﻿USE sofia;
DROP TABLE IF EXISTS sofia.uigara_vpl;
CREATE TABLE uigara_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uigara_vpl WRITE;
INSERT INTO uigara_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","مۇقەددەمدە خۇدا ئاسمانلار بىلەن زېمىننى ياراتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ئۇ چاغدا يەر بولسا شەكىلسىز ۋە قۇپقۇرۇق ھالەتتە بولدى؛ قاراڭغۇلۇق چوڭقۇر سۇلارنىڭ يۈزىنى قاپلىدى؛ خۇدانىڭ روھى چوڭقۇر سۇلار ئۈستىدە لەرزان پەرۋاز قىلاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","خۇدا: «يورۇقلۇق بولسۇن!» دېۋىدى، يورۇقلۇق پەيدا بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","خۇدا يورۇقلۇقنىڭ ياخشى ئىكەنلىكىنى كۆردى؛ خۇدا يورۇقلۇق بىلەن قاراڭغۇلۇقنى ئايرىدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","خۇدا يورۇقلۇقنى «كۈندۈز»، قاراڭغۇلۇقنى «كېچە» دەپ ئاتىدى. شۇ تەرىقىدە كەچ بىلەن سەھەر ئۆتتى، بۇ تۇنجى كۈن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ئاندىن خۇدا: ــ سۇلارنىڭ ئارىلىقىدا بىر بوشلۇق بولسۇن ۋە سۇلار يۇقىرى-تۆۋەن ئىككىگە ئايرىلىپ تۇرسۇن، دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","شۇنىڭ بىلەن خۇدا بىر بوشلۇق ھاسىل قىلىپ، سۇلارنى بوشلۇقنىڭ ئاستىغا ۋە بوشلۇقنىڭ ئۈستىگە ئايرىۋەتتى؛ ئىش ئەنە شۇنداق بولدى.    ");
INSERT INTO uigara_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","خۇدا بۇ بوشلۇقنى «ئاسمان» دەپ ئاتىدى. شۇ تەرىقىدە كەچ بىلەن سەھەر ئۆتتى، بۇ ئىككىنچى كۈن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ئاندىن خۇدا: «ئاسماننىڭ ئاستىدىكى سۇلار بىر يەرگە يىغىلسۇن، قۇرۇق تۇپراق كۆرۈنسۇن!» دېۋىدى، دەل شۇنداق بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","خۇدا قۇرۇق تۇپراقنى «يەر»، يىغىلغان سۇلارنى بولسا «دېڭىزلار» دەپ ئاتىدى. خۇدا بۇلارنىڭ ياخشى بولغانلىقىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ئاندىن خۇدا يەنە: «يەر ھەرخىل ئۆسۈملۈكلەرنى، ئۇرۇقلۇق ئوتياشلارنى، مېۋە بېرىدىغان دەرەخلەرنى تۈرلىرى بويىچە ئۆزىدە ئۈندۈرسۇن! مېۋىلەرنىڭ ئىچىدە ئۇرۇقلىرى بولسۇن!» دېۋىدى، دەل شۇنداق بولدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","يەردىكى ئۆسۈملۈكلەرنى، يەنى ئۇرۇق چىقىدىغان ئوتياشلارنى ئۆز تۈرلىرى بويىچە، مېۋە بېرىدىغان، يەنى مېۋىلىرىنىڭ ئىچىدە ئۇرۇقلىرى بولغان دەرەخلەرنى ئۆز تۈرلىرى بويىچە ئۈندۈردى. خۇدا بۇلارنىڭ ياخشى بولغانلىقىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","شۇ تەرىقىدە كەچ بىلەن سەھەر ئۆتتى، بۇ ئۈچىنچى كۈن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","خۇدا يەنە: «كۈندۈز بىلەن كېچىنى ئايرىپ بېرىش ئۈچۈن ئاسمانلاردا يورۇقلۇق جىسىملار بولسۇن. ئۇلار كۈنلەر، پەسىللار ۋە يىللارنى ئايرىپ تۇرۇشقا بەلگە بولسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ئۇلار ئاسمانلاردا تۇرۇپ نۇر چىقارغۇچى بولۇپ، يەر يۈزىگە يورۇقلۇق بەرسۇن!» دېۋىدى، دەل شۇنداق بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","خۇدا ئىككى چوڭ نۇر چىقارغۇچى جىسىمنى ياراتتى؛ چوڭ نۇر چىقارغۇچىنى كۈندۈزنى باشقۇرىدىغان، كىچىك نۇر چىقارغۇچنى كېچىنى باشقۇرىدىغان قىلدى. ھەمدە يەنە يۇلتۇزلارنىمۇ ياراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN1_17‏","002_1_17‏","GEN","1","17‏","18","خۇدا بۇلارنى يەرگە يورۇقلۇق بېرىپ، كۈندۈز بىلەن كېچىنى باشقۇرۇپ، يورۇقلۇق بىلەن قاراڭغۇلۇقنى ئايرىسۇن دەپ ئاسمانلارنىڭ گۈمبىزىگە ئورۇنلاشتۇردى. خۇدا بۇنىڭ ياخشى بولغانلىقىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","شۇ تەرىقىدە كەچ بىلەن سەھەر ئۆتتى، بۇ تۆتىنچى كۈن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","خۇدا يەنە: «سۇلاردا مىغ-مىغ جانىۋارلار بولسۇن، ئۇچار-قاناتلار يەرنىڭ ئۈستىدە، ئاسمان بوشلۇقىدا ئۇچسۇن» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","شۇنداق قىلىپ خۇدا سۇدىكى چوڭ-چوڭ مەخلۇقلارنى، شۇنداقلا سۇلاردا مىغ-مىغ جانىۋارلارنى ئۆز تۈرلىرى بويىچە ۋە ھەرخىل ئۇچار-قاناتلارنى ئۆز تۈرلىرى بويىچە ياراتتى. خۇدا بۇنىڭ ياخشى بولغانلىقىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","خۇدا بۇ جانلىقلارغا بەخت-بەرىكەت ئاتا قىلىپ: «نەسىللىنىپ، كۆپىيىپ، دېڭىز سۇلىرىنى تولدۇرۇڭلار، ئۇچار-قاناتلارمۇ يەر يۈزىدە ئاۋۇسۇن» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","شۇ تەرىقىدە كەچ بىلەن سەھەر ئۆتتى، بۇ بەشىنچى كۈن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","خۇدا يەنە: «يەر جانىۋارلارنى ئۆز تۈرلىرى بويىچە چىقارسۇن ــ مال-چارۋىلارنى، ئۆمىلىگۈچى جانىۋارلارنى ۋە ياۋايى ھايۋانلارنى ئۆز تۈرلىرى بويىچە ئاپىرىدە قىلسۇن» ــ دېۋىدى، دەل شۇنداق بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","شۇنداق قىلىپ خۇدا يەردىكى ياۋايى ھايۋانلارنى ئۆز تۈرلىرى بويىچە، مال-چارۋىلارنى ئۆز تۈرلىرى بويىچە ۋە يەر يۈزىدە ئۆمىلىگۈچى بارلىق جانىۋارلارنى ئۆز تۈرلىرى بويىچە ياراتتى. خۇدا بۇنىڭ ياخشى بولغانلىقىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ئاندىن خۇدا: «ئۆز سۈرەت-ئوبرازىمىزدا، بىزگە ئوخشايدىغان قىلىپ ئىنساننى يارىتايلى. ئۇلار دېڭىزدىكى بېلىقلارغا، ئاسماندىكى ئۇچار-قاناتلارغا، بارلىق مال-چارۋىلارغا، پۈتكۈل يەر يۈزىگە ۋە يەر يۈزىدىكى بارلىق ئۆمىلىگۈچى جانىۋارلارغا ئىگىدارچىلىق قىلسۇن» دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","شۇنداق قىلىپ، خۇدا ئىنساننى ئۆز سۈرەت-ئوبرازىدا ياراتتى؛ ئۇنى ئۆزىنىڭ سۈرىتىدە ياراتتى؛ ئۇلارنى ئەركەك-چىشى قىلىپ ياراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","خۇدا ئۇلارغا بەخت-بەرىكەت ئاتا قىلىپ: «سىلەر نەسىللىنىپ، كۆپىيىپ، يەر يۈزىنى تولدۇرۇپ بويسۇندۇرۇڭلار؛ دېڭىزدىكى بېلىقلار، ئاسماندىكى ئۇچار-قاناتلارغا، شۇنىڭدەك يەر يۈزىدە يۈرىدىغان ھەربىر ھايۋانلارغا ئىگىدارچىلىق قىلىڭلار» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ئاندىن خۇدا يەنە: «مانا، مەن پۈتكۈل يەر يۈزىدىكى ئۇرۇقلۇق ئوتياشلار بىلەن ئۇرۇقلۇق مېۋە بېرىدىغان ھەربىر دەرەخلەرنى سىلەرگە ئوزۇقلۇق بولسۇن دەپ بەردىم؛ ");
INSERT INTO uigara_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","شۇنداقلا يەردىكى بارلىق جانىۋارلار بىلەن ئاسماندىكى بارلىق ئۇچار-قاناتلار ۋە يەر يۈزىدە بارلىق ئۆمىلىگۈچىلەرگە، يەنى بارلىق جان-جانىۋارلارغا ئوزۇقلۇق بولسۇن دەپ بارلىق گۈل-گىياھلارنى بەردىم» دېۋىدى، دەل شۇنداق بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","خۇدا ياراتقانلىرىنىڭ ھەممىسىگە سەپسېلىپ قارىدى، ۋە مانا بۇلارنىڭ ھەممىسى ناھايىتى ياخشى بولغانىدى. شۇ تەرىقىدە كەچ بىلەن سەھەر ئۆتتى، بۇ ئالتىنچى كۈن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","شۇنداق قىلىپ ئاسمان بىلەن زېمىن، پۈتكۈل مەۋجۇداتلىرى بىلەن قوشۇلۇپ يارىتىلىپ بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","خۇدا يەتتىنچى كۈنىگىچە قىلىدىغان ئىشىنى تاماملىدى. ئۇ يەتتىنچى كۈنى بارلىق يارىتىش ئىشىنى توختىتىپ ئارام ئالدى.    ");
INSERT INTO uigara_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","يەتتىنچى كۈنى خۇدا بارلىق يارىتىش ئىشلىرىدىن ئارام ئالغان كۈن بولغانلىقى ئۈچۈن، شۇ كۈننى بەختلىك كۈن قىلىپ، ئۇنى «مۇقەددەس كۈن» دەپ بېكىتتى. ");
INSERT INTO uigara_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","پەرۋەردىگار خۇدا زېمىن بىلەن ئاسماننى ياراتقان كۈنىدە، ئاسمان-زېمىننىڭ يارىتىلىش جەريانىنىڭ تارىخلىرى مۇنداق: ــ ");
INSERT INTO uigara_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","زېمىندا تېخى ھېچ گۈل-گىياھ، يەردە ھېچ ئوتياش ئۈنمىگەنىدى؛ چۈنكى پەرۋەردىگار خۇدا يەر يۈزىگە ھۆل-يېغىن ياغدۇرمىغانىدى، شۇنداقلا يەر تېرىيدىغان ئادەممۇ يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","لېكىن يەردىن بۇلاق سۈيى چىقىپ، تامام يەر يۈزىنى سۇغاردى. ");
INSERT INTO uigara_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ئاندىن پەرۋەردىگار خۇدا ئادەمنى يەرنىڭ توپىسىدىن ياساپ، ئۇنىڭ بۇرنىغا  ھاياتلىق نەپەسىنى پۈۋلىدى؛ شۇنىڭ بىلەن ئادەم تىرىك بىر جان بولدى.    ");
INSERT INTO uigara_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ئاندىن كېيىن پەرۋەردىگار خۇدا مەشرىق تەرەپتە ئېرەم دېگەن جايدا بىر باغ بىنا قىلىپ، ياسىغان ئادەمنى شۇ يەرگە ئورۇنلاشتۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","پەرۋەردىگار خۇدا يەردىن كۆزنى قاملاشتۇرىدىغان چىرايلىق، مېۋىلىرى يېيىشلىك ھەرخىل دەرەخنى ئۈندۈردى؛ ئۇ يەنە باغنىڭ ئوتتۇرىسىدا «ھاياتلىق دەرىخى» ۋە «ياخشى بىلەن ياماننى بىلگۈزگۈچى دەرەخ»نى ئۈندۈردى.    ");
INSERT INTO uigara_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","باغنى سۇغىرىشقا ئېرەمدىن بىر دەريا ئېقىپ چىقتى؛ ئاندىن بۆلۈنۈپ، تۆت ئېقىن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","بىرىنچى ئېقىننىڭ نامى پىشون بولۇپ، ئالتۇن چىقىدىغان پۈتكۈل ھاۋىلاھ زېمىنىنى ئايلىنىپ ئۆتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","بۇ يۇرتنىڭ ئالتۇنى ناھايىتى ئېسىل ئىدى؛ شۇ يەردە پۇراقلىق دېۋىرقاي بىلەن ئاق ھېقىقمۇ چىقىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ئىككىنچى دەريانىڭ نامى گىھون بولۇپ، پۈتكۈل كۇش زېمىنىنى ئايلىنىپ ئۆتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ئۈچىنچى دەريانىڭ نامى دىجلە بولۇپ، ئاشۇرنىڭ شەرقىدىن ئېقىپ ئۆتىدۇ، تۆتىنچى دەريانىڭ نامى ئەفرات ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","پەرۋەردىگار خۇدا ئادەمنى ئېلىپ ئېرەم بېغىغا ئىشلەپ، پەرۋىش قىلسۇن دەپ ئۇنى شۇ يەرگە قويۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","پەرۋەردىگار خۇدا ئادەمگە ئەمر قىلىپ: باغدىكى ھەربىر دەرەخ مېۋىلىرىدىن خالىغىنىڭچە يە؛ ");
INSERT INTO uigara_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ئەمما «ياخشى بىلەن ياماننى بىلگۈزگۈچى دەرەخ»نىڭ مېۋىسىدىن يېمىگىن؛ چۈنكى ئۇنىڭدىن يېگەن كۈنۈڭدە جەزمەن ئۆلىسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ئاندىن پەرۋەردىگار خۇدا يەنە سۆز قىلىپ: ــ ئادەمنىڭ يالغۇز تۇرۇشى ياخشى ئەمەس؛ مەن ئۇنىڭغا ماس كېلىدىغان بىر ياردەمچى ھەمراھنى ياساپ بېرەي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","پەرۋەردىگار خۇدا تۇپراقتىن دالادىكى بارلىق جانىۋارلار بىلەن ئاسماندىكى ھەممە ئۇچار-قاناتلارنى ياسىغانىدى؛ ئۇلارغا ئادەمنىڭ نېمە دەپ ئات قويىدىغانلىقىنى بىلىش ئۈچۈن، ئۇ ئۇلارنى ئادەمنىڭ ئالدىغا كەلتۈردى. ئادەم ھەربىر جانىۋارغا نېمە دەپ ئات قويغان بولسا، ئۇنىڭ ئېتى شۇ بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","بۇ تەرىقىدە ئادەم ھەممە مال-چارۋىلارغا، ئاسماندىكى ئۇچار-قاناتلارغا ۋە دالادىكى ھەربىر جانىۋارلارغا ئات قويدى؛ ۋەھالەنكى، ئادەم ئۆزىگە ماس كېلىدىغان ھېچبىر ياردەمچى ھەمراھ ئۇچراتمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","شۇنىڭ بىلەن پەرۋەردىگار خۇدا ئادەمگە بىر قاتتىق ئۇيقۇ سالدى؛ ئۇ ئۇخلاپ قالدى. ئۇ ئۇخلاۋاتقاندا، ئۇ ئۇنىڭ بىقىنىدىن بىر ئاز ئېلىپ، ئاندىن ئۇنىڭ ئورنىنى ئەت-گۆش بىلەن ئېتىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","شۇنىڭ بىلەن پەرۋەردىگار خۇدا ئادەمنىڭ بىقىنىدىن ئالغان شۇ قىسىمدىن بىر ئايالنى ياساپ، ئۇنى ئادەمنىڭ قېشىغا ئەكەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ئادەمئاتا خۇشال بولۇپ: ــ مانا بۇ سۆڭەكلىرىمدىكى سۆڭەك، ئېتىمدىكى ئەت بولغاچ، «ئايال» دەپ ئاتالسۇن؛ چۈنكى ئۇ ئەردىن ئېلىنغاندۇر، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","شۇنىڭ ئۈچۈن ئەر كىشى ئاتا-ئانىسىدىن ئايرىلىپ، ئۆز ئايالىغا باغلىنىپ بىر بولۇپ، ئىككىسى بىر تەن بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ئادەمئاتا بىلەن ئايالى ھەر ئىككىسى يالىڭاچ بولسىمۇ، ھېچ ئۇيالمايتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","يەر يۈزىدە يىلان رەب پەرۋەردىگار ياراتقان دالادىكى ھايۋانلارنىڭ ھەممىسىدىن ھىيلىگەر ئىدى. ئۇ ئايالدىن: ــ خۇدا راستتىنلا باغدىكى دەرەخلەرنىڭ ھېچقايسىسىنىڭ مېۋىسىدىن يېمەڭلار، دېدىمۇ؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ئايال يىلانغا جاۋاب بېرىپ: ــ باغدىكى دەرەخلەرنىڭ مېۋىلىرىنى يېسەك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ئەمما باغنىڭ ئوتتۇرىسىدىكى دەرەخنىڭ مېۋىسى توغرىسىدا خۇدا: «بۇنىڭدىن يېمەڭلار، قولمۇ تەگكۈزمەڭلار، بولمىسا ئۆلىسىلەر» دېگەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","يىلان ئايالغا: ــ ئۇنداق ئەمەس! ھەرگىز ئۆلمەيسىلەر! ");
INSERT INTO uigara_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بەلكى سىلەر ئۇنى يېگەن كۈنۈڭلاردا، خۇدا كۆزۈڭلارنىڭ ئېچىلىپ، خۇداغا ئوخشاش ياخشى بىلەن ياماننى بىلىدىغان بولۇپ قالىدىغانلىقىڭلارنى بىلىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ئايال دەرەخنىڭ مېۋىسىنىڭ يېمەكلىك ئۈچۈن ياخشىلىقىنى، ئۇنىڭ كۆزنى قاملاشتۇرىدىغانلىقىنى كۆرۈپ، ھەمدە دەرەخنىڭ ئادەمنى ئەقىللىق قىلىدىغان جەلپكارلىقىنى كۆرۈپ، مېۋىدىن يېدى ۋە ئۇنىڭدىن يېنىدا تۇرغان ئېرىگىمۇ بەردى؛ ئۇمۇ يېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","يېيىشى بىلەنلا ھەر ئىككىسىنىڭ كۆزلىرى ئېچىلىپ، ئۆزلىرىنىڭ يالىڭاچ ئىكەنلىكىنى بىلىپ، ئەنجۈر يوپۇرماقلىرىنى ئېلىپ بىر-بىرىگە ئۇلاپ تىكىپ، ئۆزلىرىگە ياپقۇچ قىلىپ تارتتى. ");
INSERT INTO uigara_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","كۈن سالقىنلىغاندا، ئۇلار پەرۋەردىگار خۇدانىڭ باغدا ماڭغان شەپىسىنى ئاڭلاپ قېلىپ، ئادەم ئايالى بىلەن پەرۋەردىگار خۇدانىڭ ھازىر بولغىنىدىن قېچىپ باغدىكى دەرەخلەرنىڭ ئارىسىغا يوشۇرۇنۇۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","لېكىن پەرۋەردىگار خۇدا توۋلاپ ئادەمنى چاقىرىپ ئۇنىڭغا: سەن نەدە؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ئادەمئاتا جاۋاب بېرىپ: ــ مەن باغدا شەپەڭنى ئاڭلاپ، يالىڭاچ تۇرغىنىم ئۈچۈن قورقۇپ كېتىپ، يوشۇرۇنۇۋالدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","خۇدا ئۇنىڭغا: ــ يالىڭاچ ئىكەنلىكىڭنى ساڭا كىم ئېيتتى؟ مەن ساڭا يېمە، دەپ ئەمر قىلغان دەرەخنىڭ مېۋىسىدىن يېدىڭمۇ-يا؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ئادەم جاۋاب بېرىپ: ــ سەن ماڭا ھەمراھ بولۇشقا بەرگەن ئايال دەرەخنىڭ مېۋىسىدىن ماڭا بەرگەنىدى، مەن يېدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","پەرۋەردىگار خۇدا ئايالغا: ــ بۇ نېمە قىلغىنىڭ؟ ــ دېدى. ئايال جاۋاب بېرىپ: ــ يىلان مېنى ئالداپ ئازدۇرسا، مەن يەپ ساپتىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","پەرۋەردىگار خۇدا يىلانغا مۇنداق دېدى: ــ «بۇ قىلغىنىڭ ئۈچۈن، سەن ھەممە مال-چارۋىلاردىن، دالادىكى بارلىق ھايۋاناتلاردىن بەكرەك لەنەتكە قالىسەن؛ قورسىقىڭ بىلەن بېغىرلاپ مېڭىپ، ئۆمرۈڭنىڭ بارلىق كۈنلىرىدە توپا يەيسەن. ");
INSERT INTO uigara_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ۋە مەن سەن بىلەن ئايالنىڭ ئارىسىغا، سېنىڭ نەسلىڭ بىلەن ئايالنىڭ نەسلىنىڭ ئارىسىغا ئۆچمەنلىك سالىمەن؛ ئۇ سېنىڭ بېشىڭنى دەسسەپ زەخىملەندۈرىدۇ، سەن قوپۇپ ئۇنىڭ تاپىنىنى چېقىپ زەخىملەندۈرىسەن».    ");
INSERT INTO uigara_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ئاندىن خۇدا ئايالغا: ــ «سېنىڭ ھامىلىدارلىقىڭنىڭ جاپا-مۇشەققەتلىرىنى كۆپەيتىمەن؛ سەن قاتتىق تولغاق ئىچىدە بوشىنىسەن؛ سەن ئېرىڭدىن ئۈستۈن تۇرۇشقا ھەۋەس قىلساڭمۇ، ئۇ ئۈستۈڭدىن خوجىلىق قىلىدۇ» ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ئاندىن ئۇ ئادەمئاتىغا: ــ «سەن ئايالىڭنىڭ سۆزىگە قۇلاق سېلىپ، مەن ساڭا يېمە، دەپ ئەمر قىلغان دەرەختىن يېگىنىڭ تۈپەيلىدىن، سېنىڭ تۈپەيلىڭدىن يەر-تۇپراق لەنىتىمگە ئۇچرايدۇ؛ ئۆمرۈڭنىڭ بارلىق كۈنلىرىدە پەقەت جاپالىق ئىشلەپلا، ئاندىن ئۇنىڭدىن ئوزۇقلىنىسەن. ");
INSERT INTO uigara_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","يەر ساڭا تىكەن بىلەن قامغاق ئۈندۈرىدۇ؛ شۇنداقتىمۇ سەن يەردىكى زىرائەت-ئوتياشلارنى يەيسەن. ");
INSERT INTO uigara_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","تاكى سەن تۇپراققا قايتقۇچە يۈز-كۆزۈڭ تەرگە چۈمگەندە، ئاندىن نان يېيەلەيسەن؛ چۈنكى سەن ئەسلى تۇپراقتىن ئېلىنغانسەن؛ سەن ئەسلىدە توپا بولغاچ، يەنە توپىغا قايتىسەن» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ئۇنىڭ ئايالى بارلىق جان ئىگىلىرىنىڭ ئانىسى بولىدىغىنى ئۈچۈن ئادەم ئۇنىڭغا «ھاۋا» دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","پەرۋەردىگار خۇدا ئادەمئاتا بىلەن ئۇنىڭ ئايالىغا ھايۋان تېرىلىرىدىن كىيىم قىلىپ كىيدۈرۈپ قويدى.    ");
INSERT INTO uigara_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","پەرۋەردىگار خۇدا سۆز قىلىپ: ــ مانا، ئادەم بىزلەردىن بىرىگە ئوخشاپ قالدى، ياخشى بىلەن ياماننى بىلدى. ئەمدى قولىنى ئۇزىتىپ ھاياتلىق دەرىخىدىن ئېلىپ يەۋېلىپ، تا ئەبەدگىچە ياشاۋەرمەسلىكى ئۈچۈن ئۇنى توسۇشىمىز كېرەك، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","شۇنىڭ بىلەن پەرۋەردىگار خۇدا ئۇنى ئېرەم باغدىن قوغلاپ چىقىرىۋەتتى؛ شۇنداق قىلىپ ئۇنى يەرگە ئىشلەيدىغان، يەنى ئۆزى ئەسلى ئاپىرىدە قىلىنغان تۇپراققا ئىشلەيدىغان قىلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ئادەمنى قوغلىۋېتىپ، ھاياتلىق دەرىخىگە بارىدىغان يولنى مۇھاپىزەت قىلىش ئۈچۈن، ئۇ ئېرەم بېغىنىڭ مەشرىق تەرىپىگە كېرۇبلارنى ۋە تۆت تەرەپكە پىرقىرايدىغان يالقۇنلۇق بىر شەمشەرنى قويۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ئادەمئاتا ئايالى ھاۋا بىلەن بىللە بولدى؛ ھاۋا ھامىلىدار بولۇپ قابىلنى تۇغۇپ: «مەن بىر ئادەمگە ئىگە بولدۇم ــ ئۇ پەرۋەردىگاردۇر!» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ئاندىن ئۇ يەنە قابىلنىڭ ئىنىسى ھابىلنى تۇغدى. ھابىل پادىچى بولدى، قابىل بولسا تېرىقچى بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","بېكىتىلگەن شۇنداق بىر ۋاقىت-سائەتتە شۇنداق بىر ئىش بولدىكى، قابىل تۇپراقنىڭ ھوسۇلىدىن پەرۋەردىگارغا ھەدىيە كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ھابىلمۇ پادىسىدىن قويلىرىنىڭ تۇنجىلىرىدىن، يەنى ئۇلارنىڭ يېغىدىن ھەدىيە سۇندى. پەرۋەردىگار ھابىلنى ۋە ئۇنىڭ سۇنغان ھەدىيەسىنى قوبۇل قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","لېكىن قابىل ۋە ئۇنىڭ سۇنغىنىغا قارىمىدى. شۇ ۋەجىدىن قابىلنىڭ تولىمۇ ئاچچىقى كېلىپ، چىرايى تۇتۇلدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","شۇنىڭ بىلەن پەرۋەردىگار قابىلغا: نېمىشقا ئاچچىقلىنىسەن؟ نېمە ئۈچۈن چىرايىڭ تۇتۇلۇپ كېتىدۇ؟ ");
INSERT INTO uigara_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ئەگەر دۇرۇس ئىش قىلساڭ، سەن كۆتۈرۈلمەمسەن؟ لېكىن دۇرۇس ئىش قىلمىساڭ، مانا گۇناھ ئىشىك ئالدىدا سېنى پايلاپ بېغىرلاپ ياتىدۇ، ئۇ سېنى ئۆز ئىلكىگە ئالماقچى بولىدۇ؛ لېكىن سەن ئۇنىڭدىن غالىپ كېلىشىڭ كېرەك، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","قابىل ئىنىسى ھابىلغا: «دالىغا چىقىپ كېلەيلى!» دېدى. دالادا شۇ ۋەقە بولدىكى، قابىل ئىنىسى ھابىلغا قول سېلىپ، ئۇنى ئۆلتۈردى.    ");
INSERT INTO uigara_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","پەرۋەردىگار قابىلغا: ئىنىڭ ھابىل نەدە؟ ــ دەپ سورىدى. ئۇ جاۋاب بېرىپ: بىلمەيمەن، مەن ئىنىمنىڭ باققۇچىسىمۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","خۇدا ئۇنىڭغا: ــ سەن نېمە قىلدىڭ؟ مانا، ئىنىڭنىڭ قېنى يەردىن ماڭا پەرياد كۆتۈرۈۋاتىدۇ! ");
INSERT INTO uigara_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ئەمدى ئىنىڭنىڭ قولۇڭدا تۆكۈلگەن قېنىنى قوبۇل قىلىشقا ئاغزىنى ئاچقان يەردىن قوغلىنىپ، لەنەتكە ئۇچرايسەن. ");
INSERT INTO uigara_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","سەن يەرگە ئىشلىسەڭمۇ ئۇ بۇنىڭدىن كېيىن ساڭا قۇۋۋىتىنى بەرمەيدۇ؛ سەن يەر يۈزىدە سەرسان بولۇپ، سەرگەردان بولىسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","بۇنى ئاڭلاپ قابىل پەرۋەردىگارغا جاۋاب قىلىپ: ــ مېنىڭ بۇ جازايىمنى ئادەم كۆتۈرەلمىگۈدەك! ");
INSERT INTO uigara_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","مانا، سەن بۈگۈن مېنى يەر يۈزىدىن قوغلىدىڭ، مەن ئەمدى سېنىڭ يۈزۈڭدىن يوشۇرۇنۇپ يۈرىمەن؛ يەر يۈزىدە سەرسەن بولۇپ سەرگەردانلىقتا يۈرىمەن؛ شۇنداق بولىدۇكى، كىملا مېنى تېپىۋالسا، ئۆلتۈرۈۋېتىدۇ!، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","لېكىن پەرۋەردىگار ئۇنىڭغا جاۋاب بېرىپ: ــ شۇنداق بولىدۇكى، كىمكى قابىلنى ئۆلتۈرسە، ئۇنىڭدىن يەتتە ھەسسە ئىنتىقام ئېلىنىدۇ، ــ دېدى. شۇلارنى دەپ پەرۋەردىگار قابىلغا ئۇچرىغان بىرسى ئۇنى ئۆلتۈرۈۋەتمىسۇن دەپ ئۇنىڭغا بىر بەلگە قويۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","شۇنىڭ بىلەن قابىل پەرۋەردىگارنىڭ ھۇزۇرىدىن چىقىپ، ئېرەمنىڭ مەشرىق تەرىپىدىكى نود دېگەن يۇرتتا ئولتۇراقلىشىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","قابىل ئايالى بىلەن بىللە بولۇپ، ئايالى ھامىلىدار بولۇپ ھانوخنى تۇغدى. ئۇ ۋاقىتتا قابىل بىر شەھەر بىنا قىلىۋاتاتتى؛ ئۇ شەھەرنىڭ نامىنى ئوغلىنىڭ ئىسمى بىلەن ھانوخ دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ھانوختىن ئىراد تۆرەلدى، ئىرادتىن مەھۇيائىل تۆرەلدى، مەھۇيائىلدىن مەتۇشائىل تۆرەلدى، مەتۇشائىلدىن لەمەخ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","لەمەخ ئۆزىگە ئىككى خوتۇن ئالدى. بىرىنىڭ ئىسمى ئاداھ، يەنە بىرىنىڭ ئىسمى زىللاھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ئاداھ يابالنى تۇغدى. ئۇ چېدىردا ئولتۇرىدىغان كۆچمەن مالچىلارنىڭ بوۋىسى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ئۇنىڭ ئىنىسىنىڭ ئىسمى يۇبال ئىدى. بۇ چىلتار بىلەن نەي چالغۇچىلارنىڭ بوۋىسى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","زىللاھ يەنە تۇبال-قايىن دېگەن بىر ئوغۇلنى تۇغدى. ئۇ مىس-تۆمۈر ئەسۋابلارنى سوققۇچى ئىدى. تۇبال-قايىننىڭ نائاماھ ئىسىملىك بىر سىڭلىسى بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","لەمەخ بولسا ئاياللىرىغا سۆز قىلىپ: ــ «ئەي ئاداھ بىلەن زىللاھ، سۆزۈمنى ئاڭلاڭلار! ئەي لەمەخنىڭ ئاياللىرى، گېپىمگە قۇلاق سېلىڭلار! مېنى زەخىملەندۈرگىنى ئۈچۈن مەن ئادەم ئۆلتۈردۈم، تېنىمنى زېدە قىلغانلىقى ئۈچۈن بىر يىگىتنى ئۆلتۈردۈم. ");
INSERT INTO uigara_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ئەگەر قابىل ئۈچۈن يەتتە ھەسسە ئىنتىقام ئېلىنسا، لەمەخ ئۈچۈن يەتمىش يەتتە ھەسسە ئىنتىقام ئېلىنىدۇ!» ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ئادەمئاتا يەنە ئايالى بىلەن بىللە بولدى. ئايالى بىر ئوغۇل تۇغۇپ، ئۇنىڭغا شېت دەپ ئات قويۇپ: قابىل ھابىلنى ئۆلتۈرۈۋەتكىنى ئۈچۈن خۇدا ئۇنىڭ ئورنىغا ماڭا باشقا بىر ئەۋلاد تىكلەپ بەردى، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","شېتتىنمۇ بىر ئوغۇل تۇغۇلدى؛ ئۇ ئۇنىڭغا ئېنوش دەپ ئات قويدى. شۇ ۋاقىتتىن تارتىپ ئادەملەر پەرۋەردىگارنىڭ نامىغا نىدا قىلىشقا باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","بۇ ئادەمئاتىنىڭ ئەۋلادلىرىنىڭ نەسەبنامىسىدۇر: ــ خۇدا ئىنساننى ياراتقان كۈنىدە، ئۇنى ئۆزىگە ئوخشاش قىلىپ ياراتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ئۇ ئۇلارنى ئەر جىنىس ۋە ئايال جىنىس قىلىپ يارىتىپ، ئۇلارغا بەخت-بەرىكەت ئاتا قىلىپ، يارىتىلغان كۈنىدە ئۇلارنىڭ نامىنى «ئادەم» دەپ ئاتىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ئادەمئاتا بىر يۈز ئوتتۇز ياشقا كىرگەندە ئۇنىڭدىن ئۆزىگە ئوخشايدىغان، ئۆز سۈرەت-ئوبرازىدەك بىر ئوغۇل تۆرەلدى؛ ئۇ ئۇنىڭغا شېت دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","شېت تۇغۇلغاندىن كېيىن ئادەمئاتا سەككىز يۈز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ئادەمئاتىمىز جەمئىي توققۇز يۈز ئوتتۇز يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","شېت بىر يۈز بەش ياشقا كىرگەندە ئۇنىڭدىن ئېنوش تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ئېنوش تۇغۇلغاندىن كېيىن شېت سەككىز يۈز يەتتە يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","شېت جەمئىي توققۇز يۈز ئون ئىككى يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ئېنوش توقسان ياشقا كىرگەندە ئۇنىڭدىن كېنان تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","كېنان تۇغۇلغاندىن كېيىن، ئېنوش سەككىز يۈر ئون بەش يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ئېنوش جەمئىي توققۇز يۈز بەش يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","كېنان يەتمىش ياشقا كىرگەندە ئۇنىڭدىن ماھالالېل تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ماھالالېل تۇغۇلغاندىن كېيىن كېنان سەككىز يۈز قىرىق يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","كېنان جەمئىي توققۇز يۈز ئون يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ماھالالېل ئاتمىش بەش ياشقا كىرگەندە ئۇنىڭدىن يارەد تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","يارەد تۇغۇلغاندىن كېيىن ماھالالېل سەككىز يۈز ئوتتۇز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ماھالالېل جەمئىي سەككىز يۈز توقسان بەش يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","يارەد بىر يۈز ئاتمىش ئىككى ياشقا كىرگەندە ئۇنىڭدىن ھانوخ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ھانوخ تۇغۇلغاندىن كېيىن يارەد سەككىز يۈز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","يارەد جەمئىي توققۇز يۈز ئاتمىش ئىككى يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ھانوخ ئاتمىش بەش ياشقا كىرگەندە ئۇنىڭدىن مەتۇشەلاھ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","مەتۇشەلاھ تۇغۇلغاندىن كېيىن ھانوخ ئۈچ يۈز يىلغىچە خۇدا بىلەن بىر يولدا مېڭىپ، يەنە ئوغۇل-قىزلارنى تاپتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ھانوخنىڭ يەر يۈزىدە بارلىق كۆرگەن كۈنلىرى ئۈچ يۈز ئاتمىش بەش يىل بولدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ئۇ خۇدا بىلەن بىر يولدا مېڭىپ ياشايتتى؛ ئۇ تۇيۇقسىز كۆزدىن غايىب بولدى؛ چۈنكى خۇدا ئۇنى ئۆز يېنىغا ئېلىپ كەتكەنىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","مەتۇشەلاھ بىر يۈز سەكسەن يەتتە ياشقا كىرگەندە ئۇنىڭدىن لەمەخ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","لەمەخ تۇغۇلغاندىن كېيىن مەتۇشەلاھ يەتتە يۈز سەكسەن ئىككى يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","مەتۇشەلاھ جەمئىي توققۇز يۈز ئاتمىش توققۇز يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_28‏","002_5_28‏","GEN","5","28‏","29","لەمەخ بىر يۈز سەكسەن ئىككى ياشقا كىرگەندە بىر ئوغۇل تېپىپ، ئۇنىڭ ئىسمىنى نۇھ ئاتاپ: ــ پەرۋەردىگار تۇپراققا لەنەت قىلدى؛ شۇڭا بىز يەرگە ئىشلىگىنىمىزدە ھەمدە قوللىرىمىزنىڭ جاپالىق ئەمگىكىدە بۇ بالا بىزگە تەسەللى بېرىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","نۇھ تۇغۇلغاندىن كېيىن لەمەخ بەش يۈز توقسان بەش يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","لەمەخ جەمئىي يەتتە يۈز يەتمىش يەتتە يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","نۇھ بەش يۈز ياشقا كىرگەندىن كېيىن، ئۇنىڭدىن شەم، ھام ۋە يافەت تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ۋە شۇنداق بولدىكى، ئىنسانلار يەر يۈزىدە كۆپىيىشكە باشلىغاندا، شۇنداقلا قىزلارمۇ كۆپلەپ تۇغۇلغاندا، ");
INSERT INTO uigara_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","خۇدانىڭ ئوغۇللىرى ئىنسانلارنىڭ قىزلىرىنىڭ چىرايلىقلىقىنى كۆرۈپ، خالىغانچە تاللاپ، ئۆزلىرىگە خوتۇن قىلىشقا باشلىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ئۇ ۋاقىتتا پەرۋەردىگار سۆز قىلىپ: ــ ــ مېنىڭ روھىم ئىنسانلار بىلەن مەڭگۈ كۈرەش قىلىۋەرمەيدۇ؛ چۈنكى ئىنسان ئەتتۇر، خالاس. كەلگۈسىدە ئۇلارنىڭ ئۆمرى پەقەت بىر يۈز يىگىرمە ياشتىن ئاشمىسۇن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","شۇ كۈنلەردە (ۋە شۇنداقلا كېيىنكى كۈنلەردىمۇ)، خۇدانىڭ ئوغۇللىرى ئىنسانلارنىڭ قىزلىرىنىڭ يېنىغا بېرىپ، ئۇلاردىن بالىلارنى تاپقىنىدا، گىگانتلار يەر يۈزىدە پەيدا بولدى. بۇلار بولسا قەدىمكى زامانلاردىكى داڭلىق پالۋان-باتۇرلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","پەرۋەردىگار ئىنساننىڭ ئۆتكۈزۈۋاتقان رەزىللىكى يەر يۈزىدە كۆپىيىپ كەتكەنلىكىنى، ئۇلارنىڭ كۆڭلىدىكى نىيەتلىرىنىڭ ھەرقاچان يامان بولۇۋاتقىنىنى كۆردى.    ");
INSERT INTO uigara_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","شۇنىڭ بىلەن پەرۋەردىگار يەر يۈزىدە ئادەمنى ئاپىرىدە قىلغىنىغا پۇشايمان قىلىپ، كۆڭلىدە ئازابلاندى. ");
INSERT INTO uigara_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","بۇنىڭ بىلەن پەرۋەردىگار: ــ ئۆزۈم ياراتقان ئىنساننى يەر يۈزىدىن يوقىتىمەن ــ ئىنساندىن تارتىپ مال-چارۋىلارغىچە، ئۆمىلىگۈچى ھايۋانلاردىن ئاسماندىكى قۇشلارغىچە، ھەممىسىنى يوق قىلىمەن؛ چۈنكى مەن ئۇلارنى ياراتقىنىمغا پۇشايمەن قىلدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","لېكىن نۇھ بولسا پەرۋەردىگارنىڭ نەزىرىدە شەپقەت تاپقانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","نۇھ ۋە ئۇنىڭ ئىش-ئىزلىرى تۆۋەندىكىچە: ــ نۇھ ھەققانىي، ئۆز دەۋرىدىكىلەر ئارىسىدا ئەيىبسىز ئادەم ئىدى؛ نۇھ خۇدا بىلەن بىر يولدا مېڭىپ ياشايتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","نۇھتىن شەم، ھام، يافەت دېگەن ئۈچ ئوغۇل تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","پۈتكۈل جاھان خۇدانىڭ ئالدىدا رەزىللىشىپ، ھەممە يەر زوراۋانلىققا تولۇپ كەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","خۇدا يەر يۈزىگە نەزەر سېلىۋىدى، مانا، جاھان رەزىللەشكەنىدى؛ چۈنكى بارلىق ئەت ئىگىلىرىنىڭ يەر يۈزىدە قىلىۋاتقىنى يۇزۇقچىلىق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","شۇنىڭ بىلەن خۇدا نۇھقا: ــ مانا، ئالدىمغا بارلىق ئەت ئىگىلىرىنىڭ زاۋاللىقى يېتىپ كەلدى؛ چۈنكى پۈتكۈل يەر-جاھاننى ئۇلارنىڭ سەۋەبىدىن زوراۋانلىق قاپلىدى. مانا، مەن ئۇلارنى يەر بىلەن قوشۇپ ھالاك قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ئەمدى سەن ئۆزۈڭگە گوفەر ياغىچىدىن بىر كېمە ياساپ، كېمىنىڭ ئىچىدە بۆلمە-خانىلارنى قىلىپ، ئىچى-تېشىنى قارىماي بىلەن سۇۋا. ");
INSERT INTO uigara_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","سەن ئۇنى شۇنداق ياسىغىن: ــ ئۇزۇنلۇقى ئۈچ يۈز گەز، كەڭلىكى ئەللىك گەز ۋە ئېگىزلىكى ئوتتۇز گەز بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","كېمىنىڭ پېشايۋىنى ئاستىغا بىر ئوچۇقچىلىق ياسا، ئۇنىڭ ئېگىزلىكى بىر گەز بولسۇن؛ ئىشىكىنى كېمىنىڭ يېنىغا ئورۇنلاشتۇر؛ كېمىنى ئاستى، ئوتتۇرا ۋە ئۈستى قىلىپ ئۈچ قەۋەت ياسا. ");
INSERT INTO uigara_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","چۈنكى مانا، مەن ئۆزۈم ئاسماننىڭ ئاستىدىكى ھاياتلىق تىنىقى بارلىكى ھەربىر ئەت ئىگىسىنى ھالاك قىلىدىغان سۇ توپاننى يەر يۈزىگە كەلتۈرىمەن؛ بۇنىڭ بىلەن يەر يۈزىدىكى بارلىق مەخلۇقلار تىنىقىدىن توختايدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","لېكىن سەن بىلەن ئەھدەمنى تۈزىمەن. سەن ئۆزۈڭ، ئوغۇللىرىڭ، ئايالىڭ ۋە كېلىنلىرىڭنى ئېلىپ بىرلىكتە كېمىگە كىرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ئۆزۈڭ بىلەن تەڭ تىرىك ساقلاپ قېلىش ئۈچۈن، بارلىق جاندارلاردىن ھەرقايسىسىدىن بىر جۈپ، يەنى ئەركىكىدىن بىرىنى، چىشىدىن بىرىنى كېمىگە ئېلىپ كىرگىن؛ ");
INSERT INTO uigara_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","تىرىك قېلىش ئۈچۈن قۇشلارنىڭ ھەربىر تۈرلىرىدىن، مال-چارۋىلارنىڭ ھەربىر تۈرلىرىدىن ۋە يەردە ئۆمىلىگۈچى جانىۋارلارنىڭ ھەربىر تۈرلىرىدىن بىر جۈپى قېشىڭغا كىرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ئۆزۈڭ ۋە ئۇلارنىڭ ئوزۇقلۇقى ئۈچۈن ھەرخىل يېمەكلىكلەردىن ئېلىپ، يېنىڭغا غەملىگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","نۇھ شۇنداق قىلدى؛ خۇدا ئۆزىگە بۇيرۇغان ھەممە ئىشنى ئۇ بەجا كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","پەرۋەردىگار نۇھقا مۇنداق دېدى: ــ «سەن پۈتۈن ئۆيدىكىلىرىڭ بىلەن كېمىگە كىرگىن؛ چۈنكى بۇ دەۋردە ئالدىمدا سېنى ھەققانىي دەپ كۆردۈم. ");
INSERT INTO uigara_vpl VALUES ("GN7_2‏","002_7_2‏","GEN","7","2‏","3","ھەممە ھالال ھايۋانلارنىڭ ئەركەك-چىشىسىدىن يەتتە جۈپتىن، ھارام ھايۋانلارنىڭ ئەركەك-چىشىسىدىن بىر جۈپتىن ئېلىپ، شۇنىڭدەك ئاسماندىكى ئۇچار-قاناتلارنىڭمۇ ئەركەك-چىشىسىدىن يەتتە جۈپتىن ئېلىپ، ئۇلارنىڭ نەسلىنى پۈتكۈل يەر يۈزىدە تىرىك ساقلاش ئۈچۈن ئۆزۈڭ بىلەن بىللە ئەكىر.    ");
INSERT INTO uigara_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","چۈنكى يەتتە كۈندىن كېيىن ئۇدا قىرىق كېچە-كۈندۈز يەر يۈزىگە يامغۇر ياغدۇرىمەن؛ ئۆزۈم ياسىغان ھەممە جانىۋارلارنى يەر يۈزىدىن يوقىتىمەن». ");
INSERT INTO uigara_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","شۇنىڭ بىلەن نۇھ پەرۋەردىگار ئۇنىڭغا بۇيرۇغىنىنىڭ ھەممىسىگە ئەمەل قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","يەر يۈزىنى توپان باسقاندا نۇھ ئالتە يۈز ياشتا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","توپاندىن قۇتۇلۇپ قېلىش ئۈچۈن نۇھ بىلەن ئوغۇللىرى، ئايالى ۋە كېلىنلىرى بىللە كېمىگە كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN7_8‏","002_7_8‏","GEN","7","8‏","9","ھالال ھايۋانلار بولسۇن، ھارام ھايۋانلار بولسۇن، قۇشلار بىلەن يەردە ئۆمىلىگۈچى جانىۋارلار بولسۇن، ھەربىر تۈردىن بىر جۈپ-بىر جۈپتىن ئەركەك-چىشى بولۇپ، خۇدا نۇھقا بۇيرۇغاندەك كېمىگە، نۇھنىڭ قېشىغا كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ۋە شۇنداق بولدىكى، يەتتە كۈندىن كېيىن، يەر يۈزىنى توپان بېسىشقا باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","نۇھنىڭ ئۆمرىنىڭ ئالتە يۈزىنچى يىلى، ئىككىنچى ئېيىنىڭ ئون يەتتىنچى كۈنىدە چوڭقۇر دېڭىزلارنىڭ تەگلىرىدىكى بارلىق بۇلاقلار يېرىلىپ، ئاسماننىڭ پەنجىرىلىرى ئېچىلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","يامغۇر ئۇدا قىرىق كېچە-كۈندۈز يەر يۈزىگە توختىماي ياغدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","دەل يامغۇر باشلانغان كۈنى، نۇھ، نۇھنىڭ شەم، ھام، يافەت دېگەن ئوغۇللىرى، نۇھنىڭ ئايالى بىلەن ئۈچ كېلىنى كېمىگە كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ئۇلار بىلەن بىللە ھەرخىل ياۋا ھايۋانلار تۈر-تۈرى بويىچە، ھەرخىل مال-چارۋىلار تۈر-تۈرى بويىچە، يەردە ئۆمىلىگۈچى ھەرخىل جانىۋارلار تۈر-تۈرى بويىچە ۋە ھەرخىل ئۇچار-قاناتلار، يەنى ھەرخىل قاناتلىق جانىۋارلار تۈر-تۈرى بويىچە كېمىگە كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ئەت ئىگىلىرىدىن، يەنى بارلىق ھاياتلىق تىنىقى بولغان ھەرخىل جاندارلاردىن، بىر جۈپ-بىر جۈپ بولۇپ، كېمىگە نۇھنىڭ قېشىغا كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","كىرگەنلەر خۇدانىڭ نۇھقا بۇيرۇغىنىدەك ئەت ئىگىلىرىنىڭ ھەرتۈرىنىڭ ئەركەك-چىشىسى ئىدى. ئاندىن پەرۋەردىگار ئىشىكنى ئېتىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","توپان يەر يۈزىنى ئۇدا قىرىق كۈن بېسىپ، سۇلار ئۇلغىيىپ كەتتى. كېمە يەر ئۈستىدىن كۆتۈرۈلۈپ لەيلەپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","سۇ ئۇلغىيىپ، يەر ئۈستىدە تېخىمۇ ئېگىزلەپ كەتتى؛ كېمە سۇ ئۈستىدە داۋالغۇپ تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","سۇلار يەر يۈزىدە تولىمۇ ئۇلغىيىپ، پۈتكۈل ئاسماننىڭ ئاستىدىكى بارلىق ئېگىز تاغلارنىمۇ بېسىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","سۇلار تاغلاردىن يەنە ئون بەش گەز ئۆرلەپ، تاغ چوققىلىرىمۇ سۇ ئاستىدا قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","بۇنىڭ بىلەن يەر يۈزىدە يۈرگۈچى ھەممە ئەت ئىگىلىرى، ئۇچار-قۇشلار، مال-چارۋىلار، ياۋايى ھايۋانلار، يەردە ئۆمىلىگۈچى ھەممە جانىۋارلار، جۈملىدىن پۈتكۈل ئادەملەر ھەممىسى ئۆلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","قۇرۇقلۇقتا ياشىغۇچى، بۇرنىدا ھاياتلىق تىنىقى بار بولغانلارنىڭ ھەممىسى ئۆلدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","يەر يۈزىدىكى جېنى بارلارنىڭ ھەممىسى، ئىنسان بولسۇن، مال-چارۋىلار بولسۇن، ئۆمىلىگۈچى ھايۋانلار بولسۇن، ئاسماندىكى قۇشلار بولسۇن، ھەممىسى ھالاك بولۇپ يەر يۈزىدىن يوق قىلىندى؛ پەقەت نۇھ ۋە كېمىدە ئۇنىڭ بىلەن بىللە تۇرغانلار قۇتۇلۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","بىر يۈز ئەللىك كۈنگىچە يەر يۈزىنى سۇ بېسىپ تۇردى.    ");
INSERT INTO uigara_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","خۇدا نۇھنى، شۇنداقلا كېمىدە ئۇنىڭ بىلەن بىللە بولغان بارلىق ياۋايى ھايۋانلار بىلەن بارلىق مال-چارۋىلارنى ئەسلىدى. شۇنىڭ بىلەن خۇدا بىر شامال چىقىرىپ يەر يۈزىنى يەلپۈتتى ۋە سۇلار يېنىشقا باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","چوڭقۇر دېڭىزلارنىڭ تەگلىرىدىكى بۇلاقلار ۋە ئاسماننىڭ پەنجىرىلىرى ئېتىلىپ، ئاسماندىن تۆكۈلگەن يامغۇر توختىدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","سۇلار بارغانسېرى يەر يۈزىدىن ياندى؛ بىر يۈز ئەللىك كۈن ئۆتكەندىن كېيىن خېلى ئازلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","يەتتىنچى ئاينىڭ ئون يەتتىنچى كۈنى، كېمە ئارارات تاغ تىزمىلىرىدىكى بىرىنىڭ ئۈستىدە توختاپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","سۇلار ئونىنچى ئايغىچە بارغانسېرى ئازىيىپ، ئونىنچى ئاينىڭ بىرىنچى كۈنى تاغ چوققىلىرى كۆرۈنۈشكە باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","قىرىق كۈندىن كېيىن نۇھ كېمىگە ئۆزى ئورناتقان دەرىزىنى ئېچىپ، ");
INSERT INTO uigara_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","بىر قۇزغۇننى سىرتقا چىقاردى. ئۇ يەر يۈزىدىكى سۇلار تارتىلىپ بولغۇچە ئۇيان-بۇيان ئۇچۇپ يۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ئۇنىڭدىن كېيىن نۇھ سۇلارنىڭ يەر يۈزىدىن تارتىلغان-تارتىلمىغانلىقىنى بىلىش ئۈچۈن، بىر كەپتەرنى چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","لېكىن سۇلار تېخىچە پۈتكۈل يەر يۈزىنى قاپلاپ تۇرغاچقا، كەپتەر پۇتىنى قويغۇدەك جاي تاپالماي، نۇھنىڭ قېشىغا كېمىگە يېنىپ كەلدى. شۇنىڭ بىلەن نۇھ قولىنى سۇنۇپ ئۇنى تۇتۇپ، كېمىگە ئەكىرىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ئۇ يەتتە كۈن ساقلاپ، بۇ كەپتەرنى كېمىدىن يەنە سىرتقا چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","كەپتەر كەچتە ئۇنىڭ قېشىغا يېنىپ كەلدى؛ مانا، ئۇنىڭ تۇمشۇقىدا يېڭى ئۈزۈۋالغان زەيتۇن يوپۇرمىقى بار ئىدى. بۇنى كۆرۈپ نۇھ سۇلارنىڭ يەر يۈزىدىن تارتىلغىنىنى بىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ئۇ يەنە يەتتە كۈن ساقلاپ، كەپتەرنى يەنە سىرتقا چىقاردى، ئەمما بۇ قېتىم كەپتەر ئۇنىڭ يېنىغا قايتىپ كەلمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","نۇھ ئالتە يۈز بىر ياشقا كىرگەن يىلى، بىرىنچى ئاينىڭ بىرىنچى كۈنىدە سۇ يەر يۈزىدىن قۇرۇغانىدى. نۇھ كېمىنىڭ قاپقىقىنى ئېچىپ قارىۋىدى، يەرنىڭ قۇرۇغىنىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ئىككىنچى ئاينىڭ يىگىرمە يەتتىنچى كۈنى، يەر يۈزى پۈتۈنلەي قۇرۇپ بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_15‏","002_8_15‏","GEN","8","15‏","16","ئۇ ۋاقىتتا خۇدا نۇھقا سۆز قىلىپ: ــ سەن ئۆزۈڭ، ئايالىڭ، ئوغۇللىرىڭ ۋە كېلىنلىرىڭ كېمىدىن چىقىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ئۆزۈڭ بىلەن بىللە بولغان بارلىق ئەت ئىگىلىرىدىن ھەربىر تۈردىكى جانىۋارلارنى، يەنى ئۇچار-قاناتلارنى ھەم مال-چارۋىلارنى، يەردە ئۆمىلىگۈچى ھايۋانلارنىڭ ھەممىسىنى ئۆزۈڭ بىلەن قوشۇپ كېمىدىن ئېلىپ چىققىن؛ شۇنىڭ بىلەن ئۇلار يەر يۈزىدە تارىلىپ-تارقىلىپ، نەسىللىنىپ زېمىندا كۆپەيسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","شۇنىڭ بىلەن نۇھ، ئايالى، ئوغۇللىرى ۋە كېلىنلىرى بىلەن بىللە سىرتقا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","جانىۋارلارنىڭ ھەممىسى، بارلىق ئۆمىلىگۈچى ھايۋانلار، بارلىق ئۇچار-قاناتلار، يەردە مىدىرلاپ يۈرىدىغانلارنىڭ ھەرقايسىسى ئۆز تۈرلىرى بويىچە كېمىدىن چىقىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","شۇ چاغدا نۇھ پەرۋەردىگارغا ئاتاپ بىر قۇربانگاھنى ياسىدى؛ ئۇ ھالال جانىۋارلار بىلەن ھالال قۇشلارنىڭ ھەر تۈرىدىن ئېلىپ كېلىپ، قۇربانگاھنىڭ ئۈستىدە «كۆيدۈرمە قۇربانلىق» ئۆتكۈزدى.    ");
INSERT INTO uigara_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","شۇنداق قىلىپ پەرۋەردىگار خۇشبۇي پۇراپ مەمنۇن بولدى؛ پەرۋەردىگار كۆڭلىدە: ــ «ئىنساننىڭ كۆڭۈل-نىيىتى ياشلىقىدىن تارتىپ رەزىل بولسىمۇ، مەن ئىنسان تۈپەيلىدىن يەرگە يەنە لەنەت ئوقۇمايمەن ۋە ئەمدى بۇ قېتىمقىدەك ھەممە جاندارلارنى ئۇرۇپ يوقىتىۋەتمەيمەن.    ");
INSERT INTO uigara_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","بۇندىن كېيىن، يەر مەۋجۇت كۈنلىرىدە، تېرىش بىلەن ئورما، سوغۇق بىلەن ئىسسىق، ياز بىلەن قىش، كۈندۈز بىلەن كېچە ئۈزۈلمەي ئايلىنىپ تۇرىدۇ» ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","خۇدا نۇھ بىلەن ئۇنىڭ ئوغۇللىرىغا بەخت-بەرىكەت ئاتا قىلىپ، ئۇلارغا مۇنداق دېدى: ــ «سىلەر جۈپلىشىپ كۆپىيىپ، يەر يۈزىنى تولدۇرۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","يەر يۈزىدىكى بارلىق جانىۋارلار، ئاسماندىكى بارلىق قۇشلار، بارلىق يەر يۈزىدە مىدىرلاپ يۈرگۈچىلەر ۋە دېڭىزدىكى بارلىق بېلىقلارنىڭ ھەممىسى سىلەردىن قورقۇپ ۋەھىمىدە بولسۇن؛ بۇلار قولۇڭلارغا تاپشۇرۇلغاندۇر. ");
INSERT INTO uigara_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","مىدىرلاپ يۈرىدىغان ھەرقانداق جانىۋارلار سىلەرگە ئوزۇق بولىدۇ؛ مەن سىلەرگە كۆك ئوتياشلارنى بەرگەندەك، بۇلارنىڭ ھەممىسىنى ئەمدى سىلەرگە بەردىم. ");
INSERT INTO uigara_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","لېكىن سىلەر گۆشنى ئىچىدىكى جېنى، يەنى قېنى بىلەن قوشۇپ يېمەسلىكىڭلار كېرەك. ");
INSERT INTO uigara_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","قېنىڭلار، يەنى جېنىڭلاردىكى قان تۆكۈلسە، مەن بەرھەق ئۇنىڭ ھېسابىنى ئالىمەن؛ ھەرقانداق ھايۋاننىڭ ئىلكىدە قېنىڭلار بار بولسا مەن ئۇنىڭغا تۆلەتكۈزىمەن؛ ئىنساننىڭ قولىدا بار بولسا، يەنى بىرسىنىڭ قولىدا ئۆز قېرىندىشىنىڭ قېنى بار بولسا، مەن ئۇنىڭغا شۇ قاننى تۆلەتكۈزىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","كىمكى ئىنساننىڭ قېنىنى تۆكسە، ئۇنىڭ قېنىمۇ ئىنسان تەرىپىدىن تۆكۈلىدۇ؛ چۈنكى خۇدا ئىنساننى ئۆز سۈرەت-ئوبرازىدا ياراتقاندۇر. ");
INSERT INTO uigara_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ئەمدى سىلەر، جۈپلىشىپ كۆپىيىپ، يەر يۈزىدە تارىلىپ-تارقىلىپ كۆپىيىڭلار». ");
INSERT INTO uigara_vpl VALUES ("GN9_8‏","002_9_8‏","GEN","9","8‏","9","ئاندىن خۇدا نۇھ بىلەن ئۇنىڭ ئوغۇللىرىغا سۆز قىلىپ مۇنداق دېدى: ــ «مانا ئۆزۈم سىلەر بىلەن ۋە سىلەردىن كېيىن كېلىدىغان ئەۋلادلىرىڭلار بىلەن، شۇنداقلا سىلەر بىلەن بىللە تۇرغان ھەربىر جان ئىگىسى، ئۇچارقاناتلار، مال-چارۋىلار، سىلەر بىلەن بىللە تۇرغان يەر يۈزىدىكى ھەربىر ياۋايى ھايۋانلار، كېمىدىن چىققانلارنىڭ ھەممىسى بىلەن ــ يەر يۈزىدىكى ھېچبىر ھايۋاننى قالدۇرماي، ئۇلار بىلەن ئۆز ئەھدەمنى تۈزىمەن ");
INSERT INTO uigara_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","مەن سىلەر بىلەن شۇنداق ئەھدە تۈزىمەنكى، نە بارلىق ئەت ئىگىلىرى توپان بىلەن يوقىتىلماس، نە يەرنى ۋەيران قىلىدىغان ھېچبىر توپان يەنە كەلمەس». ");
INSERT INTO uigara_vpl VALUES ("GN9_12‏","002_9_12‏","GEN","9","12‏","13","خۇدا يەنە: ــ «مەن ئۆزۈم سىلەر بىلەن ۋە قېشىڭلاردىكى ھەممە جان ئىگىلىرى بىلەن مەڭگۈلۈك، يەنى پۈتكۈل ئەۋلادلىرىڭلارغىچە بېكىتكەن مۇشۇ ئەھدەمنىڭ بەلگىسى شۇكى: ــ مانا، مەن ئۆزۈم بىلەن يەرنىڭ ئوتتۇرىسىدا بولغان ئەھدىنىڭ بەلگىسى بولسۇن دەپ ھەسەن-ھۈسىنىمنى بۇلۇتلار ئىچىگە قويىمەن؛ ");
INSERT INTO uigara_vpl VALUES ("GN9_14‏","002_9_14‏","GEN","9","14‏","15","ۋە شۇنداق بولىدۇكى، مەن يەرنىڭ ئۈستىگە بۇلۇتلارنى چىقارغىنىمدا، شۇنداقلا ھەسەن-ھۈسەن بۇلۇتلار ئىچىدە ئايان بولغىنىدا، مەن سىلەر بىلەن ئەت ئىگىلىرى بولغان بارلىق جانىۋارلار بىلەن تۈزگەن ئەھدەمنى ياد ئېتىمەن؛ بۇنىڭدىن كېيىن سۇلار ھەرگىز ھەممە جاندارلارنى ھالاك قىلغۇچى توپان بولماس. ");
INSERT INTO uigara_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ھەسەن-ھۈسەن بۇلۇتلار ئارىسىدا پەيدا بولىدۇ؛ مەن ئۇنىڭغا قارايمەن ۋە شۇنىڭ بىلەن مەنكى خۇدا يەر يۈزىدىكى ئەت ئىگىلىرى بولغان بارلىق جانىۋارلار بىلەن ئوتتۇرىمىزدا بېكىتكەن ئەھدەمنى ياد ئېتىمەن»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","خۇدا نۇھقا يەنە: ــ «مانا بۇ مەن ئۆزۈم بىلەن يەر يۈزىدىكى بارلىق ئەت ئىگىلىرى ئوتتۇرىسىدا بېكىتكەن ئەھدەمنىڭ نىشان-بەلگىسىدۇر»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","نۇھنىڭ كېمىدىن چىققان ئوغۇللىرى شەم، ھام ۋە يافەت ئىدى. ھام قانائاننىڭ ئاتىسى بولدى.    ");
INSERT INTO uigara_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","بۇ ئۈچى نۇھنىڭ ئوغۇللىرى بولۇپ، پۈتكۈل يەر يۈزىگە تارالغان ئاھالە شۇلارنىڭ نەسىل-ئەۋلادلىرىدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","نۇھ تېرىقچىلىق قىلىشقا باشلاپ، بىر ئۈزۈمزارلىق بەرپا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ئۇ ئۇنىڭ شارابىدىن ئىچىپ، مەست بولۇپ قېلىپ، ئۆز چېدىرى ئىچىدە كىيىم-كېچەكلىرىنى سېلىۋېتىپ، يالىڭاچ يېتىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","قانائاننىڭ ئاتىسى ھام كېلىپ، ئاتىسىنىڭ ئەۋرىتىنى كۆرۈپ، سىرتقا چىقىپ ئىككى قېرىندىشىغا ئېيتتى. ");
INSERT INTO uigara_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","شەم بىلەن يافەت قوپۇپ يېپىنجىنى ئېلىپ، مۈرىسىگە ئارتىپ، كەينىچە مېڭىپ كىرىپ، ئاتىسىنىڭ يالىڭاچ بەدىنىنى يېپىپ قويدى. ئۇلار يۈزىنى ئالدى تەرەپكە قىلىپ، ئاتىسىنىڭ يالىڭاچ تېنىگە قارىمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","نۇھ شارابنىڭ كەيپىدىن ئويغىنىپ، كەنجى ئوغلىنىڭ ئۆزىگە نېمە قىلغىنىنى بىلىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","قانائانغا لەنەت بولغاي! ئۇ قېرىنداشلىرىنىڭ قۇلىنىڭ قۇلى بولسۇن، ــ دەپ قارغىدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ئۇ يەنە: ــ شەمنىڭ خۇداسى بولغان پەرۋەردىگارغا تەشەككۈر-مەدھىيە كەلتۈرۈلگەي! قانائان شەمنىڭ قۇلى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","خۇدا يافەتنى ئاۋۇتقاي! ئۇ شەمنىڭ چېدىرلىرىدا تۇرغاي، قانائان بولسا ئۇنىڭ قۇلى بولغاي! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","نۇھ توپاندىن كېيىن ئۈچ يۈز ئەللىك يىل ئۆمۈر كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","بۇ تەرىقىدە نۇھ جەمئىي توققۇز يۈز ئەللىك يىل كۈن كۆرۈپ، ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","تۆۋەندىكىلەر نۇھنىڭ ئوغۇللىرىنىڭ ئەۋلادلىرىدۇر: ــ ئۇنىڭ ئوغۇللىرى شەم، ھام ۋە يافەت بولۇپ، توپاندىن كېيىن ئۇلاردىن ئوغۇللار تۆرەلگەن: ــ      ");
INSERT INTO uigara_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","يافەتنىڭ ئوغۇللىرى بولسا، گومەر، ماگوگ، ماداي، ياۋان، تۇبال، مەشەك ۋە تىراس ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","گومەرنىڭ ئەۋلادلىرى: ئاشكىناز، رىفات ۋە توگارماھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ياۋاننىڭ ئەۋلادلىرى: ئېلىشاھ، تارشىش، كىتتىيلار ۋە دودانىيلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","بۇلارنىڭ ئەۋلادلىرى دېڭىز بويلىرىدا ۋە ئاراللاردا ئايرىم-ئايرىم ياشىغان خەلقلەر بولۇپ، ھەرقايسىسى ئۆز تىلى، ئۆز ئائىلە-قەبىلىلىرى بويىچە ئۆز زېمىنلىرىدا تارقىلىپ ئولتۇراقلاشقان. ");
INSERT INTO uigara_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ھامنىڭ ئوغۇللىرى كۇش، مىسىر، پۇت ۋە قانائانلار ئىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","كۇشنىڭ ئوغۇللىرى سېبا، ھاۋىلاھ، سابتاھ، رائاماھ ۋە سابتىكا ئىدى. رائاماھنىڭ ئوغۇللىرى شېبا ۋە دېدان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","كۇشتىن يەنە نىمرود تۆرەلگەن؛ ئۇ يەر يۈزىدە ناھايىتى كۈچتۈڭگۈر ئادەم بولۇپ چىقتى.    ");
INSERT INTO uigara_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ئۇ پەرۋەردىگارنىڭ ئالدىدا كۈچتۈڭگۈر ئوۋچى بولدى؛ شۇ سەۋەبتىن «پالانچى بولسا نىمرودتەك، پەرۋەردىگارنىڭ ئالدىدا كۈچتۈڭگۈر ئوۋچى ئىكەن» دېگەن گەپ تارقالغان. ");
INSERT INTO uigara_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ئۇنىڭ پادىشاھلىقى شىنار زېمىنىدىكى بابىل، ئەرەك، ئاككاد ۋە كالنەھ دېگەن شەھەرلەردە باشلانغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_11‏","002_10_11‏","GEN","10","11‏","12","ئۇ بۇ زېمىندىن ئاشۇر زېمىنىغا چىقىپ نىنەۋە، رەھوبوت-ئىر، كالاھ ۋە نىنەۋە بىلەن كالاھنىڭ ئوتتۇرىسىدىكى رەسەن دېگەن شەھەرلەرنىمۇ بىنا قىلدى (بۇلار قوشۇلۇپ «كاتتا شەھەر» بولدى). ");
INSERT INTO uigara_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","مىسىرنىڭ ئەۋلادلىرى لۇدىيلار، ئانامىيلار، لەھابىيلار، نافتۇھىيلار، ");
INSERT INTO uigara_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","پاتروسىيلار، كاسلۇھىيلار (فىلىستىيلەر كاسلۇھىيلاردىن چىققان) ۋە كافتورىيلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","قانائاندىن تۇنجى ئوغۇل زىدون تۆرىلىپ، كېيىن يەنە ھەت تۆرەلگەن. ");
INSERT INTO uigara_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ئۇنىڭ ئەۋلادلىرى بولسا يەبۇسىيلار، ئامورىيلار، گىرگاشىيلار، ");
INSERT INTO uigara_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ھىۋىيلار، ئارقىيلار، سىنىيلار، ");
INSERT INTO uigara_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ئارۋادىيلار، زەمارىيلار ۋە خاماتىيلار ئىدى. شۇنىڭدىن كېيىن، قانائانىيلارنىڭ قەبىلىلىرى ھەر تەرەپكە تارقىلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","قانائانىيلارنىڭ يۇرت چېگرىسى بولسا زىدوندىن تارتىپ، گەرار تەرىپىگە سوزۇلۇپ، گازاغا چىقىپ، ئاندىن سودوم، گوموررا، ئادماھ بىلەن زەبوئىم تەرىپىگە تۇتىشىپ، لېشاغىچە يېتىپ باراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","يۇقىرىقىلار بولسا ھامنىڭ ئوغۇللىرى بولۇپ، ئۆز قەبىلىسى ۋە تىللىرى بويىچە قوۋم بولۇپ ئۆز زېمىنلىرىدا ئولتۇراقلاشقانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","شەممۇ ئوغۇل پەرزەنتلىك بولدى؛ شەم بولسا يافەتنىڭ ئاكىسى، ئېبەرلەرنىڭ ئاتا-بوۋىسى بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","شەمنىڭ ئوغۇللىرى ئېلام، ئاشۇر، ئارفاخشاد، لۇد، ئارام؛ ");
INSERT INTO uigara_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ئارامنىڭ ئوغۇللىرى ئۇز، ھۇل، گەتەر، ماش ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ئارفاخشادتىن شېلاھ تۆرەلدى، شېلاھتىن ئېبەر تۆرەلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ئېبەردىن ئىككى ئوغۇل تۆرەلگەن بولۇپ، بىرىنىڭ ئىسمى پەلەگ ئىدى، چۈنكى ئۇ ياشىغان دەۋردە يەر يۈزىدە بۆلۈنۈش بولدى؛ پەلەگنىڭ ئىنىسىنىڭ ئىسمى يوقتان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","يوقتاندىن ئالموداد، شەلەف، خازارماۋەت، يېراھ، ");
INSERT INTO uigara_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ھادورام، ئۇزال، دىكلاھ، ");
INSERT INTO uigara_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ئوبال، ئابىمائەل، شېبا، ");
INSERT INTO uigara_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ئوفىر، ھاۋىلاھ ۋە يوباب تۆرەلدى. بۇلارنىڭ ھەممىسى يوقتاننىڭ ئوغۇللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ئۇلارنىڭ ئولتۇرغان جايلىرى بولسا مېشادىن تارتىپ، سەففار دېگەن رايوننىڭ شەرق تەرىپىدىكى تاغقىچە سوزۇلاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","يۇقىرىقىلار بولسا شەمنىڭ ئوغۇللىرى بولۇپ، ئۆز قەبىلىسى ۋە تىللىرى بويىچە قوۋم بولۇپ ئۆز زېمىنلىرىدا ئولتۇراقلاشقانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","يۇقىرىدىكىلەر نۇھنىڭ ئەۋلادلىرى بولۇپ، ئۇلار ئۆز نەسەبلىرى ۋە قوۋملىرى بويىچە خاتىرىلەنگەن. توپاندىن كېيىنكى يەر يۈزىدىكى بارلىق قوۋملار ئۇلارنىڭ ئىچىدىن تارقالغان.    ");
INSERT INTO uigara_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ئۇ زاماندا پۈتكۈل يەر يۈزىدىكى تىل ھەم سۆز بىرخىل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","لېكىن شۇنداق بولدىكى، ئادەملەر مەشرىق تەرەپكە سەپەر قىلىپ، شىنار يۇرتىدا بىر تۈزلەڭلىكنى ئۇچرىتىپ، شۇ يەردە ئولتۇراقلاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ئۇلار بىر-بىرىگە: ــ كېلىڭلار، بىز خىش قۇيۇپ، ئوتتا پىشۇرايلى! ــ دېيىشتى. شۇنداق قىلىپ، ئۇلار قۇرۇلۇشتا تاشنىڭ ئورنىغا خىش، لاينىڭ ئورنىغا قارىماي ئىشلەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ئۇلار يەنە: ــ كېلىڭلار، ئەمدى ئۆزۈمىزگە بىر شەھەر بىنا قىلىپ، شەھەردە ئۇچى ئاسمانلارغا تاقاشقۇدەك بىر مۇنار ياسايلى! شۇنداق قىلىپ ئۆزىمىزگە بىر نام تىكلىيەلەيمىز. بولمىسا، پۈتكۈل يەر يۈزىگە تارىلىپ كېتىمىز، ــ دېيىشتى.    ");
INSERT INTO uigara_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ئۇ ۋاقىتتا پەرۋەردىگار ئادەم بالىلىرى بىنا قىلىۋاتقان شەھەر بىلەن مۇنارنى كۆرگىلى چۈشتى. ");
INSERT INTO uigara_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","پەرۋەردىگار: ــ «مانا، بۇلارنىڭ ھەممىسى بىر قوۋمدۇر، ئۇلارنىڭ ھەممىسىنىڭ تىلىمۇ بىردۇر؛ بۇ ئۇلارنىڭ ئىشىنىڭ باشلىنىشىدۇر! بۇندىن كېيىن ئۇلارنىڭ نىيەت قىلغان ھەرقانداق ئىشىنى ھېچ توسۇۋالغىلى بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","شۇڭا بىز تۆۋەنگە چۈشۈپ ئۇلارنىڭ بىر-بىرىنىڭ گەپلىرىنى ئۇقالماسلىقى ئۈچۈن ئۇلارنىڭ تىلىنى باشقا-باشقا قىلىپ قالايمىقانلاشتۇرۇۋېتەيلى» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","شۇنداق قىلىپ پەرۋەردىگار ئۇلارنى ئۇ جايدىن پۈتكۈل يەر يۈزىگە تارىتىۋەتتى. شۇنىڭ بىلەن ئۇلار شەھەرنى ياساشتىن توختاپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","شۇڭا بۇ شەھەرنىڭ نامى «بابىل» دەپ ئاتالدى؛ چۈنكى ئۇ يەردە پەرۋەردىگار پۈتكۈل يەر يۈزىدىكىلەرنىڭ تىلىنى قالايمىقانلاشتۇرۇۋەتتى. شۇنداق قىلىپ پەرۋەردىگار ئۇلارنى ئۇ جايدىن پۈتكۈل يەر يۈزىگە تارىتىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","تۆۋەندىكىلەر شەمنىڭ ئەۋلادلىرىدۇر: ــ توپان ئۆتۈپ ئىككى يىلدىن كېيىن، شەم يۈز يېشىدا، ئۇنىڭدىن ئارفاكشاد تۆرەلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ئارفاكشاد تۇغۇلغاندىن كېيىن شەم بەش يۈز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ئارفاكشاد ئوتتۇز بەش ياشقا كىرگەندە ئۇنىڭدىن شېلاھ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","شېلاھ تۇغۇلغاندىن كېيىن ئارفاكشاد تۆت يۈز ئۈچ يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","شېلاھ ئوتتۇز ياشقا كىرگەندە ئۇنىڭدىن ئېبەر تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ئېبەر تۇغۇلغاندىن كېيىن شېلاھ تۆت يۈز ئۈچ يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ئېبەر ئوتتۇز تۆت ياشقا كىرگەندە ئۇنىڭدىن پەلەگ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","پەلەگ تۇغۇلغاندىن كېيىن ئېبەر تۆت يۈز ئوتتۇز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","پەلەگ ئوتتۇز ياشقا كىرگەندە ئۇنىڭدىن رەئۇ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","رەئۇ تۇغۇلغاندىن كېيىن پەلەگ ئىككى يۈز توققۇز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","رەئۇ ئوتتۇز ئىككى ياشقا كىرگەندە ئۇنىڭدىن سېرۇگ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","سېرۇگ تۇغۇلغاندىن كېيىن رەئۇ ئىككى يۈز يەتتە يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","سېرۇگ ئوتتۇز ياشقا كىرگەندە ئۇنىڭدىن ناھور تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ناھور تۇغۇلغاندىن كېيىن سېرۇگ ئىككى يۈز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ناھور يىگىرمە توققۇز ياشقا كىرگەندە ئۇنىڭدىن تەراھ تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","تەراھ تۇغۇلغاندىن كېيىن ناھور بىر يۈز ئون توققۇز يىل ئۆمۈر كۆرۈپ، ئۇنىڭدىن يەنە ئوغۇل-قىزلار تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","تەراھ يەتمىش ياشقا كىرگەندە ئۇنىڭدىن ئابرام، ناھور ۋە ھاران تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","تەراھنىڭ ئەۋلادلىرى تۆۋەندىكىچە: ــ تەراھتىن ئابرام، ناھور ۋە ھاران تۆرەلدى؛ ھاراندىن لۇت تۆرەلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","لېكىن ھاران تۇغۇلغان يۇرتى بولغان، كالدىيلەرنىڭ ئۇر شەھىرىدە ئاتىسى تەراھنىڭ ئالدىدا، تەراھتىن ئىلگىرى ئۆلدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ئابرام بىلەن ناھور ئىككىسى ئۆيلەندى. ئابرامنىڭ ئايالىنىڭ ئىسمى ساراي، ناھورنىڭ ئايالىنىڭ ئىسمى مىلكاھ ئىدى؛ مىلكاھ ھاراننىڭ قىزى ئىدى؛ ھاران بولسا مىلكاھ ۋە ئىسكاھنىڭ ئاتىسى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","لېكىن ساراي تۇغماس بولغاچقا، ئۇنىڭ بالىسى يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","تەراھ بولسا ئوغلى ئابرامنى، نەۋرىسى لۇت (ھاراننىڭ ئوغلى)نى ۋە كېلىنى، يەنى ئابرامنىڭ ئايالى ساراينى ئېلىپ، قانائان زېمىنىغا بېرىش ئۈچۈن كالدىيلەرنىڭ ئۇر شەھىرىدىن يولغا چىقتى؛ بىراق ئۇلار ھاران دېگەن جايغا يېتىپ كەلگەندە، شۇ يەردە ئولتۇراقلىشىپ قالدى.    ");
INSERT INTO uigara_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","تەراھنىڭ كۆرگەن كۈنلىرى ئىككى يۈز بەش يىل بولۇپ، ھاراندا ئالەمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","پەرۋەردىگار ئەسلىدە ئابرامغا مۇنداق دېگەنىدى: ــ سەن ئۆز يۇرتۇڭدىن، ئۆز ئۇرۇق-تۇغقانلىرىڭدىن ۋە ئۆز ئاتا جەمەتىڭدىن ئايرىلىپ، مەن ساڭا كۆرسىتىدىغان زېمىنغا بارغىن. ");
INSERT INTO uigara_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","شۇنداق قىلساڭ مەن سېنى ئۇلۇغ بىر خەلق قىلىپ، ساڭا بەخت-بەرىكەت ئاتا قىلىپ، نامىڭنى ئۇلۇغ قىلىمەن؛ شۇنىڭ بىلەن سەن ئۆزۈڭ باشقىلارغا بەخت-بەرىكەت بولغىن؛ ");
INSERT INTO uigara_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","كىملەر ساڭا بەخت-بەرىكەت تىلىسە مەن ئۇلارنى بەرىكەتلەيمەن، كىمكى سېنى خورلىسا، مەن چوقۇم ئۇنى لەنەتكە قالدۇرىمەن؛ سەن ئارقىلىق يەر يۈزىدىكى بارلىق ئائىلە-قەبىلىلەرگە بەخت-بەرىكەت ئاتا قىلىنىدۇ! ــ دېدى.      ");
INSERT INTO uigara_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ئابرام پەرۋەردىگار ئۇنىڭغا ئېيتقىنى بويىچە ھاراندىن ئايرىلدى؛ لۇتمۇ ئۇنىڭ بىلەن بىللە ماڭدى. ئابرام ھاراندىن چىققىنىدا يەتمىش بەش ياشتا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ئابرام ئايالى ساراي بىلەن ئىنىسىنىڭ ئوغلى لۇتنى ئېلىپ، ئۇلارنىڭ يىغقان بارلىق مال-مۈلۈكىنى قوشۇپ، ھاراندا ئىگىدارچىلىق قىلغان ئادەملەرنى بىللە قېتىپ، قانائان زېمىنىغا بېرىش ئۈچۈن يولغا چىقتى؛ شۇنداق قىلىپ ئۇلار قانائان زېمىنىغا يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ئابرام زېمىننى كېزىپ، شەكەم دېگەن جايدىكى «مورەھنىڭ دۇب دەرىخى»نىڭ يېنىغا كەلدى (ئۇ چاغدا ئۇ زېمىندا قانائانىيلار تۇراتتى). ");
INSERT INTO uigara_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","پەرۋەردىگار ئابرامغا كۆرۈنۈپ، ئۇنىڭغا: ــ مەن بۇ زېمىننى سېنىڭ نەسلىڭگە ئاتا قىلىمەن، ــ دېدى. شۇنىڭ بىلەن ئۇ شۇ يەردە ئۆزىگە كۆرۈنگەن پەرۋەردىگارغا ئاتاپ بىر قۇربانگاھ سالدى.    ");
INSERT INTO uigara_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ئاندىن ئۇ بۇ يەردىن يۆتكىلىپ، بەيت-ئەلنىڭ شەرقىدىكى تاغقا باردى؛ غەرب تەرىپىدە بەيت-ئەل، شەرق تەرىپىدە ئايى دېگەن جاي بار ئىدى؛ ئۇ شۇ يەردە چېدىر تىكتى. ئۇ شۇ يەردە پەرۋەردىگارغا ئاتاپ بىر قۇربانگاھ ياساپ، پەرۋەردىگارنىڭ نامىنى چاقىرىپ ئىبادەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ئاندىن كېيىن ئابرام تەدرىجىي كۆچۈپ، جەنۇبىدىكى نەگەۋ رايونىغا قاراپ يۆتكەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","زېمىندا ئاچارچىلىق بولغانىدى؛ ئابرام مىسىرغا چۈشتى؛ ئۇ شۇ يەردە ۋاقتىنچە تۇرماقچى بولغانىدى، چۈنكى زېمىندا ئاچارچىلىق بەك ئېغىر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ئەمما شۇنداق بولدىكى، ئۇ مىسىرغا يېقىنلاشقاندا، ئايالى سارايغا: ــ مانا، مەن سېنىڭ ھۆسۈن-جامالىڭنىڭ گۈزەللىكىنى بىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","شۇنداق بولىدۇكى، مىسىرلىقلار سېنى كۆرسە، «بۇ ئۇنىڭ ئايالى ئىكەن» دەپ، مېنى ئۆلتۈرۈۋېتىپ، سېنى تىرىك قالدۇرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","شۇنىڭ ئۈچۈن سېنىڭ: «مەن ئۇنىڭ سىڭلىسى» دېيىشىڭنى ئۆتىنىمەن. شۇنداق قىلساڭ، مەن سېنىڭدىن ياخشىلىق تېپىپ، سەن ئارقىلىق تىرىك قالىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ئابرام مىسىرغا كىرگەندە شۇنداق بولدىكى، مىسىرلىقلار دەرۋەقە ئايالنىڭ گۈزەل ئىكەنلىكىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","پىرەۋننىڭ ئەمىرلىرىمۇ ئۇنى كۆرۈپ، پىرەۋنگە ئۇنىڭ تەرىپىنى قىلدى؛ شۇنىڭ بىلەن ئايال پىرەۋننىڭ ئوردىسىغا ئېلىپ كىرىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","پىرەۋن ساراينىڭ سەۋەبىدىن ئابرامغا ياخشى مۇئامىلە قىلدى؛ شۇنىڭ بىلەن ئۇ قوي، كالا، ھاڭگا ئېشەكلەر، قۇل-دېدەكلەر، مادا ئېشەكلەر ۋە تۆگىلەرگە ئېرىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ئەمما پەرۋەردىگار پىرەۋن ۋە ئۆيىدىكىلىرىنى ئابرامنىڭ ئايالى ساراينىڭ سەۋەبىدىن تولىمۇ ئېغىر ۋابالارغا مۇپتىلا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","شۇنىڭ ئۈچۈن پىرەۋن ئابرامنى چاقىرىپ ئۇنىڭغا: ــ «بۇ زادى سېنىڭ ماڭا نېمە قىلغىنىڭ؟ نېمىشقا ئۇنىڭ ئۆز ئايالىڭ ئىكەنلىكىنى ماڭا ئېيتمىدىڭ؟ ");
INSERT INTO uigara_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","نېمىشقا ئۇنى «سىڭلىم» دەپ مېنىڭ ئۇنى خوتۇنلۇققا ئېلىشىمغا سەۋەبكار بولغىلى تاس قالىسەن! مانا بۇ ئايالىڭ! ئۇنى ئېلىپ كەتكىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","پىرەۋن ئۆز ئادەملىرىگە ئابرام توغرىسىدا ئەمر قىلدى؛ ئۇلار ئۇنى، ئايالىنى ۋە ئۇنىڭ بارلىقىنى قوشۇپ يولغا سېلىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","شۇنىڭ بىلەن ئابرام ئايالى ۋە ئۇنىڭ بارلىق نەرسىلىرىنى ھەمدە لۇتنى ئېلىپ مىسىردىن چىقىپ، قانائاننىڭ جەنۇبىدىكى نەگەۋ يۇرتىغا ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ئۇ چاغدا ئابرامنىڭ مال-ۋاران ۋە ئالتۇن-كۈمۈشلىرى كۆپ بولۇپ، خېلىلا باي ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ئۇ كۆچۈپ يۈرۈپ، جەنۇبتىكى نەگەۋدىن بەيت-ئەلگە، يەنى بەيت-ئەل بىلەن ئايىنىڭ ئوتتۇرىسىدىكى ئەسلىدە چېدىر تىككەن جايغا، ");
INSERT INTO uigara_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","قۇربانگاھ ياسىغان جايغا قايتىپ كەلدى. ئابرام شۇ يەردە پەرۋەردىگارنىڭ نامىنى چاقىرىپ ئىبادەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ئابرام بىلەن بىللە ماڭغان لۇتنىڭمۇ قوي-كالا پادىلىرى ۋە چېدىرلىرى بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ئەمدى ئۇلار بىللە تۇرسا، زېمىن ئۇلارنى قامدىيالمايتتى؛ ");
INSERT INTO uigara_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","بۇ سەۋەبتىن ئابرامنىڭ پادىچىلىرى بىلەن لۇتنىڭ پادىچىلىرىنىڭ ئارىسىدا جېدەل چىقتى (ئۇ ۋاقىتتا قانائانىيلار بىلەن پەرىززىيلەر شۇ زېمىندا تۇراتتى).    ");
INSERT INTO uigara_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","شۇڭا ئابرام لۇتقا: ــ «بىز بولساق قېرىنداشلارمىز، سەن بىلەن مېنىڭ ئارامدا، مېنىڭ پادىچىلىرىم بىلەن سېنىڭ پادىچىلىرىڭ ئارىسىدا تالاش-تارتىش پەيدا بولمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","مانا، ئالدىڭدا پۈتكۈل زېمىن تۇرمامدۇ؟ ئەمدى سەن مەندىن ئايرىلغىن؛ ئەگەر سەن سول تەرەپكە بارساڭ، مەن ئوڭ تەرەپكە باراي؛ ئەگەر سەن ئوڭ تەرەپكە بارساڭ، مەن سول تەرەپكە باراي»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ئۇ ۋاقىتتا لۇت نەزەر سېلىپ كۆردىكى، ئىئوردان ۋادىسىدىكى بارلىق تۈزلەڭلىكنىڭ زوئار شەھىرىگىچە ھەممىلا يەرنىڭ سۈيى ئىنتايىن مول ئىدى؛ پەرۋەردىگار سودوم بىلەن گوموررانى ۋەيران قىلىشتىن ئىلگىرى بۇ يەر بەئەينى پەرۋەردىگارنىڭ بېغى، مىسىر زېمىنىدەك ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","شۇنىڭ بىلەن لۇت ئۆزىگە ئىئوردان ۋادىسىدىكى پۈتكۈل تۈزلەڭلىكنى تاللىۋالدى؛ ئاندىن لۇت مەشرىق تەرەپكە كۆچۈپ باردى. شۇنداق قىلىپ ئىككىيلەن ئايرىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ئابرام قانائان زېمىنىدا ئولتۇراقلاشتى؛ لۇت بولسا تۈزلەڭلىكتىكى شەھەرلەرنىڭ ئارىسىدا تۇردى؛ ئۇ بارا-بارا چېدىرلىرىنى سودوم شەھىرى تەرەپكە يۆتكىدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","سودوم خەلقى رەزىل ئادەملەر بولۇپ، پەرۋەردىگارنىڭ نەزىرىدە تولىمۇ ئېغىر گۇناھكارلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","لۇت ئابرامدىن ئايرىلىپ كەتكەندىن كېيىن، پەرۋەردىگار ئابرامغا: ــ سەن ئەمدى بېشىڭنى كۆتۈرۈپ، ئۆزۈڭ تۇرغان جايدىن شىمال ۋە جەنۇبقا، مەشرىق ۋە مەغرىب تەرەپكە قارىغىن؛ ");
INSERT INTO uigara_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","چۈنكى سەن ھازىر كۆرۈۋاتقان بۇ بارلىق زېمىننى ساڭا ۋە نەسلىڭگە مەڭگۈلۈك بېرىمەن.    ");
INSERT INTO uigara_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","سېنىڭ نەسلىڭنى يەردىكى توپىدەك كۆپ قىلىمەن؛ شۇنداقكى، ئەگەر بىرسى يەردىكى توپىنى ساناپ چىقالىسا، سېنىڭ نەسلىڭنىمۇ ساناپ چىقالىشى مۇمكىن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ئورنۇڭدىن تۇر، بۇ زېمىننى ئۇزۇنلۇقى ۋە ڭەڭلىكى بويىچە ئايلىنىپ چىققىن؛ چۈنكى مەن ئۇنى ساڭا ئاتا قىلىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","شۇڭا ئابرام چېدىرلىرىنى يۆتكەپ، ھېبرون شەھىرىگە يېقىن مامرەدىكى دۇبزارلىقنىڭ يېنىغا بېرىپ ئولتۇراقلاشتى؛ ئۇ شۇ يەردە پەرۋەردىگارغا ئاتاپ بىر قۇربانگاھ ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","شىنارنىڭ پادىشاھى ئامرافەل، ئەللاسارنىڭ پادىشاھى ئارىئوق، ئېلامنىڭ پادىشاھى كېدورلايومەر ۋە گويىمنىڭ پادىشاھى تىدالنىڭ كۈنلىرىدە شۇ ۋەقە بولدىكى، ");
INSERT INTO uigara_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ئۇلار بىرلىشىپ سودومنىڭ پادىشاھى بېرا، گوموررانىڭ پادىشاھى بىرشا، ئادماھنىڭ پادىشاھى شىناب، زەبوئىمنىڭ پادىشاھى شەمئېبەر ۋە بېلا (يەنى زوئار)نىڭ پادىشاھىغا قارشى ھۇجۇمغا ئاتلاندى. ");
INSERT INTO uigara_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","بۇ بەشىنىڭ ھەممىسى كېلىشىپ سىددىم ۋادىسىغا، يەنى «شور دېڭىزى» ۋادىسىغا يىغىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ئۇلار ئون ئىككى يىل كېدورلايومەرگە بېقىندى بولدى، ئون ئۈچىنچى يىلغا كەلگەندە، كېدورلايومەرگە قارشى ئىسيان كۆتۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ئون تۆتىنچى يىلى كېدورلايومەر ۋە ئۇنىڭغا ئىتتىپاقداش بولغان پادىشاھلار ھەممىسى يىغىلىپ، ئاشتاروت-كارنائىم دېگەن يەردە رەفايىيلارغا، شۇنداقلا ھام دېگەن يەردە زۇزىيلارغا، شاۋەھ-كىرىئاتايىمدا ئېمىيلارغا ھۇجۇم قىلىپ ئۇلارنى يەڭدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ئاندىن ئۇلار ھورىيلارنى ئۇلارنىڭ سېئىر تېغىدا مەغلۇپ قىلىپ، چۆلنىڭ يېنىدىكى ئەل-پارانغىچە سۈرۈپ-توقاي قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ئارقىدىنلا، ئۇلار ئەن-مىشپاتقا (يەنى قادەشكە) يېنىپ كېلىپ، ئامالەكلەرنىڭ پۈتكۈل يۇرتىنى بۇلاڭ-تالاڭ قىلدى؛ ھازازون-تاماردا ئولتۇرۇشلۇق ئامورىيلارنىمۇ ھۇجۇم قىلىپ مەغلۇپ قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","شۇنىڭ بىلەن سودومنىڭ پادىشاھى، گوموررانىڭ پادىشاھى، ئادماھنىڭ پادىشاھى، زەبوئىمنىڭ پادىشاھى ۋە بېلانىڭ (يەنى زوئارنىڭ) پادىشاھى چىقىپ، سىددىم ۋادىسىدا ئۇلارغا قارشى جەڭ قىلىشقا سەپ تىزدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","مۇشۇ بەشەيلەن ئېلامنىڭ پادىشاھى كېدورلايومەر، گويىمنىڭ پادىشاھى تىدال، شىنارنىڭ پادىشاھى ئامرافەل، ئەللاسارنىڭ پادىشاھى ئارىئوق قاتارلىقلار بىلەن سوقۇشتى؛ يەنى تۆت پادىشاھ بىلەن بەش پادىشاھ ئۆزئارا سوقۇشتى. ");
INSERT INTO uigara_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","سىددىم ۋادىسىدىكى ھەممىلا يەردە قارىماي ئورەكلىرى بار ئىدى. سودوم ۋە گوموررانىڭ پادىشاھلىرى قېچىپ، ئورەكلەرگە چۈشۈپ كەتتى. ئەمما قالغانلار بولسا تاغقا قېچىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","غالىب كەلگەن تۆت پادىشاھ بولسا سودوم بىلەن گوموررانىڭ ھەممە مال-مۈلكىنى ۋە بارلىق ئوزۇق-تۈلۈكىنى ئېلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ئۇلار يەنە ئابرامنىڭ جىيەنى لۇتنىمۇ ماللىرى بىلەن قوشۇپ ئېلىپ كەتتى؛ چۈنكى ئۇ سودومدا ئولتۇراقلاشقانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ھالبۇكى، قۇتۇلۇپ قالغان بىرسى بېرىپ بۇ ئىشلارنى ئىبرانىي ئابرامغا ئېيتتى. شۇ چاغدا ئۇ ئامورىي مامرەنىڭ دۇبزارلىقىنىڭ يېنىدا تۇراتتى. مامرە بولسا ئەشكول ۋە ئانەرنىڭ ئاكىسى ئىدى؛ بۇ ئۈچەيلەن ئابرام بىلەن ئىتتىپاقداش ئىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ئابرام قېرىندىشىنىڭ ئەسىر بولۇپ قالغانلىقىنى ئاڭلاپ، ئۆز ئۆيىدە تۇغۇلغان، ئالاھىدە تەربىيىلەنگەن ئۈچ يۈز ئون سەككىز ئادەمنى باشلاپ چىقىپ، تۆت پادىشاھنى قوغلاپ دانغىچە باردى. ");
INSERT INTO uigara_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","كېچىسى ئۇ ئادەملىرىنى گۇرۇپپىلارغا بۆلۈپ، ئۇلار بىلەن بىرلىكتە ھۇجۇم قىلىپ ئۇلارنى مەغلۇپ قىلىپ، ئۇلارنى دەمەشقنىڭ شىمال تەرىپىدىكى ھوباھ دېگەن جايغىچە قوغلاپ بېرىپ، ");
INSERT INTO uigara_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","پۈتكۈل ئولجا ئالغان مال-مۈلۈكنى قايتۇرۇۋالدى؛ ئۆز قېرىندىشى لۇتنى، ئۇنىڭ مال-مۈلكى ۋە خوتۇن-قىزلىرىنى، شۇنداقلا بارلىق قالغان ئادەملەرنى ياندۇرۇپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ئابرام كېدورلايومەر ۋە ئۇنىڭ بىلەن ئىتتىپاقداش پادىشاھلارنى مەغلۇپ قىلىپ، قايتىپ كەلگەندە، سودومنىڭ پادىشاھى شاۋەھ ۋادىسى (يەنى خان ۋادىسى)غا ئۇنىڭ ئالدىغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","سالېمنىڭ پادىشاھى مەلكىزەدەكمۇ نان بىلەن شاراب ئېلىپ ئالدىغا چىقتى. ئۇ زات بولسا، ھەممىدىن ئالىي تەڭرىنىڭ كاھىنى ئىدى؛    ");
INSERT INTO uigara_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ئۇ ئابرامنى بەخت-بەرىكەتلەپ: ــ «ئابرام ئاسمان بىلەن زېمىننىڭ ئىگىسى بولغان ھەممىدىن ئالىي تەڭرى تەرىپىدىن بەرىكەتلەنسۇن! ");
INSERT INTO uigara_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","شۇنداقلا دۈشمەنلىرىڭنى ئۆز قولۇڭغا تاپشۇرغان ھەممىدىن ئالىي تەڭرىگە ھەمدۇسانا ئوقۇلغاي!» ــ دېدى. ئابرام بولسا غەنىيمەت ئالغان نەرسىلەرنىڭ ئوندىن بىرىنى ئۇنىڭغا بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ئاندىن سودومنىڭ پادىشاھى ئابرامغا: ــ ئادەملەرنى ماڭا بەرگەيلا، غەنىيمەتلەرنى ئۆزلىرىگە ئالغايلا، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","لېكىن ئابرام سودومنىڭ پادىشاھىغا جاۋاب بېرىپ: ــ مەن بولسام ئاسمان بىلەن زېمىننىڭ ئىگىسى بولغان ھەممىدىن ئالىي تەڭرى پەرۋەردىگارغا قول كۆتۈرۈپ قەسەم قىلغانمەنكى، ");
INSERT INTO uigara_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","مەن سەندىن ھەتتا بىر تال يىپ نە بىر تال بوغقۇچىنىمۇ نە سېنىڭ باشقا ھەرقانداق نەرسەڭنى ئالمايمەن؛ بولمىسا، سەن كېيىن: «مەن ئابرامنى باي قىلىپ قويدوم» دېيىشىڭ مۇمكىن. ");
INSERT INTO uigara_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","شۇڭا يىگىتلىرىمنىڭ يېگەن-ئىچكىنى، شۇنداقلا ماڭا ھەمراھ بولغانلار، يەنى ئانەر، ئەشكول ۋە مامرەلەرگە تېگىشلىك ئۈلۈشتىن باشقا، مەن غەنىيمەتتىن ھېچنەرسە ئالمايمەن؛ شۇلار ئۆزلىرىگە تېگىشلىك ئۈلۈشىنى ئالسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","بۇ ئىشلاردىن كېيىن پەرۋەردىگارنىڭ سۆز-كالامى ئابرامغا ئالامەت كۆرۈنۈشتە كېلىپ: «ئەي ئابرام، قورقمىغىن؛ مەن ئۆزۈم قالقىنىڭ ۋە زور ئىنئامىڭدۇرمەن» ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","لېكىن ئابرام: ــ ئەي رەب پەرۋەردىگار، ماڭا نېمە بېرىسەن؟ مانا، مەن بالىسىز تۇرسام، ئۆي-بىساتلىرىمغا ۋارىسلىق قىلغۇچى مۇشۇ دەمەشقلىك ئەلىئېزەرلا باردۇر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ئابرام يەنە: مانا، سەن ماڭا ھېچ نەسىل بەرمىدىڭ، مانا ئۆيۈمدە تۇرۇۋاتقانلاردىن بىرى ماڭا ۋارىس بولىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","شۇ ھامان پەرۋەردىگارنىڭ سۆز-كالامى ئۇنىڭغا كېلىپ: «بۇ كىشى ساڭا ۋارىس بولمايدۇ، بەلكى ئۆز پۇشتۇڭدىن بولىدىغان كىشى ساڭا ۋارىس بولىدۇ»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","شۇنىڭ بىلەن پەرۋەردىگار ئۇنى تاشقىرىغا ئېلىپ چىقىپ: ــ ئەمدى ئاسمانغا قاراپ يۇلتۇزلارنى سانا ــ قېنى، ئۇلارنى سانىيالامسەنكىن؟! ــ دېدى. ئاندىن ئۇنىڭغا: ــ سېنىڭ نەسلىڭمۇ شۇنداق بولىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ئابرام پەرۋەردىگارغا ئىشەندى؛ پەرۋەردىگار ئۇنىڭدىكى بۇ ئىشەنچنى ئۇنىڭ ھەققانىيلىقى دەپ ھېسابلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","يەنە ئۇنىڭغا: مەن بۇ زېمىنغا ئىگە قىلىشقا سېنى كالدىيەدىكى ئۇر شەھىرىدىن ئېلىپ چىققان پەرۋەردىگاردۇرمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","لېكىن ئابرام: ــ ئى رەب پەرۋەردىگار، مەن ئۇنىڭغا جەزمەن ئىگە بولىدىغىنىمنى قانداق بىلىمەن؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","پەرۋەردىگار ئۇنىڭغا: ــ مەن ئۈچۈن ئۈچ ياشلىق بىر ئىنەك، ئۈچ ياشلىق بىر چىشى ئۆچكە، ئۈچ ياشلىق بىر قوچقار بىلەن بىر كەپتەر ۋە بىر باچكا ئېلىپ كەلگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","شۇڭا ئۇ بۇلارنىڭ ھەممىسىنى ئېلىپ، ئۇلارنىڭ ھەربىرسىنى يېرىمدىن ئىككى پارچە قىلىپ، يېرىمىنى يەنە بىر يېرىمىغا ئۇدۇلمۇئۇدۇل قىلىپ قويۇپ قويدى؛ ئەمما قۇشلارنى پارچىلىمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","قاغا-قۇزغۇنلار تاپلارنىڭ ئۈستىگە چۈشكەندە، ئابرام ئۇلارنى ئۈركۈتۈپ ھەيدىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","لېكىن كۈن پاتاي دېگەندە، ئابرامنى ئېغىر بىر ئۇيقۇ باستى ۋە مانا، ئۇنىڭ ئۈستىگە دەھشەتلىك بىر ۋەھىمە، تۇم قاراڭغۇلۇق چۈشتى. ");
INSERT INTO uigara_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ئاندىن پەرۋەردىگار ئابرامغا: ــ جەزمەن بىلىشىڭ كېرەككى، سېنىڭ نەسلىڭ ئۆزلىرىنىڭ بولمىغان بىر زېمىندا مۇساپىر بولۇپ، شۇ يەردىكى خەلقنىڭ قۇللۇقىدا بولىدۇ ۋە شۇنداقلا، بۇ خەلق ئۇلارغا تۆت يۈز يىلغىچە جەبىر-زۇلۇم سالىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","لېكىن مەن ئۇلارنى قۇللۇققا سالغۇچى شۇ تائىپىنىڭ ئۈستىدىن ھۆكۈم چىقىرىمەن. كېيىن ئۇلار نۇرغۇن بايلىقلارنى ئېلىپ شۇ يەردىن چىقىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ئەمما سەن بولساڭ، ئامان-خاتىرجەملىك ئىچىدە ئاتا-بوۋىلىرىڭغا قوشۇلىسەن؛ ئۇزۇن ئۆمۈر كۆرۈپ ئاندىن دەپنە قىلىنىسەن.    ");
INSERT INTO uigara_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","لېكىن شۇ يەردە تۆت ئەۋلاد ئۆتۈپ، نەسلىڭ بۇ يەرگە يېنىپ كېلىدۇ؛ چۈنكى ئامورىيلارنىڭ قەبىھلىكىنىڭ زىخى تېخى توشمىدى، دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","شۇنداق بولدىكى، كۈن پېتىپ قاراڭغۇ بولغاندا، مانا، گۆشلەرنىڭ ئوتتۇرىسىدىن ئۆتۈپ كېتىۋاتقان، ئىس-تۈتەك چىقىپ تۇرغان بىر ئوتدان بىلەن يالقۇنلۇق بىر مەشئەل كۆرۈندى. ");
INSERT INTO uigara_vpl VALUES ("GN15_18‏","002_15_18‏","GEN","15","18‏","19","دەل شۇ كۈنى پەرۋەردىگار ئابرام بىلەن ئەھدە تۈزۈپ ئۇنىڭغا: ــ «مەن سېنىڭ نەسلىڭگە بۇ زېمىننى مىسىرنىڭ ئېقىنىدىن تارتىپ ئۇلۇغ دەريا، يەنى ئەفرات دەرياسىغىچە بېرىمەن؛ يەنى كېنىيلەر، كەنىززىيلار، كادمونىيلار، ");
INSERT INTO uigara_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ھىتتىيلار، پەرىززىيلەر، رەفايىيلار، ");
INSERT INTO uigara_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ئامورىيلار، قانائانىيلار، گىرگاشىيلار ۋە يەبۇسىيلارنىڭ يۇرتىنى ئۇلارنىڭكى قىلىمەن» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ئەمما ئابرامنىڭ ئايالى ساراي ئۇنىڭغا ھېچ بالا تۇغۇپ بەرمىدى؛ لېكىن ئۇنىڭ ھەجەر ئىسىملىك مىسىرلىق بىر دېدىكى بار ئىدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ساراي ئابرامغا: ــ مانا، پەرۋەردىگار مېنى تۇغۇشتىن توستى. ئەمدى سەن مېنىڭ دېدىكىمنىڭ قېشىغا كىرگىن؛ بەلكىم ئۇ ئارقىلىق ئانا بولۇپ تىكلىنىشىم مۇمكىن، ــ دېدى. ئابرام بولسا ساراينىڭ سۆزىنى قوبۇل كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","شۇنىڭ بىلەن ئابرامنىڭ ئايالى ساراي دېدىكى مىسىرلىق ھەجەرنى ئۆز ئېرى ئابرامغا توقاللىققا ئاپىرىپ بەردى (ئۇ ۋاقىتتا ئابرام قانائان زېمىنىدا ئون يىل ئولتۇرغانىدى). ");
INSERT INTO uigara_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ئابرام ھەجەرنىڭ قېشىغا كىردى ۋە ئۇ ھامىلىدار بولدى. ئەمما ئۇ ئۆزىنىڭ ھامىلىدار بولغىنىنى بىلگىنىدە، ئۇ ئايال خوجايىنىنى كۆزگە ئىلماس بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ساراي ئابرامغا قېيىداپ: ــ ماڭا چۈشكەن بۇ خورلۇق سېنىڭ بېشىڭغا چۈشسۇن! مەن ئۆز دېدىكىمنى قۇچىقىڭغا سېلىپ بەردىم؛ ئەمدى ئۇ ئۆزىنىڭ ھامىلىدار بولغىنىنى كۆرگەندە مەن ئۇنىڭ نەزىرىدە كۆزگە ئىلىنمىدىم. خەير، پەرۋەردىگار سەن بىلەن مېنىڭ ئوتتۇرىمىزدا ھۆكۈم چىقارسۇن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ئابرام سارايغا: ــ مانا، دېدىكىڭ ئۆز قولۇڭدىدۇر؛ ساڭا نېمە لايىق كۆرۈنسە ئۇنىڭغا شۇنى قىلغىن، ــ دېدى. بۇنىڭ بىلەن ساراي ئۇنىڭغا قاتتىقلىق قىلىشقا باشلىدى؛ بۇنىڭ بىلەن ئۇ ئۇنىڭ ئالدىدىن قېچىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ئەمما پەرۋەردىگارنىڭ پەرىشتىسى ئۇنى چۆلدىكى بىر بۇلاقنىڭ يېنىدا، يەنى شۇر يولىنىڭ بويىدىكى بۇلاقنىڭ يېنىدىن تېپىپ، ئۇنىڭغا: ");
INSERT INTO uigara_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ئەي ساراينىڭ دېدىكى ھەجەر، نەدىن كەلدىڭ، نەگە بارىسەن؟ ــ دەپ سورىدى. ئۇ جاۋاب بېرىپ: ــ مەن خوجايىنىم ساراينىڭ ئالدىدىن قېچىپ چىقتىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","پەرۋەردىگارنىڭ پەرىشتىسى ئۇنىڭغا: ــ ئايال خوجايىنىڭنىڭ قېشىغا قايتىپ بېرىپ، ئۇنىڭ قول ئاستىدا بول، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","پەرۋەردىگارنىڭ پەرىشتىسى ئۇنىڭغا يەنە: ــ سېنىڭ نەسلىڭنى شۇنداق ئاۋۇتىمەنكى، كۆپلۈكىدىن ئۇنى ساناپ بولغىلى بولمايدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ئاندىن پەرۋەردىگارنىڭ پەرىشتىسى ئۇنىڭغا: مانا، سەن ھامىلىدارسەن؛ سەن بىر ئوغۇل تۇغۇپ، ئۇنىڭغا ئىسمائىل دەپ ئات قويغىن؛ چۈنكى پەرۋەردىگار سېنىڭ جەبىر-جاپايىڭنى ئاڭلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ئۇ ياۋا ئېشەك كەبى بىر ئادەم بولىدۇ؛ ئۇنىڭ قولى ھەر ئادەمگە قارشى ئۇزىتىلىدۇ، شۇنىڭدەك ھەر ئادەمنىڭ قولى ئۇنىڭغا قارشى ئۇزىتىلىدۇ؛ ئۇ قېرىنداشلىرىنىڭ ئۇدۇلىدا ئايرىم تۇرىدۇ، دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ھەجەر ئۆز-ئۆزىگە: «مەن مۇشۇ يەردە مېنى كۆرگۈچىنى ئارقىسىدىن كۆردۈم» دەپ، ئۆزىگە سۆز قىلغان پەرۋەردىگارنى: «سەن مېنى كۆرگۈچى تەڭرىدۇرسەن» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","شۇنىڭ بىلەن ئۇ قۇدۇق: «بەئەر-لاھاي-روي» دەپ ئاتالدى. ئۇ قادەش بىلەن بەرەد شەھىرىنىڭ ئارىلىقىدىدۇر.    ");
INSERT INTO uigara_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ھەجەر ئابرامغا بىر ئوغۇل تۇغۇپ بەردى. ئابرام ھەجەر ئۇنىڭغا تۇغۇپ بەرگەن ئوغلىغا ئىسمائىل دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ھەجەر ئابرامغا ئىسمائىلنى تۇغۇپ بەرگەندە ئابرام سەكسەن ئالتە ياشتا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ئابرام توقسان توققۇز ياشقا كىرگەندە، پەرۋەردىگار ئابرامغا كۆرۈنۈپ ئۇنىڭغا: ــ مەن قادىر تەڭرىدۇرمەن. سەن مېنىڭ ئالدىمدا مېڭىپ، كامىل بولغىن.    ");
INSERT INTO uigara_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","مەن ئۆزۈم بىلەن سېنىڭ ئاراڭدا ئەھدەمنى بېكىتىپ، سېنى ئىنتايىن زور كۆپەيتىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ئابرام ئۆزىنى تاشلاپ يۈزىنى يەرگە يېقىپ ياتتى؛ خۇدا ئۇنىڭ بىلەن يەنە سۆزلىشىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","ئۆزۈمگە كەلسەم، مانا، مېنىڭ ئەھدەم سەن بىلەن تۈزۈلگەندۇر: ــ سەن نۇرغۇن ئەل-مىللەتلەرنىڭ ئاتىسى بولىسەن.    ");
INSERT INTO uigara_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","شۇنىڭ ئۈچۈن سېنىڭ ئىسمىڭ بۇنىڭدىن كېيىن ئابرام ئاتالمايدۇ، بەلكى ئىسمىڭ ئىبراھىم بولىدۇ؛ چۈنكى مەن سېنى نۇرغۇن ئەل-مىللەتلەرنىڭ ئاتىسى قىلدىم. ");
INSERT INTO uigara_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","مەن سېنى ئىنتايىن زور كۆپەيتىمەن؛ شۇنىڭ بىلەن سەندىن كۆپ ئەل-قوۋملارنى پەيدا قىلىمەن، پۇشتۇڭدىن پادىشاھلار چىقىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","مەن سەن ۋە سەندىن كېيىنكى نەسلىڭنىڭ خۇداسى بولۇش ئۈچۈن ئۆزۈم سەن ۋە سەندىن كېيىنكى نەسلىڭنىڭ ئارىسىدا ئەبەدىي ئەھدە سۈپىتىدە بۇ ئەھدەمنى تىكلەيمەن؛ ");
INSERT INTO uigara_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","مەن ساڭا ۋە سەندىن كېيىنكى نەسلىڭگە سەن ھازىر مۇساپىر بولۇپ تۇرغان بۇ زېمىننى، يەنى پۈتكۈل قانائان زېمىنىنى ئەبەدىي بىر مۈلۈك سۈپىتىدە ئاتا قىلىمەن؛ ۋە مەن ئۇلارنىڭ خۇداسى بولىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ئاندىن خۇدا ئىبراھىمغا يەنە: ــ سەن ئۆزۈڭ مېنىڭ ئەھدەمنى تۇتقىن، ئۆزۈڭ ۋە سەندىن كېيىنكى نەسلىڭمۇ ئەۋلادتىن-ئەۋلادقا بۇنى تۇتۇشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","مەن سەن بىلەن ۋە سەندىن كېيىنكى نەسلىڭ بىلەن تۈزگەن، سىلەرنىڭ تۇتۇشۇڭلار كېرەك بولغان ئەھدەم شۇكى، ئاراڭلاردىكى ھەربىر ئەركەك خەتنە قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","شۇنىڭ بىلەن سىلەر خەتنىلىكىڭلارنى كېسىۋېتىشىڭلار كېرەك؛ بۇ مەن بىلەن سىلەرنىڭ ئاراڭلاردىكى ئەھدىنىڭ بەلگىسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","بارلىق ئەۋلادلىرىڭلار، نەسىلدىن-نەسىلگە ئاراڭلاردا، مەيلى ئۆيدە تۇغۇلغانلار بولسۇن، ياكى ئەۋلادىڭلاردىن بولماي ياتلاردىن پۇلغا سېتىۋېلىنغانلار بولسۇن، ھەممە ئەركەك سەككىز كۈنلۈك بولغاندا خەتنە قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ئۆيۈڭدە تۇغۇلغانلار بىلەن پۇلۇڭغا سېتىۋالغانلارنىڭ ھەممىسى خەتنە قىلىنىشى كېرەك. شۇنداق قىلغاندا، مېنىڭ ئەھدەم تەنلىرىڭلاردا ئورناپ، ئەبەدىي بىر ئەھدە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","لېكىن خەتنىلىكى تۇرۇپ، تېخى خەتنە قىلىنمىغان ھەربىر ئەركەك مېنىڭ ئەھدەمنى بۇزغان ھېسابلىنىپ، ئۈزۈپ تاشلىنىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","خۇدا ئىبراھىمغا يەنە سۆز قىلىپ: ــ ئايالىڭ ساراينى ئەمدى ساراي دەپ ئاتىمىغىن، بەلكى ئىسمى ساراھ بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","مەن ئۇنىڭغا بەخت-بەرىكەت بېرىپ، ئۇنىڭدىنمۇ ساڭا بىر ئوغۇل بېرىمەن. مەن دەرۋەقە ئۇنى بەرىكەتلەيمەن؛ شۇنىڭ بىلەن ئۇ ئەل-مىللەتلەرنىڭ ئانىسى بولىدۇ؛ خەلقلەرنىڭ پادىشاھلىرىمۇ ئۇنىڭدىن چىقىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ئىبراھىم يەنە ئۆزىنى يەرگە ئېتىپ دۈم يېتىپ كۈلۈپ كەتتى ۋە كۆڭلىدە: «يۈز ياشقا كىرگەن ئادەممۇ بالىلىق بولالارمۇ؟ توقسان ياشقا كىرگەن ساراھمۇ بالا تۇغارمۇ؟!»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ئىبراھىم خۇداغا: ــ ئاھ، ئىسمائىل ئالدىڭدا ياشىسا ئىدى! دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","خۇدا ئۇنىڭغا: ــ ياق، ئايالىڭ ساراھ جەزمەن ساڭا بىر ئوغۇل تۇغۇپ بېرىدۇ. سەن ئۇنىڭغا «ئىسھاق» دەپ ئات قويغىن. مەن ئۇنىڭ بىلەن ئۆز ئەھدەمنى تۈزىمەن؛ بۇ ئۇنىڭدىن كېيىن كېلىدىغان نەسلى بىلەن باغلىغان ئەبەدىي بىر ئەھدە سۈپىتىدە بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ئىسمائىلغا كەلسەك، ئۇنىڭ توغرىسىدىكى دۇئايىڭنى ئاڭلىدىم. مانا، مەن ئۇنى بەرىكەتلەپ، نەسلىنى كۆپەيتىپ، ئىنتايىن زور ئاۋۇتىمەن. ئۇنىڭ پۇشتىدىن ئون ئىككى ئەمىر چىقىدۇ؛ مەن ئۇنى ئۇلۇغ بىر خەلق قىلىمەن.    ");
INSERT INTO uigara_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","بىراق ئەھدەمنى بولسا مەن كېلەر يىلى دەل مۇشۇ ۋاقىتتا ساراھ ساڭا تۇغۇپ بېرىدىغان ئوغۇل ــ ئىسھاق بىلەن تۈزىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","خۇدا ئىبراھىم بىلەن سۆزلىشىپ بولۇپ، ئۇنىڭ يېنىدىن يۇقىرىغا چىقىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","شۇنىڭ بىلەن شۇ كۈنىلا ئىبراھىم ئۆز ئوغلى ئىسمائىلنى، ئۆز ئۆيىدە تۇغۇلغانلار ۋە پۇلغا سېتىۋالغانلارنىڭ ھەممىسىنى، يەنى ئۇنىڭ ئۆيىدىكى بارلىق ئەركەكلەرنى ئېلىپ، خۇدا ئۇنىڭغا ئېيتقاندەك ئۇلارنىڭ خەتنىلىكىنى كېسىپ خەتنە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ئىبراھىمنىڭ خەتنىلىكى كېسىلىپ، خەتنە قىلىنغاندا، توقسان توققۇز ياشقا كىرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ئۇنىڭ ئوغلى ئىسمائىلنىڭ خەتنىلىكى كېسىلىپ، خەتنە قىلىنغاندا، ئون ئۈچ ياشتا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN17_26‏","002_17_26‏","GEN","17","26‏","27","ئىبراھىم بىلەن ئۇنىڭ ئوغلى ئىسمائىل دەل شۇ كۈننىڭ ئۆزىدە خەتنە قىلىندى ۋە شۇنداقلا ئۇنىڭ ئۆيىدىكى ھەممە ئەر كىشىلەر، مەيلى ئۆيىدە تۇغۇلغان بولسۇن ياكى ياتتىن پۇلغا سېتىۋېلىنغانلار بولسۇن، ھەممىسى ئۇنىڭ بىلەن بىللە خەتنە قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","پەرۋەردىگار مامرەدىكى دۇبزارلىقنىڭ يېنىدا ئىبراھىمغا كۆرۈندى؛ بۇ كۈن ئەڭ ئىسسىغان ۋاقىت بولۇپ، ئۇ ئۆز چېدىرىنىڭ ئىشىكىدە ئولتۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ئۇ بېشىنى كۆتۈرۈپ نەزەر سېلىۋىدى، مانا ئۇنىڭ ئۇدۇلىدا ئۈچ كىشى ئۆرە تۇراتتى. ئۇلارنى كۆرۈپ ئۇ چېدىرىنىڭ ئىشىكىدىن قوپۇپ، ئۇلارنىڭ ئالدىغا يۈگۈرۈپ بېرىپ، يەرگە تەگكۈدەك تەزىم قىلىپ: ");
INSERT INTO uigara_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ــ ئى رەببىم، ئەگەر پېقىر نەزەرلىرىدە ئىلتىپات تاپقان بولسام، ئۆتۈنىمەنكى، قۇللىرىنىڭ يېنىدىن ئۆتۈپ كەتمىگەيلا؛ ");
INSERT INTO uigara_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ئازغىنا سۇ كەلتۈرۈلسۇن، سىلەر پۇتلىرىڭلارنى يۇيۇپ دەرەخنىڭ تېگىدە ئارام ئېلىۋېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","سىلەر ئۆز قۇلۇڭلارنىڭ يېنىدىن ئۆتكەنىكەنسىلەر، مەن بىر چىشلەم نان ئېلىپ چىقاي، سىلەر ھاردۇقۇڭلارنى چىقىرىپ، ئاندىن ئۆتۈپ كەتكەيسىلەر، دېدى. ئۇلار جاۋاب بېرىپ: ــ ئېيتقىنىڭدەك قىلغىن، دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ئىبراھىم چېدىرىغا ساراھنىڭ قېشىغا يۈگۈرۈپ كىرىپ، ئۇنىڭغا: ــ ئۈچ داس ئېسىل ئۇندىن تېز خېمىر يۇغۇرۇپ توقاچ ئەتكىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ئاندىن ئىبراھىم كالا پادىسىغا يۈگۈرۈپ بېرىپ، يۇمران ئوبدان بىر موزاينى تاللاپ، چاكىرىغا تاپشۇردى؛ ئۇ بۇنى تېزلا تەييار قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_8‏","002_18_8‏","GEN","18","8‏","9","ئاندىن ئىبراھىم سېرىق ماي، سۈت ۋە تەييارلاتقان موزاينى ئېلىپ كېلىپ، ئۇلارنىڭ ئالدىغا تۇتۇپ، ئۆزى دەرەخنىڭ تېگىدە ئۇلارنىڭ ئالدىدا ئۆرە تۇردى؛ ئۇلار ئۇلاردىن يېدى. ئۇلار ئۇنىڭدىن: ئايالىڭ ساراھ نەدە، دەپ سورىۋىدى، ئۇ جاۋاب بېرىپ: ــ مانا، چېدىردا، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","بىرسى: ــ مەن كېلەر يىلى مۇشۇ ۋاقىتتا قېشىڭغا جەزمەن قايتىپ كېلىمەن، ۋە مانا ئۇ ۋاقىتتا ئايالىڭ ساراھنىڭ بىر ئوغلى بولىدۇ، ــ دېدى. ساراھ بولسا ئۇنىڭ كەينىدىكى چېدىرنىڭ ئىشىكىدە تۇرۇپ، بۇلارنى ئاڭلاۋاتاتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ئىبراھىم بىلەن ساراھ ئىككىسى ياشىنىپ، قېرىپ قالغانىدى؛ ساراھتا ئايال كىشىلەردە بولىدىغان ئادەت كۆرۈش توختاپ قالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","شۇڭا ساراھ ئۆز ئىچىدە كۈلۈپ: ــ مەن شۇنچە قېرىپ كەتكەن تۇرسام، راستتىنلا لەززەت كۆرەلەرمەنمۇ؟ ئېرىممۇ قېرىپ كەتكەن تۇرسا؟ ــ دەپ خىيال قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","پەرۋەردىگار ئىبراھىمغا: ــ ساراھنىڭ: «مەن قېرىپ كەتكەن تۇرسام، راستتىنلا بالا تۇغارمەنمۇ؟» دەپ كۈلگىنى نېمىسى؟ ");
INSERT INTO uigara_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","پەرۋەردىگارغا مۇمكىن بولمايدىغان تىلسىمات ئىش بارمۇ؟ بېكىتكەن ۋاقىتتا، يەنى كېلەر يىلى دەل بۇ چاغدا قايتىپ كېلىمەن ۋە ئۇ ۋاقىتتا ساراھنىڭ بىر ئوغلى بولىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ئەمما ساراھ قورقۇپ كېتىپ: ــ كۈلمىدىم، دەپ ئىنكار قىلدى. لېكىن ئۇ: ــ ياق، سەن كۈلدۈڭ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ئاندىن بۇ زاتلار ئۇ يەردىن قوپۇپ، سودوم تەرەپكە نەزىرىنى ئاغدۇردى. ئىبراھىممۇ ئۇلارنى ئۇزىتىپ، ئۇلار بىلەن بىللە ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","پەرۋەردىگار: ــ مەن قىلىدىغان ئىشىمنى ئىبراھىمدىن يوشۇرسام بولامدۇ؟ ");
INSERT INTO uigara_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","چۈنكى ئىبراھىمدىن ئۇلۇغ ۋە كۈچلۈك بىر ئەل چىقىدۇ ۋە شۇنىڭدەك يەر يۈزىدىكى بارلىق ئەل-مىللەتلەر ئۇ ئارقىلىق بەخت-بەرىكەتكە مۇيەسسەر بولىدىغان تۇرسا؟ ");
INSERT INTO uigara_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","چۈنكى مەن ئۇنى بىلىپ تاللىغانمەن؛ ئۇ چوقۇم ئۆز بالىلىرىنى ۋە ئۇنىڭ ئۆيىدىكىلەرنى ئۆزىگە ئەگەشتۈرۈپ، ئۇلارغا پەرۋەردىگارنىڭ يولىنى تۇتۇپ، ھەققانىيلىقنى ۋە ئادالەتنى يۈرگۈزۈشنى ئۆگىتىدۇ. بۇنىڭ بىلەن مەنكى پەرۋەردىگار ئىبراھىم توغرۇلۇق قىلغان ۋەدەمنى ئەمەلگە ئاشۇرىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ئاندىن پەرۋەردىگار مۇنداق دېدى: ــ «سودوم ۋە گوموررا توغرۇلۇق كۆتۈرۈلگەن داد-پەرياد ناھايىتى كۈچلۈك، ئۇلارنىڭ گۇناھى ئىنتايىن ئېغىر بولغىنى ئۈچۈن، ");
INSERT INTO uigara_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","مەن ھازىرلا چۈشىمەن، قىلمىشلىرى راستتىنلا شۇ داد-پەريادلاردىن ماڭا مەلۇم بولغاندەك شۇنچە رەزىلمۇ، بىلىپ باقاي؛ ئۇنچە رەزىل بولمىغاندىمۇ، مەن ئۇنى بىلىشىم كېرەك». ");
INSERT INTO uigara_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","شۇنىڭ بىلەن بۇ كىشىلەر ئۇ يەردىن قوزغىلىپ، سودوم تەرەپكە يول ئالدى. لېكىن ئىبراھىم يەنىلا پەرۋەردىگارنىڭ ئالدىدا ئۆرە تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ئىبراھىم يېقىن بېرىپ: ــ سەن راستتىنلا ھەققانىيلارنى رەزىللەر بىلەن قوشۇپ ھالاك قىلامسەن؟ ");
INSERT INTO uigara_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","شەھەردە ئەللىك ھەققانىي كىشى بار بولۇشى مۇمكىن؛ سەن راستتىنلا شۇ جاينى ھالاك قىلامسەن، ئەللىك ھەققانىي كىشى ئۈچۈن ئۇ جاينى كەچۈرۈم قىلمامسەن؟ ");
INSERT INTO uigara_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ياق، ياق! بۇ ئىش سەندىن نېرى بولغاي! ھەققانىيلارنى رەزىللەرگە قوشۇپ ئۆلتۈرۈپ، ھەققانىيلارغا رەزىللەرگە ئوخشاش مۇئامىلە قىلىش سەندىن نېرى بولغاي! پۈتكۈل جاھاننىڭ سوراقچىسى ئادالەت يۈرگۈزمەمدۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","پەرۋەردىگار جاۋاب بېرىپ: ــ ئەگەر مەن سودوم شەھىرىدە ئەللىك ھەققانىينى تاپسام، ئۇلار ئۈچۈن پۈتكۈل جاينى ئاياپ قالىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ئاندىن ئىبراھىم جاۋاب بېرىپ: ــ مانا مەن پەقەت توپا بىلەن كۈلدىن ئىبارەت بولساممۇ، مەن ئىگەم بىلەن سۆزلەشكىلى يەنە پېتىنالىدىم. ");
INSERT INTO uigara_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","مۇبادا شۇ ئەللىك ھەققانىيدىن بەش كىشى كەم بولسا، سەن بۇ بەش كىشىنىڭ كەم بولغىنى ئۈچۈن پۈتكۈل شەھەرنى يوقىتامسەن؟ ــ دېدى. ئۇ: ــ ئەگەر مەن شۇ يەردە قىرىق بەشنى تاپساممۇ، ئۇنى يوقاتمايمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ئىبراھىم ئۇنىڭغا سۆزىنى داۋام قىلىپ: ــ شۇ يەردە قىرىق كىشىلا تېپىلىشى مۇمكىن، دېۋىدى، پەرۋەردىگار: ــ بۇ قىرىقى ئۈچۈن ئۇنى يوقاتمايمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ئۇ يەنە سۆز قىلىپ: ئى ئىگەم، خاپا بولمىغايسەن، مەن يەنە سۆز قىلاي. شۇ يەردە ئوتتۇزى تېپىلىشى مۇمكىن؟ ــ دېدى. ئۇ: ــ ئەگەر مەن ئۇ يەردە ئوتتۇزنى تاپساممۇ، يوقاتمايمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ئۇ يەنە سۆز قىلىپ: ــ مانا ئەمدى مەن ئىگەم بىلەن سۆزلەشكىلى جۈرئەت قىلدىم؛ شۇ يەردە يىگىرمىسى تېپىلىشى مۇمكىن، ــ دېدى. پەرۋەردىگار سۆز قىلىپ: بۇ يىگىرمىسى ئۈچۈن ئۇ يەرنى يوقاتمايمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ئۇ سۆزلەپ: ــ ئى ئىگەم، خاپا بولمىغاي، مەن پەقەت مۇشۇ بىر قېتىملا سۆز قىلاي! شۇ يەردە ئونى تېپىلىشى مۇمكىن، دېۋىدى، ئۇ جاۋاب بېرىپ: ــ مەن ئونى ئۈچۈن ئۇنى يوقاتمايمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","پەرۋەردىگار ئىبراھىم بىلەن سۆزلىشىپ بولغاندىن كېيىن كەتتى؛ ئىبراھىممۇ ئۆز جايىغا قايتىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ئىككى پەرىشتە كەچتە سودومغا يېتىپ كەلدى؛ شۇ چاغدا لۇت سودومنىڭ دەرۋازىسىدا ئولتۇراتتى. لۇت ئۇلارنى كۆرۈپلا ئورنىدىن تۇرۇپ، ئالدىغا چىقىپ يۈزى يەرگە تەگكۈدەك تەزىم قىلىپ: ");
INSERT INTO uigara_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ــ مانا، ئەي خوجىلىرىم، كەمىنىلىرىنىڭ ئۆيىگە چۈشۈپ پۇتلىرىڭلارنى يۇيۇپ قونۇپ قالغايسىلەر؛ ئاندىن ئەتە سەھەر قوپۇپ يولغا چىقساڭلارمۇ بولىدۇ، دېۋىدى، بۇلار جاۋابەن: ــ ياق، بىز شەھەر مەيدانىدا كەچلەيمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ئەمما ئۇ ئۇلارنى چىڭ تۇتۇۋىدى، ئاخىر ئۇلار ئۇنىڭ بىلەن بېرىپ ئۆيىگە كىردى. ئۇ ئۇلارغا داستىخان سېلىپ، پېتىر توقاچلارنى پىشۇرۇپ بەردى، ئۇلار غىزالاندى. ");
INSERT INTO uigara_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ئۇلار تېخى ياتمىغانىدى، شەھەردىكىلەر، يەنى سودومنىڭ ئەركەكلىرى، ياش، قېرى ھەممىسى ھەرقايسى مەھەللىلەردىن كېلىپ ئۆينى قورشىۋالدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ئۇلار لۇتنى چاقىرىپ ئۇنىڭغا: ــ بۈگۈن كەچتە سېنىڭكىگە كىرگەن ئادەملەر قېنى؟ ئۇلارنى بىزگە چىقىرىپ بەر، بىز ئۇلار بىلەن يېقىنچىلىق قىلىمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","لۇت دەرۋازىنىڭ ئالدىغا، ئۇلارنىڭ قېشىغا چىقىپ، ئىشىكنى يېپىۋېتىپ، ");
INSERT INTO uigara_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ئۇلارغا: ــ ئەي بۇرادەرلىرىم، مۇنداق رەزىللىكنى قىلماڭلار! ");
INSERT INTO uigara_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","مانا، تېخى ھېچ ئەر بىلەن بىللە بولمىغان ئىككى قىزىم بار؛ ئۇلارنى سىلەرگە چىقىرىپ بېرەي. ئۇلار بىلەن خالىغىنىڭلارنى قىلىڭلار. ئەمما بۇ ئادەملەر ئۆگزەمنىڭ سايىسى ئاستىغا كىرگەنىكەن، سىلەر ئۇلارنى ھېچنېمە قىلماڭلار! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","لېكىن ئۇلار جاۋاب بېرىپ: «نېرى تۇر!» دېگىنىچە، يەنە: ــ بۇ يەردە تۇرۇشقا كەلگەن بۇ مۇساپىر ھاكىم بولماقچىمىكەن؟ ئەمدى ساڭا ئۇلارغا قىلغاندىنمۇ بەتتەر يامانلىق قىلىمىز! ــ دەپ لۇتنى قىستاپ، ئىشىكنى چېقىشقا باستۇرۇپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ئەمما ئۇ ئىككى كىشى قوللىرىنى ئۇزىتىپ لۇتنى ئۆيگە ئۆز قېشىغا تارتىپ ئەكىرىۋېلىپ، ئىشىكنى تاقىۋالدى ");
INSERT INTO uigara_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ۋە ئۆينىڭ دەرۋازىسىنىڭ ئالدىدىكى ئادەملەرنى كىچىكىدىن تارتىپ چوڭىغىچە كورلۇققا مۇپتىلا قىلدى؛ شۇنىڭ بىلەن ئۇلار دەرۋازىنى ئىزدەپ، ھالىدىن كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ئاندىن ئىككەيلەن لۇتقا: ــ مۇشۇ يەردە يەنە بىرەر كىمىڭ بارمۇ؟ كۈيئوغۇل، ئوغۇل ياكى قىزلىرىڭ ۋە ياكى شەھەردە باشقا ئادەملىرىڭ بولسا ئۇلارنى بۇ يەردىن ئېلىپ كەتكىن! ");
INSERT INTO uigara_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","چۈنكى بىز بۇ يەرنى يوقىتىمىز؛ چۈنكى ئۇلار توغرۇلۇق كۆتۈرۈلگەن داد-پەرياد پەرۋەردىگارنىڭ ئالدىدا ئىنتايىن كۈچلۈك بولغاچ، پەرۋەردىگار بىزنى ئۇنى يوقىتىشقا ئەۋەتتى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","شۇنىڭ بىلەن لۇت تاشقىرىغا چىقىپ، قىزلىرىنى ئالىدىغان بولغۇسى كۈيئوغۇللىرىنىڭ قېشىغا بېرىپ: «ئەمدى قوپۇپ بۇ يەردىن چىقىپ كېتىڭلار؛ چۈنكى پەرۋەردىگار شەھەرنى يوقىتىدۇ» ــ دېدى. ئەمما ئۇ بولغۇسى كۈيئوغۇللىرىنىڭ نەزىرىگە چاقچاق قىلغاندەك كۆرۈندى. ");
INSERT INTO uigara_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","تاڭ ئاتقاندا، پەرىشتىلەر لۇتنى ئالدىرىتىپ: ــ ئەمدى قوپۇپ ئايالىڭ بىلەن قېشىڭدىكى ئىككى قىزىڭنى ئالغىن؛ بولمىسا شەھەرنىڭ قەبىھلىكىگە چېتىلىپ قېلىپ، ھالاك بولىسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ئەمما ئۇ تېخىچە ئارىسالدى بولۇپ تۇرغاندا، پەرۋەردىگار ئۇنىڭغا رەھىم قىلغانلىقى ئۈچۈن، ئۇ ئىككىيلەن لۇتنىڭ قولىنى، ئايالىنىڭ قولىنى ۋە ئىككى قىزىنىڭ قوللىرىنى تۇتۇپ، ئۇلارنى شەھەرنىڭ سىرتىغا ئەچىقىپ، ئورۇنلاشتۇرۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ئۇلارنى چىقارغاندىن كېيىن شۇ ئىش بولدىكى، ئۇلاردىن بىرى ئۇنىڭغا: ــ جېنىڭنى ئېلىپ قاچ، ھالاك بولماسلىقىڭ ئۈچۈن كەينىڭگە قارىماي، تۈزلەڭلىكتىكى ھېچ يەردە توختىماي، تاغقا قاچقىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","لېكىن لۇت ئۇلارغا: ــ ئۇنداق بولمىغاي، ئەي خوجام، ئۆتۈنۈپ قالاي! ");
INSERT INTO uigara_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","مانا، كەمىنەڭ كۆزۈڭدە ئىلتىپات تاپتى، جېنىمنى قۇتقۇزدۇڭ، ماڭا زور مەرھەمەت كۆرسەتتىڭ؛ ئەمما مەن تاغقا قاچالمايمەن؛ ئۇنداق قىلسام، ماڭا بىرەر ئاپەت چۈشۈپ، ئۆلۈپ كېتەرمەنمىكىن. ");
INSERT INTO uigara_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","قارا، ئاۋۇ شەھەرگە قېچىپ بارسا بولغۇدەك ناھايىتى يېقىن ئىكەن، شۇنداقلا كىچىك شەھەر ئىكەن! ئۆتۈنۈپ قالاي، مېنىڭ شۇ يەرگە قېچىشىمغا يول قويغايسەن! ئۇ كىچىك شەھەر ئەمەسمۇ؟! جېنىم شۇ يەردە ئامان قالىدۇ! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","پەرىشتە ئۇنىڭغا جاۋاب بېرىپ: ــ خەير، بۇ ئىشتىمۇ ساڭا ماقۇل بولاي، سەن ئېيتقان شۇ شەھەرنى ۋەيران قىلماي. ");
INSERT INTO uigara_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ئەمدى ئۇ يەرگە تېزدىن قېچىپ بارغىن؛ چۈنكى سەن شۇ يەرگە يېتىپ بارمىغۇچە ھېچ ئىش قىلالماسمەن، ــ دېدى. شۇڭا ئۇ شەھەرنىڭ ئىسمى «زوئار» دەپ ئاتالغان. ");
INSERT INTO uigara_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","لۇت زوئارغا يېتىپ بارغاندا كۈن نۇرى يەر يۈزىگە چېچىلغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","شۇ چاغدا پەرۋەردىگار پەرۋەردىگاردىن سودوم بىلەن گوموررانىڭ ئۈستىگە ئەرشتىن گۈڭگۈرت ۋە ئوت ياغدۇرۇپ،    ");
INSERT INTO uigara_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","شۇ شەھەرلەرنى، پۈتكۈل تۈزلەڭلىكنى ھەمدە شەھەرلەردىكى بارلىق ئاھالىلەر ۋە يەردىن ئۈنگەنلەرنى قوشۇپ بەربات قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","لېكىن لۇتنىڭ ئارقىسىدىن ماڭغان ئايالى كەينىگە قارىۋىدى، تۇز تۈۋرۈككە ئايلىنىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ئەتىسى تاڭ سەھەردە، ئىبراھىم قوپۇپ ئىلگىرى پەرۋەردىگارنىڭ ئالدىدا تۇرغان جايغا چىقىپ، ");
INSERT INTO uigara_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","سودوم بىلەن گوموررا تەرەپكە، شۇنداقلا تۈزلەڭلىكنىڭ ھەممە يېرىگە نەزەر سېلىۋىدى، مانا، يەر يۈزىدىن خۇمداننىڭ تۈتۈنىدەك تۈتۈن ئۆرلەۋاتقىنىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ئەمما شۇنداق بولدىكى، خۇدا ئۇ تۈزلەڭلىكتىكى شەھەرلەرنى ۋەيران قىلغاندا، ئۇ ئىبراھىمنى ئېسىگە ئېلىپ، لۇت تۇرغان شەھەرلەرنى بەربات قىلغاندا ئۇنى بالايىئاپەتنىڭ ئىچىدىن چىقىرىپ قۇتقۇزدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ئەمما لۇت زوئار شەھىرىدە تۇرۇشتىن قورققاچقا، زوئاردىن كېتىپ، تاغقا چىقىپ، ئىككى قىزى بىلەن شۇ يەردە ماكانلاشتى. ئۇ ئىككى قىزى بىلەن بىر ئۆڭكۈردە تۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ئەمدى چوڭ قىز كىچىكىگە: ــ ئاتىمىز بولسا قېرىپ كەتتى؛ دۇنيانىڭ قائىدە-يوسۇنى بويىچە بۇ يۇرتتا بىزگە يېقىنچىلىق قىلىدىغان ھېچ ئەر كىشى قالمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","قېنى، ئاتىمىزنى شاراب بىلەن مەست قىلىپ قويۇپ، ئۇنىڭ بىلەن بىللە ياتايلى؛ شۇنداق قىلساق، بىز پەرزەنت كۆرۈپ ئاتىمىزنىڭ ئۇرۇقىنى قالدۇرالايمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","شۇنىڭ بىلەن ئۇلار ئۇ كېچىسى ئاتىسىغا شاراب ئىچكۈزۈپ مەست قىلىپ قويۇپ، چوڭ قىزى كىرىپ ئاتىسى بىلەن ياتتى. لېكىن لۇت ئۇنىڭ كىرىپ ياتقىنىنىمۇ، قوپۇپ كەتكىنىنىمۇ ھېچ سەزمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ئەتىسى شۇنداق بولدىكى، چوڭى كىچىكىگە: ــ مانا، مەن ئاخشام ئاتام بىلەن ياتتىم؛ بۈگۈن كەچتىمۇ ئۇنىڭغا يەنە شاراب ئىچكۈزەيلى؛ شۇنىڭ بىلەن سەن كىرىپ ئۇنىڭ بىلەن ياتقىن؛ شۇنداق قىلىپ، ھەر ئىككىمىز پەرزەنت كۆرۈپ ئاتىمىزنىڭ نەسلىنى قالدۇرالايمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","شۇنىڭ بىلەن ئۇلار ئۇ كېچىسى ئاتىسىغا شاراب ئىچكۈزۈپ مەست قىلىپ قويۇپ، كىچىك قىزى ئورنىدىن تۇرۇپ ئۇنىڭ بىلەن بىللە ياتتى. ئەمما لۇت ئۇنىڭ كىرىپ ياتقىنىنىمۇ، قوپۇپ كەتكىنىنىمۇ ھېچ سەزمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","شۇنداق قىلىپ، لۇتنىڭ ئىككىلا قىزى ئۆز ئاتىسىدىن ھامىلىدار بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","چوڭى بولسا ئوغۇل تۇغۇپ، ئۇنىڭ ئېتىنى موئاب قويدى؛ ئۇ بۈگۈنكى موئابىيلارنىڭ ئاتىسىدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","كىچىكىمۇ ئوغۇل تۇغۇپ، ئۇنىڭ ئېتىنى بەن-ئاممى قويدى. ئۇ بۈگۈنكى ئاممونىيلارنىڭ ئاتىسىدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ئىبراھىم ئۇ يەردىن چىقىپ، جەنۇب تەرەپتىكى نەگەۋگە كۆچۈپ كېلىپ، قادەش بىلەن شۇرنىڭ ئارىلىقىدا تۇرۇپ قالدى؛ بىر مەزگىلدىن كېيىن گەراردا ئولتۇراقلاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","شۇ يەردە ئىبراھىم ئايالى ساراھ توغرىسىدا: «ئۇ مېنىڭ سىڭلىمدۇر»، دېگەنىدى. شۇنىڭ بىلەن گەرارنىڭ پادىشاھى ئابىمەلەك ئادەم ئەۋەتىپ، ساراھنى ئۆزىگە خوتۇن بولۇشقا ئېلىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","لېكىن بىر كۈنى كېچىسى چۈشىدە خۇدا ئابىمەلەككە كېلىپ ئۇنىڭغا: ــ مانا، سەن ئۆزۈڭگە ئېلىۋالغان ئايال سەۋەبىدىن ئەمدى ئۆلگەن ئادەمدۇرسەن؛ چۈنكى ئۇ باشقا بىرسىنىڭ ئايالىدۇر ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ئەمما ئابىمەلەك ئۇنىڭغا تېخى يېقىنچىلىق قىلمىغانىدى. ئۇ خۇداغا: ــ ئى رەب، ھەققانىي بىر خەلقنىمۇ ھالاك قىلامسەن؟ ");
INSERT INTO uigara_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ئۇ ئۆزىمۇ ماڭا: «ئۇ مېنىڭ سىڭلىم» دەپ ئېيتمىدىمۇ؟ يەنە كېلىپ، بۇ ئايالمۇ «ئۇ مېنىڭ ئاكام»، دەپ ئېيتقانىدى. مەن بولسام ساپ كۆڭلۈم ۋە دۇرۇس نىيىتىم بىلەن بۇ ئىشنى قىلدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","خۇدا چۈشىدە ئۇنىڭغا يەنە: ــ بۇ ئىشنى ساپ كۆڭۈل بىلەن قىلغىنىڭنى بىلىمەن؛ شۇ سەۋەبتىن مەن سېنى ئالدىمدا گۇناھ قىلىشتىن توسۇپ، ئۇنىڭغا تېگىشىڭگە قويمىدىم. ");
INSERT INTO uigara_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ئەمدى ئۇ كىشىنىڭ ئايالىنى ئۆزىگە قايتۇرۇپ بەر؛ چۈنكى ئۇ پەيغەمبەر، ئۇ سېنىڭ ھەققىڭدە دۇئا قىلىدۇ ۋە سەن تىرىك قالىسەن. ئەگەر ئۇنى ياندۇرۇپ بەرمىسەڭ شۇنى بىلىپ قويغىنكى، سەن ۋە ھەممە ئادەملىرىڭ قوشۇلۇپ جەزمەن ئۆلىسىلەر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ئابىمەلەك ئەتىگەن تاڭ سەھەردە قوپۇپ، ھەممە خىزمەتكارلىرىنى چاقىرىپ، بۇ سۆزلەرنىڭ ھەممىسىنى ئۇلارنىڭ قۇلاقلىرىغا سالدى؛ بۇ ئادەملەر ناھايىتى قورقۇشۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ئاندىن ئابىمەلەك ئىبراھىمنى چاقىرىپ ئۇنىڭغا: ــ بۇ بىزگە نېمە قىلغىنىڭ؟ مەن ساڭا زادى نېمە گۇناھ قىلدىم، سەن مەن ۋە پادىشاھلىقىمغا ئېغىر بىر گۇناھنى يۈكلەپ قويدۇڭ؟ ماڭا قىلمايدىغان ئىشلارنى قىلدىڭ! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ئابىمەلەك ئىبراھىمغا يەنە: ــ سەن زادى بىزنىڭ نېمە ئىشىمىزنى كۆرگىنىڭ ئۈچۈن مۇشۇ ئىشنى قىلدىڭ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ئىبراھىم جاۋاب بېرىپ: ــ «بۇ يەردە شۈبھىسىزكى ھېچكىم خۇدادىن قورقمايدىكەن، ئۇلار مېنى ئايالىم تۈپەيلىدىن ئۆلتۈرۈۋېتىدۇ»، دەپ ئويلىغانىدىم. ");
INSERT INTO uigara_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ئەمەلىيەتتە، ئۇنىڭ مېنىڭ سىڭلىم ئىكەنلىكى راست، لېكىن ئۇ مېنىڭ ئاتا بىر، ئانا بۆلەك سىڭلىم؛ كېيىن ئۇ مېنىڭ ئايالىم بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","لېكىن خۇدا مېنى ئاتامنىڭ ئۆيىدىن چىقىرىپ سەرگەردانلىققا يۈرگۈزگىنىدە، مەن ئايالىمغا: ــ بىز قەيەرگىلا بارساق، سەن ماڭا شۇنداق شاپائەت كۆرسەتكەيسەنكى، مېنىڭ توغرامدا: «بۇ مېنىڭ ئاكام بولىدۇ»، دېگىن، ــ دەپ ئېيتقانىدىم ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ئاندىن ئابىمەلەك قوي-كالىلار، قۇللار ۋە دېدەكلەرنى ئېلىپ ئۇلارنى ئىبراھىمغا بەردى ۋە ئايالى ساراھنىمۇ ئۇنىڭغا قايتۇرۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ئابىمەلەك: ــ مانا مېنىڭ زېمىنىم بولسا ئالدىڭدا تۇرۇپتۇ؛ كۆزۈڭگە قايسى يەر ياقسا شۇ يەردە تۇرغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ئۇ ساراھقا: «مانا، مەن ئاكاڭغا مىڭ كۈمۈش تەڭگە بەردىم؛ مانا بۇلار ئۆز يېنىڭدىكىلەر، شۇنداقلا ھەممە ئادەملەرنىڭ كۆز ئالدىدا ئۇياتنى ياپقۇچى بولىدۇ؛ شۇنىڭ بىلەن سەن ھەرقانداق داغ-ئەيىبتىن خالاس بولىسەن». ");
INSERT INTO uigara_vpl VALUES ("GN20_17‏","002_20_17‏","GEN","20","17‏","18","ئىبراھىم خۇداغا دۇئا قىلدى، خۇدا ئابىمەلەك، ئايالى ۋە كېنىزەكلىرىنى ساقايتتى؛ ئاندىن ئۇلار يەنە بالا تۇغالايدىغان بولدى؛ چۈنكى پەرۋەردىگار ئىبراھىمنىڭ ئايالى ساراھ تۈپەيلىدىن ئابىمەلەكنىڭ ئۆيىدىكى ھەممە خوتۇنلارنىڭ بالىياتقۇلىرىنى ئېتىپ قويغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ئەمدى پەرۋەردىگار ۋەدە قىلغىنىدەك ساراھنى يوقلىدى؛ پەرۋەردىگار ساراھقا دېگىنىدەك قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ساراھ ھامىلىدار بولۇپ، ئىبراھىم قېرىغاندا خۇدا ئۇنىڭغا بېكىتكەن ۋاقىتتا بىر ئوغۇل تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ئىبراھىم ئۆزىگە تۆرەلگەن ئوغلى، يەنى ساراھ ئۇنىڭغا تۇغۇپ بەرگەن ئوغلىنىڭ ئىسمىنى ئىسھاق قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ئاندىن ئىبراھىم خۇدا ئۇنىڭغا بۇيرۇغىنىدەك ئۆز ئوغلى ئىسھاق تۇغۇلۇپ سەككىزىنچى كۈنى خەتنە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ئوغلى ئىسھاق تۇغۇلغان چاغدا، ئىبراھىم يۈز ياشتا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ساراھ: «خۇدا مېنى كۈلدۈرۈۋەتتى؛ ھەركىم بۇ ئىشنى ئاڭلىسا، مەن بىلەن تەڭ كۈلۈشىدۇ»، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ئۇ يەنە: ــ كىممۇ ئىبراھىمغا: «ساراھ بالا ئېمىتىدىغان بولىدۇ!» دەپ ئېيتالايتتى؟ چۈنكى ئۇ قېرىغاندا ئۇنىڭغا بىر ئوغۇل تۇغۇپ بەردىم! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","بالا چوڭ بولۇپ، ئەمچەكتىن ئايرىلدى. ئىسھاق ئەمچەكتىن ئايرىلغان كۈنى ئىبراھىم چوڭ زىياپەت ئۆتكۈزۈپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ئەمما ساراھ مىسىرلىق ھەجەرنىڭ ئىبراھىمغا تۇغۇپ بەرگەن ئوغۇلنىڭ ئىسھاقنى مەسخىرە قىلىۋاتقىنىنى كۆرۈپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","شۇنىڭ بىلەن ئۇ ئىبراھىمغا: ــ بۇ دېدەك بىلەن ئوغلىنى ھەيدىۋەت! چۈنكى بۇ دېدەكنىڭ ئوغلى مېنىڭ ئوغلۇم ئىسھاق بىلەن تەڭ ۋارىس بولسا بولمايدۇ!، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ساراھنىڭ بۇ سۆزى ئىبراھىمغا تولىمۇ ئېغىر كەلدى؛ چۈنكى ئىسمائىلمۇ ئۇنىڭ ئوغلى-دە! ");
INSERT INTO uigara_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","لېكىن خۇدا ئىبراھىمغا: ــ بالاڭ ۋە دېدىكىڭ ۋەجىدىن بۇ سۆز ساڭا ئېغىر كەلمىسۇن، بەلكى ساراھنىڭ ساڭا دېگەنلىرىنىڭ ھەممىسىگە قۇلاق سالغىن؛ چۈنكى ئىسھاقتىن بولغىنى سېنىڭ نەسلىڭ ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","لېكىن دېدەكنىڭ ئوغلىدىنمۇ بىر خەلق-مىللەت پەيدا قىلىمەن، چۈنكى ئۇمۇ سېنىڭ نەسلىڭ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ئەتىسى تاڭ سەھەردە ئىبراھىم قوپۇپ، نان بىلەن بىر تۇلۇم سۇنى ئېلىپ ھەجەرگە بېرىپ، ئۆشنىسىگە يۈدكۈزۈپ، بالىنى ئۇنىڭغا تاپشۇرۇپ، ئىككىسىنى يولغا سېلىپ قويدى. ھەجەر كېتىپ، بەئەر-شېبانىڭ چۆلىدە كېزىپ يۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN21_15‏","002_21_15‏","GEN","21","15‏","16","ئەمدى تۇلۇمدىكى سۇ تۈگەپ كەتكەنىدى؛ ھەجەر بالىنى بىر چاتقالنىڭ تۈۋىگە تاشلاپ قويۇپ، ئۆز-ئۆزىگە: «بالىنىڭ ئۆلۈپ كېتىشىگە قاراپ چىدىمايمەن» دەپ، بىر ئوق ئېتىمچە يىراققا بېرىپ، ئۇدۇلىدا ئولتۇردى. ئۇ ئۇدۇلىدا ئولتۇرۇپ، پەرياد كۆتۈرۈپ يىغلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","خۇدا ئوغۇلنىڭ يىغا ئاۋازىنى ئاڭلىدى؛ شۇنىڭ بىلەن خۇدانىڭ پەرىشتىسى ئاسماندىن ھەجەرنى چاقىرىپ ئۇنىڭغا: ــ ئەي ھەجەر، ساڭا نېمە بولدى؟ قورقمىغىن؛ چۈنكى خۇدا ئوغۇلنىڭ يىغا ئاۋازىنى ياتقان يېرىدىن ئاڭلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ئەمدى قوپۇپ، قولۇڭ بىلەن بالىنى يۆلەپ تۇرغۇز؛ چۈنكى مەن ئۇنى ئۇلۇغ بىر ئەل-مىللەت قىلىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","شۇئان خۇدا ھەجەرنىڭ كۆزلىرىنى ئاچتى، ئۇ بىر قۇدۇقنى كۆردى. ئۇ بېرىپ تۇلۇمغا سۇ تولدۇرۇپ، ئوغۇلغا ئىچكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","خۇدا ئۇ بالا بىلەن بىللە بولدى؛ ئۇ ئۆسۈپ چوڭ بولدى. ئۇ چۆلدە ياشاپ، مەرگەن بولۇپ يېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ئۇ پاران چۆلىدە تۇردى؛ شۇ ۋاقىتلاردا ئانىسى ئۇنىڭغا مىسىر زېمىنىدىن بىر قىزنى خوتۇنلۇققا ئېلىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ئۇ ۋاقىتلاردا شۇنداق بولدىكى، ئابىمەلەك ۋە ئۇنىڭ لەشكەربېشى فىكول كېلىپ ئىبراھىمغا: ــ قىلغان ھەممە ئىشلىرىڭدا، خۇدا سېنىڭ بىلەن بىللىدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ئەمدى سەن دەل مۇشۇ يەردە ماڭا، ئوغلۇمغا ۋە نەۋرەمگە خىيانەت قىلماسلىققا خۇدانىڭ نامىدا قەسەم قىلىپ بەرگەيسەن؛ مەن ساڭا كۆرسىتىپ كەلگەن مېھرىبانلىقىمدەك، سەنمۇ ماڭا ۋە سەن ھازىر تۇرۇۋاتقان يۇرتقا مېھرىبانلىق قىلغايسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ئىبراھىم: قەسەم قىلىپ بېرەي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ئاندىن ئىبراھىم ئابىمەلەكنىڭ چاكارلىرى تارتىۋالغان بىر قۇدۇق توغرىسىدا ئابىمەلەكنى ئەيىبلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ئابىمەلەك: ــ بۇ ئىشنى قىلغان كىشىنى بىلمەيمەن؛ سەن بۇ ئىشنى ماڭىمۇ ئېيتماپسەن؛ مەن بۇ ئىشنى پەقەت بۈگۈنلا ئاڭلىشىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ئىبراھىم قوي-كالا ئېلىپ ئابىمەلەككە تەقدىم قىلدى؛ ئاندىن ئۇلار ئىككىلىسى ئەھدە قىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ئىبراھىم يەنە پادىدىن يەتتە چىشى قوزىنى بىر تەرەپكە ئايرىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ئابىمەلەك ئىبراھىمدىن: ــ سەن بىر تەرەپكە ئايرىپ قويغان بۇ يەتتە چىشى قوزىنىڭ نېمە مەنىسى بار؟ ــ دەپ سورىۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ئۇ: ــ مېنىڭ بۇ قۇدۇقنى كولىغىنىمنى ئېتىراپ قىلغىنىڭغا گۇۋاھلىق سۈپىتىدە بۇ يەتتە چىشى قوزىنى قولۇمدىن قوبۇل قىلغايسەن، ــ دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","بۇ ئىككىسى شۇ يەردە قەسەم قىلىشقانلىقى ئۈچۈن، ئۇ شۇ جاينى «بەئەر-شېبا» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","شۇ تەرىقىدە ئۇلار بەئەر-شېبادا ئەھدە قىلىشتى. ئاندىن ئابىمەلەك ۋە ئۇنىڭ لەشكەربېشى فىكول قوزغىلىپ، فىلىستىيلەرنىڭ زېمىنىغا يېنىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ئىبراھىم بەئەر-شېبادا بىر تۈپ يۇلغۇننى تىكىپ، ئۇ يەردە ئەبەدىي تەڭرى بولغان پەرۋەردىگارنىڭ نامىغا نىدا قىلىپ ئىبادەت قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ئىبراھىم فىلىستىيلەرنىڭ زېمىنىدا ئۇزۇن ۋاقىتقىچە تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","بۇ ئىشلاردىن كېيىن شۇنداق بولدىكى، خۇدا ئىبراھىمنى سىناپ ئۇنىڭغا: ــ ئەي ئىبراھىم! دېدى. ئۇ: مانا مەن! ــ دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ئۇ: ــ سەن ئوغلۇڭنى، يەنى سەن سۆيىدىغان يالغۇز ئوغلۇڭ ئىسھاقنى ئېلىپ، مورىيا يۇرتىغا بېرىپ، شۇ يەردە، مەن ساڭا ئېيتىدىغان تاغلارنىڭ بىرىنىڭ ئۈستىدە ئۇنى كۆيدۈرمە قۇربانلىق سۈپىتىدە سۇنغىن، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ئەتىسى ئىبراھىم سەھەر قوپۇپ، ئېشىكىنى توقۇپ، يىگىتلىرىدىن ئىككىيلەن بىلەن ئىسھاقنى بىللە ئېلىپ، كۆيدۈرمە قۇربانلىق ئۈچۈن ئوتۇن يېرىپ، خۇدا ئۇنىڭغا ئېيتقان يەرگە قاراپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ئۈچىنچى كۈنى ئىبراھىم بېشىنى كۆتۈرۈپ قاراپ، يىراقتىن ئۇ يەرنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ئىبراھىم يىگىتلىرىگە: ــ سىلەر ئېشەك بىلەن مۇشۇ يەردە تۇرۇپ تۇرۇڭلار. مەن بالام بىلەن ئۇ يەرگە بېرىپ، سەجدە قىلىپ، ئاندىن قېشىڭلارغا يېنىپ كېلىمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","شۇنىڭ بىلەن ئىبراھىم كۆيدۈرمە قۇربانلىققا كېرەكلىك ئوتۇننى ئېلىپ، ئوغلى ئىسھاققا يۈدكۈزۈپ، ئۆزى قولىغا پىچاق بىلەن ئوتنى ئېلىپ، ئىككىسى بىللە يۈرۈپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ئىسھاق ئاتىسى ئىبراھىمغا: ــ ئەي ئاتا! دېۋىدى، ئۇ ئۇنىڭغا جاۋاب بېرىپ: ــ مانا مەن، ئوغلۇم، دېدى. ئۇ ئۇنىڭدىن: ــ مانا ئوت بىلەن ئوتۇنغۇ بار، ئەمما كۆيدۈرمە قۇربانلىق بولىدىغان قوزا قېنى؟ ــ دەپ سورىۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ئىبراھىم جاۋاب بېرىپ: ــ ئەي ئوغلۇم، خۇدا ئۆزى ئۆزىگە كۆيدۈرمە قۇربانلىق قوزىنى تەمىنلەيدۇ، ــ دېدى. ئاندىن ئىككىسى بىرگە يولىنى داۋاملاشتۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ئاخىرىدا ئۇلار خۇدا ئىبراھىمغا ئېيتقان جايغا يېتىپ كەلدى. ئىبراھىم ئۇ يەردە قۇربانگاھ ياساپ، ئۈستىگە ئوتۇننى تىزىپ قويدى. ئاندىن ئۇ ئوغلى ئىسھاقنى باغلاپ، ئۇنى قۇربانگاھدىكى ئوتۇننىڭ ئۈستىدە ياتقۇزدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ئاندىن ئىبراھىم قولىنى ئۇزىتىپ، ئوغلىنى بوغۇزلىغىلى پىچاقنى ئالدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","شۇئان پەرۋەردىگارنىڭ پەرىشتىسى ئاسماندىن ئۇنى چاقىرىپ ئۇنىڭغا: ــ ئىبراھىم، ئىبراھىم! ــ دەپ ۋارقىرىدى. ئۇ: ــ مانا مەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ئۇ ئۇنىڭغا: ــ سەن بالىغا قولۇڭنى تەگكۈزمىگىن، ئۇنى ھېچنېمە قىلمىغىن؛ چۈنكى مەن سېنىڭ خۇدادىن قورققانلىقىڭنى بىلدىم؛ چۈنكى سېنىڭ ئوغلۇڭنى، يەنى يالغۇز ئوغلۇڭنى مەندىن ئايىمىدىڭ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ئىبراھىم بېشىنى كۆتۈرۈپ قارىۋىدى، مانا، ئارقىسىدا مۈڭگۈزلىرى چاتقالغا چىرمىشىپ قالغان بىر قوچقارنى كۆردى. ئىبراھىم بېرىپ قوچقارنى ئېلىپ، ئۇنى ئوغلىنىڭ ئورنىدا كۆيدۈرمە قۇربانلىق قىلىپ سۇندى. ");
INSERT INTO uigara_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","شۇنىڭ بىلەن ئىبراھىم شۇ جايغا «ياھۋەھ-يىرەھ» دەپ ئات قويدى. شۇڭا كىشىلەر: «پەرۋەردىگارنىڭ تېغىدا تەمىنلىنىدۇ» دېگەن بۇ سۆز بۈگۈنگە قەدەر ئېيتىلىپ كېلىۋاتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","پەرۋەردىگارنىڭ پەرىشتىسى ئاسماندىن ئىبراھىمنى ئىككىنچى قېتىم چاقىرىپ ئۇنىڭغا: ــ ");
INSERT INTO uigara_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","سەن ئۆز ئوغلۇڭنى، يەنى يالغۇز ئوغلۇڭنى ئايىماي بۇ ئىشنى قىلغىنىڭ ئۈچۈن مەن ئۆزۈم بىلەن قەسەم قىلىمەنكى، دەيدۇ پەرۋەردىگار، ");
INSERT INTO uigara_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ــ مەن سېنى زور بەرىكەتلەپ، نەسلىڭنى ئاسماندىكى يۇلتۇزلاردەك نۇرغۇن كۆپەيتىپ، دېڭىز ساھىلىدىكى قۇمدەك غولدىتىمەن؛ نەسلىڭ بولسا دۈشمەنلىرىنىڭ دەرۋازىلىرىغا ئىگە بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","سەن مېنىڭ ئاۋازىمغا قۇلاق سالغىنىڭ ئۈچۈن يەر يۈزىدىكى بارلىق ئەل-يۇرتلار نەسلىڭنىڭ نامى بىلەن ئۆزلىرى ئۈچۈن بەخت-بەرىكەت تىلەيدۇ، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ئاندىن ئىبراھىم يىگىتلىرىنىڭ قېشىغا يېنىپ باردى. ئۇلار ھەممىسى ئورنىدىن تۇرۇشۇپ بەئەر-شېباغا يول ئالدى. ئىبراھىم بەئەر-شېبادا تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","بۇ ئىشلاردىن كېيىن ئىبراھىمغا: «مانا مىلكاھمۇ ئىنىڭ ناھورغا بىرقانچە ئوغۇل تۇغۇپ بېرىپتۇ»، دېگەن خەۋەر يەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ئۇلار بولسا تۇنجى ئوغلى ئۇز، ئۇنىڭ ئىنىسى بۇز ۋە ئارامنىڭ ئاتىسى بولغان كەمۇئەل، ");
INSERT INTO uigara_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ئاندىن كەسەد، خازو، پىلداش، يىدلاف ۋە بېتۇئەل دېگەن ئوغۇللار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(بېتۇئەلدىن رىۋكاھ تۆرەلدى). بۇ سەككىزىنى مىلكاھ ئىبراھىمنىڭ ئىنىسى ناھورغا تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","شۇنىڭدەك ئۇنىڭ كېنىزىكى رەئۇماھمۇ تېباھ، گاھام، تاخاش ۋە مائاكاھ دېگەنلەرنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ساراھ بىر يۈز يىگىرمە يەتتە ياشقىچە ئۆمۈر كۆردى. بۇ ساراھنىڭ ئۆمرىنىڭ يىللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ساراھ قانائان زېمىنىدىكى كىرىئات-ئاربا، يەنى ھېبروندا ۋاپات بولدى. ئىبراھىم بېرىپ ساراھ ئۈچۈن ماتەم تۇتۇپ يىغا-زار قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ئىبراھىم ئۆز مەرھۇمەسىنىڭ يېنىدىن قوپۇپ، ھىتتىيلارغا سۆز قىلىپ: ");
INSERT INTO uigara_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","ــ مەن بولسام ئاراڭلاردا مۇساپىر مېھمان، خالاس؛ سىلەر ئەمدى ئاراڭلاردىن ماڭا بىر يەرلىك بېرىڭلار؛ شۇنىڭ بىلەن مەن بۇ مەرھۇمەمنى ئالدىمدا كۆرۈنۈپ تۇرمىسۇن ئۈچۈن ئېلىپ بېرىپ دەپنە قىلاي، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN23_5‏","002_23_5‏","GEN","23","5‏","6","ھىتتىيلار ئىبراھىمغا جاۋاب بېرىپ: ــ ئى خوجام، بىزگە قۇلاق سالغايلا! سىلى ئارىمىزدا خۇدانىڭ بىر شاھزادىسى ھېسابلىنىلا! ئارىمىزدىكى ئەڭ ئېسىل يەرلىكنى تاللاپ، شۇ يەردە مەرھۇمەلىرىنى دەپنە قىلغايلا! مەرھۇمەلىرىنى دەپنە قىلىشقا ھېچقايسىمىز ئۆز يەرلىكىنى سىلىدىن ئايىمايدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ئىبراھىم ئورنىدىن تۇرۇپ، ئۇ زېمىندىكى خەلققە، يەنى ھىتتىيلارغا تەزىم قىلىپ، ");
INSERT INTO uigara_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ئۇلارغا: ــ ئەگەر مەرھۇمەمنىڭ كۆز ئالدىمدا تۇرىۋەرمەسلىكى ئۈچۈن، ئۇنى ئېلىپ بېرىپ، دەپنە قىلىشىمنى راۋا كۆرسەڭلار، ئۇنداقتا سۆزۈمنى ئاڭلاپ مېنىڭ ئۈچۈن زوھارنىڭ ئوغلى ئەفرونغا سۆز قىلىپ، ");
INSERT INTO uigara_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ئۇنىڭ ئېتىزىنىڭ ئايىغىدا ئۆزىنىڭكى بولغان ماكپېلاھنىڭ غارىنى ماڭا بېرىشىنى ئىلتىماس قىلىڭلار. ئۇ ماڭا بۇنى سىلەرنىڭ ئاراڭلاردا گۆرىستان بولۇشقا تولۇق نەرخىدە بەرسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","شۇ چاغدا ئەفرون ھىتتىيلار ئارىسىدا ئولتۇراتتى. شۇنىڭ بىلەن ھىتتىيلىق ئەفرون ھىتتىيلارنىڭ ئالدىدا، يەنى شەھىرىنىڭ دەرۋازىسىدىن كىرگۈچىلەرنىڭ ھەممىسىنىڭ ئالدىدا ئىبراھىمغا جاۋاب بېرىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","يوقسۇ، ئەي خوجام، ماڭا قۇلاق سالغايلا. بۇ ئېتىزلىقنى، شۇنداقلا ئۇنىڭدىكى غارنى سىلىگە بېرەي؛ ئۇنى ئۆز خەلقىم بولغان ئادەملەرنىڭ ئالدىدا سىلىگە بەردىم؛ ئۆز مېيىتلىرىنى دەپنە قىلغايلا، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ئاندىن ئىبراھىم يەنە زېمىن خەلقى ئالدىدا تەزىم قىلىپ، ");
INSERT INTO uigara_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","شۇ زېمىندىكى خەلقنىڭ قۇلاقلىرى ئالدىدا ئەفرونغا: ــ ئىلتىماسىمغا قۇلاق سالغايلا؛ مەن بۇ ئېتىزلىقنىڭ نەرخى بويىچە پۇل بېرەي، ئۇنى مەندىن قوبۇل قىلغايلا، ئاندىن مەن مېيىتىمنى شۇ يەردە دەپنە قىلاي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ئەفرون ئىبراھىمغا جاۋاب بېرىپ ئۇنىڭغا: ");
INSERT INTO uigara_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","ئەي خوجام، ماڭا قۇلاق سالغايلا؛ تۆت يۈز شەكەل كۈمۈشكە يارايدىغان بىر ئېتىزلىق، سىلى بىلەن مېنىڭ ئارامدا نېمە ئىدى؟ سىلى مېيىتلىرىنى دەپنە قىلغايلا ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ئىبراھىم ئەفروننىڭ سۆزىگە قوشۇلدى؛ ئاندىن ئەفرون ھىتتىيلار ئالدىدا ئېيتقان باھانى، يەنى شۇ چاغدىكى سودا ئۆلچىمى بويىچە تۆت يۈز شەكەل كۈمۈشنى تارازىدا تارتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","شۇنداق قىلىپ مامرەنىڭ ئۇدۇلىدىكى ماكپېلاھقا جايلاشقان ئەفروننىڭ ئېتىزلىقى، يەنى ئېتىزلىقنىڭ ئۆزى، ئۇنىڭدىكى غار، شۇنداقلا ئېتىزلىقنىڭ ئىچى ۋە ئەتراپىدىكى بارلىق دەرەخلەرنىڭ ھەممىسى ");
INSERT INTO uigara_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ھىتتىيلارنىڭ كۆز ئالدىدا ئىبراھىمغا تاپشۇرۇلۇپ، يەنى ئەفروننىڭ شەھىرىنىڭ دەرۋازىسىدىن بارلىق كىرگۈچىلەرنىڭ ئالدىدا ئۇنىڭ مۈلكى قىلىپ بېكىتىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","شۇنىڭدىن كېيىن ئىبراھىم ئايالى ساراھنى قانائان زېمىنىدىكى مامرە (يەنى، ھېبرون)نىڭ ئۇدۇلىدىكى ماكپېلاھنىڭ ئېتىزلىقىنىڭ غارىدا دەپنە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","شۇ تەرىقىدە ئۇ ئېتىزلىق ۋە ئۇنىڭدىكى غار ھىتتىيلار تەرىپىدىن ئىبراھىمغا گۆرىستان بولۇشقا تايىن قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ئىبراھىم قېرىپ، يېشى بىر يەرگە بېرىپ قالغانىدى؛ پەرۋەردىگار ئىبراھىمغا ھەر تەرەپتە بەخت-بەرىكەت ئاتا قىلغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ئىبراھىم ئۆيىدىكى ئەڭ مۆتىۋەر خىزمەتكارى، ئۆزىنىڭ پۈتۈن مال-مۈلكىنى باشقۇرىدىغان غوجىدارغا: ــ قولۇڭنى يوتامنىڭ ئاستىغا قويغىن؛    ");
INSERT INTO uigara_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","مەن سېنى ئاسمانلارنىڭ خۇداسى شۇنداقلا يەرنىڭ خۇداسى بولغان پەرۋەردىگارنىڭ نامى بىلەن قەسەم قىلدۇرىمەنكى، سەن مەن ھازىر تۇرۇۋاتقان بۇ قانائانىيلارنىڭ ئارىسىدىن ئوغلۇمغا قىز ئېلىپ بەرمەي، ");
INSERT INTO uigara_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بەلكى ئۆز يۇرتۇمغا، شۇنداقلا ئۆز ئۇرۇق-تۇغقانلىرىمنىڭ قېشىغا بېرىپ، ئوغلۇم ئىسھاققا خوتۇن ئېلىپ بەرگەيسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","خىزمەتكارى ئۇنىڭغا: ــ مۇبادا ئۇ قىز مەن بىلەن بۇ يۇرتقا كەلگىلى ئۇنىمىسا، ئۇنداقتا ئۆزلىرى چىققان شۇ يۇرتقا ئوغۇللىرىنى ياندۇرۇپ ئاپىرامدىمەن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ئىبراھىم ئۇنىڭغا جاۋاب بېرىپ: ــ ھېزى بول، ئوغلۇمنى ھەرگىز شۇ يەرگە ياندۇرۇپ بارمىغىن! ");
INSERT INTO uigara_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","مېنى ئاتامنىڭ ئۆيى بىلەن تۇغۇلغان يۇرتۇمدىن يېتەكلەپ ئېلىپ كەلگۈچى، يەنى ماڭا سۆز قىلىپ: ــ «سېنىڭ نەسلىڭگە بۇ يۇرتنى بېرىمەن»، دەپ ماڭا قەسەم قىلغان، ئاسماننىڭ خۇداسى بولغان پەرۋەردىگار ئۆز پەرىشتىسىنى ئالدىڭغا ئەۋەتىدۇ؛ شۇنىڭ بىلەن سەن ئۇ يەردىن ئوغلۇمغا قىز ئېلىپ كېلەلەيسەن. ");
INSERT INTO uigara_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","شۇنداقتىمۇ، ئەگەر قىز سەن بىلەن بۇ يەرگە كەلگىلى ئۇنىمىسا، مەن ساڭا قىلدۇرىدىغان قەسەمدىن خالاس بولىسەن؛ ئەمما ئوغلۇمنى ئۇ يەرگە ھەرگىز ياندۇرۇپ بارمىغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","شۇنىڭ بىلەن خىزمەتكار قولىنى خوجىسى ئىبراھىمنىڭ يوتىسىنىڭ ئاستىغا قويۇپ تۇرۇپ، بۇ توغرىدا ئۇنىڭغا قەسەم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ئاندىن خىزمەتكار بۇ توغرىدا خوجىسىنىڭ تۆگىلىرىدىن ئوننى، شۇنداقلا خوجىسىنىڭ ھەرخىل ئېسىل نەرسىلىرىنى ئېلىپ يولغا چىقتى؛ ئۇ ئارام-ناھارائىم رايونىغا سەپەر قىلىپ، ناھورنىڭ شەھىرىگە يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ئۇ شەھەرنىڭ سىرتىدىكى بىر قۇدۇقنىڭ يېنىدا تۆگىلىرىنى چۆكۈندۇردى: بۇ كەچقۇرۇن، قىز-ئاياللارنىڭ سۇ تارتقىلى چىقىدىغان چېغى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ئۇ دۇئا قىلىپ: ــ ئەي خوجام ئىبراھىمنىڭ خۇداسى بولغان پەرۋەردىگار، ئۆتۈنىمەنكى، بۈگۈن مېنىڭ ئىشىمنى ئوڭغا تارتقايسەن، خوجام ئىبراھىمغا شاپائەت كۆرسەتكەيسەن. ");
INSERT INTO uigara_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","مانا مەن بۇ يەردە قۇدۇقنىڭ بېشىدا تۇرۇۋاتىمەن ۋە شەھەر خەلقىنىڭ قىزلىرى بۇ يەرگە سۇ تارتقىلى كېلىۋاتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ئەمدى شۇنداق بولسۇنكى، مەن قايسى قىزغا: «كوزمزىكىڭنى چۈشۈرسەڭ، مەن سۇ ئىچىۋالسام بوپتىكەن!» دېسەم، ئۇ جاۋاب بېرىپ: «مانا ئىچكىن، مەن تۆگىلىرىڭنىمۇ سۇغىرىپ قوياي»، دېسە، ئۇ قىز سەن قۇلۇڭ ئىسھاققا بېكىتكىنىڭنىڭ ئۆزى بولسۇن. بۇنىڭدىن سېنىڭ خوجام ئىبراھىمغا شاپائەت قىلغىنىڭنى بىلەلەيمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ئۇ تېخى سۆزىنى تۈگەتمەيلا، مانا رىۋكاھ كومزەكنى مۈرىسىدە كۆتۈرۈپ چىقىپ كەلدى؛ ئۇ بولسا ئىبراھىمنىڭ ئىنىسى ناھورنىڭ ئايالى مىلكاھتىن تۇغۇلغان ئوغلى بېتۇئەلنىڭ قىزى ئىدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","قىز ئىنتايىن چىرايلىق بولۇپ، ھېچ ئەر كىشى تەگمىگەن پاك قىز ئىدى. ئۇ قۇدۇقنىڭ بويىغا چۈشۈپ، كومزەكنى تولدۇرۇپ ئاندىن چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","خىزمەتكار ئۇنىڭ ئالدىغا يۈگۈرۈپ بېرىپ: ــ ئۆتۈنۈپ قالاي، كومزىكىڭتىن ئازغىنە سۇ ئوتلىۋالاي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ئۇ جاۋاب بېرىپ: ــ ئىچكەيلا، ئەي خوجام! دەپلا، كومزەكنى دەرھال قولىغا ئېلىپ، ئۇنىڭ سۇ ئىچىشى ئۈچۈن سۇندى. ");
INSERT INTO uigara_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ئۇ سۈيىدىن ئۇنىڭغا قانغۇچە ئىچكۈزگەندىن كېيىن: ــ تۆگىلىرىگىمۇ قانغۇچە سۇ ئىچكۈزۈپ قوياي، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","شۇنىڭ بىلەن ئۇ دەرھال كومزەكتىكى سۇنى ئولاققا تۆكۈۋېتىپ، يەنە قۇدۇققا سۇ تارتقىلى يۈگۈرۈپ باردى؛ ئۇ ئۇنىڭ ھەممە تۆگىلىرىگە سۇ تارتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ئۇ كىشى ئۇنىڭغا كۆزىنى تىككىنىچە جىمجىت تۇرۇپ، پەرۋەردىگارنىڭ يولىنى ئوڭ قىلغان، قىلمىغانلىقىنى بىلىش ئۈچۈن كۈتۈۋاتاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","تۆگىلەر سۇ ئىچىپ قانغاندا، شۇنداق بولدىكى، ھېلىقى كىشى يېرىم شەكەللىك بىر ئالتۇن بۇرۇن ھالقىسى بىلەن ئىككى قولىغا ئون شەكەللىك ئالتۇن بىلەزۈكنى چىقىرىپ قىزغا بېرىپ ئۇنىڭغا: ");
INSERT INTO uigara_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","سەن كىمنىڭ قىزى بولىسەن؟ ماڭا دەپ بەرسەڭ! ئاتاڭنىڭ ئۆيىدە بىزگە قونغۇدەك جاي بارمۇ؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","قىز ئۇنىڭغا: ــ مەن مىلكاھنىڭ ناھورغا تۇغۇپ بەرگەن ئوغلى بېتۇئەلنىڭ قىزى بولىمەن، ــ دېدى، ");
INSERT INTO uigara_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","يەنە ئۇنىڭغا: ــ بىزنىڭكىدە سامان بىلەن بوغۇز كەڭرى، سىلەرگە قونغىلى جايمۇ بار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","شۇئان بۇ ئادەم ئېڭىشىپ پەرۋەردىگارنىڭ ئالدىدا سەجدە قىلىپ: ");
INSERT INTO uigara_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ئۆز شاپائىتى بىلەن خوجامدىن ۋاپادارلىقىنى ئايىمىغان، خوجام ئىبراھىمنىڭ خۇداسى بولغان پەرۋەردىگارغا ھەمدۇسانا ئوقۇلغاي! پەرۋەردىگار بۇ سەپىرىمدە مېنى خوجامنىڭ قېرىنداشلىرى تۇرغان ئۆيگە باشلاپ كەلدى! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","قىز يۈگۈرۈپ بېرىپ، بۇلارنىڭ ھەممىسىنى ئانىسىنىڭ ئۆيدىكىلەرگە ئېيتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ئەمدى رىۋكاھنىڭ لابان دېگەن بىر ئاكىسى بار ئىدى. لابان قۇدۇقنىڭ بېشىغا، ئۇ ئادەمنىڭ قېشىغا يۈگۈرۈپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","چۈنكى ئۇ سىڭلىسىنىڭ بۇرۇن ھالقىسىنى ۋە قوللىرىدىكى بىلەزۈكلەرنى كۆرۈپ، ھەمدە سىڭلىسىنىڭ: ئۇ ئادەم ماڭا مۇنداق-مۇنداق دېدى، دېگىنىنى ئاڭلاپ، ئۇ ئادەمنىڭ قېشىغا باردى. مانا، ئۇ كىشى قۇدۇقنىڭ يېنىدا تۆگىلەرنىڭ قېشىدا تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","لابان ئۇنىڭغا: ــ ئەي پەرۋەردىگارنىڭ بەخت-بەرىكىتى ئاتا قىلىنغۇچى، كىرگەيلا! نېمە ئۈچۈن تاشقىرىدا تۇردىلا؟ مەن ئۆينى تەييارلاپ قويدۇم، تۆگىلەرگىمۇ جاي راسلىدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ئۇ ئادەم ئۆيگە كىردى؛ لابان تۆگىلەردىن يۈكنى چۈشۈرۈپ، تۆگىلەرگە سامان بىلەن بوغۇز بېرىپ، ئۇ كىشىنىڭ ھەم ئۇنىڭ ھەمراھلىرىنىڭ پۇتلىرىنى يۇغىلى سۇ ئېلىپ كەلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ئاندىن ئۇ كىشىنىڭ ئالدىغا تائام قويۇلدى؛ لېكىن ئۇ: ــ مەن گېپىمنى دېمەي تۇرۇپ تائام يېمەيمەن، ــ دېدى. لابان جاۋاب بېرىپ: ــ ئېيتقايلا، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ئۇ: ــ مەن بولسام ئىبراھىمنىڭ خىزمەتكارىمەن؛ ");
INSERT INTO uigara_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","پەرۋەردىگار خوجامغا كۆپ بەخت-بەرىكەت ئاتا قىلغاچقا، ئۇ ئۇلۇغ بىر كىشى بولدى. ئۇ ئۇنىڭغا قوي بىلەن كالا، كۈمۈش بىلەن ئالتۇن، قۇل بىلەن دېدەكلەرنى، تۆگە بىلەن ئېشەكلەرنى بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","خوجامنىڭ ئايالى ساراھ قېرىغاندا خوجامغا بىر ئوغۇل تۇغۇپ بەرگەنىدى. خوجام ئوغلىغا ئۆزىنىڭ بارلىقىنى ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","خوجام مېنى قەسەم قىلدۇرۇپ: «سەن مەن تۇرۇۋاتقان زېمىندىكى قانائانىيلارنىڭ قىزلىرىدىن ئوغلۇمغا خوتۇن ئېلىپ بەرمە، ");
INSERT INTO uigara_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بەلكى جەزمەن ئاتامنىڭ ئۆيىگە، ئۆز تۇغقانلىرىمنىڭ قېشىغا بېرىپ، ئوغلۇمغا خوتۇن ئېلىپ بەرگەيسەن»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ئۇ ۋاقىتتا مەن خوجامغا: «ئۇ قىز مەن بىلەن كەلگىلى ئۇنىمىسىچۇ؟» ــ دېسەم، ");
INSERT INTO uigara_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ئۇ ماڭا جاۋاب بېرىپ: «تۇتقان يوللىرىم ئۇنىڭغا ئوچۇق بولغان پەرۋەردىگارىم ئۆز پەرىشتىسىنى سېنىڭ بىلەن ئەۋەتىپ، يولۇڭنى ئوڭ قىلىدۇ. بۇ تەرىقىدە سەن مېنىڭ ئائىلىدىكىلىرىم ئارىسىدىن، ئاتامنىڭ جەمەتى ئىچىدىن ئوغلۇمغا خوتۇن ئېلىپ بېرىسەن. ");
INSERT INTO uigara_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","شۇنداق قىلىپ ئائىلەمدىكىلەرنىڭ قېشىغا يېتىپ بارغىنىڭدا، سەن مەن قىلدۇرغان قەسەمدىن خالاس بولىسەن؛ ئۇلار ساڭا قىزنى بەرمىسىمۇ ئوخشاشلا قەسەمدىن خالاس بولىسەن»، ــ دېگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","شۇڭا مەن بۈگۈن بۇ قۇدۇقنىڭ قېشىغا كېلىپ: ــ ئەي، خوجام ئىبراھىمنىڭ خۇداسى بولغان پەرۋەردىگار، ئەگەر سەن بۇ سەپىرىمنى ئوڭ قىلساڭ: ــ ");
INSERT INTO uigara_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","مانا مەن سۇ قۇدۇقىنىڭ يېنىدا تۇرۇۋاتىمەن؛ ۋە شۇنداق بولسۇنكى، سۇ تارتقىلى كەلگەن قىزغا: «كوزاڭدىن ماڭا بىر ئوتلام سۇ بەرگەن بولساڭ»، دېسەم، ");
INSERT INTO uigara_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ئۇ ماڭا: «سەن ئىچكىن، تۆگىلىرىڭگىمۇ سۇ تارتىپ بېرەي»، دەپ جاۋاب بەرسە، ئۇنداقتا بۇ قىز دەل پەرۋەردىگار ئۆزى خوجامنىڭ ئوغلى ئۈچۈن بېكىتكەن قىز بولسۇن، دەپ دۇئا قىلغانىدىم. ");
INSERT INTO uigara_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","كۆڭلۈمدە تېخى سۆزۈم تۈگىمەيلا، مانا، رىۋكاھ كومزەكنى مۈرىسىدە كۆتۈرۈپ چىقىپ، قۇدۇقنىڭ بويىغا چۈشۈپ سۇ تارتتى؛ مەن ئۇنىڭغا: ــ ئىلتىپات قىلىپ، ماڭا سۇ ئىچكىلى قويساڭ، دېۋىدىم، ");
INSERT INTO uigara_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ئۇ دەرھال كومزىكىنى مۈرىسىدىن چۈشۈرۈپ: «ئىچكەيلا، تۆگىلىرىنىمۇ سۇغىرىپ قوياي»، دېدى. شۇنىڭ بىلەن مەن ئىچتىم؛ ئۇ تۆگىلىرىمنىمۇ سۇغىرىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ئاندىن مەن ئۇنىڭدىن: ــ كىمنىڭ قىزى بولىسەن، دەپ سورىسام، ئۇ جاۋاب بېرىپ: ــ مەن ناھورنىڭ مىلكاھدىن تۇغۇلغان ئوغلى بېتۇئەلنىڭ قىزى بولىمەن، ــ دېدى. شۇ چاغدا مەن ئۇنىڭ بۇرنىغا ھالقا، قوللىرىغا بىلەزۈكلەرنى سېلىپ قويدۇم؛ ");
INSERT INTO uigara_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ئاندىن ئېڭىشىپ پەرۋەردىگارغا سەجدە قىلدىم؛ خوجامنىڭ قېرىندىشىنىڭ قىزىنى ئۇنىڭ ئوغلى ئۈچۈن ئېلىپ كېتىشكە مېنىڭ يولۇمنى ئوڭ قىلغىنى ئۈچۈن، خوجامنىڭ خۇداسى بولغان پەرۋەردىگارغا ھەمدۇسانا ئېيتتىم. ");
INSERT INTO uigara_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ئەمدى سىلەر خوجامغا ئىخلاس قىلىپ شاپائەت كۆرسىتەيلى دېسەڭلار، بۇنى ماڭا دەڭلار. ئەگەر خالىمىساڭلار، ئۇنىمۇ ماڭا ئېيتىڭلار، مەن ئوڭ تەرەپكە ياكى سول تەرەپكە بارىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ئەمدى لابان بىلەن بېتۇئەل جاۋاب بېرىپ: ــ بۇ ئىش پەرۋەردىگاردىن بولغاچ، سىلىگە يا ئۇنداق يا بۇنداق دېيەلمەيمىز. ");
INSERT INTO uigara_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","مانا، رىۋكاھ ئالدىلىرىدا تۇرىدۇ؛ ئۇنى ئېلىپ كەتكەيلا. ئۇ پەرۋەردىگارنىڭ دېگىنىدەك ئۆز خوجىلىرىنىڭ ئوغلىغا خوتۇن بولسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ئىبراھىمنىڭ خىزمەتكارى ئۇلارنىڭ سۆزلىرىنى ئاڭلاپ، يەرگە ئېڭىشىپ، پەرۋەردىگارغا سەجدە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ئاندىن، خىزمەتكار كۈمۈش بۇيۇملارنى، ئالتۇن بۇيۇملارنى ۋە كىيىم-كېچەكلەرنى چىقىرىپ، بۇلارنى رىۋكاھقا بەردى؛ ئۇ يەنە قىزنىڭ ئاكىسى ۋە ئانىسىغىمۇ قىممەتلىك ھەدىيەلەرنى سۇندى. ");
INSERT INTO uigara_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ئاندىن ئۇ ۋە ھەمراھلىرى بىلەن بىللە يەپ-ئىچىپ، شۇ يەردە قونۇپ قالدى. ئەتىسى سەھەردە قوپۇپ، ئۇ ئۇلارغا: مېنى خوجامنىڭ قېشىغا يولغا سېلىپ قويۇڭلار، دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","قىزنىڭ ئاكىسى بىلەن ئانىسى ئۇنىڭغا: ــ قىز بىرقانچە كۈن ياكى ئون كۈن يېنىمىزدا تۇرسۇن؛ ئاندىن بارسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ئەمما ئۇ ئۇلارغا: ــ پەرۋەردىگار مېنىڭ سەپىرىمنى ئوڭ قىلغانىكەن، مېنى توسماڭلار؛ خوجامنىڭ قېشىغا بېرىشىم ئۈچۈن مېنى يولغا سېلىپ قويۇڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ئۇلار ئۇنىڭغا: ــ قىزنى چاقىرىپ، ئۇنىڭ ئاغزىدىن ئاڭلاپ باقايلى، دەپ ");
INSERT INTO uigara_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","رىۋكاھنى چاقىرىپ ئۇنىڭدىن: ــ بۇ ئادەم بىلەن بارامسەن؟ دەپ سورىۋىدى، ئۇ: ــ باراي، دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","شۇنىڭ بىلەن ئۇلار سىڭلىسى رىۋكاھنى، ئۇنىڭ ئىنىكئانىسى، ئىبراھىمنىڭ خىزمەتكارى ۋە ئادەملىرى بىلەن قوشۇپ يولغا سېلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ئۇ ۋاقىتتا ئۇلار رىۋكاھقا بەخت تىلەپ: ــ ئەي سىڭلىمىز، مىڭلىغان ئون مىڭلىغان ئادەملەرنىڭ ئانىسى بولغايسەن! نەسلىڭ دۈشمەنلىرىنىڭ دەرۋازىلىرىغا ئىگە بولغاي! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","شۇنىڭ بىلەن رىۋكاھ بىلەن ئۇنىڭ دېدەكلىرى ئورنىدىن تۇرۇپ، تۆگىلەرگە مىنىپ، ئۇ كىشىگە ئەگىشىپ ماڭدى. شۇنداق قىلىپ خىزمەتكار رىۋكاھنى ئېلىپ يولغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ئىسھاق بەئەر-لاھاي-روي دېگەن جايدىن بايىلا قايتىپ كەلگەنىدى؛ چۈنكى ئۇ جەنۇبتىكى نەگەۋدە تۇراتتى؛ ");
INSERT INTO uigara_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ئىسھاق كەچقۇرۇن ئىستىقامەتكە دالاغا چىققانىدى؛ ئۇ بېشىنى كۆتۈرۈپ قارىسا، مانا تۆگىلەر كېلىۋاتاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN24_64‏","002_24_64‏","GEN","24","64‏","65","رىۋكاھ بېشىنى كۆتۈرۈپ، ئىسھاقنى كۆردى؛ ئۇ دەرھال تۆگىدىن چۈشۈپ، خىزمەتكاردىن: ــ سەھرادا بىزنىڭ ئالدىمىزغا چىقىۋاتقان بۇ كىشى كىم بولىدۇ؟ ــ دەپ سورىدى. خىزمەتكار: ــ بۇ خوجامدۇر! دېدى. رىۋكاھ دەرھال چۈمبىلىنى تارتىپ يۈزىنى يېپىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","خىزمەتكار ئەمدى قىلغان ھەممە ئىشلىرىنى ئىسھاققا ئېيتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ئىسھاق قىزنى ئانىسى ساراھنىڭ چېدىرىغا باشلاپ كىردى؛ ئۇ رىۋكاھنى ئۆز ئەمرىگە ئالدى؛ ئۇ ئۇنىڭ خوتۇنى بولدى. ئۇ ئۇنى ياخشى كۆرۈپ قالدى؛ بۇ تەرىقىدە ئىسھاق ئانىسىنىڭ ۋاپاتىدىن كېيىن تەسەللى تاپتى. ");
INSERT INTO uigara_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ئىبراھىم كەتۇراھ ئىسىملىك يەنە بىر ئايالنى ئالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ئۇ ئىبراھىمغا زىمران، يوقشان، مېدان، مىدىيان، ئىشباق ۋە شۇئاھنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","يوقشاندىن شېبا بىلەن دېدان تۆرەلدى؛ دېداننىڭ ئەۋلادلىرى ئاشۇرىيلار، لېتۇشىيلار ۋە لېئۇممىيلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","مىدىياننىڭ ئوغۇللىرى ئەفاھ، ئېفەر، ھانوخ، ئابىدا ۋە ئەلدائاھ ئىدى. بۇلار ھەممىسى كەتۇراھنىڭ ئەۋلادلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ئىبراھىم بارلىقىنى ئىسھاققا ئاتىۋەتكەنىدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ئىبراھىم تېخى ھايات ۋاقتىدا كىچىك خوتۇنلىرىدىن بولغان ئوغۇللىرىغا ھەدىيەلەرنى بېرىپ، ئاندىن بۇلارنى ئوغلى ئىسھاقتىن يىراق تۇرسۇن دەپ، كۈن چىقىش تەرەپكە، شەرقىي زېمىنغا ئەۋەتىۋەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_7‏","002_25_7‏","GEN","25","7‏","8","ئىبراھىمنىڭ ئۆمرىنىڭ كۈنلىرى بىر يۈز يەتمىش بەش يىل بولدى؛ ئۇ تولىمۇ قېرىپ، كۈنلىرى توشۇپ، نەپەستىن توختاپ ۋاپات بولدى؛ ئۇ ئۆز قوۋمىنىڭ قېشىغا بېرىپ قوشۇلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ئۇنىڭ ئوغۇللىرى ئىسھاق ۋە ئىسمائىل ئۇنى مامرەنىڭ ئۇدۇلىغا جايلاشقان، ھىتتىي زوھارنىڭ ئوغلى ئەفروننىڭ ئېتىزلىقىدىكى ماكپيلاھنىڭ غارىدا دەپنە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","بۇ ئېتىزلىقنى ئىبراھىم ھىتتىيلاردىن سېتىۋالغانىدى؛ مانا بۇ يەرلىككە ئىبراھىم دەپنە قىلىندى، ئايالى ساراھمۇ مۇشۇ يەرگە دەپنە قىلىنغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ئىبراھىم ۋاپات بولغاندىن كېيىن شۇنداق بولدىكى، پەرۋەردىگار ئۇنىڭ ئوغلى ئىسھاقنى بەرىكەتلىدى. ئىسھاق بەئەر-لاھاي-روينىڭ يېنىدا تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","تۆۋەندىكىلەر ساراھنىڭ مىسىرلىق دېدىكى ھەجەردىن تۇغۇلغان، ئىبراھىمنىڭ ئوغلى بولغان ئىسمائىلنىڭ ئەۋلادلىرى: ــ ");
INSERT INTO uigara_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ئىسمائىلنىڭ ئوغۇللىرىنىڭ، ئۇلارنىڭ نەسەبنامىلىرى ۋە قەبىلىلىرى بويىچە ئىسمى تۆۋەندىكىچە: ــ ئىسمائىلنىڭ تۇنجى ئوغلى نېبايوت؛ ئاندىن كېدار، ئادبەئەل، مىبسام، ");
INSERT INTO uigara_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","مىشما، دۇماھ، ماسسا، ");
INSERT INTO uigara_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ھاداد بىلەن تېما، يەتۇر بىلەن نافىش ۋە قەدەماھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","بۇلار بولسا ئىسمائىلنىڭ ئوغۇللىرى بولۇپ، ئۇلارنىڭ كەنت ۋە چېدىرگاھلىرى ئۇلارنىڭ نامى بىلەن ئاتالغان بولۇپ، ئۇلار ئون ئىككى قەبىلىگە ئەمىر بولغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ئىسمائىلنىڭ ئۆمرىنىڭ يىللىرى بىر يۈز ئوتتۇز يەتتە يىل بولدى؛ ئۇ ئاخىرقى نەپسىنى تارتىپ ۋاپات بولۇپ، ئۆز قوۋمىنىڭ قېشىغا بېرىپ قوشۇلدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ئۇنىڭ ئەۋلادلىرى ھاۋىلاھ رايونىدىن تارتىپ شۇرغىچە ئولتۇراقلاشتى (شۇر بولسا مىسىرنىڭ ئۇتتۇرىسىدا بولۇپ، ئاشۇرغا بارىدىغان يولدا ئىدى). ئىسمائىل ئۆزىنىڭ بارلىق قېرىنداشلىرىنىڭ ئۇدۇلىدا ئولتۇراقلاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ئىبراھىمنىڭ ئوغلى ئىسھاقنىڭ نەسلىنىڭ بايانى مۇنداقتۇر: ــ ئىبراھىمدىن ئىسھاق تۆرەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ئىسھاق پادان-ئارامدا ئولتۇرۇشلۇق ئارامىي بېتۇئەلنىڭ قىزى، ئارامىي لاباننىڭ سىڭلىسى بولغان رىۋكاھنى خوتۇنلۇققا ئالغاندا قىرىق ياشقا كىرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ئەمما رىۋكاھ بولسا تۇغماس بولغاچقا، ئىسھاق خوتۇنى ئۈچۈن پەرۋەردىگارغا دۇئا-تىلاۋەت قىلدى؛ پەرۋەردىگار ئۇنىڭ دۇئاسىنى ئىجابەت قىلدى؛ شۇنىڭ بىلەن ئايالى رىۋكاھ ھامىلىدار بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ئەمما ئۇنىڭ قورسىقىدىكى ئىككى بالا بىر-بىرى بىلەن سوقۇشقىلى تۇردى. شۇنىڭ بىلەن رىۋكاھ: ــ ئەگەر بۇنداقلىقىنى بىلسەم، ھامىلىدار بولۇپ نېمە قىلاتتىم؟ ــ دەپ پەرۋەردىگاردىن سەۋەبىنى سورىغىلى باردى. ");
INSERT INTO uigara_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","پەرۋەردىگار ئۇنىڭغا: ــ «سېنىڭ قورسىقىڭدا ئىككى ئەل باردۇر، ئىچىڭدىن ئىككى خەلق چىقىپ بىر-بىرىدىن ئايرىلىدۇ، بىر خەلق يەنە بىر خەلقتىن غالىب كېلىدۇ، چوڭى كىچىكىنىڭ خىزمىتىنى قىلىدۇ» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ئۇنىڭ ئاي-كۈنى توشقاندا، مانا ئۇنىڭ قورسىقىدا دەرۋەقە بىر جۈپ قوشكېزەك بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ئاۋۋال تۇغۇلغىنى قىزغۇچ بولۇپ، پۈتۈن بەدىنى جۇۋىدەك تۈكلۈك ئىدى. ئۇلار ئۇنىڭ ئىسمىنى ئەساۋ دەپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ئاندىن ئىنىسى قولى بىلەن ئەساۋنىڭ تاپىنىنى تۇتقان ھالدا چىقتى. بۇ سەۋەبتىن ئۇنىڭ ئىسمى ياقۇپ دەپ قويۇلدى. ئۇلار تۇغۇلغاندا ئىسھاق ئاتمىش ياشتا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","بالىلار ئۆسۈپ چوڭ بولدى؛ ئەساۋ ماھىر ئوۋچى بولۇپ، دالا-جاڭگالدا يۈرىدىغان ئادەم بولدى. ياقۇپ بولسا دۇرۇس ئادەم بولۇپ، چېدىرلاردا تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ئىسھاق ئەساۋنىڭ ئوۋلاپ كەلگەن گۆشىدىن دائىم يەپ تۇرغاچقا، ئۇنىڭغا ئامراق ئىدى. لېكىن رىۋكاھ ياقۇپقا ئامراق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","بىر كۈنى ياقۇپ پۇرچاق شورپىسى قاينىتىۋاتاتتى؛ ئەساۋ دالادىن ھېرىپ-ئېچىپ قايتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ئەساۋ ياقۇپقا: ــ مەن ھالىمدىن كەتتىم! ئۆتۈنۈپ قالاي، ئاۋۇ قىزىلدىن بەرسەڭ! ــ ئاۋۇ قىزىل نەرسىدىن مېنى ئوزۇقلاندۇرساڭچۇ! مەن ھالىمدىن كەتتىم، ــ دېدى (شۇ سەۋەبتىن ئۇنىڭ ئېتى «ئېدوم» دەپمۇ ئاتالدى). ");
INSERT INTO uigara_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ياقۇپ ئۇنىڭغا: ــ ئۇنداق بولسا، تۇنجىلىق ھوقۇقۇڭنى ماڭا سېتىپ بەرگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ئەساۋ: ــ مەن ئۆلەي دەۋاتىمەن، بۇ تۇنجىلىق ھوقۇقىنىڭ ماڭا نېمە پايدىسى؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ياقۇپ: ــ ئەمىسە ھازىر ماڭا قەسەم قىلغىن، دېۋىدى، ئۇ ئۇنىڭغا قەسەم قىلىپ، تۇنجىلىق ھوقۇقىنى ياقۇپقا سېتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","شۇنىڭ بىلەن ياقۇپ ئەساۋغا نان بىلەن قىزىل پۇرچاق شورپىسىنى بەردى. ئۇ يەپ-ئىچىپ ئورنىدىن تۇرۇپ كەتتى. شۇنداق قىلىپ ئەساۋ تۇنجىلىق ھوقۇقىغا شۇنچە ئېتىبارسىز قارىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","قانائان زېمىنىدا ئىبراھىمنىڭ ۋاقتىدىكى ئاچارچىلىقتىن باشقا يەنە بىر قېتىملىق ئاچارچىلىق يۈز بەردى. شۇنىڭ بىلەن ئىسھاق گەرار شەھىرىگە، فىلىستىيلەرنىڭ پادىشاھى ئابىمەلەكنىڭ قېشىغا باردى. ");
INSERT INTO uigara_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","پەرۋەردىگار ئۇنىڭغا كۆرۈنۈپ مۇنداق دېدى: ــ سەن مىسىرغا چۈشمەي، بەلكى مەن ساڭا كۆرسىتىپ بېرىدىغان يۇرتتا تۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","موشۇ زېمىندىن چىقماي مۇساپىر بولۇپ تۇرغىن؛ شۇنىڭ بىلەن مەن سەن بىلەن بىللە بولۇپ، ساڭا بەخت-بەرىكەت ئاتا قىلىمەن؛ چۈنكى مەن سەن ۋە نەسلىڭگە بۇ زېمىنلارنىڭ ھەممىسىنى بېرىپ، ئاتاڭ ئىبراھىمغا بەرگەن قەسىمىمنى ئادا قىلىمەن؛ ");
INSERT INTO uigara_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","نەسلىڭنى ئاسماندىكى يۇلتۇزلاردەك ئاۋۇتىمەن ۋە نەسلىڭگە بۇ زېمىنلارنىڭ ھەممىسىنى بېرىمەن؛ يەر يۈزىدىكى بارلىق ئەل-يۇرتلار نەسلىڭنىڭ نامى بىلەن ئۆزلىرىگە بەخت-بەرىكەت تىلەيدۇ؛    ");
INSERT INTO uigara_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","چۈنكى ئىبراھىم مېنىڭ ئاۋازىمغا قۇلاق سېلىپ، تاپىلىغىنىم، ئەمرلىرىم، بەلگىلىمىلىرىم ۋە قانۇنلىرىمنى بەجا كەلتۈردى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","شۇنىڭ بىلەن ئىسھاق گەراردا تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ئەمما ئۇ يەرلىك كىشىلەر ئۇنىڭ ئايالى توغرىسىدا سورىسا ئۇ: ــ بۇ مېنىڭ سىڭلىم بولىدۇ، ــ دېدى؛ چۈنكى رىۋكاھ ئىنتايىن چىرايلىق بولغاچقا، ئىسھاق ئۆز-ئۆزىگە: «بۇ مېنىڭ ئايالىم بولىدۇ»، دېسەم، بۇ يەرلىك ئادەملەر رىۋكاھنىڭ سەۋەبىدىن مېنى ئۆلتۈرۈۋېتەرمىكىن، ــ دەپ قورقتى. ");
INSERT INTO uigara_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","لېكىن ئۇ شۇ يەردە ئۇزاق ۋاقىت تۇرغاندىن كېيىن شۇنداق بولدىكى، فىلىستىيلەرنىڭ پادىشاھى ئابىمەلەك دەرىزىدىن قارىۋىدى، مانا ئىسھاق ۋە ئايالى رىۋكاھ بىر-بىرىگە ئەركىلىشىپ تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ئاندىن ئابىمەلەك ئىسھاقنى چاقىرىپ: ــ مانا، ئۇ جەزمەن سېنىڭ ئايالىڭ ئىكەن! سەن نېمە دەپ: «ئۇ مېنىڭ سىڭلىم»، دېدىڭ؟ ــ دېۋىدى، ئىسھاق ئۇنىڭغا: ــ چۈنكى مەن ئەسلىدە ئۇنىڭ سەۋەبىدىن بىرسى مېنى ئۆلتۈرۈۋېتەرمىكىن، دەپ ئەنسىرىگەنىدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ئابىمەلەك ئۇنىڭغا: بۇ بىزگە نېمە قىلغىنىڭ؟ تاس قاپتۇ خەلق ئارىسىدىن بىرەرسى ئايالىڭ بىلەن بىرگە بولغىلى؟! ئۇنداق بولغان بولسا سەن بىزنى گۇناھقا پاتقۇزغان بولاتتىڭ! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ئاندىن ئابىمەلەك ھەممە خەلققە بۇيرۇپ: ــ كىمكى بۇ كىشىگە ۋە ياكى خوتۇنىغا قول تەگكۈزسە جەزمەن ئۆلتۈرۈلمەي قالمايدۇ، ــ دەپ يارلىق چۈشۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ئىسھاق ئۇ زېمىندا تېرىقچىلىق قىلدى: ئۇ شۇ يىلى يەردىن يۈز ھەسسە ھوسۇل ئالدى؛ پەرۋەردىگار ئۇنى بەرىكەتلىگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","بۇ كىشى باش كۆتۈرۈپ، بارغانسېرى راۋاج تېپىپ، تولىمۇ كاتتا كىشىلەردىن بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ئۇنىڭ قوي-كالا پادىلىرى ۋە ئۆيىدىكى قۇللىرى ئىنتايىن كۆپەيدى؛ فىلىستىيلەر ئۇنىڭغا ھەسەت قىلغىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","بۇ سەۋەبتىن ئۇنىڭ ئاتىسى ئىبراھىمنىڭ كۈنلىرىدە ئاتىسىنىڭ قۇللىرى كولىغان قۇدۇقلارنىڭ ھەممىسىنى فىلىستىيلەر ئېتىپ، توپا بىلەن تىندۇرۇۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ئابىمەلەك ئىسھاققا: ــ سەن بىزدىن زىيادە كۈچىيىپ كەتتىڭ، ئەمدى ئارىمىزدىن چىقىپ كەتكىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ئىسھاق ئۇ يەردىن كېتىپ، گەرار ۋادىسىغا چېدىر تىكىپ، شۇ يەردە تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ئىبراھىم ھايات ۋاقتىدا قۇللىرى بىرمۇنچە قۇدۇقلارنى قازغانىدى؛ بىراق ئىبراھىم ئۆلگەندىن كېيىن، فىلىستىيلەر بۇلارنى توپا بىلەن تىندۇرۇۋەتكەنىدى. ئىسھاق بۇ قۇدۇقلارنى قايتىدىن كولىتىپ، ئۇلارغا ئاتىسى ئىلگىرى قويغان ئىسىملارنى يەنە قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ئىسھاقنىڭ قۇللىرى ۋادىدا قۇدۇق كولاۋاتقاندا سۇلىرى ئۇرغۇپ چىقىپ ئاقىدىغان بىر قۇدۇقنى تېپىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","لېكىن گەراردىكى پادىچىلار ئىسھاقنىڭ پادىچىلىرىدىن ئۇنى تالىشىپ: ــ بۇ سۇ بىزنىڭكىدۇر، ــ دېدى. ئۇلار ئىسھاق بىلەن جېدەللەشكەچكە، ئۇ بۇ قۇدۇقنى «ئېسەك» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ئۇلار يەنە باشقا بىر قۇدۇقنى كولىدى، ئۇلار يەنە بۇ قۇدۇق توغرىسىدا جېدەللەشتى. شۇنىڭ بىلەن ئىسھاق بۇنىڭ ئىسمىنى «سىتناھ» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ئاندىن ئۇ ئۇ يەردىن كېتىپ، باشقا يەرگە بېرىپ، شۇ يەردىمۇ يەنە بىر قۇدۇق كولىدى؛ ئەمدى گەراردىكىلەر بۇ قۇدۇقنى تالاشمىدى. بۇ سەۋەبتىن ئۇ ئۇنىڭ ئېتىنى «رەھوبوت» قويۇپ: «ئەمدى پەرۋەردىگار بىز ئۈچۈن جاي بەرگەنىكەن، بۇ زېمىندا مېۋىلىك بولىمىز»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ئاندىن ئۇ ئۇ يەردىن چىقىپ بەئەر-شېباغا باردى. ");
INSERT INTO uigara_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","پەرۋەردىگار شۇ كېچىسى ئۇنىڭغا كۆرۈنۈپ: ــ مەن بولسام ئاتاڭ ئىبراھىمنىڭ خۇداسىدۇرمەن؛ قورقمىغىن، چۈنكى مەن سەن بىلەن بىللىمەن، سېنى بەخت-بەرىكەتلەپ، نەسلىڭنى قۇلۇم ئىبراھىمنىڭ سەۋەبىدىن ئاۋۇتىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ئۇ شۇ يەردە بىر قۇربانگاھ ياساپ، پەرۋەردىگارنىڭ نامىغا نىدا قىلىپ ئىبادەت قىلدى. ئۇ شۇ يەردە چېدىرىنى تىكتى، ئىسھاقنىڭ قۇللىرى شۇ يەردە بىر قۇدۇق كولىدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ئەمدى ئابىمەلەك، ئاغىنىسى ئاھۇززات بىلەن لەشكەربېشى فىكول بىرگە گەراردىن چىقىپ، ئۇنىڭ قېشىغا باردى. ");
INSERT INTO uigara_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ئىسھاق ئۇلارغا: ــ ماڭا ئۆچمەنلىك قىلىپ، مېنى ئاراڭلاردىن قوغلىۋەتكەندىن كېيىن، نېمە ئۈچۈن مېنىڭ قېشىمغا كەلدىڭلار؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_28‏","002_26_28‏","GEN","26","28‏","29","ئۇلار جاۋابەن: ــ بىز پەرۋەردىگارنىڭ سەن بىلەن بىللە بولغىنىنى روشەن بايقىدۇق، شۇنىڭ بىلەن بىز سېنىڭ توغراڭدا: «ئوتتۇرىمىزدا بىر كېلىشىم بولسۇن، يەنى بىزلەر بىلەن سەن بىر-بىرىمىزگە قەسەم بېرىپ ئەھدە قىلىشايلى» دېدۇق؛ شۇ ۋەجىدىن سەن بىزگە ھېچقانداق زىيان-زەخمەت يەتكۈزمىگەيسەن؛ بىز ساڭا ھېچ تەگمىگىنىمىزدەك، شۇنداقلا ساڭا ياخشىلىقتىن باشقا ھېچبىر نېمە قىلمىغىنىمىزدەك (بەلكى سېنى ئامان-ئېسەنلىك ئىچىدە يولۇڭغا ئەۋەتكەنىدۇق) سەنمۇ شۇنداق قىلغايسەن. مانا ھازىر سەن پەرۋەردىگار تەرىپىدىن بەخت-بەرىكەت كۆرۈۋاتىسەن! ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","شۇنىڭ بىلەن ئۇ ئۇلارغا بىر زىياپەت قىلىپ بەردى. ئۇلار بولسا يەپ-ئىچتى. ");
INSERT INTO uigara_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ئەتىسى تاڭ سەھەردە ئۇلار قوپۇپ بىر-بىرىگە قەسەم قىلىشتى؛ ئاندىن ئىسھاق ئۇلارنى يولغا سېلىپ قويدى؛ ئۇلار ئۇنىڭ قېشىدىن ئامان-ئېسەن كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ئۇ كۈنى شۇنداق بولدىكى، ئىسھاقنىڭ قۇللىرى كېلىپ، ئۇنىڭغا ئۆزى كولىغان قۇدۇق توغرىسىدا خەۋەر بېرىپ: «بىز سۇ تاپتۇق!» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ئۇ ئۇنىڭ نامىنى «شېباھ» قويدى. بۇ سەۋەبتىن بۇ شەھەرنىڭ ئىسمى بۈگۈنگىچە «بەئەر-شېبا» دەپ ئاتىلىپ كەلمەكتە. ");
INSERT INTO uigara_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ئەساۋ قىرىق ياشقا كىرگەندە، ھىتتىيلاردىن بولغان بەئەرىنىڭ قىزى يەھۇدىت بىلەن ھىتتىيلاردىن بولغان ئېلوننىڭ قىزى باسىماتنى خوتۇنلۇققا ئالدى. ");
INSERT INTO uigara_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ئەمما بۇلار ئىسھاق بىلەن رىۋكاھنىڭ كۆڭلىگە ئازاب ئېلىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ئىسھاق قېرىپ، كۆزلىرى تورلىشىپ، كۆزى غۇۋا كۆرىدىغان بولۇپ قالغاندا شۇنداق بولدىكى، ئۇ چوڭ ئوغلى ئەساۋنى چاقىرىپ ئۇنىڭغا: ــ ئوغلۇم! ــ دېدى. ئۇ: ــ مانا مەن! ــ دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ئۇ ئۇنىڭغا: ــ مانا مەن ئەمدى قېرىپ كەتتىم، قانچىلىك كۈن كۆرىدىغىنىمنىمۇ بىلمەيمەن. ");
INSERT INTO uigara_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","شۇڭا سەندىن ئۆتۈنىمەن، قوراللىرىڭ، يەنى ساداق ۋە ئوقيايىڭنى ئېلىپ جاڭگالغا چىقىپ، مەن ئۈچۈن بىر ئوۋ ئوۋلاپ كەل؛ ");
INSERT INTO uigara_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","مەن ياخشى كۆرىدىغان مەززىلىك تاماقتىن بىرنى ئېتىپ، ماڭا كەلتۈرگىن. مەن ئۇنى يەپ، ئۆلۈشتىن ئىلگىرى كۆڭلۈمدىن ساڭا بەخت-بەرىكەت تىلەپ دۇئا قىلاي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ئىسھاق ئوغلى ئەساۋغا سۆز قىلغاندا رىۋكاھمۇ ئاڭلىدى. ئەساۋ ئوۋ ئوۋلاپ كەلگىلى جاڭگالغا چىقىپ كەتكەندە، ");
INSERT INTO uigara_vpl VALUES ("GN27_6‏","002_27_6‏","GEN","27","6‏","7","رىۋكاھ ئوغلى ياقۇپقا: ــ مانا مەن ئاتاڭنىڭ ئاكاڭ ئەساۋغا: «سەن ئوۋ ئوۋلاپ كېلىپ، ماڭا مەززىلىك بىر تائامنى ئەتكىن؛ مەن ئۇنى يەپ ئۆلۈپ كېتىشتىن بۇرۇن پەرۋەردىگار ئالدىدا ساڭا بەخت-بەرىكەت تىلەپ دۇئا قىلاي»، ــ دەپ ئېيتقىنىنى ئاڭلاپ قالدىم. ");
INSERT INTO uigara_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ئەمدى، ئى ئوغلۇم، سۆزۈمگە قۇلاق سېلىپ بۇيرۇغىنىمنى قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","سەن دەرھال پادىغا بېرىپ، ئۆچكىلەرنىڭ ئىچىدىن ئېسىل ئىككى ئوغلاقنى ئېلىپ كەلگىن؛ مەن ئۇلاردىن ئاتاڭ ئۈچۈن ئۇ ياخشى كۆرىدىغان مەززىلىك بىر تائام تەييار قىلاي. ");
INSERT INTO uigara_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","سەن ئۇنى ئاتاڭنىڭ ئالدىغا ئېلىپ كىرگىن. شۇنىڭ بىلەن ئۇ يەپ، ئۆلۈپ كېتىشتىن بۇرۇن ساڭا بەخت-بەرىكەت تىلەپ دۇئا قىلىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","لېكىن ياقۇپ ئانىسى رىۋكاھغا: ــ مانا ئاكام ئەساۋ بولسا تۈكلۈك كىشى، مەن بولسام تۈكسىز سىلىق تەنلىك ئادەممەن. ");
INSERT INTO uigara_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","مۇبادا ئاتام مېنى سىلاپ قالسا، ئۇنداقتا مەن ئۇنىڭ نەزىرىدە ئۇنى مازاق قىلغۇچى ئادەم بولۇپ قېلىپ، بېشىمغا بەرىكەت ئەمەس، بەلكى لەنەت تاپارمەنمىكىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ئانىسى ئۇنىڭغا: ــ ئەي ئوغلۇم، ساڭا چۈشىدىغان لەنەت ماڭا چۈشسۇن؛ ئەمما سەن پەقەت سۆزۈمگە قۇلاق سېلىپ، بېرىپ ئوغلاقلارنى ئېلىپ كەل، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ئۇ بېرىپ ئۇلارنى ئېلىپ كېلىپ، ئانىسىغا بەردى. ئانىسى ئۇنىڭ ئاتىسى ياخشى كۆرىدىغان مەززىلىك بىر تائامنى تەييار قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ئاندىن رىۋكاھ تۇنجى ئوغلى ئەساۋنىڭ ئۆيدە ئۆز يېنىدا ساقلاقلىق ئەڭ ئېسىل كىيىملىرىنى ئېلىپ كىچىك ئوغلى ياقۇپقا كىيدۈرۈپ، ");
INSERT INTO uigara_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ئوغلاقلارنىڭ تېرىسىنى ئىككى قولى بىلەن بوينىنىڭ تۈكسىز جايىغا يۆگەپ، ");
INSERT INTO uigara_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ئاندىن ئۆزى ئەتكەن مەززىلىك تائاملار بىلەن نانلارنى ئوغلى ياقۇپنىڭ قولىغا تۇتقۇزدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ياقۇپ ئاتىسىنىڭ قېشىغا كىرىپ: ــ ئەي ئاتا! دېدى. ئۇ: ــ مانا مەن! ئوغلۇم، سەن كىم بولىسەن؟ ــ دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ياقۇپ ئاتىسىغا جاۋاب بېرىپ: ــ مەن چوڭ ئوغۇللىرى ئەساۋمەن، ماڭا ئېيتقانلىرىدەك قىلدىم؛ ئەمدى ئورۇنلىرىدىن تۇرۇپ، ئولتۇرۇپ قىلغان ئوۋۇمنىڭ گۆشىگە ئېغىز تېگىپ، ئاندىن كۆڭۈللىرىدىن ماڭا بەخت-بەرىكەت تىلەپ دۇئا قىلغايلا، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ئىسھاق ئوغلىغا: ــ ئەي ئوغلۇم، قانداقمۇ ئۇنى شۇنچە تېز تېپىپ كەلدىڭ؟ ــ دېۋىدى، ئۇ جاۋاب بېرىپ: ــ چۈنكى پەرۋەردىگار خۇدالىرى ئۇنى دەل يولۇمغا يولۇقتۇردى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ئىسھاق ياقۇپقا: ــ ئەي ئوغلۇم، يېقىنراق كەل، سەن راست ئوغلۇم ئەساۋمۇ، ئەمەسمۇ، سىلاپ باقاي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","شۇنىڭ بىلەن ياقۇپ ئاتىسى ئىسھاقنىڭ قېشىغا يېقىن باردى؛ ئۇ ئۇنى سىلاپ تۇرۇپ: ــ ئاۋاز ياقۇپنىڭ ئاۋازى، لېكىن قول بولسا ئەساۋنىڭ قولىدۇر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ئۇنىڭ قوللىرى بولسا ئاكىسى ئەساۋنىڭ قوللىرىدەك تۈكلۈك بولغىنى ئۈچۈن ئۇنى تونۇيالماي، ئۇنىڭغا بەخت-بەرىكەت تىلەپ دۇئا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ئاندىن ئۇ يەنە: ــ سەن راست ئوغلۇم ئەساۋمۇسەن؟ دەپ سورىۋىدى، ئۇ جاۋاب بېرىپ: ــ دەل مەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ئىسھاق ئۇنىڭغا: ــ تائامنى ئېلىپ كەلگىن، مەن ئوغلۇمنىڭ ئوۋ گۆشىدىن يەپ، كۆڭلۈمدىن ساڭا بەخت-بەرىكەت تىلەپ دۇئا قىلاي، ــ دېدى. ياقۇپ ئۇنى ئۇنىڭ ئالدىغا قويدى؛ ئۇ يېدى. ئۇ شاراب كەلتۈرۈۋىدى، ئۇنىمۇ ئىچتى. ");
INSERT INTO uigara_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ئاندىن ئاتىسى ئىسھاق ئۇنىڭغا: ــ ئەي ئوغلۇم، ئەمدى يېقىن كېلىپ مېنى سۆيگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ئۇ ئۇنىڭ قېشىغا بېرىپ ئۇنى سۆيدى. ئاتىسى ئۇنىڭ كىيىمىنىڭ پۇرىقىنى پۇراپ ئۇنىڭغا بەخت-بەرىكەت تىلەپ دۇئا قىلىپ: ــ «مانا، ئوغلۇمنىڭ تېنىدىكى پۇراق پەرۋەردىگار بەرىكەتلىگەن كۆكلەمزارنىڭ خۇش پۇرىقىغا ئوخشايدىكەن! ");
INSERT INTO uigara_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","خۇدا ساڭا ئاسماننىڭ شەبنىمى، يەرنىڭ مۇنبەت كۈچىنى ئاتا قىلىپ، ئاشلىق-تۈلۈك بىلەن شارابنىمۇ كۆپ بەرگەي. ");
INSERT INTO uigara_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","خەلقلەر سېنىڭ قۇللۇقۇڭدا بولغاي، ئەل-مىللەتلەر ئالدىڭدا تىزلانغاي؛ قېرىنداشلىرىڭغا خوجا بولغايسەن؛ ئاناڭنىڭ ئوغۇللىرى ساڭا تىزلانغاي؛ ساڭا لەنەت قىلغانلار لەنەتكە قالغاي؛ ساڭا بەخت تىلىگەنلەر بەخت تاپقاي!» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","شۇنداق بولدىكى، ئىسھاق ياقۇپقا دۇئا قىلىپ بولۇپ، ياقۇپ ئاتىسى ئىسھاقنىڭ قېشىدىن چىقىپ بولۇشىغا، ئاكىسى ئەساۋ ئوۋدىن قايتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ئۇمۇ مەززىلىك تائاملارنى ئېتىپ، ئاتىسىنىڭ قېشىغا ئېلىپ كىرىپ، ئاتىسىغا: ــ ئاتا قوپقايلا، ئوغۇللىرىنىڭ ئوۋ گۆشىدىن يەپ، كۆڭۈللىرىدىن ماڭا بەخت-بەرىكەت تىلەپ دۇئا قىلغايلا، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ئاتىسى ئىسھاق ئۇنىڭغا: ــ سەن كىمسەن؟ ــ دېدى. ئۇ جاۋاب بېرىپ: ــ مەن ئوغۇللىرى، چوڭ ئوغۇللىرى ئەساۋمەن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","بۇنى ئاڭلاپ ئىسھاق ئالاقزادىلىككە چۈشۈپ، پۈتۈن بەدىنى جالاقلاپ تىترەپ: ــ ئۇنداقتا باياتىن ئوۋ ئوۋلاپ ئېلىپ كەلگىنى كىم؟ سەن كېلىشتىن بۇرۇن ئۇنىڭ ھەممە نەرسىسىدىن يەپ، ئۇنىڭغا بەخت-بەرىكەت تىلەپ دۇئا قىلدىم؛ ۋە بەرھەق، ئۇ بەخت-بەرىكەت كۆرىدۇ! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ئەساۋ ئاتىسىنىڭ سۆزلىرىنى ئاڭلاپلا ئىنتايىن ئېچىنارلىق ھالدا ئۈن سېلىپ ئاچچىق پەرياد كۆتۈرۈپ ئاتىسىغا: ــ مېنىمۇ، ئى ئاتا، مېنىمۇ بەخت-بەرىكەتلىگەيلا! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ئۇ جاۋاب بېرىپ: ــ سېنىڭ ئىنىڭ ھىيلە بىلەن كىرىپ، ساڭا تېگىشلىك بەخت-بەرىكەتنى ئېلىپ كېتىپتۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ئەساۋ: ــ راست ئۇنىڭ ئېتى ياقۇپ ئەمەسمۇ؟! چۈنكى ئۇ ئىككى قېتىم مېنى پۇتلاپ، ئورنۇمنى تارتىۋالدى. ئاۋۋال تۇنجىلىق ھوقۇقۇمنى تارتىۋالدى ۋە مانا ھازىر ئۇ ماڭا تېگىدىغان بەخت-بەرىكەتنى ئېلىپ كەتتى، ــ دېدى، ئاندىن يەنە: ــ مېنىڭ ئۈچۈن بىرەر بەخت-بەرىكەت قالدۇرمىدىلىمۇ؟ ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ئىسھاق ئەساۋغا جاۋاب بېرىپ: ــ مانا، مەن ئۇنى ئۈستۈڭگە خوجا قىلدىم؛ ھەممە قېرىنداشلىرىنى ئۇنىڭ قۇللۇقىدا بولىدىغان قىلدىم؛ ئاشلىق ۋە يېڭى شاراب بىلەن ئۇنى قۇۋۋەتلىدىم؛ ئەي ئوغلۇم، ئەمدى ساڭا يەنە نېمىمۇ قىلىپ بېرەلەيمەن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ئەساۋ ئاتىسىغا يەنە: ــ ئەي ئاتا، سىلىدە پەقەت شۇ بىرلا بەخت-بەرىكەت بار ئىدىمۇ؟ ماڭا، ئەي ئاتا، ماڭىمۇ بەخت-بەرىكەت تىلەپ دۇئا قىلغايلا! دېدى. ئاندىن ئۇ ئۈن سېلىپ يىغلاپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ئاتىسى ئىسھاق ئۇنىڭغا جاۋاب بېرىپ: ــ «مانا، تۇرالغۇ جايىڭ يەرنىڭ مۇنبەت كۈچىدىن نېرى، ئېگىز ئاسماننىڭ شەبنىمىدىن يىراق بولۇر؛ ");
INSERT INTO uigara_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","سەن قىلىچىڭغا تايىنىپ جان باقىسەن، ئىنىڭنىڭ خىزمىتىدە بولىسەن؛ لېكىن چېگرىدىن چىقىپ كەزگىنىڭدە، سەن بوينۇڭدىن ئۇنىڭ بويۇنتۇرۇقىنى چىقىرىپ سۇندۇرۇۋېتىسەن» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","شۇڭا ئەساۋ ئاتىسى ئۇنىڭغا تىلىگەن بەخت-بەرىكەت سەۋەبىدىن ياقۇپقا ئۆچمەنلىك ساقلاپ يۈردى. ئەساۋ كۆڭلىدە: ــ ئاتامنىڭ ماتەم كۈنلىرى يېقىنلىشىپ قالدى؛ شۇ چاغدا ئىنىم ياقۇپنى ئۆلتۈرۈۋېتىمەن، دەپ خىيال قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","لېكىن رىۋكاھ چوڭ ئوغلى ئەساۋنىڭ بۇ سۆزلىرىدىن خەۋەر تاپتى. ئۇ كىچىك ئوغلى ياقۇپنى چاقىرىپ ئۇنىڭغا: ــ مانا ئاكاڭ ئەساۋ سېنى ئۆلتۈرۈۋېتىمەن دەپ ئۆز-ئۆزىدىن تەسەللى تېپىۋېتىپتۇ؛ ");
INSERT INTO uigara_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ئەمدى ئەي ئوغلۇم، سۆزۈمگە قۇلاق سېلىپ، قوپۇپ ھارانغا، ئاكام لاباننىڭ قېشىغا قېچىپ كەتكىن؛ ");
INSERT INTO uigara_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ئاكاڭنىڭ قەھرى يانغۇچە، ئۇنىڭ قېشىدا بىرنەچچە ۋاقىت تۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ئاكاڭ ئاچچىقىدىن يېنىپ، سېنىڭ ئۇنىڭغا قىلغىنىڭنى ئۇنتۇپ كەتكۈچە شۇ يەردە تۇرۇپ تۇرغىن؛ ئاندىن مەن ئادەم ئەۋەتىپ، سېنى ئۇ يەردىن ئالدۇرۇپ كېلىمەن. نېمە ئۈچۈن بىر كۈندىلا ھەر ئىككىڭلاردىن مەھرۇم بولۇپ قالاي؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ئەمما رىۋكاھ ئىسھاققا: ــ مەن مۇشۇ ھىتتىي قىزلار ۋەجىدىن جېنىمدىن جاق تويدۇم. ئەگەر ياقۇپمۇ بۇ يۇرتتىكى قىزلاردىن، مۇشۇنداق ھىتتىي قىزنى خوتۇنلۇققا ئالسا ياشىغىنىمنىڭ ماڭا نېمە پايدىسى؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","شۇنىڭ بىلەن ئىسھاق ياقۇپنى چاقىرىپ، ئۇنىڭغا بەخت-بەرىكەت تىلەپ، ئۇنىڭغا جېكىلەپ: ــ سەن قانائانىيلارنىڭ قىزلىرىدىن خوتۇن ئالما؛ ");
INSERT INTO uigara_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","بەلكى قوپۇپ، پادان-ئارامغا، ئاناڭنىڭ ئاتىسى بېتۇئەلنىڭ ئۆيىگە بېرىپ، ئۇ يەردىن ئاناڭنىڭ ئاكىسى لاباننىڭ قىزلىرىدىن خوتۇن ئالغىن. ");
INSERT INTO uigara_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ھەممىگە قادىر تەڭرى سېنى بەخت-بەرىكەتلەپ، ئاۋۇتۇپ، سەندىن كۆپ خەلقلەرنى چىقىرىپ كۆپەيتكەي، ");
INSERT INTO uigara_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","شۇنداقلا ئىبراھىمنىڭ بەخت-بەرىكىتىنى ساڭا ۋە سېنىڭ بىلەن نەسلىڭگە بەرگەي؛ شۇنداق قىلىپ سەن ھازىر مۇساپىر بولۇپ تۇرۇۋاتقان يەرنى، يەنى ئەسلىدە خۇدا ئىبراھىمغا بەرگەن زېمىننى ئىگىلەيسەن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","شۇنىڭ بىلەن ئىسھاق ياقۇپنى يولغا سالدى. ئۇ پادان-ئارامغا، ئارامىي بېتۇئەلنىڭ ئوغلى، ياقۇپ بىلەن ئەساۋنىڭ ئانىسى رىۋكاھنىڭ ئاكىسى لاباننىڭ قېشىغا قاراپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_6‏","002_28_6‏","GEN","28","6‏","7","ئەساۋ ئىسھاقنىڭ ياقۇپقا بەخت-بەرىكەت تىلەپ، ئۇنى پادان-ئارامغا شۇ يەردىن خوتۇن ئېلىشقا ئەۋەتكەنلىكىنى، شۇنداقلا ئۇنىڭغا بەخت-بەرىكەت تىلەپ، ئۇنىڭا جېكىلەپ: سەن قانائانىيلارنىڭ قىزلىرىدىن خوتۇن ئالمىغىن، دېگەنلىرىنى ئۇقۇپ، ياقۇپنىڭمۇ ئۆز ئاتا-ئانىسىغا ئىتائەت قىلىپ، پادان-ئارامغا كەتكىنىنى كۆرگىنىدە، ");
INSERT INTO uigara_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ئەساۋ: ــ قانائانيلارنىڭ قىزلىرى ئاتام ئىسھاقنىڭ نەزىرىدە يامان كۆرۈنىدىكەن، دەپ بىلىپ يەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ئۇ ئىسمائىلنىڭ قېشىغا بېرىپ، ھازىرقى خوتۇنلىرىنىڭ ئۈستىگە ئىبراھىمنىڭ ئوغلى ئىسمائىلنىڭ قىزى، نېبايوتنىڭ سىڭلىسى ماھالاتنى خوتۇنلۇققا ئالدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ياقۇپ بولسا بەئەر-شېبادىن چىقىپ، ھاران تەرەپكە مېڭىپ، ");
INSERT INTO uigara_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","بىر يەرگە يېتىپ كەلگەندە، كۈن ئولتۇرۇپ كەتكەچكە شۇ يەردە قونماقچى بولدى. ئۇ شۇ يەردىكى تاشلاردىن بىرىنى ئېلىپ، بېشىغا ياستۇق قىلىپ قويۇپ، ئۇخلىغىلى ياتتى. ");
INSERT INTO uigara_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ئۇ بىر چۈش كۆردى: ــ مانا، ئۇچى ئاسمانلارغا تاقىشىدىغان بىر پەلەمپەي يەردە تىكلەكلىك تۇراتتى؛ خۇدانىڭ پەرىشتىلىرى ئۇنىڭدا چىقىپ-چۈشۈپ تۇرۇشاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","مانا، پەرۋەردىگار ئۇنىڭ ئۈستىدە تۇراتتى. ئۇ: ــ «مەن بولسام ئاتاڭ ئىبراھىمنىڭ خۇداسى ۋە ئىسھاقنىڭ خۇداسى بولغان پەرۋەردىگاردۇرمەن؛ مەن سەن ياتقان بۇ زېمىننى سېنىڭ بىلەن نەسلىڭگە بېرىمەن.    ");
INSERT INTO uigara_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","نەسلىڭ بولسا يەرنىڭ توپىسىدەك كۆپ بولۇپ، سەن مەغرىب بىلەن مەشرىققە، شىمال بىلەن جەنۇبقا يېيىلىسەن؛ سەن ۋە نەسلىڭنىڭ ۋاسىتىسى بىلەن يەر يۈزىدىكى بارلىق ئائىلە-قەبىلىلەر بەخت-بەرىكەت تاپىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","مانا، مەن سەن بىلەن بىللىدۇرمەن، قەيەرگە بارساڭ سېنى ئامان-ئېسەن ساقلاپ، بۇ زېمىنغا سېنى قايتۇرۇپ كېلىمەن؛ چۈنكى ساڭا ئېيتقان سۆزۈمنى ئادا قىلماي تۇرۇپ، سېنى تاشلىمايمەن» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ئاندىن ياقۇپ ئويغىنىپ: ــ بەرھەق، پەرۋەردىگار بۇ يەردىدۇر، لېكىن مەن ئۇنى بىلمەپتىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ئۇ قورقۇپ كېتىپ: بۇ جاي ئالامەت دەھشەتلىك بىر جاي ئىكەن! بۇ خۇدانىڭ ئۆيى بىلەن ئاسماننىڭ دەرۋازىسىدىن باشقا ھېچ جاي ئەمەستۇر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ياقۇپ ئەتىسى سەھەر قوپۇپ، بېشىنىڭ ئاستىغا قويغان تاشنى ئېلىپ، خاتىرە تۈۋرۈك سۈپىتىدە تىكلەپ، ئۈستىگە زەيتۇن مېيى قۇيۇپ قويدى.    ");
INSERT INTO uigara_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ئۇ جاينىڭ ئىسمىنى بەيت-ئەل دەپ ئاتىدى؛ ئەمما ئىلگىرى ئۇ جاينىڭ ئېتى لۇز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ئاندىن ياقۇپ قەسەم بىلەن ۋەدە قىلىپ: ــ ئەگەر خۇدا مېنىڭ بىلەن بىللە بولۇپ، بۇ سەپىرىمدە مېنى ساقلاپ، يېگىلى نان، كىيگىلى كىيىم بېرىپ، ");
INSERT INTO uigara_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","مەن ئاتامنىڭ ئۆيىگە ئامان-ئېسەن يېنىپ بارسام، ئۇنداقتا پەرۋەردىگار مېنىڭ خۇدايىم بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","شۇنىڭدەك مەن خاتىرە تۈۋرۈك سۈپىتىدە تىكلەپ قويغان بۇ تاش خۇدانىڭ ئۆيى بولىدۇ؛ ھەم شۇنداقلا سەن ماڭا بېرىدىغان بارلىق نەرسىلەرنىڭ ئوندىن بىر ئۈلۈشىنى ساڭا تەقدىم قىلماي قالمايمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ئاندىن ياقۇپ سەپىرىنى داۋاملاشتۇرۇپ، مەشرىقتىكى قوۋملارنىڭ زېمىنىغا يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ئۇ قارىۋىدى، مانا، يايلاقتا بىر قۇدۇق تۇراتتى، ئۇنىڭ يېنىدا ئۈچ توپ قوي پادىسى تۇراتتى؛ چۈنكى خەلق بۇ قۇدۇقتىن پادىلارنى سۇغىراتتى. قۇدۇقنىڭ ئاغزىغا يوغان بىر تاش قويۇقلۇق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","قاچانىكى پادىلارنىڭ ھەممىسى ئۇ يەرگە يىغىلسا، پادىچىلار بىرلىكتە قۇدۇقنىڭ ئاغزىدىكى تاشنى يۇمىلىتىۋېتىپ، قويلارنى سۇغىرىپ، ئاندىن تاشنى يەنە قۇدۇقنىڭ ئاغزىغا ئۆز ئورنىغا قويۇپ قوياتتى. ");
INSERT INTO uigara_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ياقۇپ پادىچىلاردىن: ئەي بۇرادەرلەر، سىلەر قەيەرلىك؟ ــ دەپ سورىدى. ئۇلار: ــ بىز ھارانلىقمىز، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ئۇ ئۇلاردىن: ــ سىلەر ناھورنىڭ ئوغلى لاباننى تونۇمسىلەر؟ ــ دەپ سورىدى. ئۇلار: ــ تونۇيمىز، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ئۇ ئۇلاردىن: ــ ئۇ سالامەتمۇ، دەپ سورىۋىدى، ئۇلار جاۋاب بېرىپ: ــ ئۇ سالامەت تۇرۇۋاتىدۇ. مانا ئەنە ئۇنىڭ قىزى راھىلە قويلىرى بىلەن كېلىۋاتىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ئۇ: ــ مانا، كۈن تېخى ئېگىز تۇرسا، ھازىر تېخى مالنىڭ يىغىلىدىغان ۋاقتى بولمىدى؛ نېمىشقا قويلارنى سۇغىرىپ، ئاندىن يەنە بېرىپ ئوتلاتمايسىلەر؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ئۇلار جاۋاب بېرىپ: ــ ياق، مۇنداق قىلالمايمىز. ئاۋۋال پادىلارنىڭ ھەممىسى يىغىلىپ، پادىچىلار تاشنى قۇدۇقنىڭ ئاغزىدىن يۇمىلىتىۋەتكەندىن كېيىن، ئاندىن قويلارنى سۇغىرىمىز، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ئۇ ئۇلار بىلەن گەپلىشىپ تۇرغىنىدا، راھىلە ئاتىسىنىڭ قويلىرى بىلەن يېتىپ كەلدى؛ چۈنكى ئۇ قوي باققۇچى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","شۇنداق بولدىكى، ياقۇپ ئانىسىنىڭ ئاكىسى لاباننىڭ قىزى راھىلە بىلەن ئانىسىنىڭ ئاكىسى لاباننىڭ قويلىرىنى كۆرگەندە، ئۇ قوپۇپ بېرىپ، قۇدۇقنىڭ ئاغزىدىن تاشنى يۇمىلىتىۋېتىپ، ئانىسىنىڭ ئاكىسى لاباننىڭ قويلىرىنى سۇغاردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_11‏","002_29_11‏","GEN","29","11‏","12","ئاندىن ياقۇپ راھىلەنى سۆيۈپ، يۇقىرى ئاۋاز بىلەن يىغلاپ تاشلىدى ۋە راھىلەگە: ــ مەن سېنىڭ ئاتاڭنىڭ تۇغقىنى، رىۋكاھنىڭ ئوغلى بولىمەن، دېۋىدى، ئۇ يۈگۈرۈپ بېرىپ ئاتىسىغا خەۋەر بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","شۇنداق بولدىكى، لابان ئۆز سىڭلىسىنىڭ ئوغلى ياقۇپنىڭ خەۋىرىنى ئاڭلىغاندا، ئۇنىڭ ئالدىغا يۈگۈرۈپ بېرىپ، ئۇنى قۇچاقلاپ سۆيۈپ، ئۆيىگە باشلاپ كەلدى. ئاندىن ياقۇپ لابانغا كەچۈرمىشلىرىنىڭ ھەممىسىنى دەپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","لابان ئۇنىڭغا: ــ سەن دەرۋەقە مېنىڭ سۆڭەك بىلەن گۆشۈمدۇرسەن! ــ دېدى. بۇنىڭ بىلەن ئۇ ئۇنىڭ قېشىدا بىر ئايچە تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ئاندىن لابان ياقۇپقا: ــ سەن مېنىڭ تۇغقىنىم بولغاچ، ماڭا بىكارغا خىزمەت قىلامسەن؟ ئېيتقىنا، ھەققىڭگە نېمە ئالىسەن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","لاباننىڭ ئىككى قىزى بار ئىدى؛ چوڭىنىڭ ئېتى لېياھ، كىچىكىنىڭ ئېتى راھىلە ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","لېياھنىڭ كۆزلىرى يېقىملىق ئىدى؛ ئەمما راھىلەنىڭ بولسا تەقى-تۇرقى كېلىشكەن، ھۆسنى-جامالى چىرايلىق قىز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ياقۇپنىڭ كۆڭلى راھىلەگە چۈشكەن بولۇپ لابانغا: ــ مەن سېنىڭ كىچىك قىزىڭ راھىلە ئۈچۈن ساڭا يەتتە يىل خىزمەت قىلاي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لابان جاۋاب بېرىپ: ــ ئۇنى باشقا كىشىگە بەرگىنىمدىن ساڭا بەرگىنىم ياخشى. ئەمدى مېنىڭكىدە تۇرغىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ياقۇپ راھىلەنى ئېلىش ئۈچۈن يەتتە يىل خىزمەت قىلدى. ئەمما ئۇ ئۇنى ئىنتايىن ياخشى كۆرگەچكە، بۇ يىللار ئۇنىڭغا پەقەت بىرنەچچە كۈندەكلا بىلىندى. ");
INSERT INTO uigara_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ۋاقىت توشقاندا ياقۇپ لابانغا: ــ مانا مېنىڭ كۈنلىرىم توشتى. ئەمدى ئايالىمنى ماڭا بەرگىن، مەن ئۇنىڭ قېشىغا كىرەي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","لابان شۇ يەردىكى ھەممە كىشىلەرنى يىغىپ، زىياپەت قىلىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","لېكىن شۇنداق بولدىكى، كەچ كىرگەندە، ئۇ چوڭ قىزى لېياھنى ياقۇپنىڭ يېنىغا ئېلىپ كەلدى؛ ياقۇپ ئۇنىڭ قېشىغا كىرىپ بىللە بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","لابان ئۆز دېدىكى زىلپاھنى قىزى لېياھغا دېدەك قىلىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ئەتىسى شۇنداق بولدىكى، مانا ئالدىدا لېياھ تۇراتتى! ئۇ لابانغا: ــ بۇ زادى ماڭا نېمە قىلغىنىڭ؟ ئەجەبا، مەن راھىلە ئۈچۈن ساڭا خىزمەت قىلمىدىممۇ؟ مېنى نېمىشقا شۇنداق ئالدىدىڭ؟! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لابان: بىزنىڭ يۇرتىمىزدا كىچىكىنى چوڭىدىن ئىلگىرى ياتلىق قىلىدىغان رەسىم-قائىدە يوق. ");
INSERT INTO uigara_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ئەمدى سەن چوڭىنىڭ يەتتە كۈنلۈك توي مۇراسىمىنى ئۆتكۈزۈپ بولغىن؛ ئاندىن يەنە ئىككىنچىسىنىمۇ ساڭا بېرەيلى؛ ئۇ سېنىڭ ماڭا يەنە يەتتە يىل قىلىدىغان خىزمىتىڭنىڭ ھەققى بولىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ياقۇپ ماقۇل بولۇپ، لېياھنىڭ يەتتە كۈنلۈك توي مۇراسىمىنى ئۆتكۈزۈپ بولغاندا، لابان قىزى راھىلەنىمۇ ئۇنىڭغا خوتۇنلۇققا بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","لابان دېدىكى بىلھاھنى قىزى راھىلەگە دېدەك قىلىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","بۇ تەرىقىدە ياقۇپ راھىلەنىڭمۇ قېشىغا كىردى؛ ئۇ راھىلەنى لېياھدىن زىيادە ياخشى كۆردى. ئاندىن كېيىن ئۇ يەنە يەتتە يىل لابانغا خىزمەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ئەمما پەرۋەردىگار لېياھنىڭ ئەتىۋارلانمىغانلىقىنى كۆرگەندە، ئۇنىڭغا تۇغۇشنى نېسىپ قىلدى. لېكىن راھىلە تۇغماس ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","لېياھ ھامىلىدار بولۇپ بىر ئوغۇل تۇغۇپ: ــ «پەرۋەردىگار خارلانغىنىمنى كۆردى؛ ئەمدى ئېرىم مېنى ياخشى كۆرىدۇ» دەپ ئۇنىڭ ئىسمىنى «رۇبەن» قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ئۇ يەنە ھامىلىدار بولۇپ، بىر ئوغۇل تۇغۇپ: ــ «پەرۋەردىگار ئەتىۋارلانمىغانلىقىنى ئاڭلاپ، بۇنى ھەم ماڭا بەردى» دەپ، ئۇنىڭ ئىسمىنى شىمېئون قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ئۇ يەنە ھامىلىدار بولۇپ، بىر ئوغۇل تۇغۇپ: ــ «ئەمدى بۇ قېتىم ئېرىم ماڭا باغلىنىدۇ؛ چۈنكى مەن ئۇنىڭغا ئۈچ ئوغۇل تۇغۇپ بەردىم» دەپ ئۇنىڭ ئىسمىنى لاۋىي قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ئۇ يەنە ھامىلىدار بولۇپ، بىر ئوغۇل تۇغۇپ: ــ «ئەمدى بۇ قېتىم مەن پەرۋەردىگارغا ھەمدۇسانا ئوقۇي!» دەپ ئۇنىڭ ئىسمىنى يەھۇدا قويدى. ئاندىن ئۇ تۇغۇتتىن توختاپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ئەمما راھىلە ئۆزىنىڭ ياقۇپقا بالا تۇغۇپ بېرەلمىگىنىنى كۆرگەندە، ئاچىسىغا ھەسەت قىلىپ ياقۇپقا: ــ ماڭا بالا بەرگىن؛ بولمىسا ئۆلىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","شۇنىڭ بىلەن ياقۇپنىڭ راھىلەگە غەزىپى كېلىپ: ــ مەن بالىياتقۇنىڭ مېۋىسىنى سەندىن ئايىغان خۇدانىڭ ئورنىدىمۇ؟! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ــ مانا، دېدىكىم بىلھاھ بۇ يەردە تۇرىدۇ؛ سەن ئۇنىڭ قېشىغا كىرگىن، ئۇ مېنىڭ قۇچىقىمغا تۇغسۇن؛ مەن ئۇ ئارقىلىق بالىلىق بولاي، ــ دېدى راھىلە. ");
INSERT INTO uigara_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","شۇنىڭ بىلەن ئۇ دېدىكى بىلھاھنى ئۇنىڭغا خوتۇن قىلىپ بەردى؛ ياقۇپ ئۇنىڭ قېشىغا كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","بىلھاھ ھامىلىدار بولۇپ، ياقۇپقا بىر ئوغۇل تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","راھىلە: ــ «خۇدا مەن ئۈچۈن ئادالەت يۈرگۈزۈپ پەريادىمنى ئاڭلاپ، ماڭا بىر ئوغۇل بەردى»، دەپ ئۇنىڭ ئىسمىنى دان قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","راھىلەنىڭ دېدىكى بىلھاھ يەنە ھامىلىدار بولۇپ، ياقۇپقا ئىككىنچى ئوغلىنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","راھىلە: ــ «مەن ئاچام بىلەن بەسلىشىپ قاتتىق تۇتۇشۇپ، يەڭدىم» دەپ ئۇنىڭ ئىسمىنى نافتالى قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","لېياھ ئۆزىنىڭ تۇغۇتتىن توختاپ قالغانىنى كۆرۈپ، دېدىكى زىلپاھنى ياقۇپقا خوتۇن قىلىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","لېياھنىڭ دېدىكى زىلپاھ ياقۇپقا بىر ئوغۇل تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","لېياھ: ــ «نېمىدېگەن تەلەيلىك-ھە!» دەپ ئۇنىڭ ئىسمىنى گاد قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","لېياھنىڭ دېدىكى زىلپاھ ياقۇپقا ئىككىنچى ئوغلىنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","لېياھ: «مەن بەختلىكتۇرمەن! چۈنكى خوتۇن-قىزلار مېنى بەختلىك دېيىشىدۇ!» دەپ ئۇنىڭ ئىسمىنى ئاشىر قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","بۇغداي ئورمىسى كۈنلىرىدە رۇبەن چىقىپ ئېتىزلىققا باردى ۋە ئېتىزدىن بىرقانچە مۇھەببەتگۈلىنى تېرىپ، بۇلارنى ئانىسى لېياھنىڭ قېشىغا ئەكەلدى. ئەمدى راھىلە لېياھقا: ــ ئۆتۈنۈپ قالاي، ئوغلۇڭنىڭ مۇھەببەتگۈلىدىن بىرنەچچىنى ماڭا بەرگىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","لېياھ ئۇنىڭغا جاۋابەن: ــ ئېرىمنى تارتىۋالغىنىڭ يەتمەمدۇ؟ ئەمدى ئوغلۇمنىڭ مۇھەببەتگۈلىنىمۇ تارتىۋالماقچىمۇسەن؟ ــ دېدى. راھىلە جاۋاب بېرىپ: ــ ئۇنداق بولسا ئۇ ئوغلۇڭنىڭ مۇھەببەتگۈللىرى ئۈچۈن بۈگۈن كېچە سەن بىلەن ياتسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ياقۇپ كەچقۇرۇن ئېتىزدىن قايتىپ كەلگىنىدە، لېياھ ئۇنىڭ ئالدىغا چىقىپ: ــ مېنىڭ قېشىمغا كىرىشىڭ كېرەك؛ چۈنكى مەن ئوغلۇمنىڭ مۇھەببەتگۈللىرى بىلەن سېنى ئىجارىگە ئالدىم، ــ دېدى. شۇنداق دېۋىدى، ئۇ بۇ كېچە ئۇنىڭ بىلەن ياتتى. ");
INSERT INTO uigara_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","خۇدا لېياھنىڭ دۇئاسىنى ئاڭلىدى؛ ئۇ ھامىلىدار بولۇپ، ياقۇپقا بەشىنچى ئوغلىنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","شۇنىڭ بىلەن لېياھ: «دېدىكىمنى ئېرىمگە بەرگىنىمگە خۇدا ئەمدى ماڭا «ئىجارە ھەققىم»نى ئاتا قىلدى» دەپ ئۇنىڭ ئىسمىنى ئىسساكار قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","لېياھ يەنە ھامىلىدار بولۇپ، ياقۇپقا ئالتىنچى ئوغلىنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","لېياھ: ــ «خۇدا ماڭا ياخشى تويلۇق ئاتا قىلدى؛ ئەمدى ئېرىم مېنىڭ بىلەن بىللە تۇرىدىغان بولدى؛ چۈنكى مەن ئۇنىڭغا ئالتە ئوغۇل تۇغۇپ بەردىم» دەپ ئۇنىڭ ئىسمىنى زەبۇلۇن قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","شۇنىڭدىن كېيىن، ئۇ بىر قىز تۇغۇپ، ئۇنىڭ ئىسمىنى دىناھ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ئەمما خۇدا راھىلەنى ياد قىلىپ، دۇئاسىنى ئاڭلاپ ئۇنى تۇغىدىغان قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ئۇ ھامىلىدار بولۇپ، بىر ئوغۇل تۇغدى. ئۇ: ــ «خۇدا مېنى نومۇستىن خالاس قىلدى»، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ئۇ: ــ «پەرۋەردىگار ماڭا يەنە بىر بالا بەرسە» دەپ، ئۇنىڭ ئىسمىنى يۈسۈپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","راھىلە يۈسۈپنى تۇغقاندىن كېيىن ياقۇپ لابانغا: ــ مېنى ئۆز يۇرتۇمغا، ئۆز ۋەتىنىمگە كەتكىلى قويغىن. ");
INSERT INTO uigara_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","مېنىڭ ساڭا ئىشلەپ ئېرىشكەن ئىش ھەققىم بولغان ئاياللىرىم بىلەن بالىلىرىمنى ماڭا بەرگىن؛ مەن كېتەي؛ چۈنكى مېنىڭ ساڭا ئىشلىگەن جاپالىق خىزمىتىم ئۆزۈڭگە ئايان، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","لابان ئۇنىڭغا جاۋابەن: نەزىرىڭدە ئىلتىپات تاپقان بولسام، ئۆتۈنۈپ قالاي، يېنىمدىن كەتمە. چۈنكى مەن پەرۋەردىگارنىڭ سېنىڭ سەۋەبىڭدىن ماڭا بەرىكەت بەرگىنىنى تونۇپ يەتتىم، دېۋىدى، ياقۇپ يەنە: ــ ");
INSERT INTO uigara_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ماڭا ئالىدىغان ھەققىڭنى توختاتقىن؛ مەن ساڭا شۇنى بېرەي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ياقۇپ ئۇنىڭغا جاۋاب بېرىپ: ــ مەن ساڭا قانداق خىزمەت قىلىپ كەلگىنىم، مېنىڭ قولۇمدا ماللىرىڭنىڭ قانداق بولغىنى ئۆزۈڭگە ئايان. ");
INSERT INTO uigara_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","چۈنكى مەن كەلمەستە مېلىڭ ئاز ئىدى؛ ئەمدى ناھايىتى زور بىر توپ بولدى. مېنىڭ قەدىمىم قەيەرگە يەتسە، پەرۋەردىگار ساڭا بەرىكەت ئاتا قىلدى. ئەمدى مەن قاچان ئۆز ئائىلەم ئۈچۈن ئىگىلىك تىكلەيمەن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","شۇنىڭ بىلەن لابان: ــ مەن ساڭا نېمە بېرەي، دېۋىدى، ياقۇپ: ــ سەن ماڭا ھېچنېمە بەرمىگىن؛ پەقەت مېنىڭ شۇ ئىشىمغا قوشۇلساڭلا، مەن يەنە پاداڭنى بېقىپ، ئۇلاردىن خەۋەر ئالىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","مەن بۈگۈن پۈتكۈل پاداڭنى ئارىلاپ، ئالا-چىپار قويلارنى، قارا-قوڭۇر پاخلانلارنى، شۇنداقلا ئۆچكىلەرنىڭ ئىچىدىنمۇ ئالا-چىپارلىرىنى ئايرىپ چىقىمەن. بۇلار مېنىڭ ئىش ھەققىم بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","كېيىن، مېنىڭ ھەققىمنى تەكشۈرۈپ كەلگەن ۋاقتىڭدا، ھەققانىي بولغىنىم كۆز ئالدىڭدا ئىسپاتلىنىدۇ؛ ئۆچكىلەر ئارىسىدا ئالا-چىپار بولمىغانلىرىنىڭ ھەممىسى، پاخلانلار ئارىسىدا قارا-قوڭۇر بولمىغانلىرىنىڭ ھەممىسى ئوغرىلاپ كېلىنگەن ھېسابلانسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ئۇ ۋاقىتتا لابان: ــ ماقۇل، دېگىنىڭدەك بولسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","شۇ كۈنى لابان تاغىل ۋە ئالا-چىپار تېكىلەرنى، ئالا-چىپار چىشى ئۆچكىلەرنى، شۇنداقلا ئاز-پاز ئاق چىكىمى بولغان بارلىق ئۆچكىلەرنى، بارلىق قارا-قوڭۇر قوزىلارنى ئايرىپ، ئۆز ئوغۇللىرىنىڭ قولىغا تاپشۇرۇپ، ");
INSERT INTO uigara_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ئۆزى بىلەن ياقۇپنىڭ ئوتتۇرىسىدا ئۈچ كۈنلۈك ئارىلىقنى قويدى. ياقۇپ بولسا لاباننىڭ پادىلىرىنىڭ قالغىنىنى باقتى. ");
INSERT INTO uigara_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","لېكىن ياقۇپ تېرەك، بادام ۋە چىنار دەرەخلىرىدىن يۇمران چىۋىقلارنى ئېلىپ، قوۋزىقىنى يوللۇق قىلىپ شىلىپ، ئاق سىزىقلارنى چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("GN30_38‏","002_30_38‏","GEN","30","38‏","39","ئاندىن مال كۈيلىگەن ۋاقىتلىرىدا سۇ ئىچكىلى كەلگەندە، ئۇ مۇشۇ شىلغان چىۋىقلارنى پادىلار سۇ ئىچىدىغان يەرلەردىكى ئۇلاقلارغا مالنىڭ ئالدىغا تىكلەپ قوياتتى. مال بۇ تاغىل چىۋىقلارنىڭ ئالدىدا جۈپلەشكەندىن كېيىن ئۇلار تاغىل ۋە ئالا-چىپار قوزىلارنى تۇغدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ئاندىن ياقۇپ بۇ قوزىلارنى لاباننىڭ پادىسىدىن ئايرىپ چىقاردى؛ ئاندىن ئۇ لاباننىڭ پادىسىنىڭ يۈزلىرىنى تاغىل ۋە قوڭۇر قويلىرىغا قارىتىپ جۈپلەشتۈردى؛ شۇنداق قىلىپ، ئۇ ئۆز مېلىنى لاباننىڭ مېلىغا قوشماي بۆلەك قويۇپ، ئۆزى ئۈچۈن ئايرىم بادىلارنى قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ساغلام كۈچلۈك مال جۈپلەشكىنىدە، ياقۇپ چىۋىقلارنى پادىنىڭ كۆز ئالدىغا ئۇلاقلاردا قوياتتى؛ ماللار شۇ چىۋىقلارنىڭ يېنىدا جۈپلىشەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","لېكىن جۈپلىشىۋاتقان مال ئاجىز بولسا، ئۇ چىۋىقلارنى قويمايتتى. بۇ تەرىقىدە ئاجىزلىرى لابانغا، كۈچلۈكلىرى ياقۇپقا تەۋە بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","شۇنداق قىلىپ، بۇ كىشى ناھايىتى باي بولۇپ، ماللىرى، دېدەكلىرى، قۇللىرى، تۆگىلىرى ۋە ئېشەكلىرى خېلى كۆپ بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ئەمما ياقۇپ لاباننىڭ ئوغۇللىرىنىڭ: ــ ياقۇپ ئاتىمىزنىڭ پۈتۈن مال-مۈلكىنى ئېلىپ كەتتى؛ ئۇنىڭ ئېرىشكەن بۇ دۆلىتى ئاتىمىزنىڭ تەئەللۇقاتىدىن كەلگەن، دېگىنىنى ئاڭلاپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ياقۇپ لاباننىڭ چىرايىغا قارىۋىدى، مانا، ئۇ ئۆزىگە بۇرۇنقىدەك خۇش پېئىل بولمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","بۇ چاغدا، پەرۋەردىگار ياقۇپقا: ــ سەن ئاتا-بوۋىلىرىڭنىڭ زېمىنىغا، ئۆز ئۇرۇق-تۇغقانلىرىڭنىڭ قېشىغا قايتىپ كەتكىن. مەن سېنىڭ بىلەن بىللە بولىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","شۇنىڭ ئۈچۈن ياقۇپ ئادەم ئەۋەتىپ، راھىلە ۋە لېياھنى ئۆز پادىسى تۇرغان كۆكلەمگە چاقىرىپ كېلىپ ");
INSERT INTO uigara_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ئۇلارغا مۇنداق دېدى: ــ مەن ئاتاڭلارنىڭ چىرايىغا قارىسام ماڭا بۇرۇنقىدەك خۇش پېئىل بولمىدى؛ ئەمما ئاتامنىڭ خۇداسى مەن بىلەن بىللە بولۇپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","كۈچۈمنىڭ يېتىشىچە ئاتاڭلارغا ئىشلەپ بەرگىنىم سىلەرگە ئايان؛ ");
INSERT INTO uigara_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ھالبۇكى، ئاتاڭلار مېنى ئەخمەق قىلىپ، ھەققىمنى ئون قېتىم ئۆزگەرتتى؛ لېكىن خۇدا ئۇنىڭ ماڭا زىيان يەتكۈزۈشىگە يول قويمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ئەگەر ئۇ: «ئالا-چىپار قوزىلار ھەققىڭ بولىدۇ»، دېسە، بارلىق پادىلار ئالا-چىپار قوزىلىغىلى تۇردى. ئۇ: «تاغىل قوزىلار ھەققىڭ بولسۇن»، دېسە، بارلىق پادىلار تاغىل قوزىلىغىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","بۇ تەرىقىدە خۇدا ئاتاڭلارنىڭ ماللىرىنى تارتىۋېلىپ، ماڭا بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","پادىلار كۈيلىگەن ۋاقىتتا مەن بىر قېتىم چۈشۈمدە بېشىمنى كۆتۈرۈپ شۇنى كۆردۇمكى، مانا، ماللارنىڭ ئۈستىگە جۈپلىشىشكە ئېتىلغان قوچقار-تېكىلەرنىڭ ھەممىسى تاغىل ياكى ئالا-چىپار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ئاندىن خۇدانىڭ پەرىشتىسى چۈشۈمدە ماڭا: «ئەي ياقۇپ»، دېۋىدى، مەن جاۋاب بېرىپ: «مانا مەن»، دېدىم. ");
INSERT INTO uigara_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ئۇ ماڭا: ــ «ئەمدى بېشىڭنى كۆتۈرۈپ قارىغىن؛ مانا ماللارنىڭ ئۈستىگە جۈپلىشىشكە ئېتىلغان قوچقار-تېكىلەرنىڭ ھەممىسى تاغىل ۋە ئالا-چىپاردۇر؛ چۈنكى مەن لاباننىڭ ساڭا قىلغىنىنىڭ ھەممىسىنى كۆردۈم. ");
INSERT INTO uigara_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","مەن بەيت-ئەلدە ساڭا كۆرۈنگەن تەڭرىدۇرمەن. سەن شۇ يەردە تۈۋرۈكنى مەسىھلەپ، ماڭا قەسەم ئىچتىڭ. ئەمدى سەن ئورنۇڭدىن تۇرۇپ، بۇ زېمىندىن چىقىپ، ئۇرۇق-تۇغقانلىرىڭنىڭ زېمىنىغا يانغىن» دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","راھىلە ۋە لېياھ ئۇنىڭغا جاۋاب بېرىپ: ــ ئاتىمىزنىڭ ئۆيىدە بىزگە تېگىشلىك نېسىۋە ياكى مىراس قالمىغانمۇ؟ ");
INSERT INTO uigara_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","بىز دەرۋەقە ئۇنىڭغا يات ئادەم ھېسابلىنىپ قالغانمۇ؟! ئۇ بىزنى سېتىۋەتتى، تويلۇقىمىزنىمۇ پۈتۈنلەي يەپ كەتتى! ");
INSERT INTO uigara_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","شۇنداق بولغاندىن كېيىن، خۇدا ئاتىمىزدىن ساڭا ئېلىپ بەرگەن بارلىق دۆلەت بىز بىلەن بالىلىرىمىزنىڭكىدۇر. ئەمدى خۇدا ساڭا نېمە دېگەن بولسا، شۇنى قىلغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_17‏","002_31_17‏","GEN","31","17‏","18","شۇنىڭ بىلەن ياقۇپ ئورنىدىن تۇرۇپ، بالىلىرى ۋە ئاياللىرىنى تۆگىلەرگە مىندۇرۇپ، ئېرىشكەن بارلىق ماللىرى ۋە بارلىق تەئەللۇقاتىنى، يەنى پادان-ئارامدا تاپقان تەئەللۇقاتلىرىنى ئېلىپ، ئاتىسى ئىسھاقنىڭ يېنىغا بېرىشقا قانائان زېمىنىغا قاراپ يول ئالدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","لابان بولسا قويلىرىنى قىرقىغىلى كەتكەنىدى؛ راھىلە ئۆز ئاتىسىغا تەۋە «ئۆي بۇتلىرى»نى ئوغرىلاپ ئېلىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ياقۇپ ئارامىي لابانغا ئۆز قېشىدىن ئوغرىلىقچە قېچىپ كېتىدىغانلىقىنى ئۇقتۇرماي ئۇنى ئالداپ قويغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ئۇ بار-يوقىنى ئېلىپ قېچىپ كەتتى؛ ئۇ دەريادىن ئۆتۈپ گىلېئاد تېغى تەرەپكە قاراپ يول ئالدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ئۈچىنچى كۈنى، لابانغا ياقۇپنىڭ قاچقىنى توغرىسىدا خەۋەر يەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ئۇ ئۆز تۇغقانلىرىنى ئېلىپ، يەتتە كۈنلۈك يولغىچە كەينىدىن قوغلاپ بېرىپ، گىلېئاد تېغىدا ئۇنىڭغا يېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","لېكىن كېچىسى خۇدا ئارامىي لاباننىڭ چۈشىگە كىرىپ ئۇنىڭغا: «سەن ھېزى بول، ياقۇپقا يا ئاق يا كۆك دېمە!» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","لابان ياقۇپقا يېتىشىپ بارغاندا، ياقۇپ چېدىرىنى تاغنىڭ ئۈستىگە تىككەنىدى. لابانمۇ تۇغقانلىرى بىلەن گىلېئاد تېغىنىڭ ئۈستىدە چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","لابان ياقۇپقا: ــ بۇ نېمە قىلغىنىڭ؟ سەن مېنى ئالداپ، قىزلىرىمنى ئۇرۇشتا ئالغان ئولجىدەك ئېلىپ كەتتىڭ؟ ");
INSERT INTO uigara_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","نېمىشقا يوشۇرۇن قاچىسەن، ماڭا خەۋەر بەرمەي مەندىن ئوغرىلىقچە كەتتىڭ؟ ماڭا دېگەن بولساڭ مەن خۇشال-خۇراملىق بىلەن غەزەل ئوقۇپ، داپ ۋە چاڭ چېلىپ، سېنى ئۇزىتىپ قويمامتىم؟ ");
INSERT INTO uigara_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","شۇنداق قىلىپ سەن ماڭا ئۆز ئوغۇللىرىم ۋە قىزلىرىمنى سۆيۈپ ئۇزىتىپ قويۇش پۇرسىتىنىمۇ بەرمىدىڭ. بۇ ئىشتا ئەخمەقلىق قىلدىڭ. ");
INSERT INTO uigara_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","سىلەرگە زىيان-زەخمەت يەتكۈزۈش قولۇمدىن كېلەتتى؛ لېكىن تۈنۈگۈن كېچە ئاتاڭنىڭ خۇداسى ماڭا سۆز قىلىپ: «ھېزى بول، ياقۇپقا يا ئاق يا كۆك دېمە» دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","خوش، سەن ئاتاڭنىڭ ئۆيىنى تولىمۇ سېغىنغىنىڭ ئۈچۈن كەتمەي قويمايسەن؛ لېكىن نېمىشقا يەنە مېنىڭ بۇتلىرىمنى ئوغرىلىدىڭ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ياقۇپ لابانغا جاۋاب بېرىپ: ــ مەن قورقۇپ قاچتىم؛ چۈنكى سېنى قىزلىرىنى مەندىن مەجبۇرىي تارتىۋالامدىكىن، دېدىم. ");
INSERT INTO uigara_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ئەمدى بۇتلىرىڭغا كەلسەك، ئۇلار كىمدىن چىقسا شۇ تىرىك قالمايدۇ! قېرىنداشلىرىمىز ئالدىدا مەندىن قانداقلا نېمەڭنى تونۇۋالساڭ، ئۇنى ئېلىپ كەت، ــ دېدى. ھالبۇكى، ياقۇپنىڭ راھىلەنىڭ بۇتلارنى ئوغرىلاپ كەلگىنىدىن خەۋىرى يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","لابان ئالدى بىلەن ياقۇپنىڭ چېدىرىغا كىرىپ، ئاندىن لېياھنىڭ چېدىرى ھەم ئىككى دېدەكنىڭ چېدىرلىرىغا كىرىپ ئاختۇرۇپ ھېچنېمە تاپالمىدى. لېياھنىڭ چېدىرىدىن چىقىپ، راھىلەنىڭ چېدىرىغا كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","راھىلە بولسا ئۆي بۇتلىرىنى ئېلىپ، بۇلارنى تۆگىنىڭ چومىنىڭ ئىچىگە تىقىپ قويۇپ، ئۈستىدە ئولتۇرۇۋالغانىدى. لابان پۈتكۈل چېدىرىنى ئاختۇرۇپ، ھېچنېمە تاپالمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","راھىلە ئاتىسىغا: ــ ئەي خوجام، ئالدىڭدا تۇرالمىغىنىم ئۈچۈن خاپا بولمىغىن؛ چۈنكى مەن ھازىر ئاياللارنىڭ ئادەت مەزگىلىدە تۇرۇۋاتىمەن، ــ دېدى. شۇنداق قىلىپ، لابان ھەممە يەرنى قويماي ئاختۇرۇپمۇ، ئۆي بۇتلىرىنى تاپالمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","شۇنىڭ بىلەن ياقۇپ ئاچچىقلاپ لابان بىلەن جېدەللىشىپ كەتتى. ياقۇپ لابانغا: ــ سەن مېنى كەينىمدىن مۇنچە ئالدىراپ-تېنەپ قوغلاپ كەلگۈدەك مەندە نېمە سەۋەنلىك، نېمە گۇناھ بار؟ ");
INSERT INTO uigara_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","سەن ھەممە يۈك-تاقلىرىمنى ئاختۇرۇپ چىقتىڭ، ئۆيۈڭنىڭ نەرسىلىرىدىن بىرەر نېمە تاپالىدىڭمۇ؟ بىرنېمە تاپقان بولساڭ، مېنىڭ قېرىنداشلىرىم بىلەن سېنىڭ قېرىنداشلىرىڭنىڭ ئالدىدا ئۇنى قويغىن، ئۇلار بىز ئىككىمىزنىڭ ئارىسىدا ھۆكۈم قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","مەن مۇشۇ يىگىرمە يىل قېشىڭدا تۇردۇم؛ ھېچقاچان ساغلىقىڭ ۋە چىشى ئۆچكىلىرىڭ بالا تاشلىۋەتمىدى؛ پادىلىرىڭدىن قوچقارلىرىڭنى يېگىنىم يوق. ");
INSERT INTO uigara_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","بوغۇۋېتىلگەنلىرىنى قېشىڭغا ئېلىپ كەلمەي، بۇ زىياننى ئۆزۈم تولدۇردۇم؛ كېچىسى ئوغرىلانغان ياكى كۈندۈزى ئوغرىلانغان بولسۇن سەن ئۇنى مەندىن تۆلىتىپ ئالدىڭ. ");
INSERT INTO uigara_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","مېنىڭ كۈنلىرىم شۇنداق ئۆتتىكى، كۈندۈزى ئىسسىقتىن، كېچىسى سوغۇقتىن قىينىلىپ، ئۇيقۇ كۆزۈمدىن قاچاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","مېنىڭ كۈنلىرىم مۇشۇ يىگىرمە يىلدا ئۆيۈڭدە تۇرۇپ شۇنداق بولدى؛ ئون تۆت يىل ئىككى قىزىڭ ئۈچۈن ساڭا خىزمەت قىلدىم، ئالتە يىل پاداڭ ئۈچۈن خىزمەت قىلدىم؛ ئۇنىڭ ئۈستىگە سەن ئىش ھەققىمنى ئون قېتىم ئۆزگەرتتىڭ. ");
INSERT INTO uigara_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ئەگەر ئاتامنىڭ خۇداسى، يەنى ئىبراھىمنىڭ خۇداسى، يەنى ئىسھاقنىڭ قورقۇنچىسى بولغاننىڭ ئۆزى مەن بىلەن بىللە بولمىسا ئىدى، سەن جەزمەن مېنى قۇرۇق قول قىلىپ قايتۇرۇۋېتەتتىڭ. لېكىن خۇدا مېنىڭ تارتقان جەبىر-جاپالىرىمنى، قوللىرىمنىڭ مۇشەققىتىنى كۆرۈپ تۈنۈگۈن كېچە ساڭا تەنبىھ بەردى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","لابان ياقۇپقا جاۋاب بېرىپ: ــ بۇ قىزلار مېنىڭ قىزلىرىم، بۇ ئوغۇللار مېنىڭ ئوغۇللىرىم، بۇ پادا بولسا مېنىڭ پادام بولىدۇ؛ شۇنداقلا كۆز ئالدىڭدىكى ھەممە نەرسە مىنىڭكىدۇر؛ ئەمما مەن بۈگۈن بۇ قىزلىرىمنى ۋە ئۇلارنىڭ تۇغقان ئوغۇللىرىنى نېمە قىلاي؟ ");
INSERT INTO uigara_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","قېنى كەل، سەن بىلەن ئىككىمىز بىر ئەھدە تۈزۈشەيلى، بۇ مەن بىلەن سېنىڭ ئوتتۇرىمىزدا گۇۋاھ بولسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","شۇنىڭ بىلەن ياقۇپ بىر تاشنى ئېلىپ ئۆرە تىكلەپ تۈۋرۈك قىلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ئاندىن ياقۇپ قېرىنداشلىرىغا: ــ تاش يىغىڭلار، ــ دېۋىدى، تاشلارنى ئېلىپ كېلىپ دۆۋىلىدى، شۇ يەردە تاش دۆۋىسىنىڭ يېنىدا غىزالىنىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","لابان بۇ دۆۋىنى «يەگار-ساھادۇتا» دەپ ئاتىدى، ياقۇپ ئۇنىڭغا «گالېئەد» دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","لابان: ــ بۇ دۆۋە بۈگۈن سەن بىلەن مېنىڭ ئوتتۇرامدا گۇۋاھ بولسۇن، ــ دېدى. شۇڭا بۇ سەۋەبتىن دۆۋىنىڭ نامى «گالېئەد» ئاتالدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ئۇ جاي يەنە «مىزپاھ»، دەپمۇ ئاتالدى؛ چۈنكى لابان يەنە: ــ ئىككىمىز بىر-بىرىمىز بىلەن كۆرۈشمىگەن ۋاقىتلاردا، پەرۋەردىگار سەن بىلەن مېنىڭ ئوتتۇرامدا قاراۋۇل بولۇپ كۆزىتىپ تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ئەگەر سەن قىزلىرىمنى بوزەك قىلساڭ، ياكى قىزلىرىمنىڭ ئۈستىگە باشقا خوتۇنلارنى ئالساڭ، باشقا ھېچ كىشى قېشىمىزدا ھازىر بولمىغان تەقدىردىمۇ، مانا، خۇدا مەن بىلەن سېنىڭ ئاراڭدا گۇۋاھچىدۇر! ");
INSERT INTO uigara_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","لابان ياقۇپقا يەنە: ــ مانا، بۇ دۆۋىگە قارا، مەن بىلەن سەن ئىككىمىزنىڭ ئوتتۇرىسىدا مەن تىكلەپ قويغان بۇ تۈۋرۈككىمۇ قارا؛ ");
INSERT INTO uigara_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","كەلگۈسىدە بۇ دۆۋە ۋە بۇ تۈۋرۈكمۇ مەن يامان نىيەت بىلەن بۇ دۆۋىدىن سېنىڭ تەرىپىڭگە ئۆتمەسلىكىم ئۈچۈن، سېنىڭمۇ نىيىتىڭنى يامان قىلىپ بۇ دۆۋە ۋە بۇ تۈۋرۈكتىن ئۆتۈپ مېنىڭ تەرىپىمگە كەلمەسلىكىڭ ئۈچۈن گۇۋاھچى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ئىبراھىمنىڭ ئىلاھى، ناھورنىڭ ئىلاھى ۋە بۇ ئىككىسىنىڭ ئاتىسىنىڭ ئىلاھلىرى ئارىمىزدا ھۆكۈم چىقارسۇن، ــ دېدى. ياقۇپ بولسا ئاتىسى ئىسھاقنىڭ قورقۇنچىسى بولغۇچى بىلەن قەسەم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ئاندىن ياقۇپ تاغ ئۈستىدە بىر قۇربانلىق سۇنۇپ، قېرىنداشلىرىنى ئۆزى بىلەن تاماقلىنىشقا تەكلىپ قىلدى. ئۇلار ھەمداستىخان ئولتۇردى ۋە كېچىسى تاغدا قوندى. ");
INSERT INTO uigara_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ئەتىسى تاڭ سەھەردە لابان ئورنىدىن تۇرۇپ، نەۋرىلىرى بىلەن قىزلىرىنى سۆيۈپ، ئۇلارغا بەخت-بەرىكەت تىلەپ، ئۆز ئۆيىگە راۋان بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ياقۇپ ئۆز يولىغا كېتىپ باراتتى؛ يولدا خۇدانىڭ پەرىشتىلىرى ئۇنىڭغا ئۇچرىدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ياقۇپ ئۇلارنى كۆرۈپ: ــ بۇ جاي خۇدانىڭ بارگاھى ئىكەن! ــ دەپ، بۇ جاينىڭ نامىنى «ماھانائىم» دەپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ئاندىن ياقۇپ سېئىر زېمىنىدىكى «ئېدوم يايلىقى»غا، ئاكىسى ئەساۋنىڭ قېشىغا ئالدىن خەۋەرچىلەرنى ئەۋەتىپ، ");
INSERT INTO uigara_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ئۇلارغا جېكىلەپ: ــ سىلەر خوجامغا، يەنى ئەساۋغا: «كەمىنىلىرى ياقۇپ مۇنداق دېدى: ــ مەن لاباننىڭ قېشىدا مۇساپىر بولۇپ، تا مۇشۇ ۋاقىتقىچە تۇردۇم. ");
INSERT INTO uigara_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ئەمدى مەندە كالا، ئېشەك ۋە قويلار، قۇل-دېدەكلەرمۇ بار؛ مەن ئۆزلىرىنىڭ نەزىرىدە ئىلتىپات تاپارمەنمىكىن دەپ خوجامغا خەۋەر يەتكۈزۈشنى لايىق كۆردۈم»، دەڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","خەۋەرچىلەر ياقۇپنىڭ يېنىغا يېنىپ كېلىپ: ــ بىز ئاكىلىرى ئەساۋنىڭ قېشىغا باردۇق؛ ئۇ تۆت يۈز كىشىنى ئېلىپ، سىلىنىڭ ئالدىلىرىغا كېلىۋاتىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ياقۇپ ناھايىتى قورقۇپ، غەم-غۇسسىگە چۈشۈپ ئادەملىرىنى قوي، كالا ۋە تۆگىلىرىگە قوشۇپ، ئىككى توپقا ئايرىدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ئۇ: ــ «ئەگەر ئەساۋ كېلىپ بىر توپىمىزغا ھۇجۇم قىلسا، يەنە بىر توپى قېچىپ قۇتۇلۇپ قالار» ــ دەپ ئويلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ئاندىن ياقۇپ مۇنداق دۇئا قىلدى: ــ ئى ئاتام ئىبراھىمنىڭ خۇداسى ۋە ئاتام ئىسھاقنىڭ خۇداسى! ماڭا: «ئۆز زېمىنىڭ ۋە ئۇرۇق-تۇغقانلىرىڭنىڭ قېشىغا يېنىپ كەتكىن، ساڭا ياخشىلىق قىلىمەن» دەپ ۋەدە قىلغان پەرۋەردىگار! ");
INSERT INTO uigara_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ــ مەن سېنىڭ ئۆز قۇلۇڭغا كۆرسەتكەن ئۆزگەرمەس بارلىق مېھرىبانلىقىڭ ۋە بارلىق ۋاپادارلىقىڭ ئالدىدا ھېچنېمە ئەمەسمەن؛ چۈنكى مەن بۇ ئىئوردان دەرياسىدىن ئۆتكىنىمدە يالغۇز بىر ھاسام بار ئىدى. ئەمدى مەن ئىككى توپ ئادەم بولۇپ قايتىۋاتىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ئۆتۈنۈپ قالاي، مېنى ئاكام ئەساۋنىڭ قولىدىن قۇتقۇزغايسەن؛ چۈنكى ئۇ كېلىپ مەن بىلەن خوتۇن-بالىلىرىمنى ئۆلتۈرۈۋېتەمدىكىن، دەپ قورقىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","سەن: «مەن جەزمەن ساڭا زور ياخشىلىق قىلىپ، سېنىڭ نەسلىڭنى دېڭىزدىكى قۇمدەك ھەددى-ھېسابسىز كۆپ قىلىمەن»، دېگەنىدىڭ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_13‏","002_32_13‏","GEN","32","13‏","15","ئۇ شۇ كېچىسى شۇ يەردە قونۇپ قالدى؛ ئاندىن ئۇ قول ئىلىكىدىكى ماللاردىن ئېلىپ، ئاكىسى ئەساۋغا ئىككى يۈز ئۆچكە، يىگىرمە تېكە، ئىككى يۈز ساغلىق، يىگىرمە قوچقار، ئوتتۇز چىشى تۆگىنى تايلاقلىرى بىلەن، قىرىق ئىنەك، ئون بۇقا، يىگىرمە مادا ئېشەك، ئون ھاڭگا ئېشەكنى سوۋغات قىلىپ تەييارلاپ، ");
INSERT INTO uigara_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","بۇلارنى ئايرىم-ئايرىم توپ قىلىپ خىزمەتكارلىرىنىڭ قولىغا تاپشۇرۇپ، ئۇلارغا جېكىلەپ: ــ سىلەر مەندىن بۇرۇن مېڭىپ، ھەر توپنىڭ ئارىسىدا ئارىلىق قويۇپ ھەيدەپ مېڭىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ئۇ ئەڭ ئالدىدىكى توپ بىلەن ماڭغان كىشىكە ئەمر قىلىپ: ــ ئاكام ئەساۋ ساڭا ئۇچرىغاندا، ئەگەر ئۇ سەندىن: «كىمنىڭ ئادىمىسەن؟ قەيەرگە بارىسەن؟ ئالدىڭدىكى جانىۋارلار كىمنىڭ؟» ــ دەپ سورىسا، ");
INSERT INTO uigara_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ئۇنداقتا سەن جاۋاب بېرىپ: «بۇلار كەمىنىلىرى ياقۇپنىڭ بولۇپ، خوجام ئەساۋغا ئەۋەتكەن سوۋغاتتۇر. مانا، ئۇ ئۆزىمۇ كەينىمىزدىن كېلىۋاتىدۇ» ــ دېگىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_19‏","002_32_19‏","GEN","32","19‏","20","شۇ تەرىقىدە ئۇ ئىككىنچى، ئۈچىنچى ۋە ئۇلاردىن كېيىنكى پادىلارنى ھەيدەپ ماڭغۇچى كىشىلەرگىمۇ ئوخشاش ئەمر قىلىپ: ــ ئەساۋ سىزلەرگە ئۇچرىغاندا، سىلەرمۇ ئۇنىڭغا شۇنداق دەڭلار، ئاندىن: ــ مانا، كەمىنىلىرى ياقۇپ ئۆزىمۇ ئارقىمىزدىن كېلىۋاتىدۇ، ــ دەڭلار، دېدى؛ چۈنكى ئۇ: ــ مەن ئالدىمدا بارغان سوۋغات بىلەن ئۇنى مېنى كەچۈرۈم قىلدۇرۇپ، ئاندىن يۈزىنى كۆرسەم، مېنى قوبۇل قىلارمىكىن، ــ دەپ ئويلىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","شۇنداق قىلىپ سوۋغات ئالدىن ئەۋەتىلدى؛ ئۇ شۇ كېچىسى بارگاھتا قونۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ئۇ شۇ كېچىدە قوپۇپ، ئىككى ئايالى ۋە ئىككى دېدىكى ۋە ئون بىر ئوغلىنى ئېلىپ، ياببوك كېچىكىدىن ئۆتۈپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ئۇ ئۇلارنى ئېقىندىن ئۆتكۈزدى، شۇنداقلا ھەممە تەئەللۇقىنىمۇ ئۇ قارشى تەرەپكە ئۆتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ياقۇپ بولسا بۇ قاتتا يالغۇز قالدى؛ بىر زات كېلىپ شۇ يەردە ئۇنىڭ بىلەن تاڭ ئاتقۇچە چېلىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","لېكىن بۇ زات ئۇنى يېڭەلمەيدىغانلىقىنى كۆرۈپ، ئۇنىڭ يوتىسىنىڭ يىرىقىغا قولىنى تەگكۈزۈپ قويدى؛ شۇنىڭ بىلەن ئۇلار چېلىشىۋاتقاندا ياقۇپنىڭ يوتىسى قازاندىن چىقىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ئۇ زات: ــ مېنى قويۇپ بەرگىن، چۈنكى تاڭ ئاتاي دەپ قالدى، دېدى. ــ سەن مېنى بەرىكەتلىمىگۈچە، سېنى قويۇپ بەرمەيمەن، دېدى ياقۇپ. ");
INSERT INTO uigara_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ئۇ ئۇنىڭدىن: ــ ئېتىڭ نېمە؟ دەپ سورىدى. ئۇ: ئېتىم ياقۇپ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ئۇ ئۇنىڭغا: ــ سېنىڭ ئېتىڭ بۇنىڭدىن كېيىن ياقۇپ بولماي، بەلكى ئىسرائىل بولىدۇ؛ چۈنكى سەن خۇدا بىلەنمۇ، ئىنسان بىلەنمۇ ئېلىشىپ غالىب كەلدىڭ، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ئاندىن ياقۇپ ئۇنىڭدىن: ــ نامىڭنى ماڭا دەپ بەرگىن، دېۋىدى، ئۇ: ــ نېمىشقا مېنىڭ نامىمنى سورايسەن؟ ــ دېدى ۋە شۇ يەردە ئۇنىڭغا بەخت-بەرىكەت ئاتا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","شۇنىڭ بىلەن ياقۇپ: ــ خۇدانى يۈزمۇ-يۈز كۆرۈپ، جېنىم قۇتۇلۇپ قالدى، دەپ ئۇ جاينىڭ نامىنى «پەنىئەل» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ئۇ پەنىئەلدىن ئۆتۈپ ماڭغاندا، كۈن ئۇنىڭ ئۈستىبېشىنى يورۇتتى؛ ئەمما ئۇ يوتىسى تۈپەيلىدىن ئاقساپ ماڭاتتى . ");
INSERT INTO uigara_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","بۇ سەۋەبتىن ئىسرائىللار بۈگۈنگىچە يوتىنىڭ ئۈگىسىدىكى پەينى يېمەيدۇ؛ چۈنكى شۇ زات ياقۇپنىڭ يوتىسىنىڭ يىرىقىغا، يەنى ئۇنىڭ پېيىگە قولىنى تەگكۈزۈپ قويغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ياقۇپ بېشىنى كۆتۈرۈپ قارىۋىدى، مانا ئەساۋ تۆت يۈز كىشى بىلەن كېلىۋاتاتتى. شۇنىڭ بىلەن ئۇ بالىلىرىنى ئايرىپ، لېياھ، راھىلە ۋە ئىككى دېدەككە تاپشۇردى؛ ");
INSERT INTO uigara_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ئۇ ئىككى دېدەك ۋە ئۇلارنىڭ بالىلىرىنى ھەممىنىڭ ئالدىدا ماڭدۇردى، ئاندىن لېياھ بىلەن ئۇنىڭ بالىلىرىنى، ئەڭ ئاخىرىدا راھىلە بىلەن يۈسۈپنى ماڭدۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ئۆزى بولسا ئۇلارنىڭ ئالدىغا ئۆتۈپ ماڭدى، ئۇ ئاكىسىنىڭ ئالدىغا يېتىپ بارغۇچە يەتتە قېتىم يەرگە باش ئۇرۇپ تەزىم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ئەساۋ ئۇنىڭ ئالدىغا يۈگۈرۈپ كېلىپ، ئۇنى قۇچاقلاپ، بوينىغا گىرە سېلىپ، ئۇنى سۆيدى؛ ھەر ئىككىسى يىغلىشىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ئاندىن ئەساۋ بېشىنى كۆتۈرۈپ قاراپ، ئاياللار ۋە بالىلارنى كۆرۈپ: ــ بۇ سەن بىلەن بىللە كەلگەنلەر كىملەر؟ ــ دەپ سورىدى. ياقۇپ: ــ بۇلار خۇدا شاپائەت قىلىپ كەمىنىلىرىگە بەرگەن بالىلاردۇر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ئاندىن ئىككى دېدەك ۋە ئۇلارنىڭ بالىلىرى ئالدىغا بېرىپ، ئۇنىڭغا تەزىم قىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ئاندىن لېياھمۇ ئۇنىڭ بالىلىرى بىلەن ئالدىغا بېرىپ، تەزىم قىلدى، ئاخىرىدا يۈسۈپ بىلەن راھىلە ئالدىغا بېرىپ، تەزىم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ئەساۋ: ــ ماڭا يولدا ئۇچرىغان ئاشۇ توپلىرىڭدا نېمە مەقسىتىڭ بار؟ ــ دېۋىدى، ياقۇپ جاۋاب بېرىپ: ــ بۇ خوجامنىڭ ئالدىدا ئىلتىپات تېپىشىم ئۈچۈندۇر، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","لېكىن ئەساۋ: ــ ئەي قېرىندىشىم، مەندە يېتىپ ئاشقۇدەك بار. سېنىڭ ئۆز نەرسىلىرىڭ ئۆزۈڭگە قالسۇن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ئەمما ياقۇپ: ــ ئۇنداق قىلمىغىن؛ ئەگەر مەن نەزەرلىرىدە ئىلتىپات تاپقان بولسام، سوۋغىتىمنى قولۇمدىن قوبۇل قىلغايلا؛ چۈنكى سىلىنىڭ مېنى خۇشاللىق بىلەن قوبۇل قىلغانلىرىنى كۆرۈپ، دىدارلىرىنى كۆرگىنىمدە خۇدانىڭ دىدارىنى كۆرگەندەك بولدۇم! ");
INSERT INTO uigara_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ئەمدى ساڭا كەلتۈرۈلگەن، خۇدادىن كۆرگەن بۇ بەرىكەتلىرىمنى قوبۇل قىلغايلا؛ چۈنكى خۇدا ماڭا شاپائەت كۆرسەتتى، ھەممە نەرسىلىرىم بار بولدى، ــ دەپ ئۇنىڭدىن قايتا-قايتا ئۆتۈنۈۋىدى، ئۇ قوبۇل قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ئاندىن ئەساۋ: ــ ئەمدى بىز قوزغىلىپ سەپىرىمىزنى داۋاملاشتۇرايلى، مەن سېنىڭ ئالدىڭدا ماڭاي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ئۇ ئۇنىڭغا جاۋابەن: ــ خوجام كۆردىلە، بالىلار كىچىك، قېشىمدا ئېمىدىغان قوزا ۋە موزايلار بار؛ ئەگەر مەن بۇلارنى بىر كۈنلا ئالدىرتىپ قوغلاپ ماڭدۇرسام، پۈتكۈل پادا ئۆلۈپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","شۇڭا ئۆتۈنىمەنكى، خوجام كەمىنىلىرىدىن ئالدىدا ماڭغاچ تۇرسۇن؛ مەن ئالدىمدىكى مال-چارۋىلارنىڭ مېڭىشىغا، شۇنداقلا بالىلارنىڭ مېڭىشىغا قاراپ ئاستا مېڭىپ، خوجامنىڭ قېشىغا سېئىرغا ئۇدۇل باراي، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ئۇ ۋاقىتتا ئەساۋ: ــ ئۇنداق بولسا، مەن ئۆزۈم بىلەن كەلگەن كىشىلەردىن بىرنەچچىنى قېشىڭدا قويۇپ كېتەي، دېدى. لېكىن ئۇ جاۋاب بېرىپ: ــ بۇنىڭ نېمە ھاجىتى؟ پەقەت خوجامنىڭ نەزىرىدە ئىلتىپات تاپساملا شۇ كۇپايە، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ئەساۋ ئۇ كۈنى يولغا چىقىپ سېئىرغا يېنىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ياقۇپ سەپەر قىلىپ، سۇككوت دېگەن جايغا كەلگەندە، ئۇ يەرگە بىر ئۆي سېلىپ، ماللىرىغا لاپاسلارنى ياسىدى. شۇڭا بۇ يەر «سۇككوت» دەپ ئاتالدى. ");
INSERT INTO uigara_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","شۇ تەرىقىدە ياقۇپ پادان-ئارامدىن قايتىپ، قانائان زېمىنىدىكى شەكەم شەھىرىگە ئامان-ئېسەن كەلدى. ئۇ شەھەرنىڭ ئالدىدا چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ئاندىن ئۇ چېدىر تىككەن يەرنىڭ بىر قىسىمىنى شەكەمنىڭ ئاتىسى بولغان ھامورنىڭ ئوغۇللىرىدىن بىر يۈز قەسىتىگە سېتىۋېلىپ، ");
INSERT INTO uigara_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","شۇ يەردە بىر قۇربانگاھ سېلىپ، نامىنى «ئەل-ئەلوھە-ئىسرائىل» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","بىر كۈنى، لېياھنىڭ ياقۇپقا تۇغۇپ بەرگەن قىزى دىناھ يۇرتنىڭ قىزلىرى بىلەن كۆرۈشكىلى چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","شۇ يۇرتنىڭ ئەمىرى ھىۋىي ھامورنىڭ ئوغلى شەكەم ئۇنى كۆرۈپ قېلىپ، ئۇنى تۇتۇۋېلىپ، زورلاپ نومۇسىغا تەگدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ئەمما ئۇنىڭ كۆڭلى ياقۇپنىڭ قىزى دىناھقا چۈشۈپ، ئۇنى ياخشى كۆرۈپ قالدى ۋە ئۇنىڭغا مۇھەببىتى بىلەن كۆڭۈل سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","شۇنىڭ بىلەن شەكەم ئاتىسى ھاموردىن: ــ بۇ قىزنى ماڭا خوتۇنلۇققا ئېلىپ بەرگىن، دەپ تەلەپ قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ياقۇپ شەكەمنىڭ قىزى دىناھنىڭ ئىپپىتىگە تەگكەنلىكىنى ئاڭلاپ قالدى. ئۇنىڭ ئوغۇللىرى ماللىرى بىلەن دالالاردا ئىدى؛ شۇڭا ياقۇپ ئۇلار كەلگۈچە جىم تۇرۇپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","شەكەمنىڭ ئاتىسى ھامور ياقۇپنىڭ ئالدىغا ئۇنىڭ بىلەن سۆزلەشكىلى چىقتى؛ ");
INSERT INTO uigara_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ياقۇپنىڭ ئوغۇللىرى خەۋەرنى ئاڭلاپلا دالالاردىن قايتىپ كەلگەنىدى. بۇلار شەكەمنىڭ قىلمايدىغان ئىشنى قىلىپ، ياقۇپنىڭ قىزىنىڭ نومۇسىغا تېگىپ ئىسرائىل قەبىلىسىدە شەرمەندىلىك قىلغىنى ئۈچۈن ئازابلىنىپ، ئىنتايىن قاتتىق غەزەپلەندى. ");
INSERT INTO uigara_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ھامور ئۇلارغا سۆز قىلىپ: ــ ئوغلۇم شەكەمنىڭ كۆڭلى قىزىڭلارغا چۈشۈپ قاپتۇ. ئىلتىپات قىلىپ ئۇنى ئوغلۇمغا خوتۇنلۇققا بەرسەڭلار! ");
INSERT INTO uigara_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","بىز بىلەن قۇدا-باجا بولۇپ، قىزلىرىڭلارنى بىزگە بېرىڭلار، بىزنىڭ قىزلىرىمىزنىمۇ سىلەر ئېلىڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","بىز بىلەن بىللە تۇرۇڭلار. مانا، يەر ئالدىڭلاردا تۇرۇپتۇ؛ بۇ يەرنى ماكان قىلىپ، سودا قىلىپ، ئۆزۈڭلار ئۈچۈن ئۆي-مۈلۈك ئېلىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","شەكەم قىزنىڭ ئاتىسى بىلەن ئاكا-ئۇكىلىرىغا: ــ نەزىرىڭلاردا ئىلتىپات تاپسام دەيمەن؛ سىلەر نېمە دېسەڭلار، شۇنى بېرەي. ");
INSERT INTO uigara_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","مەندىن قانچىلىك تويلۇق ياكى سوۋغات تەلەپ قىلساڭلار، ماڭا ئېيتقىنىڭلارچە بېرەي؛ پەقەت بۇ قىزنى ماڭا خوتۇنلۇققا بەرسەڭلارلا بولىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ياقۇپنىڭ ئوغۇللىرى بولسا شەكەم ۋە ئاتىسى ھامورغا ھىيلە-مىكىر بىلەن جاۋاب بەردى، چۈنكى ئۇ سىڭلىسى دىناھنىڭ ئىپپىتىگە تەگكەنىدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ئۇلارغا: ــ بىز بۇنداق قىلالمايمىز، سىڭلىمىزنى خەتنىسىز بىرسىگە بېرىشكە ماقۇل دېيەلمەيمىز؛ چۈنكى بۇ بىزگە نومۇس بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","پەقەت بىر شەرتىمىزگە كۆنسەڭلارلا سىلەرگە ماقۇل بولىمىز؛ سىلەرنىڭ بارلىق ئەركەكلىرىڭلار خەتنە قىلىنىپ بىزدەك بولسا، ");
INSERT INTO uigara_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","قىزلىرىمىزنى سىلەرگە بېرىپ، سىلەرنىڭ قىزلىرىڭلارنى بىز ئېلىپ ئاراڭلاردا ئولتۇرۇپ، بىر قوۋم بولۇپ قالىمىز. ");
INSERT INTO uigara_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ئەمما بىزگە قۇلاق سالماي خەتنە قىلىنىشقا ئۇنىمىساڭلار، ئۇنداقتا بىز قىزىمىزنى ئېلىپ كېتىمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ئۇلارنىڭ سۆزلىرى ھامور ۋە ئوغلى شەكەمنىڭ نەزىرىگە ياقتى. ");
INSERT INTO uigara_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","يىگىت بۇ ئىشنى كەينىگە سوزمىدى، چۈنكى ئۇ ياقۇپنىڭ قىزىغا ئېجىل بولۇپ قالغانىدى؛ ئۇ ئاتىسىنىڭ ئۆيىدە ھەممىدىن ئەتىۋارلىق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","شۇنىڭ بىلەن ھامور ئوغلى شەكەم بىلەن شەھەرنىڭ دەرۋازىسىغا بېرىپ، شەھەرنىڭ ئادەملىرىگە سۆز قىلىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","بۇ ئادەملەرنىڭ بىز بىلەن ئىناق ئۆتكۈسى بار. شۇڭا ئۇلار مۇشۇ يۇرتتا تۇرۇپ سودا-سېتىق قىلسۇن؛ مانا، بۇ جاينىڭ ئىككى تەرىپى ئۇلارغا يەتكۈدەك كەڭرىدۇر. بىز ئۇلارنىڭ قىزلىرىنى خوتۇنلۇققا ئېلىپ، ئۆز قىزلىرىمىزنى ئۇلارغا بېرىمىز. ");
INSERT INTO uigara_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","لېكىن پەقەت ئارىمىزدىكى ھەممە ئەركەك ئۇلار خەتنە قىلىنغاندەك خەتنە قىلىنسا، ئۇ ئادەملەر ئارىمىزدا تۇرۇپ بىز بىلەن بىر خەلق بولۇشقا ماقۇل دەيدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","شۇ تەرىقىدە ئۇلارنىڭ مال-تەئەللۇقاتى، ھەممە چارپايلىرى بىزنىڭكى بولمامدۇ؟ بىز پەقەت ئۇلارغا ماقۇل دېسەكلا، ئۇلار ئارىمىزدا تۇرىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","شۇنىڭ بىلەن شەھەرنىڭ دەرۋازىسىدىن كىرىپ-چىقىدىغانلارنىڭ ھەممىسى ھامور بىلەن ئوغلى شەكەمنىڭ سۆزىگە قۇلاق سالدى. شەھەرنىڭ دەرۋازىسىدىن كىرىپ-چىقادىغانلارنىڭ ھەممىسى خەتنە قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ئەمما ئۈچىنچى كۈنى، ئۇلار تېخىچە ئاغرىق ياتقىنىدا شۇنداق بولدىكى، ياقۇپنىڭ ئىككى ئوغلى، يەنى دىناھنىڭ ئاكىلىرى شىمېئون بىلەن لاۋىي ھەرقايسىسى ئۆز قىلىچىنى ئېلىپ، شەھەر خاتىرجەملىك ئىچىدە تۇرغىنىدا بېسىپ كىرىپ، ھەممە ئەركەكنى ئۆلتۈرۈۋەتتى؛    ");
INSERT INTO uigara_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ئۇلار ھامور بىلەن ئوغلى شەكەمنىمۇ قىلىچلاپ، دىناھنى شەكەمنىڭ ئۆيىدىن ئېلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ئاندىن ياقۇپنىڭ بارلىق ئوغۇللىرى: «ئۇلار سىڭلىمىزنىڭ نومۇسىغا تەگدى» دەپ، ئۆلتۈرۈلگەنلەرنىڭ جايىغا كېلىپ، شەھەرنى بۇلاپ-تالاڭ قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ئۇلارنىڭ قوي-كالا، ئېشەكلىرىنى، شەھەردىكى ھەممىنى، ئېتىزلىقلاردىكى ھەممىنى ئېلىپ كەتتى، ");
INSERT INTO uigara_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","شۇنداقلا ئۇلارنىڭ بارلىق مال-مۈلكىنى بۇلاپ-تالاپ، بارلىق خوتۇن-بالىلارنى ئەسىر قىلىپ، ئۆي ئىچىدىكى بارلىق نەرسىلەرنىمۇ قوشۇپ ئېلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ياقۇپ شىمېئون ۋە لاۋىينى ئەيىبلەپ: ــ سىلەر مېنى بالاغا تىقىپ، زېمىندىكىلەر ــ قانائانىيلار بىلەن پەرىززىيلەرنىڭ ئالدىدا سېسىتتىڭلار. بىزنىڭ ئادىمىمىز ئاز بىر خەلقتۇرمىز؛ ئۇلار ماڭا قارشى چىقىپ يىغىلىپ ھۇجۇم قىلىدۇ؛ شۇنىڭ بىلەن مەن ۋە جەمەتىم ۋەيران بولىمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ئەمما ئۇلار جاۋاب بېرىپ: ــ ئەجەبا، سىڭلىمىزغا بىر پاھىشە ئايالغا قىلغاندەك مۇئامىلە قىلسا بولامدۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ئاندىن خۇدا ياقۇپقا: ــ سەن ھازىر بەيت-ئەلگە چىقىپ، شۇ يەرنى ماكان قىل، ئۆزۈڭ ئاكاڭ ئەساۋدىن قېچىپ ماڭغىنىڭدا ساڭا كۆرۈنگەن مەن تەڭرىگە بىر قۇربانگاھ ياسىغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","شۇنىڭ بىلەن ياقۇپ ئۆيىدىكىلەر ۋە ئۆزى بىلەن بىللە بولغانلارنىڭ ھەممىسىگە مۇنداق دېدى: ــ ئاراڭلاردىكى يات ئىلاھ بۇتلىرىنى تاشلىۋېتىپ، ئۆزۈڭلارنى پاكلاپ ئېگىنلىرىڭلارنى يەڭگۈشلەڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ئاندىن قوپۇپ بەيت-ئەلگە چىقىمىز. مەن شۇ يەردە قىيىنچىلىقتا قالغاندا دۇئايىمنى ئىجابەت قىلىپ، يۈرگەن يولۇمدا مېنىڭ بىلەن بىللە بولۇپ كەلگەن تەڭرىگە قۇربانگاھ سالاي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","شۇنىڭ بىلەن ئۆز قوللىرىدىكى ھەممە يات ئىلاھ بۇتلىرىنى، شۇنداقلا قۇلاقلىرىدىكى زىرىلەرنى چىقىرىپ ياقۇپقا بەردى. ياقۇپ بۇلارنى شەكەمدىكى دۇب دەرىخىنىڭ تۈۋىگە كۆمۈپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ئاندىن ئۇلار سەپەرگە ئاتلاندى؛ ئەمما ئەتراپىدىكى شەھەرلەرنى خۇدادىن بولغان بىر ۋەھىمە باسقاچقا، ئۇلار ياقۇپنىڭ ئوغۇللىرىنى قوغلىمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","بۇ تەرىقىدە ياقۇپ ۋە ئۇنىڭ بىلەن بىللە بولغانلارنىڭ ھەممىسى قانائان زېمىنىدىكى لۇز، يەنى بەيت-ئەلگە يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ئۇ شۇ يەردە بىر قۇربانگاھ ياسىدى؛ ئاكىسىدىن قېچىپ ماڭغىنىدا شۇ يەردە خۇدا ئۇنىڭغا كۆرۈنگىنى ئۈچۈن بۇ جاينىڭ ئىسمىنى «ئەل-بەيت-ئەل» دەپ ئاتىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","رىۋكاھنىڭ ئىنىكئانىسى دەبوراھ بولسا شۇ يەردە ئالەمدىن ئۆتتى. ئۇ بەيت-ئەلنىڭ ئايىغىدىكى دۇب دەرىخىنىڭ تۈۋىدە دەپنە قىلىندى. بۇ سەۋەبتىن شۇ دەرەخ «يىغا-زارنىڭ دۇب دەرىخى» دەپ ئاتالدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ياقۇپ شۇ يول بىلەن پادان-ئارامدىن يېنىپ كەلگەندىن كېيىن، خۇدا ئۇنىڭغا يەنە بىر قېتىم كۆرۈنۈپ، ئۇنىڭغا بەخت-بەرىكەت ئاتا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ئاندىن خۇدا ئۇنىڭغا: ــ سېنىڭ ئىسمىڭ ياقۇپتۇر؛ ئەمما مۇندىن كېيىن سەن ياقۇپ ئاتالماي، بەلكى نامىڭ ئىسرائىل بولىدۇ، دەپ ئۇنىڭ ئىسمىنى ئىسرائىل قويۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ئاندىن خۇدا يەنە ئۇنىڭغا: ــ مەن ئۆزۈم ھەممىگە قادىر تەڭرىدۇرمەن؛ سەن نەسىللىنىپ، كۆپەيگىن؛ بىر ئەل، شۇنداقلا بىر تۈركۈم ئەللەر سەندىن پەيدا بولىدۇ؛ پادىشاھلارمۇ سېنىڭ پۇشتۇڭدىن چىقىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","مەن ئىبراھىم ۋە ئىسھاققا بەرگەن زېمىننى ساڭا بېرىمەن، شۇنداقلا سەندىن كېيىنكى نەسلىڭگىمۇ شۇ زېمىننى بېرىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ئاندىن خۇدا ئۇنىڭ بىلەن سۆزلەشكەن جايدىن، ئۇنىڭ يېنىدىن يۇقىرىغا كۆتۈرۈلدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ياقۇپ خۇدا ئۆزى بىلەن سۆزلەشكەن جايدا بىر تاش تۈۋرۈكنى تىكلەپ، ئۈستىگە بىر شاراب ھەدىيەسىنى تۆكتى ۋە زەيتۇن مېيى قۇيۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ياقۇپ خۇدا ئۆزى بىلەن سۆزلەشكەن شۇ جاينىڭ نامىنى «بەيت-ئەل» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ئاندىن ئۇلار بەيت-ئەلدىن مېڭىپ، ئەفراتقا ئازغىنا يول قالغاندا، راھىلەنى تولغاق تۇتۇپ كېتىپ، قاتتىق تۇغۇت ئازابىدا قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ئەمما تولغىقى قاتتىق ئېغىرلاشقاندا، تۇغۇت ئانىسى ئۇنىڭغا: ــ قورقمىغىن، بۇ قېتىم يەنە بىر ئوغلۇڭ بولىدىغان بولدى ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","شۇنداق بولدىكى، راھىلە جېنى چىقىش ئالدىدا، ئاخىرقى نەپىسى بىلەن ئوغلىغا «بەن-ئونى» دەپ ئىسىم قويدى؛ ئەمما ئۇنىڭ ئاتىسى ئۇنى «بەن-يامىن» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","راھىلە ۋاپات بولدى ۋە بەيت-لەھەم دەپ ئاتىلىدىغان ئەفراتنىڭ يولىنىڭ بويىغا دەپنە قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ياقۇپ ئۇنىڭ قەبرىسىنىڭ ئۈستىگە بىر خاتىرە تېشى تىكلەپ قويدى. بۈگۈنگە قەدەر «راھىلەنىڭ قەبرە تېشى» شۇ يەردە تۇرماقتا. ");
INSERT INTO uigara_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ئاندىن ئىسرائىل سەپەرنى داۋاملاشتۇرۇپ مىگدال-ئېدىرنىڭ ئۇ تەرىپىدە ئۆز چېدىرىنى تىكتى. ");
INSERT INTO uigara_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ئىسرائىل ئۇ زېمىندا تۇرغان ۋاقتىدا، رۇبەن بېرىپ ئۆز ئاتىسىنىڭ كېنىزىكى بىلھاھ بىلەن بىر ئورۇندا ياتتى؛ ئىسرائىل بۇنى ئاڭلاپ قالدى. ياقۇپنىڭ ئون ئىككى ئوغلى بار ئىدى: ــ ");
INSERT INTO uigara_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","لېياھدىن تۇغۇلغان ئوغۇللىرى: ــ ياقۇپنىڭ تۇنجى ئوغلى رۇبەن ۋە شىمېئون، لاۋىي، يەھۇدا، ئىسساكار ھەم زەبۇلۇن ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","راھىلەدىن تۇغۇلغان ئوغۇللىرى: ــ يۈسۈپ ۋە بىنيامىن ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","راھىلەنىڭ دېدىكى بىلھاھدىن تۇغۇلغان ئوغۇللىرى: ــ دان ۋە نافتالى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","لېياھنىڭ دېدىكى زىلپاھدىن تۇغۇلغان ئوغۇللىرى: ــ گاد بىلەن ئاشىر ئىدى. بۇلار بولسا ياقۇپقا پادان-ئارامدا تۇغۇلغان ئوغۇللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ئەمدى ياقۇپ ئاتىسى ئىسھاقنىڭ قېشىغا، ئىبراھىم ۋە ئىسھاق مۇساپىر بولۇپ تۇرغان كىرىئات-ئاربا، يەنى ھېبروننىڭ يېنىدىكى مامرەگە كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ئىسھاقنىڭ كۆرگەن كۈنلىرى بىر يۈز سەكسەن يىل بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ئىسھاق تولىمۇ قېرىپ، كۈنلىرى توشۇپ، نەپەستىن توختاپ ۋاپات بولدى ۋە ئۆز قوۋمىنىڭ قېشىغا بېرىپ قوشۇلدى. ئۇنىڭ ئوغۇللىرى ئەساۋ بىلەن ياقۇپ ئۇنى دەپنە قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","تۆۋەندىكىلەر ئەساۋنىڭ ئەۋلادلىرىدۇر (ئەساۋ يەنە ئېدوم دەپمۇ ئاتىلىدۇ): ــ    ");
INSERT INTO uigara_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ئەساۋ ئاياللىرىنى قانائانىيلارنىڭ قىزلىرىدىن ئالدى، يەنى ھىتتىيلاردىن بولغان ئېلوننىڭ قىزى ئاداھ بىلەن ھىۋىيلاردىن بولغان زىبېئوننىڭ نەۋرىسى، ئاناھنىڭ قىزى ئوھولىباماھنى ئالدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ئۇنىڭدىن باشقا ئىسمائىلنىڭ قىزى، نېبايوتنىڭ سىڭلىسى باسىماتنىمۇ ئالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ئاداھ ئەساۋغا ئېلىفازنى تۇغۇپ بەردى؛ باسىمات بولسا رېئۇئەلنى تۇغدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ئوھولىباماھ يەئۇش، يائالام ۋە كوراھنى تۇغدى؛ بۇلار قانائان زېمىنىدا ئەساۋغا تۇغۇلغان ئوغۇللار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ئەساۋ ئاياللىرى، ئوغۇل-قىزلىرى، ئۆيىدىكى ھەممە كىشىلىرىنى ۋە چارپايلىرىنى، بارلىق ئۇلاغلىرىنى، شۇنداقلا قانائان زېمىنىدا تاپقان بارلىق تەئەللۇقاتلىرىنى ئېلىپ، ئىنىسى ياقۇپتىن ئايرىلىپ، باشقا بىر يۇرتقا كۆچۈپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","چۈنكى ھەر ئىككىسىنىڭ تەئەللۇقاتلىرى ئىنتايىن كۆپ بولغاچقا، بىر يەردە بىللە تۇرالمايتتى؛ مۇساپىر بولۇپ تۇرغان زېمىن ئۇلارنىڭ مال-چارۋىلىرىنىڭ كۆپلۈكىدىن ئۇلارنى باقالمايتتى. ");
INSERT INTO uigara_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","بۇنىڭ بىلەن ئەساۋ (ئەساۋ ئېدوم دەپمۇ ئاتىلىدۇ) سېئىر تېغىغا بېرىپ، ئولتۇراقلىشىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","تۆۋەندىكىلەر تاغلىق رايون سېئىردىكى ئېدومىيلارنىڭ ئاتا-بوۋىسى ئەساۋنىڭ ئەۋلادلىرىدۇر: ــ ");
INSERT INTO uigara_vpl VALUES ("GN36_10‏","002_36_10‏","GEN","36","10‏","13","ئەساۋنىڭ ئوغۇللىرى: ــ ئەساۋنىڭ ئايالى ئاداھنىڭ ئوغلى ئېلىفاز؛ ئەساۋنىڭ ئايالى باسىماتنىڭ ئوغلى رېئۇئەل. ئېلىفازنىڭ ئوغۇللىرى: ــ تېمان، ئومار، زەفو، گاتام ۋە كەناز ئىدى. ئەساۋنىڭ ئوغلى ئېلىفازنىڭ كىچىك خوتۇنى تىمنا ئىدى؛ ئۇ ئېلىفازغا ئامالەكنى تۇغۇپ بەردى. يۇقىرىلار بولسا ئەساۋنىڭ ئايالى ئاداھنىڭ ئەۋلادلىرى ئىدى. رېئۇئەلنىڭ ئوغۇللىرى: ــ ناھات، زەراھ، شامماھ ۋە مىززاھ ئىدى؛ بۇلار ئەساۋنىڭ ئايالى باسىماتنىڭ ئەۋلادلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ئەساۋنىڭ ئايالى، يەنى زىبېئوننىڭ چوڭ قىزى، ئاناھنىڭ قىزى بولغان ئوھولىباماھنىڭ ئوغۇللىرى: ئۇ ئەساۋغا يەئۇش، يائالام ۋە كوراھنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ئەساۋنىڭ ئەۋلادلىرىنىڭ ئىچىدىن تۆۋەندىكى ئەمىرلەر چىققان: ــ ئەساۋنىڭ تۇنجى ئوغلى ئېلىفازنىڭ ئوغۇللىرىدىن: ــ ئەمىر تېمان، ئەمىر ئومار، ئەمىر زەفو، ئەمىر كېناز، ");
INSERT INTO uigara_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ئەمىر كوراھ، ئەمىر گاتام ۋە ئەمىر ئامالەك چىققان. بۇلار ئېدوم زېمىنىدا ئېلىفازنىڭ نەسلىدىن چىققان ئەمىرلەر بولۇپ، ئاداھنىڭ ئەۋلادلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ئەساۋنىڭ ئوغلى رېئۇئەلنىڭ ئوغۇللىرىدىن ئەمىر ناھات، ئەمىر زەراھ، ئەمىر شامماھ ۋە ئەمىر مىززاھلار چىققان؛ بۇلار ئېدوم زېمىنىدا رېئۇئەلنىڭ نەسلىدىن چىققان ئەمىرلەردۇر؛ بۇلارنىڭ ھەممىسى ئەساۋنىڭ ئايالى باسىماتنىڭ ئەۋلادلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ئەساۋنىڭ ئايالى ئوھولىباماھنىڭ ئوغۇللىرىدىن ئەمىر يەئۇش، ئەمىر يائالام ۋە ئەمىر كوراھلار چىققان. بۇلار ئاناھنىڭ قىزى، ئەساۋنىڭ ئايالى ئوھولىباماھنىڭ نەسلىدىن چىققان ئەمىرلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","بۇلار ئەساۋنىڭ، يەنى ئېدومنىڭ ئەۋلادلىرى بولۇپ، ئېدومىيلارنىڭ ئەمىرلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_20‏","002_36_20‏","GEN","36","20‏","21","ھورىيلاردىن بولغان سېئىرنىڭ ئېدوم زېمىنىدا ئولتۇرغان ئەۋلادلىرى: ــ لوتان، شوبال، زىبېئون، ئاناھ، دىشون، ئېزەر ۋە دىشان ئىدى. بۇلار سېئىرنىڭ ئەۋلادلىرى بولۇپ، ئېدوم زېمىنىدا ھورىيلارنىڭ ئەمىرلىرى ئىدى.    ");
INSERT INTO uigara_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","لوتاننىڭ ئوغۇللىرى ھورى بىلەن ھېمام ئىدى؛ لوتاننىڭ سىڭلىسى تىمنا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","شوبالنىڭ ئوغۇللىرى: ئالۋان، ماناھات، ئېبال، شېفو ۋە ئونام ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","زىبېئوننىڭ ئوغۇللىرى: ــ ئاياھ ۋە ئاناھ ئىدى. بۇ ئاناھ چۆلدە ئاتىسى زىبېئوننىڭ ئېشەكلىرىنى بېقىۋېتىپ، ئارشاڭلارنى تېپىۋالغان ئاناھنىڭ دەل ئۆزى شۇ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ئاناھنىڭ پەرزەنتلىرى: ئوغلى دىشون؛ ئاناھنىڭ قىزى ئوھولىباماھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","دىشوننىڭ ئوغۇللىرى: ھەمدان، ئەشبان، ئىتران ۋە كېران ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ئېزەرنىڭ ئوغۇللىرى: بىلھان، زائاۋان ۋە ئاكان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","دىشاننىڭ ئوغۇللىرى: ئۇز ۋە ئاران ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_29‏","002_36_29‏","GEN","36","29‏","30","ھورىيلارنىڭ ئۆزلىرىنىڭ ئەمىرلىرى: ئەمىر لوتان، ئەمىر شوبال، ئەمىر زىبېئون، ئەمىر ئاناھ، ئەمىر دىشون، ئەمىر ئېزەر ۋە ئەمىر دىشان ئىدى. بۇلار بولسا ھورىيلارنىڭ سېئىر زېمىنىدا ئۆز ناملىرى بويىچە ئاتالغان قەبىلىلەرنىڭ ئەمىرلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ئىسرائىللارنىڭ ئۈستىگە ھېچ پادىشاھ تېخى سەلتەنەت قىلماستا ئېدوم زېمىنىدا سەلتەنەت قىلغان پادىشاھلار تۆۋەندىكىدەك: ــ ");
INSERT INTO uigara_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بېئورنىڭ ئوغلى بېلا ئېدومدا سەلتەنەت قىلدى؛ ئۇنىڭ شەھىرىنىڭ ئىسمى دىنھاباھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","بېلا ئۆلگەندىن كېيىن، بوزراھلىق زەراھنىڭ ئوغلى يوباب ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","يوباب ئۆلگەندىن كېيىن، تېمانىيلارنىڭ زېمىنىدىن كەلگەن ھۇشام ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ھۇشام ئۆلگەندىن كېيىن، بېدادنىڭ ئوغلى ھاداد ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ئۇ موئابنىڭ يايلاقلىرىدا مىدىيانىيلارغا ھۇجۇم قىلىپ يەڭگەنىدى. ئۇنىڭ شەھىرىنىڭ ئىسمى ئاۋىت ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ھاداد ئۆلگەندىن كېيىن، ماسرەكاھلىق ساملاھ ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ساملاھ ئۆلگەندىن كېيىن، «دەريانىڭ بويىدىكى رەھوبوت»تىن كەلگەن سائۇل ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","سائۇل ئۆلگەندىن كېيىن، ئاكبورنىڭ ئوغلى بائال-ھانان ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ئاكبورنىڭ ئوغلى بائال-ھانان ئۆلگەندىن كېيىن، ھادار ئۇنىڭ ئورنىدا سەلتەنەت قىلدى. ئۇنىڭ شەھىرىنىڭ ئىسمى پائۇ ئىدى. ئۇنىڭ ئايالىنىڭ ئىسمى مەھېتابەل بولۇپ، ئۇ مەي-زاھابنىڭ قىزى بولغان ماترەدنىڭ قىزى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN36_40‏","002_36_40‏","GEN","36","40‏","43","ئەساۋنىڭ نەسلىدىن بولغان ئەمىرلەر ئۇلارنىڭ ئات-ئىسىملىرى، جەمەتلىرى، نەسەبنامىلىرى ۋە تۇرغان جايلىرى بويىچە: ئەمىر تىمنا، ئەمىر ئالۋاھ، ئەمىر يەھەت، ئەمىر ئوھولىباماھ، ئەمىر ئېلاھ، ئەمىر پىنون، ئەمىر كېناز، ئەمىر تېمان ۋە ئەمىر مىبزار، ئەمىر ماگدىيەل ۋە ئەمىر ئىراملار ئىدى. بۇلار ئېدومىيلارنىڭ ئەمىرلىرى بولۇپ، ئۆزلىرى ئىگىلەپ ئولتۇراقلاشقان جايلار ئۆز ناملىرى بىلەن ئاتالغانىدى. مانا شۇ تەرىقىدە ئەساۋ ئېدومىيلارنىڭ ئاتا-بوۋىسى بولدى.    ");
INSERT INTO uigara_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ياقۇپ بولسا ئاتىسى مۇساپىر بولۇپ تۇرغان يەردە، يەنى قانائان زېمىنىدا ئولتۇراقلاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","تۆۋەندىكىلەر ياقۇپ ئەۋلادلىرىنىڭ ئىش-ئىزلىرىدۇر. يۈسۈپ يىگىت بولۇپ ئون يەتتە ياشقا كىرگەن چاغلىرىدا، ئاكىلىرى بىلەن بىللە قويلارنى باقاتتى؛ ئۇ ئاتىسىنىڭ كىچىك خوتۇنلىرى بىلھاھ ۋە زىلپاھنىڭ ئوغۇللىرى بىلەن بىللە ئىشلەيتتى. يۈسۈپ ئاتىسىغا ئۇلارنىڭ ناچار قىلىقلىرىنى ئېيتىپ قوياتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","يۈسۈپ ئىسرائىلنىڭ قېرىغان ۋاقتىدا تاپقان بالىسى بولغاچقا، ئۇنى باشقا ئوغۇللىرىدىن بەكرەك ياخشى كۆرەتتى. شۇڭا ئۇ يۈسۈپكە ئۇزۇن يەڭلىك تون تىكتۈرۈپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ئەمما ئاكىلىرى ئاتىسىنىڭ ئۇنى ئۆزلىرىدىن ياخشى كۆرىدىغىنىنى كۆرۈپ، ئۇنىڭغا ئۆچ بولۇپ قالغانىدى ۋە ئۇنىڭغا چىرايلىق گەپ قىلماتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ئۇنىڭ ئۈستىگە يۈسۈپ بىر چۈش كۆرگەن بولۇپ، ئۇنى ئاكىلىرىغا دەپ بېرىۋىدى، ئۇلار ئۇنىڭغا تېخىمۇ ئۆچ بولۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","يۈسۈپ ئۇلارغا مۇنداق دېدى: ــ مېنىڭ كۆرگەن شۇ چۈشۈمنى ئاڭلاپ بېقىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","مانا، بىز ھەممىمىز ئېتىزلاردا ئاشلىقلارنى باغلاۋاتقۇدەكمىز. قارىسام مېنىڭ ئۆنچەم ئۆرە تۇرۇپتىدەك؛ سىلەرنىڭ ئۆنچەڭلار بولسا مېنىڭ ئۆنچەمنىڭ چۆرىسىگە ئولىشىپ تەزىم قىلىپ تۇرغۇدەك! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ئاكىلىرى ئۇنىڭدىن: ــ ئەجەبا، سەن بىزگە پادىشاھ بولامسەن؟ ئۈستىمىزگە ھۆكۈمرانلىق قىلامسەن؟ ــ دەپ سورىدى. ئۇنىڭ كۆرگەن چۈشلىرى ۋە گېپىدىن ئاكىلىرى ئۇنى تېخىمۇ يامان كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","كېيىن ئۇ يەنە بىر چۈش كۆردى ۋە چۈشىنى ئاكىلىرىغا دەپ: ــ مانا، مەن يەنە بىر چۈش كۆردۈم. قارىسام، قۇياش بىلەن ئاي ۋە ئون بىر يۇلتۇز ماڭا تەزىم قىلىپ تۇرغۇدەك! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ئۇ بۇ چۈشنى ئاتىسى ۋە ئاكىلىرىغا دەپ بەردى. ئاتىسى ئۇنىڭغا تەنبىھ بېرىپ: ــ بۇ كۆرگىنىڭ زادى قانداق چۈش؟ ئەجەبا، مەن، ئاناڭ ۋە ئاكا-ئۇكىلىرىڭ ئالدىڭغا بېرىپ، ساڭا يەرگە باش ئۇرۇپ تەزىم قىلىمىزمۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","شۇنىڭ بىلەن ئاكىلىرى ئۇنىڭغا ھەسەت قىلغىلى تۇردى. ئەمما ئاتىسى شۇ گەپنى كۆڭلىگە پۈكۈپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ئەمدى يۈسۈپنىڭ قېرىنداشلىرى ئاتىسىنىڭ قويلىرىنى باققىلى شەكەمگە كەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ئىسرائىل يۈسۈپكە: ــ ئاكىلىرىڭ شەكەمدە پادا بېقىۋاتىدىغۇ؟ كەل، مەن سېنى ئۇلارنىڭ قېشىغا ئەۋەتەي، دېۋىدى، يۈسۈپ: ــ مانا مەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ئۇ ئۇنىڭغا: ــ ئەمدى بېرىپ ئاكىلىرىڭ ئامان-ئېسەنمۇ-ئەمەسمۇ، قويلار ئامان-ئېسەنمۇ-ئەمەسمۇ، ماڭا خەۋىرىنى ئېلىپ كەلگىن، دەپ ئۇنى ھېبرون جىلغىسىدىن يولغا سالدى؛ ئۇ شەكەمگە باردى. ");
INSERT INTO uigara_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","شۇ يەردە بىرسى ئۇنىڭ دالادا تېنەپ يۈرگىنىنى كۆرۈپ ئۇنىڭدىن: ــ نېمە ئىزدەۋاتىسەن، دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ئۇ: ــ مەن ئاكىلىرىمنى ئىزدەۋاتىمەن. ئۇلارنىڭ پادىلىرىنى قەيەردە بېقىۋاتقانلىقىنى ئېيتىپ بەرسىڭىز، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ئۇ ئادەم جاۋاب بېرىپ: ــ ئۇلار بۇ يەردىن كېتىپ قالدى، چۈنكى مەن ئۇلارنىڭ: «يۈرۈڭلار، دوتانغا بارايلى» دېگىنىنى ئاڭلىدىم، دېدى. شۇنىڭ بىلەن يۈسۈپ ئاكىلىرىنىڭ ئارقىسىدىن بېرىپ، ئۇلارنى دوتاندىن تاپتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ئۇلار ئۇنى يىراقتىن كۆرۈپ، ئۇ تېخى ئۇلارنىڭ قېشىغا كەلمەيلا، ئۇنى ئۆلتۈرۈۋېتىشنى مەسلىھەتلەشتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ئۇلار بىر-بىرىگە: ــ مانا ھېلىقى چۈش كۆرگۈچى كېلىۋاتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","كېلىڭلار، ئۇنى ئۆلتۈرۈپ مۇشۇ يەردىكى ئورەكلەردىن بىرىگە تاشلىۋېتەيلى، ئاندىن: ــ ۋەھشىي بىر ھايۋان ئۇنى يەپ كېتىپتۇ، دەيلى. شۇندا، بىز ئۇنىڭ چۈشلىرىنىڭ نېمە بولىدىغىنىنى كۆرىمىز! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ئەمما رۇبەن بۇنى ئاڭلاپ ئۇنى ئۇلارنىڭ قوللىرىدىن قۇتقۇزماقچى بولۇپ: ــ ئۇنى ئۆلتۈرمەيلى، دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","رۇبەن ئۇلارغا يەنە: ــ قان تۆكمەڭلار! بەلكى ئۇنى چۆلدىكى مۇشۇ ئورەككە تاشلىۋېتىڭلار؛ لېكىن ئۇنىڭغا قول تەگكۈزمەڭلەر، دېدى (ئەمەلىيەتتە، ئۇ ئۇنى ئۇلارنىڭ قولىدىن قۇتقۇزۇپ، ئاتىسىنىڭ قېشىغا قايتۇرۇۋەتمەكچى ئىدى). ");
INSERT INTO uigara_vpl VALUES ("GN37_23‏","002_37_23‏","GEN","37","23‏","24","يۈسۈپ ئاكىلىرىنىڭ قېشىغا يېتىپ كەلگەندە ئۇلار ئۇنى تۇتۇپ، ئۇنىڭ ئالاھىدە تونىنى، يەنى كىيىكلىك ئۇزۇن يەڭلىك تونىنى سالدۇرۇۋېلىپ، ئورەككە تاشلىۋەتتى. لېكىن ئورەك قۇرۇق بولۇپ، ئىچىدە سۇ يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ئاندىن ئۇلار تاماق يېگىلى ئولتۇردى. ئۇلار بېشىنى كۆتۈرۈپ قارىۋىدى، مانا ئىسمائىللارنىڭ بىر كارۋىنى گىلېئاد تەرەپتىن كېلىۋاتاتتى. تۆگىلىرىگە دورا-دەرمەك، تۇتىيا ۋە مۇرمەككىلەر ئارتىلغان بولۇپ، مىسىر تەرەپكە كېتىۋاتاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","يەھۇدا قېرىنداشلىرىغا: ــ بىزنىڭ بىر تۇغقان قېرىندىشىمىزنى ئۆلتۈرۈپ، قېنىنى يوشۇرغىنىمىزنىڭ نېمە پايدىسى بار؟ ");
INSERT INTO uigara_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","كېلىڭلار، ئۇنى ئىسمائىللارغا سېتىۋېتەيلى؛ قانداقلا بولمىسۇن ئۇ بىزنىڭ ئىنىمىز، بىر تۇغقان قېرىندىشىمىز؛ شۇڭا ئۇنىڭغا قول سالمايلى، دېۋىدى، قېرىنداشلىرى بۇنىڭغا قۇلاق سالدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","مىدىيانلىق سودىگەرلەر شۇ يەردىن ئۆتۈپ كېتىۋاتقاندا، ئۇلار يۈسۈپنى ئورەكتىن تارتىپ چىقىرىپ، ئۇلارغا يىگىرمە كۈمۈش تەڭگىگە سېتىۋەتتى. بۇلار بولسا يۈسۈپنى مىسىرغا ئېلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","رۇبەن ئورەكنىڭ يېنىغا قايتىپ كېلىپ، يۈسۈپنىڭ ئورەكتە يوقلۇقىنى كۆرۈپ، كىيىملىرىنى يىرتىپ، ");
INSERT INTO uigara_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ئىنىلىرىنىڭ قېشىغا بېرىپ: ــ بالا يوق تۇرىدۇ! ئەمدى مەن نەگە باراي؟! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ئەمما ئۇلار يۈسۈپنىڭ تونىنى ئېلىپ، بىر تېكىنى بوغۇزلاپ توننى ئۇنىڭ قېنىغا مىلەپ، ");
INSERT INTO uigara_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ئاندىن ئۇزۇن يەڭلىك توننى ئاتىسىنىڭ قېشىغا ئەۋەتىپ، ئۇنىڭغا: ــ بۇنى بىز تېپىۋالدۇق؛ بۇ ئوغلۇڭنىڭ تونىمۇ-ئەمەسمۇ، ئۆزۈڭ كۆرۈپ باققىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ئۇ ئۇنى تونۇپ: ــ بۇ دەرۋەقە مېنىڭ ئوغلۇمنىڭ تونى ئىكەن؛ بىر ۋەھشىي ھايۋان ئۇنى يەپ كەتكەن ئوخشايدۇ؛ شۈبھىسىزكى، يۈسۈپ تىتما-تىتما قىلىۋېتىلىپتۇ! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","شۇنىڭ بىلەن ياقۇپ كىيىملىرىنى يىرتىپ، بېلىگە بۆز باغلاپ، نۇرغۇن كۈنلەرگىچە ئوغلى ئۈچۈن ماتەم تۇتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ئۇنىڭ ھەممە ئوغۇل-قىزلىرى يېنىغا كېلىپ ئۇنىڭغا تەسەللى بەرسىمۇ، ئۇ تەسەللىنى قوبۇل قىلماي: «مەن تەھتىساراغا چۈشۈپ ئوغلۇمنىڭ قېشىغا بارغۇچە شۇنداق ماتەم تۇتىمەن!» دېدى. يۈسۈپنىڭ ئاتىسى شۇ پېتى ئۇنىڭغا ئاھ-زار كۆتۈرۈپ ماتەم تۇتتى. ");
INSERT INTO uigara_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ئەمدى مىدىيانىيلار يۈسۈپنى مىسىرغا ئېلىپ بېرىپ، پىرەۋننىڭ بىر غوجىدارى، پاسىبان بېشى پوتىفارغا ساتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ئۇ ۋاقىتلاردا شۇنداق بولدىكى، يەھۇدا ئاكا-ئۇكىلىرىنىڭ قېشىدىن كېتىپ، ھىراھ ئىسىملىك ئادۇللاملىق بىر كىشىنىڭكىگە چۈشتى. ");
INSERT INTO uigara_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","شۇ يەردە يەھۇدا شۇئا ئىسىملىك بىر قانائانىينىڭ قىزىنى كۆردى؛ ئۇ ئۇنى خوتۇنلۇققا ئېلىپ قېشىغا كىرىپ ياتتى.    ");
INSERT INTO uigara_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ئۇ ھامىلىدار بولۇپ بىر ئوغۇل تۇغدى؛ يەھۇدا ئۇنىڭغا «ئەر» دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ئۇ يەنە ھامىلىدار بولۇپ، بىر ئوغۇل تۇغدى ۋە ئۇنىڭغا ئونان دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ئاندىن يەنە ھامىلىدار بولۇپ بىر ئوغۇل تۇغدى ۋە ئۇنىڭغا شەلاھ دەپ ئات قويدى. ئۇ تۇغۇلغاندا يەھۇدا كېزىبدا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","يەھۇدا تۇنجى ئوغلى ئەرگە تامار ئىسىملىك بىر قىزنى ئېلىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","لېكىن يەھۇدانىڭ تۇنجى ئوغلى ئەر پەرۋەردىگارنىڭ نەزىرىدە رەزىل بولغاچقا، پەرۋەردىگار ئۇنى ئۆلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","بۇ چاغدا يەھۇدا ئونانغا: ــ ئاكاڭنىڭ ئايالىنىڭ قېشىغا كىرىپ، ئۇنى خوتۇنلۇققا ئېلىپ قېرىنداشلىق بۇرچىنى ئادا قىلىپ، ئاكاڭ ئۈچۈن نەسىل قالدۇرغىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ئەمما ئونان بۇ نەسىلنىڭ ئۆزىگە تەۋە بولمايدىغانلىقىنى بىلىپ، ئاكىسىغا نەسىل قالدۇرماسلىق ئۈچۈن ھەر قېتىم ئاكىسىنىڭ ئايالى بىلەن بىللە بولغاندا مەنىيسىنى يەرگە ئاقتۇرۇۋېتەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ئۇنىڭ بۇ قىلمىشى پەرۋەردىگارنىڭ نەزىرىدە رەزىل كۆرۈنگەچكە، ئۇنىمۇ ئۆلتۈرۈۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","يەھۇدا ئەمدى كېلىنى تامارغا: ــ ئوغلۇم شەلاھ چوڭ بولغۇچە ئاتاڭنىڭ ئۆيىدە تۇل ئولتۇرۇپ تۇرغىن، دېدى. چۈنكى ئۇ ئىچىدە: ــ بۇمۇ ئاكىلىرىغا ئوخشاش ئۆلۈپ كېتەرمىكىن، دەپ قورقتى. شۇنىڭ بىلەن تامار بېرىپ ئاتىسىنىڭ ئۆيىدە تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ئەمدى كۆپ كۈنلەر ئۆتۈپ، شۇئانىڭ قىزى، يەھۇداغا تەگكەن ئايال ئۆلدى. يەھۇدا تەسەللى تاپقاندىن كېيىن ئادۇللاملىق دوستى ھىراھ بىلەن بىللە ئۆزىنىڭ قوي قىرقىغۇچىلىرىنىڭ ئەھۋالىنى بىلىشكە تىمناھقا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","تامارغا: ــ قېينئاتاڭ قويلىرىنى قىرقىغىلى تىمناھقا يول ئالدى، دېگەن خەۋەر يەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","شۇنىڭ بىلەن تامار شەلاھ چوڭ بولغان بولسىمۇ، مەن ئۇنىڭغا خوتۇنلۇققا ئېلىپ بېرىلمىدىم، دەپ قاراپ، تۇللۇق كىيىمىنى سېلىۋېتىپ، چۈمبەل تارتىپ بەدىنىنى ئوراپ، تىمناھ يولىنىڭ ئۈستىدە ئەنائىمغا كىرىش ئېغىزىغا بېرىپ ئولتۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ئەمدى يەھۇدا ئۇنى يۈزى يېپىقلىق ھالدا كۆرگەندە: ــ بۇ بىر پاھىشە ئايال ئوخشايدۇ، دەپ ئويلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ئۇ يولدىن بۇرۇلۇپ ئۇنىڭ يېنىغا بېرىپ، ئۆز كېلىنى ئىكەنلىكىنى بىلمەي: ــ كەل، مەن سەن بىلەن بىللە بولاي، دېدى. ئۇ جاۋاب بېرىپ: ــ مەن بىلەن بىللە بولساڭ، ماڭا نېمە بېرىسەن؟ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ئۇ ئۇنىڭغا: ــ پادامنىڭ ئىچىدىن بىر ئوغلاقنى ساڭا ئەۋەتىپ بېرەي، دېدى. ئايال: ــ سەن ئۇنى ئەكېلىپ بەرگۈچە، ماڭا رەنىگە بىرەر نەرسە بېرەمسەن؟ دەپ سورىۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ئۇ: ــ ساڭا نېمىنى رەنىگە بېرەي؟ ــ دېدى. ئۇ: ــ ئۆز مۆھۈرۈڭ بىلەن ئۇنىڭ شوينىسىنى ۋە قولۇڭدىكى ھاساڭنى رەنىگە بەرگىن، دېۋىدى، ئۇ بۇلارنى بېرىپ، ئۇنىڭ بىلەن بىرگە بولدى. شۇنىڭ بىلەن ئۇ ئۇنىڭدىن ھامىلىدار بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ئاندىن تامار ئورنىدىن تۇرۇپ ماڭدى؛ ئۇ پەرەنجىنى سېلىۋېتىپ، تۇللۇق كىيىمىنى كىيىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","يەھۇدا: ــ ئۇ خوتۇننىڭ قولىدىكى رەنىنى ياندۇرۇپ كەلسۇن دەپ ئادۇللاملىق دوستىنىڭ قولى ئارقىلىق ئوغلاقنى ئەۋەتتى، ئەمما ئۇ ئۇنى تاپالمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ئۇ شۇ جايدىكى ئادەملەردىن: ــ ئەنائىمدىكى يولنىڭ بويىدا ئولتۇرغان بۇتپەرەس پاھىشە قېنى، دەپ سورىسا، ئۇلار: ــ بۇ يەردە ھېچبىر بۇتپەرەس پاھىشە بولغان ئەمەس، دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","بۇنىڭ بىلەن ئۇ يەھۇدانىڭ قېشىغا يېنىپ بېرىپ: ــ مەن ئۇنى تاپالمىدىم؛ ئۈنىڭ ئۈستىگە ئۇ جايدىكى ئادەملەرمۇ: «بۇ يەردە ھېچبىر بۇتپەرەس پاھىشە ئايال بولغان ئەمەس» دېيىشتى، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","يەھۇدا: ــ بوپتۇ، ئۇ نەرسىلەرنى ئۇ ئېلىپ كەتسە كەتسۇن؛ بولمىسا، باشقىلارنىڭ مەسخىرىسىگە قالىمىز. نېمىلا بولمىسۇن، مەن ئۇنىڭغا ئوغلاق ئەۋەتتىم، لېكىن سەن ئۇ خوتۇننى تاپالمىدىڭ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ئۈچ ئايچە ئۆتكەندىن كېيىن بىرسى يەھۇداغا: ــ سېنىڭ كېلىنىڭ تامار بۇزۇقچىلىق قىلدى، ئۇنىڭ ئۈستىگە زىنادىن ھامىلىدار بولۇپ قالدى، دېگەن خەۋەرنى يەتكۈزدى. يەھۇدا جاۋابەن: ــ ئۇنى ئېلىپ چىقىڭلار، كۆيدۈرۈۋېتىلسۇن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","لېكىن ئۇ ئېلىپ چىقىلغاندا قېيناتىسىغا خەۋەر ئەۋەتىپ: ــ بۇ نەرسىلەرنىڭ ئىگىسى بولغان ئادەمدىن ھامىلىدار بولدۇم! ئەمدى سەن كۆرۈپ باق، بۇ مۆھۈر، شوينىسى ۋە ھاسىنىڭ كىمنىڭ ئىكەنلىكىنى ئېتىراپ قىلغىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","يەھۇدا بۇ نەرسىلەرنى ئېتىراپ قىلىپ: ــ ئۇ ماڭا نىسبەتەن ھەقلىقتۇر؛ دەرۋەقە مەن ئۇنى ئوغلۇم شەلاھقا ئېلىپ بەرمىدىم، دېدى. بۇ ئىشتىن كېيىن يەھۇدا ئۇنىڭغا يەنە يېقىنچىلىق قىلمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ئۇنىڭ تۇغۇت ۋاقتى يېقىنلاشتى، مانا قورسىقىدا قوشكېزەك بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ئۇ تۇغقان ۋاقتىدا بالىلاردىن بىرسى قولىنى چىقىرىۋىدى، تۇغۇت ئانىسى دەرھال بىر قىزىل يىپنى ئېلىپ: «بۇ ئاۋۋال چىقتى» دەپ ئۇنىڭ قولىغا چىگىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","لېكىن ئۇ قولىنى يەنە ئىچىگە تىقىۋالدى، مانا ئۇنىڭ ئىنىسى چىقتى. شۇنىڭ بىلەن تۇغۇت ئانىسى: «سەن قانداق قىلىپ بۆسۈپ چىقتىڭ!» دېدى؛ شۇنىڭ بىلەن ئۇنىڭغا «پەرەز» دېگەن ئات قويۇلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ئاندىن قولىغا قىزىل يىپ چىگىلگەن ئاكىسى تۇغۇلدى. ئۇنىڭ ئىسمى زەراھ دەپ ئاتالدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","يۈسۈپ بولسا مىسىرغا ئېلىپ كېلىندى؛ ئۇنى پىرەۋننىڭ غوجىدارى، پاسىبان بېشى پوتىفار شۇ يەرگە ئېلىپ كەلگەن ئىسمائىللارنىڭ قولىدىن سېتىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","لېكىن پەرۋەردىگار يۈسۈپ بىلەن بىللە بولغاچقا، ئۇنىڭ ئىشلىرى ئوڭغا تارتتى؛ ئۇ مىسىرلىق خوجىسىنىڭ ئۆيىدە تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ئۇنىڭ خوجىسى پەرۋەردىگارنىڭ ئۇنىڭ بىلەن بىللە ئىكەنلىكىنى، شۇنداقلا ئۇ نېمە ئىش قىلسا، پەرۋەردىگارنىڭ ئۇنىڭ قولىدا روناق تاپقۇزغانلىقىنى بايقىدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","شۇنىڭ بىلەن يۈسۈپ ئۇنىڭ نەزىرىدە ئىلتىپات تېپىپ، ئۇنىڭ خاس خىزمەتچىسى بولدى. خوجىسى ئۇنى ئۆيىنى باشقۇرۇشقا قويدى ۋە بارلىق تەئەللۇقاتىنى ئۇنىڭ قولىغا تاپشۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ۋە شۇنداق بولدىكى، ئۇ ئۇنى ئۆيى ۋە بارلىق تەئەللۇقاتىنى باشقۇرۇشقا قويغاندىن تارتىپ، پەرۋەردىگار بۇ مىسىرلىقنىڭ ئۆيىنى يۈسۈپنىڭ سەۋەبىدىن بەرىكەتلىدى؛ پەرۋەردىگارنىڭ بەرىكىتى ئۇنىڭ پۈتۈن ئائىلىسى ۋە بارلىق تېرىقچىلىقىغا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","شۇنىڭ بىلەن پوتىفار بارلىق ئىشلىرىنى يۈسۈپنىڭ قولىغا تاپشۇرۇپ، ئۆز تامىقىنى يېيىشتىن باشقا ھېچقانداق ئىش بىلەن كارى بولمىدى. يۈسۈپ بولسا قامىتى كېلىشكەن، خۇشچىراي يىگىت ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","بىرنەچچە ۋاقىت ئۆتكەندىن كېيىن شۇنداق بولدىكى، ئۇنىڭ خوجىسىنىڭ ئايالىنىڭ يۈسۈپكە كۆزى چۈشۈپ قېلىپ: ــ مەن بىلەن ياتقىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ئەمما ئۇ ئۇنىماي خوجىسىنىڭ ئايالىغا مۇنداق دېدى: ــ مانا خوجام ئۆيدىكى ئىشلارنى، شۇنداقلا بارلىق تەئەللۇقاتىنى قولۇمغا تاپشۇردى، ماڭا تولىمۇ ئىشىنىپ ئىشلىرىم بىلەن كارى بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","بۇ ئۆيدە مەندىن چوڭ ئادەم يوق. سەندىن باشقا ئۇ ھېچبىر نەرسىنى مەندىن ئايىمىدى ــ چۈنكى سەن ئۇنىڭ ئايالىدۇرسەن! شۇنداق تۇرۇقلۇق مەن قانداقمۇ بۇنداق رەزىللىكنى قىلىپ خۇدا ئالدىدا گۇناھكار بولاي؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","گەرچە ھەر كۈنى يۈسۈپكە شۇنداق دېسىمۇ، شۇنداقلا ئۇ ئۇنىڭ بىلەن يېتىپ ئۇنىڭغا يېقىنچىلىق قىلىشنى ياكى ئۇنىڭ بىلەن بىرگە تۇرۇشنى رەت قىلغان بولسىمۇ، ");
INSERT INTO uigara_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","شۇنداق بىر ۋەقە بولدىكى، بىر كۈنى ئۇ ئۆز ئىشى بىلەن ئۆي ئىچىگە كىرگەنىدى، ئۆيدىكىلەردىن ھېچقايسىسى ئۆينىڭ ئىچىدە ئەمەس ئىدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","بۇ ئايال ئۇنىڭ تونىنى تۇتۇۋېلىپ: ــ مەن بىلەن ياتقىن! دېدى. ئۇ تونىنى ئۇنىڭ قولىغا تاشلاپ قويۇپ، يۈگۈرگەن پېتى قېچىپ تاشقىرىغا چىقىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ئايال يۈسۈپنىڭ تونىنى ئۆز قولىغا تاشلاپ قېچىپ چىقىپ كەتكىنىنى كۆرۈپ، ");
INSERT INTO uigara_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ئۆيىدىكى خىزمەتچىلىرىنى چاقىرىپ ئۇلارغا: ــ قاراڭلار، ئېرىم بىزگە ھاقارەت كەلتۈرسۇن دەپ بىر ئىبرانىي ئادەمنى ئېلىپ كەپتۇ! بۇ ئادەم يېنىمغا كىرىپ: «سەن بىلەن ياتاي» دېۋىدى، قاتتىق ۋارقىرىدىم! ");
INSERT INTO uigara_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ئۇ مېنىڭ قاتتىق ۋارقىرىغىنىمنى ئاڭلاپ، تونىنى يېنىمغا تاشلاپ، تاشقىرىغا قېچىپ كەتتى، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","شۇنىڭ بىلەن خوجىسى ئۆيىگە يېنىپ كەلگۈچە ئۇ يۈسۈپنىڭ تونىنى يېنىدا ساقلاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ئاندىن ئۇ ئېرىگىمۇ شۇ گەپنى قىلىپ: ــ سەن ئېلىپ كەلگەن ھېلىقى ئىبرانىي قۇل ماڭا ھاقارەت قىلىشقا قېشىمغا كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","لېكىن مەن قاتتىق ۋارقىراپ-جارقىردىم، ئۇ تونىنى قېشىمدا تاشلاپ، تاشقىرىغا قېچىپ كەتتى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ئۇنىڭ خوجىسى ئايالىنىڭ: ــ سېنىڭ قۇلۇڭ مېنى ئۇنداق-مۇنداق قىلدى، دېگەن گەپلىرىنى ئاڭلاپ غەزىپى ئوتتەك تۇتاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","شۇنىڭ بىلەن يۈسۈپنىڭ خوجىسى ئۇنى تۇتۇپ ئوردا مۇنارلىق زىندانغا قاماپ قويدى. شۇ يەرگە پەقەت پادىشاھنىڭ مەھبۇسلىرى سولىناتتى. بۇنىڭ بىلەن ئۇ شۇ يەردە سولاقتا يېتىپ قالدى.    ");
INSERT INTO uigara_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","لېكىن پەرۋەردىگار يۈسۈپ بىلەن بىللە بولۇپ، ئۇنىڭغا شاپائەت كۆرسىتىپ، ئۇنى زىندان بېگىنىڭ نەزىرىدە ئىلتىپات تاپتۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","شۇنىڭ بىلەن زىندان بېگى گۇندىخانىدا ياتقان ھەممە مەھبۇسلارنى يۈسۈپنىڭ قولىغا تاپشۇردى. شۇ يەردە قىلىنىدىغان ھەرقانداق ئىش ئۇنىڭ قولى بىلەن بولاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","زىندان بېگى يۈسۈپنىڭ قولىدىكى ھېچقانداق ئىشتىن غەم قىلماتتى؛ چۈنكى پەرۋەردىگار ئۇنىڭ بىلەن بىللە بولۇپ، ئۇ ھەرنېمە قىلسا پەرۋەردىگار ئۇنى ئوڭۇشلۇق قىلاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","بۇ ئىشلاردىن كېيىن مىسىر پادىشاھىنىڭ ساقىيسى ۋە باش ناۋىيى مىسىر پادىشاھىنىڭ زىتىغا تېگىپ گۇناھكار بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","شۇنىڭ بىلەن پىرەۋن ئۇنىڭ بۇ ئىككى مەنسەپدارىغا، يەنى باش ساقىي ۋە باش ناۋايغا غەزەپلىنىپ، ");
INSERT INTO uigara_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ئۇلارنى پاسىبان بېشىنىڭ سارىيىغا، يۈسۈپ سولاقلىق مۇنارلىق زىندانغا سولاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","پاسىبان بېشى يۈسۈپنى ئۇلارنىڭ خىزمىتىدە بولۇپ ئۇلارنى كۈتۈشكە تەيىنلىدى. ئۇلار سولاقتا بىرنەچچە كۈن يېتىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ئۇلار ئىككىسى ــ مىسىر پادىشاھىنىڭ ساقىيسى ۋە ناۋىيى گۇندىخانىدا سولاقلىق تۇرغان بىر كېچىدە چۈش كۆردى. ھەربىرىنىڭ چۈشىنىڭ ئۆزىگە خاس تەبىرى بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ئەتىسى ئەتىگەندە، يۈسۈپ ئۇلارنىڭ قېشىغا كىرىۋىدى، ئۇلارنىڭ غەمكىن ئولتۇرغىنىنى كۆردى؛ ");
INSERT INTO uigara_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","شۇڭا ئۇ ئۆزى بىلەن بىللە خوجىسىنىڭ سارىيىدا سولاقلىق ياتقان پىرەۋننىڭ بۇ ئىككى مەنسەپدارىدىن: ــ نېمىشقا چىرايىڭلار بۈگۈن شۇنچە سولغۇن؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ئۇلار ئۇنىڭغا جاۋاب بېرىپ: ــ ئىككىمىز بىر چۈش كۆردۇق؛ ئەمما چۈشىمىزنىڭ تەبىرىنى يېشىپ بېرىدىغان كىشى يوق، دېدى. يۈسۈپ ئۇلارغا: ــ چۈشكە تەبىر بېرىش خۇدادىن بولىدۇ ئەمەسمۇ؟ چۈشۈڭلارنى ماڭا ئېيتىپ بېرىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","بۇنىڭ بىلەن باش ساقىي يۈسۈپكە چۈشىنى ئېيتىپ: ــ چۈشۈمدە ئالدىمدا بىر ئۈزۈم تېلى تۇرغۇدەك؛ ");
INSERT INTO uigara_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","بۇ ئۈزۈم تېلىنىڭ ئۈچ شېخى بار ئىكەن. ئۇ بىخ ئۇرۇپ چېچەكلەپ، ساپلىرىدا ئۇزۇم پىشىپ كېتىپتۇدەك؛ ");
INSERT INTO uigara_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","پىرەۋننىڭ قەدەھى قولۇمدا ئىكەن؛ مەن ئۈزۈملەرنى ئېلىپ پىرەۋننىڭ قەدەھىگە سىقىپ، قەدەھنى ئۇنىڭ قولىغا سۇنۇپتىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","يۈسۈپ ئۇنىڭغا جاۋابەن: چۈشنىڭ تەبىرى شۇدۇركى، بۇ ئۈچ شاخ ئۈچ كۈننى كۆرسىتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ئۈچ كۈن ئىچىدە پىرەۋن قەددىڭنى رۇسلىتىپ، سېنى مەنسىپىڭگە قايتىدىن تەيىنلەيدۇ. بۇنىڭ بىلەن سەن بۇرۇن ئۇنىڭغا ساقىي بولغاندەك پىرەۋننىڭ قەدەھىنى ئۇنىڭ قولىغا سۇنىدىغان بولىسەن. ");
INSERT INTO uigara_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","لېكىن ئىشلىرىڭ ئوڭۇشلۇق بولغاندا مېنى يادىڭغا يەتكۈزۈپ، ماڭا شاپائەت كۆرسىتىپ پىرەۋننىڭ ئالدىدا مېنىڭ توغرامدا گەپ قىلىپ، مېنى بۇ ئۆيدىن چىقارتقايسەن. ");
INSERT INTO uigara_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","چۈنكى مەن ھەقىقەتەن ئىبرانىيلارنىڭ زېمىنىدىن ناھەق تۇتۇپ ئېلىپ كېلىندىم؛ بۇ يەردىمۇ مېنى زىندانغا سالغۇدەك بىر ئىش قىلمىدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","باش ناۋاي يۈسۈپنىڭ شۇنداق ياخشى تەبىر بەرگىنىنى كۆرۈپ ئۇنىڭغا مۇنداق دېدى: ــ مەنمۇ ئۆزۈمنى چۈشۈمدە كۆردۈم؛ مانا، بېشىمدا ئاق نان بار ئۈچ سېۋەت بار ئىكەن. ");
INSERT INTO uigara_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ئەڭ ئۈستۈنكى سېۋەتتە ناۋايلار پىرەۋنگە پىشۇرغان ھەرخىل نازۇنېمەتلەر بار ئىكەن؛ لېكىن قۇشلار بېشىمدىكى ئۇ سېۋەتتىكى نەرسىلەرنى يەپ كېتىپتۇدەك، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","يۈسۈپ جاۋابەن: ــ چۈشنىڭ تەبىرى شۇدۇركى: ــ بۇ ئۈچ سېۋەت ئۈچ كۈننى كۆرسىتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ئۈچ كۈن ئىچىدە پىرەۋن سېنىڭ بېشىڭنى كېسىپ، جەسىتىڭنى دەرەخكە ئاسىدىكەن. شۇنىڭ بىلەن ئۇچارقاناتلار كېلىپ گۆشۈڭنى يەيدىكەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ئۈچىنچى كۈنى شۇنداق بولدىكى، پىرەۋننىڭ تۇغۇلغان كۈنى بولغاچقا، ئۇ ھەممە خىزمەتكارلىرى ئۈچۈن بىر زىياپەت قىلىپ بەردى، شۇنداقلا دەرۋەقە خىزمەتكارلىرىنىڭ ئارىسىدا باش ساقىينىڭ بېشىنى كۆتۈردى ۋە باش ناۋاينىڭ بېشىنى ئالدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ئۇ باش ساقىينى قايتىدىن ئۆز مەنسىپىگە تەيىنلىدى؛ شۇنىڭ بىلەن ئۇ پىرەۋننىڭ قەدەھىنى ئۇنىڭ قولىغا قايتىدىن سۇنىدىغان بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","لېكىن باش ناۋاينى بولسا يۈسۈپ ئۇلارغا تەبىر بەرگەندەك ئېسىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ئەمما باش ساقىي يۈسۈپنى ھېچ ئەسلىمەي، ئەكسىچە ئۇنى ئۇنتۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","توپتوغرا ئىككى يىل ئۆتۈپ، پىرەۋن بىر چۈش كۆردى. چۈشىدە ئۇ نىل دەرياسىنىڭ بويىدا تۇرغۇدەك. ");
INSERT INTO uigara_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ھەم چىرايلىق ھەم سېمىز يەتتە تۇياق ئىنەك دەريادىن چىقىپ، قۇمۇشلۇقتا ئوتلاپتۇدەك. ");
INSERT INTO uigara_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ئاندىن يەنە يەتتە تۇياق ئىنەك دەريادىن چىقىپتۇ؛ ئۇلار سەت ھەم ئورۇق بولۇپ، ئالدىنقى ئىنەكلەرنىڭ يېنىدا، دەريانىڭ بويىدا تۇرۇپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","بۇ سەت ھەم ئورۇق ئىنەكلەر ئۇ يەتتە چىرايلىق ھەم سېمىز ئىنەكلەرنى يەۋېتىپتۇ. شۇ ۋاقىتتا پىرەۋن ئويغىنىپ كېتىپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ئۇ يەنە ئۇخلاپ، ئىككىنچى قېتىم چۈش كۆردى: ــ مانا، بىر تۈپ بۇغداي شېخىدىن توق ۋە چىرايلىق يەتتە باشاق چىقىپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ئۇلاردىن كېيىن يەنە يەتتە باشاق چىقىپتۇ؛ ئۇلار ھەم ئورۇق ۋە پۇچەك بولۇپ، شەرق شامىلىدا سولىشىپ قالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","بۇ ئورۇق باشاقلار ئۇ يەتتە سېمىز، توق باشاقنى يۇتۇپ كېتىپتۇ. ئاندىن پىرەۋن ئويغىنىپ كېتىپتۇ، بۇ ئۇنىڭ چۈشى ئىكەن. ");
INSERT INTO uigara_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ئەتىسى ئۇنىڭ كۆڭلى ناھايىتى بىئارام بولۇپ، مىسىردىكى ھەممە پالچى-جادۇگەرلەر بىلەن بارلىق دانىشمەنلەرنى چاقىرتىپ كەلدى. پىرەۋن ئۆز چۈشىنى ئۇلارغا ئېيتىپ بەردى؛ لېكىن ھېچكىم پىرەۋنگە چۈشلەرنىڭ تەبىرىنى دەپ بېرەلمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ئۇ چاغدا باش ساقىي پىرەۋنگە: ــ بۈگۈن مېنىڭ ئۆتكۈزگەن خاتالىقلىرىم ئېسىمگە كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","بۇرۇن پىرەۋن جانابلىرى قۇللىرىغا، يەنى پېقىر ۋە باش ناۋايغا ئاچچىقلىنىپ، بىزنى پاسىبان بېشىنىڭ سارىيىدا سولاققا تاشلىغانىدىلا؛ ");
INSERT INTO uigara_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","شۇ چاغلاردا ھەربىرىمىز بىر كېچىدە بىردىن چۈش كۆردۇق؛ ھەر قايسىمىز كۆرگەن چۈشنىڭ تەبىرى باشقا-باشقا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","شۇ يەردە بىز بىلەن بىللە پاسىبان بېشىنىڭ قۇلى بولغان بىر ئىبرانىي يىگىت بار ئىدى. ئۇنىڭغا چۈشلىرىمىزنى ئېيتىۋىدۇق، ئۇ بىزگە چۈشلىرىمىزنىڭ تەبىرىنى بايان قىلدى؛ ئۇ ھەربىرىمىزنىڭ كۆرگەن چۈشىگە قاراپ تەبىر بەرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","شۇنداق بولدىكى، ئىشلار دەل ئۇنىڭ بەرگەن تەبىرىدە دېيىلگەندەك يۈز بەردى؛ جانابلىرى پېقىرنى ئۆز مەنسىپىمگە قايتىدىن تەيىنلىدىلە، باش ناۋاينى دارغا ئاستىلا، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","شۇنىڭ بىلەن پىرەۋن ئادەم ئەۋەتىپ، يۈسۈپنى چاقىردى؛ ئۇلار دەرھال ئۇنى زىنداندىن چىقاردى. يۈسۈپ بۇرۇت-ساقىلىنى چۈشۈرۈپ، كىيىملىرىنى يەڭگۈشلەپ، پىرەۋننىڭ ئالدىغا كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","پىرەۋن يۈسۈپكە: ــ مەن بىر چۈش كۆردۈم، ئەمما ئۇنىڭ تەبىرىنى ئېيتىپ بېرەلەيدىغان ھېچكىم چىقمىدى. ئاڭلىسام، سەن چۈشكە تەبىر بېرەلەيدىكەنسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","يۈسۈپ پىرەۋنگە جاۋاب بېرىپ: ــ تەبىر بېرىش ئۆزۈمدىن ئەمەس؛ لېكىن خۇدا پىرەۋنگە خاتىرجەملىك بېرىدىغان بىر جاۋاب بېرىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","پىرەۋن يۈسۈپكە: ــ چۈشۈمدە مەن دەريانىڭ قىرغىقىدا تۇرۇپتىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","قارىسام، دەريادىن ھەم سېمىز ھەم چىرايلىق يەتتە تۇياق ئىنەك چىقىپ قۇمۇشلۇقتا ئوتلاپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ئاندىن ئۇلاردىن كېيىن ئاجىز، تولىمۇ سەت ھەم ئورۇق يەتتە تۇياق ئىنەك چىقىپتۇ. مەن مىسىر زېمىنىدا شۇنداق سەت ئىنەكلەرنى كۆرگەن ئەمەسمەن. ");
INSERT INTO uigara_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","بۇ ئورۇق، ئەسكى ئىنەكلەر بولسا ئاۋۋالقى يەتتە سېمىز ئىنەكنى يەۋېتىپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ئۇلارنى يەۋەتكەن بولسىمۇ، قورسىقىغا بىر نېمىنىڭ كىرگەنلىكى ھېچ ئايان بولماپتۇ، ئۇلارنىڭ كۆرۈنۈشى بەلكى بۇرۇنقىدەك سەت ئىمىش. ئاندىن مەن ئويغىنىپ كەتتىم. ");
INSERT INTO uigara_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ئاندىن يەنە بىر چۈش كۆردۇم، مانا بىر شاختىن يەتتە ھەم توق ھەم چىرايلىق باشاق چىقىپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ئاندىن يەنە يەتتە پۇچەك، ئورۇق باشاق چىقىپتۇ؛ ئۇلار شەرق شامىلى بىلەن سولىشىپ قۇرۇپ كېتىپتۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","بۇ ئورۇق باشاقلار يەتتە چىرايلىق باشاقنى يەپ كېتىپتۇ. مەن بۇ ئىشنى پالچى-جادۇگەرلەرگە دەپ بەرسەم، ماڭا تەبىرىنى ئېيتىپ بېرىدىغان ھېچ كىشى چىقمىدى، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","يۈسۈپ پىرەۋنگە: ــ جانابلىرى پىرەۋننىڭ چۈشلىرى بىر مەنىدىدۇر. خۇدا ئۆزى قىلماقچى بولغان ئىشلىرىنى پىرەۋنگە ئالدىن بىلدۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","بۇ يەتتە ياخشى ئىنەك يەتتە يىلنى كۆرسىتىدۇ؛ يەتتە ياخشى باشاقمۇ يەتتە يىلنى كۆرسىتىدۇ. بۇ چۈشلەر ئوخشاش بىر چۈشتۇر. ");
INSERT INTO uigara_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ئۇلاردىن كېيىن چىققان يەتتە ئورۇق، يامان سەت ئىنەك يەتتە يىلنى كۆرسىتىدۇ؛ شەرق شامىلى بىلەن سولىشىپ قالغان يەتتە قۇرۇق باشاقمۇ شۇنداق بولۇپ، ئاچارچىلىق بولىدىغان يەتتە يىلدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","مەن پىرەۋنگە دەيدىغان سۆزۈم شۇكى، خۇدا يېقىندا قىلماقچى بولغان ئىشنى پىرەۋنگە ئايان قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","مانا، پۈتكۈل مىسىر زېمىنىدا يەتتە يىلغىچە مەمۇرچىلىق بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ئاندىن يەتتە يىلغىچە ئاچارچىلىق بولىدۇ؛ شۇنىڭ بىلەن مىسىر زېمىنىدا پۈتكۈل مەمۇرچىلىقنى ئۇنۇتقۇزىدىغان ئاچارچىلىق زېمىننى ۋەيران قىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","كېلىدىغان ئاچارچىلىقنىڭ سەۋەبىدىن زېمىندا بولغان مەمۇرچىلىق كىشىلەرنىڭ ئېسىدىن كۆتۈرۈلۈپ كېتىدۇ؛ چۈنكى ئاچارچىلىق تولىمۇ ئېغىر بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","لېكىن چۈشنىڭ ياندۇرۇلۇپ، پىرەۋنگە ئىككى قېتىم كۆرۈنگىنىنىڭ ئەھمىيىتى شۇكى، بۇ ئىش خۇدا تەرىپىدىن بېكىتىلگەن بولۇپ، خۇدا ئۇنى پات ئارىدا ئەمەلگە ئاشۇرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ئەمدى پىرەۋن ئۆزى ئۈچۈن پەم-پاراسەتلىك ھەم دانا بىر كىشىنى تېپىپ، مىسىر زېمىنىغا قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","پىرەۋن شۇنداق قىلسۇنكى، مەمۇرچىلىق بولغان يەتتە يىلدا مىسىر زېمىنىدىن چىققان ئاشلىقنىڭ بەشتىن بىرىنى توپلاڭلار دەپ زېمىنغا نازارەتچىلەرنى تەيىنلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","بۇلار شۇ كېلىدىغان توقچىلىق يىللىرىدا بارلىق ئاشلىقنى توپلاپ، شەھەر-شەھەرلەردە يېمەكلىك بولسۇن دەپ بۇغداي-قوناقلارنى پىرەۋننىڭ قول ئاستىغا جەم قىلىپ ساقلىتىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","يىغىلغان شۇ ئاشلىقلار مىسىر زېمىنىدا بولىدىغان يەتتە يىللىق ئاچارچىلىققا تاقابىل تۇرۇش ئۈچۈن ساقلانسۇن؛ شۇ تەرىقىدە زېمىن ئاچارچىلىقتىن ھالاك بولمايدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","بۇ سۆز پىرەۋن ۋە ئۇنىڭ خىزمەتكارلىرىنىڭ نەزىرىگە تازا ياقتى. ");
INSERT INTO uigara_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","شۇنىڭ بىلەن پىرەۋن خىزمەتكارلىرىغا: ــ بۇ كىشىدەك، ئىچىدە خۇدانىڭ روھى بار يەنە بىرسىنى تاپالامدۇق؟! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","پىرەۋن يۈسۈپكە: ــ خۇدا ساڭا بۇنىڭ ھەممىسىنى ئايان قىلغانىكەن، سەندەك پەملىك ھەم دانا ھېچكىم چىقمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","سەن ئەمدى مېنىڭ ئۆيۈمنى باشقۇرۇشقا بېكىتىلدىڭ، بارلىق خەلقىم سېنىڭ ئاغزىڭغا قاراپ ئۆزلىرىنى تەرتىپكە تىزسۇن. پەقەت تەختتىلا مەن سەندىن ئۈستۈن تۇرىمەن، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ئاخىرىدا پىرەۋن يۈسۈپكە: ــ مانا، مەن سېنى پۈتكۈل مىسىر زېمىنىنىڭ ئۈستىگە تەيىنلىدىم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","بۇنىڭ بىلەن، پىرەۋن ئۆز قولىدىن مۆھۈر ئۈزۈكىنى چىقىرىپ، يۈسۈپنىڭ قولىغا سالدى؛ ئۇنىڭغا نەپىس كاناپ رەختتىن تىكىلگەن لىباسنى كىيگۈزۈپ، بوينىغا بىر ئالتۇن زەنجىر ئېسىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ئۇنى ئۆزىنىڭ ئىككىنچى شاھانە ھارۋىسىغا ئولتۇرغۇزۇپ، ئۇنىڭ ئالدىدا: «تىز پۈكۈڭلار!» ــ دەپ جار سالدۇردى. شۇنداق قىلىپ، پىرەۋن ئۇنى پۈتكۈل مىسىر زېمىنىغا تىكلەپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ئاندىن پىرەۋن يۈسۈپكە يەنە: ــ مەن دېگەن پىرەۋندۇرمەن؛ پۈتكۈل مىسىر زېمىنىدا سەنسىز ھېچكىم قول-پۇتىنى مىدىرلاتمىسۇن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_45‏","002_41_45‏","GEN","41","45‏","46","پىرەۋن يۈسۈپكە زافىنات-پائانىياھ دېگەن نامنى بەردى ۋە ئون شەھىرىدىكى كاھىن پوتىفىراھنىڭ قىزى ئاسىناتنى ئۇنىڭغا خوتۇنلۇققا ئېلىپ بەردى. شۇنداق قىلىپ يۈسۈپ پۈتكۈل مىسىر زېمىنىنى باشقۇرۇش ئۈچۈن چۆرگىلەشكە چىقتى. يۈسۈپ مىسىر پادىشاھى پىرەۋننىڭ خىزمىتىدە بولۇشقا بېكىتىلگەندە ئوتتۇز ياشتا ئىدى؛ ئۇ پىرەۋننىڭ ئالدىدىن چىقىپ، مىسىر زېمىنىنىڭ ھەرقايسى جايلىرىنى كۆزدىن كەچۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","مەمۇرچىلىق بولغان يەتتە يىل ئىچىدە زېمىننىڭ ھوسۇلى دۆۋە-دۆۋە بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","يەتتە يىلدا ئۇ مىسىر زېمىنىدىن چىققان ئاشلىقنى يىغىپ، شەھەر-شەھەرگە توپلىدى؛ ھەرقايسى شەھەرنىڭ ئەتراپىدىكى ئېتىزلىقنىڭ ئاشلىقىنى ئۇ شۇ شەھەرنىڭ ئۆزىگە جۇغلاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","شۇ تەرىقىدە يۈسۈپ دېڭىزدىكى قۇمدەك ناھايىتى كۆپ ئاشلىق توپلىدى؛ ئاشلىق ھەددى-ھېسابسىز بولغاچقا، ئۇلار ھېسابلاشنى توختاتتى. ");
INSERT INTO uigara_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ئاچارچىلىق يىللىرى يېتىپ كېلىشتىن بۇرۇن يۈسۈپكە ئىككى ئوغۇل تۆرەلدى. بۇلارنى ئوندىكى كاھىن پوتىفەراھنىڭ قىزى ئاسىنات ئۇنىڭغا تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","يۈسۈپ: «خۇدا پۈتۈن جاپا-مۇشەققىتىم ۋە ئاتامنىڭ پۈتۈن ئائىلىسىنى كۆڭلۈمدىن كۆتۈرۈۋەتتى» دەپ تۇنجى ئوغلىغا ماناسسەھ دەپ ئات قويدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ئاندىن: «مەن ئازاب-ئوقۇبەت چەككەن يۇرتتا خۇدا مېنى مېۋىلىك قىلدى» دەپ ئىككىنچىسىگە ئەفرائىم دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","مىسىر زېمىنىدا مەمۇرچىلىق بولغان يەتتە يىل ئاياغلاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ئاندىن يۈسۈپنىڭ ئېيتقىنىدەك ئاچارچىلىقنىڭ يەتتە يىلى باشلاندى. ئۇ چاغلاردا باشقا بارلىق يۇرتلاردىمۇ ئاچارچىلىق بولدى؛ لېكىن مىسىر زېمىنىدىكى ھەر يەرلەردە نان بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ئاچارچىلىق پۈتكۈل مىسىر زېمىننى باسقاندا، خەلق ئاشلىق سوراپ پىرەۋنگە پەرياد قىلدى. پىرەۋن مىسىرلىقلارنىڭ ھەممىسىگە: ــ يۈسۈپنىڭ قېشىغا بېرىپ، ئۇ سىلەرگە نېمە دېسە، شۇنى قىلىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ئاچارچىلىق پۈتكۈل يەر يۈزىنى بېسىپ كەتتى. يۈسۈپ ھەر يەردىكى ئامبارلارنى ئېچىپ، مىسىرلىقلارغا ئاشلىق ساتاتتى؛ ئاچارچىلىق مىسىر زېمىنىدا ئىنتايىن ئېغىر بولغىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ئاچارچىلىق پۈتكۈل يەر يۈزىنى باسقان بولغاچقا، بارلىق يۇرتلاردىكى خەلقمۇ ئاشلىق ئالغىلى مىسىرغا يۈسۈپنىڭ قېشىغا كېلەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ئەمدى ياقۇپ مىسىردا ئاشلىق بارلىقىنى بىلگىنىدە ئوغۇللىرىغا: ــ نېمىشقا بىر-بىرىڭلارغا قارىشىپ تۇرىسىلەر؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ئاندىن يەنە: ــ ماڭا قاراڭلار، ئاڭلىشىمچە مىسىردا ئاشلىق بار ئىكەن. ئۇ يەرگە بېرىپ، ئاندىن شۇ يەردىن بىزگە ئاشلىق ئېلىپ كېلىڭلار؛ بۇنىڭ بىلەن ئۆلۈپ كەتمەي، تىرىك قالىمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","بۇنىڭ بىلەن يۈسۈپنىڭ ئون ئاكىسى ئاشلىق سېتىۋالغىلى مىسىرغا يولغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","لېكىن ياقۇپ يۈسۈپنىڭ ئىنىسى بىنيامىننىڭ بىرەر يامانلىققا ئۇچراپ قېلىشىدىن قورقۇپ ئۇنى ئاكىلىرى بىلەن بىللە ئەۋەتمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","شۇنىڭدەك ئاچارچىلىق قانائان زېمىنىدىمۇ يۈز بەرگەچكە، ئىسرائىلنىڭ ئوغۇللىرى ئاشلىق ئالغىلى كەلگەنلەر ئارىسىدا بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","يۈسۈپ زېمىننىڭ ۋالىيسى بولۇپ، يۇرتنىڭ بارلىق خەلقىگە ئاشلىق سېتىپ بەرگۈچى شۇ ئىدى. يۈسۈپنىڭ ئاكىلىرى كېلىپ ئۇنىڭ ئالدىدا يۈزلىرىنى يەرگە تەگكۈزۈپ تەزىم قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","يۈسۈپ ئاكىلىرىنى كۆرۈپلا ئۇلارنى تونۇدى؛ لېكىن ئۇ تونۇشلۇق بەرمەي، ئۇلارغا قوپال تەلەپپۇزدا گەپ قىلىپ: ــ قەيەردىن كەلدىڭلار، دەپ سورىدى. ئۇلار جاۋابەن: ــ قانائان زېمىنىدىن ئاشلىق ئالغىلى كەلدۇق، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","يۈسۈپ ئاكىلىرىنى تونۇغان بولسىمۇ، لېكىن ئۇلار ئۇنى تونۇمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","يۈسۈپ ئەمدى ئۇلار توغرىسىدا كۆرگەن چۈشلىرىنى ئېسىگە ئېلىپ، ئۇلارغا: ــ سىلەر جاسۇس، بۇ ئەلنىڭ مۇداپىئەسىز جايلىرىنى كۆزەتكىلى كەلدىڭلار، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ئەمما ئۇلار ئۇنىڭغا جاۋاب بېرىپ: ــ ئەي خوجام، ئۇنداق ئەمەس! بەلكى كەمىنىلىرى ئاشلىق سېتىۋالغىلى كەلدى! ");
INSERT INTO uigara_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","بىز ھەممىمىز بىر ئادەمنىڭ ئوغۇللىرى، سەمىمىي ئادەملەرمىز. كەمىنىلىرى جاسۇس ئەمەس! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ئۇ ئۇلارغا يەنە: ــ ئۇنداق ئەمەس! بەلكى زېمىننىڭ مۇداپىئەسىز جايلىرىنى كۆرگىلى كەلدىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ئۇلار جاۋاب بېرىپ: ــ كەمىنىلىرى ئەسلىدە ئون ئىككى قېرىنداش ئىدۇق؛ بىز ھەممىمىز قانائان زېمىنىدىكى بىر ئادەمنىڭ ئوغۇللىرىدۇرمىز؛ لېكىن كەنجى ئىنىمىز ئاتىمىزنىڭ قېشىدا قېلىپ قالدى؛ يەنە بىر ئىنىمىز يوقاپ كەتتى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ئەمما يۈسۈپ ئۇلارغا يەنە: ــ مانا مەن دەل سىلەرگە ئېيتقىنىمدەك، جاسۇس ئىكەنسىلەر! ");
INSERT INTO uigara_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","پىرەۋننىڭ ھاياتى بىلەن قەسەم قىلىمەنكى، كىچىك ئىنىڭلار بۇ يەرگە كەلمىگۈچە سىلەر بۇ يەردىن چىقىپ كېتەلمەيسىلەر؛ سىلەر شۇنىڭ بىلەن سىنىلىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ئىنىڭلارنى ئېلىپ كەلگىلى بىرىڭلارنى ئەۋەتىڭلار، قالغانلىرىڭلار بولسا سولاپ قويۇلىسىلەر. بۇنىڭ بىلەن ئېيتقىنىڭلارنىڭ راست-يالغانلىقى ئىسپاتلىنىدۇ؛ بولمىسا، پىرەۋننىڭ ھاياتى بىلەن قەسەم قىلىمەنكى، سىلەر جەزمەن جاسۇس! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","شۇنىڭ بىلەن ئۇ ئۇلارنى ئۈچ كۈنگىچە سولاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ئۈچىنچى كۈنى يۈسۈپ ئۇلارغا مۇنداق دېدى: ــ مەن خۇدادىن قورقىدىغان ئادەممەن؛ تىرىك قېلىشىڭلار ئۈچۈن مۇشۇ ئىشنى قىلىڭلار: ــ ");
INSERT INTO uigara_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ئەگەر سەمىمىي ئادەملەر بولساڭلار، قېرىنداشلىرىڭلاردىن بىرى سىلەر سولانغان گۇندىخانىدا سولاقلىق تۇرىۋەرسۇن، قالغىنىڭلار ئاچارچىلىقتا قالغان ئائىلەڭلار ئۈچۈن ئاشلىق ئېلىپ كېتىڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ئاندىن كىچىك ئىنىڭلارنى قېشىمغا ئېلىپ كېلىڭلار. شۇنىڭ بىلەن سۆزلىرىڭلار ئىسپاتلانسا، ئۆلمەيسىلەر!، ــ دېدى. ئۇلار شۇنداق قىلىدىغان بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ئاندىن ئۇلار ئۆزئارا: ــ بەرھەق، بىز ئىنىمىزغا قىلغان ئىشىمىز بىلەن گۇناھكار بولۇپ قالدۇق؛ ئۇ بىزگە يالۋۇرسىمۇ ئۇنىڭ ئازابىنى كۆرۈپ تۇرۇپ ئۇنىڭغا قۇلاق سالمىدۇق. شۇنىڭ ئۈچۈن بۇ ئازاب-ئوقۇبەت بېشىمىزغا چۈشتى، ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","رۇبەن ئۇلارغا جاۋابەن: ــ مەن سىلەرگە: بالىغا زۇلۇم قىلماڭلار، دېگەن ئەمەسمىدىم؟ لېكىن ئۇنىمىدىڭلار. مانا ئەمدى ئۇنىڭ قان قەرزى بىزدىن سورىلىۋاتىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ئەمما يۈسۈپ ئۇلار بىلەن تەرجىمان ئارقىلىق سۆزلەشكەچكە، ئۇلار يۈسۈپنىڭ ئۆز گەپلىرىنى ئۇقۇپ تۇرۇۋاتقىنىنى بىلمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ئۇ ئۇلاردىن ئۆزىنى چەتكە ئېلىپ، يىغلاپ كەتتى. ئاندىن ئۇلارنىڭ قېشىغا يېنىپ كېلىپ، ئۇلارغا يەنە سۆز قىلىپ، ئۇلارنىڭ ئارىسىدىن شىمېئوننى تۇتۇپ، ئۇلارنىڭ كۆز ئالدىدا باغلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ئاندىن يۈسۈپ ئەمر چۈشۈرۈپ، ئۇلارنىڭ تاغارلىرىغا ئاشلىق تولدۇرۇپ، ھەر بىرسىنىڭ پۇلىنى قايتۇرۇپ تاغىرىغا سېلىپ قويۇپ، سەپەر ھازىرلىقلىرىمۇ بېرىلسۇن دەپ بۇيرۇۋىدى، ئۇلارغا شۇنداق قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","شۇنىڭ بىلەن ئاكىلىرى ئېشەكلىرىگە ئاشلىقلىرىنى ئارتىپ، شۇ يەردىن كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ئەمما ئۆتەڭگە كەلگەندە ئۇلاردىن بىرى ئېشىكىگە يەم بەرگىلى تاغىرىنى ئېچىۋىدى، مانا، ئۆز پۇلى تاغارنىڭ ئاغزىدا تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ئۇ قېرىنداشلىرىغا: ــ مېنىڭ پۇلۇمنى قايتۇرۇۋېتىپتۇ. مانا ئۇ تاغىرىمدا تۇرىدۇ، دېدى. بۇنى ئاڭلاپ ئۇلارنىڭ يۈرىكى سۇ بولۇپ، تىترىشىپ بىر-بىرىگە: ــ بۇ خۇدانىڭ بىزگە زادى نېمە قىلغىنىدۇ؟ ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ئۇلار قانائان زېمىنىغا، ئاتىسى ياقۇپنىڭ قېشىغا كېلىپ، بېشىدىن ئۆتكەن ھەممە ۋەقەلەرنى ئۇنىڭغا سۆزلەپ بېرىپ: ");
INSERT INTO uigara_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ــ ھېلىقى كىشى، يەنى شۇ زېمىننىڭ خوجىسى بىزگە قوپال گەپ قىلدى، بىزگە زېمىننى پايلىغۇچى جاسۇستەك مۇئامىلە قىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ئەمدى بىز ئۇنىڭغا: «بىز بولساق سەمىمىي ئادەملەرمىز، جاسۇس ئەمەسمىز. ");
INSERT INTO uigara_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","بىز بىر ئاتىدىن بولغان ئوغۇللار بولۇپ، ئون ئىككى ئاكا-ئۇكا ئىدۇق؛ بىرى يوقاپ كەتتى، كىچىك ئىنىمىز ھازىر قانائان زېمىنىدا ئاتىمىزنىڭ يېنىدا قالدى» دېسەك، ");
INSERT INTO uigara_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ھېلىقى كىشى، يەنى شۇ زېمىننىڭ خوجىسى بىزگە مۇنداق دېدى: «مېنىڭ سىلەرنىڭ سەمىمىي ئىكەنلىكىڭلارنى بىلىشىم ئۈچۈن، قېرىنداشلىرىڭلارنىڭ بىرىنى مېنىڭ يېنىمدا قالدۇرۇپ قويۇپ، ئاچ قالغان ئائىلەڭلار ئۈچۈن ئاشلىق ئېلىپ كېتىڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ئاندىن كىچىك ئىنىڭلارنى قېشىمغا ئېلىپ كېلىڭلار؛ شۇنداق قىلساڭلار، سىلەرنىڭ جاسۇس ئەمەس، بەلكى سەمىمىي ئادەملەر ئىكەنلىكىڭلارنى بىلەلەيمەن. ئاندىن قېرىندىشىڭلارنى سىلەرگە قايتۇرۇپ بېرىمەن ۋە سىلەر زېمىندا سودا-سېتىق قىلساڭلار بولىدۇ» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ئەمما شۇنداق بولدىكى، ئۇلار تاغارلىرىنى تۆككەندە، مانا ھەربىرىنىڭ پۇلدىنى ئۆز تاغارلىرىدا تۇراتتى! ئۇلار ۋە ئاتىسى ئۆزلىرىنىڭ چىگىكلىك پۇللىرىنى كۆرگەندە، قورقۇپ قېلىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ئاتىسى ياقۇپ ئۇلارغا: ــ مېنى ئوغلۇمدىن جۇدا قىلدىڭلار! يۈسۈپ يوق بولدى، شىمېئونمۇ يوق، ئەمدى بىنيامىننىمۇ ئېلىپ كەتمەكچى بولۇۋاتىسىلەر! مانا بۇ ئىشلارنىڭ ھەممىسى مېنىڭ بېشىمغىلا كەلدى! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","رۇبەن ئاتىسىغا: ــ ئەگەر مەن بىنيامىننى قېشىڭغا قايتۇرۇپ ئېلىپ كەلمىسەم، مېنىڭ ئىككى ئوغلۇمنى ئۆلتۈرۈۋەتكىن؛ ئۇنى مېنىڭ قولۇمغا تاپشۇرغىن؛ مەن ئۇنى قېشىڭغا ياندۇرۇپ ئېلىپ كېلىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","لېكىن ياقۇپ جاۋاب بېرىپ: ــ ئوغلۇم سىلەر بىلەن بىللە ئۇ يەرگە چۈشمەيدۇ؛ چۈنكى ئۇنىڭ ئاكىسى ئۆلۈپ كېتىپ، ئۇ ئۆزى يالغۇز قالدى. مۇبادا يولدا كېتىۋاتقاندا ئۇنىڭغا بىرەر كېلىشمەسلىك كەلسە، سىلەر مەندەك بىر ئاق چاچلىق ئادەمنى دەرد-ئەلەم بىلەن تەھتىساراغا چۈشۈرۈۋېتىسىلەر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ئاچارچىلىق زېمىننى ئىنتايىن ئېغىر باسقانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","بۇ سەۋەبتىن ئۇلار مىسىردىن ئېلىپ كەلگەن ئاشلىقنى يەپ تۈگەتكەندە، ئاتىسى ئۇلارغا: ــ يەنە بېرىپ بىزگە ئازغىنا ئاشلىق ئېلىپ كېلىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","لېكىن يەھۇدا ئۇنىڭغا جاۋابەن: ــ ھېلىقى كىشى بىزنى قاتتىق ئاگاھلاندۇرۇپ: «ئىنىڭلار سىلەر بىلەن بىللە كەلمىسە، يۈزۈمنى كۆرىمەن دەپ خىيال قىلماڭلار» دېگەن. ");
INSERT INTO uigara_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ئەگەر ئىنىمىزنى بىز بىلەن بىللە ئەۋەتسەڭ، بىز بېرىپ ساڭا ئاشلىق ئېلىپ كېلىمىز. ");
INSERT INTO uigara_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ئەمما ئەۋەتىشكە ئۇنىمىساڭ، بىز بارمايمىز؛ چۈنكى ھېلىقى كىشى بىزگە: «ئىنىڭلار سىلەر بىلەن بىللە كەلمىسە، يۈزۈمنى كۆرىمەن دەپ خىيال قىلماڭلار» دېگەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ئىسرائىل ئۇلارغا: ــ سىلەر نېمىشقا ماڭا شۇنچە يامانلىق قىلىپ ئۇ كىشىگە: «يەنە بىر ئىنىمىزمۇ بار» دېدىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ئۇلار جاۋابەن: ــ ئۇ كىشى بىزنىڭ ۋە ئائىلىمىزنىڭ ئەھۋالىنى سۈرۈشتۈرۈپ كوچىلاپ: «ئاتاڭلار تېخى ھاياتمۇ؟ يەنە بىر ئىنىڭلار بارمۇ؟» ــ دەپ سورىدى. بىز ئۇنىڭ شۇ سوئالىغا يارىشا جاۋاب بەردۇق. ئۇنىڭ بىزگە: «ئىنىڭلارنى ئېلىپ كېلىڭلار» دەيدىغىنىنى نەدىن بىلەيلى؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","يەھۇدا ئاتىسى ئىسرائىلغا: ــ بالىنى مەن بىلەن ئەۋەتكىن؛ بىز دەرھال قوزغىلىپ يولغا چىقايلى؛ شۇنداقتا بىز ۋە سەن، بىزلەر ھەم بالىلىرىمىز ئۆلمەي، تىرىك قالىمىز. ");
INSERT INTO uigara_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","مەن ئۇنىڭغا كېپىل بولىمەن؛ سەن ئۇنىڭ ئۈچۈن مېنىڭدىن ھېساب ئالىسەن؛ ئەگەر مەن ئۇنى سېنىڭ قېشىڭغا ئامان-ئېسەن ياندۇرۇپ كېلىپ، يۈزۈڭنىڭ ئالدىدا تۇرغۇزمىسام، پۈتكۈل ئۆمرۈمدە ئالدىڭدا گۇناھكار بولاي.    ");
INSERT INTO uigara_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","چۈنكى ھايال بولمىغان بولساق، بۇ چاغقىچە ئىككى قېتىم بېرىپ كېلەتتۇق، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ئۇلارنىڭ ئاتىسى ئىسرائىل ئۇلارغا: ــ ئۇنداق بولسا، مۇنداق قىلىڭلار: ــ ئۇ كىشىگە قاچا-قۇچاڭلارغا زېمىندىكى ئەڭ ئېسىل مېۋىلەردىن سوۋغات ئالغاچ بېرىڭلار: يەنە ئازغىنا تۇتىيا، ئازراق ھەسەل، دورا-دەرمانلار، مۇرمەككى، پىستە ۋە باداملارنى ئالغاچ بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","قولۇڭلاردا ئىككى ھەسسە پۇل ئېلىپ، تاغارلىرىڭلارنىڭ ئاغزىدىكى ئۆزۈڭلارغا ياندۇرۇلغان پۇلنىمۇ ئالغاچ بېرىڭلار. ئېھتىمال، بۇ ئىشتا سەۋەنلىك كۆرۈلگەن بولۇشى مۇمكىن. ");
INSERT INTO uigara_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ئىنىڭلارنىمۇ بىللە ئېلىپ، قوزغىلىپ ئۇ كىشىنىڭ يېنىغا يەنە بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ھەممىگە قادىر تەڭرى ئۆزى سىلەرنى ئۇ كىشىنىڭ ئالدىدا رەھىمگە ئېرىشتۈرگەي. بۇنىڭ بىلەن ئۇ سىلەرنىڭ شۇ يەردىكى قېرىندىشىڭلارنى ۋە بىنيامىننى قويۇپ بېرىپ، سىلەرگە قوشۇپ قويارمىكىن؛ ئۆزۈم ناۋادا بالىلىرىمدىن جۇدا بولسام بولاي! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","شۇنىڭ بىلەن بۇ ئادەملەر شۇ سوۋغاتنى ئېلىپ، قوللىرىغا ئىككى ھەسسە پۇلنى تۇتۇپ، بىنيامىننى ئېلىپ قوزغىلىپ، مىسىرغا بېرىپ يۈسۈپنىڭ ئالدىدا ھازىر بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","يۈسۈپ بىنيامىننى ئۇلار بىلەن بىللە كۆرگىنىدە، ئۆز ئۆيىنى باشقۇرىدىغان غوجىدارىغا بۇيرۇپ: ــ بۇ ئادەملەرنى ئۆيۈمگە باشلاپ كىرىپ، مال سويۇپ تائام تەييار قىلغىن؛ چۈنكى بۇ كىشىلەر چۈشلۈك غىزانى مەن بىلەن يەيدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ئۇ كىشى يۈسۈپنىڭ بۇيرۇغىنىدەك قىلىپ، ئادەملەرنى يۈسۈپنىڭ ئۆيىگە باشلاپ كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ئۇلار بولسا يۈسۈپنىڭ ئۆيىگە باشلاپ كېلىنگىنىدىن قورقۇشۇپ: ــ ئالدىنقى قېتىم تاغارلىرىمىزغا ياندۇرۇلغان پۇلنىڭ سەۋەبىدىن بىز ئۇنىڭ ئۆيىگە ئېلىپ كېلىندۇق؛ ئۇنىڭ مەقسىتى بىزگە ھۇجۇم قىلىپ، ئۈستىمىزدىن بېسىپ قۇل قىلىپ، ئېشەكلىرىمىزنى تارتىۋېلىش ئوخشايدۇ، ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ئۇلار يۈسۈپنىڭ ئۆيىنى باشقۇرىدىغان غوجىدارنىڭ يېنىغا كېلىپ، ئۆينىڭ ئىشىكىنىڭ تۈۋىدە ئۇنىڭغا: ــ ");
INSERT INTO uigara_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ئەي خوجام، بىز ھەقىقەتەن ئەسلىدە مۇشۇ يەرگە ئاشلىق ئالغىلى كەلگەنىدۇق؛ ");
INSERT INTO uigara_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","شۇنداق بولدىكى، بىز ئۆتەڭگە كېلىپ ئۆز تاغارلىرىمىزنى ئاچساق، مانا ھەربىرىمىزنىڭ پۇلى، ئەينى ئېغىرلىقى بويىچە تاغارلىرىمىزنىڭ ئاغزىدا تۇرۇپتۇ؛ شۇڭا بىز بۇنى ياندۇرۇپ قولىمىزدا ئالغاچ كەلدۇق. ");
INSERT INTO uigara_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ئاشلىق ئالغىلى قولىمىزدا باشقا پۇلمۇ ئېلىپ كەلدۇق؛ ئەمما تاغارلىرىمىزغا پۇلنى كىمنىڭ سېلىپ قويغانلىقىنى بىلمىدۇق، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ئۇ ئۇلارغا: ــ خاتىرجەم بولۇڭلار، قورقماڭلار. سىلەرنىڭ خۇدايىڭلار، ئاتاڭلارنىڭ خۇداسى تاغارلىرىڭلاردا سىلەرگە بايلىق ئاتا قىلغان ئوخشايدۇ؛ سىلەرنىڭ پۇلۇڭلارنى ئاللىقاچان تاپشۇرۇپ ئالدىم، ــ دېدى. ئاندىن ئۇ شىمېئوننى ئۇلارنىڭ قېشىغا ئېلىپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ئۇ كىشى ئۇلارنى يۈسۈپنىڭ ئۆيىگە باشلاپ كىرىپ، ئۇلارنىڭ پۇتلىرىنى يۇيۇشىغا سۇ ئەكىرىپ بېرىپ، ئاندىن ئېشەكلىرىگە يەم بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ئۇلار يۈسۈپنىڭ چۈشتە كېلىشىگە ئۈلگۈرتۈپ سوۋغاتنى تەييارلاپ قويدى؛ چۈنكى ئۇلار ئۆزلىرىنىڭ شۇ يەردە غىزا يەيدىغىنىنى ئاڭلىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","يۈسۈپ ئۆيگە كەلگەندە ئۇلار قوللىرىدىكى سوۋغاتنى ئۆيگە ئۇنىڭ ئالدىغا ئېلىپ كىرىپ، بېشىنى يەرگە تەگكۈزۈپ ئۇنىڭغا تەزىم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ئۇ ئۇلاردىن ھال سوراپ، ئاندىن: ــ سىلەر گېپىنى قىلغان قېرى ئاتاڭلار سالامەتمۇ؟ ئۇ ھاياتمۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ئۇلار جاۋاب بېرىپ: ــ سىلىنىڭ قۇللىرى بىزنىڭ ئاتىمىز سالامەت تۇرۇۋاتىدۇ، ئۇ تېخى ھاياتتۇر، ــ دەپ ئۇنىڭ ئالدىدا ئېگىلىپ تەزىم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","يۈسۈپ بېشىنى كۆتۈرۈپ، ئۆز ئىنىسى بىنيامىننى كۆرۈپ: ــ سىلەر ماڭا گېپىنى قىلغان كىچىك ئىنىڭلار شۇمۇ؟ ــ دەپ سوراپ: ــ ئەي ئوغلۇم، خۇدا ساڭا شاپائەت كۆرسەتكەي! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","يۈسۈپنىڭ ئۆز ئىنىسىغا بولغان سېغىنىش ئوتى قاتتىق كۈچىيىپ، يىغلىۋالغۇدەك خالىي جاي ئىزدەپ، ئالدىراپ ئىچكىرىكى ئۆيگە كىرىپ تازا بىر يىغلىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ئاندىن يۈزىنى يۇيۇپ چىقىپ، ئۆزىنى بېسىۋېلىپ: ــ تائاملارنى قويۇڭلار، ــ دەپ بۇيرۇدى. ");
INSERT INTO uigara_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","خىزمەتكارلار يۈسۈپكە ئايرىم، ئۇلارغا ئايرىم ۋە يۈسۈپ بىلەن بىللە تاماققا كەلگەن مىسىرلىقلارغىمۇ ئايرىم تاماق قويدى؛ چۈنكى مىسىرلىقلار ئىبرانىيلار بىلەن بىر داستىخاندا تاماق يېيىشنى يىرگىنچلىك دەپ قاراپ، ئۇلار بىلەن بىللە تاماق يېمەيتتى. ");
INSERT INTO uigara_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","يۈسۈپنىڭ قېرىنداشلىرى ئۇنىڭ ئۇدۇلىدا، ھەربىرى چوڭ-كىچىك تەرتىپى بويىچە ئولتۇرغۇزۇلدى؛ چوڭى چوڭلۇقىغا يارىشا، كىچىكى كىچىكلىكىگە يارىشا ئولتۇرغۇزۇلدى؛ ئۇلار بىر-بىرىگە قاراپ ھەيران قېلىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","يۈسۈپ ئالدىدىكى داستىخاندىكى تاماقلاردىن ئۇلارغا بۆلۈپ بەردى. ئەمما بىنيامىنغا بەرگىنى باشقىلارنىڭكىگە قارىغاندا بەش ھەسسە كۆپ ئىدى. ئۇلار شاراب ئىچىپ، ئۇنىڭ بىلەن خۇش كەيپ قىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ئاندىن ئۇ ئۆز ئۆيىنى باشقۇرىدىغان غوجىدارىغا بۇيرۇپ: ــ بۇ كىشىلەرنىڭ تاغارلىرىنى ئېلىپ كۆتۈرەلىگۈدەك ئاشلىق قاچىلاپ، ھەربىرىنىڭ پۇلىنى تاغىرىنىڭ ئاغزىغا سېلىپ قويغىن؛ ");
INSERT INTO uigara_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ئاندىن مېنىڭ جامىمنى، يەنى كۈمۈش جامنى ئاشلىقنىڭ پۇلى بىلەن بىللە ئەڭ كىچىكىنىڭ تاغىرىنىڭ ئاغزىغا سېلىپ قويغىن، ــ دېدى. ئۇ ئادەم يۈسۈپنىڭ دېگىنىدەك قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ئەتىسى تاڭ يورىغاندا، ئۇلار ئېشەكلىرى بىلەن بىللە يولغا سېلىپ قويۇلدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","لېكىن ئۇلار شەھەردىن چىقىپ ئانچە ئۇزۇن ماڭمايلا، يۈسۈپ غوجىدارىغا: ــ ئورنۇڭدىن تۇر، بۇ ئادەملەرنىڭ كەينىدىن قوغلىغىن؛ ئۇلارغا يېتىشكىنىڭدە ئۇلارغا: «نېمىشقا ياخشىلىققا يامانلىق قايتۇردۇڭلار؟ ");
INSERT INTO uigara_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","خوجام شۇ جامدا شاراب ئىچىدۇ ھەمدە ئۇنىڭدا پال ئاچىدۇ ئەمەسمۇ؟! مۇنداق قىلغىنىڭلار رەزىللىك قىلغىنىڭلار بولمامدۇ!» دېگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","بۇ ئادەم ئۇلارنىڭ كەينىدىن يېتىشىپ بېرىپ، ئۇلارغا بۇ سۆزلەرنى قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ئۇلار ئۇنىڭغا جاۋابەن: ــ خوجىمىز نېمىشقا مۇنداق گەپ قىلىدۇ؟ مۇنداق ئىشنى قىلىش كەمىنىلىرىدىن نېرى بولسۇن! ");
INSERT INTO uigara_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","بىز ئەسلىدە تاغارلىرىمىزنىڭ ئاغزىدىن تاپقان پۇلنىمۇ قانائان زېمىنىدىن سىلىنىڭ قاشلىرىغا قايتۇرۇپ بېرىشكە ئەكەلگەنىدۇق. شۇنداق تۇرۇقلۇق قانداقمۇ خوجىلىرىنىڭ ئۆيىدىن ئالتۇن-كۈمۈشنى ئوغرىلايلى؟ ");
INSERT INTO uigara_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","كەمىنىلىرىڭنىڭ ئارىسىدا كىمدىن بۇ جام تېپىلسا، شۇ ئۆلۈمگە مەھكۇم بولسۇن، بىزمۇ خوجىمىزنىڭ قۇللىرى بولايلى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","غوجىدار جاۋابەن: ــ ئېيتقان سۆزلىرىڭلاردەك بولسۇن؛ جام كىمنىڭ يېنىدىن تېپىلسا، شۇ كىشى قۇلۇم بولۇپ قېلىپ قالسۇن، قالغانلىرىڭلار بىگۇناھ بولىسىلەر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","شۇنىڭ بىلەن ئۇلار ئالدىراپ-تېنەپ، تاغارلىرىنى يەرگە چۈشۈرۈپ، ھەربىرى ئۆز تاغىرىنى ئېچىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","غوجىدار چوڭىنىڭكىدىن باشلاپ كىچىكىنىڭكىگىچە ئاختۇردى، جام بىنيامىننىڭ تاغىرىدىن تېپىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","بۇنى كۆرۈپ ئۇلار كىيىملىرىنى يىرتىشىپ، ھەربىرى ئېشىكىگە قايتىدىن يۈكنى ئارتىپ، شەھەرگە قايتتى. ");
INSERT INTO uigara_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","شۇنداق قىلىپ يەھۇدا ۋە قېرىنداشلىرى يۈسۈپنىڭ ئۆيىگە كەلدى؛ ئۇ تېخى شۇ يەردە ئىدى. ئۇلار ئۇنىڭ ئالدىغا كېلىپ ئۆزلىرىنى يەرگە ئېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","يۈسۈپ ئۇلارغا: ــ بۇ سىلەرنىڭ زادى نېمە قىلغىنىڭلار؟ مېنىڭدەك ئادەمنىڭ چوقۇم پال ئاچالايدىغانلىقىنى بىلمەمتىڭلار؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","يەھۇدا جاۋابەن: ــ بىز خوجىمىزغا نېمىمۇ دېيەلەيمىز؟ نېمە گەپ قىلالايمىز، قانداق قىلىپ ئۆزىمىزنى ئاقلىيالايمىز؟ خۇدا كەمىنلىرىنىڭ قەبىھلىكىنى ئاشكارا قىلدى. مانا، بىز ۋە قولىدىن جاملىرى تېپىلغان كىشى ھەممىمىز خوجىمىزغا قۇل بولىدىغان بولدۇق، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","لېكىن يۈسۈپ: ــ مۇنداق قىلىش مەندىن نېرى بولسۇن! بەلكى جام كىمنىڭ قولىدىن تېپىلغان بولسا پەقەت شۇ كىشى مېنىڭ قۇلۇم بولىدۇ. لېكىن قالغانلىرىڭلار ئامان-ئېسەن ئاتاڭلارنىڭ قېشىغا كېتىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ئاندىن يەھۇدا ئۇنىڭغا يېقىن بېرىپ مۇنداق دېدى: ــ ئەي خوجام، كەمىنىلىرىگە قۇلاق سېلىپ خوجامنىڭ قۇلىقىغا بىر ئېغىز گەپ قىلىشقا ئىجازەت بەرگەيلا. غەزەپلىرى كەمىنىلىرىگە تۇتاشمىغاي؛ چۈنكى ئۆزلىرى پىرەۋنگە ئوخشاش ئىكەنلا. ");
INSERT INTO uigara_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ئەسلىدە خوجام كەمىنىلىرىدىن: «ئاتاڭلار يا ئىنىڭلار بارمۇ؟» دەپ سورىۋىدىلا، ");
INSERT INTO uigara_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","بىز خوجىمىزغا جاۋابەن: «بىزنىڭ بىر قېرى ئاتىمىز بار ۋە ئۇ قېرىغاندا تاپقان، ياش بىر بالىسىمۇ بار. بۇ بالىنىڭ بىر ئانىسىدىن بولغان ئاكىسى ئۆلۈپ كېتىپ، ئۇ ئۆزى يالغۇز قالدى؛ ئۇنىڭ ئاتىسى ئۇنى ئىنتايىن سۆيىدۇ» دېسەك، ");
INSERT INTO uigara_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","سىلى كەمىنىلىرىگە: «ئۇنىڭ ئۆزىنى قېشىمغا ئېلىپ كېلىڭلار، مەن ئۇنى ئۆز كۆزۈم بىلەن كۆرەي» دېدىلە. ");
INSERT INTO uigara_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","بىز خوجىمىزغا جاۋاب بېرىپ: «يىگىت ئاتىسىدىن ئايرىلالمايدۇ؛ ئەگەر ئاتىسىدىن ئايرىلسا، ئاتىسى ئۆلۈپ كېتىدۇ» دېسەك، ");
INSERT INTO uigara_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","سىلى يەنىلا كەمىنىلىرىگە: «ئەگەر كىچىك ئىنىڭلار سىلەر بىلەن بىللە كەلمىسە، يۈزۈمنى يەنە كۆرىمىز دەپ خىيال قىلماڭلار» دېگەنىدىلا. ");
INSERT INTO uigara_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","شۇنىڭ بىلەن بىز كەمىنىلىرى ئاتىمىزنىڭ قېشىغا بارغاندا خوجامنىڭ سۆزلىرىنى ئۇنىڭغا ئېيتتۇق؛ ");
INSERT INTO uigara_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ئاندىن ئاتىمىز يەنە: «يەنە بېرىپ، بىزگە ئازراق ئاشلىق ئېلىپ كېلىڭلار» دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","بىز جاۋابەن: «بىز شۇ يەرگە قايتىدىن چۈشەلمەيمىز؛ ئەگەر كىچىك ئىنىمىز بىز بىلەن بىللە بولسا، ئۇنداقتا بارىمىز؛ چۈنكى كىچىك ئىنىمىز بىز بىلەن بىللە بولمىسا، ئۇ زاتنىڭ يۈزى ئالدىدا تۇرالمايمىز»، دېدۇق. ");
INSERT INTO uigara_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","سىلىنىڭ قۇللىرى بىزنىڭ ئاتىمىز بىزگە يەنە: «سىلەرگە مەلۇمكى، ئايالىم ماڭا ئىككى ئوغۇل تۇغۇپ بەرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","بىرى مېنىڭ يېنىمدىن چىقىپ، يوق بولۇپ كەتتى؛ مەن: ئۇ جەزمەن تىتما-تىتما قىلىۋېتىلىپتۇ، دەپ ئويلىدىم، شۇنداقلا ئۇنى بۈگۈنگىچە كۆرمىدىم. ");
INSERT INTO uigara_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ئەمدى سىلەر بۇنىمۇ مېنىڭ قېشىمدىن ئېلىپ كېتىپ، ئۇنىڭغا بىر كېلىشمەسلىك كېلىپ قالسا، سىلەر مەندەك بىر ئاق چاچلىق ئادەمنى دەرد-ئەلەم بىلەن تەھتىساراغا چۈشۈرۈۋېتىسىلەر»، دېگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ئەمدى مەن سىلىنىڭ قۇللىرى مېنىڭ ئاتامنىڭ قېشىغا بارغاندا، شۇ بالا بىز بىلەن بولمىسا ئۇنىڭ جېنى بالىنىڭ جېنىغا باغلانغان بولغاچقا، ");
INSERT INTO uigara_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","شۇنداق بولىدۇكى، ئۇ بالىنىڭ يوقلۇقىنى كۆرسە، جەزمەن ئۆلۈپ كېتىدۇ؛ شۇنىڭ بىلەن سىلىنىڭ قۇللىرى بىزنىڭ ئاتىمىز بولغان بۇ ئاق چاچنى دەرد-ئەلەم ئىچىدە تەھتىساراغا چۈشۈرۈۋەتكەن بولىمىز. ");
INSERT INTO uigara_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","چۈنكى مەنكى كەمىنىلىرى ئاتامغا بۇ يىگىت ئۈچۈن كېپىل بولۇپ: «ئەگەر مەن ئۇنى قېشىڭغا قايتۇرۇپ كەلمىسەم پۈتكۈل ئۆمرۈمدە ئاتامنىڭ ئالدىدا گۇناھكار بولاي» دېگەنىدىم. ");
INSERT INTO uigara_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","شۇڭا ھازىر ئۆتۈنۈپ قالاي، مەنكى كەمىنىلىرى ئۇ يىگىتنىڭ ئورنىدا خوجامنىڭ قېشىدا قۇل بولۇپ تۇرسام، ئۇ يىگىت قېرىنداشلىرى بىلەن بىللە قايتىپ كەتسە! ");
INSERT INTO uigara_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","چۈنكى يىگىت مەن بىلەن بولمىسا، مەن قانداقمۇ ئاتامنىڭ قېشىغا بارالايمەن؟ ئاتامغا شۇنداق ئازاب-ئوقۇبەتنىڭ چۈشۈشىنى كۆزۈم كۆرگۈچى بولمىسۇن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_1‏","002_45_1‏","GEN","45","1‏","2","يۈسۈپ ئۆز يېنىدا تۇرغانلارنىڭ ئالدىدا ئۆزىنى تۇتالماي: ــ ھەممە ئادەم ئالدىمدىن چىقىرىۋېتىلسۇن! دەپ ۋارقىرىدى. شۇنىڭ بىلەن يۈسۈپ ئۆزىنى قېرىنداشلىرىغا ئاشكارا قىلغاندا ئۇنىڭ قېشىدا ھېچكىم بولمىدى. ئۇ قاتتىق يىغلاپ كەتتى؛ مىسىرلىقلار ئۇنى ئاڭلىدى، پىرەۋننىڭ ئوردىسىكىلەرمۇ بۇنىڭدىن تېزلا خەۋەر تاپتى. ");
INSERT INTO uigara_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","يۈسۈپ قېرىنداشلىرىغا: ــ مەن يۈسۈپ بولىمەن! ئاتام ھازىر ھاياتمۇ؟! ــ دەپ سورىدى. ئەمما قېرىنداشلىرى ئۇنىڭغا قاراپ ھودۇقۇپ كېتىپ، ھېچ جاۋاب بېرەلمەي قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","لېكىن يۈسۈپ ئۇلارنى: ــ قېنى، ماڭا يېقىن كېلىڭلار، دەپ چاقىرىدى. ئۇلار يېقىن كەلدى، ئۇ يەنە: ــ مەن سىلەرنىڭ ئىنىڭلار، يەنى سىلەر مىسىرغا سېتىۋەتكەن يۈسۈپ بولىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ئەمدى مېنى مۇشۇ يەرگە سېتىۋەتكىنىڭلار ئۈچۈن ئازابلانماڭلار، ئۆزۈڭلارنى ئەيىبكە بۇيرۇماڭلار؛ چۈنكى خۇدا ئادەملەرنىڭ ھاياتىنى ساقلاپ قېلىش ئۈچۈن مېنى سىلەردىن بۇرۇن بۇ يەرگە ئەۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","چۈنكى ھازىر زېمىندىكى ئاچارچىلىققا ئىككى يىل بولدى؛ لېكىن تېخى يەنە بەش يىلغىچە ھېچ تېرىلغۇمۇ بولمايدۇ، ئورمىمۇ بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","شۇنىڭ ئۈچۈن سىلەرگە دۇنيادا بىر قالدىنى ساقلاپ قېلىش ئۈچۈن، ئۇلۇغ بىر نىجاتلىق كۆرسىتىپ، سىلەرنىڭ تىرىك قۇتۇلۇشۇڭلار ئۈچۈن خۇدا مېنى سىلەردىن بۇرۇن بۇ يەرگە ئەۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","شۇنداق بولغانىكەن، مېنى مۇشۇ يەرگە ئەۋەتكۈچى سىلەر ئەمەس، بەلكى خۇدادۇر. ئۇ مېنى پىرەۋنگە ئاتىنىڭ ئورنىدا قىلىپ، ئۇنىڭ پۈتكۈل ئۆيىگە خوجا قىلىپ تىكلەپ، پۈتكۈل زېمىنغا باش ۋەزىر قىلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ئەمدى تېزدىن ئاتامنىڭ قېشىغا بېرىپ، ئۇنىڭغا: ــ سېنىڭ ئوغلۇڭ يۈسۈپ: «خۇدا مېنى پۈتكۈل مىسىرغا خوجا قىلىپ قويدى. سەن ھايال قىلماي، مېنىڭ قېشىمغا كەلگىن؛ ");
INSERT INTO uigara_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","سەن گوشەن يۇرتىدا تۇرىسەن؛ شۇنىڭ بىلەن سەن ئۆزۈڭ، ئوغۇللىرىڭ، نەۋرىلىرىڭ، قويلىرىڭ، كالىلىرىڭ ۋە ھەممە تەئەللۇقاتلىرىڭ بىلەن ماڭا يېقىن تۇرىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ئۆزۈڭ، ئائىلەڭ ۋە ھەممە تەئەللۇقاتىڭنى نامراتلىق بېسىۋالمىسۇن دەپ مەن سېنى شۇ يەردە باقىمەن؛ چۈنكى يەنە بەش يىل ئاچارچىلىق باردۇر»، دېدى، ــ دەڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ــ مانا سىلەرنىڭ كۆزلىرىڭلار ۋە ئىنىم بىنيامىننىڭ كۆزلىرى سىلەرگە گەپ قىلىۋاتقان مېنىڭ ئۆز ئاغزىم ئىكەنلىكىنى كۆرۈۋاتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ئاتامغا مېنىڭ مىسىردىكى بۇ بارلىق شان-شەرىپىم ھەمدە سىلەرنىڭ بارلىق كۆرگىنىڭلار توغرىسىدا ئېيتىپ، ئاتامنى تېزدىن بۇ يەرگە ئېلىپ كېلىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","شۇنىڭ بىلەن ئۇ ئۆزىنى بىنيامىنغا ئېتىپ ئۇنىڭ بوينىغا گىرە سېلىپ يىغلاپ كەتتى؛ بىنيامىنمۇ ئۇنىڭ بوينىغا يۆلىنىپ يىغلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ئاندىن يۈسۈپ بارلىق قېرىندشالىرىنى سۆيۈپ، ئۇلارنى بىر-بىرلەپ قۇچاقلاپ يىغلىدى. ئاندىن قېرىندشالىرى ئۇنىڭ بىلەن پاراڭلاشتى. ");
INSERT INTO uigara_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","يۈسۈپنىڭ قېرىندشالىرى كەلدى، دېگەن خەۋەر پىرەۋننىڭ ئوردىسىغا يەتكۈزۈلدى؛ بۇ پىرەۋن ۋە خىزمەتكارلىرىنىڭ نەزىرىدە قۇتلۇق ئىش بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","پىرەۋن يۈسۈپكە: ــ قېرىنداشلىرىڭغا: ــ «سىلەر ئەمدى مۇنداق قىلىڭلار؛ ئۇلاغلىرىڭلارغا يۈك ئارتىپ، قانائان زېمىنىغا بېرىپ، ");
INSERT INTO uigara_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ئاتاڭلار ۋە جەمەتىڭلارنى ئېلىپ مېنىڭ قېشىمغا كېلىڭلار؛ مەن مىسىر زېمىنىدىن ئەڭ ئېسىل يەرلەرنى سىلەرگە بېرەي؛ سىلەر بۇ زېمىندىن چىققان نازۇ-نېمەتلەردىن يەيسىلەر» ــ دېگىن. ");
INSERT INTO uigara_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ساڭا بولغان ئەمرىم شۇكى، سەن ئۇلارغا: «بالىلىرىڭلار ۋە ئاياللىرىڭلارنى ئېلىش ئۈچۈن مىسىر زېمىنىدىن ھارۋىلارنى ئېلىپ بېرىڭلار. شۇنىڭدەك ئاتاڭلارنىمۇ بۇ يەرگە يەتكۈزۈپ كېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","پۈتكۈل مىسىر زېمىنىدىن ئەڭ ئېسىل جايلار سىلەرنىڭكى بولغاچقا، ئۆز سەرەمجانلىرىڭلارغا كارىڭلار بولمىسۇن» دەپ بۇيرۇغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","شۇنىڭ بىلەن ئىسرائىلنىڭ ئوغۇللىرى شۇنداق قىلدى؛ يۈسۈپ پىرەۋننىڭ بۇيرۇقى بويىچە ئۇلارغا ھارۋىلارنى بېرىپ، يولى ئۈچۈنمۇ ئوزۇق بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ئۇلارنىڭ ھەربىرىگە بىر قۇر كىيىم بەردى؛ لېكىن بىنيامىنغا بولسا ئۇ ئۈچ يۈز كۈمۈش تەڭگە، بەش قۇر كىيىم بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ئۇ ئاتىسىغىمۇ شۇ ھەدىيەلەرنى، يەنى مىسىرنىڭ ئېسىل مەھسۇلاتلىرى ئارتىلغان ئون ھاڭگا ئېشەك ھەمدە ئاشلىق، نان ۋە ئاتىسىغا يول تەييارلىقى ئارتىلغان ئون مادا ئېشەكنى ئەۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ئاندىن ئۇ قېرىنداشلىرىنى يولغا سېلىپ، ئۇلارغا: ــ يولدا جېدەللەشمەڭلار، دەپ جېكىلىدى. ئۇلار يولغا راۋان بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ئۇلار مىسىردىن چىقىپ، قانائان زېمىنىغا ئاتىسى ياقۇپنىڭ قېشىغا بېرىپ، ");
INSERT INTO uigara_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ئۇنىڭغا يۈسۈپ ئۆزلىرىگە ئېيتقان گەپلەرنى يەتكۈزۈپ: «يۈسۈپ تېخى ھايات ئىكەن! ئۇ پۈتكۈل مىسىر زېمىنىغا باش ۋەزىر ئىكەن!» دېدى. ئەمما ئۇ ئۇلارغا ئىشەنمەي، يۈرىكى قېتىپ ھوشىدىن كېتەي دەپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","لېكىن ئۇلار يۈسۈپنىڭ ئۆزلىرىگە ئېيتقان بارلىق سۆزلىرىنى ئۇنىڭغا دېگەندە، شۇنداقلا يۈسۈپنىڭ ئۆزىنى ئېلىپ كېلىشكە ئەۋەتكەن ھارۋىلارنىمۇ كۆرگەندە، ئۇلارنىڭ ئاتىسى ياقۇپنىڭ روھىغا جان كىردى. ");
INSERT INTO uigara_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ئىسرائىل شۇنىڭ بىلەن: ــ ئەمدى ئارمىنىم يوق! ئوغلۇم يۈسۈپ تېخى ھاياتتۇر! مەن ئۆلمەستە بېرىپ ئۇنى كۆرۈۋالاي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","شۇنىڭ بىلەن ئىسرائىل بارلىق تەئەللۇقاتىنى ئېلىپ يولغا چىقىپ، بەئەر-شېباغا كەلدى. ئۇ شۇ يەردە ئاتىسى ئىسھاقنىڭ خۇداسىغا قۇربانلىقلارنى سۇندى. ");
INSERT INTO uigara_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","كېچىسى خۇدا ئالامەت كۆرۈنۈشلەردە ئىسرائىلغا: ــ ياقۇپ، ياقۇپ! دېۋىدى، ئۇ جاۋاب بېرىپ: ــ مانا مەن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ئۇ: ــ ئاتاڭنىڭ تەڭرىسى بولغان خۇدا مەندۇرمەن. سەن مىسىرغا بېرىشتىن قورقمىغىن، چۈنكى مەن سېنى شۇ يەردە ئۇلۇغ بىر قوۋم قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","مەن سېنىڭ بىلەن مىسىرغا بىللە بارىمەن ۋە مەن ئۆزۈم جەزمەن يەنە سېنى شۇ يەردىن ياندۇرۇپ كېلىمەن. يۈسۈپ ئۆز قولى بىلەن سېنىڭ كۆزۈڭنى يۇمدۇرىدۇ، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ئاندىن ياقۇپ بەئەر-شېبادىن يولغا چىقتى؛ ئىسرائىلنىڭ ئوغۇللىرى ئاتىسى ياقۇپ ۋە ئۇلارنىڭ بالا-چاقىلىرىنى پىرەۋن ئۇنى ئېپكېلىش ئۈچۈن ئەۋەتكەن ھارۋىلارغا ئولتۇرغۇزۇپ، ");
INSERT INTO uigara_vpl VALUES ("GN46_6‏","002_46_6‏","GEN","46","6‏","7","چارپايلىرى بىلەن قانائان زېمىنىدا تاپقان تەئەللۇقاتلىرىنى ئېلىپ ماڭدى. بۇ تەرىقىدە ياقۇپ بىلەن بارلىق ئەۋلادلىرى مىسىرغا كەلدى؛ ئوغۇللىرىنى، ئوغۇل نەۋرىلىرىنى، قىزلىرىنى، قىز نەۋرىلىرىنى يىغىپ، نەسىللىرىنىڭ ھەممىسىنى ئۆزى بىلەن بىللە ئېلىپ مىسىرغا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ئىسرائىلنىڭ ئوغۇللىرى، يەنى ياقۇپنىڭ مىسىرغا كەلگەن ئەۋلادلىرى تۆۋەندىكىچە: ــ ياقۇپنىڭ تۇنجى ئوغلى رۇبەن؛ ");
INSERT INTO uigara_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","رۇبەننىڭ ئوغۇللىرى ھانوخ، پاللۇ، ھەزرون بىلەن كارمى. ");
INSERT INTO uigara_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","شىمېئوننىڭ ئوغۇللىرى: ــ يەمۇئەل، يامىن، ئوھاد، ياقىن، زوھار ۋە قانائانىي ئايالدىن بولغان سائۇل.    ");
INSERT INTO uigara_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","لاۋىينىڭ ئوغۇللىرى: ــ گەرشون، كوھات ۋە مەرارى. ");
INSERT INTO uigara_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","يەھۇدانىڭ ئوغۇللىرى: ــ ئەر، ئونان، شەلاھ، پەرەز ۋە زەراھ. ئەمما ئەر ۋە ئونان قانائاننىڭ زېمىنىدا ئۆلۈپ كەتكەنىدى. پەرەزنىڭ ئوغۇللىرى ھەزرون بىلەن ھامۇللار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ئىسساكارنىڭ ئوغۇللىرى: ــ تولا، پۇئاھ، يوب ۋە شىمرون. ");
INSERT INTO uigara_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","زەبۇلۇننىڭ ئوغۇللىرى: ــ سەرەد، ئېلون ۋە جاھلىيەل. ");
INSERT INTO uigara_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","بۇلار لېياھنىڭ ياقۇپقا پادان-ئارامدا تۇغۇپ بەرگەن ئوغۇل-ئەۋلادلىرى ئىدى؛ ئۇ يەنە قىزى دىناھنى تۇغۇپ بەردى. بۇنىڭ بۇ ئوغۇل-قىز پەرزەنتلىرى جەمئىي بولۇپ ئوتتۇز ئۈچ جان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","گادنىڭ ئوغۇللىرى: ــ زىفىئون، ھاگگى، شۇنى، ئەزبون، ئېرى، ئارودى ۋە ئارئەلى. ");
INSERT INTO uigara_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ئاشىرنىڭ ئوغۇللىرى: ــ يىمناھ، يىشۋاھ، يىشۋى ۋە بېرىياھ. ئۇلارنىڭ سىڭلىسى سېراھ ئىدى؛ بېرىياھنىڭ ئوغۇللىرى ھەبەر ۋە مالكىئەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","بۇلار بولسا لابان قىزى لېياھقا دېدەك بولۇشقا بەرگەن زىلپاھنىڭ ياقۇپقا تۇغۇپ بەرگەن ئوغۇللىرى بولۇپ، جەمئىي ئون ئالتە جان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ياقۇپنىڭ ئايالى راھىلەنىڭ ئوغۇللىرى يۈسۈپ ۋە بىنيامىن. ");
INSERT INTO uigara_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","يۈسۈپكە مىسىر زېمىنىدا تۆرەلگەن ئوغۇللىرى ماناسسەھ ۋە ئەفرائىم؛ بۇلارنى ئوندىكى كاھىن پوتىفىراھنىڭ قىزى ئاسىنات ئۇنىڭغا تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","بىنيامىننىڭ ئوغۇللىرى: ــ بېلاھ، بەكەر، ئاشبەل، گېرا، نائامان، ئېھى، روش، مۇپپىم، ھۇپپىم ۋە ئارد.    ");
INSERT INTO uigara_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","بۇلار راھىلەنىڭ ياقۇپقا تۇغۇپ بەرگەن ئوغۇل-ئەۋلادلىرى بولۇپ، جەمئىي ئون تۆت جان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","داننىڭ ئوغلى: ــ ھۇشىم. ");
INSERT INTO uigara_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","نافتالىنىڭ ئوغۇللىرى: ــ ياھزىئەل، گۇنى، يەزەر ۋە شىللەم. ");
INSERT INTO uigara_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","بۇلار لابان قىزى راھىلەگە دېدەك بولۇشقا بەرگەن بىلھاھنىڭ ياقۇپقا تۇغۇپ بەرگەن ئوغۇل-ئەۋلادلىرى بولۇپ، جەمئىي يەتتە جان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ياقۇپنىڭ كېلىنلىرىدىن باشقا، ياقۇپنىڭ پۇشتىدىن بولغان، ئۇنىڭ بىلەن بىرگە مىسىرغا كەلگەنلەر جەمئىي ئاتمىش ئالتە جان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","يۈسۈپنىڭ مىسىردا تۇغۇلغان ئوغۇللىرى ئىككى ئىدى. ياقۇپنىڭ جەمەتىدىن بولۇپ، مىسىرغا كەلگەنلەر جەمئىي يەتمىش جان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ياقۇپ يۈسۈپتىن كۆرسەتمە ئېلىپ، ئۆزلىرىنى گوشەنگە باشلاپ بېرىشقا يەھۇدانى يۈسۈپنىڭ قېشىغا ئەۋەتتى. شۇنداق قىلىپ ئۇلار گوشەن يۇرتىغا كېلىپ چۈشتى. ");
INSERT INTO uigara_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","يۈسۈپ ئۆزىنىڭ ۋەزىرلىك ھارۋىسىنى قاتقۇزۇپ، ئاتىسى ئىسرائىلنىڭ ئالدىغا گوشەنگە چىقتى. ئۇ ئۆزىنى ئۇنىڭ ئالدىغا ھازىر قىلىپ ئاتىسىغا ئۆزىنى ئېتىپ بوينىغا گىرە سېلىپ قۇچاقلاپ، ئۇزۇندىن ئۇزۇن يىغلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ئىسرائىل يۈسۈپكە: مەن سېنىڭ يۈزۈڭنى كۆرۈپ، تىرىك ئىكەنلىكىڭنى بىلدىم؛ ئەمدى ئۆلسەممۇ ئارمىنىم يوق، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ئاندىن يۈسۈپ قېرىنداشلىرى ۋە ئاتىسىنىڭ ئۆيدىكىلىرىگە مۇنداق دېدى: ــ مەن ھازىر چىقىپ پىرەۋنگە خەۋەر بېرىپ: «قانائان زېمىنىدا ئولتۇرغان قېرىنداشلىرىم، شۇنداقلا ئاتامنىڭ ئۆيىدىكىلەر قېشىمغا كەلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","بۇ ئادەملەر پادىچىلار بولۇپ، مال بېقىش بىلەن شۇغۇللىنىپ كەلگەن، قوي-كالىلىرى، شۇنداقلا بارلىق مال-مۈلۈكلىرىنى ئېلىپ كەلدى» دەپ ئېيتاي. ");
INSERT INTO uigara_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","شۇنداق بولىدۇكى، پىرەۋن سىلەرنى چاقىرىدۇ؛ شۇ چاغدا ئۇ سىلەردىن: «نېمە ئوقىتىڭلار بار؟» دەپ سورىسا، ");
INSERT INTO uigara_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","سىلەر جاۋاب بېرىپ: ــ كەمىنىلىرى كىچىكىمىزدىن تارتىپ ئاتا-بوۋىلىرىمىزغا ئوخشاش پادا بېقىپ كەلگەنمىز، ــ دەڭلار. شۇنداق دېسەڭلار گوشەن يۇرتىدا ئولتۇرۇپ قالىسىلەر؛ چۈنكى پادىچىلارنىڭ ھەممىسى مىسىرلىقلار ئارىسىدا كۆزگە ئىلىنمايدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","يۈسۈپ پىرەۋننىڭ قېشىغا كېلىپ: ــ ئاتام بىلەن قېرىنداشلىرىم قوي-كالىلىرى، شۇنداقلا ھەممە مال-مۈلۈكلىرىنى بىللە ئېلىپ قانائان زېمىنىدىن كەلدى. مانا، ئۇلار ھازىر گوشەن يۇرتىغا چۈشتى، دەپ خەۋەر بېرىپ، ");
INSERT INTO uigara_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","قېرىنداشلىرىنىڭ ئىچىدىن بەشەيلەننى ئېلىپ، پىرەۋننىڭ ئالدىغا ھازىر قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","پىرەۋن ئۇنىڭ قېرىنداشلىرىدىن: ــ نېمە ئوقىتىڭلار بار، دەپ سورىۋىدى، ئۇلار پىرەۋنگە جاۋاب بېرىپ: ــ كەمىنىلىرى ئاتا-بوۋىلىرىمىزغا ئوخشاش مال باققۇچىلارمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ئاندىن ئۇلار پىرەۋنگە ئىلتىماس قىلىپ: ــ قانائان زېمىنىدا قاتتىق قەھەتچىلىك بولغاچقا، كەمىنىلىرىنىڭ قويلىرىمىزنى باقىدىغانغا يايلاقمۇ يوق؛ شۇڭا بۇ زېمىندا مۇساپىر بولۇپ تۇرۇشقا كەلدۇق؛ جانابلىرىدىن تەلەپ قىلىمىزكى، كەمىنىلىرىنىڭ گوشەن يۇرتىدا تۇرۇشىغا ئىجازەت بەرگەيلا، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","پىرەۋن يۈسۈپكە: ــ ئاتاڭ ۋە قېرىنداشلىرىڭ قېشىڭغا كەلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","مانا مىسىر زېمىنى سېنىڭ ئالدىڭدا تۇرۇپتۇ؛ ئاتاڭ ۋە قېرىنداشلىرىڭنى زېمىننىڭ ئەڭ ئېسىل يېرىدە ئولتۇرغۇزغىن؛ ئۇلار گوشەن يۇرتىدا ماكان قىلسۇن. شۇنىڭدەك، ئەگەر سەن ئۇلارنىڭ ئىچىدىكى قابىل كىشىلەرنى بىلسەڭ، بۇلارنى مېنىڭ چارپايلىرىمغا نازارەتچى قىلغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","كېيىن، يۈسۈپ ئاتىسى ياقۇپنى ئېلىپ، پىرەۋننىڭ ئالدىغا ھازىر قىلدى؛ ياقۇپ پىرەۋنگە بەخت-بەرىكەت تىلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ئاندىن پىرەۋن ياقۇپتىن: ــ ئۆمرۈڭنىڭ يىل-كۈنلىرى نەچچىگە يەتتى؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ياقۇپ پىرەۋنگە جاۋاب بېرىپ: ــ مۇساپىرلىق سەپىرىمنىڭ كۈنلىرى بىر يۈز ئوتتۇز يىلغا يەتتى؛ ئۆمرۈمنىڭ كۈنلىرى ئاز ھەم جاپا-مۇشەققەتلىك بولۇپ، ئاتا-بوۋىلىرىمنىڭ مۇساپىرلىق ئۆمۈر سەپىرىنىڭ كۈنلىرىگە تېخى يەتمىدى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","شۇنىڭ بىلەن ياقۇپ پىرەۋنگە بەخت-بەرىكەت تىلەپ، ئالدىدىن چىقىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","شۇنىڭ بىلەن يۈسۈپ ئاتىسى بىلەن قېرىنداشلىرىنى مىسىر زېمىنىدا ئولتۇراقلاشتۇرۇپ قويدى؛ پىرەۋننىڭ بۇيرۇغىنىدەك ئۇلارغا زېمىننىڭ ئەڭ ئېسىل يېرىدىن، يەنى رامسەس دېگەن يۇرتتىن تەۋەلىك بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","يۈسۈپ ئاتىسى، قېرىنداشلىرى، شۇنداقلا ئاتىسىنىڭ ھەممە ئۆيدىكىلىرىنى بالا-چاقىلىرىنىڭ سانلىرىغا قاراپ ئاشلىق بىلەن تەمىنلەپ باقتى. ");
INSERT INTO uigara_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ئەمما ئاچارچىلىق قاتتىق ئېغىر بولغاچقا، زېمىننىڭ ھېچ يېرىدە ئوزۇق-تۈلۈك تېپىلمىدى؛ مىسىر زېمىنى بىلەن قانائان زېمىنى ئاچارچىلىقتىن خاراپلىشىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","يۈسۈپ ئاشلىق سېتىپ مىسىر زېمىنى بىلەن قانائان زېمىنىدىكى بارلىق پۇلنى يىغىۋالدى. ئاندىن يۈسۈپ بۇ پۇلنى پىرەۋننىڭ ئوردىسىغا يەتكۈزۈپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ئەمما مىسىر زېمىنى بىلەن قانائان زېمىنىدىكى پۇل تۈگەپ كەتكەندە مىسىرلىقلارنىڭ ھەممىسى يۈسۈپنىڭ ئالدىغا كېلىپ: ــ بىزگە نان بەرگەيلا! پۇل تۈگەپ كەتكىنى ئۈچۈن سىلىنىڭ ئالدىلىرىدا ئۆلىمىزمۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","يۈسۈپ جاۋابەن: ــ پۇلۇڭلار قالمىغان بولسا، چارپايلىرىڭلارنى ئېلىپ كېلىپ بەرسەڭلار، مەن ماللىرىڭلارىغا ئوزۇق-تۈلۈك تېگىشىپ بېرىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","بۇنىڭ بىلەن ئۇلار چارپايلىرىنى يۈسۈپنىڭ قېشىغا ئېلىپ كەلگىلى تۇردى؛ يۈسۈپ ئۇلارنىڭ ئاتلىرى، قوي پادىلىرى، كالا پادىلىرى ۋە ئېشەكلىرىنىڭ ئورنىغا ئوزۇق-تۈلۈك بەردى؛ شۇ يىلى ماللىرىنىڭ ئورنىغا ئۇلارغا ئوزۇق-تۈلۈك بېرىپ باقتى. ");
INSERT INTO uigara_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ئۇ يىل ئاياغلىشىپ، ئۇلار ئىككىنچى يىلى ئۇنىڭ قېشىغا كېلىپ ئۇنىڭغا: ــ بىز خوجىمىزدىن ھېچنېمىنى يوشۇرمايمىز؛ پۇلىمىز تۈگىدى، چارپاي مال پادىلىرىمىز بولسا خوجىمىزنىڭ ئىلكىدە، خوجىمىزنىڭ ئالدىدا تەنلىرىمىز بىلەن يېرىمىزدىن باشقا ھېچنەرسە قالمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","نېمىشقا كۆز ئالدىلىرىدا بىز ھەم يېرىمىزمۇ ئۆلۈپ كەتسۇن؟ ئەمدى سىلى ئۆزىمىز ۋە يېرىمىزنى ئوزۇق-تۈلۈككە تېگىشىپ ئېلىۋالغايلا؛ ئۆزىمىز ۋە يېرىمىز پىرەۋننىڭ بولۇپ، ئۇنىڭغا قۇل بولايلى. بىز ئۆلۈپ كەتمەي، تىرىك تۇرۇشىمىز، يېرىمىزمۇ ۋەيران بولماسلىقى ئۈچۈن بىزگە ئۇرۇق-تۈلۈك بەرگەيلا، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","بۇ تەرىقىدە يۈسۈپ مىسىرنىڭ پۈتكۈل تېرىلغۇ يېرىنى پىرەۋن ئۈچۈن سېتىۋالدى؛ چۈنكى ئاچارچىلىق قاتتىق بولغاچقا، مىسىرلىقلارنىڭ ھەربىرى ئۆز ئېتىزىنى سېتىپ بەردى. شۇنىڭ بىلەن يەر-زېمىن پىرەۋننىڭ بولۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","يۈسۈپ خەلقنى مىسىرنىڭ بۇ چېتىدىن يەنە بىر چېتىگىچە ھەرقايسى شەھەرلەرگە كۆچۈردى. ");
INSERT INTO uigara_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","پەقەت كاھىنلارنىڭ يېرىنى ئۇ ئالمىدى؛ چۈنكى كاھىنلارغا پىرەۋن تەرىپىدىن ئالاھىدە تەمىنات بېرىلگەچكە، ئۇلار پىرەۋن تەرىپىدىن تەمىنلەنگەن ئۈلۈشىنى يەپ، ئۆز يەرلىرىنى ساتمىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","يۈسۈپ خەلققە: ــ مانا، مەن بۈگۈن ئۆزۈڭلار بىلەن يەرلىرىڭلارنى پىرەۋن ئۈچۈن سېتىۋالدىم. مانا سىلەرگە ئۇرۇق! ئەمدى يەر تېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ئەمدى شۇنداق قىلىسىلەركى، چىققان ھوسۇلدىن بەشتىن بىرىنى پىرەۋنگە بېرىپ، قالغان تۆت قىسمىنى ئۆزۈڭلارغا ئېلىپ قېلىڭلار؛ ئۇ ئۇرۇقلۇق ھەمدە ئۆزۈڭلارغا، جۈملىدىن ئۆيۈڭدىكىلەرگە ۋە كىچىك بالىلىرىڭلارغا ئوزۇق بولسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ئۇلار جاۋابەن: ــ سىلى جېنىمىزنى قۇتقۇزدىلا. خوجىمىزنىڭ نەزىرىدە ئىلتىپات تاپقان بولساقلا، پىرەۋننىڭ قۇللىرى بولۇپ تۇرايلى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","شۇنىڭ بىلەن يۈسۈپ: ــ «ھوسۇلنىڭ بەشتىن بىرى پىرەۋنگە بېرىلسۇن» دەپ بۇ ئىشنى بۈگۈنگە قەدەر مىسىر زېمىنى ئۈچۈن قانۇن-بەلگىلىمە قىلدى. پەقەت كاھىنلارنىڭ يېرىلا بۇنىڭ سىرتىدا بولۇپ، پىرەۋنگە تەۋە بولمىدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ئىسرائىللار مىسىر زېمىنىدا، گوشەن ئۆلكىسىدە ئولتۇراقلاشتى؛ ئۇلار شۇ جايدا يەر-زېمىنلىك بولۇپ، ئاۋۇپ، تولىمۇ كۆپەيدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ياقۇپ مىسىر زېمىنىدا ئون يەتتە يىل ئۆمۈر كۆردى؛ بۇنىڭ بىلەن ياقۇپنىڭ ئۆمۈر كۈنلىرى بىر يۈز قىرىق يەتتە يىلغا يەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ئىسرائىلنىڭ كۈنلىرى سەكراتقا يېقىنلاشقاندا، ئوغلى يۈسۈپنى چاقىرتىپ، ئۇنىڭغا: ــ ئەگەر نەزىرىڭدە ئىلتىپات تاپقان بولسام، قولۇڭنى يوتامنىڭ ئاستىغا قويۇپ، ماڭا شاپائەت ۋە ساداقەتلىكنى كۆرسىتىپ، مېنى مىسىردا دەپنە قىلما؛ ");
INSERT INTO uigara_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بەلكى مەن ئاتا-بوۋىلىرىم بىلەن ياتىدىغان ۋاقتىمدا مېنى مىسىردىن ئېلىپ كېتىپ، ئۇلارنىڭ گۆرىستانىغا دەپنە قىلغىن، دېدى. ئۇ جاۋاب بېرىپ: ــ مەن ئېيتقىنىڭدەك قىلاي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ياقۇپ ئۇنىڭغا: ــ ماڭا قەسەم قىلىپ بەرگىن، ــ دېدى. ئۇ ئۇنىڭغا قەسەم قىلىپ بەردى؛ ئاندىن ئىسرائىل كارۋاتنىڭ باش تەرىپىدە سەجدە قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","بۇ ئىشلاردىن كېيىن بىرسى يۈسۈپكە: ــ مانا ئاتاڭ كېسەل بولۇپ قاپتۇ، دەپ خەۋەر بەردى. ئۇ ئىككى ئوغلى ماناسسەھ بىلەن ئەفرائىمنى بىللە ئېلىپ باردى. ");
INSERT INTO uigara_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","بىرسى ياقۇپقا: ــ مانا ئوغلۇڭ يۈسۈپ قېشىڭغا كېلىۋاتىدۇ، دەپ خەۋەر بېرىۋىدى، ئىسرائىل كۈچەپ قوپۇپ كارىۋاتتا ئولتۇردى. ");
INSERT INTO uigara_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ياقۇپ يۈسۈپكە: ــ ھەممىگە قادىر تەڭرى ماڭا قانائان زېمىنىدىكى لۇز دېگەن جايدا ئايان بولۇپ، مېنى بەرىكەتلەپ ");
INSERT INTO uigara_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ماڭا: مانا، مەن سېنىڭ نەسلىڭنى كۆپەيتىپ، سېنى ئىنتايىن زور ئاۋۇتىمەن، سەندىن بىر تۈركۈم خەلق چىقىرىمەن؛ بۇ زېمىننى سەندىن كېيىنكى نەسلىڭگە ئەبەدىي مىراس قىلىپ بېرىمەن، دەپ ئېيتقانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ئەمدى مەن مىسىرغا كېلىشتىن ئىلگىرى ساڭا مىسىر زېمىنىدا تۇغۇلغان ئىككى ئوغلۇڭ مېنىڭ ھېسابلىنىدۇ؛ ئەفرائىم بىلەن ماناسسەھ بولسا، خۇددى رۇبەن بىلەن شىمېئونغا ئوخشاش، ھەر ئىككىسى مېنىڭ ئوغۇللىرىم بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ئۇلاردىن كېيىن تاپقان بالىلىرىڭ ئۆزۈڭنىڭ بولىدۇ؛ ئۇلار كەلگۈسىدە مىراسقا ئېرىشكەندە ئاكىلىرىنىڭ نامى ئاستىدا بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ماڭا كەلسەك، پاداندىن كېلىۋاتقىنىمدا راھىلە قانائان زېمىنىدا يول ئۈستىدە ئەفراتقا ئاز قالغاندا مېنى تاشلاپ ئۆلۈپ كەتتى. مەن ئۇنى شۇ يەردە، يەنى ئەفراتقا (يەنى بەيت-لەھەمگە) بارىدىغان يولدا دەپنە قىلدىم، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ئاندىن ئىسرائىل يۈسۈپنىڭ ئوغۇللىرىغا قاراپ: ــ بۇلار كىمدۇر، ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","يۈسۈپ ئاتىسىغا جاۋابەن: ــ بۇلار بولسا خۇدا ماڭا بۇ يەردە بەرگەن ئوغۇللىرىمدۇر، ــ دېدى. ئۇ: ــ ئۇلارنى ئالدىمغا يېقىن كەلتۈرگىن، مەن ئۇلارغا بەخت-بەرىكەت تىلەي، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ئەمدى ئىسرائىلنىڭ كۆزلىرى قېرىلىقىدىن غۇۋالىشىپ ياخشى كۆرەلمەيتتى. شۇڭا يۈسۈپ ئۇلارنى ئۇنىڭ ئالدىغا يېقىنراق كەلتۈردى؛ ئۇ ئۇلارنى سۆيۈپ قۇچاقلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ئاندىن ئىسرائىل يۈسۈپكە: ــ مەن سېنىڭ يۈزۈڭنى كۆرەلەيمەن دەپ ھېچ ئويلىمىغانىدىم؛ لېكىن خۇدا مېنى سېنىڭ بالىلىرىڭنىمۇ كۆرۈشكە نېسىپ قىلدى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","يۈسۈپ بالىلارنى ياقۇپنىڭ تىزلىرىنىڭ ئارىلىقىدىن ئېلىپ، يۈزىنى يەرگە تەگكۈزۈپ تەزىم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ئاندىن يۈسۈپ بۇ ئىككىيلەننى ئىسرائىلنىڭ ئالدىغا يېقىن ئېلىپ كېلىپ، ئەفرائىمنى ئوڭ قولى بىلەن تۇتۇپ ئىسرائىلنىڭ سول قولىغا ئۇدۇللاپ تۇرغۇزدى؛ ماناسسەھنى سول قولى بىلەن تۇتۇپ ئىسرائىلنىڭ ئوڭ قولىغا ئۇدۇللاپ تۇرغۇزدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","لېكىن ئىسرائىل ئوڭ قولىنى ئۇزىتىپ، كەنجى بالىسى ئەفرائىمنىڭ بېشىغا قويدى، سول قولىنى ماناسسەھنىڭ بېشىغا قويدى. ماناسسەھ تۇنجىسى بولسىمۇ، ئۇ ئىككى قولىنى قايچىلاپ تۇتۇپ شۇنداق قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ئۇ يۈسۈپكە بەخت-بەرىكەت تىلەپ: ــ ئاتىلىرىم ئىبراھىم بىلەن ئىسھاق خۇدا دەپ بىلىپ يۈزى ئالدىدا ماڭغان، مېنى پۈتكۈل ئۆمرۈمدە بۇ كۈنگىچە پادىچىدەك يېتەكلەپ بېقىپ كەلگەن خۇدا، ");
INSERT INTO uigara_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ماڭا ھەمجەمەت بولۇپ مېنى ھەممە بالا-قازادىن قۇتقۇزغان پەرىشتە بۇ ئىككى ئوغۇلنى بەرىكەتلىسۇن؛ ئۇلار مېنىڭ ئىسمىم ۋە ئاتىلىرىم بولغان ئىبراھىم ۋە ئىسھاقنىڭ ئىسىملىرى بىلەن ئاتىلىپ، يەر يۈزىدە كۆپ ئاۋۇغاي! ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","يۈسۈپ ئاتىسىنىڭ ئوڭ قولىنى ئەفرائىمنىڭ بېشىغا قويغىنىنى كۆرۈپ كۆڭلىدە خاپا بولدى؛ شۇڭا ئۇ ئاتىسىنىڭ قولىنى تۇتۇپ، ئەفرائىمنىڭ بېشىدىن ئېلىپ ماناسسەھنىڭ بېشىغا يۆتكىمەكچى بولۇپ، ");
INSERT INTO uigara_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ئاتىسىغا: ــ ئەي ئاتا، بۇنداق قىلمىغىن؛ چۈنكى مانا، تۇنجىسى بۇدۇر؛ ئوڭ قولۇڭنى ئۇنىڭ بېشىغا قويغىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","لېكىن ئاتىسى رەت قىلىپ: ــ بىلىمەن، ئى ئوغلۇم، بىلىمەن؛ ئۇنىڭدىنمۇ بىر قوۋم چىقىپ، ئۆزىمۇ ئۇلۇغ بولىدۇ، ئەمما دەرھەقىقەت ئۇنىڭ ئىنىسى ئۇنىڭدىن تېخىمۇ ئۇلۇغ بولىدۇ؛ ئۇنىڭ نەسلىدىن ناھايىتى كۆپ قوۋملار پەيدا بولىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","شۇنىڭ بىلەن شۇ كۈنى ئۇ بۇ ئىككىسىنى بەرىكەتلەپ: ــ كەلگۈسىدە ئىسرائىللار بەخت-بەرىكەت تىلىگەندە: «خۇدا سېنى ئەفرائىم بىلەن ماناسسەھدەك ئۇلۇغ قىلسۇن!» دەيدىغان بولىدۇ، دېدى. بۇ تەرىقىدە ئۇ ئەفرائىمنى ماناسسەھتىن ئۈستۈن قويدى. ");
INSERT INTO uigara_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ئاندىن ئىسرائىل يۈسۈپكە يەنە: ــ مانا، مەن ئۆلىمەن؛ لېكىن خۇدا سىلەر بىلەن بىللە بولۇپ، سىلەرنى ئاتا-بوۋىلىرىڭلارنىڭ زېمىنىغا قايتۇرۇپ بارىدۇ. ");
INSERT INTO uigara_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","مەن ساڭا قېرىنداشلىرىڭنىڭكىدىن بىر ئۈلۈش يەرنى ئارتۇق بەردىم؛ شۇ يەرنى ئۆزۈم قىلىچ ۋە ئوقيايىم بىلەن ئامورىيلارنىڭ قولىدىن تارتىۋالغانىدىم.    ");
INSERT INTO uigara_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ئاندىن ياقۇپ ئوغۇللىرىنى چاقىرىپ ئۇلارغا مۇنداق دېدى: ــ ھەممىڭلار جەم بولۇڭلار، مەن سىلەرگە كېيىنكى كۈنلەردە سىلەر يولۇقىدىغان ئىشلارنى ئېيتىپ بېرەي: ــ ");
INSERT INTO uigara_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","يىغىلىپ كېلىپ ئاڭلاڭلار، ئى ياقۇپنىڭ ئوغۇللىرى؛ ئاتاڭلار ئىسرائىلغا قۇلاق سېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ئەي رۇبەن، سەن مېنىڭ تۇنجى ئوغلۇمسەن، كۈچ-قۇدرىتىمسەن، كۈچۈم بار ۋاقتىمنىڭ تۇنجى مېۋىسىدۇرسەن، سالاپەت ۋە قۇدرەتتە ئالدى ئىدىڭ، ");
INSERT INTO uigara_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","لېكىن قايناپ تېشىپ چۈشكەن سۇدەك، ئەمدى ئالدى بولالماسسەن؛ سەن ئاتاڭنىڭ كۆرپىسىگە چىقتىڭ، شۇنىڭ بىلەن سەن ئۇنى بۇلغىدىڭ! ئۇ مېنىڭ كۆرپەمنىڭ ئۈستىگە چىقتى!    ");
INSERT INTO uigara_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","شىمېئون بىلەن لاۋىي قېرىنداشلاردۇر؛ ئۇلارنىڭ قىلىچلىرى زوراۋانلىقنىڭ قوراللىرىدۇر! ");
INSERT INTO uigara_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ئاھ جېنىم، ئۇلارنىڭ مەسلىھىتىگە كىرمىگىن! ئى ئىززىتىم، ئۇلارنىڭ جامائىتى بىلەن چېتىلىپ قالمىغاي! چۈنكى ئۇلار ئاچچىقىدا ئادەملەرنى ئۆلتۈرۈپ، ئۆز بېشىمچىلىق قىلىپ بۇقىلارنىڭ پېيىنى كەستى. ");
INSERT INTO uigara_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ئۇلارنىڭ ئاچچىقى ئەشەددىي بولغاچقا لەنەتكە قالسۇن! غەزىپىمۇ رەھىمسىز بولغاچقا لەنەتكە قالسۇن! مەن ئۇلارنى ياقۇپنىڭ ئىچىدە تارقىتىۋېتىمەن، ئىسرائىلنىڭ ئىچىدە ئۇلارنى چېچىۋېتىمەن.    ");
INSERT INTO uigara_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ئەي يەھۇدا! سېنى بولسا قېرىنداشلىرىڭ تەرىپلەر، قولۇڭ دۈشمەنلىرىڭنىڭ گەجگىسىنى باسار. ئاتاڭنىڭ ئوغۇللىرى ساڭا باش ئۇرار، ");
INSERT INTO uigara_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","يەھۇدا ياش بىر شىردۇر؛ ئەي ئوغلۇم، سەن ئوۋنى تۇتۇپلا چىقتىڭ؛ ئۇ شىردەك ئوۋنىڭ يېنىدا چۆكۈپ سوزۇلۇپ ياتسا، ياكى چىشى شىردەك يېتىۋالسا، كىممۇ ئۇنى قوزغاشقا پېتىنار؟    ");
INSERT INTO uigara_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","شاھانە ھاسا يەھۇدادىن كېتىپ قالمايدۇ، يەھۇدانىڭ پۇشتىدىن قانۇن چىقارغۇچى ئۆكسۈمەيدۇ، تاكى شۇ ھوقۇق ئىگىسى كەلگۈچە كۈتىدۇ؛ كەلگەندە، جاھان خەلقلىرى ئۇنىڭغا ئىتائەت قىلىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ئۇ تەخىيىنى ئۈزۈم تېلىغا، ئېشەك بالىسىنى سورتلۇق ئۈزۈم تېلىغا باغلاپ قويار. ئۇ لىباسىنى شارابتا يۇيۇپ، تونىنى ئۈزۈم شەربىتىدە يۇيار. ");
INSERT INTO uigara_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ئۇنىڭ كۆزلىرى شارابتىن قىزىرىپ كېتەر، چىشلىرى سۈت ئىچكىنىدىن ئاپئاق تۇرار. ");
INSERT INTO uigara_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","زەبۇلۇن دېڭىز بويىنى ماكان قىلار، ماكانى كېمىلەرنىڭ پاناھگاھى بولار، يەر-زېمىنى زىدونغىچە يېتىپ بارار. ");
INSERT INTO uigara_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ئىسساكار بەستلىك بەردەم بىر ئېشەكتۇر، ئۇ ئىككى قوتان ئارىسىدا ياتقاندۇر؛ ");
INSERT INTO uigara_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ئۇ ئارامگاھنىڭ ياخشى ئىكەنلىكىگە قاراپ، زېمىننىڭ ئېسىللىقىنى كۆرۈپ، يۈك كۆتۈرۈشكە مۈرىسىنى ئېگىپ، ئالۋانغا ئىشلەيدىغان قۇل بولۇپ قالار. ");
INSERT INTO uigara_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","دان ئىسرائىل قەبىلىلىرىدىن بىرى بولار، ئۆز خەلقىگە ھۆكۈم چىقىرار. ");
INSERT INTO uigara_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","دان يول ئۈستىدىكى يىلان، چىغىر يول ئۈستىدە تۇرغان زەھەرلىك بىر يىلاندۇر. ئۇ ئاتنىڭ تۇيىقىنى چېقىپ، ئات مىنگۈچىنى ئارقىغا موللاق ئاتقۇزار. ");
INSERT INTO uigara_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ئى پەرۋەردىگار، نىجاتىڭغا تەلمۈرۈپ كۈتۈپ كەلدىم! ");
INSERT INTO uigara_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","گادقا بولسا، قاراقچىلار قوشۇنى ھۇجۇم قىلار؛ لېكىن ئۇ تاپىنىنى بېسىپ زەربە بېرەر. ");
INSERT INTO uigara_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ئاشىرنىڭ تامىقىدا زەيتۇن مېيى مول بولار، ئۇ شاھلار ئۈچۈن نازۇ-نېمەتلەرنى تەمىنلەر. ");
INSERT INTO uigara_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نافتالىدىن چىرايلىق گەپلەر چىقار، ئۇ ئەركىن قويۇۋېتىلگەن مارالدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","يۈسۈپ مېۋىلىك دەرەخنىڭ شېخىدۇر، بۇلاقنىڭ يېنىدىكى كۆپ مېۋىلىك شاختەكتۇر؛ ئۇنىڭ شاخچىلىرى تامدىن ھالقىپ كەتكەندۇر.    ");
INSERT INTO uigara_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","يا ئاتقۇچىلار ئۇنىڭغا ئازار قىلىپ، ئۇنىڭغا ئوق ئاتتى، ئۇنىڭغا نەپرەتلەندى. ");
INSERT INTO uigara_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ھالبۇكى، ئۇنىڭ ئوقيايى مەزمۇت تۇرار، قول-بىلەكلىرى ئەپلىك تۇرغۇزۇلار، شۇ كۈچ ياقۇپتىكى قۇدرەت ئىگىسىنىڭ قوللىرىدىندۇر ــ (ئىسرائىلنىڭ قورام تېشى، يەنى ئۇنىڭ پادىچىسى ئۇنىڭدىن چىقار!) ");
INSERT INTO uigara_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ئاشۇ كۈچ ئاتاڭنىڭ تەڭرىسىدىندۇر ــ (ئۇ ساڭا مەدەت بېرەر!) يەنى ھەممىگە قادىردىندۇر ــ ئۇ سېنى بەرىكەتلەر! يۇقىرىدا ئاسماننىڭ بەرىكەتلىرى بىلەن، تۆۋەندە ياتقان چوڭقۇر سۇلارنىڭ بەرىكەتلىرى بىلەن، ئەمچەك بىلەن بالىياتقۇنىڭ بەرىكىتى بىلەن سېنى بەرىكەتلەر! ");
INSERT INTO uigara_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","سېنىڭ ئاتاڭنىڭ تىلىگەن بەرىكەتلىرى ئاتا-بوۋىلىرىمنىڭ تىلىگەن بەرىكەتلىرىدىن زىيادە بولدى، ئۇلار مەڭگۈلۈك تاغ-ئېدىرلارنىڭ چەتلىرىگىچە يېتەر، ئۇلار يۈسۈپنىڭ بېشىغا چۈشەر، يەنى ئۆز قېرىنداشلىرىدىن ئايرىم تۇرغۇچىنىڭ چوققىسىغا تېگەر.    ");
INSERT INTO uigara_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","بىنيامىن يىرتقۇچ بۆرىدەكتۇر؛ ئەتىگەندە ئۇ ئوۋنى يەر، كەچقۇرۇن ئۇ ئولجىسىنى تەقسىم قىلار» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","بۇلارنىڭ ھەممىسى ئىسرائىلنىڭ ئون ئىككى قەبىلىسى بولۇپ، مەزكۇر سۆزلەر بولسا ئاتىسىنىڭ ئۇلارغا تىلىگەن بەخت-بەرىكەت سۆزلىرىدۇر. ئۇ شۇنىڭ بىلەن ئۇلارنىڭ ھەربىرىگە ماس كېلىدىغان بىر بەرىكەت بىلەن ئۇلارغا بەخت-بەرىكەت تىلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ئاندىن ياقۇپ ئۇلارغا مۇنداق تاپىلىدى: ــ «مەن ئەمدى ئۆز قوۋمىمنىڭ قېشىغا قوشۇلىمەن. سىلەر مېنى ئاتا-بوۋىلىرىمنىڭ يېنىدا، ھىتتىيلاردىن بولغان ئەفروننىڭ ئېتىزلىقىدىكى غارغا دەپنە قىلىڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ئۇ غار بولسا قانائان زېمىنىدا مامرەنىڭ ئۇدۇلىدا، ماكپېلاھنىڭ ئېتىزلىقىدا. غارنى ئىبراھىم گۆرىستان بولسۇن دەپ شۇ ئېتىزلىق بىلەن قوشۇپ ھىتتىي ئەفروندىن سېتىۋالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","شۇ يەردە ئىبراھىم ئايالى ساراھ بىلەن دەپنە قىلىنغان؛ شۇ يەردە ئىسھاق ئايالى رىۋكاھ بىلەنمۇ دەپنە قىلىنغان؛ شۇ يەردە مەنمۇ لېياھنى دەپنە قىلدىم. ");
INSERT INTO uigara_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","بۇ ئېتىزلىق ھەم ئىچىدىكى غار ھەتنىڭ ئەۋلادلىرىدىن سېتىۋېلىنغانىدى». ");
INSERT INTO uigara_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ياقۇپ ئوغۇللىرىغا بۇ ۋەسىيەتنى تاپىلاپ بولۇپ، پۇتلىرىنى كارىۋاتتا تۈزلەپ، نەپەس توختاپ ئۆز قوۋمىغا قوشۇلدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","يۈسۈپ ئاتىسىنىڭ يۈزىگە ئۆزىنى ئېتىپ، ئۇنىڭ ئۈستىدە يىغلاپ، ئۇنى سۆيدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ئاندىن يۈسۈپ ئۆز خىزمىتىدە بولغان تېۋىپلارغا ئاتىسىنى مۇمىيا قىلىشنى بۇيرۇدى؛ شۇنىڭ بىلەن تېۋىپلار ئىسرائىلنى مۇمىيا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","بۇنى قىلىشقا قىرىق كۈن كەتتى، چۈنكى مۇمىيا قىلىشقا شۇنچىلىك كۈن كېتەتتى. مىسىرلىقلار ئۇنىڭغا يەتمىش كۈن ماتەم تۇتتى. ");
INSERT INTO uigara_vpl VALUES ("GN50_4‏","002_50_4‏","GEN","50","4‏","5","ئۇنىڭغا ھازا تۇتۇش كۈنلىرى ئۆتۈپ بولغاندا، يۈسۈپ پىرەۋننىڭ ئوردىسىدىكىلەرگە: ــ مەن نەزىرىڭلاردا ئىلتىپات تاپقان بولسام، پىرەۋننىڭ قۇلاقلىرىغا سۆز قىلىڭلاركى: ــ ئاتام ماڭا قەسەم قىلدۇرۇپ: «مانا مەن ئۆلىمەن؛ سەن مېنى مەن قانائان زېمىنىدا ئۆزۈم ئۈچۈن كولاپ قويغان گۆرگە دەپنە قىلغىن» دېگەنىدى. ئەمدى پىرەۋن ماڭا ئىجازەت بەرگەي، مەن بېرىپ ئاتامنى دەپنە قىلىپ بولۇپ يېنىپ كەلسەم، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","پىرەۋن جاۋابەن: ــ سەن بېرىپ ئۆزۈڭگە ئاتاڭ قەسەم قىلدۇرغاندەك ئۇنى دەپنە قىلغىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","شۇنىڭ بىلەن يۈسۈپ ئاتىسىنى دەپنە قىلغىلى ماڭدى. پىرەۋننىڭ بارلىق خىزمەتكارلىرى، ئوردىنىڭ ئاقساقاللىرى ھەم مىسىر زېمىنىدىكى ئاقساقاللار ئۇنىڭ بىلەن ھەمراھ بولۇپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","يۈسۈپنىڭ ئۆيىدىكى ھەممىسى، قېرىنداشلىرى ۋە ئاتىسىنىڭ ئۆيىدىكىلەرمۇ بىللە باردى؛ ئۇلار پەقەت كىچىك بالىلىرى، قوي-كالا پادىلىرىنى گوشەن يۇرتىدا قويۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ئۇنىڭ بىلەن يەنە جەڭ ھارۋىلىرى ۋە ئاتلىقلارمۇ بىللە باردى؛ شۇنىڭ بىلەن ئۇلار ناھايىتى چوڭ بىر قوشۇن بولدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ئۇلار ئىئوردان دەرياسىنىڭ ئۇ تەرىپىدىكى «ئاتادنىڭ خامىنى»غا يېتىپ كەلگەندە، شۇ يەردە قاتتىق ۋە ھەسرەتلىك يىغا-زار قىلىپ ماتەم تۇتۇپ يىغلاشتى. يۈسۈپ ئاتىسى ئۈچۈن يەتتە كۈن ماتەم تۇتتى. ");
INSERT INTO uigara_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","شۇ يۇرتتا ئولتۇرۇشلۇق قانائانىيلار ئاتادنىڭ خامىنىدا بولغان بۇ ماتەمنى كۆرۈپ: ــ بۇ مىسىرلىقلارنىڭ ئىنتايىن قاتتىق تۇتقان ھازىسى بولدى، دېيىشتى. بۇ سەۋەبتىن ئۇ جاينىڭ نامى «ئابەل-مىزرائىم» دەپ ئاتالدى؛ ئۇ ئىئوردان دەرياسىنىڭ ئۇ تەرىپىدىدۇر. ");
INSERT INTO uigara_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ياقۇپنىڭ ئوغۇللىرى ئۇنىڭ ئۆزلىرىگە تاپىلىغىنىدەك قىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ئۇنىڭ ئوغۇللىرى ئۇنى قانائان زېمىنىغا ئېلىپ بېرىپ، مامرەنىڭ ئۇدۇلىدا، ماكپېلاھنىڭ ئېتىزلىقىنىڭ ئىچىدىكى غاردا دەپنە قىلدى. شۇ غارنى ئىبراھىم قەبرىستانلىق قىلاي دەپ ماكپېلاھنىڭ ئېتىزلىقى بىلەن قوشۇپ ھىتتىي ئەفروندىن سېتىۋالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","يۈسۈپ ئاتىسىنى دەپنە قىلغاندىن كېيىن، ئۆزى، قېرىنداشلىرى، شۇنداقلا ئاتىسىنى دەپنە قىلىشقا ئۇنىڭغا ھەمراھ بولۇپ چىققان ھەممە خەلقلەر مىسىرغا يېنىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","لېكىن يۈسۈپنىڭ قېرىنداشلىرى ئاتىسىنىڭ ئۆلۈپ كەتكىنىنى كۆرگەندە: ــ ئەمدى يۈسۈپ بىزگە دۈشمەن بولۇپ بىزنىڭ ئۇنىڭغا قىلغان بارلىق يامانلىقىمىزنى ئۈستىمىزگە ياندۇرارمىكىن، دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ئۇلار يۈسۈپنىڭ قېشىغا ئادەم ئەۋەتىپ: ــ ئاتىلىرى ئۆلۈشتىن ئىلگىرى بىزگە ۋەسىيەت قىلىپ تاپىلاپ: ــ ");
INSERT INTO uigara_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«سىلەر يۈسۈپكە: ــ ئاكىلىرىڭ ساڭا رەزىللىك قىلغانىدى؛ ئەمدى ئۇلارنىڭ ئاسىيلىقى ھەم گۇناھىنى كەچۈرگىن! ــ دەڭلار» ــ دېگەنىدى. ھازىر سىلىدىن ئۆتۈنۈمىزكى، ئاتىلىرىنىڭ خۇداسىنىڭ بەندىلىرىنىڭ ئاسىيلىقىنى كەچۈرگەيلا! ــ دېدى. يۈسۈپ بۇ گەپلەرنى ئاڭلاپ يىغلىدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ئاندىن ئاكىلىرى كېلىپ ئۇنىڭ ئالدىدا ئۆزلىرىنى يەرگە ئېتىپ: ــ مانا، بىز سىلىنىڭ قۇللىرىدۇرمىز! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","لېكىن يۈسۈپ ئۇلارغا جاۋابەن: ــ قورقماڭلار! مەن خۇدانىڭ ئورنىدا تۇرۇۋاتامدىم؟ ");
INSERT INTO uigara_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","سىلەر دەرۋەقە ماڭا شۇ ئىشنى يامان نىيەت بىلەن قىلدىڭلار؛ لېكىن خۇدا بۈگۈنكى كۈندىكىدەك نۇرغۇنلىغان خەلقنىڭ جېنىنى تىرىك ساقلاپ قېلىش ئۈچۈن شۇ ئىشنى ياخشىلىققا بېكىتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","شۇڭا ئەمدى قورقماڭلار؛ مەن ھەم سىلەرنى ھەم بالا-چاقىلىرىڭلارنى باقىمەن، ــ دېدى ۋە ئۇلارنىڭ كۆڭلىنى خاتىرجەم قىلىپ مېھىرلىك گەپ قىلدى. ");
INSERT INTO uigara_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","يۈسۈپ ئاتىسىنىڭ جەمەتى بىلەن بىللە مىسىردا تۇرۇپ قالدى. يۈسۈپ بىر يۈز ئون يىل ئۆمۈر كۆردى. ");
INSERT INTO uigara_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","بۇ تەرىقىدە يۈسۈپ ئەفرائىمنىڭ ئۈچىنچى ئەۋلادىنى كۆردى؛ ماناسسەھنىڭ ئوغلى ماكىرنىڭ بالىلىرىمۇ ئۇنىڭ تىزلىرى ئۈستىدە تۇغۇلدى.    ");
INSERT INTO uigara_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","يۈسۈپ قېرىنداشلىرىغا: ــ مەن ئۆلۈپ كېتىمەن؛ لېكىن خۇدا چوقۇم سىلەرنى يوقلاپ سىلەرنى بۇ زېمىندىن چىقىرىپ، ئىبراھىم، ئىسھاق ۋە ياقۇپقا بېرىشكە قەسەم قىلىپ ۋەدە قىلغان زېمىنغا يەتكۈزىدۇ، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ئاندىن يۈسۈپ يەنە قېرىنداشلىرىغا قەسەم ئىچكۈزۈپ: «خۇدا سىلەرنى چوقۇم يوقلايدۇ؛ شۇ چاغدا سىلەر مېنىڭ سۆڭەكلىرىمنى ئېلىپ، بۇ يەردىن چىقىپ كېتىشىڭلار كېرەك»، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","يۈسۈپ بىر يۈز ئون ياشقا كىرگەندە ۋاپات تاپتى. ئۇلار ئۇنى مۇمىيا قىلىپ، مىسىردا بىر مېيىت ساندۇقىغا سېلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ۋە تۆۋەندىكىلەر ئىسرائىل بىلەن بىللە مىسىرغا بارغان ئوغۇللىرىنىڭ ئىسىملىرى (ئۇلار ھەرقايسىسى ئۆز بالا-چاقىلىرىنى ئېلىپ، ياقۇپ بىلەن بىللە مىسىرغا بارغانىدى): ــ    ");
INSERT INTO uigara_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رۇبەن، شىمېئون، لاۋىي، يەھۇدا، ");
INSERT INTO uigara_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ئىسساكار، زەبۇلۇن، بىنيامىن، ");
INSERT INTO uigara_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","دان، نافتالى، گاد ۋە ئاشىر. ");
INSERT INTO uigara_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ئەمدى ياقۇپنىڭ پۇشتىدىن بولغانلار جەمئىي بولۇپ يەتمىش ئادەم ئىدى. بۇ ۋاقىتتا يۈسۈپ مىسىردا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","كېيىن يۈسۈپ، ئۇنىڭ بارلىق قېرىنداشلىرى ھەمدە بارلىق زامانداشلىرى ئۆلۈپ تۈگىدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","شۇنداقتىمۇ، ئىسرائىللار كۆپ تۇغۇلۇپ، تېز ئاۋۇپ، ئىنتايىن كۈچەيدى؛ ئۇلار زېمىنغا بىر كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ئۇ ۋاقىتلاردا يۈسۈپنى بىلمەيدىغان يېڭى بىر پادىشاھ مىسىردا تەختكە چىقتى.    ");
INSERT INTO uigara_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ئۇ خەلقىگە: مانا، ئىسرائىللارنىڭ خەلقى بىزدىن زىيادە ئاۋۇپ ھەمدە بىزدىنمۇ كۈچلىنىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ئەمدى بىز ئۇلارغا نىسبەتەن ئاقىلانە ئىش تۇتايلى؛ بولمىسا، ئۇلار تېخىمۇ ئاۋۇپ كېتىدۇ، مۇبادا ئۇرۇش پارتلاپ قالسا، شۇنداق بولىدۇكى، ئۇلار دۈشمەنلىرىمىز تەرەپكە ئۆتۈپ، بىزگە ھۇجۇم قىلىپ، يۇرتتىن چىقىپ كېتىشى مۇمكىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","شۇنىڭ بىلەن ئۇلار ئۇلارنى قىلىۋاتقان ئەمگەكلەردە خارلاش ئۈچۈن ئىش باشلىرىنى تەيىنلەپ نازارەتچىلىككە قويدى. شۇنىڭ بىلەن ئىسرائىللار پىرەۋن ئۈچۈن پىتوم بىلەن رائامسەس دېگەن ماددىي ئەشيا ساقلايدىغان شەھەرلەرنى ياساپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","لېكىن ئۇلارنى قانچە ئەزگەنسېرى، بۇلار شۇنچە كۆپىيىپ ھەممە يەرنى قاپلىدى؛ بۇنىڭ بىلەن مىسىرلىقلار ئىسرائىللارغا ئۆچ بولۇپ كەتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","شۇنىڭ بىلەن مىسىرلىقلار ئىسرائىللارغا زۇلۇم قىلىپ، ئۇلارنى تېخىمۇ قاتتىق ئىشلىتىپ ئېغىر ئىشلارغا سالدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","مىسىرلىقلار ئۇلارنى لايچىلىق، خىش-كېسەك قۇيۇش ۋە ئېتىزلارنىڭ ھەرخىل ئەمگەكلىرىگە سېلىپ، ئىشنىڭ قاتتىقلىقى بىلەن ئۇلارنىڭ تۇرمۇشىغا قاتتىق ئېغىرچىلىق سالدى؛ ئۇلارنى نېمە ئەمگەككە سالمىسۇن، ئىنتايىن جاپالىق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","مىسىر پادىشاھى ئىككى ئىبرانىي تۇغۇت ئانىسىغا سۆز قىلىپ (ئۇلارنىڭ بىرىنىڭ ئىسمى شىفراھ، يەنە بىرىنىڭ ئىسمى پۇئاھ ئىدى): ");
INSERT INTO uigara_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ــ سىلەر قاچانلىكى ئىبرانىي خوتۇنلارنى تۇغدۇرساڭلار، تۇغقاندا ئوبدان قاراڭلار؛ بوۋاق ئوغۇل بولسا، ئۆلتۈرۈۋېتىڭلار؛ قىز بولسا، تىرىك قويۇڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","لېكىن تۇغۇت ئانىلىرى خۇدادىن قورقۇپ، مىسىرنىڭ پادىشاھى ئۇلارغا ئېيتقاندەك قىلماي، بەلكى ئوغۇل بوۋاقلارنى تىرىك قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","شۇڭا مىسىرنىڭ پادىشاھى تۇغۇت ئانىلىرىنى چاقىرتىپ ئۇلاردىن: ــ بۇ نېمە قىلغىنىڭلار؟! ئوغۇل بالىلارنى نېمىشقا تىرىك قويدۇڭلار؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","تۇغۇت ئانىلىرى پىرەۋنگە جاۋاب بېرىپ: ــ ئىبرانىي ئاياللار مىسىرلىق ئاياللارغا ئوخشىمايدۇ. ئۇلار كۈچلۈك، ساغلام-تىمەن بولغىنى ئۈچۈن تۇغۇت ئانىلىرى ئۇلارنىڭ قېشىغا يېتىپ بارغۇچە، ئۆزلىرى تۇغۇپ بولىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","نەتىجىدە، خۇدا تۇغۇت ئانىلىرىغا ئىلتىپات كۆرسەتتى؛ ئىسرائىل خەلقى داۋاملىق كۆپىيىپ، تېخىمۇ كۈچەيدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","شۇنداق بولدىكى، تۇغۇت ئانىلىرى خۇدادىن قورقىدىغان ئىخلاسمەن بولغانلىقى ئۈچۈن خۇدا ئۇلارنى ئائىلىلىك بولۇشقا مۇيەسسەر قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","بۇنىڭ بىلەن پىرەۋن بارلىق پۇقرالىرىغا: ــ ئىسرائىللاردىن يېڭى تۇغۇلغان ئوغۇل بالىلارنىڭ ھەممىسىنى دەرياغا تاشلاڭلار، لېكىن قىز بالىلارنىڭ ھەممىسىنى تىرىك قالدۇرۇڭلار، دەپ ئەمر قىلدى.      ");
INSERT INTO uigara_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","لاۋىينىڭ جەمەتىدىن بولغان بىر كىشى بېرىپ، لاۋىينىڭ نەسلىدىن بولغان بىر قىزنى خوتۇنلۇققا ئالدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","بۇ ئايال ھامىلىدار بولۇپ، بىر ئوغۇل تۇغدى. ئانا ئۇنىڭ چىرايلىق ئىكەنلىكىنى كۆرۈپ، ئۇنى ئۈچ ئاي يوشۇرۇپ ساقلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ئۇنى يەنە يوشۇرۇشقا ئامالسىز قالغاندا، قومۇشتىن بىر سېۋەت ياساپ، ئۇنىڭغا ياريېلىم ۋە موم سۇۋاپ، بالىنى ئىچىگە سېلىپ، دەريانىڭ قىرغىقىدىكى قومۇشلۇق ئارىسىغا قويۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ئاندىن بالىنىڭ ھەدىسى ئۇنىڭغا نېمە بولاركىن دەپ يىراقتىن قاراپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ئۇ ۋاقىتتا پىرەۋننىڭ قىزى سۇغا چۆمۈلگىلى دەريا تەرەپكە كەلدى؛ ئۇنىڭ چۆرىلىرى دەريا بويىدا ئايلىنىپ يۈردى. پىرەۋننىڭ قىزى قومۇشلۇقنىڭ ئارىسىدا تۇرغان سېۋەتنى كۆرۈپ، خاس چۆرىسىنى ئۇنى ئېلىپ چىقىشقا ئەۋەتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ئۇ سېۋەتنى ئېچىپ قارىۋىدى، مانا، بىر ئوغۇل بالىنى كۆردى ۋە ئۇ بالا يىغلاپ كەتتى. مەلىكە ئۇنىڭغا ئىچ ئاغرىتىپ: ــ بۇ شۈبھىسىزكى ئىبرانىيلارنىڭ بالىلىرىدىن بىرى ئىكەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ئۇ چاغدا بالىنىڭ ھەدىسى پىرەۋننىڭ قىزىدىن: ــ مەن بېرىپ، سىلى ئۈچۈن بالىنى ئېمىتىپ باقىدىغان بىر ئىبرانىي ئىنىكئانا تېپىپ كېلەيمۇ؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","پىرەۋننىڭ قىزى ئۇنىڭغا: ــ بارغىن، دېدى. قىز بېرىپ بوۋاقنىڭ ئانىسىنى چاقىرىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","پىرەۋننىڭ قىزى ئۇنىڭغا: ــ بۇ بالىنى ئېلىپ كېتىپ مەن ئۈچۈن ئېمىتىپ بېقىپ بەر؛ ھەققىڭنى بېرىمەن، دېدى. شۇنىڭ بىلەن ئايال بالىنى ئېلىپ كېتىپ، ئۇنى ئېمىتىپ باقتى. ");
INSERT INTO uigara_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","بالا چوڭ بولغاندا ئۇنى پىرەۋننىڭ قىزىنىڭ قېشىغا ئېلىپ باردى؛ ئۇ ئۇنىڭغا ئوغۇل بولدى. ئۇ: «مەن ئۇنى سۇدىن چىقىرىۋالغان» دەپ ئۇنىڭغا مۇسا دېگەن ئىسىمنى قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","مۇسا چوڭ بولغاندىن كېيىنكى كۈنلەردە شۇنداق بولدىكى، ئۇ ئۆز قېرىنداشلىرىنىڭ يېنىغا باردى ۋە ئۇلارنىڭ ئېغىر ئەمگەككە سېلىنىۋاتقانلىقىنى ئۆز كۆزى بىلەن كۆردى. ئارىدا، بىر مىسىرلىقنىڭ ئىبرانىي قېرىنداشلىرىدىن بىرىنى ئۇرۇۋاتقانلىقىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ئۇ تۆت ئەتراپىغا قاراپ، ئادەم يوقلۇقىنى كۆرۈپ، ھېلىقى مىسىرلىقنى ئۇرۇپ ئۆلتۈرۈپ، قۇمغا كۆمۈپ يوشۇرۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ئەتىسى ئۇ يەنە چىقىپ قارىۋىدى، مانا ئىككى ئىبرانىي بىر-بىرى بىلەن سوقۇشۇۋاتاتتى؛ ئۇ يولسىزلىق قىلىۋاتقان كىشىگە: ــ ئۆز قېرىندىشىڭنى نېمىشقا ئۇرىسەن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ھېلىقى كىشى جاۋاب بېرىپ: ــ كىم سېنى بىزگە ھاكىم ۋە سوراقچى قىلىپ قويدى؟ ھېلىقى مىسىرلىقنى ئۆلتۈرگىنىڭدەك مېنىمۇ ئۆلتۈرمەكچىمۇسەن؟ ــ دېدى. مۇسا بۇ گەپنى ئاڭلاپ قورقۇپ ئۆز ئىچىدە: «مەن قىلغان ئىش جەزمەن ئاشكارا بولۇپ قاپتۇ!» دەپ ئويلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","پىرەۋن ھەم بۇ ئىشتىن خەۋەر تېپىپ، مۇسانى ئۆلتۈرمەكچى بولدى؛ لېكىن مۇسا پىرەۋننىڭ ئالدىدىن قېچىپ، مىدىيان زېمىنىغا بېرىپ ئولتۇراقلاشتى. بىر كۈنى، ئۇ قۇدۇقنىڭ يېنىغا كېلىپ ئولتۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","مىدىياننىڭ كاھىنىنىڭ يەتتە قىزى بار ئىدى؛ ئۇلار كېلىپ، ئاتىسىنىڭ قويلىرىنى سۇغىرىشقا سۇ تارتىپ ئوقۇرلارغا قۇيۇپ تولدۇرۇشقا باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ئۇ ۋاقىتتا يەرلىك پادىچىلار كېلىپ، ئۇلارنى ھەيدىدى، مۇسا قوپۇپ قىزلارغا ياردەم بېرىپ، قويلىرىنى سۇغىرىشىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ئۇلار ئاتىسى رېئۇئەلنىڭ قېشىغا يېنىپ كەلگەندە، ئۇلاردىن: ــ نېمىشقا بۈگۈن شۇنچە تېز يېنىپ كەلدىڭلار؟ ــ دەپ سورىدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ئۇلار جاۋاب بېرىپ: ــ بىر مىسىرلىق ئادەم بىزنى پادىچىلارنىڭ قولىدىن قۇتقۇزدى ھەمدە بىز ئۈچۈن سۇ تارتىپ، قوي پادىمىزنى سۇغىرىپمۇ بەردى! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ئۇ قىزلىرىغا: ــ ئۇنداقتا ئۇ كىشى ھازىر نەدە؟! ئۇنى نېمىشقا سىرتتا تاشلاپ كەلدىڭلار؟ ئۇنى تاماققا چاقىرىڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","مۇسا ئۇ كىشى بىلەن بىللە تۇرۇشقا ماقۇل بولدى. ئۇ قىزى زىپپوراھنى ئۇنىڭغا خوتۇنلۇققا بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ئۇ ئايال ئۇنىڭغا بىر ئوغۇل تۇغۇپ بەردى؛ مۇسا «مەن ياقا يۇرتتا مۇساپىردۇرمەن» دەپ، ئۇنىڭ ئىسمىنى گەرشوم دەپ قويدى.    ");
INSERT INTO uigara_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","نۇرغۇن كۈنلەر ئۆتۈپ، مىسىرنىڭ پادىشاھى ئۆلدى. ئىسرائىللار ئۆز قۇللۇق ھالىتى تۈپەيلىدىن ئاھ-زار ئۇرۇپ، نالە-پەرياد كۆتۈردى؛ قۇللۇقتىن بولغان پەريادى خۇدانىڭ ھۇزۇرىغا بېرىپ يەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","خۇدا ئۇلارنىڭ ئاھ-زارلىرىنى ئاڭلاپ، ئۆزىنىڭ ئىبراھىم بىلەن، ئىسھاق بىلەن ۋە ياقۇپ بىلەن تۈزگەن ئەھدىسىنى ئېسىگە ئالدى. ");
INSERT INTO uigara_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","شۇنىڭ بىلەن خۇدا ئىسرائىللارنىڭ ھال-ئەھۋالىنى كۆردى ۋە خۇدا ئۇلارغا كۆڭۈل بۆلدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","مۇسا بولسا قېينئاتىسى مىدىياننىڭ كاھىنى يەترونىڭ قوي پادىسىنى باقاتتى. ئۇ قويلارنى باشلاپ چۆلنىڭ ئەڭ چېتىگە خۇدانىڭ تېغى، يەنى ھورەب تېغىنىڭ باغرىغا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","شۇ يەردە بىر ئازغانلىقتىن ئۆرلەپ چىقىۋاتقان ئوت يالقۇنى ئىچىدىن پەرۋەردىگارنىڭ پەرىشتىسى ئۇنىڭغا كۆرۈندى. مانا، ئازغانلىق ئوتتا كۆيۈۋاتقان بولسىمۇ، لېكىن ئازغان ئۆزى كۆيۈپ كەتمىگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","مۇسا: ــ مەن بېرىپ، بۇ ئاجايىپ مەنزىرىنى كۆرۈپ باقاي؛ ئازغانلىق نېمىشقا كۆيۈپ كەتمەيدىغاندۇ؟ ــ دەپ ئويلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","پەرۋەردىگار ئۇنىڭ بۇنى كۆرگىلى يولدىن چەتنەپ ئازغانلىققا كەلگىنىنى كۆردى؛ خۇدا ئازغانلىق ئىچىدىن ئۇنى: ــ مۇسا! مۇسا! ــ دەپ چاقىردى. ئۇ: مانا مەن! ــ دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ئۇ ئۇنىڭغا: ــ بۇ يەرگە يېقىن كەلمە؛ پۇتلىرىڭدىن كەشىڭنى سالغىن؛ چۈنكى سەن تۇرغان بۇ يەر مۇقەددەس جايدۇر.    ");
INSERT INTO uigara_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","مەن ئاتاڭنىڭ خۇداسى، ئىبراھىمنىڭ خۇداسى، ئىسھاقنىڭ خۇداسى ۋە ياقۇپنىڭ خۇداسىدۇرمەن، ــ دېدى. بۇنى ئاڭلاپ مۇسا خۇداغا قاراشتىن قورقۇپ، يۈزىنى ئېتىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","پەرۋەردىگار ئۇنىڭغا مۇنداق دېدى: ــ بەرھەق، مەن مىسىردا تۇرۇۋاتقان قوۋمىمنىڭ تارتىۋاتقان ئازاب-ئوقۇبەتلىرىنى كۆردۇم، نازارەتچىلەرنىڭ ئۇلارنى خارلاۋاتقانلىقىدىن قىلغان پەريادىنى ئاڭلىدىم؛ چۈنكى مەن ئۇلارنىڭ دەردلىرىنى بىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","شۇڭا مەن ئۇلارنى مىسىرلىقلارنىڭ قولىدىن قۇتقۇزۇپ، شۇ زېمىندىن چىقىرىپ، ياخشى ھەم كەڭ بىر زېمىنغا، سۈت بىلەن ھەسەل ئېقىپ تۇرىدىغان بىر زېمىنغا، يەنى قانائانىي، ھىتتىي، ئامورىي، پەرىززىي، ھىۋىي ۋە يەبۇسىيلارنىڭ يۇرتىغا ئېلىپ بېرىشقا چۈشتۈم. ");
INSERT INTO uigara_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","مانا ئەمدى ئىسرائىللارنىڭ نالە-پەريادى ماڭا يەتتى، مىسىرلىقلارنىڭ ئۇلارغا قانداق زۇلۇم قىلغانلىقىنىمۇ كۆردۈم. ");
INSERT INTO uigara_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ئەمدى سەن كەل، مەن سېنى خەلقىم ئىسرائىللارنى مىسىردىن ئېلىپ چىقىرىش ئۈچۈن پىرەۋننىڭ ئالدىغا ئەۋەتىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","لېكىن مۇسا خۇداغا: ــ مەن كىم ئىدىم، پىرەۋننىڭ ئالدىغا بېرىپ ئىسرائىللارنى مىسىردىن چىقىرالىغۇدەك؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ئۇ جاۋاب بېرىپ: ــ بەرھەق، مەن سەن بىلەن بىللە بولىمەن؛ سەن قوۋمنى مىسىردىن ئېلىپ چىققاندىن كېيىن بۇ تاغدا خۇداغا ئىبادەت قىلىسىلەر؛ بۇ ئىش مانا ئۆزۈڭگە مېنىڭ سېنى ئەۋەتكىنىمنىڭ ئىسپات-بەلگىسى بولىدۇ، ــ دېدى.   ");
INSERT INTO uigara_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","شۇنىڭ بىلەن مۇسا خۇداغا: ــ مەن ئىسرائىللارنىڭ قېشىغا بېرىپ ئۇلارغا: «ئاتا-بوۋىلىرىڭلارنىڭ خۇداسى مېنى قېشىڭلارغا ئەۋەتتى» دېسەم، ئۇلار مەندىن: «ئۇنىڭ نامى نېمە؟» ــ دەپ سورىسا، ئۇلارغا نېمە دەپ جاۋاب بېرىمەن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","خۇدا مۇساغا: ــ مەن «ئەزەلدىن بار بولغۇچى»دۇرمەن ــ دېدى. ئاندىن ئۇ: ــ بېرىپ، ئىسرائىللارغا: ««ئەزەلدىن بار بولغۇچى» مېنى قېشىڭلارغا ئەۋەتتى» دەپ ئېيتقىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","خۇدا مۇساغا يەنە: ــ ئىسرائىللارغا: ــ «ئاتا-بوۋىلىرىڭلارنىڭ خۇداسى، ئىبراھىمنىڭ خۇداسى، ئىسھاقنىڭ خۇداسى ۋە ياقۇپنىڭ خۇداسى بولغان «ياھۋەھ» مېنى قېشىڭلارغا ئەۋەتتى؛ ئۇ: ياھۋەھ دېگەن بۇ نام ئەبەدگىچە مېنىڭ نامىم بولىدۇ، دەۋردىن-دەۋرگىچە مەن شۇ نام بىلەن ئەسكە ئېلىنىمەن، دەيدۇ» ــ دېگىن. ");
INSERT INTO uigara_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ــ بېرىپ، ئىسرائىلنىڭ ئاقساقاللىرىنى يىغىپ ئۇلارغا: ــ «ئاتا-بوۋىلىرىڭلارنىڭ خۇداسى، يەنى ئىبراھىم، ئىسھاق ۋە ياقۇپنىڭ خۇداسى بولغان پەرۋەردىگار ماڭا كۆرۈنۈپ: ــ مەن سىلەرنى يوقلاپ كەلدىم، مىسىردا سىلەرگە قانداق مۇئامىلە قىلىنىۋاتقانلىقىنى كۆردۈم؛ ");
INSERT INTO uigara_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","شۇنىڭ ئۈچۈن سۆزۈم شۇدۇركى، مەن سىلەرنى مىسىرنىڭ زۇلۇمىدىن چىقىرىپ، قانائانىيلار، ھىتتىيلار، ئامورىيلار، پەرىززىيلەر، ھىۋىيلار ۋە يەبۇسىيلارنىڭ زېمىنى، يەنى سۈت بىلەن ھەسەل ئېقىپ تۇرىدىغان زېمىنغا ئېلىپ بارىمەن، دېدى، ــ دېگىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ــ شۇنىڭ بىلەن ئۇلار سېنىڭ سۆزۈڭگە قۇلاق سالىدىغان بولىدۇ. ئۇ ۋاقىتتا سەن، ئۆزۈڭ ۋە ئىسرائىلنىڭ ئاقساقاللىرى بىلەن بىرگە مىسىر پادىشاھىنىڭ ئالدىغا بېرىپ، ئۇنىڭغا: «ئىبرانىيلارنىڭ خۇداسى پەرۋەردىگار بىز بىلەن كۆرۈشتى. ئەمدى سىزدىن ئۆتۈنىمىزكى، بىزگە ئۈچ كۈنلۈك يولنى بېسىپ، چۆلگە بېرىپ، خۇدايىمىز پەرۋەردىگارغا قۇربانلىق قىلىشقا ئىجازەت بەرگەيسىز» ــ دەڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","لېكىن مىسىر پادىشاھىنىڭ ھەتتا قۇدرەتلىك بىر قولنىڭ ئاستىدا تۇرۇپمۇ، سىلەرنى يەنىلا قويۇپ بەرمەيدىغىنىنى بىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","شۇڭا قولۇمنى ئۇزىتىپ، مىسىرلىقلارنى مەن ئۆز زېمىنى ئىچىدە كۆرسەتمەكچى بولغان ھەرخىل كارامەت-مۆجىزىلىرىم بىلەن ئۇرىمەن؛ ئاندىن پىرەۋن سىلەرنى قويۇپ بېرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","بۇ قوۋمنى مىسىرلىقلارنىڭ ئالدىدا ئىلتىپات تاپتۇرىمەن ۋە شۇنىڭ بىلەن شۇنداق بولىدۇكى، سىلەر شۇ يەردىن چىققىنىڭلاردا، قۇرۇق قول چىقمايسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","بەلكى ھەربىر ئايال كىشى ئۆز قوشنىسىدىن ۋە ئۆز ئۆيىدە ئولتۇرۇشلۇق يات ئايالدىن كۈمۈش زىننەت بۇيۇملىرى، ئالتۇن زىننەت بۇيۇملىرى ۋە كىيىم-كېچەكلەرنى تەلەپ قىلىدۇ. بۇ نەرسىلەرنى ئوغۇل-قىزلىرىڭلارغا تاقايسىلەر، كىيدۈرىسىلەر؛ شۇ تەرىقىدە مىسىرلىقلاردىن ئولجا ئالغان بولىسىلەر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","مۇسا جاۋاب بېرىپ: ــ مانا، ئۇلار ماڭا ئىشەنمەي تۇرۇپ، سۆزۈمگە قۇلاق سالمايدۇ، بەلكى: «پەرۋەردىگار ساڭا كۆرۈنمىدى»، دېيىشى مۇمكىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","پەرۋەردىگار ئۇنىڭغا: ــ قولۇڭدىكى بۇ نېمە؟ ــ دەپ سورىدى. ئۇ: ــ بۇ بىر ھاسا، دەپ جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ئۇ: ــ ئۇنى يەرگە تاشلا، دېدى. ئۇنى يەرگە تاشلىۋىدى، ئۇ بىر يىلانغا ئايلاندى؛ مۇسا ئۇنىڭ ئالدىدىن قاچتى. ");
INSERT INTO uigara_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ئاندىن پەرۋەردىگار مۇساغا: ــ قولۇڭنى ئۇزىتىپ، ئۇنى قۇيرۇقىدىن تۇت، دېۋىدى، ئۇ قولىنى ئۇزىتىپ، ئۇنى تۇتتى. ئۇ يەنە ئۇنىڭ قولىدا ھاسىغا ئايلاندى. ");
INSERT INTO uigara_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","پەرۋەردىگار يەنە: ــ بۇنىڭ بىلەن ئۇلار ئاتا-بوۋىلىرىنىڭ خۇداسى، يەنى ئىبراھىمنىڭ خۇداسى، ئىسھاقنىڭ خۇداسى ۋە ياقۇپنىڭ خۇداسى بولغان پەرۋەردىگارنىڭ ساڭا كۆرۈنگىنىگە ئىشىنىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","پەرۋەردىگار ئۇنىڭغا يەنە: ــ قولۇڭنى قوينۇڭغا سالغىن، دېۋىدى، ئۇ قولىنى قوينىغا سېلىپ چىقىرىۋىدى، مانا، قولى پېسە-ماخاۋ كېسىلىگە گىرىپتار بولۇپ قاردەك ئاقىرىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ئاندىن ئۇنىڭغا: ــ قولۇڭنى يەنە قوينۇڭغا سالغىن، دېۋىدى، قولىنى قوينىغا سالدى. ئۇنى يەنە قوينىدىن چىقىرىۋىدى، مانا، ئۆز ئەكسىگە كېلىپ ئەتلىرىنىڭ باشقا يەرلىرىدەك بولدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","پەرۋەردىگار يەنە: ــ شۇنداق بولىدۇكى، ئەگەر ئۇلار ساڭا ئىشەنمەي، ئالدىنقى مۆجىزىلىك ئالامەتكە كۆڭۈلشىمىسە، ئۇلار ئىككىنچى مۆجىزىلىك ئالامەتكە ئىشىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ھالبۇكى، ئۇلار بۇ ئىككى مۆجىزىگە يەنىلا ئىشەنمىسە ۋە يا سۆزۈڭگە قۇلاق سالمىسا، ئۇنداقتا سەن نىل دەرياسىنىڭ سۈيىدىن ئېلىپ، قۇرۇق يەرگە تۆككىن. شۇنىڭ بىلەن سەن دەريادىن ئالغان سۇ قۇرۇق يەر ئۈستىدە قانغا ئايلىنىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ئاندىن مۇسا پەرۋەردىگارغا: ــ ئەي ئىگەم، مەن ئەسلىدىنلا گەپكە ئۇستا ئەمەستىم، سەن قۇلۇڭغا سۆز قىلغاندىن كېيىنمۇ يەنىلا شۇنداق؛ چۈنكى مەن ئاغزىم كالۋا ۋە تىلىم ئېغىر ئادەممەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","پەرۋەردىگار ئۇنىڭغا: ــ كىم ئىنسانغا ئېغىز بەرگەن؟ كىم ئادەمنى گاچا ياكى گاس، كۆرگۈچى ياكى كور قىلغان؟ شۇنداق قىلغۇچى مەن پەرۋەردىگار ئەمەسمۇ؟ ");
INSERT INTO uigara_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ئەمدى سەن بارغىن، مەن ئۆزۈم سېنىڭ ئاغزىڭ بىلەن بىللە بولىمەن، نېمە سۆزلەيدىغىنىڭنى ساڭا ئۆگىتىپ تۇرىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","لېكىن ئۇ: ــ ئەي ئىگەم! سەندىن ئۆتۈنۈپ قالاي، سەن بۇ ئىشقا خالىغان باشقا بىرسىنى ئەۋەتىپ، شۇنىڭ قولى بىلەن قىلغىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","بۇنى ئاڭلاپ پەرۋەردىگارنىڭ غەزىپى مۇساغا تۇتىشىپ: ــ لاۋىيلاردىن بولغان ئاكاڭ ھارۇن بار ئەمەسمۇ؟ ئۇنىڭ گەپنى ئوبدان قىلالايدىغىنىنى بىلىمەن. مانا، ئۇ ئەمدى سېنىڭ ئالدىڭغا چىقىشقا ئاللىقاچان يولغا چىقتى؛ ئۇ سېنى كۆرسە، كۆڭلى تولىمۇ خۇش بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ئەمدى دەيدىغان گەپلەرنى ئۇنىڭغا ئېيت؛ مەن ئۆزۈم سېنىڭ ئاغزىڭ بىلەن بىللە ۋە ئۇنىڭ ئاغزى بىلەن بىللە بولىمەن، نېمە قىلىش كېرەكلىكىڭلارنى سىلەرگە ئۆگىتىمەن.    ");
INSERT INTO uigara_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ھارۇن سېنىڭ ئورنۇڭدا خەلققە سۆزلەيدۇ؛ شۇنداق بولىدۇكى، ئۇ ساڭا ئېغىز بولىدۇ، سەن ئۇنىڭغا خۇدادەك بولىسەن. ");
INSERT INTO uigara_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","بۇ ھاسىنى قولۇڭغا ئېلىپ، ئۇنىڭ بىلەن شۇ مۆجىزىلىك ئالامەتلەرنى كۆرسىتىسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","شۇنىڭ بىلەن مۇسا قېينئاتىسى يەترونىڭ قېشىغا يېنىپ بېرىپ، ئۇنىڭغا: ــ ماڭا ئىجازەت بەرگەيلا، مىسىردىكى قېرىنداشلىرىمنىڭ قېشىغا باراي، ئۇلار ھاياتمۇ، ئەمەسمۇ كۆرۈپ كېلەي، دېدى. يەترو مۇساغا: ــ ئامان-ئېسەن بېرىپ كەلگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","مۇسا تېخى مىدىياندىكى ۋاقتىدا، پەرۋەردىگار ئۇنىڭغا يەنە: ــ مىسىرغا يېنىپ بارغىن! چۈنكى سېنىڭ جېنىڭنى ئىستىگەن كىشىلەر ئۆلۈپ كەتتى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","شۇنىڭ بىلەن مۇسا ئايالى ۋە ئوغۇللىرىنى ئېلىپ، ئۇلارنى بىر ئېشەككە مىندۈرۈپ، مىسىر زېمىنىغا بېرىشقا يولغا چىقتى. ماڭغاندا مۇسا خۇدانىڭ ھاسىسىنى ئالغاچ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","پەرۋەردىگار مۇساغا: ــ مىسىرغا يېنىپ بارغىنىڭدا سەن ئاگاھ بول، مەن قولۇڭغا تاپشۇرغان بارلىق كارامەتلەرنى پىرەۋننىڭ ئالدىدا كۆرسەتكىن. لېكىن مەن ئۇنىڭ كۆڭلىنى خەلقنى قويۇپ بەرمىگۈدەك قاتتىق قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","سەن پىرەۋنگە: ــ «پەرۋەردىگار مۇنداق دەيدۇ: ــ ئىسرائىل مېنىڭ ئوغلۇم، مېنىڭ تۇنجى ئوغلۇم بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","شۇنىڭ ئۈچۈن مەن ساڭا: ئوغلۇمنى ئۆزۈمگە ئىبادەت قىلىشقا قويۇپ بەر، دېدىم. ئۇنىڭغا يول قويۇشنى رەت قىلىدىغان بولساڭ، سېنىڭ تۇنجى ئوغلۇڭنى ئۆلتۈرىمەن» ــ دېگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ئەمما مۇسا سەپەر قىلىپ بىر قونالغۇغا كەلگەندە، پەرۋەردىگار ئۇنىڭغا ئۇچراپ، ئۇنى ئۆلتۈرۈۋەتمەكچى بولدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","شۇنىڭ بىلەن زىپپوراھ بىر چاقماق تېشىنى ئېلىپ، ئوغلىنىڭ خەتنىلىكىنى كېسىپ، ئۇنى ئېرىنىڭ ئايىغىغا تاشلاپ: ــ سەن دەرۋەقە ئالدىمدا قان تۆكەر ئەر ئىكەنسەن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","شۇنىڭ بىلەن پەرۋەردىگار ئۇنى قويۇپ بەردى (بۇ چاغدا زىپپوراھ ئۇنىڭغا: «سەن دەرۋەقە ئالدىمدا قان تۆكەر بىر ئەر ئىكەنسەن!» ــ دېدى. بۇ سۆزىنى ئۇ خەتنە تۈپەيلىدىن ئېيتتى). ");
INSERT INTO uigara_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","پەرۋەردىگار ھارۇنغا: ــ سەن چۆل-باياۋانغا بېرىپ، مۇسا بىلەن كۆرۈشكىن، دېۋىدى، ئۇ بېرىپ خۇدانىڭ تېغىدا ئۇنىڭ بىلەن ئۇچرىشىپ، ئۇنى سۆيدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","مۇسا ئۆزىنى ئەۋەتكەن پەرۋەردىگارنىڭ ھەممە سۆزلىرى بىلەن قىلىشقا بۇيرۇغان بارلىق مۆجىزىلىك ئالامەتلەرنى ھارۇنغا دەپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ئاندىن مۇسا بىلەن ھارۇن بېرىپ، ئىسرائىللارنىڭ بارلىق ئاقساقاللىرىنى يىغدى. ");
INSERT INTO uigara_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ھارۇن پەرۋەردىگارنىڭ مۇساغا ئېيتقان ھەممە سۆزلىرىنى بايان قىلدى ۋە خەلقنىڭ كۆز ئالدىدا شۇ مۆجىزىلىك ئالامەتلەرنى كۆرسەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","بۇنى كۆرۈپ، خەلق ئىشەندى؛ پەرۋەردىگارنىڭ ئىسرائىللارنى يوقلاپ، ئۇلار ئۇچرىغان خارلىقلارنى كۆرگەنلىكىنى ئاڭلىغان ھامان، باشلىرىنى ئېگىپ سەجدە قىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ئاندىن مۇسا بىلەن ھارۇن پىرەۋننىڭ ئالدىغا بېرىپ، ئۇنىڭغا: ــ ئىسرائىلنىڭ خۇداسى پەرۋەردىگار ساڭا: ــ «ئۇلارنىڭ بېرىپ چۆلدە ماڭا ئىبادەت قىلىپ، ھېيت ئۆتكۈزۈشىگە قوۋمىمغا يول قويسۇن» دەيدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","لېكىن پىرەۋن جاۋاب بېرىپ: ــ ئۇنىڭ سۆزىگە قۇلاق سېلىپ، مېنى ئىسرائىلغا يول قويغۇزىدىغان قانداق پەرۋەردىگار ئىكەن ئۇ؟ مەن ئۇ پەرۋەردىگارنى تونۇمايمەن ھەم ئىسرائىلغىمۇ يول قويمايمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ئۇلار سۆز قىلىپ: ــ ئىبرانىيلارنىڭ خۇداسى بىز بىلەن كۆرۈشتى. شۇڭا ئۆتۈنىمىزكى، بىزگە پەرۋەردىگار خۇدايىمىزغا قۇربانلىق سۇنۇش ئۈچۈن بىزگە چۆلگە بېرىشقا ئۈچ كۈنلۈك يولغا رۇخسەت بەرگەيسىز. بولمىسا، ئۇ بىزنى ۋابا ياكى قىلىچ بىلەن ئۇرۇشى مۇمكىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","لېكىن مىسىرنىڭ پادىشاھى ئۇلارغا جاۋاب بېرىپ: ــ ئەي مۇسا ۋە ھارۇن، نېمىشقا ئىككىڭلار خەلقنى ئىشلىرىدىن توختىتىپ قويماقچى بولىسىلەر؟ بېرىپ ئۆز ئەپكىشىڭلارنى كۆتۈرۈڭلار! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","پىرەۋن يەنە: ــ مانا، خەلق يۇرتتا زىيادە ئاۋۇپ كەتتى. سىلەر بولساڭلار، ئۇلارنى ئەپكەشلىرىدىن خالاس قىلماقچىسىلەر، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","شۇ كۈنى پىرەۋن نازارەتچىلەرگە ۋە نازارەتچىلەرنىڭ قول ئاستىدىكى ئىش باشلىرىغا بۇيرۇق چۈشۈرۈپ: ــ ");
INSERT INTO uigara_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","ھازىردىن باشلاپ خەلققە ئىلگىرىكىدەك كېسەك قۇيۇشقا سامان بەرمەڭلار! ئۇلار ساماننى ئۆزلىرى يىغسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","لېكىن ئىلگىرى قانچىلىك كېسەك قۇيۇپ كەلگەن بولسا، ھېلىھەم كەم قىلماي شۇنچىلىك كېسەك قۇيدۇرۇڭلار؛ چۈنكى ئۇلار ھۇرۇنلىشىپ: «خۇدايىمىزغا قۇربانلىق ئۆتكۈزۈشكە بىزنى بارغىلى قوي» دەپ غەلۋە قىلىشىۋاتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ئەمدى ئۇلارنى ئۆز ئىشىغا تولۇق بەند بولۇپ، يالغان-ياۋىداق گەپلەرگە قۇلاق سالماسلىقى ئۈچۈن، بۇ ئادەملەرنىڭ ئۈستىگە تېخىمۇ ئېغىر ئەمگەكلەرنى يۈكلەڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","شۇنىڭ بىلەن خەلقنىڭ ئۈستىدىكى نازارەتچىلەر بىلەن ئىش باشلىرى چىقىپ خەلققە: پىرەۋن شۇنداق دېدىكى، مەن ئەمدى سىلەرگە سامان بەرمەيدىغان بولدۇم. ");
INSERT INTO uigara_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ئۆزۈڭلار بېرىڭلار، ئۆزۈڭلار ئۈچۈن قەيەردىن سامان تاپالىساڭلار، شۇ يەردىن ئېلىپ كېلىڭلار؛ لېكىن قىلىدىغان ئىشلىرىڭلار بولسا قىلچىلىكمۇ كېمەيتىلمەيدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","بۇنىڭ بىلەن خەلق پۈتكۈل مىسىر زېمىنىغا تارىلىپ، ساماننىڭ ئورنىغا پاخال يىغىشقا باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","نازارەتچىلەر بولسا ئۇلارنى قىستاپ: سىلەرگە سامان بېرىلگەن چاغدىكىدەك ھازىرمۇ ھەر كۈنلۈك ئىشنى شۇ كۈنى قىلىڭلار، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ئىسرائىللارنىڭ ئۈستىگە پىرەۋننىڭ نازارەتچىلىرى تەرىپىدىن قويۇلغان ئىسرائىللىق ئىش باشلىرى تاياق يېدى ۋە: ــ تۈنۈگۈن ۋە بۈگۈن نېمىشقا كېسەك قۇيۇش ۋەزىپسىنى بۇرۇنقىدەك توشقۇزۇپ ئورۇنلىمىدىڭلار؟! ــ دەپ تىل ئىشىتتى. ");
INSERT INTO uigara_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ئاندىن ئىسرائىللىق ئىش باشلىرى پىرەۋننىڭ ئالدىغا بېرىپ: نېمىشقا ئۆز قۇللىرىغا مۇنداق مۇئامىلە قىلىدىلا؟ ");
INSERT INTO uigara_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ئۆز قۇللىرىغا ھېچ سامان بېرىلمىدى. لېكىن نازارەتچىلەر يەنىلا «كېسەك قۇيدۇرۇڭلار» دەپ بىزنى بۇيرۇيدۇ. مانا، ئۆز قۇللىرى تاياق يەۋاتىدۇ، ئەمما ئەيىب بولسا ئۆزلىرىنىڭ ئادەملىرىدە، دەپ پەرياد قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","لېكىن ئۇ يەنە: ــ سىلەر ھۇرۇن ئىكەنسىلەر! ھۇرۇن ئىكەنسىلەر! شۇڭا سىلەر: «بېرىپ پەرۋەردىگارغا قۇربانلىق ئۆتكۈزۈشىمىزگە ئىجازەت بەر دەۋاتىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","قايتىپ بېرىپ ئىشىڭنى قىلىش! سىلەرگە سامان بېرىلمەيدۇ، بىراق كېسەكلەرنى بەلگىلەنگەن سان بويىچە ئاۋۋالقىدەك تولۇق تاپشۇرۇشىسەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ئىسرائىللىق ئىش باشلىرى پىرەۋننىڭ: «سىلەر ھەركۈنلۈك ۋەزىپەڭلارنى، يەنى تەلەپ قىلغان كېسەكلەرنى بەلگىلەنگەن ساندىن كېمەيتسەڭلار قەتىي بولمايدۇ» دېگىنىگە قاراپ، بېشىغا بالا-قازانىڭ چۈشىدىغانلىقىنى بىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ئۇلار پىرەۋننىڭ ئالدىدىن چىقىپ كېلىۋاتقىنىدا، ئۇلار بىلەن كۆرۈشۈشكە كېلىپ شۇ يەردە ساقلاپ تۇرغان مۇسا ۋە ھارۇن بىلەن ئۇچرىشىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ئۇلار مۇسا بىلەن ھارۇنغا: ــ بىزنى پىرەۋننىڭ نەزىرىدە ۋە ئۇنىڭ ئەمەلدارلىرىنىڭ نەزىرىدە سېسىتىپ، بىزنى ئۆلتۈرۈشكە ئۇلارنىڭ قولىغا قىلىچ تۇتقۇزغىنىڭلار ئۈچۈن، پەرۋەردىگار سىلەرنىڭ ئۈستۈڭلارغا ھۆكۈم قىلسۇن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","شۇنىڭ بىلەن مۇسا پەرۋەردىگارنىڭ ئالدىغا يېنىپ بېرىپ ئۇنىڭغا: ــ ئەي ئىگەم، نېمىشقا بۇ خەلقنى بالاغا تىقتىڭ؟ سەن نېمە ئۈچۈن مېنى ئەۋەتتىڭ؟ ");
INSERT INTO uigara_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","چۈنكى مەن پىرەۋننىڭ ئالدىغا كىرىپ سېنىڭ نامىڭ بىلەن سۆز قىلغىنىمدىن تارتىپ، ئۇ بۇ خەلقنىڭ ئۈستىگە تېخىمۇ زىيادە ئازاب قىلغىلى تۇردى. ئەمما سەن تېخىچە قوۋمىڭنى ھېچ قۇتقۇزمىدىڭ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","لېكىن پەرۋەردىگار مۇساغا: ــ ئەمدى سەن مېنىڭ پىرەۋنگە قىلىدىغانلىرىمنى كۆرىسەن؛ چۈنكى ئۇ قۇدرەتلىك بىر قولدىن مەجبۇرلىنىپ، ئۇلارنى قويۇپ بېرىدۇ، قۇدرەتلىك بىر قولنىڭ سەۋەبىدىن ئۆزىنىڭ زېمىنىدىن ئۇلارنى قوغلاپ چىقىرىۋېتىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ئاندىن خۇدا مۇساغا يەنە سۆز قىلىپ مۇنداق دېدى: ــ مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","مەن ئىبراھىمغا، ئىسھاققا ۋە ياقۇپقا قادىر-مۇتلەق تەڭرى سۈپىتىدە كۆرۈندۈم؛ لېكىن «ياھۋەھ» دېگەن نامىم بىلەن ئۇلارغا ئاشكارا تونۇلمىدىم. ");
INSERT INTO uigara_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","مەن ئۇلار بىلەن: ــ «سىلەر مۇساپىر بولۇپ ئولتۇرغان زېمىننى، يەنى قانائان زېمىنىنى سىلەرگە بېرىمەن» دەپ، ئۇلار بىلەن ئەھدە باغلىشىپ ۋەدە قىلغانمەن. ");
INSERT INTO uigara_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ئەمدى مەن مىسىرلىقلار قۇل قىلىپ زۇلۇم سالغان ئىسرائىللارنىڭ ئاھ-زارلىرىنى ئاڭلاپ، قىلغان شۇ ئەھدەمنى ئېسىمگە ئالدىم. ");
INSERT INTO uigara_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","شۇڭا ئىسرائىللارغا مۇنداق دېگىن: ــ «مەن پەرۋەردىگاردۇرمەن؛ مەن ئۆزۈم سىلەرنى مىسىرلىقلارنىڭ ئېغىر يۈكلىرى ئاستىدىن چىقىرىپ، ئۇلارنىڭ قۇللۇقىدىن ئازاد قىلىپ، قولۇمنى ئۇزىتىپ ئۇلارغا چوڭ بالايىئاپەتلەرنى چۈشۈرۈپ، سىلەرگە ھەمجەمەت بولۇپ ھۆرلۈككە ئېرىشتۈرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","سىلەرنى ئۆز قوۋمىم بولۇشقا قوبۇل قىلىمەن ۋە ئۆزۈم خۇدايىڭلار بولىمەن؛ شۇنىڭ بىلەن سىلەر ئۆزۈڭلارنى مىسىرلىقلارنىڭ يۈكلىرىنىڭ ئاستىدىن قۇتقۇزۇپ چىقارغۇچىنىڭ مەن خۇدايىڭلار پەرۋەردىگار ئىكەنلىكىنى بىلىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","مەن شۇنىڭ بىلەن سىلەرنى قول كۆتۈرۈپ ئىبراھىمغا، ئىسھاققا ۋە ياقۇپقا بېرىشكە قەسەم قىلغان زېمىنغا ئېلىپ بارىمەن؛ مەن ئۇ يەرنى سىلەرگە مىراس قىلىپ زېمىنلىققا بېرىمەن؛ مەن پەرۋەردىگاردۇرمەن». ");
INSERT INTO uigara_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","بۇلارنىڭ ھەممىسىنى مۇسا ئىسرائىللارغا دەپ بەردى؛ لېكىن ئۇلار ئېغىر قۇللۇق ئازابىدىن پىغانغا چۈشكەن بولۇپ، ئۇنىڭغا قۇلاق سالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ئاندىن پەرۋەردىگار مۇساغا يەنە: ــ ");
INSERT INTO uigara_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","بېرىپ مىسىرنىڭ پادىشاھى پىرەۋنگە: «ئىسرائىللارنىڭ زېمىنىڭدىن كېتىشىگە يول قوي»، دەپ ئېيتقىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","لېكىن مۇسا پەرۋەردىگارنىڭ ئالدىدا: مانا، ئىسرائىللار ماڭا قۇلاق سالمىغان يەردە، پىرەۋن قانداقمۇ مەندەك كالپۇكى خەتنە قىلىنمىغان بىر ئادەمگە قۇلاق سالسۇن؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ئەمما پەرۋەردىگار مۇسا ۋە ھارۇنغا سۆزلەپ، ئۇلارنىڭ ئىسرائىللارغا ۋە مىسىرنىڭ پادىشاھى پىرەۋنگە ئىسرائىللار توغرۇلۇق: ــ «ئۇلار مىسىر زېمىنىدىن ئېلىپ چىقىرىلسۇن» دېگەن ئەمر يەتكۈزۈشىنى بۇيرۇدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","تۆۋەندىكىلەر جەمەت باشلىقلىرى: ــ ئىسرائىلنىڭ تۇنجى ئوغلى بولغان رۇبەننىڭ ئوغۇللىرى ھانۇق، پاللۇ، ھەزرون ۋە كارمى. بۇلار بولسا رۇبەننىڭ نەسىللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","شىمېئوننىڭ ئوغۇللىرى: ــ يەمۇئەل، يامىن، ئوھاد، ياقىن، زوھار ۋە قانائانلىق ئايالدىن بولغان سائۇللار ئىدى؛ بۇلار شىمېئوننىڭ نەسىللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","لاۋىينىڭ ئوغۇللىرىنىڭ ئىسىملىرى، نەسەبنامىلىرىگە ئاساسەن: گەرشون، كوھات ۋە مەرارى؛ لاۋىينىڭ ئۆمرىنىڭ يىللىرى بىر يۈز ئوتتۇز يەتتە يىل بولدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","گەرشوننىڭ ئوغۇللىرى ئائىلىلىرى بويىچە: ــ لىبنى ۋە شىمەي. ");
INSERT INTO uigara_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","كوھاتنىڭ ئوغۇللىرى: ــ ئامرام، يىزھار، ھېبرون بىلەن ئۇززىئەل. كوھات بىر يۈز ئوتتۇز ئۈچ يىل ئۆمۈر كۆردى. ");
INSERT INTO uigara_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","مەرارىنىڭ ئوغۇللىرى: ــ ماھلى ۋە مۇشى. بۇلار نەسەبنامىلىرى بويىچە لاۋىينىڭ نەسىللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ئامرام ئۆز ھاممىسى يوكەبەدنى خوتۇنلۇققا ئالدى، يوكەبەد ئۇنىڭغا ھارۇن ۋە مۇسانى تۇغۇپ بەردى. ئامرام بىر يۈز ئوتتۇز يەتتە يىل ئۆمۈر كۆردى.    ");
INSERT INTO uigara_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","يىزھارنىڭ ئوغۇللىرى: ــ كوراھ، نەفەگ ۋە زىكرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ئۇززىئەلنىڭ ئوغۇللىرى: ــ مىشائەل، ئەلزافان ۋە سىترى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ھارۇن بولسا ناھشوننىڭ سىڭلىسىنى، يەنى ئاممىنادابنىڭ قىزى ئېلىشېبانى خوتۇنلۇققا ئالدى. ئۇ ئۇنىڭغا ناداب بىلەن ئابىھۇنى، ۋە ئەلىئازار بىلەن ئىتامارنى تۇغۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","كوراھنىڭ ئوغۇللىرى: ــ ئاسسىر، ئەلكاناھ ۋە ئابىئاساف؛ بۇلار كوراھلارنىڭ نەسىللىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ھارۇننىڭ ئوغلى ئەلىئازار پۇتىئەلنىڭ قىزلىرىنىڭ بىرىنى خوتۇنلۇققا ئالدى؛ ئۇ ئۇنىڭغا فىنىھاسنى تۇغۇپ بەردى؛ بۇلار بولسا ئۆز نەسەبى بويىچە ھەممىسى لاۋىيلارنىڭ جەمەت باشلقىلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","پەرۋەردىگارنىڭ: ــ ئىسرائىللارنى قوشۇنلاردەك توپ-توپى بىلەن مىسىر زېمىنىدىن ئېلىپ چىقىڭلار، دېگەن ئەمرىنى تاپشۇرۇۋالغۇچىلار دەل مۇشۇ ھارۇن بىلەن مۇسا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ئىسرائىللار مىسىردىن چىقىرىلسۇن، دەپ مىسىرنىڭ پادىشاھى پىرەۋنگە سۆز قىلغانلار دەل بۇ كىشىلەر، يەنى مۇشۇ مۇسا بىلەن ھارۇن ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","پەرۋەردىگار مىسىرنىڭ زېمىنىدا مۇساغا سۆز قىلغان ۋاقتىدا ");
INSERT INTO uigara_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","مۇساغا: «مەن پەرۋەردىگاردۇرمەن. ساڭا ئېيتقىنىمنىڭ ھەممىسىنى مىسىرنىڭ پادىشاھى پىرەۋنگە دېگىن»، دەپ ئەمر قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","لېكىن مۇسا پەرۋەردىگارنىڭ ئالدىدا: ــ مەندەك كالپۇكى خەتنە قىلىنمىغان بىر كىشىگە پىرەۋن قانداقمۇ قۇلاق سالسۇن؟» ــ دەپ جاۋاپ بەرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","شۇنىڭ بىلەن پەرۋەردىگار مۇساغا: ــ مانا، مەن پىرەۋننىڭ ئالدىدا سېنى خۇدانىڭ ئورنىدا قىلدىم. ئاكاڭ ھارۇن بولسا سېنىڭ پەيغەمبىرىڭ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","مەن ساڭا بۇيرۇغىنىمنىڭ ھەممىسىنى ئۇنىڭغا دەيسەن؛ ئاندىن ئاكاڭ ھارۇن پىرەۋنگە ئۇنىڭ ئۆز زېمىنىدىن ئىسرائىللارنى قويۇپ بېرىشى كېرەكلىكى توغرىسىدا سۆز قىلىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","لېكىن مەن پىرەۋننىڭ كۆڭلىنى قاتتىق قىلىمەن؛ بۇنىڭ بىلەن مەن مىسىر زېمىنىدا مۆجىزىلىك ئالامەتلەر ۋە كارامەتلىرىمنى كۆپلەپ كۆرسىتىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","شۇنداقتىمۇ، پىرەۋن سىلەرگە قۇلاق سالمايدۇ. ئەمما مەن مىسىرنىڭ ئۈستىگە ھۆكۈم چىقىرىپ قولۇمنى ئۇزىتىپ، چوڭ بالايىئاپەتلەرنى چۈشۈرۈپ، قوشۇنلىرىم بولغان ئۆز قوۋمىم ئىسرائىللارنى مىسىر زېمىنىدىن چىقىرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ئۆز قولۇمنى مىسىرنىڭ ئۈستىگە سوزغىنىمدا، ئىسرائىللارنى ئۇلارنىڭ ئارىسىدىن چىقارغىنىمدا مىسىرلىقلار مېنىڭ پەرۋەردىگار ئىكەنلىكىمنى تونۇپ يېتىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","مۇسا بىلەن ھارۇن شۇنداق قىلدى؛ پەرۋەردىگار ئۇلارغا قانداق تاپىلىغان بولسا، ئۇلارمۇ شۇنداق قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ئۇلار پىرەۋنگە سۆز قىلغان ۋاقىتتا مۇسا سەكسەن ياشقا، ھارۇن سەكسەن ئۈچ ياشقا كىرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","ئەمدى پىرەۋن سىلەرگە: ــ ئۆزۈڭلارنى تەستىقلاپ بىر مۆجىزە كۆرسىتىڭلار، دېسە، سەن ھارۇنغا: ــ ھاساڭنى ئېلىپ پىرەۋننىڭ ئالدىغا تاشلىغىن، دەپ ئېيتقىن. شۇنداق قىلىشى بىلەنلا ھاسا يىلانغا ئايلىنىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","شۇنىڭ بىلەن، مۇسا بىلەن ھارۇن پىرەۋننىڭ ئالدىغا بېرىپ، پەرۋەردىگارنىڭ بۇيرۇغىنىدەك قىلدى؛ ھارۇن ھاسىسىنى پىرەۋن بىلەن ئۇنىڭ ئەمەلدارلىرىنىڭ ئالدىغا تاشلىۋىدى، ئۇ يىلانغا ئايلاندى. ");
INSERT INTO uigara_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ئۇ ۋاقىتتا پىرەۋن دانىشمەنلىرى ۋە سېھىرگەرلىرىنى چاقىرتىپ كەلدى؛ مىسىرنىڭ جادۇگەرلىرىمۇ ئۆز جادۇسى بىلەن ئوخشاش ئىشنى قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ئۇلارنىڭ ھەربىرى ئۆز ھاسىسىنى تاشلىدى؛ ئۇلارمۇ يىلانغا ئايلاندى. لېكىن ھارۇننىڭ ھاسىسى ئۇلارنىڭ ھاسىلىرىنى يۇتۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","بىراق پەرۋەردىگار ئېيتقاندەك پىرەۋننىڭ كۆڭلى قاتتىقلىق بىلەن پەرۋەردىگار ئېيتقاندەك ئۇلارغا قۇلاق سالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ئاندىن پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ پىرەۋننىڭ كۆڭلى قاتتىق؛ ئۇ قوۋمنى قويۇپ بېرىشنى رەت قىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ئەمدى سەن ئەتە سەھەردە پىرەۋننىڭ قېشىغا بارغىن (شۇ ۋاقىتتا ئۇ سۇ بويىغا چىقىدۇ) ــ سەن ئۇنىڭ بىلەن كۆرۈشۈشكە دەريانىڭ بويىدا ساقلاپ تۇرغىن؛ يىلانغا ئايلانغان ھاسىنى قولۇڭغا ئېلىۋال. ");
INSERT INTO uigara_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","سەن ئۇنىڭغا مۇنداق دېگىن: ــ «ئىبرانىيلارنىڭ خۇداسى پەرۋەردىگار مېنى ئالدىڭغا: «چۆلدە ماڭا ئىبادەت قىلىشى ئۈچۈن قوۋمىمنى قويۇپ بەر» دېيىشكە ئەۋەتكەنىدى؛ لېكىن مانا، بۇ ۋاقىتقىچە ھېچ ئاڭلىمىدىڭ. ");
INSERT INTO uigara_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","شۇڭا پەرۋەردىگار ساڭا: ــ «سەن شۇ ئالامەت بىلەن مېنىڭ پەرۋەردىگار ئىكەنلىكىمنى بىلىسەن»، دەيدۇ ــ مانا، مەن قولۇمدىكى ھاسا بىلەن دەريانىڭ سۈيىنى ئۇرسام، سۇ قانغا ئايلىنىدۇ، ");
INSERT INTO uigara_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","دەريانىڭ بېلىقلىرى ئۆلۈپ، دەريانىڭ سۈيى سېسىپ كېتىدۇ؛ مىسىرلىقلار سۇدىن سەسكىنىپ، ئىچەلمەيدىغان بولۇپ قالىدۇ». ");
INSERT INTO uigara_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","پەرۋەردىگار مۇساغا يەنە: ــ سەن ھارۇنغا: ــ ھاساڭنى ئېلىپ مىسىرلىقلارنىڭ سۇلىرى قانغا ئايلانسۇن دەپ ئۇلارنىڭ ئۈستىگە، يەنى ئېقىنلىرى، ئۆستەڭلىرى، كۆللىرى ۋە سۇ ئامبارلىرى ئۈستىگە قولۇڭنى ئۇزاتقىن. شۇنىڭ بىلەن پۈتكۈل مىسىر زېمىنىدا، ھەتتا ياغاچ ۋە تاش قاچىلاردىكى سۇلارمۇ قانغا ئايلىنىدۇ، دېگىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","مۇسا بىلەن ھارۇن پەرۋەردىگارنىڭ بۇيرۇغىنىدەك قىلدى؛ ھارۇن پىرەۋن ۋە ئەمەلدارلىرىنىڭ كۆز ئالدىدا ھاسىنى كۆتۈرۈپ، دەريانىڭ سۈيىنى ئۇرۇۋىدى، پۈتۈن دەريانىڭ سۈيى قانغا ئايلىنىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","دەريادىكى بېلىقلار ئۆلۈپ، دەريانىڭ سۈيى سېسىپ كەتتى. مىسىرلىقلار دەريانىڭ سۈيىنى ئىچەلمەيدىغان بولۇپ قالدى، پۈتكۈل مىسىر زېمىنى قانغا تولدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","لېكىن مىسىرنىڭ جادۇگەرلىرىمۇ ئۆز جادۇلىرى بىلەن ھەم شۇنداق قىلدى. بۇ سەۋەبتىن پەرۋەردىگار ئېيتقاندەك پىرەۋننىڭ كۆڭلى قاتتىق بولۇپ، ئۇلارغا قۇلاق سالمىدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ئەكسىچە پىرەۋن ئۆيىگە قايتىپ كېتىپ، بۇ ئىشقا ھېچ پىسەنت قىلمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","دەريانىڭ سۈيىنى ئىچەلمىگىنى ئۈچۈن بارلىق مىسىرلىقلار ئىچكۈدەك سۇ تېپىش ئۈچۈن دەريانىڭ ئەتراپلىرىنى كولىدى. ");
INSERT INTO uigara_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","پەرۋەردىگار دەريانى ئۇرۇپ، يەنە يەتتە كۈن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ئاندىن پەرۋەردىگار مۇساغا: ــ پىرەۋننىڭ ئالدىغا بېرىپ ئۇنىڭغا: ــ پەرۋەردىگار مۇنداق دەيدۇ: ــ «ماڭا ئىبادەت قىلىشقا ئۆز قوۋمىمنى قويۇپ بەر. ");
INSERT INTO uigara_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","لېكىن ئۇلارنى قويۇپ بېرىشنى رەت قىلساڭ، مانا، مەن دۆلىتىڭنىڭ ھەممە يېرىنى پاقىلار بىلەن باستۇرۇپ ئۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","دەريادا توپ-توپ پاقىلار پەيدا بولۇپ، دەريادىن چىقىپ ئورداڭغا، ھۇجراڭغا، ئورۇن-كۆرپەڭگە، ئەمەلدارلىرىڭنىڭ ئۆيلىرىگە كىرىۋالىدۇ، شۇنىڭدەك خەلقىڭنىڭ ئۇچىسىغا، تونۇر ۋە تەڭنىلىرىڭگە يامىشىپ چىقىۋالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","پاقىلار ئۆزۈڭنىڭ ئۈستىبېشىغا، خەلقىڭنىڭ ئۈستىبېشىغا ۋە ھەممە ئەمەلدارلىرىڭنىڭ ئۈستىبېشىغا يامىشىپ چىقىۋالىدۇ» ــ دېگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","پەرۋەردىگار مۇساغا: ــ سەن ھارۇنغا: پاقىلارنىڭ مىسىر زېمىنىنىڭ ئۈستىگە چىقىشى ئۈچۈن قولۇڭنى ئۇزىتىپ، ھاساڭنى ئېقىنلار، ئۆستەڭلەر ۋە كۆللەرنىڭ ئۈستىگە شىلتىغىن، دېگىن ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","شۇنىڭ بىلەن ھارۇن قولىنى مىسىرنىڭ سۇلىرى ئۈستىگە ئۇزاتتى؛ شۇنداق قىلىۋىدى، پاقىلار چىقىپ مىسىر زېمىنىنى قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","لېكىن جادۇگەرلەرمۇ ئۆز جادۇلىرى بىلەن ئوخشاش ئىشنى قىلىپ، مىسىر زېمىنى ئۈستىگە پاقىلارنى پەيدا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","پىرەۋن مۇسا بىلەن ھارۇننى چاقىرتىپ: ــ پاقىلارنى مەندىن ۋە خەلقىمدىن نېرى قىلىش ئۈچۈن پەرۋەردىگاردىن ئۆتۈنۈڭلار. شۇنداق بولسا، مەن خەلقىڭنى پەرۋەردىگارغا قۇربانلىق قىلسۇن دەپ قويۇپ بېرىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","مۇسا پىرەۋنگە: ــ بوپتۇ، مەن ئىززىتىڭنى قىلاي، پەقەت دەريادىكى پاقىلارلا قېلىپ، باشقىلىرى ئۆزۈڭدىن ۋە ئۆيلىرىڭدىن ئايرىلسۇن دەپ، سەن، ئەمەلدارلىرىڭ ۋە خەلقىڭ ئۈچۈن مېنىڭ دۇئا قىلىدىغان ۋاقتىمنى بېكىتكىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ئۇ جاۋاب بېرىپ: ــ ئەتە بولسۇن، دېدى. مۇسا ئۇنىڭغا: ــ خۇدايىمىز پەرۋەردىگارغا ئوخشاش ھېچبىرىنىڭ يوقلۇقىنى بىلىشىڭ ئۈچۈن سېنىڭ دېگىنىڭدەك بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","پاقىلار سەندىن، ئۆيلىرىڭدىن، ئەمەلدارلىرىڭ ۋە خەلقىڭدىن چىقىپ كېتىدۇ؛ پەقەت دەريادىلا قالىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","شۇنىڭ بىلەن مۇسا ۋە ھارۇن پىرەۋننىڭ ئالدىدىن چىقىپ كەتتى. ئاندىن مۇسا پىرەۋننىڭ ئۈستىگە ئەۋەتىلگەن پاقىلار توغرىسىدا پەرۋەردىگارغا نىدا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","پەرۋەردىگار مۇسانىڭ تىلىگىنىدەك قىلدى. بۇنىڭ بىلەن ئۆيلەردىكى، ھويلىلاردىكى ۋە ئېتىزلاردىكى پاقىلار ئۆلدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","خەلق ئۇلارنى يىغىپ دۆۋە-دۆۋە قىلدى، پۈتكۈل يۇرت-زېمىن سېسىقچىلىققا تولدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","لېكىن پىرەۋن ئاپەتتىن خالاس بولغىنىنى كۆرگەندە، كۆڭلىنى قاتتىق قىلىپ، پەرۋەردىگار ئېيتقىنىدەك ئۇلارغا قۇلاق سالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ئاندىن پەرۋەردىگار مۇساغا: ــ سەن ھارۇنغا: ــ ھاساڭنى ئۇزىتىپ، يەرنىڭ توپىسىنى ئۇرغىن. بۇنىڭ بىلەن ئۇ پاشىغا ئايلىنىپ، پۈتكۈل مىسىر زېمىنىنى قاپلايدۇ، دېگىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ئۇلار شۇنداق قىلدى؛ ھارۇن قولىنى ئۇزىتىپ ھاسىسى بىلەن يەرنىڭ توپىسىنى ئۇرۇۋىدى، ئادەملەر ۋە ھايۋانلارنىڭ ئۈستىبېشىنى پاشا باستى؛ پۈتكۈل مىسىر زېمىنىدىكى توپا-چاڭلار پاشىغا ئايلاندى. ");
INSERT INTO uigara_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","جادۇگەرلەرمۇ ئۆز جادۇلىرى بىلەن شۇنداق قىلىپ پاشا پەيدا قىلىشقا ئۇرۇنغان بولسىمۇ، پەيدا قىلالمىدى. پاشىلار بولسا ھەم ئادەملەرنىڭ ھەم ھايۋانلارنىڭ ئۈستىبېشىنى قاپلاپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ئاندىن جادۇگەرلەر پىرەۋنگە: ــ بۇ ئىش خۇدانىڭ بارمىقىنىڭ قىلغىنى! ــ دېيىشتى. لېكىن پىرەۋن كۆڭلىنى قاتتىق قىلىپ، پەرۋەردىگار ئېيتقىنىدەك ئۇلارغا قۇلاق سالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","پەرۋەردىگار مۇساغا: ــ ئەتە سەھەر قوپۇپ پىرەۋننىڭ ئالدىغا بېرىپ تۇرغىن ــ (شۇ ۋاقىتتا ئۇ سۇ بويىغا چىقىدۇ) ئۇنىڭغا: «پەرۋەردىگار مۇنداق دەيدۇ: ــ ماڭا ئىبادەت قىلىشى ئۈچۈن ئۆز قوۋمىمنى قويۇپ بەر! ");
INSERT INTO uigara_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","چۈنكى ئەگەر قوۋمىمنى قويۇپ بەرمىسەڭ، مانا مەن سېنىڭ ۋە ئەمەلدارلىرىڭ، خەلقىڭ ئۈستىگە، ئۆيلىرىڭگە كۆكۈيۈنلەرنى ئەۋەتىمەن؛ شۇنىڭ بىلەن مىسىرلىقلارنىڭ ئۆيلىرى ۋە ھەتتا ئۇلار تۇرۇۋاتقان تۇپراقمۇ كۆكۈيۈنلەر بىلەن تولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","لېكىن شۇ كۈنىدە ئۆز قوۋمىم تۇرۇۋاتقان گوشەن يۇرتىنى باشقىچە قىلىمەن؛ شۇنداق بولىدۇكى، ئۇ يەردە كۆكۈيۈنلەر تېپىلمايدۇ. شۇنىڭ بىلەن سەن مەن پەرۋەردىگارنىڭ بۇ زېمىندا بولغانلىقىمنى بىلىسەن. ");
INSERT INTO uigara_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","شۇنداق قىلىپ مەن ئۆز قوۋمىمنى سېنىڭ خەلقىڭدىن پەرقلەندۈرىمەن؛ بۇ مۆجىزىلىك ئالامەت ئەتە يۈز بېرىدۇ»، دەپ ئېيتقىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","پەرۋەردىگار دېگىنىنى قىلدى. پىرەۋننىڭ ئۆيلىرىگە، ئەمەلدارلىرىنىڭ ئۆيلىرىگە كۆكۈيۈنلەر توپ-توپ بولۇپ كىردى؛ پۈتكۈل مىسىر زېمىنىنىڭ ھەممە يېرى كۆكۈيۈنلەر تەرىپىدىن خاراب بولۇشقا باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","پىرەۋن مۇسا بىلەن ھارۇننى چاقىرتىپ كېلىپ ئۇلارغا: بېرىپ مۇشۇ زېمىندا خۇدايىڭلارغا قۇربانلىق ئۆتكۈزۈڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","لېكىن مۇسا جاۋاب بېرىپ: ــ بۇنداق قىلىش بىزگە تازا مۇۋاپىق بولمايدۇ؛ چۈنكى بىز پەرۋەردىگار خۇدايىمىزغا سۇنماقچى بولغان قۇربانلىق مال مىسىرلىقلارغا نىسبەتەن يىرگىنچلىكتۇر. ئەمدى ئەگەر بىز مىسىرلىقلارنىڭ كۆز ئالدىدا يامان كۆرۈنگەن نەرسىنى قۇربانلىق قىلساق ئۇلار بىزنى چالما-كېسەك قىلىۋەتمەمدۇ؟    ");
INSERT INTO uigara_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","بىز ئۈچ كۈنلۈك يولنى بېسىپ، چۆلدە پەرۋەردىگار خۇدايىمىز بىزگە بۇيرۇغىنىدەك ئۇنىڭغا قۇربانلىق سۇنۇشىمىز كېرەك، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","پىرەۋن: ــ سىلەرنى پەرۋەردىگار خۇدايىڭلارغا چۆلدە قۇربانلىق ئۆتكۈزۈشكە بارغىلى قويىمەن؛ پەقەت بەك يىراق كېتىپ قالماڭلار، مېنىڭ ئۈچۈن دۇئا قىلىڭلار، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","مۇسا جاۋاب بېرىپ: ــ مانا، مەن سېنىڭ ئالدىڭدىن چىقىپ پەرۋەردىگارغا ئىلتىجا قىلىمەن ۋە كۆكۈيۈنلەر سەن پىرەۋندىن، ئەمەلدارلىرىڭدىن ۋە خەلقىڭدىن ئەتە چىقىپ كېتىدۇ؛ لېكىن پىرەۋن يەنە ھىيلە ئىشلىتىپ، خەلقنى پەرۋەردىگارغا قۇربانلىق قىلىشقا بېرىشتىن توسقۇچى بولمىسۇن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","مۇسا پىرەۋننىڭ ئالدىدىن چىقىپ، پەرۋەردىگارغا شۇنداق ئىلتىجا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","پەرۋەردىگار مۇسا تىلىگىنىدەك قىلدى؛ ئۇ كۆكۈيۈنلەرنى پىرەۋن، ئەمەلدارلىرى ۋە خەلقىدىن چىقىرىۋەتتى؛ ھەتتا بىر تال كۆكۈيۈنمۇ قالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","لېكىن پىرەۋن بۇ قېتىممۇ كۆڭلىنى قاتتىق قىلىپ، قوۋمنى قويۇپ بەرمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ئاندىن پەرۋەردىگار مۇساغا: ــ پىرەۋننىڭ ئالدىغا بېرىپ ئۇنىڭغا: ــ «ئىبرانىيلارنىڭ خۇداسى پەرۋەردىگار مۇنداق دەيدۇ: ــ ماڭا ئىبادەت قىلىشىغا ئۆز قوۋمىمنى قويۇپ بەر. ");
INSERT INTO uigara_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ئەگەر ئۇلارنى قويۇپ بېرىشنى رەت قىلىپ، يەنىلا تۇتۇپ تۇرۇۋالىدىغان بولساڭ، ");
INSERT INTO uigara_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","مانا، پەرۋەردىگارنىڭ قولى ئېتىزلىقتىكى چارپايلىرىڭنىڭ ئۈستىگە، ئات-ئېشەكلەر، تۆگىلەر، ۋە قوي-كالىلىرىڭنىڭ ئۈستىگە چۈشۈپ ئىنتايىن ئېغىر بىر ۋابا كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","لېكىن پەرۋەردىگار ئىسرائىلنىڭ چارپايلىرىنى مىسىرلىقلارنىڭ چارپايلىرىدىن پەرقلەندۈرىدۇ. نەتىجىدە، ئىسرائىلنىڭ چارپايلىرىدىن ھېچبىرى ئۆلمەيدۇ» ــ دېگىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","پەرۋەردىگار ۋاقىتنى بېكىتىپ: ــ ئەتە پەرۋەردىگار زېمىندا بۇ ئىشنى قىلىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ئەتىسى پەرۋەردىگار شۇنداق قىلدى؛ مىسىرلىقلارنىڭ بارلىق چارپايلىرى ئۆلدى؛ لېكىن ئىسرائىللارنىڭ چارپايلىرىدىن بىرىمۇ ئۆلمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","پىرەۋن ئادەم ئەۋەتىپ تەكشۈرىۋىدى، مانا، ئىسرائىللارنىڭ چارپايلىرىدىن بىرىمۇ ئۆلمىگەنىدى. لېكىن پىرەۋننىڭ كۆڭلى قاتتىق قىلىنىپ، ئۇ قوۋمنى قويۇپ بەرمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ئاندىن پەرۋەردىگار مۇسا ۋە ھارۇنغا: ــ خۇمداننىڭ كۈلىدىن چاڭگىلىڭلارنى توشقۇزۇپ ئېلىڭلار، ئاندىن مۇسا ئۇنى پىرەۋننىڭ كۆز ئالدىدا ئاسمانغا قارىتىپ چاچسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","شۇنداق قىلىشى بىلەن كۈل پۈتكۈل مىسىر زېمىنىنى قاپلايدىغان چاڭ-توزان بولىدۇ ۋە مىسىر زېمىنىدىكى ھەممە يەردە ئادەملەر ۋە ھايۋانلارنىڭ بەدىنىگە چۈشۈشى بىلەن ھۈررەك-ھۈررەك چاقا چىقىرىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","شۇنىڭ بىلەن ئۇلار خۇمداندىن كۈل ئېلىپ، پىرەۋننىڭ ئالدىغا بېرىپ تۇردى ۋە مۇسا ئۇنى ئاسمانغا قارىتىپ چاچتى؛ ئۇ ئادەملەر ۋە ھايۋانلارنىڭ بەدىنىگە چۈشۈشى بىلەن ھۈررەك-ھۈررەك چاقا چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","جادۇگەرلەر چاقىلار دەستىدىن مۇسانىڭ ئالدىدا تۇرالماي قالدى؛ چۈنكى جادۇگەرلەرنىڭ بەدىنىنىمۇ، باشقا بارلىق مىسىرلىقلارنىمۇ ئوخشاش چاقا بېسىپ كەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","لېكىن پەرۋەردىگار پىرەۋننىڭ كۆڭلىنى قاتتىق قىلدى؛ شۇڭا پەرۋەردىگار دەل مۇساغا ئېيتقىنىدەك ئۇ ئۇلارغا قۇلاق سالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ئاندىن پەرۋەردىگار مۇساغا: ــ ئەتە تاڭ سەھەر قوپۇپ، پىرەۋننىڭ ئالدىدا تۇرۇپ ئۇنىڭغا: «ئىبرانىيلارنىڭ خۇداسى پەرۋەردىگار مۇنداق دەيدۇ: ــ قوۋمىمنى ماڭا ئىبادەت قىلىشقا قويۇپ بەر؛ ");
INSERT INTO uigara_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","چۈنكى مەن بۇ قېتىم ھەممە بالايىئاپەتلىرىمنى يۈرىكىڭگە، ئەمەلدارلىرىڭ ۋە پۇقرالىرىڭنىڭ ئۈستىگە ئەۋەتىمەن. بۇنىڭ بىلەن سەن پۈتكۈل يەر يۈزىدە مەندەك باشقا بىرىنىڭ يوق ئىكەنلىكىنى بىلىسەن. ");
INSERT INTO uigara_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","چۈنكى مەن قولۇمنى ئۇزىتىپ، ئۆزۈڭ ۋە قوۋمىڭنى ۋابا بىلەن ئۇرغان بولسامئىدى، بۇ ۋاقىتقىچە سەن يەر يۈزىدىن يوقىلىپ كېتەتتىڭ. ");
INSERT INTO uigara_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ھالبۇكى، مېنىڭ سېنى ئورنۇڭغا تىكلىشىمدىكى مەقسىتىم شۇ ئىدىكى، دەل ئۆز قۇدرىتىمنى ساڭا كۆرسىتىش، شۇنداقلا نامىمنىڭ پۈتكۈل يەر يۈزىدە جاكارلىنىشى ئۈچۈن ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","سەن يەنە قوۋمىمغا چوڭچىلىق قىلىپ، ئۇلارنى قويۇپ بېرىشنى رەت قىلىۋېرەمسەن؟ ");
INSERT INTO uigara_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","مانا، ئەتە مۇشۇ ۋاقىتلاردا مىسىر دۆلىتى بىنا بولغاندىن بۇيان ھېچ كۆرۈلۈپ باقمىغان قاتتىق مۆلدۈرنى ياغدۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","شۇنىڭ ئۈچۈن ئادەم ئەۋەتىپ، ھايۋان ۋە ئېتىزدا بار-يوقۇڭنى يىغىپ ئىچكىرى سولىغىن؛ چۈنكى ئۆيگە قايتۇرۇلماي سىرتتا قالغان ئادەم ۋە ھايۋانلارنىڭ ھەممىسى مۆلدۈرنىڭ ئاستىدا قېلىپ ئۆلۈپ كېتىدۇ! ــ دېگىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","بۇنى ئاڭلاپ پىرەۋننىڭ ئەمەلدارلىرىنىڭ ئارىسىدىن پەرۋەردىگارنىڭ سۆزىدىن قورققان ھەربىر ئادەم ئۆز قۇللىرى ۋە چارپايلىرىنى يۈگۈرتۈپ ئۆيلىرىگە ئېلىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","لېكىن پەرۋەردىگارنىڭ سۆزىنى ئېتىبارغا ئالمىغانلار ئۆز قۇل ۋە ماللىرىنى تاشقىرىدا قالدۇرۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","پەرۋەردىگار مۇساغا: ــ مىسىر زېمىنىدىكى ھەر يەردە، ئادەملەر ئۈستىگە، ماللارنىڭ ئۈستىگە، شۇنداقلا مىسىر زېمىنىدىكى دالالارنىڭ ھەممە ئوت-چۆپلىرىنىڭ ئۈستىگە مۆلدۈر ياغسۇن دەپ، ئاسمانغا قاراپ قولۇڭنى كۆتۈرگىن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","مۇسا شۇنىڭ بىلەن ھاسىسىنى ئاسمانغا قارىتىپ كۆتۈرۈۋىدى، پەرۋەردىگار گۈلدۈرمامىنى گۈلدۈرلىتىپ، مۆلدۈر ياغدۇردى، يەر يۈزىدە چاقماق چېقىندىلىرى چېپىپ يۈرەتتى. شۇنداق قىلىپ پەرۋەردىگار مىسىر زېمىنى ئۈستىگە مۆلدۈر ياغدۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","مۆلدۈر يېغىپ، مۆلدۈر بىلەن ئوت ئارىلاش چۈشتى؛ مۆلدۈر شۇنچە ئېغىر بولدىكى، مىسىر دۆلىتى بىنا بولغاندىن تارتىپ ئۇنداق قاتتىق مۆلدۈر يېغىپ باقمىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","مۆلدۈر پۈتكۈل مىسىر زېمىنىنىڭ ھەر يېرىدە چۈشۈپ، ئىنسان بولسۇن، ھايۋان بولسۇن، ھەممىسىنى ئۇردى؛ مۆلدۈر ئېتىزدىكى ھەممە ئوت-چۆپنى ئۇرۇپ، يەردىكى ھەممە دەل-دەرەخلەرنىمۇ سۇندۇرۇۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","پەقەت ئىسرائىللار ئولتۇرۇشلۇق گوشەن زېمىنىدىلا مۆلدۈر ياغمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","پىرەۋن ئادەم ئەۋەتىپ مۇسا بىلەن ھارۇننى چاقىرتىپ ئۇلارغا: ــ مەن بۇ قېتىم گۇناھ قىلدىم! پەرۋەردىگار ھەققانىيدۇر؛ سەۋەنلىك بولسا مەن ۋە خەلقىمدىن ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","يەنە بېرىپ پەرۋەردىگاردىن ئۆتۈنۈپ ئىلتىجا قىلىڭلار! خۇدادىن چىققان بۇ قاتتىق گۈلدۈرمامىلار ۋە مۆلدۈر يېتىپ ئاشتى! سىلەرنى قويۇپ بېرەي؛ سىلەر ئەمدى مۇشۇ يەردە تۇرىۋەرسەڭلار بولمايدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","مۇسا ئۇنىڭغا جاۋاب بېرىپ: ــ مەن شەھەردىن چىققاندا، پەرۋەردىگار تەرەپكە قاراپ قوللىرىمنى يېيىپ كۆتۈرىمەن؛ گۈلدۈرمامىلار شۇ ھامان بېسىقىپ مۆلدۈر يەنە ياغمايدۇ. يەر يۈزى پەرۋەردىگارنىڭكىدۇر، دەپ بىلىشىڭ ئۈچۈن شۇنداق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","لېكىن سەن ۋە سېنىڭ ئەمەلدارلىرىڭ، سىلەرنىڭ پەرۋەردىگار خۇدادىن تېخىچە قورقمايۋاتقىنىڭلارنى بىلىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","شۇ چاغدا ئارپا باش چىقىرىپ، زىغىر غۇنچىلىغان بولغاچقا، زىغىر ۋە ئارپا مۆلدۈردىن ۋەيران قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","لېكىن بۇغداي بىلەن قارا بۇغداي كېيىنرەك بىخ چىقارغاچقا، ۋەيران قىلىنمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","مۇسا پىرەۋننىڭ ئالدىدىن كېتىپ، شەھەردىن چىقىپ پەرۋەردىگار تەرەپكە قاراپ قوللىرىنى يېيىپ كۆتۈردى. شۇنىڭ بىلەن گۈلدۈرماما ۋە مۆلدۈر توختاپ، يامغۇر يەرگە يەنە تۆكۈلمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ئەمما پىرەۋن يامغۇر، مۆلدۈر ۋە گۈلدۈرمامىلارنىڭ توختىغىنىنى كۆرگەندە، يەنە گۇناھ سادىر قىلدى؛ ئۇمۇ، ئەمەلدارلىرىمۇ كۆڭلىنى قاتتىق قىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","بۇ تەرىقىدە پىرەۋننىڭ كۆڭلى قاتتىق تۇرۇۋېرىپ، پەرۋەردىگار مۇسانىڭ ۋاسىتىسى بىلەن ئېيتقاندەك، ئىسرائىللارنى قويۇپ بېرىشنى رەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ئاندىن پەرۋەردىگار مۇساغا: ــ پىرەۋننىڭ ئالدىغا بارغىن؛ چۈنكى ئۇلارنىڭ ئارىسىدا بۇ مۆجىزىلىك ئالامەتلەرنى كۆرسىتىشىم ئۈچۈن پىرەۋننىڭ كۆڭلىنى ۋە ئەمەلدارلىرىنىڭ كۆڭلىنى قاتتىق قىلىپ قويدۇم. ");
INSERT INTO uigara_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","بۇ ئىش بىلەن مېنىڭ مىسىرلىقلارنى قانداق رەسۋا قىلغانلىقىم ۋە ئۇلارنىڭ ئارىسىدا كۆرسەتكەن مۆجىزىلىك ئالامەتلىرىمنى سەن ئوغلۇڭنىڭ ئاندىن نەۋرەڭنىڭ قۇلىقىغا يەتكۈزىسەن. بۇنىڭ بىلەن مېنىڭ پەرۋەردىگار ئىكەنلىكىمنى بىلىسىلەر، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","شۇنىڭ بىلەن مۇسا بىلەن ھارۇن پىرەۋننىڭ ئالدىغا بېرىپ، ئۇنىڭغا: ــ ئىبرانىيلارنىڭ خۇداسى پەرۋەردىگار مۇنداق دەيدۇ: «ئۆزۈڭنى ئالدىمدا تۆۋەن تۇتۇشنى قاچانغىچە رەت قىلىسەن؟ ماڭا ئىبادەت قىلىش ئۈچۈن قوۋمىمنى قويۇپ بەر. ");
INSERT INTO uigara_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","چۈنكى ئەگەر سەن قوۋمىمنى قويۇپ بېرىشنى رەت قىلساڭ، مانا، مەن ئەتە سېنىڭ يۇرتۇڭغا چېكەتكە ئەۋەتىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ئۇلار سىلەر زېمىن يۈزىنى كۆرمىگۈدەك قىلىپ يېپىۋېتىدۇ، سىلەرنىڭ مۆلدۈردىن ئامان قالغان نەرسىلىرىڭلارنىمۇ، دالالاردا ئۆسكەن ھەممە دەل-دەرەخلىرىڭلارنىمۇ يەپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ئۇلار ئوردا-سارايلىرىڭغا، ئەمەلدارلىرىڭنىڭ سارايلىرى، شۇنداقلا بارلىق مىسىرلىقلارنىڭ ئۆيلىرىگە تولۇپ كېتىدۇ؛ بۇنداق ئاپەتنى ئاتا-بوۋاڭلىرىڭ ۋە ئاتا-بوۋىلىرىڭنىڭ ئاتا-بوۋىلىرىمۇ يەر يۈزىدە ئاپىرىدە بولغاندىن تارتىپ كۆرۈپ باقمىغان» ــ دېدى-دە، بۇرۇلۇپ پىرەۋننىڭ ئالدىدىن چىقىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","پىرەۋننىڭ ئەمەلدارلىرى ئۇنىڭغا: ــ بۇ ئادەم بىزگە قاچانغىچە تۇزاق بولار؟ ئۆز خۇداسى پەرۋەردىگارغا ئىبادەت قىلىشقا بۇ ئادەملەرنى قويۇپ بەرگەيلا! مىسىرنىڭ خاراب بولغىنىنى تېخىچە كۆرمەيۋاتامدىلا؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","شۇنىڭ بىلەن مۇسا بىلەن ھارۇن پىرەۋننىڭ ئالدىغا يەنە چاقىرىتىپ كېلىندى. ئۇ ئۇلارغا: ــ پەرۋەردىگارغا ئىبادەت قىلىش ئۈچۈن بېرىڭلار؛ لېكىن بارىدىغانلار زادى كىملەر؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","مۇسا جاۋاب بېرىپ: ــ ياشلىرىمىز ۋە قېرى-چۈرىلەر بىلەن، ئوغۇللىرىمىز ۋە قىزلىرىمىز بىلەن، قوي ۋە كالا پادىلىرىمىزنى ئېلىپ ھەممىمىز بارىمىز؛ چۈنكى بىز پەرۋەردىگار ئۈچۈن ھېيت ئۆتكۈزۈشىمىز كېرەك، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ئۇ ئۇلارغا: ــ سىلەرنى بالا-چاقاڭلار بىلەن قوشۇپ قويۇپ بەرگىنىمدە، پەرۋەردىگار سىلەر بىلەن بىللە بولغاي! مانا، ئالدىڭلاردا بالايىئاپەت تۇرۇپتۇ! ");
INSERT INTO uigara_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","يوقسۇ، بۇنداق قىلىشىڭلارغا بولمايدۇ! پەرۋەردىگارغا ئىبادەت قىلىشقا پەقەت ئاراڭلاردىن ئەر كىشىلەرلا بارسۇن! چۈنكى سىلەرنىڭ تەلىپىڭلار دەل شۇ ئەمەسمىدى! ــ دېدى-دە، ئۇلار پىرەۋننىڭ ئالدىدىن قوغلاپ چىقىرىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ئاندىن پەرۋەردىگار مۇساغا: ــ مىسىر زېمىنىنىڭ ئۈستىگە قولۇڭنى ئۇزاتقىن. شۇنداق قىلساڭ، چېكەتكىلەر مىسىر زېمىنىنى بېسىپ، زېمىندىكى ھەرخىل ئوتياشلارنى، يەنى مۆلدۈردىن ئامان قالغاننىڭ ھەممىسىنى يەپ كېتىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","مۇسا ھاسىسىنى مىسىر زېمىنىنىڭ ئۈستىگە ئۇزاتتى؛ پەرۋەردىگار شۇ كۈنى ۋە كېچىسى زېمىن ئۈستىگە شەرق شامىلى چىقاردى. سەھەردە، شەرق شامىلى چېكەتكىلەرنى ئۇچۇرۇپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","چېكەتكىلەر مىسىرنىڭ پۈتكۈل زېمىنىغا يېيىلىپ، مىسىرنىڭ پۈتۈن چېگرىسىنىمۇ باستى. ئاپەت ئىنتايىن ئېغىر بولدى؛ ئىلگىرى بۇنداق چېكەتكە ئاپىتى بولۇپ باقمىغان، مۇندىن كېيىنمۇ ئۇنىڭدەك بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ئۇلار پۈتكۈل زېمىننىڭ يۈزىنى قاپلىدى، يەر قاراڭغۇلىشىپ كەتتى؛ ئۇلار مۆلدۈردىن ئامان قالغان زېمىندىكى ھەممە ئوتياشلارنى ۋە دەل-دەرەخلەرنىڭ بارلىق مېۋىلىرىنى يەپ كەتتى. شۇنىڭ بىلەن پۈتكۈل مىسىر زېمىنى تەۋەسىدىكى دەل-دەرەخلەردە ياكى دالادىكى گۈل-گىياھلاردا ھېچ يېشىللىق قالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ئاندىن پىرەۋن ئالدىراپ-تېنەپ مۇسا بىلەن ھارۇننى چاقىرتىپ ئۇلارغا: ــ مەن ھەم خۇدايىڭلار پەرۋەردىگار ئالدىدا ھەم سىلەرنىڭ ئالدىڭلاردا گۇناھ قىلدىم. ");
INSERT INTO uigara_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ئەمدى مۇشۇ بىر قېتىم گۇناھىمدىن ئۆتۈپ پەرۋەردىگار خۇدايىڭلاردىن بۇ ئۆلۈمنى مەندىن ئېلىپ كېتىشىنى ئىلتىجا قىلىشىڭلارنى ئۆتۈنىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","شۇنىڭ بىلەن مۇسا پىرەۋننىڭ ئالدىدىن چىقىپ پەرۋەردىگارغا ئىلتىجا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","شۇنىڭ بىلەن پەرۋەردىگار شامالنى بۇراپ غەرب تەرەپتىن ئىنتايىن كۈچلۈك بوران چىقىرىپ، چېكەتكىلەرنى ئۇچۇرۇپ، قىزىل دېڭىزغا غەرق قىلدى؛ مىسىرنىڭ پۈتكۈل تەۋەسىدە بىر تالمۇ چېكەتكە قالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","لېكىن پەرۋەردىگار پىرەۋننىڭ كۆڭلىنى قاتتىق قىلىپ قويغىنى ئۈچۈن ئۇ ئىسرائىللارنى قويۇپ بەرمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ئاندىن پەرۋەردىگار مۇساغا: ــ قولۇڭنى ئاسمانغا قارىتىپ ئۇزاتقىن؛ شۇنىڭ بىلەن قاتتىق بىر قاراڭغۇلۇق بولىدۇ، ھەتتا ئادەم سىلىسا قولىغا تۇيۇلغۇدەك قويۇق قاراڭغۇلۇق مىسىر زېمىنىنى قاپلايدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ئاندىن مۇسا قولىنى ئاسمانغا قارىتىپ ئۇزىتىۋىدى، قويۇق بىر قاراڭغۇلۇق مىسىر زېمىنىنى ئۈچ كۈنگىچە قاپلاپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ئۈچ كۈنگىچە بىرى يەنە بىرىنى كۆرەلمەس ۋە يا ھېچكىم ئۆز جايىدىن قوزغىلالماس بولدى؛ لېكىن بارلىق ئىسرائىللار ئولتۇرغان جايلاردا يورۇقلۇق بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","پىرەۋن مۇسانى چاقىرتىپ ئۇنىڭغا: ــ بېرىپ، پەرۋەردىگارغا ئىبادەت قىلىڭلار. پەقەت قوي ۋە كالا پادىلىرىڭلار قالسۇن؛ بالا-چاقىلىرىڭلارنىمۇ ئېلىپ بارساڭلار بولىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","مۇسا جاۋابەن: ــ ئۇنداقتا خۇدايىمىز پەرۋەردىگارغا قۇربانلىق قىلىشقا ئىناقلىق قۇربانلىقى ۋە كۆيدۈرمە قۇربانلىقىغا لازىملىق چارپايلارنى سەن بىزگە بېرەمسەن؟ ");
INSERT INTO uigara_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ئۆزىمىزنىڭ چارپايلىرىمىز بىز بىلەن بىرگە كېتىشى كېرەك، بىر تۇيىقىمۇ كەينىدە قالسا بولمايدۇ؛ چۈنكى خۇدايىمىز پەرۋەردىگارغا ئىبادەت قىلىشقا قۇربانلىق قىلىدىغىنىمىزنى بۇلاردىن تاللىشىمىز لازىم. ئۇ يەرگە يېتىپ بارمىغۇچە، پەرۋەردىگارغا قايسى قۇربانلىقلار بىلەن ئىبادەت قىلىدىغىنىمىزنى بىلمەيمىز، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","لېكىن پەرۋەردىگار پىرەۋننىڭ كۆڭلىنى قاتتىق قىلدى؛ ئۇ ئۇلارنى يەنىلا قويۇپ بەرمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","پىرەۋن مۇساغا: ــ ئالدىمدىن يوقال! ھېزى بول، ئىككىنچى ماڭا كۆرۈنگۈچى بولما! چۈنكى يۈزۈمنى يەنە كۆرگەن كۈنۈڭ جېنىڭدىن ئايرىلىسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","مۇسا ئۇنىڭغا: ــ راست ئېيتتىڭ! مەن سېنىڭ يۈزۈڭنى ئىككىنچى كۆرگۈچى بولمايمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","شۇنىڭ بىلەن پەرۋەردىگار مۇساغا: ــ يەنە بىر ئاپەتنى پىرەۋننىڭ ئۈستىگە ۋە مىسىرنىڭ ئۈستىگە چۈشۈرىمەن. ئاندىن ئۇ سىلەرنى بۇ يەردىن كېتىشكە يول قويىدۇ ۋە ئۇ سىلەرنى ھەممە نەرسىلىرىڭلار بىلەن قوشۇپ قويۇپ بېرىپ، بۇ يەردىن مۇتلەق قوغلاپ چىقىرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ئەمدى سەن خەلققە تاپىلاپ: ــ ھەر بىرىڭلار، ئەر كىشىلەرنىڭ ھەربىرى ئۆز قوشنىسىدىن، ئايال كىشىلەرنىڭ ھەربىرى ئۆز قوشنىسىدىن كۈمۈش بۇيۇملارنى، ئالتۇن بۇيۇملارنى سوراپ ئالسۇن، دېگىن، ــ دېدى    ");
INSERT INTO uigara_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(پەرۋەردىگار خەلقىنى مىسىرلىقلارنىڭ ئالدىدا ئىلتىپات تاپقۇزدى. شۇنىڭدەك مۇسا دېگەن بۇ ئادەم مىسىر زېمىنىدا پىرەۋننىڭ ئەمەلدارلىرىنىڭ نەزىرىدە بولسۇن، پۇقرالارنىڭ نەزىرىدە بولسۇن، ناھايىتى ئۇلۇغ زات بولدى). ");
INSERT INTO uigara_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ئاندىن مۇسا يەنە: ــ پەرۋەردىگار مۇنداق دەيدۇ: ــ «مەن يېرىم كېچىدە چىقىپ مىسىرنى كېزىپ چىقىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","شۇ ۋاقىتتا تەختتە ئولتۇرۇۋاتقان پىرەۋننىڭ تۇنجى ئوغلىدىن تارتىپ يارغۇنچاق تارتىدىغان دېدەكنىڭ تۇنجى ئوغلىغىچە، شۇنداقلا بارلىق چارپايلارنىڭ تۇنجىلىرى، يەنى مىسىردىكى بارلىق تۇنجى جان ئىگىلىرى ئۆلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","بۇ سەۋەبتىن پۈتكۈل مىسىر زېمىنىدا قاتتىق بىر پەرياد كۆتۈرۈلىدۇ؛ ئۇنىڭدىن ئىلگىرى شۇنداق پەرياد بولۇپ باقمىغانىدى، مۇندىن كېيىنمۇ بۇنداق پەرياد ئاڭلانمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","لېكىن ئىسرائىللارغا، مەيلى ئادەملىرى، مەيلى ھايۋاناتلىرىغا بولسۇن، ھەتتا بىر تال ئىتمۇ قاۋاپ قويمايدۇ. بۇنىڭدىن پەرۋەردىگارنىڭ مىسىرلىقلار بىلەن ئىسرائىلنى پەرقلەندۈرىدىغانلىقىنى بىلىسىلەر». ");
INSERT INTO uigara_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ــ شۇنىڭ بىلەن بۇ ئەمەلدارلىرىڭنىڭ ھەممىسى ئالدىمغا كېلىپ، ماڭا تەزىم قىلىپ: «سىلى ئۆزلىرى ۋە سىلىگە ئەگەشكەن بارلىق قوۋملىرى چىقىپ كېتىشكەيلا!» دەپ ئېيتىدۇ، ئاندىن چىقىپ كېتىمەن» ــ دېدى-دە، قاتتىق غەزەپ بىلەن پىرەۋننىڭ ئالدىدىن چىقىپ كەتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","پەرۋەردىگار مۇساغا: ــ مىسىر زېمىنىدا مېنىڭ كارامەت مۆجىزىلىرىمنىڭ كۆپلەپ كۆرسىتىلىشى ئۈچۈن پىرەۋن سىلەرگە قۇلاق سالمايدۇ، ــ دېگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","مۇسا بىلەن ھارۇن بۇ كارامەت مۆجىزىلەرنىڭ ھەممىسىنى پىرەۋننىڭ ئالدىدا كۆرسىتىپ بولدى؛ لېكىن پەرۋەردىگار پىرەۋننىڭ كۆڭلىنى قاتتىق قىلىپ قويغىنى ئۈچۈن ئۇ ئىسرائىللارنى ئۇنىڭ زېمىنىدىن كەتكىلى قويمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","پەرۋەردىگار مىسىر يۇرتىدا مۇسا ۋە ھارۇنغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","بۇ ئاي سىلەرگە ئايلارنىڭ ئىچىدە بېشى، يىلنىڭ تۇنجى ئېيى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","سىلەر پۈتۈن ئىسرائىل جامائىتىگە سۆز قىلىپ: ــ بۇ ئاينىڭ ئونىنچى كۈنى ھەممىڭلار ئاتىلىرىڭلارنىڭ ئائىلىسى بويىچە بىر قوزىنى ئېلىڭلار؛ ھەربىر ئائىلىگە بىردىن قوزا ئېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ئەگەر مەلۇم بىر ئائىلە بىر قوزىنى يەپ بولالمىغۇدەك بولسا، ئۇنداقتا ئۆي ئىگىسى يېنىدىكى قوشنىسى بىلەن بىرلىشىپ ئادەم سانىغا قاراپ بىر قوزا ئېلىڭلار؛ ھەربىر كىشىنىڭ ئىشتىھاسىغا قاراپ ھېسابلاپ مۇۋاپىق بىر قوزا ھازىرلاڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ھەربىرىڭلار تاللايدىغان قوزاڭلار بېجىرىم، بىر ياشلىق ئەركەك بولسۇن؛ قوي ياكى ئۆچكە پادىلىرىدىن تاللانسىمۇ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","قوزىنى بۇ ئاينىڭ ئون تۆتىنچى كۈنىگىچە يېنىڭلاردا تۇرغۇزۇڭلار، ــ دېگىن. ــ شۇ كۈنى ئىسرائىلنىڭ پۈتكۈل جامائىتى تاللىغان مېلىنى گۇگۇمدا سويسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ئاندىن ئۇلار ئۇنىڭ قېنىدىن ئېلىپ گۆش يېيىلگەن ئۆينىڭ ئىشىكنىڭ باش تەرىپىگە ھەم ئىككى يان كېشىكىگە سۈركەپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ئۇلار شۇ كېچىسى گۆشىنى ئوتتا كاۋاپ قىلىپ يېسۇن؛ ئۇنى پېتىر نان ۋە ئاچچىق-چۈچۈك كۆكتات بىلەن قوشۇپ يېسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","قەتئىي خام ياكى سۇدا پىشۇرۇپ يېمەڭلار، بەلكى ئۇنى باش، پۇت ۋە ئىچ-قارىنلىرى بىلەن ئوتتا كاۋاپ قىلىپ يەڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ئۇنىڭ ھېچنېمىسىنى ئەتىگە قالدۇرماڭلار. ئەگەر ئەتىگە ئېشىپ قالغانلىرى بولسا، ئۇنى ئوتقا سېلىپ كۆيدۈرۈۋېتىڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","سىلەر ئۇنى مۇنداق ھالەتتە يەڭلار: ــ ئۇنى يېگەندە بەللىرىڭلارنى چىڭ باغلاپ، ئاياغلىرىڭلارغا كەش كىيىپ، قوللىرىڭلاردا ھاسا تۇتقان ھالدا تېز يەڭلار. ئۇ بولسا پەرۋەردىگارنىڭ «ئۆتۈپ كېتىش» قوزىسىدۇر. ");
INSERT INTO uigara_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","چۈنكى مەن ئۇ كېچىسى مىسىر زېمىنىنى كېزىپ ئۆتىمەن؛ مەن مىسىر زېمىنىدا مەيلى ئىنسان بولسۇن، مەيلى ھايۋان بولسۇن ئۇلارنىڭ تۇنجى تۇغۇلغان ئەركىكىنىڭ ھەممىسىنى ئۆلتۈرىمەن؛ شۇنىڭ بىلەن مەن مىسىرنىڭ بارلىق بۇت-ئىلاھلىرىنىڭ ئۈستىدىن ھۆكۈم چىقىرىمەن؛ مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","شۇ قۇربانلىقنىڭ قېنى سىلەر ئولتۇرغان ئۆيلەردە سىلەرگە نىجات بەلگىسى بولىدۇ؛ بۇ قانلارنى كۆرگىنىمدە سىلەرگە ئۆتۈپ تۇرىمەن. شۇنىڭ بىلەن مىسىر زېمىنىنى ئۇرغىنىمدا ھالاكەت ئېلىپ كېلىدىغان ۋابا-ئاپەت سىلەرگە تەگمەيدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","بۇ كۈن سىلەرگە خاتىرە كۈن بولسۇن؛ ئۇنى پەرۋەردىگارنىڭ ھېيتى سۈپىتىدە ئۆتكۈزۈپ تەبرىكلەڭلار؛ ئەبەدىي بەلگىلىمە سۈپىتىدە نەسىلدىن-نەسىلگە مەڭگۈ ئۆتكۈزۈڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","يەتتە كۈن پېتىر نان يەڭلار؛ بىرىنچى كۈنى ئۆيۈڭلاردىن بارلىق خېمىرتۇرۇچلارنى يوق قىلىڭلار؛ چۈنكى كىمكى بىرىنچى كۈندىن تارتىپ يەتتىنچى كۈنگىچە بولدۇرۇلغان نان يېسە، شۇ كىشى ئىسرائىل قاتارىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","بىرىنچى كۈنى سىلەر مۇقەددەس ئىبادەت سورۇنى تۈزۈڭلار؛ يەتتىنچى كۈنىمۇ ھەم شۇنداق بىر مۇقەددەس ئىبادەت سورۇنى ئۆتكۈزۈلسۇن. بۇ ئىككى كۈن ئىچىدە ھېچقانداق ئىش-ئەمگەك قىلىنمىسۇن؛ پەقەت ھەر كىشىنىڭ يەيدىغىنىنى تەييارلاشقا مۇناسىۋەتلىك ئىشلارنىلا قىلساڭلار بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","مەن دەل شۇ كۈنى سىلەرنى قوشۇن-قوشۇن بويىچە مىسىر زېمىنىدىن چىقارغىنىم ئۈچۈن سىلەر پېتىر نان ھېيتىنى ئۆتكۈزۈڭلار؛ شۇ كۈننى نەسىلدىن-نەسىلگە ئەبەدىي بەلگىلىمە سۈپىتىدە ھېيت كۈنى قىلىپ بېكىتىڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","بىرىنچى ئاينىڭ ئون تۆتىنچى كۈنى، كەچقۇرۇندىن تارتىپ شۇ ئاينىڭ يىگىرمە بىرىنچى كۈنى كەچقۇرۇنغىچە، پېتىر نان يەڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","يەتتە كۈن ئىچىدە ئۆيلىرىڭلاردا ھېچ خېمىرتۇرۇچ بولمىسۇن؛ چۈنكى مۇساپىر بولسۇن، زېمىندا تۇغۇلغان بولسۇن، كىمكى بولدۇرۇلغان نەرسىلەرنى يېسە شۇ كىشى ئىسرائىل جامائىتىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","سىلەر ھېچقانداق بولدۇرۇلغان نەرسىنى يېمەي، قەيەردىلا تۇرساڭلار، پېتىر نان يەڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","مۇسا ئىسرائىلنىڭ بارلىق ئاقساقاللىرىنى چاقىرىپ ئۇلارغا: ــ بېرىپ ھەربىرىڭلارنىڭ ئائىلىسى بويىچە ئۆزۈڭلارغا بىر قوزىنى تارتىپ چىقىرىپ پاسخا قوزىسىنى سويۇڭلار.    ");
INSERT INTO uigara_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ئاندىن بىر تۇتام زۇپا ئېلىپ ئۇنى قاچىدىكى قانغا چىلاپ، قاچىدىكى قاننى ئىشىكنىڭ بېشى ۋە ئىككى كېشىكىگە سۈركەڭلار. سىلەردىن ئەتىگەنگىچە ھېچكىم ئۆيىنىڭ ئىشىكىدىن قەتئىي چىقمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","چۈنكى پەرۋەردىگار مىسىرلىقلارنى ئۇرۇپ ھالاك قىلىش ئۈچۈن، زېمىننى كېزىپ ئۆتىدۇ؛ ئۇ ئىشىكنىڭ بېشى ۋە ئىككى كېشىكىدىكى قاننى كۆرگەندە، پەرۋەردىگار ھالاك قىلغۇچىنىڭ ئۆيلىرىڭلارغا كىرىپ سىلەرنى ئۇرۇشىدىن توسۇش ئۈچۈن مۇھاپىزەت قىلىپ ئىشىكنىڭ ئالدىغا ئۆتۈپ تۇرىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","بۇ رەسىم-قائىدىنى ئۆزۈڭلار ۋە بالىلىرىڭلار ئۈچۈن ئەبەدىي بىر بەلگىلىمە سۈپىتىدە تۇتۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","سىلەر پەرۋەردىگار ئۆز ۋەدىسى بويىچە سىلەرگە بېرىدىغان زېمىنغا كىرگىنىڭلاردا بۇ ھېيتلىق ئىبادەتنى تۇتۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","بالىلىرىڭلار سىلەردىن: «بۇ ئىبادىتىڭلارنىڭ مەنىسى نېمە؟» ــ دەپ سورىسا، ");
INSERT INTO uigara_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","سىلەر: «بۇ مىسىرلىقلارنى ئۇرغىنىدا، مىسىردا ئىسرائىللارنىڭ ئۆيلىرىنىڭ ئالدىغا ئۆتۈپ تۇرۇپ، بىزنىڭ ئۆيدىكىلىرىمىزنى قۇتقۇزغان پەرۋەردىگارغا بولغان «ئۆتۈپ كېتىش» قۇربانلىقى بولىدۇ» ــ دەڭلار. شۇنى ئاڭلىغاندا، خەلق ئېڭىشىپ خۇداغا سەجدە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ئاندىن ئىسرائىللار قايتىپ بېرىپ، پەرۋەردىگار دەل مۇسا بىلەن ھارۇنغا ئەمر قىلغاندەك ئىش كۆردى. ");
INSERT INTO uigara_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ۋە شۇنداق بولدىكى، يېرىم كېچە بولغاندا، پەرۋەردىگار پىرەۋننىڭ تەختىدە ئولتۇرۇۋاتقان تۇنجىسىدىن تارتىپ زىنداندا يېتىۋاتقان مەھبۇسنىڭ تۇنجىسىغىچە، مىسىر زېمىنىدىكى تۇنجى ئوغۇللارنىڭ ھەممىسىنى ئۇرۇپ ئۆلتۈردى، شۇنداقلا ئۇ ھايۋاناتلارنىڭ تۇنجى تۇغۇلغانلىرىنىڭمۇ ھەممىسىنى ئۆلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ئادەم ئۆلمىگەن بىرمۇ ئۆي قالمىغاچقا، شۇ كېچىسى پىرەۋننىڭ ئۆزى، ئۇنىڭ بارلىق ئەمەلدارلىرى ۋە بارلىق مىسىرلىقلار كېچىدە ئورنىدىن قوپتى؛ مىسىر زېمىنىدا ئىنتايىن قاتتىق پەرياد كۆتۈرۈلدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","پىرەۋن كېچىدە مۇسا بىلەن ھارۇننى چاقىرتىپ: ــ تۇرۇڭلار، سىلەر ۋە ئىسرائىللار بىلەن بىللە مېنىڭ خەلقىمنىڭ ئارىسىدىن چىقىپ كېتىڭلار؛ ئېيتقىنىڭلاردەك بېرىپ، پەرۋەردىگارغا ئىبادەت قىلىڭلار! ");
INSERT INTO uigara_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","سىلەرنىڭ دېگىنىڭلار بويىچە قوي، ئۆچكە، كالا پادىلىرىنىمۇ ئېلىپ كېتىڭلار؛ مەن ئۈچۈنمۇ بەخت-بەرىكەت تىلەڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","مىسىرلىق پۇقرالارمۇ «ھەممىمىز ئۆلۈپ كەتكۈدەكمىز» دېيىشىپ، خەلقنى زېمىندىن تېز چىقىرىۋېتىش ئۈچۈن ئۇلارنى كېتىشكە ئالدىراتتى. ");
INSERT INTO uigara_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","خەلق تېخى بولمىغان خېمىرلىرىنى ئېلىپ، ئۇنى تەڭنىلەرگە سېلىپ، كىيىم-كېچەكلىرى بىلەن يۆگەپ، مۈرىلىرىگە ئېلىپ كۆتۈرۈپ مېڭىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ئىسرائىللار مۇسانىڭ تاپىلىغىنى بويىچە قىلىپ، مىسىرلىقلاردىن كۈمۈش بۇيۇملار، ئالتۇن بۇيۇملار ۋە كىيىم-كېچەكلەرنى سوراپ ئېلىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","پەرۋەردىگار خەلقنى مىسىرلىقلارنىڭ كۆز ئالدىدا ئىلتىپات تاپقۇزغىنى ئۈچۈن مىسىرلىقلار ئۇلارنىڭ ئۆزلىرىدىن سورىغانلىرىنى بەردى؛ شۇنداق قىلىپ ئىسرائىللار مىسىرلىقلاردىن غەنىيمەتلەرنى ئېلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","شۇنىڭ بىلەن ئىسرائىللار بالىلارنى ھېسابقا ئالمىغاندا ئالتە يۈز مىڭچە ئەركەك بولۇپ، رامسەستىن چىقىپ، سۇككوت شەھىرىگىچە پىيادە ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ئۇلار بىلەن بىللە چوڭ بىر توپ شالغۇت خەلقمۇ ئۇلارغا قوشۇلۇپ ماڭدى، يەنە نۇرغۇن چارۋىلار، كۆپلىگەن كالا-قوي پادىلىرى بىلەن بىللە چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","مىسىردىن ئالغاچ چىققان خېمىردىن ئۇلار پېتىر نان-توقاچلارنى ئەتتى؛ چۈنكى ئۇلار مىسىردا بىردەم-يېرىم دەم تۇرغۇزۇلماي ھەيدەلگىنى ئۈچۈن خېمىر بولمىغانىدى؛ ئۇلار ئۆزلىرى ئۈچۈن يېمەكلىك تەييارلىۋېلىشقىمۇ ئۈلگۈرەلمىگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ئىسرائىللارنىڭ مىسىردا مۇساپىر بولۇپ تۇرغان ۋاقتى جەمئىي تۆت يۈز ئوتتۇز يىل بولدى.    ");
INSERT INTO uigara_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","شۇنداق بولدىكى، شۇ تۆت يۈز ئوتتۇز يىل توشقاندا، دەل شۇ كۈنىدە پەرۋەردىگارنىڭ بارلىق قوشۇنلىرى مىسىر زېمىنىدىن چىقىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","شۇ كۈنى كېچىدە ئۇلار مىسىر زېمىنىدىن چىقىرىلغىنى ئۈچۈن، شۇ كېچىنى ئۇلار پەرۋەردىگارنىڭ كېچىسى دەپ تۇتۇشى كېرەك؛ شۇ كېچىنى بارلىق ئىسرائىللار ئەۋلادتىن ئەۋلادقىچە پەرۋەردىگارغا ئاتاپ تۇتۇپ، تۈنىشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","پەرۋەردىگار مۇسا بىلەن ھارۇنغا مۇنداق دېگەنىدى: ــ پاسخا قوزىسى توغرىسىدىكى بەلگىلىمە شۇ بولسۇنكى،: ــ ھېچقانداق يات ئەللىك ئادەم ئۇنىڭدىن يېمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","لېكىن ھەركىمنىڭ پۇلغا سېتىۋالغان قۇلى بولسا، ئۇ خەتنە قىلىنسۇن، ئاندىن ئۇنىڭدىن يېسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ئەمما ئۆيۈڭلاردا ۋاقىتلىق تۇرۇۋاتقان مۇساپىر ياكى مەدىكار بۇنىڭدىن يېسە بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","گۆشنى باشقا بىر ئۆيگە ئېلىپ چىقمىغىن؛ بىرلا ئۆيدە يېيىلسۇن؛ قوزىنىڭ ھېچبىر سۆڭىكى سۇندۇرۇلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","پۈتكۈل ئىسرائىل جامائىتى بۇ ھېيتنى ئۆتكۈزسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ئەگەر سېنىڭ بىلەن بىرگە تۇرغان مۇساپىر بولسا، پەرۋەردىگارغا ئاتاپ پاسخا ھېيتىنى ئۆتكۈزمەكچى بولسا، ئۇنداقتا ئالدى بىلەن بارلىق ئەركەكلىرى خەتنە قىلىنسۇن؛ ئاندىن كېلىپ ھېيت ئۆتكۈزسۇن. ئۇ زېمىندا تۇغۇلغان كىشىدەك سانالسۇن. لېكىن ھېچبىر خەتنىسىز ئادەم ئۇنىڭدىن يېمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","زېمىندا تۇغۇلغان كىشى ھەم ئاراڭلاردا تۇرغان مۇساپىر ئۈچۈن ئوخشاش قانۇن-بەلگىلىمە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","شۇنىڭ بىلەن ئىسرائىللارنىڭ ھەممىسى دەل پەرۋەردىگار مۇسا بىلەن ھارۇنغا بۇيرۇغاندەك شۇ ئىشلارنى ئادا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","شۇ كۈننىڭ ئۆزىدە پەرۋەردىگار ئىسرائىللارنى قوشۇن-قوشۇن بويىچە مىسىر زېمىنىدىن چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","پەرۋەردىگار مۇساغا: ");
INSERT INTO uigara_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","ــ ئىسرائىللار ئارىسىدا بالىياتقۇنىڭ بارلىق تۇنجى ئەركەك مېۋىسىنى، مەيلى ئۇ ئىنساننىڭ ياكى ھايۋاننىڭ بولسۇن، ماڭا ئاتاپ مۇقەددەس قىلغىن؛ ئۇ ماڭا مەنسۇپتۇر، دېگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","مۇسا خەلقكە مۇنداق دېدى: ــ سىلەر مىسىردىن ئىبارەت «قۇللۇق ماكانى»دىن چىققان بۇ كۈننى ياد ئېتىڭلار؛ چۈنكى پەرۋەردىگار سىلەرنى بۇ يەردىن قۇدرەتلىك قولى بىلەن چىقاردى. بۇنىڭ ئۈچۈن ھېچ بولدۇرۇلغان نەرسە يېيىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ئابىب ئېيىنىڭ بۈگۈنكى كۈنى يولغا چىققان كۈن.    ");
INSERT INTO uigara_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ئەمدى پەرۋەردىگار ساڭا بېرىشكە ئاتا-بوۋىلىرىڭغا قەسەم قىلغان، سۈت بىلەن ھەسەل ئېقىپ تۇرىدىغان زېمىنغا، يەنى قانائانىي، ھىتتىي، ئامورىي، ھىۋىي ۋە يەبۇسىيلارنىڭ زېمىنىغا سېنى ئېلىپ بارغىنىدا مۇشۇ ئابىب ئېيىدا شۇ ئىبادەتنى تۇتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","يەتتە كۈنگىچە پېتىر نان يەڭلار؛ يەتتىنچى كۈنىدە پەرۋەردىگارغا ئالاھىدە ئاتىغان ھېيت ئۆتكۈزۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","يەتتە كۈن ئىچىدە پېتىر نان يېيىلسۇن؛ سىلەرنىڭ ئاراڭلاردا ھېچقانداق بولدۇرۇلغان نان تېپىلمىسۇن ۋە يا چېگرىلىرىڭ ئىچىدە ھېچ خېمىرتۇرۇچمۇ كۆرۈنمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","شۇ كۈنى سەن ئۆز ئوغلۇڭغا: «مىسىردىن چىققىنىمدا پەرۋەردىگارنىڭ ماڭا كۆرسەتكەن ئىلتىپاتىنى ياد قىلىپ تەشەككۇر بىلدۈرۈش ئۈچۈن، بۇ ھېيتنى ئۆتكۈزىمەن»، دەپ چۈشەندۈرگىن. ");
INSERT INTO uigara_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","پەرۋەردىگارنىڭ قانۇن-تەلىمىنىڭ ھەمىشە ئاغزىڭدىن چۈشمەسلىكى ئۈچۈن، بۇ بەلگىلىمىنى قولۇڭغا بەلگە قىلىپ سېلىۋال، پېشانەڭگە قاشقىدەك ئەسلەتمە قىلىپ ئورنىتىۋال؛ چۈنكى پەرۋەردىگار سېنى قۇدرەتلىك قولى بىلەن مىسىردىن چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ئەمدى بۇ بەلگىلىمىنى يىلمۇ-يىل بېكىتىلگەن ۋاقتىدا تۇتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","پەرۋەردىگار سەن بىلەن ئاتا-بوۋىلىرىڭغا قىلغان قەسىمى بويىچە سېنى قانائانىيلارنىڭ زېمىنىغا ئېلىپ بېرىپ، ئۇنى ساڭا تەقدىم قىلغاندىن كېيىن، شۇنداق قىلىشىڭ كېرەك: ــ ");
INSERT INTO uigara_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","بارلىق بالىياتقۇنىڭ تۇنجى مېۋىسىنى پەرۋەردىگارغا ئاتاپ سۇنىسەن؛ شۇنداقلا چارپاي مېلىڭنىڭ ھەممە تۇنجى ئەركەكلىرىمۇ پەرۋەردىگارغا مەنسۇپ بولسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ئەمما ئېشەكلەرنىڭ ھەممە تۇنجىلىرىنىڭ ئورنىغا بىردىن قوزا بەرگىن. ئەگەر ئۇنىڭ ئورنىغا بىرنەرسە بەرمىسەڭ، ئۇنىڭ بوينىنى سۇندۇرۇۋەتكىن. ئوغۇللىرىڭلار ئارىسىدا بارلىق تۇنجىلىرىنىڭ ئورنىغا ھۆرلۈك بەدىلى تۆلۈشۈڭ كېرەك. ");
INSERT INTO uigara_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","كېيىنكى كۈنلەردە ئوغلۇڭ سەندىن: «بۇنىڭ مەنىسى نېمىدۇر»، دەپ سورىسا، سەن ئۇنىڭغا جاۋاب بېرىپ: «پەرۋەردىگار قۇدرەتلىك قولى بىلەن بىزنى مىسىردىن چىقىرىپ، «قۇللۇق ماكانى»دىن ئازاد قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","شۇنداق بولدىكى، پىرەۋن بوينى قاتتىقلىق قىلىپ بىزنى قويۇپ بېرىشنى رەت قىلغىنىدا، پەرۋەردىگار مىسىر زېمىنىدىكى بارلىق تۇنجى تۇغۇلغانلارنى، ئىنساننىڭ بولسۇن، مالنىڭ بولسۇن، ھەممىسىنى ئۇرۇپ ئۆلتۈردى؛ بۇنىڭ ئۈچۈن مەن مالنىڭ بالىياتقۇسىنىڭ تۇنجى مېۋىسىنى، يەنى ھەممە تۇنجى تۇغۇلغان ئەركەكلىرىنى پەرۋەردىگارغا ئاتاپ قۇربانلىق قىلىپ سۇنىمەن ۋە ئوغۇللىرىمنىڭ ھەربىر تۇنجىلىرى ئۈچۈن ھۆرلۈك بەدىلى تۆلەپ بېرىمەن»، دەپ ئېيتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","بۇ بەلگىلىمىنى قولۇڭغا ئەسلەتمە-بەلگە قىلىپ سېلىۋال، پېشانەڭگە قاشقىدەك ئەسلەتمە قىلىپ ئورنىتىۋال، چۈنكى پەرۋەردىگار قۇدرەتلىك قولى بىلەن بىزنى مىسىردىن چىقاردى» ــ دېگىن. ");
INSERT INTO uigara_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ئەمما پىرەۋن خەلقنى كېتىشكە قويغاندىن كېيىن، فىلىستىيلەرنىڭ زېمىنىدىكى يول يېقىن بولسىمۇ، خۇدا ئۇلارنى شۇ يول بىلەن باشلىمىدى؛ چۈنكى ئۇ: «خەلقىم جەڭگە ئۇچراپ قالسا، قورقۇپ پۇشايمان قىلىپ، مىسىرغا يېنىپ كېتىشى مۇمكىن» دەپ ئويلىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","شۇ سەۋەبتىن خۇدا خەلقنى ئايلاندۇرۇپ، قىزىل دېڭىز تەرەپتىكى چۆلنىڭ يولى بىلەن باشلاپ ماڭدى. شۇنداق قىلىپ ئىسرائىللار مىسىردىن چىققىنىدا، قوراللىنىپ جەڭگە تەييار بولۇپ تەرتىپ بىلەن ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","مۇسا يۈسۈپنىڭ سۆڭەكلىرىنىمۇ بىللە ئېلىۋالدى؛ چۈنكى يۈسۈپ ئەسلىدە ئىسرائىلنىڭ ئوغۇللىرى بولغان قېرىنداشلىرىنى: «خۇدا چوقۇم سىلەرنى يوقلاپ ھالىڭلاردىن خەۋەر ئالىدۇ؛ شۇ چاغدا سىلەر مېنىڭ سۆڭەكلىرىمنى مۇشۇ يەردىن بىللە ئېلىپ كېتىڭلار» دەپ قەسەم قىلدۇرغانىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ئاندىن ئۇلار سۇككوتتىن چىقىپ، چۆلنىڭ چېتىدىكى ئېتام دېگەن يەردە چېدىرلىرىنى تىكتى. ");
INSERT INTO uigara_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ئەمدى پەرۋەردىگار ئۇلارغا يول كۆرسىتىشكە كۈندۈزى بىر بۇلۇت تۈۋرۈكىدە، كېچىسى يورۇقلۇق بېرىشكە ئوت تۈۋرۈكىدە بولۇپ ئۇلارنىڭ ئالدىدا يۈرەتتى. شۇنىڭ بىلەن ئۇلار كېچە-كۈندۈز يول يۈرەلەيتتى. ");
INSERT INTO uigara_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","بۇلۇت تۈۋرۈكى كۈندۈزى، ئوت تۈۋرۈكى كېچىسى خەلقتىن ئايرىلماي، ئالدىدا يۈرەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","پەرۋەردىگار مۇساغا: ");
INSERT INTO uigara_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","ــ سەن ئىسرائىللارغا: «سىلەر بۇرۇلۇپ مىگدول بىلەن دېڭىزنىڭ ئارىلىقىدىكى پى-ھاھىروتنىڭ ئالدىغا بېرىپ چېدىر تىكىڭلار؛ بائال-زېفوننىڭ ئۇدۇلىدىكى دېڭىزنىڭ بويىدا چېدىر تىكىڭلار»، دېگىن.    ");
INSERT INTO uigara_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","شۇنىڭ بىلەن پىرەۋن: «ئىسرائىللار زېمىندا ئېزىپ قالدى، چۆلنىڭ ئىچىدە قامىلىپ قالدى» دەپ ئويلايدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ئىسرائىللارنى قوغلىسۇن دەپ مەن پىرەۋننىڭ كۆڭلىنى قاتتىق قىلىمەن؛ شۇنداق قىلىپ، مەن پىرەۋن ۋە ئۇنىڭ پۈتكۈل قوشۇنلىرى ئارقىلىق ئۆز ئۇلۇغلۇقۇمنى ئايان قىلىمەن؛ ۋە مىسىرلىقلار مېنىڭ پەرۋەردىگار ئىكەنلىكىمنى بىلىدۇ، ــ دېدى. ئىسرائىللار خۇدانىڭ سۆزى بويىچە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","«ئۇ خەلق قېچىپ كەتتى» دەپ مىسىرنىڭ پادىشاھىغا خەۋەر بېرىلىۋىدى، پىرەۋن بىلەن ئەمەلدارلىرى خەلق توغرىسىدىكى قارارىدىن يېنىپ: «ئىسرائىللارنى قۇللۇقتىن قويۇۋەتكىنىمىز، بۇ زادى نېمە قىلغىنىمىز؟!» ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","پىرەۋن دەرھال جەڭ ھارۋىسىنى قوشتۇرۇپ، ئۆز خەلقىنى باشلاپ يولغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ئۇ يەنە ئالتە يۈز خىللانغان جەڭ ھارۋىسى، شۇنداقلا مىسىردىكى بارلىق جەڭ ھارۋىلىرىنى يىغدۇرۇپ، ئۇلارنىڭ ھەربىرىگە لەشكەر باشلىقلىرىنى ئولتۇرغۇزۇپ ئېلىپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","پەرۋەردىگار مىسىرنىڭ پادىشاھى پىرەۋننىڭ كۆڭلىنى قاتتىق قىلغىنى ئۈچۈن، ئۇ ئىسرائىللارنى قوغلىدى. بۇ چاغدا ئىسرائىللار قوللىرىنى ئېگىز كۆتۈرۈشكەن ھالدا مىسىردىن چىقىپ بولغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","مىسىرلىقلارنىڭ ھەممىسى يەنى پىرەۋننىڭ بارلىق ئاتلىرى بىلەن جەڭ ھارۋىلىرى، ئاتلىق لەشكەرلىرى بىلەن پۈتكۈل قوشۇنى ئۇلارنى قوغلاپ، ئىسرائىللار دېڭىز بويىغا چېدىر تىككەن جايدا، يەنى پى-ھاھىروتنىڭ يېنىدا، بائال-زېفوننىڭ ئۇدۇلىدا ئۇلارغا يېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","پىرەۋن يېقىنلاشقاندا، ئىسرائىللار بېشىنى كۆتۈرۈپ قارىۋىدى، مانا، مىسىرلىقلار ئۇلارنىڭ ئارقىسىدىن يۈرۈش قىلىپ قوغلاپ كېلىۋاتاتتى! شۇنى كۆرگەندە ئىسرائىللار تولىمۇ قورقۇشۇپ، پەرۋەردىگارغا نىدا-پەرياد كۆتۈردى. ");
INSERT INTO uigara_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ئۇلار مۇساغا: ــ مىسىردا گۆرىستان تېپىلماسمىدى، سەن بىزنى چۆلدە ئۆلسۇن دەپ مۇشۇ يەرگە ئېلىپ كەلدىڭغۇ؟! بىزنى مىسىردىن ئېلىپ چىقىپ، بىزگە مۇنداق قىلغىنىڭ نېمىسى؟! ");
INSERT INTO uigara_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","مىسىردا تۇرغان ۋاقتىمىزدا بىز ساڭا: «بىزنى مىسىرلىقلارنىڭ قۇللۇقىدا بولۇشىمىزغا قويغىن، بىز بىلەن كارىڭ بولمىسۇن» دەپ ئېيتمىغانمىدۇق؟ مىسىرلىقلارنىڭ قۇللۇقىدا بولغىنىمىز چۆلگە كېلىپ ئۆلگىنىمىزدىن ئەۋزەل بولاتتى! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","بۇنىڭ بىلەن مۇسا خەلققە: ــ قورقماي، تىك تۇرۇڭلار، پەرۋەردىگارنىڭ بۈگۈن سىلەرگە يۈرگۈزىدىغان نىجاتىنى كۆرىسىلەر؛ چۈنكى سىلەر بۈگۈن كۆرگەن مىسىرلىقلارنى ئىككىنچى كۆرمەيسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","پەرۋەردىگار سىلەر ئۈچۈن جەڭ قىلىدۇ، لېكىن سىلەر بولساڭلار جىم تۇرساڭلارلا بولدى، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ئاندىن پەرۋەردىگار مۇساغا: ــ نېمىشقا سەن ماڭا پەرياد كۆتۈرىسەن؟ ئىسرائىللارغا: «ئالدىغا مېڭىڭلار» دەپ بۇيرۇغىن. ");
INSERT INTO uigara_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","لېكىن سەن ھاساڭنى كۆتۈرۈپ قولۇڭنى دېڭىزغا ئۇزىتىپ، ئۇنى ئىككىگە بۆلگىن؛ شۇنداقتا، ئىسرائىللار دېڭىزنىڭ ئوتتۇرىسىدىن قۇرۇق يەر بىلەن ئۆتۈپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","مانا، مەن ئۇلارنى قوغلىسۇن دەپ مىسىرلىقلارنىڭ كۆڭۈللىرىنى قاتتىق قىلىمەن، شۇنىڭ بىلەن مەن پىرەۋن ۋە ئۇنىڭ پۈتكۈل قوشۇنى، جەڭ ھارۋىلىرى ۋە ئاتلىقلىرى ئارقىلىق ئۆز ئۇلۇغلۇقىمنى ئايان قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","شۇنداق قىلىپ، مەن پىرەۋن ۋە ئۇنىڭ جەڭ ھارۋىلىرى ۋە ئاتلىقلىرى ئارقىلىق ئۆز ئۇلۇغلۇقىمنى ئايان قىلغىنىمدا، مىسىرلىقلار مېنىڭ پەرۋەردىگار ئىكەنلىكىمنى بىلىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ئىسرائىلنىڭ قوشۇنىنىڭ ئالدىدا يۈرۈۋاتقان خۇدانىڭ پەرىشتىسى ئەمدى ئۇلارنىڭ كەينىگە ئۆتتى؛ شۇنىڭدەك ئۇلارنىڭ ئالدىدا ماڭغان بۇلۇت تۈۋرۈكىمۇ ئۇلارنىڭ كەينىگە يۆتكىلىپ، ");
INSERT INTO uigara_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","مىسىرلىقلارنىڭ چېدىرگاھى بىلەن ئىسرائىلنىڭ چېدىرگاھىنىڭ ئارىلىقىدا توختىدى؛ بۇ بۇلۇت بىر تەرەپتە قاراڭغۇلۇق چۈشۈرۈپ، يەنە بىر تەرەپتە كېچىنى يورۇتتى. بۇنىڭ بىلەن پۈتۈن بىر كېچە بىر قوشۇن يەنە بىر قوشۇنغا يېقىن كېلەلمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","مۇسا قولىنى دېڭىزنىڭ ئۈستىگە ئۇزاتتى؛ پەرۋەردىگار پۈتۈن كېچە شەرقتىن كۈچلۈك بىر شامال چىقىرىپ، دېڭىزنىڭ سۈيىنى كەينىگە ياندۇردى؛ ئۇ سۇنى ياندۇرۇپ دېڭىزنى قۇرۇق يەر قىلدى، سۇلار ئىككىگە بۆلۈندى. ");
INSERT INTO uigara_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","شۇ تەرىقىدە ئىسرائىللار دېڭىزنىڭ ئوتتۇرىسىدىكى قۇرۇق يەردىن مېڭىپ، ئۆتۈپ كەتتى؛ سۇلار بولسا ئۇلارنىڭ ئوڭ ۋە سول يېنىدا كۆتۈرۈلۈپ تامدەك تۇراتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ئەمما مىسىرلىقلار ئۇلارنى قوغلاپ كېلىۋاتاتتى ــ پىرەۋننىڭ بارلىق ئاتلىرى، جەڭ ھارۋىلىرى ۋە ئاتلىق لەشكەرلىرى ئۇلارنىڭ كەينىدىن دېڭىزنىڭ ئوتتۇرىسىغىچە كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","تاڭ ئاتقاندا شۇنداق بولدىكى، پەرۋەردىگار ئوت بىلەن بۇلۇت تۈۋرۈكىدە تۇرۇپ مىسىرلىقلارنىڭ قوشۇنىغا قارىدى ۋە مىسىرلىقلارنىڭ قوشۇنىغا پاراكەندىچىلىك چۈشۈردى. ");
INSERT INTO uigara_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ئۇ ئۇلارنىڭ ھارۋىلىرىنىڭ چاقلىرىنى پاتقۇزۇپ، ھەيدەپ مېڭىشىنى مۈشكۈل قىلدى. مىسىرلىقلار: ــ يۈرۈڭلار، ئىسرائىلنىڭ ئالدىدىن قاچايلى، چۈنكى پەرۋەردىگار ئۇلار ئۈچۈن مىسىرلىقلارغا قارشى جەڭ قىلىۋاتىدۇ، ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","پەرۋەردىگار مۇساغا: ــ سۇلار يېنىپ مىسىرلىقلارنىڭ ئۈستىگە، ئۇلارنىڭ جەڭ ھارۋىلىرىنىڭ ئۈستىگە ۋە ئاتلىقلىرىنىڭ ئۈستىگە ئېقىپ بېرىپ، ئۇلارنى چۆكتۈرۈۋەتسۇن دەپ قولۇڭنى دېڭىزنىڭ ئۈستىگە ئۇزاتقىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","مۇسا قولىنى دېڭىزنىڭ ئۈستىگە ئۇزىتىۋىدى، تاڭ ئاتقاندا دېڭىزنىڭ سۈيى يەنە ئەسلىي ھالىتىگە يېنىپ كەلدى. قېچىۋاتقان مىسىرلىقلار ئېقىنغا قارشى يۈگۈرۈشتى، پەرۋەردىگار ئۇلارنى دېڭىزنىڭ ئوتتۇرىسىدا موللاق ئاتقۇزدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","سۇ ئەسلىگە يېنىپ كېلىپ، جەڭ ھارۋىلىرى بىلەن ئاتلىقلارنى، يەنى ئىسرائىللارنىڭ ئارقىدىن قوغلاپ دېڭىزغا كىرگەن پىرەۋننىڭ پۈتكۈل قوشۇنىنى غەرق قىلىۋەتتى؛ ئۇلاردىن بىرىمۇ ساق قالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","لېكىن ئىسرائىللار دېڭىزنىڭ ئوتتۇرىسىدىكى قۇرۇق يەر بىلەن مېڭىپ ئۆتۈپ كەتتى؛ سۇلار ئۇلارنىڭ ئوڭ ۋە سول يېنىدا كۆتۈرۈلۈپ تامدەك تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","شۇ تەرىقىدە پەرۋەردىگار ئۇ كۈنى ئىسرائىللارنى مىسىرلىقلارنىڭ قولىدىن قۇتقۇزدى؛ ئىسرائىللار مىسىرلىقلارنىڭ دېڭىزنىڭ بويىدا ئۆلۈك ياتقىنىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ئىسرائىل خەلقى پەرۋەردىگارنىڭ مىسىرلىقلارغا ئىشلەتكەن زور قۇدرىتىنى كۆرۈپ، پەرۋەردىگاردىن قورقتى؛ ئۇلار پەرۋەردىگارغا ۋە ئۇنىڭ قۇلى مۇساغا ئىشەندى. ");
INSERT INTO uigara_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","شۇ چاغدا مۇسا بىلەن ئىسرائىللار پەرۋەردىگارغا مەدھىيە ئوقۇپ مۇنۇ كۈينى ئېيتتى: ــ «مەن پەرۋەردىگارنى مەدھىيىلەپ كۈي ئېيتاي، چۈنكى ئۇ كارامەت ئۇلۇغلۇقىنى كۆرسەتتى؛ ئۇ ئات ۋە مىنگۈچىنى دېڭىزغا تاشلىۋەتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","مېنىڭ كۈچۈم ھەم مېنىڭ كۈيۈم ياھ ئۆزىدۇر؛ ئۇ ماڭا نىجات بولدى؛ ئۇ مېنىڭ تەڭرىمدۇر، مەن ئۇنى ئۇلۇغلايمەن؛ ئۇ مېنىڭ ئاتامنىڭ خۇداسىدۇر، مەن ئۇنى ئالىي دەپ مەدھىيىلەيمەن.    ");
INSERT INTO uigara_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","پەرۋەردىگار جەڭچىدۇر، ياھۋەھ ئۇنىڭ نامىدۇر. ");
INSERT INTO uigara_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","پىرەۋننىڭ جەڭ ھارۋىلىرىنى ھەم قوشۇنلىرىنى دېڭىزغا تاشلىۋەتتى؛ ئۇنىڭ ئالىي لەشكەر باشلىقلىرى قىزىل دېڭىزدا غەرق قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","چوڭقۇر سۇلار ئۇلارنى كۆمۈۋەتتى، ئۇلار خۇددى تاشتەك دېڭىز تېگىگە چۆكۈپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","سېنىڭ ئوڭ قولۇڭ، ئەي پەرۋەردىگار، قۇدرىتى بىلەن شان-شەرەپ تاپتى؛ سېنىڭ ئوڭ قولۇڭ، ئەي پەرۋەردىگار،دۈشمەننى كۇكۇم-تالقان قىلىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ئۆز ئۇلۇغلۇقۇڭنىڭ ھەيۋىسى بىلەن ئۆزۈڭگە قارشى چىققانلارنى نابۇت قىلدىڭ، سەن ئوتلۇق غەزىپىڭنى ئەۋەتتىڭ، ئۇ ساماننى كۆيدۈرگەن ئوتتەك ئۇلارنى يۇتۇۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","دىمىغىڭنىڭ نەپىسى بىلەن سۇلار دۆڭ بولۇپ ئۆرلىدى، جۇشقۇنلىغان دولقۇنلار دۆڭ كەبى تىك تۇردى، دېڭىزنىڭ ئوتتۇرىسىدىكى چوڭقۇر سۇلار قاتۇرۇپ قويۇلدى.    ");
INSERT INTO uigara_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","دۈشمەن دېدى: «مەن ئۇلارنى قوغلايمەن، يېتىشىمەن، ئولجا ئېلىپ ئۈلەشتۈرىمەن، ئۇلاردىن دەردىمنى چىقىرىمەن، قىلىچىمنى سۇغۇرۇپ، ئۆز قولۇم بىلەن ئۇلارنى نابۇت قىلىمەن». ");
INSERT INTO uigara_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","لېكىن سەن نەپىسىڭ بىلەن پۈۋلىدىڭ، دېڭىز ئۇلارنى كۆمۈۋەتتى؛ ئۇلار جۇشقۇنلۇق سۇلاردا قوغۇشۇندەك چۆكۈپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ئىلاھلارنىڭ ئارىسىدا، ئەي پەرۋەردىگار، كىم سېنىڭ تەڭدىشىڭ بولسۇن؟ پاك-مۇقەددەسلىك ئىچىدە ئۆز ھەيۋىتىڭنى كۆرسىتىدىغان، ھەمد-مەدھىيىلەر ئارىسىدا دەھشەتلىك تۇرىدىغان، مۆجىزە-كارامەت يارىتىدىغان، سەندەك كىم بولسۇن؟ ");
INSERT INTO uigara_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","سەن ئوڭ قولۇڭنى ئۇزىتىشىڭ بىلەن، يەر-زېمىن ئۇلارنى يۇتۇۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","لېكىن ئۆزۈڭگە ھەمجەمەت قىلىپ قۇتقۇزغان قوۋمنى رەھىمدىللىقىڭ بىلەن باشلاپ چىقتىڭ؛ سەن ئۇلارنى ئۆز مۇقەددەس ماكانىڭغا قۇدرىتىڭ بىلەن ھىدايەت قىلىپ يېتەكلىدىڭ. ");
INSERT INTO uigara_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","يات خەلقلەر بۇنى ئاڭلاپ، تىترىشىپ كەتتى؛ فىلىستىيەدە تۇرۇۋاتقانلارنى تولغاقتەك ئازاب تۇتتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ئاندىن ئېدومنىڭ ئەمىرلىرى دەككە-دۈككىگە چۈشتى؛ موئابنىڭ پالۋانلىرىنى بولسا، راسا تىترەك باستى؛ قانائان زېمىنىدىكىلەرنىڭ يۈرىكى سۇ بولۇپ ئاقتى؛ ");
INSERT INTO uigara_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","قورقۇنچ ۋە دەھشەت ئۇلارنى باستى؛ بىلىكىڭنىڭ ھەيۋىتى بىلەن ئۇلار خۇددى تاشتەك مىدىرلىيالماي قالدى؛ خەلقىڭ ئۆتۈپ كەتكۈچە، ئى پەرۋەردىگار، ئۆزۈڭ رەنە تۆلەپ ھۆر قىلغان خەلقىڭ ئۆتۈپ بولغۇچە.    ");
INSERT INTO uigara_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ئۇلارنى باشلاپ كىرىپ، ئۆز مىراسىڭ بولغان تاغدا كۆچەتتەك تىكىسەن، ئۆز ماكانىڭ قىلغان جايغا، ئى پەرۋەردىگار، ئۆز قوللىرىڭ تەييارلىغان مۇقەددەس جايغا، ئى رەب، ئۇلارنى ئېلىپ بارىسەن. ");
INSERT INTO uigara_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","پەرۋەردىگار ئەبەدىلئەبەدگىچە پادىشاھ بولۇپ ھۆكۈم سۈرىدۇ! ");
INSERT INTO uigara_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","چۈنكى پىرەۋننىڭ ئاتلىرى، جەڭ ھارۋىلىرى ئاتلىقلىرى بىلەن بىللە دېڭىزغا كىرىپ بولدى؛ پەرۋەردىگار دېڭىزنىڭ سۇلىرىنى ئۇلارنىڭ ئۈستىگە ياندۇردى، لېكىن ئىسرائىللار بولسا دېڭىزنىڭ ئوتتۇرىسىدىن قۇرۇق يەردىن مېڭىپ ئۆتۈپ كەتتى». ");
INSERT INTO uigara_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ئاندىن ھارۇننىڭ ھەدىسى پەيغەمبەر مەريەم قولىغا داپنى ئالدى، بارلىق قىز-ئاياللارمۇ قولىغا داپ ئېلىپ، ئۇسسۇل ئوينىشىپ ئۇنىڭغا ئەگەشتى. ");
INSERT INTO uigara_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","مەريەم ئۇلارغا جاۋابەن مۇنداق كۈينى ئوقۇدى: ــ «پەرۋەردىگارنى مەدھىيىلەپ كۈي ئېيتىڭلار، چۈنكى ئۇ زور ئۇلۇغلۇقىنى كۆرسەتتى؛ ئۇ ئات ۋە مىنگۈچىنى دېڭىزغا تاشلىۋەتتى!». ");
INSERT INTO uigara_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ئاندىن مۇسا ئىسرائىللارنى قىزىل دېڭىزدىن باشلاپ، شۇر چۆلىگە ئېلىپ باردى. ئۇلار ئۇدا ئۈچ كۈن چۆلدە يۈرۈپ، سۇ تاپالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ئاندىن ئۇلار ماراھقا يېتىپ كەلدى؛ لېكىن ئۇ يەرنىڭ سۈيى ئاچچىق بولۇپ، سۈيىنى ئىچكىلى بولمايتتى؛ شۇڭا ئۇ جاينىڭ نامى «ماراھ» دەپ قويۇلغان.    ");
INSERT INTO uigara_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ئۇ ۋاقىتتا خالايىق: ــ بىز نېمە ئىچىمىز؟ ــ دەپ مۇسادىن ئاغرىنىپ غوتۇلداشقىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ئۇ پەرۋەردىگارغا پەرياد كۆتۈردى؛ پەرۋەردىگار ئۇنىڭغا بىر دەرەخنى كۆرسەتتى؛ ئۇ دەرەخ ياغىچىنى ئېلىپ، سۇغا تاشلىۋىدى، سۇ تاتلىق سۇغا ئايلاندى. ئۇ يەردە پەرۋەردىگار ئۇلارغا ھۆكۈم-بەلگىلىمە بېكىتىپ، ئۇلارنى سىناپ، مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«ئەگەر سىلەر كۆڭۈل قويۇپ خۇدايىڭلار پەرۋەردىگارنىڭ سۆزىنى ئاڭلاپ، ئۇنىڭ نەزىرىدە دۇرۇس بولغاننى قىلىپ، ئەمرلىرىگە قۇلاق سېلىپ، بارلىق ھۆكۈملىرىنى تۇتساڭلار، ئۇنداقتا، مەن مىسىرلىقلارنىڭ ئۈستىگە سالغان كېسەللەردىن ھېچبىرىنى ئۈستۈڭگە سالمايمەن؛ چۈنكى مەنكى سىلەرگە شىپالىق بەرگۈچى پەرۋەردىگاردۇرمەن». ");
INSERT INTO uigara_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ئاندىن ئۇلار ئېلىمغا يېتىپ كەلدى. شۇ يەردە ئون ئىككى بۇلاق بىلەن يەتمىش خورما دەرىخى بار ئىدى؛ ئۇلار شۇ يەردە سۇلارنىڭ بويىدا چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ئاندىن ئىسرائىللارنىڭ پۈتكۈل جامائىتى ئېلىمدىن يولغا ئاتلاندى؛ مىسىر زېمىنىدىن چىقىپ، ئىككىنچى ئېيىنىڭ ئون بەشىنچى كۈنىدە ئېلىم بىلەن سىناينىڭ ئوتتۇرىسىدىكى سىن چۆلىگە يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ئەمما ئىسرائىللارنىڭ پۈتكۈل جامائىتى چۆلدە مۇسا بىلەن ھارۇننىڭ يامان گېپىنى قىلىپ غوتۇلداشقىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ئىسرائىللار ئۇلارغا: ــ پەرۋەردىگارنىڭ قولى بىزنى مىسىر يۇرتىدىلا ئۆلتۈرۈۋەتكەن بولسا بولماسمىدى! شۇ يەردە بىز گۆش قايناۋاتقان قازانلارنى چۆرىدەپ ئولتۇرۇپ، تويغۇدەك نان يېمىگەنمىدۇق؟ لېكىن سىلەر بۇ جامائەتنىڭ ھەممىسىنى ئاچلىق بىلەن ئۆلتۈرمەكچى بولۇپ بىزنى بۇ چۆلگە ئېلىپ كەلدىڭلار! ــ دېيىشتى.    ");
INSERT INTO uigara_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","بۇنىڭ بىلەن پەرۋەردىگار مۇساغا: ــ مانا، مەن ئاسماندىن سىلەرگە نان ياغدۇرىمەن؛ شۇنىڭ بىلەن خەلق ھەر كۈنى چىقىپ، بىر كۈنلۈك لازىملىقىنى يىغىۋالسۇن. بۇ تەرىقىدە مەن ئۇلارنىڭ مېنىڭ قانۇن-ئەمرلىرىمدە ماڭىدىغان-ماڭمايدىغانلىقىنى سىنايمەن. ");
INSERT INTO uigara_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ھەر ھەپتىنىڭ ئالتىنچى كۈنى شۇنداق بولىدۇكى، ئۇلار يىغىۋالغانلىرىنى تەييارلىسۇن؛ ئۇ باشقا كۈنلەردە ئېرىشىدىغىنىدىن بىر ھەسسە كۆپ بولىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ئاندىن مۇسا بىلەن ھارۇن بارلىق ئىسرائىللارغا: ــ بۈگۈن ئاخشام سىلەرنى مىسىر زېمىنىدىن ئېلىپ چىققۇچىنىڭ پەرۋەردىگار ئىكەنلىكىنى بىلىسىلەر ۋە ");
INSERT INTO uigara_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ئەتە سىلەر پەرۋەردىگارنىڭ شان-شەرىپىنى كۆرىسىلەر؛ چۈنكى ئۇ سىلەرنىڭ ئۇنىڭ يامان گېپىنى قىلىپ غوتۇلداشقىنىڭلارنى ئاڭلىدى؛ بىزگە كەلسەك، سىلەر يامان گېپىمىزنى قىلىپ غوتۇلدىغۇدەك بىز كىم ئىدۇق؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","مۇسا يەنە: پەرۋەردىگار بۈگۈن ئاخشام سىلەرگە يېگىلى گۆش بېرىپ، ئەتە ئەتىگەندە تويغۇدەك نان بەرگەندە بۇنى بىلىسىلەر؛ چۈنكى پەرۋەردىگار سىلەر ئۇنىڭ يامان گېپىنى قىلىپ غوتۇلدىغىنىڭلارنى ئاڭلىدى. ئەمدى بىز نېمە ئىدۇق؟ سىلەرنىڭ غوتۇلداشقىنىڭلار بىزلەرگە قارىتىلغان ئەمەس، بەلكى پەرۋەردىگارغا قارىتىلغاندۇر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ئاندىن مۇسا ھارۇنغا: ــ سەن ئىسرائىللارنىڭ پۈتكۈل جامائىتىگە: «پەرۋەردىگارنىڭ ئالدىغا كېلىڭلار؛ چۈنكى ئۇ يامان گەپ بىلەن غوتۇلداشقىنىڭلارنى ئاڭلىدى»، دەپ ئېيتقىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","شۇنداق بولدىكى، ھارۇن ئىسرائىللارنىڭ پۈتكۈل جامائىتىگە سۆزلەپ تۇرغىنىدا، ئۇلار چۆل تەرەپكە قارىۋىدى، مانا، پەرۋەردىگارنىڭ جۇلاسى بۇلۇتتا ئايان بولدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","شۇنىڭ بىلەن پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","ــ مەن ئىسرائىللارنىڭ يامان گەپ قىلىپ غوتۇلداشقىنىنى ئاڭلىدىم؛ ئەمدى ئۇلارغا: «گۇگۇمدا سىلەر گۆش يەيسىلەر ۋە ئەتىگەندە ناندىن تويۇنىسىلەر، شۇنىڭ بىلەن سىلەر مېنىڭ پەرۋەردىگار خۇدايىڭلار ئىكەنلىكىمنى بىلىپ يېتىسىلەر» ــ دەپ ئېيتقىن، دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","كەچقۇرۇندا شۇنداق بولدىكى، بۆدۈنىلەر ئۇچۇپ كېلىپ، چېدىرگاھنى قاپلاپ كەتتى؛ ئەتىسى ئەتىگەندە، چېدىرگاھنىڭ ئەتراپىدىكى يەرلەرگە شەبنەم چۈشكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ئەتراپتا ياتقان شەبنەم كۆتۈرۈلۈپ كەتكەندىن كېيىن، مانا، چۆللۈكنىڭ يەر يۈزىدە قىراۋدەك نېپىز، كىچىك-كىچىك يۇمىلاق نەرسىلەر تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ئىسرائىللار ئۇنى كۆرگەندە، ئۇنىڭ نېمە ئىكەنلىكىنى بىلمىگىنى ئۈچۈن: ــ بۇ نېمىدۇ؟ ــ دەپ سوراشتى. مۇسا ئۇلارغا جاۋابەن: ــ بۇ پەرۋەردىگار سىلەرگە ئاتا قىلغان ئوزۇق-تۈلۈكتۇر. ");
INSERT INTO uigara_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","پەرۋەردىگار شۇ ئىشنى ئەمر قىلىپ دېدىكى، «ھەربىرىڭلار يەيدىغىنىڭلارغا قاراپ ئۇنىڭدىن يىغىۋېلىڭلار؛ ھەربىرىڭلار ئائىلىدىكى ئادەم سانىغا قاراپ، ھەربىر ئادەمگە بىر ئومەر مىقداردا يىغىڭلار؛ ھەر ئادەم ئۆز چېدىرىدىكى كىشىلەر ئۈچۈن يىغىڭلار» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ئىسرائىللار شۇنداق قىلىپ، بەزىسى كۆپرەك، بەزىسى ئازراق يىغىۋالدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ئۇلار ئۇنى ئومەر مىقدارى بىلەن ئۆلچىۋىدى، كۆپ يىغقانلارنىڭكىدىن ئېشىپ كەتمىدى، ئاز يىغقانلارنىڭمۇ كەملىك قىلمىدى؛ ھەربىر كىشى ئۆز يەيدىغىنىغا قاراپ يىغقانىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","مۇسا ئۇلارغا: ــ ھېچقانداق ئادەم بۇلاردىن ھېچنېمىنى ئەتىگە قالدۇرمىسۇن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","شۇنداق بولسىمۇ، ئۇلار مۇسانىڭ سۆزىگە قۇلاق سالمىدى؛ بەزىلەر ئۇنىڭدىن بىر قىسمىنى ئەتىگە ساقلاپ قويدى. ئەمما ساقلاپ قويغىنى قۇرتلاپ سېسىپ كەتتى. بۇ ئىش ئۈچۈن مۇسا ئۇلارغا خاپا بولۇپ ئاچچىقلاندى. ");
INSERT INTO uigara_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","شۇ سەۋەبتىن ئۇلارنىڭ ھەربىرى ھەر ئەتىگىنى چىقىپ ئۆز يەيدىغىنىغا قاراپ يىغىۋالاتتى؛ قالغانلىرى بولسا ئاپتاپ چىققاندا ئېرىپ كېتەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","لېكىن ئالتىنچى كۈنى شۇنداق بولدىكى، ئۇلار كۈنلۈك ئوزۇقنىڭ ئىككى ھەسسىسىنى يىغدى؛ دېمەك، ھەربىر كىشى ئۈچۈن ئىككى ئومەر مىقداردا يىغىۋالدى؛ ئاندىن جامائەت ئەمىرلىرى ھەممىسى كېلىپ بۇنى مۇساغا ئېيتتى. ");
INSERT INTO uigara_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","مۇسا ئۇلارغا: ــ مانا پەرۋەردىگارنىڭ دېگىنى: ــ ئەتە ئارام كۈنى، پەرۋەردىگارغا ئاتالغان مۇقەددەس شابات كۈنى بولىدۇ؛ پىشۇرىدىغىنىڭلارنى پىشۇرۇپ، قاينىتىدىغىنىڭلارنى قايىنىتىپ، ئېشىپ قالغاننىڭ ھەممىسىنى ئەتىگە ساقلاپ قويۇڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ئۇلار مۇسا بۇيرۇغاندەك، ئېشىپ قالغاننى ئەتىسىگە ساقلاپ قويۇۋىدى، ئۇلار سېسىپ قالمىدى، قۇرۇتلاپمۇ كەتمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","مۇسا ئۇلارغا: ــ بۇنى بۈگۈن يەڭلار؛ چۈنكى بۈگۈن پەرۋەردىگارغا ئاتالغان شابات كۈنى بولغىنى ئۈچۈن بۈگۈن دالادىن تاپالمايسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ئالتە كۈن سىلەر يىغساڭلار بولىدۇ؛ لېكىن يەتتىنچى كۈنى شابات بولغىنى ئۈچۈن ئۇ كۈنىدە ھېچنېمە تېپىلمايدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ھالبۇكى، يەتتىنچى كۈنى خەلقتىن بىرنەچچىسى ئوزۇق-تۈلۈك يىغقىلى چىقىۋىدى، ھېچنېمە تاپالمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","پەرۋەردىگار مۇساغا: «سىلەر قاچانغىچە مېنىڭ ئەمرلىرىم ۋە قانۇن-بەلگىلىمىلىرىمنى تۇتۇشنى رەت قىلىسىلەر؟ ");
INSERT INTO uigara_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","مانا، پەرۋەردىگار سىلەرگە شابات كۈنىنى بېكىتىپ بەردى؛ شۇڭا يەتتىنچى كۈنى ھەربىرىڭلارنى ئۆز ئورنىدا تۇرۇپ، سىرتلارغا چىقمىسۇن دەپ، ئالتىنچى كۈنى ئىككى كۈنلۈك ئوزۇق بېرىدۇ»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","شۇنىڭ بىلەن خەلق يەتتىنچى كۈنى ئارام ئالدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ئىسرائىللار بۇ ئوزۇقنى «ماننا» دەپ ئاتىدى؛ ئۇنىڭ شەكلى يۇمغاقسۈت ئۇرۇقىدەك، رەڭگى ئاق بولۇپ، تەمى ھەسەلگە مىلەنگەن قوتۇرماچقا ئوخشايتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","مۇسا ئۇلارغا: ــ پەرۋەردىگارنىڭ ئەمرى شۇكى، ــ كېيىنكى ئەۋلادلىرىڭلارغا مەن سىلەرنى مىسىردىن ئېلىپ چىققاندا، مەن سىلەرگە چۆلدە يېيىشكە ئاتا قىلغان ناننى كۆرسىتىش ئۈچۈن، ئۇنىڭدىن كومزەككە بىر ئومەر توشقۇزۇپ، ئۇلار ئۈچۈن ساقلاپ قويۇڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","مۇسا ھارۇنغا: ــ كەلگۈسى ئەۋلادلىرىڭلارغا كۆرسىتىشكە ساقلاش ئۈچۈن بىر كومزەكنى ئېلىپ، ئۇنىڭغا بىر ئومەر مىقداردا ماننا سېلىپ، پەرۋەردىگارنىڭ ھۇزۇرىدا قويۇپ قويغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","كېيىن، ھارۇن پەرۋەردىگار مۇساغا بۇيرۇغاندەك كومزەكنى ساقلاش ئۈچۈن ئۇنى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئالدىدا قويۇپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","شۇ تەرىقىدە ئىسرائىللار ئادەم ئولتۇراقلاشقان بىر زېمىنغا يېتىپ كەلگۈچە قىرىق يىل «ماننا» يېدى؛ ئۇلار قانائان زېمىنىنىڭ چېگرالىرىغا يەتكۈچە ماننا يېدى. ");
INSERT INTO uigara_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ئەينى چاغدا بىر «ئومەر» «ئەفاھ»نىڭ ئوندىن بىرىگە باراۋەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ئاندىن پۈتكۈل ئىسرائىل جامائىتى قوپۇپ، سىن چۆلىدىن چىقىپ، پەرۋەردىگارنىڭ ئەمرى بويىچە سەپەر قىلىپ، رەفىدىم دېگەن يەرگە كېلىپ چېدىرلىرىنى تىكتى. ئەمما ئۇ يەردە خەلققە ئىچكىلى سۇ يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","شۇنىڭ بىلەن خەلق مۇسا بىلەن جېدەللىشىپ: ــ بىزگە ئىچكىلى سۇ بەرگىن! ــ دېدى. لېكىن مۇسا ئۇلارغا: ــ نېمىشقا مېنىڭ بىلەن جېدەللىشىسىلەر؟ نېمىشقا پەرۋەردىگارنى سىنايسىلەر؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","لېكىن خەلق چاڭقاپ، سۇ تەلەپ قىلىپ، مۇسادىن ئاغرىنىپ غوتۇلدىشىپ: ــ سەن نېمىشقا بىزنى، بالىلىرىمىزنى ۋە مېلىمىزنى ئۇسسۇزلۇق بىلەن ئۆلتۈرۈشكە مىسىردىن ئېلىپ كەلدىڭ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","شۇنىڭ بىلەن مۇسا پەرۋەردىگارغا پەرياد كۆتۈرۈپ: ــ بۇ خەلقنى قانداق قىلسام بولار؟! ئۇلار ھېلىلا مېنى چالما-كېسەك قىلىشى مۇمكىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","پەرۋەردىگار مۇساغا جاۋابەن: ــ سەن ئىسرائىلنىڭ ئاقساقاللىرىدىن بىرنەچچىسىنى ئۆزۈڭ بىلەن بىللە ئېلىپ چىقىپ، نىل دەرياسىنىڭ سۈيىنى ئۇرغىنىڭدا ئىشلەتكەن ھاساڭنى قولۇڭغا ئېلىپ خەلقنىڭ ئالدىغا بارغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","مانا، مەن شۇ يەردە، ھورەب تېغىدىكى قورام تاشنىڭ ئۈستىدە سېنىڭ ئالدىڭدا تۇرىمەن؛ سەن قورام تاشنى ئۇرغىن. بۇنىڭ بىلەن ئۇنىڭدىن خەلققە ئىچكىلى سۇ چىقىدۇ، ــ دېدى. مۇسا ئىسرائىلنىڭ ئاقساقاللىرىنىڭ كۆز ئالدىدا شۇنداق قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","مۇسا ئىسرائىللارنىڭ جېدەللەشكىنى ۋە ئۇلارنىڭ «پەرۋەردىگار زادى ئارىمىزدا بارمۇ-يوقمۇ؟» دېيىشىپ پەرۋەردىگارنى سىنىغىنى ئۈچۈن، ئۇ يەرنى «ماسساھ» ۋە «مەرىباھ» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","شۇ چاغدا ئامالەكلەر كېلىپ رەفىدىمدە ئىسرائىلغا ھۇجۇم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","مۇسا يەشۇئاغا: سەن ئۆزىمىزدىن ئامالەك بىلەن جەڭ قىلىشقا ئادەم تاللىغىن. مەن ئەتە خۇدانىڭ ھاسىسىنى قولۇمغا ئېلىپ دۆڭنىڭ چوققىسىدا تۇرۇپ تۇرىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","يەشۇئا مۇسا بۇيرۇغىنىدەك قىلىپ، ئامالەكلەر بىلەن جەڭ قىلدى. مۇسا، ھارۇن ۋە خۇر دۆڭنىڭ چوققىسىغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","شۇنداق بولدىكى، مۇسا قولىنى كۆتۈرۈپ تۇرسا، ئىسرائىل غالىب كېلەتتى، لېكىن ئۇ قوللىرىنى پەسكە چۈشۈرۈپ تۇرسا، ئامالەك غالىب كېلەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","مۇسانىڭ قوللىرى ئېغىرلىشىپ كەتتى؛ ئۇلار بىر تاشنى ئېلىپ كېلىپ ئۇنىڭ ئاستىغا قويدى؛ ئۇ ئۇنىڭ ئۈستىدە ئولتۇردى؛ ئاندىن ھارۇن بىلەن خۇر بىرى بىر تەرىپىدە، بىرى يەنە بىر تەرىپىدە ئۇنىڭ قوللىرىنى يۆلەپ تۇردى؛ بۇ تەرىقىدە ئۇنىڭ قوللىرى تاكى كۈن پاتقۇچە مەزمۇت تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","شۇنداق قىلىپ، يەشۇئا ئامالەك ۋە ئۇنىڭ خەلقىنى قىلىچلاپ نابۇت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","پەرۋەردىگار مۇساغا: ــ بىر ئەسلىمە بولسۇن دەپ بۇ ئىشلارنى بىر كىتابقا يېزىپ قالدۇرغىن، شۇنداقلا شۇلارنى يەشۇئانىڭ قۇلاقلىرىغا ئوقۇپ بەر؛ چۈنكى مەن ئامالەكنىڭ نامىنى ئاسمانلارنىڭ ئاستىدىن، ھەتتا ئادەملەرنىڭ ئېسىدىنمۇ مۇتلەق ئۆچۈرۈۋېتىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ئاندىن مۇسا بىر قۇربانگاھنى ياساپ، نامىنى «پەرۋەردىگار تۇغۇمدۇر» دەپ ئاتىدى ");
INSERT INTO uigara_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ۋە مۇسا: ــ ياھنىڭ تەختى ئالدىدا بىر قول كۆتۈرۈلۈپ: ــ «پەرۋەردىگار ئەۋلادتىن ئەۋلادقىچە ئامالەككە قارشى جەڭ قىلىدۇ» دېيىلگەنىدى، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","مۇسانىڭ قېينئاتىسى، يەنى مىدىياننىڭ كاھىنى يەترو خۇدانىڭ مۇسا ئۈچۈن ھەمدە ئۆز خەلقى ئىسرائىل ئۈچۈن بارلىق قىلغانلىرى توغرۇلۇق ئاڭلىدى، يەنى پەرۋەردىگارنىڭ ئىسرائىلنى مىسىردىن چىقارغانلىقىدىن خەۋەر تاپتى. ");
INSERT INTO uigara_vpl VALUES ("EX18_2‏","003_18_2‏","EXO","18","2‏","3","شۇنىڭ بىلەن مۇسانىڭ قېينئاتىسى يەترو مۇسانىڭ ئەسلىدە ئۆز يېنىغا ئەۋەتىۋەتكەن ئايالى زىپپوراھ ۋە ئۇنىڭ ئىككى ئوغلىنى ئېلىپ يولغا چىقتى (بىرىنچى ئوغلىنىڭ ئىسمى گەرشوم دەپ قويۇلغانىدى؛ چۈنكى مۇسا: «مەن ياقا يۇرتتا مۇساپىر بولۇپ تۇرۇۋاتىمەن» دېگەنىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","يەنە بىرىنىڭ ئىسمى ئەلىئېزەر دەپ قويۇلغانىدى؛ چۈنكى مۇسا: «ئاتامنىڭ خۇداسى ماڭا ياردەمدە بولۇپ، مېنى پىرەۋننىڭ قىلىچىدىن قۇتقۇزدى»، دېگەنىدى). ");
INSERT INTO uigara_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","شۇنداق قىلىپ مۇسانىڭ قېينئاتىسى يەترو مۇسانىڭ ئوغۇللىرى بىلەن ئايالىنى ئېلىپ، مۇسانىڭ چۆلدە، خۇدانىڭ تېغىنىڭ يېنىدا چېدىر تىككەن يېرىگە يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ئۇ ئەسلىدە مۇساغا: ــ «مانا، مەنكى قېينئاتاڭ يەترو سېنىڭ ئايالىڭنى ۋە ئۇنىڭ ئىككى ئوغلىنى ئېلىپ يېنىڭغا كېتىۋاتىمەن» دەپ خەۋەر ئەۋەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","شۇنىڭ بىلەن مۇسا ئۆز قېينئاتىسىنىڭ ئالدىغا چىقىپ، تەزىم قىلىپ، ئۇنى سۆيدى. ئۇلار بىر-بىرىدىن ھال-ئەھۋال سورىشىپ چېدىرغا كىردى؛ ");
INSERT INTO uigara_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ئاندىن مۇسا قىيناتىسىغا ئىسرائىلنىڭ ۋەجىدىن پەرۋەردىگارنىڭ پىرەۋن ۋە مىسىرلىقلارغا قىلغان ھەممە ئەمەللىرىنى سۆزلەپ، ئۇلارنىڭ يول بويى بېشىغا چۈشكەن جەبىر-جاپالارنى بايان قىلىپ، پەرۋەردىگارنىڭ قانداق قىلىپ ئۇلارنى قۇتقۇزغىنىنى ئېيتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","بۇنى ئاڭلاپ يەترو پەرۋەردىگارنىڭ ئىسرائىلغا كۆرسەتكەن بارلىق ياخشىلىقىدىن، ئۇلارنى مىسىرلىقلارنىڭ قولىدىن قۇتقۇزغانلىقىدىن شادلاندى. ");
INSERT INTO uigara_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","يەترو شادلىنىپ: ــ سىلەرنى مىسىرلىقلارنىڭ ۋە پىرەۋننىڭ قولىدىن قۇتقۇزغان پەرۋەردىگارغا تەشەككۇرلەر بولغاي! ئۇ بۇ قوۋمنى مىسىرلىقلارنىڭ قولىدىن قۇتقۇزدى! ");
INSERT INTO uigara_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","مەن پەرۋەردىگارنىڭ بارلىق ئىلاھلاردىن ئۈستۈن تۇرىدىغانلىقىنى ئەمدى بىلدىم؛ چۈنكى ئۇ دەل ئۇلار يوغانچىلىق قىلغان ئىشتا ئۆزىنىڭ ئۇلاردىن ئۈستۈن تۇرىدىغانلىقىنى نامايان قىلدى ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ئاندىن مۇسانىڭ قېينئاتىسى يەترو خۇداغا ئاتاپ بىر كۆيدۈرمە قۇربانلىق ۋە بىرنەچچە تەشەككۇر قۇربانلىقلىرىنى ئېلىپ كەلدى؛ ھارۇن بىلەن ئىسرائىلنىڭ ھەربىر ئاقساقىلى مۇسانىڭ قېينئاتىسى بىلەن بىللە خۇدانىڭ ھۇزۇرىدا تائام يېيىشكە كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ئەتىسى مۇسا خەلقنىڭ ئىش-دەۋالىرى ئۈستىدىن ھۆكۈم چىقىرىشقا ئولتۇردى؛ خەلق ئەتىگەندىن تارتىپ كەچكىچە مۇسانىڭ چۆرىسىدە تۇرۇشتى. ");
INSERT INTO uigara_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","مۇسانىڭ قېينئاتىسى ئۇنىڭ خەلقى ئۈچۈن قىلغان ئىشلىرىنى كۆرگەندە ئۇنىڭدىن: ــ سېنىڭ خەلققە قىلىۋاتقان بۇ ئىشىڭ زادى نېمە ئىش؟ نېمىشقا سەن بۇ ئىشتا يالغۇز ئولتۇرىسەن، بارلىق خەلق نېمە ئۈچۈن ئەتىگەندىن كەچكىچە سېنىڭ چۆرەڭدە تۇرىدۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","مۇسا قېينئاتىسىغا جاۋاب بېرىپ: ــ خەلق خۇدادىن يول ئىزدەشكە مېنىڭ قېشىمغا كېلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","قاچانكى ئۇلارنىڭ بىر ئىش-دەۋاسى چىقسا ئۇلار يېنىمغا كېلىدۇ؛ شۇنىڭ بىلەن مەن ئۇلارنىڭ ئوتتۇرىسىدا ھۆكۈم چىقىرىمەن ۋە شۇنداقلا خۇدانىڭ قانۇن-بەلگىلىمىلىرىنى ئۇلارغا بىلدۈرىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","مۇسانىڭ قېينئاتىسى ئۇنىڭغا: ــ بۇ قىلغىنىڭ ياخشى بولماپتۇ. ");
INSERT INTO uigara_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","سەن جەزمەن ئۆزۈڭنى ھەمدە چۆرەڭدە تۇرغان خەلقنىمۇ چارچىتىپ قويىسەن؛ چۈنكى بۇ ئىش ساڭا بەك ئېغىر كېلىدۇ. سەن ئۇنى يالغۇز قىلىپ يېتىشەلمەيسەن. ");
INSERT INTO uigara_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ئەمدى مېنىڭ سۆزۈمگە قۇلاق سالغىن، مەن ساڭا بىر مەسلىھەت بېرەي ۋە شۇنداق قىلساڭ، خۇدا سېنىڭ بىلەن بىللە بولىدۇ: ــ سەن ئۆزۈڭ خۇدانىڭ ئالدىدا خەلقنىڭ ۋەكىلى بولۇپ، ئۇلارنىڭ ئىشلىرىنى خۇداغا مەلۇم قىلغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","سەن خەلققە قانۇن-بەلگىلىمىلەرنى ئۆگىتىپ، ماڭىدىغان يولنى كۆرسىتىپ، ئۇلارنىڭ قانداق بۇرچى بارلىقىنى ئۇقتۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","شۇنىڭ بىلەن بىر ۋاقىتتا سەن پۈتكۈل خەلقنىڭ ئارىسىدىن خۇدادىن قورقىدىغان، نەپسانىيەتچىلىكنى يامان كۆرىدىغان ھەم قابىلىيەتلىك ھەم دىيانەتلىك ئادەملەرنى تېپىپ، ئۇلارنى خەلقنىڭ ئۈستىگە باش قىلىپ، بەزىسىنى مىڭبېشى، بەزىسىنى يۈزبېشى، بەزىسىنى ئەللىكبېشى، بەزىسىنى ئونبېشى قىلىپ تەيىنلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","شۇنىڭ بىلەن بۇلار ھەرقانداق ۋاقىتتا خەلقنىڭ ئىش-دەۋالىرىنى سورايدۇ. ئەگەر چوڭ بىر ئىش-دەۋا چىقىپ قالسا، بۇنى ساڭا تاپشۇرسۇن؛ لېكىن ھەممە كىچىك ئىش-دەۋالارنى ئۇلار ئۆزلىرى بېجىرىسۇن. شۇنداق قىلىپ، ئۇلار سېنىڭ ۋەزىپەڭنى يېنىكلىتىپ، يۈكۈڭنى كۆتۈرۈشۈپ بېرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ئەگەر شۇنداق قىلساڭ ۋە خۇدا ساڭا شۇنداق بۇيرۇسا، ئۆزۈڭ ۋەزىپەڭدە پۇت تىرەپ تۇرالايسەن ۋە خەلقىڭمۇ خاتىرجەملىك بىلەن ئۆز جايىغا قايتىپ كېتىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","مۇسا قېينئاتىسىنىڭ سۆزىگە قۇلاق سېلىپ دېگىنىنىڭ ھەممىسىنى قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","مۇسا پۈتكۈل ئىسرائىل ئارىسىدىن قابىلىيەتلىك ئادەملەرنى تاللاپ، ئۇلارنى خەلقنىڭ ئۈستىگە باش قىلىپ، بەزىسىنى مىڭبېشى، بەزىسىنى يۈزبېشى، بەزىسىنى ئەللىكبېشى، بەزىسىنى ئونبېشى قىلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","بۇلار ھەرقانداق ۋاقىتتا خەلقنىڭ ئىش-دەۋالىرىنى سوراپ تۇردى؛ تەسرەك ئىش-دەۋالارنى بولسا، مۇساغا يوللايتتى، كىچىك ئىش-دەۋالارنى بولسا ئۆزلىرى سورايتتى. ");
INSERT INTO uigara_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ئاندىن مۇسا قېينئاتىسىنى يولغا سېلىپ قويدى، ئۇ ئۆز يۇرتىغا قايتىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ئىسرائىللار مىسىر زېمىنىدىن چىقىپ، دەل ئۈچىنچى ئېيىنىڭ باشلانغان كۈنى سىناي چۆلىگە يېتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ئۇلار رەفىدىمدىن چىقىپ، سىناي چۆلىگە يېتىپ كېلىپ، چۆلدە چېدىر تىكتى؛ ئىسرائىل شۇ يەردە، تاغنىڭ ئۇدۇلىدا توختاپ چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","مۇسا خۇدانىڭ ئالدىغا چىقىۋىدى، پەرۋەردىگار تاغدىن ئۇنىڭغا خىتاب قىلىپ مۇنداق دېدى: ــ سەن ياقۇپنىڭ جەمەتىگە سۆز قىلىپ، ئىسرائىللارغا مۇنۇ خەۋەرنى يەتكۈزگىن: ــ ");
INSERT INTO uigara_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","«مېنىڭ مىسىرلىقلارغا نېمە قىلغىنىمنى، شۇنداقلا مەن سىلەرنى خۇددى بۈركۈت بالىلىرىنى قاناتلىرىغا مىندۈرۈپ ئېلىپ يۈرگەندەك، ئۆز قېشىمغا ئېلىپ كەلگىنىمنى ئۆزۈڭلار كۆردۈڭلار.    ");
INSERT INTO uigara_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ئەمدى سىلەر دەرھەقىقەت مېنىڭ سۆزۈمنى ئاڭلاپ، ئەھدەمنى تۇتساڭلار، ئۇنداقتا بارلىق ئەللەرنىڭ ئارىسىدا ماڭا خاس بىر گۆھەر بولىسىلەر ــ چۈنكى پۈتكۈل يەر مېنىڭكىدۇر ــ ");
INSERT INTO uigara_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ۋە سىلەر ماڭا كاھىنلاردىن تەركىب تاپقان خاس بىر پادىشاھلىق ۋە مۇقەددەس بىر قوۋم بولىسىلەر». مانا بۇ سەن ئىسرائىللارغا دېيىشىڭ كېرەك بولغان سۆزلەردۇر، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","شۇنىڭ بىلەن مۇسا يېنىپ كېلىپ، خەلقنىڭ ئاقساقاللىرىنى چاقىرتىپ، پەرۋەردىگار ئۇنىڭغا بۇيرۇغان شۇ سۆزلەرنىڭ ھەممىسىنى ئۇلارغا يەتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","خەلقنىڭ ھەممىسى بىر ئېغىزدىن: ــ پەرۋەردىگار بۇيرۇغاننىڭ ھەممىسىگە چوقۇم ئەمەل قىلىمىز! ــ دەپ جاۋاب بەردى. ئاندىن مۇسا خەلقنىڭ جاۋاب سۆزلىرىنى پەرۋەردىگارنىڭ قېشىغا بېرىپ يەتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","پەرۋەردىگار مۇساغا: ــ مانا، مەن ساڭا سۆز قىلغىنىمدا خەلق ئاۋازىمنى ئاڭلىسۇن، ھەمىشە ساڭا ئىشەنسۇن دەپ، يېنىڭغا قارا بۇلۇتنىڭ قاراڭغۇلۇقى ئىچىدە كېلىمەن، دەپ ئېيتتى. مۇسامۇ خەلقنىڭ دېگەنلىرىنى پەرۋەردىگارغا ئاڭلاتتى. ");
INSERT INTO uigara_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","پەرۋەردىگار مۇساغا يەنە: ــ سەن خەلقنىڭ قېشىغا بېرىپ، بۈگۈن ۋە ئەتە ئۇلارنى پاك-مۇقەددەس قىلىپ، كىيىم-كېچەكلىرىنى يۇدۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ئۇلار ئۈچىنچى كۈنىگە تەييار تۇرسۇن؛ چۈنكى ئۈچىنچى كۈنى بارلىق خەلقنىڭ كۆز ئالدىدا پەرۋەردىگار سىناي تېغىغا چۈشىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","سەن خەلق ئۈچۈن تاغنىڭ ئەتراپىغا بىر پاسىل قىلىپ، ئۇلارغا: «سىلەر ئېھتىيات قىلىڭلار، تاغقا چىقماڭلار ياكى ئۇنىڭ ئېتىكىگە تېگىپ كەتمەڭلار. كىمكى تاغقا تەگسە ئۆلتۈرۈلمەي قالمايدۇ؛    ");
INSERT INTO uigara_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ئۇنىڭغا ھەتتا بىرەر قولى تېگىپ كەتسىمۇ، چالما-كېسەك قىلىپ ئۆلتۈرۈلسۇن ياكى ئوق ئېتىپ ئۆلتۈرۈلسۇن. مەيلى ھايۋان ياكى ئىنسان بولسۇن، شۇنداق قىلسا، تىرىك قالدۇرۇلمىسۇن» ــ دەپ ئېيتقىن. لېكىن كاناي ئۇزۇن چېلىنسا، ئۇلار تاغنىڭ تۈۋىگە چىقسۇن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","مۇسا تاغدىن چۈشۈپ خەلقنىڭ قېشىغا بېرىپ، خەلقنى خۇداغا ئاتاپ مۇقەددەس قىلدى؛ ئۇلار كىيىم-كېچەكلىرىنى يۇدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ئاندىن مۇسا خەلققە: ــ ئۈچىنچى كۈنىگە تەييار تۇرۇڭلار؛ ھېچكىم ئايالى بىلەن يېقىنچىلىق قىلمىسۇن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ئۈچىنچى كۈنى بولغاندا، تاڭ يورۇشى بىلەن شۇنداق بولدىكى، گۈلدۈرمامىلار گۈلدۈرلەپ، چاقماق چېقىپ، تاغ ئۈستىدە قويۇق بىر پارچە بۇلۇت پەيدا بولدى، زور قاتتىق چېلىنغان كاناينىڭ ئاۋازى ئاڭلاندى. بۇنى كۆرۈپ چېدىرگاھدىكى پۈتكۈل خەلق قورقۇنچىدىن تىترەپ كەتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","مۇسا خەلقنى خۇدانىڭ ئالدىدا ھازىر بولۇشقا چېدىرگاھدىن ئېلىپ چىقتى. ئۇلار كېلىپ تاغنىڭ تۈۋىدە ئۆرە تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","پەرۋەردىگار سىناي تېغىغا ئوتتا چۈشۈپ كەلگىنى ئۈچۈن ئىس-تۈتەك پۈتكۈل تاغنى قاپلىدى؛ ئىس-تۈتەك خۇمداندىن ئۆرلىگەن ئىس-تۈتەكتەك ئۈستىگە ئۆرلەپ چىقتى. پۈتكۈل تاغ قاتتىق تەۋرىنىشكە باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","كاناي ئاۋازى بارغانسېرى كۈچىيىپ ئىنتايىن قاتتىق چىقتى. مۇسا سۆز قىلىۋىدى، خۇدا ئاڭلاپ ئۈنلۈك ئاۋاز بىلەن جاۋاب بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","پەرۋەردىگار ئۆزى سىناي تېغىغا، تاغنىڭ چوققىسىغا چۈشتى؛ ئاندىن پەرۋەردىگار مۇسانى تاغنىڭ چوققىسىغا چاقىرىۋىدى، مۇسا تاغقا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","پەرۋەردىگار مۇساغا: ــ سەن چۈشۈپ خالايىقنى ئاگاھلاندۇرۇپ: ئۇلار «پەرۋەردىگارنى كۆرىمىز» دەپ پاسىلدىن بۆسۈپ ئۆتمىسۇن؛ ئۇنداق قىلسا، ئۇلاردىن كۆپ ئادەم ھالاك بولىدۇ، دەپ ئېيتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","پەرۋەردىگارغا يېقىن كېلەلەيدىغان كاھىنلارمۇ ئۆزلىرىنى ماڭا ئاتاپ مۇقەددەس قىلسۇن؛ بولمىسا، پەرۋەردىگار سېپىلنى بۆسكەندەك ئۇلارغا ھالاكەت يەتكۈزىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","مۇسا پەرۋەردىگارغا: ــ خالايىقنىڭ سىناي تېغىغا چىقىشى مۇمكىن ئەمەس؛ چۈنكى سەن ئۆزۈڭ بىزگە قاتتىق ئاگاھلاندۇردۇڭ: تاغنى «مۇقەددەس» دەپ قاراپ، ئۇنىڭ ئەتراپىغا پاسىللارنى بېكىتىڭلار، دەپ ئەمر قىلدىڭ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","پەرۋەردىگار مۇساغا: ــ ماڭ، سەن چۈشۈپ كەتكىن. ئاندىن سەن ھارۇننى ئېلىپ، بىللە چىققىن؛ لېكىن كاھىنلار ۋە خەلق بولسا پەرۋەردىگارنىڭ قېشىغا بارايلى دەپ پاسىلدىن بۆسۈپ ئۆتمىسۇن؛ بولمىسا، پەرۋەردىگار سېپىلنى بۆسكەندەك ئۇلارنىڭ ئۈستىگە چۈشىدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","شۇنىڭ بىلەن مۇسا خەلقنىڭ قېشىغا چۈشۈپ، ئۇلارغا بۇ سۆزنى يەتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","خۇدا مۇنۇ بارلىق سۆزلەرنى بايان قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","مەن سېنى «قۇللۇق ماكانى» بولغان مىسىر زېمىنىدىن چىقىرىپ كەلگەن پەرۋەردىگار خۇدايىڭدۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","سېنىڭ مەندىن باشقا ھېچقانداق ئىلاھىڭ بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","سەن ئۆزۈڭ ئۈچۈن مەيلى يۇقىرىدىكى ئاسماندا بولسۇن، مەيلى تۆۋەندىكى زېمىندا بولسۇن، ياكى يەر ئاستىدىكى سۇلاردا بولسۇن، ھەرقانداق نەرسىنىڭ قىياپىتىدىكى ھېچقانداق ئويما شەكىلنى ياسىما.    ");
INSERT INTO uigara_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","سەن بۇنداق نەرسىلەرگە باش ئۇرما ياكى ئۇلارنىڭ قۇللۇقىغا كىرمە. چۈنكى مەنكى پەرۋەردىگار خۇدايىڭ ۋاپاسىزلىققا ھەسەت قىلغۇچى تەڭرىدۇرمەن. مەندىن نەپرەتلەنگەنلەرنىڭ قەبىھلىكلىرىنى ئۆزلىرىگە، ئوغۇللىرىغا، ھەتتا نەۋرە-چەۋرىلىرىگىچە چۈشۈرىمەن، ");
INSERT INTO uigara_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ئەمما مېنى سۆيىدىغان ۋە ئەمرلىرىمنى تۇتىدىغانلارغا مىڭ ئەۋلادىغىچە ئۆزگەرمەس مېھرىبانلىق كۆرسىتىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","پەرۋەردىگار خۇدايىڭنىڭ نامىنى قالايمىقان تىلغا ئالما؛ چۈنكى كىمدەكىم نامىنى قالايمىقان تىلغا ئالسا، پەرۋەردىگار ئۇنى گۇناھكار ھېسابلىماي قالمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","شابات كۈنىنى مۇقەددەس دەپ بىلىپ تۇتقىلى يادىڭدا ساقلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ئالتە كۈن ئىشلەپ بارلىق ئىشلىرىڭنى تۈگەتكىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","لېكىن يەتتىنچى كۈنى پەرۋەردىگار خۇدايىڭغا ئاتالغان شابات كۈنىدۇر؛ سەن شۇ كۈنى ھېچقانداق ئىش قىلمايسەن؛ مەيلى سەن ياكى ئوغلۇڭ بولسۇن، مەيلى قىزىڭ، مەيلى قۇلۇڭ، مەيلى دېدىكىڭ، مەيلى بۇقاڭ ياكى سەن بىلەن بىر يەردە تۇرۇۋاتقان مۇساپىر بولسۇن، ھېچقانداق ئىش قىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","چۈنكى ئالتە كۈن ئىچىدە پەرۋەردىگار ئاسمان بىلەن زېمىننى، دېڭىز بىلەن ئۇنىڭ ئىچىدىكى بارىنى ياراتتى ئاندىن يەتتىنچى كۈنىدە ئارام ئالدى. بۇنىڭ ئۈچۈن پەرۋەردىگار شابات كۈنىنى بەخت-بەرىكەتلىك كۈن قىلىپ، ئۇنى مۇقەددەس كۈن دەپ بېكىتتى. ");
INSERT INTO uigara_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ئاتا-ئاناڭنى ھۆرمەت قىل. شۇنداق قىلساڭ پەرۋەردىگار خۇدايىڭ ساڭا ئاتا قىلماقچى بولغان زېمىندا ئۇزۇن ئۆمۈر كۆرىسەن. ");
INSERT INTO uigara_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","قاتىللىق قىلما. ");
INSERT INTO uigara_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","زىنا قىلما. ");
INSERT INTO uigara_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ئوغرىلىق قىلما. ");
INSERT INTO uigara_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","قوشناڭ توغرۇلۇق يالغان گۇۋاھلىق بەرمە. ");
INSERT INTO uigara_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","سەن قوشناڭنىڭ ئۆي-ئىمارىتىگە كۆز قىرىڭنى سالما، نە قوشناڭنىڭ ئايالى، نە ئۇنىڭ قۇلىغا، نە ئۇنىڭ دېدىكى، نە ئۇنىڭ كالىسى، نە ئۇنىڭ ئىشىكى ياكى قوشناڭنىڭ ھەرقانداق باشقا نەرسىسىگە كۆز قىرىڭنى سالما.    ");
INSERT INTO uigara_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","پۈتكۈل خەلق گۈلدۈرمامىلارنى، چېقىن-يالقۇنلارنى، كاناينىڭ ئاۋازى ۋە تاغدىن ئۆرلەپ چىققان ئىس-تۈتەكلەرنى كۆردى ۋە ئاڭلىدى؛ ئۇلار بۇلارنى كۆرۈپ، تىترىشىپ يىراق تۇرۇشتى ");
INSERT INTO uigara_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ۋە مۇساغا: ــ بىزگە سەنلا سۆز قىلغايسەن، بىز ئاڭلايمىز؛ لېكىن خۇدا بىزگە ئۆزى سۆز قىلمىسۇن؛ چۈنكى ئۇنداق قىلسا ئۆلۈپ كېتىمىز، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","مۇسا خالايىققا جاۋابەن: ــ قورقماڭلار؛ چۈنكى خۇدانىڭ بۇ يەرگە كېلىشى سىلەرنى سىناش ئۈچۈن، يەنى سىلەرنىڭ ئۇنىڭ دەھشەتلىكىنى كۆز ئالدىڭلارغا كەلتۈرۈپ، گۇناھ قىلماسلىقىڭلار ئۈچۈندۇر، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","شۇنىڭ بىلەن خالايىق نېرىدا تۇردى؛ لېكىن مۇسا خۇدا ئىچىدە تۇرغان قويۇق بۇلۇتنىڭ قېشىغا يېقىن باردى. ");
INSERT INTO uigara_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","پەرۋەردىگار مۇساغا: ــ سەن بېرىپ ئىسرائىللارغا مۇنۇ سۆزلەرنى يەتكۈزگىن: «سىلەرگە ئەرشتىن سۆز قىلغىنىمنى كۆردۈڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","سىلەر مېنىڭ ئورنۇمدا ئىلاھ دەپ كۈمۈشتىن بۇتلار ياسىماڭلار، ياكى ئۆزۈڭلار ئۈچۈن ئالتۇندىن بۇتلارنى ياسىماڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ــ سەن مەن ئۈچۈن تۇپراقتىن بىر قۇربانگاھ ياساپ، شۇ يەردە كۆيدۈرمە قۇربانلىق ۋە ئىناقلىق قۇربانلىقلىرىڭنى، قوي-ئۆچكە بىلەن كالىلىرىڭنى سۇنغىن. ئومۇمەن مەن خەلققە نامىمنى ھۆرمەت بىلەن ئەسلىتىدىغان بارلىق جايلاردا، يېنىڭغا كېلىپ ساڭا بەخت-بەرىكەت ئاتا قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ــ ئەگەر ماڭا ئاتاپ تاشلاردىن قۇربانگاھ ياسىماقچى بولساڭ، يونۇلغان تاشلاردىن ياسىمىغىن؛ چۈنكى تاشلارغا ئەسۋابىڭنى تەگكۈزسەڭ، ئۇلار ناپاك بولۇپ قالىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","قۇربانگاھىمغا چىقىدىغان پەلەمپەي بولمىسۇن؛ ئۇنداق بولغاندا، پەلەمپەيدىن چىققۇچە ئەۋرىتىڭ كۆرۈنۈپ قېلىشى مۇمكىن»، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ــ سەن ئۇلارنىڭ ئالدىغا قويىدىغان ھۆكۈم-بەلگىلىمىلەر مۇنۇلاردۇر: ــ ");
INSERT INTO uigara_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ئەگەر سەن بىر ئىبرانىي قۇلنى سېتىۋالغان بولساڭ، ئۇ ئالتە يىلغىچە خىزمىتىڭدە بولۇپ، يەتتىنچى يىلى تۆلەمسىز ھۆر قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ئۇ قۇل قىلىنىشقا تەنھا ھالەتتە ئېلىپ كېلىنگەن بولسا، تەنھا ھالەتتە كەتسۇن. ئايالى بىلەن بىرگە ئېلىپ كېلىنگەن بولسا، ئايالىمۇ ئۇنىڭ بىلەن بىللە كەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ئەگەر خوجىسى ئۇنىڭغا خوتۇن ئېلىپ بەرگەن بولسا، شۇنداقلا ئايالى ئۇنىڭغا ئوغۇل-قىزلارنى تۇغۇپ بەرگەن بولسا، ئايال بالىلىرى بىلەن خوجىسىغا قېلىپ، ئەر يالغۇز كەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","لېكىن ئەگەر قۇل ئېلان قىلىپ: «مەن خوجام، ئايالىم ۋە بالىلىرىمغا مۇھەببىتىم بولغىنى ئۈچۈن ھۆر بولۇپ كەتمەيمەن» دېسە، ");
INSERT INTO uigara_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ئۇنداقتا ئۇنىڭ خوجىسى ئۇنى خۇدانىڭ ئىبادەت سورۇنىنىڭ ئالدىغا ئېلىپ بېرىپ، ئۇنى ئىشىكنىڭ ئالدىدا ياكى ئىشىكنىڭ كېشىكىنىڭ ئالدىدا تۇرغۇزسۇن؛ ئاندىن خوجىسى بىگىز بىلەن ئۇنىڭ قۇلىقىنى تەشسۇن. شۇنداق قىلىپ، ئۇ مەڭگۈگە خوجىسىنىڭ قۇلى بولۇپ قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ئەگەر بىركىم قىزىنى دېدەكلىككە سېتىۋەتكەن بولسا، ئۇ ئەر قۇللار ھۆر قىلىنغاندەك ھۆر قىلىنمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ئەگەر ئۆزىگە خاس سېتىۋالغان قىز خوجىسىغا ياقمىسا، ئۇنداقتا ئۇ قىز تەرەپنىڭ ھەق تۆلەپ ئۇنى ھۆر قىلىشىغا يول قويۇشى كېرەك. لېكىن خوجىسىنىڭ ئۇنى يات خەلققە سېتىش ھوقۇقى بولمايدۇ؛ چۈنكى خوجىسى ئۇنىڭغا ۋاپاسىزلىق قىلغاندۇر. ");
INSERT INTO uigara_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ئەگەر ئۇ قىزنى ئوغلىغا خاس بېكىتكەن بولسا، ئۇنداقتا ئۇ بەلگىلىمىلەر بويىچە ئۇنىڭغا ئۆز قىزىدەك مۇئامىلە قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ئەگەر خوجىسى يەنە خوتۇن ئالسا، ئەسلىدە ئەمرىگە ئالغان دېدىكىنىڭ يېمەك-ئىچمىكىنى، كىيىم-كېچىكىنى ۋە ئەر-خوتۇنچىلىق بۇرچىنى كېمەيتمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ئەگەر ئۇ شۇ ئۈچ ئىشنى ئادا قىلمىسا، ئۇنداقتا ئۇ بەدەل تۆلىمەي ھۆر بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","كىمكى بىر ئادەمنى ئۇرۇپ ئۆلتۈرۈپ قويسا، ئۇمۇ چوقۇم ئۆلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","لېكىن ئەگەر ئۇ كىشى ئۆلگۈچىنىڭ جېنىنى پايلاپ تۇرۇپ قەستەن ئۆلتۈرمىگەن، بەلكى مەن خۇدا ئۇنىڭ قولى ئارقىلىق شۇ كىشىنىڭ ئۆلۈشىگە يول قويغان بولسام، ئۇنداق ئەھۋالدا مەن ئۇنىڭغا قاچىدىغان بىر جاينى ئورۇنلاشتۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","لېكىن ئەگەر بىرسى ئۆز قوشنىسىنى ھىيلە بىلەن ئۆلتۈرىمەن دەپ، ئۇنىڭغا قەستەن ھۇجۇم قىلسا، ئۇ گەرچە پاناھ ئىزدەپ قۇربانگاھىمغا قېچىپ كەلسىمۇ، ئۇ شۇ يەردە تۇتۇلسۇن ۋە ئۆلۈمگە مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","كىمكى ئۆز ئاتىسى ياكى ئانىسىغا قول تەگكۈزسە، چوقۇم ئۆلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","كىمكى بىر ئادەمنى بۇلاپ ساتقان بولسا ياكى ئۇنىڭ قولىدا بارلىقى مەلۇم بولسا، جەزمەن ئۆلتۈرۈلۈشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","كىمكى ئۆز ئاتىسى ياكى ئانىسىغا لەنەت قىلىپ قارغىغان بولسا، جەزمەن ئۆلتۈرۈلۈشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ئەگەر ئىككى كىشى ئۇرۇشۇپ قېلىپ، بىرى يەنە بىرىنى تاش يا موشتى بىلەن ئۇرسا، ئۇرۇلغان كىشى ئۆلمەي، ئورۇن تۇتۇپ يېتىپ قالغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ئۇ كىشى قوپۇپ ھاسىغا تايىنىپ تاشقىرىغا چىققۇدەك بولسا، ئۇنداقتا ئۇنى ئۇرغان كىشى جازادىن خالاس قىلىنسۇن؛ پەقەت زەخىملەنگۈچىنىڭ يېتىپ ئىشتىن قالغان ۋاقتى ئۈچۈن تۆلەم بېرىپ، ئۇنى داۋالىتىپ سەللىمازا ساقايتسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ئەگەر بىرسى قۇلى ياكى دېدىكىنى تاياقتا ئۇرسا، شۇنداقلا قۇل ياكى دېدەك نەق مەيداندا ئۆلۈپ كەتسە، ئۇنىڭ ئۈچۈن ئىگىسى چوقۇم جازاغا تارتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لېكىن ئەگەر تاياق يېگۈچى بىر-ئىككى كۈن تىرىك تۇرسا، ئۇنداقتا قۇل خوجايىنىنىڭ شەخسى مال-مۈلكى بولغىنى ئۈچۈن، قۇلنىڭ جازاسىغا تارتىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ئەگەر كىشىلەر بىر-بىرى بىلەن ئۇرۇشۇپ قېلىپ، ھامىلىدار بىر ئايالنى ئۇرۇپ سالسا، ھامىلىدار ئايالدا بالىسى بالدۇر تۇغۇلۇشىدىن باشقا زەخىملىنىش بولمىسا، ئايالنىڭ ئېرىنىڭ تۆلەم تەلىپى بويىچە ھاكىملارنىڭ تەستىقىدىن ئۆتكۈزۈلۈپ جەرىمانە تۆلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ئەگەر ئايال ياكى بالا زىيان-زەخەتكە ئۇچرىغان بولسا، ئۇنداقتا جېنىغا جان، ");
INSERT INTO uigara_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","كۆزىگە كۆز، چىشىغا چىش، قولىغا قول، پۇتىغا پۇت، ");
INSERT INTO uigara_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","كۆيۈككە كۆيۈك، زەخىمگە زەخىم، كۆككە كۆك تۆلەنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ئەگەر بىرسى ئۆز قۇل يا دېدىكىنىڭ كۆزىنى ئۇرۇپ ناكار قىلىپ قويسا، كۆزى ۋەجىدىن ئۇنى ئازاد قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","شۇنىڭدەك بىرسى ئۆز قۇلى يا دېدىكىنىڭ چىشىنى ئۇرۇپ چىقىرىۋەتكەن بولسا، چىشى ۋەجىدىن ئۇنى ئازاد قىلسۇن». ");
INSERT INTO uigara_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ئەگەر بىر كالا بىر ئەر ياكى ئايال كىشىنى ئۈسۈپ ئۆلتۈرۈپ قويسا، شۇ كالا چوقۇم چالما-كېسەك قىلىنىشى كېرەك، ئۇنىڭ گۆشى يېيىلمىسۇن. لېكىن كالىنىڭ ئىگىسىگە گۇناھ كەلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","لېكىن بۇ ئۇينىڭ ئىلگىرىدىن ئۈسۈش ئادىتى بولۇپ، ئىگىسىگە بۇ ھەقتە ئاگاھ بېرىلگەن بولسا، لېكىن يەنىلا ئۇنى باغلىمىغىنى ئۈچۈن ئەر-ئايال كىشىلەرنى ئۈسۈپ ئۆلتۈرۈپ قويغان بولسا، ئۇنداقتا كالا چالما-كېسەك قىلىنسۇن، ئىگىسىمۇ ئۆلۈمگە مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","لېكىن ئۇنىڭدىن خۇن ھەققى تەلەپ قىلىنسا، ئۆز جېنىنىڭ ئورنىدا ئۇنىڭغا قانچىلىك تۆلەم قويۇلغان بولسا شۇنى بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","كالىدىن ئۈسۈلگۈچى ئوغۇل ياكى قىز بالا بولسا، كالىنىڭ ئىگىسى ئوخشاشلا يۇقىرىقى ھۆكۈمدىكىدەك بىر تەرەپ قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","كالا قۇل ياكى دېدەكنى ئۈسكەن بولسا، كالىنىڭ ئىگىسى ئۈسۈلگۈچىنىڭ خوجىسىغا ئوتتۇز شەكەل كۈمۈش بەرسۇن؛ ئاندىن كالا چالما-كېسەك قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ئەگەر بىرسى بىر ئورىنىڭ ئاغزىنى ئوچۇق قويۇپ ياكى كولاۋاتقان ئورىنىڭ ئاغزىنى ياپماي، كالا ياكى ئېشەك ئۇنىڭغا چۈشۈپ كەتسە، ");
INSERT INTO uigara_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ئۇنداقتا ئورىنىڭ ئىگىسى مال ئىگىسىنىڭ زىيىنىنى تولۇق تۆلەپ بەرسۇن؛ ئۆلگەن مال ئۇنىڭكى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ئەگەر بىرسىنىڭ كالىسى يەنە بىرسىنىڭ كالىسىنى ئۈسۈپ ئۆلتۈرۈپ قويغان بولسا، ئۇنداقتا ئۇلار تىرىك قالغان كالىنى سېتىپ، پۇلنى باراۋەر بۆلۈشسۇن ھەم ئۆلۈك كالىنىمۇ شۇنداق بۆلۈشسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","لېكىن كالىنىڭ ئىلگىرىدىن ئۈسىدىغان ئادىتى بارلىقى ئېنىق تۇرۇپ، ئىگىسى ئۇنى باغلىماي قويۇۋەتكەن بولسا، ئۇنداقتا ئۈسكۈچى كالىنىڭ ئىگىسى كالىغا كالا تۆلەپ بەرسۇن، ئۆلۈك كالا ئۇنىڭ بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ئەگەر بىرسى بىر كالا ياكى قوينى ئوغرىلاپ، ئۇنى سويسا يا سېتىۋەتسە، ئۇ بىر كالىنىڭ ئورنىغا بەش كالا، بىر قوينىڭ ئورنىغا تۆت قوي تۆلىسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ئوغرى تام تەشكەندە تۇتۇلۇپ قېلىپ، تاياق يەپ ئۆلۈپ قالسا، ئۆلتۈرگۈچىگە خۇن جازاسى كەلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","لېكىن شۇ ۋەقە بولغان پەيتتە كۈن چىقىپ قالغان بولسا، ئۇنداقتا ئۆلتۈرگۈچى خۇن جازاسىغا تارتىلسۇن. ئوغرى ئوغرىلىغىنىنى تۆلەپ زىياننى تولۇقلاپ بېرىشى كېرەك؛ ئۇنىڭدا بىر نېمە بولمىسا، قۇللۇققا سېتىلىپ، ئوغرىلىغان نەرسىنى تۆلىشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ئوغرى تۇتۇلغاندا ئوغرىلىغان نەرسە، كالا بولسۇن، ئېشەك بولسۇن، قوي بولسۇن ئۇنىڭ قولىدا تىرىك ھالەتتە تېپىلسا، ئۇ ئىككى ھەسسە قىممەتتە تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ئەگەر بىرسى ئۆز مال-چارۋىلىرىنى ئېتىزلىققا ياكى ئۈزۈمزارلىققا ئوتلاشقا قويۇۋېتىپ، باشقىلارنىڭ باغ-ئېتىزلىقىدا ئوتلاشقا يول قويسا، ئۇنداقتا ئۇ ئۆزىنىڭ ئەڭ ئېسىل مەھسۇلاتلىرىدىن ياكى ئۈزۈمزارلىقىنىڭ ئەڭ ئېسىل مېۋىسىدىن زىياننى تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ئەگەر ئوت كېتىپ، تىكەنلىككە تۇتىشىپ كېتىپ، ئاندىن ئۆنچىلەرنى، باش تارتىپ پىشقان زىرائەتنى كۆيدۈرۈپ، پۈتكۈل ئېتىزلىقنى كۈل قىلىۋەتسە، ئۇنداقتا ئوت قويغۇچى بارلىق زىياننى تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ئەگەر بىرسى قوشنىسىغا پۇل ياكى مال-دۇنياسىنى ئامانەت قىلغان بولسا، بۇلار ئۆيىدىن ئوغرىلىنىپ كەتسە، شۇنداقلا ئوغرى كېيىن تۇتۇلسا، ئۇ ئوغرىلىغىنىنى ئىككى ھەسسە قىممەتتە تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","لېكىن ئوغرى تېپىلمىسا، ئۆي ئىگىسىنىڭ قوشنىسىنىڭ مېلىغا قول تەگكۈزگەن يا تەگكۈزمىگەنلىكى مەلۇم بولسۇن دەپ، ھاكىملارنىڭ ئالدىغا كەلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ھەرخىل خىيانەت، ئۇ مەيلى كالا، ئېشەك، قوي، كىيىم-كېچەك بولسۇن، يىتتۈرۈپ قويغان نەرسە بولسۇن، ئۇلار توغرۇلۇق بىر قوشنىسى: «ئەمەلىيەتتە مۇنداق ئىدى» دەپ تالاشقان بولسا، ھەر ئىككىسىنىڭ دەۋاسى ھاكىملارنىڭ ئالدىغا كەلتۈرۈلسۇن؛ ھاكىملار قايسىغا گۇناھ بېكىتسە، شۇ قوشنىسىغا ئىككى ھەسسە قىممەتتە تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ئەگەر بىرسى قوشنىسىغا ئېشەك، كالا، قوي ياكى باشقا بىر چارپاينى ئامانەت قىلسا، بۇ ئامانەت مېلى كىشى كۆرمەي ئۆلۈپ كەتسە، ياكى زەخىملەنسە، ياكى ھەيدەپ ئەكىتىلسە، ");
INSERT INTO uigara_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ئۇنداقتا قوشنىسىنىڭ مېلىغا قول تەگكۈزگەن يا تەگكۈزمىگەنلىكى مەلۇم بولسۇن دەپ، پەرۋەردىگارنىڭ ئالدىدا ئۇلارنىڭ ئوتتۇرىسىدا بىر قەسەم ئىچۈرۈلسۇن. مال ئىگىسى بۇ قەسەمنى قوبۇل قىلسۇن؛ قوشنىسى ئۇنىڭغا تۆلەم تۆلەپ بەرمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","لېكىن مال ئوغرىلانغان بولسا، ئۇ ئىگىسىگە تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ئەگەر ئۇنى ۋەھشىي ھايۋان بوغۇپ قويغان بولسا، ئۇ مالنىڭ قالدۇقىنى گۇۋاھلىق ئۈچۈن كۆرسىتىپ، ئۇنى تۆلەپ بەرمىسىمۇ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ئەگەر بىرسى قوشنىسىدىن بىر ئۇلاغنى ئۆتنە ئېلىپ، ئۇلاغ ئىگىسى يوق يەردە زەخىملەنسە ياكى ئۆلۈپ قالسا، ئۆتنە ئالغۇچى تولۇق تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","لېكىن ئىگىسى نەق مەيداندا بولسا، ئۆتنە ئالغۇچى تۆلەپ بەرمىسۇن؛ ئۇلاغ ئىجارىگە ئېلىنغان بولسا، ئالغۇچى تۆلەم تۆلىمىسۇن؛ چۈنكى ئۇنى ئىجارە تۆلەپ ئەكەلگەن. ");
INSERT INTO uigara_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ئەگەر بىر ئادەم تېخى ياتلىق بولمىغان بىر قىزنى ئازدۇرۇپ، ئۇنىڭ بىلەن بىللە ياتسا، ئۇنداقتا ئۇ ئۇنىڭ تويلۇقىنى بېرىشى كېرەك، ئاندىن ئۇنى خوتۇنلۇققا ئالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","لېكىن قىزنىڭ ئاتىسى ئۇنى ئۇنىڭغا بەرگىلى ئۇنىمىسا، زىنا قىلغۇچى پاك قىزلارنىڭ تويلۇقىغا باراۋەر كېلىدىغان كۈمۈش پۇلنى تارازىدا ئۆلچەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","جادۇگەر خوتۇننى تىرىك قويمىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ھايۋان بىلەن جىنسىي مۇناسىۋەت ئۆتكۈزگەن ھەربىرى جەزمەن ئۆلۈمگە مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","كىمدەكىم بىردىنبىر پەرۋەردىگاردىن باشقا ھەرقانداق ئىلاھغا قۇربانلىق سۇنسا، ھارام دەپ مۇتلەق ھالاكەتكە مەھكۇم قىلىنسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","سىلەرمۇ مىسىردا مۇساپىر بولۇپ تۇرغانىكەنسىلەر، مۇساپىر بولغان كىشىنى ھېچ خارلىماڭلار ۋە ياكى ئۇنىڭغا ھېچ زۇلۇم قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ھەرقانداق تۇل خوتۇن ياكى يېتىم بالىنى خورلىماڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","سەن ئۇلارنى ھەرقانداق تەرەپتە خورلىساڭ، ئۇلار ماڭا پەرياد كۆتۈرسە، مەن ئۇلارنىڭ ئاۋازىنى چوقۇم ئاڭلايمەن؛ ");
INSERT INTO uigara_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","شۇنىڭ بىلەن غەزىپىم تۇتىشىپ، سىلەرنى قىلىچلاپ ئۆلتۈرىمەن، سىلەرنىڭ خوتۇنلىرىڭلار تۇل قىلىنىپ، بالىلىرىڭلار يېتىم بولۇپ قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ئەگەر سەن مېنىڭ خەلقىمنىڭ ئىچىدىن ساڭا قوشنا بولغان كەمبەغەلگە قەرز بەرگەن بولساڭ، ئۇنىڭغا جازانىخورلاردەك مۇئامىلە قىلمىغىن؛ ئۇنىڭدىن ئۆسۈم ئالماڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ئەگەر سەن قوشناڭنىڭ چاپىنىنى گۆرۈگە ئالغان بولساڭ، كۈن ئولتۇرماستا ئۇنىڭغا ياندۇرۇپ بەر. ");
INSERT INTO uigara_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","چۈنكى چاپىنى ئۇنىڭ بىردىنبىر يېپىنچىسى بولۇپ، بەدىنىنى ياپىدىغان كىيىم شۇدۇر. ئۇ بولمىسا، ئۇ نېمىنى يېپىنىپ ياتىدۇ؟ بۇ سەۋەبتىن ماڭا پەرياد قىلسا، پەريادىنى ئاڭلايمەن؛ چۈنكى مەن شەپقەتلىكتۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","ھاكىملارغا كۇپۇرلۇق قىلما، ۋە خەلقىڭنىڭ ئەمىرلىرىنىمۇ قارغاپ تىللىما.    ");
INSERT INTO uigara_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","خامىنىڭنىڭ ھوسۇلىنىڭ ئاشقىنىدىن ۋە شاراب-زەيتۇن مېيى كۆلچىكىڭدىن تاشقىنىدىن ماڭا ھەدىيە سۇنۇشنى ھايال قىلمىغىن. سەن ئوغۇللىرىڭنىڭ تۇنجىسىنى ماڭا ئاتىغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","كالا بىلەن قويلىرىڭنىڭ تۇنجى بالىلىرىنىمۇ ھەم شۇنداق ئاتىغىن؛ تۇنجى بالا يەتتە كۈنگىچە ئانىسى بىلەن بىللە تۇرسۇن؛ ئەمما سەككىزىنچى كۈنى ئۇنى ماڭا ئاتاپ سۇنغىن. ");
INSERT INTO uigara_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","سىلەر ماڭا ئاتالغان مۇقەددەس كىشىلەر بولىسىلەر؛ شۇڭا دالادا يىرتقۇچ ھايۋان تەرىپىدىن بوغۇلغان ھايۋاننىڭ گۆشىنى يېمەڭلار، بەلكى ئۇنى ئىتلارغا تاشلاپ بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","يالغان گەپنى يايمىغىن ۋە يا يالغان گۇۋاھلىق بېرىپ رەزىل ئادەمگە يان باسمىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","توپقا ئەگىشىپ رەزىل ئىشتا بولما ياكى دەۋا-دەستۇرلاردا گۇۋاھلىق بەرگەندە توپقا ئەگىشىپ ھەقىقەتنى بۇرمىلىما. ");
INSERT INTO uigara_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","كەمبەغەل دەۋا قىلسا، ئۇنىڭغا يان باسما. ");
INSERT INTO uigara_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","دۈشمىنىڭنىڭ كالا يا ئېشىكى ئېزىپ كېتىپ، ساڭا ئۇچراپ قالسا، ئۇنى ئېلىپ كېلىپ، ئىگىسىگە چوقۇم تاپشۇرۇپ بەر. ");
INSERT INTO uigara_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ئەگەر ساڭا ئۆچ بولغاننىڭ ئېشىكى يۈكنى كۆتۈرەلمەي يۈكنىڭ ئاستىدا ياتقىنىنى كۆرسەڭ، ئۇنى ياردەمسىز تاشلىماي، بەلكى ئۇنىڭغا ياردەملىشىپ ئېشىكىنى قوپۇرۇشۇپ بېرىشىڭ زۆرۈر. ");
INSERT INTO uigara_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","ئاراڭدىكى كەمبەغەلنىڭ دەۋاسىدا ئادالەتنى بۇرمىلىما. ");
INSERT INTO uigara_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ھەرقانداق ساختا ئىشتىن ئۆزۈڭنى نېرى تارت؛ بىگۇناھ ئادەم بىلەن ھەققانىي ئادەمنى ئۆلتۈرمىگىن؛ چۈنكى مەن رەزىل ئادەمنى ھەرگىز ئادىل دەپ ئاقلىمايمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","شۇنىڭدەك ھېچقانداق پارا يېمە؛ چۈنكى پارا كۆزى ئوچۇقلارنى كور قىلىپ، ھەققانىيلارنىڭ سۆزلىرىنى بۇرمىلايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","مۇساپىر كىشىلەرگە زۇلۇم قىلما؛ چۈنكى ئۆزۈڭلار مىسىر زېمىنىدا مۇساپىر بولۇپ تۇرغان بولغاچقا، مۇساپىرنىڭ روھىي ھالىنى بىلىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ئالتە يىل ئۆز يېرىڭنى تېرىپ، ھوسۇللىرىنى ئال. ");
INSERT INTO uigara_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","لېكىن يەتتىنچى يىلى يەرگە ئارام بېرىپ ئۇنى بوش قوي؛ خەلقىڭنىڭ نامراتلىرى ئۇنىڭدىن يىغىپ يېسۇن، ئۇلاردىن ئاشقىنىنى جاڭگالدىكى ھايۋانلار يېسۇن؛ شۇنداقلا ئۈزۈمزارلىقىڭ بىلەن زەيتۇنزارلىقىڭنىمۇ شۇنداق قىلغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ئالتە كۈن ئىچىدە ئۆز ئىشىڭنى ئادا قىلىپ، يەتتىنچى كۈنى ئارام ئېلىشىڭ زۆرۈر. بۇنىڭ بىلەن كالا-ئېشەكلىرىڭ ئارام تاپىدۇ، دېدىكىڭنىڭ ئوغلى بىلەن مۇساپىر كىشىمۇ ھاردۇقىنى چىقىرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","مەن ساڭا ئېيتقىنىمنىڭ ھەممىسىنى كۆڭۈل بۆلۈپ ئادا قىل؛ باشقا ئىلاھلارنىڭ نامىنى تىلىڭغا ئالما؛ بۇلار ھەتتا ئاغزىڭغىمۇ چىقمىسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ھەر يىلدا ئۈچ قېتىم مېنىڭ ئۈچۈن ھېيت ئۆتكۈزگىن. ");
INSERT INTO uigara_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ئالدى بىلەن «پېتىر نان ھېيتى»نى ئۆتكۈز؛ ساڭا ئەمر قىلغىنىمدەك ئابىب ئېيىدىكى بېكىتىلگەن كۈنلەردە يەتتە كۈن پېتىر نان يېگىن؛ چۈنكى شۇ ئايدا سەن مىسىردىن چىققانىدىڭ. شۇ ھېيتتا ھېچكىشى ئالدىمغا قۇرۇق قول كەلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","سەن ئەجىر قىلىپ تېرىغان ئېتىزدىكى زىرائىتىڭنىڭ تۇنجى ھوسۇلىنى ئورغاندا «ئورما ھېيتى»نى ئۆتكۈز؛ شۇنداقلا سەن ئەجىر سىڭدۈرۈپ يەردىن ئاخىرقى ھوسۇل-مەھسۇلاتلىرىڭنى يىل ئاخىرىدا يىغقاندا «ھوسۇل يىغىش ھېيتى»نى ئۆتكۈز. ");
INSERT INTO uigara_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","يىلدا ئۈچ قېتىم ئەركەكلىرىڭنىڭ ھەممىسى رەب پەرۋەردىگارنىڭ ھۇزۇرىغا ھازىر بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","سەن ماڭا ئاتالغان قۇربانلىقنىڭ قېنىنى خېمىرتۇرۇچ سېلىنغان نان بىلەن سۇنمىغىن؛ ھېيت قۇربانلىقىنىڭ يېغىنى بولسا كېچىچە قوندۇرۇپ ئەتىگىچىگە ساقلىما. ");
INSERT INTO uigara_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","زېمىنىڭدىكى دەسلەپكى ھوسۇلنىڭ ئەڭ ياخشسىنى پەرۋەردىگار خۇدايىڭنىڭ ئۆيىگە ئېلىپ كەل. ئوغلاقنى ئانىسىنىڭ سۈتىدە قاينىتىپ پىشۇرما.    ");
INSERT INTO uigara_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","مانا، مەن بىر پەرىشتىنى يولدا سېنى قوغداپ، مەن ساڭا تەييارلىغان يەرگە ئېلىپ بارسۇن دەپ، ئالدىڭدا يۈرۈشكە ئەۋەتىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","سەن ئۇنىڭ ئالدىدا ئۆزۈڭگە ئاگاھ بول، ئۇنىڭ ئاۋازىغا قۇلاق سال. ئۇنىڭ زىتىغا تەگمە؛ بولمىسا، ئۇ ئىتائەتسىزلىكلىرىڭنى كەچۈرمەيدۇ؛ چۈنكى مېنىڭ نامىم ئۇنىڭدىدۇر. ");
INSERT INTO uigara_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","لېكىن ئەگەر سەن ئۇنىڭ ئاۋازىغا قۇلاق سېلىپ، مېنىڭ بارلىق بۇيرۇغانلىرىمغا ئەمەل قىلساڭ، مەن دۈشمەنلىرىڭگە دۈشمەن، كۈشەندىلىرىڭگە كۈشەندە بولىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","چۈنكى مېنىڭ پەرىشتەم ئالدىڭدا يۈرۈپ، سېنى ئامورىي، ھىتتىي، پەرىززىي، قانائانىي، ھىۋىي ۋە يەبۇسىيلارنىڭ زېمىنىغا باشلاپ كىرىدۇ؛ مەن ئۇلارنى يوقىتىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","سەن ئۇلارنىڭ ئىلاھلىرىغا باش ئۇرۇپ ئىبادەت قىلما ۋە ياكى ئۇلار قىلغاندەك قىلما؛ بەلكى ئۇلارنىڭ بۇتلىرىنى ئۈزۈل-كېسىل چېقىۋەت، بۇت تۈۋرۈكلىرىنى ئۈزۈل-كېسىل كۇكۇم-تالغان قىلىۋەت؛ ");
INSERT INTO uigara_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","لېكىن خۇدايىڭلار پەرۋەردىگارنىڭ ئىبادىتىدە بولۇڭلار. شۇنداق قىلساڭلار ئۇ نان بىلەن سۈيۈڭلارنى بەرىكەتلەيدۇ؛ مەن بارلىق كېسەللىكنى ئاراڭلاردىن چىقىرىپ تاشلايمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","بۇنىڭ بىلەن زېمىنىڭدا بويىدىن ئاجراپ كېتىدىغان ياكى تۇغماس ھېچبىر ئايال ياكى چارپاي بولمايدۇ؛ ئۆمرۈڭنىڭ كۈنلىرىنى تولۇق قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","مەن سېنىڭ ئالدىڭدا ۋەھىمىمنى ئەۋەتىمەن، قايسى تائىپىگە يېقىنلاشساڭ شۇلارنى پاراكەندە قىلىمەن؛ شۇنىڭ بىلەن ھەممە دۈشمەنلىرىڭنى كەينىگە ياندۇرۇپ قاچۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ھىۋىيلار، قانائانىيلار ۋە ھىتتىيلارنى ئالدىڭدىن قوغلاپ چىقىرىۋېتىشكە سېرىق ھەرىلەرنى ئالدىڭدا يۈرۈشكە ئەۋەتىمەن.    ");
INSERT INTO uigara_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ئەمما زېمىننىڭ خارابىلىشىپ، دالادا ۋەھشىي ھايۋانلار ئاۋۇپ ساڭا خەۋپ بولۇپ قالماسلىقى ئۈچۈن، شۇ ئەللەرنى ئالدىڭدىن بىر يىلغىچە ھەيدىۋەتمەيمەن، ");
INSERT INTO uigara_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","بەلكى سەن ئاۋۇپ، زېمىننى پۈتۈنلەي مىراس قىلىپ بولغۇچە، ئاز-ئازدىن ھەيدەپ تۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","سېنىڭ زېمىنىڭنىڭ چېگرىلىرىنى قىزىل دېڭىزدىن تارتىپ فىلىستىيلەرنىڭ دېڭىزىغىچە، شۇنىڭدەك چۆلدىن تارتىپ ئەفرات دەرياسىغىچە بېكىتىمەن؛ چۈنكى زېمىندا تۇرۇۋاتقانلارنى ھەيدىۋېتىپ يېرىنى ئىگىلىشىڭ ئۈچۈن، ئۇلارنى قولۇڭغا تاپشۇرىمەن.    ");
INSERT INTO uigara_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","سەن ئۇلار بىلەن ۋە ياكى ئىلاھلىرى بىلەن ھېچقانداق بىر ئەھدە تۈزمە. ");
INSERT INTO uigara_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ئۇلارنىڭ سېنى ئالدىمدا گۇناھقا پاتقۇزماسلىقى ئۈچۈن ئۇلارنى زېمىنىڭدا قەتئىي تۇرغۇزما. چۈنكى مۇبادا سەن ئۇلارنىڭ ئىلاھلىرىنىڭ ئىبادىتىدە بولساڭ، بۇ ئىش ساڭا تۇزاق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ئۇ مۇساغا يەنە: ــ «سەن بېرىپ، ئۆزۈڭ بىلەن بىللە ھارۇن، ناداب، ئابىھۇنى ۋە ئىسرائىللارنىڭ ئاقساقاللىرى ئارىسىدىن يەتمىش ئادەمنى ئېلىپ، پەرۋەردىگارنىڭ ھۇزۇرىغا چىقىپ، يىراقتا تۇرۇپ سەجدە قىلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","پەقەت مۇسالا پەرۋەردىگارنىڭ ئالدىغا يېقىن كەلسۇن؛ باشقىلار يېقىن كەلمىسۇن، خەلق ئۇنىڭ بىلەن بىللە ئۈستىگە چىقمىسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","مۇسا كېلىپ پەرۋەردىگارنىڭ بارلىق سۆزلىرى بىلەن ھۆكۈملىرىنى خالايىققا دەپ بەردى؛ پۈتكۈل خالايىق بىر ئاۋازدا: ــ پەرۋەردىگارنىڭ ئېيتقان سۆزلىرىنىڭ ھەممىسىگە ئەمەل قىلىمىز! ــ دەپ جاۋاب بېرىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ئاندىن مۇسا پەرۋەردىگارنىڭ ھەممە سۆزىنى خاتىرىلىۋېلىپ، ئەتىسى سەھەر قوپۇپ تاغنىڭ تۈۋىدە بىر قۇربانگاھنى ياساپ، شۇ يەردە ئىسرائىلنىڭ ئون ئىككى قەبىلىسىنىڭ سانى بويىچە ئون ئىككى تاش تۈۋرۈكنى تىكلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","يەنە ئىسرائىللارنىڭ بىرنەچچە يىگىتلىرىنى ئەۋەتتى، ئۇلار بېرىپ پەرۋەردىگارغا كۆيدۈرمە قۇربانلىقلار سۇندى، ئىناقلىق قۇربانلىقى سۈپىتىدە بىرنەچچە تورپاقنىمۇ سويۇپ سۇندى. ");
INSERT INTO uigara_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ئاندىن مۇسا قاننىڭ يېرىمىنى قاچىلارغا قاچىلىدى، يەنە يېرىمىنى قۇربانگاھ ئۈستىگە چاچتى. ");
INSERT INTO uigara_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ئاندىن ئۇ ئەھدىنامىنى قولىغا ئېلىپ، خەلققە ئوقۇپ بەردى. ئۇلار جاۋابەن: ــ پەرۋەردىگارنىڭ ئېيتقىنىنىڭ ھەممىسىگە قۇلاق سېلىپ، ئىتائەت قىلىمىز! ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","شۇنىڭ بىلەن مۇسا قاچىلاردىكى قاننى ئېلىپ، خەلققە سېپىپ: ــ مانا، بۇ پەرۋەردىگار مۇشۇ سۆزلەرنىڭ ھەممىسىگە ئاساسەن سىلەر بىلەن باغلىغان ئەھدىنىڭ قېنىدۇر، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ئاندىن كېيىن مۇسا ۋە ھارۇن، ناداب ۋە ئابىھۇ ئىسرائىللارنىڭ ئاقساقاللىرىدىن يەتمىش ئادەم بىلەن بىللە تاغ ئۈستىگە چىقىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ئۇلار شۇ يەردە ئىسرائىلنىڭ خۇداسىنى كۆردى؛ ئۇنىڭ ئايىغىنىڭ ئاستىدا خۇددى كۆك ياقۇتتىن ياسالغان نەپىس پاياندازدەك، ئاسمان گۈمبىزىدەك سۈپسۈزۈك بىر جىسىم بار ئىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","لېكىن ئۇ ئىسرائىللارنىڭ مۆتىۋەرلىرىگە قول تەگكۈزمىدى؛ ئۇلار خۇدانى كۆرۈپ تۇردى ھەمدە يەپ-ئىچىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","پەرۋەردىگار مۇساغا: ــ تاغ ئۈستىگە، قېشىمغا چىقىپ شۇ يەردە تۇرغىن. ساڭا ئۇلارغا ئۆگىتىشكە تاش تاختايلارنى، يەنى مەن يېزىپ قويغان قانۇن-ئەمرنى بېرىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","شۇنىڭ بىلەن مۇسا قوپۇپ، ياردەمچىسى يەشۇئانى ئېلىپ ماڭدى. مۇسا خۇدانىڭ تېغىغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ئۇ ئاۋۋال ئاقساقاللارغا: بىز يېنىپ كەلگۈچە مۇشۇ يەردە بىزنى ساقلاپ تۇرۇڭلار. مانا، ھارۇن بىلەن خۇر سىلەرنىڭ يېنىڭلاردا قالىدۇ؛ ئەگەر بىرسىنىڭ ئىش-دەۋاسى چىقسا، ئۇلارنىڭ ئالدىغا بارسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","شۇنىڭ بىلەن مۇسا تاغنىڭ ئۈستىگە چىقتى ۋە تاغنى بۇلۇت قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","پەرۋەردىگارنىڭ جۇلاسى سىناي تېغىنىڭ ئۈستىدە توختىدى؛ بۇلۇت ئۇنى ئالتە كۈنگىچە قاپلاپ تۇردى؛ يەتتىنچى كۈنى، پەرۋەردىگار بۇلۇت ئىچىدىن مۇسانى چاقىردى؛ ");
INSERT INTO uigara_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","پەرۋەردىگارنىڭ جۇلاسىنىڭ قىياپىتى ئىسرائىللارنىڭ كۆز ئالدىدا تاغنىڭ چوققىسىدا ھەممىنى يۇتقۇچى ئوتتەك كۆرۈندى. ");
INSERT INTO uigara_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","مۇسا بۇلۇتنىڭ ئىچىگە كىرىپ، تاغنىڭ ئۈستىگە چىقىپ كەتتى. مۇسا قىرىق كېچە-كۈندۈز تاغدا تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","سەن ئىسرائىللارغا ئېيتقىن، ئۇلار ماڭا بىر «كۆتۈرمە ھەدىيە»نى كەلتۈرسۇن؛ كىمنىڭ كۆڭلى ھەدىيە سۇنۇشقا خۇش بولسا، ئۇنىڭدىن ماڭا سۇنۇلىدىغان «كۆتۈرمە ھەدىيە»نى تاپشۇرۇۋېلىڭلار.    ");
INSERT INTO uigara_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","سىلەر ئۇلاردىن تاپشۇرۇۋالىدىغان كۆتۈرمە ھەدىيە: ــ ئالتۇن، كۈمۈش، مىس، ");
INSERT INTO uigara_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","كۆك، سۆسۈن ۋە قىزىل رەڭلىك يىپ، كاناپ رەخت، تىۋىت، ");
INSERT INTO uigara_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","قىزىل بويالغان قوچقارنىڭ تېرىلىرى، دېلفىننىڭ تېرىلىرى، ئاكاتسىيە ياغىچى، ");
INSERT INTO uigara_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","چىراغ ئۈچۈن زەيتۇن مېيى، «مەسىھلەش مېيى» ۋە خۇشبۇي ئۈچۈن خۇشبۇي دورا-دەرمەكلەر، ");
INSERT INTO uigara_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ئەفود بىلەن «قوشېن»غا ئورنىتىلىدىغان ئاق ھېقىق ۋە باشقا ئېسىل تاشلار بولسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","مېنىڭ ئۆزلىرى ئارىسىدا ماكان قىلىشىم ئۈچۈن شۇلاردىن ماڭا بىر مۇقەددەس تۇرالغۇنى ياسىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ئۇنى مەن ساڭا بارلىق كۆرسەتمەكچى بولغىنىمغا ئاساسەن، يەنى ئىبادەت چېدىرىنىڭ نۇسخىسى ۋە بارلىق ئەسۋاب-سايمانلىرىنىڭ نۇسخىسىغا ئوپئوخشاش قىلىپ ياساڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ئۇلار ئاكاتسىيە ياغىچىدىن بىر ساندۇق ياسىسۇن. ئۇنىڭ ئۇزۇنلۇقى ئىككى يېرىم گەز، كەڭلىكى بىر يېرىم گەز، ئېگىزلىكى بىر يېرىم گەز بولسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","سەن ئۇنى ساپ ئالتۇن بىلەن قاپلىغىن؛ ئىچى ۋە سىرتىنى ئالتۇن بىلەن قاپلاپ، ئۇنىڭ ئۈستۈنكى قىسمىنىڭ چۆرىسىگە ئالتۇندىن گىرۋەك چىقار. ");
INSERT INTO uigara_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ئۇنىڭغا ئالتۇندىن تۆت ھالقا قۇيدۇرۇپ، تۆت چېتىقىغا بېكىتكىن. بىر تەرىپىگە ئىككى ھالقا، يەنە بىر تەرىپىگە ئىككى ھالقا بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","سەن ھەم ئاكاتسىيە ياغىچىدىن ئىككى بالداق ياساپ، ھەر ئىككىسىنى ئالتۇن بىلەن قاپلىغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ئاندىن ساندۇق ئۇلار ئارقىلىق كۆتۈرۈلسۇن دەپ، بالداقلارنى ساندۇقنىڭ ئىككى يېنىدىكى ھالقىلىرىدىن ئۆتكۈزۈپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","بالداقلار ھەمىشە ساندۇقتىكى ھالقىدا تۇرسۇن؛ ئۇلار ئۇنىڭدىن چىقىرىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","مەن ساڭا بېرىدىغان ھۆكۈم-گۇۋاھلىقنى ساندۇققا قويغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ساندۇقنىڭ ياپقۇچى سۈپىتىدە سەن ئالتۇندىن ئۇزۇنلۇقى ئىككى يېرىم گەز، كەڭلىكى بىر يېرىم گەز بولغان بىر «كەفارەت تەختى» ياسىغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ئىككى كېرۇبنى ئالتۇندىن سوقۇپ ياسىغىن. ئۇلارنى كەفارەت تەختىنىڭ ئىككى تەرىپىگە ئورناتقىن.    ");
INSERT INTO uigara_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","بىر كېرۇبنى بىر تەرىپىگە، يەنە بىر كېرۇبنى يەنە بىر تەرىپىگە ئورنىتىش ئۈچۈن ياسىغىن. ئىككى تەرىپىدىكى كېرۇبلارنى كافارەت تەختى بىلەن بىر گەۋدە قىلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","كېرۇبلار بىر-بىرىگە يۈزلەنسۇن، قاناتلىرىنى كەفارەت تەختىنىڭ ئۈستىگە كېرىپ، قاناتلىرى بىلەن ئۇنى ياپسۇن؛ كېرۇبلارنىڭ يۈزى كەفارەت تەختىگە قارىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","سەن كەفارەت تەختىنى ساندۇقنىڭ ئۈستىگە قويۇپ، مەن ساڭا بېرىدىغان ھۆكۈم-گۇۋاھلىقنى ساندۇقنىڭ ئىچىگە قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","مەن شۇ يەردە سەن بىلەن كۆرۈشىمەن؛ كەفارەت تەختى ئۈستىدە، يەنى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۈستىدىكى ئىككى كېرۇبنىڭ ئوتتۇرىسىدا تۇرۇپ ساڭا ئىسرائىللارغا يەتكۈزۈشكە تاپشۇرىدىغان بارلىق ئەمرلىرىم توغرىسىدا سۆز قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ھەم ئاكاتسىيە ياغىچىدىن ئۇزۇنلۇقى ئىككى گەز، كەڭلىكى بىر گەز، ئېگىزلىكى بىر يېرىم گەز بولغان بىر شىرە ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ئۇنى ساپ ئالتۇن بىلەن قاپلاپ، ئۇنىڭ ئۈستۈنكى قىسمىنىڭ چۆرىسىگە ئالتۇندىن گىرۋەك چىقار. ");
INSERT INTO uigara_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","سەن شىرەنىڭ چۆرىسىگە تۆت ئىلىك ئېگىزلىكتە بىر لەۋ ياسىغىن؛ بۇ لەۋنىڭ چۆرىسىگىمۇ ئالتۇندىن بىر گىرۋەك چىقار. ");
INSERT INTO uigara_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","سەن ئۇ شىرەگە ئالتۇندىن تۆت ھالقا ياساپ، بۇ ھالقىلارنى شىرەنىڭ تۆت بۇرجىكىدىكى چېتىققا ئورناتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","شىرەنى كۆتۈرۈشكە بالداقلار ئۆتكۈزۈلسۇن دەپ، ھالقىلار شىرە لېۋىگە يېقىن بېكىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","بالداقلارنى ئاكاتسىيە ياغىچىدىن ياساپ، ئالتۇن بىلەن قاپلىغىن؛ شىرە ئۇلار ئارقىلىق كۆتۈرىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","شىرەگە يانداپ لېگەن، قاچا-تەخسە، پىيالە ۋە شاراب ھەدىيەلىرىنى چاچىدىغان قەدەھلەرنى ياسىغىن؛ ئۇلارنى ساپ ئالتۇندىن ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","مېنىڭ ھۇزۇرۇمدا تۇرۇشقا سەن شىرەگە ھەمىشە «تەقدىم نان»نى قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","سەن ھەم ساپ ئالتۇندىن بىر چىراغدان ياسىغىن. ئۇ چىراغدان سوقۇپ ياسالسۇن؛ چىراغداننىڭ پۇتى، غولى، قەدەھلىرى، غۇنچە ۋە چېچەكلىرى پۈتۈن بىر ئالتۇندىن سوقۇلسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","چىراغداننىڭ غولىنىڭ ئىككى يېنىدىن ئالتە شاخچە چىقىرىلسۇن ــ چىراغداننىڭ بىر يېنىدىن ئۈچ شاخچە، چىراغداننىڭ يەنە بىر يېنىدىن ئۈچ شاخچە چىقىرىلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","بىر يېنىدىكى ھەربىر شاخچىدە بادام گۈلى شەكلىدە غۇنچىسى ۋە چېچىكى بولغان ئۈچ قەدەھ چىقىرىلسۇن، يەنە بىر يېنىدىكى ھەربىر شاخچىدە بادام گۈلى شەكلىدە غۇنچىسى ۋە چېچىكى بولغان ئۈچ قەدەھ چىقىرىلسۇن. چىراغدانغا چىقىرىلغان ئالتە شاخچىنىڭ ھەممىسى شۇنداق ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","چىراغداننىڭ غولىدىن بادام گۈلى شەكلىدە غۇنچىسى ۋە چېچىكى بولغان تۆت قەدەھ چىقىرىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","بۇلاردىن باشقا بىرىنچى ئىككى شاخچىنىڭ ئاستىدا بىر غۇنچە، ئىككىنچى ئىككى شاخچىنىڭ ئاستىدا بىر غۇنچە، ئۈچىنچى ئىككى شاخچىنىڭ ئاستىدا بىر غۇنچە بولسۇن؛ چىراغدانغا چىقىرىلغان ئالتە شاخچىنىڭ ئاستى ھەممىسى شۇنداق بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ئۇنىڭ شۇ غۇنچىلىرى ھەم شاخچىلىرى چىراغدان بىلەن بىر گەۋدە قىلىنسۇن ــ بىر پۈتۈن ساپ ئالتۇندىن سوقۇپ ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","سەن چىراغداننىڭ يەتتە چىرىغىنى ياسىغىن؛ چىراغلار ئۇدۇلغا يورۇق چۈشۈرەلىشى ئۈچۈن ئۈستى تەرەپكە ئورنىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ئۇنىڭ پىلىك قايچىلىرى بىلەن كۈلدانلىرى ساپ ئالتۇندىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","چىراغدان ۋە ئۇنىڭ بارلىق ئەسۋابلىرى بىر تالانت ساپ ئالتۇندىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ساڭا تاغدا ئايان قىلىنغان نۇسخا بويىچە بۇلارنى ئېھتىيات بىلەن ياسىغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","مۇقەددەس چېدىرنى ئون پارچە يوپۇقتىن ياساتقىن؛ يوپۇقلار نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ ئىشلەنسۇن؛ ئۇنىڭغا كېرۇبلارنىڭ سۈرىتىنى چېۋەر قوللارغا نەپىس قىلىپ كەشتىلەپ چىقارغۇزغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ھەربىر يوپۇقنىڭ ئۇزۇنلۇقى يىگىرمە سەككىز گەز، كەڭلىكى تۆت گەز بولۇپ، ھەربىر يوپۇق ئوخشاش چوڭ-كىچىكلىكتە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","يوپۇقلارنىڭ بەشى بىر-بىرىگە ئۇلانسۇن، قالغان بەش يوپۇقمۇ ھەم بىر-بىرىگە ئۇلانسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","سەن ئۇلاپ چىقىلغان بىرىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا بىر تەرىپىگە رەڭگى كۆك ئىزمە قادىغىن، شۇنىڭدەك ئۇلاپ چىقىلغان ئىككىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكىسىنىڭ بىر تەرىپىگىمۇ ھەم شۇنداق قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","بىرىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا ئەللىك ئىزمە قادىغىن، ئىككىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكىسىگىمۇ ئەللىك ئىزمە قادىغىن. ئىزمىلەر بىر-بىرىگە ئۇدۇلمۇئۇدۇل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","مۇقەددەس چېدىر بىر پۈتۈن بولسۇن ئۈچۈن ئالتۇندىن ئەللىك ئىلغۇ ياساپ، ئىككى چوڭ پارچە يوپۇقنى شۇ ئىلغۇلار بىلەن بىر-بىرىگە تۇتاشتۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","مۇقەددەس چېدىرنى يېپىش ئۈچۈن ئۆچكە تىۋىتىدىن يوپۇقلارنى ياسىغىن؛ يوپۇقتىن ئون بىر پارچە ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","يوپۇقلارنىڭ ھەربىرىنىڭ ئۇزۇنلۇقى ئوتتۇز گەز، كەڭلىكى تۆت گەز بولۇپ، ئون بىر يوپۇقنىڭ ھەممىسى ئوخشاش چوڭ-كىچىكلىكتە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","يوپۇقلارنىڭ بەشىنى ئۇلاپ بىر قىلىپ، قالغان ئالتە يوپۇقنىمۇ ئۇلاپ بىر قىلىپ، ئالتىنچى يوپۇقنى ئىككى قات قىلىپ، چېدىرنىڭ ئالدى تەرىپىگە ساڭگىلىتىپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","سەن بىرىنچى ئۇلاپ چىقىلغان چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا ئەللىك ئىزمە، ئىككىنچى ئۇلاپ چىقىلغان چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا ئەللىك ئىزمە قادىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","سەن ھەم مىستىن ئەللىك ئىلغۇ ياساپ، چېدىر بىر پۈتۈن بولسۇن ئۈچۈن ئۇلارنى ئىزمىلەرگە ئۆتكۈزۈپ ئىككى چوڭ پارچىنى ئۇلاپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","لېكىن يوپۇقنىڭ چېدىرنىڭ كەينىدىن ئېشىپ قالغان قىسمى، يەنى ئېشىپ قالغان يېرىم پارچىسى چېدىرنىڭ كەينى تەرىپىدە ساڭگىلاپ تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","چېدىر يوپۇقلىرىنىڭ چېدىرنىڭ بويىدىن ئارتۇق قىسمى، يەنى ئۇ تەرىپىدىن بىر گەز، بۇ تەرىپىدىن بىر گەز، چېدىرنىڭ ئىككى تەرىپىدىن ساڭگىلاپ، ئۇنى تولۇق ياپسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","بۇنىڭدىن باشقا، چېدىرغا قىزىل بويالغان قوچقار تېرىسىدىن يوپۇق ياساپ ياپقىن، ئاندىن ئۇنىڭ ئۈستىدىنمۇ دېلفىن تېرىسىدىن ياسالغان يەنە بىر يوپۇقنى قاپلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","مۇقەددەس چېدىرنىڭ تىك تاختايلىرىنى ئاكاتسىيە ياغىچىدىن ياساپ تىكلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ھەربىر تاختاينىڭ ئۇزۇنلۇقى ئون گەز، كەڭلىكى بىر يېرىم گەز بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ھەربىر تاختاينىڭ ئىككىدىن تۇرۇمى بولسۇن، ھەر ئىككى تاختاي شۇلار بىلەن بىر-بىرىگە چېتىلسۇن؛ چېدىرنىڭ بارلىق تاختايلىرىنى شۇنداق ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","چېدىرنىڭ تاختايلىرىنى شۇنداق ياسىغىن؛ يىگىرمىسىنى جەنۇب تەرەپكە تىكلىگىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","بۇ يىگىرمە تاختاينىڭ تېگىگە كۈمۈشتىن قىرىق تەگلىك ياسىغىن؛ بىر تاختاينىڭ ئاستىدىكى ئىككى تۇرۇمى ئۈچۈن ئىككىدىن تەگلىك، يەنە بىر تاختاينىڭ ئىككى تۇرۇمى ئۈچۈن ئىككىدىن تەگلىك ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","شۇنىڭدەك چېدىرنىڭ ئۇدۇل تەرىپىدە، يەنى شىمال تەرىپىدە يىگىرمە تاختاي بولسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","بۇلارنىڭ قىرىق تەگلىكى كۈمۈشتىن بولسۇن؛ بىر تاختاينىڭ تېگىگە ئىككىدىن تەگلىك، يەنە بىر تاختاينىڭ تېگىگە ئىككىدىن تەگلىك ئورۇنلاشتۇرۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","چېدىرنىڭ كەينى تەرىپىگە، يەنى غەرب تەرەپكە ئالتە تاختاي ياساپ تىكلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","چېدىرنىڭ كەينى تەرىپىدىكى ئىككى بۇلۇڭغا ئىككى تاختاي ياساپ ئورناتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","بۇ بۇلۇڭ تاختايلىرى ئاستىدىن ئۈستىگىچە ئىككى قات قىلىنىپ تاختايلارنى ئۆزئارا چېتىشتۇرسۇن، ئۈستى بىر ھالقىغا بېكىتىلسۇن. ھەر ئىككىسى شۇنداق قىلىنىپ، ئىككى بۇلۇڭغا تىكلەنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ئارقا تەرەپتە سەككىز تاختاي بولىدۇ، ئۇلارنىڭ كۈمۈشتىن ياسالغان ئون ئالتە تەگلىكى بولىدۇ؛ بىر تاختاينىڭ تېگىدە ئىككى تەگلىك، يەنە بىر تاختاينىڭ تېگىدە ئىككى تەگلىك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","بۇنىڭدىن باشقا سەن ئاكاتسىيە ياغىچىدىن بالداق ياسىغىن؛ چېدىرنىڭ بۇ تەرىپىدىكى تاختايلارغا بەش بالداقنى، ");
INSERT INTO uigara_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","چېدىرنىڭ ئۇ تەرىپىدىكى تاختايلارغا بەش بالداقنى، چېدىرنىڭ ئارقا تەرىپىدىكى تاختايلارغا، يەنى غەرب تەرىپىدىكى تاختايلارغا بەش بالداقنى ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","تاختايلارنىڭ ئوتتۇرىسىدىكى ئوتتۇرا بالداق بۇ تەرەپتىن ئۇ تەرەپكە يېتىدىغان بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","تاختايلارنى ئالتۇن بىلەن قاپلاپ، بالداقلار ئۆتكۈزۈلىدىغان ھالقىلارنى ئالتۇندىن ياساپ، بالداقلارنى ئالتۇن بىلەن قاپلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","چېدىرنى ساڭا تاغدا ئايان قىلىنغان نۇسخا بويىچە ياساپ تىكلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","سەن نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ ئىشلەنگەن بىر پەردە ياسىغىن؛ ئۇنى چېۋەر قوللار كېرۇبلارنىڭ سۈرىتىنى نەپىس قىلىپ چۈشۈرۈپ كەشتىلەپ چىقسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ئۇنى ئاكاتسىيە ياغىچىدىن ياسالغان تۆت خادىغا ئېسىپ قويغىن. بۇ خادىلار ئالتۇن بىلەن قاپلانسۇن، ھەربىرىنىڭ ئالتۇن ئىلمىكى بولسۇن؛ خادىلار كۈمۈشتىن ياسالغان تۆت تەگلىككە ئورنىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","پەردە چېدىر يوپۇقىدىكى ئىلمەكلەرگە ئېسىلىپ ساڭگىلىتىپ قويۇلسۇن؛ ئاندىن ھۆكۈم-گۇۋاھلىق ساندۇقىنى شۇ يەرگە كەلتۈرۈپ، پەردىنىڭ ئىچىگە ئېلىپ كىرگىن. شۇنىڭ بىلەن پەردە سىلەر ئۈچۈن مۇقەددەس جاي بىلەن ئەڭ مۇقەددەس جاينىڭ ئوتتۇرىسىدىكى بىر ئايرىما پەردە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ئاندىن سەن «كەفارەت تەختى»نى ئەڭ مۇقەددەس جايدىكى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۈستىگە قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","شىرە بولسا پەردىنىڭ تېشىغا ئورۇنلاشتۇرۇلسۇن؛ چىراغداننى شىرەنىڭ ئۇدۇلىغا، چېدىرنىڭ جەنۇب تەرىپىگە قويغىن؛ شىرەنى شىمال تەرىپىگە قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","بۇنىڭدىن باشقا سەن چېدىرنىڭ كىرىش ئېغىزىغا نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ ئىشلەنگەن بىر پەردە ياسىغىن؛ ئۇ كەشتىچى تەرىپىدىن كەشتىلەنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","بۇ پەردە ئۈچۈن ئاكاتسىيە ياغىچىدىن بەش خادا ياساپ، ئۇلارنى ئالتۇن بىلەن قاپلىغىن؛ ھەربىرىنىڭ ئالتۇن ئىلمىكى بولسۇن؛ ئۇلارنىڭ تېگىگە بەش دانە تەگلىكنى مىستىن قۇيۇپ تەييارلاتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","سەن قۇربانگاھنى ئاكاتسىيە ياغىچىدىن ياسىغىن. قۇربانگاھ تۆت چاسا بولسۇن؛ ئۇزۇنلۇقى بەش گەز، كەڭلىكى بەش گەز، ئېگىزلىكى ئۈچ گەز قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ئۇنىڭ تۆت بۇرجىكىگە قويۇلىدىغان مۈڭگۈزلىرىنى ياسىغىن؛ مۈڭگۈزلىرى قۇربانگاھ بىلەن بىر گەۋدە قىلىنسۇن. قۇربانگاھنى مىس بىلەن قاپلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","قۇربانگاھنىڭ ياغ ۋە كۈلىنى ئېلىشقا داسلارنى ياسىغىن؛ ئۇنىڭغا خاس بولغان گۈرجەكلەرنى، كورىلارنى، لاخشىگىرلارنى ۋە ئوتدانلارنىمۇ ياسىغىن؛ ئۇنىڭ بارلىق ئەسۋابلىرىنى ياساشقا مىس ئىشلەتكىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","قۇربانگاھ ئۈچۈن مىستىن بىر شالا ياسىغىن؛ شالانىڭ تۆت بۇرجىكىگە تۆت مىس ھالقا ياساپ بېكىتىپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","شالانى قۇربانگاھنىڭ قاپ بېلىنىڭ ئاستىدىكى گىرۋەكتىن تۆۋەنرەك تۇرىدىغان قىلغىن، شۇنداقتا شالا قۇربانگاھنىڭ دەل ئوتتۇرىسىدا بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","قۇربانگاھقا ئىككى بالداق ياسىغىن؛ ئۇلار ئاكاتسىيە ياغىچىدىن بولسۇن، ئۇلارنى مىس بىلەن قاپلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","قۇربانگاھنى كۆتۈرگەندە، بالداقلار ئۇنىڭ ئىككى يېنىدا بولۇشى ئۈچۈن، ئۇلارنى ھالقىلارغا ئۆتكۈزۈپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","قۇربانگاھنى تاختايلاردىن ياسىغىن، ئىچى بوش بولسۇن؛ ئۇ تاغدا ساڭا ئايان قىلىنغان نۇسخا بويىچە ھۈنەرۋەنلەر تەييار قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","مۇقەددەس چېدىرنىڭ ھويلىسىنىمۇ ياسىغىن. ھويلىنىڭ جەنۇبىغا، يەنى جەنۇبقا يۈزلەنگەن تەرىپىگە نېپىز توقۇلغان ئاق كاناپ رەختتىن پەردىلەرنى توقۇغىن؛ شۇ تەرىپىنىڭ ئۇزۇنلۇقى يۈز گەز بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","پەردىلەرنى ئېسىشقا يىگىرمە خادا ياسالسۇن؛ ئۇلارنىڭ تېگىگە قويۇشقا يىگىرمە مىس تەگلىك ياسالسۇن؛ خادىلارنىڭ ئىلمىكى بىلەن بالداقلار بولسا كۈمۈشتىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","شۇنىڭغا ئوخشاش شىمال تەرىپىدىمۇ ئۇزۇنلۇقى يۈز گەز كېلىدىغان پەردە بولسۇن. پەردىلەرنى ئېسىشقا يىگىرمە خادا ياسالسۇن؛ ئۇلارنىڭ تېگىگە قويۇشقا يىگىرمە مىس تەگلىك ياسالسۇن؛ خادىلارنىڭ ئىلمىكى بىلەن بالداقلار بولسا كۈمۈشتىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ھويلىنىڭ غەرب تەرىپىدە ئۇزۇنلۇقى ئەللىك گەز كېلىدىغان پەردە بولسۇن؛ ئۇنىڭ ئون خادىسى ۋە ئون تەگلىكى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ھويلىنىڭ شەرق تەرىپى، يەنى كۈن چىقىشقا يۈزلەنگەن تەرىپىنىڭ كەڭلىكى ئەللىك گەز بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","بىر تەرىپىدە ئون بەش گەز كېلىدىغان پەردە بولسۇن؛ ئۇنىڭ ئۈچ خادىسى بىلەن ئۈچ تەگلىكى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","يەنە بىر تەرىپىدە ئون بەش گەز كېلىدىغان پەردە بولسۇن؛ ئۇنىڭ ئۈچ خادىسى بىلەن ئۈچ تەگلىكى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ھويلىنىڭ كىرىش ئېغىزىغا يىگىرمە گەز كېلىدىغان بىر پەردە قويۇلسۇن؛ پەردە نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ، كەشتىچى تەرىپىدىن كەشتىلەنسۇن. ئۇنىڭ تۆت خادىسى بىلەن تۆت تەگلىكى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ھويلىنىڭ چۆرىسىدىكى ھەممە خادىلار كۈمۈشتىن ياسالغان بالداقلار بىلەن بىر-بىرىگە چېتىلسۇن؛ ئۇلارنىڭ ئىلمەكلىرى كۈمۈشتىن، تەگلىكلىرى مىستىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ھويلىنىڭ ئۇزۇنلۇقى يۈز گەز، كەڭلىكى ھەر ئىككى تەرىپى ئەللىك گەز بولسۇن؛ نېپىز توقۇلغان ئاق كاناپ رەختتىن ئىشلەنگەن پەردىنىڭ ئېگىزلىكى بەش گەز قىلىنسۇن؛ خادىلارنىڭ تەگلىكلىرى مىستىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","مۇقەددەس چېدىرنىڭ ئىش-خىزمىتىدە ئىشلىتىلىدىغان بارلىق ئەسۋاب-سايمانلىرى ھەمدە بارلىق مىق-قوزۇقلىرى، شۇنداقلا ھويلىنىڭ بارلىق مىق-قوزۇقلىرى مىستىن بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ــ چىراغنىڭ ھەمىشە يېنىق تۇرۇشى ئۈچۈن، چىراغقا ئىشلىتىشكە زەيتۇندىن سوقۇپ چىقىرىلغان ساپ ماينى قېشىڭغا كەلتۈرۈشكە ئىسرائىللارنى بۇيرۇغىن. ");
INSERT INTO uigara_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","جامائەت چېدىرىنىڭ ئىچىدە، ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۇدۇلىدىكى پەردىنىڭ تاشقىرىدا ھارۇن ۋە ئوغۇللىرى ھەر كېچىسى ئەتىگەنگىچە پەرۋەردىگارنىڭ ئالدىدا چىراغلارنىڭ يېنىق تۇرغۇزۇش ئىشىدا بولسۇن. بۇ ئىش دەۋردىن-دەۋرگىچە ئىسرائىللارغا ئەبەدىي بىر قانۇن-بەلگىلىمە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","سەن ئىسرائىللارنىڭ ئىچىدىن ئاكاڭ ھارۇن ۋە ئۇنىڭ ئوغۇللىرىنى ئۆز قېشىڭغا كەلتۈرگىن؛ ئۇلارنى، يەنى ھارۇن ۋە ئوغۇللىرى ناداب، ئابىھۇ، ئەلىئازار ۋە ئىتامارلارنىڭ مېنىڭ كاھىنلىق خىزمىتىمدە بولۇشى ئۈچۈن يېنىڭغا كەلتۈرگىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ئاكاڭ ھارۇنغا ھەم شەرەپ ھەم گۈزەللىك ئۈچۈن مۇقەددەس كىيىملەرنى تەييارلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ھارۇننىڭ ماڭا مۇقەددەس قىلىنىپ، مېنىڭ كاھىنلىق خىزمىتىمدە بولۇشى ئۈچۈن، مەن ئەقىل-پاراسەتنىڭ روھى بىلەن قەلبلىرىنى تولدۇرغان چېۋەر كىشىلەرنىڭ ھەربىرىگە سۆز قىلىپ، ئۇلارنى ئالاھىدە كىيىملەرنى تىكىشكە بۇيرۇغىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ئۇلار تىكىدىغان كىيىملەر مۇنۇلاردىن ئىبارەت: ــ بىر قوشېن، بىر ئەفود، بىر تون، كەشتىلەنگەن بىر خالتا كۆڭلەك، بىر سەللە ۋە بىر بەلۋاغ. مېنىڭ كاھىنلىق خىزمىتىمدە بولۇشى ئۈچۈن، ئۇلار ئاكاڭ ھارۇنغا ۋە ئوغۇللىرىغا مۇقەددەس كىيىملەرنى تىكسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ئۇنىڭغا ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار بىلەن نېپىز توقۇلغان ئاق كاناپ رەخت ئىشلىتىلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ئەفودنى ئۇلار ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار بىلەن نېپىز توقۇلغان ئاق كاناپ رەختلەرنى تەييارلاپ، چېۋەر قوللارغا نەپىس قىلىپ كەشتىلىتىپ ئىشلەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ئەفودنىڭ ئىككى بېشىنى بىر-بىرگە تۇتاشتۇرۇش ئۈچۈن ئىككى دولىسىدا مۈرىلىك تاسما بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ئەفودنىڭ ئۈستىدىن باغلايدىغان، كەشتىلەنگەن بەلۋاغ ئەفود بىلەن بىر پۈتۈن قىلىنسۇن ۋە ئۇنىڭغا ئوخشاش سىپتا ئىشلىنىپ، ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار ۋە نېپىز توقۇلغان ئاق كاناپ رەختتىن ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ئىككى ئاق ھېقىقنى تېپىپ، ئۇلارنىڭ ئۈستىگە ئىسرائىلنىڭ ئوغۇللىرىنىڭ ناملىرىنى ئويدۇرغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ئۇلارنىڭ ناملىرىنىڭ ئالتىسى بىر ياقۇتقا ئويۇلسۇن، قالغان ئالتىسى بولسا يەنە بىر ياقۇتقا ئويۇلسۇن، ھەممىسى تۇغۇلۇش تەرتىپى بويىچە پۈتۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","خۇددى ياقۇت نەقىشچىلىرى ئىشلىگەندەك، مۆھۈر ئويۇلغاندەك ئىسرائىلنىڭ ئوغۇللىرىنىڭ ناملىرىنى ئىككى ياقۇتقا ئويدۇرغىن؛ ئۇلار ئالتۇندىن ياسالغان كۆزلۈككە بېكىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ئىسرائىلنىڭ ئوغۇللىرىغا ئەسلەتمە تاش بولسۇن ئۈچۈن، ئىككى ياقۇتنى ئەفودنىڭ ئىككى مۈرىلىك تاسمىسىغا قادىغۇزغىن؛ شۇنداق بولغاندا، ھارۇن پەرۋەردىگارنىڭ ئالدىدا ئۇلارنىڭ ناملىرىنى ئەسلەتمە سۈپىتىدە مۈرىلىرىدە كۆتۈرۈپ يۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX28_13‏","003_28_13‏","EXO","28","13‏","14","بۇنىڭدىن باشقا، سەن ئالتۇندىن يەنە ئىككى كۆزلۈك ۋە ساپ ئالتۇندىن شوينىدەك ئېشىپ ئېتىلگەن ئىككى زەنجىر ياساتقىن؛ ئاندىن ئېشىلمە زەنجىرلەر كۆزلۈكلەرگە بېكىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«ھۆكۈم قوشېنى»نى چېۋەر قوللارغا نەپىس قىلىپ كەشتىلىتىپ ياساتقىن؛ ئۇنى ھەم ئەفودنى ئىشلىگەن ئۇسۇلدا ياسىغان، ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار بىلەن نېپىز توقۇلغان ئاق كاناپ رەختتىن ياسىغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ئۇ ئىككى قات، تۆت چاسا قىلىنسۇن؛ ئۇزۇنلۇقى بىر غېرىچ، كەڭلىكىمۇ بىر غېرىچ بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ئۇنىڭ ئۈستىگە تۆت قاتار قىلىپ گۆھەرلەرنى ئورناتقىن: ــ بىرىنچى قاتارغا قىزىل ياقۇت، سېرىق گۆھەر ۋە زۇمرەت ئورنىتىلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ئىككىنچى قاتارغا كۆك قاشتېشى، كۆك ياقۇت ۋە ئالماس ئورنىتىلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ئۈچىنچى قاتارغا سۆسۈن ياقۇت، پىروزا ۋە سۆسۈن كۋارتس ئورنىتىلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","تۆتىنچى قاتارغا بېرىل ياقۇت، ئاق ھېقىق ۋە ئانارتاش ئورنىتىلسۇن؛ بۇلارنىڭ ھەممىسى ئالتۇن كۆزلۈك ئىچىگە ئورنىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","بۇ گۆھەرلەر ئىسرائىلنىڭ ئوغۇللىرىنىڭ ناملىرىغا ۋەكىل قىلىنىپ، ئۇلارنىڭ سانىدەك ئون ئىككى بولۇپ، مۆھۈر ئويغاندەك ھەربىر گۆھەرگە ئون ئىككى قەبىلىنىڭ نامى بىردىن-بىردىن پۈتۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","قوشېنغا شوينىدەك ئېشىلگەن ساپ ئالتۇندىن ئىككى ئېشىلمە زەنجىر ياسىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","قوشېنغا ئالتۇندىن ئىككى ھالقا ئېتىپ، ئىككى ھالقىنى قوشېننىڭ يۇقىرىقى ئىككى بۇرجىكىگە بېكىتكىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ئاندىن ئالتۇندىن ئېشىلىپ ياسالغان ئىككى زەنجىرنى قوشېننىڭ يۇقىرىقى ئىككى بۇرجىكىدىكى ھالقىدىن ئۆتكۈزۈپ، ");
INSERT INTO uigara_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ئېشىلگەن شۇ زەنجىرلەرنىڭ ئىككى ئۇچىنى ئىككى كۆزلۈككە بېكىتىپ، كۆزلۈكلەرنى ئەفودنىڭ ئىككى مۈرىلىك تاسمىسىنىڭ ئالدى قىسمىغا ئورناتقىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","بۇنىڭدىن باشقا سەن ئالتۇندىن ئىككى ھالقا ياساپ، ئۇلارنى قوشېننىڭ ئاستى تەرىپىدىكى ئىككى بۇرجىكىگە بېكىتكىن؛ ئۇلار ئەفودقا تېگىشىپ تۇرىدىغان قىلىنىپ ئىچىگە قادالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","مۇندىن باشقا سەن ئالتۇندىن يەنە ئىككى ھالقا ياساپ، ئۇلارنى ئەفودنىڭ ئىككى مۈرىلىك تاسمىسىنىڭ ئالدى تۆۋەنكى قىسمىغا، يەنى ئەفودقا ئۇلىنىدىغان جايغا يېقىن قىلىپ، كەشىتىلەنگەن بەلۋاغدىن ئېگىزرەك قىلىپ بېكىتكىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","قوشېننىڭ ئەفودنىڭ كەشىتىلەنگەن بەلۋېغىدىن يۇقىرىراق تۇرۇشى، قوشېننىڭ ئەفودتىن ئاجراپ كەتمەسلىكى ئۈچۈن قوشېننىڭ ھالقىسىنى كۆك شوينا بىلەن ئەفودنىڭ ھالقىسىغا چېتىپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","شۇنداق قىلغاندا، ھارۇن مۇقەددەس جايغا كىرگەندە، ھۆكۈم قوشېنىنى تاقىغاچقا، ئىسرائىلنىڭ ئوغۇللىرىنىڭ ناملىرىنى ئەسلەتمە سۈپىتىدە يۈرىكىنىڭ ئۈستىدە پەرۋەردىگارنىڭ ئالدىدا دائىم كۆتۈرۈپ يۈرگەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ھارۇن پەرۋەردىگارنىڭ ئالدىغا كىرگەندە، ئۇرىم بىلەن تۇممىم ئۇنىڭ يۈرىكى ئۈستىدە بولۇشى ئۈچۈن، بۇلارنى ھۆكۈم قوشېنىنىڭ ئىچىگە ئالغىن؛ مۇشۇنداق قىلغاندا، ھارۇن ئىسرائىللارغا باغلىق ھۆكۈملەرنى ھەمىشە پەرۋەردىگارنىڭ ھۇزۇرىدا ئۆز يۈرىكى ئۈستىدە كۆتۈرۈپ يۈرگەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ئەفودنىڭ ئىچىدىكى توننى پۈتۈنلەي كۆك رەڭلىك قىلغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","توننىڭ باشقا كىيىلىدىغان تۆشۈكى دەل ئوتتۇرىسىدا بولسۇن؛ ئۇنىڭ يىرتىلىپ كەتمەسلىكى ئۈچۈن خۇددى باپكار توقۇغاندەك، ساۋۇتنىڭ ياقىسىغا ئوخشاش چۆرىسىگە پەۋاز چىقىرىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_33‏","003_28_33‏","EXO","28","33‏","34","ئۇنىڭ ئېتىكىنىڭ چۆرىسىگە كۆك، سۆسۈن ۋە قىزىل يىپتىن ئانارلارنى توقۇپ ئاسقىن ھەمدە ئالتۇن قوڭغۇراقلارنى ياساپ، چۆرىسىدىكى ئانارلارنىڭ ئارىلىقىغا بىردىن ئېسىپ قويغىن؛ توننىڭ ئېتىكىنىڭ پۈتكۈل چۆرىسىگە بىر ئالتۇن قوڭغۇراق، بىر ئانار، يەنە بىر ئالتۇن قوڭغۇراق، بىر ئانار... بېكىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ھارۇن خىزمەت قىلغان ۋاقتىدا شۇ توننى كىيسۇن؛ بۇنىڭ بىلەن ھارۇن پەرۋەردىگارنىڭ ئالدىغا بارغاندا، يەنى مۇقەددەس جايغا، پەرۋەردىگارنىڭ ئالدىغا كىرىپ-چىققاندا ئۇنىڭ ئاۋازى ئاڭلىنىپ تۇرىدۇ-دە، ئۇ ئۆلۈمدىن ئامان قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ئاندىن كېيىن سەن ساپ ئالتۇندىن نەپىس بىر ئوتۇغاتنى ياساپ، ئۇنىڭ ئۈستىگە مۆھۈرگە نەقىشلەنگەندەك: «پەرۋەردىگارغا مۇقەددەس قىلىندى» دەپ ئويغىن؛    ");
INSERT INTO uigara_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ئۇنى كۆك رەڭلىك يىپ بىلەن سەللىسىگە چىگكىن؛ ئۇ سەللىنىڭ ئالدى تەرىپىگە تاقالسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ئۇ ھارۇننىڭ پېشانىسىدە تۇرسۇن. بۇنىڭ بىلەن ھارۇن ئىسرائىللارنىڭ مۇقەددەس قىلىپ كەلتۈرگەن بارلىق مۇقەددەس ھەدىيەلىرىگە چاپلاشقان گۇناھلارنى ئۆز ئۈستىگە ئېلىپ كۆتۈرىدۇ؛ ھەدىيەلەرنىڭ پەرۋەردىگارنىڭ ئالدىدا قوبۇل قىلىنىشى ئۈچۈن ئوتۇغات ھەمىشە ئۇنىڭ پېشانىسىگە تاقاقلىق تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","بۇنىڭدىن باشقا ئاق كاناپ رەختتىن بىر كۆڭلەك توقۇغىن، شۇنىڭدەك كاناپ رەختتىن توقۇلغان بىر سەللە تەييارلىغىن؛ كەشتىلەنگەن بىر بەلۋاغ ياسىغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ھارۇننىڭ ئوغۇللىرىغا خالتا كۆڭلەكلەرنى تىككىن؛ ئۇلارغىمۇ بەلۋاغلارنى تەييارلا، ئۇلارغا ئېگىز بۆكلەرنىمۇ تىككىن؛ بۇلار ئۇلارغا ھەم شەرەپ ھەم گۈزەللىك بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","بۇلارنىڭ ھەممىسىنى سەن ئاكاڭ ھارۇن ۋە ئۇنىڭ ئوغۇللىرىغا كىيدۈرگىن؛ ئاندىن ئۇلارنىڭ مېنىڭ ئالدىمدا كاھىنلىق خىزمىتىمدە بولۇشى ئۈچۈن ئۇلارنى مەسىھلەپ، ماڭا مۇقەددەس قىلىپ ئايرىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ئۇلارنىڭ ئەۋرەتلىرىنىڭ يېپىق تۇرۇشى ئۈچۈن ئۇلارغا كاناپ رەختتىن تامبال ئەتتۈرگىن؛ ئۇ بېلىدىن يوتىسىغىچە يېپىپ تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ھارۇن ۋە ئوغۇللىرى جامائەت چېدىرىغا كىرگەندە ياكى مۇقەددەس جايدا خىزمەتتە بولۇش ئۈچۈن قۇربانگاھقا يېقىنلاشقاندا، ئۇلار گۇناھكار بولۇپ ئۆلۈپ كەتمەسلىكى ئۈچۈن تامبالنى كىيىۋالسۇن. بۇ ئۇنىڭغا ۋە ئۇنىڭدىن كېيىنكى نەسىللىرى ئۈچۈن ئەبەدىي بىر بەلگىلىمە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ئۇلارنىڭ ماڭا مۇقەددەس قىلىنىپ، كاھىنلىق خىزمىتىمدە بولۇشى ئۈچۈن مۇنداق ئىشنى ئادا قىلىشىڭ كېرەك: ــ سەن بىر ياش ئەركەك تورپاق بىلەن ئىككى قوچقارنى تاللا (ھەممىسى بېجىرىم بولسۇن) ");
INSERT INTO uigara_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ھەمدە پېتىر نان، زەيتۇن مېيى ئىلەشتۈرۈلگەن پېتىر توقاچ ۋە زەيتۇن مېيى سۈرۈلۈپ مەسىھلەنگەن پېتىر ھەمەك نانلارنى تەييارلا، بۇلارنىڭ ھەممىسىنى بۇغداي ئۇنىدىن قىلغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","نانلارنىڭ ھەممىسىنى بىر سېۋەتكە سېلىپ، سېۋەتنى، تورپاقنى ۋە ئىككى قوچقارنى بىللە ھەدىيە قىلىپ كەلتۈرگىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","سەن ھارۇن ۋە ئۇنىڭ ئوغۇللىرىنى جامائەت چېدىرىنىڭ كىرىش ئېغىزىغا يېقىن ئېلىپ كېلىپ، ئۇلارنى سۇ بىلەن يۇغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ئاندىن كىيىملىرىنى ئېلىپ كېلىپ، ھارۇنغا خالتا كۆڭلەك، ئەفود تونى ۋە ئەفودنى كىيدۈرگىن، قوشېننى تاقىغىن؛ ئاندىن بېلىگە ئەفودنىڭ كەشتىلەنگەن بەلۋېغىنى باغلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","بېشىغا سەللىنى يۆگەپ، سەللىگە مۇقەددەس ئوتۇغاتنى تاقاپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ئاندىن مەسىھلەش مېيىنى ئېلىپ، بېشىغا قۇيۇپ ئۇنى مەسىھلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ئاندىن سەن ئۇنىڭ ئوغۇللىرىنى ئېلىپ كېلىپ، ئۇلارغا خالتا كۆڭلەكلەرنى كىيدۈرگىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ئۇلارغا، يەنى ھارۇن ۋە ئۇنىڭ ئوغۇللىرىغا بەلۋاغلارنى باغلاپ، ئېگىز بۆكلەرنى كىيدۈرگىن. شۇنىڭ بىلەن ئەبەدىي بەلگىلىمە بويىچە، كاھىنلىق خىزمىتى ئۇلارنىڭكى بولىدۇ؛ شۇنداق قىلىپ، سەن ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىنى خۇداغا مۇقەددەس قىلىپ ئايرىپ تەيىنلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","— سەن تورپاقنى جامائەت چېدىرىنىڭ ئالدىغا ئېلىپ كەلگىن؛ ئېلىپ كەلگىنىڭدە ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى قوللىرىنى تورپاقنىڭ بېشىغا قويسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ئاندىن سەن بۇ تورپاقنى پەرۋەردىگارنىڭ ئالدىدا، جامائەت چېدىرىنىڭ كىرىش ئېغىزىنىڭ يېنىدا بوغۇزلىغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","تورپاقنىڭ قېنىدىن ئېلىپ بارمىقىڭ بىلەن ئۇنى قۇربانگاھنىڭ مۈڭگۈزلىرىگە سۈرۈپ، قالغان قاننىڭ ھەممىسىنى قۇربانگاھنىڭ تۈۋىگە تۆكۈپ قۇيغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ئىچ قارنىنى يۆگەپ تۇرغان بارلىق ماينى، شۇنداقلا جىگەرنىڭ ئۈستىدىكى چاۋا ماي، ئىككى بۆرەك ۋە ئۇلارنىڭ ئۈستىدىكى ماينى ئاجرىتىپ بۇلارنى قۇربانگاھتا كۆيدۈرگىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","تورپاقنىڭ گۆشى، تېرىسى ۋە تېزىكىنى بولسا چېدىرگاھنىڭ سىرتىغا ئېلىپ چىقىپ، ئوتتا كۆيدۈرۈۋەتكىن؛ بۇ گۇناھ قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ئاندىن سەن قوچقارلارنىڭ بىرىنى ئېلىپ كەلگىن؛ ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى قوللىرىنى قوچقارنىڭ بېشىغا قويسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ئاندىن سەن بۇ قوچقارنى بوغۇزلاپ، ئۇنىڭ قېنىدىن قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپكىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","قوچقارنى پارچىلاپ، ئۇنىڭ ئىچ قارنى بىلەن پاچاقلىرىنى يۇيۇپ، ئۇلارنى گۆش پارچىلىرى ۋە باشنىڭ ئۈستىگە قويۇپ، ");
INSERT INTO uigara_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","پۈتۈن قوچقارنى قۇربانگاھتا كۆيدۈرگىن. بۇ پەرۋەردىگارغا ئاتالغان كۆيدۈرمە قۇربانلىق ــ ئوت ئارقىلىق سۇنۇلىدىغان، پەرۋەردىگارغا خۇشبۇي يەتكۈزىدىغان ھەدىيە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","كېيىن سەن ئىككىنچى قوچقارنى ئېلىپ كەلگىن؛ ھارۇن ۋە ئۇنىڭ ئوغۇللىرى قوللىرىنى قوچقارنىڭ بېشىغا قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ئاندىن بۇ قوچقارنى بوغۇزلاپ قېنىدىن ئېلىپ، ھارۇننىڭ ئوڭ قۇلىقىنىڭ يۇمشىقىغا، ئۇنىڭ ئوغۇللىرىنىڭ ئوڭ قۇلىقىنىڭ يۇمشىقىغا، ئۇلارنىڭ ئوڭ قوللىرىنىڭ چوڭ بارمىقى بىلەن ئوڭ پۇتلىرىنىڭ چوڭ بارمىقىغا سۈركەپ قويغىن، قالغان قاننى قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپكىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ئاندىن قۇربانگاھ ئۈستىدىكى قاندىن ۋە مەسىھلەش مېيىدىن ئېلىپ، ھارۇننىڭ ئۈستىگە، ئۇنىڭ كىيىملىرىگە، شۇنىڭدەك ئۇنىڭ ئوغۇللىرىنىڭ ئۈستىگە ۋە ئۇلارنىڭ كىيىملىرىگىمۇ سەپكىن. شۇنداق قىلىپ ئۇ ۋە ئۇنىڭ كىيىملىرى، ئۇنىڭ ئوغۇللىرى ۋە ئۇلارنىڭ كىيىملىرىمۇ ئۇنىڭ بىلەن تەڭ خۇداغا ئاتاپ مۇقەددەس قىلىنغان بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ئاندىن سەن قوچقارنىڭ مېيى، قۇيرۇق مېيى، ئىچ قارنىنى يۆگەپ تۇرغان بارلىق ماي، جىگەرنىڭ ئۈستىدىكى چاۋا ماي، ئىككى بۆرەك ۋە ئۇلارنىڭ ئۈستىدىكى ماينى چىقار ھەمدە ئوڭ ئارقا پۇتىنى ئالغىن ــ (چۈنكى بۇ قوچقار كاھىنلىققا تىكلەش قۇربانلىقىغا ئاتالغان قوچقاردۇر) ــ ");
INSERT INTO uigara_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","— بۇنىڭدىن باشقا سەن پەرۋەردىگارنىڭ ئالدىدا قويۇلغان پېتىر نان سېۋىتىدىن بىر گىردىنى، زەيتۇن مېيى ئىلەشتۈرۈلگەن پېتىر توقاچتىن بىرنى ۋە پېتىر ھەمەك ناندىن بىرنى ئېلىپ، ");
INSERT INTO uigara_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","بۇلارنىڭ ھەممىسىنى ھارۇننىڭ قوللىرىغا ۋە ئۇنىڭ ئوغۇللىرىنىڭ قوللىرىغا قويۇپ، ئۇلارنى «پۇلاڭلاتما ھەدىيە» سۈپىتىدە پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتقۇزغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ئاندىن سەن بۇلارنى ئۇلارنىڭ قوللىرىدىن تاپشۇرۇپ ئېلىپ، پەرۋەردىگارنىڭ ئالدىدا خۇشبۇي چىقارسۇن دەپ، قۇربانگاھتىكى كۆيدۈرمە قۇربانلىقنىڭ ئۈستىدە قويۇپ كۆيدۈرگىن. بۇ ئوت ئارقىلىق پەرۋەردىگارغا سۇنۇلغان ھەدىيە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","سەن ھارۇننى كاھىنلىققا تىكلەش قۇربانلىقىغا ئاتالغان قوچقارنىڭ تۆشىنى ئېلىپ «پۇلاڭلاتما ھەدىيە» سۈپىتىدە پەرۋەردىگارنىڭ ھۇزۇرىدا پۇلاڭلاتقىن؛ بۇ سېنىڭ ئۈلۈشۈڭ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","شۇنىڭدەك، سەن كاھىنلىققا تىكلەش قۇربانلىقىغا ئاتالغان قوچقارنىڭ «پۇلاڭلاتما ھەدىيە» سۈپىتىدە پۇلاڭلىتىلغان تۆشى بىلەن «كۆتۈرمە ھەدىيە» سۈپىتىدە ئېگىز كۆتۈرۈپ پۇلاڭلىتىلغان ئارقا پۇتىنى، يەنى ھارۇن ۋە ئۇنىڭ ئوغۇللىرىغا بېغىشلانغان شۇ ئۈلۈشلەرنى «مۇقەددەس» دەپ ئايرىپ بېكىتكىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","شۇنىڭ بىلەن بۇ نەرسىلەر ئەبەدىي بەلگىلىمە بويىچە ئىسرائىللار تەرىپىدىن ھارۇن ۋە ئوغۇللىرىغا بېغىشلانغان نېسىۋە بولىدۇ؛ چۈنكى ئۇ كۆتۈرمە ھەدىيەدۇر. بۇلار ئىسرائىللار تەرىپىدىن سۇنۇلىدىغان ئىناقلىق قۇربانلىقلىرىدىن ئايرىپ چىقىلىپ، ئۇلارنىڭ پەرۋەردىگارغا ئاتاپ «ئېگىز كۆتۈرگەن ھەدىيە»سى ھېسابلىنىپ، «كۆتۈرمە ھەدىيە» بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ھارۇننىڭ مۇقەددەس كىيىملىرىگە كېيىن ئوغۇللىرى ۋارىسلىق قىلىدۇ. ئۇلار مەسىھلىنىپ، كاھىنلىققا تەيىنلەنگەندە شۇ كىيىملەرنى كىيسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ئوغۇللىرىنىڭ قايسىسى ئۇنىڭ ئورنىنى بېسىپ كاھىن بولسا، جامائەت چېدىرىغا كىرىپ مۇقەددەس جاينىڭ ئىچىدە خىزمەتكە كىرىشكەندە، بۇ كىيىملەرنى ئۇدا يەتتە كۈن كىيىپ يۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","سەن كاھىنلىققا تىكلەش قۇربانلىقىغا ئاتالغان قوچقارنى ئېلىپ، ئۇنىڭ گۆشىنى مۇقەددەس جايدا پىشۇرغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ئاندىن ھارۇن ۋە ئوغۇللىرى قوچقارنىڭ گۆشى بىلەن سېۋەتتىكى نانلارنى جامائەت چېدىرىنىڭ كىرىش ئېغىزىدا يېسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ئۇلار ئۆزلىرىنىڭ كاھىنلىققا تەيىنلىنىشىدە خۇداغا ئاتاپ مۇقەددەس قىلىنغاندا كەفارەتكە ئىشلىتىلگەن نەرسىلەرنى يېسۇن، لېكىن بۇلار مۇقەددەس بولغاچقا، يات كىشى بۇنىڭدىن ھېچنېمىنى يېمىسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ئەگەر كاھىنلىققا تىكلەش قۇربانلىق گۆشىدىن ياكى ناندىن ئەتىگە ئازراق ئېشىپ قالسا، ئېشىپ قالغاننى ئوتتا كۆيدۈرۈۋەت؛ بۇلار مۇقەددەس بولغاچقا، ھېچكىم ئۇنىڭدىن يېسە بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","سەن شۇ تەرىقىدە ھارۇن ۋە ئۇنىڭ ئوغۇللىرى توغرىسىدا بۇيرۇغىنىمنىڭ ھەممىسىنى بەجا كەلتۈرۈپ، ئۇدا يەتتە كۈنگىچە ئۇلارنى كاھىنلىققا تىكلەش ۋەزىپىسىنى ئادا قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ھەر كۈنى كەفارەت قىلىنىشقا گۇناھ قۇربانلىقى سۈپىتىدە بىر تورپاقنى سۇنغىن. قۇربانگاھنىڭ ئۆزىنى گۇناھتىن پاك قىلىشقا ئۇنىڭ ئۈچۈنمۇ كەفارەت كەلتۈرگىن، مۇقەددەس قىلىنسۇن دەپ، ئۇنى زەيتۇن مېيى بىلەن مەسىھلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","يەتتە كۈنگىچە سەن قۇربانگاھ ئۈچۈن كەفارەت كەلتۈرۈپ، ئۇنى مۇقەددەس قىلغىن. بۇنىڭ بىلەن ئۇ «ئەڭ مۇقەددەس نەرسىلەرنىڭ بىرى» ھېسابلىنىدۇ؛ ئۇنىڭغا تەگكەن ھەممە نەرسە مۇقەددەس ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","مانا، قۇربانگاھتا ھەمىشە سۇنىدىغانلىرىڭ مۇنۇلار: ــ ھەر كۈنى بىر ياشلىق ئىككى قوزا قۇربانلىق قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","بىرىنى ئەتىگەندە، يەنە بىرىنى گۇگۇمدا قۇربانلىق قىلىپ سۇنغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","بىرىنچى قوزا بىلەن بىرگە زەيتۇن مېيىدىن بىر ھىننىڭ تۆتتىن بىرى ئىلەشتۈرۈلگەن بۇغداي ئۇنىدىن ئەفاھنىڭ ئوندىن بىرى ۋە يەنە شاراب ھەدىيەسى سۈپىتىدە تۆتتىن بىر ھىن شاراب قوشۇپ سۇنۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ئىككىنچى قوزىنى گۇگۇمدا سۇنغىن؛ ئۇنى ئەتىگەنلىك قۇربانلىقنىڭكىدەك، خۇشبۇي بولۇشى ئۈچۈن ئوت ئارقىلىق پەرۋەردىگارغا ئاتالغان قۇربانلىق سۈپىتىدە ئاشلىق ھەدىيەسى ۋە شاراب ھەدىيەسى بىلەن قوشۇپ سۇنغىن. ");
INSERT INTO uigara_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","شۇ تەرىقىدە بۇ كۆيدۈرمە قۇربانلىق نەسىلدىن-نەسىلگە جامائەت چېدىرىنىڭ كىرىش ئېغىزىدا پەرۋەردىگارنىڭ ھۇزۇرىدا ئۆتكۈزۈلۈپ دائىملىق قۇربانلىق بولسۇن؛ مەن پەرۋەردىگار شۇ يەردە سىلەر بىلەن كۆرۈشۈپ، سەن بىلەن سۆزلىشىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","شۇنىڭدەك مەن شۇ يەردە ئىسرائىللار بىلەن ئۇچرىشىمەن، شۇنىڭ بىلەن ئۇ جاي مېنىڭ شان-شەرىپىم بىلەن مۇقەددەس قىلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","مەن جامائەت چېدىرى بىلەن قۇربانگاھنى ئۆزۈمگە ئاتاپ مۇقەددەس قىلىمەن؛ ھارۇن ۋە ئۇنىڭ ئوغۇللىرىنىمۇ ئۆزۈمگە كاھىنلىق خىزمەتتە بولۇشقا ئايرىپ مۇقەددەس قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","شۇنداق قىلىپ مەن ئىسرائىللارنىڭ ئارىسىدا ماكان قىلىپ، ئۇلارنىڭ خۇداسى بولىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ئۇ ۋاقىتتا ئۇلار مېنىڭ ئۇلارنىڭ ئارىسىدا ماكان قىلىشىم ئۈچۈن ئۇلارنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن خۇداسى پەرۋەردىگار ئىكەنلىكىمنى بىلىدۇ؛ مەن ئۇلارنىڭ خۇداسى پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","سەن يەنە خۇشبۇي ياندۇرۇش ئۈچۈن بىر خۇشبۇيگاھنى ياساتقىن؛ ئۇنى ئاكاتسىيە ياغىچىدىن تەييارلىغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ئۇ تۆت چاسا، ئۇزۇنلۇقى بىر گەز، كەڭلىكى بىر گەز، ئېگىزلىكى ئىككى گەز بولسۇن. ئۇنىڭ تۆت بۇرجىكىدىكى مۈڭگۈزلەر ئۇنىڭ بىلەن بىر پۈتۈن قىلىپ ياسالسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","سەن ئۇنى، يەنى ئۇنىڭ ئۈستىنى، تۆت ئەتراپىنى ھەم مۈڭگۈزلىرىنى ساپ ئالتۇن بىلەن قاپلاتقىن؛ ئۇنىڭ ئۈستى قىسمىنىڭ چۆرىسىگە ئالتۇندىن گىرۋەك چىقارغىن. ");
INSERT INTO uigara_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ئۇنىڭغا ئالتۇندىن ئىككى ھالقا ياساپ، ئۇنىڭ گىرۋىكىنىڭ ئاستىغا بېكىتكىن؛ ئۇلارنى ئىككى يېنىغا ئۇدۇلمۇئۇدۇل بېكىتكىن. خۇشبۇيگاھنى كۆتۈرىدىغان ئىككى بالداقنى سېلىش ئۈچۈن بۇلارنى خۇشبۇيگاھنىڭ ئىككى تەرىپىگە ئورۇنلاشتۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","بالداقلىرىنى ئاكاتسىيە ياغىچىدىن ياساپ، ئالتۇن بىلەن قاپلىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","خۇشبۇيگاھنى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۇدۇلىدىكى پەردىنىڭ سىرتىغا، يەنى مەن سەن بىلەن كۆرىشىدىغان جاي بولغان ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۈستىدىكى كەفارەت تەختىنىڭ ئۇدۇلىغا قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ھارۇن شۇنىڭ ئۈستىدە ئېسىل خۇشبۇي ئەتىرنى ياندۇرسۇن؛ ھەر كۈنى ئەتىگەنلىكى چىراغلارنى پەرلىگىلى كەلگەندە، خۇشبۇيلارنى ياندۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","شۇنىڭدەك ھارۇن گۇگۇمدا چىراغلارنى تىزىپ ياققاندا، خۇشبۇي ياندۇرسۇن. شۇنداق قىلىپ پەرۋەردىگارنىڭ ئالدىدا نەسىلدىن-نەسىلگە خۇشبۇي ھەمىشە ئۆچۈرۈلمەي يېنىق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","سىلەر ئۇنىڭ ئۈستىدە نە ھېچقانداق غەيرىي خۇشبۇي ياندۇرماڭلار، نە كۆيدۈرمە قۇربانلىق نە ئاشلىق ھەدىيەسى سۇنماڭلار، شۇنداقلا ئۇنىڭ ئۈستىگە ھېچقانداق شاراب ھەدىيەسىنى تۆكمەڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ھەر يىلدا ھارۇن بىر قېتىم خۇشبۇيگاھنىڭ مۈڭگۈزلىرىگە كەفارەت كەلتۈرسۇن؛ ھەر قېتىم كەفارەت كەلتۈرىدىغان گۇناھ قۇربانلىقىنىڭ قېنى بىلەن ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرسۇن. نەسىلدىن-نەسىلگە شۇنداق قىلىڭلار؛ بۇ خۇشبۇيگاھ پەرۋەردىگارغا «ئەڭ مۇقەددەس» ھېسابلىنىدىغان نەرسىلەرنىڭ قاتارىدىندۇر. ");
INSERT INTO uigara_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","سەن ئىسرائىللارنىڭ سانىنى ئېنىقلاش ئۈچۈن ئۇلارنى سانىغىنىڭدا، ئۇلارنىڭ سانىلىشى ۋەجىدىن ئارىسىغا بالايىئاپەت كەلمەسلىكى ئۈچۈن، ئۇلارنى سانىغىنىڭدا ھەربىر ئادەم ئۆز جېنى ئۈچۈن پەرۋەردىگارغا كەفارەت پۇلى تاپشۇرسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","رويخەتكە ئېلىنىپ، ساناقتىن ئۆتكەنلەرنىڭ ھەممىسى بېرىشى كېرەك بولغىنى شۇكى، ھەربىرى مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە يېرىم شەكەل بەرسۇن (بىر شەكەل يىگىرمە گەراھقا باراۋەر كېلىدۇ). بۇ يېرىم شەكەل پەرۋەردىگارغا «كۆتۈرمە ھەدىيە» بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","رويخەتكە ئېلىنىپ، ساناقتىن ئۆتكەنلەر، يەنى يىگىرمە ياش ياكى ئۇنىڭدىن چوڭلارنىڭ ھەربىرى پەرۋەردىگارغا شۇ «كۆتۈرمە ھەدىيە»نى بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ئۆز جېنىڭلارغا كەفارەت كەلتۈرۈش ئۈچۈن پەرۋەردىگارغا كۆتۈرمە ھەدىيە بەرگىنىڭلاردا باي كىشى يېرىم شەكەلدىن ئارتۇق بەرمىسۇن، كەمبەغەل كىشىمۇ يېرىم شەكەلدىن كەم بەرمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","سەن ئىسرائىللاردىن شۇ كەفارەت پۇلىنى تاپشۇرۇپ ئېلىپ، جامائەت چېدىرىنىڭ خىزمىتىگە بېغىشلاپ ئىشلەتكىن؛ ئۇ پۇل ئىسرائىللارغا پەرۋەردىگارنىڭ ھۇزۇرىدا ئەسلەتمە سۈپىتىدە جېنىڭلارغا كەفارەت كەلتۈرىدىغان بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","سەن يۇيۇنۇشقا ئىشلىتىشكە مىستىن يوغان بىر داس ۋە ئۇنىڭغا مىستىن بىر تەگلىك ياساتقىن؛ ئۇنى جامائەت چېدىرى بىلەن قۇربانگاھنىڭ ئوتتۇرىسىغا ئورۇنلاشتۇرۇپ، ئىچىگە سۇ توشتۇرۇپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى ئۇنىڭدىكى سۇ بىلەن پۇت-قوللىرىنى يۇسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ئۇلار جامائەت چېدىرىغا كىرگەندە ئۆلمەسلىكى ئۈچۈن سۇ بىلەن ئۆزىنى يۇيۇشى كېرەك؛ ئۇلار خىزمەت قىلىش ئۈچۈن، قۇربانگاھقا يېقىن بېرىپ پەرۋەردىگارغا ئوت ئارقىلىق ئاتىلىدىغان قۇربانلىق سۇنماقچى بولغىنىدىمۇ، شۇنداق قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ئۇلار ئۆلمەسلىكى ئۈچۈن پۇت-قوللىرىنى يۇسۇن؛ بۇ ئىش ئۇلارغا، يەنى ئۆزى ۋە ئۇنىڭ نەسىللىرى ئۈچۈن ئەۋلادتىن ئەۋلادقىچە ئەبەدىي بىر بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","سەن ھەممىدىن ئېسىل خۇشبۇي دورا-دەرمەكلەردىن تەييارلا، يەنى مۇرمەككى سۇيۇقلۇقىدىن بەش يۈز شەكەل، دارچىندىن ئىككى يۈز ئەللىك شەكەل، ئېگىردىن ئىككى يۈز ئەللىك شەكەل، ");
INSERT INTO uigara_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","قوۋزاقدارچىندىن بەش يۈز شەكەل ئېلىپ (بۇ ئۆلچەملەر مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە بولسۇن) ۋە زەيتۇن مېيىدىنمۇ بىر ھىن تەييارلا؛ ");
INSERT INTO uigara_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","بۇ دورا-دەرمەكلەر بىلەن مەسىھ قىلىش ئۈچۈن بىر مۇقەددەس ماي ــ ئەتىرچى چىقارغاندەك بىر خۇشبۇي ماي چىقارغۇزغىن. بۇ «مۇقەددەس مەسىھلەش مېيى» بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","سەن ئۇنىڭ بىلەن جامائەت چېدىرىنى، ھۆكۈم-گۇۋاھلىق ساندۇقىنى، ");
INSERT INTO uigara_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","شىرە ۋە ئۇنىڭ بارلىق قاچا-قۇچىلىرىنى، چىراغدان ۋە ئۇنىڭ ئەسۋابلىرىنى، خۇشبۇيگاھنى، ");
INSERT INTO uigara_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","كۆيدۈرمە قۇربانلىق قۇربانگاھى ۋە ئۇنىڭ ئەسۋابلىرىنى، يۇيۇنۇش دېسى ۋە ئۇنىڭ تەگلىكىنى مەسىھلىگىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","سەن شۇ تەرزدە ئۇلارنى «ئەڭ مۇقەددەس نەرسىلەر» قاتارىدا مۇقەددەس قىلغىن. ئۇلارغا تەگكەن ھەرقانداق نەرسىمۇ «مۇقەددەس» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىنى بولسا ماڭا كاھىنلىق خىزمەتتە بولۇشى ئۈچۈن مەسىھلەپ مۇقەددەس قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ئىسرائىللارغا سۆز قىلىپ مۇنداق ئېيتقىن: ــ بۇ ماي ئەۋلادتىن ئەۋلادقىچە ماڭا ئاتالغان مۇقەددەس مەسىھلەش مېيى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ئۇنى ئادەمنىڭ بەدىنىگە قۇيسا بولمايدۇ؛ شۇنىڭدەك ئۇنىڭغا ئوخشايدىغان ياكى تەركىبى ئوخشىشىدىغان ھېچقانداق مايلارنى ياسىماڭلار. ئۇ مۇقەددەس بولغىنى ئۈچۈن سىلەرگىمۇ مۇقەددەس بولۇشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","كىمكى تەركىبى شۇنىڭغا ئوخشايدىغان ماي تەڭشىسە، ياكى ئۇنى ئېلىپ يات بىرسىگە سۈرسە، ئۇ ئۆز خەلقى ئارىسىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ سەن خۇشبۇي دورا-دەرمەكلەر، يەنى خۇشبۇي يېلىم، دېڭىز قۇلۇلىسى مېيى، ئاق دېۋىرقاي ۋە ساپ مەستىكى تەييارلىغىن. بۇلارنىڭ ھەممىسى ئوخشاش مىقداردا بولسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","خۇددى ئەتىرچى ماي چىقارغانغا ئوخشاش، ئۇلارنى تەڭشەپ خۇشبۇي ياسىغىن؛ ئۇ تۇزلانغان، ساپ ۋە مۇقەددەس پۇراقلىق ئەتىر بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","سەن ئۇنىڭدىن ئازراق ئېلىپ، تالقاندەك ئوبدان ئېزىپ، جامائەت چېدىرىدىكى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۇدۇلىغا، يەنى مەن سىلەر بىلەن كۆرۈشىدىغان جاينىڭ ئالدىغا قويغىن. بۇ سىلەرگە پەرۋەردىگارغا ئاتالغان «ئەڭ مۇقەددەس نەرسىلەر» قاتارىدا ھېسابلانسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","سىلەر ياسىغان بۇ خۇشبۇينىڭ رېتسېپى بىلەن ئۆزۈڭلارغىمۇ ئوخشاش بىر خۇشبۇينى ياسىۋالساڭلار بولمايدۇ. ئۇ ساڭا نىسبەتەن ئېيتقاندا پەرۋەردىگارغا خاس قىلىنغان مۇقەددەس بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","كىمكى ئۇنىڭ پۇرىقىنى پۇراپ ھۇزۇرلىنىش ئۈچۈن ئۇنىڭغا ئوخشاپ كېتىدىغان ھەرقانداق بىر خۇشبۇينى ياسىسا، ئۇ ئۆز خەلقى ئارىسىدىن ئۈزۈپ تاشلانسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","پەرۋەردىگار خۇدا مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","مانا، مەن ئۆزۈم يەھۇدا قەبىلىسىدىن بولغان خۇرنىڭ نەۋرىسى، ئۇرىنىڭ ئوغلى بەزالەلنى ئىسمىنى ئاتاپ چاقىردىم؛    ");
INSERT INTO uigara_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ئۇنى خۇدانىڭ روھى بىلەن تولدۇرۇپ، ئۇنىڭغا دانالىق، ئەقىل-پاراسەت، ئىلىم-ھېكمەت ئىگىلىتىپ، ئۇنى ھەرتۈرلۈك ئىشنى قىلىشقا قابىلىيەتلىك قىلىپ، ");
INSERT INTO uigara_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","تۈرلۈك-تۈرلۈك ھۈنەرلەرنى قىلالايدىغان، يەنى ئالتۇن، كۈمۈش ۋە مىس ئىشلىرىنى قىلالايدىغان، ");
INSERT INTO uigara_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ياقۇتلارنى كېسىپ-ئويالايدىغان، ئۇلارنى زىننەت بۇيۇملىرىغا ئورنىتالايدىغان، ياغاچلارغا نەقىش چىقىرالايدىغان، ھەرخىل ھۈنەر ئىشلىرىنى قاملاشتۇرالايدىغان قىلدىم. ");
INSERT INTO uigara_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","شۇنىڭدەك مانا، مەن يەنە دان قەبىلىسىدىن ئاھىساماقنىڭ ئوغلى ئوھولىيابنى ئۇنىڭغا ياردەمچىلىككە تەيىنلىدىم، شۇنداقلا مەن ساڭا بۇيرۇغان ھەممە نەرسىلەرنى ياسىسۇن دەپ، بارلىق پەم-پاراسەتلىك كىشىكەرنىڭ كۆڭلىگە تېخىمۇ ئەقىل-پاراسەت ئاتا قىلدىم؛ ");
INSERT INTO uigara_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","شۇنىڭ بىلەن ئۇلار جامائەت چېدىرىنى، ھۆكۈم-گۇۋاھلىق ساندۇقىنى، ئۇنىڭ ئۈستىدىكى كەفارەت تەختىنى، چېدىرىنىڭ ھەممە ئەسۋابلىرىنى، ");
INSERT INTO uigara_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","شىرە بىلەن ئۇنىڭ قاچا-قۇچىلىرىنى، ساپ ئالتۇندىن ياسىلىدىغان چىراغدان بىلەن ئۇنىڭ بارلىق ئەسۋابلىرىنى، خۇشبۇيگاھنى، ");
INSERT INTO uigara_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","كۆيدۈرمە قۇربانلىق قۇربانگاھى بىلەن ئۇنىڭ بارلىق ئەسۋابلىرىنى، يۇيۇش دېسى بىلەن ئۇنىڭ تەگلىكىنى ياسىيالايدىغان، ");
INSERT INTO uigara_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","خىزمەت كىيىملىرى، يەنى كاھىنلىق خىزمىتىدە كىيىلىدىغان، ھارۇن كاھىننىڭ مۇقەددەس كىيىملىرى ۋە ئۇنىڭ ئوغۇللىرىنىڭ كاھىنلىق كىيىملىرىنى توقۇيالايدىغان، ");
INSERT INTO uigara_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","مەسىھلەش مېيى ۋە مۇقەددەس جايغا تەييارلىنىدىغان ئېسىل دورا-دەرمەكلەردىن خۇشبۇينى ياسىيالايدىغان بولدى. مەن ساڭا ئەمر قىلغىنىم بويىچە ئۇلار بارلىق ئىشنى بەجا كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","پەرۋەردىگار مۇساغا ئەمر قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","سەن ئىسرائىللارغا ئەمر قىلىپ ئۇلارغا: ــ «سىلەر مېنىڭ شابات كۈنلىرىمنى چوقۇم تۇتۇڭلار؛ چۈنكى بۇلار سىلەرنىڭ ئۆزۈڭلارنى پاك-مۇقەددەس قىلغۇچىنىڭ مەن پەرۋەردىگار ئىكەنلىكىنى بىلىشىڭلار ئۈچۈن مەن بىلەن سىلەرنىڭ ئوتتۇراڭلاردىكى بىر نىشانە-بەلگە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","شابات كۈنى سىلەرگە مۇقەددەس قىلىپ بېكىتىلگىنى ئۈچۈن، ئۇنى تۇتۇڭلار؛ كىمكى ئۇنى بۇزسا، ئۆلۈم جازاسىغا تارتىلمىسا بولمايدۇ؛ بەرھەق، كىمكى ئۇ كۈنىدە ھەرقانداق ئىشنى قىلسا، ئۆز خەلقى ئارىسىدىن ئۈزۈپ تاشلانسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ئالتە كۈن ئىچىدە ئىش قىلىنسۇن؛ لېكىن يەتتىنچى كۈنى پەرۋەردىگارغا ئاتالغان مۇقەددەس كۈن بولۇپ، ئارام ئالىدىغان شابات كۈنى بولىدۇ؛ كىمكى شابات كۈنىدە بىرەر ئىش قىلسا، ئۆلۈم جازاسىغا تارتىلمىسا بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ئىسرائىللار شابات كۈنىنى تۇتۇشى كېرەك؛ ئۇلار ئەبەدىي ئەھدە سۈپىتىدە ئۇنى ئەۋلادتىن ئەۋلادقىچە تۇتسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","بۇ مەن بىلەن ئىسرائىللارنىڭ ئوتتۇرىسىدا ئەبەدىي بىر نىشانە-بەلگە بولىدۇ؛ چۈنكى پەرۋەردىگار ئالتە كۈن ئىچىدە ئاسمان بىلەن زېمىننى يارىتىپ، يەتتىنچى كۈنىدە ئارام ئېلىپ راھەت تاپقانىدى»، ــ دېگىن. ");
INSERT INTO uigara_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","خۇدا سىناي تېغىدا مۇساغا بۇ سۆزلەرنى قىلىپ بولغاندىن كېيىن، ئىككى ھۆكۈم-گۇۋاھلىق تاختىيىنى ئۇنىڭغا تاپشۇردى. تاختايلار تاشتىن بولۇپ، سۆزلەر خۇدانىڭ بارمىقى بىلەن ئۇلارغا پۈتۈلگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","خەلق مۇسانىڭ تاغدىن چۈشمەي ھايال بولۇپ قالغىنىنى كۆرۈپ، ھارۇننىڭ قېشىغا يىغىلىپ ئۇنىڭغا: ــ سەن قوپۇپ، بىزگە ئالدىمىزدا يول باشلاپ ماڭىدىغان بىر ئىلاھ ياساپ بەرگىن! چۈنكى بىزنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن مۇسا دېگەن ھېلىقى كىشىگە نېمە بولۇپ كەتكەنلىكىنى بىلمەيمىز، ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ھارۇن ئۇلارغا: ــ خوتۇنلىرىڭلار بىلەن ئوغۇل-قىزلىرىڭلارنىڭ قۇلاقلىرىدىكى ئالتۇن زىرە ھالقىلارنى چىقىرىپ، مېنىڭ قېشىمغا ئېلىپ كېلىڭلار، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","شۇنىڭ بىلەن پۈتكۈل خەلق ئۆز قۇلاقلىرىدىكى ئالتۇن زىرە ھالقىلارنى چىقىرىپ ھارۇننىڭ قېشىغا ئېلىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ئۇ بۇلارنى ئۇلارنىڭ قولىدىن ئېلىپ، ئىسكىنە بىلەن قۇيما بىر موزاينى ياساتقۇزدى. شۇنىڭ بىلەن ئۇلار: ــ ئەي ئىسرائىل، سېنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن خۇدايىڭلار مانا بۇدۇر! ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ھارۇن ئۇنى كۆرۈپ ئۇنىڭ ئالدىدا بىر قۇربانگاھنى ياسىتىپ ئاندىن: «ئەتە پەرۋەردىگار ئۈچۈن بىر ھېيت ئۆتكۈزۈلىدۇ»، دەپ ئېلان قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ئەتىسى ئۇلار سەھەر قوپۇپ، كۆيدۈرمە قۇربانلىقلارنى سۇنۇپ، ئىناقلىق قۇربانلىقلىرىنىمۇ كەلتۈردى؛ ئاندىن خالايىق ئولتۇرۇپ يەپ-ئىچىشتى، قوپۇپ ئەيش-ئىشرەت قىلىشتى.    ");
INSERT INTO uigara_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","شۇ چاغدا پەرۋەردىگار مۇساغا: ــ ئورنۇڭدىن تۇر، تېزدىن پەسكە چۈشكىن! چۈنكى سەن مىسىر زېمىنىدىن چىقىرىپ كەلگەن خەلقىڭ بۇزۇقچىلىققا بېرىلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","مەن ئۇلارغا بۇيرۇغان يولدىن شۇنچە تېزلا چەتنەپ، ئۆزلىرى ئۈچۈن بىر قۇيما موزاينى ياساپ، ئۇنىڭغا چوقۇنۇپ قۇربانلىق كەلتۈرۈشتى ھەمدە: «ئەي ئىسرائىل، سېنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن خۇدايىڭ مانا شۇدۇر!»، دېيىشتى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ئاندىن پەرۋەردىگار مۇساغا: ــ مانا، بۇ خەلقنى كۆرۈپ قويدۇم؛ مانا، ئۇلار دەرۋەقە بوينى قاتتىق بىر خەلقتۇر. ");
INSERT INTO uigara_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ئەمدى مېنى توسما، مەن غەزەپ ئوتۇمنى ئۇلارنىڭ ئۈستىگە چۈشۈرۈپ، ئۇلارنى يۇتۇۋېتىمەن؛ ئاندىن سېنى ئۇلۇغ بىر ئەل قىلىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","لېكىن مۇسا خۇداسى پەرۋەردىگاردىن ئۆتۈنۈپ ئىلتىجا قىلىپ مۇنداق دېدى: ــ ئەي پەرۋەردىگار، نېمىشقا سەن غەزەپ ئوتۇڭنى ئۆزۈڭ زور قۇدرەت ۋە كۈچلۈك قول بىلەن مىسىر زېمىنىدىن چىقىرىپ كەلگەن خەلقىڭنىڭ ئۈستىگە چۈشۈرىسەن؟ ");
INSERT INTO uigara_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","مىسىرلىقلار مازاق قىلىپ: ــ ئۇلارنىڭ بېشىغا بالا چۈشۈرۈش ئۈچۈن، ئۇلارنى تاغلارنىڭ ئۈستىدە ئۆلتۈرۈپ يەر يۈزىدىن يوقىتىش ئۈچۈن، ئۇلارنىڭ خۇداسى ئۇلارنى ئېلىپ كەتتى، ــ دېيىشسۇنمۇ؟ ئۆز ئوتلۇق غەزىپىڭدىن يېنىپ، ئۆز خەلقىڭگە بالايىئاپەت كەلتۈرۈش نىيىتىڭدىن يانغايسەن! ");
INSERT INTO uigara_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ئۆز قۇللىرىڭ ئىبراھىم، ئىسھاق ۋە ئىسرائىلنى ياد قىلغىن؛ سەن ئۇلارغا قەسەم بىلەن ۋەدە قىلىپ: «نەسلىڭلارنى ئاسماندىكى يۇلتۇزلاردەك ئاۋۇتىمەن، ئۆزۈم ئۇنىڭ توغرىسىدا سۆزلىگەن مۇشۇ زېمىننىڭ ھەممىسىنى نەسلىڭلارغا بېرىمەن، ئۇلار ئۇنىڭغا مەڭگۈ ئىگىدارچىلىق قىلىدىغان بولىدۇ» دېگەنىدىڭغۇ، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","شۇنىڭ بىلەن پەرۋەردىگار ئۆز خەلقىنىڭ ئۈستىگە: «بالايىئاپەت چۈشۈرىمەن» دېگەن نىيىتىدىن ياندى. ");
INSERT INTO uigara_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","مۇسا كەينىگە بۇرۇلۇپ، ئىككى ھۆكۈم-گۇۋاھلىق تاختىيىنى قولىغا ئېلىپ تاغدىن چۈشتى. تاختايلارنىڭ ئىككى تەرىپىگە سۆزلەر پۈتۈلگەنىدى؛ ئۇ يۈزىگىمۇ، بۇ يۈزىگىمۇ پۈتۈكلۈك ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","بۇ تاختايلار بولسا خۇدانىڭ ئۆزىنىڭ ياسىغىنى، پۈتۈلگەنلىرى بولسا خۇدانىڭ ئۆزىنىڭ پۈتكىنى ئىدى، ئۇ تاختايلارغا ئويۇلغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","يەشۇئا خەلقنىڭ كۆتۈرگەن چۇقان-سۈرەنلىرىنى، ۋارقىراشلىرىنى ئاڭلاپ مۇساغا: ــ چېدىرگاھدىن جەڭنىڭ خىتابى چىقىۋاتىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","لېكىن ئۇ جاۋاب بېرىپ: ــ ئاڭلىنىۋاتقان ئاۋاز نە نۇسرەت تەنتەنىسى ئەمەس، نە مەغلۇبىيەتنىڭ پەريادى ئەمەس، بەلكى ناخشا-كۈي ساداسى! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","مۇسا چېدىرگاھغا يېقىن كېلىپ، موزاينى ۋە جامائەتنىڭ ئۇسسۇلغا چۈشۈپ كەتكەنلىكىنى كۆرۈپ شۇنداق دەرغەزەپ بولدىكى، تاختايلارنى قولىدىن تاشلاپ تاغنىڭ تۈۋىدە چېقىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ئاندىن ئۇلار ياسىغان موزاينى ئوتقا سېلىپ كۆيدۈرۈپ، ئۇنى يانجىپ كۇكۇم-تالقان قىلىپ، سۇ ئۈستىگە چېچىپ ئىسرائىللارنى ئىچىشكە مەجبۇرلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ئاندىن مۇسا ھارۇنغا: سەن ئۇلارنى شۇنچە ئېغىر گۇناھقا پاتقۇزغۇدەك، مۇشۇ خەلق ساڭا نېمە قىلدى؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ھارۇن جاۋاب بېرىپ: ــ خوجامنىڭ غەزەپ-ئاچچىقى تۇتاشمىغاي! بۇ خەلقنىڭ قانداق ئىكەنلىكىنى، ئۇلارنىڭ زەزىللىككە مايىل ئىكەنلىكىنى ئوبدان بىلىسەن. ");
INSERT INTO uigara_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ئۇلار ماڭا: ــ «بىزگە ئالدىمىزدا يول باشلاپ ماڭىدىغان بىر ئىلاھنى ياساپ بەرگىن؛ چۈنكى بىزنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن مۇسا دېگەن شۇ ئادەمگە نېمە بولغىنىنى بىلمەيمىز»، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","مەن ئۇلارغا: «كىمدە ئالتۇن بولسا شۇنى چىقىرىپ بەرسۇن» دېسەم، ئۇلار ماڭا تاپشۇرۇپ بەردى؛ مەن ئۇنى ئوتقا تاشلىۋىدىم، مانا، بۇ موزاي چىقتى، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","مۇسا خەلقنىڭ قانداقسىگە تىزگىنسىز بولۇپ كەتكەنلىكىنى كۆردى؛ چۈنكى ھارۇن ئۇلارنى دۈشمەنلىرىنىڭ ئالدىدا مەسخىرە ئوبيېكتى بولۇشقا ئۆز مەيلىگە قويۇۋەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","مۇسا چېدىرگاھنىڭ كىرىش ئېغىزىغا بېرىپ، شۇ يەردە تۇرۇپ: ــ كىمكى پەرۋەردىگارنىڭ تەرىپىدە بولسا مېنىڭ يېنىمغا كەلسۇن! ــ دېدى. شۇنى دېۋىدى، لاۋىيلارنىڭ ھەممىسى ئۇنىڭ قېشىغا يىغىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ئۇ ئۇلارغا: ــ ئىسرائىلنىڭ خۇداسى پەرۋەردىگار مۇنداق دەيدۇ: ــ «ھەربىر كىشى ئۆز قىلىچىنى يانپىشىغا ئېسىپ، چېدىرگاھنىڭ ئىچىگە كىرىپ، بۇ چېتىدىن ئۇ چېتىگىچە كېزىپ يۈرۈپ، ھەربىرى ئۆز قېرىندىشىنى، ئۆز دوست-بۇرادىرىنى، ئۆز قوشنىسىنى ئۆلتۈرسۇن!» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","شۇنىڭ بىلەن لاۋىيلار مۇسانىڭ بۇيرۇغىنى بويىچە ئىش كۆردى؛ شۇ كۈنى خەلقنىڭ ئىچىدىن ئۈچ مىڭ كىشى ئۆلتۈرۈلدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ئاندىن مۇسا: ــ ھەربىرىڭلار بۈگۈن ئۆزۈڭلارنى پەرۋەردىگارغا خاس بولۇشقا ئاتىدىڭلار؛ چۈنكى ھەربىرىڭلار ھەتتا ئۆز ئوغلۇڭلار ھەم قېرىندىشىڭلارنىمۇ ئايىمىدىڭلار؛ شۇنىڭ بىلەن بۈگۈن بەخت-بەرىكەتنى ئۈستۈڭلارغا چۈشۈردۇڭلار، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ئەتىسى مۇسا خەلققە سۆز قىلىپ: ــ سىلەر دەرۋەقە ناھايىتى ئېغىر بىر گۇناھ سادىر قىلدىڭلار. ئەمدى مانا، مەن پەرۋەردىگارنىڭ ئالدىغا چىقىمەن؛ گۇناھىڭلار ئۈچۈن كەفارەت كەلتۈرەلەيمەنمىكىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","شۇنىڭ بىلەن مۇسا پەرۋەردىگارنىڭ ئالدىغا يېنىپ بېرىپ: ــ ھەي...! بۇ خەلق دەرۋەقە ئېغىر بىر گۇناھ سادىر قىلىپ، ئۆزلىرىگە ئالتۇندىن ئىلاھلارنى ياساپتۇ! ");
INSERT INTO uigara_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","لېكىن ئەمدى سەن ئۇلارنىڭ گۇناھىنى ئەپۇ قىلىشقا ئۇنىغايسەن...، ئۇنىمىساڭ، ئىسمىمنى ئۆزۈڭ يازغان دەپتىرىڭدىن ئۆچۈرۈۋەتكىن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","پەرۋەردىگار مۇساغا جاۋاب بېرىپ: ــ كىمكى مېنىڭ ئالدىمدا گۇناھ قىلغان بولسا، ئۇنىڭ ئېتىنى ئۆز دەپتىرىمدىن ئۆچۈرۈۋېتىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ئەمدى سەن بېرىپ، مەن ساڭا ئېيتقان جايغا خەلقنى باشلاپ بارغىن. مانا، مېنىڭ پەرىشتەم ئالدىڭدا ماڭىدۇ. لېكىن ئۇلارغا جازا بېرىدىغان كۈنۈم كەلگەندە، ئۇلارغا گۇناھى ئۈچۈن جازا بېرىمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","بۇ سۆزدىن كېيىن پەرۋەردىگار خەلقنىڭ ھارۇننىڭ قولى بىلەن موزاينى قۇيدۇرۇپ ياساتقىنى ئۈچۈن ئۇلارنى ۋابا بىلەن جازالىدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ سەن ئورنۇڭدىن تۇرۇپ، ئۆزۈڭ مىسىر زېمىنىدىن ئېلىپ كەلگەن خەلق بىلەن بىللە مۇشۇ يەردىن كېتىپ: «مەن سېنىڭ نەسلىڭگە ئۇنى بېرىمەن» دەپ قەسەم قىلىپ ئىبراھىمغا، ئىسھاققا ۋە ياقۇپقا ۋەدە قىلغان زېمىنغا بارغىن. ");
INSERT INTO uigara_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","شۇنىڭ بىلەن سېنىڭ ئالدىڭدا بىر پەرىشتە ئەۋەتىپ، قانائانىي، ئامورىي، ھىتتىي، پەرىززىيلەرنى، ھىۋىي بىلەن يەبۇسىيلارنى ھەيدەپ چىقىرىپ، ");
INSERT INTO uigara_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","سېنى سۈت بىلەن ھەسەل ئېقىپ تۇرىدىغان زېمىنغا كەلتۈرىمەن. چۈنكى سىلەر بوينى قاتتىق بىر خەلق بولغاچقا، يولدا سىلەرنى ھالاك قىلىۋەتمەسلىكىم ئۈچۈن، ئۆزۈم سىلەرنىڭ ئاراڭلاردا بولۇپ، شۇ زېمىنغا بىللە چىقمايمەن، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","خالايىق بۇ قاتتىق سۆزنى ئاڭلاپ، قايغۇغا چۆمۈپ ھېچقايسىسى ئۆز زىبۇ-زىننەتلىرىنى تاقىمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","چۈنكى پەرۋەردىگار مۇساغا سۆز قىلىپ: ــ سەن بېرىپ ئىسرائىللارغا: «پەرۋەردىگار: ــ سىلەر بوينى قاتتىق بىر خەلق ئىكەنسىلەر؛ ئەگەر مەن پەرۋەردىگار ئاراڭلارغا چىقىپ بىر دەقىقىلا تۇرسام، سىلەرنى يوقىتىۋەتكەن بولاتتىم. ئەمدى سىلەر ئۆزۈڭلاردىكى زىبۇ-زىننەتلەرنى ئېلىۋېتىڭلار؛ شۇ چاغدا مەن سىلەرگە نېمە قىلىدىغىنىمنى بىلىمەن، دېدى»، دەپ ئېيتقىن، ــ دېگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","شۇڭا ئىسرائىللار ھورەب تېغىدىن ئايرىلىپلا زىبۇ-زىننەتلىرىنى ئۆزلىرىدىن ئېلىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","شۇنىڭ بىلەن مۇسا ئۆز چېدىرىنى ئېلىپ، ئۇنى چېدىرگاھنىڭ سىرتىدا، چېدىرگاھدىن نېرىراق بىر جايغا تىكىپ، ئۇنى «كۆرۈشۈش چېدىرى» دەپ ئاتىدى. كىمكى پەرۋەردىگارنى ئىزدەپ، يول سورىماقچى بولسا چېدىرگاھنىڭ سىرتىدىكى «كۆرۈشۈش چېدىرى»غا باراتتى. ");
INSERT INTO uigara_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","شۇنداق بولاتتىكى، ھەر قېتىم مۇسا چېدىرغا چىقسا، پۈتكۈل خالايىق قوپۇپ، ھەربىرى ئۆز چېدىرىنىڭ ئىشىكىدە ئۆرە تۇرۇپ، مۇسا چېدىرغا كىرىپ بولغۇچە ئۇنىڭ كەينىدىن قارىشىپ تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ئاندىن مۇسا ھەر قېتىم چېدىرغا كىرىپ كەتسە شۇنداق بولاتتىكى، بۇلۇت تۈۋرۈكى چۈشۈپ، چېدىرنىڭ كىرىش ئېغىزىدا توختايتتى؛ شۇنىڭ بىلەن پەرۋەردىگار مۇسا بىلەن سۆزلىشەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","پۈتكۈل خالايىق بۇلۇت تۈۋرۈكىنىڭ جامائەت چېدىرىنىڭ كىرىش ئېغىزىدا توختىغىنىنى كۆرەتتى؛ ئۇنى كۆرگىنىدە خەلقنىڭ ھەممىسى قوپۇپ، ھەربىرى ئۆز چېدىرىنىڭ ئىشىكىدە تۇرۇپ سەجدە قىلىشاتتى. ");
INSERT INTO uigara_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","شۇ چاغلاردا پەرۋەردىگار مۇسا بىلەن كىشىلەر ئۆز دوست-بۇرادىرى بىلەن سۆزلەشكەندەك، يۈزمۇيۈز سۆزلىشەتتى. ئاندىن مۇسا چېدىرگاھغا يېنىپ كېلەتتى؛ لېكىن ئۇنىڭ خىزمەتكارى بولغان نۇننىڭ ئوغلى يەشۇئا دېگەن ياش يىگىت چېدىرنىڭ ئىچىدىن چىقمايتتى. ");
INSERT INTO uigara_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","مۇسا پەرۋەردىگارغا مۇنداق دېدى: ــ مانا، سەن دائىم ماڭا: «بۇ خەلقنى ئېلىپ چىققىن» دەپ كەلدىڭ؛ لېكىن ئۆزۈڭ ماڭا: «مەن سېنى ئىسمىڭنى بىلىپ تونۇيمەن»، ۋە شۇنىڭدەك «نەزىرىم ئالدىدا ئىلتىپات تاپتىڭ» دېگەن بولساڭمۇ، سەن مېنىڭ بىلەن بىرگە كىمنى ئەۋەتىدىغىنىڭنى ماڭا ئايان قىلمىدىڭ. ");
INSERT INTO uigara_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ئەگەر مەن راستتىنلا نەزىرىڭدە ئىلتىپات تاپقان بولسام، ئۆزۈمنىڭ سېنى تونۇشۇم ئۈچۈن، نەزىرىڭدە ئىلتىپات تېپىۋېرىشىم ئۈچۈن ماڭا ئۆز يولۇڭنى ئايان قىلغايسەن؛ مانا، بۇ خەلقنىڭ ئۆز خەلقىڭ بولغىنىنى نەزىرىڭدە تۇتقايسەن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ئۇ جاۋاب بېرىپ: مەن ئۆزۈم سەن بىللە بىللە بېرىپ، ساڭا ئارام ئاتا قىلىمەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","مۇسا ئۇنىڭغا جاۋابەن: ــ ئەگەر سەن ئۆزۈڭ بىز بىلەن بىللە ماڭمىساڭ، بىزنى بۇ يەردىن چىقارمىغايسەن؛ ");
INSERT INTO uigara_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","چۈنكى، مەن ۋە خەلقىڭ نەزىرىڭدە ئىلتىپات تاپقىنىمىز نېمىدىن بىلىنىدۇ؟ ئەجەبا، ئۆزۈڭنىڭ بىز بىلەن بىللە ماڭغىنىڭدىن بىلىنمەمدۇ؟ شۇ سەۋەبتىن مەن ۋە خەلقىڭ يەر يۈزىدىكى ھەربىر تائىپىلەردىن ئالاھىدە پەرقلەنمەمدۇق؟! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","پەرۋەردىگار مۇساغا: ــ مۇشۇ ئىلتىجايىڭنىمۇ ئىجابەت قىلىمەن؛ چۈنكى سەن نەزىرىمدە ئىلتىپات تاپتىڭ ۋە مەن سېنى ئىسمىڭنى بىلىپ تونۇيمەن، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","شۇنىڭ بىلەن مۇسا: ــ ئۆز شان-شەرپىڭنى ماڭا كۆرسەتكەيسەن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","پەرۋەردىگار: ــ ئۆزۈمنىڭ پۈتكۈل مېھرىبانلىقىمنى سېنىڭ كۆز ئالدىڭدىن ئۆتكۈزىمەن ۋە ئالدىڭدا «ياھۋەھ» دېگەن نامنى جاكارلايمەن. كىمگە شاپائەت قىلماقچى بولسام شۇنىڭغا شاپائەت كۆرسىتىمەن، كىمگە رەھىم-شەپقەت كۆرسەتمەكچى بولسام، شۇنىڭغا رەھىم-شەپقەت كۆرسىتىمەن، دېدى.    ");
INSERT INTO uigara_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","پەرۋەردىگار ئۇنىڭغا: ــ سەن يۈزۈمنى كۆرەلمەيسەن؛ چۈنكى ھېچ ئادەمزات مېنى كۆرسە تىرىك قالمايدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ئاندىن پەرۋەردىگار: ــ مانا، يېنىمدا بىر جاي باردۇر؛ سەن شۇ يەردىكى قورام تاشنىڭ ئۈستىدە تۇرغىن. ");
INSERT INTO uigara_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","مېنىڭ شان-شەرىپىم ئۆتىدىغان ۋاقىتتا، شۇنداق بولىدۇكى، مەن سېنى شۇ قورام تاشنىڭ يېرىقىدا تۇرغۇزۇپ، مەن ئۆتۈپ بولغۇچە سېنى قولۇم بىلەن يېپىپ تۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ئاندىن قولۇمنى تارتىۋالىمەن؛ شۇنىڭ بىلەن سەن مېنىڭ ئارقا تەرىپىمنى كۆرىسەن، لېكىن يۈزۈم كۆرۈنمەيدۇ، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","پەرۋەردىگار مۇساغا: ــ سەن ئاۋۋالقىغا ئوخشاش ئۆزۈڭ ئۈچۈن تاشتىن ئىككى تاختاينى يونۇپ كەل؛ مەن بۇ تاختايلارغا سەن ئىلگىرى چېقىۋەتكەن تاختايلاردىكى سۆزلەرنى يېزىپ قويىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","سەن ئەتە ئەتىگەنگىچە تەييار بولۇپ، سەھەردە سىناي تېغىغا چىقىپ، شۇ يەردە تاغنىڭ چوققىسىدا مېنىڭ ئالدىمدا ھازىر بولغىن. ");
INSERT INTO uigara_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","لېكىن ھېچ كىشى سەن بىلەن بىللە چىقمىسۇن ۋە ياكى تاغنىڭ ھېچ يېرىدە باشقا ئادەم كۆرۈنمىسۇن، قوي-كالىلارمۇ تاغنىڭ تۈۋىدە ئوتلىمىسۇن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","مۇسا ئاۋۋالقىغا ئوخشاش تاشتىن ئىككى تاختاينى يونۇپ، ئەتىسى تاڭ سەھەر قوپۇپ، بۇ ئىككى تاش تاختاينى قولىدا ئېلىپ، پەرۋەردىگارنىڭ بۇيرۇغىنى بويىچە سىناي تېغىغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","شۇنىڭ بىلەن پەرۋەردىگار بۇلۇتتا چۈشۈپ، شۇ يەردە مۇسانىڭ قېشىدا تۇرۇپ، «ياھۋەھ» دېگەن نامىنى جاكارلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","پەرۋەردىگار ئۇنىڭ كۆز ئالدىدىن ئۆتۈپ: ــ «پەرۋەردىگار، پەرۋەردىگار، رەھىمدىل ۋە مېھىر-شەپقەتلىكتۇر، ئاسان غەزەپلەنمەيدىغان، شاپائەت بىلەن ۋاپاسى كەڭ تەڭرىدۇر،    ");
INSERT INTO uigara_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","مىڭلىغان-ئون مىڭلىغانلارغا رەھىم-شاپائەت كۆرسىتىپ، قەبىھلىك، ئاسىيلىق ۋە گۇناھنى كەچۈرگۈچىدۇر؛ لېكىن ئۇ گۇناھكارلارنى ھەرگىز گۇناھسىز دەپ قارىمايدىغان، بەلكى ئاتىلارنىڭ قەبىھلىكىنىڭ جازاسىنى بالىلىرى ۋە نەۋرلىرىگىچە، شۇنداقلا ئۈچىنچى ۋە تۆتىنچى ئەۋلادىغىچە يۈكلەيدىغان تەڭرىدۇر» ــ دەپ جاكارلىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","شۇنىڭ بىلەن مۇسا دەرھال يەرگە باش قويۇپ سەجدە قىلىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ــ ئەي رەب، ئەگەر مەن راستتىنلا نەزىرىڭدە ئىلتىپات تاپقان بولسام، ئۇنداقتا ئى رەب، ئارىمىزدا بىز بىلەن ماڭغايسەن؛ چۈنكى بۇ خەلق دەرۋەقە بوينى قاتتىق بىر خەلقتۇر؛ بىزنىڭ قەبىھلىكىمىزنى ۋە گۇناھىمىزنى كەچۈرگەيسەن، بىزنى ئۆز مىراسىڭ بولۇشقا قوبۇل قىلغايسەن! ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","شۇنىڭ بىلەن ئۇ مۇساغا: ــ مانا، مەن بىر ئەھدە تۈزىمەن؛ سېنىڭ بارلىق خەلقىڭ ئالدىدا پۈتكۈل يەر يۈزىنىڭ ھېچبىر جايىدا ياكى ھېچبىر ئەل ئارىسىدا قىلىنىپ باقمىغان مۆجىزىلەرنى يارىتىمەن. شۇنىڭ بىلەن سەن ئارىسىدا بولغان خەلقىڭنىڭ ھەممىسى پەرۋەردىگارنىڭ كارامەت ئەمەلىنى كۆرىدۇ؛ چۈنكى مېنىڭ سىلەرگە قىلىدىغان ئەمەلىم دەرۋەقە دەھشەتلىك ئىش بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","مەن بۈگۈن ساڭا تاپىلايدىغان ئەمرلىرىمنى تۇتقىن؛ مانا، مەن سىلەرنىڭ ئالدىڭلاردىن ئامورىي، قانائانىي، ھىتتىي، پەرىززىي، ھىۋىي ۋە يەبۇسىيلارنى ھەيدەپ چىقىرىمەن. ");
INSERT INTO uigara_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ئەمدى ھېزى بولغىنكى، سەن بارىدىغان زېمىندا تۇرۇۋاتقانلار بىلەن ھېچ ئەھدە باغلاشمىغىن؛ بولمىسا، بۇ ئىش سىلەرگە تۇزاق بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بەلكى سىلەر ئۇلارنىڭ قۇربانگاھلىرىنى چۇۋۇپ، بۇت تۈۋرۈكلىرىنى سۇندۇرۇپ، «ئاشەراھ» بۇتلىرىنى كېسىپ تاشلاڭلار. ");
INSERT INTO uigara_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","چۈنكى سەن ھېچقانداق باشقا ئىلاھقا ئىبادەت قىلماسلىقىڭ كېرەك ــ چۈنكى مەنكى پەرۋەردىگارنىڭ نامى «ۋاپاسىزلىققا ھەسەت قىلغۇچى» بولۇپ، ھەسەت قىلغۇچى بىر ئىلاھدۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","بولمىسا، شۇ زېمىندا تۇرۇۋاتقانلار بىلەن ئەھدە تۈزۈشۈڭ مۇمكىن؛ ئاندىن ئۇلار ئىلاھلىرىنىڭ كەينىدىن يۈرۈپ بۇزۇقچىلىق قىلىپ، ئىلاھلىرىغا قۇربانلىقلار ئۆتكۈزگىنىدە، سىلەرنى چاقىرسا ئۇلارنىڭ قۇربانلىقلىرىدىن يەپ كېتىشىڭلار مۇمكىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","سەن شۇنداقلا يەنە ئۇلارنىڭ قىزلىرىنى ئوغۇللىرىڭغا خوتۇنلۇققا ئېلىپ بېرىشىڭ مۇمكىن؛ ئۇ قىزلار ئۆز ئىلاھلىرىنىڭ كەينىدىن يۈرۈپ بۇزۇقچىلىق قىلغىنىدا، ئۇلار ئوغۇللىرىڭنىمۇ ئۆز ئىلاھلىرىنىڭ ئارقىسىدىن ماڭغۇزۇپ، بۇزۇقچىلىق قىلدۇرۇشى مۇمكىن. ");
INSERT INTO uigara_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ئۆزۈڭ ئۈچۈن ھېچقانداق قۇيما بۇتلارنى ياساتمىغىن. ");
INSERT INTO uigara_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","پېتىر نان ھېيتىنى تۇتۇڭلار؛ مېنىڭ ئەمر قىلغىنىمدەك ئابىب ئېيىدا، بېكىتىلگەن ۋاقىتتا يەتتە كۈن پېتىر نان يەڭلار. چۈنكى سىلەر ئابىب ئېيىدا مىسىردىن چىققانسىلەر. ");
INSERT INTO uigara_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","بالىياتقۇنىڭ تۇنجى مېۋىسى مېنىڭكى بولىدۇ؛ چارپاي ماللىرىڭنىڭ ئىچىدىن دەسلەپ تۇغۇلغان ئەركەكلەر، كالا بولسۇن، قوي بولسۇن ئۇلارنىڭ تۇنجىلىرىنىڭ ھەممىسى مېنىڭكى بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","لېكىن ئېشەكلەرنىڭ تۇنجى تەخەيلىرىنىڭ ئورنىغا قوزا بىلەن بەدەل تۆلىشىڭ لازىم بولىدۇ. ئەگەر ئورنىغا قوزا بەرمىسەڭ، تەخەينىڭ بوينىنى سۇندۇرۇۋەتكىن. تۇنجى ئوغۇللىرىڭنى بولسا، ئۇلارغا بەدەل تۆلەپ قايتۇرۇۋال. ھېچكىم مېنىڭ ھۇزۇرۇمغا قۇرۇق قول كەلمىسۇن.    ");
INSERT INTO uigara_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","سەن ئالتە كۈن ئىچىدە ئىش-ئەمەلىڭنى قىلىپ، يەتتىنچى كۈنى ئارام ئېلىشىڭ زۆرۈر؛ يەر ھەيدەش ۋاقتى بولسۇن، ئورما ۋاقتى بولسۇن، ئارام ئېلىشىڭ زۆرۈر. ");
INSERT INTO uigara_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","يېڭى بۇغداينىڭ تۇنجى ھوسۇلىنى تەبرىكلەيدىغان «ھەپتىلەر ھېيتى»نى ئۆتكۈزۈڭلار؛ يىلنىڭ ئاخىرىدا «ھوسۇل يىغىش ھېيتى»نى ئۆتكۈزۈڭلار.    ");
INSERT INTO uigara_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","سېنىڭ ھەربىر ئەركەك كىشىلىرىڭ يىلدا ئۈچ قېتىم ئىسرائىلنىڭ خۇداسى بولغان رەب پەرۋەردىگارنىڭ ئالدىغا ھازىر بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","چۈنكى مەن تائىپىلەرنى ئالدىڭدىن ھەيدىۋېتىپ، چېگرالىرىڭنى كېڭەيتىمەن؛ شۇنىڭدەك سەن يىلدا ئۈچ قېتىم پەرۋەردىگار خۇدايىڭنىڭ ئالدىغا ھازىر بولۇشقا چىقىپ بارساڭ، ھېچكىم يېرىڭگە كۆز قىرىنى سالمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","ماڭا سۇنۇلىدىغان قۇربانلىقنىڭ قېنىنى بولدۇرۇلغان نان بىلەن بىللە سۇنمىغىن؛ ياكى ئۆتۈپ كېتىش ھېيتىنىڭ قۇربانلىقىنىڭ گۆشىنى ئەتىگە قالدۇرما.    ");
INSERT INTO uigara_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","زېمىنىڭنىڭ دەسلەپكى ھوسۇلىدىن تۇنجى مەھسۇلاتلارنى پەرۋەردىگار خۇدايىڭنىڭ ئۆيىگە كەلتۈرۈپ ئاتا. ئوغلاقنى ئانىسىنىڭ سۈتىدە قاينىتىپ پىشۇرما.    ");
INSERT INTO uigara_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","پەرۋەردىگار مۇساغا: ــ بۇ سۆزلەرنى ئۆزۈڭ ئۈچۈن يېزىۋالغىن؛ چۈنكى مەن مۇشۇ سۆزلەرنى ئاساس قىلىپ سەن بىلەن ۋە ئىسرائىل بىلەن ئەھدە باغلىدىم، دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ئۇ ۋاقىتتا مۇسا شۇ يەردە پەرۋەردىگارنىڭ ھۇزۇرىدا قىرىق كېچە-كۈندۈز تۇردى؛ ئۇ ھېچنەرسە يېمىدى، ھېچ سۇ ئىچمىدى. ئۇ يەردە پەرۋەردىگار تاختايلارغا ئەھدىنىڭ سۆزلىرى بولغان ئون ئەمرنى پۈتتى.    ");
INSERT INTO uigara_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","مۇسا سىناي تېغىدىن چۈشكەندە شۇنداق بولدىكى (ئۇ تاغدىن چۈشكەندە ئىككى ھۆكۈم-گۇۋاھلىق تاختىيى ئۇنىڭ قولىدا ئىدى)، ئۆزىنىڭ پەرۋەردىگار بىلەن سۆزلەشكىنى ئۈچۈن يۈزىنىڭ پارقىراپ كەتكىنىنى بىلمەيتتى. ");
INSERT INTO uigara_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ئەمدى ھارۇن ۋە بارلىق ئىسرائىللار مۇسانى كۆردى، مانا، ئۇنىڭ يۈز تېرىسى پارقىراپ تۇراتتى؛ ئۇلار ئۇنىڭغا يېقىن بېرىشتىن قورقۇشتى. ");
INSERT INTO uigara_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","لېكىن مۇسا ئۇلارنى چاقىرىۋىدى، ھارۇن ۋە جامائەتنىڭ بارلىق باشلىرى يېنىپ، ئۇنىڭ قېشىغا كەلدى؛ مۇسا ئۇلار بىلەن سۆزلەشتى. ");
INSERT INTO uigara_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","شۇنىڭدىن كېيىن، بارلىق ئىسرائىللار ئۇنىڭ يېنىغا كەلدى؛ ئۇ ۋاقىتتا مۇسا پەرۋەردىگار ئۆزىگە سىناي تېغىدا سۆز قىلغىنىدا تاپشۇرغان بارلىق ئەمرلەرنى ئۇلارغا تاپىلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","مۇسا ئۇلارغا دەيدىغىنىنى دەپ تۈگەتتى. ئۇ سۆزلىگەندە يۈزىگە بىر چۈمپەردە تارتىۋالغانىدى؛    ");
INSERT INTO uigara_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","قاچانكى مۇسا پەرۋەردىگار بىلەن سۆزلىشىشكە ئۇنىڭ ھۇزۇرىغا كىرسە، چۈمپەردىنى ئېلىۋېتەتتى، تاكى ئۇ يېنىپ چىققۇچە شۇنداق بولاتتى؛ يېنىپ چىققاندا ئۆزىگە نېمە تاپىلانغان بولسا، شۇنى ئىسرائىللارغا ئېيتىپ بېرەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ئىسرائىللار مۇسانىڭ يۈز تېرىسىنىڭ پارقىراپ تۇرغىنىنى كۆرەتتى؛ شۇڭا مۇسا يەنە تاكى پەرۋەردىگار بىلەن سۆزلەشكىلى ئۇنىڭ ھۇزۇرىغا كىرگۈچە يۈزىگە چۈمپەردە تارتىۋالاتتى. ");
INSERT INTO uigara_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","مۇسا ئىسرائىللارنىڭ پۈتكۈل جامائىتىنى يىغىپ ئۇلارغا: ــ پەرۋەردىگار سىلەرگە قىلىشقا بۇيرۇغان ئەمرلەر مۇنۇلاردۇر: ــ ");
INSERT INTO uigara_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ئالتە كۈن ئىش-ئەمگەك كۈنى بولسۇن؛ لېكىن يەتتىنچى كۈنى سىلەرگە نىسبەتەن مۇقەددەس بىر كۈن بولۇپ، پەرۋەردىگارغا ئاتالغان ئارام ئالىدىغان شابات كۈنى بولسۇن. ھەركىم شۇ كۈنىدە ئىش-ئەمگەك قىلسا ئۆلۈمگە مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","شابات كۈنىدە بارلىق تۇرالغۇلىرىڭلاردا ھەرگىز ئوت قالىماڭلار، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","مۇسا ئىسرائىللارنىڭ پۈتكۈل جامائىتىگە سۆز قىلىپ مۇنداق دېدى: ــ «پەرۋەردىگار بۇيرۇغان ئەمر مانا شۇكى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ئۆزۈڭلارنىڭ ئاراڭلاردىن پەرۋەردىگارغا بىر «كۆتۈرمە ھەدىيە» كەلتۈرۈڭلار؛ كۆڭلى خالىغانلارنىڭ ھەربىرى پەرۋەردىگارغا بىر «كۆتۈرمە ھەدىيە»سىنى كەلتۈرسۇن: يەنى ئالتۇن، كۈمۈش، مىس، ");
INSERT INTO uigara_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","كۆك، سۆسۈن ۋە قىزىل يىپ، ئاق كاناپ رەخت، ئۆچكە تىۋىتى، ");
INSERT INTO uigara_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","قىزىل بويالغان قوچقار تېرىسى، دېلفىن تېرىسى، ئاكاتسىيە ياغىچى، ");
INSERT INTO uigara_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","چىراغدان ئۈچۈن زەيتۇن مېيى، «مەسىھلەش مېيى» بىلەن خۇشبۇي ئۈچۈن ئىشلىتىلىدىغان ئېسىل دورا-دەرمەكلەر، ");
INSERT INTO uigara_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ئەفودقا ھەم قوشېنغا ئورنىتىلىدىغان ھېقىق ۋە باشقا ياقۇتلارنى كەلتۈرۈڭلار». ");
INSERT INTO uigara_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ــ «ئاراڭلاردىكى بارلىق ماھىر ئۇستىلار كېلىپ پەرۋەردىگار بۇيرۇغاننىڭ ھەممىسىنى ياساپ بەرسۇن: ");
INSERT INTO uigara_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ــ مۇقەددەس چېدىر بىلەن ئۇنىڭ ئىچكى ۋە تاشقى يوپۇقلىرىنى، ئىلغۇلىرىنى، تاختايلىرىنى، بالداقلىرىنى، خادىلىرىنى ۋە بۇلارنىڭ تەگلىكلىرىنى، ");
INSERT INTO uigara_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ئەھدە ساندۇقى ۋە ئۇنىڭ بالداقلىرىنى، «كەفارەت تەختى»نى، «ئايرىما پەردە-يوپۇق»نى، ");
INSERT INTO uigara_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","شىرە ۋە ئۇنىڭ بالداقلىرىنى، ئۇنىڭ بارلىق قاچا-قۇچىلىرىنى ۋە «تەقدىم نانلىرى»نى، ");
INSERT INTO uigara_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","يورۇقلۇق ئۈچۈن ياسالغان چىراغدان ۋە ئۇنىڭ ئەسۋابلىرىنى، ئۇنىڭ چىراغلىرى ۋە چىراغ مېيىنى، ");
INSERT INTO uigara_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","خۇشبۇيگاھ ۋە ئۇنىڭ بالداقلىرىنى، «مەسىھلەش مېيى»نى، دورا-دەرمەكلەردىن ئىشلەنگەن خۇشبۇينى، مۇقەددەس چېدىرىنىڭ كىرىش ئېغىزىدىكى «ئىشىك پەردىسى»نى، ");
INSERT INTO uigara_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","كۆيدۈرمە قۇربانلىق قۇربانگاھى ۋە ئۇنىڭ مىس شالاسىنى، بالداقلىرىنى ۋە بارلىق ئەسۋابلىرىنى، يۇيۇنۇش دېسى ۋە ئۇنىڭ تەگلىكىنى، ");
INSERT INTO uigara_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ھويلىنىڭ پەردىلىرىنى، ئۇنىڭ خادىلىرى ۋە ئۇلارنىڭ تەگلىكلىرىنى، ھويلىنىڭ كىرىش ئېغىزىدىكى پەردىنى، ");
INSERT INTO uigara_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","چېدىرنىڭ مىخ-قوزۇقلىرىنى، ھويلىنىڭ مىخ-قوزۇقلىرىنى، شۇنداقلا بارلىق تانىلىرىنى، ");
INSERT INTO uigara_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","توقۇلىدىغان كىيىملەر، يەنى مۇقەددەس جاينىڭ خىزمىتىگە كاھىنلىق خىزمىتىدە كىيىلىدىغان، ھارۇن كاھىننىڭ مۇقەددەس كىيىملىرىنى ھەم ئۇنىڭ ئوغۇللىرىنىڭ كىيىملىرىنى تەييار قىلسۇن».    ");
INSERT INTO uigara_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","شۇنىڭ بىلەن پۈتكۈل ئىسرائىل جامائىتى مۇسانىڭ يېنىدىن چىقىپ كېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ئاندىن كۆڭلى تارتقانلارنىڭ ھەربىرى، روھى ئۆزلىرىگە تۈرتكە بولغانلارنىڭ ھەربىرى كېلىپ، جامائەت چېدىرىنى ياساشقا، شۇنداقلا چېدىرنىڭ خىزمىتىدە ئىشلىتىلىدىغان بارلىق سەرەمجانلارنى ياساشقا ۋە مۇقەددەس كىيىملەرنى تىكىشكە پەرۋەردىگارغا ئاتالغان «پۇلاڭلاتما ھەدىيە»نى كەلتۈرگىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ئۇلار ئەرلەرمۇ، ئاياللارمۇ كېلىپ، سۇنۇشقا كۆڭلى خۇش بولغانلارنىڭ ھەربىرى ھەدىيە كەلتۈرۈپ، بۇلاپكا، زىرە-ھالقا، ئۈزۈك، زۇننار-بىلەزۈك قاتارلىق ھەرخىل ئالتۇن بۇيۇملارنى ئېلىپ كەلدى؛ ئالتۇننى «كۆتۈرمە ھەدىيە» قىلىپ بېرەي دېگەنلەرنىڭ ھەربىرى ئۇنى پەرۋەردىگارغا سۇندى. ");
INSERT INTO uigara_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","كىمدە كۆك، سۆسۈن، قىزىل يىپ بىلەن ئاق كاناپ رەخت، ئۆچكە تىۋىتى، قىزىل بويالغان قوچقار تېرىسى ۋە دېلفىن تېرىسى بولسا، شۇلارنى ئېلىپ كېلىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","كۈمۈش يا مىستىن كۆتۈرمە ھەدىيە كەلتۈرەي دېگەنلەرنىڭ ھەربىرى شۇنى پەرۋەردىگارغا ھەدىيە قىلىپ سۇندى. كىمدە چېدىرنىڭ خىزمىتىدە ئىشلىتىلىدىغان ھەرخىل سەرەمجانلارغا يارىغۇدەك ئاكاتسىيە ياغىچى بولسا، ئۇنى ئېلىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","قولى چېۋەر ئاياللارنىڭ ھەربىرى ئۆز قوللىرى بىلەن ئېگىرىپ، شۇ ئېگىرگەن يىپ ۋە رەختلەرنى، يەنى كۆك، سۆسۈن ۋە قىزىل يىپ بىلەن ئاق كاناپ رەختلەرنى كەلتۈردى،    ");
INSERT INTO uigara_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","شۇنىڭدەك كۆڭلى قوزغالغان ئاياللارنىڭ ھەممىسى ھۈنىرىنى ئىشلىتىپ ئۆچكە تىۋىتىدىن يىپ ئېگىرىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ئەمىرلەر ئەفود ۋە قوشېنغا ئورنىتىلىدىغان ھېقىقلار ۋە ياقۇتلارنى، ");
INSERT INTO uigara_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","دورا-دەرمەكلەرنى، چىراغقا ۋە مەسىھلەش مېيىغا ئىشلىتىلىدىغان زەيتۇن مېيىنى، خۇشبۇيغا ئىشلىتىلىدىغان ئېسىل دورا-دەرمەكلەرنى كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","شۇ تەرىقىدە ئىسرائىللار پەرۋەردىگار مۇسانىڭ ۋاسىتىسى بىلەن بۇيرۇغان ئىشلارنىڭ ھەرقايسىغا بىر نەرسە بېرىشكە كۆڭلى تارتقان بولسا، ئەر بولسۇن ئايال بولسۇن ھەربىرى شۇنى ئېلىپ كېلىپ، پەرۋەردىگارغا ئاتاپ ئىختىيارىي ھەدىيە بەردى. ");
INSERT INTO uigara_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ئاندىن مۇسا ئىسرائىللارغا مۇنداق دېدى: ــ «مانا، پەرۋەردىگار يەھۇدا قەبىلىسىدىن خۇرنىڭ نەۋرىسى، ئۇرىنىڭ ئوغلى بەزالەلنى ئىسمىنى ئاتاپ چاقىرىپ،    ");
INSERT INTO uigara_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ئۇنى خۇدانىڭ روھى بىلەن تولدۇرۇپ، ئۇنىڭغا دانالىق، ئەقىل-پاراسەت، ئىلىم-ھېكمەت ئىگىلىتىپ، ئۇنى ھەرتۈرلۈك ئىشنى قىلىشقا قابىلىيەتلىك قىلىپ، ");
INSERT INTO uigara_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ئۇنى تۈرلۈك-تۈرلۈك ھۈنەرلەرنى قىلالايدىغان ــ ئالتۇن، كۈمۈش ۋە مىس ئىشلىرىنى قىلالايدىغان، ");
INSERT INTO uigara_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ياقۇتلارنى كېسىپ-ئويالايدىغان، زىننەت بۇيۇملىرىغا ئورنىتالايدىغان، ياغاچلارغا نەقىش چىقىرالايدىغان، ھەرخىل ھۈنەر ئىشلىرىنى قاملاشتۇرالايدىغان قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ئۇ يەنە ئۇنىڭ كۆڭلىگە، شۇنىڭدەك ھەم دان قەبىلىسىدىن بولغان ئاھىساماقنىڭ ئوغلى ئوھولىيابنىڭ كۆڭلىگە باشقىلارغا ھۈنەر ئۆگىتىش نىيەت-ئىستىكىنى سېلىپ، ");
INSERT INTO uigara_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ئۇلارنىڭ كۆڭۈللىرىنى دانالىق-ھېكمەت بىلەن تولدۇرۇپ، ئۇلارنى ھەرخىل نەققاشلىق-ئويمىچىلىق ئىشلىرىغا ماھىر قىلىپ، كۆك، سۆسۈن ۋە قىزىل يىپ بىلەن ئاق كاناپ رەخت بىلەن كەشتىچىلىك قىلىشقا ھەمدە باپكارلىققا ئىقتىدارلىق قىلدى. شۇنىڭ بىلەن ئۇلار ھەرخىل ھۈنەر ئىشلىرىنىڭ ۋە ھەرخىل لايىھىلەش ئىشلىرىنىڭ ھۆددىسىدىن چىقالايدىغان بولدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","شۇنىڭ بىلەن بەزالەل ۋە ئوھولىيابلار، شۇنىڭدەك پەرۋەردىگار مۇقەددەس چېدىر ياساشنىڭ ھەرخىل ئىشلىرىغا كېرەك بولغان دانالىق-ھېكمەت ۋە ئەقىل-پاراسەتنى ئاتا قىلغان ماھىر ئۇستىلارنىڭ ھەربىرى ئۇلارغا قوشۇلۇپ، شۇ ئىشنى ئۇنىڭ ئەمر قىلغىنى بويىچە ئەمەلگە ئاشۇرىدۇ». ");
INSERT INTO uigara_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","شۇ ۋاقىتتا مۇسا بەزالەل ۋە ئوھولىيابنى، شۇنداقلا پەرۋەردىگار دانالىق-ھېكمەت بىلەن كۆڭۈللىرىنى تولدۇرغان، كۆڭلى ئۆزىنى شۇ ئىشنى قىلىشقا قاتنىشىشقا دالالەت قىلغان بارلىق ھۈنەرۋەن-كاسىپلارنى چاقىرىپ يىغدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ئۇلار كېلىپ مۇقەددەس چېدىرنى ياساشقا، شۇنداقلا ئۇنىڭ ئىش-خىزمەتلىرىگە كېرەكلىك سەرەمجانلارنى ياساشقا ئىسرائىللار ئېلىپ كەلتۈرگەن بارلىق «كۆتۈرمە ھەدىيە»لەرنى مۇسادىن تاپشۇرۇۋالدى. ئىسرائىل خەلقى يەنىلا ئۆز مەيلى بىلەن ھەر كۈنى ئەتىگىنى مۇساغا ئىختىيارىي ھەدىيە كەلتۈرۈپ تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ئاندىن مۇقەددەس چېدىرنىڭ ئىشلىرىنى قىلىۋاتقان ئۇستىلارنىڭ ھەممىسى قولىدىكى ئىشىنى قويۇپ قويۇپ كېلىپ، ");
INSERT INTO uigara_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","مۇساغا: ــ خەلقنىڭ ئېلىپ كەلگىنى پەرۋەردىگار بىزگە قىلىشقا بۇيرۇغان ئىشنى پۈتكۈزۈشكە ئېھتىياج بولغىنىدىن كۆپ ئېشىپ كەتتى! ــ دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ئاندىن مۇسا ئەمر قىلىپ، پۈتكۈل چېدىرگاھ بويىچە: «مانا، ئەر بولسۇن، ئايال بولسۇن، ھېچكىم مۇقەددەس چېدىرنى ياساش ئۈچۈن «كۆتۈرمە ھەدىيە» سۈپىتىدە يەنە ھېچقانداق نەرسە تەييارلاپ كەلمىسۇن!» دەپ جاكارلاتتى. بۇنىڭ بىلەن كۆپچىلىك ھەدىيەلەر كەلتۈرۈشتىن توختىتىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","چۈنكى ئۇلار تەييارلىغان ماتېرىياللار پۈتكۈل قۇرۇلۇش ئىشىغا يېتەتتى، ھەتتا ئېشىپ قالاتتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","مۇقەددەس چېدىرنىڭ قۇرۇلۇش ئىشىنى قىلىۋاتقان ئۇستىلارنىڭ ھەربىرى نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ ئىشلەنگەن ئون پارچە يوپۇق ياساپ، كېرۇبلارنىڭ سۈرىتىنى يوپۇقلارغا چېۋەرلىك بىلەن لايىھىلەپ نەپىس قىلىپ كەشتىلەپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ھەربىر يوپۇقنىڭ ئۇزۇنلۇقى يىگىرمە سەككىز گەز، كەڭلىكى تۆت گەز بولۇپ، ھەربىر يوپۇق ئوخشاش چوڭ-كىچىكلىكتە قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","بەزالەل يوپۇقلارنىڭ بەشىنى بىر-بىرىگە ئۇلىدى، قالغان بەش يوپۇقنىمۇ ھەم بىر-بىرىگە ئۇلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ئۇ ئۇلاپ چىقىلغان بىرىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىنىڭ بىر تەرىپىگە رەڭگى كۆك ئىزمىلەرنى قادىدى، شۇنىڭدەك ئۇلاپ چىقىلغان ئىككىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكىسىنىڭ بىر تەرىپىگىمۇ شۇنداق قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","بىرىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا ئەللىك ئىزمە قادىدى، ئىككىنچى چوڭ پارچىنىڭ ئەڭ چېتىدىكىسىگىمۇ ئەللىك ئىزمە قادىدى. ئىزمىلەر بىر-بىرىگە ئۇدۇلمۇئۇدۇل قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","مۇقەددەس چېدىر بىر پۈتۈن بولسۇن ئۈچۈن ئۇ ئالتۇندىن ئەللىك ئىلغۇ ياساپ، ئىككى پارچە يوپۇقنى شۇ ئىلغۇلار بىلەن بىر-بىرىگە تۇتاشتۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ئۇ مۇقەددەس چېدىرنى يېپىش ئۈچۈن ئۆچكە تىۋىتىدىن يوپۇقلارنى ياسىدى؛ يوپۇقتىن ئون بىر پارچە ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","يوپۇقلارنىڭ ھەربىرىنىڭ ئۇزۇنلۇقى ئوتتۇز گەز، كەڭلىكى تۆت گەز بولۇپ، ئون بىر يوپۇقنىڭ ھەممىسى ئوخشاش چوڭ-كىچىكلىكتە قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","يوپۇقلارنىڭ بەشىنى ئۇ ئۇلاپ بىر قىلىپ، قالغان ئالتە يوپۇقنىمۇ ئۇلاپ بىر قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ئۇ بىرىنچى ئۇلاپ چىقىلغان چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا ئەللىك ئىزمە، ئىككىنچى ئۇلاپ چىقىلغان چوڭ پارچىنىڭ ئەڭ چېتىدىكى قىسمىغا ئەللىك ئىزمە قادىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ئۇ چېدىر بىر پۈتۈن بولسۇن ئۈچۈن ھەم مىستىن ئەللىك ئىلغۇ ياساپ، ئىككى چوڭ پارچىنى ئۇلاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ئۇ بۇنىڭدىن باشقا چېدىرغا قىزىل بويالغان قوچقار تېرىسىدىن يوپۇق ياساپ ياپتى، ئاندىن ئۇنىڭ ئۈستىدىنمۇ دېلفىن تېرىسىدىن ياسالغان يەنە بىر يوپۇقنى قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ئۇ مۇقەددەس چېدىرنىڭ تىك تاختايلىرىنى ئاكاتسىيە ياغىچىدىن ياساپ تىكلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ھەربىر تاختاينىڭ ئۇزۇنلۇقى ئون گەز، كەڭلىكى بىر يېرىم گەز قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ھەربىر تاختاينىڭ ئىككىدىن تۇرۇمى بار ئىدى، ھەر ئىككى تاختاي شۇلار بىلەن بىر-بىرىگە چېتىلدى؛ ئۇ چېدىرنىڭ بارلىق تاختايلىرىنى شۇنداق ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ئۇ چېدىرنىڭ تاختايلىرىنى شۇنداق ياسىدى؛ يىگىرمىسى جەنۇب تەرەپكە ئورنىتىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ئۇ بۇ يىگىرمە تاختاينىڭ تېگىگە كۈمۈشتىن قىرىق تەگلىك ياسىدى؛ بىر تاختاينىڭ ئاستىدىكى ئىككى تۇرۇمى ئۈچۈن ئىككىدىن تەگلىك، يەنە بىر تاختاينىڭ ئىككى تۇرۇمى ئۈچۈن ئىككىدىن تەگلىكنى ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","شۇنىڭدەك ئۇ چېدىرنىڭ ئۇدۇل تەرىپىگە، يەنى شىمال تەرىپىگە يىگىرمە تاختاي ياسىدى، ");
INSERT INTO uigara_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","شۇنداقلا بۇلارنىڭ قىرىق تەگلىكىنى كۈمۈشتىن ياسىدى؛ بىر تاختاينىڭ تېگىگە ئىككىدىن تەگلىك، يەنە بىر تاختاينىڭ تېگىگە ئىككىدىن تەگلىك ئورۇنلاشتۇرۇلدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","چېدىرنىڭ كەينى تەرىپىگە، يەنى غەرب تەرەپكە ئالتە تاختاينى ياساپ ئورناتتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ئۇ چېدىرنىڭ كەينى تەرىپىدىكى ئىككى بۇلۇڭغا ئىككى تاختاينى ياساپ ئورناتتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","بۇ بۇلۇڭ تاختايلىرى ئاستىدىن ئۈستىگىچە ئىككى قات قىلىپ تاختايلارنى ئۆزئارا چېتىشتۇردى، ئۈستى بىر ھالقىغا بېكىتىلدى. ئۇ ھەر ئىككىسىنى شۇنداق ياساپ، ئىككى بۇلۇڭغا ئورناتتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","شۇڭلاشقىمۇ ئۇ تەرىپىدە سەككىز تاختاي بولدى، ئۇلارنىڭ كۈمۈشتىن ياسالغان ئون ئالتە تەگلىكى بار ئىدى؛ بىر تاختاينىڭ تېگىدە ئىككى تەگلىك، يەنە بىر تاختاينىڭ تېگىدە ئىككى تەگلىك بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","بۇنىڭدىن باشقا ئۇ ئاكاتسىيە ياغىچىدىن بالداق ياسىدى؛ چېدىرنىڭ بۇ تەرىپىدىكى تاختايلارغا بەش بالداقنى، ");
INSERT INTO uigara_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","چېدىرنىڭ ئۇ تەرىپىدىكى تاختايلارغا بەش بالداقنى، چېدىرنىڭ ئارقا تەرىپىدىكى تاختايلارغا، يەنى غەرب تەرىپىدىكى تاختايلارغىمۇ بەش بالداقنى ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ئۇ تاختايلارنىڭ ئوتتۇرىدىكى ئوتتۇرا بالداقنى بۇ تەرەپتىن ئۇ تەرەپكە يەتكۈزۈپ ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ئۇ تاختايلارنى ئالتۇن بىلەن قاپلاپ، بالداقلار ئۆتكۈزۈلىدىغان ھالقىلارنى ئالتۇندىن ياساپ، بالداقلارنى ئالتۇن بىلەن قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ئۇ نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ ئىشلەنگەن بىر پەردە ياسىدى؛ ئۇنى كېرۇبلارنىڭ سۈرىتىنى چېۋەرلىك بىلەن لايىھىلەپ نەپىس قىلىپ چۈشۈرۈپ، كەشتىلەپ چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ئۇنى ئېسىشقا ئۇ ئاكاتسىيە ياغىچىدىن تۆت خادا ياساپ، ئالتۇن بىلەن قاپلىدى. ئۇلارنىڭ ئىلمەكلىرى ئالتۇندىن ياسالدى؛ خادىلارغا ئۇ كۈمۈشتىن تۆت تەگلىكنى قۇيۇپ ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ئۇ چېدىرنىڭ كىرىش ئېغىزىغا نەپىس توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ ئىشلەنگەن بىر پەردە ياسىدى، ئۇنى كەشتىچىگە كەشتىلەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ئۇ يەنە بۇ پەردىنىڭ بەش خادىسىنى ئىلمەكلىرى بىلەن قوشۇپ ياسىدى؛ ئۇلارنىڭ باشلىرىنى ۋە بالداقلىرىنى ئالتۇن بىلەن قاپلىدى؛ ئۇلارنىڭ بەش تەگلىكى مىستىن ياسالدى.    ");
INSERT INTO uigara_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ئاندىن بەزالەل ئەھدە ساندۇقىنى ئاكاتسىيە ياغىچىدىن ياسىدى؛ ئۇنىڭ ئۇزۇنلۇقى ئىككى يېرىم گەز، ئېگىزلىكى بىر يېرىم گەز، كەڭلىكى بىر يېرىم گەز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ئۇ ئۇنىڭ ئىچى ۋە سىرتىنى ساپ ئالتۇن بىلەن قاپلىدى، ئۇنىڭ ئۈستۈنكى قىسمىنىڭ چۆرىسىگە ئالتۇندىن گىرۋەك چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ئۇ ئۇنىڭ ئۈچۈن ئالتۇندىن تۆت ھالقا قۇيۇپ، ئۇلارنى ئۇنىڭ تۆت چېتىقىغا بېكىتتى؛ بىر تەرىپىگە ئىككى ھالقا، يەنە بىر تەرىپىگە ئىككى ھالقا بېكىتتى. ");
INSERT INTO uigara_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ئۇ ھەم ئاكاتسىيە ياغىچىدىن ئىككى بالداق ياساپ، ھەر ئىككىسىنى ئالتۇن بىلەن قاپلىدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ئاندىن ساندۇق ئۇلار ئارقىلىق كۆتۈرۈلسۇن دەپ، بالداقلارنى ساندۇقنىڭ ئىككى يېنىدىكى ھالقىلىرىدىن ئۆتكۈزۈپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ئۇ ساندۇقنىڭ ياپقۇچى سۈپىتىدە ئالتۇندىن ئۇزۇنلۇقى ئىككى يېرىم گەز، كەڭلىكى بىر يېرىم گەز بولغان بىر «كەفارەت تەختى» ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ئۇ ئىككى كېرۇبنى ئالتۇندىن سوقۇپ ياسىدى؛ ئۇلارنى كەفارەت تەختىنىڭ ئىككى تەرىپىگە ئورناتتى؛ ");
INSERT INTO uigara_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","بىر كېرۇبنى بىر تەرىپىگە، يەنە بىر كېرۇبنى يەنە بىر تەرىپىگە ئورناتتى. ئۇ ئىككى تەرىپىدىكى كېرۇبلارنى كەفارەت تەختى بىلەن بىر گەۋدە قىلدى.    ");
INSERT INTO uigara_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","كېرۇبلار بىر-بىرىگە يۈزلىنىپ، قاناتلىرىنى كەفارەت تەختىنىڭ ئۈستىگە كېرىپ، قاناتلىرى بىلەن ئۇنى يېپىپ تۇراتتى؛ كېرۇبلارنىڭ يۈزى كەفارەت تەختىگە قارىتىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ئۇ ھەم شىرەنى ئاكاتسىيە ياغىچىدىن ياسىدى؛ ئۇنىڭ ئۇزۇنلۇقى ئىككى گەز، كەڭلىكى بىر گەز، ئېگىزلىكى بىر يېرىم گەز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ئۇ ئۇنى ساپ ئالتۇن بىلەن قاپلاپ، ئۇنىڭ ئۈستۈنكى قىسمىنىڭ چۆرىسىگە ئالتۇندىن گىرۋەك چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ئۇ شىرەنىڭ چۆرىسىگە تۆت ئىلىك ئېگىزلىكتە بىر لەۋ ياسىدى؛ بۇ لەۋنىڭ چۆرىسىگىمۇ ئالتۇندىن بىر گىرۋەك چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ئۇ شىرەگە ئالتۇندىن تۆت ھالقا ياساپ، بۇ ھالقىلارنى شىرەنىڭ تۆت بۇرجىكىدىكى چېتىققا ئورناتتى. ");
INSERT INTO uigara_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","شىرەنى كۆتۈرۈشكە بالداقلار ئۆتكۈزۈلسۇن دەپ، ھالقىلار شىرە لېۋىگە يېقىن بېكىتىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","شىرە ئۈچۈن ئۇ بالداقلارنى ئاكاتسىيە ياغىچىدىن ياساپ، ئالتۇن بىلەن قاپلىدى؛ شىرە ئۇلار بىلەن كۆتۈرۈلەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ئۇ شىرەنىڭ ئۈستىگە قويۇلىدىغان بارلىق بۇيۇملارنى، يەنى لېگەنلىرىنى، قاچا-قۇچا تەخسىلىرىنى، شاراب ھەدىيەلىرىنى قۇيىدىغان قەدەھ ۋە پىيالىلەرنىڭ ھەممىسىنى ساپ ئالتۇندىن ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ئۇ ھەم چىراغداننى ساپ ئالتۇندىن ياسىدى؛ چىراغداننى سوقۇپ ياسىدى؛ چىراغداننىڭ پۇتى، غولى، قەدەھلىرى، غۇنچىلىرى ۋە گۈللىرى بىر پۈتۈن ئالتۇندىن سوقۇلدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","چىراغداننىڭ غولىنىڭ ئىككى يېنىدىن ئالتە شاخچە چىقىرىلدى ــ چىراغداننىڭ بىر يېنىدىن ئۈچ شاخچە، ئۇنىڭ يەنە بىر يېنىدىن ئۈچ شاخچە چىقىرىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","بىر يېنىدىكى ھەربىر شاخچىدە بادام گۈلى شەكلىدە غۇنچىسى ۋە چېچىكى بولغان ئۈچ قەدەھ چىقىرىلدى، يەنە بىر يېنىدىكى ھەربىر شاخچىدە بادام گۈلى شەكلىدە غۇنچىسى ۋە چېچىكى بولغان ئۈچ قەدەھ چىقىرىلدى. چىراغدانغا چىقىرىلغان ئالتە شاخچىنىڭ ھەممىسى شۇنداق ياسالدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","چىراغداننىڭ غولىدىن بادام گۈلى شەكلىدە غۇنچىسى ۋە چېچىكى بولغان تۆت قەدەھ چىقىرىلدى.    ");
INSERT INTO uigara_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","بۇلاردىن باشقا بىرىنچى ئىككى شاخچىنىڭ ئاستىدا بىر غۇنچە، ئىككىنچى ئىككى شاخچىنىڭ ئاستىدا بىر غۇنچە، ئۈچىنچى ئىككى شاخچىنىڭ ئاستىدا بىر غۇنچە ياسالغانىدى؛ چىراغدانغا چىقىرىلغان ئالتە شاخچىنىڭ ئاستىنىڭ ھەممىسى شۇنداق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ئۇنىڭ شۇ غۇنچىلىرى ھەم شاخچىلىرى چىراغدان بىلەن بىر گەۋدە قىلىندى ــ بىر پۈتۈن ساپ ئالتۇندىن سوقۇپ ياسالدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ئۇ چىراغداننىڭ يەتتە چىرىغىنى، شۇنداقلا ئۇنىڭ پىلىك قايچىلىرى بىلەن كۈلدانلىرىنى ساپ ئالتۇندىن ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ئۇ چىراغدان ۋە ئۇنىڭ بارلىق ئەسۋابلىرىنى بىر تالانت ساپ ئالتۇندىن ياسىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ئۇ يەنە خۇشبۇيگاھنى ئاكاتسىيە ياغىچىدىن ياسىدى. ئۇنىڭ ئۇزۇنلۇقى بىر گەز، كەڭلىكى بىر گەز، ئېگىزلىكى ئىككى گەز بولۇپ، تۆت چاسا قىلىپ ياسالدى؛ تۆت بۇرجىكىدىكى مۈڭگۈزلەر ئۇنىڭ بىلەن بىر پۈتۈن قىلىپ ياسالدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ئۇ ئۇنى، يەنى ئۇنىڭ ئۈستىنى، تۆت ئەتراپىنى ھەم مۈڭگۈزلىرىنى ساپ ئالتۇن بىلەن قاپلىدى؛ ئۇنىڭ ئۈستى قىسمىنىڭ چۆرىسىگە ئالتۇندىن گىرۋەك چىقاردى. ");
INSERT INTO uigara_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ئۇنىڭغا ئالتۇندىن ئىككى ھالقا ياساپ، ئۇنىڭ گىرۋىكىنىڭ ئاستىغا بېكىتتى؛ ئۇلارنى ئىككى يېنىغا ئۇدۇلمۇئۇدۇل بېكىتتى. خۇشبۇيگاھنى كۆتۈرىدىغان ئىككى بالداقنى سېلىش ئۈچۈن بۇلارنى خۇشبۇيگاھنىڭ ئىككى تەرىپىگە ئورۇنلاشتۇردى.    ");
INSERT INTO uigara_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ئۇ بالداقلارنى ئاكاتسىيە ياغىچىدىن ياساپ، ئالتۇن بىلەن قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ئۇ ھەم مۇقەددەس مەسىھلەش مېيىنى ياسىدى، ئاندىن ئەتىرچى چىقارغاندەك دورا-دەرمەكلەرنى تەڭشەپ ساپ خۇشبۇينى ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ئۇ كۆيدۈرمە قۇربانلىق قۇربانگاھىنى ئاكاتسىيە ياغىچىدىن ياسىدى. قۇربانگاھ تۆت چاسا بولۇپ، ئۇزۇنلۇقى بەش گەز، كەڭلىكى بەش گەز، ئېگىزلىكى ئۈچ گەز قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ئۇ ئۇنىڭ تۆت بۇرجىكىگە قويۇلىدىغان مۈڭگۈزلىرىنى ياسىدى؛ مۈڭگۈزلىرى قۇربانگاھ بىلەن بىر گەۋدە قىلىندى. قۇربانگاھنى مىس بىلەن قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ئۇ قۇربانگاھنىڭ بارلىق ئەسۋابلىرىنى ــ ئۇنىڭغا خاس بولغان داسلارنى، گۈرجەكلەرنى، كورىلارنى، لاخشىگىرلارنى ۋە ئوتدانلارنىمۇ ياسىدى؛ ئۇنىڭ بارلىق ئەسۋابلىرىنى مىستىن ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","قۇربانگاھ ئۈچۈن مىستىن بىر شالا ياسىدى؛ شالانى قۇربانگاھنىڭ قاپ بېلىنىڭ ئاستىدىكى گىرۋەكتىن تۆۋەنرەك تۇرىدىغان قىلدى؛ شالا قۇربانگاھنىڭ دەل ئوتتۇرىسىدا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ئۇ شالانىڭ تۆت بۇرجىكىگە بالداقلار ئۆتكۈزۈلىدىغان تۆت مىس ھالقىنى قۇيۇپ ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ئۇ بالداقلارنى ئاكاتسىيە ياغىچىدىن ياساپ، ئۇلارنى مىس بىلەن قاپلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ئاندىن ئۇ قۇربانگاھنى كۆتۈرۈش ئۈچۈن بالداقلارنى قۇربانگاھنىڭ ئىككى يېنىدىكى ھالقىلارغا ئۆتكۈزۈپ قويدى. ئۇ قۇربانگاھنى تاختايلاردىن، ئىچىنى بوش قىلىپ ياسىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ئۇ يەنە يۇيۇنۇش دېسىنى مىستىن، ئۇنىڭ تەگلىكىنىمۇ مىستىن ياسىدى؛ ئۇ بۇلارنى «كۆرۈشۈش چېدىرى»نىڭ كىرىش ئېغىزىنىڭ ئالدىدا خىزمەتتە بولغان ئاياللارنىڭ مىس ئەينەكلىرىدىن ياسىدى.    ");
INSERT INTO uigara_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ئاندىن ئۇ چېدىرنىڭ ھويلىسىنىمۇ ياسىدى. ھويلىنىڭ جەنۇبىغا، يەنى جەنۇبقا يۈزلەنگەن تەرىپىگە نېپىز توقۇلغان ئاق كاناپ رەختتىن پەردىلەرنى ياسىدى؛ ئۇنىڭ ئۇزۇنلۇقى يۈز گەز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","پەردىلەرنى ئېسىشقا يىگىرمە خادا ۋە خادىلارنىڭ يىگىرمە تەگلىكىنى ئۇ مىستىن ياسىدى. خادىلارنىڭ ئىلمەكلىرى ۋە بالداقلىرى كۈمۈشتىن ياسالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","شۇنىڭغا ئوخشاش شىمال تەرىپىدىمۇ ئۇزۇنلۇقى يۈز گەز كېلىدىغان پەردە بار ئىدى. پەردىلەرنى ئېسىشقا يىگىرمە خادا ۋە خادىلارنىڭ يىگىرمە تەگلىكىنى ئۇ مىستىن ياسىدى. خادىلارنىڭ ئىلمەكلىرى ۋە بالداقلىرى كۈمۈشتىن ياسالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","شۇنىڭغا ئوخشاش غەرب تەرىپىدە ئۇزۇنلۇقى ئەللىك گەز كېلىدىغان پەردە بار ئىدى؛ پەردىلەرنى ئېسىشقا ئون خادا ۋە خادىلارنىڭ ئون تەگلىكىنى ئۇ مىستىن ياسىدى. خادىلارنىڭ ئىلمەكلىرى ۋە بالداقلىرى كۈمۈشتىن ياسالدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ھويلىنىڭ شەرق تەرىپى، يەنى كۈن چىقىشقا يۈزلەنگەن تەرىپىنىڭ كەڭلىكى ئەللىك گەز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","بىر تەرىپىدە ئون بەش گەز كېلىدىغان پەردە بولۇپ، ئۇنىڭ ئۈچ خادىسى بىلەن ئۈچ تەگلىكى بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","يەنە بىر تەرىپىدىمۇ ئون بەش گەز كېلىدىغان پەردە بولۇپ، ئۇنىڭ ئۈچ خادىسى بىلەن ئۈچ تەگلىكى بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ھويلىنىڭ چۆرىسىدىكى پەردىلەرنىڭ ھەممىسى نېپىز توقۇلغان ئاق كاناپ رەختتىن تىكىلگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ھويلىنىڭ چۆرىسىدىكى ھەممە خادىلارنىڭ تەگلىكى مىستىن، ئۇلارنىڭ ئىلمەكلىرى ۋە بالداقلىرى كۈمۈشتىن ياسالدى؛ خادىلارنىڭ باشلىرىمۇ كۈمۈشتىن قاپلانغانىدى. ھويلىنىڭ چۆرىسىدىكى ھەممە خادىلار كۈمۈشتىن ياسالغان بالداقلار بىلەن بىر-بىرىگە چېتىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ھويلىنىڭ كىرىش ئېغىزىدىكى پەردە نېپىز توقۇلغان ئاق كاناپ رەختكە كۆك، سۆسۈن ۋە قىزىل يىپلار ئارىلاشتۇرۇلۇپ، كەشتىچىلەر تەرىپىدىن كەشتىلەندى؛ ئۇنىڭ ئۇزۇنلۇقى يىگىرمە گەز، ئېگىزلىكى ھويلىدىكى پەردىلەرنىڭ ئېگىزلىكىگە ئوخشاش بولۇپ بەش گەز ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ئۇنىڭ تۆت خادىسى بىلەن مىستىن ياسالغان تۆت تەگلىكى بار ئىدى؛ خادىلارنىڭ ئىلمەكلىرى كۈمۈشتىن ياسالدى، ئۇلارنىڭ باشلىرى كۈمۈش بىلەن قاپلاندى ۋە بالداقلىرى كۈمۈشتىن ياسالدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","مۇقەددەس چېدىرنىڭ ھەم چۆرىسىدىكى ھويلىنىڭ بارلىق مىق-قوزۇقلىرى مىستىن ياسالدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","مۇقەددەس چېدىر، يەنى «ھۆكۈم-گۇۋاھلىقى چېدىرى» ئۈچۈن ئاتالغان ماتېرىياللارنىڭ سانى تۆۋەندە خاتىرىلەنگەن (ئۇلار مۇسانىڭ بۇيرۇقى بىلەن، كاھىن ھارۇننىڭ ئوغلى ئىتامارنىڭ قول ئاستىدىكى لاۋىيلار مەسئۇل بولۇپ ساناقتىن ئۆتكۈزۈلۈپ، خۇداغا ئاتالغانىدى): ــ ");
INSERT INTO uigara_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","يەھۇدا قەبىلىسىدىن بولغان خۇرنىڭ نەۋرىسى، ئۇرىنىڭ ئوغلى بەزالەل پەرۋەردىگار مۇساغا بۇيرۇغاننىڭ ھەممىسىنى ئادا قىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","دان قەبىلىسىدىن بولغان ئاھىساماقنىڭ ئوغلى ئوھولىياب ئۇنىڭ ياردەمچىسى ئىدى؛ ئۇ بولسا نەققاشلىق-ئويمىچىلىق ئۇستىسى، لايىھىلىگۈچى ھەمدە كۆك، سۆسۈن، قىزىل يىپتىن ئاق كاناپ رەختكە كەشتە تىكەلەيدىغان ئۇستا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","مۇقەددەس چېدىرنى ياساشقا ئىشلىتىلگەن ئالتۇن، يەنى «پۇلاڭلاتما ھەدىيە» سۈپىتىدە كەلتۈرۈلگەن ئالتۇننىڭ ھەممىسى مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە يىگىرمە توققۇز تالانت يەتتە يۈز ئوتتۇز شەكەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","جامائەت ئارىسىدىن ساناقتىن ئۆتكۈزۈلگەن ئادەملەر تەرىپىدىن كەلتۈرۈلگەن كۈمۈش بولسا مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە بىر يۈز تالانت بىر مىڭ يەتتە يۈز يەتمىش بەش شەكەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","بۇ كۈمۈش نوپۇسى رويخەتكە ئېلىنغان كىشىلەردىن ئېلىنغانىدى ــ دېمەك، كىمكى يىگىرمە ياش يا ئۇنىڭدىن چوڭ، ساناقتىن ئۆتكۈزۈلگەنلەرنىڭ ھەربىرى بىر بېكا، يەنى مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە يېرىم شەكەل كۈمۈش بەردى. ساناقتىن ئۆتكەن كىشى ئالتە يۈز ئۈچ مىڭ بەش يۈز ئەللىك كىشى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","مۇقەددەس جاينىڭ تەگلىكلىرىنى ھەم ئوتتۇرىسىدىكى پەردىنىڭ تەگلىكلىرىنى قۇيۇشقا يۈز تالانت كۈمۈش كەتتى؛ يۈز تالانت كۈمۈشتىن يۈز تەگلىك ياسىلىپ، ھەربىر تەگلىك ئۈچۈن بىر تالانت ئىشلىتىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ئۇ قالغان بىر مىڭ يەتتە يۈز يەتمىش بەش شەكەل كۈمۈشتىن خادىلارنىڭ ئىلمەكلىرىنى ياسىدى، ئۇلارنىڭ باشلىرىنى قاپلىدى، شۇنىڭدەك ئۇلارنى بىر-بىرىگە چاتىدىغان بالداقلارنى ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","«پۇلاڭلاتما ھەدىيە» سۈپىتىدە كەلتۈرۈلگەن مىس بولسا يەتمىش تالانت، ئىككى مىڭ تۆت يۈز شەكەل چىقتى. ");
INSERT INTO uigara_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","بۇنىڭدىن ئۇ جامائەت چېدىرىنىڭ كىرىش ئېغىزىنىڭ تەگلىكلىرىنى، مىس قۇربانگاھنى، ئۇنىڭ مىس شالاسى ۋە قۇربانگاھنىڭ بارلىق ئەسۋابلىرىنى، ");
INSERT INTO uigara_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ھويلىنىڭ چۆرىسىدىكى خادا تەگلىكلىرىنى، ھويلىنىڭ كىرىش ئېغىزىدىكى تەگلىكلەرنى، چېدىرنىڭ بارلىق قوزۇقلىرىنى ۋە ھويلىنىڭ چۆرىسىدىكى قوزۇقلارنىڭ ھەممىسىنى ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","پەرۋەردىگار مۇساغا بۇيرۇغىنىدەك كۆك، سۆسۈن ۋە قىزىل يىپلار ئىشلىتىلىپ، مۇقەددەس چېدىرنىڭ خىزمىتىدە كىيىلىدىغان كاھىنلىق كىيىملەر، شۇنداقلا ھارۇننىڭ مۇقەددەس كىيىملىرى تەييار قىلىندى.    ");
INSERT INTO uigara_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","بەزالەل ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار بىلەن نېپىز توقۇلغان ئاق كاناپ رەختلەردىن ئەفودنى ياساپ تەييارلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ئۇلار ئالتۇننى سوقۇپ نېپىز قىلىپ، ئۇنى كېسىپ يىپ قىلدى، ئاندىن بۇلارنى ماھىرلىق بىلەن كۆك يىپلار، سۆسۈن يىپلار ۋە قىزىل يىپلاردىن ئاق كاناپ رەختكە لاھايىلەنگەن نۇسخىلار ئۈستىگە توقۇدى.    ");
INSERT INTO uigara_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ئۇلار ئەفودنىڭ ئالدى ۋە كەينى قىسمىنى بىر-بىرگە تۇتاشتۇرۇپ تۇرىدىغان ئىككى مۈرىلىك تاسما ياسىدى؛ ئەفودنىڭ ئىككى تەرىپى بىر-بىرىگە تۇتاشتۇرۇلدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ئەفودنىڭ ئۈستىگە باغلايدىغان بەلۋاغ ئەفود بىلەن بىر پۈتۈن قىلىنغان بولۇپ، ئۇنىڭغا ئوخشاش سىپتا ئىشلىنىپ، ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار ۋە نېپىز توقۇلغان ئاق كاناپ رەختتىن ياسالدى؛ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ئۇلار ئىككى ئاق ھېقىقنى ئىككى ئالتۇن كۆزلۈككە ئورنىتىپ، ئۇلارنىڭ ئۈستىگە خۇددى مۆھۈر ئويغاندەك ئىسرائىلنىڭ ئوغۇللىرىنىڭ ناملىرىنى ئويۇپ ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ئىسرائىلنىڭ ئوغۇللىرىغا ئەسلەتمە تاش بولسۇن ئۈچۈن، پەرۋەردىگار مۇساغا بۇيرۇغاندەك ئىككى ياقۇتنى ئەفودنىڭ ئىككى مۈرىلىك تاسمىسىغا بېكىتىپ قويدى.    ");
INSERT INTO uigara_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ئۇ قوشېننى چېۋەر قوللارغا نەپىس قىلىپ كەشتىلىتىپ ياسىدى؛ ئۇنى ئەفودنى ئىشلىگەن ئۇسۇلدا ئالتۇن ۋە كۆك، سۆسۈن، قىزىل يىپلار بىلەن نېپىز توقۇلغان ئاق كاناپ رەختتىن ياسىدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ئۇلار قوشېننى ئىككى قات، تۆت چاسا قىلىپ ياسىدى؛ ئىككى قات قىلىنغاندا ئۇزۇنلۇقى بىر غېرىچ، كەڭلىكىمۇ بىر غېرىچ كېلەتتى. ");
INSERT INTO uigara_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ئۇنىڭ ئۈستىگە تۆت قاتار قىلىپ گۆھەرلەرنى ئورناتتى: ــ بىر قاتاردىكىسى قىزىل ياقۇت، سېرىق گۆھەر ۋە زۇمرەتلەر ئىدى؛ بۇ بىرىنچى قاتار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ئىككىنچى قاتارغا كۆك قاشتېشى، كۆك ياقۇت ۋە ئالماس، ");
INSERT INTO uigara_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ئۈچىنچى قاتارغا سۆسۈن ياقۇت، پىروزا ۋە سۆسۈن كۋارتس، ");
INSERT INTO uigara_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","تۆتىنچى قاتارغا بېرىل ياقۇت، ئاق ھېقىق ۋە ئانارتاش ئورنىتىلدى؛ بۇلارنىڭ ھەممىسى ئالتۇن كۆزلۈككە بېكىتىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","بۇ گۆھەرلەر ئىسرائىلنىڭ ئوغۇللىرىنىڭ ناملىرىغا ۋەكىل قىلىنىپ، ئۇلارنىڭ سانىدەك ئون ئىككى بولۇپ، مۆھۈر ئويغاندەك ھەربىر گۆھەرگە ئون ئىككى قەبىلىنىڭ نامى بىردىن-بىردىن پۈتۈلدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ئۇلار قوشېنغا شوينىدەك ئېشىلگەن ساپ ئالتۇندىن ئىككى ئېشىلمە زەنجىر ياسىدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ئۇلار قوشېنغا ئالتۇندىن ئىككى كۆزلۈك ۋە ئىككى ھالقا ئېتىپ، ئىككى ھالقىنى قوشېننىڭ يۇقىرىقى ئىككى بۇرجىكىگە بېكىتتى؛ ");
INSERT INTO uigara_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ئاندىن شۇ ئالتۇندىن ئېشىلىپ ياسالغان ئىككى زەنجىرنى قوشېننىڭ يۇقىرىقى ئىككى بۇرجىكىدىكى ھالقىدىن ئۆتكۈزۈپ، ");
INSERT INTO uigara_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ئېشىلگەن شۇ زەنجىرلەرنىڭ ئىككى ئۇچىنى ئىككى كۆزلۈككە بېكىتىپ، كۆزلۈكلەرنى ئەفودنىڭ ئىككى مۈرىلىك تاسمىسىنىڭ ئالدى قىسمىغا ئورناتتى. ");
INSERT INTO uigara_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","بۇنىڭدىن باشقا ئۇلار ئالتۇندىن ئىككى ھالقا ياساپ، ئۇلارنى قوشېننىڭ ئاستى تەرىپىدىكى ئىككى بۇرجىكىگە بېكىتتى؛ ئۇلار ئەفودقا تېگىشىپ تۇرىدىغان قىلىنىپ ئىچىگە قادالدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","مۇندىن باشقا ئۇلار ئالتۇندىن يەنە ئىككى ھالقا ياساپ، ئۇلارنى ئەفودنىڭ ئىككى مۈرىلىك تاسمىسىنىڭ ئالدى تۆۋەنكى قىسمىغا، ئەفودقا ئۇلىنىدىغان جايغا يېقىن، كەشىتىلەنگەن بەلۋاغدىن ئېگىزرەك قىلىپ بېكىتتى. ");
INSERT INTO uigara_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ئۇلار قوشېننىڭ ئەفودنىڭ بەلۋېغىدىن يۇقىرىراق تۇرۇشى، قوشېننىڭ ئەفودتىن ئاجراپ كەتمەسلىكى ئۈچۈن كۆك شوينا بىلەن قوشېننىڭ ھالقىسىنى ئەفودنىڭ ھالقىسىغا چېتىپ قويدى. بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","بەزالەل ئەفودنىڭ ئىچىدىكى توننى پۈتۈنلەي كۆك رەڭلىك قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","توننىڭ باشقا كىيىلىدىغان تۆشۈكى دەل ئوتتۇرىسىدا، خۇددى ساۋۇتنىڭ ياقىسىدەك ئىشلەنگەنىدى؛ يىرتىلىپ كەتمەسلىكى ئۈچۈن ئۇنىڭ چۆرىسىگە پەۋاز ئىشلەندى. ");
INSERT INTO uigara_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ئۇلار توننىڭ ئېتىكىنىڭ چۆرىسىگە كۆك، سۆسۈن ۋە قىزىل يىپتىن ئانارلارنى توقۇپ ئېسىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ئۇلار ھەمدە ئالتۇن قوڭغۇراقلارنى ياساپ، قوڭغۇراقلارنى توننىڭ ئېتىكىنىڭ چۆرىسىگە، ئانارلارنىڭ ئارىلىقىغا بىردىن ئېسىپ قويدى؛ ھەر ئىككى ئانارنىڭ ئوتتۇرىسىغا بىر قوڭغۇراق ئېسىپ قويۇلدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","كاھىنلىق خىزمىتىگە ئائىت قوڭغۇراقلار توننىڭ ئېتىكىنىڭ چۆرىسىگە بېكىتىلدى؛ بىر ئالتۇن قوڭغۇراق، بىر ئانار، بىر ئالتۇن قوڭغۇراق، بىر ئانار قىلىپ بېكىتىلدى؛ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ئۇلار ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا نېپىز توقۇلغان ئاق كاناپ رەختتىن خالتا كۆڭلەكلەرنى تىكتى؛ ");
INSERT INTO uigara_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","سەللىنى ئاق كاناپ رەختتە ياسىدى، شۇنداقلا چىرايلىق ئېگىز بۆكلەرنى ئاق كاناپ رەختتە، تامباللارنى نېپىز توقۇلغان ئاق كاناپ رەختتە تەييارلىدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","بۇنىڭدىن باشقا ئۇلار بەلۋاغنىمۇ كۆك، سۆسۈن ۋە قىزىل يىپ ئارىلاشتۇرۇلۇپ كەشتىلەنگەن، نېپىز توقۇلغان ئاق كاناپ رەختتە تەييارلىدى؛ بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ئۇلار يەنە نەپىس تاختاينى، يەنى مۇقەددەس ئوتۇغاتنى ساپ ئالتۇندىن ياساپ، ئۇنىڭ ئۈستىگە مۆھۈر ئويغاندەك: «پەرۋەردىگارغا مۇقەددەس قىلىندى» دەپ ئويۇپ پۈتتى؛ ");
INSERT INTO uigara_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ئۇلار ئوتۇغاتقا كۆك رەڭلىك يىپنى باغلاپ، ئۇنىڭ بىلەن ئوتۇغاتنى سەللىگە تاقىدى، بۇلار پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","شۇ تەرىقىدە جامائەتنىڭ ئىبادەت چېدىرىنىڭ ھەممە قۇرۇلۇشى پۈتكۈزۈلدى؛ ئىسرائىللار پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىنىڭ ھەممىسىنى شۇ بويىچە قىلدى؛ شۇ تەرىقىدە ھەممىسىنى پۈتتۈردى. ");
INSERT INTO uigara_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ئۇلار چېدىرنى مۇسانىڭ يېنىغا ئېلىپ كەلدى ــ چېدىر يوپۇقلىرىنى، ئۇنىڭ بارلىق ئەسۋابلىرىنى، ئىلمەكلىرىنى، تاختايلىرىنى، بالداقلىرىنى، خادىلىرى بىلەن تەگلىكلىرىنى، ");
INSERT INTO uigara_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","شۇنىڭدەك قىزىل بويالغان قوچقار تېرىسىدىن ياسالغان يوپۇق بىلەن دېلفىن تېرىسىدىن ياسالغان يوپۇقنى، «ئايرىما پەردە»نى، ");
INSERT INTO uigara_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ئەھدە ساندۇقى ۋە ئۇنىڭ بالداقلىرىنى، «كەفارەت تەختى»نى، ");
INSERT INTO uigara_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","شىرە ۋە ئۇنىڭ بارلىق ئەسۋابلىرىنى، شۇنداقلا «تەقدىم نانلار»نى، ");
INSERT INTO uigara_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ساپ ئالتۇندىن ياسالغان چىراغدان بىلەن ئۇنىڭ چىراغلىرىنى، يەنى ئۈستىگە تىزىلغان چىراغلارنى، ئۇنىڭ بارلىق ئەسۋابلىرى ھەم چىراغ مېيىنى، ");
INSERT INTO uigara_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ئالتۇن خۇشبۇيگاھ، مەسىھلەش مېيى، دورا-دەرمەكلەردىن ياسالغان خۇشبۇينى، چېدىرنىڭ كىرىش ئېغىزىنىڭ پەردىسىنى، ");
INSERT INTO uigara_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","مىس قۇربانگاھ بىلەن ئۇنىڭ مىس شالاسىنى، ئۇنىڭ بالداقلىرى بىلەن ھەممە ئەسۋابلىرىنى، يۇيۇش دېسى بىلەن ئۇنىڭ تەگلىكىنى، ");
INSERT INTO uigara_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ھويلىنىڭ چۆرىسىدىكى پەردىلەرنى، ئۇنىڭ خادىلىرى ۋە ئۇلارنىڭ تەگلىكلىرىنى، ھويلىنىڭ كىرىش ئېغىزىنىڭ پەردىسى بىلەن ھويلىنىڭ تانىلىرى ۋە قوزۇقلىرىنى، مۇقەددەس چېدىرنىڭ، يەنى جامائەت چېدىرىغا ئائىت خىزمەتكە ئىشلىتىلىدىغان بارلىق ئەسۋابلارنى، ");
INSERT INTO uigara_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","مۇقەددەس جايغا ئائىت خىزمەت ئۈچۈن تىكىلگەن كاھىنلىق كىيىمىنى، يەنى ھارۇن كاھىننىڭ مۇقەددەس كىيىملىرى بىلەن ئۇنىڭ ئوغۇللىرىنىڭ كاھىنلىق كىيىملىرىنى بولسا، ھەممىسىنى ئېلىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","بۇ ئىشلارنىڭ ھەممىسىنى ئىسرائىللار پەرۋەردىگارنىڭ مۇساغا بارلىق بۇيرۇغانلىرى بويىچە ئەنە شۇنداق ئادا قىلغانىدى. ");
INSERT INTO uigara_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","مۇسا ئىشلارنىڭ ھەممىسىگە تەپسىلىي قارىدى، مانا، ئۇلار پەرۋەردىگارنىڭ بۇيرۇغىنى بويىچە بۇ ئىشلارنى پۈتكۈزگەنىدى؛ بۇيرۇلغاندەك، دەل شۇنداق قىلغانىدى؛ مۇسا بۇلارنى كۆرۈپ، ئۇلارغا بەخت-بەرىكەت تىلەپ دۇئا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ئاندىن پەرۋەردىگار مۇساغا مۇنداق ئەمر قىلدى: ــ ");
INSERT INTO uigara_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","بىرىنچى ئاينىڭ بېشى، ئاينىڭ بىرىنچى كۈنى سەن جامائەت چېدىرىنىڭ مۇقەددەسخانىسىنى تىكلىگىن. ");
INSERT INTO uigara_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ھۆكۈم-گۇۋاھلىق ساندۇقىنى ئۇنىڭ ئىچىگە قويۇپ، ئىچكى پەردە ئارقىلىق ئەھدە ساندۇقىنى توسۇپ قويغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","شىرەنى چېدىرنىڭ ئىچىگە ئەكىرىپ، ئۈستىگە تىزىلىدىغان نەرسىلەرنى تىزغىن؛ ئاندىن چىراغداننى ئەكىرىپ، ئۈستىگە چىراغلارنى ئورۇنلاشتۇرغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ئالتۇن بىلەن قاپلانغان خۇشبۇي كۆيدۈرگۈچى قۇربانگاھنى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۇدۇلىغا تىكلەپ قويغىن؛ چېدىرنىڭ كىرىش ئېغىزىنىڭ پەردىسىنى ئېسىپ قويغىن.    ");
INSERT INTO uigara_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","كۆيدۈرمە قۇربانلىق قۇربانگاھىنى مۇقەددەسخانىنىڭ، يەنى جامائەت چېدىرىنىڭ كىرىش ئېغىزىنىڭ ئالدىغا قويغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ئاندىن يۇيۇش دېسىنى جامائەت چېدىرى بىلەن قۇربانگاھنىڭ ئوتتۇرىسىغا ئورۇنلاشتۇرۇپ، سۇ توشتۇرۇپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ھويلىنىڭ چۆرىسىگە پەردىلەرنى بېكىتىپ، ھويلىنىڭ كىرىش ئېغىزىنىڭ پەردىسىنى ئاسقىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","ئاندىن «مەسىھلەش مېيى»نى ئېلىپ، ئىبادەت چېدىرى ۋە ئۇنىڭ ئىچىدىكى بارلىق نەرسىلەرنى مەسىھلەپ، ئۇنى ۋە بارلىق ھەممە ئەسۋابلىرىنى خۇداغا ئاتاپ مۇقەددەس قىلغىن. شۇنداق قىلىپ پۈتكۈل چېدىر مۇقەددەس بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","سەن كۆيدۈرمە قۇربانلىق قۇربانگاھىنى، شۇنداقلا ئۇنىڭ بارلىق ئەسۋابلىرىنى مەسىھلەپ، ئۇنى خۇداغا ئاتاپ مۇقەددەس قىلغىن؛ بۇنىڭ بىلەن قۇربانگاھ «ئەڭ مۇقەددەس نەرسىلەر» قاتارىدا بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","سەن يەنە يۇيۇنۇش دېسى ۋە ئۇنىڭ تەگلىكىنى مەسىھلەپ مۇقەددەس قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","ئاندىن ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىنى جامائەت چېدىرىنىڭ كىرىش ئېغىزىغا يېقىن ئەكىلىپ، ئۇلارنى سۇ بىلەن يۇغىن؛ ");
INSERT INTO uigara_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ھارۇنغا مۇقەددەس كىيىملەرنى كىيدۈرۈپ، ماڭا كاھىنلىق خىزمەتتە بولۇشى ئۈچۈن ئۇنى مەسىھلەپ، ماڭا ئايرىپ مۇقەددەس قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ئاندىن ئۇنىڭ ئوغۇللىرىنى ئېلىپ كىرىپ، ئۇلارغا خالتا كۆڭلەكلەرنى كىيدۈرۈپ، ");
INSERT INTO uigara_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ئۇلارنىڭ ئاتىسىنى مەسىھلىگىنىڭدەك ماڭا كاھىنلىق خىزمىتىدە بولۇشى ئۈچۈن ئۇلارنىمۇ مەسىھلىگىن. شۇنىڭ بىلەن ئۇلارنىڭ بۇ مەسىھلىنىشى ئۇلار ئۈچۈن ئەۋلادتىن ئەۋلادقىچە ئەبەدىي كاھىنلىقنىڭ بەلگىسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","مۇسا شۇنداق قىلدى؛ پەرۋەردىگار ئۇنىڭغا نېمە بۇيرۇغان بولسا، ئۇ شۇنداق بەجا كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","شۇنداق بولدىكى، ئىككىنچى يىلنىڭ بىرىنچى ئېيىدا، ئاينىڭ بىرىنچى كۈنىدە ئىبادەت چېدىرى تىكلەندى.    ");
INSERT INTO uigara_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","مۇسا چېدىرنى تىكىپ، تەگلىكلىرىنى ئورۇنلاشتۇرۇپ، تاختايلىرىنى تىزىپ، ئۇلارنىڭ بالداقلىرىنى بېكىتىپ، خادىلىرىنى تىكلىدى. ");
INSERT INTO uigara_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","مۇقەددەس چېدىرنىڭ ئۈستىگە ئىچكى يوپۇقنى ياپتى، ئاندىن ئۇنىڭ ئۈستىگە تاشقى يوپۇقنى يېپىپ قويدى؛ بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ئاندىن ئۇ ھۆكۈم-گۇۋاھلىقنى ئېلىپ، ئۇنى ساندۇق ئىچىگە قويدى؛ بالداقلارنى ئەھدە ساندۇقىنىڭ ھالقىلىرىدىن ئۆتكۈزۈپ، «كەفارەت تەختى»نى ساندۇقنىڭ ئۈستىگە ئورۇنلاشتۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ئەھدە ساندۇقىنى مۇقەددەس چېدىر ئىچىگە ئېلىپ كىرىپ، ئوتتۇرىغا «ئايرىما پەردە»نى تارتتى؛ شۇنداق قىلىپ ئۇ ھۆكۈم-گۇۋاھلىق ساندۇقىنى پەردە ئارقىلىق توسۇپ قويدى. ھەممە ئىش پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ئۇ شىرەنى جامائەت چېدىرىغا ئېلىپ كىرىپ، مۇقەددەس جاينىڭ شىمال تەرىپىگە، «ئەڭ مۇقەددەس جاي»دىكى پەردىنىڭ سىرتىغا قويدى. ");
INSERT INTO uigara_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","«تەقدىم نانلار»نى شىرەنىڭ ئۈستىگە، پەرۋەردىگارنىڭ ئالدىغا تىزىپ قويدى؛ بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ئاندىن ئۇ چىراغداننى جامائەت چېدىرىغا ئېلىپ كىرىپ، ئۇنى مۇقەددەس جاينىڭ جەنۇب تەرىپىگە، شىرەنىڭ ئۇدۇلىغا قويدى، ");
INSERT INTO uigara_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","چىراغلارنى پەرۋەردىگارنىڭ ئالدىغا ئورۇنلاشتۇردى؛ بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ئاندىن ئۇ خۇشبۇينى كۆيدۈرگۈچى ئالتۇن قۇربانگاھنى ئىچىدىكى پەردىنىڭ ئالدىغا تىكلىدى؛ ");
INSERT INTO uigara_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ئۇنىڭ ئۈستىدە ئېسىل خۇشبۇينى كۆيدۈردى؛ بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ئۇ ئىبادەت چېدىرىنىڭ كىرىش ئېغىزىغا پەردە تارتتى. ");
INSERT INTO uigara_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ئاندىن كۆيدۈرمە قۇربانلىق قۇربانگاھىنى جامائەت چېدىرىدىكى مۇقەددەس جاينىڭ كىرىش ئېغىزىغا يېقىن قويدى؛ ئۇنىڭ ئۈستىدە كۆيدۈرمە قۇربانلىق ۋە قوشۇمچە ئاشلىق ھەدىيەسىنى ئۆتكۈزدى؛ بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","يۇيۇنۇش دېسىنى جامائەت چېدىرى بىلەن قۇربانگاھنىڭ ئوتتۇرىسىغا قويۇپ، يۇيۇشقا ئىشلىتىلىدىغان سۇنى داسقا توشقۇزۇپ قۇيدى. ");
INSERT INTO uigara_vpl VALUES ("EX40_31‏","003_40_31‏","EXO","40","31‏","32","مۇسا ۋە ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى قاچانلا جامائەت چېدىرىغا كىرسە ياكى قۇربانگاھقا يېقىن بارسا، پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قوللىرىنى شۇ سۇدا يۇياتتى. بۇلار پەرۋەردىگارنىڭ مۇساغا بۇيرۇغىنىدەك قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ئاندىن ئۇ چېدىر ھەم قۇربانگاھنىڭ ئەتراپىغا ھويلا پەردىسىنى تىكلەپ، ھويلىنىڭ كىرىش ئېغىزىنىڭ پەردىسىنى تارتتى. شۇ تەرىقىدە مۇسا پۈتكۈل ئىشنى تاماملىدى. ");
INSERT INTO uigara_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","شۇنىڭ بىلەن بۇلۇت جامائەت چېدىرىنى قاپلاپ، پەرۋەردىگارنىڭ جۇلاسى ئىبادەت چېدىرىنى تولدۇردى. ");
INSERT INTO uigara_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","بۇلۇت سايە چۈشۈرۈپ، پەرۋەردىگارنىڭ جۇلاسى چېدىرنى تولدۇرغىنى ئۈچۈن، مۇسا جامائەت چېدىرىغا كىرەلمىدى. ");
INSERT INTO uigara_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","قاچانكى بۇلۇت جامائەت چېدىرىدىن كۆتۈرۈلسە، ئىسرائىللار سەپەرگە ئاتلىناتتى. ھەربىر قېتىم سەپەردە شۇنداق بولاتتى. ");
INSERT INTO uigara_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","بۇلۇت كۆتۈرۈلمىسە ئۇلار قوزغالماي، تاكى كۆتۈرۈلىدىغان كۈنگىچە سەپەرگە چىقمايتتى. ");
INSERT INTO uigara_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","چۈنكى كۈندۈزى پەرۋەردىگارنىڭ بۇلۇتى مۇقەددەس چېدىر ئۈستىدە تۇراتتى، كېچىسى ئۇنىڭ ئۈستىدە ئوت كۆرۈنەتتى؛ پۈتكۈل ئىسرائىل جەمەتىنىڭ كۆز ئالدىدا ئۇلارنىڭ بارلىق قىلغان سەپەرلىرىدە شۇلار كۆرۈنەتتى. ");
INSERT INTO uigara_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ۋە پەرۋەردىگار مۇسانى چاقىرىپ جامائەت چېدىرىدىن ئۇنىڭغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","سەن ئىسرائىللارغا سۆز قىلىپ ئۇلارغا مۇنداق دېگىن: ــ ئەگەر سىلەردىن بىرىڭلار پەرۋەردىگارنىڭ ئالدىغا بىر قۇربانلىقنى سۇنماقچى بولساڭلار، قۇربانلىقىڭلارنى چارپايلاردىن، يەنى كالا ياكى ئۇششاق ماللاردىن سۇنۇشۇڭلار كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ئەگەر ئۇنىڭ سۇنىدىغىنى كالىلاردىن كۆيدۈرمە قۇربانلىق بولسا، ئۇنداقتا ئۇ بېجىرىم ئەركەك ھايۋاننى كەلتۈرسۇن؛ ئۇنىڭ پەرۋەردىگارنىڭ ئالدىدا قوبۇل بولۇشى ئۈچۈن ئۇنى جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىدا سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ئۇ قولىنى كۆيدۈرمە قۇربانلىقنىڭ بېشىغا قويسۇن؛ شۇنىڭ بىلەن قۇربانلىق ئۇنىڭ ئورنىغا كەفارەت بولۇشقا قوبۇل قىلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ئاندىن ئۇ پەرۋەردىگارنىڭ ھۇزۇرىدا بۇقىنى بوغۇزلىسۇن؛ كاھىنلار بولغان ھارۇننىڭ ئوغۇللىرى قېنىنى كەلتۈرۈپ، جامائەت چېدىرىنىڭ كىرىش ئاغزىدىكى قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ئاندىن قۇربانلىق قىلغۇچى كۆيدۈرمە قۇربانلىق قىلىنغان ھايۋاننىڭ تېرىسىنى سويۇپ، تېنىنى پارچىلىسۇن ");
INSERT INTO uigara_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ۋە ھارۇن كاھىننىڭ ئوغۇللىرى قۇربانگاھتا ئوت قالاپ ئوتنىڭ ئۈستىگە ئوتۇنلارنى تىزسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ئاندىن كاھىنلار بولغان ھارۇننىڭ ئوغۇللىرى گۆش پارچىلىرىنى، بېشى ۋە مېيى بىلەن قوشۇپ، قۇربانگاھدىكى ئوتنىڭ ئۈستىدىكى ئوتۇننىڭ ئۈستىگە تەرتىپ بىلەن تىزىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","لېكىن ئۇنىڭ ئىچ-قارنى بىلەن پاچاقلىرىنى قۇربانلىق سۇنغۇچى سۇدا يۇسۇن؛ ئاندىن كاھىن ھەممىسىنى ئېلىپ كېلىپ قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. بۇ ئوت ئارقىلىق سۇنۇلىدىغان قۇربانلىق ھېسابىدا، پەرۋەردىگارغا خۇشبۇي چىقىرىلىدىغان كۆيدۈرمە قۇربانلىق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ئەگەر ئۇ كۆيدۈرمە قۇربانلىق قىلىش ئۈچۈن ئۇششاق ماللاردىن قوي يا ئۆچكە قۇربانلىق قىلاي دېسە، ئۇنداقتا ئۇ بېجىرىم بولغان بىر ئەركىكىنى كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ئۇ ئۇنى قۇربانگاھنىڭ شىمال تەرىپىدە پەرۋەردىگارنىڭ ھۇزۇرىدا بوغۇزلىسۇن. ئاندىن كاھىنلار بولغان ھارۇننىڭ ئوغۇللىرى قېنىنى ئېلىپ، قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","قۇربانلىق قىلغۇچى بولسا گۆشنى پارچىلاپ، بېشى بىلەن مېيىنى كېسىپ ئايرىسۇن. ئاندىن كاھىن بۇلارنى ئېلىپ قۇربانگاھتىكى ئوتنىڭ ئۈستىدىكى ئوتۇننىڭ ئۈستىدە تەرتىپ بويىچە تىزىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","لېكىن ئۇنىڭ ئىچ-قارنى بىلەن پاچاقلارنى قۇربانلىق سۇنغۇچى سۇدا يۇسۇن؛ ئاندىن كاھىن ھەممىسىنى ئېلىپ كېلىپ قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. بۇ ئوت ئارقىلىق سۇنۇلىدىغان قۇربانلىق ھېسابىدا، پەرۋەردىگارغا خۇشبۇي چىقىرىلىدىغان كۆيدۈرمە قۇربانلىق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ئەگەر قۇربانلىق قىلغۇچى پەرۋەردىگارغا ئاتاپ ئۇچار-قاناتلاردىن كۆيدۈرمە قۇربانلىق قىلاي دېسە، ئۇنداقتا ئۇ پاختەكلەردىن ياكى كەپتەر باچكىلىرىدىن قۇربانلىق كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","كاھىن ئۇنى قۇربانگاھنىڭ يېنىغا ئېلىپ كېلىپ، بېشىنى تولغاپ ئۈزۈپ ئۇنى قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن؛ ئۇنىڭ قېنى سىقىلىپ قۇربانگاھنىڭ تېمىغا سۈرتۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","لېكىن تاشلىقىنى پەيلىرى بىلەن قوشۇپ قۇربانگاھنىڭ شەرق تەرىپىدىكى كۈللۈككە تاشلىۋەتسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ئۇ قۇربانلىقنى ئىككى قانىتىنىڭ ئوتتۇرىسىدىن يارسۇن، بىراق ئۇنى ئىككى پارچە قىلىۋەتمىسۇن. ئاندىن كاھىن بۇنى ئېلىپ قۇربانگاھدىكى ئوتنىڭ ئۈستىدىكى ئوتۇننىڭ ئۈستىگە قويۇپ كۆيدۈرسۇن؛ بۇ ئوت ئارقىلىق سۇنۇلىدىغان قۇربانلىق ھېسابىدا، پەرۋەردىگارغا خۇشبۇي چىقىرىلىدىغان كۆيدۈرمە قۇربانلىق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ئەگەر بىركىم پەرۋەردىگارنىڭ ھۇزۇرىغا ئاشلىق ھەدىيەسى سۇنماقچى بولسا ھەدىيەسى ئېسىل ئۇندىن بولۇشى كېرەك؛ ئۇ ئۇنىڭغا زەيتۇن مېيى قۇيۇپ ئاندىن ئۈستىگە مەستىكى سالسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ئۇ ئۇنى ئېلىپ كاھىنلار بولغان ھارۇننىڭ ئوغۇللىرىنىڭ ئالدىغا كەلتۈرسۇن؛ ئاندىن كاھىن ھەدىيە سۇنغۇچىنىڭ يادلىنىشى ئۈچۈن زەيتۇن مېيى ئىلەشتۈرۈلگەن ئۇندىن بىر چاڭگال ئېلىپ، ھەممە مەستىكى بىلەن قوشۇپ، بۇ ھەدىيەنى قۇربانگاھتا كۆيدۈرسۇن؛ بۇ ئوت ئارقىلىق سۇنۇلىدىغان، پەرۋەردىگارغا خۇشبۇي چىقىرىلىدىغان ھەدىيە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ئەمما ئاشلىق ھەدىيەسىدىن قالغىنى بولسا، ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا تەۋە بولسۇن. بۇ پەرۋەردىگارغا ئوت ئارقىلىق سۇنۇلغانلارنىڭ ئىچىدە «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","ئەگەر سەن تونۇردا پىشۇرۇلغان نەرسىلەردىن ئاشلىق ھەدىيەسى سۇناي دېسەڭ، ئۇلار زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن پىشۇرۇلغان توقاچلار ياكى زەيتۇن مېيى سۈرۈلۈپ مەسىھلەنگەن پېتىر ھەمەك نانلاردىن بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ئەگەر سېنىڭ كەلتۈرىدىغان ھەدىيەڭ تاۋىدا پىشۇرۇلغان ئاشلىق ھەدىيەسى بولسا ئۇ زەيتۇن مېيى ئىشلەشتۈرۈلۈپ ئېسىل ئۇندىن پېتىر ھالدا ئېتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","سەن ئۇنى ئوشتۇپ ئۈستىگە زەيتۇن مېيى قۇيغىن؛ ئۇ ئاشلىق ھەدىيەسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","سېنىڭ كەلتۈرىدىغان ھەدىيەڭ قازاندا پىشۇرۇلغان ئاشلىق ھەدىيەسى بولسا ئۇنداقتا ئۇ ئېسىل ئۇن بىلەن زەيتۇن مېيىدا ئېتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","شۇ يوللاردا تەييارلانغان ئاشلىق ھەدىيەلىرىنى پەرۋەردىگارنىڭ ھۇزۇرىغا كەلتۈرگىن؛ ئۇنى كاھىنغا بەرگىن، ئۇ ئۇنى قۇربانگاھقا ئېلىپ بارىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","كاھىن بولسا ئاشلىق ھەدىيەسىدىن «يادلىنىش ئۈلۈشى»نى ئېلىپ قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. بۇ ئوت ئارقىلىق سۇنۇلىدىغان، پەرۋەردىگارغا خۇشبۇي چىقىرىلىدىغان ھەدىيە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ئەمما ئاشلىق ھەدىيەسىدىن قالغىنى بولسا، ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا تەۋە بولسۇن. بۇ پەرۋەردىگارغا ئوت ئارقىلىق سۇنۇلغانلارنىڭ ئىچىدە «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","سىلەر پەرۋەردىگارنىڭ ھۇزۇرىغا سۇنىدىغان ھەرقانداق ئاشلىق ھەدىيەلىرى ئېچىتقۇ بىلەن تەييارلانمىسون. چۈنكى سىلەرنىڭ پەرۋەردىگارغا ئوتتا سۇنۇلىدىغان ھەدىيەڭلارنىڭ ھېچقايسىسىدا ئېچىتقۇ ياكى ھەسەلنى كۆيدۈرۈشكە بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","بۇلارنى پەرۋەردىگارنىڭ ئالدىغا «دەسلەپكى ھوسۇل» سۈپىتىدە سۇنساڭلار بولىدۇ، لېكىن ئۇلار خۇشبۇي سۈپىتىدە قۇربانگاھنىڭ ئۈستىدە كۆيدۈرۈلۈپ سۇنۇلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","سېنىڭ ھەربىر ئاشلىق ھەدىيەڭ تۇز بىلەن تۇزلىنىشى كېرەك؛ ھەدىيەڭنى خۇدايىڭنىڭ ئەھدە تۇزىدىن مەھرۇم قىلماي، ھەممە ئاشلىق ھەدىيەلىرىڭنى تۇز بىلەن تۇزلىغىن. ");
INSERT INTO uigara_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ئەگەر سەن پەرۋەردىگارغا «دەسلەپكى ھوسۇل»دىن ئاشلىق ھەدىيەسى سۇناي دېسەڭ، ئۇنداقتا زىرائەتنىڭ يېڭى پىشقان كۆك بېشىنى ئېلىپ، دانلارنى ئوتتا قورۇپ، ئېزىپ تالقان سۈپىتىدە سۇنغىن؛ بۇ «دەسلەپكى ھوسۇل» ھەدىيەسى بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","سەن ئۇنىڭغا زەيتۇن مېيى قۇيۇپ ئۈستىگە مەستىكى سالغىن؛ بۇ ئاشلىق ھەدىيەسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","كاھىن بولسا ئۇنىڭدىن، يەنى قورۇپ ئېزىلگەن دانلار بىلەن زەيتۇن مېيىدىن بىر قىسمىنى ئېلىپ ھەممە مەستىكى بىلەن قوشۇپ، بولارنى «يادلىنىش ئۈلۈشى» سۈپىتىدە كۆيدۈرسۇن. بۇ ئوت ئارقىلىق پەرۋەردىگارغا سۇنۇلغان ھەدىيە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","بىرسىنىڭ سۇنىدىغىنى ئىناقلىق قۇربانلىقى بولسا، شۇنداقلا كالىلاردىن سۇنسا، ئۇ پەرۋەردىگارنىڭ ھۇزۇرىغا بېجىرىم بىر ئەركىكىنى ياكى چىشىسىنى كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ئۇ سۇنىدىغان بۇ ھايۋاننىڭ بېشىغا قولىنى قويۇپ، ئاندىن ئۇنى جامائەت چېدىرىنىڭ كىرىش ئېغىزى ئالدىدا بوغۇزلىسۇن. ئاندىن كاھىنلار بولغان ھارۇننىڭ ئوغۇللىرى قېنىنى قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","سۇنغۇچى كىشى بۇ ئىناقلىق قۇربانلىقىدىن پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان ھەدىيە سۈپىتىدە بىر قىسمىنى ئېلىپ بېغىشلىسۇن، يەنى ئىچ قارنىنى يۆگەپ تۇرغان ماينى، شۇنداقلا بارلىق ئىچ مېيىنى ئېلىپ ");
INSERT INTO uigara_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ئىككى بۆرەكنى ۋە ئۇلارنىڭ ئۈستىدىكى ھەمدە ئىككى يانپىشىدىكى ماينى ئاجرىتىپ، جىگەرنىڭ بۆرەككىچە بولغان چاۋا مېيىنى كېسىپ، ئېلىپ كەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ھارۇننىڭ ئوغۇللىرى بولسا بۇلارنى قۇربانگاھنىڭ ئۈستىگە كەلتۈرۈپ ئوت ئۈستىگە قويۇلغان ئوتۇننىڭ ئۈستىدىكى كۆيدۈرمە قۇربانلىققا قوشۇپ كۆيدۈرسۇن. بۇ ئوت ئارقىلىق سۇنۇلىدىغان، پەرۋەردىگارغا خۇشبۇي چىقىرىلىدىغان قۇربانلىق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","بىرسىنىڭ پەرۋەردىگارغا قىلىدىغان ئىناقلىق قۇربانلىقى ئۈچۈن سۇنىدىغىنى ئۇششاق مالدىن بولسا، ئۇنداقتا ئۇ بېجىرىم بىر ئەركىكىنى ياكى چىشىسىنى كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ئەگەر ئۇنىڭ قۇربانلىقى قوي بولسا ئۇنى پەرۋەردىگارنىڭ ئالدىغا كەلتۈرۈپ، ");
INSERT INTO uigara_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","قۇربانلىق قىلىدىغان بۇ ھايۋاننىڭ بېشىغا قولىنى قويۇپ، ئاندىن ئۇنى جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىدا بوغۇزلىسۇن. ئاندىن ھارۇننىڭ ئوغۇللىرى قېنىنى ئېلىپ قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","سۇنغۇچى كىشى بۇ ئىناقلىق قۇربانلىقىدىن پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان ھەدىيە سۈپىتىدە بىر قىسمىنى، يەنى ئۇنىڭ مېيىنى ئېلىپ بېغىشلىسۇن، ــ پۈتۈن مايلىق قۇيرۇقىنى ئۇنىڭ ئومۇرتقىسىغا يېقىن يەردىن ئاجرىتىپ ئېلىپ، ئىچ قارنىنى يۆگەپ تۇرغان ماينى، شۇنداقلا بارلىق ئىچ مېيىنى ئېلىپ، ");
INSERT INTO uigara_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ئىككى بۆرەكنى ۋە ئۇلارنىڭ ئۈستىدىكى ھەمدە ئىككى يانپىشىدىكى ماينى ئاجرىتىپ، جىگەرنىڭ بۆرەككىچە بولغان چاۋا مېيىنى كېسىپ، ئېلىپ كەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","كاھىن بۇلارنى قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن؛ بۇ ئوتتا سۇنۇلىدىغان، پەرۋەردىگارغا ئاتالغان تائام ھەدىيەسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","ئۇنىڭ سۇنىدىغىنى ئۆچكە بولسا، بۇنى پەرۋەردىگارنىڭ ھۇزۇرىغا كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ئۇ قولىنى ئۇنىڭ بېشىغا قويۇپ، ئاندىن ئۇنى جامائەت چېدىرىنىڭ ئالدىدا بوغۇزلىسۇن. ئاندىن ھارۇننىڭ ئوغۇللىرى قېنىنى ئېلىپ قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ئاندىن سۇنغۇچى كىشى بۇ قۇربانلىقتىن پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان ھەدىيە سۈپىتىدە بىر قىسمىنى ئېلىپ بېغىشلىسۇن، يەنى ئىچ قارنىنى يۆگەپ تۇرغان ماينى، شۇنداقلا بارلىق ئىچ مېيىنى ئېلىپ، ");
INSERT INTO uigara_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ئىككى بۆرەكنى ۋە ئۇلارنىڭ ئۈستىدىكى ھەمدە ئىككى يانپىشىدىكى ماينى ئاجرىتىپ، جىگەرنىڭ بۆرەككىچە بولغان چاۋا مېيىنى كېسىپ، ئېلىپ كەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","كاھىن بۇلارنى قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن؛ بۇ ئوتتا سۇنۇلىدىغان، خۇشبۇي چىقىرىدىغان تائام ھەدىيەسى بولىدۇ. ماينىڭ ھەممىسى پەرۋەردىگارغا تەۋەدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","بۇ ھەرقانداق تۇرار جايىڭلاردا سىلەرگە ئەبەدىي بەلگىلىمە بولىدۇ؛ سىلەر ھېچقانداق ماي ياكى قان يېمەسلىكىڭلار كېرەك.    ");
INSERT INTO uigara_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ئىسرائىللارغا سۆز قىلىپ مۇنداق دېگىن: ــ «بىرسى بىلمەي ئېزىپ، پەرۋەردىگار «قىلما» دەپ بۇيرۇغان ھەرقانداق ئەمرلەردىن بىرىگە خىلاپلىق قىلىپ سېلىپ، گۇناھ قىلسا، تۆۋەندىكىدەك قىلسۇن: ــ ");
INSERT INTO uigara_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ــ ئەگەر مەسىھلەنگەن كاھىن خەلقنى گۇناھقا پۇتلاشتۇرىدىغان بىر گۇناھنى قىلسا، ئۇنداقتا ئۇ بۇ قىلغان گۇناھى ئۈچۈن بىر بېجىرىم ياش تورپاقنى ئېلىپ كېلىپ، پەرۋەردىگارغا گۇناھ قۇربانلىقى سۈپىتىدە سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ئۇ تورپاقنى جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ يېنىغا، پەرۋەردىگارنىڭ ئالدىغا كەلتۈرۈپ، قولىنى ئۇنىڭ بېشىغا قويۇپ، ئاندىن تورپاقنى پەرۋەردىگارنىڭ ھۇزۇرىدا بوغۇزلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ئاندىن مەسىھلەنگەن كاھىن تورپاقنىڭ قېنىدىن ئازغىنا ئېلىپ، جامائەت چېدىرى ئىچىگە كۆتۈرۈپ ئاپارسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","كاھىن شۇ يەردە بارمىقىنى قانغا چىلاپ، قاننى مۇقەددەس جاينىڭ ئەڭ پەردىسىنىڭ ئالدىدا، پەرۋەردىگارنىڭ ھۇزۇرىدا يەتتە مەرتىۋە سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","شۇنداقلا كاھىن قاندىن ئېلىپ، جامائەت چېدىرى ئىچىدە پەرۋەردىگارنىڭ ئالدىدا تۇرغان خۇشبۇيگاھنىڭ مۈڭگۈزلىرىگە سۈرسۇن. تورپاقنىڭ قالغان ھەممە قېنىنى بولسا، جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىدىكى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ تۈۋىگە تۆكۈپ قويسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ئاندىن ئۇ گۇناھ قۇربانلىقى بولغان تورپاقنىڭ ئىچىدىن ھەممە مېيىنى ئاجرىتىپ چىقارسۇن ــ يەنى ئىچ قارنىنى يۆگەپ تۇرغان ماي بىلەن قالغان ئىچ مېيى، ");
INSERT INTO uigara_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ئىككى بۆرەكنى ۋە ئۇلارنىڭ ئۈستىدىكى ھەمدە ئىككى يانپىشىدىكى ماينى ئاجرىتىپ، جىگەرنىڭ بۆرەككىچە بولغان چاۋا مېيىنى ئاجراتسۇن ");
INSERT INTO uigara_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(خۇددى ئىناقلىق قۇربانلىقى بولغان كالىنىڭ ئىچىدىكى ماي ئاجرىتىلغاندەك)؛ ئاندىن كاھىن بۇلارنى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ ئۈستىدە كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","لېكىن تورپاقنىڭ تېرىسى بىلەن ھەممە گۆشى، باش بىلەن پاچاقلىرى، ئىچ قارنى بىلەن ژىنىنى، ");
INSERT INTO uigara_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","يەنى پۈتكۈل تورپاقنىڭ قالغان قىسىملىرىنى چېدىرگاھنىڭ سىرتىغا ئېلىپ چىقىپ، پاك بىر يەرگە، يەنى كۈللەر تۆكۈلىدىغان جايغا ئېلىپ چىقىپ، ئوتۇننىڭ ئۈستىدە ئوتتا كۆيدۈرسۇن. بۇلار كۈللەر تۆكۈلىدىغان جايدا كۆيدۈرۈۋېتىلسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ئەگەر پۈتكۈل ئىسرائىل جامائىتى ئۆزى بىلمىگەن ھالدا ئېزىپ گۇناھ قىلغان بولسا، پەرۋەردىگارنىڭ «قىلما» دەپ بۇيرۇغان ھەرقانداق ئەمرلىرىگە خىلاپلىق ئىشلارنىڭ بىرىنى قىلىپ سېلىپ، گۇناھقا چۈشۈپ قالسا،    ");
INSERT INTO uigara_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","شۇنداقلا ئۇلارنىڭ سادىر قىلغان گۇناھى ئايدىڭلاشقان بولسا، ئۇنداقتا جامائەت گۇناھ قۇربانلىقى سۈپىتىدە بىر ياش تورپاقنى سۇنۇپ جامائەت چېدىرىنىڭ ئالدىغا كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","جامائەتنىڭ ئاقساقاللىرى پەرۋەردىگارنىڭ ئالدىدا قوللىرىنى تورپاقنىڭ بېشىغا قويۇپ، ئاندىن تورپاقنى پەرۋەردىگارنىڭ ئالدىدا بوغۇزلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","مەسىھلەنگەن كاھىن تورپاقنىڭ قېنىدىن ئازغىنا ئېلىپ جامائەت چېدىرى ئىچىگە ئېلىپ كىرسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","شۇ يەردە بارمىقىنى قانغا چىلاپ، قاننى ئەڭ مۇقەددەس جاينىڭ پەردىسىنىڭ ئالدىدا، پەرۋەردىگارنىڭ ھۇزۇرىدا يەتتە مەرتىۋە سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","شۇنداقلا كاھىن قاندىن ئېلىپ جامائەت چېدىرى ئىچىدە پەرۋەردىگارنىڭ ئالدىدا تۇرغان خۇشبۇيگاھنىڭ مۈڭگۈزلىرىگە سۈرسۇن. تورپاقنىڭ قالغان ھەممە قېنىنى بولسا، جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىدىكى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ تۈۋىگە تۆكۈپ قويسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","كاھىن تورپاقنىڭ ئىچىدىن بارلىق مېيىنى ئاجرىتىپ ئېلىپ، قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ئۇ گۇناھ قۇربانلىقى بولغان ئىلگىرىكى تورپاقنى قىلغىنىغا ئوخشاش بۇ تورپاقنىمۇ شۇنداق قىلسۇن؛ ۋە دەل شۇنداق قىلىشى كېرەك؛ شۇ يول بىلەن كاھىن ئۇلار ئۈچۈن كەفارەت كەلتۈرىدۇ؛ شۇ گۇناھ ئۇلاردىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ئاندىن ئۇ تورپاقنى چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقىپ، ئىلگىرىكى تورپاقنى كۆيدۈرگەندەك بۇ تورپاقنىمۇ كۆيدۈرسۇن. بۇ جامائەت ئۈچۈن گۇناھ قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ئەگەر بىر ئەمىر بىلمەي ئۇنىڭ خۇداسى پەرۋەردىگارنىڭ «قىلما» دېگەن ھەرقانداق ئەمرلىرىنىڭ بىرىگە خىلاپلىق قىلىپ سېلىپ، گۇناھقا چۈشۈپ قالسا، ");
INSERT INTO uigara_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ۋە قىلغان گۇناھى ئۆزىگە مەلۇم قىلىنغان بولسا، ئۇنداقتا ئۇ ئۆزى قۇربانلىق ئۈچۈن بېجىرىم بىر تېكىنى سۇنسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ئۇ قولىنى تېكىنىڭ بېشىغا قويۇپ، ئاندىن ئۇنى كۆيدۈرمە قۇربانلىق قىلىنىدىغان ھايۋانلارنى بوغۇزلايدىغان جايغا ئېلىپ بېرىپ پەرۋەردىگارنىڭ ئالدىدا بوغۇزلىسۇن. بۇ بىر گۇناھ قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","كاھىن گۇناھ قۇربانلىقىنىڭ قېنىدىن بارمىقىغا ئازغىنا ئېلىپ، ئۇنى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ مۈڭگۈزلىرىگە سۈرۈپ قويسۇن؛ ئاندىن قالغان قېنىنى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ تۈۋىگە تۆكۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ئۇ ئىناقلىق قۇربانلىقى قىلىنغان ھايۋاننىڭ مېيىنى كۆيدۈرگەندەك، ئۇنىڭ بارلىق مېيىنى قۇربانگاھتا كۆيدۈرسۇن. بۇ يول بىلەن كاھىن ئۇنى گۇناھىدىن پاكلاندۇرۇش ئۈچۈن كەفارەت كەلتۈرىدۇ ۋە شۇ گۇناھى ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ئەگەر پۇقرالاردىن بىرى بىلمەي ئۇنىڭ خۇداسى پەرۋەردىگارنىڭ «قىلما» دېگەن ھەرقانداق ئەمرلىرىنىڭ بىرىگە خىلاپلىق قىلىپ سېلىپ، گۇناھقا چۈشۈپ قالسا، ");
INSERT INTO uigara_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ۋە قىلغان گۇناھى ئۆزىگە مەلۇم قىلىنغان بولسا، ئۇنداقتا ئۇ ئۆزىنىڭ، يەنى ئۇ سادىر قىلغان گۇناھى ئۈچۈن قۇربانلىق قىلىشقا بېجىرىم بىر چىشى ئۆچكىنى سۇنسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ئۇ قولىنى گۇناھ قۇربانلىقىنىڭ بېشىغا قويۇپ، ئاندىن ئۇنى كۆيدۈرمە قۇربانلىقلارنى بوغۇزلايدىغان جايغا ئېلىپ بېرىپ بوغۇزلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ئاندىن كاھىن ئۇنىڭ قېنىدىن بارمىقىغا ئازغىنا ئېلىپ ئۇنى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ مۈڭگۈزلىرىگە سۈرۈپ قويسۇن؛ قالغان بارلىق قېنىنى قۇربانگاھنىڭ تۈۋىگە تۆكۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ئىناقلىق قۇربانلىقى قىلىنغان ھايۋاننىڭ مېيى ئىچىدىن ئاجرىتىلغاندەك ئۇنىڭمۇ ھەممە مېيىنى ئاجرىتىپ چىقارسۇن؛ كاھىن ئۇنى پەرۋەردىگارنىڭ ئالدىدا خۇشبۇي كەلتۈرسۇن دەپ قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. شۇ يول بىلەن كاھىن ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرىدۇ؛ شۇ گۇناھ ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ئەگەر ئۇ كىشى گۇناھ قۇربانلىقى ئۈچۈن قوزا كەلتۈرۈشنى خالىسا، بېجىرىم بىر چىشى قوزىنى سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ئۇ قولىنى گۇناھ قۇربانلىقى قوزىسىنىڭ بېشىغا قويۇپ، كۆيدۈرمە قۇربانلىقلار بوغۇزلىنىدىغان جايغا ئېلىپ بېرىپ، ئۇنى گۇناھ قۇربانلىقى سۈپىتىدە بوغۇزلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ئاندىن كاھىن گۇناھ قۇربانلىقىنىڭ قېنىدىن بارمىقىغا ئازغىنا ئېلىپ ئۇنى كۆيدۈرمە قۇربانلىق قۇربانگاھىنىڭ مۈڭگۈزلىرىگە سۈرۈپ قويسۇن؛ ئۇنىڭ قالغان بارلىق قېنىنى ئۇ قۇربانگاھنىڭ تۈۋىگە تۆكۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ئىناقلىق قۇربانلىقى قىلىنغان قوزىنىڭ مېيى ئىچىدىن ئاجرىتىلغاندەك، ئۇنىڭمۇ ھەممە مېيىنى ئاجرىتىپ چىقارسۇن؛ كاھىن بۇلارنى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان بارلىق قۇربانلىقلارغا قوشۇپ، قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. شۇ يول بىلەن كاھىن ئۇنىڭ سادىر قىلغان گۇناھى ئۈچۈن كەفارەت كەلتۈرىدۇ؛ شۇ گۇناھ ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ئەگەر بىرسى مەلۇم ئىشقا گۇۋاھچى بولۇپ، شۇنداقلا ئۇنىڭغا قەسەم بۇيرۇلغىنىدا كۆرگىنى ياكى بىلگىنىدىن مەلۇمات بەرمىسە، ئۇنداقتا ئۇ قەبىھلىكىنىڭ جازاسىغا تارتىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ئەگەر بىرسى ئۆزى بىلمەي ناپاك بىر نەرسىگە تېگىپ كەتسە ــ مەيلى ئۇ ناپاك بىر ھايۋاننىڭ جەسىتى بولسۇن، مەيلى ناپاك بىر چارپاينىڭ جەسىتى بولسۇن، ياكى ناپاك بىر ئۆمىلىگۈچى ھايۋاننىڭ جەسىتى بولسۇن، مۇشۇنداق نەرسىگە تېگىپ كەتسە ئۇمۇ ناپاك سانىلىپ گۇناھكار ھېسابلىنىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ئەگەر شۇنىڭدەك بىرسى ئۆزى تۇيماي مەلۇم كىشىنىڭ ئادەمنى ناپاك قىلىدىغان ھەرقانداق نىجاسىتىگە تېگىپ كەتسە، شۇنداقلا ئۇ بۇنى بىلىپ يەتسە، ئۇنداقتا ئۇ گۇناھكار ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ئەگەر بىرسى ئاڭسىز رەۋىشتە يامان ياكى ياخشى بىر ئىشنى قىلاي دەپ قەسەم قىلىپ سالسا (كىشىلەر ھەرتۈرلۈك ئىش توغرىسىدا ئاڭسىز رەۋىشتە قەسەم قىلىشى مۇمكىن)، شۇنداقلا ئۇ بۇنى تونۇپ يەتسە، ئۇ بۇ ئىشلار تۈپەيلىدىن گۇناھكار ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","بىرسى يۇقىرىقى ھەرقايسى ئىشلاردا مەن گۇناھكار بولدۇم دەپ بىلسە، ئۇ ئۆز گۇناھىنى «مەن مۇنداق گۇناھ قىلدىم» دەپ ئىقرار قىلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ئاندىن ئۆزى سادىر قىلغان گۇناھىنىڭ كافارىتى ئۈچۈن پەرۋەردىگارنىڭ ئالدىغا «ئىتائەتسىزلىكنى تىلىگۈچى قۇربانلىق» سۈپىتىدە ئۇششاق مالدىن ساغلىق ۋە يا بىر چىشى ئۆچكىنى گۇناھ قۇربانلىقى قىلىپ كەلتۈرسۇن؛ ئاندىن كاھىن ئۇنى گۇناھىدىن پاكلاندۇرۇشقا ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ئەگەر ئۇ قويلاردىن قۇربانلىق قىلىشقا قۇربى يەتمىسە، ئۇ قىلغان ئىتائەتسىزلىكى ئۈچۈن ئىككى پاختەك ياكى ئىككى باچكىنى ئېلىپ كېلىپ، بىرىنى گۇناھ قۇربانلىقى ئۈچۈن، يەنە بىرىنى كۆيدۈرمە قۇربانلىق ئۈچۈن پەرۋەردىگارنىڭ ئالدىغا سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ئۇ بۇلارنى كاھىننىڭ قېشىغا كەلتۈرگەندە، كاھىن ئاۋۋال گۇناھ قۇربانلىقىغا تەييارلانغاننى قۇربانلىق قىلىپ بوينىنى ئۈزمەي، بېشىغا يېقىن جايىدىن تولغىسۇن، لېكىن بېشىنى بوينىدىن ئۈزۈۋەتمىسۇن؛    ");
INSERT INTO uigara_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ئاندىن گۇناھ قۇربانلىقىنىڭ قېنىدىن ئازغىنا ئېلىپ قۇربانگاھنىڭ تېمىغا چاچسۇن؛ قالغان قېنى بولسا قۇربانگاھنىڭ تۈۋىگە سىقىپ چىقىرىلسۇن. بۇنىڭ ئۆزى گۇناھ قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ئەمما ئىككىنچىسىنى بولسا بېكىتىلگەن بەلگىلىمە بويىچە كۆيدۈرمە قۇربانلىق قىلىپ سۇنسۇن. بۇ يول بىلەن كاھىن ئۇنىڭ قىلغان گۇناھى ئۈچۈن كەفارەت كەلتۈرىدۇ ۋە شۇ گۇناھ ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ئەگەر ئىككى پاختەك ياكى ئىككى باچكىنى كەلتۈرۈشكە قۇربى يەتمىسە، ئۇنداقتا گۇناھ قىلغان كىشى گۇناھ قۇربانلىقى ئۈچۈن ئېسىل ئۇندىن بىر ئەفاھنىڭ ئوندىن بىرىنى كەلتۈرسۇن؛ بۇ گۇناھ قۇربانلىقى بولغاچقا ئۇ ئۇنىڭ ئۈستىگە زەيتۇن مېيى قۇيمىسۇن ياكى ئۈستىگە ھېچقانداق مەستىكى سالمىسۇن؛ چۈنكى ئۇ گۇناھ قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ئۇ ئۇنى كاھىننىڭ قېشىغا كەلتۈرسۇن ۋە كاھىن بۇنىڭدىن سۇنغۇچىنىڭ «يادلىنىش ئۈلۈشى» سۈپىتىدە بىر چاڭگال ئېلىپ، شۇنى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلغان قۇربانلىقلارغا قوشۇپ، قۇربانگاھنىڭ ئۈستىدە كۆيدۈرسۇن. بۇنىڭ ئۆزى گۇناھ قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","بۇ يول بىلەن ئۇ شۇ گۇناھلاردىن قايسىسىنى قىلغان بولسا، كاھىن ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرىدۇ. ئاشلىق ھەدىيەلىرىدىكىگە ئوخشاش قالغان قىسمى كاھىنغا تەۋە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ئاندىن پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","بىرسى بىلمەي پەرۋەردىگارغا ئاتالغان مۇقەددەس نەرسىلەرگە نىسبەتەن ئىتائەتسىزلىك قىلىپ گۇناھ ئۆتكۈزسە، ئۇنداقتا ئۇ پەرۋەردىگارنىڭ ئالدىغا ئۇششاق مالدىن بېجىرىم بىر قوچقارنى ئىتائەتسىزلىك قۇربانلىقى قىلىپ كەلتۈرسۇن؛ شۇ ئىتائەتسىزلىك قۇربانلىقى بولغان قوچقارنىڭ باھاسىنى سەن مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە كۈمۈش شەكەلگە توختاتقىن.    ");
INSERT INTO uigara_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ئاندىن شۇ كىشى مۇقەددەس نەرسىلەرگە نىسبەتەن ئۆتكۈزگەن خاتالىقىدىن بولغان زىياننى تولدۇرسۇن، شۇنداقلا زىياننىڭ بەشتىن بىرى بويىچە قوشۇپ كاھىنغا تۆلەم تۆلىسۇن. بۇ يول بىلەن كاھىن ئىتائەتسىزلىك قۇربانلىقى بولغان قوچقارنىڭ ۋاسىتىسى بىلەن ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرىدۇ؛ شۇ گۇناھ ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ئەگەر بىرسى بىلمەي پەرۋەردىگارنىڭ «قىلما» دېگەن ھەرقانداق ئەمرلىرىنىڭ بىرەرىسىگە خىلاپلىق قىلىپ، گۇناھكار بولغان بولسا ئۇ قەبىھلىكىنىڭ جازاسىغا تارتىلىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","شۇنداق بولسا، ئۇ ئۇششاق مالدىن سەن توختاتقان قىممەتتە بېجىرىم بىر قوچقارنى ئىتائەتسىزلىك قۇربانلىقى قىلىپ سۇنسۇن. بۇ يول بىلەن كاھىن ئۇنىڭ بىلمەي ئۆتكۈزگەن ئىتائەتسىزلىكى ئۈچۈن كەفارەت كەلتۈرىدۇ ۋە شۇ ئىتائەتسىزلىك گۇناھى ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","بۇ ئىتائەتسىزلىك قۇربانلىقى بولىدۇ؛ چۈنكى ئۇ دەرھەقىقەت پەرۋەردىگارنىڭ ئالدىدا ئىتائەتسىزلىك قىلغان. ");
INSERT INTO uigara_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ئاندىن پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","ئەگەر بىرسى گۇناھ قىلىپ پەرۋەردىگارنىڭ ئالدىدا ۋاپاسىزلىق قىلىپ، قوشنىسى ئۆزىگە ئامانەت ياكى كاپالەتكە بەرگەن بىر نەرسە ياكى قوشنىسىدىن زوراۋانلىق بىلەن بۇلىۋالغان مەلۇم بىر نەرسە توغرىسىدا يالغان گەپ قىلغان بولسا ياكى قوشنىسىدىن ناھەقلىق بىلەن مەلۇم نەرسىنى تارتىۋالغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ياكى يىتىپ كەتكەن بىر نەرسىنى تېپىۋېلىپ ئۇنىڭدىن تانسا ياكى كىشىلەرنىڭ گۇناھ سادىر قىلغان ھەرقانداق بىر ئىشى توغرىسىدا يالغان قەسەم ئىچسە، ");
INSERT INTO uigara_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ئۇ گۇناھ قىلغان ئىشتا ئۆزىنى گۇناھكار دەپ تونۇپ يەتسە، ئۇنداقتا ئۇ بۇلىۋالغان ياكى ناھەق تارتىۋالغان نەرسە ياكى ئۇنىڭغا ئامانەتكە بېرىلگەن نەرسە بولسۇن، ياكى يىتىپ كېتىپ تېپىۋالغان نەرسە بولسۇن، ");
INSERT INTO uigara_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ياكى ئۇ ھەرقانداق نەرسە توغرىسىدا يالغان قەسەم ئىچكەن بولسۇن، ئۇنىڭ ھەممىسىنى تولۇق باھاسى بويىچە تۆلىسۇن، شۇنداقلا شۇ باھانىڭ بەشتىن بىر قىسمى بويىچە قوشۇپ تۆلىسۇن؛ ئۇ ئىتائەتسىزلىك قۇربانلىقىنى قىلغان كۈنىدە تۆلەمنى ئىگىسىگە تاپشۇرۇپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ئاندىن ئۇ پەرۋەردىگارنىڭ ئالدىغا ئىتائەتسىزلىك قۇربانلىقى سۈپىتىدە ئۇششاق مالدىن سەن توختاتقان قىممەت بويىچە بېجىرىم بىر قوچقارنى ئىتائەتسىزلىك قۇربانلىقى قىلىپ كاھىننىڭ قېشىغا ئېلىپ كەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","كاھىن بۇ يول بىلەن ئۇنىڭ ئۈچۈن پەرۋەردىگارنىڭ ئالدىدا كەفارەت كەلتۈرىدۇ ۋە ئۇ ھەرقايسى ئىشتا ئىتائەتسىزلىك قىلغان بولسىمۇ ئۇ ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","سەن ھارۇن بىلەن ئوغۇللىرىغا كۆيدۈرمە قۇربانلىق توغرىسىدا ئەمر قىلىپ مۇنداق دېگىن: ــ كۆيدۈرمە قۇربانلىق توغرىسىدىكى قائىدە-نىزام مۇنداق بولىدۇ: ــ كۆيدۈرمە قۇربانلىق پۈتۈن كېچە تاڭ ئاتقۇچە قۇربانگاھتىكى ئوچاقنىڭ ئۈستىدە كۆيۈپ تۇرسۇن؛ ۋە قۇربانگاھنىڭ ئوتىنى ئۆچۈرمەي يېنىق تۇرغۇزۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","كاھىن كاناپ تونىنى كىيىپ، يالىڭاچلىقىنى يېپىپ، ساغرىسىغىچە كاناپ ئىچ تامبال كىيىپ تۇرسۇن؛ قۇربانگاھنىڭ ئۈستىدىكى ئوت بىلەن كۆيدۈرۈلگەن كۆيدۈرمە قۇربانلىقنىڭ كۈلىنى ئېلىپ، قۇربانگاھنىڭ بىر تەرىپىدە قويسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ئاندىن كىيىملىرىنى سېلىۋېتىپ باشقا كىيىملەرنى كىيىپ، كۈلىنى چېدىرگاھنىڭ سىرتىغا ئېلىپ چىقىپ پاكىز بىر جايدا قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","قۇربانگاھنىڭ ئوتى بولسا ھەمىشە يېنىپ تۇرسۇن؛ ئۇنى ھېچ ۋاقىت ئۆچۈرۈشكە بولمايدۇ، كاھىن ئۆزى ھەر كۈنى ئەتىگەندە ئۇنىڭغا ئوتۇن سېلىپ، ئۈستىگە كۆيدۈرمە قۇربانلىقنى تىزسۇن ۋە ئۇنىڭ ئۈستىگە ئىناقلىق قۇربانلىقلىرىنىڭ مېيىنى قويۇپ كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ئۈزۈلمەس بىر ئوت قۇربانگاھنىڭ ئۈستىدە ھەمىشە كۆيۈپ تۇرسۇن؛ ئۇ ھەرگىز ئۆچۈرۈلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ئاشلىق ھەدىيەسى توغرىسىدىكى قائىدە-نىزام مۇنداق: ــ ھارۇننىڭ ئوغۇللىرىدىن بىرى ئۇنى پەرۋەردىگارنىڭ ئالدىغا، قۇربانگاھنىڭ ئالدىغا كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ئۇ ئاشلىق ھەدىيەسى بولغان ئېسىل ئۇنغا قولىنى سېلىپ ئۇنىڭدىن شۇنداقلا ئۇنىڭدىكى زەيتۇن مېيىدىن بىر چاڭگال ئېلىپ ۋە ھەدىيەنىڭ ئۈستىدىكى بارلىق مەستىكىنى قوشۇپ، بۇلارنى قۇربانگاھ ئۈستىدە كۆيدۈرسۇن؛ بۇ ھەدىيەنىڭ «يادلىنىش ئۈلۈشى» بولۇپ، پەرۋەردىگارنىڭ ئالدىدا خۇشبۇي كەلتۈرۈش ئۈچۈن قىلىنغان بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ئېشىپ قالغانلىرىنى بولسا ھارۇن بىلەن ئوغۇللىرى يېسۇن؛ ئۇ ئېچىتقۇ سېلىنماي پىشۇرۇلۇپ مۇقەددەس بىر جايدا يېيىلسۇن؛ ئۇلار ئۇنى جامائەت چېدىرىنىڭ ھويلىسىدا يېسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ئۇ مۇتلەق ئېچىتقۇسىز پىشۇرۇلسۇن. مەن ئوتتا ماڭا سۇنۇلىدىغان قۇربانلىق-ھەدىيەلەر ئىچىدىن شۇنى ئۇلارنىڭ ئۆز ئۈلۈشى بولسۇن دەپ ئۇلارغا ھەق قىلىپ بەردىم؛ ئۇ گۇناھ ۋە ئىتائەتسىزلىكنى تىلىگۈچى قۇربانلىقلارغا ئوخشاش «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ھارۇننىڭ ئەۋلادىدىن بولغان ئەركەكلەرنىڭ ھەممىسى بۇنىڭدىن يېسۇن؛ بۇ دەۋردىن-دەۋرگە ئاراڭلاردا ئەبەدىي بىر بەلگىلىمە بولىدۇ؛ پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلغانلىرىدىن بۇلار ئۇلارنىڭ ئۈلۈشى بولسۇن. ئۇنىڭغا قول تەگكۈزگۈچى جەزمەن مۇقەددەس بولۇشى كېرەك.    ");
INSERT INTO uigara_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","ھارۇن مەسىھلىنىدىغان كۈنىدە ئۇ ۋە ئوغۇللىرىنىڭ پەرۋەردىگارنىڭ ئالدىغا سۇنىدىغىنى مۇنداق بولۇشى كېرەك: ــ ئۇلار ئۈزۈلمەس ئاشلىق ھەدىيەسى سۈپىتىدە ئېسىل ئۇندىن بىر ئەفاھنىڭ ئوندىن بىرىنى سۇنۇشى كېرەك؛ ئەتىگىنى يېرىمىنى، ئاخشىمى يەنە يېرىمىنى سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ئۇ تاۋىدا زەيتۇن مېيى بىلەن ئېتىلسۇن؛ ئۇ زەيتۇن مېيىغا چىلاپ پىشۇرۇلغاندىن كېيىن سەن ئۇنى ئېلىپ كىر؛ ئاشلىق ھەدىيەسىنىڭ پىشۇرۇلغان پارچىلىرىنى خۇشبۇي سۈپىتىدە پەرۋەردىگارغا ئاتاپ سۇنغىن. ");
INSERT INTO uigara_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ھارۇننىڭ ئوغۇللىرىنىڭ قايسىسى ئۇنىڭ ئورنىدا تۇرۇشقا مەسىھلەنگەن بولسا ئۇمۇ ھەدىيەنى شۇنداق تەييارلاپ سۇنسۇن؛ بۇ ئەبەدىي مۇتلەق بىر بەلگىلىمە بولىدۇ. بۇ ھەدىيە پەرۋەردىگارغا ئاتاپ تولۇق كۆيدۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","كاھىننىڭ ھەربىر ئاشلىق ھەدىيەسى بولسا پۈتۈنلەي كۆيدۈرۈلسۇن؛ ئۇ ھەرگىز يېيىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","ھارۇن بىلەن ئوغۇللىرىغا مۇنداق دېگىن: ــ گۇناھ قۇربانلىقى توغرىسىدىكى قائىدە-نىزام مۇنداق: ــ گۇناھ قۇربانلىقىمۇ كۆيدۈرمە قۇربانلىق بوغۇزلىنىدىغان جايدا، پەرۋەردىگارنىڭ ئالدىدا بوغۇزلانسۇن؛ بۇ خىل قۇربانلىق «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","گۇناھ قۇربانلىقىنى ئۆتكۈزگۈچى كاھىن ئۆزى ئۇنى يېسۇن؛ قۇربانلىق مۇقەددەس بىر يەردە، جامائەت چېدىرىنىڭ ھويلىسىدا يېيىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ئۇنىڭ گۆشىگە قول تەگكۈزگۈچى ھەركىم مۇقەددەس بولمىسا بولمايدۇ، شۇنىڭدەك ئەگەر ئۇنىڭ قېنى بىرسىنىڭ كىيىمىگە چاچراپ كەتسە، ئۇنداقتا قان چېچىلغان جاي مۇقەددەس بىر يەردە يۇيۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","قايسى ساپال قازاندا قۇربانلىق قاينىتىلىپ پىشۇرۇلغان بولسا، ئۇ سۇندۇرۇلسۇن. ئەگەر ئۇ مىس قازاندا قاينىتىپ پىشۇرۇلغان بولسا، ئۇ قىرىپ سۈرۈلسۇن ھەم سۇ بىلەن يۇيۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","كاھىنلاردىن بولغان بارلىق ئەر كىشىلەر ئۇنىڭدىن يېسە بولىدۇ. بۇ «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ھالبۇكى، مۇقەددەس جايدا كەفارەت كەلتۈرۈش ئۈچۈن قېنى جامائەت چېدىرىغا كىرگۈزۈلگەن ھەرقانداق گۇناھ قۇربانلىقى بولسا، ھەرگىز يېيىلمىسۇن، بەلكى پۈتۈنلەي كۆيدۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ئىتائەتسىزلىك قۇربانلىقى توغرىسىدىكى قائىدە-نىزام مانا مۇنداق: ــ بۇ قۇربانلىق «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","كۆيدۈرمە قۇربانلىق بوغۇزلىنىدىغان جايدا ئىتائەتسىزلىكنى تىلەش قۇربانلىقىمۇ بوغۇزلىنىدۇ؛ كاھىن قېنىنى قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","قۇربانلىق قىلغۇچى كىشى بارلىق مېيىنى سۇنسۇن؛ يەنى مايلىق قۇيرۇقى بىلەن ئىچ قارنىنى يۆگەپ تۇرغان ماينى، ");
INSERT INTO uigara_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ئىككى بۆرەكنى ۋە ئۇلارنىڭ ئۈستىدىكى ھەمدە ئىككى يانپىشىدىكى ماينى ئاجرىتىپ، جىگەرنىڭ بۆرەككىچە بولغان چاۋا مېيىنى ئاجرىتىپ سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","كاھىن بۇلارنى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىق سۈپىتىدە قۇربانگاھتا كۆيدۈرسۇن. بۇ ئىتائەتسىزلىك قۇربانلىقى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","كاھىنلاردىن بولغان ئەر كىشىلەرنىڭ ھەممىسى بۇنى يېسۇن؛ ئۇ مۇقەددەس يەردە يېيىلسۇن؛ ئۇ «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","گۇناھ قۇربانلىقى قانداق بولسا ئىتائەتسىزلىك قۇربانلىقىمۇ شۇنداق بولىدۇ؛ ئۇلار ئىككىسى توغرىسىدىكى قائىدە-نىزام ئوخشاش؛ بۇ قۇربانلىق كەفارەت كەلتۈرۈشكە قۇربانلىق ئۆتكۈزگۈچى كاھىننىڭ ئۆزىگە تەۋە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","كاھىن بىرسىنىڭ سۇنغان كۆيدۈرمە قۇربانلىقىنى ئۆتكۈزگەن بولسا، كۆيدۈرمە قۇربانلىقنىڭ تېرىسى شۇ كاھىننىڭ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","تونۇردا پىشۇرۇلغان ھەربىر ئاشلىق ھەدىيەسى، شۇنداقلا قازاندا ياكى تاۋىدا ئېتىلگەن ھەربىر ئاشلىق ھەدىيەسى بولسا ئۇنى ئۆتكۈزگەن كاھىننىڭ بولىدۇ، يەنى كاھىننىڭ ئۆزىگە تەۋە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ھەربىر ئاشلىق ھەدىيەسى، مەيلى زەيتۇن مېيى ئارىلاشتۇرۇلغان بولسۇن، ياكى قۇرۇق كەلتۈرۈلگەن بولسۇن، بۇلار ھارۇننىڭ ئوغۇللىرىنىڭ ھەربىرىگە باراۋەر بۆلۈپ بېرىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","پەرۋەردىگارغا ئاتاپ كەلتۈرۈلگەن ئىناقلىق قۇربانلىقى توغرىسىدىكى قائىدە-نىزام مۇنداق: ــ ");
INSERT INTO uigara_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","سۇنماقچى بولغان كىشى ئۇنى تەشەككۈر ئېيتىش ئۈچۈن سۇنسا، ئۇنداقتا ئۇ «تەشەككۈر قۇربانلىقى» بىلەن بىللە زەيتۇن مېيى ئىلەشتۈرۈلگەن پېتىر توقاچلار، زەيتۇن مېيى سۈرۈلۈپ مەسىھلەنگەن پېتىر ھەمەك نانلار ۋە ئېسىل ئۇندىن زەيتۇن مېيىغا چىلاپ پىشۇرۇلغان توقاچلارنىمۇ كەلتۈرسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","شۇ توقاچلاردىن باشقا، يەنە تەشەككۈر ئېيتىدىغان ئىناقلىق قۇربانلىقى بىلەن بىللە ئېچىتقۇ سېلىنغان نانلارنىمۇ سۇنسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ئۇ شۇ سۇنغانلىرىنىڭ ھەربىر تۈرىدىن بىرنى ئېلىپ پەرۋەردىگار ئۈچۈن قوش قوللاپ سۇنىدىغان «كۆتۈرمە ھەدىيە» قىلىپ كەلتۈرسۇن؛ بۇ ئىناقلىق قۇربانلىقىنىڭ قېنىنى قۇربانگاھنىڭ ئۈستىگە سەپكەن كاھىننىڭ ئۆزىگە تەگسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","تەشەككۈر بىلدۈرىدىغان ئىناقلىق قۇربانلىقىنىڭ گۆشى بولسا قۇربانلىق قىلىنغان شۇ كۈنى يېيىلىشى كېرەك؛ قۇربانلىقنى سۇنغۇچى كىشى تاڭ ئاتقۇچە ئۇنىڭ ھېچ نېمىسىنى قالدۇرمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ئەگەر ئۇنىڭ سۇنغان قۇربانلىقى قەسىمىگە خاس قۇربانلىق ياكى ئىختىيارىي كەلتۈرگەن قۇربانلىق بولسا، ئۇنداقتا ھايۋاننىڭ گۆشى قۇربانلىق قىلىنغان كۈندە يېيىلسۇن؛ ئۇنىڭدىن ئېشىپ قالغىنىنى بولسا، ئەتىسىمۇ يېيىشكە بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","لېكىن قۇربانلىقنىڭ گۆشىدىن ئۈچىنچى كۈنىگىچە ئېشىپ قالسا، ئۇ ئوتتا كۆيدۈرۈلۈشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ئىناقلىق قۇربانلىقىنىڭ گۆشىدىن ئۈچىنچى كۈنىدە يېيىلسە، ئۇنداقتا قۇربانلىق قوبۇل بولمايدۇ، قۇربانلىق سۇنغۇچىنىڭ ھېسابىغىمۇ ھېسابلانمايدۇ، بەلكى مەكرۇھ بولىدۇ؛ كىمدەكىم ئۇنىڭدىن يېسە ئۆز قەبىھلىكىنىڭ جازاسىغا تارتىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","شۇنداقلا ناپاك نەرسىگە تېگىپ قالغان گۆشمۇ يېيىلمەسلىكى كېرەك، بەلكى ئوتتا كۆيدۈرۈلۈشى كېرەك. ھەرقانداق پاك ئادەم ناپاك نەرسىگە تەگمىگەن قۇربانلىقنىڭ گۆشىنى يېسە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","لېكىن كىمكى ناپاك ھالەتتە تۇرۇپ پەرۋەردىگارغا ئاتالغان ئىناقلىق قۇربانلىقىدىن يېسە، ئۇنداقتا ئۇ ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","كىمكى ناپاك بىر نەرسىگە تېگىپ كەتسە (مەيلى ناپاك ھالەتتىكى ئادەم بولسۇن، ناپاك بىر ھايۋان بولسۇن ياكى ھەرقانداق ناپاك يىرگىنچلىك نەرسە بولسۇن) ۋە شۇنداقلا پەرۋەردىگارغا خاس ئاتالغان ئىناقلىق قۇربانلىقىنىڭ گۆشىدىن يېسە، ئۇنداقتا ئۇ ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ئىسرائىللارغا مۇنداق دېگىن: ــ سىلەر كالا، قوي ۋە ئۆچكىلەرنىڭ مېيىنى ھەرگىز يېمەڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ئۆزلۈكىدىن ئۆلگەن ياكى يىرتقۇچلار بوغۇپ قويغان ھايۋاننىڭ جەسىتىنىڭ مېيىنى ھەرقانداق ئىشقا ئىشلەتكىلى بولىدۇ، لېكىن ھەرگىز ئۇنىڭدىن يېمەڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","چۈنكى كىمكى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان ھەرقانداق ھايۋاننىڭ مېيىنى يېسە، شۇنى يېگەن كىشى ئۆز خەلقلىرىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","سىلەر ھەرقانداق تۇرار جايىڭلاردا ھېچقانداق قاننى، يەنى ئۇچار-قاناتلارنىڭ بولسۇن ياكى چارپايلارنىڭ بولسۇن قېنىنى ھەرگىز ئېستىمال قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","كىمدەكىم ھەرقانداق قاننى ئېستىمال قىلسا، شۇ كىشى ئۆز خەلقلىرىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ئىسرائىللارغا مۇنداق دېگىن: ــ كىمكى پەرۋەردىگارغا ئاتاپ بىر ئىناقلىق قۇربانلىقى سۇنسا، ئۇنداقتا ئۇ پەرۋەردىگارغا خاس بولغان ھەدىيەنى شۇ ئىناقلىق قۇربانلىقتىن ئايرىپ كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ئۆز قولى بىلەن پەرۋەردىگارغا ئاتىغان، ئوتتا سۇنۇلىدىغان ھەدىيەلەرنى، يەنى ماي بىلەن تۆشنى قوشۇپ ئېلىپ كېلىپ، تۆشنى «پۇلاڭلاتما ھەدىيە» سۈپىتىدە پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","كاھىن مېيىنى قۇربانگاھ ئۈستىدە كۆيدۈرۈۋەتسۇن. تۆش بولسا ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا خاس بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ئىناقلىق قۇربانلىقلىرىڭلارنىڭ ئوڭ ئارقا پۇتىنى سىلەر «كۆتۈرمە ھەدىيە» سۈپىتىدە كاھىنغا بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ھارۇننىڭ ئوغۇللىرىدىن قايسىسى ئىناقلىق قۇربانلىقىنىڭ قېنى بىلەن مېيىنى سۇنغان بولسا ئۆز ئۈلۈشى ئۈچۈن ئوڭ ئارقا پۇتىنى ئۆزى ئالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","چۈنكى مەن ئىسرائىللارنىڭ ئىناقلىق قۇربانلىقلىرىدىن «پۇلاڭلاتما ھەدىيە» بولغان تۆش بىلەن «كۆتۈرمە ھەدىيە» بولغان ئارقا پۇتىنى ئەبەدىي بىر بەلگىلىمە بىلەن ئىسرائىللاردىن ئېلىپ، كاھىن ھارۇن ۋە ئۇنىڭ ئوغۇللىرىنىڭ ھەققى بولسۇن دەپ ئۇلارغا تەقدىم قىلدىم.    ");
INSERT INTO uigara_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","مۇسا ھارۇن بىلەن ئوغۇللىرىنى پەرۋەردىگارنىڭ قۇللۇقىدا كاھىن بولۇشقا ئۇنىڭ ئالدىغا كەلتۈرگەن كۈنىدە، ئۇلارغا پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىقلاردىن تەقدىم قىلىنىدىغان كاھىنلىق ئۈلۈشى مانا شۇدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","مۇسا ئۇلارنى مەسىھلىگەن كۈنىدە، پەرۋەردىگار بۇ ئۈلۈشنى ئىسرائىللاردىن ئېلىپ ئۇلارغا بېرىلسۇن دەپ ئەمر قىلغان. بۇ ئىسرائىللارغا دەۋردىن دەۋرگىچە ئەبەدىي بىر بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","كۆيدۈرمە قۇربانلىق بىلەن ئاشلىق ھەدىيەسى، گۇناھ قۇربانلىقى بىلەن ئىتائەتسىزلىك قۇربانلىقى، كاھىنلىققا تىكلەش قۇربانلىقى بىلەن ئىناقلىق قۇربانلىقى توغرىسىدىكى قائىدە-نىزام مانا شۇدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","پەرۋەردىگار ئىسرائىللارغا: «سىلەر بۇ سىناي باياۋانىدا پەرۋەردىگارنىڭ ئالدىغا قۇربانلىقلىرىڭلارنى سۇنۇڭلار» دەپ بۇيرۇغان كۈنىدە، ئۇ بۇلارنىڭ ھەممىسىنى سىناي تېغىدا مۇساغا تاپشۇرغانىدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","ھارۇننى ئوغۇللىرى بىلەن بىللە، ۋە ئۇلارنىڭ مەخسۇس كىيىملىرىنى، «مەسىھلەش مېيى»نى، گۇناھ قۇربانلىقى بولىدىغان تورپاق بىلەن ئىككى قوچقارنى، پېتىر نان سېلىنغان سېۋەتنى ئېلىپ كېلىپ،    ");
INSERT INTO uigara_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ئىسرائىلنىڭ پۈتۈن جامائىتىنى جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىغا جەم قىلغىن، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","مۇسا پەرۋەردىگار ئۇنىڭغا بۇيرۇغىنىدەك قىلدى، جامائەت جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىغا يىغىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ئاندىن مۇسا جامائەتكە: ــ پەرۋەردىگار بۇيرۇغان ئىش مانا مۇنداق، ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","شۇنىڭ بىلەن مۇسا ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىنى ئالدىغا كەلتۈرۈپ ئۇلارنى سۇ بىلەن يۇيۇپ، ");
INSERT INTO uigara_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ھارۇنغا كۆڭلەك كىيدۈرۈپ، بەلۋاغ باغلاپ، توننى كىيدۈردى ۋە ئۈستىگە ئەفودنى ياپتى؛ ئۇ ئەفودنىڭ بەلۋېغىنى باغلاپ، ئەفودنى ئۇنىڭغا تاقاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ئاندىن مۇسا ئۇنىڭغا «قوشېن»نى تاقاپ، قوشېننىڭ ئىچىگە «ئۇرىم بىلەن تۇممىم»نى سېلىپ،    ");
INSERT INTO uigara_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","بېشىغا سەللە يۆگەپ پەرۋەردىگار ئۇنىڭغا بۇيرۇغىنىدەك سەللىنىڭ ئالدى تەرىپىگە «ئالتۇن تاختىلىق مۇقەددەس ئوتۇغات»نى بېكىتىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ئاندىن مۇسا مەسىھلەش مېيىنى ئېلىپ ئىبادەت چېدىرى بىلەن ئىچىدىكى بارلىق نەرسىلەرنىڭ ھەممىسىنى مەسىھلەپ مۇقەددەس قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ئۇ مايدىن ئېلىپ قۇربانگاھقا يەتتە مەرتىۋە چېچىپ، قۇربانگاھ بىلەن ئۇنىڭ بارچە قاچا-قۇچىلىرىنى، يۇيۇنۇش دېسى ۋە تەگلىكىنى خۇداغا ئاتاپ مۇقەددەس قىلىشقا مەسىھلىدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ئۇ يەنە مەسىھلەش مېيىدىن ئازراق ئېلىپ ھارۇننىڭ بېشىغا قۇيۇپ ئۇنى خۇداغا ئاتاپ مۇقەددەس قىلىشقا مەسىھلىدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ئاندىن مۇسا ھارۇننىڭ ئوغۇللىرىنى ئالدىغا كەلتۈرۈپ، پەرۋەردىگار ئۇنىڭغا بۇيرۇغىنىدەك ئۇلارغا كۆڭلەك كىيدۈرۈپ، بەللىرىگە بەلۋاغ باغلاپ، ئۇلارغا ئېگىز بۆكلەرنىمۇ تاقاپ قويدى.    ");
INSERT INTO uigara_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ئاندىن ئۇ گۇناھ قۇربانلىقى قىلىنىدىغان تورپاقنى يېتىلەپ كەلدى؛ ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى گۇناھ قۇربانلىقى قىلىنىدىغان تورپاقنىڭ بېشىغا قوللىرىنى قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ئۇ ئۇنى بوغۇزلىدى، ئاندىن مۇسا قېنىدىن ئېلىپ، ئۆز بارمىقى بىلەن قۇربانگاھنىڭ مۈڭگۈزلىرىگە، چۆرىسىگە سۈرۈپ قۇربانگاھنى گۇناھتىن پاكلىدى؛ قالغان قاننى بولسا ئۇ قۇربانگاھنىڭ تۈۋىگە تۆكۈپ، مۇقەددەس بولۇشقا كەفارەت كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ئاندىن ئۇ ئىچ قارنىنى يۆگەپ تۇرغان ماينىڭ ھەممىسىنى، جىگەرنىڭ ئۈستىدىكى چاۋا ماينى، ئىككى بۆرەك ۋە ئۈستىدىكى مايلىرىنى قوشۇپ ئالدى؛ ئاندىن مۇسا بۇلارنى قۇربانگاھنىڭ ئۈستىدە كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","بىراق مۇسا تورپاقنىڭ تېرىسى بىلەن گۆشى ۋە تېزىكىنى بولسا پەرۋەردىگار ئۆزىگە بۇيرۇغىنىدەك چېدىرگاھنىڭ تاشقىرىدا ئوتتا كۆيدۈرۈۋەتتى.    ");
INSERT INTO uigara_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ئاندىن ئۇ كۆيدۈرمە قۇربانلىق قىلىنىدىغان قوچقارنى كەلتۈردى؛ ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى قوللىرىنى قوچقارنىڭ بېشىغا قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ھارۇن قوچقارنى بوغۇزلىدى؛ ئاندىن مۇسا قېنىنى ئېلىپ قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپتى؛ ");
INSERT INTO uigara_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ھارۇن قوچقارنى پارچە-پارچە قىلىپ پارچىلىدى؛ ئاندىن مۇسا بېشىنى، پارچىلانغان گۆشلىرىنى بارلىق مېيى بىلەن قوشۇپ كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ئۈچەي-قېرىنلىرى بىلەن پاچاقلىرىنى سۇدا يۇدى. ئاندىن مۇسا قوچقارنى پۈتۈن پېتى قۇربانگاھ ئۈستىدە كۆيدۈردى. بۇ پەرۋەردىگار مۇساغا بۇيرۇغان، «پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان خۇشبۇي چىقىدىغان قۇربانلىق» ئىدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ئاندىن ئۇ كاھىنلىققا تىكلەش قۇربانلىقى قىلىنىدىغان قوچقارنى، ئىككىنچى قوچقارنى كەلتۈردى؛ ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى قوللىرىنى قوچقارنىڭ بېشىغا قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ئۇ ئۇنى بوغۇزلىدى؛ ۋە مۇسا ئۇنىڭ قېنىدىن ئېلىپ ھارۇننىڭ ئوڭ قۇلىقىنىڭ يۇمشىقى بىلەن ئوڭ قولىنىڭ باش بارمىقىغا سۈرۈپ ۋە ئوڭ پۇتىنىڭ چوڭ بارمىقىغىمۇ سۇۋاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ئاندىن مۇسا ھارۇننىڭ ئوغۇللىرىنى ئالدىغا كەلتۈرۈپ، قاندىن ئېلىپ ئۇلارنىڭ ئوڭ قۇلاقلىرىنىڭ يۇمشىقى بىلەن ئوڭ قوللىرىنىڭ باش بارماقلىرىغا سۈردى، ئۇلارنىڭ ئوڭ پۇتلىرىنىڭ چوڭ بارماقلىرىغىمۇ سۇۋاپ قويدى، قالغان قاننى مۇسا قۇربانگاھنىڭ چۆرىسىگە سەپتى. ");
INSERT INTO uigara_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","شۇنداق قىلىپ، ئۇ مېيى بىلەن مايلىق قۇيرۇقىنى، ئىچ قارنىنى يۆگەپ تۇرغان بارلىق ماي بىلەن جىگەرنىڭ ئۈستىدىكى چاۋا مېيىنى، ئىككى بۆرەك ۋە ئۈستىدىكى مايلىرىنى قوشۇپ ئېلىپ ئوڭ ئارقا پۇتىنىمۇ كېسىپ ئېلىپ، ");
INSERT INTO uigara_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","پەرۋەردىگارنىڭ ئالدىدىكى پېتىر نان سېلىنغان سېۋەتتىن بىر پېتىر توقاچ بىلەن بىر زەيتۇن ماي توقىچى ۋە بىر دانە ھەمەك ناننى ئېلىپ بۇلارنى ماي بىلەن ئوڭ ئارقا پۇتنىڭ ئۈستىدە قويدى؛ ");
INSERT INTO uigara_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ئاندىن بۇلارنىڭ ھەممىسىنى ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىنىڭ قوللىرىغا تۇتقۇزۇپ، پۇلاڭلاتما ھەدىيە بولسۇن دەپ پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتتى. ");
INSERT INTO uigara_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ئاندىن مۇسا بۇلارنى ئۇلارنىڭ قوللىرىدىن ئېلىپ قۇربانگاھتىكى كۆيدۈرمە قۇربانلىقنىڭ ئۈستىدە قويۇپ كۆيدۈردى. بۇ «كاھىنلىققا تىكلەش قۇربانلىقى» بولۇپ، پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان، خۇشبۇي چىقىدىغان قۇربانلىق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ئاندىن مۇسا تۆشنى ئېلىپ پۇلاڭلاتما ھەدىيە سۈپىتىدە پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتتى؛ پەرۋەردىگارنىڭ ئۇنىڭغا بۇيرۇغىنى بويىچە، «كاھىنلىققا تىكلەش قۇربانلىقى» بولغان قوچقارنىڭ بۇ قىسمى مۇسانىڭ ئۈلۈشى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ئاندىن مۇسا مەسىھلەش مېيىدىن ۋە قۇربانگاھنىڭ ئۈستىدىكى قاندىن بىرئاز ئېلىپ، ھارۇن بىلەن ئۇنىڭ كىيىملىرىگە ۋە ئوغۇللىرى بىلەن ئۇلارنىڭ كىيىملىرىگە سەپتى. شۇنداق قىلىپ، ئۇ ھارۇن ۋە كىيىملىرىنى، ئوغۇللىرى بىلەن ئۇلارنىڭ كىيىملىرىنى مۇقەددەس قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","مۇسا ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا مۇنداق بۇيرۇدى: ــ «بۇ گۆشنى جامائەت چېدىرىنىڭ كىرىش ئاغزىدا قاينىتىپ پىشۇرۇپ شۇ يەردە ئولتۇرۇپ «كاھىنلىققا تىكلەش قۇربانلىقى»غا تەۋە بولغان سېۋەتتىكى نان بىلەن قوشۇپ يەڭلار؛ بۇلارنى ھارۇن بىلەن ئوغۇللىرى يېسۇن، دەپ بۇيرۇغىنىمدەك ئۇنى يەڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","لېكىن گۆش بىلەن ناندىن ئېشىپ قالغانلىرىنىڭ ھەممىسىنى ئوتتا كۆيدۈرۈۋېتىڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","سىلەر يەتتە كۈنگىچە جامائەت چېدىرىنىڭ كىرىش ئاغزىدىن چىقماي، خۇداغا ئاتاپ كاھىنلىققا تىكلەش كۈنلىرىڭلار توشقۇچە شۇ يەردە تۇرۇڭلار؛ چۈنكى سىلەرنى خۇداغا ئاتاپ كاھىنلىققا تىكلەش ئۈچۈن يەتتە كۈن كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","بۈگۈن قىلىنغان ئىشلار پەرۋەردىگارنىڭ بۇيرۇغىنى بويىچە سىلەر ئۈچۈن كەفارەت كەلتۈرۈلسۇن دەپ قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","سىلەر ئۆلمەسلىكىڭلار ئۈچۈن پەرۋەردىگارنىڭ ئەمرىنى تۇتۇپ جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىدا كېچە-كۈندۈز يەتتە كۈن تۇرۇشۇڭلار كېرەك؛ چۈنكى ماڭا شۇنداق بۇيرۇلدى». ");
INSERT INTO uigara_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ھارۇن بىلەن ئوغۇللىرى پەرۋەردىگارنىڭ مۇسانىڭ ۋاسىتىسى بىلەن بۇيرۇغىنىنىڭ ھەممىسىنى بەجا كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","سەككىزىنچى كۈنى مۇسا ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى ۋە ئىسرائىلنىڭ ئاقساقاللىرىنى چاقىرىپ، ");
INSERT INTO uigara_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ھارۇنغا مۇنداق دېدى: ــ «سەن گۇناھ قۇربانلىقىغا بېجىرىم بىر موزاينى، كۆيدۈرمە قۇربانلىققا بېجىرىم بىر قوچقارنى ئۆزۈڭ ئۈچۈن ئېلىپ، پەرۋەردىگارنىڭ ئالدىغا كەلتۈرگىن، ");
INSERT INTO uigara_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ئاندىن ئىسرائىللارغا سۆز قىلىپ: ــ سىلەر گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە ئېلىپ كېلىڭلار، كۆيدۈرمە قۇربانلىق ئۈچۈن بىر موزاي ۋە بىر قوزا ئېلىپ كېلىڭلار، ھەر ئىككىسى بېجىرىم، بىر ياشقا كىرگەن بولسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","پەرۋەردىگارنىڭ ئالدىدا سۇنۇشقا ئىناقلىق قۇربانلىقى سۈپىتىدە بىر تورپاق بىلەن بىر قوچقارنى ئېلىپ، زەيتۇن مېيى ئىلەشتۈرۈلگەن ئاشلىق ھەدىيەسى بىلەن بىللە كەلتۈرۈڭلار؛ چۈنكى بۈگۈن پەرۋەردىگار ئۆزىنى سىلەرگە ئايان قىلىدۇ، دېگىن». ");
INSERT INTO uigara_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ئۇلار مۇسا بۇيرۇغان نەرسىلەرنى جامائەت چېدىرىنىڭ ئالدىغا ئېلىپ كەلدى؛ پۈتكۈل جامائەت يېقىن كېلىپ، پەرۋەردىگارنىڭ ئالدىدا ھازىر بولۇپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","مۇسا: ــ مانا، بۇ پەرۋەردىگار بۇيرۇغان ئىشتۇر؛ بۇنى قىلساڭلار پەرۋەردىگارنىڭ شان-شەرىپى سىلەرگە ئايان بولىدۇ، دېدى. ");
INSERT INTO uigara_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","شۇنىڭ بىلەن مۇسا ھارۇنغا: ــ سەن قۇربانگاھقا يېقىن بېرىپ گۇناھ قۇربانلىقىڭ بىلەن كۆيدۈرمە قۇربانلىقىڭنى سۇنۇپ ئۆزۈڭ ۋە خەلق ئۈچۈن كەفارەت كەلتۈرگىن؛ ئاندىن خەلقنىڭ قۇربانلىقىنىمۇ سۇنۇپ، پەرۋەردىگار ئەمر قىلغاندەك ئۇلار ھەققىدە كەفارەت كەلتۈرگىن» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","شۇنى دېۋىدى، ھارۇن قۇربانگاھقا يېقىن بېرىپ ئۆزى ئۈچۈن گۇناھ قۇربانلىقى بولىدىغان موزاينى بوغۇزلىدى. ");
INSERT INTO uigara_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ھارۇننىڭ ئوغۇللىرى قاننى ئۇنىڭغا سۇنۇپ بەردى؛ ئۇ بارمىقىنى قانغا تەگكۈزۈپ، قۇربانگاھنىڭ مۈڭگۈزلىرىگە سۈردى، قالغان قاننى قۇربانگاھنىڭ تۈۋىگە قۇيدى. ");
INSERT INTO uigara_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","گۇناھ قۇربانلىقىنىڭ مېيى بىلەن ئىككى بۆرەك ۋە جىگەرنىڭ ئۈستىدىكى چاۋا ماينى ئېلىپ، پەرۋەردىگار مۇساغا بۇيرۇغىنىدەك ئۇلارنى قۇربانگاھ ئۈستىدە كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","گۆش بىلەن تېرىسىنى بولسا چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقىپ ئوتتا كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ئاندىن ئۇ كۆيدۈرمە قۇربانلىق قىلىدىغان قوچقارنى بوغوزلىدى؛ ھارۇننىڭ ئوغۇللىرى ئۇنىڭغا قاننى سۇنۇپ بەردى؛ ئۇ بۇنى قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپتى. ");
INSERT INTO uigara_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ئاندىن ئۇلار پارچە-پارچە قىلىنغان كۆيدۈرمە قۇربانلىقنى بېشى بىلەن بىللە ئۇنىڭغا سۇنۇپ بەردى؛ ئۇ بۇلارنى قۇربانگاھتا كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ئۇ ئىچ قارنى بىلەن پاچاقلىرىنى يۇيۇپ، بۇلارنىمۇ قۇربانگاھنىڭ ئۈستىدە، كۆيدۈرمە قۇربانلىقنىڭ ئۈستىگە قويۇپ كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ئاندىن ئۇ خەلقنىڭ قۇربانلىقىنى كەلتۈردى؛ خەلقنىڭ گۇناھ قۇربانلىقى بولغان تېكىنى بوغۇزلاپ، ئىلگىرى ھايۋاننى سۇنغاندەك ئۇنىمۇ گۇناھ قۇربانلىقى قىلىپ سۇندى. ");
INSERT INTO uigara_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ئۇ كۆيدۈرمە قۇربانلىق قىلىدىغان مالنى كەلتۈرۈپ بۇنىمۇ بەلگىلىمە بويىچە سۇندى. ");
INSERT INTO uigara_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ئاندىن ئۇ ئاشلىق ھەدىيەسىنى كەلتۈرۈپ ئۇنىڭدىن بىر چاڭگال ئېلىپ ئەتىگەنلىك كۆيدۈرمە قۇربانلىققا قوشۇپ قۇربانگاھ ئۈستىدە كۆيدۈردى.    ");
INSERT INTO uigara_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ئاندىن خەلققە بولىدىغان ئىناقلىق قۇربانلىقى بولىدىغان تورپاق بىلەن قوچقارنى بوغۇزلىدى. ھارۇننىڭ ئوغۇللىرى قېنىنى ئۇنىڭغا سۇنۇپ بەردى؛ ئۇ بۇنى قۇربانگاھنىڭ ئۈستى قىسمىنىڭ ئەتراپىغا سەپتى. ");
INSERT INTO uigara_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ئۇلار تورپاق بىلەن قوچقارنىڭ ماي قىسمىنى، يەنى مايلىق قۇيرۇقى، ئىچ قارنىنى يۆگەپ تۇرغان مايلىرىنى، ئىككى بۆرەك ۋە جىگەرنىڭ چاۋا مېيىنى ئېلىپ، ");
INSERT INTO uigara_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","بۇ ماي پارچىلىرىنى ئىككى تۆشنىڭ ئۈستىدە قويدى، ھارۇن بۇلارنى قۇربانگاھنىڭ ئۈستىدە كۆيدۈردى. ");
INSERT INTO uigara_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ئاخىرىدا ھارۇن ئىككى تۆش بىلەن ئوڭ ئارقا پۇتىنى پۇلاڭلاتما ھەدىيە سۈپىتىدە مۇسانىڭ بۇيرۇغىنىدەك پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتتى. ");
INSERT INTO uigara_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ئاندىن ھارۇن قوللىرىنى خەلققە قارىتىپ كۆتۈرۈپ، ئۇلارغا بەخت تىلىدى؛ ئۇ گۇناھ قۇربانلىقى، كۆيدۈرمە قۇربانلىق ۋە ئىناقلىق قۇربانلىقىنى سۇنۇپ، قۇربانگاھتىن چۈشتى. ");
INSERT INTO uigara_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","مۇسا بىلەن ھارۇن جامائەت چېدىرىغا كىرىپ، يەنە يېنىپ چىقىپ خەلققە بەخت تىلىدى؛ شۇنىڭ بىلەن پەرۋەردىگارنىڭ شان-شەرىپى پۈتكۈل خەلققە ئايان بولدى؛ ");
INSERT INTO uigara_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","پەرۋەردىگارنىڭ ئالدىدىن ئوت چىقىپ، قۇربانگاھ ئۈستىدىكى كۆيدۈرمە قۇربانلىق بىلەن مايلارنى يۇتۇپ كەتتى. پۈتكۈل خەلق بۇنى كۆرۈپ، توۋلىشىپ، دۈم يىقىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ھارۇننىڭ ئوغۇللىرى ناداب بىلەن ئابىھۇ ئىككىسى ئۆز خۇشبۇيدانىنى ئېلىپ ئۇنىڭغا ئوت يېقىپ ئۈستىگە خۇشبۇينى سېلىپ، پەرۋەردىگار ئۇلارغا بۇيرۇپ باقمىغان غەيرىي بىر ئوتنى پەرۋەردىگارغا سۇندى؛ ");
INSERT INTO uigara_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","شۇنىڭ بىلەن پەرۋەردىگارنىڭ ئالدىدىن ئوت چىقىپ ئۇلارنى يەۋەتتى؛ شۇئان ئۇلار پەرۋەردىگارنىڭ ئالدىدا ئۆلدى. ");
INSERT INTO uigara_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","مۇسا ھارۇنغا: ــ مانا، بۇ پەرۋەردىگارنىڭ: «مەن ماڭا يېقىن كەلگەن ئادەملەردە ئۆزۈمنىڭ مۇقەددەس ئىكەنلىكىمنى كۆرسىتىمەن ۋە بارلىق خەلقنىڭ ئالدىدا ئۇلۇغلىنىمەن» دېگەن سۆزىنىڭ ئۆزىدۇر، دېدى. شۇنى دېۋىدى، ھارۇن جىم تۇرۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","مۇسا ھارۇننىڭ تاغىسى ئۇززىئەلنىڭ ئوغۇللىرى بولغان مىشائەل بىلەن ئەلزافاننى چاقىرىپ ئۇلارغا: ــ سىلەر يېقىن كېلىپ ئۆز قېرىنداشلىرىڭلارنى مۇقەددەس جاينىڭ ئالدىدىن كۆتۈرۈپ، چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقىڭلار» ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","شۇنىڭ بىلەن ئۇلار يېقىن كېلىپ، ئۇلارنى كىيىكلىك كۆڭلەكلىرى بىلەن كۆتۈرۈپ مۇسانىڭ بۇيرۇغىنىدەك چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","مۇسا ھارۇن ۋە ئوغۇللىرى ئەلىئازار بىلەن ئىتامارغا: ــ سىلەر باشلىرىڭلارنى ئوچۇق قويماڭلار، كىيىملىرىڭلارنى يىرتماڭلار؛ بولمىسا ئۆزۈڭلار ئۆلۈپ، پۈتكۈل جامائەتكە غەزەپ كەلتۈرىسىلەر؛ لېكىن قېرىنداشلىرىڭلار بولغان پۈتكۈل ئىسرائىل جەمەتى پەرۋەردىگار ياققان ئوت تۈپەيلىدىن ماتەم تۇتۇپ يىغلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ئەمما سىلەر بولساڭلار پەرۋەردىگارنىڭ مەسىھلەش مېيى ئۈستۈڭلارغا سۈرۈلگەن بولغاچقا، جامائەت چېدىرىنىڭ تاشقىرىغا چىقماڭلار؛ بولمىسا ئۆلىسىلەر، دېدى. شۇنى دېۋىدى، ئۇلار مۇسانىڭ بۇيرۇغىنىدەك قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","پەرۋەردىگار ھارۇنغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«سەن ئۆزۈڭ ۋە ئوغۇللىرىڭ شاراب ۋە يا باشقا كۈچلۈك ھاراقلارنى ئىچىپ، جامائەت چېدىرىغا ھەرگىز كىرمەڭلار؛ بولمىسا، ئۆلۈپ كېتىسىلەر. بۇ سىلەر ئۈچۈن دەۋردىن-دەۋرگە ئەبەدىي بىر بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","شۇنداق قىلساڭلار، مۇقەددەس بىلەن ئادەتتىكىنى، پاك بىلەن ناپاكنى پەرق ئېتىپ ئاجرىتالايدىغان بولىسىلەر؛ ");
INSERT INTO uigara_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","شۇنداقلا پەرۋەردىگار مۇسانىڭ ۋاسىتىسى بىلەن ئىسرائىللارغا تاپشۇرغان ھەممە بەلگىلىمىلەرنى ئۇلارغا ئۆگىتەلەيسىلەر». ");
INSERT INTO uigara_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","مۇسا ھارۇن ۋە ئۇنىڭ تىرىك قالغان ئوغۇللىرى ئەلىئازار بىلەن ئىتامارغا مۇنداق دېدى: ــ «سىلەر پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىق-ھەدىيەلەردىن ئېشىپ قالغان ئاشلىق ھەدىيەسىنى ئېلىپ ئۇنى قۇربانگاھنىڭ يېنىدا ئېچىتقۇ ئارىلاشتۇرمىغان ھالدا يەڭلار؛ چۈنكى ئۇ «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","بۇ پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان نەرسىلەردىن سېنىڭ نېسىۋەڭ ۋە ئوغۇللىرىڭنىڭ نېسىۋىسى بولغاچقا، ئۇنى مۇقەددەس جايدا يېيىشىڭلار كېرەك؛ چۈنكى ماڭا شۇنداق بۇيرۇلغاندۇر. ");
INSERT INTO uigara_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ئۇنىڭدىن باشقا پۇلاڭلاتما ھەدىيە قىلىنغان تۆش بىلەن كۆتۈرمە ھەدىيە قىلىنغان ئارقا پۇتنى سەن ۋە ئوغۇل-قىزلىرىڭ بىللە پاك بىر جايدا يەڭلار؛ چۈنكى بۇلار سېنىڭ نېسىۋەڭ بىلەن ئوغۇللىرىڭنىڭ نېسىۋىسى بولسۇن دەپ، ئىسرائىللارنىڭ ئىناقلىق قۇربانلىقلىرىدىن سىلەرگە بېرىلگەن. ");
INSERT INTO uigara_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ئۇلار كۆتۈرمە ھەدىيە قىلىنغان ئارقا پۇت بىلەن پۇلاڭلاتما ھەدىيە قىلىنغان تۆشنى ئوتتا سۇنۇلىدىغان مايلىرى بىلەن قوشۇپ، پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتما ھەدىيە سۈپىتىدە پۇلاڭلىتىش ئۈچۈن كەلتۈرسۇن؛ پەرۋەردىگارنىڭ بۇيرۇغىنى بويىچە بۇلار سېنىڭ ۋە ئوغۇللىرىڭنىڭ نېسىۋىسى بولىدۇ؛ بۇ ئەبەدىي بىر بەلگىلىمە بولىدۇ». ");
INSERT INTO uigara_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ئاندىن مۇسا گۇناھ قۇربانلىقى قىلىدىغان تېكىنى ئىزدىۋىدى، مانا ئۇ ئاللىقاچان كۆيدۈرۈلۈپ بولغانىدى. بۇ سەۋەبتىن ئۇ ھارۇننىڭ تىرىك قالغان ئىككى ئوغلى ئەلىئازار بىلەن ئىتامارغا ئاچچىقلىنىپ: ");
INSERT INTO uigara_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","ــ نېمىشقا سىلەر گۇناھ قۇربانلىقىنىڭ گۆشىنى مۇقەددەس جايدا يېمىدىڭلار؟ چۈنكى ئۇ «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىناتتى، پەرۋەردىگار سىلەرنى جامائەتنىڭ گۇناھىنى كۆتۈرۈپ ئۇلار ئۈچۈن ئۇنىڭ ئالدىدا كەفارەت كەلتۈرسۇن دەپ، شۇنى سىلەرگە تەقسىم قىلغانىدى. ");
INSERT INTO uigara_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","مانا، ئۇنىڭ قېنى مۇقەددەس جاينىڭ ئىچىگە كەلتۈرۈلمىدى؛ سىلەر ئەسلىدە مەن بۇيرۇغاندەك ئۇنى مۇقەددەس جايدا يېيىشىڭلار كېرەك ئىدى، ــ دېدى.    ");
INSERT INTO uigara_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","لېكىن ھارۇن مۇساغا: ــ مانا، بۇلار بۈگۈن توغرا ئىش قىلىپ ئۆزلىرىنىڭ گۇناھ قۇربانلىقى بىلەن كۆيدۈرمە قۇربانلىقىنى پەرۋەردىگارنىڭ ئالدىدا سۇندى؛ مېنىڭ بېشىمغا شۇ ئىشلار كەلدى؛ ئەگەر مەن بۈگۈن گۇناھ قۇربانلىقىنىڭ گۆشىنى يېگەن بولسام، پەرۋەردىگارنىڭ نەزىرىدە ئوبدان بولاتتىمۇ؟ ــ دېدى. ");
INSERT INTO uigara_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","مۇسا بۇنى ئاڭلاپ جاۋابىدىن رازى بولدى. ");
INSERT INTO uigara_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","پەرۋەردىگار مۇسا بىلەن ھارۇنغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","ئىسرائىللارغا مۇنداق دېگىن: ــ يەر يۈزىدىكى بارلىق ھايۋانلارنىڭ ئىچىدىن سىلەرگە يېيىشكە بولىدىغان جانىۋارلار شۇكى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ھايۋانلار ئىچىدە ھەم تۇياقلىرى پۈتۈن ئاچىماق (تۇياقلىرى پۈتۈنلەي يېرىق) ھەم كۆشىگۈچى ھايۋانلارنىڭ ھەربىرىنى يېسەڭلار بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","لېكىن كۆشىگۈچى ياكى ئاچىماق تۇياقلىق ھايۋانلاردىن تۆۋەندىكىلەرنى يېمەسلىكىڭلار كېرەك: ــ تۆگە: چۈنكى ئۇ كۆشىگىنى بىلەن تۇيىقى ئاچىماق ئەمەس. شۇڭا ئۇ سىلەرگە ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","سۇغۇر بولسا كۆشىگىنى بىلەن تۇيىقى ئاچىماق ئەمەس ــ ئۇ سىلەرگە ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","توشقان بولسا بۇمۇ كۆشىگىنى بىلەن تۇيىقى ئاچىماق ئەمەس ــ ئۇ سىلەرگە ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","چوشقا بولسا تۇياقلىرى ئاچىماق (تۇياقلىرى پۈتۈنلەي يېرىق) بولغىنى بىلەن كۆشىمىگىنى ئۈچۈن سىلەرگە ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","سىلەر شۇ ھايۋانلارنىڭ گۆشىدىن يېمەسلىكىڭلار كېرەك ۋە ئۇلارنىڭ ئۆلۈكىگىمۇ تەگمەڭلار. ئۇلار بولسا سىلەرگە ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","سۇدا ياشايدىغان جانىۋارلاردىن تۆۋەندىكىلەرنى يېيىشكە بولىدۇ: ــ سۇدىكى، يەنى دەريا-دېڭىزلاردىكى جانىۋارلاردىن قانىتى ۋە قاسىراقلىرى بولغانلارنى يېيىشكە بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","لېكىن دەريا-دېڭىزلاردا ياشايدىغان، يەنى سۇلاردا توپ-توپ ئۈزىدىغان بارلىق جانىۋارلاردىن، قاسىراقلىرى ياكى قانىتى بولمىغانلىرىنى يېمەسلىكىڭلار كېرەك؛ ئۇلار سىلەرگە يىرگىنچلىك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","مەزكۇر جانىۋارلار دەرۋەقە سىلەرگە يىرگىنچلىك سانالسۇن؛ سىلەر ئۇلارنىڭ گۆشىدىن يېمەسلىكىڭلار كېرەك؛ ئۇلارنىڭ ئۆلۈكىنى يىرگىنچلىك دەپ قاراڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","سۇدىكى جانىۋارلارنىڭ ئىچىدىن قانىتى بىلەن قاسىرىقى بولمىغان جانىۋارلارنىڭ ھەممىسى سىلەرگە يىرگىنچلىك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ئۇچار-قاناتلاردىن تۆۋەندىكىلەر سىلەرگە يىرگىنچلىكتۇر؛ ئۇلار يېيىلمەسلىكى كېرەك ۋە سىلەرگە يىرگىنچلىك بولسۇن: ــ يەنى بۈركۈت، قورۇلتاز-تاپقۇشلار، دېڭىز بۈركۈتى، ");
INSERT INTO uigara_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","قارلىغاچ قۇيرۇقلۇق سار، لاچىن ۋە ئۇلارنىڭ خىللىرى، ");
INSERT INTO uigara_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ھەممە قاغا-قوزغۇنلار ۋە ئۇلارنىڭ خىللىرى، ");
INSERT INTO uigara_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","مۈشۈكياپىلاق، تۆگىقۇش، چايكا، سار ۋە ئۇلارنىڭ خىللىرى، ");
INSERT INTO uigara_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ھۇۋقۇش، قارنا، ئىبىس، ");
INSERT INTO uigara_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ئاققۇ، ساقىيقۇش، بېلىقئالغۇچ، ");
INSERT INTO uigara_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","لەيلەك، تۇرنا ۋە ئۇنىڭ خىللىرى، ھۆپۈپ ۋە شەپەرەڭ قاتارلىقلار سىلەرگە ھارام سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","بۇنىڭدىن باشقا تۆت پۇتلاپ ماڭىدىغان، ئۇچىدىغان ئۇششاق جانىۋارلارنىڭ ھەممىسى سىلەرگە يىرگىنچلىك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ھالبۇكى، تۆت پۇتلاپ ماڭىدىغان، ئۇچىدىغان ئۇششاق جانىۋارلاردىن تۆۋەندىكىلەرنى يېسەڭلار بولىدۇ: ــ پۇتى بىلەن ئۈگىلىك پاچىقى بولۇپ، يەر يۈزىدە سەكرىيەلەيدىغانلارنى يېسەڭلار بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","بۇلارنىڭ ئىچىدىن سىلەرگە يېيىشكە بولىدىغانلىرى: ــ چېكەتكە ۋە ئۇنىڭ خىللىرى، قارا چېكەتكە ۋە ئۇنىڭ خىللىرى، تومۇزغا ۋە ئۇنىڭ خىللىرى، چاقچىقىز ۋە ئۇنىڭ خىللىرى. ");
INSERT INTO uigara_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","لېكىن تۆت پۇتلۇق بولغان ئۆمىلىگۈچى ھەم ئۇچىدىغان ھەممە باشقا جانىۋارلار سىلەرگە يىرگىنچلىك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","بۇ جانىۋارلاردىنمۇ مۇنداق يول بىلەن ناپاك بولىسىلەر؛ بىركىم ئۇلارنىڭ ئۆلۈك تېنىگە تەگسە كەچ كىرگۈچە ناپاك ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","كىمدەكىم بۇلارنىڭ ئۆلۈكىنىڭ بىر قىسمىنى كۆتۈرسە ئۆز كىيىملىرىنى يۇيۇشى كېرەك، ئۇ كىشى كەچ كىرگۈچە ناپاك ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","تۇياقلىرى ئاچىماق، بىراق پۈتۈنلەي بۆلۈنمىگەن ياكى كۆشىمەيدىغان ھايۋانلارنىڭ ھەممىسى سىلەرگە ھارامدۇر؛ ھەركىم ئۇلارنىڭ ئۆلۈكىگە تەگسە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","تۆت پۇتى بىلەن ماڭىدىغان ھايۋانلارنىڭ ئىچىدىن تاپىنى بىلەن ماڭىدىغانلارنىڭ ھەممىسى سىلەرگە ناپاك بولۇپ، ھەركىم ئۇلارنىڭ ئۆلۈك تەنلىرىگە تەگسە كەچ كىرگۈچە ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","كىمكى ئۇلارنىڭ ئۆلۈكىنى كۆتۈرسە ئۆز كىيىملىرىنى يۇيۇشى كېرەك، ئۇ كىشى كەچ كىرگۈچە ناپاك تۇرىدۇ. بۇ ھايۋانلار بولسا سىلەرگە ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","يەر يۈزىدە ئۆمىلىگۈچى ئۇششاق جانىۋارلارنىڭ ئىچىدىن سىلەرگە ھارام بولغانلار مۇنۇلار: ــ قارىغۇ زوكور، چاشقان، كەسلەنچۈك ۋە ئۇلارنىڭ تۈرلىرى، ");
INSERT INTO uigara_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","سالما، قىزىل كەسلەنچۈك، تام كەسلەنچۈكى، تۈگۈرۈك كەسلەنچۈك ۋە خامېلېئون قاتارلىقلار ھارام بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","بۇلارنىڭ ھەممىسى يەر يۈزىدە ئۆمىلىگۈچى ھەممە ئۇششاق جانىۋارلارنىڭ ئىچىدە سىلەرگە ھارام بولىدۇ؛ ئۇلارنىڭ ئۆلۈكىگە تەگسە، كەچ كىرگۈچە ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","بۇ جانىۋارلارنىڭ ئۆلۈكى ھەرقانداق نېمىگە چۈشۈپ قالسا شۇ نېمە ناپاك ھېسابلىنىدۇ ــ ھەرقانداق ياغاچ قاچا-قۇچا بولسۇن، كىيىم بولسۇن، تېرە بولسۇن، تاغار بولسۇن، ھەرقانداق ئىشقا ئىشلىتىلىدىغان ئەسۋاب بولسۇن، سۇغا چىلىنىشى كېرەك؛ ئۇلار كەچ كىرگۈچە ناپاك سانىلىپ، كېيىن پاك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","بۇلارنىڭ بىرى ساپالدىن ياسالغان ھەرقانداق قاچا ئىچىگە چۈشۈپ قالسا، شۇ قاچا ئىچىدىكى ھەممە نەرسە ناپاك سانالسۇن ۋە قاچا ئۆزى سۇندۇرۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ئەگەر قاچىدىكى سۇدىن ئاش-تائام ئۈستىگە چاچراپ كەتسە، ئاش-تائام ناپاك سانالسۇن ۋە شۇنداقلا قاچىدىكى ھەرقانداق ئىچىملىكمۇ ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ھەرنېمىگە ئۇنداق ئۆلۈكنىڭ بىرەر قىسمى چۈشۈپ قالسىمۇ، ناپاك سانالسۇن. ئەگەر تونۇر ۋە ئوچاق بولسا، ناپاك بولدى دەپ چېقىۋېتىلسۇن؛ ئۇلار سىلەرگە ھارام بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","لېكىن شۇنداق ئەھۋالدا بۇلاق ياكى سۇ يىغىلىدىغان كۆلچەك يەنىلا پاك سانىلىدۇ؛ ئەمما بىركىم ئۇلارنىڭ ئۆلۈك تېنىگە تەگسە ناپاك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ئەگەر ئۇنداق ئۆلۈكنىڭ بىرەر قىسمى تېرىشقا تەييارلانغان دانلارغا چۈشۈپ قالسا، بۇمۇ يەنىلا پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لېكىن ئەگەر داننىڭ ئۈستىگە سۇ قۇيۇلغاندىن كېيىن شۇنداق بىر ئۆلۈكنىڭ بىرەر قىسمى چۈشۈپ قالسا، ئۇنداقتا بۇ دانلار سىلەرگە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ئەگەر سىلەرگە يېيىشكە بولىدىغان ھايۋانلاردىن بىرى ئۆلۈپ قالسا، ئۇنىڭ ئۆلۈكىگە تەگكەن كىشى كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","كىمكى ئۇنداق ئۆلۈكنىڭ گۆشىدىن يېسە، ئۆز كىيىملىرىنى يۇيۇشى كېرەك ۋە كەچ كىرگۈچە ناپاك سانالسۇن؛ شۇنداقلا ئۇنداق بىر ئۆلۈكنى كۆتۈرگەن كىشىمۇ كىيىملىرىنى يۇيۇشى كېرەك ۋە ئۇ كىشى كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","يەر يۈزىدە ئۆمىلىگۈچى ھەممە ئۇششاق جانىۋارلار يىرگىنچلىك سانىلىپ، ھەرگىز يېيىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","قورسىقى بىلەن بېغىرلاپ ماڭىدىغان جانىۋار بولسۇن، يەر يۈزىدە يۈرۈپ تۆت پۇتى بىلەن ياكى كۆپ پۇتلىرى بىلەن ماڭىدىغان ئۆمىلىگۈچى جانىۋارلارنىڭ ھەرتۈرلۈكىنى بولسا، ئۇلارنى ھەرگىز يېمەڭلار؛ چۈنكى ئۇلار يىرگىنچلىكتۇر. ");
INSERT INTO uigara_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","سىلەر بولساڭلار مۇنداق ئۆمىلىگۈچى جانىۋارنىڭ سەۋەبىدىن ئۆزۈڭلارنى يىرگىنچلىك قىلماسلىقىڭلار كېرەك. ئۆزۈڭلارنى ئۇلار تۈپەيلىدىن ناپاك قىلماڭلار، بولمىسا ئۇلارنىڭ سەۋەبىدىن بۇلغىنىپ قالىسىلەر؛ ");
INSERT INTO uigara_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","چۈنكى مەن خۇدايىڭلاردۇرمەن. سىلەر ئۆزۈڭلارنى ئۆزۈمگە ئاتاپ مۇقەددەس قىلىشىڭلار كېرەك؛ مەن ئۆزۈم مۇقەددەس بولغاچ سىلەرمۇ ئۆزۈڭلارنى مۇقەددەس تۇتۇشۇڭلار كېرەك. سىلەر ئۆزۈڭلارنى يەر يۈزىدە ئۆمىلىگۈچى ئۇششاق ھەرقانداق جانىۋارلارنىڭ سەۋەبىدىن ناپاك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","چۈنكى مەن ئۆز خۇدايىڭلار بولۇشقا سىلەرنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن پەرۋەردىگاردۇرمەن؛ سىلەر مۇقەددەس بولۇڭلار، چۈنكى مەن مۇقەددەستۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","شۇلار بولسا چارپاي بىلەن ئۇچار-قاناتلار، سۇدا يۈرىدىغان ھەربىر جانىۋار بىلەن يەر يۈزىدە ئۆمىلىگۈچى ھەربىر ئۇششاق جانىۋارلار توغرىسىدىكى قانۇن-بەلگىلىمىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","بۇلار بىلەن ھارام-ھالالنى ئۇقۇپ، يېيىشكە بولىدىغان ھايۋان بىلەن يېيىشكە بولمايدىغان ھايۋانلارنى پەرق ئېتەلەيسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","ئىسرائىللارغا سۆز قىلىپ مۇنداق دېگىن: ــ «ئايال كىشى ھامىلىدار بولۇپ ئوغۇل تۇغسا، ئادەت كۆرۈپ ئاغرىق بولغان كۈنلىرىدىكىدەك يەتتە كۈنگىچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","سەككىزىنچى كۈنى ئوغلى بولسا خەتنە قىلىنسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ئايال بولسا شۇنىڭدىن كېيىن ئوتتۇز ئۈچ كۈنگىچە «قان پاكلىنىش»تا تۇرسۇن؛ پاكلىنىش كۈنلىرى تامام بولمىغۇچە ھېچبىر مۇقەددەس نەرسىگە تەگمىسۇن، مۇقەددەس جايغىمۇ كىرمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ئەگەر ئۇ قىز تۇغسا ئۇنداقتا ئادەت كۈنلىرىدىكىدەك ئىككى ھەپتىگىچە ناپاك تۇرۇپ، ئاندىن ئاتمىش ئالتە كۈنگىچە «قان پاكلىنىش»تا تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","مەيلى ئوغۇل ياكى قىز تۇغسۇن، قان پاكلىنىش كۈنلىرى تامام بولغاندىن كېيىن ئۇ ئايال كۆيدۈرمە قۇربانلىق ئۈچۈن بىر ياشقا كىرگەن قوزىنى، گۇناھ قۇربانلىقى ئۈچۈن بىر باچكا ياكى پاختەكنى ئېلىپ جامائەت چېدىرىنىڭ كىرىش ئاغزىغا، كاھىننىڭ قېشىغا كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","كاھىن ئۇنى پەرۋەردىگارنىڭ ئالدىدا سۇنۇپ، شۇ ئايال ئۈچۈن كەفارەت كەلتۈرىدۇ؛ شۇنىڭ بىلەن ئۇ خۇنىدىن پاك بولىدۇ. ئوغۇل ياكى قىز تۇغقان ئايال توغرىسىدىكى قانۇن-بەلگىلىمە مانا شۇدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ئەگەر ئۇنىڭ قوزىغا قۇربى يەتمىسە، ئۇ ئىككى پاختەك ياكى ئىككى باچكا كەلتۈرسۇن؛ ئۇلارنىڭ بىرى كۆيدۈرمە قۇربانلىق ئۈچۈن، يەنە بىرى گۇناھ قۇربانلىقى ئۈچۈن بولىدۇ؛ شۇ يول بىلەن كاھىن ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرىدۇ؛ ئۇ ئايال پاك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","بىرسىنىڭ بەدىنىنىڭ تېرىسىدە بىر چىقان، ياكى تەمرەتكە ياكى پارقىراق تاشما چىقىپ، ئۇنىڭدىن بەدىنىنىڭ تېرىسىدە پېسە-ماخاۋ كېسىلىنىڭ جاراھىتى پەيدا بولغان بولسا، ئۇ كىشى ھارۇن كاھىننىڭ ياكى ئۇنىڭ كاھىن ئوغۇللىرىدىن بىرىنىڭ قېشىغا كەلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","كاھىن ئۇنىڭ بەدىنىنىڭ جاراھىتىگە قارايدۇ؛ جاراھەت بولغان جاينىڭ تۈكى ئاقىرىپ كەتكەن ھەمدە جاراھەتمۇ ئەتراپىدىكى تېرىدىن قېنىقراق كۆرۈنسە، بۇ پېسە-ماخاۋ كېسەللىكىدۇر. شۇڭا كاھىن ئۇنى كۆرگەندىن كېيىن شۇ كىشىنى «ناپاك» دەپ جاكارلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","لېكىن ئەگەر ئۇنىڭ بەدىنىنىڭ تېرىسىدىكى پەيدا بولغان ئاشۇ يالتىراق چىقان ئاق بولۇپ، ئەتراپىدىكى تېرىدىن قېنىقراق كۆرۈنمىسە ۋە تۈكىمۇ ئاقىرىپ كەتمىگەن بولسا، كاھىن بۇ جاراھەت بار كىشىنى يەتتە كۈنگىچە ئايرىم سولاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","يەتتىنچى كۈنى كاھىن ئۇنىڭغا قارىسۇن ۋە ئەگەر جاراھەت ئوخشاش تۇرۇپ، تېرىسىدە كېڭىيىپ كەتمىگەن بولسا، كاھىن ئۇنى يەنە يەتتە كۈنگىچە ئايرىم سولاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","يەتتىنچى كۈنى كاھىن ئۇنىڭغا يەنە قارىسۇن ۋە جاراھەتنىڭ رەڭگى سۇسلاشقان ۋە كېڭىيىپ كەتمىگەن بولسا، ئۇنداقتا كاھىن ئۇنى «پاك» دەپ جاكارلىسۇن؛ جاراھەتنىڭ پەقەت بىر چاقا ئىكەنلىكى بېكىتىلىپ، كېسەل كىشى ئۆز كىيىملىرىنى يۇيۇپ پاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","لېكىن ئەگەر ئۇ كاھىنغا كۆرۈنۈپ «پاك» دەپ جاكارلانغاندىن كېيىن شۇ چاقا تېرىسىدە كېڭىيىپ كەتسە، ئۇنداقتا ئۇ يەنە بىر قېتىم كاھىنغا كۆرۈنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","كاھىن ئۇنىڭغا يەنە قارىسۇن ۋە ئەگەر چاقا ئۇنىڭ تېرىسىدە كېڭىيىپ كەتكەن بولسا، كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن؛ ئۇ جاراھەت پېسە-ماخاۋدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","ئەگەر بىركىمدە پېسە-ماخاۋ جاراھىتى پەيدا بولۇپ قالسا كاھىننىڭ قېشىغا كەلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","كاھىن ئۇنىڭ جاراھىتىگە سەپسېلىپ قارىسۇن؛ ۋە ئەگەر تېرىسىدە ئاق بىر چىقان پەيدا بولغان، تۈكى ئاقىرىپ كەتكەن بولسا ۋە چىقان چىققان جايدا ئەت-گۆشى كۆرۈنۈپ قالغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","بۇ ئۇنىڭ بەدىنىنىڭ تېرىسىگە چۈشكەن كونا پېسە-ماخاۋ جاراھىتىنىڭ قايتىدىن قوزغىلىشى بولۇپ، كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن. ئۇ ناپاك بولغىنى ئۈچۈن ئۇنى سولاشنىڭ ھاجىتى يوق. ");
INSERT INTO uigara_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","لېكىن ئەگەر پېسە-ماخاۋ قوزغىلىپ، جاراھىتى بار كىشىنىڭ تېرىسىگە يېيىلىپ كەتكەن بولسا، كاھىن نەگىلا قارىسا شۇ يەردە شۇ «پېسە-ماخاۋ» بولسا، تېرىسىنى بېشىدىن پۇتىغىچە قاپلاپ كەتكەن بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ئۇنداقتا كاھىن ئۇنىڭغا سەپسېلىپ قارىسۇن؛ مانا، شۇ پېسە-ماخاۋ جاراھىتى پۈتۈن بەدىنىنى قاپلاپ كەتكەن بولسا، ئۇ جاراھىتى بار كىشىنى «پاك» دەپ جاكارلىسۇن؛ چۈنكى ئۇنىڭ پۈتۈن بەدىنى ئاقىرىپ كەتكەن بولۇپ، ئۇ «پاك» دەپ سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لېكىن قاچانىكى ئۇنىڭدا ئەت-گۆشى كۆرۈنۈپ قالسا، ئۇ كىشى ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","كاھىن مۇنداق كۆرۈنگەن ئەت-گۆشىگە قاراپ، ئۇ كىشىنى «ناپاك» دەپ جاكارلىسۇن؛ چۈنكى شۇ ئەت-گۆش ناپاك بولۇپ، ئۇ پېسە-ماخاۋ كېسىلىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ھالبۇكى، ئەگەر ئەت-گۆشى قايتىدىن ئۆزگىرىپ، ئاقارسا ئۇ كىشى يەنە كاھىننىڭ قېشىغا كەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","كاھىن ئۇنىڭغا سەپسېلىپ قارىسۇن؛ جاراھەت ئاقارغان بولسا، كاھىن جاراھىتى بار كىشىنى «پاك» دەپ جاكارلىسۇن؛ ئۇ پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ئەگەر بىركىمنىڭ بەدىنىنىڭ تېرىسىگە ھۈررەك چىقىپ ساقىيىپ، ");
INSERT INTO uigara_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ھۈررەكنىڭ ئورنىدا ئاق چىقان ياكى قىزغۇچ داغ پەيدا بولغان بولسا، كاھىنغا كۆرسىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","كاھىن ئۇنىڭغا سەپسېلىپ قارىسۇن؛ ئەگەر داغ ئەتراپىدىكى تېرىدىن قېنىقراق كۆرۈنسە، شۇنداقلا ئۇنىڭدىكى تۈكلەر ئاقىرىپ قالغان بولسا، ئۇنداقتا كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن؛ چۈنكى بۇ ھۈررەكتىن قوزغىلىپ پەيدا بولغان پېسە-ماخاۋ كېسىلى جاراھىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","لېكىن كاھىن ئۇنىڭغا سەپسېلىپ قارىغاندا، داغ چىققان جايدا ئاقىرىپ قالغان تۈكلەر بولمىسا، ۋە داغمۇ ئەتراپىدىكى تېرىدىن قېنىقراق بولمىسا، رەڭگى سەل سۇسراق بولغان بولسا، ئۇنداقتا كاھىن ئۇنى يەتتە كۈنگىچە ئايرىم سولاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ئەگەر داغ دەرۋەقە تېرىسىگە يېيىلىپ كەتكەن بولسا، كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن؛ چۈنكى بۇ پېسە-ماخاۋ جاراھىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ئەمما ئەگەر داغ ئۆز جايىدا توختاپ يېيىلمىغان بولسا، بۇ پەقەت ھۈررەكنىڭ زەخمى، خالاس؛ كاھىن ئۇنى «پاك» دەپ جاكارلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","ئەگەر بىرسىنىڭ بەدىنىنىڭ تېرىسىنىڭ مەلۇم جايى كۆيۈپ قېلىپ، كۆيگەن جاي ئاق-قىزغۇچ ياكى پۈتۈنلەي ئاق داغ بولۇپ قالسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","كاھىن ئۇنىڭغا سەپسېلىپ قارىسۇن؛ ئەگەر شۇ داغدىكى تۈكلەر ئاقىرىپ كەتكەن، داغمۇ ئەتراپىدىكى تېرىدىن قېنىقراق بولۇپ قالغان بولسا، ئۇنداقتا بۇ كۆيۈك يارىسىدىن پەيدا بولغان پېسە-ماخاۋ كېسىلىدۇر؛ كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن؛ چۈنكى ئۇ پېسە-ماخاۋ جاراھىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","لېكىن ئەگەر كاھىن سەپسېلىپ قارىغاندا، داغنىڭ ئورنىدا ھېچقانداق ئاقىرىپ كەتكەن تۈك بولمىسا، شۇنداقلا داغمۇ ئەتراپىدىكى تېرىدىن قېنىق بولمىسا، بەلكى رەڭگى سۇس بولسا، ئۇنداقتا كاھىن ئۇنى يەتتە كۈنگىچە ئايرىم سولاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","يەتتىنچى كۈنى كاھىن ئۇنىڭغا يەنە قارىسۇن؛ داغ تېرىسىدە كېڭىيىپ كەتكەن بولسا، كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن؛ چۈنكى ئۇ پېسە-ماخاۋ جاراھىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ئەمما ئەگەر داغ جايىدا توختاپ، يېيىلمىغان بولسا، شۇنداقلا رەڭگى سۇس بولسا، بۇ پەقەت كۆيۈكتىن بولغان چاۋارتقۇ، خالاس؛ كاھىن ئۇنى «پاك» دەپ جاكارلىسۇن؛ چۈنكى ئۇ كۆيۈكنىڭ تاتۇقى، خالاس. ");
INSERT INTO uigara_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ئەگەر بىر ئەر ياكى ئايال كىشىنىڭ بېشىدا ياكى ساقىلىدا جاراھەت پەيدا بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","كاھىن جاراھەتكە سەپسېلىپ قارىسۇن؛ ئەگەر جاراھەت ئەتراپىدىكى تېرىدىن قېنىقراق كۆرۈنسە، ئۈستىدە شالاڭ سېرىق تۈك بولسا، ئۇنداقتا كاھىن ئۇنى «ناپاك» دەپ جاكارلىسۇن؛ چۈنكى بۇ جاراھەت قاقاچ بولۇپ، باش ياكى ساقالدىكى پېسە-ماخاۋنىڭ ئالامىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ئەگەر كاھىن قاقاچ جايغا سەپسېلىپ قارىغاندا، ئۇ ئەتراپىدىكى تېرىدىن قېنىق كۆرۈنمىسە، شۇنداقلا ئۇنىڭ ئىچىدە ھېچقانداق قارا تۈكمۇ بولمىسا، ئۇنداقتا كاھىن قاقىچى بار كىشىنى يەتتە كۈنگىچە ئايرىم سولاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","كاھىن يەتتىنچى كۈنى قاقاچقا يەنە سەپسېلىپ قارىسۇن؛ قاقاچ كېڭىيىپ كەتمەي، ئۈستىدىمۇ ھېچقانداق سېرىق تۈك بولمىسا، شۇنداقلا قاقاچ ئەتراپىدىكى تېرىدىن قېنىق كۆرۈنمىسە، ");
INSERT INTO uigara_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","جاراھىتى بار كىشى بارلىق چاچ-ساقىلىنى چۈشۈرۈۋەتسۇن؛ قاقاچنىڭ ئۆزىنى غىردىمىسۇن. كاھىن قاقىچى بار كىشىنى يەنە يەتتە كۈنگىچە ئايرىم سولاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","يەتتىنچى كۈنى كاھىن قاقاچقا سەپسېلىپ قارىسۇن؛ ئەگەر قاقاچ تېرىدە كېڭىيىپ كەتمىگەن بولسا، شۇنداقلا ئەتراپىدىكى تېرىدىن قېنىق كۆرۈنمىسە، كاھىن ئۇنى «پاك» دەپ جاكارلىسۇن. ئاندىن ئۇ كىيىملىرىنى يۇسۇن؛ شۇنىڭ بىلەن ئۇ پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لېكىن ئەگەر ئۇ «پاك» دەپ جاكارلانغاندىن كېيىن قاقاچ تېرىدە كېڭىيىپ كەتسە، ");
INSERT INTO uigara_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","كاھىن ئۇنىڭغا يەنە سەپسېلىپ قارىسۇن؛ ئەگەر قاقاچ تېرىدە كېڭىيىپ كەتكەن بولسا، سېرىق تۈكنىڭ بار-يوقلۇقىنى تەكشۈرۈشنىڭ ھاجىتى يوق؛ چۈنكى بۇ كىشى ناپاكتۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ئەگەر قاقاچ جايىدا شۇ پېتى قېلىپ، ئۈستىدىن قارا تۈك ئۈنۈپ چىققان بولسا، قاقاچ ساقايغان بولىدۇ؛ شۇ كىشى پاك بولغاچقا، كاھىن ئۇنى «پاك» دەپ جاكارلىشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ئەگەر ئەر ياكى ئايال كىشىنىڭ بەدىنىنىڭ تېرىسىدە داغ پەيدا بولۇپ، بۇ داغلار پارقىراق ھەم ئاق بولسا ");
INSERT INTO uigara_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","كاھىن سەپسېلىپ قارىسۇن؛ ئەگەر بەدەننىڭ تېرىسىدىكى شۇ داغلار سۇسلىشىپ بوز رەڭگە يۈزلەنگەن بولسا، بۇ تېرىدىن چىققان بىر تاشما، خالاس؛ بۇ كىشى پاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ئەگەر بىركىمنىڭ بېشىنىڭ تۈكلىرى چۈشۈپ كەتكەن بولسا، ئۇ پەقەت بىر تاقىر باش، خالاس؛ ئۇ پاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ئەگەر ئۇنىڭ بېشىنىڭ تۈكى پېشانە تەرىپىدىن چۈشكەن بولسا، ئۇ پەقەت پاينەكباش، خالاس؛ ئۇ يەنىلا پاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","لېكىن ئەگەر ئۇنىڭ تاقىر بېشى ياكى پاينەك بېشىدا قىزغۇچ ئاق داغ كۆرۈنسە، ئۇنداقتا شۇ جاراھەت ئۇنىڭ تاقىر بېشى ياكى پاينەك بېشىدىكى پېسە-ماخاۋ كېسىلىنىڭ بىر ئالامىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","كاھىن جاراھىتىگە سەپسېلىپ قارىسۇن؛ ئەگەر ئۇنىڭ تاقىر بېشىدا ياكى پاينەك بېشىدا ئىششىق جاراھەت بولسا ھەمدە پېسە-ماخاۋ كېسىلىنىڭ ئالامىتىدەك قىزغۇچ ئاق كۆرۈنسە، ");
INSERT INTO uigara_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ئۇنداقتا ئۇ پېسە-ماخاۋ كېسىلىگە گىرىپتار بولغان ئادەم بولۇپ، ناپاك ھېسابلىنىدۇ. ئۇنىڭ بېشىغا شۇنداق جاراھەت چۈشكەن بولغاچ، كاھىن ئۇنى مۇتلەق «ناپاك» دەپ جاكارلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","شۇنداق جاراھىتى بار پېسە-ماخاۋ كېسىلى بولغان كىشى كىيىملىرى يىرتىق، چاچلىرى چۇۋۇق، بۇرۇت-ساقىلى يېپىقلىق ھالدا: «ناپاك، ناپاك!» دەپ توۋلاپ يۈرۈشى كېرەك.    ");
INSERT INTO uigara_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","شۇ جاراھىتى بولغان بارلىق كۈنلەردە ئۇ «ناپاك» سانىلىدۇ؛ ئۇ ناپاك بولغاچقا، ئايرىم تۇرۇشى كېرەك؛ ئۇنىڭ تۇرالغۇسى چېدىرگاھنىڭ سىرتىدا بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ئەگەر بىر كىيىمدە، مەيلى يۇڭدىن ياكى كاناپتىن تىكىلگەن بولسۇن ئۇنىڭدا پېسە-ماخاۋ ئىز-دېغى پەيدا بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","يەنى كاناپ ياكى يۇڭدىن توقۇلغان رەختتە، ئۆرۈش يىپىدا ياكى ئارقاق يىپلىرىدا بولسۇن، تېرە-خۇرۇمدا ياكى تېرىدىن ئېتىلگەن ھەرقانداق نەرسىلەردە پېسە-ماخاۋ ئىز-دېغى بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","شۇنداقلا كىيىم-كېچەك ياكى تېرە-خۇرۇمدا، ئۆرۈش يىپ ياكى ئارقاق يىپلىرىدا، يا تېرە-خۇرۇمدىن ئېتىلگەن نەرسىلەردە پەيدا بولغان ئىز-داغ يېشىلراق ياكى قىزغۇچ بولسا بۇ ئىز-داغ «پېسە-ماخاۋ ئىز-دېغى» دەپ قارىلىپ كاھىنغا كۆرسىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","كاھىن داغقا سەپسېلىپ قارىسۇن، ئاندىن ئىز-داغ پەيدا بولغان نەرسىنى يەتتە كۈنگىچە ئايرىم ساقلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ئۇ يەتتىنچى كۈنى ئىز-داغقا قاراپ باقسۇن؛ ئىز-داغ چۈشكەن كىيىم-كېچەك، مەيلى ئارقاق يىپتا ياكى ئۆرۈش يىپتا بولسۇن، ياكى تېرە-خۇرۇمدا ياكى تېرە-خۇرۇمدىن ئېتىلگەن نەرسىدە بولسۇن، ئۇ كېڭىيىپ كەتكەن بولسا، بۇ ئىز-داغ چىرىتكۈچ پېسە-ماخاۋ كېسىلى دەپ ھېسابلىنىپ، ئۇلار ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","شۇنىڭدەك كاھىن ئۆرۈش يىپ ياكى ئارقاق يىپىدا ئىز-داغ بولسا كىيىم-كېچەك ياكى تېرە-خۇرۇمدىن ئېتىلگەن نەرسىدە شۇنداق ئىز-داغ بولسا ئۇلارنىمۇ كۆيدۈرۈۋەتسۇن؛ چۈنكى بۇ چىرىتكۈچ پېسە-ماخاۋ كېسىلىدۇر. مۇنداق نەرسىلەرنىڭ ھەممىسىنى ئوتتا كۆيدۈرۈش كېرەكتۇر. ");
INSERT INTO uigara_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","لېكىن كاھىن ئۇنىڭغا سەپسېلىپ قارىغاندا، ئىز-داغ كىيىم-كېچەكتىكى ئۆرۈش يىپتا بولسۇن، ئارقاق يىپتا بولسۇن، ياكى تېرە-خۇرۇمدىن ئېتىلگەن نەرسىدە بولسۇن، ئىز-داغ كېڭەيمىگەن بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ئۇنداقتا كاھىن دېغى بار نەرسىنى يۇيۇلسۇن دەپ بۇيرۇپ، ئىككىنچى قېتىم ئۇنى يەتتە كۈنگىچە ساقلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","بۇ نەرسە يۇيۇلغاندىن كېيىن كاھىن يەنە داغقا سەپسېلىپ قارىسۇن؛ ئەگەر ئۇنىڭ رەڭگى ئۆزگەرمىگەن بولسا (گەرچە كېڭىيىپ كەتمىگەن بولسىمۇ)، ئۇ يەنىلا ناپاكتۇر؛ سەن ئۇنى ئوتتا كۆيدۈرگىن. چۈنكى مەيلى ئۇنىڭ ئىز-دېغى ئىچ يۈزىدە بولسۇن ياكى تاش يۈزىدە بولسۇن ئۇ چىرىتكۈچ ئىز-داغ ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","لېكىن ئەگەر كاھىن سەپسېلىپ قارىغاندا، مانا، داغنىڭ رەڭگى يۇيۇلغاندىن كېيىن سۇسلىشىپ كەتكەن بولسا، ئۇ شۇ قىسمىنى كىيىم-كېچەكتىن، ئۆرۈش يىپتىن ياكى ئارقاق يىپتىن بولسۇن، ياكى تېرە-خۇرۇمدىن بولسۇن ئۇنى يىرتىپ ئېلىپ، تاشلىۋەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ئەگەر بۇ ئىز-داغ كىيىم-كېچەكتە، مەيلى ئارقاق يىپتا ياكى ئۆرۈش يىپتا بولسۇن، يا تېرە-خۇرۇمدىن ئېتىلگەن نەرسىدە كۆرۈنسۇن، بۇ كېڭىيدىغان بىرخىل پېسە-ماخاۋ ئىز-دېغى دەپ سانالسۇن؛ سەن ئۇ چاپلاشقان كىيىم-كېچەكنى كۆيدۈرۈۋەتكىن. ");
INSERT INTO uigara_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","لېكىن ئەگەر ئىز-داغ كىيىم-كېچەكتە بولسۇن (ئۆرۈش يىپىدا ياكى ئارقاق يىپىدا بولسۇن) ياكى تېرە-خۇرۇمدىن ئېتىلگەن نەرسىدە بولسۇن، يۇيۇلۇش بىلەن چىقىپ كەتسە، ئۇنداقتا بۇ ئېگىن ئىككىنچى قېتىم يۇيۇلسۇن، ئاندىن پاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","پېسە-ماخاۋ كېسىلىنىڭكىدەك ئىز-داغ پەيدا بولغان يۇڭ ياكى كاناپ رەختتىن توقۇلغان كىيىم-كېچەك (ئىز-داغ ئۆرۈش يىپتا ياكى ئارقاق يىپتا بولسۇن) ياكى تېرە-خۇرۇمدىن ئېتىلگەن نەرسىلەر توغرىسىدىكى قانۇن-بەلگىلىمە مانا شۇدۇر؛ بۇنىڭ بىلەن ئۇلارنى پاك ياكى ناپاك جاكارلاشقا بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","پېسە-ماخاۋ بولغان كىشى پاك قىلىنىدىغان كۈنىدە بەجا قىلىش كېرەك بولغان قانۇن-بەلگىلىمە مانا تۆۋەندىكىدەكتۇر: ــ ئۇ كاھىننىڭ ئالدىغا كەلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","كاھىن چېدىرگاھنىڭ تاشقىرىغا چىقىپ، پېسە-ماخاۋ بولغان كىشىگە سەپسېلىپ قارىسۇن؛ ئەگەر پېسە-ماخاۋ بولغان كىشى كېسىلىدىن ساقايغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ئۇنداقتا كاھىن پاك قىلىنىدىغان كىشىگە پاك، تىرىك قۇشتىن ئىككىنى ئۇنىڭغا قوشۇپ كېدىر ياغىچى، قىزىل رەخت ۋە زوفا كەلتۈرۈشكە بۇيرۇسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ئاندىن كاھىن قۇشلارنىڭ بىرىنى ئېقىن سۇ قاچىلانغان ساپال كوزىنىڭ ئۈستىدە بوغۇزلاڭلار دەپ بۇيرۇسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ئاندىن تىرىك قۇشنى بولسا، كاھىن ئۇنى كېدىر ياغىچى، قىزىل رەخت ۋە زوفا بىلەن ئېلىپ كېلىپ، بۇ نەرسىلەرنىڭ ھەممىسىنى تىرىك قۇش بىلەن بىرگە ئېقىن سۇنىڭ ئۈستىدە بوغۇزلانغان قۇشنىڭ قېنىغا چىلىسۇن، ");
INSERT INTO uigara_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ئاندىن پېسە-ماخاۋدىن پاك قىلىنىدىغان كىشىگە يەتتە قېتىم سېپىشى بىلەن ئۇنى پاك دەپ جاكارلىسۇن؛ ۋە تىرىك قۇشنى دالاغا قويۇپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","پېسە-ماخاۋدىن پاك قىلىنىدىغان كىشى كىيىملىرىنى يۇيۇپ، بەدىنىدىكى بارلىق تۈكلەرنى چۈشۈرۈپ، سۇدا يۇيۇنغاندىن كېيىن پاك ھېسابلىنىدۇ. ئاندىن ئۇنىڭغا چېدىرگاھقا كىرىشكە ئىجازەت بولىدۇ؛ پەقەت ئۇ يەتتە كۈنگىچە ئۆز چېدىرىنىڭ تېشىدا تۇرۇشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","يەتتىنچى كۈنى ئۇ بەدىنىدىكى ھەممە تۈكلەرنى چۈشۈرسۇن؛ باشنىڭ چاچ-ساقاللىرى ۋە قېشىنى، يەنى بارلىق تۈكلىرىنى چۈشۈرسۇن؛ ئۇ كىيىملىرىنى يۇيۇپ ئۆز بەدىنىنى سۇدا يۇسۇن، ئاندىن پاك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","سەككىزىنچى كۈنى ئۇ ئىككى بېجىرىم ئەركەك قوزا بىلەن بىر ياشقا كىرگەن بېجىرىم چىشى قوزىدىن بىرنى، شۇنىڭدەك بىر ئەفاھنىڭ ئوندىن ئۈچىگە باراۋەر زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇن «ئاشلىق ھەدىيەسى»نى، بىر لوگ زەيتۇن مېيىنى كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ئۇنى «پاك» دەپ جاكارلايدىغان بۇ رەسىم-قائىدىنى ئۆتكۈزىدىغان كاھىن پاك قىلىنىدىغان كىشىنى ۋە ئۇ نەرسىلەرنى جامائەت چېدىرىنىڭ كىرىش ئاغزىدا، پەرۋەردىگارنىڭ ئالدىدا ھازىر قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ئاندىن كاھىن ئەركەك قوزىلارنىڭ بىرىنى ئېلىپ ئىتائەتسىزلىك قۇربانلىقى قىلىپ سۇنۇپ، ئۇنىڭ بىلەن بىللە شۇ بىر لوگ زەيتۇن مېيىنىمۇ كەلتۈرۈپ، پۇلاڭلاتما ھەدىيە سۈپىتىدە پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","قوزا بولسا مۇقەددەس بىر جاينىڭ ئىچىدە گۇناھ قۇربانلىقى بىلەن كۆيدۈرمە قۇربانلىقلار بوغۇزلىنىدىغان جايدا بوغۇزلانسۇن؛ چۈنكى ئىتائەتسىزلىك قۇربانلىقى بولسا گۇناھ قۇربانلىقىغا ئوخشاش، كاھىنغا تەۋە بولۇپ «ئەڭ مۇقەددەسلەرنىڭ بىرى» سانىلىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","كاھىن ئىتائەتسىزلىك قۇربانلىقىنىڭ قېنىدىن ئېلىپ پاك قىلىنىدىغان كىشىنىڭ ئوڭ قۇلىقىنىڭ يۇمشىقىغا ۋە ئوڭ قولىنىڭ چوڭ بارمىقى بىلەن ئوڭ پۇتىنىڭ چوڭ بارمىقىغىمۇ سۈرۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ئاندىن كاھىن شۇ بىر لوگ زەيتۇن مېيىدىن ئېلىپ، ئۆزىنىڭ سول قولىنىڭ ئالىقىنىغا ئازغىنا قۇيسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","كاھىن ئوڭ بارمىقىنى سول قولىدىكى زەيتۇن مېيىغا چىلاپ، پەرۋەردىگارنىڭ ئالدىدا يەتتە قېتىم بارمىقى بىلەن سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ئاندىن كاھىن قولىدىكى قالغان مايدىن ئېلىپ، پاك قىلىنىدىغان كىشىنىڭ ئوڭ قۇلىقىنىڭ يۇمشىقىغا، ئوڭ قولىنىڭ باش بارمىقىغا ۋە ئوڭ پۇتىنىڭ باش بارمىقىغا سۈرۈلگەن ئىتائەتسىزلىك قۇربانلىقىنىڭ قېنىنىڭ ئۈستىگە سۈرۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","سۈرۈپ بولۇپ، كاھىن قولىدىكى ئېشىپ قالغان ماينى پاك قىلىنىدىغان كىشىنىڭ بېشىغا قۇيسۇن. بۇ يول بىلەن كاھىن ئۇنىڭ ئۈچۈن پەرۋەردىگارنىڭ ئالدىدا كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ئاندىن كاھىن گۇناھ قۇربانلىقىنى سۇنۇپ، پاك قىلىنىدىغان كىشىنى ناپاكلىقىدىن پاك قىلىشقا كەفارەت كەلتۈرىدۇ؛ ئاخىرىدا ئۇ كۆيدۈرمە قۇربانلىقنى بوغۇزلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","كاھىن كۆيدۈرمە قۇربانلىق بىلەن ئاشلىق ھەدىيەسىنى قۇربانگاھتا سۇنسۇن. بۇ يول بىلەن كاھىن ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرۈپ، ئۇ كىشى پاك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","لېكىن ئۇ كەمبەغەللىكتىن شۇنداق قىلىشقا قۇربى يەتمىسە، ئۆزىگە كەفارەت كەلتۈرۈش ئۈچۈن «پۇلاڭلاتما ھەدىيە» سۈپىتىدە يالغۇز بىر ئەركەك قوزىنى ئىتائەتسىزلىك قۇربانلىقى قىلىپ كەلتۈرسۇن، شۇنىڭدەك ئاشلىق ھەدىيەسى ئۈچۈن بىر ئەفاھنىڭ ئوندىن بىرىگە باراۋەر زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇن بىلەن بىر لوگ زەيتۇن مېيىنى كەلتۈرسۇن ");
INSERT INTO uigara_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ۋە ئۆز ئەھۋالىغا يارىشا ئىككى پاختەك ياكى ئىككى باچكا ئېلىپ كەلسۇن؛ بىرى گۇناھ قۇربانلىقى ئۈچۈن، يەنە بىرى كۆيدۈرمە قۇربانلىق ئۈچۈن بولسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","سەككىزىنچى كۈنى بۇلارنى ئۆزىنىڭ پاك قىلىنىشى ئۈچۈن جامائەت چېدىرىنىڭ كىرىش ئاغزىغا ئېلىپ كېلىپ، پەرۋەردىگارنىڭ ئالدىدا كاھىننىڭ قېشىغا كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","كاھىن ئىتائەتسىزلىك قۇربانلىقى بولىدىغان ئەركەك قوزا بىلەن شۇ بىر لوگ ماينى ئېلىپ، بۇلارنى پۇلاڭلاتما ھەدىيە سۈپىتىدە پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ئىتائەتسىزلىك قۇربانلىقى قىلىنغان ئەركەك قوزىنى بولسا ئۆزى بوغۇزلىسۇن؛ ئاندىن كاھىن ئىتائەتسىزلىك قۇربانلىقىنىڭ قېنىدىن ئازغىنا ئېلىپ، پاك قىلىنىدىغان كىشىنىڭ ئوڭ قۇلىقىنىڭ يۇمشىقىغا، ئوڭ قولىنىڭ باش بارمىقىغا ۋە ئوڭ پۇتىنىڭ باش بارمىقىغا سۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ئاندىن كاھىن مايدىن ئېلىپ، سول قولىنىڭ ئالىقىنىغا ئازغىنا قۇيسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","شۇنداق قىلىپ، كاھىن ئوڭ بارمىقى بىلەن سول قولىدىكى مايدىن پەرۋەردىگارنىڭ ئالدىدا يەتتە قېتىم سەپسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ئاندىن كاھىن ئۆزى قولىدىكى مايدىن ئېلىپ، پاك قىلىنىدىغان كىشىنىڭ ئوڭ قۇلىقىنىڭ يۇمشىقىغا ۋە ئوڭ قولىنىڭ باش بارمىقى بىلەن ئوڭ پۇتىنىڭ باش بارمىقىغا ئىتائەتسىزلىك قۇربانلىقىنىڭ قېنىنىڭ ئۈستىگە سۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","شۇنىڭ بىلەن پەرۋەردىگارنىڭ ئالدىدا ئۇنىڭغا كەفارەت كەلتۈرۈشكە كاھىن قولىدىكى ماينىڭ قالغىنىنى پاك قىلىنىدىغان كىشىنىڭ بېشىغا قۇيسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ئاندىن شۇ كىشى ئۆز قۇربىغا قاراپ پاختەكتىن بىرنى ياكى باچكىدىن بىرنى سۇنسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ئۆز قۇربىغا قاراپ، بىرىنى گۇناھ قۇربانلىقى، يەنە بىرىنى كۆيدۈرمە قۇربانلىق قىلىپ ئاشلىق ھەدىيەسى بىلەن بىللە سۇنسۇن. بۇ يولدا كاھىن پەرۋەردىگارنىڭ ئالدىدا پاك قىلىنىدىغان كىشى ئۈچۈن كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ئۆزىدە پېسە-ماخاۋ بولغان، پاك قىلىنىشى ئۈچۈن ۋاجىپ بولىدىغان نەرسىلەرنى كەلتۈرۈشكە قۇربى يەتمەيدىغان كىشىلەر توغرىسىدىكى قانۇن-بەلگىلىمە مانا شۇلاردۇر. ");
INSERT INTO uigara_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","پەرۋەردىگار مۇسا بىلەن ھارۇنغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","ــ سىلەر مەن ئۆزۈڭلارغا مىراس قىلىپ بېرىدىغان قانائان زېمىنىغا كىرگەندىن كېيىن، مەن سىلەر ئىگە بولىدىغان شۇ زېمىندىكى بىر ئۆيگە بىرخىل پېسە-ماخاۋ يارىسىنى ئەۋەتسەم، ");
INSERT INTO uigara_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ئۆينىڭ ئىگىسى كاھىننىڭ قېشىغا بېرىپ، ئۇنىڭغا بۇنى مەلۇم قىلىپ: «مېنىڭ ئۆيۈمگە ۋابا يۇققاندەك كۆرۈنىدۇ»، دەپ مەلۇم قىلىشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","كاھىن بولسا: ــ ئۆيدىكى ھەممە نەرسىلەر ناپاك بولمىسۇن ئۈچۈن مەن بېرىپ بۇ ۋاباغا سەپسېلىپ قاراشتىن بۇرۇن ئۆينى بىكارلاڭلار، دەپ بۇيرۇسۇن. ئاندىن كاھىن كىرىپ ئۆيگە سەپسېلىپ قارىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ئۇ شۇ ۋاباغا سەپسېلىپ قارىغىنىدا، مانا ئۆينىڭ تاملىرىغا ۋابا داغلىرى يۇققان جايلار كاۋاك بولسا، ھەم يېشىلغا مايىل ياكى قىزغۇچ بولۇپ، تامنىڭ يۈزىدىن قېنىقراق بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","كاھىن ئۆينىڭ ئىشىكىنىڭ ئالدىغا چىقىپ، ئىشىكنى يەتتە كۈنگىچە تاقاپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ئاندىن كاھىن يەتتىنچى كۈنى يېنىپ كېلىپ، سەپسېلىپ قارىغىنىدا، ئۆينىڭ تاملىرىدىكى ئىز-داغ كېڭىيىپ كەتكەن بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","كاھىن: ــ ۋابا يۇققان تاشلارنى چىقىرىپ شەھەرنىڭ سىرتىدىكى ناپاك بىر جايغا تاشلىۋېتىڭلار، دەپ بۇيرۇسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","شۇنىڭ بىلەن بىرگە ئۇ ئۆينىڭ ئىچىنىڭ تۆت ئەتراپىنى قىردۇرسۇن ۋە ئۇلار قىرغان سۇۋاقنى بولسا شەھەرنىڭ تېشىدىكى ناپاك بىر جايغا تۆكۈۋەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ئاندىن ئۇلار باشقا تاشلارنى ئېلىپ، ئىلگىرىكى تاشلارنىڭ ئورنىدا قويسۇن ۋە باشقا ھاك لاي ئېتىپ، ئۇنىڭ بىلەن ئۆينى قايتىدىن سۇۋىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ئەگەر ئۇ تاشلارنى چىقىرىپ، ئۆينى قىردۇرۇپ قايتىدىن سۇۋاتقاندىن كېيىن، ئۆيدە ۋابا دېغى يەنە پەيدا بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ئۇنداقتا كاھىن يەنە كىرىپ بۇنىڭغا سەپسېلىپ قارىسۇن. سەپسېلىپ قارىغىنىدا، مانا ئىز-داغ ئۆيدە كېڭىيىپ كەتكەن بولسا، بۇ ئۆيگە يۇققىنى چىرىتكۈچ ۋابا بولىدۇ؛ ئۆي ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","بۇ ۋەجىدىن ئۇلار ئۆينى، يەنى ياغاچ-تاش ۋە بارلىق سۇۋىقى بىلەن بىللە چۈشۈرۈپ، ھەممىسىنى كۆتۈرۈپ شەھەرنىڭ سىرتىدىكى ناپاك بىر جايغا تاشلىۋەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","كىمدەكىم ئۆي تاقالغان مەزگىلدە ئۇنىڭغا كىرسە، ئۇ كەچ كىرگۈچە ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ئەگەر بىركىم ئۆي ئىچىدە ياتقان بولسا، كىيىملىرىنى يۇسۇن؛ ۋە ئەگەر بىرسى ئۆيدە غىزالانغان بولسا، ئۇمۇ ئۆز كىيىملىرىنى يۇسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","لېكىن كاھىن كىرىپ، ئۆيگە سەپسېلىپ قارىغىنىدا ئۆي سۇۋالغاندىن كېيىن ۋابا ئۇنىڭدا كېڭىيىپ كەتمىگەن بولسا، ئۇنداقتا كاھىن ئۆينى «پاك» دەپ جاكارلىسۇن؛ چۈنكى ئۇنىڭدىكى ۋابا ساقايغان بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ئاندىن ئۇ ئۆينىڭ پاك قىلىنىشى ئۈچۈن ئىككى قۇش، كېدىر ياغىچى، قىزىل رەخت بىلەن زوفا ئېلىپ كېلىپ، ");
INSERT INTO uigara_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","قۇشلارنىڭ بىرىنى ئېقىن سۇ قاچىلانغان ساپال كوزىنىڭ ئۈستىدە بوغۇزلىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ئاندىن ئۇ كېدىر ياغىچى، زوفا، قىزىل رەخت ۋە تىرىك قۇشنى بىللە ئېلىپ كېلىپ، بۇ نەرسىلەرنىڭ ھەممىسىنى بوغۇزلانغان قۇشنىڭ قېنىغا، شۇنداقلا ئېقىن سۇغا چىلاپ، ئۆيگە يەتتە مەرتىۋە سەپسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","بۇ يول بىلەن ئۇ ئۆينى قۇشنىڭ قېنى، ئېقىن سۇ، تىرىك قۇش، كېدىر ياغىچى، زوفا ۋە قىزىل رەخت ئارقىلىق ناپاكلىقتىن پاكلايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ئاندىن ئۇ تىرىك قۇشنى شەھەرنىڭ سىرتىدا، دالادا قويۇپ بەرسۇن. ئۇ شۇنداق قىلىپ، ئۆي ئۈچۈن كەفارەت كەلتۈرىدۇ؛ ئۇ ئۆي پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","بۇلار بولسا ھەرخىل پېسە-ماخاۋ جاراھىتى، قاقاچ، ");
INSERT INTO uigara_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","كىيىم-كېچەك ۋە ئۆيگە يۇققان پېسە-ماخاۋ ۋاباسى، ");
INSERT INTO uigara_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","تېرىدىكى چىقانلار، تەمرەتكە ۋە پارقىراق ئاق ئىز-داغلار توغرىسىدىكى قانۇن-بەلگىلىمىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","شۇ بەلگىلىمىلەر بىلەن بىر نەرسىنىڭ قايسى ئەھۋالدا ناپاك، قايسى ئەھۋالدا پاك بولىدىغانلىقىنى پەرق ئېتىشكە كۆرسەتمە بېرىشكە بولىدۇ؛ مانا بۇ پېسە-ماخاۋ توغرىسىدىكى قانۇن-بەلگىلىمىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","ئىسرائىللارغا مۇنداق دەڭلار: ــ ھەرقانداق ئەركەكنىڭ ئۆز تېنىدىن ئاقما چىقسا شۇ كىشى شۇ ئاقما سەۋەبىدىن ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ئاقما چىقىشتىن بولغان ناپاكلىق توغرىسىدىكى ھۆكۈم شۇكى، ئاقمىسى مەيلى تېنىدىن ئېقىپ تۇرسۇن ياكى ئېقىشتىن توختىتىلغان بولسۇن، شۇ كىشى يەنىلا ناپاك سانالسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","مۇنداق ئاقما بولغان كىشى ياتقان ھەربىر ئورۇن-كۆرپە ناپاك سانىلىدۇ ۋە ئۇ قايسى نەرسىنىڭ ئۈستىدە ئولتۇرسا شۇ نەرسىمۇ ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","كىمكى ئۇ ياتقان ئورۇن-كۆرپىگە تەگسە، ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن، ئاندىن كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","شۇنىڭدەك كىمكى مۇنداق ئاقما بولغان كىشى ئولتۇرغان نەرسىدە ئولتۇرسا ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","كىمكى ئاقما بولغان كىشىنىڭ تېنىگە تەگسە، ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن، ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ئەگەر ئاقما بولغان كىشى پاك بىرسىگە تۈكۈرسە، شۇ كىشى ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن، كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","قايسىبىر ئېگەر-توقۇمنىڭ ئۈستىگە ئاقما بولغان كىشى مىنسە، شۇ نەرسە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","كىمكى ئۇنىڭ تېگىدە قويۇلغان نەرسىلەرگە تەگسە كەچ كىرگۈچە ناپاك سانىلىدۇ؛ ۋە كىمكى شۇ نەرسىلەرنى كۆتۈرسە، ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن، ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ئاقما بولغان كىشى قولىنى يۇماستىن بىركىمگە تەگكۈزسە، شۇ كىشى ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ئاقما بولغان كىشى ساپال قاچىنى تۇتۇپ سالسا، شۇ قاچا چېقىۋېتىلسۇن؛ ياغاچ قاچا بولسا سۇدا يۇيۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","قاچانىكى ئاقما بار كىشى ئاقما ھالىتىدىن قۇتۇلسا، ئۆزىنىڭ پاك قىلىنىشى ئۈچۈن يەتتە كۈننى ھېسابلاپ ئۆتكۈزۈپ، ئاندىن كىيىملىرىنى يۇيۇپ، ئېقىن سۇدا يۇيۇنسۇن؛ ئاندىن پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","سەككىزىنچى كۈنى ئىككى پاختەك ياكى ئىككى باچكىنى ئېلىپ، جامائەت چېدىرىنىڭ كىرىش ئاغزىغا، پەرۋەردىگارنىڭ ئالدىغا كەلتۈرۈپ، كاھىنغا تاپشۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","كاھىن ئۇلاردىن بىرىنى گۇناھ قۇربانلىقى ئۈچۈن، يەنە بىرىنى كۆيدۈرمە قۇربانلىق ئۈچۈن سۇنسۇن. بۇ يول بىلەن كاھىن پەرۋەردىگارنىڭ ئالدىدا ئۇنىڭ ئاقما بولغانلىقىغا كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ئەگەر بىر ئەركەكنىڭ مەنىيسى ئۆزلۈكىدىن چىقىپ كەتكەن بولسا، ئۇ پۈتۈن بەدىنىنى سۇدا يۇسۇن، ئۇ كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","شۇنىڭدەك ئادەمنىڭ مەنىيسى قايسى كىيىمىگە ياكى تېرىسىگە يۇقۇپ قالسا، سۇدا يۇيۇلسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ئەر ۋە ئايال كىشى بىر-بىرىگە يېقىنلىشىشى بىلەن مەنىي چىقسا، ئىككىسى يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ئەگەر ئايال كىشىلەر ئاقما كېلىش ھالىتىدە تۇرسا ۋە ئاقمىسى خۇن بولسا، ئۇ يەتتە كۈنگىچە «ئايرىم» تۇرسۇن؛ كىمكى ئۇنىڭغا تەگسە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","«ئايرىم» تۇرۇش مەزگىلىدە، قايسى نەرسىنىڭ ئۈستىدە ياتسا، شۇ نەرسە ناپاك سانىلىدۇ، شۇنداقلا قايسى نەرسىنىڭ ئۈستىدە ئولتۇرغان بولسا، شۇ نەرسىمۇ ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ھەركىم ئۇنىڭ ئورۇن-كۆرپىسىگە تەگسە ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ھەركىم ئۇ ئولتۇرغان نەرسىگە تەگسە، ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ۋە ئەگەر بىركىم ئۇ ياتقان ياكى ئولتۇرغان جايدا قويۇلغان بىرەر نەرسىگە تەگسە، كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ئەگەر بىر ئەر كىشى شۇ ھالەتتىكى ئايال بىلەن بىرگە ياتسا، شۇنداقلا ئۇنىڭ خۇن ناپاكلىقى شۇ ئەرگە يۇقۇپ قالسا، ئۇ يەتتە كۈنگىچە ناپاك سانالسۇن؛ ئۇ ياتقان ھەربىر ئورۇن-كۆرپىمۇ ناپاك سانالسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ئەگەر ئايال كىشىنىڭ ئادەت ۋاقتىنىڭ سىرتىدىمۇ بىرنەچچە كۈنگىچە خۇنى كېلىپ تۇرسا، ياكى خۇن ئاقمىسى ئادەت ۋاقتىدىن ئېشىپ كەتكەن بولسا، ئۇنداقتا بۇ ناپاك قان ئېقىپ تۇرغان كۈنلىرىنىڭ ھەممىسىدە، ئۇ ئادەت كۈنلىرىدە تۇرغاندەك سانالسۇن، يەنە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","قان كەلگەن ھەربىر كۈندە ئۇ قايسى ئورۇن-كۆرپە ئۈستىدە ياتسا، بۇلار ئۇ ئادەت كۈنلىرىدە ياتقان ئورۇن-كۆرپىلەردەك ھېسابلىنىدۇ؛ ئۇ قايسى نەرسىنىڭ ئۈستىدە ئولتۇرغان بولسا، شۇ نەرسە ئادەت كۈنلىرىنىڭ ناپاكلىقىدەك ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ھەركىم بۇ نەرسىلەرگە تەگسە ناپاك بولىدۇ؛ شۇ كىشى كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ئايال كىشى قاچان خۇن كېلىشتىن ساقايسا، ئۇ يەتتە كۈننى ھېسابلاپ، ئۆتكۈزۈپ بولغاندا پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","سەككىزىنچى كۈنى ئۇ ئىككى پاختەك ياكى ئىككى باچكىنى ئېلىپ جامائەت چېدىرىنىڭ كىرىش ئاغزىغا، كاھىننىڭ قېشىغا كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","كاھىن بۇلارنىڭ بىرىنى گۇناھ قۇربانلىقى ئۈچۈن، يەنە بىرىنى كۆيدۈرمە قۇربانلىق ئۈچۈن ئۆتكۈزسۇن؛ بۇ يول بىلەن كاھىن ئۇنىڭ ناپاك ئاقما قېنىدىن پاك بولۇشىغا ئۇنىڭ ئۈچۈن پەرۋەردىگارنىڭ ئالدىدا كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","سىلەر مۇشۇ يول بىلەن ئىسرائىللارنى ناپاكلىقىدىن ئۈزۈڭلار؛ بولمىسا، ئۇلار ناپاكلىقىدا تۇرۇۋېرىپ، ئۇلارنىڭ ئارىسىدا تۇرغان مېنىڭ تۇرالغۇ چېدىرىمنى بۇلغىشى تۈپەيلىدىن ناپاك ھالىتىدە ئۆلۈپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ئاقما كېلىش ھالىتىدە بولغان كىشى ۋە مەنىي كېتىش بىلەن ناپاك بولغان كىشى توغرىسىدا، ");
INSERT INTO uigara_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","شۇنىڭدەك خۇن كېلىش كۈنلىرىدىكى ئاغرىق ئايال كىشى توغرۇلۇق، ئاقما ھالەتتە بولغان ئەر ۋە ئايال توغرۇلۇق، ناپاك ھالەتتىكى ئايال بىللە ياتقان ئەر توغرۇلۇق كەلگەن قانۇن-بەلگىلىمە مانا شۇلاردۇر. ");
INSERT INTO uigara_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ھارۇننىڭ ئىككى ئوغلى پەرۋەردىگارنىڭ ئالدىغا يېقىنلىشىشى بىلەن ئۆلۈپ كەتتى. ئۇلار ئۆلۈپ كەتكەندىن كېيىن، پەرۋەردىگار مۇساغا سۆز قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ «سەن ئۆز قېرىندىشىڭ ھارۇنغا: «سەن ئۆلۈپ كەتمەسلىكىڭ ئۈچۈن پەردىنىڭ ئىچىدىكى مۇقەددەس جايغا قويۇلغان ئەھدە ساندۇقىنىڭ ئۈستىدىكى «كەفارەت تەختى»نىڭ ئالدىغا ھەر ۋاقىت كەلمە»، دېگىن. چۈنكى مەن «كەفارەت تەختى»نىڭ ئۈستىدىكى بۇلۇتتا ئايان بولىمەن. ");
INSERT INTO uigara_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ھارۇن ئەڭ مۇقەددەس جايغا مۇنۇ يول بىلەن كىرسۇن: ــ گۇناھ قۇربانلىقى ئۈچۈن بىر ياش تورپاق، كۆيدۈرمە قۇربانلىق ئۈچۈن بىر قوچقارنى كەلتۈرسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ئۆزى مۇقەددەس كاناپ خالتا كۆڭلەكنى كىيىپ، ئەتلىرىنى ياپىدىغان كاناپ ئىشتاننىمۇ كىيىپ، بېلىگە بىر كاناپ بەلۋاغنى باغلاپ، بېشىغا كاناپ سەللىنى يۆگەپ كەلسۇن. بۇلار مۇقەددەس كىيىملەر بولغاچقا، كىيىشتىن ئىلگىرى بەدىنىنى سۇدا يۇسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ئۇ ئىسرائىللارنىڭ جامائىتىدىن گۇناھ قۇربانلىقى ئۈچۈن ئىككى تېكە، كۆيدۈرمە قۇربانلىق ئۈچۈن بىر قوچقارنى تاپشۇرۇۋالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","شۇنىڭ بىلەن ھارۇن ئاۋۋال گۇناھ قۇربانلىقى بولىدىغان تورپاقنى سۇنۇپ، ئۆزى ۋە ئۆز ئۆيىدىكىلەر ئۈچۈن كەفارەت كەلتۈرۈشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ئاندىن ئۇ ئىككى تېكىنى ئېلىپ، ئۇلارنى جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىغا كەلتۈرۈپ، پەرۋەردىگارنىڭ ئالدىدا تۇرغۇزسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ئاندىن ھارۇن بۇ ئىككى تېكە توغرىسىدا چەك تاشلىسۇن؛ چەكنىڭ بىرىنى «پەرۋەردىگار ئۈچۈن»، يەنە بىرىنى «ئازازەل ئۈچۈن» تاشلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ھارۇن پەرۋەردىگارغا چەك چۈشكەن تېكىنى كەلتۈرۈپ، گۇناھ قۇربانلىقى سۈپىتىدە سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","لېكىن «ئازازەل»گە چەك چۈشكەن تېكىنى بولسا، كەفارەت كەلتۈرۈشى ئۈچۈن چۆلگە ھەيدىلىشكە، شۇنداقلا «ئازازەل»گە ئەۋەتىلىشكە پەرۋەردىگارنىڭ ئالدىدا تىرىك قالدۇرۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","ئاندىن ھارۇن گۇناھ قۇربانلىقىنى، يەنى ئۆزى ئۈچۈن بولغان تورپاقنى كەلتۈرۈپ، ئۆزى ۋە ئۆز ئۆيىدىكىلەر ئۈچۈن كەفارەت كەلتۈرۈشكە ئۆزىگە گۇناھ قۇربانلىقى بولىدىغان بۇ تورپاقنى بوغۇزلىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ئاندىن ئۇ پەرۋەردىگارنىڭ ئالدىدىكى قۇربانگاھتىن ئېلىنغان چوغ بىلەن تولغان بىر خۇشبۇيداننى ئېلىپ، ئىككى قوللاپ يۇمشاق ئېزىلگەن ئېسىل خۇشبۇي ئەتىر بىلەن تولدۇرۇپ، بۇنى پەردىنىڭ ئىچىگە ئېلىپ بارسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ئاندىن خۇشبۇي ئىس-تۈتىكى ھۆكۈم-گۇۋاھ ساندۇقىنىڭ ئۈستىدىكى كەفارەت تەختىنى قاپلىسۇن دەپ، خۇشبۇينى پەرۋەردىگارنىڭ ھۇزۇرىدىكى ئوتنىڭ ئۈستىگە قويسۇن؛ شۇنىڭ بىلەن ئۇ ئۆلمەيدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ئۇ تورپاقنىڭ قېنىدىن ئېلىپ ئۆز بارمىقى بىلەن كەفارەت تەختىنىڭ شەرق تەرىپىگە چېچىپ، كەفارەت تەختىنىڭ ئالدىغىمۇ ئۆز بارمىقى بىلەن قاندىن ئېلىپ، يەتتە قېتىم سەپسۇن.    ");
INSERT INTO uigara_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ئاندىن ئۇ خەلق ئۈچۈن گۇناھ قۇربانلىقى قىلىنىدىغان تېكىنى بوغۇزلىسۇن؛ قېنىنى پەردىنىڭ ئىچىگە كەلتۈرۈپ، تورپاقنىڭ قېنىنى قىلغاندەك قىلسۇن، يەنى ئۇنىڭ قېنىدىن ئېلىپ كەفارەت تەختىگە ۋە كەفارەت تەختىنىڭ ئالدىغا چاچسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ئۇ بۇ يول بىلەن مۇقەددەس جاي ئۈچۈن كەفارەت كەلتۈرۈپ، ئۇنى ئىسرائىللارنىڭ ناپاكلىقىدىن، ھەممە ئىتائەتسىزلىكلىرىنى ئېلىپ بارىدىغان گۇناھلىرىدىن پاكلايدۇ ۋە شۇنىڭدەك ئۇلارنىڭ ناپاكلىقى ئارىسىدا تۇرۇۋاتقان جامائەت چېدىرى ئۈچۈنمۇ شۇنداق كەفارەت قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ئۇ كەفارەت كەلتۈرۈش ئۈچۈن ئەڭ مۇقەددەس جايغا كىرگەندىن تارتىپ ئۇنىڭدىن چىققۇچە ھېچبىر ئادەم جامائەت چېدىرى ئىچىدە بولمىسۇن؛ بۇ يول بىلەن ئۇ ئۆزى، ئۆيىدىكىلەر ۋە ئىسرائىلنىڭ پۈتكۈل جامائىتى ئۈچۈن كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ئاندىن ئۇ پەرۋەردىگارنىڭ ئالدىدىكى قۇربانگاھقا چىقىپ، ئۇنىڭ ئۈچۈنمۇ كەفارەت كەلتۈرىدۇ؛ شۇنىڭدەك تورپاقنىڭ قېنى بىلەن تېكىنىڭ قېنىدىن ئېلىپ قۇربانگاھنىڭ چۆرىسىدىكى مۈڭگۈزلەرگە سۈرسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ئۇ بارمىقى بىلەن قاندىن ئېلىپ قۇربانگاھنىڭ ئۈستىگە يەتتە قېتىم سەپسۇن؛ شۇنىڭ بىلەن ئۇ ئۇنى ئىسرائىللارنىڭ ناپاكلىقلىرىدىن پاكلاپ خۇداغا ئاتاپ مۇقەددەس قىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","ــ مۇقەددەس جاي، جامائەت چېدىرى ۋە قۇربانگاھ ئۈچۈن كەفارەت كەلتۈرۈپ بولغاندىن كېيىن، ئۇ تىرىك تېكىنى كەلتۈرسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ئاندىن ھارۇن ئىككى قولىنى تىرىك تېكىنىڭ بېشىغا قويۇپ تۇرۇپ، ئۇنىڭ ئۈستىدە تۇرۇپ، ئىسرائىللارنىڭ بارلىق قەبىھلىكلىرى ۋە ئىتائەتسىزلىكلىرىنى ئېلىپ بارىدىغان گۇناھلىرىنى ئىقرار قىلىپ، ئۇلارنى تېكىنىڭ بېشىغا ئارتسۇن؛ ئاندىن ئۇنى يېنىدا تەييار تۇرىدىغان بىر ئادەمنىڭ قولى بىلەن چۆلگە ئەۋەتىۋەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","بۇ يول بىلەن تېكە ئۇلارنىڭ ھەممە قەبىھلىكلىرىنى ئۆز ئۈستىگە ئېلىپ، ئادەمزاتسىز چۆلگە كېتىدۇ. شۇڭا ئۇ تېكىنى چۆلگە قويۇۋەتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ــ ئاندىن ھارۇن جامائەت چېدىرىغا كىرىپ مۇقەددەس جايغا كىرگەن ۋاقىتتا كىيگەن كاناپ كىيىملىرىنى سېلىپ شۇ يەردە ئۇلارنى قويۇپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ئۇ مۇقەددەس يەردە ئۆز بەدىنىنى سۇدا يۇيۇپ، ئۆز كىيىملىرىنى كىيىپ تاشقىرىغا چىقىپ، ئۆزىنىڭ كۆيدۈرمە قۇربانلىقى بىلەن خەلقنىڭ كۆيدۈرمە قۇربانلىقىنى سۇنۇپ، شۇ يول بىلەن ئۆزى ۋە خەلق ئۈچۈن كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","شۇنداقلا ئۇ گۇناھ قۇربانلىقىنىڭ مېيىنى قۇربانگاھتا كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«ئازازەل»گە بېكىتىلگەن تېكىنى ئېلىپ بېرىپ قويۇۋەتكەن كىشى ئۆز كىيىملىرىنى يۇيۇپ، بەدىنىنى سۇدا يۇيۇپ، ئاندىن چېدىرگاھقا كىرىشكە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","كەفارەت كەلتۈرۈش ئۈچۈن قېنى ئەڭ مۇقەددەس جايغا ئېلىپ كىرىلىپ، گۇناھ قۇربانلىقى قىلىنغان تورپاق بىلەن گۇناھ قۇربانلىقى قىلىنغان تېكىنى بىرسى چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقىپ، ئۇلارنىڭ تېرىسى، گۆشى ۋە تېزەكلىرىنى ئوتتا كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ئۇلارنى كۆيدۈرگەن كىشى ئۆز كىيىملىرىنى يۇيۇپ، بەدىنىنى سۇدا يۇيۇپ، ئاندىن چېدىرگاھقا كىرىشكە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","ــ مانا بۇ سىلەرگە بىر ئەبەدىي قانۇن-بەلگىلىمە بولسۇن: ــ ھەر يەتتىنچى ئاينىڭ ئونىنچى كۈنىدە سىلەر ئۆز نەپسىڭلارنى تارتىپ ئۆزۈڭلارنى تۆۋەن تۇتۇڭلار ۋە ھېچقانداق ئىش قىلماڭلار؛ مەيلى يەرلىكلەر بولسۇن ياكى ئاراڭلاردا تۇرۇۋاتقان ياقا يۇرتلۇقلار بولسۇن شۇنداق قىلىشىڭلار كېرەك.    ");
INSERT INTO uigara_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","چۈنكى شۇ كۈنىدە سىلەرنى پاكلاشقا سىلەر ئۈچۈن كەفارەت كەلتۈرۈلىدۇ؛ پەرۋەردىگارنىڭ ئالدىدا سىلەر ھەممە گۇناھلىرىڭلاردىن پاك بولىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","بۇ كۈن سىلەرگە پۈتۈنلەي ئارام ئالىدىغان شابات كۈنى بولۇپ، نەپسىڭلارنى تارتىپ ئۆزۈڭلارنى تۆۋەن تۇتىسىلەر؛ بۇ ئەبەدىي بىر بەلگىلىمىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","كىمكى ئاتىسىنىڭ ئورنىدا كاھىنلىق يۈرگۈزۈش ئۈچۈن مەسىھ قىلىنىپ، خۇداغا ئاتاپ تىكلەنگەن كاھىن بولسا شۇ يول بىلەن كەفارەت كەلتۈرىدۇ. ئۇ كاناپتىن ئېتىلگەن مۇقەددەس كىيىمنى كىيىپ تۇرۇپ، ");
INSERT INTO uigara_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ئەڭ مۇقەددەس جاي ئۈچۈن كەفارەت كەلتۈرىدۇ؛ جامائەت چېدىرى بىلەن قۇربانگاھ ئۈچۈنمۇ كەفارەت كەلتۈرىدۇ؛ قالغان كاھىنلار بىلەن بارلىق خەلقنىڭ جامائىتى ئۈچۈن ھەم كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","بۇ بولسا سىلەر ئۈچۈن ئەبەدىي بىر بەلگىلىمە بولىدۇ؛ شۇنىڭ بىلەن ئىسرائىللارنى بارلىق گۇناھلىرىدىن پاكلاش ئۈچۈن يىلدا بىر قېتىم كەفارەت كەلتۈرۈپ بېرىسىلەر». شۇنىڭ بىلەن ھارۇن پەرۋەردىگار مۇساغا بۇيرۇغىنىدەك قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ھارۇن بىلەن ئوغۇللىرى ۋە بارلىق ئىسرائىللارغا مۇنداق دېگىن: ــ پەرۋەردىگار سىلەرگە بۇيرۇغان ھۆكۈم شۇكى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV17_3‏","004_17_3‏","LEV","17","3‏","4","ئىسرائىلنىڭ جەمەتلىرىدىن بولغان ھەرقانداق كىشى قۇربانلىق قىلماقچى بولۇپ، كالا ياكى قوي ياكى ئۆچكىنى جامائەت چېدىرىنىڭ كىرىش ئاغزىدا، پەرۋەردىگارنىڭ تۇرالغۇ چېدىرىنىڭ ئالدىغا، پەرۋەردىگارغا ئاتالغان قۇربانلىق سۈپىتىدە يېتىلەپ ئەپكەلمەي، بەلكى چېدىرگاھنىڭ ئىچىدە ياكى تاشقىرىدا بوغۇزلىسا، ئۇنىڭدىن ئاققان قان شۇ كىشىنىڭ گەدىنىگە ئارتىلىدۇ؛ بۇ ئادەم «قان تۆككەن» دەپ، ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","بۇ ھۆكۈمنىڭ مەقسىتى ئىسرائىللارنىڭ ھازىرقىدەك دالادا مال سويۇپ قۇربانلىق قىلىشنىڭ ئورنىغا، قۇربانلىقلىرىنى جامائەت چېدىرىنىڭ كىرىش ئاغزىدا پەرۋەردىگارنىڭ ئالدىغا كەلتۈرۈپ، كاھىنغا تاپشۇرۇپ پەرۋەردىگارغا ئىناقلىق قۇربانلىقلىرى سۈپىتىدە سۇنۇپ بوغۇزلىشى ئۈچۈندۇر. ");
INSERT INTO uigara_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","كاھىن قاننى ئېلىپ جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ يېنىدىكى پەرۋەردىگارنىڭ قۇربانگاھىنىڭ ئۈستىگە سېپىپ، پەرۋەردىگارغا خۇشبۇي كەلتۈرۈش ئۈچۈن ماينى كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","شۇنىڭ بىلەن ئۇلار ئەمدى بۇرۇنقىدەك بۇزۇقلۇق قىلىپ تېكە-جىنلارنىڭ كەينىدە يۈرۈپ، ئۇلارغا ئۆز قۇربانلىقلىرىنى ئۆتكۈزۈپ يۈرمىسۇن. مانا بۇ ئۇلار ئۈچۈن دەۋردىن-دەۋرگىچە ئەبەدىي بىر بەلگىلىمە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","سەن ئۇلارغا: ــ ئىسرائىلنىڭ جەمەتىدىن ياكى ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان ياقا يۇرتلۇقلاردىن بىرى كۆيدۈرمە قۇربانلىق ياكى باشقا قۇربانلىق ئۆتكۈزمەكچى بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ئۇنى پەرۋەردىگارغا ئاتاپ سۇنۇش ئۈچۈن جامائەت چېدىرىغا كىرىش ئاغزىنىڭ ئالدىغا كەلتۈرمىسە، ئۇ كىشى ئۆز خەلقلىرىدىن ئۈزۈپ تاشلانسۇن» ــ دېگىن. ");
INSERT INTO uigara_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ئەگەر ئىسرائىلنىڭ جەمەتىدىن بولغان ھەرقانداق ئادەم ياكى ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان ياقا يۇرتلۇقلار قان يېسە، مەن يۈزۈمنى قاننى يېگەن شۇ كىشىگە قارشى قىلىمەن، ئۇنى ئۆز خەلقىدىن ئۈزۈپ تاشلايمەن. ");
INSERT INTO uigara_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","چۈنكى ھەربىر جانىۋارنىڭ جېنى بولسا ئۇنىڭ قېنىدىدۇر؛ مەن ئۇنى جېنىڭلار ئۈچۈن قۇربانگاھ ئۈستىگە كەفارەت كەلتۈرۈشكە بەرگەنمەن. چۈنكى قان ئۆزىدىكى جاننىڭ ۋاسىتىسى بىلەن كەفارەت كەلتۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","شۇڭا بۇ سەۋەبتىن مەن ئىسرائىللارغا: ــ «سىلەرنىڭ ھېچبىرىڭلار قان يېمەسلىكىڭلار كېرەك، ئاراڭلاردا تۇرۇۋاتقان ياقا يۇرتلۇقلارمۇ قان يېمەسلىكى كېرەك» ــ دېگەنىدىم. ");
INSERT INTO uigara_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ئەگەر ئىسرائىللاردىن بىرى ياكى ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان ياقا يۇرتلۇقلارنىڭ بىرى يېيىشكە بولىدىغان بىر چارپاي ھايۋان ياكى قۇشنى ئوۋلاپ، قېنىنى تۆكسە، ئۇنى توپا بىلەن يېپىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","چۈنكى ھەربىر جانىۋارنىڭ جېنى بولسا، ئۇنىڭ قېنىدىن ئىبارەتتۇر. ئۇنىڭ جېنى قېنىدا بولغاچ مەن ئىسرائىللارغا: «سىلەر ھېچقانداق جانىۋارنىڭ قېنىنى يېمەڭلار، چۈنكى ھەربىر جانىۋارنىڭ جېنى ئۇنىڭ قېنىدىدۇر؛ كىمكى ئۇنى يېسە ئۈزۈپ تاشلىنىدۇ» ــ دېدىم. ");
INSERT INTO uigara_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","كىمدەكىم ئۆلۈپ قالغان ياكى يىرتقۇچلار بوغۇپ تىتما-تىتما قىلىۋەتكەن بىر ھايۋاننى يېسە، مەيلى ئۇ يەرلىك ياكى ياقا يۇرتلۇق بولسۇن ئۆز كىيىملىرىنى يۇيۇپ، سۇدا يۇيۇنسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن؛ ئاندىن ئۇ پاك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","لېكىن ئۇ ياكى كىيىملىرىنى يۇمىسا، ياكى سۇدا بەدىنىنى يۇمىسا، شۇ كىشى ئۆز قەبىھلىكىنىڭ جازاسىنى تارتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ «مەن بولسام خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","سىلەر ئىلگىرى تۇرغان مىسىر زېمىنىدىكىدەك ئىشلارنى قىلماڭلار ۋە ياكى مەن سىلەرنى ئېلىپ بارىدىغان قانائان زېمىنىدىكىدەك ئىشلارنى قىلماڭلار؛ ئۇلارنىڭ رەسىم-ئادەتلىرىدە يۈرمەڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","بەلكى مېنىڭ ھۆكۈملىرىمگە ئەمەل قىلىپ، قانۇن بەلگىلىمىلىرىمنى تۇتۇپ شۇ بويىچە مېڭىڭلار. مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","سىلەر چوقۇم مېنىڭ بەلگىلىمىلىرىم بىلەن ھۆكۈملىرىمنى تۇتۇشۇڭلار كېرەك؛ ئىنسان ئۇلارغا ئەمەل قىلىدىغان بولسا ئۇلارنىڭ سەۋەبىدىن ھاياتتا بولىدۇ. مەن پەرۋەردىگاردۇرمەن.    ");
INSERT INTO uigara_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ــ ھېچكىم ئۆزىگە يېقىن تۇغقان بولغان ئايالغا يېقىنلىق قىلىپ ئەۋرىتىنى ئاچمىسۇن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ئاناڭنىڭ ئەۋرىتىگە تەگمە، بۇ ئاتاڭنىڭ ئەۋرىتىگە تەگكىنىڭ بولىدۇ؛ ئۇ سېنىڭ ئاناڭ بولغاچقا ئۇنىڭ ئەۋرىتىگە تەگسەڭ بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ئاتاڭنىڭ ئايالىنىڭ ئەۋرىتىگىمۇ تەگمە، چۈنكى شۇنداق قىلساڭ ئاتاڭنىڭ ئەۋرىتىگە تەگكەندەك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","سەن ئاچا-سىڭلىڭنىڭ، بىر ئاتىدىن بولغان ياكى بىر ئانىدىن بولغان، ياكى شۇ ئۆيدە تۇغۇلغان ياكى باشقا يەردە تۇغۇلغان بولسۇن، ئۇنىڭ ئەۋرىتىگە تەگمە. ");
INSERT INTO uigara_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","سەن ئۆز ئوغلۇڭنىڭ قىزى ۋە ياكى قىزىڭنىڭ قىزىنىڭ ئەۋرىتىگە تەگمە؛ چۈنكى ئۇلارنىڭ ئەۋرىتى سەن ئۆزۈڭنىڭ ئەۋرىتىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","سەن ئاتاڭنىڭ ئايالىنىڭ قىزىنىڭ ئەۋرىتىگە تەگمە؛ ئۇ ئاتاڭدىن تۇغۇلغان، سېنىڭ ئاچا-سىڭلىڭ، شۇڭا ئۇنىڭ ئەۋرىتىگە تەگمە.    ");
INSERT INTO uigara_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","سەن ئاتاڭنىڭ ئاچا-سىڭلىسىنىڭ ئەۋرىتىگىمۇ تەگمە، چۈنكى ئۇ ئاتاڭنىڭ بىرتۇغقىنىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","سەن ئاناڭنىڭ ئاچا-سىڭىللىرىنىڭ ئەۋرىتىگىمۇ تەگمە، چۈنكى ئۇ ئاناڭنىڭ بىرتۇغقىنىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ئاتاڭنىڭ ئاكا-ئىنىلىرىنىڭ ئايالىنىڭ ئەۋرىتىگە تەگمە؛ ئۇلارنىڭ ئاياللىرىغا يېقىنلىق قىلما؛ چۈنكى ئۇلار سېنىڭ ھامماڭدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","سەن كېلىنىڭنىڭ ئەۋرىتىگە تەگمە؛ ئۇ سېنىڭ ئوغلۇڭنىڭ ئايالى بولغاچقا، ئۇنىڭ ئەۋرىتىگە تەگسەڭ بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","سەن ئاكا-ئىنىلىرىڭنىڭ ئايالىنىڭ ئەۋرىتىگە تەگمە؛ چۈنكى بۇ ئۆز ئاكا-ئىنىلىرىڭنىڭ ئەۋرىتىگە تەگكەندەك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","سەن بىر ئايالغا ۋە شۇنىڭ بىلەن بىرگە ئۇنىڭ قىزىنىڭ ئەۋرىتىگە تەگمە؛ شۇنداقلا ئۇنىڭ ئوغلىنىڭ قىزى ۋە قىزىنىڭ قىزىنىمۇ خوتۇنلۇققا ئېلىپ ئەۋرىتىگە تەگمە. ئۇلار بىر-بىرىگە يېقىن تۇغقان بولغاچقا، مۇنداق ئىش پەسەندىلىكتۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","سەن ئايالىڭ ھايات ۋاقتىدا، ئۇنىڭ ئاچا-سىڭلىسىنى خوتۇنلۇققا ئېلىپ ئەۋرىتىگە تەگمە. ئۇنداق قىلساڭ خوتۇنۇڭغا كۈندەشلىك ئازابىنى كەلتۈرىسەن. ");
INSERT INTO uigara_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","سەن بىر ئايالنىڭ ئادەت كۆرۈپ ناپاك تۇرغان ۋاقتىدا يېقىنلىق قىلىپ ئەۋرىتىگە تەگمە.    ");
INSERT INTO uigara_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","سەن ئۆز قوشناڭنىڭ ئايالى بىلەن زىنا قىلىپ ئۆزۈڭنى ئۇنىڭ بىلەن ناپاك قىلما. ");
INSERT INTO uigara_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","سەن ئۆز نەسلىڭدىن ھېچبىرىنى مولەك مەبۇدىغا ئاتاپ ئوتتىن ئۆتكۈزسەڭ قەتئىي بولمايدۇ. ئەگەر شۇنداق قىلساڭ خۇدايىڭنىڭ نامىنى ناپاك قىلغان بولىسەن. مەن ئۆزۈم پەرۋەردىگاردۇرمەن.    ");
INSERT INTO uigara_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","سەن ئاياللار بىلەن بىرگە بولغاندەك ئەر كىشى بىلەن بىرگە بولما. بۇ ئىش يىرگىنچلىكتۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","سەن ھېچ ھايۋان بىلەن مۇناسىۋەت قىلىپ ئۆزۈڭنى ناپاك قىلما؛ شۇنىڭدەك ئايال كىشىمۇ مۇناسىۋەت قىلدۇرۇش ئۈچۈن بىر ھايۋاننىڭ ئالدىغا بارمىسۇن. بۇ ئىش نىجىسلىقتۇر. ");
INSERT INTO uigara_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","سىلەر بۇ ئىشلارنى قىلىپ ئۆزۈڭلارنى ناپاك قىلماڭلار، چۈنكى مەن سىلەرنىڭ ئالدىڭلاردىن چىقىرىۋاتقان تائىپىلەر بولسا شۇنداق ئىشلارنى قىلىپ ئۆزلىرىنى ناپاك قىلغان ");
INSERT INTO uigara_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ۋە زېمىنىمۇ ناپاك بولغاندۇر. بۇنىڭ ئۈچۈن مەن ئۇ زېمىننىڭ قەبىھلىكىنى ئۆز بېشىغا چۈشۈرىمەن، شۇنىڭدەك ئۇ زېمىنمۇ ئۆزىدە تۇرۇۋاتقانلارنى قۇسۇپ چىقىرىۋېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","لېكىن سىلەر بولساڭلار مېنىڭ بەلگىلىمىلىرىم بىلەن ھۆكۈملىرىمنى تۇتۇڭلار؛ سىلەردىن ھېچكىم، مەيلى يەرلىك ياكى ئاراڭلاردا تۇرۇۋاتقان ياقا يۇرتلۇق بولسۇن بۇ يىرگىنچلىك ئىشلاردىن ھېچبىرىنى قىلمىسۇن ");
INSERT INTO uigara_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(چۈنكى بۇ بارلىق يىرگىنچلىك ئىشلارنى سىلەردىن ئىلگىرى شۇ زېمىندا تۇرغان خەلق قىلىپ كەلگەچكە، زېمىننىڭ ئۆزى ناپاك بولۇپ قالدى). ");
INSERT INTO uigara_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","شۇنداق قىلىپ زېمىننى ناپاك قىلساڭلار، زېمىن ئۆزى سىلەردىن ئىلگىرى ئۆزىدە تۇرغان ئەللەرنى قۇسۇپ چىقارغاندەك، سىلەرنىمۇ قۇسۇپ چىقىرىۋېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","چۈنكى بۇ يىرگىنچلىك ئىشلارنىڭ ھەرقاندىقىنى قىلغۇچى، ــ مۇنداق قىلمىشلارنى قىلغان ھەرقانداق كىشى ئۆز خەلقى ئارىسىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","سىلەر مەن سىلەرگە تاپىلىغىنىمغا ئەمەل قىلىشىڭلار زۆرۈردۇر؛ ــ دېمەك، سىلەر ئۆزۈڭلاردىن ئىلگىرى ئۆتكەنلەر تۇتقان شۇ يىرگىنچلىك رەسىم-قائىدىلەرنى تۇتۇپ، ئۆزۈڭلارنى ناپاك قىلماسلىقىڭلار كېرەك. مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","سەن ئىسرائىللارنىڭ پۈتكۈل جامائىتىگە سۆز قىلىپ ئۇلارغا مۇنداق دېگىن: ــ «مەن خۇدايىڭلار پەرۋەردىگار مۇقەددەس بولغاچقا، سىلەرمۇ مۇقەددەس بولۇشۇڭلار كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","سىلەر ھەربىرىڭلار ئاناڭلار بىلەن ئاتاڭلارنى ئىززەتلەڭلار؛ مېنىڭ شابات كۈنلىرىمنى بولسا، ئۇلارنى تۇتۇشۇڭلار كېرەك. مەن ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","سىلەر ئەرزىمەس بۇتلارغا تايانماڭلار، ئۆزۈڭلار ئۈچۈن قۇيما بۇتلارنى ياسىماڭلار. مەن ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن.    ");
INSERT INTO uigara_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","سىلەر پەرۋەردىگارغا ئىناقلىق قۇربانلىقىنى كەلتۈرۈشنى خالىساڭلار، قوبۇل قىلىنغۇدەك يول بىلەن ئۇنى سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","سىلەر ئۇنى سۇنغان كۈنى ۋە ئەتىسى ئۇ يېيىلسۇن؛ ئۈچىنچى كۈنىگە قالغىنى بولسا ئوتتا كۆيدۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ئەگەر ئۇنىڭدىن بىر قىسمى ئۈچىنچى كۈنى يېيىلسە قۇربانلىق ھارام ھېسابلىنىپ قوبۇل قىلىنمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","كىمكى ئۇنىڭدىن يېسە ئۆز گۇناھىنى ئۆز ئۈستىگە ئالىدۇ، چۈنكى ئۇ پەرۋەردىگارغا ئاتاپ مۇقەددەس قىلىنغان نەرسىنى ناپاك قىلدى؛ ئۇنداق كىشى ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","سىلەر زېمىنىڭلاردىكى ھوسۇلنى يىغساڭلار، سەن ئېتىزىڭنىڭ بۇلۇڭ-پۇشقاقلىرىغىچە تامام يىغىۋالما ۋە ھوسۇلۇڭدىن قالغان ۋاساڭنى تېرىۋالمىغىن. ");
INSERT INTO uigara_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ئۈزۈم تاللىرىڭنى پاساڭدىۋاتما ۋە ئۈزۈم تاللىرىدىن چۈشكەن ئۈزۈملەرنىمۇ تېرىۋالما، بەلكى بۇلارنى كەمبەغەللەر بىلەن مۇساپىرلارغا قويغىن. مەن ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","سىلەر ئوغرىلىق قىلماڭلار، ئالدامچىلىق قىلماڭلار، بىر-بىرىڭلارغا يالغان سۆزلىمەڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","مېنىڭ نامىم بىلەن يالغان قەسەم ئىچمەڭلار، ئۇنداق قىلساڭ خۇدايىڭنىڭ نامىنى بۇلغايسەن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ئۆز قوشناڭغا زۇلۇم قىلما، ئۇنىڭكىنى ئۆزۈڭنىڭ قىلىۋالما. مەدىكارنىڭ ھەققىنى كېچىچە يېنىڭدا قوندۇرۇپ قالما. ");
INSERT INTO uigara_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","گاس كىشىنى تىللىما، كور كىشىنىڭ ئالدىدا پۇتلىشاڭغۇ نەرسىنى قويما؛ بەلكى ئۆز خۇدايىڭدىن قورققىن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ھۆكۈم قىلغىنىڭلاردا ھېچ ناھەقلىق قىلماڭلار؛ نامراتقىمۇ يان باسماي، بايغىمۇ يۈز-خاتىرە قىلماي، بەلكى ئادىللىق بىلەن ئۆز قوشناڭ ئۈستىدىن توغرا ھۆكۈم قىلغىن. ");
INSERT INTO uigara_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ئۆز خەلقىڭنىڭ ئارىسىدا گەپ توشۇغۇچى بولۇپ يۈرمە؛ قوشناڭنىڭ جېنىغا ھېچقانداق زىيان-زەخمەت يەتكۈزمە. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","سەن كۆڭلۈڭدە ئۆز قېرىندىشىڭدىن نەپرەتلەنمىگىن؛ قوشناڭدا گۇناھ بولسا سەن ئۇنىڭ سەۋەبىدىن بېشىڭغا گۇناھ كېلىپ قالماسلىقى ئۈچۈن ئۇنىڭغا تەنبىھ-نەسىھەت بەرگىن. ");
INSERT INTO uigara_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","سەن ئىنتىقام ئالمىغىن ۋە ئۆز خەلقىڭنىڭ نەسلىگە ھېچ ئاداۋەتمۇ ساقلىمىغىن، بەلكى قوشناڭنى ئۆزۈڭنى سۆيگەندەك سۆيگىن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","سىلەر مېنىڭ قانۇن-بەلگىلىمىلىرىمنى تۇتۇڭلار. سەن ئۆز چارپايلىرىڭنى باشقا نەسىللەر بىلەن چېپىشتۇرما، ئېتىزىڭغا ئىككى خىل ئۇرۇق سالمىغىن، ئىككى خىل يىپتىن توقۇلغان كىيىمنى كىيمە. ");
INSERT INTO uigara_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ئەگەر بىر ئەر كىشى قىز-چوكان بىلەن يېتىپ مۇناسىۋەت ئۆتكۈزسە، ۋە ئۇ باشقا بىرى بىلەن ۋەدىلەشكەن دېدەك بولسا، بۇ دېدەكنىڭ ھۆرلۈك پۇلى تاپشۇرۇلمىغان بولسا، ياكى ئۇنىڭغا ھۆرلۈك بېرىلمىگەن بولسا، مۇۋاپىق جازا بېرىلسۇن. لېكىن قىز-چوكان ھۆر قىلىنمىغاچقا، ھەر ئىككىسى ئۆلتۈرۈلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ئەر كىشى بولسا ئۆزىنىڭ ئىتائەتسىزلىك قۇربانلىقىنى جامائەت چېدىرىنىڭ كىرىش ئاغزىنىڭ ئالدىغا، پەرۋەردىگارنىڭ ئالدىغا كەلتۈرسۇن؛ ئىتائەتسىزلىك قۇربانلىقى بىر قوچقار بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","كاھىن ئۇ ئىتائەتسىزلىك قۇربانلىقى ئۈچۈن كەلتۈرگەن قوچقارنى ئېلىپ ئۇنىڭ سادىر قىلغان گۇناھى ئۈچۈن پەرۋەردىگارنىڭ ئالدىدا كەفارەت كەلتۈرىدۇ؛ ئۇنىڭ قىلغان گۇناھى ئۇنىڭدىن كەچۈرۈلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","سىلەر زېمىنغا كىرىپ ھەرخىل يەيدىغان مېۋىلىك دەرەخلەرنى تىككەن بولساڭلار، مېۋىلىرىنى «خەتنىسىز» دەپ قاراڭلار؛ ئۈچ يىلغىچە بۇنى «خەتنىسىز» دەپ قاراپ ئۇنىڭدىن يېمەڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","تۆتىنچى يىلى ئۇلارنىڭ ھەممە مېۋىلىرى پەرۋەردىگارغا مەدھىيە سۈپىتىدە مۇقەددەس قىلىپ بېغىشلانسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ئاندىن بەشىنچى يىلدىن تارتىپ سىلەر ئۇلارنىڭ مېۋىلىرىدىن يېيىشكە باشلاڭلار. شۇنداق قىلساڭلار زېمىن مەھسۇلاتلىرىنى سىلەرگە زىيادە قىلىدۇ. مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","سىلەر قان چىقمىغان نەرسىنى يېمەڭلار. نە پالچىلىق نە جادۇگەرلىك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","سىلەر بېشىڭلارنىڭ چېكە-چۆرىسىدىكى چاچنى چۈشۈرۈپ دۈگىلەك قىلىۋالماڭلار، ساقالنىڭ ئۇچ-يانلىرىنى بۇزماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","سىلەر ئۆلگەنلەر ئۈچۈن بەدىنىڭلارنى زەخىم يەتكۈزۈپ تىلماڭلار، ئۆزۈڭلارغا ھېچقانداق گۈل-سۈرەت چەكمەڭلار. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","سەن قىزىڭنى بۇزۇقلۇق-پاھىشىلىككە سېلىپ ناپاك قىلمىغىن. بولمىسا، زېمىندىكىلەر بۇزۇقلۇق-پاھىشىلىككە بېرىلىپ، پۈتكۈل زېمىننى ئەيش-ئىشرەت قاپلاپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","سىلەر مېنىڭ شابات كۈنلىرىمنى تۇتۇڭلار، مېنىڭ مۇقەددەس جايىمنى ھۆرمەتلەڭلار. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","جىنكەشلەر بىلەن سېھىرگەرلەرگە تايانماڭلار، ئۇلارنىڭ كەينىدىن يۈرۈپ ئۆزۈڭلارنى ناپاك قىلماڭلار. مەن ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","ئاق باش كىشىنىڭ ئالدىدا ئورنۇڭدىن تۇر، قېرىلارنى ھۆرمەت قىلغىن؛ خۇدايىڭدىن قورققىن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","بىر مۇساپىر زېمىندا ئاراڭلاردا تۇرۇۋاتقان بولسا سىلەر ئۇنىڭغا زۇلۇم قىلماڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","بەلكى ئاراڭلاردا تۇرۇۋاتقان مۇساپىر سىلەرگە يەرلىك كىشىدەك بولسۇن؛ ئۇنى ئۆزۈڭنى سۆيگەندەك سۆيگىن؛ چۈنكى سىلەرمۇ مىسىر زېمىنىدا مۇساپىر بولغانسىلەر. مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","سىلەرنىڭ ھۆكۈم چىقىرىشىڭلاردا، ئۇزۇنلۇق، ئېغىرلىق ۋە ھەجىم ئۆلچەشتە ھېچقانداق ناھەقلىك بولمىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","سىلەردە ئادىل تارازا، ئادىل تارازا تاشلىرى، ئادىل ئەفاھ كەمچىنى بىلەن ئادىل ھىن كەمچىنى بولسۇن. مەن سىلەرنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن خۇدايىڭلار پەرۋەردىگاردۇرمەن.    ");
INSERT INTO uigara_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","سىلەر مېنىڭ بارلىق قانۇن-بەلگىلىمىلىرىم ۋە بارلىق ھۆكۈملىرىمنى تۇتۇپ، ئۇلارغا ئەمەل قىلىڭلار؛ مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","سەن ئىسرائىللارغا سۆز قىلىپ مۇنداق دېگىن: ــ ئەگەر ئىسرائىللارنىڭ بىرى ۋە ياكى ئىسرائىل زېمىنىدا تۇرۇۋاتقان مۇساپىرلارنىڭ بىرى مولەك بۇتىغا نەسلىنىڭ بىرىنى بېغىشلىسا، ئۇنىڭغا ئۆلۈم جازاسى بېرىلىشى كېرەك؛ زېمىندىكىلەر ئۇنى چالما-كېسەك قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ۋە مەن ئۆز يۈزۈمنى بۇ كىشىگە قارشى قىلىمەن، چۈنكى ئۆزى ئۆز ئەۋلادلىرىنىڭ بىرىنى مولەك بۇتىغا بېغىشلاپ مۇقەددەس جايىمنى پاسكىنا قىلىپ، مېنىڭ نامىمنى بۇلغىغىنى ئۈچۈن ئۇنى ئۆز خەلقىدىن ئۈزۈپ تاشلايمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ئەگەر زېمىندا تۇرۇۋاتقانلار ئۆز نەسلىدىن بىرىنى مولەككە بېغىشلىغاندا شۇ كىشىگە كۆزلىرىنى يۇمۇپ، ئۇنىڭ بىلەن كارى بولمىسا، شۇنداقلا ئۇنى ئۆلتۈرمىسە، ");
INSERT INTO uigara_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","مەن ئۆزۈم يۈزۈمنى ئۇ كىشى بىلەن ئۇنىڭ ئائىلىسىگە قارشى قىلىمەن، ئۇنى ۋە ئۇنىڭغا ئەگىشىپ بۇزۇقچىلىق قىلغۇچىلار، يەنى مولەكنىڭ كەينىدىن يۈرۈپ بۇزۇقچىلىق قىلغۇچىلارنىڭ ھەممىسىنى ئۆز خەلقىدىن ئۈزۈپ تاشلايمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","جىنكەشلەر بىلەن سېھىرگەرلەرگە تايىنىپ، ئۇلارنىڭ كەينىگە كىرىپ بۇزۇقچىلىق قىلىپ يۈرگۈچىلەر بولسا، مەن يۈزۈمنى شۇ كىشىلەرگە قارشى قىلىپ، ئۇنى ئۆز خەلقىدىن ئۈزۈپ تاشلايمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","شۇڭا ئۆزۈڭلارنى پاك قىلىپ مۇقەددەس بولۇڭلار، چۈنكى مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","قانۇن-بەلگىلىمىلىرىمنى تۇتۇپ، ئۇلارغا ئەمەل قىلىڭلار؛ مەن بولسام سىلەرنى مۇقەددەس قىلغۇچى پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","ئەگەر بىركىم ئۆز ئاتىسى ياكى ئانىسىنى قارغىسا، ئۇلارغا ئۆلۈم جازاسى بېرىلمىسە بولمايدۇ؛ چۈنكى ئۇ ئۆز ئاتا-ئانىسىنى قارغىغىنى ئۈچۈن ئۆز قېنى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ئەگەر بىركىم باشقىسىنىڭ ئايالى بىلەن زىنا قىلسا، يەنى ئۆز قوشنىسىنىڭ ئايالى بىلەن زىنا قىلسا، زىنا قىلغان ئەر بىلەن ئايال ئىككىسى ئۆلۈم جازاسىنى تارتمىسا بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ئەگەر بىرسى ئاتىسىنىڭ ئايالى بىلەن ياتسا، ئۆز ئاتىسىنىڭ ئەۋرىتىگە تەگكەن بولىدۇ؛ ئۇلار ئىككىسى ئۆلۈم جازاسىنى تارتمىسا بولمايدۇ؛ ئۇلارنىڭ قېنى ئۆز بېشىغا چۈشكەن بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","بىرسى ئۆز كېلىنى بىلەن ياتسا، ئىككىسى نىجىسلىق قىلغىنى ئۈچۈن ئۆلۈم جازاسىنى تارتمىسا بولمايدۇ؛ ئۇلارنىڭ قېنى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","بىرسى ئايال كىشى بىلەن ياتقاندەك ئەر كىشى بىلەن ياتسا ئىككىسى يىرگىنچلىك ئىش قىلغان بولىدۇ؛ ئۇلارغا ئۆلۈم جازاسى بېرىلمىسە بولمايدۇ. ئۆز قېنى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ئەگەر بىرسى قىزى بىلەن ئانىسىنى قوشۇپ خوتۇنلۇققا ئالسا پەسەندىلىك قىلغان بولىدۇ. ئەر بىلەن ئىككى ئايال ئوتتا كۆيدۈرۈلسۇن. شۇنىڭ بىلەن ئاراڭلاردا ھېچ پەسەندىلىك ئىش بولمايدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","بىرسى بىر ھايۋان بىلەن مۇناسىۋەت ئۆتكۈزسە، ئۇ ئۆلۈم جازاسىنى تارتسۇن، ھايۋاننىمۇ ئۆلتۇرۈڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ئەگەر ئايال كىشى بىر ھايۋاننىڭ قېشىغا بېرىپ مۇناسىۋەت قىلدۇرسا، ئايال بىلەن ھايۋاننىڭ ئىككىسىنى ئۆلتۈرۈڭلار؛ ئۆز قېنى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","بىرسى ئاچا-سىڭلىسىنى، يەنى ئاتىسىدىن ياكى ئانىسىدىن بولغان قىزنى ئېلىپ، ئەۋرىتىگە تەگسە ۋە بۇ قىزمۇ ئۇنىڭ ئەۋرىتىگە تەگسە ئۇياتلىق ئىش بولىدۇ؛ شۇنىڭ ئۈچۈن ئەر-ئايال ئىككىسى ئۆز خەلقىنىڭ كۆز ئالدىدىن ئۈزۈپ تاشلانسۇن؛ ئۇ ئۆز ئاچا ياكى سىڭلىسىنىڭ ئەۋرىتىگە تەگكەچكە، ئۆز قەبىھلىكى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","بىرسى ئادەت كۆرگەن ئاغرىق ۋاقتىدا بىر ئايال بىلەن بىرگە يېتىپ، ئۇنىڭ ئەۋرىتىگە تەگسە، ئۇنداقتا ئۇ ئۇنىڭ قان مەنبەسىگە تەگكەن، ئايالمۇ قان مەنبەسىنى ئېچىپ بەرگەن بولۇپ، ئىككىسى ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","سەن ئۆز ئاناڭنىڭ ئاچا-سىڭلىسى ۋە ئاتاڭنىڭ ئاچا-سىڭلىسىنىڭ ئەۋرىتىگە تەگمە؛ چۈنكى كىمكى شۇنداق قىلسا يېقىن تۇغقىنىنىڭ ئەۋرىتىگە تەگكەن بولىدۇ؛ ئۇلار ئىككىلىسىنىڭ ئۆز قەبىھلىكى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","بىرسى تاغىسىنىڭ ئايالى بىلەن ياتسا تاغىسىنىڭ ئەۋرىتىگە تەگكەن بولىدۇ؛ ئىككىلىسى ئۆز گۇناھىنى ئۆز بېشىغا ئالىدۇ؛ ئۇلار پەرزەنتسىز ئۆلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","بىرسى ئاكا-ئىنىسىنىڭ ئايالىنى ئالسا پاسكىنا بىر ئىش بولىدۇ. ئۇ ئۆز بىرتۇغقان ئاكا-ئىنىسىنىڭ ئەۋرىتىگە تەگكەن بولىدۇ؛ ئۇلار ئىككىلىسى پەرزەنتسىز قالىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","سىلەر مېنىڭ بارلىق قانۇن بەلگىلىمىلىرىم بىلەن بارلىق ھۆكۈملىرىمنى تۇتۇپ، بۇنىڭغا مۇۋاپىق ئەمەل قىلىڭلار؛ بولمىسا، مەن سىلەرنى ئېلىپ بېرىپ تۇرغۇزىدىغان زېمىن سىلەرنى قۇسۇپ چىقىرىۋېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","سىلەر مەن ئالدىڭلاردىن ھەيدىۋېتىدىغان ئەللەرنىڭ رەسىم-قائىدىلىرى بويىچە ماڭساڭلار بولمايدۇ؛ چۈنكى ئۇلار بۇ يىرگىنچلىك ئىشلارنىڭ ھەممىسىنى قىلىپ كەلدى، ۋە شۇنىڭ ئۈچۈن ئۇلار ماڭا يىرگىنچلىك بولدى. ");
INSERT INTO uigara_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","شۇنىڭ ئۈچۈن مەن سىلەرگە: «سىلەر ئۇلارنىڭ زېمىنىنى مىراس قىلىپ ئالىسىلەر؛ مەن شۇ سۈت بىلەن ھەسەل ئاقىدىغان زېمىننى سىلەرگە بېرىمەن»، دەپ ئېيتقانىدىم؛ سىلەرنى باشقا خەلقلەردىن ئايرىم قىلغان خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","شۇڭا سىلەر پاك ۋە ناپاك چارپايلارنى پەرق ئېتىپ، پاك ۋە ناپاك ئۇچار-قاناتلارنى تونۇپ، مەن سىلەر ئۈچۈن ئايرىپ، ناپاك قىلىپ بېكىتىپ بەرگەن جانىۋارلارنىڭ ئىچىدىن ھەرقاندىقى، چارپاي ياكى ئۇچار-قانات بولسۇن ياكى يەردە ئۆمىلىگۈچى جانىۋار بولسۇن، ئۇلارنىڭ ھېچبىرى بىلەن ئۆزۈڭلارنى ناپاك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","سىلەر ماڭا خاس پاك-مۇقەددەس بولۇشۇڭلار كېرەك؛ چۈنكى مەن پەرۋەردىگار پاك-مۇقەددەستۇرمەن، سىلەرنى ماڭا خاس بولسۇن دەپ بارلىق ئەللەردىن ئايرىم قىلغانمەن. ");
INSERT INTO uigara_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","جىنكەش ياكى سېھىرگەر بولغان ھەرقانداق ئەر ياكى خوتۇن كىشىگە ئۆلۈم جازاسى بېرىلمىسە بولمايدۇ؛ خەلق ئۇلارنى چالما-كېسەك قىلسۇن؛ ئۇلارنىڭ قېنى ئۆز بېشىغا چۈشكەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ سەن كاھىنلار بولغان ھارۇننىڭ ئوغۇللىرىغا مۇنداق دېگىن: ــ بىر كاھىن ئۆز خەلقىنىڭ ئارىسىدىكى ئۆلگەنلەر ۋەجىدىن ئۆزىنى ناپاك قىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","پەقەت ئۆزىنىڭ يېقىن تۇغقانلىرى ئۈچۈن ــ ئانىسى بىلەن ئاتىسى، ئوغلى بىلەن قىزى ۋە ئاكا-ئىنىسىنىڭ ئۆلۈكى تۈپەيلىدىن ئۆزىنى ناپاك قىلسا بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","شۇنىڭدەك ئەگەر ئاچا-سىڭلىسى ئەرگە تەگمەي پاك قىز ھالەتتە ئۆزى بىلەن بىللە تۇرۇۋاتقان بولسا، ئۇنىڭ ئۆلۈكى تۈپەيلىدىن ئۆزىنى ناپاك قىلسا بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","چۈنكى كاھىن ئۆز خەلقىنىڭ ئارىسىدا مۆتىۋەر بولغاچقا، ئۆزىنى ناپاك قىلىپ بۇلغىماسلىقى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","كاھىنلار بېشىنى يېرىم-ياتا قىلىپ چۈشۈرمەسلىكى، ساقىلىنىڭ ئۇچ-يانلىرىنى ھەم چۈشۈرمەسلىكى، بەدىنىگىمۇ زەخىم يەتكۈزۈپ تىلماسلىقى كېرەك، ");
INSERT INTO uigara_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","بەلكى ئۇلار ئۆز خۇداسىغا مۇقەددەس تۇرۇپ، خۇداسىنىڭ نامىنى بۇلغىماسلىقى كېرەك؛ چۈنكى ئۇلار پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىقلارنى، ئۆز خۇداسىنىڭ نېنىنى سۇنىدۇ؛ شۇڭا ئۇلار مۇقەددەس بولۇشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ئۇلار بىر ئايالنى ئۆز ئەمرىگە ئالغاندا پاھىشە ئايالنىمۇ، بۇزۇق ئايالنىمۇ ئالماسلىقى كېرەك ۋە ئېرى قويۇۋەتكەن ئايالنىمۇ ئالمىسۇن. چۈنكى كاھىن بولسا ئۆز خۇداسىغا خاس مۇقەددەس قىلىنغان. ");
INSERT INTO uigara_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ئۇ خۇدايىڭنىڭ نېنىنى سۇنغىنى ئۈچۈن ئۇ ساڭا نىسبەتەن مۇقەددەس دەپ سانىلىشى كېرەك؛ چۈنكى سىلەرنى مۇقەددەس قىلغۇچى پەرۋەردىگار ئۆزۈم مۇقەددەستۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ئەگەر بىر كاھىننىڭ قىزى پاھىشىلىك قىلىپ ئۆزىنى بۇلغىغان قىلسا، ئۆز ئاتىسىنى بۇلغىغان بولىدۇ؛ ئۇ ئوتتا كۆيدۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","بېشىغا مەسىھلەش زەيتۇن مېيى تۆكۈلگەن، كاھىنلىق كىيىملەرنى كىيىشكە تىكلەنگەن، ئۆز قېرىنداشلىرىنىڭ ئارىسىدا باش كاھىن قىلىنغان كىشى يالاڭباش بولمىسۇن، كىيىملىرىنىمۇ يىرتمىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ئۇ يەنە ھېچ ئۆلۈككە يېقىنلاشماسلىقى كېرەك، ھەتتا ئاتىسى ۋە ياكى ئانىسىنىڭ ئۆلۈكلىرىنىڭ ۋەجىدىن ئۆزىنى ناپاك قىلماسلىقى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ئۇ ۋەزىپىسىدە تۇرۇۋاتقاندا مۇقەددەس جايدىن ھەرگىز ئايرىلمىسۇن ۋە شۇنىڭدەك خۇداسىنىڭ مۇقەددەس جايىنى بۇلغىماسلىقى كېرەك؛ چۈنكى ئۇنىڭ خۇداسىنىڭ ئۇنى ئۆزىگە خاس قىلغان «مەسىھلەش مېيى» ئۇنىڭ بېشىدا تۇرىدۇ. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ئۇ خوتۇن ئالسا پاك قىزنى ئېلىشى كېرەك؛ ");
INSERT INTO uigara_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","تۇل ۋە ياكى ئەردىن قويۇۋېتىلگەن ئايال ۋە ياكى بۇزۇق ۋە ياكى پاھىشە ئايال بولسا بۇلارنى ئالماسلىقى، بەلكى ئۆز خەلقىدىن بولغان پاك قىزنى خوتۇنلۇققا ئېلىشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","بولمىسا ئۇ ئۆز خەلقىنىڭ ئارىسىدا ئۆز ئۇرۇقىنى ناپاك قىلىدۇ؛ چۈنكى ئۇنى مۇقەددەس قىلغۇچى پەرۋەردىگار مەندۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","سەن ھارۇنغا مۇنداق دېگىن: ــ «ئەۋلادتىن-ئەۋلادقىچە سېنىڭ نەسلىڭدىن بولغان بىرسى مېيىپ بولسا، خۇدانىڭ نېنىنى سۇنۇش ئۈچۈن يېقىن كەلمىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","مېيىپ بولغان ھەرقانداق كىشى ھەرگىز يېقىن كەلمىسۇن ــ ياكى كور بولسۇن، توكۇر بولسۇن، پاناق بولسۇن ياكى بىر ئەزاسى يەنە بىر جۈپىدىن ئۇزۇن بولغان ئادەم بولسۇن، ");
INSERT INTO uigara_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","پۇتى ياكى قولى سۇنۇق بولسۇن، ");
INSERT INTO uigara_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","دوك بولسۇن، پارپا بولسۇن، كۆزىدە ئاق بولسۇن، قىچىشقاق بولغان بولسۇن، تەمرەتكە باسقان بولسۇن ياكى ئۇرۇقدېنى ئېزىلگەن ھەركىم بولسۇن، ");
INSERT INTO uigara_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ھارۇن كاھىننىڭ نەسلىدىن بولغان ئۇنداق مېيىپ كىشىلەرنىڭ ھېچبىرى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان نەرسىلەرنى كەلتۈرۈشكە يېقىن بارمىسۇن؛ ئۇنداق كىشى مېيىپتۇر؛ ئۇ ئۆز خۇداسىنىڭ نېنىنى سۇنۇشقا يېقىن كەلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ھالبۇكى، ئۇ ئۆز خۇداسىنىڭ نېنىنى، يەنى «ئەڭ مۇقەددەس» ۋە «مۇقەددەس» ھېسابلانغان نەرسىلەرنىڭ ھەر ئىككىسىدىن يېسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","پەقەت ئۇ پەردىدىن ئۆتۈپ ئىچكىرىسىگە كىرمەسلىكى ياكى قۇربانگاھقىمۇ يېقىن بارماسلىقى كېرەك؛ چۈنكى ئۇ مېيىپتۇر؛ بولمىسا، ئۇ مېنىڭ مۇقەددەس جايلىرىمنى بۇلغىغان بولىدۇ؛ چۈنكى ئۇلارنى مۇقەددەس قىلغۇچى پەرۋەردىگار ئۆزۈمدۇرمەن». ");
INSERT INTO uigara_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","بۇ سۆزلەرنىڭ ھەممىسىنى مۇسا ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى ۋە ئىسرائىللارنىڭ ھەممىسىگە ئېيتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","سەن ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا مۇنداق دېگىن: ــ «سىلەر ئىسرائىللارنىڭ ماڭا ئاتىغان مۇقەددەس ھەدىيەلەرنى ئېھتىياتچانلىق بىلەن بىر تەرەپ قىلىڭلار، بولمىسا ئۇلار نامىمنى بۇلغىشى مۇمكىن. مەن پەرۋەردىگاردۇرمەن». ");
INSERT INTO uigara_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ئۇلارغا مۇنداق دېگىن: ــ «سىلەر ھەربىر دەۋرلەردە، بارلىق نەسىللىڭلاردىن ھەرقايسىسى ئىسرائىللار پەرۋەردىگارغا ئاتىغان پاك نەرسىلەرگە ناپاك ھالەتتە يېقىنلاشسا، ئۇنداق كىشى مېنىڭ ئالدىمدىن ئۈزۈپ تاشلىنىدۇ. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ھارۇننىڭ نەسلىدىن بىرى پېسە-ماخاۋ ياكى ئاقما كېسىلى بولغان بولسا، پاك بولمىغۇچە مۇقەددەس نەرسىلەردىن يېمىسۇن. بىركىم ئۆلۈكنىڭ سەۋەبىدىن ناپاك بولغان بىركىمگە ۋە ياكى مەنىيسى ئېقىپ كەتكەن كىشىگە تېگىپ كەتسە، ");
INSERT INTO uigara_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ياكى ئادەمنى ناپاك قىلىدىغان ئۆمىلىگۈچى جانىۋارغا تەگسە ياكى ھەرقانداق يۇقۇپ قالىدىغان ناپاكلىقى بار بىر ئادەمگە تېگىپ كەتسە، (ناپاكلىقى نېمىدىن بولۇشىدىن قەتئىينەزەر) ");
INSERT INTO uigara_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","مۇنداق نەرسىلەرگە تەگكەن كىشى كەچ كىرگۈچە ناپاك بولۇپ، مۇقەددەس نەرسىلەردىن يېمىسۇن. ئۇ بەدىنىنى سۇدا يۇسۇن ");
INSERT INTO uigara_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ئاندىن كۈن ئولتۇرغاندا پاك سانىلىپ، مۇقەددەس نەرسىلەردىن يېيىشكە بولىدۇ؛ چۈنكى بۇلار ئۇنىڭ ئوزۇقىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ئۇ ئۆزلۈكىدىن ئۆلگەن ۋە ياكى يىرتقۇچلار بوغۇپ قويغان ھايۋاننى يېيىش بىلەن ئۆزىنى ناپاك قىلمىسۇن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ئۇلار مېنىڭ بۇ تاپىلىغانلىرىمنى تۇتۇشى كېرەك؛ بولمىسا، بۇنىڭغا ئىخلاسسىزلىق قىلسا، شۇ ئۆلۈك تۈپەيلىدىن گۇناھكار بولۇپ ئۆلىدۇ؛ ئۇلارنى مۇقەددەس قىلغۇچى پەرۋەردىگار ئۆزۈمدۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","كاھىنلارغا يات بولغان ھېچقانداق كىشى مۇقەددەس نەرسىلەردىن يېمىسۇن. كاھىننىڭ يېنىدىكى مۇساپىر-مېھمان ۋە ياكى مەدىكارى بولسۇن ئۇلارمۇ مۇقەددەس نەرسىلەردىن يېمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ھالبۇكى، كاھىن ئۆزى پۇل چىقىرىپ سېتىۋالغان قۇل ئۇنىڭدىن يېيىشكە بولىدۇ؛ شۇنىڭدەك ئۇنىڭ ئۆيىدە تۇغۇلغان كىشىمۇ ئۇنىڭدىن يېسە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","كاھىننىڭ قىزى يات كىشىگە تەگكەن بولسا ئۇمۇ «كۆتۈرمە ھەدىيە» سۈپىتىدە ئاتالغان مۇقەددەس نەرسىلەردىن يېمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","لېكىن ئەگەر كاھىننىڭ قىزى تۇل بولۇپ قېلىپ، ياكى قويۇپ بېرىلىپ پەرزەنتسىز ھالەتتە ئاتىسىنىڭ ئۆيىگە يېنىپ كېلىپ، ياش ۋاقتىدىكىدەك ئولتۇرغان بولسا، ئۇنداقتا ئاتىسىنىڭ تائامىدىن يېيەلەيدۇ؛ لېكىن ھېچبىر يات كىشى ئۇنىڭدىن يېمەسلىكى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ئەگەر بىركىم بىلمەي، مۇقەددەس نەرسىلەردىن يەپ سالسا، ئۇنداقتا ئۇ ئۇنىڭغا شۇنىڭ بەشتىن بىرىنى قوشۇپ، مۇقەددەس نەرسىنىڭ ئۆزى بىلەن كاھىنغا قايتۇرۇپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","كاھىنلار ئىسرائىللارنىڭ پەرۋەردىگارغا ئاتىغان نەرسىلىرىنى بۇلغىماسلىقى كېرەك؛ ");
INSERT INTO uigara_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","بولمىسا، خەلق مۇقەددەس ھەدىيىلەردىن يېيىشى بىلەن، كاھىنلار خەلقنىڭ گەدىنىگە ئىتائەتسىزلىك گۇناھىنى يۈكلەپ قويغان بولىدۇ؛ چۈنكى ئۇلارنى مۇقەددەس قىلغۇچى پەرۋەردىگار ئۆزۈمدۇرمەن». ");
INSERT INTO uigara_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","سەن ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى ۋە ئىسرائىللارنىڭ ھەممىسىگە مۇنداق دېگىن: ــ ئەگەر ئىسرائىل جەمەتىدىن بىرى ۋە ياكى ئىسرائىل زېمىنىدا تۇرۇۋاتقان مۇساپىرلارنىڭ بىرى ئۆز قەسەملىرىگە باغلىق قۇربانلىق ياكى ئىختىيارىي قۇربانلىقنى سۇنۇپ، پەرۋەردىگارغا ئاتاپ كۆيدۈرمە قۇربانلىق قىلماقچى بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ئۇنداقتا ئۇ قوبۇل قىلىنىشى ئۈچۈن بېجىرىم ئەركەك كالا، قوي ياكى ئۆچكىلەردىن كەلتۈرۈڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ئەيىبى بولمىغان بىر جانىۋارنى سۇنۇشۇڭلار كېرەك؛ چۈنكى شۇنداق بولغىنى سىلەر ئۈچۈن قوبۇل قىلىنماس. ");
INSERT INTO uigara_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","بىرسى كالىلاردىن ياكى ئۇششاق مالدىن ئۆز قەسەملىرىگە باغلىق قۇربانلىق ياكى ئىختىيارىي قۇربانلىقنى سۇنۇپ، پەرۋەردىگارغا ئاتاپ ئىناقلىق قۇربانلىقى قىلماقچى بولسا، سۇنۇلغان ھايۋان قوبۇل قىلىنىشى ئۈچۈن بېجىرىم بولۇشى كېرەك؛ ئۇنىڭ ھېچقانداق ئەيىبى بولمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","كور ياكى ئاقساق-چولاق، چوناق ياكى يارىسى يىرىڭداپ كەتكەن، تەمرەتكە باسقان ياكى قوتۇر-چاقا بېسىپ قالغان ھايۋانلار بولسا ــ بۇلارنى پەرۋەردىگارغا ئاتاپ سۇنساڭلار ياكى بۇلارنى پەرۋەردىگارغا ئاتاپ قۇربانلىق سۈپىتىدە قۇربانگاھتا ئوتتا كۆيدۈرسەڭلار بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","تورپاق ياكى قوينىڭ مەلۇم جۈپ ئەزاسىدىن بىرى ئۇزۇنراق يا قىسقا بولسا، مۇنداقلارنى ئىختىيارىي قۇربانلىق سۈپىتىدە ئۆتكۈزسەڭ بولىدۇ، لېكىن قەسەمگە باغلىق بولسا قۇربانلىق ئۈچۈن قوبۇل قىلىنماس. ");
INSERT INTO uigara_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ئۇرۇقدىنى زەخىملەنگەن، ئېزىلىپ كەتكەن، يېرىلغان ياكى پىچىلغان ھايۋاننى پەرۋەردىگارغا ئاتاپ قۇربانلىق قىلماڭلار. مۇنداق ئىشنى ئۆز زېمىنىڭلاردىمۇ ھەرگىز قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","خۇدايىڭلارنىڭ نېنى سۈپىتىدە ياقا يۇرتلۇق كىشىنىڭ قولىدىن شۇنداق ھايۋانلاردىن ھېچقايسىسىنى ئېلىپ سۇنماڭلار؛ چۈنكى ئۇلار مېيىپ بولغاچقا، سىلەر ئۈچۈن قوبۇل قىلىنمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","بىر موزاي، قوزا ياكى ئوغلاق تۇغۇلسا يەتتە كۈنگىچە ئانىسىنى ئەمسۇن؛ سەككىزىنچى كۈنىدىن باشلاپ پەرۋەردىگارغا ئاتاپ ئوتتا سۇنىدىغان قۇربانلىق سۈپىتىدە قوبۇل بولۇشقا يارايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","مەيلى كالا بولسۇن، قوي بولسۇن، سىلەر ئانىسى بىلەن بالىسىنى بىر كۈندە بوغۇزلىماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","سىلەر پەرۋەردىگارغا ئاتاپ بىر تەشەككۈر قۇربانلىقى سۇنماقچى بولساڭلار، قوبۇل قىلىنىشقا لايىق بولغان يول بىلەن سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ئۇ سۇنۇلغان كۈنىدە يېيىلىشى كېرەك؛ ئۇنىڭدىن ھېچنېمىنى ئەتىسىگە قالدۇرماسلىقىڭلار كېرەك. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","سىلەر مېنىڭ ئەمرلىرىمنى چىڭ تۇتۇپ، ئۇلارغا ئەمەل قىلىڭلار. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","مېنىڭ مۇقەددەس نامىمنى بۇلغىماڭلار، مەن ئەمدى ئىسرائىللارنىڭ ئارىسىدا مۇقەددەس دەپ بىلىنىمەن. مەن سىلەرنى مۇقەددەس قىلغۇچى پەرۋەردىگار بولۇپ، ");
INSERT INTO uigara_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","خۇدايىڭلار بولۇشقا سىلەرنى مىسىر زېمىنىدىن چىقىرىپ كەلدىم. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ پەرۋەردىگار بېكىتكەن ھېيتلار، سىلەر مۇقەددەس سورۇنلار بولسۇن دەپ چاقىرىپ جاكارلايدىغان ھېيتلىرىم مانا مۇنۇلاردۇر: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","(ئالتە كۈن ئىش-ئەمگەك قىلىنسۇن؛ لېكىن يەتتىنچى كۈنى «خاس شابات كۈنى»، مۇقەددەس سورۇنلار كۈنى بولىدۇ؛ ئۇ كۈنى ھېچقانداق ئىش-ئەمگەك قىلماڭلار. قەيەردىلا تۇرساڭلار بۇ كۈن پەرۋەردىگارغا ئاتالغان شابات كۈنى بولىدۇ).    ");
INSERT INTO uigara_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","سىلەر بېكىتىلگەن كۈنلىرى مۇقەددەس سورۇنلار بولسۇن دەپ چاقىرىپ جاكارلايدىغان، پەرۋەردىگارنىڭ ھېيتلىرى مانا مۇنۇلاردۇر: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","بىرىنچى ئاينىڭ ئون تۆتىنچى كۈنى گۇگۇمدا پەرۋەردىگارغا ئاتالغان «ئۆتۈپ كېتىش ھېيتى» بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","شۇ ئاينىڭ ئون بەشىنچى كۈنى پەرۋەردىگارغا ئاتالغان «پېتىر نان» ھېيتى بولىدۇ؛ سىلەر يەتتە كۈنگىچە پېتىر نان يەيسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","بىرىنچى كۈنىدە سىلەر مۇقەددەس يىغىلىش قىلىپ، ھېچقانداق ئىش-ئەمگەك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","سىلەر يەتتە كۈنگىچە پەرۋەردىگارغا ئاتاپ ئوتتا سۇنىدىغان قۇربانلىقلارنى سۇنۇپ تۇرۇڭلار. يەتتىنچى كۈنىدە مۇقەددەس يىغىلىش بولىدۇ؛ ھېچقانداق ئىش-ئەمگەك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ سىلەر مەن ئۆزۈڭلارغا تەقدىم قىلىدىغان زېمىنغا كىرىپ، ئۇنىڭدىن ھوسۇل يىغقىنىڭلاردا، ھوسۇلۇڭلارنىڭ دەسلەپكى پىشقىنىدىن بىر باغلامنى كاھىننىڭ قېشىغا ئېلىپ بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","كاھىن سىلەر ئۈچۈن قوبۇل بولۇشقا ئۇنى پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتسۇن؛ ئۇنى پۇلاڭلاتقان ۋاقىت بولسا شاباتنىڭ ئەتىسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","سىلەر ئۇنى پۇلاڭلاتقان كۈندە سىلەر بىر ياشقا كىرگەن بېجىرىم بىر قوزىنى پەرۋەردىگارغا ئاتاپ كۆيدۈرمە قۇربانلىق سۈپىتىدە سۇنۇڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","شۇنىڭغا قوشۇپ ئاشلىق ھەدىيەسى سۈپىتىدە زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن بىر ئەفاھنىڭ ئوندىن بىرىنى پەرۋەردىگارغا خۇشبۇي كەلتۈرسۇن دەپ ئوتتا سۇنۇڭلار؛ بۇنىڭغا قوشۇپ شاراب ھەدىيەسى سۈپىتىدە شارابتىن بىر ھىننىڭ تۆتتىن بىرىنى سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","سىلەر خۇدايىڭلارغا خاس بولغان بۇ ھەدىيەنى سۇنىدىغان كۈندىن ئىلگىرى يېڭى ھوسۇلدىن ھېچنېمىنى، نە نان نە قوماچ نە كۆك باش بولسۇن يېمەڭلار. بۇ دەۋردىن-دەۋرگىچە سىلەر ئۈچۈن قەيەردە تۇرساڭلار ئەبەدىي بىر بەلگىلىمە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ئاندىن سىلەر شۇ شابات كۈننىڭ ئەتىسىدىن، يەنى شۇ بىر باغلامنى پۇلاڭلاتما ھەدىيە سۈپىتىدە سۇنغان كۈننىڭ ئەتىسىدىن تارتىپ، يەتتە ھەپتە ساناڭلار (ئۇلار تولۇق ھەپتە بولۇشى كېرەك)؛ ");
INSERT INTO uigara_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","يەتتىنچى شاباتنىڭ ئىككىنچى كۈنىگىچە ئەللىك كۈننى ساناڭلار؛ ئاندىن پەرۋەردىگارغا ئاتاپ يېڭى ھوسۇلدىن بىر ئاشلىق ھەدىيەسى سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ئۆزۈڭلار تۇرۇۋاتقان جايلاردىن پۇلاڭلاتما ھەدىيە سۈپىتىدە ئېسىل ئۇندىن بىر ئەفاھنىڭ ئوندىن ئىككىسىدە ئېتىلگەن ئىككى ناننى ئېلىپ كەلتۈرۈڭلار؛ ئۇلار ئېچىتقۇ سېلىپ ئېتىلگەن بولسۇن؛ بۇلار پەرۋەردىگارغا ئاتالغان دەسلەپكى ھوسۇل ھەدىيەسى دەپ ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ناندىن باشقا يەنە بىر ياشلىق يەتتە بېجىرىم قوزا، ياش بىر تورپاق ۋە ئىككى قوچقارنى كۆيدۈرمە قۇربانلىق سۈپىتىدە پەرۋەردىگارغا ئاتاپ سۇنۇڭلار؛ ئۇلارغا خاس ئاشلىق ھەدىيەلىرى ۋە شاراب ھەدىيەلىرىنى قوشۇپ، ھەممىسى پەرۋەردىگارغا خۇشبۇي كەلتۈرۈشكە سۇنۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","بۇنىڭدىن باشقا سىلەر گۇناھ قۇربانلىقى ئۈچۈن بىر تېكىنى، ئىناقلىق قۇربانلىقى ئۈچۈن بىر ياشلىق ئىككى قوزىنى كەلتۈرۈڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","كاھىن بۇلارنى، يەنى شۇ ئىككى قوزىنى دەسلەپكى ھوسۇل نانلىرىغا قوشۇپ پۇلاڭلاتما ھەدىيە سۈپىتىدە پەرۋەردىگار ئالدىدا پۇلاڭلاتسۇن. بۇلار بولسا پەرۋەردىگارغا ئاتالغان مۇقەددەس سانىلىپ، كاھىنغا تەگسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","شۇ كۈنى سىلەر «بۈگۈن بىزلەرگە مۇقەددەس يىغىلىش بولىدۇ» دەپ جاكارلاڭلار؛ شۇ كۈنى ھېچقانداق ئىش-ئەمگەك قىلماڭلار. بۇ سىلەر ئۈچۈن قەيەردىلا تۇرساڭلار ئەبەدىي بىر بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ئېتىزىڭنىڭ بۇلۇڭ-پۇچقاقلىرىغىچە تامام يىغىۋالماڭلار، ۋە ھوسۇلۇڭدىن قالغان ۋاساڭنى تېرىۋالمىغىن، بەلكى بۇلارنى كەمبەغەللەر بىلەن مۇساپىرلارغا قويغىن. مەن ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","پەرۋەردىگار مۇساغا مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ سىلەر يەتتىنچى ئاينىڭ بىرىنچى كۈنى تولۇق ئارام ئېلىپ، كانايلار چېلىنىش بىلەن ئەسلەتمە يوسۇندا ھېيت قىلىپ، مۇقەددەس سورۇنلارنى تۈزۈڭلار.    ");
INSERT INTO uigara_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ئۇ كۈندە ھېچقانداق ئىش-ئەمگەك قىلماڭلار؛ پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان بىر قۇربانلىق سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","يەتتىنچى ئاينىڭ ئونىنچى كۈنى بولسا كەفارەت كۈنى بولىدۇ؛ ئۇ كۈن سىلەر ئۈچۈن مۇقەددەس يىغىلىش كۈنى بولىدۇ؛ شۇ كۈنى نەپسىڭلارنى تارتىپ ئۆزۈڭلارنى تۆۋەن تۇتۇپ، پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىقنى سۇنۇڭلار؛    ");
INSERT INTO uigara_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ئۇ كۈندە ھېچقانداق ئىش-ئەمگەك قىلماڭلار؛ چۈنكى ئۇ بىر كەفارەت كۈنى بولۇپ، شۇ كۈن ئۆزۈڭلار ئۈچۈن خۇدايىڭلار پەرۋەردىگار ئالدىدا كەفارەت قىلىنىشقا بېكىتىلگەندۇر. ");
INSERT INTO uigara_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ھەركىم شۇ كۈنى نەپسىنى تارتماي ئۆزىنى تۆۋەن تۇتمىسا ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","كىمدەكىم شۇ كۈندىمۇ ھەرقانداق بىر ئىش قىلسا، مەن شۇ ئادەمنى ئۆز خەلقىدىن ئۈزۈپ تاشلايمەن. ");
INSERT INTO uigara_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","شۇ كۈنى ھېچقانداق ئىش قىلماڭلار؛ بۇ دەۋردىن-دەۋرگىچە سىلەر ئۈچۈن قەيەردە تۇرساڭلار بىر ئەبەدىي بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ئۇ كۈن سىلەر ئۈچۈن تولۇق ئارام ئالىدىغان شابات كۈنى بولىدۇ؛ نەپسىڭلارنى تارتىپ ئۆزۈڭلارنى تۆۋەن تۇتۇڭلار. شۇ ئاينىڭ توققۇزىنچى كۈنى گۇگۇمدىن تارتىپ ئەتىسى گۇگۇمغىچە شابات كۈنىگە رىئايە قىلىپ ئارام ئېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ يەتتىنچى ئاينىڭ ئون بەشىنچى كۈنىدىن باشلاپ، يەتتە كۈنگىچە پەرۋەردىگارنىڭ «كەپىلەر ھېيتى» بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","بىرىنچى كۈندە مۇقەددەس يىغىلىش بولىدۇ؛ ھېچقانداق ئىش-ئەمگەك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","يەتتە كۈنگىچە پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىق سۇنۇڭلار؛ سەككىزىنچى كۈندە سىلەرگە مۇقەددەس يىغىلىش بولىدۇ؛ پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىق سۇنۇڭلار. بۇ ئۆزى تەنتەنىلىك يىغىلىش بولغاچ، ئۇ كۈنى ھېچقانداق ئىش-ئەمگەك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","سىلەر «مۇقەددەس سورۇنلار بولسۇن» دەپ جاكارلايدىغان، يەنى پەرۋەردىگار بېكىتكەن ھېيتلار مانا شۇلاردۇر. شۇ سورۇنلاردا سىلەر ھەرقايسى كۈنگە بېكىتىلگىنى بويىچە، پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان ھەدىيە-قۇربانلىق، يەنى كۆيدۈرمە قۇربانلىق، ئاشلىق ھەدىيەسى، باشقا ھەرخىل قۇربانلىقلار ۋە شاراب ھەدىيەلەرنى سۇنىسىلەر؛ ");
INSERT INTO uigara_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","بۇلاردىن باشقا، پەرۋەردىگارنىڭ شابات كۈنلىرىنى تۇتىسىلەر ۋە پەرۋەردىگارغا ئاتاپ قالغان ھەدىيەلىرىڭلارنى بېرىپ، قەسەم قۇربانلىقلىرىڭلارنىڭ ھەممىسىنى ئادا قىلىپ، ئىختىيارىي قۇربانلىقلىرىڭلارنىڭ ھەممىسىنى سۇنىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","سىلەر ئەمدى زېمىندىن ھوسۇل-مەھسۇلاتلىرىنى يىغىپ بولۇپ، يەتتىنچى ئاينىڭ ئون بەشىنچى كۈنىدىن باشلاپ يەتتە كۈن پەرۋەردىگارنىڭ ھېيتىنى ئۆتكۈزۈڭلار. بىرىنچى كۈنى تولۇق ئارام ئېلىش بولىدۇ، سەككىزىنچى كونىدىمۇ تولۇق ئارام ئېلىش بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","بىرىنچى كۈنى سىلەر ئېسىل دەرەخلەردىن شاخ-پۇتاقلارنى چاتاپ، يەنى خورما دەرەخلىرى بىلەن قويۇق يوپۇرماقلىق دەرەخلەرنىڭ شاخلىرىنى كېسىپ، ئېرىق بويىدىكى سۆگەت چىۋىقلىرىنى قىرقىپ خۇدايىڭلار پەرۋەردىگار ئالدىدا يەتتە كۈننى شۇنداق شاد-خۇرام ئۆتكۈزىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","سىلەر ھەر يىلى بۇ يەتتە كۈننى پەرۋەردىگارغا ئاتىغان بىر ھېيت سۈپىتىدە ئۆتكۈزۈڭلار؛ دەۋردىن-دەۋرگىچە بۇ سىلەر ئۈچۈن ئەبەدىي بىر بەلگىلىمە بولىدۇ. سىلەر ھېيتنى يەتتىنچى ئايدا ئۆتكۈزۈڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","يەتتە كۈنگىچە كەپىلەردە تۇرۇڭلار. ئىسرائىلدا تۇغۇلغانلارنىڭ ھەممىسى كەپىدە تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","بۇنىڭ بىلەن مەن ئىسرائىللارنى مىسىر زېمىنىدىن چىقارغىنىمدا، ئۇلارنى كەپىلەردە تۇرغۇزغىنىمنى ئەۋلادلىرىڭلار بىلىدۇ. ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","شۇنداق قىلىپ مۇسا پەرۋەردىگارنىڭ بېكىتكەن شۇ ھېيتلىرىنى ئىسرائىللارغا بايان قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ئىسرائىللارغا چىراغ ھەمىشە يېنىق تۇرۇشى ئۈچۈن زەيتۇندىن سوقۇپ چىقىرىلغان ساپ ماينى ساڭا ئېلىپ كېلىشكە بۇيرۇغىن. ");
INSERT INTO uigara_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ھارۇن جامائەت چېدىرىنىڭ ئىچىدە، ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئۇدۇلىدىكى پەردىنىڭ سىرتىدا ھەر كېچىسى ئەتىگەنگىچە پەرۋەردىگارنىڭ ئالدىدا چىراغلارنى شۇنداق پەرلەپ تۇرسۇن. بۇ دەۋردىن-دەۋرگىچە سىلەر ئۈچۈن ئەبەدىي بىر بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ھارۇن ھەمىشە پەرۋەردىگارنىڭ ئالدىدا بۇ چىراغلارنى پاك چىراغداننىڭ ئۈستىگە تىزىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","سەن يەنە ئېسىل بۇغداي ئۇنىدىن ئون ئىككى توقاچنى ئەتكىن. ھەربىر توقاچ بىر ئەفاھنىڭ ئوندىن ئىككىسىگە باراۋەر بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ئاندىن سەن پەرۋەردىگارنىڭ ئالدىدىكى پاك شىرەنىڭ ئۈستىگە ئالتىدىن ئىككى قاتار قىلىپ تىزغىن. ");
INSERT INTO uigara_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ھەربىر قاتارنىڭ ئۈستىگە ساپ مەستىكى قويغىن؛ شۇنىڭ بىلەن ئۇلار پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان ھەدىيە، ئەسلەتمە نان بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","بۇلارنى ئۇ ئىسرائىللارغا ۋاكالىتەن ھەربىر شابات كۈنى پەرۋەردىگارنىڭ ئالدىدا تىزسۇن؛ بۇ ئەبەدىي بىر ئەھدىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","نانلار ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا تەۋە بولىدۇ؛ ئۇلار ئۇلارنى مۇقەددەس جايدا يېسۇن؛ چۈنكى بۇ نەرسىلەر پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلغان نەرسىلەر ئىچىدە «ئەڭ مۇقەددەسلەرنىڭ بىرى» دەپ سانىلىپ، ھارۇنغا تەۋە بولىدۇ؛ بۇ ئەبەدىي بىر بەلگىلىمىدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ئانىسى ئىسرائىلىي، ئاتىسى مىسىرلىق بىر ئوغۇل بار ئىدى. ئۇ ئىسرائىللارنىڭ ئارىسىغا باردى؛ ئۇ چېدىرگاھتا بىر ئىسرائىلىي بىلەن ئۇرۇشۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ئۇلار سوقۇشقاندا ئىسرائىلىي ئايالنىڭ ئوغلى كۇپۇرلۇق قىلىپ، مۇقەددەس نامنى بۇلغاپ قارغىدى. خەلق ئۇنى مۇسانىڭ ئالدىغا ئېلىپ باردى. ئۇ كىشىنىڭ ئانىسىنىڭ ئىسمى شېلومىت بولۇپ، ئۇ دان قەبىلىسىدىن بولغان دىبرىنىڭ قىزى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","شۇنىڭ بىلەن ئۇلار پەرۋەردىگارنىڭ ھۆكۈم بۇيرۇقى چىققۇچە ئۇ كىشىنى سولاپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ئاندىن پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","قارغىغۇچىنى چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقىڭلار. ئۇنىڭ ئېيتقىنىنى ئاڭلىغانلارنىڭ ھەممىسى قوللىرىنى ئۇنىڭ بېشىغا قويسۇن، ئاندىن پۈتكۈل جامائەت بىر بولۇپ ئۇنى چالما-كېسەك قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ھەمدە سەن ئىسرائىللارغا مۇنداق دېگىن: ــ ئەگەر بىركىم ئۆز خۇداسىنى ھاقارەتلەپ قارغىسا ئۆز گۇناھىنى تارتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","پەرۋەردىگارنىڭ نامىغا كۇپۇرلۇق قىلغان ھەرقانداق كىشى ئۆلۈمگە مەھكۇم قىلىنسۇن؛ پۈتكۈل جامائەت چوقۇم بىر بولۇپ ئۇنى چالما-كېسەك قىلسۇن؛ مەيلى ئۇ مۇساپىر بولسۇن ياكى يەرلىك بولسۇن، مۇقەددەس نامغا كۇپۇرلۇق قىلسا ئۆلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","ئەگەر بىرسى باشقا بىرسىنى ئۇرۇپ ئۆلتۈرسە، ئۇ ئۆلۈمگە مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","بىرسى بىر چارپاينى ئۆلتۈرسە، ئۇنىڭ ئۈچۈن ھايۋاننى تۆلەپ، جانغا-جان تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","بىركىم ئۆز قوشنىسىنى مېيىپ قىلسا، ئۇ ئۆزگىگە قانداق قىلغان بولسا، ئۇنىڭ ئۆزىگىمۇ شۇنداق قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","بىرەر ئەزاسى سۇندۇرۇۋېتىلگەن بولسا، ئۇنىڭمۇ سۇندۇرۇلسۇن؛ كۆزىگە-كۆز، چىشىغا-چىش ناكار قىلىنسۇن؛ باشقا كىشىنى قانداق زەخىملەندۈرگەن بولسا ئۇمۇ ھەم شۇنداق قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","كىمدەكىم بىر چارپاينى ئۆلتۈرسە، چارپاي تۆلەپ بەرسۇن؛ ئادەمنى ئۇرۇپ ئۆلتۈرگەن كىشى بولسا، ئۆلۈم جازاسىغا مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","سىلەردە بىرلا قانۇن بولسۇن. مۇساپىر ياكى يەرلىك بولسۇن، باراۋەر مۇئامىلە قىلىنسۇن؛ چۈنكى مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","مۇسا ئىسرائىللارغا شۇلارنى دېدى؛ شۇنىڭ بىلەن ئۇلار شۇ قارغىغۇچىنى چېدىرگاھنىڭ تاشقىرىغا ئېلىپ چىقىپ، چالما-كېسەك قىلدى. شۇنداق قىلىپ، ئىسرائىللار پەرۋەردىگارنىڭ مۇساغا ئەمر قىلغىنىدەك قىلدى. ");
INSERT INTO uigara_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","پەرۋەردىگار سىناي تېغىدا مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ مەن سىلەرگە بېرىدىغان زېمىنغا كىرگىنىڭلاردا ئۇ زېمىننىڭ ئۆزىمۇ پەرۋەردىگارغا ئاتاپ بىر شابات ئارامىنى ئالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","سەن ئالتە يىل ئېتىزىڭنى تېرىپ، ئالتە يىل تاللىق بېغىڭنى چاتاپ، ئۇلاردىن ھوسۇللارنى يىغقىن؛ ");
INSERT INTO uigara_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ئەمما يەتتىنچى يىلى زېمىننىڭ ئۆزى ئۈچۈن بىر «شاباتلىق ئارام» بولسۇن؛ ئۇ پەرۋەردىگارغا ئاتالغان بىر «شابات» ھېسابلىنىدۇ. شۇ يىلى سەن ئېتىزىڭنى تېرىمايسەن ۋە تاللىقىڭنى چاتىمايسەن. ");
INSERT INTO uigara_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ئۆزلۈكىدىن ئۈنۈپ چىققان ھوسۇلنى ئورمايسەن؛ ۋە چاتالمىغان تاللىرىڭنىڭ ئۈزۈملىرىنى ئۈزمەيسەن؛ چۈنكى شۇ يىل زېمىن ئارام ئالىدىغان يىلدۇر. ");
INSERT INTO uigara_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ھالبۇكى، زېمىن شابات يىلىدا چىقارغان ھوسۇل ھەممىڭلارغا ئوزۇق بولىدۇ، يەنى ئۆزۈڭ ئۈچۈن، قۇل-دېدىكىڭ ئۈچۈن، مەدىكارىڭ ئۈچۈن ۋە سېنىڭكىدە تۇرۇۋاتقان مۇساپىر ئۈچۈن، شۇنىڭدەك مال-ۋارانلىرىڭ ئۈچۈن ");
INSERT INTO uigara_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ۋە زېمىنىڭدىكى ياۋايى ھايۋانلار ئۈچۈنمۇ ئوزۇق بولىدۇ؛ زېمىننىڭ ھەممە ھوسۇلى ئوزۇق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","شۇنىڭدەك سەن يەتتە قېتىملىق شابات يىلىنى، يەنى يەتتە ھەسسە يەتتە يىلنى سانىغىن؛ يەتتە شابات يىل كۈنلىرى قىرىق توققۇز يىل بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","شۇنچىلىك ۋاقىت ئۆتۈپ، يەتتىنچى ئايدا، ئاينىڭ ئونىنچى كۈنى، كەفارەت كۈنىدە بۇرغا چېلىپ ساداسىنى يۇقىرى چىقىرىسىلەر؛ كەفارەت كۈنىنىڭ ئۆزىدە سىلەر پۈتكۈل زېمىنىڭلاردا بۇرغىنىڭ ساداسىنى ئاڭلىتىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","شۇ ئەللىكىنچى يىلىنى سىلەر مۇقەددەس دەپ بىلىپ، پۈتكۈل زېمىندا ئۇنىڭدا بارلىق تۇرۇۋاتقانلارنىڭ ھەممىسىگە ئازادلىقنى جاكارلىشىڭلار كېرەك. شۇ يىل سىلەرگە «ئازادلىق يىلى» بولىدۇ، ھەربىرىڭلار ئۆز يەر-مۈلۈكلىرىڭلارغا قايتىسىلەر، ھەربىرىڭلار ئۆز ئائىلە-جەمەتىڭلارغا قايتىپ بارىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","بۇ ئەللىكىنچى يىلى سىلەرگە بىر ئازادلىق يىلى بولسۇن؛ ئۇ يىلى ھېچ نېمە تېرىمايسىلەر، ئۆزلۈكىدىن ئۈنۈپ چىققان ھوسۇلنىمۇ ئورمايسىلەر ۋە چاتالمىغان تاللىرىڭلارنىڭ ئۈزۈملىرىنىمۇ يىغمايسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","چۈنكى بۇ ئازادلىق يىلى بولۇپ، سىلەرگە مۇقەددەس ھېسابلانسۇن؛ ئۇنىڭ ھوسۇلىنى بولسا، ئېتىز-دالىلاردىن تېپىپ ھەممىڭلار يەيسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ئازادلىق يىلى ئاراڭلاردىكى ھەربىر ئادەم ئۆز يەر-مۈلكىگە قايتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","سىلەر قوشناڭلارغا بىرنېمە سېتىپ بەرسەڭلار، ياكى قوشناڭلاردىن بىرنېمە سېتىۋالساڭلار، بىر-بىرىڭلارنى بوزەك قىلماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","قوشناڭدىن يەرنى سېتىۋالساڭ، ئۇنداقتا «ئازادلىق يىلى»دىن كېيىن ئۆتكەن يىللارنىڭ سانىنى ھېسابلاپ ئۇنىڭدىن سېتىۋېلىشىڭ كېرەك؛ ئۇمۇ قالغان يىللارنىڭ سانىغا قاراپ، يەرنىڭ كېيىنكى ھوسۇللىرىغا ئاساسەن ساڭا سېتىپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","«ئازادلىق يىلى»غىچە بولغان يىللار كۆپرەك بولسا، باھاسىنى شۇنىڭغا مۇۋاپىق يۇقىرى كۆتۈرىسەن؛ قالغان يىللار ئازراق بولسا، باھاسىنى شۇنىڭغا مۇۋاپىق كېمەيتسۇن. چۈنكى قالغان يىللارنىڭ ھوسۇللىرى قانچە بولسا، ئۇ شۇ بويىچە ساڭا سېتىپ بېرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","سىلەر بىر-بىرىڭلارنى بوزەك قىلماڭلار، بەلكى خۇدايىڭلاردىن قورقۇڭلار؛ چۈنكى مەن بولسام خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","سىلەر مېنىڭ بەلگىلىمىلىرىمنى تۇتۇپ، ھۆكۈملىرىمدە تۇرۇپ، شۇلارغا ئەمەل قىلىڭلار؛ سىلەر شۇنداق قىلساڭلار، زېمىنىڭلاردا تىنچ-ئامان تۇرىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","شۇنىڭ بىلەن زېمىن سىلەرگە ئۆز مېۋىسىنى بېرىدۇ، سىلەر تويغۇدەك يەپ، ئۇنىڭدا تىنچ-ئامان تۇرىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ئەگەر سىلەر: ــ مانا، بىزگە تېرىپ ھوسۇلنى يىغىشقا ئىجازەت بېرىلمىسە، يەتتىنچى يىلى نېمە يەيمىز، دەپ سورىساڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","سىلەرگە مەلۇم بولسۇنكى، ئالتىنچى يىلىدا ئۈچ يىلنىڭ ھوسۇلىنى بەرسۇن دەپ، مەن ئۈستۈڭلارغا بەرىكىتىمنى «چۈش» دەپ بۇيرۇيمەن. ");
INSERT INTO uigara_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ۋە شۇنداق بولىدۇكى، سىلەر سەككىزىنچى يىلى تېرىيسىلەر، ئەمما توققۇزىنچى يىلىغىچە ئېشىپ قالغان كونا ھوسۇلدىن تېخىچە يەيسىلەر؛ شۇ توققۇزىنچى يىلىغىچە سىلەر كونا ئاشلىقتىن يەيسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","يەر-زېمىن سېتىلسا، مەڭگۈلۈك سېتىلمىسۇن، چۈنكى زېمىننىڭ ئۆزى مېنىڭكىدۇر، سىلەر بولساڭلار مېنىڭ يېنىمدىكى مۇساپىر ۋە مېھمان، خالاس. ");
INSERT INTO uigara_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","سىلەر ئىگە بولىدىغان پۈتكۈل زېمىندا يەر-زېمىننىڭ ئىگىلىرىگە ئۇنى «قايتۇرۇۋېلىش ھوقۇقى»نى يارىتىپ بېرىشىڭلار كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ئەگەر قېرىنداشلىرىڭلاردىن بىرى كەمبەغەللىشىپ، ئۆز مىراس يېرىنى سېتىۋەتكەن بولسا، ئۇنىڭ يېقىن تۇغقىنى، يەنى «ھەمجەمەت شاپائەتچى»سى كېلىپ ئۆز قېرىندىشى ساتقان يەرنى قايتۇرۇپ سېتىۋالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ئەگەر ئۇنىڭ ھېچ شاپائەتچى تۇغقىنى بولمىسا، لېكىن ئۇ ياندۇرۇۋېلىشقا كېرەكلىك پۇلنى تاپالىسا، ");
INSERT INTO uigara_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ئۇنداقتا ساتقىنىغا قانچە يىل بولغانلىقىنى ھېسابلاپ، ئازادلىق يىلىغىچە قالغان يىللار ئۈچۈن سېتىۋالغان كىشىگە مۇۋاپىق پۇل بېرىپ، ئۆز يېرىگە قايتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","لېكىن ئەگەر ئۇ ياندۇرۇۋېلىشقا كېرەكلىك پۇلنى تاپالمىسا، ئۆزى سېتىپ بەرگەن يەر ئازادلىق يىلىغىچە ئالغۇچىنىڭ قولىدا تۇرسۇن؛ ئازادلىق يىلى كەلگەندە يەر يەر سېتىۋالغۇچىنىڭ قولىدىن چىقسۇن، ئۆز ئىگىسى ئۆز يەر-مۈلكىگە قايتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ئەگەر بىرسى سېپىللىق شەھەرنىڭ ئىچىدىكى بىر تۇرالغۇ ئۆينى ساتقان بولسا، سېتىپ بىر يىل ئىچىدە ئۇنى ياندۇرۇۋېلىش ھوقۇقى باردۇر. تولۇق بىر يىل تۈگەپ بولغۇچە، ياندۇرۇۋېلىش ھوقۇقى باردۇر. ");
INSERT INTO uigara_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","لېكىن پۈتۈن يىل ئىچىدە ياندۇرۇۋېلىنمىسا، سېپىللىق شەھەرنىڭ ئىچىدىكى بۇ ئۆي نەسىلدىن-نەسىلگە ئالغان كىشىنىڭ قولىدا بولۇپ، ئازادلىق يىلى كەلسىمۇ ياندۇرۇلماس. ");
INSERT INTO uigara_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","لېكىن سېپىلسىز كەنتلەرنىڭ ئۆيلىرى بولسا زېمىننىڭ ئېتىزلىرىدەك ھېسابلىنىدۇ؛ ئۇلارنى ياندۇرۇپ سېتىۋالغىلى بولىدۇ؛ ئازادلىق يىلى كەلگەندە ئەسلى ئىگىسىنىڭ قولىغا ياندۇرۇلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","لېكىن لاۋىي شەھەرلىرىدە بولسا، لاۋىيلار ئۆز مىراسى بولغان شەھەرلەردىكى ئۆيلىرىنى خالىسا ھەرقاچان قايتۇرۇۋېلىش ھوقۇقى باردۇر. ");
INSERT INTO uigara_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","لاۋىيلاردىن بىرى ئۆيلىرىنى، يەنى ئۆز مىراسى بولغان شەھەردىكى بىر ئۆينى قايتۇرۇۋېلىش ھوقۇقى بار بولسىمۇ، لېكىن قايتۇرۇپ ئالمىغان بولسا، ئۇنداق ئەھۋالدا ئۇ ئازادلىق يىلى كەلگەندە ياندۇرۇلىدۇ؛ چۈنكى لاۋىي شەھەرلىرىنىڭ ئۆيلىرى بولسا لاۋىيلارنىڭ ئىسرائىللارنىڭ ئارىسىدىكى مىراسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","شۇنداق ھەم بۇلارنىڭ شەھەرلىرىنىڭ چۆرىسىدىكى ئېتىز-يەرلىرى بولسا، ئۇلارنىڭ ئەبەدىي مىراسى بولغاچقا، سېتىلسا بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","ساڭا قوشنا بولغان، قېرىنداشلىرىڭلاردىن بىرى كەمبەغەللىشىپ، ئۆز جېنىنى باقالماي قالسا، سەن ئۇنى مۇساپىر ياكى ياقا يۇرتلۇق مېھماندەك يېنىڭدا تۇرغۇزۇپ، ئۇنىڭدىن خەۋەر ئالغىن. ");
INSERT INTO uigara_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","سەن ئۇنىڭدىن ئۆسۈم ۋە ياكى پايدا ئالمىغىن؛ سەن خۇدايىڭدىن قورقۇپ، قېرىندىشىڭنى قېشىڭدا تۇرۇشقا قويغىن. ");
INSERT INTO uigara_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","پۇلۇڭنى ئۇنىڭغا ئۆسۈمگە بەرمە، ئاشلىقىڭنىمۇ پايدا ئېلىش مەقسىتىدە ئۇنىڭغا ئۆتنە بەرمىگىن. ");
INSERT INTO uigara_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","خۇدايىڭلار بولۇشقا، قانائان زېمىنىنى سىلەرگە بېرىشكە سىلەرنى مىسىر زېمىنىدىن چىقىرىپ كەلگەن خۇدايىڭلار پەرۋەردىگار ئۆزۈمدۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","ئەگەر ساڭا قوشنا بولغان قېرىندىشىڭ كەمبەغەللىشىپ، ئۆزىنى ساڭا ساتسا، ئۇنى قۇلدەك قۇللۇق خىزمىتىگە سالمىغىن؛ ");
INSERT INTO uigara_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","بەلكى ئۇ قېشىڭدا مەدىكار ياكى مۇساپىردەك تۇرسۇن؛ ئازادلىق يىلىغىچە سېنىڭ خىزمىتىڭدە بولسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ئاندىن ئازاد بولۇپ ئۆزى بىلەن بالىلىرى قېشىڭدىن چىقىپ، ئۆز جەمەتىگە يېنىپ بېرىپ، ئاتا-بوۋىلىرىنىڭ يەر-مۈلكىگە قايتسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","چۈنكى ئۇلار مەن ئۆزۈم مىسىر زېمىنىدىن چىقىرىپ ئېلىپ كەلگەن قۇل-بەندىلىرىم بولغاچقا، ئۇلارنى قۇلدەك سېتىشقا يول قويماڭلار. ");
INSERT INTO uigara_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","سەن ئۇلارغا قاتتىق قوللۇق بىلەن خوجىلىق قىلمايسەن، بەلكى خۇدايىڭدىن قورققىن. ");
INSERT INTO uigara_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","لېكىن ئۆزۈڭگە قۇل ياكى دېدەك ئالماقچى بولساڭ، ئۇلارنى ئەتراپتىكى يات ئەللەردىن شۇنداق قۇل يا دېدەك سېتىۋالساڭ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","بۇلاردىن باشقا، ئاراڭلاردا ئولتۇراقلاشقان مۇساپىرلارنىڭ پەرزەنتلىرىنى ۋە شۇلارنىڭ جەمەتىدىن، يەنى سىلەر بىلەن بىللە تۇرۇۋاتقان، زېمىنىڭلاردا تۇغۇلغانلاردىن قۇللار سېتىۋالساڭلار بولىدۇ؛ شۇنىڭ بىلەن ئۇلار سىلەرنىڭ مۈلكۈڭلار بولۇپ قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","سىلەر مۇشۇلارنى ئۆزۈڭلاردىن كېيىنكى بالىلىرىڭلارغا مىراس قىلىپ، ئۇلارغا مۈلۈك بولۇشقا قالدۇرساڭلار بولىدۇ؛ مۇشۇلارنى ئەبەدگىچە قۇل قىلساڭلار بولىدۇ؛ لېكىن ئۆز قېرىنداشلىرىڭلار بولغان ئىسرائىللار ئارىسىدا بولسا، بىر-بىرىڭلارغا قاتتىق قوللۇق بىلەن خوجىلىق قىلماسلىقىڭلار كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","ئەگەر ئاراڭلاردا ئولتۇرۇشلۇق بىر مۇساپىر ياكى ياقا يۇرتلۇق بېيىغان ۋە ئۇنىڭغا قوشنا قېرىندىشىڭ كەمبەغەللىشىپ، ئۆزىنى شۇ قوشنا مۇساپىرغا ۋە ياكى شۇ مۇساپىرنىڭ مەلۇم بىر ئەۋلادىغا ساتسا، ");
INSERT INTO uigara_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ئۇ سېتىلغاندىن كېيىن ئۇنىڭدا پۇل تۆلەپ ھۆرلۈككە چىقىش ھوقۇقى قالىدۇ؛ ئۇنىڭ ئاكا-ئۇكىلىرىنىڭ ھەرقايسىسى ئۇنى ھۆرلۈككە سېتىۋالسا بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","شۇنىڭدەك ئۇنىڭ تاغىسى ياكى تاغىسىنىڭ ئوغلى ۋە ياكى جەمەتىدىن بولغان ھەرقايسى يېقىن تۇغقىنى ئۇنى ھۆرلۈككە سېتىۋالسا بولىدۇ؛ ياكى ئۆزىنىڭ قۇربى يەتسە، پۇل بېرىپ ئۆز-ئۆزىنى ھۆرلۈككە سېتىۋالسا بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ئۇنى سېتىۋالىدىغان كىشى ئۇنىڭ خوجىسى بىلەن گەپلىشىپ سېتىلغان يىلدىن تارتىپ ئازادلىق يىلىغىچە قانچىلىك بولغانلىقىنى ھېسابلاپ، سېتىۋېلىش باھاسىنى يىللارنىڭ سانىغا قاراپ ھېسابلىسۇن؛ ھۆرلۈك پۇلى ھېسابلاشتا قۇلنىڭ خوجىسىغا ئىشلەشكە كېرەك بولغان قالغان كۈنلىرىنىڭ ھەققى «مەدىكارنىڭ ئىشلىگەن كۈنلىرى»دەك ھېسابلانسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ئازادلىق يىلىغا يەنە خېلى يىللار بولسا، شۇنى ھېسابلاپ، سېتىلغان پۇلنىڭ نىسبىتى بويىچە ھۆرلۈك پۇلىنى ھېسابلاپ بەرسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ئەگەر ئازادلىق يىلىغا ئاز يىللار قالغان بولسا، ئۇنى ھېساب قىلىپ، قالغان قۇللۇق يىللىرىغا مۇۋاپىق پۇلنى ياندۇرۇپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","بولمىسا، قۇل شۇ خوجىسىنىڭ يېنىدا يىللىق مەدىكاردەك تۇرۇشى كېرەك؛ ئۇنىڭ خوجىسى سېنىڭ كۆز ئالدىڭدا ئۇنىڭغا قاتتىق قوللۇق بىلەن خوجىلىق قىلمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ئەگەر قۇل يۇقىرىقى يوللار بىلەن ھۆرلۈككە چىقالمىسا، ئازادلىق يىلى كەلگەندە قويۇپ بېرىلسۇن ــ ئۇ بالىلىرى بىلەن قوشۇلۇپ ئازاد بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","چۈنكى ئىسرائىللارنىڭ ئۆزى ماڭا قۇل-بەندىلەردۇر؛ ئۇلار مەن ئۆزۈم مىسىر زېمىنىدىن چىقىرىپ كەلگەن قۇل-بەندىلىرىمدۇر. خۇدايىڭلار پەرۋەردىگار ئۆزۈمدۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","سىلەر ئۆزۈڭلار ئۈچۈن ھېچقانداق بۇت ياسىماڭلار ياكى ئۆزۈڭلارغا ھېچ ئويما مەبۇد ياكى ھەيكەل-تۈۋرۈكنى تۇرغۇزماڭلار ياكى ئۇلارغا باش ئۇرۇشقا ئويۇلغان نەقىشلىك تاشلارنى زېمىنىڭلاردا ھەرگىز تىكلىمەڭلار؛ چۈنكى ئۆزۈم خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","مېنىڭ شابات كۈنلىرىمنى تۇتۇپ، مۇقەددەس جايىمغا ئىخلاسمەن بولۇڭلار. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","ئەگەر سىلەر مېنىڭ بەلگىلىمىلىرىمدە مېڭىپ، ئەمرلىرىمنى تۇتۇپ ئۇلارغا ئەمەل قىلساڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","مەن يېرىڭلارنىڭ ئۆز ھوسۇلىنى بېرىپ تۇرۇشىغا، دالادىكى دەرەخلەرنىڭ مېۋىسىنى چىقىرىشىغا ۋاقتىدا يامغۇرلىرىڭلارنى ياغدۇرۇپ تۇرىمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","شۇنىڭ بىلەن خامان تېپىش ۋاقتى ئۈزۈم يىغىش پەسلىگىچە بولىدۇ، ئۈزۈم يىغىش ۋاقتى تېرىلغۇ ۋاقتىغىچە بولىدۇ؛ سىلەر نېنىڭلارنى تويۇنغۇچە يەپ، ئۆز زېمىنىڭلاردا تىنچ-ئامان تۇرىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","مەن زېمىنغا ئارام-تىنچلىق ئاتا قىلىمەن، شۇنىڭ بىلەن ھېچكىم سىلەرنى قورقۇتالمايدۇ، ئارامخۇدا يېتىپ ئۇخلايسىلەر؛ ۋەھشىي ھايۋانلارنى زېمىندىن يوقىتىمەن، قىلىچمۇ زېمىنىڭلاردىن ئۆتمەيدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","سىلەر دۈشمەنلىرىڭلارنى قوغلايسىلەر، ئۇلار ئالدىڭلاردا قىلىچلىنىپ يىقىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","سىلەردىن بەش كىشى يۈز كىشىنى قوغلايدۇ، يۈز كىشى ئون مىڭنى قاچۇرىدۇ؛ دۈشمەنلىرىڭلار بولسا ئالدىڭلاردا قىلىچلىنىپ يىقىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","مەن سىلەرگە يۈزۈمنى قارىتىپ، سىلەرنى پەرزەنت كۆرگۈزۈپ كۆپەيتىمەن، سىلەر بىلەن باغلىغان ئەھدەمنى مەزمۇت تۇرغۇزىمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","سىلەر تېخىچە ئۇزۇن ساقلانغان كونا ئاشلىقنى يەۋاتقىنىڭلاردا، يېڭى ئاشلىق چىقىدۇ؛ يېڭىسى ۋەجىدىن كونىسىنى چىقىرىۋېتىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","مەن ئۆز ماكانىمنى ئاراڭلاردا تۇرغۇزىمەن ۋە قەلبىم سىلەردىن نەپرەتلەنمەيدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","مەن ئاراڭلاردا مېڭىپ سىلەرنىڭ خۇدايىڭلار بولىمەن ۋە سىلەر مېنىڭ خەلقىم بولىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","مەن سىلەرنى مىسىردا ئۇلارنىڭ قۇللىرى بولۇشتىن ھۆر قىلىشقا شۇ زېمىنىدىن چىقارغان خۇدايىڭلار پەرۋەردىگاردۇرمەن؛ مەن بويۇنتۇرۇقۇڭلارنىڭ ئاسارەتلىرىنى سۇندۇرۇپ، قەددىڭلارنى تىك قىلىپ ماڭغۇزدۇم. ");
INSERT INTO uigara_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ھالبۇكى، ئەگەر سىلەر ماڭا قۇلاق سالماي، بۇ ئەمرلەرنىڭ ھەممىسىگە ئەمەل قىلماي، ");
INSERT INTO uigara_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","بەلگىلىمىلىرىمنى تاشلاپ، قەلبىڭلاردىن ھۆكۈملىرىمنى يامان كۆرۈپ، بارلىق ئەمرلىرىمنى تۇتماي، ئەھدەمنى بۇزساڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","مەنمۇ بېشىڭلارغا شۇ ئىشلارنى چۈشۈرىمەنكى، ــ مەن سىلەرگە ۋەھىمە سېلىپ، كۆزۈڭلارنى كور قىلىدىغان، جېنىڭلارنى زەئىپلەشتۈرىدىغان سىل-ۋابا كېسىلى، كېزىك كېسىلىنى بېشىڭلارغا چۈشۈرىمەن. سىلەر ئۇرۇقۇڭلارنى بىكار چېچىپ-تېرىيسىلەر، چۈنكى دۈشمەنلىرىڭلار ئۇنى يەپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","مەن يۈزۈمنى سىلەرگە قارشى قىلىمەن، شۇنىڭ بىلەن سىلەر دۈشمەنلىرىڭلاردىن ئۇرۇلۇپ قاچىدىغان بولىسىلەر؛ سىلەرنى ئۆچ كۆرگۈچىلەر ئۈستۈڭلاردىن ھۆكۈمرانلىق قىلىدۇ؛ ھېچكىم سىلەرنى قوغلىمىسىمۇ، قاچىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","بۇلاردىن ھېچ ئىبرەت ئالماي، بەلكى ماڭا يەنە قۇلاق سالمىساڭلار، مەن گۇناھلىرىڭلار تۈپەيلىدىن سىلەرگە بولغان جازانى يەتتە ھەسسە ئېغىرلىتىمەن، ");
INSERT INTO uigara_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","كۈچ-ھەيۋەڭلاردىن بولغان ھاكاۋۇرلۇقىڭلارنى سۇندۇرىمەن؛ ئاسمىنىڭلارنى تۆمۈردەك قىلىپ، يېرىڭلارنى مىستەك قىلىۋېتىمەن؛ ");
INSERT INTO uigara_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ئەجىر-جاپايىڭلار بىكارغا كېتىدۇ، يېرىڭلار ھوسۇل بەرمەيدۇ، دالادىكى دەرەخلەرگە مېۋە چۈشمەيدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ئەگەر يەنىلا مەن بىلەن قارشى ماڭساڭلار، شۇنداقلا ماڭا قۇلاق سالمىساڭلار، مەن گۇناھلىرىڭلارغا لايىق بېشىڭلارغا چۈشىدىغان ۋابا-كۈلپەتلەرنى يەنە يەتتە ھەسسە ئېغىرلىتىمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ئاراڭلارغا سىلەرنى بالىلىرىڭلاردىن جۇدا قىلىدىغان، چارپايلىرىڭلارنى يوقىتىدىغان، سىلەرنى ئازلىتىدىغان ياۋايى ھايۋانلارنى ئەۋەتىمەن؛ يول-كوچىلىرىڭلار ئادەمزاتسىز چۆلدەك بولۇپ قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","سىلەر بۇ ئىشلار ئارقىلىق ئىبرەت-تەربىيە ئالماي، بەلكى يەنىلا ماڭا قارشى ماڭساڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","مەنمۇ سىلەرگە قارشى مېڭىپ، گۇناھىڭلار تۈپەيلىدىن بولغان جازانى يەنە يەتتە ھەسسە ئېغىرلىتىپ، مەن ئۆزۈم سىلەرنى ئۇرىمەن؛ ");
INSERT INTO uigara_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ئۈستۈڭلارغا ئەھدەمنى بۇزغانلىقنىڭ ئىنتىقامىنى ئالىدىغان قىلىچ چۈشۈرىمەن؛ شۇنىڭ بىلەن سىلەر شەھەرلەرگە يىغىلىۋالىسىلەر، مەن ئاراڭلارغا ۋابا چۈشۈرىمەن؛ شۇنىڭ بىلەن سىلەر دۈشمەنلەرنىڭ قولىغا چۈشىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","سىلەرگە يۆلەنچۈك بولغان ئاشلىقنى قۇرۇتۇۋېتىمەن؛ ئون ئايال بىر بولۇپ بىر تونۇردا نان يېقىپ، نانلارنى سىلەرگە تارازىدا تارتىپ بېرىدۇ، ئەمما بۇنى يېگىنىڭلار بىلەن تويمايسىلەر. ");
INSERT INTO uigara_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ئەگەر بۇلاردىن ھېچ ئىبرەت ئالماي، ماڭا قۇلاق سالمىساڭلار، بەلكى ماڭا قارشى ماڭساڭلار، ");
INSERT INTO uigara_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","مەنمۇ قەھر بىلەن سىلەرگە قارشى ماڭىمەن؛ مەن، يەنى مەن ئۆزۈم گۇناھلىرىڭلار تۈپەيلىدىن جازا-تەربىيىنى يەنە يەتتە ھەسسە ئېغىرلىتىپ چۈشۈرىمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","شۇنىڭ بىلەن سىلەر ئوغۇللىرىڭلارنىڭ گۆشى ۋە قىزلىرىڭلارنىڭ گۆشىنى يەيسىلەر؛ ");
INSERT INTO uigara_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","شۇنداقلا مەن قۇربانلىق «يۇقىرى جاي»لىرىڭلانى ۋەيران قىلىپ، «كۈن تۈۋرۈك»لىرىڭلارنى سۇندۇرۇپ، ئۆلۈكلىرىڭلارنى سۇنۇق بۇتلىرىڭلارنىڭ ئۈستىگە تاشلىۋېتىمەن؛ مېنىڭ قەلبىم سىلەردىن نەپرەتلىنىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","مەن شەھەرلىرىڭلارنى ۋەيران قىلىپ، مۇقەددەس جايلىرىڭلارنى خاراب قىلىپ، قۇربانلىقىڭلارنىڭ خۇشبۇيلىرىنى يەنە پۇرىمايمەن؛ ");
INSERT INTO uigara_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","زېمىننى ھالاكەتكە ئېلىپ بارىمەن؛ ئۇنىڭدا ئولتۇراقلاشقان دۈشمەنلىرىڭلار بۇ ئەھۋالغا ھەيرانۇھەس قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","سىلەرنى ئەللەرنىڭ ئارىسىغا تارىتىپ، كەينىڭلاردىن قىلىچنى سۇغۇرۇپ قوغلايمەن؛ شۇنىڭ بىلەن زېمىنىڭلار ۋەيران بولۇپ شەھەرلىرىڭلار خاراب قىلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ئۇ ۋاقىتتا، سىلەر دۈشمەنلىرىڭلارنىڭ زېمىنىدا تۇرۇۋاتقىنىڭلاردا، زېمىن ۋەيرانە بولغان بارلىق كۈنلەردە، زېمىن ئۆز شابات كۈنلىرىدىن سۆيۈنىدۇ؛ ئۇ زاماندا زېمىن دەرۋەقە ئارام ئېلىپ ئۆز شاباتلىرىدىن سۆيۈنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ئۆزى ۋەيرانە بولۇپ تۇرغان بارلىق كۈنلىرىدە ئۇ ئارام ئالىدۇ، يەنى سىلەر ئۇنىڭدا تۇرۇۋاتقان ۋاقىتتىكى شابات كۈنلىرىڭلاردا ھېچ ئالمىغان ئارامنى ئەمدى ئالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ئاراڭلاردىن قۇتۇلۇپ قالغانلار بولسا، ئۇلار دۈشمەنلەرنىڭ زېمىنلىرىدا تۇرغىنىدا كۆڭۈللىرىگە يۈرەكزادىلىك سالىمەن، شۇنىڭ بىلەن ئۇلار چۈشكەن بىر يوپۇرماقنىڭ شەپىسىنى ئاڭلىسا قىلىچتىن قاچقاندەك قاچىدۇ؛ ھېچكىم قوغلىمىسىمۇ يىقىلىپ چۈشىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","گەرچە ھېچكىم ئۇلارنى قوغلىمىسىمۇ، دەرۋەقە قىلىچتىن يىقىتىلغاندەك ئۇلار بىر-بىرىنىڭ ئۈستىگە پۇتلىشىپ يىقىلىدۇ؛ سىلەردە دۈشمەنلىرىڭلارغا قارشى تۇرغۇدەك كۈچ قالمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ئەللەرنىڭ ئارىسىدا ھالاك بولىسىلەر، دۈشمەنلىرىڭلارنىڭ زېمىنى سىلەرنى يەپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ئاراڭلاردىن قۇتۇلۇپ قالغانلىرى بولسا ئۆز رەزىللىكى تۈپەيلىدىن دۈشمەنلىرىڭلارنىڭ زېمىنىدا زەئىپلىشىدۇ؛ ۋە ئاتا-بوۋىلىرىنىڭ رەزىللىكىدىمۇ يۈرۈپ، شۇلار زەئىپلەشكەندەك ئۇلارمۇ زەئىپلىشىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","ھالبۇكى، ئۇلار ئۆزى قىلغان رەزىللىكى بىلەن ئاتا-بوۋىلىرىنىڭ سادىر قىلغان رەزىللىكىنى، ماڭا يۈز ئۆرۈپ ئاسىيلىق قىلغىنىنى، شۇنداقلا ئۇلارنىڭ ماڭا قارشى تۇرۇپ ماڭغىنىنى بوينىغا ئالىدۇ، ");
INSERT INTO uigara_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","شۇنىڭدەك مېنىڭ ئۇلارغا قارشى ماڭغىنىمغا، شۇنىڭدەك ئۇلارنى دۈشمەنلىرىنىڭ قولىغا تاپشۇرغىنىمغا ئىقرار بولىدۇ. شۇڭا ئەگەر ئۇ ۋاقىتتا ئۇلارنىڭ خەتنىسىز كۆڭلى تۆۋەن قىلىنىپ، ئۆز قەبىھلىكىنىڭ جازاسىنى قوبۇل قىلسا، ");
INSERT INTO uigara_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ئۇنداقتا مەن ياقۇپ بىلەن باغلىغان ئەھدەمنى ياد قىلىپ، ئىسھاق بىلەن باغلىغان ئەھدەمنىمۇ ۋە ئىبراھىم بىلەن باغلىغان ئەھدەمنىمۇ ئېسىمگە كەلتۈرىمەن، زېمىننىمۇ ياد قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","چۈنكى زېمىن ئۇلاردىن تاشلىنىپ، ئۇلارسىز بولۇپ خارابە تۇرغان ۋاقىتتا، شابات كۈنلىرىدىن سۆيۈنىدۇ؛ ئۇلار بولسا ئۆز قەبىھلىكىنىڭ جازاسىنى قوبۇل قىلىدۇ؛ سەۋەبى دەل شۇكى، ئۇلار مېنىڭ ھۆكۈملىرىمنى تاشلىدى، بەلگىلىمىلىرىمنى قەلبىدىن يامان كۆرگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ھالبۇكى، شۇنداق بولسىمۇ، ئۇلار ئۆز دۈشمەنلىرىنىڭ زېمىنىدا تۇرغىنىدا مەن ئۇلارنى تاشلىمايمەن ياكى ئۇلارغا ئۆچلۈك قىلمايمەن، شۇنىڭدەك ئۇلار بىلەن باغلىغان ئەھدەمنى بۇزمايمەن، ئۇلارنى يوقاتمايمەن؛ چۈنكى مەن ئۆزۈم ئۇلارنىڭ خۇداسى پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","مەن بەلكى ئۇلارنى دەپ، ئۇلارنىڭ خۇداسى بولۇشقا ئەللەرنىڭ كۆزى ئالدىدا مىسىر زېمىنىدىن چىقىرىپ كەلگەن ئاتا-بوۋىلىرى بىلەن باغلاشقان ئەھدەمنى ئېسىمدە تۇتىمەن. مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","پەرۋەردىگار مۇسانى ۋاسىتە قىلىپ، سىناي تېغىدا ئۆزى بىلەن ئىسرائىللارنىڭ ئوتتۇرىسىدا بېكىتكەن ھۆكۈملەر، بەلگىلىمىلەر ۋە قانۇنلار مانا شۇلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: ــ ");
INSERT INTO uigara_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","سەن ئىسرائىللارغا مۇنداق دېگىن: ــ ئەگەر بىرسى پەۋقۇلئاددە بىر قەسەم قىلىپ مەلۇم كىشىنىڭ جېنىنى پەرۋەردىگارغا ئاتىغان بولسا، ئۇنداقتا شۇ كىشىگە سەن بېكىتكەن جېنىنىڭ قىممىتىنىڭ نەرخى تۆۋەندىكىدەك بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","يېشى يىگىرمە بىلەن ئاتمىشنىڭ ئارىلىقىدا بولغان ئەر كىشى بولسا، سەن توختىتىدىغان قىممىتى مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە بولسۇن؛ ئۇنىڭ قىممىتى ئەللىك شەكەل كۈمۈشكە توختىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ئايال كىشى بولسا، ئاراڭلاردا توختىتىلغان قىممىتى ئوتتۇز شەكەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ئەگەر يېشى بەش بىلەن يىگىرمىنىڭ ئارىلىقىدا بولسا، ئەركەك ئۈچۈن توختىتىلىدىغان قىممىتى يىگىرمە شەكەل بولۇپ، ئايال كىشى ئۈچۈن ئون شەكەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ئەگەر يېشى بىر ئاي بىلەن بەش ياشنىڭ ئارىلىقىدا بولسا، توختىتىلىدىغان قىممىتى ئوغۇل بالا ئۈچۈن بەش شەكەل، قىز بالا ئۈچۈن ئۈچ شەكەل كۈمۈش بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ئەگەر ئاتمىش يا ئۇنىڭدىن چوڭراق ياشتىكى كىشى بولسا، توختىتىلىدىغان قىممىتى ئەر كىشى ئۈچۈن ئون بەش شەكەل، خوتۇن كىشى ئۈچۈن ئون شەكەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ئەگەر بىرسى توختىتىلغان قىممىتىنى تۆلەشكە قۇربى يەتمىسە، ئۇ ئۆزىنى كاھىننىڭ ئالدىدا تەق قىلسۇن؛ كاھىن ئۇنىڭ قىممىتىنى بېكىتسۇن. كاھىن قەسەم قىلغۇچىنىڭ ئەھۋالىغا قاراپ ئۇنىڭ قىممىتىنى توختىتىپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","ئەگەر بىرسى قەسەم قىلىپ پەرۋەردىگارغا قۇربانلىق بولۇشقا لايىق بولىدىغان بىر ھايۋاننى ئۇنىڭغا ئاتىغان بولسا، ئۇنداقتا شۇنداق ھايۋانلار پەرۋەردىگارغا ئاتاپ مۇتلەق مۇقەددەس سانالسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ھايۋان ناچار بولسا ئۇنىڭ ئورنىغا ياخشىنى ياكى ياخشىنىڭ ئورنىغا ناچىرىنى تېگىشىشكە ياكى ئورنىغا باشقىسىنى ئالماشتۇرۇشقا ھەرگىز بولمايدۇ. مۇبادا ئاتىغۇچى ئۇ ھايۋاننىڭ ئورنىغا يەنە بىر ھايۋاننى يەڭگۈشلىمەكچى بولسا، ئاۋۋالقىسى بىلەن ئورنىغا ئەكەلگىنىنىڭ ھەر ئىككىسى مۇقەددەس سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ئەگەر ھايۋان پەرۋەردىگارغا ئاتالغان قۇربانلىققا لايىق بولمايدىغان بىر «ناپاك» ھايۋان بولسا، ئۇنداقتا ئۇ ھايۋاننى كاھىننىڭ ئالدىغا ئېلىپ كەلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ئاندىن كاھىن ئۆزى ئۇنىڭ ياخشى-يامانلىقىغا قاراپ قىممىتىنى توختاتسۇن؛ كاھىن قىممىتىنى قانچە توختاتقان بولسا شۇنداق بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ئەگەر ئىگىسى پۇل تۆلەپ ھايۋاننى قايتۇرۇۋۇلماقچى بولسا، توختىتىلغان قىممىتىگە يەنە ئۇنىڭ بەشتىن بىرىنى قوشۇپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","ئەگەر بىرسى پەرۋەردىگارغا مۇقەددەس بولسۇن دەپ ئۆيىنى ئۇنىڭغا ئاتاپ مۇقەددەس قىلسا، كاھىن ئۇنىڭ ياخشى-يامانلىقىغا قاراپ قىممىتىنى توختاتسۇن؛ كاھىن ئۇنىڭ قىممىتىنى قانچە توختاتقان بولسا، شۇ قىممىتى ئىناۋەتلىك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","كېيىن ئەگەر ئۆينى ئاتىغۇچى كىشى ئۇنى قايتۇرۇۋالماقچى بولسا، ئۇ توختىتىلغان قىممىتىگە ئۇنىڭ بەشتىن بىرىنى قوشۇپ بەرسۇن؛ ئاندىن ئۆي يەنە ئۇنىڭ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ئەگەر بىرسى ئۆز مال-مۈلكى بولغان ئېتىزلىقنىڭ بىر قىسمىنى پەرۋەردىگارغا ئاتاپ مۇقەددەس قىلسا، قىممىتى ئۇنىڭغا قانچىلىك ئۇرۇق تېرىلىدىغانلىقىغا قاراپ توختىتىلسۇن؛ بىر خومىر ئارپا ئۇرۇقى كېتىدىغان يەر بولسا، قىممىتى ئەللىك شەكەل كۆمۈشكە توختىتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ئەگەر بىرسى «ئازادلىق يىلى»دىن تارتىپ ئۆز ئېتىزلىقىنى مۇقەددەس قىلسا، سەن قانچە توختاتساڭ شۇ بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","لېكىن ئەگەر بىرسى «ئازادلىق يىلى»دىن كېيىن ئۆز ئېتىزلىقىنى مۇقەددەس قىلغان بولسا، كاھىن كېلىدىغان ئازادلىق يىلىغىچە قانچىلىك يىللار قالغانلىقىنى ھېسابلاپ قىممىتىنى توختاتسۇن. ئۆتۈپ كەتكەن يىللارغا قاراپ تولۇق باھادىن مۇۋاپىق پۇل كېمەيتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ئەگەر بىرسى ئۆز ئېتىزلىقىنى مۇقەددەس قىلغاندىن كېيىن پۇل تۆلەپ ئۇنى قايتۇرۇۋالماقچى بولسا، ئۇ سەن توختاتقان قىممىتىگە يەنە ئۇنىڭ بەشتىن بىرىنى قوشۇپ بەرسۇن؛ شۇنىڭ بىلەن ئېتىزلىق ئۇنىڭ ئۆز قولىغا قايتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ئەگەر ئۇ پۇل بېرىپ ئېتىزلىقنى قايتۇرۇۋالمىغان بولسا ياكى باشقا بىرسىگە سېتىپ بەرگەن بولسا، كېيىن شۇ ئېتىزلىقنى قايتۇرۇۋېلىشقا بولمايدۇ، ");
INSERT INTO uigara_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","بەلكى ئازادلىق يىلى كەلگەندە ئېتىزلىق «ئىگىسىگە قايتۇرۇلىدىغاندا» ئۇ مۇتلەق بېغىشلانغان يەرگە ئوخشاش، پەرۋەردىگارغا ئاتاپ مۇقەددەس قىلىنىپ، مىراس ھوقۇقى كاھىنغا ئۆتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ئەگەر بىرسى سېتىۋالغان ئەمما ئۆز مىراسى بولمىغان بىر پارچە يەر-ئېتىزنى پەرۋەردىگارغا ئاتاپ مۇقەددەس قىلغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","كاھىن ئازادلىق يىلىغىچە قالغان يىلنى ھېسابلاپ، قىممىتىنى توختاتسۇن. ئاندىن ئۇ كۈنى شۇ كىشى توختىتىلغان قىممىتىنى پەرۋەردىگارغا مۇقەددەس قىلغان نەرسە سۈپىتىدە كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","لېكىن ئازادلىق يىلى كەلگەندە، ئېتىزلىق كىمدىن ئېلىنغان بولسا، شۇ كىشىگە، يەنى ئەسلىدىكى ئىگىسىگە قايتۇرۇپ بېرىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","سەن توختىتىدىغان بارلىق قىممەتلەر بولسا ھەمىشە مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ھېسابلانسۇن؛ بىر شەكەل يىگىرمە گەراھقا باراۋەر بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","لېكىن چارپاينىڭ تۇنجى بالىسى تۇنجى بالا بولغانلىقى سەۋەبىدىن ئەسلىدىنلا پەرۋەردىگارغا ئاتىلىدىغان بولغاچقا، كالا بولسۇن، قوي-ئۆچكە بولسۇن ھېچكىم ئۇنى «خۇداغا ئاتاپ» مۇقەددەس قىلمىسۇن؛ چۈنكى ئۇ ئەسلىدە پەرۋەردىگارنىڭ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ئەگەر ئۇ ناپاك بىر ھايۋاندىن تۇغۇلغان بولسا، ئىگىسى سەن توختاتقان قىممەتكە يەنە ئۇنىڭ بەشتىن بىرىنى قوشۇپ بېرىپ، ئاندىن ئۆزىگە قايتۇرۇۋالسۇن؛ لېكىن ئەگەر ئىگىسى ئۇنى ئۆزىگە قايتۇرۇۋالمايمەن دېسە، بۇ ھايۋان سەن توختاتقان قىممەتكە سېتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","ئەگەر بىرسى پەرۋەردىگارغا ئۆز مېلىدىن، ئادەم بولسۇن، ھايۋان بولسۇن ياكى مىراس يېرى بولسۇن، پەرۋەردىگارغا مۇتلەق ئاتىغان بولسا، ئۇنداق نەرسە ھەرگىز سېتىلمىسۇن ياكى بەدەل تۆلەش بىلەنمۇ قايتۇرۇلمىسۇن. پەرۋەردىگارغا مۇتلەق ئاتالغان ھەرنەرسە بولسا «ئەڭ مۇقەددەسلەرنىڭ بىرى» ھېسابلىنىپ، ئۇنىڭغا خاس بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ئەگەر بىر ئادەم خۇداغا مۇتلەق خاس ئاتالغان بولسا، ئۇنداقتا ئۇنىڭ ئۈچۈن بەدەل بېرىلىپ، قايتۇرۇۋېلىنىشقا ھەرگىز بولمايدۇ؛ ئۇ چوقۇم ئۆلتۈرۈلۈشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","يەر-زېمىندىن چىققان ھەممە ھوسۇلنىڭ ئوندىن بىرى بولغان ئۆشرە بولسا، يەرنىڭ دانلىق زىرائەتلىرى بولسۇن ياكى دەرەخلەرنىڭ مېۋىسى بولسۇن، پەرۋەردىگارنىڭكى بولىدۇ؛ ئۇ پەرۋەردىگارغا مۇقەددەس قىلىنغاندۇر. ");
INSERT INTO uigara_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","بىرسى ئۆز ئۆشرىلىرىدىن مەلۇم بىرنەرسىنى بەدەل بېرىپ قايتۇرۇۋالماقچى بولسا، ئۇ شۇنىڭغا يەنە ئۇنىڭ قىممىتىنىڭ بەشتىن بىرىنى قوشۇپ بېرىپ، قايتۇرۇۋالسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","كالا ياكى قوي-ئۆچكە پادىسىدىن ئېلىنىدىغان ئۆشرە بولسا پادىچىنىڭ تايىقى ئاستىدىن ئۆتكۈزۈلگەن ھايۋانلاردىن ھەر ئونىنچىسى بولسۇن؛ پەرۋەردىگارغا ئاتىلىپ مۇقەددەس قىلىنغىنى شۇ بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ھېچكىم ئۇنىڭ ياخشى-يامانلىقىغا قارىمىسۇن ۋە ياكى ئۇنى ئالماشتۇرمىسۇن؛ ئەگەر ئۇنى ئالماشتۇرىمەن دېسە، ئاۋۋالقىسى بىلەن ئورنىغا ئالماشتۇرۇلغان ھەر ئىككىسى مۇقەددەس سانالسۇن؛ ئۇ ھەرگىز بەدەل تۆلۈپ قايتۇرۇۋېلىنمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","پەرۋەردىگار سىناي تېغىدا مۇساغا تاپىلغان، ئىسرائىللارغا تاپشۇرۇش كېرەك بولغان ئەمرلەر مانا شۇلار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ۋە ئىسرائىللار مىسىردىن چىققاندىن كېيىن ئىككىنچى يىلى ئىككىنچى ئاينىڭ بىرىنچى كۈنى پەرۋەردىگار سىناي چۆلىدە، جامائەت چېدىرىدا تۇرۇپ مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","سىلەر پۈتكۈل ئىسرائىل جامائىتىنى قەبىلىسى، ئاتا جەمەتى بويىچە سانىنى ئېلىپ چىقىڭلار؛ ئادەملەرنىڭ ئىسمى ئاساس قىلىنىپ، بارلىق ئەركەكلەر تىزىملانسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ئىسرائ‍ىللار ئىچىدە ئومۇمەن يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنى ھارۇن بىلەن ئىككىڭلار ئۇلارنىڭ قوشۇن-قىسمىلىرى بويىچە ساناقتىن ئۆتكۈزۈڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ھەربىر قەبىلىدىن سىلەرگە ياردەملىشىدىغان بىردىن كىشى بولسۇن؛ ئۇلارنىڭ ھەربىرى ئۇلارنىڭ ئاتا جەمەتىنىڭ بېشى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","تۆۋەندىكىلەر سىلەرگە ياردەملىشىدىغانلارنىڭ ئىسىملىكى: — رۇبەن قەبىلىسىدىن شىدۆرنىڭ ئوغلى ئەلىزۇر؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","شىمېئون قەبىلىسىدىن زۇرى-شادداينىڭ ئوغلى شېلۇمىيەل؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","يەھۇدا قەبىلىسىدىن ئاممىنادابنىڭ ئوغلى ناھشون؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ئىسساكار قەبىلىسىدىن زۇئارنىڭ ئوغلى نەتانەل؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","زەبۇلۇن قەبىلىسىدىن ھېلوننىڭ ئوغلى ئېلىئاب؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","يۈسۈپ ئەۋلادلىرى ئىچىدە ئەفرائىم قەبىلىسىدىن ئاممىھۇدنىڭ ئوغلى ئەلىشاما؛ ماناسسەھ قەبىلىسىدىن پىداھزۇرنىڭ ئوغلى گامالىيەل؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","بىنيامىن قەبىلىسىدىن گىدېئونىنىڭ ئوغلى ئابىدان؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","دان قەبىلىسىدىن ئاممىشادداينىڭ ئوغلى ئاھىئېزەر؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ئاشىر قەبىلىسىدىن ئوكراننىڭ ئوغلى پاگىيەل؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","گاد قەبىلىسىدىن دېئۇئەلنىڭ ئوغلى ئەلىئاساف؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","نافتالى قەبىلىسىدىن ئېناننىڭ ئوغلى ئاھىرا». ");
INSERT INTO uigara_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","بۇلار جامائەت ئىچىدىن چاقىرىلغانلار، يەنى ئاتا جەمەت-قەبىلىلىرىنىڭ باشلىقلىرى، مىڭلىغان ئىسرائ‍ىللارنىڭ باش سەردارلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","شۇنىڭ بىلەن مۇسا بىلەن ھارۇن ئىسمى ئاتالغان بۇ كىشىلەرنى باشلاپ، ");
INSERT INTO uigara_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ئىككىنچى ئاينىڭ بىرىنچى كۈنى پۈتكۈل جامائەتنى يىغدى؛ ئۇلار خەلقنىڭ ھەربىرىنىڭ قەبىلە-نەسەبى، ئاتا جەمەتى بويىچە ئىسمىنى ئاساس قىلىپ، يىگىرمە ياشتىن يۇقىرىلارنىڭ ھەممىسىنى بىر-بىرلەپ تىزىملىدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","پەرۋەردىگار مۇساغا قانداق بۇيرۇغان بولسا، مۇسا سىناي چۆلىدە ئۇلارنى شۇنداق ساناقتىن ئۆتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ئىسرائىلنىڭ تۇنجى ئوغلى رۇبەننىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغان ئەركەكلەرنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","رۇبەن قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق ئالتە مىڭ بەش يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","شىمېئوننىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغان ئەركەكلەرنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","شىمېئون قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك توققۇز مىڭ ئۈچ يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","گادنىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","گاد قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق بەش مىڭ ئالتە يۈز ئەللىك كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","يەھۇدانىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","يەھۇدا قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي يەتمىش تۆت مىڭ ئالتە يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ئىسساكارنىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ئىسساكار قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك تۆت مىڭ تۆت يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","زەبۇلۇننىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","زەبۇلۇن قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك يەتتە مىڭ تۆت يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","يۈسۈپنىڭ ئەۋلادلىرى: — ئۇنىڭ ئوغلى ئەفرائىمنىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ئەفرائىم قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق مىڭ بەش يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","يۈسۈپنىڭ ئىككىنچى ئوغلى ماناسسەھنىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ماناسسەھ قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئوتتۇز ئىككى مىڭ ئىككى يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","بىنيامىننىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","بىنيامىن قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئوتتۇز بەش مىڭ تۆت يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","داننىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","دان قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئاتمىش ئىككى مىڭ يەتتە يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ئاشىرنىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ئاشىر قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق بىر مىڭ بەش يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","نافتالىنىڭ ئەۋلادلىرى ئاتا جەمەتى، ئائىلىسى بويىچە، ئىسمى ئاساس قىلىنىپ، يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى بىر-بىرلەپ تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","نافتالى قەبىلىسىدىن ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك ئۈچ مىڭ تۆت يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","يۇقىرىقىلار بولسا ساناقتىن ئۆتكۈزۈلگەنلەر بولۇپ، مۇسا بىلەن ھارۇن ھەم ئىسرائ‍ىللارنىڭ ئون ئىككى ئەمىرى ‹ھەربىرى ئۆز ئاتا جەمەتىگە ۋەكىل بولدى› ئۇلارنى ساناقتىن ئۆتكەزگەن. ");
INSERT INTO uigara_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","شۇنداق قىلىپ، ئىسرائ‍ىللارنىڭ ھەممىسى، يەنى ئىسرائىلدا يىگىرمە ياشتىن ئاشقانلاردىن، جەڭگە چىقالايدىغانلارنىڭ ھەممىسى ئاتا جەمەتلىرى بويىچە تىزىملاندى؛ ");
INSERT INTO uigara_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئالتە يۈز ئۈچ مىڭ بەش يۈز ئەللىك كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","بىراق لاۋىيلار ئاتا جەمەت-قەبىلىسى بويىچە ساناقنىڭ ئىچىگە كىرگۈزۈلمىدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","چۈنكى پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«سەن پەقەت لاۋىي قەبىلىسىنىلا شۇ ھېسابقا كىرگۈزمىگىن، ئۇلارنىڭ ئومۇمىي سانىنىمۇ ئىسرائ‍ىللارنىڭ قاتارىغا كىرگۈزمىگىن. ");
INSERT INTO uigara_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","لېكىن سەن لاۋىيلارنى خۇدانىڭ ھۆكۈم-گۇۋاھلىقى ساقلاقلىق چېدىر ۋە ئۇنىڭ ئىچىدىكى بارلىق قاچا-قۇچا ئەسۋابلارنى ھەم ئۇنىڭغا دائىر بارلىق نەرسىلەرنى باشقۇرۇشقا تەيىنلىگىن؛ ئۇلار ئىبادەت چېدىرىنى ۋە ئۇنىڭ ئىچىدىكى بارلىق قاچا-قۇچا ئەسۋابلارنى كۆتۈرىدۇ؛ ئىبادەت چېدىرىنىڭ خىزمىتىنى قىلغۇچىلار شۇلار بولسۇن، ئۇلار چېدىرنىڭ تۆت ئەتراپىدا ئۆز چېدىرلىرىنى تىكسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","چېدىرنى كۆچۈرىدىغان چاغدا ئۇنى لاۋىيلار سۆكسۇن؛ چېدىرنى تىكىدىغان چاغدا ئۇنى لاۋىيلار تىكسۇن؛ لاۋىيلارغا يات بولغان ھەرقانداق ئادەم ئۇنىڭغا يېقىنلاشسا ئۆلۈمگە مەھكۇم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ئىسرائ‍ىللار بارگاھ قۇرغاندا ھەر ئادەم ئۆز قىسمىدا، ئۆزىگە خاس تۇغ ئاستىغا چېدىر تىكسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","بىراق خۇدانىڭ غەزىپى ئىسرائىل جامائىتىنىڭ ئۈستىگە چۈشمەسلىكى ئۈچۈن، لاۋىيلار خۇدانىڭ ھۆكۈم-گۇۋاھلىقى ساقلاقلىق چېدىرنىڭ تۆت ئەتراپىغا بارگاھ قۇرسۇن؛ لاۋىيلار خۇدانىڭ ھۆكۈم-گۇۋاھلىقى ساقلاقلىق چېدىرنى مۇھاپىزەت قىلىشقا مەسئۇل بولىدۇ» — دېگەنىدى. ");
INSERT INTO uigara_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ئىسرائىللار ئەنە شۇنداق قىلدى؛ پەرۋەردىگار مۇساغا قانداق بۇيرۇغان بولسا، ئۇلار شۇنداق قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","پەرۋەردىگار مۇسا بىلەن ھارۇنغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ئىسرائ‍ىللار ھەربىرى ئۆزلىرىنىڭ تۇغى ئاستىغا، ئۆزلىرىنىڭ ئاتا جەمەتىنىڭ بايرىقى ئاستىدا چېدىر تىكسۇن؛ جامائەت چېدىرىنىڭ تۆت ئەتراپىدىن سەل يىراقراق بارگاھ قۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","كۈن چىقىش تەرەپكە، شەرق تەرەپكە قارىتىپ ئۆز تۇغى ئاستىدا قوشۇن-قىسمى بويىچە بارگاھ قۇرىدىغىنى يەھۇدابولسۇن؛ يەھۇدالارنىڭ ئەمىرى ئاممىنادابنىڭ ئوغلى ناھشون بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي يەتمىش تۆت مىڭ ئالتە يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ئۇنىڭ يېنىدا بارگاھ قۇرىدىغىنى ئىسساكار قەبىلىسى بولسۇن؛ ئىسساكارلارنىڭ ئەمىرى زۇئارنىڭ ئوغلى نەتانەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك تۆت مىڭ تۆت يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ئۇلارنىڭ يېنىدا يەنە زەبۇلۇن قەبىلىسى بولسۇن؛ زەبۇلۇنلارنىڭ ئەمىرى ھېلوننىڭ ئوغلى ئېلىئاب بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك يەتتە مىڭ تۆت يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ئومۇمەن يەھۇدا بارگاھىغا قارايدىغانلارنىڭ ھەممىسى، يەنى قوشۇن-قىسىملىرى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي بىر يۈز سەكسەن ئالتە مىڭ تۆت يۈز كىشى؛ ئۇلار ئالدى بىلەن يولغا چىقسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","— جەنۇب تەرەپتە، تۇغ تىكلەپ، قوشۇن تەرتىپى بىلەن بارگاھ قۇرىدىغىنى رۇبەن قەبىلىسى بولسۇن؛ رۇبەنلارنىڭ ئەمىرى شىدۆرنىڭ ئوغلى ئەلىزۇر بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق ئالتە مىڭ بەش يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ئۇنىڭ يېنىدا بارگاھ قۇرىدىغىنى شىمېئون قەبىلىسى بولسۇن؛ شىمېئونلارنىڭ ئەمىرى زۇرى-شادداينىڭ ئوغلى شېلۇمىيەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك توققۇز مىڭ ئۈچ يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ئۇلارنىڭ يېنىدا گاد قەبىلىسى بولسۇن؛ گادلارنىڭ ئەمىرى دېئۇئەلنىڭ ئوغلى ئەلىئاساف بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق بەش مىڭ ئالتە يۈز ئەللىك كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","رۇبەن بارگاھىغا قارايدىغانلارنىڭ ھەممىسى، يەنى قوشۇنى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي بىر يۈز ئەللىك بىر مىڭ تۆت يۈز ئەللىك كىشى؛ ئۇلار ئىككىنچى سەپ بولۇپ يولغا چىقسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ئاندىن جامائەت چېدىرى بىلەن لاۋىيلارنىڭ بارگاھى باشقا بارگاھلارنىڭ ئوتتۇرىسىدا ماڭسۇن؛ ئۇلار قانداق بارگاھ قۇرغان بولسا، شۇنداق يولغا چىقسۇن؛ ھەر قايسىسى ئۆز ئورنىدا ئۆز تۇغى ئاستىدا بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","— كۈن پېتىش تەرەپتە، تۇغ تىكلەپ، قوشۇن تەرتىپى بىلەن بارگاھ قۇرىدىغىنى ئەفرائىم قەبىلىسى بولسۇن؛ ئەفرائىملارنىڭ ئەمىرى ئاممىھۇدنىڭ ئوغلى ئەلىشاما بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق مىڭ بەش يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ئۇنىڭ يېنىدا بارگاھ قۇرىدىغىنى ماناسسەھ قەبىلىسى بولسۇن؛ ماناسسەھلەرنىڭ ئەمىرى پىداھزۇرنىڭ ئوغلى گامالىيەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئوتتۇز ئىككى مىڭ ئىككى يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ئۇلارنىڭ يېنىدا بىنيامىن قەبىلىسى بولسۇن؛ بىنيامىنلارنىڭ ئەمىرى گىدېئونىنىڭ ئوغلى ئابىدان بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئوتتۇز بەش مىڭ تۆت يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ئومۇمەن ئەفرائىم بارگاھىغا قارايدىغانلارنىڭ ھەممىسى، يەنى قوشۇن قىسىملىرى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي بىر يۈز سەككىز مىڭ بىر يۈز كىشى؛ ئۇلار ئۈچىنچى سەپ بولۇپ يولغا چىقسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","— شىمال تەرەپتە، تۇغ تىكلەپ، قوشۇن تەرتىپى بىلەن بارگاھ قۇرىدىغىنى دان قەبىلىسى بولسۇن. دانلارنىڭ ئەمىرى ئاممىشادداينىڭ ئوغلى ئاھىئېزەر بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئاتمىش ئىككى مىڭ يەتتە يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ئۇنىڭ يېنىدا بارگاھ قۇرىدىغىنى ئاشىر قەبىلىسى بولسۇن؛ ئاشىرلارنىڭ ئەمىرى ئوكراننىڭ ئوغلى پاگىيەل بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي قىرىق بىر مىڭ بەش يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ئۇلارنىڭ يېنىدا نافتالى قەبىلىسى بولسۇن؛ نافتالىلارنىڭ ئەمىرى ئېناننىڭ ئوغلى ئاھىرا بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ئۇنىڭ قوشۇنى، يەنى ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئەللىك ئۈچ مىڭ تۆت يۈز كىشى. ");
INSERT INTO uigara_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","دان بارگاھىغا قارايدىغانلارنىڭ ھەممىسى، يەنى قوشۇن-قىسىملىرى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي بىر يۈز ئەللىك يەتتە مىڭ ئالتە يۈز كىشى؛ ئۇلار ئۆز تۇغلىرى ئاستىدا ھەممىنىڭ كەينىدە يولغا چىقسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","يۇقىرىدىكىلەر ئۆز ئاتا جەمەتى بويىچە ساناقتىن ئۆتكۈزۈلگەن ئىسرائ‍ىللاردۇر؛ قوشۇن-قىسىملىرى بويىچە بارگاھلاردا ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئالتە يۈز ئۈچ مىڭ بەش يۈز ئەللىك كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","بىراق لاۋىيلارلا، پەرۋەردىگارنىڭ مۇساغا قىلغان ئەمرى بويىچە، ئىسرائ‍ىللار قاتارىدا ساناقتىن ئۆتكۈزۈلمىدى. ");
INSERT INTO uigara_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ئىسرائ‍ىللار پەرۋەردىگارنىڭ مۇساغا قىلغان بارلىق ئەمرى بويىچە ئىش تۇتۇپ، ئۆزلىرىنىڭ تۇغى بويىچە بارگاھ قۇراتتى؛ ئۇلار ئۆز قەبىلىسى ۋە ئاتا جەمەتى تەرتىپى بويىچە يولغا چىقاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","پەرۋەردىگار سىناي تېغىدا مۇسا بىلەن سۆزلەشكەن كۈنلەردە، ھارۇن بىلەن مۇسانىڭ ئەۋلادلىرى تۆۋەندىكىلەردىن ئىبارەت ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ھارۇننىڭ ئوغۇللىرىنىڭ ئىسمى مۇنداق: تۇنجى ئوغلىنىڭ ئىسمى ناداب ئىدى، ئۇنىڭ يەنە ئابىھۇ، ئەلىئازار، ئىتامار دېگەن ئوغۇللىرى بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ھارۇننىڭ ئوغۇللىرىنىڭ ئىسمى ئەنە شۇنداق ئىدى، ئۇلار مەسىھلەنگەن كاھىنلار ئىدى؛ مۇسا ئۇلارنى كاھىنلىق ۋەزىپىسىنى ئۆتەشكە خۇداغا ئاتاپ ئايرىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","لېكىن ناداب بىلەن ئابىھۇ سىناي چۆلىدە غەيرىي بىر ئوتنى پەرۋەردىگارنىڭ ئالدىغا سۇنغىنى تۈپەيلىدىن پەرۋەردىگار ئالدىدا ئۆلدى ۋە ئۇلارنىڭ ھېچ نەسلى قالدۇرۇلمىدى؛ ئەلىئازار بىلەن ئىتامار ئۆز ئاتىسى ھارۇن ئالدىدا كاھىنلىق ۋەزىپىسىنى ئۆتىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","سەن لاۋىي قەبىلىسىنى ئالدىڭغا كەلتۈرۈپ، ئۇلارنى كاھىن ھارۇننىڭ خىزمىتىدە بولۇشقا ئۇنىڭ ئالدىغا ھازىر قىل. ");
INSERT INTO uigara_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ئۇلار ھارۇننىڭ ھاجىتى ۋە پۈتكۈل جامائەتنىڭ ھاجىتىدىن چىقىپ جامائەت چېدىرىنىڭ ئالدىدا ۋەزىپە ئۆتەپ، ئىبادەت چېدىرىنىڭ خىزمىتىنى بېجىرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ئۇلار يەنە جامائەت چېدىرىدىكى بارلىق قاچا-قۇچا ئەسۋابلارنى باشقۇرۇش بىلەن ئىسرائ‍ىللارنىڭ خىزمىتىدە بولۇپ ۋەزىپە ئۆتەپ، ئىبادەت چېدىرىنىڭ ئىشلىرىنى بېجىرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","سەن لاۋىيلارنى ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا تەقسىملەپ بەرگىن؛ ئۇلار ئىسرائ‍ىللار ئىچىدىن مەخسۇس ئۇنىڭغا تاللاپ بېرىلگەن. ");
INSERT INTO uigara_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ھارۇن بىلەن ئوغۇللىرىنى بولسا سەن ئۆزىنىڭ كاھىنلىق ۋەزىپىسىنى ئۆتەشكە بېكىتكىن؛ ھەرقانداق يات كىشى يېقىنلاشسا ئۆلتۈرۈلسۇن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ئاندىن پەرۋەردىگار مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","— قارا، مەن ئىسرائ‍ىللار ئىچىدىن لاۋىيلارنى تاللىدىم، ئۇلارنى ئىسرائىل ئىچىدە بالىياتقۇنىڭ بارلىق تۇنجى مېۋىسىنىڭ ئورنىغا، يەنى چوڭ ئوغۇللىرىنىڭ ئورنىغا قويىمەن، شۇڭا لاۋىيلار مېنىڭ بولىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","چۈنكى تۇنجى ئوغۇللارنىڭ ھەممىسى مېنىڭكىدۇر؛ مەن مىسىر زېمىنىدا تۇنجى تۇغۇلغانلارنىڭ ھەممىسىنى قەتل قىلغان كۈنىدە ئىسرائ‍ىللارنىڭ ئىچىدىكى تۇنجىلارنىڭ ھەممىسىنى، مەيلى ئادەم بولسۇن ياكى ھايۋان بولسۇن، مۇقەددەس ھېسابلاپ مېنىڭكى قىلغانىدىم. ئۇلار مېنىڭكىدۇر؛ مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ئاندىن پەرۋەردىگار سىناي چۆل-باياۋانىدا مۇساغا: — ");
INSERT INTO uigara_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","— سەن لاۋىيلارنى ئاتا جەمەتى، ئائىلىسى بويىچە ساناقتىن ئۆتكۈز؛ بارلىق ئەركەكلەرنى، يەنى بىر ئايلىقتىن ئاشقانلارنىڭ ھەممىسىنى ساناقتىن ئۆتكۈز، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","شۇنىڭ بىلەن مۇسا پەرۋەردىگارنىڭ ئەمرى بويىچە، ئۆزىگە دېيىلگەندەك لاۋىيلارنى ساناقتىن ئۆتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","لاۋىينىڭ ئوغۇللىرىنىڭ ئىسمى مۇنداق: — گەرشون، كوھات، مەرارى. ");
INSERT INTO uigara_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","گەرشوننىڭ ئوغۇللىرىنىڭ ئىسمى ئائىلىلىرى بويىچە لىبنى ۋە شىمەي ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","كوھاتنىڭ ئوغۇللىرى ئائىلىلىرى بويىچە ئامرام، ئىزھار، ھېبرون ۋە ئۇززىئەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","مەرارىنىڭ ئوغۇللىرى ئائىلىلىرى بويىچە ماھلى ۋە مۇشى ئىدى. بۇلارنىڭ ھەممىسى ئاتا جەمەتى بويىچە لاۋىيلارنىڭ جەمەتى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","گەرشوندىن لىبنىلارنىڭ جەمەتى بىلەن شىمەيلەرنىڭ جەمەتى ۋۇجۇدقا كەلدى؛ بۇلار گەرشونلارنىڭ جەمەتلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","بارلىق ئەرلەرنىڭ سانىغا ئاساسەن، بىر ئايلىقتىن ئاشقانلىرىنىڭ ساناقتىن ئۆتكۈزۈلگەنلىرى جەمئىي يەتتە مىڭ بەش يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","گەرشوننىڭ جەمەتى ئىبادەت چېدىرىنىڭ ئارقا تەرىپىدە، يەنى غەرب تەرەپتە بارگاھ قۇردى؛ ");
INSERT INTO uigara_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","گەرشون جەمەتىنىڭ ئەمىرى لائەلنىڭ ئوغلى ئەلىئاساف ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","گەرشونلارنىڭ جامائەت چېدىرىدىكى ۋەزىپىسى ئىبادەت چېدىرىنىڭ ئۆزىدىكى ئاستىنقى ئىككى ياپقۇچ-پەردە، ئۇنىڭ ئۈستىدىكى يوپۇق ۋە جامائەت چېدىرىنىڭ ئىشىك پەردىسىگە، ");
INSERT INTO uigara_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","شۇنداقلا ھويلا ئەتراپىدىكى پەردىلەر، ھويلا دەرۋازىسىنىڭ پەردىسى ‹ھويلا پەردىلىرى ئىبادەت چېدىرى بىلەن قۇربانگاھنى چۆرىدەپ تۇراتتى› ۋە ھويلىدا ئىشلىتىلىدىغان مۇناسىۋەتلىك بارلىق تانىلارغاقاراش ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","كوھاتتىن ئامراملارنىڭ جەمەتى، ئىزھارلارنىڭ جەمەتى، ھېبرونلارنىڭ جەمەتى ۋە ئۇززىئەللەرنىڭ جەمەتى ۋۇجۇدقا كەلدى؛ بۇ كوھاتلارنىڭ جەمەتلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","بارلىق ئەركەكلەرنىڭ سانى بويىچە، بىر ئايلىقتىن ئاشقانلار جەمئىي سەككىز مىڭ ئالتە يۈز ئادەم بولۇپ چىقتى؛ ئۇلار مۇقەددەس جايغا قاراش ۋەزىپىسىنى ئۆتەيدىغان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","كوھات ئەۋلادلىرىنىڭ جەمەتلىرى جامائەت چېدىرىنىڭ جەنۇب تەرىپىدە بارگاھ تىكتى. ");
INSERT INTO uigara_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","كوھات جەمەتىنىڭ ئەمىرى ئۇززىئەلنىڭ ئوغلى ئەلىزافان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ئۇلارنىڭ ۋەزىپىسى ئەھدە ساندۇقى، شىرە، چىراغدان، ئىككى قۇربانگاھ، شۇنىڭدەك مۇقەددەس جاينىڭ ئىچىدە ئىشلىتىدىغان قاچا-قۇچا، پەردە ۋە ئىبادەت چېدىرىنىڭ ئىچىدە ئىشلىتىدىغان بارلىق نەرسىلەرگە قاراش ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","لاۋىيلارنىڭ ئەمىرلىرىنىڭ ئەمىرى بولسا كاھىن ھارۇننىڭ ئوغلى ئەلىئازار ئىدى؛ ئۇ مۇقەددەسخانىغا قاراش ۋەزىپىسىنى ئۆتەيدىغانلار ئۈستىدىن نازارەت قىلىدىغان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","مەرارىدىن ماھلى جەمەتى بىلەن مۇشى جەمەتى ۋۇجۇدقا كەلدى؛ بۇلار مەرارىنىڭ جەمەتلىرى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","بارلىق ئەركەكلەرنىڭ سانىغا ئاساسەن، بىر ئايلىقتىن يۇقىرى بولغانلار ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئالتە مىڭ ئىككى يۈز كىشى چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","مەرارىنىڭ جەمەتىنىڭ ئەمىرى ئابىھايىلنىڭ ئوغلى زۇرىيەل بولدى؛ ئۇلار ئىبادەت چېدىرىنىڭ شىمال تەرىپىگە بارگاھ قۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","مەرارى ئەۋلادلىرىنىڭ ۋەزىپىسى ئىبادەت چېدىرىنىڭ تاختايلىرى، بالداقلىرى، خادىلىرىغا، تەگلىكلىرى بارلىق ئەسۋاب-جابدۇقلىرىغا قاراش، شۇنىڭدەك بۇلارغا مۇناسىۋەتلىك ئىشلىتىلىدىغان بارلىق نەرسىلەرگە، ");
INSERT INTO uigara_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","شۇنداقلا ھويلىنىڭ تۆت ئەتراپىدىكى خادىلارغا ۋە ئۇلارنىڭ تەگلىكلىرى، قوزۇق ۋە تانىلارغا مەسئۇل بولۇشقا بەلگىلەنىدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ئىبادەت چېدىرىنىڭ ئالدىغا، شەرق تەرىپىگە، يەنى جامائەت چېدىرىنىڭ كۈنچىقىش تەرىپىگە بارگاھ قۇرغانلار مۇسا، ھارۇن ۋە ھارۇننىڭ ئوغۇللىرى ئىدى؛ ئۇلار ئىسرائ‍ىللارنىڭ خىزمىتىدە بولۇش ۋەزىپىسىنى ئۆتەپ، مۇقەددەس جايغا قارايدىغان بولدى؛ ئۇلارغا يات بولغان ھەرقانداق ئادەم مۇقەددەس جايغا يېقىنلاشسا، ئۆلتۈرۈلەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","مۇسا بىلەن ھارۇن پەرۋەردىگارنىڭ ئەمرى بويىچە، ساناقتىن ئۆتكۈزگەن بارلىق لاۋىيلار، جەمەتلىرى بويىچە، يەنى بىر ئايلىقتىن يۇقىرى ساناقتىن ئۆتكۈزۈلگەن ئەركەكلەر جەمئىي يىگىرمە ئىككى مىڭ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","پەرۋەردىگار مۇساغا: — سەن ئىسرائ‍ىللار ئىچىدە بىر ئايلىقتىن ئاشقان تۇنجى ئوغۇللارنى ساناقتىن ئۆتكۈزۈپ، ئىسىم-فامىلىسى بويىچە تىزىملاپ چىق. ");
INSERT INTO uigara_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","سەن لاۋىيلارنى ئىسرائ‍ىللارنىڭ بارلىق تۇنجىلىرىنىڭ ئورنىدا ماڭا خاس قىل ‹مەن پەرۋەردىگاردۇرمەن›؛ لاۋىيلارنىڭ مال-چارۋىلىرىنىمۇ ئىسرائ‍ىللارنىڭ بارلىق تۇنجى مال-چارۋىلىرىنىڭ ئورنىدا ماڭا خاس قىل، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","مۇسا پەرۋەردىگارنىڭ ئەمرى بويىچە، ئىسرائ‍ىللارنىڭ تۇنجىلىرىنى قويماي ساناقتىن ئۆتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","بىر ئايلىقتىن يۇقىرى تۇنجى ئوغۇل بالىلىرىنى ئىسىم-فامىلىسى بىلەن ساناقتىن ئۆتكۈزگەندە، ئۇلار جەمئىي يىگىرمە ئىككى مىڭ ئىككى يۈز يەتمىش ئۈچ كىشى چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","پەرۋەردىگار مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","سەن لاۋىيلارنى ئىسرائ‍ىللارنىڭ تۇنجىلىرىنىڭ ئورنىدا ماڭا تاللا، شۇنداقلا لاۋىيلارنىڭ مال-چارۋىلىرىنىمۇ ئىسرائ‍ىللارنىڭ مال-چارۋىلىرىنىڭ ئورنىدا ماڭا تاللا؛ شۇنىڭ بىلەن لاۋىيلار مېنىڭكى بولىدۇ؛ مەن پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ۋە لاۋىيلارنىڭ سانىدىن ئارتۇق چىققان ئىسرائ‍ىللارنىڭ تۇنجىلىرى، يەنى شۇ ئىككى يۈز يەتمىش ئۈچى ئۈچۈن ھۆرلۈك ھەققىنى قوبۇل قىلغىن؛ ");
INSERT INTO uigara_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","شۇلارنىڭ ھەربىرى ئۈچۈن بەش شەكەل كۈمۈش ئال، كىشى سانىغا قاراپ بولسۇن؛ مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچەۇلاردىن ئالغىن ‹بىر شەكەل يىگىرمە گەراھدۇر›.    ");
INSERT INTO uigara_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ئارتۇق چىققان ئادەملەرنىڭ، يەنى ھۆرلۈك ھەققىنى تۆلىشى كېرەك بولغانلارنىڭ كۈمۈشىنى ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا بەر. ");
INSERT INTO uigara_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ئەمدى لاۋىيلار تەرىپىدىن «ھۆرلۈككە چىقىرىلغان» دەپ ھېسابلانغان تۇنجى ئوغۇللاردىن ئارتۇق چىققانلاردىن بولسا، مۇسا ئۇلاردىن شۇ ھۆرلۈك ھەققىنى ئالدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ئۇ ئىسرائ‍ىللارنىڭ تۇنجىلىرىدىن شۇ كۈمۈشنى، يەنى مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە جەمئىي بىر مىڭ ئۈچ يۈز ئاتمىش بەش شەكەل ئالدى. ");
INSERT INTO uigara_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","مۇسا پەرۋەردىگارنىڭ ئەمرى بويىچە «ھۆرلۈككە چىقىرىلغان»لارنىڭ كۈمۈشىنى دەل پەرۋەردىگار بۇيرۇغىنىدەك، ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا بەردى. ");
INSERT INTO uigara_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ئاندىن پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","سەن لاۋىيلار ئىچىدىن ئاتا جەمەتى بويىچە كوھات ئەۋلادلىرىنىڭ ئومۇمىي سانىنى تىزىملىغىن، ");
INSERT INTO uigara_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرىدا ئىش-خىزمەت قىلىشقا كېلەلەيدىغانلارنىڭ ھەممىسىنى تىزىملاپ چىق. ");
INSERT INTO uigara_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","كوھات ئەۋلادلىرىنىڭ جامائەت چېدىرى ئىچىدىكى ۋەزىپىسى ئەڭ مۇقەددەس بۇيۇملارنى باشقۇرۇش بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","بارگاھكۆچۈرۈلىدىغان چاغدا، ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى كىرىپ «ئەڭ مۇقەددەس جاي»دىكى «ئايرىما پەردە-يوپۇق»نى چۈشۈرۈپ، ئۇنىڭ بىلەن ھۆكۈم-گۇۋاھلىق ساندۇقىنى يۆگىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ئاندىن ئۇنىڭ ئۈستىنى دېلفىننىڭ تېرىسىدىن ئېتىلگەن يوپۇق بىلەن ئوراپ، ئۈستىگە كۆك بىر رەختنى يېپىپ، ئاندىن كۆتۈرىدىغان بالداقلارنى ئۆتكۈزسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","تەقدىم نان تىزىلغان شىرەگە كۆك بىر رەخت سېلىنىپ، ئۈستىگە لېگەن، تەخسە، پىيالە ۋە شاراب ھەدىيەلىرىنى چاچىدىغان قەدەھلەر تىزىپ قويۇلسۇن؛ شىرەدىمۇ «دائىمىي نان» تىزىلىپ تۇرىۋەرسۇن؛    ");
INSERT INTO uigara_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","بۇ نەرسىلەرنىڭ ئۈستى قىزىل رەخت بىلەن، ئۇنىڭ ئۈستى يەنە دېلفىن تېرىسىدە ئېتىلگەن بىر يوپۇق بىلەن يېپىلىپ، ئاندىن كۆتىرىدىغان بالداقلار ئۆتكۈزۈپ قويۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ئۇلار كۆك رەخت ئېلىپ، ئۇنىڭ بىلەن چىراغدان بىلەن ئۈستىدىكى چىراغلارنى، پىلىك قىسقۇچلارنى، كۈلدانلارنى ۋە چىراغدانغا ئىشلىتىدىغان، بارلىق ماي قاچىلايدىغان قاچىلارنى يېپىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ئۇلار يەنە چىراغدان بىلەن چىراغدانغا ئىشلىتىدىغان ھەممە قاچا-قۇچا ئەسۋابلارنى دېلفىن تېرىسىدىن ئېتىلگەن يوپۇق بىلەن يۆگەپ، ئاندىن ئەپكەشكە سېلىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ئالتۇن خۇشبۇيگاھقا كۆك بىر رەخت سېلىپ، يەنە دېلفىن تېرىسىدە ئېتىلگەن يوپۇق بىلەن يېپىپ، ئاندىن كۆتۈرگۈچكە قوش بالداقلارنى ئۆتكۈزۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","مۇقەددەس جاينىڭ ئىچىدە ئىشلىتىدىغان بارلىق قاچا-قۇچىلارنى كۆك بىر رەخت بىلەن يۆگەپ، ئاندىن ئۈستىگە دېلفىن تېرىسىدە ئېتىلگەن يوپۇقنى يېپىپ، ئاندىن بىر ئەپكەشكە سېلىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ئۇلار قۇربانگاھنى كۈلىدىن تازىلاپ، ئۈستىگە سۆسۈن رەڭلىك بىر رەختنى يېيىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ئاندىن يەنە قۇربانگاھتا ئىشلىتىلىدىغان ئەسۋابلار —كۈلدان، ئىلمەك، بەلگۈرجەك، چىنىلەر، شۇنداقلا بارلىق ئەسۋابلارنى قۇربانگاھ ئۈستىگە تىزىپ، ئاندىن دېلفىن تېرىسىدە ئېتىلگەن بىر يوپۇق بىلەن يېپىپ، ئاندىن كۆتۈرىدىغان بالداقلارنى ئۆتكۈزۈپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","پۈتۈن بارگاھتىكىلەر يولغا چىقىدىغان چاغدا، ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى مۇقەددەس جاي ۋە مۇقەددەس جايدىكى بارلىق قاچا-قۇچا ئەسۋابلارنى يېپىپ بولغاندىن كېيىن، كوھاتنىڭ ئەۋلادلىرى كېلىپ كۆتۈرسۇن؛ لېكىن ئۆلۈپ كەتمەسلىك ئۈچۈن مۇقەددەس بۇيۇملارغا قول تەگكۈزمىسۇن. جامائەت چېدىرى ئىچىدىكى نەرسىلەردىن شۇلارنى كوھاتنىڭ ئەۋلادلىرى كۆتۈرۈشى كېرەك. ");
INSERT INTO uigara_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ھارۇننىڭ ئوغلى ئەلىئازارنىڭ ۋەزىپىسى چىراغ مېيى، خۇشبۇي ئەتىر، دائىمىي تەقدىم قىلىنىدىغان ئاشلىق ھەدىيەسى بىلەن مەسىھلەش مېيىغا قاراش، شۇنداقلا پۈتكۈل ئىبادەت چېدىرى بىلەن ئۇنىڭ ئىچىدىكى بارلىق نەرسىلەر، مۇقەددەس جاي ھەم مۇقەددەس جايدىكى قاچا-قۇچا ئەسۋابلارغا قاراشتىن ئىبارەت. ");
INSERT INTO uigara_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ئاندىن پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","سىلەر كوھات جەمەتىدىكىلەرنى لاۋىيلار ئارىسىدىن قەتئىي يوقىتىپ قويماڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","بەلكى ئۇلارنىڭ ئۆلمەي، ھايات قېلىشى ئۈچۈن ئۇلار «ئەڭ مۇقەددەس» بۇيۇملارغا يېقىنلاشقان چاغدا، ھارۇن بىلەن ئۇنىڭ ئوغۇللىرى كىرىپ ئۇلارنىڭ ھەربىرىگە قىلىدىغان ۋە كۆتۈرىدىغان ئىشلارنى كۆرسىتىپ قويسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ئۇلار پەقەت مۇقەددەس جايغا كىرگەندە مۇقەددەس بۇيۇملارغا بىر دەقىقىمۇ قارىمىسۇن، ئۇنداق قىلىپ قويسا ئۆلۈپ كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU4_22‏","005_4_22‏","NUM","4","22‏","23","گەرشون ئەۋلادلىرى ئىچىدە ئاتا جەمەتى ۋە ئائىلىلىرى بويىچە، ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرى ئىچىدە خىزمەت قىلىش سېپىگە كىرەلەيدىغان ھەممىسىنى ساناقتىن ئۆتكۈزۈپ ئومۇمىي سانىنى ئال. ");
INSERT INTO uigara_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","گەرشون ئائىلىلىرىنىڭ قىلىدىغان خىزمىتى ۋە ئۇلار كۆتۈرىدىغان نەرسىلەر تۆۋەندىكىچە: ");
INSERT INTO uigara_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","— ئۇلار جامائەت چېدىرىنىڭ ئۆزىنى، يەنى ئاستىدىكى ئىچكى پەردىلىرى ۋە سىرتقى پەردىلىرىنى، ئۇنىڭ ياپقۇچىنى، شۇنداقلا ئۈستىگە ياپقان دېلفىن تېرىسىدە ئېتىلگەن يوپۇقنى ۋە جامائەت چېدىرىنىڭكىرىش ئىشىكىنىڭ پەردىسىنى، ");
INSERT INTO uigara_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ئىبادەت چېدىرى بىلەن قۇربانگاھنى چۆرىدەپ تارتىلغان ھويلىدىكى پەردىلەر بىلەن كىرىش دەرۋازىسىنىڭ پەردىسىنى، شۇلارغا خاس تانىلىرىنى ۋە ئىشلىتىدىغان بارلىق قاچا-قۇچا ئەسۋابلارنى كۆتۈرسۇن؛ بۇ ئەسۋاب-ئۈسكۈنىلەرگە مۇناسىۋەتلىك كېرەك بولغان ئىشلارنى قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","گەرشون ئەۋلادلىرىنىڭ پۈتۈن ۋەزىپىسى، يەنى ئۇلار كۆتۈرىدىغان ۋە بېجىرىدىغان بارلىق ئىشلار ھارۇن ۋە ئۇنىڭ ئوغۇللىرىنىڭ كۆرسەتمىلىرى بويىچە بولسۇن؛ ئۇلارنىڭ نېمە كۆتۈرىدىغانلىقىنى سىلەر بەلگىلەپ بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","گەرشون ئەۋلادلىرىنىڭ جەمەتلىرىنىڭ جامائەت چېدىرىنىڭ ئىچىدە قىلىدىغان خىزمىتى شۇلار؛ ئۇلار كاھىن ھارۇننىڭ ئوغلى ئىتامارنىڭ قول ئاستىدا تۇرۇپ ئىشلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","مەرارىنىڭ ئەۋلادلىرىنىمۇ، ئۇلارنى ئاتا جەمەتى، ئائىلىلىرى بويىچە، ساناقتىن ئۆتكۈز؛ ");
INSERT INTO uigara_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرى ئىچىدە خىزمەت قىلىش سېپىگە كىرەلەيدىغان ھەممىسىنى ساناقتىن ئۆتكۈزۈپ ئومۇمىي سانىنى ئال. ");
INSERT INTO uigara_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ئۇلارنىڭ جامائەت چېدىرى ئىچىدىكى بارلىق خىزمىتى، يەنى كۆتۈرۈش ۋەزىپىسى مۇنداق: — ئۇلار جامائەت چېدىرىنىڭ تاختايلىرى، بالداقلىرى، خادىلىرى ۋە ئۇلارنىڭ تەگلىكلىرى، ");
INSERT INTO uigara_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ھويلىنىڭ تۆت ئەتراپىدىكى خادىلار، ئۇلارنىڭ تەگلىكلىرى، قوزۇقلىرى، تانالىرى، بارلىق ئەسۋاب-ئۈسكۈنە ھەم شۇلارغا كېرەكلىك بولغان بارلىق نەرسىلەرنى كۆتۈرۈش بولسۇن؛ ئۇلار كۆتۈرىدىغان ئەسۋاب-ئۈسكۈنىلەرنى نامىنى ئاتاپ بىر-بىرلەپ ھەر ئادەمگە كۆرسىتىپ بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","مەرارى جەمەت-ئائىلىلىرىنىڭ جامائەت چېدىرى ئىچىدە قىلىدىغان بارلىق ئىشلىرى ئەنە شۇلار؛ ئۇلار كاھىن ھارۇننىڭ ئوغلى ئىتامارنىڭ قول ئاستىدا تۇرۇپ ئىشلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU4_34‏","005_4_34‏","NUM","4","34‏","35","مۇسا بىلەن ھارۇن ۋە جامائەتنىڭ ئەمىرلىرى كوھاتنىڭ ئەۋلادلىرىنىڭ ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرىدا خىزمەت قىلىش سېپىگە كىرەلەيدىغانلارنىڭ ھەممىسىنى ئاتا جەمەتى، ئائىلىلىرى بويىچە ساناقتىن ئۆتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ئۇلاردىن جەمەتى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئىككى مىڭ يەتتە يۈز ئەللىك كىشى بولۇپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","مۇشۇلار كوھات جەمەتىدىن ساناقتىن ئۆتكۈزۈلگەنلەر بولۇپ، جامائەت چېدىرىدا ئىش قىلىدىغان ھەربىرى، يەنى پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن قىلغان ئەمرى بويىچە مۇسا بىلەن ھارۇن ساناقتىن ئۆتكۈزگەنلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU4_38‏","005_4_38‏","NUM","4","38‏","39","گەرشونلارنىڭ ئاتا جەمەتى، ئائىلىلىرى بويىچە، ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرىدا خىزمەت قىلىش سېپىگە كىرەلەيدىغان ھەممىسى ساناقتىن ئۆتكۈزۈلدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ئاتا جەمەتى، ئائىلىلىرى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئىككى مىڭ ئالتە يۈز ئوتتۇز كىشى بولۇپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","مۇشۇلار گەرشون جەمەتىدىن ساناقتىن ئۆتكۈزۈلگەنلەر بولۇپ، جامائەت چېدىرىدا ئىش قىلىدىغان ھەربىرى، يەنى پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن قىلغان ئەمرى بويىچە مۇسا بىلەن ھارۇن ساناقتىن ئۆتكۈزگەنلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU4_42‏","005_4_42‏","NUM","4","42‏","43","مەرارىلارنىڭ ئاتا جەمەتى، ئائىلىلىرى بويىچە، ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرىدا خىزمەت قىلىش سېپىگە كىرەلەيدىغان ھەممىسى ساناقتىن ئۆتكۈزۈلدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ئاتا جەمەتى، ئائىلىلىرى بويىچە ساناقتىن ئۆتكۈزۈلگەنلەر جەمئىي ئۈچ مىڭ ئىككى يۈز كىشى بولۇپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","مۇشۇلار مەرارى جەمەتىدىن ساناقتىن ئۆتكۈزۈلگەنلەر بولۇپ، جامائەت چېدىرىدا ئىش قىلىدىغان ھەربىرى، يەنى پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن قىلغان ئەمرى بويىچە مۇسا بىلەن ھارۇن ساناقتىن ئۆتكۈزگەنلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU4_46‏","005_4_46‏","NUM","4","46‏","47","ساناقتىن ئۆتكۈزۈلگەن لاۋىيلار مانا شۇلار ئىدى؛ مۇسا بىلەن ھارۇن ھەم ئىسرائ‍ىللارنىڭ ئەمىرلىرى ئۇلاردىن ئاتا جەمەتى، ئائىلىلىرى بويىچە، ئوتتۇز ياشتىن ئەللىك ياشقىچە بولغان، جامائەت چېدىرىدا خىزمەت قىلىش ۋە يۈك كۈتۈرۈش ۋەزىپىسىگە كىرەلەيدىغانلارنى ساناقتىن ئۆتكۈزگەن. ");
INSERT INTO uigara_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ئۇلارنىڭ سانى جەمئىي سەككىز مىڭ بەش يۈز سەكسەن ئادەم بولۇپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","پەرۋەردىگارنىڭ ئەمرى بويىچە، ئۇلار مۇسا تەرىپىدىن ساناقتىن ئۆتكۈزۈلدى؛ ھەركىم ئۆزى قىلىدىغان ئىشى ۋە كۆتۈرىدىغان يۈكىگە ئاساسەن ساناقتىن ئۆتكۈزۈلدى. بۇلارنىڭ ھەممىسى پەرۋەردىگارنىڭ مۇساغا ئەمر قىلغىنىدەك بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU5_2‏","005_5_2‏","NUM","5","2‏","3","سەن ئىسرائ‍ىللارغا ئەمر قىلىپ: «سىلەر پىسە-ماخاۋ كېسىلى بىلەن ئاقما كېسىلىگە گىرىپتار بولغانلارنى، شۇنداقلا ئۆلۈككە تېگىشى بىلەن ناپاك بولۇپ قالغان ھەممىسىنى ئەر-ئايال دېمەي بارگاھتىن چىقىرىۋېتىڭلار. بارگاھلارنى بۇلغىۋەتمەسلىكى ئۈچۈن ئۇلارنى بارگاھتىن چىقىرىۋېتىڭلار؛ چۈنكى مەن بارگاھ ئوتتۇرىسىدا ماكان قىلدىم» — دېگىن، — دېدى.    ");
INSERT INTO uigara_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ئىسرائ‍ىللار شۇنداق قىلىپ ئۇلارنى بارگاھتىن چىقىرىۋەتتى؛ پەرۋەردىگار مۇساغا قانداق ئەمر قىلغان بولسا، ئىسرائ‍ىللار شۇنداق قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","سەن ئىسرائ‍ىللارغا ئېيتقىن: ــ مەيلى ئەر ياكى ئايال بولسۇن، ئەگەر ئۇ ئىنسانلارنىڭ پەرۋەردىگارغا ۋاپاسىزلىق قىلىدىغان ھەرقانداق گۇناھلىرىدىن بىرىنى سادىر قىلىپ، شۇنىڭ بىلەن گۇناھكار دەپ بېكىتىلسە، ");
INSERT INTO uigara_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ئۇنداقتا ئۇ ئۆزى ئۆتكۈزگەن گۇناھىغا ئىقرار قىلىپ، ئىتائەتسىزلىكى كەلتۈرۈپ چىقارغان، زىيانلانغۇچىنىڭ زىيىنىنى تولۇق تۆلەپ بېرىشى كېرەك ۋە ئۇنىڭ سىرتىدا ئۇ كىشىگە يەنە بەشتىن بىر ئۈلۈشنى قوشۇپ تۆلەپ بەرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","زىيانلانغۇچىنىڭ مۇبادا ئىتائەتسىزلىك كەلتۈرۈپ چىقارغان زىيانغا بېرىلگەن تۆلەم پۇلىنى ئالغۇدەك تۇغقىنى بولمىسا، تۆلەم پۇلى گۇناھكار بولغان كىشىنىڭ كافارىتىگە سۇنۇلىدىغان قوشقارغا قوشۇلۇپ، پەرۋەردىگارغا ئاتىلىپ، كاھىنغا بېرىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","شۇنىڭدەك ئىسرائ‍ىللارنىڭ خۇداغا ئاتىغان بارلىق مۇقەددەس ھەدىيەلىرى، يەنى كاھىنغا كەلتۈرگەن نەرسىلەردىن بارلىق «كۆتۈرمە قۇربانلىق-ھەدىيە»لەر كاھىنغا ھېساب بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ھەركىم خۇداغا ئاتىغان ھەدىيەلەر مۇقەددەس دەپ ھېسابلانسۇن، شۇنداقلا كاھىننىڭ بولسۇن؛ كىشىلەر كاھىنغا نېمە ھەدىيە قىلسا، ئۇنىڭ ھەممىسى كاھىننىڭ بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","سەن ئىسرائ‍ىللارغا سۆز قىلىپ مۇنداق دېگىن: — ئەگەر بىرسىنىڭ خوتۇنى ئۆز ئېرىدىن يۈز ئۆرۈگەن، ساداقەتسىزلىك قىلغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","— دېمەك، باشقا بىرسى بىلەن يېقىنلاشقان، شۇنداقلا ئۇنىڭ بۇلغانغانلىقى ئېرىنىڭ كۆزلىرىدىن يوشۇرۇن بولغان بولسا، ھېچ گۇۋاھچى بولمىغان ھەم گۇناھ قىلغان چېغىدا تۇتۇلۇپمۇ قالمىغان بولسا، ");
INSERT INTO uigara_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","— شۇنداق ئەھۋالدا، ئېرى ئۆز خوتۇنىدىن گۇمان قىلىپ كۈنلىسە، خوتۇنى راستلا زىنا قىلىپ بۇلغانغان بولسا ‹ياكى ئۆز خوتۇنىغا گۇمان قىلىپ كۈنلىسىمۇ، خوتۇنى زىنا قىلمىغان ۋە بۇلغانمىغان بولسا› ");
INSERT INTO uigara_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ئەھۋالىنى ئىسپاتلاش ئۈچۈن بۇ ئادەم خوتۇنىنى كاھىننىڭ يېنىغا ئەكەلسۇن ھەم خوتۇنى ئۈچۈن زۆرۈر ئاشلىق ھەدىيەسى، يەنى ئارپا ئۇندىن ئوندىن بىر ئەفاھنى ئالغاچ كەلسۇن؛ شۇ ھەدىيەنىڭ ئۈستىگە ئۇ ھېچ زەيتۇن مېيى قۇيمىسۇن ياكى ھېچ مەستىكى قوشۇپ قويمىسۇن؛ چۈنكى بۇ كۈنداشلىق ھەدىيەسى، ئەسلەتمە ئاشلىق ھەدىيەسى بولۇپ، ئۇلارنىڭ قەبىھلىكىگە بولغان ئەسلەتمىدۇر. ");
INSERT INTO uigara_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","كاھىن ئۇ خوتۇننى ئالدىغا كەلتۈرۈپ، پەرۋەردىگارنىڭ ھۇزۇرىدا تۇرغۇزسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","كاھىن كومزەككە مۇقەددەس سۇدىن قۇيۇپ، ئىبادەت چېدىرىنىڭ يەر توپىسىدىن بىر چىمدىم ئېلىپ سۇغا چېچىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","كاھىن ئۇ خوتۇننى پەرۋەردىگارنىڭ ھۇزۇرىدا تۇرغۇزۇپ، بېشىنى ئېچىپ، ئەسلەتمە ئاشلىق ھەدىيەسى، يەنى كۈنداشلىق ھەدىيەسىنى ئۇنىڭ قولىغا تۇتقۇزسۇن، ئاندىن كاھىن قولىغا قارغىش كەلتۈرگۈچى ئەلەم سۈيىنى ئالسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","كاھىن ئۇ خوتۇنغا قەسەم ئىچكۈزۈپ، ئۇنىڭغا «دەرۋەقە سەن ھېچقانداق ئادەم بىلەن بىللە ياتمىغان، ئېرىڭنىڭ ئورنىدا باشقا بىرسى بىلەن بىللە بولۇشقا ئېزىپ بۇزۇقلۇق قىلمىغان بولساڭ، ئۇنداقتا سەن بۇ قارغىش كەلتۈرگۈچى ئەلەم سۈيىدىن خالاس بولغايسەن. ");
INSERT INTO uigara_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","لېكىن سەن ئېرىڭنىڭ ئورنىدا باشقا بىرسىگە يېقىنلىشىپ ئۆزۈڭنى بۇلغىغان بولساڭ، ئېرىڭدىن باشقا بىر ئەر سەن بىلەن بىللە ياتقان بولسا، —» دېسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU5_21‏","005_5_21‏","NUM","5","21‏","22","ئاندىن كاھىن ئۇ خوتۇنغا قارغىش قەسىمىنى ئىچكۈزگەندىن كېيىن، يەنە ئۇنىڭغا: «ــ پەرۋەردىگار يوتاڭنى يىگلىتىپ، قورسىقىڭنى ئىششىتىۋەتسۇن، شۇنىڭدەك پەرۋەردىگار سېنى ئۆز خەلقىڭ ئىچىدە قارغىش ۋە قەسەم ئىچىش دەستىكىگە ئايلاندۇرسۇن؛ بۇ قارغىش سۈيى ئىچ-قارنىڭغا كىرىپ، قورسىقىڭنى ئىششىتىۋەتسۇن، يوتاڭنى يىگلىتىۋەتسۇن» دېگەندە، ئۇ خوتۇن: «ئامىن، ئامىن» دېسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","شۇنىڭدەك كاھىن بۇ قارغىش سۆزلىرىنى دەپتەرگە پۈتۈپ قويسۇن، شۇنداقلا يازغان سۆزلەرنى ئەلەم سۈيىگە چىلىسۇن، ");
INSERT INTO uigara_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ئاندىن ئۇ خوتۇنغا بۇ قارغىش كەلتۈرگۈچى ئەلەم سۈيىنى ئىچكۈزسۇن، بۇ قارغىش كەلتۈرگۈچى سۇ ئۇنىڭ ئىچىگە كىرىشى بىلەنلا ئۇنىڭغا ئازاب-ئەلەم بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","كاھىن ئۇ خوتۇننىڭ قولىدىن كۈنداشلىق ئاشلىق ھەدىيەسىنى ئېلىپ، ئۇنى پەرۋەردىگارنىڭ ھۇزۇرىدا پۇلاڭلىتىپ بولغاندىن كېيىن، قۇربانگاھقا ئېلىپ كەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","كاھىن ھەدىيەدىن بىر سىقىم ئۇن ئېلىپ، خاتىرە ھېسابىدا قۇربانگاھقا قويۇپ كۆيدۈرسۇن؛ ئاندىن ئۇ خوتۇنغا بۇ سۇنى ئىچكۈزسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","كاھىن ئەمدى ئۇ خوتۇنغا سۇنى ئىچكۈزگەندىن كېيىن، ئەگەر ئۇھەقىقىي بۇلغانغان بولۇپ، ئۆز ئېرىگە ساداقەتسىزلىك قىلغان بولسا، چوقۇم شۇنداق بولىدۇكى، بۇ قارغىش سۈيى ئۇنىڭ ئىچىگە كىرگەندىن كېيىن ئۇنىڭغا ئازاب-ئەلەم كەلتۈرىدۇ؛ ئۇنىڭ قورسىقى ئىششىپ، يوتىسى يىگىلەپ كېتىدۇ؛ شۇنىڭ بىلەن ئۇ خوتۇن ئۆز خەلقى ئىچىدە قارغىشقا كېتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","لېكىن ئەگەر ئۇ خوتۇن بۇلغانمىغان پاك بولسا، شۇ ئىشتىن خالاس بولىدۇ ۋە ئەكسىچە ھامىلىدار بولۇپ پەرزەنتلىك بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","مانا بۇ كۈنداشلىق توغرىسىدىكى قانۇندۇر؛ خوتۇن ئۆز ئېرىنىڭ ئورنىدا باشقا بىرسى بىلەن بىللە بولۇشى بىلەن ئېزىپ بۇلغانغان بولسا ");
INSERT INTO uigara_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ۋە ياكى بىرسى خوتۇنىدىن گۇمان قىلىپ كۈنلىسە، ئۇنداقتا ئۇ خوتۇنىنى پەرۋەردىگارنىڭ ئالدىدا تۇرغۇزسۇن، كاھىن ئۇنىڭغا شۇ قانۇن بويىچە ھەممىنى ئىجرا قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ئەنە شۇنداق قىلغاندا، ئەر گۇناھتىن خالاس بولۇپ، خوتۇن ئۆز گۇناھىنى كۆتىرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","سەن ئىسرائ‍ىللارغا ئېيتقىن: «مەيلى ئەر ياكى ئايال بولسۇن، «ئۆزۈمنى پەرۋەردىگارغا ئاتاپ، نازارىيلاردىن بولىمەن» دېگەن ئالاھىدە بىر قەسەمنى ئىچكەن بولسا، ");
INSERT INTO uigara_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ئۇنداقتا ئۇ ئۆزىنى ھاراق-شارابتىن ئايرىپ پەرھىز تۇتسۇن؛ ھاراق-شاراب بىلەن ئىشلەنگەن سىركىنىمۇ ئىچمىسۇن ياكى ھەرقانداق ئۈزۈم شەربىتىنى ئىچمىسۇن ۋە ھۆل-قۇرۇق ئۈزۈملەرنىمۇ يېمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ئۆزىنى پەرۋەردىگارغا ئاتىغان بارلىق كۈنلەردە، ئۈزۈم تېلىدىن چىققان ھەرقانداق نەرسىنى، مەيلى ئۈزۈم ئۇرۇقى بولسۇن، پوستى بولسۇن، ئۇلارنى يېيىشكە بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ئۆزۈمنى پەرۋەردىگارغا ئاتىدىم دەپ قەسەم قىلغان كۈنلىرىدە، ئۇلارنىڭ بېشىغا ئۇستىرا تەگكۈزۈشكە بولمايدۇ؛ ئۆزىنى پەرۋەردىگارغا ئاتىغان كۈنلەر ئۆتۈپ بولمىغۇچە، ئۇ مۇقەددەس بولۇشى كېرەك؛ ئۇلار چاچلىرىنى ئۇزۇن قويۇشى كېرەك.    ");
INSERT INTO uigara_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ئۇ قەسەم ئىچكەن بارلىق كۈنلىرىدە ھېچقانداق ئۆلۈكلەرگە يېقىنلىشىشقا بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ئۇنىڭ ئۆز ئاتىسى، ئانىسى، قېرىندىشى ياكى ھەدە-سىڭىللىرى ئۆلۈپ قالغان بولسا، ئۇلارنى دەپ ئۆزىنى ناپاك قىلماسلىقى كېرەك؛ چۈنكى بېشىدا پەرۋەردىگارغىلا خاس بولىمەن دەپ بەرگەن ۋەدىسىنىڭ بەلگىسى بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ئۆزىنى خۇداغا ئاتىۋەتكەن بارلىق كۈنلەردە ئۇ پەرۋەردىگار ئالدىدا مۇقەددەس بولۇپ تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","مۇبادا بىر كىشى ئۇنىڭ يېنىدا تۇيۇقسىز ئۆلۈپ قېلىپ، ئۆزىنى پەرۋەردىگارغا ئاتىغانلىقنىڭ بەلگىسى بولغان بېشى بۇلغانغان بولسا، ئۇ ئۆزىنى پاكلاش كۈنى ۋە كېيىنكى يەتتىنچى كۈنىمۇ چېچىنى ئالدۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","سەككىزىنچى كۈنى ئۇ ئىككى پاختەكنى ياكى ئىككى باچكىنى ئېلىپ جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىدا كاھىنغا تاپشۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","كاھىن بىرىنى گۇناھ قۇربانلىقى، يەنە بىرىنى كۆيدۈرمە قۇربانلىق سۈپىتىدە سۇنۇپ، ئۆلۈك سەۋەبىدىن ناپاك بولۇپ قالغان گۇناھىنى تىلەپ كەفارەت قىلسۇن؛ نازارىي شۇ كۈننىڭ ئۆزىدە ئۆز بېشىنى قايتىدىن مۇقەددەس-پاك قىلسۇن، ");
INSERT INTO uigara_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ئۇ ئۆزىنى پەرۋەردىگارغا ئاتىغان كۈنلىرىنى يېڭىۋاشتىن باشلىسۇن، شۇنىڭ بىلەن بىر ياشلىق بىر ئەركەك قوزىنى ئىتائەتسىزلىك قۇربانلىقى قىلىپ سۇنسۇن؛ ئىلگىرىكى كۈنلىرى بولسا ئىناۋەتسىز ھېسابلانسۇن؛ چۈنكى ئۇنىڭ ئۆزىنى پەرۋەردىگارغا ئاتىغان ھالىتى بۇلغانغان. ");
INSERT INTO uigara_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","نازارىيلاردىن بىرى ئۆزىنى پەرۋەردىگارغىلا ئاتىغان كۈنلەر توشقان كۈنىدە ئۇ توغرۇلۇق قانۇن-بەلگىلىمە مۇنداق: ــ كىشىلەر ئۇنى جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىغا ئەكەلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ئۇ ئۆزى پەرۋەردىگارغا سۇنۇلىدىغان كۆيدۈرمە قۇربانلىق ئۈچۈن بىر ياشلىق بېجىرىم ئەركەك قوزىنى، گۇناھ قۇربانلىقى ئۈچۈن بىر ياشلىق چىشى بېجىرىم بىر قوزىنى، ئىناقلىق قۇربانلىقى ئۈچۈن بېجىرىم بىر قوشقارنى كەلتۈرسۇن، ");
INSERT INTO uigara_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","شۇنداقلا بىر سېۋەت پېتىر نان، زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن پىشۇرۇلغان توقاچلار ھەمدە زەيتۇن مېيى سۈرۈلۈپ مەسىھلەنگەن پېتىر ھەمەك نانلار ۋە شۇ قۇربانلىقلارنىڭ قوشۇمچە ئاشلىق ھەدىيەلىرى ۋە شاراب ھەدىيەلىرىنى كەلتۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","كاھىن بۇلارنى پەرۋەردىگارنىڭ ھۇزۇرىغا كەلتۈرۈپ، نازارىينىڭ شۇ گۇناھ قۇربانلىقى بىلەن كۆيدۈرمە قۇربانلىقىنى سۇنسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ئۇ پەرۋەردىگارغا ئاتالغان ئىناقلىق قۇربانلىقى سۈپىتىدە قوشقارنى سۇنسۇن، ئۇنىڭغا قوشۇپ بىر سېۋەت پېتىر ناننى سۇنسۇن؛ كاھىن شۇلار بىلەن تەڭ نازارىي قوشۇپ تەقدىم قىلغان ئاشلىق ھەدىيەسى بىلەن شاراب ھەدىيەسىنى كەلتۈرۈپ سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","نازارىي جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىدا ئۆزىنى پەرۋەردىگارغا ئاتىغانلىقىغا بەلگە قىلىپ قويۇۋەتكەن چېچىنى چۈشۈرۈپ، چېچىنى ئېلىپ ئىناقلىق قۇربانلىقى ئاستىدىكى ئوتقا قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","نازارىي شۇ تەرىقىدە ئۆزىنى پەرۋەردىگارغىلا ئاتىغانلىق چېچىنى چۈشۈرۈپ بولغاندىن كېيىن، كاھىن قايناپ پىشىرىلغان قوشقارنىڭ بىر ئالدى قولىنى ھەم سېۋەتتىن بىر پېتىر نان بىلەن بىر پېتىر ھەمەك ناننى ئېلىپ كېلىپ نازارىينىڭ قولىغا تۇتقۇزسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","كاھىن بۇلارنى پەرۋەردىگارنىڭ ئالدىدا پۇلاڭلاتما قۇربانلىق سۈپىتىدە ئۆرۈسۇن؛ بۇلار پۇلاڭلاتما قۇربانلىق سۈپىتىدە سۇنغان تۆش بىلەن كۆتۈرمە ھەدىيە قىلىنغان ئالدى قول بىلەن قوشۇلۇپ، مۇقەددەس دەپ ھېسابلىنىپ كاھىنغا بېرىلسۇن؛ ئاندىن كېيىن نازارىي شاراب ئىچسە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","شۇلار بولسا قەسەم ئىچكەن نازارىي توغرىسىدا، ئۆزىنى پەرۋەردىگارغا ئاتاشتا سۇنۇش زۆرۈر بولغان قۇربانلىق-ھەدىيەلەر توغرىسىدا بېكىتىلگەن قانۇن-بەلگىلىمىدۇر؛ شۇنىڭدەك ئۇنىڭ قولى نېمىگە يەتسە شۇنى سۇنسىمۇ بولىدۇ؛ ئۇ ئىچكەن قەسىمى بويىچە، يەنى ئۆزىنى خۇداغا ئاتاش ۋەدىسى توغرۇلۇق شۇ نىزام-بەلگىلىمە بويىچە ھەممە ئىشنى ئادا قىلسۇن؛ ۋەدىسىگە ئەمەل قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","سەن ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا سۆز قىلىپ مۇنداق دېگىن: — سىلەر ئىسرائ‍ىللارغا مۇنداق بەخت-بەرىكەت تىلەڭلار: — ");
INSERT INTO uigara_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«پەرۋەردىگار سىلەرگە بەخت-بەرىكەت ئاتا قىلغاي، سىلەرنى ئۆز پاناھىدا ساقلىغاي؛ ");
INSERT INTO uigara_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","پەرۋەردىگار يۈزىنى سىلەرنىڭ ئۈستۈڭلاردا يورۇتۇپ، سىلەرگە شاپائەت قىلغاي؛ ");
INSERT INTO uigara_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","پەرۋەردىگار يۈزىنى ئۈستۈڭلارغا قارىتىپ كۆتۈرۈپ، سىلەرگە خاتىرجەملىك بەرگەي!» ــ دەپ تىلەڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ئۇلار شۇنداق قىلىپ نامىمنى ئىسرائ‍ىللارنىڭ ئۈستىگە قوندۇرىدۇ ۋە مەن ئۇلارغا بەخت-بەرىكەت ئاتا قىلىمەن. ");
INSERT INTO uigara_vpl VALUES ("NU7_1‏","005_7_1‏","NUM","7","1‏","2","مۇسا ئىبادەت چېدىرىنى تىكلىگەن كۈنى، ئۇ چېدىرنى مەسىھ قىلىپ مايلاپ مۇقەددەس قىلدى، شۇنداقلا ئۇنىڭ ئىچىدىكى بارلىق ئەسۋاب-جابدۇقلار، قۇربانگاھ ۋە ئۇنىڭ بارلىق قاچا-قۇچا ئەسۋابلىرىنى مەسىھ قىلىپ مايلاپ مۇقەددەس قىلدى؛ شۈ كۈنى شۇنداق بولدىكى، ئىسرائىلنىڭ ئەمىرلىرى، يەنى ئۇلارنىڭ ئاتا جەمەتىنىڭ باشلىقلىرى بولغان، قەبىلە ئەمىرلىرى كېلىپ ھەدىيەلەرنى سۇندى؛ شۇ قەبىلىلەرنىڭ ئەمىرلىرى ساناقتىن ئۆتكۈزۈش ئىشىغا نازارەت قىلغۇچىلار ئىدى.    ");
INSERT INTO uigara_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ئۇلار ئۆزلىرىنىڭ ھەدىيەلىرىنى پەرۋەردىگارنىڭ ھۇزۇرىغا ھازىر قىلىشتى، كەلتۈرۈلگەن بۇ ھەدىيەلەر جەمئىي بولۇپ ئالتە ھارۋا، ئون ئىككى ئۆكۈزدىن ئىبارەت ئىدى؛ ھەر ئىككى ئەمىر بىرلىشىپ بىردىن سايىۋەنلىك ھارۋا، ھەربىر ئەمىر بىردىن ئۆكۈز ئېلىپ كەلدى؛ ئۇلار بۇ ھەدىيەلەرنى چېدىرىنىڭ ئالدىغا ئەكىلىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","پەرۋەردىگار مۇساغا سۆز قىلىپ: ــ ");
INSERT INTO uigara_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","جامائەت چېدىرىنىڭ ئىشلىرىغا ئىشلىتىش ئۈچۈن سەن بۇ نەرسىلەرنى قوبۇل قىلىپ، لاۋىيلارنىڭ ھەربىرىنىڭ بېجىرىدىغان ئىشلىرى بويىچە ئۇلارنىڭ ئىشلىتىشىگەبەرگىن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","شۇنىڭ بىلەن مۇسا ھارۋا بىلەن ئۆكۈزلەرنى قوبۇل قىلىپ لاۋىيلارغا تاپشۇرۇپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ئۇ گەرشون ئەۋلادلىرىنىڭ قىلىدىغان ئىشلىرىغا ئاساسەن، ئۇلارغا ئىككى ھارۋا بىلەن تۆت ئۆكۈز بەردى. ");
INSERT INTO uigara_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","مەرارى ئەۋلادلىرىنىڭ قىلىدىغان ئىشلىرىغا ئاساسەن، ئۇلارغا تۆت ھارۋا بىلەن سەككىز ئۆكۈز بەردى؛ ئۇلارنىڭ ھەممىسى كاھىن ھارۇننىڭ ئوغلى ئىتامارغا قارايتتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","لېكىن ئۇ كوھاتنىڭ ئەۋلادلىرىغاھېچنېمە بەرمىدى؛ چۈنكى ئۇلار مۇقەددەس نەرسىلەرنى كۆتۈرۈشكە مەسئۇل ئىدى؛ دېمەك، ئۇلار مەسئۇل بولغان نەرسىلەرنى ئۆز مۈرىسىدە كۆتۈرەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","قۇربانگاھ مايلىنىپ مەسىھلەنگەن كۈنى، ئۇنى خۇداغا بېغىشلاش يولىدا ئەمىرلەر سۇنىدىغان ھەدىيەلىرىنى ئېلىپ كېلىپ، قۇربانگاھ ئالدىغا قويۇشتى. ");
INSERT INTO uigara_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","پەرۋەردىگار مۇساغا: — ئۇلار قۇربانگاھنى بېغىشلاش يولىدا ھەدىيەلىرىنى سۇنسۇن؛ ھەربىر ئەمىر ئۆز كۈنىدە سۇنسۇن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","بىرىنچى كۈنى ھەدىيە سۇنغۇچى يەھۇدا قەبىلىسىدىن ئاممىنادابنىڭ ئوغلى ناھشون بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار ئاممىنادابنىڭ ئوغلى ناھشون سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ئىككىنچى كۈنى ھەدىيە سۇنغۇچى ئىسساكارنىڭ ئەمىرى زۇئارنىڭ ئوغلى نەتانەل بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار زۇئارنىڭ ئوغلى نەتانەل سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ئۈچىنچى كۈنى ھەدىيە سۇنغۇچى زەبۇلۇن ئەۋلادلىرىنىڭ ئەمىرى ھېلوننىڭ ئوغلى ئېلىئاب بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار ھېلوننىڭ ئوغلى ئېلىئاب سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","تۆتىنچى كۈنى ھەدىيە سۇنغۇچى رۇبەن ئەۋلادلىرىنىڭ ئەمىرى شىدۆرنىڭ ئوغلى ئەلىزۇر بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار شىدۆرنىڭ ئوغلى ئەلىزۇر سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","بەشىنچى كۈنى ھەدىيە سۇنغۇچى شىمېئون ئەۋلادلىرىنىڭ ئەمىرى زۇرى-شادداينىڭ ئوغلى شېلۇمىيەل بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار زۇرى-شادداينىڭ ئوغلى شېلۇمىيەل سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ئالتىنچى كۈنى ھەدىيە سۇنغۇچى گاد ئەۋلادلىرىنىڭ ئەمىرى دېئۇئەلنىڭ ئوغلى ئەلىئاساف بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار دېئۇئەلنىڭ ئوغلى ئەلىئاساف سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","يەتتىنچى كۈنى ھەدىيە سۇنغۇچى ئەفرائىم ئەۋلادلىرىنىڭ ئەمىرى ئاممىھۇدنىڭ ئوغلى ئەلىشاما بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار ئاممىھۇدنىڭ ئوغلى ئەلىشاما سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","سەككىزىنچى كۈنى ھەدىيە سۇنغۇچى ماناسسەھ ئەۋلادلىرىنىڭ ئەمىرى پىداھزۇرنىڭ ئوغلى گامالىيەل بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار پىداھزۇرنىڭ ئوغلى گامالىيەل سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","توققۇزىنچى كۈنى ھەدىيە سۇنغۇچى بېنيامىن ئەۋلادلىرىنىڭ ئەمىرى گىدېئونىنىڭ ئوغلى ئابىدان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار گىدېئونىنىڭ ئوغلى ئابىدان سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ئونىنچى كۈنى ھەدىيە سۇنغۇچى دان ئەۋلادلىرىنىڭ ئەمىرى ئاممىشادداينىڭ ئوغلى ئاھىئېزەر بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار ئئاممىشادداينىڭ ئوغلى ئاھىئېزەر سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ئون بىرىنچى كۈنى ھەدىيە سۇنغۇچى ئاشىر ئەۋلادلىرىنىڭ ئەمىرى ئوكراننىڭ ئوغلى پاگىيەل بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار ئوكراننىڭ ئوغلى پاگىيەل سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ئون ئىككىنچى كۈنى ھەدىيە سۇنغۇچى نافتالى ئەۋلادلىرىنىڭ ئەمىرى ئېناننىڭ ئوغلى ئاھىرا بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ئۇ سۇنغان ھەدىيە ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل كېلىدىغان بىر كۈمۈش لېگەن، ئېغىرلىقى يەتمىش شەكەل كېلىدىغان بىر كۈمۈش داس بولۇپ، بۇلار مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەندى؛ ئاشلىق ھەدىيەسى بولسۇن دەپ ئىككىسىگە زەيتۇن مېيى ئارىلاشتۇرۇلغان ئېسىل ئۇن تولدۇرۇلغانىدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ئون شەكەل ئېغىرلىقتا، خۇشبۇي تولدۇرۇلغان بىر ئالتۇن پىيالە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","كۆيدۈرمە قۇربانلىق ئۈچۈن بىر تورپاق، بىر قوچقار، بىر ياشلىق بىر ئەركەك قوزا؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","گۇناھ قۇربانلىقى ئۈچۈن بىر تېكە؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ئىناقلىق قۇربانلىقى ئۈچۈن ئىككى بۇقا، بەش قوچقار، بەش تېكە، بىر ياشلىق بەش ئەركەك قوزا؛ بۇلار ئېناننىڭ ئوغلى ئاھىرا سۇنغان ھەدىيەلەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","قۇربانگاھ مايلىنىپ مەسىھلەنگەن كۈنىدە، ئىسرائىل ئەمىرلىرى قۇربانگاھقا سۇنغان ھەدىيەلەر: — جەمئىي ئون ئىككى كۈمۈش لېگەن، ئون ئىككى كۈمۈش داس، ئون ئىككى ئالتۇن پىيالە بولدى، ");
INSERT INTO uigara_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ھەربىر كۈمۈش لېگەننىڭ ئېغىرلىقى بىر يۈز ئوتتۇز شەكەل، ھەربىر كۈمۈش داسنىڭ ئېغىرلىقى يەتمىش شەكەل ئىدى؛ مۇشۇ قاچا-قۇچىغا كەتكەن كۈمۈش مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەنگەندە، جەمئىي ئىككى مىڭ تۆت يۈز شەكەل چىقتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","خۇشبۇي بىلەن تولدۇرۇلغان ئالتۇن پىيالە ئون ئىككى بولۇپ، مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ئۆلچەنگەندە، ھەربىر ئالتۇن پىيالىنىڭ ئېغىرلىقى ئون شەكەل چىقتى؛ بۇ ئالتۇن پىيالىلەرنىڭ ئالتۇنى جەمئىي بىر يۈز يىگىرمە شەكەل چىقتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","كۆيدۈرمە قۇربانلىقلار ئۈچۈن بولغان ماللار: — جەمئىي ئون ئىككى تورپاق، ئون ئىككى قوچقار، ئون ئىككى بىر ياشلىق ئەركەك قوزا ئىدى، ھەربىرى تېگىشلىك ئاشلىق ھەدىيەلىرى بىلەن بىللە سۇنۇلدى؛ ئون ئىككى تېكە گۇناھ قۇربانلىقى ئۈچۈن سۇنۇلدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ئىناقلىق قۇربانلىقلىرى ئۈچۈن سۇنۇلغىنى جەمئىي يىگىرمە تۆت بۇقا، ئاتمىش قوچقار، ئاتمىش تېكە، بىر ياشلىق ئاتمىش ئەركەك قوزا ئىدى. قۇربانگاھ مايلىنىپ مەسىھلىنىپ، ئۇنى خۇداغا بېغىشلاش يولىدا سۇنۇلغان ھەدىيەلەر مانا مۇشۇلار. ");
INSERT INTO uigara_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","مۇسا پەرۋەردىگار بىلەن سۆزلەشكىلى جامائەت چېدىرىغا كىرگەن چېغىدا، ئۇ «ھۆكۈم-گۇۋاھلىق ساندۇقى»نىڭ ئۈستىدىكى «كەفارەت تەختى»نىڭىككى تەرىپىدىكى كېرۇبنىڭ ئوتتۇرىسىدىن ئۇنىڭ ئۆزىگە گەپ قىلغان ئاۋازىنى ئاڭلاپ تۇردى؛ پەرۋەردىگار شۇ يولدا ئۇنىڭغا سۆز قىلاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","سەن ھارۇنغا: «سەن چىراغلار ياقىدىغان چاغدا يەتتە چىراغنىڭ ھەممىسى چىراغداننىڭ ئالدىنى يورۇتىدىغان بولسۇن» دەپ ئېيتىپ قوي، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ھارۇن شۇنداق قىلدى؛ ئۇ چىراغدان ئۈستىدىكى چىراغلارنىڭ ھەممىسىنى ياندۇرۇپ، خۇددى پەرۋەردىگارنىڭ مۇساغا ئېيتقىنىدەك، چىراغ نۇرىنى چىراغداننىڭ ئالدىنى يورۇتىدىغان قىلىپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","چىراغداننىڭ ياسىلىشى مۇنداق: ئۇ ئالتۇندىن بولقا بىلەن سوقۇپ ياسالغان، پۇتىدىن گۈللىرىگىچە بولقا بىلەن سوقۇپ چىقىرىلغان. پەرۋەردىگار مۇساغا كۆرسەتكەن نۇسخىدەك، ئۇ چىراغداننى شۇنداق ياساتتى. ");
INSERT INTO uigara_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","پەرۋەردىگار مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«سەن ئىسرائ‍ىللارنىڭ ئىچىدىن لاۋىيلارنى تاللاپ چىقىپ پاكلىغىن. ");
INSERT INTO uigara_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ئۇلارنى پاكلاش ئۈچۈن ئۇلارغا مۇنداق قىل: «كەفارەت سۈيى»نى ئۇلارنىڭ بەدىنىگە چاچقىن؛ ئاندىن ئۇلار ئۆزلىرى پۈتۈن بەدىنىنى ئۇستۇرا بىلەن چۈشۈرسۇن، كىيىملىرىنى يۇيۇپ ئۆزىنى پاك قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ئاندىن كېيىن ئۇلار بىر تورپاق بىلەن شۇنىڭغا قوشۇپ ئاشلىق ھەدىيەسىنى، يەنى زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇننى كەلتۈرسۇن؛ سەن گۇناھ قۇربانلىقى ئۈچۈن يەنە بىر تورپاقنى كەلتۈر. ");
INSERT INTO uigara_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","سەن لاۋىيلارنى جامائەت چېدىرىنىڭ ئالدىغا كەلتۈر ۋە پۈتۈن ئىسرائىل جامائىتىنى يىغىپ كەل؛ ");
INSERT INTO uigara_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","لاۋىيلارنى پەرۋەردىگارنىڭ ھۇزۇرىغا ھازىر قىلغىن؛ ئاندىن ئىسرائ‍ىللار كېلىپ قوللىرىنى ئۇلارنىڭ ئۈستىگە قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ھارۇن لاۋىيلارنى ئىسرائ‍ىللارنىڭ «پۇلاڭلاتما قۇربانلىق»ى سۈپىتىدە پەرۋەردىگارنىڭ خىزمىتىنى قىلسۇن دەپ، پەرۋەردىگارغا ھەدىيە قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","لاۋىيلار قوللىرىنى ھېلىقى ئىككى تورپاقنىڭ بېشىغا قويسۇن؛ سەن بىرىنى گۇناھ قۇربانلىقى بولسۇن، بىرىنى كۆيدۈرمە قۇربانلىق بولسۇن، لاۋىيلار ئۈچۈن كەفارەت كەلتۈرسۇن دەپ پەرۋەردىگارغا سۇنغىن. ");
INSERT INTO uigara_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","سەن ئاندىن لاۋىيلارنى ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىنىڭ ئالدىدا تۇرغۇزۇپ، ئۇلارنى پۇلاڭلاتما قۇربانلىق سۈپىتىدە پەرۋەردىگارغا ھەدىيە قىل. ");
INSERT INTO uigara_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","لاۋىيلار مېنىڭكى بولسۇن دەپ، سەن لاۋىيلارنى ئەنە شۇ تەرىقىدە ئىسرائ‍ىللاردىن ئايرىپ چىق. ");
INSERT INTO uigara_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ئاندىن لاۋىيلار كىرىپ جامائەت چېدىرىنىڭ ئىشلىرىنى قىلسا بولىدۇ؛ سەن ئۇلارنى پاكلاندۇر، ئۇلارنى پۇلاڭلاتما قۇربانلىق سۈپىتىدە ھەدىيە قىل. ");
INSERT INTO uigara_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","چۈنكى ئۇلار ئىسرائ‍ىللار ئىچىدە پۈتۈنلەي ماڭا ئاتالغان؛ مېنىڭ ئۇلارنى مېنىڭكى بولسۇن دەپ تاللىشىم ئۇلارنى ئىسرائ‍ىللارنىڭ ئارىسىدا بالىياتقۇنىڭ تۇنجى مېۋىسى ئورنىدا قويغانلىقىمدۇر. ");
INSERT INTO uigara_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","چۈنكى ئىسرائ‍ىللارنىڭ تۇنجىسى، مەيلى ئۇ ئىنسان ياكى ھايۋان بولسۇن، پۈتۈنلەي ماڭا تەۋەدۇر؛ مەن مىسىر زېمىنىدا بارلىق تۇنجىلارنى ئۆلتۈرگەن كۈنى ئۇلارنى ئۆزۈمگە مۇقەددەس قىلىپ ئېلىۋالغانىدىم. ");
INSERT INTO uigara_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","مېنىڭ لاۋىيلارنى ئۇ يول بىلەن تاللىشىم ئۇلارنى ئىسرائ‍ىللارنىڭ ئىچىدىكى تۇنجىلىرىنىڭ ئورنىدا قويۇشۇم ئۈچۈندۇر. ");
INSERT INTO uigara_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ۋە جامائەت چېدىرىدا ئىسرائ‍ىللارنىڭ خىزمىتىدە بولسۇن ۋە ئىسرائ‍ىللارنىڭ گۇناھىنى تىلەپ كەفارەت كەلتۈرسۇن، شۇنىڭدەك ئىسرائ‍ىللار مۇقەددەس جايغا يېقىنلاشقاندا ئۇلار ئارىسىدا بالا-قازا چىقمىسۇن دەپ، مەن ئىسرائ‍ىللار ئىچىدىن لاۋىيلارنى ھارۇن بىلەن ئۇنىڭ ئوغۇللىرىغا بەردىم». ");
INSERT INTO uigara_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","مۇسا، ھارۇن ۋە پۈتكۈل ئىسرائىل جامائىتى لاۋىيلارنى شۇنداق قىلدى؛ پەرۋەردىگارنىڭ لاۋىيلار توغرۇلۇق مۇساغا بۇيرۇغىنىدەك ئىسرائ‍ىللار ھەممىسىنى بەجا كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","لاۋىيلار شۇنداق قىلىپ ئۆزلىرىنى گۇناھتىن پاكلاپ، كىيىم-كېچەكلىرىنى يۇيۇپ پاكىزلىدى؛ ھارۇن ئۇلارنى پۇلاڭلاتما قۇربانلىق سۈپىتىدە پەرۋەردىگارغا ھەدىيە قىلدى؛ ھارۇن يەنە ئۇلارنى پاكلاشقا گۇناھىنى تىلەپ كەفارەت قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ئاندىن كېيىن لاۋىيلار كىرىپ ھارۇننىڭ ئالدىدا، شۇنداقلا ئۇنىڭ ئوغۇللىرىنىڭ ئالدىدا، جامائەت چېدىرى ئىچىدىكى ئىشلارنى قىلىشقا كىرىشتى؛ پەرۋەردىگار لاۋىيلار توغرۇلۇق مۇساغا قانداق بۇيرۇغان بولسا، ئىسرائ‍ىللار ئۇنى شۇ بويىچە بەجا كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«لاۋىيلارنىڭ ۋەزىپىسى مۇنداق بولسۇن: — يىگىرمە بەش ياشتىن يۇقىرىلىرى كىرىپ جامائەت چېدىرى ئىچىدىكى ئىشلارنى قىلىشقا سەپكە كىرسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ئەللىك ياشقا يەتكەندىن كېيىن سەپتىن چېكىنىپ شۇ خىزمەتنى قىلمىسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","لېكىن ئۇلار جامائەت چېدىرى ئىچىدە قېرىنداشلىرىغا ياردەملىشىپ، ئۇلارنىڭ ھاجەتلىرىدىن چىقىشقا بولىدۇ، ئەمما چېدىردىكى رەسمىي ۋەزىپىدە بولمىسۇن. لاۋىيلارنىڭ ۋەزىپىلىرى ھەققىدە ئۇلارغا ئەنە شۇنداق قىل». ");
INSERT INTO uigara_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","مىسىر زېمىنىدىن چىققاندىن كېيىنكى ئىككىنچى يىلى بىرىنچى ئايدا، پەرۋەردىگار سىناي چۆلىدە مۇساغا بۇيرۇپ: — ");
INSERT INTO uigara_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ئىسرائ‍ىللار بېكىتىلگەن ۋاقىتتا ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","يەنى مۇشۇ ئاينىڭ ئون تۆتىنچى كۈنى گۇگۇمدا، بېكىتىلگەن ۋاقىتتا، بارلىق بەلگىلىمە ۋە قائىدە-تەرتىپ بويىچە ھېيتنى ئۆتكۈزۈڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","شۇنىڭ بىلەن مۇسا ئىسرائ‍ىللارغا سۆز قىلىپ ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزۈشنى بۇيرۇدى. ");
INSERT INTO uigara_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ئۇلار بىرىنچى ئاينىڭ ئون تۆتىنچى كۈنى گۇگۇمدا، سىناي چۆلىدە ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزدى؛ پەرۋەردىگار مۇساغا قانداق بۇيرۇغان بولسا، ئىسرائ‍ىللار شۇنداق قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","بىر نەچچەيلەن بىر ئۆلۈككە تېگىپ كېتىپ ناپاك بولۇپ قالغانلىقى ئۈچۈن، ئۇلار شۇ كۈنى ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزەلمىدى-دە، ئۇلار شۇ كۈنى مۇسا بىلەن ھارۇننىڭ ئالدىغا كېلىپ مۇساغا: — ");
INSERT INTO uigara_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","بىز ئۆلۈپ قالغان ئادەمگە تېگىپ كېتىپ ناپاك بولۇپ قالغان بولساقمۇ، لېكىن نېمىشقا ئىسرائ‍ىللارنىڭ قاتارىدا، بېكىتىلگەن ۋاقىتتا پەرۋەردىگارغا سۇنۇشقا كېرەك بولغىنىنى ئېلىپ كېلىشتىن رەت قىلىنىمىز؟ — دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","— توختاپ تۇرۇڭلار، مەن بېرىپ پەرۋەردىگار سىلەر توغراڭلاردا نېمە بۇيرۇيدىكىن، ئاڭلاپ باقاي، ــ دېدى مۇسا ئۇلارغا. ");
INSERT INTO uigara_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","سەن ئىسرائ‍ىللارغا مۇنداق دېگىن: «سىلەر ۋە سىلەرنىڭ ئەۋلادلىرىڭلار ئىچىدە بەزىلەر ئۆلۈكلەرگە تېگىپ كېتىپ ناپاك بولۇپ قالغان بولسا ياكى ئۇزاق سەپەر ئۈستىدە بولسا، ئۇلار يەنىلا پەرۋەردىگار ئۈچۈن ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزۈشكە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ئۇنداق كىشىلەر ئىككىنچى ئاينىڭ ئون تۆتىنچى كۈنى گۇگۇمدا ھېيتنى ئۆتكۈزسۇن؛ ھېيت تائامىنى پېتىر نان ۋە ئاچچىق كۆكتاتلار بىلەن بىللە يېسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ئۇلاردىن ئەتىگە ئازراقمۇ قالدۇرمىسۇن ۋە قوزىسىنىڭ ئۇستىخانلىرىدىن بىرەرسىنىمۇ سۇندۇرغۇچى بولمىسۇن؛ ئۇلار ھېيتنى ئۆتۈپ كېتىش ھېيتىنىڭ بارلىق بەلگىلىمىلىرى بويىچە ئۆتكۈزسۇن.    ");
INSERT INTO uigara_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ھالبۇكى، پاك بولغان، سەپەر ئۈستىدىمۇ بولمىغان ئەمما ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزۈشكە ئېتىبار بەرمىگەن كىشى بولسا ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ؛ چۈنكى بېكىتىلگەن ۋاقىتتا پەرۋەردىگارغا سۇنۇش كېرەك بولغىنىنى سۇنمىغانلىق ىۈچۈن، ئۇ ئۆز گۇناھىنى ئۆز ئۈستىگە ئالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ئەگەر ئاراڭلاردا تۇرۇۋاتقان يات ئەللىك بىر مۇساپىر پەرۋەردىگار ئۈچۈن ئۆتۈپ كېتىش ھېيتىنى ئۆتكۈزۈشنى خالىسا، ئۇ ئۆتۈپ كېتىش ھېيتى توغرىسىدىكى بەلگىلىمە ۋە قائىدە-تەرتىپ بويىچە ئۆتكۈزسۇن؛ يات ئەللىك مۇساپىرلار ئۈچۈن ۋە زېمىندا تۇغۇلغانلار ئۈچۈنمۇ ئاراڭلاردا شۇ بىرلا نىزام بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ئىبادەت چېدىرى تىكلەنگەن كۈنى، بۇلۇت ئىبادەت چېدىرىنى، يەنى ھۆكۈم-گۇۋاھلىق چېدىرىنى قاپلاپ تۇردى؛ كەچتىن تاكى ئەتىگەنگىچە، بۇلۇت خۇددى ئوتتەك ئىبادەت چېدىرىنىڭ ئۈستىدە تۇردى.    ");
INSERT INTO uigara_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","دائىم شۇنداق بولاتتى؛ كۈندۈزى بۇلۇت ئىبادەت چېدىرىنى قاپلاپ تۇراتتى، كېچىسى ئۇ ئوتقا ئوخشايتتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","قاچانىكى بۇلۇت جامائەت چېدىرىنىڭ ئۈستىدىن كۆتۈرۈلسە، ئىسرائ‍ىللار يولغا چىقاتتى؛ بۇلۇت قەيەردە توختىسا، ئىسرائ‍ىللار شۇ يەردە بارگاھ تىكەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ئىسرائ‍ىللار پەرۋەردىگارنىڭ بۇيرۇقى بويىچە ماڭاتتى، پەرۋەردىگارنىڭ بۇيرۇقى بويىچە بارگاھ تىكەتتى؛ بۇلۇت ئىبادەت چېدىرىنىڭ ئۈستىدە قانچە ئۇزاق توختىسا، ئۇلار بارگاھتا شۇنچە ئۇزاق تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","بۇلۇت ئىبادەت چېدىرىنىڭ ئۈستىدە خېلى كۈنلەرگىچە توختاپ تۇرسا، ئىسرائ‍ىللارمۇ پەرۋەردىگارنىڭ كۆرسىتمىسىنى تۇتۇپ سەپەرگە چىقمايتتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","مۇبادا بۇلۇت ئىبادەت چېدىرىنىڭ ئۈستىدە پەقەت بىرنەچچە كۈنلا توختىسا، ئۇلار پەرۋەردىگارنىڭ بۇيرۇقى بويىچە شۇ ۋاقىتتا بارگاھ قۇرۇپ ياتاتتى، ئاندىن يەنە پەرۋەردىگارنىڭ بۇيرۇقى بويىچە سەپەرگە ئاتلىناتتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ۋە مۇبادا بۇلۇت پەقەتلا كەچتىن ئەتىگەنگىچە توختاپ، ئەتتىگەندە بۇلۇت يەنە كۆتۈرۈلسە، ئۇلار يەنە يولغا چىقاتتى؛ مەيلى كۈندۈزى ياكى كېچىسى بۇلۇت كۆتۈرۈلسىلا، ئۇلار سەپەرگە چىقاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","بۇلۇت ئىبادەت چېدىرىنىڭ ئۈستىدە ئۇزۇنراق تۇرسا، مەيلى ئىككى كۈن، بىر ئاي، بىر يىل تۇرسىمۇ، ئىسرائ‍ىللار يولغا چىقماي بارگاھتا تۇرۇۋېرەتتى؛ لېكىن بۇلۇت كۆتۈرۈلۈپ ماڭسىلا ئۇلار سەپىرىنى داۋاملاشتۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","پەرۋەردىگارنىڭ بۇيرۇقى بىلەن ئۇلار بارگاھ قۇراتتى، پەرۋەردىگارنىڭ بۇيرۇقى بىلەن ئۇلار سەپەرنى داۋاملاشتۇراتتى؛ ئۇلار پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن بەرگەن ئەمرى بويىچە، پەرۋەردىگارنىڭ كۆرسىتمىسىنى تۇتاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","سەن ئۆزۈڭگە ئىككى كاناي ياساتقىن؛ ئۇلارنى كۈمۈشتىن سوقتۇر. ئۇلار جامائەتنى يىغىشقا، شۇنداقلا جامائەتنى بارگاھلىرىنى يىغىشتۇرۇپ يولغا چىقىشقا چاقىرىش ئۈچۈن ئىشلىتىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ئىككى كاناي چېلىنغاندا پۈتكۈل جامائەت سېنىڭ يېنىڭغا جامائەت چېدىرى دەرۋازىسىنىڭ ئالدىغا يىغىلىدىغان بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ئەگەر يالغۇز بىرى چېلىنسا، ئەمىرلىرى، يەنى مىڭلىغان ئىسرائ‍ىللارنىڭ مىڭبېشىلىرى سېنىڭ يېنىڭغا كېلىپ يىغىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","سىلەر قاتتىق يۇقىرى ئاۋاز بىلەن چالغاندا كۈن چىقىش تەرەپتىكى بارگاھلار يولغا چىقسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ئاندىن سىلەر ئىككىنچى قېتىم قاتتىق، يۇقىرى ئاۋاز بىلەن چالغاندا جەنۇب تەرەپتىكى بارگاھلار يولغا چىقسۇن؛ ئۇلار يولغا چىققان چاغدا كاناي قاتتىق، يۇقىرى ئاۋاز بىلەن چېلىنىشى كېرەكتۇر. ");
INSERT INTO uigara_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","جامائەتنى يىغىلىشقا چاقىرىدىغان چاغدا، كاناي چېلىڭلار، ئەمما قاتتىق، يۇقىرى ئاۋاز بىلەن چالماڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ھارۇننىڭ ئەۋلادلىرى، كاھىن بولغانلار كانايلارنى چالسۇن؛ بۇلار سىلەرگە ئەۋلادمۇ-ئەۋلاد بىر ئەبەدىي بەلگىلىمە بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ئەگەر سىلەر ئۆز زېمىنىڭلاردا سىلەرگە زۇلۇم سالغان دۈشمىنىڭلار بىلەن جەڭ قىلىشقا چىقساڭلار، قاتتىق، يۇقىرى ئاۋاز بىلەن چېلىڭلار. شۇنىڭ بىلەن ئۆزۈڭلارنىڭ خۇداسى بولغان پەرۋەردىگارنىڭ ئالدىدا ياد ئېتىلىپ، دۈشمىنىڭلاردىن قۇتۇلىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","بۇنىڭدىن باشقا، خۇشال كۈنلىرىڭلاردا، بېكىتىلگەن ھېيتلىرىڭلاردا ۋە ئاينىڭ بىرىنچى كۈنلىرىدە، سىلەر كۆيدۈرمە قۇربانلىق ۋە ئىناقلىق قۇربانلىقلىرىنى سۇنغىنىڭلاردا، قۇربانلىقلارنىڭ ئالدىدا تۇرۇپ كاناي چېلىڭلار؛ شۇنىڭ بىلەن كانايلار سىلەرنى خۇدايىڭلارغا ئەسلەتكۈچى بولىدۇ؛ مەن خۇدايىڭلار پەرۋەردىگاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ئىككىنچى يىلى، ئىككىنچى ئاينىڭ يىگىرمىنچى كۈنى بۇلۇت ھۆكۈم-گۇۋاھلىق چېدىرىنىڭ ئۈستىدىن كۆتۈرۈلدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","شۇنىڭ بىلەن ئىسرائ‍ىللار سىناي چۆلىدىن چىقىپ، يول ئېلىپ سەپەرلىرىنى باشلىدى؛ بۇلۇت پاران چۆلىدە توختىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","بۇ ئۇلارنىڭ بىرىنچى قېتىم پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن قىلغان ئەمرى بويىچە يولغا چىقىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","يەھۇدا بارگاھى ئۆزىنىڭ تۇغى ئاستىدا قوشۇن-قوشۇن بولۇپ ئالدى بىلەن يولغا چىقتى؛ قوشۇننىڭ باشلىقى ئاممىنادابنىڭ ئوغلى ناھشون ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ئىسساكار قەبىلىسى قوشۇنىنىڭ باشلىقى زۇئارنىڭ ئوغلى نەتانەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","زەبۇلۇن قەبىلىسى قوشۇنىنىڭ باشلىقى ھېلوننىڭ ئوغلى ئېلىئاب ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ئاندىن ئىبادەت چېدىرى چۇۋۇلۇپ، گەرشوننىڭ ئەۋلادلىرى بىلەن مەرارىنىڭ ئەۋلادلىرى ئۇنى كۆتۈرۈپ يولغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","رۇبەن بارگاھى ئۆزىنىڭ تۇغى ئاستىدا قوشۇن-قوشۇن بولۇپ يولغا چىقتى؛ قوشۇننىڭ باشلىقى شىدۆرنىڭ ئوغلى ئەلىزۇر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","شىمېئون قەبىلىسى قوشۇنىنىڭ باشلىقى زۇرى-شادداينىڭ ئوغلى شېلۇمىيەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","گاد قەبىلىسى قوشۇنىنىڭ باشلىقى دېئۇئەلنىڭ ئوغلى ئەلىئاساف ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ئاندىن كوھاتلار مۇقەددەس بۇيۇملارنى كۆتۈرۈپ يولغا چىقتى؛ ئۇلار يېتىپ كېلىشتىن بۇرۇن ئىبادەت چېدىرىنى كۆتۈرگۈچىلەر كېلىپ ئۇنى تىكلەپ قويۇشقانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ئەفرائىم بارگاھى ئۆزىنىڭ تۇغى ئاستىدا قوشۇن-قوشۇن بولۇپ يولغا چىقتى؛ قوشۇننىڭ باشلىقى ئاممىھۇدنىڭ ئوغلى ئەلىشاما ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ماناسسەھ قەبىلىسى قوشۇنىنىڭ باشلىقى پىداھزۇرنىڭ ئوغلى گامالىيەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","بىنيامىن قەبىلىسى قوشۇنىنىڭ باشلىقى گىدېئونىنىڭ ئوغلى ئابىدان ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","دان بارگاھى ھەممە بارگاھلارنىڭ ئارقا مۇھاپىزەتچىسى بولۇپ، ئۆزىنىڭ تۇغى ئاستىدا قوشۇن-قوشۇن بولۇپ يولغا چىقتى؛ قوشۇننىڭ باشلىقى ئاممىشادداينىڭ ئوغلى ئاھىئېزەر ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ئاشىر قەبىلىسى قوشۇنىنىڭ باشلىقى ئوكراننىڭ ئوغلى پاگىيەل ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","نافتالى قەبىلىسى قوشۇنىنىڭ باشلىقى ئېناننىڭ ئوغلى ئاھىرا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","بۇلار ئىسرائ‍ىللار يولغا چىققاندا قوشۇن-قوشۇن بولۇپ مېڭىش تەرتىپى ئىدى؛ ئۇلار شۇ تەرىقىدە يولغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","مۇسا ئۆزىنىڭ قېيناتىسى، مىدىيانلىق رېئۇئەلنىڭ ئوغلى ھوبابقا: — بىز پەرۋەردىگار ۋەدە قىلغان يەرگە قاراپ سەپەر قىلىۋاتىمىز، ئۇ: «مەن ئۇ يەرنى سىلەرگە مىراس قىلىپ بېرىمەن» دېگەن؛ ئۆزلىرىنىڭ بىز بىلەن بىللە مېڭىشلىرىنى ئۆتۈنىمەن، بىز سىلىگە ياخشى قارايمىز، چۈنكى پەرۋەردىگار ئىسرائىل توغرۇلۇق بەخت-سائادەت ئاتا قىلىمەن دەپ ۋەدە بەرگەن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","لېكىن ھوباب مۇساغا: — ياق، مەن ئۆز يۇرتۇم، ئۆز ئۇرۇق-تۇغقانلىرىمغا كېتىمەن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","مۇسا ئۇنىڭغا: بىزدىن ئايرىلىپ كەتمىسىلە؛ چۈنكى سىلى چۆلدە قانداق بارگاھ قۇرۇشىمىز كېرەكلىكىنى بىلىلا، سىلى بىزگە كۆز بولۇپ بەرسىلە. ");
INSERT INTO uigara_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","شۇنداق بولىدۇكى، بىز بىلەن بىللە بارسىلا، كەلگۈسىدە پەرۋەردىگار بىزگە قانداق ياخشىلىق قىلسا، بىزمۇ سىلىگە شۇنداق قىلىمىز! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ئىسرائ‍ىللار پەرۋەردىگار تېغىدىن يولغا چىقىپ ئۈچ كۈن يول ماڭدى؛ پەرۋەردىگارنىڭ ئەھدە ساندۇقى ئۇلارغا ئارام ئالىدىغان يەر ئىزدەپ ئۇلارنىڭ ئالدىدا ئۈچ كۈن يول باشلاپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ئۇلار چېدىرلىرىنى يىغىشتۇرۇپ يولغا چىقىدىغان چاغلاردا، پەرۋەردىگارنىڭ بۇلۇتى ھامان ئۇلارنىڭ ئۈستىدە بولاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ئەھدە ساندۇقى يولغا چىقىدىغان چاغدا مۇسا: «ئورنۇڭدىن تۇرغايسەن، ئى پەرۋەردىگار؛ دۈشمەنلىرىڭ تىرىپىرەن بولسۇن؛ ساڭا ئۆچلەر يۈزۈڭنىڭ ئالدىدىن قاچسۇن!» — دەيتتى. ");
INSERT INTO uigara_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ئەھدە ساندۇقى توختىغان چاغدا ئۇ: «قايتىپ كەلگەيسەن، ئى پەرۋەردىگار، مىڭلىغان-تۈمەنلىگەن ئىسرائىل خەلقى ئارىسىغا قايتىپ كەلگەيسەن!» — دەيتتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ۋە شۇنداق بولدىكى، خەلق غوتۇلدىشاتتى، ئۇلارنىڭ غوتۇلداشلىرى پەرۋەردىگارنىڭ قۇلىقىغا يېتىپ ئىنتايىن رەزىل ئاڭلاندى؛ ئۇ بۇ سۆزلەرنى ئاڭلىدى ۋە ئۇنىڭ غەزىپى قوزغالدى؛ پەرۋەردىگارنىڭ ئوت-يالقۇنى ئۇلارنىڭ ئارىسىدا تۇتىشىپ، بارگاھنىڭ چېتىدىكى بەزىلەرنى كۆيدۈرۈشكە باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","خەلق بۇ چاغدا مۇساغا يالۋۇرىۋىدى، مۇسا پەرۋەردىگاردىن تىلىدى؛ شۇنىڭ بىلەن ئوت پەسىيىپ ئۆچتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","پەرۋەردىگارنىڭ ئوتى ئۇلارنىڭ ئوتتۇرىسىدا تۇتاشقانلىقى ئۈچۈن ئۇ ئۇ يەرگە «تابەراھ» دەپ ئات قويدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ئۇلارنىڭ ئارىسىدىكى شالغۇت كىشىلەرنىڭ نەپسى تاقىلداپ كەتتى، ئىسرائ‍ىللارمۇ يەنە يىغلاشقا باشلىدى: «ئەمدى بىزگە كىم گۆش بېرىدۇ؟    ");
INSERT INTO uigara_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ھېلىمۇ ئېسىمىزدىكى، بىز مىسىردىكى چاغلاردا پۇل خەجلىمەي تۇرۇپمۇ بېلىق يېيەلەيتتۇق، يەنە تەرخەمەك، تاۋۇز، پىياز ۋە كۈدە پىياز بىلەن سامساقمۇ بار ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","مانا بۇ يەردە ھازىر كۆز ئالدىمىزدا ماننادىن باشقا ھېچنېمە يوق، ئەمدى بىزنىڭ جېنىمىزمۇ قۇرۇپ كېتىۋاتىدۇ» دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ماننا گويا يۇمغاقسۈت ئۇرۇقىغا، كۆرۈنۈشى گويا كەھرىۋاغا ئوخشايتتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","كىشىلەر ئۇيان-بۇيان چېپىپ ئۇنى يىغىپ، بەزىدە يارغۇنچاقتا ئېزىپ، بەزىدە ھاۋانچىدا سوقۇپ، يا بەزىدە قازاندا پىشۇرۇپ نان قىلىپ يەيتتى؛ تەمى زەيتۇن مايلىق توقاچلارغا ئوخشايتتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","كېچىدە بارگاھقا شەبنەم چۈشكەندە، ماننامۇ شۇنىڭ ئۈستىگە چۈشەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","مۇسا خەلقنىڭ ئائىلىمۇ-ئائىلە ھەربىرى ئۆز چېدىرىنىڭ ئىشىكى ئالدىدا يىغا-زار قىلىشىۋاتقىنىنى ئاڭلىدى؛ بۇنىڭغا پەرۋەردىگارنىڭ غەزىپى قاتتىق قوزغالدى، بۇ ئىش مۇسانىڭ نەزىرىدىمۇ يامان كۆرۈندى. ");
INSERT INTO uigara_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","مۇسا پەرۋەردىگارغا: — سەن بۇ بارلىق خەلقنىڭ ئېغىر يۈكىنى ماڭا ئارتىپ قويۇپ، مەن قۇلۇڭنى نېمىشقا بۇنداق قىينايسەن؛ نېمىشقا مەن سېنىڭ ئالدىڭدا ئىلتىپات تاپمايمەن؟ ");
INSERT INTO uigara_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","يا مەن بۇ پۈتۈن خەلققە ھامىلىدار بولۇپ، ئۇلارنى تۇغدۇممۇ؟ سەن تېخى ماڭا: «سەن ئۇلارنى مەن قەسەم ئىچىپ ئۇلارنىڭ ئاتا-بوۋىلىرىغا مىراس قىلغان شۇ يەرگە يەتكۈزگۈچە، خۇددى باققان ئاتىسى ئەمچەكتىكى بوۋاقنى باغرىغا ئالغاندەك باغرىڭغا ئېلىپ كۆتۈرۈپ ماڭ» دەۋاتىسەن؟ ");
INSERT INTO uigara_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","مەن بۇ خەلققە نەدىن گۆش تېپىپ بېرەلەيمەن؟ چۈنكى ئۇلار ماڭا يىغلاپ: «سەن بىزگە يېگۈدەك گۆش تېپىپ بەر!» دېيىشمەكتە. ");
INSERT INTO uigara_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","مەن بۇ خەلقنى كۆتۈرۈشنى يالغۇز ئۈستۈمگە ئېلىپ كېتەلمەيدىكەنمەن، بۇ ئىش ماڭا بەك ئېغىر كېلىۋاتىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ئەگەر سەن ماڭا مۇشۇنداق مۇئامىلە قىلماقچى بولساڭ، مەن ئۆتۈنۈپ قالاي، بۇ خاراب ھالىتىمنى ماڭا كۆرسەتمەي، ئىلتىپات قىلىپ مېنى ئۆلتۈرۈۋەت! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","پەرۋەردىگار مۇساغا مۇنداق دېدى: — ئىسرائىل ئاقساقاللىرى ئىچىدىن، سەن يېنىمغا تونۇيدىغان خەلق ئاقساقاللىرى ۋە بەگلەردىن يەتمىشنى تاللاپ يىغقىن، ئۇلارنى جامائەت چېدىرىنىڭ ئالدىغا ئەكەل. ئۇلار سېنىڭ بىلەن بىللە شۇ يەردە تۇرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","مەن شۇ يەرگە چۈشۈپ سېنىڭ بىلەن سۆزلىشىمەن؛ ۋە سېنىڭ ئۈستۈڭدە تۇرۇۋاتقان روھنى ئېلىپ ئۇلارنىڭ ئۈستىگىمۇ بۆلۈپ قويىمەن. شۇنىڭ بىلەن ئۇلار سەن بىلەن بىللە خەلقنى كۆتۈرۈش مەسئۇلىيىتىنى ئۈستىگە ئالىدۇ، ئاندىن سەن ئۇنى ئۆزۈڭ يالغۇز كۆتۈرمەيدىغان بولىسەن. ");
INSERT INTO uigara_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","سەن خەلققە مۇنداق دېگىن: «ئەتە گۆش يىيىشكە تەييارلىنىپ ئۆزەڭلەرنى خۇداغا ئاتاپ پاكلاڭلار؛ چۈنكى سىلەر پەرۋەردىگارنىڭ قۇلىقىنى ئاغرىتىپ يىغلاپ: «ئەمدى كىم بىزگە گۆش بېرىدۇ؟ ئاھ، مىسىردىكى ھالىمىز بەك ياخشى ئىدى!» دېگەنىدىڭلار ئەمەسمۇ؟ پەرۋەردىگار دەرۋەقە سىلەرگە گۆش بېرىدۇ، سىلەر ئۇنىڭدىن يەيسىلەر. ");
INSERT INTO uigara_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","سىلەر بىر كۈن، ئىككى كۈن ئەمەس، بەش كۈن، ئون كۈن ئەمەس، يىگىرمە كۈنمۇ ئەمەس، ");
INSERT INTO uigara_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بەلكى پۈتۈن بىر ئاي يەيسىلەر، تاكى بۇرنىڭلاردىن ئېتىلىپ چىقىپ ھۆ بولغۇچە يەيسىلەر؛ چۈنكى سىلەر ئاراڭلاردا تۇرۇۋاتقان پەرۋەردىگارنى مەنسىتمەي، ئۇنىڭ ئالدىدا يىغلاپ تۇرۇپ: «بىز نېمە ئۈچۈن مىسىردىن چىقتۇق؟» — دېدىڭلار». ");
INSERT INTO uigara_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","مۇسا: — مەن ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان بۇ خەلقتىن يولغا چىقالايدىغان ئەركەكلەر ئالتە يۈز مىڭ تۇرسا، سەن تېخى: «مەن ئۇلارنى گۆش يەيدىغان، ھەتتا پۈتۈن بىر ئاي گۆش يەيدىغان قىلىمەن» دەيسەن؛ ");
INSERT INTO uigara_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ئەمىسە قوي، كالا پادىلىرىنىڭ ھەممىسى سويۇلسا ئۇلارغا يېتەمدۇ؟ ياكى دېڭىزدىكى ھەممە بېلىق ئۇلارغا تۇتۇپ بېرىلسە، ئۇلارنىڭ يىيىشىگە يىتەرمۇ؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","شۇنىڭ بىلەن پەرۋەردىگار مۇساغا: — پەرۋەردىگارنىڭ قولى قىسقا بولۇپ قاپتىمۇ؟ ئەمدى كۆرۈپ باققىنە، مېنىڭ ساڭا دېگەن سۆزۈم ئەمەلگە ئاشۇرۇلامدۇ-يوق؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","شۇنىڭ بىلەن مۇسا چىقىپ پەرۋەردىگارنىڭ سۆزىنى خەلققە يەتكۈزدى ۋە خەلق ئىچىدىكى ئاقساقاللاردىن يەتمىش ئادەمنى تاللاپ يىغىپ ئۇلارنى جامائەت چېدىرىنىڭ ئەتراپىدا تۇرغۇزدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ئاندىن پەرۋەردىگار بۇلۇت ئىچىدىن چۈشۈپ، مۇسا بىلەن سۆزلىشىپ، ئۇنىڭدىكى روھتىن ئېلىپ يەتمىش ئاقساقالغا قويدى؛ روھ ئۇلارنىڭ ئۈستىگە قونۇشى بىلەن ئۇلار بېشارەت بېرىشكە كىرىشتى. لېكىن شۇ ۋاقىتتىن كېيىن ئۇلار ئۇنداق قىلمىدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","لېكىن ئۇ چاغدا ئۇلاردىن ئىككى ئادەم بارگاھتا قالدى؛ بىرسىنىڭ ئىسمى ئەلداد، ئىككىنچىسى مېداد ئىدى ‹ئۇلار ئەسلىدە ئاقساقاللارنىڭ ئارىسىدا تىزىملانغانىدى، لېكىن ئىبادەت چېدىرىغا چىقماي قالغانىدى›. روھ ئۇلارنىڭ ئۈستىدىمۇ قوندى ۋە ئۇلار بارگاھ ئىچىدە بېشارەت بېرىشكە باشلىدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ياش بىر يىگىت يۈگۈرۈپ كېلىپ مۇساغا: — ئەلداد بىلەن مېداد بارگاھتا بېشارەت بېرىۋاتىدۇ، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","مۇسانىڭ خىزمەتكارى، مۇسا تاللىغان سەرخىل يىگىتلىرىدىن بىرى، نۇننىڭ ئوغلى يەشۇئا قوپۇپ: — ئى خوجام مۇسا، ئۇلارنى توسۇغايلا، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","لېكىن مۇسا ئۇنىڭغا: — سەن مېنىڭ سەۋەبىمدىن ھەسەت قىلىۋاتامسەن؟ پەرۋەردىگارنىڭ پۈتۈن خەلقى پەيغەمبەر بولۇپ كەتسە ئىدى، پەرۋەردىگار ئۆزىنىڭ روھىنى ئۇلارنىڭ ئۈستىگە قويسا ئىدى! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","شۇنىڭ بىلەن مۇسا بىلەن ئىسرائىل ئاقساقاللىرىنىڭ ھەممىسى بارگاھقا قايتىپ كېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ئەمدى پەرۋەردىگار ئالدىدىن بىر شامال چىقىپ، ئۇ دېڭىز تەرەپتىن بۆدۈنىلەرنى ئۇچۇرتۇپ كېلىپ، بارگاھنىڭ ئەتراپىغا يېيىۋەتتى؛ بۆدۈنىلەر بارگاھنىڭ ئۇ تەرىپىدىمۇ بىر كۈنلۈك يول، بۇ تەرىپىدىمۇ بىر كۈنلۈك يول كەلگۈدەك يەر يۈزىنى ئىككى گەز ئېگىزلىكتە كەلگۈدەك قاپلىدى.    ");
INSERT INTO uigara_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","خەلق ئورنىدىن تۇرۇپ پۈتكۈل شۇ كۈنى، شۇ كېچىسى ۋە ئەتىسى پۈتۈن كۈن بۆدۈنە تۇتۇپ يىغدى، ئەڭ ئاز دېگەنلىرىمۇ ئالاھازەل ئىككى خومىر يىغدى؛ ئۇلار بۇلارنى بارگاھنىڭ تۆت ئەتراپىغا ئۆزلىرى ئۈچۈن يېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ئۇلار گۆشنى چايناپ ئېزىپ بولماي، گۆش تېخى چىشلىرى ئارىسىدا تۇرغاندا، پەرۋەردىگارنىڭ غەزىپى ئۇلارغا قوزغىلىپ، خەلقنى ئىنتايىن ئېغىر بىر ۋابا بىلەن ئۇردى.    ");
INSERT INTO uigara_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","شۇڭا كىشىلەر شۇ يەرنى «قىبروت-ھاتتاۋاھ» دەپ ئاتىدى؛ چۈنكى ئۇلار شۇ يەردە نەپسى تاقىلدىغان كىشىلەرنى يەرلىككە قويغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","كېيىن خەلق قىبروت-ھاتتاۋاھتىن يولغا چىقىپ ھازىروتقا كېلىپ، ھازىروتتا توختىدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","مەرىيەم بىلەن ھارۇن مۇسانىڭ ھەبەشلىك قىزنى خوتۇنلۇققا ئالغىنى ئۈچۈن ئۇنىڭغا قارشى سۆز قىلدى ‹چۈنكى ئۇ ھەبەشلىك بىر قىزنى ئالغانىدى›. ");
INSERT INTO uigara_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ئۇلار: — پەرۋەردىگار پەقەت مۇسا بىلەنلا سۆزلىشىپ، بىز بىلەن سۆزلەشمەپتىمۇ؟ — دېيىشتى. بۇ گەپنى پەرۋەردىگار ئاڭلىدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","مۇسا دېگەن بۇ ئادەم ئىنتايىن كەمتەر-مۆمىن ئادەم بولۇپ، بۇ تەرەپتە يەر يۈزىدىكىلەر ئارىسىدا ئۇنىڭ ئالدىغا ئۆتىدىغىنى يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","پەرۋەردىگار مۇسا، ھارۇن ۋە مەرىيەمگە تۇيۇقسىز: — سىلەر ئۈچۈڭلار جامائەت چېدىرىغا كېلىڭلار، — دېدى. ئۈچىلىسى چىقىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ئاندىن پەرۋەردىگار ئەرشتىن بۇلۇت تۈۋرۈكى ئىچىدە چۈشۈپ، جامائەت چېدىرىنىڭ ئالدىدا توختاپ، ھارۇن بىلەن مەريەمنى قىچقىرىۋىدى، ئۇلار ئالدىغا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ئۇ ئۇلارغا: — ئەمدى سىلەر گېپىمنى ئاڭلاڭلار، ئەگەر سىلەرنىڭ ئاراڭلاردا پەيغەمبەر بولسا، مەن پەرۋەردىگار ئالامەت كۆرۈنۈشتە ئۇنىڭغا ئۆزۈمنى ئايان قىلىمەن، چۈشىدە ئۇنىڭ بىلەن سۆزلىشىمەن. ");
INSERT INTO uigara_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","لېكىن قۇلۇم مۇساغا نىسبەتەن ئۇنداق ئەمەس؛ ئۇ بارلىق ئائىلەم ئىچىدە تولىمۇ سادىقتۇر؛ ");
INSERT INTO uigara_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","مەن ئۇنىڭ بىلەن تېپىشماق ئېيتىپ ئولتۇرماي، يۈزمۇ يۈز تۇرۇپ بىۋاسىتە سۆزلىشىمەن؛ ئۇ مەن پەرۋەردىگارنىڭ قىياپىتىنى كۆرەلەيدۇ. ئەمدى سىلەر نېمىشقا قۇلۇم مۇسا توغرۇلۇق يامان گەپ قىلىشتىن قورقمىدىڭلار؟ — دېدى.    ");
INSERT INTO uigara_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","پەرۋەردىگارنىڭ ئوتلۇق غەزىپى ئۇلارغا قوزغالدى ۋە ئۇ كېتىپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","شۇنىڭ بىلەن بۇلۇت جامائەت چېدىرى ئۈستىدىن كەتتى، ۋە مانا، مەريەم خۇددى ئاپئاق قاردەك پېسە-ماخاۋ بولۇپ كەتتى؛ ھارۇن بۇرۇلۇپ مەريەمگە قارىۋىدى، مانا، ئۇ پېسە-ماخاۋ بولۇپ قالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ھارۇن مۇساغا: — ۋاي خوجام! نادانلىق قىلىپ گۇناھ ئۆتكۈزۈپ قويغانلىقىمىز سەۋەبىدىن بۇ گۇناھنى بىزنىڭ ئۈستىمىزگە ئارتمىغايسەن. ");
INSERT INTO uigara_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ئۇ خۇددى ئانىسىنىڭ قورسىقىدىن چىققاندىلا بەدىنى يېرىم چىرىك، ئۆلۈك تۇغۇلغان بالىدەك بولۇپ قالمىغاي! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","شۇنىڭ بىلەن مۇسا پەرۋەردىگارغا: — ئى تەڭرى، ئۇنىڭ كېسىلىنى ساقايتىۋەتكەن بولساڭ، — دەپ نىدا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","پەرۋەردىگار مۇساغا: — ئەگەر ئاتىسى ئۇنىڭ يۈزىگە تۈكۈرگەن بولسا، ئۇ يەتتە كۈن خىجىلچىلىق ئىچىدە تۇرغان بولاتتى ئەمەسمۇ؟ ئەمدى ئۇ بارگاھنىڭ سىرتىغا يەتتە كۈن قاماپ قويۇلسۇن، ئاندىن ئۇ قايتىپ كەلسۇن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","شۇنىڭ بىلەن مەريەم بارگاھ سىرتىغا يەتتە كۈن قاماپ قويۇلدى، تاكى مەريەم قايتىپ كەلگۈچە خەلق يولغا چىقماي تۇرۇپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ئاندىن كېيىن خەلق ھازىروتتىن يولغا چىقىپ، پاران چۆلىدە بارگاھ قۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","مەن ئىسرائ‍ىللارغا مىراس قىلىپ بەرگەن قانائان زېمىنىنى چارلاپ كېلىشكە ئادەملەرنى ئەۋەتكىن؛ ھەربىر ئاتا جەمەتكە تەۋە قەبىلىدىن بىردىن ئادەم چىقىرىلسۇن، ئۇلار ئۆز قەبىلىسىدىكى ئەمىر بولسۇن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","مۇسا پەرۋەردىگارنىڭ ئەمرى بويىچە، ئۇلارنى پاران چۆلىدىن يولغا سالدى؛ ئۇلارنىڭ ھەممىسى ئىسرائ‍ىللارنىڭ باشلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","تۆۋەندىكىلەر ئۇلارنىڭ ئىسىملىرى: — رۇبەن قەبىلىسىدىن زاككۇرنىڭ ئوغلى شاممۇيا، ");
INSERT INTO uigara_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","شىمېئون قەبىلىسىدىن خورىنىڭ ئوغلى شافات، ");
INSERT INTO uigara_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","يەھۇدا قەبىلىسىدىن يەفۇننەھنىڭ ئوغلى كالەب، ");
INSERT INTO uigara_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ئىسساكار قەبىلىسىدىن يۈسۈپنىڭ ئوغلى ئىگال، ");
INSERT INTO uigara_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ئەفرائىم قەبىلىسىدىن نۇننىڭ ئوغلى ھوشىيا، ");
INSERT INTO uigara_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","بىنيامىن قەبىلىسىدىن رافۇنىڭ ئوغلى پالتى، ");
INSERT INTO uigara_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","زەبۇلۇن قەبىلىسىدىن سودىنىڭ ئوغلى گاددىيەل، ");
INSERT INTO uigara_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","يۈسۈپ قەبىلىسىدىن، يەنى ماناسسەھ قەبىلىسىدىن سۇسىنىڭ ئوغلى گاددى، ");
INSERT INTO uigara_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","دان قەبىلىسىدىن گىماللىنىڭ ئوغلى ئاممىيەل، ");
INSERT INTO uigara_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ئاشىر قەبىلىسىدىن مىكائىلنىڭ ئوغلى سەتۇر، ");
INSERT INTO uigara_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","نافتالى قەبىلىسىدىن ۋوفسىنىڭ ئوغلى ناھبى، ");
INSERT INTO uigara_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","گاد قەبىلىسىدىن ماكىنىڭ ئوغلى گېئۇئەل. ");
INSERT INTO uigara_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","مانا بۇلار مۇسا چارلاپ كېلىڭلار دەپ قانائان زېمىنىغا ئەۋەتكەن ئادەملەرنىڭ ئىسمى. مۇسا نۇننىڭ ئوغلى ھوشىيانى يەھوشۇيا دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","مۇسا ئۇلارنى چارلاپ كېلىشكە قانائانغا سەپەرۋەر قىلىپ: — سىلەر مۇشۇ يەردىن نەگەۋ چۆلى تەرەپكە قاراپ مېڭىڭلار، ئاندىن تاغلىق رايونغا چىقىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ئۇ يەرنىڭ قانداق ئىكەنلىكىنى، ئۇ يەردىكىلەرنىڭ كۈچلۈك-ئاجىزلىقىنى، ئاز ياكى كۆپلۈكىنى كۆرۈپ بېقىڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ئۇلار تۇرۇۋاتقان يەرنىڭ قانداق ئىكەنلىكىنى، ياخشى-يامانلىقىنى كۆرۈڭلار؛ ئۇلار تۇرۇۋاتقان شەھەرلەرنىڭ قانداق ئىكەنلىكىنى، بارگاھلىق شەھەر ياكى سېپىل-قەلئەلىك شەھەر ئىكەنلىكىنى؛ ");
INSERT INTO uigara_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ئۇ يەرنىڭ مۇنبەت ياكى مۇنبەتسىز ئىكەنلىكىنى، دەل-دەرەخلىرىنىڭ بار-يوقلۇقىنى كۆرۈپ كېلىڭلار. يۈرەكلىكرەك بولۇپ، مېۋە-چىۋىلىرىدىن ئالغاچ كېلىڭلار، — دېدى. بۇ چاغ دەل ئۈزۈم پىشىپ قالغان ۋاقىت ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ئۇلار شۇ تەرەپلەرگە چىقىپ، زېمىننى زىن چۆلىدىن تارتىپ تاكى ھامات ئېغىزىنىڭ يېنىدىكى رەھوبقىچە بېرىپ چارلاشتى. ");
INSERT INTO uigara_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ئۇلار جەنۇب تەرەپتە ھېبرونغا باردى، ئۇ يەرلەردە ئاناقىيلارنىڭ ئەۋلادلىرىدىن ئاھىمان، شىشاي، تالماي دېگەنلەر ئولتۇرۇشلۇق ئىدى. ئەسلىدە ھېبرون شەھىرى مىسىردىكى زوئان شەھىرىدىن يەتتە يىل ئىلگىرى ياسالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ئۇلار «ئەشكول جىلغىسى»غا كەلدى، ئۇ يەردە بىر ساپ ئۈزۈمى بار بىر ئۈزۈم شېخىنى كېسىپ، بىر بالداققا ئېسىپ ئىككى ئادەمگە كۆتۈرگۈزۈپ ماڭدى؛ ئۇلار ئازراق ئانار بىلەن ئەنجۈرمۇ ئېلىپ قايتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ئىسرائ‍ىللار شۇ يەردە كېسىۋالغان ئەشۇ ئۈزۈم سەۋەبىدىن ئۇ يەر «ئەشكول جىلغىسى» ‹«ئۈزۈم ساپىقى جىلغىسى»› دەپ ئاتالدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ئۇلار قىرىق كۈندىن كېيىن ئۇ يەرلەرنى چارلاپ تۈگىتىپ، قايتىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ئۇلار كېلىپ، پاران چۆللۈكىدىكى قادەشتە مۇسا، ھارۇن ۋە پۈتۈن ئىسرائىل جامائىتى بىلەن كۆرۈشتى. ئۇلار ئىككىيلەنگە ھەم پۈتكۈل ئىسرائىل جامائىتىگە مەلۇمات بەردى ھەم زېمىننىڭ مېۋىلىرىنى ئۇلارغا كۆرسەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ئۇلار مۇساغا مەلۇمات بېرىپ: — بىز ئۆزلىرى بېرىڭلار دېگەن يەرلەرگە باردۇق، راستتىنلا سۈت بىلەن ھەسەل ئېقىپ تۇرىدىغان يەر ئىكەن، مانا بۇلار شۇ يەرنىڭ مېۋىلىرى. ");
INSERT INTO uigara_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","بىراق ئۇ يەردىكىلەر بەك كۈچتۈڭگۈر ئىكەن، شەھەرلەر سېپىللىق بولۇپ ھەم پۇختا-ھەيۋەتلىك ئىكەن. ئۇنىڭ ئۈستىگە، بىز ئۇ يەردە ئاناقىيلارنىڭ ئەۋلادلىرىنىمۇ كۆردۇق. ");
INSERT INTO uigara_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ئامالەكلەر جەنۇب تەرەپتە تۇرىدىكەن؛ ھىتتىيلار، يەبۇسىيلار، ئامورىيلار تاغلاردا تۇرىدىكەن؛ قانائانىيلار دېڭىز بويلىرىدا ۋە ئىئوردان دەرياسى بويلىرىدا تۇرىدىكەن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","كالەب مۇسانىڭ ئالدىدا كۆپچىلىكنى تىنچىتىپ: — بىز دەرھال ئاتلىنىپ بېرىپ ئۇ يەرنى ئىگىلەيلى! چۈنكى بىز چوقۇم غالىپ كېلىمىز — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","لېكىن ئۇنىڭ بىلەن بىللە چىققان باشقىلار بولسا: — ئۇلار بىزدىن كۈچلۈك ئىكەن، شۇڭا ئۇلارغا ھۇجۇم قىلساق بولمايدۇ، — دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ئاندىن چارلىغۇچىلار ئۆزلىرى چارلاپ كەلگەن زېمىننىڭ ئەھۋالىدىن ئىسرائ‍ىللارغا يامان مەلۇمات بېرىپ: — بىز كىرىپ چارلاپ ئۆتكەن زېمىن بولسا ئۆز ئاھالىسىنى يەيدىغان زېمىن ئىكەن؛ بىز ئۇ يەردە كۆرگەنلەرنىڭ ھەممىسى يوغان ئادەملەر ئىكەن. ");
INSERT INTO uigara_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","بىز ئۇ يەرلەردە «نەفىلىيلەر» دېگەن گىگانت ئادەملەرنى كۆردۇق ‹دەرۋەقە ئاناقىيلارنىڭ ئەۋلادلىرى نەفىلىيلەردىن چىققاندۇر›؛ بىز ئۆزىمىزگە قارىساق چېكەتكىدەك تۇرىدىكەنمىز، بىز ئۇلارغىمۇ شۇنداق كۆرىنىدىكەنمىز، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","شۇنىڭ بىلەن بارلىق جامائەت داد-پەرياد كۆتۈرۈپ يىغلىدى؛ ئۇلار كېچىچە يىغا-زار قىلىشىپ چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ئىسرائ‍ىللار مۇسا بىلەن ھارۇنغا تاپا-تەنە قىلىپ: — بىز بالدۇرلا مىسىردا ئۆلۈپ كەتسەك بوپتىكەن! مۇشۇ چۆل-جەزىرىدە ئۆلۈپ كەتسەك بوپتىكەن! ");
INSERT INTO uigara_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","پەرۋەردىگار نېمىشقا بىزنى قىلىچ ئاستىدا ئۆلسۇن، خوتۇن بالا-چاقىلىرىمىز بۇلىنىپ، دۈشمەننىڭ ئولجىسى بولسۇن دەپ بىزنى بۇ يەرگە باشلاپ كەلگەندۇ؟ ئۇنىڭدىن كۆرە، مىسىرغا قايتىپ كەتكىنىمىز ياخشى ئەمەسمۇ؟ — دەپ غوتۇلداشتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","شۇنىڭ بىلەن ئۇلار بىر-بىرىگە: — باشقىدىن بىر باشلىق تىكلەپ مىسىرغا قايتىپ كېتەيلى، — دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","مۇسا بىلەن ھارۇن پۈتۈن ئىسرائىل جامائىتى ئالدىدا يىقىلىپ دۈم ياتتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","شۇ يەرنى چارلاپ كەلگەنلەر ئىچىدىكى نۇننىڭ ئوغلى يەشۇئا بىلەن يەفۇننەھنىڭ ئوغلى كالەب كىيىملىرىنى يىرتىپ، ");
INSERT INTO uigara_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","پۈتۈن ئىسرائىل جامائەتچىلىكىگە: — بىز چارلاپ كېلىشكە ئۆتۈپ بارغان زېمىن ئىنتايىن بەك ياخشى زېمىن ئىكەن. ");
INSERT INTO uigara_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ئەگەر پەرۋەردىگار بىزدىن سۆيۈنسە، بىزنى شۇ زېمىنغا، يەنى ھەسەل بىلەن سۈت ئېقىپ تۇرىدىغان شۇ زېمىنغا باشلاپ بېرىپ، ئۇنى بىزگە بېرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","سىلەر پەقەت پەرۋەردىگارغا ئاسىيلىق قىلماڭلار! ئۇ زېمىنىدىكىلەردىن قورقماڭلار، چۈنكى ئۇلار بىزگە نىسبەتەن بىر غىزادۇر؛ ئۇلارنىڭ پاناھدارلىرى ئۇلاردىن كەتتى، پەرۋەردىگار بولسا بىز بىلەن بىللە؛ ئۇلاردىن قورقماڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ھالبۇكى، پۈتكۈل جامائەت تەرەپ-تەرەپتىن: — ئۇ ئىككىسىنى چالما-كېسەك قىلىپ ئۆلتۈرۈۋېتەيلى، دېيىشتى. لېكىن پەرۋەردىگارنىڭ جۇلاسى جامائەت چېدىرىدا ئىسرائ‍ىللارغا ئايان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","پەرۋەردىگار مۇساغا: — بۇ خەلق مېنى قاچانغىچە مەنسىتمەيدۇ؟ گەرچە ئۇلارنىڭ ئوتتۇرىسىدا شۇنچە مۆجىزىلىك ئالامەتلەرنى ياراتقان بولساممۇ، لېكىن ئۇلار ماڭا قاچانغىچە ئىشىنىشمەيدىكەن؟ ");
INSERT INTO uigara_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","مەن ئۇلارنى ۋابا بىلەن ئۇرۇپ يوقىتىمەن، شۇنىڭ بىلەن سېنى ئۇلاردىن تېخىمۇ چوڭ ۋە قۇدرەتلىك بىر ئەل قىلىمەن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","مۇسا بولسا پەرۋەردىگارغا مۇنداق دېدى: — «بۇنداق بولىدىغان بولسا بۇ ئىشنى مىسىرلىقلار ئاڭلاپ قالىدۇ، چۈنكى سەن ئۇلۇغ قۇدرىتىڭ بىلەن بۇ خەلقنى ئۇلارنىڭ ئارىسىدىن ئېلىپ چىققانىدىڭ؛ ");
INSERT INTO uigara_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ۋە مىسىرلىقلار بۇ ئىشنى شۇ زېمىندىكى خەلقلەرگىمۇ ئېيتىدۇ. ئۇ زېمىندىكى ئاھالىمۇ سەن پەرۋەردىگارنىڭ بۇ خەلقنىڭ ئارىسىدا ئىكەنلىكىڭنى، سەن پەرۋەردىگارنىڭ ئۇلارنىڭ ئالدىدا يۈزمۇيۈز كۆرۈنگەنلىكىڭنى، سېنىڭ بۇلۇتىڭ دائىم ئۇلارغا سايە چۈشۈرۈپ كەلگەنلىكىنى، شۇنداقلا سېنىڭ كۈندۈزى بۇلۇت تۈۋرۈكىدە، كېچىسى ئوت تۈۋرۈكىدە ئۇلارنىڭ ئالدىدا ماڭغانلىقىڭنى ئاڭلىغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ئەمدى سەن بۇ خەلقنى خۇددى بىر ئادەمنى ئۆلتۈرگەندەك ئۆلتۈرۈۋەتسەڭ، سېنىڭ نام-شۆھرىتىڭنى ئاڭلىغان ئەللەرنىڭ ھەممىسى: ");
INSERT INTO uigara_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","«پەرۋەردىگار بۇ خەلقنى ئۆزى ئۇلارغا بېرىشكە قەسەم قىلغان زېمىنغا باشلاپ بارالمايدىغانلىقى ئۈچۈن، شۇڭا ئۇلارنى ئەشۇ چۆل-جەزىرىدە ئۆلتۈرۈۋېتىپتۇ» دەپ قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ئەمدى ئۆتۈنىمەنكى، رەببىم قۇدرىتىڭنى جارى قىلدۇرغايسەن، ئۆزۈڭنىڭ: ");
INSERT INTO uigara_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","«پەرۋەردىگار ئاسانلىقچە ئاچچىقلانمايدۇ، ئۇنىڭ مېھىر-مۇھەببىتى تېشىپ تۇرىدۇ؛ ئۇ گۇناھ ۋە ئىتائەتسىزلىكنى كەچۈرىدۇ، لېكىن گۇناھكارلارنى ھەرگىز گۇناھسىز دەپ قارىمايدۇ، ئاتىلارنىڭ قەبىھلىكىنى ئاتىسىدىن بالىسىغىچە، ھەتتا نەرۋە-چەۋرىلىرىگىچە ئۇلارنىڭ ئۈستىگە يۈكلەيدۇ» دېگىنىڭدەك قىلغايسەن.    ");
INSERT INTO uigara_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","مېھىر-شەپقىتىڭنىڭ كەڭرىلىكى بويىچە، مىسىردىكى چاغدىن تاكى ھازىرغىچە دائىم كەچۈرۈپ كەلگىنىڭدەك، بۇ خەلقنىڭ قەبىھلىكىنى كەچۈرگەيسەن!». ");
INSERT INTO uigara_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","پەرۋەردىگار: — «بوپتۇ، سەن دېگەندەك ئۇلارنى كەچۈردۈم. ");
INSERT INTO uigara_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","لېكىن ئۆز ھاياتىم بىلەن قەسەم قىلىمەنكى، پۈتكۈل يەر يۈزى مەن پەرۋەردىگارنىڭ شان-شەرىپى بىلەن تولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ھالبۇكى، مېنىڭ جۇلايىمنى، مىسىردا ۋە چۆل-جەزىرىدە كۆرسەتكەن مۆجىزىلىك ئالامەتلىرىمنى كۆرۈپ تۇرۇپمۇ مېنى مۇشۇنداق ئون قېتىملاپ سىناپ يەنە ئاۋازىمغا قۇلاق سالمىغانلار، ");
INSERT INTO uigara_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","مەن قەسەم ئىچىپ ئۇلارنىڭ ئاتا-بوۋىلىرىغا مىراس قىلىپ بېرىمەن دېگەن ئۇ زېمىننى ھەرگىز كۆرەلمەيدۇ؛ مېنى مەنسىتمىگەنلەردىن بىرىمۇ ئۇ يۇرتنى كۆرەلمەيدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","لېكىن ئۆزىدە باشقىچە بىر روھنىڭ بولغىنى، پۈتۈن قەلبى بىلەن ماڭا ئەگەشكىنى ئۈچۈن قۇلۇم كالەبنى ئۇ كىرگەن يەرگە باشلاپ كىرىمەن؛ ئۇنىڭ ئەۋلادلىرىمۇ ئۇ يەرگە مىراسخور بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","‹شۇ چاغدا ئامالەكلەر بىلەن قانائانىيلار تاغلىق جىلغىلاردا تۇرۇۋاتاتتى› — ئەتە سىلەر يولۇڭلاردىن بۇرۇلۇپ، قىزىل دېڭىزغا بارىدىغان يول بىلەن مېڭىپ چۆلگە سەپەر قىلىڭلار» — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: ");
INSERT INTO uigara_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","— مەن مېنىڭ يامان گېپىمنى قىلىپ غوتۇلدىشىدىغان بۇ رەزىل جامائەتكە قاچانغىچە چىدىشىم كېرەك؟ ئىسرائ‍ىللارنىڭ مېنىڭ يامان گېپىمنى قىلغانلىرى، شۇ توختاۋسىز غوتۇلداشلىرىنىڭ ھەممىسىنى ئاڭلىدىم. ");
INSERT INTO uigara_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","سەن ئۇلارغا: — پەرۋەردىگار مۇنداق دەيدۇ: «مەن ھاياتىم بىلەن قەسەم قىلىمەنكى، خەپ، مەن سىلەرگە قۇلىقىمغا كىرگەن سۆزلىرىڭلار بويىچە مۇئامىلە قىلمايدىغان بولسام! ");
INSERT INTO uigara_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","سىلەرنىڭ ئۆلۈكۈڭلار مۇشۇ چۆلدە ياتىدۇ؛ سىلەرنىڭ ئىچىڭلاردا ساناقتىن ئۆتكۈزۈلگەنلەر، يەنى يېشى يىگىرمىدىن ئاشقان، مېنىڭ يامان گېپىمنى قىلىپ غوتۇلدىغانلارنىڭ ھەممىسى پۈتۈن سانى بويىچە ");
INSERT INTO uigara_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","سىلەرگە قول كۆتۈرۈپ قەسەم قىلىپ، تۇرالغۇڭلار قىلىپ بېرىمەن دېگەن زېمىنغا ھېچ كىرەلمەيدۇ؛ پەقەت يەفۇنمەهنىڭ ئوغلى كالەب بىلەن نۇننىڭ ئوغلى يەشۇئالا كىرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","سىلەرنىڭ كىچىك بالىلىرىڭلار، يەنى «بۇلىنىپ، دۈشمەننىڭ ئولجىسى بولۇپ قالىدۇ» دېيىلگەنلەرنى مەن باشلاپ كىرىمەن، ئۇلار سىلەر كەمسىتكەن ئۇ زېمىندىن بەھرىمەن بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","بىراق سىلەر بولساڭلار، سىلەر يىقىلىپ، ئۆلۈكۈڭلار بۇ چۆلدە قالىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","سىلەرنىڭ بالىلىرىڭلار بۇزۇقلۇق-ۋاپاسىزلىقىڭلارنىڭ ئەلىمىنى تارتىپ، ئۆلۈكۈڭلار چۆلدە يوقالغۇچە، بۇ چۆلدە قىرىق يىل سەرگەردان بولۇپ يۈرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","سىلەرنىڭ شۇ زېمىننى چارلىغان كۈنلىرىڭلارنىڭ سانى بويىچە، قىرىق كۈننىڭ ھەربىر كۈنىنى بىر يىل ھېسابلاپ، قەبىھلىكلىرىڭلارنى قىرىق يىل ئۆز ئۈستۈڭلارغا ئېلىپ يۈرىسىلەر؛ شۇ چاغدا مېنىڭ ئۆزۈڭلاردىن ياتلاشقىنىمنىڭ نېمە ئىكەنلىكىنى بىلىپ يېتىسىلەر» — دېگىن. ");
INSERT INTO uigara_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","مەن پەرۋەردىگار شۇنداق دېگەنىكەنمەن، يىغىلىپ ماڭا قارشى چىققان بۇ رەزىل خەلق جامائىتىگە مەن چوقۇم شۇنداق قىلىمەن؛ ئۇلار مۇشۇ چۆل-جەزىرىدە يەۋېتىلىدۇ، شۇ يەردە ئۆلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","مۇسا ئۇ زېمىننى چارلاپ كېلىشكە ئەۋەتكەنلەر قايتىپ كەلگەندە، ئۇ زېمىن توغرۇلۇق يامان خەۋەر ئېلىپ كېلىش بىلەن پۈتۈن جامائەتنى غوتۇلدىتىپ، مۇسانىڭ يامان گېپىنى قىلغۇزغانلار، ");
INSERT INTO uigara_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","يەنى ئۇ زېمىن توغرۇلۇق يامان خەۋەر ئەكەلگەن بۇ كىشىلەرنىڭ ھەممىسى ۋابا كېسىلى تېگىپ پەرۋەردىگارنىڭ ئالدىدا ئۆلدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","زېمىننى چارلاپ كېلىشكە بارغان ئادەملەر ئىچىدىن پەقەت نۇننىڭ ئوغلى يەشۇئا بىلەن يەفۇننەھنىڭ ئوغلى كالەبلا ھايات قالدى. ");
INSERT INTO uigara_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","مۇسا بۇ گەپلەرنى پۈتكۈل ئىسرائىل جامائىتىگە ئېيتىۋىدى، ھەممىسى بەك ھەسرەت چەكتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ئۇلار ئەتىگەن تاڭ ئاتقاندا تۇرۇپ تاغقا چىقىپ: — مانا بىز كەلدۇق! پەرۋەردىگار ئېيتقان يۇرتقا چىقىپ ھۇجۇم قىلايلى؛ چۈنكى بىز گۇناھ قىلدۇق، — دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","— سىلەر يەنە نېمىشقا پەرۋەردىگارنىڭ ئەمرىگە خىلاپلىق قىلىسىلەر؟ — دېدى مۇسا، — بۇ ئىش غەلىبىلىك بولمايدۇ! ");
INSERT INTO uigara_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","پەرۋەردىگار ئاراڭلاردا بولمىغاچقا، دۈشمەننىڭ قىلىچى ئاستىدا ئۆلۈپ، مەغلۇپ بولماسلىقىڭلار ئۈچۈن ھۇجۇمغا چىقماڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","چۈنكى ئامالەكلەر بىلەن قانائانىيلار ئۇ يۇرتتا، سىلەرنىڭ ئالدىڭلاردا تۇرىدۇ؛ سىلەر قىلىچ ئاستىدا ئۆلۈپ كېتىسىلەر؛ چۈنكى سىلەر پەرۋەردىگاردىن تېنىپ كەتتىڭلار، پەرۋەردىگار سىلەر بىلەن بىللە بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","لېكىن، گەرچە پەرۋەردىگارنىڭ ئەھدە ساندۇقى ۋە مۇسا بارگاھتىن قوزغالمىغان بولسىمۇ، ئۇلار يەنىلا ئۆز مەيلىچە تاغقا چىقىپ ھۇجۇمغا ئۆتتى. ");
INSERT INTO uigara_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","شۇنىڭ بىلەن ئامالەكلەر بىلەن شۇ تاغدا تۇرۇشلۇق قانائانىيلار چۈشۈپ ئۇلارنى تاكى خورماھغىچە قوغلاپ، بىتچىت قىلىپ قىرغىن قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","سەن ئىسرائ‍ىللارغا مۇنداق دېگىن: — سىلەر ماكانلىشىشىڭلار ئۈچۈن سىلەرگە تەقدىم قىلىپ بېرىدىغان زېمىنغا كىرگەن چېغىڭلاردا، ");
INSERT INTO uigara_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ئەگەر پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان، ئۇنىڭغا خۇشبۇي بولسۇن دەپ بىرەر ھەدىيە-قۇربانلىق قىلماقچى بولساڭلار، قۇربانلىق كالا ياكى قوي-ئۆچكە پادىسىدىن بولسۇن. ئۇ كۆيدۈرمە قۇربانلىق بولسۇن، قەسەمنى ئادا قىلىش قۇربانلىقى بولسۇن، ئىختىيارىي قۇربانلىق ياكى سىلەرگە بېكىتىلگەن ھېيتلاردىكى زۆرۈر قۇربانلىق بولسۇن، ");
INSERT INTO uigara_vpl VALUES ("NU15_4‏","005_15_4‏","NUM","15","4‏","5","قۇربانلىق سۇنغۇچى كىشى پەرۋەردىگارغا ئاتىغىنىغا بىر ئاشلىق ھەدىيەسىنى قوشۇپ كەلتۈرسۇن. كۆيدۈرمە قۇربانلىق ياكى باشقا قۇربانلىق قوزا بولسا، ئۇنداقتا ئاشلىق ھەدىيەسى زەيتۇن مېيىدىن بىر ھىننىڭ تۆتتىن بىرى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن ئەفاھنىڭ ئوندىن بىرى بولسۇن؛ ئۇنىڭغا يەنە شاراب ھەدىيەسى سۈپىتىدە تۆتتىن بىر ھىن شارابنى قوشۇپ سۇنسۇن.    ");
INSERT INTO uigara_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","قۇربانلىقىڭ قوچقار بولسا، سەن ئۇنىڭغا ئاشلىق ھەدىيەسى سۈپىتىدە ئۈچتىن بىر ھىن زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن ئەفاھنىڭ ئوندىن ئىككىسى بولسۇن ");
INSERT INTO uigara_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ۋە شاراب ھەدىيەسى سۈپىتىدە ئۈچتىن بىر ھىن شارابنى قوشۇپ سۇنسۇن؛ بۇلار پەرۋەردىگارغا خۇشبۇي چىقارسۇن دەپ سۇنۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ئەگەر سەن پەرۋەردىگارغا كۆيدۈرمە قۇربانلىق، ياكى قەسەم ئادا قىلىش قۇربانلىقى ياكى ئىناقلىق قۇربانلىقى سۈپىتىدە تورپاق ئاتىغان بولساڭ، ");
INSERT INTO uigara_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ئۇنداقتا تورپاققا ئاشلىق ھەدىيەسى سۈپىتىدە يېرىم ھىن زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن ئەفاھنىڭ ئوندىن ئۈچىنى، ");
INSERT INTO uigara_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","شاراب ھەدىيەسى سۈپىتىدە يېرىم ھىن شارابنى قوشۇپ سۇنغىن؛ بۇلار پەرۋەردىگارغا ئاتىلىپ ئوتتا سۇنۇلۇپ، خۇشبۇي چىقارسۇن دەپ كەلتۈرۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ھەربىر سۇنۇلغان تورپاق، قوچقار، قوزا ياكى ئوغلاققا نىسبەتەن مۇشۇنداق قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","سىلەر سۇنىدىغىنىڭلارنىڭ سانى بويىچە، ھەرخىل قۇربانلىقنىڭ سانىغا قاراپ شۇنداق قىلىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","شۇ زېمىندا تۇغۇلغانلارنىڭ ھەممىسى پەرۋەردىگارغا خۇشبۇي چىقارسۇن دەپ، ئوتتا سۇنۇلىدىغان قۇربانلىق قىلماقچى بولسا ئەنە شۇنداق قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","شۇنىڭدەك سىلەر بىلەن بىللە تۇرۇۋاتقان مۇساپىر ياكى ئەۋلادمۇ-ئەۋلاد سىلەر بىلەن بىللە تۇرۇۋاتقانلار بولسا، خۇشبۇي چىقارسۇن دەپ ئوتتا سۇنۇلىدىغان قۇربانلىق قىلماقچى بولسا، سىلەر قانداق قىلغان بولساڭلار، ئۇلارمۇ شۇنداق قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","پۈتكۈل جامائەتكە، مەيلى سىلەر بولۇڭلار ياكى سىلەر بىلەن بىللە تۇرۇۋاتقان مۇساپىر بولسۇن، ھەممىڭلار ئۈچۈن ئوخشاش بىر بەلگىلىمە بولىدۇ؛ سىلەر ئۈچۈن دەۋرمۇ-دەۋر ئەبەدىي بىر بەلگىلىمە بولىدۇ؛ پەرۋەردىگار ئالدىدا سىلەر قانداق بولساڭلار، مۇساپىرلارمۇ شۇنداقتۇر. ");
INSERT INTO uigara_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","سىلەرگىمۇ، ئاراڭلاردا تۇرۇۋاتقان مۇساپىرلارغىمۇ ئوخشاش بىر قانۇن-بەلگىلىمە، ئوخشاش بىر ھۆكۈم بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","سەن ئىسرائ‍ىللارغا سۆز قىلىپ ئۇلارغا مۇنداق دېگىن: — «سىلەر مەن سىلەرنى ئەكىرىدىغان زېمىنغا يېتىپ بارغاندا، ");
INSERT INTO uigara_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","شۇ يەردىن چىققان ئاشلىقنى يەيدىغان چېغىڭلاردا، پەرۋەردىگارغا بىر «كۆتۈرمە ھەدىيە» تەقدىم قىلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","سىلەر ھەربىر يېڭى خېمىردىن پىشقان نانلاردىن بىرىنى «كۆتۈرمە ھەدىيە» قىلىپ تەقدىم قىلىڭلار؛ سىلەر ئۇنى تەقدىم قىلغاندا خۇددى خاماننىڭ «كۆتۈرمە ھەدىيە»سىگە ئوخشاش بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","دەۋردىن-دەۋرگە سىلەر دەسلەپكى ھوسۇلدىن چىققان خېمىردىن بىر ناننى «كۆتۈرمە ھەدىيە» سۈپىتىدە پەرۋەردىگارغا سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ئەگەر سىلەر ئۆزۈڭلار بىلمەي ئېزىپ گۇناھ قىلىپ، پەرۋەردىگارنىڭ مۇساغا بۇيرۇغان بۇ بارلىق ئەمىرلىرىگە ئەمەل قىلمىغان بولساڭلار، ");
INSERT INTO uigara_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","يەنى پەرۋەردىگار بۇيرۇغان كۈندىن ئېتىبارەن بارلىق ئەۋلادلىرىڭلارغىچە پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن سىلەرگە بۇيرۇغان بارلىق ئىشلىرىغا ئەمەل قىلمىغان بولساڭلار، ");
INSERT INTO uigara_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","جامائەت شۇنداق بىرەر گۇناھنىڭ بىلمەي ئۆتكۈزۈلگەنلىكىدىن خەۋەرسىز بولسا، ئۇنداقتا پۈتكۈل جامائەت پەرۋەردىگارغا خۇشبۇي چىقارسۇن دەپ ياش بىر تورپاقنى كۆيدۈرمە قۇربانلىق سۈپىتىدە سۇنسۇن ھەمدە قائىدە-نىزام بويىچە ئۇنىڭغا مۇناسىۋەتلىك ئاشلىق ھەدىيەسى بىلەن شاراب ھەدىيەسىنى قوشۇپ سۇنسۇن، ۋە ئۇنىڭ ئۈستىگە بىر تېكىنى گۇناھ قۇربانلىقى سۈپىتىدە سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","شۇ يول بىلەن كاھىن پۈتكۈل ئىسرائىل جامائىتى ئۈچۈن كەفارەت كەلتۈرۈپ، بۇ گۇناھ ئۇلاردىن كەچۈرۈم قىلىنىدۇ؛ چۈنكى بۇ بىلمەي ئۆتكۈزۈپ قويغان گۇناھ ۋە ئۇلار ئۆزلىرىنىڭ بىلمەي ئۆتكۈزۈپ قويغان گۇناھى ئۈچۈن قۇربانلىق، يەنى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان قۇربانلىق ۋە گۇناھ قۇربانلىقىنى بىرلىكتە پەرۋەردىگار ئالدىغا سۇنغان. ");
INSERT INTO uigara_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","بۇ گۇناھ پۈتكۈل ئىسرائىل جامائىتى بىلەن ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان مۇساپىرلارنىڭ ھەممىسىدىن كەچۈرۈم قىلىنىدۇ، چۈنكى بۇ پۈتكۈل خەلق بىلمەي تۇرۇپ ئۆتكۈزۈپ قويغان گۇناھتۇر. ");
INSERT INTO uigara_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ئەگەر بىر كىشى بىلمەستىن گۇناھ قىلىپ قويغان بولسا، ئۇ بىر ياشلىق بىر چىشى ئوغلاقنى گۇناھ قۇربانلىقى سۈپىتىدە سۇنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","كاھىن شۇ يول بىلەن بىلمەي گۇناھ قىلىپ قويغان ئادەم ئۈچۈن كەفارەت كەلتۈرىدۇ؛ ئۇنىڭ ئۈچۈن كەفارەت كەلتۈرسە ئۇنىڭ پەرۋەردىگار ئالدىدا بىلمەي ئۆتكۈزگەن گۇناھى ئۇنىڭدىن كەچۈرۈم قىلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","بىلمەي بىرەر سەۋەنلىك ئۆتكۈزۈپ قويغان بارلىق كىشىلەرگە، مەيلى شۇ زېمىندا تۇغۇلغان ئىسرائ‍ىللار بولسۇن ياكى ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان مۇساپىرلارغا بولسۇن، — سىلەرنىڭ ھەممىڭلارغا ئوخشاش بىر قانۇن-بەلگىلىمە تەتبىقلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","لېكىن يۈرىكىنى قاپتەك قىلىپ ئىش كۆرگەن كىشى، مەيلى ئۇ زېمىندا تۇغۇلغان بولسۇن ياكى مۇساپىر بولسۇن، پەرۋەردىگارغا ھاقارەت كەلتۈرگەن بولىدۇ؛ ئۇ ھامان ئۆز خەلقىدىن ئۈزۈپ تاشلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ئۇ پەرۋەردىگارنىڭ سۆزىنى مەنسىتمىگەنىكەن، پەرۋەردىگارنىڭ ئەمرىگە خىلاپلىق قىلغانىكەن؛ شۇنىڭ ئۈچۈن ئۇ چوقۇم ئۈزۈپ تاشلىنىدۇ؛ گۇناھى ئۆزىنىڭ بېشىغا چۈشىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ئىسرائ‍ىللار چۆل-جەزىرىدىكى ۋاقىتلىرىدا، بىر كىشىنىڭ شابات كۈنىدە ئوتۇن تەرگەنلىكى بايقالدى. ");
INSERT INTO uigara_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ئوتۇن تېرىۋاتقانلىقىنى بايقاپ قالغانلار ئۇنى مۇسا، ھارۇن ۋە پۈتكۈل جامائەتنىڭ ئالدىغا ئېلىپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ئۇنى قانداق بىر تەرەپ قىلىش كېرەكلىكى تېخى كۆرسىتىلمىگەچكە، ئۇلار ئۇنى قاماپ قويدى. ");
INSERT INTO uigara_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","پەرۋەردىگار مۇساغا: — ئۇ ئادەم ئۆلتۈرۈلمىسە بولمايدۇ؛ پۈتۈن جامائەت ئۇنى بارگاھنىڭ تېشىغا ئەپچىقىپ چالما-كېسەك قىلىپ ئۆلتۈرسۇن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ئاندىن پۈتۈن جامائەت ئۇ ئادەمنى بارگاھ سىرتىغا ئەپچىقىپ، خۇددى پەرۋەردىگار مۇساغا بۇيرۇغاندەك، چالما-كېسەك قىلىپ ئۆلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","سەن ئىسرائ‍ىللارغا مۇنداق دېگىن، ئۇلار ئەۋلادمۇ-ئەۋلاد كىيىم-كېچەكلىرىنىڭ چۆرىسىگە چۇچىلارنى تۇتسۇن ھەم بۇرجىكىدىكى چۇچىلىرىنىڭ ھەربىرىگە كۆك شوينا تىكىپ قويسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","بۇ خىل چۇچىلار سىلەرنىڭ ئۇنى تىكىپ تۇرۇشۇڭلار ئۈچۈن بولىدۇ؛ ئۇنى كۆرگەندە پەرۋەردىگارنىڭ بارلىق ئەمرلىرىنى ئېسىڭلاردا تۇتۇپ، ئۇلارغا ئەمەل قىلىشىڭلار ئۈچۈن بۇ سىلەرگە بىر ئەسلەتمە بولىدۇ؛ شۇنىڭدەك سىلەرنىڭ ھازىرقىدەك ئۆزۈڭلارنىڭ كۆڭلۈڭلار ۋە كۆزۈڭلارنىڭ كەينىگە كىرىپ، قاتىراپ بۇزۇقلۇق قىلىپ كەتمەسلىكىڭلار، ");
INSERT INTO uigara_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","مېنىڭ بارلىق ئەمرلىرىمنى ئەستە تۇتۇشۇڭلار ھەم ئۇنىڭغا ئەمەل قىلىپ، خۇدايىڭلارغا ئاتاپ پاك-مۇقەددەس بولۇشۇڭلار ئۈچۈن بولسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","مەن خۇدايىڭلار بولۇش ئۈچۈن سىلەرنى مىسىر زېمىنىدىن ئېلىپ چىققان پەرۋەردىگاردۇرمەن؛ مەن پەرۋەردىگار خۇدايىڭلاردۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","لاۋىينىڭ ئەۋرىسى، كوھاتنىڭ نەۋرىسى، ئىزھارنىڭ ئوغلى كوراھ ۋە رۇبەننىڭ ئەۋلادلىرىدىن ئېلىئابنىڭ ئوغۇللىرى داتان بىلەن ئابىرام ۋە پەلەتنىڭ ئوغلى ئون ");
INSERT INTO uigara_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ئىسرائ‍ىللار ئىچىدىكى جامائەت ئەمىرلىرى بولغان، جامائەت ئىچىدىن سايلاپ چىقىلغان مۆتىۋەرلەردىن ئىككى يۈز ئەللىك كىشىنى باشلاپ كېلىپ مۇساغا قارشى چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ئۇلار يىغىلىپ مۇساغا قارشى ھەم ھارۇنغا قارشى چىقىپ: — سىلەر ھەددىڭلاردىن بەك ئاشتىڭلار، پۈتكۈل جامائەتنىڭ ھەممىسى پاك-مۇقەددەس، پەرۋەردىگارمۇ ئۇلارنىڭ ئارىسىدا، شۇنداق تۇرۇغلۇق سىلەر نېمە دەپ ئۆزۈڭلەرنى پەرۋەردىگارنىڭ جامائىتىدىن ئۈستۈن قويۇسىلەر؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_4‏","005_16_4‏","NUM","16","4‏","5","مۇسا ئۇلارنىڭ گېپىنى ئاڭلاپ دۈم يىقىلىپ، كوراھ بىلەن ئۇنىڭ گۇرۇھىدىكىلەرگە سۆز قىلىپ: — ئەتە ئەتىگەندە پەرۋەردىگار كىملەرنىڭ ئۆزىگە مەنسۇپ ئىكەنلىكىنى، كىملەرنىڭ پاك-مۇقەددەس ئىكەنلىكىنى ئايان قىلىدۇ؛ شۇ كىشىنى ئۆزىگە يېقىنلاشتۇرىدۇ؛ كىمنى تاللىغان بولسا، ئۇنى ئۆزىگە يېقىنلاشتۇرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","سىلەر مۇنداق قىلىڭلار: — سەن كوراھ ۋە سېنىڭ گۇرۇھىڭدىكىلەر ھەممىسى خۇشبۇيدانلارنى ئەپكېلىڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ئەتە پەرۋەردىگارنىڭ ئالدىدا خۇشبۇيدانلارغا ئوت يېقىپ، خۇشبۇينى ئۇنىڭ ئۈستىگە قويۇڭلار؛ پەرۋەردىگار كىمنى تاللىسا، شۇ مۇقەددەس-پاك بولغان بولسۇن! ئەي سىلەر لاۋىيلار، ھەددىڭلاردىن بەك ئاشتىڭلار! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","مۇسا يەنە كوراھقا: — ئى لاۋىيلار، گېپىمگە قۇلاق سېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU16_9‏","005_16_9‏","NUM","16","9‏","10","ئىسرائىلنىڭ خۇداسى پەرۋەردىگار سىلەرنى ئۆزىنىڭ چېدىرىنىڭ ئىشلىرىنى قىلسۇن دەپ ھەمدە جامائەتنىڭ ئالدىدا ئۇلارنىڭ خىزمىتىدە بولسۇن دەپ ئۆزىگە يېقىنلاشتۇرۇش ئۈچۈن سىلەرنى ئىسرائىل جامائىتىدىن ئايرىپ چىققان — يەنى پەرۋەردىگار سېنى ۋە سېنىڭ ھەممە قېرىنداشلىرىڭ بولغان لاۋىينىڭ ئەۋلادلىرىنى بىردەك ئۆزىگە يېقىنلاشتۇرغانلىقى سىلەرچە كىچىك ئىشمۇ؟ سىلەر يەنە تېخى كاھىنلىق ۋەزىپىسىنى تاما قىلىۋاتامسىلەر؟ ");
INSERT INTO uigara_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","شۇ ۋەجىدىن سەن ۋە سېنىڭ گۇرۇھىڭدىكىلەر ھەممىسى يىغىلىپ پەرۋەردىگارغا قارشى چىقىۋېتىپسىلەر-دە؛ ھارۇن نېمىدى، سىلەر ئۇنىڭ ئۈستىدىن شۇنچىلىك ئاغرىنىپ غوتۇلدىشىپ كەتكۈدەك؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","مۇسا ئېلىئابنىڭ ئوغلى داتان بىلەن ئابىرامنى قىچقىرىپ كېلىشكە ئادەم ئەۋەتىۋىدى، ئۇلار: — بارمايمىز! ");
INSERT INTO uigara_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","سېنىڭ بىزنى سۈت بىلەن ھەسەل ئاقىدىغان زېمىندىن باشلاپ چىقىپ بۇ چۆل-جەزىرىدە ئۆلتەرمەكچى بولغانلىقىڭنىڭ ئۆزى كىچىك ئىشمۇ؟ سەن تېخى ئۆزۈڭنى پادىشاھ ھېسابلاپ بىزنىڭ ئۈستىمىزدىن ھۆكۈمرانلىق قىلماقچىمۇ؟ ");
INSERT INTO uigara_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ھالبۇكى، سەن بىزنى سۈت بىلەن ھەسەل ئاقىدىغان يۇرتقا باشلاپ كەلمىدىڭ، ئېتىز ۋە ئۈزۈمزارلىقلارنىمۇ بىزگە مىراس قىلىپ بەرمىدىڭ. سەن بۇ خەقنىڭ كۆزىنىمۇ ئويۇۋالماقچىمۇ؟ بىز بارمايمىز! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","بۇنى ئاڭلاپ مۇسا قاتتىق غەزەپلىنىپ پەرۋەردىگارغا: — ئۇلارنىڭ سوۋغات-ھەدىيەسىگە ئېتىبار قىلمىغايسەن؛ مەن ئۇلارنىڭ ھەتتا بىرەر ئېشىكىنىمۇ تارتىۋالمىدىم، بىرەر ئادىمىگىمۇ ھېچ زىيان-زەخمەت يەتكۈزمىدىم، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","مۇسا كوراھقا: — ئەتە سەن ۋە سېنىڭ گۇرۇھىڭدىكىلەر — سەن، ئۇلار ۋە ھارۇن پەرۋەردىگارنىڭ ئالدىغا كېلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ھەربىرىڭلار ئۆزۈڭلارنىڭ خۇشبۇيدانلىرىڭلارنى ئەكىلىپ ئۇنىڭ ئۈستىگە خۇشبۇينى سېلىڭلار؛ ھەربىرىڭلار ئۆزۈڭلارنىڭ خۇشبۇيدانلىرىڭلارنى، يەنى جەمئىي ئىككى يۈز ئەللىك خۇشبۇيداننى ئېلىپ ئۇنى پەرۋەردىگارنىڭ ھۇزۇرىدا تۇتۇپ تۇرۇڭلار؛ سەنمۇ، ھارۇنمۇ ھەربىرىڭلار ئۆز خۇشبۇيدانلىرىڭلارنى ئېلىپ كېلىڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","شۇنىڭ بىلەن ھەربىر ئادەم ئۆزىنىڭ خۇشبۇيدانىنى ئېلىپ، ئوتنى يېقىپ، خۇشبۇي سېلىپ، مۇسا ۋە ھارۇن بىلەن بىرلىكتە جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىدا تۇرۇشتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","كوراھ مۇسا بىلەن ھارۇنغا ھۇجۇم قىلغىلى پۈتۈن جامائەتنى يىغىپ جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىغا كېلىۋىدى، پەرۋەردىگارنىڭ جۇلاسى پۈتكۈل جامائەتكە ئايان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","سىلەر بۇ خەلقنىڭ ئارىسىدىن نېرى تۇرۇڭلار، مەن كۆز يۇمۇپ ئاچقۇچە ئۇلارنى يۇتۇۋېتىمەن، — دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","مۇسا بىلەن ھارۇن دۈم يىقىلىپ: — ئى تەڭرىم، بارلىق ئەت ئىگىلىرىنىڭ روھلىرىنىڭ خۇداسى، بىر ئادەم گۇناھ قىلسا، غەزىپىڭنى پۈتۈن جامائەتكە چاچامسەن؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","سەن جامائەتكە: «سىلەر كوراھ، داتان ۋە ئابىرامنىڭ تۇرار جايلىرىدىن ئايرىلىپ ئۇلاردىن نېرى كېتىڭلار» — دەپ بۇيرۇق بەر، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","شۇنىڭ بىلەن مۇسا ئورنىدىن تۇرۇپ داتان بىلەن ئابىرام تەرەپكە قاراپ ماڭدى؛ ئىسرائىل ئاقساقاللىرىمۇ ئۇنىڭغا ئەگىشىپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","مۇسا جامائەتكە: — سىلەردىن ئۆتۈنىمەن، بۇ رەزىل ئادەملەرنىڭ چېدىرلىرىدىن يىراق كېتىڭلار، ئۇلارنىڭ بارلىق گۇناھلىرى سەۋەبىدىن ئۇلار بىلەن بىللە ۋەيران بولماسلىقىڭلار ئۈچۈن ئۇلارنىڭ ھېچنەرسىسىگە قول تەگكۈزمەڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","شۇنىڭ بىلەن جامائەت كوراھ، داتان، ئابىرامنىڭ چېدىرلىرىنىڭ تۆت ئەتراپىدىن نېرى كەتتى؛ داتان بىلەن ئابىرام بولسا ئۆز ئاياللىرىنى، ئوغۇل-قىزلىرىنى ۋە بوۋاقلىرىنى ئېلىپ چىقىپ ئۆز چېدىرىنىڭ ئىشىكى ئالدىدا تۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","مۇسا: — بۇنىڭدىن سىلەر شۇنى بىلىسىلەركى، بۇ ئىشلارنىڭ ھەممىسى مېنىڭ كۆڭلۈمدىن چىققان ئەمەس، بەلكى پەرۋەردىگار مېنى ئۇلارنى ئادا قىلىشقا ئەۋەتكەن: ");
INSERT INTO uigara_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","— ئەگەر بۇ ئادەملەرنىڭ ئۆلۈمى ئادەتتىكى ئادەملەرنىڭ ئۆلۈمىگە ئوخشاش بولىدىغان ياكى ئۇلارنىڭ بېشىغا چۈشىدىغان قىسمەتلەر ئادەتتىكى ئادەملەر دۇچار بولىدىغان قىسمەتلەرگە ئوخشاش بولىدىغان بولسا، پەرۋەردىگار مېنى ئەۋەتمىگەن بولاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ئەگەر پەرۋەردىگار يېڭى بىر ئىشنى قىلىپ، يەر ئاغزىنى ئېچىپ ئۇلارنى ۋە ئۇلارنىڭ پۈتۈن نەرسىسىنى يۇتۇپ كېتىشى بىلەن، ئۇلار تىرىكلا تەھتىساراغا چۈشۈپ كەتسە، ئۇ چاغدا سىلەر بۇ ئادەملەرنىڭ پەرۋەردىگارنى مەنسىتمىگەنلىكىنى بىلىپ قالىسىلەر، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","مۇسانىڭ بۇ گېپى ئاخىرلىشىشى بىلەنلا ئۇلارنىڭ پۇتى ئاستىدىكى يەر يېرىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","يەر ئاغزىنى ئېچىپ ئۇلارنى بارلىق ئائىلىسىدىكىلەر بىلەن، شۇنىڭدەك كوراھقا تەۋە ھەممە ئادەملەرنى قويماي تەئەللۇقاتلىرى بىلەن قوشۇپ يۇتۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","شۇنداق قىلىپ، ئۇلار ۋە ئۇلارنىڭ تەۋەسىدىكىلەرنىڭ ھەممىسى تىرىكلا تەھتىساراغا چۈشۈپ كەتتى، يەر ئۇلارنىڭ ئۈستىدە يېپىلدى. ئۇلار شۇ يول بىلەن جامائەتنىڭ ئارىسىدىن يوقالدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ئۇلارنىڭ ئەتراپىدا تۇرغان ئىسرائ‍ىللارنىڭ ھەممىسى ئۇلارنىڭ نالىسىنى ئاڭلاپ: «يەر بىزنىمۇ يۇتۇپ كېتەرمىكىن!» دېيىشىپ قېچىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ئاندىن پەرۋەردىگارنىڭ ئالدىدىن بىر ئوت چىقىپ، خۇشبۇي سۇنۇۋاتقان ھېلىقى ئىككى يۈز ئەللىك ئادەمنىمۇ يۇتۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","پەرۋەردىگار مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","سەن كاھىن ھارۇننىڭ ئوغلى ئەلىئازارغا بۇيرۇغىن، ئۇ خۇشبۇيدانلارنى ئوت ئارىسىدىن تېرىۋېلىپ، چوغلىرىنى يىراقلارغا چېچىۋەتسۇن، چۈنكى ئۇ خۇشبۇيدانلار خۇداغا ئاتالغاندۇر؛ ");
INSERT INTO uigara_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","شۇڭا ئۆزىنىڭ جېنىغا ئۆزى زامىن بولغان گۇناھكارلارنىڭ خۇشبۇيدانلىرىنى تېرىۋالغىن؛ ئۇلار قۇربانگاھنى قاپلاش ئۈچۈن سوقۇپ نېپىز تۈنىكە قىلىنسۇن، چۈنكى بۇ خۇشبۇيدانلار ئەسلىدە پەرۋەردىگارنىڭ ھۇزۇرىغا سۇنۇلۇپ ئۇنىڭغا ئاتالىپ مۇقەددەس قىلىنغان. شۇنداق قىلىپ ئۇلار كېيىن ئىسرائ‍ىللارغا ئىبرەت بولىدىغان ئىشارەت-بەلگە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","شۇنىڭ بىلەن كاھىن ئەلىئازار ئوتتا كۆيدۈرۈۋېتىلگەنلەر سۇنغان مىس خۇشبۇيدانلارنى تېرىۋالدى؛ ئۇلار قۇربانگاھنى قاپلىتىشقا نېپىز تۈنىكە قىلىپ سوقۇلدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","شۇنىڭ بىلەن قۇربانگاھنىڭ بۇ قاپلىمىسى ھارۇننىڭ ئەۋلادلىرىغا يات ئادەملەرنىڭ خۇددى كوراھ بىلەن ئۇنىڭ گۇرۇھىدىكىلەرگە ئوخشاش قىسمەتكە قالماسلىقى ئۈچۈن، پەرۋەردىگارنىڭ ھۇزۇرىدا خۇشبۇي كۆيدۈرۈشكە يېقىنلاشماسلىقىغا ئىسرائ‍ىللار ئۈچۈن بىر ئەسلەتمە بولدى. بۇ پەرۋەردىگارنىڭ مۇسانىڭ ۋاستىسى بىلەن ئەلىئازارغا بۇيرۇغانلىرىدۇر. ");
INSERT INTO uigara_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ئەتىسى پۈتكۈل ئىسرائىل جامائىتى مۇسا بىلەن ھارۇننىڭ يامان گېپىنى قىلىپ: — سىلەر پەرۋەردىگارنىڭ خەلقىنى ئۆلتۈردۈڭلار، — دەپ غوتۇلداشتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ۋە شۇنداق بولدىكى، جامائەت مۇسا بىلەن ھارۇنغا ھۇجۇم قىلىشقا يىغىلىۋاتقاندا، جامائەت بۇرۇلۇپ جامائەت چېدىرىغا قارىۋىدى، ۋە مانا، بۇلۇت چېدىرنى قاپلىۋالدى ھەم پەرۋەردىگارنىڭ جۇلاسى ئايان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","شۇنىڭ بىلەن مۇسا بىلەن ھارۇن جامائەت چېدىرىنىڭ ئالدىغا بېرىپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","پەرۋەردىگار مۇساغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","مەن كۆزنى يۇمۇپ ئاچقۇچە ئۇلارنى يوقىتىپ تاشلىشىم ئۈچۈن ئىككىڭلار بۇ جامائەتتىن چىقىپ نېرى كېتىڭلار، — دەپ بۇيرۇۋىدى، ئىككىيلەن يىقىلىپ يەردە دۈم ياتتى. ");
INSERT INTO uigara_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","مۇسا ھارۇنغا: — سەن خۇشبۇيداننى ئېلىپ ئۇنىڭغا قۇربانگاھتىكى ئوتتىن سال، ئۇنىڭغا خۇشبۇي قويۇپ، ئۇلار ئۈچۈن كەفارەت كەلتۈرۈشكە تېزلىكتە جامائەتنىڭ ئارىسىغا ئاپار؛ چۈنكى قەھر-غەزەپ پەرۋەردىگارنىڭ ئالدىدىن چىقتى، ۋابا باسقىلى تۇردى، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ھارۇن مۇسانىڭ دېگىنىدەك قىلىپ، خۇشبۇيداننى ئېلىپ جامائەتنىڭ ئارىسىغا يۈگۈرۈپ كىردى؛ ۋە مانا، ۋابا كىشىلەرنىڭ ئارىسىدا باشلانغانىدى؛ ئۇ خۇشبۇينى خۇشبۇيدانغا سېلىپ، خەلق ئۈچۈن كەفارەت كەلتۈردى. ");
INSERT INTO uigara_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ئۇ ئۆلۈكلەر بىلەن تىرىكلەر ئوتتۇرىسىدا تۇرۇۋىدى، ۋابا توختىدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","كوراھنىڭ ۋەقەسى مۇناسىۋىتى بىلەن ئۆلگەنلەردىن باشقا، ۋابا سەۋەبىدىن ئۆلگەنلەر ئون تۆت مىڭ يەتتە يۈز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ھارۇن جامائەت چېدىرىنىڭ دەرۋازىسى يېنىدا تۇرغان مۇسانىڭ يېنىغا يېنىپ كەلدى؛ ۋابا توختىدى. ");
INSERT INTO uigara_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«سەن ئىسرائ‍ىللارغا سۆز قىلىپ، ئۇلاردىن ئاتا جەمەتى بويىچە، ھەر قەبىلىنىڭ ئەمىرىدىن بىردىن ئون ئىككى ھاسا ئالغىن؛ سەن ئۇلارنىڭ ھەربىرىنىڭ ئىسمىنى ئۆزىنىڭ ھاسىسىغا يېزىپ قويغىن. ");
INSERT INTO uigara_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","لاۋىي قەبىلىسىنىڭ ھاسىسىغا ھارۇننىڭ ئىسمىنى يازغىن، چۈنكى ھەربىر ئاتا جەمەت قەبىلە باشلىقى ئۈچۈن بىر ھاسا ۋەكىل بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","سەن بۇ ھاسىلارنى جامائەت چېدىرىدىكى ھۆكۈم-گۇۋاھلىق ساندۇقىنىڭ ئالدىغا، يەنى مەن سېنىڭ بىلەن كۆرۈشىدىغان يەرگە قويغىن.    ");
INSERT INTO uigara_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ۋە شۇنداق بولىدۇكى، مەن تاللىغان كىشىنىڭ بولسا، ئۇنىڭ ھاسىسى بىخ سۈرىدۇ؛ شۇنداق قىلىپ ئىسرائ‍ىللارنىڭ سىلەرگە غۇدۇراشقان گەپلىرىنى توختىتىپ ماڭا ئاڭلانمايدىغان قىلىۋېتىمەن». ");
INSERT INTO uigara_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","شۇنىڭ بىلەن مۇسا ئىسرائ‍ىللارغا شۇنداق سۆز قىلدى؛ ئۇلارنىڭ ھەممە ئەمىرلىرى ئۇنىڭغا بىردىن ھاسىنى، جەمئىي بولۇپ ئون ئىككى ھاسىنى بەردى؛ ھەربىر ئاتا جەمەتكە بىر ھاسا ۋەكىل بولدى، ھارۇننىڭ ھاسىسىمۇ شۇلارنىڭ ئىچىدە ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","مۇسا ھاسىلارنى ھۆكۈم-گۇۋاھلىق چېدىرىغا ئەكىرىپ پەرۋەردىگارنىڭ ھۇزۇرىغا قويدى. ");
INSERT INTO uigara_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ۋە شۇنداق بولدىكى، مۇسا ئەتىسى ھۆكۈم-گۇۋاھلىق چېدىرىغا كىرىۋىدى، مانا، لاۋىي جەمەتىگە ۋەكىل بولغان ھارۇننىڭ ھاسىسى بىخ سۈرۈپ، غۇنچىلاپ، چېچەكلەپ، بادام چۈشكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","مۇسا ھاسىلارنىڭ ھەممىسىنى پەرۋەردىگارنىڭ ئالدىدىن ئېلىپ چىقىپ، ئىسرائىل خەلقىگە كۆرسەتتى؛ ئۇلار كۆرگەندىن كېيىن ھەركىم ئۆز ھاسىلىرىنى ئېلىپ كېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","پەرۋەردىگار مۇساغا: — شۇ ئاسىيلىق قىلغۇچى بالىلارغا بىر ئاگاھ بەلگىسى بولسۇن دەپ ھارۇننىڭ ھاسىسىنى ھۆكۈم-گۇۋاھنىڭ ئالدىغا ئەكىرىپ قويغىن. شۇنداق قىلساڭ سەن ئۇلارنىڭ غۇدۇراشقان گەپلىرىنى توختىتىپ، ماڭا ئاڭلانمايدىغان قىلىسەن؛ ئۇلارمۇ شۇنىڭ بىلەن ئۆلۈپ كەتمەيدۇ، — دېدى.    ");
INSERT INTO uigara_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","مۇسا شۇنداق قىلدى؛ پەرۋەردىگار ئۆزىگە قانداق بۇيرۇغان بولسا ئۇ شۇنداق قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ئىسرائ‍ىللار مۇساغا سۆز قىلىپ: — بىز نەپەستىن قالاي دەۋاتىمىز، بىز تۈگەشتۇق، بىز ھەممىمىز تۈگەشتۇق! ");
INSERT INTO uigara_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","پەرۋەردىگارنىڭ ئىبادەت چېدىرىغا يېقىنلاشقانلار ئۆلمەي قالمايدۇ، شۇنداق ئىكەن، بىز ھەممىمىز مۇتلەق نەپەستىن قېلىشىمىز كېرەكمۇ؟ — دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","پەرۋەردىگار ھارۇنغا مۇنداق دېدى: — سەن، ئوغۇللىرىڭ ۋە ئاتا جەمەتىڭدىكىلەر سېنىڭ بىلەن بىرلىكتە مۇقەددەس جايغا مۇناسىۋەتلىك بولغان گۇناھنى، شۇنىڭدەك سەن ۋە ئوغۇللىرىڭ بىرلىكتە كاھىنلىق ۋەزىپىسىگە مۇناسىۋەتلىك بولغان گۇناھنى ئۈستۈڭلارغا ئالىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","سەن قېرىنداشلىرىڭ بولغان لاۋىي قەبىلىسىدىكىلەرنى، يەنى ئاتا-بوۋىلىرىڭنىڭ قەبىلىسىدىكىلەرنى ئۆزۈڭ بىلەن بىرلەشتۈر ھەم ئۇلارنى خىزمىتىڭنى قىلىشى ئۈچۈن باشلاپ ئېلىپ كەل؛ بىراق سەن بىلەن ئوغۇللىرىڭ سېنىڭ بىلەن بىرلىكتە ھۆكۈم-گۇۋاھلىق چېدىرى ئالدىدا خىزمەتلەرنى قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ئۇلار سېنىڭ بۇيرۇقلىرىڭغا تەييار تۇرۇپ، شۇنداقلا چېدىردىكى بارلىق خىزمەت-ۋەزىپىسىنى ئۆتەيدۇ؛ پەقەت مۇقەددەس جايدىكى قاچا-قۇچا ئەسۋابلارغا ۋە قۇربانگاھقا يېقىنلاشمىسۇن؛ ئۇنداق قىلسا، ئۇلارمۇ، سىلەرمۇ ئۆلۈپ كېتىسىلەر. ");
INSERT INTO uigara_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ئۇلار سېنىڭ بىلەن بىرلىشىپ، جامائەت چېدىرىدىكى ۋەزىپىنى ئۆتەپ، قىلىدىغان ھەربىر ئىشىنى قىلسۇن؛ پەقەتلا ھېچ يات كىشىلەر سىلەرگە يېقىنلاشمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","قەھر-غەزەپ يەنە ئىسرائ‍ىللارنىڭ بېشىغا چۈشمىسۇن ئۈچۈن، سىلەر مۇقەددەس جايدىكى ۋەزىپە بىلەن قۇربانگاھدىكى ۋەزىپىنى ئۆتەشكە مەسئۇل بولۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","مانا، مەن ئۆزۈم سىلەرنىڭ قېرىنداشلىرىڭلار بولغان لاۋىيلارنى ئىسرائ‍ىللار ئىچىدىن تاللاپ چىقتىم؛ ئۇلار جامائەت چېدىرىنىڭ ئىشلىرىنى قىلىشقا پەرۋەردىگارغا تەقدىم قىلىنغان بولۇپ، سىلەرگە سوۋغا سۈپىتىدە ئاتا قىلىنغان. ");
INSERT INTO uigara_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","لېكىن سەن ۋە ئوغۇللىرىڭ سېنىڭ بىلەن بىرلىكتە كاھىنلىق ۋەزىپەڭلەردە تۇرۇپ، قۇربانگاھتىكى بارلىق ئىشلارنى ھەم پەردە ئىچىدىكى ئىشلارنى بېجىرىڭلار؛ سىلەرنىڭ ۋەزىپەڭلەر شۇنداق بولسۇن. كاھىنلىق ۋەزىپىسىنى، خىزمىتىمدە بولۇشۇڭلار ئۈچۈن سىلەرگە سوۋغا قىلىپ بەردىم؛ يات ئادەملەر يېقىنلاشسا، ئۆلتۈرۈۋېتىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","پەرۋەردىگار ھارۇنغا مۇنداق دېدى: — مەن ماڭا سۇنۇلغان كۆتۈرمە ھەدىيەلەرنى، يەنى ئىسرائ‍ىللار ماڭا مۇقەددەس دەپ ئاتىغان بارلىق نەرسىلەرنى ئۈلۈشۈڭلار بولسۇن دەپ، مانا مەڭگۈلۈك بەلگىلىمە بىلەن ساڭا ۋە سېنىڭ ئەۋلادلىرىڭغا تەقدىم قىلدىم. ");
INSERT INTO uigara_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ئىسرائ‍ىللار ئوتتا سۇنىدىغان، «ئەڭ مۇقەددەس» نەرسىلەردىن سىلەرگە مۇنۇلار قالدۇرۇپ بېرىلىدۇ: — ئۇلارنىڭ ماڭا ئاتاپ سۇنغان بارلىق نەرسىلىرى، يەنى بارلىق ئاشلىق ھەدىيەلىرىدىن، بارلىق گۇناھ قۇربانلىقلىرىدىن، بارلىق ئىتائەتسىزلىك قۇربانلىقلىرىدىن «ئەڭ مۇقەددەس» ھېسابلانغانلىرى، ساڭا ۋە ئەۋلادلىرىڭغا ئاتا قىلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","سەن شۇ ئۈلۈشۈڭنى «ئەڭ مۇقەددەس» سۈپىتىدە يېگىن، سىلەردىن بولغان ھەربىر ئەر كىشى ئۇنى يېسۇن؛ ئۇ ساڭا «ئەڭ مۇقەددەس» دەپ بىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","مۇنۇلارمۇ سېنىڭ بولىدۇ: — ئىسرائ‍ىللارنىڭ سوۋغاتلىرى ئىچىدىن كۆتۈرمە ھەدىيەلەر، بارلىق پۇلاڭلاتما ھەدىيەلەر سېنىڭ؛ مەن ئۇلارنى ساڭا، شۇنداقلا ئوغۇللىرىڭ بىلەن قىزلىرىڭغا مەڭگۈلۈك بەلگىلىمە بىلەن تەقدىم قىلدىم؛ سېنىڭ ئۆيۈڭدىكى ھەربىر پاك ئادەم ئۇنىڭدىن يېسە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","زەيتۇن مېيىدىن ئەڭ ئېسىلىنى، يېڭى شارابتىن ئەڭ ئېسىلىنى، شۇنداقلا ئاشلىقتىن ئەڭ ئېسىلىنى، يەنى ئىسرائ‍ىللار پەرۋەردىگارغا ئاتاپ سۇنغان دەسلەپكى پىشقان مەھسۇلاتلارنىڭ ھەممىسىنى مەن ساڭا تەقدىم قىلىپ بەردىم. ");
INSERT INTO uigara_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ئۇلار يەردىن ئېلىپ پەرۋەردىگارغا ئاتاپ ئەكەلگەن دەسلەپكى پىشقان نەرسىلەرنىڭ ھەممىسى سېنىڭ بولسۇن؛ ئۆيۈڭدىكى ھەربىر پاك ئادەم ئۇنىڭدىن يېسە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ئىسرائىلدا خۇداغا مۇتلەق ئاتىلىدىغان ھەربىر نەرسە سېنىڭ بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ئۇلار پەرۋەردىگارغا ئاتاپ كەلتۈرىدىغان بارلىق جانىۋارلارنىڭ تۇنجىلىرى، مەيلى ئىنسان ياكى ئۇلاغ-چارپاي بولسۇن سېنىڭ بولىدۇ؛ ھالبۇكى، ئىنسانلارنىڭ تۇنجىلىرىنى بولسا ئۇلارنى تۆلەم تۆلەپ ياندۇرۇۋالسۇن ۋە ناپاك ھايۋانلارنىڭ تۇنجىلىرىنى تۆلەم تۆلەپ ياندۇرۇۋالسۇن.    ");
INSERT INTO uigara_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","تۆلەم تۆلەش كېرەك بولغانلار ئۈچۈن يېشى بىر ئايلىقتىن ئاشقاندا تۆلەم پۇلى تۆلەنسۇن؛ ئۇلارغا سەن توختاتقان باھا بويىچە، يەنى مۇقەددەس جايدىكى شەكەلنىڭ ئۆلچەم بىرلىكى بويىچە ‹بىر شەكەل يىگىرمە گەراھدۇر› باھا قويۇپ، بەش كۈمۈش شەكەل ئال. ");
INSERT INTO uigara_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","پەقەت تۇنجى كالا، تۇنجى قوي ياكى تۇنجى ئوغلاققا تۆلەم ئالساڭ بولمايدۇ؛ ئۇلارنىڭ ھەممىسى مۇقەددەستۇر. سەن ئۇلارنىڭ قېنىنى قۇربانگاھقا چېچىپ، مېيىنى پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان، ئۇنىڭغا خۇشبۇي كەلتۈرىدىغان قۇربانلىق سۈپىتىدە كۆيدۈرگىن. ");
INSERT INTO uigara_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ئۇلارنىڭ گۆشى سېنىڭ بولىدۇ؛ خۇددى «كۆتۈرمە ھەدىيە» قىلىنغان تۆش ۋە ئوڭ ئارقا پۇتىغا ئوخشاش، ساڭا تەۋە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ئىسرائ‍ىللار پەرۋەردىگارغا ئاتاپ سۇنغان مۇقەددەس نەرسىلەر ئىچىدىكى كۆتۈرمە ھەدىيە-قۇربانلىقنىڭ ھەممىسىنى مەن ساڭا ۋە سېنىڭ بىلەن بىللە تۇرۇۋاتقان ئوغۇل-قىزلىرىڭغا مەڭگۈلۈك بەلگىلىمە بىلەن تەقدىم قىلدىم. بۇ پەرۋەردىگار ئالدىدا سەن ۋە سېنىڭ بىلەن بىللە تۇرۇۋاتقان ئەۋلادلىرىڭ ئۈچۈن مەڭگۈلۈك تۇزلۇق ئەھدە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","پەرۋەردىگار ھارۇنغا مۇنداق دېدى: — ئىسرائىل زېمىنىدا سېنىڭ ھېچقانداق مىراسىڭ بولمايدۇ، ئۇلارنىڭ ئارىسىدىمۇ ھېچقانداق نېسىۋەڭ بولمايدۇ؛ ئىسرائ‍ىللار ئارىسىدا مانا مەن ئۆزۈم سېنىڭ نېسىۋەڭ، سېنىڭ مىراسىڭدۇرمەن. ");
INSERT INTO uigara_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","لاۋىيلارغا بولسا، ئۇلارنىڭ ئۆتەيدىغان خىزمەتلىرى، يەنى جامائەت چېدىرىدىكى خىزمىتى ئۈچۈن، مانا مەن ئىسرائىلدا تەقدىم قىلىنغان بارلىق «ئوندىن بىر ئۈلۈش»نىڭ ھەممىسىنى ئۇلارغا مىراس قىلىپ بەرگەنمەن. ");
INSERT INTO uigara_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","بۇنىڭدىن كېيىن، گۇناھكار بولۇپ ئۆلۈپ كەتمەسلىكى ئۈچۈن، ئىسرائ‍ىللار جامائەت چېدىرىغا يېقىنلاشمىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","جامائەت چېدىرىدىكى خىزمەتنى بولسا، ئۇنى ئۆتىگۈچىلەر پەقەت لاۋىيلارلا بولىدۇ ۋە شۇ ئىشتا بولغان گۇناھىنى ئۆزلىرى ئۈستىگە ئالىدۇ، بۇ سىلەر ئۈچۈن ئەۋلادمۇ-ئەۋلاد مەڭگۈلۈك بىر بەلگىلىمە بولىدۇ؛ ئۇلارنىڭ ئىسرائ‍ىللارنىڭ ئىچىدە ھېچقانداق مىراسى بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","چۈنكى ئىسرائ‍ىللارنىڭ پەرۋەردىگارغا ئاتاپ كۆتۈرمە ھەدىيە سۈپىتىدە سۇنغان «ئوندىن بىر ئۈلۈشى»نى لاۋىيلارغا مىراس قىلىپ تەقدىم قىلىدىغان بولدۇم؛ شۇڭا مەن ئۇلار توغرۇلۇق: ئىسرائ‍ىللار ئىچىدە ھېچقانداق مىراسى بولسا بولمايدۇ، — دېدىم. ");
INSERT INTO uigara_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","پەرۋەردىگار مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","سەن لاۋىيلارغا ئېيتقىن: «سىلەر ئىسرائ‍ىللارنىڭ قولىدىن مەن سىلەرگە مىراس بولسۇن دەپ تەقدىم قىلغان «ئوندىن بىر ئۈلۈش»نى ئالغان ئىكەنسىلەر، سىلەر شۇ ئوندىن بىر ئۈلۈشنىڭ يەنە ئوندىن بىر ئۈلۈشىنى ئايرىپ، ئۇنى پەرۋەردىگارغا ئاتاپ كۆتۈرمە ھەدىيە سۈپىتىدە سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","بۇ يول بىلەن سىلەرنىڭ شۇ «كۆتۈرمە ھەدىيە»ڭلار سىلەرگە «خاماندىكى ئاشلىقىڭلار»دىن ھەم «شاراب كۆلچىكىدىكى تولۇپ تاشقان شارابىڭلار»دىن ئاتالغانلار ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","بۇنداق بولغاندا، سىلەر ئىسرائ‍ىللارنىڭ قولىدىن ئالغان ئوندىن بىر ئۈلۈشنىڭ ھەممىسىدىن پەرۋەردىگارغا ئاتاپ كۆتۈرمە ھەدىيە سۇنىسىلەر؛ سىلەر پەرۋەردىگارغا ئاتىغان شۇ «كۆتۈرمە ھەدىيە»نى كاھىن ھارۇنغا بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","سىلەرگە تەقدىم قىلىنغان بارلىق نەرسىلەردىن ئەڭ ئېسىلىنى ئېلىپ شۇلارنى مۇقەددەس ھېسابلاپ «پەرۋەردىگارغا ئاتالغان تولۇق كۆتۈرمە ھەدىيە» سۈپىتىدە سۇنۇڭلار». ");
INSERT INTO uigara_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","شۇڭا سەن لاۋىيلارغا ئېيتقىنكى، «سىلەر شۇلاردىن ئەڭ ئېسىلىنى كۆتۈرۈپ سۇنساڭلار، بۇ سىلەر لاۋىيلارنىڭ خاماندىكى ئاشلىقىڭلار ۋە شاراب كۆلچىكىدىكى شارابىڭلارغا ئوخشاش ھېسابلىنىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","شۇنداق قىلغاندىن كېيىن سىلەر ۋە ئۆيدىكىلىرىڭلار شۇ «ئوندىن بىر ئۈلۈش»لەرنى خالىغان يەردە يېسەڭلار بولىدۇ، چۈنكى بۇ سىلەرنىڭ جامائەت چېدىرىدىكى خىزمىتىڭلارنىڭ ئىنئامى بولىدۇ؛ ");
INSERT INTO uigara_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","سىلەر شۇ ئۈلۈشلەردىن ئەڭ ئېسىلىنى كۆتۈرۈپ سۇنساڭلار، مۇشۇ ئىشىڭلار سەۋەبىدىن گۇناھكار بولمايسىلەر. ئۇنداق قىلساڭلار سىلەر ئىسرائ‍ىللار ئاتىغان مۇقەددەس نەرسىلەرنى بۇلغىمايسىلەر، شۇنىڭ بىلەن ئۆلمەيسىلەر». ");
INSERT INTO uigara_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","پەرۋەردىگار مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","مەن پەرۋەردىگار ئەمر قىلغان قانۇن-بەلگىلىمە شۇكى: — سەن ئىسرائ‍ىللارغا بۇيرۇغىن، ئۇلار بېجىرىم، نۇقسانسىز، بويۇنتۇرۇق سېلىنمىغان قىزىل ياش سىيىردىن بىرنى سېنىڭ يېنىڭغا ئەكەلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","سەن سىيىرنى كاھىن ئەلىئازارغا تاپشۇر، ئۇ ئۇنى چېدىرگاھنىڭ سىرتىغا ئەپچىقسۇن، ئاندىن بىرسى سىيىرنى ئۇنىڭ ئالدىدا بوغۇزلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","كاھىن ئەلىئازار بارمىقىنى قانغا مىلەپ، جامائەت چېدىرىنىڭ ئالدىغا قارىتىپ يەتتە مەرتەم چاچسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ئاندىن بىرسى ئەلىئازارنىڭ كۆز ئالدىدا پۈتكۈل سىيىرنى كۆيدۈرسۇن، يەنى ئۇنىڭ تېرىسى، گۆشى، قېنى ۋە تېزەكلىرىنى كۆيدۈرسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","كاھىن كېدىر ياغىچى، زوفا ئۆسۈملۈكى ۋە قىزىل رەختنى سىيىر كۆيدۈرۈلىدىغان ئوتقا تاشلىسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ئاندىن كاھىن ئۆز كىيىمىنى يۇسۇن ۋە بەدىنىنى سۇدا يۇسۇن، ئاندىن كېيىن بارگاھقا كىرىشكە بولىدۇ؛ لېكىن كاھىن كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","سىيىرنى كۆيدۈرگەن كىشىمۇ كىيىملىرىنى سۇ بىلەن يۇيۇپ، ئۆز بەدىنىنى سۇدا يۇسۇن، ئاندىن ئۇ كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","پاك بىر ئادەم سىيىرنىڭ كۈلىنى يىغىپ بارگاھنىڭ سىرتىدىكى پاك بىر يەرگە قويسۇن؛ ئۇ ئىسرائىل جامائىتى ئۈچۈن «ناپاكلىقنى چىقارغۇچى سۇ»نى ياساشقا شۇ يەردە ساقلانسۇن، ئۇ بىر «گۇناھنى پاكلىغۇچى»دۇر. ");
INSERT INTO uigara_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","سىيىرنىڭ كۈلىنى يىغىشتۇرغان ئادەم ئۆزىنىڭ كىيىملىرىنى يۇسۇن ۋە كەچ كىرگۈچە ناپاك سانالسۇن. بۇ ئىسرائ‍ىللارغا ۋە ئۇلارنىڭ ئارىسىدا تۇرۇۋاتقان مۇساپىرلارغا مەڭگۈلۈك قانۇن-بەلگىلىمە بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","ــ ئۆلۈككە، يەنى ھەرقانداق ئۆلگەن كىشىنىڭ جەسىتىگە تېگىپ كەتكەن ھەربىر كىشى يەتتە كۈن ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ئۇ ئادەم ئۈچىنچى كۈنى ئاشۇ سۇ بىلەن ئۆزىنى پاكلىسۇن، ھەمدە يەتتىنچى كۈنىمۇ پاكلىسۇن، ئاندىن ئۇ پاك سانىلىدۇ؛ ئەگەر ئۇ ئۈچىنچى كۈنى ھەمدە يەتتىنچى كۈنى ئۆزىنى پاكلىمىسا، پاك سانالمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ھەرقانداق ئادەم ئۆلۈككە، يەنى ھەرقانداق ئۆلگەن كىشىنىڭ جەسىتىگە تېگىپ كەتسە، ھەمدە ئۆزىنى پاكلىمىسا، پەرۋەردىگارنىڭ چېدىرىنى بۇلغىغان بولىدۇ؛ شۇ كىشى ئىسرائىل ئارىسىدىن ئۈزۈپ تاشلىنىدۇ؛ چۈنكى «ناپاكلىقنى چىقارغۇچى سۇ» ئۇنىڭغا سېپىلمىگەچكە، ئۇ ناپاك سانىلىدۇ؛ ئۇنىڭ ناپاكلىقى تېخىچە ئۈستىدە تۇرىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","ئەگەر بىرەر كىشى بىر چېدىر ئىچىدە ئۆلۈپ قالغان بولسا، ئۇ توغرۇلۇق قانۇن-بەلگىلىمە مۇنداق بولىدۇ: — شۇ چېدىرغا كىرگەن ھەربىرسى ۋە چېدىردا تۇرۇپ قالغانلارنىڭ ھەربىرى يەتتە كۈن ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ھەربىر ئوچۇق تۇرغان، ئاغزى يېپىلمىغان قاچا-قۇچىلارنىڭ ھەممىسى ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","شۇنىڭدەك دالادا قىلىچ-شەمشەر بىلەن ئۆلتۈرۈلگەنلەرگە، ياكى ئۆزى ئۆلۈپ قالغاننىڭ ئۆلۈكىگە، ياكى ئادەمنىڭ ئۇستىخىنىنىغا ياكى قەبرىسىگە تەگكەن ھەربىر كىشى يەتتە كۈنگىچە ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","كىشىلەر بۇ ناپاك كىشى ئۈچۈن «پاكلاندۇرغۇچى قۇربانلىق»نىڭ كۈلىدىن ئازراق ئېلىپ كومزەككە سېلىپ، ئۇلارنىڭ ئۈستىگە ئېقىن سۇ قۇيسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ئاندىن پاك بىر كىشى زوفا ئۆسۈملۈكىنى ئېلىپ شۇ سۇغا تەگكۈزۈپ ئۇنى چېدىرغا ۋە ئىچىدىكى بارلىق قاچا-قۇچىلارغا ھەم شۇ يەردە تۇرغان بارلىق كىشىلەرنىڭ ئۈستىگە سېپىپ قويسۇن، ۋە يەنە ئۇنى ئۇستىخانغا، ئۆلتۈرۈلگۈچىگە ياكى قەبرىگە تەگكەن كىشىنىڭ ئۈستىگە سېپىپ قويسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ئۈچىنچى كۈنى ۋە يەتتىنچى كۈنى ھېلىقى پاك ئادەم پاك بولمىغان ئادەملەرنىڭ ئۈستىگە شۇ سۇنى سېپىپ قويسۇن؛ شۇنداق قىلغاندا، يەتتىنچى كۈنىگە كەلگەندە ئۇ كىشى پاكلانغان بولىدۇ؛ ئاندىن ئۇ كىشى كىيىملىرىنى يۇيۇپ، بەدىنىنى سۇدا يۇسۇن، كەچ كىرگەندە ئۇ پاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","لېكىن ناپاك بولۇپ قېلىپ، ئۆزىنى پاكلىمىغان كىشى پەرۋەردىگارنىڭ مۇقەددەس جايىنى بۇلغىغىنى ئۈچۈن، جامائەت ئارىسىدىن ئۈزۈپ تاشلىنىدۇ؛ «ناپاكلىقنى چىقارغۇچى سۇ» ئۇنىڭ ئۈستىگە سېپىلمىگەن، شۇڭا ئۇ ناپاك سانىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","بۇ ئىسرائ‍ىللارغا مەڭگۈلۈك بەلگىلىمە بولىدۇ. «ناپاكلىقنى چىقارغۇچى سۇ»نى سەپكەن كىشى بولسا ئۆزىنىڭ كىيىملىرىنى يۇسۇن ۋە «ناپاكلىقنى چىقارغۇچى سۇ»غا تەگكەن كىشى كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ناپاك كىشى تەگكەن ھەرقانداق نەرسىمۇ ناپاك سانىلىدۇ؛ بۇ نەرسىلەرگە تەگكەن كىشىلەرمۇ كەچ كىرگۈچە ناپاك سانالسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","بىرىنچى ئاينىڭ ئىچىدە ئىسرائ‍ىللار، يەنى پۈتكۈل ئىسرائىل جامائىتى زىن چۆلىگە يېتىپ كېلىپ، قادەشتە تۇرۇپ قالدى؛ مەريەم شۇ يەردە ۋاپات بولدى ۋە شۇ يەرگە دەپنە قىلىندى. ");
INSERT INTO uigara_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","جامائەتكە ئىچىدىغانغا سۇ يوق ئىدى، ئۇلار يىغىلىپ مۇسا بىلەن ھارۇنغا ھۇجۇم قىلغىلى تۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","خەلق مۇسا بىلەن تەگىشىپ: —قېرىنداشلىرىمىز پەرۋەردىگارنىڭ ئالدىدا ئۆلگەن چاغدا بىزمۇ بىللە ئۆلسەك بوپتىكەن! ");
INSERT INTO uigara_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","سىلەر نېمە ئۈچۈن بىز ۋە چارپايلىرىمىزنى بۇ يەردە ئۆلۈپ كەتسۇن دەپ، پەرۋەردىگارنىڭ جامائىتىنى بۇ چۆل-جەزىرىگە باشلاپ كەلدىڭلار؟ ");
INSERT INTO uigara_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","سىلەر نېمە ئۈچۈن بىزنى مىسىردىن ئېلىپ چىقىپ بۇنداق دەھشەتلىك يەرگە ئەكەلدىڭلار؟ بۇ يەردە يا تېرىقچىلىق قىلغىلى يەر بولمىسا، يا ئەنجۈر، ئۈزۈم، ئانار بولمىسا، ئىچىدىغانغا سۇمۇ بولمىسا، — دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","شۇنىڭ بىلەن مۇسا بىلەن ھارۇن جامائەتتىن ئايرىلىپ جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىغا كېلىپ دۈم يىقىلىۋىدى، پەرۋەردىگارنىڭ جۇلاسى ئۇ ئىككىسىگە ئايان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","ھاسىنى قولۇڭغا ئال، ئاندىن سەن ئاكاڭ ھارۇن بىلەن بىرلىكتە جامائەتنى يىغىپ، ئۇلارنىڭ كۆز ئالدىدىلا قورام تاشقا بۇيرۇق قىل؛ شۇنداق قىلساڭ قورام تاش ئۆز سۈيىنى چىقىرىدۇ؛ شۇ يول بىلەن سەن ئۇلارغا سۇ چىقىرىپ، جامائەت ۋە چارپايلىرى ئىچىدىغانغا سۇ بېرىسەن.    ");
INSERT INTO uigara_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","شۇنىڭ بىلەن مۇسا پەرۋەردىگارنىڭ ئەمرى بويىچە پەرۋەردىگارنىڭ ھۇزۇرىدىن ھاسىنى ئالدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","مۇسا بىلەن ھارۇن ئىككىسى جامائەتنى قورام تاشنىڭ ئالدىغا يىغدى ۋە مۇسا ئۇلارغا: — گېپىمگە قۇلاق سېلىڭلار، ئى ئاسىيلار! بىز سىلەرگە بۇ قورام تاشتىن سۇ چىقىرىپ بېرەيلىمۇ؟! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ئاندىن مۇسا ھاسىسى بىلەن قورام تاشنى ئىككى قېتىم ئۇرۇۋىدى، ناھايىتى كۆپ سۇ ئېقىپ چىقتى، سۇدىن جامائەتمۇ، چارپايلارمۇ ئىچىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","پەرۋەردىگار مۇسا بىلەن ھارۇنغا: — سىلەر ماڭا ئىشەنمەي، ئىسرائ‍ىللار ئالدىدا مېنى مۇقەددەس دەپ ھۆرمەتلىمىگىنىڭلار ئۈچۈن، ئىككىڭلارنىڭ بۇ جامائەتنى مەن ئۇلارغا تەقدىم قىلىپ بەرگەن زېمىنغا باشلاپ كىرىشىڭلارغا يول قويمايمەن، — دېدى.    ");
INSERT INTO uigara_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","سۇ چىقىرىلغان جاي «مەرىباھ سۇلىرى» دەپ ئاتالغان؛ ئىسرائ‍ىللار شۇ يەردە پەرۋەردىگار بىلەن تاكاللاشقانلىقى ئۈچۈن، ئۇ ئۇلارنىڭ ئوتتۇرىسىدا ئۆزىنىڭ مۇقەددەس ئىكەنلىكىنى كۆرسەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","مۇسا قادەشتىن ئېدوم پادىشاھى بىلەن كۆرۈشۈشكە ئەلچى ئەۋەتىپ ئۇنىڭغا: «قېرىنداشلىرى ئىسرائىل مۇنداق دەيدۇ: — بىز تارتىۋاتقان جەبر-جاپالارنىڭ قانداقلىقى ئۆزلىرىگە مەلۇم، ");
INSERT INTO uigara_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","بىزنىڭ ئاتا-بوۋىلىرىمىز مىسىرغا چۈشكەن بولۇپ، بىز مىسىردا ئۇزاق زامان تۇرۇپ كەتتۇق؛ مىسىرلىقلار بىزگىمۇ، بىزنىڭ ئاتا-بوۋىلىرىمىزغىمۇ يامان مۇئامىلە قىلدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","بىز پەرۋەردىگارغا يېلىنىۋېدۇق، ئۇ بىزنىڭ زارىمىزغا قۇلاق سېلىپ، پەرىشتە ئەۋەتىپ بىزنى مىسىردىن ئېلىپ چىقتى. ھازىر مانا، بىز ئۆزلىرىنىڭ چېگرىسىغا جايلاشقان قادەش دېگەن بىر شەھەردە تۇرۇۋاتىمىز.    ");
INSERT INTO uigara_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ئەمدى بىزنىڭ زېمىنلىرىدىن ئۆتۈشىمىزگە رۇخسەت قىلغان بولسىلا، بىز ئېتىز-ئېرىق ۋە ئۈزۈمزارلىقلاردىن ئۆتمەيمىز، قۇدۇقلىرىڭلادىن سۇمۇ ئىچمەيمىز؛ «خان يولى» بىلەن مېڭىپ چېگرىلىرىدىن ئۆتۈپ كەتكۈچە ئوڭ-سولغا بۇرۇلمايمىز» — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","لېكىن ئېدوملار ئۇنىڭغا: «سىلەرنىڭ بىزنىڭ زېمىنىمىزدىن ئۆتۈشۈڭلەرگە بولمايدۇ، ئۆتىمەن دېسەڭلار قىلىچ كۆتۈرۈپ سىلەرگە جەڭگە چىقىمىز» — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ئىسرائ‍ىللار ئۇنىڭغا: «بىز «كۆتۈرۈلگەن يول» بىلەن ماڭىمىز، ئۆزىمىز ۋە ماللىرىمىز سۈيۈڭلارنى ئىچسەك، نەرخى بويىچە ھەققىنى بېرىمىز؛ بىز پەقەت پىيادە ئۆتۈپ كېتىمىز، باشقا ھېچ تەلىپىمىز يوق» دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ئېدوم پادىشاھى: «ياق. ئۆتمەيسىلەر!» دېدى. ئېدوم پادىشاھى ناھايىتى كۆپ ئادىمىنى باشلاپ چىقىپ ئىسرائ‍ىللارغا زور ھەيۋە كۆرسەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","شۇنداق قىلىپ ئېدوملار ئىسرائ‍ىللارنىڭ ئۇلارنىڭ تەۋەلىكىدىن ئۆتۈشىگە ئەنە شۇ يوسۇندا يول قويمىدى؛ شۇنىڭ بىلەن ئىسرائ‍ىللار ئېدوملارنىڭ ئالدىدىن بۇرۇلۇپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ئۇلار قادەشتىن يولغا چىقتى؛ پۈتكۈل ئىسرائىل خەلقى ھور تېغىغا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","پەرۋەردىگار ئېدومنىڭ چېگرىسىدىكى ھور تېغىدا مۇسا بىلەن ھارۇنغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","ھارۇن ئۆز خەلقلىرىگە قوشۇلۇپ كېتىدۇ؛ ئىككىڭلار مەرىباھ سۇلىرى دېگەن جايدا مېنىڭ ئەمرىمگە خىلاپلىق قىلغىنىڭلار ئۈچۈن، ئۇنىڭ مەن ئىسرائ‍ىللارغا تەقدىم قىلىپ بەرگەن زېمىنغا كىرىشىگە بولمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","سەن ھارۇن بىلەن ئوغلى ئەلىئازارنى ئېلىپ ھور تېغىغا چىققىن؛ ");
INSERT INTO uigara_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ھارۇننىڭ كىيىملىرىنى سالدۇرۇپ، ئوغلى ئەلىئازارغا كىيدۈرۈپ قوي؛ ھارۇن شۇ يەردە ئۆلۈپ، ئۆز خەلقلىرىگە قوشۇلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","مۇسا پەرۋەردىگارنىڭ دېگىنىدەك قىلدى، ئۈچەيلەن پۈتكۈل جامائەتنىڭ كۆز ئالدىدا ھور تېغىغا چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","مۇسا ھارۇننىڭ كىيىملىرىنى سالدۇرۇپ ئۇنىڭ ئوغلى ئەلىئازارغا كىيدۈرۈپ قويدى؛ ھارۇن تاغنىڭ چوققىسىدا ئۆلدى. ئاندىن مۇسا بىلەن ئەلىئازار تاغدىن چۈشۈپ كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","پۈتكۈل جامائەت ھارۇننىڭ ئۆلگەنلىكىنى بىلدى؛ شۇنىڭ بىلەن پۈتۈن ئىسرائىل جەمەتى ھارۇن ئۈچۈن ئوتتۇز كۈن ماتەم تۇتتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","جەنۇبتا تۇرۇشلۇق ئاراد مەملىكىتىنىڭ قانائانىيلاردىن بولغان پادىشاھى ئىسرائ‍ىللارنىڭ ئاتارىم يولى بىلەن كېلىۋاتقانلىقىنى ئاڭلاپ، چىقىپ ئۇلار بىلەن سوقۇشۇپ، نەچچەيلەننى تۇتقۇن قىلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ئاندىن ئىسرائ‍ىللار پەرۋەردىگارغا قەسەم ئىچىپ: «ئەگەر بۇ خەلقنى بىزنىڭ قولىمىزغا پۈتۈنلەي تاپشۇرىدىغان بولساڭ، ئۇلارنىڭ شەھەرلىرىنى ۋەيران قىلىپ تاشلايمىز» — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","پەرۋەردىگار ئىسرائ‍ىللارنىڭ پەريادىنى ئاڭلاپ، قانائانلىيلارنى ئۇلارنىڭ قولىغا تاپشۇردى، شۇنىڭ بىلەن ئۇلار قانائانىيلارنى ئۇلارنىڭ شەھەرلىرى بىلەن قوشۇپ ۋەيران قىلدى؛ شۇ سەۋەبتىن ئۇلار شۇ يەرنى «خورماھ» دەپ ئاتىدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ئۇلار ھور تېغىدىن يولغا چىقىپ، ئېدوم زېمىنىنى ئايلىنىپ ئۆتۈش ئۈچۈن، قىزىل دېڭىز بويىدىكى يولنى بويلاپ ماڭدى؛ خەلق مۇشۇ يول سەۋەبىدىن كۆڭلىدە تولىمۇ تاقەتسىز بولۇپ، ");
INSERT INTO uigara_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","خۇداغا ۋە مۇساغا قارشى چىقىپ: — سىلەر نېمە ئۈچۈن بىزنى چۆل-جەزىرىدە ئۆلسۇن دەپ مىسىر زېمىنىدىن باشلاپ چىققانسىلەر؟ بۇ يەردە يا ئاشلىق، يا سۇ يوق، كۆڭلىمىز بۇ ئەرزىمەس نانلاردىن بىزار بولدى، دېيىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","شۇ سەۋەبتىن پەرۋەردىگار ئۇلارنىڭ ئارىسىغا زەھەرلىك يىلانلارنى ئەۋەتتى؛ يىلانلار ئۇلارنى چاقتى، شۇ سەۋەبتىن ئىسرائ‍ىللاردىن نۇرغۇن ئادەم ئۆلۈپ كەتتى.    ");
INSERT INTO uigara_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","خەلق مۇسانىڭ ئالدىغا كېلىپ ئۇنىڭغا: — بىز ئاغزىمىزنى بۇزۇپ، پەرۋەردىگارغا ھەم ساڭا ھۇجۇم قىلىپ، يامان گەپ قىلىپ گۇناھ قىلدۇق؛ پەرۋەردىگارغا تىلاۋەت قىلساڭ، ئۇ بۇ يىلانلارنى ئارىمىزدىن ئېلىپ كەتكەي، — دېۋىدى، مۇسا خەلق ئۈچۈن دۇئا قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","پەرۋەردىگار مۇساغا: — سەن بىر زەھەرلىك يىلاننىڭ شەكلىنى ياساپ خادىغا ئېسىپ قويغىن؛ يىلان چېقىۋالغان ھەربىرى ئۇنىڭغا قارىسىلا قايتا ھاياتقا ئېرىشىدۇ، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","مۇسا مىستىن بىر يىلان ياسىتىپ خادىغا ئېسىپ قويدى؛ ۋە شۇنداق بولدىكى، يىلان بىركىمنى چېقىۋالغان بولسا، ئۇ بۇ مىس يىلانغا قارىسىلا، ئۇلار ھايات قالدى.    ");
INSERT INTO uigara_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ئىسرائ‍ىللار يەنە يولغا چىقىپ ئوبوتقا كېلىپ چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","يەنە ئوبوتتىن يولغا چىقىپ، موئاب زېمىنىنىڭ ئۇدۇلىدا كۈن چىقىش تەرەپتىكى ئىيە-ئىبارىمغا كېلىپ چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ئۇلار يەنە ئۇ يەردىن يولغا چىقىپ زەرەد جىلغىسىدا چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","يەنە ئۇ يەردىن مېڭىپ ئامورىيلارنىڭ زېمىنىنىڭ چېتىدىن چىقىپ چۆل-باياۋاندىن ئۆتۈپ، ئېقىپ تۇرغان ئارنون دەرياسىنىڭ ئۇ قېتىدا چېدىر تىكتى ‹چۈنكى ئارنون دەرياسى موئابىيلارنىڭ چېگرىسى بولۇپ، موئابىيلار بىلەن ئامورىيلارنىڭ ئوتتۇرىسىدا ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_14‏","005_21_14‏","NUM","21","14‏","15","شۇڭا «پەرۋەردىگارنىڭ جەڭنامىسى» دېگەن كىتابتا: — «سۇفاھدىكى ۋاھەب ۋە دەريا-ۋادىلىرى، ئارنون دەرياسى ۋە جىلغىلىرىنىڭ يانباغىرلىرى، ئارنىڭ تۇرالغۇسىغىچە يېتىپ، موئابنىڭ چېگرىسىغا چۈشىدۇ» دەپ پۈتۈلگەنىدى›. ");
INSERT INTO uigara_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ئىسرائ‍ىللار يەنە ئۇ يەردىن مېڭىپ بەئەرگە كەلدى؛ «بەئەر» قۇدۇق دېگەن مەنىدە بولۇپ، ئىلگىرى پەرۋەردىگار مۇساغا: «سەن خەلقنى يىغ، مەن ئۇلارغا ئىچىدىغان سۇ بېرەي» دېگەندە شۇ قۇدۇقنى كۆزدە تۇتقان. ");
INSERT INTO uigara_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","شۇ چاغدا ئىسرائ‍ىللار مۇنۇ ناخشىنى ئېيتىشقان: — «ئاھ قۇدۇق، چىقسۇن سۈيۈڭ بۇلدۇقلاپ، ناخشا ئېيتىڭلار، قۇدۇققا بېغىشلاپ: ");
INSERT INTO uigara_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","بۇ قۇدۇقنى ئەمىرلەر، خەلقنىڭ كاتتىلىرى قازغان، قانۇن چىقارغۇچىنىڭ سۆزى بىلەن، ھاسىلىرى بىلەن قازغان». ئىسرائ‍ىللار چۆل-باياۋاندىن يەنە ماتتاناھقا، ");
INSERT INTO uigara_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ماتتاناھتىن ناھالىيەلگە، ناھالىيەلدىن باموتقا، ");
INSERT INTO uigara_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","باموتتىن موئاب دالاسىدىكى جىلغىغا، يەنە چۆل-باياۋان تەرەپكە قاراپ تۇرغان پىسگاھ تېغىنىڭ چوققىسىغا يېتىپ باردى. ");
INSERT INTO uigara_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ئىسرائ‍ىللار ئامورىيلارنىڭ پادىشاھى سىھوننىڭ ئالدىغا ئەلچىلەرنى ئەۋەتىپ:    ");
INSERT INTO uigara_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","— بىزنىڭ ئۆز زېمىنلىرىدىن ئۆتۈۋېلىشىمىزگە ئىجازەت بەرگەيلا؛ بىز سىلىنىڭ ئېتىزلىقلىرىغا ۋە ئۈزۈمزارلىقلىرىغا كىرمەيمىز، قۇدۇقلىرىدىن سۇمۇ ئىچمەيمىز؛ تەۋەلىرىدىن ئۆتۈپ كەتكۈچە «خان يولى»دىن چىقمايمىز، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","سىھون ئىسرائ‍ىللارنى ئۆز چېگرىسىدىن ئۆتكىلى قويمايلا قالماستىن، ئەكسىچە ئۇ ئىسرائ‍ىللار بىلەن سوقۇشىمەن دەپ، ئۆزىنىڭ بارلىق خەلقىنى يىغىپ چۆلگە قاراپ ئاتلاندى. ئۇ ياھازغا كېلىپ ئىسرائىلغا ھۇجۇم قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ئىسرائ‍ىللار ئۇنى قىلىچ بىلەن چېپىپ ئۆلتۈرۈپ، ئۇنىڭ يۇرتىنى ئارنون دەرياسىدىن ياببوك دەرياسىغىچە، يەنى ئاممونىيلارنىڭ چېگرىسىغىچە ئىگىلىدى؛ ئاممونىيلارنىڭ چېگرىسى بولسا بەك مۇستەھكەم ئىدى.    ");
INSERT INTO uigara_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ئىسرائ‍ىللار بۇ يەردىكى ھەممە شەھەرنى ئىگىلىدى ھەم ئامورىيلارنىڭ شەھەرلىرىگە، يەنى ھەشبونغا ۋە ئۇنىڭغا تەۋە بارلىق يېزا-قىشلاقلارغىمۇ كىرىپ ئورۇنلاشتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","چۈنكى ھەشبون ئەسلىدە ئامورىيلارنىڭ پادىشاھى سىھوننىڭ مەركىزىي شەھىرى ئىدى؛ سىھون ئەسلىدە موئابنىڭ ئىلگىرىكى پادىشاھى بىلەن سوقۇشقان، ئۇنىڭ ئارنون دەرياسىغىچە بولغان ھەممە زېمىنىنى تارتىۋالغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","شۇ سەۋەبتىن شائىرلار: — «ھەشبونغا كېلىڭلار! مانا سىھوننىڭ شەھىرى يېڭىۋاشتىن قۇرۇلسۇن، سىھوننىڭ شەھىرى مەھكەم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","چۈنكى ھەشبوننىڭ ئۆزىدىن چىقتى بىر ئوت، سىھوننىڭ شەھىرىدىن بىر يالقۇن يالقۇنلاپ، يۇتۇۋەتتى موئابتىكى ئار شەھىرىنى، ئارنوندىكى ئېگىز جايلارنىڭ ئەمىرلىرىنى. ");
INSERT INTO uigara_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ۋاي ساڭا ئەي موئاب! ھەي كېموشنىڭ ئۈممىتى، تۈگەشتىڭلار! چۈنكى كېموش ئۆز ئوغۇللىرىنى قاچقۇنغا ئايلاندۇردى، قىزلىرىنى ئەسىرلىككە بېرىپ، ئامورىيلارنىڭ پادىشاھى سىھونغا تۇتۇپ بەردى!    ");
INSERT INTO uigara_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","بىز ئۇلارنى يىقىتىۋەتتۇق، ھەشبون تاكى دىبونغىچە ھالاك بولدى؛ بىز ھەتتا نوفاھقىچە ‹نوفاھتىن مەدەباغا يېتىدۇ› ئۇلارنىڭ يۇرتىنى ۋەيران قىلىۋەتتۇق!» — دەپ شېئىر يېزىشقانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","شۇنىڭ بىلەن ئىسرائ‍ىللار ئەنە شۇ تەرىقىدە ئامورىيلارنىڭ يۇرتىغا ئورۇنلاشتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","مۇسا يائازەرنى چارلاپ كېلىشكە چارلىغۇچىلارنى ئەۋەتتى؛ ئاندىن ئىسرائ‍ىللار يائازەرنىڭ يېزا-قىشلاقلىرىنى ئىشغال قىلىپ، ئۇ يەرلەردىكى ئامورىيلارنى يېرىدىن قوغلىۋەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","شۇنىڭدىن كېيىن ئىسرائ‍ىللار بۇرۇلۇپ، باشاننىڭ يولىنى بويلاپ ماڭدى؛ باشاننىڭ پادىشاھى ئوگ ۋە ئۇنىڭ بارلىق خەلقى چىقىپ ئەدرەيدە ئىسرائ‍ىللار بىلەن جەڭ قىلىشقا سەپ تۈزدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","پەرۋەردىگار مۇساغا: — قورقما، مەن ئۇنى، ئۇنىڭ بارلىق خەلقى ھەم زېمىنىنى قولۇڭغا تاپشۇرىمەن؛ سەن ئۇنى ئىلگىرى ھەشبوندا تۇرۇشلۇق ئامورىيلارنىڭ پادىشاھى سىھوننى قىلغاندەك قىلىسەن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","شۇنىڭ بىلەن ئۇلار ئوگ بىلەن ئۇنىڭ ئوغۇللىرىنى ھەم بارلىق خەلقىنىڭ بىرىنى قويماي قىرىپ تاشلىدى ۋە ئۇنىڭ زېمىنىنى ئىگىلىدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ئىسرائ‍ىللار يەنە يولغا چىقىپ موئاب تۈزلەڭلىكلىرىدە، يەنى ئىئوردان دەرياسىنىڭ شەرق تەرىپىدە، يېرىخونىڭ ئۇدۇلىدا چېدىر تىكتى. ");
INSERT INTO uigara_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ئىسرائ‍ىللارنىڭ ئامورىيلارغا قىلغان ئىشلىرىنىڭ ھەممىسىنى زىپپورنىڭ ئوغلى بالاق كۆرۈپ تۇرغانىدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","موئابىيلار خەلقتىن ئىنتايىن قورقۇشتى، چۈنكى ئۇلار بەك كۆپ ئىدى؛ موئابىيلار ئىسرائ‍ىللارنىڭ سەۋەبىدىن بەك ئالاقزادە بولۇپ كېتىشتى. ");
INSERT INTO uigara_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","موئابىيلار مىدىيان ئاقساقاللىرىغا: «بۇ بىر توپ ئادەم ئەتراپىمىزدىكى ھەممە نەرسىنى، خۇددى كالا ئېتىزدىكى ئوتنى يالمىغاندەك يالماپ يەپ كېتىدىغان بولدى» — دېيىشتى. ئۇ چاغدا زىپپورنىڭ ئوغلى بالاق موئابنىڭ پادىشاھى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ئۇ ئەلچىلەرنى بېئورنىڭ ئوغلى بالائامنىڭ ئالدىغا، بالائامنىڭ ئانا يۇرتىدىكى ئۇلۇغ دەريا بويىدىكى پېتور شەھىرىگە بېرىپ، بالائامنى چاقىرىپ كېلىشكە ئەۋەتىپ: پادىشاھىمىز: — «قارىسىلا، بىر خەلق مىسىردىن چىققانىدى؛ مانا، ئۇلار پۈتۈن زېمىنغا يامراپ كەتتى، مانا ئۇلار بىزنىڭ ئۇدۇلىمىزغا كېلىپ چۈشتى.    ");
INSERT INTO uigara_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ئۇلار مېنىڭدىن كۈچلۈك بولغاچقا، ئەمدى ئۆزلىرى كېلىپ بۇ خەلقنى مەن ئۈچۈن بىر قارغاپ بەرگەن بولسىلا؛ بەلكىم مەن ئۇلارنى يېڭىپ، بۇ زېمىندىن قوغلاپ چىقىرىشىم مۇمكىن؛ چۈنكى ئۆزلىرى كىمگە بەخت تىلىسىلە شۇنىڭ بەخت قۇچىدىغانلىقىنى، كىمنى قارغىسىلا، شۇنىڭ قارغىشقا قالىدىغانلىقىنى بىلىمەن» دەيدۇ، دەڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","موئابنىڭ ئاقساقاللىرى بىلەن مىدىياننىڭ ئاقساقاللىرى قوللىرىدا پال سېلىش ئىنئاملىرىنى ئېلىپ ماڭدى؛ ئۇلار بالائامنىڭ ئالدىغا كېلىپ بالاقنىڭ گەپلىرىنى يەتكۈزدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","بالائام ئۇلارغا: — بۈگۈن ئاخشام مۇشۇ يەردە قونۇپ قېلىڭلار، مەن پەرۋەردىگارنىڭ ماڭا قىلغان سۆزى بويىچە سىلەرگە جاۋاپ يەتكۈزىمەن، — دېدى. شۇنىڭ بىلەن موئابنىڭ شۇ ئەمىرلىرى بالائامنىڭكىدە قونۇپ قالدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","خۇدا بالائامنىڭكىگە كېلىپ: — سېنىڭ بىلەن بىللە تۇرغان بۇ ئادەملەر كىم؟ — دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بالائام خۇداغا: — موئاب پادىشاھى زىپپورنىڭ ئوغلى بالاق ئەلچىلەرنى ئەۋەتىپ ماڭا: ");
INSERT INTO uigara_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","«قارىسىلا، مىسىردىن بىر خەلق چىققانىدى، ئۇلار پۈتۈن زېمىنغا يامراپ كەتتى؛ بۇ يەرگە كېلىپ مېنىڭ ئۈچۈن ئۇلارنى قارغاپ بەرسىلە، شۇنداق قىلسىلا بەلكىم ئۇلارنى يېڭىپ، بۇ يەردىن قوغلىۋېتەلىشىم مۇمكىن» — دېدى، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","خۇدا بالائامغا: سەن ئۇلار بىلەن بىللە بارساڭ بولمايدۇ، ئۇ خەلقنى قارغىساڭمۇ بولمايدۇ، چۈنكى ئۇلارغا بەخت-بەرىكەت ئاتا قىلىنغان، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","بالائام ئەتىگەن تۇرۇپ بالاقنىڭ ئەمەلدارلىرىغا: — سىلەر ئۆز يۇرتۇڭلارغا قايتىپ كېتىڭلار، چۈنكى پەرۋەردىگار مېنىڭ سىلەر بىلەن بىللە بېرىشىمغا رۇخسەت قىلمىدى، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","موئابنىڭ ئەمەلدارلىرى قوپۇپ بالاقنىڭ يېنىغا كېلىپ ئۇنىڭغا: — بالائام بىز بىلەن بىللە كېلىشكە ئۇنىمىدى، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","شۇنىڭ بىلەن بالاق تېخىمۇ كۆپ ۋە تېخىمۇ مۆتىۋەر ئەمەلدارلارنى ئەۋەتتى، ");
INSERT INTO uigara_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ئۇلار بالائامنىڭ ئالدىغا كېلىپ ئۇنىڭغا: — زىپپورنىڭ ئوغلى بالاق مۇنداق دەيدۇ: — «ھېچنېمە سىلىنىڭ يېنىمغا كېلىشلىرىنى توسمىغاي؛ ");
INSERT INTO uigara_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","چۈنكى مەن ئۆزلىرىنى زور شان-شۆھرەتكە ئېگە قىلىمەن؛ نېمە دېسىلە ماقۇل دەيمەن؛ شۇڭا ماڭا ئەشۇ خەلقنى قارغاپ بەرسىلىلا بولىدۇ»، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","بالائام بالاقنىڭ خىزمەتكارلىرىغا جاۋابەن: — بالاق ماڭا ئۆزىنىڭ ئالتۇن-كۈمۈشكە لىق تولغان ئۆز ئۆيىنى بەرسىمۇ، مەيلى چوڭ ياكى كىچىك ئىش قىلاي، خۇدايىم پەرۋەردىگارنىڭ ماڭا بۇيرۇغانلىرىدىن ھالقىپ كېتەلمەيمەن. ");
INSERT INTO uigara_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","سىلەرمۇ بۈگۈن ئاخشام مۇشۇ يەردە قونۇپ قېلىڭلار، پەرۋەردىگار يەنە شۇ ئىشلار توغرىسىدا ماڭا نېمە دەيدىكىن، شۇنى بىلەي، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","شۇ كېچىسى خۇدا بالائامنىڭكىگە كېلىپ ئۇنىڭغا: — ئۇ كىشىلەر سېنى تەكلىپ قىلىپ كەلگەن بولسا، ئۇلار بىلەن بىللە بارغىن، لېكىن سەن مېنىڭ ساڭا ئېيتىدىغانلىرىم بويىچە ئىش قىلىشىڭ كېرەك، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","بالائام ئەتىگەن تۇرۇپ ئېشىكىنى توقۇپ موئابنىڭ ئەمىرلىرى بىلەن بىللە ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","خۇدا بالائامنىڭ ماڭغانلىقىدىن غەزەپلەندى؛ پەرۋەردىگارنىڭ پەرىشتىسى ئۇنى توسۇشقا يولدا تۇراتتى. ئۇ شۇ چاغدا ئېشىكىگە مىنىپ ئىككى غۇلامى بىلەن بىللە كېتىۋاتاتتى. ");
INSERT INTO uigara_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","مادا ئېشەك پەرۋەردىگارنىڭ پەرىشتىسىنىڭ قولىغا قىلىچ ئالغان ھالدا يولدا تۇرغانلىقىنى كۆرۈپ، يولدىن چىقىپ ئېتىزلىق بىلەن مېڭىۋىدى، بالائام ئېشەكنى يولغا چىقىپ مېڭىشقا دۇمبالاپ ئۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","پەرۋەردىگارنىڭ پەرىشتىسى ئىككى تەرىپى توسما تام بىلەن توسۇلغان ئۈزۈمزارلىقتىكى تار بىر يولدا تۇرۇۋالدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ئېشەك پەرۋەردىگارنىڭ پەرىشتىسىنى كۆرۈپ، تامغا قىستىلىپ مېڭىپ، بالائامنىڭ پۇتىنى تامغا قىستاپ يارىلاندۇرۇپ قويدى؛ بالائام ئېشەكنى يەنە دۇمبالىدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","پەرۋەردىگارنىڭ پەرىشتىسى بولسا يەنە ئالدىغىراق بېرىپ، ئوڭ يا سولغا بۇرۇلۇشقا بولمايدىغان تېخىمۇ تار بىر يەردە كۈتۈپ تۇردى. ");
INSERT INTO uigara_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ئېشەك پەرۋەردىگارنىڭ پەرىشتىسىنى كۆرۈپ ماڭماي، بالائامنىڭ ئاستىدا يېتىۋالدى؛ بالائام قاتتىق خاپا بولۇپ، ئېشەكنى ھاسىسى بىلەن قاتتىق دۇمبالاپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","بۇ چاغدا پەرۋەردىگار ئېشەككە زۇۋان كىرگۈزۈۋىدى، ئېشەك بالائامغا: — مېنى ئۈچ قېتىم دۇمبالايدىغانغا ساڭا نېمە يامانلىق قىپتىمەن؟ — دېۋىدى، ");
INSERT INTO uigara_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بالائام ئېشەككە: — سەن مېنى سەتلەشتۈردۈڭ، قولۇمدا قىلىچ بولغان بولسا ئىدى، سېنى چېپىپ ئۆلتۈرۈۋېتەتتىم! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ئېشەك بالائامغا: — مەن سېنىڭكى بولغىنىمدىن تارتىپ مىنىپ كەلگەن ئېشىكىڭ مەن ئەمەسمۇ؟ ئىلگىرى مەن ساڭا مۇشۇنداق قىلىش ئادىتىم بولۇپ باققانمۇ؟ — دېۋىدى، — ياق، — دېدى بالائام. ");
INSERT INTO uigara_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ئەنە شۇ چاغدا پەرۋەردىگار بالائامنىڭ كۆزلىرىنى ئاچتى، بالائام پەرۋەردىگارنىڭ پەرىشتىسىنىڭ قىلىچىنى غىلىپىدىن چىقىرىپ، يولدا تۇرغانلىقىنى كۆردى؛ ئۇ يەرگە بېشىنى قويۇپ سەجدە قىلدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","پەرۋەردىگارنىڭ پەرىشتىسى ئۇنىڭغا: — سەن ئېشىكىڭنى نېمە ئۈچۈن ئۈچ قېتىم دۇمبالايسەن؟ قارىغىنا، ماڭغان يولۇڭ مېنىڭ نەزىرىمدە تەتۈر بولغاچقا،سېنى توسۇشقا چىققۇچى مەن ئۆزۈم ئىدىم. ");
INSERT INTO uigara_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ئېشەك مېنى كۆرۈپ ئۈچ قېتىم مېنىڭ ئالدىمدىن بۇرۇلۇپ كەتتى؛ ئەگەر ئېشەك مېنىڭ ئالدىمدىن بۇرۇلۇپ كەتمىگەن بولسا، مەن ئاللىقاچان سېنى ئۆلتۈرۈپ ئېشەكنى تىرىك قالدۇرغان بولاتتىم، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","بالائام پەرۋەردىگارنىڭ پەرىشتىسىگە: — مەن گۇناھكارمەن، ئۆزلىرىنىڭ يولدا مېنى توسۇپ تۇرغانلىقلىرىنى كۆرمەپتىمەن؛ مۇبادا ئەمدى مېنىڭ بېرىشىم نەزەرلىرىدە رەزىل كۆرۈنسە، مەن قايتىپ كېتەي، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","پەرۋەردىگارنىڭ پەرىشتىسى بالائامغا يەنە: — بوپتۇ، بۇ كىشىلەر بىلەن بىللە بارغىن، بىراق پەقەت مەن ساڭا دېگەن سۆزنىلا دېگىن، — دېدى. شۇنىڭ بىلەن بالائام بالاقنىڭ ئەمەلدارلىرى بىلەن بىللە ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","بالاق بالائامنى كېلىۋېتىپتۇ دەپ ئاڭلاپ، قارشى ئېلىش ئۈچۈن موئابنىڭ ئارنون دەرياسىنىڭ بويىدىكى، چېگرىنىڭ ئەڭ بېشىدىكى شەھىرىگە كەلدى: ");
INSERT INTO uigara_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","— مەن سىلىنى چاقىرىشقا شۇنچە جىددىي ئەلچى ئەۋەتكەنىدىم، نېمە ئۈچۈن كېلىشكە ئۇنىمىدىلا؟ مەن سىلىنى شان-شۆھرەتكە ئىگە قىلالمايتتىممۇ؟ — دېدى بالاق بالائامغا. ");
INSERT INTO uigara_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","— قارىسىلا، مانا كەلدىمغۇ، ئەمدى مەن ئۆز ئالدىمغا بىرنېمە دېيەلەيتتىممۇ؟ — دېدى بالائام، — خۇدا ئاغزىمغا نېمە گەپنى سالسا، مەن شۇنىلا دەيمەن. ");
INSERT INTO uigara_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","بالائام بالاق بىلەن بىللە يولغا چىقىپ كىرىئات-خۇزوتقا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","بالاق كالا، قويلارنى سويۇپ قۇربانلىق قىلىپ، ئۇلارنىڭ گۆشىدىن بالائام ۋە ئۇنىڭ بىلەن بىللە بولغان ئەمىرلەرگە ئەۋەتىپ بەردى. ");
INSERT INTO uigara_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ئاندىن بالاق ئەتىسى سەھەردە بالائامنى بائالنىڭ ئېگىز جايلىرىغا ئېلىپ چىقتى؛ ئۇ شۇ يەردىن ئىسرائىل خەلقىنىڭ ئەڭ چەتتىكى بىر قىسمىنى كۆردى. ");
INSERT INTO uigara_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","بالائام بالاققا: — سىلى مۇشۇ يەرگە ماڭا يەتتە قۇربانگاھ ياسىتىپ بەرسىلە، مۇشۇ يەرگە يەنە يەتتە بۇقا بىلەن يەتتە قوشقارمۇ ھازىرلاپ بەرسىلە، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","بالاق بالائامنىڭ دېگىنىدەك قىلىپ بەردى؛ بالاق بىلەن بالائام ئىككىسى ھەربىر قۇربانگاھقا قۇربانلىق قىلىشقا بىردىن بۇقا بىلەن بىردىن قوشقار سۇندى. ");
INSERT INTO uigara_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","بالائام بالاققا: — سىلى ئۆز كۆيدۈرمە قۇربانلىقلىرىنىڭ يېنىدا تۇرسىلا، مەن ئالدىغا بارىمەن، پەرۋەردىگار مېنىڭ بىلەن كۆرۈشۈشكە كېلەمدىكىن؟ ئۇ ماڭا نېمە دەپ كۆرسەتمە بەرسە، مەن ئۆزلىرىگە شۇنى دەپ بېرىمەن، — دېدى ۋە بىر دۆڭگە چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","خۇدا بالائام بىلەن كۆرۈشتى؛ بالائام خۇداغا: — مەن يەتتە قۇربانگاھ ھازىرلاتتىم، ھەربىر قۇربانگاھقا قۇربانلىق سۈپىتىدە بىردىن بۇقا بىلەن بىردىن قوشقار سۇندۇم، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","پەرۋەردىگار بالائامنىڭ ئاغزىغا بىر سۆزنى سېلىپ: — بالاقنىڭ يېنىغا قايتىپ بېرىپ ئۇنىڭغا مۇنداق، مۇنداق دېگىن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","شۇنىڭ بىلەن ئۇ بالاقنىڭ يېنىغا قايتىپ باردى. مانا، ئۇ ۋە موئابنىڭ بارلىق ئەمىرلىرى ئۇنىڭ كۆيدۈرمە قۇربانلىقىنىڭ يېنىدا تۇراتتى. ");
INSERT INTO uigara_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","بالائام كالام سۆزىنى ئاغزىغا ئېلىپ مۇنداق دېدى: — بالاق مېنى ئارام دېگەن يۇرتتىن، موئاب شاھى بالاق مېنى مەشرىق تاغلىرىدىن ئېلىپ كېلىپ، مۇنداق دېدى: — كەل، مېنىڭ ئۈچۈن ياقۇپنى قارغىغىن. كەل، ئىسرائىلنى راسا بىر سۆكۈپ ئەيىبلىگىن. ");
INSERT INTO uigara_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","تەڭرى ئۆزى قارغىمىغان بىراۋنى مەن قانداق قارغاي؟ پەرۋەردىگار ئۆزى سۆكۈپ ئەيىبلىمىگەن بىراۋنى مەن قانداق سۆكۈپ ئەيىبلەي؟ ");
INSERT INTO uigara_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","مەن قورام تاشلارنىڭ چوققىلىرىدا تۇرۇپ ئۇنى كۆرمەكتىمەن، دۆڭلەردە تۇرۇپ ئۇنىڭغا نەزەر سالماقتىمەن؛ مانا، ئۇلار يەككە ياشايدىغان بىر قوۋم، ئۇلار باشقا قوۋملارنىڭ قاتارىدا سانالمايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ياقۇپنىڭ توپىلىرىنى كىم ھېسابلاپ چىقالايدۇ؟ ھەتتا ئىسرائىلنىڭ تۆتتىن بىرىنىمۇ كىم ساناپ چىقالايدۇ؟ مېنىڭ جېنىم ھەققانىينىڭ ئۆلۈمىدەك ئۆلسۇن، مېنىڭ ئاخىرىم ئۇنىڭكىدەك بولغاي! ");
INSERT INTO uigara_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","بالاق بالائامغا قاراپ: — سەن ماڭا نېمە قىلىۋاتىسەن؟! مەن سېنى دۈشمەنلىرىمنى قارغاپ بېرىشكە چاقىرىتقان تۇرسام، مانا سەن ئەكسىچە پۈتۈنلەي ئۇلارغا ئامەت تىلىدىڭ! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","— پەرۋەردىگارنىڭ ئاغزىمغا سالغىنىنى يەتكۈزۈشكە كۆڭۈل قويمىسام بولامتى؟ — دەپ جاۋاپ بەردى بالائام. ");
INSERT INTO uigara_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","بالاق بالائامغا: — مېنىڭ بىلەن بىللە باشقا بىر يەرگە بارسىلا، ئۇلارنى شۇ يەردىن كۆرەلەيلا؛ بىراق ئۇلارنىڭ ھەممىسىنى ئەمەس، ئۇلارنىڭ چېگرىدىكى بىر قىسمىنىلا كۆرەلەيلا؛ سىلى شۇ يەردە تۇرۇپ ئۇلارنى مەن ئۈچۈن قارغاپ بەرسىلە، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","شۇنىڭ بىلەن بالاق بالائامنى «زوفىمنىڭ دالاسى»غا، پىسگاھ تېغىنىڭ چوققىسىغا باشلاپ بېرىپ، شۇ يەردە يەتتە قۇربانگاھ سالدۇرۇپ، ھەربىر قۇربانگاھقا قۇربانلىق سۈپىتىدە بىردىن بۇقا، بىردىن قوشقار سۇندى. ");
INSERT INTO uigara_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","بالائام بالاققا: — سىلى مۇشۇ يەردە ئۆزلىرىنىڭ كۆيدۈرمە قۇربانلىقلىرىنىڭ يېنىدا تۇرۇپ تۇرسىلا، مەن ئاۋۇ ياققا بېرىپ كۆرۈشۈپ كېلەي، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","پەرۋەردىگار بالائام بىلەن كۆرۈشۈپ، ئۇنىڭ ئاغزىغا بىر سۆزنى سېلىپ: — سەن بالاقنىڭ يېنىغا قايتىپ ئۇنىڭغا مۇنداق، مۇنداق دېگىن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","بالائام بالاقنىڭ يېنىغا قايتىپ كەلگەندە، مانا، ئۇ ۋە موئابنىڭ بارلىق ئەمىرلىرى ئۇنىڭ كۆيدۈرمە قۇربانلىقىنىڭ يېنىدا تۇراتتى. — پەرۋەردىگار نېمە دېدى؟ — دەپ سورىدى بالاق. ");
INSERT INTO uigara_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","بالائام كالام سۆزىنى ئاغزىغا ئېلىپ مۇنداق دېدى: — «ھەي بالاق، سەن قوپۇپ ئاڭلىغىن، ئاھ ، زىپپورنىڭ ئوغلى، ماڭا قۇلاق سالغىن. ");
INSERT INTO uigara_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","تەڭرى ئىنسان ئەمەستۇر، ئۇ يالغان ئېيتمايدۇ، ياكى ئادەم بالىسىمۇ ئەمەستۇر، ئۇ پۇشايمان قىلمايدۇ. ئۇ دېگەنىكەن، ئىشقا ئاشۇرماي قالامدۇ؟ ئۇ سۆز قىلغانىكەن، ۋۇجۇدقا چىقارماي قالامدۇ؟ ");
INSERT INTO uigara_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","مانا، ماڭا «بەرىكەتلە» دەپ تاپشۇرۇلدى، ئۇ بەرىكەتلىگەنىكەن، بۇنى مەن ياندۇرالمايمەن. ");
INSERT INTO uigara_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ئۇ ياقۇپتا ھېچ گۇناھ كۆرمىگەن، ئىسرائىلدا ناھەقلىقنى ئۇچراتمىغان. خۇداسى پەرۋەردىگار ئۇنىڭ بىلەن بىللە، پادىشاھنىڭ تەنتەنە ئاۋازى ئۇنىڭ ئارىسىدىدۇر.    ");
INSERT INTO uigara_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","تەڭرى ئۇنى مىسىردىن ئېلىپ چىققان؛ ئۇنىڭدا ياۋا كالىنىڭكىدەك كۈچ باردۇر.    ");
INSERT INTO uigara_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","چۈنكى ياقۇپلارغا ئەپسۇن كارغا كەلمەيدۇ، ئىسرائىللارغىمۇ پال كارغا كەلمەيدۇ. ۋاقتى-سائىتى كەلگەندە، ياقۇپ بىلەن ئىسرائىل توغرىسىدا: — «تەڭرى نەقەدەر كارامەت ئىش قىلىپ بەرگەن-ھە!» دەپ جاكارلانماي قالمايدۇ! ");
INSERT INTO uigara_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","مانا، بۇ قوۋم چىشى شىردەك قوپىدۇ، ئەركەك شىردەك قەددىنى رۇسلايدۇ؛ ئۆزى ئوۋلىغان ئوۋنى يېمىگۈچە، ئۆلتۈرگەنلەرنىڭ قېنىنى ئىچمىگۈچە، ھەرگىز ياتمايدۇ!». ");
INSERT INTO uigara_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","بالاق بالائامغا: — بولدى، سىلى ئۇلارنى ئازراقمۇ قارغىمىسىلا، ئۇلارغا ئامەتمۇ تىلىمىسىلە! — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","بالائام بالاققا جاۋاب قىلىپ: — مەن سىلىگە: — «پەرۋەردىگارنىڭ ماڭا ئېيتقانلىرىنىڭ ھەممىسىگە ئەمەل قىلمىسام بولمايدۇ» دېگەن ئەمەسمىدىم؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","بالاق بالائامغا: — كەلسىلە، مەن سىلىنى باشقا بىر يەرگە ئاپىراي، خۇدانىڭ نەزىرىدە سىلى شۇ يەردە تۇرۇپ ئۇلارنى قارغاشلىرى مۇۋاپىق تېپىلارمىكىن؟ — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","شۇنىڭ بىلەن بالاق بالائامنى باشلاپ، چۆل-باياۋانغا قارايدىغان پېئور تېغىنىڭ چوققىسىغا كەلدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بالائام بالاققا: — سىلى بۇ يەردە ماڭا يەتتە قۇربانگاھ سالدۇرۇپ بەرسىلە، يەتتە بۇقا بىلەن يەتتە قوشقارمۇ تەييارلاپ بەرسىلە، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","بالاق بالائامنىڭ دېگىنىدەك قىلدى، ھەربىر قۇربانگاھقا بىردىن بۇقا بىلەن بىردىن قوچقار سۇندى. ");
INSERT INTO uigara_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","بالائام پەرۋەردىگارنىڭ ئىسرائ‍ىللارغا بەخت-بەرىكەت ئاتا قىلىشنى مۇۋاپىق كۆرگەنلىكىنى كۆرۈپ يېتىپ، ئالدىنقى ئىككى قېتىمقىدىكىدەك سېھىر ئىشلىتىشكە بارمىدى، بەلكى يۈزىنى چۆل-باياۋان تەرەپكە قاراتتى. ");
INSERT INTO uigara_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","بالائام بېشىنى كۆتۈرۈپ ئىسرائ‍ىللارنىڭ قەبىلە بويىچە چېدىرلاردا ئولتۇراقلاشقانلىقىنى كۆردى، خۇدانىڭ روھى ئۇنىڭ ئۈستىگە چۈشتى. ");
INSERT INTO uigara_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","شۇنىڭ بىلەن ئۇ ئاغزىغا كالام سۆزىنى ئېلىپ مۇنداق دېدى: — «بېئورنىڭ ئوغلى بالائام يەتكۈزىدىغان كالام سۆزى، كۆزى ئېچىلمىغان ئادەمنىڭ ئېيتىدىغان كالام سۆزى، ");
INSERT INTO uigara_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","يەنى تەڭرىنىڭ سۆزلىرىنى ئاڭلىغۇچى، ھەممىگە قادىرنىڭ ئالامەت كۆرۈنۈشىنى كۆرگۈچى، مانا ئەمدى كۆزى ئېچىلىپ دۈم يىقىلغان كىشى يەتكۈزگەن كالام سۆزى: — ");
INSERT INTO uigara_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ئاھ ياقۇپ، چېدىرلىرىڭ نەقەدەر گۈزەل، تۇرالغۇلىرىڭ نەقەدەر گۈزەل، ئاھ ئىسرائىل! ");
INSERT INTO uigara_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","گويا كېڭەيگەن دەريا ۋادىلىرىدەك، خۇددى دەريا بويىدىكى باغلاردەك، گويا پەرۋەردىگار تىكىپ ئۆستۈرگەن ئۇد دەرەخلىرىدەك، دەريا بويىدىكى كېدىر دەرەخلىرىدەك؛ ");
INSERT INTO uigara_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","سۇلار ئۇنىڭ سوغىلىرىدىن ئېقىپ چىقىدۇ، ئەۋلادلىرى سۈيى مول جايلاردا بولىدۇ؛ پادىشاھى ئاگاگدىن ئېشىپ كېتىدۇ، ئۇنىڭ پادىشاھلىقى ئۈستۈن قىلىنىپ گۈللىنىدۇ.    ");
INSERT INTO uigara_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","تەڭرى ئۇنى مىسىردىن ئېلىپ چىققان، ئۇنىڭدا ياۋا بۇقىنىڭ كۈچى باردۇر؛ دۈشمەن ئەللەرنى ئۇ يەپ كېتىدۇ، ئۇستىخانلىرىنى ئېزىپ تاشلايدۇ، ئوقيا ئېتىپ ئۇلارنى تېشىپ تاشلايدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ئۇ باغىرلاپ ياتسا، ئەركەك شىردەك، ياتسا ھەم چىشى شىردەك، كىم ئۇنى قوزغىتىشقا پېتىنار؟ كىم ساڭا بەخت-بەرىكەت تىلىسە، بەخت-بەرىكەت تاپىدۇ. كىم سېنى قارغىسا، قارغىشقا كېتىدۇ». ");
INSERT INTO uigara_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","بالاق بالائامغا ئاچچىقلىنىپ، قولىنى قولىغا ئۇرۇپ كەتتى؛ بالاق بالائامغا: — مەن سىلىنى دۈشمىنىمنى قارغاپ بېرىشكە قىچقىرتقانىدىم ۋە مانا، سىلى ئۈچ قېتىم پۈتۈنلەي ئۇلارغا ئامەت تىلىدىلە! ");
INSERT INTO uigara_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ئەمدى تېزدىن يۇرتلىرىغا قېچىپ كەتسىلە؛ مەن ئەسلىدە سىلىنىڭ ئىززەت-ھۆرمەتلىرىنى كاتتا قىلاي دېگەنىدىم، مانا پەرۋەردىگار سىلىنى بۇ كاتتا ئىززەت-ھۆرمەتكە نائىل بولۇشتىن توسۇپ قويدى، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بالائام بالاققا: — مەن ئەسلىدە ئۆزلىرىنىڭ ئەلچىلىرىگە: ");
INSERT INTO uigara_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","«بالاق ماڭا ئۆزىنىڭ ئالتۇن-كۈمۈشكە لىق تولغان ئۆز ئۆيىنى بەرسىمۇ، پەرۋەردىگارنىڭ بۇيرۇغىنىدىن ھالقىپ، ئۆز مەيلىمچە ياخشى-يامان ئىش قىلالمايمەن؛ پەرۋەردىگار ماڭا نېمە دېسە، مەن شۇنى دەيمەن» دېگەن ئەمەسمىدىم؟ ");
INSERT INTO uigara_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ئەمدى مەن ئۆز خەلقىمگە قايتىمەن؛ كەلسىلە، مەن ئۆزلىرىگە بۇ خەلقنىڭ كۈنلەرنىڭ ئاخىرىدا سىلىنىڭ خەلقلىرىگە قانداق مۇئامىلە قىلىدىغانلىقىنى ئېيتىپ بېرەي، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ئۇ كالام سۆزىنى ئاغزىغا ئېلىپ مۇنداق دېدى: — بېئورنىڭ ئوغلى بالائام يەتكۈزىدىغان كالام سۆزى، كۆزلىرى ئېچىلمىغان كىشى ئېيتقان كالام سۆزى، ");
INSERT INTO uigara_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","تەڭرىنىڭ سۆزلىرىنى ئاڭلىغۇچى، ھەممىدىن ئالىينىڭ ۋەھىيلىرىنى بىلگۈچى، ھەممىگە قادىرنىڭ ئالامەت كۆرۈنۈشىنى كۆرگۈچى، مانا ئەمدى كۆزى ئېچىلغان دۈم يىقىلىغان كىشى يەتكۈزىدىغان كالام سۆزى: — ");
INSERT INTO uigara_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","مەن ئۇنى كۆرىمەن، لېكىن ھازىر ئەمەس؛ مەن ئۇنىڭغا قارايمەن، لېكىن يېقىن يەردىن ئەمەس؛ ياقۇپتىن چىقار بىر يۇلتۇز، كۆتۈرۈلەر ئىسرائىلدىن بىر شاھانە ھاسا؛ چېقىۋېتەر ئۇ موئابنىڭ چېكىسىنى، بارلىق شېتلەرنىڭ بېشىنى يانجىيدۇ.    ");
INSERT INTO uigara_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ئېدوم ئۇنىڭغا تەۋە بولىدۇ، يەنە تېخى دۈشمىنى سېئىرلار ئۇنىڭغا تەۋە بولىدۇ؛ ئىسرائىل بولسا باتۇرلۇق قىلىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ياقۇپتىن چىققان بىرى سەلتەنەت سۈرىدۇ، شەھەردە قالغان ھەممەيلەننى يوقىتىدۇ».    ");
INSERT INTO uigara_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ئاندىن بالائام ئامالەكنى كۆرۈپ، مۇنداق كالام سۆزىنى ئېيتتى: — «ئامالەك ئىدى ئەسلى ئەللەر ئارىسىدا باش، ئەمدى ھالاكەتتۇر تەقدىر-قىسمىتى». ");
INSERT INTO uigara_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ئاندىن بالائام كېنىيلەرنى كۆرۈپ مۇنداق كالام سۆزىنى ئېيتتى: — «سېنىڭ ماكانىڭ مۇستەھكەم بولۇپ، چاڭگاڭ قورام تاش ئىچىدە بولسىمۇ، ");
INSERT INTO uigara_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","لېكىن سىلەر كېنىيلەر ھالاك قىلىنىپ تۇرىسىلەر؛ تاكى ئاشۇر سىلەرنى تۇتقۇن قىلىپ كەتكۈچە». ");
INSERT INTO uigara_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","بالائام يەنە كالام سۆزىنى داۋام قىلىپ مۇنداق دېدى: — «ئاھ ، تەڭرى بۇ ئىشلارنى قىلغان چېغىدا، كىم تىرىك قېلىشقا قادىر بولار؟ ");
INSERT INTO uigara_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","كىتتىم تەرەپلىرىدىن كېمىلەر كېلىپ، زۇلۇم-زەخمەت سالىدۇ ئاشۇرغا، زۇلۇم-زەخمەت سالىدۇ ئېبەرگە؛ لېكىن كىتتىمدىن كەلگۈچى ئۆزىمۇ ھالاكەتكە يۈزلىنەر». ");
INSERT INTO uigara_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","شۇنىڭ بىلەن بالائام ئورنىدىن قوپۇپ ئۆز يۇرتىغا قايتتى؛ بالاقمۇ ئۆز يولىغا ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ئىسرائ‍ىللار شىتتىمدا تۇرغان مەزگىلدە، خەلق موئاب قىزلىرى بىلەن بۇزۇقلۇق قىلىشقا بېرىلىپ كەتتى. ");
INSERT INTO uigara_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ئۇ قىزلار ئىسرائ‍ىللارنى ئۆز ئىلاھلىرىغا ئاتالغان قۇربانلىقلارغا قاتنىشىشقا چاقىردى؛ ئىسرائ‍ىللارمۇ قۇربانلىقلاردىن يەيدىغان، ئۇلارنىڭ ئىلاھلىرىغا بىرلىكتە چوقۇنىدىغان بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ئىسرائ‍ىللار بائال-پېئور بىلەن ئەنە شۇ تەرىقىدە باغلىنىپ كەتكەنلىكى ئۈچۈن، پەرۋەردىگارنىڭ ئىسرائ‍ىللارغا ئاچچىقى قوزغالدى.    ");
INSERT INTO uigara_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","پەرۋەردىگار مۇساغا: — پەرۋەردىگارنىڭ قاتتىق غەزىپى ئىسرائ‍ىللارغا چۈشمىسۇن ئۈچۈن، خەلقنىڭ ئەمىرلىرىنىڭ ھەممىسىنى تۇتۇپ، ئۇلارنى مېنىڭ ئالدىمدا ئاپتاپتا ئېسىپ قويغىن، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","شۇنىڭ بىلەن مۇسا ئىسرائىلنىڭ سوراقچىلىرىغا: — سىلەر بېرىپ ھەربىرىڭلار ئۆزۈڭلارنىڭ بائال-پېئور بىلەن باغلىنىپ كەتكەن ئادەملىرىنى ئۆلتۈرۈۋېتىڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ۋە مۇسا پۈتكۈل ئىسرائىل جامائىتى بىلەن جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىدا يىغا-زار قىلىپ تۇرۇۋاتقاندا، مانا ئىسرائ‍ىللاردىن بىرەيلەن كېلىپ ئۇلارنىڭ كۆز ئالدىدىلا مىدىيانىي بىر قىزنى ئۆز قېرىنداشلىرىنىڭ يېنىغا ئېلىپ ماڭدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","كاھىن ھارۇننىڭ نەۋرىسى، ئەلىئازارنىڭ ئوغلى فىنىھاس بۇنى كۆرۈپ، جامائەت ئىچىدىن قوپتى-دە، قولىغا نەيزە ئېلىپ، ");
INSERT INTO uigara_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ھېلىقى ئىسرائىل ئادەمنىڭ ئارقىسىدىن چېدىرنىڭ ئىچكىرىگە كىرىپ، قىز بىلەن ئىككىسىنىڭ قارنىغا نەيزە تىقىۋەتتى. ئىسرائ‍ىللار ئارىسىدا تارقالغان ۋابا ئەنە شۇ چاغدىلا توختىدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","شۇ چاغدا ۋابا تېگىپ ئۆلگەنلەر جەمئىي يىگىرمە تۆت مىڭ ئادەمگە يەتكەنىدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ئاندىن پەرۋەردىگار مۇساغا مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","— «كاھىن ھارۇننىڭ نەۋرىسى، ئەلىئازارنىڭ ئوغلى فىنىھاس مېنى دەپ ۋاپاسىزلىققا بولغان ھەسىتىمنى ئۆز ھەسىتى بىلىپ، مېنىڭ ئىسرائ‍ىللارغا بولغان غەزىپىمنى ياندۇردى. شۇڭا گەرچە مەن ۋاپاسىزلىققا بولغان ھەسىتىمدىن غەزەپلەنگەن بولساممۇ، ئىسرائ‍ىللارنى يوقىتىۋەتمىدىم. ");
INSERT INTO uigara_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","شۇڭا سەن: — «مانا، مەن ئۇنىڭغا ئۆز ئامان-خاتىرجەملىك ئەھدەمنى تەقدىم قىلىمەن! ");
INSERT INTO uigara_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","بۇ ئەھدە ئۇنىڭغا ۋە ئۇنىڭ ئەۋلادلىرىغا تەۋە بولىدىغان مەڭگۈلۈك كاھىنلىق ئەھدىسى بولىدۇ، چۈنكى ئۇ ئۆز خۇداسىنى دەپ ۋاپاسىزلىققا ھەسەت قىلىپ، ئىسرائ‍ىللار ئۈچۈن كەفارەت كەلتۈردى» — دەپ جاكارلىغىن». ");
INSERT INTO uigara_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ئۆلتۈرۈلگەن يەنى ھېلىقى مىدىيانىي قىز بىلەن بىللە ئۆلتۈرۈلگەن ئىسرائىل ئادەمنىڭ ئىسمى زىمرى بولۇپ، سالۇنىڭ ئوغلى، شىمېئون قەبىلىسىدىكى بىر جەمەتنىڭ ئەمىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ئۆلتۈرۈلگەن مىدىيانىي قىزنىڭ ئىسمى كوزبى بولۇپ، زۇرنىڭ قىزى ئىدى؛ زۇر بولسا مىدىيانىي بىر قەبىلىنىڭ باشلىقى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","پەرۋەردىگار مۇساغا: — ");
INSERT INTO uigara_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","سەن مىدىيانىيلارغا ئارام بەرمەي زەربە بەرگىن؛ ");
INSERT INTO uigara_vpl VALUES ("NU25_18‏","005_25_18‏","NUM","25","18‏","19","چۈنكى ئۇلار ھىيلە-مىكىر ئىشلىتىپ سىلەرگە ئارام بەرمىگەن؛ پېئوردىكى ئىشتا، شۇنداقلا ئۇلارنىڭ سىڭلىسى بولغان مىدىياننىڭ بىر ئەمىرىنىڭ قىزى كوزبىنىڭ ئىشىدىمۇ ھىيلە-مىكىر ئىشلىتىپ سىلەرنى ئازدۇرغان، — دېدى. كوزبى ۋابا تارقالغان كۈنىدە پېئوردىكى ئىش سەۋەبىدىن ئۆلتۈرۈلدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ۋابادىن كېيىن پەرۋەردىگار مۇسا بىلەن ھارۇننىڭ ئوغلى ئەلىئازارغا سۆز قىلىپ: — ");
INSERT INTO uigara_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","سىلەر پۈتكۈل ئىسرائ‍ىللارنىڭ جامائىتى ئىچىدە يىگىرمە ياشتىن ئاشقان، جەڭگە چىقالايدىغانلارنى ئاتا جەمەتى بويىچە ھېسابلاپ ساناقتىن ئۆتكۈزۈڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","شۇنىڭ بىلەن مۇسا بىلەن كاھىن ئەلىئازار موئاب تۈزلەڭلىكلىرىدە، يەنى يېرىخونىڭ يېنىدىكى ئىئوردان دەرياسىنىڭ بويىدا ئىسرائ‍ىللار بىلەن سۆزلىشىپ ئۇلارغا: ");
INSERT INTO uigara_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«پەرۋەردىگارنىڭ مۇسا ۋە مىسىردىن چىققان ئىسرائ‍ىللارغا بۇيرۇغىنى بويىچە، سىلەردىن يىگىرمە ياشتىن ئاشقانلارنىڭ ھەممىسى تىزىملىنىپ ساناقتىن ئۆتكۈزۈلۈشى كېرەك» دەپ ئۇقتۇردى. تىزىملىتىلغان سانلار مۇنداق بولدى: —    ");
INSERT INTO uigara_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ئىسرائىلنىڭ تۇنجى ئوغلى رۇبەن ئىدى. رۇبەننىڭ ئەۋلادلىرى، يەنى ھانۇقنىڭ نەسلىدىن بولغان ھانۇق جەمەتى؛ پاللۇنىڭ نەسلىدىن بولغان پاللۇ جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ھەزرون نەسلىدىن بولغان ھەزرون جەمەتى؛ كارمى نەسلىدىن بولغان كارمى جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","بۇلار رۇبەننىڭ جەمەتلىرى بولۇپ، ئۇلاردىن ساناقتىن ئۆتكۈزۈلگىنى جەمئىي قىرىق ئۈچ مىڭ يەتتە يۈز ئوتتۇز كىشى بولدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","پاللۇنىڭ ئوغلى ئېلىئاب؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ئېلىئابنىڭ ئوغۇللىرى نىمۇئەل، داتان، ئابىرام ئىدى. داتان بىلەن ئابىرام ئەسلىدە جامائەت ئىچىدىن چاقىرىلغان مۆتىۋەرلەر بولسىمۇ، كوراھ گۇرۇھىدىكىلەر پەرۋەردىگار بىلەن تاكاللاشقاندا، ئۇلار بىلەن بىرلىشىپ مۇسا ۋە ھارۇن بىلەن تاكاللاشقانىدى.    ");
INSERT INTO uigara_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","يەر ئاغزىنى ئېچىپ ئۇلارنى كوراھ بىلەن بىرگە يۇتۇپ كەتكەن؛ شۇ چاغدا كوراھ گۇرۇھىدىكىلەرنىڭ ھەممىسى ئۆلگەن؛ باشقىلارغا ئىبرەت بولسۇن دەپ، ئوت ئۇنىڭ ئىككى يۈز ئەللىك ئادىمىنى يۇتۇپ كەتكەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","لېكىن كوراھنىڭ ئەۋلادلىرى ئۆلۈپ كەتمىگەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","شىمېئوننىڭ ئەۋلادلىرى، جەمەت بويىچە، نەمۇئەلنىڭ نەسلىدىن بولغان نەمۇئەل جەمەتى؛ يامىن نەسلىدىن بولغان يامىن جەمەتى؛ ياقىن نەسلىدىن بولغان ياقىن جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","زەراھ نەسلىدىن بولغان زەراھ جەمەتى؛ سائۇل نەسلىدىن بولغان سائۇل جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","بۇلار شىمېئوننىڭ جەمەتلىرى بولۇپ، جەمئىي يىگىرمە ئىككى مىڭ ئىككى يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","گاد قەبىلىسىدىن، جەمەت بويىچە، زەفون نەسلىدىن بولغان زەفون جەمەتى؛ ھاگگى نەسلىدىن بولغان ھاگگى جەمەتى؛ شۇنى نەسلىدىن بولغان شۇنى جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ئوزنى نەسلىدىن بولغان ئوزنى جەمەتى؛ ئېرى نەسلىدىن بولغان ئېرى جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ئارود نەسلىدىن بولغان ئارود جەمەتى؛ ئارئەلى نەسلىدىن بولغان ئارئەلى جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","بۇلار گاد ئەۋلادلىرىنىڭ جەمەتلىرى بولۇپ، ئۇلار جەمەتلىرى بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي قىرىق مىڭ بەش يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","يەھۇدانىڭ ئوغۇللىرى ئېر بىلەن ئونان ئىدى؛ بۇ ئىككىسى قانائان زېمىنىدا ئۆلۈپ كەتكەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","يەھۇدانىڭ ئەۋلادلىرى، جەمەتى بويىچە، شىلاھنىڭ نەسلىدىن بولغان شىلاھ جەمەتى؛ پەرەزنىڭ نەسلىدىن بولغان پەرەز جەمەتى؛ زەراھنىڭ نەسلىدىن بولغان زەراھ جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","پەرەزنىڭ ئەۋلادلىرى ھەزروننىڭ نەسلىدىن بولغان ھەزرون جەمەتى؛ ھامۇلنىڭ نەسلىدىن بولغان ھامۇل جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","بۇلار يەھۇدانىڭ جەمەتلىرى بولۇپ، ئۇلار جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي يەتمىش ئالتە مىڭ بەش يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ئىسساكارنىڭ ئەۋلادلىرى، جەمەت بويىچە، تولانىڭ نەسلىدىن بولغان تولا جەمەتى؛ پۇئاھنىڭ نەسلىدىن بولغان پۇئاھ جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ياشۇبنىڭ نەسلىدىن بولغان ياشۇب جەمەتى؛ شىمروننىڭ نەسلىدىن بولغان شىمرون جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","بۇلار ئىسساكارنىڭ جەمەتلىرى بولۇپ، ئۇلار جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئاتمىش تۆت مىڭ ئۈچ يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","زەبۇلۇننىڭ ئەۋلادلىرى، جەمەتى بويىچە، سەرەدنىڭ نەسلىدىن بولغان سەرەد جەمەتى؛ ئېلون نەسلىدىن بولغان ئېلون جەمەتى؛ جاھلىيەلنىڭ نەسلىدىن بولغان جاھلىيەل جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","بۇلار زەبۇلۇننىڭ جەمەتلىرى بولۇپ، ئۇلار جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئاتمىش مىڭ بەش يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","يۈسۈپنىڭ ئوغۇللىرى: — جەمەت بويىچە، ماناسسەھ بىلەن ئەفرائىم ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ماناسسەھنىڭ ئەۋلادلىرى: — ماكىرنىڭ نەسلىدىن بولغان ماكىر جەمەتى ‹ماكىردىن گىلېئاد تۆرەلگەن›، گىلېئادنىڭ نەسلىدىن بولغان گىلېئاد جەمەتى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","تۆۋەندىكىلەر گىلېئادنىڭ ئەۋلادلىرى: — يەئەزەرنىڭ نەسلىدىن بولغان يەئەزەر جەمەتى؛ ھەلەكنىڭ نەسلىدىن بولغان ھەلەك جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ئاسرىيەلنىڭ نەسلىدىن بولغان ئاسرىيەل جەمەتى؛ شەكەمنىڭ نەسلىدىن بولغان شەكەم جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","شەمىدانىڭ نەسلىدىن بولغان شەمىدا جەمەتى؛ ھەفەرنىڭ نەسلىدىن بولغان ھەفەر جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ھەفەرنىڭ ئوغلى زەلوفىھاد ئوغۇل پەرزەنت كۆرمەي قىز پەرزەنت كۆرگەن؛ زەلوفىھادنىڭ قىزلىرىنىڭ ئىسمى ماھلاھ، نوئاھ، ھوگلاھ، مىلكاھ، تىرزاھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","بۇلار ماناسسەھنىڭ جەمەتلىرى بولۇپ، ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئەللىك ئىككى مىڭ يەتتە يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","تۆۋەندىكىلەر ئەفرائىمنىڭ ئەۋلادلىرى، جەمەتى بويىچە: — شۇتىلاھنىڭ نەسلىدىن بولغان شۇتىلاھ جەمەتى؛ بەكەرنىڭ نەسلىدىن بولغان بەكەر جەمەتى؛ تاھاننىڭ نەسلىدىن بولغان تاھان جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","شۇتىلانىڭ ئەۋلادلىرى ئېراننىڭ نەسلىدىن بولغان ئېران جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","مانا بۇلار ئەفرائىم ئەۋلادلىرىنىڭ جەمەتلىرى بولۇپ، ھەرقايسى جەمەتلەر بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئوتتۇز ئىككى مىڭ بەش يۈز ئادەم چىقتى. جەمەتلىرى بويىچە، ئۇلارنىڭ ھەممىسى يۈسۈپنىڭ ئەۋلادلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","بىنيامىننىڭ ئەۋلادلىرى، جەمەتى بويىچە، بېلانىڭ نەسلىدىن بولغان بېلا جەمەتى؛ ئاشبەلنىڭ نەسلىدىن بولغان ئاشبەل جەمەتى؛ ئاھىرامنىڭ نەسلىدىن بولغان ئاھىرام جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","شەفۇفامنىڭ نەسلىدىن بولغان شۇفام جەمەتى؛ ھۇفامنىڭ نەسلىدىن بولغان ھۇفام جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ئارد بىلەن نائامان بېلانىڭ ئوغۇللىرى ئىدى؛ ئاردنىڭ نەسلىدىن بولغان ئارد جەمەتى؛ نائاماننىڭ نەسلىدىن بولغان نائامان جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","بۇلار بىنيامىننىڭ ئەۋلادلىرى بولۇپ، جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي قىرىق بەش مىڭ ئالتە يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","تۆۋەندىكىلەر داننىڭ ئەۋلادلىرى بولۇپ، جەمەت بويىچە، شۇھامنىڭ نەسلىدىن بولغان شۇھام جەمەتى؛ جەمەت بويىچە بۇلار داننىڭ جەمەتلىرى ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","شۇھامنىڭ ھەممە جەمەتى ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئاتمىش تۆت مىڭ تۆت يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ئاشىرنىڭ ئەۋلادلىرى، جەمەت بويىچە، يىمناھنىڭ نەسلىدىن بولغان يىمناھ جەمەتى؛ يىشۋىنىڭ نەسلىدىن بولغان يىشۋى جەمەتى؛ بېرىياھنىڭ نەسلىدىن بولغان بېرىياھ جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","بېرىياھنىڭ ئەۋلادلىرى، جەمەت بويىچە، ھەبەرنىڭ نەسلىدىن بولغان ھەبەر جەمەتى؛ مالكىئەلنىڭ نەسلىدىن بولغان مالكىئەل جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ئاشىرنىڭ قىزىنىڭ ئىسمى سېراھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","بۇلار ئاشىر ئەۋلادلىرىنىڭ جەمەتلىرى بولۇپ، ئۇلار جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي ئەللىك ئۈچ مىڭ تۆت يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","نافتالىنىڭ ئەۋلادلىرى، جەمەت بويىچە، ياھزىئەلنىڭ نەسلىدىن بولغان ياھزىئەل جەمەتى؛ گۇنىنىڭ نەسلىدىن بولغان گۇنى جەمەتى؛ ");
INSERT INTO uigara_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","يەزەرنىڭ نەسلىدىن بولغان يەزەر جەمەتى؛ شىللەمنىڭ نەسلىدىن بولغان شىللەم جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","بۇلار نافتالىنىڭ جەمەتلىرى بولۇپ، جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەندە جەمئىي قىرىق بەش مىڭ تۆت يۈز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","يۇقىرىقىلار ئىسرائ‍ىللاردىن ساناقتىن ئۆتكۈزۈلگەنلەر بولۇپ، جەمئىي ئالتە يۈز بىر مىڭ يەتتە يۈز ئوتتۇز ئادەم چىقتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","زېمىن مۇشۇلارغا رويخەتكە ئېلىنغان سان بويىچە مىراس قىلىپ تەقسىم قىلىنسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","مىراسنى ئادەم سانى كۆپ قەبىلىلەرگە كۆپرەك، ئادەم سانى ئاز قەبىلىلەرگە ئازراق بۆل؛ مىراس رويخەتتىن ئۆتكۈزۈلگەن ئادەم سانىغا قاراپ ھەربىر ئادەمگە بۆلۈپ بېرىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ھالبۇكى، زېمىن چەك تاشلىنىش يولى بىلەن بۆلۈنسۇن؛ ئۇلار مىراسقا ئۆزلىرىنىڭ ئاتا جەمەت-قەبىلىسىنىڭ نامى بويىچە ۋارىسلىق قىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","مىراس ئۇلارغا چەك تاشلاش يولى بىلەن ئادەم سانىنىڭ ئاز-كۆپلۈكىگە قاراپ ھەربىر ئائىلە-جەمەتكە بۆلۈپ بېرىلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","تۆۋەندىكىلەر ئاتا جەمەت بويىچە ساناقتىن ئۆتكۈزۈلگەن لاۋىيلار: — گەرشوننىڭ نەسلىدىن بولغان گەرشون جەمەتى؛ كوھاتنىڭ نەسلىدىن بولغان كوھات جەمەتى؛ مەرارىنىڭ نەسلىدىن بولغان مەرارى جەمەتى. ");
INSERT INTO uigara_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","بۇلار لاۋىيلارنىڭ جەمەتلىرى: — لىبنى جەمەتى، ھېبرون جەمەتى، ماھلى جەمەتى، مۇشى جەمەتى، كوراھ جەمەتى. كوھاتتىن ئامرام تۆرەلگەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ئامرامنىڭ ئايالىنىڭ ئىسمى يوكەبەد بولۇپ، لاۋىينىڭ مىسىردا تۇغۇلغان قىزى ئىدى؛ ئۇ ئامرامغا ھارۇن، مۇسا ۋە ئۇلارنىڭ ئاچىسى مەريەمنى تۇغۇپ بەرگەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ھارۇندىن ناداب، ئابىھۇ، ئەلىئازار، ئىتامار تۆرەلگەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","لېكىن ناداب بىلەن ئابىھۇ پەرۋەردىگارنىڭ ئالدىغا غەيرىي بىر ئوتنى سۇنغاندا ئۆلۈپ كەتكەن.    ");
INSERT INTO uigara_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","لاۋىيلار ئىچىدە بىر ئايلىقتىن ئاشقان بارلىق ئەركەكلەر ساناقتىن ئۆتكۈزۈلگەندە جەمئىي يىگىرمە ئۈچ مىڭ ئادەم چىقتى. ئۇلار ئىسرائ‍ىللار ئىچىدە ساناقتىن ئۆتكۈزۈلمىگەن، چۈنكى ئۇلارغا ئىسرائ‍ىللار ئىچىدە ھېچقانداق مىراس زېمىن بۆلۈپ بېرىلمىگەن. ");
INSERT INTO uigara_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","يۇقىرىدا ئېيتىلغان ئادەملەر موئاب تۈزلەڭلىكلىرىدە، يېرىخونىڭ ئۇدۇلىدىكى ئىئوردان دەرياسى بويىدا مۇسا بىلەن كاھىن ئەلىئازار تەرىپىدىن ساناقتىن ئۆتكۈزۈلگەن ئىسرائ‍ىللاردۇر. ");
INSERT INTO uigara_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","بىراق بۇ ئادەملەر ئىچىدە مۇسا بىلەن كاھىن ھارۇن ئىلگىرى سىناي چۆلىدە ساناقتىن ئۆتكۈزگەندە ساناقتىن ئۆتكۈزۈلگەن بىرمۇ ئادەم يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","چۈنكى پەرۋەردىگار ئۇلار توغرىسىدا: «ئۇلار چۆلدە ئۆلمەي قالمايدۇ» دەپ ئېيتقانىدى. شۇڭا، يەفۇننەھنىڭ ئوغلى كالەب بىلەن نۇننىڭ ئوغلى يەشۇئادىن باشقا بىرىمۇ قالمىغان. ");
INSERT INTO uigara_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","يۈسۈپنىڭ ئوغلى ماناسسەھنىڭ نەسلىدىن بولغان جەمەتلەر ئىچىدە ماناسسەھنىڭ چەۋرىسى، ماكىرنىڭ ئەۋرىسى، گىلېئادنىڭ نەۋرىسى، ھەفەرنىڭ ئوغلى زەلوفىھادنىڭ قىزلىرى بولۇپ، ئۇلارنىڭ ئىسمى ماھلاھ، نوئاھ، ھوگلاھ، مىلكاھ، ۋە تىرزاھ ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ئۇلار جامائەت چېدىرىنىڭ دەرۋازىسى ئالدىغا كېلىپ، مۇسا بىلەن كاھىن ئەلىئازار ۋە ئەمىرلەر بىلەن پۈتكۈل جامائەتنىڭ ئالدىدا تۇرۇپ: ");
INSERT INTO uigara_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","— بىزنىڭ ئاتىمىز چۆلدە ئۆلۈپ كەتكەن؛ ئۇ ئۇ يەردە پەرۋەردىگارغا ھۇجۇم قىلغىلى يىغىلغانلاردىن ئەمەس، يەنى كوراھ گۇرۇھىدىكىلەردىن ئەمەس؛ ئۇ بەلكى ئۆز گۇناھى ئىچىدە ئۆلگەن، ۋە ئۇنىڭ ئوغۇل پەرزەنتى يوق ئىدى. ");
INSERT INTO uigara_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","نېمە ئۈچۈن ئاتىمىزنىڭ ئوغلى يوقلۇقى سەۋەبلىك ئۇنىڭ نامى ئۇنىڭ جەمەتىدىن ئۆچۈرۈۋېتىلىدۇ؟ ئۆزلىرىنىڭ بىزگە ئاتىمىزنىڭ قېرىنداشلىرى قاتارىدا مىراس بۆلۈپ بېرىشلىرىنى ئۆتۈنىمىز، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","مۇسا ئۇلارنىڭ بۇ ئىشىنى پەرۋەردىگارنىڭ ئالدىغا قويدى. ");
INSERT INTO uigara_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","زەلوفىھادنىڭ قىزلىرىنىڭ ئېيتقىنى دۇرۇس، سەن چوقۇم ئۇلارغا ئاتىسىنىڭ قېرىنداشلىرى قاتارىدا مىراس بەر؛ ئۇلارنىڭ ئاتىسىنىڭ مىراسىنى ئۇلارغا ئۆتكۈزۈپ بەرگىن. ");
INSERT INTO uigara_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","سەن ئىسرائ‍ىللارغا ئېيتقىن: «بىر ئادەم ئۆلۈپ كەتكەن چاغدا ئۇنىڭ ئوغلى بولمىسا، ئۇنداقتا سىلەر ئۇنىڭ مىراسىنى قىزىغا ئۆتكۈزۈپ بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","قىزى بولمىسا، مىراسىنى قېرىنداشلىرىغا بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","قېرىنداشلىرى بولمىسا، مىراسىنى ئاتا جەمەت تاغىلىرىغا بېرىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ئەگەر ئۇنىڭ ئاتىسىنىڭ قېرىنداشلىرى بولمىسا، ئۇنداقتا ئۇنىڭ مىراسىنى ئۇنىڭ جەمەتىدىكى ئەڭ يېقىن بىر تۇغقىنىغا بېرىڭلار؛ ئۇ ئادەم ئۇنىڭ مىراسىغا ئىگە بولسۇن. بۇ پەرۋەردىگار مۇساغا بۇيرۇغاندەك، ئىسرائ‍ىللارغا چۈشۈرۈلگەن ھۆكۈم، قانۇن-بەلگىلىمە بولۇپ قالسۇن». ");
INSERT INTO uigara_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","پەرۋەردىگار مۇساغا: — سەن ماۋۇ ئابارىم تېغىغا چىقىپ، مەن ئىسرائ‍ىللارغا تەقدىم قىلغان زېمىنغا قاراپ باق.    ");
INSERT INTO uigara_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","كۆرۈپ بولغاندىن كېيىن سەنمۇ ئاكاڭ ھارۇنغا ئوخشاش ئۆز خەلقلىرىڭگە قوشۇلىسەن.    ");
INSERT INTO uigara_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","چۈنكى زىن چۆلىدە، جامائەت جېدەل چىقارغان چاغدا، ئىككىڭلار مېنىڭ بۇيرۇقىمغا ئاسىيلىق قىلىپ، سۇنىڭ ئىشىدا ‹زىن چۆلىدە، قادەشتىكى «مەرىباھ سۇلىرى» دېگەن جايدا› مېنى جامائەتنىڭ ئالدىدا مۇقەددەس دەپ ھۆرمەتلىمىدىڭلار، — دېدى. ");
INSERT INTO uigara_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","مۇسا پەرۋەردىگارغا سۆز قىلىپ: ");
INSERT INTO uigara_vpl VALUES ("NU27_16‏","005_27_16‏","NUM","27","16‏","17","— ئى پەرۋەردىگار، بارلىق ئەت ئىگىلىرىنىڭ روھلىرىنىڭ خۇداسى، ئۆز جامائىتىنىڭ پادىچىسىز پادىدەك بولۇپ قېلىشىنىڭ ئالدىنى ئېلىش ئۈچۈن جامائەتنى ئىدارە قىلىدىغان، ئۇلارنىڭ ئالدىغا كىرىپ چىقالايدىغان، ئۇلارنى باشلاپ ماڭالايدىغان بىر ئادەمنى تىكلەپ بېرىشىڭنى تىلەيمەن، — دېدى.    ");
INSERT INTO uigara_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","سەن نۇننىڭ ئوغلى يەشۇئانى تاللىغىن، — دېدى پەرۋەردىگار مۇساغا، — ئۇنىڭدا روھىم بار، سەن قولۇڭنى ئۇنىڭ بېشىغا قوي،    ");
INSERT INTO uigara_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ئۇنى كاھىن ئەلىئازار ۋە بارلىق جامائەتنىڭ ئالدىدا تۇرغۇزۇپ ۋەزىپىگە قوي. ");
INSERT INTO uigara_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","سەن پۈتكۈل ئىسرائىل جامائىتى ئۇنىڭ گېپىگە كىرىشى ئۈچۈن ئۆزۈڭنىڭ ئىززەت-شۆھرىتىڭدىن بىر قىسمىنى ئۇنىڭغا بەرگىن. ");
INSERT INTO uigara_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ئۇ كاھىن ئەلىئازارنىڭ ئالدىدا تۇرسۇن، ئەلىئازار ئۇرىمنىڭ ھۆكۈمىنى ۋاسىتە قىلىپ تۇرۇپ، پەرۋەردىگارنىڭ ھۇزۇرىدا ئۇنىڭ ئۈچۈن يول سورىسۇن؛ ئىسرائىل خەلقى، يەنى پۈتكۈل جامائەت ئۇنىڭ بۇيرۇقى بىلەن چىقىدۇ، ئۇنىڭ بۇيرۇقى بىلەن كىرىشى كېرەك.    ");
INSERT INTO uigara_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","شۇنىڭ بىلەن مۇسا پەرۋەردىگارنىڭ بۇيرۇقى بويىچە ئىش كۆرۈپ، يەشۇئانى باشلاپ كېلىپ، كاھىن ئەلىئازارنىڭ ۋە بارلىق جامائەتنىڭ ئالدىدا تۇرغۇزدى؛ ");
INSERT INTO uigara_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ئەلىئازار قولىنى ئۇنىڭ بېشىغا قويۇپ، ئۇنى پەرۋەردىگارنىڭ مۇسانىڭ ۋاسىتىسى بىلەن بۇيرۇغىنىدەك ۋەزىپىگە قويدى. ");
INSERT INTO uigara_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","پەرۋەردىگار مۇساغا سۆز قىلىپ مۇنداق دېدى: — ");
INSERT INTO uigara_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","سەن ئىسرائ‍ىللارغا بۇيرۇپ: — «ماڭا سۇنۇلغان ھەدىيە-قۇربانلىقلارنى، يەنى ماڭا ئوزۇق بولىدىغان، خۇشبۇي كەلتۈرىدىغان ئوتتا سۇنۇلىدىغان ھەدىيە-قۇربانلىقلارنى بولسا، سىلەر ھەربىرىنى بېكىتىلگەن قەرەلىدە سۇنۇشقا كۆڭۈل قويۇڭلار» — دېگىن. ");
INSERT INTO uigara_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","سەن ئۇلارغا يەنە: «سىلەرنىڭ پەرۋەردىگارغا ئاتاپ ئوتتا سۇنىدىغان كۆيدۈرمە قۇربانلىقىڭلار مۇنداق بولىدۇ: — ھەر كۈنى بېجىرىم بىر ياشلىق ئەركەك قوزىدىن ئىككىنى دائىمىي كۆيدۈرمە قۇربانلىق قىلىڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ئەتىگىنى بىرنى، گۇگۇمدا بىرنى سۇنۇڭلار؛ ");
INSERT INTO uigara_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","يەنە تۆتتىن بىر ھىندىن سوقۇپ چىقىرىلغان زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن ئوندىن بىر ئەفاھنى ئاشلىق ھەدىيەسى سۈپىتىدە سۇنۇڭلار.    ");
INSERT INTO uigara_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","سىناي تېغىدا بەلگىلەنگەن، پەرۋەردىگارغا ئاتاپ خۇشبۇي چىقارسۇن دەپ، ئوتتا سۇنۇلىدىغان دائىمىي كۆيدۈرمە قۇربانلىق مانا شۇدۇر. ");
INSERT INTO uigara_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ھەربىر قوزا ئۈچۈن ئۇنىڭغا قوشۇلىدىغان شاراب ھەدىيەسى تۆتتىن بىر ھىن شاراب بولىدۇ؛ ئېچىتما ئىچىملىك بولغان شاراب ھەدىيەسى مۇقەددەس جايدا پەرۋەردىگارغا سۇنۇپ تۆكۈلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","سەن ئىككىنچى بىر قوزىنى گۇگۇمدا سۇنغىن؛ ئۇنى ئەتىگەنكىدەك ئاشلىق ھەدىيەسى ۋە شاراب ھەدىيەسى بىلەن قوشۇپ سۇنغىن؛ ئۇ خۇشبۇي كەلتۈرۈش ئۈچۈن پەرۋەردىگارغا ئاتاپ ئوتتا سۇنۇلىدىغان كۆيدۈرمە قۇربانلىق بولىدۇ. ");
INSERT INTO uigara_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","— شابات كۈنى بېجىرىم بىر ياشلىق ئىككى ئەركەك قوزا سۇنۇلسۇن؛ ئۇنىڭغا قوشۇپ زەيتۇن مېيى ئىلەشتۈرۈلگەن ئېسىل ئۇندىن ئەفاھنىڭ ئوندىن ئىككىسى ئاشلىق ھەدىيەسى سۈپىتىدە سۇنۇلسۇن ۋە شاراب ھەدىيەسى سۇنۇلسۇن؛ ");
INSERT INTO uigara_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","بۇ ھەربىر شابات كۈنىدە سۇنۇلىدىغان شابات كۈنىدىكى قۇربانلىقتۇر؛ ئۇنىڭ بىلەن دائىمىي كۆيدۈرمە قۇربانلىق ۋە قوشۇمچە سۇنۇلىدىغان شاراب ھەدىيەسى بىللە سۇنۇلسۇن. ");
INSERT INTO uigara_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","— ھەر ئاينىڭ بىرىنچى كۈنى پەرۋەردىگارغا ئاتىلىدىغان كۆيدۈرمە قۇربانلىق سۇنۇڭلار؛ يەنى ئىككى ياش تورپاق، بىر قوچقار، بىر ياشلىق بېجىرىم يەتتە ئەركەك قوزىنى سۇنۇڭلار. ");
INSERT INTO uigara_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ھەر تورپاق بېشىغا زەيتۇ