﻿USE sofia;
DROP TABLE IF EXISTS sofia.udu_vpl;
CREATE TABLE udu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES udu_vpl WRITE;
INSERT INTO udu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ka muŋ’kup̱ mo tani Arumgimis uḵki momis dhali mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dhali mony’cesh a’di ’ceṯẖki’da ’thintha/ mo dhali di bwa ’te/ mo, dhali mondhurumi’d a’di wup̱ki’da ap̱o/ mo jin ’kula’kul mo. Dhali Shi/in ma Arumgimis a’di wukurki’d ap̱owa ris ḵumma/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dhali Arumgimis ki o gwo mo ki: Dhalki moŋkush piyi’d mo. Dhali moŋkush diki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dhali Arumgimis p̱arki moŋkush e ki a’di ’bora’bor mo. Dhali Arumgimis ki ḵwa/ moŋkush bwa ’peni mondhurumi’d mo. ");
INSERT INTO udu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Arumgimis ki yuḵ moŋkush ki Montee mo dhali mondhurumi’d yuḵa a’di ki Mon’thiny mo. Dhali mom’pimpili/ diki’d mo dhali mon’thamo/ diki’d mo, a’di jin ta’da cim ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dhali Arumgimis ki o gwo mo ki: Dhalka balany di’d mo ibwaman ḵumma/ yi’de/ mo dhali dhalki a’di ḵwa/a’da ris ḵumma/ yi’de/ bwa mo ’pena ris ḵumma/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Dhali Arumgimis ki uḵa balany mmoḵwa/a ris ḵumma/ yi’de/ bwa mo, uni kun ’kokin e bwaŋ’kwariny ma balany ’pena ris ḵumma/ yi’de/ mo, uni kun ’kokina p̱owa balany mo. Dhali uni ’kokin kan mo. ");
INSERT INTO udu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dhali Arumgimis ki yuḵa balany ki Momis mo. Dhali mom’pimpili/ diki’d mo dhali mon’thamo/ diki’d mo, a’di jin ta’da cim su/ mo. ");
INSERT INTO udu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dhali Arumgimis ki o gwo mo ki: Dhalka ris ḵumma/ yi’de/, uni kun ’kokin e bwaŋ’kwariny momis mo minu tul isi monṯal ’de/ mo e mon ’de/ mo, dhali dhalki moŋḵuthu’d piyi’d mo. Dhali a’di waki’d kan mo. ");
INSERT INTO udu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Arumgimis ki yuḵ mo jin ḵuthaḵu’th ki Mony’cesh mo, dhali aris yi’de/ gwansan kun tulu isi monṯal ’de/ mo tani yuḵkina a’di gway ki Ḵumma/ Yi’de/ mo be. Dhali Arumgimis ki p̱ar a’di e ki a’di ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Dhali Arumgimis ki o gwo mo ki: Dhalka ’cesh ’ka to ale/ ki ton dhii/in mo, to kun minu si kun mini dho’th maman ki emen buni mo, dhali cwa kun mini dho’th maman ki emen buni kun c̱inu uni mo, uni ’baar ka ’deṯe/ ’deṯe/ isi ki e jin ’ko uni ki she/ ki she/ kuku/ mo, ap̱o/ mony’cesh mo. Dhali a’di waki’d kan mo. ");
INSERT INTO udu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Mony’cesh a’di dho’thki ton dhii/in kun ’kana le/ mo, to kun sinu mo kun dhodhi maman mo isi ka ḵa’bany buni kun ’kona e uni ki she/ ki she/ mo, dhali cwa kun dho’thki maman ki emen buni ki she/ ki she/ kun c̱inu uni mo, uni ’baar ki isi e kuku/ mo. Dhali Arumgimis ki p̱ar a’di e mo ki a’di ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Dhali mom’pimpili/ diki’d mo dhali mon’thamo/ diki’d mo, a’di jin ta’da cimi kwara mo. ");
INSERT INTO udu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dhali Arumgimis ki o gwo mo ki: Dhalki moŋkush uni i’kon eya balany gi momis mo mmoḵwa/ montee bwa ’peni mon’thiny mo. Dhali dhalki uni ta jamas mii mo dhali goma yir mo dhali goma tee mo dhali gom yil mo, ");
INSERT INTO udu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","dhali dhalki uni kushi mo mo ’pena balany gi momis mo mmoc̱i moŋkusha p̱o/ mony’cesh mo. Dhali a’di waki’d kan mo. ");
INSERT INTO udu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dhali Arumgimis ki uḵ dhan moŋkush kun caaca isu/ mo, a’di jin ta dhan moŋkush jin caaca mmoji mo jin yuḵu ki montee mo, dhali a’di jin boc̱a is ka kamu/ mmoji mo jin yuḵu ki mon’thiny mo. A’di uḵki’da risa cul si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dhali Arumgimis ki dhu uni eya balany gi momis mo mmoc̱i moŋkush buni ap̱o/ mony’cesh mo, ");
INSERT INTO udu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","mmoji mo jin yuḵu ki montee mo dhali ap̱o/ mon’thiny mo, dhali mmoḵwa/ moŋkush bwa ’peni mondhurumi’d mo. Dhali Arumgimis ki p̱ar a’di e mo ki a’di ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Dhali mom’pimpili/ diki’d mo dhali mon’thamo/ diki’d mo, a’di jin ta’da cimi doŋon mo. ");
INSERT INTO udu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dhali Arumgimis ki o gwo mo ki: Dhalka ris yi’de/ dhodhona risa waambuhany to/e kun uḵu mo, dhali dhalka ris ’dii p̱ena ap̱o/ mony’cesh mmo’ciṯẖ ka ’ciṯẖan dhul ap̱owa balany gi momis mo. ");
INSERT INTO udu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Wakan Arumgimis ki uḵ dhan to kun ’kon e ḵumma/ yi’de/ kun caaca mo dhala ris to kun ’kon ki e kun ḵalki ya ka bor mo, uni kun ’tu’dki yi’de/ isi ki em buni kun ’ko uni kuku/ mo, dhala ris ’dii kun ’kan ma bi mo isi ki em buni kun ’ko uni kuku/ mo. Dhali Arumgimis ki p̱ar a’di e mo ki a’di ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Dhali Arumgimis ki ’bor uni mii mo, mmo/o gwo mo ki: Dhodhi maman mo, dhali mari is mo dhali ’tu’di aris yi’de/ ki piny piny mo e bwam uni kun ta ḵumma/ yi’de/ mo, dhali dhalka ris ’dii mar is ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Dhali mom’pimpili/ diki’d mo dhali mon’thamo/ diki’d mo, a’di jin ta’da cim ma mudhe’d mo. ");
INSERT INTO udu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dhali Arumgimis ki o gwo mo ki: Dhalki mony’cesh dhodho’da ris to kun ’kon ki e kun uḵu mo isi ki em buni kun ’ko uni kuku/ mo: bip̱ dhali to kun parana ’cesh mo dhali tombwaasho mo kun ’kon e mony’cesh mo isi ki em buni kun ’ko uni ki she/ ki she/ kuku/ mo. Dhali a’di waki’d kan mo. ");
INSERT INTO udu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dhali Arumgimis ki uḵ tonycuḵ kun ’kon e mony’cesh mo isi ki em buni kun ’ko uni ki she/ ki she/ kuku/ mo dhali bip̱ isi ki em buni kun ’ko uni ki she/ ki she/ kuku/ mo, dhali aris to kun parana p̱o/ mony’cesh isi ki em buni kun ’ko uni ki she/ ki she/ kuku/ mo. Dhali Arumgimis ki p̱ar a’di e ki a’di ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Dhali yan’ko’d Arumgimis ki o gwo mo ki: Dhalki ana uḵa wathi/ en’thi/ mo ki jamas bana mo, mmowa e ki jamas bana mo, dhali dhalki uni ta gi mom’bi’th mo ap̱o/ yi’de/ kun ’kon e bwaŋ ḵumma/ yi’de/ mo, dhali ap̱owa ris ’dii kun p̱en e mis mo, dhali ap̱o/ bip̱ mo, dhali ap̱owa ris mony’ceshi ’baar mo, dhali ap̱owa ris to/e kun parana ’cesh mo, uni kun parkin ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Wakan Arumgimis uḵki wathi/ en’thi/ mo ki jamas pitiŋ gana/ mo, ki jamas ma Arumgimis gana/ mo tani a’di i/uḵkina a’di a’di mo. A’di jin ta wathiŋ gwaṯẖ mo dhali a’di jin ta wathim ’bomi mo, uni i/uḵkina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dhali Arumgimis ki ’bor uni mii mo, dhali Arumgimis ki o uni gwo mo ki: Dhodhi maman mo, dhali mari is mo, dhali ’tu’di mony’cesh mo, dhali dili a’di abora ’cesh mo, dhali tayi gi mom’bi’th ap̱o/ to yi’de/ gi ḵumma/ yi’de/ mo dhali ap̱owa ris ’dii kun p̱en e mis mo, dhali ap̱owa ris to kun ’kon ki e kun ḵalki ya ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Dhali Arumgimis ki o gwo mo ki: Hili mo mo ma, aha/ c̱ikina um aris emen to kun minu si mo kun mini dho’th mo uni kun ’kokin ap̱o/ bwam/e gi mony’cesh ’baar mo, dhali arisa ḵa’bany cwa ki maman buni ki she/ ki she/ mo. Um mini bu’th uni haali/ uni mini ta tonṯe/ gom um mo. ");
INSERT INTO udu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Dhala ris tonycuḵ gi mony’cesh mo dhali aris ’dii kun p̱en e momis mo dhala ris to kun parana p̱o/ mony’cesh mo, dhali aris to kun shi/irin kun ’kon ki e mo tani aha/ c̱ikina aris ton dhii/in kun minu si gom tonṯe/ mo. Dhali a’di waki’d kan mo. ");
INSERT INTO udu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Dhali Arumgimis p̱arki aris to/e kun uḵkina a’di mo, dhali hili mo mo ma, a’di ’bora e ki ’bor mo. Dhali mom’pimpili/ diki’d mo, dhali mon’thamo/ diki’d mo, dhali a’di ta’da cim ma pe’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Wakan momis dhali mony’cesh uni ’baarkunu mo dhali aris to kun ’koni bwaman uni mo. ");
INSERT INTO udu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dhali ka cim ma pesu/ mo tani Arumgimis ’baarki miim piti jin miikina a’di mo, dhali a’di ki si is ka cim ma pesu/ ’pena ris miin tom piti kun miikina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Wakan Arumgimis ki ’bora cim ma pesu/ mii mo dhali kar a’di ki she/ ki dhelel dhelel mo, haali/ eya cim ma pesu/ yan mo tani Arumgimis ki si is mo ’pena ris tom piti kun miikina a’di ki uḵ jin uḵkina a’di to mo. ");
INSERT INTO udu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Uni gwansan itana nyaḵum yil ki momis mo dhali mony’cesh mo me’d jin ’konu mmo/uḵ uni mo be. Ka tee jin uḵa Tap̱a Arumgimis mony’cesh mo dhali momis mo tani ");
INSERT INTO udu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ki to jin sinu e mombunto p̱iyi’d e mony’cesh naskina/ mo dhali to jin miinuwa ’tash ’koki ’ko e bunto mo mmo’ka/a le/ naskina/ mo – haali/ Tap̱a Arumgimis diki dhal uniya sho’k bway mo mmohetha p̱o/ mony’cesh mo, dhali wathimpa en’thi/ p̱iyi’d mmoḵora ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Hili jasa shile/ a’di icuki mis ’peni mony’cesh mo dhali ya’th bwam/e gi mony’cesh ki jap̱em piti mo – ");
INSERT INTO udu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","dhali yan’ko’d Arumgimis ki ’diḵil wathimpa en’thi/ ’peni bu’da’cesh mo, dhali p̱i shi/in e shush piti, shi/in jin di ki e mo dhali wathimpa en’thi/ warki’d ki jin di ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Dhali Tap̱a Arumgimis thosonki bwaagoŋ e Idin, e mom’pesho’k mo dhali e mun mo a’di ki kar wathi/ jin uḵkina a’di icine/ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dhali ’pena ’cesh mo tani Tap̱a Arumgimis ki kara ’cesh jin mina cwa ’ka a’diya p̱o/ mo, aris cwa ’baar mo kun ’bora’bor kun minu hil mo dhali kun ’boron kun minu shwa maman ’peni nycine/ mo. Dhali cwa gi mondiki/e si’da/ di’d e bwaman ma goŋ mo dhali cwa jin minu nyiṯẖ to jin ’boro’d dhali jin shiyi’d diki’d si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yi’de/ guski’d ’peni bwaman ma goŋ ma Idin mo, a’di jin wolki’d e bwaagoŋ mo dhali a’di ḵwa/kunu bwa mo mmo’ko ’kusi doŋon mo. ");
INSERT INTO udu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Dhali gway gi yi’de/ jin ṯwa/a/ yuḵu gway ka P̱ishun mo, a’di jin guski’d mmokulum bampa/ gi Pam Hawiila isi ’baar mo e mo jin ’kokina ’dolkon gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dhali ’dolkon gana/ gi mony’cesh yan mo tani uni ’bora’bor mo. Dhala ’bica wasin dhela/ dhala wasin dhela/ jin ta’da jamas kush mo uni ’kokin mo. ");
INSERT INTO udu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dhali gway ḵumma/ yi’de/ jin ’kon ma p̱o/i su/ mo tani yuḵu gway ka Jihun mo, a’din ṯal ’de/ jin guski’d mo mmo’kama ’cesh gi Paŋ Kush is mo. ");
INSERT INTO udu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Dhali ḵumma/ yi’de/ jin ’kon ma p̱o/i kwara mo tani a’di yuḵu gway ka Hiddaagil mo, a’di jin guski’d ’kup̱ki mom’pesho’k ki Pan Ashshuur mo. Dhali yi’de/ jin ’kon ma p̱o/i doŋon mo yuḵu gway ka Elp̱uraat mo. ");
INSERT INTO udu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Dhali Tap̱a Arumgimis ki bu’th wathimpa en’thi/ mo mmokar a’di e bwaagoŋ ma Idin mmoḵorki a’di mo dhali mmokar a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Dhali Tap̱a Arumgimis ḵanki wathimpa en’thi/ gwo mo mmo/o gwo mo ki: /E mini shwa aris cwa gi bwaman bwaagoŋ ’baḵany mo ");
INSERT INTO udu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","hili cwa jin minu ’bi’th e ki miim ’boro’d mo dhali ki mii shiyi’d mo tani /e mini dhalki a’di ki shwa mo, haali/ ka tee jin mina /e shwa a’di mo tani /e mini wu mo be. ");
INSERT INTO udu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Dhali yan’ko’d Tap̱a Arumgimis ki o gwo mo ki: A’di diki ’bor mmokar wathimpa en’thi/ a’di ’de/ kan mo. Aha/ mina mii uḵ ki a’di amanwoṯẖ, a’di jin midi gam ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wakan ’pena ’cesh mo tani Tap̱a Arumgimis ki uḵa ris tombwaasho mo dhali aris ’dii kun p̱en e momis mo, dhali a’di ki ’doyu uni wathimpa en’thi/ mmohil mo ki a’di midi yer uni gway mo, dhali ma gway gunn kun yerkina wathi/ to/e kun uḵkunu mo kun ’ko ki e mo tani a’di ita gway kun yeru uni mo. ");
INSERT INTO udu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Wathi/ en’thi/ ki c̱i aris to/e gway ’baar mo dhali aris ’dii kun p̱en e momis mo dhali aris tombwaasho mo. Hili gom wathi/ en’thi/ mo tani wathi/ p̱iyi’d jin gamkunu jin midi woṯẖ a’di, a’di jin midi gam gom a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Wakan Tap̱a Arumgimis ki dhal mo jin ’ce’du e kagahara mmobiṯa p̱o/ wathimpa en’thi/ mo, dhali ki a’di di’di mmo/ish e mo tani a’di bu’thki’da simaŋ gwar ṯal ’de/ ’peni a’di mo dhali a’di ki ’dap̱ki buŋgwar is ki shuman ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Dhali ’pena simaŋ gwar jin bu’thkina Tap̱a Arumgimis ’peni wathiŋ gwaṯẖ mo tani a’di ki uḵ a’di mmota a’bom mo dhali guya yim e wathiŋ gwaṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Dhali yan’ko’d wathiŋ gwaṯẖ ki o gwo mo ki: Hayyiye ayaase ita’da simam pema dhali buŋgwar is ki shuman is pema. Ayim minu yuḵ gway ka A’bom mo, haali/ ayim a’di bu’thkunu ’peni Wathiŋ Gwaṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Dhali gom gwo gi wakan mo tani wathiŋ gwaṯẖ midi dhal com ’pen mo dhali kum mo dhali ’dap̱ is piti me’d ki ash mo dhali uni su/ warkina buŋgwar is ki isa ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Dhali wathiŋ gwaṯẖ dhali ashim piti mo tani uni ’ko ki is ’te/ mo dhali uni ’kona is ki ’theya ’the mo. ");
INSERT INTO udu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Dhali tasha/ a’di kora e ki kor mo mmobola ris tombwaasho kun uḵu mo, uni gun uḵkina Tap̱a Arumgimis mo. A’di ki owa ’bom gwo mo ki: A/Arumgimis o gwo mo ki: Um mini mii dhalku/ cwan ṯal ’de/ ki shwa ’peni bwaagoŋ ’te/o? ");
INSERT INTO udu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Dhala ’bom ki thoḵ tasha/ gwo mo ki: Aman dhalu bway mmoshwa aris maman cwa gi bwaagoŋ mo. ");
INSERT INTO udu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Hili Arumgimis ki o gwo mo ki: Um mini mii dhalku/ ki shwa maman cwa jin di’d e bwaman gi bwaagoŋ mo, walla dhalku/ ki ta a’di is ki me’d mo gom isi ciki/ um mini wu mo. ");
INSERT INTO udu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Hili tasha/ ki owa ’bom gwo mo ki: Um mini wu mo yisa. ");
INSERT INTO udu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Haali/ Arumgimis mishki’d ki um mini shwa a’di mo tani em bum minu ḵa’d mo dhali um mina e wa ka Arumgimis mo mmonyiṯẖ jin ’boro’d dhali jin ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Wakan ka ’bom ki p̱ar cwa e ki a’di ’bora’bor mmoshwa mo, dhali a’di ’kunya’kuny e jis/em piti mo, dhali cwa a’di iminu o bwa mmokar jan ṯal ’de/ mmoyuḵa yuḵ mo tani ayim ki bu’th maman cwa mo dhali shwa a’di, dhali ayim si’da/ ki c̱iki a’di ka kaṯẖim piti mo, dhali a’di shwaki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Dhali yan’ko’d uni su/ ḵa’dkunu em buni mo, dhali uni su/ mishki mo mo ki uni ’ko ki is ’te/ mo, dhali uni ki sho ’cemena p̱u/ mmonṯal ’de/ mo dhali uni ki uḵa romp̱a/ ’peni ’cemena p̱u/ gom is buni mo. ");
INSERT INTO udu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Dhali uni ciḵki is gi Tap̱a Arumgimis mmoyakina a’di e bwam ma goŋ e mom’pimpili/ jin ’thup̱ ma tee she/ mo, dhali wathiŋ gwaṯẖ dhali ash uni bagki is buni ’peni buŋ’kus gi Tap̱a Arumgimis mo e bwanycwa gi bwaman gi bwaagoŋ mo. ");
INSERT INTO udu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Hili Tap̱a Arumgimis yuḵki wathi/ mo dhali o a’di gwo mo ki: /E dini mana? ");
INSERT INTO udu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Dhali a’di ki thoḵ gwo mo ki: Aha/ ciḵa is jin gwo /e e bwaman ma goŋ mo, dhali aha/ ḵo/kina is mo, haali/ aha/ dina is ’te/ mo, dhali aha/ bagkina is pem mo. ");
INSERT INTO udu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","A’di o gwo mo ki: Kaja iṯor /e gwo mo ki /e di is ’te/a? Ki /e ishwaki cwa jin ḵanka/ /e gwo mo ki: /E mini mii dhalku/ a’di ki shwa mo? ");
INSERT INTO udu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dhali wathi/ ki o gwo mo ki: A’bom a’di jin c̱ikina /e mmonyaḵ c̱a’b ki aha/ mo tani ayim a’di ic̱iki aha/ maman cwa mo dhali aha/ shwakina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Dhali yan’ko’d Tap̱a Arumgimis ki owa ’bom gwo mo ki: Katinta sa/ jin miikina /e mo? Dhali a’bom ki thoḵ gwo mo ki: Tasha/ a’di imu’thki aha/ e mo dhali aha/ shwakina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Dhali Tap̱a Arumgimis ki o tasha/ gwo mo ki: Haali/ gom miim pini jin miikina /e kansan tan mo tani monyjeem pini boli’da ris to/e kun uḵu e ki shi/ mo dhali ap̱owa ris to/e kun ’koni bwaasho ’baar mo. Dhali ka bor pini mo tani /e mini para bora ’cesh mo, dhali bu’da’cesh mina /e shwa mo ka risa tee gi mondiki/em pini ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aha/ mina kar mo jin dup̱u i bwaman /e mo dhala ’bom mo, dhali e bwaman emen pini mo dhali emen ma yim mo. A’di midi pwaṯẖ /e ’kup̱ pini mo dhali /e mini ṯikina ṯiŋkilam piti ka ulmany mo. ");
INSERT INTO udu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Eya ’bom mo tani a’di ki o gwo mo ki: Isa nyor dho’th pini gom uc̱i mo tani miga/ mar is kagahara gom /e mo. /e mini dho’th uc̱i ki isa nyor i e mo, hili bwam pini mini mii o ka kaṯẖim pini mo dhali a’di midi ta tap̱a ap̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Dhali a’di ki owa Aadam gwo mo ki: Gom miim pini jin ciḵa /e ’twa/ gi ashim pini mo dhali shwa cwa yansan jin ḵanka/ /e gwo mo ki: /E mini mii dhalku/ ki shwa a’di mo tani mony’cesh jeenu mo gom /e mo be. Aris to kun mina /e shwa mo tani uni mina /e gam ’peni mii jin mina /e ’kosha shir shir mo ka tee gi mondiki/em pini ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","A’de/ dhala liṯ uni mini ’ka gom /e mo, dhali /e mini shwa to kun sinu ’peni bunto mo. ");
INSERT INTO udu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","/E mini shwa tonṯe/ ki jiṯi/ bwam/em pini mo ntagi /e mini doḵ ki bu’da’cesh ka nyaŋ’ko’d, haali/ ’peni bu’da’cesh mo tani /e bu’thkunu mo be. /E ta bu’d gana/ mo, dhali e bu’da’cesh mo tani /e mini doḵ ki a’di ka nyaŋ’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Dhali wathi/ ki yuḵ ash gway ka Hawwa mo, a’di jin ta ’pemen gwo jin onu ki: To jin di’d ki e mo, haali/ ayim ta’da ata’da ma ris to ’baar kun ’kon ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Dhali Tap̱a Arumgimis ki uḵ ka Aadam dhali gom ashim piti burrinye/ ’pena yi’c mo, dhali hi’thki uni i is mo. ");
INSERT INTO udu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Dhali yan’ko’d Tap̱a Arumgimis ki o gwo mo ki: Hili mo mo ma, wathi/ a’di wakina e ki jan ṯal ’dem bana mo, mmomish jin ’boro’d dhali jin ta thus ki thus mo. Dhali shwane/ isi ciki/ ki a’di midi kar me’d piti dhali bu’th cwa gi mondiki/e si’da/ mo dhali shwa a’di mo dhali a’di midi c̱a’b ki e ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Dhali gom gwo gi wakan mo tani Tap̱a Arumgimis ki kar a’di ’pen ka pije/ ’peni bwaagoŋ ma Idin mo, mmoya ḵora ’cesh ki me’d piti mo ’peni mo jin bu’thkunu a’di ’peni cine/ mo. ");
INSERT INTO udu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A’di ki ur wathi/ ka pije/ mo dhali e mom’pesho’k gi bwaagoŋ ma Idin mo tani a’di ki dhu karubiim kun ta iman’doyu gwo mo dhali gandal jin kaaka jin shwa’d ki o’d ki bar bar mo a’di jin ṯu’kki’d ki washar washar ’ban kuku/ mo, mmoji bway gi maman cwa jin di ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Dhala Aadam mishki’da Hawwa jin ta ash mo, dhali ayim bwaaki’d mo dhali dhodha Kayiin mo mmo/o gwo mo ki: Aha/ gamkina a’ciŋgwaṯẖ ki mowoṯẖ gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Dhali doḵ/e ayim dho’thki’da kam piti jin yuḵu gway ka Habiil mo. Dhala Habiil ta’da manhil ḵa’bal mo dhala Kayiin ta’da manḵora ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Dhali ki eŋ kamu/ mo tani Kayiin a’di ki ’doyi maman to kun sinu eya ’cesh mo mmoc̱i ki Tap̱a mo, ");
INSERT INTO udu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","dhala Habiil a’di ki ’doyi ushi ḵa’bal kun tana bwanyara/ mo ’pena ma’diny ḵa’bal piti mo dhali ’peni unim buni kun ’thiḵa’thiḵ ki tuntum tuntum mo. Dhali Tap̱a ki c̱iya hirdhe/ gom to ma Habiil jin c̱ina a’di ki me’d mo, ");
INSERT INTO udu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","hili goma Kayiin dhali tom piti kun c̱ina a’di ki me’d mo tani a’di diki c̱iya hirdhe/ mo be. Wakan a’di shwakin ma Kayiina nyor kagahara mo dhali jis/em piti bushura/ bushur mo. ");
INSERT INTO udu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Dhali Tap̱a ki owa Kayiin gwo mo ki: Atinta shwana /e anyor kan mo dhali atinta ’bushurkina jis/em pini ki ’bushur kan mo? ");
INSERT INTO udu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Waḵki/ /e mini mii ki ’bore/ mo tani a/e minu diki mish bu’th mowa? Dhali waḵki/ /e diki mii ki ’bore/ mo tani miinthus a’di wup̱ki’d e ’twaŋkal gu’b mo. A’di ona bwa ki /e mo, hili /e mini mii ta tap̱a ap̱o/ a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayiin ki owa Habiil gwo jin ta’da kam piti mo ki: Dhalki ana iina ka pije/ e bwam bunto mo. Dhali ki uni ’kokin e bwam bunto mo tani aKayiin cuki mis ap̱owa kam piti jin ta’da Habiil mo dhali ’kosh a’di jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Dhali yan’ko’d Tap̱a ki owa Kayiin gwo mo ki: Mana Habiil jin ta’da kam pini mo? A’di ki o gwo mo ki: Mishgaa? Aha/ tana manhila kam pema? ");
INSERT INTO udu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Dhali Tap̱a ki o gwo mo ki: Atinta miikina /e? ’Twa/ ma bas ma kam pini a’di gwoki’d ’twa/ i aha/ ’pena ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Dhali shwane/ /e jeekunu ’pena ’cesh mo, a’di jin ḵa’dki ’twa/ mo mmolosa bas ma kam pini ’peni me’d pini mo. ");
INSERT INTO udu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ki /e mini ḵora ’cesh mo tani a’di midi doḵ/e dho’th to kagahara gom /e ’peni mom’bi’th is piti mo yisa. /E mini ta jwa ki jwa mo dhali ya yany c̱a/ e mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayiin ki o Tap̱a gwo mo ki: Miim pem jin di aha/ ’ba/ a’di caaca gom aha/ mmoḵal mo. ");
INSERT INTO udu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hili mo mo ma, /e urki aha/ ka pije/ ka cim yansan mo ’pena ’cesh mo. Dhali ’peni jis/em pini mo tani aha/ minu bag mo, dhali aha/ mina ta jwa ki jwa mo dhali ya yany c̱a/ e mony’cesh mo dhali ma a’diyin jin midi gam aha/ mo tani midi ’kosh aha/ jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Dhali yan’ko’d Tap̱a ki o a’di gwo mo ki: Midi wakan yisa. Waḵki/ jan ṯal ’deŋ kamu/ midi ’kosha Kayiin jwa mo tani mori’c midi di ap̱o/ a’di me’di pesu/ mo. Dhali Tap̱a ki c̱iya Kayiin jamas mo, isi ciki/ ki a’din ’de/ yin jin midi ya ap̱o/ a’di midi diki ’kosh a’di jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Dhali yan’ko’da Kayiin yaki’d ka pije/ ’peni buŋ’kus gi Tap̱a mo dhali c̱a’b e mony’cesh gi Pa Nud mo, e mom’pesho’k ma Idin mo. ");
INSERT INTO udu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Dhala Kayiin mishki’da ’bom piti mo dhali ayim bwaaki’d mo dhali dhodha Hanuuk mo. Dhali a’di nyaŋki dhan ’peŋkuman bampa/ mo dhali yuḵ ’peŋkuman bampa/ gway mmobaṯẖ gway gi ya/m piti ka Hanuuk i’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Dhali Hanuuk dho’th ya/ jin yuḵu ka Irad mo. Dhala Irad ta’da baba ma Mahuya/iil mo dhala Mahuya/iil ta’da baba ma Matusha/iil mo dhala Matusha/iil ta’da baba ma Laamak mo. ");
INSERT INTO udu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Dhala Laamak ki mash up̱i su/ mmota i/ash mo. Dhali gway jan ’de/ mo tani yuḵu ka Aadah dhali gway ka kamu/ yuḵu ka Sillah mo. ");
INSERT INTO udu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aadah a’di dho’thki’da Yabal mo. A’di ta’da baba gi uni gwansan kun ’kon e gu’b burrinye/ dhali ta gi to/e mo. ");
INSERT INTO udu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Dhali gway ma kam piti yuḵu gway ka Yubal. A’di ta’da baba gi uni gwansan kun p̱ikina dheŋdhenye/ kun ’kon ma shu/i pesu/ mo dhala baraŋku/ mo. ");
INSERT INTO udu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Dhala Sillah dho’thki’da Tubalkayiin mo. A’di ta’da mandor to kun kaaka mo dhali gurany mo dhali toŋḵuthu’d mo. Dhali ’bwaham ma Tubalkayiin yuḵu gway ka Naama mo. ");
INSERT INTO udu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Dhala Laamak ki o up̱ gwo mo ki: Aadah dhala Sillah, ciḵi gwo ’peni ’twam pem mo. Um kun ta up̱ ma Laamak mo tani ciḵi gwo jin miga/ o mo: Aha/ ’koshkina wathi/ jin ’koshki aha/ mmotaḵ jama/ mo, wathi/ jin ta dhuru’c jin ’koshki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Waḵka Kayiin ri’ckunu me’di pesu/ mo tani ka jiŋ gana/ si’da/ Laamak minu ri’c me’di iss ’kwanimpa ikwara i’ce’dka ’kume’d i’ce’dka pesu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Dhala Aadam mishki’da ’bom piti doḵ/e mo, dhali ayim dho’thki’da ’ci jin ta ya/ mo dhali yuḵ a’di gway ka Shiiṯ mo, haala yim o gwo mo ki: Arumgimis karki aha/ ’pen ka pije/ mmodhodha ’ciŋ kamu/ mmodhalka Habiil e i is mo, haala Kayiin ’koshki a’di jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Dhala Shiiṯ si’da/ ta’dki ya/ jin dho’thkina a’di mo dhali a’di ki yuḵ a’di gway ka Anuush mo. Dhali ka tee c̱aan mo tani ’kwani ṯelki mii ’pen mo mmoko ’twa/ ap̱o/ Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","A’di ta’da warka/ ma nyaḵum yil gi uc̱i ma Aadam mo. Ka Arumgimis ki uḵ wathimpa en’thi/ mo tani a’di ki uḵ a’di mmowa e ka Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wathiŋ gwaṯẖ dhali wathim ’bomi a’di ki uḵ uni mo dhali a’di ki ’bor uni mii mo dhali a’di ki yuḵ uni gway ki ’kwani en’thi/ mo me’d jin uḵkina a’di uni mo. ");
INSERT INTO udu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ka Aadam c̱a’bki’d ki e ki yili iss ’kwanimpa ipe’de/ i’ce’dka ’kume’d mo tani a’di warki’d ka baba gom ya/m piti jin wakina e ki a’di mo, mmobu’thkina a’di isi jamas piti mo, dhali yuḵ a’di gway ka Shiiṯ mo. ");
INSERT INTO udu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Atee kun din ma Aadam ’ko’di a’di taki’da baba goma Shiiṯ mo tani a’di ’kokina yili iss ’kwanimpa i/iss su/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Dhali wakan arisa tee kun c̱a’bkin ma Aadam ki e mo tani a’di ta yil kun ta iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa ipe’de/ i’ce’dka ’kume’d mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Dhala Shiiṯ c̱a’bki’d ki e ki yili iss ’kwanimpa imudhe’d i’ce’dka mudhe’d mo tani a’di warki’d ka baba ma Anuush mo. ");
INSERT INTO udu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Dhala Shiiṯ c̱a’bki’d ki e mo ’ko’di dho’th ma Anuush mo ka yili iss ’kwanimpa i/iss su/ i’ce’dka pesu/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Dhali wakan arisa tee kun c̱a’bkin ma Shiiṯ ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa imudhe’d i’ce’dka ’kume’d i’ce’dka su/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ka Anuush c̱a’bki’d ki e ki yili iss ’kwanimpa idoŋon i’ce’dka ’kume’d mo tani a’di warki’d ka baba ma Kinan mo. ");
INSERT INTO udu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Anuush c̱a’bki’d ki e mo ’ko’di dho’th ma Kinan mo ki yili iss ’kwanimpa i/iss su/ i’ce’dka ḵarpa’c mo dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Dhali wakan arisa tee kun c̱a’bkin ma Anuush ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa imudhe’d i’ce’dka mudhe’d ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ka Kinan c̱a’bki’d ki e ki yili iss ’kwanimpa ikwara i’ce’dka ’kume’d mo tani a’di warki’d ka baba ma Mahlal/iil mo. ");
INSERT INTO udu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Dhala Kinan c̱a’bki’d ki e mo ’ko’di dho’th ma Mahlal/iil mo ki yili iss ’kwanimpa i/iss su/ i’ce’dki iss su/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Dhali wakan arisa tee kun c̱a’bkin ma Kinan ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa imudhe’d i’ce’dka ’kume’da ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ka Mahlal/iil c̱a’bki’d ki e ki yili iss ’kwanimpa ikwara i’ce’dka mudhe’d mo tani a’di warki’d ka baba ma Yarid mo. ");
INSERT INTO udu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Dhala Mahlal/iil c̱a’bki’d ki e mo ’ko’di dho’th ma Yarid mo ki yili iss ’kwanimpa i/iss su/ i’ce’dka iss ’kwanimpa ’de/ i’ce’dka ’kume’da ap̱o/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Dhali wakan arisa tee kun c̱a’bkin ma Mahlal/iil ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa idoŋon i’ce’dka ḵarpa’c ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ka Yarid c̱a’bki’d ki e ki yili iss ’kwanimpa ipekwara i’ce’dka su/ mo tani a’di warki’d ka baba ma Aḵnuuḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Dhala Yarid c̱a’bki’d ki e mo ’ko’di dho’th ma Aḵnuuḵ mo ki yili iss ’kwanimpa i/iss su/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Dhali wakan arisa tee kun c̱a’bkin ma Yarid ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa ipekwara i’ce’dka su/ ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ka Aḵnuuḵ c̱a’bki’d ki e ki yili iss ’kwanimpa ikwara i’ce’dka mudhe’d mo tani a’di warki’d ka baba ma Maṯushaalah mo. ");
INSERT INTO udu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Aḵnuuḵ nyaḵ ya ka Arumgimis mo ’ko’di dho’th ma Maṯushaalah mo ki yili iss ’kwanimpa ḵarpa’c mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Dhali wakan arisa tee kun c̱a’bkin ma Aḵnuuḵ ki e mo tani ’kona yili iss ’kwanimpa ḵarpa’c i’ce’dki iss ’kwanimpa ikwara i’ce’dka mudhe’d ap̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Aḵnuuḵ a’di nyaḵki ya ka Arumgimis mo, dhali a’di dinuki gam mo haali/ Arumgimis suski a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ka Maṯushaalah c̱a’bki’d ki e ki yili iss ’kwanimpa ipedoŋon i’ce’dka pesu/ mo tani a’di warki’d ka baba ma Laamak mo. ");
INSERT INTO udu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Dhala Maṯushaalah c̱a’bki’d ki e mo ’ko’di dho’th ma Laamak mo ka yili iss ’kwanimpa i/iss su/ aṯẖ ’de/ i’ce’dka su/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Dhali wakan arisa tee kun c̱a’bkin ma Maṯushaalah ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa ipekwara i’ce’dka pedoŋon ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ka Laamak c̱a’bki’d ki e ki yili iss ’kwanimpa ipedoŋon i’ce’dka su/ mo tani a’di warki’d ka baba gi ya/ mo ");
INSERT INTO udu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","dhali a’di ki yuḵ a’di gway ka Nuuh mo mmo/o gwo mo ki: ’Pena ’cesh jin jeekina Tap̱a mo tani jan ’de/ yansansan a’di midi ḵal ana mo jin minu raḵ ana is ka ’cesh mo ’peni miin tom bana mo dhali ’peni miin tom bana jin ’kosha ana ki me’d bana ki ṯu/ul ṯu/ul ki is jin wu ana e mo. ");
INSERT INTO udu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Dhala Laamak c̱a’bki’d ki e mo ’ko’di dho’th ma Nuuh mo ka yili iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa ipedoŋon i’ce’dka ḵarpa’c ap̱o/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Dhali wakan arisa tee kun c̱a’bkin ma Laamak ki e mo tani ’kona yili iss ’kwanimpa i/iss su/ aṯẖ iss su/ i’ce’dka ’kume’d i’ce’dka pesu/ ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ka Nuuh taki’d ki yili iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa imudhe’d mo tani a’di warki’d ka baba ma Saam dhala Haam dhala Yap̱aṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ki ’kwani ṯelki mii ’pen mmomar is mo ap̱o/ bwam/e ga ’cesh mo dhali ’bwa/m buni dho’thkunu uni mo ṯani ");
INSERT INTO udu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","iya/ ma Arumgimis mo uni p̱arki i’bwa/ gi ’kwani e mo ki uni ’bora’bor mo dhali uni ki mash uni mo mmota i/ash mo me’d jin kwanykina uni uni wakan mo. ");
INSERT INTO udu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Dhali yan’ko’d Tap̱a ki o gwo mo ki: Shi/in pem midi diki malas ’kwani ki sule/ sule/ mo haali/ a’di ta buŋgwar is mo, hili ateem piti midi ta yili iss ’kwanimpa ipe’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Dhan ḵampar ’kwani uni ’kokin e mony’cesh ka tee gwansan mo dhali uni ’koni ’ko’d si’da/ mo me’d jin p̱u’dkina iya/ ma Arumgimis e i’bwa/ gi ’kwani mo dhali uni dho’thki uni uc̱i mo. Uni gwansan ita ’kwani kun c̱a’bki dem dem ’peni kadhamo/ mo dhali kun tora gway ḵarash mo. ");
INSERT INTO udu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tap̱a p̱arki tonthus e kun miikina ’kwani caaca kagahara e mony’cesh mo dhali misha ris gwalal buni kun kulumkina uni eya dum buni mo ta jasi tonthus ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Dhali Tap̱a ḵalki bwan diṯi’d mo ki a’di uḵki ’kwani e mony’cesh mo dhali a’di jwakaṯki a’di adum piti mo. ");
INSERT INTO udu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Wakan Tap̱a a’di ki o gwo mo ki: Aha/ mina dhi’th ’kwani sho’k mo uni kun uḵka/ ’peni bwam/e ga ’cesh mo, ’kwanimpa en’thi/ dhali tombwaasho dhali to kun parana ’cesh dhali ’dii kun p̱en e mis mo haali/ aha/ diṯa bwa mo ki aha/ i/uḵkina uni mo. ");
INSERT INTO udu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hili Nuuh gamki’da ’the e e gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Uni gwansan itana nyaḵum yil ma Nuuh mo. Nuuh a’di ita wathiŋ ḵar/e mo, dar gi mii ’ba/ e nyaḵum yil gi ’kwanim piti mo. Nuuh nyaḵ ya ka Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Dhala Nuuh ta gi iya/ ikwara mo: Saam dhala Haam dhala Yap̱aṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hili mony’cesh a’di p̱u/ki’d e bwam/e ma Arumgimis mo dhali mony’cesh ’tu’dkunu ki piny piny ki mo jin bujurkunuwa bujur mo. ");
INSERT INTO udu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dhali Arumgimis mishki mony’cesh mo dhali hili mo mo ma, a’di p̱u/ki’d mo haali/ aris buŋgwar isi ’baar p̱u/ki uni isiny cine/ mo e bway buni jin iina uni ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Dhali Arumgimis ki owa Nuuh gwo mo ki: Aha/ ḵara/ dina gwo ibwa mo ba/ mmodaḵa ris buŋgwar is ’kup̱ mo haali/ mony’cesh a’di ’tu’dkunu ki piny piny ki mo ma bujur gi uni mo. Hili mo mo ma, aha/ mina ’ce’d uni sho’k nyaḵki mony’ceshi lu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Uḵi /e is pini adhana ḵur yi’de/ ’pena cwa jin wana e ki ṯu’b mo dhali /e mini thoson bwaŋ gu’b e bwaman ma ḵur mo dhali /e mini gwa’c a’di bwaman dhali ’ko’d gwar ka ’cesh jin deḵadeḵ jin ta’da jillo mo. ");
INSERT INTO udu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mii a’dihe/ be jin mina /e uḵ a’di mo. Aluc̱ ma ḵur midi ta gula iss ’kwanimpa ḵarpa’c mo dhali beem piti midi ta iss ’kwanimpa isu/ i’ce’dka ’kume’d mo ki gulam piti mo dhali tur piti midi ta iss ’kwanimpa ’de/ i’ce’dka ’kume’d mo ki gulam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nyaŋa ḵur ’kup̱an mo dhali ’baari a’di mo ntagi gulam piti ’kup̱ mo dhali /e mini kar ’twaŋkal goma ḵur si’da/ e em bwaman piti mo dhali uḵi a’di ki dhunya/ dhunya/ ka maḵamp̱o/ mo ka p̱o/i kwara mo. ");
INSERT INTO udu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Haali/ hili mo mo ma aha/ mina hasha gannu/ yi’de/ ap̱o/ mony’ceshi ’baar mo mmo’ce’da ris buŋgwar is sho’k mo uni gun shi/irin moŋ’koki/e ’peni bwaŋ’kwariny momis mo. Aris to ’baar mo kun ’kon e mony’cesh mo tani mini wu mo. ");
INSERT INTO udu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Hili aha/ mina ṯel gwom pem jin gamka/ me’d nyaḵki /e sho’k mo dhali /e mini cic̱ bwaa ḵur mo /e dhali iya/m pini dhali ashin dhali up̱ gi iya/m pini nyaḵki /e mo. ");
INSERT INTO udu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Dhali ’peni aris to kun ’ko ki e kun ta shuman is mo tani /e mini ’doyi uni ka susu/ susu/ aris uni kun ’kona e ki she/ ki she/ mo e bwaa ḵur mo mmodhu uni ki e nyaḵki /e mo uni gun ta gwasan dhali kuman mo. ");
INSERT INTO udu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","’Pena ris ’dii isi ki em buni kun ’ko uni ki she/ ki e kuku/ mo, dhali ’pena ris to/e mo isi ki em buni kun ’ko uni ki she/ ki e kuku/ mo, ’pena ris to kun parana ’cesh mo isi ki em buni kun ’ko uni ki she/ ki e kuku/ mo, ka susu/ susu/ uni mini nyaḵ ii ki /e mo ki /e mini dhu uni ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Wakan /e mini ḵala ris tonṯe/ ’baar kun ’kona e ki she/ ki she/ uni kun shwanu mo, dhali dhuyi uni themes mo, dhali a’di midi ta tonṯe/ jin minu mii ki /e mmoshwa mo dhali gom uni mo. ");
INSERT INTO udu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuuh miiki mii yansan mo. A’di miiki’da ris gwo kun ḵankin ma Arumgimis a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Dhali yan’ko’d Tap̱a ki owa Nuuh gwo mo ki: Yaku/ bwaa ḵur mo, /e dhala risa waḵ gi gu’b pini mo, haali/ aha/ misha ki /e ta wathiŋ ḵar/e ibwambori aha/ ki nyaḵum yil gi ’kwani gwansan mo. ");
INSERT INTO udu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Susi nyaḵki /e to/e kun ’koni pesu/ ka pesu/ pesu/ mo kun mishu shum ’ka mo, kun ta gwasan dhali kuman buni mo, dhali to/eŋ kamu/ si’da/ kun molu shum ’ka mo, arasan dhali kuman mo, ");
INSERT INTO udu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","dhali ’dii kun ’koni pesu/ ka pesu/ pesu/ mo kun p̱en e mis si’da/ mo, rasan dhali kuman mo, mmodhu uni ki e ki jamas buni ki she/ ki she/ e bwam/e gi mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Haali/ ka cim pesu/ mo tani aha/ mina hasha sho’k ap̱o/ mony’cesh mo acim ma iss su/ montee mo dhali acim ma iss su/ mon’thiny mo. Dhali aris to/e ’baar mo kun ’kon ki e mo kun uḵka/ mo tani aha/ mina ḵal uni sho’k ka pije/ ’peni bwam/e ga ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Dhala Nuuh a’di mii’da ris to kun ḵana Tap̱a a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Dhala Nuuh ’koni yil iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa i’kume’d mo me’d jin p̱u’dkin ma gannu/ yi’de/ ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Dhala Nuuh dhali iya/m piti dhali ash dhali i/ash gi iya/m piti nyaḵki a’di mo tani uni iikin e bwaa ḵur mo mmoye ’pena gannu/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","To/e kun mishu shum ’ka mo dhali to/e kun molu shum ’ka mo, dhali ’dii mo dhala ris to kun parana ’cesh mo ");
INSERT INTO udu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ka susu/ susu/ mo, gwasan dhali kuman mo, iikin e bwam ma ḵur nyaḵka Nuuh mo me’d gwo jin ḵankin ma Arumgimisa Nuuh mo. ");
INSERT INTO udu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Dhali ’ko’da cim pesu/ thimkin mo tani agannu/ yi’de/ p̱u’dki’da p̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ka yil iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa i’kume’d jin ta yil mondiki/e ma Nuuh mo tani, ka ppe jiŋ ’ko’d mo jin ta’da cim ’kume’d i’ce’dka pesu/ ma appe mo, dhali ka cim c̱aan mo tani aris yi’de/ kun kasha e ’peni jisa ’kulga/ uni ’twaḵkin mo dhali campur gi momis a’di ḵa’dkunu ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Dhala sho’k wolki ’twa/a p̱o/ mony’cesh ka cim iss su/ montee mo dhali ka cim iss su/ mon’thiny mo. ");
INSERT INTO udu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Dhali ka tenteŋ gana/ yan mo tani Nuuh dhali iya/m piti jin ta’da Saam dhala Haam dhala Yap̱aṯẖ dhali asha Nuuh dhali up̱ gi iya/m piti kun ’koni kwara nyaḵki cic̱ ki uni e bwam ma ḵur mo, ");
INSERT INTO udu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","uni dhali aris tombwaasho ’baar mo isi ki jamas buni ki she/ ki she/ mo, dhali aris bip̱ mo isi ki jamas buni ki she/ ki she/ mo, dhali aris to jin parkin mo kun parana ’cesh mo isi ki jamas buni ki she/ ki she/ mo, dhali aris ’dii ’baar mo isi ki jamas buni ki she/ ki she/ mo, aris ’dii ka warom buni ki she/ ki she/ mo. ");
INSERT INTO udu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Uni iikin nyaḵka Nuuh e bwam ma ḵur mo, ka susu/ susu/ mo, aris to kun ta ga shuman is mo e uni kun p̱inu shush buni mmo’ko ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Dhali uni gwansan kun ta gwasan mo dhali kuman mo kun ta shuman isi ’baar mo, uni cic̱kin mo me’d gwo jin ḵankin ma Arumgimis a’di mo. Dhali Arumgimis ki mu’thki a’diya campur mo. ");
INSERT INTO udu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Agannu/ yi’de/ a’di ṯikirki’d ka cim iss su/ ap̱o/ mony’cesh mo dhali yi’de/ marki is mo dhali a’di ki ’deka ḵur mo dhali a’di ki cu mo mmobola ’cesh ka p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dhali yi’de/ a’di p̱iki mii e mo dhali mar is kagahara ap̱o/ mony’cesh mo dhali aḵur a’di hashki’d e ’kup̱an yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Dhali yi’de/ a’di p̱iki mii e ki mo ma dem dem mo ap̱o/ mony’cesh wakan mo, dhali aris wosha turga/ kun ’kokin e bwaŋ’kwariny momis mo tani uni hac̱kina yi’de/ ki ’peny ’ce i e mo. ");
INSERT INTO udu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dhali yi’de/ p̱iki mii e mo ap̱owa ris wosha turga/ mo mmolos uni mo ki eŋgula kun ’koni ḵarpa’c ki ’kul piti mo. ");
INSERT INTO udu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Dhali aris buŋgwar is wukin mo dhali to kun ’koni mmoḵal ya ap̱o/ mony’cesh mo, ’dii dhali bip̱ dhali tombwaasho, dhali aris to kun tana ris kun yan ka ŋul ’kup̱ kun ’kona p̱o/ mony’cesh mo dhali aris ’kwani ’baar mo, ");
INSERT INTO udu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","aris to kun ’kon eya ’cesh jin ḵuthaḵu’th mo kun p̱inu shush buni mmo’ko ki e mo tani uni wukin mo be. ");
INSERT INTO udu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","A’di ḵalki’da ris to ’baar mo sho’k ka pije/ mo kun ’kon ki e ’peni bwam/e ga ’cesh mo, ’kwani dhali to/e dhali to kun parana ’cesh mo dhali ’dii kun p̱en e momis mo tani uni iḵalkina a’di sho’k ka pije/ ’peni mony’cesh mo. Jasa Nuuh a’di ’de/ idhalkunu mo dhali uni gwansan kun nyaḵ ’ko ki a’di eya ḵur mo. ");
INSERT INTO udu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Dhali yi’de/ p̱iki mii e ap̱o/ mony’cesh mo ka tee iss ’kwanimpa ipesu/ i’ce’dka ’kume’d mo. ");
INSERT INTO udu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hili Arumgimis kaki’da Nuuh e mo dhala ris tombwaasho mo dhala ris to/e mo kun nyaḵ ’ko ki a’di e bwam ma ḵur mo. Dhali Arumgimis ki uḵ dhan ’tham mmoposha p̱o/ mony’cesh mo dhali yi’de/ a’di guki’da wuuy mo. ");
INSERT INTO udu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Yi’de/ kun kasha e ’peni mo kun ’kula’kul mo dhala campur gi momis mo tani uni mu’thkunu mo dhala sho’k ’peni momis a’di guki ’twa/ mo, ");
INSERT INTO udu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","dhali yi’de/ cunycumki’d ka ’cesh mo ’pena ’cesh ki sule/ sule/ mo. Dhali ka cim iss ’kwanimpa ipesu/ i’ce’dka ’kume’d thimin mo tani yi’de/ a’di mara’d ma ap̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Dhali ka appe ’kup̱i pesu/ mo dhali ka cim ’kume’d i’ce’dka pesu/ jin ta jama/ appe mo tani aḵur a’di p̱u’dki’da p̱o/ ’kuwosha turga/ kun yuḵu gway ka Ararath dhali rep̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dhali yi’de/ di’di mmoṯikir mmomara’d is mo ntaga ppe ’koni ’kup̱i ’kume’d mo, dhali ka appe ’koni ’kup̱i ’kume’d mo tani a’di jin ta’da tee jin ṯwa/a/ ka appe mo tani ’kup̱an dhan wosha turga/ uni p̱arkunu e mo. ");
INSERT INTO udu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Dhali ’ko’da cim iss ’kwanimpa su/ ’baarki’d mo tani Nuuh ’ce’dki’da shubbaak ma ḵur mo a’di jin uḵkina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Dhali a’di ki hasha waraŋgwaḵ mo, dhali a’di wukurki’d ntagi yi’de/ ḵu’thki’d ’peni mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Dhali yan’ko’d a’di ki hasha gurko/ ’peni a’di mo mmop̱ar mo e mo waḵki/ yi’de/ midi gu ka wuuy ’peni bwam/e ga ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Hili gurko/ diki gam moŋkamu/ jin mina a’di kar sho’k piti icine/ mo, dhala yim doḵki’d ka nyaŋ’ko’d e a’di e bwam ma ḵur mo haali/ yi’de/ di’d naskina/ e bwam/e gi mony’ceshi ’baar mo. Wakan a’di ki kar me’d piti mo dhali budha yim mo dhali susa yim bway bwam ma ḵur nyaḵki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A’di c̱orki’da cim pesuŋ kamu/ doḵ/e mo dhali a’di ki hash gurko/ ka pije/ ’peni bwam ma ḵur doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Dhali gurko/ p̱u’dki’d ka nyaŋ’ko’d i a’di mom’pimpili/ mo dhali hili mo mo ma, ayim ḵalki’d e ’twam piti ’cemen jip̱i/ cwa seṯuun jin ta’da go’d go’d mo jin daḵa ’ciṯẖkunu ki she/ mo. Wakana Nuuh a’di mishki mo mo ki yi’de/ a’di guki’da wuuy ’peni mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Dhali yan’ko’d a’di c̱orki’da cim pesuŋ kamu/ mo, dhali a’di hash gurko/ mo, dhala yim yaki’d mo dhali diki doḵu/ ka nyaŋ’ko’d i a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ka yil iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa i’kume’d i’ce’dka ’de/ mo, dhali ka appe jin ṯwa/a/ dhali ka cim ’de/ ka appe mo, yi’de/ a’di ḵu’thki’d ’peni mony’cesh mo dhala Nuuh a’di ’ceeki’da ḵur ’kup̱ mo dhali a’di ki p̱ar mo e mo dhali hili mo mo ma, bwam/e ga ’cesh a’di pupura/ pupur mo. ");
INSERT INTO udu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Dhali ka appe kun ’kon ma p̱o/i su/ mo ka cim iss ’de/ i’ce’dka pesu/ ka appe mo tani mony’cesh a’di pupuri’di ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Dhali yan’ko’d Arumgimis ki owa Nuuh gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Yaku/ ka pije/ ’peni bwam ma ḵur mo, /e dhali ashin mo dhali iya/m pini mo dhali up̱ gi iya/m pini nyaḵki /e mo. ");
INSERT INTO udu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","’Doyi aris to kun ’kon ki e nyaḵki /e mo uni gun ta to ki shuman isi ’baar mo, aris ’dii dhali to/e dhali aris to kun paran mo kun paran e mony’cesh mo ki uni mini c̱is ka enthus ap̱o/ mony’cesh mo ki uni mini dho’th maman dhali mar is ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wakana Nuuh yaki’d ka pije/ mo dhali iya/m piti mo dhali ash mo dhali up̱ gi iya/ nyaḵki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Dhali aris tombwaasho mo dhali aris to kun parana ’cesh mo dhali aris ’dii mo dhali aris to kun ḵalki ya ap̱o/ mony’cesh mo, iikin ka pije/ ka waḵ buni ki she/ ki she/ ’peni bwam ma ḵur mo. ");
INSERT INTO udu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Dhali yan’ko’da Nuuh ki nyaŋa gwaṯa/ mmomiiya bas gom Tap̱a mo dhali a’di ki bu’th to/e kun dheleladhelel mo ’pena ris tiya mo dhali ’dii kun dheleladhelel mo ’pena ris tiya mo dhali a’di ki c̱i to kun ’ciṯẖu/ ’kus mmomiiya bas eya gwaṯa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Dhali ki Tap̱a cic̱ki’da shim jin c̱iiyi mo ki c̱ii jin ’bor a’di bwa mo tani Tap̱a o gwo eya dum piti mo ki: Aha/ mina diki doḵ/e jee a’cesh mo gom ’kwani ki sule/ mo haali/ gwalal buni kun kulumkina uni gwo ibwa ta thus ki thus ’peni dhuru’c buni mo. Aha/ si’dayi mina diki ’ce’da ris to sho’k doḵ/e ki sule/ mo kun ’kon ki e kun uḵu mo me’d jin miikika/ mo. ");
INSERT INTO udu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ki mony’cesh diki’d mo tani mo jin sinu aḵa’bany to dhali mo jin ’ciṯẖu/ to uni ’kokin mo, dhali mon’thup̱u’d dhali mom’batha’d, dhali moyurantee dhali mondiṯ mo, dhali montee dhali mon’thiny uni mol daḵ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dhali Arumgimis ki ’bora Nuuh mii mo dhali iya/m piti mo dhali o uni gwo mo ki: Dhodhi maman mo dhali mari is mo dhali ’tu’di mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dhali um mina to/e ḵo/ mo dhali um mina to/e dee ki bir bir mmo’cuḵi ’kup̱ mo, aris to/e kun ’kon e mony’cesh mo dhali aris ’dii kun p̱en e momis mo dhali aris to kun parana ’cesh mo dhali aris to yi’de/ kun ’koni bwaŋ ḵumma/ yi’de/ mo. E me’d bum mo tani uni c̱ikunu um mo. ");
INSERT INTO udu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Aris to kun joc̱kin kun ’kon ki e mo tani uni mini ta tonṯe/ gom um mo, dhali me’d jin c̱ika/ um ton dhii/i’d mmosi mo tani aha/ mina c̱i um aris to ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hili um mini mii dhalku/ ki ’ka to ka basi e mo, haala bas a’di ta mondiki/em piti mo. ");
INSERT INTO udu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Goma bas bum jin ’kona um ki e mo tani aha/ ka jiŋ gana/ aha/ mina ’theḵ gwo mo mmokara kar mo. ’Pena ris tombwaasho mo aha/ mina ’theḵ gwo mo dhali ’peni ’kwani mo. Dhali ’peni aris ’kwani kun ta ikam mo tani aha/ mina ’theḵ gwo gom mondiki/e gi wathi/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","A’diyin jin midi ’kosh wathi/ jwa mo mmogac̱a bas piti a’cesh mo tani abas piti gara/ mina ’kwani gac̱a ’cesh mo, haali/ Arumgimis ki uḵ wathi/ ki jamas pitiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Dhali um mini dho’th maman dhali mar is mo, ki um mini ḵala dho’th ka enthus mo dhali mara mar is kagahara i mony’cesh nycine/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Dhali yan’ko’d Arumgimis ki owa Nuuh dhali iya/ kun nyaḵ ’ko ki a’di gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Hili mo mo ma, aha/ ṯelkina gwom pem jin gamka/ me’d nyaḵki um mo dhali emen bum kun mini baṯẖ um ’ko’d mo ");
INSERT INTO udu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","dhali aris to/e kun ’kon ki e kun uḵu mo kun nyaḵ ’ko ki um mo, ’dii dhali toŋkal, dhali tombwaasho kun nyaḵ ’ko ki um e mony’cesh me’d jin tana uni aris ka ris mmo/iiyu/ ’peni bwam ma ḵur mo. ");
INSERT INTO udu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Aha/ ṯelkina gwom pem jin gamka/ me’d nyaḵki um mo ki aris buŋgwar is gi ’kwani minu ’ce’d sho’k ka gannu/ yi’de/ doḵ/e yisa ki sule/ dhali mony’cesh yisa minu ’ce’d sho’k ka gannu/ yi’de/ doḵ/e yisa ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Dhali Arumgimis ki o gwo mo ki: A’di ta jamas mii gi gwom pem jin gamka/ me’d a’dihe/ mo, a’di jin miga/ gam me’d nyaḵki um mo dhali aris to/e kun uḵu mo kun nyaḵ ’ko ki um mo gom yilaŋkamu/ ma nyaḵum yil buni ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Aha/ karkina bwaam pem e bwam ma raḵ mo, dhali a’di midi ta jamas mii gi gwo jin gamka/ me’d ibwaman aha/ dhali mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ki aha/ mina dhala raḵ mmo’ka ap̱o/ mony’cesh mo dhali ’kwani ki p̱ara bwaa e e bwam ma raḵ mo tani ");
INSERT INTO udu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","aha/ mina ka gwom pem jin gamka/ me’d e mo jin karka/ ibwaman aha/ mo dhali um mo dhali aris to/e kun ’kon ki e mo kun ta shuman isi ’baar mo, dhali yi’de/ midi doḵ/e war ka gannu/ mmo’ce’da ris buŋgwar is sho’k mo yisa ki sule/. ");
INSERT INTO udu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ka bwaa midi di e bwaman ma raḵ mo tani aha/ mina hil ap̱o/ a’di mo dhali ka gwo jin gamu me’d e jin di’d ki sule/ sule/ mo e bwaman ma Arumgimis mo dhali aris to/e kun ’kon ki e mo dhali aris buŋgwar is kun ’kon ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Arumgimis ki owa Nuuh gwo mo ki: A’di ta jamas mii gi gwo jin gamka/ me’d mo, a’di jin miga/ ṯel sho’k ibwaman aha/ mo dhali aris buŋgwar is kun ’kon e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Iya/ ma Nuuh kun iikin ka pije/ ’peni bwaman ma ḵur mo tani jan ’de/ yuḵu gway ka Saam mo, dhali jaŋ kamu/ yuḵu gway ka Haam mo dhali jaŋ kamu/ yuḵu gway ka Yap̱aṯẖ mo. Haam a’di ta’da baba ma Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Uniŋ kwaraŋ gwansan mo tani ita iya/ ma Nuuh mo, dhali ’peni uni gwansan mo tani mony’cesh taki’d gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuuh a’di ta wathin ṯal ’de/ jin ṯwa/a/ jin ḵorki’da ’cesh mo. A’di siki’da mura’th mo. ");
INSERT INTO udu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Dhali a’di ki p̱i yimana mura’th jin ḵa/u ki ŋah ŋah mo, dhali a’di ’koshkunu ki a’di me’da su mo, dhali a’di ishki e gu’b burrinyem piti ki dar gi toŋ kamu/ mmokum is mo. ");
INSERT INTO udu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Dhala Haam jin ta’da ababa ma Kanaan mishki com mmodi is ’te/ mo dhali a’di ki ṯor ikam piti isu/ gwo mo uni kun ’kona pije/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Dhali yan’ko’d Saam dhala Yap̱aṯẖ uni ki bu’th burrinye/ mo, uni ki hi’th a’di ’kup̱a bim buni mmonṯal ’de/ mo dhali ii ka c̱iŋ’ko’d mo dhali kumki ababam buni is piti jin dina a’di is ’te/ mo, dhali bwam/em buni ṯu’kkina uni mo dhali uni ’koki p̱ar com e mmodina a’di is ’te/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ka Nuuh merki e mo ’peni mom piti jin ’kosha yimana mura’th a’di mo dhali mish to jin miina a’di ya/ jin gwa’da’d a’di wakan mo tani ");
INSERT INTO udu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","a’di o gwo mo ki: Monyjee midi di goma Kanaan mo. C̱iŋkina/ jin tanu mmota c̱iŋkina/ mo tani a’di imidi wakan gom ikam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A’di si’da/ o gwo mo ki: Mom’bor mii gi Tap̱a Arumgimis pem midi di goma Saam mo, dhali dhalka Kanaan ta c̱iŋkinam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Arumgimis dwaḵa Yap̱aṯẖ mo ma dhali dhalki a’di c̱a’ba’d e gu’b burrinye/ ma Saam mo, dhali dhalka Kanaan ta c̱iŋkinam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Dhali ’ko’da gannu/ yi’de/ ’baarki’d mo tani Nuuh c̱a’bki’d ki e mo ki yili iss ’kwanimpa ḵarpa’c i’ce’dki iss ’kwanimpa su/ i’ce’dka ’kume’d ap̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Dhali arisa tee ma Nuuh kun c̱a’bkina a’di ki e mo tani uni ’koni iss ’kwanimpa i/iss su/ i’ce’dki iss ’kwanimpa ipesu/ i’ce’dka ’kume’d ap̱o/ mo, dhali a’di wuki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Uni gwansan itana nyaḵum yil gi iya/ ma Nuuh mo uni gun ta Saam dhala Haam dhala Yap̱aṯẖ mo. Iya/ dho’thkunu uni mo ’ko’da gannu/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iya/ ma Yap̱aṯẖ: a’di jin ṯwa/a/ yuḵu gway ka Jumar mo, dhala Majuuj mo dhala Maday mo dhala Yawan mo dhala Ṯubal mo dhala Maashik mo dhala Ṯiras mo. ");
INSERT INTO udu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Dhali iya/ ma Jumar: a’di jin ṯwa/a/ yuḵu gway ka Ashkanaas mo, dhala Rip̱aṯẖ mo dhala Ṯujarmah mo. ");
INSERT INTO udu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Dhali iya/ ma Yawan: a’di jin ṯwa/a/ yuḵu gway ka Aliishah mo, dhala Tarshiish mo dhala Kittiim mo dhala Dudaniim mo. ");
INSERT INTO udu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","’Peni uni ’kwani gwansan kun ’kokin e yana gap̱ mo tani uni a’di ipeperkin mo be. Uni gwansan kun ta iya/ ma Yap̱aṯẖ mo kun ’kon e mony’cesh buni mo, uni ka ’deṯe/ ’deṯe/ ki ’twam buni gun wala uni mo ka waḵ buni i’pen mo dhali ki kal buni ilu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Iya/ ma Haam: a’di jin ṯwa/a/ yuḵu gway ka Kush mo, dhala Masir mo dhala P̱uth mo dhala Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Dhali iya/ ma Kush: a’di jin ṯwa/a/ yuḵu gway ka Saba mo, dhala Hawiila mo dhala Sabtah mo dhala Raamah mo dhala Sabtaka mo. Dhali iya/ ma Raamah: a’di jin ṯwa/a/ yuḵu gway ka Shaba mo, dhala Dadaan mo. ");
INSERT INTO udu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush a’di warki’d ka baba ma Nimruud mo. A’di ta wathi/ en’thi/ jin ṯwa/a/ jin c̱a’bki dem dem e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","A’di ta wathi/ jin c̱a’bki dem dem mmopar ka yempa/ ibwambori Tap̱a mo. Gom gwo gi wakan mo tani a’di onu gwo mo ki: Wathi/ jin waga Nimruud jin c̱a’bki dem dem ibwambori Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Dhali monṯel ’pen gi ’peŋkuman bampam piti mo ta Pam Baabil mo dhali Pan Arak mo dhali Pa Akkad mo, aris uni ’baar mo ’kon e mony’cesh gi Pan Shinaar mo. ");
INSERT INTO udu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","’Peni mony’cesh c̱aan mo tani a’di yaki’d mo e Pa Ashshuur mo dhali nyaŋ Pa Ninawa mo dhali Pa Rahubuteer mo dhali Paŋ Kaalah mo ");
INSERT INTO udu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Dhali Pa Rasan ibwaman gi Pa Ninawa mo dhali gi Paŋ Kaalah mo, a’di jin ta ’peŋkuman bampa/ jin caaca mo. ");
INSERT INTO udu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Masir warki’d ka baba ma Ludim mo dhala Anamiim mo dhala Lahabiim mo dhala Nap̱tuhiim mo ");
INSERT INTO udu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","dhala P̱atrusiim mo dhala Kasluhiim mo (uni i/iiyina ’Kwani gi Pa P̱ilisthiin ’peni cine/ mo) dhali Paŋ Kap̱turiim mo. ");
INSERT INTO udu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan warki’d ka baba ma Sidun mo a’di jin ta ya/m piti jin ṯwa/a/ mo, dhala Hiṯẖ mo ");
INSERT INTO udu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","dhali ’Kwani gi Pa Yabuus mo dhali ’Kwani gi Pa Amuur mo dhali ’Kwani gi Pa Jirjaash mo ");
INSERT INTO udu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","dhali ’Kwani gi Pa Hiwwi mo dhali ’Kwani gi Pa Argi mo dhali ’Kwani gi Pan Siin mo ");
INSERT INTO udu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","dhali ’Kwani gi Pa Arwaad mo dhali ’Kwani gi Pan Samaar mo dhali ’Kwani gi Pa Hamaat mo. Dhali yan’ko’d mo tani awaḵ gi ’Kwani gi Paŋ Kanaan uni ihagaski mony’cesh ki lala’th mo. ");
INSERT INTO udu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Dhali mo gi ’Kwani gi Paŋ Kanaan p̱ar ’twa/ ki ribi/ ribi/ ’peni Pan Sidun e mo jin c̱utha a’di bway ’kup̱ ki Pany Jaraar ki si’d piti jin si’da a’di ntagi Paŋ Ghassa mo dhali ’peni mo jin c̱utha a’di bway ’kup̱ ki bway Pan Saduum mo dhali Paŋ Gamuura mo dhali Pa Admah mo dhali Pa Sabuyiim ki si’d piti jin si’da a’di ntagi Pan Laasha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Uni gwansan uni ta iya/ ma Haam mo ka waḵ buni i’pen mo dhali ki ’twam buni ilu/ mo dhali ki mony’cesh buni ilu/ mo dhali ki kal buni ilu/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Dhali uc̱i dho’thkunu eya Saam si’da/ a’di jin taki’da baba gom uc̱i ma Aabir ’baar mo, a’di jin ta’da kam ma Yap̱aṯẖ jin ca’d mo. ");
INSERT INTO udu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Iya/ ma Saam: a’di jin ṯwa/a/ yuḵu gway ka Iilaam mo, dhala Ashshuur mo dhala Arp̱akshaad mo dhala Lud mo dhala Araam mo. ");
INSERT INTO udu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Dhali iya/ ma Araam: a’di jin ṯwa/a/ yuḵu gway ka Uus mo, dhala Hul mo dhala Jaaṯẖar mo dhala Mash mo. ");
INSERT INTO udu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Dhala Arp̱akshaad warki’d ka baba ma Shaalah mo dhala Shaalah warki’d ka baba ma Aabir mo. ");
INSERT INTO udu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eya Aabir mo tani iya/ su/ dho’thkunu mo. Dhali jan ’de/ yuḵu gway ka P̱aalaj mo haali/ ka teem piti mo tani mony’cesh ḵwa/kunu bwa mo, dhala kam jin ta ’ko’d piti mo tani yuḵu gway ka Yagthaan mo. ");
INSERT INTO udu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yagthaan warki’d ka baba ma Almudad mo dhala Shaalap̱ mo dhala Hadharmoot mo dhala Yaarah mo ");
INSERT INTO udu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","dhala Haduraam mo dhala Usal mo dhala Diglah mo ");
INSERT INTO udu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","dhala Uubal mo dhala Abimaayil mo dhala Shaba mo ");
INSERT INTO udu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","dhala Up̱ir mo dhala Hawiila mo dhala Yubab mo. Aris uni gwansani ’baar mo tani uni ta iya/ ma Yagthaan mo. ");
INSERT INTO udu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Dhali mony’cesh jin ’kokina uni nycine/ mo tani a’di p̱arki ’twa/ ki ribi/ ribi/ mo ’peni Pa Misha mo e mo jin ta bway jin c̱u’thki ’twa/ ki Pan Sap̱aar ibampa/ ki paŋ ’kuwosh gi mom’pesho’k mo. ");
INSERT INTO udu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Uni gwansan ita iya/ ma Saam mo ka waḵ buni i’pen mo dhali ki ’twam buni gun wala uni ilu/ mo dhali ki mony’cesh buni ilu/ mo dhali ki kal buni ilu/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Uni gwansan itana waḵ gi iya/ ma Nuuh mo isi gi gwom buni jin bele’thkunu mo dhali gom kal buni mo, dhali ’peni uni gwansan mo tani kal gi ’kwani uni ihagaski mony’cesh ki lala’th mo ’ko’da gannu/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dhali aris ’kwani ’baar mo kun ’koni mony’cesh mo tani uni ta gi jasi ’twan ’de/ jin wala uni kadhamo/ mo dhali ’twa/ yisa misha uni ki thatha/ thatha/ yisa. ");
INSERT INTO udu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Dhali me’d jin borkina ’kwani is mo e mom’pesho’k mo tani uni gamki mony’cesh jin ta’da thiṯẖin thiṯẖ mo e Pan Shinaar mo dhali uni ki ’ko nycine/ mo. ");
INSERT INTO udu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Dhali uni ki o gwo ka rem ’kup̱ mo ki: Iiyu/ bala dhalki ana uḵa je mo dhali ’thos uni mo ki ṯil ṯil mo. Dhali uni tan ga jeŋ gu’b ’peni wosh mo dhala dena ma sip̱ti mmorus to mo. ");
INSERT INTO udu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Dhali yan’ko’d uni ki o gwo mo ki: Iiyu/ mo dhalki ana nyaŋa dhan ’peŋkuman bampa/ gom is bana mo dhali gu’b jin turatur, a’di jin midi gu ’kup̱ piti gamki mis mo dhali dhalki ana ’kwara gwo gom is bana mo isi ciki/ ki ana ’konuki c̱eker bwa e bwam/e gi mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Dhali Tap̱a a’di thulki’d ka ’cesh mo mmop̱ar ’peŋkuman bampa/ e mo dhali gu’ba turga/ yan mo a’di jin nyaŋkina iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Dhali Tap̱a ki o gwo mo ki: Hili mo mo ma, uni ta ’kwani jin ṯala en ’de/ mo dhali uni ’baar mo wal ’twan ṯal ’de/ mo, dhali a’di ta jasi monṯel ’pen jin ṯwa/a/ mo a’di jin mina uni mii mo, dhali ma to yin jin mina uni o bwa mmomii mo tani a’di midi diki ta to jin midi p̱i uni e mo. ");
INSERT INTO udu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Iiyu/ mo dhali dhalki ana iina ka ’cesh mo dhali tuŋkur uni ’twa/ is mo ki uni mini ’koki mish ciḵ gwo ka gam ’kup̱ mo jin wala uni mo. ");
INSERT INTO udu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wakan Tap̱a ki c̱eker uni bwa e mo ’baar mo ’peni mun ntagi bwam/e gi mony’ceshi ’baar mo, dhali uni dhalki ’peŋkuman bampa/ ’pen ki dar gi mo jin ’kona uni ki ’ka a’di ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Wakan gway piti yuḵu gway ka Baabil mo haali/ Tap̱a tuŋkurki ’twa/ gi mony’ceshi ’baar mo is mo, dhali ’peni mun mo tani Tap̱a ki c̱eker uni bwa eya ris bwam/e gi mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Uni gwansan uni ita emen ma Saam mo. Ka Saam ’kokina yil iss ’kwanimpa imudhe’d ka dhan piti mo tani a’di warki’d ka baba ma Arp̱akshaad mo ’ko’di yili su/ mo i’ko’di gannu/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Dhala Saam c̱a’bki’d ki e mo ’ko’di dho’th ma Arp̱akshaad mo ki yili iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa imudhe’d mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ka Arp̱akshaad c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka ḵarpa’c mo tani a’di warki’d ka baba ma Shaalah mo. ");
INSERT INTO udu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Dhala Arp̱akshaad c̱a’bki’d ki e mo ’ko’di dho’th ma Shaalah mo ki yili iss ’kwanimpa i/iss ’de/ i’ce’dka kwara mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ka Shaalah c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka ’kume’d mo tani a’di warki’d ka baba ma Aabir mo. ");
INSERT INTO udu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Dhala Shaalah c̱a’bki’d ki e mo ’ko’di dho’th ma Aabir mo ki yili iss ’kwanimpa i/iss ’de/ i’ce’dka kwara mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ka Aabir c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka ’kume’d i’ce’dka doŋon ap̱o/ mo tani a’di warki’d ka baba ma P̱aalaj mo. ");
INSERT INTO udu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Dhala Aabir c̱a’bki’d ki e mo ’ko’di dho’th ma P̱aalaj mo ki yili iss ’kwanimpa i/iss ’de/ i’ce’dki iss ’kwanimpa ’de/ i’ce’dka ’kume’d ap̱o/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ka P̱aalaj c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka ’kume’d mo tani a’di warki’d ka baba ma Ra/u mo. ");
INSERT INTO udu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Dhala P̱aalaj c̱a’bki’d ki e mo ’ko’di dho’th ma Ra/u mo ki yili iss ’kwanimpa i’kume’d i’ce’dka pedoŋon mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ka Ra/u c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka ’kume’d i’ce’dka su/ ap̱o/ mo tani a’di warki’d ka baba ma Saruuj mo. ");
INSERT INTO udu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Dhala Ra/u c̱a’bki’d ki e mo ’ko’di dho’th ma Saruuj mo ki yili iss ’kwanimpa i’kume’d i’ce’dka pesu/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ka Saruuj c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka ’kume’d mo tani a’di warki’d ka baba ma Nahur mo. ");
INSERT INTO udu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Dhala Saruuj c̱a’bki’d ki e mo ’ko’di dho’th ma Nahur mo ki yili iss ’kwanimpa i’kume’d mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ka Nahur c̱a’bki’d ki e ki yili iss ’de/ i’ce’dka pedoŋon mo tani a’di warki’d ka baba ma Taarah mo. ");
INSERT INTO udu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Dhala Nahur c̱a’bki’d ki e mo ’ko’di dho’th ma Taarah mo ki yili iss ’kwanimpa ipe’de/ i/aṯẖ ’de/ mo, dhali a’di ta’dki iya/a tiya mo dhali i’bwa/a tiya mo. ");
INSERT INTO udu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ka Taarah c̱a’bki’d ki e ki yili iss ’kwanimpa ikwara i’ce’dka ’kume’d mo tani a’di warki’d ka baba ma Abraam mo dhala Nahur mo dhala Haraan mo. ");
INSERT INTO udu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dhali uni gwansan mo tani uni ita emen ma Taarah mo. Taarah a’di ta’da baba ma Abraam mo dhala Nahur mo dhala Haraan mo, dhala Haraan ta’da baba ma Luuth mo. ");
INSERT INTO udu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haraan wuki’di ṯwa/a/ mo ki com ga Taarah mo eya ’cesh jin dho’thkunu a’di mo e Pa Ur ma Kaldaan mo. ");
INSERT INTO udu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Dhala Abraam dhala Nahur mashkin mo. Dhali asha Abraam yuḵu gway ka Saray, dhali gway gi asha Nahur yuḵu ka Milkah mo a’di jin ta ’bwa/ ma Haraan mo a’di jin ta com ga Milkah dhala Yiskah mo. ");
INSERT INTO udu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Dhala Saray a’di ta’da burum mo. Ayim ta ga ’ciŋ kamuwa? ");
INSERT INTO udu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taarah ki susa Abraam jin ta ya/m piti mo dhala Luuth jin ta’da ’ci ma Haraan mo, jin tana a’di adhancom mo, dhala Saray jin ta’da mar piti mo, a’di jin ta ash gi ya/m piti jin ta’da Abraam mo, dhali uni iikin mo mmonṯal ’de/ mo ’peni Pa Ur ma Kaldaan mmo/ii e bampa/ gi Paŋ Kanaan mo. Hili ki uni p̱u’dkin e Pan Haraan mo tani uni ki ’ko mo be. ");
INSERT INTO udu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Yil ma Taarah jin c̱a’bkina a’di ki e mo tani a’di ta yili iss ’kwanimpa i’kume’d i’ce’dka mudhe’d mo, dhala Taarah wuki’d mo e Pan Haraan mo be. ");
INSERT INTO udu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Dhali Tap̱a ki owa Abraam gwo mo ki: Yaku/ mo ’peni bampam pini mo dhali ’peni ’kwani ma bas pini mo dhali ’peni ’kwani gi gu’b gi cim mo e mony’cesh jin miga/ ṯor /e mo. ");
INSERT INTO udu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Dhali aha/ mina kar /e mmota dhan kal caaca mo, dhali aha/ mina ’bor /e mii mo dhali kar gway pini ki ca mo, wakan ki /e mini ’bora ’bor mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aha/ mina ’bor uni gwansan mii gun ’bor /e mii mo dhali a’di jin midi jee /e mo tani aha/ si’da/ mina jee a’di mo, dhali gom /e mo tani arisa waḵ gi ’kwaniny’cesh mo tani minu ’bor mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Wakan Abraam yaki’d mo, me’d gwo jin ṯorkina Tap̱a a’di mo dhala Luuth yaki’d nyaḵki a’di mo. Dhala Abraam ’kokini yili issi kwara i’ce’dka ḵarpa’c mo me’d jin yakina a’di ’peni Pan Haraan mo. ");
INSERT INTO udu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Dhala Abraam ki susa Saray jin ta ashim piti ilu/ mo dhali a’di ki susa Luuth jin ta’da ’ci ma kam mo, dhali aris tom buni kun tana uni mo uni gun tulkina uni is mo, dhali ’kwani kun gamkina uni e Pan Haraan. Dhali uni ’kakin ka ji sho’k ki bway Paŋ Kanaan mo. Ki uni p̱u’dkin e bampa/ gi Paŋ Kanaan mo tani ");
INSERT INTO udu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abraam yaki’d ki tur mo e mony’cesh gi bampa/ gi Pan Shakiim mo e dhan cwa jin wana e ka ’kwaṯṯan ma Murah mo. Ka cim c̱aan mo tani ’Kwani Kanaan uni ’kokin e mony’cesh c̱aan mo. ");
INSERT INTO udu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Dhali yan’ko’d Tap̱a ki piya Abraam i is mo mmo/o gwo mo ki: E emen pini mo tani aha/ mina c̱i uni mony’cesh yansan mo. Wakan a’di ki nyaŋ agwaṯa/ jin miinuwa bas gom Tap̱a mo a’di jin piki a’di i is mo. ");
INSERT INTO udu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yan’ko’d a’di ki thoṯẖ mo e ’kuwosha turga/ gi mom’pesho’k ki Pam Beeṯ/iil mo dhali a’di ki ṯel gu’b burrinyem piti mo. Pam Beeṯ/iil di’d ka bora luŋgu’b mo dhali Pa Aay di’d ki ’ban gi mom’pesho’k mo. Dhali e mun mo tani a’di ki nyaŋa gwaṯa/ jin miinuwa bas gom Tap̱a mo dhali a’di ki yuḵ gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Dhala Abraam yaki’d mo mmoya naskina/ ’kup̱ ki bway ma Januub mo. ");
INSERT INTO udu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Dhali ṯe/ ’koshki’d kagahara mo e bampa/ mo. Wakan Abraam yaki’d ka luŋgu’b e Pam Masir mo ki ya yilkina/ mo e mun mo, haali/ ṯe/ shina ’kosh ki shi/ e bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ki a’di ’dishi ’twa/ mmocic̱ Pam Masir mo tani a’di ki owa Saray gwo mo, a’di jin ta ash mo ki: Aha/ misha ki /e tana ’bom jin ta jaro/ ki jaro/ jin ṯeru/ mo. ");
INSERT INTO udu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Dhali ki ’Kwani gi Pam Masir mini p̱ar /e e mo tani uni mini o gwo mo ki: A’di yansan ta ashim piti mo. Dhali yan’ko’d uni mini ’kosh aha/ jwa mo, hili /e minu dhalku/ ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","/E mini o gwo mo ki /e ta ’bwah pem mo, ma a’di mina to ya ki ’bore/ gom aha/ gom /e mo, dhali mondiki/em pem minu ’tash ’twa/ ’peni jwa gom miim pini mo. ");
INSERT INTO udu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ka Abraam cic̱ki’d e Pam Masir mo tani ’Kwani gi Pam Masir p̱arki’da ’bom e jin shina jaro/ i me’d mo. ");
INSERT INTO udu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Dhali ki iya/ ma P̱irawn p̱arki’da yim e mo tani uni maŋkina yim eya P̱irawn mo. Dhala ’bom suskunu mo e gu’b ma P̱irawn mo. ");
INSERT INTO udu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Dhali gom gway ma yim mo tani a’di mii’d ki ’bore/ goma Abraam mo. Dhali a’di ta’dki ḵa’bal mo dhala morbip̱ mo dhali gwasin thuluny mo dhali ’kwani kun miina ṯu’c mo dhali c̱iŋkina/ nyara/ mo dhali kuman thuluny mo dhali kalman mo. ");
INSERT INTO udu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hili Tap̱a ’koshki’da P̱irawn dhali kuŋ gu’b piti ka dhan ’ba’th jin wo’cki is she/ mo goma Saray, a’di jin ta asha Abraam mo. ");
INSERT INTO udu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Wakana P̱irawn yuḵki’da Abraam mo dhali o a’di gwo mo ki: Atinta tan jin miina /e aha/ kan mo? Atinta dina /e ki ṯor aha/ gwo ka yim ta ashin mo? ");
INSERT INTO udu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Dhali /e ki ’cur gwo o ka yim ta ’bwahan mo. Wakan aha/ de budha yim mo mmo’taki ta ashim pem mo. Shwane/, ashim pini a’dan mo. Susi a’di mo, dhali iiyi mo. ");
INSERT INTO udu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Dhala P̱irawn ki c̱i gwaṯẖ gwoŋḵan mo isi gom a’di mo. Dhali uni ki kar ki a’di ’pen mo nyaḵki ashim piti mo dhali aris to kun tana a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Wakan Abraam yaki’d ka gagamis ’peni Pam Masir mo a’di uni ki ashim piti nyaḵki a’di mo dhali aris to kun tana a’di mo dhala Luuth si’da/ nyaḵki uni mo eya Januub mo. ");
INSERT INTO udu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Dhala Abraam ta pa ki pa mo e to/e mo dhali e ’dolkon kush mo dhali e ’dolkon gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Dhali a’di yaki’d ’pena Januub mo ntagi Pam Beeṯ/iil mo e mo jin dikina gu’b burrinyem piti ki monṯel ’pen mo, mo jin diki’di bwaman gi Pam Beeṯ/iil mo dhali gi Pa Ayy mo, ");
INSERT INTO udu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","e mo jin nyaŋkina a’diya gwaṯa/ jin miinuwa bas mo iṯwa/a/ mo. Dhali e mun mo tani a/Abraam a’di yuḵki gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Dhala Luuth, a’di jin yaki’d nyaḵka Abraam mo tani a’di si’da/ ta’dki ma’diny ḵa’bal ka ris mo dhali ma’diny mi ka ris mo dhali to/e ka ris mo dhali gu’b burrinye/ ka ris mo. ");
INSERT INTO udu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ki a’di wakan mo tani bampa/ mol uni thip̱ mo uni su/ mmonyaḵ uni ’ko mo mmonṯal ’de/ mo, haali/ tom buni kun takina uni mo tani uni tana ris ka ris kagahara mo. Wakan uni moli nyaḵ ’ko mo mmonṯal ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Dhali mo jin biruwa bir diki’di bwaman imanhil to/e ma Abraam mo dhali imanhil to/e ma Luuth mo. Dhali ka tee c̱aan mo tani ’Kwani gi Paŋ Kanaan mo dhali ’Kwani gi Pam Paaris ’kokin mo e bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Dhali yan’ko’d Abraam ki owa Luuth gwo mo ki: Dhalku/ ki dhal mo jin biruwa bir bway mo mmodi ibwaman ana mo, aha/ dhali /e mo, dhali ibwaman imanhil to/em pini mo dhali imanhil to/em pem mo haali/ ana tana ikam mo. ");
INSERT INTO udu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dina bampa/ isi ’baar mo ki di ibwambori /e mo ’taa? Ḵwa/ki is pini bwa mo ’peni aha/ mo ma. Waḵki/ /e mini bu’th ’ban ma biny cam mo tani wakan aha/ mina ya ki ’ban ma bim poros mo, walla waḵki/ /e mini bu’th ’ban ma bim poros mo tani wakan aha/ mina ya ki ’ban ma biny cam moyi. ");
INSERT INTO udu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Dhala Luuth ’de’kki em piti ki mis mo dhali mishki mo mo ki embul ma Uurdun a’di ya’thkunu ki ’bore/ eya ris mo ’baar mo me’d bwaagoŋ jin ta monsinu gi Tap̱a mo, me’d bampa/ gi Pam Masir si’da/ e mo jin c̱utha a’di bway ’kup̱ ki Pan Suugar mo. Yansan diki’di ṯwa/a/ mo ki Pan Saduum dhali Paŋ Gamuura ’konuki ’ce’d sho’k mo ki Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Wakan mo Luuth kwanyki’d gom is piti aris mo ’baar mo jin ta embul ma Uurdun mo, dhala Luuth yaki’d mo ’kup̱ ki mom’pesho’k mo. Wakan uni ḵwa/ki is buni bwa mo ka rem ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraam c̱a’bki’d mo e bampa/ gi Paŋ Kanaan mo, ka Luuth c̱a’bki’d mo e bwaŋ ’kwani eya ris ’peŋkuman bampa/ gi embul mo dhali a’di ijoc̱ki gu’b burrinyem piti ntagi Pan Saduum mo be. ");
INSERT INTO udu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Dhali ’Kwani gi Pan Saduum mo tani uni ta uni gun ta thus ki thus mo dhali gun ta imanmii miinthus kun shi/ashi/ ap̱o/ Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Dhali Tap̱a ki owa Abraam gwo mo ’ko’da Luuth ḵwa/ki is piti bwa mo ’pena Abraam mo ki: ’Deki em pini imis mo ma, dhali hili mo mo ma, ’peni mo jin dina /e nycine/ mo ’kup̱ ki moŋ’ko’d gwar ma bim poros mo dhali ’kup̱ ki moŋ’ko’d gwar ma biny cam mo dhali ’kup̱ ki mom’pesho’k mo dhali ’kup̱ ki bora luŋgu’b mo, ");
INSERT INTO udu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","haali/ aris mony’cesh ’baar mo jin misha /e mo tani a’di miga/ c̱i gom /e mo dhali gom emen pini kun mini pi ’peni /e mo ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aha/ mina dhu emen pini kun mini pi ’peni /e mo mmota aris me’d emen gi bu’da’cesh gi mony’cesh mo. Wakan mo tani waḵki/ wathiŋ kamu/ mishi emen gi bu’da’cesh gi mony’cesh deŋ e mo tani emen pini kun mini pi ’peni /e mo si’da/ minu mish deŋ e mo be. ");
INSERT INTO udu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Cuyi mis mo ma, dhali ya ki sho’k ki tur mo e mony’cesh yan mo ka luc̱ piti mo dhali ki beem piti mo haali/ aha/ mina c̱i a’di ki /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Wakan Abraam ijoc̱ki gu’b burrinyem piti mo dhali a’di p̱u’dki’d mo dhali c̱a’bki’d mo e ’ko’d gwar gi dhan cwa jin wana e ka ’kwaṯṯan ma Mamra kun ’kon e Pa Habruun mo. Dhali e mun mo tani a’di ki nyaŋa gwaṯa/ jin miinuwa bas gom Tap̱a mo be. ");
INSERT INTO udu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ka tee ma Amraap̱al jin ta’da maliḵ gi Pan Shinaar mo dhala Aryuuk jin ta’da maliḵ gi Pa Allasar mo dhala Kadarla/oomar jin ta’da maliḵ gi Pa Iilaam mo dhala Tid/aal jin ta’da maliḵ gi Pa Juyim mo tani ");
INSERT INTO udu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","imaliḵ gwansan miiki mo/as ap̱owa Baara/ jin ta’da maliḵ gi Pan Saduum mo dhala Birshaa/ jin ta’da maliḵ gi Paŋ Gamuura mo dhala Shin/aab jin ta’da maliḵ gi Pa Admah mo dhala Shim/iibar jin ta’da maliḵ gi Pan Sabuyiim mo dhali a’di jin ta’da maliḵ gi Pam Baala/ mo (yansan ita Pan Suugar mo). ");
INSERT INTO udu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Dhali aris ’kwani ma mee gwansan gamki ’twa/ ’kup̱ mmonṯal ’de/ mo e Embul ma Siddiim mo (yansan ita a’di jin ta Al ’Doŋkoro/ mo). ");
INSERT INTO udu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dhali yil ’koni ’kume’d i’ce’dka su/ mo kun miikina uni to mo goma Kadarla/oomar mo, hili ki yil ’koni ’kup̱i ’kume’d i’ce’dka kwara mo tani uni pishki is ka le’d mo. ");
INSERT INTO udu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Dhali ki yil ’koni ’kup̱i ḵarpa’c aṯẖ ’de/ mo tani Kadarla/oomar dhali imaliḵ kun nyaḵ ’ko ki a’di mo p̱u’dkin mo dhali ’dap̱ki uni e bwaŋ’kwariny buni mo uni gun ta ’Kwani Rap̱a e Pa Ashtaruṯẖgarnaayim mo dhali ’Kwani Suus e Pa Haam mo dhali ’Kwani Iim e Pan Shawagiryataayim mo ");
INSERT INTO udu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","dhali ’Kwani Hur e Wosh Si/iir buni mo ntagi Pam P̱aran mo e mo jin di’d e gwayu/ gi mombwaasho mo. ");
INSERT INTO udu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Dhali yan’ko’d mo tani uni doḵkin ka nyaŋ’ko’d mo e Pa Eenmishp̱aath (yansan ita Paŋ Kaadish mo), dhali uni ’dap̱ki aris bampa/ gi ’Kwani gi Pa Amaliik e bwaŋ’kwariny buni mo ki ’Kwani gi Pa Amuur ilu/ mo uni gun ’kokin mo e Pa Hassuun Tamar mo. ");
INSERT INTO udu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Dhali yan’ko’d mo tani maliḵ gi Pan Saduum mo dhala maliḵ gi Paŋ Gamuura mo dhala maliḵ gi Pa Admah mo dhala maliḵ gi Pan Sabuyiim mo dhala maliḵ gi Pam Baala/ mo (yansan ita Pan Suugar mo), uni iikin ka pije/ mo dhali uni gamki ’twa/ ’kup̱ mo e mo ma mee mo e Embul ma Siddiim mo ");
INSERT INTO udu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","uni nyaḵka Kadarla/oomar jin ta’da maliḵ gi Pa Iilaam mo dhala Tid/aal jin ta’da maliḵ gi Pany Juyim mo dhala Amraap̱al jin ta’da maliḵ gi Pan Shinaar mo, dhala Aryuuk jin ta’da maliḵ gi Pa Allasar mo, uni gun ta imaliḵ kun ’koni doŋon mo ap̱o/ imaliḵ kun ’koni mudhe’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dhali Embul ma Siddiim mo tani a’di i’tu’dkunu ki jis ma dena ma sip̱ti mo, dhali me’d jin soyina maliḵ gi Pan Saduum mo dhala maliḵ gi Paŋ Gamuura mo tani kun tiya ṯa’kkin e uni mo, dhali kun tiya sokin mo e ’kuwosh mo. ");
INSERT INTO udu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wakan mo tani uni kun ta ’kup̱ gi uni mo tani uni ki budha ris to kun tana ’Kwani gi Pan Saduum mo dhali ’Kwani gi Paŋ Gamuura mo dhali aris tonṯem buni gom bway mo, dhali uni iikini bway buni mo. ");
INSERT INTO udu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Dhala Luuth si’da/ ibu’thkina uni mo, a’di jin ta ya/ ma kam ma Abraam mo, a’di jin c̱a’bki’d mo e Pan Saduum mo dhali aris tom piti bu’thkina uni mo dhali uni iikin mo be. ");
INSERT INTO udu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Dhali yan’ko’d jan ’de/ jin yeki’d mo tani a’di p̱u’dki’d mo dhali a’di ki ṯora Abraam, a’di jin ta ji Ibraani gwo mo, a’di jin diki’d mmoc̱a’b mo e ’ko’d gwar gi dhan cwa jin wana e ka ’kwaṯṯan ma Mamra mo, a’di jin ta wathi/ gi Pa Amuur mo, jin ta’da kam ma Ashkuul mo dhala Anir mo. Uni ta imangam gwo me’d mo nyaḵka Abraam mo. ");
INSERT INTO udu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Dhali ka Abraam ciḵki gwo mo ki a’di jin ta’da bas piti ibu’thkunu mo mmota habuus mo tani a’di ki shu ’kwanim piti kun ye’thkunu sho’k ka pije/ mo uni kun dho’thkunu mo e gu’b piti mo, uni kun ’kon ki iss ’kwanimpa ḵarpa’c i’ce’dka ’kume’d i’ce’dka pekwara ap̱o/ mo dhali uni iikin mo mmo/ur uni isho’k mo ntagi Pan Daan mo. ");
INSERT INTO udu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Dhali a’di ki ḵwa/ ’kwani ma meem piti gun gamki ’twa/ ’kup̱ bwa mo ap̱o/ uni ki mon’thiny mo, dhali a’di uni ki ic̱iŋkinam piti ilu/ mo ’koshki uni mo dhali urki uni isho’k mo ntagi Pan Hubah mo jin di’d ki ’ban ma bim poros gi Pan Dimashk mo. ");
INSERT INTO udu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Dhali yan’ko’d a’di ki ’doyu aris to ka nyaŋ’ko’d mo, dhali a’di si’da/ ki sus abas piti ka Luuth ka nyaŋ’ko’d mo nyaḵki tom piti mo ki up̱i lu/ mo dhali ’kwani ma mee gara/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Dhali ’ko’di modoḵ piti ka nyaŋ’ko’d mo ’peni mo jin p̱inuwa Kadarla/oomar e mo dhali itap̱a kun nyaḵ ’ko ki a’di mo tani tap̱a gi Pan Saduum mo yaki’d ka pije/ mmogam a’di ’kup̱ mo e Embul ma Shawa (a’di jin onu mo ki, Embul ma Maliḵ mo). ");
INSERT INTO udu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Dhala Malkisaadag si’da/ jin ta’da maliḵ gi Pan Saliim mo a’di ki ’doyu tonṯe/ ka pije/ mo dhali yimana mura’th jin ḵa/u ki ŋah ŋah mo. A’di ta’da gasiis ma Arumgimis jin Cayaa/ e ki Ca mo. ");
INSERT INTO udu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Dhali a’di ’borki a’di mii mo dhali oki gwo mo ki: Mom’bor mii midi di goma Abraam mo ka Arumgimis jin Cayaa/ e ki Ca mo, a’di jin uḵki momis dhali mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dhali mom’bor mii midi di si’da/ goma Arumgimis jin Cayaa/ e ki Ca mo, a’di jin c̱iki uni kun ta ’kup̱ ki /e mo e me’d pini mo. Dhala Abraam ki c̱i a’di to jin ’dap̱ki’da ’dap̱ ’twa/ ka ’kume’d mo ’peni aris to ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Dhala maliḵ gi Pan Saduum oki’da Abraam gwo mo ki: C̱iyi aha/ ’kwani mo ma, hili budha ris to gom is piniŋ gana/ ma. ");
INSERT INTO udu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Hili Abraam oki’da maliḵ gi Pan Saduum gwo mo ki: Aha/ thulkina gwo me’da p̱o/ gom Tap̱a Arumgimis jin Cayaa/ e ki Ca mo, a’di jin uḵki momis dhali mony’cesh mo, ");
INSERT INTO udu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ki aha/ mina ’taki diki budha thus mo walla wac̱kana ap̱p̱a/ mo walla ma toŋ kamu/ jin ta jim pini moyi, isi ciki/ ki /e mini o gwo mo ki: Aha/ de aha/ ikarkina Abraam mmota pa ki pa mo. ");
INSERT INTO udu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Toŋ kamu/ miga/ bu’th yisa, hili jasi a’di jin shwakina ’kwanin dhuru’c mo dhali to jin pwaḵkunu bwa mo gom ’kwaniŋ gwas kun nyaḵ ii ki aha/ mo. Dhalka Aanir mo dhala Ashkuul mo dhala Mamra mo bu’th to kun pwaḵkunu bwa mo gom uni mo ma. ");
INSERT INTO udu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","’Ko’di to gwansan mo tani gwo gi Tap̱a p̱u’dki’d mo eya Abraam mo ki tonyjan mo mmo/o gwo mo ki: Dhalki is ki ḵo/ mo ma, Abraam. Aha/ tana goŋgorom pini mo. Adhan to jin ish ḵumma/ jin caaca kagahara mo tani a’di midi ta jim pini mo. ");
INSERT INTO udu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Hili Abraam oki gwo mo ki: Ayy Tap̱a Arumgimisa ki to jin ta’da ta imina /e c̱iyaa/ mo? haali/ aha/ ṯikirkina di mo ki dar gi uc̱i mo dhali a’di jin midi ḵal mal gom gu’b pem mo tani a’di ita Eli/aasar gi Pan Dimashk mo. ");
INSERT INTO udu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Dhala Abraam oki gwo mo ki: Hili mo mo ma, emena kamu/ yisa c̱ikina /e aha/ mo, dhali c̱iŋkina/ jin dho’thkunu mo e gu’b pem mo tani a’di midi ta a’di jin midi ḵal mal pem mo. ");
INSERT INTO udu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Dhali hili mo mo ma, gwo gi Tap̱a p̱u’dki’d mo e a’di mo mmo/o gwo mo ki: Wathi/ yan midi ta amanḵal mal pini mo yisa. Ya/m piniŋ gana/ a’di imidi ta amanḵal mal pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Dhali a’di suski a’di mo ka pije/ mo dhali oki gwo mo ki: Hilki /e mo ’kup̱ki momis mo, dhali deŋi arisa cul e mo waḵki/ /e mini mish uni deŋ e mo. Dhali yan’ko’d a’di oki a’di gwo mo ki: Wakan be, emen pini kun mini pi ’peni /e mo tani uni imini ’ko mo be. ");
INSERT INTO udu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Dhali a’di gamki Tap̱a gwo is mo dhali a’di karki a’di gom a’di mo ki mo ma ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Dhali a’di oki a’di gwo mo ki: Aha/ tana Tap̱a mo, a’di jin suski /e mo ’peni Pa Ur ma Kaldaan mo mmoc̱i /e mony’cesh yan mmobu’th mo be. ");
INSERT INTO udu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Hili a’di oki a’di gwo mo ki: Ayy Tap̱a Arumgimisa, ki tonta imiga/ mish mo mo ki aha/ mina bu’th a’diya? ");
INSERT INTO udu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","A’di oki a’di gwo mo ki: ’Doyu/ i aha/ anas bip̱ jin ta’d gi yili kwara mo ma dhali kuman mi jin ta’d gi yili kwara si’da/ mo dhali arasiŋ ḵa’bal jin ta’d gi yili kwara gara/ dhali bimbir gurko/ mo dhali gurko/ jin bap̱ki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Dhali a’di ’doyi’da ris to gwansan e a’di mo dhali ’ciṯẖki uni bwa mo ka ’ban su/ mo dhali ’bwanu’ba kanu/ ’thikina a’di mo ka p̱ar ’bana kamu/ mo ka ’deṯe/ ’deṯe/ mo. Hili ’dii gwansan ’ciṯẖkina a’di bwa mo ki ’ban su/ mo yisa. ");
INSERT INTO udu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Dhali me’d jin p̱u’dkina ’dii kun ’kwar to ka gwap̱i/ mo ka ’cesh mo ap̱o/ buŋgwar isa goŋgoro/ mo tani Abraam ki ur uni asho mo be. ");
INSERT INTO udu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Me’d jin din ma tente/ mmoyul mo tani mo jin ’ce’du e kagahara biṯki’da p̱owa Abraam mo. Dhali hili mo mo ma, dhan mondhurumi’d jin deenu ki bir bir biṯki’da ap̱o/ a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Dhali yan’ko’d Tap̱a oki’da Abraam gwo mo ki: Mishi gwo ’ban mo ma me’d to jin ’tashu ’twa/ mo ki emen pini kun mini pi ’peni /e mo tani uni mini ta uni kun iiki iiŋ ’kus e bampa/ jin diki ta jim buni mo, dhali uni mini ta c̱iŋkina/ e mun mo, dhali uni minu siri’c ki sho’k mo ki yili iss ’kwanimpa i/iss ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Hili aha/ mina dhu uni e mo jin dwallu gwo mo, kal gi ’kwani gwansan jin mina uni mii to mo, dhali ŋ’ko’d mo tani uni mini p̱u’du/ ka pije/ mo mmota gi to kun ish ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Dhali hili gom is pini mo tani /e mini ya e icim mo e moŋḵu’th is mo. /E minu kan mo ki /e mini ta adhan mo ki ’bore/ mo, e mo jin canu ki yil mo. ");
INSERT INTO udu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Dhali uni mini doḵu/ mmahan ka nyaŋ’ko’d mo e bwaŋ ’kwani ma nyaḵum yil kun min ma ap̱o/i ’ko/i doŋon mo, haali/ miinthus gi ’Kwani Amuur mo a’di ithimkunu mo yisa naskina/ moyi. ");
INSERT INTO udu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ka tente/ yulki’d mo dhali mo di’d ki mondhurum mo tani hili mo mo ma, ’ku’kus gwansan pekunu ’kup̱ mbwaman mo ka nos jin ’thanu o’d nycine/ mo jin diki’d mo mmoya aku’d mo dhali ki dhantho/ o’d si’da/ jin diki’d mmoshwa ka le’dan mo. ");
INSERT INTO udu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ka tee yin mo tani Tap̱a gamki gwo me’d mo nyaḵka Abraam mo mmo/o gwo mo ki: E emen kun mini pi mo ’peni /e mo tani aha/ mina c̱i bampa/ yan mo ’peni yi’deŋ ḵumma/ ma Masir mo ntagi dhan yi’deŋ ḵumma/ ma Elp̱uraat mo ");
INSERT INTO udu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","a’di jin ta bampa/ gi ’Kwani Giin mo, dhali ’Kwani Genissi mo, dhali ’Kwani Gadmuun mo, ");
INSERT INTO udu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","dhali ’Kwani Hiṯẖṯẖa mo, dhali ’Kwani P̱aaris mo, dhali ’Kwani Rap̱a mo, ");
INSERT INTO udu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","dhali ’Kwani Amuur mo, dhali ’Kwani Kanaan mo, dhali ’Kwani Jirjaash mo, dhali ’Kwani Yabuus mo. ");
INSERT INTO udu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Dhala Saray, a’di jin ta asha Abraam mo tani ayim dho’thki a’di a’ciŋ kamu/ yisa. Dhala yim ta’dki nyarany c̱iŋkina/ gi Pam Masir jin yuḵu gway ka Haagar mo. ");
INSERT INTO udu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Dhala Saray oki’da Abraam gwo mo ki: Hili mo mo ma, Tap̱a a’di ki non aha/ mo mmodho’th uc̱i mo. Mashi nyarany c̱iŋkinam pem mo ma, ma a’di miga/ gam uc̱i ki a’di moyi. Dhala Abraam ciḵki ’twa/ ma Saray mo be. ");
INSERT INTO udu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wakan ’ko’di Abraam c̱a’bki’d mo e Paŋ Kanaan mo ki yili ’kume’d mo tani Saray jin ta asha Abraam mo tani bu’thki’da Haagar jin ta ji gi Pam Masir mo dhali jin ta nyarany c̱iŋkina/ ma yim mo dhali c̱iki a’di ka Abraam jin ta’da kaṯẖim piti mo mmota ash mo. ");
INSERT INTO udu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Dhali a’di mashki’da Haagar mo dhala yim bwaaki’d mo. Dhali ka yim mishki’d mo ka yim bwaaki’d mo tani ayim hilki’da ’bom jin karu mmohil nyarany c̱iŋkina/ yin ka waḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Dhala Saray ki owa Abraam gwo mo ki: Dhalki to jin ṯẖuthu mii ap̱o/ aha/ mo di /e ’ba/ mo ma. Aha/ de c̱ikina /e nyarany c̱iŋkinam pem mmokoṯẖ e me’d pini mo dhali ka yim mishki’d mo ka yim bwaaki’d mo tani ayim ki hil aha/ ka waḵ mo. Dhalki Tap̱a a’di idwall gwo ibwaman /e mo dhali aha/ mo ma. ");
INSERT INTO udu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Hili Abraam ki owa Saray gwo mo ki: Hili mo mo ma, nyarany c̱iŋkinam pini di’d e mom’bi’th pini mo. Miiyi to ka yim me’d jin o /e bwa mo ma. Yan’ko’d Saray ki us mii is mo ki gwony ’cwar goma yim mo dhala ayim ki gus ya ŋwac̱a/ mo ’peni a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Dhala man’doyu gwo gi Tap̱a gamki’da yim e yi’de/ jin kasha e mo e mombwaasho mo. A’di ta yi’de/ jin kasha e jin di’d e bway gi Pan Shur mo. ");
INSERT INTO udu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Dhali a’di ki o gwo mo ki: Haagar nyarany c̱iŋkina/ ma Saray, /e p̱u’dkin mo ’peni mana mo dhali /e yani ya mana mo? Ayim oki gwo mo ki: Aha/ guskina ka ŋwac̱a/ mo ’pena ’bom jin karu mmohil aha/ jin tana nyarany c̱iŋkina/ mo, ayim jin yuḵu gway ka Saray mo. ");
INSERT INTO udu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Aman’doyu gwo gi Tap̱a ki owa yim gwo mo ki: Doḵu/ mo eya ’bom pini jin karu mmohil nyarany c̱iŋkina/ mo dhali ’dap̱i ’twa/a ’cesh eya yim mo. ");
INSERT INTO udu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aman’doyu gwo gi Tap̱a ki owa yim gwo mo si’da/ ki: Aha/ mina mar emen pini kun mini pi ’peni /e mo is kagahara mo wakansan ki uni minu mol deŋ e gom uni mini ta adhana buhany wathimpa caaca kan mo. ");
INSERT INTO udu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Dhala man’doyu gwo gi Tap̱a ki owa yim gwo mo ki: Hili mo mo ma, /e bwaakin mo dhali /e mini dho’th ya/ mo. /E mini yer a’di gway ka Isma/iil mo haali/ Tap̱a c̱iki’da hirdhe/ gom monṯo’c bwam pini mo. ");
INSERT INTO udu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","A’di midi ta wathiŋ gwaṯẖ me’d thuluny bwaasho mo, dhali me’d piti midi di ap̱o/ aris ’kwani ’baar mo dhali me’d ga ris ’kwani ’baar si’da/ mini ’ko ap̱o/ a’di mo dhali a’di midi c̱a’b ap̱o/ aris uni ma bas piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Dhala yim yerki gway gi Tap̱a jin ṯorki a’di gwo mo ki: /E tana Arumgimis jin mishi mo mo, haali/ ayim ki o gwo mo ki: A/aha/ ka jiŋ gana/ mishkina Arumgimis mo dhali aha/ dina ki e mo naskina/ ’ko’di aha/ mishkina a’di mo ’taa? ");
INSERT INTO udu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Haali/ a’di wakan mo tani jis yi’de/ yan yuḵkunu gway ka Birlahayru/i mo. A’di di’di bwaman ma Kaadish dhala Baara’d mo. ");
INSERT INTO udu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Dhala Haagar dho’thki ya/ gom Abraam mo dhala Abraam ki yer gway gi ya/m piti jin dho’thkin ma Haagar mo ka Isma/iil mo. ");
INSERT INTO udu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Dhala Abraam ’kokini yili iss ’kwanimpa idoŋon i’ce’dka pe’de/ mo me’dyin Haagar ki dho’th Isma/iil eya Abraam mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Dhali ka Abraam ’koni yili iss ’kwanimpa imudhe’d aṯẖka ’de/ mo tani Tap̱a piki Abraam i is mo dhali oki a’di gwo mo ki: Aha/ tana Tap̱a Arumgimis jin Eḵa/ e ki Eḵ mo. Yayi ki sho’k ibwambori aha/ mo ma dhali tayi ki dar gi mii i’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Dhali gwom pem miga/ gam me’d nyaḵki /e mo ibwaman aha/ mo dhali /e mo dhali aha/ mina mar /e amar is kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yan’ko’d Abraam biṯki bwam/em piti a’cesh mo dhali Arumgimis oki a’di gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Hili mo mo ma, gwom pem jin gamka/ me’d mo a’di di’d e /e mo dhali /e mini ta ababa goma waambuhany kal gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Gway pini minu doḵ/e yuḵ ka Abraam mo yisa, hili gway pini minu yuḵ ka Ibrahiim mo, haali/ aha/ karkina /e mo mmota ababa goma waambuhany kal gi ’kwaniny’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aha/ mina kar /e jin mina /e dho’th maman mmoḵala dho’th ka enthus mo dhali ’peni /e mo tani miga/ dhu kal gi ’kwaniny’cesh mo dhali imaliḵ mini p̱u’du/ mo ’peni /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Dhali gwom pem jin gamka/ me’d mo a’di imiga/ ṯel sho’k mo ibwaman aha/ mo dhali /e mo dhali emen pini kun mini pi ’peni /e mo ’ko’di /e mo eya ris nyaḵum yil gi ’kwanim buni mo, mmota gwo jin gamu me’d mo jin di’d ki sule/ sule/ mo be, mmota Arumgimis gom /e mo dhali gom emen pini kun mini pi ’peni /e mo ’ko’di /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dhali e /e mo dhali e emen pini kun mini pi ’peni /e mo ’ko’di /e mo tani aha/ mina c̱i um mony’cesh gi mo/ii ki iiŋ ’kus bum mo dhali aris mony’cesh gi Paŋ Kanaan mo mmota mom bum jin mina um ibu’th ki sule/ sule/ mo dhali aha/ mina ta Arumgimis buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dhali Arumgimis oki’da Ibrahiim gwo mo ki: Dhali gom /e mo tani /e mini mii dhu gwom pem jin gamu me’d mo, /e dhali emen pini kun mini pi ’peni /e mo ’ko’di /e mo eya ris nyaḵum yil gi ’kwanim buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","A’di ta gwom pem jin gamu me’d mo jin mina /e imii dhu mo ibwaman aha/ mo dhali /e mo dhali emen pini kun mini pi mo ’peni /e mo ’ko’di /e mo. Aris gwasan kun ’koni bwaman um mo tani uni minu mii i’ciṯẖa/ munyjal yis buni mo. ");
INSERT INTO udu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Um minu mii i’ciṯẖa/ munyjal yis bum mo e shuman is ma yi’c ma munyjal yis jin ’kuc̱kunu is mo, dhali a’di midi ta jamas mii gi gwo jin gamka/ me’d mo ibwaman aha/ mo dhali /e mo. ");
INSERT INTO udu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Dhali a’diyin jin di’di bwaman um mo jin ta’d ga cim pekwara mo tani a’di iminu mii ’ciṯẖa/ munyjal yis piti mo, aris gwasani ’baar ka ’deṯe/ ’deṯe/ mo eya ris nyaḵum yil gi ’kwanim bum mo waḵki/ a’di dho’thkunu mo e gu’b pini mo walla a’di yolkunu mo ka guurush pini mo ’peni ’kwanin tiya kun ’koki ta ji gi emen pini mo. ");
INSERT INTO udu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","A’di jin dho’thkunu mo e gu’b pini mo dhali a’di jin yolkunu mo ka guurush pini mo tani a’di iminu mii i’ciṯẖa/ munyjal yis mo be. Wakan gwom pem jin gamka/ me’d mo tani a’di midi di e shuman is pini mo gwo jin gamu me’d mo jin midi di ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Jan ṯal ’deŋ kamu/ ’peni gwasan kun ’konuki ’ciṯẖa/ munyjal yis mo jin diki ’ciṯẖa/ munyjal yis piti mo e shuman is ma yi’c ma munyjal yis jin ’kuc̱kunu is mo tani a’di iminu mii ’ciṯẖ ’twa/ mo ’peni ’kwanim piti mo be. A’di ’ce’dki gwom pem jin gamka/ me’d mo. ");
INSERT INTO udu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dhali Arumgimis oki’da Ibrahiim gwo mo ki: Dhali goma Saray jin ta ashim pini mo tani /e mini yuḵ a’di ki gway ma yim ka Saray yisa. Hili gway ma yim minu mii iyuḵ ka Saarah mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Aha/ mina ’bora yim mii mo dhali bahili aha/ mina c̱i /e ya/m ka yim mo. Aha/ mina ’bora yim mii mo dhala yim midi ta kum gi kal gi ’kwaniny’cesh mo, dhali imaliḵ gi ’kwaniny’cesh mini p̱u’du/ mo ’pena yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yan’ko’d a/Ibrahiim biṯki bwam/em piti a’cesh mo dhali a’di ki p̱e’th mo dhali o gwo ki is piti mo ki: A/dhali ya/ minu dho’th e wathiŋ gwaṯẖ jin ’koni yili iss ’kwanimpa imudhe’d mowa? A/dhali Saarah si da/ jin ’koni yil iss ’kwanimpa idoŋon i’ce’dka ’kume’d mo ayim midi dhodha ’ciya? ");
INSERT INTO udu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dhala Ibrahiim oki’da Arumgimis gwo mo ki: Ayy, dhalka Isma/iil c̱a’b ki e mo e jis/em pini mo. ");
INSERT INTO udu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dhali Arumgimis oki gwo mo ki: Yisa. Hili Saarah jin ta ashim pini mo midi dho’th /e ya/in mo dhali gway piti mina /e iyuḵ ka Is/hak mo. Gwom pem jin gamka/ me’d mo tani miga/ ṯel sho’k mo nyaḵki a’di mo mmota gwo jin gamu me’d mo jin di’d ki sule/ sule/ mo gom emen piti kun mini pi ’peni a’di mo ’ko’di a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Dhali goma Isma/iil mo tani /e ciḵga/ mo. Hili mo mo ma, aha/ mina ’bor a’di mii mo dhali kar a’di mmodho’th maman mo dhali mar a’di amar is mo kagahara mo. A’di midi ta ababa gom uni kun ’koni ’kume’d i’ce’dka su/ mo kun ta iya/ ma maliḵ mo dhali aha/ mina kar a’di mmota kal jin caaca mo. ");
INSERT INTO udu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hili gwom pem jin gamka/ me’d mo tani miga/ ṯel sho’k mo nyaḵka Is/hak mo jin min ma Saarah dho’th /e mo ka yir yan ka yil jiŋ ’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ki a’di thimki’da ṯor jin ṯorkina a’di nyaḵki a’di mo tani Arumgimis yaki’d ki mis mo ’pena Ibrahiim mo. ");
INSERT INTO udu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Yan’ko’d a/Ibrahiim bu’thki’da Isma/iil jin ta ya/m piti mo dhali aris c̱iŋkina/ kun yolu mo, uni kun dho’thkunu mo e gu’b piti mo walla uni kun yolkunu mo ka guurush piti mo, aris gwasani ’baar ka ’deṯe/ ’deṯe/ mo kun ’koni bwaman ’kwaniŋ gwas gi gu’b ma Ibrahiim mo, dhali a’di ki ’ciṯẖ uni amunyjal yis mo e shuman is ma yi’c ma munyjal yis buni kun ’kuc̱kunu is mo ka tee yin gana/ mo, me’d jin okin ma Arumgimis a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Dhala Ibrahiim ’kona yili iss ’kwanimpa imudhe’d i/aṯẖ ’de/ mo me’dyin a’di ’ciṯẖkunuwa munyjal yis mo e shuman is ma yi’c ma munyjal yis piti jin ’kuc̱kunu is mo. ");
INSERT INTO udu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Dhala Isma/iil jin ta ya/m piti mo tani a’di ’kona yili ’kume’d i’ce’dka kwara mo me’dyin a’di ’ciṯẖkunuwa munyjal yis mo e shuman is ma yi’c ma munyjal yis piti jin ’kuc̱kunu is mo. ");
INSERT INTO udu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ka tee yin gana/ mo tani Ibrahiim dhali ya/m piti ka Isma/iil mo uni i’ciṯẖkunuwa munyjal yis mo. ");
INSERT INTO udu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Dhali aris ’kwaniŋ gwas gi gu’b piti mo, uni kun dho’thkunu mo e gu’b mo dhali uni kun yolkunu mo ka guurush ’peni wathiŋ kamu/ mo tani uni i’ciṯẖkunuwa munyjal yis nyaḵki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Dhali Tap̱a piki a’di i is mo e ’ko’d gwar gi dhan cwa kun wana e ka ’kwaṯṯan ma Mamra mo me’d jin c̱a’bkina a’di eya campur gi gu’b burrinyem piti mo e mo jin ta mom’batha’d jin ’koshki to montee mo. ");
INSERT INTO udu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Dhali a’di ’de’kki em piti ki mis mo dhali hilki mo mo, dhali hili mo mo ma, ’kwaniŋ gwasi kwara doshkin mo ibwambori a’di mo. Dhali ki a’di p̱arki uni e mo tani a’di guski’d ’pena campur gi gu’b burrinye/ mmoraḵ uni ibway mo dhali a’di kumki is piti ’twa/a ’cesh mo ");
INSERT INTO udu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","dhali oki gwo mo ki: Tap̱am pema, waḵki/ aha/ gamkina ’the e jis/em pini mo tani dhalku/ ki ya c̱iŋkinam pini pe mo. ");
INSERT INTO udu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Dhalki ari yi’de/ ha’bkunu mo mo ma dhali lami sho’k bum mo ma dhali siyi is bum mo eya lany cwa mo ");
INSERT INTO udu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ki aha/ ki ya guwa gabul maaŋḵuthu’d mo ki um mini ye is bum ’ba/ mo dhali ŋ’ko’d mo tani um mini mish iim pe mo – haali/ um p̱u’dkin mo e c̱iŋkinam bum mo. Wakan uni oki gwo mo ki: Miiyi me’d jin okina /e mo mo ma. ");
INSERT INTO udu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Dhala Ibrahiim miiki is ki ’kasa/ ’kasa/ mo mmop̱u’d e gu’b burrinye/ eya Saarah mo dhali oki gwo mo ki: Thosoni to ki jahanne/ mo ma, to jin ta’da dip̱any jin ’tiya’ti jin baru ka uc̱aŋi kwara mo. Na’th a’di mo ma dhali miiya guraasa mo ma. ");
INSERT INTO udu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Dhala Ibrahiim guski’d mo eya ma’diny bip̱ mo dhali a’di ki bu’th ari bip̱ jin ’ta’dama’ta’dam mo dhali jin ’bora’bor mo dhali c̱i a’di ki c̱iŋkina/ mo a’di jin miiki is ki ’kasa/ ’kasa/ mo mmothoson a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yan’ko’d a’di ki guwa konṯaŋka/ mo dhala ko mo dhali ari bip̱ jin thosonkina a’di mo dhali dhuki uni ibwambori uni mo. Dhali a’di doshki’d ki ’dishe/ i uni mo e bwaŋ’kwariny gi cwa mo ki uni shwaki to mo. ");
INSERT INTO udu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Uni oki a’di gwo mo ki: Mane Saarah jin ta ashim pini mo mane? Dhali a’di oki gwo mo ki: A’di di’di gu’b burrinye/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Dhali a’di oki gwo mo ki: Ka jiŋ gana aha/ mina mii doḵu/ e /e mo ki yil midi ta jin this mo, dhala Saarah jin ta ashim pini midi dho’th ya/ mo be. Dhala Saarah di’d mmociḵ gwo mo eya campur gi gu’b burrinye/ jin di’di bwamp̱o/ a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Hili Ibrahiim dhala Saarah uni itakina dhan mo dhali cakin ki yil mo dhali goma Saarah mo tani mo jin baṯẖu mii gi up̱ daḵki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Haali/ a’di wakan mo tani Saarah p̱e’thki’d ki is piti mo mmo/o gwo mo ki: ’Ko’di aha/ takina dhan mo dhala kaṯẖim pem si’da/ ta’da dhan mo tani miga/ ta gi ’ceŋ kamu/ jin midi ’kol aha/ mowa? ");
INSERT INTO udu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Dhala Tap̱a oki’da Ibrahiim gwo mo ki: Ata p̱e’thkin ma Saarah kan mo dhali ata on ma yim gwo mo ki: Ka jiŋ gana/ aha/ mina dhodha ’ciya ki aha/ shwane/ cakina yil mo? ");
INSERT INTO udu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ton ṯal deŋ kamu/ di’da jin mola Tap̱a mii mo ’taa? Ka tenteŋ ḵar/e mo tani miga/ doḵu/ e /e mo e mo jin tana yil this mo dhala Saarah midi dho’th ya/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Hili Saarah waṯki gwo mo mmo/o gwo mo ki: Aha/ dinaki p̱e’th mo, haali/ ayim ḵo/ki is mo. Dhali a’di oki gwo mo ki: Yisa wakana, hili /e p̱e’thkin mo ka jiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Yan’ko’d ’kwaniŋ gwas gwansan ’kakin ka ji sho’k ’peni maṯṯan mo, dhali uni hilkin mo ’kup̱ ki Pan Saduum mo. Dhala Ibrahiim suski uni ’pen mbway buni mo. ");
INSERT INTO udu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Dhali Tap̱a oki gwo mo ki: A/dhali a’di jin murka/ mii mo tani miga/ bag ’pena Ibrahiim mo ’taa? ");
INSERT INTO udu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Haali/ Ibrahiim midi war mo ki kal gi ’kwaniny’cesh jin caaca mo dhali jin eḵa/ eḵ mo dhali e a’di mo tani aris kal gi ’kwaniny’ceshi ’baar mo minu ’bor mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Yisa, haali/ a’di kwanykika/ mo ki a’di midi ḵan uc̱im piti gwo mo dhali uni gi gu’b piti kun mini ’ko mo ŋ’ko’di a’di mo ki uni mini dhu bway gi Tap̱a mo mmo’ko mmomii mii ma ḵar/e mo dhali mii kun miinu ki dar gi mii ma gwar ’de/ mo. Ki a’di wakan mo tani a’di mina Tap̱a ’taki gu eya Ibrahiim mo a’di jin okina Tap̱a gwo is mo. ");
INSERT INTO udu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yan’ko’d Tap̱a oki gwo mo ki: Haali/ cuuwa/ jin ’theru ap̱o/ Pan Saduum mo dhali Paŋ Gamuura mo maru is mo dhali miinthus buni caaca kagahara mo tani ");
INSERT INTO udu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","aha/ mina ya ka ’cesh mo mmop̱ar e mo waḵki/ uni miiki mii mo isi gi cuuwa/ jin ’theru e aha/ ki ’bil kan mo, dhali waḵki/ a’di yisa wakan mo tani aha/ mina mish mo mo. ");
INSERT INTO udu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Wakan mo tani ’kwaniŋ gwas gwansan ṯu’kkin mo ’peni maṯṯaan mo dhali iikin mo ’kup̱ ki Pan Saduum mo. Hili Ibrahiim doshki’d mo naskina/ ibwambori Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Yan’ko’d Ibrahiim ’dishki is mo dhali o gwo mo ki: Ka jiŋ gana/ /e mini ’ce’d uni sho’k mowa uni gun mii miiŋḵar/e mo nyaḵki uni gun mii tonthus mowa? ");
INSERT INTO udu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Waḵki/ uni gun mii miiŋḵar/e mo mini ’taki ’ko iss ’kwanimpa su/ i’ce’dka ’kume’d mo ibwaman ’peŋkuman bampa/ mo tani wakan mina /e ’taki ’ce’d mo sho’k mo dhali diki ’taki ’tash a’di ’twa/ mo gom uni gun mii miiŋḵar/e mo kun ’koni iss ’kwanimpa su/ i’ce’dka ’kume’d mo ibwaman a’di mo ’taa? ");
INSERT INTO udu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Dhalka mii gi wakan midi mii diki thoṯẖ /e is mo ma mmo’kosh uni gun mii miiŋḵar/e mo nyaḵki uni gun mii tonthus mo, wakan ki uni gun mii miiŋḵar/e mina e wa gi uni gun mii tonthus mo. Dhalka mii yan midi mii diki thoṯẖ /e is mo ma. A/min ma Mandwall aris mony’cesh gwo mo diki mii miim ’boro’da? ");
INSERT INTO udu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Dhali Tap̱a oki gwo mo ki: Waḵki/ aha/ mina ’taki gam e Pan Saduum mo uni gun mii miiŋḵar/e mo kun ’koni iss ’kwanimpa su/ i’ce’dka ’kume’d mo ibwaman ’peŋkuman bampa/ mo tani aha/ mina ’tash aris mo yani ’baar mo ’twa/ mo gom gway buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Dhala Ibrahiim thoḵki ’twa/ mo ki: Hili mo mo ma, aha/ bu’thkina a’di ap̱o/ is pem mo mmoṯor gwo e Tap̱a mo, aha/ be jin ta jasi bu’da’cesh mo dhali ’piny mo. ");
INSERT INTO udu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Waḵki/ uni imudhe’d ’peni uni kun ’koni iss ’kwanimpa isu/ i’ce’dka ’kume’d mo kun mii miiŋḵar/e mo tani mini ’taki aṯẖ mo, a/mina /e ’ce’d ’peŋkuman bampa/ sho’k mo ka ’bimbil mo mmo/aṯẖa ’kwani imudhe’d mowa? Dhali a’di oki gwo mo ki: Aha/ mina diki ’ce’d a’di sho’k mo waḵki/ aha/ mina ’taki gam uni kun ’koni iss ’kwanimpa su/ i’ce’dka mudhe’d mo mmun mo be. ");
INSERT INTO udu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Dhali doḵ/e a’di ki ṯor a’di gwo mo dhali o gwo mo ki: Waḵki/ uni ’koni iss ’kwanimpa isu/ kun minu ’taki gam mmun mowa? Dhali a’di thoḵki gwo mo ki: Gom gway gi uni kun ’koni iss ’kwanimpa isu/ mo tani aha/ mina diki mii a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Yan’ko’d a’di oki gwo mo ki: Ayy Tap̱a dhalku/ anyor ki shwa mo ma, dhali aha/ mina ṯor gwo mo. Waḵki/ uni ’koni iss ’kwanimpa ’de/ i’ce’dka ’kume’d mo kun minu ’taki gam mmun mowa? Dhali a’di thoḵki gwo mo ki: Aha/ mina diki mii a’di mo tani waḵki/ aha/ mina ’taki gam uni kun ’koni iss ’kwanimpa ’de/ i’ce’dka ’kume’d mmun mo. ");
INSERT INTO udu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","A’di oki gwo mo ki: Hili mo mo ma, aha/ bu’thkina a’di ap̱o/ is pem mo mmoṯor gwo e Tap̱a mo. Waḵki/ uni ’koni iss ’kwanimpa ’de/ mo kun minu ’taki gam mmun mowa? Dhali a’di thoḵki gwo mo ki: Gom gway gi uni kun ’koni iss ’kwanimpa ’de/ mo tani aha/ mina diki ’ce’d a’di sho’k mo. ");
INSERT INTO udu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Yan’ko’d a’di oki gwo mo ki: Ayy Tap̱a dhalku/ anyor ki shwa mo ma, dhali aha/ mina gwo ṯor doḵ/e mo jasi me’d ’deŋ gana/ mo. Waḵki/ uni ’koni ’kume’d mo kun minu ’taki gam mmun mowa? Dhali a’di thoḵki gwo mo ki: Gom gway gi uni kun ’koni ’kume’d mo tani aha/ mina diki ’ce’d a’di sho’k mo. ");
INSERT INTO udu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Dhali Tap̱a yaki bway piti mo me’d jin thimkina a’di gwo ṯor ka Ibrahiim mo. Dhala Ibrahiim doḵki’d ka nyaŋ’ko’d mo e mom piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Iman’doyu gwo su/ gwansan p̱u’dkin mo e Pan Saduum mo e mom’pimpili/ mo. Dhala Luuth diki’d mo mmoc̱a’b ’pena ’cesh e ’twaŋkal gi Pan Saduum mo. Ki Luuth p̱arki uni e mo tani a’di cuki mis mo mmogam uni ’kup̱ mo dhali a’di kumki is piti mo ki bwam/em piti eya ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Dhali a’di oki gwo mo ki: Itap̱am pema, aha/ doṯkina um mo. Ṯuki mo ma ’peni bway bum mo e gu’b gi c̱iŋkinam bum mo dhali ’baari mon’thiny mo dhali lami sho’k bum mo. Yan’ko’d um mini mish cu mis mo ki jahanne/ mon’thamo/ mo dhali ii ki bway bum mo. Uni oki gwo mo ki: Yisa. Am mina i’baar mon’thiny mo e bway tur mo. ");
INSERT INTO udu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Hili a’di ṯirrishki uni ki gwom ’bi’thga/ mo. Wakan uni ṯu’kki mo ’peni bway buni e a’di mo dhali cic̱ki gu’b piti mo. Dhali a’di miiki uni dhan mo jin shwanu to mo dhali shunki maaŋḵuthu’d jin miinu ki dar ka cumaṯ mo dhali uni ishwakin mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hili ki uni ’koki ish ’ko’da ’cesh naskina/ mo tani ’kwaniŋ gwas gi ’peŋkuman bampa/ yan mo, ’kwaniŋ gwas gi Pan Saduum mo, uni kun ta dhuru’c mo dhali uni kun tana dhani lu/ mo, aris ’kwani ’baar mo ntagi wathiŋ gwaṯẖ jiŋ ’ko’d mo tani uni ’kamki gu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Dhali uni yuḵki ’twa/ eya Luuth mo ki: Mane ’kwaniŋ gwas kun p̱u’dkin e /e mon’thiny yan mo mane? Susi uni ka pije/ e aman mo ma ki aman mina mish uni mo. ");
INSERT INTO udu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Dhala Luuth yaki’d ka pije/ ki campur mo e ’kwaniŋ gwas mo dhali mu’thki campur i’ko’di a’di mo, ");
INSERT INTO udu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","dhali oki gwo mo ki: Aha/ doṯkina um mo ikam pema, dhalku/ tonthus ki mii wakan mo ma. ");
INSERT INTO udu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Hili mo mo ma, aha/ takina gi i’bwa/i su/ mo kun ’koki mish wathiŋ kamu/ mo. Dhalki aha/ bway mo mmosus uni ka pije/ e um mo dhali miiyi um e uni mo me’d jin o um bwa mo. Hili dhalku/ toŋ kamu/ ki mii e ’kwaniŋ gwas gwansan mo ma haali/ uni p̱u’dkin mo ibwaŋ’kwariny ma darha’da/ ma galgin gu’b pem mo. ");
INSERT INTO udu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Hili uni oki gwo mo ki: Doshi ka c̱iŋ’ko’d mo ma. Dhali uni oki gwo mo ki: Cim yan p̱u’dki’d mo mmoc̱a’b yilkina/ mo dhali a’di midi ’taki lo’b mo jin tanuwa mandwall gwo moyi. Shwane/ aman mina ṯu/ul /e mo ki mii kun warkin ki shi/ kagahara mo mmobol kun minu mii gom uni e mo. Yan’ko’d uni yap̱ki ap̱o/ wathiŋ gwaṯẖ jin yuḵu ka Luuth ki is kagahara mo dhali ’dishki is mo mmo’ce’da campur mo. ");
INSERT INTO udu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Hili ’kwaniŋ gwas dhuki me’d buni mo dhali susa Luuth bway bwaŋ gu’b e uni mo, dhali mu’thki’da campur mo. ");
INSERT INTO udu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","’Kwaniŋ gwas kun ’kokin mo eya campur gu’b mo tani dha’bkina uni em buni ki ja’da/ mo, uni kun gwa’da is mo dhali kun caaca mo, wakan ki uni wukina is buni e mo mmotopuwa campur mo. ");
INSERT INTO udu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Yan’ko’d ’kwaniŋ gwas okina Luuth gwo mo ki: Ṯal ’deŋ kamu/ takina /e imahana? Iya/ kun ta imar mo ’taa? Iya/ mo ’taa? I’bwa/ mo ’taa? Walla ma a’diŋ kamu/ jin takina /e mo e ’peŋkuman bampa/ yan mo tani susi uni ka pije/ mo ’peni mo yan mo ");
INSERT INTO udu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","haali/ am mura ’ce’d mo yan sho’k mo haali/ cuuwa/ jin ’theru ap̱o/ ’kwanim piti mo tani a’di warki’d mmomaru is mo ibwambori Tap̱a mo dhali aman hashkina Tap̱a mo mmo’ce’d a’di sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Dhali wakan mo tani Luuth yaki’d ka pije/ mo dhali oki iya/ kun ta imar mo uni kun mini ’taki mash i’bwa/ piti gwo mo ki: Cuyi mis mo ma. Iiku/ ka pije/ mo ’peni mo yan mo, haali/ Tap̱a muru’di ’ce’d ’peŋkuman bampa/ yan sho’k mo. Hili a’di wakina e ga man/o gwo ki maḵ mo e iya/ kun ta imar piti mo. ");
INSERT INTO udu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ki e ma tente/ kasha’d mo tani aLuuth miikina iman’doyu gwo is ki ’kasa/ ’kasa/ mo mmo/o gwo mo ki: Cuyi mis mo mo ma mmosus ashim pini dhali i’bwa/m pini isu/ mo, uni kun ’koyin mmahan mo, isi ciki/ ki /e minu diki ’ce’d sho’k mo e mo jin doruwa dor mo gi ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Dhali ki a’di di’d mmoc̱ora/ c̱or naskina/ mo tani ’kwaniŋ gwas gwansan bu’thki a’di i is ap̱o/ me’d piti mo dhali ap̱o/ me’d gi ashim piti mo dhali ap̱o/ me’d gi i’bwa/m piti isu/ ilu/ mo. Tap̱a si’da/ a’di di’d mmomiimii ap̱o/ a’di mo. Dhali uni isuski a’di ka pije/ mo dhali karki a’di ka pije/ mo ’peni ’peŋkuman bampa/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Dhali ki uni suskina uni ka pije/ mo tani uni ki o gwo mo ki: Yeyi /e mo ma gom mondiki/em pini mo. Dhalku/ /e ki hil ka c̱iŋ’ko’d ŋ’ko’di /e mo ma walla dhalku/ /e ki c̱a’b e mo isi ’baar mo jin ta’da mom’ba’da’d mo. Yeyi /e mo ma ’kup̱ ki wosh mo isi ciki/ ki /e minu diki kup̱ ki ’ci’d’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Dhala Luuth oki uni gwo mo ki: Ayy tap̱am pema, dhalku/ a’di ki di wakan mo ma. ");
INSERT INTO udu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Hili mo mo ma, shwane/ c̱iŋkinam pini gamki’da ’the e jis/em pini mo, dhali momiimiim pini eḵkina /e mo, a’di jin ṯorkina /e i aha/ mo e mo jin woṯẖuwa woṯẖ gom mondiki/em pem mo. Dhali mmoye mo e ’kup̱ ki wosh mo molga/ mii mo isi ciki/ ki tonthus yan midi ’taki ḵal aha/ ka ’cesh mo dhali aha/ mina ’taki wu mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hili mo mo ma, shwane/ ’peŋkuman bampa/ yaase a’di ’disha’dish mo mmoye nycine/ mo, dhali a’di si’da/ gwa’dagwa’d mo. Ayy, dhalki aha/ mmoye mo imun mo ma – a’di diki ta ari gwa’dga/ mo ’taa? – Dhali mondiki/em pem minu woṯẖ mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Dhali a’di oki a’di gwo mo ki: Hili mo mo ma aha/ mina mii mii ma ’the si’da/ mmomiga/ diki kum ’peŋkuman bampa/ yaase ’twa/a ’cesh mo, a’di jin doṯkina /e mo. ");
INSERT INTO udu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Layu/ /e ki jahanne/ mo ma mmoye imun mo haali/ aha/ mola toŋ kamu/ mii mo ntagi /e mini p̱u’du/ mo e mun mo. Haali/ a’di gi wakan mo tani a’di iyuḵkunu ’peŋkuman bampa/ yan gway ka Suugar mo. ");
INSERT INTO udu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Atente/ sulki’d mo hila/ ap̱o/ mony’cesh mo me’d jin cic̱kin ma Luuth e Pan Suugar mo. ");
INSERT INTO udu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Dhali yan’ko’d mo tani Tap̱a a’di he’thki’da p̱o/ Pan Saduum mo dhali ap̱o/ Paŋ Gamuura mo to jin si’du/ mo dhala kap̱any o’d ’peni Tap̱a mo ’peni bwaman momis mo. ");
INSERT INTO udu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Dhali a’di kumki ’peŋkuman bampa/ gwansan ’twa/a ’cesh mo dhala ris mom’ba’da’d si’da/ mo dhali aris uni gun ’kokin mo e ’peŋkuman bampa/ gwansan mo dhali to jin caki’d mo ap̱o/ mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Hili ashim piti jin diki’di ’ko’d mo ibwamp̱o/ a’di mo tani a’di hilki mo ka c̱iŋ’ko’d mo dhali a’di warki’d mo ki wosh ’doŋkoro/ mo. ");
INSERT INTO udu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Dhala Ibrahiim la cuki mis mo mon’thamo/ mo e mo jin doshkina a’diya dosh mo ibwambori Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Dhali a’di hilki’da ’cesh mo ’kup̱ ki Pan Saduum mo dhali Paŋ Gamuura mo dhali ’kup̱ ki aris bampa/ jin ta mom’ba’da’d mo dhali a’di hilki mo mo. Dhali hili mo mo ma, aku’d ’peni bampa/ cuki mis mo me’da ku’d ’peni mo jin ’thanu o’d ki wur wur mo. ");
INSERT INTO udu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Dhali a’di warki’d mo ka Arumgimis ’ce’dki ’peŋkuman bampa/ kun ’koni bwaman mom’ba’da’d sho’k mo tani Arumgimis kaki’da Ibrahiim e mo dhali karki’da Luuth ki ya mo ’peni bwaman mo jin kumkunu ’twa/a ’cesh mo me’d jin kumkina a’di ’peŋkuman bampa/ gwansan ’twa/a ’cesh mo uni kun c̱a’bkin ma Luuth nycine/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Dhala Luuth yaki’di ya ki mis ka pije/ mo ’peni Pan Suugar mo dhali c̱a’bki’d mo e ’kuwosha turga/ mo dhali i’bwa/m piti isu/ nyaḵki a’di mo. Haali/ a’di ḵo/ki’da ḵo/ is mo mmo’ko e Pan Suugar mo. Dhali a’di c̱a’bki’d mo ibwamana jurum wosh mo dhali i’bwa/m piti isu/ nyaḵki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Dhali a’di jin ta bwanyara/ ki o a’di jin ta jiŋ ’ko’d gwo mo ki: Ababam bana ta’da dhan mo dhali wathiŋ gwaṯẖa kamu/ yisa di’da e mony’cesh mo mmoyayu/ bway bwaman ana mo me’d mii jin baṯẖu imii mo isi mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yayu/ /e mo dhali dhalki ana ṯuca babam bana mo mmop̱iya yimana mura’th jin ḵa/u ki ŋah ŋah mo, dhali ana mina nyaḵ ish ki a’di mo ki ana mina ’taki dhuwa dhu mo gom emen ma babam bana mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Dhali uni ṯu’ckina babam buni mo mmop̱i yimana mura’th jin ḵa/u ki ŋah ŋah mo ki mon’thiny yin gana/ mo. Dhali a’di jin ta bwanyara/ yaki’d mo dhali nyaḵ ish ki com piti mo. Dhala Luuth a’di diki mish mo mo, atente/ jin ishkina a’diya yim ’ko’da ’cesh mo walla atente/ jin cukina a’di ki mis mo. ");
INSERT INTO udu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Dhali a’di waki’d mo ka cim jiŋ ’ko’d mo tani a’di jin ta bwanyara/ ki o a’di jin ta jiŋ ’ko’d mo ki: Hili mo mo ma katili/ ki mon’thiny mo tani aha/ nyaḵkina ish ka babam pem mo. Dhalki ana ki ṯu’c a’di mo mmop̱i yimana mura’th jin ḵa/u ki ŋah ŋah ki mon’thiny shwane/ si’da/ mo. Dhali yayi /e mo dhali ish nyaḵki a’di mo ki ana mina ’taki dhuwa dhu mo gom emen ma babam bana mo. ");
INSERT INTO udu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Dhali uni ṯu’ckina babam buni mo mmop̱i yimana mura’th jin ḵa/u ki ŋah ŋah mo ki mon’thiny doḵ/e mo. Dhali a’di jin ta jiŋ ’ko’d cuki mis mo dhali ishki nyaḵki a’di mo. Dhali doḵ/e aLuuth diki mish mo mo, atente/ jin ishkin ma yim ’ko’da ’cesh mo walla atente/ jin cukin ma yim ki mis mo. ");
INSERT INTO udu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Wakan be uni su/ kun ta i’bwa/ ma Luuth mo uni ’kokin mo ki uc̱i ibwa mo ki com buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Dhali ayim jin ta bwanyara/ dho’thki ya/ mo dhali a’di yerkunu gway mo ka Muwab mo. A’di yaase ita com gom ’Kwani gi Pa Muwab mo ntagi shwanesan mo be. ");
INSERT INTO udu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Dhali ayim jin ta jiŋ ’ko’d mo a’di si’da/ idho’thki ya/ mo dhali gway piti yerkunu mo ka Ben/ammi mo. A’di yaase ita com gom uc̱i ma Ammuun mo ntagi shwanesan mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Dhali ’peni maṯṯaan mo tani Ibrahiim yaki’di yam pe mo ’kup̱ ki bampa/ jin di’d e ’ko’d gwar ga biny jam mo dhali a’di c̱a’bki’d mo ibwaman gi Paŋ Kaadish mo dhali gi Pan Shur mo dhali a’di p̱u’dki’d ki yaŋ’kus e Pan Jaraar mo. ");
INSERT INTO udu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Dhala Ibrahiim oki gwo mo goma Saarah jin ta ashim piti mo ki: Ayim ita ’bwah pem mo. Dhala Abimaalik jin ta maliḵ gi Pan Jaraar mo karki’da kar ’pen mo dhali bu’thki’da Saarah mo. ");
INSERT INTO udu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Hili Arumgimis p̱u’dki’d eya Abimaalik gi tony jan ki mon’thiny mo dhali oki a’di gwo mo ki: Hili mo mo ma, /e ta wathiŋ gwaṯẖ jin wana e gi wathi/ jin wu’d mo goma ’bom jin bu’thkina /e mo haali/ ayim ita ash gi wathiŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hili Abimaalik a’di i’dishkin ma yimi is yisa dhali a’di oki gwo mo ki: Tap̱a a/mina /e i’kosh kal gi ’kwaniny’cesh gun daran gi mii m’ba/ si’da/ moyi? ");
INSERT INTO udu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Dina a’di ki o gwo mo ki is pitiŋ gana/ ki aha/ mo ki: Ayim ita ’bwah pem mowa? Dhala yim si’da/ ayim ki is pitiŋ gana/ o gwo mo ki: A’di ita’da kam pem mo. E mo jin dika/ ki mii ki ŋadhum eya dum pem mo dhali e mo jin dika/ ka p̱o/ gi me’d pem mo tani a’di imiikika/ mii yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dhali yan’ko’d Arumgimis oki a’di gwo mo ki tony jan mo ki: Nye, a’di imishka/ mo ki mii yan a’di imiikina /e mo ki mii jin miikunu mo ki dar gi ŋadhum eya dum pini mo. Dhali a’di ita aha/ si’da/ jin nonkina /e mo ’peni mo jin miikunu miinthus ap̱o/ aha/ mo. Haali/ a’di gi wakan mo tani a’di dika/ ki dhal /e bway mo mmota ayim is ki me’d moyi. ");
INSERT INTO udu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hili shwane/ mo tani doḵki/ /e e wathiŋ gwaṯẖ ashim piti ka nyaŋ’ko’d mo ma, haali/ a’di ita aman/o gwo mo dhali a’di midi ’tho gom /e mo, dhali /e mini di ki e mo. Hili waḵki/ /e mini diki doḵa ayim ka nyaŋ’ko’d mo tani mishi /e mo mo ma ki /e mini mii wu mo ka jiŋ gana/ mo, /e dhala ris uni ’baar mo gun ta kum pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wakan be Abimaalik la cuki mis mo mon’thamo/ mo dhali a’di yuḵki imanmiiya ṯu’c piti i’baar mo dhala ris to gwansani ’baar mo iṯorkina a’di mo e ’cem buni mo. Dhali ’kwaniŋ gwas gwansan uni ḵo/kina ḵo/ is kagahara mo. ");
INSERT INTO udu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Dhali yan’ko’d Abimaalik yuḵki’da Ibrahiim mo dhali oki a’di gwo mo ki: To gi wakatinta imiikina /e mo ap̱o/ aman mo? Dhali ton shigga/ gi wakata si’da/ imiikika/ ap̱o/ /e mo mmo’doyina /e dhan miinthus caaca ap̱o/ aha/ mo dhali ap̱o/ bampam pem si’da/ mo. /E be imiiki to ap̱o/ aha/ mo kun ḵa ba/ iminu ’koki mii mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Dhala Abimaalik ki owa Ibrahiim gwo mo ki: Atinta c̱aan jin kulumkina /e ibwa mo mmomiikina /e mii yan mo? ");
INSERT INTO udu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Dhala Ibrahiim ki o gwo mo ki: A’di imiikika/ kan haali/ a’di iṯoshkika/ mo mmo/o gwo mo ki: Ka jiŋ gana/ moŋḵo/ isa kamu/ yisa di’da goma Arumgimis e mo yansan mo dhali uni mini ’kosh aha/ jwa mo gom gway gi ashim pem mo. ");
INSERT INTO udu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Dhali bahili ayim ka jiŋ gana/ ita ’bwah pem mo, a’di jin ta ’bwa/ ma babam pem mo, hili ayim diki ta ’bwa/ ma ta’dam pem mo. Dhali ayim warki’d ki ashim pem mo. ");
INSERT INTO udu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dhali ki aha/ raḵkin ma Arumgimis mo mmo/ii ki ii ma c̱a/ mo ’peni gu’b ma babam pem mo tani aha/ okina yim gwo mo ki: A’di yansan ta miim pini jin mina /e ikar bwa jin kushakush gom aha/ mo. Eya ris mo i’baar mo jin mina ana ip̱u’du/ mo tani oyi gwo gom aha/ mo ki: A’di ita’da kam pem mo. ");
INSERT INTO udu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Dhali yan’ko’d Abimaalik bu’thki ḵa’bal mo dhala morbip̱ mo dhali ’kwani kun miina ṯu’c mo dhali up̱ kun miina ṯu’c mo dhali c̱iki uni ka Ibrahiim mo dhali warki a’di aSaarah i is mo, ayim jin ta ashim piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Dhala Abimaalik ki o gwo mo ki: Hili mo mo ma, bampam pem di’di bwambori /e mo. C̱a’bi /e mo mo ma e mo jin midi ’bor /e bwa mo. ");
INSERT INTO udu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Dhali eya Saarah a’di oki gwo mo ki: Hili mo mo ma, aha/ c̱ikina akam pini gabul ’dolkon kushi alip̱ mo. A’di ita mom pini jin yenuwa ye mo e jis/e gi uni ’baar mo kun nyaḵ ’ko ki /e mo. Dhali ibwambori aris ’kwani ’baar mo tani /e minu kar ki mo ma ḵar/e mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Dhali yan’ko’d Ibrahiim ’thoki’d ka Arumgimis mo. Dhali Arumgimis ki wac̱a Abimaalik mo dhali ashim piti si’da/ wac̱kunu mo dhali aris up̱ kun miina ṯu’c mo ki uni ki dho’thki uc̱i mo be. ");
INSERT INTO udu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Haali/ aris bwa gi gu’b ma Abimaalik molona dho’th mo mmomu’thkina Tap̱a uni mo gom gway ma Saarah mo a’di jin ta ash ma Ibrahiim mo. ");
INSERT INTO udu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Dhali Tap̱a a’di yayi’d mo mmobuṯa Saarah me’d jin okina a’di mo, dhali Tap̱a a’di miiki eya Saarah mo me’d jin okina a’di gwo is mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Dhala Saarah bwaaki’d mo dhali ayim ki dhodha ’ci jin ta ya/ goma Ibrahiim mo ki yil jin cana a’di mmota dhan mo ka tee c̱aan mo a’di jin okin ma Arumgimis a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Dhala Ibrahiim yuḵki gway gi ya/m piti jin dho’thkunu gom a’di mo tani, a’di jin dho’thkin ma Saarah mo gom a’di mo tani ka Is/hak mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Dhali me’d jin ḵankin ma Arumgimis a’di mo tani Ibrahiim ’ciṯẖki’da Is/haka munyjal yis mo ki ya/m piti ka Is/hak ’kon ma cimi pekwara mo. ");
INSERT INTO udu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Dhala Ibrahiim ’kokina yil iss ’kwanimpa imudhe’d ka dhan piti mo tani me’d jin dho’thkunu ya/m piti ka Is/hak gom a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Dhala Saarah oki gwo mo ki: Arumgimis a’di c̱iki mo gi momp̱e’th gom aha/ mo. Aris ’kwani ’baar mo ka ’deṯe/ ’deṯe/ kun mini ciḵ gwo mo mini p̱e’th gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Dhali ayim ki o gwo mo ki: Kaja a’di jin midi ’taki o ka Ibrahiim gwo mo ka Saarah midi ’taki c̱i uc̱i ako mmop̱i moyi? Hili aha/ be ki dho’th a’di ya/ mo ki yil jin cana a’di mmota dhan mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Dhali a’di ca’d mo dhali a’di dhalkunuwa koŋ kum ’pen mo dhala Ibrahiim miiki’da dhan mo jin yuḵunuwa yuḵ mo ka cim jin dhalkunuwa koŋ kum ’pen mo goma Is/hak mo. ");
INSERT INTO udu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hili Saarah p̱arki ya/ ma Haagar jin ta ji gi Pam Masir e mo, a’di jin dho’thkin ma yim goma Ibrahiim mo, dhali a’di ki mii a’di ka maḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Gom gwo gi wakan mo tani ayim ki owa Ibrahiim gwo mo ki: Uri a’bom c̱iŋkina/ yan ka pije/ mo nyaḵka ’cim piti mo haali/ ya/ ma ’bom c̱iŋkina/ yan mo tani midi diki pwaḵ mal bwa nyaḵki ya/m pem mo, isi a’di jin ta’da Is/hak mo. ");
INSERT INTO udu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Dhali gwo yan jwakaṯki’da Ibrahiima du e jis/em piti mo gom gway gi ya/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Dhala Arumgimis ki owa Ibrahiim gwo mo ki: Dhalku/ gwo yan ki kar mmojwagaṯ /eya du e jis/em pini mo goma ’ci yan mo, dhali gom gwo gi ashin jin ta’da ’bom c̱iŋkina/ mo. Dhali eya ris gwo kun on ma Saarah /e mo tani ciḵi ’twa/ ma yim mo ma haala Is/hak a’di midi ta emen pini jin minu yuḵ gway i’ko’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Dhali gom ya/ ma ’bom c̱iŋkina/ si’da/ mo tani aha/ mina kar a’di mmota kal mo haali/ a’di ta emen pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Dhala Ibrahiim cu mis mo mon’thamo/ ka’tum mo dhali bu’th maaŋḵuthu’d mo dhali ḵucaŋ yi’de/ mo dhali a’di ki c̱i ka Haagar mo mmokar ki a’di e ’kup̱a bi ma yim mo dhali a’di ki c̱i ka yima ’ci mo dhali karka ayim ’pen mo dhala ayim a’di yaki’d mo dhali yaki yany c̱a/ mo e mombwaasho e Pam Birsaba mo. ");
INSERT INTO udu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Dhali yi’de/ jin di’di bwa ḵucaŋ mo tani a’di ḵu’thki’d mo dhala yim ki biṯa ’ci me’d e bwaman ma bwaabuuy mo. ");
INSERT INTO udu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Dhala yim yaki’d mo dhali a’di ki c̱a’ba ’cesh mo mmoc̱i a’di ’ko’di is mo ari is ’ko’d mo kantaan me’d mo jin shiinu aththa mo kantaan, haala ayim oki gwo mo ki: Aha/ mina mii dhalku/ ki p̱ar jwa ma ’ci e mo. Dhala ayim ki c̱a’b mmoc̱i a’di ’ko’di is mo dhali a’di ki ’de’k ’twam piti mo dhali ko mo. ");
INSERT INTO udu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dhali Arumgimis ciḵki ’twa/ ma ara ’ci mo dhala man’doyu gwo ma Arumgimis yuḵki’da Haagar mo ’peni momis mo dhali owa yim gwo mo ki: Ata mii /e mo, Haagar? Dhalku/ is ki ḵo/ mo haali/ Arumgimis ciḵki ’twa/ ma ara ’ci e mo jin dina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Cuyi mis mo dhali ’deka ’ci mo dhali susi a’di ki me’d pini mo haali/ aha/ mina kar a’di ki dhan kala caaga/ mo. ");
INSERT INTO udu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Dhali yan’ko’d Arumgimis ki ḵa’d e ma ayim mo dhala yim ki p̱ar jis yi’de/ e mo. Dhala yim yaki’d mo dhali ’tu’d ḵucaŋ ki yi’de/ mo dhali a’di ki c̱i ka ’ci mmop̱i mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dhali Arumgimis nyaḵ di ka ’ci mo dhali a’di caki’d mo dhali a’di c̱a’bki’d e mombwaasho mo dhali warki’d ki wathi/ jin yuḵayuḵ mo mmoshiina aththa mo. ");
INSERT INTO udu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Dhali a’di c̱a’bki’d e mombwaasho gi Pam P̱aaraan mo dhali kum ki ŋap̱ki a’di a’bom mo ’peni Pa Masir mo. ");
INSERT INTO udu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Dhali a’di warki’d ki mo jin peki’d mo ka tee c̱aan mo ka Abimaalik dhala P̱ikul jin ta tap̱a gi ’kwani ma mee mo oki’da Ibrahiim gwo mo ki: Arumgimis nyaḵ di e /e eya ris to kun miikina /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Dhali gom gwo gi wakan mo tani thuli /e me’da p̱o/ mmahan ki gway ma Arumgimis mo gom aha/ mo ki /e mini diki mii to shiyi’da p̱o/ aha/ mo walla ap̱o/ ya/m pem mo walla ap̱o/ iya/m pem kun mini dho’th iya/ i’ko’d mo, hili gom mii kun miiga/ ki bwaŋkush gom /e mo tani /e si’da/ mini mii a’di gom aha/ mo be, dhali e mony’cesh a’di jin mina /e ya ki yaŋ’kus mo. ");
INSERT INTO udu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Dhala Ibrahiim oki gwo mo ki: Aha/ mina thul gwo me’da p̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Dhala Ibrahiim nyo/ki’da Abimaalik ki gwo mo gom jis yi’de/ mo a’di jin bu’thkina c̱iŋkina/ ma Abimaalik ki ’bi’th mo. ");
INSERT INTO udu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Dhala Abimaalik ki o ki gwo mo ki: Aha/ yisa misha wathi/ jin thami to mii kansan mo yisa. /E si’da/ diki ṯor aha/ gwo mo. Dhali kan si’da/ aha/ si’da/ dinaki ciḵ gwoŋ kamu/, hili jasi ki ’dishe/ ishunsan mo. ");
INSERT INTO udu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Dhala Ibrahiim bu’thki ḵa’bal mo dhala morbip̱ mo dhali a’di ki c̱i ki uni ka Abimaalik mo dhali uni su/ miiki gwo jin gamu me’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Dhala Ibrahiim ki dhu ushi nas ḵa’bali pesu/ ’pen ka pije/ mo ’pena ma’diny piti mo uni ’cena mo. ");
INSERT INTO udu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Dhala Abimaalik ki owa Ibrahiim gwo mo ki: ’Pemen gwo yan ta’da ta mo mmodhuna /e ushi nas ḵa’bali pesu/ ’pen ka pije/ mo mmo’ko uni ’cena mo? ");
INSERT INTO udu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Dhali a’di ki o gwo mo ki: Ushi nas ḵa’bali pesu/ gwansan mina /e ibu’th ki me’d pini mo ki uni mini ta iman/o gwo gom aha/ mo ki aha/ c̱wanykina jis yi’de/ yansan mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Gom gwo gi wakan mo a’di iyuḵkunu mo yansan gway ka Birsaba mo, haali/ uni su/ thulki gwo me’da p̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Dhali gom gwo gi wakan mo tani uni gamki gwo me’d mo e Pam Birsaba mo. Dhala Abimaalik cuki mis mo dhala P̱ikul mo a’di jin ta wathi/ gom ’kwani ma meem piti mo dhali uni doḵkin ka nyaŋ’ko’d mo eya ’cesh gi Pam P̱ilisthiin mo. ");
INSERT INTO udu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Dhala Ibrahiim siki cwa jin wana e ka ’kwaṯṯan e Pam Birsaba mo dhali a’di ki yuḵ gway gi Tap̱a mo a’di jin ta’da Arumgimis jin di’d ki e ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Dhala Ibrahiim yaki’d ki yaŋ’kus e Bampa/ gi Pam P̱ilisthiin yil ka ris mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Dhali ki a’di warki’d ki mo jin pekin ma ris to gwansan mo tani Arumgimis nyo/ki’da Ibrahiim mo dhali o a’di gwo mo ki: Ibrahiim. Dhali a’di ki thoḵ a’di ’twa/ mo ki: Aha/ dina mmahan mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dhali a’di ki o gwo mo ki: Susi ya/m pini shwane/ a’di jin ta jim piniŋ gana/ mo, a’di jin ena /e, isi a’di jin ta’da Is/hak mo dhali iiyi mo eya ’cesh gi Pa Muriyya dhali /e mini ’ciṯẖ a’di ’kus mmomiiya roroc̱o/ e ’kuwosh mo e mo jin miga/ ṯor /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Dhala Ibrahiim cuki mis mo mon’thamo/ ka’tum mo dhali a’di ki shi’d thuluny piti akakasha ap̱o/ mo dhali a’di ki sus dhuru’c washan piti isu/ dhala Is/hak jin ta ya/m piti mo. Dhali a’di ki ’ce’d c̱iŋkira/ mo goma roroc̱o/ mo dhali a’di ki cu mis mo dhali ya mo e mo jin ṯor ma Arumgimis a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Dhali ka cim ’koni kwara mo tani Ibrahiim ’de’kki em piti ’kup̱ki mis mo dhali a’di ki p̱ar mo e isa dhana/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Dhala Ibrahiim ki o dhuru’c ’kwanim piti gwo mo ki: ’Koyi mmahan mo nyaḵki thuluny mo. Dhali aha/ dhali a’ci mina ii i maṯṯaan ari is ’ko’d mo dhali aman mina luŋ mo dhali doḵu/ ka nyaŋ’ko’di um mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Dhala Ibrahiim ki bu’th c̱iŋkira/ jin minu miiya roroc̱o/ mo dhali ’thiḵ a’di mo e ’kup̱a bi ma Is/hak jin ta ya/m piti mo dhali a’di ki ḵal o’di me’d piti mo dhali gandal mo. Dhali uni ki ii ’kup̱ki misi monṯal ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Dhala Is/hak oki’da Ibrahiim jin ta com mo dhali o gwo mo ki: Ababam pema! Dhali a’di ki thoḵ a’di gwo mo ki: Aha/ dina mmahan mo be. Hili mo mo ma. O’d jin shwa’d di’di mmahan dhali c̱iŋkira/ mo. Hili mane ḵa’bal jin mina ana i’ciṯẖ ’kus mmomiiya roroc̱o/ mo? ");
INSERT INTO udu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Dhala Ibrahiim ki o gwo mo ki: Arumgimis ki is piti midi thoson ana ḵa’bal jin mina ana ’ciṯẖ mmomiiya basa ’cesh mo, ya/m pem mo. Dhali uni su/ iikin ki misi monṯal ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Dhali uni p̱u’dkin e mo jin ṯor ma Arumgimis a’di mo. Dhala Ibrahiim ki ḵa’ba gwaṯa/ mo dhali su’k c̱iŋkira/ mo dhali deḵa Is/hak jin ta ya/m piti mo dhali ’thi a’di ap̱o/ ’kup̱a gwaṯa/ ap̱o/ c̱iŋkira/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Dhali yan’ko’d Ibrahiim he’thki me’d piti mo dhali bu’th gandal mo mmomuri ’taki ’kosh ya/m piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Hili aman’doyu gwo gi Tap̱a yuḵki a’di mo ’peni momis mo dhali oki a’di gwo mo ki: Ibrahiim. Ibrahiim. Dhali a’di oki gwo mo ki: Aha/ dina mmahan mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Dhali a’di ki o a’di gwo mo ki: Dhalku/ ki kar me’d pini ap̱owa ’ci mo, walla dhalku/ ki mii toŋ kamu/ gom a’di mo. Haali/ aha/ misha mo shwane/ ki /e ḵo/kina Arumgimis mo mmomishka/ ki /e diki non ya/m pini mo a’di jin ta ya/in gana/ ’peni aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Dhala Ibrahiim ’de’kki em piti ’kup̱ki mis mo dhali a’di ki p̱ar mo e mo dhali hili mo mo ma e bwamp̱o/ a’di mo tani arasiŋ ḵa’bal di’d jin bu’th ma ’de/ i’cem piti mo. Dhala Ibrahiim yaki’d mo dhali bu’th arasiŋ ḵa’bal mo dhali a’di ki c̱i a’di mo mmo’ciṯẖ ’kus mo mmomiiya basa ’cesh mo mmodhal ya/m piti e i is mo. ");
INSERT INTO udu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Dhala Ibrahiim ki yuḵ mo yan gway ka Yahwah Yir/ah mo, me’d jin okunu gwo ka tee yan mo ntagi shwane/ mo ki: E ’kuwosh gi Tap̱a mo tani a’di iminu thoson to mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Dhala man’doyu gwo gi Tap̱a yuḵki Ibrahiim mo me’di su/ ’peni momis mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Dhali a’di ki o gwo mo ki: Aha/ ki is pem mo tani thulkina gwo me’da p̱o/ mo a’di ita gwo jin ona Tap̱a gom to yan jin miikina /e mo dhali mmodina /e ki non ya/m pini a’di jin ta ya/m piniŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Gom mom’bor mii tani aha/ mina mar ’bor /e mii mo dhali gom mo jin maruwa mar is mo tani aha/ mara emen pini is mo mmowa e ka cul gi momis mo dhali mmowa e ka si’b kun ’koni bwaman ma gap̱ mo. Dhali emen pini mini dila ris to ’pena goŋ gi ’kwani gun ta ’kup̱ pini mo, ");
INSERT INTO udu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","dhali e emen pini mo tani aris kal gi ’kwaniny’cesh minu ’bor mii mo haali/ /e haki gwo gi ’twam pem e mo. ");
INSERT INTO udu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Gom gwo gi wakan mo tani Ibrahiim doḵki’d mo nyaḵki ’kwanin dhuru’c piti mo dhali uni ki cu mis mo dhali ii mo i monṯal ’de/ mo e Pam Birsaba mo. Dhala Ibrahiim c̱a’bki’d e Pam Birsaba mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Dhali a’di warki’d ki mo jin peki’d mo ’ko’da ris to gwansan gun ṯorkunu Ibrahiim mo mmo/o ki: Hili mo mo ma, aMilkah a’di dho’thki uc̱i mo ka kan ka Nahur mo, ");
INSERT INTO udu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Jin ṯwa/a/ yuḵu gway ka Uus mo dhali jiŋ ’ko’d yuḵu gway ka Buus dhali jin ’kon ma p̱o/ ikwara yuḵu gway ka Gamu/iil mo a’di jin ta’da baba ma Araam mo ");
INSERT INTO udu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","dhali Kaasad mo dhala Hasu mo dhala P̱ildaash mo dhala Yidlaap̱ mo dhala Baṯu/iil mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Dhala Baṯu/iil dho’thki’da Rip̱ka mo. Uc̱i ipekwara gwansan idho’thkin ma Milkah goma Nahur mo jin ta’da kam ma Ibrahiim mo be. ");
INSERT INTO udu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Dhala ’boma ’bwaash piti jin yuḵu gway ka Ra/uumah mo ayim si’da/ dho’thki’da Thaabah mo dhala Jaaham mo dhala Taahash mo dhala Maakah mo be. ");
INSERT INTO udu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Dhala Saarah diki’d ki e ki yili iss ’kwanimpa ipe’de/ i’ce’dka pesu/ ap̱o/ mo. Uni ta yil kun din ma Saarah ki e mo be. ");
INSERT INTO udu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Dhala Saarah a’di wuki’d mo e Paŋ Giryat/arba (a’di jin ta Habruun) e bampa/ gi Paŋ Kanaan mo dhala Ibrahiim yaki’d mo mmoko goma Saarah dhali ko ki gwony jabu’th goma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Dhala Ibrahiim cuki mis mo ibwambor a’di jin wuki’d mo dhali o ’Kwani gi Pa Hiṯẖṯẖa gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Aha/ tana wathi/ yilkina/ dhali aha/ yana yany c̱a/ ibwaman um mo. C̱iyaa/ mo mbwam um jin miga/ kana kan mo ki aha/ mina kan jwam pem ’peni jis/em pem mo. ");
INSERT INTO udu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","’Kwani gi Pa Hiṯẖṯẖa thoḵkina Ibrahiim gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ciḵi aman gwo mo ma. Tap̱am pem /e ta wathi/ jin c̱a’bki dem dem ibwaman aman mo. Kani jwam pini e mo jin mina /e ikwany mo e mo gi jis jwam bam mo. Wathiŋ kamu/ yisa midi non /e ’peni mo gi jis jwam piti yisa, walla midi non /e ’peni mmokan jwam pini yisa. ");
INSERT INTO udu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Dhala Ibrahiim cuki mis mo dhali luŋ is piti mbwambori ’Kwani gi Pa Hiṯẖṯẖa uni kun ta ’kwani gi bampa/ c̱aan mo. ");
INSERT INTO udu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Dhali a’di ki o uni gwo mo ki: Waḵki/ um ona bwa ki aha/ mina kan jwam pem ’peni jis/em pem mo tani ciḵi aha/ gwo mo dhali ’thoyi Ip̱ruun jin ta ya/ ma Suuhar mo ");
INSERT INTO udu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ki a’di midi c̱i aha/ jurum wosh gi Pa Makp̱iilah mo a’di jin ta jim piti mo, a’di jin di’di shemen buntom piti mo. Ka ṯẖaman gana/ mo tani dhalki a’di c̱i a’di aha/ e bwambori um mo ki a’di midi ta mo jin miga/ bu’th mmokana/ kan mo be. ");
INSERT INTO udu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Dhala Ip̱ruun a’di diki’di bwaman ’Kwani gi Pa Hiṯẖṯẖa mo dhali a’di ki thoḵki Ibrahiim gwo mo ki gwo jin ciḵkina ’Kwani gi Pa Hiṯẖṯẖa mo ’pena ris ’kwani kun iiyin ka pije/ gi ’twaŋkala goŋ gi ’peŋkuman bampam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Yisa, tap̱am pem ciḵ aha/ gwo mo. Aha/ c̱ikina /e bwam bunto dhali aha/ c̱ikina /e jurum wosh dhali to jin di’di bwaman a’di mo. E bwambori jis/e iya/ gi ’kwanim pem mo tani aha/ c̱ikina /e a’di mmokan jwam pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Dhali yan’ko’d Ibrahiim a’di luŋki is piti ibwambori ’kwani gi bampa/ yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Dhali a’di ki owa Ip̱ruun e mo jin ciḵa ’kwani gi bampa/ gwo mo ki: Hili waḵki/ /e mini ciḵ aha/ gwo mo tani aha/ mina c̱i /e ṯẖaman gi bunto mo. Buthi a’di ’peni aha/ mo ki aha/ mina kan jwam pem imun mo. ");
INSERT INTO udu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ip̱ruun thoḵki’da Ibrahiim gwo mo mmo/o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Tap̱am pem, ciḵi gwo ’peni aha/ mo ma. Mony’cesh jin yolka/ tani a’di ta iss ’kwanimpa i/iss ’de/ jin ta’da guurush gi ’dolkon kush mo. To yan midi ta atinta ibwaman /e dhali aha/ mo? Kani jwam pini mo ma. ");
INSERT INTO udu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibrahiim gamki gwo me’d nyaḵka Ip̱ruun mo dhala Ibrahiim ki bara guurush ’dolkon kush mo goma Ip̱ruun mo a’di jin yerkina a’di gway e gwo jin ciḵkina ’Kwani gi Pa Hiṯẖṯẖa jin ta’da guurush iss ’kwanimpa i/iss ’de/ ’peni ’dolkon kush mo me’d isi mii jin barkunu a’di ibwaman ’kwani kun ta imanyol to mo. ");
INSERT INTO udu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Gom gwo gi wakan mo tani bunto ma Ip̱ruun e Pa Makp̱iilah a’di jin di’d ’kup̱ ka bor ki mis gi Pa Mamra mo, e bunto jin dina jurum wosh a’di jin di’di bwaman mo dhala ris cwa kun ’koni bunto mo ntagi shemen piti ’baar mo tani a’di i’kwarkunu mo ");
INSERT INTO udu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ga Ibrahiim mo a’di ta mom piti mo ibwambori ’Kwani gi Pa Hiṯẖṯẖa mo dhali ibwambora ris uni kun iin bway bwamana goŋ gi ’peŋkuman bampam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ŋ’ko’d mii yan mo tani Ibrahiim kanki’da Saarah jin ta ash mo e jurum wosh gi mom bunto jin ta Makp̱iilah mo jin di’d ’kup̱ki mis ki Pa Mamra mo (a’di jin ta Pa Habruun) jin ta bampa/ gi Paŋ Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mombunto dhali jurum wosh jin di’di bwaman mo tani uni i’kwarkunu mo ga Ibrahiim mo mmota jim piti mo gom mo jin minu kana kan ki ’Kwani gi Pa Hiṯẖṯẖa mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Dhala Ibrahiim ta’da dhan mo, a’di ta dhana dhan gana/ ki yil piti mo. Dhali Tap̱a a’di ’borki’da Ibrahiim mii ka ris to ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Dhala Ibrahiim oki c̱iŋkinam piti gwo mo ki, a’di jin caki’d jin hilki gu’b piti mo, a’di jin ta tap̱a ap̱owa ris tom piti kun tana a’di mo, ki: Kari me’d pini awum pem mo. ");
INSERT INTO udu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Dhali aha/ mina kar /e mmothul gwo me’da ap̱o/ ki Tap̱a mo ka Arumgimis jin di’di momis mo dhali a’di jin di’di mony’cesh mo ki /e mini diki gama ’bom gom ya/m pem ’peni i’bwa/ gi ’Kwani gi Paŋ Kanaan mo e bwaman uni kun c̱a’bka/ mo. ");
INSERT INTO udu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Hili /e mini ya mo e bampam pem mo dhali e ’kwani ma bas pem mo dhali gama ’bom gom ya/m pem ka Is/hak mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Dhali c̱iŋkina/ ki o a’di gwo mo ki: Wariba/ a’bom midi diki hayaa/ gwo e mmobaṯẖaa/ e bampa/ yan mo. Waḵki/ wakan mo tani ya/m pini miga/ mii sus mo ka nyaŋ’ko’d e bampam pini jin yayina /e ’peni nycine/ mo? ");
INSERT INTO udu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibrahiim ki thoḵ a’di gwo mo ki: A/e mini mii dhalku/ ki sus ya/m pem ka nyaŋ’ko’d e bampa/ c̱aan mo. ");
INSERT INTO udu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tap̱a jin ta’da Arumgimis gi momis mo a’di jin suski aha/ mo ’peni gu’b ma babam pem mo dhali ’pena ’cesh jin dho’thkunu aha/ mo dhali a’di jin oki aha/ gwo mo dhali thulki aha/ gwo me’da ap̱o/ mo gom emen pem mo mmo/o ki: Aha/ mina c̱i emen pini a’cesh yan mo. Dhali a’di midi hasha man’doyu gwom piti ibwambori jis/em pini mo dhali /e mini gama ’bom gom ya/m pem ’peni mun mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Hili waḵka ’bom dina bwa ki oyu/ mmobaṯẖ /e mo tani yan’ko’d /e din ki ’kus ’peni gwo yan jin gama ana me’d mo haali/ /e yisa mini sus ya/m pem imuna. ");
INSERT INTO udu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Dhali gom gwo gi wakan mo tani c̱iŋkinam piti karki me’d piti eya wum ma Ibrahiim mo a’di jin ta tap̱am piti mo dhali thul gwo me’d ap̱o/ gom a’di isi gom gwo gi to yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Dhali yan’ko’d c̱iŋkina/ a’di suski kalmani ’kume’d jin ta ji gi tap̱am piti mo dhali bu’th moyam piti mo. Dhali a’di ki kala ris to kun c̱inu ki me’d e kugu ’peni tap̱am piti mo. Dhali a’di cuki mis mo dhali ya mo e uḵa ’cesh jin tana dhan yi’deya ḵara’b e ’peŋkuman bampa/ ma Nahur mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Dhali a’di ki ḵana ris kalman mo mmo’ko ki jiŋ ’kup̱a’dup̱una ’cesh ka pije/ ’peni ’peŋkuman bampa/ mo e yany jis yi’de/ ka tee c̱aan mom’pimpili/ mo ka tente/ jin ’ceṯẖa up̱ ka pije/ mmo/ii ha’b yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Dhali a’di ki o gwo mo ki: Ayy Tap̱a Arumgimis gi tap̱am pem ka Ibrahiim mo, nyoŋi aha/ ki ’bore/ mo jin miga/ gam mii adu is mo, aha/ ’thona /e mo. /E ki ṯor aha/ mmodhal mii e is ki mo/en gi tap̱am pem ka Ibrahiim mo. ");
INSERT INTO udu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Hili mo mo ma, aha/ doshkina e shemen jis yi’de/ jin kasha e mo dhali i’bwa/ gi ’kwani gi ’peŋkuman bampa/ uni iikin ka pije/ mmoha’b yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Dhalki nyara/ jin miga/ o gwo ki: Aha/ ’thona /e ki /e mini dhal dhur yi’dem pini mo ki aha/ mina ’taki p̱i yi’de/ mo, dhali jin midi oyaa/ gwo mo ki: P̱iyi ma tani dhali aha/ mina c̱iki kalman pini mmop̱i mo, dhalka yim midi mii ta a’di jin mina /e mii kar ’pen ka pije/ gom c̱iŋkinam pini ka Is/hak mo be. Dhali gom mii yan kan mo tani aha/ mina mish ki /e ṯorki aha/ mo/en gi tap̱am pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Nṯwa/a/ ki a’di ki ’baarki gwom piti mmo/o mo tani hili mo mo ma, Rip̱ka a’di jin dho’thkunu ka Baṯu/iil jin ta ya/ ma Milkah jin ta ash ma Nahur jin ta’da kam ma Ibrahiim mo tani a’di yayi’d ka pije/ ka dhur yi’dem piti me’d e ’kup̱a bi ma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ayim nyara/ ta jaro/ ki jaro/ mo, a’di jin di’d ki nyaraŋ gana/ a’di jin dina wathiŋ kamu/ ki mash mo. Ayim yaki’d ka luŋgu’b e jis yi’de/ jin kasha e mo dhali ’tu’d dhur ma yim mo dhali a’di p̱u’dki’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yan’ko’d a’di jin ta c̱iŋkina/ guski’d mo mmogama ayim ’kup̱ mo dhali o gwo mo ki: Aha/ ’thona /e mmoc̱iyaa/ ari yi’de/ ’peni dhur pini mo. ");
INSERT INTO udu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Dhala yim ki o gwo mo ki: P̱iyi ma, tap̱am pem mo, dhala yim ki jahanne/ ki dhal dhur piti me’d ’peni me’d ma yim mo dhali a’di ki c̱i a’di yi’de/ mmop̱i mo. ");
INSERT INTO udu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Dhali ka yim ’baarki yi’de/ mmoc̱i a’di mmop̱i mo tani ayim ki o gwo mo ki: Aha/ si’da/ mina mush ki kalman pini yi’de/ mo ntagi uni mini p̱i ikap̱ mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Dhali ki jahanne/ ayim ki gac̱ yi’dem piti eya ḵur mo dhali gus ka nyaŋ’ko’d bway jis yi’de/ mo mmomush yi’de/ mo dhala yim mushki yi’de/ goma ris kalman piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Wathi/ ki guwa yim ki e ki e ma ’thime/ ki shwamm mo mmoda/ar gwo waḵki/ Tap̱a thoson moyam piti mo walla yisa. ");
INSERT INTO udu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ki kalman kap̱ki yi’de/ mmop̱i mo tani wathi/ ki bu’th ’dolkon jin hidhu i me’d jin baru ka nusa guurush mo dhali gurany ’peri su/ mo goma yim ki hidha bi mo jin baru ki ’dolkoni ’kume’d ka guurush mo. ");
INSERT INTO udu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Dhali yan’ko’d a’di ki o gwo mo ki: Ṯoraa/ gwo mo ma ki /e ta ’bwa/ maja mo? A/mo jin ishu di’di gu’b gi cima jin mina aman i/ishi cineya? ");
INSERT INTO udu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ayim ki o a’di gwo mo ki: Aha/ tana ’bwa/ ma Baṯu/iil jin ta ya/ ma Milkah mo a’di jin dho’thkin ma yim ka Nahur mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Dhala yim ki mar gwo is mo mmo/o gwo mo ki: Am tana ka wusha/ dhali tonṯe/ mmo’kosh jwa mo dhali gu’b mmo/ishi cine/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Wathi/ ki goŋ ’kup̱ piti ka luŋgu’b mo dhali luŋ Tap̱a mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Dhali a’di ki o gwo mo ki: Mom’bor mii gom Tap̱a mo a’di jin ta’da Arumgimis gi tap̱am pem ka Ibrahiim mo, a’di jin diki dhal mo/en piti ’pen mo dhali mii ma isiŋ gana/ ’kup̱ ki tap̱am pem mo. Dhali gom aha/ tani Tap̱a ki shu aha/ bway gu’b gi ibas gi itap̱am pem mo. ");
INSERT INTO udu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Dhali yan’ko’d nyara/ a’di guski’d mo dhali ṯor ’kwani gi gu’b gi kum gwo mo goma ris to gwansan mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Dhala Rip̱ka ta’d ka kam jin yuḵu gway ka Laabaan mo. Dhala Laabaan ki gus ka pije/ e wathi/ mo e jis yi’de/ jin kasha e mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Dhali a’di ki p̱ar tome’d e mo dhali gurany ’per eya bi gi ’bwaham mo dhali me’d jin ciḵkina a’di gwo gi ’bwaham ga Rip̱ka mo ki: Wathi/ ṯorki’da ṯor ki aha/ mo tani a’di yaki’d mo e wathi/ mo. Dhali hili mo mo ma, a’di doshki’d nyaḵka kalman e jis yi’de/ jin kasha e mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","A’di ki o gwo mo ki: Yayi mo. Ayy mom’bor mii gi Tap̱a mo. Atinta dosha /eya pije/ kan mo? Haali/ aha/ thosonkina /e gu’b mo dhali mo gom kalman mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Gom gwo gi wakan mo tani wathi/ p̱u’dki’d e gu’b mo. Dhala Laabaan ’cuḵki kalman ashi/ mo dhali a’di ki c̱i uni awusha/ mo dhali tonṯe/ gom kalman mmoshwa mo dhali yi’de/ mmolam sho’k piti mo dhali sho’k gi ’kwani kun nyaḵ iiyu/ ki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Dhali yan’ko’d mo tani tonṯe/ karu ibwambori a’di mmoshwa mo. Hili a’di ki o gwo mo ki: Aha/ mina diki shwa tonṯe/ naskina/ ntagi aha/ mina ṯor ’pemen ’kup̱ yam pem yan. Dhali a’di ki o a’di gwo mo ki: Ṯori gwo mo ma. ");
INSERT INTO udu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Dhali gom gwo gi wakan mo tani a’di ki o gwo mo ki: Aha/ tana c̱iŋkina/ ma Ibrahiim mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tap̱a a’di ’borki tap̱am pem mii kagahara mo dhali a’di caki’d mo. Dhali Arumgimis c̱iki a’di toŋkal mo dhali bip̱ mo dhali ’dolkon kush dhali ’dolkon gana/ dhala ris c̱iŋkina/ kun miina ṯu’c mo kun ta gwaṯẖ mo dhala ris c̱iŋkina/ kun miina ṯu’c kun ta nyara/ mo dhala ris kalman dhala ris thuluny mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Dhala Saarah jin ta ash gi tap̱am pem mo tani a’di dho’thki ya/ mo gom tap̱am pem mo ka yim ta’da dhan mo dhali ki a’di mo tani a’di c̱iki’da ris to ’baar mo kun tana a’di ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tap̱am pem ki kar aha/ mmothul gwo me’da p̱o/ mo mmo/o gwo mo ki: /E mini mii diki dhal ya/m pem bway mmogam nyara/ ’peni ’Kwani gi Paŋ Kanaan mo e mony’cesh jin dika/ mo. ");
INSERT INTO udu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Hili /e mini ya mo e gu’b ma babam pem mo e ’kwani ma bas pem mo dhali gama ’bom gom ya/m pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Dhali aha/ ki o tap̱am pem gwo mo ki: Wariba/ a’bom midi ushu mmoyayu/ nyaḵki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Hili a’di ki o aha/ gwo mo ki: Tap̱a a’di jin yaka/ ibwambor midi hasha man’doyu gwom piti nyaḵki /e mo mmoshu /e bway mo dhali /e mini gama ’bom gom ya/m pem ’peni ’kwani ma bas pem mo dhali ’peni ’kwani gi gu’b ma baba mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Dhali yan’ko’d /e mini di ki ’kus mo ’peni gwo jin thulka/ me’da p̱o/ mo, me’d jin mina /e ya mo e ’kwani ma bas pem mo. Dhali waḵki/ uni mini ’koki c̱i ayim ki /e mo tani /e din ki ’kus mo ’peni gwo jin thulka/ me’da p̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Aha/ p̱u’dkina mo shwane/ e jis yi’de/ jin kasha e mo dhali o gwo mo ki: Ayy Tap̱a /e jin tana Arumgimis gi tap̱am pem ka Ibrahiim mo, waḵki/ /e shwane/ mini shu/aa/ bway e bway jin miga/ ya mo tani ");
INSERT INTO udu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","hili mo mo ma aha/ doshkina e jis yi’de/ jin kasha e mo dhali dhalki nyara/ jin p̱u’du’d mmoya mush yi’de/ mo a’di jin miga/ o gwo mo ki: C̱iyaa/ ari yi’de/ ’pena dhur mo ma tani ");
INSERT INTO udu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","dhali a’di midi oyaa/ gwo mo ki: P̱iyi ma dhali aha/ mina mush gom kalman pini si’da/ mo. Dhalki a’di ta’da yim jin mina Tap̱a kar ’pen ka pije/ gom ya/ gi tap̱am pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nṯwa/a/ ki aha/ daḵa gwom pem o mo eya du mo tani hili mo mo ma, aRip̱ka a’di ayim p̱u’dki’d mo nyaḵki dhur yi’de/ e ’kup̱a bi ma yim mo dhala yim yaki’d ka luŋgu’b e jis yi’de/ jin kasha e mo dhali mush yi’de/ mo dhali aha/ ki owa yim gwo mo ki: C̱iyaa/ dhalki aha/ p̱ina ma. ");
INSERT INTO udu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Dhali ki jahanne/ ayim ki dhal dhur yi’de/ me’d ’peni ’kup̱a bi ma yim mo dhali o aha/ gwo mo ki: P̱iyi ma dhali aha/ mina c̱i ki kalman pini si’da/ mmop̱i mo. ");
INSERT INTO udu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Gom gwo gi wakan mo tani aha/ p̱ikina mo dhala yim ki c̱i ki kalman mmop̱i si’da/ mo be. Dhali yan’ko’d mo tani aha/ ki doṯa yim gwo mo mmo/o ki: /E ta ’bwa/ maja si’da/? Ayim ki thoḵ aha/ gwo mo ki: Aha/ tana ’bwa/ ma Baṯu/iil jin ta ya/ ma Nahur mo, a’di jin dho’thkin ma Milkah a’di mo. Gom gwo gi wakan mo tani aha/ ki kar dhirriny ’dolkon e shush ma yim dhali gurany ’per eya bi ma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Dhali yan’ko’d aha/ ki luŋ ’kup̱ pem mo dhali luŋ Tap̱a mo, dhali ’bor Tap̱a mii mo a’di jin ta’da Arumgimis gi tap̱am pem ka Ibrahiim mo, a’di jin shu aha/ bway, ki bwaya ’borgaŋ gana/ mmosus ’bwa/ gi ’kwani ma bas gi tap̱am pem gom ya/m piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Dhali shwane/ waḵki/ /e mini ṯu/ul gi mii ma teṯe/ mo dhali gi miiŋ gana/ gi tap̱am pem mo tani ṯori /e aha/ gwo mo dhali waḵki/ diki ta gwoŋ gana/ mo tani ṯori aha/ gwo mo ki aha/ mina ṯu’k mo ki me’da bim poros mo walla ki me’da biny cam mo. ");
INSERT INTO udu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Dhali yan’ko’d mo tani Laabaan dhala Baṯu/iil thoḵki gwo mo ki: To gwan p̱u’dkin ’peni Tap̱a mo dhali aman mola gwo shiyi’di o i /e walla jim ’boro’d mo. ");
INSERT INTO udu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Hili mo mo ma, aRip̱ka a’di di’di bori /e mo. Susa yim mo dhali iiyi mo me’d gwo jin okina Tap̱a mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Dhali ki c̱iŋkina/ ma Ibrahiim ciḵki gwo jin ona uni mo tani a’di goŋki is piti mo ka ’cesh ibwambori Tap̱a mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Dhali c̱iŋkina/ a’di ḵalki’da ris tonyjaro/ kun ta ’dolkon kush mo dhali ’dolkon gana/ mo dhali burrinye/ dhali c̱iki uni ka Rip̱ka mo dhali a’di ki c̱i ki uni ka kam nyara/ mo dhali ki kum nyara/ mo to gi ’bitha yol she/ ki ’bi’th mo. ");
INSERT INTO udu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Dhali a’di dhali ’kwani kun nyaḵ ii ki a’di mo tani uni shwaki to mo dhali p̱iki to mo dhali uni ki isha cim ’deŋ gana/ imun mo. Ki uni cuki mis mon’thamo/ mo tani a’di ki o gwo mo ki: Hashi aha/ ka nyaŋ’ko’d e tap̱am pem mo. ");
INSERT INTO udu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Akam gi nyara/ dhali kum nyara/ ki o gwo mo ki: Ayim midi c̱a’b naskina/ ka cimi ’kume’d mo. ’Ko’da cim c̱aan mo tani ayim midi ya beseene/. ");
INSERT INTO udu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Hili a’di ki o uni gwo mo ki: Dhalku/ ki mii aha/ mii ka diiṯe/ mo. Me’d jin ’borkina Tap̱a aha/ mii e bway pem mo tani dhalki aha/ yana mo ki aha/ mina ya mo e tap̱am pem mo. ");
INSERT INTO udu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Uni ki o gwo mo ki: Am mina yuḵ nyara/ mo dhali doṯa yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Dhali uni yuḵkina aRip̱ka mo dhali owa ayim gwo mo ki: A/e mini ya nyaḵki wathi/ yan mo? Ayim ki o gwo mo ki: Aha/ mina ya mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Gom gwo gi wakan mo tani uni hashkina Rip̱ka jin ta ’bwaham mo dhala yim jin midi nyaḵ di ki a’di mo dhali c̱iŋkina/ ma Ibrahiim mo dhali ’kwanim piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Dhali uni ’borkina Rip̱ka mii mo dhali owa yim gwo mo ki: ’Bwah bama, tayi ata’da gi ’kwani ma alaap̱ ka ris kun maru is ka alaap̱i ’kume’d mo dhali dhalki emen pini dil to ’peni ’twaman ma goŋ gi uni gwansan kun shi/ uni i e mo. ");
INSERT INTO udu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Dhali yan’ko’d aRip̱ka dhali nyara/ kun nyaḵ ii ki a’di cuki mis mo dhali mer kalmana p̱o/ mo dhali baṯẖ wathi/ mo. Dhali kan c̱iŋkina/ suski’da Rip̱ka dhali ya e bway piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Dhala Is/hak a’di yayi’d ’peni Pam Birlahayru/i dhali a’di c̱a’bki’d mo eya Januub mo. ");
INSERT INTO udu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Dhala Is/hak yaki’d ka pije/ mmo’thowa pije/ mo e mom’pimpili/ mo. Dhali a’di ’de’kki em piti ’kup̱ki mis mo dhali p̱ar mo e mo dhali hili mo mo ma, kalman uni p̱u’dkin mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Dhala Rip̱ka ’de’kki em piti ’kup̱ ki mis mo dhali ka yim p̱arki’da Is/hak e mo tani ayim ki thul ka ’cesh ’peni kalman mo ");
INSERT INTO udu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","dhali o c̱iŋkina/ gwo mo ki: Wathi/ jana idi’di maṯṯaan mo a’di jin yayi’d mmogam ana ’kup̱ mo? C̱iŋkina/ ki thoḵ a’di gwo mo ki: A’di ta tap̱am pem mo. Wakan ayim ki bu’th burrinyeŋ ’kup̱ piti dhali kum is piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Dhali c̱iŋkina/ ki ṯor Is/hak gwo goma ris to kun miikina a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Dhali yan’ko’d Is/hak ki susa yim e gu’b burrinye/ mo dhali a’di ki butha Rip̱ka dhali ayim warki’d ki ash mo dhali a’di enki’da yim mo. Dhala Is/hak a’di malaskunuwa du mo ’ko’di jwa gi kum mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahiim a’di bu’thki’da ’boma kamu/ mo a’di jin yuḵu gway ka Gathuurah mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ayim dho’thki a’di aSimraan mo dhala Yagshaan mo dhala Madaan mo dhala Midyaan mo dhala Yishbaag mo dhala Shuha mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yagshaan si’da/ a’di ita’da baba ma Shaba mo dhala Dadaan mo. Dhali iya/ ma Dadaan uni si’da/ annihe/ mo: Ashshuriim dhala Lathushiim dhala La/ummiim mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Dhali iya/ ma Midyaan uni si’da/ annihe/ mo: Ep̱ah dhala Ip̱ir mo dhala Hanuuk mo dhala Abiidaa/ mo dhala Elda/ah mo be. Aris uc̱i gwansan uni ta kuma Gathuurah mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahiim c̱iki’da ris tom piti kun tana a’di ka Is/hak i’baar mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Hili e iya/ gi up̱ lac̱am piti yan mo tani Ibrahiim ki c̱i uni to kun c̱inu ki me’d mo, dhali ki a’di di’d ki e naskina/ mo tani a’di ki dhuki uni ’pen mo ’peni ya/m pitiŋ gana/ ka Is/hak mo mmo/iiku/ mmo’koku/ ’kup̱ki mom’pesho’k isa dhana/ imun mo jin ta bampa/ gi mom’pesho’k mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Hili atee yil jin din ma Ibrahiim ki e annihe/ mo, a’di ’kona yili iss ’kwanimpa ipekwara i’ce’dka ḵarpa’c ap̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ibrahiim a’di c̱iki shi/in piti jiŋ ’ko’d mo dhali a’di wuki’d mo ki dhana dhan gana/ mo mmotana a’di dhan gumpan dhan ki yil piti mo dhali a’di gamkunu me’d nyaḵki ’kwanim piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Is/hak dhala Isma/iil uni kun ta iya/m piti mo tani uni kanki a’di e jurum wosh ma Makp̱iilah mo e bwam bunto ma Ip̱ruun jin ta ya/ ma Suuhar jin ta wathi/ Hiṯẖṯẖa jin di’d ’kup̱ ka bor ki mis ki Pa Mamra mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Bwam bunto yan yolkin ma Ibrahiim ’peni ’Kwani Hiṯẖṯẖa mo tani a’di ikankunu a’di nycine/ uni ka ashim piti ka Saarah mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","’Ko’di jwa ma Ibrahiim mo tani Arumgimis ’borki’da Is/hak mii mo a’di jin ta ya/m piti mo. Dhala Is/hak a’di c̱a’bki’d mo e pam Birlahayru/i mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Uni kun ta emen ma Isma/iil kun yerkunu gwayi ’ko’d mo a’di jin ta ya/ ma Ibrahiim mo ka Haagar jin ta ji Masir mo a’di jin ta c̱iŋkina/ nyara/ ma Saarah a’di jin dho’thkina a’di ka Ibrahiim mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Gway gi iya/ ma Isma/iil mo tani uni annihe/ mo, a’di jin yerkunu ka baṯẖ ’pen ka dho’th buni mo: Nabayuut a’di ita’da bwanyara/ ma Isma/iil mo dhala Gidar mo dhala Adab/iil mo dhala Mibsaam mo, ");
INSERT INTO udu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","dhala Mishmaa/ mo dhala Duumah mo dhala Massa mo ");
INSERT INTO udu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","dhala Hadaar mo dhala Teema mo dhala Yathuur mo dhala Nap̱ish mo dhala Gidmah mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Uni gwansan uni ita iya/ ma Isma/iil mo dhali gway buni si’da/ uni anann mo be. Dhali gway bampam buni dhali aṯa/ kun ’kona uni tani uni ’kume’d i’ce’dka su/ mo ka waḵ buni kun tana uni iya/ ma maliḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Hili atee yil jin din ma Isma/iil annihe/ mo, a’di ’kona yili iss ’kwanimpa ipesu/ aṯẖ ikwara mo dhali a’di c̱iki shi/in piti jiŋ ’ko’d mo dhali a’di wuki’d mo dhali a’di nyaḵkunu is gam me’d ki ’kwani ma bas piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Uni ’peni Pa Hawiila ntagi Pan Shur mo a’di jin di’d ka p̱ar ’twa/ ki Pa Masir mo ’kup̱ki bway jin c̱uthi ’twa/ ’kup̱ki bway Pa Ashshuur mo be. A’di c̱a’bki’da p̱o/ aris ’kwanim piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Gway gi iya/ ma Is/hak uni kun ta emen piti mo a’di jin ta ya/ ma Ibrahiim mo: Ibrahiim jin ta’da baba ma Is/hak mo. ");
INSERT INTO udu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Is/hak a’di i’kokina yili issu/ mo ka dhan piti me’d jin bu’thkina a’di aRip̱ka ki ash mo a’di yim jin ta ’bwa/ ma Baṯu/iil mo jin ta Wathi/ Araam gi Pam P̱addaan/araam jin ta ’bwah ma Laabaan Wathi/ Araam mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Dhala Is/hak ’thoki’da Arumgimis gom ash mo, dhala Rip̱ka jin ta ash a’di yim bwaaki’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Dhali uc̱i su/ gwansan uni gurunyki is e bwa ma yim mo, dhali ayim ki o gwo mo ki: Waḵki/ a’di wakan mo tani, ata si’da/ idika/ ki e mo? Gom gwo gi wakan mo tani ayim yaki’d mo dhali ’theḵ gwo yan e Tap̱a Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Dhali Tap̱a ki owa yim gwo mo ki: Kal ’koni su/ e bwa ma dho’th pini mo, dhali ’kwani su/ gwan kun mina /e dho’th mo tani uni mini ḵwa/ bwa mo dhali jan ṯal ’de/ a’di imidi ’bitha’bi’th mo mmobola kamu/ e mo, dhali a’di jin ca’d a’di imidi mii ara kam to mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ka tee ma yim jin mina a’di dho’th thimkunu mo tani, hili mo mo ma, ushi uc̱i su/ ’kon e bwa ma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","A’di jin p̱u’dki’di ṯwa/a/ mo tani a’di tagi ’per mo, dhali aris buŋgwar is piti wana e ki burrinye/ muri is mo. Gom gwo gi wakan mo tani a’di yuḵki a’di gway ka Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Dhali yan’ko’d mo tani akam p̱u’dki’d mo, dhali me’d piti bu’thki ’pena ṯiŋkila/ ma Iisu mo. Dhali gom gwo gi wakan mo tani a’di yuḵkunu gway ka Yakuub mo. Is/hak ’kona yil issi kwara mo me’d jin dho’thkin ma yim uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Me’d jin cakina uc̱i su/ mo tani Iisu ta wathi/ jin kora e ki kor e mompar mo, a’di ta wathi/ ma shoŋ gana/ mo ka Yakuub ta wathi/ jin bu’th is piti ka mathaŋ’kur dhali c̱a’b e gu’b burrinye/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Is/hak enki’da Iisu mo haali/ a’di ’kaki shum piti kun parkina a’di mo. Hila Rip̱ka enki’da Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ka cima kamu/ me’d jin miikin ma Yakuub a’tash mo tani Iisu p̱u’dki’di pa mo ’peni bwaasho mo dhali a’di muṯṯa/ ṯe/ is kagahara mo. ");
INSERT INTO udu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Dhali Iisu ki owa Yakuub gwo mo ki: Dhalki aha/ nyoḵa ’tash pini yan jin cesa /e e ki ’per ’per mo haali/ aha/ muṯṯa/ ṯe/ is mo (gom gwo gi wakan mo tani a’di iyuḵkunu a’di gway ka Aduum mo). ");
INSERT INTO udu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakuub oki gwo mo ki: /E mini yolaa/ mo ma bwanyaran dho’th ganam pini yan mo. ");
INSERT INTO udu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iisu thoḵki gwo mo ki: Aha/ mura wu ’te/ mo be. Mo ma bwanyara/ yan midi miiya ta gom aha/ mo? ");
INSERT INTO udu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakuub ki o gwo mo ki: /E mini thul gwo me’da p̱o/ nṯwa/a/ gom aha/ mo, dhali wakan a’di thulki gwo me’da p̱o/ gom a’di dhali yol mo ma bwanyaran dho’th pitiŋ gana/ ka Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yan’ko’da Yakuub ki c̱ika Iisu maaŋ guraasa dhala ’tasha p̱asuliya jin cesu/ mo dhali a’di shwaki a’di mo dhali a’di p̱iki to mo dhali cu mis mo dhali ya e bway piti mo. Iisu a’di ishi/ki mo ma bwanyaram pitiŋ gana/ i e mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Dhali shwane/ ṯe/ p̱u’dki’d mo e bampa/ mo mmowaki ṯen dhamo/ mo me’d jin din ma Ibrahiim mo. Dhala Is/hak a’di yaki’d mo e Pany Jaraar mo eya Abimaalik jin ta’da maliḵ gi ’Kwani P̱ilisthiin mo. ");
INSERT INTO udu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Dhali Tap̱a piki a’di i is mo, dhali o a’di gwo mo ki: Dhalku/ ki ya ka luŋgu’b bway Pa Masir mo. Hili c̱a’bi /e eya ’cesh jin miga/ ṯor /e mo. ");
INSERT INTO udu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tayi ac̱a/ eya ’cesh yan mo dhali aha/ mina di nyaḵki /e mo dhali ’bor /e mii mo, dhali gom /e mo dhali gom emen pini mo tani aha/ mina c̱i aris bampa/ gwan ki /e mo dhali aha/ mina thim gwom pem jin oka/ is mo mmothul gwo me’da p̱o/ goma Ibrahiim jin ta’da babam pini mo be ki: ");
INSERT INTO udu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aha/ mina mar emen pini is mo me’da cul gi momis mo dhali aha/ mina c̱i emen pini aris bampa/ yani ’baar mo. Dhali gom gway gi emen pini mo tani aris kal gi mony’cesh mini ’bor is buni mii ki uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Haala Ibrahiim haki gwo gi ’twam pem e mo dhali dhu gwo kun ḵanka/ a’di mo dhali gwoŋḵan pem mo dhali gwoŋḵan pem kun c̱inu ki ’twa/ mo dhali gwoŋḵan pem jin c̱inu mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Gom gwo gi wakan mo tani Is/hak a’di c̱a’bki’d mo e Pany Jaraar mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ki ’kwaniŋ gwaṯẖ gi mo yan doṯki a’di gwo mo gom ash mo tani, a’di ki thoḵ gwo mo ki: Ayim a’di ita ’bwah pem mo, haali/ a’di ḵo/ki is mo mmo/o ki a’di ta ashim piti mo isi ciki/ ’kwani gi mo yan imini ’taki ’kosh a’di jwa mo gom gway ma Rip̱ka mo, haala yim dina jarom piti ki she/ mo mmohil mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ki a’di diki’d e mun ki rash rash mo tani Abimaalik jin ta’da maliḵ gi ’Kwani P̱ilisthiin mo tani a’di hilki mo ki e shu’d gu’b mo dhali p̱ara Is/hak e mo mmolo’bkina a’di aRip̱ka jin ta ash mo. ");
INSERT INTO udu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Gom gwo gi wakan mo tani Abimaalik yuḵki’da Is/hak mo dhali o a’di gwo mo ki: Hili mo mo ma, ayim ta ashin mo ba/, kata jan ona /e gwo oki ayim ta ’bwahan mo? Is/hak ki thoḵ a’di gwo mo ki: Haali/ aha/ kulumkina gwo ibwa mo oki aha/ mina wu mo gom gwo ma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimaalik ki o a’di gwo mo ki: Atinta a’dan jin miikina /e wakan ap̱o/ aman mo, wathiŋ kamun ’de/ wariba/ midi ’taki ya mo isha ’bom pini mo dhali /e mini ’taki guyu/ mo jin thamu mii ap̱o/ aman mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Gom gwo gi wakan mo tani Abimaalik ki ruma aris ’kwani ’baar ki gwo mo mmo/o ki: A’di yin jin midi ta wathi/ yan is ki cwa mo walla ashim piti mo tani a’di minu ’kosh jwa mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Dhala Is/hak siki to mo e bampa/ yan mo dhali a’di ’ciṯẖki to mo ki yila ’de/ yan mo ki iss ’kwanimpa imudhe’d mo. Haali/ Tap̱a a’di ’borki a’di mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Dhali wathi/ warki’d ki wathimpa mo dhali gama ris to ki nyanye/ kun markunu is mo ntagi a’di ta wathi/ jin eḵa/ ’pen ki eḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","A’di taki’d ga ma’diny ḵa’bal kun jinu mo dhali bip̱ mo dhali aris c̱iŋkina/ tana ris mo kun ’kokin e gu’b piti mo, dhali gom gwo gi wakan mo tani ’Kwani P̱ilisthiin uni taki dhap̱an ap̱o/ a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","(Dhali shwane/ ’Kwani P̱ilisthiin uni ’dap̱kina aris jis yi’de/ ’twa/ ka dihar mo uni kun c̱wanykin ma ris c̱iŋkina/ gi com ka tee ma babam piti ka Ibrahiim mo.) ");
INSERT INTO udu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Dhali Abimaalik ki owa Is/hak gwo mo ki: Yaku/ /e mo ’peni aman mo haali/ /e ta wathi/ jin c̱a’bki dem dem mmobol am e mo. ");
INSERT INTO udu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Gom gwo gi wakan mo tani Is/hak yaki’d mo ’peni maṯṯaan mo dhali nyaŋ gu’b burrinyem piti e embul wosh ma Jaraar mo dhali c̱a’bi mun mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Dhala Is/hak c̱wanyki jis yi’de/ doḵ/e mo e mo jin ’thissa/ c̱wanykunu uni ka tee ma Ibrahiim jin ta com mo haali/ ’Kwani P̱ilisthiin ’thissa/ ’dap̱ki uni ’twa/ ka dihar mo ’ko’di jwa ma Ibrahiim mo dhali a’di yerki uni gway mo me’d jin yerkina com uni gway mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Hili ki c̱iŋkina/ ma Is/hak c̱wanyki jis yi’de/ mo e embul wosh mo tani uni gamki jis yi’de/ kun kasha yi’de/ e ki kash mo. ");
INSERT INTO udu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Dhali imanhil ḵa’bal gi Pany Jaraar uni walkin ki imanhil ḵa’bal ma Is/hak mo mmo/o gwo mo ki: Yi’de/ ta jim bam mo be. Dhali gom gwo gi wakan mo tani a’di yuḵki jis yi’de/ yan ki gway mo ka Isig haali/ uni askin gom a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Dhali yan’ko’d uni c̱wanyki jis yi’deŋ kamu/ mo dhali uni si’da/ walkina p̱o/ c̱aan mo. Dhali gom gwo gi wakan mo tani a’di ki yuḵ jis yi’de/ yan ka Sithnah mo. ");
INSERT INTO udu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Dhali a’di so’kki’d mo ’peni mun mo dhali c̱wany jis yi’deŋ kamu/ mo dhali ap̱o/ c̱aan mo tani uni ’koki wal mo, dhali gom gwo gi wakan mo tani a’di ki yuḵ jis yi’de/ yan gway ka Rahubut mmo/o gwo mo ki: Tap̱a a’di ithosonki ana embul mo mo dhali ana shwane/ mina ḵal mamana dho’th mo e bampa/ yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","’Peni maṯṯaan mo tani a’di yaki’d ka gagamis mo e Pan Birsaba mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Dhali Tap̱a piki a’di i is mon’thiny mo dhali o gwo mo ki: Aha/ tana Arumgimis ma Ibrahiim jin ta’da babam pini mo, dhalku/ is ki ḵo/ mo haali/ aha/ mina nyaḵ di ki /e mo dhali ’bor /e mii mo dhali mar emen pini is mo gom gway gi c̱iŋkinam pem ka Ibrahiim mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Gom gwo gi wakan mo tani a’di nyaŋki’da gwaṯa/ jin miinuwa basa ’cesh mo e mun mo dhali yuḵ gway gi Tap̱a mo dhali thum gu’b burrinyem piti i mun mo. Dhali e mun mo tani c̱iŋkina/ ma Is/hak uni c̱wanyki jis yi’de/ ka ris mo. ");
INSERT INTO udu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Dhali yan’ko’d Abimaalik yaki’di a’di ’peni Pany Jaraar mo nyaḵka Ahussaat jin ta’da amanlogom a’di ki gwo mo dhala P̱ikul jin ta’da ’kaŋ’kup̱ gom ’kwani ma meem piti mo. ");
INSERT INTO udu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Is/hak ki o uni gwo mo ki: Atinta iiyina umi aha/ mo? ’Kona um ki misha ki um shi/i aha/ i e mo dhali ur aha/ mo ’peni um mowa? ");
INSERT INTO udu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Uni ki thoḵ a’di gwo mo ki: Aman misha eya tenteŋ gana/ ki Tap̱a di’d nyaḵki /e mo, a’di i/ona aman gwo jin waki cise/ mo ki: Dhalki mo jin minu mii thul gwo me’da p̱o/ midi mii di mo e bwaman am dhali /e mo, dhali dhalki ana gama gwo jin gamu me’d mo nyaḵki /e mo. ");
INSERT INTO udu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ki /e mini diki mii to shiyi’da kamu/ ap̱o/ aman mo, me’d jin ’kona aman ki ta /e is ki cwa mo dhali aman si’da/ ’konaki mii toŋ kamu/ mo hili jasi tom ’boro’d mo dhali hashki /e mo ki moŋḵu’th is mo. /E shwane/ ’borkina Tap̱a mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Gom gwo gi wakan mo tani a’di miiki uni tonṯe/ jin shwanu ka tul ’kup̱ mo dhali uni shwaki to mo dhali uni p̱iki to mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Dhali mon’thamo/ mo tani uni cuki mis mo ki jahanne/ mo dhali thul gwo me’da p̱o/ ka rem’kup̱ mo, dhala Is/hak dhuki uni ’pen mo e bway buni mo dhali uni iikin mo ’peni a’di ki moŋḵu’th is mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Dhali ’pena cim ’de/ yan mo tani c̱iŋkina/ ma Is/hak p̱u’dkin mo dhali ṯor a’di gwo gom jis yi’de/ kun c̱wanykina uni mo dhali o gwo mo ki: Aman gamkina yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","A’di yuḵki jis yi’de/ yan gway mo ka Shibah mo. Gom ’pemen gwo gi wakan mo tani a’di iyuḵkunu ’peŋkuman bampa/ yan gway ka Birsaba ntagi shwanesan mo be. ");
INSERT INTO udu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Me’d jin ’kona yili Iisu i issu/ mo tani a’di bu’thki ash mo jin yuḵu gway ka Yahudiit jin ta ’bwa/ ma Biiri jin ta Wathi/ Hiṯẖṯẖa mo dhala Basmah jin ta ’bwa/ ma Iiluun jin ta Wathi/ Hiṯẖṯẖa mo. ");
INSERT INTO udu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Dhali uni gwan mii moŋ’ko ap̱owa Is/hak dhala Rip̱ka mmoḵa/a ḵa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ka Is/hak taki’da dhan mo dhali em piti si’da/ dhuruma/ dhurum wakan mo a’di imolkina a’di mo mmop̱ar e ki ’bore/ mo, a’di iyuḵkina a’di a/Iisu mo a’di jin ta ya/m piti jin ca’d mo dhali o a’di gwo mo ki: Ya/m pema, dhali a’di ki thoḵ a’di gwo mo ki: Aha/ dina imahan mo. ");
INSERT INTO udu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","A’di ki o gwo mo ki: Hili mo mo ma, aha/ tana adhan mo dhali aha/ dinaki misha cim jwam pem mo. ");
INSERT INTO udu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hili shwane/ buthi to gi mo/as pini mo dhala kulp̱em pini dhala bwam pini mo dhali ya ka pije/ e mombwaasho mo dhali par tom bwaasho mo gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Dhali thosoni shum jin ’kunya’kuny gom aha/ mo, a’di jin enka/ mo dhali ḵali a’di ki aha/ ki aha/ mina shwa a’di mo dhali ’bor /e mii nṯwa/a/ ki aha/ dinaki wu mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Dhala Rip̱ka ciḵki gwo yan me’d jin okin ma Is/hak gwo e ya/m piti ka Iisu mo. Gom gwo gi wakan mo tani Iisu a’di yaki’d ka pije/ mo dhali par tombwaasho mo dhali ’koshi a’di mo dhali ḵali a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rip̱ka si’da/ oki ya/m piti ka Yakuub gwo mo ki: Aha/ ciḵkina ’twa/ mmoṯora/ ṯor ka kan ka Iisu mo, ki: ");
INSERT INTO udu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ḵalaa/ shum tombwaasho mo dhali thosoni shum jin ’kunya’kuny gom aha/ mo ki aha/ mina shwa a’di mo dhali ’bor /e mii mo mbwambor ki Tap̱a mo nṯwa/a/ ki aha/ dinaki wu mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hili mo mo ma, ya/m pem, hayi gwom pem e mo me’d jin ḵankika/ /e mo. ");
INSERT INTO udu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yaku/ e ma’diny ḵa’bal mo dhali kwanyi ushi guŋgulu mi isu/ mo ki aha/ mina thoson shum kun ’kunya’kuny ’peni uni mo gom cim mo a’di jin enkina a’di kagahara mo. ");
INSERT INTO udu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Dhali /e mini ḵalki a’di ki cim mo mmoshwa mo. Wakan ki a’di midi ’bor /e mii mo nṯwa/a/ ki a’di diki wu mo. ");
INSERT INTO udu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Hila Yakuub oki’da Rip̱ka jin ta kum gwo mo ki: Hili mo mo ma, akam pem ka Iisu a’di ta wathi/ jin ’kan ma muri is mo, dhali aha/ ’tiḵila/ buŋgwar ki ’tiḵil mo. ");
INSERT INTO udu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Wariba/ ababa midi tayaa/ is is ki me’d mo, dhali aha/ mina e waki aha/ miina a’di ka maḵ mo dhali aha/ mina ḵal monyjee ap̱o/ is pem mo, yisa mom’bor mii mo. ");
INSERT INTO udu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kum ki o a’di gwo mo ki: Monyjeem pini midi di ap̱o/ aha/ mo ya/m pem mo, hili hayi gwom pem e mo dhali yayi mo dhali kwanyi uni gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Gom gwo gi wakan mo tani a’di yaki’d mo dhali buthi uni mo dhali ’doyu/ uni ki kum mo, dhali kum ki thoson shum kun ’kunya’kuny mo, me’d jin enkina com kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Dhala Rip̱ka ki bu’th burrinyem ’borga/ ma Iisu jin ta ya/ ma yim jin ca’d mo uni kun ’koni gu’b nyaḵka yim mo a’di ki hi’thki a’di ka Yakuub mo a’di jin ta ya/m piti jin gwa’da’d mo. ");
INSERT INTO udu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Dhala yim ki hi’thki a’di ayi’c mi e ’bame’d piti mo dhali e ’bam piti jin ’tiḵila/ ’tiḵil mo. ");
INSERT INTO udu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Dhali ayim ki c̱i shum jin ’kunya’kuny mo dhali maaŋḵuthu’d mo a’di jin thosonkin ma yim mo e me’d gi ya/m piti ka Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Wakan a’di yaki’d bway gu’b gi com mo, dhali o a’di gwo mo ki: Ababam pema, dhali a’di ki thoḵ a’di gwo mo ki: Aha/ dina imahan mo. Ki /e aja a’dun mo? ya/m pem. ");
INSERT INTO udu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakuub oki com gwo mo ki: Aha/ tana Iisu jin ta’da bwanyaram pini mo. Aha/ miikina me’d jin ḵankina /e aha/ gwo mo dhali shwane/ c̱a’bi /e ki mis mo dhali ’kayi shum tombwaashom pem mo ki /e mini ’bor aha/ mii mo. ");
INSERT INTO udu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hila Is/hak oki ya/m piti gwo mo ki: Mii wakata ganne/ gamkina /e a’di ki jahanne/ kan mo? ya/m pem. A’di ki thoḵ gwo mo ki: Haali/ Tap̱a Arumgimis pini a’di c̱iki aha/ a’di ki ’ta’b kan mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yan’ko’d Is/hak ki owa Yakuub gwo mo ki: Shoru/ is ki ’dishe/ mo ki aha/ mina ta /e is is ki me’d mo ya/m pem mo ki aha/ mina mish /e mo waḵki/ /e tana Iisu ka jiŋ gana/ jin ta ya/m pem mo, walla aja a’dan mo? ");
INSERT INTO udu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Wakan aYakuub a’di yaki’d mo mmo’disha Is/hak is mo a’di jin ta com mo, a’di taki a’di is is ki me’d mo dhali o gwo mo ki: ’Twa/ a’di ita jim ma Yakuub mo, hili me’d uni ita me’d ma Iisu mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Dhali a’di diki nyiṯẖ a’di mo haali/ me’d piti ’kan ma mur nycine/ mo me’d ji ma kam piti ka Iisu mo, dhali gom gwo gi wakan mo tani a’di ki ’bor a’di mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A’di ki o gwo mo ki: A/e ta ya/m pem ka jiŋ gana/ mo jin ta’da Iisu mo? A’di ki thoḵ gwo mo ki: Aha/ tana a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Dhali yan’ko’d a’di ki o gwo mo ki: Ḵali a’di ki aha/ mo ki aha/ mina ’ka shum tombwaasho gi ya/m pem mo dhali ’bor /e mii mo. Wakan a’di ḵalki a’di a’di mo dhali a’di ’kaki a’di mo dhali a’di ḵalki a’di yimana mura’th jin ḵa/u ki ŋahŋah mo dhali a’di p̱iki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Dhali yan’ko’d com ka Is/hak ki o a’di gwo mo ki: Shoru/ is ki ’dishe/ mo dhali p̱iyaa/ ’twa/ mo ya/m pem mo. ");
INSERT INTO udu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Wakan a’di p̱u’dki’d ki ’dishe/ mo dhali p̱i a’di ’twa/ mo dhali a’di jiḵki’da shim burrinyem piti mo dhali ’bor a’di mii mo dhali o gwo mo ki: Hili yisawa/, ashim gi ya/m pem mo ma isi me’da shim gi wathi/ jin yayi’d ’pena pije/ mo, a’di jin ’borkina Tap̱a mii be. ");
INSERT INTO udu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dhala Arumgimis c̱i jap̱e/ gi momis mo, dhali aris tom ’boron gi mony’cesh mo, dhali pos mo dhala mura’th ki nyanye/ mo. ");
INSERT INTO udu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dhalka ris ’kwani ’baar mo mii /e to ime’d mo, dhali aris kal gi mony’cesh mina ’ko ka bamambor mmoluŋ /e mo. Tayi tap̱a ap̱o/ ikam pini mo dhali dhalki iya/in gi kwan mini ’ko ka bamambor mmoluŋ /e mo. Monyjee midi di ap̱o/ aris ’kwani ’baar ka ’deṯe/ ’deṯe/ kun jeeki /e mo, dhali mom’bor mii midi di ap̱o/ aris ’kwani ’baar mo kun ’borki /e mii mo. ");
INSERT INTO udu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Dhali ka Is/hak daḵa/ ’baarki mii i’dishesan mmo’bora Yakuub mii mo, ka Yakuub ’tilki is mo mmoya ka pije/ mo ’peni bwambor ma Is/hak mo jin ta com mo tani Iisu jin ta’da kam mo tani a’di p̱u’dki’d mo ’peni mompar mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A’di si’da/ thosonki shum jin ’kunya’kuny mo dhali ḵali a’di e com mo. Dhali a’di ki o com gwo mo ki: Dhalka baba cu mis mo dhali ’ka shum tombwaasho gi ya/m piti mo ki /e mini ’bor aha/ mii mo. ");
INSERT INTO udu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ababam piti ka Is/hak oki a’di gwo mo ki: Ki /e aja a’dun mo? A’di thoḵki gwo mo ki: Aha/ tana ya/m pini, jin ta’da bwanyara/ jin ta’da Iisu mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yan’ko’d a/Is/hak a’di dekina is ki bir bir ki ’bi’th mo, dhali o gwo mo ki: Kaja sa/ yaki’d mo mmopar mo dhali ’koshi tombwaasho mo dhali ḵali aha/ shum mo, dhali aha/ ’kakina a’di ’baar mo nṯwa/a/ ki /e diki p̱u’du/ mo dhali aha/ ’borkina a’di mii mo? Nye a’di minu mii ’bor mii mo. ");
INSERT INTO udu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ka Iisu ciḵki gwo ’peni com mo tani a’di ’therki dhan ko ki ’bi’th mo dhali ko ki jabu’th ki ḵu’bu/ ḵu’bu/ mo, dhali o com gwo mo ki: ’Bori aha/ mii mo ma, isi aha/ gara/ si’dayi, ayy ababam pem mo. ");
INSERT INTO udu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Hili a’di oki gwo mo ki: Akam pini a’di p̱u’dki’d ka maḵ mo, dhali a’di bu’thki mom’bor miim pini mo. ");
INSERT INTO udu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iisu oki gwo mo ki: A’di ’konuki yuḵ gway ka Yakuub ka jiŋ gana/ ’taa? Haali/ a’di thamki aha/ thum me’di su/ mo. A’di bu’thki mo ma bwanyaram pem jin taka/ mo, dhali hili mo mo ma, shwane/ a’di bu’thki mom’bor miim pem ’peni aha/ mo. Yan’ko’d a’di ki o gwo mo ki: A/mom’bor miiŋ kamu/ bunya/ dina /e ki ’tash ’twa/ mo gom aha/ mowa? ");
INSERT INTO udu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Is/hak ki thoḵa Iisu gwo mo ki: Hili mo mo ma aha/ karkina a’di mmota tap̱am pini mo, dhali aris ikam piti aha/ c̱ikina uni ki a’di mmota c̱iŋkina/ mo mmomii a’di i me’d mo dhali pos dhala mura’th kun sinu mo aha/ c̱ikina uni ki a’di mo mmocil mo. Kata beseene/ imiga/ mii gom /e ya/m pem mo? ");
INSERT INTO udu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iisu ki o com gwo mo ki: A/e taki jasi mom’bor mii ’deŋ gana/ kan niina? ababam pem mo. ’Bori aha/ mii mo ma, isi aha/ gara/ si’dayi, ayy ababam pem mo. Dhala Iisu c̱eki ’twam piti mo dhali ko mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Dhali yan’ko’d Is/hak jin ta’da babam piti thoḵki a’di gwo mo ki: Hili mo mo ma, /e mini si’d mo ’peni mony’cesh jin minu si to mo haali/ a’di ita mom pini jin mina /e c̱a’bi cine/ mo, dhali /e si’da/ mini si’d mo ’peni jap̱e/ gi momis e mo jin ḵa’dama/ ḵa’dam mo. ");
INSERT INTO udu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Shemen gandala turgam pini mo tani a’di imina /e ndi ki e mo be. Dhali /e mini miiya kan to mo, hili ki /e mini ḵwa/ is pini bwa mo tani /e ḵwa/ki dhaŋḵa’b tom’bam piti bwa mo ’peni ’bam pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Shwane/ Iisu shi/ki’da Yakuubi e mo gom mom’bor mii jin ’borkina com a’di mii mo, dhala Iisu oki gwo e is piti mo ki: Atee jin minu kowa ko goma babam pem a’di ’dishkina ’twa/ mo. Aha/ mina ’kosha kam pem ka Yakuub jwa mo ŋ’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Hili gwo gi Iisu a’di ṯorkunuwa Rip̱ka mo a’di jin ta’da bwanyara/ ma yim mo. Gom gwo gi wakan mo tani ayim hashki gwo mo mmoyuḵa Yakuub jin ta ari ya/ ma yim jin gwa’da’d mo, dhali o a’di gwo mo ki: Hili mo mo ma, akam pini ka Iisu a’di malaski is piti mo dhali thoson is mo mmo’kosh /e jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Dhali ’peni shwanesan mo, ya/m pem hayi gwo gi ’twam pem e mo, dhali cuyi mis dhali gusi pa mo a Laabaan mo a’di jin ta’da kam pem mo e Pan Haraan mo. ");
INSERT INTO udu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Dhali c̱a’bi /e e mun mo nyaḵki a’di ki ari mo mo ntaga nyor ma kan yan jin ’batha’ba’th mina she/ i’thup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ntaga nyor ma kan yan mina she/ i’thup̱ mo dhali a’di midi this to gwan e mo kun miikina /e mo. Yan’ko’d aha/ mina hash gwo mo dhali susi /e ka nyaŋ’ko’d ’peni mun mo. Goma tinta imiga/ this um isu/ e mo mmonṯal ’de/ ka cim ’de/ kan mo. ");
INSERT INTO udu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Yan’ko’d aRip̱ka ki owa Is/hak gwo mo ki: Aha/ ’baka/ mondiki/em pem e mo haali/ aris up̱ gi ’Kwani gi Pan Hiṯẖṯẖa mo. Waḵka Yakuub midi mash jan ’de/ ’peni up̱ gi Pan Hiṯẖṯẖa me’d uni up̱ gwansan kun ’kon e bampa/ yansan mo, dhali shim miim ’boro’da ta midi di gom mondiki/em pem mo? ");
INSERT INTO udu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Dhali yan’ko’d Is/hak yuḵki’da Yakuub mo dhali ’bor a’di mii mo dhali ḵan a’di gwo mo ki: /E mini dhalku/ ki mii masha ’boma kamu/ ’de/ ’peni ’Kwani gi Paŋ Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Cuyi mis mo dhali yayi mo e Pam P̱addaan/araam e gu’b ma Baṯu/iil jin ta’da baba gi kwan mo dhali butha ’bom ’peni mun mo jan ’de/ ’peni i’bwa/ ma Laabaan jin ta’da kam gi kwan mo. ");
INSERT INTO udu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Arumgimis jin Eḵa/ Eḵ mo ’borki /e mii mo dhali kar /e mmodho’th mo dhali mar /e amar is mo ki /e mini ta dhana buhany ’kwani mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Dhalki a’di c̱i mom’bor mii ma Ibrahiim ki /e mo dhali emen pini si’da/ mo ki /e mini bu’th bampa/ gwan kun takina /e ac̱a/ ap̱o/ mo a’di jin c̱ikin ma Arumgimis a/Ibrahiim mo. ");
INSERT INTO udu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Wakan Is/hak hashki’da Yakuub ’peni a’di mo dhali a’di yaki’d mo e Pam P̱addaan/araam mo eya Laabaan jin ta ya/ ma Baṯu/iil mo jin ta Wathi/ Araam a’di jin ta’da kam ma Rip̱ka mo a’di jin ta KoYakuub dhala Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Dhala Iisu me’d jin mishkina a’di ka Is/hak ’borki’da Yakuub mii mo dhali karki a’di ’pen mo e Pam P̱addaan/araam mo mmobutha ’bom ’peni mun mo tani dhali ki a’di ’borki a’di mii mo dhali ḵan a’di gwo mo ki: /E mini dhalku/ ki mash jan ’de/ ’peni up̱ ’Kwani Kanaan mo, ");
INSERT INTO udu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","dhali ka Yakuub haki gwo gi com e mo dhali kum mo dhali ya mo e Pam P̱addaan/araam mo. ");
INSERT INTO udu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Wakan Iisu p̱arki mo e mo ki up̱ gi ’Kwani gi Paŋ Kanaan ’koki ’bora Is/hak bwa mo a’di jin ta com mo. ");
INSERT INTO udu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Iisu a’di yaki’d mo eya Isma/iil mo dhali butha ’bom mo mmomar up̱a tiya kun takina a’di is mo a’di jin ta’da Mahlah jin ta ’bwa/ ma Isma/iil mo jin ta ya/ ma Ibrahiim mo a’di jin ta ’bwaham ma Nabayuut mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakuub dhalki Pam Birsaba ’pen mo dhali yaki’d mo ’kup̱ki bway Pan Haraan mo. ");
INSERT INTO udu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Dhali a’di p̱u’dki’d mo e moŋkamu/ mo dhali a’di c̱a’bki’d e mun mon’thiny mo haala tente/ yulki’d mo. A’di ki bu’th wosha kamu/ mo e mo yan mo mmokar ’kup̱ piti mo dhali a’di ki ishi mo yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Dhali a’di shu’bki jan mo ki to di’d jin karkunu mo ’peni mony’cesh mo jin senu sho’k mo dhali ’kup̱an piti jithirki momis mo dhali hili mo mo ma, iman’doyu gwo ma Arumgimis seki momisi a’di mo dhali thulkin ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Dhali hili mo mo ma, Tap̱a doshki’di ’kup̱i a’di mo dhali o gwo mo ki: Aha/ tana Tap̱a Arumgimis ma Ibrahiim jin ta’da babam pini mo dhali Arumgimis ma Is/hak mo. Mony’cesh yan jin isha /e ap̱o/ mo tani aha/ mina c̱i a’di ki /e mo dhali emen pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dhali emen pini uni mina e waki bu’da ’cesh mo dhali /e mini hakas mo ka bor mo ntaga bora luŋgu’b mo dhali ’kup̱ki mom’pesho’k mo dhali ’kup̱ka ’bana bim poros mo dhali ’kup̱ka ’bana biny cam mo, dhali ki /e mo dhali emen pini mo tani arisa waḵ gi ’kwaniny’cesh mini ’bor is buni mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Hili mo mo ma, aha/ mina di nyaḵki /e mo dhali kar /e mo eya ris mo gunn kun mina /e iya mo dhali susi /e ka nyaŋ’ko’d e bampa/ yansan mo. Haali/ aha/ yisa mina dhal /e ’pen yisa ntagi aha/ mina thim gwom pem jin okika/ /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yan’ko’d aYakuub merki e mo ’peni mo/ish em piti mo dhali o gwo mo ki: Ka jiŋ gana/ Tap̱a a’di idiki’d e mo yan mo dhali aha/ molkina a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Dhali a’di ḵo/ki is mo dhali o gwo mo ki: Mo yan ta mo jin ḵogu mo. Mo yan a’di ita isi gu’b ma Arumgimis gana/ mo ’tese/ be dhali yansan a’di ita ’twaŋkala goŋ gi bway momis mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wakan aYakuub cuki mis mo mon’thamo/ ka ’tum mo dhali bu’th wosh jin isha a’di ’ba/ mo dhali thum a’di ki mis mo mmota tiŋkiliŋ mo dhali wol a’di ayini ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A’di yuḵki mo c̱aan gway mo ka Beeṯ/iil mo, hili gway gi ’peŋkuman bampa/ yan mo tani a’di yuḵu iṯwa/a/ ka Luus mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yan’ko’d aYakuub thulki gwo me’da ap̱o/ mo mmo/o ki: Waḵki/ Arumgimis midi di e aha/ mo dhali kar aha/ e bway pem yan jin yaka/ iya mo dhali c̱iyaa/ tonṯe/ mmoshwa mo dhali burrinye/ mmohithi is mo, ");
INSERT INTO udu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","wakan ki aha/ mina doḵu/ bway pa e gu’b ma babam pem ki moŋḵu’th is mo tani yan’ko’d Tap̱a a’di imidi ta Arumgimis pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dhali wosh yan jin thumkika/ ki mis me’da tiŋkiliŋ mo tani a’di imidi ta gu’b ma Arumgimis mo dhali aris to ’baar mo kun mina /e c̱i aha/ mo tani aha/ mina bu’th jan ’de/ mo ’pena ’kume’d mo gom /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Dhala Yakuub yaki’d mo e bway piti mo ntagi a’di p̱u’dki’d mo e ’kwani gi bampa/ gi mom’pesho’k mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ki a’di hilki mo mo tani a’di p̱arki jis yi’de/ e mo e bwam bunto mo dhali hili mo mo ma, adhana ma’diny ḵa’bal ikwara kun ishkini shemen piti mo haali/ ’peni jis yi’de/ c̱aan mo tani ama’diny ḵa’bal wolkunu yi’de/ mo. Dhali wosh gi ’twaŋkal jis yi’de/ yan mo tani a’di caaca mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dhali ka ma’diny ḵa’bal tulkunu isi monṯal ’de/ imaṯṯaan mo tani imanhil ḵa’bal ki ’daŋkal wosh ’peni ’twaŋkal jis yi’de/ mo dhali wolki ḵa’bal yi’de/ mo dhali karki wosh ka nyaŋ’ko’d mo e mom piti mo e ’twaŋkal jis yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakuub ki o uni gwo mo ki: Ikam pema um iiyin ’peni mana mo? Uni ki thoḵ a’di gwo mo ki: ’Peni Pan Haraan mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A’di ki o uni gwo mo ki: A/um mishina Laabaan jin ta ya/ ma Nahur mowa? Uni ki thoḵ a’di gwo mo ki: Aman mishkina a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A’di ki o uni gwo mo ki: A/dhali a’di ’bora is mo ’te/ tana? Uni thoḵki a’di gwo mo ki: A’di ’bora is mo, dhali hili mo mo ma, aRahiil jin ta ’bwa/ p̱u’dki’d mo nyaḵki ḵa’bal mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A’di ki o gwo mo ki: Hili mo mo ma, atente/ caaca kagahara mo, a’di diki ta atente/ jin minu tul to/e isi monṯal ’de/ mo, woli ḵa’bal yi’de/ mo ma dhali iiku/ mo mmoc̱i uni ashon dhii/i’d mo. ");
INSERT INTO udu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Hili uni thoḵki a’di gwo mo ki: Aman mola mii ntaga ma’diny ḵa’bal minu tul isi ’baar mo imonṯal ’de/ mo dhali wosh si’da/ minu ’daŋkalu/ mo ’peni ’twaŋkal jis yi’de/ mo dhali yan’ko’d aman ki wol ḵa’bal yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ki a’di mal ma ṯor mmoṯor ki uni mo tani Rahiil p̱u’dki’d mo nyaḵki ḵa’bal gi com haala yim a’di ita’da manhil uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Dhali ka Yakuub p̱arki’da Rahiil e mo a’di jin ta ’bwa/ ma Laabaan jin ta’da kam gi kum mo dhali ḵa’bal ma Laabaan jin ta’da kam gi kum mo tani Yakuub seki mis mo dhali ’daŋkal wosh mo ’peni ’twaŋkal jis yi’de/ mo dhali wolka ma’diny ḵa’bal ma Laabaan yi’de/ mo a’di jin ta’da kam gi kum mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Dhali yan’ko’d a’di p̱iki’da Rahiil ’twa/ mo dhali ’ther dhan ko kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Dhala Yakuub ṯorki’da Rahiil gwo mo ki a’di ta’da bas gi com mo dhali a’di si’da/ ta ya/ ma Rip̱ka mo, dhali ayim guski’d mo dhali ṯor com gwo mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ka Laabaan ciḵki gwom ’borga/ goma Yakuub jin ta ya/ gi ’bwaham mo tani a’di guski’d mo mmogam a’di ’kup̱ mo dhali kar a’di mmota isa kony mo dhali p̱i a’di ’twa/ mo dhali susi a’di bway gu’b piti mo. AYakuub ṯorki’da Laabaan aris to gwansani ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Dhali aLaabaan ki o a’di gwo mo ki: Ka jiŋ gana/ /e tana simam pem mo dhali buŋgwar is pem mo. Dhali a’di c̱a’bki’d nyaḵki a’di ka appe i’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Dhali yan’ko’da Laabaan ki owa Yakuub gwo mo ki: Haali/ /e tana bas pem mo tani a’di ’boro’da jin mina /e imii aha/ aṯu’c ki me’d mowa? Ṯoraa/ gwo mo gom tom pini jin mina /e gam ki ji gi mina /e ta mo tani midi ta atinta mo? ");
INSERT INTO udu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Dhala Laabaan a’di ita gi i’bwa/i su/ mo: gway gi ’bwa/ jin ca’d mo tani a’di iyuḵu ka Le/ah mo dhali gway gi ’bwa/ jin gwa’da’d mo tani a’di iyuḵu ka Rahiil mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","E ma Le/ah mol mo hil ki ’bore/ mo haali/ em piti ’cwara’cwar mo, hila Rahiil a’di ta jaroŋ gana/ mo dhali enu kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakuub enki’da Rahiil mo dhali a’di ki o gwo mo ki: Aha/ mina mii /e aṯu’c ki yili pesu/ mo gom ’bwa/m pini jin ta’da Rahiil jin gwa’da’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabaan ki o gwo mo ki: A’di ’boro’d ki ’bor gana/ mo gom aha/ mo mmoc̱iki /e a’di mo, ma mo diki c̱i a’di ’kwanin tiya mo, c̱a’bi /e nyaḵki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wakana Yakuub miiki’da ṯu’c ki yili pesu/ goma Rahiil mo dhali uni wana mo i e ka cim midi diki ta rash rash gom mo/en jin enkina a’di ayim mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yan’ko’da Yakuub oki’da Laabaan gwo mo ki: C̱iyaa/ a’bom pem mo ki aha/ mina ya ayim mo haali/ mom pem ’baarki’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Wakan aLaabaan tulki’da aris ’kwani gi mo c̱aan isi monṯal ’de/ mo dhali shwa to jin yuḵuwa yuḵ ka tul ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Hili mom’pimpili/ mo tani a’di ki bu’th ’bwa/ ka Le/ah dhali suski a’di aYakuub mo dhali a’di yaki’da yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laabaan c̱iki nyarany c̱iŋkinam piti jin ta’da Silp̱ah e ’bwa/m piti ka Le/ah mo mmota c̱iŋkina/ nyara/ ma yim mo.) ");
INSERT INTO udu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Dhali e mon’thamo/ mo tani hili mo mo ma, aLe/ah ayim ta a’di jin c̱ikunu a’di mo dhala Yakuub ki owa Laabaan gwo mo ki: Dika/ ki miiki /e aṯu’c goma Rahiil mo ’taa? Atinta he’kkina /e aha/ e wakan mo. ");
INSERT INTO udu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabaan ki thoḵ a’di gwo mo ki: A’di yisa miinu wakana e bampam bam mo mmoc̱i jiŋ gwa’da’d nṯwa/a/ mmodhal a’di ma bwanyara/ i’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Thimi adhas nyaḵki jan ’de/ yan mo dhali aman mina c̱i /e jaŋ kamu/ si’da/ mo e mii jin mina /e doḵ/e doḵ sho’k mmomii aha/ to ki yili pesuŋ kamu/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakuub miiki’d kan mo dhali a’di ’baarki’da dhas ’de/ mo. Yan’ko’da Laabaan c̱iki a’di ’bwa/ ka Rahiil mo mmota ash mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laabaan c̱iki c̱iŋkina/ nyaram piti ka Bilhah ki ’bwa/ ka Rahiil mo mmota c̱iŋkina/ nyara/ ma yim mo.) ");
INSERT INTO udu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Wakan aYakuub yaki’d mo eya Rahiil mo si’da/ dhali a’di enki’da Rahiil mmobola Le/ah e mo, dhali a’di miiki’da Laabaan aṯu’c mo gom yili pesuŋ kamu/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ki Tap̱a p̱arki mo e ka Le/ah shi/kunu i e mo tani a’di ḵa’dki’da yim bwama dho’th piti ’twa/ mo, hila Rahiil a’di ta’da burum mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Dhali aLe/ah a’di bwaaki’d mo dhali dho’th ya/ mo dhala yim ki yuḵ a’di gway ka Ra/ubiin mo haala yim oki gwo mo ki: Haali/ Tap̱a hilki’d ap̱o/ to kun wo’cki aha/ is she/ mo, shwane/ akaṯẖim pem midi en aha/ ka jiŋ gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ayim a’di bwaaki’d doḵ/e mo dhali dho’th ya/ mo dhali o gwo mo ki: Haali/ Tap̱a a’di iciḵki gwo mo ki aha/ shi/kunu i e mo, a’di si’da/ ic̱ikina a’di aha/ ya/m pem yan mo dhala yim yuḵki a’di gway ka Shim/uun mo. ");
INSERT INTO udu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Doḵ/e ayim bwaaki’d mo dhali dho’th ya/ mo dhali o gwo mo ki: Shwanesan mo akaṯẖim pem midi gam is piti me’d ki aha/ mo haali/ aha/ dho’thkina a’di uc̱iŋgwaṯẖi kwara mo. Gom gwo gi wakan mo tani a’di iyuḵkunu a’di gway ka Lawi mo. ");
INSERT INTO udu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Dhali ayim bwaaki’d doḵ/e mo dhali dho’th ya/ mo dhali o gwo mo ki: Aha/ mina maŋ Tap̱a mo ganne/ mo. Gom gwo gi wakan mo tani a’di iyuḵkunu a’di gway piti ka Yahuuda mo, dhali yan’ko’da yim daḵki’da dho’th mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ka Rahiil p̱arki e mo ka yim diki dho’thka Yakuub uc̱i mo tani ayim taki dhap̱an ap̱o/ ’bwaham mo dhali ayim owa Yakuub gwo mo ki: C̱iyaa/ uc̱i mo ma walla aha/ mina wu mo ’te/ ba/. ");
INSERT INTO udu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Anyor ma Yakuub a’di ’thakunu ap̱owa Rahiil ki ’bi’th mo dhali a’di ki o gwo mo ki: Aha/ dina e embul ma Arumgimis mo a’di jin ’tashki bwama dho’th pini ’twa/ mo mmoḵal mamana dho’th mowa? ");
INSERT INTO udu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Yan’ko’da yim ki o gwo mo ki: Bilhah jin ta nyarany c̱iŋkinam pem di’d imahan mo. /E mini ya ayim mo ka yim midi ta gi uc̱i e ’kup̱a’dup̱un pem mo dhali aha/ mina ta gi uc̱i ka yim si’da/ moyi. ");
INSERT INTO udu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Wakan ayim c̱iki a’di aBilhah jin ta nyara/ c̱iŋkinam piti mo mmota ash mo dhali aYakuub a’di yaki’da yim mo. ");
INSERT INTO udu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Dhala Bilhah a’di bwaaki’d mo dhali dho’thka Yakuub ya/ mo. ");
INSERT INTO udu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Dhali yan’ko’d Rahiil ki o gwo mo ki: Arumgimis dwallki aha/ gwo mo dhali a’di si’da/ ciḵki aha/ ’twa/ mo dhali c̱iki aha/ ya/m mo. Gom gwo gi wakan mo tani ayim ki yuḵ a’di gway mo ka Daan mo. ");
INSERT INTO udu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nyara/ c̱iŋkina/ ma Rahiil a’di bwaaki’d doḵ/e mo dhali dho’thka Yakuub ya/ jin ’kon ma p̱o/ isu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Dhali yan’ko’d Rahiil oki gwo mo ki: Ki mon’thir jin c̱a’bki dem dem mo tani a’di i’thirkika/ ’bwah pem mo dhali p̱i gwo jip̱i/ mo. Gom gwo gi wakan mo tani ayim ki yuḵ a’di gway mo ka Nap̱taali mo. ");
INSERT INTO udu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ka Le/ah p̱arki mo e mo ki a’di daḵki’da dho’th mo tani ayim ki bu’th c̱iŋkina/ nyaram piti jin ta’da Silp̱ah mo mmoc̱iki a’di ka Yakuub mo mmota ash mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Yan’ko’d c̱iŋkina/ nyara/ ma Le/ah a’di dho’thki’da Yakuub ya/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Dhala Le/ah ki o gwo mo ki: Mo i e ki ’bor mo, wakan ayim ki yuḵ a’di gway mo ka Jaad mo. ");
INSERT INTO udu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","C̱iŋkina/ nyara/ ma Le/ah a’di jin ta’da Silp̱ah mo dho’thki’da Yakuub ya/ jin ’kon ma p̱o/i su/ mo. ");
INSERT INTO udu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Dhala Le/ah ki o gwo mo ki: Aha/ be i’bora bwa mo, haali/ aris up̱i ’baar mo mini yuḵ aha/ gway ki ji gi ’bora bwa mo, wakan ayim yuḵki a’di gway mo ka Ashiir mo. ");
INSERT INTO udu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ka tee jin ’ciṯẖkunu pos bunycan mo tani aRa/ubiin a’di yaki’d mo dhali gam mamana kamu/ e bunto mo (a’di jin yuḵu ki ’twa/ ma Arab ka lup̱p̱aah mo). Dhali a’di ki ḵalki uni kum ka Le/ah mo. Dhali yan’ko’da Rahiil o gwo mo ki: C̱iyaa/ mo ma, aha/ ’thona /e maman cwa ma lup̱p̱aah jin ḵalkina ya/m pini mo. ");
INSERT INTO udu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Hila yim ki thoḵa yim gwo mo ki: A/a’di ta ari mii jin gwa’dagwa’d mo mmobutha kaṯẖim pem mo ’peni aha/ mo ’taa? Dhali /e ki doḵ/e o gwo mo ki /e mini ḵal maman cwa ma lup̱p̱aah jin ḵalkina ya/m pem ’te/ si’dawa? Rahiil ki thoḵa yim gwo mo ki: Ba a’di be midi ya ishi /e mon’thiny shwane/ mo gom maman cwa ma lup̱p̱aah jin ḵalina ya/m pini mo ’te/ be. ");
INSERT INTO udu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ka Yakuub p̱u’dki’d mo ’peni bunto mom’pimpili/ mo tani aLe/ah yaki’d ka pije/ mo mmogam a’di ’kup̱ mo, dhali o a’di gwo mo ki: /E mini mii yayu/ aha/ shwane/ mo haali/ aha/ yolkina /e mo ki maman cwa ma lup̱p̱aah jin ta jim ma ya/m pem mo. Wakan a’di ishki’d nyaḵka yim mon’thiny c̱aan mo. ");
INSERT INTO udu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dhali Arumgimis ciḵki gwo ma Le/ah mo dhala yim bwaaki’d mo dhali dho’thka Yakuub ya/ jin ’kon ma p̱o/ imudhe’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Le/ah ki o gwo mo ki: Arumgimis c̱iki aha/ tom pem jin karka/ ka bara ṯu’c mo haali/ aha/ c̱ikina c̱iŋkina/ nyaram pem ka kaṯẖim pem mo. Wakana yim ki yuḵ a’di gway ka Yassaakar mo. ");
INSERT INTO udu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Dhali aLe/ah a’di bwaaki’d mo doḵ/e dhala yim dho’thki’da Yakuub ya/ jin ’kon ma p̱o/i pe’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Dhali yan’ko’da Le/ah ki o gwo mo ki: Arumgimis a’di tashaa/ ki tom ’boro’d jin ḵamu/ aḵam mo. Shwane/ akaṯẖim pem midi taḵ aha/ mo haali/ aha/ dho’thkina a’di iya/ kun ’kon ma p̱o/ ipe’de/ mo. Wakan ayim ki yuḵ a’di gway mo ka Sabuluun mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Yan’ko’da yim dho’thki ’bwa/ mo dhali yuḵa yim gway mo ka Diinah mo. ");
INSERT INTO udu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Dhali yan’ko’da Arumgimis si’da/ kaki’da Rahiil e mo dhali Arumgimis ciḵki’da yim gwo mo dhali ḵa’dka yim bwa ma dho’th piti ’twa/. ");
INSERT INTO udu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ayim bwaaki’d mo dhali dho’th ya/ mo dhali o gwo mo ki: Arumgimis ḵalki mowaḵ pem sho’k ka pije/ mo. ");
INSERT INTO udu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Dhala yim ki yuḵ a’di gway ka Yuusup̱ mo mmo/o gwo mo ki: Dhalka Arumgimis maraa/ ya/a kamu/ is mo. ");
INSERT INTO udu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ka Rahiil dho’thki’da Yuusup̱ mo tani aYakuub oki’da Laabaan gwo mo ki: Karki aha/ ’pen mo ki aha/ mina ya mo e gu’b pem mo dhali e bampam pem mo. ");
INSERT INTO udu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","C̱iyaa/ up̱ pem mo dhali uc̱im pem mo uni kun miikika/ /e aṯu’c mo dhali dhalkaa/ bway ayana mo haali/ /e mishkina ṯu’c kun miikika/ /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Hila Laabaan o a’di gwo mo ki: Waḵki/ /e mini dhalaa/ bway mmo/o gwo gi wakan mo si’da/ tani aha/ da/arkina gwo mo ki to jin mishu ki jamas mii mo tani Tap̱a a’di ’borki aha/ mii gom /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Yeri to gway mo, uni kun gamu ki ji gi miinu to mo dhali aha/ mina c̱iki /e uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","AYakuub ki o a’di gwo mo ki: /E ki is pini mishi to kun miikika/ /e aṯu’c mo dhali aris to/em pini ’ko /e ki ’kom pa mo gom mo jin hilka/ uni ki ’bore/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Haali/ /e tan jasi ushi’ceenne/ kagush mo nṯwa/a/ ki aha/ dina ki p̱u’du/ mo dhali shwane/ uni markunu is ka enthus mo dhali Tap̱a ’borki /e mii eya ris mo gunn kun ṯu’kka/ mo. Hili dhali aha/ kakasja si’da/ miga/ mii thoson to gom ku gi gu’b pem mo? ");
INSERT INTO udu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","A’di ki o gwo mo ki: Atinta a’di imiga/ c̱i /e mo? AYakuub o gwo mo ki: /E mini c̱i aha/ toŋ kamu/ yisa. Waḵki/ /e mini mii to yan gom aha/ mo aha/ mina doḵ/e c̱i ama’diny ḵa’bal pini ashon dhii/i’d mo dhali ta amandhu uni mo. ");
INSERT INTO udu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Dhalki aha/ yana e bwaman ma arisa ma’diny ḵa’bal pini ki tur mo shwane/ mmoḵwa/ ’peni arisa unycur dhali adhudhunyaŋ ḵa’bal dhali ḵa’bal ’thi/ ka ris mo dhali ’peni arisa dhudhunya/ min ’thi/ mo dhali arisa unycur mi mo, dhali uni gi wakan mo tani uni be ita tom pem jin gamka/ ki ji gi miinu to mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Dhali gom gwom pem ji wakan mo jin oka/ ki o ma teṯe/ mo tani /e mini thoḵ gwo gom aha/ yilaŋkamu/ i’ko’d mo ki /e mini p̱u’du/ mo, dhali p̱ara ris tom pem jin miga/ gam ki ji gi miinu to inyaḵki /e mo. Aris uni kun tana unycur dhali gun tana dhudhunya/ mi dhali ḵa’bal ’thi/ waḵki/ gamu mo tani uni minu deŋ e oki kuki ḵwalu mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabaan ki o gwo mo ki: ’Boro’d be, dhalki a’di gi wakan mo me’d jin ona /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Hili ’peni acim c̱aan mo tani a’di ḵwa/ki’da aris gwaṯẖi mi bwa mo uni kun tana ’beres is mo dhala dhudhunya/ mo dhali aris kuman mi kun tana unycur mo dhali ḵan iya/ gwo mo mmoji uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Dhali a’di hashki uni mmo/ii mo si’dasi’d ka cim kwara mo ’peni bwaman a’di ki is piti mo dhala Yakuub mo. Dhala Yakuub dhuki kun tiya mo uni kun tana ma’diny ḵa’bal ma Laabaan mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Dhali yan’ko’da Yakuub ḵwa/ki’da biny cwan this jin ’ta’dama’ta’dam mo dhali ’ciṯẖ uni mo dhali thoson uni mo dhali ’ce cwa is mo mmotagi kush mo mmoṯor gulu’c cwaŋkush gwan eya tente/ mo. ");
INSERT INTO udu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A’di dhuki cwaŋkush gwan jin ’cena a’di is mbwambor ma ma’diny ḵa’bal mo eya al yi’de/ mo jin wolkunu uni yi’de/ ka ḵur mo e mo jin p̱u’dkin ma ma’diny ḵa’bal mo mmop̱i yi’de/ mo. Dhali me’d jin merkina uni mo mmomash mo tani uni p̱u’dkin mmop̱i yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Dhali ama’diny ḵa’bal merkin mo dhali mash mo mbwambor cwa gwan jin ’cena a’di is mo dhali wakan ama’diny dho’thki ushan kun ’beresa is ki ’beres mo dhali tana unycur mo dhali kun tana dhudhunya/ mo. ");
INSERT INTO udu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Dhala Yakuub ḵwa/ki ḵa’bal bwa mo dhali kar jis/em piti ’kup̱ki ḵa’bal kun ’beresa is ki ’beres mo dhali dhalki ḵa’bal ’thi/ e bwamana ma’diny ḵa’bal ma Laabaan mo dhali a’di ki dhu kum piti kun ura a’di ki she/ mo dhali diki gam uni me’d ka ma’diny kuma Laabaan mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","E bwaman ḵa’bal kun ’bitha is ki ’bi’th mo mmodho’th mo tani aYakuub ki gu cwa mo dhali dhu uni eya al yi’de/ mo mbwambori jis/e ma ma’diny ḵa’bal mo ki uni mini mer mo dhali mash mo e bwaman cwa su/ gwan mo. ");
INSERT INTO udu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Hili e ḵa’bal kun ’ka’da is ki ’ka’d mo tani a’di diki dhu cwa gwan imun mo wakan uni gwan kun ta ḵa’bal kun ’ka’da is mo tani uni kuma Laabaan mo dhali kun ’bitha is ki ’bi’th gwan mo tani uni ta kuma Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ki mii wakan mo tani wathi/ ta pa mo ijasa/? dhali a’di taki’d ka ma’diny ḵa’bal jin caaca mo dhali up̱ piti si’da/ takin gi up̱ c̱iŋkina/ ka ris mo kun mii uni to ime’d mo dhali ’kwaniŋ gwaṯẖ tana ris kun ta c̱iŋkinam piti mo kun mii a’di to ime’d mo dhali aris kalman mo dhali aris thuluny mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Dhala Yakuub ciḵki gwo jin ’kokina iya/ ma Laabaan mmo/o mo ki: AYakuub a’di bu’thki’da ris to ’baar mo kun ta kuma babam bana mo, dhali ’peni kuma babam bana mo tani a’di igamkina a’di mii adu is mmota pa ki pa kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Dhala Yakuub si’da/ mishki mo mo ka Laabaan diki hil a’di i e ki ’bore/ ki hila ’the mo me’d jin ṯwa/a/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Dhali yan’ko’d Tap̱a ki owa Yakuub gwo mo ki: Doḵi /e eya ’cesh gi ibabam pini ka nyaŋ’ko’d mo dhali e ’kwani ma bas pini mo dhali aha/ mina di e /e mo. ");
INSERT INTO udu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gom gwo gi wakan mo tani aYakuub hashki gwo eya Rahiil dhala Le/ah e mombwaasho jin ’kona ma’diny ḵa’bal piti mo. ");
INSERT INTO udu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Dhali a’di ki o uni gwo mo ki: Aha/ misha ka babam bum diki hil aha/ i e ki ’bore/ ki hila ’the mo me’d jin ṯwa/a/ mo. Hili Arumgimis ma babam pem a’di nyaḵki di ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Um mishkin ki aha/ miikina ababam bum aṯu’c ki mom’bi’th pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Dhali hili ababam bum a’di di’d mmohe’k aha/ e mo dhali aḵ tom pem e mo jin gamka/ ki ji gi miiga/ to mo me’di ’kume’d mo. Hili Arumgimis diki dhal a’di bway mo mmo’kosh aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","A’di oki gwo mo ki: Waḵki/ min dhudhunya/ mini dho’th mo tani uni a’di imini ta kum pini mo kun mina /e igam ki ji gi miina /e to mo, dhali arisa ma’diny uni ka jiŋ gana/ uni idho’thkina dhudhunya/ mi mo. Dhali yan’ko’d doḵ/e a’di ki o gwo mo ki: Waḵki/ mi kun ’beresa is ki ’beres mini ’ko mo tani uni a’di imini ta kum pini kun mina /e igam mo ki ji gi miina /e to mo, dhali arisa ma’diny uni ka jiŋ gana/ uni idho’thkina ’beres is mi mo. ");
INSERT INTO udu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Gom gwo gi wakan mo tani a’di ibu’thkin ma Arumgimis to/e ma babam bum mo dhali c̱i uni ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Dhali yil kun bwan ma ma’diny ḵa’bal dhali mi mo tani aha/ ’de’kkina em pem ’kup̱ki mo momis mo dhali mish to ki jan mo ka ris gwasi mi ji kun p̱ekina jap̱p̱a/ ap̱o/ ma’diny ḵa’bal mo tani uni tana dhudhunya/ mo dhali uni ’beresa is ki ’beres mo dhali uni itana diŋdiŋ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dhali yan’ko’d aman’doyu gwo gi Tap̱a o aha/ gwo ki jan mo ki: Yakuub, dhali aha/ ki thoḵ a’di gwo mo ki: Aha/ dina imahan mo. ");
INSERT INTO udu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Dhali a’di ki o aha/ gwo mo ki: ’Deki em pini ’kup̱ki mo momis mo dhali p̱ari mo e mo, aris mi kun p̱ena jap̱p̱a/ ap̱o/ ama’diny ḵa’bal mo tani uni ’beresa is ki ’beres mo dhali uni tana dhudhunya/ mo dhali uni tana diŋdiŋ mo haali/ aha/ mishkina ris to kun miikin ma Laabaan ap̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Aha/ tana Arumgimis ma Beeṯ/iil e mo jin wolkina /e ayini ’kuwosh jin karkina /e ka tiŋkiliŋ mo dhali /e ki thul gwo me’da p̱o/ gom aha/ mo. Cuyi mis shwane/ mo ’peni bampa/ yan mo dhali doḵi /e ka nyaŋ’ko’d e bampam pini jin dhothu /e mo. ");
INSERT INTO udu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yan’ko’da Rahiil dhala Le/ah thoḵki a’di gwo mo ki: A/toŋ kamu/ di’d jin ’tuntulkunu bwa ime’d mo walla mala kamu/ dhalkunu aman e gu’b ma babam bam mowa? ");
INSERT INTO udu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aman shwane/ dina a’di ki yuḵ ki bunycan paŋ ’kwanin tiya mowa? Haali/ a’di yolki aman mo dhali a’di ’baarki’da guurush jin c̱ikunu a’di gom aman mo. ");
INSERT INTO udu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Aris mal kun bu’thkin ma Arumgimis mo ’pena babam bam mo tani uni ta kum bam mo dhali kuki uc̱im bam mo. Hili shwane/ aris gwo gunn kun min ma Arumgimis i o /e mo tani miiyi uni mo ma. ");
INSERT INTO udu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Wakan aYakuub cuki mis mo dhali dhu iya/ dhali i/ash e kalman mo. ");
INSERT INTO udu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Dhali a’di dilki’da ris to/em piti sho’k mo, aris mal piti kun gamkina a’di adu is ki mii jin miikina a’di to mo, to/em piti kun tulkina a’di is mo e Pam P̱addaan/araam mo mmo/ii mo e bampa/ gi Paŋ Kanaan eya babam piti ka Is/hak mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Dhali ka cim c̱aan mo tani aLaabaan a’di yaki’d mo mmo’ciṯẖ ḵa’bal piti amur mo dhala Rahiil a’di ḵwalki tomp̱inycon gi gu’b gi com mo. ");
INSERT INTO udu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Dhala Yakuub shakalki’d mo ki e ka wu mo i’ko’da Laabaan jin ta wathi/ Araam mo mmodiki ṯor a’di gwo ki a’di murki’di gus mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A’di guski’d mo nyaḵki aris to kun tana a’di mo dhali cu mis mo mmo’ciṯẖ Yi’deŋ Ḵumma/ Elp̱uraat mo dhali a’di c̱u’thki jis/em piti ’kup̱ki bampa/ gi paŋ ’kuwosh e Pany Jil/aad mo. ");
INSERT INTO udu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Dhali yan’ko’d gwo ṯorkunuwa Laabaan ’ko’da cim kwara mo ka Yakuub guski’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","A’di bu’thki ’kwani ma bas piti nyaḵki a’di mo dhali ur a’di isho’k ka cim pesu/ mo dhali baṯẖ a’di isho’k ki ya’th ya’th mo e bampa/ gi Pany Jil/aad mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Hili Arumgimis p̱u’dki’da Laabaan mo a’di jin ta wathi/ Araam ki jan mo mon’thiny mo dhali o a’di gwo mo ki: ’Cunycuri is pini ki ’bore/ mo ki /e mini diki o gwon ṯal ’deŋ kamu/ ka Yakuub mo walla ki gwom ’boro’d mo walla ki gwo shiyi’d mo. ");
INSERT INTO udu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Dhali aLaabaan gamki’da Yakuub mo. Dhala Yakuub a’di thumki gu’b burrinyem piti e bampa/ gi paŋ ’kuwosh mo dhali aLaabaan nyaḵki ’kwani ma bas piti mo tani uni ishkina yuuka/ mo e paŋ ’kuwosh gi Pany Jil/aad mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Dhali aLaabaan ki owa Yakuub gwo mo ki: Atinta si’da/ imiikina /e mo mmoḵwal aha/ to mo kan mo dhali bor i’bwa/m pem mo me’d ’kwani kun bu’thkunu ki shemen gandala turga/ e mo wakan gomata mo? ");
INSERT INTO udu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Gomata iguskina /e ka ḵwal is mo dhali ḵwal aha/ to mo dhali ilu/ diki ṯor aha/ gwo mo, wakan ki aha/ mina ’taki karki /e ’pen ki bwaŋ ’kunyu’d mo dhali ki gway jin yuḵu mo ka danluuka kun doru ki me’d mo dhali ka dheŋdhenye/ kun ’kon ma shu/i pesu/ mo? ");
INSERT INTO udu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Dhali atinta dina /e ki dhalaa/ bway mo mmop̱i iya/m pem dhali i’bwa/m pem ’twa/ mo dhali o uni gwo mo ki: Iiku/ ki ’bore/ ibway mo. Shwane/ /e mii miimp̱us mo. ");
INSERT INTO udu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","A’di ta mom’bi’th pem mo mmo’kosh /e jwa mo shwanetan, hili Arumgimis ma babam pini a’di ṯorki aha/ gwo ki jan ka en’thiny mo mmo/o gwo mo ki: ’Cunycuri is pini ki ’bore/ mo ki /e mini diki o gwon ṯal ’deŋ kamu/ ka Yakuub mo walla ki gwom ’boro’d mo walla ki gwo shiyi’d mo. ");
INSERT INTO udu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Shwane/ /e yakin mo haali/ /e ’kosha dhan ṯem pa kagahara gom gu’b gi cim mo, hili atinta si’da/ iḵwalkina /e tomp̱inycon pem mo? ");
INSERT INTO udu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","AYakuub thoḵki’da Laabaan gwo mo ki: Haali/ aha/ ḵo/kina is mo haali/ aha/ kulumkina gwo ibwa mo oki /e mini bu’th i’bwa/ yin ki ’bi’th ’peni aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","E a’din ’de/ yin jin mina /e gam tomp̱inycon pini nycine/ mo tani midi diki di ki e mo. E buŋ’kus ’kwani ma bas bana mo tani ṯori to e ki me’d mo uni kun ta kum pini kun bu’thka/ mo dhali ḵali uni mo. Dhala Yakuub yisa mishi gwo ’bana kamu/ mo ka Rahiil a’di iḵwalki uni mo. ");
INSERT INTO udu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Wakan aLaabaan cic̱ki gu’b burrinye/ ma Yakuub mo dhali gu’b burrinye/ ma Le/ah mo dhali gu’b burrinye/ gi up̱ c̱iŋkina/ su/ gi i’bwah mo, hili a’di diki gam uni mo. Dhali a’di yaki’d ka pije/ mo ’peni gu’b burrinye/ ma Le/ah mo dhali cic̱ jima Rahiil mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Dhali aRahiil a’di ka jiŋ gana/ iḵwalki tomp̱inycon gi gu’b gi com mo dhali dhu uni ap̱oŋ kalman e bwam ma ras mo dhali c̱a’bi uni ’pena p̱o/ mo. Laabaan a’di kulki’da ris gu’b burrinye/ ’baar mo dhali diki gam uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Dhali ayim ki o com gwo mo ki: Tap̱am pem midi mii dhalka nyor ki mii shwa mo haali/ aha/ mola cu ibwambori /e mo haali/ bway gi up̱ mo tani a’di di’da p̱o/ aha/ mo. Wakan a’di ŋap̱ki’da ŋap̱ ki bur bur mo hili a’di diki gam tomp̱inycon gi gu’b piti mo. ");
INSERT INTO udu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Dhali yan’ko’da Yakuub warki’d ki dhana nyor jin caaca mo dhali waḵa Laabaan mo. Yakuub oki’da Laabaan gwo mo ki: Tom pem jin thamka/ mane si’da/ ti dhali mane miinthus pem mo? jin urkina /e aha/ isho’k ki ’bar ’bar mo kan? ");
INSERT INTO udu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ba /e ŋap̱ki bwan tom pem mo ki bur bur mo. Aris uni ’baar mo kun gamkina /e mo tani uni ta ku ki gu’b piniya? Dhu uni imahan mo ibwambori ’kwani ma bas pem mo dhali ’kwani ma bas pini mo ki uni mini ’cunycur to mo e bwaman ana su/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yil ’koni iss ’de/ kun nyaḵka/ c̱a’b ki /e mo. Aris gwasiŋ ḵa’bal pini dhali kuman ḵa’bal uni thamka/ hil yisa dhali aha/ si’da/ dinaki ’ka jan ṯal ’deŋ kamu/ mo ’pena ma’diny ḵa’bal pini mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Uni kun dhera toŋgwap̱i/ is ka gwapi/ mo tani uni ’koka/ ḵali /e mowa? Aha/ thiskina is ’ko’d e mo gom uni mo dhali e ’peni bwam me’d pem mo tani /e ki ’theḵ gwo mo gom uni mo waḵki/ uni ḵwalu montee mo walla mon’thiny mo. ");
INSERT INTO udu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aha/ a’dan be montee jin ’ba’th ma tente/ mmoshilaa/ is mo dhali ’thama ’thup̱ga/ mo mon’thiny mo dhali e ish em pem mo tani a’di guski’d mo ’peni em pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yil ’koni issu/ jin nyaḵka di ki e e gu’b pini mo, dhali aha/ miikina /eya ṯu’c ki yili ’kume’d i’ce’dka doŋon mo gom i’bwa/m pini su/ gwan mo, dhali yili pe’de/ si’da/ goma ma’diny ḵa’bal pini mo dhali /e aḵki tom pem e me’di ’kume’d mo uni kun gamka/ ki ji gi miinu to mo. ");
INSERT INTO udu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Waḵki/ a’di midi ’taki diki ta Arumgimis ma babam pem mo a’di jin ta’da Arumgimis ma Ibrahiim mo dhali a’di jin ḵo/kin ma Is/hak mo waḵki/ a’diŋ gana/ yan midi ’taki diki di ka ’ban pem mo tani /e ka jiŋ gana/ mini ’taki hash aha/ mo me’d ’teŋ gana/ mo. Arumgimis mishki isa nyor pem jin wo’c aha/ she/ mo dhala ṯu’c gi me’d pem mo dhali ḵucur /e ka en’thiny mo. ");
INSERT INTO udu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Dhali yan’ko’da Laabaan thoḵki’da Yakuub gwo mo ki: I’bwa/m gwan mo tani uni ita i’bwa/m pem mo dhali uc̱i gwan mo tani uni ita uc̱im pem mo dhali ama’diny ḵa’bal gwan mo tani uni itana ma’diny pem mo dhali aris to kun p̱arkina /e e mo tani uni ta kum pem mo be. Hili ata a’di imiga/ mii shwane/ mo gom i’bwa/m pem gwan mo walla gom uc̱i gwansan kun dho’thkina uni mo? ");
INSERT INTO udu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yayo/ shwane/ mo dhali dhalki ana gama gwo me’d mo /e dhali aha/ mo, dhali dhalki a’di ta gwo jin minu mish ṯor e bwaman /e dhali aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Wakana Yakuub bu’thki wosh mo dhali thum a’di ka tiŋkiliŋ mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Dhala Yakuub ki ṯor ’kwani ma bas piti gwo mo mmotuli wosh is mo. Dhali uni bu’thki wosh mo dhali su’k uni ka tul ’kup̱ mo dhali uni shwaki to imaṯṯaan e mo ma tul ’kup̱ wosh mo. ");
INSERT INTO udu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Dhala Laabaan ki yuḵ mo c̱aan gway ka YajarSahduuṯẖa mo, hila Yakuub yuḵki a’di gway ka Jal/iid mo. ");
INSERT INTO udu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Dhala Laabaan ki o gwo mo ki: Wosh su’k yan mo tani a’di midi ṯor gwo e bwaman /e dhali aha/ mo ’pena tee yan shwane/ mo. Gom gwo gi wakan mo tani a’di yuḵki mo yan gway ka Jal/iid mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Dhala tiŋkiliŋ yan yuḵkunu gway ka Misp̱ah mo haali/ a’di oki gwo mo ki: Tap̱a a’di ihilki’da hil e bwaman /e mo dhali aha/ mo ki ana mina mii p̱i mo ka rem’kup̱ ’pena kamuŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Waḵki/ /e mini tham i’bwa/m pem to mii ap̱o/ mo walla /e wari mini bu’th up̱a tiya mmop̱ana’d i’bwa/m pem isa p̱o/ mo tani, ba wathiŋ kamu/ p̱iyi’d mmonyaḵ di ki ana mo mmomii mo, hili, kayi gwo e mo, Arumgimis a’di ita’da amanṯor gwo e bwaman /e dhali aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Dhali yan’ko’da Laabaan ki owa Yakuub gwo mo ki: P̱ari wosh su’k gwan e mo dhala tiŋkiliŋ piti mo a’di jin thumkika/ mo e bwaman /e mo dhali aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Wosh su’k yan a’di ita’da man/o gwo mo dhali atiŋkiliŋ a’di ita’da man/o gwo mo ki aha/ mina diki pe ’kuwosh su’k yan mo e /e mo, dhali /e si’da/ mini diki pe ’kuwosh su’k yan e aha/ mo gom mo jin ’koshuwa ’kosh mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Arumgimis ma Ibrahiim dhali Arumgimis ma Nahur a’di jin ta’da Arumgimis ga babam buni mo dhalki a’di dwall gwo i bwaman ana mo. Wakana Yakuub thulki gwo me’da p̱o/ mo ki moŋḵo/ is ma babam piti ka Is/hak mo. ");
INSERT INTO udu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Dhala Yakuub a’di c̱iki to mo mmomiiya basa ’cesh mo e ’kuwosh jin turatur mo dhali yuḵ ’kwani ma bas piti mo dhali shwa maaŋḵuthu’d mo, dhali ki uni shwaki maaŋḵuthu’d mo tani uni ’kokin e mun mmo’baar mon’thiny yan mo e ’kuwosh jin turatur mo be. ");
INSERT INTO udu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mon’thamo/ ka ’tum mo aLaabaan a’di cuki mis mo dhali p̱i idhancom ’twa/ mo dhali i’bwa/m piti mo dhali ’bor uni mii mo dhali yan’ko’d a’di ki ḵwa/ is piti bwa ’peni uni mo dhali doḵ bway pa ka nyaŋ’ko’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","AYakuub a’di iyaki’d mo e bway piti mo dhali iman’doyu gwo gamki a’di ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Dhali ka Yakuub mishi uni mo tani a’di oki gwo mo ki: Uni gwansan ita ’kwani ma mee ma Arumgimis mo. Wakan a’di yuḵki mo c̱aan gway mo ka Mahanaayim mo. ");
INSERT INTO udu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Dhala Yakuub hashki’da ris ’kwani ma gum bway piti nṯwa/a/ ki a’di mo eya Iisu jin ta’da kam piti mo e bampa/ ki Pa Si/iir mo jin ta bampa/ Aduum mo. ");
INSERT INTO udu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","A’di ye’thki uni sho’k ki gwo mo mmo/o ki: Iiyi ṯorki tap̱am pem ka Iisu gwo mo ki: C̱iŋkinam pini ka Yakuub oki gwo gi wakan mo ki: Aha/ yakina yanyc̱a/ mo e pa Laabaan mo dhali c̱a’b ntagi shwane/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Dhali aha/ tana ga risa morbip̱ mo dhali aris thuluny mo dhali ama’diny ḵa’bal mo dhali aris c̱iŋkinaŋ ’kwaniŋ gwaṯẖ mo kun miina ṯu’c mo dhali aris c̱iŋkina/ nyara/ mo kun miina ṯu’c mo dhali aha/ hashkina gwo mo mmoṯor tap̱am pem gwo mo ki aha/ mina gam mii ma ’the ’peni jis/em pini mo. ");
INSERT INTO udu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Dhali aris ’kwani ma gum bway piti uni doḵkin ka nyaŋ’ko’da Yakuub mo mmo/o gwo mo ki: Aman p̱u’dkina eya kam pini ka Iisu mo dhali a’di di’d mmoyayu/ mo mmogam /e ’kup̱ mo nyaḵki ’kwaniŋ gwaṯẖ kun ’koni iss ’kwanimpa i/iss ’de/ kun nyaḵ iiyu/ ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dhali yan’ko’da Yakuub ḵo/ki is kagahara mo dhali a’di butha ’tham mo dhali a’di ḵwa/ki ’kwani bwa mo kun ’kokin nyaḵki a’di mo dhali ama’diny ḵa’bal mo dhala buhany bip̱ mo dhali aris kalman mo mmo’ko ka ṯa/ isu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","A’di kulumki gwo ibwa mo waḵki/ Iisu midi p̱u’du/ ka ṯa/ ’de/ mo dhali ’ce’da/ ’ce’d sho’k mo tani aṯaŋ kamu/ minu dhalku mo mmoye mo be. ");
INSERT INTO udu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Dhala Yakuub ki o gwo mo ki: Ayy Arumgimis ma babam pem ka Ibrahiim mo dhali Arumgimis ma babam pem ka Is/hak mo, ayy Tap̱a /e jin oki aha/ gwo mo ki: Doḵi ka nyaŋ’ko’d e bampam pini mo dhali e ’kwani ma bas pini mo dhali aha/ mina mii /e ki ’bore/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Aha/ dina ki ha me’d mo goma ris mo/en jin ṯelu sho’k mo dhali goma ris mii ma isiŋ ganam pini mo uni kun ṯorkina /e c̱iŋkinam pini mo haali/ ki cwa gi me’d pem ’te/ mo tani a’di i’ciṯẖka/ Yi’deŋ Ḵumma/ Uurdun mo dhali shwane/ aha/ warkina ki wathi/ jin ’kon ma ṯa/i su/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","’Cuḵi aha/ mo ma, aha/ ’thona /e mo ’peni me’d ma kam pem mo isi ’peni me’d ma Iisu mo haali/ aha/ ḵo/kina a’di mo isi ciki/ a’di midi p̱u’du/ mo dhali ’kosh am ’baar mo jwa mo nyaḵki ita’da ki uc̱i ilu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Hili /e oki gwo mo ki: Aha/ mina mii /e ki ’bore/ mo dhali dhu emen pini mmowa e ka si’b gi bwam ma al yi’de/ mo a’di jin minu mol deŋ e mo goma buhany piti mo. ");
INSERT INTO udu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Wakan a’di ishki’d imaṯṯaan mon’thiny mo dhali a’di ki bu’th ’peni to kun tana a’di mo to jin c̱inu ki me’d mo goma kam ka Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","A’di c̱iki a’di kuman ḵa’bali iss ’kwanimpa i’kume’d mo dhali gwasi mi i/iss ’de/ mo dhali kuman ḵa’bali iss ’kwanimpa i’kume’d mo dhali gwasiŋ ḵa’bali iss ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Dhali kuman kalman kun umuwa ko i iss ’de/ i’ce’dka ’kume’d mo nyaḵki ushan buni mo dhali bip̱i issu/ mo dhali amorbip̱i ’kume’d mo dhali kuman thulunyi iss ’de/ mo dhali gwaṯẖan thulunyi ’kume’d mo. ");
INSERT INTO udu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Aris to gwansan idhukina a’di e me’d ma ris c̱iŋkinam piti mo dhali aris uni urkunu ki she/ ki she/ mo dhali a’di oki’da ris c̱iŋkinam piti gwo mo ki: Iiku/ nṯwa/a/ ki aha/ mo dhali kari buli bwaman mo mmo/ur to mo dhali uri to mo. ");
INSERT INTO udu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A’di ye’thki uni kun iikin nṯwa/a/ sho’k ki gwo mo ki: Ka Iisu jin ta’da kam pem midi gam um ’kup̱ mo dhali doṯ um gwo mo ki um ta gu maja mo tani, dhali um iini ii mana mo? tani, dhali aris to maja gwansan kun iini bwambori um mo isan? tani, ");
INSERT INTO udu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","dhali yan’ko’d um mini o gwo mo ki: Uni ta ku gi c̱iŋkinam pini ka Yakuub mo, uni ta to kun c̱inu ki me’d kun hashu /e tap̱am pem ka Iisu mo dhali a’di ki is piti yayi’di ’ko’di aman mo be. ");
INSERT INTO udu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","A’di mii miin ’de/ yan jin nyaḵka’d mmoye’th uni kun ’kon ma p̱o/ isu/ sho’k gi gwo mo dhali nyaḵki uni kun ’kon ma p̱o/ ikwara mo dhali aris uni kun uru mo ki: Um mini mii o jasi gwon ’de/ mo eya Iisu mo ki um mini gam a’di ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Dhali um mini o a’di gwo mo ki c̱iŋkinam pini ka Yakuub a’di di’d mmoyayu/ ki is piti i’ko’di aman mo, haali/ a’di kulumki gwo ibwa mo ki aha/ mina ’taki wan a’di is ki to jin c̱inu ki me’d mo kun iini bwambori aha/ mo dhali yan’ko’d aha/ mina p̱ar jis/em piti e mo: waḵki/ a’di wariba/ midi ’taki bu’th aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Wakan to kun c̱inu ki me’d iikin mo mmoshu a’di bway mbwambor mo dhali a’di ki is piti ishki’d mo mon’thiny yin e gu’b burrinyem piti mo. ");
INSERT INTO udu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Dhali mon’thiny ’de/ yan mo tani a’di cuki mis mo dhali bu’th i/ashi su/ mo dhali up̱ c̱iŋkina/ nyaram piti isu/ mo ’dhali uc̱im piti ’kume’d i’ce’dka ’de/ mo dhali a’di ki ’ciṯẖa al yi’de/ ma Yabbuug mo. ");
INSERT INTO udu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","A’di suski uni mo dhali hash uni mo mmo’ciṯẖ yi’de/ jin guski’d mo dhali nyaḵka ris to ’baar mo kun tana a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Dhala Yakuub a’di dhalkunu a’di ’de/ mo dhali a’di ’tirki’d uni ki wathiŋ kamu/ mo ntagi e ḵali kush mo. ");
INSERT INTO udu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ki wathi/ p̱arki mo e mo ki a’di diki p̱iya Yakuub e ki mii mo tani a’di ki ta a’di bwaman ma wum piti is ki me’d mo ntagi a’di burushki’d mo dhali awum gi Yakuub a’di iraḵki’d mo ’peni gocor piti mo me’d jin ’tirkina a’di nyaḵki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Dhali yan’ko’d a’di ki o gwo mo ki: Dhalki aha/ me’d, aha/ yana mo haali/ mo ḵalki kush mo. Hila Yakuub oki gwo mo ki: Aha/ mina dhal /e me’d mo yisa isi ciki/ /e mini mii ’bor aha/ mii mo. ");
INSERT INTO udu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Dhali a’di ki o a’di gwo mo ki: Gway pini yuḵu kaja mo? Dhali a’di ki thoḵ a’di gwo mo ka: Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Dhali yan’ko’d a’di ki o gwo mo ki: Gway pini minu mii ’koki doḵ/e yuḵ ka Yakuub yisa, hili ka Israyiil mo haali/ /e askina Arumgimis nycine/ mo dhali ’kwani mo dhali /e p̱iki mii e mo be. ");
INSERT INTO udu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Dhali yan’ko’d Yakuub ki doṯ a’di gwo mo ki: Ṯori aha/ gwo mo ma aha/ ’thona /e mo, gway pini yuḵu kaja mo? Hili a’di oki gwo mo ki: Gomatinta idoṯkina /e gway pem mo? Dhali a’di ki la dhiŋ mii is mo i’bor a’di mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Wakan aYakuub yuḵki mo c̱aan gway mo ka P̱anu/iil mo mmo/o gwo mo ki: Haali/ Arumgimis mishkika/ jis/em piti ka ḵarambor mo dhali hili mondiki/em pem a’di ’tashkunu ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Atente/ sulki’da p̱o/ a’di mo me’d jin pekina a’di Pa P̱anu/iil mo mmoto’b ki cwa mo haala wum piti ta ŋwol mo. ");
INSERT INTO udu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Gom gwo gi wakan mo ’pena cim c̱aan mo tani ’Kwani ma Israyiili ’baar mo tani uni ’koki ’ka to kun miinycuru/ ’kus ki ’bi’th mo mmoraḵ dugu’b buni ’peni awum mo haali/ a’di burushki’da Yakuub awum piti mo ’peni dugu’b mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Dhali aYakuub i’de’kki em piti ki mis mo dhali p̱ar mo e mo dhali hili mo mo ma, Iisu a’di p̱u’dki’d mo nyaḵki ’kwanim piti kun ’koni iss ’kwanimpa i/iss ’de/ mo. Wakan a’di ḵwa/ki uc̱i bwa mo e bwaman ma Le/ah dhala Rahiil mo dhali up̱i su/ gwan kun ta c̱iŋkina/ nyara/ mo. ");
INSERT INTO udu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Dhali dhuki up̱i su/ gwan kun ta c̱iŋkina/ nyara/ mbwambor mo nyaḵki uc̱im buni mo dhali yan’ko’da Le/ah nyaḵki uc̱i ma yim mo dhala Rahiil mo dhala Yuusup̱ ŋ’ko’d gana/ mo ki tiya ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A’di ki is piti yaki’d nṯwa/a/ ki uni mo dhali luŋki is piti a’cesh ki goŋgo/ mo me’di pesu/ mo ntagi a’di ’dishki’da kam is mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Hila Iisu a’di guski’d mo mmogam a’di ’kup̱ mo dhali kar a’di mmota isa kony mo dhali biṯi ’bam piti mo dhali p̱i a’di ’twa/ mo dhali uni ki ko mo imonṯal ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Dhali ka Iisu ’de’kki em piti ki mis mo dhali p̱ar up̱ e mo dhali aris uc̱i mo tani a’di ki o gwo mo ki: ’Kwani kuna anansan kun nyaḵ iiyu/ ki /e mo? AYakuub ki thoḵ gwo mo ki: Uc̱i kun c̱ikin ma Arumgimis c̱iŋkinam pini ka ’the mo. ");
INSERT INTO udu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Dhali yan’ko’d up̱ nyarany c̱iŋkina/ uni ’dishkin mo, uni dhali uc̱im buni mo dhali goŋ is ka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Le/ah miiki’d wakan mo dhali uc̱i ma yim mo uni ’dishkin mo dhali goŋ is ka ’cesh mo dhala Yuusup̱ ŋ’ko’d mo dhala Rahiil i’dishki mo is mo dhali uni goŋki is ka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iisu doṯki gwo mo ki: ’Pemen miim pini yan ta’da ta mo jin gamkika/ arisa ṯaŋ ’kwaniŋ ’kup̱ mo kan? AYakuub a’di thoḵki gwo mo ki: Mmogam mii ma ’the ’peni jis/e gi tap̱am pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Hila Iisu thoḵki gwo mo ki: Aha/ tana gi to kun ’koshi jwa mo akam pem. Dhuyi uni kun tana /e mo gom is pini mo. ");
INSERT INTO udu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakuub thoḵki gwo mo ki: Yisa, aha/ ’thokina /e mo, waḵki/ aha/ mina gam mii ma ’the ’peni jis/em pini mo tani /e mini mii bu’th tom pem gwan kun c̱inu ki me’d mo ’peni me’d pem mo haali/ ka jiŋ gana/ mmop̱ar jis/em pini e mo wakan mo tani a’di wana e ki mmop̱ar jis/e ma Arumgimis e mo mmobu’thkina /e aha/ ki mii ma ’the gi wakan mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Buthi uni mo, aha/ ’thokina /e mo tom pem gwan kun c̱ika/ ka ’ka’d me’di is mo kun ḵalkika/ gom /e mo haali/ Arumgimis ṯu/ulki aha/ ki mii ma ’the mo dhali haali/ aha/ takina gi to jin ’kosh jwa mo. A’di ṯirrishki a’di mo dhali a’di bu’thki uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Dhali yan’ko’d Iisu ki o gwo mo ki: Dhalki ana iina mo e bway bana mo dhali aha/ mina shu /e bway mo. ");
INSERT INTO udu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Hila Yakuub thoḵ a’di gwo mo ki: Tap̱am pem /e mishi uc̱i ki uni gwa’dagwa’d mo dhali ama’diny ḵa’bal dhali dhana ŋul’kup̱ ḵa’bal ta gi ushan mo kun miga/ hili e ki ’bore/ mo. Dhali waḵki/ uni uru ki ur ma hala/hala/ ka cim ’de/ mo tani arisa ma’diny ḵa’bal uni mini wu ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Dhalki tap̱am pem shuki c̱iŋkinam piti bway nṯwa/a/ mo dhali aha/ mina suska sus ka serec̱ serec̱ mo isi me’d ŋaṯgin to/e mo uni gun ’kon abori aha/ mo dhali isi me’d ŋaṯgin jin mina uc̱i idhu mo, ntagi aha/ mina p̱u’dku/ i tap̱am pem e Pan Si/iir mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Wakan Iisu oki gwo mo ki: Dhalki aha/ dhalkina /e ’kwaniŋ gwaṯẖ kun nyaḵ ’ko ki aha/ mo. Hili a’di oki gwo mo ki: Atinta a’di imina uni mii c̱or imun mo? Dhalki aha/ gama mii ma ’the ’peni jis/em pini mo tap̱am pem mo. ");
INSERT INTO udu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Wakana Iisu doḵki’d mo ka tee c̱aan mo e bway piti mo e Pan Si/iir mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Hila Yakuub a’di yaki’d mo e Pan Sukkuut mo dhali nyaŋ gu’b gom is piti mo dhali nyaŋa ris c̱iŋŋa/ goma ris to/em piti mo. Gom gwo gi wakan mo tani a’di iyuḵkunu mo c̱aan gway mo ka Sukkuut mo be. ");
INSERT INTO udu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Dhala Yakuub a’di pu’dki’d ki ’dantar mo e ’peŋkuman bampa/ gi Pan Shakiim mo a’di jin di’di Paŋ Kanaan mo e bway piti jin yayina a’di mo ’peni Pam P̱addaan/araam mo dhali a’di p̱e’dki gu’b burrinyem piti ibwambor ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dhali ’peni iya/ ma Hamuur mo a’di jin ta’da baba gi ’Kwani gi Pan Shakiim mo tani a’di yolki’da ’cesha kamu/ ka riyaal iss ’kwanimpa imudhe’d mo a’di jin thumkina a’di gu’b burrinyem piti mo. ");
INSERT INTO udu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","E mo yan mo tani a’di ḵa’bki’da gwaṯa/ mo a’di jin miinuwa basa ’cesh mo dhali yuḵ mo yan gway mo ka El-Elohe Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dhali aDiinah jin ta ’bwa/ ma Le/ah a’di jin dho’thkin ma yim ka Yakuub mo a’di yaki’d mo mmobuṯa ris up̱ gi bampa/ yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Dhali ka Shakiim jin ta ya/ ma Hamuur jin ta Wathi/ gi Pan Hiwwi jin ta ya/ ma maliḵ gi bampa/ yan p̱arki’da yim e mo tani a’di bu’thki’da yim mo dhali ish nyaḵka yim mo dhali kara yim is ki gwa’d mo. ");
INSERT INTO udu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Dhali aḵashiram piti dirkunu mo ’kup̱ ka Diinah mo a’di jin ta ’bwa/ ma Yakuub mo. A’di enki nyara/ yan mo dhali wal ’twa/ ka yim ki wala teṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Wakan Shakiim ṯorki’da ṯor ki com jin ta’da Hamuur mo mmo/o gwo mo ki: Guyaa/ nyara/ yan mo ma mmota a’bom pem mo. ");
INSERT INTO udu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Dhali ka Yakuub ciḵki gwo mo ki a’di shi/ki ’bwa/m piti ka Diinah is mo tani, hili iya/ ’koyina mo mmohil to/em piti e bwaasho/ mo. Wakana Yakuub bu’thki moŋḵu’th is piti mo ntagi uni p̱u’dkin mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Dhala Hamuur jin ta’da baba ma Shakiim mo tani a’di yaki’d ka pije/ mo mmoṯora ṯor ka Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Dhali iya/ ma Yakuub p̱u’dkin mo ’peni bwaasho mo ki uni ciḵki gwo yan mo dhali ’kwani gwan shwan ma anyor eya du mo dhali miiya anyor kagahara mo haali/ a’di wakaski tonthus yan jin ta p̱us e ’Kwani ma Israyiil mo mmo/ishi ’bwa/ ma Yakuub mo haali/ tonthus gi wakan ḵa ba/ iminu ’koki mii mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hila Hamuur ṯorki’da ṯor ki uni mo dhali o gwo mo ki: Aḵashira/ gi ya/m pem ka Shakiim a’di ’thoṯẖa bwa gom ’bwa/m bum mo, aha/ ’thona um mo, mmoc̱iya yim ki a’di mo mmomash mo. ");
INSERT INTO udu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Thosoni gwo gi miimash nyaḵki aman mo, c̱iyu/ i’bwa/m bum ki aman mo dhali buthi i’bwa/m bam gom is bum si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Um mini nyaḵ ’ko ki aman mo dhali mony’cesh midi di ki ḵany gom um mo. ’Koyi mo dhali miiya ṯu’c e a’di mo dhali gami mal e a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shakiim si’da/ oki gwo eya baba ma yim mo dhali e ikam ma yim mo ki: Dhalki aha/ gama mii ma ’the e jis/em bum mo dhali aris to gunn kun mina um i o aha/ mo tani aha/ mina c̱i uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Doṯi aha/ mo ma, ma to gom miimash jin taka/ ki nyanye/ mo a’di jin ta tontaḵ dhali to kun c̱inu ki me’d mo dhali aha/ mina c̱i uni isi me’d jin ona um aha/ mo, hili c̱iyaa/ nyara/ yan mmota a’bom pem mo. ");
INSERT INTO udu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Dhali iya/ ma Yakuub thoḵkina Shakiim gwo mo dhali com ka Hamuur gwo ka he’k e mo haali/ a’di shi/ki ’bwah buni ka Diinah is mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Uni oki uni gwo mo ki: Aman mola to yan mii mo mmoc̱i ’bwah bam ki wathi/ jin ’konuki ’ciṯẖa/ munyjal yis mo haali/ mii yan a’di imidi ta mii jin midi ’the aman is mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hili e mii yan mo tani aman mina gam gwo me’d nyaḵki /e mo ki /e mini mii war mo mmowa ki aman mo dhali aris ’kwaniŋ gwaṯẖ pini minu mii ’ciṯẖa/ munyjal yis mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dhali yan’ko’d aman mina c̱i i’bwa/m bam ki um mo dhali aman si’da/ mina bu’th i’bwa/m bum gom is bam mo dhali aman mina ’ko nyaḵki um mo dhali warki ’kwani en ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Hili waḵki/ /e diki ciḵ gwom bam mo dhali ’ciṯẖa/ munyjal yis mo tani aman mina bu’th ’bwa/m bam mo dhali aman mina ii mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Gwom buni ’borki’da Hamuur bwa mo dhala Shakiim jin ta ya/ ma Hamuur mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Dhali dhuru’c wathi/ diki ta diiṯe/ mo mmomii to yan mo haali/ a’di ’kunya bwa ki ’kuny kagahara gom ’bwa/ ma Yakuub mo. Dhali a’di si’da/ ita wathi/ jin taḵu kagahara mmobol tiya ’baar mo e e bwaman ma waḵ piti ki montaḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Wakana Hamuur dhali ya/m piti ka Shakiim uni iikin ka pije/ e ’twaŋkala goŋ gi ’peŋkuman bampa/ mo dhali ṯora ṯor ki ’kwani ki ’peŋkuman bampa/ mo dhali o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","’Kwani gwansan uni ita ikam bana mo. Dhalki uni ’kon mo e bampa/ yan mo dhali miiya ṯu’c ap̱o/ a’di mo haali/ hili mo mo ma, bampa/ beeyabee mo dhali midi ’kosh jwa mo gom uni mo. Dhalki ana butha i’bwa/m buni mo mmomash mo dhali dhalki ana si’da/ c̱ina uni ’bwa/m bana mo. ");
INSERT INTO udu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Hili jasi e mii yan ’de/ mo tani a’di imina ’kwani igam gwo me’d mo dhali nyaḵ ’ko ki ana mo dhali war ki ’kwani en ’de/ mo, ki aris ’kwaniŋ gwaṯẖ ’peni bwaman ana mo tani minu ’ciṯẖa/ munyjal yis mo me’d jin ’ciṯẖkunu uniya munyjal yis mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mina to/em buni dhali mal buni dhali aris toŋkal buni ’koki ta kum bana mowa? Dhalki ana gama jasi gwo yan me’d ki uni mo dhali uni mini nyaḵ ’ko ki ana mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Aris ’kwani kun iikin ka pije/ ’peni ’twaŋkal ma goŋ ’peŋkuman bampam piti mo tani uni ciḵki gwo ma Hamuur mo dhali ya/m piti ka Shakiim mo dhali aris ’kwaniŋ gwaṯẖi ’baar mo tani uni i’ciṯẖkunu amunyjal yis mo, aris uni ’baar mo kun iikin ka pije/ ’peni ’twaŋkal ma goŋ gi ’peŋkuman bampam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Dhali ka cim ’koni kwara mo ki uni ’kon ki jama/ i is mo tani iya/ ma Yakuub su/ mo a’di jin ta’da Shim/uun dhala Lawi uni kun ta ikam ma Diinah mo bu’thki gandala turgam buni mo dhali p̱u’dku/ e ’peŋkuman bampa/ ki e ka wu mo dhali ’kosha ris ’kwaniŋ gwaṯẖ gwan jwa mo ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Uni ’koshkina Hamuur dhali ya/m piti ka Shakiim jwa ki gandala turga/ mo dhali susa Diinah ka pije/ ’peni gu’b ma Shakiim mo dhali uni ki ii mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dhali iya/ ma Yakuub uni p̱u’dkin e moŋ’kosha ’kosh mo dhali kar ’peŋkuman bampa/ mmota abar ka bar mo haali/ ’bwah buni a’di ishi/kunu is mo be. ");
INSERT INTO udu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Uni bu’thkina ma’diny ḵa’bal buni mo dhala buhany bip̱ buni mo dhali aris thuluny buni mo dhali aris to gunn kun ’kon e ’peŋkuman bampa/ mo dhali kun ’kon e bwam bunto mo. ");
INSERT INTO udu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Aris tom buni kun tana uni pa ki pa mo dhali aris ushi uc̱im buni mo dhali aris up̱ buni mo dhali aris to gwan kun ’kon eya ris gu’b mo tani uni bu’thki uni mo dhali war ki tom buni jin dilina uni ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Dhali yan’ko’da Yakuub ki owa Shim/uun dhala Lawi gwo mo ki: Um ḵalki mo jin raḵu araḵ isa p̱o/ aha/ mo mmokar aha/ gway pem mmoshi/a shi/ e bwaman ’kwani gi bampa/ yan mo uni kun ta ’Kwani gi Paŋ Kanaan mo dhali ’Kwani gi Pam Pirissi mo. Aha/ tana a/ushala/ mo dhali waḵki/ uni mini tul isi monṯal ’de/ ap̱o/ aha/ mo dhali p̱u’daa/ i is mo tani aha/ minu ’ce’d sho’k mo aha/ dhali nyaḵki kuŋ gu’b pem ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Hili uni oki gwo mo ki: A/miim piti ’boro’da? mmomii ’bwah bam me’da ’bom c̱al mowa? ");
INSERT INTO udu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Arumgimis oki’da Yakuub gwo mo ki: Cuyi mis mo dhali yayi ka gagamis e Pam Beeṯ/iil mo dhali c̱a’bi /e imun mo dhali ḵa’bi agwaṯa/ goma Arumgimis imun mo a’di jin piki /e i is mo me’d jin guskina /e mo ’pena kam pini ka Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Wakan aYakuub oki gwo e kuŋ gu’b piti mo dhali aris uni ’baar mo kun nyaḵ ’ko ki a’di mo ki: Dhuya risa rum thus ’pen ka pije/ mo ma uni kun tana rum gi ’kwanim bunycani tiya mo ’peni bwam um mo dhali dhagami is bum mo dhali aḵi burrinyem bum e mo. ");
INSERT INTO udu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Dhali dhalki ana cuna mis mo dhali iina ka gagamis e Pam Beeṯ/iil mo ki aha/ mina ḵa’b agwaṯa/ goma Arumgimis imun mo a’di jin thoḵki aha/ ’twa/ mo ka teem pem jin taka c̱is ka c̱is mo dhali a’di jin nyaḵki di ki aha/ mo eya ris mo gunn kun yakika/ mo. ");
INSERT INTO udu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Wakan uni c̱ikina Yakuub arisa rum thus gi bunycan ’kwanin tiya mo uni kun takina uni mo dhali aris malla/ ’cem buni mo dhali aYakuub ba’kki uni mo e ’peny cwa ma c̱aww jin ’dish Pan Shakiim is mo. ");
INSERT INTO udu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Dhali ki uni iikin ibway mo tani dhan moŋḵo/ is ’peni Arumgimis yayi’da p̱o/ ’peŋkuman bampa/ kun ’kamki uni is mo. Wakan uni ’koki ur iya/ ma Yakuub isho’k mo. ");
INSERT INTO udu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Dhala Yakuub a’di ip̱u’dki’d mo e Pan Luus mo a’di jin ta’da Beeṯ/iil mo a’di jin di’d e bampa/ Kanaan mo a’di dhali aris ’kwani kun nyaḵki ’ko ki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Dhali imun mo tani a’di iḵa’bkina a’di gwaṯa/ mo mmomiiya basa ’cesh mo dhali yuḵ mo yan gway mo ka Iil Beeṯ/iil mo haali/ e mo yan mo tani Arumgimis ṯorki a’di is piti e eya tente/ mo me’d jin guskina a’di mo ’pena kam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Dhala Dabuurah jin ta’da manhila Rip̱ka mo a’di iwuki’d mo dhala yim a’di kankunu mo e ’peny cwa ma c̱aww e mo jin di’d ka luŋgu’b ki Pam Beeṯ/iil mo. Wakan a’di iyuḵkunu a’di gway mo ka Alluun Bakuut mo. ");
INSERT INTO udu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Arumgimis piki’da Yakuubi is doḵ/e mo me’d jin p̱u’dkina a’di mo ’peni Pam P̱addaan/araam mo dhali ’bor a’di mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Dhali Arumgimis ki o a’di gwo mo ki: Gway pini be yuḵu ka Yakuub mo be dhali /e yisa minu doḵ/e yuḵ gway pini ka Yakuuba mo yisa. Hili gway pini minu yuḵ ka Israyiil mo. Wakan a’di iyuḵkunu a’di gway ka Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Dhali Arumgimis ki o a’di gwo mo ki: Aha/ tana Arumgimis jin Eḵa/ Eḵ mo. Ḵali /e mamana dho’th mo dhali mari /e amar is mo. Kal ’kwaniny’cesh dhali arisa ṯa/ gi kal ’kwaniny’cesh mini piyu/ ’peni /e mo dhali imaliḵ ka ris mini du’du/ ’peni /e mo. ");
INSERT INTO udu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mony’cesh jin c̱ikika/ ka Ibrahiim dhala Is/hak mo tani aha/ mina c̱i a’di /e mo dhali aha/ mina c̱i a’di ki emen pini i’ko’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Dhali yan’ko’da Arumgimis borki is piti imis mo ’peni mo jin ṯorkina a’diya ṯor nyaḵki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Dhala Yakuub thumki’da tiŋkiliŋ mo e mo yan jin ṯorkina a’diya ṯor nyaḵki a’di mo, a’di jin ta’da tiŋkiliŋ wosh mo dhali wolki’da tiŋkiliŋ tomp̱i i’kup̱i a’di jin c̱inu ki bwa ma ’the mo dhali wola yini ’kup̱i a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Wakana Yakuub yuḵki mo yan gway ka Beeṯ/iil mo a’di jin ṯorkin ma Arumgimis aṯor ki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Dhali yan’ko’d uni iikin mo ’pena Pam Beeṯ/iil mo dhali uni si’dasi’d naskina/ ’peni Pan Ap̱raatah mo, aRahiil shwan ma ’ci mo dhali ayim di’d e mo jin shwana bwan dho’th mo. ");
INSERT INTO udu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Dhali ka yim diki’d e mo jin shwana bwan dho’th mo tani a’bom jin karu mo mmowoṯẖa woṯẖ mo gom mondho’th up̱ mo tani oki a’di gwo mo ki: Dhalku/ is ki ḵo/ mo ma haali/ /e shwane/ murkini ta ga ’ciŋgwaṯẖa kamu/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Dhali me’da ḵashira/ ma yim di’di mmoḵwa/kina a’di is bwa ’pena yim mo (haali/ ayim wuki’d mo) tani a’di ayim ki yuḵ a’di gway ka Ben/uuni mo hili com a’di iyuḵki a’di gway mo ka Benyamiin mo. ");
INSERT INTO udu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Wakana Rahiil a’di wuki’d mo dhala yim a’di kankunu mo e bway gi Pa Ap̱raatah mo, a’di jin ta Pam Beeṯlaham mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Dhala Yakuub thumki’da tiŋkiliŋ i’kup̱ jis jwa ma yim mo a’di jin ta’da tiŋkiliŋ i’kup̱ jis jwa ma Rahiil mo a’di jin diki’d imun ntagi shwanesan mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israyiil a’di yaki’d mo dhali thum gu’b burrinyem piti e bwamp̱o/ gu’ba turga/ gi Pan Idir mo. ");
INSERT INTO udu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ka Israyiil c̱a’bki’d e bampa/ yan mo tani Ra/ubiin a’di yaki’d mo dhali isha Bilhah mo a’di jin ta’da ’bom lac̱a/ gi com mo dhala Israyiil ciḵki gwo yan mo. Dhali iya/ ma Yakuub uni ’koni ’kume’d i’ce’dka su/ mo. ");
INSERT INTO udu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Iya/ ma Le/ah mo tani jin ṯwa/a/ a’di jin ta’da bwanyara/ ma Yakuub a’di ita’da Ra/ubiin mo dhala Shim/uun mo dhala Lawi mo dhala Yahuuda mo dhala Yassaakar mo dhala Sabuluun mo. ");
INSERT INTO udu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Iya/ ma Rahiil uni si’da/ annihe/ mo: Yuusup̱ dhala Benyamiin mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Dhali iya/ ma Bilhah a’di jin ta nyarany c̱iŋkina/ ma Rahiil mo uni si’da/ annihe/ mo: Daan dhala Nap̱taali mo. ");
INSERT INTO udu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Dhali iya/ ma Silp̱ah uni si’da/ annihe/ mo: Jaad dhala Ashiir mo. Uni gwansan ita iya/ ma Yakuub mo kun dho’thkunu a’di me’d jin dikina a’di e Pam P̱addaan/araam. ");
INSERT INTO udu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Dhala Yakuub p̱u’dki’di com ka Is/hak mo e Pa Mamra mo walla e Paŋ Giryat/arba mo a’di jin ta Pa Habruun mo e mo jin yakin ma Ibrahiim dhala Is/hak iinyc̱a/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Dhali atee yil ma Is/hak uni ’koni iss ’kwanimpa ipedoŋon mo be. ");
INSERT INTO udu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Dhala Is/hak a’di c̱iki shi/in piti jiŋ ’ko’d mo dhali a’di wuki’d mo dhali a’di gamkunu isi monṯal ’de/ nyaḵki ’kwanim piti mo mmotana a’di dhan guma dhan gana/ mo ka teem piti mo. Dhali iya/m piti jin ta’da Iisu dhala Yakuub uni kanki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Uni gwansan ita emen ma Iisu mo (a’di jin ta Aduum mo). ");
INSERT INTO udu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iisu bu’thki’da ris up̱ ’peni ’Kwaniŋ Kanaan mo: Ada jin ta ’bwa/ ma Iiluun jin ta Wathi/ Hiṯẖṯẖa mo dhala Uhulibaamah jin ta ’bwa/ ma Ana jin ta ya/ ma Sib/uun mo jin ta Wathi/ Hiwwi mo. ");
INSERT INTO udu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Dhala Basmah jin ta ’bwa/ ma Isma/iil dhali ’bwaham ka Nabayuut mo. ");
INSERT INTO udu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Dhala Ada dho’thki’da Iisu a/Elip̱aas mo dhala Basmah dho’thki’da Ra/u/iil mo. ");
INSERT INTO udu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Dhala Uhulibaamah dho’thki’da Ya/uush dhala Yalaam dhala Guurah mo. Uni gwansan ita iya/ ma Iisu mo kun dho’thkunu a’di mo me’d jin dikina a’di e Paŋ Kanaan mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Dhali yan’ko’da Iisu bu’thki’da ris up̱ piti mo dhali aris iya/m piti mo dhali aris i’bwa/m piti mo dhali arisa waḵ gi gu’b piti mo dhali to/em piti mo dhali aris toŋkal piti ’baar mo dhali aris mal piti ’baar mo kun gamkina a’di adu is mo ’peni bampa/ gi Paŋ Kanaan mo dhali a’di yaki’d mo e bampaŋ kamu/ mo ’pena kam piti ka Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Haali/ tom buni kun gamkina uni mo tani uni caaca kagahara mo gom uni mmo’ko imonṯal ’de/ mo haali/ mony’cesh jin tana uni ac̱a/ ap̱o/ mo tani midi mol uni thip̱ mo gom to/em buni mo. ");
INSERT INTO udu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Wakana Iisu a’di c̱a’bki’d mo e bampa/ gi paŋ ’kuwosh ma Si/iir mo. Iisu a’di ita wathi/ Aduum mo. ");
INSERT INTO udu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Uni gwansan ita emen ma Iisu mo jin ta’da baba gi ’Kwani gi Pan Aduum mo e bampa/ paŋ ’kuwosh ma Si/iir mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Gway gi iya/ ma Iisu uni annihe/ mo: Elip̱aas jin ta ya/ ma Ada mo jin ta asha Iisu mo dhala Ra/u/iil jin ta ya/ ma Basmah jin ta asha Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dhali iya/ ma Elip̱aas uni annihe/ mo: Temaan dhala Awmaar dhala Sap̱wa dhala Ja/ṯẖaam dhala Ganaas mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","(Timnaa/ a’di ita’da ’bom lac̱a/ goma Elip̱aas mo a’di jin ta ya/ ma Iisu mo. Ayim a’di idho’thki’da Amaliik ka Elip̱aas mo.) Uni gwansan ita iya/ ma Ada jin ta asha Iisu mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Uni gwansan ita iya/ ma Ra/u/iil mo: a’di jin yuḵu gway ka Nahaṯẖ dhala Saarah dhala Shammah dhala Missa mo. Uni gwansan ita iya/ ma Basmah mo jin ta asha Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Uni gwansan ita iya/ ma Uhulibaamah mo a’di jin ta ’bwa/ ma Ana mo jin ta ya/ ma Sib/uun mo jin ta asha Iisu mo. Ayim dho’thki a’di aYa/uush mo dhala Yalaam dhala Guurah mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Uni gwansan ita iya/ ma Iisu kun tana ris tap̱a mo. Iya/ ma Elip̱aas a’di jin ta’da bwanyara/ ma Iisu mo: Temaan dhala Awmaar dhala Sap̱wa dhala Ganaas uni ita tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Guurah dhala Ja/ṯẖaam dhala Amaliik uni gwansan si’da/ ita tap̱a ’pena Elip̱aas e bampa/ gi Pan Aduum mo uni kun ta iya/ ma Ada mo. ");
INSERT INTO udu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Uni gwansan si’da/ ita iya/ ma Ra/u/iil jin ta ya/ ma Iisu mo: Nahaṯẖ dhala Saarah dhala Shammah dhala Missa mo uni gwansan ita tap̱a ’pena Ra/u/iil mo e bampa/ gi Pan Aduum mo. Uni gwansan ita iya/ ma Basmah mo jin ta asha Iisu mo. ");
INSERT INTO udu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Uni gwansan ita iya/ ma Uhulibaamah jin ta asha Iisu mo uni kun ta itap̱a mo: Ya/uush dhala Yalaam dhala Guurah mo. Uni gwansan ita tap̱a ’pena Uhulibaamah jin ta ’bwa/ ma Ana a’di jin ta asha Iisu mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Uni gwansan ita iya/ ma Iisu mo (jin ta Aduum mo) dhali itap̱am buni anann mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Uni gwansan si’da/ ita iya/ ma Si/iir jin ta Wathi/ gi Pan Huri mo a’di jin cila bampa/ yan mo: Luthan dhala Shubal dhala Sib/uun dhala Ana mo. ");
INSERT INTO udu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishun dhala Iisar dhala Dishan mo uni gwansan ita itap̱aŋ ’Kwani gi Pan Huri mo kun ta iya/ ma Si/iir e bampa/ Pan Aduum mo. ");
INSERT INTO udu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Iya/ ma Luthan mo tani ita iHuri dhala Hemam mo, dhali ’bwah ma Luthan mo tani a’di ita’da Timnaa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Uni gwansan ita iya/ ma Shubal mo: Alwaan dhala Manaahah dhala Eebaal dhala Shap̱wa dhala Unam mo. ");
INSERT INTO udu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Uni gwansan ita iya/ ma Sib/uun mo: Ayyah dhala Ana a’di jin ta’da Ana jin gamki yi’de/ jin kasha e ki kash jin ’batha’ba’th e mombwaasho mo me’d jin urkina a’di aris thuluny ma Sib/uun jin ta’da babam piti mmoc̱iya shon dhii/i’d mo. ");
INSERT INTO udu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Uni gwansan ita uc̱i ma Ana mo: Dishun dhala Uhulibaamah a’di ta ’bwa/ ma Ana mo. ");
INSERT INTO udu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Uni gwansan ita iya/ ma Dishan mo: Hamdaan dhala Ashbaan dhala Yiṯẖraan mo dhala Karaan mo. ");
INSERT INTO udu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Uni gwansan ita iya/ ma Iisar mo: Bilhaan dhala Sawaan dhala Agaan mo. ");
INSERT INTO udu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Uni gwansan ita iya/ ma Dishun mo: Uus dhala Araan mo. ");
INSERT INTO udu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Uni gwansan ita itap̱aŋ ’kwani bampa/ Huri mo, uni kun ta itap̱a mo: aLuthan dhala Shubal dhala Sib/uun dhala Ana mo. ");
INSERT INTO udu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishun dhala Iisar dhala Dishan uni gwansan ita itap̱a gi ’Kwani Huri mo isi me’da bas buni kun tana uni mo e Pan Si/iir mo. ");
INSERT INTO udu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Uni gwansan ita imaliḵ mmoji/a ji e bampa/ Pan Aduum mo nṯwa/a/ ka maliḵ ’deŋ kamu/ diki ji/a ji ap̱o/ ’Kwani ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Baala/ a’di jin ta ya/ ma Ba/uur mo a’di ijiki’da ji ap̱o/ Pa Aduum mo dhali ’peŋkuman bampam piti yuḵkunu gway ka Dinhaabah mo. ");
INSERT INTO udu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Baala/ a’di iwuki’d mo dhala Yubab jin ta ya/ ma Saarah ’pena Busrah mo tani a’di ijiki’da ji i embul piti mo. ");
INSERT INTO udu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yubab a’di iwuki’d mo dhala Husham ’peni bampa/ ’Kwani gi Pan Temaan a’di ijiki’da ji mo i embul piti mo. ");
INSERT INTO udu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham a’di wuki’d mo dhala Hadaad jin ta ya/ ma Badaad a’di jin p̱iki ’Kwani Midyaan e mo e bampa/ ’Kwani Pam Muwab mo tani a’di ki ji/a ji i embul piti mo dhali gway ’peŋkuman bampam piti mo tani a’di yuḵu gway ka Awiit mo. ");
INSERT INTO udu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaad a’di iwuki’d mo dhala Samlah ’pena Masriigah a’di ijiki’da ji i embul piti mo. ");
INSERT INTO udu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah a’di iwuki’d mo dhala Sha/uul ’pena Rahubut ’peni ’kwani Yi’deŋ Ḵumma/ ma Elp̱uraat mo tani a’di ijiki’da ji i embul piti mo. ");
INSERT INTO udu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sha/uul a’di iwuki’d mo dhala Baalhanaan a’di jin ta ya/ ma Akbuur a’di ijiki’da ji i embul piti mo. ");
INSERT INTO udu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baalhanaan a’di jin ta ya/ ma Akbuur a’di iwuki’d mo dhala Hadaar a’di ijiki’da ji i embul piti mo dhali gway gi ’peŋkuman bampam piti mo tani a’di iyuḵkunu gway ka P̱a/u mo. Ash yuḵkunu gway ka Mahithab/iil mo a’di jin ta ’bwa/ ma Mathrid mo a’di jin ta ’bwa/ ma Maadahab mo. ");
INSERT INTO udu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Uni gwansan ita gway itap̱a uc̱i ma Iisu mo isi me’d jin tana uni awaḵ buni mo dhali moŋ’kom buni jin ’kona uni mmoyer mo gway ki she/ ki she/ mo. Itap̱a ita iTimnaa/ mo dhala Alwaah mo dhala Yatiit mo. ");
INSERT INTO udu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Uhulibaamah dhala Iilah dhala P̱inun mo. ");
INSERT INTO udu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Ganaas dhala Temaan dhala Mibsar. ");
INSERT INTO udu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Majdi/iil dhala Iraam uni gwansan ita itap̱a ’Kwani Aduum (a’di Iisu jin ta’da baba gi ’Kwani Aduum mo) mo isi me’d moŋ’kom buni mo e mony’cesh jin takina uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakuub c̱a’bki’d mo e mony’cesh jin takina coma c̱a/ ap̱o/ mo e bampa/ gi Paŋ Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yansan a’di ita gwo jin beledhu goma waḵ ma Yakuub mo. Yuusup̱ a’di ’kona yili ’kume’d i’ce’dka pesu/ ap̱o/ mo me’d jin urkina a’di ama’diny ḵa’bal nyaḵki ikam mo. A’di ta’da ’ci nyaḵki iya/ ma Bilhah dhala Silp̱ah mo uni kun ta up̱ ki com mo, dhala Yuusup̱ ḵalki’da ris gwon thus kun thama ikam a’di imii mmoṯor ababam buni mo. ");
INSERT INTO udu_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Dhala Israyiil a’di enki’da Yuusup̱ kagahara mmobol uc̱im pitin tiya e mo haali/ a’di ta ya/m piti jin tana a’di ka dhan piti mo. Dhali a’di shoki a’di burrinyen turga/ jin tur ma bi ki tur mo. ");
INSERT INTO udu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Hili ki ikam p̱arki mo e ka babam buni enki a’di kagahara mo mmobol ikam piti e mo tani uni shi/ki a’di i e mo dhali ’te bwa mmoṯora ṯor nyaḵki a’di ki moŋḵu’th is mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Dhala Yuusup̱ shu’bki jan mo dhali ki a’di ṯorki ikam gwo mo tani uni ki thisi ’cur ’pen ishi/ki a’di i e ki nyanye/ mo. ");
INSERT INTO udu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A’di oki uni gwo mo ki: Ciḵi gwony jan jin shu’bka/ mo ma. ");
INSERT INTO udu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Hili mo mo ma, ana ’kokina mmodeḵ deḵken pos e bwam bunto mo dhali hili mo mo ma, deḵken pos pem a’di icuki mis mo dhali dosh ka ji sho’k mo dhali hili mo mo ma, deḵken pos bum uni tulki isi monṯal ’de/ ijim pem mo dhali goŋ is ka ’cesh mmoluŋ deḵken pos pem mo. ");
INSERT INTO udu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ikam piti o a’di gwo mo ki: A/e ka jiŋ gana/ mini ji/a ji ap̱o/ aman mowa? Walla a/e mini ta tap̱a ap̱o/ aman mowa? Wakan uni shi/ki, a’di i e ki nyanye/ mo gom gwony jan piti mo dhali gom gwom piti mo. ");
INSERT INTO udu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Dhali yan’ko’d a’di shu’bki jana kamu/ mo dhali ṯorki a’di ikam mo dhali o gwo mo ki: Hili mo mo ma aha/ shu’bkina jana kamu/ mo dhali hili mo mo ma, atente/ dhali appe mo dhali acul kun ’koni ’kume’d i’ce’dka ’de/ ap̱o/ mo tani uni ’kokin mo mmogoŋ is ka ’cesh mo mmoluŋ aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Hili ki a’di ṯorki ’pemen jan yan ki com mo dhali ikam piti mo tani ababam piti a’di iḵucurki a’di mo dhali o a’di gwo mo ki: Jan yan ta’da ta mo jin shu’bkina /e mo? A/aha/ dhali kwan dhali ikam pini ka jiŋ gana/ mina iiku/ mo dhali ’ko is bam ki goŋgo/ ibwambori /e mowa? ");
INSERT INTO udu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Dhali ikam piti uni ṯaca bwa gom a’di mo hili ababam piti a’di idhuki gwo gwansan ibwa mo. ");
INSERT INTO udu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Dhali ikam iikin mo mmoc̱iya ma’diny ḵa’bal gi com ashon dhii/i’d mo mmo’dish Pan Shakiim is mo. ");
INSERT INTO udu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Dhala Israyiil oki’da Yuusup̱ gwo mo ki: Ikam pini ’koki ura ma’diny ḵa’bal mo mmoc̱iya shon dhii/i’d mmo’dish Pan Shakiim is mo ’taa? Yayu/ mo, aha/ mina hash /e i uni mo. Dhali a’di thoḵki a’di gwo mo ki: Aha/ dina imahan mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Wakan a’di oki a’di gwo mo ki: Yayi mo shwane/ dhali p̱ar mo e mo waḵki/ ikan ’kon ki ’bore/ mo dhali nyaḵka ma’diny ḵa’bal mo dhali ḵalaa/ gwo ka nyaŋ’ko’d mo. Wakan a’di hashki a’di mo ’peni embul wosh ma Habruun mo dhali a’di p̱u’dki’d mo e Pan Shakiim mo. ");
INSERT INTO udu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Dhali wathiŋ kamu/ gamki a’di mo mmomaŋaskina a’di mo e mombwaasho mo dhali wathi/ doṯki a’di gwo mo ki: /E ŋap̱kina tinta mo? ");
INSERT INTO udu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Aha/ ŋap̱kina ikam pem mo. A’di oki gwo kan mo mmo/o ki: Ṯoraa/ mo ma, aha/ ’thona /e mo, mane mom buni jin c̱ina uni ama’diny ḵa’bal ashon dhii/i’d mo? ");
INSERT INTO udu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Dhali wathi/ thoḵki a’di gwo mo ki: Uni iikin mo haali/ aha/ ciḵa ṯor jin ṯorkina uni mo mmo/o gwo mo ki: Dhalki ana iina mo e Pan Duṯẖan mo. Wakana Yuusup̱ baṯẖki ikam isho’k mo dhali gam uni e Pan Duṯẖan mo. ");
INSERT INTO udu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Uni mishki a’di ’pena dhana/ ki si’d si’d mo dhali nṯwa/a/ ki a’di p̱u’dki’d mo mmo’dish uni is mo tani uni gamki ’twa/ ’kup̱ mo mmo’kosh a’di jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Uni oki gwo ka rem’kup̱ mo ki: Amanshu’b jana ac̱aan a’di ip̱u’dki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Iiyu/ mo shwane/ dhalki ana ’kosha a’di jwa mo dhali biṯ a’di mo e jis ’deŋ kamu/ mo dhali yan’ko’d ana mina o gwo mo ki: A’di ’kosha toŋgwap̱i/ jin shwan ma nyor jwa mo dhali ana mina p̱ar mo e mo ’pemen jan piti yan midi wakata mo? ");
INSERT INTO udu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Hila Ra/ubiin ciḵki gwo yan mo tani a’di ’cuḵki a’di mo ’peni me’d buni mo dhali o gwo mo ki: Dhalkina ki ’kosh mondiki/em piti mo. ");
INSERT INTO udu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Dhali Ra/ubiin oki uni gwo mo ki: Dhalki a’diya bas ki p̱o mo. Biṯi a’di e jis yi’de/ gwan kun ’kon e mombwaasho mo hili dhalki me’d bum ki dhu ap̱o/ a’di mo, ki a’di midi ’taki ye a’di mo ’peni me’d buni mo mmowar a’di is mo goma babam piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wakana Yuusup̱ me’d jin p̱u’dkina a’di e ikam piti mo tani uni ’cuḵki a’di burrinyen turga/ ’peni is mo a’di jin ta burrinyen turga/ jin tur ma bi ki tur jin hi’thkina a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Dhali uni bu’thki a’di mo dhali biṯ a’di e jis yi’de/ mo. Jis yi’de/ yan a’di idi bwa ’te/ mo, yi’deŋ kamu/ yisa di’d nycineya. ");
INSERT INTO udu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Dhali uni ’kokina ’cesh mo mmoshwa to mo dhali uni ’de’kki em buni ’kup̱ ki mis mo tani uni p̱arkina dhana ŋul’kup̱ ’Kwani ma Isma/iil e mo mmop̱u’du/ mo ’peni Pany Jil/aad mo nyaḵka ris kalman buni mo mmoḵala ’bi’c mo dhala ’bi’c ’peni cwa jin yuḵu ka balsam mo dhali cwa jin yuḵu ka murr mo mmo/iikina uni mo mmo/ii e bway buni bway Pa Masir mo mmoḵal uni ka luŋgu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Dhala Yahuuda oki ikam gwo mo ki: Miim ’boro’d jana mina ana gam mo waḵki/ ana mina ’kosh a’di jwa mo dhali diḵa bas piti e mo. ");
INSERT INTO udu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Iiyu/ mo dhalki ana yola a’di mo e ’Kwani ma Isma/iil mo dhali dhalku/ me’d bana ki dhu ap̱o/ a’di mo haali/ a’di ita’da kam bana mo, a’di jin ta buŋgwar is bana mo. Dhali ikam piti c̱ikina hirdhe/ ki gwom piti mo. ");
INSERT INTO udu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Dhali ’Kwani Midyaan kun ta imanyol to mo si’da/ iikin ki iimpe mo dhali dirkina Yuusup̱ ka pije/ mo dhali ’de’k a’di ka pije/ ’peni jis yi’de/ mo dhali yolki a’di mo e ’Kwani Isma/iil mo ka guurush jin ’koni iss ’de/ mo a’di jin ta ’dolkon kush mo dhali uni suskina Yuusup̱ bway Pa Masir mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ka Ra/ubiin doḵki’d ka nyaŋ’ko’d e jis yi’de/ mo tani dhali p̱ara Yuusup̱ e ki a’di diki di ijis yi’de/ mo tani a’di dherki burrinyem piti bwa mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Dhali a’di doḵki’d ka nyaŋ’ko’d e ikam piti mo dhali o gwo mo ki: Ari dhuru’c wathi/ a’di p̱iki’d mo dhali aha/ mo mane mo jin miga/ ya mo? ");
INSERT INTO udu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Uni bu’thki burrinye/ ma Yuusup̱ mo dhali ’kosh mi jwa mo dhali biṯ burrinyen turga/ yan eya bas mo. ");
INSERT INTO udu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Dhali uni ki hash burrinyen tura bi yan mo dhali ḵali a’di eya babam buni mo dhali o gwo mo ki: A’di yan gamkina aman mo. P̱ari a’di e mo shwane/ waḵki/ a’di ta ji gi ya/m pini mo walla yisa. ");
INSERT INTO udu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Dhali a’di nyiṯẖki a’di mo dhali o gwo mo ki: A’di ta burrinyen turga/ gi ya/m pem mo. A’di be ’koshkina toŋgwap̱i/ mo ’te/ be. Gwo jin minu dhaŋ goma Yuusup̱ p̱iyi’d mo haali/ a’di idherkina to bwa ka gwap̱i/ mo. ");
INSERT INTO udu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Dhali yan’ko’da Yakuub dherki burrinyem piti bwa mo dhali deḵ burrinyen shawaal e empa’d piti mo dhali ko gom ya/m piti acim ka ris ris mo. ");
INSERT INTO udu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Aris iya/m piti dhali aris i’bwa/m piti cuki mis mo mmomalas a’di mo tani hili a’di ushki’d mo ki a’di minu malas mo dhali o gwo mo ki: Yisa. Aha/ mina ya ka luŋgu’b eya Haawiya mo gom ya/m pem mo. Koŋ gana/ jin gwona ki kony jwa mo a’di idosh ’peni o’d kan mo. Wakan com gwoki’d gom a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ki ari embul mo ari’ceenne/ mo tani ’Kwani Midyaan yolki a’di mo e Pa Masir mo eya P̱uthip̱ar a’di jin ta wathi/ jin cil ma askar goma P̱irawn mo a’di jin ca’d ki ’kwani ma mee kun jina ji mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A’di bu’thki embul ka cim c̱aan mo ka Yahuuda a’di yaki’d ka luŋgu’b mo ’peni ikam piti mo dhali a’di ṯu’kki’d mo e moŋkamu/ mo dhali gam Wathi/ gi Pa Adullaam ’kup̱ mo a’di jin yuḵkunu gway ka Hiirah mo. ");
INSERT INTO udu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","E mun mo tani aYahuuda mishki ’bwa/ gi ’Kwaniŋ Kanaan mo jin yuḵkunu gway ki Shuu/ mo. A’di mashki a’di mo dhali ya gu’b ma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Dhala yim bwaaki’d mo dhali dho’th ya/ mo dhali a’di ki yuḵ a’di gway ka Iir mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Doḵ/e ayim bwaaki’d mo dhali dho’th ya/ mo dhali ayim ki yuḵ a’di gway ka Unan mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Naskina/ doḵ/e ayim dho’thki ya/ mo dhali ayim ki yuḵ a’di gway ka Shiilah mo. Ayim diki’d e Paŋ Kasiib mo me’d jin dho’thkin ma yim a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Dhala Yahuuda si’da/ gamki’da ’bom goma Iir jin ta’da bwanyaram piti mo, dhala yim yuḵu ka Ṯẖamar. ");
INSERT INTO udu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Hili Iir jin ta’da bwanyara/ ma Yahuuda mo tani a’di ta thus ki thus e jis/e gi Tap̱a mo dhali Tap̱a ’koshki a’di jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Dhali yan’ko’da Yahuuda oki’da Unan gwo mo ki: Mashi asha kam pini mo mo ma, dhali miiyi mii mo jin minu mii mii mo gom marem pini mo, dhali c̱is uc̱i goma kam pini mo. ");
INSERT INTO udu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Hila Unan nyiṯẖki’d ka ’ci jin mina a’di ic̱is mo tani midi diki ta jim piti mo. Wakan ki a’di yaki bway gu’b e asha kam mo tani a’di wolki’da ’co/ piti eya ’cesh mo isi ciki/ ki a’di midi diki c̱is uc̱i goma kam mo. ");
INSERT INTO udu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Dhali mii jin miikina a’di wakan mo tani a’di diki ’bor e jis/e gi Tap̱a mo dhali a’di si’da/ ’koshki a’di jwa mo. ");
INSERT INTO udu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Dhala Yahuuda oki’da Ṯẖamar gwo mo a’di jin ta’da mar pitim ’bomi gwo mo ki: Diyi ka dhalla/ e gu’b ki cim mo ntaga Shiilah jin ta ya/m pem midi ca mo. Haali/ a’di ḵo/ki is mo oki a’di midi wu mo me’d ikam mo. Wakana Ṯẖamar a’di yaki’d mo dhali c̱a’b e gu’b gi com mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ŋ’ko’d mo tani mo p̱u’du’d mo ki ’bwa/ ma Shuu/ jin ta asha Yahuuda a’di iwuki’d mo dhali ka Yahuuda malaskunu mo tani a’di yaki’d mo e Pan Timnah mo eya manhil ḵa’bal piti mo a’di dhala mugum piti ka Hiirah mo jin ta Wathi/ gi Pa Adullaam mo. ");
INSERT INTO udu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Dhali ka Ṯẖamar ṯorkunu gwo ka mar piti a’di yaki’d mo e Pan Timnah mo mmo’ciṯẖ ḵa’bal piti amur mo tani, ");
INSERT INTO udu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ayim ’cuḵki burrinyem ma dhallam piti ’peni is mo dhali hi’th burrinye/ jin kumu ’kup̱ mo dhali ’tam is ma yim ki burrinye/ mo dhali c̱a’b e shemen bway ma Eenaayim a’di jin diki’d ’kup̱ ki bway gi Pan Timnah mo haala yim mishki mo mo ka Shiilah a’di caki’d mo dhali a’di ayim dinuki c̱i ki a’di mmomash mo. ");
INSERT INTO udu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ka Yahuuda p̱arki’da yim e mo tani a’di kulumki’da yimi bwa mo oki a’di ta’da ’bom c̱al mo haali/ ayim a’di kumki jis/em piti mo. ");
INSERT INTO udu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A’di yaki’da yim mo e shemen bway mo dhali o a’di gwo mo ki: Yayu/ mo dhalki aha/ yana /e gu’bi is mo, haali/ a’di diki misha yim mo ki a’di ta’da mar piti mo. Ayim ki o a’di gwo mo ki: Atinta a’di imina /e ic̱i aha/ mo ki /e mini yayu/ i aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A’di ki thoḵ a’di gwo mo ki: Aha/ mina c̱iki /e ari mi mo ’peni bwaman ma ma’diny ḵa’bal mo. Dhala yim ki o a’di gwo mo ki: Mina /e diki c̱iyaa/ jamas mii mo ntagi /e mini hashi a’di mowa? ");
INSERT INTO udu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A’di thoḵki gwo mo ki: Jamas mii gi wakata imiga/ c̱i /e mo? Ayim thoḵki gwo mo ki: To me’d pini dhali dheŋdhenye/ jin ’kon ma ashu ipesu/ mo dhali cwa jin di’di me’d pini mo. Wakan a’di c̱iki’da yim uni mo dhali ya ayim gu’bi is mo dhali ayim bwaaki’d ki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Dhali yan’ko’da yim cuki mis mo dhali ya mo dhali ayim bu’thki burrinyeŋ ’kup̱ piti mo dhali hi’th burrinyem ma dhallam piti i is mo. ");
INSERT INTO udu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ka Yahuuda hashki ari mi ka mugum piti jin ta Wathi/ gi Pa Adullaam mo jin mina a’di bu’th jamas to mii ’peni me’d ma ’bom mo tani a’di diki gama yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Dhali a’di doṯki ’kwani gi mo yan mo ki: Mane a’bom c̱al yan mo a’di jin c̱a’bki’d e shemen bway gi Pa Eenaayim mo? Dhali uni thoḵki a’di gwo mo ki: A’bom c̱ala kamu/ yisa di’di mahana. ");
INSERT INTO udu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Wakan a’di doḵki’da Yahuuda ka nyaŋ’ko’d mo dhali o a’di gwo mo ki: Aha/ dinaki gama yim mo dhali ’kwani gi mo yan o gwo si’da/ ki a’bom c̱ala kamu/ yisa di’di mahana. ");
INSERT INTO udu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuuda thoḵki gwo mo ki: Dhalka yim dhu to gwan gom is pitiŋ gana/ mo isi ciki/ ana mina ’kwani ip̱e’th mo. /E mishini ki aha/ hashkina ari mi yan mo dhali /e diki gama yim mo. ");
INSERT INTO udu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","’Ko’da ppe kwara ŋ’ko’d mo Yahuuda ṯorkunu gwo mo ka Ṯẖamar jin ta’da marem pini a’di lo’bki’di miinyc̱al mo dhali shwane/ ayim a’di bwaaki’da ’ci ki miinyc̱al mo. Dhala Yahuuda oki gwo mo ki: Guya ayim ka pije/ mo dhali dhalka ayim c̱idhu ki o’d mo. ");
INSERT INTO udu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Dhali me’d jin ’koyunu mmoḵala ayim ka pije/ mo tani ayim hashki gwo eya mar pitiŋ gwaṯẖ mo ki: Wathi/ yan jin cilkina to gwansan mo tani a’di ta wathi/ jin bwaakika/ a’ci mo. Dhala yim oki gwo mo ki: Nyiṯẖi jamas to gwansan mo aha/ ’thona /e mo. To gwansan uni ta kuma ja mo tome’d dhala dheŋdhenye/ kun ’kon ma shu ipesu/ mo dhali cwa mo. ");
INSERT INTO udu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Dhali yan’ko’da Yahuuda nyiṯẖki uni mo dhali o gwo mo ki: Ayim a’di iboli aha/ e ki mii ma ḵar/e e mo haali/ aha/ dinaki c̱iya yim ki ya/m pem ka Shiilah mo. Dhali a’di diki ish nyaḵka yim doḵ/e mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Dhali ki mo p̱u’dki’d mo jin min ma yimi dho’th mo tani ushi uc̱i ’koni su/ e bwa ma yim mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dhali ka yim shwan ma ’ci mo tani jan ṯal ’de/ karki me’d ka pije/ mo dhali a’bom jin karu mmowoṯẖa woṯẖ mo gom mondho’th up̱ mo tani a’di deḵki me’d piti ka thus ’per mo mmo/o gwo mo ki: Yansan a’di ip̱u’dki’di ṯwa/a/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Hili ki a’di doḵki me’d piti bway bwa mo tani hili mo mo ma, akam piti p̱u’dki’d ka pije/ mo dhala yim ki o gwo mo ki: Awanyam pini jin p̱u’dkina /e ka pije/ ki is pini mo tani isa wa’da. Wakan a’di iyuḵkunu a’di gway mo ka P̱aaris mo. ");
INSERT INTO udu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Dhali yan’ko’d akam p̱u’dki’d mo ka thus ’peri me’d piti mo dhali gway piti yuḵkunu ka Saarah mo be. ");
INSERT INTO udu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Dhali aYuusup̱ a’di isuskunu ka luŋgu’b e Pa Masir mo dhala P̱uthip̱ar jin cil ma askar goma P̱irawn dhali wathi/ jin cil ma askar kun jina ji mo gom ’Kwani Masir mo a’di yolki a’di ’peni ’Kwani Isma/iil mo uni kun ḵalki a’di ka luŋgu’b ’peni mun mo. ");
INSERT INTO udu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Dhali Tap̱a nyaḵki di ka Yuusup̱ mo dhali a’di warki’d ki wathi/ jin hana mii me’d mo dhali a’di diki’d e gu’b gi tap̱am piti jin ta Wathi/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Dhali tap̱am piti mishki mo mo ki Tap̱a nyaḵki di ki a’di mo dhali ki Tap̱a raḵki’da ris mii jin mina a’di ha me’d mmorusa/ rus mo. ");
INSERT INTO udu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Wakana Yuusup̱ gamki mii ma ’the e jis/em piti mo dhali buḵ a’di ’pen ka pije/ mo dhali a’di ki kar a’di mmota amanhil to gom gu’b mo dhali kar a’di ki tap̱a ap̱owa ris tom piti jin tana a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","’Pena cim yan jin karkina a’di a’di mo mmota amanhil to gom gu’b piti mo dhali kar a’di ki tap̱a ap̱owa ris tom piti jin tana a’di mo tani Tap̱a ’borki ’kwani gi gu’b gi Wathi/ Masir mii mo gom gway ma Yuusup̱ mo. Dhali mom’bor mii gi Tap̱a diki’da p̱o/ aris to ’baar mo kun tana a’di mo e bwaŋ gu’b mo dhali e bwam bunto mo. ");
INSERT INTO udu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Wakan a’di dhalki’da ris to ’baar mo e me’d ma Yuusup̱ mmohil mo dhali mmodhalkina a’di a’di e me’d piti mo tani a’di yisa shwana jwa mo gom toŋ kamuwa, hili jasi gom tonṯe/ jin shwakina a’di mo. Dhala Yuusup̱ ŋala/ ’bora jaro/ ime’da/ a’di hili mo ki jis/e jin yesayes mo. ");
INSERT INTO udu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Dhali ki ara cima kamu/ mo tani a’bom gi tap̱am piti, ayim ’cemi’dki’da Yuusup̱ ki e mo dhali o a’di gwo mo ki: Ishi nyaḵki aha/ mo ma. ");
INSERT INTO udu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Hili a’di ushki’d mo dhali owa ’bom gi tap̱am piti gwo mo ki: Hili mo aha/ dhalkina tap̱am pem to ime’d mo dhali a’di dina jwa ki shwa mo goma ris to mo e gu’b mo kun dhalkina a’di aha/ e me’d pem mo. ");
INSERT INTO udu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A’di diki caaca kagahara e gu’b yan mmobol aha/ e mowa. Toŋ kamu/ yisa ’tasha a’di aha/ ’twa/ mo yisa hili isi ciki/ is piniŋ gana/ mo haali/ /e ta ashim piti mo. Aha/ mina mish dhan miinthus yan mii mo wakan mana dhali mii miinthus ap̱owa Arumgimis mowa? ");
INSERT INTO udu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ba dhala yim ṯorki’da ṯor ka Yuusup̱ isa yempa/ yempa/ mo dhali a’di ’tena bwa mmociḵ gwo ma yim mo mmo/isha ayim mo walla mmonyaḵ c̱a’b ka yim mo. ");
INSERT INTO udu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Hili ka cimi ’deŋ kamu/ mo me’d jin yakina a’di gu’b mo mmomiiya ṯu’c piti mo dhali ’kwanin tiya yisa ’koni bwaŋ gu’b yisa uni kun miina ṯu’c e gu’b mo tani, ");
INSERT INTO udu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ayim bu’thki a’di e burrinyem piti mo mmo/o a’di gwo mo ki: Ishi nyaḵki aha/ mo. Hili a’di dhalki burrinyem piti e me’d ma yim mo dhali gus mo dhali p̱u’d ka pije/ ’peni gu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Dhali ka yim p̱arki mo e mo ki a’di dhalki burrinyem piti e me’d ma yim mo dhali p̱u’d ka pije/ ’peni gu’b mo tani ");
INSERT INTO udu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ayim yuḵ ’kwani gi kuŋ gu’b ma yim mo dhali o uni gwo mo ki: Hili a’di guyi Wathi/ Ibraan yan e bwam ana mo mmosor ana mo. A’di seyi bwaŋ gu’b mo dhali di ki gwo ibwa mo mmo/ish nyaḵki aha/ mo dhali aha/ cuukina ki dhan ’twa/ jin caaca mo. ");
INSERT INTO udu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Dhali ki a’di ciḵki gwo ki aha/ ’deka ’twam pem ki mis mo dhali cuu mo tani a’di dhalki burrinyem piti i aha/ mo dhali gus mo dhali p̱u’d ka pije/ ’peni gu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Dhali yan’ko’da yim karki burrinyem piti e me’d ma yim mo ntagi tap̱am piti p̱u’dki’di pa mo. ");
INSERT INTO udu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Dhali ayim ṯorki a’di gwo jin nyaḵka’d mo mmo/o ki: Wathi/ Ibraan yan jin ta c̱iŋkina/ a’di jin suskina /e ibwaman ana mo p̱u’dki’di aha/ mo mmosor aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Hili me’d jin ’de’kkika/ ’twam pem ’kup̱ki mis mo dhali cuu mo tani a’di dhalki burrinyem piti e aha/ mo dhali p̱u’d ka pije/ ’peni gu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ki tap̱am piti ciḵki gwo ’peni ’twa/ gi ash mo ki: Mii a’dan jin miikina c̱iŋkinam pini jan aha/ mo tani anyor piti ’batha’ba’th mo. ");
INSERT INTO udu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Dhali tap̱a ma Yuusup̱ bu’thki a’di mo dhali kar a’diya sijin mo e mo jin ṯa’kkunu habuus ma maliḵ nycine/ mo dhali a’di diki’da sijin imun mo. ");
INSERT INTO udu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Hili Tap̱a a’di nyaḵki di ka Yuusup̱ mo dhali ṯor a’di mo/en piti jin ṯelu sho’k mo dhali c̱i a’di mii ma ’the i jis/e ma manhila sijin mo. ");
INSERT INTO udu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Dhali amanhila sijin c̱iki’da Yuusup̱ gwo ime’d mo mmota amanhil ’kwani ma sijin i’baar mo uni kun ’kokina sijin mo. Dhali aris mii gunn kun miinu mo tani a’di ki mii uni mo. ");
INSERT INTO udu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Dhali amanhila sijin mo tani a’di c̱ina hirdhe/ yisa ki mii gunn kun miin ma Yuusup̱ mo mmohila hil mo haali/ Tap̱a nyaḵki di ki a’di mo dhali eya ris to gunn kun miina a’di mo tani Tap̱a dhuki uni mmorusa/ rus mo be. ");
INSERT INTO udu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ka cima kamu/ ’ko’di mii yan mo tani tap̱a jin karu mmohil ’kwani kun miina ṯu’c e gu’b ma maliḵ gi ’Kwani Masir mo dhali aman’coḵ maam piti mo tani uni thamki to mii mo gom tap̱a maliḵ Masir buni mo. ");
INSERT INTO udu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Dhala P̱irawn shwaki’da nyor gom ’kwani kun can ka askar piti su/ gwan mo, tap̱a jin karu mmohil ’kwani kun miina ṯu’c e gu’b ma maliḵ mo dhali aman’coḵ maam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A’di dhuki uni eya sijin mo e gu’b gi wathi/ jin ca’d gom ’kwani ma mee kun jina ji eya sijin mo jin di’di bwaŋ’kwariny mo jin dikin ma Yuusup̱ nycine/ mo. ");
INSERT INTO udu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Wathi/ jin ca’d gom ’kwani ma mee kun jina ji mo tani a’di ḵanki’da Yuusup̱ gwo mo gom uni mo dhali a’di miiki uni to mo dhali uni ’kon ki mondeḵ is mo ki sule/ sule/ ntaga cima kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Dhali mon’thinya kamu/ mo tani uni su/ shu’bki jan mo a’di jin ta tap̱a gom ’kwani kun miina ṯu’c mo dhali a’di jin ta’da man’coḵ maa goma maliḵ ’Kwani Masir mo uni kun ’kokin e bwaŋ’kwariny ma sijin mo uni ita gi jan buni ki she/ ki she/ mo dhali ’pemen jan buni ’kon ki she/ ki she/ mo. ");
INSERT INTO udu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ka Yuusup̱ p̱u’dki’di uni mon’thamo/ mo tani dhali p̱arki uni e ki uni ṯocu ’kus mo. ");
INSERT INTO udu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Wakan a’di doṯki ’kwani ma mee ma P̱irawn uni kun nyaḵ ’ko ki a’di e mo jin deḵuwa deḵ mo e gu’b gi tap̱am piti mo ki: Atinta iṯaka um jis/em bum ka luŋgu’b kan ganne/ mo? ");
INSERT INTO udu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Uni ṯorki a’di gwo mo ki: Aman takina ki jan mo dhali wathi/ p̱iyi’d jin midi ṯor ’pemen buni mo. Dhala Yuusup̱ thoḵki uni gwo mo ki: Dina mo jin ṯoru ’pemen jan ki ta kuma Arumgimis mowa? Ṯori uni ki aha/ mo ma aha/ ’thona um mo. ");
INSERT INTO udu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wakan tap̱a jin karu mmohil ’kwani ma ṯu’c ṯorki jan piti ka Yuusup̱ mo dhali a’di oki a’di gwo mo ki: E jan pem mo tani cwalmana mura’th uni ’kokini bwambori aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Dhali ap̱o/ cwalmana mura’th mo tani abi karkini kwara e a’di mo dhali me’d jin lu/kina a’di mo tani jandim piti c̱a’bki’d ki ṯup̱ ṯup̱ mo dhali atora mura’th iski’d mo jin minu ’ciṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Aḵubbaaya ma P̱irawn diki’d e me’d pem mo dhali aha/ bu’thkina amura’th mo dhali nyu/ uni e bwam ma ḵubbaaya ma P̱irawn mo dhali karka/ aḵubbaaya e me’d ma P̱irawn mo. ");
INSERT INTO udu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Dhala Yuusup̱ thoḵki a’di gwo mo ki: ’Pemen jan a’dan be: cwalman ma mura’th kun ’koni kwara mo tani a’di ita’da cimi kwara mo. ");
INSERT INTO udu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","E bwaman ma cimi kwara yan mo tani aP̱irawn midi ’de’k ’kup̱ pini ki mis mo dhali wari /e is mo mmodoḵa ṯu’c pini ka nyaŋ’ko’d mo dhali /e mini dhuwa P̱irawn aḵubbaaya e me’d piti mo me’d jan dhamo/ mo me’d jin karkunu /e mmota tap̱a gom ’kwani kun miina ṯu’c mo. ");
INSERT INTO udu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hili /e mini mii kayaa/ e mo ki mii midi mii ha me’d mo gom /e mo dhali miiyi aha/ ki mii gi bwaŋkush mo, aha/ ’thona /e mo jin mina /e mii pika P̱irawn gwo yan i is gom aha/ mo dhali wakan /e mini ’cuḵaa/ ka pije/ ’peni gu’b yan mo. ");
INSERT INTO udu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Haali/ aha/ ka jiŋ gana/ ḵwalkunu mo ’peni Paŋ ’Kwani Ibraan mo dhali e mahan si’da/ mo tani aha/ dinaki mii toŋ kamu/ mo jin mina uni kar aha/ e jisa ’tum yan mo. ");
INSERT INTO udu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ki tap̱a jin ta’da man’coḵ maa mo p̱arki ’pemen jan yan e ki uni ha me’d mo tani a’di oki’da Yuusup̱ gwo mo ki: Aha/ si’da/ tana gi jan mo. Maaŋḵuthu’d kun ḵalka/ ka nura/ ikwara mo tani uni ’koni ’kup̱i aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dhali e ’kup̱an ma nura/ mo tani aris maaŋḵuthu’d tana eya ris ka ris mo goma P̱irawn mo hili aris ’dii ’kokin mo mmoshwa uni mo ’peni bwam ma nura/ e ’kup̱i aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Dhala Yuusup̱ thoḵki a’di gwo mo ki: ’Pemen jan a’dan be: anura/ kun ’koni kwara mo tani a’di ita’da cimi kwara mo. ");
INSERT INTO udu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","E bwaman ma cimi kwara yan mo tani P̱irawn midi ’de’k ’kup̱ pini ki mis mo ’peni /e mo dhali /e minu shir ka ’cajala/ ap̱o/ cwa mo dhali aris ’dii mini ’ka shum gi buŋgwar is ’peni /e mo. ");
INSERT INTO udu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ka cimi kwara a’di jin ta’da cim jin dhodhuwa P̱irawn mo tani a’di yuḵki’da yuḵ jin yuḵu ’kwani mmotul ’kup̱ mo goma ris ’kwanim piti kun miina ṯu’c mo dhali a’di ’de’kki ’kup̱ gi wathi/ jin ta tap̱a gom ’kwani ma ṯu’c gi gu’b ma maliḵ mo dhali ’kup̱ gi wathi/ jin ta’da man’coḵ maa mo e bwaman ’kwanim piti kun miina ṯu’c mo. ");
INSERT INTO udu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A’di warki wathi/ jin ta tap̱a jin karu mmohil ’kwani ma ṯu’c gi gu’b ma maliḵ is mo dhali a’di karki’da ḵubbaaya e me’d ma P̱irawn mo. ");
INSERT INTO udu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Hili a’di shirki tap̱a jin ta’da man’coḵ maa ’kus ka shi/ mo me’d ’pemen jan jin ṯorkin ma Yuusup̱ uni mo. ");
INSERT INTO udu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Dhali wathi/ jin karu mmohil ’kwani kun miina ṯu’c e gu’b ma maliḵ mac̱a/ ya’di ka aYuusup̱ e mo yisa hili a’di thiski a’di e mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","’Ko’di yili su/ gwansani ’baar mo tani P̱irawn a’di shu’bki jan mo ki a’di doshki’d e shemen Yi’deŋ Ḵumma/ Niil mo. ");
INSERT INTO udu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Dhali hili mo mo ma, bip̱ ’koni pesu/ kun pikin ka pije/ ’peni ḵumma/ yi’de/ mo kun yesa buŋgwar is ki yes mo dhali kun ’thiḵa’thiḵ mo dhali uni shwakina lup̱e/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Dhali hili mo mo ma, bip̱ ’koni pesu/ kun ’bwaṯala’bwaṯal mo dhali kun korakor mo pikin mo ’peni Yi’deŋ Ḵumma/ Niil mo dhali doshkin mo nyaḵki bip̱a tiya mo e yana gap̱ Yi’deŋ Ḵumma/ Niil mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Dhali uni gwansan kun ’bwaṯala is ki ’bwaṯal dhali kun korakor mo tani uni ’kaki uni gwansan kun yesa buŋgwar is ki yes mo dhali kun ’thiḵa’thiḵ mo. Dhala P̱irawn a’di merki e mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Dhali a’di ’ce’dkina e mo dhali shu’bki jan jin ’kon ma p̱o/i su/ mo doḵ/e dhali hili mo mo ma, awusham pos ’koni pesu/ mo kun dwama e ki dwam mo dhali kun ’bora’bor mo uni cakin mo e cwalman ’de/ nyaḵki uni ma ’de/ ’deṯe/ gwan mo. ");
INSERT INTO udu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Dhali hili mo mo ma, ŋ’ko’d unim pesu/ gwan waski ’kup̱ mo, uniŋ korga/ dhali kun ’ce’dkina ’ce’d ki ’tham gi mom’pesho’k mo. ");
INSERT INTO udu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Dhali pos kun tawash ma wusha/ ki tawash mo tani uni a’di iloski pos kun ’koni pesu/ kun dwam ma wusha/ e ki dwam mo dhali kun bocora e ki bojor mo. Dhala P̱irawn merki e mo dhali hili mo mo ma a’di ita jan mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Wakan mon’thamo/ mo tani shi/in piti ṯo’ckunu ’kus mo dhali a’di hashki gwo mo dhali yuḵa/ yuḵ goma ris ŋaariŋ ’Kwani Masir mo kun ṯori gwo ki ’twaŋ gwocon mo dhali aris ’kwanin yuḵga/ mo, dhala P̱irawn ṯorki uni jan piti mo. Hili jan ’deŋ kamu/ yisa di’da a’di jin mishi ’pemen jan ka P̱irawn ṯor mo. ");
INSERT INTO udu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Dhali yan’ko’d tap̱a jin karu mo mmohil ’kwani gi gu’b ma maliḵ oki’da P̱irawn gwo mo ki: Aha/ kakina miim pem jin thamkika/ e shwane/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ka P̱irawn shwaki’da nyor ap̱o/ ’kwanim piti kun dhuna a’di aṯu’c mo dhali kar aha/ dhala man’coḵ maa e mo jin ’tashuwa ’tash ’twa/ mo e gu’b gi a’di jin ji’da ji mo tani, ");
INSERT INTO udu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","aman su/ shu’bkina jan ka cim ’de/ mo mon’thiny yin mo a’di dhali aha/ aman ka ’deṯe/ ’deṯe/ takina ki jan mo kun ’kona ’pemen buni ki she/ ki she/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Dhuru’c wathi/ Ibraan yan diki’d nyaḵki aman imun mo a’di jin ta’da manmii wathi/ jin ca’da ṯu’c mo gom a’di jin ji’da ji mo. Dhali ki aman a’di ṯorkina a’di gwo mo tani a’di ṯorki ’pemen jan bam mo. A’di theke’thki ’pemen jan ṯor ki ’bore/ e ’kwani su/ gwan isi me’d jan buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Dhali me’d jin ṯorkina a’di a’di ki aman mo tani wakan a’di p̱u’dki’d ki ’pemen gana/ mo dhali aha/ warkunu is mo mmodoḵa maktab pem mo dhali aman’coḵ maa a’di ishirkunu ka ’cajala/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Dhala P̱irawn a’di hashki gwo mo dhali yuḵa Yuusup̱ mo dhali uni suski a’di ki ’ta’b mo ’peni jisa ’tum mo dhali ki a’di ’thiki’da mur ’kup̱ mo dhali aḵ burrinyem piti e mo tani a’di p̱u’dki’di bwambor ma P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Dhala P̱irawn oki’da Yuusup̱ gwo mo ki: Aha/ takina gi jan mo dhali wathiŋ kamu/ yisa di’da jin mishi ’pemen piti ṯor mo dhali aha/ ciḵkina gwo mo gom /e mo ki me’d jin ciḵkina /e gwo gom jan mo tani /e mishki ’pemen buni ṯor mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yuusup̱ thoḵki’da P̱irawn gwo mo ki: A’di yisa ta aha/ mo. Arumgimis midi c̱iya P̱irawn gwon thoḵ jin ha me’d ki haŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Dhala P̱irawn oki’da Yuusup̱ gwo mo ki: Hili mo mo ma e jan pem jin shu’bka/ mo tani aha/ doshkina ap̱owa gap̱ Yi’deŋ Ḵumma/ Niil mo. ");
INSERT INTO udu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Dhali bip̱ ’koni pesu/ kun ’thiḵa’thiḵ mo dhali kun yesa buŋgwar is ki yes mo pikin ka pije/ ’peni ḵumma/ yi’de/ mo dhali uni shwakina lup̱e/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Dhali bip̱ ’koni pesu/ kun baṯẖi uni isho’k mo kun hatha’ko’d ki ha’th mo dhali kun ’bwaṯala is ki ’bwaṯal mo dhali uni korakor mo uni kun wakan yisa mishkika/ me’d ’deŋ kamu/ e bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dhali uniŋ korga/ dhali uni bip̱ kun ’bwaṯala is ki ’bwaṯal mo tani uni ’kaki bip̱ pesu/ gwan kun ’thiḵa’thiḵ kun ’koni ṯwa/a/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Dhali me’d jin ’kakina uni uni mo tani wathiŋ kamu/ yisa midi ’taki mish mo mowa mo jin ’kakina uni uni mo haali/ uni i’kokin ki ’bwaṯal kan naskina/ ’pena muŋ’kup̱ mo dhali yan’ko’d aha/ merkina e mo. ");
INSERT INTO udu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Aha/ si’da/ mishkina e jan pem mo awusham pos kun ’koni pesu/ mo uni kun cakin mo eya cwalman ’de/ nyaḵki uni ma ’de/ ’deṯe/ gwan mo kun dwama e ki dwam mo dhali kun ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Dhali awusham pos kun ’koni pesu/ uni ḵu’thkin mo mmokora kor mo dhali kun ’ce’dkina ’ce’d sho’k ki ’tham gi mom’pesho’k mo waski ’kup̱i ’ko’di uni mo. ");
INSERT INTO udu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Dhali uni wusham pos gwan kun korakor iloskina wusham posa dwamga/ gwan kun ’koni pesu/ mo. Dhali aha/ ṯorkina aris ŋaari/ gwan gwo mo uni kun ṯori gwo ki ’twaŋ gwocon mo, hili wathiŋ kamu/ yisa di’da jin midi ’taki be’daa/ gwo ’pen ka pije/ ki ’bore/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Dhali yan’ko’da Yuusup̱ thoḵki’da P̱irawn gwo mo ki: Jan ma P̱irawn mo tani a’di ṯal ’de/ mo be. Arumgimis be’dki’da P̱irawn gwo mo gom to jin murkina a’di i’dish ’twa/ mmomii mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bip̱a ’borga/ kun ’koni pesu/ mo tani uni a’di ita yil kun mini ’ko ipesu/ kun mini ’bora’bor mo dhali awushan dwamga/ kun ’bora’bor mo tani uni si’da/ ita yili pesu/ mo, jan a’di iṯala ’pen ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Dhali bip̱ kun ’koni pesu/ kun ’bwaṯala’bwaṯal dhali kun korakor mo kun p̱u’dkini ’ko’di uni mo tani uni a’di ita yili pesu/ mo dhala wusha/ kun tawasha tawash mo tani uni kun ta ’tham gi mom’pesho’k kun ’ce’dkina ’ce’d sho’k mo tani a’di si’da/ ita yili pesu/ jin mina ṯe/ i’kosha ’kosh mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","A’di a’dan be me’d jin ṯorkika/ /e aP̱irawn ka Arumgimis murki’da ṯora P̱irawn to jin i’disha ’twa/ a’di mmomii mo. ");
INSERT INTO udu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yil imidi ’ko ipesu/ jin mina tonṯe/ idho’th kagahara mo e bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hili ’ko’di uni mo tani adhan ṯe/ si’da/ midi cu mis i’kosh ’kwani ki yili pesu/ mo dhali aris to kun ishkin kagahara mo tani mina ’kwani iŋa mo be e bampa/ Masir mo. Adhan ṯe/ midi kup̱ bampa/ ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Dhali aris to kun tana ’kwani kagahara minu mol ’ban mo e bampa/ mo gom ’pemen gwon ṯe/ mo a’di jin midi baṯẖa/ baṯẖi ’ko’d mo haali/ ṯe/ a’di midi jwakaṯa du ki ’bi’th mo. ");
INSERT INTO udu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dhali jan ma P̱irawn kun shu’bkina a’di ka ’buḵum ’ban mo tani uni ta kun thosonkin ma Arumgimis mo dhali Arumgimis midi ṯor uni eya tente/ ki ’dishe/ san mo. ");
INSERT INTO udu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Dhali gom gwo gi wakan mo tani dhalka P̱irawn a’di kwany wathi/ jin midi ḵu’th is ki ’cese/ ’cese/ dhali wathi/ jin yuḵayuḵ mo dhali kari a’di ap̱o/ bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Dhalka P̱irawn di’b mii is mo mmodhu ’kwani ’pen ka pije/ mo mmota imanhil tonṯe/ ap̱o/ bampa/ mo dhali bu’th ’bwanu’b tonṯe/ kun ’kon ma p̱o/i mudhe’d kun gamkina ’Kwani Masir ka tee yan kun isha tonṯe/ ka enthus ki yili pesu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Dhali dhalki uni tula ris tonṯe/ is mo ’peni yila ’borga/ yan mo kun iiyin mo dhali dhuyi pos e me’d ma P̱irawn a’di jin cili mom’bi’th mo gom tonṯe/ goma ris ’peŋkuman bampa/ mo dhali dhalki uni dhu uni mo. ");
INSERT INTO udu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Dhali tonṯe/ minu ’tash ’twa/ mo ap̱o/ bampa/ gom yili pesu/ yan mo jin mina ṯe/ ibiṯa p̱o/ bampa/ Masir mo wakan ki ’kwani kun ’koni bampa/ yan mina ṯe/ diki ’ce’d sho’k mo. ");
INSERT INTO udu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Gwo yan ’thinuwa ’cesh mo tani a’di wame’d ’boro’da P̱irawn e ki ’bor mo dhali ’kwani si’da/ kun miina ṯu’c piti ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Dhala P̱irawn oki’da ris ’kwanim piti kun miina ṯu’c piti gwo mo ki: A/ana mina gam wathi/ jin wakansan ’peni mana mo a’di jin taki’d gi Shi/in ma Arumgimis mo? ");
INSERT INTO udu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Wakana P̱irawn oki’da Yuusup̱ gwo mo ki: Me’d jin ṯorkin ma Arumgimis /e aris to gwansani ’baar mo tani, wathiŋ kamu/ yisa di’da jin midi ḵu’th is ki ’cese/ ’cese/ dhali jin yuḵayuḵ wakansan me’d /e mo. ");
INSERT INTO udu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","/E mini ta tap̱a ap̱o/ gu’b pem mo, dhali aris ’kwanim pem uni mini nin is buni mo me’d jin mina /e iḵan uni gwo mo. Hili jasi gwo goma ḵursi ma maliḵ mo tani aha/ imina a’di icil dhali bol /e e ki ca kagahara mo. ");
INSERT INTO udu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Dhala P̱irawn oki’da Yuusup̱ gwo mo ki: Hili mo mo ma aha/ karkina /e mo ap̱o/ bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Dhali yan’ko’da P̱irawn bu’thki tome’d piti ’peni me’d piti mo dhali hi’thka Yuusup̱ e me’d piti mo dhali shum a’di ki burrinye/ ma maliḵ jin na’bulana’bul mo dhali hi’thki a’di ajindhiir ’dolkon i’bam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Dhali a’di karki a’di mmomera arabiya jin dira shumarum piti mo a’di jin ’kon ma p̱o/i su/ mo dhali uni ḵumki cuuwa/ ibwambori a’di mo ki: Luŋa luŋ ki jiŋ ’kup̱a’dup̱un mo ma. Nyc̱a/ a’di karki a’di ap̱o/ bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Doḵ/e P̱irawn oki’da Yuusup̱ gwo mo ki: Aha/ tana P̱irawn mo. Wathiŋ kamu/ yisa midi mii ’de’k me’di mis walla sho’k piti e bampa/ Masiri ’baar mo ki dar gi gwoŋḵan pini mo. ");
INSERT INTO udu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Dhala P̱irawn yuḵki’da Yuusup̱ gway ka Sap̱naat P̱aniih dhali c̱iki a’diya Asnaat mmomash mo a’di jin ta ’bwa/ ma P̱uthip̱aara/ mo a’di jin ta’da gasiis ma Uun mo. Wakana Yuusup̱ raski’d ki mis e bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yuusup̱ a’di ’kona yili iss ’de/ i’ce’dka ’kume’d mo me’d jin cic̱kina a’di e momii to ma P̱irawn jin ta’da maliḵ ’Kwani Masir mo be. Dhala Yuusup̱ yaki’d ka pije/ ’peni buŋ’kus ma P̱irawn mo dhali ya e bampa/ Pa Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ki embul yil pesu/ yan mo tani a’cesh dho’thki to ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Dhali a’di tulki’da aris tonṯe/ is mo ’peni yil pesu/ yan jin kap̱a ’pen ’kwani mo e bampa/ Masir mo dhali dhu uni e themes gi ’peŋkuman bampa/ mo. A’di si’da/ dhu e themes gi ’peŋkuman bampa/ ’peni bunto kun ’kam uni is mo. ");
INSERT INTO udu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Dhali aYuusup̱ dhuki posi themes ki nyanyeŋ gana/ ka enthus mo mmowa e ka si’b gi bwam ma gap̱ mo ntagi a’di daḵ uni bar mo haali/ a’di molu bar mo be. ");
INSERT INTO udu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nṯwa/a/ ki yil ṯe/ diki p̱u’d naskina/ mo tani aYuusup̱ a’di ita gi iya/ isu/ mo, uni kun dho’thkin ma Asnaat a’di jin ta ’bwa/ ma P̱uthip̱aara/ jin ta’da gasiis ma Uun mo. ");
INSERT INTO udu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yuusup̱ yuḵki gway ma ’ci ma bwanyaram piti ka Manassa mo haali/ a’di oki gwo mo ka: Arumgimis kar aha/ mmothisa ris mii kun diṯadiṯ e mo dhali aris to gi gu’b ma babam pem mo. ");
INSERT INTO udu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Dhali gway a’di jin ’kon ma p̱o/i su/ mo tani a’di yuḵki a’di gway ka Ep̱rayim mo: Haali/ Arumgimis karki aha/ mmoḵal mamana dho’th mo e bampa/ jin wo’ckina is aha/ she/ mo. ");
INSERT INTO udu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Yili pesu/ yansan jin kap̱a ’pen ’kwani a’di/ p̱iki gwo jip̱i/ mo e bampa/ Masir mo tani a’di ’baarki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Dhali yili pesu/ jin mina ṯe/ i’kosh a’di iṯelki ’pen mo me’d gwo jin okin ma Yuusup̱ mo. Dhan ṯe/ a’di caaca e bampany ’ceshi ’baar mo dhali hili e bampa/ Masiri ’baar mo tani tonṯe/ di’d mo. ");
INSERT INTO udu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ka ris ’kwanim bampa/ Masiri ’baar mo harki to mo tani ’kwani cuukin ’twa/a P̱irawn mo gom tonṯe/ mo dhala P̱irawn ṯorki ’Kwani Masir gwo mo ki: Iiku/ mo aYuusup̱ mo dhali ciḵ gwo jin mina a’di iḵan um mo mmomii mo. ");
INSERT INTO udu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Wakan me’d jin peperkina ṯe/ ap̱o/ bampany ’ceshi ’baar mo tani aYuusup̱ a’di iḵa’dki’da ris gu’b themes ’twa/ mo dhali yolki ’Kwani Masir tonṯe/ mo haali/ ṯe/ shina ’kosh ki shi/ e bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Doḵ/e adhana ’cesh yini ’baar mo uni p̱u’dkin e Pa Masir mo eya Yuusup̱ mo mmoyol pos mo haali/ ṯe/ shilki ’kwani isi ’baar mo e mony’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ka Yakuub da/arki gwo ki pos ishki’d mo e bampa/ Masir mo tani a’di oki iya/m piti gwo mo ki: Atinta i’kona um mmohili e ka rem’kup̱ kan mo? ");
INSERT INTO udu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Dhali a’di oki gwo mo ki: Hili mo mo ma, aha/ ciḵkina gwo mo ki pos ishki’d mo e bampa/ Masir mo. Iiku/ ka luŋgu’b mo dhali yoli pos ’peni mun gom ana mo ki ana mina ’ko ki e mo dhali ’koki wu mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Wakan ikam ma Yuusup̱ kun ’koni ’kume’d uni iikin ka luŋgu’b mo mmoyoli pos ’peni bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Hila Yakuub diki hasha Benyamiin mo a’di jin ta’da kam ma Yuusup̱ mo nyaḵki ikam mo haali/ a’di ḵo/ki is mo oki tonthusa kamu/ midi ’taki biṯ a’di ap̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Wakan iya/ ma Israyiil p̱u’dkin mo mmoyol to mo nyaḵki ’kwani kun p̱u’dkin mo gom gwon ṯe/ ’peni bampa/ Kanaan mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Dhali aYuusup̱ a’di itaki’da mudhiir mo ap̱o/ pa ’baar mo. A’di iyolki to goma ris ’kwanim bampa/ ’baar mo. Dhali ikam ma Yuusup̱ uni p̱u’dkin mo dhali goŋ is buni ka ’cesh mo ibwambori a’di mo ki jis/em buni kun ’dokina uni ka luŋgu’ba ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","AYuusup̱ mishki ikam mo dhali nyiṯẖ uni mo hili a’di miiki uni ka jin thus me’d ’kwanin tiya kun ’kona e ki she/ mo dhali a’di ṯorki’da ṯor nyaḵki uni ki ’twany ’cwar mo mmo/o ki: Um iiyin ’peni mana mo? A’di oki’d kan mo. Uni thoḵki a’di gwo mo ki: ’Peni Paŋ Kanaan mo mmoyol tonṯe/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Wakana Yuusup̱ nyiṯẖki ikam mo ihili uni i’koki mish a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Dhala Yuusup̱ kakina gwony jan piti e mo a’di jin shu’bkina a’di gom uni mo dhali a’di oki uni gwo mo ki: Um ta ’kwani kun parkina mee mo, um p̱u’dkin mo mmop̱ar bampa/ e mo ki a’di ’ka’da is ki ’ka’d mo. ");
INSERT INTO udu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Uni thoḵki a’di gwo mo ki: Yisa tap̱am bam hili mmoyol tonṯe/ mo a’di ip̱u’dkina c̱iŋkinam pini mo. ");
INSERT INTO udu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Aman ’baar mo tana iya/ gi wathin ’de/ mo. Aman tana ’kwaniŋ ḵar/e mo, c̱iŋkinam pini gwansan ’koki ta ’kwani kun parkina mee mo. ");
INSERT INTO udu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A’di oki uni gwo mo ki: Yisa mo ti mmo’ka’da bampa/ yan is ki ’ka’d mo ti. A’di ti ip̱u’dkina um mo mmop̱ar mo e mo. ");
INSERT INTO udu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Dhali uni thoḵki gwo mo ki: Aman kun tana c̱iŋkinam pini mo aman kun tana ikam kun ’kon jasi i’kume’d i’ce’dka su/ mo kun ta iya/ gi wathin ’de/ mo e bampa/ Kanaan mo dhali hili mo mo ma, ara gwa’dgaŋ gana/ ka tee yan mo tani a’di idiyi’di nyaḵka babam bam mo dhali jaŋ kamu/ yisa di’d doḵ/eya. ");
INSERT INTO udu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hila Yuusup̱ thoḵki uni gwo mo ki: Me’d gwo jin okika/ um mo tani aha/ ona um ki um ta ’kwani kun parana mee ka jiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Gom mii yansan mo tani um minu pal mo ki mondiki/e ma P̱irawn mo, um mini mish ii ’peni mo yan yisa ntagi um mini sus ara kam bum jin ta’da ṯu/u imahan mo. ");
INSERT INTO udu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hashi jan ’de/ ’peni um mo dhali dhalki a’di susi’da kam bum mo ki um ’kon ka yiha/ eya sijin mo ki gwom bum minu nyo/ mo, mishki gwoŋ gana/ di’d e um mo walla isi’da/ ki mondiki/e ma P̱irawn mo, um ka jiŋ gana/ ta ’kwani kun parkina mee mo. ");
INSERT INTO udu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Dhali a’di dhuki uni ’baar mo mmonṯal ’de/ eya sijin mo ka cimi kwara mo. ");
INSERT INTO udu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","’Ko’da cimi kwara mo tani aYuusup̱ oki uni gwo mo ki: Miiyi mii yan mo a’di i’kona um ki e mo haali/ aha/ ḵo/kina Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Waḵki/ um ta ’kwaniŋ ḵar/e mo tani dhalka kam buma kamu/ diki’da sijin mondeḵ is mo dhali dhalki kun tiya ki ii mo dhali ḵal pos gom ṯe/ mo gom kuŋ gu’bi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Dhali susi ara kam bum jin gwa’da’d i aha/ mo wakan ki gwom bum minu ’da’b ’pen mo dhali um mini ’koki wu mo be. Dhali uni miikin wakan mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Dhali yan’ko’d uni oki gwo ka rem’kup̱ mo ki: Ka jiŋ gana/ ana ’kona mii i’ba/ isi gwo goma kam bana mo me’d jin mishkina ana mii ma ḵashiram piti jin diki’d e mo ma c̱is mo ki a’di suski ana gwo sho’k mo dhali ana ’konaki ciḵ gwom piti mo. Gom gwo gi wakan mo tani a’di biṯa mii ma c̱is ap̱o/ ana mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Dhali aRa/ubiin thoḵki uni gwo mo ki: Dika/ ki o um gwo mo ki: Dhalku/ miinthus ki mii ap̱o/ ari dhuru’c wathi/ mowa? Hili um ’koki ciḵ gwo mo. Wakan shwane/ mo jin ri/u ari/ gom abas piti mo tani a’di ip̱u’dki’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Uni yisa mishi gwo ’bana ka Yuusup̱ ciḵki gwom buni mo haala manluḵ ’twa/ a’di idiki’d e bwaman uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Dhali yan’ko’d a’di ṯu’kki ’ban ’peni uni mo dhali ko mo be. Dhali a’di doḵki’di uni ka nyaŋ’ko’d mo dhali ṯorki’da ṯor ki uni mo. Dhali a’di bu’thki’da Shim/uun ’peni uni mo dhali deḵ a’di mo ibwambori jis/em buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Dhala Yuusup̱ ḵanki gwo mo mmo’tu’da wolgwap̱im buni ki pos mo dhali ro’dki uniya guurush buni e ’twamana wolgwap̱im buni ka ’deṯe/ ’deṯe/ mo dhali thosonki uni tonṯe/ kun mina uni mii ishwa e bway iim buni mo. Yan a’di imiikunu gom uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Dhali yan’ko’d uni su’kki thuluny buni to ap̱o/ mo dhali ship̱iṯi ii mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Dhali ki jan ’de/ ’peni uni ḵa’dki’da wolgwap̱i/ ’twa/ mo mmo’taki c̱i thuluny piti to mmoshwa e mo jin ishkina uni mo tani a’di mishki’da guurush e ’twaman ma wolgwap̱im piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Dhali a’di oki ikam gwo mo ki: Aguurush pem doḵkunu aha/ i is ka nyaŋ’ko’d mo. A’di a’dihe/ e ’twaman ma wolgwap̱im pem mo. Gom mii yan mo tani adum buni ushki uni me’di e mo dhali uni ṯu’kkin ka rem’kup̱ mo mmode ki bir bir mo mmo/o gwo mo ki: Atinta a’dan mo? a’di jin miikin ma Arumgimis ana mo. ");
INSERT INTO udu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ki uni p̱u’dkina Yakuub jin ta’da babam buni e bampa/ Kanaan mo tani uni ṯorki a’di aris to kun miikin ki uni mo mmo/o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Wathi/ jin ta tap̱a ap̱o/ bampa/ yan mo tani a’di ṯorki’da ṯor ki aman ki ’twany ’cwar mo dhali bu’th aman mo, o ki aman tana ’kwani kun parkina mee mo ap̱o/ bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Hili aman thoḵkina a’di gwo mo ki: Aman tana ’kwaniŋ ḵar/e mo dhali aman yisa tana ’kwani kun parkina mee mo. ");
INSERT INTO udu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Aman tana ikam kun ’kon jasi ’kume’d i’ce’dka su/ mo, iya/ ma babam bam mo, jan ’deŋ kamu/ yisa diyi’da dhali ara ṯu/u shwane/ yan a’di idiyi’d nyaḵka babam bam e bampa/ Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Dhali yan’ko’d wathi/ jin ta tap̱a gom bampa/ yan mo oki aman gwo mo ki: Gom kan mo tani aha/ mina mish um ki um ta ’kwaniŋ ḵar/e mo. Dhalka kam buma kamun ’de/ nyaḵki aha/ mo dhali ḵali pos mo gom ṯe/ gom kuŋ gu’b bumi ’baar mo dhali iiku/ mo e bway bum mo. ");
INSERT INTO udu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Susi ara kam bum jin gwa’da’d e aha/ mo dhali yan’ko’d aha/ mina mish um ki um ’koki ta ’kwani kun parkina mee mo hili um ta ’kwaniŋ ḵar/eŋ gana/ mo dhali aha/ mina ’cuḵki uma kam bum mo dhali um mini yol to e bampa/ yan mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Me’d jin wolkina uni arisa wolgwap̱im buni to mo ’peni bwaman mo tani hili mo mo ma, arisa guurush buni kun deḵkunu is mo tani gamkunu e bwaman ma wolgwap̱im buni ki she/ ki she/ mo dhali uni dhala babam buni uni p̱arkina guurush buni e mo kun deḵkina uni mo, uni merkina ijamasa/. ");
INSERT INTO udu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Dhala Yakuub jin ta’da babam buni oki uni gwo mo ki: Um bu’thki uc̱i ’peni aha/ mo dhala Yuusup̱ yisa di’da dhali aShim/uun si’da/ a’di p̱iki’d mo adhali um shwane/ mini susa Benyamiina? Aris mii gwansan uni p̱u’dkina p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Dhali yan’ko’da Ra/ubiin oki’da babam piti gwo mo ki: ’Koshi iya/m pem su/ gwan jwa mo waḵki/ aha/ dinaki doḵi a’di pa i /e ka nyaŋ’ko’d mo. Kari a’di e me’d pem mo ma dhali aha/ mina doḵi a’di pa ka nyaŋ’ko’d mo e /e mo be. ");
INSERT INTO udu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Hili a’di thoḵki gwo mo ki: Ya/m pem midi mol ya ka luŋgu’b nyaḵki um mo haali/ akam a’di iwuki’d mo dhali a’di idiki’d jasi ’de/ mo. Waḵki/ tonthusa kamu/ midi ’taki biṯ a’di ap̱o/ e bway iim bum yan jin mura umi kar mo tani um mini raḵa wuum pem yan jin ’kayaa/ mmodiṯ bwa ntaga Haawiya mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Shwane/ ṯe/ shilki ’kwani is ki she/ e bampa/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Dhali ki uni shwaki pos mo a’di jin ḵalkina uni ’peni Pa Masir mo tani ababam buni oki uni gwo mo ki: Iiku/ mo doḵ/e mmoyoli ari tonṯe/ gom ana mo. ");
INSERT INTO udu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Hila Yahuuda oki a’di gwo mo ki: Wathi/ rumki aman ki gwo ki ’bi’th mo mmo/o gwo mo ki: Um mini mol jis/em pem p̱ar e mo isi ciki/ akam bum midi nyaḵ yayu/ ki um mo. ");
INSERT INTO udu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Waḵki/ /e mini hasha kam bam nyaḵki aman mo tani aman mina ii ka luŋgu’b mo dhali yolu /e tonṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Hili waḵki/ /e mini diki hash a’di mo tani aman yisa mina ii ka luŋgu’b mo haali/ wathi/ oki aman gwo mo ki: um mini mol jis/em pem p̱ar e mo isi ciki/ akam bum midi nyaḵ yayu/ ki um mo. ");
INSERT INTO udu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israyiil oki gwo mo ki: Katinta jan miina um aha/ ka jin thus kan mo mmoṯor wathi/ gwo mo o ki um tan ga kama kamu/ mo? ");
INSERT INTO udu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Uni thoḵki gwo mo ki: Wathi/ be idoṯki aman gwo ka ḵar/e mo gom is bam mo dhala bas bam mo mmo/o gwo mo ki: A/ababam bum di’d ki e naskina/ mowa? A/um tan ga kam buma kamu/ mowa? A’di jin ṯorkina aman a’di mo tani uni a’di ita gwon doṯ kun thoḵkunu mo. A/ba aman misha to kun mina a’di i’taki mii owa? Mmo/o ki susa kam bum ka luŋgu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Dhali aYahuuda oki’da Israyiil jin ta’da babam piti gwo mo ki: Hashi dhuru’c wathi/ nyaḵki aha/ mo dhali aman mina cu mis dhali ii mo ki aman mina ’ko ki e mo dhali ’koki wu mo, aman imonṯal ’de/ inyaḵki /e mo dhali ushi uc̱iŋ gwa’dgam bam si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Aha/ mina ya ta a’di jin ’tashu ’twa/ mo gom a’di mo. ’Peni me’d pem mo tani /e mini ’theḵ gwo gom a’di. Waḵki/ aha/ dinaki susu/ a’di pa ka nyaŋ’ko’di /e mo dhali kar a’di ibwambori /e mo tani dhalki mo jin diluwa dil miga/ ḵal e ’ba/ pem ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Haali/ waḵki/ aman mina ’taki ’koki ta adiiṯe/ kan mo tani aman anann be mina ’taki p̱u’du/ ka nyaŋ’ko’d me’di su/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Dhali yan’ko’d ababam buni ka Israyiil oki uni gwo mo ki: Waḵki/ a’di midi mii wakan mo tani ba miiyi a’di yan mo. Buthi maman cwa kun mina umi kwany mo ’peni bampa/ mo dhali dhuyi uni e bwaŋ ḵucaŋ mo dhali ḵalki uni ka luŋgu’b gom wathi/ mo mmota to jin mina um taḵ a’di mo ara ’bi’c cwa ma balsam dhali ara yina dham dhala ’bi’c en’thi/ dhala murr dhali emen cwa jin wana maman ki shu’be/ mo dhali emen cwaŋ kamu/ si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ḵali aguurush ka ’buḵum ’ban mo nyaḵki um mo. Ḵalka guurush gwan ka nyaŋ’ko’d kun doḵkunu umi is mo e aris ’twaman ma wolgwap̱im bum mo, wariba/ a’di ta mii jin thamunu miiyi mo. ");
INSERT INTO udu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Susa kam bum si’da/ mo dhali cuyi mis mo dhali iiku/ i wathi/ doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ba dhalka Arumgimis jin Eḵa/ Eḵ c̱i um mii jin miinu mo ibwambori wathi/ mo ki a’di midi hasha kam bum akamu/ ka nyaŋ’ko’d nyaḵka Benyamiin mo. Waḵki/ aha/ minu bu’th uc̱i i’baar mo tani aha/ dara ki mowoṯẖ mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Wakan ’kwani ḵalki tontaḵ mo dhali uni ḵalkina aguurush ka ’buḵum ’ban nyaḵki uni mo dhala Benyamiin mo dhali uni cuki mis mo dhali ii ka luŋgu’b bway bampa/ Masir mo dhali uni doshkini bwambor ma Yuusup̱ mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ka Yuusup̱ p̱arki’da Benyamiin e mo tani a’di oki’da manhil to e gu’b piti gwo mo ki: Susi ’kwani gu’b mo dhali ’ciṯẖi/ to/e ’kus mo dhali thosoni to ki jahanne/ mo haali/ ’kwani mini nyaḵ to shwa ki aha/ montee mo. ");
INSERT INTO udu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Wathi/ miiki’d me’d jin ḵankin ma Yuusup̱ a’di gwo mo dhali suski ’kwani e gu’b ma Yuusup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Dhali ’kwani uni ḵo/ki is mo haali/ uni suskunu bway gu’b ma Yuusup̱ mo dhali uni oki gwo mo ki: A’di ta mii ma guurush wariba/ kun dhukunu e ’twamana wolgwap̱im bana mo ka cim gi ṯwa/a/ yin mo a’di isuskunu ana gu’b mo ’tese/ wakan ki a’di midi ŋap̱ embula ’borga/ ap̱o/ ana mo dhali biṯa p̱o/ ana dhali dhu ana ki c̱iŋkina/ kun yolu mo dhali bu’th thuluny bana mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wakan uni iiki gu’b gi wathi/ jin ta’da manhil to ma Yuusup̱ mo dhali ṯora ṯor nyaḵki a’di e shan’tamo/ gi gu’b mo. ");
INSERT INTO udu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Dhali oki gwo mo ki: Ayy tap̱am bam, aman p̱u’dkina ka luŋgu’b ka cim jin ṯwa/a/ mo mmoyol tonṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Dhali ki aman p̱u’dkina e mo jin ishu mo tani aman ḵa’dkina wolgwap̱im bam ’twa/ mo dhali imun mo tani aman ’kwani gamkina aguurush ka ’deṯe/ ’deṯe/ e ’twaman ma wolgwap̱im bam mo, aguurush bam uni idiṯadiṯ mo, wakan aman ḵalina uni doḵ/e nyaḵki aman mo. ");
INSERT INTO udu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Dhali aman si’da/ ḵalina aguurusha kamu/ ka luŋgu’b e me’d bam mo mmoyol tonṯe/ mo. Aman yisa misha wathi/ jin dhuki aman aguurush e ’twamana wolgwap̱im bam mo. ");
INSERT INTO udu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","A’di thoḵki uni gwo mo ki: Shiyi is bum ki gwo jin rokomkunu mo ma. Dhalku/ is ki ḵo/ mo, Arumgimis bum dhali Arumgimis ma babam bum a’di be i’taki mii idhuki umi tom bum kun ish ḵumma/ e ’twamana wolgwap̱im bum mo gom um mo. Aha/ bu’thkina aguurush bum mo. Dhali yan’ko’d a’di suski’da Shim/uun ka pije/ e uni mo. ");
INSERT INTO udu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Dhali wathi/ suski ’kwani bway gu’b ma Yuusup̱ mo dhali c̱i uni yi’de/ mo dhali ki uni lamki sho’k buni mo dhali ki a’di c̱iki thuluny buni to mmoshwa mo si’da/ tani ");
INSERT INTO udu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","uni thosonki tontaḵ buni is mo goma Yuusup̱ midi yayu/ pa mo montee mo haali/ uni ciḵki gwo ki uni mini ’taki shwa tonṯe/ imun mo. ");
INSERT INTO udu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ka Yuusup̱ p̱u’dki pa mo tani uni ḵalki a’di to bway gu’b mo kun ta tontaḵ kun takina uni mo dhali uni goŋki is ka ’cesh mo e a’di mo ntaga ’cesh gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Dhali a’di ’theḵki gwondoṯ mo gom moŋ’kom buni dhali o gwo mo ki: A/ababam bum di’d ki ’bore/ mo ’te/ tana? wathin dhan jin ṯorkina um aha/ gwo mowa? A/a’di di’d ki ’bore/ mowa? ");
INSERT INTO udu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Uni thoḵki a’di gwo mo ki: C̱iŋkinam pini jin ta’da babam bam mo tani a’di idi’d ki ’bore/ mo, a’di di’d ki e naskina/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Dhali a’di i’de’kki em piti ki mis mo dhali misha kam piti ka Benyamiin mo jin ta ya/ gi kum mo dhali o gwo mo ki: A/ara kam bum jin gwa’da’d a’dana a’di jin ṯorkina um aha/ mowa? Arumgimis midi mii mii ma ’the gom /e ya/m pem. ");
INSERT INTO udu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Dhali yan’ko’da Yuusup̱ di’bki mii is mo ki jahanne/ haali/ adum piti gworki’d mo goma kam piti mo dhali a’di ŋap̱ki mo mo mmoko nycine/ mo. Dhali a’di yaki gu’b ish piti mo dhali ko imun mo. ");
INSERT INTO udu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Dhali yan’ko’d a’di lamki jis/em piti mo dhali yayu/ ka pije/ mo dhali butha du mo dhali o gwo mo ki: Dhalki tonṯe/ a’di ipashu mo. ");
INSERT INTO udu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Uni c̱iki a’di tonṯe/ ki is piti a’di ’de/ mo dhali uni ’cena c̱em buni mo dhali ’Kwani Masir kun nyaḵki tonṯe/ shwa ki a’di uni ’cena c̱em buni mo haali/ ’Kwani Masir mini mol tonṯe/ shwa nyaḵki ’Kwani Ibraan mo haali/ a’di midi ta miin nyogga/ gom ’Kwani Masir mo. ");
INSERT INTO udu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Dhali uni dhukunu ’pena ’cesh mo ibwambori a’di mo, a’di jin ta’da bwanyara/ me’di isi gwo ma bwanyara/ jin tana a’di ka ḵar/e mo dhali ara gwa’dga/ me’d isi dhuru’c piti jin tana a’di mo. Dhali ’kwani hilkin e ka rem ’kup̱ mo dhali mer kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","To kun ’tuntulu/ bwa ime’d ’pena tharabeesa ma Yuusup̱ mo tani a’di ḵalkunu uni mo hili aBenyamiin a’di ’tuntulkunu to ime’d me’di mudhe’d mo mmobol kum buni e mo. Wakan uni p̱iki to mo dhali ’kuny bwa nyaḵki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Dhali yan’ko’d a’di ḵanki wathi/ jin ta’da manhil tom piti gwo mo ki: ’Tu’dki ’kwani awolgwap̱im buni ki tonṯe/ ki nyanye/ mo me’d mii jin mina uni imish a’di ḵal mo dhali dhuka guurush buni e ’twamana wolgwap̱i/ gi ’kwani ka ’deṯe/ ’deṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Dhali kari aḵubbaayam pem a’di jin ta’da ḵubbaayan ’dolkon kush mo e ’twamana wolgwap̱i/ a’di jin gwa’dagwa’d mo nyaḵka guurush pos piti mo. Dhali a’di miiki a’di mo me’d gwo jin ḵankin ma Yuusup̱ a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Me’d jin ḵalkina mo kush mon’thamo/ mo tani ’kwani uni idhukunu ’pen mo nyaḵki thuluny buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ki uni iikin mo ari is ’ko’d ari’ceenne/ mo ’peni ’peŋkuman bampa/ mo tani aYuusup̱ oki’da manhil tom piti gwo mo ki: Cuyi mis mo dhali ur ’kwani gwan isho’k mo dhali ki /e mini siri’c uni ap̱o/ ki sho’k mo tani oyi uni gwo mo ki: Atinta iraḵkina um tom ’boro’di bway mo mmowar ki to shigga/ mo? Atinta iḵwalkina uma ḵubbaayan ’dolkon kush pem mo? ");
INSERT INTO udu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","A’di diki ta ji gi p̱ina tap̱am pem to mowa dhali gom mii yan mo tani a’di inyiṯẖa a’di to kun mini mii yilaŋkamu/ moyi? Um thamki mii mo mmomii wakan mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ki a’di siri’cki uni ap̱o/ ki sho’k mo tani a’di ṯorki’da ṯor ki uni ki gwo gwansan mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Uni thoḵki a’di gwo mo ki: Atinta i/okina tap̱am bam gwo gi wakan mo? Gwo midi mii si’dasi’d ’peni aman kun tana c̱iŋkinam pini mo ki uni mini ’taki mii to gi wakan mo. ");
INSERT INTO udu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Hili mo mo ma, aguurush kun gamkina aman ’peni ’twamana wolgwap̱im bam uni ḵalkina aman /e ka nyaŋ’ko’d mo ’peni bampa/ Kanaan mo, dhali mii jin midi ’taki ta ata ’te/ imina aman ḵwal ’dolkon kush walla ’dolkon gana/ ’peni gu’b gi tap̱am pini mo? ");
INSERT INTO udu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Dhali e bwaman c̱iŋkinan ’de/ yin jin minu gam to nycine/ mo tani dhalki a’di iwu’d mo dhali aman si’da/ mina ta c̱iŋkina/ jin yolu gom tap̱am bam mo. ");
INSERT INTO udu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A’di thoḵki uni gwo mo ki: Dhalki a’di miinu mo me’d gwo jin okina um mo ki: Ki a’di yin jin minu gam to nycine/ mo tani a’di imidi ta c̱iŋkina/ jin yolu pem mo dhali um kun boc̱kin mo tani mini ta ’kwani kun mini dar gi mii i’ba/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Dhali yan’ko’d aris ’kwani thulkina wolgwap̱im buni ka ’cesh ki jahanne/ mo dhali aris ’kwani uni ḵa’dkina wolgwap̱im buni ’twa/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Dhali a’di ŋap̱ki to mo mmoṯel ’pen ’peni a’di jin ca’d mo dhali daḵ ’kup̱ ki a’di jin gwa’da’d mo dhali aḵubbaaya a’di gamkunu e ’twaman ma wolgwap̱i/ ma Benyamiin mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Dhali yan’ko’d uni dherki burrinyem buni bwa mo dhali aris ’kwani deḵki thuluny buni to ap̱o/ ka nyaŋ’ko’d mo mmodoḵ bway ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ka Yahuuda dhali ikam p̱u’dkin e gu’b ma Yuusup̱ mo a’di di’d naskina/ imun mo dhali uni ṯa’kkina ibwambori a’di a’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yuusup̱ oki uni gwo mo ki: Mii gi wakatinta imiikina um mii gi wakan mo? ’Kona um ki misha wathi/ me’d aha/ mo mina nyiṯẖ to kun mini mii yilaŋkamu/ mowa? ");
INSERT INTO udu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Dhala Yahuuda thoḵki gwo mo ki: Atinta a’di i mina amani o e tap̱am bam mo? Dhali aman mina o katinta mo? Walla am mina dhu is bam athiṯẖin thiṯẖ kata mo? Arumgimis a’di gamki mii jin thamu ap̱o/ c̱iŋkinam pini mo. Hili mo mo ma, aman takina c̱iŋkina/ tap̱a kun yolu mo amani ’baari monṯal ’de/ dhali a’di si’da/ jin gamkunuwa ḵubbaaya e me’d piti mo. ");
INSERT INTO udu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hili a’di si’da/ oki gwo mo ki: Mii yan midi si’dasi’d ’peni aha/ mo ki aha/ mina diki ’taki mii wakan mo. Hili jasi e me’d jin minu gama ḵubbaaya mo tani a’di imidi ta c̱iŋkinam pem jin yolka/ mo hili gom um mo tani iiku/ ki moŋḵu’th is eya babam bum mo. ");
INSERT INTO udu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Dhali yan’ko’da Yahuuda yaki’di a’di mo dhali o a’di gwo mo ki: Ayy tap̱am pem. Dhalki c̱iŋkinam pini mo, aha/ ’thona /e mo, ṯora ṯor ki tap̱am pem e bwany’cem piti mo dhali dhalka nyor pini ki pur ki o’d ap̱o/ aman kun tana c̱iŋkinam pini mo haali/ /e wana e ka P̱irawn ki is pini mo. ");
INSERT INTO udu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tap̱am pem doṯki c̱iŋkinam piti gwo mo dhali oki: A/um tan ga babam bum mo dhali akam buma? ");
INSERT INTO udu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Dhali aman okina gwo e tap̱am bam mo ki: Aman tana ka baba wathin dhan mo dhali ara kam bam jin gwa’dagwa’d mo jin ta’da ’cim piti ka dhan piti mo dhali akam piti a’di iwuki’d mo dhali a’di idhalkunu a’di ’de/ ’pena ’ciŋ kum mo dhali ababam piti enki a’di kagahara mo. ");
INSERT INTO udu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Dhali yan’ko’d /e oki c̱iŋkinam pini gwo ki susu/ a’di ka luŋgu’b i /e mo ki aha/ mina ’thos a’di em pema is mo. ");
INSERT INTO udu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Aman okina gwo yan e tap̱am bam mo ki: Ari dhuru’c wathi/ midi mol dhal com ’pen mo haali/ waḵki/ a’di midi dhal com ’pen mo tani ababam piti a’di imidi wu mo. ");
INSERT INTO udu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Dhali yan’ko’d /e ki o c̱iŋkinam pini gwo mo ki isi ciki/ waḵka kam buma gwa’dga/ diki yayu/ ka luŋgu’b nyaḵki um mo tani um mini ’koki mish jis/em pem p̱ar e doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ki aman doḵkina e pa gi c̱iŋkinam pini jin ta’da babam pem mo dhali ṯor gwon tap̱am pem mo, ");
INSERT INTO udu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","dhali ka babam bam oki aman gwo mo ki: Iiku/ doḵ/e mo dhali yolu/ ari tonṯe/ mo tani, ");
INSERT INTO udu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","aman thoḵkina a’di gwo mo ki: Aman mola ii ka luŋgu’b mo. Waḵki/ ara kam bam jin gwa’da’d midi nyaḵ ya ki aman mo tani aman mina ii ka luŋgu’b mo. Haali/ aman mola p̱ar wathi/ jis/em piti e mo isi ciki/ ara kam bam jin gwa’da’d midi mii nyaḵ di ki aman mo. ");
INSERT INTO udu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Dhali yan’ko’d c̱iŋkinam pini jin ta’da babam pem ki o aman gwo mo ki: Um mishin ka ’bom pem dho’thki aha/ iya/i su/ mo. ");
INSERT INTO udu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jaŋ kamu/ thiska/ e mo dhali aha/ okina gwo ki: A’di ka jiŋ gana/ dherkina toŋgwap̱i/ bwa ka gwap̱i/ ki ruṯ ruṯ mo dhali aha/ dinaki mish a’di ’pena cim yin ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Waḵki/ um mini sus jin ṯal ’de/ yan si’da/ ’peni aha/ mo tani dhali tonthus ki biṯa p̱o/ a’di mo tani um mini raḵa awuuŋ kush pem yan isi bwan diṯi’d mo dhali ya mo eya Haawiya mo. ");
INSERT INTO udu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Dhali gom gwo gi wakan mo tani ki aha/ yakina e c̱iŋkinam pini jin ta’da babam pem mo dhali ari dhuru’c wathi/ diki nyaḵ yayu/ ki aman mo haali/ mondiki/em piti a’di deḵkunu mo nyaḵki ji gi ari dhuru’c wathi/ mo. ");
INSERT INTO udu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Ki a’di p̱arki mo e ki ari dhuru’c wathi/ diki nyaḵ di ki aman mo tani a’di midi iwu mo be dhali c̱iŋkinam pini mini raḵa awuuŋ kush piti isi bwan diṯi’d mo dhali a’di midi ya ka luŋgu’b eya Haawiya ki bwan diṯi’d mo a’di jin ta c̱iŋkinam pini jin ta’da babam bam mo. ");
INSERT INTO udu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Haali/ c̱iŋkinam pini a’di warki’d ka manmish mo ki isi mish gana/ gom ari dhuru’c wathi/ goma babam pem mo mmo/o gwo mo ki: Waḵki/ aha/ dinaki susi a’di pa i /e mo tani dhalki aha/ a’di iḵala mo jin diluwa dil mo e jis/e ma babam pem ki mondiki/em pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Dhali gom gwo gi wakan mo tani dhalki c̱iŋkinam pini mo, aha/ ’thona /e mo, mmoc̱a’bku/ mo e embul ma ari dhuru’c wathi/ mo mmota c̱iŋkina/ gi tap̱am pem jin yolu mo. Dhali dhalki ari dhuru’c wathi/ doḵ bway pa nyaḵki ikam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Haali/ aha/ mola doḵ bway pa ababam pem mo waḵki/ ari dhuru’c wathi/ diki nyaḵ ya ki aha/ mo haali/ aha/ ḵo/kina is mo mmop̱ar tonthus gi wakan e mo mmop̱u’da p̱o/ ababam pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Dhala Yuusup̱ mol is piti non mo ibwambori aris ’kwani kun nyaḵ ’ko ki a’di mo, dhali a’di ’therki ko mo ki: Raḵa ris ’kwani ’baar mo mmo/ii ka pije/ ’peni aha/ mo. Gom gwo gi wakan mo tani wathin ṯal ’deŋ kamu/ yisa di’d nyaḵki a’di mo me’d jin ṯorkin ma Yuusup̱ is piti eya tente/ e ikam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Dhali a’di ’therki ko kagahara mo, wakan ’Kwani Masir ciḵki a’di mo dhali aris ’kwani gi gu’b ma P̱irawni ’baar mo ciḵki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Dhali aYuusup̱ oki ikam gwo mo ki: Aha/ tana Yuusup̱ mo. A/ababam pem di’d ki e naskina/ mowa? Hili ikam piti mol a’di gwo thoḵ mo haali/ uni ḵo/ki is kagahara ibuŋ’kus piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Wakana Yuusup̱ oki ikam piti gwo mo ki: Shori aha/ is ki ’dishe/ mo. Dhali uni shorki a’di is mo. Dhali a’di oki uni gwo mo ki: Aha/ tana akam bum jin ta’da Yuusup̱ a’di jin yolkina um mo e Pa Masir mo. ");
INSERT INTO udu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Dhali shwane/ dhalku/ is bum ki dhu ka madhan’kur mo walla ka nyor e bwaman is bum mo haali/ um yolki aha/ imahan mo, haali/ Arumgimis hashki aha/ nṯwa/a/ ki um mo mmo’tash mondiki/e ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Haali/ ṯe/ diki’d e bampa/ yansan yili su/ mo dhali yil boc̱kini mudhe’d mo jin minu ’koki gorra ’cesh mo walla ’ciṯẖ to mo. ");
INSERT INTO udu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dhali Arumgimis hashki aha/ nṯwa/a/ ki um mo mmo’tasha/ ’tash ’twa/ gom um mo haali/ um tana ushalla/ e mony’cesh mo dhali mmodhuya dhu ki e gom um mo uni ka ris kun minu ’ko ki e mo. ");
INSERT INTO udu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Wakan um yisa a’di ihashki aha/ imahan mo, hili Arumgimis mo dhali a’di karki aha/ mmota ababa goma P̱irawn mo dhali tap̱a gom kuŋ gu’b piti ’baar mo dhali ta amanji/a ji ap̱o/ bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Thosoni is ki jahanne/ mo dhali iiku/ ka gagamis mo eya babam pem mo dhali oyi a’di gwo mo ki: Gwo jin ona ya/m pini ka Yuusup̱ a’dihe/ mo ki: Arumgimis karki aha/ ki tap̱a ’Kwani Masiri ’baar mo. Yayu/ ka luŋgu’bi aha/ mo. Dhalka diiṯe/ ki miiyu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","/E mini c̱a’b e bampa/ Jaasaan mo dhali /e mini ’dishaa/ is mo /e dhali uc̱im pini mo dhali uc̱i gi uc̱im pini mo dhali arisa ma’diny ḵa’bal pini mo dhali arisa ŋul’kup̱ bip̱ pini mo dhali aris to ’baar mo kun takina /e mo. ");
INSERT INTO udu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Dhali e mahan mo tani aha/ mina thip̱ /e ki to mo haali/ yil boc̱kini mudhe’d naskina/ jin mina ṯe/ p̱u’du/ mmo’kosha/ ’kosh mo isi ciki/ /e dhali aris kuŋ gu’b pini dhali aris to kun tana /e mo mini war ki moha’th’ko’d pini mo. ");
INSERT INTO udu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Dhali shwane/ em pini midi mish mo mo dhali e ma kam pem ka Benyamiin mishki mo mo ki a’di ta ’twam pem jin ṯorki’da ṯor nyaḵki /e mo. ");
INSERT INTO udu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Um mini mii ṯora babam pem gwo mo goma ris to ma ra/ ra/ pem e Pa Masir mo dhali aris to ’baar mo kun p̱arkina um e mo. Thosoni is ki jahanne/ mo dhali susa babam pem ka luŋgu’b imahan mo. ");
INSERT INTO udu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Dhali yan’ko’d a’di biṯki’d m’ba/ ma kam piti ka Benyamiin mo dhali ko mo dhala Benyamiin si’da/ goki’d e ’ba/ piti mo. ");
INSERT INTO udu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Dhali a’di p̱iki ikam piti ’twa/i ’baar mo dhali ko eya p̱o/i uni mo dhali yan’ko’d mo tani ikam ṯorkina ṯor nyaḵki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ki gwo jin ḵalu ciḵkin ma P̱irawn e gu’b piti mo ki ikam ma Yuusup̱ p̱u’dkin mo tani a’di ’borki’da P̱irawn bwa mo dhali aris c̱iŋkinam piti gara/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Dhala P̱irawn oki’da Yuusup̱ gwo mo ki: Oyi ikam pini gwo mo ki: Miiyi mii yansan mo ma, suki to/e gwansan towa p̱o/ mo dhali iiku/ ka nyaŋ’ko’d e Paŋ Kanaan mo. ");
INSERT INTO udu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Dhali susi ababam bum mo dhali aris kuŋ gu’b bum mo dhali iiyu/ i aha/ mo dhali aha/ mina c̱i um mom’borga/ e bampa/ mo dhali um mini shwa to ’pena ’cesh yan jin ṯu/aṯu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ḵani uni gwo si’da/ mo ki: Miiyi mii yansan mo ma. Ḵala arabiya kun dira shumarum ’peni Pa Masir mo mmoḵala ris ushi uc̱im bum mo dhali goma ris up̱ bum mo dhali susa babam bum mo dhali iiyu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Dhalki gwoŋ kamu/ ki kulumi bwa gom tom bum mo haali/ mony’cesh jin mina um i’ko nycine/ mo tani a’di ta jim ’borgaŋ gana/ mo e bampa/ Masir mo a’di jin midi ta jim bum mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Iya/ ma Israyiil miikin kan mo dhala Yuusup̱ c̱iki uni arisa arabiya kun dira shumarum mo isi me’d gwo jin ḵankin ma P̱irawn mo dhali thosonki uni tonṯe/ kun mina uni ishwa e bway iim buni mo. ");
INSERT INTO udu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Eya ris uni ka ’deṯe/ ’deṯe/ dhali eya ris uni ’baar mo tani a’di c̱iki uni burrinye/ ka kwa kwara mmo/aḵ e mo hili aBenyamiin mo tani a’di ki c̱iki a’di ariyaal iss ’kwanimpa ḵarpa’c mo ’pena guurush jin ta ’dolkon kush mo dhali burrinye/ imudhe’d kun mina a’di mii aḵ e mo. ");
INSERT INTO udu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Goma babam piti mo tani to kun hashkina a’di gom a’di mo tani uni ta thuluny i’kume’d mo kun su’kkunu tom ’boron gi Pa Masira p̱o/ mo dhali kuman thuluny ’koni ’kume’d kun su’kkunu posa p̱o/ mo dhali maaŋḵuthu’d mo dhali tonṯe/ si’da/ thosonkunu is mo goma babam piti mo gom ya jin mina a’di iyayu/ i bway mo. ");
INSERT INTO udu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Dhali yan’ko’d a’di dhuki ikam piti ’pen mo, dhali ki uni ḵwa/ is bwa mo tani a’di oki uni gwo mo ki: Dhalka wala ki wal i bway mo. ");
INSERT INTO udu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wakan uni cuki mis ka pije/ ’peni bampa/ Masir mo dhali p̱u’d e Paŋ Kanaan mo eya babam buni ka Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Dhali uni ṯorki a’di gwo ka Yuusup̱ di’d ki e naskina/ mo dhali a’di iji’da ji ap̱o/ bampa/ Masiri ’baar mo, dhala dum piti a’di ’thikina buye/ mo haali/ a’di diki gam gwom buni is mo. ");
INSERT INTO udu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Hili ki uni ṯorki a’di aris gwo ma Yuusup̱ i’baar mo a’di jin okina a’di uni mo dhali a’di p̱arki’da arisa arabiya kun dira shumarum e mo uni kun hashkin ma Yuusup̱ mo mmoḵali a’di mo tani shi/in ma babam buni ka Yakuub a’di warkunu is mo be. ");
INSERT INTO udu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Dhala Israyiil oki gwo mo ki: A’di ’koshki jwa mo. Yuusup̱ jin ta ya/m pem a’di idiki’d ki e naskina/ mo. Aha/ mina ya mo dhali p̱ar a’di e mo nṯwa/a/ ki aha/ dinaki wu mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wakana Israyiil bu’thki moyam piti mo nyaḵka ris tom piti kun tana a’di mo dhali a’di p̱u’dki’d mo e Pam Birsaba mo dhali a’di ki c̱i to jin ’ciṯẖu/ ’kus mmomiiya basa ’cesh goma Arumgimis ma babam piti ka Is/hak mo. ");
INSERT INTO udu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dhali Arumgimis ṯorki’da ṯor ka Israyiil mon’thiny ki jan mo dhali o a’di gwo mo ki: Yakuub, Yakuub. Dhali a’di oki gwo mo ki: Aha/ dina imahan mo. ");
INSERT INTO udu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Dhali yan’ko’d a’di oki gwo mo ki: Aha/ tana Arumgimis mo a’di jin ta’da Arumgimis ma babam pini mo. Dhalku/ is ki ḵo/ mo mmoya ka luŋgu’b bway Pa Masir mo haali/ aha/ mina di imun mo dhali kar /e mmota adhan kal caaca mo. ");
INSERT INTO udu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aha/ mina ya ka luŋgu’b nyaḵki /e mo e Pa Masir mo dhali aha/ si’da/ mina doḵu/ /e pa ka nyaŋ’ko’d doḵ/e mo dhali me’d ma Yuusup̱ a’di imidi mu’th em pini mo. ");
INSERT INTO udu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Dhala Yakuub cuki mis mo ’peni Pam Birsaba mo dhali aris iya/ ma Israyiil uni ḵalkina Yakuub jin ta’da babam buni mo nyaḵki ushi uc̱im buni mo dhali aris up̱ buni mo eya risa arabiya kun dira shumarum mo uni kun hashkin ma P̱irawn mo mmoḵalu/ uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Uni si’da/ urki to/em buni mo dhali tom ’borgam buni mo uni kun gamkina uniya du is mo e Paŋ Kanaan mo dhali uni p̱u’dkin mo e Pam Masir mo aYakuub dhali aris kum piti kun c̱isa a’di nyaḵki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iya/m piti dhali iya/ gi iya/m piti nyaḵki a’di mo dhali i’bwa/m piti mo dhali i’bwa/ gi iya/m piti mo, aris kum piti ’baar mo kun c̱isa a’di mo tani uni ’doyina a’di bway Pa Masir mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dhali aris gway gi emen ma Israyiil uni annihe/ mo uni gun p̱u’dkin e Pa Masir mo aYakuub dhali iya/m piti mo. Ra/ubiin jin ta’da bwanyara/ ma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Dhali gway gi iya/ ma Ra/ubiin uni annihe/ mo: Hanuuk dhala P̱allu dhala Hasruun dhala Karmi mo. ");
INSERT INTO udu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Dhali gway gi iya/ ma Shim/uun uni annihe/ mo: Yamu/iil dhala Yaamiin dhala Uuhad dhala Yaaḵiin dhala Suuhar dhala Sha/uul a’di jin ta ya/ ma ’bom ’Kwani Kanaan mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Dhali gway gi iya/ ma Lawi uni annihe/ mo: Jirshuun dhala Gahaat dhala Maraari mo. ");
INSERT INTO udu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Dhali gway gi iya/ ma Yahuuda uni annihe/ mo: Iir dhala Unan dhala Shiilah dhala P̱aaris dhala Saarah mo (hila Iir dhala Unan uni a’di iwuyin mo e Paŋ Kanaan mo) dhali gway gi iya/ ma P̱aaris mo uni annihe/ mo: Hasruun dhala Hamul mo. ");
INSERT INTO udu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Dhali gway gi iya/ ma Yassaakar uni annihe/ mo: Tuulaa/ dhala P̱awwah dhala Yuub dhala Shimruun mo. ");
INSERT INTO udu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Dhali gway gi iya/ ma Sabuluun uni annihe/ mo: Saarad dhala Iiluun dhala Yahal/iil mo. ");
INSERT INTO udu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(Uni gwansan ita iya/ ma Le/ah mo uni kun dho’thkina a’diya Yakuub mo e Pam P̱addaan/araam imonṯal ’de/ nyaḵki ku gi ’bwa/ ka Diinah mo imonṯal ’de/ nyaḵki iya/m piti dhali i’bwa/m piti mo dhali mondeŋ buni ’koni iss ’de/ i’ce’dka ’kume’d i’ce’dka kwara ap̱o/ mo.) ");
INSERT INTO udu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Dhali gway gi iya/ ma Jaad uni annihe/ mo: Sip̱yuun dhala Hajji dhala Shuuni dhala Asbuun dhala Iiri dhala Aruudi dhala Ar/iili mo. ");
INSERT INTO udu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Dhali gway gi iya/ ma Ashiir uni annihe/ mo: Yimnah dhala Yishwah dhala Yishwi dhala Barii/ah nyaḵka Saarah jin ta ’bwah buni mo. Dhali gway gi iya/ ma Barii/ah uni annihe/ mo: Haabar dhala Malḵi/iil mo. ");
INSERT INTO udu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(Uni gwansan ita iya/ ma Silp̱ah mo a’di jin c̱ikin ma Laabaana Le/ah jin ta ’bwa/m piti mo dhali uni gwansan idho’thkin ma yima Yakuub mo, ’kwani kun ’koni ’kume’d i’ce’dka pe’de/ mo.) ");
INSERT INTO udu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dhali gway gi iya/ ma Rahiil a’di jin ta asha Yakuub uni annihe/ mo: Yuusup̱ dhala Benyamiin mo. ");
INSERT INTO udu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dhali goma Yuusup̱ e bampa/ Masir mo iya/ kun dho’thkunu a’di mo tani gway buni annihe/ mo: Manassa dhala Ep̱rayim uni kun dho’thkin ma Asnaat a’di mo a’di ta ’bwa/ ma P̱uthip̱aara/ jin ta’da gasiis ma Uun mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Dhali gway gi iya/ ma Benyamiin uni annihe/ mo: Baala/ dhala Baakar dhala Ashbiil dhala Jiira dhala Namaan dhala Iihi dhala Ruush dhala Mup̱p̱iim dhala Hup̱p̱iim dhala Ard mo. ");
INSERT INTO udu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(Uni gwansan ita iya/ ma Rahiil mo kun dho’thkina a’diya Yakuub mo kun ta ’kwani kun ’koni ’kume’d i’ce’dka doŋon ’baar mo.) ");
INSERT INTO udu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dhali gway gi iya/ ma Daan uni annihe/ mo: Hushim mo. ");
INSERT INTO udu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Dhali gway gi iya/ ma Nap̱taali uni annihe/ mo: Yahas/iil dhala Juuni dhala Yisr dhala Shilliim mo. ");
INSERT INTO udu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(Uni gwansan ita iya/ ma Bilhah a’di jin c̱ikin ma Laabaana Rahiil jin ta ’bwa/ mo dhali uni gwansan kun dho’thkin ma yim ma Yakuub mo tani ta ’kwani kun ’kon jasi pesuŋ gana/ ’baar mo.) ");
INSERT INTO udu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Aris ’kwani kun ta kuma Yakuub kun p̱u’dkin mo e bampa/ Masir mo tani uni ta jasi ku ki c̱isa a’di mo, yisa nyce/e ki ku ki aris up̱ gi iya/ ma Yakuub mo. Hili aris uni ’baar mo imonṯal ’de/ mo tani uni tana issi kwara i’ce’dka pe’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Dhali iya/ ma Yuusup̱ kun dho’thkunu a’di e bampa/ Masir mo tani uni ’koni jasi su/ mo dhali aris uni ’baar mo kun ’kon e gu’b ma Yakuub mo me’d jin p̱u’dkina uni e bampa/ Masir mo tani uni ’koni issi kwara i’ce’dka ’kume’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","A’di hashki’da Yahuuda nṯwa/a/ ki a’di mo eya Yuusup̱ mo mmopi a’di i isi bwambor e Pan Jaasaan mo dhali uni p̱u’dkin mo e mony’cesh ma Jaasaan mo. ");
INSERT INTO udu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Dhali yan’ko’da Yuusup̱ thosonki’da arabiyam piti jin dira shumarum is mo dhali cu mis mo dhali ya gama Israyiil ’kup̱ mo a’di jin ta’da babam piti e Pan Jaasaan mo dhali a’di c̱iki is piti ki a’di mo dhali biṯi ’bam piti mo dhali ko e ’bam piti ki rash rash gana/ mo. ");
INSERT INTO udu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israyiil oki’da Yuusup̱ gwo mo ki: Shwane/ dhalkaa/ wuna mo me’d jin mishkika/ jis/em pini mo dhali mish mo mo ki /e din ki e naskina/ mo. ");
INSERT INTO udu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yuusup̱ oki ikam piti gwo mo dhali aris ’kwani ’baar mo kun ta kuŋ gu’b gi com mo ki: Aha/ mina ya mo dhali ṯora P̱irawn gwo mo dhali aha/ mina o a’di gwo mo ki: Ikam pem dhali aris ’kwani kun ta kuŋ gu’b ma babam pemi ’baar mo uni kun ’kokin e mony’cesh gi Paŋ Kanaan mo tani uni p̱u’dkini aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Dhali ’kwani uni ita imanhil ḵa’bal mo haali/ uni ta imanhil to/e mo dhali uni ḵalkina ma’diny ḵa’bal buni ilu/ mo dhala dhana ŋul’kup̱ bip̱ buni mo dhali aris to ’baar mo kun tana uni mo be. ");
INSERT INTO udu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ka P̱irawn midi yuḵ um mo dhali o gwo mo ki: Miin tom bum ta’da tinta mo? tani, ");
INSERT INTO udu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","um mini o gwo mo ki: C̱iŋkinam pini uni ita imanhil to/e mo ’peni dhuru’c bam kun tana aman mo ntagi shwanesan mo, aman dhali ibabam bam mo, ki um mini mish ’ko mo e mony’cesh gi Pan Jaasaan mo haala ris ’kwani kun ta imanhil ḵa’bal mo tani uni ita thus ki thus e jis/e gi ’Kwani Masir mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Wakana Yuusup̱ yaki bway gu’b mo dhali ṯorka P̱irawn gwo mo ki: Ababam pem dhali ikam pem nyaḵka ma’diny ḵa’bal buni dhala dhana ŋul’kup̱ bip̱ dhali aris to kun tagina uni mo tani uni ip̱u’dkin mo ’peni Paŋ Kanaan mo dhali uni shwane/ ’kokin e Pan Jaasaan mo. ");
INSERT INTO udu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Dhali ’peni bwaman ikam piti mo tani a’di bu’thki ’kwani imudhe’d mo dhali ṯorki uniya P̱irawn i e mo. ");
INSERT INTO udu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","P̱irawn oki ikam piti gwo mo ki: Miin tom bum ta’da tinta mo? Dhali uni thoḵkina P̱irawn gwo mo ki: C̱iŋkinam pini uni ita imanhil ḵa’bal mo me’d ibabam bam mo. ");
INSERT INTO udu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Uni okina P̱irawn gwo mo ki: Aman p̱u’dkina mo mmo’ko ki ’ko ma c̱a/ e mony’cesh yan mo haali/ ashon dhii/i’da kamu/ yisa di’d imun kun mina c̱iŋkinam pini ic̱iya ma’diny ḵa’bal mo haali/ ṯe/ si’da/ a’di ishilki ’kwani is mo e Paŋ Kanaan mo. Dhali shwane/, aman ’thona /e mo, ki /e mini dhal c̱iŋkinam pini bway mo mmo’ko e Pan Jaasaan mo. ");
INSERT INTO udu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Dhali yan’ko’da P̱irawn ki owa Yuusup̱ gwo mo ki: Ababam pini dhali ikam pini uni p̱u’dkini /e itan mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Bampa/ Masir uni ’koni bwambori /e m’baar mo. Thumi ababam pini dhali ikan moŋ’ko mo e mony’cesha ’borga/ mo dhali dhalki uni ’kon mo e Pan Jaasaan mo. Dhali waḵki/ /e mishi wathi/ jin ’bora she/ ’peni bwaman uni mo tani dhuyi uni mmota imanhil to/em pem mo. ");
INSERT INTO udu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Dhali yan’ko’da Yuusup̱ ki susa Yakuub jin ta’da babam piti mo dhali kar a’di ibwambor ma P̱irawn mo dhala Yakuub ’borki’da P̱irawn mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Dhala P̱irawn oki’da Yakuub gwo mo ki: Atee gi yil gi mondiki/em pini uni ’kokin ekata mo? ");
INSERT INTO udu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Dhala Yakuub thoḵki’da P̱irawn gwo mo ki: Atee gi yila c̱a/ pem mo tani uni ’koni iss ’kwanimpa ipe’de/ i’ce’dka ’kume’da p̱o/ mo. Dhala tee gi yil gi mondiki/em pem mo tani uni tana hony/e mo dhali kun p̱u’da tonthus ap̱o/ aha/ mo dhali uni yisa i’thona/ ’tho/ ki me’d goma tee gi yil gi moŋ’koki/e gi ibabam pem ka atee kun iikina uni iinyc̱a/ mo. ");
INSERT INTO udu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Dhala Yakuub ’borki’da P̱irawn mii mo dhali ya ka pije/ ’peni buŋ’kus ma P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Dhali yan’ko’da Yuusup̱ thumki’da babam piti dhali ikam moŋ’ko mo dhali c̱iki uni mo mmota jim buni e bampa/ Masir mo e mony’cesh jin ’bora’bor mo e bampa/ Ra/amsiis mo me’d gwo jin ḵankin ma P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Dhala Yuusup̱ thip̱ki’da babam piti mo dhali ikam piti mo dhali aris ’kwani ’baar mo kun ta kuŋ gu’b gi com mo ki tonṯe/ mo isi ki mii jin mina uni mii ta gi a’di mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dhali tonṯe/ p̱iyi’d eya ris bampa/ ’baar mo haali/ ṯe/ a’di ishilki ’kwani is mo wakan bampa/ Masir dhali bampa/ Kanaan uni shi/ki is mo gom gwon ṯe/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Dhala Yuusup̱ tulki’da risa guurush is mo uni kun gamkunu mo e bampa/ Masir dhali ’peni Paŋ Kanaan gom pos jin yolkina ’kwani mo. Dhala Yuusup̱ ḵalki’da guurush e gu’b ma P̱irawn mo. ");
INSERT INTO udu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Dhali ka guurush ’baarki’d mo e bampa/ Masir mo dhali e bampa/ Kanaan mo tani aris ’Kwani Masir uni p̱u’dkina Yuusup̱ mo dhali o a’di gwo mo ki: C̱iyi aman tonṯe/ mo ma. To jin ta’da tinta imina amani wu mo ibwambori jis/em pini kan mo? Haali/ aguurush bam a’di ’baarki’d mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Dhala Yuusup̱ thoḵki uni gwo mo ki: C̱iyaa/ to/em bum mo dhali aha/ mina c̱i um tonṯe/ mo mmowan a’di e ki to/em bum mo waḵka guurush bum ’baarki’d mo. ");
INSERT INTO udu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Wakan uni ḵalki to/em buni aYuusup̱ mo dhala Yuusup̱ c̱iki uni tonṯe/ mo mmowan a’di e ki to/em buni kun tana ris, shumarum mo dhali ama’diny ḵa’bal mo dhala ŋul’kup̱ bip̱ dhali aris kuman thuluny mo dhali a’di thip̱ki uni ki tonṯe/ mo mmowan a’di e ki to/em buni kun tana uni ki yil c̱aan mo. ");
INSERT INTO udu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Dhali ki yil c̱aan ’baarki’d mo tani uni p̱u’dkini a’di ki yil jiŋ ’ko’d mo dhali o a’di gwo mo ki: Aman yisa mina ba’k gwo ’peni tap̱am bam ka guurush bam i’baarki’d mo dhali arisa ŋul’kup̱ to/e uni ta to gi tap̱am bam mo, toŋ kamu/ yisa boc̱ki’da e jis/e gi tap̱am bam mo hili jasi buŋgwar is bam dhali mony’cesh bam mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","To jin ta’da tinta i mina amani wu e bwambori jis/em pini mo, aman dhali mony’cesh bam mo? Yoli aman mo dhali mony’cesh bam ki tonṯe/ mo dhali aman nyaḵki mony’cesh bam imina ta c̱iŋkina/ ma P̱irawn kun yolu mo, dhali c̱iyi aman emena ḵa’bany to mo ki aman mina ’ko ki e mo dhali ’koki wu mo dhali mony’cesh si’da/ midi diki ta bwam ma’du/ mo. ");
INSERT INTO udu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Wakana Yuusup̱ yolki bampa/ Masiri ’baar mo goma P̱irawn mo haala ris ’Kwani Masir yolkina ris buntom buni mo haali/ ṯe/ a’di ishilki’da shil ki she/ ap̱o/ uni ki ’bi’th mo. Dhali mony’ceshi ’baar mo tani uni ta kuma P̱irawn gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Dhali gom ’kwani mo tani a’di dhuki uni mmota c̱iŋkina/ kun yolu mo ’peni yoḵkam Pa Masir itor karash ntagi ’bana kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Jasi mony’cesh ’kwani kun ta igasiis mo tani a’di dina a’di ki yol mo haali/ igasiis uni ita gi to kun ḵalkina uni ki me’d ’pena P̱irawn mo dhali ’ko ki e mo ’peni to gwansan kun ḵalkina uni ki me’d mo kun c̱ikin ma P̱irawn uni mo. Gom gwo gi wakan mo tani uni ’koki yol mony’cesh buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Dhali yan’ko’da Yuusup̱ oki ’kwani gwo mo ki: Hili mo mo ma, aha/ ’pena tee yansan mo tani aha/ yolkina um mo dhali mony’cesh bum goma P̱irawn mo. Shwane/ emena ḵa’bany annihe/ gom um mo dhali um mini si uni e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Dhali e bwam mondhe’d mo tani um mini c̱ika P̱irawn ’ban ’de/ ’peni uni kun ’kon ma p̱o/i mudhe’d mo dhali ’ban kun ’kon ma p̱o/i doŋon mo ’peni ap̱o/ ma kamu/ mudhe’d mo tani uni imini ta jim bum mo jin midi ta emena ḵa’bany to gom bunto mo dhali me’d tonṯe/ gom is bum mo dhali goma ris kuŋ gu’b bum mo dhali gom tonṯe/ gom ushi uc̱im bum mo. ");
INSERT INTO udu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Dhali uni oki a’di gwo mo ki: /E taki mondiki/em bam is is ki me’d mo. Dhalki gwo yan ’bor tap̱am bam bwa mo ki aman mina ta c̱iŋkina/ ma P̱irawn kun yolu mo. ");
INSERT INTO udu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Wakana Yuusup̱ a’di karki a’di mmota gwoŋḵan jin bahu mo isi gom gwo gi bampa/ Masir mo dhali a’di ’dishki’d ’pena cim c̱aan ntagi shwanesan mo ka P̱irawn midi bu’th ’ban ’de/ ’peni uni to kun ’kon ma p̱o/i mudhe’d mo. Mony’cesh gi igasiis uni ’cena ’koki ta ku ma P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Wakana Israyiil a’di ic̱a’bki’d mo e Pa Masir mo e mony’cesh gi Pan Jaasaan mo dhali uni gamki miiya du is e a’di mo, dhali dho’thki maman mo dhali mara/ amar is ki nyanye/ mo. ");
INSERT INTO udu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Dhala Yakuub c̱a’bki’d e bampa/ Masir ki yili ’kume’d i’ce’dka pesu/ ap̱o/ mo. A’di ita’da tee ma Yakuub gi wakan mo dhali yil gi mondiki/em piti ’koni iss ’kwanimpa ipesu/ i’ce’dka pesu/ ap̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Dhali ki mo ’dishkina ’twa/ mo ka Israyiil midi mii wu mo tani a’di yuḵki ya/m piti ka Yuusup̱ mo dhali o a’di gwo mo ki: Waḵki/ aha/ shwane/ mina gam mii ma ’the ’peni jis/em pini mo tani kari me’d pini awum pem mo dhali oyi gwo is mo mmota ga dum paŋ gana/ dhali tayi wathiŋ gana/ gom aha/ mo. Dhalku/ /e ki kanaa/ e bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Dhalki aha/ yana ish nyaḵki ibabam pem mo. Ḵali aha/ ka pije/ ’peni bampa/ Masir mo dhali kani aha/ e mom buni jin kana uniya kan mo. A’di thoḵki gwo mo ki: Aha/ mina mii a’di me’d jin okina /e mo. ");
INSERT INTO udu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Dhali a’di oki gwo mo ki: Thuli /e gwo me’da p̱o/ gom aha/ mo. Dhali a’di ithulki gwo me’da p̱o/ gom a’di mo. Dhala Israyiil a’di c̱a’bki’d ki goŋgo/ ki is piti mo ap̱o/ ’kup̱a cim piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","’Ko’di mii yan mo tani aYuusup̱ a’di ṯorkunu gwo mo ki: Hili mo mo ma, ababam pini a’di ’ba’thki’d mo. Wakan a’di suski iya/m piti isu/ mo iManassa dhala Ep̱rayim mo. ");
INSERT INTO udu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Dhali a’di ṯorkunuwa Yakuub mo ki: Ya/m pini ka Yuusup̱ a’di p̱u’dki’di /e mo, dhali yan’ko’da Yakuub iriny is piti mo mmogam mom’bi’th mo dhali c̱a’bki mis mo ap̱owa ci mo. ");
INSERT INTO udu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Dhala Yakuub oki’da Yuusup̱ gwo mo ki: Arumgimis jin Eḵa/ Eḵ a’di piki aha/ i is mo e Pan Luus mo e bampa/ Kanaan mo dhali a’di ’borki aha/ mii mo be. ");
INSERT INTO udu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Dhali a’di o aha/ gwo mo ki: Hili mo mo ma, aha/ mina kar /e mo mmodho’th maman kagahara mo dhali aha/ mina mar /e amar is mo dhali aha/ mina kar /e mo mmota adhana ŋul’kup̱ ’kwani mo dhali aha/ mina c̱i bampa/ yan ki emen pini mo i’ko’di /e mo mmota mom buni jin mina uni ibu’th ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Dhali shwane/ iya/m pini isu/ gwansan uni kun dho’thkunu /e mo e bampa/ Masir mo nṯwa/a/ ki aha/ dinaki p̱u’di /e e Pa Masir mo tani uni ta kum pem mo Ep̱rayim dhala Manassa uni imini ta kum pem mo me’d jin tan ma Ra/ubiin dhala Shim/uun kum pem mo. ");
INSERT INTO udu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Dhali uni kun minu c̱is ki /e ’ko’di uni mo tani uni a’di imini ta kum pini mo. Uni minu yuḵ gway gi ikam buni mo e mal buni mo. ");
INSERT INTO udu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Haali/ me’d jin p̱u’dkika/ mo ’peni Pam P̱addaan mo tani aRahiil ki bwan diṯi’d pem mo tani a’di wukaa/ mo e Paŋ Kanaan mo e bway jin iiyina ana mo ki ŋaṯgin si’dasi’d naskina/ mo mmo’taki ii bway Pan Ap̱raatah mo dhali aha/ kankina ayim imun mo e bway tur gi Pan Ap̱raatah mo (a’di jin ta Pam Beeṯlaham mo). ");
INSERT INTO udu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ka Israyiil p̱arki iya/ ma Yuusup̱ e mo kun ’koni su/ mo tani a’di oki gwo mo ki: Ija anni’dan mo? ");
INSERT INTO udu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yuusup̱ oki com gwo mo ki: Uni ta iya/m pem mo uni kun c̱ikin ma Arumgimis aha/ imahan mo. Dhali a’di oki gwo mo ki: Susi uni i aha/ mo ma, aha/ ’thona /e mo, ki aha/ mina ’bor uni mii mo. ");
INSERT INTO udu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Dhali e ma Israyiil a’di dhuruma/ dhurum mo goma dhan piti mo, wakan a’di imolkina a’di mmop̱ar e ki ’bore/ mo. Wakana Yuusup̱ suski uni mmo’dish a’di is mo dhali a’di ki p̱i uni ’twa/ mo dhali dhu uni mmota isa kony mo. ");
INSERT INTO udu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Dhala Israyiil oki’da Yuusup̱ gwo mo ki: Aha/ dara ki gwo ibwa mo me’dyin mo mmo’taki p̱ar jis/em pini e mo dhali hili mo mo ma, Arumgimis ki dhal aha/ bway mo mmop̱ar uc̱im pini e mo si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Dhali yan’ko’da Yuusup̱ shorki uni is mo ’peni ’kup̱a’dup̱un piti mo dhali a’di goŋki is piti mo dhali kar jis/em piti ka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Dhali aYuusup̱ bu’thki uni isu/ mo, Ep̱rayim ki me’da bim poros piti mo ’kup̱ki me’da biny cam ma Israyiil mo, dhala Manassa ki me’da biny cam piti mo ’kup̱ki me’da bim poros ma Israyiil mo dhali suski uni mmo’dish a’di is mo. ");
INSERT INTO udu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Dhala Israyiil he’thki me’da bim poros piti mo dhali ’thi a’di i’kup̱ ma Ep̱rayim a’di jin gwa’da’d mo dhali me’da biny cam piti di’di ’kup̱ ma Manassa mo mmo/aḵ abi e mo haala Manassa a’di ta’da bwanyara/ mo. ");
INSERT INTO udu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Dhali a’di ’borki’da Yuusup̱ mii mo dhali o gwo mo ki: Arumgimis a’di jin iikina ibabam pem ka Ibrahiim dhala Is/hak mo dhali Arumgimis jin shuki aha/ bway eya ris mondiki/em pem mo ntagi shwanesan mo, ");
INSERT INTO udu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","aman’doyu gwo a’di jin wanki aha/ ’ba/ mo ’pena ris tonthus mo, ’bori uc̱i mii mo. Dhali e uni mo tani dhalki gway pem lu/ki’d mo dhali gway gi ibabam pem ka Ibrahiim dhala Is/hak mo. Dhali dhalki uni can mo mmota dhana buhany ’kwani mo e bwaman mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ka Yuusup̱ p̱arki com e mmokar me’da bim poros piti i’kup̱a Ep̱rayim mo tani a’di ishi/ki a’di bwa mo, dhali a’di ki bu’th com ime’d mo dhali shor a’di me’d piti mo ’peni ’kup̱ ma Ep̱rayim mo mmokar a’di i ’kup̱ ma Manassa mo be. ");
INSERT INTO udu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Dhala Yuusup̱ ki o com gwo mo ki: Yisa ababam pem haali/ a’di yansan ita’da bwanyara/ mo. Kari me’da bim poros pini i’kup̱ piti mo. ");
INSERT INTO udu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hili ababam piti a’di i/ushki’d mo dhali o gwo mo ki: Aha/ misha mo ya/m pem mo, aha/ misha mo. A’di si’da/ midi war ki ’kwani mo dhali a’di si’da/ midi caaca mo. Bahili ara kam jin gwa’dagwa’d a’di imidi caaca kagahara mo mmobol a’di e mo dhali emen piti midi ta abuhany kal ’kwaniny’cesh ka ris mo. ");
INSERT INTO udu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Wakan a’di ’borki uni mii ka cim c̱aan mo dhali o gwo mo ki: Ki um mo tani Israyiil a’di imini bah mom’bor mii mo mmo/o gwo mo ki: Arumgimis midi kar /e me’da Ep̱rayim mo dhali me’da Manassa mo. Dhali wakan a’di karki’da Ep̱rayim nṯwa/a/ ka Manassa mo be. ");
INSERT INTO udu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Dhali yan’ko’da Israyiil oki’da Yuusup̱ gwo mo ki: Hili mo mo ma, aha/ ’dishkina ’twa/ mmowu mo, hili Arumgimis midi nyaḵ di ki /e mo dhali a’di midi susi /e bway pa ka nyaŋ’ko’d e mony’cesh gi ibabam pini mo. ");
INSERT INTO udu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ba aha/ c̱ikina /e tony caaga/ mmobol ikan e mo a’di jin ta ’ban ’de/ ka wosha turga/ mo a’di jin bu’thka/ ’peni me’d gi ’Kwani Amuur ki gandala turgam pem mo dhali ki bwam pem mo be. ");
INSERT INTO udu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Dhali yan’ko’da Yakuub yuḵki iya/m piti mo dhali o gwo mo ki: Tuli um is bumi monṯal ’de/ mo ki aha/ mina ṯor um to kun mini mii ṯaka p̱o/ um yilin tiya kun mini iiyu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Tuli is mo dhali ciḵ gwo mo, ayy um iya/ ma Yakuub mo dhali ciḵi gwo ma Israyiil jin ta’da babam bum mo. ");
INSERT INTO udu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ra/ubiin /e tana bwanyaram pem mo, ’peni mo ma dem dem pem mo dhali ’peni maman pem kun ṯwa/a/ gi mom’bi’th is mo dhala liṯgan pem mo e monyca mo dhala liṯgan e mom’bi’th mo. ");
INSERT INTO udu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","/E jin gwakalki mii mo me’d yi’de/ mo tani /e mini gam mo jin mina /e idiya liṯgan yisa, haali/ /e sekim ka ci gi cim mo dhali shi/ a’di is mo dhali /e yakin ki mis mo eya ci ma nyaŋa’b pem mo. ");
INSERT INTO udu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shim/uun dhala Lawi uni kun ta ikam mo. To gi mo/as gom mo ma bujur mo tani uni ita gandala turgam buni mo. ");
INSERT INTO udu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ayy aḵashiram pem midi diki ya ’kup̱ ki mo ma tul is buni mo. Ayy shi/in pem midi diki gam dhana ŋul’kup̱ ’kwanim buni is mo. Goma nyor buni mo tani uni ’koshki ’kwani mo dhali mmocana uni bwa en’dap̱ buni mo tani uni ki ’ciṯẖa morbip̱ buni dugu’b gi ’kup̱a’dup̱un buni mo be. ");
INSERT INTO udu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Monyjee midi di goma nyor buni mo haali/ a’di c̱ithirac̱ithir mo, dhali anyor buni mo tani a’di si’da/ ita ji maṯ mo. Aha/ mina ḵwa/ uni bwa mo e bwaman ma Yakuub mo dhali c̱eker uni bwa mo e bwaman ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuuda, ikam pini uni imini maŋ /e mo dhali me’d pini midi di eya aris ’ba/ gi ’kwani kun ta ’kup̱ ki /e mo. Iya/ gi cim uni imini goŋ is ka ’cesh ibwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuuda a’di ita adhop̱ dhuru’c mo. ’Peni mo jin dheru to bwa ka gwap̱i/ mo, ayy ya/m pem, /e yaki bway mis mo. A’di wup̱ki’da ’cesh mo dhali a’di ishki’d ki bara’th me’da dhop̱ mo dhali me’d kumana dhop̱ mo. Aja a’di iro’dki mii mo mmomer a’di e mo? ");
INSERT INTO udu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Cwa ma maliḵ midi diki p̱i mo ’peni Yahuuda ki sule/ mo walla cwa gi amanjinuwa ji ’peni bwaman sho’k piti mo ntagi a’di midi p̱u’dku/ e a’dim piti jin cila a’di mo, dhali e a’di mo mo jin hanu gwo e ki ’kwani midi mii di mo. ");
INSERT INTO udu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A’di deḵki ari thuluny dhuru’c piti ki cwalmana mura’th mo dhali ari dhuru’c thuluny piti cwalmana mura’th jin kwanykunu mo gom ’boro’d piti mo tani, a’di wuski burrinyem piti ki yimana mura’th jin ḵa/u ki ŋah ŋah mo dhali burrinye/ ma p̱om piti eya basa mura’th mo. ");
INSERT INTO udu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Em piti midi c̱a’bki dhir dhir gom yimana mura’th jin ḵa/u ki ŋah ŋah mo dhali she/ piti midi tagi kush goma ko mo be. ");
INSERT INTO udu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabuluun a’di imidi c̱a’b e yana gap̱ gi bwam ma al mo, a’di imidi war ki mo kun min ma risa ḵur yi’de/ ikoḵ ’kup̱i nycine/ mo, dhali bwayam piti midi ya ntagi Pan Sidun mo. ");
INSERT INTO udu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Yassaakar a’di imidi ’bitha’bi’th me’d thuluny mo mmothum ’kup̱ ka luŋgu’b mo e bwaman ma ma’diny ḵa’bal mo. ");
INSERT INTO udu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A’di p̱arki mo jin sinu is e mo, ki a’di ’bora’bor mo dhali bampa/ ki a’di ta gi jin ’boru bwa mo. Wakan a’di igoŋkina a’di ’kup̱a bim piti ka ’cesh mo dhali ḵala/ ḵal mo dhali a’di warki’d ki c̱iŋkina/ jin yolu mo jin miinu ki ’bi’th goma ṯu’c mo. ");
INSERT INTO udu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daan a’di imidi ta amandwall ’kwanim piti gwo mo, me’d a’din ’de/ e bwaman ma waḵ gi ’Kwani ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan a’di imina e i wa ki tasha/ jin ishki’d e shemen bway mo a’di jin ta tashan ’thi/ jin ishki’d e bway tur jin iinu mo mmowo’c shumarum ’pena ṯiŋkilam piti mo wakan ka manmer a’di ap̱o/ mo tani a’di imidi biṯ ki tar mo be. ");
INSERT INTO udu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aha/ c̱orkina mowoṯẖ pini mo ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Iman’ceya/ ’ce ki buw buw mini ’ceya Jaadi is mo, hili a’di imidi ’ce uni ki is eya panyjap̱am buni mo. ");
INSERT INTO udu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Tonṯe/ jin min ma Ashiir ishwa mo tani uni mini ṯawusaṯawus mo dhali a’di midi dho’th ton ṯawusga/ ma maliḵ mo. ");
INSERT INTO udu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nap̱taali a’di imina e wa ka yuul jin dhalkunu me’d ki ’kus mo jin dho’thki ushana ’borga/ mo. ");
INSERT INTO udu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yuusup̱ a’di imidi ta abinycwa jin midi dho’th maman mo abinycwa jin midi dho’th maman monyjoc̱o/ mo. Abinycwam piti mini so wup̱uni ’kup̱ agangara/ ma goŋ bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","’Kwani kun mishina bwa shin kun c̱ithirac̱ithir mo tani iwup̱kina p̱o/ a’di mo dhali shin a’di mo dhali ’cwar a’di ki ŋara’d ŋara’d mmobur a’di adu mo. ");
INSERT INTO udu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Baṯẖtho/ abwam piti ṯikir di mo mmo’konu ki joc̱ a’di mo, dhali abim piti dhunu ki mo jin mishu mii mo ki me’d gi a’din ’de/ jin Eḵa/ Eḵ mo a’di jin ta jima Yakuub mo (ki gway ma Manhil Ḵa’bal mo jin ta Wosh ma Israyiil mo.) ");
INSERT INTO udu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ka Arumgimis ma babam pini mo a’di jin midi woṯẖ /e mo, a’di jin ta’da Arumgimis jin Eḵa/ Eḵ mo a’di jin midi ’bor /e mii mo ka ris mom’bor mii gi momis kun ’koni buŋ’kup̱ mo, dhali aris mom’bor mii kun ’kon e moŋ’kulga/ mo kun p̱arashap̱arash e bwaŋ’kwariny mony’cesh mo dhali aris mom’bor mii ’pena risa bor kun c̱ina ko mmop̱i mo dhali aris bwama dho’th mo. ");
INSERT INTO udu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mom’bor mii ma babam pini mo uni ita mo ma dem dem jin ’ce’dki gwayu/ ma ris mom’bor mii ma ris wosha turga/ kun ’konu ki sule/ sule/ mo dhali maman gi wosha turga/ kun ’konu ki sule/ sule/ mo. Dhalki uni ’kon mo e ’kup̱a Yuusup̱ mo dhali eya mur ’ko’d em piti mo a’di jin karkunu ki she/ ’peni ikam piti mo. ");
INSERT INTO udu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamiin a’di ita awuu jin pitili to ki she/ mo, e mon’thamo/ mo tani a’di midi la shwa ’kwani ki ’ci’d’da/ mo dhali mom’pimpili/ mo a’di ki pwaḵ to bwa mo uni kun dilina a’di ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Uni gwansani ’baar mo tani uni itana waḵ ma Israyiil kun ’koni ’kume’d i’ce’dka su/ mo, dhali gwo jin ṯorkin ma babam buni uni anann mo me’d jin ’borkina a’di uni mii mo mmo’bor uni mii ka ’deṯe/ ’deṯe/ mo, mom’bor mii kun ha me’d mo gom a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Dhali yan’ko’d a’di ḵanki uni gwo mo dhali o uni gwo mo ki: Aha/ minu mii ’tuma bi is imonṯal ’de/ nyaḵki ’kwanim pem mo. Kanaa/ nyaḵki ibabam pem mo e jurum wosh gi mombunto Ip̱ruun mo, jin ta Wathi/ Hiṯẖṯẖa mo. ");
INSERT INTO udu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","E jurum wosh gi mombunto ma Maḵp̱iilah jin diki’d ki mom’pesho’k gi Pa Mamra mo e bampa/ gi Paŋ Kanaan mo a’di jin yolkin ma Ibrahiim ’peni bwam bunto ma Ip̱ruun jin ta ’Kwani Hiṯẖṯẖa mo e mo jin mina a’di imii ta mo gom mo jin kanuwa kan mo. ");
INSERT INTO udu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","E mo yan mo tani a’di ikankina uniya Ibrahiim nycine/ mo dhala Saarah jin ta ash mo, dhali imun si’da/ mo tani a’di kankina uniya Is/hak dhala Rip̱ka jin ta ash mo dhali imun si’da/ mo tani a’di ikankika/ aLe/ah mo. ");
INSERT INTO udu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Bwam bunto dhali jurum wosh gwansan mo tani a’di iyolkunu ’peni ’Kwani Hiṯẖṯẖa mo. ");
INSERT INTO udu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ka Yakuub ’baarki gwo jin ḵankina a’di ya/m piti mo tani a’di dhuki sho’k piti eya ci mo dhali a’di c̱iki shi/in piti jiŋ ’ko’d mo dhali a’di tulkunuwa abi is nyaḵki ’kwanim piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Dhali yan’ko’da Yuusup̱ biṯki’di ’ba/i com mo dhali ko eya p̱o/i a’di mo dhali p̱i a’di ’twa/ mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Dhala Yuusup̱ ḵanki’da ris c̱iŋkinam piti gwo mo ka ris uni kun tana hakiim mini lol com bwa mo a’di idina a’di ki bul mo. Wakana risa hakiim uni lulkina Israyiil bwa mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Acimi iss ’kwanimpa su/ a’di i’theḵkunu gwo mo gom a’di mo, haali/ acim tana ris wakan kun ’theḵkunu gwo mo mmolol bwa mo. Dhali ’Kwani Masir uni gwokin gom a’di ka cim iss ’kwanimpa ikwara i’ce’dka ’kume’d mo. ");
INSERT INTO udu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Dhali ka tee jin gwokunu gom a’di ’baarki’d mo tani aYuusup̱ ṯorki’da ṯor ki kuŋ gu’b ma P̱irawni ’baar mo mmo/o gwo mo ki: Waḵki/ aha/ mina gam mii ma ’the e jis/em pini shwane/ mo tani, oyi gwo mo, aha/ ’thona /e mo, e bwany’ce ma P̱irawn mo mmo/o ki: ");
INSERT INTO udu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ababam pem kar aha/ mmothul gwo me’da p̱o/ mo mmo/o ki: Ki aha/ mura ’twa/ i’dish i mmomuri wu mo tani e jis wosh jwam pem jin ’kulkika/ mo e Paŋ Kanaan mo tani a’di iminu kan aha/ imun mo. Dhali shwane/ gom gwo gi wakan mo tani dhalki aha/ yana ka gagamis mo, aha/ ’thona /e mo, dhali kana babam pem mo dhali yan’ko’d aha/ ki doḵu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Dhala P̱irawn thoḵki gwo mo ki: Yaku/ ka gagamis mo dhali kani cim mo me’d jin karkina a’di /e mmothul gwo me’da p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Wakana Yuusup̱ yaki’d ka gagamis mo mmokana babam piti mo dhali nyaḵki a’di mo tani c̱iŋkina/ tana ris kun baṯẖki a’di mo ’peni ku ma P̱irawn mo dhali aris ’kwaniŋ gwanyjaḵa/ ’peni ku ki gu’b piti mo dhali aris ’kwaniŋ gwanyjaḵa/ gi bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Dhali isi kan aris kuŋ gu’b ma Yuusup̱i ’baar mo ikam piti dhali aris kuŋ gu’b gi com mo hili jasi ushi uc̱im buni a’di idhalkunu mo dhali ama’diny ḵa’bal buni mo dhali adhana ŋul’kup̱ bip̱ buni mo uni a’di idhalkunu mo e Pan Jaasaan mo. ");
INSERT INTO udu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Dhali aris ’kwani kun merkina arabiya kun dira shumarum mo tani uni inyaḵki ii ka gagamis nyaḵki a’di mo dhali aris ’kwani kun mer shumaruma p̱o/ mo a’di ta dhana buhany wathimpa jin seki’d jin caaca kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ki uni p̱u’dkin mo e ja’dam pos gi Pan Athaad mo a’di jin diki’d e bwamp̱o/ Yi’deŋ Ḵumma/ Uurdun mo tani uni ḵumki ko mo imun mo gom dhan bwan diṯi’d kagahara mo e kony jwa jin gwokina uni mmo/up̱ e ki jabu’th mo dhali a’di karki mo jin gwonu ki kony jwa gom com ka cima pesu/ mo. ");
INSERT INTO udu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ki ’kwani kun cila mony’cesh yan mo tani uni gun ta ’Kwaniŋ Kanaan mo p̱arki kony jwa jin gwokunu mo e ja’dam pos gi Pan Athaad mo tani uni oki gwo mo ki: Kony jwa yansan jin gwokunu mo tani a’di ita a’di jin jwakaṯki’da du mo gom ’Kwani Masir mo. Gom gwo gi wakan mo tani a’di iyuḵkunu mo yan gway ka Aabilmisrayim mo. A’di jin diki’d e bwamp̱o/ Yi’deŋ Ḵumma/ Uurdun mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","To jin miina iya/m piti gom a’di a’dan mo me’d jin ḵankina a’di uni gwo mo. ");
INSERT INTO udu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Haali/ iya/m piti ḵalki a’di mo e mony’cesh gi Paŋ Kanaan mo dhali kan a’di mo e bwam bunto ma Maḵp̱iilah mo a’di jin di’d ’kup̱ki mom’pesho’k gi Pa Mamra mo a’di jin yolkin ma Ibrahiim ’pena Ip̱ruun jin ta wathi/ Hiṯẖṯẖa mo mmokar a’di ki mo jin minu kana kani cine/ mo. ");
INSERT INTO udu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","’Ko’di a’di kanki’da babam piti mo tani, aYuusup̱ doḵki bway Pa Masir mo nyaḵki ikam piti mo dhali aris ’kwani ’baar mo kun nyaḵki ii ki a’di ka gagamis mo mmokana babam piti mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ki ikam ma Yuusup̱ p̱arki mo e mo ka babam buni a’di iwuki’d mo tani uni oki gwo mo ki: Wariba/ aYuusup̱ midi shi/ ana i e mo dhali ri/ ana mo goma ris tonthus kun miikina ana a’di ap̱o/ me’d yin mo. ");
INSERT INTO udu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Gom gwo gi wakan mo tani uni hashki gwo aYuusup̱ mo dhali o gwo mo ki: Ababam pini a’di iḵanki gwo yansan nṯwa/a/ ki a’di diki wu mo ki: ");
INSERT INTO udu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Oya Yuusup̱ gwo mo ki: Gwami agwam mo ma, aha/ ’thona /e mo, gwondhaŋ gi ikam pini mo dhali miinthus buni mo haali/ uni miiki /e tonthusa p̱o/ mo. Dhali shwane/ am ’thona /e ki /e mini gwama/ gwam mo gom gwondhaŋ gi c̱iŋkina/ ma Arumgimis mo jin ta’da Arumgimis ma babam pini mo. Yuusup̱ a’di gwoki’d mo me’d jin ṯorkina uni aṯor ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Dhali ikam piti p̱u’dkin mo dhali ṯaka ’ceshi bwambori a’di mo dhali o gwo mo ki: Hili mo mo ma, aman tana c̱iŋkinam pini mo. ");
INSERT INTO udu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Hila Yuusup̱ oki uni gwo mo ki: Dhalku/ is ki ḵo/ mo ma haali/ a/aha/ be dina e embul ma Arumgimis mowa? ");
INSERT INTO udu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Haali/ me’d um mo, kagush tani um kar to ap̱o/ aha/ ki ’pemen thus mo hili Arumgimis a’di ikarki a’di ki ’pemen jim ’boro’d mo mmowaski mii yan mo ki ’kwani ka ris ris minu dhu ki e mo, me’d jin ’kokina uni ki e shwanesan mo. ");
INSERT INTO udu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dhalku/ is ki ḵo/ wakan mo, aha/ mina thip̱ um mo dhali ushi uc̱im bum mo. Wakan a’di rokomki uni ki gwo mo dhali malas uni mo. ");
INSERT INTO udu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Wakan Yuusup̱ a’di c̱a’bki’d mo e bampa/ Masir a’di nyaḵki ’kwani gi gu’b gi com mo. Dhala Yuusup̱ a’di c̱a’bki’d ki e mo ki yil iss ’kwanimpa imudhe’d i’ce’dka ’kume’da p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Dhala Yuusup̱ p̱arki uc̱i ma Ep̱rayim e mo kun ’kon ma aṯa/i kwara mo dhali uc̱i ma Maakiir si’da/ mo a’di jin ta ya/ ma Manassa mo uni dho’thkunu mo e ’kup̱a’dup̱un ma Yuusup̱ mo. ");
INSERT INTO udu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Dhala Yuusup̱ oki ikam piti gwo mo ki: Aha/ ’dishkina ’twa/ mmomuri wu mo hili Arumgimis a’di midi yayu/ mmobuṯi um mo dhali a’di midi susi um bway pa ka nyaŋ’ko’d mo ’peni bampa/ yansan e mony’cesh jin thulkina a’di a/Ibrahiim gwo me’da p̱o/ mo goma Is/hak dhala Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Dhali yan’ko’da Yuusup̱ bu’thki mo jin thulu gwo me’da p̱o/ mo e iya/ ma Israyiil mo mmo/o gwo mo ki: Arumgimis midi yayu/ mmobuṯi um mo dhali um mini ḵal asimam pem mo ’peni mahan mo. ");
INSERT INTO udu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Wakana Yuusup̱ a’di iwuki’d mo mmo’kokina yil a’di i/iss ’kwanimpa imudhe’d i’ce’dka ’kume’da p̱o/ mo, dhali uni lolki is piti mo dhali a’di karkunu mo e bwam ma ḵur jwa mo e bampa/ Masir mo be.");
INSERT INTO udu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Gwansan i ta gway gi iya/ ma Israyiil mo uni kun iikin bway Pam Masir mo nyaḵka Yakuub mo, aris uni ka ’deṯe/ ’deṯe/ mo ’peni kuŋ gu’b piti mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ra/ubiin mo dhala Shim/uun dhala Lawi mo dhala Yahuuda/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yassaakar dhala Sabuluun dhala Benyamiin mo. ");
INSERT INTO udu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daan dhala Nap̱taali dhala Jaad dhala Ashiir mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Aris emen ma Yakuub i ’baar mo uni ’ko iss ’kwanimpa i kwara i’ce’dka ’kume’d mo. Dhala Yuusup̱ diki’di ṯwa/a/ e Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Dhali yan’ko’d aYuusup̱ wuki’d mo dhala ris ikam piti mo dhala risa nyaḵum yil ki uc̱im buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Hili emen ma Israyiil uni dho’thkin ka ris mo dhali markunu is kagahara mo. Dhali uni eḵkin mo ki nyanye/ dhali ’bi’thkina is ki ’bi’th mo. Gom kan mo tani Pam Masir ’tu’dkunu ki uni mo. ");
INSERT INTO udu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Dhali yan’ko’d amaliḵ thisa kamu/ bu’thki embul ma kamu/ dhamo/ mo i Pam Masir mo a’di jin diki misha Yuusup̱ mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Dhali a’di ki o ’kwanim piti gwo mo ki: Ayy, ’kwani ma Israyiil uni tana ris ka ris mo dhali uni si’da/ ’bitha’bi’th mo mmobol ana e mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Waḵki/ mo/as midi biṯa p̱o/i ana mo tani uni mini gam me’d ki ’kwani kun ta ’kup̱ ki ana mo dhali as ana mo dhali ye mo ’peni bampam bana mo be. Dhalki ana ṯikira ap̱o/ uni ki yuḵ yuḵ mo ki uni mini ’koki mar is mo. ");
INSERT INTO udu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Gom ’kup̱ gwo yan tani uni dhuki itap̱a ap̱o/ uni mo mmoṯa/ uni is jwa ka ṯu’c kun diṯadiṯ mo. Dhali uni nyaŋkina P̱irawn ’peŋkuman bampa/ ki jasi mondhu tom piti mo kun yuḵu gway ka Piṯuum dhala Ramasiis mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Hili ki ’kwani ma Israyiil ’kokunu mo mmosirica p̱o/ ki sho’k mo ki nyanye/ mo tani uni si’da/ markunu is mo ki nyanye/ mo dhali mmohakara ’cesh ka bor mo. Wakan ’kwani Pam Masir uni ḵo/ ki is mo gom ’kwani ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Wakan uni dhuki ’kwani ma Israyiil mo mmomiiya ṯu’c ki c̱iŋkina/ ki mom’bi’th mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Dhali uni si’da/ dhuki ’kwani ma Israyiil is mmo’ta’bula’ta’bul mo ka ṯu’c jin ’batha’ba’th mo mmo’thoḵa jeeŋ gu’b mo dhali eya risa ṯu’c kun ’kona e ki she/ ki she/ mo e bwam buntom buni mo. Eya risa ṯu’c buni gwansani ’baar mo tani c̱inu uni ki dar gi mo si/is mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Dhali yan’ko’da maliḵ gi ’kwani Pam Masir ki o iShip̱ira uni ka Puu/a kun ta up̱ kun dho’th tiya Ibraniyiin gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Waḵki/ um dho’th up̱ ’kwani Ibraniyiin mo dhali um ki p̱ar uni e eya p̱owa birish jin dhodhuwa dho’th ap̱o/ mo tani, ’koshi a’di jwa mo waḵki/ ta’da ’ciŋgwaṯẖ mo. Hili waḵki/ ta’da ’bomi mo tani dhalka yim di’d ki e mo. ");
INSERT INTO udu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Hili up̱ gwansan kun dhodhi tiya mo tani uni ḵo/kina Arumgimis mo. Dhali uni ’koki mii gwoŋḵan ma maliḵ gi Pam Masir jin ḵankina a’di uni mo. Hili uni dhal uc̱iŋgwaṯẖ mo mmo’ko ki e mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Dhali amaliḵ gi Pam Masir a’di yuḵki up̱ gwansan mo dhali o uni gwo mo ki: Atinta miina um kan mo mmodhal uc̱iŋgwaṯẖ bway mo mmo’ko ki e kan mo? ");
INSERT INTO udu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Up̱ kun dhodhi tiya thoḵkina P̱irawn gwo mo ki: Haali/ up̱ gi ’Kwani Ibraniyiin yisa wa ki up̱ gi ’kwani Pam Masir yisa. Hili uni c̱a’b ki dem dem mo dhali uni la dho’th uc̱im buni nṯwa/a/ mo ki aman ’konaki p̱u’d naskina/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Wakan Arumgimis miiki’d ki ’bore/ gom up̱ gun dho’thki tiya mo. Dhali ’kwani markunu is ki nyanye/ mo dhali uni c̱a’b ki dem dem e mom’bi’th buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Dhali gom moŋḵo/ jin ḵo/kina up̱ Arumgimis mo tani a’di c̱iki uni uc̱im buni si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Dhali yan’ko’d mo tani aP̱irawn ḵanki’da ris ’kwanim piti gwo ’baar mo ki: Aris iya/ kun dho’thkunu gom ’kwani Ibraniyiin mo tani minu ṯa’kku/ mo e ḵumma/ yi’de/ mo, hili um mini dhalku/ ushi i’bwa/ i ’kon ki e mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Dhali ki embul yan wathi/ ’peni ’Kwani Lawi masha’da ’bom ’pena waḵ piti mo. ");
INSERT INTO udu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Dhali a’bom bwaki’d mo dhali dho’th ya/ mo. Dhali ka yim p̱arki a’di e mo ka ’ci ’bora’bor mo tani ayim ki bag a’di mo ka ppee ’kup̱i kwara mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Dhali ka yim mol a’di bag ki rash rash mo tani ayim ’kuc̱ki’da gup̱p̱a mo jin uḵkunu mo ’pena ’ci’d mo dhali rus a’di ka ’bi’c mo dhala sip̱ti/ mo, mmonon yi’de/ ki bway mo mmose bwa gup̱p̱a mo. Dhala yim ki kara ’ci nycine/ mo dhali karki a’di e bwam ma ’ci’d jin di’d i shemen ma gap̱ gi ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Dhali ’bwah ma ’ci doshki’d ari kaṯan mo mmop̱ar mo e mo ka ta a’di i midi p̱u’d e ara kam mo. ");
INSERT INTO udu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Dhali ’bwa/ ma P̱irawn p̱u’dki’d ka luŋgu’b mo mmo/up̱ yi’de/ mo e ḵumma/ yi’de/ mo. Dhali aris nyara/ gun mii a’di aṯu’c iikin e yan wor mo tani ayim mishki’da gup̱p̱a mo e bwam ma ’ci’d mo. Dhali ayim ki hash nyarany c̱iŋkinam piti mo mmo’cwam a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Dhali ka yim ḵa’dki a’di ’kup̱ mo tani ayim p̱arki ara ’ciŋgwaṯẖ e mo. Dhali ara ’ci di’d mmoko mo. Ayim hilki a’di ki e ma ’thime/ gi mo/en mo dhali o gwo mo ki: Yansan a’di i ta ara ’ci ’peni ’Kwani Ibraniyiin mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Dhali yan’ko’d ’bwah ma ’ci yansan ki o ’bwa/ ma P̱irawn gwo mo ki: Miga/ ya mo dhali yuḵi /eya manthip̱a ’ci ’peni bwaman up̱ ’Kwani Ibraniyiin mo mmothip̱ ki /eya ’ci mo ’taa? ");
INSERT INTO udu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Dhali ’bwa/ ma P̱irawn ki o ari nyara/ gwo mo ki: Nye, yaku/ mo ma. Gom gwo gi wakan mo tani ari nyara/ yaki’d mo dhali yuḵi kum ma ’ci mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Dhali ’bwa/ ma P̱irawn o’da yim gwo mo ki: ḵalka ’ci yansan mo dhali thip̱i a’di mo gom aha/ mo dhali aha/ mina c̱iki /e to jin miina /eya ṯu’c gom a’di mo. Gom gwo gi wakan mo tani a’bom bu’thki’da ’ci mo dhali thip̱ a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Dhali a’ci caki’d mo dhala yim ki ḵalki a’di ’bwa/ ma P̱irawn mo dhali a’di warki’d ki ya/ ma yim mo. Dhali ayim ki yer a’di gway ka Musa mo goma yim oki gwo mo ki: Haali/ aha/ ’cwamkina a’di ka pije/ mo ’peni yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ka Musa caki’d mo tani a’di yaki’d ka pije/ mo mmobuṯi ’kwanim pitiŋ gana/ mo dhali p̱ara ṯuca diṯga/ gi kwanim piti e mo. Dhali a’di p̱arki wathi/ Masir e mo mmo’koshkina a’di wathi/ Ibraniyiin mo a’di jin ta wathi/ ’peni ’kwanim piti mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","AMusa ki ’kar mo ki e mo dhali jan ṯal ’deŋ kamu/ yisa di’da. Dhali a’di ki ’kosh wathi/ Masir jwa mo dhali bag a’di mo e bwam ma si’b mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ka cim jiŋ ’ko’d, a’di yaki’d ka pije/ i ’kwanim piti doḵ e mo dhali a’di ki mish ’kwani Ibraniyiin i su/ ḵalkin ki as c̱em buni mo. Dhali a’di ki o wathi/ jin dina mii i ’ba/ gwo mo ki: Atinta i dorkina /eya waḵ pini mo kan? ");
INSERT INTO udu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A’di thoḵki a’di gwo mo ki: Aja i kar /e ki tap̱a mo dhali ka mandwall aman gwo mo? A /e kulumki gwo i bwa mo mmoŋap̱i ’kosh aha/ jwa mo me’d jin ’koshkina /e wathi/ Pam Masir mo ’taa? Dhali yan’ko’d aMusa ḵo/ki is mo dhali kulumki gwo ’kup̱ mo ki to yansan ka jiŋ gana/ mishu mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Yan’ko’da maliḵ ciḵki gwo yansan mo dhali ŋap̱a Musa ki minu ’kosh jwa mo. Hila Musa guski’d mo ’pena P̱irawn mo dhali a’di yaki’d mmoc̱a’b e Pam Midyaan mo be. Dhali ka cima kamu/ a’di c̱a’bki’da ’cesh e shemen jis yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Dhala gasiis gi Pam Midyaan taki’d gi i ’bwa/ i pesu/ mo dhali uni p̱u’dkin mo mmomush yi’de/ e mo jin c̱a’b ma Musa i shemen mo. Dhali uni ’tu’dkina ḵur ki yi’de/ mo goma ma’diny ḵa’bal dhali miya ma babam buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Imanhil ḵa’bala tiya uni p̱u’dkin mo dhali ur uni mo. Hila Musa cuki mis mo dhali woṯẖki nyara/ dhali doḵi uni ka nyaŋ’ko’d mmowol ki uni to em buni yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ki nyara/ doḵkin eya babam buni ka Rau/iil mo tani a’di ki o uni gwo mo ki: ’Pemen ta’da ta layina um p̱u’du/ gane/ ki jahanne/ kan mo? ");
INSERT INTO udu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Uni ki thoḵ gwo mo ki: Wathi/ Masir a’di i woṯẖki aman mo ’peni me’d gi imanhil ḵa’bal mo dhali a’di si’dayi ki mush ki aman yi’de/ mo dhali wolki to e mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A’di oki i’bwa/ gwo mo ki: Mane a’di mane? Atinta i dhalina um wathi/ mo? Yuḵi a’di mo ma ki a’di midi shwa to nyaḵki ana mo. ");
INSERT INTO udu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Dhala Musa gamki gwo me’d mo mmoc̱a’b mo nyaḵki wathi/ yan mo. Dhali a’di c̱iki’da Musa ’bwa/ jin yuḵu gway ka Sap̱uura mmota ash mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ayim dho’thki a’di ya/ mo dhala Musa ki yer a’di gway piti ka Jirshuum mo haali/ a’di oki gwo mo ki: Aha/ dina ka c̱is e pampaŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","I’ko’di yil ka ris pekin mo tani amaliḵ gi ’kwani Pam Masir a’di wuki’d mo be. Dhali ’kwani ma Israyiil uni ’kon mmo/ohon mo e bwaŋ’kwariny miiny c̱iŋkinam buni mo dhali uni ḵumki cuuwa mo gom mowoṯẖ mo. Dhali kom buni e bwaŋ’kwariny miiny c̱iŋkina/ mo tani ciḵkin ma Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dhali Arumgimis ciḵki mo/ohon buni mo dhali a’di kakina gwo e mo jin gamkina a’di me’d ki mondeḵ nyaḵka Ibrahiim mo dhali nyaḵka Is/hak mo dhali nyaḵka Yakuub mo be. ");
INSERT INTO udu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Dhali Arumgimis mishki ’kwani ma Israyiil mo dhali a’di ta gi bwaŋ kulum ap̱o/ uni mo gom moŋ’kom buni jin shi/ashi/ kan mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Dhala Musa ta’da amanhila ma’diny ḵa’bal ma mar piti ka Rau/iil mo jin ta’da gasiis gi Pa Midyaan mo. Dhala Musa urki’da ma’diny ḵa’bal piti dhali ’ciṯẖ bway mombwaasho mo dhali p̱u’di Wosh Sinaa/ jin ta wosh jin ḵogu mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Dhali aman’doyu/ gwo gi TAP̱A piki a’di i is ka le’dan o’d e ari bwaman cwa mo. Dhala Musa p̱arki mo e dhali merki’d mo ki cwa shwakina o’d mo dhali a’di ’konu ki kup̱ ki sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Dhali aMusa ki kulum gwo i bwa mo ki: Atinta dina o’d ki kup̱ ari bwaman cwa yan mo kan sa/? Aha/ mina shorki is mo dhali p̱ar dhan miimer yan e mo. ");
INSERT INTO udu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ki TAP̱A p̱arki mo e ka Musa ya’d mmo’dish mo is mmop̱ar mo e mo tani Arumgimis yuḵki a’di ’peni ari bwaman cwa mo ki: Musa, Musa. Dhali a’di thoḵki gwo mo ki: Aha/ dina i se mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Dhali yan’ko’d Arumgimis ki o a’di gwo mo ki: Dhalku/ ki shor mmo’dish mo yan is mo. ’Cuḵa p̱p̱am pini ’peni sho’k mo ma haali/ mo yan jin dina /e i cine/ mo tani ta’da ’cesh jin ḵogu mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Dhali a’di ki o a’di gwo mo ki: Aha/ tana Arumgimis gi ibabam pini jin ta’da Arumgimis ma Ibrahiim mo dhali Arumgimis ma Is/hak dhali Arumgimis ma Yakuub mo be. Dhali yan’ko’da Musa tiḵki jis em piti mo haali/ a’di ḵo/ki is mo mmohila Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Dhali yan’ko’d TAP̱A ki o a’di gwo mo ki: Aha/ misha isa nyor jin wo’cki ’kwanim pem mo uni kun ’kokin mo e Pam Masir mo. Dhali aha/ ciḵkina kom buni mo gom mii gi imanjiya ṯu’c buni kun ta ’Kwani Masir mo. Dhali aha/ misha moŋ’kosh is ka nyor buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Dhali aha/ thulkina ka ’cesh mo mmo’cuḵ uni ’peni me’d gi ’Kwani Masir mo. Dhali aha/ mina sus uni mo ’peni pa c̱aan mo bway mo jin ’kosh jwa mo jin isha ris embul mo dhali jin ’bor ma ’cesh ki ’bor mo. A’di ta mo jin ’kona ’kwani Paŋ Kanaan mo dhali Pa Hiṯẖṯẖa mo dhali Pa Amuur mo dhali Pam P̱aaris mo dhali Pa Hayp̱a mo dhali Pa Yabuus mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Dhali shwane/ aha/ ciḵkina ko gi ’kwani ma Israyiil mo dhali aha/ mishkina mo jin siriju asiri’c ki sho’k jin ’kokina ’Kwani Pam Masir mmosiri’c uni ap̱o/ ki sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Dhali shwane/ yaku/ mo ma, aha/ mina hash /e aP̱irawn mo ki /e mini mish susu ’kwanim pem ka pije/ mo, uni kun ta ’kwani ma Israyiil mo ’peni Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Hila Musa thoḵki’da Arumgimis gwo mo ki: Aha/ jana/ sa/ mina ’taki ya aP̱irawn dhali susi ’kwani ma Israyiil ka pije/ ’peni Pam Masir mo? ");
INSERT INTO udu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Arumgimis ki thoḵ a’di gwo mo ki: Aha/ mina nyaḵ di ki /e mo. Dhali ki /e mini dili ’kwani sho’k ka pije/ ’peni Pam Masir mo tani um mini mii mii mmotaḵ aha/ e ’kuwosh yan mo. Dhali mii yansan midi ta jamas mii mo gom /e mo ki aha/ tana a’di jin hashkina /e mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Dhali yan’ko’d aMusa ki owa Arumgimis gwo mo ki: Waḵki/ aha/ mina p̱u’dku/ e ’kwani ma Israyiil mo dhali o uni gwo mo ki: Arumgimis gi ibabam bum a’di i hashki aha/ i um mo tani uni mini doṯ aha/ gwo mo ki: Gway piti yuḵu kaja mo? Atinta i miga/ thoḵ uni mo? ");
INSERT INTO udu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Arumgimis ki thoḵa Musa gwo mo ki: Aha/ Be I Tana Aha/ be. Dhali a’di ki o gwo mo ki: Oyi gwo yansan e ’kwani ma Israyiil ki: Aha/ jin Tana Aha/ mo tani i hashki aha/ i um mo. ");
INSERT INTO udu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Arumgimis si’da/ ki owa Musa gwo mo ki: Oyi gwo yansan mo ma e ’kwani ma Israyiil mo ki: Aha/ jin tana TAP̱A jin ta’da Arumgimis gi ibabam bum mo a’di jin ta’da Arumgimis ma Ibrahiim mo dhali Arumgimis ma Is/hak mo dhali Arumgimis ma Yakuub mo aha/ i hashkina /e i uni mo. Gway pem a’dansan ki sule/ sule/ ya ye ’ba/ mo. Gway yan a’di ta ’pemen jin min ma risa nyaḵum yili heri ’baar mo ka londhoṯẖ mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Yaku/ mo dhali tuli jwahaŋ ’kwani ma Israyiil gun jina ji isi monṯal ’de/ mo dhali oyi uni gwo mo ki: TAP̱A jin ta’da Arumgimis gi ibabam bum mo a’di jin ta’da Arumgimis ma Ibrahiim mo dhali Arumgimis ma Is/hak mo dhali Arumgimis ma Yakuub mo a’di i piki aha/ i is mo mmo/o gwo mo ki: Aha/ nyiṯẖkina um mo gom to kun miikunu um mo e Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Dhali aha/ ona gwo is mo ki aha/ mina susi um ka pije/ mo ’peni mii jin woci um is she/ ’peni miiŋ ’kwani gi Pam Masir mo mmop̱u’d mo e Paŋ ḵanaan mo dhali Pa Hiṯẖṯẖa mo dhali Pan Amuur mo dhali Pam P̱aaris mo dhali Pa Hayp̱a mo dhali Pa Yabuus mo e mo jin ’bor ma ’cesh ki ’bor mo. ");
INSERT INTO udu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Dhali uni mini ciḵ ’twam pini mo dhali /e dhali gwany jwahaŋ ’kwani ma Israyiil um mini ii eya maliḵ gi ’kwani gi Pam Masir mo dhali o a’di gwo mo ki: TAP̱A jin ta’da Arumgimis gi ’kwani ma Ibraniyiin mo tani a’di buṯki’di aman mo. Dhali shwane/ aman doṯa /e ’twa/ mo ki /e mini dhal aman bway ki aman mina ii mo jin ḵala’da cimi kwara e mombwaasho mo ki aman mina ’ciṯẖ to e ’kus mmomiiya bas gom Tap̱a Arumgimis bam mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aha/ misha ka maliḵ gi Pam Masir midi diki dhal um bway mo hili isi ciki/ a’di minu gac̱ ki dhan me’d jin ’bitha’bi’th mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Wakan aha/ mina he’th me’d pem mo dhali dor ’Kwani Masir mo ka ris miimer mo uni kun miga/ mii mo. Yan’ko’d mo tani a’di midi dhal um bway mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Dhali aha/ mina raḵ ’kwani gwansan mmoc̱i um monyca mo. Dhali ki um mini ii mo tani um mini ’koki ii bwam me’d ’te/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Up̱ ’Kwani Israyiil ka ’deṯe/ ’deṯe/ mini ii gu’b gi ’Kwani Masir kun ’dish uni is mo dhali mini doṯ to ’peni uni mo dhali ’peni uni ilu/ gun ’koni gu’b buni mo. Dhali uni mini doṯ uni dhiriny ’dolkon kush mo dhali dhiriny ’dolkon gana/ mo dhali burrinye/ mo. Dhali um mini hi’thki iya/m bum burrinye/ i/is mo dhali i’bwa/m bum si’da/ mo. Dhali um beseene/ mini bu’th mal gi ’kwani Pam Masir ki mom’bi’th bum mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","AMusa thoḵki gwo mo ki: Waḵki/ uni ’koki gam gwom pem is mo walla ciḵ ’twam pem mo dhali o aha/ gwo mo ki: TAP̱A yisa piki /e i is mo yisa tani, aha/ mina mii ata mo? ");
INSERT INTO udu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Dhali yan’ko’d TAP̱A ki o a’di gwo mo ki: Atinta i di’di me’d pini mo sa/? A’di ki thoḵ a’di gwo mo ki: Alukaas mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Dhali TAP̱A ki o gwo mo ki: Biṯi a’di a’cesh mo ma. Wakan a’di biṯki a’di a’cesh mo dhali a’di warki’d ki tasha/ mo dhala Musa guski’d ’peni a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yan’ko’d TAP̱A oki’da Musa gwo mo ki: Luŋi ma dhali buthi a’di i thin mo. Wakan a’di luŋki’d mo dhali bu’th a’di mo dhali a’di warki’d ka lukaas doḵ e mo e me’d piti mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Wakan ki uni mini gam gwo is ki TAP̱A a’di piki /e i is mo, a’di jin ta’da Arumgimis jin ta ji gi ibabam buni mo, Arumgimis ma Ibrahiim mo dhali Arumgimis ma Is/haḵ mo dhali Arumgimis ma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Doḵ e TAP̱A ki o a’di gwo mo ki: Dwari me’d abor pini mo ma, dhali a’di miiki’d kan mo. Dhali ki a’di buḵki a’di ka pije/ mo tani me’d piti ’koshkina monthus mo mmokusha/ kush me’d ’thip̱iny gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Dhali yan’ko’d Arumgimis ki o a’di gwo mo ki: Dwari me’d pini ka nyaŋ’ko’d abor pini mo. Wakan a’di dwarki me’d ka nyaŋ’ko’d abor piti mo. Dhali ki a’di buḵki a’di ka pije/ mo tani a’di dhelelkunu ka nyaŋ’ko’d mo me’d isi is pitiŋ gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Dhali TAP̱A ki o gwo mo ki: Waḵki/ uni mini ’koki gam /e gwo is mo tani, walla ’koki c̱iya hirdhe/ ki to gi miimer jin ṯwa/a/ mo tani uni mini gam gwo is ki miimer yansan mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Waḵki/ uni ’koki gam gwo is, isi gom to gi miimera su/ gwansan mo walla ’koki c̱iya hirdhe/ ki ’twam pini mo tani /e mini pash yi’de/ ’peni ḵumma/ yi’de/ mo dhali gac̱ a’di ap̱owa ’cesh jin ḵuthaḵu’th mo dhali yi’de/ midi war ka bas mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Hila Musa thoḵki TAP̱A gwo mo ki: Ayy Tap̱am pem, aha/ mola gwo o ka ḵar e ki ’bore/ ki sule/ mo, ’peni nṯwa/a/ nniin wala ’peni embul jin ṯela /e mii ’pen mmowal ’twa/ ki aha/ mo. Hili aha/ diṯa ’twa/ wal ki diṯ mo mmo/o gwo mo dhala le’d c̱umpula/ c̱umpul mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Dhali yan’ko’d TAP̱A ki o a’di gwo mo ki: Kaja a’di i uḵki ’twa/ gi wathi/ mo? Dhali kaja a’di i karki a’di mo mmota amanmol ’twa/ wal mo walla mmota ’diye/ mo walla mmomish to p̱ar e mo walla mmota aja’da/ mo? A’di diki ta aha/ mo ’taa jin tana TAP̱A mo? ");
INSERT INTO udu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Shwane/ yaku/ mo dhali aha/ mina di e ’twam pini mo dhali ṯor /e gwo jin mina /e i o mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Hili aMusa thoḵki gwo mo ki: Ayy Tap̱a, hashki wathiŋ kamu/ mo ma mmomii wakan mo. ");
INSERT INTO udu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Dhali yan’ko’d TAP̱A diṯkina bwa ap̱o/a Musa ki ’bi’th mo dhali a’di ki o gwo mo ki: Din ma Haruun ki ta akam pini ’peni ’kwani Lawi mo ’taa? Aha/ misha ki a’di mish gwo o ki ’bore/ mo dhali a’di yayi’di bway mmogam /e ’kup̱ mo. Dhali ki a’di midi mish /e mo tani a’di mina bwa i ’bor kagahara mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Dhali /e mini o a’di gwo mo dhali ṯor ki a’di gwo jin mina a’di o mo. Dhali aha/ mina di e ’twam pini mo dhali di e ’twam piti mo dhali ṯorki um gwo mo gom to kun mina umi mii mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A’di midi o gwo mo gom /e e ’kwani mo dhali midi ta ’twa/ gom /e mo. Dhali /e a’di i mini wa a’di e ka Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Dhali /e mini ḵala lukaas yan i me’d mo mmoṯor miimer ka ris mo. ");
INSERT INTO udu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Yan’ko’d aMusa doḵki’d ka nyaŋ’ko’d eya Rau/iil mo a’di jin ta’da mar piti mo dhali o a’di gwo mo ki: /E doṯga/ ’twa/ mo ki: Dhalki aha/ bway mmodoḵ ka nyaŋ’ko’d i ’kwanim pem e Pa Masir mo dhali p̱ar uni e mo waḵki/ ’kon ki e mo. Dhala Rau/iil ki owa Musa gwo mo ki: Yaku/ ki moŋḵu’th is mo. ");
INSERT INTO udu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Dhali ka Musa di’d e Pam Midyaan naskina/ mo tani TAP̱A ki o a’di gwo mo ki: Doḵi ka nyaŋ’ko’d e Pam Masir mo, haali/ aris ’kwani kun ŋap̱ki /e mmo’kosh jwa mo tani uni wukin mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Wakana Musa suski ash mo dhali iya/m piti isu/ mo dhali dhu uni i ’ku thuluny mo dhali ṯel ’pen mmodoḵ ka nyaŋ’ko’d eya ’cesh gi Pam Masir mo. Dhali e me’d piti mo tani a’di ki ḵala lukaas ma Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Dhali TAP̱A ki owa Musa gwo mo ki: Ki /e mini doḵ ka nyaŋ’ko’d e Pam Masir mo tani hili ki ’bore/ mmomiiya ris miimeri ’baar mo ibwambor ma P̱irawn mo uni kun c̱ikika/ /e mom’bi’th mmomii mo. Hili aha/ mina ’bi’thki a’di adum piti is me’d wosh mo, wakan ki a’di midi diki dhal ’kwani bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Dhali /e mini owa P̱irawn gwo mo ki: Yase ta gwo jin ona TAP̱A ki is piti mo ki: Israyiil ta’da bwanyaraŋ gwaṯẖ pem mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Dhali aha/ ṯora /e gwo mo ki: Dhalki ya/m pem ya’d mo ki a’di midi mii mii mmotaḵ aha/ mo. Dhali /e ushun mo mmodiki dhal a’di bway mmoya mo. Gom kan aha/ mina ’kosha bwanyaraŋ gwaṯẖ pini mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","E mo jin ishkina uni mo e bway mo tani TAP̱A gamki a’di ’kup̱ mo dhali ŋap̱ a’di mmo’taki ’kosh jwa mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Dhali yan’ko’da Sap̱uura ki ’de’k wosh jin kaaka dhali ’ci’th ya/m piti amunyjal yis mo dhali ta aMusa sho’k piti ki a’di mo. Dhali a’di ki o gwo mo ki: /E ka jiŋ gana/ tana kaṯhim pem ka bas e aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Gom gwo gi wakan mo tani TAP̱A dhalki a’di mo. Dhali yan’ko’d a’di waka’d mo kan me’d jin okin ma yim a’di mo ki: /E tana kaṯẖim pem ka bas mo. A’di o gwo yan goma munyjal yis jin ’ciṯẖu mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Dhali TAP̱A oki’da Haruun gwo mo ki: Yaku/ e mombwaasho mo mmogama Musa ’kup̱ mo. Gom kan mo tani a’di yaki’d mo dhali gam a’di ’kup̱ mo e wosha turga/ ma Arumgimis mo dhali p̱i aMusa ’twa/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Dhala Musa ṯorki’da Haruun aris gwo gi TAP̱A mo jin hashkina TAP̱A a’di mo. Dhali a’di si’da/ ṯorki’da Haruun aris jamas miimer mo jin ḵankina TAP̱A a’di mo mmomii mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Dhala Musa uni ka Haruun iikin mo dhali tula ris gwanyjwahaŋ ’kwani ma Israyiil isi monṯal ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Dhala Haruun oki’da ris gwo ’baar mo uni kun ṯorkina TAP̱A aMusa mo. Dhali a’di ki mii jamas miimer i bwambori ’kwani ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Dhali ’kwani gamki gwo is mo. Dhali uni ciḵki gwo ki TAP̱A yaya’di ’kwani ma Israyiil mo dhali ki a’di si’da/ ta gi bwaŋ kulum ki nyanye/ gom isa nyor buni jin wo’cki uni is she/ mo. Dhali uni luŋkina luŋ mo be. ");
INSERT INTO udu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Yan’ko’da Musa dhala Haruun iikina P̱irawn mo dhali o a’di gwo mo ki: Yase/ ta gwo jin ona TAP̱A mo a’di jin ta’da Arumgimis gi ’kwani ma Israyiil mo ki: Dhalki ’kwanim pem iin mo mmota gi dhan moshwan to mmotaḵ aha/ e mombwaasho mo. ");
INSERT INTO udu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Hila P̱irawn oki gwo mo ki: Kaja i taki TAP̱A mo ki aha/ mina c̱i a’di embul mo dhali dhala Israyiil bway mo mmo/ii mo? Aha/ yisa misha TAP̱A yisa. Dhali aha/ yisa mina dhala Israyiil bway mo mmo/ii mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Dhali yan’ko’d uni ki o gwo mo ki: Arumgimis gi ’kwani Ibraniyiin a’di nyaḵki is tul ki aman mo. Aman ’thona /e bway mo mmodhalki aman iina mo ari ii jin tura ’ba/ gom jasa cimi kwara mo e mombwaasho mo. Aman mina mii TAP̱A abasa ’cesh mo a’di jin ta’da Arumgimis bam mo, isi ciḵi/ ki a’di midi diki biṯa p̱o/ aman mo ki ’ba’th jin woci ’kwani is she/ mo walla ki mo ma mee mo be. ");
INSERT INTO udu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Hila maliḵ gi ’kwani Pa Masir oki uni gwo mo ki: Musa um ka Haruun, ata ŋap̱a um mo mmosus ’kwani mo ’pena ṯu’c buni mo? Doḵi ka nyaŋ’ko’da ṯu’c bum mo ma. ");
INSERT INTO udu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Dhala P̱irawn ki o gwo mo ki: ’Kwani kun ’koni bampa/ yansan mo tani uni tana ris ka ris mo. Um ki dosh uni mo ’pena ṯu’c buni gomata? ");
INSERT INTO udu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ka tenten ’de/ yan mo tani aP̱irawn ḵanki’da ris imanjiya ṯu’c kun ta ’Kwani Masir gwo mo dhali imahil tiya kun ta ’kwani ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Um mini doḵ e c̱i ’kwani ḵun’tush i me’d mo mmo’thoḵa jeŋgu’b yisa. Dhalki uni iini ŋap̱i ḵun’tush ki is buni mo. ");
INSERT INTO udu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Uni mini mii uḵa jeŋgu’b me’d jin miina uni iṯwa/a/ mo. Ajeŋ gu’ba ’deŋ kamu/ yisa midi p̱iya. Uni tana p̱iny is ka p̱iny is mo. Wakan a’di ona uni gwo ki: Dhalki aman iina i miiya Arumgimis bam abasa ’cesh ’te/ mo. ");
INSERT INTO udu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Dhalka ṯu’c kun diṯadiṯ i ’thiḵkunu ’kwani i ’ba/ mo ki uni mini miiya ṯu’c mo dhali ’koki c̱i ’ce mo gom gwo ma maḵ ka ris mo. ");
INSERT INTO udu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Wakan imanjiya ṯu’c dhali imanhil tiya kun ta ’kwani ma Israyiil mo tani uni iikin ka pije/ mo dhali o ’kwani gwo mo ki: Yase ta gwo jin on ma P̱irawn mo ki aha/ mina diki c̱i um ḵun’tush mo be. ");
INSERT INTO udu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Iiyi ki is bum mo dhali ḵali ḵun’tush ’peni mo jin mina umi gami a’di mo. Hili aṯu’c bum mina sheŋ kamu/ i p̱o’d yisa ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Wakan aris ’kwani c̱ekerki bwa mo mmopwaḵ is e Pa Masiri ’baar mo mmotula wusha is mo me’d ḵun’tush mo be. ");
INSERT INTO udu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Dhali imanjiya ṯu’c buni naskina/ ’kon mmopucur uni ka ṯu’c mo mmo/o gwo mo ki: Miiyi aṯu’c bumi ’baar mo me’d jin miina um a’di ka cimi ’baar mo jin c̱inu um ḵun’tush inniin mo. ");
INSERT INTO udu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Dhali imanhil tiya ’peni ’kwani ma Israyiil uni kun dhuna imanmiiya ṯu’c ma P̱irawn ki imanhil tiya mo tani uni si’da/ dorkunu mo dhali doṯkunu gwo mo ki: Atinta ’kona um ki miiya risa ṯu’c bum mo mmo/uḵa jeŋgu’b ka nimira shwane/ dhali katili mo me’d mii jin miikina um a’di iṯwa/a/ mo? ");
INSERT INTO udu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Yan’ko’d imanhil tiya ’peni ’kwani ma Israyiil p̱u’dkin mo dhali ḵum cuuwa eya P̱irawn mo ki: Atinta ṯu/ula /e aman ki mii gi wakan mo? ");
INSERT INTO udu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ḵun’tusha kamu/ yisa di’da jin ḵalunu c̱iŋkinam pini mo. Hili uni ’kon mo mmoc̱a’bi o aman gwo mo ki: ’Thoḵa jeŋgu’b mo. P̱ari c̱iŋkinam pini e ’koshu kata? Hili ’kwanim pini uni a’di ṯẖu’th mii mo. ");
INSERT INTO udu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Hila maliḵ ki thoḵ uni gwo mo ki: Um tana p̱iny is ka p̱iny is mo. A’di ona um gwo ki: Dhalki aman iina mo mmomii TAP̱A abasa ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Doḵi ka nyaŋ’ko’d mo dhali miiya ṯu’c mo haali/ ḵun’tusha kamu/ minu c̱i ki um yisa. Hili um mini uḵa jeŋgu’b ki nyanye/ mo mmonyaḵki jin ṯwa/a/ mo. ");
INSERT INTO udu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Imanhil tiya ’peni ’kwani ma Israyiil uni mishki mo mo ki uni ’kokin mo e embul jin ḵaŋkama ḵaŋkam mo ka P̱irawn oki gwo mo ki: Um mini dhalku/ miiŋ kamu/ ki guwa wuy mo ’pena ṯuca jeŋgu’b mo a’di jin ta toma e me’d mo. ");
INSERT INTO udu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Uni gamki iMusa ’kup̱ mo uni ka Haruun mo ki uni c̱orki uni mo me’d jin iiyina uni ka pije/ mo ’pena P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Dhali uni ki thoḵ uni gwo mo ki: Dhalki TAP̱A hilki’da p̱o/ um mo dhali dwall um gwo mo haali/ um dhuki aman mo mmota imankola kol mo e jis e ma P̱irawn mo dhali aris imanmii a’di to mo dhali um dhu gandala turga/ e me’d buni mo mmo’kosh aman jwa mo be. ");
INSERT INTO udu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Dhali yan’ko’da Musa doḵko’d mo e TAP̱A mo dhali o gwo mo ki: Ayy Tap̱a, atinta miikina /e to jin shi/ashi/ wakan ap̱o/ ’kwani gwansan mo? Dhali atinta sa/ i hashina /e aha/ wakan mo? ");
INSERT INTO udu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Haali/ me’d jin yakika/ aP̱irawn mo dhali o gwo ki gway pini mo tani a’di boṯki mii ton thus ki nyanye/ ap̱o/ ’kwani gwansan mo. Dhali /e si’da/ yisa ’cuḵki ’kwanim pini gwansan yisa ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yan’ko’d TAP̱A thoḵki’da Musa gwo mo ki: Shwane/ /e mini mish to jin miga/ miiya P̱irawn mo haali/ ki me’d pem jin ’bitha’bi’th mo tani aP̱irawn midi hashki uni ka pije/ mo. Nye, ki me’d pem jin ’bitha’bi’th mo tani a’di midi ur uni ka pije/ ’peni bampam piti mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dhali Arumgimis ki owa Musa gwo mo ki: Aha/ tana TAP̱A mo. ");
INSERT INTO udu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Aha/ pikina Ibrahiim i is dhala Is/haḵ dhala Yakuub mo me’da Arumgimis jin c̱a’b ki dem dem mo. Hili gom gway pem jin taka/ TAP̱A mo tani aha/ dina ki dhal gway yan bway mo uni ki mish aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Aha/ si’da/ ṯela gwom pem jin gamga/ me’d ki mondeḵ nyaḵki uni mmoc̱iki uni Paŋ Kanaan mo e bampa/ jin ’kona uni ’pena gush ki hilkina/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Dhali aha/ si’dayi ciḵa ohon gi ’kwani ma Israyiil mo uni kun dhukina ’Kwani Masir mo mmota c̱iŋkinam buni mo. Dhali aha/ kakina gwom pem e jin gamga/ me’d mo. ");
INSERT INTO udu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Oyi gwo cikise/ mo e ’kwani ma Israyiil mo ki: Aha/ tana TAP̱A mo dhali aha/ mina sus um ka pije/ mo ’peni ton diṯin gi ’kwani Pa Masir mo dhali aha/ mina ’cu’k um mo ’peni mii jin miina uni um ki c̱iŋkina/ mo. Dhali aha/ mina wan um ’ba/ mo ka bim pem jin miga/ ye’th ka pije/ mo dhali ki dhan mii jin caaca ki gwon dwall mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Dhali aha/ mina bu’th um ki ’kwanim pem mo dhali aha/ mina ta Arumgimis bum mo. Dhali um mini mish mo mo ki aha/ tana TAP̱A Arumgimis bum mo a’di jin suski um ka pije/ mo ’peni aris ton diṯin gi ’Kwani Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Dhali aha/ mina sus um ka pije/ mo e bampa/ jin oka/ gwo is ki gwon deḵ mo mmoc̱ika Ibrahiim mo dhala Is/haḵ mo dhala Yakuub mo be. Aha/ mina c̱i ki um a’di mo mmota mo jin mina umi bu’th is mo. Aha/ be i tana TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa si’da/ oki yase e ’kwani ma Israyiil mo, hili uni ’koki ciḵ gwo ma Musa haali/ shi/in buni i ’ce’dkunu bwa mo dhali gom miiny c̱iŋkinam buni jin maṯẖamaṯẖ mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Dhali TAP̱A ki owa Musa gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Yaku/ /e mo dhali ṯora P̱irawn gwo mo a’di jin ta’da maliḵ gi ’kwani Pam Masir mo mmodhalki ’kwani ma Israyiil bway mo mmo/ii ka pije/ mo ’peni bampam piti mo. ");
INSERT INTO udu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Hila Musa thoḵki TAP̱A gwo mo ki: Hili waḵki/ ’kwani ma Israyiil ush gwo ciḵ ’peni aha/ mo tani bakata i min ma P̱irawn i ciḵ aha/ ’twany c̱umpulgam pem yan mo? ");
INSERT INTO udu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hili TAP̱A oki iMusa uni ka Haruun gwo mo gom ’kwani ma Israyiil mo dhali goma P̱irawn mo a’di jin ta’da maliḵ gi ’kwani Pam Masir mo. Dhali a’di ḵanki iMusa mmosus ’kwani ma Israyiil ka pije/ mo ’peni Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Gwansan uni tana ’kaŋ’kup̱ gom kuŋ gu’b gi ibabam buni mo, gway gi iya/ ma Ra/ubiin mo a’di jin ta’da bwanyara/ ma Israyiil mo: Hanuuḵ dhala P̱allu dhala Hasruun dhala ḵarmi mo. Uni gwansan i tana waḵ ma Ra/ubiin mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Gway gi iya/ ma Shim/uun si’da/ aniihe/ mo. Yamu/iil dhala Yamiin dhala Uhad dhala Yakiin dhala Suhar dhala Sha/uul jin ta ya/ ’pena ’bom gi Paŋ Kanaan mo. Uni i tana waḵ ma Shim/uun mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Gwansan si’da/ i ta gway gi iya/ ma Lawi mo isi me’da nyaḵum yil buni kun tana uni mo: Jirshuun dhala Gahaat dhala Maraari mo. Dhali yil ma Lawi jin dikina a’di ki e mo tani ’koni 137 mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Dhali gway gi iya/ ma Jirshuun aniihe/ mo: Libni dhala Shim/i nyaḵka waḵ buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Dhali gway gi iya/ ma Kahaat aniihe/ mo: Amraam dhala Yishaar dhala Hibruun dhala Usi/iil mo. Dhali yil jin dikin ma Kahaat ki e mo ’koni 133 mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Dhali gway gi iya/ ma Maraari aniihe/ mo: Mahli dhala Mushi mo: Gwansan uni tana waḵ gi ’kwani Lawi mo isi me’da nyaḵum yil buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amraam bu’thki’da ’bom jin yuḵu ka Yukabed mo a’di jin ta ’bwah ma babam piti mo dhala yim dho’thki a’diya Haruun mo dhala Musa mo. Dhali yil piti jin dikina a’di ki e mo tani a’di ’koni 137 mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Dhali gway gi iya/ ma Yashar aniihe/ mo: ḵuurah dhala Napu’c dhala Sikri mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Dhali gway gi iya/ ma Usi/iil aniihe/ mo: Misha/iil dhala Elsap̱aan dhala Sitri mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruun si’da/ bu’thki’da ’bom jin yuḵu gway ka Alishaba/ mo a’di jin ta ’bwa/ ma Aminadab mo dhali a’di jin ta ’bwah ma Nahshuun mo. Dhali ayim dho’thki a’di aNadaab dhala Abiihu dhala Eli/asar dhala Iṯẖamaar mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Dhali gway gi iya/ ma ḵuurah aniihe/ mo: Assiir dhala Elḵana dhala Abi/asaap̱ mo. Gwansan uni i tana waḵ gi ’kwaniŋ ḵuurah mo. ");
INSERT INTO udu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ili/assar a’di jin ta ya/ ma Haruun mo a’di bu’thki’da ’bom ’de/ mo ’peni ’bwa/ ma Puṯi/iil mo. Dhala ayim dho’thki a’di a P̱inihas mo. Gwansan uni i tana ’kaŋ’kup̱ gu’b ’kwani ma Lawi mo ’pena waḵ buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","AHaruun dhala Musa uni anansan kun ona TAP̱A gwo mo ki: Susu ’kwani ma Israyiil ka pije/ mo ’peni Bampa/ Masir mo ka waḵ buni mo. ");
INSERT INTO udu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Uni i ta uni kun oki gwo eya P̱irawn jin ta’da maliḵ gi ’kwani Pa Masir mo mmomuri susu ’kwani ma Israyiil ka pije/ mo ’peni Pam Masir mo, aMusan ’de/ yan mo dhala Haruun mo be. ");
INSERT INTO udu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ka tee yin jin okina TAP̱A gwo eya Musa e Bampa/ Masir mo tani ");
INSERT INTO udu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","TAP̱A oki’da Musa gwo mo mmo/o ki: Aha/ tana TAP̱A mo. Ṯori aP̱irawn jin ta’da maliḵ gi ’Kwani Masir aris gwo kun oka/ /e ’baar mo. ");
INSERT INTO udu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Hila Musa thoḵki TAP̱A gwo mo ki: Aha/ wana ’twam pemi c̱umpula/ ki jin ta’da tinta i min ma P̱irawn i ciḵ ’peni aha/ mo? ");
INSERT INTO udu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Dhali TAP̱A oki’da Musa gwo mo ki: Hili ma. Aha/ mina mii /e me’da Arumgimis ibwambora maliḵ mo. Akam pini ka Haruun midi o gwom pini goma maliḵ me’d isa manc̱i gwo ma Arumgimis jin o gwo ma Arumgimis gom ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ṯorka Haruun aris to ’baar mo kun ḵankika/ /e mo dhala Haruun midi luḵ ka P̱irawn gwo mo mmodhal ’kwani ma Israyiil bway mo mmo/ii ka pije/ mo ’peni bampam piti mo. ");
INSERT INTO udu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Hili aha/ mina ’bitha P̱irawn adum piti mo, dhali ba aha/ mina mara ris jamas miim pem is mo dhali momer mo e Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","P̱irawn yisa midi ciḵ gwo ’peni /e mo. Dhali yan’ko’d aha/ mina dor Pam Masir mo dhali susa waḵ pem ka ’deṯe/ ’deṯe/ ka pije/ mo uni kun ta ’kwanim pem mo ’peni Bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Dhali ’kwanim Pam Masir mini mish mo mo ki aha/ tana TAP̱A mo me’d jin miga/ dor Pam Masir mo dhali susu ’kwani ma Israyiil ka pije/ mo ’peni bwam uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","AMusa dhala Haruun uni miikin kan mo me’d isi ji gi ḵankina TAP̱A uni gwo mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ka tee jin okina uni a P̱irawn gwo mo tani aMusa i ’kona yili iss ’kwanim pa i doŋon mo dhala Haruun i ’kona yili iss ’kwanimpa i doŋon i ’ce’dka kwara ap̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Dhali TAP̱A oki’da Musa dhala Haruun gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Waḵka P̱irawn midi ḵan um mmomii miimer mo tani /e mini owa Haruun gwo mo ki: Budhi cwam pini mo dhali biṯi a’di a ’cesh i bwambor ma P̱irawn mo ki a’di midi war ki tasha/ mo. ");
INSERT INTO udu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Wakana Musa dhala Haruun uni iikina P̱irawn mo dhali miiki a’di me’d jin ḵankina TAP̱A uni gwo mo. Haruun biṯki’da lukaas piti a’cesh ibwambor ma P̱irawn mo dhali aris imanmiiya ṯu’c piti mo dhali a’di warki’d ki tasha/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Dhali yan’ko’d si’da/ P̱irawn yuḵki ’kwanim piti kun yuḵayuḵ mo dhali aris ŋarim piti mo. Dhali uni si’da/ miiki to jin nyaḵan mo ki miilaṯṯ buni mo. ");
INSERT INTO udu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Haali/ aris uni ka ’deṯe/ ’deṯe/ biṯkina lukaas buni mo dhali uni warkin ki tasha/ mo. Hila lukaas ma Haruun a’di i loski’da lukaas buni i ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Naskina/ adu ma P̱irawn wa ki wosh jin ’bitha’bi’th mo dhali ushki gwom buni gam is mo me’d gwo jin ṯorkina TAP̱A uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Dhali yan’ko’d TAP̱A ki owa Musa gwo mo ki: Adu ma P̱irawn a’di ’bitha’bi’th mo. A’di ushki’d mo mmodhal ’kwani bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Yaku/ a P̱irawn mon’thamo/ mo me’d isi mii jin miikina a’di mo mmoya ka pije/ e ḵumma/ Yi’de/ Niil mo. C̱ori a’di e yana gap̱ mo dhali ḵala lukaas pini yani me’d mo a’di jin warki’d ki tasha/ mo. ");
INSERT INTO udu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Dhali /e mini o a’di gwo mo ki: TAP̱A jin ta’da Arumgimis gi ’kwani ma Ibraniyiin a’di i hashki aha/ i /e mo mmo/o /e gwo mo ki: Dhalki ’kwanim pem iin mo ki uni mini luŋ aha/ mo e mom bwaasho mo. Dhali /e ushki gwo ha e naskina/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yase i ta gwo jin ona TAP̱A mo. ’Peni mii yan mo tani /e mini mish gwo ’ban ki aha/ tana TAP̱A mo. Aha/ mina dor ḵumma/ yi’de/ mo ka lukaas pem mo a’di jin diki’d e me’d pem mo dhali a’di midi war ka bas mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Dhali wa’c kun ’kokini ḵumma/ yi’de/ yan mo tani uni mini wu mo dhali ḵumma/ yi’de/ midi bulabul mo be. Dhali ’kwani Pam Masir mini mol yi’de/ p̱i ’peni ḵumma/ yi’de/ yansan mo. ");
INSERT INTO udu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Dhali TAP̱A ki owa Musa gwo mo ki: Owa Haruun gwo mo ki: Budha lukaas pini mo dhali yetha bim pini mo ap̱o/ aris moŋ’kulu yi’de/ ka ris mo gi Pam Masir mo eya ris wor buni i ’baar mo dhali eya kanycal buni mo dhali eya ris ushi mo kun doshkina yi’dem buni dhali eya al buni ’baar mo, ki uni mini war ka bas mo. Dhali abas minu mish ki tur mo e Bampa/ Masiri ’baar mo eya ris bwaman toŋ’kul bwa mo kun ta cwa mo dhali e bwaman wosh kun ta ton tantar bwa mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa dhala Haruun uni miikin me’d jin ḵankina TAP̱A gwo mo. E jis e ma P̱irawn dhali aris imanmiiya ṯu’c piti mo tani Haruun ’de’kki’da lukaas mo dhali dora p̱o/ ḵumma/ Yi’de/ Niil mo. Dhala ris yi’de/ kun ’kokin mo eya Niil mo tani uni warkunu ka bas mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Dhali aris wa’c kun ’kokin eya Niil mo tani uni wukin mo dhala Niil ki bul mo mo. Wakan ’kwani Pam Masir uni molki yi’de/ p̱i ’pena Niil mo. Dhali abas si’da/ ishki’d ki tur e Bampa/ Masiri ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Hili ŋari gi Pam Masir mo tani uni si’da/ mii to jin nyaḵan ki miilaṯ buni mo. Wakan adu ma P̱irawn wa ki wosh jin ’bitha’bi’th mo. Dhali a’di diki ha uni gwo e mo me’d gwo jin okina TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","AP̱irawn ṯu’kki’d mo dhali ya gu’b piti mo dhali a’di si’dayi diki kar ’cem piti gom to yan mo. ");
INSERT INTO udu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Dhala ris ’kwani Pam Masir si’da/ uni c̱wanyki jis e yana Niil ka ris mo gom yi’de/ mmop̱i mo, haali/ uni molki yi’de/ p̱i ’pena Niil mo be. ");
INSERT INTO udu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Acim ’koni pesu/ kun pekin ’ko’di TAP̱A warki yi’den Niil ka bas mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Yaku/ mo eya P̱irawn mo dhali ṯori a’di gwo mo ki: Yase ta gwo jin ona TAP̱A mo ki: Dhalki ’kwanim pem bway mo mmo/ii mo ki uni mini mii mii mmotaḵ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Hili waḵki/ /e mini ush mo mmodiki dhal uni bway mo mmo/ii mo tani, aha/ mina ’kosh aris bampam pini ka ma’dinya ’dwa/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Dhali ḵumma/ Yi’de/ Niil minu ’tu’d mo ka risa ’dwa/ mo. Uni mini seku bway gu’b pini mo dhali bway gu’b ish pini mo dhali ap̱owa cim pini mo dhali eya ris gu’b gi imanmii tom pini mo dhali ’kwanim pini mo dhali eya ris mo ma p̱urun pini mo dhali e bwaman ma sahan kun miikunu /eya gana’th mo. ");
INSERT INTO udu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Arisa ’dwa/ mini seku /e i is mo dhali ap̱o/ ’kwanim pini mo dhali ap̱o/ aris imanmiiya ṯu’c pini mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yan’ko’d TAP̱A oki’da Musa gwo mo ki: Ṯora Haruun gwo mo mmo’deḵa lukaas piti ap̱o/ aris yi’de/ kun son mo dhali ap̱owa risa kanycal dhali ap̱owa risa al mo. Dhali raḵa risa ’dwa/ mmoseyu/ ap̱o/ Bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Wakana Haruun ’de’kki’da lukaas piti mo ap̱owa ris yi’de/ gi Pam Masir mo. Dhali arisa ’dwa/ p̱u’dkin ka pije/ mo dhali kum Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Hili ŋari si’da/ miiki miilaṯ buni gun gama uni adu is mo kun nyaḵkan ki mii gi iMusa mo. Dhali uni si’da/ raḵana arisa ’dwa/ mmoseyu/ ka pije/ mo e Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Dhali yan’ko’da P̱irawn yuḵki’da Musa dhala Haruun mo dhali o uni gwo mo ki: ’Thoyi TAP̱A mo ma ki a’di midi ḵalka risa ’dwa/ mo ’peni aha/ mo dhali ’peni ’kwanim pem mo, dhali aha/ mina dhal ’kwani bway mo mmo/ii mo mmomii TAP̱A a basa ’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa oki’da P̱irawn gwo mo ki: Aha/ mina bwa ’kuny mo mmo’tho gom /e mo. Ṯori atente/ jin ŋap̱a /e aha/ ki ’tho gom /e mo dhali goma ris imanmiiya ṯu’c pini mo dhali gom ’kwanim pini mo ka risa ’dwa/ minu ’ce’d sho’k mo dhali minu dhalku/ mo mmo’ko jasi e ḵumma/ Yi’de/ Niil mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Dhala P̱irawn ki o gwo mo ki: Ka’thamo/ mo. AMusa thoḵki gwo mo kan ki: Dhalki mii yan miinu wakan mo me’d jin okina /e mo ki /e mini mish mo mo ki jaŋ kamu/ yisa di’da jin wa ki TAP̱A Arumgimis bam mo. ");
INSERT INTO udu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ama’dinya ’dwa/ mini dhal um ’pen mo dhali aris gu’b pini mo dhali aris imanmii tom pini kun mii ki /eya ṯu’c mo dhali ’kwanim pini mo. Dhali momboc̱ ma ’dwa/ mina uni ’ko jasi e ḵumma/ Yi’de/ Niil mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Wakana Musa dhala Haruun uni iikin ka pije/ mo ’pena P̱irawn mo. Dhala Musa ’thoki’d ki ’bi’th mo e TAP̱A mo isi gom gwo ma ’dwa/ mo jin hashkina a’di a P̱irawn mo. ");
INSERT INTO udu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Dhali TAP̱A miiki a’di mo isi me’d gwo ma Musa mo. Dhali arisa ’dwa/ wukin mo eya ris gu’bi ’baar mo dhali eya ris bwaagoŋi ’baar mo dhali e mondhe’di ’baar mo. ");
INSERT INTO udu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Dhali uni tulki uni is i monṯal ’de/ ka ŋul’kup̱ mo dhali bampa/ bulabul mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Hili ka P̱irawn p̱arki mo e mo ka ’dwa/ wukin mo tani a’di ’bi’thki’da dum piti mo dhali diki’d ki gwo i bwa mo mmo/ush gwo ma Musa dhala Haruun mo me’d jin ṯorkina TAP̱A uni gwo mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Dhali yan’ko’d TAP̱A ki owa Musa gwo mo ki: Ṯora Haruun gwo mo ki: ’Deki alukaas pini mo dhali dori bu’da ’cesh mo ki a’di midi war ka shokom ki tur mo e Bampa/ Masiri ’baar mo. ");
INSERT INTO udu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Wakan aHaruun dorki’da ’cesh ka lukaas piti mo dhali dhan bu’d ’ce’dki’d ki to’bo/ to’bo/ mmowar ka shokom mo dhali shwa ’kwanim Pam Masiri ’baar mo dhali to em buni si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Dhali ŋari si’da/ palki mii mo mmo’taki raḵa shokom mmoseyu/ ka pije/ ki miilaṯ buni mo jin gama uni adu is tani, hili uni p̱ikunu e mo. Ashokom ishki’d e ’kwani mo dhali to e mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Dhali ŋari ṯorkina P̱irawn gwo mo ki: Yansan ta me’d ma Arumgimis mo. Hila P̱irawn i ’bi’thkin ma du mo dhali a’di si’da/ ush gwom buni ciḵ mo me’d gwo jin okina TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Dhali yan’ko’d TAP̱A ki owa Musa gwo mo ki: Cuyi mis mo mon’thamo/ ka’tum mo dhali yayi dosha bora P̱irawn mo me’d jin yakina a’di ka pije/ bwaya Niil mo, dhali ṯor a’di gwo mo ki: Yase ta gwo jin ona TAP̱A mo ki: Dhalki ’kwani bway mo mmo/ii mo ki uni mini mii mii mmotaḵ aha/ ki momaŋ mo. ");
INSERT INTO udu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Waḵki/ /e mini diki dhal ’kwanim pem bway mo mmo/ii mo tani aha/ mina hash ka dhana buhanya ḵan’thi/ ap̱o/ /e mo dhali ap̱o/ imanmiiya ṯu’c pini mo dhali ap̱o/ ’kwanim pini mo dhali eya ris bwaŋgu’b pini mo. Dhali eya ris bwaŋgu’b gi ’kwani Pam Masir mo tani uni minu ’tu’d mo ka dhana buhanya ḵan’thi/ mo dhali i tagi mo jin karkina Bampa/ Masir ’kup̱ mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Hili ka tee c̱aan mo tani aha/ mina ḵwa/ Bampa/ Jaasaan bwa mo a’di jin ’kokina ’kwanim pem i cine/ mo, wakan ka buhanya ḵan’thi/ ’deŋ kamu/ midi diki di imun mo, ki /e mini mish gwo ’ban ki aha/ tana TAP̱A jin di’d e bwaman gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Yaase/ i ta mii jin miga/ mii mo mmoḵwa/a ḵwa/ bwa mo e bwaman ’kwanim pem dhali ’kwanim pini mo. Ka’thamoŋ gana/ mo tani a’di i mina to mer yan i di mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Dhali TAP̱A miiki mii gi wakansan mo. E mun mo tani adhana buhanya ḵan’thi/ p̱u’dkin mo e gu’b ma P̱irawn mo dhali gu’b ma ris imanmii tom piti mo. Dhali eya ris Bampa/ Masiri ’baar mo uni shi/kunu is mo ki ’kup̱ gwo ma ḵan’thi/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Dhali yan’ko’d a P̱irawn yuḵki’da Musa dhala Haruun mo dhali o uni gwo mo ki: Iiku/ mo dhali miiya Arumgimis bum abasa ’cesh e bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Hila Musa thoḵki gwo o ki: A’di yisa midi ’bora mmomii mii gi wakan mo haali/ aman mina mii TAP̱A Arumgimis bam abasa ’cesh mo. Mii yan midi bulabul mo gom ’kwani Pam Masir mo. Waḵki/ aman miina abasa ’cesh jin bulabul mo e jis e gi ’kwani Pam Masir mo tani uni mini ’koki ’kosh aman jwa mo ki wosh mo ’te/ tana? ");
INSERT INTO udu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Aman mina mii ii mo goma cimi kwara mo e mom bwaasho mo dhali mii TAP̱A Arumgimis bam abasa ’cesh mo me’d gwo jin ḵankina a’di aman mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Wakana P̱irawn oki gwo mo ki: Aha/ mina dhal ki um bway mo mmo/ii mo dhali mii TAP̱A Arumgimis bum abasa ’cesh mo e mombwaasho mo hili um mini ii i si’dasi’d yisa. ’Thoyi gom aha/ si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Dhali yan’ko’da Musa oki gwo mo ki: Aha/ yana mo ka pije/ mo ’peni /e mo dhali aha/ mina ’tho TAP̱A ki a’di midi hashka buhanya ḵan’thi/ mo ’peni /e mo jin tana P̱irawn mo dhali ’peni imanmiiya ṯu’c pini mo, dhali ’peni ’kwanim pini mo ka’thamoŋ gana/ mo. P̱irawn, dhalku/ ki c̱a’bi heka he’k em p̱us mo doḵ e mo mmodiki dhal ’kwani bwayi ii mo mmomii TAP̱A abasa ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Yan’ko’d aMusa a’di yaki’d ka pije/ mo dhali ’thoki TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Dhali TAP̱A miiki’d wakan mo me’d jin okin ma Musa a’di mo dhali ḵalki’da buhanya ḵan’thi/ mo ’pena P̱irawn mo dhali ’peni imanmiiya ṯu’c piti mo dhali ’peni ’kwanim piti mo. Jan ’deŋ kamu/ yisa boc̱o’da. ");
INSERT INTO udu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Hila P̱irawn ’bi’thki’da dum piti is mo doḵ e ka tente/ yansan gana/ si’da/ mo, dhali diki dhal ’kwani bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Yaku/ mo eya P̱irawn mo dhali o a’di gwo mo ki: Yase/ ta gwo jin ona TAP̱A Arumgimis gi ’kwani Ibraniyiin mo ki: Dhalki ’kwanim pem bway mo mmo/ii mo ki uni mini mii mii mmotaḵ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Waḵki/ /e mini ush mo mmodhal uni bway mo mmo/ii mo dhali di mmonon uni ’kup̱ mo tani ");
INSERT INTO udu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","me’d gi TAP̱A midi biṯa p̱o/ to em pini ki ’ba’th jin shi/ashi/ mo e uni ’baar kun ’kon eya pije/ mo, shumarum dhali thuluny dhali kalman dhali bip̱ dhala ma’diny ḵa’bal dhali miya si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Hili TAP̱A midi ḵwa’th to e gi ’kwani ma Israyiil mo ’peni bwaman ji gi ’Kwani Masir mo. Wakan ki jin ṯal ’de/ midi diki wu mo ’peni aris uni kun ta ku ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Dhali TAP̱A karki’da cim ’pen ka pije/ mo dhali o gwo mo ki: Ka’thamoŋ gana/ aha/ TAP̱A mina mii to yansan mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Dhali mon’thamoŋ gana/ mo tani TAP̱A miiki to yansan mo. Aris to e gi ’kwanim Pam Masir wukin mo. Hili to e gi ’kwani ma Israyiil mo tani ṯal ’deŋ kamu/ yisa wu’da. ");
INSERT INTO udu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Dhala P̱irawn hashki’da hash mmo’kar to e gi ’Kwani ma Israyiil mo. Dhali jan ’deŋ kamu/ yisa di’da ’peni ji gi ’kwani ma Israyiiil jin wu’da. Hila P̱irawn ’bi’thki’da dum piti mo dhali a’di diki dhal ’kwani bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Dhali TAP̱A oki’da Musa gwo mo dhala Haruun ki: Muthi ’pinyi ’tu’d me’d bum mo ’peni bwam ma gwaṯa/ mo dhali dhalka Musa yeḵ uni i mis mo e jis e ma P̱irawn mo. ");
INSERT INTO udu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Dhali a’di midi war ki bu’da ’cesh gana/ mo ap̱owa ris Pa Masiri ’baar mo. Dhali ’ba’th jamany jwa midi mu/ ’kwani is dhali ki to e ilu/ ki tur mo e Pa Masiri ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Wakan uni mu’thki ’piny mo ’peni bwam ma gwaṯa/ mo dhali dosh mo ibwambor ma P̱irawn mo. Dhala Musa yeḵki ’piny mo isi mis mo dhali a’di warki’d ki ’ba’th jamany jwa mo ap̱o/ i’kwanim pa ki to e ilu/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Dhali ’kwani kun miiki to ki e ma rum thus molki dosh mo ibwambor ma Musa mo gom jamany jwa mo haali/ jamany jwa biṯki’da p̱o/ uni mo dhali ap̱o/ ’kwani Pam Masir i ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Hili TAP̱A i ’bi’thki’da P̱irawn adum piti is mo. Dhali a’di diki ciḵ gwom buni mo me’d isi gwo jin ṯorkina TAP̱A aMusa mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Cuyi mis mon’thamo/ ka ’tum mo dhali doshi ibwambor ma P̱irawn mo dhali oyi a’di gwo mo ki: Yase/ ta gwo jin ona TAP̱A Arumgimis gi ’kwani ma Ibraniyiin mo ki: Dhalki ’kwanim pem bway mo mmo/ii mo ki uni mini mii mii mmotaḵ aha/ ki momaŋ mo. ");
INSERT INTO udu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ka tee yansan aha/ mina hash mom’bi’th gi mompal jin wo’c ’kwani is she/ pem ap̱o/ /e mo dhali ap̱owa ris imanmiiya ṯu’c pini mo dhali ap̱o/ aris ’kwanim pini mo, wakan ki /e mini mish mo mo ki wathiŋ kamu/ yisa wa ki aha/ eya ris mony’ceshi ’baar mowah. ");
INSERT INTO udu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Waḵki/ aha/ mina ’taki ’de’k me’d pem mmodor /e mo ki ’kwanim pini ilu/ mo tani um minu ’taki ’ce’d ki sho’k mo ’peni ’dishesan mo ’peni mony’cesh mo ki ’ba’th jin wo’cki ’kwani is she/ ki ra’b ra’b mo. ");
INSERT INTO udu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Hili gom ’kup̱ mii yan mo tani aha/ dhalkina /e mo mmoṯor /e mom’bi’th pem mo, wakan ki gway pem minu bah ki tur mo eya ris mony’ceshi ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","/E din naskina/ mo mmokar is pini ki ca mo ap̱o/ ’kwanim pem mo dhali diki dhal uni bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Gom kan mo tani ka’thamoŋ gana/ ka tente/ gi wakansan mo tani aha/ mina rasa dhana wassa/ kun diṯadiṯ mo, ji gi wakan yisa mishkunu e Pam Masir mo yisa, ’pena cim c̱aan jin ḵa’bkunu Pa Masir mo ntagi shwanesan mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Hashi gwo mo mmotulu to em pini isi ’baar mo uni kun takina /e mo eya pije/ mo ki /e mini dhu uni ki ’danṯar e bwaŋ’kwarany ma darha’da/ mo haala wassa/ mini wolu ka ’cesh mo ap̱o/ ’kwani ’baar mo dhali ap̱o/ to e mo kun ’kokin apije/ mo. Dhali waḵki/ uni ’konuki ’doyu/ pa mo tani uni mini wu mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Dhali yan’ko’d uni kun ḵo/ki gwo gi TAP̱A mo e bwaman ’kwani kun miikina P̱irawn aṯu’c mo tani uni dhuki aris c̱iŋkina/ dhali to em buni mo mmosoyu/ bway bwaŋ gu’b mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Hili gwaṯṯan kun dina gwon TAP̱A ki thoṯẖ ki is mo tani uni dhalki c̱iŋkinam buni kun yola uni mo dhali to em buni eya pije/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Dhali TAP̱A oki’da Musa gwo mo ki: Yethi me’d pini ’kup̱ ki momis mo ka wassa/ midi rasu/ ap̱o/ Pam Masiri ’baar mo ap̱o/i ’kwani mo dhali ap̱o/i to e mo dhali eya ris to kun sinu eya pije/ ki tur mo e Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Wakana Musa ’de’kki cwam piti mo ’kup̱ ki mis mo dhali TAP̱A hashki mondor ma sho’k mo dhala wassa/ dhali o’d iikina war war ka ’cesh mo. Wakan TAP̱A a’di i he’thki’da wassa/ mo ap̱o/ Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Awassa/ raski’d, dhali awara sho’k su’kki’d ki dwa/a’d dwa/a’d ki sule/ sule/ mo ’peni bwaman ma wassa/ mo. ’Tham si’da/ bucurki’d ki ’bi’th mo. Ji gi wakansan yisa mishkunu yisa e Bampa/ Masiri ’baar mo ’pena dhamo/ me’dyin dina a’di ki war ki kal mo. ");
INSERT INTO udu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Awassa/ raski’da p̱o/a ’cesh eya ris to kun ’kona pije/ mo uni kun sikunu mo ki tur mo eya ris Bampa/ Masir mo ki ’kwani ilu/ mo dhali to e ilu/ si’da/ mo dhali dhera ris cwa bwa ’baar mo kun ’kokin e bwam bunto si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Dhali mon ’de/ jin dina a’di ki ’ce’d sho’k ka wassa/ mo tani ta’da ’cesh gi Pany Jaasaan jin ’kona uc̱i ma Israyiil i cine/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Dhali yan’ko’da P̱irawn hashki’da hash mo dhali yuḵa Musa dhala Haruun mo dhali o uni gwo mo ki: Aha/ miikina miinthus ka tee yan mo. TAP̱A a’di i mii’d ki ’bore/ mo dhali aha/ dhali ’kwanim pem mo tani aman a’di i thamkina mii mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","’Thoyi TAP̱A mo ma, haali/ a’di ’kosh jwa mo ’peni kon dor ma sho’k yan mo dhala wassa/ mo. Aha/ mina dhal um bway mo mmo/ii mo. Um mini mii dhalku/ ki mii ’ko ki rash rash kan mo. ");
INSERT INTO udu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa ki thoḵ a’di gwo mo ki: Ki aha/ mina ya mo ’peni ’peŋkuman bampa/ ki ’ta’b mo tani aha/ mina ṯe’d me’d pem e TAP̱A mo dhali ’tho mo. Dhali mondor ma sho’k midi dosh mo dhala wassa/ si’da/ mini ’koki ’ko mo doḵ e ki /e mini mish gwo ’ban ki mony’cesh ta ji gi TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Hili gom /e mo dhali aris ’kwanim pini kun miiki /eya ṯu’c mo tani, aha/ misha ki um ’koki ḵo/ TAP̱A Arumgimis naskina/ moyi. ");
INSERT INTO udu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Emen to ma yin dhali ḵala uni i’ce’dkunu sho’k mo haali/ ḵala isi’d mo dhali emen to ma yin di’d e pimpal mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Hila gameh yisa i’ce’dkunu sho’k mo haali/ a’di iski’d i ’ko’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Wakan aMusa a’di yaki’d ka pije/ mo ’peni ’peŋkuman bampa/ mo ’pena P̱irawn mo dhali ṯe’d me’d piti e TAP̱A mo. Dhali mondor ma sho’k dhala wassa/ uni doshkin mo dhali asho’k yisa doḵ e hethi yi’de/ ap̱o/ mony’cesh mowa. ");
INSERT INTO udu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Hili ka P̱irawn mishki’d ka sho’k dhala wassa/ dhali mondor ma sho’k doshkin mo tani a’di miiki miinthus naskina/ doḵ e mo. Dhali a’di ’bi’thki’da dum piti ki ’bi’th mo, a’di i nyaḵki/ uni kun miiki a’di aṯu’c si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Wakan adu ma P̱irawn a’di ’bi’thki’d mo dhali a’di diki dhal ’kwani ma Israyiil bway mo mmo/ii mo me’d gwo jin ṯorkina TAP̱A eya Musa mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Yaku/ aP̱irawn mo haali/ aha/ i’bi’thkina a’di adum piti is mo dhala du gi aris ’kwani kun miiki a’di aṯu’c mo ki aha/ mina mii aris miimer pem gwansan i bwamani uni mo. ");
INSERT INTO udu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Dhali ki /e mini mii ṯor gwo mo ki uc̱im pini mo dhal ki uc̱i gi iya/in mo gom mon’the is jin ’thekika/ ’kwani Pam Masir mo ka tee jin miikika/ miimer e bwaman uni mo. Um ’baar mo mini mish mo mo ki aha/ tana TAP̱A mo. ");
INSERT INTO udu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Wakana Musa dhala Haruun uni iikina P̱irawn mo dhali o a’di gwo mo ki: Yase/ ta gwo jin ona TAP̱A mo a’di jin ta ’da Arumgimis gi ’kwani Ibraniyiin mo. Me’di ekata i mina /e i c̱a’bi ush is pini kar ki gwa’d kan mo ibwambori aha/ mo? Dhalki ’kwanim pem bway mo mmo/ii mo ki uni mini mii mii mmotaḵ aha/ ki momaŋ mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Haali/ waḵki/ /e mini ush ’kwanim pem dhal bway mo mmo/ii mo tani, ka’thamoŋ gana/ aha/ mina hasha waambuhanya kuyu/ e bampam pini mo. ");
INSERT INTO udu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Dhali uni mini tiḵa ’cesh e mo, wakan ki wathin ṯal ’deŋ kamu/ midi diki misha ’cesh mo. Dhali uni mini shwa to ki c̱a’ba c̱a’ba kun urki ’kup̱ mo i’ko’da wassa/ mo. Dhali uni mini shwa aris cwam bumi ’baar mo kun cakin mo e mondhe’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Dhali uni si’da/ mini ’tu’d aris gu’b pini mo dhali aris gu’b gi ’kwanim pini kun miiki /eya ṯu’c mo dhali aris gu’b gi ’kwani Pam Masiri ’baar mo. To gi wakansan yisa mishkina ibabam pini mo dhali idhan cim mo ’pena tee c̱aan jin p̱u’dkina uni e mo yan mo ntagi shwane/ mo yisa. Dhali yan’ko’d aMusa ṯu’kki’da bor mo ’pena P̱irawn mo dhali ya ka pije/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Dhali ’kwani kun miikina P̱irawna ṯu’c mo tani oki a’di gwo mo ki: Me’d ekata i mina wathi/ yan ic̱a’bi yap̱ ana ka gumme/ wakan mo? Dhalki ’kwani iin mo ki uni mini mii mii mmotaḵ TAP̱A Arumgimis buni mo. /E mala ṯumu’c pini mmomol gwo ’ban naskinaŋ gana/ mo? Dina /e ki mish gwo ’ban ki Pam Masir ’ce’dkunu shoka? ");
INSERT INTO udu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Yan’ko’d aMusa dhala Haruun uni susunu ka nyaŋ’ko’d eya P̱irawn mo. Dhala P̱irawn ki o uni gwo mo ki: Iiku/ mo mmomii mii mmotaḵ TAP̱A jin ta’da Arumgimis bum mo. Hili ija uni i mini ii mo? ");
INSERT INTO udu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Dhala Musa ki thoḵ a ’di gwo mo ki: Aman mina ii nyaḵki dhuru’c bam mo dhali nyaḵki ’kwani kun tana dhan mo. Dhali aman mina ii nyaḵki iya/m bam mo dhali i’bwa/m bam mo dhali ura ma’diny ḵa’bal bam mo dhali aris bip̱ bam mo haali/ aman mina mii ta gi dhan moshwan to mmotaḵ TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Dhala P̱irawn ki o uni gwo mo ki: Dhalki TAP̱A di’d e um mo ma, waḵki/ aha/ dhala um bway mo mmo/ii mo nyaḵki uc̱im bum mo. Um ta gi gwon thusa tiya eya dum bum mo ba/. ");
INSERT INTO udu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yisa wakan ’teya. Iiku/ mo um ’kwaniŋgwaṯẖ um ’cena mo dhali miiyi mii mmotaḵ TAP̱A mo. Haali/ mii a’dan jin gwon ma dum bum mo. Dhala Musa uni ka Haruun urkunu ka pije/ ’peni buŋ’kus ma P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Dhali TAP̱A oki’da Musa gwo mo ki: ’Deki me’d pini mo ap̱o/ Bampa/ Masir mo goma kuyu/ mo ki uni mini ṯẖathu ki sheŋ ’kup̱ mo eya ’cesh gi Pam Masir mo dhali shwa aris to kun sinu mo e bwam bunto mo aris uni ’baar mo kun urkin ma wassa/ ’kup̱ mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Wakan aMusa a’di ihe’thki’da lukaas piti mo ap̱o/ Bampa/ Masir mo. Dhali TAP̱A ḵalki ’tham gi mom’pesho’k mo mmoposh ka enthus mo ka cim c̱aan ki mon’thiny ilu/ mo. Dhali ki mo ta mon’thamo/ mo tani ’tham gi mom’pesho’k a’di i ḵala’da risa kuyu/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Dhala waambuhanya kuyu/ ṯẖa’thkin ap̱owa ’cesh gi Pam Masir mo dhali thoson is buni mo mmo’ko mo e dhan Bampa/ Masiri ’baar mo. Adhana kuyu/ shwan ma risa nyor kagahara mo. Ji gi wakansan yisa mishkunuwa, dhali a’di midi doḵ e di ki sule/ sule/ mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Uni kumkina ’ceshi ’baar mo. Wakan a’cesh ki ḵar ’kup̱ ki dhurum mo mo. Dhali uni shwaki to kun sikunu mo e mony’cesh mo dhali aris maman to ’peni uni kun urkin ma wassa/ ’kup̱ mo. Ton dhi/i’da kamu/ yisa boc̱o’da walla cwa si’da/ walla to kun sinu mo em bunto mo ki tur eya ’cesh gi Pam Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Dhali yan’ko’da P̱irawn yuḵki’da Musa dhala Haruun ki jahanne/ mo dhali o uni gwo mo ki: Aha/ miikina miinthus ap̱o/ TAP̱A Arumgimis bum mo dhali ap̱o/ um mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Dhali shwanesan gwami aha/ miinthus pem jasi me’d ’deŋ gana/ mo. Dhali ’thoyi TAP̱A Arumgimis bum mo gom aha/ mo mmojoc̱ ki mompal jin ’kosho’da ’kosh jwa mo ’peni aha/ mo. ");
INSERT INTO udu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Wakan aMusa yaki’d ka pije/ ’pena P̱irawn mo dhali ’thoki TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Dhali TAP̱A aḵki ’tham gi mompesho’k a’ban e mo mmowar ka bora luŋgu’b mo jin ’bitha’bi’th mo a’di jin yu’dki’da buhanya kuyu/ mo dhali ḵal uni sho’k mo e Yi’deŋ ḵummam ’Per mo. Ara kuyuŋ kamu/ ’de/ yisa di’d jin dhalkunu mo e Bampa/ Masira. ");
INSERT INTO udu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Hili TAP̱A ’bi’thki’da P̱irawn adum piti is mo dhali a’di diki dhal ’kwani ma Israyiil bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Ṯe’dki me’d pini ’kup̱ ki momis mo ki mondhurumi’d jin ’ceṯẖe’da ’tum midi wuma p̱o/ Pam Masiri ’baar mo. Mondhurumi’d mina moŋkusha kamu/ i diki di ce e mo. ");
INSERT INTO udu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Wakan aMusa ṯe’dki me’d piti ’kup̱ ki momis mo dhali dhan mondhurumi’da ’tum diki’d mo e Bampa/ Masir goma cimi kwara mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wathiŋ kamu/ yisa di’da jin mishi tiyan tiya p̱ar e mo yisa. Walla jin ṯal ’deŋ kamu/ yisa cuki mis mo ’peni mom piti mo ka cimi kwara mo. Hili aris ’kwani ma Israyiil uni a’di i ta gi moŋkush mo e mo jin ’kokina uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Dhali yan’ko’d aP̱irawn yuḵki’da Musa mo dhali o gwo mo ki: Iiku/ mo mmomii mii mmotaḵ TAP̱A mo ki up̱ bumi lu/ mo. Dhali uc̱im bum si’da/ mini nyaḵ ii ki um mo. Hili dhalka ma’diny ḵa’bal dhali aris bip̱ bum i mini ’koku/ maṯaan mo. ");
INSERT INTO udu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Hila Musa thoḵki gwo mo ki: /E mini mii dhal aman bway si’da/ mo mmota gi to jin mina aman i miiya basa ’cesh mo dhali to kun miinu mo kun c̱inu ki me’d mo jin ’thanu o’d ka kuluny ki aman mina c̱iki a’di TAP̱A Arumgimis bam mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","To em bam si’da/ mini mii ii nyaḵki aman mo, To e ’deŋ kamu/ yisa minu dhalku/ i’ko’d yisa, haali/ aman mina mii bu’th uni mo dhali mii mii mmotaḵ TAP̱A Arumgimis bam mo. Dhali aman yisa misha to kun mina aman i mii i ’ci’th ’kus naskina/ gom TAP̱A yisa ntagi aman mina p̱u’dku/ i mun mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Hili TAP̱A a’di i ’bi’thki’da P̱irawna du is mo dhali a’di diki dhal uni bway mo mmo/ii mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Dhala P̱irawn ki owa Musa gwo mo ki: Guki jis em pini mo ’peni aha/ mo. Mishi gwo ’ban ki /e mini diki doḵu/ ka nyaŋ’ko’d doḵ e mo. Dhali ka cim jin mina /e i p̱ar jis em pem e mo tani /e mini wu mo be. ");
INSERT INTO udu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa thoḵki a’di gwo mo ki: Me’d jin ona /e mo tani aha/ si’da/ mina diki p̱ar jis em pini e ki sule/ doḵ e mo be. ");
INSERT INTO udu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Iṯwa/a/ TAP̱A ṯorki’da Musa gwo mo ki: Mompala kamu/ jin wo’c ’kwani is she/ diyi’di ’de/ naskina/ mo a’di jin miga/ ḵala p̱owa P̱irawn mo dhali ap̱o/ ’kwanim piti mo. Yan’ko’d mo tani a’di midi dhal um bway mo mmo/ii mo beseene/ mo. Ki a’di midi dhal um bway mo mmo/ii mo tani, a’di midi ur um ka kuluny mo. ");
INSERT INTO udu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ṯori ’kwaniŋ gwaṯẖ gwo mo ki up̱ ilu/ ki uni mini doṯ tiya kun ’dish uni gu’b is mo gom dhiriny ’dolkon kush dhali ’dolkon gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Dhali TAP̱A c̱iki ’kwani mii ma ’the i jis e gi ’kwani Pam Masir mo. Dhali aMusa ki is piti mo tani a’di karu ki dhan gump̱a/ mo e Pam Masir mo e jis e ma ris ’kwani kun miikina P̱irawn aṯu’c mo dhali e jis e gi ’kwani mo be. ");
INSERT INTO udu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Wakan aMusa oki’da P̱irawn gwo mo ki: Yase/ i ta gwo jin ona TAP̱A mo. Ki mo midi ta mombwam/e mo tani aha/ mina yaku/ e bwaman ’Kwani Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Dhala bwanyara/ uc̱iŋ gwaṯẖi ’baar mo gun ’kon e Pam Masir mo tani mini wu mo ’pena bwanyara/ ma P̱irawn jin c̱a’bka’da ḵurse/ ma maliḵ mo ntaga bwanyara/ gi c̱iŋkinam piti kun miina yo mo dhali i ta ga bwanyaram bip̱ si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Dhali e mun mo tani adhan cuuwa minu ’ther ki tur mo e Bampa/ Masiri ’baar mo. Mii gi wakan yisa mishkunu me’d ’de/ yisa walla mii yan midi doḵ e di yisa ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Hili e bwaman ’kwani ma Israyiil mo tani a’kaŋ kamu/ yisa midi buḵ wathiŋ kamu/ wala to e ilu/ yisa. Yan’ko’d um mini mish ki TAP̱A kar ki mo jin ḵwa/uwa ḵwa/ bwa ’peni ’kwanim Pam Masir nyaḵki ’kwani ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dhali aris ’kwanim pini kun miiki /e to mo tani uni mini dhorothu aha/ mo dhali luŋa luŋ gom aha/ mo dhali o gwo mo ki: Yaku/ /e ka pije/ mo dhali aris ’kwani kun baṯẖki /e nsho’k ’baar mo. Dhali yan’ko’d mo tani aha/ mina ya ka pije/ mo. Dhali a’di yaki’d ka pije/ ’pena P̱irawn ka nyor jin ’batha’ba’th mo. ");
INSERT INTO udu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Dhali iṯwa/a/ TAP̱A oki’da Musa gwo mo ki: AP̱irawn midi ciḵ gwo ’peni /e yisa mo. Wakan ki miimer pem miga/ mar is mo e Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa dhala Haruun miikina ris to mer gwani ’baar mo i ibwambor ma P̱irawn mo. Hili TAP̱A ’bi’thki’da P̱irawn adum piti is mo dhali a’di diki dhal ’kwani ma Israyiil bway mo mmo/ii mo ’peni bampam piti mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Dhali TAP̱A oki iMusa uni ka Haruun gwo mo e Pam Masir mo ki: ");
INSERT INTO udu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Appee yansan a’di ta’da ppee jin ṯwa/a/ ki yil gom um jin mina umi ṯel ’pen goma risa ppee i ’baar mo. A’di midi ta appee jin ṯwa/a/ ki yil gom um mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ṯora risa ŋul ’kup̱ ’kwani ma Israyiil gwo yan mo ka cima ’kume’d ka ppee yansan mo tani uni mini bu’th ushi ḵa’bal gwaṯẖan mo, wathi/ ka ’deṯe/ ’deṯe/ ’peni gu’b gi ibabam buni mo isi me’d jin wana a’di kan mo, ḵa’bala ’de/ gom gu’b ka kuluny mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Dhali waḵki/ kuŋgu’b ka kuluny gwa’da she/ mo gom ḵa’bala ’de/ mo tani dhalki uni nyaḵ ḵa’bal ki gu’ba kamu/ mo jin ’dish uni is mo. Uni mini deŋ ’kwani e me’d isa nimira jin midi p̱ar shum isi me’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ḵa’bal bum mini mii dar gi thalkin mo, ’pena rasan jin dina yili ’de/ gana/ mo. Um mini bu’th a’di ’peni bwaŋ ḵa’bal mo walla ’peni bwam mi mo. ");
INSERT INTO udu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Dhali um mini dhu uni ki ’bore/ mo ntaga cimi ’kume’d i’ce’d ka doŋon ka ppee yansan mo. ’Kwani ma Israyiil ka ŋul ’kup̱i ’baar mo mini ’kosh ḵa’bal buni jwa mom ’penḵaskum mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Dhali yan’ko’d mo tani uni mini ’thup̱a bas mo dhali ’kosh a’di e cwa gi ’twaŋkal gu’b ka ’ban su/ mo dhali i cwa gi buŋ’kup̱ ma campur gu’b mo kun ’kokina uni mmo’ka shum mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Uni mini ’thos shum ki isi o’d dhali ’ka a’di ki mon’thinya ’de/ c̱aan mo! Dhali uni mini ’ka a’di nyaḵki jasse/ jin ḵa/aḵa/ mo dhali nyaḵki maaŋḵuthu’d jin miinu ki dar ga cumaṯ mo. ");
INSERT INTO udu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Dhalku/ shum ki ’ka ki ’de/ mo walla dhalku/ a’di ki shun ki yi’de/ mo. Hili ’thosi a’di ki o’d mo ki ’kup̱ ilu/ mo dhali ki ’basho’k ilu/ mo dhali ka ris to ’baar kun ’koni bwaman buŋgwar is ilu/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Dhali um mini dhalku/ shuma kamu/ ki boc̱ ntagi mon’thamo/ mo. Waḵki/ kun tiya boc̱a umi ta gi mon’thamo/ tani ’thayyi um uni o’d mo ka jiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Bwaya ’dihe/ jin mina um i ’ka a’di mo: Deḵi wac̱kan e empa’d bum mo dhali hitha p̱p̱am bum mo dhali ḵala lukaas e me’d bum mo, dhali um mini ’ka shum ki yap̱ yap̱ ise/ ki jahanne/ mo. Haali/ a’di ta Mompe’kup̱anyolos gi TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Dhali aha/ mina pe ki tur e Bampa/ Masir ki mon’thiny c̱aan mo. Dhali aha/ mina ’kosha bwanyara/ gi Pam Masir ’baar mo uni kun tana gwaṯẖ mo dhali ki to e ilu/ mo. Dhali arum p̱inycon jin luŋa uni mo tani aha/ mina dor uni mo. Aha/ be i tana TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Abas a’di i midi ta jamas mmomish gwo ’ban gom moŋ’kom bum mo. Dhali ki aha/ mina p̱ara bas e mo tani aha/ mina pe um ’kup̱a nyolos mo. Dhali mii shi/gaŋ kamu/ yisa midi biṯa p̱o/ um mo mmo’ce’d um sho’k mo me’d jin miga/ ’kosh Bampa/ Masir mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Atee midi ta jim bum jin mina umi ka e mo. Um mini ta gi dhan moshwan to mmotaḵ TAP̱A mo. Um mini nyoŋ a’di me’d gwoŋḵan jin mina umi mii ki tur e emen bum ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Um mini shwa maaŋḵuthu’d jin miinu ki dar ga cumaṯ goma cimi pesu/ mo. Dhali ka cim jin ṯwa/a/ mo tani um mini ḵala cumaṯ bum sho’k ka pije/ mo ’peni aris gu’b bum mo. Jan ṯal ’deŋ kamu/ midi diki shwa ji gi din ma cumaṯi e mo’pena cim jin ṯwa/a/ ntaga cimi pesu/ mo. Haali/ waḵki/ wathiŋ kamu/ shwa to ka maḵ tani minu ’ciṯẖ ’twa/ mo ’peni ’kwani ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ka cim jin ṯwa/a/ mo tani um mini ta gi mo ma tul ’kup̱ jin ḵogu mo. Dhali ka cimi pesu/ mo doḵ e um mini ta gi mo ma tul ’kup̱ jin ḵogu mo. Aṯuca kamu/ minu mii ka tee gwansan yisa, hili jasi to jin miin ma ris ’kwani ’baar ka ’deṯe/ ’deṯe/ i shwa mo a’di mina umi i mii thoson jasi is mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Um mini kar Dhan Moshwan To gi Maaŋḵuthu’d jin miinu ki dar ga cumaṯ mmotaḵ TAP̱A ki sule/ mo be. Haali/ a’di ta’da tee yan gana/ jin ḵalkika/ waḵ bum ka pije/ ’peni Pam Masir mo. Ka cim yansan ’ko’di yili ’baar mo tani um mini shwa maaŋḵuthu’d jin miinu ki dar gi cumaṯ mo ki dhan mombuṯ yan mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Dhali ka cim jin ṯwa/a/ jin ta’da ’kume’d i’ce’d ka doŋon ma ppe mo mom’pimpili/ mo tani um mini shwa maaŋḵuthu’d jin miinu ki dar ga cumaṯ mo dhali wakan si’da/ ntaga cim iss ’de/ i’ce’d ’de/ ka ppe mo mom’pimpili/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Haali/ goma cima pesu/ mo tani acumaṯa kamu/ minu gam yisa eya ris gu’b mowa. Dhali waḵki/ unin tiya shwaki maaŋḵuthu’d jin miikunu ka cumaṯ mo tani ’kwani gwansan minu ’ciṯẖ ’twa/ mo ’pena ŋul’kup̱ gi ’kwani ma Israyiil mo be. Nyaḵka’d kan waḵki/ a’di ta wathi/ jin yayi yilkina/ mo walla wathi/ gi bampa/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Dhalku/ maa jin minu ka cumaṯ ki shwa mo. E mo ’baar kun ’kona um mo tani, um mini mii shwa to kun minu ki dar ga cumaṯ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Dhala Musa yuḵki’da ris ’kwani jwaha/ ma Israyiil mo dhali ṯor uni gwo mo ki: Lahi ushi ḵa’bal gom is bum mo me’d isa waḵ bum mo dhali ’koshi uni mo goma Cim gi Mompe’kup̱anyolos yan mo. ");
INSERT INTO udu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Budhi deḵken cwan ’tasha cal bip̱ mo dhali ’thup̱i a’di ka bas jin diki’d mo e bwaman ma sahan mo. Dhali ’koshi a’di i buŋ’kup̱ ma campur mo dhali ka ’ban su/ cwa ma campur mo ka bas jin diki’d e bwaman ma sahan mo. Dhali jan ṯal ’deŋ kamu/ yisa midi ya ka pije/ ka campur gu’b piti mo ntagi mon’thamo/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Haali/ TAP̱A a’di i midi ya pe ki tur mo mmo’kosh ’kwani Pam Masir mo. A’di midi p̱ara bas e mo e buŋ’kup̱ ma campur dhali ’ko’d gwara su/ mo. Dhali a’di midi peya campur ’kup̱ mo dhali midi diki dhala aman’ce’da ’ce’d sho’k bway mo mmoci’c aris gu’b bum mo mmo’kosh um mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Um mini ha gwoŋḵan e mo, um dhali iya/m bum ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Dhali ki um mini ci’c mo e bampa/ c̱aan jin okina TAP̱A mo mmoc̱i um mo me’d isi gwo jin okina a’di is mo tani um mini kar Mompe’kup̱anyolos yansan mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Dhali uc̱im bum mini o um gwo mo ki: ’Pemen mii yan ta’da tinta jin ona um gom miin to yan mo? Ki uni mini o um gwo kan mo tani ");
INSERT INTO udu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","um mini o gwo mo ki: A’di ta mii ma basa ’cesh gi TAP̱A mo gom mompe’kup̱anyolos mo haali/ a’di peki gu’b gi ’kwani ma Israyiil ’kup̱ e Pam Masir mo. A’di ’koshki ’kwani Pam Masir mo hili a’di i ’tashki gu’b bana ’twa/ mo be. Dhali ’kwani ṯaki ’kup̱ buni ka luŋgu’b mo dhali luŋa luŋ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Dhali ’kwani ma Israyiil uni iikin mo dhali mii a’di wakansan mo me’d gwo jin ḵankina TAP̱A aMusa mo dhala Haruun mo. ");
INSERT INTO udu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ki mombwam/e mo tani TAP̱A ’koshki’da risa bwanyara/ gi Bampa/ Masir mo. A’di ’koshki’da bwanyara/ ma P̱irawn mo a’di jin c̱a’bki’da ḵursem piti mo. Dhali a’di ’koshki’da ris uni ’baar mo si’da/ ntaga bwanyara/ gi a’di jin di’da sijina ’kulga/ mo dhali arisa bwanyara/ gi to e mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Dhali aP̱irawn cuki mis mo mon’thiny mo, a’di dhali aris imanmii a’di to mo dhali aris ’kwani Pam Masiri ’baar mo. Dhali adhan mo jin ḵumu/ ko caaca kagahara mo e Bampa/ Masir mo haali/ gu’ba kamu/ yisa di’da jin dina jan ṯal ’deŋ kamu/ ki wu i bwaman mowa. ");
INSERT INTO udu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Dhali a’di yuḵki’da Musa dhala Haruun ki mon’thinya ’de/ c̱aan mo dhali o gwo mo ki: Cuyi um mis mo dhali iiku/ mo ka pije/ ’peni bwaŋ ’kwanim pem mo isi um gwan dhali ’kwani ma Israyiil mo. Dhali iiku/ um mo dhali mii ki montaḵ gom TAP̱A mo me’d jin okina um mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Budhi arisa ma’diny ḵa’bal bum dhali aris bip̱ bum mo me’d gwo jin okina um mo. Dhali iiyi mo dhali ’borki aha/ mii si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Dhali ’kwanim Pam Masir uni di’bki ’kwani is mo mmo/iiku/ mo ki yap̱ yap̱ ki jahanne/ ’peni bampam buni mo haali/ uni oki gwo mo ki: Amani ’baar mo mura wu mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Gom kan mo tani ’kwani ḵalkina gana’th buni ki dar ga cumaṯ i e mo. Aḵwalal buni jin ’thoḵa uni to nycine/ mo tani koṯẖkina uni is mo ki burrinyem buni mo dhali shir uni mo e ’kup̱a bim buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Dhali ’kwani ma Israyiil miikin mo me’d jin ṯorkin ma Musa uni gwo mo. Uni ’thoki ’kwani Pam Masir dhiriny ’dolkon kush mo dhali ’dolkon gana/ mo dhali burrinye/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Dhali TAP̱A c̱iki ’kwani mii ma ’the e jis e gi ’kwani Pam Masir mo. Uni c̱iki uni to gun doṯa uni mo be. Yase/ i ta mii jin ḵalkina uni ’kwani Pam Masir to mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Dhali ’kwaniŋ gwaṯẖ ma Israyiil thum ii ka ji sho’k mo ’peni Pa Ramisiis mo ntagi Pan Suḵuuṯ mo. ’Kwani ’kona alip̱i suttu miyya mo kun iikin ki sho’k mo mmodiki deŋ up̱ e dhali uc̱i mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","’Kwanin tiya ka ris iikin nyaḵki uni mo dhali to e kun tana ris ka ris mo nyaḵka ma’diny ḵa’bal mo dhali aris bip̱ mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Dhali uni ’thoḵki maaŋḵuthu’d ki dar ga cumaṯ i e mo ’pena gana’th jin ḵalina uni mo ka pije/ ’peni Pam Masir mo. Uni ’konuki miiya cumaṯ i e mo haali/ uni dhi’thunu sho’k ka pije/ mo ’peni Pam Masir mo. Uni yisa tan ga tenteŋ kamu/ mo mmothoson is buniŋ gana/ mo gom tonṯe/ gom bway mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yil gun ’kokina ’kwani ma Israyiil mo e Pam Masir mo tani ta’da urbu/ miyya wa talatiin mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Dhali e she/ yil ma urbu miyya wa talatiin mo ’pena cim gana/ ’de/ yan mo tani ku gi TAP̱A ’baar mo iikin ka pije/ mo ’peni Pa Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","A’di ta mon’thiny jin jikina TAP̱A aji mo mmosusu uni ka pije/ mo ’peni Pam Masir mo. Wakan ki mon’thiny yansan jin nyaḵka’d mo tani ’kwani ma Israyiili ’baar mo mini jiya ji ka tee yan eya risa nyaḵum yil buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Dhali TAP̱A oki’da Musa dhala Haruun gwo mo ki: Yansan a’di i ta gwoŋḵan gom mompe’kup̱anyolos mo be. Wathi/ gi paŋ kamu/ midi ’ka a’di mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Hili aris c̱iŋkina/ kun yolu ka guurush mo tani uni a’di i mini ’ka a’di mo ŋ’ko’di /e mini ’ciṯẖ uni amunyjal yis buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Hili ’kwani gun iiyi yilkina/ mo walla ’kwani gun kwanyu ki imanmiiya ṯu’c mo tani uni mini ’ka yisa. ");
INSERT INTO udu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","E gu’ba ’de/ mo tani a’di i minu ’ka a’di mo. Um mini dhalku/ shum ki ḵal ka pije/ mo ’peni gu’b mo dhali um si’da/ mini dhalka sima/ ki ’ce’d bwa mo ’peni uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Adhana waḵ ’kwani ma Israyiil ka kuluny mini mii moshwan to yan mmotaḵ TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Dhali waḵki/ wathi/ jin dina e ki she/ di’di nyaḵki um mo dhali ŋap̱a’d mmokar Mompe’kup̱anyolos gi TAP̱A mo tani dhalka ris unim piti ka kuluny kun tana gwaṯẖ ’ciṯhuwa munyjal yis mo, dhali yan’ko’d a’di midi yayu/ mo mmo’dish mo is mo dhali kar a’di mo. A’di si’da/ midi wa e ki wathi/ gi bampa/ mo. Hili wathi/ jin di’d ka munyjal yisi e mo tani midi diki ’ka shum yan mo. ");
INSERT INTO udu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Gwoŋḵan midi ṯal ’de/ gom wathi/ gi bampa/ mo dhali gom wathi/ jin dina e ki she/ jin nyaḵki di ki um mo be. ");
INSERT INTO udu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Yase/ i miikina ’kwani ma Israyiil i ’baar mo me’d jin ḵankina TAP̱A aMusa gwo dhala Haruun mo. ");
INSERT INTO udu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Dhali ka cima ’deŋ gana/ yan mo tani TAP̱A suski ’kwani ma Israyiil ka pije/ mo ’peni Bampa/ Masir mo ka waḵ buni ’peni e kun ’ko uni ki she/ ki she/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Dhali TAP̱A oki’da Musa gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","C̱iyi aha/ arisa bwanyara/ mo ’peni kuŋ gwaṯẖ, uni kun ḵa’dki bwa ma dho’th gi ’kwani ma Israyiil mo ’peni wathiŋ gwaṯh mo dhali to e mo. Uni ta kum pem mo. ");
INSERT INTO udu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Dhali aMusa oki ’kwani gwo mo ki: Kayi atee yansan e mo a’di jin pikina um ka pije/ mo ’peni Bampa/ Masir mo, ’peni mo jin miinu um ki miiny c̱iŋkina/ mo. Haali/ ki me’d gi TAP̱A jin ’bitha’bi’th mo tani i suskina a’di um ka pije/ mo ’peni mo yansan mo. Maaŋḵuthu’da kamu/ yisa mina umi shwa jin din ma cumaṯi e mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ka ppee jin ṯwa/a/ jin yuḵu ka Abiib mo tani um mini ii ki sule/ suleŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","TAP̱A oki gwo is gom ibabam bum mmoc̱i ki um a’cesh gi Bampa/ Kanaan mo dhali Bampa/ Hathaṯẖ mo dhali Bampa/ Amuur mo dhali Bampa/ Hawb mo dhali Bampa/ Yabuus mo. Ki a’di midi ’doyu/ um eya ’cesh jin ta pa ki pa mo, um mini mii moshwan to yan ka ppee jin ṯwa/a/ ’ko’di yili ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Goma cimi pesu/ um mini shwa maaŋḵuthu’d jin miinu ki dar ga cumaṯ mo. Dhali ka cim pesu/ mo tani dhan moshwan to midi di mmotaḵ TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Maaŋḵuthu’d jin miinu ki dar ga cumaṯ mo tani a’di i minu i shwa ka cim pesu/ mo. Maaŋḵuthu’da kamu/ jin miinu ka cumaṯ yisa minu mii mishi um mo dhali acumaṯ yisa si’da/ minu mii i mishi um eya ris gwayu/ moŋ’kom bumi ’baar mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Dhali /e mini ṯor iya/m pini gwo ka tee c̱aan mo ki: Mii yan miikika/ gom to jin miina TAP̱A gom aha/ mo ki aha/ pikina ka pije/ ’peni Bampa/ Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Dhali a’di midi ta jamas mii e me’d pini mo dhali me’d mo jin kanuwa ka e e buyem pini mo, ki gwoŋḵan gi TAP̱A midi di e ’twam pini mo. Haali/ ki me’da ’bi’thga/ gi TAP̱A mo tani a’di i suski /e ka pije/ mo ’peni Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Gom gwo gi wakansan mo tani /e mini kar gwoŋḵan yansan ka ḵanne ka cim jin karu a’di gom ki sule/ ’ko’di yili ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Dhali TAP̱A midi susi /e e Bampaŋ Kanaan mo isi me’d mii jin thulkina a’di gwo me’da p̱o/ mo gom /e mo dhali ibabam pini mo. Dhali ki a’di midi c̱iki /e a’di mo tani ");
INSERT INTO udu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","/e mini dhu to ki she/ gom TAP̱A mo, uni kun ṯwa/a/ mo kun ḵa’dki bwama dho’th mo. Arisa bwanyaran to em pini mo uni kun tana rasan mo uni ta kun TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Eya risa bwanyara ma rasan thuluny mo tani /e mini wan uni ’ba/ ki ḵa’bal mo. Walla waḵki/ /e diki wan uni ’ba/ mo tani ’ce’di a’di ’ba/ piti mo. Dhali arisa bwanyara/ uc̱iŋgwaṯẖ kun dho’thkunu mo e bwaman iya/m pini mo tani /e mini wan uni ’ba/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Dhali ka tee midi p̱u’du/ mo tani ya/m pini midi doṯ /e gwo mo ki: ’Pemen gwo yan ta’da tinta mo? /E mini thoḵ a’di gwo mo ki: Ki me’d gi TAP̱A jin ’bitha’bi’th mo tani a’di i suskina a’di aman ka pije/ mo ’peni Pam Masir mo ’pena ’cesh gi miiny c̱iŋkina/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Haali/ ka P̱irawn yan ushki’d ki ’tash mo mmodhal aman bway mo mmo/ii mo tani TAP̱A ki ’kosh arisa bwanyara/ kun dhodhu e Bampa/ Masiri ’baar mo ’peni uc̱iŋ gwaṯẖ kun tana bwanyara/ mo dhali ’pena risa bwanyaran to e mo. Gom gwo gi wakan mo tani aha/ miikina TAP̱A abasa ’cesh mo ’peni aris to e kun ta gwaṯẖan mo kun ḵa’dki bwama dho’th ’twa/ mo. Hila bwanyara/ gi iya/m pem ’baar mo tani aha/ wankina/ uni ’ba/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","A’di midi ta jamas gom /e e me’d pini mo walla e buyem pini mo ki me’da ’bi’thga/ gi TAP̱A a’di i suski aman ka pije/ ’peni Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ka P̱irawn dhalki ’kwani bway mo mmo/ii mo tani Arumgimis diki shu uni bway mo ki bway Pam P̱ilisṯiyiin mo, ba ki a’di ’disha’dish mo kan de. Haali/ Arumgiimis oki gwo mo ki: Waḵki/ uni mini p̱ar mo/as e mo tani uni wari mini rica du is mo dhali doḵ bway Pam Masir ka nyaŋ’ko’d mo ba/. ");
INSERT INTO udu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hili Arumgimis suski ’kwani ka kukul is mo ki bway gi mombwaasho mo ’kup̱ ki ḵumma/ Yi’de/ jin ta gi ’Per mo. Dhali ’kwani ma Israyiil uni iikin ka pije/ mo ’peni Bampa/ Masir mo mmonyaŋ is gom mo ma mee mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Dhali aMusa ḵalki’da sima/ ma Yuusup̱ mo nyaḵki a’di mo haala Yuusup̱ ṯeki gwo gom ’kwani ma Israyiil mmo/o is mmomii kan mo be. A’di ki o gwo mo ki: Arumgimis midi yayu/ i woṯẖ um mo. Dhali yan’ko’d mo tani um mini mii ḵala simam pem nyaḵki um mo ’peni mahan mo. ");
INSERT INTO udu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Dhali uni joc̱kin mo ’peni Pa Suḵuṯẖ mo dhali bu’th moŋ’ko me’d e Pan Iṯẖaam mo e shemen gi mombwaasho mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Dhali TAP̱A a’di i yaki uni ibwambor montee ka raḵ jin wana e ka ḵa’dum ki jamas piti mo mmoshu uni bway ki sule/ sule/ mo. Dhali mon’thiny si’da/ o’d jin wana e ka ḵa’dum ki jamas piti c̱iki uni moŋkush mo ki uni mini mish ii montee dhali mon’thiny mo be. ");
INSERT INTO udu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Araḵa ḵa’dum montee dhali araḵa ḵa’dum o’d mon’thiny mo uni ’koki dhal ’kwani ’pen mo ’peni jis em buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Ṯori ’kwani ma Israyiil gwo mo mmoṯuka bor ka nyaŋ’ko’d mo dhali thum gu’b burrinyem buni mo i bwambor ma P̱ihaahiiruṯẖ mo. A’di di’da nuss bwaman gi i Majduul dhali ḵumma/ yi’de/ mo jin ’dish pa Baalsap̱un is mo. ");
INSERT INTO udu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Haala P̱irawn midi ṯosh ki ’kwani ma Israyiil ii ki ii ma wukura/ e mombwaasho mo dhali mombwaasho si’da/ mu’thki uni ki jiṯ mo e bwaman mo. ");
INSERT INTO udu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Dhali aha/ mina ’bitha P̱irawn adum piti is me’d wosh mo dhali a’di midi ur um i sho’k mo dhali aha/ mina gam monyca ’pena P̱irawn mo dhali ’pena jesh piti mo. Dhali ’kwani Pam Masir mini mish mo mo ki aha/ tana TAP̱A mo. Dhali ’kwani ma Israyiil miikin wakan si’da/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ka maliḵ gi ’kwanim Pam Masir ṯorkunu gwo mo ki ’kwani sokin bway bwaasho mo tani bwa ma P̱irawn aḵ e nyaḵki imanmii tom piti mo ’kup̱ ki uni mo. Dhali uni oki gwo mo ki: Atinta a’dan jin miikina ana mo? Ana ki dhala Israyiil bway mo mmo/ii mo ’peni mo jin miikina uni ana to mo. ");
INSERT INTO udu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Wakan a’di thosonki’da arabiyam piti jin dira shumarum ki jahanne/ mo dhali sus ’kwani ma meem piti nyaḵki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Dhali a’di dilki’da arabiya sho’k i’baar mo gun dira shumarum mo e bwaman uni kun tana suthumiyya i ’bora’bor mmobol tiya e mo. I bwaman uni ta gi ’kwaniny can ka ’deṯe/ ’deṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Dhali TAP̱A ’bi’thki’da du ma P̱irawn is mo a’di jin ta’da maliḵ gi ’Kwani Masir mo dhali a’di urki ’kwani ma Israyiil i sho’k mo me’d jin iikina uni mo ki dar gi moŋḵo/ is mo. ");
INSERT INTO udu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","’Kwani Pam Masir uni urki uni i sho’k mo, aris shumarum ma P̱irawn mo dhali arisa arabiya kun dira shumarum mo dhali ’kwanim piti kun merki shumarum ap̱o/ mo dhali ’kwanim piti mo dhali ’kwani ma meem piti mo. Dhali uni ’baar mo ur uni sho’k dhali dil uni is mo ki ’kwani ma Israyiil thumki gu’b burrinyem buni i shemen ḵumma/ yi’de/ mo ki bway gi Bampa/ Pan P̱ihahiiruṯẖ mo jin ’dish Bampa/ Baalsip̱uun is mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ka P̱irawn ’dishki mo is mo tani ’kwani ma Israyiil uni ’deki em buni ’kup̱ ki mis mo dhali ’kwani Pam Masir uni yakina ye’c ye’c i’ko’di uni mo. Dhali uni shwakin ma kap̱e/ kagahara mo. Dhali ’kwani ma Israyiil uni gwo ki ’twa/ en TAP̱A mo. ");
INSERT INTO udu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Dhali uni okina Musa gwo mo ki: A a’di bese/ i ta mii mo haali/ jis jwa jin minu kan ’kwani e Pam Masir p̱iyina? I suskina /e am mo mmowu mo mombwaasho kana? Atinta miikina /e aman kan mo mmosusu aman ka pije/ ’peni Pam Masir mo? ");
INSERT INTO udu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","A’di diki ta gwo jin ona aman /e e Pam Masir ki: Dhalki aman mo. Dhalki aman miikina ’kwani Pam Masir to mo. Haali/ a’di midi ’taki ha me’d ki isi haŋ gana/ mo gom aman mo mmomii ki ’kwani Pam Masir to mo mmo’koki wu mo e mombwaasho mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Dhala aMusa oki ’kwani gwo mo ki: Dhalku/ is ki ḵo/ mo. Doshi ṯel shoka ’cesh ’te/ mo dhali p̱ar mowoṯẖ gi TAP̱A e mo a’di jin mina a’di i miiya ṯuca p̱o/ shwane/ gom um mo. ’Kwani Pam Masir kun p̱arkina um e mo shwane/ tani mina umi ’koki p̱ar e doḵ e ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","TAP̱A a’di i midi as gom um mo dhali um a’di ’te/ i mini ṯel jasi shoka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","TAP̱A oki’da Musa gwo mo ki: Atinta i gwokina /e ’twa/ i aha/ mo? Ṯori ’kwani ma Israyiil gwo mo mmo/ii mo ki seṯẖ. ");
INSERT INTO udu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","’Deki cwam pini ’kup̱ ki mis mo dhali yethi me’d pini ap̱o/ ḵumma/ yi’de/ mo dhali ḵwa/i a’di bwa mo ki uni mini mish ii ap̱o/a ’cesh jin ḵuthaḵu’th ki tur mo e ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Dhali aha/ mina ’bitha du gi ’kwani Pam Masir is mo wakan ki uni mini i baṯẖ uni i sho’k mo. Dhali aha/ mina gam monyca ’pena P̱irawn mo dhala risa jesh piti mo dhali aris shumarum piti kun dirina arabiya mo dhali aris ’kwani ma meem piti kun mer shumaruma p̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Dhali ’kwani Pam Masir mini mish mo mo ki aha/ tana TAP̱A mo ki aha/ mina gam monyca mo ap̱owa P̱irawn mo dhali arisa arabiyam piti kun dira shumarum mo dhali aris ’kwani ma meem piti kun merki shumaruma p̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Dhali yan’ko’d aman’doyu/ gwo ma Arumgimis jin yaki’da jesh gi ’kwani ma Israyiil ibwambor mo tani a’di joc̱ki’d mo dhali ya i’ko’di uni mo. Dhali araḵa ḵa’dum si’da/ joc̱ki’d mo ’peni bwambori uni bway ’ko’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","A’di dwarki’di embul bwaman ma jesh ’Kwani Masir mo dhala jesh ’kwani ma Israyiil mo be. Araḵ ḵali mondhurumi’d gom ’kwani pa Masir mo, hili a’di ki c̱iki moŋkush gom ’kwani ma Israyiil mo. Dhali mon’thiny yaki’di pe mo ki dar gi jin ṯal ’deŋ kamu/ mmoyaku/ mmo’disha kamu/ is ki mon’thiny c̱ani ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Dhali yan’ko’d aMusa ye’thki me’d piti mo ap̱o/ ḵumma/ yi’de/ mo. Dhali TAP̱A halki ḵumma/ yi’de/ ka nyaŋ’ko’d ki ’tham gi mom’pesho’k jin ’bitha’bith mo mon’thinyi ’baar mo dhali a’di ki kar ḵumma/ yi’de/ mo mmota a’cesh jin ḵuthaḵu’th mo dhali aris yi’de/ uni ḵwa/kunu bwa mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Dhali ’kwani ma Israyiil uni iikin mo e bwaman ḵumma/ yi’de/ ap̱owa ’cesh jin ḵu’th ma p̱o/ ki ḵu’th mo. Aris yi’de/ ḵarki ’kup̱ ki ta gaŋgara/ gom uni mo ki ’ban sum buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","’Kwani Pam Masir uni urkina uri sho’k mo dhali iikin mmobaṯẖ uni gi sho’k mo e bwaman ḵumma/ yi’de/ mo, aris shumarum ma P̱irawn mo dhali arisa arabiyam piti mo dhali aris ’kwani ma meem piti kun merki shumaruma p̱o/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Dhali i ṯwa/a/ gi mon ’twash e TAP̱A hilki mo ka luŋgu’b ’peni bwam ma ḵa’dum o’d dhali araḵ mo ap̱o/ ’kwani ma mee Pam Masir mo dhali duŋgur uni ’kup̱ is mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A’di raḵki’da arabiyam buni kun dirkina shumarum mo. Wakan mombor buni uni diṯkin ki diṯ mo. Dhali ’kwani Pam Masir uni oki gwo mo ki: Dhalki ana sona mo ’peni ’kwani ma Israyil mo haali/ TAP̱A a’di i aski’d gom uni mo ap̱o/ ana mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Yethi /e me’d pini mo ap̱o/ ḵumma/ yi’de/ mo ki yi’de/ midi doḵu/ ka nyaŋ’ko’d ap̱o/ ’kwani Pam Masir mo dhali ap̱owa ris arabiyam buni mo dhali ap̱o/ ’kwani ma meem buni kun merki shumaruma p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Wakan aMusa a’di i ye’thki me’d piti mo ap̱o/ ḵumma/ yi’de/ mo. Dhali mon’twash e ḵumma/ yi’de/ a’di doḵki’d ka nyaŋ’ko’d bway mo jin gusina a’di mo be. Dhali ’kwani Pam Masir uni sokin ’peni yi’de/ mo hili TAP̱A a’di belki uni mo e bwaman ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Yi’de/ doḵki’d ka nyaŋ’ko’d mo dhali kuma p̱o/ a/arabiya kun dirkina shumarum mo dhali ’kwani ma mee kun merki shumaruma p̱o/ mo dhala risa jesh ma P̱irawn mo uni kun baṯẖki ’kwani ma Israyiil i sho’k mo e ḵumma/ yi’de/ mo. Jan ṯal ’deŋ kamu/ dhalu ki e yisa. ");
INSERT INTO udu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Hili ’kwani ma Israyiil uni iin ki tur eya ’cesh jin ḵuthaḵu’th mo e ḵumma/ yi’de/ mo, yi’de/ i warki’d ka gaŋgara/ gom uni ki ’bana bim poros buni mo dhali ki ’bana biny cam buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Yase/ i ta mii gi TAP̱A mo mmota Israyiil is ki me’d mo ka tee c̱aan mo ’peni me’d gi ’kwani Pam Masir mo. Dhala Israyiil mishki ’kwani Pam Masir wukin mo e yana gap̱ gi ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Dhala Israyiil mishki dhan mom’bi’th jin miikina TAP̱A ap̱o/ ’kwani Pam Masir mo. Dhali ’kwani uni ḵo/ki TAP̱A mo. Dhali uni gamki gwo is e TAP̱A mo dhali e c̱iŋkinam piti ka Musa mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Dhali yan’ko’da Musa dhali ’kwani ma Israyiil yuḵi gway yansan mo e TAP̱A mo mmo/o gwo mo ki: Aha/ mina yuḵ gway e TAP̱A mo haali/ a’di karu ki ji gi eḵa/ eḵ mo. Shumarum dhali com piti mo tani uni belkunu mo e ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","TAP̱A a’di i ta mom’bi’th pem mo dhali moroc̱ pem mo dhali a’di warki’d ki mowoṯẖ pem mo. A’di i ta’da Arumgimis pem mo dhali aha/ mina maŋ a’di mo, Arumgimis jin ta ji gi ibabam pem mo dhali aha/ mina kar a’di ki ji gi eḵa/ eḵ mo. ");
INSERT INTO udu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","TAP̱A a’di i ta a’di gi mo/as mo, gway piti i ta TAP̱A mo. ");
INSERT INTO udu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Arabiya ma P̱irawn kun dirkina shumarum ka ris mo dhali ajesh piti mo tani uni i ṯa’kkina a’di mo e ḵumma/ yi’de/ mo. Dhali ’kwaniny can piti kun yuḵayuḵ gun bol tiya e ki yuḵ mo tani uni loskina ḵumma/ Yi’de/ jin Ta gi ’Per mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Agannu/ yi’de/ i kumki uni mo, uni iikin ka ’cesh mo ki si’d si’d me’d wosh gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Me’da bim poros pini ayy TAP̱A, a’di eḵa/eḵ e mom’bi’th mo. Me’da bim poros pini, ayy TAP̱A a’di i c̱ekerki ’kwaniŋ ’kup̱ bwa mo. ");
INSERT INTO udu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","E monycam pini jin caaca kagahara mo e mo jin eḵa/ /e ki eḵ mo tani /E yocorki ’kwani ’twa/a ’cesh kun ta ’kup̱ ki /e mo. /E hashkina nyor pini jin ’batha’ba’th mo a’di shwa ki uni mo me’da wusha/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Eya le’dan gi jisan shush pini mo tani aris yi’de/ p̱alan ka pije/ mo. Dhali agannu/ yi’de/ a’di doshki’d ka jisho’k me’da gaŋgara/ mo dhali moŋ’kulga/ gi ḵumma/ yi’de/ wara’d ki boro’th mo. ");
INSERT INTO udu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","’Kwani kun ta ’kup̱ oki gwo mo ki: Aha/ mina ura uri sho’k mo, dhali aha/ mina bu’th uni mo. Dhali aha/ mina ḵwa/ mal buni bwa mo, dhali dil ku gi o aha/ bwa mo. Dhali aha/ mina buḵ gandala turgam me’d pem mo. Dhali me’d pem a’di i midi i ’ce’d uni sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","/E ’theḵki ’tham pini mo dhali ḵumma/ yi’de/ i kumki uni ’twa/a ’cesh mo be. Uni loskina yi’de/ mo ki ’kolo’c me’da hathiṯẖ mo, e yi’de/ jin c̱a’b ki dem dem mo. ");
INSERT INTO udu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kaja a’di wana e ki /e, ayy TAP̱A, i bwaman ma risa ruma ’cesh mo kun yeru gway ka wuny is mo? Kaja a’di wana e ki /e mo? /e jin cayaa/ e ki ca mo e mo jin ḵogu mo. /e dar ki liil e monycam pini jin miina /e to mo /e miiki miimer ka ris mo. ");
INSERT INTO udu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","/E ye’thki me’d pini jin ta’da bim poros mo tani mony’cesh loski uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","’Kwani kun wankina /e ’ba/ mo tani /E shuki uni bway ki mo/en pini jin ṯelkunu sho’k mo. /E shuki uni bway ki mom’bi’th pini mo e moŋḵogum pini jin dina /e nycine/ mo. ");
INSERT INTO udu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ka ŋul’kup̱ ’kwani i ciḵkin mo tani uni dekin ki bir bir mo be, dhali akap̱e bu’thki ’kwani P̱ilisṯiyiin mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Dhali aris tap̱a gi Pa Aduum uni si’da/ ḵalkina jwa mo dhali aris tap̱a gi ’kwani Mu/ab mo tani mo jin denu ki bir bir mo tani a’di bu’thki uni mo. Dhali aris ’kwani kun ’kokin mo e Paŋ Kanaan mo tani uni thiski mo ma dum ’bi’thgam buni e mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Akap̱e/ dhali mo jin ṯagu is jwa mo a’di i biṯki’da p̱o/ uni mo. Gom monyca ma bim pini mo tani uni doshkin mo mmoḵu’th guŋkuru/ me’d wosh mo, Ayy TAP̱A. Ntagi ’kwanim pini pekin mo uni kun ’cuḵkina /e mo be, ");
INSERT INTO udu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","/E mini susi uni mo dhali i dhu uni e ’kuwosha turgam pini mo, ayy TAP̱A, e mo jin karkina /e mmota mondim pini jin ḵogu/ mo jin nyaŋkina /e ki me’d pini mo. ");
INSERT INTO udu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","TAP̱A /e i mini ta aMaliḵ gom ki sule/ sule/ ya ye ’ba/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ka arabiyaŋ ’kwani Pa Masir dhali shumarum ki imanmer uni ilu/ ’ceṯẖki bway ḵumma/ yi’de/ mo tani TAP̱A ḵalki yi’de/ ka nyaŋ’ko’d ’peni ḵumma/ yi’de/ ap̱o/ uni mo be. Hili ’kwani ma Israyiil uni iikin ap̱o/a ’cesh jin ḵuthaḵu’th e bwaman ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Dhali yan’ko’d aMiriyam jin ta’da amanc̱i gwo jin ta’da yim mo a’di jin ta ’bwah ma Haruun mo a’di ’bu’thki’da jallugga/ e me’d piti mo. Dhali aris up̱i ’baar mo iikin mo ka pije/ mmobaṯẖa yimi sho’k ka jalluggam buni i me’d mo dhali sa mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Dhala Miriyam yuḵki uni gway mo mmo/o gwo mo ki: Yuḵi gway e TAP̱A mo haali/ a’di p̱iki mii e ki monycaŋ gana/ mo. Shumarum dhali imanmer uni ap̱o/ mo tani uni belkunu mo e ḵumma/ yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Dhali yan’ko’d aMusa suski’da Israyiil ki seṯẖ mo ’peni ḵumma/ Yi’dem ’Per mo. Dhali uni iikin mo e mombwaasho jin yuḵu gway ka Shur mo. Uni iikin ka cimi kwara/ e mombwaasho mo dhali ’koki gam yi’deŋ kamu/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ki uni p̱u’dkin e mo jin yuḵu gway ka Murrah mo tani uni molki yi’de/ p̱i ’peni a’di mo haali/ a’di ḵa/aḵa/ kagahara mo. Gom gwo gi wakan mo tani a’di i yuḵkunu a’di gway ka Murrah mo. ");
INSERT INTO udu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Dhali ’kwani miikina gumgum ap̱owa Musa mo mmo/o gwo mo ki: Atinta a’di mina ana i p̱i mo? ");
INSERT INTO udu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Dhala Musa gwo ki ’twa/ e TAP̱A mo dhali TAP̱A ṯorki a’di cwa mo. Dhali a’di birki a’di mo e yi’de/ mo dhali yi’de/ c̱a’b ki dhel dhel mo. E mun mo tani TAP̱A c̱iki uni gwoŋḵan ki ’twa/ mmomii mo. Dhali e mun mo tani a’di palki uni mo. ");
INSERT INTO udu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A’di o gwo mo ki: Waḵki/ um mini ha gwom pem e ki ’bor ’bor mo tani dhali mii jasi tom ’boron e jis em pem mo tani dhali c̱iya hirdhe/ ki gwoŋḵan pem mo dhali dhuwa ris gwoŋḵan gi ’twam pem mo tani, aha/ mina dhu ’batha tiya ap̱o/ um yisa me’d kun dhukika/ ap̱o/ ’Kwani Masir mo. Haali/ aha/ tana TAP̱A jin wac̱ um mo. ");
INSERT INTO udu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Dhali yan’ko’d uni p̱u’dkin mo e Pa Iliim mo e mo yin jin ’kokina yi’de/ gun du’dun i ’kume’d i’ce’dka su/ mo dhali cwan jeṯkum ’kokina iss ’kwanimpa ikwara i’ce’dka ’kume’d mo. Dhali uni thumki gu’b burrinyem buni mo e yan yi’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Arisa ŋul’kup̱ ’kwani ma Israyiil uni iikin mo ’peni Pa Iliim dhali p̱u’dkin mo e mom bwaasho jin yuḵu gway ka Sinaa/ mo a’di jin diki’d mo em bwaman gi Pa Iliim dhali Pa Sinaa/ mo. A’di ta’da cim ma ’kume’d i ’ce’dka mudhe’d ka ppee jin ’kon ma p̱o/ i su/ mo i’ko’di monycum buni ’peni Bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Dhali e mombwaasho tani uni miikina gumgum ap̱owa Musa dhala Haruun mo. ");
INSERT INTO udu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Dhali uni oki uni gwo mo ki: Midi ’taki ’bor ki aman mina wuyu/ mo e me’d gi TAP̱A e Bampa/ Masir mo. E mun tani aman misha ’ko a’cesh dhali ’ka shum mo dhali shwa aris to gun o am bwa i kap̱ mo. Hili um bala suski aman ka pije/ mo e mom bwaasho mo i ’kosha tul ’kup̱ kwani ’baar mo ki ṯe/ mo ba/. ");
INSERT INTO udu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Dhali yan’ko’d TAP̱A oki’da Musa gwo mo ki: Aha/ mina rasku/ tonṯe/ ’peni momis me’da sho’k mo gom um mo. Dhali ’kwani mini ii ka pije/ isa yempa/ mo dhali tul tonṯe/ is mo gom jasa cima ’de/ c̱aan mo ki aha/ mina nyo/ uni mo waḵki/ uni mini ii e gwoŋḵan pem walla yisa mo. ");
INSERT INTO udu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ka cim pe’de/ mo tani uni mini ḵal tonṯe/ ka ’buḵum ’ban mo dhali thoson a’di mo. ");
INSERT INTO udu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Wakan aMusa dhala Haruun ṯorkina ris ’kwani ma Israyiil gwo mo ki: Ki mo midi ta mom’pimpili/ mo tani um mini mish gwo ’ban ki TAP̱A a’di suski um ka pije/ mo ’peni Pa Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Dhali ki mon’thamo/ um mini p̱ar monyca gi TAP̱A e mo haali/ a’di ciḵki’da gumgum bum ap̱o/ a’di mo. Haali/ aman tana ija mo, jin miikina uma gumgum ap̱o/ aman kan mo? ");
INSERT INTO udu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Dhala Musa oki gwo mo ki: Um mini mish ki a’di ta TAP̱A jin c̱i ki um shum mmo’ka mom’pimpili/ mo dhali maaŋḵuthu’d mmoshwa mon’thamo/ mo haali/ TAP̱A ciḵki’da gumgum bum mo ap̱o/ a’di mo. Aman tana ija sa/? Mo ma gumgum bum di’d ap̱o/ aman yisa hili ap̱o/ TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Dhali a Musa oki’da Haruun gwo mo ki: Oyi arisa ŋul’kup̱ ’kwani ma Israyiil gwo mo ki: Iiyu/ ibwambori TAP̱A mo haali/ a’di ciḵki’da gumgum bum mo. ");
INSERT INTO udu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Dhali me’d jin ṯorkin ma Haruun aŋul’kup̱ ’kwani ma Israyiil gwo mo tani uni hilki mo mo ’kup̱ ki mom bwaasho mo dhali monyca gi TAP̱A a’di piki’d mo eya raḵ mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Dhali TAP̱A oki’da Musa gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Aha/ ciḵkina gumgum gi ’kwani ma Israyiil mo. Ṯori uni gwo mo ki: Mom’pen ḵaskum mo tani um mini ’ka shum mo, dhali mon’thamo/ mo tani um mini shwa maa i kap̱ mo. Dhali yan’ko’d mo tani um mini mish mo mo ki aha/ tana TAP̱A Arumgimis bum mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ki mo ta mom’pimpili/ mo tani ḵuskun ṯẖa’thkin ka ris mo dhali kuma ’cesh c̱aan ’baar mo. Dhali mon’thamo/ jap̱e/ ’kaka’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Dhali ki jap̱e/ birki is mo tani yan’ko’d bunya jin p̱o’dap̱o’d diki’d mo eya p̱o/a ’cesh gi mom bwaasho mo me’da ḵwarma’c to mo jin wana e ka ḵomo/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ki ’kwani ma Israyiil p̱arki a’di e mo tani uni oki gwo ka rem ’kup̱ mo ki: Atinta a’di a’dan mo? Haali/ uni ’koki mish a’di gi wakan mo. Dhala Musa oki uni gwo mo ki: A’di ta tonṯe/ jin c̱ikina TAP̱A um mo mmoshwa mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yansan a’di ta gwo jin ḵankina TAP̱A mo ki: Tuli tonṯe/ is mo um ’baar ka ’deṯe/ ’deṯe/ mo ki nyanye/ me’d jin mina umi ŋap̱ a’di mo. Um mini bar a’di ka balapip̱ isu/ mo isi me’da ris ’kwani gi gu’b pini mo. ");
INSERT INTO udu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Dhali ’kwani ma Israyiil miiki a’di wakan mo, uni tulki uni is mo. Kun tiya tulki is ki nyanye/ mo dhali kun tiya tulki is ki gwa’d gwa’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Hili ki uni barki a’di bwa mo tani a’di jin tul kum piti is ki nyanye/ mo tani a’di be i ’kosh jwa ’peni ji gi ŋap̱u mmodiki ur ’kup̱ mo. Dhali a’di jin tulki is ki gwa’d gwa’d mo tani a’di yisa hara toŋ kamuwa. Aris uni tulki uni is mo isi me’d jin mina uni i shwa a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Dhali aMusa oki uni gwo mo ki: Wathiŋ kamu/ yisa di’da jin midi boc̱ a’di itagi mon’thamo/ mo. ");
INSERT INTO udu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Hili unin tiya ciḵ gwo ’pena Musa yisa. Kun tiya boc̱ki ’bana tiya i tagi mon’thamo/ mo dhali a’di shwakin ma yish mo dhali c̱a’b ki bul bul mo, dhali aMusa shwa’da nyor ap̱o/ uni mo be, ");
INSERT INTO udu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mon’thamo/ isa yempa/ uni tulki uni is mo aris uni ka ’deṯe/ ’deṯe/ me’d isi ji gi mina uni shwa a’di mo. Hili ka tente/ caki’d ka nyor piti ki ’ba’th ’ba’th mo tani uni gun boc̱kona ’cesh ṯo’dkin mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ka cim pe’de/ mo tani uni tulki a’di is ki nyanye/ me’di su/ me’d tonṯe/ mo ka balapip̱i i doŋon gom uni ka ’deṯe/ ’deṯe/ mo. Dhali aris tap̱a ka ŋul ’kup̱ p̱u’dkin mo dhali ṯor ka Musa gwo mo. ");
INSERT INTO udu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","A’di oki uni gwo mo ki: Yansan a’di i ta gwo jin ḵankina TAP̱A wakan mo ki: Ka’thamo/ a’di ta’da tee jin minu dosh shoka ’cesh mo mmosi/is mo jin ḵogu gom TAP̱A mo. ’Thoḵi to jin ŋap̱a umi ’thoḵ mo dhali shuni to gun ŋap̱a umi shun mo. Dhali aris uni gun urki ’kup̱ mo tani thoson ki uni mo ki uni minu dhuku/ mo ntaga ’thamo/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Wakan uni thosonki uni mo ntagi mon’thamo/ mo me’d gwo jin ḵankin ma Musa uni mo. Dhali uni ’koki bul mo mo dhali ayisha kamu/ yisa di’di e uni mowaa. ");
INSERT INTO udu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa oki gwo mo ki: Shwayi a’di shwane/ mo ma, haali/ shwane/ a’di i ta’da cim ma pesu/ jin sinu is jin ta’da cim jin c̱inu ki TAP̱A mo. Shwane/ um yisa mini gam tonṯeŋ kamu/ apije/ mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Goma cim pe’de/ mo tani um mini tul uni is mo hili ka cima pesu/ mo tani a’di jin ta’da cim mosi/is mo, um yisa mini gam tonṯeŋ kamu/ yisa mowa. ");
INSERT INTO udu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ka cima pesu/ mo tani ’kwanin tiya uni iikin ka pije/ mo mmotul tonṯe/ is mo hili uni gam toŋ kamuwa? ");
INSERT INTO udu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yan’ko’d TAP̱A oki’da Musa gwo mo ki: Me’d e kata ushkina um gwoŋḵan pem e mo ’peni gwo jin c̱ika um ki ’ce’de/ ’ce’de/ mo? ");
INSERT INTO udu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kayi gwo e ki TAP̱A c̱iki uma cim gi mosi/is mo dhali gom kan mo tani ka cim pe’de/ mo aha/ c̱ikina um tonṯe/ goma cimi su/ mo ba/. Dhalka ris ’kwani ka ’deṯe/ ’deṯe/ ’kon e mom buni mo. Dhalku/ ki dhal wathin ’de/ bway mo mmoya ka pije/ mo ’peni mom piti ka cima pesu/ mo. ");
INSERT INTO udu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Wakan ’kwani si/ki is mo ka cima pesu/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Wakan ’kwani ma Israyiil yuḵki a’di gway mo ka manna mo. A’di wana e ki emen to jin miinu a’tash dhali ta gi kush mo. Dhali ’kuny piti waka biskwiita p̱o’d ’ban jin miinu ka yina dham mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Dhali aMusa oki gwo mo ki: TAP̱A ḵanki ana mmodhuwa mannan tiya gom emen bana jin mina uni mish tonṯe/ ’peni ji gi c̱ikina a’di ana mmoshwa e mombwaasho mo me’d jin suskina a’di ana ka pije/ mo ’peni Pa Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Dhali aMusa oki’da Haruun gwo mo ki: Buthi dhur mo dhali ’thuṯẖa manna jin baru ka balapip̱ i bwaman mo. Dhali kar ki a’di ibwambor gi TAP̱A mo ki a’di minu kar ki tur mo gom emen bana mo. ");
INSERT INTO udu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Me’d gwo jin ḵankina TAP̱A aMusa mo tani wakan aHaruun karki’da manna e mo jin mina a’di di ki sule/ mo ibwambora sanduuḵ jin dina gwoŋḵan jin ṯenu mo be. ");
INSERT INTO udu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Dhali ’kwani ma Israyiil uni shwakina manna ki yili issu/ mo ntagi uni p̱u’dkin mo e bampaŋ Kanaan mo dhali ’ko mo. ");
INSERT INTO udu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Tom bar yan wana e ka balapip̱ iss ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Arisa ŋul’kup̱ ’kwani ma Israyiil ’baar mo uni joc̱kin mo ’peni mombwaasho jin yuḵu gway ka Siin mo dhali joc̱kon e mon tiya ka ris mo isi me’d gwoŋḵan gi TAP̱A mo. Dhali uni ki thum moŋ’kom buni e Pan Rep̱idiim mo hili yi’deŋ kamu/ yisa di’da jin mina ’kwani i p̱i mo. ");
INSERT INTO udu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Gom gwo gi wakan mo tani ’kwani miikina gumgum ap̱owa Musa o ki: C̱i am yi’de/, aman ki p̱i mo ma. Dhala Musa thoḵki uni gwo mo ki: Atinta miikina uma gumgum ap̱o/ aha/ kan mo? Atinta si’da/ pala um TAP̱A kan? ");
INSERT INTO udu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Hili ’kwani ḵu’thkina ’kus guŋkuru/ mo imun gom yi’de/ mo dhali ’kwani miikina gumgum ap̱o/ aMusa naskina/ mo dhali o gwo mo ki: Atinta i susina /e aman ka pije/ mo ’peni Pa Masir mo mmo’kosh aman dhali uc̱im bam dhali to em bam jwa mo ki yi’dem bu’th kan mo? ");
INSERT INTO udu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Wakana Musa ’thoki TAP̱A mo ki: Atinta i miga/ mii mo gom ’kwani gwansan mo? Uni ’dishkina ’twa/ mo mmo’kosh aha/ ki wosh mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Dhali TAP̱A oki’da Musa gwo mo ki: Yayi ibwambori ’kwani mo. Susi ’kwaniŋ gwanyjwaha/ ma Israyiila tiya nyaḵki /e mo dhali guyi cwam pini i me’d mo a’di jin dorkina /e yi’de/ ma Niil mo dhali yaku/ mo. ");
INSERT INTO udu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Aha/ mina dosh ibwambori /e ap̱o/ wosh mo e Wosh Sinaa/ mo. Dhali /e mini dor wosh mo dhali yi’de/ midi gac̱u/ ka pije/ mo ’peni a’di mo jin mina ’kwani i p̱i a’di mo. Dhali aMusa miiki a’di wakan mo e jis e gi gwanyjwahaŋ ’kwani ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Dhali a’di yuḵki yansan gway ka Massa mo dhala Miiriba mo haali/ ’kwani ma Israyiil miikina gumgum mo dhali uni palki TAP̱A mmo/o gwo mo ki: A TAP̱A di’di bwamani ana ’te/ tana walla p̱iyi’d mo? ");
INSERT INTO udu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Yan’ko’d ’kwani Amaliiḵ p̱u’dkin mo dhali as ’kwani ma Israyiili cine/ mo e Pa Rep̱idiim mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Dhali aMusa oki’da Jeshuwa gwo mo ki: Kwanyi ’kwanim bana mo. Dhali iiyi um ka pije/ mo mmo/as ’kwani Amaliiḵ nycine/ mo. Ka’thamo/ aha/ mina dosh i ’kup̱an wosh mo ki cwa ma Arumgimis e me’d pem mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Wakana Jeshuwa miiki’d mo me’d jin ḵankin ma Musa a’di gwo mo. Dhali uni as ki ’kwani Amaliiḵ nycine/ mo. Dhala Musa dhala Haruun dhala Huur iikin ka gagamis i ’kup̱an wosh mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Me’d jin ’de’kkin ma Musa me’di mis mo tani Israyiil p̱iki mii e mo. Dhali me’d jin thulkina a’di me’d piti ka ’cesh mo tani ’kwani Amaliiḵ uni p̱iki mii e mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Hili me’d ma Musa i wuki e mo. Wakan uni ḵalki wosh mo gom a’di mmoc̱a’b ap̱o/ a’di mo. Dhali aHaruun dhala Huur bu’thki me’d piti mo, jan ṯal ’deŋ kamu/ ki ’bana ’deŋ kamu/ mo dhali jaŋ kamu/ ka ’bana kamu/ mo. Wakan me’d piti ’bi’thkina is mo ntagi mo jin yakin ma tente/ jis mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ki mii yan mo tani Jeshuwa dorki ’kwani Amaliik ’twa/a ’cesh mo ki gandala turga/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Dhali TAP̱A oki’da Musa gwo mo ki: ’Kwari gwo yansan mo ki gwo jin minu ka e mo e bwaman ma warkaŋ ’kuc̱ mo. Dhali bahi gwo yansan e bwany ’ce ma Jeshuwa mo haali/ aha/ mina ’ce’d ’Kwani Amaliiḵ sho’k ka kuluny mo be. ");
INSERT INTO udu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Dhali a Musa nyaŋki’da gwaṯa/ mo dhali yuḵ a’di gway mo ki: TAP̱A a’di i ta’da berḵam pem mo. ");
INSERT INTO udu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","A’di o gwo mo ki: ’Deka berkam piti isi mis mo. TAP̱A midi as ’kwani Amaliiḵ nycine/ mo ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Rau/iil jin ta’da mar ma Musa ta’da gasiis gi Pam Midyaan mo. A’di ciḵki gwo goma ris to ’baar mo jin miikin ma Arumgimis goma Musa mo dhali ’kwanim piti ka Israyiil mo. Dhali a’di ciḵki gwo ki TAP̱A suski ’Kwani Israyiil ka pije/ ’peni Bampa/ Masir mo. ");
INSERT INTO udu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Dhala Rau/iil jin ta’da mar ma Musa mo a’di suski’da Sippuura mo a’di jin ta asha Musa mo i’ko’da Musa hashki’da yim mo nyaḵki uc̱iŋ gwaṯẖ ma yim su/ mo ’peni a’di mo, ");
INSERT INTO udu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","dhali uc̱iŋ gwaṯẖ ma yim su/ mo. Jan ṯal ’de/ yuḵkunu gway mo ka Jirshuum mo, haali/ aMusa oki gwo mo ki: Aha/ yakina yany c̱a/ mo e bampa/ ’kwanin tiya mo. ");
INSERT INTO udu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Dhali gway gi jaŋ kamu/ mo tani a’di i ta’da Iliyaasir haali/ a’di oki gwo mo ki: Arumgimis ma babam pem mo tani a’di ta’da manwoṯẖ aha/ mo dhali woṯẖ aha/ mo ’peni gandal ma P̱irawn mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Dhala Rau/iil p̱u’dki’d mo nyaḵki asha Musa dhali iya/ i su/ mo e mo jin bu’thkin ma Musa mondi me’d e mombwaasho e wosha turga/ ma Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Dhali a’di hashki’da Musa gwo mo ki: Amar pini ka Rau/iil a’di yayi’d nyaḵki ashin mo dhali uc̱iŋ gwaṯẖ ma yimi su/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Wakana Musa yaki’d mo dhali gama mar piti ’kup̱ mo dhali ’tuḵ a’di i is mo dhali p̱i a’di ’twa/ mo. Dhali uni theki me’di monṯal ’de/ mo dhali uni iiki bway gu’b burrinye/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Dhali yan’ko’da Musa ṯorki’da mar piti aris to ’baar mo jin miikina TAP̱A a P̱irawn mo dhali aris ’kwani Pam Masir i ’baar mo gom gway ma Israyiil mo. Dhali a’di ṯorki’da ris ton diṯga/ kun p̱u’dkina p̱o/ uni i bway mo dhali mii jin woṯẖkina TAP̱A uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Dhala Rau/iil ’kunykina bwa mo gom tom ’borga/ jin miikina TAP̱A goma Israyiil mo e mii jin miikina a’di mmo’cuḵ uni ka pije/ ’peni me’d gi ’kwani Pam Masir mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Dhala Rau/iil oki gwo mo ki: Mom’bor mii gom TAP̱A mo a’di jin ’cuḵki um ka pije/ mo ’peni me’d gi ’kwani Pam Masir mo dhali ’peni me’d ma P̱irawn mo. Dhali mom’bor mii gom TAP̱A jin ’cuḵki ’kwani ’peni mii c̱iŋkinam buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Shwane/ aha/ misha ki TAP̱A a’di i eḵki’d mo mmobola risa ruma tiya e mo haali/ a’di ’cuḵki ’kwani mo ’peni bwaŋ ’kwariny me’d gi ’kwani Pam Masir mo ki uni ṯu/ulki uni ki mii maṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Dhala Rau/iil a’di jin ta’da mar ma Musa mo a’di c̱iki to jin c̱inu ki me’d jin ’thanu o’d dhali miiya Arumgimis abasa ’cesh mo. Dhala Haruun dhali aris ’kwaniŋ gwanyjwaha/ ma Israyiil uni p̱u’dkin mo dhali shwa tonṯe/ jin karu ki she/ goma Arumgimis mo nyaḵka mar ma Musa mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Dhali ka’thamo/ ki eŋ kamu/ mo tani aMusa c̱a’bki’d mo dhali dwall ’kwani gwo mo. Dhali ’kwani doshkin mo mmo’kama Musa is ki deḵ mo ’peni mon’thamo/ ntagi mom’pimpili/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ka mar ma Musa p̱arki’da ris to gwansan e mo kun miikina a’di mo gom ’kwani mo tani a’di oki gwo mo ki: Atinta a’dan jin miikina /e ’kwani mo? Atinta dina /e /e ’de/ kan dhali aris ’kwani doshkini ’kam /e is mo ’peni mon’thamo/ ntagi mom’pimpili/ mo? ");
INSERT INTO udu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Dhali a Musa thoḵki’da mar piti gwo mo ki: Haali/ ’kwani p̱u’dkini aha/ mo mmotheke’th gwo mo goma Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ki uni su’kkin ki gwo mo tani yan’ko’d uni ki iiyu/ i aha/ mo dhali aha/ ki mish gwo pwaḵ bwa bese/ i bwamani uni gun su’kkin ki gwo mo. Dhali aha/ ki dhu uni mo mmomish gwoŋḵan ma Arumgimis kun ’kwarkunu mo dhali gwoŋḵan piti kun c̱inu mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mar ma Musa oki a’di gwo mo ki: To jin miikina /e yisa ’boro’da. ");
INSERT INTO udu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","/E dhali aris ’kwani gun iiyini /e mo tani um mina isi wu e mo, haali/ to diṯadiṯ gom /e mo. /E yisa mini mish ṯel shoka ’cesh /e ’de/ mo yisa. ");
INSERT INTO udu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ciḵi gwo gi ’twam pem mo. Aha/ mina logom /e ki gwo mo dhali Arumgimis midi di nyaḵki /e mo. A’di ’boro’d gom /e ki dosh i bwaman ’kwani dhali Arumgimis mo dhali ḵala ris tom buni kun ṯoci uni ’kus eya Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Dhali /e mini ṯor uni gwoŋḵan mo dhali gwo gom moŋ’ko mo. Dhali dhuyi uni mo mmomish bway mo a’di jin mina uni mish ii nycine/ mo gom to jin mina uni i mii mii mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Hili kwanyi ’kwani kun mishi mii mo si’da/ ’peni aris ’kwani mo, dhali dhu uni ki jwaha/ ap̱o/ ’kwani alip̱ mo dhali ap̱o/ iss ’kwanimpa ka mudhe’d mo dhali ap̱o/ iss ’kwanimpa isu/ i’ce’dka ’kume’d mo dhali ap̱o/ ’kwani ka ’kume’d mo be. Uni mini mii ta ’kwani gun ḵo/on Arumgimis mo, ’kwaniŋgwaṯẖ kun dhelel ma du mo dhali uni kun shi/ki mii kun wanu ’kwani is ki ton tiya i e mo. ");
INSERT INTO udu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Dhali dhalki uni a’di i dwall ’kwani gwo isa yempa/ mo. Eya ris dhan mii kun p̱iki e mo tani uni mini mishi uni ḵalu i /e mo. Hili ushi mii kun p̱o’da she/ mo tani uni a’di mini pwaḵ uni bwa mo uni ki is buni uni ’cena mo. Wakan a’di i mina to i ’dish mii ki ’dish gom /e mo dhali uni mini mish ton diṯin nyaḵ ḵal ki /e mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Waḵki/ /e mini mii mii yan mo tani dhali Arumgimis ḵanki /e wakan mo tani yan’ko’d /e mini mish ’dim ’kup̱ mo. Dhali aris ’kwani gwansan si’da/ mini ii mom buni ki moŋḵu’th is mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Gom gwo gi wakan mo tani aMusa a’di c̱iki’da hirdhe/ ki gwo ma mar piti mo dhali miiya ris to gwansani ’baar mo jin okina a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","AMusa a’di kwanyki ’kwaniŋ gwaṯẖ kun mishki mii mo ’peni aris ’kwani ma Israyiil mo dhali dhuki uni mmota tap̱a ap̱o/i ’kwani mo, i tap̱a kun ji ’kwani alip̱ mo dhali ’kwani iss ’kwanimpa i mudhe’d mo dhali a/iss ’kwanimpa isu/ i ’ce’dka ’kume’d mo dhali imandwall gwo i ’kume’d mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Dhali uni dwallki ’kwani gwo isa yempa/ mo. Gwo kun ’bitha’bi’th mo tani uni ḵalki a’di ka Musa mo, hili ushi mii kun p̱o’da she/ mo tani misha uni dwall ki is buni uni ’cena mo be. ");
INSERT INTO udu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Dhali yan’ko’da Musa dhalki’da mar piti bway mo mmoya mo dhali a’di yaki’d mo ki bway bampam piti mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","’Kwani ma Israyiil iikin ka pije/ mo ’peni Pa Rep̱idiim mo. Dhali ka cima ’de/ ka ppee ’kup̱i kwara ’ko’di uni iikin mo ’peni Pa Masir mo tani uni p̱u’dkin mo e mombwaasho ma Sinaa/ mo be. Dhali imun mo tani Israyiil bu’thki moŋ’ko me’d i bum’pen i wosha turga/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Dhali aMusa seki mis wosh mmogam Arumgimis ’kup̱ mo. Dhali TAP̱A yuḵki a’di mo ’peni wosha turga/ mo dhali o gwo mo ki: Yase/ i mina /e i ṯor ’kwani ma Israyiil gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Um mishki to kun miikika/ ’kwani Pa Masir me’dyin mo dhali bahili aha/ borkina um ka bi ma wulu/ mo dhali susu um e aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Dhali waḵki/ um mini ha gwo gi ’twam pem e mo dhali ṯel gwom pem jin gamu/ me’d mo tani um mini ta ’kwani gun kwanyka/ ka me’d pem kun miga/ nyuny mo e bwaman ma aris ’kwani mo haali/ aris mony’ceshi ’baar mo tani uni ta kum pem mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Dhali um mini ta kum pem gun c̱inu aha/ aha/ ’de/ mo. Dhali um mini dhu miim pem me’d igasiis mo. Gwo gwansan a’di i mina /e i ṯor ’kwani ma Israyiil mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Wakan aMusa thulki’d mo dhali yuḵki gwanyjwahaŋ ’kwani mo dhali ṯor uni aris gwo gwansani ’baar mo uni gun ḵankina TAP̱A a’di mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Dhali aris ’kwani ’baar mo thoḵki gwo imonṯal ’de/ mo dhali oki gwo mo ki: Aris gwo gwansan kun okina TAP̱A mo tani mina amani mii mo. Dhali aMusa doḵki gwoŋ ’kwani ka nyaŋ’ko’d bway TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Dhali TAP̱A oki’da Musa gwo mo ki: Aha/ mina yaku/ i /e ka raḵ jin dhinya/ e ki dhiny mo ki ’kwani mini mish ki aha/ ṯora ṯor nyaḵki /e mo. Dhali uni si’da/ mini gam /e gwo is ki sule/ sule/ mo. Dhali yan’ko’d aMusa ṯorki gwoŋ ’kwani e TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Dhali TAP̱A oki’da Musa gwo mo ki: Yaku/ i ’kwani mo dhali dhu uni ki she/ shwane/ mo dhali ka’thamo/ mo. Dhali dhalki uni wusi burrinyem buni mo ");
INSERT INTO udu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","dhali thosoni is mo goma ’thamo/ c̱an mo. Haali/ ka’thamo/ c̱an mo tani TAP̱A a’di midi i thulu ka ’cesh mo ap̱o/ ’Kuwosh Sinaa/ mo e jis e gi ’kwani ’baar mo. ");
INSERT INTO udu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Dhali /e mini kar gwayu/ ka kukul is mo ki ’ko’d gwar wosh jin mina ’kwani ’koki ’ciṯẖ a’di mo. Dhali oyi gwo mo ki: Hili ki ’bore/ ki um ’koki se ’ku wosh mo walla ’dish a’di is mo. Ba a’di yin jin midi ta Wosh Sinaa/ is ki me’d mo tani minu ’kosh jwa mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Me’da kamu/ yisa midi ta a’di is ki me’d yisa mo hili a’di minu ’kosh ki wosh mo walla minu shin ka thop̱a mo. Waḵki/ ta to e walla wathimpa mo tani a’di midi mish di ki e yisa. Ka poome/ midi ko mo tani yan’ko’d uni mini iiku/ ’kup̱ ki wosh mo. ");
INSERT INTO udu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Wakan aMusa yaki’d ka ’cesh mo ’peni ’kuwosha turga/ mo e ’kwani mo dhali ṯor ’kwani gwo mmothoson is mmoluŋ mo. Dhali uni wuski burrinyem buni mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Dhali a’di oki ’kwani gwo mo ki: Thosoni is mo goma ’thamo/ c̱an mo. Dhalku/ up̱ ki mii ’dish is mo. ");
INSERT INTO udu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mon’thamo/ jin ’kon ma p̱o/i kwara mo tani kon dor ma sho’k diki’d mo dhala wara sho’k mo dhali araḵ jin ’cethe’da ’tum ap̱o/ ’kuwosha turga/ mo. Dhali ko ma poome/ dhi’thki’d ki nyanye/ mo. Wakan aris ’kwani kun ’kokin e mo jin butha uni moŋ’ko me’d mo tani uni dekin ki bir bir mo. ");
INSERT INTO udu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Dhali yan’ko’da Musa suski ’kwani ka pije/ mo ’peni moŋ’kom buni mmogama Arumgimis ’kup̱ mo. Dhali uni doshkin mo e bum’pen wosha turga/ mo. ");
INSERT INTO udu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Dhali ’kuwosh Sinaa/ ka kuluny a’di koṯẖkunu is ka ku’d mo haali/ TAP̱A i thulki’di a’di ki o’d mo. Dhali aku’d piti a’di yaki mis mo me’d ji ma p̱urun mo. Dhali wosha turga/ kakulu mo tani a’di yiḵinki is kagahara ki nyanye/ mo. ");
INSERT INTO udu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dhali ki ko ma poome/ gwoki’d ki nyanye/ dhali ki nyanye/ mo tani aMusa ṯorki’da ṯor mo dhali Arumgimis thoḵki a’di gwo ki ’twa/ jin wa ki kon dor ma sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Dhali TAP̱A thulki’d ka ’cesh eya liman wosh Sinaa/ mo dhali yuḵa Musa bwaya liman wosh mo. Dhala Musa a’di i seki ’kuwosh mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Dhali TAP̱A oki’da Musa gwo mo ki: Thulku/ ka ’ceshi ’kwani dhali rumi ’kwani ki gwo mo isi ciki/ ki uni mini ’koki ’ceṯẖku/ ki tur mo mmohil aha/ mo ka ’thime/ mo. Haali/ waḵki/ miinu kan tani uni ka ris ka ris mini wu mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dhali si’da/ dhalki igasiis uni kun iiyin ki ’dishe/ e TAP̱A dhagam is buni mo isi ciki/ ki TAP̱A midi diki dor uni mo. ");
INSERT INTO udu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Dhali aMusa oki TAP̱A gwo mo ki: ’Kwani mini molku/ seku/ bway ’kuwosh Sinaa/ mo haali/ /e ki is pini ḵanki aman gwo mo mmo/o ki: Kari gwayu/ mo mmo’kam ’kuwosha turga/ is mo dhali dhagami a’di mo. ");
INSERT INTO udu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Dhali TAP̱A oki a’di gwo mo ki: Yaku/ ka ’cesh mo dhali susa Haruun nyaḵki /e bway aha/ mo. Hili dhalku/ ki dhal igasiis bway dhali aris ’kwani mo mmo’ciṯẖ gwayu mo mmo/ii i aha/ mo haali/ waḵki/ miina uni kan mo tani aha/ mina dor uni mo be. ");
INSERT INTO udu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Wakan aMusa a’di i yaki’d ka ’cesh mo e ’kwani mo dhali ṯorki uni gwo jin okina TAP̱A mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Arumgimis oki’da ris gwo gwansani ’baar mo mmo/o ki: ");
INSERT INTO udu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Aha/ tana TAP̱A Arumgimis pini jin suski /e ka pije/ mo ’peni Pa Masir mo ’peni mo jin miikunu /e ki miiny c̱iŋkina/ mo. ");
INSERT INTO udu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","/E mini mii dhalku/ ki mii luŋa ruma tiya mo. /E mini mii luŋ jasi aha/ ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","/E mini mii dhalku/ to ki mii uḵ mo jin mina /e i luŋ mo, a’di jin wana e ki toŋ kamu/ jin di’d e momis walla jin di’di mony’cesh walla jin di’d e yi’de/ e bwaŋ’kwariny mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","/E mini mii dhalku/ ki mii luŋ to/uḵa kamu/ mo walla mii uni to mo. Haali/ aha/ tana TAP̱A Arumgimis pini mo. Aha/ yisa mina dhal /e bway mmoluŋa ruma kamu/ mo. Aha/ dora ’kwani gun shi/aa/ i e dhali gun ush gwom pem mo. Dhali aha/ dora emen buni ka lonthoṯẖ i taga p̱o/ doŋon mo. ");
INSERT INTO udu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Hili aha/ ṯora mo/en jin ṯelu sho’k mo gom emena alip̱ kun enki aha/ mo dhali dhu gwoŋḵan pem mo. ");
INSERT INTO udu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","/E mini mii dhalku/ ki yer gway gi TAP̱A Arumgimis pini ka wuny is ka ṯor mo haali/ TAP̱A midi diki dhal a’di jin yeri gway piti ka ṯor mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kayi acima pesu/ e mo mmokar a’di ki she/ ki dhelel dhelel mo. ");
INSERT INTO udu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","/E ta ga cimi pe’de/ mo mmomiiya risa ṯu’c pini ’baar mo. ");
INSERT INTO udu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Hili acim ma pesu/ mo tani a’di ta’da cim gi mo si/is gom aha/ mo be. E a’di mo tani /e mini mii dhalka ṯu’c pini mo, /e dhali ya/m pini mo dhali ’bwa/m pini mo walla c̱iŋkina/ wathiŋ gwaṯẖ jin mii’da ṯu’c pini mo dhali c̱iŋkina/ nyara/ jin mii’da ṯu’c pini mo dhali bip̱ pini mo dhali wathi/ jin yayi yilkina/ e pum mo. ");
INSERT INTO udu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Haali/ acim pe’de/ mo tani aha/ jin tana TAP̱A uḵkina momis mo dhali mony’cesh mo dhali ḵumma/ yi’de/ mo dhali aris to kun ’kokin e bwaman uni mo. Bahili ka cim ma pesu/ mo aha/ sikina is mo. Gom gwo gi wakan mo tani aha/ ’borkina cim ma pesu/ mii mo dhali kar a’di ki ji gi ḵogu mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Taḵi cim dhali kwan mo ma, ki yil pini jin dina /e ki e mo mini ta ris mo e mo jin min ma Arumimisi c̱iki /e mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","/E mini mii dhalka mee ki ’kosh mo. ");
INSERT INTO udu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","/E mini mii dhalku/ miinyc̱al ki mii mii mo. ");
INSERT INTO udu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","/E mini mii dhalku/ to ki ḵwal mo. ");
INSERT INTO udu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","/E mini mii dhalka ṯor ki ḵal ap̱o/ wathiŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","/E mini mii dhalku/ bwa ki mii ’thoṯẖ gom gu’b gi wathiŋ kamu/ mo. /E mini mii dhalku/ bwa ki ’thoṯẖ goma ’bom gi wathiŋ kamu/ mo walla gom wathi/ jin ta c̱iŋkinam piti mo walla nyarany c̱iŋkinam piti mo walla mor bip̱ piti mo walla thuluny piti mo walla ton ṯal ’deŋ kamu/ jin di’d e gu’b gi wathiŋ kamu/ mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Dhali ki ’kwani nyiṯẖ mondor ma sho’k mo dhala wara sho’k mo dhali ko ma poome/ mo dhali wosha turga/ mmoyakina a’di aku’d mo tani ’kwani ḵo/ki is mo dhali den ki bir bir mo dhali uni doshkin isa dhana mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Dhali uni ki owa Musa gwo mo ki: /E a’di i mini wal ’twa/ nyaḵki aman mo dhali aman mina ciḵ gwo mo. Hili aman ḵo/a is gom waḵka Arumgimis a’di midi wal ’twa/ i nyaḵki aman mo tani aman mina wu mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Dhali aMusa oki ’kwani gwo mo ki: Dhalki is ki ḵo/ mo ma, haali/ Arumgimis p̱u’dki’d mo mmopal um mo dhali woṯẖ um mmoha gwom piti e mo ki um mini ’koki mii miinthus mo be ");
INSERT INTO udu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Hili ’kwani doshkin isa dhanaŋ gana/ mo imun mo. Jasa Musa a’di ’de/ ’dishki’da raḵa dhiny e is mo e mo jin dikin ma Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Dhali TAP̱A oki’da Musa gwo mo ki: Yase a’di i mina /e i o ’kwani ma Israyiil mo ki: Um mishkin ki is bum ki aha/ ṯorkina aṯor nyaḵki um ’peni momis mo. ");
INSERT INTO udu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Um mini mii dhalka ruma kamu/ ki mii uḵ ’peni ’dolkon kush walla ’dolkon gana/ mo mmokar ka p̱ar ki aha/ mo, jin mina umi luŋ mo. ");
INSERT INTO udu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Agwaṯa/ ma ’cesh a’di i mina umi uḵ mo mmomii aha/ abasi cine/ mo ’peni ḵa’bal pini dhali bip̱ pini mo mmota to jin c̱inu ki me’d goma Arumgimis mo. Kun tiya minu c̱i mmo’tha o’d ka kuluny dhali kun tiya minu c̱i gom moŋḵu’th is goma Arumgimis mo. E mo guni ’baar mo jin raḵ gway pem kakunu e mo tani aha/ mina p̱u’dku/ i um mo dhali ’bor um mii mo be. ");
INSERT INTO udu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Dhali ki um mini uḵa gwaṯa/ ’peni wosh mo tani um mini mii dhalki a’di ki uḵ ’peni wosh jin paṯẖu ki ’doro/ mo haali/ waḵki/ um mini paṯẖ a’di ki ’doro/ mo tani a’di yisa midi ’kosh jwa mo yisa gom to jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Dhali um mini ’koki seya bor ki mis gi ushi mon tan eya gwaṯam pem mo haali/ um mini ṯora yir buŋgwar is bum eya tente/ mo be.");
INSERT INTO udu_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Mom’bor mii gom wathi/ a’di jin diki ya e bway jin logoma ’kwanin thus gwo mo, walla dosh e bway gi imanmii miinthus mo, walla c̱a’b mo e moŋ’ko gi uni gun ’theḵ shushi mis mo, ");
INSERT INTO udu_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","hili mom’bor bwam piti mo tani di’d e gwoŋḵan gi Tap̱a Arumgimis jin c̱inu mo, dhali e gwoŋḵan piti jin c̱inu mo tani a’di ki c̱i is ki a’di montee mo dhali mon’thiny mo be. ");
INSERT INTO udu_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","A’di wana e ki cwa jin c̱u’thkunu e shemen yi’de/ jin guski’d mo, a’di jin gwono’dki maman ki yil piti mo, dhali ’cemen piti diki ḵu’th mo. Eya ris to ’baar kun miina a’di mo tani a’di rusa/ rus mo. ");
INSERT INTO udu_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Imanmii tonthus mo tani yisa wakana, hili uni wana e ka ’pi’b jin ’dashkina ’tham mo be. ");
INSERT INTO udu_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Wakan imanmii tonthus mo tani mini ’koki dosh mo ka tee gi gwon dwall jin toru gwo ’twa/a ’cesh mo walla imanmii miinthus si’da/ e dhan mo ma tul ’kup̱ gi ’kwani ma ḵar/e mo, ");
INSERT INTO udu_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","haali/ Tap̱a Arumgimis mishki bway gi a’diŋ ḵar/e mo, hili bway gi uni gun mii tonthus mo tani ta mony’ce’d sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Ata miina ’kwani gi kala tiya adulaṯṯ mo, dhali ’kwani gam ’twa/ ’kup̱ ki p̱e’th kan mo? ");
INSERT INTO udu_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Imaliḵ gi ’kwaniny’cesh doshkin ki is buni ki ’dishe/ mo, dhali itap̱a tuli isi monṯal ’de/ mo ap̱o/ Tap̱a dhali ap̱o/ a’din ’de/ jin ’koshkunu ki monyca mo, mmo/o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Dhalki ana ’ce’da mondeḵ buni mo dhali ṯaka nyoḵ buni ’peni ana mo. ");
INSERT INTO udu_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","A’di jin c̱a’bki’d eya ris momis mo tani p̱e’thki’d mo, Tap̱a miiki uni ka mudhiny’cere/ mo. ");
INSERT INTO udu_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Yan’ko’d a’di midi ṯor uni gwo eya nyor piti mo dhali dher uni is bwa ka nyor piti jin c̱ithirac̱ithir mo mmo/o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Aha/ karkina maliḵ pem mo ap̱owa Sihyuun, a’di jin ta wosh pem jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Aha/ mina ṯor gwoŋḵan gi Tap̱a mo: A’di ta gwo jin ona a’di aha/ mo ki: /E ta Ya/m pem mo, shwane/ aha/ dho’thkina /e mo. ");
INSERT INTO udu_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Doṯi aha/ ma, dhali aha/ mina c̱i /eya ris kal gi ’kwaniny’cesh mo mmota mal pini mo, dhali ’pemen gi mony’cesh mo tani uni mini ta kum pini mo. ");
INSERT INTO udu_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","/E mini ’ce’d uni bwa mo ki cwan kol ’kus jin ta toŋḵuthu’d mo, dhali mu/ uni ’twa/a ’cesh mo ka ’ci’cimi’th mo me’d toŋ’kul bwa jin uḵu ’pena je mo. ");
INSERT INTO udu_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Dhali wakan shwane/, ayy imaliḵ, yuḵi is mo ma, muri is mo, ayy um itap̱a gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Miiyi Tap̱a to ki moŋḵo/ is mo dhali ki mondee is mo, ");
INSERT INTO udu_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","p̱iyi sho’k piti ’twa/ mo, isi ciki/ ki a’di midi diki shwaa nyor mo, dhali um minu ’ce’d sho’k ibway mo, haali/ anyor piti ’thakunu hila/ ki jahanne/ mo. Mom’bor mii goma ris uni gun bu’thki mo jin huru jwa e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Ayy Tap̱a, ’kwani kun ta ’kup̱ gi aha/ wana risa! Uni tana ris ka ris kun cuna p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Uni tana ris o gwo gom aha/ mo ki: mowoṯẖa/ kamu/ midi di gom a’di eya Arumgimis yisa. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Hili /e, ayy Tap̱a, itana goŋgoro/ gom aha/ mo, dhali monycam pem mo dhali aman’de’k ’kup̱ pem ki mis mo. ");
INSERT INTO udu_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Aha/ ’thera cuuwa/ ki nyanye/ e Tap̱a mo, dhali a’di thoḵki aha/ ’twa/ ’peni ’kuwosh piti jin ḵogu mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Aha/ isha ’ko’da ’cesh dhali ish e mo. Aha/ mera e doḵ/e mo, haali/ Tap̱a a’di ṯeki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Aha/ dinaki ḵo/ is gom ’kwani kun ’koni alaap̱i ’kume’d mo uni gun doshkin ki is buni ap̱o/ mo mmo’kama ’kam mo. ");
INSERT INTO udu_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Cuyi mis mo ma, ayy Tap̱a. ’Cuḵi aha/ mo ma, ayy Arumgimis pem. Haali/ /e dorkina ris uni gun ta ’kup̱ ki aha/ e peshe/ mo, dhali /e ki ’ce’d she/ gi uni gun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Mo jin ’cuḵuwa ’cuḵ mo tani a’di ta ji gi Tap̱a mo, mom’bor miim pini a’di midi di ap̱o/ ’kwanim pini mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Thoḵi aha/ ’twa/ mo ma ki aha/ yuḵa yuḵ mo, ayy Arumgimis pem jin ta’da ḵar/e mo. /E c̱iki aha/ mo mo ki aha/ dina ka c̱is mo. Miiyi mii ma ’the ap̱o/ aha/ ma, dhali ciḵi mo ma ’thom pem mo. ");
INSERT INTO udu_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ayy ’kwani kakasja imina montaḵ pem jin ’koshu is is ka nyor idi ki mo ma ’the is kan mo? Kakasja imina /e dhal mo/en gi gwo jin di’d bwa ’te/ ’pen mo dhali simm jasi gwo ma ṯor e kan mo? Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Hili mishi gwo ’ban ki Tap̱a a’di dhuki uniŋ gayiin ki she/ mo gom is piti mo. Tap̱a ciḵki aha/ gwo mo ki aha/ gwona ’twa/ e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ka nyor di’d mo tani hili dhalku/ miinthus ki mii mo. Wali ’twa/ ka dum bum mo ap̱owa cim bum mo dhali ’koyi um ki shwamm mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","C̱iyi to kun ’ciṯẖu/ ’kus kun tana ḵar/eŋ gana/ mo dhali dhuyi moŋgam gwo is bum e Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Kwani tana ris kun o gwo mo ki: Ayy, ki ana mina mish tom ’boro’da kamuyi. ’Deki moŋkush gi jis/em pini ap̱o/ aman mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","/E karki moŋkuny bwa ki nyanye/ eya dum pem mo mmobol uni gwansan e mo kun takin gi pos buni dhali yimana mura’th jin ḵa/u ki ŋah ŋah kun ishkin mo. ");
INSERT INTO udu_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","E mo ma ḵu’th is mo tani aha/ mina ish ’ko’da ’cesh mo dhali ish e mo, haali/ /e ’de/ mo tani ayy Tap̱a, kar aha/ mmoc̱a’b ki ’dantar mo. ");
INSERT INTO udu_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","C̱iyi ’cem pini ka ris gwom pem mo ma, ayy Tap̱a, yip̱i /e ’kup̱ mo gom ohon pem jin ohonkika/ mo. ");
INSERT INTO udu_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ciḵi kony cuuwam pem jin gwoka/ mo ma, aMaliḵ pem dhali Arumgimis pem, gom e /e mo tani aha/ ’thona mo. ");
INSERT INTO udu_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Ayy Tap̱a, e mon’thamo/ mo tani /e ciḵki ’twam pem mo, e mon’thamo/ mo tani aha/ ’ciṯẖa to ’kus gom /e mo dhali tima tim mo. ");
INSERT INTO udu_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Haali/ /e diki ta Arumgimis jin ’kunya bwa mo e tonthus jin miikunu mo. tonthus midi diki nyaḵ di ki /e mo. ");
INSERT INTO udu_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Iman’theḵ ’ba/i mis mo mini ’koki doshi bwambori jis/em pini mo, /e shi/kina ris imanmii tonthusi e mo. ");
INSERT INTO udu_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","/E ’ce’dki uni gwansan sho’k mo kun oki gwo ma ṯor mo. Tap̱a shi/i uni gwansani e kun budha ṯe/ jasi goma bas mo dhali ’kwani kun tana he’k e ka he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Hili aha/ ki mo/en pini jin ṯelu sho’k mo jin ishki’d ka enthus mo tani aha/ mina cic̱ gu’b pini mo, dhali aha/ mina luŋa luŋ ka ḵarambuye/ gi gu’b gi mondheleladhelel pini mo ki moŋḵo/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Shuyi aha/ bway mo ma, ayy Tap̱a, e mii ma ḵar/em pini mo haali/ gom ’kup̱ pem tana ris mo, kari bway pini ka ji sho’k mo ibwambori aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Haali/ gwoŋ gana/ yisa di’da e ’twam buni mo, adum buni ’ce’dkunu sho’k mo, ’kus buni wana e ki moŋ’kup̱aje jin ḵa’du ’twa/ mo, dhali uni ko ’kus ka le’d buni mo. ");
INSERT INTO udu_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Dhuyi uni mmoḵal tom buni kun ’ko uni i’ba/ mo, ayy Arumgimis, dhalki uni biṯkin ki gwom buniŋ gana/ gun ’ko uni ibwa mo, haali/ goma dhiŋ gwom buni ka ris mo tani ṯaki uni ka pije/ mo, haali/ uni walkin ki ṯas ṯas ap̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Hili dhalka ris uni gwansan kun huri jwa mo e /e mo tani ’kunya bwa mo. Dhalki uni yuḵ gway ki sule/ gom moŋ’kuny bwa mo, dhali /e a’di imina uni jeṯṯ me’di cine/ mo, ki uni gwansan kun en gway pini mo tani mina bwa i/ii imis gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Haali/ /e ’borki uniŋ ḵar/e mii mo, ayy Tap̱a, /e kumki uni ki mo ma ’them pini me’da goŋgoro/ mo. ");
INSERT INTO udu_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Ayy Tap̱a, dhalku/ ki ḵucur aha/ ka nyor pini mo, walla dor aha/ ka nyor pini jin ’batha’ba’th mo. ");
INSERT INTO udu_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Miiyi mii ma ’the gom aha/ mo, ayy Tap̱a, haali/ aha/ ’dushura ki ’dushur mo. Ayy Tap̱a, wac̱i/ aha/ mo, haali/ arisa simam pem ṯocu bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Aḵashiram pem si’da/ a’di puru/ ki monṯo’c bwa mo. Hili /e, ayy Tap̱a – kakasja sa/? ");
INSERT INTO udu_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Ṯuki mo, ayy Tap̱a, tayi mondiki/em pem is ki me’d mo, ’cuḵi aha/ mo gom gway gi mo/en pini jin ṯelki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Haali/ e mowu mo tani moŋkamu/ yisa di’da jin kanu /e e mo. E mo ma Haawiya mo tani aja si’da/ imidi c̱i /e momaŋ mo? ");
INSERT INTO udu_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Aha/ ’thabula is mo gom is pem jin shunki aha/ mo, aris mon’thinyi ’baar mo aha/ up̱a cim pem ki jabu’th mo. Aha/ c̱orosa/ ki c̱oros ap̱owa cim pem mo ki jabu’th pem jin gwoka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Em pem c̱a’bki reŋ reŋ mo gom monyjwakaṯ pem mo, a’di warki’d ki moŋ’ka’d is mo haala ris ’kup̱ pem tana ris ka ris mo. ");
INSERT INTO udu_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Iiku/ ’peni aha/ mo, aris um gun miiki tonthus mo, haali/ Tap̱a a’di ciḵki cuuwa/ gi kom pem mo. ");
INSERT INTO udu_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Tap̱a ciḵki aha/ ko gom mo ma di’b is mo. Tap̱a bu’thki mo ma ’thom pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Aris uni gun ta ’kup̱ pem minu dhu ki mo ma ’the is mo dhali pura du ki monṯo’c bwa mo, uni mini doḵ ka nyaŋ’ko’d mo dhali minu dhu ki mo ma ’the is ki e ’kamu’thki’d hila/ mo. ");
INSERT INTO udu_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Ayy Tap̱a Arumgimis pem, e /e mo tani aha/ budha mo jin huru jwa mo, tayi aha/ is ki me’d ’pena ris unim pem kun uri aha/ isho’k mo, dhali ’cuḵi aha/ mo ma, ");
INSERT INTO udu_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","isi ciki/ ki uni mini ’koki dher aha/ bwa me’da dhop̱ mo, mmodir aha/ mo mmodar gi jan ṯal ’de/ mmowoṯẖ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Ayy Tap̱a Arumgimis pem waḵki/ aha/ miina yansankan mo, dhali waḵki/ toŋ kamu/ di’d jin miiga/ ki me’d pem jin shiyi’d mo tani ");
INSERT INTO udu_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","dhali waḵki/ aha/ ri/a amugum pem ki tonthus mo tani walla dil a’di jin ta ’kup̱ pem to ka wuny is mo tani ");
INSERT INTO udu_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","dhalki a’di jin ta ’kup̱ gi aha/ uri aha/ mo dhali bu’th mo, dhali dhalki a’di pucur mondiki/em pem ’twa/a ’cesh mo, dhali ’thi/a ḵashiram pem e bwam bu’d mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Cuyi mis mo ma, ayy Tap̱a, eya nyor pini mo, ’deki is pini ki mis ap̱o/ uni gwansan kun ta ’kup̱ pem kun puri mii ki o’d mo, meri is mo, ayy Arumgimis pem, /e ṯorki gwon dwall jin toru gwo ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Dhalki montul is gom ’kwani uni itul is gom /e mo, dhali ap̱o/ a’di mo tani budhi monyc̱a’b pini jin eḵa/ eḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Tap̱a dwalli ’kwani gwo mo, dwalli aha/ gwo mo ayy Tap̱a, isi ki mii ma ḵar/em pem mo dhali isi ki gwo jin di’di aha/ jin dika/ ki mii ki ŋadhum mo. ");
INSERT INTO udu_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Ayy dhalki tonthus gi imanmii miinthus daḵu ka bwa i’ba/ mo ma, hili ṯeli /e imanmii ka ḵar/e sho’k mo, /e jin nyo/ki bwaŋ ’kwani mo dhali aduŋ ’kwani mo, /e jin tana Arumgimis jin ta’da ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Agoŋgorom pem a’di di’d eya Arumgimis mo, a’di jin ta uni is ki me’d mo, uni kun dhelel ma du mo. ");
INSERT INTO udu_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Arumgimis ta’da ḵar/e jin dwalli gwo mo, dhali Arumgimis jin deḵ ma nyor mo isa yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Waḵki/ wathi/ diki rica du is mo tani Arumgimis midi cil gandal piti ki ŋar ŋar mo. A’di ric̱ki’da shum bwam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","A’di thosonki to gi mo/as piti gom mo gi ’koshuwa ’kosh mo, mmodhala thop̱a/ o’d piti me’d mo jin c̱a’bki wur wur mo. ");
INSERT INTO udu_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Hili mo mo ma, amanmii tonthus mo tani a’di bwaaki’da ris tonthus mo, dhali di’d ka ’ci ibwa mo jin ta’da pibi ka pibi mo, dhali a’di ki ḵala ṯor ka pije/ mo. ");
INSERT INTO udu_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","A’di ki c̱wany jis mo tani dhali tor a’di ḵarash ka pije/ mo, dhali biṯi jis piti jin c̱wanykina a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Mo ma pibim piti ṯu’kki’d e ’kup̱ pitiŋ gana/ mo, dhali mombujur piti thulu’d e bwaŋ ’kup̱ pitiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Aha/ mina c̱i Tap̱a mo jin ’boruwa ’bor bwa i is mo jin ha me’d ki mo ma ḵar/em pitiŋ gana/ mo dhali aha/ mina yuḵ gway mmomaŋ gway gi Tap̱a mo, a’di jin Caa e ki Ca mo. ");
INSERT INTO udu_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Ayy Tap̱a, jin ta Tap̱am bam, gway pini wa’di eḵa/ e mony’ceshi ’baar mo! /E jin ta gi monyca ap̱o/ momisi ’baar mo jin nani’da nana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ki ’twa/ gi usha ŋa/ mo dhali uni gun tana ’pereny mo tani /e ṯelkina cur sho’k mo haali/ gom uni gun ta ’kup̱ gi /e mo, mmodosh a’di jin ta ’kup̱ gi /e mo dhali a’di jin ri’cki’da ri’c mo. ");
INSERT INTO udu_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Ki aha/ p̱arkina momis pini e mo, jin ta’da ṯu’c gi me’d pini mo tani mmop̱ara ppe e mo dhala risa cul kun ṯelkina /e sho’k mo, ");
INSERT INTO udu_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","wathi/ gi wakata mo, jin mina /e i/o bwa ki a’di mo, walla ya/ gi wathi/ mo ki /e mini hil a’di i e mo? ");
INSERT INTO udu_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Naskin /e ki kar a’di mmota ari jin gwa’da’d ka Arumgimis mo dhali shum a’di ki monyca mo dhali mii montaḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","/E c̱iki a’di mo jin tanu tap̱a ap̱owa risa ṯu’c gi me’d pini mo dhali /e dhukina ris to ’baar mo e bwaŋ’kwariny sho’k piti mo ");
INSERT INTO udu_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","aris ḵa’bal dhala morbip̱ mo, dhali si’da/ aris tombwaasho mo, ");
INSERT INTO udu_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","dhali aris ’dii kun p̱eni mis mo, dhala ris wa’c e bwaŋ ḵumma/ yi’de/ mo dhala ris to gunn kun dhu bway e bwaŋ ḵumma/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Ayy Tap̱a, jin ta Tap̱am bam mo, gway pini wa’di eḵa/ e mony’ceshi ’baar mo! ");
INSERT INTO udu_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Aha/ mina c̱i mo jin ’boruwa ’bor bwa i is e Tap̱a ka dum pemi ’baar mo. Dhali aha/ mina ṯora ris to kun miikina /e ki jaro/ jaro/ mo. ");
INSERT INTO udu_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Aha/ mina bwa ’kuny mo dhali ya i mis gom /e mo. Dhali aha/ mina yuḵ gway mmomaŋ gway pini mo, ayy /e jin Caa e ki Ca. ");
INSERT INTO udu_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Ka ris uni kun ta ’kup̱ gi aha/ doḵkin ka nyaŋ’ko’d mo dhali uni golkinki is mo dhali ’ce’d sho’k ibwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Haali/ /e halki mom pem jin raḵu jin ta jiŋ ḵar/e mo. /E c̱a’bkina p̱o/ ḵursi ma maliḵ mo mmoc̱i mo ma ḵar/e mo dhali gwon dwall jin toru gwo ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","/E ḵucurkina ris kal gi ’kwaniny’cesh mo, /e ’ce’dki uni gun ta thus ki thus sho’k mo, /e ’koshki gway buni ki sule/ dhali ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Uni gun ta ’kup̱ mo tani uni torki sho’k ka pupush mo e mo jin mu/u ’twa/a ’ceshi ’baar mo, aris ’peŋkuman bampam buni mo tani yu’dkina /e mo, dhali mom buni jin kanu uni e mo tani a’di i’ce’dkunu sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Hili Tap̱a a’di ic̱a’bki’d i mo ma ḵursi ma maliḵ ki sule/ mo. A’di ṯelki’da ḵursi ma maliḵ piti mo gom gwon dwall jin toru gwo ’twa/a ’cesh mo, ");
INSERT INTO udu_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","dhali a’di dwallki ’kwaniny’cesh gwo ki mii ma ḵar/e mo. A’di midi dwall ’kwani gwo ki dar gi mii ma gwar ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Tap̱a a’di ’bitha’bi’th me’da cur gom uni gun yap̱kunu mo, a’di ta’da cur jin ’bitha’bi’th ka tee jin ṯojuwa ṯo’c bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Dhali uni gwansan kun mishki gway piti mo tani dhuki moŋgam gwo is buni e /e mo, haali/ gom /e mo tani ayy Tap̱a /e diki dhal uni gwansan ’pen mo gun simmki /e e mo. ");
INSERT INTO udu_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Yuḵi gway ki maŋi Tap̱a mo a’di jin di’d eya Sihyuun mo. Ṯori miin tom piti e bwaman ma ris ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Haali/ a’di jin ri’cki’da bas mo tani a’di diki this uni e mo dhali a’di diki this ko e mo, ko gi a’di jin wo’ckunu is she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Miiyi mii ma ’the gom aha/ mo ma, ayy Tap̱a. Hili mo mo ma to jin ’koshi aha/ is ka nyor mo tani a’di ta to ’peni uni gwansan kun shi/ki aha/ i e mo, Ayy /e jin ’de’kki aha/ mo ’peni ’twaŋkal gi mowu mo, ");
INSERT INTO udu_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","ki aha/ mina rasha ris momaŋ pini e mo, ki eya ris ’twaŋkal ma goŋ gi ’bwa/ ma Sihyuun mo ki aha/ mina bwa ’kuny mo e mony’cuḵ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Aris kal gi ’kwaniny’cesh cic̱kin ’teki jorom mo e jis kun c̱wanykina uni mo, eya nyoḵ kun bagkina uni mo tani a’di bu’thki uni isho’k buniŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Tap̱a dhalki is piti ki a’di minu mish mo, a’di torki gwon dwall ’twa/a ’cesh mo, uni gun ta thus ki thus mo tani bu’thkin ma gumem buni kun uḵkina uni ki me’d buniŋ gana/ mo. Higgaion. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Uni gun ta thus ki thus mo tani uni mini c̱eker bwa mo eya Haawiya mo, aris kal gi ’kwaniny’ceshi ’baar mo kun thiskina Arumgimis e mo. ");
INSERT INTO udu_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Haali/ uni kun mini mii ta gi to mo tani uni minu mii ’koki this e isa yempa/ mo, dhali mo ma ’teŋ kap̱e/ gi uni gun hatha’ko’d mo tani uni minu ’koki ’ce’d sho’k ki sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Cuyi mis mo, ayy Tap̱a. Dhalku/ ki dhal ’kwani mmop̱i gwo jip̱i/ mo. Dhalka ris kal gi ’kwaniny’ceshi ’baar mo dwallu gwo mo ibwambori jis/em pini mo. ");
INSERT INTO udu_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Dhuyi uni ki mo ma ḵo/ is mo, ayy Tap̱a. Dhalka ris kal gi ’kwaniny’cesh ki mish uni mo ki uni tana ta, uni ta ’kwaniny’cesh mo! Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Katinta doshkina /e isa dhana/ kan mo, ayy Tap̱a? Katinta bagkina /e is pini ’pena tee jin ṯocu bwa mo? ");
INSERT INTO udu_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","E mo jin dhuna uni kun ta thus ki thus is ki ca mo tani uni ki ur uni kun hatha’ko’d isho’k mo. Dhalki uni budhu mo e mom buni kun p̱ishinkina uni ki ’pen mo kun kulumkina uni gwo ibwa mo. ");
INSERT INTO udu_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Haali/ uni kun ta thus ki thus mo tani dhuki ’ba/ ki ca mo gom to kun gop̱ uni bwam buni mo, dhali wathi/ jin pura bwa ki pur gom nyunykina/ mo tani a’di midi jeeya je mo dhali ruḵ Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","E bwam/em piti jin kara a’di ’ba/ ki ca mo tani a’di jin ta thus ki thus mo tani diki ŋap̱ a’di mo. Dhali aris gwom piti kun kuluma a’di ibwa mo tani ta ku kun wa cikise/ mo mmo/o ki: Arumgimis p̱iyi’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Bway piti ruski’d ki rus isa yempa/ mo, gwon dwall pini a’di c̱a’bki’d e mo jin eḵa/ eḵ mo, jin di’di bwamp̱o/ gi jis/em piti mo: dhali goma ris ’kup̱ piti mo tani a’di ki ’taḵ uni manya/ i’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","A’di kulumki gwo eya dum piti mo ki: Aha/ mina mol joc̱ mo, eya risa nyaḵum yil gi ’kwani mo tani aha/ mina diki gam a’di jin ta mo jin ’konu ki ’twa/ jin ’bushura/ ’bushur ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","’Twam piti ’tu’dkunu mo ki mo ma jee mo dhali ki mo ma he’k e mo dhali mmoyap̱a yap̱ mo, dhali ’ko’da le’d piti mo tani a’di taki’da pibi mo dhali miinthus jin shi/ashi/ mo. ");
INSERT INTO udu_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","A’di c̱a’bki’d mo mmobag mo eya ris bampa/ mo, e mom piti jin bagkina a’di is mo tani a’di jin ta’da man’kosha mee gom uni gun ’kon ka p̱o/ mo. Em piti mii’d ki jir jir mmotim uni gun hatha’ko’d mo ");
INSERT INTO udu_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","a’di ki wup̱a ’cesh ka ḵwal is me’da dhop̱ e bwaŋ gu’b piti mo, a’di ki wup̱a ’cesh ki a’di midi bu’th uni gun hatha’ko’d mo, a’di ki bu’th uni gun hatha’ko’d mo ki a’di di’d mmodir uni ka nyoḵ bway bwaman mo. ");
INSERT INTO udu_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Uni gun hatha’ko’d mo tani uni nyu/kunu mo, mmocic̱ ka ’cesh mo, dhali ṯa’k mo e mom’bi’th piti mo. ");
INSERT INTO udu_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","A’di kulumki gwo eya dum piti mo ki: Arumgimis dhalki’da dhal ’pen mo, a’di bagki jis/em piti mo, a’di midi mol a’di p̱ar e mo. ");
INSERT INTO udu_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Cuyi mis mo ma ayy Tap̱a, ayy Arumgimis. ’Deki me’d pini mo, dhalku/ ki dhal uni gun woca is is she/ ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Katinta iruḵkina wathi/ jin ta thus ki thus Arumgimis mo, dhali o gwo eya dum piti mo ki: /E mini diki yuḵ a’di mmoc̱i mondeŋ piti e mo? ");
INSERT INTO udu_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","/E mishkin mo, nye, /e nyiṯẖki mo jin ṯocu bwa mo dhali mo jin jwakaṯkunuwa jwakaṯ mo ki /e mini ’taki ḵal a’di e me’d pini mo, a’di jin hatha’ko’d mo tani a’di c̱iki is piti ki /e mo, haali/ /e jin tana manwoṯẖ gom a’di jin dar gi com mo. ");
INSERT INTO udu_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","’Ce’dki /e a’di abi mo a’di jin ta thus ki thus mo dhali a’di jin ta’da manmii tonthus mo, simmi miin tonthus piti e naskin mo ntagi /e mini diki gam toŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Tap̱a a’di ta’da maliḵ gom ki sule/ mo dhali ki sule/ mo. Kal gi ’kwaniny’ceshi ’baar mo mini ’ce’d sho’k ’peni mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ayy Tap̱a /e mini ciḵ to gi a’di jin ’ka’d ma du ki ’ka’d gom to jin o a’di bwa mo, /e mini ’bi’th uni adum buni is mo dhali /e mini ḵa’d ’cem pini mo, ");
INSERT INTO udu_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","mmodhuwa dhu ka p̱o/ mo gom uni gun dar gi icom mo dhali uni gun yap̱kunu mo be, wakan ki wathi/ gi mony’cesh midi diki dhu uni ki moŋḵo/ is doḵ/e mo be. ");
INSERT INTO udu_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","E Tap̱a mo tani aha/ bu’thkina mom pem jin hurkika/ jwa mo, dhali /e mini oyaa/ gwo kata mo ki: P̱eyi me’d ’dii mo e ’kuwosha turga/ mo, ");
INSERT INTO udu_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","haali/ hili mo mo ma, haali/ uni gun ta thus ki thus mo tani gwana’dkina bwa mo, uni ḵa’bkina thop̱am buni eya shu/ mo mmoshin e mondhurumi’d mo ap̱o/ uni kun dhelel ma du mo. ");
INSERT INTO udu_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Dhali waḵki/ mo kun ḵa’bkunu ’ce’dkunu sho’k mo tani imanmii ka ḵar/e mini miiya ta mo? ");
INSERT INTO udu_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Tap̱a a’di di’d e gu’b gi mondheleladhelel piti jin ḵogu mo, dhali aḵursi gi Tap̱a a’di di’d e momis mo, dhali em piti hilki mo mo, dhali aḵwarma’c em piti a’di nyo/ki uc̱i gi ’kwaniny’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Tap̱a a’di nyo/ki uni gun miin ka ḵar/e mo dhali uni gun ta thus ki thus mo, dhali aḵashiram piti shi/ki a’di i e mo a’di jin enki mo jin bujuruwa bujur mo. ");
INSERT INTO udu_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Ap̱o/ a’di jin ta thus ki thus kan mo tani a’di midi hetha p̱o/ a’di akap̱any o’d mo dhali to jin si’du/ mo, dhali ’tham jin shi’bil to mo tani a’di midi ta tom buni kun pwaḵkunu uni bwa ka ’to’d ’to’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Haali/ Tap̱a a’di ta’da ḵar/e mo dhali a’di eni mii gun miinu ka ḵar/e mo. Uni gun dhelel ma du mo tani mini hil bwam/em piti mo be. ");
INSERT INTO udu_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Woṯẖi/ awoṯẖ mo ma, Tap̱a. Haali/ jaŋ kamu/ yisa di’da naskina/ jin ta’da gayiin mo, haali/ uni kun ta ku isiŋ gana/ mo tani torki sho’k ka pupush mo ’peni bwaman gi ya/ gi ’kwaniny’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Aris ’kwaniny’ceshi ’baar mo ka ’deṯe/ ’deṯe/ mo tani takina ṯor ka ṯor ap̱o/ imannyaḵ ’dish gu’b buni is mo, ki gwo maŋ buni ’pena le’d buni ka maḵ mo dhali ka du kun ’koni su/ mo tani uni ki ṯor gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Dhalki Tap̱a a’di ’ciṯẖki’da risa maŋ kun maŋu ka maḵ ’peni ’twa/ mo, dhala le’d kun dhu dhan ’ba/ ki ca mo, ");
INSERT INTO udu_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","uni gwansan kun o gwo mo ki: Ka le’d bana mo tani ana mina p̱i gwo jip̱i/ mo, ale’d bana ’kon nyaḵki ana mo, kaja a’di ita tap̱am bana mo? ");
INSERT INTO udu_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Haali/ uni gun hatha’ko’d mo tani uni yap̱kunu mo, haali/ uni gun mini mii ta gi to mo tani uni ohonkin mo, aha/ mina cu mis shwane/ mo, a’di ta gwo jin ona Tap̱a mo, dhali aha/ mina kar a’di ki ’dantar e mo jin o a’di bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Aris gwo kun ona Tap̱a is mo tani uni ta gwo kun onu is mo kun dhelelkin mo, ’dolkon kush uni iṯo’dkunu ki o’d jin c̱a’b ki wur wur mo ’pena ’cesh mo, uni dhukunu i o’d me’di pesu/ mmodhelel a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Ayy Tap̱a, miiyi mii mmocesh am ka p̱o/ mo ma, jiyi aman ’pena nyaḵum yil gi ’kwani gwansan mo ma ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Eya ris ’twaŋkal kuku/ mo uni kun ta thus ki thus mo tani ’kaḵarki mo mo, me’d miim bulga/ a’di ikaru ki ca e bwaman iya/ gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Kakasja, ayy Tap̱a? A/e mini dhal aha/ ’pen ki sule/ sule/ kan mowa? Dhali /e mini bag jis/em pini ’peni aha/ ki mo gi wakata mo? ");
INSERT INTO udu_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Dhali ki mo gi wakatinta imiga/ mii ḵal mom’pe’d shem pem eya ḵashiram pem mo, dhali ta gi mondiṯ bwa eya dum pem iyula tente/ kan mo? Ki mo gi wakatinta imina a’di jin ta ’kup̱ gi aha/ ica ap̱o/ aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Nyiṯẖi ma dhali thoḵ aha/ gwo mo, ayy Tap̱a, Arumgimis pem mo. Kushi em pem mo isi ciki/ ki aha/ mina ish e mo e a’di jin ta mo/ish e gi mowu mo, ");
INSERT INTO udu_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","isi ciki/ ki a’di jin ta ’kup̱ ki aha/ midi o gwo mo ki: Aha/ p̱ina a’di e mo be, isi ciki/ ki uni kun ta ’kup̱ ki aha/ mina bwa ’kuny mo haali/ aha/ yiḵinkunu is mo be. ");
INSERT INTO udu_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Hili aha/ gamkina gwo is mo e mo/en pini jin ṯelkunu sho’k mo, adum pem mina bwa ’kuny mo e bway mowoṯẖ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Aha/ mina yuḵ gway e Tap̱a mo, haali/ a’di mii aha/ ki ’bore/ ki miin to kun ishkin ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","A’di jin ta p̱us mo tani o gwo eya dum piti mo ki: Arumgimis p̱iyi’d mo. Uni p̱u/kin mo, dhali uni mii mii kun bulabul mo. Jaŋ kamu/ jin mii’d ka ḵar/e yisa di’da. ");
INSERT INTO udu_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Tap̱a hilki mo ka luŋgu’b ’peni mis ap̱o/ uc̱i gi ’kwaniny’cesh mo mmop̱ar mo e mo waḵki/ jan ṯal ’deŋ kamu/ mii mii ki yuḵ yuḵ mo, mmosimm jasi Arumgimis e mo. ");
INSERT INTO udu_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Uni ’baar mo iikini dheres mo, uni ’baar mo wakina e ki to gun p̱u/kin mo, jan ṯal ’deŋ kamu/ yisa di’da jin mii mii jin ’boro’d mo, ṯal ’de/ p̱iyi’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","’Kona uni ki nyiṯẖa/, aris imanmii tonthus mowa, uni kun shwa ’kwanim pem me’d tonṯe/ kun shwana uni mo, dhali uni ’koki yuḵ Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Uni minu dhu ki dhan moŋḵo/ is mo, haali/ Arumgimis nyaḵ di ki ’kwani ma nyaḵum yil kun mii miiŋḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Um mini ’taki non mo jin thosona wathi/ jin hatha’ko’d ’twa/ mo tani, hili Tap̱a a’di ita jim piti jin hura a’di jwa nycine/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Ayy mony’cuḵ midi ’taki p̱u’d gom ’Kwani ma Israyiil moyi ’peni Sihyuun mo! Ki Tap̱a midi wara shamaneṯṯan ki ’kwanim piti is mo tani Yakuub mina bwa ’kuny mo dhali Israyiil mina bwa ’bor mo. ");
INSERT INTO udu_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Ayy Tap̱a, aja a’di imidi c̱a’b ki c̱a’b yilkina/ e gu’b burrinyem pini mo? Dhali aja a’di imidi c̱a’b e ’kuwosh pini jin ḵogu mo? ");
INSERT INTO udu_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","A’di jin ya’d ki dar gi mii ’ba/ mo, dhali mii miim ’boro’d mo, dhali ṯor gwoŋ gana/ ’pena dum piti mo, ");
INSERT INTO udu_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","a’di jin diki thutha thu’th ’pen ka le’d piti mo, dhali diki mii tonthus ka kam piti mo, walla ḵal mo jin waḵuwa waḵ ap̱owa mannyaḵ c̱a’b piti jin ’dish a’di is mo, ");
INSERT INTO udu_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","dhali e jis/em piti mo tani aman/ush gwo gam is mo tani waḵkina a’di mo, hili a’di taḵ uni gwansan kun ḵo/ki Tap̱a mo, dhali a’di jin thulki gwom piti me’da p̱o/ mo ki to jin shi/ki a’di mo tani dhali diki aḵ gwom piti e mo be, ");
INSERT INTO udu_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","a’di jin diki kara guurush piti e mo jin nyunyu/ to mo, dhali a’di diki bu’th mo jin wanu is ap̱o/ a’di jin di’d ka po/ mo be. A’di jin mii to gwansan mo tani minu mol joc̱ ki sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","’Tashi aha/ ’twa/ mo ma, ayy Arumgimis, haali/ e /e mo tani aha/ bu’thkina mo jin huru jwa mo. ");
INSERT INTO udu_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Aha/ ki o Tap̱a gwo mo ki: /E ta Tap̱am pem mo. Ki dar gi /e mo tani aha/ mina mol tom ’boro’d gam mo. ");
INSERT INTO udu_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Me’d uni gun dhunu ki she/ ki dhelel dhelel e mony’cesh mo tani uni a’di ita kun bol tiya e ki ’bor mo, dhali e uni mo tani a’di ’kunyka/ bwam pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Uni gwansan kun kwanykina ruma tiya mo tani uni marki mondiṯ bwam buni is mo, mon tom buni gun c̱ina uni mmo’ciṯẖa basa ’cesh mo tani aha/ mina diki c̱i mo walla aha/ mina diki ḵal gway buni e ’twam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Tap̱a a’di ta tom pem jin kwanyka/ mmobu’th mo dhala ḵubbaayam pem mo dhali /e ko’dki mal pem is mo. ");
INSERT INTO udu_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Jil uni dirkini bwambori aha/ mo e mo jin ’kunyka/ bwa mo, nye, aha/ tana gi mala ’borga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Aha/ ’bora Tap̱a mii mo a’di jin c̱iki aha/ gwo logom mo, e mon’thiny si’da/ mo tani adum pem ye’thki aha/ sho’k ki gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Aha/ karkina Tap̱a isa yempa/ ibwambori jis/em pem mo, haali/ a’di di’d ki me’da bim poros pem mo ki aha/ minu ’koki joc̱ mo be. ");
INSERT INTO udu_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Wakan adum pem a’di ’borkunu bwa mo dhala ḵashiram pem a’di ’kunykina bwa mo. Buŋgwar is pem a’di c̱a’bki’d ki c̱a’b ’pempaŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Haali/ /e diki c̱i aha/ eya Haawiya mo, walla /e diki dhal a’din ’de/ jin ta’da gayiin pini bway mo mmop̱ar jisa ’kulga/ e mo. ");
INSERT INTO udu_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","/E ṯorki aha/ bway tur gi mondiki/e mo, e buŋ’kus pini mo tani a’di isha mo jin ’tu’du ki moŋ’kuny bwa mo, eya bim poros pini mo tani a’di ’kona mo jin ’boru bwa ki sule/ sule/ ya ye ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Ciḵi gwoŋ ḵar/e mo ma, ayy Tap̱a. Kari ’ce gom kom pem mo. C̱iyi ’cem pini gom mon’thom pem ’pena le’d pem jin di’d ki ’kus ’pena he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","’Peni /e mo tani dhalki mom pem jin yenu p̱u’du’d mo. Dhalki em pini a’di hili jim ’boro’d mo. ");
INSERT INTO udu_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Waḵki/ /e mini pala dum pem mo, dhali waḵki/ /e mini yayu/ mmobuṯi aha/ mon’thiny mo, dhali waḵki/ /e mini nyo/ aha/ mo tani /e mini diki gam tonthusa kamu/ e aha/ mo. ’Twam pem diki dhaŋ gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Me’d mii gun miina ’kwani mo tani ki gwo gi ’twam pini mo tani aha/ gaskina mo ’peni bway gi uni kun bujurkina bujur mo. ");
INSERT INTO udu_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ŋaṯgin pem ṯelki sho’k mo e bway tur pini mo, sho’k pem diki yeres mo. ");
INSERT INTO udu_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Aha/ yuḵkina /e mo haali/ /e mini thoḵ aha/ ’twa/ mo, ayy Arumgimis. Kari /e ’cem pini gom aha/ mo, ciḵi /e gwom pem mo ma. ");
INSERT INTO udu_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ṯori monṯel sho’k gi mo/en pini ki jaro/ jaro/ mo, ayy amanwoṯẖ gi uni gwansan kun simmki mo jin huru jwa e mo ’peni uni kun ta ’kup̱ gi uni ki me’da bim poros pini mo. ");
INSERT INTO udu_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Kari aha/ me’da pinya/ e e mo. Bagi aha/ eya la ma bim pini mo, ");
INSERT INTO udu_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","’peni uni kun ta thus kun dilki aha/ to mo, kun ta ’kup̱ pem kun shi/in ki shiŋ gana/ mo kun ’kamki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Uni mu’thkina dum buni ’peni bwa jin hilu ki e ma ’thime/ mo. Dhali ki ’twam buni mo tani uni oki gwo ki ’ba/ kun dhuna uni ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Uni thuḵki aha/ ki ’the’b ’the’b mo, dhali shwane/ uni ’kamki aha/ mo. Uni dhuki em buni mo mmo’tuḵ aha/ ka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Uni wana e ka dhop̱ jin gananki ’ba/ mo mmodher to bwa ka gwap̱i/ mo, me’d ari dhuru’c ma dhop̱ jin wup̱ki’da ’cesh mmobag mo. ");
INSERT INTO udu_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Cuyi mis mo, ayy Tap̱a, jemi uni ’kup̱ mo, dhali p̱iyi uni e mo. Dhali ’cuḵi mondiki/em pem ’peni uni kun ta thus ki thus ki gandal pini mo, ");
INSERT INTO udu_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","’peni ’kwani ki me’d pini mo, ayy Tap̱a, ’peni ’kwani gwansan kun bu’th to jin ta moŋ’ko gi mony’cesh mo. Dhalki bwam buni ’tu’du/ mo ki to kun dhukina /e gom uni mo. Dhalki uc̱im buni uni tan gi to ki nyanye/ mo jin midi bol ji gi ca’d e mo. Dhali dhalki uni ur ton tiya ’kup̱ gom usha ŋam buni mo. ");
INSERT INTO udu_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Dhali gom aha/ mo tani aha/ mina hil bwam/em pini mo e mo ma ḵar/e mo. Ki aha/ mina mer e mo tani aha/ minu kap̱ mo mmohila yir em pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Aha/ ena /e mo, ayy Tap̱a, jin ta mom’bi’th pem mo. ");
INSERT INTO udu_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Tap̱a a’di ta wosh pem mo, dhali acur pem mo, dhali aman’cuḵ aha/ mo, dhali Arumgimis pem mo, dhali wosh pem mo, e a’di jin bu’thkika/ mo jin hurga/ jwa mo, a’di jin ta’da goŋgorom pem mo, dhali ce gi bway gi mowoṯẖ pem mo, dhali mo ma cur pem jin ṯenu gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Aha/ yuḵkina Tap̱a mo, a’di jin haki me’d mo jin minu maŋ mo, dhali aha/ takunu is ki me’d mo ’pena ris unim pem kun ta ’kup̱ ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Atomm gi mowu a’di ’tamkunu aha/ is mo, mii jin kar ’kus me’d yi’de/ ’peni mo jin daḵu/ gwo me’d mo a’di tiḵ aha/ e mo, ");
INSERT INTO udu_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","dhali atomm ma Haawiya a’di koṯẖki aha/ is mo, dhali agume/ gi mowu a’di jemki aha/ ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","E mo ma c̱is pem mo tani aha/ yuḵkina Tap̱a mo, eya Arumgimis pem mo tani aha/ gwokina ’twa/i a’di gom mowoṯẖ mo. ’Peni gu’b gi mondheleladhelel piti mo tani a’di ciḵki ’twam pem mo, dhali kom pem a’di jidhirki’d mo e bwany’cem piti mo. ");
INSERT INTO udu_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Dhali mony’cesh a’di yaki’d ka kul is mo dhali ṯu’k ’ban ki washar washar mo, dhali moŋḵa’b ma ris wosha turga/ si’da/ uni deekin ki bir bir mo, dhali yiḵinki is mo haali/ a’di shwaki’da nyor mo. ");
INSERT INTO udu_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Aku’d yaki’d ka pije/ ’peni shush piti mo dhali o’d jin midi kup̱a kup̱ ’peni ’twam piti mo, akap̱any o’d jin ḵakaca ḵaka’c gac̱ki’d ka pije/ ’peni a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","A’di goŋki momis is mo dhali thulu/ ka ’cesh mo dhala raḵ jin ’ceṯẖki’da ’tum a’di di’d e bwaŋ’kwariny sho’k piti mo. ");
INSERT INTO udu_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","A’di merki’da p̱owa man’doyu gwo mo dhali p̱e mo, a’di p̱u’dki’d ki ’ta’b ap̱owa bi gi ’tham mo. ");
INSERT INTO udu_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","A’di karki mondhurumi’d mmota tom piti jin ’kamki a’di is mo, adarha’dam piti a’di ta’da raḵ jin ’ceṯẖki’da ’tum gom yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","’Peni moŋkush jin kushi mo kagahara e bwambori a’di mo tani to p̱u’dki’d ’pena raḵ piti mo jin ta’da wasa/ mo dhali akap̱any o’d mo. ");
INSERT INTO udu_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Dhali Tap̱a si’da/ a’di gwoki’da gur gur e momis mo dhali a’di jin Caa e ki Ca a’di bahki ’twam piti mo, awasa/ mo dhali akap̱any o’d mo. ");
INSERT INTO udu_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Dhali a’di shinki’da thop̱am piti mo dhali c̱e uni bwa mo dhali a’di ki dhi’th mo ka war mo dhali ṯi’k uni ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Dhali bway tur e ḵumma/ yi’de/ mo tani uni ’kokunu mo mmomish mo, dhali moŋḵa’b gi mony’cesh uni mishkunu mo be, gom miiŋ ḵucur pini mo jin ḵucurkina /eya ḵucur mo, ayy Tap̱a, gom du’d gi shi/in ’peni shush pini mo. ");
INSERT INTO udu_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","A’di jidhirki’d ’peni mo jin eḵa/ eḵ mo, dhali a’di bu’thki aha/ mo, a’di ki dir aha/ ka pije/ ’pena ris yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","A’di ki ’cuḵ aha/ mo ’peni a’di jin ta ’kup̱ ki aha/ jin ’bitha’bi’th mo, dhali ’peni uni gwansan kun shi/ki aha/ i e mo, haali/ uni ’kona isi ’bitha gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Uni p̱u’dkina p̱o/ aha/ ka teem pem jin ta joḵ ki joḵ mo, hili Tap̱a a’di ta mohal pem mo, ");
INSERT INTO udu_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","A’di ki buḵ aha/ ka pije/ e mo jin ḵwashara/ ḵwashar mo dhali a’di ’cuḵki aha/ mo, haali/ a’di ’borkina bwa ki ’bor ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Tap̱a a’di c̱iki aha/ adum pem jin ish ḵumma/ mo me’d isi mii ma ḵar/em pem mo, dhali me’d isi mii jin dhelelkika/ me’d pem mo tani a’di raḵki aha/ to ibway mo. ");
INSERT INTO udu_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Haali/ aha/ dhukina bway gi Tap̱a mo dhali aha/ dinaki mii tonthus mmoper mo ’peni bway ma Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Haali/ aris gwoŋḵan piti kun onu mo tani uni ’koni bwambori aha/ mo, dhali gwoŋḵan piti kun bahu mo tani aha/ dinaki dhu uni ’pen ka pije/ ’peni aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Aha/ dara gi mii ’ba/ ibwambori a’di mo, dhali aha/ karkina is pem ’peni mo jin ’konu ki mii ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Gom gwo gi wakan mo tani Tap̱a a’di iraḵki aha/ to ibway mo isi ki mii ma ḵar/em pem mo, dhali isi ki me’d pem jin dhelelkika/ mo e jis/em piti mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Gom uni kun ta ku isiŋ gana/ mo tani /e ki ṯor is pini jin tana /e a/isiŋ gana/ e uni mo, dhali ki wathi/ jin dar gi mii ’ba/ mo tani /e ki ṯor is pini jin dara /e ki mii ’ba/ e wathi/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Dhali gom uni kun dhelelkin mo tani /e ki ṯor is pini jin dhelelkina /e e uni mo, dhali ki uni kun wanycarkina ii ki wanyjar mo tani /e ki ṯor is pini e uni ki c̱a’ckon mo. ");
INSERT INTO udu_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Haali/ /e ’cuḵki ’kwani kun dhu is ki gwa’d mo, hili uni kun dhu ’bam buni ki ca ki e ma waḵ mo tani /e mini thul uni ka ’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Nye, /e ḵanyki moŋkush ma lambam pem mo. Tap̱a Arumgimis pem a’di ’twaḵki mondhurumi’d pem ki moŋkush mo. ");
INSERT INTO udu_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Nye, ki /e mo tani aha/ misha sirica risa thuruḵ ma mee ki sho’k mo dhali ka Arumgimis pem mo tani aha/ mina mish nyalla/ ap̱o/ ’kup̱a gaŋgara/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Arumgimis yansan mo tani bway piti ’boro’d ki ’bor gana/ mo. Dhali gwo jin ona Tap̱a is mo tani a’di nyo/ki gwoŋ gana/ mo. A’di ta’da goŋgoro/ goma ris uni gwansan kun bu’thki mo jin huru jwa e a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Haali/ aja a’di ta’da Arumgimis mo? hili a’di jin ta Tap̱a mo. Dhali aja a’di ita wosh? isi ciki/ Arumgimis bana mo. ");
INSERT INTO udu_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Arumgimis jin deḵki aha/ ki mom’bi’th is mo, dhali kar bway pem ki ’dantar mo. ");
INSERT INTO udu_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","A’di ki kar sho’k pem mmowa e ki sho’k ma buyymo mo, dhali a’di ki kar aha/ ki kar ’pempaŋ gana/ mo e mo jin turatur mo. ");
INSERT INTO udu_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","A’di ṯorki me’d pem gwo mo gom mo ma mee mo, wakan ka bim pem mini mish gwana’da bwa me’da koroḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","/E c̱iki aha/ agoŋgoro/ gi bway mowoṯẖ pini mo, dhali ki me’da bim poros pini mo tani /e thip̱ki aha/ mo, dhali ki mowoṯẖ pini mo tani a’di ki kar aha/ mmocaaca mo. ");
INSERT INTO udu_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","/E ki c̱i aha/ mo jin waŋgala/ waŋgal gom ŋaṯgin pem kun dhuka/ e bwaŋ’kwariny pem mo, dhali sho’k pem diki yeres mo. ");
INSERT INTO udu_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Aha/ urkina ris uni kun ta ’kup̱ gi aha/ isho’k mo, dhali bu’th uni mo dhali aha/ dinaki doḵ ka nyaŋ’ko’d mo ntagi uni kup̱kunu mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Aha/ p̱uṯulkina uni i e mo, wakan ki uni molki cu mis mo. Uni ṯa’kkin e bwaŋ’kwariny sho’k pem mo. ");
INSERT INTO udu_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Haali/ /e deḵki aha/ ki mom’bith mo gom mo ma mee mo. /E ki dhu uni kun tiḵki aha/ e mo mmocic̱ ki jorom mo ibwaŋ’kwariny aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","/E ki dhu aris unim pem kun ta ’kup̱ ki aha/ mmoṯu’k aha/ ’ko’d buni i is mo dhali uni gwansan kun shi/ki aha/ i e mo tani aha/ ’ce’dkina uni sho’k mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Uni cuukin gom mowoṯẖ mo hili jaŋ kamu/ p̱iyi’d mmota uni is ki me’d mo. Uni cuukin ’twa/ e Tap̱a mo tani hili a’di diki thoḵ uni gwo mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Aha/ dorkina uni mmota agarisa/ ibwambori ’tham mo. Aha/ ṯa’kkina uni ka pije/ me’da je e bway tur kun iinu mo. ");
INSERT INTO udu_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","/E ’cuḵki aha/ mo ’peni mo jin bira ’kwani abir mo, /E ki kar aha/ mmota a’kaŋ’kup̱ ki kal gi ’kwaniny’cesh mo. Ki ’kwani kun dika/ ki mish mo tani uni miiki aha/ to mo. ");
INSERT INTO udu_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Haali/ me’d jin ciḵkina uni gwo gom aha/ mo tani uni haki aha/ gwo e mo. ’Kwani kun wal ’twan tiya mo tani uni p̱u’dkin mo mmopar ki jiŋ ’kup̱a’dup̱un ’kup̱ ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","’Kwani kun wal ’twan tiya mo tani uni thiskin ma du e mo, dhali p̱u’du/ mo mmodee kagahara ’peni mo ma cur buni mo. ");
INSERT INTO udu_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Tap̱a di ki e mo dhali mom’bor mii midi di gom wosh pem mo, dhali mo/eḵ midi di goma Arumgimis pem jin ta bway mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Arumgimis jin c̱iki aha/ mori’c mo dhali aris ’kwani mmo’dap̱ ’twa/a ’cesh i bwaŋ’kwariny sho’k pem mo. ");
INSERT INTO udu_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","A’di jin ’cuḵki aha/ mo ’pena ris ’kup̱ pem mo, nye, /e karki aha/ ki ca mo mmoboloc̱a ris uni kun ta ’kup̱ ki aha/ e mo, dhali /e ’cuḵki aha/ mo ’peni ’kwani kun bujurkina bujur mo. ");
INSERT INTO udu_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Haali/ gom mii yan kan mo tani aha/ mina c̱i /e montaḵ gi gwo maŋ mo, ayy Tap̱a ibwaman kal gi ’kwaniny’cesh mo, dhali yuḵ gway mmomaŋ gway pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Adhan mo jin p̱inu mii e mo tani a’di c̱ikina a’di goma maliḵ piti mo, dhali a’di ki ṯor mo jin ṯelu mo/en piti sho’k mo ki a’dim piti jin ’koshkina a’di ki monyca mo, eya Dawuu’d mo dhali e emen piti ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Aris momis uni ṯorki monyca ma Arumgimis mo, dhala balany bahki miin tom piti ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Ka yempa/ ka yempa/ mo a’di ki gac̱ gwonṯor piti mo, dhali mon’thiny ka yempa/ mon’thiny mo tani a’di ki ṯor monyiṯẖ piti mo, ");
INSERT INTO udu_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Mowal ’twa/ p̱iyi’d mo walla gwo p̱iyin mo, dhali ’twam buni si’da/ ’konuki ciḵ mo tani ");
INSERT INTO udu_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","hili ’twam buni a’di yaki’d ka pije/ e mony’ceshi ’baar mo, dhali gwom buni a’di yaki’d ki ’pemen gi mony’ceshi ’baar mo. E uni mo a’di ki kar gu’ba’ku/ goma tente/ mmodi mo, ");
INSERT INTO udu_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","a’di jin sulki’d ka pije/ me’d wathinyaŋa’b jin dhalki gu’b jin isha a’di ’pen mo dhali wa e ki wathi/ jin ’bitha’bi’th jin guski’d mmo’baar bway piti ki moŋ’kuny bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Mosul piti a’di ’peni ’pemen ma ris momis mo, dhali mo ma kul is piti a’di taki’d gi ’pemen e uni mo, dhali toŋ kamu/ yisa di’da jin mishu bag mo ’peni mo ma wur wur piti mo. ");
INSERT INTO udu_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Gwoŋḵan jin c̱inu gi Tap̱a mo tani a’di ’boro’d ki isi ’bor gana/ mo, a’di jin warki’da ḵashira/ is mo, dhali gwonyc̱i gi Tap̱a a’di doshki’d mo, mmodhu uni gun ’ka’da mii ’ba/ ki moyuḵ mo, ");
INSERT INTO udu_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","gwoŋḵan gi ’twa/ gi Tap̱a mo tani uni yisa shiyina, hili uni ’kunykina du mo be. Dhali gwoŋḵan gi Tap̱a jin ’kwarkunu mo tani a’di dheleladhelel mo, a’di jin kushki e gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Moŋḵo/ jin ḵogu Tap̱a mo tani uni dheleladhelel mo, kun minu ’dim ’kup̱ ki sule/ sule/ ya ye ’ba/ mo. Dhali gwoŋḵan gi Tap̱a kun onu mo tani uni ta uniŋ gana/ mo dhali tana ḵar/e mmonṯal ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Kun minu o bwa ki nyanye/ mmobol ’dolkon gana/ e mo isi kan si’dayi me’d ’dolkon gana/ jin tashkunu e ki o’d mo, dhali a’di jin c̱a’bki dhel dhel si’da/ mmobola dham e mo dhali jin yuki’d ki haw haw me’d mamana dham mo. ");
INSERT INTO udu_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Bahili ki uni mo tani c̱iŋkinam pini a’di rumkunu mo dhali mmodhu uni mo tani adhan to jin ish ḵumma/ jin caaca mo tani a’di c̱ikunu mo. ");
INSERT INTO udu_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Hili aja a’di imidi theke’th tom piti kun thama a’di mii mo? Dheleli /e aha/ ’peni mombag gi mii kun thamka/ mii mo. ");
INSERT INTO udu_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","’Tashi c̱iŋkinam pini ’twa/ mo ’peni miinthus kun miina a’di ka daran du mo. Dhali dhalku/ ki dhal uni bway mo mmota tap̱a ap̱o/ aha/ mo. Dhali yan’ko’d aha/ mina di ki dar gi mii ’ba/ mo dhali di ka p̱o/ ’pena dhan gwon dhaŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Dhalki gwo gi ’twam pem dhali gwo kun kulum aha/ eya du mo mishu bu’th mo e jis/em pini mo, ayy Tap̱a jin ta wosh pem mo dhali amanwan aha/ ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Tap̱a midi thoḵ /e ’twa/ mo ka tee jin ṯoju /e bwa mo. Dhali gway ma Arumgimis ma Yakuub mo tani a’di midi cesh /e ka p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Dhalki a’di hashki /e mowoṯẖ ’peni mo jin ḵogu mo dhali c̱i /e mo ma thip̱ ’pena Sihyuun mo. ");
INSERT INTO udu_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Dhalki a’di ka’da ris tom pini kun c̱ina /e ki me’d e mo mmo’ciṯẖ ’kus mo, dhali kar /e ki mo ma ’the mo gom to kun ’ciṯẖkina /e ’kus mo mmomiiya bas mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Dhalki a’di c̱i /e a’di jin gwon ma dum pini mo dhali thima ris tom pini kun thosonkina /e is mo. ");
INSERT INTO udu_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Dhalki aman wola cuuwa/ mo gom bwaŋ ’kunyka/ ap̱o/ mom pini jin p̱ina /e mii e mo dhali ki gway ma Arumgimis bana mo tani dhalki ana thuma bereḵ bana mo. Dhalki Tap̱a a’di thimi’da ris mo ma ’thom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Dhali aha/ misha ki Tap̱a a’di midi woṯẖ jim piti jin ’koshkunu ki monyca mo. A’di midi thoḵ a’di ’twa/ mo ’peni momis piti jin ḵogu mo ki dhan mo ma dem dem jin p̱inu mii e mo ki me’da bim poros piti mo be. ");
INSERT INTO udu_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Kun tiya dhu ’ba/ ki ca mo goma risa arabiyya kun dira shumarum mo, dhali goma ris shumarum mo. Hili ana dhuna ’ba/ ki ca gom gway gi Tap̱a Arumgimis bana mo. ");
INSERT INTO udu_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Uni mini ’tuḵ mo dhali ṯa’k mo hili ana mina cu mis mo dhali dosh ki bimbir mo. ");
INSERT INTO udu_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","C̱iyi mo jin p̱inu mii e ka maliḵ mo, ayy Tap̱a, thoḵi aman ’twa/ mo ma ki aman yuḵkina yuḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","E mom’bi’th is pini mo tani amaliḵ a’di ’kunykina bwa mo, ayy Tap̱a, dhali e mowoṯẖ pini mo tani adhan momaŋ mmoyuḵ gway wa’d e a’diya! ");
INSERT INTO udu_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","/E c̱iki a’di to jin gwon ma dum piti mo, dhali /e diki non to jin ’theḵa a’di gwo ki ’twam piti mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Haali/ /e gamki a’di ’kup̱ ki mom’bor miim ’borga/ mo, dhali /e ki kar a’di toŋ’kup̱ ki ’dolkon gana/ jin tashu e ki o’d i’kup̱i a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","A’di doṯki mondiki/e ’peni /e mo tani dhali /e c̱iki a’di a’di mo, a’di jin ta’da luc̱ ma tee gom ki sule/ dhali ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Monycam piti caaca gom mowoṯẖ pini mo, dhali mo ma ra/ ra/ mo dhali mo/eḵ mo tani karkina /e ap̱o/ a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Nye, /e karki a’di mmota a’di jin midi ’bora ’bor mii ki sule/ mo dhali /e ki kar a’di mmota aman’bor bwa mo ki moŋ’kuny bwa gi buŋ’kus pini mo. ");
INSERT INTO udu_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Haala maliḵ gamki gwo is e Tap̱a mo dhali e monṯel sho’k gi mo/en gi a’di jin Caa e ki Ca mo tani a’di midi diki joc̱ sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Me’d pini a’di midi gama ris unim pini ’baar kun ta ’kup̱ ki /e mo. Me’da bim poros pini midi gam uni gwansan gun shi/ki /e i e mo. ");
INSERT INTO udu_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","/E mini dhu uni mmota ’cepesa ’cepes me’d to kun cesuwa gwaṯa/ mo ki /e mini pi is ka pije/ mo. Tap̱a a’di midi los uni ki ’kolo’c ka nyor piti mo, dhali o’d midi shwa uni ki ’ci’d’da/ mo. ");
INSERT INTO udu_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","/E mini ’ce’da ’pereny buni sho’k ’peni mony’cesh mo dhali uc̱im buni ’peni bwaman iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Waḵki/ uni thoson tonthus ap̱o/ /e mo, dhali waḵki/ uni mini mum tonthus mmota pibi icine/ mo tani uni mini mol a’di pi ’ba/ ka pije/ mo. ");
INSERT INTO udu_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Haali/ /e mini dhu uni mmoso mo. Haali/ /e mini ṯur uni jis/em buni ka bwam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Dhalki /e karu ki ca mo, ayy Tap̱a, e mom’bi’th is pini mo. Aman mina yuḵ gway mo dhali maŋ mom’bi’th pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Arumgimis pem, Arumgimis pem, atinta idhalkina /e aha/ ’pen kan mo? Dhali ki ton ta’da ta isi’da/ /e ki si’d ’peni mowoṯẖ aha/ kan mo? ’peni gwo gi kom pem jin ohonkika/ mo? ");
INSERT INTO udu_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Ayy Arumgimis pem aha/ gwokina montee ka yempa/ mo, dhali hili /e diki thoḵ aha/ ’twa/ mo. Dhali mon’thiny si’da/ aha/ gwokina mo, dhali hili mosi/isa kamu/ gamkaa/? ");
INSERT INTO udu_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Naskin mo tani /e dheleladhelel mo, /e karuwa ḵursin tap̱a jin ta momaŋ gi ’Kwani ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","E /e mo tani ibaba gamki gwo is mo. Uni gamki gwo is mo, dhali /e ’cuḵki uni mo. ");
INSERT INTO udu_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","E /e mo tani uni gwokin mo dhali ’kokunu mo mmota is ki me’d mo. E /e mo tani uni gamki gwo is mo, dhali uni ’konuki this dhu mo. ");
INSERT INTO udu_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Hili aha/ tana yiish mo, dhali aha/ tana wathi/ yisa, haali/ aha/ c̱inu gurra/ ki ’kwani mo, dhali jin waḵkunu ki ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Aris uni gwansan gun p̱arki aha/ e mo tani uni miiki aha/ ka maḵ mo, uni ṯẖuny aha/ ’twa/ i is mo, dhali uni pirki ’kup̱ buni mo be. ");
INSERT INTO udu_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","A’di c̱iki miim piti jin raḵa’d e Tap̱a mo. Dhalki a’di ’cuḵ a’di mo. Dhalki a’di ’cwam a’di mo, haali/ a’di ’kunya bwa e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Hili /e ta a’di jin bu’thki aha/ ’peni bwa ma dho’th ma ta’da mo. Dhali /e karki aha/ ki ’dantar mo abora ko ma ta’dam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Apo/ /e mo tani aha/ biṯkunu ’peni mondho’th pem mo, dhali me’d jin ḵal ma ta’dam pem aha/ e bwa mo tani /e tana Arumgimis pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Dhalku/ ki si’d ’peni aha/ kan mo ma, haali/ monṯo’c bwa uni ’disha’dish mo dhali wathiŋ kamu/ p̱iyi’d mmowoṯẖa woṯẖ mo be. ");
INSERT INTO udu_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Aris gwaṯẖim bip̱ uni ’kamki aha/ mo, gwaṯẖim bip̱ gun ’bitha’bi’th ’peni Pam Bashan mo tani uni ’kamki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Uni c̱eeki aha/ ’twam buni i is mo mmowa e ka dhop̱ kun pithilki to ki she/ mo dhali ko mo. ");
INSERT INTO udu_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Aha/ wana ’baar mo me’d yi’de/, dhala risa simam pemi ’baar raḵkin mo ’peni gwocor mo. Adum pem ta walmish ki walmish mo, a’di ṯo’do’d mo eya bor pem mo. ");
INSERT INTO udu_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Mom’bi’th pem a’di ḵu’thki’d me’da ’pish mo, dhala le’d pem a’di ’dap̱ki’d e bwaŋ ḵa’dkim pem mo. /E ’thiki aha/ ’ko’d e bu’da ’cesh ki mowu mo. ");
INSERT INTO udu_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Nye, arisa ’ka uni ’kamki aha/ mo. Imanŋali ’pen kun mii tonthus mo tani uni hamki aha/ mo. Uni su’kki me’d pem dhali sho’k pem mo. ");
INSERT INTO udu_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Aha/ misha deŋa risa simam pem e mo – Uni hilki aha/ ka ’thime/ mmoḵo’c e i is mo dhali p̱e’th ki ḵuss ḵuss ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Uni pwaḵki burrinyem pem bwa mo e bwaman is buni mo, dhali gom burrinyem bwaman pem mo tani uni biṯki to gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Hili /e, ayy Tap̱a, dhalku/ ki si’d mo ma. Ayy /e jin ta mowoṯẖ pem mo, huru/ ki jahanne/ gom mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","’Cuḵa ḵashiram pem ’pena ris gandal gun kaaka mo ma, dhali mondiki/em pem ’peni mom’bi’th ma ’ka mo. ");
INSERT INTO udu_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Tayi aha/ is ki me’d ’peni ’twa/ ma dhop̱ mo ma, aḵashiram pem wa’thkunu i e ki ce ma morbip̱ gun shwana nyor ka nyor mo. ");
INSERT INTO udu_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Aha/ mina ṯor gway pini e iwaḵ pem mo. E bwaman ma dhana tul ’kup̱ ’kwani mo tani aha/ mina maŋ /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Um gun ḵo/ki Tap̱a mo tani maŋi a’di mo ma, aris um gun ta iya/ ma Yakuub mo tani kari a’di ki ca mo ma, dhali doshi ki moŋḵo/ is gom a’di mo, aris um gun ta iya/ ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Haali/ a’di diki waḵa waḵ mo dhali shi/a shi/ i e mo gom monṯo’c bwa jin ṯoci wathi/ bwa mo. Dhali a’di diki bag jis/em piti ’peni wathi/ mo, hili a’di ciḵki ko mo me’d jin gwokina wathi/ ’twa/ i a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","’Peni /e mo tani a’di p̱u’dkina mom pem jin maŋka/ /e eya dhana tul ’kup̱ ki ’kwani mo, aris gwom pem kun oka/ is mo tani aha/ mina c̱i uni ibwambori uni gwansan kun ḵo/ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Wathi/ jin ṯo’ckunu bwa mo tani a’di midi shwa tonṯe/ mo tani dhali minu kap̱ mo, Dhali uni gwansan kun simmki a’di e mo tani uni mini maŋ Tap̱a mo. Dhalka dum bum ’kon ki sule/ sule/ ya ye ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Aris uni kun ’kokin isi ’pemen gi mony’ceshi ’baar mo tani uni a’di imini ka a’di e mo dhali ṯu’k e Tap̱a mo, dhala risa waḵ gi kal gi ’kwaniny’cesh mini luŋ ibwambori a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Haali/ mo jin tanu tap̱a a’di cila Tap̱a mo, dhali a’di ki jiya ris kal gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Nye, e a’di aris ’kwani kun dhu ’ba/ ki ca e mony’cesh mo tani mini dhu shush ka luŋgu’b mo. Ibwambori a’di mo tani uni mini luŋ mo, uni gun mini ii ka ’cesh mmowa e ki bu’da ’cesh mo, dhali a’di jin mol is piti kar ki e mo. ");
INSERT INTO udu_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Aris uni gun mini iiyu/ i’ko’d mo tani uni a’di imini mii a’di to mo. Dhali ’kwani mini ṯor gwo gom Tap̱a goma nyaḵum yil gi uc̱i gun mini p̱u’du/ i’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","dhali bah gwo gom mony’cuḵ piti mo gom uni gun ’konuki dho’th naskina/ mo, ki a’di a’di iwagaski a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Tap̱a a’di ta’da Manhil aha/ mo. Aha/ mina diki har to mo. ");
INSERT INTO udu_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","A’di karki aha/ mmo/ish ’ko’da shon dhii/i’d mo. A’di suski aha/ e shemen yi’de/ jin doshki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","A’di warki aha/ aḵashiram pem is mo. A’di suski aha/ e bway mii ma ḵar/e mo gom gway gi gway piti mo. ");
INSERT INTO udu_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ba isi waḵki/ aha/ mina ya e embul wosh ma la gi mowu mo tani aha/ yisa mina ḵo/ tonthus yisa, haali/ /e nyaḵki di ki aha/ mo. Ajap̱p̱am pini dhali cwam pini uni malaski aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","/E thosonki tonṯe/ ibwambori aha/ mo e buŋ’kus ma ris uni gun ta ’kup̱ ki aha/ mo. /E ’koshki aha/ ’kup̱ pem ka yin mo. Aḵubbaayam pem a’di ’tu’dki’d iwol ’kup̱a sho mo. ");
INSERT INTO udu_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ka jiŋ gana/ miim ’boron dhali momiimii mo tani uni mini baṯẖ aha/ nsho’k mo ka teem pemi ’baar mo jin dika/ ki e mo, dhali aha/ mina c̱a’b e gu’b gi Tap̱a ki sule/ sule/ ya ye ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Mony’cesh a’di ta jin Tap̱a mo dhali mon’tu’d piti mo, mony’cesh dhali uni gwansan gun ’koni bwaman a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Haali/ a’di nyaŋki a’diya p̱owa ris ḵumma/ yi’de/ mo dhali ṯel a’di sho’k mo ap̱owa ris yi’de/ kun son mo. ");
INSERT INTO udu_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Kaja a’di imidi shin ’kuwosh gi Tap̱a mo? Dhali kaja a’di imidi doshi mom piti jin ḵogu mo? ");
INSERT INTO udu_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","A’di ta a’di jin mina me’di dheleladhelel mo dhali adu jin dheleladhelel mo, a’di jin diki ’deka ḵashiram piti ’kup̱ ki gwo jin ’ce’du/ ’te/ ka ṯor mo dhali jin diki thul gwo me’da p̱o/ ka he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","A’di midi bu’th mom’bor mii ’peni Tap̱a mo, dhali mo gi yeyunum piti ’peni Arumgimis gi bway gi mowoṯẖ piti mo. ");
INSERT INTO udu_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Me’d uni ma nyaḵum yil gwansan kun simmki a’di e mo, uni gun simmki jis/e ma Arumgimis ma Yakuub e mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","’Deki ’kup̱ bum ki mis mo ma, ayy aris ’twaŋkala goŋ mo, dhali um minu ’de’k mo, ayy arisa campur kun tana dhamo/ mo, jin min ma Maliḵ gi monyca yayu/ bway bwaman mo. ");
INSERT INTO udu_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Kaja a’di ita’da Maliḵ gi monyca mo? Tap̱a a’di jin ta gi mom’bi’th mo dhali mo ma dem dem mo. Tap̱a a’di jin ta gi mo ma dem dem e mo ma mee mo. ");
INSERT INTO udu_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","’Deki ’kup̱ bum ki mis mo ma, ayy aris ’twaŋkala goŋ mo dhali um minu ’de’k mo, ayy arisa campur kun tana dhamo/ mo, jin min ma Maliḵ gi monyca yayu/ bway bwaman mo. ");
INSERT INTO udu_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Kaja a’di yansan ita’da Maliḵ gi monyca mo? Tap̱a gi momis mo, a’di ita’da Maliḵ gi monyca mo be. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","E /e mo tani ayy Tap̱a, aha/ ’de’kkina ḵashiram pem mo. ");
INSERT INTO udu_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Ayy Arumgimis pem e /e mo tani aha/ gamkina gwo is mo. Dhalku/ ki dhal aha/ ki aha/ minu kar ki mo ma ’the is mo. Dhalku/ ki dhal ris uni kun ta ’kup̱ ki aha/ mmoyuḵ gway ki moŋ’kuny bwa ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Nye, dhalki jan ṯal ’de/ jin c̱or /e ki kar ki mo ma ’the is mo ma. Dhalki uni dhunu ki mo ma ’the is mo, uni gwansan gun ’dap̱a e ki mii ma ’bar ’bar mo. ");
INSERT INTO udu_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Kari aha/ mmomish bway pini mo ma, ayy Tap̱a. Ṯori /e aha/ bway tur pini mo. ");
INSERT INTO udu_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Shuyi aha/ bway e gwoŋ ganam pini mo, dhali ṯori aha/ gwo mo, haali/ /e tana Arumgimis gi bway gi mowoṯẖ pem mo, haali/ aha/ c̱orkina /e ka tee ’baar mo isa yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Kayi momiimiim pini e mo, ayy Tap̱a, dhali mo/en pini jin ṯelu sho’k mo, haali/ uni ’kokin ’peni kadhamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Dhalku/ ki ka miinthus pem e kun miiga/ ki aha/ tana dhuru’c mo, walla ris gwon dhaŋ pem mo, isi ki gwo ki mo/en pini jin ṯelu sho’k mo tani kayi aha/ e mo, gom gway gi miim ’borgam pini mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Tap̱a a’di ’boro’d dhali ta jaŋ ḵar/e mo. Dhali gom gwo gi wakan mo tani a’di ki ye’th imanmii miinthus sho’k e bway ’boro’d mo. ");
INSERT INTO udu_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","A’di ki shuwa shu/um bway gom uni gun dhu is ki gwa’d e a’di jin ’boro’d mo, dhali ṯor imandhu is ki gwa’d bway piti mo. ");
INSERT INTO udu_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Aris bway tur gi Tap̱a mo tani uni ṯelu sho’k e mo/en mo dhala ris mii ma isiŋ gana/ mo, gom uni gwansan gun dhu gwom piti kun gamu me’d mo dhali gwonyc̱im piti gun c̱ina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Gom gway gi gway pini mo tani ayy Tap̱a, dhalki miim pem jin dika/ i’ba/ ’pen mo ma, haali/ a’di caaca mo. ");
INSERT INTO udu_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Ki wathi/ ja iḵo/ki Tap̱a mo? A’di imina a’di ye’th sho’k mo i bway jin mina a’di ikwany mo. ");
INSERT INTO udu_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","A’di ki is piti midi c̱a’b e mo jin isha to ka enthus mo, dhali uc̱im piti mini gam mal gi mony’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Mo jin nyaḵu to mii ki Tap̱a mo tani a’di gom uni gwansan gun ḵo/ki a’di mo, dhali a’di ṯorki’d eya tente/ e uni gwom piti jin gamu me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Em pem isa yempa/ c̱u’thki ’kup̱ki Tap̱a mo, haali/ a’di midi buḵ sho’k pem ’pena gume/ mo. ");
INSERT INTO udu_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Ṯuki /e e aha/ mo dhali miiyi mii ma ’the e aha/ mo, haali/ aha/ dina aha/ ’de/ dhali ṯocu bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","’Cuḵi aha/ ’peni mo ma ṯo’c bwa ma dum pem mo ma, dhali susi aha/ ka pije/ ’peni mo ma c̱is pem mo. ");
INSERT INTO udu_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Hili isi gwo e gom monṯo’c bwam pem mo dhali gom mo ma du mur pem mo, dhali gwami aha/ ’pena ris miinthus pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Hili isi gwo e ma haali/ ’kup̱ pem ŋala/ wana risa! Dhali ki mombujur jin shinuwa shi/i e mo tani uni shi/ki aha/ i e mo be. ");
INSERT INTO udu_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Ayy jiyi mondiki/em pem mo dhali ’cuḵi aha/ mo. Dhalku/ ki dhal aha/ bway ki aha/ minu kar ki mo ma ’the is mo, haali/ aha/ budha mo jin hurga/ jwa e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Dhalki mii jin miinu ki dar gi ŋadhum dhali miiŋḵar/e uni ’tash aha/ ’twa/ mo, haali/ aha/ c̱orkina c̱or gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Wani ’Kwani ma Israyiil ’ba/ mo ma, ayy Arumgimis, ’pena ris monṯo’c bwam buni mo. ");
INSERT INTO udu_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Yeyi aha/ mo ma, ayy Tap̱a, haali/ aha/ yana e yam pem ki ya jin dar gi ŋadhum mo, dhali aha/ gamkina gwo is e Tap̱a ki dar gi bwa jin shinu ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Nyo/i aha/ mo ma, ayy Tap̱a dhali pali aha/ mo. ’Cunycuri adum pem mo dhali bwam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Haali/ mo/en pini iṯeli sho’k ibwambori em pem mo. Dhali aha/ yana e ya ma isiŋ gana/ e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Aha/ dinaki nyaḵ c̱a’b ki ’kwani kun ta imanṯor gwonthus mo, walla aha/ dinaki ce e ki ’kwani kun ḵal mii ka bor mo. ");
INSERT INTO udu_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Aha/ shi/a mo jin cenu e ki imanmii tonthusi e mo, dhali aha/ mina diki nyaḵ c̱a’b ki a’di jin ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Aha/ mina ’thur me’d pem mo gom aha/ dina ka p̱o/ mo, dhali ya mo e mo ma gwaṯam pini jin ’ciṯẖu/ to ’kus mo, ayy Tap̱a, ");
INSERT INTO udu_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","mmoyuḵ gway ki ’kall ’kall mo, gway jin ’boruwa ’bor bwa i is mo, dhali mmoṯora ris miiny jarom pini kun miina /e mo. ");
INSERT INTO udu_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Ayy Tap̱a, aha/ ena mo kun ’konu e gu’b pini mo, dhali e mo jin dina monycam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Dhalku/ ki tor aha/ sho’k ka pupush nyaḵki imanmii miinthus mo, walla mondiki/em pem nyaḵki ’kwani kun ’kosha ṯe/ ma nyor mmowol ’kwani abasa ’cesh mo, ");
INSERT INTO udu_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","’kwani uni gun nyo/a me’d ki nyo/ gom tonthus kun p̱ishinkina uni ki mii mo dhali me’da bim poros buni uni ’tu’dkunu ki mowan ’kwani is mo. ");
INSERT INTO udu_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Hili gom aha/ mo tani aha/ yana ki yam pem ki ya jin dar ki ŋadhum mo. Wani aha/ ’ba/ mo dhali miiyi mii ma ’the e aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Sho’k pem doshki’d e mo ma ’cesh jin ba’da/ ba’d mo. Eya dhana buhany ’kwani mo tani aha/ mina ’bor Tap̱a mii mo be. ");
INSERT INTO udu_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Tap̱a a’di ta moŋkush pem mo dhali bway gi mowoṯẖ pem mo, kaja a’di imiga/ ḵo/ mo? Tap̱a a’di ta’da cur jin ṯelu gwo sho’k mo gom mondiki/em pem mo, dhali kaja a’di imiga/ ḵo/ is mo? ");
INSERT INTO udu_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Ki imanmii tonthus tiḵki aha/ e mo tani uni thu’thkina thu’th ’pen kagahara ap̱o/ aha/ mo, uni gun ta ’kup̱ ki aha/ mo dhali kun ’kwarkina ’kwar ka gwap̱i/ mo tani uni mini ḵal ’bar mo dhali ṯa’k mo be. ");
INSERT INTO udu_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ba aris uni kun ’kamkina ’kam ap̱o/ aha/ mo tani adum pem yisa ḵo/ is yisa. Ba ki mo ma mee cuu’da p̱o/ aha/ mo tani hili aha/ mina wu is ka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ton ṯal ’de/ doṯkika/ ’peni Tap̱a mo, a’di jin miga/ simm e mo mmobaṯẖi ’ko’d mo, ki aha/ mina c̱a’b e gu’b gi Tap̱a mo ka risa cim pemi ’baar mo ki mondiki/em pem mo, mmohil monyjaro/ gi Tap̱a mo, dhali mmohil isi gwo i e mo gom gu’b gi mondheleladhelel piti mo be. ");
INSERT INTO udu_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Haali/ a’di midi bag aha/ eya darha’dam piti mo ka tee jin ṯocu aha/ bwa mo. A’di midi bag aha/ e bwaŋ’kwariny gi gu’b burrinyem piti mo. Dhali a’di midi kar aha/ i’kuwosh jin turatur mo. ");
INSERT INTO udu_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Dhali shwane/ ’kup̱ pem minu ’de’k ki mis mo ap̱owa ris uni gun ta ’kup̱ ki aha/ mo kun ’kamki aha/ is mo be. Dhali aha/ mina c̱i to jin ’ciṯẖu/ ’kus mmomiiya bas e gu’b burrinyem piti mo ki cuuwa/ gi moŋ’kuny bwa mo. Dhali aha/ mina yuḵ gway mo dhali mii ko gom Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Ciḵi ko mo ma, ayy Tap̱a, ki aha/ ’thera cuuwa/ kagahara mo. Miiyi mii ka ’the gom aha/ mo dhali thoḵi aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","/E oki gwo mo ki: Simmi um bwam/em pem e mo. Adum pem o gwo gom /e mo ki: Bwam/em pini Tap̱a, a’di isimmkika/ e mo be. ");
INSERT INTO udu_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Dhalku/ ki bag bwam/em pini ’peni aha/ mo. Dhalku/ ki ṯu’k c̱iŋkinam pini jin mii /e to ka nyor mo, /e jin tana manwoṯẖ pem ’thissa/ mo. Dhalku/ ki biṯ aha/ asho mo, dhali dhalku/ ki dhal aha/ ’pen mo, ayy Arumgimis gi mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Haala babam pem dhali ata’dam pem uni dhalki aha/ ’pen mo, hili Tap̱a a’di imidi hil aha/ i e mo. ");
INSERT INTO udu_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Ṯori aha/ bway pini mo ma, ayy Tap̱a, dhali susi aha/ e bway tur jin ba’da/ ba’d mo haali/ goma ris uni kun ta ’kup̱ ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Dhalku/ ki c̱i aha/ ki bwa gi uni kun ta ’kup̱ ki aha/ mo, goma ris iman/o gwonthus cukina p̱o/ aha/ mo dhali uni wukina shure/ gom mombujur mo. ");
INSERT INTO udu_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Aha/ gama gwo is ki aha/ mina p̱ar miim ’boro’d gi Tap̱a e mo e mo jin ’kona ’kwani ki e mo. ");
INSERT INTO udu_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","C̱ori Tap̱a mo ma, dhali ’bithi is mo dhali dhalka dum pini bu’th mo jin roc̱u sho’k mo. Nye, c̱ori Tap̱a mo ma. ");
INSERT INTO udu_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","E /e mo tani, ayy Tap̱a, aha/ yuḵkina /e mo. /E jin ta wosh pem mo, dhalku/ ki ta a’diye/ gom aha/ mo, isi ciki/ waḵki/ /e mini ’taki c̱a’b ki shwamm gom aha/ mo tani aha/ mina e waki uni gwansan gun iin ka luŋgu’b e jisa ’kulga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ciḵi ’twam pem jin oka/ gwo gom mo ma di’b is pem jin di’bka/ mo ma, me’d jin gwoka/ ’twa/ i /e gom mowoṯẖ mo, me’d jin ’de’kkika/ me’d pem ki mis mo ’kup̱ ki mom pini jin miinu to jin ḵogu mo jin bol tiya e mo. ");
INSERT INTO udu_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Dhalku/ ki nu’th aha/ ’ban nyaḵki imanmii tonthus mo, nyaḵki uni gwansan kun ta imanmii to kun ta thus ki thus mo, uni gun ṯorkina ṯor gom moŋḵu’th is nyaḵki imannyaḵ ’kom buni mo, ki mo ma pibi ’kokin eya dum buni mo. ");
INSERT INTO udu_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Raḵi uni to ibway isi ki tom buni kun miina uni mo, dhali isi ki tonthus buni kun miikina uni mo. Raḵi uni to ibway isi ki miin to kun miina uni ki me’d buni mo. Garki uni to ’kusi ’twa/ kun mina uni gam mo. ");
INSERT INTO udu_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Haali/ uni ’koki dhu miin to gi Tap̱a mo, walla miin to ki me’d piti mo. A’di midi ’ce’d uni ka ’cesh mo dhali midi diki nyaŋ uni ki mis doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Mom’bor mii midi di gom Tap̱a mo! Haali/ a’di ciḵki ’twam pem goma di’b is jin di’bkika/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Tap̱a a’di ita mom’bi’th pem mo dhali agoŋgorom pem mo. E a’di mo tani adum pem gamki gwo is mo be. Wakan aha/ woṯẖkunu mo dhali adum pem midi ya i mis mo, dhali ki gway pem jin miga/ yuḵ mo tani aha/ mina c̱i a’di mo jin ’boruwa ’bor bwa i is mo. ");
INSERT INTO udu_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Tap̱a a’di ita mom’bi’th gom ’kwanim piti mo. A’di ta mo jin huru jwa jin tanu is ki me’d mo gom a’dim piti jin ’koshu ki monyca mo. ");
INSERT INTO udu_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Ayy tayi ’kwanim pini is ki me’d mo ma, dhali ’bori mal pini mii mo. Tayi /e Amanhil uni mo dhali ḵali uni ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","C̱iyi Tap̱a monyca mo, ayy um gun ’koni momis mo, C̱iyi Tap̱a monyca mo dhali mom’bi’th mo. ");
INSERT INTO udu_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","C̱iyi Tap̱a monyca ki gway piti mo dhali luŋi Tap̱a e monyjarom piti jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","’Twa/ gi Tap̱a a’di diki’da p̱owa ris yi’de/ mo. Dhali Arumgimis ki monyca a’di ta ’twan tor ma sho’k mo, Tap̱a jin di’da p̱owa ris yi’de/ ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","’Twa/ gi Tap̱a a’di ta gi mom’bi’th caaca mo, dhali ’twa/ gi Tap̱a a’di ’tu’dkunu mo ki mo/eḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","’Twa/ gi Tap̱a a’di ’ce’dki cwa kun wana e ka bwanyayiis bwa mo, Tap̱a a’di ’ce’dki cwa kun wana e ka bwanyayiis bwa mo kun ta cwa gi Pan Lubnaan bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","A’di ki kar cwa yan e Pan Lubnaan mmop̱eya ŋalbothoŋ mo me’d ari bip̱ mo, dhali ’Kuwosh Siryuun me’d dhuru’c ari morbip̱ mo jin shwa’da nyor ka nyor mo. ");
INSERT INTO udu_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","’Twa/ gi Tap̱a a’di dhi’thki mo ka le’dan o’d ki ’bala’c ’bala’c mo. ");
INSERT INTO udu_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","’Twa/ gi Tap̱a a’di yiḵinki mombwaasho is mo, Tap̱a a’di yiḵinki mombwaasho is ki Paŋ Kaadish mo. ");
INSERT INTO udu_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","’Twa/ gi Tap̱a a’di ki dhu abuyymo mmodho’th ushan mo dhali mmo’cwar ’cemen gi bwanycwa mo. Dhali e gu’b gi mondheleladhelel piti mo tani aris ’kwani ’baar mo cuun ki: Monyca mo. ");
INSERT INTO udu_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Tap̱a a’di c̱a’bki’da p̱owa ḵursi ap̱owa gannu/ yi’de/ mo, Tap̱a a’di c̱a’bki’da p̱owa ḵursi ma maliḵ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Dhalki Tap̱a c̱i mom’bi’th piti ki ’kwanim piti mo. Dhalki Tap̱a ’bor ’kwanim piti mii ki moŋḵu’th is mo. ");
INSERT INTO udu_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Aha/ mina kar /e ki ca mo, ayy Tap̱a, haali/ /e ’de’kki aha/ ki mis mo, dhali /e diki dhal uni gwansan bway mo kun ta ’kup̱ ki aha/ mo mmo’kuny bwa ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Ayy Tap̱a Arumgimis pem, aha/ gwona ’twa/ e /e gom mowoṯẖ mo, dhali /e wac̱ki aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Ayy Tap̱a, /e ’cwamkina aḵashiram pem ’pena Haawiya mo, dhali war aha/ mondiki/em pem is mo ’peni bwaman uni gwansan kun iikin ka luŋgu’b e jisa ’kulga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Yuḵi gway mmomaŋ Tap̱a mo, ayy um piti kun dhunu ki she/ ki dhelel dhelel mo, dhali c̱iyi a’borim bwa i is gom gway piti jin ḵogu mo, ");
INSERT INTO udu_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Haali/ anyor piti di’d mo hili jasi gom ari mo mo, dhali mii ma ’them piti a’di di’d ki sule/ sule/ mo. Ko jin gwonu a’di midi di gom mon’thiny mo tani hili moŋ’kuny bwa a’di p̱u’dki’d mon’thamo/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Haali/ me’d aha/ mo tani aha/ ona gwo e mom pem jin isha to ka enthus mo ki: Aha/ minu ’koki joc̱ ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ki mii ma ’them pini mo, ayy Tap̱a, /e ṯelki aha/ sho’k mo me’d ’kuwosha turga/ jin ’bitha’bi’th mo. /E bagki jis/em pini mo tani dhali aha/ merkina mo. ");
INSERT INTO udu_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","E /e mo tani ayy Tap̱a, aha/ gwokina mo dhali e Tap̱a mo tani aha/ karkina mo jin di’buwa di’b is mo. ");
INSERT INTO udu_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","To wakata midi ’dap̱ e mowum pem mo waḵki/ aha/ yana ka ’cesh e jisa ’kulga/ mo? A/dhali mina bu’da ’ceshi maŋ /eya? A/dhali mina a’di iṯor mom pini jin tana /e a/isiŋ gana/ mowa? ");
INSERT INTO udu_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Ciḵi gwo mo ma, ayy Tap̱a, dhali miiyi mii ma ’the gom aha/ mo. Ayy Tap̱a, wari /e ka manwoṯẖ aha/ mo ma. ");
INSERT INTO udu_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","/E ṯu’kki moŋkom pem ki mo jin p̱eka/ imis mo. Dhali /e ’cuḵki aha/ burrinyen shawaal mo dhali ’kam aha/ ki moŋ’kuny bwa mo, ");
INSERT INTO udu_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","ka ḵashiram pem midi maŋ /e mo dhali diki di ki shwamm mo. Ayy Tap̱a Arumgimis pem mo, aha/ mina c̱i /e mo jin ’boruwa ’bor bwa i is ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","E /e mo tani ayy Tap̱a, aha/ simmkina mom pem jin huru jwa e mo. Dhalku/ ki dhal aha/ bway ki aha/ minu kar ki mo ma ’the is mo. E mo ma ḵar/em pini mo tani ’cuḵi aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Kari ’cem pini gom aha/ mo ma. ’Cwami aha/ ki ’ta’b mo. Wari /e ki wosh jin miga/ hur jwa mo, dhali mmota acur jin ’bitha’bi’th jin midi ta aha/ is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nye, /e ta wosh pem mo dhali acur pem mo, gom gway gi gway pini mo tani susi aha/ mo ma dhali shuyi aha/ bway mo. ");
INSERT INTO udu_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Susi aha/ ka pije/ ’pena gume/ jin bagkunu gom aha/ mo, haali/ /e ta jim pem jin hurga/ jwa mo. ");
INSERT INTO udu_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","E me’d pini mo tani aha/ c̱ikina shi/in pem mo. /E wanki aha/ ’ba/ mo, ayy Tap̱a, Arumgimis jin ta isiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","/E shi/ki uni gwansan i e mo uni gun c̱ina hirdhe/ ki p̱e’th ki tomp̱inycon kun luŋu mo. Bahili aha/ gamkina gwo is e Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Aha/ mina bwa ’kuny mo dhali ’bor mo gom mo/en pini jin ṯelu sho’k mo, haali/ /e hilki mom pem jin ṯocu aha/ bwa mo, dhali /e yip̱ki ’kup̱ mo goma ris uni kun ta ’kup̱ gi aha/ mo, ");
INSERT INTO udu_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","dhali /e diki c̱i aha/ e me’d gi uni kun ta ’kup̱ gi aha/ mo. /E dhuki sho’k pem e mo ma ’cesh jin beeyabee mo. ");
INSERT INTO udu_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Miiyi mii ma ’the gom aha/ mo, ayy Tap̱a, haali/ aha/ dina e mo ma c̱is mo. Em pem shi/ki is mo gom jwakaṯ jin jwakaṯki’d mo, eya ḵashiram pem mo dhali buŋgwar is pem si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Haali/ mondiki/em pem ’baaru mo jasi ki mondiṯ bwa mo, dhali yil pem ki jasi mowuwa shure/ mo. Mom’bi’th pem ushki me’d mo gom mondim pem jin ’bushura/ ’bushur mo, dhala simam buŋgwar is pem tana ’kala/ ’kala/ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Aha/ tana jin ṯẖunyu/ ’twa/ i is ka ris uni kun ta ’kup̱ ki aha/ mo, dhali aha/ shi/u i e ki uni gun nyaḵ ’ko ki aha/ mo, dhali aha/ tana to jin guna uni ki e mo ki moŋḵo/ is mo, unim pem kun mishi aha/ mo, dhali uni gwansan kun p̱arki aha/ e mo e bway tur mo tani uni ’cuḵki aha/ i ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Aha/ ŋakunu me’d jan ’de/ jin wuki’d mo. Dhali aha/ wakina e ki toŋ’kul bwa jin waki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Nye, aha/ ciḵkina ris ’kwani ’baar mo shilki gwalish mo mmo’dowa ŋur ŋur ’twaŋkal kuku/ mo, me’d jin ’tuntulkina uni isi monṯal ’de/ ap̱o/ aha/ mo, me’d jin wu’thkina uni awu’th mmobu’th mondiki/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Hili aha/ gamkina gwo is e /e mo, ayy Tap̱a. Aha/ ona gwo mo ki: /E tana Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Mom pem uni ’kon e me’d pini mo. ’Cuḵi aha/ mo ’peni me’d ma ris uni gun ta ’kup̱ ki aha/ mo dhali uni kun ṯo’cki aha/ bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Dhalki bwam/em pini a’di kushu mo mo e c̱iŋkinam pini mo. Tayi aha/ is ki me’d mo e mo/en pini jin ṯelu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Dhalku/ ki dhal aha/ mo mmodi ki mo ma ’the is mo, ayy Tap̱a mo, haali/ aha/ yuḵkina /e mo. Dhalki uni kun mii tonthus idhukunu ’te/ ki mo ma ’the is mo dhali dhalki uni ii ’ce us kan e mo ma Haawiya mo. ");
INSERT INTO udu_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Dhalka le’d kun tana ṯor tana ’diye/ mo, uni oki gwo sor ap̱o/ uniŋ ḵar/e mo e mo jin dhuna uni ’ba/ ki ca mo dhali mo ma bujur mo. ");
INSERT INTO udu_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ayy mom’boro’d pini wa’di ish ka enthusa! A’di jin karkina /e gom uni gwansan kun ḵo/ki /e mo dhali wagas mo gom uni gwansan kun bu’thki mo jin huru jwa e /e mo, e jis/e gi iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Dhali buŋ’kus pini mo tani a’di ibagki uni mo ’pena risa wu’th gi ’kwani mo. /E dhuki uni ki ’dantar e bwaŋ’kwariny ma darha’dam pini mo ’pena risa le’d jin biruwa bir mo. ");
INSERT INTO udu_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Mom’bor mii midi di gom Tap̱a mo, haali/ a’di wa’di ’bora mmoṯor mo/en piti jin ṯelu sho’k e aha/ mo ki aha/ karu mo mmohem me’d ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Aha/ okina gwo e mo ma ayy/ayy/ayy pem mo ki: Aha/ borkunu ki ’bal ’bal itaga dhana/ mo ’peni jis/em pini mo. Hili /e ciḵki mom pem jin di’bkika/ di’b is mo ki aha/ gwokina ’twa/i /e gom mowoṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Eni Tap̱a mo, aris umi ’baar mo kun ta kum piti kun dhunu ki she/ ki dhelel dhelel mo. Arumgimis dhuki uni kun ta ku isiŋ gana/ mo, hili tom piti kun mina a’di iraḵ ’kwani to ibway ishki’d ka enthus mo gom uni kun ḵalki mii mo mmo’theḵ ’ba/ imis mo. ");
INSERT INTO udu_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","’Bithi is mo dhali dhalka dum pini bu’th mo jin roc̱u sho’k mo, aris umi ’baar mo kun c̱orki Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Mom’bor mii gom a’di jin gwamkunu gwon dhaŋ piti mo, a’di jin ta miinthus piti jin kumkunu ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Mom’bor mii gom wathi/ jin dina Tap̱a ki yer is ki gway gom miinthusa kamu/ mo, dhali e shi/in piti mo tani mo ma he’k e p̱iyi’d mo. ");
INSERT INTO udu_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ki aha/ dinaki ṯor gwo miinthus pem mo tani buŋgwar is pem a’di muṯṯi’di ’baar mo e mo/ohon pem ka tee ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Haali/ montee dhali mon’thiny mo tani me’d pini diṯadiṯ ap̱o/ aha/ mo. Mom’bi’th pem a’di ḵu’thki’d mo me’d mom’batha’d jin ’koshki to moyurantee mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Aha/ nyiṯẖkina miinthus pem e /e mo dhali aha/ dinaki bag miinthus pem mo. Aha/ ona gwo mo ki: Aha/ mina pi gwon dhaŋ pem ki Tap̱a mo. Dhali yan’ko’d /e gwamki aha/ gom miinthus jin di aha/ i’ba/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Wakan dhalka ris ’kwani ’baar mo kun tana gayiin ’thon e /e mo. Ka tee ma c̱is mo, dhali ka tente/ kun sona dhan yi’de/ mo tani uni mol a’di gam mo. ");
INSERT INTO udu_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","/E ta mombag gom aha/ mo dhali /e ’tashki aha/ ’twa/ mo ’peni monṯo’c bwa mo. Dhali /e ’kamki aha/ ki mony’cuḵ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Aha/ mina ye’th /e sho’k mo dhali ṯor /e bway jin mina /e iya mo be. Aha/ mina logom /e ki gwo mo ki em pem jin midi di ap̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Dhalku/ ki wa e ki shumarum walla bagal kun mol ’twa/ wal mo, uni kun minu ’kali’th is mo dhali ’kamu’th ’twa/ ka lijaam mo isi ciki/ ki uni mini ’koki so ’peni /e mo. ");
INSERT INTO udu_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","To kun diṯ bwa gom ’kwani kun ta thus ki thus mo tani uni tana ris mo, hili mo/en jin ṯeli sho’k mo a’di ’kam a’di is mo a’di jin gamki gwo is e Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","’Bori bwa e Tap̱a mo dhali ’kunyi bwa mo ayy um ’kwani kun tana ḵar/e mo, dhali ḵumi cuuwa/ gom moŋ’kuny bwa mo, aris um kun dhelel ma du mo. ");
INSERT INTO udu_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","’Kunyi bwa mo ma e Tap̱a, ayy um ’kwani kun tana ḵar/e mo. Maŋa maŋ jin ’dap̱a’d gom uni kun dhelel ma du mo. ");
INSERT INTO udu_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Maŋi Tap̱a ka dheŋdhenye/ jin buḵu/ mo, dhali yuḵi gway gom a’di ka dheŋdhenye/ jin ’kon ma shu/i ’kume’d mo. ");
INSERT INTO udu_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Yuḵi gway gom a’di, gway jin ta jin this mo, buḵa shu/ ki me’d jin ta gwocon mo, ki ’kus jin caaca mo. ");
INSERT INTO udu_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Haali/ gwo gi Tap̱a mo tani uni ha me’d mo. Dhali aris miim piti uni miikunu ki mii ma isiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","A’di enki momii ma ḵar/e mo dhali mo jin miinu ki dar gi mo ma gwar ’de/ mo. Mony’cesh a’di ’tu’du/ mo ki mo/en gi Tap̱a jin ṯeli sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Ki gwo gi Tap̱a mo tani momis uḵkunu mo dhali aris to kun ’koni bwaman uni ki shi/in jin shi/ini’d ’peni ’twam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","A’di ki tula ris yi’de/ is mo dhali ḵumma/ yi’de/ mo me’d jin ’thuṯẖu/ uni ibwaman ma gasaas mo. A’di ki dhu yi’deŋ ’kulga/ e mo kun dhunu to mo. ");
INSERT INTO udu_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Dhalki aris ’kwani ’baar kun ’kon e mony’cesh ḵo/ Tap̱a mo. Dhalki aris ’kwani ’baar kun ’kon e mony’cesh doshon ki moŋḵo/ is gom a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Haali/ a’di ṯorki gwo mo tani dhali a’di p̱u’dki’d kan mo. Dhali a’di ḵanki gwo mo tani dhali gwo doshki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Tap̱a ki ḵal gwo kun logoma kal gi ’kwaniny’cesh mo mmota gwo jin di bwa ’te/ mo. A’di ki non mo jin thosona ’kwani ’kup̱ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Gwo logom gi Tap̱a mo tani a’di doshki’d ki sule/ mo. Gwoŋ kulum eya dum piti mo tani a’di diki’d ki sule/ goma risa nyaḵum yil gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Mom’bor mii gom kal gi ’kwani jin tan ma Arumgimis Tap̱a mo, ’kwani kun kwanykina a’di mo mmota mal piti mo. ");
INSERT INTO udu_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Tap̱a hilki mo ka luŋgu’b ’peni momis mmop̱ara ris iya/ gi ’kwaniny’cesh e mo. ");
INSERT INTO udu_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","’Peni mo jin c̱a’bkina a’di eya ḵursi ma maliḵ mo tani a’di ki hil mo mo ap̱owa ris ’kwani gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","A’di ta a’di jin aḵki’da dum buni e ’baar mo, dhali a’di ki hila ris miim buni kun miina uni mo. ");
INSERT INTO udu_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Amaliḵ a’di ’konuki ta is ki me’d ki dhan ’kwani ma meem piti mo. Wathi/ gom mo ma mee mo tani a’di ’konuki ’cuḵ ki dhan mom’bi’th piti mo. ");
INSERT INTO udu_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Shumarum gi mo ma mee mo tani a’di ta tom p̱e’th gi mo ma ’teŋ kap̱e/ gi mo jin p̱inu mii e mo. Dhali ki dhan mo ma ’bi’th ma dem dem piti mo tani a’di molu ta is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Hili mo mo ma, e gi Tap̱a a’di di’d ap̱o/ uni gwansan kun ḵo/ki a’di mo, ap̱o/ uni gwansan kun takin gi mo ma ’teŋ kap̱e/ gi mo/en piti jin ṯelkunu sho’k mo, ");
INSERT INTO udu_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","ki a’di midi ’cuḵa ḵashiram buni ’peni mowu mo, dhali dhu uni ki e mo e yil jin ’kosha ṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Aḵashiram bana a’di c̱orki Tap̱a mo. A’di ta’da Manwoṯẖ gom ana mo dhali agoŋgorom bana mo. ");
INSERT INTO udu_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Nye, adum bana ’kunykina bwa mo e a’di mo haali/ ana gamkina gwo is e gway piti jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Dhalki mo/en pini jin ṯelu sho’k, ayy Tap̱a, di’d eya p̱o/ aman mo, isi kani, me’d jin tana aman ka ’teŋ kap̱e/ e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Aha/ ’bora Tap̱a mii isa yempa/ mo. Momaŋ midi di isa yempa/ e ’twam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Aḵashiram pem kar is ki ca e Tap̱a mo. Dhalki uni gwansan kun ’koshu ki isa nyor ciḵ a’di mo dhali ’bor bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ayy kari Tap̱a ki ca nyaḵki aha/ mo, dhali dhalki ana kara gway piti ki ca imonṯal ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Aha/ ŋap̱kina Tap̱a mo dhali a’di thoḵki aha/ ’twa/ mo, dhali ’cuḵ aha/ mo ’pena ris moŋḵo/ is pem mo. ");
INSERT INTO udu_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Hili ’kup ki a’di mo dhali kushi mo mo wakan ki bwam/em bum mini ’koki ’ko ki mo ma ’the is mo. ");
INSERT INTO udu_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Wathi/ ha’th’ko’d yan gwoki’d mo dhali Tap̱a ciḵki a’di mo dhali ta a’di is ki me’d mo ’pena ris monṯo’c bwam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Aman’doyu gwo gi Tap̱a ’kamki’da ’kam ka kul is gom uni gwansan kun ḵo/ki a’di mo, dhali ’cuḵ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Ayy nyoḵi ma dhali p̱ar e ki Tap̱a ’boro’d mo. Mom’bor bwa gom wathi/ jin bu’thki mo jin huru jwa e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Ayy ḵoki Tap̱a mo um piti kun dhunu ki she/ ki dhelel dhelel mo, haali/ uni gwansan kun ḵo/ki a’di mo tani ’kona ton tiya ki har mo. ");
INSERT INTO udu_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Ushi dhuruca dhop̱ uni hari to mo haali/ uni ’kosha ṯe/ mo hili uni gwansan kun simmki Tap̱a e mo tani uni ’koki har tom ’boro’da kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Iiyu/ ma, ayy iya/ mo, ciḵi gwo ’peni aha/ mo. Aha/ mina ṯor um gwo gom moŋḵo/ is gom Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Wathi/ jana i/ona bwa ki mondiki/e mo, dhali ’thoṯẖ bwa ka yempa/ ki a’di mina bwa ’kuny ka yempa/ gom tom ’boro’d mo? ");
INSERT INTO udu_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Nona le’d pini ’twa/ ’peni gwon thus mo dhali ’twam pini mmo/o gwo ka he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ḵwa/i bwa mo ’peni tonthus mo dhali miiyi ki ’bore/ mo. Simmi moŋḵu’th is e mo dhali uri a’di isho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","E gi Tap̱a a’di di’da p̱o/ uni kun miin ka ḵar/e mo dhali ’cem piti ’kup̱ ki kom buni mo. ");
INSERT INTO udu_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Bwam/e gi Tap̱a di’da p̱o/ imanmii tonthus mo, ki uni minu ’ciṯẖ ’twa/ mo ki uni minu ’koki doḵ/e ka e e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Ki uni kun mii miiŋḵar/e gwokin gom mowoṯẖ mo tani Tap̱a ciḵki uni mo dhali ’cuḵ uni mo ’peni aris monṯo’c bwam buni mo. ");
INSERT INTO udu_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Tap̱a ’disha’dish ka yempa/ e uni kun ’ce’dkunuwa du mo dhali ta uni is ki me’d mo uni kun siri’ckunu shi/in ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Monṯo’c bwa tana ris gom a’di jin mii miiŋḵar/e mo, hili Tap̱a ’cuḵki a’di ’peni uni ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","A’di ki dhuwa risa simam piti ’baar mo. Simam pitiŋ kamu/ yisa ’ce’dkunuwa. ");
INSERT INTO udu_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Tonthus jin miinu midi ’kosha manmii tonthus mo, dhali uni gwansan kun shi/ki ’kwani kun mii miiŋḵar/e i e mo tani minu waḵ mo be. ");
INSERT INTO udu_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Tap̱a a’di wanki mondiki/e gi c̱iŋkinam piti ’ba/ mo. Jan ṯal ’deŋ kamu/ ’peni uni gwansan kun bu’thki mo jin huru jwa e a’di mo tani minu ’koki waḵ mo be. ");
INSERT INTO udu_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Jemi ajem ’kup̱ mo ma, ayy Tap̱a, nyaḵki uni gwansan kun jemki aha/ ’kup̱ mo. Asi ap̱o/ uni gwansan kun askin ap̱o/ aha/ mo ma. ");
INSERT INTO udu_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Bu’thka goŋgoro/ ki me’d mo dhali to mmocesh is mo dhali cuyi mis gom mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","’Deka mee she mis mo dhali ameeny ’ciṯẖ is mo apo/ uni kun urki aha/ isho’k mo. Oyi gwo goma ḵashiram pem mo ki: Aha/ tana man’cuḵ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Dhalki uni dhukunu ’te/ ki mo ma ’the is mo dhali ush taḵ mo uni gwansan kun simmki mondiki/em pem e mo. Dhalki uni ṯu’kkunu ka nyaŋ’ko’d mo dhali non ’twa/ mo uni kun p̱ishinki mo gi ’pen mo mmomii tonthus ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Dhalki uni wana e ka ’pi’b ibwambori ’tham mo ka man’doyu gwo gi Tap̱a ki ur uni ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Dhalki bway buni ta’da ’tum mo dhali dheresa dheres mo, ka man’doyu gwo gi Tap̱a ki ur uni isho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Ki dar gi ’kup̱ mii mo tani uni bagkina gumem buni gom aha/ mo. Dhali ki dar gi ’kup̱ mii mo tani uni c̱wanyki jis gom mondiki/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Dhalki mo kun toru sho’k ka pupush p̱u’du’d ap̱o/ uni ki e ka wu mo. Dhalka gumem buni kun baga uni mo tani bu’th uni mo. Dhalki uni ṯa’kkin ibwaman uni mmo’ce’d sho’k ka pupush mo. ");
INSERT INTO udu_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Dhali yan’ko’d aḵashiram pem ’kunya bwa e Tap̱a mo mmoyuḵ gway mmomaŋa maŋ gom mony’cuḵ piti mo. ");
INSERT INTO udu_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Arisa simam pem mini o gwo mo ki: Ayy Tap̱a, kaja a’di jin waki /e mo, /e jin ’cuḵ a’di jin ’ka’da is ki ’ka’d mo ’peni a’di jin ’bitha’bi’th gom a’di mo, dhali a’di jin ’ka’da is dhali a’di jin midi mii ta gi to mo ’peni a’di jin shi/ki a’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Iman/o gwo kun dup̱una dup̱i e mo tani uni cuki mis ap̱o/ aha/ mo. Uni doṯki aha/ to kun ’koka/ ki mish ’ban mo. ");
INSERT INTO udu_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Uni ki c̱i aha/ tonthus ka nyaŋ’ko’d gom tom ’borga/ kun miiga/ gom uni mo. Aḵashiram pem a’di ’bushura/ ’bushur mo. ");
INSERT INTO udu_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Hili aha/, ki uni ’ba’thkin mo tani – aha/ hi’thkina burrinyen shawaal mo, aha/ shi/kina is pem ki moŋga/ to mo. Aha/ ’thokina ki ’kup̱ pem jin karka/ ka luŋgu’b abor pem mo ");
INSERT INTO udu_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","me’d jin jwakaṯkunu aha/ adu goma mugum pem mo dhala kam pem mo. Aha/ yakina ka kul is me’d jan ṯal ’de/ jin gwoki’d goma ta’dam piti mo, mmobiṯ ’kup̱ ka luŋgu’b dhali ko ki gwony jabu’th mo. ");
INSERT INTO udu_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Hili e mombiṯ pem mo tani uni tulki is mo mmop̱e’th ki ḵuss ḵuss mo, uni tulki is mmonṯal ’de/ ap̱o/ aha/ mo. Uni kun ta ŋwol kun molka/ mo tani thu’thki aha/ ’pen ki dar gi mondaḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Uni c̱i aha/ ṯinya/ ka maḵ mo ki nyanye/ dhali ki nyanye/ mo. Uni ’pe’dki aha/ shem buni i is mo. ");
INSERT INTO udu_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Kakasja, ayy Tap̱a, mina /e c̱a’bi gu is mo kan? ’Cwami aha/ mo ’peni mo ma bujur buni kun ’ce’du sho’k mo, mondiki/em pem ’pena risa dhop̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Dhali yan’ko’d aha/ mina c̱i /e mom’bor bwa i is e bwaman ma waambuhany ’kwani mo. Dhali e mom’bi’th ma waambuhany ’kwani mo tani aha/ mina maŋ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Dhalku/ ki dhal uni gwansan bway mo mmo’kuny bwa ap̱o/ aha/ mo uni kun mii aha/ ki shi/ kun ta ’kup̱ ki aha/ mo, dhali dhalku/ ki dhal uni gwansan bway mo mmoshi’b e kun shi/ aha/ i e ki dar gi miiŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Haali/ uni ’koki o gwo gom moŋḵu’th is mo, hili ap̱o/ uni gwansan kun ’kon ki biyuu e mony’cesh mo tani uni bwaaki gwo kun hekuwa he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Uni ḵa’dki ’twam buni kun beeyabee ap̱o/ aha/ mo. Uni oki gwo mo ki: Soso soso. Em bana p̱arki a’di e mo. ");
INSERT INTO udu_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","/E mishkin mo, ayy Tap̱a. Dhalku/ ki c̱a’b ki shwamm mo ma, ayy Tap̱a, dhalku/ ki si’d ’peni aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Muri is pini mo ma, dhali meri is gom tom pem jin raḵ aha/ mo, dhali tom pem jin p̱u’du’d mo. Arumgimis pem mo dhali Tap̱am pem mo. ");
INSERT INTO udu_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yeyaa/ mo, ayy Tap̱a, Arumgimis pem, isi ki mii ma ḵar/em pini mo, dhali dhalku/ ki dhal uni bway mo mmo’kuny bwa ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Dhalku/ uni ki dhal bway mo mmo/o gwo e is buni mo ki: Soo, ana tana gi to kun on ma dum bana mo. Dhalku/ uni ki dhal bway mo mmo/o gwo mo ki: Ana loskina a’di ki ’kolo’c mo. ");
INSERT INTO udu_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Dhalki uni dhunu ki mo ma ’the is mo dhali duŋguru/ ka du isi monṯal ’de/ mo uni kun ’kunykina bwa mo ap̱owa c̱is pem mo. Dhalki uni kumu is ki mo ma ’the is mo dhali ki mo jin ushuwa taḵ taḵ mo, uni kun dhu is buni ki ca ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Dhalki uni gwansan kun ’kona gwo i bwa gom moyem pem ḵum cuuwa/ mo gom moŋ’kuny bwa mo dhali mom’bor bwa mo, dhali o gwo ki sule/ sule/ mo ki: Tap̱a a’di caaca mo, a’di jin ’kunya bwa e miin to gi c̱iŋkinam piti jin gama a’di adu is mo. ");
INSERT INTO udu_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Dhali yan’ko’d ’twa/ pem midi ṯor gwo gom mii ma ḵar/em pini mo dhali momaŋ pini isa yempa/ isa yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Gwon dhaŋ oki a’di jin ta thus ki thus gwo mo ki ’kula’kul eya dum piti mo. Moŋḵo/ isa kamu/ yisa di’da goma Arumgimis e bwambor jis/em piti mo. ");
INSERT INTO udu_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Haali/ a’di o gwo maŋ ka maḵ gom is piti mo e em pitiŋ gana/ mo ki miinthus piti minu ’koki gam mo dhali shi/i e mo. ");
INSERT INTO udu_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Gwo ’peni ’twam piti mo tani uni tana pibi mo dhali mo jin hekuwa he’k e mo. A’di daḵki’d mo ’peni mo jin miina a’di ki yuḵ yuḵ mo dhali mii ki ’bore/ mo. ");
INSERT INTO udu_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","A’di c̱i is piti ki gwo ma pibi ma wu’th mo ki a’di di’d mmo/isha aŋkar piti mo. A’di ki kar is piti e bway jin diki ’bor mo. A’di diki ush tonthus mo. ");
INSERT INTO udu_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Mo/en pini jin ṯeli sho’k mo tani, ayy Tap̱a, a’di jithirki’d e momis mo, dhali mii gi isiŋ ganam pini eya raḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Mii ma ḵar/em pini a’di wana e ki wosh kun turatur kun ta ku ma Arumgimis mo, gwon dwall pini kun toru gwo ’twa/a ’cesh mo uni wana e ki dhan ’kul yi’de/ mo. ’Kwani dhali tombwaasho takina /e is ki me’d mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Mo/en pini jin ṯeli sho’k mo tani wa’di yinthowa, ayy Arumgimis. Uc̱i gi ’kwaniny’cesh uni bu’thki mo jin huru jwa eya ḵashira/ ma bim pini mo. ");
INSERT INTO udu_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Uni yuḵkina yuḵ e gu’b pini jin isha to ka enthus mo, dhali /e c̱iki uni to mmop̱i mo ’peni yi’de/ jin ’kunykina /e bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Haali/ e /e mo tani /e a’di ta mondiki/e jin kashki’d mo. E moŋkush pini mo tani am p̱arkina moŋkush e mo. ");
INSERT INTO udu_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ayy ṯikiri mo/en pini jin ṯeli sho’k ki sule/ gom uni gwansan kun mishki /e mo, dhali bway gi mowoṯẖ pini gom uni kun dhelel ma du ki dhelel mo. ");
INSERT INTO udu_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Dhalku/ ki dhal sho’k gi a’di jin kar ’ba/ ki ca mmop̱u’da p̱o/ aha/ mo, walla me’d gi a’di jin ta thus ki thus mmobor aha/ mmosi’da/ si’d mo. ");
INSERT INTO udu_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","’Kwani kun ta imanmii tonthus ishkin ki rap̱ rap̱ mo, uni kun torkunu ’ko’da ’cesh mo, mmomol cu mo. ");
INSERT INTO udu_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dhalku/ is pini ki anan mo goma manṯẖu’th to mii mo, dhalku/ dhap̱an ki mii ta gom imanṯẖu’th to mii mo. ");
INSERT INTO udu_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Haali/ uni mini la us ki jog me’da sho mo, dhali ḵu’th mo me’da sho mo. ");
INSERT INTO udu_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Gami gwo is e Tap̱a mo, dhali miiyi ki ’bore/ mo. Wakan ki /e mini c̱a’b eya ’cesh mo, dhali ’kuny bwa mo gom mo jin mina /e c̱a’b ki ’dantar mo. ");
INSERT INTO udu_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Budhi mo jin ’kunyu bwa e Tap̱a mo, dhali a’di midi c̱i /e to kun gwon ma dum pini mo. ");
INSERT INTO udu_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","C̱uthi bway pini ’kup̱ ki Tap̱a mo. Dhali gami gwo is e a’di mo, dhali a’di midi ḵal mii mo be. ");
INSERT INTO udu_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Dhali a’di midi ḵal mom pini jin minu ye /e mo e moŋkush mo dhali tom ’boro’d pini mina e waki montee mo. ");
INSERT INTO udu_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Doshi naskina/ e bwambor gi Tap̱a mo dhali c̱oriya c̱or ki bwa jin ’kuc̱u/ ki ’kari’th gom a’di mo. Dhalku/ is ki anan ap̱o/ a’di jin gam mii adu is e bway piti mo, ap̱o/ wathi/ jin ḵali tonthus ka pije/ ki mii jin p̱ishina a’di ki ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Daḵi ’pena nyor mo dhali dhalka nyor jin shwanu ’pen mo. Dhalku/ is pini ki anan mo, a’di jin ḵuthi is jasi gom tonthus mo. ");
INSERT INTO udu_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Haali/ amanmii tonthus mo tani a’di minu la ’ciṯẖ mo, hili uni gwansan kun c̱orki Tap̱a mo tani uni a’di imini gam mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","C̱ori naskina/ ari’ceenne/ mo dhali amanmii tonthus midi di doḵ/e yisa. Ba me’d jin hila um a’di ki a’di di’d e mom piti ki ’bore/ mo tani a’di midi di yisa. ");
INSERT INTO udu_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Hili uni kun ’thup̱ ma du mini gam mony’cesh mo dhali ’kuny bwa e is buni mo e mo jin isha to ka enthus ki mii jin gama uni adu is mo. ");
INSERT INTO udu_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Amanmii tonthus a’di mii’da wu’th ap̱o/ a’diŋ ḵar/e mo dhali ’pe’d shem piti ap̱o/ a’di mo, ");
INSERT INTO udu_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","hili Tap̱a p̱e’thki a’di jin mii tonthus mo haali/ a’di mishki’d ka teem piti p̱u’dki’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Imanmii tonthus uni buḵi gandal buni mo dhali gwana’da bwam buni mo, mmoḵal ka ’cesh uni kun hatha’ko’d mo dhali kun mini mii ta gi to mo. dhali ’kosh uni gwansan kun iin ki iin dhelelga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Gandal buni mini cic̱a dum buniŋ gana/ mo, dhali abwam buni minu ’ce’d bwa mo be. ");
INSERT INTO udu_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","To kun tana a’diŋ ḵar/e ush’ceenne/ mo tani a’di ’boro’d mo mmobol to jin ishi’d ka enthus ma ris uni kun mii tonthus e mo. ");
INSERT INTO udu_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Haala bi gi imanmii tonthus mo tani uni minu ’ce’d mo, hili Tap̱a a’di dhuki imanmii miiŋḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Tap̱a a’di mishki’da tee gi uni kun ’kon ki dar gi mii ’ba/ mo, dhali mal buni c̱a’bki’d ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Uni minu ’koki dhu ki mo ma ’the is ka tee kun ta thus ki thus mo, dhali ka tee jin mina ṯe/ ’kosh mo tani uni mini ta gi to jin ish ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Hili imanmii tonthus mo tani uni ’ce’dki sho’k mo. Aris uni kun ta ’kup̱ gi Tap̱a mo tani uni wana e ki monyca ma shon dhii/i’d mo, uni kun la p̱uu mo – dhali uni kun wana e ka ku’d kun la p̱uu mo. ");
INSERT INTO udu_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Amanmii tonthus barki to ḵal ’peni ’kwani mo tani, dhali mol c̱iya murem piti ka nyaŋ’ko’d mo, hili a’diŋ ḵar/e ta’da ’the mo dhali c̱i’da c̱i mo. ");
INSERT INTO udu_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Haali/ uni gwansan kun ’boru mii ki Tap̱a mo tani uni mini gam mony’cesh mo, hili uni gwansan kun jeenu ki a’di mo tani uni minu ’ciṯẖ ’twa/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Ŋaṯgin jin tana wathi/ mo tani a’di ’peni Tap̱a mo, dhali a’di ṯelki a’di sho’k mo e bway jin mina bwa ’kuny a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ba ki a’di midi biṯ mo tani a’di minu ’koki biṯa sho ’kup̱ ka luŋgu’b mo, haali/ Tap̱a a’di ta mondim gom me’d piti mo. ");
INSERT INTO udu_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Aha/ tana dhuru’c ’thissa/ mo dhali shwane/ aha/ tana dhan mo. Hili naskina/ aha/ dinaki p̱ar a’diŋ ḵar/e e dhalkunu ’pen mo walla uc̱im piti mmo’tho tonṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","A’di c̱iki to ka ’ka’d me’di is mo ka yempa/ mo dhali c̱i to mo, dhali uc̱im piti warkin ki uni kun ’bor mii mo. ");
INSERT INTO udu_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Ḵwa/i bwa mo ’peni tonthus mo dhali miiyi ki ’bore/ mo, wakan ki /e mini di ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Haali/ Tap̱a a’di enki mo jin ’konuki miiya mii ka gwar ’de/ mo. A’di midi diki dhal unim piti kun dhunu ki she/ ki dhelel dhelel ’pen mo. Imanmii miiŋḵar/e minu dhu ki sule/ sule/ mo. Hili uc̱i gi imanmii tonthus mo tani uni minu ’ciṯẖ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Imanmii miiŋḵar/e mini gam mony’cesh mo dhali c̱a’ba p̱o/ a’di ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","’Twa/ ma manmii miiŋḵar/e mo tani a’di bahki gwo gom moyuḵ mo dhali ale’d oki gwo ki dar gi mii ma gwar ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Dhali gwoŋḵan ma Arumgimis piti jin c̱inu mo tani a’di di’da dum piti mo. Dhali ŋaṯgin piti ’koki yeresa/ yeres mo. ");
INSERT INTO udu_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Amanmii tonthus a’di timki a’diŋ ḵar/e mo dhali simm a’di e mo mmo’kosh mo. ");
INSERT INTO udu_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Tap̱a a’di midi diki dhal a’di ’pen e mom’bi’th piti mo, walla dhal a’di ki a’di minu waḵ mo me’d jin minu sus a’di e mondwall gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","C̱ori Tap̱a mo dhali kari bway piti mo dhali a’di midi kar /e ki ca mo mmogam mal gi mony’cesh mo. /E mini hil mony’ce’d sho’k ma manmii tonthus mo. ");
INSERT INTO udu_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Aha/ hilkina manmii tonthus mo mmomii mii gi ’ba/ mo, dhali mmotura tur me’da bwanyayiis gi Pan Lubnaan mo. ");
INSERT INTO udu_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Doḵ/e aha/ yakina ki yam pe mo dhali hili a’di diki di doḵ/e mo. Ba aha/ ŋap̱kina a’di mo tani a’di ’konuki gam mo be. ");
INSERT INTO udu_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","’Cunycuri wathi/ jin dar gi mii ’ba/ mo dhali hili mo mo ma a’di jin dhelel ma du mo, haali/ emen ’kon gom wathi/ gi moŋḵu’th is mo. ");
INSERT INTO udu_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Hili imandhaŋ gwo mo tani uni minu ’ce’d sho’k imonṯal ’de/ mo. Dhali emen gi imanmii tonthus mo tani uni minu ’ciṯẖ mo be. ");
INSERT INTO udu_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Bway gi mowoṯẖ gom wathiŋ ḵar/e mo tani a’di ’peni Tap̱a mo be. A’di ita jim buni jin hura uni jwa ka tee gi monṯo’c bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Tap̱a woṯẖki uni mo dhali ’cuḵki uni mo. A’di ’cuḵki uni mo ’peni imanmii tonthus mo dhali ta uni is ki me’d mo haali/ uni bu’thki mo jin huru jwa e a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Ayy Tap̱a, dhalku/ ki ḵucur aha/ ka nyor pini mo walla dhalku/ ki dor aha/ ka nyor pini jin shwana /e mo! ");
INSERT INTO udu_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Haala thop̱am pini ḵarana dum ’per pem ’kup̱ mo, dhali me’d pini p̱u’dkina p̱om pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Dhali moŋkamu/ mura shuman buŋgwar is pem is mowa? haala nyor pini jin shwana /e caaca mo. Dhali mowac̱a kamu/ di’d goma simam pema? gom miinthus pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Haali/ miinthus pem loski aha/ ki ’kup̱i lu/ mo, dhali uni ’thiraa/ diṯ mmoḵal mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Jamam pem ’kakin mo dhali bulabul mo dhali taga ’bi/ nycine/ mo gom miim p̱us pem mo. ");
INSERT INTO udu_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Aha/ kumkunu ’twa/a ’cesh mo dhali ’dac̱al ’ko’da ’cesh mo. Isa yempa/ yula tente/ mo tani aha/ yakina gwolu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Haali/ empa’d pem a’di ’tu’dkunu ki mo jin ’batha’ba’th mo, dhali moŋkamu/ mura shuman buŋgwar is pem is mowa? ");
INSERT INTO udu_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Aha/ kumkunu ’twa/a ’ceshi ’baar mo dhali sirica p̱o/ ki sho’k mo. Aha/ ohonkina mo goma dulaṯṯ ma nyor ma dum pem mo. ");
INSERT INTO udu_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Tap̱a, aris mom pem kun gwon ma du mo tani mishu ki /e mo. Dhali ashurem pem jin wuka/ mo tani ’konuki bag ’peni /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Adum pem shwa’d ki ju’k ju’k mo dhali mom’bi’th pem ushi me’d mo e aha/ mo dhali apinya/ em pem jin shwa’d ki o’d mo tani, uni si’da/ uskin ’peni aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Imugum pem dhali uni gun nyaḵ aha/ ii ka yempa/ mo tani uni doshkin ki moŋḵo/ is ’peni isa nyor pem kun wo’cki aha/ she/ mo, dhala bas pem si’da/ uni doshkin isa dhana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Uni gwansan kun simmki mondiki/em pem e mo tani ’thikina gumem buni mo. Uni gwansan kun simmki mo e jin mina uni shi/ aha/ is mo tani oki gwo kun minu kup̱ mo dhali kulum gwo ibwa mmo’ce’da ’ce’d me’di isi yula tente/ mo. ");
INSERT INTO udu_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Hili aha/ wana e ki wathin ’diye/ mo, aha/ dinaki ciḵ toŋ kamu/ mo. Aha/ wana e ki wathi/ jin mol ’twa/ wal mo jin mol ’twam piti ḵa’d mo. ");
INSERT INTO udu_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Nye, aha/ wana e ki wathi/ jin mol gwo ciḵ mo, dhali e ’twa/ mo tani aha/ dara gi gwoŋ ḵucur mo. ");
INSERT INTO udu_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Hili e /e mo tani ayy Tap̱a, /e be ic̱orkaa/ mo be. A’di ta /e be, ayy Tap̱a Arumgimis pem, /e jin mini thoḵa thoḵ ’twa/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Haali/ aha/ ’thona mo ki: Uni mini dhalki bwa ki ’kuny ap̱o/ aha/ mo. uni gun dhu ’ba/ ki ca ap̱o/ aha/ mo ki sho’k pem yereski’d mo. ");
INSERT INTO udu_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Aha/ ’dishkina mmobiṯ mo, dhali mo jin woca is aha/ she/ mo tani a’di di’da bori aha/ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Aha/ pikina gwo gom tonthus pem jin miika/ mo, aha/ ḵala bwan diṯi’d gom miinthus pem mo. ");
INSERT INTO udu_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Uni gwansan kun ta ’kup̱ pem mo tani dar gi ’ko mo uni ’bitha’bi’th mo, dhali uni gwansan kun shi/i aha/ i e ki shi/ thus mo tani uni tana ris mo. ");
INSERT INTO udu_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Dhali uni gwansan kun raḵki aha/ tonthusi bway gom tom ’boro’d mo tani uni ita ’kup̱ pem kun tana ris mo haali/ aha/ baṯẖa jasi tom ’boroni ’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Dhalku/ ki dhal aha/ ’pen mo ma, ayy Tap̱a, ayy Arumgimis pem, dhalku/ ki si’d ’peni aha/ mo! ");
INSERT INTO udu_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Huru/ ki jahanne/ mmowoṯẖ aha/ mo, ayy Tap̱a, gi bway mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Aha/ ona gwo mo ki: Aha/ mina ji bway pem ki e mo, ki aha/ mina diki mii miinthus ka le’d pem mo. Aha/ mina ’kali’th ’twam pem mo, wakan me’d jin mina ’kwanin thusi ’kowa bori aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Aha/ usha ’twa/ wal mo dhali c̱a’bki shwamm mo, aha/ bu’thkina moŋḵu’th is pem mo tani toŋ kamu/ gamkaa/? mo ma c̱is pem thissi’di ca mo ’teki shi/ shi/ mo. ");
INSERT INTO udu_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Adum pem c̱a’bki ’ba’th ’ba’th e aha/ mo. Me’d jin tashu aha/ ki gwo kun kulumkaa/ e bwa mo tani o’d jin ’batha’ba’th shwaki’d mo, dhali yan’ko’d aha/ ki o gwo ka le’d pem mo ki: ");
INSERT INTO udu_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Tap̱a, dhalki aha/ misha ’pemen pem jin midi di ’kup̱ mo dhali ateem bar pem wakata mo? Dhalki aha/ misha mo mo, ma mondiki/em pem midi gus kata mo? ");
INSERT INTO udu_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Hili /e ki kara teem pem mmokuṯa/ kuṯ me’d bwam me’d ki daḵa/ mo dhali mondiki/em pem jin dika/ ki e mo tani ta toŋ kamu/ ibwambori jis/em pini yisa. Ka jiŋ gana/ aris ’kwani ’baar mo ’kokin ’twa/i ’kup̱ ’te/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Ka jiŋ gana/ ’kwani iikin ki jasa ḵashira/ ma la ’te/ mo. Ka jiŋ gana/ uni ’koshki jis mo ki dar gi mii kun ḵala uni mii ’kup̱ pa ka pije/ mo. ’Kwani sugki to mo dhali mol mo mo a’di jin midi tul a’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Dhali shwane/ Tap̱a, ki to jin ta’da ta ic̱orkika/ mo? Mo ma ’teŋ kap̱em pem di’d e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","’Cuḵi aha/ mo ’pena ris gwom pem kun dhaŋka/ mo. Dhalku/ ki kar aha/ jin mina imanmii miim p̱us iwaḵ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Aha/ usha ’twa/ wal mo, aha/ dinaki ḵa’d ’twam pem mo, haali/ a’di ta /e jin miiki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Joc̱ki mondor pini ’peni aha/ mo. Aha/ ’baarkina mo ki mondor ki me’d pini mo. ");
INSERT INTO udu_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Ki /e ki dor wathi/ dhali ḵucur a’di gom miinthus mo tani /e ki ’cum to jin ena a’di me’da dhurany jin shwa to jin ’ka’d a’di ’twa/ ki ’ka’da bor mo. Ka jiŋ gana/ aris ’kwani ’baar mo ’ko ki e ’twa/i ’kup̱ ’te/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Ciḵi mon’thom pem mo ma, ayy Tap̱a, dhali ḵa’di ’cem pini gom moŋkom pem mo. Dhalku/ ki bu’th moŋḵu’th is pini ’peni jabu’th em pem mo. Haali/ aha/ takina yilkinam pini jin yaki’d ki yam pe mo, a’di jin tani pa mo, mmowa e ki ibabam pemi ’baar kadhamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Hilki /e mo ka c̱iŋ’ko’d mo ’peni aha/ mo, ki aha/ mina gam bwaŋ ’kunyu’d mo nṯwa/a/ ki aha/ mina ya mo dhali diki di doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Aha/ c̱ora/ c̱or ki bwa jin ’kuc̱u/ ki ’kari’th gom Tap̱a mo. A’di ḵa’dki ’cem piti mo dhali ciḵ aha/ kom pem mo. ");
INSERT INTO udu_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","A’di dirki aha/ ka pije/ ’peni jis jin miga/ ’taki tor sho’k ka pupush mo, ’peni boro’th jin c̱a’bki c̱o’do/ c̱o’do/ mo. A’di ki dhu sho’k pem ap̱o/ wosh mo dhali dhu ŋaṯgin pem mmo’ko ki ’dantar mo. ");
INSERT INTO udu_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","A’di ki kar gway this e ’twam pem mo, gway jin maŋka/ Arumgimis bana mo. ’Kwani ka ris mini p̱ar e mo tani dhali ḵoka ḵo/ mo dhali dhu moŋgam gwo is buni e Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Mom’bor mii gom wathi/ jin kar Tap̱a ki jim piti jin gama a’di gwo is mo, a’di jin diki ṯu’k mo e mo jin karu is ki ca mo, ki uni gwansan kun iikini per mo mmobaṯẖ gwo ma rum p̱inyconi sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","/E marki momiin tom pini kun ta momer is mo dhali gwom pini kun kulumkina /e ibwa ’kup̱ki am mo, ayy Tap̱a Arumgimis pem mo. Jamu/ p̱iyi’d jin minu kar ka p̱ar nyaḵki /e mo. Waḵki/ aha/ mina ’taki bah gwo mo dhali ṯor uni mo tani uni mini ’taki bol uni kun minu ’taki deŋ e e ka ris mo. ");
INSERT INTO udu_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","To jin ’ciṯẖu/ ’kus mmomiiya bas mo dhali to jin c̱inu ki me’d mo tani bwam pini diki o mo. Hili /e ki tup̱ aha/ ’cem pem mmoshuwa shu mo. To jin c̱ithu/ ki o’d jin c̱inu ki me’d mo dhali jin c̱inu gom miinthus mo tani /e yisa ’theḵki gwo gom uni yisa. ");
INSERT INTO udu_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Yan’ko’d aha/ ki o gwo mo ki: Hili mo mo ma, aha/ p̱u’dkina mo. Eya warka/ jin ’kuc̱u/ is jin ’kwarkunu gwo ap̱o/ gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Aha/ ’kunya bwa mo mmomii bwam pini mo, ayy Arumgimis pem. Gwoŋḵan pini jin c̱inu mo a’di di’d eya dum pem mo. ");
INSERT INTO udu_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Aha/ ṯorkina gwoŋ ’kunyga/ jin c̱inu gom mo jin ’cuḵuwa ’cuḵ mo eya dhana tul ’kup̱ mo. Dhali hili mo mo ma, aha/ dinaki mu’th ’twam pem mo, me’d jin mishkina /e aha/ mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Aha/ dinaki bag mom pini jin tana /e aha/ is ki me’d mmowoṯẖ aha/ eya dum pem mo. Aha/ ṯorkina gwo mo goma isiŋ ganam pini jin tana /e mo dhali gom bway gi mowoṯẖ pini mo. Aha/ dinaki us mo/en pini jin ṯelu sho’k mo dhali mo ma isiŋ ganam pini jin tana /e mo. ’pena dhana tul ’kup̱ ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Dhalku/ ki bu’th momiimiim pini ’peni aha/ mo, ayy Tap̱a. Dhalki mo/en pini jin ṯelu sho’k mo dhali mo ma isiŋ ganam pini jin tana /e mo tani ’tash aha/ ’twa/ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Haali/ tonthus uni ’kamki aha/ mo dhali uni molu deŋ e mo. Miinthus pem uni ḵalki aha/ ka ’cesh mo ntagi aha/ mola mo mo. Uni tana ris ka ris kun bolina mur ’kup̱ pem e mo. Adum pem ush aha/ me’di e mo. ");
INSERT INTO udu_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Ba miiyi ki ’bore/ bala, ayy Tap̱a, mmo’cuḵ aha/ mo. Ayy Tap̱a, huru/ ki jahanne/ ma mmowoṯẖ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Dhalki uni dhunu mo ma ki mo ma ’the is mo dhali duŋkuru/ ’kup̱ isi monṯal ’de/ mo uni gwansan kun simmki mii e mo tani mmo/uṯẖ mondiki/em pem mo. Dhalki uni ṯu’kkunu ka nyaŋ’ko’d mo dhali ’doyu/ e mo jin ushuwa taḵ taḵ mo uni gun ona bwa ki shi/ aha/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Dhalki uni meren kagahara gom mon’the is buni mo uni gun o aha/ gwo mo ki: Soso, soso. ");
INSERT INTO udu_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Hili dhalki uni gwansani ’baar mo kun simmki /e e mo tani ’kunya bwa mo dhali ’bor bwa mo e /e mo. Dhalki uni gwansan kun eni bway gi mowoṯẖ pini mo tani ṯikir gwo o mo ki: Tap̱a a’di i/eḵa/ eḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Gom aha/ mo tani aha/ hatha’ko’d ki ha’th mo dhali mina mii ta gi to mo, hili Tap̱a a’di kulumki gwo ibwa gom aha/ mo. /E ta a’dim pem jin woṯẖki aha/ mo dhali a’dim pem jin ’cuḵki aha/ mo. Dhalku/ ki ta adiiṯe/, ayy Arumgimis pem! ");
INSERT INTO udu_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Mom’bor mii gom a’di jin hili uni gun hatha’ko’di e mo. Tap̱a ’cuḵki a’di ka tee jin ṯoju a’di aṯo’c bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Tap̱a woṯẖki a’di mo dhali kar a’di ki e mo. A’di yuḵu gway ka man’boru mii e mony’cesh mo. /E diki c̱i a’di e bwa gi uni gun ta ’kup̱ ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Tap̱a a’di thip̱ a’di ’ko’da cim piti jin isha a’di mmo’ba’th mo. E mom’ba’th piti mo tani a’di ki wac̱ a’di ’pena ris isa nyor kun ’koshki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Gom aha/ mo tani, aha/ ona gwo mo ki: Ayy Tap̱a, miiyi mii ma ’the gom aha/ mo ma. Dhali wac̱i aha/ mo, haali/ aha/ miikina miinthusa p̱o/ /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Uni gun ta ’kup̱ ki aha/ mo o gwo e aha/ eya adun dup̱ buni mo ki: Kakasja imina a’di iwu mo? dhali gway piti ki ’ce’d sho’k mo? ");
INSERT INTO udu_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Dhali ki jan ṯal ’deŋ kamu/ p̱u’dki’d mmop̱ar aha/ e mo tani a’di ki bah gwo kun ’kon isi bwa ’te/ mo, ka yiha/ ka dum piti tulu’da ris mii ma pibi is mo. Ki a’di ya’d ka pije/ mo tani a’di ki wagar gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Aris uni gwansan kun shi/ki aha/ i e mo tani ṯorkina ṯor ki ḵako/ mmonṯal ’de/ gom aha/ mo. Uni ki gwalal buni mo tani uni kulumki gwo shi/in ibwa gom aha/ mo, kun bol tiya e mo. ");
INSERT INTO udu_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Uni ki o gwo mo ki, To jin wunu ḵara biṯi’da p̱o/ a’di ba/. A’di midi cu mis doḵ/eya? ma ’peni mo jin isha a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Isi kani amugum pem gana/ jin di’da bori aha/ jin gamka/ gwo is mo tani a’di jin shwaki tonṯem pem mo tani a’di ’de’kki ’penaṯiŋkilam piti ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Hili /e ayy Tap̱a, miiyi mii ma ’the ap̱o/ aha/ mo, dhali ’deki aha/ ki mis mo ki aha/ mina ’taki mu’th uni ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Gom mii yansan mo tani aha/ misha ki /e ’bora bwa ki aha/ mo, ki a’di jin ta ’kup̱ ki aha/ mo tani diki p̱i aha/ e mo be. ");
INSERT INTO udu_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Hili /e bu’thki aha/ mo gom miim pem jin dar gi ŋadhum mo, dhali /e ki kar aha/ e buŋ’kus pini ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Mom’bor mii midi di gom Tap̱a mo, a’di jin ta Arumgimis gi ’Kwani ma Israyiil mo, ’peni mo jin ’konuki/e ki sule/ sule/ ya ye ’ba/ mo ntagi mo jin ’konuki/e ki sule/ sule/ ya ye ’ba/ mo. Amen dhali doḵ/e Amen mo. ");
INSERT INTO udu_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Me’da sheṯ jin ḵara ce jin ta yoll mo a’di jin ona bwa ki yi’de/ jin kasha e ki kash mo tani wakan si’da/ aḵashiram pem c̱orki’da c̱or gom /e mo, ayy Tap̱a Arumgimis. ");
INSERT INTO udu_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Aḵashiram pem budha ṯe/ miiŋḵar/e goma Arumgimis mo, goma Arumgimis jin di ki e mo. Ki aha/ mina p̱u’d kakasja dhali hil bwam/e ma Arumgimis mo? ");
INSERT INTO udu_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Jabu’th em pem a’di warki’d ki tonṯem pem gi montee mo dhali mon’thiny mo, ka yiha/ ki ’kwani ’kon mmorash aha/ gwo o mo ki: Mane Arumgimis pini mane? ");
INSERT INTO udu_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","To gwansan mo tani uni kakika/ e mo, me’d jin wolkika/ ḵashiram pem ka pije/ mo: me’d jin yaka/ nyaḵka buhany ’kwani mo dhali shu uni bway ka jintura/ e gu’b ma Arumgimis mo, ki bwam ’boro’d kun ḵumu cuuwa/ mo dhali yuḵ gway kun ’boruwa ’bor bwa i is mo, me’d jin dhukin ma waambuhany ’kwani kun ḵogu acim mo. ");
INSERT INTO udu_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Katinta ibiṯu/ /e eya ’cesh mo, ayy aḵashiram pem mo, dhali atinta i/usha /e me’d kan e aha/ mo? Tayi ka ’teŋ kap̱e/ eya Arumgimis mo. Haali/ aha/ mina doḵ/e maŋ a’di mo, a’di jin ta’da manwoṯẖ pem dhali Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Aḵashiram pem a’di biṯu/ ’ko’da ’cesh e aha/ mo. Wakan aha/ kakina /e e mo ’pena ’cesh gi Pan Uurdun mo dhali gi Pan Harmuun mo dhali ’peni ’Kuwosh ma Misar mo. ");
INSERT INTO udu_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Moŋ’kulga/ jin yuḵu ki moŋ’kulgaŋ kamu/ mo me’d jin dora yi’deŋ ḵuku/ ḵukum pini mo. Aris yi’dem pini kun bir bakal mo dhali aris eŋ ḵuthar yi’dem pini uni ḵalki aha/ ka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Ki montee isa yempa/ mo tani Tap̱a a’di ḵanki mo/en piti jin ṯelu sho’k mo dhali mon’thiny mo tani gway piti di’d nyaḵki aha/ mo, mmo’thowa Arumgimis gi mondiki/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Aha/ ona gwo eya Arumgimis jin ta wosh pem mo ki: Atinta iŋana /e aha/ kan mo? Katinta gara/ imiga/ c̱a’b jasi gwolu/ kan mo gom mosiri’c gi uni kun ta ’kup̱ ki aha/ kan mo. ");
INSERT INTO udu_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Me’d wathi/ jin ’disha ’twa/ mmowu mo ’peni jama/ jin doruwa dor e buŋgwar is pem mo tani uni kun ta ’kup̱ ki aha/ mo sorki aha/ mo, dhali ka yiha/ mo tani uni ’kon mmorash aha/ gwo o mo ki: Mane Arumgimis pini mane? ");
INSERT INTO udu_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Katinta ibiṯu/ /e eya ’cesh mo, ayy aḵashiram pem mo, dhali atinta i/usha /e me’d kan e aha/ mo? Tayi ka ’teŋ kap̱e/ eya Arumgimis mo. Haali/ aha/ mina doḵ/e maŋ a’di mo, a’di jin ta’da manwoṯẖ pem dhali Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Yeyi aha/ mo, ayy Arumgimis dhali ’ce’di gwo she/ gom to jin raḵi aha/ mo ap̱o/ ’kwani kun ’koki mii miiŋḵar/e mo, dhali ’peni ’kwani kun ta imanhe’k e mo, dhali ’peni ’kwani kun ’konuki dhu ki mo ma ḵar/e mo tani ’cuḵi aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Haali/ /e tana Arumgimis a’di jin bu’thka/ mom pem jin hurga/ jwa mo be. Katinta biṯa /e aha/ asho kan mo? Dhali tonta imiga/ c̱a’b jasi gwolu/ kan mo gom uni kun siri’c aha/ ki sho’k mo kun ta ’kup̱ pem mo? ");
INSERT INTO udu_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Ayy, hashi moŋkush pini mo dhali gwoŋ ganam pini mo. Dhalki uni shu aha/ bway mo. Dhalki uni sus aha/ mo e ’kuwosh pini jin ḵogu mo dhali mom pini jin c̱a’ba /e mo. ");
INSERT INTO udu_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Dhali yan’ko’d aha/ mina ya mo e mo ma gwaṯa/ jin ’ciṯẖu/ to ’kus goma Arumgimis mo, eya Arumgimis jin ’kunyka/ bwa ki ’kuny icine/ kagahara mo. Dhali aha/ mina maŋ /e ka dheŋdhenye/ jin ’kon ma shu/i pesu/ mo, ayy Arumgimis jin ta Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Katinta ibiṯu/ /e eya ’cesh mo, ayy aḵashiram pem mo, dhali atinta i/usha /e me’d kan e aha/ mo? Tayi ka ’teŋ kap̱e/ eya Arumgimis mo. Haali/ aha/ mina doḵ/e maŋ a’di mo, a’di jin ta’da manwoṯẖ pem dhali Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Aman ciḵkina gwo ki ’cem bam mo, ayy Arumgimis mo, ibabam bam ṯorki aman gwo mo, gom miim pini kun miikina /e mmothim ka teem buni mo, ka tee ’peni kadhamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","/E ki me’d piniŋ gana/ mo tani /e ki ura ris kala tiya ka pije/ mo dhali hili uni mo tani /e ki c̱u’th uni mo. /E ki dor ’kwani ka ris mo, dhali hili uni mo tani /e ki dhu uni ki ’kus mo. ");
INSERT INTO udu_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Haali/ a’di ki gandal buni yisa igamkina uniya ’cesh yan adu is mo yisa, walla si’da/ abim buni diki c̱i uni mom’bi’th mo, hili me’da bim poros pini mo dhali abim pini mo, dhali moŋkush ’peni bwam/em pini jin kushki mo mo, haali/ /e ’kunykina bwa e uni mo be. ");
INSERT INTO udu_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","/E tana Maliḵ pem mo dhali Arumgimis pem mo, a’di jin ’kawurki’da ’kawur mo gom momp̱inu mii e ma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Ki /e mo tani am ki ṯan uni kun ta ’kup̱ bam ka bor mo. Dhali ki gway pini mo tani am ki yap̱ uni gwahan ki sho’k mo kun gam am ’kup̱ mmo/as mo. ");
INSERT INTO udu_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Haali/ bwam pem mo tani aha/ dinaki gam gwo is gom a’di mo, walla gandal pem si’da/ diki ta aha/ is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Hili /e woṯẖki aman mo ’peni uni kun ta ’kup̱ ki am mo, dhali kar to ibwaman uni kun shi/i aman i e mo jin midi duŋgur uni ’kup̱ ’kup̱ is mo. ");
INSERT INTO udu_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Eya Arumgimis mo tani aman dhukina ’ba/ ki ca ki ṯikir ṯikir mo, dhali aman mina c̱i /e momaŋ gom gway pini ki sule/ sule/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Hili /e ki ṯa’k am ka pije/ mo dhali dhu am ki mondhu is ki gwa’d mo, dhali /e diki ya ka pije/ nyaḵki ’kwani ma meem bam mo. ");
INSERT INTO udu_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","/E ki dhu am mmodoḵ ka nyaŋ’ko’d mo ’peni uni gun ’kwar am ka gwap̱i/ mo. Dhali uni kun ta ’kup̱ ki am mo tani dilki aman to mo. ");
INSERT INTO udu_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","/E ki dhu am me’d ḵa’bal kun minu ’ciṯẖ ’kus mo, dhali /e ki c̱eker aman bwa mo e bwaman kal gi ’kwaniny’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","/E ki yol ’kwanim pini ka maliim gana/ mo, /e ki ḵan gwo ki uni minu ’koki yol ka thaman kun caaca mo. ");
INSERT INTO udu_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","/E ki dhu am ki uni gun nyaḵ ’ko ki am mmoc̱i aman gura/ mo, dhali aman dup̱u i e dhali ṯẖuny ’twa/ i is ki uni gwansan kun ’kamki am is mo. ");
INSERT INTO udu_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Dhali /e ki dhu am ki ku gun miinu mii ka maḵ mo e bwaman kal gi ’kwaniny’cesh mo. dhali aman p̱e’thkunu mmopir ’kup̱i is e bwaman ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Ka cim ’baar mo mom pem jin darka/ ka ’the mo di’di bwambori aha/ mo, dhali mon’the is a’di kumki aha/ bwam/em pem mo, ");
INSERT INTO udu_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","gom gwo gi uni kun c̱iki aman gura/ mo dhali imansor aman mo tani dhali e bwambor uni gun ta ’kup̱ mo dhali a’di jin ŋap̱a’d mmori/a ri’c mo. ");
INSERT INTO udu_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Aris to gwansan p̱u’dki’d ap̱o/ aman mo, ba aman ’konaki ŋa /e mo, walla aman ’konaki ta thus gom gwom pini jin gamu me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Adum bam ’koki doḵ ka nyaŋ’ko’d mo, walla ŋaṯgin bam ’koki dheres ’peni bway pini mo ");
INSERT INTO udu_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","ki /e mini ’taki ’ce’d am mo ’peni mo jin ’kon ma jala/ nycine/ mo, dhali kum am ’kup̱ ki mondhurumi’d jin ’kula’kul mo. ");
INSERT INTO udu_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Waḵki/ aman ŋakina gway ma Arumgimis bam mo tani, walla he’th me’d bam goma rum p̱inycon mo tani, ");
INSERT INTO udu_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","min ma Arumgimis ’taki diki gam mii yansana? Haali/ a’di mishki to kun ’kona duŋ ’kwani ka ḵwal is mo. ");
INSERT INTO udu_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Yisa, gom gway pini mo tani aman ’koshkunu yula tente/ mo, dhali aman dhukunu mo me’d ḵa’bal kun dhunu mmo’ciṯẖ ’kus mo be. ");
INSERT INTO udu_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Muri is pini mo. Ata isha /e e kan mo, ayy Tap̱a? Meri /e e mo. Dhalku/ ki ṯa’k am asho ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Katinta ibaga /e jis/em pini mo? Katinta iŋana /e mom bam jin woja is am she/ mo dhali mo jin siri’ckunu am ki sho’k mo? ");
INSERT INTO udu_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Haala ḵashiram bam a’di kumkunu ’twa/a ’cesh e bwam bu’d mo, dhali buŋgwar is bam ishkina ’cesh ki rap̱ rap̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Cuyi mis mo dhali yayu/ mmowoṯẖ aman mo. ’Cuḵi aman mo gom gway gi mo/en pini jin ṯelu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Adum pem a’di ’tu’du/ mo ki tom ’borga/ jin di’di bwaman mo mmo/o mo. Aha/ bahkina gwom pem eya maliḵ mo. Ale’d pem a’di wana e ka galama riisha/ jin thoson ma man’kwar to is hila/ mo. ");
INSERT INTO udu_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","/E ta a’di jin onu bwa ki nyanye/ ki iya/ gi ’kwani mo. A’the a’di wolkunuwa p̱owa le’d pini mo. Wakan Arumgimis ’borki /e mii ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Deḵi gandal pini ap̱owa wum pini mo, ayy /en ’de/ jin c̱a’bki dem dem mo e monycam pini mo dhali e mo/eḵ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","E mo/eḵ pini mo tani meri mo e mo jin p̱inu mii e mo gom gway gi gwoŋ gana/ mo dhali gom mo jin minu cesh she/ mo gom mo jin minu dhu bwa ki gwa’d ki miiŋḵar/e mo. Dhalki me’da bim poros pini ṯorki /e gwo gom dhan mii jin caaca mo. ");
INSERT INTO udu_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Athop̱am pini uni kaaka mo eya du uni kun ta ’kup̱ ma maliḵ mo. Dhali ’kwani ṯa’kkin e bwaŋ’kwariny pini mo. ");
INSERT INTO udu_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Ḵursim pini a’di ta ji ma Arumgimis jin di’d ki sule/ sule/ mo. Cwa ma maliḵ pini a’di ta cwa jin ’konuki mii mii ka gwar ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","/E eni mo jin miinu miiŋḵar/e mo dhali shi/ mo jin miinu to gun ’coḵa’coḵ i e mo. Wakan Arumgimis jin ta’da Arumgimis pini mo tani a’di ’koshki /e ki monyca mo ka yin gi mom’bor bwa ap̱o/ uni gun ta cim pini mo. ");
INSERT INTO udu_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Burrinye/ ma p̱om pini a’di ter mo kagahara mo gom yiman cwaŋ ḵuyu’d ’pena murr dhali yiman gi cwa jin wana e ka ’kwaṯan mo dhali yiman cwa jin yuḵu gway ka saliiḵa mo. ’Peni mo ma maliḵ pini jin ta sheny je mo tani ashun dheŋdhenye/ uni buḵkunu mo mmo’kuny /e bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","I’bwa/ gi imaliḵ mo uni ’koni bwaman up̱ pini kun taḵu mo. E me’da bim poros pini mo tani ayim jin ta asha maliḵ a’di doshki’d ki ’dolkon ’peni Pa Up̱ir jin hidhu i/is ma yim mo. ");
INSERT INTO udu_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Ciḵi gwo mo ma, ayy ’bwa/um, dhali mishi isi gwo dhali ḵa’di ’cem pini mo. Dhalki ’kwanim pini ’pen mo dhali gu’b gi icim mo. ");
INSERT INTO udu_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Dhala maliḵ mina bwa o gom jarom pini mo. Me’d jin tana a’di tap̱am pini mo tani luŋi a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","’Kwani gi Pan Sur uni mini sus mo ma ’them pini ki to kun c̱inu ki me’d mo, uni ’peni ’kwani kun ta pa ki pa mo, ");
INSERT INTO udu_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","’pena ris to gun ’kona e ki she/ ki she/ kun tanu mo. ’Bwa/ ma Maliḵ a’di shumkunu ki burrinye/ jin shonu ka ce e ki ’dolkoni e mo. ");
INSERT INTO udu_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ka ris jamas burrinye/ ki she/ ki she/ mo tani ayim suskunu amaliḵ mo nyaḵki nyaranyaŋa’b ma yim jin suski a’di mo, uni gun iiyin nyaḵka yim mo. ");
INSERT INTO udu_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Ki bwaŋ ’kunyu’d dhali ki bwaŋ ’kunyka/ mo tani uni sus uni mmonṯal ’de/ mo me’d jin cic̱kina uni gu’b ma maliḵ mo be. ");
INSERT INTO udu_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Mmodhal mii yansan e i is gom ibabam bum mo tani a’di midi ta iya/m bum mo. Dhali /e mini dhu uni mmota iya/ gi mony’ceshi ’baar mo be. ");
INSERT INTO udu_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Aha/ mina kar gway pini ki a’di midi ’ciṯẖa cim bwa mo jin minu taḵ a’di mo eya risa nyaḵum yil gi ’kwani mo. Wakan ’kwani ’baar mo mini maŋ /e mo gom ki sule/ mo dhali ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Arumgimis ta a’dim bana jin hura ana jwa icine/ mo dhali mom’bi’th mo, a’di jin ’dishi’d ka yempa/ mmowoṯẖa woṯẖ ’peni monṯo’c bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Wakan ana mina ’koki ḵo/ is mo, ma waḵki/ mony’cesh midi aḵ jamas e mo, ma dhali waḵka ris wosh kun turatur si’da/ mini ’taki yiḵin is mo e bwaman ma duŋ ḵumma/ yi’de/ mo, ");
INSERT INTO udu_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","ba yi’de/ a’di gwokina is mo dhali seya gabusha/ mo, ba dhan wosha turga/ uni deekin mo ka dulaṯṯ piti mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Yi’de/ jin kasha e jin gusu’d a’di jin kar ’peŋkuman Bampa/ ma Arumgimis ki bwaŋ ’kunyka/ mo, dhali mo jin ḵogu jin ta mo gi a’di jin Eḵa/ Eḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Arumgimis a’di di’di bwaman ma yim mo. Ayim minu mol joc̱ mo. Arumgimis midi woṯẖa yim ki ’dishe/ shunsan mo. ");
INSERT INTO udu_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Kal gi ’kwaniny’cesh uni shwakina bumburush mo. Dhala risa hakuuma kun ’kona ’cesh mo uni yaki yil mo mmoḵala mo uni mo. A’di bahki gwo ki ’twam piti mo tani mony’cesh waki’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Tap̱a gi momis mo tani a’di nyaḵki di ki ana mo. Arumgimis ma Yakuub a’di ta jim bana jin hura ana jwa icine/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Iiyu/ ma, hili mo mo ma, mii kun miina Tap̱a mo, a’di jin wagaski mo jin ’ce’du/ sho’k e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","A’di doshki mo ma mee kun asu mo e ’pemen gi mony’ceshi ’baar mo. A’di ’ce’dki’da bwaa mo dhali ṯosha mee mo. A’di ki c̱itha arabiyya kun dira shumarum ki o’d mo. ");
INSERT INTO udu_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Doshi ka ḵu’th is naskina/ mo dhali mishi gwo ’ban ki aha/ tana Arumgimis mo. Aha/ karu ki ca e kal gi ’kwaniny’cesh mo. Dhali aha/ karu ki ca e mony’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Tap̱a gi momis mo tani a’di nyaḵki di ki ana mo. Arumgimis ma Yakuub a’di ta jim bana jin hura ana jwa icine/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Tori me’d bum mo, aris ’kwani ’baar mo. Ḵumi cuuwa/ mo goma Arumgimis mo ki gway jin eḵu/ ki nyanye/ gom bwaŋ ’kunyka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Haali/ Tap̱a, a’di jin Caa e ki Ca mo tani a’di ḵa/aḵa/ mo, a’di jin ta dhana Maliḵ ap̱o/ mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","A’di ki dhuwa ris ’kwani e bwaŋ’kwariny ana mo dhali aris ’kwani e bwaŋ’kwariny sho’k bana mo. ");
INSERT INTO udu_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","A’di ki kwany mal bana gom ana mo, ’ba/ jin kar ma Yakuub ki ca a’di jin ena a’di mo be. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Arumgimis shinki bway momis cuuwa/ ilu/ mo be, dhali Tap̱a ki ko ma poome/ mo. ");
INSERT INTO udu_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Yuḵi gway mmomaŋ Arumgimis mo, yuḵi gway mmomaŋa maŋ mo. Yuḵi gway mmomaŋa Maliḵ bana mo, yuḵi gway mmomaŋa maŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Haali/ Arumgimis a’di ta’da Maliḵ gom mony’ceshi ’baar mo. Yuḵi gway mmomaŋa maŋ ki gway jin yedhuwa ye’th sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Arumgimis miiki miin tap̱a ap̱owa ris kal gi ’kwaniny’cesh mo. Arumgimis c̱a’bki’da p̱owa ḵursim piti jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Iya/ gi ’kwani mo tani uni tulki isi monṯal ’de/ mo me’d ’kwani ma Arumgimis ma Ibrahiim mo. Haala goŋgoro/ jin ta ji gi mony’cesh mo tani a’di cil ma Arumgimis mo be. A’di karu ki ca jin eḵa/ eḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Tap̱a a’di ta a’di jin ca’d mo dhali ta a’di jin ca’d jin minu maŋ mo e ’peŋkuman bampa/ ma Arumgimis bana mo. ");
INSERT INTO udu_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Dhali e ’kuwosha turgam piti jin turatur jin ḵogu mo, dhali jarom piti ki tur mo, a’di ta moŋ’kunyka/ gom ’kwaniny’ceshi ’baar mo. A’di jin ta Wosh ma Sihyuun mo jin di’d isa dhana/ ki ’ban ma bim poros mo, a’di jin ta ’peŋkuman bampa/ ma dhana Maliḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","E bwaman gi gu’b mo gom montur piti mo tani Arumgimis ki ṯor is piti eya tente/ ki a’di ta a’di jin ’ce’de’da ’ce’d she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Bahili, imaliḵ uni tulki ’kup̱ mo, uni p̱u’dkini monṯal ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Isi me’d jin p̱arkina uni a’di e mo tani uni merkin kagahara mo. Uni ’kokunu mmoduŋgur ’kup̱ is mo dhali uni sokin mo be. ");
INSERT INTO udu_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Mo jin deenu is ki bir bir mo tani a’di bu’thki uni mo, dhali uni ’pe’dki she/ me’da ’bom jin shwan ma ’ci mmomuri dho’th mo. ");
INSERT INTO udu_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Ki ’tham ki mom’pesho’k poshki’d mo tani /e ki p̱or uni bwa mo uni gun tana ḵur yi’de/ gi Pan Tarshiish mo. ");
INSERT INTO udu_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Me’d jin ciḵkina ana gwo mo tani wakan si’da/ p̱arkina ana e mo, e ’peŋkuman bampa/ gi Tap̱a gi momis mo, dhali e ’peŋkuman bampa/ ma Arumgimis bana mo, a’di jin ṯel ma Arumgimis sho’k ki sule/ sule/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Aman kulumkina gwo ibwa gom mo/en pini jin ṯelu sho’k mo, ayy Arumgimis, e bwaman gu’b gi mondheleladhelel pini mo. ");
INSERT INTO udu_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Me’d gway pini mo tani, ayy Arumgimis mo, wakan momaŋ pini a’di jidhirki’d e ’pemen gi mony’cesh mo. Me’da bim poros pini mo tani a’di ’tu’dkunu ki momp̱i mii e mo. ");
INSERT INTO udu_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Dhalki Wosh ma Sihyuun a’di ’kunya bwa mo. Dhali dhalki i’bwa/ gi ’Kwani Yahuuda/ uni ’kunya bwa mo gom mondwall gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Iiyi mmo’kara Sihyuun mo, dhali iiyi ka kul is mmo’kama yim is mo, deŋi aris gu’b ma yim kun turatur e mo, ");
INSERT INTO udu_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","hili isi gwo i e ki ’bore/ goma cur ma yim mo, iiyi e bwaman mo ma, e mo ma yim kun turatur mo ki um mini mii ṯora nyaḵum yil ’kwani gwo i’ko’d mo, ");
INSERT INTO udu_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","ki a’di yansan ta’da Arumgimis mo, a’di jin ta’da Arumgimis bana mo gom ki sule/ dhali ki sule/ mo. A’di midi ta jim bana jin midi shu ana bway ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Ciḵi gwo yansan mo ma, aris ’kwani ’baar mo. Dhali c̱iyi ’cem bum mo, aris um gun ’kokin e mony’cesh mo, ");
INSERT INTO udu_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","um gun gwa’da is mo dhali um gun ’bap̱kin mo, dhali kun ta pa ki pa mo dhali kun hatha’do’d si’da/ mmonṯal ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","’Twa/ pem midi ṯor gwo gom moyuḵ mo. Dhali gwom pem jin kulumka/ eya du mo tani minu mish ’ban mo be. ");
INSERT INTO udu_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Aha/ mina ḵa’d ’cem pem ki gwom ’bi’th/e mo. Aha/ mina gam gwom pem jin ’ce’dka/ agagala/ mo ki ko ma dheŋdhenye/ jin ’kon ma shu/i pesu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Ki gomatinta imiga/ ḵo/ is goma risa tente/ kun ṯoju aha/ bwa mo, ki imanmii tonthus kun ṯoci aha/ ’kus mo tani ’kamki aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Uni gun ta ’kwaniŋ gwaṯẖ kun ’ko ki ’kus gom tom buni kun tana uni mo dhali dhu ’ba/ ki ca gom tom buni kun tana uni kun ishkin ka enthus ki pa jin tana uni mo? ");
INSERT INTO udu_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Ka jiŋ gana/ wathiŋ kamu/ p̱iyi’d jin midi wan is piti ’ba/ mo, walla c̱iya Arumgimis she/ yol gom mondiki/em piti mo, ");
INSERT INTO udu_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","haali/ mo jin wanu ’ba/ gom mondiki/em piti mo tani a’di ’bitha yol she/ ki ’bi’th mo, dhali midi mol gam ki sule/ sule/ mo, ");
INSERT INTO udu_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","ki a’di midi ’taki ṯikir di ki e ki sule/ sule/ mo, dhali mol jisa ’kulga/ p̱ar e mo. ");
INSERT INTO udu_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Nye, a’di midi p̱ar e ka jiŋ gana/ ki isi ’kwani kun yuḵayuḵ wukin mo, uni gun ta p̱us dhali uni gun dar gi bwaŋ’kup̱ mo tani uni mini mii inyaḵ ’ce’d sho’k imonṯal ’de/ mo dhali dhal tom buni kun tana uni pa ki pa ki unin tiya mo be. ");
INSERT INTO udu_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Jis jwam buni mo tani a’di ta pam buni jin mina uni ’ko ki sule/ sule/ mo, a’di jin ta mo jin mina uni i’ko nyaḵka ris ’kwani ma nyaḵum yil buni mo, ba uni ṯoshki yuḵa ’cesh gway ki jim buni mo. ");
INSERT INTO udu_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Wathi/ mol c̱a’b ki e e ’penkap̱an piti jin tana a’di mo, a’di wana e ki tonycuḵ kun ’ce’dki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","A’di yansan ta ’pemen gi uni gwansan kun ta p̱us mo kun wuna wuny jwa i is mo, a’di ta ’pemen gi uni gwansan kun ’bora bwa gom tom buni gun pwaḵkunu uni mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Me’d ḵa’bal mo tani uni dhukunu ’pen ka pije/ goma Haawiya mo. Wu a’di midi ta amanhil uni mo, ka ji sho’k gana/ bway jis jwa mo tani uni thulkunu mo be, dhala yi’c buni midi shi/ is mo. AHaawiya a’di midi ta pam buni mo be. ");
INSERT INTO udu_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Hili Arumgimis midi wana ḵashiram pem ’ba/ mo ’peni mom’bi’th ma Haawiya mo, haali/ a’di midi bu’th aha/ mo be. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Dhalki is ki ḵo/ mo waḵki/ jan ṯal ’deŋ kamu/ ta pa ki pa mo, ki monyca gi gu’b piti maru is mo. ");
INSERT INTO udu_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Haali/ ki a’di midi wu mo tani toŋ kamu/ mina a’di ḵal ime’da? Monycam piti midi diki ya ka luŋgu’b baṯẖ a’di nsho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Ba, me’dyin dina a’di ki e mo tani a’di ki p̱ar is piti e ki a’di ’bora bwa ki ’bor mo, dhali ba wathi/ maŋu mo ki a’di ki mii to ki ’bore/ gom is piti mo tani ");
INSERT INTO udu_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","a’di midi ya nyaḵki ’kwani ma nyaḵum yil gi icom mo, uni gun mini mol moŋkush p̱ar e ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Wathi/ mol c̱a’bki e e ’penkap̱an piti jin tana a’di mo, a’di wana e ki tonycuḵ kun ’ce’dki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","A’din ’De/ jin c̱a’bki dem dem mo, Arumgimis jin ta Tap̱a mo, ki a’di ki o gwo mo dhali mony’cesh yuḵkunu mo ’peni mo jin sul ma tente/ mo ntagi mo jin yul ma tente/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","’Pena Sihyuun mo tani ’bor piti shina jaro/ ime’d mo, Arumgimis ’twaḵki mo mo. ");
INSERT INTO udu_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Arumgimis bana p̱u’dki’d mo a’di diki c̱a’bki shwamm mo, e bwambori a’di mo tani a’di ta o’d jin loski’da los mo, dhali mo ’kam a’di is mo a’di jin ta’da dem dem mo tani a’di ta ’thama p̱unthar mo. ");
INSERT INTO udu_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","A’di yuḵki’da yuḵ gom momis jin di’da p̱o/ momis mo, dhali mony’cesh mo, ki a’di midi dwall ’kwanim piti gwo mo be. ");
INSERT INTO udu_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Tuli aha/ kum pem is mo kun ta ku isiŋ gana/ mo, uni gun gamki gwo me’d nyaḵki aha/ ki to kun ’ciṯẖu/ ’kus mo. ");
INSERT INTO udu_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Momis bahki gwo gom mo ma ḵar/em piti mo. haali/ Arumgimis ki is piti mo tani a’di ta’da mandwall gwo mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Ciḵi gwo, ayy ’kwanim pem mo, dhali aha/ mina ṯor gwo mo, ayy Israyiila, aha/ mina ṯe gwo ap̱o/ um mo. Aha/ tana Arumgimis jin ta’da Arumgimis bum mo. ");
INSERT INTO udu_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Dhali aha/ dinaki ḵucur um gom tom bum gun ’ciṯẖa/ um ’kus mmomiiya bas mo, walla tom bum kun c̱ina um ki me’d mo mmoc̱i’th ki o’d mo ki ṯikir ṯikir ibwambori aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Aha/ mina mola rasim bip̱ bu’th ’peni gu’b bum mo, walla rasi mi ’peni kal bum mo. ");
INSERT INTO udu_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Haala ris tonycuḵ kun ’kon e bwaasho mo tani uni ta kum pem mo, dhali bip̱ kun ’koni ’kuwosha alip̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Aha/ misha ris ’dii kun p̱en e momisi ’baar mo, dhali aris to gwansan kun joc̱kin e bwam bunto mo tani uni ta kum pem mo. ");
INSERT INTO udu_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Waḵki/ aha/ mina ṯe/ ’taki ’kosh mo tani aha/ mina ’taki diki ṯor um gwoyi, haali/ mony’cesh dhali aris to gwansan kun ’koni bwaman a’di mo tani uni ta kum pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","A/aha/ ’kana shum gi gwaṯẖim bip̱ mo? walla a/aha/ p̱ina bas mi mo? ");
INSERT INTO udu_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","C̱iyi Arumgimis to jin c̱inu ki me’d mmo’ciṯẖ ’kus ki bwa jin ’boruwa ’bor i is mo, dhali c̱iyi gwom bum kun onu is ki a’di jin Eḵa/ Eḵ mo, ");
INSERT INTO udu_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","dhali yuḵi aha/ ka tee jin ṯoju um bwa mo, dhali aha/ mina ’cuḵ um mo dhali um mini kar aha/ ki ca mo be. ");
INSERT INTO udu_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Hili gom a’di jin ta thus ki thus mo tani Arumgimis ki o gwo mo ki: Kaja c̱i /e shi/ mii mmorash gwoŋḵan pem kun bahu e mo, walla bu’th gwoŋḵan pem jin gamu me’d eya le’d pini mo? ");
INSERT INTO udu_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Haali/ /e shi/i mo jin dilu ’kwani abora ’ceshi e mo dhali /e ki biṯ gwom pem ki nyanygon mo. ");
INSERT INTO udu_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Waḵki/ /e ki p̱ar wathin ’di/ e mo tani /e tana mugum piti mo be dhali /e ki ta amanŋali ’pen gom uni gun buthi miinyc̱al me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","/E ki c̱i ’twam pini bway ki ḵany mo gom tonthus mo, dhali ale’d pini ki uḵ mo jin hekuwa he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","/E ki c̱a’b dhali ṯor gwo ap̱owa kam pini mo. /E ki thutha ’ci ki kwan ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","To gwansan miikina um mo dhali aha/ c̱a’ba ki shwamm mo. Dhali /e ṯoshkin ki aha/ nyaḵa is ki /e mo. Dhali hili shwane/ aha/ ḵucurkina /e mo, dhali kar gwoŋḵan ibwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Nyiṯẖi gwo yansan mo ma, um gun ŋakina Arumgimis mo, isi ciki/ ki aha/ mina bwa p̱u’d ka pije/ mo dhali yan’ko’d jaŋ kamu/ midi diki di mmo’cuḵ um mo be. ");
INSERT INTO udu_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","A’di yansan jin ’doyu to ki bwa jin ’boruwa ’bor i is mo me’d to jin ’ciṯẖu/ ’kus jin ta jim piti mo tani a’di taḵ aha/ mo be. E a’di jin karki bway piti ki ’bore/ mo tani aha/ mina ṯor bway gi mowoṯẖ ma Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Miiyi mii ap̱o/ aha/ mo ma, ayy Arumgimis, isi ki gwo gi mo/en pini jin ṯelu sho’k mo, isi ki gwo gi mii ma ’them pini jin ishki’d ka enthus mo tani ’koshi aris gwon dhaŋ pem mo ma. ");
INSERT INTO udu_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Lami aha/ ’pena taŋkara/ ’peni miinthus pem mo, dhali dheleli aha/ mo ’peni miinthus pem mo. ");
INSERT INTO udu_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Haali/ aha/ misha gwon dhaŋ pem mo, dhali miinthus pem di’d ka yempa/ e bwambori aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ap̱o/ /e, /e ’de/ mo tani a’di imiikika/ miinthus mo, dhali mii a’din thus yin jin shi/a shi/ e bwambori jis/em pini mo, wakan /e karu ki mo ma ḵar/e e gwom pini jin tora /e ’twa/a ’cesh mo, dhali dar gi mii ’ba/ e gwon dwall pini mo. ");
INSERT INTO udu_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Hili mo mo ma, aha/ ḵalunu ka pije/ e miinthus mo, dhali e miinthus mo tani ata’dam pem bwaaki aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Hili mo mo ma /e ona bwa ki gwoŋ gana/ e isi bwaman ma dum ’per mo. Dhali gom gwo gi wakan mo tani ṯori aha/ gwo gom moyuḵ mo eya dum pem ki kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Dhagami aha/ mo ki cwa jin wana e ka ’tasha jalbip̱ mo, dhali aha/ mina dheleladhelel mo. Lami aha/ mo dhali aha/ mina c̱a’bki bany bany mmobola wasa/ e mo. ");
INSERT INTO udu_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","’Tu’di aha/ ki bwam ’borga/ mo dhali ki bwaŋ ’kunyga/ mo. Dhalka sima/ jin ’ce’da /e mo ’kunya bwa mo si’da/. ");
INSERT INTO udu_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Bagi jis/em pini ’peni miinthus pem mo dhali ’koshi aris miinthus pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Uḵi e aha/ adun dhelelga/ mo, ayy Arumgimis, dhali kar jin this dhali jin ’boro’d e bwaman shi/in pem mo. ");
INSERT INTO udu_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Dhalku/ ki biṯ aha/ asho ’peni buŋ’kus pini mo, dhali dhalku/ ki bu’th Shi/in dhelel dhelel pini ’peni aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Wari bwaŋ ’kunyga/ is e aha/ mo e bway gi mowoṯẖ pini mo, dhali buthi aha/ me’d ki bwa gi shi/in mo. ");
INSERT INTO udu_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Dhali yan’ko’d aha/ mina ṯor imandhaŋ gwo bway pini mo, dhali imanmii miinthus mo mini ṯu’k mo e /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","’Cuḵi aha/ mo ’pena bas gi aha/ jin dina mii i’ba/ mo, ayy Arumgimis, /e jin tana Arumgimis mo tani ita bway gi mowoṯẖ pem mo be, dhali ale’d pem midi yuḵ gway ki ’kal ’kal gom mony’cuḵ pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ayy Tap̱a, ḵa’di /e ’twa/ pem mo ma, dhali ’twa/ pem midi ṯor momaŋ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Haali/ /e dina bwa ki ’kuny mo e mo jin ’ciṯẖu/ to ’kus mmomiiya bas mo. Waḵki/ aha/ mina ’taki c̱i to ki me’d mmoc̱i’th ki o’d mo tani /e mini ’taki diki ’bor bwa mo be. ");
INSERT INTO udu_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","To jin ’ciṯẖu/ ’kus mmomiiya bas jin mish ma Arumgimis bu’th mo tani a’di ta shi/in jin ’ce’dkunu mo. Dhali mo ma du jin ’ce’du mo dhali adu jin waki’d mo tani, ayy Arumgimis, /e mini diki usha ush mo. ");
INSERT INTO udu_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Miiyi ki ’bore/ gom Sihyuun mo e bwaŋ ’kunygam pini mo. Nyaŋi doḵ/e agoŋ gi Pa Urushaliim mo. ");
INSERT INTO udu_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Dhali yan’ko’d /e mina bwa ’kuny mo e to jin c̱inu ki me’d mo mmo’ciṯẖ ’kus jin ’boro’d mo, dhali e to jin c̱inu ki me’d mo mmoc̱i’th ki o’d mo dhali kun c̱ithu/ ki o’d ka ’bimpil mo, dhali yan’ko’d gwasimbip̱ uni minu ’ciṯẖ ’kus eya gwaṯam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Atinta kara /e ’ba/ ki ca mo, ayy wathi/ jin c̱a’bki dem dem mo? mmota pibi ap̱o/ ’kwani kun tana gayiin mo. Isa yempa/ /e kar gwo shiyi’d e ilu/ mo mmo’ce’da ’ce’d sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","’Twam pini kaaka me’da nyer mo, /e jin tana manmii mii jin hekuwa he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","/E ki en tonthus mmobol jin ’boro’d e mo dhali /e ki o gwo ka ṯor mmobol gwoŋ gana/ e mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","/E ki en aris gwo kun losina los mo, ayy /e jin tan ma le’d pini ahe’k e ka he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Hili Arumgimis midi ’ce’d /e bwa ka ’cesh ki sule/ mo. A’di midi bor /e mo dhali dher /e bwa mo ’peni gu’b burrinyem pini mo. Dhali /e minu yu’d mo ’peni mo jin ’kona ’kwani mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Uniŋ ḵar/e mini p̱ar e mo dhali ḵo/ is mo dhali p̱e’th a’di mo mmo/o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Hili wathi/ yan jin ’tena bwa mmokara Arumgimis ki a’dim piti jin hura a’di jwa icine/ mo, hili a’di ki gam gwo is e tom piti jin ishin ka enthus jin tana a’di pa ki pa mo, dhali a’di ki ŋap̱ mo jin huru jwa e ’penkap̱an piti jin tana a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Hili aha/ wana e ki cwa seṯuun jin c̱a’bki go’d go’d e gu’b ma Arumgimis mo. Aha/ gamkina gwo is e mo/en ma Arumgimis jin ṯelu sho’k ki sule/ ki sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Aha/ mina c̱i /e bwam ’boro’di is ki sule/ ki sule/ mo, haali/ /e miiki a’di mo. Aha/ mina bah gway pini haali/ a’di ’boro’d mo be, e buŋ’kus uni kun tana gayiin mo be. ");
INSERT INTO udu_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","A’di jin ta p̱us mo tani o gwo eya dum piti mo ki: Arumgimis p̱iyi’d mo. Uni p̱u/kin mo, dhali uni mii mii kun bulabul mo. Jaŋ kamu/ jin mii’d ka ḵar/e yisa di’da. ");
INSERT INTO udu_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Tap̱a hilki mo ka luŋgu’b ’peni mis ap̱o/ uc̱i gi ’kwaniny’cesh mo mmop̱ar e mo waḵki/ jan ṯal ’deŋ kamu/ mii mii ki yuḵ yuḵ mo, mmosimm jasi Arumgimis e mo. ");
INSERT INTO udu_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Uni ’baar mo iikini dheres mo, uni ’baar mo wakina e ki to kun p̱u/kin mo. Jan ṯal ’deŋ kamu/ yisa di’da jin mii mii jin ’boro’d mo, ṯal ’de/ p̱iyi’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","’Kona uni ki nyiṯẖa, aris uni gwansan kun mii tonthus mo, uni kun shwa ’kwanim pem me’d tonṯe/ mo dhali uni ’koki yuḵa Arumgimis mo? ");
INSERT INTO udu_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Uni nanni kun ’kon e dhan mo kun ḵogu is mo, mo jin ḵogu is wakan diki di ’peni kadhamo/ mo. Haali/ Arumgimis midi rasa sima/ gi ’kwani kun ushuna Arumgimis mo. Uni minu dhu ki mo ma ’the is mo haali/ Arumgimis waḵki uni mo be. ");
INSERT INTO udu_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Ayy mo jin ’cuḵuwa ’cuḵ gom ’Kwani ma Israyiil mo tani a’di midi ’taki p̱u’du/ ’pena Sihyuun moyi. Ka Arumgimis midi wara shamaneṯṯan ki ’kwanim piti is mo tani Yakuub mina bwa ’kuny mo dhali Israyiil mina bwa ’bor mo be. ");
INSERT INTO udu_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Tayi aha/ is ki me’d mo ma, ayy Arumgimis mo, ki gway pini mo, dhali yeyi aha/ mo ki mo ma dem dem pini mo. ");
INSERT INTO udu_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Ciḵi mon’thom pem mo ma, ayy Arumgimis. C̱iyi ’cem pini ki gwo gi ’twa/ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Haali/ iman/ush ’kwani ga/ mo tani uni cu mis ap̱o/ aha/ mo, dhali imangora bwa ki gor mo tani uni ŋap̱ki mondiki/em pem mo. Dhali uni ’koki kara Arumgimis ibwambori jis/em buni mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Hili mo mo ma, Arumgimis ta’da manwoṯẖ pem mo, dhali Tap̱a a’di ta’da manṯel aha/ mondiki/em pem sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","A’di midi ri’c ’kwani kun ta ’kup̱ ki aha/ ki tonthus mo. Dhali e mii ma isiŋ ganam pini mo tani /e mini daḵ uni ’pemen buni ’kup̱ mo be. ");
INSERT INTO udu_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Ki bwam pem jin di ’baḵany mo tani aha/ c̱ina to jin ’ciṯẖu/ ’kus mmomiiya bas ki /e mo. Dhali aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki gway pini mo, ayy Tap̱a, haali/ mii yan a’di ’boro’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Haali/ /e ’cuḵki aha/ mo ’pena ris monṯo’c bwam pem mo, dhali em pem hilki mo jin p̱inu mii e ap̱o/ ’kwani gun ta ’kup̱ ki aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","C̱iyi ’cem pini ki mon’thom pem, ayy Arumgimis. Dhali dhalki is pini ki ba’k mo ’peni tom pem jin doṯka/ ka di’b is mo. ");
INSERT INTO udu_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Ḵuthi is gom aha/ mo, dhali thoḵi aha/ gwo mo. Aha/ kumu ’twa/a ’cesh ki monṯo’c bwam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Dhali aha/ guskina du mo gom cuuwa/ gi ’kwani kun ta ’kup̱ mo, haali/ ’kwani kun ta thus ki thus mo tani uni siri’ckina siri’c ki sho’k mo. Haali/ uni ḵali mo jin ṯoju bwa ap̱o/ aha/ mo dhali ka nyor mo tani uni ki thip̱ mo ma dup̱e/ ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Dhali adum pem ’pe’di she/ e bwaman is pem mo, dhala pure/ gom mowu biṯki’da p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Moŋḵo/ is dhali mondee is p̱u’dkina p̱o/ aha/ mo, dhali to jin ḵo/ki aha/ is mo tani uni kumki aha/ ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Dhali aha/ ona gwo mo ki: Ayy waḵki/ aha/ mina ’taki ta ga bi me’d gurko/ mo tani aha/ mina ’taki p̱e mo dhali si/ is mo be. ");
INSERT INTO udu_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nye, aha/ mina ya si’dasi’d moyi Aha/ mina ya c̱a’b e mombwaasho moyi. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Aha/ mina lala ki jahanneyi dhali gama darha’dam pem ’peni mo ma bumburush ’tham mo dhali ’thama p̱unthar mo. ");
INSERT INTO udu_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","’Ce’di tom buni jin thosona uni sho’k sho’k mo ma, ayy Tap̱a. C̱umbulki uni ale’d buni mo, haali/ aha/ hilkina mo jin bujura bujur mo dhali mo jin biruwa bir e ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Montee dhali mon’thiny uni iikin ka kul is e yana gaŋgaram piti mo, dhali mo jin tanuwa pibi dhali mo jin ṯoju bwa mo tani ’kon e uni mo. ");
INSERT INTO udu_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Mo jin doru sho’k ka pupush mo tani a’di di’d e bwaman a’di mo, dhali mo jin sirijuwa siri’c ki sho’k mo dhali mo jin hekuwa he’k e mo tani uni ’koki ii mo ’peni mo ma suug piti mo. ");
INSERT INTO udu_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","A’di diki ta a’di jin ta ’kup̱ ki aha/ jin ’bakaa e mo – ki aha/ mina ’taki mish a’di ḵal mo. A’di diki ta a’di jin ta ’kup̱ ki aha/ jin ṯu/ul mo jin gora bwa ki gor ap̱o/ aha/ mo, ki aha/ mina ’taki bag ’peni a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Hili /e be, jin wa e ki aha/ ki is pem mo, /e jin nyaḵ ya ki aha/ mo, dhali /e jin tana waḵ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Me’dyin mo ana nyaḵa ṯor ṯori monṯal ’de/ mo jin ’kunya’kuny mo. E gu’b ma Arumgimis mo tani ana iina mmonyaḵ to mii mo. ");
INSERT INTO udu_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Dhalki mowu p̱u’du’d ap̱o/ uni mo. Dhali dhalki uni ’donu ki e eya Haawiya mo. Dhali dhalki uni iin e bwaya pure/ gi moŋ’kup̱ajem buni mo. ");
INSERT INTO udu_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Hili aha/ yuḵkina Arumgimis mo. Dhali Tap̱a midi ta aha/ is is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Mom’pimpili/ dhali mon’thamo/ dhali montee mo tani aha/ bahkina gwo ma ’thup̱in ’twam pem mo dhali ko mo, dhali a’di midi ciḵ ’twam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","A’di midi ’cuḵa ḵashiram pem ki ’dantar mo ’peni mo ma mee jin miga/ ’taki as mo, haali/ ’kwani tana ris miina bumburusha p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Arumgimis midi c̱i ’cem piti mo dhali dhu uni ki gwa’d mo, a’di jin diki’d eya ḵursi ma maliḵ kadhamo/ mo. Haali/ uni ’koki dhu gwoŋḵan jin c̱inu mo dhali uni ’koki ḵo/ Arumgimis mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Amannyaḵ yam pem a’di he’thki’da bim piti mo ap̱owa mugum piti mo, a’di ’ce’dki gwom piti jin gama a’di me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Gwom piti jin ona a’di mo tani a’di na’bulana’bul mmobola yina ko e mo, hili anyor di’d eya dum piti mo. Dhali gwom piti ’capuṯa/ ’capuṯ mmobola yin e mo, hili uni wana e ki gandal kun ’de’kkunu she ki mis mo. ");
INSERT INTO udu_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Ṯaki to jin diṯi’d pini ap̱o/ Tap̱a mo dhali a’di midi ḵal gom /e mo. A’di midi diki dhal jaŋ kamu/ jin ta’da ḵar/e mmojoc̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Hili /e ayy Arumgimis mini ṯa’k uni ka luŋgu’b mo e jis jin ’kula’kul mo. ’Kwani kun wol tiya bas mo dhali kun wa’thkina wathi/ e mo tani uni mini ’koki ’ko ki e mo ka teem bunin ’de/ i’tu’d mo. Hili aha/ mina gam gwo is e /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Miiyi mii ka ’the gom aha/ mo ma, ayy Arumgimis, haali/ ’kwani yap̱ki aha/ ki sho’k mo. Yula tente/ mo ’kwani kun ta ’kup̱ ki aha/ uni siri’cki aha/ ap̱o/ ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Uni gun ta ’kup̱ ki aha/ mo tani uni yap̱ki aha/ ki sho’k mo yula tente/ mo, haali/ ’kwani tana ris kun askina p̱o/ aha/ ki ’ba/ gun dhuna uni ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Ki aha/ ḵo/kina is mo tani aha/ karkina moŋgam gwo is pem e /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Eya Arumgimis mo, a’di jin maŋka/ gwom piti mo, eya Arumgimis mo tani aha/ gama gwo is ki dar gi moŋḵo/ is mo. Buŋgwar is midi miiya tinta ki aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Yula tente/ mo tani uni simmki mii e mo mmotaḵ aha/ jama/ gom tom pem jin raḵki aha/ mo. Aris gwom buni ’baar mo kun kulumkina uni ibwa ap̱o/ aha/ mo tani uni ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Uni ’tuntulki is buni imonṯal ’de/ mo, dhali uni wup̱kina ’cesh mo. Uni c̱orki ŋaṯgin pem mo. Me’d jin c̱orkina uni mondiki/em pem mo, ");
INSERT INTO udu_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","wakan raḵi uni to ibway mo gom tonthus buni mo kun miikina uni mo, ka nyor pini mo tani Arumgimisa, ṯaki ’kwani gwan ka ’cesh mo, ayy. ");
INSERT INTO udu_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","/E deŋki yam pem jin wuŋkulkika/ e mo. Ṯe’di jabu’th em pem eya gasaas pini mo. ’Kona uni ki ’ko eya warkam pini mowa? ");
INSERT INTO udu_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Dhali yan’ko’d mo tani uni kun ta ’kup̱ ki aha/ mo tani minu ṯu’k ka nyaŋ’ko’d mo ka tee jin miga/ yuḵa yuḵ mo. Dhali aha/ misha ka jiŋ gana/ ka Arumgimis ta a’di gom aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Eya Arumgimis mo, a’di jin maŋka/ gwom piti mo, e Tap̱a, a’di jin maŋka/ gwom piti mo, ");
INSERT INTO udu_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Eya Arumgimis mo tani aha/ gama gwo is ki dar gi moŋḵo/ is mo. Ton tinta a’di imina ’kwani mii gom aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Gwom pem kun oka/ is e /e mo tani aha/ mina thim uni mo, ayy Arumgimis. Aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki to jin c̱inu mmo’ciṯẖ ’kus gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Haali/ /e ’cuḵkina ḵashiram pem mo ’peni mowu mo, nye, sho’k pem ’tasha /e ’twa/ ’peni mombiṯ mo, ki aha/ mina ya ibwambor ma Arumgimis mo, e moŋkush gi mondiki/e mo. ");
INSERT INTO udu_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Miiyi mii e aha/ mo, ayy Arumgimis, dhali miiyi mii e aha/ mo, haali/ e /e mo tani aḵashiram pem bu’thki mo jin huru jwa mo. Dhali eya la ma bim pini mo tani aha/ bu’thkina mo jin hurga/ jwa mo, ntagi ’thama p̱unthar jin ’ce’di’da ’ce’d sho’k peki’d mo be. ");
INSERT INTO udu_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Aha/ gwokina ’twa/ Arumgimis jin Caa e ki Ca mo, eya Arumgimis jin thimki ’kup̱ miim ’boro’d piti gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","A’di midi hasha hash ’peni momis dhali ta aha/ is ki me’d mo, dhali a’di midi dhu uni gwansan ki mon’the is mo, uni gun yap̱ki aha/ ki sho’k mo. Doshi ma dhali ’cunycuri yan mo. Arumgimis midi hashi mo/en piti jin ṯelu sho’k mo dhali mii ma isiŋ ganam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Aha/ isha e bwaman ma risa dhop̱ mo uni gun pitilki iya/ gi ’kwani bwa ki she/ mo. Shem buni waka mee mo dhala thop̱a/ mo, dhali ale’d buni kaaka me’d gandal mo be. ");
INSERT INTO udu_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Dhalki /e karu ki ca mo, ayy Arumgimis, ap̱owa ris momisi ’baar mo. Dhalki monycam pini a’di di’da p̱o/ mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Uni karkina kume/ gom ŋaṯgin sho’k pem kun dhuka/ mo, aḵashiram pem a’di di ki ’kup̱ ka luŋgu’b mo. Dhali uni c̱wanyki jis e bway pem jin yaka/ mo, hili uni ki is buni uni iṯa’kkin e jis buni jin c̱wanya uni mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Adum pem ṯelkunu sho’k mo, ayy Arumgimis, adum pem ka jiŋ gana/ a’di ṯelkunu sho’k mo. Aha/ mina yuḵ gway mo dhali nann gway mo. ");
INSERT INTO udu_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Meri e mo ma, aḵashiram pem. Meri e mo ma, ayy adheŋdhenye/ dhali adheŋdhenye/ jin ’kon ma shu/i pesu/ mo. Aha/ mina mer mo gi mon’thamo/ e mo. ");
INSERT INTO udu_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki /e mo, ayy Tap̱a, e bwaman ma ris ’kwani mo. Aha/ mina yuḵ gway mo dhali maŋ /e mo e bwaman ma ris kal gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Haali/ mo/en pini jin ṯelu sho’k mo tani a’di caaca kagahara e momis mo, dhali mo ma isiŋ ganam pini jin tana /e mo e bwaman ma risa raḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Dhalki /e karu ki ca mo, ayy Arumgimis mo, ap̱owa ris momisi ’baar mo. Dhalki monycam pini a’di di’da p̱o/ mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","A/um ka jiŋ gana/ ḵani gwo ki isi ḵan gana/, um kun ta ’kwani ma tul ’kup̱a? A/um dwalli iya/ gi ’kwani gwo ki dwall gana/ mowa? ");
INSERT INTO udu_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Yisa, eya dum bum mo tani um usha ’ce ’kol mo eya dum bum gom tonthus mo. Me’d bum ṯu/ul mo jin bujura bujur e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Imanmii tonthus mo iikini dheres mo ’peni bwa gi ikum mo, uni thamki mii ’pena cim gun dhodhu uni mo tani uni thamki gwo o ka ṯor mo. ");
INSERT INTO udu_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Uni tan ga ṯi’d me’da ṯi’d tasha/ mo, me’d tashan ’thi/ jin ta’da ’diye/ mo jin ’dap̱ki bwany’cem piti ’twa/ mo, ");
INSERT INTO udu_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","wakan jin mina a’di diki ciḵ gwalish gi wathi/ mo walla laṯ jin laṯu/ a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Ayy Arumgimis, ’ce’dki uni she/ e bwan ’twam buni mo. Buḵki uni sheŋ gwoliŋgwoṯẖa/ mo ’peni ushi dhuru’c ma dhop̱ mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Dhalki uni p̱ikin ki jahanne/ me’d yi’de/ jin gusu’di ’ciṯẖ ’pen mo, dhali wa e ka sho si’da/ jin tora moŋḵuthu’d ’ko’da ’cesh mo dhali ḵu’th mo. ");
INSERT INTO udu_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Dhalki uni wana e ka homo’th jin yu moros mo, dhali me’da ’ci jin ṯagu ka dho’th piti jin molo’da tente/ p̱ar e mo be. ");
INSERT INTO udu_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Ki ’dishe/ tani anos bum mina ’ko’d gwari ’batha’ba’th me’da ’de/ jin shwana o’d mo, waḵki/ ta’da go’d go’d walla diki’d mo/o’d mo tani dhalki a’di dhi’th uni sho’k ki jahanne/ mo. ");
INSERT INTO udu_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Amanmii miiŋḵar/e mo tani a’di mina bwa ’kuny mo haali/ a’di midi p̱ar mo jin ri/uwa ri’c e mo be. Dhali a’di midi lam sho’k piti ka bas gi ’kwani kun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","’Kwani mini o gwo mo ki: Ka jiŋ gana/ to jin ish ḵumma/ mo tani di’d gom ’kwaniŋ ḵar/e mo. Ka jiŋ gana/ Arumgimis di’d mmodwall gwo ap̱o/ mony’cesh mo be. ");
INSERT INTO udu_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","’Cuḵi aha/ mo ma ’peni ’kwaniŋ ’kup̱ pem mo, ayy Arumgimis pem, ceshi aha/ ’peni uni gwansan kun cuuna p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","’Cuḵi aha/ mo ’peni uni gwansan kun mii tonthus mo, dhali tayi aha/ is ki me’d mo ’peni ’kwani gwansan kun ’kosha ṯe/ mmowol ’kwaniya bas mo. ");
INSERT INTO udu_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Haali/, hili mo mo ma, uni ishkin mmoc̱or mondiki/em pem mo, ’kwani kun ’cithira/ ’cithir mo tani uni ’tuntulki is buni imonṯal ’de/ ap̱o/ aha/ mo. Gom gwon dhaŋ pem walla miinthus pem yisa, ayy Tap̱a, ");
INSERT INTO udu_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","walla gom miim pem jin thamka/ yisa, uni urkina uri sho’k mo dhali thoson is mo. Muri is pini mo, dhali p̱u’du/ mo dhali woṯẖ aha/ mo, dhali p̱ari mii yan e mo. ");
INSERT INTO udu_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","/E, jin ta Tap̱a Arumgimis gi momis mo tani, /e tana Arumgimis ma Israyiil mo be. Meri is mo dhali c̱iya ris kal gi ’kwaniny’cesh to kun wana e ki miim buni mo. Dhalku/ ki dhal jan ṯal ’deŋ kamu/ bway mo ’peni uni gwansan kun ’dap̱a e ki mii ma wu’th gi tonthus mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Mom’pimpili/ isa yempa/ mo tani uni p̱u’dkin ka nyaŋ’ko’d mo mmobuḵ me’da ’ka ka ris mo dhali ’thil is buni e ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Uni anann be, gwona bomboḵ ki ’twam buni mo, dhali ḵaa ’twa/ i is ki ’twam buni mo – haali/ kaja ikuluma uni gwo ibwa mo mmo/o gwo mo ki: Kaja imidi ciḵ ana mo? ");
INSERT INTO udu_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Hili /e, ayy Tap̱a, /e p̱e’thki uni mo, dhali /e dhukina ris kal gi ’kwaniny’cesh mmota uni gun waḵu mo. ");
INSERT INTO udu_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Ayy Mom’bi’th pem mo tani aha/ mina yuḵ gway mo mmomaŋ /e mo, haali/ /e, ayy Arumgimis, tana cur pem jin ṯenu gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Arumgimis pem jin di’d e mo/en piti jin ṯelu sho’k mo tani a’di midi gam aha/ ’kup̱ mo. Dhali Arumgimis pem a’di midi dhal aha/ bway mo mmop̱ar mo jin p̱inu mii e mo ap̱o/ uni gun ta ’kup̱ ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Dhalku/ uni ki ’kosh jwa mo, isi ciki/ tagi ’kwanim pem mini this uni e mo. Dhuyi uni mmomol dosh shoka ’cesh mo ki mom’bi’th pini mo, dhali ’doku/ uni ka luŋgu’b mo, ayy Tap̱a, jin ta jim bam jin ta’da goŋgoro/ mo. ");
INSERT INTO udu_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Haali/ gom miinthus kun miikina uni ki ’twam buni mo, dhali ki gwo ma le’d buni mo, dhalki uni bu’th ma kume/ gi ’bam buni kun dhuna uni ki ca mo. Gom gwo ma jee dhali gwo ma ṯor kun baha uni mo tani ");
INSERT INTO udu_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","shwayi uni ki ’ci’d’da/ ka nyor pini mo, shwayi uni ki ’ci’d’da/ ntagi uni mini ’koki ’ko doḵ/e mo, ki ’kwani mini mish ki /e tana Arumgimis jin ji ’kwani ma Yakuub mo ntagi ’pemen gi mony’cesh mo be. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Mom’pimpili/ isa yempa/ mo tani uni p̱u’dkin ka nyaŋ’ko’d mo mmobuḵ me’da ’ka ka ris mo dhali ’thil is buni e ’peŋkuman bampa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Uni tani mo ki tantan gom tonṯe/ mo, dhali cesh mo ki ŋarŋash mo waḵki/ uni ’koki kap̱a dum buni mo. ");
INSERT INTO udu_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Hili aha/ mina yuḵ gway gom mo ma dem dem pini mo. Dhali aha/ mina yuḵ gway ki ’kal ’kal gom mo/en pini jin ṯelu sho’k mo e mon’thamo/ mo. Haali/ /e takina cur jin ṯenu gwo gom aha/ mo dhali /e ta jim pem jin hurga/ jwa icine/ mo ka teem pem jin dika/ ka c̱is mo. ");
INSERT INTO udu_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Ayy Mom’bi’th pem mo tani aha/ mina yuḵ gway mo mmomaŋ /e mo, haali/ /e, ayy Arumgimis, tana cur pem jin ṯenu gwo mo, /e jin tana Arumgimis jin ṯorki aha/ mo/en pini jin ṯelu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Ayy Arumgimis, /e waḵki aman mo, dhali ’ce’d mom bam jin ’ce’du/ gwo she/ mo. /E miikina nyor mo. Ayy, waru/ aman is mo ma. ");
INSERT INTO udu_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","/E karki mony’cesh mmoyiḵin is mo. Dhali /e ki ’twaḵ a’di bwa mmotheḵ she/ mo. Nyaŋi a’di ka nyaŋ’ko’d mo e mom piti jin shi/ki’d mo, haali/ a’di mol dosh shoka ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","/E ki dhal ’kwanim pini mmo’kosh is ka nyor ki to kun ’batha’ba’th mo, /e ki dhu am me’d ’kwani kun sona du mo gom to kun diṯadiṯ kun ’kosh am mo. ");
INSERT INTO udu_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","/E ki kar mom pini jin ta’da berag gom uni gwansan kun ḵo/ki /e mo, mmocuna uni ki bimbir ’peni a’di jin ta jiŋ gana/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Wakan ki unim pini gun ena /e mo minu ’cuḵ mo, c̱iyi mo jin p̱inu mii e ki me’da bim poros pini mo dhali thoḵ am gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Arumgimis oki gwo e mom piti jin ḵogu mo. Nyaḵki gway jin yuḵu ki moŋ’kuny bwa mo tani aha/ mina ḵwa/ Pan Shakiim bwa mo dhali dhu uni ka bwanykin ’peni embul ma Sukkuut mo. ");
INSERT INTO udu_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Dhala Jil/aad, a’di ta jim pem mo. Dhala Manassa a’di ta jim pem mo. Dhala Ep̱rayim a’di ta toŋ’kup̱ pem mo. Dhala Yahuuda/ a’di ta cwa ma maliḵ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Muwab a’di ta mom pem jin ’thurka/ me’d mo. Dhali ap̱o/ Pan Aduum mo tani aha/ yip̱a p̱p̱am pema p̱o/ mo. Dhali ap̱o/ Pam P̱alasthiin mo aha/ mina ’ther cuuwa/ gom mo jin p̱inu mii e mo be. ");
INSERT INTO udu_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Kaja a’di imidi sus aha/ e ’peŋkuman bampa/ jin ṯenu gwo mo? Dhali kaja a’di imidi shu aha/ bway mo e Pan Aduum mo? ");
INSERT INTO udu_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","/E a’di idiki waḵ amana, ayy Arumgimis? /E diki ḵal ya ka bor mo, ayy Arumgimis, nyaḵki ’kwani ma meem bam mo. ");
INSERT INTO udu_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Ayy ṯuka bor ma, woṯẖ am mo ’pena p̱o/ ’kwani kun ta ’kup̱ ki am mo, haali/ mowoṯẖ jin ta gi wathi/ mo tani a’di ta jim p̱e’th mo be. ");
INSERT INTO udu_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Nyaḵka Arumgimis mo tani ana p̱ina mii e mo haali/ a’di ta a’di jin siri’cki uni gun ta ’kup̱ bana ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Ciḵi gwom pem mo ma, ayy Arumgimis, kari ’ce gom mon’thom pem mo, ");
INSERT INTO udu_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","’peni ’pemen gi mony’cesh mo tani aha/ yuḵkina /e mo me’d jin ’thin ma dum pem buye/ mo be. Susi /e aha/ mo e wosh c̱aan jin turatur mmobol aha/ e mo, ");
INSERT INTO udu_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","haali/ /e ta jim pem jin hurga/ jwa mo, /e ta a’di jin waki gu’ba turga/ jin ’bitha’bi’th ap̱o/ ’kwani kun ta ’kup̱ ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Dhalki aha/ c̱a’ba e gu’b burrinyem pini ki sule/ sule/ mo. Ayy mmodi ki ’dantar e bwaŋ’kwariny ma darha’dam pini jin ta’da bi mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Haali/ /e, ayy Arumgimis, ciḵki gwom pem jin oka/ is mo, /e c̱iki aha/ mal gi uni gwansan kun ḵo/ki gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Galali mondiki/e ma maliḵ mo. Dhali dhalki yil piti ’dim ’kup̱ ntaga risa nyaḵum yil gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Dhalki a’di karuwa ḵursi ma maliḵ ki sule/ sule/ ibwambor ma Arumgimis mo. Dhalku/ ki non mo/en jin ṯelu sho’k mo dhali mii ma isiŋ gana/ mmotim a’di ap̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Dhali aha/ mina yuḵ gway mo mmomaŋ gway pini mo, me’d jin c̱ikika/ gwom pem jin oka/ is ’ko’da tee ’ko’da tee mo. ");
INSERT INTO udu_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Goma Arumgimis ’de/ mo tani a’di ic̱or ma ḵashiram pem ki shwamm mo. ’Peni a’di mo tani mowoṯẖ pem p̱u’dki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","A’din ’deŋ gana/ ita wosh pem mo dhali bway gi mowoṯẖ pem mo dhali acur pem jin ṯenu gwo mo. Ki aha/ minu ’koki joc̱ mo ki joc̱ jin shiyi’d mo. ");
INSERT INTO udu_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Um mini daḵ mo kakasja mmo’ko ap̱o/ ’kwani mo mmo’ce’d uni bwa mo, aris umi ’baar mo, kun wana e ka goŋ kun ishki gal mo, agoŋ jin dar gi mo jin kar shoka ’cesh mo? ");
INSERT INTO udu_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Uni i’kona gwo ibwa mo mmoyap̱ a’di ki sho’k ’pena ris ’kup̱ piti mo. Uni ’kunykina bwa ki ’kuny gom gwon thus mo. Uni ’borki ’twam buni mii mo, dhali hili e bwaman ma dum buni mo tani uni jeekina jee mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Goma Arumgimis a’di ’de/ mo tani a’di ic̱or ma ḵashiram pem ki shwamm mo. Haali/ mo ma ’teŋ kap̱em pem mo tani a’di ’peni a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","A’din ’deŋ gana/ ita wosh pem mo dhali bway gi mowoṯẖ pem mo dhali acur pem jin ṯenu gwo mo. Aha/ minu mol yiḵin is mo be. ");
INSERT INTO udu_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Eya Arumgimis mo tani mom pem jin sika/ is gom mony’cuḵ mo dhali montaḵ mo tani ’kon e a’dim pem jin ta wosh jin eḵa/ eḵ mo, dhali a’dim pem jin hurga/ jwa mo tani a’di ita’da Arumgimis mo be. ");
INSERT INTO udu_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Gami gwo is e a’di ka tee i’baar mo, ayy ’kwani. Woli adum bum ibwambori a’di mo. Haali/ Arumgimis ta a’di jin mina ana hur jwa icine/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","’Kwani kun hatha moŋ’ko ’ko’d ki ha’th mo tani hili ’kon jasi ari’ceenne/ mo. ’Kwani kun ’kon e mo jin kap̱a ’penkap̱an mo tani suskunu this e mo eya dum buni mo. Dhali mombar buni ’deke’thki’d isi mis mo. Uni tawasha tawash mo mmobola wulp̱e/ e mo. ");
INSERT INTO udu_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Dhalku/ ki dhu mo jin wunu awuny jwa i is e mo jin dilu to mo. Dhalku/ ki dhu mo ma ’te/ ma kap̱em bum ki p̱e’th e mo jin ḵwalu to mo. Waḵki/ mo jin tanu pa ki pa mar is mo tani dhalku/ ki dhu adum bum ’ko’di uni mo. ");
INSERT INTO udu_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Me’d ’de/ Arumgimis oki gwo mo. Me’di su/ mo tani aha/ ciḵkina gwo yansan mo ki mom’bi’th ta jima Arumgimis mo ");
INSERT INTO udu_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","dhali e /e mo tani ayy Tap̱a, mo/en jin ṯelu sho’k mo cila /e mo. Haali/ /e ki raḵ wathi/ to ibway mo isi ki miin to jin miina a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Ayy Arumgimis, /e tana Arumgimis pem mo, dhali aha/ simmkina /e e mo. Aḵashiram pem ’kosha ṯe/ /e mo. Buŋgwar is pem ’thina buye/ gom /e mo me’d mo jin ḵuthaḵu’th mo dhali mony’cesh jin ta toŋkor jin dina yi’de/ ki di mo be. ");
INSERT INTO udu_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Wakan aha/ hilkina ap̱o/ /e e mo jin ḵogu mo mmohil mom’bi’th pini mo dhali monyca mo. ");
INSERT INTO udu_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Haali/ mo/en pini jin ṯelu sho’k mo tani a’di ’borki’d mo mmobol mondiki/e e mo, ’twa/ pem midi maŋ /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Wakan aha/ mina ’bor /e mii mo isi me’d jin miga/ di ki e mo. Aha/ mina ’de’k me’d pem ’kup̱ ki mis mo dhali yuḵa yuḵ ap̱o/ gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Aḵashiram pem a’di ’kunykina bwa mo me’d ki monoro’d mo dhali c̱a’bki momoṯ momoṯ mo dhali ’twa/ pem a’di maŋki /e ki moŋ’kuny bwa jin ta ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Ki aha/ kulumkina gwo ibwa gom /e ap̱owa cim pem jin ishka/ mo dhali kulum gwo ibwa gom /e mon’thiny kun timka/ tim mo. ");
INSERT INTO udu_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Haali/ /e tana manwoṯẖ aha/ mo, dhali eya la ma bim pini mo tani aha/ yuḵkina gway gom moŋ’kuny bwa mo be. ");
INSERT INTO udu_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Aḵashiram pem koṯẖki /e me’d mo. Dhali me’da bim poros pini bu’thki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Hili uni gwansan kun simmki mondiki/em pem e mo mmo’ce’d a’di sho’k mo tani uni mini ii ka luŋgu’b e mony’cesh jin ’kula’kul mo. ");
INSERT INTO udu_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Uni mini c̱iku/ e mom’bi’th gi gandal jin kaaka mo. Uni min ma jala/ i’kwar ka gwap̱i/ mo. ");
INSERT INTO udu_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Hili amaliḵ mina bwa ’kuny eya Arumgimis mo. Aris uni gun thulkunu me’da p̱o/ ki a’di mo tani uni mini ca mo, haali/ ’twa/ gi uni kun tana ṯor ka ṯor mo tani minu ’dap̱ ’twa/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Ciḵi ’twa/ pem ma, ayy Arumgimis, goma ’thup̱in ’twam pem mo. ’Tashi mondiki/em pem ’twa/ mo ’peni mo jin kar aha/ ki mo ma ḵo/ is gom uni kun ta ’kup̱ gi aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Bagi aha/ mo ’peni ’kwanin thus kun miina wu’th ka ḵwal is mo, ’peni mo jin ’konu gwo ibwa mo mmomii to jin ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Uni gun cilkina le’d buni me’d gandal kun kaaka mo, kun ṯurki gwo kun kaaka me’da thop̱a/ kun ṯuru/ to mo, ");
INSERT INTO udu_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","mmo’kosha ’kosh ’peni mo jin isha uni ki jim bag ap̱o/ wathi/ jin dar gi mii ’ba/ mo, mmo’kosh a’di ki jahanne/ mo dhali dar gi moŋḵo/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Uni buthi tonthus buni me’d mo, dhali uni ṯorkina ṯor goma gume/ kun ’thina uniya ’cesh ka ḵwal is mo mmokulum gwo ibwa mo mmo/o ki: Kaja mini p̱ar ana e mo? ");
INSERT INTO udu_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Dhali kaja a’di imidi ŋap̱ ana ki bur bur gom miim bana kun ’ko ana i’ba/ mo? Ana kulumkina gwo ibwa ki e kun korakor mo mmobwaa wu’th mo. Haali/ isi bwaman bwa wathi/ mo dhali adu mo tani a’di ’kula’kul mo. ");
INSERT INTO udu_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Hili Arumgimis a’di midi shinka thop̱a/ ka luŋgu’b e uni imun mo, uni mini ta jama/ ki jahanne/ mo. ");
INSERT INTO udu_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Haali/ goma le’d buni mo tani a’di midi ’doyi uni e mo jin kup̱u/ mo. Aris ’kwani kun mini p̱ar uni e mo tani mini bir ’kup̱ buni mo be. ");
INSERT INTO udu_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Dhali yan’ko’d aris ’kwani ’baar mo mini ḵo/ is mo dhali uni mini ṯor to jin wagaskin ma Arumgimis mo, dhali kulum gwo ibwa mo gom to kun miikina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Dhalki a’di jin mii miiŋḵar/e ’kunya bwa mo e Tap̱a mo dhali bu’th mo jin huru jwa e a’di mo. Dhalki uni gwansan kun dhelel ma du mo tani can mo. ");
INSERT INTO udu_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Momaŋ a’di ’dap̱a’d ki /e mo, ayy Arumgimis, eya Sihyuun mo, dhali e /e mo tani gwo jin onu is minu mii thim mo, ");
INSERT INTO udu_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","ayy /e jin ciḵki mon’tho mo. Haali/ e i /e mo tani a’di ipiyina ris buŋgwar is mo ");
INSERT INTO udu_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","haali/ gom gway gi miinthus mo. Ki gwondhaŋ bana p̱iki ana e mo, /e gwamki uni mo. ");
INSERT INTO udu_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Mom’bor mii gom a’di jin kwanykina /e mo dhali guyu/ mmo’dish mo is mo, dhali mmoc̱a’b e bwaagoŋ pini mo. Am minu kap̱ mo ki miim ’borgam pini mo e gu’b pini mo jin ta gu’b pini gi mondheleladhelel mo be. ");
INSERT INTO udu_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Ki dhan miim pini kun miikina /e kun caaca mmothoḵ am ’twa/ ki mony’cuḵ mo, ayy Arumgimis bam jin ta bway mowoṯẖ mo, /e jin ta mo ma ’teŋ kap̱e/ goma ris ’kwani kun ’kokin e ’pemen gi mony’ceshi ’baar mo, dhali uni kun si’dkin mo e bwamp̱owa ris ḵumma/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","/E ki mom’bi’th is pini mo tani /e ṯelki dhan wosh kun turatur sho’k mo, mmoc̱u’th gi mo ma dem dem mo. ");
INSERT INTO udu_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","/E jin doshki yi’de/ jin mii’da ḵuku/ ḵuku/ mo, dhala ḵuku/ ḵukum buni jin birkina uni bakal mo, dhala dulaṯṯ gi ’kwani mo, ");
INSERT INTO udu_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","wakan uni gwansan gun ’kokin e mony’cesh jin si’dasi’d mo tani, uni ḵo/ki is gom jamas miim pini mo. /E ki dhal mo jin yana ya gi mon’thamo/ mo dhali mom’pimpili/ mo mmoḵum cuuwa/ gom bwaŋ ’kunyka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","/E buṯkin e mony’cesh mo dhali wol a’di yi’de/ mo, dhali /e ’kummki a’di ki ’kumm jin caaca kagahara mo. Yi’de/ ma Arumgimis kun son a’di ’tu’dki mo mo. /E ki ’twaḵ emen buni mo, haali/ wakan /e thosonki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","/E wolki a’di yi’de/ ka ceŋjal kun ishkin ka enthus mo, dhali thoson a’di jil piti mo, mmodhal a’di ki c̱o’do/ mo ’pena p̱iriny ma sho’k mo dhali /e ki ’bor a’di mii mo gom ca jin cana a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","/E shumki yil gi mo jin isha to ka enthus kun ta kum pini mo. Jil jin dir ma arabiyyam pini mo tani uni wolki ’twa/ mo ki momoṯ jin momoṯkina uni mo. ");
INSERT INTO udu_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Mo ma shon dhii/i’d gi mombwaasho mo tani wolki ’twa/ mo, dhali aris woshi ’baar mo uni ’kamki is buni ki moŋ’kuny bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Ashom bip̱ uni hi’thki is buni ki mo ma ma’diny mo, dhali embul wosh uni hi’thki is buni ki pos mo, uni ḵumki cuuwa/ mo dhali yuḵ gway mmonṯal ’de/ ki moŋ’kuny bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Yuḵi gway ki moŋ’kuny bwa ki ’kal ’kal goma Arumgimis aris um kun ’koni mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Yuḵi gway ki monyca gom gway piti mo. Dhali c̱i a’di monyca ki momaŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Dhali oyi Arumgimis gwo mo ki: Dhan miim pini ’ka’da mii ca kagahara. Wakan dhan monycam pini ’kuc̱ki uni gun ta ’kup̱ ki /e ibwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Aris ’kwani gi mony’ceshi ’baar mo luŋki /e mo. Uni yuḵki gway mmomaŋ /e mo, uni yuḵki gway gom gway pini mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Iiyu/ mo dhali p̱ar to jin miikin ma Arumgimis e mo. A’di miiki’da dhan to kun caaca kagahara e bwaŋ ’kwani gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","A’di ṯu’kki ḵumma/ yi’de/ mo mmota a’cesh jin ḵuthaḵu’th mo. Dhali ’kwani iikin ki sho’k e bwam yi’de/ jin ḵu’thki’d mo. Dhali e mun mo tani aman ’kunykina bwa mo e a’di mo, ");
INSERT INTO udu_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","a’di jin jiki’da ji ki mo ma dem dem piti ki sule/ sule/ mo, a’di jin timki kal gi mony’cesh gi ’kwani ki em piti mo, dhalku/ ki dhal uni gwansan bway mo uni kun pishi is buni ka le’d mo mmodhu is buni ki ca mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Mom’bor mii goma Arumgimis bana mo, ayy ’kwani, dhalki cuuwa/ jin minu maŋ a’di dhalki a’di ciḵu mo, ");
INSERT INTO udu_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","a’di jin dhuki ana e bwaman ’kwani kun ’kon ki e mo, dhali diki dhal sho’k bana bway mmoyeres mo. ");
INSERT INTO udu_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Haali/ /e, ayy Arumgimis, /e nyo/ki aman mo. Dhali /e palki aman me’d ’dolkon kush jin palu ki o’d mo. ");
INSERT INTO udu_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","/E ki sus am eya gume/ mo. /E ki ’thi monṯo’c bwa e empa’d bam mo. ");
INSERT INTO udu_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","/E ki dhal ’kwani bway mo mmomeri ’kup̱i aman mo. Aman iikina e mo/o’d mo dhali e yi’de/ kun shwana nyor mo, hili /e din mmosus am e embul mo kun beeyabee mo. ");
INSERT INTO udu_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Aha/ mina ya e gu’b pini mmoc̱i to jin ’ciṯẖu/ ’kus mmo’tha ki o’d mo. Aha/ mina c̱i /e gwo jin oka/ is mo, ");
INSERT INTO udu_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","a’di jin bahkina ’twam pem mo dhali ’twam pem oki gwo is mo me’d jin dika/ e monṯo’c bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Aha/ mina c̱i /e to jin c̱inu mmo’ciṯẖ ’kus jin ta guŋkulus ḵa’bal mo, nyaḵka ku’d ma rasiŋ ḵa’bal mo kun ’ciṯẖu/ ’kus mmo’tha ki o’d mo. Aha/ mina c̱i to jin ’ciṯẖu/ ’kus kun ta gwaṯẖim bip̱ dhali mi mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Iiyu/ mo dhali ciḵ gwo mo, aris umi ’baar mo kun ḵo/kina Arumgimis mo, dhali aha/ mina ṯor a’di jin miikunu gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Aha/ ’therkina cuuwa/ kagahara gom a’di mo, dhali a’di karkunu ki ca ki ’twa/ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Waḵki/ aha/ mina ’taki thip̱ tonthus eya dum pem mo tani Tap̱a a’di midi ’taki diki ciḵ aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Hili ka jiŋ gana/ Arumgimis a’di iciḵki’da ciḵ mo. A’di c̱iki’da hirdhe/ ki ’twa/ pem jin ’thoka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Mom’bor mii goma Arumgimis mo, haali/ a’di diki waḵ mon’thom pem mo, walla joc̱ mo/en piti jin ṯelu sho’k ’peni aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Dhalka Arumgimis mii mii ma ’the gom am mo dhali ’bor am mii mo dhali kar bwam/em piti mmokush mo ap̱o/ aman mo, Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","ki bway pini minu mish mo ap̱o/ mony’cesh mo, dhali mom’bi’th pini jin tana /e ata is ki me’d mo e bwaman kal gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Dhalki ’kwani maŋ /e mo, ayy Arumgimis. Dhalka ris ’kwani ’baar mo maŋ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Dhalki kal gi ’kwaniny’cesh yuḵ gway ki mom’bor bwa mo dhali ki moŋ’kuny bwa mo, haali/ /e dwallki ’kwani gwo ki dar gi mii ma gwar ’de/ mo, dhali shu kal gi ’kwaniny’cesh bway ap̱o/ mony’cesh mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Dhalki ’kwani maŋ /e mo, ayy Arumgimis. Dhalka ris ’kwani ’baar mo maŋ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Mony’cesh gwono’dki maman piti jin markina a’di is mo. Arumgimis jin ta’da Arumgimis bam mo, a’di ’borki am mii mo. ");
INSERT INTO udu_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Arumgimis ’borki am mii mo. Dhalka ris ’kwani kun ’kon e ’pemen gi mony’cesh mo ḵo/ a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Dhalka Arumgimis cu mis mo dhali dhalki uni kun ta ’kup̱ ki a’di c̱ekerkunu bwa mo. Dhalki uni gwansan kun shi/ a’di i e mo tani son mo ’peni bwambori a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Dhalki uni wana e ka ku’d kun borkunu mo, wakan borki uni mo. Dhali me’d mamana dham jin ṯo’dki’d ibwambori o’d mo tani dhalki a’di jin ta thus ’ce’du/ sho’k mo si’da/ e bwambor ma Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Hili dhalki a’di jin ta’da ḵar/e ’kunya bwa mo. Dhalki uni yuḵ gway ki moŋ’kuny bwa mo ibwambor ma Arumgimis mo. Dhalki uni tashu ki moŋ’kuny bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Yuḵi gway eya Arumgimis mo. Yuḵi gway jin maŋu gway piti mo. ’Deki gway isi mis ap̱o/ a’di jin merki’da p̱owa raḵ mo. Gway piti ta Tap̱a mo. Yuḵi gway ki moŋ’kuny bwa mo ibwambori a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Ababa gi uni kun daran ki icom mo, dhali amanhil up̱ gun wuna ikaṯẖ mo tani, a’di ta’da Arumgimis jin di’d e mom piti jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Arumgimis ki c̱i uni kun dar gi gu’b mo mo mmo’ko icine/ mo. A’di ki sus ’kwani gun dhunu eya sijin e mo jin rusa/ rus mo, hili uni gun pish is ka le’d mo tani uni ’kokin e mo jin ta’da burṯa/ o’d ka burṯa/ o’d mo. ");
INSERT INTO udu_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Ayy Arumgimis, me’d jin yana /e ka pije/ nyaḵki ’kwanim pini mo tani dhali me’d jin yana /eya ye’th ye’th nyaḵki ’kwanim pini mo e mombwaasho mo tani, Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","mony’cesh yiḵinki is mo dhali momis wolki’da shoka ’cesh ’peni icine/ mo, e buŋ’kus ma Arumgimis mo. Wosh Sinaa/ c̱aan mo tani a’di yiḵinki is mo e buŋ’kus ma Arumgimis mo, a’di jin ta’da Arumgimis ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Ayy Arumgimis, /e dhalkina sho’k mmohe’th kagahara mo, /e jin wari mal pini is ka nyaŋ’ko’d mo me’d jin wuyina is a’di e mo. ");
INSERT INTO udu_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Ama’diny ḵa’bal pini uni gamki mo jin ’konu icine/ mo. E mo mii miiŋ ganam pini mo tani, ayy Arumgimis, /e ki thoson mii gom ’kwani kun dar gi to mo. ");
INSERT INTO udu_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Tap̱a ḵanki gwo mo. Uni gwansan tana ris kagahara kun ḵalki gwom ’borga/ yan mo. ");
INSERT INTO udu_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Imaliḵ gi ’kwani ma mee mo tani uni son mo, hili uni sokin mo. Up̱ kun ’koni pa mo tani uni ḵwa/ki to jin dilu bwa mo, ");
INSERT INTO udu_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","ba uni nyaḵ ’ko ki ḵa’bal e bwam ma goŋ mo, dhala biŋ gurko/ uni ’koshkunu is ki ’dolkon kush mo dhali jeshem piti c̱a’b ki go’d go’d me’d ’dolkona go’d go’d mo. ");
INSERT INTO udu_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Ki a’di jin ta gi Mom’bi’th ma Dem Dem c̱ekerki imaliḵ bwa mo tani awasa/ p̱u’dki’d ap̱o/ Wosha Salmuun mo. ");
INSERT INTO udu_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Ayy, wosh jin turatur jin c̱a’bki dem dem mo, jin ta wosha turga/ gi Pam Bashan mo. Ayy wosha turga/ jin ’kana ’kup̱ ki bidhi/ bidhi/ ka ris mo, jin ta wosha turga/ gi Pam Bashan mo. ");
INSERT INTO udu_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Ata hila /e mo ki en dhap̱an kan mo, ayy, wosha turga/ jin ’kana ’kup̱ ki bidhi/ bidhi/ ka ris mo, e ’kuwosh jin on ma Arumgimis bwa mo mmota mom piti mmoc̱a’bi cine/ mo? Nye, mo jin mina Tap̱a c̱a’b ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Ki mom’bi’th ma ris shumarum kun tana dem dem mo kun ta iss ’kwanimpa ka iss ’de/ ka alip̱ mo, dhala alaap̱a p̱owa alaap̱ mo, Tap̱a pu’dki’d ’peni ’kuwosha Sinaa/ e mo jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","/E ki poḵ wosh jin turatur mo, dhali /e ki shu uni bway uni gun bu’thkunu mo e bway pini jin yana /e mo, dhali bu’th to kun c̱inu ki me’d e bwaŋ ’kwani mo, isi kan e bwaŋ ’kwani kun pishi is ka le’d mo, wakan ki Tap̱a Arumgimis midi di e mo yan mo be. ");
INSERT INTO udu_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Mom’bor mii midi di gom Tap̱a mo, a’di jin ’de’kki ana abor ki mis isa yempa/ mo. Arumgimis a’di ta bway gi mowoṯẖ bana mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Arumgimis bana a’di ta’da Arumgimis gi bway gi mowoṯẖ mo. Dhali eya Arumgimis mo tani, a’di ta Tap̱a jin cila mo jin yenu ’peni mowu mo. ");
INSERT INTO udu_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Hili Arumgimis midi pwaṯẖ ’kup̱ gi uni kun ta ’kup̱ ki a’di mo, dhali ayinyjwa gi ’kup̱ gi a’di jin ya’d e bway piti jin dina mii a’di i’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Tap̱a o gwo mo ki: Aha/ mina doḵ uni ka nyaŋ’ko’d ’peni Pam Bashan mo, dhali aha/ mina doḵ uni ka nyaŋ’ko’d ’peni ḵumma/ yi’de/ jin ’kula’kul mo ");
INSERT INTO udu_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","ki um mini lam sho’k bum ka bas mo, dhali ka le’d ma ’kam bum mo tani uni mini ta gi tonṯe/ ’peni ’kwani gi ’kup̱ bum mo. ");
INSERT INTO udu_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Yam pini kun ḵogu kun yana /e mo tani mishu mo, ayy Arumgimis, a’di jin ta ya ma Arumgimis pem mo, a’di jin ta’da Maliḵ pem mo, e mo jin ḵogu mo, ");
INSERT INTO udu_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","imanyuḵ gway kun iina bori a’di mo, dhali uni kun buḵina dheŋdhenye/ iini ’ko’d mo dhali bwaman uni mo tani nyara/ p̱ina dheŋdhenyem buni ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","’Bori Arumgimis mii e dhana tul ’kup̱ gi ’kwani mo, Tap̱a, ayy um ’kwani kun ta uc̱i ma Israyiil kun kasha e mo. ");
INSERT INTO udu_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","’Pena waḵ ma Benyamiin, a’di jin p̱iski’d e bwaman uni, jin shu’da shu/um bway mo, e bwaman gi iya/ gi ’Kwani Yahuuda/ eya waambuhany buni mo, dhali e iya/ gi ’Kwani gi Pan Sabulun mo, dhali e iya/ gi ’Kwani gi Pa Nap̱taali mo. ");
INSERT INTO udu_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Tilu mom’bi’th ma dem dem pini is mo, ayy Arumgimis. Ṯori mom’bi’th pini mo, ayy Arumgimis, /e jin wagaski a’di gom am mo. ");
INSERT INTO udu_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Gom gu’b gi mondheleladhelel pini jin di’d e Pa Urushaliim mo tani imaliḵ ḵalki to kun c̱inu ki me’d mmoc̱i /e mo. ");
INSERT INTO udu_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Ḵucuri to/e gwansan kun ’kon e bwaman ma pil mo, dhali e bwaman ma ma’diny gwaṯẖim bip̱ nyaḵki ushi bip̱ gi ’kwani mo. Yap̱ uni ki sho’k uni gwansan kun ’dap̱kina e goma thulp̱a/ mo, dhali c̱ekerki ’kwani bwa mo uni gun ’kunyi bwa e mo ma mee mo. ");
INSERT INTO udu_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Dhalka koroḵ ḵalu ’peni Pam Masir mo. Dhalki ’Kwaniŋ Gale/ soyin ki jahanne/ mo dhali he’th me’d buni goma Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Yuḵi gway eya Arumgimis mo, ayy aris ’peŋkuman bampa/ gi mony’cesh mo. Yuḵi gway mmomaŋ Tap̱a mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","E a’di jin merki’d eya p̱owa ris momis mo, a’di jin ta gi momisa dhamo/ mo. Hili mo mo ma, a’di hashki ’twam piti ’peni mun mo, ’twam piti jin c̱a’bki dem dem mo. ");
INSERT INTO udu_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","C̱ika Arumgimis mom’bi’th mo, mom’bi’th piti jin miikina a’di miin tap̱a ap̱o/ ’kwani ma Israyiil mo, dhali mom’bi’th piti a’di diki’d e bwaman momis mo. ");
INSERT INTO udu_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Arumgimis a’di ḵa/aḵa/ e mom piti jin ḵogu mo, a’di jin ta’da Arumgimis gi ’Kwani ma Israyiil mo, a’di ki c̱i mom’bi’th mo dhali ’bi’th ’kwanim piti is mo. Mom’bor mii midi di goma Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Tayi aha/ is is ki me’d mo ma, ayy Arumgimis. Haali/ yi’de/ loski aha/ ki ’ba/ ilu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Aha/ cic̱kina ka ’cesh e bwam boro’th jin ’kula’kul mo, e mo jin dar gi mo jin miga/ jeṯṯ shoki cine/ mo. Aha/ p̱u’dkina e yi’de/ jin ’kula’kul mo, dhali agannu/ yi’de/ a’di kac̱ki’da p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Aha/ wukina is e gom kom pem mo, dhali ’kus pem dhere’di ’baar mo. Dhali em pem ’ceṯẖki’da ’tum kagahara mo mmowu e ’kup̱ mmoc̱ora Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Mmobola mur ’kup̱ pem e mo tani uni ta uni gwansan kun shi/ki aha/ e mo ki dar gi miiŋ kamu/ mo. Uni gwansan c̱a’bki dem dem mo kun mini ’ce’d aha/ sho’k moyi, uni gwansan kun mini bu’th aha/ ki gwo ma ṯor mo. A’di jin dika/ ki ḵwal naskina/ mo tani aha/ mina mii doḵ a’di ka nyaŋ’ko’d mowa? ");
INSERT INTO udu_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Ayy Arumgimis, /e mishki mii ma p̱alim pem mo. Mii gun ṯẖu’thka/ mii mo tani ’konuki bag ’peni /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Dhalku/ ki dhal uni gwansan bway kun tan gi mo ma ’teŋ kap̱e/ e /e mo dhunu ki mo ma ’the is gom aha/ mo, ayy Tap̱a Arumgimis gi momis mo. Dhalku/ ki dhal uni gwansan bway kun simmki /e e mo jin minu ’doyu/ uni e mo jin minu this uni taḵ gom aha/ mo, ayy Arumgimis ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Haali/ a’di gom gway pini mo tani aha/ ḵalkina mo jin waḵuwa waḵ mo, dhali mon’the is a’di kumki aha/ bwam/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Aha/ wara ki wathi/ gi bampaŋ kamu/ e bwaman ’kwani ma waḵ pem mo, mmota a’di gi paŋ kamu/ e bwaman iya/ ma ta’da mo. ");
INSERT INTO udu_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Haala nyor gom gu’b pini a’di shwakaa/ mo, dhali asor gi uni gwansan kun sorki /e mo tani ṯa’kkina p̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ki aha/ karkina is pem ki gwa’d mo eya ḵashiram pem ki moŋga/ to mo tani a’di warki’d ki mowaḵ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ki aha/ hi’thkina burrinye/ ma shawaal e is mmota burrinye/ gom is pem mo tani, aha/ warkina ki a’di jin miikina uni ka maḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Aha/ tana a’di jin ṯora uni gwansana ṯor kun ’kon e ’twaŋkala goŋ mo dhali uni kun ’koshkin ma su mo tani yuḵki gway gom aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Hili gom aha/ mo a’thom pem jin ’thoka/ mo tani e /e mo be, ayy Tap̱a. Eya tente/ jin mishuwa bu’th bu’th mo, ayy Arumgimis, dhali e mo/ish jin isha mo/en pini jin ṯelu sho’k mo tani /e ’thoḵki aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ki mowoṯẖ pini jin ta isiŋ gana/ mo tani ’cwami aha/ mo ’peni boro’th jin loski aha/ mo. Dhalki aha/ ’cuḵu mo ’peni ’kwani kun ta ’kup̱ ki aha/ mo dhali ’peni yi’de/ kun ’kula’kul kun shwana nyor mo. ");
INSERT INTO udu_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Dhalku/ ki dhala gannu/ yi’de/ bway mo mmodhi’th aha/ sho’k mo, walla moŋ’kul piti mmolos aha/ mo, walla jisa ’kulga/ mmomu’th ’twa/ ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","’Thoḵi aha/ ’twa/ mo ma ayy Tap̱a, haali/ mo/en pini jin ṯelu sho’k mo a’di ’bora’bor mo be. Isi ki gwo gi momiimiim pini jin ishki’d ka enthus mo tani ṯu’kki/ aha/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Dhalku/ ki bag jis/em pini ’peni c̱iŋkinam pini mo. Haali/ aha/ dina e mo ma c̱is mo tani huru/ ki jahanne/ mo mmo’thoḵ aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","’Dishi aha/ is mo dhali wani aha/ ’ba/ mo, dhali kari aha/ ki ’kus ’peni ’kwani kun ta ’kup̱ ki aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","/E mishi mowaḵ pem jin waḵu aha/ mo, dhali mo ma ’the is pem mo dhali mo jin ’konuki taḵ aha/ mo. Aris uni gun ta ’kup̱ ki aha/ misha /e mo. ");
INSERT INTO udu_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Asor ’ce’dkina dum pem bwa mo, wakan a’di itaka/ buṯkan ki buṯkan mo. Aha/ ŋap̱a mo jin minu ’taki hil aha/ ki mo ma ’thime/ ki mo/en mo tani hili aha/ gama wathiŋ kamu/ yisa. Dhali aha/ ŋap̱a ’kwani mmo’taki malas aha/ mo tani, hili aha/ dinaki gam jaŋ kamu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Uni c̱iki aha/ aṯi’d tonthus e tonṯe/ mo, dhali gom yi’de/ jin bu’thki aha/ mo tani uni c̱iki aha/ yiman tom’pac̱a’d mmop̱i mo be. ");
INSERT INTO udu_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Dhalki tonṯem buni jin shwana uni atharabeesa mo warki’d ka gume/ ibwambori uni mo. Dhalki tom buni kun ’ciṯẖu/ ’kus mmomiiya bas goma yuḵ jin yuḵu ka tul ’kup̱ mo warki’d ka gume/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Dhalki em buni a’di dhurumkunu mo mo, wakan ki uni mini ’koki p̱ar mo e mo dhali dhu ki uni empa’d buni mmodee ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Woli anyor pini jin deḵkina /e ap̱o/ uni mo, dhali dhalka nyor buni jin pura /e ki o’d kumki uni ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Dhalki gu’ba’kum buni taki bwam ma’du/ mo. Dhalku/ ki dhal jan ṯal ’deŋ kamu/ bway mo mmoc̱a’b e gu’b burrinyem buni mo. ");
INSERT INTO udu_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Haali/ uni ṯo’cki a’di bwa mo a’di jin dorkina /e mo, dhali a’di jin taḵkina /e jama/ mo tani uni ’kon naskina/ mmoṯo’c a’di bwa ki nyanye/ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Dhuki uni ajisa i is mo. Dhalku/ ki dhu uni mmodhu ka p̱o/ ’peni /e mo. ");
INSERT INTO udu_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Dhalki uni ’koshu gway buni ’pena warka/ gi mondiki/e mo, dhali uni minu ’koki ’kwar gway buni e bwamana warka/ nyaḵki ’kwani kun tana ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Hili aha/ wo’ckunuwa du she/ mo dhali ’kaa du she/ mo, Dhalki bwaya ḵar/em pini, ayy Tap̱a Arumgimis, kar aha/ e mo jin ḵa’dama/ ḵa’dam mo. ");
INSERT INTO udu_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Aha/ mina maŋ gway ma Arumgimis ki gway jin yuḵu mo. Aha/ mina eḵ a’di ki bwa jin ’boruwa ’bor i is mo. ");
INSERT INTO udu_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Mii yansan a’di imidi ’bor Tap̱a bwa kagahara mmobola morbip̱ e mo, walla rasim bip̱ jin ’kana je mo dhala cuḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Dhalki uni gwansan kun siriju/ ki sho’k p̱ar mii e mo dhali ’kuny bwa mo. Dhali um gwansan gun simmkina Arumgimis e mo tani dhalka dum bum tashu e mo doḵ/e. ");
INSERT INTO udu_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Haali/ Tap̱a a’di ciḵki gwo mo ’peni uni gun mini mii ta gi to mo, dhali a’di diki waḵ uni gun ta unim piti kun deḵkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Dhalki momis dhali mony’cesh maŋ a’di mo, dhali dhan ḵumma/ yi’de/ dhali aris to ’baar mo kun ḵalki ya e bwaman a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Haali/ Arumgimis midi ta Sihyuun is is ki me’d mo dhali nyaŋ ka Yahuuda/ ’peŋkuman bampam piti doḵ/e mo. Dhali uni gun ta c̱iŋkinam piti mo tani mini ’ko e mo yan mo dhali bu’th a’di mo ");
INSERT INTO udu_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","dhali uc̱i gi c̱iŋkinam piti mo tani midi ta mal piti mo, dhali uni gwansan gun eni gway piti mo tani mini ’ko e bwaman a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Tayi ki bwam ’boro’d ma, ayy Arumgimis mmo’cuḵ aha/ mo. Ayy Tap̱a, huru/ ki jahanne/ mmowoṯẖ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Dhalki uni dhunu ki mon’the is mo dhali duŋkurki ’kup̱ is mo uni gwansan kun ŋap̱ mondiki/em pem mo. Dhalki uni doḵkunu to ka nyaŋ’ko’da bor mo dhali dhalki uni ’doyunu mo e mo jin ushu uni taḵ mo uni gwansan kun ona bwa ki aha/ minu shi/ mo. ");
INSERT INTO udu_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Dhalki uni ḵo/ is ki ḵo/ jin shiyi’d mo gom mo ma ’the is buni mo uni gun o gwo mo ki: ’Thor ki ’thor. ");
INSERT INTO udu_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Dhalki aris uni ’baar kun simmi /e e mo tani ’bora bwa mo dhali ’kuny bwa mo e /e mo. Dhalki uni gwansan kun en bway gi mowoṯẖ pini mo o gwo mo kagahara mo ki: Arumgimis a’di caaca mo. ");
INSERT INTO udu_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Hili aha/ hatha’ko’d mo dhali aha/ mina mii ta gi to mo. Huru/ ki jahanne/ gom aha/ mo, ayy Arumgimis. /E tana manwoṯẖ pem mo dhali aman’cuḵ pem mo. Ayy Tap̱a, dhalku/ ki tayaa diiṯe/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","E /e mo tani, ayy Tap̱a, aha/ bu’thkina mom pem jin hurga/ jwa e /e mo. Dhalku/ ki dhal aha/ bway ki aha/ minu kar ki mo ma ’the is mo. ");
INSERT INTO udu_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","E momii ma ḵar/em pini mo tani ’cuḵi aha/ mo dhali ’cwami aha/ mo. Ḵa’di ’cem pini gom aha/ mo dhali tayi aha/ is is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Wari /e ki wosh jin miga/ hur jwa icine/ mo, mmota acur jin ṯenu gwo mo mmota aha/ is is ki me’d mo, haali/ /e ta wosh pem mo dhali acur pem jin ṯenu gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","’Cwami aha/ mo, ayy Arumgimis pem, ’peni me’d gi a’di jin ta thus ki thus mo, dhali ’peni a’di jin bu’thki’da bu’th ki ḵwap̱ mo, a’di jin diki ta ḵar/e mo dhali wathi/ jin ta maṯṯ ki maṯṯ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Haali/ /e, ayy Tap̱a, /e tana ’teŋ kap̱em pem mo, dhali ’pena cim pem jin gamka/ /e gwo is mo, ayy Tap̱a, ’peni dhuru’c pem jin taka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ap̱o/ /e mo tani aha/ dikina ka linthiṯẖ ’peni mondho’th pem mo. /E ta a’di be jin bu’thki aha/ ’peni bwa ma dho’th ma ta’dam pem mo. Momaŋ pem ṯikirki di gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Aha/ mera ’kwani ka ris ka yempa/ mo. Hili /e ta jim pem jin ’bitha’bi’th jin hurga/ jwa icine/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","’Twa/ pem a’di ’tu’du/ mo ki piny piny ki momaŋ /e mo dhali ki monycam pini i’baara tee mo. ");
INSERT INTO udu_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Dhalku/ ki biṯ aha/ asho ka tee jin miga/ ta adhan mo. Dhalku/ ki dhal aha/ ’pen mo waḵki/ aha/ mina mom’bi’th pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Haali/ ’kwani tana ris kun ta ’kup̱ ki aha/ mo kun oki isi gwo gom aha/ mo, uni gwansan kun c̱orki mondiki/em pem mo tani uni logomki gwo mo mmonṯal ’de/ gom aha/ mo ");
INSERT INTO udu_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","dhali o gwo mo ki: Arumgimis, mola /e, dhalki a’di ’pen mowa? Uri a’di isho’k mo dhali bu’th a’di mo haali/ jaŋ kamu/ di’da jin midi ’cuḵ a’di mo? ");
INSERT INTO udu_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Ayy Arumgimis, dhalku/ ki si’d ’peni aha/ kagahara mo. Ayy Arumgimis pem, huru/ ki jahanne/ dhali woṯẖ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Dhalki unim pem gwahan kun yeri aha/ is ki gway dhunu ki mo ma ’the is mo dhali shwa ki o’d ki ’ci’d’da/ mo. Dhalki uni tashu ki mo jin waḵuwa waḵ mo dhali mo jin thisuwa taḵ taḵ mo, uni gwansan kun simmki mo e jin midi shi/ aha/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Hili aha/ mina ta gi mo ma ’teŋ kap̱e/ ki sule/ sule/ mo, dhali aha/ mina maŋ /e naskina/ ki sule/ dhali ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","’Twam pem midi ṯor gwo gom mo ma ḵar/em pini jin ḵalkina /e mo dhali miim pini jin miina /e gom bway gi mowoṯẖ goma tee ’baar mo, haali/ mondeŋ buni a’di peki monyiṯẖ pem jin nyiṯẖka/ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Ki dhan mii ma dem dem gi Tap̱a Arumgimis mo tani aha/ mina p̱u’dku/ mo, aha/ mina maŋ mii ma ḵar/em pini mo, a’di jin ta jim pini /e ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Ayy Arumgimis, ’peni dhuru’c pem jin taka/ mo tani /e ṯorki aha/ gwo mo, dhali aha/ mina bah dhan momer pini jin miina /e to mo. ");
INSERT INTO udu_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Wakan, isi kani, e mo jin canu ki yil mo dhali mo jin ’kan ma wuu ’kwani mo ayy Arumgimis, dhalku/ ki dhal aha/ ’pen mo, ntagi aha/ mina bah mo ma dem dem pini mo eya risa nyaḵum yil gi ’kwani kun mini p̱u’du/ mo. ");
INSERT INTO udu_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Mom’bi’th pini dhali mo ma ḵar/em pini mo tani, ayy Arumgimis, uni jidhirkin e momis jin ḵa’dama/ ḵa’dam mo. /E jin miikina dhan to kun caaca mo, ayy Arumgimis, kaja a’di iwaki /e mo? ");
INSERT INTO udu_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","/E jin karki aha/ mo mmop̱ara ris monṯo’c bwa e kun surkun mo tani /e mini tash aha/ e mo doḵ/e. ’Peni moŋ’kul gi mony’cesh mo tani /e mini ’de’k aha/ abor gi mis doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","/E mini mar aha/ montaḵ pem is is mo dhali malas aha/ doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Dhali aha/ si’da/ mina maŋ /e ka dheŋdhenyem pem jin buḵka/ mo gom mo ma isiŋ ganam pini jin tana /e mo tani, ayy Arumgimis pem, aha/ mina yuḵ gway mmomaŋ /e ka dheŋdhenye/ jin ’kon ma shu/i pesu/ mo, ayy /En ’De/ jin ta jima Israyiil jin Ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","’Twa/ pem midi ’ther cuuwa/ gom bwaŋ ’kunyka/ mo, ma me’d jin miga/ yuḵ gway mmomaŋ /e mo, nyaḵka ḵashiram pem si’da/ ilu/ mo a’di jin ’cwamkina /e mo. ");
INSERT INTO udu_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Dhali ale’d pem midi ṯor gwo gom mii ma ḵar/em pini jin woṯẖkina /eya woṯẖ ka tee ’baar mo haali/ uni dhukunu ki mo ma ’the is mo dhali mo jin thisuwa taḵ taḵ e mo, uni gwansan kun ŋap̱ki bway ki bur bur mo mmo’taki shi/ aha/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","C̱iya maliḵ mo ma ḵar/em pini mo, Ayy Arumgimis, dhali mo ma ḵar/em pini gom ya/ ma maliḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Dhalki a’di dwall ’kwanim pini gwo ki mii ma ḵar/e mo dhali unim pini kun hatha’ko’d ki mo ma ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Dhalki dhan wosha turga/ ḵali mo jin rusu ki rus gom ’kwani mo, dhali aris wosh si’da/ ḵali mo ma ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Dhalki a’di ’ce’d gwo she/ gom to jin raḵi ’kwani kun hatha’ko’d mo. C̱iyi mo jin ’cuḵuwa ’cuḵ gom ’kwani kun mini mii ta gi to mo, dhali yap̱i uni gwansan kun siri’ckina siri’c ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Dhalki a’di di’d ki e mo ka tente/ di’di motim ’kup̱ naskina/ mo, dhali me’d jin din ma ppe naskina/ gara/ mo, eya risa nyaḵum yil gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Dhalki a’di wana e ka sho’k jin wolki yi’dem piti asho jin ’punyu/ mo, me’da sho’k jin mii yi’de/ ki puya/ puya/ ap̱owa ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Eya teem piti jin dina a’di ki e mo tani dhalki mo ma ḵar/e ’twaḵa’d mo, dhali moŋḵu’th is mmo/ish mo ntaga ppe midi diki di doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Dhalki a’di ta gi mom’bi’th ’peni ḵumma/ yi’de/ mo ntagi ḵumma/ yi’den tiya mo, dhali ’peni yi’de/ kun sokin mo ita gi ’pemen gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Dhalki uni gun ta ’kup̱ ki a’di luŋkini bwambori a’di mo, dhali ’kwani kun ta ’kup̱ ki a’di mini ’biṯṯ bu’da’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Dhalki imaliḵ gi Pan Tarshiish dhali kum pa uḵa ’cesh mo c̱i a’diya thulp̱a/ mo, dhali imaliḵ gi Pan Shaba mo dhali Pan Saba mo ḵal to kun c̱inu ki me’d gom a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Dhalki aris imaliḵi ’baar mo ṯagkina ’cesh ki jiŋ ’kup̱a’dup̱uni bwambori a’di mo, dhali dhalka ris kal gi ’kwaniny’cesh si’da/ mii a’di to mo. ");
INSERT INTO udu_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Haali/ a’di ’cuḵki uni gun mini mii ta gi to mo, ki a’di yuḵki’da yuḵ mo, a’di jin hatha’ko’d mo dhali a’di jin dar gi wathi/ mmowoṯẖ a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","A’di ki hila hil ki e ma ’thime/ ki mo/en ap̱o/ uni gun ’ka’da is mo dhali ap̱o/ uni gun mini mii ta gi to mo, dhali ta moŋ’koki/em buni is ki me’d mo gom uni gun mini mii ta gi to mo. ");
INSERT INTO udu_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","’Peni mo jin sirijuwa siri’c ki sho’k mo dhali abujur jin bujuru mo tani a’di wanki moŋ’koki/em buni ’ba/ mo, dhala bas buni ta yinthoŋ gana/ e jis/em piti mo. ");
INSERT INTO udu_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Dhalki a’di di’d ki e ki sule/ sule/ mo. Dhalki ’dolkon gana/ jin ta gi Pan Shaba c̱inu a’di mo. Dhalki mon’tho minu ṯikir ’tho gom a’di ki ṯikir ṯikir mo dhali mom’bor mii minu ’tho gom a’di ka tee ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Dhalki emen tonṯe/ ishin ka enthus e bampa/ mo, ap̱owa ris ’kuwosha turga/ mo me’d jin yiḵinkina ’tham uni is mo. Dhalki maman cwam piti wana e ki ji gi Pan Lubnaan mo dhali dhalki ’kwani ’tu’dina ’tu’d mo ’peni aris ’peŋkuman bampa/ mo me’da sho gi bwam bunto mo. ");
INSERT INTO udu_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Dhalki gway piti ’dim ’kup̱ ki sule/ sule/ mo. Dhalki yir piti di’d ki sule/ sule/ me’da tente/ mo. Dhalki ’kwani ’bori is buni mii ki a’di mo, dhali aris kal gi ’kwaniny’cesh yuḵi a’di mo ki a’di jin ’boru mii mo. ");
INSERT INTO udu_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Mom’bor mii midi di gom Tap̱a mo a’di jin ta’da Arumgimis gom ’Kwani ma Israyiil mo, A’din ’deŋ gana/ imii’da dhan to gi momer mo. ");
INSERT INTO udu_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Mom’bor mii midi di gom gway gi monycam piti ki sule/ sule/ mo. Dhalki monycam piti ’tu’d mony’ceshi ’baar mo. Amen dhali Amen. ");
INSERT INTO udu_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Mon’tho ma Dawuu’d mo a’di jin ta ya/ ma Yassa mo a’di ’baarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Ka jiŋ gana/ Arumgimis ta a’di jin ’boro’d gom uni kun dhelel ma du mo, gom uni gwansan kun dhelelkin eya du mo. ");
INSERT INTO udu_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Bahili gom aha/ mo tani sho’k pem ’dishi ’twa/ ’taki dheres mo, ŋaṯgin pem ’disha’dish ’taki yeres mo. ");
INSERT INTO udu_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Haali/ aha/ tana dhap̱an gom uni kun dhu is ki ca mo, ki aha/ p̱arkina mo jin rusa to ki rus gom uni kun ta thus ki thus e mo. ");
INSERT INTO udu_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Haali/ uni dar gi mo jin su’k uniya du ka war mo. Buŋgwar is buni c̱a’b ki c̱ur c̱ur mo dhali c̱a’b ki ’thiḵil ’thiḵil mo. ");
INSERT INTO udu_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Uni ṯocu ’kus me’d ’kwanin tiyaa? Dhali uni doru ki to jin woci is she/ me’d ’kwanin tiyaa? ");
INSERT INTO udu_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Wakan uni dhu is ki ca gom neram buni kun hitha uni i’ba/ mo, dhali mo ma bujur jin bujurkina uni mo tani a’di ’kamki uni is mo me’d burrinye/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Em buni dhethadhe’th gom momoṯ buni mo, adum buni a’di kumkunu ’twa/a ’cesh ki mii ma p̱ali mo. ");
INSERT INTO udu_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Uni ’theḵ shushi mis mo dhali o gwo ki mo jin dup̱uwa dup̱ i e mo. Mmodhuna uni is buni eya tente/ ki ṯẖorony mo tani uni ki ruma rum gom mo jin miinu sirica siri’c ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Uni ki ḵa’d ’twam buni mmosor momis mo dhala le’d buni a’di ḵalki ’pen ḵany e mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Dhali gom gwo gi wakan mo tani ’kwani ṯu’kkin mo dhali maŋ uni mo dhali gam to shiyi’da kamu/ e uni yisa. ");
INSERT INTO udu_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Dhali uni o gwo mo ki: Ki tonta si’da/ imish ma Arumgimis mo? A/a’di jin Caa e ki Ca nyiṯẖki toŋ kamuwa? ");
INSERT INTO udu_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Hili mo mo ma, uni gwansan ita thus ki thus mo. Isa yempa/ uni ’koni mo jin ’ka’da mii ’ba/ ki ’ka’d mo dhali uni mara to kun tana uni pa ki pa is mo. ");
INSERT INTO udu_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Dhali aha/ ki p̱e’th mo tani aha/ karkina dum pem ki dhelel dhelel mo dhali lam me’d pem e mo jin ’konu ka p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Haali/ ka tee ’baar mo tani aha/ dherkunu is bwa mo, dhali dorkunu isa yempa/ mon’thamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Waḵki/ aha/ mina ’taki o gwo mo ki: Aha/ mina o gwo wakan mo tani aha/ mina ’taki diki ta a’diŋ gana/ goma nyaḵum yil gi uc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Hili ki aha/ kulumkina gwo ibwa mmomish gwo yansan ’ban mo tani a’di midi ’taki wayaa/ e ki to jin midi wu is e mmomii mo, ");
INSERT INTO udu_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","ntagi aha/ yakina e mo ma Arumgimis jin ḵogu mo, dhali yan’ko’d aha/ ki nyiṯẖ ’pemen gi ’ko’d ’buni mo. ");
INSERT INTO udu_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Ka jiŋ gana/ /e ki dhu uni e mo jin yeresa/ yeres mo. /E ki dhal uni bway mo mmoṯa’k e mo jin kup̱u/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Uni ’ce’dki sho’k kadhamowa? Uni dhidhu sho’k ka pupush ka dhan mii jin ta’da pure/ ka pure/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Uni wana e ki jan jin shu’bu/ mo me’d jin merkina jan ’deŋ kamu/ e mo. ’Peni momer e mo tani um ki waḵ to munn buni mo. ");
INSERT INTO udu_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Ka ḵashiram pem ḵa/ki’d ki ḵa/ mo tani dhali ki aha/ su’kkunu eya du mo, ");
INSERT INTO udu_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","aha/ takina dholgon mo dhali ta p̱us mo tani aha/ wana e ki tombwaasho ’kup̱ ki /e mo. ");
INSERT INTO udu_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Bahili aha/ dina mmoṯikir c̱a’b nyaḵki /e mo. /E bu’thki me’da bim poros pem mo. ");
INSERT INTO udu_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","/E ki shu aha/ bway ki gwom pini jin logomkina /e mo dhali yan’ko’d /e mini bu’th aha/ mmotaḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Kaja a’di itaka/ e momis mo? Hili diki ta jasi /eya? Dhali to p̱iyi’d e mony’cesh yan mo mmo/oka/ bwa mo mmodhal /e ka p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Buŋgwar is pem dhala dum pem mini ’taki ush me’d mo tani hili Arumgimis a’di ta’da Man’bitha dum pem is mo dhali Amanpwaḵ ki aha/ to jin miga/ ta ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Haali/ hili mo mo ma, uni gwansan kun si’dkin ’peni /e mo tani minu ’ce’d sho’k mo be. /E ki kar mo jin daḵu gwo ’kup̱ mo gom uni gwansan kun ṯori gwon thus ap̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Hili gom aha/ mo tani a’di ’boro’d jin miga/ ’disha Arumgimis is mo. Aha/ karkina Tap̱a Arumgimis mo mmota a’di jin hurga/ jwa icine/ mo, ki aha/ mina ṯora ris miim pini mo. ");
INSERT INTO udu_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Ayy Arumgimis, ki to jin ta’da ta iṯa’kkina /e amana sho ki sule/ sule/ kan mo? Ki to jin ta’da ta idhala /eya nyor pini i ya ku’d ap̱o/ ḵa’bal pini kun tana shon dhii/i’d mo? ");
INSERT INTO udu_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Kayi dhana tul ’kup̱ ’kwanim pini e mo, uni gun takina /e ’peni kadhamo/ mo, uni kun wankina /e ’ba/ mo mmota waḵ gom mal pini mo. Kayi ’Kuwosh ma Sihyuun e mo e mo yan jin c̱a’bkina /e mo. ");
INSERT INTO udu_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","C̱uthi /e ŋaṯgin pini e mo jin ’tuḵkunu ki sule/ sule/ mo. Uni gun ta ’kup̱ ki ’kup̱ mo tani ’ce’dkina ris to sho’k mo e mo jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Uni gun ta ’kup̱ ki /e mo tani aŋkarkin e bwaman mom pini jin ḵogu mo. Uni thumkina bereḵ buniŋ gana/ mo mmota jamas mo. ");
INSERT INTO udu_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Dhali e ’twaŋkal gu’b isi mis mo tani uni ki jep̱ cwandher bwa ka thurmany mo. ");
INSERT INTO udu_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Dhali yan’ko’d aris cwa kun ’cimudhu bwa mo tani uni ’ce’d uni ka ’cesh ka thurmanya ba’d’ban mo dhali ki ’dorro/ mo. ");
INSERT INTO udu_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Uni ki c̱i’th mom pini jin ḵogu ki o’d mo. Uni ki shi/a ’cesh pini jin c̱a’ba /e ki gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Uni ki o gwo e is buni mo ki: Ana mina uṯẖ uni ’baar mo. Uni ki c̱itha ris mo jin tulu is goma Arumgimis e mo yan mo. ");
INSERT INTO udu_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ana ’konaki p̱ar jamas bana e mo. Dhala manc̱i gwoŋ kamu/ di’da? Dhali jaŋ kamu/ di’di bwam ana jin mishi gwo ki mii yan midi ta ata? ");
INSERT INTO udu_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Ayy Arumgimisa, /e mini dhal ’kwani kun ta ’kup̱ bway mo mmo’theḵ shushi mis ki rash rash kan ntagi mo gi wakata mo? A/’kwani kun ta ’kup̱ ki /e mini sor gway pini ki sule/ sule/ kan mo? ");
INSERT INTO udu_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Ki to jin ta’da ta si’da/ igukina /e me’d pini ka nyaŋ’ko’d mo? Ki to jin ta’da ta ikarkina /e me’d pini e bwambor pini mo? ");
INSERT INTO udu_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Hili Arumgimis jin ta’da maliḵ pem mo a’di jin diki’d ’peni kadhamo/ mo, jin miiki bway gi mowoṯẖ e bwaman gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","/E ki ḵwa/ dhan yi’de/ bwa ki mii ma dem dem pini mo. /E ki ’ce’d ’kup̱ ma dhan tasha/ ki bwam yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","/E ki pwaṯẖ ’kup̱ gi dhan to yi’de/ mo, dhali /e ki c̱i a’di mmota tonṯe/ gom uni kun uḵu kun ’kon e bwaasho mo. ");
INSERT INTO udu_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","/E ki tirki wosh mo dhali ḵa’d a’di ’twa/ mo dhali du’d yi’de/ mo dhali yi’de/ ki ’thonthor mo. /E ki ḵu’thki yi’de/ jin sokin e bwam ma gap̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Atee ta jim pini mo. Mon’thiny si’da/ ta jim pini mo. /E ṯelki moŋkush gi momis sho’k mo dhala tente/ mo. ");
INSERT INTO udu_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","/E thosonkina ris gwayu/ gi mony’cesh mo. /E karki moyurantee mo dhali mondiṯ mo. ");
INSERT INTO udu_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Kayi gwo yan e mo ma, ayy Tap̱a, ’kwani kun ta ’kup̱ ’theḵki shushi mis kata sa/ mo? dhali ’kwani kun ’koki dhu mii gun ḵogu mo tani waḵki gway pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Dhalku/ ki c̱iya ḵashira/ gi gurkom pini ki tom bwaasho mo. Dhalku/ ki ŋa mondiki/e gi a’dim pini jin hatha’ko’d ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Kari gwom pini jin gamu me’d mo. Haali/ mo gi mondhurumi’d gi mony’cesh mo tani a’di ’tu’dkunu mo ki ’kwani gwahan kun bujurkina bujur mo. ");
INSERT INTO udu_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Dhalku/ ki dhal uni gwansan bway mo kun yap̱kunu ki sho’k mo mmodhu ki mo ma ’the is mo. Dhalki uni kun hatha’ko’d dhali kun mini mii ta gi to mo maŋ gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Cuyi mis mo, ayy Arumgimis, dhali muri is mo gom mii jin midi raḵ /e mo. Kayi gwo e ki uni gwahan kun ushi gwo kun ḵogu dhu ’theḵi /e shushi is ka tee ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Dhalku/ ki ŋa cuuwa/ jin cuuna ’kwani kun ta ’kup̱ ki /e mo, abomboḵ ’peni ’kwani kun ta ’kup̱ ki /e ka ris mo, a’di jin yaki’d ka ’kulam ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Am c̱ina /e mo jin ’boru /e bwa i is mo, ayy Arumgimis, bwa jin ’boruwa ’bor bwa i is c̱ina aman /e mo. Aman yuḵkina yuḵ ap̱o/ gway pini mo dhali deŋ dhan momer pini e mo kun miikina /e mo. ");
INSERT INTO udu_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ka tee jin karka/ ’pen ka pije/ mo tani aha/ mina dwall gwo ki dar gi mii ma gwar ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Ka ’cesh midi wuŋkul mo dhali aris ’kwani kun ’kon e a’di mo tani a’di ta aha/ be jin ṯelki mom piti jin tana a’di akaḵ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Aha/ mina o uni gwansan kun dhu ’ba/ ki ca gwo mo ki: Dhalku/ ’ba/ ki dhu ki ca mo dhali aha/ mina o a’di jin ta thus ki thus gwo mo ki: Dhalku/ cem pini ki ’de’k ki mis mo. ");
INSERT INTO udu_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Dhalku/ cem pini ki ’de’k ’kup̱ ki mis jin ḵa’dama/ ḵa’dam mo walla o gwo mmo’theḵ ’ba/ imis mmo/ush ’kwani ga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Haali/ yisa ’peni mom’pesho’k walla bora luŋgu’b mo dhali yisa ’peni mombwaasho mo ip̱u’dkina mo jin ’deku is ki mis mo. ");
INSERT INTO udu_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Hili a’di ta’da Arumgimis jin torki gwon dwall ’twa/a ’cesh mo mmo’thi jan ’de/ ’ko’da ’cesh mo dhali cuwa kamuŋ kamu/ mis mo. ");
INSERT INTO udu_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Haali/ e me’d gi Tap̱a mo tani aḵubbaaya diki’d mo jin sekina yimana mura’th jin ḵa/u ki ŋah ŋah ki ’tha’da/ ’tha’da/ mo, jin ’koshu is ki ’bore/ mo. Dhali a’di midi wol a’di ’peni jin p̱inu mo, dhali aris ’kwani kun ta thus ki thus e mony’cesh mo uni mini p̱i a’di ḵu’th mo ki ṯer ntaga ’cummam piti ilu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Hili aha/ mina bwa ’kuny ki sule/ sule/ mo. Aha/ mina yuḵ gway mmomaŋ Arumgimis ma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Aris ce gi uni kun ta thus ki thus mo tani mina a’di wa’b bwa mo hili ce gi uni kun tana ḵar/e minu dhu ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Eya Yahuuda/ mo tani a’di imish ma Arumgimis mo, gway piti jin eḵa/ eḵ mo e bwaman ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Monyc̱a’b piti a’di ṯelkunu sho’k mo e Pan Saliim mo, mo jin c̱a’ba a’di mo tani a’di di’d eya Sihyuun mo. ");
INSERT INTO udu_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","E mun mo tani a’di ki ’ce’da thop̱a/ kun shinunu ki o’d ki yuwar yuwar bwa mo, dhali agoŋgoro/ gi mo/as mo dhali gandal gi mo/as mo dhali aris toŋkan gi mo/as mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Monyca ta jim pini mo, dhali mo jin eḵu mmobol dhan wosha turga/ e kun ’kon ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","’Kwani kun ’kon ma du ki dhethadhe’th mo tani uni dilkunu tom buni kun dilina uni mo. Uni cic̱kin e mo jin ishu e mo. Aris ’kwani gi mo/as mo tani uni mol me’d buni bu’th mmomii to mo. ");
INSERT INTO udu_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","E mo ma ḵucur pini mo ayy Arumgimis ma Yakuub mo tani a’di jin mer shumaruma p̱o/ mo dhali shumarum mo uni su/ miikina buye/ ka yiŋkira/ mo. ");
INSERT INTO udu_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Hili /e, /e tana pure/ mo. Kaja a’di imidi mish doshi bwambori /e mo me’d jin min ma nyor pini ’tulu/ ka pije/ mo? ");
INSERT INTO udu_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","’Peni momis mo tani /e ki bah gwo gom gwon dwall jin toru ’twa/a ’cesh mo. Mony’cesh ḵo/ki is mo dhali dosh shoka ’cesh mo ");
INSERT INTO udu_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","ka Arumgimis cuki mis mo dhali ṯel gwon dwall piti jin toru ’twa/a ’cesh mo mmota ris ’kwani gwansan is ki me’d mo kun ’cwarkunu e mony’cesh mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Ka jiŋ gana/ anyor gi ’kwani midi maŋ /e mo. Dhali anyor jin boc̱ki’d mina /e non ’twa/ ’pena p̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Oyi um gwo is e Tap̱a Arumgimis bum mo dhali thimi uni mo. Dhalki aris uni ’baar mo kun ’kam a’di is mo tani ’doyu to kun c̱inu ki me’d mo e a’di jin minu mii ḵo/ mo ");
INSERT INTO udu_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","dhali a’di jin ’ciṯẖki mondiki/e gi iya/ ma maliḵ mo, a’di jin taki’da pure/ ka pure/ ap̱o/ imaliḵ gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Aha/ gwokina ’twa/ Arumgimis ki nyanye/ mo, mmoko ’twa/ Arumgimis ki nyanye/ ki a’di midi ciḵ aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Ka tee jin ṯocu aha/ bwa mo tani aha/ simmkina Tap̱a e mo, e mon’thiny me’d pem a’di he’thki’d mo ki dar gi mo jin wuna is a’di e mo. Aḵashiram pem a’di ushki’d mo ki a’di minu malas mo. ");
INSERT INTO udu_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Aha/ kulumkina gwo ibwa goma Arumgimis mo, dhali aha/ gwokina mo mmo/anan is mo. Dhali aha/ kulumkina gwo ibwa mo dhali shi/in pem ’thikina buye/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","/E ki bu’th ’ko’d em pem me’d mo ’peni mo jin ’kamutha a’di e mo. Aha/ ṯocu bwa kagahara mo dhali aha/ mola gwo o mo. ");
INSERT INTO udu_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Aha/ hila isi gwo i e goma teen dhamo/ gunn mo, dhali aha/ kakina yil gunn e kadhamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Aha/ ṯorkina ṯor eya dum pem mon’thiny ka ḵar/e mo. Dhali aha/ kulumkina gwo ibwa mo dhali aha/ ŋap̱kina shi/in pem mo. ");
INSERT INTO udu_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Mina Tap̱a usha ush ki sule/ mo dhali diki mii mii ma ’the doḵ/e ’taa? ");
INSERT INTO udu_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Mo/en piti jin ṯelu sho’k daḵki’d mo ’taa? Dhali aris gwom piti kun onu is ’kokin ntagi ’pemen ma risa tee ’baar mo ’taa? ");
INSERT INTO udu_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Arumgimis thiski mii ma ’them piti e mo ’taa? Dhala nyor piti jin shwakina a’di mo tani a’di daḵki’da hil hil ki e ma ’thime/ ki mo/en mo ’taa? Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Dhali aha/ ona gwo mo ki: A’di ta aha/ jin jwakaṯkunuwa du mo ki me’d gi a’di jin Caa e ki Ca aḵki mii e mo. ");
INSERT INTO udu_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Aha/ mina ka mii gi Tap̱a e mo. Nye, aha/ mina ka momer piti e ’peni kun dhamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Aha/ mina kulum gwo ibwa goma ris miin tom pini mo dhali ṯikir gwo kulum ibwa gom mii ma dem dem pini mo. ");
INSERT INTO udu_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Bway pini, ayy Arumgimis, a’di ḵogu mo. Ka rum jana caaca me’da Arumgimis banaŋ gana/ mo? ");
INSERT INTO udu_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","/E tana Arumgimis jin miiki momer mo, /e jin piki mo ma dem dem pini ibwaman ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","/E ki me’da bim pini mo tani /e ki wan ’kwanim pini ’ba/ mo, uni gun ta iya/ ma Yakuub mo dhali ku ma Yuusup̱ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Ka ris yi’de/ p̱arki /e e mo tani ayy Arumgimis, ka ris yi’de/ p̱arki /e e mo tani uni ḵo/kina ḵo/ is mo, nye, uni gun ’kula’kul mo tani deekina is ki bir bir gom moŋḵo/ is mo. ");
INSERT INTO udu_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Dhali araḵ kun ’kani mis wolki yi’de/ mo, dhali momis si’da/ dhalki mondor ma sho’k me’d mo. Dhali athop̱am pini a’di dhwa/a’dki’d ki dhwa/a’d dhwa/a’d mo eya ris ’twaŋkal kuku/ mo. ");
INSERT INTO udu_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Dhali mom pini jin ’twaḵa mondor ma sho’k mo tani a’di diki’d e ’tham kun ’theḵkin mo. Awara sho’k pini a’di kushki mony’cesh mo, dhali mony’cesh deeki’d ki bir bir mo dhali yiḵin is mo. ");
INSERT INTO udu_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Bway pini diki’d e bwam ḵumma/ yi’de/ mo dhali bway tur pini diki’d eya dhan yi’de/ mo. Dhala dum bwam sho’k pini jin yana /e mo tani mishuwa? ");
INSERT INTO udu_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","/E ki sus ’kwanim pini me’da ma’diny ḵa’bal mo, ki me’d ma Musa mo dhala Haruun mo. ");
INSERT INTO udu_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Dhuyi ’ce, ayy ’kwanim pem, ki gwo jin ṯorka/ mo. Ḵa’di bwany’cem bum mo ki gwo ki ’twam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Haali/ aha/ mina ḵa’d ’twam pem ki gwom ’bi’th e mo. Aha/ mina bah gwo mmo/o gwo kun mini ’koki ’ko eya tente/ ’peni gwon dhamo/ mo, ");
INSERT INTO udu_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","’peni to gwansan kun ciḵkina ana gwo mo dhali mish mo, uni gun ṯorkina ibabam bana ana mo. ");
INSERT INTO udu_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ki ana mina ’koki bag uni ’peni uc̱im buni mo, hili a’di minu ṯor ka nyaḵum yil jin mini yayu/ i’ko’d mo mii gi monyca gi Tap̱a mo dhali mo ma dem dem piti mo dhali momer jin wagaskina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","A’di ṯelki gwonyc̱i sho’k eya Yakuub mo, dhali kar gwoŋḵan ’pen ka pije/ jin c̱inu eya Israyiil mo, a’di jin ḵankina a’di ibabam bana mo mmoṯor uc̱im buni gwo mo ");
INSERT INTO udu_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","ki uc̱i ma nyaḵum yil kun min ma p̱o/i ’ko isu/ ki uni mini mish uni mo dhali uc̱i kun ’konuki dho’th naskina/ mo, dhali cu mis mo dhali ṯor uc̱i kun ta uc̱im buni mo ");
INSERT INTO udu_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","wakan ki uni mini dhu mo ma ’teŋ kap̱em buni eya Arumgimis mo dhali ’koki this mii ma Arumgimis e mo, hili mmodhu gwoŋḵan piti kun ’kwarkunu mo ");
INSERT INTO udu_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","dhali ki uni mini ’taki ’koki waki ibabam buni mo, mmota ga du jin tana wa’ba/ mo dhali ta anyaḵum yil kun mini pish is ka le’d mo, uni gun mini ta anyaḵum yil kun min ma du ṯel shoka ’cesh mo, uni gun mini ta ga ḵashira/ kun mini ’koki ta ku isiŋ gana/ goma Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","’Kwani ma Ep̱rayim uni takin ka bwaa gi mo/as mo, dhali uni doḵkin ka nyaŋ’ko’d mo ka tee jin asuwa mee mo. ");
INSERT INTO udu_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Uni ’koki dhu Gwo ma Arumgimis jin gamu me’d mo, hili uni ushkin ki ’tash mo mmo/ii isi ki gwoŋḵan piti jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Uni ŋaki mii kun miikina Tap̱a mo dhali miimer jin ṯorkina a’di uni mo. ");
INSERT INTO udu_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","E jis/e gi ibabam buni mo tani a’di wagaski momer mo dhali e Pam Masir mo dhali e bwam bunto ma Suu/an mo. ");
INSERT INTO udu_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","A’di ki ḵwa/ dhan ḵumma/ yi’de/ bwa mo dhali dhal uni bway mo mmo/ii icine/ mo dhali a’di ki kar yi’de/ mmodosh me’da gap̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Dhali montee mo tani a’di ki shu uni bway ka raḵ mo, dhali mon’thiny isa yempa/ mo tani a’di ki shu uni bway ka dhan o’d jin kushi mo mo. ");
INSERT INTO udu_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","A’di ki tawan wosh e ki cwa e mombwaasho mo dhali a’di ki c̱i uni yi’de/ jin kasha e ki kash mmop̱i mo me’d mo jin ’kula’kul mo. ");
INSERT INTO udu_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","A’di ki dhal yi’de/ bway mmo’thonthoru/ ’peni ’kuwosh mo, dhali a’di ki raḵ yi’de/ mmogac̱u/ ka ’cesh me’d a’di jin guski’d e bwaagap̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Naskina/ uni ’kon mmomii miinthus ap̱o/ a’di mo, mmopish is ka le’d ap̱o/ a’di jin Caa e ki Ca mo e bwam ma si’b mo. ");
INSERT INTO udu_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Uni ki pal Arumgimis ka dum buni mo ki gwom buni jin ’theḵkina uni gom tonṯe/ mo ka dum buni kun purki uni mo. ");
INSERT INTO udu_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Uni ki o gwo ap̱owa Arumgimis mo mmo/o gwo mo ki: A/Arumgimis mishi c̱i ana tonṯe/ mmoshwa e bwaashowa? ");
INSERT INTO udu_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","A’di ki mush wosh ki cwa mo, wakan yi’de/ kolki ’kus mo, dhali yi’de/ ’thonthorki’d kagahara mo. Gara/ mina a’di diki c̱i tonṯe/ walla dina a’di gara/ ki c̱i shum ki ’kwanim piti mo? ");
INSERT INTO udu_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Wakan ki Tap̱a ciḵki gwo mo tani, a’di ’tu’dkunu ka nyor mo. O’d a’di ’thakunu ap̱owa Yakuub mo, anyor piti a’di caki’da p̱owa Israyiil mo ");
INSERT INTO udu_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","haali/ uni dar gi moŋgam gwo is eya Arumgimis mo dhali ’koki gam gwo is gom mom’bi’th piti jin tana a’di ata is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Naskina/ a’di ki ḵan momis jin di’di mis mo, dhali a’di ki ḵa’c acampur gi momis mo ");
INSERT INTO udu_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","dhali a’di ki hethu a’cesh ap̱o/ uni amanna mmoshwa mo, dhali a’di ki c̱i uni pos ’peni momis mo. ");
INSERT INTO udu_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","’Kwani shwaki tonṯe/ gi iman’doyu gwo mo. A’di hashki uni tonṯe/ ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","A’di ki raḵ ’tham gi mom’pesho’k mmoposhu e momis mo, dhali ki mom’bi’th piti mo tani a’di ki shu ’tham ma biny cam bway mo. ");
INSERT INTO udu_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","A’di ki he’th shum ap̱o/ uni me’d bu’da ’cesh mo, dhali ’dii kun ’kan ma bi me’d emena si’b kun ’kon e bwaman ma gap̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","A’di ki dhal uni bway mo mmoṯa’k e bwaman gu’b c̱iŋŋam buni mo, mmo’kama ris mom buni kun ’kona uni is mo. ");
INSERT INTO udu_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Dhali uni ’kaki uni mo ntagi uni kap̱kin ki kap̱ gana/ mo, haali/ a’di c̱iki uni to jin ’thona bwa uni ki gor gor mo. ");
INSERT INTO udu_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Hili nṯwa/a/ ki uni dhu to kun gora bwa uni mo tani, ki tonṯe/ di’d e ’twam buni mo tani, ");
INSERT INTO udu_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","anyor ma Arumgimis cuki mis ap̱o/ uni mo dhali a’di ki ’kosh uni gun ’bitha’bi’th ’peni bwam uni mo dhali a’di ki ’thi uni gwahan a’cesh uni gun dhunu ’pen ka pije/ gom mom’bor buni ’peni ’Kwani ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Bahili ap̱owa ris to gwansan kun miinu mo tani uni ’kon naskina/ mmomii miinthus mo. Dhali bahili ki a’di mii momer piti mo tani uni ’koki gam a’di gwo is mo. ");
INSERT INTO udu_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Wakan a’di dhalki’da teem buni mmop̱uu mo me’da wulp̱e/ mo dhali yil buni ta’da pure/ ka pure/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Ki a’di ’koshki uni mo tani uni ŋap̱ki a’di mo. Uni ri’ckina du is mo dhali ŋap̱a Arumgimis ka duŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Uni kaki gwo e ka Arumgimis a’di ta wosh buni mo, a’di jin ta’da Arumgimis buni jin Caa e ki Ca jin wanki’da wan ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Hili uni ṯorkina ṯor ki a’di ki ’twany jarom buni ka maḵ mo. Uni takina ṯor ka ṯor gom a’di ka le’d buni mo. ");
INSERT INTO udu_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Adum buni yisa ṯelu shoka ’kup̱ ki a’di mo. Uni ’koki ha me’d gom gwoŋ ganam piti jin gamu me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Hili a’di di’d naskina/ mmohila hil ki e ma ’thime/ ki mo/en mo, dhali gwam uni ’peni tonthus buni kun miikina uni mo, dhali diki ’ce’d uni sho’k mo. A’di ’tumki’da nyor piti is ka nyaŋ’ko’d me’d ka ris mo, dhali a’di diki mura nyor piti ’baar mo mmoshwa a’cesh ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","A’di kaki gwo e mo ki uni ta jasi shuman is gi buŋgwar is mo, me’d ’tham yin jin poshki’d mo dhali diki wuṯulu/ ka nyaŋ’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Me’d wana risa kun pisha uni is ka le’da p̱o/ a’di e mombwaasho mo dhali jwakaṯ a’di adum piti e bwam ma si’b mo. ");
INSERT INTO udu_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Uni palki a’di doḵ/e dhali doḵ/e mo dhali rukuny A’din ’De/ jin Ḵogu jin ta jima Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Dhali uni yisa dhu mom’bi’th piti eya dum buni yisa, walla atee yin si’da/ me’d jin wankina a’di uni ’ba/ ’peni ’kup̱ buni mo, ");
INSERT INTO udu_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","me’d jin wagaskina a’di jamas miim piti e Pam Masir mo, dhali miimer piti e bunto ma Suu/an mo. ");
INSERT INTO udu_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","A’di ki ṯu’k yi’dem buni mmota abas mo, wakan ki uni mini ’koki p̱i yi’dem buni kun sokin mo. ");
INSERT INTO udu_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","A’di ki hash dhana buhanya ḵanthi/ e bwaman uni mo a’di jin loski uni mo, dhali adhana buhanya ’dwa/ jin ’ce’dki uni sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","A’di ki c̱i tonṯem buni kun sina uni ka jirsaŋ mmoshwa mo, dhali maman buni jin miina uniya ṯu’c mo tani shwan ma kuyu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Dhali a’di ki ’ce’d cwalman tom buni sho’k ka wasa/ mo dhali cwamp̱u/ buni ki jap̱e/ jin wuna uni me’d manyandhe/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Dhali a’di ki c̱i bip̱ buni cwa ki me’d ka wasa/ mo, dhali ma’diny ḵa’bal buni uni dorkunu ki dhan o’d jin dhwa/a’dki’d mo ’pena wara sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","A’di ki ’cuḵa nyor piti jin c̱a’bki wur wur ap̱o/ uni mo, anyor jin ta’da nyor piti jin deḵ a’di mo dhali mo ma c̱is mo, uni gun ’doyina iman’doyu gwo kun ’ce’dkina ’ce’d sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","A’di ki kar bway tur goma nyor piti mo. A’di ’tash uni ’twa/ ’peni mowuwa? Hili a’di ki kar ’kup̱ki ṯa’kki moŋ’koki/em buni ki mom’ba’th jin wo’cki uni is she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","A’di ki musha risa bwanyara/ gi ’Kwani gi Pam Masir ki cwa mo, mom’bi’th jin ta jim buni jin gac̱ki’d e gu’ba’ku/ ma Haam mo. ");
INSERT INTO udu_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Dhali yan’ko’d a’di ki shu ’kwanim piti bway ka pije/ me’d ḵa’bal mo, dhali a’di ki shu uni bway e mombwaasho me’da ma’diny ḵa’bal mo. ");
INSERT INTO udu_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","A’di ki sus uni ki ’dantar mo, wakan uni ’koki ḵo/ is mo. Hili dhan ḵumma/ yi’de/ a’di ’ce’dki ’kup̱ buni sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Dhali a’di ki sus uni ka pije/ e mony’cesh piti jin ḵogu mo, dhali e ’kuwosha turga/ jin ta’da bim poros piti mo jin gamkina a’di adu is mo. ");
INSERT INTO udu_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","A’di ki ura ris kal gi ’kwani ka pije/ ibwambori uni mo. A’di ki dhu mo ki she/ gom uni jin mina uni mii bu’th mo, dhali thoson mo kun minu ’ko goma waḵ ma Israyiil e gu’ba’kum buni mo. ");
INSERT INTO udu_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Naskina/ uni ’kon mmopal a’di mo dhali pish is ka le’da p̱o/ a’di jin Caa e ki Ca jin ta’da Arumgimis mo, dhali ’koki dhu gwonyc̱im piti mo, ");
INSERT INTO udu_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","hili uni ṯu’kkin mo dhali ’dap̱ e ki miiny dac̱ara/ mo me’d ibabam buni mo. Uni ṯoshkin me’da bwaa jin he’kki’da he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Haali/ uni rukunyki a’di mo mmomii anyor mo ki mom buni kun eḵa/ eḵ mo. Uni ki raḵ a’di joc̱u/ ki mo jin ’thoṯẖu/ bwa ki miin dhap̱an mo gom tomp̱inycon buni kun uḵa uni mmoluŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Ka Arumgimis ciḵki gwo mo tani a’di ’tu’du ka nyor mo, dhali a’di ki waḵa Israyiil ka bor ’deŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","A’di ki dhal mom piti ’pen jin c̱a’bkina a’di jin ta Pan Shilu mo, e gu’ba’ku/ jin c̱a’bkina a’di e bwaŋ ’kwani mo, ");
INSERT INTO udu_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","dhali a’di ki ’cuḵ mom’bi’th piti ap̱o/ uni gun bu’thkunu mo mmota c̱iŋkina/ mo, dhali monyca gi me’d piti ap̱o/ ’kwani kun ta ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","A’di ki c̱i ’kwanim piti e me’d gi uni kun ḵal gandal mo, dhali kuma nyor piti mo ap̱o/ uni kun ta mal piti mo. ");
INSERT INTO udu_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","O’d shwaki ’kwani kun ta dhuru’c buni mo, dhali nyaram buni uni dar gi gway gi momash mo. ");
INSERT INTO udu_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Igasiis buni ṯa’kkina ’cesh gom shemen gandal mo, dhali up̱a dhalla/ gi igasiis mo, moŋkamu/ gwona uniya? ");
INSERT INTO udu_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Dhali yan’ko’d Tap̱a merki e mo ’peni mo jin wana e ki mo jin ishkina a’di e mo, me’d wathi/ jin ’bitha’bi’th jin ’therki cuuwa/ gom yimana mura’th jin p̱ina a’di jin ḵa/u ki ŋah ŋah mo. ");
INSERT INTO udu_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Dhali a’di ki dhu ’kup̱ piti mmoḵwa/ bwa mo. A’di ki dhu uni e mo ma ’the is ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","A’di ki waḵ gu’ba’ku/ ma Yuusup̱ mo, dhali a’di diki kwanya waḵ ma Ep̱rayim mo. ");
INSERT INTO udu_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Hili a’di ki kwany awaḵ ma Yahuuda/ mo, a’di jin ta ’Kuwosha Sihyuun, a’di jin ena a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","A’di ki nyaŋ mom piti jin ḵogu mo me’d mo jin eḵa/ eḵ e momis mo, dhali me’d mony’cesh jin ṯelkina a’di sho’k ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Dhali a’di ki kwanya Dawuu’d jin ta c̱iŋkinam piti mo, dhali sus a’di mo ’peni mo jin hila a’di ḵa’bal mo, ");
INSERT INTO udu_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","’peni mo jin hila a’di ushi nas ḵa’bal kun bwan mo tani a’di ki sus a’di mo mmota amanhil ḵa’bal gom ’Kwani ma Yakuub mo, a’di jin ta’da Israyiil jin ta mal piti mo. ");
INSERT INTO udu_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Ka du jin ta a’di pa ki pa mo tani a’di ki hil uni mo, dhali a’di ki shu uni bway ki me’d piti jin ta gwocon mo. ");
INSERT INTO udu_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Ayy Arumgimis, ’kwani kun ’kon ki ’kus ’peni ji gi luŋu mo tani uni p̱u’dkun e mo gi mal pini mo. Uni ki shi/ gu’b gi mondheleladhelel pini mo. Uni ki shi/ Pa Urushaliim mo mmokup̱ a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Uni ki c̱i buŋgwar is gi c̱iŋkinam pini ki ’dii kun p̱en e momis mmota tonṯe/ gom uni ki ’ka mo, buŋgwar is gi unim pini kun dhunu mo ki she/ ki dhelel dhelel mo tani ’kakina toŋgwap̱i/ gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Uni wolkina bas buni me’d yi’de/ mo mmo’kam Pa Urushaliim is mo dhali jaŋkamu/ di’d jin kan uniya? ");
INSERT INTO udu_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Ana warkina ki uni gun c̱inu gura/ ki imannyaḵ ’kom bana mo, dhali miikunu ka maḵ mo dhali p̱e’th ki p̱etha sor ki uni gwansan kun ’kamki ana is mo. ");
INSERT INTO udu_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Ayy Tap̱a, kakasja imina /e di mo mmomiiya nyor mo? Min ma nyor pini ’peni bwan ṯa’c pini diki pur me’d o’da? ");
INSERT INTO udu_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Woli /e anyor pini ap̱o/ kal gi ’kwaniny’cesh mo uni kun ’koki mish /e mo, dhali eya dhan bampa/ mo uni kun ’koki yuḵ gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Haali/ uni loskina Yakuub mo, dhali shi/ mom piti is mo. ");
INSERT INTO udu_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Dhalku/ ki doḵ/e ka gwo e ap̱o/ am gom miinthus kun miikina ibabam bam kadhamo/ mo. Dhalki mo ma ’thimem pini jin hilu ki mo/en p̱u’du’d ki jahanne/ gam am ’kup̱ mo, haali/ aman dhukunu e mo jin ’the am is ki ’the ka luŋgu’b mo. ");
INSERT INTO udu_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Woṯẖi/ aman mo, ayy Arumgimis, jin ta bway mowoṯẖ bam mo, ki gway gi monycam pini mo. ’Cuḵi aman mo dhali gwami aman ’peni miinthus bam mo, gom gway gi gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Ki to jin ta’da ta imina kal gi ’kwaniny’cesh i/o gwo mo ki: Mane Arumgimis buni mane? Dhalki mori’c pini goma bas gi c̱iŋkinam pini jin gac̱kunuwa ’cesh mo, dhalki a’di mishu mo e bwaman kal gi ’kwaniny’cesh e bwambori jis/em bam mo. ");
INSERT INTO udu_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Dhalki mo/ohon gi uni gun dhunuwa sijin p̱u’dkini bwambori /e mo, ki isi ki dhan mom’bi’th pini mo ki /e mini ’tash uni ’twa/ mo uni gwansan kun ’disha ’twa/ mmowu mo. ");
INSERT INTO udu_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","’Tu’dki uni to me’di pesu/ ibwambor mo uni gwahan kun ta imannyaḵ ’kom bam mo, gom gura/ jin c̱ikina uni /e mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Dhali yan’ko’d aman kun tana ’kwanim pini mo, uni gun tana ma’diny ḵa’bal pini goma shon dhii/i’d pini mo aman mina c̱i /e mo jin ’boruwa ’bor bwa i is ki sule/ sule/ mo, ’pena nyaḵum yil jin tanu mo ntaga nyaḵum yil jiŋ ’ko’d mo, aman mina p̱e’d momaŋ pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","C̱iyi ’ce mo ma, ayy Amanhil Ḵa’bal ma Israyiil mo, /e jin shukina Yuusup̱ bway ka pije/ me’da ma’diny ḵa’bal mo. /E jin karkunu mo mmoc̱a’ba p̱o/ ḵursi ma maliḵ mo ap̱owa c̱arabiim kun ’thup̱a ḵursi is ka bim buni mo tani, kushi mo mo ");
INSERT INTO udu_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","ibwambor ma Ep̱rayim mo dhali bwambor ma Benyamiin mo dhala Manassa mo. Piri mo ma dem dem pini is mo dhali yayu/ mo mmota am is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Waru/ am is mo, ayy Arumgimis. Dhalki bwam/em pini kushu mo mo, ki am minu ta is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Ayy Tap̱a Arumgimis gi momis mo, anyor pini midi di p̱u’d kakasja gom mon’tho gi ’kwanim pini mo? ");
INSERT INTO udu_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","/E ki c̱i uni tonṯe/ jin shwana uni jin ta jabu’th mo, dhali /e ki c̱i uni jabu’th mmop̱i mo ki sheŋ kwa jin ’tu’du’d mo. ");
INSERT INTO udu_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","/E ki dhu am ki imannyaḵ ’kom bam mmoc̱i am gura/ mo, dhali uni gun ta ’kup̱ ki am mmop̱e’th e bwaman is buni mo. ");
INSERT INTO udu_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Waru/ am is mo, ayy Arumgimis gi momis mo. Dhalki bwam/em pini kushu mo mo, ki am minu ta is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","/E ki ḵal cwalman ka pije/ ’peni Pam Masir mo, dhali /e ki ura ris kal gi ’kwaniny’cesh ka pije/ mo dhali c̱u’th a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","/E ki kara ’cesh eya tente/ gom a’di mo. A’di ki guwa birman piti ka luŋgu’b e mo jin ’kula’kul mo dhali a’di ki ’tu’d mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Dhali ’kuwosha turga/ uni ’tu’dkunu mo ka lam piti mo, cwa kun wana e ka bwanyayiis kun c̱a’bki dem dem nyaḵka bim piti mo. ");
INSERT INTO udu_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","A’di ki hash ka bim piti ntagi ḵumma/ yi’de/ mo dhala birman piti mmoya gam yi’de/ a’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Goma tinta sa/ i’ce’dkina /e agaŋgaram piti ka ’cesh mo wakan ka ris uni gun iikin ki iimpe e bway piti mo tani hoki maman piti mo? ");
INSERT INTO udu_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Abogo’b gi bwaasho a’di ha’thki a’di ki ’twa/ mo, dhali aris to gwansan kun ’kon mmoḵal ya e bwam bunto mo tani shwaki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Ṯuku mo doḵ/e, ayy Arumgimis gi momis mo. Hili mo ka luŋgu’b ’peni momis mo dhali p̱ar mo e mo. Hili cwalman ma mura’th yan mo ma, ");
INSERT INTO udu_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","a’di jin koṯẖki’d jin sikina /e ka bim poros pini mo. ");
INSERT INTO udu_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Uni c̱i’thki a’di ki o’d mo dhali uni ki jep̱ uni ka ’cesh mo. Dhalki uni ’ce’d sho’k mo e mo jin ḵucura ḵucur mo jin ta jis/em pini mo. ");
INSERT INTO udu_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Hili dhalki me’d pini a’di di’da p̱o/ wathi/ jin ta me’da bim poros pini mo, a’di jin ta ya/ gi wathi/ jin karkina /e mmo’bitha’bi’th gom is pini mo. ");
INSERT INTO udu_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Dhali yan’ko’d am mina mol doḵ ka nyaŋ’ko’d ’peni /e ki sule/ mo. C̱i am moŋ’koki/e mo dhali am mina yer gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Waru/ am is mo, ayy Tap̱a Arumgimis gi momis mo. Dhalki bwam/em pini kushu mo mo, ki am minu ta is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Yuḵi um gway ki ’kal ’kal eya Arumgimis jin ta mom’bi’th bana mo. Ḵumi cuuwa/ mo gom bwaŋ ’kunyka/ eya Arumgimis ma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","’Deki gway abor ki mis mo ki ko ma dheŋdhenye/ jin p̱inu ki me’d mo, adheŋdhenye/ jin ’kon ma shu/i pesu/ mo jin ’kunya’kuny mo dhali adheŋdhenye/ mo. ");
INSERT INTO udu_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","P̱iyi apoome/ ka ppen this mo, dhali ka ppe jin ta’da kunn is mo, ka cim jin yuḵuwa yuḵ ka tul ’kup̱ bana mo. ");
INSERT INTO udu_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Haali/ a’di ta gwoŋḵan jin bahu gom ’Kwani ma Israyiil mo, dhali gwoŋḵan ma Arumgimis jin onu ki ’twa/ goma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","A’di ki kar gwoŋḵan goma Yuusup̱ mo, me’d jin yakina a’di ka pije/ e Pam Masir mo. Aha/ ciḵkina ’twa/ mo a’di jin molkika/ mo. ");
INSERT INTO udu_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Aha/ soroṯẖkina /e ’kup̱a bim pini ’peni ton diṯi’d mo. Me’d pini karu ki ’kus ’pena nura/ mo. ");
INSERT INTO udu_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","E mo ma c̱is pini mo tani /e yuḵkina yuḵ mo dhali aha/ ’cuḵkina /e mo. Aha/ thoḵkina /e ’twa/ ka ḵwal is e mo jin dor ma shoka dor mo. Aha/ palkina /e mo e yi’de/ ma Mariiba mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Ciḵi gwo mo ma, ayy ’kwanim pem, dhali aha/ mina ḵucur um mo ki ḵucur pa mo. Ayy Israyiil, waḵki/ /e mina bwa ’taki oyi, hili dhali ciḵ aha/ gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Wakan ka rum p̱inycon kun luŋa ’kwanin tiya midi diki di e bwam um mo. Wakan ki um mini ’koki luŋ ka jiŋ ’kup̱a’dup̱un gom tomp̱inycon jin luŋa ’kwanin tiya mo. ");
INSERT INTO udu_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Aha/ tana Tap̱a Arumgimis bum mo, a’di jin suski um ka pije/ ’peni Pam Masir mo. Ḵa’di ’twam bum ki waŋgal mo dhali aha/ mina ’tu’d a’di ki piny piny mo. ");
INSERT INTO udu_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Hili ’kwanim pem ’koki ciḵ ’twam pem mo, Israyiil midi ’taki ta gi jim pema kamuwa? ");
INSERT INTO udu_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Wakan aha/ c̱ikina uni bway mo eya dum buni kun miin ki wa’th wa’th mo, mmobaṯẖ gwom buni kun logoma bwam buniŋ gana/ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Ayy, ki ’kwanim pem mini ’taki ’koki ciḵ aha/ gwo mo sa/? Ka Israyiil midi ’taki ya e bway pem moyi. ");
INSERT INTO udu_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Aha/ ’disha ’twa/ ba/ mmo’ce’d ’kup̱ buni sho’k mo, dhali ṯu’k me’d pem ap̱o/ uni gun ta ’kup̱ ki uni mo. ");
INSERT INTO udu_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Uni gwansan kun shi/ki Tap̱a i e mo tani uni mini ’taki koc̱ki ṯil ṯil ’kup̱ ki a’di mo, dhali tom buni jin ’baki uni e mo tani midi diyi bwambori uni ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Aha/ mina ’taki thip̱ um ki pos bunyan gana/ mo dhali ka dham ’peni wosh jin midi ’taki kap̱ um moyi. ");
INSERT INTO udu_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Arumgimis bu’thki mom piti e mo ma tul ’kup̱ jin ta jim piti mo, eya ris bwaman gi ’kwani ma hakuumam piti a’di ki kar mo jin dwallu gwo jin toru gwo ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","/E mini daḵ gwo dwall ki shi/ shi/ kakasja mo dhali ṯor mo ma gwar ’de/ gom uni gun ta thus ki thus mo? Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","C̱iyi mii ma ḵar/e ki uni gun ’ka’da is mo dhali uni gun daran gi icom mo. Hali mo ma ḵar/e gom uni gun dorkunuwa du mo dhali gom uni kun mini mii ta gi to mo. ");
INSERT INTO udu_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","’Cwamu/ uni gun ’ka’da is mo dhali uni kun mini mii ta gi to mo. ’Cuḵi uni mo ’peni me’d gi uni gun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Uni mish toŋ kamu/ nyiṯẖ yisa walla gwoŋ kamu/ misha uni ’bana? Uni iikin e mondhurumi’d mo. Aris mo gun ḵa’bu mony’cesh mo tani uni yiḵinki is mo. ");
INSERT INTO udu_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Aha/ ona gwo mo ki: Um a’di itana hakuuma mo, dhali um ta iya/ gi a’di jin Caa e ki Ca mo, aris umi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Bahili um ’baar mo mini wu mo me’d ’kwani mo dhali ṯa’k ’ko’da ’cesh me’d iya/ ma maliḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Cuyi mis mo, ayy Arumgimis, dhali dwalli mony’cesh gwo mo haala ris kal gi ’kwaniny’ceshi ’baar mo tani ta kum pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Ayy Arumgimis, dhalku/ ki c̱a’b ki shwamm mo. Dhalku/ ki c̱a’bi bu’th moŋḵu’th is pini mo walla di ki shwamm mo, ayy Arumgimis. ");
INSERT INTO udu_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Haali/ hili mo mo ma, ’kwaniŋ ’kup̱ pini uni miikina dulaṯṯ mo. Uni gwansan kun shi/ki /e i e mo tani uni ’deki ’kup̱ buni ki mis mo. ");
INSERT INTO udu_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Uni ’thiki gwonthus ’cesh ap̱o/ ’kwanim pini mmocesh uni mo. Uni ṯorkina ṯor mmonṯal ’de/ ap̱o/ unim pini gun ceshkina /e ka p̱o/ mo. ");
INSERT INTO udu_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Uni o gwo mo ki: Iiyu/ mo, dhalki ana dhidha uni sho’k ka pupush ’peni kal jin tana uni mo. Dhalku/ ki dhal gway ma Israyiil ki a’di minu ka e doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Nye, uni ’dap̱an ki me’d ki gwom buni ka rem ’kup̱ mo. Ap̱o/ /e mo tani uni ki gam gwo me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Gu’ba’ku/ gi ’Kwani Pa Aduum dhali ’Kwani ma Isma/iil dhali ’Kwani gi Pa Muwab dhali ’Kwani gi Pa Haajar mo, ");
INSERT INTO udu_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","dhali ’Kwani gi Pany Jibaal dhali ’Kwani gi Pa Ammuun dhali ’Kwani gi Pa Amalik, dhali ’Kwani gi Pam P̱alasthiin nyaḵka ris ’Kwani gi Pan Sur mo. ");
INSERT INTO udu_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Dhali ’Kwani gi Pan Ashshuur si’da/ uni gamki gwo me’d ki uni mo. Uni ta ’kwani kun ’bi’th ma bi ki ’bi’th kun ta uc̱i ma Luuth mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Wakan /e mini mii miim pini ap̱o/ uni me’d jin miikina /e ap̱oŋ ’Kwani gi Pam Midyaan mo, dhali me’da Sisara dhala Yabin mo e Yi’de/ ma Kishun mo, ");
INSERT INTO udu_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","uni gun ’ce’dkunu sho’k mo e Pan Endor mo, uni gun warkin ki gure/ gom mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Dhuyi mom buni kun tana uni ’penkap̱an mmowa e ka Guraab dhala Diib mo dhali aris iya/ ma maliḵ buni mo me’da Sabah dhala Salmunnaa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Uni gun o gwo mo ki: Dhalki ana budha to gom is bana mo ’pena shon dhii/i’d ma Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Ayy Arumgimis pem, dhuyi uni mmowa e ki ’tham jin ’theḵi bu’da’cesh ki ji wuṯul mo, me’da ’pi’b jin ’dashu ibwambori ’tham mo. ");
INSERT INTO udu_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Me’d o’d jin shwaki bwanycwa mo, dhali me’da le’dan o’d jin shwaki’d ka le’d eya ris ’kuwosha turga/ mo tani ");
INSERT INTO udu_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","wakan /e mini ŋal uni ka c̱unthar pini mo, dhali p̱or uni bwa ka p̱unthar pini mo. ");
INSERT INTO udu_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","’Tu’dki uni bwam/em buni ki mo ma ’the is mo, ki uni mini ’taki ŋap̱ gway pini mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Dhalki uni dhunu ki mo ma ’the is mo dhali ’koku ki ’ko ma c̱is ki sule/ sule/ mo. Dhalki uni ’ce’dki sho’k mo ki mii jin thiskunu mii ’ko’d e ki dar ka ’the mo. ");
INSERT INTO udu_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Dhalki uni mish gwo ’ban mo ki /e a’di iṯal ’de/ mo jin tana gway pini Tap̱a mo, /e jin Caa e ki Ca ap̱o/ mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Mom pini jin c̱a’ba /e mo tani wanu ena, ayy Tap̱a gi momis mo. ");
INSERT INTO udu_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Aḵashiram pem c̱orki’da c̱or mo, nye a’di ’thikina buye/ mo gom mo ki monyc̱a’b gi Tap̱a mo. Adum pem dhali buŋgwar is pem yuḵi gway ki bwaŋ ’kunyga/ goma Arumgimis jin di ki e mo. ");
INSERT INTO udu_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Isi kan si’da/ ara ganya/ a’di gamki gu’b mo dhala gwajayilil taki’d gi gu’b gom is piti mo, e mo jin mina a’di dho’th ushan piti mo, e mo ma gwaṯam pini jin miinu to mo, ayy Tap̱a gi momis mo, /e jin tana Maliḵ pem mo dhali Arumgimis pem mo. ");
INSERT INTO udu_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Mom’bor mii gom uni gwansan kun ’kokin e gu’b pini mo, uni gun yuḵki gway mmomaŋ /e ki sule/ sule/ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Mom’bor mii gom ’kwani gwahan kun ’kona mom’bi’th is e /e mo, dhali uni gun ḵwasharr ma du ki ḵwasharr e bway ma Sihyuun mo. ");
INSERT INTO udu_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Me’d jin iikina uni ka luŋgu’b e embul wosh ma Buka mo tani uni ki war a’di mmota mo jin kasha yi’de/ e ki kash mo, dhala shoka ’ce’dc̱ipiny tashki a’di ’kup̱ ki usha al piti mo. ");
INSERT INTO udu_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Uni iikin ki mo jin ’bithu is mo itagi mo jin ’bithu is mo. Arumgimis jin bol tiya e ki ’bor mo tani a’di iminu mish mo eya Sihyuun mo. ");
INSERT INTO udu_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Ayy Tap̱a Arumgimis gi momis mo, ciḵi mon’thom pem mo ma. Dhali c̱iyi /e ’ce mo, ayy Arumgimis ma Yakuub mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Hila goŋgoro/ me’d bam mo ma, ayy Arumgimis. Hili ’kup̱ ki jis/e gi a’dim pini jin ’koshu ki monyca mo. ");
INSERT INTO udu_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Haali/ atee gi mo ki monyc̱a’b pini mo tani a’di ’boro’d mo, mmobola alip̱ gi mo gunn e mo. Aha/ mina ’taki dhal mii gunn e i is ’te/ sayi mmota manhil ’twaŋkal gu’b ma Arumgimis pem mo mmobol mo jin ’konu e gu’ba’ku/ gi ’kwani kun ta thus ki thus e mo. ");
INSERT INTO udu_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Haali/ Tap̱a Arumgimis a’di ta’da tente/ dhali agoŋgoro/ mo. A’di c̱iki mo ma ’the dhali montaḵ mo. Tom ’boro’da kamu/ mina Tap̱a non yisa ’peni uni gwansan kun iikin ki iiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Ayy Tap̱a gi momis mo, mom’bor mii gom wathi/ jin gamki gwo is e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Tap̱a, /e miiki isi mii gi bwa goma ’cesh pini mo. /E ki waru/ shamaneṯṯan ma Yakuub is mo. ");
INSERT INTO udu_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","/E ki gwamki miinthus gi ’kwanim pini mo. /E ki dhal ka ris miinthus buni ’pen mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","/E doḵkina nyor pini bway bwa ’baar mo. /E ṯu’kkin mo ’pena nyor pini jin ’batha’ba’th mo. ");
INSERT INTO udu_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Waru/ aman is ka nyaŋ’ko’d mo doḵ/e ayy Arumgimis jin ta bway mowoṯẖ bam mo dhali dhu ka nyor pini gunn ’pen ka pije/ kun deḵkina /e ap̱o/ aman mo. ");
INSERT INTO udu_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","A/e mini miiya nyor ap̱o/ aman ki sule/ sule/ kan mo? A/e mini dhala nyor pini mmoya ki tur ap̱o/ ma risa nyaḵum yil gi ’kwani kana? ");
INSERT INTO udu_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Mina /e bunya/ diki tash am e mo doḵ/e? ki ’kwanim pini mina bwa ’kuny mo e /e? ");
INSERT INTO udu_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Ṯori aman mo/en pini jin ṯelu sho’k mo ma, ayy Tap̱a, dhali dhalki aman bway gi mowoṯẖ pini me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Dhalki aha/ ciḵa gwo mo ma, gwo jin min ma Arumgimis jin ta Tap̱a o mo, haali/ a’di midi o gwo gom moŋḵu’th is ki ’kwanim piti mo, dhali unim piti gwansan kun dhunu mo ki she/ ki dhelel dhelel mo, dhali uni gwansan kun ṯu’kkun e a’di mo eya dum buni mo. ");
INSERT INTO udu_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Ka jiŋ gana/ bway mowoṯẖ piti a’di diki’d e me’d mo gom uni gwansan kun ḵo/ki a’di mo ki monyca midi di e bampam bana mo. ");
INSERT INTO udu_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Mo/en jin ṯelu sho’k mo dhali mii jin ta ji ma isiŋ gana/ mo tani uni mini sho ki me’d mo. Mii ma ḵar/e dhali moŋḵu’th is uni mini p̱i ’twa/ ka rem ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Mo ma isiŋ gana/ midi kash e me’d yi’de/ ’peni mony’cesh mo, dhali mii ma ḵar/e midi hil ka luŋgu’b ’peni momis mo. ");
INSERT INTO udu_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Nye, Tap̱a a’di midi c̱i a’di jin ’boro’d mo, dhali bampam bana a’di midi gwono’d a’di jin midi mara mar is mo. ");
INSERT INTO udu_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Mii ma ḵar/e midi ya ibwambori a’di mo dhali kar ŋaṯgin piti mmota bway mo be. ");
INSERT INTO udu_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Ḵa’di ’cem pini mo, ayy Tap̱a, dhali ciḵ aha/ gwo mo, haali/ aha/ hatha’ko’d mo dhali mina mii ta gi to mo. ");
INSERT INTO udu_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","’Tashi mondiki/em pem ’twa/ mo, haali/ aha/ tana wathiŋ gayiin mo. Tayi c̱iŋkinam pini is ki me’d mo, a’di jin gami gwo is e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","/E tana Arumgimis pem mo. Miiyi mii ka ’the gom aha/ mo, ayy Tap̱a, haali/ e /e mo tani aha/ gwokina ’twa/ i /e iyula tente/ mo. ");
INSERT INTO udu_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","’Kunyi aḵashira/ gi c̱iŋkinam pini mo, haali/ e /e, ayy Tap̱a, aḵashiram pem ’de’kka/ ’kup̱ ’kup̱ ki mis mo. ");
INSERT INTO udu_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Haali/ /e, ayy Tap̱a, ta a’di jin ’boro’d mo dhali jin gwamki’da gwam mo, ki mo/en pini jin ṯelu sho’k mo jin ishki’d ka enthus mo gom uni ’baar mo kun mini yuḵ /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","C̱iyi ’cem pini, ayy Tap̱a, ka ’thom pem mo. Ciḵi gwo gom ko jin gwoka/ ka di’b me’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Ka tee jin ṯocu aha/ bwa mo tani aha/ yuḵkina /e mo, haali/ /e thoḵki aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Jaŋkamu/ yisa di’da e bwam ma rum thus gwahan jin waki /e, ayy Tap̱a, walla jaŋ kamu/ yisa di’da jin mii to me’d /e mo. ");
INSERT INTO udu_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Aris kal ma ris ’kwaniny’ceshi ’baar mo kun uḵa /e mo tani mini p̱u’du/ mo dhali luŋ ki jiŋ ’kup̱a’dup̱uni bwambori /e mo, ayy Tap̱a, dhali kar gway pini ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Haali/ /e caaca mo dhali miina dhan to gi momer mo, dhali /e ’de/ itana Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Ṯori aha/ gwo gom bway pini mo, ayy Tap̱a, ki aha/ mina ya e bway ganam pini mo. Kara dum pem mmoṯal ’de/ mo ki aha/ mina ḵo/ gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Aha/ c̱ina mo jin ’boruwa ’bor bwa i is ki /e mo, ayy Tap̱a Arumgimis pem mo, ka dum pemi ’baar mo, dhali aha/ mina kar gway pini ki ca ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Haali/ mo/en jin ṯelu sho’k mo tani a’di caaca ’kup̱ ki aha/ mo. /E ’cuḵkina ḵashiram pem ’peni moŋ’kulga/ ma Haawiya mo. ");
INSERT INTO udu_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Ayy Arumgimis, ’kwani kun ushi ’kwani ga/ uni cukin ap̱o/ aha/ mo, dhana tul ’kup̱ ’kwani kun maṯẖamaṯẖ mo tani simmki mondiki/em pem e mo, dhali uni ’koki kar /e ibwambori jis/em buni mo. ");
INSERT INTO udu_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Hili /e, ayy Tap̱a, /e tana Arumgimis jin miimii mo dhali mii mii ka ’the mo, /e maŋgala she/ ki maŋgal goma nyor mo, dhali mo/en pini jin ṯelu sho’k mo tani ishki’d mo dhali mii ma isiŋ gana/ si’da/ mo. ");
INSERT INTO udu_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Ṯuku/ mo e aha/ mo dhali bu’th mo jin hiluwa hil ka ’thime/ ki mo/en ap̱o/ aha/ mo. C̱iyu/ mo jin ’bidhu/ e is pini ki c̱iŋkinam pini mo, dhali tayi ya/ gi nyaranyc̱iŋkinam pini is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Ṯori aha/ jamas mii ma ’them pini mo, ki uni gwansan kun shi/ki aha/ i e mo mini p̱ar mii e mo tani dhali minu dhu ki mo ma ’the is mo haali/ /e, Tap̱a, woṯẖki aha/ mo dhali malas aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","E ’kuwosha turga/ jin ḵogu mo jin doshki’d mo jin ta ’peŋkuman bampam piti jin ḵa’bki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Tap̱a a’di enki ’twaŋkala goŋ ma Sihyuun mo, mmobola ris mo jin ’konu e pa ma Yakuub e mo. ");
INSERT INTO udu_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","To gi monyca a’di ṯorkunuwa ṯor gom /e mo, ayy ’peŋkuman bampa/ ma Arumgimis mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","E bwaman uni gwansan kun mishki aha/ mo tani aha/ ṯorkina aRahab eya tente/ mo dhali Pam Baabil mo. Hili mo mo ma, ’Kwani gi Pam P̱alasthiin dhali ’Kwani gi Pan Sur nyaḵki ’Kwani gi Paŋ Gale/ mo. Uni o gwo mo ki: Jan ’de/ yan dho’thkunu e mun mo. ");
INSERT INTO udu_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Dhali goma Sihyuun mo tani a’di minu o gwo ciki: Jan ’de/ yan dhali jan ’de/ c̱aan dho’thkunu eya yim mo. Haali/ a’di jin Caa e ki Ca ki is piti midi ṯela yim sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Tap̱a midi deŋa deŋ e mo me’d jin ’kwarkina a’di gway gi ’kwani mo ki: A’di ’de/ yan dho’thkunu imun mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Imanyuḵ gway dhali imansa gara/ o gwo mo ki: Aris mo jin kasha yi’dem pem e mo tani uni ’kon e /e mo. ");
INSERT INTO udu_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Ayy Tap̱a, Arumgimis pem, aha/ yuḵkina /e mmowoṯẖ aha/ montee mo. Aha/ gwokina mon’thiny ibwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Dhalki mon’thom pem p̱u’dki’d ibwambori /e mo, ḵa’di ’cem pini mmociḵ kom pem mo. ");
INSERT INTO udu_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Haali/ aḵashiram pem a’di ’tu’du/ mo ki monṯo’c bwa mo, dhali mondiki/em pem a’di ḵalkina mo mo mmo’disha Haawiya is mo. ");
INSERT INTO udu_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Aha/ deŋu e nyaḵki uni gwansan kun iikin ka luŋgu’b e jisa ’kulga/ mo. Aha/ tana wathi/ jin dar gi mom’bi’th mo, ");
INSERT INTO udu_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","dhali mmowa e ki a’di jin dhalkunu ’pen e bwaman jwa mo, dhali wa e ki wathi/ jin ’koshkunu mmo/ish e jis jwa mo, dhali wa e ki uni gwansan kun dina /e ki ka e doḵ/e mo, haali/ uni ’ciṯẖkunu ’twa/ mo ’peni me’d pini mo. ");
INSERT INTO udu_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","/E karki aha/ e jisa ’kulga/ mo, dhali e pa gi mondhurumi’d dhali moŋ’kulga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Anyor pini ishki’da p̱o/ aha/ ki diṯ diṯ mo, dhali /e kumki aha/ ’twa/a ’cesh ka ris mii gi lanthinem pini mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","/E ki raḵ uni gun nyaḵ ii ki aha/ mmogas aha/ mo. /E ki kar aha/ mmota to jin bulabul gom uni mo. Aha/ mu’thkunu ’twaŋkal e bwaman mo wakan ki aha/ mina mol ye mo. ");
INSERT INTO udu_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Em pem caki’d mo mmoḵala ’tum gom bwan diṯi’d mo. Isa yempa/ aha/ yuḵkina /e mo, ayy Tap̱a. Aha/ ṯe’dkina me’d pem gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","A/e mii miimer gom uni gun wukina? A/dhali kun iikin mo mini cu mis mo mmomaŋ /eya? Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","A/mo/en pini jin ṯelu sho’k bahu e jis jwa mowa? Walla dhali mo ma isiŋ ganam pini e mo jin kup̱u mowa? ");
INSERT INTO udu_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","A/momer pini mishu e mondhurumi’d mowa? Walla a/mo jin tana /e is ki me’d mmowoṯẖ ’kwani e mony’cesh jin dhaluwa dhal ’pen mishu mowa? ");
INSERT INTO udu_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Hili aha/, ayy Tap̱a, gwokina ’twa/ e /e mo. E mon’thamo/ a’thom pem yaki’di bwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Ayy Tap̱a, atinta ibiṯa /e aha/ asho kan mo? Atinta baga /e jis/em pini ’peni aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Mo jin jwakaṯkunuwa du mo dhali mowu ’dishki aha/ is mo ’pena tee jin taka/ dhuru’c mo, aha/ ’koshu is ka nyor goma purem pini mo. Aha/ dara gi mowoṯẖ mo. ");
INSERT INTO udu_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Anyor pini a’di dhi’thki aha/ sho’k mo. To jin ḵo/ka/ is ’peni /e uni bu’thkina bu’th mmo’ce’d aha/ sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Uni ’kamki aha/ is me’da gannu/ yi’de/ jin guski’d ka tee ’baar mo. Uni ’kamki aha/ ’kup̱ ki deḵi monṯal ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","/E ki raḵ uni gun eni aha/ dhali imugum pem mmogas aha/ mo. Imannyaḵ ’kom pem uni ’kon e mondhurumi’d mo. ");
INSERT INTO udu_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Aha/ mina yuḵ gway gom mo/en pini jin ṯelu sho’k mo, ayy Tap̱a, ki sule/ sule/ mo. Ki ’twa/ pem mo tani aha/ mina bah gwo gom mo ma isiŋ ganam pini eya risa nyaḵum yil gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Haali/ mo/en pini jin ṯelu sho’k mo tani a’di ṯelkunu ki sule/ sule/ mo. Mo ma isiŋ ganam pini a’di rwa’ckunu mo me’d momis mo. ");
INSERT INTO udu_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","/E ki o gwo mo ki: Aha/ gamkina gwo me’d ki jin ’dem pem jin kwanyka/ mo. Aha/ thulkina gwo me’da p̱o/ goma Dawuu’d jin ta c̱iŋkinam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Aha/ mina ṯel emen pini sho’k ki sule/ sule/ mo, dhali nyaŋa ḵursi ma maliḵ pini goma risa nyaḵum yil gi ’kwani mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Dhalki momis maŋ momer pini mo, ayy Tap̱a, dhali mo ma isiŋ ganam pini e dhana tul ’kup̱ gi ’kwani kun ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Haali/ kaja a’di jin di’d e momis gunn kun uḵu jin minu kar ka p̱ar nyaḵki Tap̱a mo? Kaja ibwaman uni gi momis jin wakina e ki Tap̱a mo? ");
INSERT INTO udu_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Arumgimis a’di jin ḵo/kunu eya dhana tul ’kup̱ gi ’kwanim piti kun ḵogu mo, a’di jin caaca mo dhali jin ta’da pure/ mo ap̱owa ris uni ’baar mo kun ’kamki a’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Ayy Tap̱a Arumgimis gi momis mo, kaja a’di jin ta jima dem dem me’d /e mo? ayy Tap̱a, nyaḵki mo ma isiŋ ganam pini jin ’kamki /e is mo. ");
INSERT INTO udu_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","/E jikina ji ap̱o/ yi’de/ jin birki bakal mo. Ki lanthinem pini jin cukina a’di mis mo tani /e doshki uni mo. ");
INSERT INTO udu_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","/E siri’ckina Rahab ap̱o/ ki sho’k mo me’d buŋgwar isa goŋgoro/ mo. /E ḵwa/ki ’kwani kun ta ’kup̱ ki /e ’twa/ mo ka bim pini jin c̱a’bki dem dem mo. ");
INSERT INTO udu_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Momis ta kum pini mo dhali mony’cesh si’da/ ta jim pini mo. Mony’cesh dhala ris to ’baar kun ’kon e a’di mo tani, /e ḵa’bki uni mo be. ");
INSERT INTO udu_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Abora bim poros dhali abora biny cam /e uḵki uni mo. Wosh ma Tabur dhali Wosh ma Harmuun uni ’kunykina bwa gom gway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","/E takin ga bim pini jin c̱a’bki dem dem mo. Me’d pini ’bitha’bi’th mo, me’da bim poros pini turatur mo. ");
INSERT INTO udu_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Mo ma ḵar/e dhali mo jin dhunuwa dhu ka p̱o/ uni ḵa’bkina ḵursi ma maliḵ pini mo dhali mo/en jin ṯelu sho’k mo dhali mii ma isiŋ ganam pini mo uni iikini bwambori /e mo. ");
INSERT INTO udu_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Mom’bor mii gom ’kwani kun mishi cuu mo e mo ma tul ’kup̱ jin yuḵuwa yuḵ mo, uni gun iikin mo, ayy Tap̱a, e moŋkush gi jis/em pini mo, ");
INSERT INTO udu_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","uni gun ’de’k gway isi mis gom gway pini ka tee ’baar mo, dhali kar mo ma ḵar/em pini ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Haali/ /e ta monyca gom mom’bi’th is buni mo. Ki mii ma ’them pini mo tani cem bam karkunu ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Haali/ agoŋgoro/ gi me’d bana mo tani a’di ta ji gi Tap̱a mo, amaliḵ bana mo tani a’di ta ji gi A’din ’De/ jin Ḵogu jin ta jima Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Haali/ ’pena dhamo/ mo tani /e ṯorki gwo ki tonyjan mo ki a’dim pinin ’de/ jin ta isiŋ gana/ mo dhali o a’di gwo mo ki: Aha/ karkina toŋ’kup̱ ’dolkon ap̱o/ jan ’de/ a’di jin c̱a’bki dem dem mo, dhali aha/ karkina a’di ki ca, a’din ṯal ’de/ yan jin kwanyu/ mo ’peni ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Aha/ gamkina Dawuu’d mo a’di jin ta c̱iŋkinam pem mo. Ka yin pem jin ḵogu mo tani aha/ ki ’koshki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Wakan me’d pem midi diya p̱o/ a’di ki sule/ sule/ mo. Abim pem si’da/ midi ’bi’th a’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Uni gun ta ’kup̱ ki a’di mo tani uni mini ’koki p̱i a’di e ki yuḵ mo. Uni gun ta thus ki thus mini ’koki kar a’di mo mmokar is ki gwa’d mo. ");
INSERT INTO udu_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Aha/ mina siri’c uni gun ta ’kup̱ ki a’di ki sho’k ibwambori a’di mo. dhali dher uni gwahan is bwa ka ’cesh mo uni gun shi/ki a’di i e mo. ");
INSERT INTO udu_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Mii ma isiŋ ganam pem dhali mo/en pem jin ṯelu sho’k mo tani uni mini nyaḵ ’ko ki a’di mo be, dhali ki gway pem mo tani cem piti minu kar ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Aha/ mina kar me’d piti ap̱o/ ḵumma/ yi’de/ mo dhali me’da bim poros piti ap̱o/ yi’de/ kun son mo. ");
INSERT INTO udu_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","A’di midi ’ther ko e aha/ mo dhali o gwo mo ki: /E tana Ababam pem mo, jin ta’da Arumgimis pem mo, dhali Wosh jin ta bway mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Dhali aha/ mina kar a’di mmota abwanyara/ mo, a’di jin eḵa/ eḵ mmobol imaliḵ gi mony’cesh e mo. ");
INSERT INTO udu_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Mo/en pem jin ṯelu sho’k mo tani aha/ mina karki a’di gom a’di ki sule/ sule/ mo. Dhali gwom pem jin gamka/ me’d mo midi dosh mmorwa’ckunu a’di gom a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Aha/ mina ṯel jil piti sho’k ki sule/ sule/ mo dhali aḵursi ma maliḵ piti mina e wa ka tee gi momis mo. ");
INSERT INTO udu_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Waḵki/ uc̱im piti mini dhal gwoŋḵan pem jin c̱inu ’pen mo dhali ’koki ii isi me’d gwoŋḵan kun onu mo tani, ");
INSERT INTO udu_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","dhali waḵki/ uni ki p̱uu gwoŋḵan pem kun bahu mo dhali ’koki dhu gwoŋḵan pem kun ’kwarkunu mo tani ");
INSERT INTO udu_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","yan’ko’d aha/ mina c̱i uni ajisa gom gwondhaŋ buni ki cwam pem mo dhali miinthus buni ki gulu’c jin miga/ dor uni mo. ");
INSERT INTO udu_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Hili aha/ mina joc̱ mo/en pem jin ṯelu sho’k ’peni a’di yisa, walla aha/ mina ta thus gom mii ma isiŋ ganam pem yisa. ");
INSERT INTO udu_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Aha/ mina diki p̱uu gwo jin gamka/ me’d mo walla aḵ gwo e mo jin piyi’d ’peni ’twam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Me’d ’de/ ki sule/ aha/ okina gwo isi ’baar mo mmothul gwo me’da p̱o/ gom mondhelel pem mo. Dhali aha/ mina diki ta aṯor goma Dawuu’d mo. ");
INSERT INTO udu_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Jil piti midi ’dim ’kup̱ ki sule/ sule/ mo, dhali aḵursi ma maliḵ piti midi di ki sule/ me’da tente/ ibwambori jis/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Me’da ppe mo tani a’di midi ṯel sho’k ki sule/ sule/ mo. A’di midi dosh ki morwa’c is mo ki momis ’kon mmo’dim ’kup̱ mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Hili shwane/ /e biṯkina biṯa sho mo dhali ruḵa/ ruḵ mo. /E ’tu’dkunu mo ka nyor ap̱o/ a’dim pini jin ’koshkunu ki monyca mo. ");
INSERT INTO udu_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","/E waṯki gwom pini jin gamu me’d mo gi c̱iŋkinam pini mo. /E ki shi/ toŋ’kup̱ piti is e bu’da’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","/E ki yu’d agoŋ piti mo. /E ki kar mom piti jin ṯenu gwo mmokup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Aris uni gwansan kun pekin mo uni dilki a’di to mo. A’di c̱ikunu gura/ ki imannyaḵ ’kom piti mo. ");
INSERT INTO udu_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","/E ki kar me’da bim poros gi a’di jin ta ’kup̱ ki a’di ki ca mo. /E ki dhuwa ris uni gun ta ’kup̱ ki a’di mmo’kuny bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Nye, /e ki doḵ shemen gandal piti jin kaaka ka nyaŋ’ko’d mo. Dhali /e diki kar a’di mmodosh mo e mo ma mee mo. ");
INSERT INTO udu_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","/E ki joc̱ cwa ma maliḵ ’peni me’d piti mo dhali /e ki biṯa ḵursi ma maliḵ piti a’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","/E ki kara teem piti ki kuṯ kuṯ mo ateem piti jin tana a’di dhuru’c mo. /E ki tash a’di is ki mo ma ’the is mo. Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Ki mo gi wakata, ayy Tap̱a, imina /e bag is pini ki sule/ sule/ kan mo? Ki mo gi wakata, imin ma nyor pini pur me’d o’d kan mo? ");
INSERT INTO udu_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Kayi gwo e mo ma, ayy Tap̱a, mondiki/e wana bar piti kata mo? Dina /e ki p̱ar e mom pini jin uḵa /e to di bwa ’te/ goma ris iya/ gi ’kwani mo? ");
INSERT INTO udu_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Wathi/ jana sa/ imidi di ki e mmodiki p̱ar wu e mo? Dhali kaja si’da/ imidi misha ḵashiram piti woṯẖ ’peni mom’bi’th ma Haawiya mo? Doshi ma dhali ’cunycuri yan mo. ");
INSERT INTO udu_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Tap̱a, mane mo/en pinin dhamo/ yin jin ṯelu sho’k mo, a’di jin tana /e isiŋ gana/ a’di jin thulkina /e aDawuu’d gwo me’da p̱o/ mo? ");
INSERT INTO udu_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Kayi gwo e mo ma, ayy Tap̱a, c̱iŋkinam pini c̱inu gura/ mo be. Kayi gwo e mo ma, ki aha/ ḵalkina asor gi ’kwani gwansan eya bor pem mo, ");
INSERT INTO udu_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","a’di jin ṯẖunykina ’kwani kun ta ’kup̱ ki /e ’twa/ is mo, ayy Tap̱a, a’di jin miikina uni ka maḵ mo, ŋaṯgin gi a’di jin ’koshkina /e ki monyca mo. ");
INSERT INTO udu_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Mom’bor mii gom Tap̱a ki sule/ sule/ mo. Amen dhali Amen. ");
INSERT INTO udu_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Tap̱a, /e taki jim bam jin ’kona am ’twa/i cine/ mo eya risa nyaḵum yil gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Nṯwa/a/ ka dhan wosha turga/ ’kokunu mmo’doyu/ ka pije/ mo, walla isi me’dyini jin uḵa /eya ’cesh dhali mony’cesh mo, ’peni mo jin ’konuki/e ki sule/ sule/ ya ye ’ba/ mo itan mo jin ’konuki/ e ki sule/ sule/ ya ye ’ba/ mo tani /e tana Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","/E ki ṯu’k wathi/ mmowar ki bu’da’cesh ka nyaŋ’ko’d doḵ/e mo dhali /e ki o gwo mo ki: Doḵku/ ka nyaŋ’ko’d mo, ayy uc̱i gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Haali/ yila alip̱ e jis/em pini mo tani ta toŋ kamuwa? Hili a’di wana e katili/ jin peki’d mo, walla a’di wana e ki mon’thiny jin timkunu mo mo. ");
INSERT INTO udu_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","/E ki dhi’th ’kwani sho’k mo dhali uni wakina e ki jan jin shu’bu/ mo, dhali wa e ka sho jin lu/kin mon’thamo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","E mon’thamo/ me’d jin lu/a a’di ki ṯup̱ ṯup̱ mo dhali a’di lu/u mo dhali mom’pimpili/ mo tani a’di uski’d ki jog mo dhali ḵu’th mo. ");
INSERT INTO udu_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Haali/ aman kup̱kunu ki ’ci’d’da/ ka nyor pini mo. Ka nyor pini mo tani aman kumkunu ’twa/a ’cesh ki kum jin ’boro’da? ");
INSERT INTO udu_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","/E ki kar tom bam jin ’coḵa’coḵ ibwambori /e mo. Miinthus bam kun miikina am ka ḵwal is mo dhukina /e e moŋkush gi bwam/em pini mo. ");
INSERT INTO udu_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Haala risa teem bami ’baar mo pekin mo e bwaŋ’kwariny ma nyor pini mo. Yil bam p̱u’dkin itagi ’pemen mo me’da shure/ jin daḵ ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Yil gi moŋ’koki/em bam a’di ta iss ’kwanimpa kwara i’ce’dka ’kume’d ap̱o/ mo, walla isi kani waḵki/ ’kup̱ gwo gom mom’bi’th is itagi iss ’kwanimpa doŋon mo tani hili naskina/ sur buni a’di di’di mmo’kosha ’kosh ki mii mo dhali monṯo’c bwa mo, dhali ki ’dishe/ mo tani uni pekin mo dhali aman p̱ekina mo. ");
INSERT INTO udu_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Kaja si’da/ imidi hil isi gwo i e goma nyor pini mo, dhali ka nyor pini isi ki gwo jin minu ḵo/ /e mo? ");
INSERT INTO udu_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Wakan ṯori aman gwo mo mmodeŋa teem bam e mo ki aman mina gama dum bam gi moyuḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Doḵu/ mo, ayy Tap̱a! Ki mo jin wakata imina /e idi mo? Hili ahil ki e ma ’thime/ gom c̱iŋkinam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Kap̱i amana dum bam ki mon’thamo/ ki mo/en pini jin ṯelu sho’k mo ki aman mina bwa ’kuny mo dhali ’bor bwa mo ka teem bam ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Dhuyi aman mmo’kuny bwa mo me’da tee ka ris mo me’da cim gunn kun dorkina /e aman mo dhali me’d yil ka ris me’d jin p̱arkina aman tonthus e mo. ");
INSERT INTO udu_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Dhalka ṯu’c pini a’di ṯoru eya tente/ e c̱iŋkinam pini mo, dhali monyca gi mom’bi’th pini e uc̱im buni mo. ");
INSERT INTO udu_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Dhalki mii ma ’the gi Tap̱a Arumgimis bam di’da p̱o/ aman mo, dhali ṯeli /e aṯu’c bam sho’k mo jin miina aman ki me’d bam mo, nye, aṯu’c jin miina aman ki me’d bam mo tani ṯeli /e a’di sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","A’di jin c̱a’bki’d eya darha’da/ gi a’di jin Caa e ki Ca mo, a’di jin c̱a’bki’d eya la gi a’di jin c̱a’bki dem dem mo, ");
INSERT INTO udu_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","midi o Tap̱a gwo mo ki: /E a’di ihurga/ jwa icine/ mo dhali /e tana cur pem jin ṯenu gwo mo, Arumgimis pem, e /e mo tani aha/ gamkina gwo is mo. ");
INSERT INTO udu_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Haali/ a’di midi ’cuḵ /e mo ’pena gume/ jin cesh ma mancesh to to mo dhali ’peni to jin wo’cki ’kwani is she/ mmowu mo. ");
INSERT INTO udu_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","A’di midi kum /e ’kup̱ ki thulas piti mo, dhali e bwaŋ’kwariny ma bim piti mo tani /e mini gam mo jin huru jwa mo. Mii ma isiŋ ganam piti a’di ta’da goŋgoro/ mo dhali p̱a’dal mo. ");
INSERT INTO udu_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","/E mini diki ḵo/ is gom mon’thiny jin midi miiya pure/ mo, walla athop̱a/ jin p̱eki’d montee mo, ");
INSERT INTO udu_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","walla to jin wo’cki is she/ jin parki’d mon’thiny mo, walla mo jin ’ce’du/ sho’k jin shi/ki’da shi/ is montee mo. ");
INSERT INTO udu_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Alip̱ ’kwani mini rasu/ e ’ko’d gwar pini mo, dhali alaap̱i ’kume’d mini rasu/ ka bim poros pini mo, hili a’di midi diki p̱u’du/ mmo’dish /e is mo. ");
INSERT INTO udu_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","/E mini hil ki jasi em pini mo dhali hil mo jin minu ri’c a’di jin ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Haali/ /e ki kar Tap̱a mmota jim pini jin hura /e jwa mo, a’di jin Caa e ki Ca mo jin ta mom pini jin c̱a’ba /e icine/ mo tani ");
INSERT INTO udu_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","tonthusa kamu/ midi diya mmop̱u’da p̱o/ /eya? walla mo jin doruwa dor midi ’dish /e is e gu’b burrinyem pini jin c̱a’ba /eya? ");
INSERT INTO udu_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Haali/ a’di midi hash iman’doyu gwom piti mo mmoḵan gwo gom /e mo dhali mmoji /e mo eya ris bway pini ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","E me’d buni mo tani uni mini ’de’k /e mo, isi ciki/ ki /e mina sho’k pini diki ṯorosh ap̱o/ wosh mo be. ");
INSERT INTO udu_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","/E mini yap̱a dhop̱a p̱o/ ki sho’k mo dhali tasha/ jin ta ga ṯi’di cine/ mo, dhali adhop̱ jin ta dhuru’c mo dhali tasha/ mo /e mini yap̱ uni ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Haali/ a’di koṯẖki aha/ me’d ki mo/en mo tani aha/ mina ’cuḵ a’di mo. Dhali aha/ mina cesh a’di ka p̱o/ mo haali/ a’di mishki gway pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ki a’di midi yuḵ aha/ mo tani aha/ mina yuḵ a’di ’twa/ mo, aha/ mina nyaḵ di ki a’di e mo jin ṯoju a’di bwa mo. Aha/ mina ’cwam a’di mo dhali taḵ a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ki mondiki/e jin tura ’ba/ ki tur mo tani aha/ mina kap̱ a’diya du mo, dhali ṯor a’di bway gi mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","A’di ’boro’d mmoc̱i mo jin ’boruwa ’bor bwa i is ki Tap̱a mo, mmoyuḵ gway mmomaŋ gway pini mo, ayy /e jin Caa e ki Ca mo, ");
INSERT INTO udu_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","mmobah gwo gom mo/en pini jin ṯelu sho’k mo mon’thamo/ mo, dhali mo ma isiŋ ganam pini mon’thiny mo, ");
INSERT INTO udu_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","dhali ki koŋ gway ma dheŋdhenye/ jin ’kon ma shu/i ’kume’d mo jin buḵu ki dar ga yi’c mo dhala dheŋdhenye/ mo, dhali ko jin lukum ma dheŋdhenye/ jin ’kon ma shu/i pesu/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Haali/ /e, ayy Tap̱a, /e karki aha/ mmo’kuny bwa ki ’kuny gom miim pini mo. Ki miin to ki me’d pini mo tani aha/ yuḵkina gway ki moŋ’kuny bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Dhan miim pini ’ka’da miiya, ayy Tap̱a. Gwom pini kun kuluma /e ibwa mo tani uni ’kula’kul mo. ");
INSERT INTO udu_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Wathi/ jin ta dholgon mo tani mol a’di mish ’ban mo, wathi/ jin ’kan ma ’kama janya/ mo tani a’di mol mish gwo yansan ’ban mo be. ");
INSERT INTO udu_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Ki ba a’di jin ta thus mo tani a’di ’ka’da le/ me’da sho mo dhali imanmii tonthusi ’baar mo lugkin ki ṯup̱ ṯup̱ mo tani uni ’birki ’kup̱ ki mo jin ’ce’du/ sho’k ki sule/ sule/ mo, ");
INSERT INTO udu_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","hili /e, ayy Tap̱a, /e a’di idikin e mo jin ḵapaṯa/ ḵapaṯ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Haali/, hili mo mo ma, ’kwani kun ta ’kup̱ ki /e mo, ayy Tap̱a, haali/, hili mo mo ma, ’kwani kun ta ’kup̱ ki /e mo tani uni minu ’ce’d sho’k mo. Aris imanmii tonthus mo tani minu c̱eker bwa mo be. ");
INSERT INTO udu_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Hili /e eḵki cem pem mo mmowa e ki ce ma almaŋa’th mo. /E ki wol aha/ ayin jin ta this ki this i is mo. ");
INSERT INTO udu_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Em pem p̱arki uni kun ta ’kup̱ ki aha/ e mo mmoṯa’k ka luŋgu’b mo. ’Cem pem ciḵki gwo gom mom’bir ’kup̱ ki ’kwani kun ta thus ki thus kun ṯẖa’th aha/ ki is mo. ");
INSERT INTO udu_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Uniŋ ḵar/e uni lugkin me’d cwanyjeṯẖkum mo dhali ca me’da bwanyayiis e Pan Lubnaan mo. ");
INSERT INTO udu_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Uni c̱u’thkunu mo e gu’b gi Tap̱a mo. Uni lugkin ki ṯup̱ ṯup̱ e gu’b ma pije/ jin di ’kup̱ ḵany ma Arumgimis bana mo. ");
INSERT INTO udu_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Uni ’kon naskina/ mmodho’th maman ka dhan buni kun tana uni mo. Uni ’tu’du/ mo ki sule/ ki yiman ki is buni mo dhali ishki dhii/ mo ");
INSERT INTO udu_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","mmoṯor eya tente/ ki Tap̱a a’di ta a’di jin ta’da ḵar/e mo, a’di jin ta wosh pem mo, dhali miiŋ kamu/ di’d e a’di yisa jin ush me’d mmonon a’di mmota ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Tap̱a a’di jiki’da ji mo. A’di hi’thkunu ki burrinye/ ma maliḵ mo. Tap̱a a’di hi’thkunu is ki burrinye/ mo. A’di ’kamkunu is ki mom’bi’th mo. Nye, mony’cesh a’di ṯelkunu sho’k mo. A’di molu joc̱ ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Ḵursi ma maliḵ pini a’di ṯelkunu sho’k mo ’peni kadhamo/ mo. /E idikin ’peni kadhamo/ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Agannu/ yi’de/ uni uluc̱kin ki mis mo, ayy Tap̱a, agannu/ yi’de/ uni uluc̱kin ki mis ki ’twam buni mo, agannu/ yi’de/ uni uluc̱kin ki mis ki ’twam buni jin gwokina uni aḵuku/ ḵuku/ mo. ");
INSERT INTO udu_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Mo ta gi mom’bi’th kagahara mmobol yi’de/ e jin alki is is ka ris mo, dhali mo ta gi mom’bi’th mmobol yi’de/ jin birki bakal e mo. Tap̱a jin diki’d e mo jin ḵa’dama/ ḵa’dam mo tani a’di c̱a’bki dem dem mo. ");
INSERT INTO udu_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Gwoŋḵan pini kun ’kawurkunu mo tani uni ’kon eya tente/ ki ’koŋ gana/ mo. Moŋḵo/ piti a’di gama gam gom gu’b pini mo, ayy Tap̱a, gom ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Ayy Tap̱a, /e tana Arumgimis jin ri’cki’da ri’c mo. /E tana Arumgimis jin ri’cki’da ri’c mo tani dhalki /e kushki mo mo. ");
INSERT INTO udu_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Cuyi mis mo, ayy /e jin tana Amandwall mony’cesh gwo mo. C̱iki uni gwahan kun dhu is ki ca tom buni kun ’dap̱a uni ki ’dap̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Ayy Tap̱a, ki mo gi wakata imina uni kun ta thus ki thus i’ko mo? Ki mo gi wakata imina uni kun ta thus ki thus ’ko mo mmop̱e ki bwaŋ ’kunyu’d mo? ");
INSERT INTO udu_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Uni wolki gwom p̱us buni kun dhunu uni ’ba/ ki ca ka pije/ mo, uni dhu ’ba/ ki ca mo, aris uni ’baar mo kun miiki tonthus mo. ");
INSERT INTO udu_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Uni siri’cki ’kwanim pini ap̱o/ ki sho’k mo, ayy Tap̱a, dhali wa’th mal pini i e mo. ");
INSERT INTO udu_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Uni ki ’kosh up̱a dhalla/ mo dhali uni kun ii ii yilkina/ mo, dhali ta iman’kosha mee ki ’kwani kun dar gi icom mo. ");
INSERT INTO udu_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Dhali uni ki o gwo mo ki: Tap̱a mishki toŋ kamu/ p̱ar eya? Arumgimis ma Yakuub a’di mish toŋ kamu/ nyiṯẖa/? ");
INSERT INTO udu_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Mishi gwo ’ban ma, ayy ’kwani kun ta dholgon ki dholgon mo. Um kun tana rwa/e/, ki um mini yuḵ kakasja mo? ");
INSERT INTO udu_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","A’di jin uḵki gu’ban’ce mo tani mina a’di diki ciḵ gwo mowa? A’di jin uḵki e mo tani mina a’di diki p̱ar mo e mowa? ");
INSERT INTO udu_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","A’di jin dorki kal gi ’kwaniny’cesh mo tani mina a’di diki dora dor garaa? A’di jin ṯorki ’kwani gwo mmonyiṯẖ to mo tani, ");
INSERT INTO udu_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Tap̱a a’di mishki to kun kuluma ’kwani ibwa mo, ki uni ta toŋ kamuwa? ayy jasa wulp̱e/ ’te/ mo. ");
INSERT INTO udu_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Mom’bor mii gom wathi/ a’di jin dorkina /e mo, ayy Tap̱a, dhali a’di jin ṯorkina /e gwo ’peni gwoŋḵan pini jin c̱inu mo, ");
INSERT INTO udu_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","mmoc̱i a’di isa haju/ ’pena teem piti jin ṯoju a’di bwa mo, ntagi jisa ’kulga/ minu c̱wany mo gom a’di jin ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Haali/ Tap̱a midi diki dhal ’kwanim piti ’pen mo. A’di midi diki dhal mal piti ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Mo jin dhunuwa dhu ka p̱o/ midi doḵu/ mo e mo jin ta’da ḵar/e mo, dhali aris uni ’baar mo kun dhelel ma du mo tani uni mini baṯẖ a’di isho’k mo be. ");
INSERT INTO udu_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Kaja a’di jin cu mis gom aha/ ap̱o/ uni kun ta thus ki thus mo? Kaja a’di jin doshki’d gom aha/ ap̱o/ imanmii tonthus mo? ");
INSERT INTO udu_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Waḵki/ Tap̱a midi diki ta manwoṯẖ pem mo tani aḵashiram pem ishunsan gana/ moyi midi c̱a’b ki shwamm e mony’cesh jin ’konu ki shwamm mo. ");
INSERT INTO udu_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Ki aha/ kulumkina gwo ibwa mo ki: Sho’k pem yereski’d mo tani mo/en pini jin ṯelu sho’k mo, ayy Tap̱a, a’di ibu’thki aha/ mmodosh mo be. ");
INSERT INTO udu_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Ki mo ma teṯe/ ma dum pem tana ris mo tani momalas pini uni ’kunykina ḵashiram pem bwa mo be. ");
INSERT INTO udu_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Mina itap̱a kun ta thus ki thus mish gwo gam me’d nyaḵki /e mo, uni kun thosonki gwoŋḵan kun bahu kun tanuwa pibi ka pibi mo? ");
INSERT INTO udu_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Uni ’tuntulki isi monṯal ’de/ ap̱o/ mondiki/e gi wathiŋ ḵar/e mo, dhali waḵ a’di jin di’d ka p̱o/ mmokar a’di mmowu mo. ");
INSERT INTO udu_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Hili Tap̱a a’di warki’d ka cur pem jin ṯenu gwo mo, dhali Arumgimis pem ta wosh pem jin hurga/ jwa mo. ");
INSERT INTO udu_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","A’di midi doḵki uni to i is mo gom miiny ’coḵgam buni mo dhali dhi’th uni sho’k ka pupush ’peni miim buni kun tana uni thus ki thus mo. Tap̱a Arumgimis bana midi dhi’th uni sho’k ka je’desh mo. ");
INSERT INTO udu_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ayy iiyu/ mo, dhalki ana yuḵa gway gom Tap̱a mo. Dhalki ana ’kunya bwa kagahara mmowol cuuwa/ gom wosh jin ta bway mowoṯẖ bana mo. ");
INSERT INTO udu_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Dhalki ana iiyina mo e buŋ’kus piti mo mmoc̱i mo jin ’boruwa ’bor bwa i is mo. Dhalki ana ’kunya bwa kagahara mmowol cuuwa/ nyaḵki gway jin maŋuwa maŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Haali/ Tap̱a a’di ta’da Arumgimis jin caaca mo, dhali a’di ita’da Maliḵ jin caaca ap̱owa risa rum p̱inycon mo. ");
INSERT INTO udu_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","E me’d piti mo tani moŋ’kulga/ gi mony’cesh ’kokin mo, dhali mo jin ḵa’dama/ ḵa’dam kun ta wosha turga/ si’da/ uni ta kum piti mo. ");
INSERT INTO udu_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Ḵumma/ yi’de/ uni ta kum piti mo, haali/ a’di i/uḵki uni mo, haali/ me’d piti a’di uḵki mony’cesh jin ḵuthaḵu’th mo. ");
INSERT INTO udu_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ayy iiyu/ mo, dhalki ana luŋa luŋ mo, dhali ’ko ki jiŋ ’kup̱a’dup̱un mo, dhalki ana raḵa is ka ’cesh ibwambori Tap̱a jin uḵki ana mo. ");
INSERT INTO udu_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Haali/ a’di ta’da Arumgimis bana mo, dhali ana tana ’kwani ma shon dhii/i’d piti mo, dhali ḵa’bal gi me’d piti mo. Ayy ka tee yan shwane/ mo ki um mini ’taki ciḵ ’twam piti moyi. ");
INSERT INTO udu_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Dhalka dum bum ki ’bi’th mo me’d mo jin yuḵu gway ka Mariiba mo me’da tee yan jin ta’da tee ma Massa e bwaasho mo, ");
INSERT INTO udu_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","ki ibabam bum palki aha/ mo dhali kar aha/ mmonyo/ mo, ba uni mishki miim pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ki yila issu/ mo tani aha/ jwakaṯkunuwa du mo gom ’kwani ma nyaḵum yil gwan mo, dhali o gwo mo ki: Uni ’kwani gwansan uni tan ma dum buni ṯẖuthu/ ki ṯẖuthu/ mo, dhali uni ’koki dhu gwo ki bway pem mo. ");
INSERT INTO udu_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Wakan aha/ thulkina gwo me’da p̱o/ ka nyor pem mo ki uni mini ’taki ’koki cic̱ mo e mo jin sinu is mo be. ");
INSERT INTO udu_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Ayy, yuḵi gway e Tap̱a gway jin ta jin this mo, yuḵi gway e Tap̱a mo aris ’kwaniny’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Yuḵi gway e Tap̱a mo, dhali ’bori gway piti mii mo, ṯori gwo gom bway mowoṯẖ piti ’pena tee itana tee mo. ");
INSERT INTO udu_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Bahi monycam piti e bwaman kal gi ’kwaniny’cesh mo, dhali miim piti kun miina a’di ki momer e bwaman ma ris ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Haali/ Tap̱a a’di caaca mo, dhali ki nyanye/ mo tani a’di iminu taḵ mo. A’di iminu ḵo/ mo ap̱owa risa rum p̱inyconi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Haali/ arisa rum p̱inycon gi ’kwani mo tani uni ta tomp̱inycon kun luŋa ’kwani mo. Hili Tap̱a a’di uḵki momis mo. ");
INSERT INTO udu_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Montaḵ dhali mo jin eḵa/ eḵ uni ’koni bwambori a’di mo, mom’bi’th dhali monyjarom piti uni ’kon e mom piti jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","C̱iki Tap̱a monyca mo, ayy um uc̱i gi ’kwani mo, c̱iki Tap̱a monyca mo dhali mom’bi’th is mo. ");
INSERT INTO udu_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","C̱iki Tap̱a monyca mo, a’di jin ’dap̱a gway piti ki ’dap̱ mo. Guyi to jin c̱inu mmo’ciṯẖ ’kus mo dhali iiyi e mom piti jin di ’kup̱ ḵany mo. ");
INSERT INTO udu_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Luŋi Tap̱a ki burrinye/ ma du jin hidhu ki hitha dhelelga/ mo. Dhali deeyi ki bir bir ibwambori a’di mo, aris ’kwani ’baar gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Oyi gwo e bwaman kal gi ’kwaniny’cesh mo ki: Tap̱a a’di ijiki’da ji mo. Nye, mony’cesh a’di ṯelkunu sho’k mo, dhali a’di molu joc̱ ki sule/ sule/ mo be. A’di midi dwall ’kwani gwo ki dar gi mii ma gwar ’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Dhalki momis ’kunya bwa mo dhali dhalki mony’cesh si’da/ ’kunyu bwa mo, dhali dhalki ḵumma/ yi’de/ si’da/ bir bakal mo dhali aris to gwansani ’baar mo kun ’tu’d a’di bwaman mo. ");
INSERT INTO udu_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Dhalki bwam mondhe’d yuḵ gway ki moŋ’kuny bwa mo dhali aris to ’baar mo kun ’kon e bwaman a’di mo. Yan’ko’d aris cwa ’baar mo gi bwanycwa mini yuḵ gway ki moŋ’kuny bwa mo ");
INSERT INTO udu_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","ibwambor gi Tap̱a mo, haali/ a’di p̱u’dki’d mo, haali/ a’di p̱u’dki’d mo mmodwall mony’cesh gwo mo. A’di midi dwall mony’cesh gwo ki mii ma ḵar/e mo dhali ’kwaniny’cesh ki gwoŋ ganam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Tap̱a a’di ijiki’da ji mo. Dhalki mony’cesh ’kunya bwa mo. Dhalka ris ’kwani kun ’kon e mony’cesh ki yanagap̱ ’kunya bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Araḵ dhali araḵ kun ’ceṯẖina ku’dum ki mondhurumi’d mo tani a’di ’kamki a’di is mo. Mo ma ḵar/e dhali mii ma ḵar/e uni ita moŋḵa’b ma ḵursi ma maliḵ piti mo. ");
INSERT INTO udu_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","O’d yayi’di bwambori a’di mo, dhali shwa jin minu shwa ’kup̱ piti ki o’d mo tani ’kamki a’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Awara sho’k piti a’di kushki mony’cesh mo mo. Mony’cesh p̱arki a’di e mo dhali dee ki bir bir mo. ");
INSERT INTO udu_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Dhan wosha turga/ uni wakin me’d mandha/ dham mo ibwambori Tap̱a mo, ibwambori Tap̱a gi mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Momis a’di bahki mo ma ḵar/em piti mo, dhali aris ’kwani ’baar mo p̱arki monycam piti e mo be. ");
INSERT INTO udu_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Aris uni ’baar mo kun luŋki tomp̱inycon mo tani uni dhunu ki mo ma ’the is mo, uni kun dhu ’bam buni ki ca mo gom to jin mol ha me’d jin ta tomp̱inycon mo. Arisa rum p̱inycon mini luŋ ki jiŋ ’kup̱a’dup̱uni bwambori a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Sihyuun ciḵki gwo mo tani dhali a’di ’kunya bwa mo, dhali i’bwa/ gi ’Kwani Yahuuda/ uni ’kunya bwa mo, haali/ gom gwon dwall pini jin toru gwo ’twa/a ’cesh mo, ayy Arumgimis. ");
INSERT INTO udu_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Haali/ /e, ayy Tap̱a, /e a’di icaaca ap̱o/ mony’ceshi ’baar mo, /e a’di ikarkunu ki ca ap̱owa risa rum p̱inyconi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Tap̱a a’di enki uni gwansan kun shi/ki tonthusi e mo. A’di ’tashki mondiki/e gi unim piti kun dhunu ki she/ ki dhelel dhelel ’twa/ ’peni tonthus mo. A’di ’cuḵki uni ’peni me’d gi uni kun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Moŋkush kushki mo mo gom uni kun miin ka ḵar/e mo, dhali moŋ’kuny bwa gom uni kun dhelel ma du mo. ");
INSERT INTO udu_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","’Kunyi bwa e Tap̱a mo, ayy uma ḵar/e mo, dhali c̱i a’di mo jin ’boruwa ’bor bwa i is gom a’di jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Ayy, yuḵi gway e Tap̱a gway jin ta jin this mo, haali/ a’di miiki dhan to ki momer mo. Me’da bim poros piti dhala bim piti jin ḵogu mo tani gamki a’di mo jin p̱inu mii e mo. ");
INSERT INTO udu_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Tap̱a a’di iṯorki mom piti jin p̱inu mii e eya tente/ mo, a’di ki pi mom piti jin yenuwa ye mo e jis/e gi kal gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","A’di ki ka mo/en piti jin ṯelu sho’k e mo dhali mii ma isiŋ ganam piti mo e gu’b ma Israyiil mo. Aris ’pemen gi mony’ceshi ’baar mo tani p̱arki a’di e mo, a’di jin ta mo jin p̱inu mii e ma Arumgimis bana mo. ");
INSERT INTO udu_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Ḵumi cuuwa/ gom bwaŋ ’kunyka/ e Tap̱a mo, aris ’kwaniny’ceshi ’baar mo. Ḵwaku/ ’twaŋkal gom moŋ’kuny bwa ki gway mo dhali yuḵi gway jin maŋuwa maŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Yuḵi gway jin maŋuwa maŋ e Tap̱a ka dheŋdhenye/ jin ’kon ma shu/i pesu/ mo, dhali ka dheŋdhenye/ jin ’kon ma shu/i pesu/ mo dhali ki koŋ gway jin lukumu mo. ");
INSERT INTO udu_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Ka risa poome/ jin p̱inu mo dhali ki kony ce jin p̱inu mo, ḵumi cuuwa/ gom bwaŋ ’kunyka/ ibwambor ma Maliḵ mo, a’di jin ta Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Dhalki ḵumma/ yi’de/ bir bakal mo, dhali aris to gwansan kun ’tu’dki a’di bwaman mo, mony’cesh dhali uni gwansan kun ’kokin e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Dhalka gannu/ yi’de/ tor me’d buni mo. Dhalka ris wosh yuḵ gway moŋ’kuny bwa imonṯal ’de/ mo ");
INSERT INTO udu_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","ibwambori Tap̱a mo, haali/ a’di midi p̱u’du/ mo mmoji mony’cesh mo be. A’di midi dwall ’kwaniny’cesh gwo ki mii ma ḵar/e mo dhali ’kwani ki dar gi mii ma gwar ’de/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Tap̱a a’di ijiki’da ji mo. Dhalki ’kwani deen ki bir bir mo. A’di c̱a’bki’d eya ḵursi ma Maliḵ eya p̱owa c̱arabiim mo. Dhalki mony’cesh theḵ she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Tap̱a a’di caaca eya Sihyuun mo. A’di ikarkunu ki ca ap̱owa ris ’kwani ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Dhalki ’kwani maŋ gway pini mo jin caaca mo dhala purem pini mo. A’di iḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Maliḵ a’di c̱a’bki dem dem mo, a’di jin enki mo ma ḵar/e mo. /E ṯelki mo jin daru gi mii ma dehe/ sho’k mo. /E ki tor gwowa bora ’cesh gom mii ma ḵar/e mo dhali mo ma ḵar/e goma Yakuub mo. ");
INSERT INTO udu_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Kari Tap̱a Arumgimis bana ki ca mo. Luŋi a’di e cwam piti jin dhuna a’di sho’k mo. A’di iḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Musa dhala Haruun uni ita kum piti ibwaman ma gasiis mo. Samu/iil si’da/ a’di ita jim piti e bwaman uni gwansan kun yuḵki gway piti mo. Uni ki ko ’twa/i Tap̱a mo tani dhali a’di ithoḵki uni gwo mo be. ");
INSERT INTO udu_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","A’di ṯorki uni gwo ka raḵ jin wana e ka ḵa’dum ki jamas piti mo. Uni dhuki gwonyc̱im piti mo, dhali gwoŋḵan piti kun bahu mo kun c̱ikina a’di uni mo. ");
INSERT INTO udu_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Ayy Tap̱a Arumgimis bam /e thoḵki uni ’twa/ mo. /E tana Arumgimis jin gwamki uni mo, hili /e ki ri’c uni gom tonthus buni jin thama uni mii mo. ");
INSERT INTO udu_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Kari Tap̱a Arumgimis bana ki ca mo, dhali luŋi a’di e ’kuwosha turgam piti jin ḵogu mo, haali/ Tap̱a Arumgimis bana mo tani a’di ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Ḵumi cuuwa/ ki moŋ’kuny bwa e Tap̱a mo, aris um ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Miiyi Tap̱a to ki bwaŋ ’kunyka/ mo. Iiyu/ i buŋ’kusi a’di ki gway ilu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Mishi mo mo ki a’di ta Tap̱a jin ta’da Arumgimis mo. A’di ta a’di jin uḵki ana mo dhali ana tana kum piti mo be. Ana tana ’kwanim piti mo dhali ana tana ḵa’bal ma shon dhii/i’d piti mo. ");
INSERT INTO udu_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Cic̱i e ’twaŋkal ma goŋ piti ki mo jin ’boruwa ’bor bwa i is mo, dhali e mom piti jin di ’kup̱ ḵany nyaḵki mo jin maŋuwa maŋ mo. C̱iyi a’di mo jin ’boruwa ’bor bwa i is mo, dhali ’bori gway piti mii mo. ");
INSERT INTO udu_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Haali/ Tap̱a a’di ’bora’bor mo. Mo/en piti jin ṯelu sho’k mo tani a’di ’dimki ’kup̱ ki sule/ sule/ mo, dhali mo ma isiŋ ganam piti eya risa nyaḵum yil ki ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Aha/ mina yuḵ gway ki yuḵa gayiin mo dhali ki mo ma ḵar/e mo. E /e mo tani ayy Tap̱a, aha/ mina yuḵ gway mo. ");
INSERT INTO udu_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Aha/ mina yip̱ ’kup̱ ki bway kun ’konu ki dar gi mii ’ba/ mo. Ayy, kakasja imina /e p̱u’du/ i aha/ mo? Aha/ mina ya ki dar gi ŋadhum eya dum pem e gu’b pem mo. ");
INSERT INTO udu_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Aha/ mina diki kar e bwambor jis/em pem mo, ma toŋ kamu/ jin ’coḵa’coḵ mo. Aha/ shina mii gi uni gwansani e mo kun ṯa’kkin ’peni bway gana/ mo. Uni mini ’koki thal aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Mo jin iinu ki c̱a’ckon eya du mo tani midi si’d ’peni aha/ mo. Tonthus miga/ mol mo be. ");
INSERT INTO udu_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","A’di jin thuthi’da mannyaḵ ’dish gu’b piti ’pen ka ḵwal is mo tani aha/ mina ’ce’d a’di sho’k mo. Wathi/ jin ’theḵ ’ba/ mmis dhali jin kar ’ba/ ki ca mo eya dum piti mo tani aha/ mina mish a’di ’dim ’kup̱ yisa. ");
INSERT INTO udu_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Aha/ mina hila hil ki mo/en ap̱o/ uni kun ta ku isiŋ gana/ e mony’cesh mo, ki uni mini nyaḵ ’ko ki aha/ mo be. A’di jin yaki’d e bway jin ’konu ki dar gi mii ’ba/ mo tani a’di imidi mii aha/ to mo be. ");
INSERT INTO udu_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Wathiŋ kamu/ jin boṯo’d ki mo ma he’k e isa yempa/ mo tani a’di midi c̱a’bi gu’b pem yisa. Wathiŋ kamu/ jin baha’da ṯor ka yempa/ mo tani a’di mol ṯikir c̱a’b e buŋ’kus pem mo be. ");
INSERT INTO udu_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Mon’thamo/ itan mon’thamo/ mo tani aha/ mina ’ce’d uni sho’k mo, aris uni kun ta thus ki thus kun ’kon e mony’cesh mo, mmo’ciṯẖa ris tonthusi ’baar mo kun miina imanmii uni mo ’peni ’peŋkuman bampa/ gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Ciḵi mon’thom pem mo ma, ayy Tap̱a. Dhalki kom pem p̱u’dki’di /e mo. ");
INSERT INTO udu_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Dhalku/ ki bag jis/em pini ’peni aha/ mo ka teem pem jin ta’da c̱is ki c̱is mo. Ḵa’di ’cem pini ki aha/ mo. Thoḵi aha/ ’twa/ ishunsan gana/ ka tee jin yuḵkika/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Haala teem pem a’di peki’d mo me’da ku’d jin ’ciṯẖki ’pen mo dhala simam pem burkin mmowa e ki mo ma gwaṯa/ jin ’thanu o’d jin ’batha’ba’th mo. ");
INSERT INTO udu_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Adum pem dorkunu mmowa e ka sho mo dhali ḵu’thki’d mo. Aha/ ŋakina tonṯem pem mmoshwa mo. ");
INSERT INTO udu_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Haali/ gom dhan mo/ohon pem caaca mo tani asimam pem thalkina buŋgwar is pem mo. ");
INSERT INTO udu_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Aha/ wakina e ki koro/ gi mombwaasho mo, aha/ wana e ka kunu/ jin diki’d e bwam ma’du/ mo. ");
INSERT INTO udu_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Aha/ isha ki e i’kup̱ ki walwal mo, aha/ wana e ki ’dii jin di a’din ’deŋ gana/ ap̱o/ ’kuŋgu’b mo. ");
INSERT INTO udu_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Ka tee ’baar mo ’kwani kun ta ’kup̱ ki aha/ ṯẖunyki aha/ ’twa/ i is ki uni gwansan kun p̱e’th aha/ ki p̱etha sor mmokar gway pem ki mo jin jeenuwa jee mo. ");
INSERT INTO udu_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Aha/ shwakina jasi ’piny me’d tonṯe/ mo, dhali ce jabu’th pem e ki to jin p̱ika/ mo ");
INSERT INTO udu_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","goma nyor jin deḵkina /e mo dhala nyor pini mo. Haali/ /e ḵalki aha/ imis mo dhali biṯ aha/ asho mo. ");
INSERT INTO udu_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Ateem pem wana e ka ḵashira/ ma tente/ gi mom’pimpili/ mo. Aha/ ḵu’thkina me’da sho mo. ");
INSERT INTO udu_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Hili /e, ayy Tap̱a, dikin e ḵursi ma maliḵ ki sule/ sule/ mo. Gway pini a’di ’dim ’kup̱ eya risa nyaḵum yil gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","/E mini cu mis mo dhali tayi gi mo/en ma ’thime/ ap̱owa Sihyuun mo. A’di ta’da tente/ jin minu mii mii ka ’the goma yim mo. Atente/ jin karu ’pen ka pije/ a’di p̱u’dki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Haali/ c̱iŋkinam pini uni bu’thki wosh ma yim ji gi ŋa/u mo, dhali hila hil ki mo/en ap̱o/ bu’da’cesh ma yim mo. ");
INSERT INTO udu_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Kal gi ’kwaniny’cesh uni mini ḵo/ gway gi Tap̱a mo, dhali aris imaliḵ gi mony’cesh mo uni mini ḵo/ monycam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Haali/ Tap̱a midi nyaŋa Sihyuun ki mis ka nyaŋ’ko’d mo, a’di midi piyu/ ki monycam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","A’di midi c̱iya hirdhe/ ki mon’tho gi uni kun dhalkunu ’pen mo, dhali a’di midi diki waḵ uni gom tom buni kun ’thona uni ka di’b is mo. ");
INSERT INTO udu_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Dhalki gwo yansan a’di ’kwarkunu isa ’cesh goma nyaḵum yil gi ’kwani kun mini iiyu/ i’ko’d mo, wakan ki ’kwani kun ’konuki dho’th naskina/ mo uni a’di imini maŋ Tap̱a mo, ");
INSERT INTO udu_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","haali/ a’di hilki mo ka luŋgu’b ’peni mom piti jin ḵogu mo jin ḵa’dama/ ḵa’dam mo, ’peni momis mo tani Tap̱a hilki mo ap̱owa ’cesh mo ");
INSERT INTO udu_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","mmociḵ ohon gi uni kun tana habuus mo, mmo’cuḵ uni gwansan kun ’birki ’kup̱ ki jwa mo, ");
INSERT INTO udu_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","ki ’kwani mini bah gwo eya tente/ eya Sihyuun mo a’di jin ta gway gi Tap̱a mo, dhali e Pa Urushaliim mo tani uni mini bah gwo maŋ piti mo, ");
INSERT INTO udu_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","ki ’kwani mini tul isi monṯal ’de/ mo dhali aris ’peŋkuman bampa/ mo mmoluŋ Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","A’di ’ce’dki mom’bi’th pem bwa mo e bwaman yam pem mo. A’di karki’da teem pem mmokuṯa/ kuṯ mo. ");
INSERT INTO udu_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Ayy Arumgimis pem, aha/ ona gwo mo ki: Dhalku/ ki bu’th aha/ ’peni mahan mo e bwaman ma teem pem mo, /e jin ’dimkina yil ’kup̱ mo eya risa nyaḵum yil gi ’kwaniny’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","’Peni kadhamo/ mo tani /e ’thiki moŋḵa’b gi mony’cesh mo, dhali momis a’di ta mii ki me’d pini mo. ");
INSERT INTO udu_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Uni mini ’ce’d sho’k mo tani hili /e a’di imini ’dim ’kup̱ mo, uni ’baar mo mini wuwa dhagale/ mo me’d burrinye/ jin hidhu i is mo. /E aḵ uni e me’d burrinye/ jin hidhu i is mo dhali uni pekin mo, ");
INSERT INTO udu_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","hili /e ta a’di ma ’de/ mo, dhali yil pini mol di ’kup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Uc̱i gi c̱iŋkinam pini uni mini ’ko ki ’dantar mo. Nyemes gi uc̱im buni ki uni mini dho’th i’ko’d mo tani uni iminu ṯel shoki bwambori /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","’Bori Tap̱a mii mo, ayy ḵashiram pem, dhali aris to gwan ’baar mo kun ’kon e aha/ mo, ’bori gway piti mii jin ḵogu mo. ");
INSERT INTO udu_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","’Bori Tap̱a mii mo, ayy ḵashiram pem mo, dhali dhalku/ ki ŋa a’dim piti jin ’dap̱a ’dap̱ mo, ");
INSERT INTO udu_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","a’di jin gwamki /e ’pena ris miim pini kun ’coḵa’coḵ mo, a’di jin wac̱ki /e ’pena ris ’ba’th pini mo, ");
INSERT INTO udu_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","a’di jin wanki /e ’ba/ ’peni jisa ’kulga/ mo, a’di jin shumki /e ki toŋ’kup̱ ki mo/en jin ṯelu sho’k mo dhali ki momiimii mo, ");
INSERT INTO udu_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","a’di jin kap̱ki /eya du mo ki tom ’boron me’d jin dikina /e ki e mo, wakan dhuru’c pini jin tana /e midi ’ka gura/ me’da biny jeshe/ ma wulu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Tap̱a a’di miiki mii jin yenuwa ye mo dhali mo ma ḵar/e goma ris uni gwansan kun siri’ckunu ap̱o/ ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Bway piti ṯora a’di eya tente/ ka Musa mo, dhali miim piti jin ḵala a’di e ’Kwani ma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Tap̱a a’di ta’da manmiimii mo dhali mii jin miinu ka ’the mo, anyor piti maŋgala she/ mo dhali mo/en jin ṯelu sho’k ishki’d ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","A’di isa yempa/ diki ḵucura ḵucur mo, walla a’di diki kara nyor piti ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","A’di diki ṯu/ul ana isi ki gwo gi miinthus bana mo, walla ri’c ana isi ki gwo gom tony ’coḵgam bana kun miina ana mo. ");
INSERT INTO udu_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Haali/ me’d momis jin ḵa’dama/ ḵa’dam ap̱o/ mony’cesh mo tani wakan dhan mo/en piti jin ṯelu sho’k caaca mo ’kup̱ki uni gwansan kun ḵo/ki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Me’d jin si’da mom’pesho’k ki si’d ’pena bora luŋgu’b mo tani isa dhana/ kan si’da/ a’di ki joc̱ gwondhaŋ bana ’peni ana mo. ");
INSERT INTO udu_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Me’da baba jin hilki ya/ ki mo/en mo tani wakan si’da/ Tap̱a ki hil uni gwansan kun ḵo/ki a’di ki mo/en mo. ");
INSERT INTO udu_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Haali/ a’di mishki’da yi’c bana mo, dhali a’di kaki gwo e ki ana tana bu’da’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Wathi/, ateem piti a’di wana e ka sho mo. A’di lugki’d ki ṯup̱ ṯup̱ mo me’d jandin to e bwam bunto mo, ");
INSERT INTO udu_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","haali/ ’tham poshki’d ap̱o/ a’di mo dhali a’di ki ’cwar a’di mo, dhali mom piti mishi a’di doḵ/e yisa. ");
INSERT INTO udu_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Hili mo/en gi Tap̱a a’di ṯelkunu sho’k mo ’peni mo jin ’konuki/e ki sule/ ya ye ’ba/ mo itan mo jin ’konuki/e ki sule/ ya ye ’ba/ mo ap̱o/ uni gwansan kun ḵo/ki a’di mo, dhali mo ma ḵar/em piti e uc̱i gi uc̱im buni mo, ");
INSERT INTO udu_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","e uni gwansan kun dhuki gwom piti jin gamu me’d mo, dhali ka uni e mo mmomii gwoŋḵan piti kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Tap̱a a’di ṯelki’da ḵursi ma maliḵ piti sho’k e momis mo, dhali ’peŋkuman bampam piti jiki’da ji ap̱owa ris to ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","’Bori Tap̱a mii mo, ayy um iman’doyu gwom piti mo, um kun c̱a’bki dem dem mo kun mii gwom piti mo, mmociḵ ’twa/ gi gwom piti mo. ");
INSERT INTO udu_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","’Bori Tap̱a mii mo, aris umi ’baar mo kun ta kum piti kun ’kon e momis mo, imanmii tom piti mo kun mii bwam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","’Bori Tap̱a mii mo, aris to kun miina a’di mo, eya ris mo ’baar mo kun ta mom piti kun tana a’di tap̱a mo. ’Bori Tap̱a mii mo, ayy ḵashiram pem mo. ");
INSERT INTO udu_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","’Bori Tap̱a mii mo, ayy ḵashiram pem mo, ayy Tap̱a Arumgimis pem, /e a’di icaaca kagahara mo. /E hi’thkunu ki montaḵ mo dhali mo/eḵ mo, ");
INSERT INTO udu_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","/e jin ’kamki is pini ki moŋkush me’d burrinye/ jin ’kamu is mo, /e jin bele’thki momis me’d gu’b burrinye/ mo, ");
INSERT INTO udu_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","/e jin ’thikina ḵa’dum gi gu’b pini ap̱owa ris yi’de/ ’baar mo, /e jin dhukina raḵ me’d arabiyya jin dira shumarum pini mo, /e jin merkina p̱owa bi gi ’tham mo, ");
INSERT INTO udu_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","/e jin dhuki ’tham ka ris mmota iman/ii gom /e mo, o’d dhala le’dan o’d jin shwa’d ki bar bar mo tani uni mii /e to mo. ");
INSERT INTO udu_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","/E ki kar mony’cesh e moŋḵa’b piti mo, wakan ki a’di minu ’koki yiḵin is ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","/E ki kum a’di ’kup̱ ki moŋ’kulga/ me’d burrinye/ jin kumu to ’kup̱ mo. Dhali yi’de/ doshki’da p̱owa ris wosha turga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Ki gwom pini jin ḵucurkina /e uni mo tani uni sokin mo. Dhali ki kon dor ma sho’k pini mo tani uni yakina ŋwac̱a/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Aris wosha turga/ cuki mis mo, dhali embul wosh mo tani uni cic̱kin ka ’cesh mo e mo jin karkina /e ’pen ka pije/ gom uni mo. ");
INSERT INTO udu_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","/E ki kar gwayu/ mo ki uni mini ’koki pe mo, wakan ki uni mini ’taki ’koki halas mony’cesh doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","/E ki dhu yi’de/ kun ’du’dun mmogac̱ ka pije/ e embul wosh mo. Uni yakina ŋwac̱a/ e embul ma ris wosh mo. ");
INSERT INTO udu_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Dhali uni ’baar mo p̱ikina to/e ’baar mo kun ’kon e bwaasho mo. Thuluny bwaasho si’da/ uni kap̱kin ’peni mo jin budha yi’de/ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Ki uni mo tani ’dii kun p̱eni momis mo tani gamki moŋ’kom buni mo. Uni wolki gway e bwaman ma risa biny cwa mo. ");
INSERT INTO udu_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","’Peni monyc̱a’b pini jin dina /eya ’ta’dama mo tani /e wolki yi’de/ ap̱o/ wosha turga/ mo. Mony’cesh a’di kap̱kunuwa du ki maman miin to ki me’d pini mo. ");
INSERT INTO udu_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","/E raḵkina sho ca’d gom to/e mo, dhali dhu emen to jin mina ’kwani si mo, ki a’di midi dho’th maman tonṯe/ ’peni mony’cesh mo, ");
INSERT INTO udu_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","dhali yimana mura’th jin ḵa/u ki ŋah ŋah mmo’kunya duŋ ’kwani mo, dhala yin mmokar bwam/em piti ki ’tikil ’tikil mo, dhali tonṯe/ mmo’bi’th ’kwani adu mo. ");
INSERT INTO udu_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Aris cwa gi Tap̱a uni wolu yi’de/ ka enthus mo, dhali arisa bwanyayiis gi Pan Lubnaan jin sikina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","E uni mo tani ’dii nyaŋki gu’b buni mo, dhala gwamp̱i/ taki’d ki gu’b piti ap̱o/ cwa jin wana e ka ṯup̱ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Dhali aris wosha turga/ mo tani uni gom mi kun ’koni bwaasho mo, dhali wosh uni ta mo jin hur ma warriny jwa icine/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","/E ki kara ppe mmoya yil mo, dhali atente/ mishi mom piti jin mina a’di iyul mo. ");
INSERT INTO udu_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","/E ki kar mondhurumi’d mo dhali a’di ta ji mon’thiny mo, ka ris to/e ’baar mo kun ’kon e mombwaasho mo tani parkina ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Ushi dhuruca dhop̱ uni aŋkarki ko mo gom tom buni kun ’kwarkina uni ka gwap̱i/ mo, mmosimm tonṯem buni e mo ’peni Arumgimis mo. ");
INSERT INTO udu_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Ka tente/ sulki’d mo tani uni sokin ’pena tente/ mo dhali bag is buni e jurum wosh mo. ");
INSERT INTO udu_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Dhali wathi/ yaki’d mmomiiya ṯu’c mo dhali a’di ki miiya ṯu’c piti ntagi mom’pimpili/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Ayy Tap̱a, mii gi me’d pini wan ma p̱o/ e diṯa/. E moyuḵ mo tani /e uḵki uni ’baar mo. Aris mony’cesh ’tu’dkunu ki tom pini kun uḵkina /e mo. ");
INSERT INTO udu_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Bwamp̱o/ ḵumma/ yi’deŋ ’kulga/ mo kun caaca mo dhali kun beena bwa ki bee mo, a’di jin ishkina to/e ki mus mus ibwaman kun uḵu mo kun molu deŋ e mo, kun ’kon ki e mo nyaḵki kun gwa’da is mo dhali kun caaca mo. ");
INSERT INTO udu_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Dhali arisa ḵur yi’de/ si’da/ hashkina p̱o/ a’di mo dhala dhan to yi’de/ a’di jin uḵkina /e mmoguwa ŋalbothoŋ ibwaman a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Aris to gwansani ’baar mo hil ’kup̱ki /e mo, dhali /e c̱iki uni tonṯem buni mmoshwa ka tentem buni ki she/ ki she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Ki /e ki c̱iki uni to mo tani uni tulki a’di isi monṯal ’de/ mo. Ki /e ḵa’dki me’d pini mo tani uni ’tu’dkunu ki tom ’borga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ki /e bagki jis/em pini mo tani uni biṯkina bwa ka luŋgu’b mo. Ki /e ki bu’th shi/in buni mo tani uni wukin mo dhali doḵ ka nyaŋ’ko’d e bu’da’cesh buni mo. ");
INSERT INTO udu_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Ki /e hashki Shi/in pini mo tani uni uḵkunu mo be dhali /e ki ta bwam/e gi mony’cesh this mo doḵ/e mo. ");
INSERT INTO udu_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Dhalki monyca gi Tap̱a a’di i’dim ’kup̱ ki sule/ sule/ mo. Dhalki Tap̱a ’kunya bwa e miim piti mo, ");
INSERT INTO udu_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","a’di jin hilki mo ap̱o/ mony’cesh mo dhali a’di deeki’d ki bir bir mo, a’di jin taki wosha turga/ is ki me’d mo dhali uni yakina ku’d mo. ");
INSERT INTO udu_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Aha/ mina yuḵ gway e Tap̱a mo me’d jin dika/ ki e mo. Aha/ mina yuḵ gway mmomaŋa Arumgimis pem mo me’d jin kusha buye/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Dhalki gwom pem jin kulum aha/ ibwa mo tani ’bor a’di bwa mo, haali/ aha/ ’kunya bwa e Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Dhalki imanmii miinthus ṯushunkunu ki o’d ’peni mony’cesh mo, dhali dhalki imanmii to kun ’coḵa’coḵ mini mii dhalku/ ki ’ko mo doḵ/e. ’Bori Tap̱a mii mo ma, ayy ḵashiram pem. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Ayy c̱iyi mo jin ’boruwa ’bor bwa i is ki Tap̱a mo, dhali yuḵi gway piti mo. Kari eya tente/ mii gi tom piti e bwaman ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Yuḵi gway e a’di mo, yuḵi gway mmomaŋ a’di mo, ṯori aris to kun miina a’di ki momer mo. ");
INSERT INTO udu_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Cayi mo e gway piti jin ḵogu mo. Dhalka du gi uni gwansan kun simmki Tap̱a e mo tani ’kunya bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Simmi Tap̱a e mo dhali mom’bi’th piti mo, simmi buŋ’kus piti e ki ṯikir ṯikir mo. ");
INSERT INTO udu_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Kayi momer piti e jin miikina a’di mo, a’di jin ta miimer piti mo dhali gwon dwall kun toru ’twa/a ’cesh jin bahkina a’di mo, ");
INSERT INTO udu_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","ayy emen ma Ibrahiim jin ta c̱iŋkinam piti mo, um kun ta iya/ ma Yakuub mo, kun ta kum piti kun kwanykina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","A’di ta Tap̱a ma Arumgimis bana mo. Gwon dwall piti kun toru gwo ’twa/a ’cesh mo tani a’di idiki’da p̱owa ris mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","A’di tana bwam piti pa ki pa gom gwom piti jin gama a’di me’d ki sule/ sule/ mo, gom gwom piti jin ḵankina a’diya ḵan goma alip̱ ma risa nyaḵum yil ’kwani mo, ");
INSERT INTO udu_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","gwo jin gamkina a’di me’d nyaḵka Ibrahiim mo, dhali gwom piti jin thulkina a’di me’da p̱o/ mmo/o is goma Is/hak mo, ");
INSERT INTO udu_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","a’di jin rwa’ckina a’di eya Yakuub mo me’d gwoŋḵan jin bahu mo, dhali eya Israyiil me’d gwoŋḵan yan jin gamu me’d mo jin midi di ki sule/ sule/ mo, ");
INSERT INTO udu_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","mmo/o gwo mo ki: E um mo tani aha/ mina c̱i um mony’cesh gi Paŋ Kanaan mo mmota a’di jin mina umi ’tuntul bwa ime’d mo mmota mal bum mo. ");
INSERT INTO udu_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Ki uni ’kon ki daḵa/ ka ris buni mo, ki uni ta jasi ara ushalaŋ gana/ mo, ki iimpem buni e a’di mo, ");
INSERT INTO udu_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","mmo/iikina uni ki ii ma c̱a/ ’peni kal gi ’kwaniny’cesh mmotan kal gi ’kwaniny’cesh mo, ’peni bampa/ gi ’peŋkuman bampaŋ kamu/ itagi ’kwanin tiya mo, ");
INSERT INTO udu_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","a’di diki dhal jan ’deŋ kamu/ bway mo mmosiri’c uni ap̱o/ ki sho’k mo. A’di ḵucurki imaliḵ gom gway buni mo ");
INSERT INTO udu_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","mmo/o gwo mo ki: Dhalku/ ki ta unim pem kun kwanyka/ is ki me’d mo, dhalku/ ki mii to shi/ka/ ap̱o/ imanc̱i gwom pem mo. ");
INSERT INTO udu_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Ki a’di yuḵki ṯe/ ap̱o/ mony’cesh mo, dhali ’ce’da ris tonṯe/ ’baar mo kun miinu ime’d mo, ");
INSERT INTO udu_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","a’di ki hash wathi/ mmoya iṯwa/a/ ki uni mo, a’di jin ta’da Yuusup̱ mo, a’di jin yolkunu mmota c̱iŋkina/ mo. ");
INSERT INTO udu_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","’Basho’k piti a’di shi/kunu ka maḵḵiyya mo, dhali ’ba/ piti a’di re’dkunu ka dhan neran toŋḵuthu’d mo ");
INSERT INTO udu_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","ntagi gwo jin ona a’di mo p̱u’dki’d mo ki jim pe mo dhali gwo gi Tap̱a nyo/ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Dhala maliḵ hashki’da hash mo dhali ’cuḵ a’di mo be, dhali tap̱a gi ’kwani mo tani karki a’di ki ’kus mo, ");
INSERT INTO udu_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","dhali a’di ki kar a’di ki ari tap̱a ap̱o/ gu’b piti mo, dhali kar a’di ki tap̱a ap̱owa ris tom piti ’baar kun tana a’di mo, ");
INSERT INTO udu_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","mmoye’th uni kun ta iya/ ma maliḵ piti sho’k ki bwam ’boro’d piti mo, dhali mmoṯor ’kwani gwanyjaḵam piti gwo ki moyuḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Dhali yan’ko’d Israyiil p̱u’dki’d e Pam Masir mo, dhala Yakuub p̱u’dki’d ki yaŋ’kus eya ’cesh ma Haam mo. ");
INSERT INTO udu_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Dhali Tap̱a ki dhu ’kwanim piti mmota uni kun dho’th maman gi dho’th gana/ mo, dhali mmodhu uni mmota ’kwani kun ’bitha’bi’th mo mmobol ’kwaniŋ ’kup̱ buni e mo. ");
INSERT INTO udu_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","A’di ki ṯuka dum buni mmoshi/ ’kwanim piti i e mo, mmoṯu/ul nyaḵki uni mmoheka ris c̱iŋkinam piti e mo. ");
INSERT INTO udu_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","A’di ki hasha Musa jin ta c̱iŋkinam piti mo, dhala Haruun jin kwanykina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Uni wagaskunu jamas miim piti e bwam uni mo, dhali miimer kun miikunu e bampa/ ma Haam mo. ");
INSERT INTO udu_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","A’di hashki mondhurumi’d mo, dhali ’ceṯẖ bampa/ ’tum mo. Dhali uni pishki is ka le’da p̱o/ gwom piti mo. ");
INSERT INTO udu_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","A’di ṯu’kki ḵumma/ yi’dem buni mmota bas mo, dhali raḵ wa’c buni isi jwa mo. ");
INSERT INTO udu_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Bampam buni tashkunu ka buhany ma ’dwa/ mo, wakan si’da/ e gu’b gi imaliḵ buni mo. ");
INSERT INTO udu_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","A’di oki gwo mo dhali abuhanya ḵanthi/ p̱u’dki’d mo, dhali arisa shokom ṯẖa’thkin e bampam buni ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","A’di c̱i uni dhana wasa/ mmohe’th me’da sho’k mo, dhala wara/ sho’k yan jin dhwa/a’dki mo ki dhwa/a’d dhwa/a’d e bampam buni ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","A’di ’koshki cwalman ma mura’th buni mo dhala ris cwam p̱u/ mo, dhali a’di ḵwa/ki cwa gi bampam buni ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","A’di oki gwo mo dhala kuyu/ p̱u’dkin mo, dhali ushi emena kuyu/ kun molu deŋ e mo, ");
INSERT INTO udu_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","uni kun loskina ris to kun sinu ki ’kolo’c e bampam buni mo, dhali uni ki shwa maman cwam buni ’pena ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","A’di ki ’kosha ris bwanyaram buni ’peni bampam buni mo, a’di jin gac̱ki’di ṯwa/a/ ’peni mom’bi’th buni mo. ");
INSERT INTO udu_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Yan’ko’d a’di ki shuwa Israyiil bway ki ’dolkon kush mo dhali ’dolkon gana/ mo, dhali jan ṯal ’deŋ kamu/ p̱iyi’d e bwaman ma waḵ piti mo jin kolkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","’Kwani gi Pam Masir ’bora bwa ki ’bor ki uni iikin mo, haali/ dhan to jin ḵo/ uni is ’peni ’Kwani ma Israyiil mo tani p̱u’dki’da p̱o/ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","A’di ki p̱a’da raḵ mmokuma kum ’kup̱ mo, dhali o’d mmoc̱i moŋkush mon’thiny mo. ");
INSERT INTO udu_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Uni doṯki to mo dhali Arumgimis ki c̱i uni aris ḵusskun mo, dhali a’di ki c̱i uni tonṯe/ ’peni momis jin ishki’d ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","A’di ḵa’dki wosh ’twa/ mo dhali yi’de/ gac̱ki’d ka pije/ mo. A’di guski’d e bwam ma si’b me’d yi’de/ jin guski’d e bwam wor mo. ");
INSERT INTO udu_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Haali/ a’di kaki gwom piti e jin ona a’di is jin ḵogu mo, dhala Ibrahiim jin ta c̱iŋkinam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Wakan a’di suski ’kwanim piti ka pije/ ki moŋ’kuny bwa mo, unim piti kun kwanykina a’di mmo/ii gwayi lu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","A’di ki c̱i uni kal gi bampa/ gi ’kwanin tiya mo, dhali uni bu’thki to gi ’kwanin tiya kun tana uni gi maman buni kun miikina uni to mo, ");
INSERT INTO udu_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","tagi ’kup̱ gwo yan mo ki uni mini ’taki dhu gwoŋḵan piti kun bahu mo, dhali mii gwoŋḵan piti kun c̱ikunu mo. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Maŋi Tap̱a mo. Ayy c̱iyi mo jin ’boruwa ’bor bwa i is gi Tap̱a mo, haali/ a’di ’bora’bor mo, haali/ mo/en piti jin ṯelu sho’k mo tani a’di i’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Kaja a’di jin midi mish bah gwo gom miin to ma dem dem gi Tap̱a mo, walla ṯora ris momaŋ piti mo? ");
INSERT INTO udu_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Mom’bor mii gom uni gwansan kun miiki mii ma ḵar/e mo, uni kun mii miiŋḵar/e isa yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Kayi aha/ e mo, ayy Tap̱a, ki /e din mmoṯor mii ma ’them pini e ’kwanim pini mo. Woṯẖi/ aha/ mo me’d jin mina /e ’cuḵ uni mo, ");
INSERT INTO udu_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","ki aha/ mina p̱ar mo jin rusa/ rus gi unim pini kun kwanya /e e mo, ki aha/ mina bwa ’kuny mo e mo jin ’kunya bwaŋ ’kwani gi kal pini mo, ki aha/ mina ca mo e mal pini mo. ");
INSERT INTO udu_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Am dhali ibabam bam mo, ’thissa/ niin mo tani miikina miinthus mo. Aman miikina mii kun ’coḵa’coḵ mo, am miikina to kun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Ibabam bam, ki uni ’kokin e Pam Masir mo tani, uni ’koki hil gwo i e gom tom pini kun miina /e ki momer mo. Uni ’koki ka mo/en pini e jin ṯelu sho’k jin ishki’d ka enthus mo, hili uni pishki is ka le’d ap̱o/ a’di jin Caa e ki Ca e Ḵumma/ Yi’de/ jin ta gi ’Per mo. ");
INSERT INTO udu_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Naskina/ a’di ki ta uni is ki me’d gom gway gi gway piti mo, ki a’di midi ṯor mom’bi’th ma dem dem piti mo. ");
INSERT INTO udu_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","A’di ḵucurki Ḵumma/ Yi’de/ jin ta gi ’Per mo dhali a’di warki’d ki mo jin ḵuthaḵu’th mo. Dhali a’di suski uni e bwaman moŋ’kulga/ mo me’d jin miikina a’di e bwaman ma si’b mo. ");
INSERT INTO udu_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Wakan a’di taki uni is ki me’d mo ’peni ’kwaniŋ ’kup̱ buni mo, dhali ’cuḵ uni mo ’peni mom’bi’th gi ’kwaniŋ ’kup̱ buni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Dhali yi’de/ kumki uniŋ ’kup̱ buni ’twa/a ’cesh mo. Jaŋkamu/ di’d jin boc̱o’d ’peni uniya? ");
INSERT INTO udu_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Dhali yan’ko’d uni gamki gwom piti is mo. Uni yuḵki gway gom momaŋ piti mo. ");
INSERT INTO udu_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Hili ki jahanne/ uni ŋaki miim piti mo. Uni ’koki c̱or gwom piti jin logoma a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Hili uni cana bwa en’dap̱ mo mmogora bwa ki gor e mombwaasho mo, dhali kara Arumgimis mo mmonyo/ a’di e bwam ma si’b mo. ");
INSERT INTO udu_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","A’di c̱i uni to jin doṯkina uni mo, hili a’di ki hash ’ba’th jin shi/ uni is e bwaman uni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Ki ’kwaniŋ gwas kun ’kon e mo ma yuukam buni mmoṯa’c bwa ki ṯa’c ap̱owa Musa mo dhala Haruun, a’di jin ta jan ’de/ gi Tap̱a jin ḵogu mo tani ");
INSERT INTO udu_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","mony’cesh ḵa’dki ’twa/ mo dhali losa waḵ ma Daṯẖan mo dhali kum ’kwani kun nyaḵ ii ka Abiram ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","O’d si’da/ du’dushki’da p̱o/ imannyaḵ iim buni mo dhala le’dan o’d shwaki ’kwani kun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Uni uḵki ari bip̱ e ’kuwosh ma Hurib mo dhali uni ki luŋ tomp̱inycon jin ṯo’du/ mmo/uḵ a’di jin ta p̱inycon mo. ");
INSERT INTO udu_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Uni aḵki monyca ma Arumgimis e mo gom jamas to jin uḵu mo me’da morbip̱ jin shwa’da sho mo. ");
INSERT INTO udu_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Uni ŋakina Arumgimis mo, a’di jin ta’da Manwoṯẖ uni mo a’di jin miiki dhan to jin caaca e Pam Masir mo, ");
INSERT INTO udu_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","ki mii gi momer mo e bampa/ ma Haam mo, dhali dhana puren to e Ḵumma/ Yi’de/ jin ta gi ’Per mo. ");
INSERT INTO udu_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Wakan a’di oki gwo mo ki: A’di midi ’ce’d uni sho’k moyi, dhala Musan ’dem piti jin kwanya a’di mo tani dina a’di ki doshi bwambori a’di mo ntagi a’di doḵki’da nyor piti jin midi ’taki ’ce’d uni sho’k mowa? ");
INSERT INTO udu_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Yan’ko’d uni ki waḵ mony’cesh jin ’bora’bor mo, dhali dar gi moŋgam gwo is gom gwom piti jin ona a’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Uni miikina gumgum e bwaŋ gu’b burrinyem buni mo, dhali ush gwo gi ’twa/ gi Tap̱a ha e mo. ");
INSERT INTO udu_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Wakan a’di ’de’kki me’d piti mo dhali thul gwo me’da p̱o/ gom uni mo mmo/o ki a’di midi dhu uni mo mmoṯa’k mo e mombwaashoyi, ");
INSERT INTO udu_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","dhali ḵwa/ emen gi uc̱im buni bwa mo e bwaman kal gi ’kwaniny’cesh mo, mmoc̱ekerki uni bwa mo e bampany ’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Wakan uni ’tampalki is buni ka rum ma Baal jin ta ji Pam P̱aguur mo, dhali ’ka to jin ’ciṯẖu/ ’kus mmothe tomp̱inycon gom jwa gi ’kwani kun wun mo. ");
INSERT INTO udu_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Uni rukunyki Tap̱a mmomiiya nyor mo gom miim buni mo, dhali ’ba’th jin wo’cki ’kwani is she/ du’dushki’d e bwaman uni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Dhali yan’ko’d P̱inahaas doshki’d ki mis mo dhali woṯẖ gwo is mo, dhali ’ba’th jin wo’cki ’kwani is she/ c̱a’bki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Dhali a’di ikarkunu a’di ki mo ma ḵar/e mo ’pena nyaḵum yil jin tanu mo mmotana nyaḵum yil ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Uni raḵ a’di isa nyor mo gom gwo yi’de/ e mo ma Mariiba mo, dhala Musa c̱inu isi jwa mo gom gway buni mo, ");
INSERT INTO udu_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","haali/ uni ki raḵa ḵashiram piti c̱a’bki ŋah ŋah mo, dhali a’di ki o gwo ki mony’cwar mo. ");
INSERT INTO udu_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Uni ’koki ’ce’d ’kwani sho’k mo me’d gwo jin ḵankina Tap̱a uni mo, ");
INSERT INTO udu_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","hili uni ceki e ki kal gi ’kwanin tiya mo dhali da/ar mii kun miina uni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Uni ki mii to gom tomp̱inycon buni mo, a’di jin warki’d ka gume/ gom uni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Uni ki c̱i iya/m buni mmo’ciṯẖ ’kus mmomiiya bas mo dhali i’bwa/ buni si’da/ ka rum thus kun nyo/anyo/ mo. ");
INSERT INTO udu_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Uni ki wol tiya bas kun ’kon ma bas ka p̱o/ mo, uni kun tana bas gi iya/m buni mo dhali i’bwa/ mo, uni kun c̱ikina uni mmo’ciṯẖ ’kus gom tomp̱inycon kun luŋu gi Paŋ Kanaan mo, dhali bampa/ shi/kunu is ka bas ’kwanimpa mo. ");
INSERT INTO udu_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Wakan uni taki ’kwani kun nyo/anyo/ ki miim buni mo, dhali lo’bi gwonyc̱al ki miim buni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Dhali yan’ko’d anyor gi Tap̱a a’di ’thakunu ki ligi/ ligi/ ap̱o/ ’kwanim piti mo dhali a’di ki shi/ mal piti i e mo. ");
INSERT INTO udu_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","A’di ki c̱iki uni mo e me’d gi kal gi ’kwanin tiya mo, wakan ki uni gwansan kun shi/ki uni i e mo tani mii miin tap̱a ap̱o/ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","’Kwaniŋ ’kup̱ buni siri’cki uni ap̱o/ ki sho’k mo, dhali uni ’doyunu mo mmodila bora ’cesh e bwaŋ’kwariny mom’bi’th buni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Me’d ka ris a’di ki ’cuḵ uni mo, hili uni pishki is ka le’d ki ṯas ṯas gom ’kup̱ gwom buni mo dhali uni ’doyunu ka luŋgu’b e miim buni kun ’coḵa’coḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Bahili a’di ki c̱iya hirdhe/ ki mo ma c̱is buni mo, ki a’di ciḵki kom buni mo. ");
INSERT INTO udu_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","A’di ki ka gwo e gom gway buni gom gwom piti jin gama a’di me’d mo, dhali a’di ki biṯ bwam piti me’d mo isi ki gwo gi mo/en piti jin ṯelu sho’k mo jin ishki’d ka enthus mo. ");
INSERT INTO udu_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","A’di ki raḵ uni gwahan mmohila hil ki e ma ’thime/ ki mo/en mo ki uni gwansan kun bu’th uni mmota habuus mo. ");
INSERT INTO udu_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Tayi aman is ki me’d mo, ayy Tap̱a Arumgimis bam mo, dhali tulu/ aman is mo ’pena ris bwaman gi kal gi ’kwaniny’cesh mo, ki am mina c̱i mo jin ’boruwa ’bor bwa i is ki gway pini jin ḵogu mo, dhali ca mo e momaŋ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Mom’bor mii gom Tap̱a mo, a’di jin ta’da Arumgimis ma Israyiil mo, ’peni mo jin ’konuki/e ki sule/ sule/ ya ye ’ba/ mo itan mo jin ’konuki/e ki sule/ sule/ ya ye ’ba/ mo. Dhali dhalka ris ’kwani ’baar mo o gwo mo ki: Amen. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Ayy, c̱iyi mo jin ’boruwa ’bor bwa i is ki Tap̱a mo, haali/ a’di ’bora’bor mo, haali/ mo/en piti jin ṯelu sho’k mo a’di ’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Dhalki ’kwani gwahan kun wanu ’ba/ mo i/o gwo wakan mo, uni kun wankina a’di ’ba/ ’peni mo jin ṯoju bwa mo, ");
INSERT INTO udu_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","dhali tul uni is ’peni mony’cesh mo ’peni mom’pesho’k mo dhali ’pena bora luŋgu’b mo, dhali ’peni moŋ’ko’d gwar ma bim poros mo dhali ’peni moŋ’ko’d gwar ma biny cam mo. ");
INSERT INTO udu_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Unin tiya kun iikin ki iinyc̱a/ e bwam ma si’b mo jin shinu is mo, uni gam bwaya kamu/ e ’peŋkuman bampa/ mmo’ko icine/ mowa? ");
INSERT INTO udu_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Uni ’kosha ṯe/ mo dhali budha yi’de/ mo, dhali aḵashiram buni ’thikina buye/ e bwaman uni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Dhali yan’ko’d uni ki ko ’twa/i Tap̱a mo gom monṯo’c bwam buni mo, dhali a’di ’cuḵki uni ’peni mo ma c̱is buni mo, ");
INSERT INTO udu_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","dhali a’di ki shu uni bway ki bwaya ji sho’k mo, ntagi uni bumburkin mo e ’peŋkuman bampa/ mmo’ko icine/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Dhalki uni c̱i mo jin ’boruwa ’bor bwa i is gom Tap̱a mo gom mo/en piti jin ṯelu sho’k mo, gom miin to gi momer piti e iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Haali/ a’di ki kap̱ a’diya du mo, a’di jin budha yi’de/ mo, dhali a’di jin ’kosha ṯe/ mo tani a’di ki ’tu’d a’diya du ki tom ’borga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Kun tiya ’kokin e mondhurumi’da ’tum mo dhali e mo jin molu pi ’kup̱ ka pije/ mo kun tana habuus mo gom uni doru ki isa nyor mo dhali remu ’basho’k ki toŋḵuthu’d mo, ");
INSERT INTO udu_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","haali/ uni pishki is ka le’da p̱o/ gwo ma Arumgimis mo, dhali bel gwo jin logoma a’di jin Caa e ki Ca mo. ");
INSERT INTO udu_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Adum buni a’di luŋku’d gom to jin diṯadiṯ kun miina uni mo, dhali ki uni ṯa’kki ’ko’da ’cesh mo tani jaŋkamu/ p̱iyi’d mmowoṯẖ uni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Yan’ko’d uni ki ko ’twa/i Tap̱a mo gom monṯo’c bwam buni mo dhali a’di ’cuḵki uni ’peni mo ma c̱is buni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Dhali a’di ki ’doyu/ uni ka pije/ ’peni mondhurumi’d mo dhali mo jin molu pi ’kup̱ ka pije/ mo dhali a’di ki ’ce’d mondeḵ buni mmoshaṯ uni ka ’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Dhalki uni c̱i mo jin ’boruwa ’bor bwa i is gom Tap̱a mo gom mo/en piti jin ṯelu sho’k mo, gom miin to gi momer piti e iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Haali/ a’di shaṯki’da risa campur ma koroḵ ka ’cesh mo, dhali a’di ki pwaṯẖ dhana bem’ban toŋḵuthu’d bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Kun tiya ’ba’thkin mo e bway miinthus buni mo, dhali gom miiny’coḵam buni mo tani uni ’koshkunu is ka nyor gom to jin wo’cki is she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Uni ushki tonṯen tiya kun ’kona e ki she/ mo, uni ’dishki ’twaŋkal gi mowu is mo. ");
INSERT INTO udu_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Dhali yan’ko’d uni ki ko ’twa/i Tap̱a mo gom monṯo’c bwam buni mo dhali a’di ’cuḵki uni ’peni mo ma c̱is buni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","A’di hashki gwom piti mo dhali wac̱ uni mo, dhali a’di ’cuḵki uni mo ’peni mo jin ’ce’du sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Dhalki uni c̱i mo jin ’boruwa ’bor bwa i is gom Tap̱a mo gom mo/en piti jin ṯelu sho’k mo, gom miin to gi momer piti e iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Dhali dhalki uni c̱i to jin c̱inu mmo’ciṯẖ ’kus ki bwa jin ’boruwa ’bor i is mo dhali ṯor miim piti ki gway mo ki bwaŋ ’kunyka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Kun tiya iikin ka ’cesh e bwaman ḵumma/ yi’de/ e bwaa ḵur mo, mmomiiya ṯu’c yol jin caaca e dhan yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Uni p̱arki mii gi Tap̱a e mo, momer piti kun miikina a’di e moŋ’kulga/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Haali/ a’di ḵanki gwo mo dhali cu ’tham jin ta’da p̱unthar mo, a’di jin ’de’kki yi’de/ abor ki mis mmobir bakal ap̱o/ ḵumma/ yi’de/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Uni uluc̱ki ’kup̱ki mis mo tani dhali uni iikin ka ’cesh e moŋ’kulga/ mo. Mo ma dum buni jin ’bitha uni is waki’d mo gom mo ma c̱inthar buni kun ta thus ki thus mo. ");
INSERT INTO udu_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Uni iikin ki dho’do/ dho’do/ mo dhali wuŋgul ii mo me’d ’kwani kun ’koshkin ma su mo, dhali uni deekina miim buni ki tash tash mo. ");
INSERT INTO udu_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Dhali yan’ko’d uni ki ko ’twa/i Tap̱a mo gom monṯo’c bwam buni mo dhali a’di ’cuḵki uni ’peni mo ma c̱is buni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","A’di karki’da p̱unthar ’tham mmodi ka ḵu’th is mo, dhali bakal ḵumma/ yi’de/ a’di doshkunu ki biyuu mo. ");
INSERT INTO udu_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Dhali yan’ko’d uni ’kunya bwa mo haali/ uni gam mo jin ’konu ki shwamm mo, dhali a’di ki sus uni e mom buni jin ’kana uni ki she/ jin ona bwa uni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Dhalki uni c̱i mo jin ’boruwa ’bor bwa i is gom Tap̱a mo gom mo/en piti jin ṯelu sho’k mo, gom miin to gi momer piti e iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Dhalki uni kar a’di ki ca mo e bwaman ma tul ’kup̱ ’kwani mo, dhali maŋ a’di e bwaman ma tul ’kup̱ gi ’kwaniŋ gwanyjaḵa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","A’di ki ṯu’k yi’de/ e bwaman ma si’b mo, yi’de/ jin kasha e e mony’cesh jin budha yi’de/ ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Mony’cesh jin dhotha to a’di ki ṯu’k a’di mo mmota a’cesh jin ’balatha’bala’th jin shiyi’d mo, gom miim buni kun ta thus ki thus kun ’kokin e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","A’di ki ṯu’k bwaa si’b mmowar ka al yi’de/ mo, dhali mony’cesh jin ta’da burta/ o’d mo tani a’di ki kar a’di mmokash yi’de/ e mo. ");
INSERT INTO udu_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Dhali imaṯṯaan a’di ki dhal uni kun ’kosha ṯe/ mmo’ko mo, dhali uni ṯelki ’peŋkuman bampa/ sho’k mo mmo’ko icine/ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Uni siki bunto mo dhali nyaŋa goŋ mmosiya mura’th mo, dhali gam maman cwa kun gwono’dkin mo. ");
INSERT INTO udu_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Ki mom’bor miim piti mo tani uni markina mar is ki caaca mo, dhali a’di diki dhal bip̱ buni bway mo mmo’koki ’ko mmodhodhi mar is mo. ");
INSERT INTO udu_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Ki uni ’kon ki daḵa/ mo dhali warkunu ki ’kwani kun aṯẖa she/ ki aṯẖ mo e mo jin siri’ckunu uniya siri’c ki sho’k mo dhali monṯo’c bwa mo dhali bwan diṯi’d mo tani ");
INSERT INTO udu_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","a’di ki wol mowaḵa p̱o/ iya/ gi imaliḵ mo dhali a’di ki dhu uni mmo/ii ka c̱a/ e mo jin p̱ina sho’k ’kwani mo dhali tonycuḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Hili a’di ki cu uni mis uni kun mini mii ta gi to ’peni mo jin ṯojuwa ṯo’c bwa mo, dhali dhuwa waḵ buni mmowa e ka ma’diny ḵa’bal mo. ");
INSERT INTO udu_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","’Kwani kun dhelel ma du mo tani p̱arki a’di e mo dhali ’kuny bwa mo dhali aris uni kun ta thus ki thus mo tani ’dap̱kunu ’twam buni mo. ");
INSERT INTO udu_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","A’diyin jin yuḵayuḵ mo tani dhalki a’di c̱iyi’da hirdhe/ ki to gwansan mo. Dhalki ’kwani hil isi gwo i e mo gom mo/en gi Tap̱a mo jin ṯelu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Adum pem thosonki is mo, ayy Arumgimis. Adum pem thosonki is mo. Aha/ mina yuḵ gway mo, aha/ mina yuḵ gway mmomaŋa maŋ mo. Meri e mo, aḵashiram pem. ");
INSERT INTO udu_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Meri e mo, ayy adheŋdhenye/ dhala dheŋdhenye/ jin ’kon ma shu/i pesu/ mo. Aha/ mina mer mon’twash/e e mo. ");
INSERT INTO udu_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki /e mo, ayy Tap̱a, e bwaman ma ris ’kwani mo. Aha/ mina yuḵ gway mmomaŋ /e e bwaman kal gi ’kwaniny’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Gom mo/en pini jin ṯelu sho’k mo ap̱owa dhan momis mo, mo ma isiŋ ganam pini a’di jithirki’d e bwaman ma raḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Kari is pini ki ca mo, ayy Arumgimis, ap̱o/ momisi ’baar mo. Dhalki monycam pini a’di di’da p̱o/ mony’ceshi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Ki a’dim pini jin enu minu ’cuḵ mo tani /e ki c̱i mowoṯẖ ka bim poros pini mo, dhali thoḵ aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Arumgimis oki gwo is e mom piti jin ḵogu mo mmo/o gwo mo ki: Aha/ mina ya i mis ki moŋ’kuny bwa mo dhali ḵwa/ Pan Shakiim bwa mo dhali ’to/ to bwa ime’d mo e embul Wosh ma Sukkuut mo. ");
INSERT INTO udu_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Jil/aad a’di ta jim pem mo, dhala Manassa a’di ta jim pem mo, dhala Ep̱rayim a’di ta toŋ’kup̱ pem mo. Yahuuda/ a’di ta cwa ma maliḵ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Muwab a’di ta’da ḵwalal pem jin ’thurka/ me’d mo dhali e Pan Aduum mo tani aha/ mina biṯa p̱p̱a/ pem mo, dhali ap̱o/ e Pam P̱alasthiin mo tani aha/ mina ’ther cuuwa/ ki mo jin p̱inu mii e mo. ");
INSERT INTO udu_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Kaja a’di imidi shu aha/ bway e ’peŋkuman bampa/ jin ṯenu gwo mo? Dhali kaja a’di jin midi shu aha/ bway e Pan Aduum mo? ");
INSERT INTO udu_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Ki diki ta /e iwaḵki aman mo, ayy Arumgimis? /E diki nyaḵ ya ki aman mo, ayy Arumgimis, nyaḵki ’kwani ma meem bam mo. ");
INSERT INTO udu_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Ayy c̱iyi aman mowoṯẖ ’peni ’kup̱ bam mo ma, haali/ mowoṯẖ ’peni ’kwani mo tani ta jim p̱e’th mo. ");
INSERT INTO udu_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Ka Arumgimis mo tani ana mina mii mii kun c̱a’bki koŋ koŋ mo. Haali/ a’di ta a’di jin midi ṯan bway gom ’kwaniŋ ’kup̱ bana mo be. ");
INSERT INTO udu_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Dhalku/ ki c̱a’b ki shwamm mo, ayy Arumgimis gom momaŋ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Haali/ ’twa/ gi ’kwani kun ta thus ki thus mo dhali kun he’kkina he’k e mo ḵa’dkina uni ap̱o/ aha/ mo, mmo/o gwo ap̱o/ aha/ ki ’twa/ ma ṯor mo. ");
INSERT INTO udu_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Uni ṯu’bki aha/ ki gwo jin shinuwa shi/ i e mo dhali bu’th aha/ ki dar gi mii mo. ");
INSERT INTO udu_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","To kun doḵkina uni aha/ ’peni mo/en pem mo tani uni ki thisi yer aha/ is ki gway mo, isi kani me’d jin dika/ mmo’tho gom uni mo. ");
INSERT INTO udu_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Wakan uni ki c̱i aha/ to jin ta thus gom tom ’boro’d mo dhali mo jin shinuwa shi/ i e mo gom mo/en pem mo. ");
INSERT INTO udu_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Kari wathi/ jin ta thus ki thus ’pen ka pije/ ap̱o/ a’di mo dhali dhalka manyer a’di is ki gway susi a’di e mo jin dwallu gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Ki a’di dwallkunu gwo mo tani dhalki a’di dikina mii i’ba/ mo. Dhalki mon’thom piti a’di deŋu e ki ta ji miinthus mo. ");
INSERT INTO udu_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Dhalka teem piti karu ki kuṯ kuṯ mo. Dhalki wathiŋ kamu/ bu’th mal piti mo. ");
INSERT INTO udu_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Dhalki uc̱im piti ’kon ki dar gi com mo, dhali dhalki ashim piti ta’da dhalla/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Dhalki uc̱im piti ii iinyc̱a/ dhali ’tho to mo. Dhalki uni uru ka pije/ ’peni mo jin kup̱a uni kun ’kona uni mo. ");
INSERT INTO udu_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Dhalki wathi/ jin dina a’di ka mure/ i’ba/ bu’th tom piti ’baar mo. Dhalki ’kwanin tiya si’da/ shi/ maman cwam piti is mo jin ’koshkina a’diya ṯu’c ki mii mo. ");
INSERT INTO udu_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Dhali dhalki wathi/ p̱iyi’d jin midi mii kar bwa jin kushakush gom a’di mo, walla hil uc̱im piti jin dar gi com ki mii ma ’thime/ gi mo/en mo. ");
INSERT INTO udu_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Dhalki emen piti kun mini yayu/ i’ko’d ’ciṯẖkunu ’twa/ mo. Dhalki gway piti si’da/ minu ’kosh ’peni ’kwani ma nyaḵum yil kun min ma p̱o/i ’ko/i su/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Dhalki mii kun ’coḵa’coḵ gi icom kanu e ibwambori Tap̱a mo, dhali dhalki miinthus gi kum minu ’koki ’kosh ka pije/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Dhalki uni ’koni bwambori Tap̱a ki ṯikir ṯikir mo dhali dhalki a’di jin dhunu ibwa minu ’ciṯẖ ’twa/ ’peni mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Haali/ a’di diki ka mii e mo mmoṯor mii gi bwaŋ kush mo hili a’di ki ur ’kwani kun hatha’ko’di sho’k mo dhali uni gun mini mii ta gi to mo dhali uni gun ’ce’dkin ma dum buni gom jwam buni mo. ");
INSERT INTO udu_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","A’di en mo jin jeenuwa jee kagahara mo, dhali dhalki mo ma jee p̱u’dki’da p̱o/ a’di mo. A’di diki en mo jin ’boruwa ’bor mii mo, dhali dhalki a’di si’dasi’d ’peni a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","A’di shumki is piti ki mo ma jee me’d burrinyem p̱om piti jin hitha a’di mo. Dhalki a’di ’thoḵ buŋgwar is piti me’d yi’de/ mo, dhali me’da yin eya simam piti mo. ");
INSERT INTO udu_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Dhalki a’di wana e ki burrinye/ jin ’tampalkina a’di i is mo, dhali me’d wac̱kan jin hi’thkina a’di e empa’d piti ka yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Dhalki a’di yansan ita to jin gam ma manyer aha/ is ki gway ’peni Tap̱a mo gom uni gwansan kun oki tonthusa p̱o/ mondiki/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Hili, /e, ayy Arumgimis jin ta Tap̱am pem mo, ṯu/uli mii yan mo ma gom gway pem mo dhali gom gway gi gway pini mo haali/ mo/en pini jin ṯelu sho’k mo a’di ’boro’d mo mmo’cuḵ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Haali/ aha/ hatha di ’ko’d ki ha’th mo dhali mina mii ta gi to mo, dhala dum pem a’di ta jama/ ki jama/ e isi aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Aha/ ’baara mo, dhali aha/ wana e ka ḵashira/ ma la gi mom’pimpili/ mo. Aha/ yiḵinkunu is me’da kuyu/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","’Kup̱a’dup̱un pem ’ka’da’ka’d mo gom ga/ jin ga/ka/ to mo. Buŋgwar is pem lulki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Aha/ tana kuṯ jin ṯẖunya imanyer aha/ is ki gway ’twa/i is mo. Ki uni p̱arki aha/ e mo tani uni birki ’kup̱ buni mo be. ");
INSERT INTO udu_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Woṯẖi/ aha/ mo ma, ayy Tap̱a Arumgimis pem mo. Tayi aha/ is is ki me’d mo isi ki mo/en pini jin ṯelu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Dhalki uni mishi mo mo ki mii yansan a’di ita mii gi me’d pini mo, ki /e, ayy Tap̱a, imiiki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Dhalki uni jeena jee mo, hili /e mini mii mo jin ’boru mii mo. Dhalki uni gwansan kun ṯẖa’th aha/ ki is dhunu ki mo ma ’the is mo. Dhalki c̱iŋkinam pini ’kunya bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Dhalki imanyer aha/ is ki gway shumu ki mii jin thisuwa taḵ ush taḵ mo. Dhalki uni i’tampalkina mo ma ’the is buniŋ gana/ e is mo me’d burrinye/ mo. ");
INSERT INTO udu_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Ki ’twam pem mo tani aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki Tap̱a mo. Aha/ mina maŋ a’di e bwaman ma waambuhany ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Haali/ a’di doshki’d ki me’da bim poros mo gom a’di jin midi mii ta gi to mo, mmota a’di is ki me’d mo ’peni uni gwansan kun waḵki a’di mmowu mo be. ");
INSERT INTO udu_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Tap̱a ki o tap̱am pem gwo mo ki: C̱a’bi /e aha/ ki me’da bim poros pem mo ma ntagi aha/ mina dhu uni gun ta ’kup̱ ki /e mmota cwa jin mina /e dhu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Tap̱a ki hash ’pena Sihyuun cwa ma maliḵ pini jin ta gi mo ma dem dem mo. Jiyiya ji e bwaman ’kwani kun ta ’kup̱ pini mo. ");
INSERT INTO udu_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","’Kwanim pini mini c̱i is buni ’baḵany mo ka tee jin mina /e susa waambuhany pini ap̱o/ ’kuwosh kun turatur kun ḵogu mo. ’Peni bwa ma dho’th gi mon’thamo/ mo tani dhuru’c pini jin tana /e midi p̱u’du/ i /e me’d jap̱e/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Tap̱a thulki gwo me’da p̱o/ mo dhali a’di midi diki aḵ bwam piti e mo: /E tana gasiis ki sule/ sule/ mo mmobaṯẖa cuḵ ma Malkisaadag isho’k mo be. ");
INSERT INTO udu_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Tap̱a a’di diki’d ki me’da bim poros pini mo be. A’di midi shaṯ imaliḵ ka ’cesh mo ka tee ma nyor piti mo. ");
INSERT INTO udu_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","A’di midi tor gwon dwall ’twa/a ’cesh e bwaman kal gi ’kwaniny’cesh mo, mmo’tu’d uni ki buŋgwar is jwa mo. A’di midi shaṯ itap̱a ka ’cesh mo ap̱o/ mony’cesh jin beeyabee mo. ");
INSERT INTO udu_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","A’di midi p̱i ’peni jis yi’de/ jin kasha e jin di’di shemen bway mo. Wakan a’di midi ’de’k ’kup̱ piti ki mis mo be. ");
INSERT INTO udu_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Maŋi Tap̱a mo. Aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki Tap̱a mo ka dum pemi ’baar mo, ki dhan ya ma tul ’kup̱ gi kwani kun dhelel ma du mo e bwaman ma tul ’kup̱ yan mo. ");
INSERT INTO udu_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Mii gi Tap̱a a’di caaca mo, dhali a’di thuḵkin ma ris ’kwani ’baar ka ’deṯe/ ’deṯe/ ki e mo, uni kun ’borkina bwa e uni mo. ");
INSERT INTO udu_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","A’di ’tu’du/ ki montaḵ mo dhali mo/eḵ mo e miin tom piti mo, dhali miiŋḵar/em piti ’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","A’di ki raḵ miin tom piti jin miina a’di ki momer kanu e mo. Tap̱a a’di ta’da ’the ka ’the mo dhali amanmiimii mo. ");
INSERT INTO udu_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","A’di ki thoson tonṯe/ gom uni gwansan kun ḵo/ki a’di mo. A’di dina bwam piti ki ush mmota pa gom gwo jin gama a’di me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","A’di ki ṯor ’kwanim piti mom’bi’th gi miin tom piti mo, dhali c̱i uni mal gi kal gi ’kwaniny’cesha tiya mo. ");
INSERT INTO udu_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Miin to gi me’d piti mo tani uni ta ku isiŋ gana/ mo dhali kuŋ ḵar/e mo. Aris gwoŋḵan gi ’twam piti uni ta ku gun minu gam is mo. ");
INSERT INTO udu_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Uni ṯelkunu sho’k ki sule/ sule/ mo dhali ki sule/ sule/ mo, mmothim uni ki mii ma isiŋ gana/ mo dhali ki mii ma ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","A’di ki hash mo jin wanu ’ba/ ki ’kwanim piti mo. A’di ki ḵan gwoŋḵan piti jin gamu me’d mmodi ki sule/ sule/ mo. Gway piti ḵogu mo dhali mii ma purem piti mo. ");
INSERT INTO udu_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Moŋḵo/ gom Tap̱a mo tani a’di ta monṯel ’pen gi moyuḵ mo. Mo jin mishu gwo ’ban jin ’boro’d goma ris uni ’baar mo kun boṯkin ki a’di mo. Momaŋ piti a’di i’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Maŋi Tap̱a mo. Mom’bor mii gom wathi/ jin ḵo/ki Tap̱a mo, a’di jin ’kunykina bwa ki ’kuny kagahara e gwoŋḵan piti kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Emen piti mini c̱a’bki dem dem e mony’cesh mo, dhala nyaḵum yil gi ’kwani kun dhelel ma du mo tani uni minu ’bor mii mo. ");
INSERT INTO udu_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Pa jin tanu dhali pa jin tana a’di e gu’b piti mo dhali mo ma ḵar/em piti ’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Moŋkush cuki mis e bwaman mondhurumi’d gom uni kun dhelel ma du mo. Tap̱a a’di ta’da ’the mo dhali ta’da manmiimii mo dhali ta’da ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","A’di ’boro’di gom wathi/ jin ṯu/ulki mii ki mii ma ’the mo dhali c̱i to ka ’ka’d me’di is mo, a’di jin mishi is piti ninn gom tom piti ki mii ma ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Haali/ wathiŋ ḵar/e a’di molu joc̱ ki sule/ sule/ mo. A’di minu ka e ki sule/ sule/ ya ye ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Dhali a’di midi diki ḵo/ is gom tonthus jin minu ḵal mo. Adum piti rwa’ckunu mo, mmogamkina a’di gwo is e Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Adum piti shurki’d mo, a’di midi diki ḵo/ is mo ntagi a’di midi p̱ar to jin ona bwa a’di e ap̱o/ uni kun ta ’kup̱ ki a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","A’di ki pwaḵ to bwa ’baḵany mo, a’di c̱iki to gom ’kwani kun hatha’ko’d mo, mii ma ḵar/em piti a’di ’dimki ’kup̱ ki sule/ sule/ ya ye ’ba/ mo. Cem piti a’di karkunu ki ca ki montaḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Wathi/ jin ta thus ki thus mo tani a’di p̱arki a’di e mo dhali a’di shwa’da nyor mo. A’di ki ’pe’d shem piti mo dhali wa mo. To jin ona bwa wathi/ jin ta thus ki thus mo tani warki’d ka munyjal mo. ");
INSERT INTO udu_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Maŋi Tap̱a mo. Maŋi amaŋ mo, ayy um c̱iŋkina/ gi Tap̱a mo, maŋi gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Mom’bor mii midi di mo gom gway gi Tap̱a mo ’pena tee yansan mo dhali ki sule/ sule/ mo dhali ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","’Peni mo jin sul ma tente/ mo tani dhali mo jin yula a’di mo tani gway gi Tap̱a a’di iminu maŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Tap̱a a’di iḵa’damaḵa’dam ap̱owa ris kal gi ’kwaniny’cesh mo, dhali monycam piti a’di diki’da p̱o/ momis mo. ");
INSERT INTO udu_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Kaja a’di iwakina e ki Tap̱a Arumgimis bana mo, a’di jin c̱a’bki’d e mo jin ḵa’dama/ ḵa’dam mo, ");
INSERT INTO udu_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","a’di jin hilki mo ka luŋgu’b ’pena p̱o/ momis mo dhali mony’cesh mo? ");
INSERT INTO udu_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","A’di ki ’de’k ’kwani kun hatha’ko’d ki ha’th ’peni bu’da’cesh mo dhali a’di ki ’de’k uni kun mini mii ta gi to mo ’pena duhal ’piny mo, ");
INSERT INTO udu_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","mmodhu uni mmonyaḵ ’ko ki iya/ gi imaliḵ mo, dhali nyaḵki iya/ gi imaliḵ gi ’kwanim piti mo. ");
INSERT INTO udu_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","A’di ki c̱iya ’boma burum pa mo mmoc̱a’b mo, mmokara yim mmo’kuny bwa ki ’kuny jin shiyi’d mo me’d kum gi uc̱i mo. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Me’d jin yakin ma Israyiil ka pije/ ’peni Pam Masir mo tani gu’b ma Yakuub ’peni ’kwani kun wal ’twan tiya mo tani ");
INSERT INTO udu_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Yahuuda/ warki’d ki mom piti jin ḵogu mo, dhala Israyiil a’di ta mo jin tanu tap̱a ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Dhan ḵumma/ yi’de/ hilki mo mo dhali ya ŋwac̱a/ mo. Dhali Ḵumma/ Yi’de/ Uurdun doḵki’d ka nyaŋ’ko’d mo. ");
INSERT INTO udu_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","’Kuwosha turga/ p̱ekina ŋalbothoŋ ki ’thir ’thir mo me’d gwasiŋ ḵa’bal mo, dhali ushi wosha gwa’dga/ wana e ki ushi ḵa’bal mo. ");
INSERT INTO udu_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Ata mii /eye, ayy ḵumma/ yi’de/, ki /e guskin kan mo? Ayy Uurdun, katinta doḵkina /e ka nyaŋ’ko’d mo? ");
INSERT INTO udu_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ayy ’kuwosha turga/, ata p̱ekina um ki ’thir ’thir me’d gwasiŋ ḵa’bal kan mo? Dhali um ushi wosha gwa’dga/ kun wana e ki ushi ḵa’bal mo? ");
INSERT INTO udu_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Deeyi ma ki bir bir mo, ayy mony’cesh, e buŋ’kus gi Tap̱a mo, e buŋ’kus ma Arumgimis ma Yakuub mo, ");
INSERT INTO udu_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","a’di jin ṯu’kki wosh mo mmota a/al gom yi’de/ mo dhali wosh jin biliṯki o’d mo tani warki’d ki yi’de/ jin kasha e mo. ");
INSERT INTO udu_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Yisa e am, ayy Tap̱a, yisa e am, hili gom gway pini mo tani c̱iyi monyca mo, gom gway gi mo/en pini jin ṯelu sho’k mo dhali mii ma isiŋ ganam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Ki ton ta’da tinta imina kal gi ’kwaniny’cesh i/o gwo mo ki: Mane Arumgimis buni mane? ");
INSERT INTO udu_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Arumgimis bana a’di diki’d e momis mo. A’di ki mii a’diyin jin ’bora bwa a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Tomp̱inycon buni kun luŋa uni mo tani ta ’dolkon kush mo dhali ’dolkon gana/ mo kun uḵu ki me’d gi ’kwani mo be. ");
INSERT INTO udu_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Uni ta gi ’twa/ mo, hili uni o gwoŋ kamuwa? Dhali uni ta gi e mo, hili uni p̱arki toŋ kamu/ eya? ");
INSERT INTO udu_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Uni ta gi ’ce mo, hili uni ciḵ toŋ kamuwa? dhali uni ta gi shush mo, hili uni cic̱kina shim toŋ kamuwa? ");
INSERT INTO udu_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Uni tan gi me’d mo, hili uni ta toŋ kamu/ is ki me’da? Uni tan gi sho’k mo, hili uni mishi ii ki shoka? Dhali uni misha isa kamu/ mur e ’kus buniya? ");
INSERT INTO udu_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Uni gwansan kun uḵ uni mo tani uni wana e ki uni mo. Wakan si’da/ aris uni gwahan kun gamki gwo is e tomp̱inycon buni mo. ");
INSERT INTO udu_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Ayy Israyiil, gami gwo is e Tap̱a mo. Haali/ a’di ita mowoṯẖ buni mo dhali agoŋgorom buni mo. ");
INSERT INTO udu_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Ayy gu’b ma Haruun, kari moŋgam gwo is e Tap̱a mo. Haali/ a’di ita mowoṯẖ buni mo dhali agoŋgorom buni mo. ");
INSERT INTO udu_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Um kun ḵo/ki Tap̱a mo tani gamki gwo is e Tap̱a mo. Haali/ a’di ita mowoṯẖ buni mo dhali agoŋgorom buni mo. ");
INSERT INTO udu_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Tap̱a tana bwa pa ki pa gom ana mo. A’di midi ’bor ana mii mo. A’di midi ’bor gu’b ma Israyiil mii mo. Dhali a’di midi ’bor gu’b ma Haruun mii mo. ");
INSERT INTO udu_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","A’di midi ’bor uni gwansan mii kun ḵo/ki Tap̱a mo ’peni uni kun gwa’da is mo dhali uni kun cakin mo. ");
INSERT INTO udu_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Dhalki Tap̱a c̱i um mo jin maruwa mar is mo, um dhali uc̱im bum mo. ");
INSERT INTO udu_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Dhalki um ’boru mii ki Tap̱a mo, a’di jin uḵki momis mo dhali mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Momis uni ta momis gi Tap̱a mo, hili mony’cesh c̱ikina a’di ki iya/ gi ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Uni kun wukin mo tani mishi Tap̱a maŋ yisa, walla uni gwansan kun iikin ka luŋgu’b e mo ma shwamm mo. ");
INSERT INTO udu_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Hili ana mina ’bor Tap̱a mii mo ’pena tee yansan shwane/ mo dhali ki sule/ sule/ ya ye ’ba/ mo. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Aha/ mina en Tap̱a mo haali/ a’di ciḵki ko gi ’twam pem mo jin ’thoka/ ka di’b me’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Haali/ a’di ḵa’dki bwany’cem piti ki aha/ mo wakan aha/ mina yuḵ a’di isi ki me’d jin dika/ ki e mo. ");
INSERT INTO udu_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Agume/ gi mowu uni ’kamki aha/ is mo, anyoḵ ma Haawiya uni bu’thki aha/ mo. Aha/ ’kosha is ka nyor mo eya c̱is pem mo dhali ’pe’d she/ mo. ");
INSERT INTO udu_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Yan’ko’d aha/ ki yuḵ gway gi Tap̱a mo mmo/o gwo mo ki: Ayy Tap̱a, aha/ yuḵa /e mo, tayi mondiki/em pem is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Tap̱a a’di ta’da ’the ka ’the mo dhali ta’da ḵar/e mo, Arumgimis bana jin miimii mo. ");
INSERT INTO udu_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Tap̱a a’di ’tashki uni ’twa/ mo uni kun wana she/ is is kan mo, ki aha/ guyunu ka luŋgu’b e moŋgwa’dga/ mo tani a’di taki aha/ is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Doḵi ka nyaŋ’ko’d, ayy ḵashiram pem, e mosi/is pini mo, haali/ Tap̱a a’di ṯu/ulki’d nyaḵki /e ki mii jin isha to ka enthus gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Haali/ /e ’cuḵkina ḵashiram pem ’peni mowu mo, dhali em pem ’peni jabu’th jin wolki’d mo, dhali sho’k pem ’peni mo jin gwoluwa gol mo. ");
INSERT INTO udu_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Aha/ yakina e bwambori Tap̱a mo e mony’cesh jin ’konuki/e mo. ");
INSERT INTO udu_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Aha/ karkina moŋgam gwo is pem mo, isi kani me’d jin okika/ gwo mo ki: Aha/ tashu ka dhan mo jin jwakaṯkunuwa jwakaṯ jin shiyi’d mo. ");
INSERT INTO udu_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Aha/ ona gwo e mom pem jin dumbulkika/ bway mo ki: ’Kwani ’baar mo tan ga ’teŋ kap̱e/ jin ta jim ma p̱e’th mo. ");
INSERT INTO udu_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Ata a’di jin miga/ c̱i ki Tap̱a mo goma ris tom piti ’baar kun ishkin ka enthus gom aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Aha/ mina ’deka ḵubbaaya gi mowoṯẖ ma Arumgimis ki mis mo dhali yuḵ gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Aha/ mina c̱i gwom pem jin oka/ is ki Tap̱a mo e buŋ’kus ma ris ’kwanim piti ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yinthoŋ gana/ e jis/e gi Tap̱a mo, a’di ita wu ki unim piti kun dhunu ki she/ ki dhelel dhelel mo. ");
INSERT INTO udu_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Ayy Tap̱a, aha/ tana c̱iŋkinam pini mo. Aha/ tana c̱iŋkinam pini mo, a’di jin ta ya/ gi nyaranyc̱iŋkinam pini mo be. /E ki ’cuḵ mondeḵ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Aha/ mina c̱i to jin ’ciṯẖu/ ’kus ki bwa jin ’boruwa ’bor i is mo dhali yuḵ gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Aha/ mina c̱i gwom pem jin oka/ is ki Tap̱a mo e buŋ’kus ma ris ’kwanim piti ’baar mo, ");
INSERT INTO udu_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","eya pije/ gi gu’b gi ’kup̱ ḵany gi Tap̱a mo, e bwaman um mo tani, ayy Urushaliim. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Maŋi Tap̱a mo, aris um kal gi ’kwaniny’cesh mo. Yuḵi gway ki moŋ’kuny bwa gom a’di mo, aris um ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Haali/ mo/en piti jin ṯelu sho’k mo tani a’di caaca ’kup̱ki ana mo dhali mo ma isiŋ gana/ gi Tap̱a mo a’di ’dimki ’kup̱ ki sule/ sule/ ya ye ’ba/ mo. Maŋi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Ayy c̱iyi mo jin ’boruwa ’bor bwa i is gom Tap̱a mo, haali/ a’di i’boro’d mo. Mo/en piti jin ṯelu sho’k mo tani a’di ’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Dhalka Israyiil o gwo mo ki: Mo/en piti jin ṯelu sho’k mo tani a’di ’dimki ’kup̱ ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Dhalki gu’b ma Haruun o gwo mo ki: Mo/en piti jin ṯelu sho’k mo tani a’di ’dimki ’kup̱ ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Dhalki uni gwansan kun ḵo/ Tap̱a mo tani o gwo mo ki: Mo/en piti jin ṯelu sho’k mo tani a’di ’dimki ’kup̱ ki sule/ sule/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","’Peni mo ma c̱is pem mo tani aha/ yuḵkina Tap̱a mo. Dhali Tap̱a thoḵki aha/ ’twa/ mo dhali kar aha/ ki ’kus mo. ");
INSERT INTO udu_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Ki Tap̱a nyaḵ di ki aha/ mo tani aha/ mina ḵo/ toŋ kamu/ yisa. To gi wakatinta imina ’kwani imii aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Tap̱a a’di diki’d e ’ko’d gwar pem mo mmowoṯẖ aha/ mo. Aha/ mina hil mo ki e jin p̱inu mii e mo ap̱o/ uni gwansan kun shi/ki aha/ i e mo. ");
INSERT INTO udu_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","A’di ’boro’d mmobu’th mo jin huru jwa e Tap̱a mo mmo’koki dhu mo jin wunuwa wuny jwa i is e ’kwani mo. ");
INSERT INTO udu_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","A’di ’boro’d mmobu’th mo jin huru jwa e Tap̱a mo mmo’koki dhu mo jin wunuwa wuny jwa i is e iya/ ma maliḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Aris kal gi ’kwaniny’cesh uni ’kamki aha/ ’kup̱ ki deḵ mo. Ki gway gi Tap̱a mo tani aha/ ’ciṯẖkina uni ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Uni ’kamki aha/ ’kup̱ ki deḵ mo, mmo’kam aha/ ’kup̱ ka ris ’twaŋkal kuku/ mo. Ki gway gi Tap̱a mo tani aha/ ’ciṯẖkina uni ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Uni ’kamki aha/ ’kup̱ ki deḵ me’da dham mo. Uni shwan ki bar bar me’d o’d cwan ’de/ mo. Ki gway gi Tap̱a mo tani aha/ ’ciṯẖkina uni ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Aha/ gac̱u/ ki gac̱ jin shi/ashi/ mo. Wakan aha/ ’barkina mo hili Tap̱a woṯẖki aha/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Tap̱a a’di ta mom’bi’th pem dhali gway pem mo. A’di warki’d ki bway gi mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Ciḵi gwo mo ma, gom gwaya ’kunyka/ kun p̱inu mii e mo e gu’b burrinye/ gi ’kwani gi miiŋḵar/e mo. Me’da bim poros gi Tap̱a a’di miiki mii ki dar gi monyju/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Me’da bim poros gi Tap̱a a’di karkunu ki ca mo. Me’da bim poros gi Tap̱a a’di miiki mii ki dar gi monyju/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Aha/ mina wu yisa, hili aha/ mina di ki e mo, dhali tash miin to deŋ e kun miina Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Tap̱a a’di dorki aha/ ntagi aha/ bura is ki wap̱ wap̱ mo, hili a’di yisa c̱iki aha/ mmowu mo yisa. ");
INSERT INTO udu_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Ḵa’di aha/ ’twaŋkal ma goŋ ki mii ma ḵar/e mo ki aha/ mina cic̱ e uni mo dhali c̱i mo jin ’boruwa ’bor bwa i is ki Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Yansan a’di ta ’twaŋkala goŋ gi Tap̱a mo jin mina ’kwaniŋ ḵar/e cic̱i cine/ mo. ");
INSERT INTO udu_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Aha/ ’borkina /e bwa i is mo haali/ /e ciḵki aha/ ’twa/ mo dhali war ki bway gi mowoṯẖ pem mo. ");
INSERT INTO udu_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Wosh gana/ yansan jin waḵkina imannyaŋ gu’b mo tani a’di warki’d ka dhana ’kaŋ’kup̱ wosh gi ’penabi mo. ");
INSERT INTO udu_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Mii yansan a’di ita mii jin miikina Tap̱a mo, dhali a’di ta mii jin meru em bana mo be. ");
INSERT INTO udu_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Yansan a’di ita’da tee jin karkina Tap̱a mo. Dhalki ana ’kunya bwa mo dhali ’bor bwa e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Tayi am is ki me’d mo, am kun yuḵkina /e mo, ayy Tap̱a. Ayy Tap̱a, am yuḵkina /e mo, c̱iyi aman mo jin diluwa bora ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Mom’bor mii gom a’di jin cic̱ki’d mo e gway gi Tap̱a mo. Am ’bora /e mii mo ’peni gu’b gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Tap̱a a’di ita’da Arumgimis mo, dhali a’di c̱iki ana moŋkush mo. Nyoŋi mo jin ḵalu ya goma yuḵ ma tul ’kup̱ ka biny cwa mo ntagi ce jin thumu e ’kup̱a gwaṯa/ jin miinuwa bas mo. ");
INSERT INTO udu_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","/E tana Arumgimis pem mo dhali aha/ mina c̱i mo jin ’boruwa ’bor bwa i is ki /e mo. /E tana Arumgimis pem mo dhali aha/ mina kar /e ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Ayy c̱iyi mo jin ’boruwa ’bor bwa i is gom Tap̱a mo, haali/ a’di i’boro’d mo, haali/ mo/en piti jin ṯelu sho’k mo tani a’di i’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Mom’bor mii gom uni gwansan kun ’kona bway buni ki dar gi mii i’ba/ mo uni kun iiyin e gwoŋḵan jin c̱inu gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Mom’bor mii gom uni gwansan kun dhuki gwonyc̱im piti mo, uni kun simmki a’di e ka dum buni ’baar mo, ");
INSERT INTO udu_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","uni si’da/ kun ’koki ṯẖu’th to mii mo, hili mmo/ii e bway piti mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","/E ḵanki gwoŋḵan gi ’twam pini mo ki uni minu dhu ka duŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Ayy ki bway pem minu ṯel sho’k mo mmodhu gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Wakan ki aha/ minu ’koki kar ki mo ma ’the is mo, mmothoson em pem mmoḵo’c eya ris gwoŋḵan pini ’baar mo kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Aha/ mina maŋ /e ka du jin dheleladhelel mo, ki aha/ mina da/ar gwo gom mii ma ḵar/em pini ’peni gwoŋḵan kun onu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Aha/ mina mii gwoŋḵan pini kun bahu mo. Ayy dhalki aha/ ki dhal ’pen mo ka dun ṯẖorony mo. ");
INSERT INTO udu_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","A’di jin ta dhuru’c midi kar bway piti ki dhelel dhelel kata mo? mmoji a’di isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ka dum pemi ’baar mo tani aha/ simmkina /e e mo. Dhalku/ ki dhal aha/ mmoc̱aca/ mo ’peni gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Aha/ dhukina gwom pini eya dum pem mo, ki aha/ mina diki mii miinthusa p̱o/ /e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Mom’bor mii gom /e mo, ayy Tap̱a. Ṯori aha/ gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ki ’twam pem mo tani aha/ bahkina aris gwoŋḵan pini kun onu ki ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","E bway gi gwonyc̱im pini mo tani aha/ ’kunya bwa mo me’d jin miga/ ’kuny bwa eya ris mo jin tanu pa ki pa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Aha/ mina kulum gwo ibwa gom gwoŋḵan gi ’twam pini mo dhali ḵo’c em pem e bway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Aha/ mina bwa ’kuny mo e gwoŋḵan pini kun bahu mo. Aha/ mina diki ŋa gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Ṯu/uli nyaḵki c̱iŋkinam pini ki mo jin isha to ka enthus mo, ki aha/ mina di ki e mo dhali mii gwom pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Ḵa’di em pem mo ma ki aha/ mina p̱ar momer e kun ’kon e gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Aha/ tana yilkina/ ki yilkina/ e mony’cesh mo. Dhalku/ ki bag gwoŋḵan pini kun ’kwarkunu ’peni aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Aḵashiram pem a’di ’cumkunu ki mo jin c̱ora/ c̱or mo goma ris gwoŋḵan pini ’baar kun onu ka yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","/E ki ḵucur uni gwansan kun ush ’kwani ga/ mo, dhali uni kun jeenu mo, uni kun c̱a’ckin mo ’peni bway gi gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ḵali ’peni aha/ mon’twam buni kun ṯẖunya uni aha/ i is mo dhali mo ma waḵ mo, haali/ aha/ dhukina gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Isi kani ba iya/ ma maliḵ uni ’kokin mo dhali miiya wutha p̱o/ aha/ mo tani c̱iŋkinam pini a’di midi kulum gwo ibwa gom gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Gwonyc̱im pini uni a’di i’kunykika/ bwa mo haali/ uni itana manlogom aha/ ki gwo mo. ");
INSERT INTO udu_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Aḵashiram pem thalkina bu’da’cesh mo. Tashi aha/ e mo isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ki aha/ ṯorkina bway pem mo tani /e thoḵki aha/ ’twa/ mo. Ṯori aha/ gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Kari aha/ mmomish gwo ’ban gom bway gi gwoŋḵan gi ’twam pini mo, dhali aha/ mina kulum gwo ibwa gom miim pini jin miina /e to ki momer mo. ");
INSERT INTO udu_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Aḵashiram pem a’di waki’d gom bwan diṯi’d mo. ’Bithi aha/ is mo isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Kari bway jin ta thus ki thus mmosi’d ’peni aha/ mo. Dhali ka ’the mo tani ṯori /e aha/ gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Aha/ kwanykina bway gi mii ma isiŋ ganam pini mo. Aha/ karkina gwoŋḵan pini kun onu ibwambori jis/em pem mo. ");
INSERT INTO udu_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Aha/ thalkina gwonyc̱im pini mo, ayy Tap̱a. Dhalku/ ki dhal aha/ bway ki aha/ minu kar ki mo ma ’the is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Aha/ mina gus e bway gi gwoŋḵan pini kun ’kwarkunu mo ki /e mini lala’th mom pem jin mishka/ gwo ’ban is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Ṯori aha/ gwo mo ma, ayy Tap̱a, gom bway gi gwoŋḵan pini kun bahu mo dhali aha/ mina dhu uni ntagi ’pemen mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","C̱iyi aha/ mo jin mishu gwo ’ban mo ki aha/ mina dhu gwoŋḵan pini jin c̱inu mo dhali mii a’di ka dum pemi ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Susi aha/ e bway gi gwoŋḵan pini kun ’kwarkunu mo haali/ aha/ ’kunya bwa e a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Ḵa’da dum pem ki gwonyc̱im pini mo yisa mmota miiya du is ki me’d mo. ");
INSERT INTO udu_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Ṯuki em pem ’peni mo jin hiluwa hil kun ’kon bwa ’te/ mo dhali c̱iyi aha/ mondiki/e e bway pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Rwaci gwom pini jin ona /e is e c̱iŋkinam pini mo, a’di jin ona /e gom uni gwansan kun ḵo/ki /e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Ḵali ’peni aha/ mowaḵ jin ḵalki aha/ ’ko’da ’cesh mo, haali/ gwoŋḵan pini kun onu mo tani uni ’bora’bor mo. ");
INSERT INTO udu_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Hili mo mo ma, aha/ c̱orkina gwoŋḵan gi ’twam pini mo e mii ma ḵar/em pini mo tani /e c̱iyi aha/ mondiki/e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Dhalki mo/en pini jin ṯelu sho’k p̱u’dki’d e aha/ mo, ayy Tap̱a, isi ki bway gi mowoṯẖ pini jin ona /e gwo is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Dhali yan’ko’d aha/ mina ta gi gwonthoḵ gom uni gwansan kun ṯẖunyki aha/ ’twa/i is mo haali/ aha/ gamkina gwo is e gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Dhali dhalku/ ki bu’th gwoŋ gana/ ’peni ’twa/ pem ka dun ṯẖorony mo, haali/ mo ma ’teŋ kap̱em pem a’di di’d e gwoŋḵan pini kun onu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Aha/ mina dhu gwoŋḵan pini jin c̱inu ki ṯikir ṯikir mo gom ki sule/ sule/ mo dhali ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Dhali aha/ mina ya ’baḵany gana/ mo haali/ aha/ ŋap̱kina gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Aha/ si’da/ mina o gwo gom gwonyc̱im pini ibwambori imaliḵ mo dhali aha/ minu ’koki kar ki mo ma ’the is mo ");
INSERT INTO udu_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","haali/ aha/ gamkina mom pem jin ’kunyka/ bwa mo e gwoŋḵan pini kun ’kwarkunu mo, a’di jin enka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Aha/ taḵa gwoŋḵan pini kun ’kwarkunu mo, a’di jin enka/ mo, dhali aha/ mina kulum gwoŋḵan pini kun bahu mo eya du mo. ");
INSERT INTO udu_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Kayi gwom pini e e c̱iŋkinam pini mo, e a’di jin karkina /e aha/ mmota ga ’teŋ kap̱e/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Yansan ta momalas pem mo e monṯo’c bwa mo ki gwom pini jin ona /e is c̱i aha/ mondiki/e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","’Kwani kun dar gi mii ma gayiin mo tani uni p̱e’th aha/ ki p̱etha sor mo, hili aha/ dinaki ṯu’k mo ’peni gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Ki aha/ kulumkina gwoŋḵan pini kun onu mo ibwa mo ’peni kadhamo/ mo tani aha/ bu’thkina momalas mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Anyor jin deḵu jin ’batha’ba’th mo tani bu’thki aha/ mo gom ’kwani kun ta thus ki thus mo, uni kun dhalki gwoŋḵan pini jin c̱inu ’pen mo. ");
INSERT INTO udu_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Gwoŋḵan pini kun bahu mo tani uni warkin ki gway pem jin yuḵka/ mo e gu’b pem gi moyam pem jin yaka/ luŋ mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Aha/ kakina gway pini e mon’thiny mo, ayy Tap̱a, dhali dhu gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Mom’bor mii yansan a’di biṯki’da p̱o/ aha/ mo ki aha/ dhukina gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Tap̱a a’di ita tom pem jin ’tuntulka/ bwa ime’d mo. Aha/ ona gwo is mmodhu gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Aha/ ’thona mii ma ’them pini ka dum pemi ’baar mo. Miiyi mii ka ’the gom aha/ isi gi gwom pini jin ona /e is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ki aha/ kulumkina gwo ibwa gom bway pini mo tani aha/ woṯẖkina sho’k pem ’ba/ e gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Aha/ hurkina ki ’ta’b mo dhali diki ta adiiṯe/ mo mmodhu gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Ba anyoḵ gi ’kwani kun ta thus ki thus mo tani uni bu’thki aha/ ka gume/ mo dhali aha/ dinaki this gwoŋḵan pini jin c̱inu e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","E mombwam/e mo tani aha/ cukina mis mmomaŋ /e mo, haali/ gom mii ma ḵar/em pini gi gwoŋḵan pini kun onu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Aha/ nyaḵkina ya ka ris uni gwansan kun ḵo/ki /e mo, uni gwansan kun dhuki gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Mony’cesh, ayy Tap̱a, a’di ’tu’dkunu mo ki mo/en pini jin ṯelu sho’k mo. Ṯori aha/ gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","/E ṯu/ulkina ṯu/ul ki ’bore/ gom c̱iŋkinam pini mo, ayy Tap̱a, isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Ṯori aha/ gwo isi ki ṯor gana/ mo mmonyiṯẖ to mo dhali moyuḵ mo, haali/ aha/ gamkina gwo is e gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Nṯwa/a/ ki aha/ wo’ckunu is she/ mo tani aha/ yakina yam per mo, hili shwane/ aha/ dhukina gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","/E ’bora’bor mo dhali mii mii kun ’bora’bor mo. Ṯori aha/ gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","’Kwani kun ushina ga/ ga/ mo tani uni ’thoḵki aha/ ka ṯor mo, hili ka dum pemi ’baar mo aha/ dhukina gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Adum buni momaṯa/ momaṯ me’d ḵwalany mo, hili aha/ ’kunykina bwa mo e gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","A’di ’boro’d gom aha/ ki aha/ jwakaṯkunuwa du mo ki aha/ mina da/ar gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Gwoŋḵan jin c̱inu ki ’twam pini mo tani a’di ’boro’d gom aha/ mo, mmobol ’dolkon gana/ ma alip̱ e mo dhali ’ku’kus ’dolkon kush mo. ");
INSERT INTO udu_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Me’d pini a’di uḵki’da uḵ mo dhali /e c̱iki aha/ jamas mo. C̱iyi aha/ mo jin mishu gwo ’ban mo ki aha/ mina da/ar gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Uni gwansan kun ḵo/ki /e mo tani mini p̱ar aha/ e mo dhali ’kuny bwa mo haali/ aha/ tana gi mo ma ’teŋ kap̱e/ e gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Aha/ misha, ayy Tap̱a, ki gwon dwall pini kun toru gwon dwall ’twa/a ’cesh mo tani uni tana ḵar/e mo dhali /e dorki aha/ ki isa nyor ki mii ma isiŋ ganam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Dhalki mo/en pini jin ṯelu sho’k mo thoson is mo mmomalas aha/ mo isi ki gwom pini jin ona /e is gom c̱iŋkinam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Dhalki momiimiim pini p̱u’du’d e aha/ mo ki aha/ mina di ki e mo, haali/ gwoŋḵan pini jin c̱inu mo tani a’di ta jim pem jin ’kunyka/ bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Dhalki uni kun ushina ga/ ga/ mo tani idhunu ki mo ma ’the is mo haali/ uni ceshki aha/ ki gwo ma maḵ mo. Gom aha/ mo tani aha/ mina kulum gwo ibwa gom gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Dhalki uni gwansan kun ḵo/ /e mo tani ṯu’kkina bor ki aha/ mo, ki uni mini mish gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Dhalka dum pem a’di dar gi mii ’ba/ e gwoŋḵan pini kun bahu mo ki aha/ minu ’koki kar ki mo ma ’the is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Aḵashiram pem a’di gananki ’ba/ mo gom bway gi mowoṯẖ pini mo. Aha/ tana ga ’teŋ kap̱e/ gom gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Em pem ushi me’d mo mmoc̱or /e gom gwom pini jin ona /e is mo. Aha/ doṯa gwo mo ki: Kakasja sa/ imina /e imalas aha/ mo? ");
INSERT INTO udu_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Haali/ aha/ warkina ki ḵucaŋ gi yimana mura’th jin ’koshkin ma ku’d mo, hili aha/ dinaki ŋa gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Ki mo gi wakatinta imina c̱iŋkinam pini i’dim ’kup̱ mo? Kakasja imina /e idwall uni gwansan gwo mo uni kun ṯo’c aha/ bwa mo? ");
INSERT INTO udu_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","’Kwani kun ushkina ga/ ga/ mo tani uni c̱wanyki jisa ’kulga/ gom aha/ mo jin miga/ biṯi cine/ mo, ’kwani kun ’konuki dosh shoka ’cesh gom gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Aris gwoŋḵan pini kun ’kwarkunu mo tani uni shurkin mo. Uni ṯo’cki aha/ bwa ki gwo ma ṯor mo. Woṯẖi/ aha/ mo ma. ");
INSERT INTO udu_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Uni ’dishi ’twa/ mo mmo’baar aha/ ’peni mony’cesh yan mo hili aha/ dinaki ŋa gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","E mo/en pini jin ṯelu sho’k mo tani ’tashi mondiki/em pem ’twa/ mo ki aha/ mina dhu gwonyc̱im pini gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Gom ki sule/ sule/ mo tani, ayy Tap̱a, gwom pini a’di irwa’ckunu mo mmothosonkunu uni mo e momis mo. ");
INSERT INTO udu_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Mii ma isiŋ ganam pini i’dimki ’kup̱ ki sule/ sule/ eya risa nyaḵum yil gi ’kwani mo. /E ṯelki mony’cesh sho’k mo dhali a’di doshki’d ki sho’k piti mo. ");
INSERT INTO udu_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Ki miim pini kun dhukina /e uni ’pen ka pije/ mo tani uni doshkin shwane/ mo. Haali/ aris to ’baar mo tani uni ta c̱iŋkinam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Waḵki/ gwoŋḵan pini jin c̱inu midi ’taki diki ta jim pem jin ’kunyka/ bwa mo tani, aha/ minu ’taki ’ce’d sho’k e tom pem jin ṯocaa/ bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Aha/ mina mol ŋa gwoŋḵan gi ’twam pini ki sule/ sule/ mo, haali/ ki uni mo tani /e c̱iki aha/ mondiki/e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Aha/ tana jim pini mo. Tayi aha/ is ki me’d mo haali/ aha/ ŋap̱kina gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Imanmii tonthus ishkin mo dhali c̱ora/ c̱or mmo’ce’d aha/ sho’k mo, hili aha/ hila isi gwonyc̱im pini i e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Aha/ hilkina gwayu/ gom a’di jin ha me’d ki isi haŋ gana/ ’baar mo, hili gwoŋḵan pini jin ’kwarkunu mo tani a’di ibeeyabee kagahara mo. ");
INSERT INTO udu_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Ayy, gwoŋḵan pini jin c̱inu mo tani enka/ kata mo sa/. A’di ta gwom pem jin kulumka/ ibwa isa yempa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Gwoŋḵan pini jin ’kwarkunu mo ikar aha/ mmoyuḵayuḵ kagahara mmobol ’kwani kun ta ’kup̱ ki aha/ e mo, haali/ a’di di’d nyaḵki aha/ isa yempa/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Aha/ misha gwo ’ban kagahara mmobola ris uni kun ṯorki aha/ gwo e mo, haali/ gwonyc̱im pini a’di ta jim pem jin kulumka/ ibwa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Aha/ mishkina gwo ’ban mo mmobol ’kwani kun cakin e mo, haali/ aha/ dhukina gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Aha/ woṯẖa sho’k pem ’ba/ mo ’pena ris bway thus mo, gom mii gi wakan mo tani mmodhu gwom pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Aha/ dinaki ṯu’k mo ’peni gwoŋḵan pini kun onu mo, haali/ /e ṯorki aha/ gwo mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Gwom pini wana ’kuny kata si’da/ mmonyoḵka/ a’di mo. A’di c̱a’bki dhel dhel mmobola dham e e ’twam pem mo. ");
INSERT INTO udu_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","E gwoŋḵan gi ’twam pini mo tani a’di ibu’thkika/ mo jin mishu gwo ’ban mo. A’di ishi/kika/ aris bway thusi e wakan mo. ");
INSERT INTO udu_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Gwom pini a’di ta’da lamba/ gom sho’k pem mo dhali moŋkush gom bway tur pem mo. ");
INSERT INTO udu_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Aha/ thulkina gwo me’da p̱o/ mo dhali o gwo is mo dhali rwa’c a’di mo mmomii gwoŋḵan pini kun onu mo kun tana ḵar/e mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Aha/ wo’ckunu is she/ mo mmobur is ki wap̱ wap̱ mo. C̱iyi aha/ mondiki/e mo, ayy Tap̱a, isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Budhi tom pem jin c̱ika/ ki me’d ki momaŋ mo, ayy Tap̱a, dhali ṯori aha/ gwo gom gwoŋḵan pini kun onu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Aha/ butha mondiki/em pem e me’d pem ki sule/ sule/ mo, hili aha/ dinaki ŋa gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","’Kwani kun ta thus ki thus mo tani uni ’thikina gume/ gom aha/ mo. hili aha/ dinaki per mo ’peni gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Gwonyc̱im pini uni ta mal pem ki sule/ sule/ mo. Nye, uni ita mom’bor bwa goma dum pem mo. ");
INSERT INTO udu_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Aha/ ḵa’dkina dum pem mo mmothim gwoŋḵan pini kun bahu ki sule/ sule/ mo ntagi ’pemen gi mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Aha/ shi/kina ’kwani kun ’kona bwa ka susu/ i e mo, hili aha/ enkina gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","/E ta mo jin bagka/ mo dhali agoŋgorom pem mo. Aha/ takina ga ’teŋ kap̱e/ e gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Iiku/ mo ’peni aha/ mo um kun mii to kun ta thus ki thus mo, ki aha/ mina ’taki dhu gwoŋḵan ma Arumgimis pem kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Budhi aha/ mo isi ki gwom pini jin ona /e is mo ki aha/ mina di ki e mo, dhali dhalku/ ki dhal aha/ bway mo ki aha/ minu kar ki mo ma ’the is mo gom mom pem jin taka/ ga ’teŋ kap̱e/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","’Deki aha/ ki mis mo ki aha/ mina ’taki di ki ’dantar mo dhali mii gwoŋḵan pini kun bahu ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","/E waḵkina ris uni kun perkin mo ’peni gwoŋḵan pini kun bahu mo, nye, mo jin laṯa/ uniya laṯ e mo tani a’di di bwa ’te/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Aris imanmii tonthus gi mony’cesh mo tani /e ki deŋ uni e me’d wushulan to mo. Wakan aha/ ena gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Buŋgwar is dee’d ki bir bir gom moŋḵo/ is jin ḵo/ka/ /e mo, dhali aha/ ḵo/kina is kagahara gom gwon dwall pini kun toru gwon dwall ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Aha/ miikina a’di jin ta’da ḵar/e mo dhali jin ’boro’d mo. Dhali dhalku/ ki dhal aha/ bway mo jin mina uni gwansan kun siri’c aha/ ap̱o/ ki sho’k mo ’koki siri’c aha/ ap̱o/ ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Tayi ki bwa ma ’dantar gom c̱iŋkinam pini mo, gom mom’bor piti mo. Dhalku/ ki dhal ’kwani kun molina gayiin ga/ bway mo mmosiri’c aha/ ap̱o/ ki sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Em pem ushki me’d mo mmotim bway mowoṯẖ pini mo, dhali gom gwom pini jin minu thim jin ona /e is ki o ma ḵar/e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Ṯu/uli nyaḵki c̱iŋkinam pini mo isi ki gwo gi mo/en pini jin ṯelu sho’k mo, dhali ṯori aha/ gwo gom gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Aha/ tana c̱iŋkinam pini mo. C̱iyi aha/ mo jin mishu gwo ’ban mo ki aha/ mina ’taki mish gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","A’di ta’da tee gi Tap̱a jin mina a’di ḵal mii mo, haali/ gwoŋḵan pini jin c̱inu mo tani a’di ’ce’dkunu bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Wakan aha/ enkina gwoŋḵan pini kun ’kwarkunu mo mmobol ’dolkon e mo, dhali ’dolkon gana/ jin tashu e ki o’d ki tash gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Wakan aha/ c̱u’thkina bway pem ’twa/ ’kup̱ ka ris gwoŋḵan gi ’twam pini mo, dhali aha/ shi/kina ris bway thusi e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Gwonyc̱im pini uni ita jaro/ ki jaro/ mo. Wakan aḵashiram pem idhuki uni mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Gwom pini kun ’ceenu mo tani uni c̱iki moŋkush mo. A’di c̱iki mo jin mishu gwo ’ban ki ’kwani kun tekela/ tekel mo. ");
INSERT INTO udu_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ki ’twa/ jin ḵa’du/ mo tani aha/ miikina shir shir mo, haali/ aha/ ’koshkina ṯe/ gom gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Ṯuki /e ’kup̱ki aha/ mo dhali miiyi mii ka ’the gom aha/ mo, me’d jin boṯa /e ki miim pini ’kup̱ ki uni gwansan kun enki gway pini mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Dhuyi sho’k pem dhali ŋaṯgin pem mmodosh ki seele/ mo isi ki gwom pini jin ona /e is mo, dhali dhalku/ ki dhal toŋ kamu/ jin ’coḵa’coḵ bway mo mmota tap̱a ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Wani aha/ ’ba/ mo ’peni mo jin sirica ’kwani aha/ ap̱o/ ki sho’k mo, ki aha/ mina ’taki dhu gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Kari bwam/em pini mmokush mo mo ap̱o/ c̱iŋkinam pini mo, dhali ṯori aha/ gwo gom gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Em pem yuki jabu’th ki haw haw mo haali/ ’kwani ’koki dhu gwoŋḵan pini jin c̱inu mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Aḵar/e itana /e mo, ayy Tap̱a, dhali /e tana ḵar/e ki gwon dwall pini jin toru gwon dwall ’twa/a ’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","/E dhuki gwonyc̱im pini ’pen ka pije/ mo e mii ma ḵar/e mo dhali eya ris mii ma isiŋ ganam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Anyor pem shwaki aha/ mo haali/ uni kun ta ’kup̱ ki aha/ mo tani uni ŋaki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Gwom pini jin ona /e is mo tani a’di nyo/u ki nyo/ gana/ mo, dhali c̱iŋkinam pini enki a’di mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Aha/ gwa’da ki gwa’d mo dhali waḵkunu mo, hili aha/ dinaki ŋa gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Mii ma ḵar/em pini uni itana ḵar/e ki sule/ sule/ mo, dhali gwoŋḵan pini jin c̱inu mo tani a’di ita jiŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Monṯo’c bwa dhali mo jin ’pe’du/ she/ mo uni p̱u’dkina p̱o/ aha/ mo, hili gwoŋḵan pini kun ’kwarkunu mo tani uni ita kum pem kun ’kunyka/ bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Gwonyc̱im pini uni tana ḵar/e ki sule/ sule/ mo. C̱iyi aha/ mo jin mishu gwo ’ban mo ki aha/ mina di ki e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Ka dum pemi ’baar mo tani aha/ gwokina mo. Thoḵi aha/ ’twa/ mo ma, ayy Tap̱a mo. Aha/ mina dhu gwoŋḵan pini kun bahu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Aha/ gwona ’twa/ i /e mo. Tayi aha/ is ki me’d mo ki aha/ mina ’taki mii gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Aha/ cukina mis mmosul mon’twash/e bway mo dhali ko gom mowoṯẖ mo. Aha/ tana gi mo ma ’teŋ kap̱e/ e gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Em pem di’d ki e ki wal wal mo mmotim mo gi mon’thiny ki mombwam/e mo ki aha/ mina ’taki kulum gwo ibwa gom gwom pini jin ona /e is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Ciḵi ’twa/ pem mo e mo/en pini jin ṯelu sho’k mo, ayy Tap̱a, e mii ma ḵar/em pini mo tani ’tashi mondiki/em pem ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Uni pamki mo ki is ki ’dish ’dish mo uni gun ṯo’cki aha/ bwa mo ki to kun ta thus ki thus ’te/ ka kar ’kup̱ mo. Uni si’dasi’d ’peni gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Hili /e a’di i’disha’dish mo, ayy Tap̱a, dhali aris gwoŋḵan pini ’baar kun ’kwarkunu mo tani uni ta kuŋ gana/ mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","’Peni kadhamoonnii mo tani aha/ mishkina gwonyc̱im pini mo ki /e ḵa’bki uni ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Hili monṯo’c bwam pem mo dhali ’cuḵ aha/ mo haali/ aha/ dinaki ŋa gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Woṯẖi/ gwo is gom tom pem jin raḵaa/ mo dhali wani aha/ ’ba/ mo. C̱iyi aha/ mondiki/e isi ki gwom pini jin ona /e is mo. ");
INSERT INTO udu_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Bway gi mowoṯẖ a’di si’dasi’d ’peni a’di jin ta thus ki thus mo be haali/ uni ’koki simm gwoŋḵan pini kun bahu e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Dhan momiimiim pini a’di caaca mo, ayy Tap̱a. C̱iyi aha/ mondiki/e isi ki gwo gi mii ma ḵar/em pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","’Kwani tana ris ka ris kun ta imanṯo’c aha/ bwa mo dhali ta imanta ’kup̱ ki aha/ mo, hili aha/ dinaki gu is mo ’peni gwonyc̱im pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Aha/ hila mo ki hil ap̱o/ uni kun dar gi gwo jin gamu is mo dhali o gwo waḵ mo, haali/ uni ’koki dhu gwoŋḵan pini jin ḵana /eya ḵan mo. ");
INSERT INTO udu_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Hili isi gwo i e mo ma. Gwoŋḵan gi ’twam pini si’da/ enka/ kata mo. ’Tashi mondiki/em pem ’twa/ mo isi ki gwo gi mo/en pini jin ṯelu sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Gumm gwom pini a’di ita gwoŋ gana/ mo dhali aris gwoŋḵan pini kun onu ’baar ka ’deṯe/ ’deṯe/ mo tani uni ita kuŋ ḵar/e mo dhali uni ’dimki ’kup̱ ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Iya/ ma maliḵ uni ṯo’cki aha/ bwa ka wuny is kan mo, hili adum pem doshki’d ki moŋḵo/ is gom gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Aha/ ’kunykina bwa e gwom pini mo mmowa e ki jan ’de/ jin gamki dhan to jin caaca jin dilu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Aha/ shina shi/ i e mo dhali ’te bwa ki gwon thus mo, hili aha/ ena gwoŋḵan pini jin c̱inu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Me’di pesu/ ka tee mo tani aha/ maŋkina /e mo goma ḵar/em pini jin tana /e gom gwoŋḵan pini kun onu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Dhan moŋḵu’th is jin caaca tana uni gwansan kun enki gwoŋḵan pini jin c̱inu mo. To p̱iyi’d jin midi kol uni mo. ");
INSERT INTO udu_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Aha/ tana gi mo ma ’teŋ kap̱e/ gom bway gi mowoṯẖ pini mo, ayy Tap̱a, dhali aha/ miina gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Aḵashiram pem dhu gwonyc̱im pini mo. Aha/ ena uni ki en jin shi/ashi/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Aha/ dhuna gwoŋḵan gi ’twam pini mo dhali gwonyc̱im pini mo, haali/ aris bway pemi ’baar mo tani uni ’koni bwambori /e mo be. ");
INSERT INTO udu_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Dhalki gwom pem p̱u’dki’di bwambori /e mo, ayy Tap̱a. C̱iyi aha/ mo jin mishu gwo ’ban isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Dhalki tom pem jin ’thoka/ ka di’b is p̱u’dki’di bwambori /e mo. ’Cuḵi aha/ mo isi ki gwom pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","’Twa/ pem midi wol mo jin maŋuwa maŋ mo ki /e ṯorki aha/ gwoŋḵan pini kun baha /e mo. ");
INSERT INTO udu_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Ale’d pem midi yuḵ gway gom gwom pini mo haali/ aris gwoŋḵan pini ’baar kun ’kwarkunu mo tani uni ta kuŋ gana/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Dhalki me’d pini thoson is mo mmowoṯẖ aha/ mo haali/ aha/ kwanykina gwoŋḵan gi ’twam pini mo. ");
INSERT INTO udu_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Aha/ ’koshkina ṯe/ gom bway gi mowoṯẖ pini mo, ayy Tap̱a, dhali gwoŋḵan pini jin c̱inu mo tani a’di ta jim pem jin ’kunyka/ bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Dhalki aha/ dina ki e mo ki aha/ mina maŋ /e mo dhali dhalki gwoŋḵan pini kun onu woṯẖ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Aha/ yakina per mo me’d ḵa’bal jin thiski e mo. Simmi c̱iŋkinam pini e mo, haali/ aha/ dinaki ŋa gwoŋḵan pini kun ’kwarkunu mo. ");
INSERT INTO udu_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","E mo ma c̱is mo tani aha/ gwokina ’twa/i Tap̱a mo, ki a’di midi ’taki thoḵ aha/ ’twa/ mo. ");
INSERT INTO udu_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","’Cuḵi aha/ mo, ayy Tap̱a, ’peni ’twa/ pem jin ta’da ṯor mo, dhali ’pena le’d pem jin he’kki’da he’k e mo. ");
INSERT INTO udu_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Ata a’di iminu c̱i /e mo? Dhali tonta a’di iminu mii gom /e mo, /e jin tana le’d jin he’kki’da he’k e mo? ");
INSERT INTO udu_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Athop̱a/ jin kaaka jin ḵala wathi/ ma mee nyaḵka ’cila’th o’d jin shwa’d ki bar bar mo ’peni cwa jin wana e ka shilgwalish mo. ");
INSERT INTO udu_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Wayyi e aha/ ki aha/ yakina yanyc̱a/ e Pam Maashik mo, ki aha/ c̱a’bkina e bwaman gu’b burrinye/ ma Gidar mo. ");
INSERT INTO udu_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Ki rash rash mo tani aha/ c̱a’bkina e bwaman uni gwansan kun shi/ki moŋḵu’th isi e mo. ");
INSERT INTO udu_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Aha/ tana gom moŋḵu’th is mo, hili ki aha/ okina gwo mo tani uni ŋap̱kina nyor mo. ");
INSERT INTO udu_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Aha/ ’deka em pem ’kup̱ ki wosh kun turatur mo. ’Peni mana imina woṯẖ pem ip̱u’du/ mo? ");
INSERT INTO udu_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Mowoṯẖ pem p̱u’dki’d ’peni Tap̱a mo, a’di jin uḵki momis dhali mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","A’di midi diki dhal sho’k pini bway ki a’di minu joc̱ mo, a’di yan jin kar /e mo tani mina e diki ’ce’d mo. ");
INSERT INTO udu_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Hili mo mo ma, a’di jin dhu ’Kwani ma Israyiil mo tani a’di mina e diki ’ce’d mo walla midi diki ish e mo. ");
INSERT INTO udu_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Tap̱a a’di ita’da mankar /e mo. Tap̱a a’di ita’da la goma bim poros pini mo. ");
INSERT INTO udu_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Atente/ midi diki ’kosh /e montee mo walla appe midi diki ’kosh /e mon’thiny mo. ");
INSERT INTO udu_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Tap̱a midi kar /e ’pena ris tonthusi ’baar mo. A’di midi kar mondiki/em pini mo. ");
INSERT INTO udu_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Tap̱a a’di imidi kara kar mo gom yam pini jin mina /e ya ka pije/ mo dhali kul pini jin mina /e kulu/ ka nyaŋ’ko’d mo, ’pena tee yansan mo dhali ki sule/ sule/ ya ye ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Aha/ ’bora bwa ki ’bor mo mmo/ona uni aha/ gwo mo ki: Dhalki ana iina gu’b gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Sho’k bam uni doshkin mo e bwaman ma goŋ pini mo, ayy Urushaliim. ");
INSERT INTO udu_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Urushaliim, a’di nyaŋkunu mo mmota ’peŋkuman bampa/ mo a’di jin shokunu ki me’di monṯal ’de/ mo, ");
INSERT INTO udu_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","e mo jin iikin ma waḵ gi ’kwani ’kup̱ ki mis mo, uni kun tana waḵ gi ’kwani gi Tap̱a mo, me’d gi gwoŋḵan jin ’kawurkunu mo goma Israyiil mo mmoc̱i mo jin ’boruwa ’bor bwa i is ki gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Aḵursi ma maliḵ gom gwon dwall jin toru gwo ’twa/a ’cesh mo tani uni dhukunu imun mo, aḵursi ma maliḵ gom gu’b ma Dawuu’d mo. ");
INSERT INTO udu_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","’Thoyi gom moŋḵu’th is gi Pa Urushaliim mo. Dhalki uni rusa/ rus mo, uni kun enki /e mo. ");
INSERT INTO udu_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Dhalki mo ma ḵu’th is di’d eya goŋ ma gaŋgaram pini mo dhali mo ma ’dantar e bwaman mom pini kun tura e ki tur mo. ");
INSERT INTO udu_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Gom gway gi iwaḵ pem mo dhali uni kun nyaḵ ii ki aha/ mo tani aha/ mina o gwo mo ki: Moŋḵu’th is midi di e bwam um mo. ");
INSERT INTO udu_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Gom gway gi gu’b gi Tap̱a Arumgimis bana mo, aha/ mina simm tom ’boro’d pini e mo. ");
INSERT INTO udu_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","E /e mo tani aha/ ’deka em pem ’kup̱ ki mis mo, ayy /e jin dikin eya ḵursi ma maliḵ e momis mo. ");
INSERT INTO udu_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Hili mo mo ma, me’d jin hila e gi c̱iŋkina/ me’d gi tap̱am buni mo, dhali me’d jin hila e gi nyara/ me’d ma yim jin karu mmohil c̱iŋkina/ nyara/ mo tani wakan em bana si’da/ hil ’kup̱ ki Tap̱a Arumgimis bana mo, ntagi a’di midi miimii ap̱o/ ana mo. ");
INSERT INTO udu_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Miiyi mii ap̱o/ aman mo ma, ayy Tap̱a, miiyi mii ap̱o/ aman mo haali/ aman tana ga dhana waḵ jin uri ’kup̱ mo ba/. ");
INSERT INTO udu_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Ki rash rash mo tani aḵashiram bam ’tu’dkunu mo ki mo jin ṯẖunyu aman ’twa/ i is mo ki uni gwansan kun ’ko ki ’ko ’penkap̱an mo, ka waḵ buni uni gun dhu is buni ki ca mo. ");
INSERT INTO udu_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Waḵki/ a’di midi diki ’taki ta Tap̱a jin di’di ’ko’d gwar bana mo tani, dhalka Israyiil o gwo mo shwane/ – ");
INSERT INTO udu_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","waḵki/ a’di midi diki ’taki ta Tap̱a jin di’di ’ko’d gwar bana mo shwane/ ki ’kwani ’kon mmocu mis ap̱o/ ana mo, ");
INSERT INTO udu_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","dhali yan’ko’d uni mini ’taki los ana ki ’kolo’c ki e mo, ka nyor buni jin ’thakina uni ap̱o/ ana mo. ");
INSERT INTO udu_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Dhali yan’ko’d agannu/ yi’de/ midi ’taki dhi’th ana sho’k ka pupush mo, dhali yi’de/ jin mishi’da ŋwac̱a/ midi ’taki kum ana ’twa/a ’cesh mo, ");
INSERT INTO udu_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","dhali yan’ko’da p̱o/ ana mo tani yi’de/ jin wuluski eŋ ḵuthar mo. ");
INSERT INTO udu_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Mom’bor mii gom Tap̱a mo, a’di jin diki c̱i ana ki shem buni mmo’kwar mo. ");
INSERT INTO udu_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Ana yekina me’d ’dii ’pena gume/ ma mancesh to jin cesha a’di to mo, dhala gume/ ’ce’dki bwa mo dhali ana yekina mo. ");
INSERT INTO udu_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Mowoṯẖ bana a’di diki’d e gway gi Tap̱a mo, a’di jin uḵki momis dhali mony’cesh mo. ");
INSERT INTO udu_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Uni gwansan kun gami gwo is e Tap̱a mo tani uni wana e ki ’Kuwosh ma Sihyuun mo, a’di jin molu joc̱ mo, hili a’di c̱a’bki’d ki sule/ sule/ ya ye ’ba/ mo. ");
INSERT INTO udu_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Me’da ris wosha turga/ kun ’kamki Pa Urushaliim is mo, wakan si’da/ Tap̱a midi ’kam ’kwanim piti is mo, ’pena tee yansan gana/ mo dhali ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Dhali cwa ma maliḵ gom uni kun ta thus ki thus mo tani midi diki di mo ap̱o/ mony’cesh jin karu gom ’kwani kun tana ḵar/e mo, isi ciki/ uni gun dhunu ka ḵar/e mini dhu me’d buni mmotham to mii mo. ");
INSERT INTO udu_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Miiyi ki ’bore/ mo, ayy Tap̱a, gom uni gwansan kun ’bora’bor mo, dhali gom uni gwansan kun dhelel ma dum buni ki dhelel mo. ");
INSERT INTO udu_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Hili uni gwansan kun ṯu’kkin mo e bway buni kun wanycara/ wanycar mo tani Tap̱a midi shu uni bway nyaḵki uni gun mii to kun ta thus ki thus mo. Moŋḵu’th is midi di goma Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Ki Tap̱a warki’da shamaneṯṯan ma Sihyuun is mo tani ana wana e ki uni gwansan kun shu’bki jan mo. ");
INSERT INTO udu_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Yan’ko’d ’twam bana ’tu’dkunu ki piny piny ki momp̱e’th mo, dhali ale’d bana a’di ḵumki cuuwa/ gom moŋ’kuny bwa mo. Dhali yan’ko’d uni oki gwo e bwaman kal gi ’kwanin tiya mo ki: Tap̱a miiki dhan to jin caaca gom uni mo be. ");
INSERT INTO udu_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Tap̱a miiki dhan to jin caaca gom ana mo be. Ana ’borkina bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Wara shamaneṯṯan bam is mo ma, ayy Tap̱a, mmowa e ki boṯan yi’de/ e mo ma Januub mo. ");
INSERT INTO udu_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Dhalki uni gwansan kun si to ki kony jabu’th mo tani dhalki uni ’ciṯẖ to ki cuuwa/ jin ḵumu/ ki bwaŋ ’kunyka/ mo. ");
INSERT INTO udu_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","A’diyin jin yaki gwolu/ mmoḵal emen to mmosi mo tani midi kulu/ bway pa ki cuuwa/ jin ’thera a’di ki bwaŋ ’kunyka/ mo, mmoḵali cwalman maman to jin sina a’di mo. ");
INSERT INTO udu_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Isi ciki/ waḵki/ Tap̱a midi nyaŋ gu’b yan mo tani uni gwansan kun nyaŋ a’di mo tani uni miikina ṯu’c ki p̱e’th mo. Isi ciki/ waḵki/ Tap̱a ki tima p̱o/ ’peŋkuman bampa/ mo tani amantim mo mo tani diki’d ki e ki p̱e’th mo. ");
INSERT INTO udu_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","A’di ta miim p̱e’th be ki /e mini cu mis ki jahanne/ mon’thamo/ mo, dhali c̱a’b mmota adiiṯe/ mmosi/is mo, dhali mmoshwa tonṯe/ mo ’peni mii jin miinu a’di ki mo/anan is mo, haali/ a’di c̱iki unim piti kun ena a’di mo tani mo/ish e mo. ");
INSERT INTO udu_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Hili mo mo ma, iya/ gi ’kwani uni ta mal ’peni Tap̱a mo, maman ’peni bwa ma dho’th mo tani a’di i/ishki ḵumma/ mo. ");
INSERT INTO udu_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Me’da thop̱a/ e me’d ma man/as mo tani a’di wana e ki iya/ gi uni gun ta dhuru’c ki dhuru’c mo. ");
INSERT INTO udu_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Mom’bor mii gom wathi/ jin ’tu’dki’da kulp̱em piti ki uni mo. A’di minu ’koki kar ki mo ma ’the is mo ki a’di midi ṯora ṯor ka ris ’kwaniŋ ’kup̱ piti mo e ’twaŋkala goŋ mo. ");
INSERT INTO udu_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Mom’bor mii goma ris uni ’baar ka ’deṯe/ ’deṯe/ kun ḵo/ki Tap̱a mo, a’di jin yaki’d e bway piti mo. ");
INSERT INTO udu_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","/E mini shwa maman cwa ma ṯu’c ki me’d pini mo, dhali /e mina bwa ’bor mo, dhali a’di midi ha me’d gom /e mo. ");
INSERT INTO udu_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Ashim pini a’di mina e waki cwa jin dho’th maman mo e bwaŋ gu’b pini mo. Uc̱im pini uni mina e waki cwa seṯuun kun ’kan ki biṯẖi/ biṯẖi/ mmo’kama tharabeesam pini is mo. ");
INSERT INTO udu_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Hili mo mo ma, wakan wathi/ minu ’bor mii mo, a’di jin ḵo/ki Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Tap̱a ’borki /e mii mo ’pena Sihyuun mo. Dhalki /e p̱ari mo jin midi rusa/ rus e gom Pa Urushaliim mo ka risa tee gi mondiki/em pini ’baar mo. ");
INSERT INTO udu_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Dhalki /e hili uc̱i gi uc̱im pini mo. Moŋḵu’th is midi di ap̱owa Israyiil mo. ");
INSERT INTO udu_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Ka daran duŋ gana/ mo tani uni wo’cki aha/ is she/ mo ’peni dhuru’c pem jin taka/ mo, dhalka Israyiil o gwo wakan shwane/ mo – ");
INSERT INTO udu_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Ka daran duŋ gana/ mo tani uni wo’cki aha/ is she/ mo ’peni dhuru’c pem jin taka/ mo, hili uni ’koki p̱i gwo jip̱i/ ap̱o/ aha/ mo. ");
INSERT INTO udu_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Imangora ’cesh uni gorkina ’cesha p̱owa p̱om pem mo. Dhali uni dherki gwan’thim buni ki tur tur mo. ");
INSERT INTO udu_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Tap̱a a’di ta’da ḵar/e mo. A’di ’ciṯẖki’da shi/ gi ’kwani kun ta thus ki thus bwa mo. ");
INSERT INTO udu_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Dhalki uni gwansan kun shi/kina Sihyuuni e mo tani dhunu ki mo ma ’the is mo dhali dhuwa bor ki tar mo. ");
INSERT INTO udu_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Dhalki uni wana e ka shoŋ ’kuŋgu’b mo kun ḵu’thkin mo iṯwa/a/ ki uni ’koki ca mo, ");
INSERT INTO udu_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","a’di jin din ma man’ciṯẖ to ki ’tu’d me’d piti mo, walla aman’de’k cwalman maman to ki ḵala bor piti mo, ");
INSERT INTO udu_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","ki ’kwani gwansan kun iin mo mmope a’di mo tani ’koki o gwo mo ki: Mom’bor mii gi Tap̱a midi di ap̱o/ /e mo. Aman ’bora /e mii ki gway gi Tap̱a mo. ");
INSERT INTO udu_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","’Peni mo jin ’kula’kul mo tani aha/ gwokina ’twa/ e /e mo, ayy Tap̱a. ");
INSERT INTO udu_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Tap̱a, ciḵi ’twa/ pem mo ma. Dhalki ’cem pini c̱i’da hirdhe/ mo ki ’twa/ pem jin ’thoka/ to ka di’b me’di is mo. ");
INSERT INTO udu_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Ayy Tap̱a, waḵki/ /e mini ’taki nyiṯẖa ris mony’coḵka/ mo tani Tap̱a, kaja a’di imidi dosh mo? ");
INSERT INTO udu_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Hili mo jin gwamkina /eya gwam mo tani di’d e /e mo, ki /e a’di minu ’taki ḵo/ moyi. ");
INSERT INTO udu_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Aha/ c̱orkina Tap̱a mo, aḵashiram pem c̱orki’da c̱or mo dhali e gwom pini mo tani aha/ tana ga ’teŋ kap̱e/ mo. ");
INSERT INTO udu_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Aḵashiram pem c̱orki Tap̱a mo mmobola ris ’kwani kun thimki mon’thamo/ e mo, mmobola ris ’kwani kun thimki mon’thamo/ e mo. ");
INSERT INTO udu_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Ayy Israyiil, tayi gi mo ma ’teŋ kap̱e/ e Tap̱a mo. Haali/ gom Tap̱a mo tani mo/en jin ṯelu sho’k diki’d mo dhali e a’di mo tani mo ma enthus jin wanuwa wan ’ba/ ishki’d mo. ");
INSERT INTO udu_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Dhali a’di midi wana Israyiil ’ba/ mo ’pena ris miim piti kun ’coḵa’coḵ mo. ");
INSERT INTO udu_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Ayy Tap̱a, adum pem ’konuki ’de’k ki mis mo dhali em pem ’konuki ’de’k ’kup̱ ki mo jin ḵa’dama/ ḵa’dam gara/ be. Buŋgwar is pem diki jar e ki dhan to kun caaca gara/ mo dhali ki to kun ta to mer gom aha/ gara/ mo. ");
INSERT INTO udu_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Hili aha/ c̱a’bkina ki dwam mo dhali kara ḵashiram pem ki shwamm mo, me’da ’ci jin karkina kum ki shwamm mmoc̱iya ko eya bor piti mo. Me’da ’ci jin karkunu ki shwamm mo tani aha/ kara ḵashiram pem ki shwamm mo be. ");
INSERT INTO udu_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Ayy Israyiil, tayi gi mo ma ’teŋ kap̱e/ e Tap̱a mo ’peni mo yansan shwane/ mo dhali ki sule/ sule/ mo. ");
INSERT INTO udu_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Kayi gwo e mo ma, ayy Tap̱a, goma ’the goma Dawuu’d mo, aris to ’baar mo kun ’batha’ba’th kun ’dimkina a’di ’kup̱ mo, ");
INSERT INTO udu_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","ba a’di thulki gwo me’da p̱o/ e Tap̱a mo dhali o gwo is ki A’di ma Dem Dem ma Yakuub mo, mmo/o gwo mo ki: ");
INSERT INTO udu_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Aha/ mina mol cic̱ gu’b pem mo, walla ish eya p̱owa cim pem mo, ");
INSERT INTO udu_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","dhali aha/ mina diki c̱i is pem ki e mmo/ish mo, walla dhal moŋ’ko’d em pem bway mmo’ce’d e mo, ");
INSERT INTO udu_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","ntagi aha/ mina gam mo gom Tap̱a mo, mo jin mina A’di ma Dem Dem ma Yakuub ic̱a’b mo. ");
INSERT INTO udu_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Hili mo mo ma, aman ciḵkina gwo mo ’pena Ap̱raatah, dhali aman gamkina a’di mo e bwam bunto ma Waar mo. ");
INSERT INTO udu_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Dhalki ana iina mo e mom piti jin c̱a’ba a’di mo. Dhalki ana luŋa a’di e cwam piti jin dhuna a’di sho’k mo. ");
INSERT INTO udu_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Cuyi mis mo ma, ayy Tap̱a, dhali yayi mo e mom pini jin mina /e ishi/ is mo, /e dhali Sanduuḵ gi mo ma dem dem pini mo. ");
INSERT INTO udu_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Dh