﻿USE sofia;
DROP TABLE IF EXISTS sofia.udi_vpl;
CREATE TABLE udi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES udi_vpl WRITE;
INSERT INTO udi_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Burqesunast'a Buxačuğon süft'ə göyə q'a oç̌alane yaratmişi. ");
INSERT INTO udi_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dünyə ams'inaxunal ams'iney. Oç̌ali ç̌oyel bakala bə̌ğə̌loy xeyurxoy loxolal bayinq'luğaxun q'erəz hik'k'al buteney, saycə Buxačuğoy nəfəse hari taysay t'e xeyurxoy loxol. ");
INSERT INTO udi_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Buxačuğon pine: «Barta işiğq'an baki». İşiğal baneki. ");
INSERT INTO udi_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Buxačuğon anek'i ki, işiğ şaat' şeye, eçeriyal şot'o bayinq'luğaxun cöyebi. ");
INSERT INTO udi_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Şot'in işiği s'iya \"ğenaxun\", bayinq'luği s'iya isə \"üşene\" laxi. Biyənebaki, oşa saal işiğe biti - mo samci ği. ");
INSERT INTO udi_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Oşa Buxačuğon pine: «Barta xene qı̌yo alaq'an laśi, me p'ə̌ xeyurxo sunaxun cöybseynak'al içoğoy arane zahmanq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Haketərəl baneki, Buxačuğon havinaxun bakala sa zahman yaratmişi xeyurxoy qǐt'u me zahmanaxun ala, qǐt'uval oq'ane efi. ");
INSERT INTO udi_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Buxačuğon me zahmani s'iya \"göye\" laxi. Biyənebaki, oşa saal işiğe biti - mo p'ə̌mci ği. ");
INSERT INTO udi_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Oşa Buxačuğon pine: «Barta göye oq'a bakala xeyurxo sagala gireśeq'an ki, q'ariluğq'an ak'eśi». Haketərəl baneki. ");
INSERT INTO udi_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Buxačuğon q'ariluği s'iya \"oç̌al\", gireśi xeyurxoy s'iya isə \"dənizxone\" laxi. Buxačuğon anek'i ki, mo şaat'e. ");
INSERT INTO udi_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Oşa Buxačuğon pine: «Barta oç̌ali ç̌oye bitk'iyoxq'an c'eri: iz śil iz loxol bakala oyurxoxun burqi śilurxo iz c'ek'ala meyvin boş bakala hər cür xodurxol śirik'». Haketərəl baneki. ");
INSERT INTO udi_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Oç̌alen bitk'iyoxe əmələ eçeri: iz śil iz loxol bakala oyurxoxun burqi śilurxo iz c'ek'ala meyvin boş bakala hər cür xodurxol śirik'. Buxačuğonal anek'i ki, mo şaat'e. ");
INSERT INTO udi_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Biyənebaki, oşa saal işiğe biti - mo xibimci ği. ");
INSERT INTO udi_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Oşa Buxačuğon pine: «Barta göynul üşe işiğ sakseynak' cöy, ğenaxun işiğ sakseynak' cöy çırağq'an baki, barta şot'oğon useni mi xaşurxo q'a gam xaşurxo, ğimxoy boxoybaksuna q'a gödəybaksuna, useni burqsuna q'a çarksunaq'at'un ak'est'i. ");
INSERT INTO udi_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Barta şorox göynul bok'ala çirağ baki oç̌ali ç̌oyel işiğq'at'un saki». Haketərəl baneki. ");
INSERT INTO udi_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Buxačuğon p'ə̌ dənə kala çirağe yaratmişi. Kalat'in ğenaxun c'eri kalaluğbaley, samal mis'ik't'in isə üşe. Şot'in hamal muč'uliğone yaratmişi. ");
INSERT INTO udi_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Oşa Buxačuğon şot'oğo göynul t'ak'epi ki, oç̌ali ç̌oyel işiğq'at'un saki. ");
INSERT INTO udi_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Şot'oğonal burt'unqi hərt'in içeynak' laxeśi vədine c'eri şünə ğenaxun, bayinq'luğa işiğaxun cöybsa. Buxačuğonal anek'i ki, mo şaat'e. ");
INSERT INTO udi_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Biyənebaki, oşa saal işiğe biti - mo bip'imci ği. ");
INSERT INTO udi_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Oşa Buxačuğon pine: «Barta xeyurxo hari iz boş elmux bakala cürbəcür heyvanxon buybakeq'an, barta oç̌ali ç̌oyelxun ala, göynul q'uşurxoq'an purpi». ");
INSERT INTO udi_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Buxačuğonal kakala çəliyox q'a xene boş ǰalk'ala hər cür heyvanxone yaratmişi, göynul purpes bakala hər cür q'uşurxoval yaratmişebi. Buxačuğon anek'i ki, mo şaat'e. ");
INSERT INTO udi_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Oşa şot'oğo xeyir-bərəkət tadi pine: «Avuzbakanan, gelebaki dənizi xeyurxo buybanan, barta q'uşurxoval gelebakeq'an». ");
INSERT INTO udi_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Biyənebaki, oşa saal işiğe biti - mo qomci ği. ");
INSERT INTO udi_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Oşa Buxačuğon pine: «Barta oç̌ali ç̌oyel hər cür heyvanq'an baki: beliğoxun q'a eğelxoxun burqi xoreğala heyvanxoxun q'a çöle bakala hər cür ə̌qnə heyvanxol śirik'». Haketərəl baneki. ");
INSERT INTO udi_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Buxačuğon hər cür ə̌qnə heyvan, beliyox q'a eğelxo saal oç̌ali ç̌oyel xoreğala cürbəcür heyvanxone yaratmişi. Buxačuğonal anek'i ki, mo şaat'e. ");
INSERT INTO udi_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Oşa Buxačuğon pine: «Yallarik' saal yax oşq'ardala amdar yaratmişen. Barta şot'in dənizi boş bakala çəliğoy, göynul purk'ala q'uşurxoy, oç̌ali ç̌oyel tarak'ala q'a xoreğala bito heyvanxoy saal oç̌ali iziyal loxol kalaluğq'anbi». ");
INSERT INTO udi_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Metərluğen, Buxačuğon amdare yaratmişi, şot'o İçu oşq'are yaratmişi. Buxačuğon ham çuux, ham işq'are yaratmişi. ");
INSERT INTO udi_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Buxačuğon şot'oğo xeyir-bərəkət tadi pine: «Avuzbakanan, gelebaki oç̌ali ç̌oya buybanan. Dənizi boş bakala çəliğoy, göynul purk'ala q'uşurxoy, oç̌ali ç̌oyel tarak'ala q'a xoreğala bito heyvanxoy q'a oç̌ali iziyal loxol kalaluğbanan». ");
INSERT INTO udi_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Oşa Buxačuğon pine: «Mone, oç̌ali ç̌oyel iz śil iz loxol bakala bito oyurxoxun q'a śilurxo iz c'ek'ala meyvin boş bakala bito xodurxoxun çuki ukalnan və̌n. ");
INSERT INTO udi_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","İz boş nəfəs taśi eğala heyvanxoy bitot'in isə, göynul purk'ala q'uşurxon, oç̌ali ç̌oyel tarak'ala q'a xoreğala k'ə heyvan bunesa bitot'in, göyün oyaxun ukale». Haketərəl baneki. ");
INSERT INTO udi_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Buxačuğonal anek'i ki, İz yaratmişi hər şey gele şaat'e. Biyənebaki, oşa saal işiğe biti - mo ǔqǔmci ği. ");
INSERT INTO udi_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hametər, Buxačuğon göyə q'a göynul bakalt'oğo, oç̌ala q'a oç̌ali ç̌oyel bakalt'oğo bitova yaratmişi çarek'i. ");
INSERT INTO udi_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Buxačuğon me ǔq ğinast'a İz biq'ala əşurxo bitova çark'i vǔğǔmci ğine isə İçu əşlə tene duği. ");
INSERT INTO udi_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Buxačuğon vǔğǔmci ğina xeyir-bərəkət tadi şot'o t'iyə̌mi ğimxoxun üst'üne laxi, şot'o görə ki, t'e ği İzi me yaratmişbsuni əşurxo çark'i dincəyinşakala ğine baki. ");
INSERT INTO udi_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Q'ončux Buxačuğon göyə q'a oç̌ala yaratmişbsun metəre bakey. Q'ončux Buxačuğon göyə q'a oç̌ala yaratmişat'an ");
INSERT INTO udi_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","oç̌ali ç̌oyel nə sa dənə xod uk'ala şey tene buy, nəəl sa dənə göyün o, şot'o görə ki, Q'ončux Buxačuğon oç̌ali loxol hələ ağala tene śipey. Oç̌ala bəcərişes bakala amdaral tene yaratmişey hələ. ");
INSERT INTO udi_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Saycə oq'axun c'eğala xene lafst'ay oç̌ala. ");
INSERT INTO udi_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Q'ončux Buxačuğonal eçeri k'ulaxun amdare düzbi. Şot'ay bǒxmǒğoxun fupi İzi elmux tadala nəfəsəne bapi şot'ay boş, amdaral diriləyinşebaki. ");
INSERT INTO udi_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Oşa Q'ončux Buxačuğon běğc'eğala tərəf bakala Edena sa gane lasaki, eçeriyal İzi yaratmişi amdara t'iya arśevek'i. ");
INSERT INTO udi_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Q'ončux Buxačuğon t'etəre bi ki, t'e ganu cürbəcür xodure c'eri: ham içoğoy loxol běğat'an ük' qayeğala, hamal içoğoy c'ek'ala meyvoğo çuki ukes bakala. Gane bı̌yex isə yəşəyinş tadala xode buy saal şaat'-pis k'ə baksuna avabakest'ala xod. ");
INSERT INTO udi_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Me Eden uk'ala ganuxun oqe taysay, me oç̌ala xe duğsun c'ovaki taśiyal bip' galane cöybaksay. ");
INSERT INTO udi_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Me cöybaki tağala oqe sunt'ay s'i Pişone, manu ki, dirist' Xavila bölginəxune c'ovaki taysa. Miya hələ q'ızılal baneksa, ");
INSERT INTO udi_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","içal şaat' q'ızıle miyanin q'ızıl. Me bölginə xodurxoxun c'eğala şaat' adeğala mətəl baneksa, oniks uk'ala toyexlu ǰěyal. ");
INSERT INTO udi_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","P'ə̌mci oqe s'i Gixone. Şo K'uş bölginəxune c'ovaki taysa. ");
INSERT INTO udi_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Xibimci oq T'igre, şo Aşşur uk'ala şəhəri běğc'eğala tərəfəxune c'ovaki taysa. Bip'imciyo isə Yevfrat uk'ala oqe. ");
INSERT INTO udi_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Q'ončux Buxačuğon amdara me Eden ganu arśeveki ki, şot'o əşp'i běğeq'an. ");
INSERT INTO udi_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Q'ončux Buxačuğon amdara metəre tapşurbi: «Ganu bakala bito xodurxoy meyvinəxun çuki ukes bankon, ");
INSERT INTO udi_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","saycə şaat'a q'a pisa avabakest'ala xodin meyvinəxun başq'a. T'e xodin meyvinəxun çuki uksunen bisun eçale». ");
INSERT INTO udi_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Oşa Q'ončux Buxačuğon metəre pi: «Amdari savsa baksun şaat' tene, barta şot'aynak' içuxun biq'ala soğo yaratmişaz, iz kula alabeq'an». ");
INSERT INTO udi_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Q'ončux Buxačuğonal eçeri oç̌ali k'ulaxun bito ə̌qnə heyvanxo q'a göynul purk'ala q'uşurxone yaratmişi. Oşa şot'oğo amdari t'ǒğǒle eçeri ki, běyn şot'oğo hetər s'iya tast'a, amdarenal şot'oğo hetər s'i tanedisa, şorox hat'etərəl k'aleśi. ");
INSERT INTO udi_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hametər, amdaren k'ojin heyvanxoy, göynul purk'ala q'uşurxoy saal ə̌qnə heyvanxoy bitot'u s'ine tadi, ama me heyvanxoy boşt'an içuxun biq'ala, iz kula alabes bakala köməyçi tene bə̌ğə̌yeśi. ");
INSERT INTO udi_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","T'e vədə Q'ončux Buxačuğon t'etəre bi ki, amdara bə̌ğə̌loy nep'ene taşeri, nep'ax vədineyal şot'ay t'ok'mašin sunt'u c'evk'i iz ganu yeq'en but'ek'i. ");
INSERT INTO udi_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Q'ončux Buxačuğon me t'ok'mašinaxun çuux düzbi şot'o amdari t'ǒğǒle eçeri. ");
INSERT INTO udi_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Amdarenal pine: «İsə pes bazkon ki, İz ǔq'en bez ǔq'enaxun, İz yeq' bez yeq'axun bakalt'u bə̌ğə̌zbi. Barta ko çuuxq'an k'aleśi, Şot'o görə ki, işq'araxune haq'eśe». ");
INSERT INTO udi_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Mot'o görəne oşa işq'ar iz bava-nanaxun cöybaki iz çuğo ğaç̌eśi, p'ǒğǒ sa bədən baki. ");
INSERT INTO udi_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adamal, iz t'ǒğǒl bakala çuuxal çuplaxt'un taraney, ama içoğost'a ot' buteney. ");
INSERT INTO udi_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Q'ončux Buxačuğon yaratmişi bito heyvanxoxun ən bic'o dizik'ey. Dizik'en çuğo pine: «Düze ki, Buxačuğon və̌x ganu bakala xodurxoxun çuki ma ukanan pene?» ");
INSERT INTO udi_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Çuğon qaybaki dizik'ə metəre pi: «Təə, yan bito xodurxoxun çuki ukes bayankon, ");
INSERT INTO udi_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","saycə gane bı̌yex bakala xodin meyvinəne piyo ki, ma ukanan. Pene sal ef kula boxodi şot'o galmadanan, tene biyalnan». ");
INSERT INTO udi_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","T'e vədə dizik'en çuğo metəre pi: «Hik'k'alal biyalatenan! ");
INSERT INTO udi_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Buxačuğon avane ki, t'e xodin meyvoğoxun ukala ğine efi pulmux qayeğale, şaat'a q'a pisa q'amişakiyal İçullarik' bakalnan». ");
INSERT INTO udi_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Çuğon běneği ki, xodin meyvoox şaat' ukalane, içoğoy loxol běğat'anal amdari ük'e taysa, hələ sa amdara gele q'amişakalal bes baneksa. Metər fikirbiyal, t'e xodin meyvoğoxun soğo çuki kəye, oşa iz işq'aral soğo tanedi, şot'inal kəye. ");
INSERT INTO udi_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hat'e saad p'rannat'ayal pulmux qayeśi içoğoy memaçağ nu q'amişakala şeyurxot'un q'amişaksa burqi. Bět'unği memaçağ çuplaxt'un tarape, eçeriyal incilnə xazalxo suna ğaç̌p'i içoğoy běšt'an but't'unki. ");
INSERT INTO udi_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Biyəsç̌oye sərin sa muşene duğsa burqi, şot'oğonal Q'ončux Buxačuğoy ganu tarapsuni səsət'un ibaki. Adam q'a iz çuux t'it'eri xodurxoy bač'ane c'ap't'unbaki. ");
INSERT INTO udi_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Q'ončux Buxačuğon Adama k'alpi pine: «Mayanu?» ");
INSERT INTO udi_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adamenal qaybaki metəre pi: «Ganu Vi eysuni səse laft'i bez ǔmǔğo, zuval çuplağzu pi q'ı̌bi c'ap'ezbaki miya». ");
INSERT INTO udi_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Buxačuğon pine: «Va şine pi ki, çuplağnu? Bezi va uksuna q'adağanbi xodin meyvinəxunen kəyo?» ");
INSERT INTO udi_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adamenal qaybaki \"Vi za tadi me çuğone za t'e meyvinəxun çuki tadi, zuval kəyiz\" pine. ");
INSERT INTO udi_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","T'e vədə Q'ončux Buxačuğon çuğo pine: «Het'u görən metər əş biq'i hun?» Çuğonal qaybaki \"dizik'ene za yaq'nuxun c'evk'i, zuval kəyiz\" pine. ");
INSERT INTO udi_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Q'ončux Buxačuğonal dizik'ə pine: «Q'arğişi q'ončux bakalnu hun vi biq'i me əşlə görə, bito k'ojin q'a ə̌qnə heyvanxoy boş ən piyexun bitiyo bakalnu! Tapani loxol xoreśi vi ömüri axıral śirik' k'ul ukalnu hun. ");
INSERT INTO udi_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Zu va q'a çuğo düşmən booz sunaxun, vaxun bakiyorox q'a çuğoxun bakiyoroxal düşmən bakalt'un. Şot'ay əylen vi bula duǧi č'ak'k'ale, hunal şot'o dabanexun duğalnu». ");
INSERT INTO udi_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Çuğo isə Buxačuğon metəre pi: «Əzyət zapest'oz va hun bı̌hi tarak'at'an, q'ač' zapsun əyel eçalnu hun. İşq'araxun ğaç̌ bakalnu, şot'inal vi loxol kalaluğbale». ");
INSERT INTO udi_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Oşa Buxačuğon Adamane İzi əyitə pi: «Çuğoy əyitə běği Bezi va q'adağanbi xodaxunen çuki kəyi hun! İsə mone, vi biq'i me əşlə görə oç̌alal q'arğişi q'ončuxe baksa! İsə me oç̌alen tadala bara ukes bakseynak' üşe-ğena əşp'alnu hun vi ömüri axıral śirik'. ");
INSERT INTO udi_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Śaś q'a il c'eğale oç̌ali ç̌oyel, saycə vi bit'i ganuxun exp'i ukala bakalnu hun. ");
INSERT INTO udi_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ap' śipi vi sa loq'ma šuma ukalnu hun, axırdal k'ule oq'a tağalnu, mayin haq'eśenusa t'iya. Şot'o görə ki, k'ulaxunen haq'eśe hun, k'ula gərbakiyal tağalnu». ");
INSERT INTO udi_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamen iz çuğoy s'iya Yevane laxi, şot'o görə ki, süft'ə əyel eçeriyo şone baki, metərluğenal oç̌ali ç̌oyel yəşəyinşala amdarxoy bitot'ay nanane hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Q'ončux Buxačuğon Adameynak' q'a iz çuğoynak' t'olaxun paltar düzbi şot'oğo lapesedi. ");
INSERT INTO udi_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Oşa Q'ončux Buxačuğon pine: «Mone, amdaren şaat'a q'a pisa q'amişaki Beşi cörginəne baśi. Ama iz kula boxodi yəşəyinş tadala xodin meyvinəxun nu ukalane kot'in, həmişəluğ nu yəşəyinşalane». ");
INSERT INTO udi_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Q'ončux Buxačuğonal amdara Eden ganuxun şəp'eśi ki, barta isə taśi iç haq'eśi t'e k'ule loxol əşp'i şot'o becərişeq'an. ");
INSERT INTO udi_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Amdara şəp'eśit'uxun oşa Buxačuğon t'e Eden uk'ala gane běğc'eğalaç tərəf angelxo q'a bok'osp'i s'ik'ala q'ılınce laxi ki, yəşəyinş tadala xod bakala ganu q'orişat'un. ");
INSERT INTO udi_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamen iz çuux Yevaxun ı̌šaluğebi, Yeval bǐhi baki sa ğare eçeri. Yevan me əylin s'iya K'ayin laxi pine: «Mone, əyel eçeri sa amdar běšez baki zu, Buxačuğone bi mot'o». ");
INSERT INTO udi_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","K'ayinaxun oşa Yevan şot'aynak' sa viçiyal eneçeri, iz s'iyal Avele laxi. Avel eğel běğale baki, K'ayinen isə oç̌ali loxole əşpsay. ");
INSERT INTO udi_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sa heq'ədər vədə hari c'ovaneki, K'ayinenal Q'ončuğoynak' izi becərişi oç̌alen tadi baraxun paye eçeri. ");
INSERT INTO udi_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Avelen isə iz sürünə bakala heyvanxoy süft'in baloğoxun, şot'oğoxun c'eri c'əyinəx ganxone pay eçeri. Şot'ay biq'i me əş Q'ončuğoy ük'el basek'i, Q'ončuğonal Aveli eçeri me paya q'abulebi. ");
INSERT INTO udi_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","K'ayini eçeri paya isə Q'ončuğon tene q'abulbi, K'ayinenal əcuğon biq'i iz k'odoğo śinepi. ");
INSERT INTO udi_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Q'ončuğon K'ayina pine: «Vi əcuğon het'u görəne biq'e? Het'aynak'en vi k'odoğo śipe hun? ");
INSERT INTO udi_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Əgər haq' galan vi k'odoğo śipesa, vi ç̌oya tez axšumdon ki Zu? Ama metər bi vi boş ǰalenst'asa, vi ük'e xal baft'ene upsune. Günaxen va iz kiyel bast'une çuresa, ama hun şot'oxun zorba bakalanu ki, va ı̌ša bites nu bakane». ");
INSERT INTO udi_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Sa ğiyal K'ayinen iz viçi Avela \"eki çöle tağen\" pi haq'i çölene taśi. T'iya p'ap'iyal Aveli loxol taśi şot'o besebi. ");
INSERT INTO udi_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","T'e vədə Q'ončuğon K'ayinaxun xavare haq'i: «Vi viçi Avel maya?» Şot'inal qaybaki \"k'əz ava, viçey q'aroola zap'k'alzu zu?\" pine. ");
INSERT INTO udi_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Q'ončuğon pine: «K'ən bi hun? Vi viçey p'iyan śipi, isəəl t'e p'iyen muz qaypi Zane k'ale, \"bezi həyifə haq'a\" nexe. ");
INSERT INTO udi_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mone, q'arğişi q'ončuxen baki hun, vi kiin śipi viçey p'iya q'uc'p'i oç̌alenal va irapedi. ");
INSERT INTO udi_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Meyin oşa hun oç̌ala becərişalbayin şot'in va hik'k'al tene tadal. Vi k'ojaxun-mesaxun bakalnu hun, ömüri axıral śirik' dədərgün bakalnu». ");
INSERT INTO udi_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","K'ayinen Q'ončuğo pine: «Me caza bezi zapes bakalt'uxun bı̌hine baki. ");
INSERT INTO udi_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Za həysə şəp'ensa me oç̌alaxun, zuval Vi piin běšt'an aç̌oz, bezi k'ojaxun-mesaxun baki dədərgün bakoz. Ama memiin c'eysun q'a za şinesa biq'i bespsun sa bakale». ");
INSERT INTO udi_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Q'ončuğon isə qaybaki metəre pi: «Ketər tene, va besp'alt'uxun Bez əcuğo vǔğ q'at haq'oz!» Metər piyal Q'ončuğon K'ayini loxol nišane laxi ki, şot'ay loxol kul alabi iz elmoğo haq'al maq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Metərluğen, K'ayin Q'ončuğoy piin běšt'an aneç̌i, Eden ganuxun běğc'eğalaç taśiyal Nod uk'ala ganune yəşəyinşbsa burqi. ");
INSERT INTO udi_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","K'ayinen iz çuğoxun ı̌šaluğebi, çuuxal bǐhi baki Xanok'ane eçeri. T'e vədə K'ayinen sa şəhəre biq'say, eçeriyal me şəhəri s'iya iz ğare s'iyaxune laxi, yəni Xanok'. ");
INSERT INTO udi_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Xanok'axun İrade baki. İradaxun Mehuyael uk'ala ğare baki. Mehuyaelaxun Met'uşaele baki. Met'uşaelaxunal izi ğar Lemek'e baki. ");
INSERT INTO udi_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek'en p'ə̌ çuuxe haq'i: sunt'ay s'i Ada, t'e sunt'ay s'i Śillaney. ");
INSERT INTO udi_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adan ğare eçeri, iz s'i Yaval. Eğel q'a beli běği iz sürüğoynak' şaat' otarişala ga bə̌ğə̌bit'uxun oşa iz çadıral hat'e gala laxi yəşəyinşalo süft'ə hame Yavale baki. ");
INSERT INTO udi_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yavali sa viçiyal buney, iz s'i Yuval. Me Yuval isə ən süft'ə arfa q'a t'üt't'əy farpiyone bake. ");
INSERT INTO udi_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lemek'i Śillaxun baki ğare s'i isə T'uval-K'ayiney. Şo dəmir t'ap'k'aley. Dəmirə q'a tunca xebit'uxun oşa şot'oğo t'api hər cür ət't'əc düzbiyo süft'ə hame T'uval-K'ayine bake. Şot'ay sa xunçiyal buney, iz s'i Naama. ");
INSERT INTO udi_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Sa ği Lemek'en iz çupuxxo k'alpi pine: «Ay Ada q'a Śilla, ǔmǔxlaxanan! Ay Lemek'i çupuxxo, ibakanan k'əz nex! Bez loxol kul alabsun çureğalt'ay elmoğoz haq'on zu, Za duğsun çureğala cəyilə besezbon! ");
INSERT INTO udi_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","K'ayina görə vǔğ q'at əcuğ haq'eğalesa, Lemek'a görə yetmiş vǔğ q'at haq'eğale». ");
INSERT INTO udi_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamen p'urum iz çuğoxun ı̌šaluğebi, iz çuux Yevanal sa ğar eçeri iz s'iya Şet'e laxi. Şot'in metəre pi: «K'ayinen besp'i Aveli gala Buxačuğon za me ğarane pay tadi». ");
INSERT INTO udi_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Şet'e izi ğar bakat'an isə şot'ay s'iya Enoşe laxi. Amdarxon Q'ončuğoy s'iya duği afırıpsunal hame vədəmoğone burqeśi. ");
INSERT INTO udi_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Moval Adamaxun bakit'oğoy siyəyi. Buxačuğon amdara yaratmişat'an şot'o İçu oşq'are yaratmişi. ");
INSERT INTO udi_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Buxačuğon ham işq'ar, ham çuuxe yaratmişi, şot'oğo xeyir-bərəkət tadi içoğoy s'iya yaratmişi ğinaxun \"amdare\" laxi. ");
INSERT INTO udi_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adami sabaç̌ otuz yəş bakat'an şot'ay sa ğare baki. Me ğar içu sa ěša p'ə̌ ganu cöybi k'inək' oşq'arey. Adamen şot'ay s'iya Şet'e laxi. ");
INSERT INTO udi_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Şet' bakit'uxun oşa Adam hələ sa muğbaç̌ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam biyat'an izi düz vuybaç̌ otuz yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Şet'e sabaç̌ qo yəş bakat'an iz ğar Enoşe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enoş bakit'uxun oşa Şet' hələ sa muğbaç̌ vǔğ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Şet' biyat'an izi düz vuybaç̌ p'as's'e yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoşi doxsan yəş bakat'an iz ğar Kenane baki. ");
INSERT INTO udi_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan bakit'uxun oşa Enoş hələ sa muğbaç̌ qos's'e usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoş biyat'an izi düz vuybaç̌ qo yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani yetmiş yəş bakat'an iz ğar Mahalalele baki. ");
INSERT INTO udi_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel bakit'uxun oşa Kenan hələ sa muğbaç̌ q'ırx usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan biyat'an izi düz vuybaç̌ vis' yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli altmış qo yəş bakat'an iz ğar Yerede baki. ");
INSERT INTO udi_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yered bakit'uxun oşa Mahalalel hələ sa muğbaç̌ otuz usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel biyat'an izi düz muğbaç̌ doxsan qo yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yeredi sabaç̌ altmış p'ə̌ yəş bakat'an iz ğar Xanok'e baki. ");
INSERT INTO udi_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Xanok' bakit'uxun oşa Yered hələ sa muğbaç̌ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yered biyat'an izi düz vuybaç̌ altmış p'ə̌ yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Xanok'i altmış qo yəş bakat'an iz ğar Met'uşelaxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Met'uşelax bakit'uxun oşa Xanok' hələ sa xibbaç̌ usenal yəşəyinşebi. Şo Buxačuğo çalxi Şot'in içu pi k'inək' yəşəyinşalt'oğoxuney. Xanok'i q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Xanok' xibbaç̌ altmış qo usen yəşəyinşebi. ");
INSERT INTO udi_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Xanok' Buxačuğoy s'iya duği Şot'in içu pi k'inək' yəşəyinşalt'oğoxuney, sa ğiyal şo hat'etər aneç̌i, şot'aynak' ki, Buxačuğon şot'o me dünyənexun bisuni k'ə baksuna avabakinut ext'i İz t'ǒğǒle taşeri. ");
INSERT INTO udi_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Met'uşelaxi sabaç̌ səksən vǔğ yəş bakat'an iz ğar Lemek'e baki. ");
INSERT INTO udi_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemek' bakit'uxun oşa Met'uşelax hələ sa vǔğbaç̌ səksən p'ə̌ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux q'a xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Met'uşelax biyat'an izi düz vuybaç̌ altmış vuy yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemek'i sabaç̌ səksən p'ə̌ yəş bakat'an şot'ay sa ğare baki. ");
INSERT INTO udi_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lemek'en ğare s'iya Noy laxi pine: «Me ğaren yax ük' tadale, Q'ončuğon İz q'arğişp'i me oç̌ali loxol əzyət zapi ap' śipsuni əvəzə tadale». ");
INSERT INTO udi_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noy bakit'uxun oşa Lemek' hələ sa qobaç̌ doxsan qo usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemek' biyat'an izi düz vǔğbaç̌ yetmiş vǔğ yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noye qobaç̌ yəş bakat'an şot'ay me ğarmuxe baki: Şem, Xam saal Yafet'. ");
INSERT INTO udi_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Oç̌ali ç̌oyel amdarxo taysun avuzebaksay. Şot'oğoy xuyərmuxe baksay, ");
INSERT INTO udi_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","alaxunbitit'oğonal ak'at'an ki, me xuyərmux gele gözəle, burt'unqi hərt'in iz çureğalt'u c'ək'p'i şot'oğo içoğoynak' çuux bsa. ");
INSERT INTO udi_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","T'e vədə Q'ončuğon pine: «Bezi amdarxoy boş bapi şot'oğo yəşəyinşest'ala nəfəs həmişəluğ tene, əfçibaki tağala bədənəxun q'erəz hik'k'al tet'un korox. Şot'o görəl sabaç̌ q'a usen vaxt'ez tast'a kot'oğo». ");
INSERT INTO udi_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","T'e döörəst'ə, lap oşal, oç̌ali ç̌oyel kakala, burux k'inək' amdarxone buy. Morox amdarxoy xuyərmoğoy alaxunbitit'oğoxun baki əyluxey. Şorox gele zorbat'uniy, içoğoy s'iyal dünyəne hələ hazar usenxoxun oşal t'ap'esay. ");
INSERT INTO udi_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Q'ončuğon běneği ki, oç̌ali ç̌oyel bakala amdarxo düz yaq'axun c'eri t'etərt'un bake ki, içoğoy vǔğ fikir suna pisluğbsune. ");
INSERT INTO udi_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Oç̌ali ç̌oyel amdar yaratmişi arśevksuni axıra metər ak'iyal gele pise baki, mot'o görə İz ük' q'ač'p'i ");
INSERT INTO udi_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","pine: «Bez me oç̌ali ç̌oyel yaratmişi arśevk'i amdarxo əfçiboz Zu! Şot'oğoxun barabar oç̌alin ç̌oyel tarak'ala q'a xoreğala k'ə heyvan, göynul purk'ala k'ə q'uş bunesa şot'oğoval əfçiboz, şot'o görə ki, pěšmanebi Za Bezi yaratmişit'oǧon». ");
INSERT INTO udi_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ama oç̌ali ç̌oyel Q'ončuğoy piyes şaat' ak'eğala tək sa amdare buy, şoval Noyey. ");
INSERT INTO udi_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Moval Noye bel hariyorox: Həysə exlət tağala me döörəst'ə oç̌ali ç̌oyel bakala amdarxoy boş düzgün, noxsansuz bakalo tək hame Noyey, şo Buxačuğo çalxi Şot'in içu pi k'inək' yəşəyinşalt'oğoxuney. ");
INSERT INTO udi_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noye xib ğare buy: Şem, Xam saal Yafet'. ");
INSERT INTO udi_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Buxačuğoy piyexune biti oç̌al, irit'epi Şot'in amdarxoy biq'ala pis əşurxo ak'i. ");
INSERT INTO udi_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Buxačuğon běneği amdarxo t'emane düz yaq'axun c'eri pisluği bač'anexun taysa ki, dünyənə murdarluğen haq'ene tanesa. ");
INSERT INTO udi_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","T'e vədə Buxačuğon Noya pine: «Oç̌ali ç̌oyel bakala amdarxoy bitot'u tumexun əfçiboz Zu, şot'o görə ki, içoğoy biq'ala pis əşurxon buye me oç̌al. Şot'oğoxun sagala me oç̌ali ç̌oyel k'ə bunesa bitova əfçiboz. ");
INSERT INTO udi_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hun isə vaynak' xe nu tərbala daxt'ak'axun but' sa gəmi düzba, iz boş otağxoval bakeq'an. Gəminə bonaxunal, ç̌oyexunal q'ir duğa. ");
INSERT INTO udi_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Şot'o metər düzba: izi boxoyluğ xibbaç̌ ə̌m, gengluğ əlli ə̌m, alloyluğal otuz ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Gəminə alaxun t'etər but'k'a ki, hərrəmine sa ə̌m ga işiğ bist'eynak' qayq'an mandi, börinexun ç̌omoval laxa. Gəmin boşt'an xib q'atq'an baki: oq'in, bı̌ğin saal alin. ");
INSERT INTO udi_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mone, Zu t'etər booz ki, oç̌ala xenen ç̌axk'ale, me dünyəne iz boş nəfəs taśi eğala k'ə bunesa k'as'eğale. Oç̌ali ç̌oyel bakalorox bito əfçibaki tağale. ");
INSERT INTO udi_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ama vaxun sa irəziluğez ğaç̌esa Zu, vi ğarmoğo, vi ğarmoğoy çupuxxo q'a vi çuğoval ext'i me vi düzbi gəminə bağalnu hun. ");
INSERT INTO udi_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","İnsanaxun q'erəz iz boş elmux bakala k'ə bunesa şot'oğoxunal hərt'uxun sa çüt, yəni sa ərkəy, sa dişi vaxun ext'alnu. Ext'alnu ki, şoroxal vaxun sagala dirist' mandeq'at'un. ");
INSERT INTO udi_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Oç̌ali ç̌oyel tarak'ala q'a xoreğala k'ə heyvan, göynul purk'ala k'ə q'uş bunesa, şot'oğoxun hərt'uxun sa çüt ext'i bağalnu ki, şoroxal maq'at'un p'uri. ");
INSERT INTO udi_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Və̌ynak' ukun, şot'oğoynak'al gelecə yem ext'a, t'etər ba ki, ukunaxun q'idluğ nu zapk'anan». ");
INSERT INTO udi_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noyenal bitova Buxačuğon içu pi k'inək' bine. ");
INSERT INTO udi_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Q'ončuğon Noya pine: «Vi külfətəl ext'i gəminə baki; oç̌ali ç̌oyel bakala amdarxoy boş saycə hunen Bez piyes düzgün ak'eśi. ");
INSERT INTO udi_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Gəminə bağat'an Bezi və̌x uksuna icaza tadi, halal hesabbakala heyvanxoxunal hərt'uxun vǔğ çüt, yəni sa ərkəy, sa dişi, vaxun ext'a. Bezi və̌x uksuna icaza nu tadi, haram hesabbakala heyvanxoxun isə hərt'uxun sa çüt ext'a. ");
INSERT INTO udi_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Q'uşurxoxunal hərt'uxun vǔğ çüt, yəni sa šumak' q'a sa dadal, ext'a. Barta kot'oğoy śil maq'an əfçibaki. ");
INSERT INTO udi_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Zu t'etər booz ki, vǔğ ğinaxun oşa q'ırx ği-q'ırx üşe ağala eğale, oç̌ali ç̌oyel Bezi yaratmişi k'ə bunesa əfçibakale». ");
INSERT INTO udi_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noyenal bitova Buxačuğon içu pi k'inək' bine. ");
INSERT INTO udi_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Oç̌ala xenen ç̌axk'at'an Noye ǔqbaç̌ yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Xenen içoğo maq'an taşeri pi, şot'in iz çuğo, ğarmoğo saal ğarmoğoy çupuxxoval ext'i izi düzbi gəminəne baśi. ");
INSERT INTO udi_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Buxačuğon içu tapşurbi k'inək', şot'in gəminə bağat'an halal q'a haram heyvanxoxun, göynul purk'ala q'uşurxoxun, oç̌ali loxol xoreğala heyvanxoxunal bitot'uxun çüt-çüt exedi, hərt'uxun sa ərkəy, sa dişi. ");
INSERT INTO udi_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Vǔğ ğinaxun oşa oç̌ala xenen ç̌axpsane burqi. ");
INSERT INTO udi_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noye ǔqbaç̌ yəş baki t'e useni p'ə̌mci xaşe vǔğes's'emci ğine oç̌ali oq'a bakala xeyure posp'i c'eri, göyurxoy q'a oç̌ali ǰomone ə̌meśi, ");
INSERT INTO udi_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","oç̌ali loxolal q'ırx ği-q'ırx üşe biq'i lağala ağalane hari. ");
INSERT INTO udi_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Oç̌ala xenen ç̌axp'i t'e ğinene Noyen iz çuğo, izi ğar Şema, Xama, Yafet'a saal xib bina ext'i gəminə laśi. ");
INSERT INTO udi_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Gəminə lağat'an şot'in içuxun sagala oç̌ali loxol tarak'ala q'a xoreğala heyvanxoy bito cürəxun saal göynul purpes bakala q'a purpes nu bakala q'uşurxoxunal bitot'uxun exedi. ");
INSERT INTO udi_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Noyen Buxačuğon içu tapşurbi k'inək' oç̌ali ç̌oye iz boş nəfəs taśi eğala k'ə bunesa bitot'uxun çüt-çüte ext'i - sa ərkəy, sa dişi. Şorox gəminə bat'unśi, Buxačuğonal gəmin ç̌omo şot'oğoy bač'anexun but'ek'i. ");
INSERT INTO udi_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Oç̌ala düz q'ırx ği xenene ç̌axp'i. Oç̌ali ç̌oyel xe gelebaksunen gəmi ěqesane burqi, ");
INSERT INTO udi_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","hariyal t'emane baki ki, gəmi lap alloy ěqeśi xene ç̌oyel manedi. ");
INSERT INTO udi_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hari buybaki xene kiyexun oç̌ali ç̌oyel bakala buruxmuğoy bul tene ak'esay. ");
INSERT INTO udi_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Xene oq'ane mandey şorox bito, ən alloy buruxmoğoxun hələ sa q'os's'e ə̌mal alloye ěqeśey xe. ");
INSERT INTO udi_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Oç̌ali ç̌oyel iz boş elmux bakala k'ə bunesa - q'uşurxo, k'ojin q'a ə̌qnə heyvanxo, xoreğala heyvanxo saal amdarxoy bito k'as'eśi. ");
INSERT INTO udi_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","İz boş nəfəs taśi eğala k'ə bunesa, oç̌ali loxol bakalt'oğoy bito k'as'eśi baredi. ");
INSERT INTO udi_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","K'ə bunesa bito - amdarxo, oç̌ali loxol tarak'ala q'a xoreğala heyvanxo, q'uşurxo! Nə sa dənə amdar, nəəl sa dənə heyvan tene mandi. Saycə Noy q'a şot'oxun sagala gəminə baśiyoroxe dirist' mandi. ");
INSERT INTO udi_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Düz sabaç̌ əlli ğiyal oç̌ali loxol bakala xe tene zap'eśi. ");
INSERT INTO udi_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ama Buxačuğon Noya q'a Noyaxun sagala gəminə bakala bito t'e k'ojin q'a ə̌qnə heyvanxo İzi eyexe badi. T'e vədə Buxačuğon oç̌ali loxol muşe yaq'abi, xeyal bureqi zap'esa. ");
INSERT INTO udi_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Oç̌ali q'a göyurxoy ǰomone but'eśi, ağalal bot'ebaki. ");
INSERT INTO udi_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Xe oç̌ali ç̌oyexun zap'esane burqi. Xenen ç̌axpsuni düz sabaç̌ əllimci ğiney, xe malbaksane burqi me ği. ");
INSERT INTO udi_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Vǔğǔmci xaşe vǔğes's'emci ğineyal gəmi hari Ararat buruğoy bel t'ə̌q'eśi çurepi. ");
INSERT INTO udi_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Vis'imci xaşal śirik' xe mal-mal zap'eśi, vis'imci xaşe samci ğineyal buruxmoğoy bulurxone ak'esa burqi. ");
INSERT INTO udi_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Q'ırx ği c'ovakit'uxun oşa Noyen gəmin boş düzbi aynina qaypi ");
INSERT INTO udi_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","sa ğə̌ynəne tərbi. Ğə̌ynəl purpi, ama p'urum qaybaki enesay, şot'o görə ki, xe oç̌ali ç̌oyexun tam tene zap'eśey. ");
INSERT INTO udi_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Oşa Noyen xe oç̌ali ç̌oyexun tam zap'eśi-nu zap'esuna avabakseynak' sa göyərçine tərbi. ");
INSERT INTO udi_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ama göyərçin purpit'uxun oşa içeynak' arśala ga nu bə̌ğə̌bi qaybaki hare, şot'o görə ki, oç̌al hələl xene boşey. Noyenal iz kula boxodi göyərçinə iz kiyele arśest'i, şot'o p'urum gəminəne ext'i. ");
INSERT INTO udi_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Vǔğ ğinaxun oşa Noyen saal göyərçinə tərebi. ");
INSERT INTO udi_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Göyərçin biyəsç̌oyene qaybaki, iz dündük'i boşal təzə sa zeytuni xazale buy! Metər Noyen q'amişebaki ki, xe oç̌ali ç̌oyexun zap'eśene. ");
INSERT INTO udi_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Vǔğ ği yaq'běğit'uxun oşa Noyen saal göyərçinə tərebi, me dəfə göyərçin sal qaytenebaki. ");
INSERT INTO udi_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noye ǔqbaç̌ sa yəş tamambaki useni samci xaşe samci ğinast'a oç̌ali ç̌oye bakala xe zap'eśi. Noyen gəmin loxolxun qayepi, iz bula c'evk'iyal běneği ki, oq'a xe tene mande. ");
INSERT INTO udi_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","P'ə̌mci xaşe saq'ovǔğǔmci ğine isə oç̌al dirist' q'arinebaki. ");
INSERT INTO udi_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","T'e vədə Buxačuğon Noya pine: ");
INSERT INTO udi_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Vi çuğo, vi ğarmoğo q'a ğarmoğoy çupuxxoval ext'a gəminəxun c'eki. ");
INSERT INTO udi_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Vaxun gəminə ext'i heyvanxoval bitova c'evk'a: oç̌ali ç̌oyel tarak'ala q'a xoreğala heyvanxo, q'uşurxo. Barta şorox avuzbakeq'at'un, barta gelebaki oç̌ali ç̌oya buybeq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noyenal iz çuğo, iz ğarmoğo, iz ğarmoğoy çupuxxoval ext'i gəminəxun c'ere. ");
INSERT INTO udi_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","İz bač'anexun gəminə bakala heyvanxoval bito soğo-soğo c'ert'un: iz boş elmux bakala k'ə heyvan bunesa bito, oç̌ali loxol tarak'ala q'a xoreğala heyvanxoxun burqi q'uşurxol śirik'. ");
INSERT INTO udi_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Oşa Noyen sa q'urban eçala gane düzbi, halal hesabbakala heyvanxoxun q'a q'uşurxoxun bitot'uxun šampiyal Q'ončuğoynak' bok'ospsuni q'urbane eçeri. ");
INSERT INTO udi_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Bok'ala yeq'e aden ala laśi Q'ončuğo irəzinebi, Şot'inal İz ük'e boş metəre pi: «Ene sal sa vədə oç̌alen amdarxoy biq'ala əşurxo görə q'arğiş tene ukal. Düze, amdaren iz pula qaypsun q'a pis yaq'en taysun sane baksa, ama ene sal sa vədə mot'o görə iz boş elmux bakalt'oğo tez əfçibal Zu. ");
INSERT INTO udi_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Heq'ədər ki, me oç̌al iz galane, Bist'un q'a expsunal bakale, Gamluğ q'a çaxluğal. Yəy çark'i ı̌ǰenal bağale, Üşe q'a ğenaxunal iz gala bakale». ");
INSERT INTO udi_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Buxačuğon Noya metər pi xeyir-bərəkəte tadi: «Avuzbakanan, gelebaki oç̌ali ç̌oya buybanan. ");
INSERT INTO udi_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Oç̌ali loxol tarak'ala q'a xoreğala k'ə heyvan, göynul purk'ala q'uşurxo q'a dənizi boş bakala k'ə çəli bunesa, bitot'ay loxol və̌n kalaluğbalnan. Zap'eğalt'un şorox bito və̌xun, pula haq'alnan və̌n şot'oğoy. ");
INSERT INTO udi_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bito heyvanxoxun ukes banankon, zu və̌x oç̌ali ç̌oyel c'eğalt'oğoxun uksuna icaza tadi k'inək', isəəl me heyvanxoy yeq'axunez uksuna icaza tast'a. ");
INSERT INTO udi_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ama p'i iz boşt'an nu bari yeq' umakanan, şot'o görə ki, p'i yəşəyinş upsune. ");
INSERT INTO udi_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ef p'iya śik'alt'oğoxunal həyifə haq'oz Zu, t'iyə̌mit'ay elmoğo haq'suni cazina zapest'oz, çuresa mo amdarq'an baki, çuresa heyvan. ");
INSERT INTO udi_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","İçu oşq'are yaratmişe Buxačuğon amdara, şot'o görəl amdar besp'i şot'ay p'iya śik'alt'ay elmoğoval t'esunt'in p'i śipi haq'ale. ");
INSERT INTO udi_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Avuzbakanan, gelebaki oç̌ali ç̌oya buybanan, bartanan ef say gelebakeq'an». ");
INSERT INTO udi_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Oşa Buxačuğon Noya q'a iz ğarmoğo metəre pi: ");
INSERT INTO udi_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Mone, və̌xun q'a və̌xun bakit'oğoxun sa irəziluğez ğaç̌esa Zu. ");
INSERT INTO udi_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Və̌xun sagala gəminəxun c'eri k'ə heyvan bunesa, şot'oğoxunal ğaç̌ezsa me irəziluğa: oç̌ali ç̌oyel tarak'ala q'a xoreğala k'ə heyvan, göynul purk'ala k'ə q'uş bunesa bitot'uxun. ");
INSERT INTO udi_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Və̌x əyitez tast'a ki, ene sal sa vədə oç̌ala xenen tene ç̌axk'al, oç̌ali ç̌oyel bakalt'oğo xenen tumexun əfçibsun tene bakal ene». ");
INSERT INTO udi_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Buxačuğon pine: «Bezi həysə və̌x q'a iz boş elmux bakalt'oğoy bitot'u həmişəluğ tadi me əyiti loxol çurpsuna isə efi piin ak'alnan və̌n: ");
INSERT INTO udi_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mone, göynul asoyxoy loxol Bezi murdufaz suruk'psa Zu, şot'in ak'est'ale Bezi və̌x tadi əyiti loxol çurpsuna. ");
INSERT INTO udi_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Hər dəfə Zu göynul asoyxo girbi eçat'an, me murduf c'eğale, ");
INSERT INTO udi_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Zuval Bezi eyex badoz və̌xun q'a iz boş elmux bakalt'oğoy bitot'uxun ğaç̌eśi irəziluğa. Ene sal sa vədə xenen oç̌ala ç̌axp'i iz loxol bakalt'oğoy bitot'u əfçitenebal. ");
INSERT INTO udi_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Me murdufa mot'aynak'ez laxsa: şot'o ak'i oç̌ali ç̌oyel izi boş elmux bakalt'oğoy bitot'uxun ğaç̌eśi me həmişəluğ irəziluğa nu eyexun c'evkseynak'». ");
INSERT INTO udi_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Buxačuğon Noya p'urum pine: «Göynul c'eğala me murduf bakale Bezi iz boş elmux bakalt'oğoy bitot'u tadi əyiti loxol çurpsuna ak'est'alo». ");
INSERT INTO udi_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noye gəminəxun c'eri ğarmux moroxey: Şem, Xam saal Yafet'. Kənan hame Xame ğarey. ");
INSERT INTO udi_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Həysə oç̌ali ç̌oyel bakala azuk'xoyal bito me xibaraxun, Noye me xib ğaraxune əmələ hare. ");
INSERT INTO udi_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noyen oç̌ale becərişbsa burqi, eçeriyal t'ulluğe lasaki. ");
INSERT INTO udi_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sa ği Noyen fi ǔği finağoye baki, şo iz çadıri boş çuplağ bask'eney. ");
INSERT INTO udi_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Xamen, Kənan şot'ay ğarey, iz bava çuplağ ak'i c'eri mot'o iz p'ə̌ viçəl pine. ");
INSERT INTO udi_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Şemen q'a Yafet'en isə içoğoy ə̌mnəbel sa paltar lap't'i, şot'o bač'anexun alabi p'ə̌ belxun biq'it'uxun oşa qoş-qoş çadıra baśi içoğoy bavay çuplağ bədənə but't'unki. Bavay əyibə maq'at'un ak'i pi içoğoy ç̌oya t'e soğo tərəft'un taradey şot'oğon. ");
INSERT INTO udi_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noyen iz finağoyluğ c'ovaki muğurbakit'uxun oşa iz mis'ik' ğaren biq'i əşlə avabaki ");
INSERT INTO udi_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","pine: «Mone, q'arğişi q'ončuxe baki Kənan! İz viçimoğoy k'ulurxoynak'al k'ul bakale şo!» ");
INSERT INTO udi_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Oşa metərəl pine: «Alxışq'an baki Şeme Buxačux bakala Q'ončuğo! Barta Kənan Şeme k'ulq'an baki! ");
INSERT INTO udi_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Barta Buxačuğon Yafet'i oç̌alxo gelebeq'an, barta Yafet'i çadırxoval Şeme çadırxoy t'ǒğǒlq'an laxeśi! Kənaneynak' isə iz viçimoğoy k'ul baksune śameśi». ");
INSERT INTO udi_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Oç̌ala xenen ç̌axp'it'uxun oşa Noy hələ sa xibbaç̌ əlli usenal yəşəyinşebi, ");
INSERT INTO udi_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","biyat'anal izi düz vuybaç̌ əlli yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Moval Noye ğarmoğoxun, Şem, Xam saal Yafet'axun bakit'ǧoy siyəyi. Oç̌ala xenen ç̌axp'it'uxun oşa şot'oğoy ğarmuxe bakey. ");
INSERT INTO udi_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet'i ğarmux: Gomer, Magog, Maday, Yavan, T'uval, Meşek' saal T'iras. ");
INSERT INTO udi_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeri ğarmux: Aşk'enaz, Rifat' saal T'ogarma. ");
INSERT INTO udi_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavani ğarmux: Elişa, Tarşiş, K'it't'im saal Dodanim. ");
INSERT INTO udi_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yavani ğarmoğoxun bakit'oğon dənizi börine bakala oç̌alxot'un məsk'ən sakey. Metərluğen, Yafet'axun əmələ hari azuk'xo moroxey, hər azuk'iyal iz oç̌al, iz muze buy. Azuk' isə şi nəsiləxune əmələ haresa t'e amdari s'iyene taysay. ");
INSERT INTO udi_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Xame ğarmux: K'uş, Misrayim, P'ut' saal Kənan. ");
INSERT INTO udi_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","K'uşe ğarmux: Seva, Xavila, Savt'a, Raama saal Savt'ek'a. Raamay ğarmux: Şeva q'a Dedan. ");
INSERT INTO udi_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","İz śi Nemrud, içust'a nu ak'eśi sa zor bakala saamci amdaral hame K'uşaxun baki azuk'axuney. ");
INSERT INTO udi_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Q'ončuğon şot'o t'etər sa başarağe tadey ki, şot'ollarik' ǒxə̌lbal tene buy. Şot'o görəne amdarxon hələl \"şaat' ǒxə̌lbal\" uk'at'an \"Nemrud k'inək' ǒxə̌lbal\" nex. ");
INSERT INTO udi_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Şot'ay padçağluğa süft'ə Şinar ölkinə bakala me şəhərmuxe buy: Vavilon, Erek', Ak'k'ad saal K'alne. ");
INSERT INTO udi_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ama oşa Aşşur ölkinə köçp'i me şəhərmoğone biq'i: Nineva, Rixovot'-İr saal K'elax. ");
INSERT INTO udi_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Şot'in Ninevin q'a K'elaxi arane Resen şəhərəl lasaneki. K'elax kala şəhərey. ");
INSERT INTO udi_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayimaxun əmələ hari azuk'xo: ludluyox, anamluyox, lehabluyox, naft'uhluyox, ");
INSERT INTO udi_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","p'at'rusluyox, k'aft'orluyox saal oşa içoğoxun filist'luyox əmələ hari k'asluhluyox. ");
INSERT INTO udi_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kənanaxun iz süft'in ğar Sidon, oşa Xet', ");
INSERT INTO udi_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","saal me azuk'xone baki: yevusluyox, emorluyox, girk'asluyox, ");
INSERT INTO udi_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","xivluyox, argluyox, sinluyox, ");
INSERT INTO udi_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ervadluyox, semarluyox saal xamat'luyox. Kənanaxun əmələ hari azuk'xo taysun śaresat'un burqi, ");
INSERT INTO udi_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","içoğoy oç̌alxoval Sidonaxun burqi taśi Gerara bakala Gazal śirik' p'anep'i. Sodom, Homorra, Adma q'a Sevoyimay tərəf bakala oç̌alxo isə Leşal śirik' tanesay. ");
INSERT INTO udi_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Metərluğen, Xamaxun əmələ hari azuk'xo moroxey, hər azuk'iyal iz oç̌al, iz muze buy. Azuk' isə şi nəsiləxune əmələ haresa t'e amdari s'iyene taysay. ");
INSERT INTO udi_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet'i kala viçi Şemeyal əyluxe baki. Everaxun baki everluyox uk'ala azuk'al hame Şemaxun əmələ hariyoroxe. ");
INSERT INTO udi_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Şeme ğarmux: Elam, Aşşur, Arp'ak'şad, Lud saal Aram. ");
INSERT INTO udi_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arami ğarmux: Us, Xul, Geter saal Maş. ");
INSERT INTO udi_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arp'ak'şadaxun Şelaxe baki, Şelaxaxun isə Evere baki. ");
INSERT INTO udi_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Everi izi p'ə̌ ğare baki: sunt'ay s'i P'elegey, şot'o görə ki, şot'ay döörəst'ə amdarxon içoğoy arane oç̌ala dirist' cöy-cöyt'unbi, t'e sunt'ay s'iyal Yok't'an. ");
INSERT INTO udi_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yok't'anaxun Almodad, Şelef, Xasarmavet', Yerah, ");
INSERT INTO udi_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Gadoram, Uzal, Dik'la, ");
INSERT INTO udi_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oval, Avimael, Şeva, ");
INSERT INTO udi_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Xavila saal Yovave baki. Morox bito Yok't'anaxun bakiyoroxey, ");
INSERT INTO udi_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","içoğoxun əmələ hari azuk'xoy oç̌alxoval Meşadaxun burqi běğc'eğalaç bakala Sefar uk'ala burux ganxol śirik' tanesay. ");
INSERT INTO udi_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Metərluğen, Şemaxun əmələ hari azuk'xo moroxey, hər azuk'iyal iz oç̌al, iz muze buy. Azuk' isə şi nəsiləxune əmələ haresa t'e amdari s'iyene taysay. ");
INSERT INTO udi_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Moval Noye ğarmoğoxun bakiyorox q'a şot'oğoy nəsiləxun əmələ hari azuk'xo. Xenen ç̌axp'it'uxun oşa oç̌ali ç̌oyel bakala azuk'xoy bito mot'oğoxune əmələ hare. ");
INSERT INTO udi_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","T'e döörəst'ə dünyəne bakala amdarxoy bitot'in sa muzine əyitey, bitot'inal suna q'amişebaksay. ");
INSERT INTO udi_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Şorox gelebaksunen běğc'eğalaç taśi Şinar oç̌ala p'at'unp'i, hariyal sa qavun ga bə̌ğə̌bi miya məsk'ənt'un saki. ");
INSERT INTO udi_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Sa ğiyal metərt'un pi: «Ekinan nešum k'ulen kərpiç düzbi şot'o yönbəri bok'osp'en». Haketərəl bit'un: şot'oğon ǰěne gala kərpiç, oč'in galal q'irt'un əşp'est'a burqi. ");
INSERT INTO udi_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Oşa metərt'un pi: «Ekinan sa şəhər lasaki iz bı̌yex t'etər sa k'üllə biq'en ki, iz bul taśi göynulq'an p'ap'i. Metər bayan beşi s'i t'ap'eğale, me dünyəne śaralğayan aç̌i teyan batk'al». ");
INSERT INTO udi_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Q'ončuğonal amdarxon biq'ala şəhərə q'a me alloy k'üllinə běğseynak' oq'a śiri ");
INSERT INTO udi_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","pine: «Morox bito amdarxoy sa azuk' k'inək' baki sa muzin əyitpsunaxune. Həysə metərt'un bsasa, oşa k'ə balt'un? Běšinə̌mə haq'es tene bakal mot'oğoy! ");
INSERT INTO udi_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nexzu śiğen mot'oğoy sunaxun əyitk'ala muza cöyben, barta suna maq'at'un q'amişaki». ");
INSERT INTO udi_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Metərluğen, Q'ončuğon t'etəre bi ki, şorox cöybaki dünyəni bip' t'ǒǒx śart'unśi, t'e şəhərəl hat'etər qǔnqǔl manedi. ");
INSERT INTO udi_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","T'e gane s'iyal mot'o görət'un Vavilon laxey, Q'ončuğon miya amdarxoy muza gərgürbi dünyənen sa śarpsuna görə. ");
INSERT INTO udi_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Moval Şemaxun bakit'oğoy siyəyi: Oç̌ala xenen ç̌axp'it'uxun p'ə̌ usen oşa, Şeme düz sabaç̌ yəş bakat'an iz ğar Arp'ak'şade baki. ");
INSERT INTO udi_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arp'ak'şad bakit'uxun oşa Şem hələ sa qobaç̌ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arp'ak'şadi otuz qo yəş bakat'an iz ğar Şelaxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Şelax bakit'uxun oşa Arp'ak'şad hələ sa bip'baç̌ xib usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Şelaxi otuz yəş bakat'an iz ğar Evere baki. ");
INSERT INTO udi_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ever bakit'uxun oşa Şelax hələ sa bip'baç̌ xib usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Everi otuz bip' yəş bakat'an iz ğar P'elege baki. ");
INSERT INTO udi_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","P'eleg bakit'uxun oşa Ever hələ sa bip'baç̌ otuz usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","P'elegi otuz yəş bakat'an iz ğar Reune baki. ");
INSERT INTO udi_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu bakit'uxun oşa P'eleg hələ sa p'ə̌baç̌ vuy usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reuni otuz p'ə̌ yəş bakat'an iz ğar Seruk'e baki. ");
INSERT INTO udi_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruk' bakit'uxun oşa Reu hələ sa p'ə̌baç̌ vǔğ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk'i otuz yəş bakat'an iz ğar Naxore baki. ");
INSERT INTO udi_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naxor bakit'uxun oşa Seruk' hələ sa p'ə̌baç̌ usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naxori saq'ovuy yəş bakat'an iz ğar T'eraxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","T'erax bakit'uxun oşa Naxor hələ sa sabaç̌ vuyes's'e usenal yəşəyinşebi, şot'ay q'erəzəl ğarmux, xuyərmuxe baki. ");
INSERT INTO udi_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","T'eraxi yetmiş yəş bakit'uxun oşa şot'ay me ğarmuxe baki: Avram, Naxor saal Xaran. ");
INSERT INTO udi_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Moval T'eraxi ğarmux: Avram, Naxor saal Xaran. Xarani Lut' uk'ala ğare buy. ");
INSERT INTO udi_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Xaran iç isə hələ iz bava dirist' bakat'an izi nanaxun baki şəhəre, yəni xaldeyluğoy Ur şəhəre p'ure. ");
INSERT INTO udi_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Avram q'a Naxor lašk'oyt'unbaki. Avrami çuğoy s'i Saray, Naxori çuğoy s'i isə Milk'aney. Milk'a Xarani xuyərey, Xarani q'erəz sa xuyərəl buney, iz s'i İsk'a. ");
INSERT INTO udi_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi əyel tene baksay, şo ərəmik'ey. ");
INSERT INTO udi_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","T'eraxen iz ğar Avrama q'a iz bin Saraya saal Xaranaxun baki ğar Lut'a, yəni izi nəvə, ext'i içoğoy bakala xaldeyluğoy Ur şəhərexun c'ere. Şo Kənan oç̌alane taysun çuresay, ama hari Xarrana p'ap'i miyane məsk'ən saki. ");
INSERT INTO udi_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","T'erax düz p'ə̌baç̌ qo usen yəşəyinşi, hame Xarranal p'ure. ");
INSERT INTO udi_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Q'ončuğon Avrama pine: «Vi bakala ganu, vi q'oomxo, vi k'oja-mesa efa hayza Bezi va ak'est'ala oç̌ala taki. ");
INSERT INTO udi_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Zu t'etər booz ki, vaxun kala sa azuk' törəyinşakale, vi s'iya alabi va t'etər sa xeyir-bərəkət tadoz ki, xeyir-bərəkətin k'ə baksuna vast'a ak'alt'un. ");
INSERT INTO udi_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Va xeyir-bərəkət tadalt'uxun Zuval Bezi xeyir-bərəkətə tez kambal, va q'arğişbalt'u isə Zuval q'arğişi q'ončux booz. Oç̌ali ç̌oyel bakala azuk'xoy bitot'in xeyir-bərəkətə vaxun haq'ale». ");
INSERT INTO udi_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Avramenal Q'ončuğon içu pi k'inək' bi t'et'iin c'ere, Lut'al içuxuney. Şorox Xarranaxun c'eğat'an Avrami yetmiş qo yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Avramen iz çuux Saraya, iz viçey ğar Lut'a, izi nökərxo q'a Xarrana əşp'i girbi k'ə bunesa bitova ext'i Kənan oç̌ala yaq'ane baft'i. Şorox Kənan oç̌ala p'ap'it'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Şekema ı̌ša More uk'ala mə̌xnə xodal śirik' taśi çurt'unpi, t'e vədə t'iya kənanluyoxe yəşəyinşbsay. ");
INSERT INTO udi_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Q'ončuğon miya Avrama ak'eśi pine: «Mone, vaxun törəyinşakalt'oğo tadoz me oç̌ala!» Avramenal içuxun əyitp'i Q'ončuğoynak' t'iya sa q'urban eçala gane düzbi. ");
INSERT INTO udi_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Oşa Avram Bet'el şəhəri běğc'eğalaç tərəf bakala buruxmoğone laśi, izi çadırxoval t'iyane laxi çurk'ala baki. Avrami çurpi me gane běğbatk'alaç tərəf Bet'el şəhərey, běğc'eğalaç tərəf isə Ay. Avramen miyal Q'ončuğoynak' q'urban eçala ga düzbi Şot'o bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Oşa Avram yaq'a baft'i p'urum güneyaç, Negev ams'i oç̌al bakala tərəfe taśi. ");
INSERT INTO udi_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Samal oşa Avrami hari me oç̌ala busaluğe burqeśi. Amdarxon içoğoy ukala šuma tet'un bə̌ğə̌bsay, Avramal hayzeri Misirəne tağala baki. ");
INSERT INTO udi_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Hari Misirə p'ap'ala vədine Avramen iz çuux Saraya pine: «Zu avazu ki, hun gözəlnu. ");
INSERT INTO udi_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Misirluğon va ak'i avabakat'an ki, hun bezi çuuxnu, za besp'i va efalt'un. ");
INSERT INTO udi_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Barta va bezi xunçiq'at'un avabaki, t'e vədə va görə zaal tet'un galdal, hər şeyal şaat' bakale». ");
INSERT INTO udi_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Avram hari Misirə p'anep'i, misirluğonal bět'unği ki, Saray gele gözəle. ");
INSERT INTO udi_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Faraoni saraya bakalt'oğonal Sarayi gözəlluğa fikirt'un tadi, taśiyal şot'o faraoni t'ǒğǒl t'ema tərift'unbi ki, Saraya haq'i hart'un faraoni t'ǒğǒl. ");
INSERT INTO udi_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Saray faraoni t'ǒğǒl baksuna görə Avrami əşural şaat'e taysay, şot'ay hər sa şey buney: eğelxo, beliyox, ərkəy q'a dişi elemxo, buşurxo, çuux nökərxo q'a işq'ar nökərxo. ");
INSERT INTO udi_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ama Q'ončuğoy biin extenedi faraonen Avrami çuğo ext'i içeynak' çuux bsuna, şot'o görəl t'etəre bi ki, faraoni q'a iz saraya bakalt'oğoy bel bəlooxe hari. ");
INSERT INTO udi_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","T'e vədə faraonen Avrama iz t'ǒğǒl eçest'i pine: «Mo hetər əşen biq'e hun? Sarayi vi çuux baksuna het'u görən c'ap'pe zaxun? ");
INSERT INTO udi_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Het'u görən şot'o vi xunçi k'inək' çalxest'e? Zuval hələ şot'o zaynak' çuux pi hazq'e! Ext'a vi çuğoval aç̌a bez piyexun!» ");
INSERT INTO udi_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraonen iz amdarxo tapşurebi, şot'oğonal Avrama q'a Saraya taşeri içoğoy oç̌alaxun c'evk'amin c'ovakest'undi. Şorox Misirəxun c'eğat'an içoğoy k'ə buneysa bitova ext'it'un c'eri. ");
INSERT INTO udi_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Metərluğen, Avramen iz çuğo q'a izi q'azayinşi girbi k'ə bunesa bitova ext'i Misirəxun c'ere. İzi viçey ğar Lut'al içuxuney, şorox qaybaki Negev ams'i oç̌alat'un taśi. ");
INSERT INTO udi_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Avram Misirəxun gele varlune c'eri, şot'ay sürüğo bakala heyvanxoy sayal geleney, q'ızıl-gümüşəl. ");
INSERT INTO udi_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negev ams'i oç̌ala p'ap'it'uxun oşa Avram Bet'el şəhərəçe taśi, eçeriyal iz çadıra Bet'el q'a Ay şəhəri arane laxi, izi t'e vaxt' çurpi gala çurepi. ");
INSERT INTO udi_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Avramen miya t'e vaxt' Q'ončuğoynak' q'urban eçala gaal düzbeney. İsə p'urum miya çurpi Q'ončuğo bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Avramaxun sagala Misirəxun c'eri Lut'eyal, ham izi sürüğo bakala heyvanxoy say geleney, ham iz külfət kalaney. ");
INSERT INTO udi_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Şot'oğon ene içoğoy çadırxo suna ı̌ša laxesal tet'un baksay, şot'o görə ki, t'e vədə nə içoğoy heyvanxo otarişala ga tene p'oyesay, nə içoğoy külfəti ǰomo girbes bakala ukun. ");
INSERT INTO udi_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Avrami q'a Lut'e heyvanxo běğala çobanxoval ene sunaxun yaq'ax tet'un taysay. T'e döörəst'ə me oç̌alxo hələ kənanluyox q'a p'erizluyoxal yəşəyinşt'unbsay. ");
INSERT INTO udi_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","T'e vədə Avramen Lut'a pine: «Eki t'etər ben ki, nə beşi, nə beşi çobanxoy arane exlət maq'an baki, şot'o görə ki, yan q'oomyan. ");
INSERT INTO udi_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Běğa heq'ədər oç̌ale bu, eki cöybaken hər soğo içeynak'q'an baki. Zaynak' fərg tene bu. Hun tərs tərəf tağayin, zu yön tərəf tağoz, hun yön tağayin, zu tərs». ");
INSERT INTO udi_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lut'enal běneği ki, İordan oqe t'ǒğen bakala oç̌alxo taśi Śoara p'ap'amin şaat' xe laft'ala oç̌alxone, lap Buxačuğon Edena lasaki ganu q'a Misirə bakala oç̌alxone oşq'arst'a. Me exlət baki vədine Q'ončuğon hələ Sodoma q'a Homorra śarpiteney. ");
INSERT INTO udi_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Metərluğen, Lut'en İordan oqe t'ǒğə c'ək'p'i běğc'eğalaçe tağala baki. Hametər şorox cöyt'unbaki: ");
INSERT INTO udi_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Avram Kənan oç̌ala manedi, Lut'en isə İordan oqe t'ǒğen tağala oç̌alxo c'ək'p'i, iz çadırxoval taşeri Sodom şəhərə ı̌ša lanexi. ");
INSERT INTO udi_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom şəhəri amdarxo isə Q'ončuğo nu çalxala sa amdarxot'uniy, şorox günaxi boş batk'et'uniy tat'unsay. ");
INSERT INTO udi_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut' cöybaki taśit'uxun oşa Q'ončuğon Avrama pine: «Sa fırıpa vi çurpi ganu běğa mayal śirik'e taysa! ");
INSERT INTO udi_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Vi həysə ak'ala me oç̌ala dirist' va tadoz, vaxun törəyinşakit'oğoy bakale şo həmişəluğ. ");
INSERT INTO udi_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Oç̌ali ç̌oyel bakala q'ume hama booz Zu vaxun törəyinşaki nəsili saya. T'e q'uma nu bǒq'ə̌lpi çark'est'es bakala k'inək', şot'oğoval bǒq'ə̌lpi çark'est'es tene bakal. ");
INSERT INTO udi_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","İsə taki Zu va tadala me oç̌ala belxun ošel tarapa!» ");
INSERT INTO udi_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Memiinal c'erit'uxun oşa Avram Xevronaçe taśi, taşeriyal izi çadırxo Mamreni mə̌xluğ uk'ala ganu ı̌ša laxi çurepi. Şot'in miya Q'ončuğoynak' q'urban eçala gaal düzebi. ");
INSERT INTO udi_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Şinari padçağ Amrafel bakat'an, Ellasari padçağ Aryok', Elami padçağ K'edorlaomer, Goyimi padçağ isə T'idal bakat'an ");
INSERT INTO udi_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","davane burqeśi. Şorox hayzeri Sodomi padçağ Berayi, Homorray padçağ Birşayi, Admay padçağ Şinavi, Śevoyimi padçağ Şemeveri q'a Belay, yəni Śoari padçaği loxol davinat'un taśi. ");
INSERT INTO udi_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Me padçağxonal içoğoy loxol davinen eğalt'oğoy běš çurpes bakseynak' içoğoy q'oşunxo gərbi Siddim uk'ala dərəne çurt'unpi. Mo həysə Elaxoy dəniz bakala gane. ");
INSERT INTO udi_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","P'as's'e useney ki, K'edorlaomeren şot'oğo iz kiyel badi efeney, ama xibes's'emci usenast'a ěqt'unśi. ");
INSERT INTO udi_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mot'oxun sa usen oşa isə K'edorlaomeren q'a me əşləst'a iz tərəf bakala padçağxon c'eri rafaluğoxun Aşt'erot'-K'arnayima uk'ala gala, zuzluğoxun Hama uk'ala gala, emluğoxun K'iryat'ayima, ");
INSERT INTO udi_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","xorluğoxun isə ams'i oç̌ali ošel bakala El-P'arana tağala yaq'e loxol, Seir uk'ala burux ganxo davabi şot'oğo tat'unşeri. ");
INSERT INTO udi_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Oşa t'et'iin qaybaki En-Mişp'at'aç, yəni Qadeşaçt'un taśi. Taśiyal amalegluğoy q'a Xaseson-T'amara yəşəyinşala emorluğoy oç̌alxo davabi dirist' ext'undi. ");
INSERT INTO udi_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Metərluğen, Sodomi padçağen, Homorray padçağen, Admay padçağen, Śevoyimi padçağen saal Belay, yəni Śoari padçağen, Siddim uk'ala dərəne içoğoy q'oşunxo girbi c'ert'un ki, davabalt'un. ");
INSERT INTO udi_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","İçoğoy loxol eğalorox isə Elami padçağ K'edorlaomer, Goyimi padçağ T'idal, Şinari padçağ Amrafel saal Ellasari padçağ Aryok'ey. Bip' padçaği q'oşunen qo padçaği q'oşunaxun davabaley. ");
INSERT INTO udi_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Me Siddim uk'ala dərəne isə oç̌ali oq'axun q'ire c'eysay, t'iya bakala kururxoval bito me q'iren buyey. Sodomi q'a Homorray padçaği əsk'ərxonal davina taşevk'i t'ist'a burqat'an gelo me kururxo baft'i p'urt'un. Dirist' mandiyorox isə c'eri buruxmoğot'un t'it'eri. ");
INSERT INTO udi_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Davina taşeri t'e bip' padçağenal Sodom q'a Homorra şəhəre k'ə bunesa bitova fǔq'p'i tat'unşeri, içoğoy ambarxo bakala ukunal śirik'. ");
INSERT INTO udi_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sodoma bakala Avrami viçey ğar Lut'al fǔq't'unpi, tağat'anal şot'o içoğoy běš badi haq'i tat'unśi. ");
INSERT INTO udi_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","T'etəre baki ki, şot'oğoy kiyexun t'it'eri içu çark'est'es baki sa amdare buy, şot'in hari mot'o əbraniğoxun bakala Avrama p'ap'esebi. Avram Mamreni mə̌xluğ uk'ala ganu ı̌šane baksay, Eşk'ol q'a Aneral hame Mamreni nəsiləxunt'uniy. Mot'oğon içoğoy arane irəziluğt'un ğaç̌eśey ki, çətinluğa baft'at'an suna köməybalt'un. ");
INSERT INTO udi_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Avramen iz viçey ğar düşməni kiyel baksuna ibakat'an, içoğoy pula qaypi ğinaxun iz šuma kəyi kalabaki ğarmoğoxun xibbaç̌ muğes's'e tanluğ sa dəst'əne girbi. Şo Lut'a biq'i taşerit'oğoy bač'anexun baft'i, düz Dan şəhərəl śirik' taneśi. ");
INSERT INTO udi_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","T'iya p'ap'it'uxun oşa üşe iz amdarxo dəst'oğo cöybi iz viçey ğara biq'i taşerit'oğoy běšt'an bot'esedi. Şorox Avrami girbi eçeri dəst'in běš çurpes nu baki c'eri t'it'alat'un baki, Avramenal şot'oğo düz Damask'i q'uzey tərəf bakala Xovinal śirik' şəp'eśi. ");
INSERT INTO udi_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Avramen şot'oğoy kiyelxun içoğoy fǔq'p'i taşerit'oğo bitova exedi. Lut'a, Lut'e çupuxxo q'a nökərxoval çark'esedi, Lut'axun fǔq'p'it'oğoval bitova qaydi exedi. ");
INSERT INTO udi_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Avram K'edorlaomera q'a şot'ay tərəf bakalt'oğo şəp'eśi qaybakat'an iz běš Şaveni dərə uk'ala gala Sodomi padçağe c'eri. Me dərəni s'iya \"Padçaği dərəl\" next'uniy. ");
INSERT INTO udi_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salemi padçağ bakala Melk'isedek'al iz kiyel šum q'a fi ext'i c'ereney. Me Melk'isedek' Ala Arśi Buxačuğo q'ulluğbala sa běyinšey, ");
INSERT INTO udi_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","şot'in Avrama me əyitmoğo pi xeyir-bərəkəte tadi: «Ala Arśi Buxačuğon, göyə q'a oç̌ala Yaratmişit'in Avrama xeyir-bərəkətq'an tadi! ");
INSERT INTO udi_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Düşmənxo vi kiyel tadi Ala Arśi Buxačuğo alxışq'an baki». Avramenal düşməni kiyexun ext'it'oğoy vis' payaxun sunt'u Melk'isedek'ane tadi. ");
INSERT INTO udi_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodomi padçağen isə Avrama metəre pi: «Za tək bezi amdarxo qayda tada, mandi bito viq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ama Avramen Sodomi padçağa qaybaki metəre pi: «Ala Arśi Buxačuğoy běšez nex, göyə q'a oç̌ala yaratmişi Q'ončuğoy s'iyaz duği elase ki, ");
INSERT INTO udi_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","zast'a vi sa çöpəl tez efal. Za vi hik'k'al lazım tene, oşa umapa ki, \"zuz Avrama běš badi\". ");
INSERT INTO udi_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Bezi amdarxon kəyit'oğo c'erit'uxun oşa zaxun sagala davabi Aneri, Eşk'oli saal Mamreni paya tada, q'erəz hik'k'al çurtezsa». ");
INSERT INTO udi_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Sa heq'ədər vədə oşa Q'ončuğon Avrama ak'eśi pine: «Avram, q'ı̌maba! Va Zuz q'orişbsa, vi Bezi əyiten taysuni əvəzəl q'at-q'at haq'alnu». ");
INSERT INTO udi_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ama Avramen qaybaki metəre pi: «Ay bezi Buxačux bakala Q'ončux, bezi əyel nu bakit'uxun oşa, Vi za tadalt'oğoy məənə hik'ə? Zu p'uri taśit'uxun oşa hər şey damask'lu Eliyezera manst'eynak'?» ");
INSERT INTO udi_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Oşa Avramen saal pine: «Za sa zürgət ten tadi, isə mone, bezi k'oya bakala nökərə mandale bezi hər şey!» ");
INSERT INTO udi_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Q'ončuğoy Avrama pi əyit isə mone baki: «Şot'o təə, vaxun bakit'u mandale vi hər şey». ");
INSERT INTO udi_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Oşa Q'ončuğon şot'o qavuna c'evk'i pine: «Göynul běğa, vi zənden, t'iya bakala muč'uliğo bǒq'ə̌lpi çark'est'es bankon? Tenbakon. Haketərəl vaxun bakit'oğo bǒq'ə̌lpi çark'est'ala tene bakal». ");
INSERT INTO udi_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Avram Q'ončuğo věnebaki, me věluğa görəl şo Q'ončuğoy piyes düzgüne ak'eśi. ");
INSERT INTO udi_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Oşa Buxačuğon saal Avramaxun əyitp'i pine: «Zu va xaldeyluğoy Ur şəhərexun c'evk'i miya eçeri Q'ončuxzu, eçerezu ki, me oç̌alxo həmişəluğ va tadoz». ");
INSERT INTO udi_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Avramen xavare haq'i: «Ay bez Buxačux bakala Q'ončux, hetər avabakoz p'oy zu me oç̌alxoy ene bez baksuna?» ");
INSERT INTO udi_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Q'ončuğonal pine: «Barta Zu Bez tadi əyiti loxol çurpsuna ak'est'az. Hayza həysə xib useni sa dənə ocas, sa dənə keçi, sa dənə eğel saal sa dənə giyər q'a təzə p'ap'i göyərçin eça». ");
INSERT INTO udi_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Avramen içu pi k'inək' bi mot'oğo bitova eçeri šamepi, oşa heyvanxo bı̌yexun qı̌bi qı̌t'u sa tərəf, qı̌t'uval t'e soğo tərəf çüt-çüt bi lanexi, ama q'uşurxo qı̌tenebi, şot'oğo dirist'e laxi. ");
INSERT INTO udi_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Murdarbaki heyvan ukala q'uşurxo hari yeq'e loxol arst'unt'un çuresay, ama Avramen şot'oğo şəp'esay. ");
INSERT INTO udi_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Hari běğ batk'ala vədine Avrama bə̌ğə̌loy sa nep'ene ç̌axp'i, şo nep'e boşal gip, zülmət sa bayinq'unane baft'i. ");
INSERT INTO udi_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","T'e vədə Q'ončuğon Avrama pine: «İbaka, k'əz nex: vaxun törəyinşaki nəsil bip'baç̌ usen q'ərib sa gala yəşəyinşale, t'iya bakalt'oğonal şot'oğo k'ul k'inək' əşp'est'i koruğ zapest'alt'un. ");
INSERT INTO udi_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ama Zu t'e ölkin amdarxoy cazina tadoz, vaxun törəyinşaki nəsiləl t'e ganuxun içoğoy kul buy c'eğalt'un. ");
INSERT INTO udi_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Hun isə pis əş ten ak'al, vi pula q'ic'p'i t'e dünyəne tağat'anal vaynak' śameśi ömürə yəşəyinşi lap q'ojabaki bakalnu. ");
INSERT INTO udi_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Vaxun bakiyorox me oç̌ala qaybakseynak' isə bip' nəsile badalbaki buq'on, şot'o görə ki, miya bakala emorluğoy əşp'est'ala günaxxo hələ ǰomol śirik' tene buybake, şot'oğoy cazina zapest'ala ği hari tene p'ap'e». ");
INSERT INTO udi_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Běğ batk'i tam bayinq'bakit'uxun oşa Avramen qı̌bi heyvanxoy bı̌yexun hari k'üünəxbakala buxari q'a bok'ala sa yalove c'ovaki. ");
INSERT INTO udi_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hametər Q'ončuğon Avramaxun İzi irəziluğ ğaç̌esuna ak'est'i pine: «Mone, Misirə bakala oqnuxun burqi kala Yevfrat oqnul śirik' bakala me oç̌alxo bitova vaxun bakit'oğoz tast'a. ");
INSERT INTO udi_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","K'ayinluğoy, genizluğoy, gadmonluğoy, ");
INSERT INTO udi_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","xet'luğoy, p'erizluğoy, rafaluğoy, ");
INSERT INTO udi_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","emorluğoy, kənanluğoy, girgaşluğoy q'a yevusluğoy yəşəyinşala me oç̌al vaxun törəyinşakit'oğo mandale». ");
INSERT INTO udi_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayen Avrameynak' əyel eçes bateneksay. Şot'ay misirlu sa çuux-nökəre buy, iz s'i Acar. ");
INSERT INTO udi_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayen Avrama metəre pi: «İsə ki Q'ončuğon za əyel tene tast'a, ext'a bezi me çuux-nökərəxun baka. Bərkə kot'in q'a bakayin zaynak' sa ğar eneçeri». Avramen Sarayi əyitə běneği, ");
INSERT INTO udi_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarayenal izi çuux-nökərə, misirlu Acara ext'i izi işq'ara çuux pi tanedi. Avrami Kənan oç̌ala eysun isə vis' useney. ");
INSERT INTO udi_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Avram Acaraxun baneki, Acaral əyeləne mandi. Acaren iz bı̌hi baksuna avabakala k'inək' içu kalane taşt'a burqi. ");
INSERT INTO udi_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","T'e vədə Sarayen Avrama pine: «Hunnu kot'o bez bel laçuvk'iyo! Ext'i bez kiin kot'o vaynak' çuuxez bi, isəəl bı̌hi baki zaynak' yağine bake. Barta isə Q'ončuğonq'an pi şine beşi boşt'an düz nex». ");
INSERT INTO udi_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Avramen qaybaki metəre pi: «Vi nökəre hunen ava, hetər çurensa hat'etərəl ba». Hat'e ğinaxun Sarayen bureqi iz nökərə pul tadi işiğ nu tast'a, axırdal t'etəre baki ki, Acaren iz bula haq'i t'it'alane baki. ");
INSERT INTO udi_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ams'i oç̌ala, Şur şəhəre tağala yaq'e loxol sa orayine buy, Acar hari miya p'ap'ala vədine Q'ončuğon İz angela şot'ay běš c'evk'i İz muzin ");
INSERT INTO udi_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","pesedi: «Ay Sarayi nökər Acar, sa upa běyn, metər mayinen eysa, maç̌un taysa?» Acarenal qaybaki \"şineynak' ki nökərluğezbsa, şot'oxunez bez bula haq'i t'ist'a - Sarayaxun\" pine. ");
INSERT INTO udi_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","T'e vədə Q'ončuğon angela İz muzin saal pesedi: «Qaybaka taki, vi bulal k'os'p'a vi nökərluğa ba». ");
INSERT INTO udi_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Oşa metəre pi: «Vaxun kala sa nəsil törəyinşakale, şot'oğoy saya t'eq'ədər booz ki, bǒq'ə̌lpi çark'est'ala tene bakal şot'oğo». ");
INSERT INTO udi_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Q'ončuğon saal angeli muzin əyitp'i pine: «Avazu ki, bı̌hinu. Vi sa ğar bakale, iz s'iya İsmail laxa, şot'o görə ki, Buxačuğon vi t'ar ğine va inebaki. ");
INSERT INTO udi_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Vi me ğaren şuk'k'ala bač'an tene k'os'p'al, izi kalo iç bakale həmişə. Nə iç şuk'k'alaxun tene p'aq'al, nəəl içuxun tet'un yaq'ax tağal. Şot'ay ara izi viçimoğoxunal şaat' tene bakal». ");
INSERT INTO udi_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Acaren \"mone, za Ak'alt'u zuval azk'i\" pi, içuxun əyitk'ala Q'ončuğoy s'iya \"Za ak'ala Buxačuxe\" laxi. ");
INSERT INTO udi_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kot'o görət'un həysəəl Qadeşi q'a Beredi arane bakala t'e orayini s'iya Beer-Laxay-Roi nex. ");
INSERT INTO udi_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hametər, Acaren Avrameynak' sa ğare eçeri, Avramenal t'e ğare s'iya İsmaile laxi. ");
INSERT INTO udi_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Acaren İsmaila eçat'an Avrami səksən ǔq yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Avrami doxsan vuy yəş bakat'an Q'ončuğon şot'o ak'eśi pine: «Bitova Başarbala Buxačux Zuzu! Bez laxi yaq'en taki, günaxal va ı̌ša bist'a ma barta. ");
INSERT INTO udi_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Zu isə vaxun sa irəziluğ ğaç̌eğoz, vaxunal bǒq'ə̌lpi çark'est'es nu bakala sa nəsil törəyinşakale». ");
INSERT INTO udi_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Mot'o ibaki Avramen Buxačuğoy běš çökt'i iz bul oç̌ala laft'amin k'os'ebaki, Buxačuğon isə saal əyitpsa burqi pine: ");
INSERT INTO udi_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Mone, vaxun sa irəziluğ ğaç̌eśi va əyitez tast'a ki, vaxun azuk'xo törəyinşakale. ");
INSERT INTO udi_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Vi s'iyal ene Avram təə, Avraham bakale, şot'o görə ki, vaxun törəyinşaki t'e azuk'xoy bitot'ay bava hun bakalnu. ");
INSERT INTO udi_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Vaxun törəyinşakalt'oğo t'eq'ədər booz ki, azuk'xo əmələ eğale vaxun, padçağxo c'eğale vaxun baki nəsiləxun! ");
INSERT INTO udi_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Me irəziluğa vaxun q'a vaxun bakit'oğoxunez ğaç̌esa, viyal, vaxun törəyinşakit'oğoyal Buxačux baksuna həmişəluğ əyitez tast'a. ");
INSERT INTO udi_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Həysə vi q'ərib k'inək' çurpi me Kənan oç̌ala ext'i həmişəluğ va q'a vaxun törəyinşakalt'oğo tadoz Zu. Şot'oğo mandale me oç̌al, Zuval içoğoy Buxačux bakoz!» ");
INSERT INTO udi_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Oşa Buxačuğon Avrahama pine: «Ama hun q'a vaxun törəyinşakalt'oğonal, nəsilxoval hari badalbakayin Bezi və̌xun ğaç̌eśi irəziluğa əməl balanan. ");
INSERT INTO udi_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Efi me ğaç̌eśi irəziluğa əməlbsuna ak'est'eynak' isə efi boş k'ə işq'ar q'a ğar əyel bunesa, sünnətbakalane. ");
INSERT INTO udi_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sünnətbaksunen ak'est'alnan Bezi q'a efi arane ğaç̌eśi irəziluğa əməlbsuna. ");
INSERT INTO udi_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ef boş k'ə ğar əyel bunesa, nanaxun bakit'ay muğumci ğine sünnətbakalane: çuresa iz pula ef k'oya qaypi əyelq'an baki, çuresa tənginen haq'eśi nökəri əyel. Barta mo həysəəl, oşa eğala nəsilxoynak'al həmişə metərq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","İz pula ef k'oya qaypi ğar əyelal sünnətbakalane, oşa tənginen haq'i eçeriyoval. Efi bədəni loxol bakala t'e yeq'a bot'i bost'unen ak'est'ale Bezi və̌xun həmişəluğ sa irəziluğ ğaç̌esuna. ");
INSERT INTO udi_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ef boş nu sünnətbakiyo, yəni iz bədəni loxol bakala t'e yeq' nu bot'eśiyo nu bakalane. Metərt'ay tura bot'anan azuk'axun, şot'o görə ki, Zaxun ğaç̌eśi irəziluğa nu əməlbalone şo». ");
INSERT INTO udi_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Oşa Buxačuğon Avrahama metəre pi: «Vi çuğoval ene Saray pi ma k'alpa, ğeyin ğinaxun şot'ay s'i Sarane baki. ");
INSERT INTO udi_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bezi xeyir-bərəkətə tadi vaynak' sa ğar eçest'oz Zu şot'o. Şot'o t'etər sa xeyir-bərəkət tadoz ki, millətxo törəyinşakale şot'oxun, azuk'xoynak' padçağxo əmələ eğale». ");
INSERT INTO udi_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Avrahamen p'urum Buxačuğoy běš çökt'i iz bul oç̌ala laft'amin k'os'ebaki, iz boş isə axšumpi \"maya ak'eśe ki, sabaç̌ yəşt'ə amdaraxun əyel bakane? Doxsan yəşt'ə Saran eçale meyin oşa əyel?\" pine. ");
INSERT INTO udi_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Metər fikirbiyal Buxačuğo pine: «İsmaili elmux dirist', şot'ay Vi piyes şaat' ak'esun za bəse!» ");
INSERT INTO udi_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ama Buxačuğon qaybaki metəre pi: «Bezi va pi k'inək' bakale, ğara vi çuux Saran vaynak' eçale, hunal t'e ğare s'iya İsaak' laxalnu. Şot'oxun q'a şot'oxun törəyinşakalt'oğoxunez ğaç̌esa Zu me həmişəluğ irəziluğa. ");
INSERT INTO udi_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ama vi İsmaili barada pit'oğoval izbaki Zu, Bezi xeyir-bərəkətə kamtezbal Zu şot'oxun. Şot'o t'ema əyel tadoz ki, şot'oğoxun törəyinşakalt'oğo bǒq'ə̌lpi çark'est'es tene bakal. P'as's'e dənə kalaluğbal c'eğale şot'ay nəsiləxun, kala sa azuk'i bava bakale şo. ");
INSERT INTO udi_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bezi uk'ala irəziluğa isə vi ğar İsaak'axun ğaç̌eğoz, eğala usen me vədine Saran vaynak' eçala ğaraxun». ");
INSERT INTO udi_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Metər piyal Buxačux Avrahami t'ǒğǒlxun ə̌xilebaki. ");
INSERT INTO udi_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Avrahamenal bitova Buxačuğon içu pi k'inək' bine. Şot'in hat'e ği iz k'oya k'ə işq'ar q'a ğar əyel bunesa bitova sünnətebi, içuxun q'a iz ğar İsmailaxun burqi, iz k'oya nanaxun baki nökərxoxun q'a oşa tənginen haq'i nökərxol śirik' şu bunesa bitova. ");
INSERT INTO udi_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Avrahami sünnətbakat'an doxsan vuy, ");
INSERT INTO udi_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","izi ğar İsmaili isə xibes's'e yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Şorox p'ǒğə̌l hat'e sa ğinet'un sünnətbaki, ");
INSERT INTO udi_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Avrahami k'ojin nökərxoxun baki ğar əylux q'a oşa tənginen haq'eśiyorox hat'e ğinet'un sünnətbakey. ");
INSERT INTO udi_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Berezərey, Avrahamenal eğarixey pi iz çadıra bağala gane běš, Mamreni mə̌xluğ uk'ala ganu ı̌ša arśeney. Hamiya Q'ončuxe şot'o ak'eśi, ");
INSERT INTO udi_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Avrahamenal běneği ki, samal běš xib tan çurpene. Hayzeri şot'oğoy běše taśi, oç̌ala p'ap'amin k'os'p'akiyal ");
INSERT INTO udi_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","pine: «Bez ağa, əgər mot'o zaynak' gele ten aksasa, me k'ule t'ǒğǒlxun hat'etər c'ovaki tamaki. ");
INSERT INTO udi_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bartanan və̌ynak' xeq'at'un eçeri, və̌nal ef turmoğo os'k'i, arśi samal me xodin tume mandak'luğnan haq'on. ");
INSERT INTO udi_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Zuval t'emaçağ və̌ynak' šumez həzirbest'on. İsə ki me k'ule k'ojin t'ǒğǒlxunnan c'ovaksa, ef ük'e sa loq'ma duğanan, oşa hayzeri p'urum yaq'a bafnandon». Amdarxonal qaybaki \"lap şaat', barta vi uk'aloq'an baki\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Me əyitə ibakala k'inək' Avrahamen çadıra taśi Sara pine: «Usum baka, ən şaat' xarinaxun xib usk'un ext'a boq'oy šarpi šum bada». ");
INSERT INTO udi_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Oşa kap heyvanxo efala galane taśi, t'iyal izi moziğoy ən şaat't'u c'ək'p'i nökərə tapşurebi ki, şot'o šampi xorayq'an həzirbi. ");
INSERT INTO udi_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hametər, Avrahamen eçeri q'onağxoy běš muč'anaq'i ç̌o, şor saal həzirbi yeq'a lanexi, içal şot'oğon ukamin xodin tume çurepi. ");
INSERT INTO udi_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Oşa q'onağxon Avrahamaxun xavart'un haq'i: «Vi çuux Sara maya?» Avrahamenal qaybaki \"miya, çadırane\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Q'onağxoy sunt'in pine: «Eğala usen hame vədine zu p'urum vi t'ǒğǒl eğoz, t'e vədə vi çuux Saray sa ğar bakale». Saran isə şot'oğoy bač'ane, çadıra bağala gane běš çurpi ǔmǔxelaxsay. ");
INSERT INTO udi_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Avraham q'a Sara ene q'ojabaket'uniy, Sara paltar aksunaxunal bot'bakeney. ");
INSERT INTO udi_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Şot'o görəl me əyitə ibakat'an Saray axšumen biq'i iz boş metəre fikirbi: \"Bezi popal mas'ibakene, mot'oğon miya işq'araxun bask'i əyel eşt'unaxunt'un əyite! İşq'ariyal sa tur gərəmzoğone\". ");
INSERT INTO udi_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","T'e vədə Q'ončuğon Avrahama pine: «Het'u görə Saran axšumpi \"zane mandiyo meyin oşa əyel eşt'un\" nex? ");
INSERT INTO udi_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Q'ončuğoy kiyexun nu ayeğala şey tene bu! Eğala usen Bezi pi vədine eğoz, Saray q'ujelal sa ğar əyel bakale». ");
INSERT INTO udi_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Metər uk'at'an, Saran q'ı̌yexun əfçiduği \"zu tez axšumpe\" pine. Şot'in isə qaybaki \"təə, axšumpenu\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hametər, q'onağxo hayzeri p'urum yaq'at'un baft'i, Avrahamal c'ere ki, taşeri şot'oğo c'ovakest'ale. Şorox Sodom şəhərəçt'un taysay, ");
INSERT INTO udi_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Q'ončuğonal q'onaǧi muzin əyitp'i pine: «Bezi ük'e biq'est'it'oğo het'u görə Avrahamaxun c'ap'baz? ");
INSERT INTO udi_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kala, zorba sa millət törəyinşakale şot'oxun, Bez tadala xeyir-bərəkətin k'ə baksuna şot'ost'a ak'alt'un oç̌ali ç̌oyel bakala azuk'xoy bitot'in. ");
INSERT INTO udi_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Bezi c'ək'p'i içu əyit tadiyone şo, şot'in ak'est'ale Bezi laxi yaq'en taysuni, düzgün baki günaxaxun ə̌xil çurpsuni k'ə baksuna. Mot'o izi əyloğo q'a şot'oğoxun oşa eğala nəsilxoval avabakest'ale, şot'oğonal Bezi əyit tadit'oğoy hari bex c'eysuna içoğoy piin ak'alt'un». ");
INSERT INTO udi_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Oşa Q'ončuğon saal pine: «Sodoma q'a Homorrina bakalt'oğoy biq'ala əşur hari bez ǔmǔğo p'anep'i, günaxi boş batk'et'un tat'unsa şorox. ");
INSERT INTO udi_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kot'aynak'ez śire, şot'oğoy kiyexun əzyət zap'k'alt'oğon Za k'alpi xoyinšp'at'an pit'oğoy düz baki nu baksuna avabakseynak'. Bez piinez aksun çureśi». ");
INSERT INTO udi_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Q'onağxoy p'ǒğǒ fırıpi tat'unśi Sodomaç, Q'ončux isə hələ Avrahami t'ǒğǒley. ");
INSERT INTO udi_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Avrahamenal Şot'o ı̌šalayinşaki pine: «İsə düzgünt'oğoval günaxkərxoxun sagala əfçibalnu? ");
INSERT INTO udi_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Uk'en şəhəre əlli tan düzgün amdare bu. İsə eçeri t'iya bakala pist'oğo görə dirist' şəhərə əfçibalnu? P'oy me əlli tan? Yəni Vi ük' tene bok'al şot'oğoynak'? ");
INSERT INTO udi_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Zu větez, Vi biq'ala əş tene mo! Düzgünt'oğo nu düzgünt'oğoxun sa bitenq'on Hun, şot'oğo suna gərbi əfçitenbon! Hun metər əş biyaltenq'on, mot'o sal věyaltez. Dirist' dünyəni əşlən běğsa Hun, maya ak'eśe Vi düzgün q'ərar nu tast'un?» ");
INSERT INTO udi_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Q'ončuğon qaybaki metəre pi: «Sodoma əlli düzgün amdar bə̌ğə̌bayiz, şəhərə tez galdal, barta şot'oğoy belq'at'un fırıpi». ");
INSERT INTO udi_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Avrahamen saal pine: «Şuzu ki zu? P'uri oç̌ali oq'a tağala, t'iyal k'ula gərbaki əfçibakala sa amdarzu, q'erəz hik'k'al! Za tene mandiyo Va əyit uk'ala, ama p'urumal uk'oz: ");
INSERT INTO udi_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","əlli tan tene baki, q'ırx qo tane baki, t'e vədə k'ə balnu? Qo tan kame pi dirist' şəhərə əfçibalnu?» Q'ončuğonal qaybaki \"t'iya q'ırx qo tan düzgün amdar bə̌ğə̌yeğayin, t'e şəhərə galtezdal\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Avrahamen saal pine: «Q'ırx qo tan tene, q'ırx tane bə̌ğə̌yeśi, t'e vədə?» Q'ončuğonal qaybaki \"q'ırx tana görəl tez galdal\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Avrahamen saal pine: «Q'ončuğoy əcuğon maq'an biq'i, ama p'urumal uk'ala bakoz: p'oy otuz tan bakayin hetər bakale?» Q'ončuğonal qaybaki \"otuz tanal bə̌ğə̌yeğayin tez galdal\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Avrahamen saal pine: «İsə ki ketəre, ük'bi saal xavar haq'oz: q'a tan bə̌ğə̌yeğayin hetər balnu?» Q'ončuğonal qaybaki \"q'a tan bə̌ğə̌yeśeq'an, t'e şəhərə Bez kula tez duğal\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Avrahamen saal pine: «Vi əcuğon maq'an biq'i, ay Q'ončux, ama bez ç̌oya boç̌ubi axırınci kərəməl xavar haq'oz: uk'en vis' tane bə̌ğə̌yeśi, t'e vədə k'ə balnu?» Q'ončuğonal qaybaki \"lap vis'c'ə tanal bə̌ğə̌yeğayin, zu t'e şəhərə tez galdal\" pine. ");
INSERT INTO udi_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Me exlətəxun oşa Q'ončuğon Avrahama efi taneśi, Avrahamal qaybaki iz mandala galane taśi. ");
INSERT INTO udi_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Avrahamen q'onağbi t'e p'ə̌ angel hari Sodoma p'ap'at'an ene biyənebaksay. Şəhəre bağala darvazin tume arśi Lut'en şot'oğo ak'i, hayzeri běše c'eri, oç̌ala p'ap'amin k'os'p'akiyal pine: ");
INSERT INTO udi_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«Bezi ağoox, ekinan və̌x q'onağbaz. Me nökəri k'oya baśi efi turmoğo os'k'aynan, bask'i mandak'luğ haq'aynan gele mǔqezbakon. Oşa savaxt'an hayzeri p'urum yaq'a bafnandon». Şot'oğon isə qaybaki \"əzyət ma zapanan, yan hamiya sa ga bə̌ğə̌bi bask'alyan\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ama Lut'en şot'oğo t'emane xurixuribi ki, axırda izi əyitə bask'i tat'unśi içuxun. Lut'enal eçeri təzə baldamac badest'i şot'oğoynak' šume laxi, şot'oğonal arśi kəyt'un. ");
INSERT INTO udi_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ama bask'ala vədine Sodoma cəyil-q'oja, k'ə işq'ar bunesa, hari Lut'e k'ojin hərrəminə biq'est'i çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Burt'unqi Lut'a k'alpi metər upsa: «Mayat'un şorox? Me üşe vi k'oya mandala amdarxoy qoşt'anyan hare, eça şot'oğo miya beş əşlə biq'en». ");
INSERT INTO udi_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut'en c'eri, iz bač'anexun ç̌omoval but'k'it'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","pine: «Ay bez viçimux, metər əş ma biq'anan! ");
INSERT INTO udi_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Běğanan k'əz nex, bezi k'oya işq'ara nu taśi p'ə̌ xuyərzax bu. Şot'oğo eçaz, k'ə çurnansa banan, ama ef běš biyaz, bez k'oya hari q'onağa ma galdanan». ");
INSERT INTO udi_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Gireśi işq'arxon isə qaybaki \"aç̌a memiin! Beş oç̌alxo hari arśene, miya yax haq'ıle tast'a!\" pit'un. Şot'oğon Lut'a \"t'etər ma ba ki, va kot'oğoxun betər ben\" pi burt'unqi şot'o lik'st'a ki, ç̌omo xoxp'i k'oya bağalt'un. ");
INSERT INTO udi_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","T'e vədə k'oya bakala q'onağxon ç̌omo qaypi Lut'a zapi bat'undi bona, ç̌omoval kiritt'unbi. ");
INSERT INTO udi_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ç̌omoy tume gireśit'oğo isə t'etərt'un bi ki, cəyil-q'oja, t'iya şu bunesa bitot'ay pulmux k'ač'ine baki. Amdarxon sal k'oya bağala ç̌omo bə̌ğə̌bes tet'un baksay. ");
INSERT INTO udi_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Q'onağxon Lut'a pit'un: «Şuvax bu ene me şəhəre? Yeznoox, ğarmux, xuyərmux, vi külfətəxun şu buvaxsa ext'a c'eki memiin, ");
INSERT INTO udi_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","şot'o görə ki, male mande me şəhəreynak', tumexun əfçibalyan me ganu! Hari p'anep'i Q'ončuğoy ǔmǔğo miya bakalt'oğon amdarxo zapest'alorox, isəəl mone, yax yaq'abene ki, oç̌alen sa ben me şəhərə». ");
INSERT INTO udi_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lut'enal iz xuyərmoğo besi yeznoğoy t'ǒğǒl taśi pine: «Usumbakanan, c'ekinan me şəhərexun, Q'ončuğon əfçibale həysə me ganu». Ama şot'oğon t'etərt'un fikirbi ki, Lut'en zarafat'ebsa. ");
INSERT INTO udi_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kəybakat'an k'oya q'onağ hari angelxon Lut'a kapt'i pit'un: «Usumbaka! Vi çuğo q'a p'ə̌ xuyərəl ext'a c'eki me şəhərexun, tene miyaneynak' həzirbaki aruğoy boş hunal bok'alnu». ");
INSERT INTO udi_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ama Lut' hələl lənge galey. T'e vədə angelxon Lut'eyal, Lut'e çuğoy q'a iz xuyərmoğoyal kiyexun biq'i, taşeri şəhərexun c'eğamin c'ovakest'undi, şot'o görə ki, Q'ončuğoy şot'oğoynak' ük'e boksay. ");
INSERT INTO udi_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Şəhərexun c'erit'uxun oşa angelxoy sunt'in pine: «T'it'anan ef elmoğo çark'est'anan! Qoş ma běğanan! Me qavun galal çurpsun maq'an baki, t'it'anan buruğo c'ap'bakanan, tene biyalnan!» ");
INSERT INTO udi_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lut'en isə qaybaki metəre pi: «Vi běš biyaz, za gorox eki, bezi Ağa! ");
INSERT INTO udi_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Vi ük'e bok'i zaynak', Vi piyes şaat'ez ak'eśi pi çark'esendi Hun me k'ule elmoğo. Ama ə̌xile Vi həysə uk'ala buruxxo, zu t'iya p'ap'amin arux hari barale bez bel, əfçibaki tağoz zuval. ");
INSERT INTO udi_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Samal běš mis'ik' sa şəhəre bu, t'iya t'it'eri p'ap'es bazkon. Axıri t'e ga t'ema kalal tene, barta za t'iya p'ap'esp'i bezi elmoğo çark'est'az!» ");
INSERT INTO udi_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Angelen pine: «Barta vi uk'ala k'inək'q'an baki, tez əfçibal t'e şəhərə. ");
INSERT INTO udi_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ama t'it'a va usum t'iya p'ap'esp'a, şot'o görə ki, hun vi ganu bamin Zu hik'k'al bes tez bakon». T'e şəhəri s'i isə Śoaral manedi. ");
INSERT INTO udi_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Běğ ene ěqeśeney. Lut' hari Śoara p'anep'i, ");
INSERT INTO udi_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Q'ončuğonal t'etəre bi ki, Sodomi q'a Homorray loxol göynuxun bok'ala kükürde bari. ");
INSERT INTO udi_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Şəhərmux q'a şəhəre bakaloroxal, dirist' t'e q'avunluğal, oç̌alaxun t'ı̌q'p'i c'eğala k'ə bunesa şoroxal - bito bok'i baredi. ");
INSERT INTO udi_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lut'e çuğon isə fırıpi qoşe běği pi, izi bədənen elen ǰě biq'ala k'inək' ǰě biq'i, hat'e izi çurpi galal manedi. ");
INSERT INTO udi_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Əyc'indəri kəybakala k'inək' Avraham hayzeri Q'ončuğon içuxun sa ği běš əyitp'i galane hari. ");
INSERT INTO udi_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Hariyal běneği ki, Sodom q'a Homorra bakala ganuxun, dirist' t'e qavunluğaxun t'etər sa k'üüne c'eysa ki, unk'on tarine boksa. ");
INSERT INTO udi_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Buxačuğon t'e qavun ganu bakala şəhərmoğo əfçibat'an Avraham İzi eyexey, şot'o görəne Lut'a t'et'iin c'evk'i çark'est'i, şot'ay t'e śareśi barala şəhəri oq'a mandi bisuna tene çureśi. ");
INSERT INTO udi_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lut'en izi p'ə̌ xuyərəl ext'i Śoaraxun c'ere, şot'o görə ki, t'iya manst'una q'ı̌nebsay. Şorox taśi buruğo sa mağarinat'un manst'a burqi. ");
INSERT INTO udi_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Sa ği Lut'e kala xuyəren iz mis'ik' xunça metəre pi: «Mone, beşi baval ene q'ojanebaksa, miya q'erəz işq'aral tene bu ki, hayzeri camaati xuyərmoğollarik' işq'ara tağayan. ");
INSERT INTO udi_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Eki beşi bava ǔğest'i içuxun bask'en, bərkə beşiyal sa əyel baneki, metərluğen beşi tumal tene əfçibakon». ");
INSERT INTO udi_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Şot'oğon hat'e üşe içoğoy bava fi tadi ǔğest'undi, kala xuyərəl baśi iz bavaxun basek'i. Lut'en isə t'ema ǔğeney ki, nə xuyəri hari izi t'ǒğǒl basksunane avabaki, nəəl şot'ay hayzeri taysuna. ");
INSERT INTO udi_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Əyc'indəri kala xuyəren mis'ik't'u pine: «C'ovaki şü zuz bask'i bavaxun, eki me üşeyal bava ǔğest'en hun bask'a içuxun. Sa əyel eçayan beşi tumal tene əfçibakon». ");
INSERT INTO udi_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Haketərəl bit'un, eçeri bava p'urum fi tadi ǔğest'undi, mis'ik' xuyərəl hari iz bavaxun basek'i. Lut'en isə t'ema ǔğeney ki, nə xuyəri hari izi t'ǒğǒl basksunane avabaki, nəəl şot'ay hayzeri taysuna. ");
INSERT INTO udi_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hametər, Lut'e p'ə̌ xuyərəl içoğoy bavaxun əylət'un mandi. ");
INSERT INTO udi_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kala xuyəren sa ğar eçeri iz s'iya Moave laxi. Moavluyox uk'ala azuk'al hame Moavaxun əmələ hariyoroxe. ");
INSERT INTO udi_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mis'ik' xuyərenal sa ğar eçeri iz s'iya Ben-Ammine laxi. Şot'oxunal həysət'in \"ammonluyox\" uk'ala azuk'e törəyinşaki. ");
INSERT INTO udi_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Avraham iz bakala ganuxun c'eri Negev oç̌alaçe taśi. Şot'in izi amdarxo q'a sürüğoval ext'i, eçeri izi çadırxo Qadeş şəhəri q'a Şur ams'i oç̌ali aranene laxi çurpi. Şo samal vədə Gerar şəhəreyal baneki, ");
INSERT INTO udi_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","miyal q'əribey pi izi çuux Sara amdarxo \"xunçi\" pine çalxest'i. T'e vədə Gerari padçağ Avimelek'en izi amdarxo yaq'abi Sara izi t'ǒğǒle eçest'i. ");
INSERT INTO udi_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ama Buxačuğon Avimelek'a nep'en metəre pi: «Ke çuğo vi t'ǒğǒl eçest'una görə biyalnu hun, şot'o görə ki, işq'arane ko». ");
INSERT INTO udi_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Avimelek'en isə hələ iz kula tene duğey çuğo, qaybakiyal pine: «Ay Q'ončux, yəni taxsırsuz sa azuk'a əfçibalnu? ");
INSERT INTO udi_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Amdaren içine za pi ki, \"mo bezi xunçine\". Oşa çuğoxunal cöy xavarez haq'i, şot'inal pine \"mo bezi viçine\". Me əşləst'a taxsır tezax bu, şuk'k'ali běšal ç̌omə̌yin tezu». ");
INSERT INTO udi_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","T'e vədə nep'en Buxačuğon saal pine: «Düzen nex, vi me əşləst'a taxsırsuz baksuna avazu. Kot'o görəl ke çuğoxun ı̌šaluğbi Bez běš günax əşp'est'unaxun ezfi va. ");
INSERT INTO udi_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","İsə qayda yaq'aba ke çuğo izi işq'ari t'ǒğǒl. Kot'ay işq'ar xavareçale, vi əşp'est'i günaxa bağışlayinşbseynak' şot'in Za afırıpi xoyinšp'ayin ten biyal. Ama nu qaydayvax, nə hun, nə vaxun sa k'ojin oq'a bakalt'oğoy sayco dirist' tenan mandal». ");
INSERT INTO udi_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avimelek'enal savaxt'an kəybakala k'inək' izi sarayi amdarxo girbi Buxačuğon içu pit'oğo bitova şot'oğo exlətebi. Amdarxo q'ı̌yene haq'i. ");
INSERT INTO udi_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Oşa Avimelek'en Avrahama izi t'ǒğǒl eçest'i pine: «Mo hetər əşe hun beş bel ençeri? Va k'əz be ki, hun zaal, bezi padçağluğal metər sa günaxan badi? Şuk'k'alen me əşlə tene biq'oy!» ");
INSERT INTO udi_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Avimelek'en Avrahamaxun saal xavare haq'i: «Me əşlə biq'at'an k'ə fikirbin biq'i?» ");
INSERT INTO udi_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Avrahamenal qaybaki metəre coğab tadi: «Fikirezbi ki, miyanin amdarxon Buxačuğoxun tet'un q'ı̌bsa, bezi çuğo içoğoy kiyel bast'una görə za best'unbon. ");
INSERT INTO udi_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Metər ext'at'an əfçiyal tene, bezi çuux həgigiyal bezi xunçine baksa, yan bava sa, nana cöy xunçi-viçiyan. ");
INSERT INTO udi_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Buxačuğonal za k'alpi \"vi bakala ganu barta, hayza q'erəz gala taki\" uk'at'an kot'o pizu ki, \"bezi şaat'a çurensasa, meyin oşa q'ərib gala baft'ayan, upa ki, zu vi viçizu\"». ");
INSERT INTO udi_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","T'e vədə Avimelek'en eğelxo, beliğo, çuux q'a işq'ar nökərxo eçest'i Avrahama paye tadi. Oşa Saral qaydi içu tadi ");
INSERT INTO udi_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","pine: «Mone, bezi oç̌alxoy bito vaynak' qaye, vi ük'en maya çuresa vi çadırxo laxi çurpes bankon». ");
INSERT INTO udi_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sara isə metəre pi: «Mone, vi viçə sa hazar gümüşi təngəz tast'a, barta me təngə vi günaxsuz gala s'i c'eysuna os'k'i taşt'eynak'q'an baki, t'e vədə vaxun sa k'ojin oq'a bakalt'oğoy běš vi bul k'os' tene bakon». ");
INSERT INTO udi_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Avrahamen Buxačuğo afırıpi xoyinšebi, Buxačuğonal Avimelek'a içu, Avimelek'i çuğo q'a şot'ay saraya bakala bito çuux-nökərxo q'olayebi. İsə şorox p'urum əylə mandest'un baksay, ");
INSERT INTO udi_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","axıri Avrahami çuux Sara görə Q'ončuğon t'etəre bey ki, Avimelek'i k'oya bakala çupuxxoy sayco əylə mantenest'ay. ");
INSERT INTO udi_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Q'ončuğon isə İzi tadi əyiti loxol çurpi Sara eyexun tene c'evk'i, ");
INSERT INTO udi_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saral bı̌hi baki, düz Buxačuğon içu pi vədine ene q'ojabaki Avrahameynak' sa ğare eçeri. ");
INSERT INTO udi_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Avrahamen Saraxun baki ğare s'iya İsaak'e laxi, ");
INSERT INTO udi_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","eçeriyal Buxačuğon içu əmirbi k'inək' əyel nanaxun bakit'ay muğumci ğine şot'o sünnətebi. ");
INSERT INTO udi_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","İsaak' nanaxun bakat'an Avrahami sabaç̌ yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saran isə metəre pi: «Bezi ç̌oyane axšumdi Buxačuğon, şiin ibakayin mǔqexun axšumek'on». ");
INSERT INTO udi_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Oşa saal pine: «Şi beynene p'aq'i Avrahama uk'oy ki, p'oy Saranal əyel eçeri şot'o döş ukest'ale? Ama mone, şot'aynak' izi q'ojabaki vədine ğarez eçeri zu!» ");
INSERT INTO udi_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Əyel kalanebaki, şot'ay muč'anaq'axun bot'bakala ğineyal Avrahamen kala sa q'onaxluğe tadi. ");
INSERT INTO udi_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sa ği Saran běneği ki, Acaren Avrahameynak' eçeri ğaren İsaak'i loxol axšumene. ");
INSERT INTO udi_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","T'e vədə şot'in Avrahama metəre pi: «Me nökərə q'a izi eçeri ğaral şəp'ey c'eri taśeq'at'un, yan nu bakit'uxun oşa kot'oxun beşi var-dövlətə cöybseynak' tez eçere zu bez ğara!» ");
INSERT INTO udi_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ama şot'oğo k'oyaxun şəp'esuna Avrahami ük'en tene bsay, şot'o görəl Saray me əyitmux içu gelene laft'i, axıri İsmailal izi ğarey. ");
INSERT INTO udi_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Buxačuğon isə Avrahama metəre pi: «Nə əylə görə, nə əylin nana görə narahat ma baka. Hun Saray əyitə běğa, şot'o görə ki, İsaak'axun törəyinşakale va əyit tadeśi t'e nəsil. ");
INSERT INTO udi_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ama Zu vi nökərəxun baki ğaral eyexun tez c'evk'al, şot'oxunal kala sa millət törəyinşakale, şot'o görə ki, şoval vaxune bake». ");
INSERT INTO udi_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Əyc'indəri savaxt'an Avrahamen yaq'eynak' šum laxi, sa tuluği boş xeyal bapi biq'esedi Acari kiyel. Oşa əyləl içu gərbi c'evek'i k'oyaxun. Acaren içinal tene avay maya taysay, hariyal Beer-Şeva uk'ala ams'i oç̌ala p'ap'i bureqi miya ams'i-ams'i fırıpsa. ");
INSERT INTO udi_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hari izi kiyel bakala xe çark'at'an Acaren əylə sa topin tume efi, ");
INSERT INTO udi_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","içal samal běš, xişt'ik' bosayin taśi p'ap'ala hama taśi, arśi bureqi ǒnepsa. Şot'in tene çuresay əylin bisuna izi piin ak'ane. ");
INSERT INTO udi_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ama Buxačuğon əylin ǒnepsuna inebaki, Buxačuğoy angelenal göynuxun Acara k'alpi pine: «Het'u görən vi piin neğa s'ine, Acar? Q'ı̌maba, Buxačuğon inebaki vi topin tume efi taśi əylin ǒnena. ");
INSERT INTO udi_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","İsə taki alabi şip'ba vi ǧara. Kot'oxun kala sa millət əmələ eçoz Zu!» ");
INSERT INTO udi_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Oşa Buxačuğon t'etəre bi ki, Acari pulmux qayeśi t'iya bakala xene kərizə anek'i, taśiyal iz kiyel bakala tuluğa xenen buybi əylə ǔğesedi. ");
INSERT INTO udi_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Hametər, Buxačuğoy sa kul əylin loxoley. Əyel kalabaki şaat' sa ǒxə̌lbale baki, hariyal çölene mandala baki. ");
INSERT INTO udi_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Şo Paran uk'ala çölene baksay, iz nananal şot'aynak' Misirəxun xuyəre eçeri. ");
INSERT INTO udi_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Hame vədəmoğo padçağ Avimelek'en iz q'oşuni kalo bakala P'ik'olal ext'i Avrahami t'ǒğǒle hari. Şot'in Avrahama pine: «Hun vi kula mani əşlə boxodayin, Buxačux vaxune. ");
INSERT INTO udi_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","İsə Buxačuğo elasp'i za əyit tada ki, hun nə zaxun, nə bez əyloğoxun, nəəl oşa şot'oğoxun əmələ eğalt'oğoxun düşmən ten bakal. Za əyit tada ki, bezi vaynak' bi şaat'luğa eyexun ten c'evk'al, eçeri va arśest'i me oç̌ali šuma ten ç̌axç̌uxk'al». ");
INSERT INTO udi_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Avrahamenal qaybaki \"əyitez tast'a\" pine. ");
INSERT INTO udi_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Oşa Avrahamen Avimelek'eynak' şot'ay amdarxon iz kiyexun kərizə exst'unane exlətp'i. ");
INSERT INTO udi_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ama Avimelek'en metəre pi: «Ke əşlə şine biq'e tez ava. Hun za hik'k'al piyaltenuy, zuval həysəz ibaksa me exlətə». ");
INSERT INTO udi_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hametər, Avrahamen taśi izi sürüğoy boşt'an eğelxo q'a beliyoxe eçeri, şot'oğo Avimelek'a tadiyal şot'oxun irəziluğe ğaç̌eśi. ");
INSERT INTO udi_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Avrahamen izi eçeri heyvanxoy boşt'an vǔğ dənə dişi q'uzina cöybi t'ǒǒx efeney, ");
INSERT INTO udi_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Avimelek'enal mot'o ak'i xavare haq'i: «Me vi cöybi vǔğ q'uzi het'aynak'e?» ");
INSERT INTO udi_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Avrahamen pine: «Ke vǔğ q'uzina va cöyez tast'a, barta korox me kərizi bezi baksuna ç̌oyel c'evksuni s'iyenq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mot'oxun oşa t'e gane s'iya Beer-Şevat'un laxi, şot'o görə ki, miya p'rannat'inal elasp'i suna əyitt'un tadey. ");
INSERT INTO udi_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Metərluğen, Beer-Şevina irəziluğ ğaç̌eśit'uxun oşa Avimelek' q'a izi q'oşuni kalo bakala P'ik'ol qaybaki filist'luğoy oç̌alat'un taśi. ");
INSERT INTO udi_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Avrahamenal eçeri Beer-Şevina sa t'amarisk' uk'ala xod bit'i, miya Q'ončuğoy, yəni Həmişə Bakala Buxačuğoy s'iya duği Şot'o bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Avraham filist'luğoy oç̌ala hələ boxoye çurk'ala baki. ");
INSERT INTO udi_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sa heq'ədər vədə hari c'ovakit'uxun oşa Buxačuğon Avrahama sinəyinşi şot'ay İzi əyitəxun c'eri-nu c'eysuna yoxlayinşbsune çureśi. Buxačuğon Avrahama k'alpi pine: «Ay Avraham!» Avrahamenal qaybaki \"izbaksa!\" pine. ");
INSERT INTO udi_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Buxačuğon pine: «Vi ğar İsaak'a, vi piin işiğ bakala t'e sa ğara ext'a Moria oç̌ala taki. Şot'o t'et'iya Zu va ak'est'ala buruğoy bel šampi Zaynak' bok'ospsuni q'urban eça». ");
INSERT INTO udi_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Avrahamenal savaxt'an üşenen hayzeri həzirləyinşaksane burqi. Şot'in lazımbakalt'oğo girbi elemi bač'ane lanexi, taśi q'urbana bok'ospseynak' ušal qı̌bit'uxun oşa, İsaak'a q'a p'ə̌ nökərəl ext'i Buxačuğon içu pi gala yaq'ane baft'i. ");
INSERT INTO udi_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Xib ği yaq' taśit'uxun oşa Avrahamen běneği ki, t'e ga ə̌xiləxun ak'esa. ");
INSERT INTO udi_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Şot'in iz nökərxo pine: «Və̌n miya çurpanan, elemal ef t'ǒğǒlq'an. Yan isə əyləxun taśi Buxačuğoynak' q'urban šampi eğalyan». ");
INSERT INTO udi_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Avrahamen q'urbana bok'ospseynak' girbi uša ext'i İsaak'i bač'anene laxi, içinal aruxpseynak' bakala ǒliğo saal menane ext'i. Hametər burt'unqi p'ə̌ tan taysa. ");
INSERT INTO udi_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Şorox tağala gala İsaak'en fırıpi iz bava Avrahama pine: «Ay bava!» Avrahamenal qaybaki \"izbaksa, bez ğar\" pine. İsaak'en xavare haq'i: «Ušal ext'eyan, aruxpseynak' ǒliyal buyax, p'oy bok'ospseynak' bakala q'urbanluğ q'uzi maya?» ");
INSERT INTO udi_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Avrahamen metəre coğab tadi: «Bez ğar, bok'ospseynak' bakala q'urbanluğ q'uzina Buxačuğon İçin yax p'ap'esp'ale». Hame exləte baki, oşa ene şip'c'ə içoğoy bula suruk'p'i tat'unśi. ");
INSERT INTO udi_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Hari Buxačuğon içu pi gala p'ap'at'an Avrahamen q'urban eçala ga düzbi ušurxoval iz loxol girebi. Oşa iz ğar İsaak'al ğaç̌p'i t'e ušurxoy loxol lanexi ki, şot'o Buxačuğoynak' q'urban eçale. ");
INSERT INTO udi_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ama mena ext'i iz ğara šamk'ale uk'at'an ");
INSERT INTO udi_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Q'ončuğoy angelen göynuxun Avrahama k'alpi pine: «Avraham! Avraham!» Şot'inal \"izbaksa\" pine. ");
INSERT INTO udi_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Angelen pine: «Zapa vi kula, əylə ma laft'a! İsə avazbaki ki, vaynak' Buxačuğoxun běš hik'k'al butene, şot'o görə ki, vi piin işiğ bakala tək sa ğaral hun Zaynak' gele ten ak'i!» ");
INSERT INTO udi_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Avrahamenal iz bula alabat'an běneği ki, samal běš iz mǔq'ǒǒx śaśa lamandi sa ərkəy eğele bu. Taśiyal t'e eğela ext'i iz ğare gala şot'one bok'ospsuni q'urban eçeri. ");
INSERT INTO udi_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Avrahamen t'e gane s'iya Yahve-İrene laxi, şot'o görə həysəəl k'ənesa bakat'an next'un \"Q'ončuğon İçin İz buruğoxun p'ap'esp'ale\". ");
INSERT INTO udi_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Oşa Q'ončuğoy angelen p'urum göynuxun Avrahama k'alpi pine: ");
INSERT INTO udi_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Q'ončuğon metəre nex: \"İsə ki hun vi piin işiğ bakala, vi t'e tək sa ğara Zaynak' gele ten ak'i, Zuval Bez s'iyen elasp'i əyitez tast'a ki, vi biq'i me əşlə görə ");
INSERT INTO udi_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Bezi xeyir-bərəkətə vaxun kamtezbal Zu! Vaxun əmələ eğala nəsili saya göynul bakala muč'uliğoy q'a dənizi börine bakala q'ume hama booz Zu. Düşmənxo saki içoğoy şəhərmoğo kiyel badalt'un şot'oğon, ");
INSERT INTO udi_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","vi Bezi əyitəxun nu c'eysuna görə oç̌ali ç̌oyel bakala azuk'xoy bitot'in xeyir-bərəkətə vaxun törəyinşakit'oğoxun haq'ale\"». ");
INSERT INTO udi_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hametər, Avrahamen hari iz nökərxoval ext'i qaybaki iz mandala gala, yəni Beer-Şevinane taśi. Şot'in miyane iz çadırxo laxi çurpey. ");
INSERT INTO udi_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sa heq'ədər vədə c'ovakit'uxun oşa Avrahami ǔmǔğo hari p'anep'i ki, iz viçi Naxori çuux Milk'ayal ğarmuxe bake: ");
INSERT INTO udi_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","kalat'ay s'i Usey, p'ə̌mcit'ay s'i Buz, xibimciyo Gemuel (şo Arami bavane baksa), ");
INSERT INTO udi_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","oşa K'esed, Xazo, P'ildaş, İdlaf saal Bet'uel. ");
INSERT INTO udi_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bet'uelaxun Rebek'a uk'ala xuyəre baki. Avrahami viçi Naxoreynak' izi çuux Milk'an eçeri ğarmux me muğoney. ");
INSERT INTO udi_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naxori Reuma uk'ala p'ə̌mci çuğoxun baki ğarmoğoy s'i isə metərey: T'ebah, Gaham, T'axaş saal Maak'a. ");
INSERT INTO udi_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saray sabaç̌ saq'o vǔğ usen ömüre baki. ");
INSERT INTO udi_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Şo Kənan oç̌ali Giryat'-Arbina, həysə beşi Xevron uk'ala şəhəre p'ure, Avrahamenal hari Saray loxol muzin ǒnepi neğe śipi. ");
INSERT INTO udi_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Oşa meyidi t'ǒǒxun hayzeri taśi xet'luğo metəre pi: ");
INSERT INTO udi_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Düze, efi k'ulnuz yəşəyinşbsa, ama avanan ki, zu miyalu tezu. Za tənginen sa ga tadanan, taşeri bezi p'urina oç̌alaxp'az». ");
INSERT INTO udi_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Xet'luğonal Avrahama pit'un: ");
INSERT INTO udi_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Ko mani exləte, ağa, hun mis'ik' amdar tenu ki! Beşi gərəmzəluğxo ən şaat' ga manunesa, taşa vi çuğo t'iya oç̌alaxp'a. Şuk'k'alen va tene uk'on ki, vi p'urineynak' miya ga tene bu». ");
INSERT INTO udi_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","T'e oç̌ala yəşəyinşala xet'luğon metər uk'at'an Avrahamen hayzeri izi şot'oğoxun heq'ədər irəzi baksuna ak'est'i bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Oşa pine: «İsə ki bezi p'urina efi k'ulnu oç̌alaxpsuna hik'k'al tenan nex, və̌x sa əyitəl uk'az: Śoxari ğar Efrona upanan ");
INSERT INTO udi_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","izi q'oruği t'e bel bakala Maxp'ela mağarina zaq'an toydi. İzi toy k'ənesa peq'an, şot'o ef piin běš təngə tadi haq'oz ki, beziyal efi k'ulnu p'uriğo oç̌alaxpseynak' gaq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Xet'lu Efron iz amdarxoy boş arśeney. Şot'in şəhəre bağala darvazin běš gireśi camaati t'ǒğǒl Avrahama qay pine: ");
INSERT INTO udi_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Hun pinu zu izbaki, bez ağa, isə ǔmǔxlaxa zu k'əz nex! Barta mot'o miya gireśi bezi azuk'enal ibakeq'an, zu t'e oç̌alal, t'e oç̌ali boş bakala mağarinal va payez tast'a. T'e ga ene p'ə̌bulla vine baki, taşa vi p'urina t'iya oç̌alaxp'a». ");
INSERT INTO udi_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Avrahamen xet'luğoxun heq'ədər irəzi baksuna ak'est'i p'urumal bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Oşa t'iya gireśit'oğoy běš Efrona qaybaki metəre pi: «Eki bezi əyitə oq'a ma saka, oç̌ali toy k'ənesa upa, zuval bez tənginə tadi haq'az vaxun bezi p'urina oç̌alaxp'ala t'e ganu». ");
INSERT INTO udi_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","T'e vədə Efronen Avrahama metəre pi: ");
INSERT INTO udi_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«K'əz nex ki? Barta vi uk'aloq'an baki! Me oç̌alen bip'baç̌ gümüşi təngəne bsa, mo t'etər sa təngə tene ki, mot'o görə vi q'a bezi arane exlət bakane. İsə taşa oç̌alaxp'a vi p'urina!» ");
INSERT INTO udi_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Avrahamenal Efronen gireśit'oğoy piin běš pi toya irəzibaki, c'evk'i bip'baç̌ gümüşi tənginə içoğoy haq'i toydalxon ayzap'k'ala ǰěnen ayzapi tanedi. ");
INSERT INTO udi_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Hametər, Mamrena ı̌ša, Maxp'ela bakala Efroni oç̌al, iz boş bakala mağarinaxun q'a xodurxoxun sagala, baneki ");
INSERT INTO udi_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Avrahami. Şəhəre bağala darvazin běš gireśi xet'luğonal bitot'in mot'o içoğoy piin at'unk'i. ");
INSERT INTO udi_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Mot'oxun oşa Avrahamen taşeri iz çuux Sara Maxp'ela uk'ala ganu bakala mağarina oç̌alaxebi. Me Maxp'ela Kənan oç̌ala, Xevroni Mamre uk'ala mə̌xluğa ı̌šaney. ");
INSERT INTO udi_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Xet'luğoy k'ulnu bakala t'e gaal, t'e ganu bakala mağaral baneki p'ə̌bulla Avrahami. Avrahamen şot'o iz p'uriğo oç̌alaxpseynak' təngə tadi haneq'ey. ");
INSERT INTO udi_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Avraham lap q'ojabakeney, iziyal hər şey buney, şot'o görə ki, Q'ončuğon şot'oxun İz xeyir-bərəkətə kamtenebsay. ");
INSERT INTO udi_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Sa ği Avrahamen izi bito əşurxo taşala nökərə iz t'ǒğǒl k'alpi pine: «Vi tadala əyiti loxol çurpsuna ak'est'eynak' vi kula bez c'ile loxol laxi ");
INSERT INTO udi_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","göye q'a oç̌ali Buxačux bakala Q'ončuğo elasp'a ki, bezi ğareynak' beşi həysə bakala ganuxun xuyər ten haq'al, şot'aynak' me kənanluğoy xuyərmoğoxun eşt'un tez çuresa. ");
INSERT INTO udi_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bezi c'eri ganu, bezi q'oomxoy t'ǒğǒl taśi t'et'iin xuyər bə̌ğə̌bi eçalnu bezi İsaak'eynak'». ");
INSERT INTO udi_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nökəren Avrahama pine: «P'oy xuyər miya eysun nu çureğayin hetər bakale? Yaq'abaz vi ğaral taśi t'iya, vi c'eri ganuq'an baki?» ");
INSERT INTO udi_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Avrahamen qaybaki metəre pi: «Sal sa vədə! ");
INSERT INTO udi_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Za bezi bavay k'oyaxun, bezi nanaxun baki oç̌alaxun c'evk'i göye Buxačux bakala Q'ončuğon İçin vi yaq'a qayk'ale. \"Vaxun bakit'oğo mandale me oç̌al\" pi za əyit tadiyone Şo, vaxun běš İzi angela yaq'abi vi əşlə suuk'bale Şot'in, hunal bezi ğareynak' xuyər bə̌ğə̌bi eçalnu. ");
INSERT INTO udi_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Əşe, xuyər iç va gərbaki miya eysun nu çureğayin, mo vi taxsır tene, zaxun \"vi tadi əyiti loxol ten çurpi\" əyit ten ibakal. Ama k'ə bakale bakeq'an, bezi ğara t'e oç̌ala taysa ma barta!» ");
INSERT INTO udi_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nökərenal iz kula Avrahami c'ile loxol laxi elasepi ki, bitova şot'ay pi k'inək' bale. ");
INSERT INTO udi_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hametər, nökəren iz ağaxun vis' buş ext'i k'ə şaat' payur bunesa şot'oğoy loxol laxi yükləyinşit'uxun oşa Aram-Naharayima yaq'anebaft'i. Avrahami viçi Naxori yəşəyinşala şəhər t'et'iyaney. ");
INSERT INTO udi_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Şo hari şəhəre bağala gala p'ap'at'an biyəsç̌oney. Běneği xuyərmoğon hari xe taşala vədəne, bureqi izi buşurxo efi miya bakala kərizəxun xe ǔğest'a. ");
INSERT INTO udi_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Şot'in afırıpsa burqi pine: «Ay Q'ončux, ay bezi ağa Avrahami Buxačux, ğe bezi əşurxo Hun yönə bada, bezi ağa Avrahamaxun Vi xeyirxaxluğa kammaba. ");
INSERT INTO udi_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mone, çurpezu həysə me kərizi bel, me şəhəri xuyərmoğonal hari memiin xet'un taşt'a. ");
INSERT INTO udi_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","T'etər ba ki, zu xuyərmoğoy mat'u \"eça vi gamataxun xe ǔğə̌z\" pit'uxun oşa za qaybaki \"ko mani əyite, həysə vi buşurxoval ǔğest'oz\" uk'ayin, haşoval Vi k'ul İsaak'eynak' c'ək'p'iyoq'an baki. Barta mo zaynak' sa nišanq'an baki, t'e vədə zuval avabakoz ki, Vi sa kul bezi ağay loxole». ");
INSERT INTO udi_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Şot'in hələ afırıpi tene çark'ey, sa xuyər izi ə̌mnəbel gamat xeneynak'e hari. Mo Avrahami viçi Naxori q'a izi çuux Milk'ay nəvə Rebek'aney, şot'oğoy Bet'uel uk'ala ğare xuyər. ");
INSERT INTO udi_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Xuyər gele gözəl xuyərey, hələ işq'aral tene taśey. Şot'in kərizəxun xena buybi qaybaki tağat'an ");
INSERT INTO udi_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Avrahami nökəren şot'ay běšt'an bot'est'i pine: «Za vi gamataxun samal xe tades bankon, ǔğə̌z?» ");
INSERT INTO udi_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Xuyərenal qaybaki \"ko mani əyite, bez ağa, ext'a ǔğə̌\" pi iz gamata nökərə tanedi ki, ǔğeq'an. ");
INSERT INTO udi_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Nökəren ǔği çark'it'uxun oşa xuyəren pine: «Barta vi buşurxoynak'al xe eçaz boşşamin ǔğeq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Metər piyal gamati boş mandi xena nə̌ve boş ams'ibi t'inet'eri ki, kərizəxun saal xe eçeri bak'ale. Hametər, xuyəren xe zapi buşurxo bitova ǔğesedi. ");
INSERT INTO udi_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nökəren isə izi ǰomoxun əyit tene c'evksay, izi t'evərcə afırıpi çureśit'oğo bala me xuyəri loxol t'ǒǒxun běği, şot'o həgigiyal Buxačuğon iz běš c'evk'i nu c'evksuna q'amişaksune çuresay. ");
INSERT INTO udi_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Buşurxon ǔği boşit'uxun oşa Avrahami nökəren c'evk'i xuyərə bǒxmǒğo lavk'ala toyexlu sa q'ızıli halq'a saal p'ə̌ dənə q'oxlang tadi ");
INSERT INTO udi_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","pine: «İsə upa běyn, hun şi xuyərnu? Vi bavay k'oya mandala ga bune, yax me üşe q'onağbes banankon?» ");
INSERT INTO udi_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Xuyərenal qaybaki \"Milk'ay q'a Naxori ğar Bet'ueli xuyərzu\" pine. ");
INSERT INTO udi_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Oşa saal pine: «Yast'a heyvanxo tadala kološ q'a yemal gelene, k'oya və̌ynak' mandala gaal bune». ");
INSERT INTO udi_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Me əyitmoğo ibakat'an Avrahami nökəren çökt'i Q'ončuğo şükürebi. ");
INSERT INTO udi_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Şot'in pine: «Bezi ağa Avrahami Buxačux bakala Q'ončuğo alxışq'anbaki, İzi nu badalbakala çuresuna ak'est'i qı̌ yaq'a tene efi Şot'in bezi ağa! Mone, Q'ončuğon za düz bezi ağay q'oomxoy k'oyane eçeri!» ");
INSERT INTO udi_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Xuyəren isə t'it'eri me bakit'oğo bitova izi nana q'a k'oya bakala çupuxxo exlətebi. ");
INSERT INTO udi_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebek'ay sa viçiyal buney, iz s'i Lavan. Şo c'eri t'ist'un kərizi bel çurpi me amdari t'ǒğǒle taśi. ");
INSERT INTO udi_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Şot'in Rebek'ay bǒxmǒğo lavk'i halq'ina q'a ə̌mel lavk'i q'oxlangxo ak'i Rebek'axun bakit'oğo bitova avabakat'an taśi t'e amdara aksune çureśi. Taśiyal běneği ki, amdar Rebek'an pi gala, kərizi bel iz buşurxoy t'ǒğǒl çurpene. ");
INSERT INTO udi_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lavanen ı̌šalayinşaki pine: «Ay Q'ončuğonxeyir-bərəkət tadi amdar, miya het'u görən çurpe? Eki q'onağbaz va, vi mandala ganuval həzirbez, vi heyvanxo efala ganuval». ");
INSERT INTO udi_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hametər, Lavanen amdara haq'i hare k'oya. Eçeri buşurxoy loxol bakala yükə ams'ibi içoğoy běš kološ q'a yeme śipi, oşa q'onağxoynak' xeyal eneçeri ki, içoğoy turmoğoq'at'un os'k'i. ");
INSERT INTO udi_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Eçeri šum laxala vədine Avrahami nökəren pine: «Bezi miya eysuni s'iya nu uk'ayiz, šum tez bot'al». Lavanenal qaybaki \"upa\" pine. ");
INSERT INTO udi_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nökəren exlətpsa burqi pine: «Za Avrahamene yaq'abe, şot'ay nökərzu. ");
INSERT INTO udi_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Bezi ağay hər şey but'ux, Q'ončuğon şot'oxun İzi xeyir-bərəkətə kamtenebi. Eğelxo, beliyox, q'ızıl-gümüş, çuux nökərxo q'a işq'ar nökərxo, buşurxo q'a elemxo - mot'oğo bitova iz belxun oq'a baramine tadi Q'ončuğon bez ağa. ");
INSERT INTO udi_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","İz çuux Saran izi q'ojabaki vədine bezi ağaynak' sa ğaral eneçeri, ağanal pine ki, bezi k'ə bunesa bito me ğareq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","İsəəl mone, bezi ağan za elasp'est'i əyite tadest'i ki, izi ğareynak' içoğoy bakala ganuxun, yəni kənanluğoxun xuyər tez haq'al. ");
INSERT INTO udi_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Za tapşurebi ki, hari memiin, izi q'oomxo bakala ganuxun izi ğareynak' xuyər eçaz. ");
INSERT INTO udi_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Bezi ağaxun xavarez haq'i ki, p'oy xuyər zaxun eysun nu çureğayin k'ə baz. ");
INSERT INTO udi_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Za qaybaki pine: \"Bezi çalxala, bezi həmişə İzi laxi yaq'en tağala Q'ončuğon İçin vi yaq'a qayk'ale, vaxun běš İzi angela yaq'abi vi əşlə suuk'bale, hunal bezi q'oomxoy, bezi p'iyaxun bakalt'oğoy boşt'an xuyər bə̌ğə̌bi eçalnu bez ğareynak'. ");
INSERT INTO udi_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ama əşe, xuyərə va nu tadayt'un, c'eki eki. Avabakoz ki, hun vi tadi əyiti loxol çurpi bezi q'oomxoy ç̌omol śirik' taśenu, ene t'et'iin tağayal vi taxsır tene\". ");
INSERT INTO udi_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Zuval ğe hari efi kərizi t'ǒğǒl p'ap'at'an afırıpi metərez pi: \"Ay bezi ağa Avrahami Buxačux bakala Q'ončux, bezi əşlə Hun yönə bada! ");
INSERT INTO udi_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mone, çurpezu həysə me kərizi bel. T'etər ba ki, həysə hari memiin xe taşala xuyərmoğoy mat'u <eça vi gamataxun xe ǔğə̌z> ");
INSERT INTO udi_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","pit'uxun oşa za qaybaki <ko mani əyite, həysə vi buşurxoval ǔğest'oz> uk'ayin, haşoval Vi bezi ağay ğareynak' c'ək'p'iyoq'an baki\". ");
INSERT INTO udi_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Hələ hametər fikirbala gala, bězği Rebek'a iz ə̌mnəbel gamat enesa. Şot'in śiri kərizəxun xena buybi qaybakat'an pizu: \"Banekon vi gamataxun xe ǔğə̌z?\" ");
INSERT INTO udi_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Za hat'e dəyğa gamata boxodi, qaybakiyal metəre pi: \"Ko mani əyite, barta vi buşurxoynak'al xe eçaz ǔğeq'at'un\". Hametər, zuval ǔzği, oşa eçeri bezi buşurxoval ǔğesedi. ");
INSERT INTO udi_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Oşa içuxun xavarez haq'i ki, hun şi xuyərnu, qaybakiyal pine: \"Naxori q'a Milk'ay ğar Bet'ueli xuyər\". Zuval eçeri izi bǒxmǒğo halq'ina, izi kiyel q'oxlangxo lavk'it'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ç̌ooq'a biti bezi ağa Avrahami Buxačux bakala Q'ončuğo alxışezbi. Bezi yaq'a qaypi za düz bezi ağay viçey ç̌omo eçeriyone Şo, eçerene ki, ağay viçey nəvə izi ğareynak' haq'az. ");
INSERT INTO udi_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","İsə və̌n upanan, bezi ağay niyətə izi boş nu efi me xeyir əşlin bul biq'suna ə̌m zap'nanne təə? Efi axırınci əyitə upanan ki, zuval bezi əşlə avabakaz». ");
INSERT INTO udi_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lavanen q'a Bet'uelen metərt'un coğab tadi: «Q'ončuğon İçin me əşlə ə̌m zapenesa, yax əyit tene kofst'a! ");
INSERT INTO udi_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mo Rebek'a, mo hun - ext'a taki! Barta Q'ončuğoy çureğaloq'an baki, taşa vi ağay ğareynak' çuuxq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Şot'oğon metər uk'at'an Avrahami nökəren oç̌ala p'ap'amin k'os'p'aki Q'ončuğo şükürebi. ");
INSERT INTO udi_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Oşa izi eçeri payurxo c'evk'i Rebek'a q'ızıl-gümüş q'a cürbəcür paltarxone tadi. Şot'in Rebek'ay viçeynak' q'a nanaynak'al toyexlu payurxone eçerey. ");
INSERT INTO udi_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hametər, Avrahami nökəren izi eysuni s'iya pi Lavani q'a Bet'ueli fikirəl avabakit'uxun oşa arśi içinal, içuxun hari amdarxonal kəyi-ǔt'unği, üşeyal hamiya mant'undi. Əyc'indəri savaxt'an nökəren pine: «İsə icaza tadaynan qaybaki bezi ağay t'ǒğǒlez tağon». ");
INSERT INTO udi_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Metər ukat'an Rebek'ay viçen q'a nanan xuyərə tərbsun nu çureśi pit'un: «Barta beş xuyər sa vis' ğiyal beşi t'ǒğǒl bakeq'an, oşa tananğon». ");
INSERT INTO udi_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ama Avrahami nökəren qaybaki metəre pi: «İsə ki Q'ončuğon İçin me əşlə yönə badene, boxoypsuni məənə tene bu. Za yaq'abadanan tağaz bezi ağay t'ǒğǒl». ");
INSERT INTO udi_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","T'e vədə pit'un: «Ekinan Rebek'axun içuxun xavar haq'en, şot'in k'ə uk'ayin şoq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebek'a k'alt'unpi, şot'inal içuxun \"me amdaraxun tansa?\" pi xavar haq'at'an qaybaki pine: «Hoo, tazsa». ");
INSERT INTO udi_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Hametər, Rebek'a Avrahami nökərə q'a şot'oxun hari amdarxo gərbi yaq'abadalat'un baki. Rebek'ay t'ǒğǒl içu muč'anaq' tadi kalabi nökərəl buney. ");
INSERT INTO udi_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebek'a me əyitmoğon xeyir-bərəkət tadit'un yaq'abadi: «Ay xunçi, barta vaxun bakit'oğoy say hazarxon, vis' hazarxonq'an baki! Barta vi əyloğon düşmənxoy şəhərmoğo bağala darvazoğo ç̌axç̌uxp'iq'at'un c'ovaki!» ");
INSERT INTO udi_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebek'a q'a izi çuux-nökərxoval buşurxoy loxol arśi Avrahami nökəri bač'anexun tat'unśi. Hametər, nökəren Rebek'a ext'i yaq'anebaft'i. ");
INSERT INTO udi_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","İsaak' isə sa heq'ədər vədəney ki, Beer-Laxay-Roina navadaney. Avrahami nökər q'a Rebek'a hari p'ap'ala vədine, şo Negev ams'i oç̌ala təzəne qaybakey, ");
INSERT INTO udi_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","biyəsç̌oyeyal çöle c'eri \"samal tarak'az\" uk'at'an, běneği mone, ə̌xiləxun buşurxone eysa! ");
INSERT INTO udi_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebek'an içinal İsaak'a anek'i, şo buşe loxolxun śiri ");
INSERT INTO udi_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","nökərəxun xavare haq'i: «Me beşi běš eğalo şuva?» Nökərenal qaybaki \"bezi ağane\" pine. Mot'o ibakala k'inək' Rebek'an çalmina ext'i izi ç̌oya but'ek'i. ");
INSERT INTO udi_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Oşa nökəren bakit'oğo bitova İsaak'a exlətebi, ");
INSERT INTO udi_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","İsaak'enal Rebek'a ext'i iz nana Saray çadırane taşeri. Rebek'a şot'ay çuuxe baki, şo İsaak'i ük'e gelene bask'i. Metərluğen, izi nana p'urit'uxun oşa İsaak'i ç̌oyen axšumpsane burqi. ");
INSERT INTO udi_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Avrahamen q'erəz sa çuuxe haq'i, iz s'i Get'ura. ");
INSERT INTO udi_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Get'uranal Avrahameynak' me ğarmoğone eçeri: Zimran, Yok'şan, Medan, Midyan, İşbag saal Şuah. ");
INSERT INTO udi_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yok'şanaxun Şeva q'a Dedane baki. Dedanaxun aşşurluyox, let'uşluyox saal leumluyox uk'ala azuk'xone əmələ hari. ");
INSERT INTO udi_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midyanaxun Efa, Efer, Xanok', Avida saal Eldaahe baki. Morox bito Avrahami Get'uraxun baki ğarmoğoxun əmələ hariyoroxey. ");
INSERT INTO udi_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Avrahamen izi var-dövlətə bitova İsaak'eynak'e efi. ");
INSERT INTO udi_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","İzi t'iyə̌mi çupuxxoxun baki ğarmoğo isə, hələ iç dirist' hamaq'un, içoğoy paya tadi běğc'eğalaçe yaq'abi ki, izi İsaak'axun ə̌xilq'at'un baki. ");
INSERT INTO udi_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Avraham düz sabaç̌ yetmiş qo usene yəşəyinşi. ");
INSERT INTO udi_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","P'uri izi bavoğoy t'ǒğǒl, elmux tadi t'e dünyəne tağat'anal izi yəşə c'ovak'est'i, iz pul boşe taśi. ");
INSERT INTO udi_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","İzi ğarmoğon, İsaak'en q'a İsmailen, şot'o taşeri Mamreni mə̌xluğa ı̌ša, Maxp'ela uk'ala mağarina oç̌alaxt'unbi. Me mağara bakala q'oruğ süft'ə xet'lu Śoxari ğar Efroniney, ");
INSERT INTO udi_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Avrahamen şot'o xet'luğoxun təngə tadi haneq'ey. Şot'o eçeri miya izi çuux Saray t'ǒğǒlt'un oç̌alaxp'i. ");
INSERT INTO udi_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Avraham p'urit'uxun oşa Buxačuğon şot'ay ğar İsaak'a xeyir-bərəkəte tadi. İsaak' isə Beer-Laxay-Roinane baksay. ");
INSERT INTO udi_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Moval İsmailaxun, Avrahameynak' Saray misirlu çuux-nökər Acaren eçeri ğaraxun bakit'oǧoy siyəyi. ");
INSERT INTO udi_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Kalat'uxun burqi mis'ik't'ul śirik' İsmaili ğarmux metəre taysay: İsmaili süft'in ğar Nevayot, oşa K'edar, Adbeel, Mivsam, ");
INSERT INTO udi_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mişma, Duma, Massa, ");
INSERT INTO udi_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Xadad, Tema, Yetur, Nafiş saal K'edma. ");
INSERT INTO udi_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Mo İsmailaxun baki ğarmoğoy q'a oşal içoğoxun əmələ hari tayfoǧoy s'iyurxoney. Me p'as's'e ğaraxun törəyinşakit'oğoy mandala ayizmux q'a içoğoy çadırxo laxi çurk'ala ganxoval içoğoy bavoğoy s'iyene taysay. ");
INSERT INTO udi_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","İsmailen iz pula q'ic'p'i t'e dünyəne, izi bavoğoy t'ǒğǒl tağat'an düz sabaç̌ otuz vǔğ yəşt'əney. ");
INSERT INTO udi_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Şot'oxun törəyinşakit'oğoy bakala ganxoval Xavilaxun burqi Misiri oç̌alxo burqeğala ganu ı̌ša, Aşşura tağala yaq'e loxol bakala Şural śirik' tanesay. Morox bito izi p'as's'e ğaraxun əmələ hariyoroxey, bitoval suna ı̌šane baksay. Ama p'urumal, sa ğaraxun baki tayfa t'e soğo ğaraxun baki tayfinaxun yaq'ax tene taysay. ");
INSERT INTO udi_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","İsəəl Avrahami ğar İsaak'axun bakit'oğoxun exlətp'en. Avrahamaxun izi ğar İsaak'e baki. ");
INSERT INTO udi_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","İsaak'i q'ırx yəş bakat'an şot'in Rebek'ane haq'i. Rebek'a P'addan-Aramaxuney, izi bava aramlu Bet'uel, izi viçiyal aramlu Lavaney. ");
INSERT INTO udi_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebek'a əylə tene manst'ay, İsaak'enal Q'ončuğo afırıpi xoyinšebsay ki, izi çuğoy əyelq'an baki. Q'ončuğon şot'ay afırığo inebaki, Rebek'al hari əyləne mandi. ");
INSERT INTO udi_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebek'ay tapane bakala əyloğon suna təpiləyinşbsa burqat'an şot'in Q'ončuğoxun \"mo k'ə upsune baki\" pi xavare haq'i, ");
INSERT INTO udi_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Q'ončuğonal şot'o metəre pi: «P'ə̌ əyelen tarast'a hun vi boş, p'ə̌ azuk' törəyinşakale vi tapane bakalt'oğoxun. Me dünyəne eğala ğinaxun cöybakalt'un şorox, soğo həmişə t'e sunt'uxun zorba bakale, kaloval mis'ik't'ay əyiten tağala bakale». ");
INSERT INTO udi_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Əyel bakala vədə hari p'anep'i, Rebek'anal əkiz ğarmuxe eçeri. ");
INSERT INTO udi_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Süft'ə baki əylin irəng č'ap'-č'oč'aney, izi bədəni loxolal t'ema pope buy ki, unk'on heyvani balaney. Şot'ay s'iya Esavt'un laxi. ");
INSERT INTO udi_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Me əylin bač'anexunal hari p'ə̌mciyone baki, şo bakat'an Esavi dabanaxun biq'ine c'erey, şot'ay s'iyal eçeri İak'ovt'un laxi. Me əylux nanaxun bakat'an İsaak'i altmış yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Əylux hari kalat'unbaki. Esav şaat' ǒxə̌lbale baki, şo k'oya tene bə̌ğə̌yesay, pes banekon dim çölmoğoney. İak'ov isə şip'ey, şo k'ojin əyeley. ");
INSERT INTO udi_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","İsaak'en çölnə heyvani yeq' çureğaley pi Esav iz ük'e gele basksay, Rebek'ay piin işiğ isə İak'ovey. ");
INSERT INTO udi_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sa ği İak'oven mərcin xoraye boxsay, hame vədine Esaval çölexun mandak' k'oyane hari. ");
INSERT INTO udi_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Şot'in İak'ova pine: «Usum baka ke vi boxala č'oč'a xorayaxun bapa tada, busa bisazu!» Mot'o görət'un Esavi s'iya hamal Edom nexey. ");
INSERT INTO udi_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","İak'oven isə metəre pi: «Upa ki, meyin oşa k'ojin kala ğar baksuni haq'q'a vaz tast'a, zuval tadaz». ");
INSERT INTO udi_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esavenal qaybaki \"busa bisazu miya, kala ğar baksuni haq'q'e ak'esa həysə bez piyes\" pine. ");
INSERT INTO udi_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","T'e vədə İak'oven metəre pi: «Elasp'a, oşa!» Esavenal elasp'i əyite tadi ki, k'ojin kala ğar baksuni haq'q'a İak'ovane tast'a. ");
INSERT INTO udi_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Esaven metər pit'uxun oşa İak'oven şot'o mərcin xorayaxunal bapi tanedi, šumal. Esaven kəye, ǔneği, izi tapana boşevk'iyal hayzeri taneśi, k'ojin kala ğar baksuni haq'q' isə sal izi eyexal tene baft'i. ");
INSERT INTO udi_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Oşa t'etəre baki ki, Avrahami döörəst'ə baki k'inək', t'e oç̌ala p'urum busaluğe hari, İsaak'al hayzeri Gerara, filist'luğoy padçağ Avimelek'i t'ǒğǒle taśi. ");
INSERT INTO udi_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Miya harit'uxun oşa Q'ončux İsaak'a ak'eśi pine: «Me oç̌alxoxun c'eri Misirə ma taki, Bezi va uk'ala ölkinə manda. ");
INSERT INTO udi_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Miya çurpa, Zuval vaxun bakoz, va xeyir-bərəkət tadoz. Vi bava Avrahama tadi əyiti loxol çurk'oz Zu, me oç̌alxoval bito vi bakale, vaxun törəyinşakit'oğo mandale vi həysə çurpi ganxo bito! ");
INSERT INTO udi_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Vaxun əmələ eğala nəsili saya göynul bakala muč'uliğoy hama gele booz, me oç̌alxoy bitova şot'oğo tadoz. Vaxun bakit'oğoxun haq'ale xeyir-bərəkətə oç̌ali ç̌oyel bakala azuk'xon bitot'in. ");
INSERT INTO udi_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Şot'o görə ki, Bezi əyitəxun tene c'eysay Avraham, Bezi içu bürüşalt'oğoy q'a tapşurbalt'oğoy bitova bex p'ap'esepsay, Bezi içu uk'alt'oğoy q'a zombalt'oğoy bitova ǔmǔxelaxsay». ");
INSERT INTO udi_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","İsaak'enal Buxačuğon içu pi k'inək' bi Gerara çurepi. ");
INSERT INTO udi_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Gerara bakalt'oğon İsaak'i t'ǒğǒl Rebek'a ak'i şot'ay şu baksuna xavar haq'at'an İsaak'en şot'o iz xunçi pine çalxest'i. Şot'in q'ı̌nebsay ki, \"bezi çuuxe\" uk'ayin, Rebek'a işq'arsuz efseynak' içu besp'at'un, axıri Rebek'a gele gözəley. ");
INSERT INTO udi_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Hametər, sa heq'ədər vədə hari c'ovaneki, sa ğiyal filist'luğoy padçağ Avimelek'en ayninaxun běği anek'i ki, mone, İsaak'en Rebek'ane q'uj-q'ujbsa. ");
INSERT INTO udi_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","T'e vədə Avimelek'en İsaak'a iz t'ǒğǒl eçest'i pine: «Zu bezi ak'alt'u azk'i! Şo vi çuux baksunen het'u görən nex ki \"bezi xunçine\"?» İsaak'enal qaybaki pine: «Q'ı̌zbi ki, bezi çuux baksuna avabakayt'un şo işq'arsuzq'an mandi pi za besp'at'un». ");
INSERT INTO udi_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Avimelek'en isə pine: «Vi xavar bune sal beş bel k'ə eyese bakoy? P'oy soğo \"şot'ay işq'ar tene bu\" pi vi çuğoxun bask'iyniy, t'e vədə k'ə balyaniy? Mot'ay hetər sa günax baksuna avanu hun?!» ");
INSERT INTO udi_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Oşa Avimelek'en camaata əmir tadi pine: «Me amdara q'a izi çuğo əyit uk'al bakayin iz elmoğo haq'anan!» ");
INSERT INTO udi_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Hametər, İsaak' t'e oç̌ala çurpi taxıl bist'ane burqi. Q'ončuğon şot'o xeyir-bərəkəte tadi, şot'inal t'e usen sabaç̌ q'at gele bare ext'i. ");
INSERT INTO udi_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Şo taysun varlayinşebaksay, hariyal gele varlu, s'ila sa amdare baki. ");
INSERT INTO udi_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Filist'luğon şot'ay sürüğo bakala eğel-keçiğoy q'a beliğoy saya, şot'ay nökərxoy heq'ədər baksuna ak'at'an içoğoy paxılluğene biq'i. ");
INSERT INTO udi_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Burt'unqi hələ iz bava Avrahami döörəxun mandi, şot'ay nökərxon kašp'i c'evk'i kərizxo bitova k'ul bapi buypsa. ");
INSERT INTO udi_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Avimelek'en için isə İsaak'a metəre pi: «Memiin c'eri tağayvax şaat'e bakon, şot'o görə ki, metər sa var-dövləti q'ončuğo beşi t'ǒğǒl efsun, yaxun zorbat'u eçeri beş boş bast'un upsune». ");
INSERT INTO udi_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","İsaak'al t'et'iin c'eri, taşeri izi çadırxo Gerari dərənene laxi çurk'ala baki. ");
INSERT INTO udi_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Şo miya harit'uxun oşa bureqi izi bava Avrahamen kašp'est'i kərizxo p'urum kašp'i təmizbsa, şot'o görə ki, Avraham p'urit'uxun oşa filist'luğon t'e kərizxo bitova k'ul bapi buybet'uniy. Şot'in me kərizxoy loxol hələ izi bavan kašp'est'at'an laxi s'iyurxone laxsay. ");
INSERT INTO udi_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Sa ğiyal İsaak'i k'ulurxon içoğoy bakala t'e ganu təzə sa kəriz kašp'i ǔğə̌lə xet'un c'evk'i, ");
INSERT INTO udi_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ama gerarlu çobanxon \"mo beşi xene\" pi, burt'unqi İsaak'i çobanxoxun davabsa. İsaak'enal iz loxol dava biti t'e kərizi s'iya \"Esek'e\" laxi. ");
INSERT INTO udi_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Oşa q'erəz sa kərizt'un kašp'i c'evk'i, ama şot'ay loxolal davane biti, İsaak'enal kərizi s'iya \"Sit'nane\" laxi. ");
INSERT INTO udi_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","İsaak'en t'et'iin c'eri taśi q'erəz ganune kəriz kašp'i. Me kərizi loxol dava tene biti, İsaak'enal kərizi s'iya \"Rexovot'\" laxi pine: «Mone, c'evek'i Q'ončuğon yax irəət ganu, isə avuzbaki tum sakalyan me oç̌ala». ");
INSERT INTO udi_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Oşa İsaak' t'et'iin c'eri Beer-Şevinane taśi. ");
INSERT INTO udi_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","T'iya p'ap'i şü Q'ončuğon İsaak'a ak'eśi pine: «Zu vi bava Avrahami Buxačuxzu. Q'ı̌maba, Zu vaxunzu, Bezi k'ul Avrahama görə va xeyir-bərəkət tadi vaxun bakit'oğoy saya avuzboz Zu». ");
INSERT INTO udi_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","İsaak'enal t'et'iya q'urban eçala ga düzbi Q'ončuğoy s'iya duği şükürebi. Şot'in eçeri izi çadırxoval miya laxit'uxun oşa k'ulurxon sa kərizal kašp'i c'evt'unk'i. ");
INSERT INTO udi_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hame vədine Avimelek'en izi yön kul bakala Axuzzat'a q'a izi q'oşuni kalo bakala P'ik'ola ext'i hayzeri Geraraxun İsaak'i t'ǒğǒle hari. ");
INSERT INTO udi_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","İsaak'en şot'oğo ak'i pine: «K'ə pinan hare bezi t'ǒğǒl? P'oy za ak'ala pul tevə̌x buy, ef eyexun c'erene unk'on za efi t'ǒğǒlxun şəp'esun?» ");
INSERT INTO udi_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Şot'oğon qaybaki metərt'un pi: «Q'ončuğoy vi bač'ane çurpsun piin běše. Şot'o görəl, eki suna elasp'i əyit taden, barta yan beş arane sa irəziluğ ğaç̌eğen. Elasp'a ki, ");
INSERT INTO udi_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","yax vaxun pisluğ tene laft'al, axıri yanal va pisluğ teyan be. Vaynak' həmişə beşi piin loxol gane bake, cöybaki tağat'anal yaxun pis əyit ten ibake. İsə mone, Q'ončuğoyxeyir-bərəkətə haq'i sa amdarnu hun». ");
INSERT INTO udi_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Me əyitmoğo ibakat'an İsaak'en eçeri şot'oğo q'onağebi, arśiyal bito sagala kəyi-ǔt'unği. ");
INSERT INTO udi_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Əyc'indəri savaxt'an isə suna elasp'i əyit tadit'uxun oşa İsaak'en şot'oğo iz xeyir-bərəkətə tadi yaq'anebadi, şoroxal içoğoy ük' arxayin hayzeri tat'unśi. ");
INSERT INTO udi_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Hat'e ği İsaak'i k'ulurxon hari içu pit'un ki, kərizt'un kašp'i c'evk'e, şot'o pulxaşluğ tadi pit'un: «Xeyan bə̌ğə̌be!» ");
INSERT INTO udi_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","İsaak'enal eçeri t'e kərizi s'iya \"Şevane\" laxi, şot'o görə həysəəl t'e kəriz bakala şəhəri s'iya \"Beer-Şevat'un\" nex. ");
INSERT INTO udi_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esavi q'ırx yəş bakat'an şot'in taśi xet'luğoy xuyərmoğoxune içeynak' çuux eçeri: soğo Beeri xuyər Yehudit'aney, t'e soğoval Eloni xuyər Basemat'. ");
INSERT INTO udi_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Şorox p'ǒğə̌l hari İsaak'eynak' q'a Rebek'aynak' biin q'ač't'un baki. ");
INSERT INTO udi_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","İsaak' ene q'ojabakeney, izi pulmoğonal tene aksay. Sa ği şot'in izi kala ǧar Esava izi t'ǒğǒl k'alpi pine: «Bezi ğar». Esavenal qaybaki \"izbaksa, bez bava\" pine. ");
INSERT INTO udi_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Oşa İsaak'en əyitpsa burqi pine: «Zu ene q'ojabakezu, ğeyin əyc'inəl avabakala şey tene. ");
INSERT INTO udi_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hayza ǒxə̌lbseynak' lazım bakalt'oğo ext'a çöle taki, ğe bez s'iyen ǒxə̌lə c'eğalnu. ");
INSERT INTO udi_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ǒxəlbi eçeri heyvana bezi çureğalt'ullarik' həzirba zaynak' eça, zuval hələki bezi elmux bez boşe, t'e t'adlu ukuna kəyi va xeyir-bərəkət tadoz». ");
INSERT INTO udi_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Me exlətə bitova Rebek'an inebaki. Esaval hayzeri ǒxə̌lbseynak' çöle tağala k'inək' ");
INSERT INTO udi_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","izi ğar İak'ova k'alpi metəre pi: «Vi bavan vi viçə pit'oğoz ibaki, Esava pine ki, ");
INSERT INTO udi_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","taśi içeynak' heyvanq'an ǒxə̌lbi eçeri. Şot'o boxi vi bavaynak' taşale, şot'inal izi çureğala t'e t'adlu ukuna kəyi vi viçə xeyir-bərəkət tadale. Hələki izi elmux izi boşe, Q'ončuğoxun eğala xeyir-bərəkətə tast'une çuresa şot'o. ");
INSERT INTO udi_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","İsə ibaka va k'əz nex, bez ğar. ");
INSERT INTO udi_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Taki sürünəxun p'ə̌ dənə ən şaat' q'uzi manunesa c'ək'p'a eça miya, şot'oğo vi bavan çureğala k'inək' boxi həzirboz. ");
INSERT INTO udi_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Taşeri lanxon iz běš, şot'inal hələki izi elmux iz boşe, şot'oğoxun kəyi vane izi xeyir-bərəkətə tadon». ");
INSERT INTO udi_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","İak'oven isə qaybaki izi nana metəre pi: «Bez viçi Esavi bədən dirist' poplane, bez loxol isə pop tene bu. ");
INSERT INTO udi_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","İz kula za duğayin k'əz bon? Bavan avabakayin ki, içu əfçiz duğsa, xeyir-bərəkəti təə, q'arğişi q'ončux bakoz». ");
INSERT INTO udi_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","İz nanan isə şot'o pine: «Vi s'iya duği uk'ala q'arğişxo hari bezi ǒyneq'an bari, bezi ğar! Hun bez uk'alt'u ba: taki bezi pit'oğo eça». ");
INSERT INTO udi_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Hametər, İak'oven taśi q'uziğo eneçeri, izi nananal şot'oğo bavan çureğalt'ullarik' boxi həzirebi. ");
INSERT INTO udi_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Oşa Rebek'an taśi k'oyaxun izi kala ğar Esavi ən şaat' paltarxoxun eçeri şot'oğo izi mis'ik' ğar İak'ovane lapest'i. ");
INSERT INTO udi_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Şot'ay kulmoğo q'a ozana isə q'uzin t'olene bəc'ürpi. ");
INSERT INTO udi_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Axırda izi həzirbi ukuna q'a šumal İak'ovi kiyel biq'est'i yaq'anebi İsaak'i t'ǒğǒl. ");
INSERT INTO udi_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","İak'oven izi bavay t'ǒğǒl hari \"ay bava\" pi k'alepi, bavanal qaybaki \"miyazu, bezi ğar!\" pine. Oşa şot'oxun \"hun bezi mani ğaren baki?\" pi xavar haq'at'an ");
INSERT INTO udi_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","İak'oven pine: «Vi kala ğarzu - Esav. Vi za pit'oğo bizu, isə hayza arśa me bezi ǒxə̌lbi heyvani yeq'axun uka ki, oşa za xeyir-bərəkət tadavax». ");
INSERT INTO udi_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","İsaak'en izi ğara pine: «He usumen ǒxə̌lbi qaybaki, bez ğar?» İak'ovenal \"vi Buxačux bakala Q'ončuğon İçine heyvana bez běš c'evk'i\" pine. ");
INSERT INTO udi_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","T'e vədə İsaak'en pine: «Ǐša eki, bez ğar, va bez kula duği avabakoz vi Esav baki nu baksuna». ");
INSERT INTO udi_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","İak'ov izi bava İsaak'a ı̌šalayinşebaki, şot'inal izi kula duği pine: «Me səs İak'ovi səse, ama kulmux Esavi kulmuxe». ");
INSERT INTO udi_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","İsaak'en İak'ova Esavaxun c'ək'p'es tene baksay, axıri mot'ay kulmuxal Esavi kulmoğollarik' poplaney. Şot'o görəl İak'ova xeyir-bərəkət tadi ");
INSERT INTO udi_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","saal xavare haq'i: «Hun həgigiyal bezi ğar Esavnu?» İak'ovenal qaybaki \"hoo\" pine. ");
INSERT INTO udi_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","T'e vədə İsaak'en pine: «Vi ǒxə̌lbi eçeri yeq'axun bezi běš laxa, bezi ğar. Kəyit'uxun oşa va xeyir-bərəkət tadoz». İak'ovenal izi eçeri ukuna q'a fina bavay běš lanexi, şot'inal kəyi-ǔğit'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","pine: «İsə ı̌šabaka za muçp'a, bez ğar». ");
INSERT INTO udi_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","İak'ovenal ı̌šalayinşaki şot'o muçk'at'an Esavi paltari ade laft'i izi bavay bǒxmǒğo. T'e vədə İsaak'en şot'o me əyitmoğon xeyir-bərəkət tadi pine: «Ox, bezi ğare ade mo! Q'ončuğoy xeyir-bərəkəten bit'eśi oç̌ali adane tast'a bez ğaren! ");
INSERT INTO udi_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Barta Buxačuğon göynuxun hari arśala xoya q'a oç̌alen tadala bara vaxun kammaq'anbi, Barta vi exp'ala arum q'a s'orobala noč' bolq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Barta millətxonq'an va q'ulluğbi, Barta tayfoğon hari vi běš bulq'at'un k'os'p'i. Vi viçimoğoy loxol kalaluğbalnu hun, Nanaxun sa viçimoğon hari va bač'an k'os'p'alt'un. Va q'arğişbalo iç q'arğişi q'ončux bakale, Va xeyir-bərəkət tadalt'in içinal xeyir-bərəkət q'azayinşale». ");
INSERT INTO udi_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","İak'oven xeyir-bərəkətə haq'i izi bavay t'ǒğǒlxun c'eğala vədine Esave ǒxə̌ləxun qaybaki. ");
INSERT INTO udi_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Eçeriyal izi həzirbala ukunxoy ən şaat't'u həzirbit'uxun oşa şot'o izi bavaynak' taşeri pine: «Hayza arśa, bez bava, vi ğaren ǒxə̌lbi harene. Mone, vaynak' həzirbi ukunaxun uka za xeyir-bərəkət tada». ");
INSERT INTO udi_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","T'e vədə İsaak'en \"hun şunu?\" pi xavare haq'i, Esavenal qaybaki \"zuzu, vi kala ğar Esavzu\" pine. ");
INSERT INTO udi_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Mot'o ibakat'an İsaak'a t'ut'ultinene haq'i, şot'in pine: «P'oy t'evər hariyo şuvay? Zaynak' izi ǒxə̌lbi heyvani yeq'axun həzirbi ukune eçeri şot'in, zuval t'e ukunaxun kəyi şot'oz tadi bezi xeyir-bərəkətə. Xeyir-bərəkətə şuz tadesa, şot'ayal bakale!» ");
INSERT INTO udi_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","İzi bavay uk'alt'oğo ibakat'an Esaven içu efes nu baki ost'aar harayepi, şot'in ǒnek'a pine: «P'oy zu, ay bava? Zaal tada vi xeyir-bərəkətə, za xeyir-bərəkətsuz ma efa!» ");
INSERT INTO udi_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","İsaak'en isə qaybaki \"vi viçen hari vaynak' həzirbaki xeyir-bərəkətə bic'luğ əşp'est'i zaxun haneq'i\" pine. ");
INSERT INTO udi_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","T'e vədə Esaven pine: «Şot'ay s'iya İak'ov hat'etər tet'un laxe! Mot'oxun p'ə̌mci kərəme ki, za feret'est'a: süft'ə k'ojin kala ğar baksuni ext'iyərəne haq'i bezi kiyexun, isəəl zaynak' həzirbaki xeyir-bərəkətə!» Oşa saal əyitpsa burqi pine: «Bakes tene bakon ki, vi zaynak' efi xeyir-bərəkət nu bakane». ");
INSERT INTO udi_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","İsaak'en Esava metəre coğab tadi: «Şot'o vi kaloz laxi zu, beşi nəsiləxun bakalt'oğoval bitot'u şot'ay k'ulez bi. İzi exp'ala arum q'a s'orobala noč'al bol bakale şot'ay. P'oy şot'o metər sa xeyir-bərəkət tadit'uxun oşa isə va k'ə pi xeyir-bərəkət tadaz, bez ğar?» ");
INSERT INTO udi_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaven izi bava pine: «Yəni vi tadala q'erəz sa xeyir-bərəkət tevax bu, bezi bava? Zaxun vi xeyir-bərəkətə kammaba, bava!» Metər piyal hönkür-hönkür ǒnenepi. ");
INSERT INTO udi_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","T'e vədə İsaak'en izi ğara metəre pi: «Nə oç̌alen tadala bara ak'alnu hun, Nə alaxun hari arśala xoya. ");
INSERT INTO udi_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ə̌me zoren, q'ılınc fə̌ldi vi šuma q'azayinşalnu hun, Vi viçeyal q'ulluğa çurk'alnu. Ama vaxt' eğale ěqeğalnu hun şot'ay loxol, Va efala q'antarğina k'as'p'iyal çark'est'alnu vi elmoğo şot'ay kiin oq'a baksunaxun». ");
INSERT INTO udi_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ama bavan İak'ova tadi xeyir-bərəkətə görə Esaven izi viçə nifrətpsane burqi. Şot'in iz boş metəre nexey: «Male mande, yas efalyan samal oşa bavaynak'. Besp'oz t'e vədə kot'o!» ");
INSERT INTO udi_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","İzi kala ğar Esavi pi me əyitmux hari Rebek'ay ǔmǔğo p'anep'i, şot'inal izi mis'ik' ğar İak'ova izi t'ǒğǒl k'alpest'i pine: «Avanu ki, vi viçen va bespsune çuresa? Vaxun izi əcuğo haq'suni yaq'a mot'ost'ane aksa. ");
INSERT INTO udi_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","İsə ibaka k'əz nex, bez ğar: c'eki taki memiin! Bezi viçi Lavani t'ǒğǒl, Xarrana t'it'a. ");
INSERT INTO udi_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Vi viçey hirs bask'amin t'iya baka. ");
INSERT INTO udi_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Hevaxt' izi əcuğ c'ovanekon, vi bit'oğo izi eyexun c'evek'on - va k'alpi eçest'oz. Tene şot'in va besp'ale, oşal izi bula ukale». ");
INSERT INTO udi_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","İsaak'a isə, şot'inal İak'ovi taysuna ə̌m zapeq'an pi Rebek'an metəre pi: «Boşevt'unki za Esaven haq'i me xet'lu xuyərmoğon. İak'ovenal taśi şot'oğoxun xuyər haq'ayin bezi ği mə̌yine». ");
INSERT INTO udi_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hametər, İsaak'en İak'ova iz t'ǒğǒl k'alpi şot'ay tağala yaq'a xeyir-bərəkət tadit'uxun oşa, şot'o me əyitmoğo pi tapşurebi: «Kənanluğoxun xuyər ma haq'a. ");
INSERT INTO udi_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hayzeri P'addan-Arama, vi nanay bava Bet'ueli k'oyan taysa. T'iya vi nanay viçi Lavani xuyərmoğoxun sunt'u haq'a. ");
INSERT INTO udi_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Barta Bitova Başarbala Buxačuğon va xeyir-bərəkətq'an tadi, barta vaxun bakala əyloğoy saya t'eq'ədərq'an bi ki, vaxun azuk'xoq'an törəyinşaki. ");
INSERT INTO udi_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Barta Buxačuğon Avrahama tadi xeyir-bərəkət va q'a vaxun bakit'oğoval c'ovakeq'an, hunal Buxačuğon Avrahama tadi oç̌ali, vi həysə q'ərib k'inək' yəşəyinşala me oç̌ali q'ončux bakavax». ");
INSERT INTO udi_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Metər piyal İsaak'en İak'ova yaq'anebadi, İak'oval hayzeri P'addan-Arama, izi nana Rebek'ay c'eri oç̌alane taśi. Rebek'ay bava aramlu Bet'uel q'a izi ğar Lavan t'iyat'un baksay. ");
INSERT INTO udi_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaven İak'ovi P'addan-Arama taysunal avanebaki, şot'o xeyir-bərəkət tadi yaq'abadat'an tapşurbit'oğoval. İsaak'en İak'ova \"kənanluğoxun xuyər ma haq'a, taki t'et'iin xuyər haq'a\" upsun, ");
INSERT INTO udi_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","İak'ovenal izi nana-bavay əyitə běği hayzeri P'addan-Arama taysun - morox bito hari Esava p'anep'i. ");
INSERT INTO udi_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","T'e vədə Esaven q'amişebaki ki, izi taśi kənanlu xuyərmoğoxun çuux haq'i eşt'un izi bava İsaak'i ük'e sa dərde. ");
INSERT INTO udi_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hayzeriyal Avrahami ğar İsmaili ç̌omo taśi sa xuyərəl şot'oğoxune haq'i. Mo İsmaili xuyər Maxalat'ey, Nevayoti xunçi. Hametər, Esavi çupuxxoy p'ǒğǒ kənanluğoxun, soğoval İsmaili k'oyaxune baki. ");
INSERT INTO udi_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Metərluğen, İak'ov Beer-Şevinaxun c'eri Xarrana yaq'anebaft'i. ");
INSERT INTO udi_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sa heq'ədər yaq' taśit'uxun oşa běğ bureqi batksa, hariyal lap biyəbakat'an İak'oven sa ga bə̌ğə̌bi çurepi ki, miya bask'i kəybale. Sa ǰě ext'i izi biin oq'a laxiyal bask'i nep'axeśi. ");
INSERT INTO udi_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Şot'in nep'e aksa burqi, běneği ki, sa piləkəne bu, iz bul taśi göynule p'ap'sa, Buxačuğoy angelxoval t'e piləkəni loxolxun laśi śit'unsa. ");
INSERT INTO udi_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Q'ončuğon isə me piləkəni lap alin muxe loxol çurpi içu metəre nex: «Zu vi bavoğoy, Avrahami q'a İsaak'i Buxačux bakala Q'ončuxzu, Va q'a vaxun bakit'oğo tadoz Zu vi həysə bul laxi bask'i oç̌ala. ");
INSERT INTO udi_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Oç̌ali ç̌oyel bakala q'ume dənoğoy hama gele bakale vaxun törəyinşakit'oğoy say, dünyəni bip' t'ǒğǒlxunal şot'oğoy səs c'eğale. Vaxun q'a vaxun törəyinşaki nəsiləxun haq'alt'un xeyir-bərəkətə oç̌ali ç̌oyel bakala azuk'xoy bitot'in. ");
INSERT INTO udi_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Zu dim vaxun bakoz, va Bezi q'ənədi oq'a ext'i q'orişoz. Hun maya tağalnu taki, Bezi sa kul vi loxol bakale, ama va p'urumal qaydi me oç̌ala eçoz. Va əyitez tast'a, me piyorox hari bex p'ap'aminal Bezi əyiti loxol çurk'oz». ");
INSERT INTO udi_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","İak'oven nep'e boşt'an muğurbaki pine: «Mo hetər əşe? Hamiyane Q'ončux, bezi bula laxi bask'i hame gala! Sal bezi xavaral tene buy!» ");
INSERT INTO udi_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Metər fikirbiyal içu q'ı̌yene haq'i, şot'in pine: «Hat'etər sa ga tene me ga! Buxačuğon İçeynak' k'ojbi, göynuxun hari śiğala gane mo!» ");
INSERT INTO udi_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kəykəymoğo isə İak'oven hayzeri izi biin oq'a laxi ǰěna ext'i tikebi ki, Buxačuğon İçeynak' k'ojbi me ga c'ək'eśeq'an. J̌ěne Buxačuğoy s'iyen laxesuna ak'est'eynak'al eçeri şot'ay loxol zeytuni c'əyine śipi. ");
INSERT INTO udi_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","İak'oven t'e gane s'iya Bet'ele laxi, manu ki, oşa dirist' t'e şəhəri s'iyal hat'etər manedi. Běšaxun isə şəhəri s'i Luzey. ");
INSERT INTO udi_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Oşa İak'oven elasp'i pine: «Əgər Buxačux zaxun baki bezi tağala me yaq'a za q'orişayin, bezi sa tapan šuma q'a bezi loxol lak'ala paltara p'ap'esp'ayin, ");
INSERT INTO udi_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","zuval bezi elmux bez boş qaybaki bezi c'eri gala eyes bakayiz, bezi bavay k'oya bez bul dinc yəşəyinşes bakayiz, Q'ončux bez Buxačux bakale! ");
INSERT INTO udi_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Bezi tikp'i laxi me ǰě çurpi ga isə Buxačuğo bul k'os'pala ga bakale! Buxačuğon za tadalt'oğoy vis' payaxun sunt'uval qaydi İçu tadoz!» ");
INSERT INTO udi_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Oşa İak'ov p'urum yaq'anebaft'i, hariyal běğc'eğalaç bakala azuk'xoy oç̌alxo c'ere. ");
INSERT INTO udi_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Miya p'ap'i běneği ki, q'oruğa sa kərize bu, izi t'ǒğǒlal xib dənə eğeli sürü. Me kərizə eğelxo xe ǔğest'eynak't'un əşp'est'ay, izi ç̌oyelal kala sa ǰěne buy. ");
INSERT INTO udi_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sürüyox hari bito gireğat'an eğelběğalxon kərizi ç̌oyel bakala ǰěna tağaybi eğelxo ǔğest'unst'ay, oşa qaydi but't'unksay kərizi ç̌oya. ");
INSERT INTO udi_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","İak'oven eğelběğalxoxun xavare haq'i: «Və̌n mayalunan, ay viçimux?» Şot'oğonal qaybaki \"Xarranaxun\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","T'e vədə İak'oven pine: «P'oy Naxori nəvə Lavana çalnanxsa?» Şot'oğonal \"hoo, çalyanxsa\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","İak'oven saal xavare haq'i: «Hetəre Lavan? Şaat'e?» Eğelběğalxonal qaybaki \"şaat'e, moval izi xuyər Raxilə, eğelxo izi běš badene enesa\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","İak'oven pine: «Biyəbakseynak' hələ gelene bu, heyvanxo badala vədə tene. Bartanan xenaxun ǔğeq'at'un, oşa c'idi taşanan samalal ot't'ayinşeq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Eğelběğalxon isə metərt'un coğab tadi: «Beşi zor aytenesa, bitot'in içoğoy sürüğo eçeri gireśine buq'on ki, kərizi ç̌oyel bakala ǰěna iz ganuxun galdi beşi eğelxo ǔğest'es bakayan». ");
INSERT INTO udi_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Hametər exlətp'ala gala Raxiləl izi sürünəxun sagala hari p'anep'i. Şot'in izi bavay eğelxone běğsay. ");
INSERT INTO udi_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","İak'oven izi t'ayi Lavani xuyər Raxilə q'a şot'in c'idi eçeri sürünə ak'ala k'inək' taśi kərizi ç̌oyel bakala ǰěna tağaybi izi t'ayin sürünə ǔğesedi. ");
INSERT INTO udi_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Oşa taśi Raxilə muçp'i, mǔqexun ǒnek'al ");
INSERT INTO udi_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","izi şu baksunane pi. Raxilən şot'ay izi bavay q'oomxoxun baksuna q'a Rebek'ay ğar baksuna avabakala k'inək' t'it'eri mot'o izi bava pine. ");
INSERT INTO udi_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lavanen izi xunçey ğar İak'ovi eysuna ibakala k'inək' hayzeri şot'ay běše c'eri, şot'o q'ujbi-muçp'i izi k'oyane eçeri. İak'oven izi bel harit'oğoval bitova exlətp'it'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lavanen pine: «Bezi p'iyaxune bu vast'a, ı̌ša q'oomyan yan!» Metər piyal İak'ova izi k'oya enefi. Hari sa xaş c'ovakit'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lavanen İak'ova pine: «Düze, yan q'oomyan, ama mo şo upsun tene ki, hun bez loxol nisyə əşp'alanu. Za upa, k'ən çuresa vi bezi loxol əşpsuni gala tadaz?» ");
INSERT INTO udi_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lavani isə p'ə̌ xuyəre buy: kalo Leaney, mis'ik'oval Raxilə. ");
INSERT INTO udi_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea amdara ləçəq'tenesay, Raxiləy isə ham ç̌o gözəley, ham bədən. ");
INSERT INTO udi_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","İak'ovenal Raxilə izi ük'e bask'eney pi qaybaki Lavana pine: «Vi mis'ik' xuyər Raxiləz çuresa. Tandon za? Vi ke xuyərə haq'es bakseynak' vi loxol vǔğ usen əşp'oz». ");
INSERT INTO udi_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lavanenal \"k'əz nex ki, ext'i nu çalxala sa amdara tast'unaxunsa va tadayiz şaat'e bakon, çurpa əşp'a bez t'ǒǧǒl\" pine. ");
INSERT INTO udi_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hametər, İak'oven Raxilə haq'es bakseynak' vǔğ usen Lavani loxol əşebi. Ama xuyər iz ük'e t'emane bask'ey ki, me vǔğ usen içeynak' sa hema ği k'inək'e hari c'ovaki. ");
INSERT INTO udi_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Vədə hari p'ap'at'anal İak'oven Lavana pine: «Mone, beşi laxi vaxt' hari c'ovaneki, isə bezi çuğo za tada taşoz». ");
INSERT INTO udi_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lavanenal eçeri t'e pervare bakalt'oğo bitova k'alpi kala sa lašk'oye c'ovakest'i. ");
INSERT INTO udi_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Biyəbakat'an isə İak'ovi t'ǒğǒl Raxilə təə, ext'i Leane yaq'abi. İak'oval şot'oxun basek'i. ");
INSERT INTO udi_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Leay t'ǒğǒl baki şot'o q'ulluğbseynak' isə izi çuux-nökər Zilp'ane tadi. ");
INSERT INTO udi_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Hari kəyebaki, İak'ovenal běneği ki, mone, içuxun bask'iyo Raxilə təə, Leane! Şot'in hayzeri Lavani t'ǒğǒl taśi pine: «Mo he əşe bez bel ençeri? Hetəryan əyitp'ey yan? Teyan pi ki, vi loxol vǔğ usen əşp'oz, hunal za mot'ay gala Raxilə tadalnu? P'oy isə het'u görən za feret't'i?» ");
INSERT INTO udi_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lavanen qaybaki metəre pi: «Beşi miya kala xuyərəxun běš mis'ik't'u tast'un ədət tene. ");
INSERT INTO udi_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Yan bito hələ me sa şamat'al lašk'oyi loxol bakalyan, barta me sa şamat' c'ovakeq'an, oşa eki bezi mis'ik' xuyərəl tadoz va. Ama Raxilə haq'suni toya cöy hesabboz, meyin oşa sa vǔğ usenal əşp'in buq'on bez loxol». ");
INSERT INTO udi_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","İak'oval irəzinebaki. Lašk'oyi vǔğǔmci ği c'ovakit'uxun oşa İak'oven hari Raxiləl taneşeri. ");
INSERT INTO udi_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lavanen Raxiləy bač'anexun isə izi Bilha uk'ala çuux-nökərəne tadi. ");
INSERT INTO udi_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hametər, İak'oven Raxiləl haq'i içeynak' çuuxe bi, mot'ay galal vǔğ usen Lavani loxol əşebi. Şot'in Raxilə Leaxun gelene çuresay. ");
INSERT INTO udi_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Q'ončuğon ak'at'an ki, Lea İak'ovi ük'e p'ə̌mci galane, şot'o usum əyləne mandest'i, Raxiləy isə əyel tene baksay. ");
INSERT INTO udi_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea bı̌hi baki sa ğare eçeri, iz s'iya Ruven laxiyal pine: «Q'ončuğon bez dərdə anek'i, isə bez işq'aren za çureğale». ");
INSERT INTO udi_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Oşa Lea p'urum əyləne mandi, hariyal p'urum ğare baki. Şot'in pine: «Q'ončuğon inebaki bezi işq'aren za nu çuresuna, şot'o görə za sa ğaral tanedi!» Eçeriyal əylin s'iya Simeone laxi. ");
INSERT INTO udi_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Samal vədə c'ovakit'uxun oşa Lea saal bı̌hine baki, sa ğar eçeriyal pine: «İsə ene bez işq'ar za ğaç̌eğale, şot'o görə ki, xib ğarez eçeri zu şot'aynak'». Metər piyal əylin s'iya Levine laxi. ");
INSERT INTO udi_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Me əyləxun oşa Lea saal bı̌hine baki, hariyal p'urum ğare baki. Şot'in \"isə ene Q'ončuğo alxışp'oz\" pi əylin s'iya İudane laxi. Şo oşa ene əylə tene mandi. ");
INSERT INTO udi_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raxilən ak'at'an ki, içuxun əyel tene baksa, bureqi izi xunça paxılluğbi İak'ovi ç̌oya çuksa: «Za əyel tada, tene biyoz!» ");
INSERT INTO udi_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","İak'oviyal me əyiti loxol əcuğon biq'i pine: «Va Buxačuğon əyel nu tadit'uxun oşa, k'ə besez bakon ki zu?» ");
INSERT INTO udi_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Raxilən pine: «Ext'a, va bezi nökər Bilhaz tast'a. Kot'oxun bask'a, barta vaxun sa əyel eçeri bezi q'ujelq'an tadi. Metərluğen beziyal vaxun sa əyel bakale». ");
INSERT INTO udi_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ext'iyal izi nökər Bilha İak'ova çuux pi tanedi, İak'oval baśi şot'oxun basek'i. ");
INSERT INTO udi_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha bǐhi baki İak'oveynak' sa ğare eçeri. ");
INSERT INTO udi_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","T'e vədə Raxilən pine: «Buxačuğon bezi əşlə běği za haq'lune c'evk'i, bezi afırına ibaki za əyelsuz tene efi». Metər piyal əylin s'iya Dane laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Oşa Raxiləy nökər Bilha saal əylə mandi İak'oveynak' sa ğaral eneçeri. ");
INSERT INTO udi_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raxilən pine: «Bez xunçaxunez bul-bula hari zu, ama Buxačuğon za me davinaxun ç̌omas'ine c'evk'i». Metər piyal əylin s'iya Naft'aline laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lean isə běneği ki, iç ene əylə tene manst'a, ext'i izi nökər Zilp'ane İak'ova çuux pi tadi. ");
INSERT INTO udi_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Şot'inal İak'oveynak' sa ğare eçeri. ");
INSERT INTO udi_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","T'e vədə Lean \"bezi naxışen bineq'i\" pi eçeri əylin s'iya Gade laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Oşa Leay nökər Zilp'a p'urum əylə mandi İak'oveynak' sa ğaral eneçeri. ");
INSERT INTO udi_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","T'e vədə Lean pine: «Bəxt'əvərzu zu! \"Bəxt'əvəre\" pi k'əşinen ak'est'alt'un za çupuxxon!» Metər piyal eçeri əylin s'iya Aşere laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Sa ği, arum exp'ala vədəney, Ruvenen çölexun mandragor uk'ala meyvinəxun bə̌ğə̌bi izi nana Leaynak'e eçeri. Raxilən mot'o ak'i Lea pine: «Vi ğaren eçeri mandragorxoxun zaal tandon samal?» ");
INSERT INTO udi_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lean isə metəre pi: «Bezi işq'ara bezi kiyexun ext'enu, isəəl bezi ğaren eçeri mandragorxoy loxole vi pul?» Raxilənal qaybaki \"isə ki ketəren nex, ext'a me üşe işq'ar vaxunq'an bask'i, hunal mot'ay gala za ke mandragorxo tada\" pine. ");
INSERT INTO udi_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Hametər, biyəsin İak'ov çölexun k'oya eğat'an Lean şot'ay běš c'eri pine: «Me üşe zaxun bask'alnu, me haq'q'a bezi ğaren eçeri mandragorxo tadi hazq'e bez xunçaxun». İak'oval baśi t'e üşe Leaxun basek'i. ");
INSERT INTO udi_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Buxačuğon isə Leay afırığo ibaki şot'o t'e üşe əyləne mandest'i, şoval bı̌hi baki İak'oveynak' qomci kərəm ğare eçeri. ");
INSERT INTO udi_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","T'e vədə Lean pine: «Mone, bez nökərə ext'i işq'ara çuux pi tast'uni əvəzəne tadi za Buxačuğon». Metər piyal eçeri əylin s'iya İssak'are laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Oşa Lea p'urum əylə mandi İak'oveynak' ǔqǔmci ğarane eçeri. ");
INSERT INTO udi_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","T'e vədə Lean pine: «Buxačuğon za tadi paye toy tene bu! İsə ene hörmətbale za bez işq'aren, şot'o görə ki, ǔq ğarez eçeri şot'aynak'». Metər piyal əylin s'iya Zevulune laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Me əyləxun oşa Lean sa xuyərəl eneçeri, şot'ay s'iya Dinane laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ama Buxačuğon Raxiləy loxolal běneği, şot'o əyləne mandest'i, ");
INSERT INTO udi_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","şoval bı̌hi baki sa ğare eçeri. T'e vədə Raxilən pine: «Mone, ç̌omas'inebi za Buxačuğon. ");
INSERT INTO udi_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Barta Q'ončuğon zaynak' sa ğaral avuzbeq'an». Metər piyal əylin s'iya İosife laxi. ");
INSERT INTO udi_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raxilən İosifa eçerit'uxun oşa İak'oven Lavana pine: «Za tərba bezi c'eri gala, bezi ölkinə qaybakaz. ");
INSERT INTO udi_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Bezi çupuxxo q'a əyloğoval tada c'eğaz tağaz. Hunal avanu ki, şot'oğo exst'un bezi haq'q'e, vi loxol heq'ədər əşezbe!» ");
INSERT INTO udi_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lavanen isə qaybaki metəre pi: «Əgər bezi xətirə çurensasa, çurpa miya, ma taki! Fala běğest'i avabakezu ki, Q'ončuğon va görəne za xeyir-bərəkət tast'a». ");
INSERT INTO udi_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Oşa metərəl pine: «Mot'o görə heq'ədəren çuresasa upa, tadoz». ");
INSERT INTO udi_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","İak'oven pine: «Ene zu tez nex. Hunal avanu ki, vi loxol əşp'i elmuxez laxe zu, bezi piin işiğ k'inək'ez běğe vi sürüğo. ");
INSERT INTO udi_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Zu vi t'ǒğǒl eğat'an bakala sürün q'a həysət'in sürün arane bakala fərg piin běše. Bineti bezi tur va, Q'ončuğon va İzi xeyir-bərəkətə tadi avuzebi vi sürüğo bakala heyvanxoy saya. P'oy zu hevaxt' cöy k'oj-mes bakoz?» ");
INSERT INTO udi_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","İak'oven metər uk'at'an Lavanen pine: «Hun saycə upa, zu va k'ə çurensa tadoz». İak'oven qaybaki pine: «Za hik'k'al tene lazım, ama vi sürüğo memaçağ hetər běğezusa meyin oşal bezi běğsuna çurensasa, va sa şey uk'oz, şot'o ba, q'erəz hik'k'al çurtezsa. ");
INSERT INTO udi_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Eki vi sürüğo dirist' tarak'en, iz boşt'an k'ə çil-çil, śampi nəəl dirist' mə̌yin eğel, q'uzi saal keçi bunesa c'ək'ken beziq'an baki. Meyin oşal sürün boş ketər sa q'uzi nəəl keçin bala nanaxun bakat'an, bezi hesabbakale. ");
INSERT INTO udi_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Həysə irəziluğa eğayan, gələcəye vi za yoxlayinşbsunal irəət bakale. Hari bezi sürün boş çil-çil, śampi nəəl dirist' mə̌yin nu bakala sa eğel q'a keçi ak'ayvax, avabakalnu ki, mo bezi vaxun başq'i heyvane». ");
INSERT INTO udi_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lavanenal qaybaki \"lap şaat', barta vi uk'ala k'inək'q'an baki\" pine. ");
INSERT INTO udi_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Haketərəl bit'un, Lavanen hat'e ği izi sürünə tarapi iz boşt'an k'ə çil-çil q'a śampi ərkəy keçi, mə̌yini loxol mas'i ləkələ q'a mas'i zolağla dişi keçi saal dirist' mə̌yin eğel q'a q'uzi bunesa c'ək'ep'i, oşal ext'i izi ğarmoğone tadi ki, běğeq'at'un. ");
INSERT INTO udi_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Şot'oğonal İak'oveynak' cöybi me heyvanxo ext'i içoğoy bavay sürünəxun xib ğiluğ yaq'e hama ə̌xil taśi t'iyat'un burqi şot'oğo otarişbsa. İak'oven isə izi pi k'inək'əl bi, çurpi Lavana içu mandi sürünəne běği. ");
INSERT INTO udi_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","İak'oven eçeri q'uanğna, badami saal çinari xodurxoy təzə taymoğoxun xoxp'i, bureqi şot'oğoy loxol içoğoy qǒlə c'eq'i mas'i zolağxo düzbsa. ");
INSERT INTO udi_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Oşa şot'oğo heyvanxon xe ǔğə̌lə nə̌vurxoy boşe laxi ki, keçiğon q'a eğelxon hari xe ǔğə̌t'an me zolağla taymoğoy loxolq'at'un běği. Heyvanxoval gele vədə xe ǔğə̌t'ant'un öörə taysay pi, ");
INSERT INTO udi_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","hər öörə tağat'an me zolağla taymux içoğoy piin běše baksay. Metərluğen, me keçiğoxun q'a eğelxoxun bakala balooxal bito hari śampi, çil-çil nəəl ləkələne baksay. ");
INSERT INTO udi_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","İak'oven me baloğo cöye efsay, Lavani sürünə isə tetəre fırıdi efsay ki, içoğoy ç̌o dim me śampi sürün tərəfq'an baki. Hametər, İak'oven içeynak' běği kalabala śampi baloğoy say taysun gelenebaksay. ");
INSERT INTO udi_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Xe ǔğsa eğat'an öörə tağala heyvanxoval běneğsay: vərkər heyvanesa, iz düzbi śampi taymoğo lanexsay nə̌ve boş, ");
INSERT INTO udi_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","zəyif heyvanesa, təə. Metərluğen, vərkər heyvanxo içune kofst'ay, zəyiforox isə Lavana. ");
INSERT INTO udi_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Samal oşa İak'ov baneki varlu sa amdar, şot'ay sürünen heyvanxone buy: eğelxo q'a keçiyox, buşurxo q'a elemxo. Şot'ay çuux q'a işq'ar nökərxoval geleney. ");
INSERT INTO udi_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","İak'ovi ǔmǔğo hari p'anep'i ki, Lavani ğarmoğon metərt'un nex: «Həysə İak'ovast'a bakala var-dövlət bito beşi bavay kiyexun haq'iyoroxe! Beşi bavay hünərene varlayinşake ko!» ");
INSERT INTO udi_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","İak'oven içinal hisebsay ki, Lavan içuxun běšin k'inək' tene. ");
INSERT INTO udi_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","T'e vədə Q'ončuğon İak'ova pine: «Vi bavay t'ǒğǒl, vi c'eri gala qaybaka. Q'ı̌maba, Zu dim vaxun bakoz!» ");
INSERT INTO udi_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","İak'ovenal Raxiləynak' q'a Leaynak' xavar yaq'abi şot'oğo çöle, izi sürüğo otarişala gala eçest'i ");
INSERT INTO udi_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","pine: «İbakanan k'əz nex. Axır vədine azaksa ki, efi bavay ara zaxun běšin k'inək' şaat' tene. Ama bezi bavay bul k'os'pala Buxačux dim zaxune. ");
INSERT INTO udi_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Və̌nal avanan ki, bez elmoğo laxiz əşp'e efi bavay loxol zu. ");
INSERT INTO udi_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Şot'in isə bezi haq'q' k'əq'an baki pi vis' kərəm fikire badalbi. Ama Buxačux hər dəfə bezi tərəfe baki. ");
INSERT INTO udi_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Uk'at'an ki, çil-çil baloox vi bakale, heyvanxoy eçala baloox hari bito çil-çile baki. Oşa pine, p'oy təə, śampi baloox vi bakale, t'e vədəl hari bito śampine baki. ");
INSERT INTO udi_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Hametər, Buxačuğon heyvanxoy sürüğo ef bavay kiyexun ext'i zane tadi. ");
INSERT INTO udi_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sa ği, heyvanxoy öörə tağala vədəney, nep'e boş azk'i ki, dişi keçiğoy loxol lağala ərkəy keçiğoy bito çil-çil, śampi saal ləkələne. ");
INSERT INTO udi_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Buxačuğoy angelen za nep'e boş k'alpi pine: \"İak'ov!\" Zuval qaybaki \"izbaksa\" pizu. ");
INSERT INTO udi_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Şot'in pine: \"Běğa, dişi keçiğoy loxol lağala ərkəy keçiğoy bito çil-çil, śampi saal ləkələne, şot'o görə ki, avazu Zu Lavanen vaynak' laxi şərturxo. ");
INSERT INTO udi_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Bet'ela vi nep'a baśi Buxačuxzu Zu, t'et'iya vi biin oq'a laxi ǰěna ext'i tikenbi hun, iz loxol zeytuni c'əyin lapiyal Za elasp'i əyiten tadi. İsə hayza c'eki me oç̌alaxun, vi c'eri ganu, vi nanaxun baki oç̌ala qaybaka\"». ");
INSERT INTO udi_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raxilən q'a Lean qaybaki metərt'un pi: «Meyin oşa yaynak' bavay var-dövlətəxun pay tene bu. ");
INSERT INTO udi_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Yan həysə şot'aynak' hik'k'al teyan. Yax va tadat'an əyitp'i tənginəl kəye beşi bavan. ");
INSERT INTO udi_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Şot'o görəl, Buxačuğon beşi bavay kiyexun ext'i va tadiyorox bito beşi q'a beşi əyloğoye hesabbaksa. İsə Buxačuğon va hetər nexe, hat'etərəl ba!» ");
INSERT INTO udi_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","İak'ovenal eçeri izi əyloğo q'a çupuxxo buşurxoy loxol arśevek'i, ");
INSERT INTO udi_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","P'addan-Arama girbi k'ə var-dövlət but'uxsa ext'i, izi sürüğo bakala heyvanxoval bitova iz běš badi Kənana, iz bava İsaak'i t'ǒğǒl yaq'ane baft'i. ");
INSERT INTO udi_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lavan eğelxo q'açibsane taśey, Raxilənal baśi iz bavay k'oya bakala binik' buxačuxxo ext'i c'ere. ");
INSERT INTO udi_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Hametər, İak'oven izi t'ayi bakala me aramlu Lavana izi taysuna nu avabakest'i şot'o əfçiduğine baki. ");
INSERT INTO udi_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Şot'in izi me usenxost'a girbit'oğo bitova ext'ine t'e oç̌alxoxun c'eri. Hariyal Yevfrat oqa p'ap'i şot'o c'ovakit'uxun oşa Gilead buruxmoğoçe taysa burqi. ");
INSERT INTO udi_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Xib ğinaxun oşa İak'ovi c'eri taysun hari Lavana p'anep'i. ");
INSERT INTO udi_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mot'o avabakala k'inək' Lavanen içuxun ı̌ša bakala q'oomxo girbi şot'ay bač'anexune baft'i, vǔğ ği yaq' taśit'uxun oşal hari Gilead buruxmoğo c'ovakat'an şot'o p'anep'i. ");
INSERT INTO udi_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ama Buxačuğon hat'e üşe Lavani nep'e boş baśi şot'o pine: «Běğa, va nexzu, İak'ova galtenst'a, vi ǰomo ə̌mbi şot'o əyit ten nexe!» ");
INSERT INTO udi_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lavanen hari İak'ova p'ap'at'an běneği ki, şot'in izi çadırxo buruxmoğo laxi çurpene, şot'o görə ene içinal izi q'oomxoxun sagala içoğoy çadırxo hamiya laxi çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Şot'in İak'ova pine: «K'ən bsa mo hun? Za əfçiduği, bezi xuyərmoğoval t'etəren haq'i taysa ki, unk'on düşməni kiyexun malen t'it'evksa. ");
INSERT INTO udi_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Za pinut c'eri taysun k'ə upsune? Sal ten nex ki, bərkə me amdarenal və̌x faren, əçinen yaq'a bast'une çuresa, ");
INSERT INTO udi_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","hələ bito t'ǒǒx, izi xuyərmoğo q'a nəvoğo dirist'oğonbi muçpsune çuresa! Sa əyiten haq'ılsuz əşe vi biq'i me əş! ");
INSERT INTO udi_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Həysə va memiya bezi tərs ç̌oya ak'est'es bazkoy, ama c'ovaki üşe vi bavay bul k'os'pala Buxačuğon za pine ki, İak'ova galmada. ");
INSERT INTO udi_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Lap uk'en c'eri taysuna avazbaki, vi bavay k'ojeynak' tarıxmişakenu pi tansa. Me bezi binik' buxačuxxo başqsuna k'ə uk'az?» ");
INSERT INTO udi_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","İak'oven Lavana metəre coğab tadi: «Q'ǐzbi ki, vi za tadi xuyərmoğo qaydi bezi kiyexun haq'alnu. ");
INSERT INTO udi_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ama binik' buxačuxxoy exlət zaluğ tene. Çurensa miya gireśi q'oomxoy piin běš baki qə̌věki, vi mal bunesa, ext'a viq'an baki. Şinesa kiyel vi buxačuxxo bə̌ğə̌bayvax, avabaka ki, şo dirist' tene mandal!» Binik' buxačuxxo Raxiləy başqsunaxun isə İak'ovi xavar tene buy. ");
INSERT INTO udi_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lavanen baśi İak'ovi, Leay saal iz xuyərmoğo tadi p'ə̌ nökəri çadıra běneği, ama hik'k'al tene bə̌ğə̌bi. Oşa Leay çadıraxun c'eri Raxiləy çadırane baśi, ");
INSERT INTO udi_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raxilən isə binik' buxačuxxo ext'i buşe yəhəri loxol suruk'p'ala torayi boş laxi, içal laśi iz loxol arśeney. Lavanen çadıri boş maya uk'ayin běneği, ama hik'k'al tene bə̌ğə̌bi. ");
INSERT INTO udi_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raxilən iz bava pine: «Vi turel hayzesal tez baksa, bez ağa, ama vi əcuğon maq'an biq'i, çupuxxost'a bakalt'uxunez baksa, şot'o görə tez hayst'a». Lavanenal dirist' çadıra şit'epi, ama p'urumal izi binik' buxačuxxo tene bə̌ğə̌bi. ");
INSERT INTO udi_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Mot'o ak'i İak'ovi əcuğon t'etəre biq'i ki, bureqi Lavani ç̌oye iz boş bakalt'oğo bitova upsa: «İsə upa běyn bezi taxsır hik'ə? Bezi k'ə günaxzax bu ki, hayzeri vi amdarxoval ext'i baft'enu bezi bač'anexun? ");
INSERT INTO udi_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","P'oy k'ə baki, bə̌ğə̌nbi k'ənesa? Vi nu běği ga tene mandi, isə eça laxa bǐyex zast'a vi sa çöpəl bakayin bə̌ğə̌benusa, barta beşi q'oomxonal ak'eq'at'un şi hetər baksuna. ");
INSERT INTO udi_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Düz q'a usen vi loxol əşezbe zu! Sal ak'enu vi sürünəxun bakala eğela tamaxp'i bakaz? Eğelxoy q'a keçiğoy bala saksun hik'ə ki, haşoval tene bake bezi běğala sürün boş! ");
INSERT INTO udi_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ə̌qnə heyvani ǰomo koft'it'ay xarcal zuz zap'ey ki, ziyan va maq'an laft'i. İçal vaynak' tafoot tene buy hevədə bake əş: ğenaxunal śarpi bakayin zuz zap'ey ziyana, üşeyal śarpi bakayin. ");
INSERT INTO udi_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ği tez ak'e zu: nə bezi basksunaz avabake, nə bezi hayst'una. Ğenaxun č'oč'a běğe ç̌oye, üşeyal miye boşez bake zu ");
INSERT INTO udi_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","vi t'ǒğǒl baki me q'a usenast'a! Bip'es's'e usen vi p'ə̌ xuyərə haq'suni galaz əşp'e, ǔq usenal zaynak' kalabi sürün gala, hər dəfəl bezi haq'q' k'əq'an baki pi vis' kərəm vi fikirən badalbi hun! ");
INSERT INTO udi_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Avrahami bul k'os'pala, bezi bava İsaak'i pula haq'ala Buxačux nu bakiyniy, isə hun sa çöpəl ten tadey za. Ama bezi zapi əzyət ams'ina tene taśi, bezi elmoğo laxi əşpsuni əvəzə tanedi za Buxačuğon. C'ovaki şü hunal ank'i ki, Buxačux bez tərəfe». ");
INSERT INTO udi_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lavanen qaybaki İak'ova metəre pi: «Me xuyərmuxal, içoğoxun baki əyluxal, vi běš badi haq'i tağala me sürüyəl - vi həysə k'ə bunesa bito bezi va tadine. Vi zənden, zu bezi xuyərmoğoy q'a nəvoğoy pisa çurezğon? ");
INSERT INTO udi_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","İsə eki vaxun sa irəziluğ ğaç̌eğen, barta gələcəye exlət bakayin beşi kiyel subutq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","İak'ovenal me ga c'ək'eśeq'an pi sa ǰě ext'i tik lanexi. ");
INSERT INTO udi_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Oşa iz q'oomxo pine: «Eçanan ǰě girbanan miya». Şot'oğonal ǰě girbi eçeri xərəyen sunay loxol śit'unpi. Me ganu içoğoy irəziluğ ğaç̌esuna ak'est'eynak' arśi me xərəyen girbi ǰěne t'ǒğǒl šumal bot'unt'i. ");
INSERT INTO udi_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lavanen eçeri xərəyen śipi me ǰěne s'iya Yegar-Sahadut'e laxi, İak'oven isə Galed. ");
INSERT INTO udi_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lavanen pine: «Barta me ǰěyurxo ğe vi q'a bezi arane ğaç̌eśi irəziluğa eyex bast'eynak'q'an baki». Şot'o görə t'e gane s'i hat'etərəl manedi - Galed. ");
INSERT INTO udi_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ama t'e gane s'iya Misp'al next'uniy, şot'o görə ki, Lavanen me əyitmoğoval peney: «Barta yan memiin cöybakit'uxun oşa Q'ončuğoy pul beşi loxolq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Avabaka ki, hevaxt'esa bezi xuyərmoğo pis běğayvax, şot'oğoy loxol q'erəz çuux haq'i eçayvax, mot'o zu nuval ak'ayiz, Buxačuğon aneksa». ");
INSERT INTO udi_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Oşa Lavanen İak'ova saal pine: «Běğa, mo beşi tikp'i laxi ǰě q'a eçeri xərəyen girbi ǰěyurxo. Barta korox yaynak' ");
INSERT INTO udi_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","beşi ğaç̌eśi irəziluğa eyex bast'eynak' laxeśi sa nišan k'inək'q'an baki. Eki həysə kot'oğoy běš suna əyit taden ki, nə zu va pisluğbseynak' me xərəyi q'a ǰěne t'e soğo tərəf tez c'ovakal, nəəl hun me soğo tərəf c'ovaki za pisluğ ten bal. ");
INSERT INTO udi_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Barta Avrahami q'a Naxori, barta beşi kalboğoy bavan bul k'os'pala Buxačuğon İçinq'an beşi əşlə běği». İak'ovenal izi bava İsaak'i pula haq'ala Buxačuğo elasp'i əyite tadi. ");
INSERT INTO udi_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Şot'in eçeri içoğoy çurpi me buruğo q'urbanal šamepi, me hari q'oomxoval bitova k'alepi ki, arśi içuxun sagala šumq'at'un kəyi. Bitot'in kəyi-ǔneği, t'e üşeyal hat'iya mant'undi. ");
INSERT INTO udi_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Əyc'indəri savaxt'an isə Lavanen hayzeri izi xuyərmoğo q'a nəvoğo muçepi, şot'oğo xeyir-bərəkət tadiyal qaybaki iz k'oyane taśi. ");
INSERT INTO udi_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","İak'ov isə hayzeri p'urum yaq'ane baft'i, izi běšal Buxačuğoy angelxone c'eri. ");
INSERT INTO udi_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","İak'oven şot'oğo ak'at'an pine: «Buxačuğoy q'oşunxo hari çurk'ala gane mo». Metər piyal t'e gane s'iya Maxanayime laxi. ");
INSERT INTO udi_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hari Edoma, izi viçi Esav yəşəyinşala oç̌ali t'e Seir uk'ala burux ganxo ı̌šalayinşakat'an İak'oven içuxun běš elçiğo yaq'abi ");
INSERT INTO udi_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","şot'oğo tapşurebi ki, taśi izi viçə me əyitmoğoq'at'un pi: «Takinan bezi kala viçi Esava upanan ki, izi k'ul bakala İak'oven metəre nex: \"Zu heq'ədər vədəne ki, q'ərib ölkinə, Lavani t'ǒğǒlez bake. ");
INSERT INTO udi_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Həysə bezi öküzxoval buzax, elemxoval, eğel-keçiğoy sürüyoxal buzax, çuux q'a işq'ar nökərxoval. İsə mone, bezi ağay turelez hare, əgər izi piyes şaat'ez ak'esasa, barta avabakest'eq'an mot'o bez yaq'abi me elçiğo\"». ");
INSERT INTO udi_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Elçiyox İak'ovi t'ǒğǒl qaybaki pit'un: «Vi viçi Esavi t'ǒğǒlxunyan eysa həysə. Pine vi běš iç c'eğale, izi t'ǒğǒl bip'baç̌ tan amdaral bune». ");
INSERT INTO udi_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mot'o ibakat'an İak'ova q'ı̌yene haq'i, isə k'əq'an bi tene avay. Eçeriyal izi amdarxo, buşurxo, eğel-keçiğo - bitova p'ə̌ gala cöyebi ki, ");
INSERT INTO udi_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Esaven hari içoğo k'as'k'ayin, iz bul sa dəst'inə gərgürbakat'an, t'e soğo dəst'inə bakalt'oğon t'it'eri içoğoy elmoğo çark'est'esq'at'un baki. ");
INSERT INTO udi_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Şot'in Buxačuğo k'alpi pine: «Ay bezi bavoğoy Buxačux, ay Avrahami q'a İsaak'i Buxačux bakala Q'ončux, Hun za pinu ki, hayza vi c'eri gala, vi bavay t'ǒğǒl taki, Zuval va ěqevk'oz. ");
INSERT INTO udi_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tene lafst'a me vi k'ul Hun izi belxun oq'a śipi t'e nu badalbakala çuresuna q'a xeyirxaxluğa. Zu me oç̌alxoxun c'eri İordan oqe t'e soğo tərəf c'ovakat'an bezi sa çombağaxun q'erəz hik'k'al butezaxiy. İsə mone, p'ə̌ dəst'inenez qaybaksa zu me oç̌alxo. ");
INSERT INTO udi_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Va xoyinšezbsa, za bezi viçi Esavi kiyexun çark'est'a! Q'ı̌zbsa hari zaal besp'ane, əyloğo q'a çupuxxoval bitova k'as'kane. ");
INSERT INTO udi_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Axıri za \"ma q'ı̌ba, tez kambal vaxun Bezi xeyir-bərəkətə, vaxun əmələ eğala nəsili saya dənizi börine bakala q'ume hama booz\" pi əyiten tadey Hun». ");
INSERT INTO udi_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Hametər, İak'oven t'e üşe t'iya kəyebi, savaxt'anal hayzeri bureqi izi heyvanxoxun c'ək'p'i Esaveynak' pay həzirbsa: ");
INSERT INTO udi_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","p'ə̌baç̌ dənə dişi keçi q'a q'a dənə ərkəy keçi, p'ə̌baç̌ dənə dişi eğel q'a q'a dənə ərkəy eğel, ");
INSERT INTO udi_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","otuz dənə çaxeğala buş izi baloğoxun sagala, q'ırx dənə çur, vis' dənə arak' saal q'a dənə dişi elem q'a vis' dənə ərkəy elem. ");
INSERT INTO udi_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Oşa me heyvanxo hametər izi c'ək'p'i k'inək'əl cöy-cöy k'ulurxo tapşurbi pine: «Hərt'in içu tapşurbaki sürünə ext'i zaxun běš taśeq'an, ama sunaxun samal ə̌xil takinan ki, efi sürüğo bakala heyvanxo suna gərbakimaq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Bitot'uxun běš tağalt'u isə metəre pi tapşurbi: «Bezi viçi Esav vi běš c'eri vaxun xavar haq'ayin ki, şi nökərnu, mayan taysa, me vi c'idala sürü şiya, ");
INSERT INTO udi_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","upa vi k'ul İak'ovi sürüne, bezi ağa Esaveynak' paye yaq'absa. Oşa upa \"mone, həysə içal bezi bač'anexun enesa\"». ");
INSERT INTO udi_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","İak'oven hame əyitmoğo şot'ay bač'anexun tağala k'ulal pine, oşin tağalt'uval. Hametər, Esaveynak' c'ək'p'i heyvanxo c'idi taşala k'ulurxo bitova hame sa əyitəne pi. Şot'oğo metəre tapşurbi: «Esava ak'at'an bezi və̌x pi k'inək' upanan, ");
INSERT INTO udi_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","\"həysə içal beşi bač'anexun enesa\" əyitə upsunal eyexun ma c'evk'anan». Şot'in fikirebsay ki, barta süft'ə pay yaq'abaz Esav cügübakeq'an, oşa iz piyes ak'eğaz, bərkə t'e vədə bezi loxol şaat'e běği. ");
INSERT INTO udi_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","K'ulurxon Esavi payurxo ext'i tat'unśi, İak'ov isə hələ sa üşeyal izi çadırxo laxi çurpi gala manedi. ");
INSERT INTO udi_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Şot'in üşe hayzeri izi p'ə̌ çuğo, içeynak' əylux eçeri p'ə̌ nökərə saal izi sas's'e ğara ext'i Yabbok' uk'ala oqe ç̌oğoloy ganuxun baśi turin şot'ay t'e soğo tərəfe c'ovaki. ");
INSERT INTO udi_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","İak'oven çupuxxo q'a əyloğo, izi k'ə bunesa bitova t'e soğo tərəf c'ovakest'it'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","tək içe mandi. Hame vədine Sunt'in hari bureqi şot'oxun düz kəybakamin buşurupsa. ");
INSERT INTO udi_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Běneği İak'ova İzi zor tene ayesa, şot'ay bude loxol t'etəre duği ki, ǔq'en iz ganuxune c'eft'i. ");
INSERT INTO udi_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Şot'in pine: «Tərba Za, ene kəyebaksa». İak'ovenal qaybaki \"za xeyir-bərəkət nu tadayvax tez tərbal Va\" pine. ");
INSERT INTO udi_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Me bürdən peydax baki İak'ovaxun Buşuruk'alt'in xavare haq'i: «Vi s'i hik'ə?» Şot'inal pine: «İak'ov». ");
INSERT INTO udi_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","T'e vədə İak'ovaxun Buşuruk'alt'in qaybaki içu metəre pi: «Vi s'i ene İak'ov təə, İsrail bakale, şot'o görə ki, hun Buxačuğoxun q'a amdarxoxun buşurupi tanşeri». ");
INSERT INTO udi_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","İak'oven pine: «Hunal upa Vi s'iya za, xoyinšezbsa!» İçuxun Buşuruk'alt'inal qaybaki \"Bezi s'iya nuval avabakayvax banekon\" pine. Metər piyal İak'ova xeyir-bərəkəte tadi. ");
INSERT INTO udi_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","İak'oven t'e gane s'iya P'eniele laxi, şot'o görə ki, metəre pi: «Buxačuğo İçuval azk'i, ama bezi elmux hələ bez boşe». ");
INSERT INTO udi_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Hari kəyebaki, İak'ovenal axsağlayinşbsun me P'eniel uk'ala ganuxun c'eri p'urum yaq'ane baft'i. Üşe bakit'oğoxun oşa şot'ay bud hələ q'ač'eney. ");
INSERT INTO udi_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","İsrailluğon həysəəl bude yeq'e loxol bakala t'amarla ganxo utet'unksa, axıri İak'ovaxun Buşuruk'alt'in şot'ay me t'amarxoy loxole duğey. ");
INSERT INTO udi_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Samal taśit'uxun oşa İak'oven běneği ki, mone, Esav, izi t'ǒğǒlal bip'baç̌ tan amdar enesa. Şot'in əyloğo Leay, Raxiləy saal şot'oğoy bač'anexun hari p'ə̌ çuux-nökəri arane cöyebi: ");
INSERT INTO udi_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","běš nökərxo q'a şot'oğon eçeri əyloğo, oşa Lea q'a Lean eçeri əyloğo, şot'oğoy bač'aneyal Raxilə q'a İosifane çurdest'i. ");
INSERT INTO udi_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","İç isə běš c'eri, hələ iz viçi ǐšalayinşakamin biti şot'ay běš vǔğ kərəm bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ama Esav İak'ovi t'ǒğǒl t'it'eri şot'o ost'aar q'ujbi muçepi, şot'oğon p'rannat'inal ǒnepsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esaven çupuxxo q'a əyloğo ak'i pine: «P'oy me vaxun hariyorox şuva?» İak'ovenal qaybaki \"mo Buxačuğon vi k'ula pay tadi əyluxe\" pine. ");
INSERT INTO udi_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Metər uk'at'an běš çurpi çuux nökərxon q'a içoğoy eçeri əyloğon Esavi t'ǒğǒl hari şot'o bult'un k'os'p'i, ");
INSERT INTO udi_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","oşa Lean q'a Lean eçeri əyloğont'un hari bul k'os'p'i, axırdal Raxilən q'a İosifene ı̌šalayinşaki bul k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Oşa Esaven xavare haq'i: «Zu miya eğat'an bez běš c'eri sürüyox hik'əy p'oy?» İak'ovenal qaybaki \"vi piyes şaat' ak'eseynak' payez yaq'abey vaynak' şot'oğo, bezi ağa\" pine. ");
INSERT INTO udi_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaven pine: «Bezi hər şey buzax, bez viçi, vi mala vast'a efa». ");
INSERT INTO udi_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ama İak'oven qaybaki metəre pi: «Bezi xətirə çurensasa, ext'a zu va tadala me paya. Zaynak' həysə va aksun Buxačuğo aksun k'inək'e baki, hələ vi zaynak' bi şaat'luğa tez nex! ");
INSERT INTO udi_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Şot'o görəl, ma saka bezi əyitə oq'a, ext'a bezi vaynak' yaq'abi payurxo. Buxačuğon kamtenebi zaxun İzi xeyir-bərəkətə, bezi belxun oq'a baramine tadi za hər şeyaxun». Hametər, İak'oven t'ema xoyinšebi ki, axırda Esav irəzinebaki içeynak' yaq'abi payurxo exst'una. ");
INSERT INTO udi_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Oşa Esaven pine: «İsə həzirləyinşaka c'eğen, meyin t'ağay zaxun tağalnu». ");
INSERT INTO udi_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ama İak'oven qaybaki metəre pi: «Hunal avanu ki, bezi ağa, əyloğoxun yaq' c'eysun heq'ədər çətine. Hələ sa çaxeğala çurur q'a eğelxoval buzax, şot'oğo sa ğiyal bakayin kapst'un c'idayiz k'as'eğalt'un yaq'a. ");
INSERT INTO udi_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Şot'o görəl, şaat'o şone, hun běš taki, zu isə əyloğoy q'a sürüğoy eyes bakala k'inək', yavaş-yavaş vi bač'anexun eğaz. Ene Seira ayank'on suna p'urum, bezi ağa». ");
INSERT INTO udi_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaven pine: «T'e vədə, barta bezi amdarxoxun sa hemara efaz, va köməybeq'at'un». Ama İak'ov p'urum irəzitenebaki, \"əzyət ma zapa, bez ağa, vi zaynak' biyorox bəse\" pine. ");
INSERT INTO udi_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ene běneği İak'ov irəzitenebaksa, Esav hat'e ği hayzeri izi k'oya, Seirane yaq'a baft'i, ");
INSERT INTO udi_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","İak'ov isə Suk'k'ot'aç taśi t'iyane izi çadırxo laxi çurpi. Şot'in miya izi heyvanxo efala ganxoval düzebi, şot'o görə gane s'iyal haketər manedi - Suk'k'ot'. ");
INSERT INTO udi_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Hametər, İak'ov Lavanaxun cöybaki, yəni P'addan-Aramaxun c'eri, iz bel əş harinut'al hari Kənan oç̌ala p'anep'i. Şo miya Şekem şəhərə ǐša iz çadırxo laxi çurepi. ");
INSERT INTO udi_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Şot'in iz çadırxo laxi me oç̌ala Xamori ğarmoğoxun baç̌ dənə gümüşi təngə tadi haneq'ey. Me Xamor Şekem şəhəri binorina laxiyoney. ");
INSERT INTO udi_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","İak'oven miya sa q'urban eçala gaal düzebi, iz s'iyal El Elohe İsraile laxi. ");
INSERT INTO udi_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Sa ği, İak'ovi Leaxun baki xuyər Dina hayzeri içoğoy arśi me oç̌ali xuyərmoğo aksane taśi. ");
INSERT INTO udi_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Şot'o miya me oç̌alxoy kalo bakala xivlu Xamori ğar Şekemen anek'i, biq'iyal xuyərəxun zorbaluğen baneki. ");
INSERT INTO udi_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ama xuyər Şekemi ük'e t'etəre bask'i ki, şot'o çuresa, şot'oxun muč'a əyitpsane burqi, ");
INSERT INTO udi_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","izi bava Xamoral pine ki, Dina içeynak' çuuxq'an haq'i. ");
INSERT INTO udi_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Şekemen Dinay bel eçeri əş hari İak'ova p'anep'i. Ama mot'o ibaki vədine izi ğarmux çöle navadat'uniy pi şorox eğamin izi səsə tene c'evk'i ki, barta şoroxal hareq'at'un běyn oşa me əşlə k'ə best'un baksa. ");
INSERT INTO udi_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Şekemi bava Xamor isə hayzeri İak'ovi t'ǒğǒle hari ki, şot'ay xuyərə izi ğareynak' çureğale. ");
INSERT INTO udi_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Hame vədine İak'ovi ğarmuxal me exlətxo ibaki çölexun hart'un, şot'oğoy belxun k'üüne c'eysay. Axıri hetəre bakes bakon ki, İsrailaxun törəyinşakit'oğoy bel metər əş eğane, me biyaburçiluğ beyne p'aq'est'ala şey teney. Şinesa ğar zorbaluğen içoğoy xunçaxune bask'e mani exləte? ");
INSERT INTO udi_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Xamoren İak'ova q'a izi ğarmoğo metəre pi: «Efi xuyər bezi ğar Şekemi ük'e gelene bask'e, izi piin şot'oxun q'erəz şuk'k'ala tene aksa. Zuval həysə efi xuyərə bezi ğareynak' çuresaz hare, və̌nal irəzibakaynan gele mǔqezbakon. ");
INSERT INTO udi_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ekinan meyin oşa suna xuyər tadi haq'en, q'uda baki q'oomluğben. ");
INSERT INTO udi_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mone, mo beşi oç̌al, mo və̌n: maya çurnansa efi çadırxo laxi çurpes banankon. Əşp'anan, q'azayinşanan, haq'i-toydanan, meyin oşa yan hetər, və̌nal haketər, bartanan beşi arane vi-bezi exlət maq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Şekemen için isə metəre pi Dinay bava q'a viçimoğo: «Saycə efi xuyərə za tast'una irəzibakanan, və̌x k'ə çureğaynan tadoz. ");
INSERT INTO udi_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Upanan xilə k'əq'an baki, zuval və̌x tadaz, eçaz ən toyexlu payurxo ef belxun oq'a śik'az. Saycə ke xuyərə za tadanan!» ");
INSERT INTO udi_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ama İak'ovi ğarmoğoy Şekemi biq'i əşlə q'uc'k'ala fikir tene buy, şot'o görəl bic'luğ əşp'est'i Şekema q'a izi bava Xamora ");
INSERT INTO udi_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","metərt'un pi: «Bul biq'ala əş tene mo, sünnətnubaki sa amdara işq'ara tades teyan bakon yan beşi xunça! Ene upanan beşi bula alabi amdarxoy ç̌oyel ma běğen yan! ");
INSERT INTO udi_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Və̌nal yallarik' sünnətbakaynan, ef boş bakala mandi işq'arxoval bito sünnətbakayt'un - t'e vədə hoo. ");
INSERT INTO udi_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","T'e vədə və̌x xuyərəl tayandon, və̌xun xuyərəl hayanq'on, sunaxunal muč'a, sa azuk' k'inək' yəşəyinşyanbon me oç̌ala. ");
INSERT INTO udi_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ama uk'aynan ki, p'oy təə, teyan sünnətbaksa, t'e vədə ef eyexun c'evk'anan yaxun xuyər haq'suna, beşi xunçal ext'i tayansa yan». ");
INSERT INTO udi_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Xamoren q'a iz ğar Şekemen me əşlə pis tet'un běği. ");
INSERT INTO udi_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Şekemen sal yaq' tene běği, eçeri sünnətebaki, t'emane çuresay İak'ovi xuyərə. Şo mis'ik' amdaral teney, me oç̌ali kalo bakala Xamoraxun törəyinşakit'oğoy boş ən hörmətlu amdarey. ");
INSERT INTO udi_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hametər bava-ğar hayzeri şəhəre bağala darvazin běš taśi t'iya gireśi işq'arxo metərt'un pi: ");
INSERT INTO udi_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Və̌nal ananksa ki, me beşi oç̌alxo hari arśi amdarxoxun yax sa pisluğ tene lafst'a, şot'o görəl nexyan ki, barta hamiya arśeq'at'un. Meq'ədər oç̌alyax bu, şuk'k'ali ga t'ar tene bakal. Barta yaxun barabar me oç̌ali loxol əşp'i q'azayinşeq'at'un, haq'i-toydeq'at'un, yan hetər, şoroxal hat'etər. Şot'oğoxun xuyərəl haq'alyan, xuyərəl tadalyan. ");
INSERT INTO udi_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Şot'oğoy yaxun çureğalo isə sa şeye: beşi işq'arxoval bito içoğollarik' sünnətbakine buq'on. Sünnətbakayan irəzit'un yaxun muč'a baki, sa azuk' k'inək' me oç̌ala arst'una, tene - təə. ");
INSERT INTO udi_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Metər ext'at'an mo hik'ə ki?! Şot'oğoy sürüğo bakala eğelxo, beliğo, içoğoy k'ə bunesa bitova beşi kiyel bades baksuni t'ǒğǒl mo hik'k'al tene! Ekinan sünnətbaken, hari beşi boş arśi yəşəyinşeq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hametər, şəhəre bağala darvazin běš gireśi işq'arxoy bito Xamori q'a Şekemi pit'oğoxun irəzit'unbaki, bitoval sünnətt'unbaki. ");
INSERT INTO udi_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Xib ği oşa isə, Xamori şəhəre bakala işq'arxoy hələ turel nu baki sa vədine, Dinaxun nana sa bakala viçimoğon, İak'ovi Simeon q'a Levi uk'ala ğarmoğon içoğoy q'ılıncxo ext'i bat'unśi şəhəri elmoğo. Şot'oğon şəhəre bakala işq'arxoy bitova k'as'p'i śit'unpi, şuk'k'alenal içoğoy běšinə̌mə̌ haq'es tene baki. ");
INSERT INTO udi_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Xamori q'a Şekemi bulal bot'unt'i, Şekemi k'oyaxun içoğoy xunçal ext'i c'ert'un. ");
INSERT INTO udi_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Oşa İak'ovi ğarmoğon işq'arxoy tumexun əfçibaki me şəhəre qaybaki burt'unqi k'ə bune fǔq'p'i taşt'a. İçoğoy xunçey namus ç̌axç̌uxeśi me şəhəre ");
INSERT INTO udi_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","k'ə eğel-keçi, beli, elem bunesa bitova ext'i tat'unşeri, şəhəri boş q'a q'oruğxo sa dənə heyvan tet'un efi. ");
INSERT INTO udi_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","İçoğoy kiyel koft'alt'u ext'unst'ay, baśi k'ojurxoval fǔq'p'it'uxun oşa şot'oğoy əyloğo q'a çupuxxoval bitova içoğoy běš badi haq'i tat'unśi. ");
INSERT INTO udi_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","T'e vədə İak'oven Simeona q'a Levina pine: «Bezi bula bəlinənan badi və̌n, me oç̌ala yəşəyinşala kənanluğoy q'a p'erizluğoy piyexunnan saki za! İsə gireśi beşi loxol eğayt'un hetər bakale? Sal beş boş t'ema işq'aral tene bu ki, şot'oğoy běš çurpes bakayan. Hari zaal besp'alt'un, və̌xal bitova k'as'k'alt'un, beşi tuma əfçibalt'un şot'oğon!» ");
INSERT INTO udi_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ama şot'oğon qaybaki içoğoy bava metərt'un pi: «Haq'q'yan be! Beşi xunçey loxol yaq'nuxun c'eri xuyəri loxol běğala piin běğalt'un, yanal mot'o q'uc'k'alyan?!» ");
INSERT INTO udi_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Me bakit'oğoxun oşa Buxačuğon İak'ova pine: «Hayza Bet'ela taki, vi çadırxo t'iya laxi çurpa. Vi viçi Esavi kiyexun t'it'at'an vi nep'a baśi Buxačuğoynak' q'urban eçala gaal düzba t'iya». ");
INSERT INTO udi_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","İak'ovenal izi külfəti boş bakalt'oğo q'a izi nökərxoy bitova girbi pine: «Efi kiyel binik' buxačuxxo mandenesa bitova bosanan. Murdarluğaxun təmizbakseynak' efi loxol xe lapi paltaral badalbanan - ");
INSERT INTO udi_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bet'elayan taysa. Bezi t'arnu p'ap'it'aynak', maya tağayiz İzi kula bezi loxolxun nu zapi Buxačuğoynak' q'urban eçala ga düzboz t'iya». ");
INSERT INTO udi_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Şot'oğonal İak'ovi əyitə běği içoğoy kiyel bakala binik' buxačuxxo q'a içoğoy ǔmǔğo lavk'i sırığanxo bitova c'evk'i tat'undi, İak'ovenal me buxačuxxo q'a şot'oğo bul k'os'psuna ak'est'ala me sırığanxo bitova taşeri Şekemi mə̌xluğ uk'ala ganu xodin tume oç̌alaxebi. ");
INSERT INTO udi_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mot'oxun oşa yaq'at'un baft'i, içoğoy yaq'e loxol bakala şəhərmoğoxunal şuk'k'alen c'eri İak'ovi ğarmoğoy běšt'an bot'estenedi, şot'o görə ki, Buxačuğon t'e oç̌ali amdarxoy bitot'ay pula haq'eney. ");
INSERT INTO udi_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Hametər, İak'ov q'a içuxun bakalorox bito hari Kənan oç̌ala bakala Luz, yəni Bet'el şəhəre p'at'unp'i, ");
INSERT INTO udi_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","İak'ovenal eçeri miya sa q'urban eçala gane düzbi. Şot'in me gane s'iya El Bet'ele laxi, şot'o görə ki, izi viçey kiyexun t'it'at'an Buxačux me ganune iz nep'a baśey. ");
INSERT INTO udi_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","T'e aramoğo Rebek'ay nökər, şot'o döş tadi kalabi Devorane p'uri, taşeriyal şot'o Bet'ele t'ǒğǒl bakala mə̌xnə xodin oq'a oç̌alaxt'unbi. Oşa t'e gane s'i hat'etərəl manedi - Allon-Baxut'. ");
INSERT INTO udi_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","İak'ov P'addan-Aramaxun c'eri Bet'ela qaybakit'uxun oşa Buxačux p'urum şot'o ak'eśi, xeyir-bərəkət tadiyal ");
INSERT INTO udi_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","pine: «Vi s'i İak'ove, ama meyin t'ağay va İsrail pi k'alk'alt'un, şot'o görə ki, vi s'iya İsrailez laxsa!» Hametər, İak'ovi s'i baneki İsrail. ");
INSERT INTO udi_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Buxačuğon İak'ova me əyitmoğoval pine: «Bitova Başarbala Buxačuxzu Zu! Avuzbakalnu hun, vaxun törəyinşakit'oğoy say t'eq'ədər bakale ki, azuk'xo əmələ eğale vi nəsiləxun. İçal sa azuk' təə, k'əşinen bǒq'ə̌lpi çark'est'es nu bakala hama! Padçağxo c'eğale vi nəsiləxun! ");
INSERT INTO udi_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Avrahama q'a İsaak'a əyit tadi me oç̌ala va tadoz, vaxun törəyinşakit'oğo mandale me oç̌al». ");
INSERT INTO udi_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Metər piyal hat'iya İak'ovi piyexun aneç̌i. ");
INSERT INTO udi_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","İak'oven eçeri Buxačuğon içuxun əyitp'i me ganu sa ǰěne tikp'i laxi. Şot'ay loxol fi q'a zeytuni c'əyin lapiyal ǰěne Buxačuğoy s'iyen laxesunane ak'est'i. ");
INSERT INTO udi_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","İak'oven me gane s'iya Bet'ele laxi, şot'o görə ki, Buxačuğon miya içuxun əyitepey. ");
INSERT INTO udi_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Oşa şorox Bet'elaxunal c'ert'un. Yaq'a baft'i hari Efrat'a p'ap'ala vədine Raxiləy q'ač'en bineq'i. Ama me dəfə əylə bakest'un tene bakest'unst'ay, ");
INSERT INTO udi_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","mamaçinenal běneği Raxilən gelene əzyət aksa, əyel hari bakit'uxun oşa şot'o ük' tadi pine: «İsə vi ük'ə buz k'inək' efa, ene p'ə̌ ğarvax bu». ");
INSERT INTO udi_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raxilən hat'iya əylin s'iya Ben-Oni laxi elmuxe tadi, ama bavan əylin s'iya badalbi Binyamine bi. ");
INSERT INTO udi_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hametər, Raxilə əylin loxol p'ure, taşeriyal şot'o hat'iya, Efrat'a tağala yaq'e börine oç̌alaxt'unbi. Me Efrat' şəhəri s'i həysə Bet'lexeme taysa. ");
INSERT INTO udi_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","İak'oven Raxiləy best'a sa ǰěyal tikp'i lanexi, manu ki, həysəəl hat'iya çurpene, bitot'inal avane me gane Raxiləy oç̌alaxeśi ga baksuna. ");
INSERT INTO udi_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","İsrail p'urum yaq'ane baft'i, taşeriyal izi çadırxo Migdal-Ederi t'e soğo tərəf laxi çurepi. ");
INSERT INTO udi_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Şo me oç̌alxo çurpi vədine Ruven izi bavaynak' əylux eçeri çuux-nökər Bilhaxune bask'i, moval İsraili ǔmǔğo hari p'anep'i. İak'ovi p'as's'e ğare buy. ");
INSERT INTO udi_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leay eçeri ğarmux: İak'ovi süft'in ğar Ruven, Simeon, Levi, İuda, İssak'ar saal Zevulun. ");
INSERT INTO udi_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raxiləy eçeri ğarmux: İosif q'a Binyamin. ");
INSERT INTO udi_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raxiləy bač'anexun hari nökər Bilhaxun baki ğarmux: Dan q'a Naft'ali. ");
INSERT INTO udi_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leay bač'anexun hari nökər Zilp'axun baki ğarmux: Gad q'a Aşer. İak'ovi P'addan-Arama baki ğarmux moroxe. ");
INSERT INTO udi_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Hametər, İak'ov hari Mamrena, izi bava bakala gala c'ere. Giryat'-Arbada, yəni Xevrona ǐša bakala me oç̌alxo Avrahami, oşal İsaak'i q'ərib k'inək' yəşəyinşi ganey. ");
INSERT INTO udi_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","İsaak' düz sabaç̌ səksən usen yəşəyinşebi. ");
INSERT INTO udi_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","P'uri izi bavoğoy t'ǒğǒl, izi pula q'ic'p'i t'e dünyəne tağat'anal izi yəşə c'ovak'est'i, iz pul boşe taśi. Şot'o taşeri oç̌alaxp'iyoval izi ğarmuxe baki - Esav q'a İak'ov. ");
INSERT INTO udi_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Moval Esavaxun bakiyorox. Me Esavi s'iya Edomal next'uniy. ");
INSERT INTO udi_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esavi çupuxxoxun p'ǒğǒ Kənan oç̌ala bakala azuk'xoxunt'uniy: soğo xet'lu Eloni xuyər Ada, t'e soğoval xivlu Śiveoni nəvə, Anani xuyər Oholivama. ");
INSERT INTO udi_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esaven mot'oğoy loxol sa çuuxal haq'eney, moval İsmaili xuyər Basemat'ey, Nevayoti xunçi. ");
INSERT INTO udi_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esavi Adaxun baki ğare s'i Elifaz, Basemat'axun baki ğare s'i isə Reueley. ");
INSERT INTO udi_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholivamaxun baki ğarmoğoy s'i Yeuş, Yalam saal Goraxey. Esavi Kənan oç̌ala baki ğarmux moroxey. ");
INSERT INTO udi_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","İak'ov qaybakit'uxun oşa Esaven izi çupuxxo, əyloğo, nökərxo, eğel-keçiğo q'a izi sürüğo bakala heyvanxoy bitova, Kənan oç̌ala əşp'i girbi k'ə but'uxsa ext'i samal t'ağay, q'erəz oç̌alane taśi yəşəyinşbsa burqi. Şo izi viçi İak'ovaxun samal ə̌xile baksun çuresay, ");
INSERT INTO udi_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","şot'o görə ki, içoğoy hari q'ərib k'inək' arśi me oç̌ala ene sagala p'atet'unq'say, p'rannat'ayal heyvanxo geleney. ");
INSERT INTO udi_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Hametər, Esaven, manu ki, izi s'iya Edomal next'uniy, taśi Seir buruxmoğoy döşene məsk'ən saki. ");
INSERT INTO udi_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Moval Seir buruxmoğoy döşel məsk'ən saki Esavaxun törəyinşakiyorox. Edomluyox uk'ala azuk'al hame Esavaxune əmələ hare. ");
INSERT INTO udi_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esavaxun baki ğarmoğoy s'iyur: Adaxun baki ğare s'i Elifaz, Basemat'axun baki ğare s'i Reuel. ");
INSERT INTO udi_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifazaxun baki ğarmux: T'eman, Omar, Śefo, Gat'am saal K'enaz. ");
INSERT INTO udi_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esavi ğar Elifazi izi çuux-nökər T'imnaxunal sa ğare buy, izi s'i Amaleg. Morox bito Esavi Adaxun baki ğare əyluxey. ");
INSERT INTO udi_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuelaxun baki ğarmux: Naxat', Zerah, Şamma saal Miśa. Morox bito Esavi Basemat'axun baki ğare əyluxey. ");
INSERT INTO udi_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esavi xivlu Śiveoni nəvə, Anani xuyər Oholivamaxun baki ğarmoğoy s'iyur: Yeuş, Yalam saal Gorax. ");
INSERT INTO udi_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Moval Esavaxun törəyinşakit'oğoxun əmələ hari tayfoox. Esavi kala ğar Elifazi nəsiləxun c'eri tayfoox: T'emani tayfa, Omari tayfa, Śefoni tayfa, K'enazi tayfa, ");
INSERT INTO udi_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Goraxi tayfa, Gat'ami tayfa saal Amalegi tayfa. Morox bito Elifazi ğarmoğoxun, Esavi q'a Aday nəvoğoxun əmələ hari tayfooxey, tayfa mani ğaraxun əmələ hareneysa hat'e ğare s'iyenal tanesay. Me tayfoğoy bito Edom oç̌alane yəşəyinşbsay. ");
INSERT INTO udi_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esavi ğar Reueli nəsiləxun c'eri tayfoox: Naxat'i tayfa, Zerahi tayfa, Şammay tayfa saal Miśay tayfa. Morox bito Reueli ğarmoğoxun, Esavi q'a Basemat'i nəvoğoxun əmələ hari tayfooxey, tayfa mani ğaraxun əmələ hareneysa hat'e ğare s'iyenal tanesay. Me tayfoğoy bito Edom oç̌alane yəşəyinşbsay. ");
INSERT INTO udi_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esavi çuux Oholivaman eçeri ğarmoğoxun əmələ hari tayfoğoy s'i isə metərey: Yeuşi tayfa, Yalami tayfa saal Goraxi tayfa. Morox bito Esaveynak' Anay xuyər Oholivaman eçeri ğarmoğoxun əmələ hari tayfooxey, tayfa mani ğaraxun əmələ hareneysa hat'e ğare s'iyenal tanesay. ");
INSERT INTO udi_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Moval Esavi, yəni Edomi ğarmux q'a şot'oğoxun əmələ hari tayfoox. ");
INSERT INTO udi_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Me oç̌ala süft'ə hari tum sakiyo isə xorlu Seire bake. Me Seiraxun baki ğarmux moroxey: Lot'an, Şoval, Śiveon, Ana, ");
INSERT INTO udi_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dişon, Eśer saal Dişan. Şot'oğoxun əmələ hari xorluyox uk'ala azuk'i boş bakala tayfooxal içoğoy s'iyene taysay, bitoval hame Edom oç̌alat'un yəşəyinşbsay. ");
INSERT INTO udi_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lot'anaxun baki ğarmux: Xori q'a Hemam. Lot'ani sa xunçiyal buney, izi s'i T'imna. ");
INSERT INTO udi_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Şovalaxun baki ğarmux: Alvan, Manaxat, Eval, Şefo saal Onam. ");
INSERT INTO udi_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Śiveonaxun baki ğarmux: Aya q'a Ana. Hame Ananey çöle izi bava Śiveoni elemxo otarişat'an ǰalpi c'eğala orayinxo bə̌ğə̌biyo. ");
INSERT INTO udi_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Seiri ğar Anay p'ə̌ əyele buy: sa ğar, sa xuyər. Ğare s'i Dişoney, xuyəri s'i isə Oholivama. ");
INSERT INTO udi_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Seiri ğar Dişonaxun baki ğarmux: Xemdan, Eşban, İtran saal K'eran. ");
INSERT INTO udi_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eśeraxun baki ğarmux: Bilhan, Śaavan saal Ak'an. ");
INSERT INTO udi_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dişanaxun baki ğarmux: Us saal Aran. ");
INSERT INTO udi_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Moval xorluyox uk'ala azuk'i boş bakala tayfoox: Lot'ani tayfa, Şovali tayfa, Śiveoni tayfa, Anay tayfa, ");
INSERT INTO udi_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dişoni tayfa, Eśeri tayfa saal Dişani tayfa. Edom oç̌ali Seir bölginə yəşəyinşala me tayfoox şuxun əmələ hareneysa hat'e amdari s'iyene taysay. ");
INSERT INTO udi_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","İsrailluğoxun padçağ c'eğamin Edom oç̌ala kalaluğbi padçağxo moroxey. ");
INSERT INTO udi_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Edomi samci padçağ Beori ğar Belane bake. Şo Dinhava şəhərene arst'ay. ");
INSERT INTO udi_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela p'urit'uxun oşa şot'ay gala Bośra şəhərexun bakala Zerahi ğar Yovave hari. ");
INSERT INTO udi_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yovav p'urit'uxun oşa şot'ay gala t'emanluğoy oç̌alaxun bakala Xuşame hari. ");
INSERT INTO udi_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Xuşam p'urit'uxun oşa şot'ay gala Bedadi ğar Hadade hari. Midyanluğoy loxol taśi şot'oğo Moava k'as'p'i śipiyo hame Hadadey. Şot'in Avit' şəhərene arśi padçağluğbsay. ");
INSERT INTO udi_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad p'urit'uxun oşa şot'ay gala Masrek'axun bakala Samlane hari. ");
INSERT INTO udi_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla p'urit'uxun oşa şot'ay gala Şaule hari. Me Şaul oqe börine bakala Rexovot' şəhərexuney. ");
INSERT INTO udi_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Şaul p'urit'uxun oşa şot'ay gala Ak'bori ğar Baal-Xanane hari. ");
INSERT INTO udi_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ak'bori ğar Baal-Xanan p'urit'uxun oşa isə şot'ay gala Hadade hari, şot'ay arśi padçağluğbala şəhəri s'iyal P'auney. Me Hadadi çuğoy s'i Mehet'aveley, me Mehet'aveli nana isə Mezahavi xuyər Mat'redey. ");
INSERT INTO udi_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Moval Esavaxun törəyinşakit'oğoxun əmələ hari tayfoox q'a şot'oğoy mandala ganxoy s'iyurxo. Tayfa şuxun əmələ harenesa t'e amdari s'iyene taysay, tayfin məsk'ən saki gane s'iyal içoğoy cınse boş bakala t'e kalat'ay s'iyene taysay: T'imnay tayfa, Alvay tayfa, Yetet'i tayfa, ");
INSERT INTO udi_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholivamay tayfa, Elay tayfa, P'inoni tayfa, ");
INSERT INTO udi_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","K'enazi tayfa, T'emani tayfa, Mivśari tayfa, ");
INSERT INTO udi_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdieli tayfa saal İrami tayfa. Esavaxun törəyinşaki, oşal edomluyox uk'ala azuk'i boş bakala tayfoğoy q'a içoğoy mandala ganxoy s'iyur metəre taysay - tayfin əmələ eysuna bulbi t'e amdari s'iyen. ");
INSERT INTO udi_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","İak'ov hari Kənan oç̌ala, izi bava İsaak'iyal q'ərib k'inək' yəşəyinşi me ölkinəne çurk'ala baki. ");
INSERT INTO udi_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","İsə ekinan İak'ovaxun bakit'oğoy bel harit'oğoxun exlətp'en. İosif ene vǔğes's'e yəşt'ə sa ğarey. Şot'in İak'ovi Bilhaxun q'a Zilp'axun baki ğarmoğo, izi bavaxun sa viçimoğo köməybi şot'oğoxun sagala çöle eğelxone otarişbsay. Şot'oğon pis sa əş biq'at'anal eçeri mot'o izi bava p'ap'esepsay. ");
INSERT INTO udi_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","İosif İsraili piin işiğey, izi q'ojabaki vədinene bakey pi ğarmoğoy boş bitot'uxun gele şot'one çuresay. Eçeri şot'aynak' toyexlu, śampi sa paltaral ěbest'eney. ");
INSERT INTO udi_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Viçimoğon hist'unbsay bavay içoğo c'ək'psuna, şot'o görəl İosifa ak'ala pul tet'ux buy, şot'oxun muč'a əyitp'esal tet'un baksay. ");
INSERT INTO udi_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sa ği isə İosifen nep'e ak'i. Hayzeriyal izi ak'i me nep'a viçimoğo exlətp'it'uxun oşa lap şot'oğoy piyexun bineti. ");
INSERT INTO udi_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","İosifen metəre exlətp'i izi ak'i nep'a: «Sa běğanan nep'e boş k'əz ak'e! ");
INSERT INTO udi_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Azk'i ki, q'oruğa yoqyan ğaç̌e: bezi ğaç̌p'i yoq tik çurpene, efi ğaç̌p'it'oğonal bezi yoqe běš biti şot'o bult'un k'os'psa». ");
INSERT INTO udi_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","İosifi viçimoğon qaybaki içu metərt'un pi: «İsə k'ə upsunen çuresa ki? Padçağ baki beşi loxol kalaluğbala fikirvax bu?!» İosifen me nep'a exlətp'it'uxun oşa viçimoğon şot'o lap gelet'un nifrətbsa burqi. ");
INSERT INTO udi_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Oşa İosifen sa nep'al anek'i. Hayzeri şot'oval izi viçimoğoynak' exlətpsa burqi pine: «Sa nep'al azk'i zu: bězği ki, göynul bakala běğ q'a xaşe, izi t'ǒğǒlal sas's'e dənə muč'uli - bitet'un za bult'un k'os'psa!» ");
INSERT INTO udi_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","İosifi ak'i me nep'a bavan ibakat'an isə şot'o töymətbi metəre pi: «Mo hetər nep'uren aksa hun?! K'ə upsune mo? Yəni zuval, vi nananal, vi viçimoğonal hari vi běš biti bul k'os'pala bakalyan va?» ");
INSERT INTO udi_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","İosifi ak'ala me nep'urxo görə izi viçimoğoy içu ak'ala pul tet'ux buy, bavay isə eyexun tene c'eysay İosifi piyorox. ");
INSERT INTO udi_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sa ği, İosifi viçimoğon heyvanxo taşeri Şekemi hərrəmine bakala oç̌alxo otarişala vədine, ");
INSERT INTO udi_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","İsrailen İosifa k'alpi pine: «Vi viçimoğon heyvanxo taşeri Şekema otarişbsuna avanu. Va şot'oğoy t'ǒğǒlez yaq'absun çuresa». İosifenal qaybaki \"lap şaat', hetər nexnu baz\" pine. ");
INSERT INTO udi_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","T'e vədə İsrailen İosifa tapşurbi pine: «Taki běğa běyn, vi viçimux t'iya hetərt'un, k'ət'un bsa. Běyn heyvanxo salamate, k'ə bu, k'ə tene bu - bitova avabaka, eki zaynak' sa xavar eça». Hametər, İosif içoğoy çurpi Xevroni dərənexun c'eri Şekemaç yaq'ane baft'i. Hariyal Şekema p'ap'i ");
INSERT INTO udi_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","çöle izi viçimoğo qə̌věğala gala içu sa amdare irəst'hari. T'e amdaren içuxun \"k'ən qə̌věsa miya\" pi xavare haq'i, ");
INSERT INTO udi_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","İosifenal qaybaki \"bezi viçimoğo, ten ava şot'oğon mayat'un heyvanxo otarişbsa?\" pine. ");
INSERT INTO udi_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","T'e amdaren metəre pi: «C'ert'un şorox memiin, unk'on Dot'anat'un taśi, ketər sa əyit lafedi bezi ǔmǔğo». Mot'o ibaki İosifal taneśi Dot'ana, taśiyal izi viçimoğo t'iya bə̌ğə̌nebi. ");
INSERT INTO udi_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Viçimoğon İosifa hələ ə̌xiləxun ak'i çalt'unxi, hari içoğo p'ap'aminal əyitə sat'unbi ki, şot'o besp'alt'un. ");
INSERT INTO udi_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Şot'oğon içoğoy arane metərt'un pi: «Mone, enesa beşi nep' ak'ala ğar! ");
INSERT INTO udi_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ekinan kot'o besp'en, oşal sa kure boş bosen taśeq'an! K'oyal uyank'on ki, ə̌qnə heyvanxone śarpe. T'e vədə běyanğon běyn k'ə bese baksa izi ak'i nep'urxon!» ");
INSERT INTO udi_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ama Ruvenen şot'oğoy me exlətxo ibaki, İosifa çark'est'une çureśi. Şot'in pine: «Besmabanan! ");
INSERT INTO udi_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","P'i śipi günax əşp'est'un lazım bateneksa. Şot'o ef kiin ma besp'anan, me xam ganu bakala kururxoxun sunt'ay boş bosaynan, bəse». Ruveni fikir isə şoney ki, oşa hari İosifa kure boşt'an c'evk'i qaydi bavay t'ǒğǒl taşale. ");
INSERT INTO udi_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Hametər, İosif hari viçimoğoy t'ǒğǒl p'ap'ala k'inək' lavabaki şot'ay loxolxun t'e toyexlu paltara zapi c'evt'unk'i, ");
INSERT INTO udi_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","oşal biq'i bot'unseri kure boş. Kur isə ams'iney, iz boş xe tene buy. ");
INSERT INTO udi_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Oşa arśi šum ukala gala bět'unği Gileadi tərəfəxun sa kərvane eysa. Mo ismailluğoy kərvaney, buşurxoy loxol şaat' adeğala oyurxo, c'əyin saal mət lapi taşeri Misirə toyt'unst'ay. ");
INSERT INTO udi_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","T'e vədə İudan izi viçimoğo pine: «İsə uk'en p'ure beşi viçi, mot'oxun k'ə q'azayinşi bakalyan? Lap mot'o bitot'uxun c'ap'albayan, beşi ozanene me günax! ");
INSERT INTO udi_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Şaat'o şone besmaben kot'o, toyden taśeq'an me ismailluğo. Heq'ədər uk'ayan, p'urumal beşi viçine, sa p'ine taysa beşi bitot'ay boş». Viçimux İuday əyitə bast'unki, ");
INSERT INTO udi_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","hariyal kərvan içoğoy t'ǒğǒlxun c'ovakat'an İosifa kure boşt'an c'evk'i ismailluğo q'a dənə gümüşi tənginəl toyt'undi. Hametər, Midyan oç̌alaxun mal taşeri toydalxon İosifa içoğoxun haq'i tat'unśi Misirə. ");
INSERT INTO udi_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Me bakit'oğoxun izi xavar nu bakala Ruvenen isə hayzeri taneśi ki, İosifa kurnuxun c'evk'i çark'est'ale. Hariyal ak'at'an ki, İosif kure boş butene, bureqi izi loxol bakala paltara zığ-zığbi ǒnepsa, t'emane şot'aynak' izi ük' bok'i. ");
INSERT INTO udi_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Şo izi viçimoğoy t'ǒğǒl hari pine: «Butene bezi mis'ik' viçi! İsə bezi bula haq'i maya tağaz zu?!» ");
INSERT INTO udi_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","T'e vədə viçimoğon sa keçi šampi, oşal İosifi loxolxun zapi c'evk'i paltara dirist' p'iyalt'unbi. ");
INSERT INTO udi_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Şot'oğon t'e toyexlu, śampi paltara bavaynak' eçeri pit'un: «Sa miya běğa k'əyan bə̌ğə̌be! Beşi zənden mo vi ğare paltare, tene ki?» ");
INSERT INTO udi_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","İak'oven paltara ak'ala k'inək' çalxi harayepi: «Bezi ğare paltare mo, bezi İosifi paltare! Taneśi bezi ğar, ə̌qnə heyvanxoynak' yeme baki!» ");
INSERT INTO udi_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Metər piyal bureqi izi loxol bakala paltara zığ-zığbi ǒnepsa. İzi loxol çul lavk'i hema ği yase efi İak'oven, şuk'k'alenal şot'o şip'bes tene baksay. ");
INSERT INTO udi_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","İzi ğarmoğon q'a xuyərmoğon gireśi içu ük' tast'un çureğat'an isə qaybaki metəre nexey: «Ma galdanan za, bartanan ǒnek'az bezi ğareynak'! Bisunez çuresa zu, t'e dünyəne, bezi ğare t'ǒğǒl taysunez çuresa!» Hametər, İosifi bisunen İak'ova gelene bok'osp'i. ");
INSERT INTO udi_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Şo izi ğare loxol ǒnepsaxey, midyanluğon isə İosifa Misirə taşeri şot'o faraoni q'aroolçiğoy kalo bakala P'ot'ifara toyt'undi. ");
INSERT INTO udi_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Me arane isə İuda izi viçimoğoxun cöybaki adullamlu Xira uk'ala sa amdari t'ǒğǒle köçp'i taśi. ");
INSERT INTO udi_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Miya Şua uk'ala sa kənanlun xuyərə ak'iyal, şot'o haq'i içeynak' çuuxe bi. ");
INSERT INTO udi_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Şot'in bǐhi baki sa ğare eçeri, İudanal me ğare s'iya Ere laxi. ");
INSERT INTO udi_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Oşa şo saal əyləne mandi, hari p'ə̌mci ğar bakat'anal İudan əylin s'iya Onane laxi. ");
INSERT INTO udi_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","İuday çuğon sa ğaral eneçeri, ğare s'iyal eçeri Şelat'un laxi. Me xibimci ğar bakat'an şorox K'ezivat'un baksay. ");
INSERT INTO udi_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Əylux hari kalat'unbaki, İudanal izi kala ğareynak' Tamar uk'ala sa xuyəre haq'i. ");
INSERT INTO udi_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ama İuday kala ğar Er izi biq'i pis əşurxo görə Q'ončuğoy piyes şaat' tene ak'esay pi Q'ončuğon şot'ay elmoğo haneq'i. ");
INSERT INTO udi_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","T'e vədə İudan izi p'ə̌mci ğar Onana pine: «İsə vi p'uri viçey çuğo hun haq'alanu, barta vaxun əylux eçereq'an ki, vi viçey s'i maq'an batk'i». ");
INSERT INTO udi_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onanen avaney ki, içuxun bakala əyloğoy loxol izi təə, izi viçey s'i bakale, şot'o görəl hər Tamaraxun bakat'an izi śilə oq'ane śiney ki, şo əylə maq'an mandi. ");
INSERT INTO udi_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Q'ončuğoy piyesal şot'ay biq'ala me əş gele pise ak'eśi, şot'o görəl Q'ončuğon Onani elmoğo haneq'i. ");
INSERT INTO udi_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","T'e vədə İudan izi mis'ik' ğar Şelal k'ənesa banekon pi q'ǐnebi, şot'o görəl izi bin Tamara metəre pi: «Va bezi ğar Şelaynak' haq'alazu, ama şo hələ mis'ik'e. Taki Şela kalabakamin vi bavay k'oya manda, vi yasa t'iya efa. Bezi ğar kalabakat'an isə va şot'aynak' eçoz». Tamaral taśi izi bavay k'oyane manst'a burqi. ");
INSERT INTO udi_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sa heq'ədər vədə hari c'ovakit'uxun oşa, İuday çuux Şuay xuyərəl p'ure. İuda yasaxun c'ere, hayzeriyal izi dost' bakala adullamlu Xiraxun sagala T'imninane taśi, t'iya izi eğelxone buy q'açibala. ");
INSERT INTO udi_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara isə mo hari p'anep'i. Şot'in izi q'ayinbay T'imnina eğelxo q'açibsa taysuna ibakat'an ");
INSERT INTO udi_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","izi loxol bakala yase paltara c'evk'i q'erəz paltare lapi. İzi ç̌oya butk'iyal taśi T'imnina tağala yaq'e loxol bakala Enayim şəhəre bağala darvazin tume areśi. Tamar izi q'ayinbaxun əcuxluney: Şela ene kala işq'arey, ama hələl hari içu tatet'unşt'ay. ");
INSERT INTO udi_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tamari ç̌o but'ey pi İudan şot'o ak'at'an çaltenexi, yaq'nuxun c'eri sa çuuxe zəndbi. ");
INSERT INTO udi_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Fırıpi şot'ay t'ǒğǒl taśiyal pine: «Eki zaxun, vaxun bask'oz». İudan yaq'e t'ǒğǒl arśi me çuğoy izi bin baksuna tene avay, şot'o görəne metər pi. Tamaren isə qaybaki \"bezi haq'q' k'ə bakale p'oy?\" pine. ");
INSERT INTO udi_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","İudan pine: «Vaynak' bezi sürünəxun sa q'uzi yaq'aboz». Ama Tamaren p'urumal irəzi nu baki pine: «Hat'etər upsunen tene baksa. T'e q'uzi hari za p'ap'amin zast'a k'ənesa efalanu, zuval avabakaz ki, vi əyiti loxol çurk'alnu». ");
INSERT INTO udi_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","T'e vədə İudan xavare haq'i: «K'ə efaz ki?» Tamarenal qaybaki \"vi s'i izi loxol bakala peçat'a, şot'o vi ozanexun suruk'p'ala bağa saal vi kiyel bakala çombağa\" pine. İuda irəzinebaki, Tamaren pit'oğo tadiyal taśi şot'oxun basek'i. Tamar me basksunen əyləne mandi. ");
INSERT INTO udi_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mot'oxun oşa Tamar izi bavay k'oya qaybaki, izi paltara badalbiyal p'urum izi yasa efsane burqi. ");
INSERT INTO udi_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","İudan isə izi adullamlu dost' Xira sa q'uzi tadi yaq'anebi ki, taśi t'e tarak'ala çuğo bə̌ğə̌bi şot'ay kiyexun izi efit'oğo ext'eq'an. Ama t'e amdaren maya uk'ayin qə̌věśi, p'urumal çuğo tene bə̌ğə̌bi. ");
INSERT INTO udi_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","T'e vədə t'iya bakala amdarxoxun xavare haq'i: «Me Enayim şəhəre bağala darvazin tume arśala çuğo tenan ava maya? Miya arśi içu tənginen işq'arxo toydalt'oğoxuney». Amdarxonal qaybaki \"tene bake miya ketər çuux\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Xiran İuday t'ǒğǒl qaybaki pine: «Tez bə̌ğə̌bi vi uk'ala çuğo. Lap amdarxoxunal xavarez haq'i, bitot'inal pine ki, miya ketər sa çuux tene bake». ");
INSERT INTO udi_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","İudan pine: «Ene lazım tene baksa, barta mandeq'an bezi tadiyorox izi kiyel, tene axšumi ga bakalyan. Zu bezi əyiti loxol çurpi q'uzina yaq'abez, içu bə̌ğə̌bes teyan baksasa, ko beşi taxsır tene». ");
INSERT INTO udi_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Me exləti loxolxun xib xaşe c'ovaki bakoy, İuday ǔmǔğo hari p'anep'i ki, p'oy izi bin tarapene, isəəl bı̌hine. İudanal mot'o ibakala k'inək' pine: «Taşanan kot'o dirist'-dirist' bok'osp'anan!» ");
INSERT INTO udi_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ama Tamara ext'i bok'ospsa taşat'an şot'in izi q'ayinbaynak' xavar yaq'abi pine: «Takinan bezi q'ayinba upanan ki, bezi kiyel bakalorox şinesa, şot'oxunzu bı̌hi». Metər piyal izi kiyel bakala peçata, bağa saal çombağane ak'est'i. ");
INSERT INTO udi_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","İudan mot'oğo ak'ala k'inək' çalexi, pěšmanbakiyal pine: «Ç̌omə̌yinzu zu me xuyəri běš! Düze nex, şot'o bezi ğar Şela çuux pi tadiyzuy, metərəl tene bakoy!» İudan şot'o ene sal sa vədə izi kula tene duği. ");
INSERT INTO udi_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Hametər, Tamari əyel bakala vədə hari p'anep'i, əylə bakest'at'anal bět'unği ki, əkize. ");
INSERT INTO udi_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Əyloğoy sunt'ay kul c'ere, mamaçinenal \"mo süft'ə bakiyone\" pi ext'i əylin kiyel č'oč'a t'urine ğaç̌p'i. ");
INSERT INTO udi_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ama oşa běneği me əylen izi kula qaydi badene, izi gala t'iyə̌minone c'eysa. T'e vədə məət't'əl mandi pine: «Mo hun hetəren zığbi c'eri?» Əylin s'iya haketərəl lat'unxi - P'ereś. ");
INSERT INTO udi_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Oşa ene izi kiyel č'oč'a t'uri bakaloval c'ere, me əylin s'iyal eçeri Śeraxt'un laxi. ");
INSERT INTO udi_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Hametər, ismailluğon İosifa et'unçeri Misirə, misirlu P'ot'ifarenal miya şot'o ismailluğoxun təngə tadi haneq'i. Me P'ot'ifar isə mis'ik' amdar teney, faraoni q'aroolçiğoy kaloney. ");
INSERT INTO udi_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","İosif şot'ay k'oyane manst'a burqi, Q'ončuxal dim izi tərəfe baksay pi İosifen izi kula mani əşlə boxodayin buye c'eysay. ");
INSERT INTO udi_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","P'ot'ifaren içinal aneksay Q'onç̌ugoy şot'oxun baksuna, İosifi əşurxoy şaat' taysunast'a Q'ončuğoy kul baksuna avaney. ");
INSERT INTO udi_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Şo izi ük'e t'etəre bask'i ki, eçeri şot'o izi nökərxoy loxol kalone laxi, isə ene saycə içune q'ulluğbsay. İosif P'ot'ifari yön kule baki: misirlun k'ə bunesa bito iz kiyexune c'ovaksay, şot'ay k'ojin əşurxoval içine taşt'ay. ");
INSERT INTO udi_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Q'ončuğonal P'ot'ifaraxun İzi xeyir-bərəkətə kamtenebsay, şot'ay əşurxo İosifene taşt'ay pi mot'ay əvəzə bol-bole tast'ay. Q'ončuğoyxeyir-bərəkəte buy P'ot'ifari k'ojin loxolal, qavuna k'ə but'uxsa şot'oğoy loxolal, ");
INSERT INTO udi_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","şot'o görəl izi k'ə bunesa bitova İosifane tapşurbi faraoni q'aroolçiğoy kalat'in. İçin isə kəyi-ǔği taranney, k'ojin əşurxo iz ozane exst'unen şot'ay əşləne suuk'p'ey İosifen. İosif isə q'əşəng ğarey, içust'a boy-buxunal buney. ");
INSERT INTO udi_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","P'ot'ifari çuğoy pul şot'ay loxoley. Sa ğiyal şot'o izi t'ǒğǒl k'alpi pine: «Eki zaxun bask'a». ");
INSERT INTO udi_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ama İosifen qaybaki çuğo metəre pi: «Me k'oya hər şeya zane tapşurbe bezi ağan, zaxun arxayine pi izi kula sa əşlə tene duğsa. ");
INSERT INTO udi_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Za me k'ojin kalone laxe, bezi əyite c'ovaksa miya izi əyit c'ovak'ala k'inək'. İsə hetərez şot'ay çuğoy loxol q'erəz piin běğon zu, şot'ay šuma ç̌axç̌uxp'i Buxačuğo bǐhi tağala me əşlə hetərez biq'on?» ");
INSERT INTO udi_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Çuğon isə me exlətəxun oşal kul tene haq'say, İosifa hər ği izi t'ǒğǒl k'alpi şot'o belxun c'evksune çuresay, ama İosifen nə şot'oxun basksun, nə izi t'ǒğǒl çurpsun çurtenesay. ");
INSERT INTO udi_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Sa ği İosif hari k'oya baneśi ki, izi əşurxo bale. K'oyal q'erəz şuk'k'al tene buy pi ");
INSERT INTO udi_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","P'ot'ifari çuğon İosifa ak'ala k'inək' şot'ay paltaraxun biq'i ləçəq'eśi ki, eki zaxun bask'a. Ama İosif şot'ay kiyexun c'eft'i t'etəre t'it'eri ki, izi ç̌oyexun lak'ala paltar çuğoy kiyel manedi. ");
INSERT INTO udi_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Çuğon İosifi paltara efi c'eri t'ist'una ak'at'an ");
INSERT INTO udi_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nökərxo k'alpi bureqi izi səsə ext'i haraypsa: «Və̌n sa me əbraninast'a bakala ç̌oya běğanan! Bezi işq'aren içu eçeri k'oyane bade, mot'in za əyite bost'a! Harene ki, eki zaxun bask'a, şoval běneği ki, harayezne, ");
INSERT INTO udi_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","bezi harayaxun q'ǐbi c'eri t'inet'eri. Mone, izi ç̌oyexun lak'ala paltaral bezi kiyel manedi». ");
INSERT INTO udi_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Çuğon İosifi paltara izi işq'ar k'oya eğamin oq'a tene laxi, ");
INSERT INTO udi_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","işq'ar hari k'oya bağala k'inək'əl bureqi nökərxo pit'oğo mot'oval upsa: «Vi eçeri k'oya badi əbraninen avanu k'ə be? Harene za nexe ki, eki zaxun bask'a! ");
INSERT INTO udi_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Şoval běneği ki, bezi səsə ext'ez harayezne, c'eri t'inet'eri. Mone, izi paltaral bezi kiyel manedi». ");
INSERT INTO udi_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Çuğon \"vi eçeri k'oya badi nökəren za metər əyite pe\" uk'at'an P'ot'ifari belxun küüne c'eri, ");
INSERT INTO udi_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","şot'in əmirebi ki, İosifa biq'i zindanaq'at'un badi. Hametər, İosifa biq'i bat'undi padçaği əmiren biq'eśit'oğoy arśala zindana. ");
INSERT INTO udi_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ama Q'ončuğon miyal İosifi loxolxun İzi kula tene zapi, şot'o İzi nu badalbakala çuresuna ak'est'i t'etəre bi ki, zindani kalat'ay ük'ene bask'i İosif. ");
INSERT INTO udi_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Şot'inal eçeri İosifa zindana arśit'oğoy loxol kalaluğbsunane tapşurbi. Zindana bakala əşurxoy bitova İosifene taşt'ay pi ");
INSERT INTO udi_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","zindani kalat'in pes banekon əş tene əşpsay: tapşurbeney bitova İosifa, içal arxayin taranney. İosifi əşurxo şaat'e taysay, şot'o görə ki, Q'ončux izi tərəfey. ");
INSERT INTO udi_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sa heq'ədər vədə hari c'ovaneki, sa ğiyal t'etəre baki ki, saraya əşp'ala fibak'alen q'a šumbadalen içoğoy ağay, Misiri padçağ bakala faraoni əcuğo biq'est'undi. ");
INSERT INTO udi_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraonenal izi əcuğon biq'i əmirebi ki, izi saraya bakala fibak'alxoy kalat'u q'a šumbadalxoy kalat'u ");
INSERT INTO udi_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","biq'i badeq'at'un zindana. Zindan isə padçaği əmiren biq'eśit'oğoy arśala zindaney, q'aroolçiğoy kalo bakala P'ot'ifari k'ojal ləçəq'ey. İosifal me zindanane arst'ay. ");
INSERT INTO udi_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Zindani kalat'in eçeri şot'oğoval İosifane tapşurbi, İosifenal mandit'oğo běğalt'ullarik' bureqi mot'oğoval běğsa. Şot'oğon sa heq'ədər vədə zindana arśit'uxun oşa ");
INSERT INTO udi_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","sa üşe nep't'un ak'i. Padçaği fibak'alenal, šumbadalenal hat'e sa üşet'un ak'i içoğoy nep'a, hərsunt'ay nep'al cöy-cöyey. ");
INSERT INTO udi_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","İosif savaxt'an şot'oğoy t'ǒğǒl eğat'an běneği ki, k'ənesa içoğoy p'i mə̌yine. ");
INSERT INTO udi_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","T'e vədə İosifen faraoni saraya əşp'it'oğoxun, içuxun sagala izi ağay k'oja ləçəq' me zindana arśit'oğoxun xavare haq'i: «K'ə bake? Het'u görənan efi k'odoğo śipi arśe?» ");
INSERT INTO udi_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Şot'oğonal qaybaki \"nep'yan ak'e, ama me nep'e k'ə upsuna avabakal tene bu\" pit'un. İosifen şot'oğo metəre pi: «Buxačuğon İçin avabakest'ale efi ak'i nep'urxoy k'ə upsuna. İsə exlətp'anan běyn k'ənan ak'e». ");
INSERT INTO udi_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Padçaği saraya bito fibak'alxoy kalo əşp'it'in izi ak'i nep'a exlətpsa burqi pine: «Nep'en azk'i ki, c'ap'e bu, ");
INSERT INTO udi_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","izi loxolal xib dənə tay. Taymoğon bureqi s'is'ik' qaypsa, oşal hat'e saad ğuma biq'i t'ule c'epi. ");
INSERT INTO udi_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Faraoni fi ǔğə̌lə əyaq' isə bezi kiyeley: ext'i burezqi me t'ulurxo əyaq'i boş q'ač'p'i faraona tast'a ki, ǔğěq'an». ");
INSERT INTO udi_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","İosifen şot'o pine: «Həysə uk'oz va k'ə upsune ke nep'. Xib dənə tay - mo xib ği upsune. ");
INSERT INTO udi_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Xib ğinaxun oşa faraonen va memiin c'evk'est'i taşeri p'urum izi fibak'alxoy kalo laxale. Hunal běšin k'inək' vi padçağa fi bapi tadalnu. ");
INSERT INTO udi_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ama t'etər ba ki, zaal eyexun ma c'evk'a, bezi pi t'e şaat' ğimxo eğat'an zaynak' ǰomo ə̌mba faraoni t'ǒğǒl, c'evk'est'a za me zindanaxun. ");
INSERT INTO udi_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Axıri əbraniğoy oç̌alaxunal bezi çuresunen tez c'ere zu, hari miyal hik'k'ali loxolez zindana arśe». ");
INSERT INTO udi_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Saraya padçağeynak' šum badit'in ak'at'an ki, fibak'ali nep' şaat'e c'eri, içinal izi nep'a İosifa exlətpsa burqi pine: «Zuval sa nep' azk'i. Nep'en azk'i ki, bezi bel xib dənə k'ans'arane bu sunay loxol, ");
INSERT INTO udi_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ç̌oyel bakalt'ay boşal faraoneynak' badeśi šumen q'a muč'a şeymoğon buye. Ama q'uşurxon hari bezi bel bakala k'ans'arin boşt'an t'uk't'i ut'unksay faraoni s'iyen badeśi t'e šumurxo». ");
INSERT INTO udi_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","İosifen şot'o pine: «Həysə uk'oz va k'ə upsune ke nep'. Xib dənə k'ans'ara - mo xib ği upsune. ");
INSERT INTO udi_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Xib ğinaxun oşa faraonen vaal memiin c'evk'ale. Taşeriyal vi bula bot'i, bədənə isə maq'e loxol lavk'ale, q'uşurxonal şot'o hari t'uk't'i ukalt'un». ");
INSERT INTO udi_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Me exləti loxolxun hari xib ğine c'ovaki, faraonenal izi nanaxun baki ğiney pi eçeri izi sarayi amdarxo kəyi-ǔğsune tadi. Şot'in hat'e ği izi fibak'ala q'a šumbadalal zindanaxun c'evk'esedi, ");
INSERT INTO udi_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","eçeriyal sunt'u p'urum içu fi bapi tadale bi, ");
INSERT INTO udi_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","t'e sunt'ayal bula bot'est'i maq'e loxol lavk'esedi. Hametər, İosifen piyorox bito hari düze c'eri. ");
INSERT INTO udi_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ama fina bapi padçaği kiyel tadalt'in izi ǰomo ə̌mbi əyit tene pi İosifi barada, izi eyexun c'evek'i şot'in İosifen içu pit'oğo. ");
INSERT INTO udi_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Me exləti loxolxun p'ə̌ usene c'ovaki, sa ğiyal faraonen sa nep'e ak'i. Běneği ki, Nil oqe börine çurpene, ");
INSERT INTO udi_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","xene boşt'anal vǔğ dənə buy, vərkər çure c'eysa. C'eriyal taśi burt'unqi xene t'ǒğǒl bakala gěšluğa ot't'ayinşbsa. ");
INSERT INTO udi_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Oşa xene boşt'an vǔğ dənə goğan, halnuxun biti çure c'eri. C'eriyal taśi me buy, vərkər çururxoy t'ǒğǒl çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bürdən me goğan, halnuxun biti çururxon biq'i buy, vərkər çururxo kəyt'un. Nep'e me gala faraon muğurebaki. ");
INSERT INTO udi_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Oşa p'urum nep'axeśi sa nep'al anek'i. Běneği sa arume c'ere, izi loxolal vǔğ dənə buy, şaat' sümbüle bu. ");
INSERT INTO udi_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Bač'anexun sa arumal c'ere, mot'ay loxol isə vǔğ dənə puça, bok'i sümbüle bu. ");
INSERT INTO udi_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bürdən me puça, bok'i sümbülxon biq'i buy, şaat' sümbülxo q'uc't'unpi. Hame gala faraon muğurebaki, ma upa moval nep'ey. ");
INSERT INTO udi_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Hari kəyebaki, faraonen isə içeynak' ga tene bə̌ğə̌bsay, izi ak'i me nep'urxoy k'ə upsunane avabaksun çuresay. Şot'in Misirə bakala bito sehirbazxo q'a me əşlə k'alpi müdrik amdarxo izi t'ǒğǒle eçest'i, şot'oğoynak' izi ak'i nep'urxo exlətebi, ama saycət'in me nep'urxoy k'ə upsuna pes tene baki. ");
INSERT INTO udi_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","T'e vədə faraoni fina bapi izi kiyel tadalt'in içu pine: «Həysəne bezi eyex bafst'a ki, hetər əşez biq'e zu! ");
INSERT INTO udi_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Sa kərəm bezi ağa faraoni izi k'ulurxoy - bezi q'a šumbadali loxol əcuğon biq'i yax q'aroolçiğoy kalat'ay k'oja ləçəq' bakala zindanane badest'i. ");
INSERT INTO udi_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","T'iya sa üşe nep'yan ak'i - zuval, šumbadalenal hat'e sa üşeyan ak'i beşi nep'a, hərt'ay nep'al cöy-cöyey. ");
INSERT INTO udi_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Yaxun sagala sa əbrani ğare arst'ay, q'aroolçiğoy kalat'ay nökəre əşp'ey. Şot'oyan exlətp'i beşi nep'a, şot'inal beşi hərt'ay nep'a cöy-cöy pine k'ə upsune. ");
INSERT INTO udi_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Şot'in yax hetər pine, hat'etərəl c'ere: za eçeri p'urum vaynak' fibak'alen bi, šumbadala isə maq'e loxolen lavk'est'i». ");
INSERT INTO udi_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraonen me exlətə ibakala k'inək' əmirebi ki, taśi İosifa izi t'ǒğǒlq'at'un eçeri. İosifa zindanaxun c'evk'i, izi paltara badalbest'i, izi ç̌oya, bula xampest'iyal eçeri faraoni běš çurdest'undi. ");
INSERT INTO udi_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faraonen İosifa pine: «Sa nep'ez ak'e zu, şuk'k'alenal za şot'ay k'ə upsuna pes tene baksa. İsə izbaksa ki, şiin vi t'ǒğǒl izi nep'a exlətp'ayin, hun hat'e saad şot'ay k'ə upsuna nexnu». ");
INSERT INTO udi_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","İosifen qaybaki faraona metəre pi: «Zu təə, Buxačuğon İçin avabakest'ale faraoni ak'i nep'e k'ə upsuna, şoval şaat' c'eğale». ");
INSERT INTO udi_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraonenal izi ak'i nep'a exlətpsa burqi pine: «Azk'i ki, Nil oqe börine çurpezu, ");
INSERT INTO udi_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","xene boşt'anal vǔğ dənə buy, vərkər çure c'eysa. C'eriyal taśi burt'unqi xene t'ǒğǒl bakala gěšluğa ot't'ayinşbsa. ");
INSERT INTO udi_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Oşa xene boşt'an vǔğ dənə goğan, halnuxun biti çure c'eri. T'etər goğant'uniy ki, zu hələ ketər goğan çur tez ak'e Misirə - sa t'oley, sa ǔq'en. ");
INSERT INTO udi_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bürdən me goğan, halnuxun biti çururxon biq'i buy, vərkər çururxo kəyt'un. ");
INSERT INTO udi_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","T'e boyda çururxo kəyt'un, ama hələl içoğoy tapan içoğo ləçəq'ey! Hame gala muğurezbaki. ");
INSERT INTO udi_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Oşa p'urum nep'axezśi, hat'iya sa nep'al azk'i. Bězği ki, sa arume c'ere, izi loxolal vǔğ dənə buy, q'əşəng ap'i sümbüle bu. ");
INSERT INTO udi_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Bač'anexun sa arumal c'ere, mot'ay loxol isə vǔğ dənə puça, bok'i, öləzi sümbüle bu. ");
INSERT INTO udi_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bürdən me puça sümbülxon biq'i vǔğ dənə buy sümbülə dirist' q'uc't'unpi. Bezi me nep'urxo nu exlətp'i sehirbaz tez barti zu, ama şuk'k'alen za mot'oğoy k'ə upsuna pes tene baki». ");
INSERT INTO udi_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","İosifen faraona pine: «Faraoni ak'i nep'urxoy p'rannat'ayal upsun çureğalo sane. Buxačuğon İzi bsun çureğalt'oğone avabakest'a va. ");
INSERT INTO udi_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Vǔğ dənə buy çural, vǔğ dənə buy sümbüləl - morox p'ǒğə̌l sa şeye - vǔğ usen upsune. ");
INSERT INTO udi_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Buy çururxoy bač'anexun c'eri vǔğ dənə goğan, turexun bitala çur q'a buy sümbülxoy bač'anexun c'eri vǔğ dənə puça, bok'i sümbüləl - sa şeye: vǔğ usen zap'k'ala busaluğ upsune. ");
INSERT INTO udi_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bezi pi k'inək'e: Buxačuğon faraona İzi bsun çureğalt'oğone avabakest'e. ");
INSERT INTO udi_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Eğala usenaxun burqi düz vǔğ usen Misirə t'etər sa bolluğ bakale ki, oç̌alen tadala bara girbi p'ap'esp'es tene bakal. ");
INSERT INTO udi_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Oşin eğala vǔğ usen isə nu ak'eśi sa busaluğ bakale. Me busaluğen Misirə t'e ğina badale ki, běšin usenxo girbit'oğoxun həş tene mandal, çökt'ale ölkinen. ");
INSERT INTO udi_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Běšaxun bitot'ay k'oya buy bakala šume k'ə baksun eyexun c'eğale amdarxoy, t'etər pis sa busaluğ bakale me ölkinə. ");
INSERT INTO udi_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Faraonen hat'e sa nep'a p'ə̌ cür aksun isə şo upsune ki, male mande, Buxačuğon me əşlə hetər laxenesa, hat'etərəl bakale, hik'k'al badaltenebakal. ");
INSERT INTO udi_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","İsə barta faraonen ə̌xilak'al, müdrik sa amdar bə̌ğə̌bi şot'o me ölkin əşurxo yaq'axtaşt'unaq'an tapşurbi. ");
INSERT INTO udi_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Barta hər bölgin loxolal sa kalo laxeq'an ki, şot'in me bolluğ bakala vǔğ usenast'a amdarxoxun içoğoy oç̌alxon tadala bare qo payaxun sunt'u girbeq'an. ");
INSERT INTO udi_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Barta t'e aruma ext'i, taşeri şəhərmoğo bakala padçaği ambarxo girbi efeq'at'un. ");
INSERT INTO udi_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Me t'ǒǒx laxi arum busaluğast'a əşeğale, Misiri oç̌alen bar nu tadala t'e vǔğ usenast'al amdarxo k'as'teneğal». ");
INSERT INTO udi_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","İosifi piyorox faraoni q'a izi amdarxoy ük'e basek'i. ");
INSERT INTO udi_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraonenal şot'oğo metəre pi: «Metər sa amdar ene mayin bə̌ğə̌balyan? Buxačuğoy Urufe bu kot'ost'a!» ");
INSERT INTO udi_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Oşa İosifi loxole běği əyitpsa burqi: «İsə ki, Buxačuğon İçin va bitot'uxun müdrik, ə̌xilak'al ak'i mot'oğo bitova avabakest'enesa, yan het'u görə taśi q'erəz amdar qə̌věğen? ");
INSERT INTO udi_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Mone, va bezi ölkin loxol kaloz laxsa, vi əyiten tağale bezi azuk'. Misiri padçağ s'iyaxun q'erəz vi zaxun kam ga tene bakal». ");
INSERT INTO udi_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Oşa faraonen saal əyitpsa burqi İosifa pine: «Bezi əyiti loxol çurezne zu, hesabba Misiri kalonu hun ene!» ");
INSERT INTO udi_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Metər piyal, izi kiyelxun peçat iz loxol bakala boğoç̌ala c'evk'i İosifi k'əşinene lavk'i. Şot'o eçeri ən toyexlu parçinen ěbeśi paltare lapest'i, izi q'oq'e q'ızıli śepe suruk'p'i. ");
INSERT INTO udi_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Oşa əmirebi ki, İosifeynak' izi laśi tarak'ala arabinaxunq'at'un eçeri, faraonen İosifa ěkurxon c'idi taşala t'e arabina arśevk'i taradesedi, amdarxonal şo hari içoğoy běšt'an c'ovakat'an \"çökt'anan!\" pi harayt'unney. Hametər, faraonen İosifa izi ölkin loxol kalone laxi. ");
INSERT INTO udi_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faraonen İosifa pine: «Zu faraonzu, bezi əyitəl mone: meyin oşa vi xavarsuz sa lə̌ngal lə̌ngbal tene bakal Misirə». ");
INSERT INTO udi_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Şot'in eçeri İosifi s'iya badalbi Śafnat'-P'aneahe laxi, On şəhəri běyinš bakala P'ot'iferani xuyər Asenat'al şot'o çuux pi tanedi. Hametər, İosifen taśi bureqi Misiri loxol kalaluğbsa. ");
INSERT INTO udi_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Otuz yəşe buy İosifi Misiri padçağ bakala faraonen şot'o me əşlə tapşurbat'an. Faraonaxun əmirə haq'i taśi bureqi İosifen dirist' Misirə tarapi hər şeye loxol kalaluğbsa. ");
INSERT INTO udi_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Düz vǔğ usen t'etər sa bolluğe baki ki, oç̌alen tadala bara girbi p'ap'esp'es tene baksay. ");
INSERT INTO udi_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Me usenxost'a Misiri oç̌alen tadala aruma bitova taşeri ambarxone girbest'ay İosifen, aruma mani şəhəri hərrəmine bakala oç̌alxoxunt'un exst'aysa, hat'e şəhəre bakala ambarxoval taşeri girt'unbsay. ");
INSERT INTO udi_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","İosifen girbi efi arumi bul-oš tene buy, t'ema geleney ki, axır vədine ene içinal tene avay heq'ədəre, dənizi börine bakala q'ume heq'ədər baksuna nu avabakala k'inək'. ");
INSERT INTO udi_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Hələ busaluğ eğamin İosifi Asenat'axun p'ə̌ ğare baki. Me Asenat' On şəhəri běyinš bakala P'ot'iferani xuyərey. ");
INSERT INTO udi_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","İosifen \"Buxačuğon eyexun c'evk'esedi za bezi ak'i koruğxo q'a bavay k'oja\" pi izi kala ğare s'iya Menaşşene laxi. ");
INSERT INTO udi_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","P'ə̌mci ğar bakat'an isə İosifen \"bezi koruğ zapi me oç̌ala Buxačuğon za avuzebi\" pi əylin s'iya Efraime laxi. ");
INSERT INTO udi_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Misirə bolluğ bakala t'e vǔğ usen hari c'ovaneki, ");
INSERT INTO udi_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","bač'anexunal busaluğe hari. İosifen pi k'inək' düz vǔğ usen zap'k'ala me busaluğen mandi oç̌alxoval bineq'i, ama Misirə bakala ambarxo arumen buyey. ");
INSERT INTO udi_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Busaluğ hari Misirə p'ap'at'an, amdarxon içoğoy ukala šuma nu bə̌ğə̌bi faraoni kiyel běğat'an Misiri padçağen metəre pi: «İosifi t'ǒğǒl takinan, şot'in avane k'ə bsune lazım». ");
INSERT INTO udi_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Dirist' ölkinəne haq'layinşi busaluğen, t'e vədə İosifen ambarxo qaypi bureqi aruma amdarxo toyst'a. Busaluğen isə taysun gelene haq'layinşbsay. ");
INSERT INTO udi_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Dünyəni t'e belxunal amdarxo hayzeri Misirə, İosifi t'ǒğǒlt'un eysay ki, şot'oxun arum haq'i taşalt'un, t'etər sa busaluğene ç̌axp'ey hər ganu. ");
INSERT INTO udi_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","İak'oven avabakat'an ki, amdarxon aruma Misirəxunt'un eşt'a, izi ğarmoğo pine: «K'ənan arśe sunay loxol běğsun?» ");
INSERT INTO udi_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Oşa metəre pi: «İbakezu ki, bitot'in taśi Misirəxune arum haq'i eşt'a. Takinan və̌nal t'et'iin haq'i eçanan ki, beşiyal ukala šumq'an baki, tene busa biyalyan». ");
INSERT INTO udi_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Me exlətəxun oşa İosifi vis' viçiyal hayzeri Misirə arum haq'sat'un taśi. ");
INSERT INTO udi_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ama İosifaxun nana sa bakala viçə, Binyamina İak'oven tene tərbi, enefi izi t'ǒğǒl, şot'ay belal əşe eğon pi q'ı̌nebsay. ");
INSERT INTO udi_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Hametər, dünyəni bip' t'ǒǒxun gireśi Misirə arum haq'sa eğalt'oğoy boş İsraili ğarmuxal baneki. Busaluğ hari Kənan oç̌alal p'ap'eney. ");
INSERT INTO udi_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Camaati arum haq'seynak' eğala me ölkin kalo isə İosifey. Arum toyst'uni əşləl şot'ine běğsay pi viçimux şot'ay t'ǒğǒlt'un hari, hariyal şot'ay běš ç̌ooq'a biti bult'un k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","İosifen viçimoğo ak'ala k'inək' çalexi, ama içu nu çalxsuna laxi izi k'odoğo śipiyal pine: «Mayinnan və̌n?» Viçimoğonal \"Kənan oç̌alaxun, arum haq'seynak'yan hare\" pit'un. ");
INSERT INTO udi_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","İosifen için viçimoğo çalxiyal bakayin, viçimoğon içu tet'un çalxi. ");
INSERT INTO udi_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","T'e vədə eyexe baft'i İosifi izi şot'oğoxun ak'i nep'ur, qaybakiyal izi viçimoğo metəre pi: «Xavar girbsanan hari bakon beşi oç̌alxo! Yəgin harenan běyn maya k'ə bu, běyn beşi zəyif ganxo bə̌ğə̌bi yax sakes bananksa!» ");
INSERT INTO udi_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ama viçimoğon içoğoy döşə t'apsa burqi pit'un: «Buxačuğon maq'an bi, beşi ağa! Arumeynak'e hare me vi k'ulurxo, q'erəz hik'k'al. ");
INSERT INTO udi_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yast'a c'ap' əş buteyax, mone, qay nexyan: viçimuxyan baksa yan, bito sa bavaxun baki əyluxyan. Ke vi uk'ala əşləxun ə̌xile me vi k'ulurxo!» ");
INSERT INTO udi_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ama İosifen p'urumal cügünubaki pine: «Větezu, beşi ölkin zəyif ganxo bə̌ğə̌bi yax sakseynak'nan hare və̌n!» ");
INSERT INTO udi_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","T'e vədə viçimoğon pit'un: «P'as's'e viçiyan yan, Kənan oç̌alaxun bakala sa amdari ğarmuxe me vi k'ulurxo bito. Beşi sa mis'ik' viçiyal buyax, şo tene hari yaxun, bavay t'ǒğǒle çurpi. Sa viçiyal p'urene». ");
INSERT INTO udi_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Mot'o ibakat'an İosifen saal pine: «Mone, bezi uk'alo hari c'ere, nexzu axıri və̌n miya xavar girbsanan hare! ");
INSERT INTO udi_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ama faraoni elmoğoz elase ki, efi şu baksuna nu avabakayiz, və̌x memiin tərtezbal! Hevaxt' efi mis'ik' viçiyal eneğon, t'e vədə c'eri tananğon. ");
INSERT INTO udi_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Barta efi boşt'an sunt'in taśi şot'o haq'i hareq'an, mandiyorox isə şorox eğamin zindana arśalt'un. İsə běğalyan efi uk'alt'oğoy düz baki nu baksuna! Əfçinan nexesa, faraoni elmoğoz elase ki, bezi uk'alone, miya xavar girbsanan hare!» ");
INSERT INTO udi_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Metər piyal xib ği şot'oğo zindana enefi. ");
INSERT INTO udi_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Xib ğinaxun oşa İosifen viçimoğo izi t'ǒğǒl eçest'i pine: «Efi elmoğo çark'est'un çurnansasa bezi uk'alt'u banan, şot'o görə ki, zuval və̌x memiya hat'etər gala efsun çurtezsa, Buxačuğoxun q'ı̌bala amdarzu zu. ");
INSERT INTO udi_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Efi uk'alorox bito düzesa, barta efi boşt'an soğo çurpeq'an miya, mandit'oğon isə aruma ext'i taśeq'at'un k'oya. Ham efi busa külfəteynak' šum taşeri bakalt'un, ");
INSERT INTO udi_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","hamal qaybakat'an efi mis'ik' viçə bezi t'ǒğǒl eçalt'un. Ama miya nu qaybakaynan, efi pit'oğoy düz baksuna ak'est'i efi viçə bezi t'ǒğǒl nu eçaynan, bito biyalnan». Viçimuxal irəzit'unbaki. ");
INSERT INTO udi_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Oşa içoğoy arane əyitpsa burqi pit'un: «Mone, beşi viçey bel eçeriyoroxe, hari c'enesa beşi běš! Heq'ədəre yax xoyinšp'i izi t'e çarasuz mandi ğine, ama saycət'in şot'o kul teyan boxodi. İsə mone, zap'yanne t'e ğine cazina!» ");
INSERT INTO udi_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruvenen isə pine: «Zu və̌x hat'e ğiyal pizu ki, ma galdanan əylə, efi ozane mandale ke günax! Ama ǔmǔxtenanlaxi, isə zapanan efi śipi p'iye cazina!» ");
INSERT INTO udi_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Viçimoğoy xavar buteney ki, İosifen şot'oğoy uk'alt'oğo bitova q'amişe, axıri memaçağ İosifen eçest'i amdarene şot'oğoy uk'alt'oğo misirluğoy muza taradi nexey. ");
INSERT INTO udi_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Şot'oğoy me əyitmoğo ibakat'an İosifen içu efes tene baki, c'eri taśi t'ǒǒx ǒnenepi. Oşa qaybaki hari p'urum bureqi şot'oğoxun əyitpsa, içoğoy boşt'an Simeona c'ək'p'iyal viçimoğoy piin běš şot'ay kul-tura ğaç̌p'est'i taşeri banedi zindana. ");
INSERT INTO udi_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","İosifen əmirebi ki, isə taşeri şot'oğoy xaralxo arumen buybi, içoğoy yaq'e šumal laxi yaq'abadeq'at'un. Hamal tapşurebi ki, şot'oğoxun təngə maq'at'un ext'i, hərt'ay eçeri gümüşi tənginə qaydi izi xarali boş laxeq'at'un. İosifen əmirbi k'inək'əl bit'un. ");
INSERT INTO udi_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hametər, viçimoğon aruma elemxoy loxol lapi yaq'at'un baft'i. ");
INSERT INTO udi_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Biyəbakat'anal sa ga bə̌ğə̌bi çurt'unpi ki, miya kəybalt'un. Viçimoğoy sunt'in taśi izi xarali boşt'an samal mu ext'i elema tast'un çureğat'an běneği ki, mone, ç̌oyel izi gümüşi təngoox! ");
INSERT INTO udi_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Şot'in iz viçimoğo k'alpi bureqi haraypsa: «Zaxun təngə ext'itet'un! Ekinan běğanan, bezi təngoox hamiya xarali boşe!» Me əyitə ibakat'an viçimoğo q'ı̌yene haq'i, içoğoy t'ut'ultina efes tet'un baksay. Burt'unqi sunay loxol běği upsa: «Buxačuğoy əşe mo! K'ə upsune çuresa yax?» ");
INSERT INTO udi_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Viçimux hari Kənan oç̌ala, içoğoy bava İak'ovi t'ǒğǒl p'ap'it'uxun oşa içoğoy bel hari əşurxo bitova exlətpsa burqi pit'un: ");
INSERT INTO udi_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«T'e ölkin loxol kalaluğbalt'in yaxun sal muč'a muzin tene əyitp'i, fikirebi ki, izi ölkinə xavar girbseynak'yan hare. ");
INSERT INTO udi_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Yanal qaybaki içu piyan ki, ketər əşurxoxun ə̌xilyan, beşi k'ə bunesa ç̌oyene. ");
INSERT INTO udi_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Oşa beşi p'as's'e viçi baksunal piyan. Piyan ki, yan bito sa bavaxun baki əyluxyan, həysə beşi mis'ik' viçi bavay t'ǒğǒl, Kənan oç̌alane, soğoval p'urene. ");
INSERT INTO udi_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ama t'e ölkin kalat'in yax p'urumal větenebaki, beşi uk'alt'oğoy düz baksuna avabakseynak' qaybaki pine ki, p'oy və̌xun sunt'u efoz miya, mandit'oğon isə aruma ext'i taśeq'at'un içoğoy busa külfəti t'ǒğǒl. ");
INSERT INTO udi_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ama sa şərten, beşi mis'ik' viçəl ext'i qaybakalayan izi t'ǒğǒl. Mot'oxun oşa yax věbakale, beşi viçə tərbi, yaxal bark'ale izi ölkinə tarapi beşi ük'en çureğalt'oğo haq'i-toyst'a». ");
INSERT INTO udi_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Viçimoğon eçeri içoğoy xaralxo ams'ibat'an bět'unği ki, içoğoy təngooxal t'iyane. Hərt'in izi xarali boş bakala tənginə ak'at'an, şot'oğo q'ı̌yene haq'i. İak'oven içinal q'ı̌nebi, ");
INSERT INTO udi_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","şot'in pine: «Bezi əyloğonan haq'i və̌n bezi kiyexun! İosif butene, Simeona efi harenan, isəəl nexnan ki, Binyaminal tada taşalyan! Mo he əşe enesa bezi bel!» ");
INSERT INTO udi_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","T'e vədə Ruvenen metəre pi izi bava: «Bezi p'ə̌ ğaral va q'urbane, Binyamina qaydi vi t'ǒğǒl nu eçayiz, haq'a şot'oğoy elmoğo! Arxayin baka, şot'o qaydi eşt'un bezi ozane!» ");
INSERT INTO udi_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ama İak'oven p'urumal yaq'alnuhari pine: «Tez yaq'absa bezi ğara və̌xun! İosif p'urene, Raxiləxun baki ğarmoğoxun sa dənə Binyamine mande. Kot'oval k'ənesa bakayin, k'əz bon zu? Ene sa kərəmluğ upanan ki, taşeri oç̌alaxyanpsa va! Me yəşt'ə ke dərdə portp'ala ük' tezax bu bezi!» ");
INSERT INTO udi_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Busaluğen isə taysun gelene haq'layinşbsay Kənan oç̌ala. ");
INSERT INTO udi_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Viçimoğon Misirəxun eçeri arumal çarek'i, t'e vədə İak'oven izi ğarmoğo pine: «Takinan samalal arum haq'i eçanan Misirəxun». ");
INSERT INTO udi_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ama İudan qaybaki izi bava metəre pi: «T'e amdaren yax qay pine ki, efi mis'ik' viçə nu eçaynan, bezi piyes ma ak'eynan. ");
INSERT INTO udi_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Beşi viçə yaxun yaq'anbsasa, yanal tağen vi uk'alt'u bi arum haq'en eğen. ");
INSERT INTO udi_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ama təə, \"tez yaq'absa\" nexnusa, t'e vədə beşi əş tene bu t'iya. Amdaren yax qay pine ki, efi viçə nu eçaynan bezi piyes ak'mayekinan». ");
INSERT INTO udi_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","T'e vədə İsrailen pine: «Mani haq'ılennan taśi t'e amdara nex ki, k'oya sa viçiyal buyax? Bezi bula bəlinənan badi çurpi gala!» ");
INSERT INTO udi_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ama ğarmoğon qaybaki içoğoy bava metərt'un pi: «T'e amdaren içine burqi yaxun bitova xavar haq'i avabaksa: şuyax bu, hema əyelyan, běyn beşi bava dirist'e, p'urene... İçin xavare haq'say, yanal coğabyan tast'ay, k'əyan avay ki, mot'in \"efi viçəl miya eçanan\" uk'ale?!» ");
INSERT INTO udi_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Oşa İudan saal əyitpsa burqi izi bava İsraila pine: «Əylə zaxun tərba, c'eğen tağen. Tene hunal, yanal, beşi əyluxal - bito busa k'as'eğalyan. ");
INSERT INTO udi_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Şot'o qaydi vi t'ǒğǒl eşt'un zaluğe - Binyamini mux tene k'oribakal, va əyitez tast'a. Şot'o k'ənesa bakayin hari za unk'on me əyitmoğo, ç̌omə̌yinq'uzbaki zu bezi ömüri axıral śirik' əgər va tadi əyiti loxol nu çurk'ayiz. ");
INSERT INTO udi_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nu boxoybiynuy, isə p'ə̌ kərəm taśi hareyaniy!» ");
INSERT INTO udi_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","T'e vədə İsrailen izi ğarmoğo pine: «Əş ki me galane, barta efi uk'aloq'an baki. T'e vədə ekinan metər ben, me oç̌alen tadala baraxun girbanan bapanan efi xaralxoy boş, ən şaat'orox manunesa şot'oğoxun: şaat' adeğala c'əyin, uč', adeğala oyur q'a mət, ereq' q'a badam. Mot'oğo bitova t'e amdareynak' pay taşanan. ");
INSERT INTO udi_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Gümüşəxun isə p'ə̌ q'at ext'anan, şot'o görə ki, t'e dönə laxi tənginə taşeri q'ayst'une lazım, banekon sərf bakit'un laxiyo. ");
INSERT INTO udi_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","İsə hayzanan Binyaminal ext'anan takinan t'e amdari t'ǒğǒl. ");
INSERT INTO udi_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Barta Bitova Başarbala Buxačuğon və̌xun İzi şaat'luğa kammaq'anbi, t'e amdarenal cügübaki Simeona q'a Binyamina tərbeq'an ki, və̌nal efi viçimoğo ext'i qaybaki bito sagala bezi t'ǒğǒl eyes bakanan. Şuk'k'alen izi q'ısmat'axun avuzin ukes batenekon, bezi k'odoğo əylux aç̌espsun śameśenesa, mot'o badalbsun beşi kiyel tene. Ene k'ə bakalesa bakale». ");
INSERT INTO udi_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hametər, viçimoğon içoğoy həzirbi paya q'a lazımbakalt'uxun p'ə̌q'at gele tənginəl ext'i Misirə yaq'at'un baft'i. Binyaminal içoğoxuney. Şorox hari Misirə p'ap'ala k'inək' İosifi t'ǒğǒlt'un taśi. ");
INSERT INTO udi_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","İosifen Binyamina şot'oğoy t'ǒğǒl ak'at'an izi k'ojin əşurxo taşala nökərə pine: «Me amdarxo bezi k'oya taşa. Sa heyvan šampa ukunal həzirba, berezəre q'onağboz kot'oğo». ");
INSERT INTO udi_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nökəren içu pi k'inək'əl bine, şot'oğo haq'i taneśi İosifi k'oya. ");
INSERT INTO udi_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ama viçimoğo q'ı̌yene haq'i içoğo ext'i İosifi k'oya taşt'una avabakat'an, burt'unqi içoğoy arane metər upsa: «Mo t'e təngin exləte, miya süft'ə eğat'an beşi xaralxoy boş laxi gümüşə görət'un taşt'a yax me amdari k'oya! Yax oğriluği loxol taxsırkər c'evk'i t'ap'k'alt'un, oşal ext'i yax k'ul k'inək' izi loxol əşp'est'ale, beşi elemxoval bakale izi!» ");
INSERT INTO udi_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hari ç̌omoy tume p'ap'ala vədine viçimoğon İosifi k'ojin əşurxo taşala nökərə ı̌šalayinşaki pit'un: ");
INSERT INTO udi_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Bark'aynan və̌x sa əyityan upsun çuresa, beşi ağa. Yan efi ölkinə sa kərəm arumeynak' hareyan. ");
INSERT INTO udi_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Qaybakat'anal, üşe mandak'luğ haq'seynak' çurpi gala, beşi xaralxoy ç̌oya qaypi běyanği ki, yaxun təngə ext'itet'un, beşi eçeri gümüşi təngoox hetər eçereyan hat'etər çurpene, hərsunt'ayo izi xarali boş. Ama həysə eçereyan t'e tənginə yaxun, ");
INSERT INTO udi_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","me dəfin arumi tənginəl cöyyan eçere. T'e gümüşi təngoğo xaralxoy boş şine qaydi laxe beşi xavar buteyax». ");
INSERT INTO udi_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ama İosifi k'ojin əşurxo taşala nökəren qaybaki metəre pi: «Narahat ma bakanan, hik'k'al tene bakon. Efi Buxačuğoy əşe ko, efi bavan bul k'os'pala Buxačuğone qaydi laxi bakon t'e təngoğo xaralxoy boş, şot'o görə ki, zu bezi ext'alt'u ext'ez». Metər piyal taśi Simeona haq'i hare. ");
INSERT INTO udi_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Oşa şot'oğo k'oya badi içoğoy turmoğo os'kseynak' xeyal eneçeri, taşeri elemxo yemal tanedi. ");
INSERT INTO udi_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Viçimoğon isə, avabakat'an ki, İosifen berezəre k'oya hari içoğoxun sagala šum ukale, şo eğamin içoğoy eçeri payurxo c'evk'i həzirt'unbi. ");
INSERT INTO udi_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","İosif hare, viçimoğonal içoğoy eçeri payurxo tadi şot'ay běš biti bult'un k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","İosifen isə şot'oğo \"usumnan hare\" pi, bureqi içoğo xavar haq'sa: «Efi bava hetəre, pinan k'oya q'oja bavavə̌x bu? Hik'k'al tene bake, izi elmux izi boşe?» ");
INSERT INTO udi_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Şot'oğonal qaybaki \"vi k'ul bakala beşi bava xavar haq'suna görə dirist'baka, şaat'e, izi elmuxal izi boşe\" pi p'urum İosifi běš bult'un k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","İosifen izi běš çurpi viçimoğo piyexun c'ovakest'at'an běneği ki, izi mis'ik' viçi, içuxun nana sa bakala Binyaminal içoğoy t'ǒğǒle. Şot'in xavare haq'i: «Efi uk'ala mis'ik' viçi mone?» Oşa Binyamini loxol běği \"barta Buxačuğon vaxun İzi ük' bok'ospsuna kammaq'anbi, bez ğar\" pine. ");
INSERT INTO udi_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Metər piyal içu efes tene baki, c'eri t'iyə̌mi otağa taśi bureqi ǒnepsa. T'emane izi ük' bok'i Binyamina ak'i. ");
INSERT INTO udi_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Oşa izi ç̌oya os'k'i p'urum hare q'onağxoy t'ǒğǒl, içu kiyel haq'iyal \"isə ekinan šum uken\" pine. ");
INSERT INTO udi_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nökərxon šuma eçeri bitot'aynak' cöy-cöyt'un laxsay: İosifeynak' cöy, q'onağxoynak' cöy, t'iya bakala misirluğoynak'al cöy. Axıri misirluğon əbraniğoxun sagala arśi šum utet'unksa, şot'oğoxun sa sulfin bel arst'un içoğoy kul murdar sa şeya lafst'un k'inək'e hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Viçimoğo İosifi běš içoğoy yəşə görə t'etərt'un arśest'ey ki, hər soğo izi galaney - kalat'uxun burqi mis'ik't'ul śirik'. Viçimux me əşlə məət't'əl mandi sunay loxolt'un běğsa burqi, ");
INSERT INTO udi_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ama p'urumal mǔqt'uniy arśi İosifaxun sagala vaxt' c'ovakest'una. İosifen izi běš eğala ukunxoxun şot'oğoynak'al yaq'anebsay, ama Binyamini paya qo q'at gelene bsay. ");
INSERT INTO udi_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","İosifen izi k'ojin əşurxo taşala nökərə pine: «Me amdarxoy xaralxo içoğoy taşes bakala hama arumen buyba, ç̌oyexunal içoğoy eçeri gümüşi təngoğo qayda laxa. ");
INSERT INTO udi_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mis'ik' viçey xarali boş isə izi eçeri gümüşi təngoğoxun cöy bezi gümüşi camal laxa». Nökərenal İosifen pi k'inək' bine. ");
INSERT INTO udi_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Savaxt'an işiğ bitala k'inək' viçimoğo içoğoy elemxoval tadi tərt'unbi ki, taśeq'at'un. ");
INSERT INTO udi_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ama şorox hələ təzə şəhərexunt'un c'erey, İosifen izi əşurxo taşala nökərə metər pi yaq'anebi: «Hayza usum baft'a şot'oğoy bač'anexun, p'ap'ala k'inək'əl upa ki, het'u görənan və̌ynak' bi şaat'luğa ç̌axç̌uxp'i? ");
INSERT INTO udi_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bezi ağay cama het'u görənan başq'i taşt'a? İzi ǔğə̌lə camey ko, hamal fale běğsay kot'ay boş! Sal şaat' əş tenan biq'i və̌n!» ");
INSERT INTO udi_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","İosifi nökərenal taśi şot'oğo p'ap'i izi ağay tapşurbit'oğo uk'at'an ");
INSERT INTO udi_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","viçimoğon qaybaki içu metərt'un pi: «Ko hetər əyite nexnu, beşi ağa?! Sal ketər əş bit'unq'on me vi k'ulurxon? ");
INSERT INTO udi_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Yan beşi xaralxoy boş bə̌ğə̌bi gümüşi təngoğo exst'una yax p'aq'est'es teyan bake, şot'oğo qaydi Kənan oç̌alaxun eyançere vaynak'! İsə het'u görəq'an beşi pul vi ağay q'ızıli q'a gümüşi loxol baki? ");
INSERT INTO udi_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Beşi boşt'an sunt'ay kiyel vi uk'ala t'e cama bə̌ğə̌bayvax, sal mandimaq'an şo! Əfçiyan nexesa, barta yanal beşi ağaynak' k'ul baken!» ");
INSERT INTO udi_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nökəren pine: «Baneki, barta efi uk'ala k'inək'q'an baki. Ama cama şi kiyel bə̌ğə̌bayiz, şot'o zaynak' k'ul booz, mandit'oğoxun bezi əş butene». ");
INSERT INTO udi_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Viçimoğon eçeri kap içoğoy xaralxo śivk'i şot'oğoy ǰomo qayt'unpi, ");
INSERT INTO udi_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","İosifi nökərenal bureqi bitot'ay xaralxo soğo-soğo běğsa. Şot'in kalat'uxun burqi mis'ik't'ul śirik' bitot'ay xaralxo běneği, camal hari Binyamini xarali boşt'ane c'eri. ");
INSERT INTO udi_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Viçimoğoy bel ǰěne biti mot'o ak'at'an, içoğoy loxol bakala paltarat'un zığzığbi şot'oğon dərde kiyexun, xaralxo elemxoy loxol lapiyal şəhəret'un qaybakala baki. ");
INSERT INTO udi_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","İosif hələ k'oyaney İudan izi viçimoğoval ext'i şot'ay t'ǒğǒl eğat'an. Viçimux baśi şot'ay turin oq'a bit'unti, ");
INSERT INTO udi_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","İosifen isə metəre pi: «Və̌n əşlə biq'at'an fikirnanbsa sal k'əyan bsa mo, şi camayan başq'sa? Fala běği hər şeya avabakala amdarzu zu, mo c'ap' mandaley zaxun?!» ");
INSERT INTO udi_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","İudan pine: «K'ə uk'az, bezi ağa, əyitəl tez bə̌ğə̌bsa. K'ə pi yax təmizə c'evk'az? Anek'i Buxačuğon beşi biq'i əşurxo, isəəl hari c'enesa beşi běš. Vi k'ulyan yan meyin t'ağay - yanal, vi cam şi kiyel bə̌ğə̌yeśene şoval». ");
INSERT INTO udi_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","İudan metər uk'at'an İosifen pine: «Lazım tene baksa! Və̌x bitova miya efala fikir tezax bu! Bezi cam şi kiyel bə̌ğə̌yeśenesa, şot'o bezi k'ul booz, mandit'oğo isə tərezbsa, c'ekinan arxayin takinan efi bavay t'ǒğǒl». ");
INSERT INTO udi_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","T'e vədə İudan İosifa ı̌šalayinşaki pine: «Vi əcuğon nu biq'ayin me vi k'ulen sa əyite uk'on, bezi ağa, axıri faraoni běš çurpi k'inək'zu həysə zu. ");
INSERT INTO udi_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Vi eyexe bakon, bezi ağa, yaxun xavaren haq'i ki, efi bava nəəl q'erəzəl sa viçi buvə̌x?! ");
INSERT INTO udi_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Yanal piyan, q'oja sa bavayax bu saal sa mis'ik' viçi. Piyan beşi bava q'ojabakit'uxun oşa baki əyele şo, bavanal izi piin işiğ k'inək'e běğsa şot'o. Me əyel beşi p'uri viçey nanan eçeri əyel baksunal piyan, me p'ə̌ ğaraxun q'erəz əyel tene bakey şot'ay. ");
INSERT INTO udi_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Hunal yax qaybaki pinu ki, efi t'e viçə bezi t'ǒğǒl eçanan şot'o bezi piin ak'az. ");
INSERT INTO udi_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yanal va piyan ki, beşi ağa, bavaxun cöybes bateyankon beşi t'e viçə, biyone şo izi mis'ik' ğara izi t'ǒğǒlxun tərbayin. ");
INSERT INTO udi_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ama hun ten cügübaki, me vi k'ulurxo pinu ki, efi viçə nu eçaynan ma ak'eynan bezi piyes. ");
INSERT INTO udi_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yanal, bezi ağa, k'oya taśit'uxun oşa vi pit'oğoy bitova p'ap'esyanbi vi k'ul bakala beşi bava. ");
INSERT INTO udi_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Oşa sa ği, beşi bavan ukat'an ki, takinan p'urum arum haq'i eçanan, ");
INSERT INTO udi_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","piyan mis'ik' viçə yaxun nu taşayan, t'iya beş əş tene bu. Yax t'e amdaren pene ki, efi viçə nu eçaynan, bezi piyes ma ak'eynan. ");
INSERT INTO udi_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","T'e vədə vi k'ul bakala beşi bavan metəre pi: \"Bakalo p'ə̌ ğarzax bu bezi Raxiləxun, ");
INSERT INTO udi_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","şot'ayal soğo p'urene. Ə̌qnə heyvanxoynak' yeme baki pi, şot'oxun oşa bezi ğare ç̌oya tez ak'i zu. ");
INSERT INTO udi_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","İsəəl nexnan, mot'oval tada taşalyan. Bezi me ğaral k'ənesa bakayin k'əz bon zu? Ene upanan taşeri oç̌alaxyanpsa va, me yəşt'ə ke dərdə portp'ala ük' tezax bu bezi!\" ");
INSERT INTO udi_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","İsə hun upa, zu me əyitmoğoxun oşa hetərez běğon bezi bavay ç̌oyel Binyamina miya efi tağayiz? Vi k'ul bakala beşi bavay piin işiğe izi mis'ik' ğar, ");
INSERT INTO udi_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ak'ayin ki, şot'o efiyan hare - biyale. Nexnu taşen beşi kiin laxen şot'o k'ule oq'a? Q'ojabakene vi k'ul bakala beşi bava, tene portp'al şo ke dərdə. ");
INSERT INTO udi_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Zuz ext'ey bezi mis'ik' viçə qaydi bavay t'ǒğǒl eşt'una bezi ozane. Me vi k'ulen əyite tade izi bava, pezu vi ğare mux k'oribakayin ç̌omə̌yinq'uzbaki zu vi běš bezi ömüri axıral śirik'. ");
INSERT INTO udi_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Həysə şot'o görəz vi t'ǒğǒl ǰomo ə̌mbsa, bezi ağa! Va xoyinšezbsa, barta bezi mis'ik' viçey gala zu çurk'az memiya, tərba şot'o taśeq'an izi viçimoğoxun k'oya. ");
INSERT INTO udi_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Axıri mani ç̌oyenez qaybakon zu bavay t'ǒğǒl bezi mis'ik' viçə miya efi?! Buxačuğon maq'an ak'est'i za bezi bavay pis ğina!» ");
INSERT INTO udi_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","İosifen běneği ki, ene içu efes tene baksa, haraypi bito nökərxo c'evek'i otağaxun. Şot'in izi şu baksuna viçimoğo uk'at'an şot'oğoy t'ǒğǒl içoğoxun q'erəz şuk'k'al tene buy. ");
INSERT INTO udi_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ama İosifen t'etəre hönkür-hönkür ǒnepi ki, bitot'in inebaki şot'ay ǒneni səsə, lap faraoni sarayal şot'ay ǒnenaxunt'un əyitey. ");
INSERT INTO udi_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","İosifen izi viçimoğo \"zu İosifzu! Hetəre bezi bava həysə?\" uk'at'an şorox haq'eśi mant'undi, içoğoy ǰomo ə̌mbi əyit pes tet'un baksay. ");
INSERT INTO udi_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","T'e vədə İosifen saal əyitpsa burqi pine: «Sa bezi t'ǒğǒl ǐša ekinan». Viçimuxal şot'o ı̌šalayinşakat'an İosifen pine: «Mone, efi viçi İosifzu zu, efi tənginen toydi Misirə yaq'abi İosif! ");
INSERT INTO udi_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ama pis ma bakanan za toyst'una görə, mot'o və̌ynak' dərd ma banan. Buxačuğoy əşey mo, Şot'ine za və̌xun běš miya yaq'abi ki, amdarxo busaluğaxun çark'est'az. ");
INSERT INTO udi_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","P'ə̌ usene ki, busaluğen haq'layinşene tanesa bito ganu, hələ qo usenal me oç̌alxo nə ezteneğal, nə exteneğal. ");
INSERT INTO udi_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ama Buxačuğon za və̌xun běš yaq'anebi ki, efi tum maq'an əfçibaki me oç̌ali ç̌oyexun, za yaq'absunast'ane ak'i Şot'in efi çark'esuna. ");
INSERT INTO udi_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Efi təə, Buxačuğoy əşe za miya yaq'absun! Şot'ine za eçeri faraoni yön kul bi, me ölkin padçaği k'ojin kaloz baki zu, bezi əyite c'ovaksa me oç̌ala. ");
INSERT INTO udi_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","İsə ibakanan k'əz nex: takinan bezi bava upanan ki, İosifen nexe Buxačuğon za dirist' Misiri kalone be. Upanan içal hayzeri usum bezi t'ǒğǒlq'an hari, ");
INSERT INTO udi_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","miya Goşen uk'ala oç̌ala, za ǐša yəşəyinşale. İçal, izi əyluxal, izi nəvooxal, izi sürünə bakala heyvanxo, izi k'ə bunesa bitova ext'i hareq'an miya. ");
INSERT INTO udi_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Şot'o t'etər běğoz ki, nə için, nə izi külfəten hik'k'alaxun koruğ tene zap'k'al, izi sürünə bakala heyvanxoy q'a izi t'ǒğǒl bakala amdarxoyal boşşamin ukun bakale. Tene, gele çətinluğ ak'alt'un, şot'o görə ki, me busaluğen hələ qo usenal zap'k'ale. ");
INSERT INTO udi_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ananksa za? Anksa za, Binyamin? Zuzu mo, ay viçi, İosife və̌x həysə me əyitmoğo uk'alo! ");
INSERT INTO udi_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","İsə takinan miya ak'it'oğo q'a bakit'oğo bitova bava upanan, barta avabakeq'an Misirə bezi hetər sa s'iye q'ončux baksuna, haq'anan ekinan bezi bava miya». ");
INSERT INTO udi_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Oşa İosifen izi viçi Binyamina q'ujbi bureqi ǒnepsa, Binyaminenal şot'one q'ujbi ǒneney. ");
INSERT INTO udi_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","İosifen viçimoğoy bitova q'ujbi muçepi, şot'in izi piin neğa efes tene baksay. Viçimoğoyal muze qayeśi, arśi burt'unqi İosifaxun exlətpsa. ");
INSERT INTO udi_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","İosifi viçimoğoy eysuni xavar taśi faraoni sarayal p'anep'i, faraonen q'a izi sarayi amdarxonal mot'o pis tet'un běği. ");
INSERT INTO udi_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraonen İosifa pine: «Vi viçimoğo upa ki, heyvanxoval yükləyinşi Kənan oç̌alaq'at'un taśi, ");
INSERT INTO udi_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","barta taśi vi baval, içoğoy külfətəl haq'i hareq'at'un miya. Misirə ən bərəkətlu, heyvanxo otarişbseynak' ən şaat' oç̌alxo manunesa, şot'oğoy bakale, hik'k'alaxunal koruğ tet'un zap'k'al. ");
INSERT INTO udi_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Şot'oğo upa içoğoxun memiin elemxon c'idi taşala arabooxal taşereq'at'un ki, eğat'an çupuxxo q'a əyloğo eşt'un hasandq'an baki. Əmirba taśi vi bava haq'i hareq'at'un. ");
INSERT INTO udi_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Eğat'an içoğoy pul qoş maq'an mandi, Misiri oç̌alen tades bakalt'oğoy ən şaat'o manunesa, içoğoy bakale». ");
INSERT INTO udi_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","İsraili ğarmoğonal içoğo pi k'inək' bit'un. İosifen faraoni əyitəxun nu c'eri izi viçimoğo arabooxe tadi, yaq'eynak' šume laxi. ");
INSERT INTO udi_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Şot'in hərt'u sa q'at paltaral tanedi, Binyamini paya isə avuzbi qo q'ate bi, hələ izi loxolxun xibbaç̌ dənə gümüşi təngəl lanexi. ");
INSERT INTO udi_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","İosifen bavaynak'al payure yaq'abi: vis' dənə ərkəy elemi loxol Misiri oç̌alen tadala ən şaat' neymətxoxune lapi, vis' dənə dişi elemi loxol isə arum, mu saal qaybakat'an yaq'a q'erəz k'ə lazımesa şot'oğo. ");
INSERT INTO udi_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Oşa viçimoğo \"isə takinan, və̌xal yaq'a běğanan\" pi yaq'anebadi. ");
INSERT INTO udi_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hametər, viçimux Misirəxun c'ert'un, hariyal Kənan oç̌ala, içoğoy bava İak'ovi t'ǒğǒl p'ap'i ");
INSERT INTO udi_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","bitova şot'aynak' exlətt'unbi. Şot'oğon \"İosif dirist'e, Misiri kalone bake şo!\" uk'at'an İak'ovi male mandi ük' çurk'ane, věbakes tene baksay mot'o. ");
INSERT INTO udi_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ama ğarmoğoy ǰomoxun İosifi pit'oğo bitova ibaki, şot'ay içu taşt'eynak' yaq'abi araboğo izi piin ak'at'an İak'ovi ük'e qayeśi. ");
INSERT INTO udi_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","T'e vədə metəre pi İsrailen: «Bəsebaki za bezi ibakiyorox q'a ak'iyorox! Dirist'e bezi ğar, tene p'ure bezi İosif! Ekinan tağen, hələki bezi elmux bezi boşe, taśi ak'oz bezi ğara». ");
INSERT INTO udi_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","İsrailen izi k'ə bunesa bitova girbi yaq'ane baft'i, hariyal Beer-Şevina p'ap'i miya izi bava İsaak'en bul k'os'p'ala Buxačuğoynak' q'urbanxone šampi. ");
INSERT INTO udi_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Buxačuğon isə üşe şot'ay nep'e boş baśi pine: «İak'ov! İak'ov!» İak'ovenal qaybaki \"izbaksa\" pine. ");
INSERT INTO udi_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Oşa Buxačuğon metəre pi: «Zu Buxačuxzu, vi bavayal bul k'os'p'i Buxačux. Q'ǐmaba, arxayin taki Misirə, Zu t'etər booz ki, vaxun kala sa azuk' törəyinşakale t'iya. ");
INSERT INTO udi_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Zu vaxun bakoz: va t'iya taşoz, oşa Bezi kiinal qaydi c'evk'oz t'et'iin vaxun törəyinşakit'oğo. Vi t'ǒğǒl bakale İosif hun vi pula q'ic'p'i t'e dünyəne tağat'an». ");
INSERT INTO udi_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Mot'oxun oşa İak'ov arxayin baki p'urum yaq'ane baft'i. İsraili ğarmoğon içoğoy bava saal əyloğo q'a çupuxxo faraonen yaq'abi araboğo arśest'it'un taşt'ay, ");
INSERT INTO udi_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","içan isə heyvanxot'un c'idi taşt'ay. Hametər, İak'oven izi külfətəl, Kənan oç̌ala q'azayinşi girbit'oğoval bitova ext'i Misirəne köçp'i. ");
INSERT INTO udi_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","İak'oven izi ğarmoğo q'a ğar nəvoğo, xuyərmoğo q'a xuyər nəvoğo - izi cınsaxun bakalt'oğoy bitova ext'ine köçp'ey Misirə. ");
INSERT INTO udi_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Moval İak'ovaxun bakit'oğoy, Misirə köçp'i, oşal israilluyox uk'ala azuk'i əmələ eysuna bulbit'oğoy siyəyi. İak'ov içal me siyəyin boşe. İak'ovi kala ğar Ruvenaxun burqen. ");
INSERT INTO udi_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruveni ğarmux: Xanok', P'allu, Xeśron saal K'armi. ");
INSERT INTO udi_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeoni ğarmux: Yemuel, Yamin, Oxad, Yak'in, Sohar saal kənanlu çuğoxun baki Şaul. ");
INSERT INTO udi_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levin ğarmux: Gerşon, K'ohat' saal Merari. ");
INSERT INTO udi_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","İuday ğarmux: Er, Onan, Şela, P'ereś saal Śerax. Er q'a Onan hələ Kənan oç̌ala bakat'an p'uret'uniy. P'ereśi isə p'ə̌ ğare buy: Xeśron q'a Xamul. ");
INSERT INTO udi_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","İssak'ari ğarmux: T'ola, P'uva, Yov saal Şimron. ");
INSERT INTO udi_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zevuluni ğarmux: Sered, Elon saal Yaxleel. ");
INSERT INTO udi_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Morox İak'ovi Leaxun baki ğarmoğoxun törəyinşakiyoroxey. Lean me ğarmoğo q'a Dina uk'ala xuyərə P'addan-Arama bakat'ane eçerey. İak'ovi me ğarmoğo q'a içoğoxun törəyinşakit'oğo bitova sagala ext'at'an otuz xib tane bsay. ");
INSERT INTO udi_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gade ğarmux: Śifyon, Haggi, Şuni, Eśbon, Eri, Arodi saal Areli. ");
INSERT INTO udi_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aşeri ğarmux: İmna, İşva, İşvi, Beria saal içoğoy xunçi Serah. Beriay ğarmux: Xever q'a Malk'iel. ");
INSERT INTO udi_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Morox İak'ovi Zilp'axun, Lavanen izi xuyər Leay bač'anexun tadi nökərəxun baki ğarmoğoxun törəyinşakiyoroxey. İak'ovi me ğarmoğo q'a içoğoxun törəyinşakit'oğo bitova sagala ext'at'an ǔqěs's'e tane bsay. ");
INSERT INTO udi_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","İak'ovi Raxiləxun baki ğarmoğoy s'i İosif q'a Binyaminey. ");
INSERT INTO udi_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","İosif Misirə bakat'an On şəhəri běyinš P'ot'iferani xuyər Asenat'en şot'aynak' p'ə̌ ğare eçeri: Menaşşe saal Efraim. ");
INSERT INTO udi_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Binyamini ğarmux: Bela, Bek'er, Aşbel, Gera, Naaman, Exi, Roş, Mup'p'im, Xup'p'im saal Ard. ");
INSERT INTO udi_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Morox İak'ovi Raxiləxun baki ğarmoğoxun törəyinşakiyoroxey. İak'ovi me ğarmoğo q'a içoğoxun törəyinşakit'oğo bitova sagala ext'at'an bip'es's'e tane bsay. ");
INSERT INTO udi_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dane sa ğare buy, iz s'i Xuşim. ");
INSERT INTO udi_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naft'alini ğarmux: Yaxśeel, Guni, Yeśer, Şillem. ");
INSERT INTO udi_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Morox İak'ovi Bilhaxun, Lavanen izi xuyər Raxiləy bač'anexun tadi nökərəxun baki ğarmoğoxun törəyinşakiyoroxey. İak'ovi me ğarmoğo q'a içoğoxun törəyinşakit'oğo bitova sagala ext'at'an vǔğ tane bsay. ");
INSERT INTO udi_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Binxoxun cöy, İak'ovaxun sagala Misirə hari ğarmoğoy q'a şot'oğoxun törəyinşakit'oğoy say bito sagala altmış ǔq taney. ");
INSERT INTO udi_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","İosifi Misirə baki p'ə̌ ğaral ext'at'an İak'ovaxun törəyinşakit'oğoy say bito sagala yetmiş tane bsay. Mo İak'ovaxun sagala Misirə köçp'i harit'oğoy sayey. ");
INSERT INTO udi_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Hametər, İak'oven izi k'ə bunesa girbi Kənan oç̌alaxun c'ere, hariyal Misirə p'ap'ala vədine İuda běš yaq'anebi ki, taśi İosifaxun Goşen uk'ala ganu tağala yaq'a avabakeq'an. Şorox hari Goşena p'at'unp'i, ");
INSERT INTO udi_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","İosifenal mot'o avabakala k'inək' izi arabina ěka ğaç̌p'est'i içal t'iya taneśi ki, izi bavay běš c'eğale. Hariyal izi bava İsraila ak'at'an şot'o boxoy q'ujbi bureqi ǒnepsa. ");
INSERT INTO udi_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","T'e vədə İsrailen metəre pi: «Həysə va dirist' azk'i - mo za bəse, ene za k'ulen exedon». ");
INSERT INTO udi_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Oşa İosifen izi viçimoğo q'a bavaxun sagala harit'oğo bitova pine: «Həysə faraoni t'ǒğǒl tağoz, taśi şot'o uk'oz ki, bezi bavan izi külfətəl girbi Kənan oç̌alaxun miya, bezi t'ǒğǒle hare. ");
INSERT INTO udi_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Şot'o efi heyvan běğsuna, efi sürüğo q'a k'ə buvə̌xsa bitova ext'i eysunal uk'oz. ");
INSERT INTO udi_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Faraonenal və̌x izi t'ǒğǒl k'alpi \"efi əşlin s'i hik'ə\" pi xavar haq'at'an ");
INSERT INTO udi_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","upanan heyvanyan běğsa. Şot'o metər upanan: \"Yan, me vi k'ulurxon, beşi pula qaypeyan ki, heyvanyan běğsa, mo hələ beşi bavoğoy döörəxun metəre bake, həysəəl haketəre\". Metər uk'aynan, və̌x hame Goşen oç̌alal arśevk'ale, şot'o görə ki, misirluğoynak' heyvan běğalxo ı̌ša bist'un içoğoy kul murdar sa şeya lafst'un k'inək'e hesabbaksa». ");
INSERT INTO udi_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Hametər, İosif hayzeri faraoni t'ǒğǒl taśi pine: «Bezi bavan q'a viçimoğon içoğoy sürüğo bakala heyvanxo saal içoğoy k'ə bunesa bitova girbi haret'un miya, həysəəl Goşen oç̌alat'un». ");
INSERT INTO udi_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Şot'in izi viçimoğoy boşt'an qoarat'u c'ək'p'i şot'oğo faraoni běše c'evk'i. ");
INSERT INTO udi_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faraonenal şot'oğoxun \"efi əşlin s'i hik'ə\" pi xavar haq'at'an viçimoğon pit'un: «Me vi k'ulurxoy əş heyvan běğsune, mo hələ beşi bavoğoy döörəxun metəre bake. ");
INSERT INTO udi_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hareyan samal vədə miya bakayan, şot'o görə ki, Kənan oç̌ala busaluğen haq'ene tanesa. Me vi k'ulurxon içoğoy heyvanxo otarişbseynak' gaal tet'un bə̌ğə̌bsa həysə t'iya, oç̌ali ç̌oyel o uk'ala şey tene bu. Həysəəl şot'o görəyan vi t'ǒğǒl hari ǰomo ə̌mbsa, barta me vi k'ulurxo taśi Goşen oç̌ala arśeq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraonen İosifa pine: «İsə ki vi bava q'a viçimux vi t'ǒğǒlt'un köçp'i hare, ");
INSERT INTO udi_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","mo Misiri oç̌al, mo və̌n! Taşa vi q'oomxo içoğoy heyvanxo otarişbseynak' ən şaat' ga manunesa, hat'iya arśest'a. Barta taśi Goşen oç̌ala arśeq'at'un. Saal ibaka k'əz nex: içoğoy boşt'an izi əşlə şaat' avabakalorox manunesa, şot'oğoxun c'ək'p'a, taśi bezi sürüğoval běğeq'at'un». ");
INSERT INTO udi_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Oşa İosifen izi bavane eçeri faraoni t'ǒğǒl, İak'ovenal faraoni běš bul k'os'p'i \"xeyirq'an baki\" pine. ");
INSERT INTO udi_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraonen İak'ovaxun xavare haq'i: «Hema yəşvax bu?» ");
INSERT INTO udi_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","İak'ovenal qaybaki metəre pi: «Sabaç̌ otuz yəşzax bu, şot'ay gele payal çətinluğ q'a q'əribluğ zapsunen c'ovakest'una hesabbayin mo hik'k'al tene. Bezi bavoğoy yəşə hari p'ap'itez hələ». ");
INSERT INTO udi_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hame exləte baki, İak'oven p'urumal faraoni běš bul k'os'p'i sarayaxun c'ere. ");
INSERT INTO udi_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","İosifen faraonen əmirbi k'inək'əl bine, taşeri izi bava q'a viçimoğo Misiri Ramses uk'ala bölginə ən şaat' ganxo manunesa şot'oğo tadi, hat'iyal arśevek'i. ");
INSERT INTO udi_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","İosifen izi bava, viçimoğo, bavaxun sagala hari şu bunesa, bitot'u ukunal tanedi. Hərt'in izi külfəti boş bakala amdari saya görə ukune haq'i. ");
INSERT INTO udi_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Busaluğen isə taysun gelene haq'layinşbsay, sal sa galal arum tene buy. Misir q'a Kənan oç̌al t'e ğinaxey ki, amdarxon içoğoy ukala šuma tet'un bə̌ğə̌bsay. ");
INSERT INTO udi_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ene şuk'k'ali kiyel təngəl tene buy, bitova İosifaxun arum haq'i çark'est'et'uniy. İosifen isə amdarxo arum toydi girbi me təngoğo bitova taşeri faraoni xəzninəne laxsay. ");
INSERT INTO udi_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Misirə q'a Kənan oç̌ala ene təngə uk'ala şey nu mandat'an misirluyox gireśi İosifi t'ǒğǒl hari pit'un: «Yax arum tada! Atenksa busa k'as'yansa? Ene təngəl teyax bu ki, haq'ayan». ");
INSERT INTO udi_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","T'e vədə İosifen metəre pi: «Təngə çark'iyal bakayin, efi sürüğo heyvan ki bune? Şot'oğo eçanan miya, zuval və̌x izi gala arum tadoz». ");
INSERT INTO udi_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Amdarxonal burt'unqi içoğoy heyvanxo eçeri izi gala arum exst'a. Ěk, eğel, beli, keçi, elem - k'oya k'ə heyvan bune haq'i et'unsay. Hametər, amdarxon t'e usenal c'ovakest'undi, İosifen şot'oğoy eçala heyvanxoy gala arum tadi şot'oğo busa tene efi. ");
INSERT INTO udi_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Sa usen hametər c'ovaneki, oşa amdarxo p'urum hayzeri hart'un İosifi t'ǒğǒl. Şot'oğon pit'un: «Vaxun k'ə c'ap'p'en, beşi ağa, hunal avanu ki, nə təngə teyax bu, isə ene heyvanal teyax bu. Beşi bakalt'u va tadi izi gala arumyan haq'e. İsə mone, həysə va arumi gala tades bakala saycə oç̌alxoyax bu saal beşi q'ari elmux. ");
INSERT INTO udi_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Het'u görə busa k'as'eğen? Het'u görəq'an beşi oç̌alxo əfçibaki taśi? Ext'a beşi oç̌alxo viq'an baki, yanal izi gala vi loxol sa tapan šumal əşp'en. Barta vi yax tadala arumi gala faraoneynak' k'ul baken, beşi oç̌alxoval ene iziq'an baki. Saycə beşi śilluğ aruma kammaba ki, nə yan busa ma manden, nəəl beşi oç̌alxo xam ganu maq'an c'ureśi». ");
INSERT INTO udi_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","İosifen haketərəl bine, Misirə bakala oç̌alxoy bitova haq'i faraoni oç̌ale bi. Busaluğen amdarxo t'e ğinane badey ki, izi oç̌ala İosifa nu toydi amdar tene mandi Misirə. Hametər, oç̌alxoy bito baneki faraoni, ");
INSERT INTO udi_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ölkinə bakala amdarxoval, me belxun t'e bel şu bune bito, baneki faraoni k'ulurxo. ");
INSERT INTO udi_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","İosifen saycə běyinšxoy oç̌alxo ext'es tene baki, faraonen şot'oğoy paya kamtenebsay pi busa tet'un manst'ay. Faraoni xəzninəxun eğala tənginen yaq'axt'un taysay, şot'o görəl t'et'un toydi içoğoy oç̌alxo İosifa. ");
INSERT INTO udi_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","İosifen amdarxo metəre pi: «Mone, efi oç̌alxo haq'i faraonaz tadi, və̌xal şot'ay k'ulez bi. Sa tapan šumal əşp'alnan və̌n meyin oşa. Ext'anan me śilluğ aruma, taşanan bit'anan. ");
INSERT INTO udi_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Exp'ala vədine arumi qo paye sunt'u faraona tadalnan, mandiyo isə efi bakale. T'et'iin ham śilluğnan ext'on, hamal efi əyloğoy q'a külfəti ǰomonan girbon». ");
INSERT INTO udi_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Amdarxonal qaybaki İosifa metərt'un pi: «Beşi piin loxol gavax bu, beşi ağa! Metər bi vi piyes şaat' ak'eğalyansa, yan faraoneynak' k'ul baksuna irəziyan, beşi elmoğon çark'est'i hun!» ");
INSERT INTO udi_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","İosifi laxi me k'anun Misirə həysəəl əşesa: exp'i arumi qo paye sunt'u faraonat'un tast'a. Běyinšxon isə içoğoy oç̌alxo faraona tet'un toydey pi şot'oğoynak' me k'anun butene. ");
INSERT INTO udi_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Hametər, İsrailaxun törəyinşakiyorox Misirə, İosifen içoğo arśest'i Goşen uk'ala oç̌alat'un yəşəyinşbsa burqi. Şot'oğon miya tum saki avuzt'unbaki, içoğoy sayal taysun gelenebaksay. ");
INSERT INTO udi_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","İak'oven Misirə vǔğes's'e usene yəşəyinşi, biyat'anal izi sabaç̌ q'ırx vǔğ yəşe buy. ");
INSERT INTO udi_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Hari lap q'ojabaki vədine şot'in İosifa izi t'ǒğǒl k'alpi pine: «Əgər bezi xətirə çurensasa, vi kula bezi c'ile loxol laxi za əyit tada: elasp'a ki, bezi həysə va uk'alt'oğo balnu. Zaxun vi şaat'luğa kammaba - za me Misiri k'ulnu ma oç̌alaxp'a! ");
INSERT INTO udi_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bezi pula q'ic'p'i t'e dünyəne tağat'an za taşa bezi bavoox oç̌alaxeśi gala oç̌alaxp'a, za miya ma efa». İosifenal qaybaki \"arxayin baka, vi pi k'inək' booz\" pine. ");
INSERT INTO udi_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ama İak'oven saal pine: «Elasp'a!» İosifen elasepi, İak'ovenal hat'e izi bask'i gala tikbaki Buxačuğo bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sa heq'ədər vədə c'ovakit'uxun oşa İosifa hari pit'un ki, vi bava azarine. İosifenal izi p'ə̌ ğara - Menaşşena q'a Efraima ext'i izi bavay t'ǒğǒle taśi. ");
INSERT INTO udi_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","İak'oven ibakat'an ki, izi ğar İosife hare, izi axırınci zora laxi hayzeri gane boş areśi, ");
INSERT INTO udi_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","oşal İosifi loxol běği pine: «Zu hələ Kənan oç̌ala bakat'an Bitova Başarbala Buxačuxe za ak'eśi Luza. Şot'in za xeyir-bərəkət tadi ");
INSERT INTO udi_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","pine ki, avuzboz va Zu. Pine vaxun əmələ eğalt'oğoy saya t'eq'ədər booz ki, bǒq'ə̌lpi çark'est'es tene bakal şot'oğo, millətxo törəyinşakale vaxun. P'ə̌bulla şot'oğoy bakale pine Kənan oç̌al. ");
INSERT INTO udi_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","İsə ibaka k'əz nex: vi hələ zu miya eğamin baki ğarmoğo - Efraima q'a Menaşşena ğarluğaz exst'a. Şorox ene bezi ğarmux hesabbakale, Ruven q'a Simeon hetər, şoroxal hat'etər. ");
INSERT INTO udi_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Vi şot'oğoxun oşa baki ğarmux isə vine, şot'o görə içoğo koft'ala oç̌alal me bezi ğarluğa ext'i viçimoğoy paynuxun bakale. ");
INSERT INTO udi_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Avanu hun bezi dərdə, p'ure yaq'a bezi Raxilə zu P'addanaxun Kənan oç̌ala qaybakat'an. Hat'iya, Efrat'a tağala yaq'e börinez oç̌alaxp'i zu şot'o». T'e gane s'iya həysə Bet'lexemt'un nex. ");
INSERT INTO udi_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","İsrailen İosifi t'ǒğǒl ğarmoğo ak'i xavare haq'i: «Morox şuva?» ");
INSERT INTO udi_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","İosifenal qaybaki \"bezi ğarmuxe, Buxačuğon za memiya tadi ğarmux\" pine. T'e vədə İsrailen metəre pi: «Bezi t'ǒğǒl ǐša eça vi ğarmoğo, xeyir-bərəkət tadoz kot'oğo». ");
INSERT INTO udi_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","İsrail t'ema q'ojabakeney ki, izi pulmoğon pes banekon tene c'ək'ey. İosifen əyloğo ǐšanebi, İsrailenal izi nəvoğo q'ujbi muçepi. ");
INSERT INTO udi_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Şot'in İosifa pine: «Bezi sal va aksuna umud tezax buy, ama mone, Buxačuğon za vi əyloğo aksunal q'ısmatebi». ");
INSERT INTO udi_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","İosifenal ğarmoğo izi bavay q'ujelxun ext'i oç̌ala p'ap'amin bule k'os'p'i. ");
INSERT INTO udi_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Oşa İosifen ext'i Efraima izi yön tərəf, Menaşşena isə izi tərs tərəf çurdesedi ki, İak'oven izi kula boxodat'an Efraim izi tərs kiin oq'a, Menaşşe isə izi yön kiin oq'aq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ama İsrailen p'urumal izi kulmoğo tərse boxodi, ext'i izi yön kula İosifi mis'ik' ğar Efraimi bel, tərs kula isə kala ğar Menaşşeni bele laxi. ");
INSERT INTO udi_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Şot'in İosifa me əyitmoğo pi xeyir-bərəkəte tadi: «Bezi bavoğon qə̌veğala Buxačux, Avrahami q'a İsaak'i Buxačux beziyal Buxačuxe! Şo həmişə, ğeyin ğinal śirik' za bəsləyinşi běğiyone, hetər ki sa çobanen izi sürünə bəsləyinşi běğane. ");
INSERT INTO udi_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","İsə barta za bito pisluğxoxun q'orişi me Angelen vi əyloğoval xeyir-bərəkətq'an tadi. Zaxun törəyinşakiyoroxe korox, bezi bavoğoy - Avrahami q'a İsaak'i nəsil pi çalxalt'un kot'oğo. Bǒq'ə̌lpi çark'est'es tene bakal ke əyloğoxun törəyinşakit'oğo, avuzbaki buybalt'un kot'oğon me oç̌ala». ");
INSERT INTO udi_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","İosifen ak'at'an ki, bavan izi yön kula Efraimi bele laxe, pene p'oy şo sərfebake. Kula ext'i Menaşşeni bel laxsun çureśi ");
INSERT INTO udi_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","pine: «Düz ten laxe, bava, bezi kala ğar mone, Menaşşeni bel laxa vi yön kula». ");
INSERT INTO udi_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ama bavan qaybaki metəre pi: «Avazu, bezi ğar, avazu. Menaşşenaxunal kala sa millət törəyinşakale, ama izi mis'ik' viçi içuxun üst'ün bakale: Efraimaxun törəyinşaki millətxoy say lap gele bakale». ");
INSERT INTO udi_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Metər piyal İsrailen t'e ği izi nəvoğo xeyir-bərəkəte tadi: «Xeyir-bərəkətin k'ə baksuna və̌st'a ak'alt'un İsrailaxun törəyinşakit'oğon, sunt'u xeyir-bərəkət tast'un çureğat'an \"Efraim q'a Menaşşe k'inək' bakanan\" uk'alt'un». Hametər, İsrailen Efraimi s'iya Menaşşenaxun běš duği şot'ay ganu izi kala viçəxun bı̌hine bi. ");
INSERT INTO udi_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Oşa İsrailen İosifa pine: «Zaynak' male mande, ama Buxačux dim və̌xun bakale, və̌x qaydi efi bavoğoy oç̌ala taşale. ");
INSERT INTO udi_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Saal ibaka k'əz nex: vi pay vi viçimoğoy payaxun avuzin bakale - zu emorluğoxun davabi haq'i oç̌ala, Şekem uk'ala ganuval vaz tast'a. Barta t'e oç̌al vi viçimoğoy təə, viq'an baki». ");
INSERT INTO udi_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","İak'oven ğarmoğo izi t'ǒğǒl eçest'i pine: «Ekinan çurpanan miya bezi hərrəmine, həysə exlətp'oz və̌ynak' efi bel k'ə eğalesa bitova. ");
INSERT INTO udi_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ekinan gireynan bezi bel, ay İak'ovi ğarmux, efi ǔmǔxxo qaypanan ibakanan efi bava İsrailen k'ə nex: ");
INSERT INTO udi_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruven, kalo hunnu bezi əyloğoy boş, Bezi hetər sa zore q'ončux baksunan ç̌oyel c'evk'i hun, Bavaluği t'adaz avabaki zu hun nanaxun bakat'an. Bǐhine vi ga, şuk'k'alenal va sakes batenekon. ");
INSERT INTO udi_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ama efes ten baki hun va, posp'i tağala xena efes nu bakala k'inək', Vi bavaynak' çuuxluğbalt'uxunen bask'i, Bezi ganun murdarlayinşi hun. Şot'o görəl meyin oşa k'ojin kala ğar uk'at'an vi s'i tene t'ap'eğal. ");
INSERT INTO udi_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon q'a Levi - p'ə̌ viçit'un şorox, Q'əddarluğbseynak't'un əşp'est'i şot'oğon içoğoy q'ılıncxo. ");
INSERT INTO udi_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Sa tene bakal bezi əyit şot'oğoxun, Gərtezbakal zu şot'oğo. Əcuğon biq'i amdar besp'alorox, Arak'xoy tura kütp'i, oşal içoğoy biq'i əşlin loxol axšumk'aloroxe şorox. ");
INSERT INTO udi_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Q'arğişi q'ončuxe bi və̌x efi me əcuğon q'a hirsen, Śarpi śik'ala əcuğ, duği besp'ala hirse şo! Aç̌i batk'alnan və̌n İak'ovaxun törəyinşakit'oğoy boş, İsraili ğarmoğoy t'ǒğǒl arśala bakalnan. ");
INSERT INTO udi_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","İuda, vi s'iya duğalt'un viçimoğon alxışp'at'an, Ozana c'urumpi bosalnu hun vi düşmənxoy, Vi bavaxun sa viçimoğonal hari va bač'an k'os'p'alt'un. ");
INSERT INTO udi_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ǒxə̌ləxun qaybakala sa cəyil aslan k'inək'nu hun, İuda, Busq'una çurpi şirəst'a bakala zore bu vast'a, Şuva ı̌ša bites bakon me aslana? ");
INSERT INTO udi_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Padçağluğbale İudaxun bakit'oğon həmişə, Taxt'e loxol arśi əmirbalt'un şot'oxun törəyinşakit'oğon. Eğale t'e taxt'e q'ončux, Hariyal bul k'os'p'alt'un Şot'o oç̌ali ç̌oyel bakala millətxoy bitot'in. ");
INSERT INTO udi_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","C'ap'axun ğaç̌k'ale şot'in izi elema, Zorapalayinşi taymoğoy ən şaat't'uxun örügbale izi elemi balina. Finen os'k'ale şot'in izi paltara, Təzə s'orobi noč'e boş badi c'evk'ale izi loxolxun lak'alt'oğo. ");
INSERT INTO udi_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","İzi t'ulluğen tadala fi t'eq'ədər bakale ki, p'i k'at'k'ale şot'ay ç̌oyexun, Uluxxo mas'ibakale şot'ay muč'anaq' ǔğsunaxun. ");
INSERT INTO udi_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zevulun isə dənizi börine, Gəmiğoy hari çurk'ala gala yəşəyinşale. Sidonal śirik' tağale şot'ay oç̌alxo. ");
INSERT INTO udi_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","İssak'ar - izi bač'ane yük xork'ala sa elem k'inək'e şo, Zorbane, izi kiyelxun nu ayeğala əş tene bu şot'ay. ");
INSERT INTO udi_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Dincluğe qə̌vesa şot'in, Bezi əşp'ala oç̌alq'an şaat' baki nexe. İrəzine şo bač'an k'os'psuna, Q'ert'ay loxol əşp'i yük xorpsuna. ");
INSERT INTO udi_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Divanbal bakale Dan izi nəsileynak', İsrailaxun əmələ hari azuk'xoy cörginə bakale şot'oxun törəyinşakiyorox. ");
INSERT INTO udi_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Yaq'e boş bask'i dizik', Cığıren tağat'an běš c'eğala gürzə k'inək' bakale Dan. Ěke tura duği, Şot'ay loxol arśit'u bač'ani loxol sakalo bakale. ");
INSERT INTO udi_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Vi za çark'est'unane bezi umud, ay Q'ončux! ");
INSERT INTO udi_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gade loxol lavabaki şot'o fǔq'psun çureğalt'un, Ama t'etər bakale ki, içan sunay dabana ç̌axç̌uxpsun t'it'ala bakalt'un. ");
INSERT INTO udi_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Nu bit'i becərişala şey tene bakal Aşeren izi oç̌alxo, Padçağxoy běš eçeri laxalt'un şot'in toydala neymətxo. ");
INSERT INTO udi_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Biq'i efes nu bakala marali gözəlluğe bu Naft'alinast'a, İzi eçala baloğoy loxole bitot'ay pul. ");
INSERT INTO udi_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","C'epi ğumoğoy kiyexun bask'ala c'ap' k'inək'e İosif, Orayini t'ǒğǒl bit'eśi şaat' c'ek'ala sa c'ap' k'inək', İzi taymux barinen tik alane laysa şot'ay. ");
INSERT INTO udi_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Elmux haq'ala düşmənxone şot'ay loxol hari, Ən şaat' oxbosalxone içuxun davina c'eri. ");
INSERT INTO udi_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ama sakes tet'un baki şot'oğon İosifa, Şot'o görə ki, Zorba Bakalt'ine şot'o İzi zoraxun tast'ay, İak'oven bul k'os'p'ala Buxačuğone şot'ay ə̌mə zorba efsay. Bač'ane baki şot'aynak' İsraileynak' Bač'an bakiyo, Enefi şot'o çobanen izi sürünə efala k'inək'. ");
INSERT INTO udi_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Vi bavay bul k'os'p'ala Buxačuxe va kul biq'i Buxačux, Bitova Başarbalone Şo! Şone göynuxun ağala yaq'abi va xeyir-bərəkət tadalo, Şone oç̌ali oq'a bakala xeyurxo duği ç̌oyel c'evk'alo. Vi saya avuzbaloval, Vi sürünə bakala heyvanxo balalayinşest'aloval Şone, Şot'oxune eysa xeyir-bərəkət. ");
INSERT INTO udi_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Vi bavay xeyir-bərəkətə p'ap'ala xeyir-bərəkət butene, Ən alloy buruxmoğoxun üst'üne şo, Burqesunast'a laxeśi təpoğon tades bakalorox hik'k'ale şot'ay t'ǒğǒl! Barta İosifi belq'an bari me xeyir-bərəkət, Barta izi viçimoğoxun üst'ün bakalt'ay k'odoğoq'an śameśi me bezi piyorox. ");
INSERT INTO udi_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Busa canavar k'inək'e Binyamin: Savaxt'an izi kiyexun haq'es ten bakon ǒxə̌lbi eçerit'u, Biyəsin isə efi taneğon izi běšt'an mandit'oğo». ");
INSERT INTO udi_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Moval İsrailen içuxun əmələ eğala p'as's'e tayfin barada saturběš piyorox, me əyitmoğo pine xeyir-bərəkət tadey şot'oğo. Hər ğarenal içu görəne izi xeyir-bərəkətə haq'ey. ");
INSERT INTO udi_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Oşa İak'oven izi ğarmoğo me əyitmoğo pi vəsyənebi: «Mone, bezi pula q'ic'p'i tazsa zu t'e dünyəne. Za taşeri bezi bavoğoy t'ǒğǒl, xet'lu Efroni q'oruğa bakala mağarinanan oç̌alaxpsa. ");
INSERT INTO udi_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kənan oç̌alane t'e mağara: Mamreni mə̌xluğa ı̌ša, Maxp'ela uk'ala q'oruği boş. Avrahamen t'e mağarina q'oruğaxun sagala təngə tadi haneq'ey xet'lu Efronaxun. İzi p'uriğo oç̌alaxpseynak'e haq'ey şot'in t'e mağarina. ");
INSERT INTO udi_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Avrahama içuval t'iyat'un oç̌alaxp'ey, izi çuux Saral, İsaak'a q'a Rebek'al. Leal t'iyaz oç̌alaxp'e zu. ");
INSERT INTO udi_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","T'e q'oruğal, izi boş bakala mağarinal Avrahamen xet'luğoxune haq'ey». ");
INSERT INTO udi_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Hametər, İak'oven izi axırınci əyitə pi izi bula lanexi, izi elmuxal hat'iya c'ere. Şot'in izi pula q'ic'p'i t'e dünyəne, izi bavoğoy t'ǒğǒle taśi. ");
INSERT INTO udi_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","İosifen k'os'p'aki izi bavay meyidə muçepi, izi loxol bitiyal bureqi ǒnepsa. ");
INSERT INTO udi_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Oşa hayzeri izi kiin oq'a əşp'ala doxt'urxo əmirebi ki, eçeri izi bavay meyidə misirluğoy ədəten mumiyalayinşeq'at'un. Doxt'urxonal burt'unqi İsraili p'uri bədənə oyurxoxun həzirbaki dərmənxo q'a c'əyin lə̌ə̌mdi şot'o mumiyalayinşpsa. ");
INSERT INTO udi_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Düz q'ırx ği doxt'urxon meyidi loxol əşt'unbi, şot'o görə ki, tam mumiyalayinşbseynak' meq'ədər vaxt'e taysay. Düz yetmiş ğiyal misirluğon İsraileynak' yast'un efi. ");
INSERT INTO udi_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yas efala ğimxo hari c'ovakit'uxun oşa, İosifen faraoni sarayi amdarxo girbi metəre pi: «Bezi xətirə çurnansasa, takinan faraona bezi s'iyen upanan ki, ");
INSERT INTO udi_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","bezi bavan elmoğoy loxol bakat'an za vəsyənebe. \"Bezi ga Kənan oç̌ala həzire\" pi za elasp'esede ki, şot'o taşeri izi pi ganu k'ula tapşurboz. Faraona upanan bark'ayin taśi bezi bava oç̌alaxp'i ezğoy». ");
INSERT INTO udi_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraonenal mot'o ibakat'an qaybaki metəre pi: «Barta tadi əyiti loxol çurpi taśi izi bava oç̌alaxp'i hareq'an». ");
INSERT INTO udi_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","İosifal hayzeri izi bava oç̌alaxpseynak' Kənan oç̌ala yaq'ane baft'i, sarayal faraoni t'ǒğǒl çurpi şot'o maslaat tadalorox şu buneysa hari gərt'unbaki şot'o. Faraoni əşurxo taşalt'oğoy q'a Misirə bakala ağsaq'q'alxoy bito İosifi t'ǒğǒley. ");
INSERT INTO udi_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","İosifi izi külfət, izi bavay külfət, viçimux - bito hayzeri tat'unśi, Goşen oç̌ala saycə əylux q'a içoğoy sürüğo bakala heyvanxone mandi. ");
INSERT INTO udi_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Turin bakalt'oğoxun cöy, ěken tağalo manuvay, arabina arśi tağalo manuvay - yaq'e t'e bul-me bul amdarey. ");
INSERT INTO udi_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","İordan oqa ı̌ša Atad uk'ala gane buy, miya arumt'un eçeri śiney, hari t'iya p'ap'at'an amdarxon İak'ovi loxol hönkür-hönkür ǒnepsat'un burqi. İosifen miya çurpi izi bavaynak' düz vǔğ ği ǒnek'a yase efi. ");
INSERT INTO udi_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","T'iya yəşəyinşala kənanluğonal Atad uk'ala ec'nuxun eğala me ǒnena ibaki pit'un: «Misirluğoy şivane mo, içoğoy p'urin loxolt'un ǒnene şot'oğon!» Oşa t'e gane s'i hat'etərəl manedi - Avel-Miśrayim. ");
INSERT INTO udi_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","İak'ovi ğarmoğon içoğoy bavan vəsiyəbi k'inək'əl bit'un: ");
INSERT INTO udi_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","taşeri şot'o Kənan oç̌ala, Maxp'ela uk'ala q'oruği boş bakala mağarina oç̌alaxt'unbi. Mamreni mə̌xluğ uk'ala ganu ı̌ša bakala me q'oruğa q'a mağarina Avrahamen xet'lu Efronaxun təngə tadi haneq'ey ki, izi p'uriğo oç̌alaxpseynak' gaq'an baki. ");
INSERT INTO udi_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","İzi bava oç̌alaxp'it'uxun oşa İosif qaybaki Misirəne hari. Viçimux q'a içuxun taśiyoroxal bito qaybaki hart'un. ");
INSERT INTO udi_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bava p'urit'uxun oşa viçimoğon fikirt'unbi ki, əgər İosif hələ içoğoy loxol əcuxlunesa, isə c'evk'ale içoğoxun t'e əcuğo. ");
INSERT INTO udi_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Şot'o görəl İosifeynak' xavar yaq'abi pit'un ki, p'oy bavan biyalt'uxun běš içoğo metəre tapşurbe: ");
INSERT INTO udi_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","\"İosifa upanan ki, bavan nexe izi viçimoğo bağışlayinşeq'an, eyexun c'evk'eq'an şot'oğoy içu bi pisluğa q'a əşp'est'i t'e günaxa\". İçoğoy s'iyen isə me əyitmoğo pit'un xavar yaq'abi: «İsə mone, va xoyinšyanbsa, bağışlayinşa vi bavay bul k'os'p'ala Buxačuğoy me k'ulurxo!» İosifen me əyitmoğo ibakat'an ǒnenepi. ");
INSERT INTO udi_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Oşa viçimux içant'un hari İosifi t'ǒğǒl, şot'ay turin oq'a bitiyal pit'un: «Vi k'ulurxoyan yan meyin t'ağay!» ");
INSERT INTO udi_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","İosifen isə qaybaki izi viçimoğo metəre pi: «Zaxun q'ı̌mabanan, zu şuzu ki? Buxačuğoxune q'ı̌bsun lazım, q'erəz şuk'k'alaxun. ");
INSERT INTO udi_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Za pisluğbsuney efi niyət, ama Buxačuğon t'etəre bi ki, efi pisluğbsuni s'iyen bit'oğon xeyire eçeri. Běğanan heq'ədər amdarxoz busaluğaxun çark'est'i zu! ");
INSERT INTO udi_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Şot'o görəl, efi ük'ə buz k'inək' efanan: heq'ədər ki zu buzu, nə və̌n, nə efi əyloğon hik'k'alaxun koruğ ak'alatenan». İosifi me əyitmoğon q'a oşal arśi içoğoxun muč'a exlətpsunen viçimoğo arxayinebi. ");
INSERT INTO udi_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hametər, İosifen izi bavay külfətə izi t'ǒğǒlxun tene tərbi, hariyal bito sagala Misirə art'unśi. İosif düz sabaç̌ vis' usen yəşəyinşebi, ");
INSERT INTO udi_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","şot'in izi nəvoğoy əyloğol śirik' ak'i oşane p'uri. Efraimi nəvoğoval, Menaşşeni Maxir uk'ala ğaraxun baki əyloğoval nanaxun bakala k'inək' eçeri İosifi q'ujelt'un tadey. ");
INSERT INTO udi_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","İosif lap q'ojabakeney, sa ği viçimoğo izi t'ǒğǒl k'alpi pine: «Zaynak' male mande, ama avazu ki, Buxačuğon və̌x eyexun tene c'evk'al. Ği eğale Şot'in və̌x me oç̌alaxun c'evk'i taşeri Avrahama, İsaak'a saal İak'ova elasp'i əyit tadi oç̌ala arśevk'ale». ");
INSERT INTO udi_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Oşa İosifen İsrailaxun törəyinşakit'oğo elasp'esedi ki, iç p'urit'uxun oşa Buxačuğon İzi əyiti loxol çurpi şot'oğo Kənan oç̌ala taşat'an içuval c'evk'i taşereq'at'un. ");
INSERT INTO udi_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","İosif biyat'an izi sabaç̌ vis' yəşe buy. Şot'o hat'iya, Misirə mumiyalayinşt'unbi, usenxon mandala sanduği boş laxiyal et'unfi.");
INSERT INTO udi_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","İak'ovaxun, yəni İsrailaxun sagala içoğoy külfətəl ext'i Misirə hari iz ğarmoğoy s'iyurxo metərey: ");
INSERT INTO udi_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruven, Simeon, Levi, İuda, ");
INSERT INTO udi_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","İssak'ar, Zevulun, Binyamin, ");
INSERT INTO udi_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naft'ali, Gad, Aşer. ");
INSERT INTO udi_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","İak'ovi külfəti say, Misirə bakala iz ğar İosifi külfətəxun sagala, bütüm yetmiş taney. ");
INSERT INTO udi_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Vaxt' c'ovaneki, İosif, iz viçimux saal t'e nəsil p'ure. ");
INSERT INTO udi_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ama israilluyox gelebaki avuzebaksay, içoğoy sayal avuzebaksay, şorox zorbat'un baksay; t'e ölkə şot'oğoxun buyebaksay. ");
INSERT INTO udi_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Oşa t'etər sa vədəne hari ki, Misirə İosifa nu çalxala sa padçağe taxt'a laśi. ");
INSERT INTO udi_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Şot'in iz azuk'a pine: «Běğanan, israilluyox içoğoy saya görə yaxun gele hamal zorbat'un. ");
INSERT INTO udi_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Yan k'ənesa biyan buq'on, tenesa samalal avuzbakalt'un. Sa dava bakayin isə beşi düşmənxo gərbaki beş loxol ěqğalt'un, yax tabi nu bakiyal ölkinəxun c'eğalt'un». ");
INSERT INTO udi_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Metərluğen, misirluğon israilluğoy loxol q'əddar nəzərətçiyoxt'un laxi ki, şot'oğo bı̌hi əşlen əzyətq'at'un tadi. İsrailluğonal faraoneynak' P'it'om saal Ramses uk'ala ambarla şəhərmuxt'un biq'i. ");
INSERT INTO udi_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ama israilluğo əzyət tast'unen şorox t'e ölkinə samalal gelebaki avuzt'un baksay. Kot'o görəl misirluğon israilluğoxun lap gelet'un zap'esa burqi, ");
INSERT INTO udi_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","şot'oğo lap gele sıxışt'ırişi koruğ tast'at'un burqi. ");
INSERT INTO udi_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Misirluğon israilluğo bı̌hi əşurxon - oč'i ç̌axç̌uxp'est'i, kərpiç bot'est'i, çöle hər cürə əşurxo zülüm tast'un əşp'est'i şot'oğoy yəşəyinşə ağut'unbsay. ");
INSERT INTO udi_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misiri padçağen sunt'ay s'i Şifra, t'e sunt'ay s'i isə P'ua bakala əbrani mamaçiğo pine: ");
INSERT INTO udi_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Běğanan, əbrani çupuxxoy əyel bakat'an əgər əyel ğar bakayin, şot'o besp'anan, xuyərmoğo isə efanan». ");
INSERT INTO udi_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ama mamaçiğon Buxačuğo çalxsuna görə Misiri padçağen şot'oğo əmirbi k'inək' tet'unbsay, ğar əyloğo dirist't'un efsay. ");
INSERT INTO udi_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","T'e vədə Misiri padçağen mamaçiğo k'alpest'i şot'oğo pine: «Het'aynak'nan metər bsa? Het'aynak'nan ğar əyloğo dirist' efsa?» ");
INSERT INTO udi_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mamaçiğon faraona pit'un: «Şot'aynak' ki, əbraniğoy çupuxxo misirluğoy çupuxxo k'inək' tet'un, şorox gele elmuxlat'un, mamaçiyox eğamin şot'oğoy əyel baneksa». ");
INSERT INTO udi_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Metərluğen, Buxačuğoy azuk' gelebaki avuzebaksay. Buxačuğon mamaçiğoval İz şaat'luğane ak'est'i. ");
INSERT INTO udi_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Şot'in İçu çalxsuna görə mamaçiğo ailəne tadi. ");
INSERT INTO udi_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Faraonen bütüm iz azuk'a əmirbi pine: «Əbraniğoy nanaxun bakala bütüm ğar əyloğo Nil oqe boş bosanan, xuyərmoğo isə efanan». ");
INSERT INTO udi_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Me vədine Levin tayfinaxun sa işq'aren iz tayfinaxun sa çuuxe haq'i. ");
INSERT INTO udi_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Şo bı̌hi baki sa ğare eçeri. Əylin heq'ədər muč'a baksuna ak'i şot'o xib xaş c'ap'ebi. ");
INSERT INTO udi_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ama ene c'ap'p'es nu baksuna ak'i sa gěše k'ans'ara ext'i şot'o q'ir q'a k'at'ran lə̌ə̌mdi əylə t'e k'ans'arin boşe laxi. Oşa t'e k'ans'arina ext'i Nil oqe t'ǒǒx bakala gěšluğa lanexi. ");
INSERT INTO udi_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Əylin xunçen isə samal ə̌xil çurpi tamaşanebsay ki, běyn k'ə baksa. ");
INSERT INTO udi_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mone, Faraoni xuyər oqe t'ǒğǒl hari os'k'alpseynak' oqane baśi. Şot'ay çuux nökərxo isə oqe t'ǒǒx tarat'unney. Faraoni xuyəren gěšluği arane k'ans'arina ak'i iz nökərə yaq'anebi ki, şot'o eçereq'an. ");
INSERT INTO udi_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Şot'in k'ans'arin ç̌oya qaypi sa ğar əyele ak'i. Əyelen ǒnenney. Faraoni xuyəren şot'o gorox hari pine: «Mo əbraniğoy əyele». ");
INSERT INTO udi_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","T'e vədə əylin xunçen ı̌šalayinşaki faraoni xuyərə pine: «Bərkə taśi əbrani çupuxxoxun sunt'u k'alk'az, əylə döş tadi kalabane vaynak'?» ");
INSERT INTO udi_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faraoni xuyərenal şot'o pine: «Hoo, taki». Xuyəren taśi əylin nana k'alepi. ");
INSERT INTO udi_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Faraoni xuyəren şot'o pine: «Me əylə ext'a, döş tadi zaynak' kalaba běğa, va kot'ay haq'q'a tadoz». Çuğonal əylə ext'i döş tadi běneği. ");
INSERT INTO udi_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Əyel kalanebaki, çuğon şot'o faraoni xuyəri t'ǒğǒle taşeri. Faraoni xuyəren əylə ğarluğane ext'i. Şot'in əylin s'iya Moisey laxi pine: «Ğara xenaxun c'evksuna görə şot'o me s'iyaz tadi». ");
INSERT INTO udi_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Gele usenxone c'ovaki, Moisey kalanebaki. Sa kərəm şo iz azuk'i t'ǒğǒl taśi şot'oğoy hetər bı̌hi əş əşbsunane ak'i. Şot'in anek'i ki, sa misirlunen iz azuk'axun bakala əbranina t'ap'ene. ");
INSERT INTO udi_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moiseyen hərrəminə şuk'k'ali nu baksuna ak'i t'e misirluna besebi, izi meyidə isə q'ume boş c'ap'ebi. ");
INSERT INTO udi_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Əyc'indəri şo saal c'eğat'an anek'i ki, p'ə̌ əbraninen sun-sunaxun davat'unbsa. Moiseyen haq'suz bakalt'u pine: «Vi azuk'axun bakalt'u het'aynak'en t'ap'e?» ");
INSERT INTO udi_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","T'e amdaren pine: «P'oy va şina beşi loxol kalo nəəl divanbal laxe? Bərkə misirluna besp'i k'inək' zaal bespsuni fikirvax bu?» Moiseyen q'ı̌bi iz ük'e boş pine: «Ak'esa ki, me əşlin barada avat'un». ");
INSERT INTO udi_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faraonen me əşlin barada avabakala k'inək' Moiseya besp'est'une çureśi. Ama Moisey faraoni kiyexun t'it'eri Midyan oç̌ala taśi t'et'iyane mandi. Sa ği Moisey sa kərizi t'ǒğǒl arśeney. ");
INSERT INTO udi_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","T'et'iya Midyani běyinši vǔğ xuyəre hari. Şot'oğon hari kərizəxun xe c'evk'i içoğoy bavay eğel-keçiğo xe tast'eynak' nə̌vǔrxot'un buybsay. ");
INSERT INTO udi_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Hame vədine sa hema çobanen hari şot'oğo şəp'eśi. Ama Moiseyen hayzeri xuyərmoğo köməyebi, şot'oğoy eğel-keçiğo xene tadi. ");
INSERT INTO udi_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Xuyərmux içoğoy bava Reueli t'ǒğǒl qaybakat'an şot'in pine: «Hetəre baki ki, ğe usumnan hari?» ");
INSERT INTO udi_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Xuyərmoğonal pit'un: «Sa misirlunen yax çobanxoy kiyexun çark'esedi, hələ yaynak' kərizəxun xe c'evk'i eğel-keçiğoval xene tadi». ");
INSERT INTO udi_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Şot'in xuyərmoğo pine: «P'oy t'e amdar maya? Şot'o het'aynak'nan tərbi? Şot'o k'alpanan, hari šumq'an kəyi». ");
INSERT INTO udi_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisey t'e amdari k'oya manst'una irəzine baki. Şot'inal iz xuyər Sip'p'ora Moiseyane tadi. ");
INSERT INTO udi_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sip'p'oran sa ğare eçeri. Moiseyen şot'ay s'iya Gerşome laxi, şot'aynak' ki, \"zu q'erəz sa ölkinə q'əribez baki\" nexey. ");
INSERT INTO udi_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Xeyli vaxt'e c'ovaki. Misiri padçağ p'ure. İsrailluğon isə bı̌hi əş əşbsuna görə şivanbi xoyinšt'unbsay. Me şivan Buxačuğo p'anep'i. ");
INSERT INTO udi_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Buxačuğonal şot'oğoy şivana inebaki; Avrahamaxun, İsaak'axun saal İak'ovaxun ğaç̌eśi irəziluğ Şot'ay eyexey. ");
INSERT INTO udi_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Buxačuğon israilluğoy k'ul baksuna anek'i, İz pula şot'oğoxun tene zapi. ");
INSERT INTO udi_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moiseyen t'e vədə iz q'ayinba, Midyani běyinš bakala Yet'roni sürünəne otarişbsay. Sa kərəm şot'in sürünə ams'i oç̌ali lap t'e bel taşeri hari Buxačuğoy burux bakala Xorevi t'ǒğǒle c'eri. ");
INSERT INTO udi_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Bürdən Q'ončuğoy angel sa ləmbin boş arux k'inək' ak'eśi. Aruğoy boş ləmbin bəc'ük'eśi nu boksuna ak'ala ");
INSERT INTO udi_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moiseyen için içeynak' fikirebi: «Sa běğaz běyn, mo hetər bakala şeya! Me ləmbə het'u görə bok'i tene çarksa?» ");
INSERT INTO udi_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Q'ončuğonMoiseyi běğsa eysuna ak'i ləmbin boşt'an şot'o k'alpi pine: «Moisey, Moisey!» Şot'inal «zu memiyazu» pine. ");
INSERT INTO udi_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Buxačuğon pine: «Memiya ma ı̌šalayinşaka. Vi turexun torok'ala c'evk'a, şot'aynak' ki, vi çurpi ga ǐvele». ");
INSERT INTO udi_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Oşa pine: «Zu vi bavoğoy Buxačuxzu: Avrahami Buxačuxzu, İsaak'i Buxačuxzu saal İak'ovi Buxačuxzu». Mot'o ibaki Moiseyen iz ç̌oya but'ek'i, şot'aynak' ki, Buxačuğoy loxol běğsuna q'ı̌nebsay. ");
INSERT INTO udi_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Q'ončuğon pine: «Mone, Zu Misirə bakala Bezi azuk'i əzyətə azk'i, nəzərətbalxoy kiyexun şot'oğoy şivana ibaki içoğoy dərdə avazbaki. ");
INSERT INTO udi_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Zu şot'o görəz śiri ki, şot'oğo misirluğoy kiyexun çark'est'i me ölkinəxun c'evk'az. Şot'oğo geng, barlu sa oç̌ala, muč'anaq' saal uč' barala oç̌ala - kənanluğoy, xet'luğoy, emorluğoy, p'erizluğoy, xivluğoy saal yevusluğoy oç̌ala taşaz. ");
INSERT INTO udi_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Həysə isə israilluğoy şivan Za p'anep'i, misirluğon şot'oğo bala zülümə azk'i. ");
INSERT INTO udi_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kot'o görəl taki! Va faraoni t'ǒğǒl yaq'azbsa ki, Bezi azuk' bakala israilluğo Misirəxun c'evk'avax!» ");
INSERT INTO udi_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moiseyen isə Buxačuğo pine: «Axıri zu şuzu ki, faraoni t'ǒğǒl taśi israilluğo Misirəxun c'evk'az?» ");
INSERT INTO udi_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Buxačuğon pine: «Zu vaxunzu. Hun azuk'a Misirəxun c'evk'it'uxun oşa me ganu Za bul k'os'balnan. Moval və̌ynak' nišan bakale ki, va yaq'abiyo Zuzu». ");
INSERT INTO udi_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moiseyen Buxačuğo pine: «İsrailluğoy t'ǒğǒl taśi \"za ef t'ǒğǒl yaq'abiyo ef bavoğoy Buxačuxe\" uk'ayiz, şot'oğonal zaxun xavar haq'es bat'unkon ki, \"p'oy Şot'ay s'i hik'ə?\" T'e vədə zu k'ə uk'az?» ");
INSERT INTO udi_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Buxačuğon Moiseya pine: «Zu Həmişə Bakalozu». Oşa pine: «İsrailluğo upa ki, \"Həmişə Bakalo\" s'iyen bakalt'ine ef t'ǒğǒl za yaq'abe». ");
INSERT INTO udi_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Buxačuğon Moiseya saal pine: «İsrailluğo upa: \"Həmişə Bakalt'in, ef bavoğoy Buxačuğon - Avrahami Buxačuğon, İsaak'i Buxačuğon saal İak'ovi Buxačuğone za ef t'ǒğǒl yaq'abe\". Mo Bezi həmişəluğ s'ine. Barta Za nəsiləxun nəsilə metərq'at'un çalxi. ");
INSERT INTO udi_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Taki, israilluğoy ağsaq'q'alxo girba, şot'oğo metər upa: «Həmişə Bakalt'in, ef bavoğoy Buxačuğon - Avrahami Buxačuğon, İsaak'i Buxačuğon saal İak'ovi Buxačuğon, za ak'eśi mot'oğone pi: \"Və̌x saal Misirə ef bel me əşurxo eçalt'oğo bitova azaksa. ");
INSERT INTO udi_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Əyitez tast'a ki, və̌x Misirə bakala əzyətəxun çark'est'i kənanluğoy, xet'luğoy, emorluğoy, p'erizluğoy, xivluğoy saal yevusluğoy ölkinə - muč'anaq' saal uč' barala oç̌ala taşoz\". ");
INSERT INTO udi_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","İsraili ağsaq'q'alxon vi əyitə ǔmǔxlaxalt'un. Hun şot'oğoxun sagala Misiri padçaği t'ǒğǒl taśi uk'alnu: \"Yax əbraniğoy Buxačux bakala Həmişə Bakalone ak'eśe. Barta yan ams'i oç̌ala xib ğiluğ yaq' taśi t'et'iya beş Buxačux Həmişə Bakalt'aynak' q'urban eçen\". ");
INSERT INTO udi_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ama avazu ki, Misiri padçağa Zu Bez zorba kiin nu məcburbayiz, ef taysuna tene bark'al. ");
INSERT INTO udi_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Şot'o görəl Zu Bezi kula boxodi Misirə Bezi ak'est'ala möcüzoğon duğoz, kot'oxun oşa Misiri padçağen və̌x tərbale. ");
INSERT INTO udi_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Zu t'etər boz ki, və̌n misirluğoy piyes şaat' ak'eğalnan, şot'oğonal və̌x yaq' c'eğat'an kulams'i tet'un tərbal. ");
INSERT INTO udi_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Barta hər çuğon iz q'onşinaxun, iz q'onşin k'oya yəşəyinşalt'uxun q'ızıl-gümüş saal paltarq'an çureśi. Və̌nal şot'oğon ef ğarmoğo saal xuyərmoğo bəzəyinşalnan, metərluğen misirluğo fǔq'k'alnan». ");
INSERT INTO udi_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ama Moiseyen metəre coğab tadi: «P'oy şot'oğon za nu věbaki, bezi əyitə nu ǔmǔxlaxi \"Q'ončux va ak'eśitene\" uk'ayt'un?» ");
INSERT INTO udi_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","T'e vədə Q'ončuğon Moiseya pine: «Vi kiyel bakalo hik'ə?» Şot'in pine: «Çombağ». ");
INSERT INTO udi_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Q'ončuğon pine: «Şot'o oq'a bosa». Moiseyen şot'o bonesi, çombağ dizik'əne fırıpi. Moisey qoş-qoşe baki. ");
INSERT INTO udi_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Q'ončuğon isə Moiseya pine: «Vi kula boxodi şot'ay oǰulaxun biq'a». Moiseyenal iz kula boxodi dizik'ə biq'at'an şo p'urum iz kiyel çombağe baki. ");
INSERT INTO udi_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Oşa Q'ončuğon pine: «Me nišan şot'o görəne ki, israilluğon Q'ončuğoy, içoğoy bavoğoy - Avrahami Buxačux, İsaak'i Buxačux saal İak'ovi Buxačuğoy va ak'esuna věbakat'un». ");
INSERT INTO udi_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Oşa Q'ončuğon pine: «Vi kula vi q'oltuğe laxa». Moiseyen kula q'oltuğe lanexi, kula q'oltuğexun c'evk'at'an isə iz kul dirist' q'otur baft'iney, şo ı̌ǰ k'inək' mapmas'iney. ");
INSERT INTO udi_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Oşa Q'ončuğon pine: «İsə kula p'urum vi q'oltuğe laxa». Moiseyen p'urum iz kula q'oltuğene laxi, kula q'oltuğexun c'evk'at'an isə şo iz bədən k'inək' təmizey. ");
INSERT INTO udi_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Q'ončuğon saal pine: «Əgər va nu věbakayt'un, süft'in möcüzinen içoğo nu vědayin, oşin möcüzinen şot'oğo vědale. ");
INSERT INTO udi_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ama əgər me p'rannal nu věbaki vi əyitə nu ǔmǔxlaxayt'un, Nil oqe xenaxun ext'i q'ariluğa śipa. Oqexun ext'i xe q'ariluğa p'iya tarak'ale». ");
INSERT INTO udi_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moiseyen Q'ončuğo pine: «Ay bezi Q'ončux, zu nə t'evaxt' yönbəri əyitk'al tez bake, nəəl isə, Hun me Vi k'ulaxun əyitk'ala vədineyal sa yönbəri əyitk'al tezu». ");
INSERT INTO udi_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Q'ončuğon şot'o pine: «Amdara muz tadiyo şuva? Amdara lal, kar, k'ač'i nəəl iz ak'es baksuna tadiyo şuva? Mot'o balo Zu Q'ončux tezu ki? ");
INSERT INTO udi_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Həysə isə taki! Zu va köməyboz, vi k'ə upsun lazımesa va zomboz». ");
INSERT INTO udi_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moiseyen pine: «Ay bezi Q'ončux, xoyinšezbsa, q'erəz sa amdar yaq'aba». ");
INSERT INTO udi_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Q'ončuğon Moiseyi loxol əcuğon biq'i pine: «Axıri vi viçi Levit' Aaronal bune. Avazu ki, şot'in şaat' əyitp'es baneksa. Həysə şo vi běše eysa. Va ak'at'anal şo ük'in mǔqbakale. ");
INSERT INTO udi_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Vi viçəxun exlətp'a, k'ə upsun lazımesa, şot'o upa. Və̌n p'rannanal əyitk'at'an Zu və̌x köməyboz, k'ə bsun lazımesa zomboz. ");
INSERT INTO udi_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Vi gala camaataxun Aaronen əyitk'ale. Hun şot'o Bez əyitmoğo p'ap'esp'alnu, şot'inal vi muzen camaataxun exlətp'ale. ");
INSERT INTO udi_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Me çombağal vi kiyel ext'a, şot'ay köməyen möcüzoox ak'est'alnu». ");
INSERT INTO udi_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisey iz q'ayinba Yet'roni t'ǒğǒl qaybaki pine: «Barta bezi Misirə bakala q'oomxoy t'ǒğǒl qaybakaz, běğaz běyn şorox dirist't'un». Yet'ronen Moiseya pine: «Taki, vaynak' şaat' yaq'». ");
INSERT INTO udi_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moisey Midyan oç̌ala bakat'an Q'ončuğon içu peney: «Misirə qaybaka, vi elmoğo haq'sun çureğalt'oğoy bito ene p'uret'un». ");
INSERT INTO udi_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Metərluğen, Moiseyen iz çuğo q'a ğarmoğo elema arśevk'i, Buxačuğon içu bürüşi çombağal iz kiyel ext'i Misirəne taśi. ");
INSERT INTO udi_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Q'ončuğon Moiseya pine: «Běğa, Misirə qaybakat'an Bezi va ak'est'eynak' tadi zoren bito t'e möcüzoğo faraoni běš ak'est'a. Ama Zu şot'o inadkərboz, şot'inal azuk'a tene tərbal. ");
INSERT INTO udi_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","T'e vədə faraona uk'alnu: \"Q'ončuğon metəre nex: \"İsrailluyox Bezi süft'in ğar k'inək't'un. ");
INSERT INTO udi_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Va pizu ki, Za bul k'os'bseynak' Bezi ğara tərba! Hun isə şot'o ten çureśi tərbsun. Mot'o görə Zu vi süft'in ğara besp'oz\"». ");
INSERT INTO udi_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Yaq'a, üşe bask'i vədine Q'ončux ı̌šalayinşaki, şot'o bespsune çureśi. ");
INSERT INTO udi_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sip'p'oran isə sa ğayin ǰě ext'i iz ğara sünnətebi, oşa sünnətbi yeq'a şot'ay turmoğo laft'est'i pine: «Hun bezi p'iye q'oomnu». ");
INSERT INTO udi_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","T'e vədə Q'ončuğon şot'oxun kule haq'i. Sip'p'oran ğara sünnətbsuna görəne «Hun bezi p'iye q'oomnu» pey. ");
INSERT INTO udi_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Q'ončuğon Aarona pine: «Moiseyi běš c'eyseynak' ams'i oç̌ala taki». Aaronenal taśi Buxačuğoy buruğoy t'ǒğǒl iz viçə irəst'e hari, şot'o muçepi. ");
INSERT INTO udi_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moiseyen Q'ončuğoy içu hetər yaq'absuni, içu mani əyitmoğo upsuni, hetər möcüzoğoy ak'est'uni barada pi əyitmoğo bütümə Aarona exlətebi. ");
INSERT INTO udi_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Şot'oğon taśi israilluğoy bütüm ağsaq'q'alxo girt'unbi. ");
INSERT INTO udi_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaronen Q'ončuğon Moiseya pi əyitmoğo bitova şot'oğo exlətebi, Moiseyenal azuk'i běš möcüzoğone ak'est'i. ");
INSERT INTO udi_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Azuk'al mot'oğo věnebaki. Şot'oğon Q'ončuğoy israilluğoy əzyətə ak'i İz kula şot'oğoy loxolxun nu zapsuna ibakat'an, Şot'o bult'un k'os'bi. ");
INSERT INTO udi_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Oşa Moiseyen q'a Aaronen faraoni t'ǒğǒl taśi pit'un: «Q'ončuğon, israilluğoy Buxačuğon metəre nex: \"Bezi azuk'a tərba ki, taśi ams'i oç̌ala Bez s'iyen axsibayq'at'un c'ovakest'i!\"» ");
INSERT INTO udi_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraonen pine: «Q'ončux şuva ki, Şot'o ǔmǔxlaxi israilluğo tərbaz? Nə Q'ončuğo çaltezaxsa, nə israilluğo tərbala fikir tezax bu». ");
INSERT INTO udi_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Şot'oğon pit'un: «Yax əbraniğoy Buxačuxe ak'eśe. Barta yan ams'i oç̌ala xib ğiluğ yaq' taśi, t'iya Q'ončuğoynak', beşi Buxačuğoynak' q'urban eçen ki, yax yaroğon nəəl q'ılıncen maq'an əfçibi». ");
INSERT INTO udi_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misiri padçağen isə şot'oğo pine: «Ay Moisey q'a Aaron, het'aynak'nan azuk'a iz əşləxunbsa? Takinan, ef əşlə əşp'anan». ");
INSERT INTO udi_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Oşa faraonen pine: «Běğanan me ölkinə ef azuk'i say heq'ədəre, və̌n isə şot'oğo əşləxunbsunnan çuresa». ");
INSERT INTO udi_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hat'e ği faraonen nəzərətçiğo q'a əşləběğalxo əmirbi pine: ");
INSERT INTO udi_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Mot'oxun oşa ene me azuk'a kərpiç düzbseynak' neq tamadanan. Bartanan içanq'at'un taśi neq girbi. ");
INSERT INTO udi_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ama içoğoy tadala kərpic'i say həmişənin k'inək'q'an baki. Tənbəlluğaxun \"tağen beşi Buxačuğo q'urban eçen\" pi şivant'unbsa. ");
INSERT INTO udi_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","İçoğoy əşlə samalal gelebanan ki, ams'i exlətxo fikir tast'una içoğoy vaxt' maq'an baki!» ");
INSERT INTO udi_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nəzərətçiyox q'a əşləběğalxoval camaati běš c'eri pit'un: «Faraonen metəre nex: \"Ene zu və̌x neq tez tadal. ");
INSERT INTO udi_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Takinan, və̌n mayin çurnansa neqa girbanan. Ef tadala kərpic'i say isə həmişənin k'inək' mandale\"». ");
INSERT INTO udi_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Azuk'al dirist' Misiri oç̌alxo baft'i neqe gala kološ girbsane burqi. ");
INSERT INTO udi_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nəzərətçiğonal şot'oğo məcburbi next'uniy: «Və̌x neq tadeğala vədine ğiluğ heq'ədər kərpiç bsananiysa, isəəl hat'eq'ədər banan!» ");
INSERT INTO udi_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Faraoni nəzərətçiğon israilluğoxun bakala əşləběğalxo isə t'api pit'un: «Het'aynak' ef həmişənin ğiluğ kərpic'i saya tenanbsa?» ");
INSERT INTO udi_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","T'e vədə israilluğoxun bakala əşləběğalxon faraoni t'ǒğǒl taśi şot'o xoyinšbi pit'un: «Yaxun het'aynak'en metər rəft'ərbsa? ");
INSERT INTO udi_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Vi k'ulurxo neq tet'un tast'a, ama \"kərpiç düzbanan\" next'un. Mone, vi k'ulurxo t'ap'esa, ama me günax vi azuk'i loxole». ");
INSERT INTO udi_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faraonen isə pine: «Tənbəlxonan, tənbəlxo, kot'o görənən \"tağen, Q'ončuğo q'urban eçen\" nexe. ");
INSERT INTO udi_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Takinan əşp'anan! Və̌x neq tene tadeğal, ama ğiluğ kərpic'i saya düzbinanbuq'on». ");
INSERT INTO udi_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","İsraillu əşləběğalxon «və̌ynak' laxeśi ğiluğ kərpic'i say tene malbakal» əyitmoğo ibakat'an içoğoy çətin vəzyətə bafst'una q'amişt'unbaki. ");
INSERT INTO udi_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Şot'oğon faraoni t'ǒǒxun c'eğat'an şot'oğoy yaq'a běğala Moiseya q'a Aarona ak'i ");
INSERT INTO udi_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","pit'un: «Barta Q'ončuğonq'an ef k'ə bsuna ak'i, ef cazina tadi! Və̌n yax faraoni q'a şot'ay sarayi amdarxoy piyes pisnanbi, yax bespseynak' içoğoy kiyel q'ılıncnan tadi». ");
INSERT INTO udi_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moiseyen Q'ončuğo pine: «Ay bezi Q'ončux, het'aynak'en me azuk'a metər bəlinə badi? Za mot'o görən yaq'abey? ");
INSERT INTO udi_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Faraoni t'ǒğǒl Vi s'iyen exlətpseynak' taśit'uxun mağay şot'in me azuk'a zülüme tast'a. Hun isə Vi azuk'a ten çark'est'i». ");
INSERT INTO udi_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Q'ončuğon Moiseya pine: «Bezi faraona k'ə bsuna ak'alnu: Bezi zorba kiin t'etər bale ki, faraonen israilluğo tərbale, şot'oğo içincə ölkinəxun şəp'eğale». ");
INSERT INTO udi_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Oşa Buxačuğon Moiseya pine: «Zu Q'ončuxzu. ");
INSERT INTO udi_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Zu Avrahama, İsaak'a saal İak'ova Bitova Bacarbala Buxačux k'inək'ez ak'eśi, ama Həmişə Bakalo s'iyen Za şot'oğo tez çalxest'ey. ");
INSERT INTO udi_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Zu şot'oğoy q'ərib k'inək' yəşəyinşi ölkinə - Kənan oç̌ala içoğo tast'eynak' şot'oğoxun irəziluğez ğaç̌eśi. ");
INSERT INTO udi_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Həysəəl misirluğon k'ul k'inək' əşp'est'ala israilluğoy şivana ibaki Bezi şot'oğoxun ğaç̌eśi irəziluğa eyexezbadi. ");
INSERT INTO udi_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Kot'o görəl israilluğo upa: \"Zu Q'ončuxzu. Və̌x misirluğoy zülüməxun çark'est'oz, və̌x yüke oq'axun c'evk'oz, Bezi kula boxodi, şot'oğo bı̌hi caza tadi və̌x çark'est'oz. ");
INSERT INTO udi_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Və̌x Bezi c'ək'p'i azuk' booz, ef Buxačux bakoz. T'e vədə avabakalnan ki, və̌x misirluğoy zülüməxun çark'est'iyo ef Buxačux Q'ončux Zuzu. ");
INSERT INTO udi_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Zu Avrahama, İsaak'a saal İak'ova elasp'i əyit tadi oç̌ala və̌x taşeri, t'iyana və̌x mülk k'inək' tadoz. Zu Q'ončuxzu\"». ");
INSERT INTO udi_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moiseyen mot'o israilluğo p'ap'esebi. Ama şorox urufaxun bitet'uniy, əzyəti boş baksunaxun Moiseya saal ǔmǔx tet'un laxi. ");
INSERT INTO udi_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","T'e vədə Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Misiri padçağ faraoni t'ǒğǒl taki. Şot'o upa ki, israilluğo ölkinəxun tərbeq'an!» ");
INSERT INTO udi_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moiseyen isə Q'ončuğo pine: «İsrailluğon za tet'un ǔmǔxlaxsasa, faraonen za ǔmǔxlaxale? Sa yönbəri əyitp'esal tez baksa». ");
INSERT INTO udi_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Q'ončuğon isə Moiseyaxun q'a Aaronaxun israilluğoy saal Misiri padçağ faraoni barada əyitp'i əmirxone tadi ki, israilluğo Misiri oç̌alaxun c'evk'at'un. ");
INSERT INTO udi_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","İsrailluyox mot'oğoxune əmələ hare: İsraili süft'in ğar Ruveni ğarmux: Xanok', P'allu, Xesron saal K'armi. Ruvenaxun bakiyorox moroxey. ");
INSERT INTO udi_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeoni ğarmux: Yemuel, Yamin, Oxad, Yak'in, Sohar saal kənanlu çuğoxun baki ğar Şaul. Simeonaxun bakiyorox moroxe. ");
INSERT INTO udi_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levin ğarmoğoy s'iyurxo kalat'uxun burqi mis'ik't'ul śirik' metəre: Gerşon, K'ohat' saal Merari. Levi sabaç̌ otuz vǔğ usene yəşəyinşe. ");
INSERT INTO udi_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerşoni ğarmux: Livni q'a Şimey saal şot'oğoxun bakiyorox. ");
INSERT INTO udi_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","K'ohat'i ğarmux: Amram, Yiśar, Xevron saal Uzziel. K'ohat' sabaç̌ otuz xib usene yəşəyinşe. ");
INSERT INTO udi_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarin ğarmux: Maxli q'a Muşi. Morox bütüm kalat'uxun burqi mis'ik't'ul śirik' Levin nəsile. ");
INSERT INTO udi_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramen iz dəə Yok'eveda içeynak' çuuxe haq'i, Yok'evedenal şot'aynak' Aarona q'a Moiseyane eçeri. Amram sabaç̌ otuz vǔğ usene yəşəyinşe. ");
INSERT INTO udi_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yiśari ğarmux: Gorax, Nefek' saal Zik'ri. ");
INSERT INTO udi_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzzieli ğarmux: Mişael, Elsafan saal Sift'i. ");
INSERT INTO udi_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaronen Naxşoni xunçi bakala Amminadavi xuyər Elişevane haq'i, Elişevanal şot'aynak' Nadava, Avihuna, Eleazara saal İt'amarane eçeri. ");
INSERT INTO udi_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Goraxaxun bakiyorox moroxe: Assir, Elk'ana saal Aviasaf. Goraxi əsil moroxe. ");
INSERT INTO udi_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaroni ğar Eleazaren Put'ieli xuyərmoğoxun sunt'une haq'i, şot'inal içeynak' P'inexasane eçeri. Metərluğen, Levi uk'ala tayfa mot'oğoxun əmələ hare. ");
INSERT INTO udi_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Me Aaron q'a Moisey Q'ončuğon içoğo «israilluğo dəst'inen Misiri oç̌alaxun c'evk'anan» pi Aaron q'a Moiseye. ");
INSERT INTO udi_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Morox hat'e israilluğo Misiri oç̌alaxun c'evkseynak' Misiri padçağ faraonaxun exlətp'i Moisey q'a Aaroney. ");
INSERT INTO udi_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Misiri oç̌ala Q'ončuğon Moiseyaxun exlətp'ala vədine ");
INSERT INTO udi_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Şot'in Moiseya pine: «Zu Q'ončuxzu, Zu va uk'ala əyitmoğo bitova Misiri padçağ faraona upa». ");
INSERT INTO udi_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moiseyen isə Q'ončuğo pine: «Zu yönbəri əyitp'esal tez baksa, faraonen za ǔmǔxelaxon ki?» ");
INSERT INTO udi_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Q'ončuğon Moiseya pine: «Hun faraona Bez əyitmoğo p'ap'esp'alnu, vi viçi Aaronen vi gala me əyitmoğo uk'ale. ");
INSERT INTO udi_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Zu va tadala əmirxo vi viçi Aarona exlətp'a. Şot'inal faraonaq'an pi ki, israilluğo iz ölkinəxun tərbeq'an. ");
INSERT INTO udi_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Zu isə faraona inadkər boz. Misiri oç̌ala gele Bez nišanxo ak'est'i q'a möcüzoox bayizal, ");
INSERT INTO udi_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","faraonen və̌x ǔmǔx tene laxal. T'e vədə Zu Bez kula Misiri oç̌ala boxodi bı̌hi cazoox yaq'abi Bezi q'oşuna - Bezi azuk' bakala israilluğo t'et'iin c'evk'oz. ");
INSERT INTO udi_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Bez kula Misiri oç̌ala boxodi israilluğo şot'oğoy kiyexun çark'est'ala vədine misirluğon avabakalt'un ki, Q'ončux Zuzu!» ");
INSERT INTO udi_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Q'ončuğon Moiseya q'a Aarona hetər əmirebisa, şot'oğon t'etərəl bit'un. ");
INSERT INTO udi_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Faraonaxun exlətp'ala vədine Moiseyi səksən, Aaroni isə səksən xib yəşoy. ");
INSERT INTO udi_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Faraonen və̌x \"za vědest'eynak' sa möcüzə ak'est'anan\" uk'at'an, hun, Moiseyen Aarona upa: \"Vi çombağa ext'i faraoni běš oq'a bosa ki, dizik'əq'an fırıpi\"». ");
INSERT INTO udi_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Metərluğen, Moisey q'a Aaron faraoni t'ǒğǒl hari Q'ončuğon hetər əmirbeneysa, t'etərəl bit'un. Aaronen iz çombağa faraoni saal şot'ay sarayi amdarxoy běš oq'ane bosi, çombağal dizik'əne fırıpi. ");
INSERT INTO udi_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Faraonen isə misirlu sehirbazxo q'a cadubalxone k'alpi. Şot'oğonal içoğoy sehirbazluğen hat'etər bit'un. ");
INSERT INTO udi_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Hərt'in iz çombağa oq'a bosi dizik'əne fırıdi, ama Aaroni çombağen şot'oğoy çombağxo q'uc'epi. ");
INSERT INTO udi_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ama Q'ončuğon pi k'inək' faraonen hələl inadkərluğebsay, şot'oğo ǔmǔx tene laxsay. ");
INSERT INTO udi_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","T'e vədə Q'ončuğon Moiseya pine: «Faraonen iz uk'alt'une bsa, azuk'a tərbsun tene çuresa. ");
INSERT INTO udi_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Əyc'ə savaxt'an faraon oqe tərəf tağat'an iz běš c'eki. Dizik'ə fırık'ala çombağal vi kiyel ext'i, şot'o Nil oqe börine yaq'běğa. ");
INSERT INTO udi_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Oşa faraona upa: \"Q'ončuğon, əbraniğoy Buxačuğon za vi t'ǒğǒle yaq'abi ki, va İzi <Bezi azuk'a tərba ki, ams'i oç̌ala taśi Za bul k'os'bat'un!> əyitə p'ap'esp'az. Ama hun hələl Şot'ay uk'alt'u ten bsa. ");
INSERT INTO udi_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Kot'o görəl Q'ončuğon metəre nex: <İsə avabakalnu ki, Q'ončux Zuzu>. Mone, zu bezi kiyel bakala çombağa Nil oqe xena duğoz, xeyal p'iya tarak'ale. ");
INSERT INTO udi_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Oqnul bakala çəliyox k'as'eğale, oq adbaft'ale, misirluğonal oqe xenaxun ǔğěs tet'un bakal\"». ");
INSERT INTO udi_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Q'ončuğon Moiseya pine: «Aarona metər upa: \"Çombağa ext'a, vi kula Misiri oç̌ala bakala bütüm xenurxoy - oqurxoy, arxurxoy, gölürxoy, hovuzxoy loxol boxoda ki, bütüm xeyur p'iyaq'an tarapi.\" Misiri oç̌ala p'iyen haq'ale, hər gala p'i bakale! Lap durut'i q'a ǰěne q'avurxoy boşal». ");
INSERT INTO udi_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moisey q'a Aaronen Q'ončuğon içoğo hetər əmirbeneysa, hat'etərəl bit'un. Aaronen çombağa faraoni q'a şot'ay sarayi amdarxoy piin běš alabi Nil oqe xena duneği. Oqe xeyal bito p'iyane tarapi. ");
INSERT INTO udi_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Oqnul bakala çəliyox k'as'eśi, oq adebaft'i, misirluğonal t'e xena ǔğěs tet'un baksay. Misiri oç̌ala hər gala p'iney. ");
INSERT INTO udi_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ama Misiri sehirbazxonal içoğoy sehirbazluğen hametər bit'un. Faraonal Q'ončuğon pi k'inək' lap inadkəre baki. Şot'in Moiseya q'a Aarona p'urum ǔmǔx tene laxi. ");
INSERT INTO udi_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Şo fırıpi iz sarayane taśi, me əşləl sal fikir tene tadi. ");
INSERT INTO udi_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misirluğon isə xe c'evkseynak' Nil oqe börine kərizxot'un kašpsa burqi, şot'aynak' ki, oqe xena ǔğsun mümkün teney. ");
INSERT INTO udi_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Q'ončuğon Nil oqeynak' caza yaq'abit'uxun oşa vǔğ ği c'ovaneki. ");
INSERT INTO udi_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Oşa Q'ončuğon Moiseya pine: «Faraoni t'ǒğǒl taśi şot'o upa: \"Q'ončuğon metəre nex: <Bezi azuk'a tərba ki, Za bul k'os'bane! ");
INSERT INTO udi_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Əgər hun Bezi azuk'a tərbsun nu çureğayin, Zu dirist' vi oç̌ala bědalaq'xon buyboz. ");
INSERT INTO udi_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Oq bědalaq'xon q'aynayinşale, t'et'iin c'eri vi saraya, bask'ala otağa, bask'ala gala tarak'alt'un, sarayi amdarxoy q'a vi azuk'i k'ojurxo, vi tarinxoy q'a boq'oyin t'ap'ak'i boş bağalt'un. ");
INSERT INTO udi_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Vi, vi azuk'i saal bütüm vi sarayi amdarxoy loxol bědalaq'xo lağale>\"». ");
INSERT INTO udi_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Q'ončuğon saal Moiseya pine: «Aarona metər upa: çombağa ext'a, vi kula oqe loxol, arxurxoy saal gölürxoy loxol boxoda. Barta Misiri oç̌al bědalaq'xon buybakeq'an». ");
INSERT INTO udi_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaronen iz kula Misiri oç̌ala bakala xenurxoy loxol boxonedi, t'et'iinal bědalaq'xone c'eri. Dirist' Misiri oç̌al şot'oğoxun buyebaki. ");
INSERT INTO udi_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ama sehirbazxonal içoğoy sehirbazluğen hametərt'un bi. Şot'oğonal Misiri loxol bědalaq'xot'un eçeri. ");
INSERT INTO udi_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Faraonen Moiseya q'a Aarona k'alpi pine: «Q'ončuğo xoyinšbanan ki, bezi q'a bez azuk'i belxun bědalaq'xo iradbeq'an, t'e vədə zuval ef azuk'a Q'ončuğoynak' q'urban eşt'a tərezbon». ");
INSERT INTO udi_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moiseyen faraona pine: «Upa běyn vi ük'en hevaxt'e çuresa ki, zu beş Buxačuğoxun xoyinšbi va, vi sarayi amdarxo saal vi azuk'a me bědalaq'xoxun çark'est'az? Mot'oxun oşa saycə oqe boş bakala bědalaq'xo mandale». ");
INSERT INTO udi_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Faraonen pine: «Əyc'ə». Moiseyenal coğabe tadi: «Vi pi k'inək' bakale. Kot'oxun avabakalnu ki, Buxačux Q'ončux k'inək'o butene! ");
INSERT INTO udi_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Bědalaq'xo vaxun, vi k'ojurxoxun, vi sarayaxun saal vi azuk'axun ə̌xilbakalt'un, şorox saycə oqe boş mandalt'un». ");
INSERT INTO udi_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moisey q'a Aaron faraoni t'ǒǒxun c'ert'un. Moiseyen Q'ončuğo faraoni loxol yaq'abi bědalaq'xo əfçibseynak' xoyinšebi. ");
INSERT INTO udi_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Q'ončuğonal Moiseyi xoyinša inebaki. K'ojurxo, məəloğo, çöle bakala bütüm bědalaq'xo k'as'eśi. ");
INSERT INTO udi_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Mundarbay bědalaq'xo girbi topt'unbsay, dirist' ölkəl adebaft'i. ");
INSERT INTO udi_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ama faraonen ak'at'an ki, me bəlinəxun iz elmux çarek'i, şot'in Q'ončuğon pi k'inək'əl Moiseya q'a Aarona nu ǔmǔxlaxi p'urum inadkərluğebi. ");
INSERT INTO udi_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","T'e vədə Q'ončuğon Moiseya pine: «Aarona upa ki, çombağa boxodi oç̌ali toza duğeq'an. Bütüm Misiri oç̌ali tozal fırıpi mos'ak' bakale.». ");
INSERT INTO udi_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Şot'oğon hat'etərəl bit'un. Aaronen iz kiyel bakala çombağa boxodi oç̌ali toza duneği, mos'ak'xoval amdarxoy q'a heyvanxoy loxole lavabaki. Bütüm Misiri ölkinə oç̌ali toz fırıpi mos'ak'e baki. ");
INSERT INTO udi_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Sehirbazxonal içoğoy sehirbazluğen mos'ak'xot'un eşt'un çureśi, ama mot'o tet'un bacarbi. Mos'ak'xon amdarxo q'a heyvanxo haq'layinşebsay. ");
INSERT INTO udi_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","T'e vədə sehirbazxon faraona pit'un: «Me əşləst'a Buxačuğoy kulo». Ama Q'ončuğon pi k'inək' faraonen p'urum inadkərluğbi ǔmǔx tene laxi. ");
INSERT INTO udi_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","T'e vədə Q'ončuğonMoiseya pine: «Savaxt'an üşenen hayza. Faraon oqe tərəf tağat'an p'urum şot'ay běš c'eri metər upa: \"Q'ončuğon metəre nex: Bezi azuk'a tərba ki, Za bul k'os'bane! ");
INSERT INTO udi_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Əgər hun şot'oğo nu tərbayin, vi, vi sarayi amdarxoy, vi azuk'i loxol saal k'ojurxoy boş sürünen t'at'urxo yaq'aboz. Misirluğoy k'ojurxo, dirist' oç̌alal t'at'urxon buybakale. ");
INSERT INTO udi_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ama t'e ği Bezi azuk' yəşəyinşala Goşen oç̌ala sa t'at'al tene bakal! Mot'oxun avabakalnu ki, me ölkinə Q'ončux Zuzu. ");
INSERT INTO udi_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Vi azuk'i q'a Bezi azuk'i arane fərg laxoz. Me möcüzə əyc'ə bakale\"». ");
INSERT INTO udi_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Q'ončuğon hametərəl bine. Faraoni saraya, sarayi amdarxoy k'ojurxo, bütüm Misiri oç̌ala t'at'urxoy sürünen ç̌axepi. T'at'e sürün kiyexun ölkə vərəne baksay. ");
INSERT INTO udi_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Faraonen Moiseya saal Aarona iz t'ǒğǒl k'alpi pine: «Takinan, ef Buxačuğoynak' q'urban eçanan, ama me ölkinə - Misirə». ");
INSERT INTO udi_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moiseyen isə pine: «Yan metər bes teyan bakon. Axıri beşi Buxačux bakala Q'ončuğoynak' q'urban šampsun misirluğoynak' irit'p'un sa şeye! Misirluğoy piin běš me q'urbana šamk'ayan, yax ǰělayinşalt'un. ");
INSERT INTO udi_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Təə, yan beşi Buxačux bakala Q'ončuğoynak' İz pi k'inək', memiin c'eri ams'i oç̌ala xib ğiluğ yaq' taśi t'et'iya q'urban eçalayan». ");
INSERT INTO udi_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faraonen pine: «Zu və̌x ef buxačux bakala Q'ončuğoynak' q'urban eşt'eynak' tərboz! Ama gele ə̌xil ma takinan. Zaynak'al xoyinšbanan!» ");
INSERT INTO udi_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moiseyen pine: «Zu vi t'ǒǒxun c'eğala k'inək' afırık'oz ki, Q'ončuğonəyc'ə va, vi sarayi amdarxo saal vi azuk'a me t'at'urxoxun çark'est'ane. Ama barta faraonenal ene camaata q'a yax \"takinan, Q'ončuğoynak' q'urban eçanan\" pi, oşa əfçi maq'an duği». ");
INSERT INTO udi_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hametər, Moiseyen faraoni t'ǒǒxun c'eri Q'ončuğo xoyinšebi. ");
INSERT INTO udi_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Q'ončuğonal Moiseyi xaişə bex p'ap'esebi. Şot'in faraona, şot'ay sarayi amdarxo saal şot'ay azuk'a t'at'urxoxun çark'esedi. Sa dənəl t'at' tene mandi. ");
INSERT INTO udi_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ama me dönəl faraonen p'urum inadkərluğebi, azuk'a tene tərbi. ");
INSERT INTO udi_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","T'e vədə Q'ončuğon Moiseya pine: «Faraoni t'ǒǒx taki şot'o upa: \"Q'ončuğon, əbraniğoy Buxačuğon metəre nex: \"Bezi azuk'a tərba ki, Za bulq'at'un k'os'bi! ");
INSERT INTO udi_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Əgər hun şot'oğo p'urum nu tərbi efayin, ");
INSERT INTO udi_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Q'ončuğoy kulen vi çöle bakala heyvanxoynak' - ěkurxoynak', elemxoynak', buşurxoynak', belineynak' saal eğel-keçiğoynak' k'as'esun eçale. ");
INSERT INTO udi_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ama Q'ončuğon israilluğoy heyvanxoy q'a misirluğoy heyvanxoy arane fərg laxale. İsrailluğoy heyvanxoxun sayco tene əfçibakal\"». ");
INSERT INTO udi_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Q'ončuğon vaxt' təyinbi pine: «Q'ončuğon mot'o me ölkinə əyc'ə bale». ");
INSERT INTO udi_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Əyc'indəri Q'ončuğon hametərəl bine. Misirluğoy bütüm heyvanxo k'as'eśi. Ama israilluğoy heyvanxoxun sayco tene əfçibaki. ");
INSERT INTO udi_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraonen amdar yaq'abi avanebaki ki, israilluğoy heyvanxoxun həgigiyal sayco tene əfçibake. Ama şot'in p'urum inadkərluğbi azuk'a tene tərbi. ");
INSERT INTO udi_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Q'ončuğon Moiseya q'a Aarona pine: «Buxarinaxun hərt'in sa q'ošamağ jeq' ext'anan. Barta Moiseyen şot'o faraoni piin běš havinaq'an muşadi. ");
INSERT INTO udi_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Şot'ay tozen dirist' Misiri oç̌ala haq'layinşale, amdarxoy q'a heyvanxoy loxolal marbiq'i çibanxo c'eğale». ");
INSERT INTO udi_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Metərluğen, şot'oğon buxarinaxun jeq'a ext'i faraoni běš çurt'unpi. Moiseyen jeq'a havinane muşadi, amdarxoy q'a heyvanxoy bədəneyal marbiq'i çibanxone c'eri. ");
INSERT INTO udi_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Sehirbazxoval Moiseyi běš çurpes tet'un baki, şot'aynak' ki, içoğoy bədənəl, bütüm misirluğoy bədənə haq'i k'inək', çibanxon haq'eney. ");
INSERT INTO udi_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ama Q'ončuğon Moiseya pi k'inək'e baki: Q'ončuğon faraona inadkərebi, faraonenal Moiseya q'a Aarona tene ǔmǔxlaxi. ");
INSERT INTO udi_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Q'ončuğon Moiseya pine: «Əyc'ə savaxt'an üşenen hayza, faraoni t'ǒǒx taśi şot'o metər upa: \"Q'ončuğon, əbraniğoy Buxačuğon metəre nex: Bezi azuk'a tərba ki, Za bul k'os'bane! ");
INSERT INTO udi_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tene, Zu me dönə vi loxol, vi azuk'i loxol, vi sarayi amdarxoy loxol bı̌hi q'azoox yaq'aboz. Mot'oxun avabakalnu ki, bütüm dünyəne Zallarik'o butene. ");
INSERT INTO udi_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Zu həysə çureğayiz, Bezi kula boxodi vi saal vi azuk'i loxol t'etər sa k'as'esunez yaq'abon ki, oç̌ali ç̌oyexun ef tume əfçibakon. ");
INSERT INTO udi_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ama va şot'aynak'ez q'orişi efsa ki, Bezi zora va ak'est'az, Bezi s'i bütüm dünyəne bayanbakane. ");
INSERT INTO udi_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Hun isə hələl Bezi azuk'i běšinə̌mə bot'est'i şot'o ten tərbsa! ");
INSERT INTO udi_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mone, Zu əyc'ə me vədine gele zorba sa təər yaq'aboz: t'etər sa təər ki, Misiren iz binora laxeśit'uxun mağay metəro tene ak'e. ");
INSERT INTO udi_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Həysə isə vi heyvanxo saal çöle bakala hər şeya bona badest'a, şot'aynak' ki, qavuna bakala bütüm amdarxoy saal heyvanxoy loxol t'etər sa təər barale ki, şorox bütüm k'as'eğalt'un\"». ");
INSERT INTO udi_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Faraoni sarayi amdarxoy boşt'an Q'ončuğoy əyitəxun q'ǐbit'oğon içoğoy k'ulurxo saal heyvanxo usum eçeri bonat'un badi. ");
INSERT INTO udi_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Q'ončuğoy əyitə nu fikir tadit'oğon isə içoğoy k'ulurxo q'a heyvanxo çöle et'unfi. ");
INSERT INTO udi_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Q'ončuğon Moiseya pine: «Vi kula alaba. Barta dirist' Misiri oç̌ala - t'et'iya bakala amdarxoy, heyvanxoy saal bütüm çöle bakala bit'k'iğoy loxol təərq'an bari». ");
INSERT INTO udi_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moiseyen iz çombağa göynule alabi. Q'ončuğonal göyen gürubsun q'a təəre yaq'abi, s'ə̌q'ene duği; Q'ončuğon Misiri oç̌ali loxol təəre śipi. ");
INSERT INTO udi_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Metərluğen, gele ost'aar sa təəre barst'ay, s'ə̌q'ene duğsay; misirluğon içoğoy tarixast'a metər təər atet'unkey. ");
INSERT INTO udi_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Təəren bütüm Misiri oç̌ala amdarxoxun burqi çöle bakala bitk'iğol śirik' hər şeya əfçinebi. Çöle bakala bütüm oyurxo t'ap'epi, xodurxoval xoxebi. ");
INSERT INTO udi_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Saycə israilluğoy yəşəyinşala Goşen oç̌ala təər tene bari. ");
INSERT INTO udi_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","T'e vədə faraonen Moiseya q'a Aarona iz t'ǒğǒl k'alpest'i şot'oğo pine: «Me dönə günaxez əşp'est'i! Q'ončux düzgüne, zu q'a bez azuk' isə haq'suzyan. ");
INSERT INTO udi_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Q'ončuğo xoyinšbanan ki, me dəhşətlü s'ə̌q' q'a təər çurpeq'an. Və̌x tərezbsa, takinan, ene və̌x memiya efal butene!» ");
INSERT INTO udi_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moiseyen şot'o pine: «Şəhərexun c'eğala k'inək' bezi kula Q'ončuğoç alabi afırık'oz s'ə̌q'al çurk'ale, təərəl ene tene baral. Metər avabakalnu ki, dirist' dünyə Q'ončuğoye. ");
INSERT INTO udi_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ama zu avazu ki, hun saal vi sarayi amdarxon hələl Q'ončuğoxun tenan q'ǐbsa». ");
INSERT INTO udi_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Təəren kətana q'a muya əfçibeney, şot'aynak' ki, t'e vədə muyen bul c'eq'ala, kətani isə s'is'ik' qayk'ala vədəney. ");
INSERT INTO udi_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ama arum q'a cir arum tene əfçibakey, şot'aynak' ki, morox samal c'əyine p'ap'sa.) ");
INSERT INTO udi_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisey faraonaxun cöybaki şəhərexun c'erit'uxun oşa iz kula Q'ončuğoç alabi afırınepi. S'ə̌q'en duğsun q'a təər hat'e dayğa bot'ebaki, ağalal çurepi. ");
INSERT INTO udi_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Faraonen ağalin, s'ə̌q'en duğsuni q'a təəri bot'baksuna ak'ala k'inək' p'urumal günaxe əşp'est'i: şot'in q'a iz sarayi amdarxon inadkərluğt'unbsay. ");
INSERT INTO udi_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Metərluğen, Q'ončuğon Moiseya pi k'inək', faraonen p'urum inadkərluğbi israilluğo tərbsun tene çureśi. ");
INSERT INTO udi_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Oşa Q'ončuğon Moiseya pine: «Faraoni t'ǒǒx taki. Zu faraona q'a şot'ay sarayi amdarxo inadkər bezu. Mo şot'aynak'e ki, Zu şot'oğo Bezi möcüzoğo ak'est'azax. ");
INSERT INTO udi_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Mo şot'aynak'e ki, və̌n Bezi misirluğo turnoq'a saksuna q'a şot'oğo ak'est'i möcüzoğo ef əyloğo saal nəvoğo exlətp'anan, Q'ončux Zu baksunal avabakanan». ");
INSERT INTO udi_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Metərluğen, Moisey q'a Aaron p'urum faraoni t'ǒǒx hari şot'o pit'un: «Q'ončuğon, əbraniğoy Buxačuğon, metəre nex: \"Heq'ədər metər bi Bezi běš vi bač'ana ten k'os'bal? Bezi azuk'a tərba, Za bulq'an k'os'bi! ");
INSERT INTO udi_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Əgər hun Bezi azuk'a nu tərbayin, Zu əyc'ə vi ölkinə çərtk'ənxo yaq'aboz. ");
INSERT INTO udi_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Çərtk'ənxon oç̌ali ç̌oya t'etər but'k'ale ki, sal oç̌al tene ak'eğal. Təərəxun oşa mandi sa p'ə̌ göyinəl şot'oğon ukalt'un, çöle bakala xodurxol śirik'! ");
INSERT INTO udi_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Şorox hari vi k'ojurxo, vi sarayin amdarxoy saal bütüm misirluğoy k'ojurxo buybakalt'un. Metər şey nə ef bavoğon, nəəl kalboğon me oç̌ala məsk'ən saki ğinaxun mağay tet'un ak'ey\"». Oşa Moisey fırıpi faraoni t'ǒǒxun c'ere. ");
INSERT INTO udi_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Faraoni sarayi amdarxon isə içu pit'un: «He vaxt'al śirik' me amdari kiyexun me koruğxo zap'k'alyan? Me amdarxo tərba, barta taśi içoğoy buxačux bakala Q'ončuğo bulq'at'un k'os'bi. Yəni atenksa ki, Misir əfçinebaksa?» ");
INSERT INTO udi_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","T'e vədə Moiseya q'a Aarona p'urum faraoni t'ǒğǒlt'un k'alpi. Faraonen şot'oğo pine: «Takinan, ef buxačux bakala Q'ončuğo bul k'os'banan. Ama upanan běyn ef boşt'an şu tağala?» ");
INSERT INTO udi_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moiseyen pine: «Yan cəyil-q'oja bütüm tağalyan! Beşi ğarmoğoxun q'a xuyərmoğoxun sagala. Yaxun beşi eğel-keçiğo q'a çururxoval ext'alyan, şot'aynak' ki, Q'ončuğoy s'iyal axsibay balayan!» ");
INSERT INTO udi_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faraonen şot'oğo pine: «Q'ončuxhəgigiyal və̌xune buq'on ki, Zu və̌x hevaxtsa çupux-əyloğoxun sagala tərbaz! Efi mani fikiren c'eysun hameyin ak'esa! ");
INSERT INTO udi_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ama mo bakalatene! Q'ončuğobul k'os'bsun çurnansa, tək işq'arxon takinan k'ə lazımesa banan!» Oşal Moiseya q'a Aarona t'et'iin şəp't'unśi. ");
INSERT INTO udi_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","T'e vədə Q'ončuğonMoiseya pine: «Vi kula Misiri oç̌ali loxol boxoda. Barta Misiri oç̌ala çərtk'ənxon hücümbeq'an, təərəxun oşa mandi bütüm bitk'iğo kəyeq'an». ");
INSERT INTO udi_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moiseyenal iz çombağa Misiri oç̌ali loxole boxodi. Q'ončuğon dirist' sa ği q'a sa üşe běğ c'eğala tərəfəxun eğala muşe yaq'abi. Savaxt'an me muşen içuxun çərtk'ənxone eçeri. ");
INSERT INTO udi_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Çərtk'ənxon Misirə haq'layinşt'unbi, şorox dirist' Misiri oç̌ala yəymişt'unbaki. Şorox t'eq'ədər gelet'uniy ki, meq'ədər sal sa vədine tene bakey, mot'oxun oşal tene bakal. ");
INSERT INTO udi_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Çərtk'ənxo hari t'etəre buybay ki, sal oç̌al tene ak'esay. Şot'oğon ölkinə bakala bütüm bitk'iğo q'a təərəxun oşa mandi bütüm meyvoğo kəyt'un. Dirist' Misiri oç̌alal nə xodurxoy loxol sa dənə xazal, nəəl çöle sa dənə göyün tene mandi. ");
INSERT INTO udi_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraonen kap Moiseya q'a Aarona k'alpest'i şot'oğo pine: «Ef buxačux bakalaQ'ončuğoy q'a ef běš günaxez əşp'est'i. ");
INSERT INTO udi_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Sa kərəməl bezi günaxa bağışlayinşanan, ef buxačuxQ'ončuğo xoyinšbanan ki, me dəhşətlü bəlinə zaxun ə̌xilbeq'an». ");
INSERT INTO udi_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisey faraoni t'ǒǒxun c'eri Q'ončuğo xoyinšebi. ");
INSERT INTO udi_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Q'ončuğonal muşa fırıdi gele zorba běğ batk'ala tərəfəxun eğala muşe yaq'abi. Me muşen çərtk'ənxo fupi taşeri Č'oč'a dənizəne bapi, dirist' Misirəl sa dənə çərtk'ən tene mandi. ");
INSERT INTO udi_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ama Q'ončuğon faraona inadkəre bi, şot'inal israilluğo tene tərbi. ");
INSERT INTO udi_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Oşa Q'ončuğon Moiseya pine: «Vi kula göyəç boxoda. Barta Misiri oç̌ala zülmət, gip bayinq'luğq'an baki». ");
INSERT INTO udi_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moiseyenal iz kula ala, göyəçe boxodi, Misiri oç̌alal xib ği gip bayinq'luğe baki. ");
INSERT INTO udi_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Xib ği şuk'k'alen nə sun-suna ak'es tet'un baksay, nə içoğoy ganuxun galpes. İsrailluğoy yəşəyinşala ganxo isə işiğluney. ");
INSERT INTO udi_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","T'e vədə faraonen Moiseya k'alpest'i pine: «Takinan, Q'ončuğo bul k'os'banan. Ef əyloğoval ext'anan, ama eğel-keçin q'a belin sürü memiyaq'an mandi». ");
INSERT INTO udi_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moiseyen isə pine: «Hun yaxun beşi eğel-keçin q'a belin sürünəl tərbin buq'on, şot'aynak' ki, yan beşi Buxačux bakala Q'ončuğoynak' heyvanxo šampi bok'ospsuni q'urbanxo eçalayan. ");
INSERT INTO udi_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Beşi heyvanxoval yaxun tağalane: sa dənoval nu mandalane, şot'aynak' ki, beşi Buxačux bakala Q'ončuğoynak' şot'oğoxun q'urban eçalayan. Heyvanxoxun mat'ay Q'ončuğoynak'q'urban eşt'unal t'iya p'ap'it'uxun oşa avabakalyan». ");
INSERT INTO udi_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ama Q'ončuğon faraona inadkəre bi, şot'inal israilluğo tərbsun tene çureśi. ");
INSERT INTO udi_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Şot'in Moiseya pine: «İradbaka, eneyal bezi piyes ak'mayeki! Va saal ak'ayiz - biyalnu!» ");
INSERT INTO udi_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moiseyen pine: «Düzen nex, hun za ene ten ak'al». ");
INSERT INTO udi_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","T'e vədə Q'ončuğon Moiseya pine: «Faraoni q'a misirluğoy loxol sa cazal yaq'aboz. Mot'oxun oşa şot'in və̌x memiin tərbale, lap şəp'eğala bakale! ");
INSERT INTO udi_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Hun isə azuk'a upa ki, içoğoy boş k'ə işq'ar saal çuux bunesa, taśi içoğoy q'onşiğoxun q'ızıl-gümüşi şeyurxoq'at'un çureśi». ");
INSERT INTO udi_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Q'ončuğon t'etəre bey ki, misirluğon İz azuk'i loxol pis tet'un běğsay. Moiseya isə faraoni sarayi amdarxoy q'a adi camaati kala hörmət'oy. ");
INSERT INTO udi_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Metərluğen, Moiseyen faraona pine: «Q'ončuğon metəre nex: \"Üşeni qı̌t'ust'a Zu Misiri oç̌alaxun c'ovakoz, ");
INSERT INTO udi_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Misirə bakala bütüm süft'in ğar əyloxal biyale. Taxt'a arśi faraoni ğaraxun burqi kiin ding əşp'est'ala çuux nökəri ğaral śirik'. Heyvanxoyal süft'in ərkəy baloox biyale. ");
INSERT INTO udi_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Dirist' Misiri oç̌alaxun t'etər sa şivan c'eğale ki, metəro baki tene, bakalal tene. ");
INSERT INTO udi_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ama israilluğoy q'a içoğoy heyvanxoy loxol sa xə̌yenal tene bə̌pk'al\". T'e vədə avabakalnan ki, Q'ončuğon israilluğoy q'a misirluğoy arane hetər fərge laxe. ");
INSERT INTO udi_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Bütüm me vi sarayi amdarxo bezi t'ǒǒx eğalt'un, bezi běš çökt'i xoyinšbalt'un ki, zuval, bezi azuk'al ef ölkinəxun c'eri tağayan! Mot'oxun oşa zu c'eğoz». Mot'oğo pi Moisey gele əcuğlu faraoni t'ǒǒxun c'ere. ");
INSERT INTO udi_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Q'ončuğon Moiseya \"faraonen və̌x ǔmǔx tene laxal, Zuval t'e vədə Misiri oç̌ala Bezi möcüzoğo geleboz\" peney. ");
INSERT INTO udi_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moiseyen q'a Aaronen bütüm me möcüzoğo faraoni běš ak'est'et'uniy. Ama Q'ončuğon faraona inadkər beney, şot'inal israilluğo iz oç̌alaxun tene tərbsay. ");
INSERT INTO udi_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Moisey q'a Aaron hələ Misirə bakat'an Q'ončuğon şot'oğo pine: ");
INSERT INTO udi_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Me xaş və̌ynak' bütün xaşurxoxun üst'ün bakale - useni süft'in xaş bakalane. ");
INSERT INTO udi_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Bütüm israilluğoxun bakalt'oğo upanan: me xaşe vis'imci ğine hər işq'aren iz k'ojeynak' sa q'uzi nəəl çəpişq'an c'ək'p'i ext'i, hər külfətə sa heyvan. ");
INSERT INTO udi_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Əgər sa heyvan sa külfəti amdarxoynak' gelenesa, t'e vədə iz ı̌ša q'onşinaxun sagalaq'an sa heyvan ext'i. Şi heq'ədər uksunal hesabbeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Heyvan sa usenin, salamat, ərkəy heyvan bakalane. Mot'oğo eğelxoy nəəl ki keçiğoy baloğoxunnan c'ək'p'es bakon. ");
INSERT INTO udi_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Şot'o me xaşe bip'es's'emci ğinal śirik' běğanan, biyəsindəər isə israilluğoxun bakalt'oğoy bütümt'in içoğoy heyvana šampeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Oşa şot'ay p'iyaxun ext'i, t'e heyvan mani k'oya ukeğalesa, t'e k'ojin ç̌omoy p'ə̌ t'ǒğin daxt'ak'al, alin alatal lə̌ə̌mdeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Yeq'a hat'e üşe, aruğoy loxol ap'esp'i, ə̌yinsuz šumen saal ağu göyinen kəyit'un buq'on. ");
INSERT INTO udi_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Şot'o bic'i nəəl xene boş ǰaldi ma ukanan, bulaxun, turmoğoxun saal çalataxun sagala aruğoy loxol ap'esp'i ukanan. ");
INSERT INTO udi_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Şot'oxun savaxt'ineynak' sa şey ma efanan, mandayin isə, savaxt'an bok'osp'anan. ");
INSERT INTO udi_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Şot'o metər ukanan: efi bı̌ğ ğaç̌, torok'al turel, çombağ isə kiyelq'an baki. Şot'o kap ukanan ki, c'eyseynak' həzir bakanan. Mo Q'ončuğoyC'ovaksuni axsibayi ukune. ");
INSERT INTO udi_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Zu isə hat'e üşe misirluğoy loxol eğoz, şot'oğoy süft'in ğarmoğoval, heyvanxoy süft'in ərkəy baloğoval besp'oz. Zu Misiri bütüm buxačuxxo caza tadoz. Q'ončux Zuzu. ");
INSERT INTO udi_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ef yəşəyinşala k'ojurxoy loxol bakala p'i sa nišan bakale. Zu t'e p'iya ak'at'an ef k'ojurxoy t'ǒǒxun c'ovaki tağoz, Misiri loxol eğala me bəlinenal və̌x biq'alatene. ");
INSERT INTO udi_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Me ğina ef eyex efanan, şot'o və̌ynak' Q'ončuğoys'iyal c'ovakest'ala həmişəluğ sa axsibay banan. Şot'o nəsiləxun nəsilə c'ovakest'i və̌ynak' həmişəluğ bakala axsibay banan. ");
INSERT INTO udi_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Vǔğ ği ə̌yinsuz šum ukanan. T'e ğimxoy süft'in ğine ef k'ojurxoxun ə̌yinə əfçibanan. Me vǔğ ğinast'a ə̌yinla šum ukalt'ay tura israilluğoy aranexun bot'anan. ");
INSERT INTO udi_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Samci q'a vǔğǔmci ğine Za bul k'os'bseynak' giresunxoq'an baki. Me ğimxo hər sunt'in içeynak' ukun həzirbsunaxun q'erəz sal sa əş maq'an biq'i. ");
INSERT INTO udi_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Me Ə̌yinsuz Šume axsibaya c'ovakest'anan, şot'aynak' ki, hat'e ğine və̌x dəst'inen Misiri oç̌alaxun c'evezk'e. Barta me ğina c'ovakest'un nəsiləxun nəsilə c'ovaki və̌ynak' həmişəluğ q'aydaq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ə̌yinsuz šuma samci xaşe bip'es's'emci ğine biyəsəxun saq'o samci ğine biyəsəl śirik' ukalanan. ");
INSERT INTO udi_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Vǔğ ği ef k'oya ə̌yin nu bakalane. Ə̌yinla šum ukalt'ay, çuresa q'ərib, çuresa israillu, iz tur israilluğoy aranexun bot'eğalane. ");
INSERT INTO udi_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Sal sa ə̌yinla şey ma ukanan, ef yəşəyinşala hər sa gala ə̌yinsuz šum ukanan». ");
INSERT INTO udi_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Oşa Moiseyen israilluğoxun bakala bütüm ağsaq'q'alxo k'alpi pine: «Takinan, ef ailineynak' q'uzi nəəl çəpiş c'ək'p'i šampanan. Mo C'ovaksuni axsibayi q'urban bakale. ");
INSERT INTO udi_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Oşa sa çəngə issop uk'ala o ext'i ləəni boş girbi p'iya torpi, t'e p'iyen ç̌omxoy alin alata saal t'ǒğin daxt'ak'xo lə̌ə̌mdanan. Savaxal śirik' şuk'k'al iz k'oyaxun maq'an c'eri. ");
INSERT INTO udi_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Q'ončuğonal misirluğoynak' bisun yaq'abat'an ef ç̌omoy alin alati q'a hər p'ə̌ t'ǒğin daxt'ak'i loxol p'iya ak'i ç̌omoy t'ǒǒxun c'ovaki tağale. Şot'in bisun eçala angela ef k'ojurxo tene bark'al. ");
INSERT INTO udi_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mot'o və̌ynak' saal ef nəvə-nəticoğoynak' həmişəluğ sa q'ayda bi əməlbanan. ");
INSERT INTO udi_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Q'ončuğon və̌x əyit tadi oç̌ala p'ap'at'anal mot'o banan. ");
INSERT INTO udi_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ef əyloğon və̌xun \"me axsibayi məənə hik'ə?\" pi xavar haq'at'an ");
INSERT INTO udi_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","şot'oğo metər upanan: \"Mo Q'ončuğoyC'ovaksuni axsibayi q'urbane. Şot'in misirluğo besp'at'an israilluğo tene galdi, beş k'ojurxoy t'ǒǒxun c'ovaki taneśi\"». Azuk'enal çökt'i Q'ončuğo bule k'os'bi. ");
INSERT INTO udi_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","İsrailluğon Q'ončuğoy Moiseya q'a Aarona tadi bütüm əmirxo bit'un. ");
INSERT INTO udi_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Üşeni qǐt'ust'a Q'ončuğon Misiri oç̌ala bakalt'oğoy bütüm süft'in ğarmoğo besebi, taxt'a arśi faraoni süft'in ğaraxun burqi zindana bakalt'ay süft'in ğaral śirik'. Heyvanxoyal süft'in baloox murdarebay. ");
INSERT INTO udi_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","T'e üşe faraon, şot'ay sarayin amdarxo saal bütüm misirluyox hayt'unzeri. Misirəxun kala sa şivane c'eri, şot'aynak' ki, t'etər sa k'oj tenoy ki, t'et'iya biyal nu bakane. ");
INSERT INTO udi_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Hat'e üşe faraonen Moiseya q'a Aarona k'alpi pine: «C'ekinan takinan! Bito israilluğoval ext'i bezi azuk'axun ə̌xil bakanan! Takinan ef çureğalt'u banan, Q'ončuğo bul k'os'banan. ");
INSERT INTO udi_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ef pi k'inək', eğel-keçiğo q'a beliğo ext'i takinan. Zaal xeyir-bərəkət tadanan». ");
INSERT INTO udi_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirluğon israilluğo içoğoy ölkinəxun c'eysuna kapt'unst'ay. Şot'oğon next'uniy: «Tenesa bütüm biyalyan». ");
INSERT INTO udi_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Camaatenal ə̌yinsuz boq'oyi q'ava içoğoy paltari boş bəc'ürpi ə̌mnəbel taneşeri. ");
INSERT INTO udi_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","İsrailluğon Moiseyi əyitəl əməlt'unbi: misirluğoxun q'ızıli, gümüşi şeyurxo q'a paltart'un çureśi. ");
INSERT INTO udi_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Q'ončuğon t'etəre bi ki, misirluğon İz azuk'i loxol pis tet'un běği, şot'oğoy çureğalt'u tat'undi. Hametər, israilluyox kulbuy c'eri Misirluğo hik'k'alsuzt'un efi. ");
INSERT INTO udi_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Metərluğen, israilluyox Ramses şəhərexun c'eri Suk'k'ot' şəhəre turin yaq'at'un baft'i. Çupux-əyloğoxun q'erəz, saycə ǔqbaç̌ hazar tan işq'are buy. ");
INSERT INTO udi_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Şot'oğoxun sagala q'erəzəl gele amdarxo, içoğoy eğel-keçiğoy q'a belin sürüyoxal tanesay. ");
INSERT INTO udi_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Şot'oğon Misirəxun c'eğat'an içoğoxun ext'i ə̌yinsuz boq'oyaxun baldamacxot'un badi. T'e boq'oy ə̌yinsuz, ěqeśinut' boq'oyey, axıri şot'oğo Misirəxun şəp't'unsay, t'et'iya çurpi içoğoynak' ukun həzirbala vaxt' buteney. ");
INSERT INTO udi_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","İsrailluyox bip'baç̌ otuz useney ki, Misirət'uniy. ");
INSERT INTO udi_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Bip'baç̌ otuz usen tamam baki ğine Q'ončuğoy azuk' bakala israilluyox dəst'inen Misiri oç̌alaxun c'ert'un. ");
INSERT INTO udi_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","T'e üşe Q'ončuğoy pul İz azuk'i loxole baki! Şot'in israilluğo Misirəxune c'evksay. Şot'o görə israilluyoxal Q'ončuğoy me əşlə nu eyexun c'evksuna görə həmişə, nəsiləxun nəsilə c'ovaksunen me üşe nu bask'alat'un. ");
INSERT INTO udi_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Q'ončuğon Moiseya q'a Aarona pine: «C'ovaksuni axsibayi ukuni q'aydoox metəre: sal sa q'əriben me q'urbani yeq'axun maq'an kəyi. ");
INSERT INTO udi_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Haq'eśi k'ulen sünnət bakit'uxun oşa şot'o ukes banekon, ");
INSERT INTO udi_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ef arane yəşəyinşala q'ərib sa amdaren, nəəl və̌ynak' tənginen əşp'ala k'ulen isə şot'oxun maq'an kəyi. ");
INSERT INTO udi_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Me yeq'a k'oya ukanan, şot'o qavuna ma c'evk'anan, iz ǔq'ěnxoval ma xoxp'anan. ");
INSERT INTO udi_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Bütüm israilluğon me axsibaya c'ovakest'alat'un. ");
INSERT INTO udi_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ef arane yəşəyinşala, ama q'ərib bakala sunt'in Q'ončuğoy me axsibaya c'ovakest'un çureğayin isə, şot'ay külfətin boş bakala bütüm işq'arxo sünnətbakalane. T'e vədə şot'inal ef oç̌ala nanaxun baki sa amdar k'inək' me axsibaya c'ovakest'es banekon. Ama sünnətbakinut' sal sa işq'aren me axsibayi ukunaxun maq'an kəyi. ");
INSERT INTO udi_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Və̌ynak'al, ef t'ǒǒx yəşəyinşala q'əribxoynak'al k'anun sane». ");
INSERT INTO udi_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","İsrailluğon Q'ončuğon Moiseya q'a Aarona əmirbi k'inək' bit'un. ");
INSERT INTO udi_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Q'ončuğonal hat'e ği israilluğo Misirəxun dəst'inen c'evek'i. ");
INSERT INTO udi_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«İsrailluğoy nanaxun baki bütüm süft'in ğar əyloğo, heyvanxoyal baki bütüm süft'in ərkəy baloğo Za həsrbanan. Şorox Bezine». ");
INSERT INTO udi_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moiseyen camaata pine: «Q'ončuğon və̌x İzi zorba kiin Misirəxun, efi k'ul baki oç̌alaxun c'evk'i ğina eyex efanan. Me ğine ə̌yinla šum ma ukanan. ");
INSERT INTO udi_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Və̌n ğe, aviv xaşest'anan c'eysa. ");
INSERT INTO udi_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Q'ončuğon və̌x ef bavoğo əyit tadi elasp'i k'inək', kənanluğoy, xet'luğoy, emorluğoy, xivluğoy, yevusluğoy oç̌ala tadat'an, muč'anaq' q'a uč' barala t'e oç̌ala və̌x eçat'an, mot'oğo hər aviv xaşast'a əməlbanan: ");
INSERT INTO udi_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","vǔğ ği ə̌yinsuz šum ukanan, vǔğǔmci ğine isə Q'ončuğoy s'iyal axsibay c'ovakest'anan. ");
INSERT INTO udi_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","T'e vǔğ ğinast'a saycə ə̌yinsuz šum ukanan. Ef oç̌ala sal sa gala, şuk'k'alast'a nə ə̌yin, nəəl ə̌yinen həzirbaki şey nu bakalane. ");
INSERT INTO udi_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","T'e ğine vi əylə metər upa: \"Misirəxun c'eğala vədine Q'ončuğon zaynak' bit'u görəz mot'o bsa\". ");
INSERT INTO udi_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Barta me axsibaya c'ovakest'un və̌ynak' ef kiin saal ef k'odoğoy loxol bakala sa nišan k'inək'q'an baki ki, Q'ončuğoy tadi me buyruğ ef eyexun nu c'eğane. Axıri Q'ončuğon və̌x İzi zorba kiin Misirəxun c'evek'i. ");
INSERT INTO udi_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Usenaxun-usena və̌ynak' təyinbaki vədine me q'aydina əməlbanan. ");
INSERT INTO udi_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Q'ončuğon və̌x saal ef bavoğo əyit tadi elaspi k'inək' və̌x kənanluğoy oç̌ala eçat'an, t'iyana və̌x tadat'an ");
INSERT INTO udi_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bütüm süft'in nanaxun baki ğar əyloğo Q'ončuğohəsrbanan, ef heyvanxoy bütüm süft'in ərkəy baloxal Q'ončuğoyq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Elemi süft'in ərkəy balin galal sa eğeli, nəəl keçin bala tadanan. Əgər şot'ay gala mot'o nu tadaynan, t'e elemi balin ozana xoxp'anan. Efi süft'in ğar əyloğoy galal sa eğeli, nəəl keçin bala tadanan. ");
INSERT INTO udi_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Gələcəye ef ğarmoğon və̌xun \"mo het'aynak'e?\" pi xavar haq'at'an şot'oğo metər upanan: \"Q'ončuğon yax Misirəxun, beşi k'ul baki ölkinəxun İzi zorba kiin c'evek'i. ");
INSERT INTO udi_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faraonen inadkərluğbi yax nu tərbat'an Q'ončuğon bütüm misirluğoy süft'in ğarmoğo, hamal şot'oğoy heyvanxoy bütüm süft'in baloğo besebi. Mot'o görəyan yan heyvanxoy bütüm süft'in ərkəy baloğo q'urban tast'a, beş süft'in ğarmoğoy gala isə sa eğeli, nəəl keçin balayan q'urban eşt'a\". ");
INSERT INTO udi_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Barta morox vaynak' vi kiin nəəl vi k'odoğoy loxol bakala sa nišan k'inək'q'an baki ki, Q'ončuğon yax Misirəxun İz zorba kiin c'evksuna eyex efanan». ");
INSERT INTO udi_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faraonen israilluğo tərbit'uxun oşa Buxačuğon şot'oğo filist'luğoy ölkinəxun c'ovakala yaq'en tene taşeri. T'e yaq' ı̌ša yaq'ey, ama Buxačuğon pine: «Me yaq'en tağat'an filist'luyoxun davabsun lazım bakale, azuk'en isə mot'o ak'i iz fikirə badalbi Misirə qaybaksune çureğon». ");
INSERT INTO udi_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kot'o görəl Buxačuğon azuk'a Č'oč'a dənizəç ams'i oç̌ali yaq'ene fırıdi taşeri. Şorox davina həzir bakala q'oşun k'inək't'un Misirəxun c'eri. ");
INSERT INTO udi_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moiseyen İosifi ǔq'ěnxoval içuxun taneşeri, şot'aynak' ki, İosifen israilluğo «Buxačuğon müt'lək' və̌x çark'est'ale, tağala vədine və̌xun bezi ǔq'ěnxoval memiin c'evk'anan» pi elase tadest'ey. ");
INSERT INTO udi_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","İsrailluyox Suk'k'ot'axun yaq'a baft'i hari ams'i oç̌ali bel bakala Et'ama çurk'ala gat'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Q'ončuğon İçine şot'oğo taşt'ay: ğenaxun asoyi sütüni boş, üşe isə işiğ sakala aruğoy sütüni boş şot'oğoy běš taśi yaq'e ak'est'ay. Metərluğen, şorox ham ğene işiğen, hamal üşe yaq' tayest'un baksay. ");
INSERT INTO udi_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Nə ğenaxun bakala asoyi sütün, nə üşe bakala aruğoy sütün azuk'i běšt'an cöy tene baksay. ");
INSERT INTO udi_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Oşa Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«İsrailluğo metər upa: \"Baal-Sefoni t'ǒğǒl Migdoli q'a dənizi arane bakala P'i-Gaxirot' şəhəri běš çurpanan. Ef çurk'ala ga düz dənizi börineq'an baki\". ");
INSERT INTO udi_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraonen fikirbale ki, israilluğon yaq'a aç̌esp'et'un, ams'i oç̌alen şot'oğoy yaq'a bot'ene. ");
INSERT INTO udi_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Zu isə faraona inadkərboz, şoval ef bač'anexun baft'ale. Hat'e vədə Zu faraona q'a şot'ay q'oşuna pis ğina badoz, metərluğenal Bezi s'iya alaboz. Bütüm misirluğon avabakalt'un ki, Q'ončux Zuzu». İsrailluğon hametərəl bit'un. ");
INSERT INTO udi_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","İsrailluğoy ölkinəxun t'ist'una Misiri padçağa hari uk'at'an şot'ay saal izi sarayi amdarxoy fikir badalebaki. Şot'oğon pit'un: «Yan het'aynak'yan metər bi? Yaynak' əşp'ala israilluğo beş kiyexun təryanbi». ");
INSERT INTO udi_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Faraonen iz davin arabina həzirbest'i iz q'oşuna girebi. ");
INSERT INTO udi_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Şot'in içuxun ǔqbaç̌ c'ək'eśi davin araboğo saal Misirə bakala q'erəzəl bütüm davin araboğo taneşeri. Hər arabin loxol bacarağlu sa dəst'ə əsk'əre buy. ");
INSERT INTO udi_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Q'ončuğon Misiri padçağ bakala faraona saal inadkərebi, şoval israilluğoy bač'anexune baft'i. İsrailluyox isə içoğoy yaq'en ük'lü tat'unsay. ");
INSERT INTO udi_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirluyox - faraoni bütüm ěkla araboox, ěklorox saal q'oşun - şot'oğoy bač'anexunt'un baft'i, hariyal P'i-Gaxirot'i t'ǒğǒl, Baal-Sefoni běš dənizi börine israilluğoy çurpi gala p'at'unp'i. ");
INSERT INTO udi_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Faraon ı̌šalayinşakat'an israilluğon at'unk'i ki, mone, misirluyox içoğoy loxolt'un eysa! İsrailluyox q'ı̌yat'un baft'i, şivanbi Q'ončuğo xoyinšbsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Şot'oğon Moiseya pit'un: «Misirə gərəmzoğ buteney ki, yax ams'i oç̌alan bisa eçeri? Yax Misirəxun c'evk'i beşi bel mo k'ən eçeri? ");
INSERT INTO udi_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Misirə va \"yaxun kul haq'a, barta misirluğoynak' q'ulluğben!\" teyan pey ki? Ams'i oç̌ala bisunaxunsa misirluğoynak' q'ulluğbsun şaat'e!» ");
INSERT INTO udi_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moiseyen isə azuk'a metəre pi: «Ma q'ı̌banan! Ost'aar çurpanan, Q'ončuğon ğe və̌x hetər çark'est'una ak'alnan. Me misirluğo ene sal sa vədə tenan ak'al. ");
INSERT INTO udi_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ef gala Q'ončuğon İçin davabale! Və̌n isə ef ük'ə buz k'inək' efanan!» ");
INSERT INTO udi_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Q'ončuğon Moiseya pine: «Het'aynak'en Za şivanbsa? İsrailluğo upa ki, içoğoy yaq'en taśeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Hun isə vi çombağa alaba, vi kula dənizi loxol boxodi xena cöyba. T'e vədə israilluyox dənizi boşt'an q'ari ganuxun c'ovakalt'un. ");
INSERT INTO udi_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Zuval misirluğo inadkərboz ki, ef bač'anexunq'at'un baft'i. T'e vədə faraona, şot'ay bütüm q'oşuna, davin araboğo saal ěklat'oğo k'as'p'i Bezi s'iya alaboz. ");
INSERT INTO udi_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Faraona, davin araboğo saal ěklat'oğo pis ğina badi Bezi s'iya alabala vədine misirluğon avabakalt'un ki, Q'ončux Zuzu». ");
INSERT INTO udi_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","T'e vədə israilluğoy běš tağala Buxačuğoy angel şot'oğoy bač'anene c'ovaki. Asoyi sütünəl içoğoy běšt'an bač'anene c'ovaki, ");
INSERT INTO udi_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","şo Misiri q'oşuni q'a israilluğoy aranene çurpi. Asoyen t'e üşe sa tərəfə bayinq', t'e soğo tərəfə isə işiğebsay. Metərluğenal dirist' üşe me azuk'xo sun-suna tet'un ı̌šalayinşaki. ");
INSERT INTO udi_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moiseyen iz kula dənizi loxole boxodi. Q'ončuğon dirist' üşe zorba běğ c'eğala tərəfəxun eğala muşen dənizi xena şəp'eśi şot'ay ganu q'arinebi. Xe cöyebaki. ");
INSERT INTO udi_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","İsrailluyoxal dənizi boşt'an, q'ari ganuxun c'ovat'unki. Xe şot'oğoy yön saal tərs tərəf bari k'inək'e baki. ");
INSERT INTO udi_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misirluyox şot'oğoy bač'anexun baft'undi. Bütüm faraoni ěkurxo, davin araboox saal ěklorox israilluğoy bač'anexun dənizət'un baśi. ");
INSERT INTO udi_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kəykəymuxey, Q'ončuğon aruğoy saal asoyi sütüni boşt'an Misiri q'oşuni loxol běneği şot'oğonal içoğo aç̌est'unbi. ");
INSERT INTO udi_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Şot'in araboğoy təkərxo t'etəre lə̌q'p'i ki, araboox zorint'un taysay. Misirluğon pit'un: «Ekinan israilluğoxun t'it'en, Q'ončuğon İçine şot'oğoy tərəf baki beşi əleyinə davabsa!» ");
INSERT INTO udi_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","T'e vədə Q'ončuğon Moiseya pine: «Vi kula dənizi loxol boxoda ki, xe misirluğoy, şot'oğoy davin araboğoy saal ěklat'oğoy loxolq'an qaybaki». ");
INSERT INTO udi_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moiseyen iz kula dənizi loxole boxodi. Dəniz savaxa ı̌ša iz galane qaybaki. Misirluyox xenaxun t'ist'un çureğat'an Q'ončuğon xena şot'oğoy loxole taşeri, metərluğenal şorox dənizə batt'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","İz gala qaybakala xenen araboğo, ěklat'oğo, israilluğoy bač'anexun dənizə baśi faraoni bütüm q'oşuna but'k'i q'uc'epi. Şot'oğoxun sayco dirist' tene mandi. ");
INSERT INTO udi_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","İsrailluyox isə dənizi tumexun, q'ari ganuxunt'un c'ovaki taśi. Xe şot'oğoy yön saal tərs tərəf bari k'inək'e bakey. ");
INSERT INTO udi_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Q'ončuğon t'e ği israilluğo misirluğoy kiyexun metəre çark'est'i. Şot'oğon dənizi börine misirluğoy meyidxo, ");
INSERT INTO udi_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Q'ončuğon İz kala zoren k'ə bsuna ak'at'an içoğo q'ı̌yene haq'i, şot'oğon Q'ončuğoçalt'unxi. Şot'oval, Şot'ay c'ək'eśi k'ul bakala Moiseyal vět'unbaki. ");
INSERT INTO udi_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","T'e vədə Moiseyen q'a israilluğon Q'ončuğoynak' me mə̌ğə̌t'un mə̌ğpi: «Zu Q'ončuğoynak' mə̌ğk'oz! Şot'in kala q'ələbəne q'azayinşi, Ěka q'a ěklat'u dənizəne bosi! ");
INSERT INTO udi_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Q'ončux bezi zore, Q'ončuğone za mə̌ğpest'alo, Q'ončuğon za çark'esedi. Q'ončux bezi Buxačuxe, Zu Şot'ay s'iya alaboz. Q'ončux Bezi bavay Buxačuxe, Zu Şot'o alxışp'oz. ");
INSERT INTO udi_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Q'ončux q'oççağe, Q'ončuxe Şot'ay s'i. ");
INSERT INTO udi_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Şot'in faraoni davin araboğo, Q'oşunal dənizəne bosi. Faraoni c'ək'eśi davabalxo Č'oč'a dənizət'un batk'i. ");
INSERT INTO udi_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bə̌ğə̌loy xenen içoğo but'k'i J̌ě k'inək' tumel śirik' taneşeri. ");
INSERT INTO udi_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ay Q'ončux! Vi yön kul ost'aar hamal zorbane. Ay Q'ončux! Vi yön kiinen düşmənə k'as'p'i. ");
INSERT INTO udi_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Vi loxol eğalt'oğo Hun Vi kala s'iyenen saki, Vi əcuğ bəc'ük'eśi şot'oğo q'ari o k'inək' bok'osebi. ");
INSERT INTO udi_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Vi bǒxmǒğoy nəfəsen xena çurpesedi, Şoval bari k'inək'e baki, Dənizi posk'ala xe buz k'inək' ost'aare baki. ");
INSERT INTO udi_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Düşmən lovğalayinşebaksay: \"Şot'oğo şəp'eśi biq'oz, İçoğoy kiyel bakalt'oğo haq'i za boşevk'oz! Bez q'ılınca c'evk'i şot'oğo əfçiboz!\" ");
INSERT INTO udi_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ama Hun Vi nəfəsen funpi, dənizenal şot'oğo q'uc'epi. Q'urq'uşun k'inək' bə̌ğə̌loy xene boş batt'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ay Q'ončux, buxačuxxoy arane Vallarik'o butene! Vallarik' ı̌veloval butene! Vi kalaluğ alxışa q'a q'ı̌ya layiğe, Möcüzoox yaratmişal Vallarik'o butene! ");
INSERT INTO udi_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Vi yön kula boxondi, oç̌alenal düşmənxo q'uc'epi. ");
INSERT INTO udi_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Vi nu badalbakala çuresunen azuk'a çark'est'i yaq'en ak'est'i. Vi zoren Vi ı̌vel ganun taşeri. ");
INSERT INTO udi_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Azuk'xon mot'o ibaki t'ut'uk'alt'un, Filist'luğo q'ǐyen bot'ale. ");
INSERT INTO udi_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edomi kalaluğbalxoval t'e vədə q'ǐyen haq'ale, Moavi kalorox kala q'ı̌ya baft'alt'un, Kənanluyox isə q'ic'eśi mandalt'un. ");
INSERT INTO udi_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Şot'oğo q'ǐyen q'a vəlvəlinen haq'ale. Vi azuk' c'ovakamin Vi zorba kiin oq'a şorox ǰě k'inək' lal-kar bakalt'un! Ay Q'ončux, Vi çark'est'i me azuk' c'ovakale! ");
INSERT INTO udi_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Şot'oğo eçeri Vi buruğo p'ap'esp'alnu, Vi yəşəyinşbseynak' yaratmişi gala, Ay Q'ončux, Vi kiin biq'i ǐvel gala! ");
INSERT INTO udi_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Q'ončuğon həmişəluğ padçağluğbale». ");
INSERT INTO udi_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Faraoni ěkurxo, davin araboox saal ěklorox dənizə bağat'an Q'ončuğon dənizi xena şot'oğoy loxol qoşe qaydey. İsrailluyox isə dənizi bǐyexun, q'ari ganuxunt'un c'ovakey. ");
INSERT INTO udi_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aaroni xunçi xavareçal Maryamen iz kiyel dəpe ext'i. Bütüm çupuxxonal içoğoy kiyel dəp ext'i əçik'a şot'ay bač'anexunt'un taśi. ");
INSERT INTO udi_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Maryamen şot'oğoynak' me mə̌ğə̌ne mə̌ğpi: «Q'ončuğoynak' mə̌ğpanan, Şo gele kalane. Ěka saal ěklat'oğo dənizəne bosi!» ");
INSERT INTO udi_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moiseyen israilluğo Č'oč'a dənizi t'ǒǒxun Şur s'iyen ams'i oç̌alane taşeri. Şorox t'et'iya xib ği yaq't'un taśi, ama xe tet'un bə̌ğə̌bi. ");
INSERT INTO udi_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mara uk'ala gala p'ap'at'an isə t'iya bakala xena ǔğěs tet'un baki, şot'o görə ki, ağuney. Kot'o görəne t'e ga Mara k'alesa. ");
INSERT INTO udi_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Azuk'en «k'ə ǔğěn?» pi t'ot'onepi, Moiseyi ç̌oyel əyitpsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","T'e vədə Moiseyen Q'ončuğo xoyinšebi, Q'ončuğonal şot'o sa xodin taye ak'est'i. Moiseyen şot'o xenane bosi, xeyal ǔğə̌ləne baki. T'et'iya Q'ončuğon israilluğoy İzi əyitə əməlbsuna yoxlayinşbseynak' şot'oğoynak' q'ayda-k'anun laxi pine: ");
INSERT INTO udi_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","«Əgər və̌n ef Buxačux bakala Q'ončuğo ǔmǔxlaxaynan, Şot'ay piyes düzgün ak'eğala əşurxo biq'aynan, Şot'ay əmirxo əməlbi k'anunxo efaynan, misirluğoy loxol hari azarxoy sayco və̌ynak' eğala tene. Axıri və̌x q'olaybala Q'ončux Zuzu». ");
INSERT INTO udi_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Oşa israilluyox Maraxun c'eri Elimat'un hari. T'et'iya p'as's'e xene orayin saal yetmiş xurmin xodoy. Şot'oğon t'e orayinxoy t'ǒğǒl içoğoynak' çurk'ala gat'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Elimaxun c'erit'uxun oşa isə israilluyox hari Elimi q'a Sinay buruğoy arane bakala Sin ams'i oç̌alat'un p'ap'i. Mo p'ə̌mci xaşe qos's'emci ğiney, israilluğoy Misirəxun c'eysun sa xaşey. ");
INSERT INTO udi_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ams'i oç̌ala p'ap'it'uxun oşa bütüm israilluğon Moiseyaxun q'a Aaronaxun p'urum t'ot'opsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Şot'oğon next'uniy: «Q'ončuğon yax Misiri ölkinə besp'iyniy mot'oxun şaat'ey! T'iya yeq'e levet'i t'ǒǒx arśi boşşamin šumyan uksay. Mot'oğon isə yax me ams'i oç̌ala busaluğaxun bespseynak't'un eçere». ");
INSERT INTO udi_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","T'e vədə Q'ončuğon Moiseya pine: «Zu və̌ynak' göynuxun šum śipest'oz. Barta hər ği camaaten c'eri iz ğiluğ šuma girbeq'an. Metər Zu şot'oğoy Bezi k'anuna əməlbsuna yoxlayinşoz. ");
INSERT INTO udi_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ǔq ği girbeq'at'un, ǔqǔmci ğine girbiyo isə q'erəz ğimxo girbit'uxun p'ə̌q'at geleq'an baki, hat'e ğiyal şot'o həzirbeq'at'un». ");
INSERT INTO udi_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Metərluğen, Moiseyen q'a Aaronen israilluğo pit'un: «Biyəsin avabakalnan ki, və̌x Misirəxun c'evk'iyo Q'ončuxe. ");
INSERT INTO udi_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Savaxt'an isə Şot'ay kalaluğa ak'alnan. Axıri Şot'in efi İçuxun t'ot'opsuna inebaki. Yan şuyan ki, yaxunnan t'ot'one?» ");
INSERT INTO udi_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Oşa Moiseyen pine: «Və̌n metər avabakalnan ki, və̌x Misirəxun c'evk'iyo Q'ončuxe: me biyəsin Q'ončuğon və̌ynak' yeq', savaxt'an isə boşşamin šum p'ap'esp'ale. Şot'in ef t'ot'oltina inebaki. Yan şuyan ki? Ef t'ot'olti yaxun təə, Q'ončuğoxune». ");
INSERT INTO udi_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moiseyen Aarona pine: «Bütüm israilluğo upa ki, Q'ončuğoy běšq'at'un c'eri, şot'aynak' ki, Şot'in içoğoy t'ot'oltina inebaki». ");
INSERT INTO udi_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaronen israilluğoxun əyitk'ala vədine şot'oğon, mone, ams'i oç̌ala asoyi boş Q'ončuğoy kalaluğat'un ak'i. ");
INSERT INTO udi_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Zu israilluğoy t'ot'oltina izbaki. Şot'oğo upa: \"Biyəsç̌oye yeq' ukalnan, savaxt'an isə ef boşşamin šum bakale. T'e vədə avabakalnan ki, ef Buxačux bakala Q'ončux Zuzu\"». ");
INSERT INTO udi_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","T'e biyəsin israilluğoy çurpi ganu bildirçinxone purpi hari. Şot'oğon dirist' t'e ganu haq'layinşebi. Savaxt'an isə israilluğoy çurpi gane hərrəmine xone arśi. ");
INSERT INTO udi_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Xo ěqeśit'uxun oşa oç̌ali ç̌oye k'ə̌yə oşq'ar mas'i xurupunxone ak'eśi. ");
INSERT INTO udi_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","İsrailluğon mot'o ak'at'an sun-sunaxun \"mo hik'ə?\" pi xavar haq'sat'un burqi, şot'aynak' ki, mot'ay k'ə baksuna tet'un avay. Moiseyen isə şot'oğo pine: «Mo Q'ončuğon və̌ynak' yaq'abi ukune. ");
INSERT INTO udi_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Q'ončuğoy əmir mone: hər amdaren iz çadıra bakala amdarxoy saya görəq'an girbi. Hər amdara sa omer hesabbi». ");
INSERT INTO udi_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","İsrailluğon hametərəl bit'un. Şinesa gele, şinesa male girbi. ");
INSERT INTO udi_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ama hari omeren usk'at'an nə gele girbit'ay avuzin, nəəl mal girbit'ay kam tene c'eri. Hərt'in iz q'ərələne girbey. ");
INSERT INTO udi_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moiseyen israilluğo pine: «Savaxt'ineynak' me ukunaxun ma efanan». ");
INSERT INTO udi_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ama bəzit'oğon Moiseyi əyitə nu běği mot'oxun savaxineynak' et'unfi. Ama şo meq baft'i adebaft'i. Moiseyiyal şot'oğoy loxol əcuğone biq'i. ");
INSERT INTO udi_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Metərluğen, israilluğon hər savaxt'an t'e ukunaxun içoğo heq'ədər lazımesa girt'unbsay, mandiyo isə běğ gameğat'an xebaki tanesay. ");
INSERT INTO udi_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","İsrailluğon me ukunaxun ǔq ği girt'unbi, ǔqǔmci ğine isə şot'oxun p'ə̌q'at avuz, p'ə̌ omert'un girbi. Q'urumi kalaluğbalxon hari mot'o Moiseya avabakest'undi. ");
INSERT INTO udi_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moiseyen şot'oğo pine: «Q'ončuğon metəre nex: \"Əyc'ə sal sa əş nu biq'ala ğine - Q'ončuğohəsrbaki ı̌vel Şamat' ğine. Ğe ef badala hər şeya badanan, ǰaldala hər şeya ǰaldanan, mandala ukunal əyc'ineynak' efanan\"». ");
INSERT INTO udi_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","İsrailluğonal Moiseyen içoğo əmirbi k'inək' bit'un. Şot'oğon mandi ukuna əyc'in ğineynak' et'unfi, şoval nə meq tene baft'i, nə ad tene baft'i. ");
INSERT INTO udi_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moiseyen pine: «Me ukuna ğe ukanan, şot'aynak' ki, ğeyin ği Q'ončuğohəsrbakiŞamat' ğine. Ğe oç̌ali ç̌oyexun ukun tenan bə̌ğə̌bal. ");
INSERT INTO udi_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Və̌n me ukuna ǔq ği girbalnan, vǔğǔmci - Şamat' ğine isə şo bakala tene». ");
INSERT INTO udi_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Azuk'i boşt'an bəziyorox vǔğǔmci ğineyal ukun girbseynak' c'ert'un, ama hik'k'al tet'un bə̌ğə̌bi. ");
INSERT INTO udi_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Q'ončuğon Moiseya pine: «Hevaxt'al śirik' Bezi əmirxo saal k'anunxo tenan əməlbal? ");
INSERT INTO udi_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ef eyex efanan, Q'ončuğon və̌ynak' Şamat' ğine tadi. Mot'o görəl Şot'in və̌ynak' hər ǔqǔmci ğine p'ə̌ ğiluğ ukune tast'a. Barta vǔğǔmci ği hər soğo iz k'oya mandi sal sa gala maq'an c'eri». ");
INSERT INTO udi_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hametərəl, azuk'en vǔğǔmci ğine sal sa əş tene biq'say. ");
INSERT INTO udi_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","İsrailluğon me ukuni s'iya \"mannane\" laxi. Şo həvici śil k'inək'ey, iz irəng mas'i, iz t'ad isə uč'e yoxinane oşq'arst'ay. ");
INSERT INTO udi_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moiseyen pine: «Q'ončuğoy əmir mone: \"Manninaxun sa omer buybi və̌xun oşa eğala nəsileynak' efanan ki, Zu və̌x Misirəxun c'evk'i vədine ams'i oç̌ala tadi ukuna ak'at'un\"». ");
INSERT INTO udi_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Metərluğen, Moiseyen Aarona pine: «Sa q'av ext'a, şot'ay boş sa omer manna bapa. Şot'o Q'ončuğoy běš laxa ki, yaxun oşa eğala nəsileynak' q'orişi efen». ");
INSERT INTO udi_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaronenal Q'ončuğon Moiseya əmirbi k'inək' t'e manninen buy q'ava q'orişi efseynak' irəziluği sanduği běš lanexi. ");
INSERT INTO udi_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","İsrailluğon içoğoy ams'i oç̌ala bakala vədine - q'ırx usen mannat'un kəyi. Şot'oğon hari Kənan oç̌ali zahmana p'ap'amin mannat'un uksay. ");
INSERT INTO udi_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Sa omer - efa uk'ala usk'uni vis' payaxun sa paye. ");
INSERT INTO udi_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","İsrailluyox bütüm Sin ams'i oç̌alaxun yaq'a baft'i Q'ončuğon əmirbi k'inək' çurk'a-çurk'a köçt'unney. Şot'oğon hari Refidim uk'ala gala içoğoynak' çurk'ala gat'un düzbi. Ama t'iya azuk'i ǔğseynak' xe tene buy. ");
INSERT INTO udi_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","T'e vədə azuk'en Moiseya \"yax xe tada, yan xenezayan\" pi p'urum şikəətbsane burqi. Moiseyen şot'oğo pine: «Het'aynak'nan za taxsırkər bsa? Het'aynak'nan Q'ončuğo sinəyinşbsa? Yəni Q'ončuğo ext'ibər tenanbsa?» ");
INSERT INTO udi_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ama azuk' t'et'iya gele xenezaney. Şot'oğon Moiseyaxun t'ot'opi, şot'ay ç̌oye me əyitmoğot'un duğsay: «Axıri het'aynak'en yax Misirəxun c'evk'i? Beşi saal beşi əyloğoy q'a heyvanxoy memiya xenezaluğaxun biseynak'?» ");
INSERT INTO udi_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moiseyen Q'ončuğo k'alpi xoyinšebi: «Axıri zu me azuk'a k'ə baz? Samalal c'ovakayin, za ǰělayinşalt'un!» ");
INSERT INTO udi_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Q'ončuğon Moiseya pine: «Azuk'i boşt'an sa hema ağsaq'q'alxoval ext'i běš taki. Nil oqa duği çombağal vi kiyel ext'a. ");
INSERT INTO udi_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Zu isə Xoreva bakala q'ayani bel vi běš çurk'oz. Q'ayana duğa, t'et'iin azuk'i ǔğseynak' xe c'eğale». Moiseyenal israilluğoxun bakala ağsaq'q'alxoy piin běš mot'o bine. ");
INSERT INTO udi_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Şot'in t'e gane s'iya Massa saal Merivane laxi, şot'aynak' ki, israilluğon t'et'iya Q'ončuğoxun t'ot'opi Şot'ay içoğoxun baki nu baksuna avabaksunt'un çuresay. ");
INSERT INTO udi_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Oşa amalegluyox Refidima israilluğoxun davinat'un c'eri. ");
INSERT INTO udi_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moiseyen Yeşua pine: «Azuk'i boşt'an amalegluğoxun davabseynak' işq'arxo c'ək'p'a. Zu isə əyc'ə Buxačuğoy çombağ bezi kiyel təpin bel çurk'oz». ");
INSERT INTO udi_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeşuanal Moiseyen pi k'inək' bine, taśi amalegluğoxun davinane c'eri. Moisey, Aaron saal Xur isə təpin belt'un laśi. ");
INSERT INTO udi_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Moiseyen iz kulmoğo alabat'an israilluğont'un taşt'ay, iz kulmoğo oq'abat'an isə amalegluyoxe běš baksay. ");
INSERT INTO udi_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ama Moiseyi kulmux mandak'e baksay. Kot'o görəl sa ǰět'un eçeri, Moisey şot'ay loxol areśi. İz sa kula Aaronen, t'e soğo kula isə Xurene biq'i efi. Moiseyi kulmuxal běğbatk'amin ala manedi. ");
INSERT INTO udi_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hametər, Yeşuan amalegluğo q'ılıncen k'as'p'i śinepi. ");
INSERT INTO udi_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","T'e vədə Q'ončuğon Moiseya pine: «Mot'o eyex efseynak' sa gala śampa, Yeşual me əyitə p'ap'esp'a ki, Zu amalegluyox uk'ala s'iya dirist' oç̌ali ç̌oyexun silboz». ");
INSERT INTO udi_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moiseyen sa q'urban eçala ga düzbi iz s'iya \"Zaynak' q'ələbə eçala bayrağ - Q'ončuxe\" laxi ");
INSERT INTO udi_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","pine: «Kul Q'ončuğoçe alabaki. Q'ončuğonal nəsiləxun nəsilə amalegluğoxun davabale». ");
INSERT INTO udi_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midyanluğoy běyinš bakala Moiseyi q'ayinba Yet'ronen Buxačuğon Moiseyeynak' saal İz azuk' israilluğoynak' bi bütüm əşurxoy barada, Q'ončuğoy israilluğo Misirəxun c'evksuni barada inebaki. ");
INSERT INTO udi_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","T'e vədə Moiseyi q'ayinban iz xuyərə q'a şot'ay p'ə̌ ğaral ext'i Moiseyi t'ǒğǒle taśi. Moiseyen hələ me əşurxoxun běš iz çuğo Sip'p'ora q'a içoğoy p'ə̌ ğara iz bava Yet'roni t'ǒğǒle yaq'abey. ");
INSERT INTO udi_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Ğarmoğoy sunt'ay s'i Gerşomey, şot'aynak' ki, Moiseyen \"yad ölkine q'əribez baki\" peney. ");
INSERT INTO udi_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","T'e sunt'ay s'i isə Eliezerey, şot'aynak' ki, Moiseyen \"bezi bavay Buxačux bez köməyə p'ap'i za faraoni q'ılıncaxune çark'est'i\" peney. ");
INSERT INTO udi_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yet'ronen şot'oğo ams'i oç̌ala, Moiseyi Buxačuğoy buruğoy tumel çurpi galane eçeri. ");
INSERT INTO udi_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","T'iya p'ap'i isə Moiseyeynak' xavare yaq'abi: «Zu - vi q'ayinba Yet'ro, vi çuux saal vi p'ə̌ ğar vi t'ǒğǒlyan eysa». ");
INSERT INTO udi_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisey iz q'ayinbay běše c'eri, şot'ay běš çökt'i oşa hayzeri şot'o muçepi. Şot'oğon sun-sunaxun xavar avabakit'uxun oşa çadırat'un baśi. ");
INSERT INTO udi_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moiseyen iz q'ayinbaynak' Q'ončuğon israilluğo görə faraona q'a misirluğo bit'oğoy, içoğoy yaq'a zapi bütüm əzyətxoy saal Q'ončuğoy içoğo hetər çark'est'uni barada exlətebi. ");
INSERT INTO udi_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yet'ro Q'ončuğon israilluğoynak' bi bütüm şaat'luğa saal misirluğoy kiyexun şot'oğo çark'est'una görə mǔqebaki. ");
INSERT INTO udi_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yet'ronen pine: «Və̌x misirluğoy saal faraoni kiyexun çark'est'i Q'ončuğo alxışq'an baki! Azuk'a misirluğoy kiyexun çark'est'iyo Şone. ");
INSERT INTO udi_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Həysə avazbaki ki, Q'ončux bütüm buxačuxxoxun kalane, heq'ədər şot'oğon içoğo kala talşayt'un». ");
INSERT INTO udi_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Oşa Moiseyi q'ayinba Yet'ronen Buxačuğoynak' bok'ospsuni saal q'erəz q'urbanxone eçeri. Aaronal, israilluğoy ağsaq'q'alxoval hari Moiseyi q'ayinbaxun sagala Buxačuğo həsr baki ı̌vel ukunaxunt'un kəyi. ");
INSERT INTO udi_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Əyc'indəri Moiseyen həmişənin k'inək' arśi azuk'i şikəətxo běğsane burqi. Amdarxoval savaxt'inaxun biyəsəl śirik' Moiseyi hərrəminət'uniy. ");
INSERT INTO udi_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Moiseyi q'ayinban azuk'eynak' şot'ay bala bütüm me əşurxo ak'i pine: «Hun het'aynak'en metər bsa? Het'aynak'en mot'oğoy əşlə tək běğsa, bütüm me amdarxonal savaxt'inaxun biyəsəl śirik' vi hərrəmine çurpi yaq't'unběğsa?» ");
INSERT INTO udi_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moiseyen iz q'ayinba pine: «Şot'o görə ki, azuk'en Buxačuğoy çureğalt'u avabakseynak'e bezi t'ǒğǒle eysa. ");
INSERT INTO udi_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Çətin həlbakala əşurxo bakat'an amdarxo bezi t'ǒğǒlt'un eysa. Zuval şot'oğoynak' q'ərarez c'evksa, Buxačuğoy q'ayda-k'anunxoz avabakest'a». ");
INSERT INTO udi_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moiseyi q'ayinban şot'o pine: «Hun düz ten bsa. ");
INSERT INTO udi_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Hun vaal, vi t'ǒğǒl eğala camaatal mandak'enbsa. Axıri me əş vaynak' bǐhine, mot'o savsa bes ten bakon. ");
INSERT INTO udi_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Həysə bezi əyitə ǔmǔxlaxa, va sa maslaat tadaz, Buxačuxal va köməyq'an baki! Hun me azuk'a içoğoy əyitə Buxačuğo p'ap'espsuna köməyba. ");
INSERT INTO udi_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Şot'oğo q'ayda-k'anuna zomba, içoğoy tağala yaq'a saal biq'ala əşurxo ak'est'a. ");
INSERT INTO udi_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Azuk'i boşt'an isə bacarağlu, Buxačuğo çalxala, ext'ibərlu, haram q'azanca nu çureğala işq'arxo c'ək'p'a. Şot'oğo hazartani, baç̌tani, əllitani, vis'tani kalo laxa ki, ");
INSERT INTO udi_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","həmişə azuk'axun baki, lazım bakat'an şot'oğo divanbat'un. Barta çətin həlbakala əşə vi t'ǒǒxq'at'un eçeri, hasand həlbala əşə isə içanq'at'un həlbi. Metər t'e amdarxon vi yükəxun samal ext'i vi əşlə suuk't'unbon. ");
INSERT INTO udi_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Əgər hun metər bayin, Buxačuğonal va İzi əyitə me cürə p'ap'esp'ayin, hunal mandak'tenbakon, me amdarxoval içoğoy bakala gala irəzit'un tağon». ");
INSERT INTO udi_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moiseyen iz q'ayinban pi k'inək'əl bine. ");
INSERT INTO udi_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Şot'in israilluğoy aranexun bacarağlu işq'arxone c'ək'p'i, şot'oğo azuk'i loxol hazartani, baç̌tani, əllitani, vis'tani kalone laxi. ");
INSERT INTO udi_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Şorox həmişə azuk'axunt'un baksay, lazım bakat'an azuk'i şikəətə bět'unğsay. Çətin həlbakala əşurxo Moiseyi t'ǒğǒlt'un eşt'ay, hasand həlbakala əşurxo isə içant'un běğsay. ");
INSERT INTO udi_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Oşa Moiseyen iz q'ayinba yaq'ane badi, şoval iz ölkinəne taśi. ");
INSERT INTO udi_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","İsrailluyox Refidimaxun c'eri Sinay ams'i oç̌alat'un hari p'ap'i. İçoğoy Misirəxun c'eysun düz p'ə̌ xaşey. Memiya israilluğon buruğoy tumel çurk'ala gat'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moisey isə buruğo - Buxačuğoy t'ǒğǒle laśi. Q'ončuğon şot'o buruğoxun k'alpi pine: «İak'ovi nəsilə, israilluğo metər upa: ");
INSERT INTO udi_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","\"Zu misirluğo k'ə bsuna, və̌x Bez t'ǒğǒl q'ızılq'uşi q'ənədi loxol k'inək' eşt'una anank'i. ");
INSERT INTO udi_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Əgər və̌n Bezi əyitə běğaynan, Bezi və̌xun ğaç̌eśi irəziluğa əməlbaynan, və̌n bütüm azuk'xoy boşt'an Bezi c'ək'p'i, Zaynak' gele əziz azuk' bakalnan. Bütüm dünyə Bezine, ");
INSERT INTO udi_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","və̌n isə Za q'ulluğbala běyinšxoy padçağluğ, ı̌vel millət bakalnan.\" Me əyitmoğo israilluğo upa». ");
INSERT INTO udi_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moiseyenal hari azuk'i ağsaq'q'alxo k'alepi, Q'ončuğon əmirbi k'inək', içu pi hər əyitə şot'oğo p'ap'esebi. ");
INSERT INTO udi_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bütüm azuk'en sa tan k'inək' metəre coğab tadi: «Q'ončuğon pit'oğo bütümə əməlbalyan». Moiseyen azuk'i coğaba Q'ončuğo p'ap'esebi. ");
INSERT INTO udi_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Q'ončuğon Moiseya pine: «Mone, Zu boç̌u asoyi boş vi t'ǒğǒl eğoz ki, azuk'en Zu vaxun exlətpsuna ibaki va həmişə věbakeq'an». Moiseyenal azuk'i əyitmoğo Q'ončuğo p'ap'esebi. ");
INSERT INTO udi_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Oşa Q'ončuğon Moiseya pine: «Azuk'i t'ǒǒx taki. Ğe saal əyc'ə şot'oğo ı̌velba. Barta içoğoy paltarxoval os'k'i ");
INSERT INTO udi_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","samaane həzirq'at'un baki, şot'aynak' ki, hat'e ği bütüm azuk'i piin běš Zu Sinay buruğoy bel śiğoz. ");
INSERT INTO udi_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Azuk'eynak' buruğoy hərrəmine zahman laxi upa: \"Və̌x buruğo laysunaxun, şot'ay tuma lafst'unaxun běğanan. Buruğo laft'alo biyalane. ");
INSERT INTO udi_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","T'etərt'u kul nu laft'alane, şot'o ǰělayinşi nəəl oxen duği besp'anan. Çuresa heyvanq'an baki, çuresa amdar - buruğo laft'alo nu mandalane. Saycə şeyp'uri boxoy səs c'eğat'an şorox buruğo layes bat'unkon\"». ");
INSERT INTO udi_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Oşa Moisey buruğoxun azuk'i t'ǒǒxe śiri. Şot'in azuk'a ı̌velebi. Şot'oğon içoğoy paltarxo os't'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","T'e vədə Moiseyen azuk'a pine: «Samanineynak' həzir bakanan, ef çupuxxoxun ı̌šaluğmabanan». ");
INSERT INTO udi_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Xib ği oşa savaxt'an üşenen göyen gürunepi, s'ə̌q'en duneği. Ost'aar şeyp'uri səse c'eri, buruğo isə boç̌u asoyene bəc'ürpi. Amdarxo içoğoy çurpi gala q'ǐyen haneq'i. ");
INSERT INTO udi_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","T'e vədə Moiseyen azuk'a içoğoy çurpi ganuxun Buxačuğoy běše taşeri, şoroxal buruğoy tume çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinay burux dirist' k'üüni boşey, şot'aynak' ki, Q'ončux şot'ay loxol aruğoy boşe śirey. Buruğon buxarinen k'üünbala k'inək' k'üünbi ost'aar ǰı̌k'esay. ");
INSERT INTO udi_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Şeyp'uri səs taysun ost'aare baksay. Moiseyen isə Buxačuğoxun əyiteney, Şot'inal ost'aar səsen coğabe tast'ay. ");
INSERT INTO udi_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Q'ončux Sinay buruğoy bel śiri Moiseya iz t'ǒğǒle k'alpi. Moiseyal t'iya laneśi. ");
INSERT INTO udi_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Q'ončuğon Moiseya pine: «Śiki, azuk'a tapşurba ki, Za akseynak' laxeśi zahmana maq'an c'ovaki, tenesa gelo k'as'eğale. ");
INSERT INTO udi_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Lap Za ı̌šalayinşakala běyinšxonal içoğo ı̌velbeq'at'un ki, Zu şot'oğo nu əfçibaz». ");
INSERT INTO udi_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moiseyen Q'ončuğo pine: «Azuk' Sinay buruğo lateneğon, şot'aynak' ki, Hun \"buruğoy hərrəmine zahman laxi şot'o ı̌vel ba\" pi yax avabakesendi». ");
INSERT INTO udi_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Q'ončuğon şot'o pine: «Śiki, Aaronal ext'i miya laki. Ama běyinšxo q'a azuk' Bez t'ǒǒx layseynak' zahmana maq'at'un c'ovaki, tenesa şot'oğo əfçiboz». ");
INSERT INTO udi_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moisey azuk'i t'ǒǒx śiri mot'o şot'oğo exlətebi. ");
INSERT INTO udi_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Oşa Buxačuğon me əyitmoğone pi: ");
INSERT INTO udi_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Zu va Misiri oç̌alaxun, k'ul baki ganuxun c'evk'i vi Buxačux bakala Q'ončuxzu. ");
INSERT INTO udi_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Vi Zaxun q'erəz buxačuxxo nu bakalane! ");
INSERT INTO udi_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Vaynak' sal sa binik' buxačux ma düzba. Nə ala - göynul, nə oq'a - oç̌ali loxol, nəəl oç̌ali oq'a xene boş bakala hik'k'ali surata ma düzba. ");
INSERT INTO udi_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Metər şeyurxo bul ma k'os'ba. Şot'aynak' ki, vi Buxačux Q'ončuxZuzu, q'erəz buxačuxxo bul k'os'bsuna nu portbala Buxačuxzu. Günaxbi bavoğoy cazina içoğoy nəvə-nəticoğoz zapest'on. ");
INSERT INTO udi_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Za çureśi Bezi əmirxo əməlbalt'oğo isə içoğoxun oşa hələ hazar nəsilxoval Bezi nu badalbakala çuresunaz ak'est'on! ");
INSERT INTO udi_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Vi Buxačux bakala Q'ončuğoy s'iya ams'i gala muzel ma eça, şot'aynak' ki, Q'ončuğon İz s'iya ams'i gala muzel eçalt'u cazasuz tene bark'on. ");
INSERT INTO udi_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Şamat' ğine ı̌vel baksuna eyex efi şot'o t'iyə̌mi ğimxoxun üst'ün laxa. ");
INSERT INTO udi_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ǔq ği əşp'i bütüm vi əşurxo biq'a. ");
INSERT INTO udi_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Vǔğǔmci ği isə vi Buxačux bakala Q'ončuğohəsrbaki ı̌vel Şamat' ğine. Me ği nə hun, nə vi ğaren, nə vi xuyəren, nə vi işq'ar nəəl çuux nökəren, nə vi heyvanxon, nə vi t'ǒǒx bakala q'erəz ölkinəxun bakala q'əriben sal sa əş maq'an biq'i. ");
INSERT INTO udi_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Şot'aynak' ki, ǔq ğiin boş Q'ončuğon göyə, oç̌ala, dənizə saal t'et'iya bakala k'ə bunesa yaratmişebi, vǔğǔmci ğine isə dincəyinşebaki. Kot'aynak'al Q'ončuğonŞamat' ğinaxeyir-bərəkət tadi şot'o t'iyə̌mi ğimxoxun üst'üne laxi. ");
INSERT INTO udi_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Vi bava-nana hörmətba ki, Buxačux Q'ončuğon va tadi oç̌ala vi ömür boxoyq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Besmaba. ");
INSERT INTO udi_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Əxlagsuzluğmaba. ");
INSERT INTO udi_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Başmaq'a. ");
INSERT INTO udi_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Şuk'k'ali əleyinə əfçidən şahidluğmaba. ");
INSERT INTO udi_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Şuk'k'ali k'oja tamaxmaba. Şuk'k'ali çuğo, iz işq'ar nəəl çuux nökərə, öküzə, elema - şot'ay sal sa şeya tamaxmaba». ");
INSERT INTO udi_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Azuk'en göye gürultina q'a şeyp'uri səsə ibaki, buruğoy k'üünəxbaksuna q'a s'ə̌q'ə ak'i q'ı̌bi ə̌xilebaki. ");
INSERT INTO udi_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Şot'oğon Moiseya pit'un: «Yaxun hun əyitp'a, va ibaken. Ama Buxačuğon yaxun maq'an exlətp'i, tene biyalyan». ");
INSERT INTO udi_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moiseyen azuk'a pine: «Ma q'ı̌banan, Buxačux şot'o görəne hare ki, İz eysunen ef Şot'o hetər q'arşilayinşbsuna yoxlayinşane saal və̌n Şot'ay zora q'a kalaluğa ak'i ene günax nu banan». ");
INSERT INTO udi_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Azuk' ə̌xil çurpeney, Moisey isə Buxačux iz boş bakala mə̌p-mə̌yin asoyane ı̌šalayinşaki. ");
INSERT INTO udi_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Q'ončuğon Moiseya pine: «İsrailluğo metər upa: \"Və̌n anank'i ki, Zu və̌xun göynuxunez əyitpi. ");
INSERT INTO udi_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Və̌ynak' nə q'ızılaxun, nəəl gümüşəxun buxačuxxo ma düzbanan, şot'oğo Zaxun barabar biq'i bul ma k'os'banan! ");
INSERT INTO udi_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Za bul k'os'bseynak' k'ulen düzbaki q'urban eçala ga düzbanan, bok'ospsuni q'a serluği q'urbanxo eşt'eynak'al ef eğel-keçiğoxun q'a beliğoxun şot'ay loxol eçeri šampanan. Vi Za bul k'os'bseynak' mani ganu c'ək'k'ayiz, Zu t'iya hari va xeyir-bərəkət tadoz. ");
INSERT INTO udi_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Əgər Za bul k'os'bseynak' ǰěnaxun q'urban eçala ga düzbayin, şot'o kişeśi ǰěnaxun ma biq'a, şot'aynak' ki, ǰěne loxol ət't'əcen əşp'ayin, şot'o murdarlayinşenbon. ");
INSERT INTO udi_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Zaynak' q'urban eçala gane loxol vi oq'axun maq'an qayeśi pi şot'ay loxol piləkənen ma laki\". ");
INSERT INTO udi_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Hun şot'oğoy běš me k'anunxo laxalanu: ");
INSERT INTO udi_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Və̌xun sunt'in əbranik'ul haq'ayin, t'e k'ulen ǔq usen q'ulluğbeq'an, vǔğǔmci usen isə iz ağan t'e k'ulaxun təngə haq'inut' şot'o tərbeq'an. ");
INSERT INTO udi_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Əgər t'e k'ul təke hareysa, barta təkəl taśeq'an. Ama əgər eğat'an iz çuux buneysa, barta çuuxal şot'oxun sagala azad bakeq'an. ");
INSERT INTO udi_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Əgər k'ula iz ağane çuux tadesa, oşaal şot'oğoy əyloxe bakesa, t'e vədə çuuxal, əyloxal ağaye, k'ul isə təke azad baksa. ");
INSERT INTO udi_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ama k'ulen uk'ayin: \"Zu bezi ağa, bezi çuğo q'a əyloğo çurezsa, şot'aynak'al azad baksun tez çuresa,\" ");
INSERT INTO udi_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","t'e vədə barta k'ule ağan şot'o Buxačuğo bul k'os'bala galaq'an eçeri. K'ula ç̌omo nəəl ç̌omoy t'ǒğin daxt'ak'a t'ayağbi iz ǔmǔğo bizen deşibeq'an. T'e vədə me k'ul ömürluğ t'e ağaye baksa. ");
INSERT INTO udi_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Sa amdaren iz xuyərə k'ul k'inək' toydayin, şo işq'ar k'ulurxollarik' maq'an azadbaki. ");
INSERT INTO udi_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Əgər t'e xuyər ağay xoşel p'ə̌mci çuux k'inək' nu eğayin, ağan t'e xuyəri toya iz bavaxun ext'i şot'o azadbeq'an. Ağay t'e xuyərə q'əribə toyst'una ext'iyər teno, şot'aynak' ki, şot'o feret'edi. ");
INSERT INTO udi_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Əgər ağan şot'o iz ğareynak' nišan tadayin, şot'oxun iz xuyər k'inək'q'an rəft'ərbi. ");
INSERT INTO udi_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Əgər t'e amdaren saal çuux haq'ayin, me k'ul-çuğoy ukuna, paltara saal izi çuux k'inək' bakala haq'q'a maq'an kambi. ");
INSERT INTO udi_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Əgər ağan t'e çuğoy me xib haq'q'a tene tast'asa, me çuux hik'k'al ödəyinşinut' c'eri taśeq'an. ");
INSERT INTO udi_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Amdara duği besp'alo biyalane. ");
INSERT INTO udi_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ama t'e amdaren q'əst'en tene besp'esa, me əşəl Buxačuğoy əşesa, t'e vədə şo Zu təyinbi şəhəreq'an t'it'eri. ");
INSERT INTO udi_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ama sa amdaren q'erəz amdara q'əst'en besp'ayin, t'e amdara lap Zaynak' q'urban eçala ganuxunal ext'i besp'anan. ");
INSERT INTO udi_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","İz bava nəəl nana kul alabala amdar biyalane. ");
INSERT INTO udi_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Amdara başq'i toydiyo biyalane. Başq'i amdara hələ toydinut biq'eśiyoval biyalane. ");
INSERT INTO udi_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","İz bava nəəl nana təhk'irbala amdar biyalane. ");
INSERT INTO udi_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Əgər davabat'an sunt'ay ǰěnen nəəl yumburuğen duği amdar gane boş mandiyal bakayin, ama nu biyayin, ");
INSERT INTO udi_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","oşa isə hayzeri çombağen tarapesal bakayin, şot'o duği amdar cazasuze manst'a. Saycə iz duği amdari gane boş bask'i vədin xarcaq'an zapi, q'olaybakamin şot'o běğeq'an. ");
INSERT INTO udi_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Əgər sa amdaren iz işq'ar nəəl çuux k'ula k'ovalen duği şot'o besp'ayin, t'e amdaren iz cazina zap'k'alane. ");
INSERT INTO udi_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ama əgər işq'ar nəəl çuux k'ul hələ sa-p'ə̌ ğiyal nu biyayin, şot'oğoy ağa caza koftenest'a, şot'aynak' ki, k'ul iz ağay əmlake. ");
INSERT INTO udi_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","İşq'arxon davabat'an sa bǐhi çuğo duğayt'un, şot'inal əyel sakayin ama q'erəz ziyan şot'o nu laft'ayin, t'e çuğoy işq'ari tələben taxsırkər amdaren divanbalxon təyinbi toya ödəyinşalane. ");
INSERT INTO udi_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ama əgər çuğo q'erəzəl ziyan laft'enesa, taxsırkər amdaren t'e ziyana ödəyinşeq'an: elmoğoy gala elmux, ");
INSERT INTO udi_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","piin gala pul, uluğoy gala ulux, kule gala kul, ture gala tur, ");
INSERT INTO udi_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","bok'uni gala bok'un, yarin gala yara, zədin gala zədə. ");
INSERT INTO udi_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ağan işq'ar nəəl çuux k'ula duği şot'ay pula k'ač'ibayin, t'e piin əvəzə şot'o tərbeq'an. ");
INSERT INTO udi_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Əgər ağan işq'ar nəəl çuux k'ule uluğo xoxbayin, uluğoy əvəzə şot'o tərbeq'an. ");
INSERT INTO udi_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Öküzen işq'ara nəəl çuğo iz mǔq'inen duği besp'ayin, t'e öküzə ǰělayinşi besp'anan, şot'ay yeq'al ma ukanan. Öküzi q'ončux isə me gala günaxsuze. ");
INSERT INTO udi_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ama əgər heyvan süft'inəxunal duğala heyvane bakesa, iz q'ončuğon isə mot'o ava-ava şot'ay běšinə̌mə tene haq'esa, heyvanenal işq'ara nəəl çuğo duği besp'enesa, t'e heyvana ǰělayinşi besp'anan, şot'ay q'ončuxal biyalane. ");
INSERT INTO udi_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ama əgər heyvani q'ončuğoxun təngə çureğayt'un, iz elmoğoy gala t'e tənginə ödəyinşi çark'es banekon. ");
INSERT INTO udi_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ğara nəəl xuyərə mǔq'ə̌ləyinşala heyvani axıral hametərq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Əgər heyvanen işq'ar nəəl çuux k'ula mǔq'ə̌ləyinşayin, heyvani q'ončuğon k'ule ağa otuz şek'el gümüşq'an tadi, heyvana isə ǰělayinşi besp'anan. ");
INSERT INTO udi_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Sa amdaren kura k'ašp'est'it'uxun oşa nəəl şot'ay looxun qayp'it'uxun oşa nu but'k'ayin, t'et'iyal sa öküz nəəl sa elem baft'ayin, ");
INSERT INTO udi_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","kure q'ončuğon zərələ ödəyinşeq'an, heyvani toya iz q'ončuğo tadeq'an, murdarbaki heyvan isə t'e amdaraq'an mandi. ");
INSERT INTO udi_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Əgər sa amdari öküzen t'iyə̌mint'ay öküzə duği besp'ayin, dirist' mandi heyvana toydi iz tənginə, t'iyə̌mint'ay isə yeq'a bǐyexun cöybeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ama əgər t'e öküz süft'inəxunal duğala öküze bakesa, şot'ay q'ončuğonal mot'o ava-ava şot'ay běšinə̌mə tene haq'esa, barta t'e öküzi gala q'erəz sa öküz tadi zərələ ödəyinşeq'an. Murdarbaki heyvan isə içu mandalane. ");
INSERT INTO udi_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Sa amdaren öküz nəəl eğel başq'i šamk'ayin nəəl toydayin, barta t'e amdaren sa öküzi gala qo öküz, sa eğeli gala bip' eğel tadi zərələ ödəyinşeq'an. ");
INSERT INTO udi_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Əgər üşe oğri sunt'ay k'oya bağat'an şot'o biq'i besp'ayt'un, besp'iyo taxsırsuze. ");
INSERT INTO udi_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ama əgər oğrina běğ c'erit'uxun oşat'un besp'esa, besp'iyo taxsırkəre. Oğrinen isə zərələ k'ojin q'ončuğo müt'lək' ödəyinşalane. Ama əgər oğrin ödəyinşala hik'k'al tet'ux busa, şot'o içuq'at'un k'ul k'inək' toydi. ");
INSERT INTO udi_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Əgər başq'eśi heyvan - çuresa öküz, çuresa elem, çuresa eğel-keçi - oğrin kiyel dirist' bə̌ğə̌yeğayin, oğrinen p'urumal zərələ p'ə̌q'at ödəyinşalane. ");
INSERT INTO udi_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Əgər şinesa iz beliğo iz oç̌ala otarişbsa c'evk'at'an beliğon q'ert'ay oç̌ala nəəl t'ulluğa zərəl tadayin, şot'in iz oç̌ali nəəl t'ulluği ən şaat' məhsuli hama əvəz tadalane. ");
INSERT INTO udi_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Əgər şinesa bəc'ük't'i aruğon śaśluğa c'ovaki oşal yoqurxo, əkinə nəəl q'oruğa bitova əfçibayin, aruğo bəc'ük't'i amdaren zərələ ödəyinşalane. ");
INSERT INTO udi_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Əgər sa amdara efseynak' tadi gümüş nəəl q'erəz şeymux şot'ay k'oyaxun başq'eğayin, oğriyal bə̌ğə̌yeğayin, oğrinen zərələ p'ə̌q'at ödəyinşalane. ");
INSERT INTO udi_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ama əgər oğri nu bə̌ğə̌yeğayin, k'ojin q'ončuğon Buxačuğo bul k'os'bala gala taśi təst'iğbeq'an ki, t'e amdari amanata tene başq'e. ");
INSERT INTO udi_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Hər aç̌i sa şeya - çuresa öküzə, çuresa elema, çuresa eğel-keçinə, çuresa paltara \"mo bezine\" uk'ala p'ə̌ tərəfenal içoğoy bala davalu əşə Buxačuğo bul k'os'bala gala eçalane. T'iya bakala divanbalxon haq'suz c'evk'ala amdarenal t'e sunt'u zərələ p'ə̌q'atq'an ödəyinşi. ");
INSERT INTO udi_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Əgər sa amdara efseynak' tadeśi elem, öküz, eğel-keçi nəəl q'erəz sa heyvan oşa şuk'k'alen iz piin ak'inut' murdarbakayin, yaralayinşakayin nəəl düşmənxon şot'o taşayt'un, ");
INSERT INTO udi_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","barta t'e amdaren Q'ončuğoy s'iyen elasp'eq'an ki, şot'in q'ert'ay amanata tene galde. Barta heyvani q'ončuğonal mot'o q'abulbeq'an, efala amdaren isə şot'o laft'i zərələ maq'an ödəyinşi. ");
INSERT INTO udi_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ama əgər heyvan başq'eśenesa, şot'o efala amdaren heyvani q'ončuğo laft'i zərələ ödəyinşeq'an. ");
INSERT INTO udi_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Əgər heyvana ə̌qnə heyvanen śarpenesa, şot'o efala amdaren śareśi heyvana subut k'inək' iz q'ončuğoy t'ǒğǒlq'an eçeri, zərələl maq'an ödəyinşi. ");
INSERT INTO udi_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Əgər sa amdaren borc ext'i heyvan şot'o qaydi qoş tadamin yaralayinşakayin nəəl murdarbakayin, barta t'e amdaren heyvani q'ončuğo laft'i zərələ ödəyinşeq'an. ");
INSERT INTO udi_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ama əgər me əş heyvani q'ončux iz t'ǒǒx bakala vədinene bakesa, q'ončuğo laft'i zərəl nu ödəyinşakalane. Heyvan tənginene tadeśesa, q'ončuğon iz tənginə haq'alane. ");
INSERT INTO udi_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Sa amdaren ərgən sa xuyərə ferett'i şot'oxun ı̌šaluğbayin, t'e xuyəri həvginə yaq'abi şot'oval içeynak' çuux balane. ");
INSERT INTO udi_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Əgər xuyəri bavan şot'o t'e amdara işq'ara tast'una nuval irəzi bakayin, t'e amdaren hələl ərgən xuyəri həvgin toya şot'ay bava ödəyinşalane. ");
INSERT INTO udi_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Cadubala çuğo besp'anan. ");
INSERT INTO udi_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Heyvanxoxun ı̌šaluğbalt'uval dirist' ma efanan. ");
INSERT INTO udi_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Q'ončuğoxun başq'a q'erəz buxačuxxo q'urban eçala amdar əfçibakalane. ");
INSERT INTO udi_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Q'ərib amdara nə haq'suzluğ, nəəl zülüm ma banan, axıri və̌nal Misiri ölkinə q'əribnan bake. ");
INSERT INTO udi_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Süpür çuğo nəəl yetimə əzyət ma tadanan. ");
INSERT INTO udi_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Əgər şot'oğoxun sunt'u əzyət tadaynan şot'in Za şivanbi xoyinšbale, Zuval müt'lək' şot'ay xoyinša ibakoz. ");
INSERT INTO udi_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Bezi əcuğon biq'i və̌x q'ılıncen besp'est'oz. Ef çupuxxo süpür, əylux isə yetim mandalt'un. ");
INSERT INTO udi_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Efi arane yəşəyinşala, Beziyal azuk'axun bakala sa kəsibə təngə borc tadaynan, şot'oxun fayiz ma çurekinan. ");
INSERT INTO udi_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Əgər şot'ay xələtənən girov exst'asa, běğ batk'amin şot'o qayda. ");
INSERT INTO udi_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Şot'aynak' ki, t'e amdari me paltaraxun başq'a iz loxolxun but'k'ala hik'k'al tet'ux bu. Axıri xələtə nu qaydaynan, t'e amdaren bask'at'an het'ina iz loxolxun but'k'on? Şot'in Za şivanbi xoyinšebon, Zuval şot'ay şivana izbakon, şot'aynak' ki, Zu ük' bok'osp'alzu. ");
INSERT INTO udi_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Buxačuğoy barada pis əyit ma əyitp'anan, ef azuk'i kalaluğbalal ma ləənətbanan. ");
INSERT INTO udi_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ef ambarxoy q'a t'op'iğoy boş bakalt'oğoxun Zaynak' bakala paya kam ma banan. Ef süft'in ğarmoğo Za həsrbanan. ");
INSERT INTO udi_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ef beliğoy q'a eğel-keçin süft'in baloğoval hametər banan: vǔğ ği şot'oğo içoğoy nanoğoxun sagala efanan, muğumci ğine isə şot'oğo Za tadanan. ");
INSERT INTO udi_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Və̌n Za həsrbaki ı̌vel azuk'nan, kot'o görəl ə̌qnə heyvanen çöle śarpi heyvani yeq'a ma ukanan, şot'o xə̌yoğo tadanan. ");
INSERT INTO udi_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Əfçi əyit taramadanan. Əfçidən şahidluğbi haq'suz amdara köməymabanan. ");
INSERT INTO udi_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Şər əş biq'ala amdarxoy bač'anexun ma takinan. Məhk'əminə gelet'oğoy tay baki düzə k'oribi əfçi şahidluğmabanan. ");
INSERT INTO udi_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Sa amdari saycə iz kəsib baksuna görə məhk'əminə şot'ay tərəf şahidluğmabanan. ");
INSERT INTO udi_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Efi düşməni azmişaki arak'a nəəl elema irəst'eğayin, şot'o iz q'ončuğo qaydanan. ");
INSERT INTO udi_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Və̌x nifrətbala amdari elema yüke oq'a biti ak'ayvax, şot'o ketər ma efanan. Şot'o köməybanan ki, t'e yüke oq'axun c'ereq'an. ");
INSERT INTO udi_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Məhk'əminə efi azuk'axun bakala kəsib amdari əşlə běğat'an düzgün divanbanan. ");
INSERT INTO udi_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Amdara məhk'əminə əfçidən taxsırkər c'evksunaxun ə̌xil bakanan. Taxsırsuzt'oğoynak' q'a düzgün amdarxoynak' şot'oğo besp'est'uni q'ərar ma c'evk'anan. Axıri pis amdara cazasuz tez bark'al. ");
INSERT INTO udi_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Rüşvət ma haq'anan, şot'aynak' ki, rüşvəten ak'alt'oğo k'ač'i, düz əyitk'alt'oğoval əfçiduğale bon. ");
INSERT INTO udi_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Q'əribə zülüm ma tadanan. Axıri və̌nal Misirə q'ərib bakat'an, q'əribluğin k'ə baksuna hisbenan. ");
INSERT INTO udi_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ǔq usen ef oç̌ala bit'anan iz baral girbanan. ");
INSERT INTO udi_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Vǔğǔmci usenast'a isə şot'o kul ma duğanan. T'e vədə ef azuk'axun bakala kəsibxon t'et'iin ukest'un bakon, avuz mandalt'u isə çölin heyvanxonq'an kəyi. Ef t'ulluğxo q'a zeytunluğxoval metər banan. ");
INSERT INTO udi_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ǔq ği ef əşurxo banan, vǔğǔmci ğine isə ma əşbanan ki, ef kəlurxo q'a elemxo dincəyinşəkeq'at'un, ef k'oya bakala nökərxo q'a q'əribxoval içoğol hareq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Bezi və̌x pi hər şeya əməlbanan. Q'erəz buxačuxxoy s'iya ma duğanan, şot'oğoy s'iyurxo ef muzelal ma eçanan. ");
INSERT INTO udi_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Bez s'iyal usena xib axsibay c'ovakest'anan. ");
INSERT INTO udi_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ə̌yinsuz Šume axsibay c'ovakest'anan: Zu və̌x əmirbi k'inək' aviv xaşast'a və̌ynak' təyinbaki vədine vǔğ ği ə̌yinsuz šum ukanan. Şot'aynak' ki, Misirəxun t'e xaşast'anan c'ere. Şuk'k'al kul ams'i Za bul k'os'bsa maq'an hari. ");
INSERT INTO udi_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Çöle bakala əkini süft'in exaxun Exe axsibay c'ovakest'anan. Oç̌alen tadi bara bitova girbit'uxun oşa useni axırast'a Bare axsibayal c'ovakest'anan. ");
INSERT INTO udi_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Metər, usena xib kərəm ef bütüm işq'arxo içoğoy Q'ončux Buxačuğo bul k'os'bala gala eğalt'un. ");
INSERT INTO udi_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Zaynak' eçala q'urbani p'iya ə̌yinen šareśi hik'k'al laft'imaq'an. Zaynak' eçala axsibayi q'urbanluği piyal savaxeynak' emafanan. ");
INSERT INTO udi_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Vi oç̌alaxun girbi nübərin ən şaat't'u ef Buxačux bakala Q'ončuğo bul k'os'bala gala eçanan. Q'uzina iz nanay muč'anaq'i boş ma ap'esp'anan. ");
INSERT INTO udi_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mone, Zu ef běš tayseynak' Bez angelaz yaq'absa ki, şot'in və̌x yaq'a q'orişi Bezi və̌ynak' həzirbi gala taşane. ");
INSERT INTO udi_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Şot'o fikir tadanan, iz əyitəl běğanan. Şot'ay əyitəxun ma c'ekinan - şot'in tene bağışlayinşal, şot'aynak' ki, k'ə bsanesa Bez s'iyene bsa. ");
INSERT INTO udi_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Əgər şot'o ǔmǔxlaxi, Bezi uk'alt'uğoval əməlbaynan, Zu ef düşmənxoynak' düşmən bakoz, və̌x nu çureğalt'oğo Zuval tez çureğal. ");
INSERT INTO udi_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Bezi angel ef běš taśi və̌x emorluğoy, xet'luğoy, p'erizluğoy, kənanluğoy, xivluğoy saal yevusluğoy oç̌ala eçale. Zuval şot'oğo əfçiboz. ");
INSERT INTO udi_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Şot'oğoy buxačuxxo bul ma k'os'banan, şot'oğo q'ulluğbiyal içoğoy ədəten ma takinan. T'e buxačuxxo śarpi əfçibanan, şot'oğoy ı̌vel hesabbakala ǰěne sütünxo k'ot'or-k'ot'or banan. ");
INSERT INTO udi_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Və̌n ef Buxačux Q'ončuğo q'ulluğbanan, Zuval ef šuma saal xena xeyir-bərəkət tadoz, azarxoval və̌xun ə̌xilboz. ");
INSERT INTO udi_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ef ölkinə nə əyel sakala, nəəl ərəmik' çuux tene bakal. Ef ömürəl boxoyboz. ");
INSERT INTO udi_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ef loxol eğala bütüm azuk'xo q'ı̌yen q'a vəlvəlinen haq'ale. Zuval şot'oğoy arane gərgürçiluğ sakoz. Bütüm ef düşmənxoval ef běšt'an t'it'alt'un. ");
INSERT INTO udi_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Zu ef běš elemi t'at'e sürüğo yaq'aboz ki, xivluğo, kənanluğo saal xet'luğo ef běšt'an şəp'eğat'un. ");
INSERT INTO udi_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ama şot'oğo sa usenen tez şəp'eğal, tene ölkə ams'ine mandon, ə̌qnə heyvanxoval avuzbaki və̌x hücumt'unbon. ");
INSERT INTO udi_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Zu şot'oğo və̌n avuzbaki ölkin q'ončux bakes bakala vədinəl śirik' yavaş-yavaş ef běšt'an şəp'eğoz. ");
INSERT INTO udi_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ef zahmana Č'oč'a dənizəxun Filist' dənizəl śirik', ams'i oç̌alaxun Yevfrat oqal śirik' zap'k'oz. T'e ölkinə yəşəyinşalt'oğo ef kiyel tadoz, və̌nal şot'oğo ef t'ǒǒxun şəp'eğalnan. ");
INSERT INTO udi_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nə şot'oğoxun, nəəl şot'oğoy buxačuxxoxun irəziluğ ma ğaç̌ekinan. ");
INSERT INTO udi_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Şot'oğo ef ölkinə yəşəyinşbsuna icaza ma tadanan, şot'aynak' ki, şot'oğon və̌x Bezi əyitəxun c'eysuna q'a içoğoy buxačuxxo bul k'os'bsuna zap'k'alt'un. Moval və̌ynak' tələ bakale». ");
INSERT INTO udi_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Oşa Q'ončuğon Moiseya pine: «Hun, Aaron, şot'ay ğarmux Nadav q'a Avihu saal israilluğoy ağsaq'q'alxoxun yetmiş tan Bez t'ǒǒx buruğo lakinan. Və̌n Za ə̌xil çurpi bul k'os'banan. ");
INSERT INTO udi_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Oşa isə saycə hun bez t'ǒğǒl ı̌šalayinşakalnu, ama azuk' memiya sal laśimaq'an». ");
INSERT INTO udi_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moiseyen hari Q'ončuğoy pit'oğo saal k'anunxo azuk'a p'ap'esebi. Bütüm azuk'enal sa səsen coğab tadi pine: «Q'ončuğon pit'oğo bitova əməlbalyan!». ");
INSERT INTO udi_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moiseyenal Q'ončuğoy pi bütüm əyitmoğo śamepi. Əyc'indəri şot'in savaxt'an üşenen hayzeri buruğoy tume q'urban eçala gane düzbi saal İsraili tayfoğoy saya görə p'as's'e ǰěne sütüne laxi. ");
INSERT INTO udi_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Oşa Moiseyen İsraili cəyilxo yaq'abi Q'ončuğoynak' bok'ospsuni q'urbanxo saal serluği q'urbaneynak' arak'xo eçest'i šampesedi. ");
INSERT INTO udi_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moiseyen heyvanxoy p'iyaxun qǐt'u ext'i ləənxone bapi, qǐt'u isə q'urban eçala gane loxole çəçədi. ");
INSERT INTO udi_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Şot'in śameśi irəziluği şərturxo ext'i azuk'eynak' k'alepi, azuk'enal pine: «Q'ončuğon pi bütüm əyitmoğo běği şot'oğo əməlbalyan!» ");
INSERT INTO udi_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Oşa Moiseyen p'iya ext'i azuk'i loxol çəçədi pine: «Mo Q'ončuğon bütüm me şərturxon və̌xun ğaç̌eśi irəziluği p'ine». ");
INSERT INTO udi_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mot'oğo bit'uxun oşa Moiseyen, Aaronen, Nadaven, Avihunen saal israilluğoxun bakala yetmiş ağsaq'q'alen buruğo samalal laśi ");
INSERT INTO udi_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","israilluğoy Buxačuğo at'unk'i. Şot'ay turin oq'a sapfiraxun bakala göy k'inək' qay irəngen sa şeye buy. ");
INSERT INTO udi_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ama Buxačuğon israilluğoy kalaluğbalxo bestenebi. Şot'oğon Buxačuğo at'unk'i, ama hələl ham ut'unksay, ham ǔt'ǔnğsay. ");
INSERT INTO udi_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Q'ončuğon Moiseya pine: «Bezi t'ǒǒx buruğo laki memiya çurpa. Zuval va me azuk'en əməlbseynak' Bezi śampi, izi loxol k'anunxo q'a əmirxo bakala t'ə̌p'ə̌k' ǰěyurxo tadoz». ");
INSERT INTO udi_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Metərluğen, Moisey q'a iz köməyçi Yeşua Buxačuğoy buruğo layseynak't'un həzirləyinşəki, Moiseyal buruğone laśi. ");
INSERT INTO udi_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Şot'in ağsaq'q'alxo pine: «Yan qoş qaybakamin memiya yaq'běğanan. Mone, Aaron q'a Xur ef t'ǒğǒlt'un - şii divanluğ əş bakayin, şot'oğoy t'ǒǒx tayes banekon». ");
INSERT INTO udi_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moisey buruğo lağat'an asoyen buruğo bəc'ürepi. ");
INSERT INTO udi_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Mo Q'ončuğoy tamtarağe Sinay buruğo śirey. Buruğ ǔq ği asoyi boşe baki. Vǔğǔmci ğine isə Q'ončuğon Moiseya asoyi boşt'an k'alepi. ");
INSERT INTO udi_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Q'ončuğoytamtarağ israilluğoy piin běš buruğoy bel bok'osp'i śik'ala arux k'inək'e ak'esay. ");
INSERT INTO udi_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisey asoyi boş baśi samalal alane laśi. Şo q'ırx ği-q'ırx şü buruğone mandi. ");
INSERT INTO udi_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«İsrailluğo upa ki, Zaynak' payurxoq'at'un eçeri. Şii ük'in k'ə çureğayin şot'o tadeq'an. Zaynak' eçala me payurxo hun q'abulba. ");
INSERT INTO udi_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Şot'oğoxun metər şeyurxo q'abulba: q'ızıl, gümüş, mis, ");
INSERT INTO udi_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","göyin, mumušak'i q'a tünd č'oč'a irəngen t'urin k'anak'xo, nəzik' kətani parça, keçin xa, ");
INSERT INTO udi_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","č'oč'a irəng duğeśi eğeli t'ol, nəzik' t'olurxo, yasəməni durut', ");
INSERT INTO udi_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","çirağa bapseynak' zeytuni c'əyin, bok'ospseynak' saal lə̌ə̌mst'eynak' bakala c'əyinə həzirbseynak' şaat' adeğala oyurxo, ");
INSERT INTO udi_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","samci běyinši döşlin saal iz suruk' cuye loxol laxseynak' oniks saal q'erəz ǰěyurxo. ");
INSERT INTO udi_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Oşa Zaynak' ı̌vel gaq'at'un düzbi ki, Zu içoğoy arane bakaz. ");
INSERT INTO udi_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Bezi me ı̌vel çadıra q'a şot'ay boş bakala bütüm şeyurxo Zu ak'est'ala k'inək' düzbanan». ");
INSERT INTO udi_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Barta yasəməni daxt'ak'axun sanduğq'at'un düzbi: boxoyluğ p'ə̌nqı̌ ə̌m, gengluğ q'a alloyluğ isə sə̌nqı̌ ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Şot'o bonaxun saal qavunaxun təmiz q'ızılen but'k'a, iz hərrəminə q'ızıli zolağ laxa. ");
INSERT INTO udi_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Q'ızıla q'əlibə bapi bip' dənə halq'a düzba. Şot'oğo qavunaxun sanduği bip' dönbine - p'ə̌ halq'ina sa tərəf, p'ə̌ halq'ina isə t'e soğo tərəf ost'aarba. ");
INSERT INTO udi_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Yasəməni xodaxun durut'xo düzba, iz looxun q'ızılen but'k'a. ");
INSERT INTO udi_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Sanduğa taşt'eynak' durut'xo sanduği börine bakala halq'oğo lavk'a. ");
INSERT INTO udi_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Durut'xo həmişə sanduği halq'oğoy boş lavk'q'an baki, şot'oğo t'et'iin ma c'evk'a. ");
INSERT INTO udi_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Zu vaxun irəziluğ ğač'eğat'an śameśi bütüm k'anunxo me sanduği boş laxa. ");
INSERT INTO udi_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Təmiz q'ızılaxun bağışlayinşbsuni q'apağ düzba. Şot'ay boxoyluğ p'ə̌nqı̌ ə̌m, gengluğ isə sə̌nqı̌ ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Bağışlayinşbsuni q'apaği p'ə̌ bel çəküçen əşeśi q'ızılaxun angelxo düzba. ");
INSERT INTO udi_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Sa angela q'apaği sa bel, t'e sunt'u isə t'e soğo bel t'etər düzba ki, q'apağaxun saq'at'un baki. ");
INSERT INTO udi_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Angelxon içoğoy q'ənədxon bağışlayinşbsuni q'apağa but'k'eq'at'un. Şot'oğon ç̌obaç̌o çurpi q'apaği loxolq'at'un běği. ");
INSERT INTO udi_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Bağışlayinşbsuni q'apağa sanduği loxol laxa, Zu va tadala śameśi irəziluğa isə sanduği boş. ");
INSERT INTO udi_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Zu t'et'iya, bağışlayinşbsuni q'apaği loxol, p'ə̌ angelxoy arane bakoz. Hunal Bezi t'ǒğǒl eğat'an israilluğoynak' bakala əmirxo va p'ap'esp'oz». ");
INSERT INTO udi_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Yasəməni xodaxun sa ist'ol düzba: boxoyluğ p'ə̌ ə̌m, gengluğ sa ə̌m, alloyluğ isə sə̌nqı̌ ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Şot'o təmiz q'ızılen but'k'a. İz hərrəmine q'ızıli zolağxo laxa. ");
INSERT INTO udi_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Şot'ay hərrəmine alloyluğ bip' k'əşə bakala t'ǒğǔrğo düzba. T'ǒğǔrğoy hərrəminəl q'ızıli zolağ laxa. ");
INSERT INTO udi_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","İst'oleynak' bip' dənə q'ızıli halq'a düzba, halq'oğo şot'ay bip' turaxun ost'aarba. ");
INSERT INTO udi_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Halq'oox t'ǒğǔrğo ləçəq' bakalane ki, ist'oli ganu badalbat'an durut'xoxun biq'i taşat'un. ");
INSERT INTO udi_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Durut'xo yasəməni xodaxun düzbi oşa iz looxun q'ızılen but'k'a; ist'ola t'e durut'xoxun biq'iq'at'un taşeri. ");
INSERT INTO udi_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","İst'oli loxol laxseynak' təmiz q'ızılaxun t'alik'xo q'a q'avurxo düzba. Śipseynak' bakala payurxoynak' cürdəkxo saal camurxo düzba. ");
INSERT INTO udi_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Za həsrbaki šumurxo həmişə ist'olin loxol Bez běšq'an baki». ");
INSERT INTO udi_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Təmiz q'ızılaxun sa pisos düzba. Me pisos çəküçen əşeśi təmiz q'ızılaxun bakalane. Şot'ay oq'in hissə, tur saal turin loxol bakala varde t'up'ulxo q'a xazalxo şot'oxun saq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Pisosi turaxun ǔq tayq'an taśi - xibo sa tərəfəxun, xiboval t'e soğo tərəfəxun. ");
INSERT INTO udi_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","T'e taymoğoy hər sunt'ay loxol badami s'is'ik'xo oşq'ardala xib dənə t'up'ulla saal vardla kasaq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Pisosi turin loxol isə vardla saal t'up'ulla badami s'is'ik'ə oşq'ardala bip' kasaq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Me t'up'ulxoy soğo pisosi turaxun tağala süft'in p'ə̌ taye oq'a, t'e soğo p'ə̌mci tağala p'ə̌ taye oq'a, xibimciyo isə xibimci tağala p'ə̌ taye oq'aq'an baki. Metər, şorox bütüm ǔq taye oq'aq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","T'up'ulxo q'a tayurxo pisosaxun sa, çəküçen əşeśi təmiz q'ızılaxunq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Pisoseynak' vǔğ dənə zeytuni c'əyinen bok'ala fit't'ələ çirağ düzbi iz loxol laxa ki, běš işiğq'an saki. ");
INSERT INTO udi_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Fit't'oğoynak' bakala maşoox q'a xətəngəzxoval təmiz q'ızılaxunq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Pisos saal şot'o əşp'est'eynak' lazım bakala bito şeyurxo sa t'alant' təmiz q'ızılaxunq'an düzbaki. ");
INSERT INTO udi_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Běğa, mot'oğo dəgig Zu va me buruğo ak'est'it'ullarik' düzba». ");
INSERT INTO udi_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Q'ončuğon saal pine: «Ǐvel çadıra vis' pərdinəxun düzba. Pərdoğo göyin, mumušak'i saal tünd č'oč'a irəngen bakala nəzik' kətani t'uriğon ə̌leśi parçoğon düzba, iz loxolal angelxoy şikilen q'əşəng laxeśi naxışxoq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Barta bütüm pərdoox sa boydaq'an baki. Hər pərdin boxoyluğ saq'o muğ ə̌m, gengluğ isə bip' ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pərdoğoy qo dəno sunaxun, t'e soğo qoval sunaxunq'an ěbeśi. ");
INSERT INTO udi_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Samci qo ěbeśi pərdin börine bakala pərdin t'ǒǒx göyin irəngen t'urinen halq'oox düzba. T'e soğo ěbeśi qo pərdin börine bakala pərdin t'ǒǒxal hat'etər halq'oox düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Samci ěbeśi qo pərdin börine əlli dənə t'urin halq'a, t'e soğo ěbeśi qo pərdin börineyal şot'oğoxun düz eğala əlli dənə t'urin halq'a düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Q'ızılaxun əlli dənə q'armağ düzba. T'e q'armağxon pərdoğo ost'aarbi sun-sunaxun calağba ki, çadır saq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ǐvel çadıri looxun but'kseynak' keçin xayen sas's'e dənə pərdə düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Pərdoğoy sas's'oval sa boydaq'an baki: boxoyluğ otuz ə̌m, gengluğ isə bip' ə̌m. ");
INSERT INTO udi_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Qo pərdinə cöy, t'iyə̌mi ǔq pərdinə cöy ěba. Ǔqǔmci pərdinə çadıri bağala gane běš p'ə̌qə̌tba. ");
INSERT INTO udi_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Samci ěbeśi qo pərdin börine bakala pərdin t'ǒǒx əlli dənə, t'e soğo ěbeśi ǔq pərdin börine bakala pərdin t'ǒǒxal əlli dənə t'urinen halq'a düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Misəxun əlli q'armağ düzbi şot'oğo halq'oğoxun c'ovakest'i pərdoğo sun-sunaxun calağba ki, çadır saq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Çadıri pərdoğoxun avuzin mandi pərdin q'ǐyo ı̌vel çadıri bač'ani tərəfəxun suruk'eśeq'an. ");
INSERT INTO udi_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ǐvel çadıri looxun but'eğala pərdoğoy avuzin mandi sa ə̌m parça isə çadıri p'ə̌ tərəfəxun suruk'eśi şot'o tam but'k'eq'an. ");
INSERT INTO udi_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Çadıri looxun č'oč'a gombi eğeli t'olen saal q'erəz sa nəzik' t'olen xibimci q'atenal but'k'a. ");
INSERT INTO udi_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ǐvel çadıreynak' yasəməni durut'axun tik çurk'ala çərçüvox düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Hər çərçüvin boxoyluğ vis' ə̌m, gengluğ isə sə̌nqı̌ ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hər çərçüvin oq'a şot'o iz laxala gala ost'aarbseynak' p'ə̌ dənə turq'an baki. Ǐvel çadıri bütüm çərçüvoğo metər düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ǐvel çadıri güney tərəfeynak' q'a çərçüvə ");
INSERT INTO udi_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","saal şot'oğo ost'aarbseynak' gümüşəxun q'ırx dənə laxala ga düzba: hər çərçüvin oq'a p'ə̌ dənə laxala ga, içoğoy durut'in saya görə. ");
INSERT INTO udi_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ǐvel çadıri q'uzey tərəfeynak'al q'a çərçüvə ");
INSERT INTO udi_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","saal şot'oğo ost'aarbseynak' gümüşəxun q'ırx dənə laxala ga, hər durut'i oq'a p'ə̌ dənə laxala ga. ");
INSERT INTO udi_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ǐvel çadıri bač'aneynak', běğ batk'ala tərəfeynak' ǔq çərçüvə düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ǐvel çadıri bač'ani dönbineynak' isə p'ə̌ çərçüvə düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Morox oq'axun çüt hari ala sa halq'ina ost'aarbakalat'un. Hər p'ə̌ dönbineynak' haketər p'ə̌ çərçüvəq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Metər, me muğ çərçüvin ǔqěs's'e dənə gümüşəxun laxala gaq'an baki: hər çərçüvin oq'a p'ə̌ dənə laxala ga. ");
INSERT INTO udi_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ǐvel çadıreynak' yasəməni durut'axun peşt'uvanxo düzba: hər t'ǒğeynak' qo peşt'uvan, ");
INSERT INTO udi_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","saal běğ batk'ala tərəf bakala çərçüvineynak' qo peşt'uvan. ");
INSERT INTO udi_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Bı̌ğin peşt'uvan çadıri sa belxun t'iyə̌mi bel śirik' baki çərçüvoğo sunaxun ğaç̌k'alane. ");
INSERT INTO udi_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Çərçüvoğo q'a peşt'uvanxo q'ızılen but'k'a, peşt'uvanxo efala halq'oğoval q'ızılaxun düzba. ");
INSERT INTO udi_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ǐvel çadıra Zu va buruğo ak'est'i k'inək' laxa. ");
INSERT INTO udi_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Göyin, mumušak'i saal tünd č'oč'a irəngen bakala t'uriğon q'a nəzik' ə̌leśi kətani parçinaxun sa pərdə düzba. İz loxol isə bacarağlu ust'an angeli şikilxon bakala naxışxoq'an düzbi. ");
INSERT INTO udi_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Şot'o q'ızıli q'armağxoxun bip' sütüni loxol suruk'p'a. Sütünxo q'ızılen bəc'üreśi yasəməni durut'axunq'an baki, içoğoy oq'a isə gümüşəxun laxala ga bakalane. ");
INSERT INTO udi_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Pərdinə q'armağxoxun suruk'p'a, irəziluği sanduğal pərdin bač'ane laxa. Me pərdinen ı̌vel ganuxun ən ı̌vel bakala ganu cöybale. ");
INSERT INTO udi_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Bağışlayinşbsuni q'apağa ən ı̌vel gala bakala irəziluği sanduği loxol laxa. ");
INSERT INTO udi_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","İst'ola pərdin t'e soğo tərəf ı̌vel çadıri q'uzey tərəfəxun laxa, pisosa isə şot'oxun ç̌obaç̌o ı̌vel çadıri güney tərəfəxun laxa. ");
INSERT INTO udi_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Çadıri bağala ganeynak' göyin, mumušak'i, tünd č'oč'a irəngen bakala t'uriğon q'a nəzik' ə̌leśi kətani parçinaxun sa pərdə düzba, iz loxolal ěbunen naxışxoq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Me pərdineynak'al yasəməni durut'axun qo dənə q'ızılen but'eśi sütün düzba. Şot'oğoy loxol q'ızıli q'armağxoq'an baki. Sütünxoynak' misəxun q'əliben düześi qo dənə laxala ga düzba». ");
INSERT INTO udi_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Yasəməni durut'axun sa q'urban eçala ga düzba. Barta şo bip'dönbələq'an baki, iz boxoyluğ q'a gengluğ qo ə̌m, alloyluğ isə xib ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Q'urban eçala gane bip' dönbineyal mǔq'ə̌q'an baki, şot'oğo t'etər düzba ki, şorox q'urban eçala ganuxun saq'an baki. Oşa t'e ganu tuncen but'k'a. ");
INSERT INTO udi_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Şot'ay jeq'e q'avurxo, ist'amxo, ləənxo, çəngəlxo, xətəngəzxo - bütüm şeyurxo misen düzba. ");
INSERT INTO udi_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Q'urban eçala ganeynak' reşotk'a - misəxun bakala set'k'a düzba. T'e set'k'in hər bip' dönbineynak'al tuncaxun halq'a düzba. ");
INSERT INTO udi_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Şot'o q'urban eçala gane zolağaxun oq'a t'etər laxa ki, set'k'a şot'ay qǐt'ul śirik'q'an p'ap'i. ");
INSERT INTO udi_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Q'urban eçala ganeynak' yasəməni xodaxun durut'xo düzba, iz looxunal misen but'k'a. ");
INSERT INTO udi_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Me durut'xo q'urban eçala gane börüğo bakala halq'oğo lavk'eğale ki, iz ganu badalbat'an şot'oğoxun biq'i taşat'un. ");
INSERT INTO udi_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Q'urban eçala ga iz boşt'an ams'i hamal daxt'ak'enq'an baki. Şot'o dəgig va buruğo ak'est'i k'inək' düzba». ");
INSERT INTO udi_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Ǐvel çadıri məəlinə cöybseynak' güney tərəfəxun boxoyluğ sabaç̌ ə̌m bakala nəzik' kətani t'urinen ə̌leśi pərdoox düzba. ");
INSERT INTO udi_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Şot'oğoynak' q'a dənə sütün saal şot'oğoy oq'a laxseynak' misəxun q'a dənə laxala ga düzba. Q'armağxo q'a halq'oox isə gümüşəxunq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Q'uzeyi tərəfeynak' bakala pərdin boxoyluğal sabaç̌ ə̌mq'an baki; şot'oğoynak'al q'a dənə sütün saal misəxun q'a dənə laxala ga düzba. Sütünxoy q'armağxo q'a halq'oox isə gümüşəxunq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Məəlin běğ batk'ala tərəfeynak' bakala pərdoğoy boxoyluğ isə əlli ə̌mq'an baki. Şot'oğoynak' vis' dənə sütün saal vis' dənə laxala ga düzba. ");
INSERT INTO udi_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Məəlin běğ c'eğala tərəfi gengluğal əlli ə̌mq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Bağala gane sa tərəfeynak' hər sunt'ay iz laxala ga bakala xib sütünin loxol, iz boxoyluğ qos's'e ə̌m bakala pərdooxq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","T'e soğo tərəfeynak'al hər sunt'ay iz laxala ga bakala xib sütünin loxol, iz boxoyluğ qos's'e ə̌m bakala pərdooxq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Məəlin bağala ganeynak' boxoyluğ q'a ə̌m bakala göyin, mumušak'i, tünd č'oč'a irəngen t'uriğoxun q'a nəzik' kətani t'uriğon ə̌leśi naxışla pərdə düzba. Şot'ay bip' sütün, içoğoy oq'a laxseynak'al bip' dənə laxala gaq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Məəlin t'ǒğǔrğoy bütüm sütünxoy ğaç̌esunxo q'a q'armağxo gümüşəxunq'an baki, içoğoy laxala ganxo isə misəxunq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Məəlin boxoyluğ sabaç̌ ə̌m, iz gengluğ isə əlli ə̌mq'an baki, iz nəzik' kətani t'urinen ə̌lěśi pərdin alloyluğ isə qo ə̌m. Sütünxoy laxala ganxo misəxunq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ǐvel çadıri boş q'ulluğeynak' əşeğala bütüm şeyurxo misəxunq'an baki. Məəlin pərdoğo ğaç̌bseynak' əşeğala mixçooxal ı̌vel çadıri pərdoğo ğaç̌bseynak' əşeğala mixçoğollarik' misəxunq'an baki». ");
INSERT INTO udi_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Hun israilluğo əmirba ki, çirağa bapseynak' vaynak' toxmağen č'ak'p'i c'evk'i, təmiz zeytuni c'əyinq'at'un eçeri. T'e çirağxo pisosi loxol həmişə bok'alane. ");
INSERT INTO udi_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaronen q'a iz ğarmoğonal běğalat'un ki, me çirağxo ı̌vel çadıri boş, irəziluği sanduğ bakala ən ı̌vel ganu cöybala pərdin běš biyəsinəxun savaxt'inal śirik' bok'eq'an. Barta mo israilluğoynak' nəsiləxun nəsilə c'ovakala həmişəluğ sa q'aydaq'an baki». ");
INSERT INTO udi_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Q'ončuğon Moiseya pine: «Hun vi viçi Aarona saal şot'ay ğarmux Nadava, Avihuna, Eleazara saal İt'amara israilluğoy aranexun vi t'ǒğǒl eçest'a ki, şot'oğon Zaynak' běyinšluğq'at'unbi. ");
INSERT INTO udi_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Vi viçi Aaroneynak' q'əşəng saal běyinšluğa layiğ ǐvel paltarxo ěbest'a. ");
INSERT INTO udi_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Zu bacarağ tadi bütüm ust'oğo tapşurba ki, Aaron Bezi c'ək'eśi běyinš bakseynak' şot'aynak' paltarxoq'at'un düzbi, şoval běyinš baki Zaynak' běyinšluğq'anbi. ");
INSERT INTO udi_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Şot'oğon me paltarxo düzbalat'un: döşli q'a iz suruk' cu, döşli, xələt q'a iz oq'axun lak'ala gurat', çalma saal q'ayinş. Me ǐvel paltarxo vi viçi Aaroneynak' saal iz ğarmoğoynak' ěbeq'at'un ki, şot'oğonal Zaynak' běyinšluğq'at'unbi. ");
INSERT INTO udi_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Barta paltara ěbalxon q'ızıli, göyin, mumušak'i, tünd č'oč'a irəngen t'uri saal nəzik' kətani parçaq'at'un ext'i. ");
INSERT INTO udi_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Samci běyinši döşli göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon saal nəzik' kətani t'uriğon ə̌leśi parçinenq'an baki. İz loxolal bacarağlu ust'oğon q'ızıli t'urinen naxışxoq'at'un laxi. ");
INSERT INTO udi_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Şot'ay loxol ə̌mnəbelxun tağala p'ə̌ parçaq'an ěbeśi ki, şot'oğon döşlin p'ə̌ bula sunaxun ğaç̌p'eq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Samci běyinši döşlin loxol bakala q'ayinşal içuxun saq'an baki. Şoval q'ızıli, göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon saal nəzik' ə̌leśi kətani parçinenq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","P'ə̌ dənə oniks uk'ala ǰě ext'a, şot'oğoy loxol İsraili ğarmoğoy s'iyurxo śampa. ");
INSERT INTO udi_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Şot'oğoy s'iyurxo kalat'uxun burqi mis'ik't'ul śirik' ǔqə̌ray s'iya sa ǰěne loxol, ǔqə̌ray s'iyal t'e sunt'ay loxol śampa. ");
INSERT INTO udi_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","İsraili ğarmoğoy s'iyurxo t'e ǰěyurxoy loxol ǰě t'ap'k'alen toyexlu ǰěnaxun peçat düzbat'an şot'o tapk'ala k'inək' t'api śampa. Oşa t'e ǰěyurxo q'ızıli çərçüvoğoy boş laxa. ");
INSERT INTO udi_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Me p'ə̌ ǰěna samci běyinši döşlin ə̌mnəbelxun tağala parçinaxun biq'est'a. Morox israilluğo eyex efseynak' bakala ǰěyurxone. Aaronen şot'oğoy s'iyurxo həmişə Q'ončuğoy eyex bakseynak' iz p'ə̌ ə̌mnəbel taradale. ");
INSERT INTO udi_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Q'ızılaxun çərçüvoox düzba, ");
INSERT INTO udi_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","təmiz q'ızılaxun p'ə̌ dənə kəndür k'inək' ə̌leśi zincir düzba; me zincirxo çərçüvoğoxun lavk'a. ");
INSERT INTO udi_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Buxačuğoy q'ərara avabakest'ala ǰěna tarast'eynak' suruk' cu düzba. T'e cuya bacarağlu ust'oğon samci běyinši döşli k'inək' q'ızıli, göyin, mumušak'i, tünd č'oč'a irəngen bakala t'uriğon saal nəzik' ə̌leśi kətani parçinenq'at'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Suruk' cu p'ə̌ q'at parçinen, bip'dönbələq'an baki: iz boxoyluğ sa ci, gengluğal sa ciq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","İz loxol bip' cörgə ǰě t'ak'p'a. Samci cörginə rubin, topaz, izumrud, ");
INSERT INTO udi_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","p'ə̌mci cörginə isə birüzə, göyin rubin saal almaz, ");
INSERT INTO udi_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","xibimci cörginə giaśint', agat' saal amet'ist', ");
INSERT INTO udi_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","bip'imci cörginə isə beril, oniks saal yasp'is uk'ala toyexlu ȷ̌eyurxoq'an baki. Me ǰěyurux q'ızılaxun düzbaki çərçüvoğoq'an laxeśi. ");
INSERT INTO udi_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Şorox İsraili ğarmoğoy saya görə p'as's'e dənəq'an baki. Me pas's'e ğare s'iya me ǰěyurxoy loxol peçat k'inək' t'etər t'ap'anan ki, hər ǰěne loxol sunt'ay s'iq'an baki. Morox israilluğoy pas's'e tayfin s'iyurxone. ");
INSERT INTO udi_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Suruk' cuyeynak' təmiz q'ızılaxun kəndür k'inək' ə̌leśi zincirxo düzba. ");
INSERT INTO udi_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Suruk' cuyeynak' p'ə̌ dənə q'ızıli halq'a düzbi şot'oğo cuye p'ə̌ dönbine biq'est'a. ");
INSERT INTO udi_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","T'e p'ə̌ q'ızıli zincirə suruk' cuye p'ə̌ halq'inaxun biq'est'a. ");
INSERT INTO udi_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Zincirxoy t'e soğo bulurxo isə döşlin ə̌mnəbel bakala çərçivoğoxun, běšin tərəfəxun biq'est'a. ");
INSERT INTO udi_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Saal p'ə̌ q'ızıli halq'a düzba, şot'oğo suruk' cuye bonin p'ə̌ dönbine biq'est'i samci běyinši döşlinəxun ost'aarba. ");
INSERT INTO udi_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Q'erəz p'ə̌ q'ızıli halq'al düzba, şot'oğo samci běyinši döşlin ə̌mnəbelxun tağala parçin oq'in tərəfəxun biq'est'a. Mo düz q'ayinş ğaç̌eğala gane alaxune bist'a. ");
INSERT INTO udi_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Suruk' cuye halq'oğo samci běyinši döşlin halq'oğoxun göyin irəngen bakala bağen t'etər ğaç̌p'a ki, cu döşlin q'ayinşi oq'a mandi şot'oxun saq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Barta Aaronen ı̌vel gala bağat'an İsraili ğarmoğoy s'iyurxo me cuyaxun sagala iz döşe taradeq'an ki, şorox həmişə Q'ončuğoy eyexq'at'un baki. ");
INSERT INTO udi_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Cuye boş isə q'ərara avabakest'ala urim saal t'ummim uk'ala ǰěyurxo laxa ki, Aaron Q'ončuğoy běš eğat'an şorox iz ük'e loxolq'an baki. Metər, Aaronen israilluğo divanbat'an Q'ončuğoy běš me ǰěyurxo həmişə iz ük'e loxol taradale. ");
INSERT INTO udi_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Samci běyinši döşlin oq'axun bakala paltara göyin irəngen parçinen ěba. ");
INSERT INTO udi_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Bǐyexun bul c'ovakseynak' ga efa. Şot'ay t'ǒğǔrğo nu zığbakseynak' t'urinen ěba. ");
INSERT INTO udi_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","T'e paltari ətəyi hərrəmine göyin, mumušak'i q'a tünd č'oč'a irəngen t'uriğon mis'ik' ə̌lə̌mxo, içoğoy araneyal zəngürxo düzba. ");
INSERT INTO udi_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","T'e ə̌lə̌mxo q'a zəngürxo paltari ətəyi hərrəmine sunay bač'anexunq'an t'ak'eśi. ");
INSERT INTO udi_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Me xələt Aaronen q'ulluğbala vədine iz loxolq'an baki. Barta t'e zəngürxonal şot'ay ı̌vel gala - Q'ončuğoy běš baśi-c'eğala vədine səsbeq'at'un. Əgər şot'in metər lak'ayin, tene biyal. ");
INSERT INTO udi_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Təmiz q'ızılaxun sa medalyon düzbi şot'ay loxol \"Q'ončuğoynak' ı̌velbaki\" śama peçati loxol t'ap'k'ala k'inək' t'api śampa. ");
INSERT INTO udi_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Şot'o göyin bağen çalmin loxol - běšin tərəf ost'aarba ki, ");
INSERT INTO udi_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","t'e śama Aaronen iz k'odoğoy loxolq'an taradi. Metər t'e ı̌vel gala q'urbanxo q'a payurxo eşt'unast'a sa sərf bakayin, t'e günaxa Aaronen iz ozane ext'ale, t'e q'urbanxoval Buxačuğon q'abulbale. ");
INSERT INTO udi_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Aaroneynak' nəzik' kətani parçinaxun gurat' ěba. Çalminal nəzik' kətanaxun düzba. Parçinaxun bakala q'ayinşi loxol t'urinen naxışxo laxa. ");
INSERT INTO udi_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaroni ğarmoğoynak'al běyinšluğa layiğ urbaşk'oox, q'ayinşxo saal papaq'xo ěba. ");
INSERT INTO udi_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Me paltarxo vi viçi Aarona saal iz ğarmoğo lapest'a. Oşa şot'oğo c'əyin lə̌ə̌mdi, běyinš laxa. Metərluğen, Za həsrba ki, Zaynak' běyinšluğq'at'unbi. ");
INSERT INTO udi_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Bı̌ğaxun k'ə̌k'ə̌p'ə̌l śirik' içoğoy çup'lağluğa but'kseynak' kətani parçinaxun qǒlǒğxo ěba. ");
INSERT INTO udi_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaronen q'a iz ğarmoğon ı̌vel gala q'ulluğbseynak' ı̌vel çadıra bağat'an nəəl q'urban eçala ganu ı̌ša eğat'an mot'oğo taxsırsuz baki nu biseynak' lak'alat'un. Mo Aaroneynak' q'a iz ğarmoğoynak' nəsiləxun nəsilə c'ovakala həmişəluğ q'aydaq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Aarona saal iz ğarmoğo Bez běyinš bakseynak' me q'aydinen ı̌velba. Salamat sa arak' saal p'ə̌ q'oç ext'a. ");
INSERT INTO udi_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Saal xuri berxeśi xarinaxun ə̌yinsuz šum, zeytuni c'əyini boş šareśi ə̌yinsuz yoxa q'a iz loxol zeytuni c'əyin lə̌ə̌mdi ə̌yinsuz k'ok'alxo həzirba. ");
INSERT INTO udi_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Şot'oğo sa zənbili boş laxi arak'axun q'a p'ə̌ q'oçaxun sagala eça. ");
INSERT INTO udi_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Oşa Aarona q'a iz ğarmoğo ı̌vel çadıri bağala gala eça, şot'oğo xenen os'k'a. ");
INSERT INTO udi_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Aarona gurat'a, döşlin oq'axun bakala paltara, samci běyinši döşlüyə, saal suruk' cuya lapest'a, oşa q'ayinşal iz bǐyex ğaç̌p'a. ");
INSERT INTO udi_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Şot'ay bel çalmina, çalmin loxolal ǐvelluği taca ost'aarba. ");
INSERT INTO udi_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Lə̌ə̌mst'eynak' bakala c'əyinə Aaroni bel lapi şot'o lə̌ə̌mda. ");
INSERT INTO udi_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Oşa Aaroni ğarmoğo içoğoy paltara lapest'a. ");
INSERT INTO udi_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aaroni saal şot'ay ğarmoğoy bı̌yex parçinaxun bakala q'ayinş ğaç̌p'a, iz ğarmoğoy bel papaq' laxa. Hametər, Aarona q'a iz ğarmoğo běyinš laxa. Me běyinšluğal şot'oğoy nəsileynak' həmişəluğ sa q'aydaq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Oşa arak'a ı̌vel çadıri běš eça. Barta Aaronen q'a iz ğarmoğon içoğoy kulmoğo arak'i belq'at'un laxi. ");
INSERT INTO udi_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Arak'a Q'ončuğoy běš, ı̌vel çadıri bağala gala šampa. ");
INSERT INTO udi_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Arak'i p'iyaxun ext'a, vi k'əşinen q'urban eçala gane mǔq'ǒğo lə̌ə̌mda. Mandi p'iya isə q'urban eçala gane tume śipa. ");
INSERT INTO udi_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Heyvani boşin c'əyinə, mə̌yin ciyəri loxol bakala c'əyinə saal p'ə̌ gurdak'a iz loxol bakala c'əyinəxun sagala q'urban eçala gala bok'osp'a. ");
INSERT INTO udi_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Arak'i yeq'a, t'ola saal gödənxo isə azuk'i çurk'ala ganuxun ə̌xil bok'osp'a. Mo běyinšxoy günaxxo os'kseynak' bakala q'urbane. ");
INSERT INTO udi_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Q'oçurxoy sunt'u ext'a, barta Aaronen q'a iz ğarmoğon içoğoy kulmoğo t'e q'oçe belq'at'un laxi. ");
INSERT INTO udi_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Oşa me q'oça šampa, iz p'iyal q'urban eçala gane böroğo çəçədə. ");
INSERT INTO udi_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Q'oçe yeq'a k'as'p'a, iz çalata q'a turmoğo os'k'i bulaxun sagala k'as'p'i tikoğoy t'ǒğǒl laxa. ");
INSERT INTO udi_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Oşa q'oça bitova q'urban eçala gala bok'osp'a. Mo Q'ončuğoynak'bok'ospsuni q'urbane. Me bok'osp'akala paye adal Şot'o irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","T'e soğo q'oçal ext'a, barta Aaronen q'a iz ğarmoğon içoğoy kulmoğo şot'ay bel laxeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Oşa me q'oça šampi iz p'iyaxun samal ext'i Aaroni q'a iz ğarmoğoy yön ǔmǒğo, şot'oğoy yön kiin saal yön turin kala k'əşinə lada. Oşa q'oçe p'iyaxun q'urban eçala gane böroğoval çəçədə. ");
INSERT INTO udi_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Q'urban eçala ganu bakala p'iyaxun q'a lə̌ə̌mst'eynak' bakala c'əyinəxun ext'i Aaroni saal şot'ay paltarxoy, iz ğarmoğoy saal şot'oğoy paltarxoy loxol çəçədə. Metər, Aaron saal şot'ay paltarxo, iz ğarmux saal şot'oğoy paltarxo pak bakale. ");
INSERT INTO udi_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Oşa me q'oçe c'əyinə, t'ump'ak'a, boşin c'əyinə, mə̌yin ciyəri loxol bakala c'əyinə, p'ə̌ gurdak'al iz loxol bakala c'əyinəxun sagala saal yön buda ext'a. Şot'aynak' ki, mo běyinšxo ǐvelbseynak' eçala q'oçe. ");
INSERT INTO udi_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Q'ončuğoy běš bakala ə̌yinsuz šume zənbili boşt'an sa yoxa, zeytuni c'əyinen šareśi yoxa saal sa k'ok'al ext'a. ");
INSERT INTO udi_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Mot'oğo bitova Aaroni q'a iz ğarmoğoy kiyel tada ki, şot'oğon alabi mot'oğoy Q'ončuğoynak' sa pay baksuna ak'est'eq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Oşa mot'oğo içoğoy kiyexun ext'i q'urban eçala gala q'urbanluği yeq'axun sagala bok'osp'a. Mo Q'ončuğoynak'bok'ospsuni q'urbane. Me bok'ospsuni paye adal Şot'o irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aarona běyinš laxseynak' bakala q'urbanluği q'oçe döşe yeq'a ext'i Q'ončuğoy běš alabi sa pay baksuna ak'est'a. Me pay vi bakale. ");
INSERT INTO udi_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Aarona q'a iz ğarmoğo běyinš laxseynak' eçeri Q'ončuğoy běš alabi q'urbanluği q'oçe döşe yeq'e saal buda ǐvel baksuna bayanba. ");
INSERT INTO udi_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","İsrailluğon eçala q'urbanxoy me payurxo həmişəluğ Aaroni q'a iz ğarmoğoynak'q'an baki. Moroxal israilluğon eçala serluği q'urbanxoxunQ'ončuğoynak'alabaki payurxoq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aaroni ǐvel paltarxo içuxun oşa iz nəsiləq'an mandi ki, şot'oğoval c'əyin lə̌ə̌mdi běyinšbat'an me paltarxo lapeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Barta şot'ay gala běyinšluğa eğala ğaren ı̌vel gala q'ulluğbseynak' ǐvel çadıra bağat'an vǔğ ği t'e paltarxo lapeq'an. ");
INSERT INTO udi_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Běyinš laxseynak' bakala q'urbanluği q'oçe yeq'a ext'i sa ǐvel gala ǰalda. ");
INSERT INTO udi_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaronen q'a iz ğarmoğon t'e q'oçe yeq'a saal zənbilə bakala šuma ı̌vel çadıri bağala gala kəyeq'at'un. ");
INSERT INTO udi_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","İçoğo běyinš laxseynak' bakala, ı̌velbala, içoğoy günaxxo os'k'ala me payurxoxun şot'oğon içanq'at'un kəyi. Q'erəz amdarxon isə me payurxoxun maq'an kəyi, şot'aynak' ki, me payurxo ǐvele. ");
INSERT INTO udi_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Əgər běyinš laxseynak' bakala q'urbanluği yeq'axun q'a šumaxun savaxt'ineynak' mandayin, şot'oğo bok'osp'a, şorox nu ukeğalane, şot'aynak' ki, şorox ǐvele. ");
INSERT INTO udi_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Zu va hetərez əmirbesa, hat'etərəl Aarona q'a iz ğarmoğo ba. Şot'oğo běyinš laxsuni vaxt' vǔğ ği zap'k'alane. ");
INSERT INTO udi_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Hər ği şot'oğoy günaxxo os'kseynak' sa arak' q'urban eça ki, Zu şot'oğoy günaxxo bağışlayinşaz. Q'urban eçala ganuval pakbseynak' sa arak' q'urban eça, hamal q'urban eçala ganu c'əyin lə̌ə̌mda ki, ı̌velq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Hametər, vǔğ ği q'urban eçala ganu pakbi şot'o ǐvelba. Oşa q'urban eçala ga ən ǐvel hesabbakale, şot'o laft'ala hər şeyal ǐvel bakale. ");
INSERT INTO udi_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Hər ği q'urban eçala gala sa usenluğ p'ə̌ q'uzi eça. ");
INSERT INTO udi_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Q'uzin sunt'u savaxt'an, t'e sunt'u isə biyəsin šampa. ");
INSERT INTO udi_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Samci q'uzinaxun sagala me şeyurxoval q'urban k'inək' eça: hine bip' payaxun sa pay zeytuni c'əyinəxun gər efin vis' payaxun sa payarumi xari saal śipseynak' bakala pay k'inək' hine bip' payaxun sa pay fi. ");
INSERT INTO udi_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","T'e soğo q'uzinal savaxt'an eçeri q'urbanallarik' taxıli saal śipseynak' bakala payurxoxun sagala eça. Mo Q'ončuğoynak'bok'ospsuni q'urbane, iz adal Şot'o irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","43","Me bok'ospsuni q'urbana vaxun oşa eğala nəsilxonal ı̌vel çadıri bağala gala, Q'ončuğoyběš həmişə eçalat'un. Hun saal israilluyox Bezi t'ǒğǒl eğat'anal Zu t'iya baki və̌xun exlətp'oz. Me gaal Bezi şərəfen q'a kala zoren ı̌vel bakale. ");
INSERT INTO udi_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Zu ı̌vel çadıra q'a q'urban eçala ganu ǐvel booz; Aarona q'a iz ğarmoğoval ǐvel booz ki, Zaynak' běyinšluğq'at'unbi. ");
INSERT INTO udi_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Zu israilluğoy arane məsk'ən saki şot'oğoy Buxačux bakoz. ");
INSERT INTO udi_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Şot'oğonal avabakalt'un ki, içoğoy arane bakseynak' şot'oğo Misiri oç̌alaxun c'evk'i Buxačux Q'ončux Zuzu. Zu şot'oğoy Buxačux bakala Q'ončuxzu. ");
INSERT INTO udi_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Yasəməni xodaxun buxur bok'ospseynak' q'urban eçala ga düzba. ");
INSERT INTO udi_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","İz boxoyluğ q'a gengluğ sa ə̌m, alloyluğ isə p'ə̌ ə̌mq'an baki. İz dönboğo bakala mǔq'ǒxal içuxun saq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Şot'ay ç̌oya, t'ǒğǔrxo saal mǔq'ǒğo təmiz q'ızılen but'k'a, hərrəmine q'ızıli zolağ laxa. ");
INSERT INTO udi_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","P'ə̌ q'ızıli halq'a düzbi şot'oğo q'urban eçala gane p'ə̌ t'ǒǒx, zolaği oq'axun ost'aarba. Şot'ay ganu badalbat'an me halq'oğo badi durut'xoxun biq'i taşalt'un. ");
INSERT INTO udi_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Durut'xo yasəməni xodaxun düzbi q'ızılen but'k'a. ");
INSERT INTO udi_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Me q'urban eçala ganu ı̌vel q'a ən ı̌vel ganu cöybala pərdin běš laxa. Bağışlayinşbsuni q'apağ q'a ı̌vel sanduğ t'e pərdin bač'anene. Və̌n Bezi t'ǒğǒl eğat'an Zu t'iya baki və̌xun exlətp'oz. ");
INSERT INTO udi_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Barta Aaronen me q'urban eçala gala şaat' adeğala buxurq'an bok'osp'i. Ham savaxt'an çirağxo həzirbala vədine, ");
INSERT INTO udi_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","hamal biyəsin çirağxo bəc'ük't'ala vədine şot'o t'iya bok'osp'eq'an. Barta Q'ončuğoy běš me buxur bok'ospsun nəsiləxun nəsilə c'ovaki həmişəluğq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Me q'urban eçala gane loxol maninesa ı̌vel nu bakala buxur, nə bok'ospsuni q'urban, nəəl taxıli pay ma eçanan; śipseynak' bakala payal ma eçanan. ");
INSERT INTO udi_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Usena sa kərəm Aaronen iz q'a azuk'i günaxxo os'kseynak' bakala q'urbani p'iyaxun q'urban eçala gane mǔq'ǒğo lə̌ə̌mdi t'e ganu pakq'anbi. Metərluğen, usena sa kərəm nəsiləxun nəsilə c'ovaksunen mot'o banan. Me q'urban eçala ganu Q'ončuğon ən ǐvele hesabsa». ");
INSERT INTO udi_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«İsrailluğo siyəyinə haq'at'an bǒq'ə̌leğala hər sa amdaren iz elmoğoy haq'q'a Q'ončuğo tadeq'an ki, bǒq'ə̌lesuna görə içoğoynak' bələ maq'an hari. ");
INSERT INTO udi_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Bǒq'ə̌leśi hər amdaren qǐ şek'el gümüşq'an tadi (ı̌vel gala bakala çəkinə görə 1 şek'el 20 gere). Me qǐ şek'elQ'ončuğoy paye. ");
INSERT INTO udi_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bǒq'ə̌leśi amdarxoxun q'a yəşəxun ala bakala hər işq'aren me paya Q'ončuğo tadeq'an. ");
INSERT INTO udi_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ef elmoğoy gala bakala haq'q'a Q'ončuğo tadat'an varlunen qǐ şek'elaxun gele, kəsiben isə qǐ şek'elaxun mal maq'an tadi. ");
INSERT INTO udi_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Me tənginə israilluğoxun ext'i ı̌vel çadıra q'ulluğbseynak' əşp'est'a. Metərluğenal israilluğon həmişə içoğoy eyex efalt'un ki, Q'ončux hetəre içoğoy tərəf baki, içoğoy elmoğo çark'est'i». ");
INSERT INTO udi_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Pak bakseynak' sa misnə ləən düzba. Şot'ay laxala gaal misəxunq'an baki. Şot'o ı̌vel çadıri q'a q'urban eçala gane arane laxi xenen buyba ki, ");
INSERT INTO udi_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaronen q'a iz ğarmoğon içoğoy kul-tura t'e xenen os'k'at'un. ");
INSERT INTO udi_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Şorox ı̌vel çadıra bağala vədine içoğo xenen os'k'eq'at'un, tenesa biyalt'un. Q'urban eçala gala ı̌šalayinşaki Q'ončuğoynak'bok'ospsuni q'urban eçat'anal, ");
INSERT INTO udi_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","içoğoy kul-tura os'k'eq'at'un, tenesa biyalt'un. Mo Aaroneynak' q'a içuxun oşa eğala nəsileynak' həmişəluğ q'aydaq'an baki». ");
INSERT INTO udi_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Oşa Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Me gözəl adeğala şeyurxo ext'a: qobaç̌ şek'el c'urut' mirra, şot'ay qǐt'ay hama şaat' adeğala darçin, hat'eq'ədərəl adeğala gěš, ");
INSERT INTO udi_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","sa qobaç̌ şek'elal k'assia uk'ala adeğala darçin saal sa hin zeytuni c'əyin. Şek'el isə ı̌vel gala bakala çəkinə görəq'an hesabbaki. ");
INSERT INTO udi_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mot'oğoxun bacarağlu ust'an lə̌ə̌mst'eynak' bakala ı̌vel c'əyinq'an həzirbi; me adeğala c'əyin, lə̌ə̌mst'eynak' bakala ǐvel c'əyin bakale. ");
INSERT INTO udi_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","T'e c'əyinə ı̌vel çadıra, irəziluği sanduğa, ");
INSERT INTO udi_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ist'ola saal şot'aynak' bakala q'av-q'acağxo, pisosa saal bütüm iz şeyurxo, buxur bok'ospseynak' q'urban eçala ganu, ");
INSERT INTO udi_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","bok'ospsuni q'urbaneynak' q'urban eçala ganu saal şot'ay bito ət't'əcxo, misnə ləənə q'a iz laxala ganu lə̌ə̌mda. ");
INSERT INTO udi_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Metər, me şeyurxo Buxačuğo həsrba ki, ən ǐvelq'an baki; şot'oğo laft'ala hər şeyal ǐvel bakale. ");
INSERT INTO udi_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aarona q'a iz ğarmoğoval lə̌ə̌mdi ǐvelba ki, Zaynak' běyinšluğq'at'unbi. ");
INSERT INTO udi_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","İsrailluğo metər upa: \"Me cürə həzirbaki c'əyin və̌ynak' həmişəluğ, nəsiləxun nəsilə c'ovak'sunen lə̌ə̌mst'eynak' bakala ı̌vel c'əyin bakale. ");
INSERT INTO udi_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Me c'əyinə běyinšxoxun q'erəz amdarxoy bədəne ma lə̌ə̌mdanan. Kot'oxun və̌ynak' həzirmabanan. Me c'əyin ǐvele, şot'o ǐvel hesabbanan. ");
INSERT INTO udi_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kot'ollarik' c'əyin içeynak' düzbi nəəl ki ke c'əyinəxun běyinšxoxun q'erəz amdarxo lə̌ə̌mdala amdari tur azuk'i aranexun bot'eğalane\"». ");
INSERT INTO udi_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Oşa Q'ončuğon Moiseya pine: «Me adeğala şeyurxo barabar ext'a: balzam, çəlin ǔmǔğoxun həzirbaki onik, xalvan ukala o saal təmiz ladan. ");
INSERT INTO udi_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Barta mot'oğoxun bacarağlu ust'an buxurq'an düzbi; me düzbaki adeğala buxur elaxbaki, təmiz saal ǐvelq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Şot'oxun samal ext'i xuribi Zu bakala gala, ı̌vel çadıra, irəziluği sanduği běš laxa. Mo və̌ynak' ən ǐvelq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Me cürə həzirbaki buxur və̌ynak' həzirmabanan, mo saycə Q'ončuğoynak'q'an baki, şot'o ǐvel hesabbanan. ");
INSERT INTO udi_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Me buxuraxun izi adbiq'seynak' həzirbala amdari tural azuk'i aranexun bot'anan». ");
INSERT INTO udi_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Běğa, İuday tayfinaxun Xure nəvə bakala Urin ğar Besalelaz c'ək'p'i. ");
INSERT INTO udi_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Şot'o Buxačuğoy Urufen, müdrikluğen, q'amişaksunen, haq'ılen saal hər sa cürə bacarağen buyezbi ki, ");
INSERT INTO udi_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","q'ızılen, gümüşen saal misen əşbsuna bacarbeq'an, ");
INSERT INTO udi_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","toyexlu ǰě k'as'p'i pul laxsuna, durut' kişpsuna, hər cürə bacarağa ak'est'eq'an. ");
INSERT INTO udi_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Hamal Dane tayfinaxun bakala Ahisamaxi ğar Oholiaba şot'aynak' köməyçiz təyinbe. Zu ust'oğoyal bütümt'u t'etər bacarağez tadi ki, Zu va əmirbi şeyurxo Bez pi k'inək' bes bakeq'at'un: ");
INSERT INTO udi_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ı̌vel çadıra, irəziluği sanduğa q'a iz loxol bakala bağışlayinşbsuni q'apağa, çadıri bütüm şeyurxo, ");
INSERT INTO udi_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ist'ola saal şot'ay q'av-q'acağa, təmiz q'ızılaxun bakala pisosa saal şot'ay bütüm lazım bakala şeyurxo, buxur bok'ospseynak' q'urban eçala ganu, ");
INSERT INTO udi_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","bok'ospsuni q'urbaneynak' bakala q'urban eçala ganu saal şot'ay bütüm şeyurxo, ləənə saal şot'ay laxala ganu. ");
INSERT INTO udi_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Běyinš Aaroneynak' q'a iz ğarmoğoynak' bakala běyinšluği ə̌leśi ǐvel paltarxoval, ");
INSERT INTO udi_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","lə̌ə̌mst'eynak' bakala c'əyinə q'a ı̌vel ganeynak' bakala adeğala buxural Zu va hetərez əmirbesa, hat'e cürəl düzbeq'at'un». ");
INSERT INTO udi_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Hun israilluğo metər upa: \"Bezi ı̌vel Şamat' ğimxo efanan. Şot'aynak' ki, mo Zaynak', hamal israilluğoynak' nəsiləxun nəsilə c'ovaksunen sa nišan bakale, və̌nal avabakalnan ki, və̌x ǐvelbala Q'ončux Zuzu. ");
INSERT INTO udi_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Metərluğen, ı̌vel Şamat' ğina efanan, şot'aynak' ki, şo və̌ynak' ǐvele. Şot'o ı̌vel nu hesabbalo biyalane. T'e ği əşp'alt'aynak' azuk'i arane ga butene. ");
INSERT INTO udi_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ǔq ği əşp'eq'at'un. Vǔğǔmci ği isə Q'ončuğon təyinbi k'inək', sal sa əş nu biq'ala, ǐvel bakala Şamat' ğiq'an baki. T'e ği əş biq'alo biyalane. ");
INSERT INTO udi_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","İsrailluğon me ğina nəsiləxun nəsilə c'ovakest'unen həmişəluğ sa irəziluğ k'inək' efalat'un. ");
INSERT INTO udi_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mo Bezi q'a israilluğoy arane laxeśi həmişəluğ sa nišane. Me nišanenal Q'ončuğoy göyə q'a oç̌ala ǔq ğiin boş yaratmişbsuna, vǔğǔmci ğine isə dincəyinşəksunane ak'est'a\"». ");
INSERT INTO udi_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Q'ončuğon Moiseyaxun Sinay buruğo exlətp'i çark'it'uxun oşa İz kiin śameśi p'ə̌ t'ə̌p'ə̌k' ǰěna Moiseyane tadi. ");
INSERT INTO udi_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Azuk'en isə Moiseyi buruğoxun nu śiysuna, c'əyibaksuna ak'at'an Aaroni hərrəminə gireśi şot'o pine: «Yaynak' buxačux düzba, barta beş loxol kalaluğq'anbi. Şot'aynak' ki, yax Misirəxun c'evk'i amdari - me Moiseyi bel k'ə əş eysuna teyan ava!» ");
INSERT INTO udi_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaronen şot'oğo coğabe tadi: «Efi çupuxxoy, ğarmoğoy, xuyərmoğoy ǔmǔxxoxun q'ızıli sırığanxo c'evk'i bezi t'ǒğǒl eçanan». ");
INSERT INTO udi_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Camaatenal içoğoy ǔmǒğo bakala q'ızıli sırığanxo c'evk'i Aaroni t'ǒğǒlt'un eçeri. ");
INSERT INTO udi_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaronen şot'oğoxun me q'ızılxo ext'i xebi q'əlibəne bapi, oşa isə t'api arak'i surate düzbi. Amdarxonal sun-suna \"ay israilluyox, mone və̌x Misiri oç̌alaxun c'evk'i buxačux!\" pit'un. ");
INSERT INTO udi_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaronen mot'o ak'i arak'i běš sa q'urban eçala ga düzbi bayanebi: «Əyc'ə Q'ončuğoy s'iyal sa axsibay bakale». ");
INSERT INTO udi_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Əyc'indəri azuk'en savaxt'an üşenen hayzeri bok'ospsuni q'a serluği q'urbanxone šampi. Şot'oğon arśi kəyi-ǔt'ǔnği, oşa isə əxlagsuzluğbsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","T'e vədə Q'ončuğon Moiseya pine: «Usum baka, buruğoxun śiki, şot'aynak' ki, vi Misirəxun c'evk'i azuk'en günax əşp'est'i Za t'ǒǒxebi. ");
INSERT INTO udi_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Zu şot'oğoynak' laxi yaq'axun he usumt'un c'eri? İçoğoynak' xebi q'ızılen arak' düzbi şot'o bult'un k'os'bsa, q'urban šampi next'un: \"Ay israilluyox, mone yax Misiri oç̌alaxun c'evk'i buxačux!\"» ");
INSERT INTO udi_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Q'ončuğon saal Moiseya pine: «Azaksa ki, me azuk' inadkər azuk'e. ");
INSERT INTO udi_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Həysə isə Za ma qoşba, Zu me azuk'i loxol əcuğləyinşəki şot'o əfçiboz. Vaxun isə kala sa millət əmələ eçoz». ");
INSERT INTO udi_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ama Moiseyen iz Buxačux Q'ončuğo xoyinšbi pine: «Ay Q'ončux, Vi əcuğo Vi azuk'i loxol ma śipa. Axıri Hunen şot'oğo Vi kala zoren q'a Vi zorba kiin Misirəxun c'evk'i. ");
INSERT INTO udi_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Het'aynak'q'at'un misirluğon \"şot'oğo pis niyəten, buruğo besp'i oç̌ali ç̌oyexun əfçibseynak'e memiin c'evk'i\" pi? Xoyinšezbsa, Vi əcuğa bask'est'a. Vi azuk'a gorox eki, şot'o ma əfçiba. ");
INSERT INTO udi_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Vi k'ul bakala Avrahama, İsaak'a saal İsraila Vi elmoğo elaspi tadi əyitə eyex bada: \"ef nəsilə göynul bakala muč'uliğoy hama geleboz, Zu əyit tadi bütüm me ölkinə ef nəsilə tadoz, şot'oğonal me ölkinə həmişəluğ miras haq'alt'un\"». ");
INSERT INTO udi_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Metərluğen, Q'ončux İz azuk'a əfçibsuni niyətəxun qoşebaki. ");
INSERT INTO udi_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moiseyal fırıpi iz kiyel p'ə̌ dənə İrəziluği ǰě buruğoxun śire. J̌ěyurxoy p'ə̌ tərəf - p'ə̌ ç̌oval śameśiney. ");
INSERT INTO udi_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Şot'oğo Buxačuğon İzi kiine düzbey, iz loxol bakala t'ap'eśi śamal Şot'ay śamey. ");
INSERT INTO udi_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Şorox śiğat'an Yeşuan azuk'i səs-küyə ibaki Moiseya pine: «Azuk' çurk'ala ganuxun davin səse eysa». ");
INSERT INTO udi_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moiseyen coğabe tadi: «Mo nə davina taşerit'oğoy, Nəəl davina taşest'it'oğoy səs tene. Zu mə̌ğě səsez ibaksa». ");
INSERT INTO udi_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Moisey hari azuk' çurk'ala gala ı̌šalayinşakat'an arak'a saal şot'ay hərrəmine bakala əçina anek'i. Şot'ay əcuğon biq'i ǰěyurxo buruğoy tume iz kiyexun boseri şot'oğo k'ot'or-k'ot'ore bi. ");
INSERT INTO udi_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Şot'in azuk'i düzbi arak'a ext'i xenebi. Şot'o toz bakamin č'ak'p'it'uxun oşa xene ç̌oyel śarpi t'e xena israilluğo ǔğěsedi. ");
INSERT INTO udi_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moiseyen Aarona pine: «Me azuk'en va k'ə be ki, şot'o metər kala günaxan badi?!» ");
INSERT INTO udi_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaronen coğabe tadi: «Bezi ağay əcuğon maq'an biq'i. Hunal me azuk'a çalenxsa, avanu ki, usumt'un yaq'nuxun c'eysa. ");
INSERT INTO udi_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Şot'oğon za pit'un: \"Yaynak' buxačux düzba ki, beş loxol kalaluğq'an bi. Şot'aynak' ki, yax Misiri oç̌alaxun c'evk'i amdari - me Moiseyi bel teyan ava k'ə əşə hare!\" ");
INSERT INTO udi_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Zu isə şot'oğo pizu: \"Şust'a q'ızıli şeymux bunesa, şot'oğo c'evk'eq'an\". Azuk'en iz q'ızıla zane tadi. Zuval şot'o aruğoz bosi, hametər me arak'e haq'eśi». ");
INSERT INTO udi_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moiseyen anek'i ki, azuk' içuxun c'erene. Aaronen azuk'a tərbsunen düşmənxone mǔqt'ey. ");
INSERT INTO udi_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moiseyen azuk' çurk'ala gane bağala ganuxun k'alepi: «Q'ončuğoy tərəf bakalorox bezi t'ǒğǒlq'an hari!» Levin tayfinaxun bakala bitoval şot'ay t'ǒğǒle gireśi. ");
INSERT INTO udi_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","T'e vədə Moiseyen şot'oğo pine: «Q'ončuğon, İsraili Buxačuğon metəre nex: \"Ef q'ılıncxo ext'anan! Azuk' çurk'ala gane sa belxun baśi t'e belxun c'ekinan! Barta ef boşt'an hərt'in iz viçey, dost'e, q'onşin loxol taśi şot'o besp'eq'an!\"». ");
INSERT INTO udi_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leviğonal Moiseyen əmirbi k'inək' bit'un. T'e ği xib hazar tana ı̌ša amdare k'as'eśi. ");
INSERT INTO udi_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moiseyen şot'oğo pine: «Ğe və̌n efi ğarmoğoy saal viçimoğoy p'iye toyen Q'ončuğo q'ulluğbseynak' c'ək'eśi xeyir-bərəkətnan haq'i». ");
INSERT INTO udi_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Əyc'indəri Moiseyen azuk'a pine: «Və̌n gele kala günaxnan əşp'est'i. Ama zu Q'ončuğoy t'ǒğǒl laśi xoyinšboz, bərkə Şot'in ef günaxxo bağışlayinşane». ");
INSERT INTO udi_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Şot'in qaybaki Q'ončuğo pine: «Düze, me azuk'en içeynak' q'ızılen buxačux düzbsunen kala günaxe əşp'est'i. ");
INSERT INTO udi_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ama xoyinšezbsa, şot'oğoy günaxxo bağışlayinşa. Tene, bezi s'iyal Vi girkəxun silba». ");
INSERT INTO udi_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Q'ončuğon isə Moiseya pine: «Şiin Bezi əleyinə taśi günax əşp'est'enesa, Zu şot'ay s'iya Bezi girkəxun silboz. ");
INSERT INTO udi_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","İsə taki, azuk'a Bezi pi gala taşa. Bez angelen və̌x taşale. İz vaxt' eğat'an isə şot'oğo içoğoy günaxxo görə caza tadoz». ");
INSERT INTO udi_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Q'ončuğonal Aaroni arak' düzbsuna saal içoğoy bi me əşurxo görə israilluğo caza tadeney. ");
INSERT INTO udi_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Q'ončuğon Moiseya pine: «Misirəxun vi c'evk'i azuk'al ext'i memiin c'eki. Zu Avrahama, İsaak'a saal İak'ova elas tadi \"şot'o vi nəsilə tadoz\" pi oç̌ala takinan. ");
INSERT INTO udi_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Bez yaq'abi angelen vi běš taśi kənanluğo, emorluğo, xet'luğo, p'erizluğo, xivluğo saal yevusluğo t'et'iin şəp'eğale. ");
INSERT INTO udi_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","T'e muč'anaq' saal uč' barala oç̌ala takinan. Ama Zu və̌xun tez tağal, tene yaq'a və̌x ef inadkərluğa görə əfçiboz!» ");
INSERT INTO udi_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Azuk'en me cürə əyitmoğo ibaki yase efi, şot'oğon içoğoy bəzəyxoval c'evt'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Axıri Q'ončuğon Moiseya peney: «İsrailluğo metər upa: \"Və̌n inadkər azuk'nan, Zu və̌xun samalcəl tağayiz, və̌x əfçiboz. İsə ef bəzəyxo c'evk'anan, Zuval běğoz, běyn və̌x k'əz bsa\"». ");
INSERT INTO udi_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Hametər, Xorev buruğoy tume israilluğon içoğoy bəzəyxo c'evk'i eneyal şot'oğo tet'un lavk'i. ");
INSERT INTO udi_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moiseyen həmişə sa çadır ext'i şot'o azuk' çurk'ala ganuxun t'ǒǒx - ə̌xil lanexoy. Şot'o Q'ončuğoxun exlətpseynak' bakala çadır s'ine tadey. Q'ončuğoxun maslaatbsun çureğalt'inal amdarxoy çurk'ala ganuxun c'eri me çadırane taysay. ");
INSERT INTO udi_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moisey Q'ončuğoxun exlətpseynak' bakala çadıra tağat'an bütüm azuk' içoğoy çadıri bağala gane běš turel çurpi Moisey t'e çadıra bağamin iz bač'anexun běneğsay. ");
INSERT INTO udi_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moisey Q'ončuğoxun exlətpseynak' bakala çadıri boş bakala vədine asoyi sütün śiri çadıri bağala gala çureney, Q'ončuğonal Moiseyaxun exlətebsay. ");
INSERT INTO udi_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Azuk'en Q'ončuğoxun exlətpseynak' bakala çadıra bağala gala asoyi sütünə ak'at'an, bitot'in içoğoy çadıra bağala gala çurpi bule k'os'bsay. ");
INSERT INTO udi_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Q'ončuğon Moiseyaxun ç̌obaç̌o, sa amdaren iz ı̌ša dost'axun exlətp'ala k'inək'e exlətpsay. Oşa Moisey azuk' çurk'ala galane qaybaksay. Şot'ay cəyil köməyçi Nune ğar Yeşua isə çadıraxun tene c'eysay. ");
INSERT INTO udi_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moiseyen Q'ončuğo pine: «Hun za \"me azuk'a c'evk'a\" penuy, ama zaxun sagala şu yaq'abalnusa ten avabakest'ey. Hun penuy ki, za şaat'en çalxsa, zu Vi piyes şaat'ez ak'esa. ");
INSERT INTO udi_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Əgər zu, həgigiyal, Vi piyes şaat'ez ak'esasa, xoyinšezbsa, Vi fikirə za avabakest'a ki, zuval Va çalxaz, Vi piyes me şaat'luğa həmişə q'azayinşes bakaz. Ama me camaatiyal Vi azuk' baksuna eyexun ma c'evk'a». ");
INSERT INTO udi_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Q'ončuğon isə Moiseya coğabe tadi: «Zu vaxun bakoz. Hunal Zaxun irəətluğ bə̌ğə̌balnu». ");
INSERT INTO udi_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","T'e vədə Moiseyen Q'ončuğo pine: «Əgər yaxun Hun nu tağayin, yax memiin ma c'evk'a. ");
INSERT INTO udi_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Bezi saal me azuk'i Vi piyes şaat'luğ q'azayinşbsuna hetər avabakalyan? Vi yaxun taysunenen yax t'iyə̌mi azuk'xoxun üst'ün laxsuna ak'est'on». ");
INSERT INTO udi_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Q'ončuğon Moiseya coğabe tadi: «Hun Zaxun çureśi me şeya booz. Şot'aynak' ki, hun Bezi ük'el basenksa, vaal şaat'ez çalxsa». ");
INSERT INTO udi_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","T'e vədə Moiseyen xaişebi: «Vi kalaluğa za ak'est'a». ");
INSERT INTO udi_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Q'ončuğon pine: «Zu bütüm Bezi xeyirxaxluğa va ak'est'oz, Q'ončux s'iyal va bayanboz. Şuu çurezsasa şot'oz şaat'luğ ak'est'a, şuu çurezsasa şot'oz gorox eysa. ");
INSERT INTO udi_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ama Bezi ç̌oya hun ak'es batenkon, şot'aynak' ki, Za ak'ala amdar dirist' tene mandon». ");
INSERT INTO udi_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Oşa Q'ončuğon pine: «Mone, Bezi t'ǒğǒl gane bu, hamemiya, me q'ayani loxol çurpa. ");
INSERT INTO udi_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Zu va Bez kalaluğa ak'est'at'an va me q'ayani q'ate sa t'ǒǒx efoz, Zu c'ovakaminal va Bezi kiin but'k'oz. ");
INSERT INTO udi_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Zu c'ovakit'uxun oşa isə Bez kula ext'oz. Hun Za bač'anexun ak'alnu, ama Bezi ç̌oya ten ak'al». ");
INSERT INTO udi_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Q'ončuğon Moiseya pine: «Süft'in ǰěyurxo oşq'ar p'ə̌ dənə t'ə̌p'ə̌k' ǰě kişp'a; hun xoxp'i süft'in t'ə̌p'ə̌k' ǰěne loxol śameśi əyitmoğo təzə ǰěne loxol śamk'oz. ");
INSERT INTO udi_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Savaxt'an həzir baka. Sinay buruğo laśi buruğoy bel Bezi běš çurpa. ");
INSERT INTO udi_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Şuk'k'al vaxun maq'an laśi, buruğo sal sa amdar maq'an ak'eśi. Buruğoy tume lap eğel-keçi nəəl beliyal ma otarişanan». ");
INSERT INTO udi_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moiseyen Q'ončuğon içu bürmişi k'inək' süft'int'oğo oşq'ar p'ə̌ dənə t'ə̌p'ə̌k' ǰěne kişp'i. Savaxt'an üşenen hayzeri isə, şot'oğo ext'i Sinay buruğone laśi. ");
INSERT INTO udi_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Q'ončuxal asoyi boş śiri Moiseyi t'ǒğǒl çurepi. Oşa İz s'iya bayanbsun ");
INSERT INTO udi_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Moiseyi běšt'an c'ovaki pine: «Q'ončux, Q'ončux, Zu ük' bok'osp'ala, şaat'luğ ak'est'ala Buxačuxzu. Zu səbürlu, İçust'a çuresun gele bakala saal Bez əyitə ğaç̌ Buxačuxzu. ");
INSERT INTO udi_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Zu hazarxon nəsilə Bezi nu badalbakala çuresunaz ak'est'a, yaq'nuxun c'eysuna, k'anunsuzluğa saal günaxa bağışlayinşezbsa. Ama taxsır bakalt'u cazasuz tez bare: bavoğoy cazina xibimci-bip'imci nəsiləl śirik' nəvə-nəticoğoz tast'a». ");
INSERT INTO udi_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moisey hat'et'iya oq'a past'eśi Q'ončuğo bul k'os'bi ");
INSERT INTO udi_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","pine: «Ay Q'ončux, əgər Vi piyes şaat'luğ bə̌ğə̌bezusa, xoyinšezbsa, Hun, Q'ončux, yaxun taki. Yan inadkər sa azuk' baalkayan, beşi yaq'nuxun c'eysuna saal günaxxo bağışlayinşa, yax Vi azuk' k'inək' q'abulba». ");
INSERT INTO udi_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Q'ončuğon Moiseya pine: «Mone, Zu və̌xun irəziluğez ğaç̌esa. Bütüm azuk'i piin běš t'etər möcüzoox ak'est'oz ki, dünyəne sal sa gala, sal sa milləti boş metəro tene bake. Ef hərrəminə bakala bütüm azuk'xonal ak'alt'un ki, Zu, Q'ončuğon vaynak' bala əşurxo kalane. ");
INSERT INTO udi_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Zu ğe və̌x tadala əmirxo əməlbanan. Zuval ef běšt'an emorluğo, kənanluğo, xet'luğo, p'erizluğo, xivluğo saal yevusluğo şəp'eğoz. ");
INSERT INTO udi_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Və̌x ef tağala oç̌ala yəşəyinşala amdarxoxun irəziluğ ğaç̌esunaxun efanan, tenesa mo və̌ynak' sa tələ bakale. ");
INSERT INTO udi_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Şot'oğoy q'urban eçala ganxo śarpanan, içoğoy ı̌vel ǰěne sütünxo xoxp'anan, çuux-buxačux Aşera efala sütünxo bot'anan. ");
INSERT INTO udi_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Q'erəz sal sa buxačuxxo bul ma k'os'banan, şot'aynak' ki, Q'ončuğoy s'i Nu Portbale, Şo q'erəz buxačuxxo nu portbala Buxačuxe. ");
INSERT INTO udi_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Běğanan, t'e oç̌ala yəşəyinşalt'oğoxun irəziluğ ma ğaç̌ekinan. Tene, şot'oğon içoğoy buxačuxxoynak' q'urban eçeri Za xəyanətbat'an və̌xal içoğoy t'ǒğǒl k'alk'alt'un, və̌nal şot'oğoy q'urbani yeq'axun ukalnan. ");
INSERT INTO udi_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Şot'aynak' ki, və̌n şot'oğoy xuyərmoğo ef ğarmoğoynak' haq'alnan şot'oğonal içoğoy buxačuxxoynak' q'urban eçat'an ef ğarmoğoval Za xəyanətbest'alt'un. ");
INSERT INTO udi_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Və̌ynak' q'əliben buxačuxxo ma düzbanan. ");
INSERT INTO udi_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ə̌yinsuz Šume axsibay c'ovakest'anan: vǔğ ği Zu və̌x əmirbi k'inək' ə̌yinsuz šum ukanan. Mot'o aviv xaşest'a banan, şot'aynak' ki, hat'e xaşest'anan Misirəxun c'ere. ");
INSERT INTO udi_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Bütüm nanaxun süft'in baki ğarmux saal bütüm ef heyvanxoy - belin, eğeli, keçinal süft'in baki ərkəy baloox Bezine. ");
INSERT INTO udi_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Süft'in baki elemi balin galal sa eğeli nəəl keçin bala tadanan. Əgər tades nu bakaynan, t'e elemi balin ozana xoxp'anan. Ef süft'in ğare galal sa eğeli nəəl keçin bala tadanan. Şuk'k'al Bezi běš ams'i kiin maq'an hari. ");
INSERT INTO udi_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ǔq ği ef əşurxo banan, vǔğǔmci ğine isə ma əşp'anan. Eze q'a exe vədineyal mot'o əməlbanan. ");
INSERT INTO udi_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Çöle bakala əkini süft'in exaxun Exe axsibay c'ovakest'anan. Payizin axırast'a isə Bare axsibaya c'ovakest'anan. ");
INSERT INTO udi_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Usena xib kərəm ef bütüm işq'arxo Q'ončuğoy, israilluğoy Buxačuğoy běšq'at'un hari. ");
INSERT INTO udi_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Və̌n ef Buxačux bakala Q'ončuğoy běš c'eğat'an şuk'k'alen ef oç̌alxo tene ext'al, şot'aynak' ki, Zu ef oç̌alaxun q'erəz millətxo şəp'eğoz. Ef oç̌alxoval gele bakale. ");
INSERT INTO udi_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Běğanan ki, ə̌yinen həzirbaki hik'k'al Zaynak' eçala q'urbani p'iya maq'an laft'i. C'ovaksuni axsibayi q'urbani yeq' savaxal śirik' maq'an mandi. ");
INSERT INTO udi_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ef oç̌alaxun gireśi ən şaat' nübərə ef Buxačux Q'ončuğoy k'oya eçanan. Q'uzina iz nanay muč'anaq'i boş ma ap'esp'anan». ");
INSERT INTO udi_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Oşa Q'ončuğon Moiseya pine: «Me əyitmoğo śampa, şot'aynak' ki, me şərturxonez Zu vaxun saal bütüm israilluğoxun ǐvel irəziluğ ğaç̌esa». ");
INSERT INTO udi_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moiseyal Q'ončuğoxun sagala q'ırx ği-q'ırx şü manedi, hik'k'al tene kəyi, hik'k'al tene ǔği. Şot'in ǰěne loxol irəziluği əyitmoğo - Vis' əmirəne śampi. ");
INSERT INTO udi_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moiseyen p'ə̌ dənə irəziluği ǰěna iz kiyel biq'i Sinay buruğoxun śiğat'an tene avay ki, Q'ončuğoxun əyitp'it'uxun oşa iz ç̌oyen s'alest'a. ");
INSERT INTO udi_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaronen q'a israilluğon Moiseyi ç̌oyen s'alst'una ak'at'an, şot'o ı̌šalayinşaksuna qǐt'unbi. ");
INSERT INTO udi_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ama Moiseyen şot'oğo k'alepi. Aaron q'a q'urumi kaloroxal ı̌šalayinşaki Moiseyaxun exlətt'unbi. ");
INSERT INTO udi_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Oşa camaatal bito şot'o ı̌šalayinşebaki. Moiseyen Q'ončuğon Sinay buruğo içu pi əmirxo bitova şot'oğo p'ap'esebi. ");
INSERT INTO udi_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moiseyen exlətə çark'i iz ç̌oya çalminen but'ek'i. ");
INSERT INTO udi_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Şot'in iz ç̌oya saycə Q'ončuğoxun exlətpseynak' Şot'ay běš tağat'ane qayey. C'erit'uxun oşa Moiseyen Buxačuğoy əyitmoğo israilluğone p'ap'espsay, ");
INSERT INTO udi_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","şot'oğonal izi ç̌oyen s'alst'una at'unksay. Moiseyen isə eğala dönüş Q'ončuğoxun exlətpseynak' bona bağamin p'urum iz ç̌oya çalminen but'eksay. ");
INSERT INTO udi_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moiseyen israilluğoy bütüm q'uruma girbi şot'oğo pine: «Q'ončuğon və̌x me şeyurxo əməlbsunane əmirbe: ");
INSERT INTO udi_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ǔq ği əşp'anan, vǔğǔmci ği isə Q'ončuğohəsrbaki ǐvel Şamat' ğine, sal sa əş nu biq'ala ğine. T'e ği əş biq'alt'u besp'anan. ");
INSERT INTO udi_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Şamat' ğine ef yəşəyinşala gala sal aruxalmabanan». ");
INSERT INTO udi_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moiseyen bütüm israilluğoy q'uruma pine: «Q'ončuğon metəre əmirbi: ");
INSERT INTO udi_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","və̌st'a bakala şeyurxoxun Q'ončuğoynak' sa pay eçanan. Barta iz ük'en çureğalt'in Q'ončuğoynak' me şeyurxoq'an eçeri: q'ızıl, gümüş nəəl mis, ");
INSERT INTO udi_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","göyin, mumušak'i nəəl tünd č'oč'a irəngen t'uriyox, nəzik' kətani parça q'a keçin xa, ");
INSERT INTO udi_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","č'oč'a irəng duğeśi eğeli t'ol q'a q'erəzəl nəzik' t'olurxo, yasəməni durut', ");
INSERT INTO udi_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","çirağa bapseynak' zeytuni c'əyin, lə̌ə̌mst'eynak' bakala c'əyineynak' q'a bok'ospseynak' şaat' adeğala oyurxo, ");
INSERT INTO udi_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","samci běyinši döşlin saal suruk' cuye loxol laxseynak' oniks saal q'erəz toyexlu ǰěyurxo. ");
INSERT INTO udi_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Barta Q'ončuğon bacarağ tadi ust'oğon hari Şot'ay əmirbi bütüm me şeyurxo düzbeq'at'un: ");
INSERT INTO udi_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ı̌vel çadıra q'a iz loxolxun but'kseynak' bakala q'aturxo, iz q'armağxo, çərçüvoğo, peşt'uvanxo, sütünxo saal iz turmoğo, ");
INSERT INTO udi_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sanduğa saal şot'o taşt'eynak' bakala durut'xo, bağışlayinşbsuni q'apağa, ı̌vel ganu ən ı̌vel ganuxun cöybala pərdinə; ");
INSERT INTO udi_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ist'ola saal şot'o taşt'eynak' bakala durut'xo, iz bütüm q'av-q'acağxo, Q'ončuğo həsrbakala šumurxo; ");
INSERT INTO udi_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","pisosa q'a şot'o lazım bakala şeyurxo, çirağxo saal şot'o bapseynak' bakala c'əyinə; ");
INSERT INTO udi_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","buxur q'urban eçala ganu saal şot'o taşt'eynak' lazım bakala durut'xo; lə̌ə̌mst'eynak' bakala c'əyinə; bok'ospseynak' bakala şaat' adeğala oyurxo; çadıra bağala ganeynak' bakala pərdinə; ");
INSERT INTO udi_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","bok'ospsuni q'urban eşt'eynak' q'urban eçala ganu, şot'ay misnə reşot'k'ina, durut'xo saal bütüm lazım bakalt'oğo; ləənə saal şot'o laxala ganu; ");
INSERT INTO udi_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","məəlin pərdoğo, sütünxo saal şot'ay turmoğo, məəlin bağala ganeynak' bakala pərdinə, ");
INSERT INTO udi_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","çadıri mixçoğo, məəlneynak' bakala mixçoğo, şot'oğoynak' bakala kəndürxo; ");
INSERT INTO udi_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ǐvel gala q'ulluğbseynak' bakala ə̌leśi paltarxo: běyinš Aaroneynak' ǐvel paltarxo saal iz ğarmoğoynak' běyinšluği paltarxo». ");
INSERT INTO udi_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hametər, israilluyox Moiseyi t'ǒğǒlxun śart'unśi. ");
INSERT INTO udi_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Oşa taśi iz ük'en çureğalt'in ı̌vel çadıra biq'seynak', şot'ay boş bakala q'ulluğeynak' saal ǐvel paltarxo düzbseynak' Q'ončuğoynak' mǔq-mǔq pay eşt'at'un burqi. ");
INSERT INTO udi_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Çureğalorox bito et'unsay - işq'arxoval, çupuxxoval. Şot'oğon içoğoy q'ızıli broşk'oğo, sırığanxo, boğoç̌alxo saal śepurxot'un eşt'ay. Şot'oğon me q'ızıli şeymoğo alabi mot'oğoy Q'ončuğoynak' sa pay baksunat'un ak'est'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Şust'a göyün, mumušak'i saal tünd č'oč'a irəngen t'uri, nəzik' kətan, keçin xa, č'oč'a irəng duğeśi eğeli t'ol saal q'erəz nəzik' t'ol buneysa, mot'oğone eşt'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bakalt'in Q'ončuğoynak' gümüş nəəl mise eşt'ay. Şust'a yasəməni durut' buneysa, şot'one çadıreynak' lazım bakala şeyurxo düzbseynak' pay tast'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Buxačuğon bacarağ tadi çupuxxon içoğoy kiin urtt'i göyün, mumušak'i, tünd č'oč'a irəngen t'uri q'a nəzik' kətani parçat'un eşt'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","İçoğoy kiyexun ayeğala saal me əş içoğoy ük'exun c'ovakala çupuxxon isə keçin xayaxunt'un t'uri urtt'i eşt'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Azuk'i kalat'oğonal samci běyinši döşlin q'a suruk' cuye loxol laxseynak' oniks saal q'erəz toyexlu ǰěyurxo, ");
INSERT INTO udi_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","bok'ospseynak' bakala şaat' adeğala oyurxo, pisoseynak' q'a lə̌ə̌mst'eynak' bakala c'əyineynak' şaat' adeğala oyurxo saal zeytuni c'əyint'un eşt'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Hametər, israillu bakala işq'arxon q'a çupuxxon Q'ončuğon Moiseyaxun içoğo p'ap'esp'it'oğo əməlt'unbi. Şot'oğon k'ə et'unşt'aysa ük'int'un eşt'ay. ");
INSERT INTO udi_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moiseyen israilluğo pine: «Běğanan, Q'ončuğonİuday tayfinaxun Xure nəvə bakala Urin ğar Besalela c'ək'p'i ");
INSERT INTO udi_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","şot'o Buxačuğoy Urufen, müdrikluğen, q'amişaksunen, haq'ılen saal hər sa cürə bacarağen buybene ki, ");
INSERT INTO udi_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","q'ızılen, gümüşen saal misen əşbsuna, ");
INSERT INTO udi_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","toyexlu ǰě kişp'i pul laxsuna, durut'en əşbsuna bacarbeq'an, iz kiyexun hər cürə əş ayeśeq'an. ");
INSERT INTO udi_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Q'ončuğon şot'o saal Dane tayfinaxun bakala Ahisamaxi ğar Oholiabina q'erəzt'oğo zombsuni bacarağal tadene. ");
INSERT INTO udi_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Şot'oğo durut' kişbsuni, naxış c'evksuni, göyin, mumušak'i saal tünd č'oč'a irəngen t'urinen naxış laxsuni, nəzik' kətani parçina ə̌lst'uni bacarağe tade ki, içoğoy kiyexun hər şey ayeśeq'an. ");
INSERT INTO udi_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Metərluğen, barta Besalelen, Oholiaben saal bacarağlu ust'oğon - Q'ončuğon me əşleynak' bacarağ saal müdrikluğ tadi me amdarxon - Q'ončuğon əmirbi k'inək' ı̌vel ganu biq'sa burqeq'at'un». ");
INSERT INTO udi_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moiseyen Besalela, Oholiaba saal Q'ončuğon içoğo müdrikluğ tadi, me əşlə ük'in bsun çureğala bütüm bacarağlu amdarxo iz t'ǒğǒle k'alpi. ");
INSERT INTO udi_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Şot'oğon ı̌vel ganu biq'seynak' israilluğon eçeri bütüm payurxo Moiseyaxun ext'undi. Ama israilluğon hələl hər savaxt'an mǔq-mǔq payurxot'un eşt'ay. ");
INSERT INTO udi_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","T'e vədə ı̌vel ganu biq'ala bacarağlu ust'oğon içoğoy əşlə efi ");
INSERT INTO udi_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Moiseyi t'ǒǒx hari pit'un: «Azuk'en Q'ončuğon əmirbi əşurxoynak' lazım bakalt'uxun gele şeye eşt'a». ");
INSERT INTO udi_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moiseyenal əmirbi bayanbesedi ki, nə işq'arxon nəəl çupuxxon ı̌vel ganeynak' ene sal sa pay maq'at'un eçeri. Azuk'enal ene hik'k'al tene eçeri, ");
INSERT INTO udi_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","şot'aynak' ki, me əşleynak' gireśi şeyurxo lazım bakalt'uxun avuzey. ");
INSERT INTO udi_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Metərluğen, bütüm bacarağlu ust'oğon gireśi göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon vis' dənə nəzik' kətani pərdət'un ə̌ldi. İz loxol isə angeli şikilen naxışxot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Bütüm pərdoox sa boydaney: boxoyluğ saq'o muğ ə̌m, gengluğ isə bip' ə̌m. ");
INSERT INTO udi_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pərdoğoy qoara sunaxun, t'e soğo qoaral sunaxun ět'unbi. ");
INSERT INTO udi_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Samci qo ěbeśi pərdin börine bakala pərdin t'ǒǒx göyin irəngen t'urinen halq'ooxt'un düzbi. Hat'etərəl t'e soğo pərdin t'ǒǒxt'un halq'oox düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Samci ěbeśi qo pərdin börine əlli dənə t'urin halq'a, t'e soğo ěbeśi qo pərdin börineyal şot'oğoxun düz eğala əlli dənə t'urin halq'at'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Oşa q'ızılaxun əlli dənə q'armağt'un düzbi. T'e q'armağxon ěbeśi pərdoğo sunaxun calağt'unbi ki, ı̌vel çadır saq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ǐvel çadıri looxun but'kseynak' keçin xayaxun bakala t'urinen sas's'e dənə pərdət'un ə̌ldi. ");
INSERT INTO udi_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Sas's'e pərdəl sa boydaney: boxoyluğ otuz ə̌m, gengluğ isə bip' ə̌m. ");
INSERT INTO udi_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Qo pərdinə cöy, ǔq pərdinəl cöyt'un ěbi. ");
INSERT INTO udi_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Oşa samci ěbeśi pərdin dönbineyal, t'e soğo ěbeśi pərdin dönbineyal əlli dənə t'urin halq'at'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Çadır saq'an baki pi, misəxun əlli dənə q'armağ düzbi t'e pərdoğo sunaxun calağt'unbi. ");
INSERT INTO udi_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Çadıri looxun but'kseynak' č'oč'a irəng duğeśi eğeli t'olaxun saal q'erəz nəzik' t'olaxun pərdooxt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ǐvel çadıreynak' yasəməni durut'axun tik çurk'ala çərçüvoxt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Hər çərçüvin boxoyluğ vis' ə̌m, gengluğ isə sə̌nqı̌ ə̌mey. ");
INSERT INTO udi_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Şot'oğoy hər soğo sunaxun ğaç̌ p'ə̌ dənə durut'axuney. Ǐvel çadıri bütüm çərçüvoğo metərt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ǐvel çadıri güney tərəfeynak' q'a çərçüvə ");
INSERT INTO udi_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","saal şot'oğoy oq'a laxseynak' gümüşəxun q'ırx dənə laxala gat'un düzbi. Hər çərçüvin oq'a p'ə̌ dənə laxala ga, içoğoy durut'in saya görə. ");
INSERT INTO udi_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ǐvel çadıri q'uzey tərəfeynak'al q'a çərçüvə ");
INSERT INTO udi_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","saal şot'oğo ost'aarbseynak' gümüşəxun q'ırx dənə laxala gat'un düzbi. Hər çərçüvin oq'a p'ə̌ dənə laxala ga, içoğoy durut'in saya görə. ");
INSERT INTO udi_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ǐvel çadıri bač'aneynak', běğ batk'alaç tərəfeynak' ǔq, ");
INSERT INTO udi_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ı̌vel çadıri bač'ani dönboğoynak' isə p'ə̌ çərçüvət'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Morox oq'axun çüt hari ala sa halq'inene ost'aarbaksay. Hər p'ə̌ dönbineynak'al hametər çərçüvooxt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Metər, me muğ çərçüvin oq'a laxseynak' ǔqěs's'e dənə gümüşi laxala gat'un düzbi - hər çərçüvin oq'a p'ə̌ dənə laxala ga. ");
INSERT INTO udi_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Yasəməni durut'axun peşt'uvanxot'un düzbi: ı̌vel çadıri hər t'ǒğeynak' qo peşt'uvan, ");
INSERT INTO udi_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","běğ batk'alaç bakala bač'ani tərəfeynak'al qo peşt'uvan. ");
INSERT INTO udi_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Bı̌ğin peşt'uvana çadıri sa belxun t'iyə̌mi bel t'etərt'un laxi ki, çərçüvoğo sunaxun ğaç̌k'ane. ");
INSERT INTO udi_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Çərçüvoğo q'ızılen but't'unk'i, q'ızılaxun peşt'uvanxo efala halq'ooxal düzt'unbi. Oşa peşt'uvanxo içoğoval q'ızılen but't'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ǐvel ganu ən ı̌vel ganuxun cöybseynak' bakala pərdinə göyün, mumušak'i, tünd č'oč'a irəngen t'uriğon q'a nəzik' kətani t'uriğont'un ə̌ldi, iz loxol isə bacarağlu ust'an angeli şikilxon naxışxone düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Şot'aynak' yasəməni durut'axun bip' dənə sütün düzbi şot'oğo q'ızılen but't'unk'i. Oşa şot'oğoynak' q'ızıli q'armağxo saal şot'oğoy oq'a laxseynak' q'əliben bip' dənə gümüşi laxala gat'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Çadıri bağala ganeynak' nəzik' kətani t'uriğon pərdət'un ə̌ldi, iz loxol isə göyin, mumušak'i, tünd č'oč'a irəngen bakala t'uriğon ěbunen naxışxot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Oşa me pərdineynak' iz loxol q'armağxo bakala qo dənə sütün düzbi şot'oğoy bulurxo q'ızılen but't'unk'i. Sütünxoy oq'a laxseynak' isə misəxun bakala qo dənə laxala gat'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalelen yasəməni daxt'ak'axun sanduğe düzbi. Sanduği boxoyluğ p'ə̌nqı̌ ə̌m, iz gengluğ q'a alloyluğ isə sə̌nqı̌ ə̌mey. ");
INSERT INTO udi_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Şot'o bonaxun saal ç̌oyexun təmiz q'ızılen but'ek'i, iz hərrəmine isə q'ızıli zolağe laxi. ");
INSERT INTO udi_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Oşa q'əliben bip' q'ızıli halq'a düzbi şot'oğo sanduği bip' dönbine, p'ə̌ halq'ina sa tərəf, p'ə̌ halq'ina isə t'e soğo tərəf ost'aarebi. ");
INSERT INTO udi_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Yasəməni xodaxun durut'xo düzbi iz looxun q'ızılen but'ek'i, ");
INSERT INTO udi_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","oşa şot'oğo sanduği dönboğo bakala halq'oğo lavek'i ki, sanduğa taşes bakat'un. ");
INSERT INTO udi_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Təmiz q'ızılen bağışlayinşbsuni q'apağane düzbi. Şot'ay boxoyluğ p'ə̌nqı̌ ə̌m, gengluğ isə sə̌nqı̌ ə̌mey. ");
INSERT INTO udi_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Bağışlayinşbsuni q'apaği p'ə̌ buleynak' q'ızılaxun çəküçen əşeśi p'ə̌ angele düzbi. ");
INSERT INTO udi_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Sa angela q'apaği sa bel, t'e sunt'u isə t'e soğo bel t'etəre düzbi ki, q'apağaxun sat'un baki. ");
INSERT INTO udi_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Angelxoy ala qayeğala q'ənədxon bağışlayinşala q'apağa but't'unksay. Şot'oğon ç̌obaç̌o çurpi q'apağaçt'un běğsay. ");
INSERT INTO udi_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Besalelen yasəməni daxt'ak'en ist'ole düzbi; şot'ay boxoyluğ p'ə̌ ə̌m, gengluğ sa ə̌m, alloyluğ isə sə̌nqı̌ ə̌mey. ");
INSERT INTO udi_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Şot'o təmiz q'ızılen but'ek'i. İz hərrəmine q'ızıli zolağe laxi. ");
INSERT INTO udi_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Şot'ay hərrəmine alloyluğ bip' k'əşə bakala t'ǒğǔrxone düzbi. T'ǒğǔrxoy hərrəmine isə q'ızıli zolağe laxi. ");
INSERT INTO udi_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","İst'oleynak' q'əliben bip' dənə q'ızıli halq'a düzbi şot'oğo ist'olin bip' turaxun ost'aarebi. ");
INSERT INTO udi_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","İst'oli ganu badalbat'an durut'xoxun biq'i taşes bakeq'at'un pi, halq'oox ist'oli t'ǒğǔrxoxuney ləçəq'. ");
INSERT INTO udi_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","İst'ola taşt'eynak' bakala durut'xo yasəməni xodaxun düzbi şot'oğo q'ızılen but'ek'i. ");
INSERT INTO udi_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","İst'olin loxol laxseynak' təmiz q'ızılaxun t'alik'xo, q'avurxo, śipseynak' bakala payurxoynak' cürdək'xo saal camurxone düzbi. ");
INSERT INTO udi_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Besalelen təmiz q'ızılaxun sa pisose düzbi. Me pisos çəküçen əşeśi təmiz q'ızılaxuney. Şot'ay oq'in hissə, tur saal ture loxol bakala varde t'up'ulxo q'a xazalxo şot'oxun saney. ");
INSERT INTO udi_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Pisosaxun ǔq taye c'eysay - xibo sa t'ǒǒxun, xiboval t'e soğo t'ǒǒxun. ");
INSERT INTO udi_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ǔq taye hər sunt'ay loxol xib dənə badami s'is'ik'xo oşq'ardala t'up'ulxo saal vardurxone buy. ");
INSERT INTO udi_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Pisosi ture loxol vardla saal t'up'ulla badami s'is'ik'ə oşq'ardala bip' kasane buy. ");
INSERT INTO udi_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Me t'up'ulxoy soğo pisosi turexun c'eğala süft'in p'ə̌ taye oq'a, t'e soğo p'ə̌mci c'eğala p'ə̌ taye oq'a, xibimciyo isə xibimci c'eğala p'ə̌ taye oq'aney. Metər, şorox pisosi turexun c'eğala ǔq taye oq'al but'uniy. ");
INSERT INTO udi_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","T'up'ulxo q'a tayurxo pisosaxun sat'uniy; çəküçen əşeśi təmiz q'ızılaxunt'uniy. ");
INSERT INTO udi_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Pisoseynak' təmiz q'ızılaxun vǔğ dənə zeytuni c'əyinen bok'ala çirağ, maşoox q'a xətəngəzxot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Pisosa saal şot'o lazım bakala bütüm şeyurxo düzbseynak' sa t'alant' təmiz q'ızıle əşeśi. ");
INSERT INTO udi_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Yasəməni daxt'ak'axun buxur bok'ospseynak' q'urban eçala gat'un düzbi. İz boxoyluğ q'a gengluğ sa ə̌m, alloyluğ isə p'ə̌ ə̌mey. İz dönboğo bakala mǔq'ǒǒx isə içuxun saney. ");
INSERT INTO udi_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Şot'ay ç̌oya, böriğo saal mǔq'ǒğo təmiz q'ızılent'un but'k'i, iz hərrəmine isə q'ızıli zolağt'un laxi. ");
INSERT INTO udi_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Q'urban eçala ganu durut'xoxun biq'i taşt'eynak' iz p'ə̌ börine, zolaği oq'a p'ə̌ q'ızıli halq'at'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Durut'xo yasəməni xodaxun düzbi q'ızılen but't'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bacarağlu ust'oğon lə̌ə̌mst'eynak' bakala ı̌vel c'əyinə saal bok'ospseynak' bakala şaat' adeğala oyurxoval həzirt'unbi. ");
INSERT INTO udi_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Yasəməni daxt'ak'axun bok'ospsuni q'urbaneynak' q'urban eçala gat'un düzbi. Şo bip' dönbələney, iz boxoyluğ q'a gengluğ qo ə̌m, alloyluğ isə xib ə̌mey. ");
INSERT INTO udi_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Q'urban eçala gane bip' dönbineyal mǔq'ǒğo t'etərt'un düzbi ki, şorox q'urban eçala ganuxun sat'un baki. Oşa t'e ganu misen but't'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Şot'ay jeq'e q'avurxo, ist'amxo, ləənxo, çəngəlxo, xətəngəzxo - bütüm şeyurxo misent'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Şot'oğon q'urban eçala ganeynak' misəxun reşot'k'at'un düzbi. Şot'o q'urban eçala gane zolağaxun oq'a t'etərt'un laxi ki, reşot'k'inen şot'ay qı̌t'uxune duğsay. ");
INSERT INTO udi_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Me misnə reşot'kin bip' dönbine durut'xo c'ovakest'eynak' q'əliben düzbaki bip' dənə misnə halq'ane buy. ");
INSERT INTO udi_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Yasəməni xodaxun durut'xo düzbi iz looxun misen butt'unki. ");
INSERT INTO udi_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Durut'xo q'urban eçala gane p'ə̌ börine bakala halq'oğo lavt'unk'i ki, şot'o biq'i taşes bakan. Q'urban eçala ganu daxt'ak'axunt'un düzbey, şot'ay boşt'an ams'iney. ");
INSERT INTO udi_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Oşa pak bakseynak' sa misnə ləən q'a şot'o laxseynak' gat'un düzbi. Şot'o ı̌vel çadıri bağala gala q'ulluğbala çupuxxoy misnə güzgüğoxunt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Oşa ı̌vel çadıri məəlin güney tərəfeynak' boxoyluğ sabaç̌ ə̌m bakala nəzik' kətani t'urinen ə̌leśi pərdooxt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Şot'oğoynak' q'a dənə sütün saal şot'oğoy oq'a laxseynak' misəxun q'a dənə laxala gat'un düzbi. Q'armağxo q'a halq'oğo isə gümüşəxunt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Q'uzeyi tərəfeynak'al bakala pərdin boxoyluğ sabaç̌ ə̌mey; şot'oğoynak'al q'a dənə sütün saal misəxun q'a dənə laxala gat'un düzbi. Sütünxoy q'armağxo q'a halq'oox isə gümüşəxuney. ");
INSERT INTO udi_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Məəlin běğ batk'ala tərəfeynak' bakala pərdoğoy boxoyluğ isə əlli ə̌mey; şot'oğoynak' vis' dənə sütün saal vis' dənə laxala gat'un düzbi. Q'armağxo q'a halq'oğo isə gümüşəxunt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Məəlin běğ c'eğala tərəfiyal boxoyluğ əlli ə̌mey. ");
INSERT INTO udi_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Bağala gane sa tərəf, hərt'ay iz laxala ga bakala xib sütüni loxol, içoğoy boxoyluğ qos's'e ə̌m bakala pərdooxe buy. ");
INSERT INTO udi_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","T'e soğo tərəfəl hərt'ay iz laxala ga bakala xib sütüni loxol içoğoy boxoyluğ qos's'e ə̌m pərdooxe buy. ");
INSERT INTO udi_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Məəlin hərrəmine bakala bütüm pərdoox nəzik' kətani parçinaxuney. ");
INSERT INTO udi_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Məəlin sütünxoy laxala ganxo misəxun, ğaç̌esunxo q'a q'armağxo isə gümüşəxuney; sütünxoy bulurxo gümüşent'un but'k'ey. Məəlin bütüm sütünxoy ğaç̌esunxo gümüşəxuney. ");
INSERT INTO udi_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Məəlin bağala ganeynak' boxoyluğ q'a ə̌m, alloyluğ isə məəlin pərdoğoy alloyluğallarik' qo ə̌m bakala pərdət'un düzbi. Şo göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon saal nəzik' kətani t'uriğone ə̌leśey, iz loxol naxışxoval buney. ");
INSERT INTO udi_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Bağala gane bip' sütüne buy, hərt'ay oq'al izi misnə laxala gane buy; şot'oğoy ğaç̌esunxo q'a q'armağxo isə bütüm gümüşəxuney. Sütünxoy bulurxoval gümüşent'un but'k'ey. ");
INSERT INTO udi_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ǐvel çadıri mixçoox isə məəlin hərrəmine bakala pərdoğo ğaç̌bseynak' əşeğala bütüm mixçoğollarik' misəxuney. ");
INSERT INTO udi_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Moiseyi əmiren běyinš Aaroni ğar İt'amari kalaluğen leviğon ı̌vel irəziluği çadıreynak' əşp'est'it'oğoy siyəyinət'un biq'i. ");
INSERT INTO udi_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Hametər, İuday tayfinaxun Xure nəvə bakala Urin ğar Besalelen Q'ončuğon Moiseya əmirbi hər şeya düzbi çark'eney. ");
INSERT INTO udi_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","İçu Dane tayfinaxun bakala ust'aluğa, kişbsuna saal göyin, mumušak'i, tünd č'oč'a irəngen t'urinen nəzik' kətani parçin loxol naxış laxsuni əşurxo bacarbala Ahit'amaxi ğar Oholiabenal köməybeney. ");
INSERT INTO udi_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ǐvel ganu biq'seynak' əşeśi q'ızıli çəki saq'o vuy t'alant' saal vǔğbaç̌ otuz şek'eley. Mo ı̌vel gala bakala şek'eli çəkinə görəney. Me q'ızıl Q'ončuğoynak' sa pay baksuna ak'est'eynak' alabaki q'ızıley. ");
INSERT INTO udi_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Siyəyinə haq'eśi amdarxoy tadi gümüşi çəki isə sabaç̌ t'alant' saal sa hazar vǔğbaç̌ yetmiş qo şek'eley. Mo ı̌vel gala bakala şek'eli çəkinə görəney. ");
INSERT INTO udi_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Siyəyinə haq'eśi hər q'a saal q'a yəşəxun ala bakala ǔqbaç̌ xib hazar qobaç̌ əlli işq'ara qǐ şek'ele koft'ey. Mo ı̌vel gala bakala şek'eli çəkinə görəney. ");
INSERT INTO udi_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Me gireśi gümüşi sabaç̌ t'alant' ǐvel çadıri q'a iz boş bakala ı̌vel ganu ən ı̌vel ganuxun cöybala pərdin sütünxoy laxala ganxo q'əliben düzbseynak'e əşeśi: sabaç̌ dənə laxala ganeynak' sabaç̌ t'alant', hər laxala ganeynak' sa t'alant'. ");
INSERT INTO udi_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Sa hazar vǔğbaç̌ yetmiş qo şek'el isə sütünxoy ğaç̌esunxo q'a q'armağxo düzbseynak' saal şot'oğoy bula but'k'seynak'e əşeśi. ");
INSERT INTO udi_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Q'ončuğoynak' alabaki pay tadeśi mise çəki yetmiş t'alant' saal p'ə̌ hazar bip'baç̌ şek'eley. ");
INSERT INTO udi_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Şot'oxun ı̌vel çadıri bağala gane sütünxoy laxala ganxo, misnə q'urban eçala ganu, şot'ay misnə reşot'k'ina saal me q'urban eçala ganeynak' bütüm lazım bakalt'oğot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Mandi misəxun isə məəlin hərrəmine bakala sütünxoy oq'a bakala laxala ganxo, bağala gane sütünxoy laxala ganxo, çadıreynak' saal məəlin hərrəmineynak' əşeśi bütüm mixçoğot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Q'ončuğon Moiseya əmirbi k'inək' göyin, mumušak'i saal tünd č'oč'a irəngen t'uriğon ı̌vel gala q'ulluğbseynak' běyinšxoynak' q'a Aaroneynak' ǐvel paltarxot'un ěbi. ");
INSERT INTO udi_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Samci běyinši döşlinə q'ızılaxun, göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon saal nəzik' kətani parçinaxunt'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Mot'aynak' q'ızıla t'api t'ə̌p'ə̌k'p'i şot'oğoxun t'urit'un k'as'p'i. Oşa t'e t'uriğoxun q'a göyin, mumušak'i saal tünd č'oč'a irəngen bakala t'uriğon nəzik' kətani parçin loxol naxışxot'un c'evk'i. ");
INSERT INTO udi_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Oşa t'e döşlin p'ə̌ t'ǒğə sun-sunaxun ğaç̌bseynak' ə̌mnəbelxun tağala p'ə̌ dənə parçat'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Şot'ay loxol bakala q'ızıli, göyin, mumušak'i saal tünd č'oč'a irəngen t'uriğon q'a nəzik' kətani parçinen ə̌leśi q'ayinş şot'oxun saney. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Şot'oğon oniksi ǰěyurxoval q'ızıli çərçüvoğoy boş laxi şot'oğoy loxol İsraili ğarmoğoy s'iyurxo peçat düzbat'an t'ap'k'ala k'inək' t'api śamt'unpi. ");
INSERT INTO udi_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Oşa şot'oğo döşlin ə̌mnəbelxun tağala parçoğoy loxol ost'aart'unbi ki, morox israilluğo eyex efseynak' bakala ǰěyurxoq'an baki. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Suruk' cuyal döşli k'inək' q'ızıli, göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon saal nəzik' kətani parçinen düzbi iz loxol naxışxot'un laxi. ");
INSERT INTO udi_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Suruk' cu p'ə̌q'at parçinen, bip'dönbələney: iz boxoyluğ q'a gengluğ sa ciney. ");
INSERT INTO udi_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","İz loox bip' cörgə toyexlu ǰěyurxot'un t'ak'p'i: samci cörginə rubin, topaz, izumrud; ");
INSERT INTO udi_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","p'ə̌mci cörginə birüzə, göyin rubin saal almaz; ");
INSERT INTO udi_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","xibimci cörginə giaśint', agat' saal amet'ist'; ");
INSERT INTO udi_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","bip'imci cörginə isə beril, oniks saal yasp'is. Me ǰěyurxo q'ızıli çərçüvoğone laxeśey. ");
INSERT INTO udi_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Şorox İsraili ğarmoğoy saya görə p'as's'e dənəney. P'as's'e tayfin hər sunt'ay s'i me ǰěyurxoy loxol peçat k'inək' t'ap'eśeney. ");
INSERT INTO udi_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Suruk' cuyeynak' təmiz q'ızılaxun kəndür k'inək' ə̌leśi zincirxot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Q'ızılaxun p'ə̌ dənə çərçüvə saal p'ə̌ dənə halq'at'un düzbi. Oşa me halq'oğo suruk' cuye p'ə̌ t'ǒğə̌xun biq'est'i ");
INSERT INTO udi_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","t'e p'ə̌ q'ızıli zincirə suruk' cuye p'ə̌ halq'inaxun lavt'unk'i. ");
INSERT INTO udi_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Zincirxoy t'e soğo bulurxo isə suruk' cuye ə̌mnəbel bakala parçin běšin tərəf bakala çərçüvoğoxunt'un ost'aarbi. ");
INSERT INTO udi_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Saal p'ə̌ dənə q'ızıli halq'at'un düzbi, şot'oğoval suruk' cuye p'ə̌ t'ǒğəxun samci běyinši döşliyəxun sagala bonaxun biq'est'undi. ");
INSERT INTO udi_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Q'erəz p'ə̌ q'ızıli halq'al düzt'unbi, şot'oğo samci běyinši döşlin ə̌mnəbelxun tağala parçin běšin tərəf, oq'a, döşlin q'ayinşaxun ğaç̌eğala galat'un ost'aarbi. ");
INSERT INTO udi_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Suruk' cuye halq'oğo q'a döşlin halq'oğo göyin irəngen bakala bağen t'etərt'un ğaç̌p'i ki, cu döşlin q'ayinşi oq'aq'an mandi. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Samci běyinši döşlin oq'axun bakala paltara göyin irəngen parçinaxunt'un ěbi. ");
INSERT INTO udi_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Bǐyexun bul c'ovakseynak' gat'un efi. Şot'ay t'ǒğǔrxo nu zığbakseynak' t'urinen ə̌lt'undi. ");
INSERT INTO udi_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","T'e paltari ətəyi hərrəmine göyin, mumušak'i, tünd č'oč'a irəngen t'uriğon saal nəzik' kətani parçinen mis'ik' ə̌lə̌mxot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Təmiz q'ızılaxun mis'ik' zəngürxoval düzbi me ə̌lə̌mxoy arane ět'unbi. ");
INSERT INTO udi_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Metərluğen, ı̌vel gala q'ulluǧbseynak' bakala me paltari ətəyi hərrəmine ə̌lə̌mxo q'a zəngürxo sunay bač'anexune t'ak'eśey. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Aaroneynak' q'a iz ğarmoğoynak' nəzik' kətani parçinaxun guratxot'un ěbi. ");
INSERT INTO udi_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Oşa kətani parçinaxun çalmoox, papaq'xo saal qǒlǒğxo, ");
INSERT INTO udi_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","göyin, mumušak'i saal tünd č'oč'a irəngen bakala t'uriğon q'a nəzik' kətani parçinaxun q'ayinşal ěbi iz loxol naxışxot'un laxi. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Təmiz q'ızılaxun ı̌velluği tac bakala sa medalyon düzbi şot'ay loxol \"Q'ončuğoynak' ı̌vel baki\" śama peçati loxol t'ap'k'ala k'inək' t'api śamt'unpi. ");
INSERT INTO udi_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Oşa şot'o çalminaxun ost'aarbseynak' iz loxol göyin bağt'un laxi. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Metərluğen, ı̌vel çadıreynak', yəni irəziluği çadıreynak' bakala bütüm əşurxo çarek'i. Q'ončuğon Moiseya hetər əmirbeneysa, israilluğon me əşə t'etərəl bit'un. ");
INSERT INTO udi_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Oşa ı̌vel çadıreynak' düzbi bütüm şeyurxo Moiseyi běšt'un eçeri: pərdoğo, halq'oğo, çərçüvoğo, sütünxo, sütünxoy laxala ganxo, peşt'uvanxo, ");
INSERT INTO udi_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","č'oč'a irəng duğeśi eğeli t'olen düzbaki pərdinə, q'erəz nəzik' t'olen düzbaki pərdinə, ı̌vel ganu ən ı̌vel ganuxun cöybala pərdinə, ");
INSERT INTO udi_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","irəziluği sanduğa saal şot'ay durut'xo, bağışlayinşbsuni q'apağa, ");
INSERT INTO udi_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ist'ola saal şot'ay loxol laxala q'av-q'acağa, Q'ončuğo həsrbakala šuma, ");
INSERT INTO udi_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","təmiz q'ızılaxun bakala pisosa q'a iz çiraǧxo saal c'əyinə, ");
INSERT INTO udi_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","q'ızılaxun bakala q'urban eçala ganu, lə̌ə̌mst'eynak' bakala c'əyinə, adeğala buxura, çadıri bağala ganeynak' bakala pərdinə, ");
INSERT INTO udi_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","misnə q'urban eçala ganu, şot'aynak' bakala misnə reşot'k'ina, şot'ay durut'xo saal şot'ay bütüm lazım bakala şeyurxo, ləənə saal şot'ay laxala ganu, ");
INSERT INTO udi_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","məəlin pərdoğo, sütünxo q'a şot'oğoy laxala ganxo, məəlin bağala ganeynak' bakala pərdinə saal şot'ay kəndürxo q'a mixçoğo. Morox bito ı̌vel çadıra, yəni irəziluği çadıri boş q'ulluğbseynak' bakala şeyurxoney. ");
INSERT INTO udi_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ǐvel gala q'ulluğbseynak' bakala ı̌vel paltarxo - běyinš Aaroni saal iz ğarmoğoy běyinšluğbseynak' ěbeśi paltarxoval et'unçeri. ");
INSERT INTO udi_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Q'ončuğon Moiseya hetər əmirbeneysa, israilluğon hat'etərəl bet'uniy. ");
INSERT INTO udi_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moiseyenal mot'oğo bitova iz piyexun c'ovakest'i anek'i ki, şot'oğon bütümə Q'ončuğon əmirbi k'inək't'un be. Şot'o görəl Moiseyen me əşurxo bi amdarxo xeyir-bərəkəte tadi. ");
INSERT INTO udi_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Oşa Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Samci xaşe samci ğine ı̌vel çadıra, yəni irəziluği çadıra girba. ");
INSERT INTO udi_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","İrəziluği sanduğa çadıri boş laxi pərdinen iz běšt'an but'k'a. ");
INSERT INTO udi_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Oşa ist'ola eçeri iz loxol lazım bakala şeyurxo laxa. Pisosa eça, çirağxoval iz loxol laxa. ");
INSERT INTO udi_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Buxur bok'ospseynak' bakala q'ızıli q'urban eçala ganu irəziluği sanduği běš laxa. Çadıri bağala gala pərdinəl suruk'p'a. ");
INSERT INTO udi_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Bok'ospsuni q'urbanxoynak' bakala q'urban eçala ganu ı̌vel çadıri - irəziluği çadıri bağala gane běš laxa. ");
INSERT INTO udi_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ləənə ı̌vel çadıri q'a t'e q'urban eçala gane arane laxa, iz boşal xe bapa. ");
INSERT INTO udi_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Çadıri hərrəmine məələ düzba, bağala gane pərdinəl suruk'p'a. ");
INSERT INTO udi_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Oşa lə̌ə̌mst'eynak' bakala c'əyinə ext'i ı̌vel çadıra saal iz bona bakala hər şeya lə̌ə̌mda. Metər, şot'o saal bütüm iz lazım bakala şeyurxo ı̌velba ki, şoroxal ǐvelq'at'un baki. ");
INSERT INTO udi_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Bok'ospsuni q'urbanxoynak' bakala q'urban eçala ganu, şot'o lazım bakala şeyurxoval lə̌ə̌mdi ı̌velba ki, şo ı̌velxoy ǐveloq'an baki. ");
INSERT INTO udi_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ləənə saal şot'ay laxala ganu c'əyin lə̌ə̌mdi ı̌velba. ");
INSERT INTO udi_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Oşa Aarona saal şot'ay ğarmoğo ı̌vel çadıri bağala gala eçeri xenen os'k'a. ");
INSERT INTO udi_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Aarona ǐvel paltarxo lapest'a. Şot'o c'əyin lə̌ə̌mdi ı̌velba ki, Zaynak' běyinšluğq'anbi. ");
INSERT INTO udi_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Oşa Aaroni ğarmoğo eçeri şot'oğo gurat' lapest'a. ");
INSERT INTO udi_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","İçoğoy bava c'əyin lə̌ə̌mdi k'inək' şot'oğoval c'əyin lə̌ə̌mda ki, Zaynak' běyinšluğq'at'unbi. Me lə̌ə̌mst'un şo upsune ki, běyinšluğbsun şot'oğoy nəsilə həmişəluğe tadeśe». ");
INSERT INTO udi_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moiseyenal Q'ončuğon içu əmirbi k'inək' bine. ");
INSERT INTO udi_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","İsrailluğoy Misirəxun c'eysun p'ə̌mci usena bağat'an, t'e useni samci xaşe samci ğine ı̌vel çadır laxeśi. ");
INSERT INTO udi_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moiseyen çadıra girebi: çərçivoğo içoğoy oq'a bakala laxala ganxoxun ost'aarebi, peşt'uvanxo saal sütünxone alabi. ");
INSERT INTO udi_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Oşaal ı̌vel çadıri looxun but'k'i iz looxun p'ə̌mci saal xibimci q'atal lanexi. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Mot'oxun oşa şot'in İrəziluği śama ext'i sanduği boşe laxi. Durut'xo sanduğa lavek'i, bağışlayinşbsuni q'apağal sanduği loxole laxi. ");
INSERT INTO udi_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Sanduğa ı̌vel çadıri boş eçeri ı̌vel ganu ən ı̌vel ganuxun cöybala pərdinə suruk'p'i irəziluği sanduği běšt'an bineq'i. Q'ončuğon Moiseya hetər əmirbeneysa hat'etərəl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","İst'ola eçeri ı̌vel çadıri boş, q'uzey tərəf, pərdin běš lanexi. ");
INSERT INTO udi_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Šumal şot'ay loxol, Q'ončuğoy běš lanexi. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Pisosa isə ǐvel çadıri boş, ist'olaxun ç̌obaç̌o, çadıri güney tərəfe laxi. ");
INSERT INTO udi_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Çirağxoval pisosi loxol, Q'ončuğoy běš lanexi. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Q'ızıli q'urban eçala ganuval ı̌vel çadıri boş, pərdin běš laxi ");
INSERT INTO udi_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","şot'ay loxol adeğala buxure bok'osp'i. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Çadıri bağala gala pərdəne suruk'p'i. ");
INSERT INTO udi_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Bok'ospsuni q'urbanxoynak' bakala q'urban eçala ganuval ext'i ı̌vel çadıri, yəni irəziluği çadıri bağala ganu ı̌ša lanexi; şot'ay loxol bok'ospsuni q'urbanxo q'a taxıli payurxone eçeri. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ləənə ı̌vel çadıri saal q'urban eçala gane arane laxi iz boş běyinšxoy pak bakseynak' xene bapi. ");
INSERT INTO udi_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moiseyen, Aaronen saal iz ğarmoğon t'et'iya içoğoy kula-turat'un os'ksay. ");
INSERT INTO udi_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Şot'oğon ı̌vel çadıra bağat'an saal q'urban eçala ganu ı̌šalayinşakat'an mot'o bsat'uniy. Q'ončuğon Moiseya əmirbi k'inək'əl baneki. ");
INSERT INTO udi_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moiseyen çadıri q'a q'urban eçala gane hərrəminə bineq'i, məəlin bağala gane pərdinəl suruk'ebi. Metərluğen, Moiseyen əşurxo çarek'i. ");
INSERT INTO udi_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","T'e vədine asoyen irəziluği çadıra bəc'ürepi, Q'ončuğonalİzi tamtaraǧen q'a kalaluğen ǐvel çadıra buyebi. ");
INSERT INTO udi_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisey irəziluği çadıra bayes tene baki, şot'aynak' ki, asoy çadıri loxoley, Q'ončuğonİzi tamtaraǧen q'a kalaluğen çadıra buybeney. ");
INSERT INTO udi_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","İsrailluyox t'e asoy çadıri loxolxun ala ěqeğat'ant'un yaq' c'eysay; ");
INSERT INTO udi_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Q'ončuğoy asoy nu ěqeğat'an isə, yaq' tet'un c'eysay, t'e asoyi ěqesunat'un yaq'běğsay. ");
INSERT INTO udi_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Metərluğen, ğenaxun me asoy çadıri loxoley, üşe isə t'e asoyi boş aruxe boksay, israilluğonal mot'o içoğoy piin at'unksay. Heq'ədər ki şorox ams'i oç̌alat'uniy, mo metərey.");
INSERT INTO udi_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","İsrailluğoy Misirəxun c'eysuni p'ə̌mci useni p'ə̌mci xaşe samci ğiney. Sinay ams'i oç̌ala, Q'ončuğon ı̌vel çadıra Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Bütüm israilluğoy işq'arxo siyəyinə haq'anan. Bǒq'ə̌leğala bütüm işq'arxoy s'iyurxo içoğoy əsilə q'a ailinə görə soğo-soğo śampanan. ");
INSERT INTO udi_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Hun q'a Aaronen israilluğoy boş q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxo bǒq'ə̌lpi dəst'oğo cöybalnan. ");
INSERT INTO udi_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Barta və̌x hər tayfinaxun iz ailin kalo bakala sa işq'aren köməybeq'an. ");
INSERT INTO udi_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Mone, və̌x köməybalorox morox bakale: Ruveni tayfinaxun - Şedeuri ğar Elisur; ");
INSERT INTO udi_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeoni tayfinaxun - Śurişaddayi ğar Şelumiel; ");
INSERT INTO udi_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","İuday tayfinaxun - Amminadavi ğar Naxşon; ");
INSERT INTO udi_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","İssak'ari tayfinaxun - Śuari ğar Net'anel; ");
INSERT INTO udi_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zevuluni tayfinaxun - Xeloni ğar Eliav; ");
INSERT INTO udi_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","İosifi nəsiləxun bakala: Efraimi tayfinaxun Ammihudi ğar Elişama saal Menaşşeni tayfinaxun P'edaśuri ğar Gamliel; ");
INSERT INTO udi_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Binyamini tayfinaxun - Gidoni ğar Avidan; ");
INSERT INTO udi_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dane tayfinaxun - Ammişaddayi ğar Axiezer; ");
INSERT INTO udi_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aşeri tayfinaxun - Ok'rani ğar P'agiel; ");
INSERT INTO udi_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gade tayfinaxun - Deueli ğar Elyasaf; ");
INSERT INTO udi_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naft'alin tayfinaxun - Enani ğar Axira». ");
INSERT INTO udi_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Morox israilluğoxun təyinbaki, içoğoy tayfin q'a əsili boş kalo hesabbakala amdarxot'uniy. ");
INSERT INTO udi_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moiseyen q'a Aaronenal me s'iyurxo duğeśi amdarxoxun sagala ");
INSERT INTO udi_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","p'ə̌mci xaşe samci ğine bütüm israilluğo topt'unbi. Şot'oğon q'a yəşt'ə saal q'a yəşəxun ala bakala bütüm işq'arxo içoğoy əsilə q'a ailinə görə soğo-soğo siyəyinət'un haq'i. ");
INSERT INTO udi_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Hametər, şot'oğon Sinay ams'i oç̌ala Q'ončuğon Moiseya əmirbi k'inək' azuk'a siyəyinət'un haq'i. ");
INSERT INTO udi_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","İsraili samci ğar Ruveni nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakalt'oğoy bitot'ay s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ruveni tayfinaxun siyəyinə haq'eśit'oğoy say 46 500 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeoni nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Simeoni tayfinaxun siyəyinə haq'eśit'oğoy say 59 300 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gade nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gade tayfinaxun siyəyinə haq'eśit'oğoy say 45 650 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","İuday nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","İuday tayfinaxun siyəyinə haq'eśit'oğoy say 74 600 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","İssak'ari nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","İssak'ari tayfinaxun siyəyinə haq'eśit'oğoy say 54 400 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zevuluni nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zevuluni tayfinaxun siyəyinə haq'eśit'oğoy say 57 400 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","İosifi ğarmoğoy nəsiləl bǒq'ə̌leśi. Efraimi nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy nəsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efraimi tayfinaxun siyəyinə haq'eśit'oğoy say 40 500 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Menaşşeni nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinə haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Menaşşeni tayfinaxun siyəyinə haq'eśit'oğoy say 32 200 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Binyamini nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Binyamini nəsiləxun siyəyinə haq'eśit'oğoy say 35 400 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dane nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dane tayfinaxun siyəyinə haq'eśit'oğoy say 62 700 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aşeri nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Aşeri tayfinaxun siyəyinə haq'eśit'oğoy say 41 500 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naft'alin nəsiləxun q'a saal q'a yəşəxun ala bakala, davina tayes bakala bito işq'arxoy s'iyurxo içoğoy əsilə saal ailinə görə soğo-soğo siyəyinəne haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naft'alin tayfinaxun siyəyinə haq'eśit'oğoy say 53 400 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Metərluğen, Moiseyen, Aaronen saal israilluğoy boşt'an c'ək'eśi, içoğoy ailoğoy kalo bakala p'as's'e işq'aren me amdarxone siyəyinə haq'i. ");
INSERT INTO udi_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","İsrailluğoxun içoğoy ailoğo görə davina tayes bakala, q'a saal q'a yəşəxun ala siyəyinə haq'eśi ");
INSERT INTO udi_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","bito işq'arxoy say 603 550 taney. ");
INSERT INTO udi_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ama Levin tayfinaxun bakalorox siyəyinə tet'un haq'eśi, ");
INSERT INTO udi_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","şot'aynak' ki, Q'ončuğon Moiseya peney: ");
INSERT INTO udi_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Levin tayfinaxun bakalt'oğo israilluğoxun sagala me siyəyinə hamaq'a. ");
INSERT INTO udi_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Şot'oğo irəziluği çadıra saal şot'ay boş q'ulluğbseynak' lazım bakala bütüm ət't'əcxo běğsuna tapşurba. Barta və̌n ef ganu badalbat'an irəziluği çadıra saal şot'ay bütüm şeyurxo şot'oğonq'at'un taşeri. Çadıra şot'oğon běğalat'un, içoğoy çurk'ala ganuval çadıri hərrəmineq'at'un düzbi. ");
INSERT INTO udi_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Çadıra sa ganuxun t'iyə̌mi ganu taşat'an barta leviğonq'an şot'o t'at'api, çadıra girbsunal şot'oğo tapşurba. Kot'oğoxun başq'a çadıra ı̌šalayinşakala amdar biyalane. ");
INSERT INTO udi_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Barta israilluğon dəst'oğo cöybakiq'at'un içoğoy çurk'ala ganu düzbi, içoğoy mani tayfinaxun baksuna ak'est'ala nišana laxsunal eyexun maq'at'un c'evk'i. Hər işq'ar iz dəst'inəq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Leviğon isə içoğoy çurk'ala ganu irəziluği çadıri hərrəmineq'at'un düzbi, şot'o görə ki, çadıra şot'oğon běğalat'un. Tene İzi əyitəxun c'eysuna görə Q'ončuğoy əcuğ israilluğoy loxol barale». ");
INSERT INTO udi_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","İsrailluğonal mot'oğo bitova Q'ončuğon Moiseya pi k'inək' bit'un. ");
INSERT INTO udi_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Barta ı̌vel çadır bı̌yexq'an baki, israilluğon isə içoğoy çurk'ala ganu şot'ay hərrəmineq'at'un düzbi: hər soğo iz dəst'in boş. İçoğoy mani dəst'inəxun saal ailinəxun baksuna ak'est'ala nišana laxsunal eyexun maq'at'un c'evk'i. ");
INSERT INTO udi_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","İuday dəst'ə běğ c'eğalaç tərəfq'an baki, dəst'in izi nišanal bakeq'an. İuday tayfin kalo isə Amminadavi ğar Naxşonq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","İuday tayfinaxun siyəyinə haq'eśi işq'arxoy say 74 600 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","İssak'ari tayfinenal me dəst'in boş, İuday tayfin t'ǒğǒlq'an iz çurk'ala ganu düzbi. İzi kalo isə Śuari ğar Net'anelq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","İssak'ari tayfinaxun siyəyinə haq'eśi işq'arxoy say 54 400 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Zevuluni tayfal mot'oğoy boş, İssak'ari tayfin t'ǒğǒlq'an baki. Me tayfin kalo isə Xeloni ğar Eliavq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Zevuluni tayfinaxun siyəyinə haq'eśi işq'arxoy say 57 400 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Metərluğen, İuday dəst'inə 186 400 tane bu. Yaq' c'eğat'an me dəst'ə běš tağale. ");
INSERT INTO udi_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ruveni dəst'ə güney tərəfq'an baki, dəst'in izi nišanal bakeq'an. Tayfin kalo isə Şedeuri ğar Eliśurq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ruveni tayfinaxun siyəyinə haq'eśi işq'arxoy say 46 500 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeoni tayfinenal iz çurk'ala ganu me dəst'in boş, Ruveni dəst'in t'ǒğǒlq'an düzbi. İzi kalo isə Śurişaddayi ğar Şelumielq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Simeoni tayfinaxun siyəyinə haq'eśi işq'arxoy say 59 300 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gade tayfal mot'oğoy boş, Simeoni tayfin t'ǒğǒlq'an baki. Me tayfin kalo isə Deueli ğar Elyasafq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Gade tayfinaxun siyəyinə haq'eśi işq'arxoy say 45 650 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Metərluğen, Ruveni dəst'inə bito sagala 151 450 tane bu. Yaq' c'eğat'an me dəst'ə İuday dəst'in bač'anexun tağale. ");
INSERT INTO udi_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Yaq' c'eğat'an ǐvel çadıra Levin tayfinenq'an taşeri. Şorox tayfoğoy arane, bı̌yexq'at'un taśi. Barta bito içoğoy çurk'ala ganu mani q'aydinent'un çurpeysa, hat'e q'aydinenq'at'un yaq' taśi: hər soğo iz dəst'in boş. Hər dəst'in içu c'ək'p'est'ala nišanal bakeq'an. ");
INSERT INTO udi_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraimi dəst'ə běğ batk'alaç tərəfq'an baki, dəst'in izi nišanal bakeq'an. Efraimi dəst'in kalo isə Ammihudi ğar Elişamaq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Me tayfinaxun siyəyinə haq'eśi işq'arxoy say 40 500 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Menaşşeni tayfinen me dəst'in boş, Efraimi tayfin t'ǒğǒlq'an iz çurk'ala ganu düzbi. Tayfin kalo isə P'edahśuri ğar Gamlielq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Menaşşeni tayfinaxun siyəyinə haq'eśi işq'arxoy say 32 200 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Binyamini tayfal mot'oğoy boş Menaşşeni tayfin t'ǒğǒlq'an baki. Me tayfin kalo isə Gideoni ğar Avidanq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Binyamini tayfinaxun siyəyinə haq'eśi işq'arxoy say 35 400 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Metərluğen, Efraimi dəst'inə bito sagala 108 100 tane bu. Yaq' c'eğat'an xibimci şorox tağale. ");
INSERT INTO udi_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dane dəst'ə q'uzey tərəfq'an baki, dəst'in izi nišanal bakeq'an. İzi kalo isə Ammişaddayi ğar Axiezerq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Dane tayfinaxun siyəyinə haq'eśi işq'arxoy say 62 700 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aşeri tayfinen me dəst'in boş, Dane tayfin t'ǒğǒlq'an iz çurk'ala ganu düzbi. Tayfin kalo isə Ok'rani ğar P'agielq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Aşeri tayfinaxun siyəyinə haq'eśi işq'arxoy say 41 500 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Naft'alin tayfal mot'oğoy boş, Aşeri tayfin t'ǒğǒlq'an baki. Me tayfin kalo isə Enani ğar Axiraq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Naft'alin tayfinaxun siyəyinə haq'eśi işq'arxoy say 53 400 tane. ");
INSERT INTO udi_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Metərluğen, Dane dəst'inə bito sagala 157 600 tane bu. Yaq' c'eğat'an barta me dəst'ə axırınciq'an taśi. İz loxol içoğo c'ək'p'est'ala nišanal bakeq'an». ");
INSERT INTO udi_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hametər, israilluğoxun içoğoy ailoğo görə siyəyinə haq'eśiyorox moroxe. Tayfoğo cöybaki dəst'oğoy boş bakalorox bito sagala 603 550 taney. ");
INSERT INTO udi_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Leviyox isə Q'ončuğon Moiseya pi k'inək' israilluğoxun sagala me siyəyinə tet'un haq'eśey. ");
INSERT INTO udi_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","İsrailluğon içoğoy çurk'ala ganu düzbsuni yönəl, yaq' c'eğat'an taysuni yönəl Q'ončuğon Moiseya pi q'aydinen bit'un. Hər soğo iz əsiləxun, iz ailinəxun bakalt'oğoxun sagalaney, hər dəst'inal izi nišane buy. ");
INSERT INTO udi_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Q'ončuğon Sinay buruğo Moiseyaxun exlətp'ala vədine Aaroni q'a Moiseyi nəsili boş bakalorox moroxey. ");
INSERT INTO udi_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaroni süft'in ğar bakala Nadav, oşa Avihu, Eleazar saal İt'amar. ");
INSERT INTO udi_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mo Aaroni ğarmoğoy s'iyurxone, Moiseyen şot'oğo c'əyin lə̌ə̌mdi Buxačuğoynak' běyinšluğbseynak'e laxey. ");
INSERT INTO udi_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ama Nadav q'a Avihu Sinay ams'i oç̌ala Q'ončuğoynak' q'urban eçat'an aruğo Şot'ay laxi q'aydinen tet'un bey, şot'aynak'al hat'e dayğa p'uret'uniy. Şorox biyat'an içoğoxun oşa nəsilə davambaloroxal buteney. Metərluğen, saycə Eleazaren q'a İt'amarene běyinšluğbi. Şot'oğon běyinšluğa burqat'an içoğoy bava Aaron dirist'ey. ");
INSERT INTO udi_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Leviğo běyinš Aaroni kiin oq'a əşpseynak' laxa ki, şot'in q'ulluğbat'an iz t'ǒğǒl baki şot'o köməybeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Barta şot'oğon ǐvel çadıra Aaroni q'a bütüm israilluğoy gala q'ulluğbi t'iya bakala əşurxost'a köməybeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Metər, şot'oğon bütüm israilluğoy gala q'ulluğbi ǐvel çadıri şeymoğo běğalat'un, t'iya bakala bütüm əşurxost'a köməybalat'un. ");
INSERT INTO udi_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Leviyox Aaroni q'a şot'ay ğarmoğoy kiin oq'a əşp'alat'un, şorox israilluğoy tayfoğoy boşt'an mot'aynak't'un c'ək'eśi şot'oğo tam həsrbaki. ");
INSERT INTO udi_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aarona q'a iz ğarmoğo isə běyinšluğbseynak' laxa. Mot'oğoxun q'erəz ı̌vel ganu ı̌šalayinşakala amdar biyalane». ");
INSERT INTO udi_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Oşa Q'ončuğon saal Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Zu leviğo israilluğoy boş nanaxun baki bito süft'in ğar əyloğoy galaz ext'i. Şot'oğo bito israilluğoy tayfoğoy boşt'an c'ək'p'i Beziz bi, ");
INSERT INTO udi_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","şot'aynak' ki, bito süft'in nanaxun bakiyorox Bezine. Zu Misirə bütüm süft'in nanaxun bakit'oğo k'as'k'at'an israilluğoy süft'in nanaxun bakit'oğo c'ək'espi, şot'oğo Beziz bi: ham amdarxoy boşt'an, ham heyvanxoy boşt'an. Şorox Bezine - Q'ončux Zuzu». ");
INSERT INTO udi_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Q'ončuğon Sinay ams'i oç̌ala Moiseya metərəl pine: ");
INSERT INTO udi_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Levin tayfinaxun bakalt'oğo içoğoy əsilə q'a ailinə görə siyəyinə haq'a. Siyəyinə sa xaşaxun ala bakala bütüm ğar əyloğo q'a işq'arxo haq'a». ");
INSERT INTO udi_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moiseyenal Q'ončuğon içu əmirbi k'inək' Levin tayfinaxun bakalt'oğo siyəyinəne haq'i. ");
INSERT INTO udi_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levin ğarmux moroxey: Gerşon, K'ohat' saal Merari. ");
INSERT INTO udi_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gerşonaxun bakiyorox: Livni q'a Şimey. ");
INSERT INTO udi_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","K'ohat'axun bakiyorox: Amram, Yiśar, Xevron saal Uzziel. ");
INSERT INTO udi_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merarinaxun bakiyorox: Maxli q'a Muşi. Metərluğen, leviyox uk'ala tayfa mot'oğoxune əmələ hare. ");
INSERT INTO udi_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gerşonaxun Livni q'a Şimeye bakey. Mot'oğoxun əmələ hari Gerşoni nəsili boş ");
INSERT INTO udi_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","7 500 tan siyəyinəne haq'eśi. Mo sa xaşaxun ala bakala ğar əyloğoy q'a işq'arxoy sayey. ");
INSERT INTO udi_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gerşoni nəsiləxun bakalt'oğon içoğoy çurk'ala ganu ı̌vel çadıri bač'ane, běğ batk'alaç tərəf düzbalat'uniy. ");
INSERT INTO udi_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Me nəsiləxun bakalt'oğoy kalo Laeli ğar Elyasafey. ");
INSERT INTO udi_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ǐvel çadıra Gerşoni nəsiləxun bakalt'oğoy əş money: çadıri looxun but'eğala xib q'atal běğsun, çadıri bağala gala bakala pərdinə běğsun saal ");
INSERT INTO udi_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","çadır q'a q'urban eçala ga bakala məəlin pərdoğo q'a iz bağala gane pərdinə běğsun. Məəlin pərdoğoy kəndürxo q'a mandi ət't'əcxoval şot'oğont'un běğsay. ");
INSERT INTO udi_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","K'ohat'axun Amram, İshar, Xevron saal Uzziele bakey. Mot'oğoxun əmələ hari K'ohat'i nəsiləxun ");
INSERT INTO udi_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","8 600 tane siyəyinə haq'eśi. Mo sa xaşaxun ala bakala ğar əyloğoy q'a işq'arxoy sayey. Şot'oğoy əş ı̌vel gala bakala ən ı̌vel şeymoğo běğsuney. ");
INSERT INTO udi_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","K'ohat'i nəsiləxun bakalt'oğon içoğoy çurk'ala ganu ı̌vel çadıri güney tərəf düzbalat'uniy. ");
INSERT INTO udi_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Me nəsiləxun bakalt'oğoy kalo Uzzieli ğar Elisafaney. ");
INSERT INTO udi_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Şot'oğoy əş ı̌vel sanduğa, ist'ola, pisosa, q'urban eçala ganxo q'a ı̌vel çadıra əşeğala bütüm ət't'əcxo běğsuney. Ǐvel ganu ən ı̌vel ganuxun cöybala pərdinəl K'ohat'i nəsiləxun bakalt'oğone běğsay. Me şeyurxo běğseynak' bakala bütüm əşurxo şot'oğont'un biq'say. ");
INSERT INTO udi_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Bütüm Levin tayfinaxun bakalt'oğoy kalo isə běyinš Aaroni ğar Eleazarey. Me ı̌vel ganu běğala amdarxo bito şot'ay kiin oq'ane əşbsay. ");
INSERT INTO udi_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merarinaxun Maxlin q'a Muşine bakey. Mot'oğoxun əmələ hari Merarin nəsiləxun ");
INSERT INTO udi_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","6 200 tane siyəyinə haq'eśi. Mo sa xaşaxun ala bakala ğar əyloğoy q'a işq'arxoy sayey. ");
INSERT INTO udi_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Me nəsiləxun bakalt'oğoy kalo Avixayili ğar Śuriele baki. Şot'oğon içoğoy çurk'ala ganu ı̌vel çadıri q'uzey tərəf düzbalat'uniy. ");
INSERT INTO udi_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merarin nəsiləxun bakalt'oğon ı̌vel çadıri çərçüvoğo, peşt'uvanxo, sütünxo q'a şot'oğo laxala ganxo saal mot'oğoy bütüm ət't'əcxo běğalat'uniy. Me şeyurxo běğseynak' bakala bütüm əşurxo şot'oğont'un biq'say. ");
INSERT INTO udi_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Çadıri məəlin sütünxo q'a şot'oğo laxala ganxo, şot'oğoy mixçoğo q'a kəndürxoval şot'oğont'un běğsay. ");
INSERT INTO udi_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ǐvel çadıri běš, běğ c'eğala tərəf isə Moiseyen, Aaronen saal iz ğarmoğont'un çurk'ala ga düzbsay. Şot'oğont'un ı̌vel çadıra bütüm israilluğoy gala q'ulluğbi t'iyana běğsay. Mot'oğoxun q'erəz ı̌vel ganu ı̌šalayinşakala amdar biyalaney. ");
INSERT INTO udi_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Metərluğen, Moiseyen q'a Aaronen Q'ončuğoy əmiren siyəyinə haq'i bütüm Levin tayfinaxun bakalt'oğoy say 22 000 taney. Mo sa xaşin saal kot'oxun ala bakala bütüm ğar əyloğoy q'a işq'arxoy sayey. ");
INSERT INTO udi_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Q'ončuğon Moiseya peney: «İsrailluğoxun sa xaşin saal kot'oxun ala bakala bütüm ğar əyloğo q'a işq'arxo siyəyinə haq'i içoğoy s'iyurxo śampa. ");
INSERT INTO udi_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","İsrailluğoy süft'in nanaxun baki ğar əyloğoy gala leviğo, heyvanxoy süft'in ərkəy baloğoy gala isə leviğoy heyvanxoy baloğo Zaynak' cöyba. Q'ončux Zuzu». ");
INSERT INTO udi_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moiseyenal Q'ončuğon içu pi k'inək' bine: israilluğoy boş bütüm süft'in nanaxun baki ğar əyloğo q'a işq'arxo siyəyinəne haq'i. ");
INSERT INTO udi_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","S'iya śampi siyəyinə haq'eśi sa xaşin saal kot'oxun ala bakala bütüm süft'in nanaxun baki ğar əyloğoy q'a işq'arxoy say 22 273 taney. ");
INSERT INTO udi_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Q'ončuğon Moiseya peney: ");
INSERT INTO udi_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«İsrailluğoy süft'in ğarmoğoy gala leviğo, içoğoy heyvanxoy süft'in ərkəy baloğoy gala isə leviğoy heyvanxoy süft'in ərkəy baloğo cöyba. Leviyox Bezi bakale - Q'ončux Zuzu. ");
INSERT INTO udi_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","47","İsrailluğoy süft'in nanaxun baki ğarmux leviğoxun 273 tan gelene. Şot'oğoy hərt'ay gala isə içoğoxun ı̌vel gane şek'elen qo şek'el ext'a, ı̌vel gane 1 şek'el q'a gere. ");
INSERT INTO udi_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Me təngə leviğoxun 273 tan avuz bakala israilluğoy toye. Tənginə Aarona q'a iz ğarmoğo tada». ");
INSERT INTO udi_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Metərluğen, Moiseyen leviğoy sayaxun avuz bakala israilluğoxun içoğoy gala tadeğala tənginə girebi, ");
INSERT INTO udi_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","moval ı̌vel gane şek'elen 1 365 şek'el gümüşe bi. ");
INSERT INTO udi_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moiseyenal Q'ončuğon içu əmirbi pi k'inək' me tənginə Aarona q'a şot'ay ğarmoğone tadi. ");
INSERT INTO udi_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Leviğoy boş K'ohat'i nəsiləxun bakala işq'arxo içoğoy ailoğo q'a əsilə görə siyəyinə haq'anan. ");
INSERT INTO udi_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Siyəyinə otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes bakala işq'arxoq'an haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ǐvel çadıri ganu badalbat'an K'ohat'i nəsiləxun bakalt'oğoy əş mone: çadıri ən ı̌vel şeymoğo běğsun. ");
INSERT INTO udi_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ama yaq' c'eğat'an barta Aaronen q'a iz ğarmoğonq'at'un ı̌vel ganu ən ı̌vel ganuxun cöybala pərdinə c'evk'i şot'in irəziluği sanduği looxun but'k'i. ");
INSERT INTO udi_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Oşa şot'ay looxun nəzik' t'olaxun düzbaki pərdinen, axırda isə saya göyün irəngen bakala pərdinenq'at'un but'k'i. Sanduğa taşt'eynak' bakala durutxoval şot'oğonq'at'un iz gala badi. ");
INSERT INTO udi_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Q'ončuğohəsrbaki šumurxo laxseynak' bakala ist'olin loxol göyün irəngen parçinenal şot'oğonq'at'un but'k'i. Oşa iz loxol t'alik'xo, q'avurxo saal śik'ala payurxoynak' bakala cürdəkxo q'a camurxoq'at'un laxi. İst'olin loxol bakala Q'ončuğohəsrbaki šumurxoval laxeq'at'un, şoval həmişə iz gala mandeq'an. ");
INSERT INTO udi_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Mot'oğoy bitot'ay looxun tünd č'oč'a irəngen sa parça lap't'i, ç̌oyexunal nəzik' t'olaxun düzbaki pərdinenq'at'un but'k'i. İst'ola taşt'eynak' bakala durutxoval şot'oğonq'at'un iz gala badi. ");
INSERT INTO udi_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Şot'oğon pisosi q'a iz çirağxoy, maşoğoy, xətəngəzxoy saal çirağa bapseynak' bakala c'əyini q'avurxoyal bitot'ay loxol göyün irəngen parça lap't'alat'un. ");
INSERT INTO udi_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Oşa isə pisosi q'a iz ət't'əcxoy loxolxun nəzik' t'olen but'k'i taşt'eynak'q'at'un həzirbi. ");
INSERT INTO udi_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Q'ızılaxun bakala q'urban eçala gane loxolal göyün parça lap't'i oşa nəzik' t'olen but'k'eq'at'un. Q'urban eçala ganu taşt'eynak' bakala durutxoval iz gala badeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ǐvel gala q'ulluğbseynak' əşeğala bütüm şeyurxo ext'i süft'ə göyün parçinen, iz looxun isə nəzik' t'olen but'k'i taşt'eynak' həzirbeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Misnə q'urban eçala ganeyal jeq'a ext'i iz loxol mumušak'i irəngen parçaq'at'un lap't'i. ");
INSERT INTO udi_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Oşa iz loxol izi bütüm ət't'əcxo - jeq'e q'avurxo, ist'amxo, ləənxo, çəngəlxo, xətəngəzxo laxi nəzik' t'olen but'k'eq'at'un. Q'urban eçala ganu taşt'eynak' bakala durutxoval şot'oğonq'at'un iz gala badi. ");
INSERT INTO udi_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","İsrailluğon içoğoy ganu badalbat'an Aaronen q'a iz ğarmoğon bütüm me ı̌vel şeyurxoy looxun but'k'it'uxun oşa, barta K'ohat'i nəsiləxun bakalt'oğonq'at'un hari şot'oğo taşeri. Ama şot'oğoy kul me şeyurxo nu laft'alane, tene biyalt'un. Metərluğen, ǐvel çadıri ət't'əcxoxun K'ohat'i nəsiləxun bakalt'oğoy taşalorox morox bakale. ");
INSERT INTO udi_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Běyinš Aaroni ğar Eleazari əş pisoseynak' bakala c'əyinə, bok'ospseynak' bakala şaat' adeğala oyurxo, hər ği eçala taxıli paya saal lə̌ə̌mst'eynak' bakala c'əyinə běğsun bakale. Şot'in ı̌vel çadıra saal iz boş bakala hər şeya - ı̌vel şeymoğo q'a ı̌vel ət't'əcxo běğalane». ");
INSERT INTO udi_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Ama běğanan ki, K'ohat'i nəsil Levin tayfinaxun maq'an əfçibaki. ");
INSERT INTO udi_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Kot'aynak'al şot'oğoy ı̌vel gala me şeyurxo taşt'eynak' ı̌šalayinşakat'an nu biseynak', barta Aaronen q'a iz ğarmoğonq'at'un hari me şeyurxo taşeri. ");
INSERT INTO udi_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","K'ohat'i nəsiləxun bakalt'oğon ı̌vel gala baśi mot'oğoy saycət'u piin t'ǒğenal bakayin nu ak'alat'un, tene biyalt'un». ");
INSERT INTO udi_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gerşoni nəsiləxun bakala işq'arxoval içoğoy ailoğo q'a əsilə görə siyəyinə haq'a. ");
INSERT INTO udi_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Siyəyinə otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes bakala işq'arxoq'an haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","İsrailluğon içoğoy ganu badalbat'an Gerşoni nəsiləxun bakalt'oğon çadıri me şeyurxo taşalt'un: ");
INSERT INTO udi_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ı̌vel, yəni Q'ončuğoxun exlətpseynak' bakala çadıra q'a iz looxun zap'eśi p'ə̌ q'at ç̌oya, şot'oğoy loxolxun eğala nəzik' t'olaxun düzbaki ç̌oya, çadıri bağala gane pərdinə saal ");
INSERT INTO udi_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","çadır q'a q'urban eçala ga bakala məəlin pərdoğo q'a iz bağala gane pərdinə. Məəlin pərdoğoy kəndürxo q'a mandi ət't'əcxoval şot'oğon běğalat'un. Barta me şeyurxo taşt'unast'a lazım bakala bito əşlə şot'oğonq'at'un biq'i. ");
INSERT INTO udi_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Şot'oğoy me şeyurxo taşt'unast'a bala bito əşlə Aaronen q'a iz ğarmoğon běğalt'un. Şot'oğo me əşlə və̌n tapşurbalnan, şot'oğon isə balt'un. ");
INSERT INTO udi_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Metərluğen, ǐvel çadıra taşat'an Gerşoni nəsiləxun bakalt'oğoy əş mo bakale, şot'oğonal bitot'in běyinš Aaroni ğar İt'amari kiin oq'a əşp'alt'un». ");
INSERT INTO udi_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Merarin nəsiləxun bakala işq'arxoval içoğoy ailoğo q'a əsilə görə siyəyinə haq'a. ");
INSERT INTO udi_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Siyəyinə otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes bakala işq'arxoq'an haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ǐvel çadıri ganu badalbat'an Merarin nəsiləxun bakalt'oğon me şeyurxo taşalt'un: çadıri çərçivoğo, peşt'uvanxo, sütünxo q'a şot'oğoy laxala ganxo, ");
INSERT INTO udi_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","çadıri məəlin sütünxo q'a şot'oğoy laxala ganxo, mixçoğo, kəndürxo saal bütüm lazım bakala ət't'əcxo q'a əslaatxo. Hər amdara cöy-cöy iz biq'ala əşlə ak'est'a. ");
INSERT INTO udi_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Metərluğen, ǐvel çadıra taşat'an Merarin nəsiləxun bakalt'oğoy əş mo bakale, şot'oğonal bitot'in běyinš Aaroni ğar İt'amari kiin oq'a əşp'alt'un». ");
INSERT INTO udi_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Hametər, Moiseyen, Aaronen saal israilluğoy boşt'an c'ək'eśi ağsaq'q'alxon K'ohat'i nəsiləxun bakala işq'arxo içoğoy ailoğo q'a əsilə görə siyəyinət'un haq'i. ");
INSERT INTO udi_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes bakala, ");
INSERT INTO udi_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","içoğoy əsilə görə siyəyinə haq'eśi işq'arxoy say 2 750 taney. ");
INSERT INTO udi_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Mo K'ohat'i nəsiləxun ǐvel çadıra q'ulluğbi köməybes bakala bito işq'arxoy sayey. Moiseyen Q'ončuğon içu pi k'inək'e Aaronaxun sagala şot'oğo siyəyinə haq'i. ");
INSERT INTO udi_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gerşoni nəsiləxun bakala işq'arxoval içoğoy ailoğo q'a əsilə görə siyəyinət'un haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes bakala, ");
INSERT INTO udi_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","içoğoy əsilə görə siyəyinə haq'eśi işq'arxoy say 2 630 taney. ");
INSERT INTO udi_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Mo Gerşoni nəsiləxun ǐvel çadıra q'ulluğbi köməybes bakala bito işq'arxoy sayey. Moiseyen Q'ončuğon içu pi k'inək'e Aaronaxun sagala şot'oğo siyəyinə haq'i. ");
INSERT INTO udi_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merarin nəsiləxun bakala işq'arxoval içoğoy ailoğo q'a əsilə görə siyəyinət'un haq'eśi. ");
INSERT INTO udi_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes bakala, ");
INSERT INTO udi_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","içoğoy əsilə görə siyəyinə haq'eśi işq'arxoy say 3 200 taney. ");
INSERT INTO udi_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Mo Merarin nəsiləxun ǐvel çadıra q'ulluğbi köməybes bakala bito işq'arxoy sayey. Q'ončuğon Moiseya pi k'inək'əl Moiseyen q'a Aaronen şot'oğo siyəyinət'un haq'i. ");
INSERT INTO udi_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Metərluğen, Moiseyen, Aaronen saal israilluğoy boşt'an c'ək'eśi ağsaq'q'alxon bütüm leviğo içoğoy ailoğo q'a əsilə görə siyəyinət'un haq'i. ");
INSERT INTO udi_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Siyəyinə haq'eśi otuz yəşəxun əlli yəşəl śirik', ǐvel çadıra q'ulluğbi köməybes q'a yük taşes bakala ");
INSERT INTO udi_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","işq'arxoy say bito sagala 8 580 taney. ");
INSERT INTO udi_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mot'oğoy bitot'uval Q'ončuğon Moiseya pi k'inək' içoğoy əşlə ak'est'undi, hərt'in iz taşala şeya avaney. Şorox Q'ončuğon Moiseya pi k'inək't'un siyəyinə haq'eśey. ");
INSERT INTO udi_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«İsrailluğo əmirba ki, içoğoy arane c'ovakala t'ole azar bakalorox, içoğost'a p'i taysun nəəl yaroğon xe c'epsun bakalorox, içoğoy kul meyidə laft'i murdarlayinşakiyorox nu bakalane. Şorox pak bakamin və̌xun ə̌xil mandalat'un. ");
INSERT INTO udi_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Metər bakala çuresa işq'ari, çuresa çuğoy ef çurk'ala ganuxun tura bot'anan. Şot'oğon ef çurk'ala ganu nu murdarlayinşalat'un. Şot'o görə ki, Zuval ef aranezu». ");
INSERT INTO udi_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","İsrailluğon hametərəl bit'un. Şot'oğon Q'ončuğon Moiseya pi k'inək' metər amdarxo pak bakamin içoğoy çurk'ala ganuxun ə̌xilt'un bsay. ");
INSERT INTO udi_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«İsrailluğo upa: \"Əgər sunt'in - çuresa işq'ar, çuresa çuux - t'iyə̌mint'u ziyan tast'unen Q'ončuğoy laxi k'anunaxun c'eri günax əşp'est'ayin, me amdar taxsırkəre. ");
INSERT INTO udi_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Barta şot'in iz günaxa ozane ext'i qo paye sunt'uval iz loxol laxi laft'i ziyana ödəyinşeq'an. ");
INSERT INTO udi_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ama əgər ziyan zapi amdar p'urenesa, zərələ ödəyinşbseynak' q'erəz ı̌ša q'oomal butet'uxsa, t'e vədə zapi zərələ běyinša tast'unen Q'ončuğo ödəyinşinan baksa. Mot'o günaxa os'k'ala q'urbanluğ eğelaxun sagala běyinšeynak' eçanan. ");
INSERT INTO udi_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","İsrailluğon běyinšeynak' eçala bütüm ı̌vel payurxo şot'aye baksa. ");
INSERT INTO udi_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Běyinšeynak' eçeriyorox bito běyinšine baksa, şot'o tadiyorox şot'ost'al manest'a\"». ");
INSERT INTO udi_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«İsrailluğo upa: \"Əgər sa çuğon günax əşp'est'i iz işq'ara xəyanətbenesa, ");
INSERT INTO udi_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ama nə iz işq'aren, nə t'iyə̌mint'in şot'ay q'erəzt'uxun baksuna iz piin ak'itenesa, me çuux p'urumal günaxa baft'ine baksa. ");
INSERT INTO udi_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ama əgər sa çuğon şuk'k'alaxun ı̌šaluğbi tenesa, ama iz işq'aren q'ısq'ancluğbi p'urumal şot'oxun şüpələyinşebaksasa, t'e vədə barta günaxa əşp'est'it'ayal, nu əşp'est'it'ayal ");
INSERT INTO udi_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","işq'aren çuğo běyinši t'ǒğǒlq'an eçeri. Şot'in çuğoy s'iyal běyinšeynak' efin vis' payaxun sa paye hama xari eşt'unen taxıli pay eçalane. Me xarin loxol nə c'əyin, nəəl ladan maq'an lapi, şot'aynak' ki, mo q'ısq'ancluği q'a xəyanəti ç̌oyel c'eysuna ak'est'ala paye. ");
INSERT INTO udi_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Běyinšen isə me çuğo Q'ončuğoy běšq'an eçeri. ");
INSERT INTO udi_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Barta şot'in sa saxsi q'ave boş ı̌vel xe bapi oşa t'iya ı̌vel çadıraxun ext'i k'ulq'an gərbi. ");
INSERT INTO udi_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Běyinšen çuğo Q'ončuğoy běš çurdest'i şot'ay popa śarpeq'an, oşa q'ısq'ancluği q'a xəyanəti ç̌oyel c'eysuna ak'est'ala taxıli paya iz kiyelq'an tadi. Me vədine běyinši kiyel q'arğiş śipest'ala k'ul gərbi xe bakalane. ");
INSERT INTO udi_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Barta běyinšen çuğo me şərtenq'an q'arğişbi: əgər hun xəyanətbitenusa, təmiz mandi vi işq'araxun başq'a şuk'k'alaxun ı̌šaluğbitenusa, barta me q'arğiş śipest'ala xenen va zərəl maq'an tadi. ");
INSERT INTO udi_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ama əgər hun işq'ara baksunen q'erəz işq'araxun ı̌šaluğbi günax əşp'est'enusa ");
INSERT INTO udi_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","- me əyitəxun oşa běyinšen çuğo q'arğişbeq'an - barta vi əyel saksunen q'a əylə nu manst'unen Q'ončuğoy lənəti vi bel barst'una azuk'enal ak'eq'an. ");
INSERT INTO udi_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Barta me q'arğiş śipest'ala xe vi boş taśi vi tapana əyel sakala q'a əylə nu mandes bakalaq'an bi. Çuğon isə me əyitmoğoxun oşa \"ammen, haketərəl beq'an!\" peq'an. ");
INSERT INTO udi_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Běyinšen me q'arğişa śampi oşa me śama t'e k'ul gərbi xene boş os'k'i taşalane. ");
INSERT INTO udi_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Běyinšen me xena çuğo ǔğěst'ale, me q'arğiş śipest'ala xeyal çuğoy boş taśi şot'aynak' azar eçale. ");
INSERT INTO udi_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Metərluğen, běyinšen q'ısq'ancluğa görə eçeri taxıli paya çuğoy kiyelxun ext'i şot'o alabi Q'ončuğoynak' baksuna ak'est'ale. Oşa q'urban eçala gane t'ǒğǒl hari ");
INSERT INTO udi_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","t'e payaxun sa mə̌xə xarina ext'i şot'ay loxol bok'osp'ale. Me bok'osp'akala sa mə̌xə xarinen bütüm me paye Q'ončuğoynak' baksuna ak'est'ale. Me vədine běyinšen həzirbi xenal çuğo ǔğěst'ale. ");
INSERT INTO udi_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Çuğon xena ǔğə̌le. Ǔğit'uxun oşal əgər me çuğon həgigiyal günax əşp'est'i q'erəzt'uxun ı̌šaluğbenesa, t'e vədə me q'arğiş śipest'ala xe şot'ay boş taśi şot'aynak' azar eçale. Şo nə əylə mandes, nə eçes tene bakal. Metərluğenal Q'ončuğon şot'oxun İz ç̌oya tarast'una dirist' azuk'en ak'ale. ");
INSERT INTO udi_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ama əgər çuğon günax əşp'est'itenesa, əgər şo təmizesa, t'e vədə me xenen şot'o hik'k'al tene bal. Bütümt'in şot'ay taxsırsuz baksuna ak'ale, şot'inal əyel eçes bakale. ");
INSERT INTO udi_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Mo sa işq'ar iz çuğoxun şot'in günax əşp'est'iyal bakayin, nu əşp'est'iyal bakayin, q'ısq'ancluğbi şüpələyinşakat'an əməlbseynak' bakala k'anune. Barta běyinšen metər çuğo Q'ončuğoy běš çurdest'i hər şeya me laxi k'anuna görə beq'an. ");
INSERT INTO udi_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Çuğoy işq'ar me əşləst'a taxsırsuze, sal sa cazal zap'k'ala tene, çuğon iz əşp'est'i günaxi cazina için zap'k'ale». ");
INSERT INTO udi_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«İsrailluğo metər upa: \"Əgər sa işq'aren nəəl sa çuğon içu Buxačuğo həsrbi, Şot'aynak' sa nəzir baksunane əyit tast'asa, ");
INSERT INTO udi_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","t'e vədə barta me amdaren nə fi, nə q'erəz finağoybala ǔğǔn, nə fine oq'oy, nəəl q'erəz oq'oy iz ǰomo maq'an duği, lap t'ule xenal maq'an ǔği. Şot'in nə t'ula içu, nəəl şot'oxun düzbaki kişmişal nu ukalane. ");
INSERT INTO udi_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","İçoğo Q'ončuğonəzir bala vədine şot'oğon c'ap'en tadala me meyvin hik'k'alaxun nu ukalat'un. Mo lap t'ule s'ana q'a qǒləl ayide. ");
INSERT INTO udi_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","İçoğo Q'ončuğoynak'nəzirbala vədə çark'amin şot'oğon içoğoy popa nu k'as'k'alat'un. Me vədine şorox Q'ončuğoy baksunen ı̌velt'un hesabbaksa, barta içoğoy popa boxoybeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Me vədine şorox meyidəl maq'at'un ı̌ša biti. ");
INSERT INTO udi_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Lap içoğoy bava nəəl nana, xunçi nəəl viçiyal biyayin, şot'oğo görə içoğoy ı̌vel baksuna ak'est'ala popa nu murdarlayinşalat'un. Axıri me popen içoğoy Buxačuğo həsr baksunane ak'est'a. ");
INSERT INTO udi_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","İçoğo Q'ončuğonəzirbala me vədə çark'amin, şorox Q'ončuğoye. ");
INSERT INTO udi_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Əgər me amdari t'ǒğǒl soğo bürdən biyayin, metərluğenal şot'ay nəzir baksuna ak'est'ala popa murdarlayinşayin, t'e vədə barta şot'in vǔğ ğinaxun oşa iz popa tumexun q'açibest'eq'an. Me vǔğ ği meyidə ı̌ša bist'axun oşa p'urum pak baksuni vaxt'e. ");
INSERT INTO udi_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Muğumci ğine isə ı̌vel çadıri bağala gala hari běyinša p'ə̌ giyər nəəl p'ə̌ göyərçinq'an tadi. ");
INSERT INTO udi_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Běyinšen şot'oğoy sunt'u günaxxo os'kseynak' bakala q'urban k'inək', t'e sunt'u isə bok'ospsuni q'urban k'inək' šampeq'an ki, şot'oğoy p'iyen me amdari meyidi t'ǒğǒl ı̌ša bist'uni murdarlayinşaksuna os'k'i taşereq'an. Hat'e ği şot'ay pop p'urum ı̌vel hesabbakale, ");
INSERT INTO udi_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","şot'inal taxsıra os'k'ala q'urban k'inək' sa usenin ərkəy q'uzi šampi içu p'urum Q'ončuğohəsrbes bakale. Ama mot'oxun běš içu nəzir bi ğimxo hesabtenebakal, şot'aynak' ki şot'in içu murdarlayinşebi. ");
INSERT INTO udi_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Amdari nəzir baksuni vaxt' çark'at'an, me q'aydoğoq'an əməlbi. Barta şot'o ǐvel çadıri bağala galaq'at'un eçeri. ");
INSERT INTO udi_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Barta şot'in t'iya Q'ončuğoynak' bok'ospsuni q'urban k'inək' salamat sa usenin ərkəy q'uzi, günaxxo os'kseynak' bakala q'urban k'inək' salamat sa usenin dişi q'uzi saal serluği q'urban k'inək' sa salamat q'oçq'an eçeri. ");
INSERT INTO udi_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Zənbili boş xuri berxeśi arumi xarinaxun zeytuni c'əyinen šareśi ə̌yinsuz k'ok'alxo q'a iz loxol c'əyin lə̌ə̌mdi k'ok'alxoval eçereq'an. Taxıli payurxo q'a śipseynak' bakala payurxo eşt'unal eyexun maq'an c'evk'i. ");
INSERT INTO udi_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Běyinšen isə mot'oğo Q'ončuğoy běš eçale, günaxxo os'kseynak' bakala q'urbana q'a bok'ospsuni q'urbanal šamk'ale. ");
INSERT INTO udi_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Oşa şot'in serluği q'urbana šampi taxıli payaxun q'a śipseynak' bakala payurxoxun sagala Q'ončuğoynak' eçeri bok'osp'ale. Şot'in ə̌yinsuz k'ok'alxo bakala zənbiləl Q'ončuğoynak' pay k'inək' eçale. ");
INSERT INTO udi_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Mot'oxun oşa içu Q'ončuğoynak'nəzir bi amdaren ı̌vel çadıri bağala gane běš iz popa tumexun q'açibi şot'o serluği q'urbani oq'a bok'ala aruğoq'an boseri. ");
INSERT INTO udi_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","İçu nəzir bi amdaren iz popa q'açibit'uxun oşa, barta běyinšen ərkəy eğelin ap'esp'i běšin buda saal zənbiləxun c'əyinen šareśi ə̌yinsuz sa k'ok'ala q'a c'əyin lə̌ə̌mdi sa k'ok'ala ext'i mot'oğo bitova t'e amdari kiyelq'an tadi. ");
INSERT INTO udi_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Běyinšen mot'oğoy sa pay baksuna ak'est'eynak' Q'ončuğoy běš alabalane. Me ı̌vel payal Q'ončuğoy běš alabaki q'urbani döşe yeq'axun sagala běyinši bakalane. Mot'oxun oşa içu nəzir bi amdaren fi ǔğěs banekon. ");
INSERT INTO udi_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Metərluğen, içu nəzir bi amdaren Q'ončuğoynak' me payurxo eçalane. Ama izi imkan bakalt'in mot'oxun avuzinal k'ənesa eçes banekon. Barta içu Q'ončuğonəzir balt'in izi əyit tadit'oğoy bitova əməl beq'an\"». ");
INSERT INTO udi_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Aarona q'a iz ğarmoğo metər upa: \"İsrailluğo me əyitmoğon xeyir-bərəkət tadalanan: ");
INSERT INTO udi_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Q'ončuğon va xeyir-bərəkətq'an tadi, va q'orişeq'an! ");
INSERT INTO udi_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Hun İz ük'e bask'avax, Şot'inal vaynak' ük' bok'osp'ane! ");
INSERT INTO udi_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Barta Şot'in İz ç̌oya vaxun maq'an taradi, vaynak' həmişə serluğq'an eçeri! ");
INSERT INTO udi_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Aaronen q'a iz ğarmoğon Bez s'iya israilluğoynak' metər pi duğalt'un, Zuval şot'oğoxun Bezi xeyir-bərəkətə kam tezbal\"». ");
INSERT INTO udi_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moiseyen ı̌vel çadıra laxit'uxun oşa şot'o içu saal iz boş bakala bütüm şeymoğo ı̌velbseynak' şot'oğo c'əyine lə̌ə̌mdi. Q'urban eçala ganu q'a şot'ay bütüm ət't'əcxoval c'əyin lə̌ə̌mdi ı̌velebi. ");
INSERT INTO udi_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","İsrailluğoxun c'ək'eśi kalat'oğonal - içoğoy tayfoğo q'a əsilə görə c'ək'eśi şot'oğo siyəyinə haq'it'oğon - Q'ončuğoynak' payt'un eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Şot'oğon ǔq dənə iz loxolxun but' araba saal p'as's'e öküzt'un Q'ončuğoynak' pay eçeri: öküzxo hər tayfin s'iyen, araboğo isə hər p'ə̌ tayfin s'iyen. Mot'oğo bitova ı̌vel çadıri běšt'un eçeri laxi. ");
INSERT INTO udi_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Me paya kot'oğoxun q'abulbi leviğoy arane içoğoy bala əşlə görə cöyba ki, ı̌vel çadıra q'ulluğbat'an kot'oğo əşp'est'eq'at'un». ");
INSERT INTO udi_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moiseyenal araboğo q'a öküzxo ext'i leviğo tanedi. ");
INSERT INTO udi_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gerşoni nəsiləxun bakalt'oğon içoğoy əşlə biq'seynak' şot'oğo p'ə̌ araba q'a bip' öküz, ");
INSERT INTO udi_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Merarin nəsiləxun bakalt'oğo isə bip' araba q'a muğ öküze tadi. Me amdarxonal bitot'in běyinš Aaroni ğar İt'amari kiin oq'at'un əşbsay. ");
INSERT INTO udi_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ama K'ohat'i nəsiləxun bakalt'oğo Moiseyen me payaxun hik'k'al tene tadi, şot'o görə ki, şot'oğoy əş ən ı̌vel şeymoğo taşt'uney. Me şeymoğo isə içoğoy ə̌mnəbel taşalat'uniy. ");
INSERT INTO udi_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Moiseyen q'urban eçala ganu ı̌velbseynak' şot'o c'əyin lə̌ə̌mdit'uxun oşa israilluğoy boşt'an c'ək'eśi kalat'oğon t'e gane Q'ončuğoy baksuna ak'est'eynak' q'urbanxot'un eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Şot'aynak' ki, Q'ončuğon Moiseya peney: «Barta q'urban eçala gane ı̌vel baksuna ak'est'eynak' hər ği kalat'oğoxun sunt'in t'iya iz payaq'an eçeri». ");
INSERT INTO udi_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Süft'ə İuday tayfinaxun kalo c'ək'eśi Amminadavi ğar Naxşonene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Amminadavi ğar Naxşoni eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","P'ə̌mci ğine İssak'ari tayfinaxun kalo c'ək'eśi Śuari ğar Net'anelene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Śuari ğar Net'aneli eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Xibimci ğine Zevuluni tayfinaxun kalo c'ək'eśi Xeloni ğar Eliavene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey), ");
INSERT INTO udi_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Xeloni ğar Eliaven eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Bip'imci ğine Ruveni tayfinaxun kalo c'ək'eśi Şedeuri ğar Elisurene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Şedeuri ğar Elisuren eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Qomci ğine Simeoni tayfinaxun kalo c'ək'eśi Śurişaddayi ğar Şelumielene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Śurişaddayi ğar Şelumielen eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ǔqǔmci ğine Gade tayfinaxun kalo c'ək'eśi Deueli ğar Elyasafene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Deueli ğar Elyasafen eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Vǔğǔmci ğine Efraimi tayfinaxun kalo c'ək'eśi Ammihudi ğar Elişamanene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Ammihudi ğar Elişaman eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Muğumci ğine Menaşşeni tayfinaxun kalo c'ək'eśi P'edahśuri ğar Gamlielene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo P'edahśuri ğar Gamlielen eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Vuyumci ğine Binyamini tayfinaxun kalo c'ək'eśi Gidoni ğar Avidanene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Gidoni ğar Avidanen eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Vis'imci ğine Dane tayfinaxun kalo c'ək'eśi Ammişaddayi ğar Axiezerene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Ammişaddayi ğar Axiezeren eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Sas's'emci ğine Aşeri tayfinaxun kalo c'ək'eśi Ok'rani ğar P'agielene payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Ok'rani ğar P'agielen eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","P'as's'emci ğine Naft'alin tayfinaxun kalo c'ək'eśi Enani ğar Axirane payurxo eçeri. ");
INSERT INTO udi_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Şot'in eçeri payurxo moroxey: ı̌vel gane şek'elen sabaç̌ otuz şek'el bı̌hiluğen bakala sa gümüşi sini q'a yetmiş şek'el bı̌hiluğen bakala sa gümüşi ləən (mot'oğoy p'ǒğə̌l taxıli payeynak' bakala zeytuni c'əyin lapi arumi xarinen buyey); ");
INSERT INTO udi_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","vis' şek'el bı̌hiluğen iz boş bok'ospseynak' bakala adeğala oyurxon buy sa q'ızıli kasa; ");
INSERT INTO udi_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","bok'ospsuni q'urbaneynak' sa arak', sa dənə q'oç eğel saal sa dənə sa usenin ərkəy q'uzi; ");
INSERT INTO udi_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","günaxxo os'kseynak' bakala q'urbaneynak' sa ərkəy keçi; ");
INSERT INTO udi_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","serluği q'urban eşt'eynak' p'ə̌ dənə öküz, qo dənə q'oç eğel, qo dənə ərkəy keçi saal qo dənə sa usenin ərkəy q'uzi. Mo Enani ğar Axiran eçeri payurxoney. ");
INSERT INTO udi_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Metərluğen, q'urban eçala ganu lə̌ə̌mdit'uxun oşa şot'ay ı̌vel baksuna ak'est'eynak' israilluğoy boşt'an c'ək'eśi kalat'oğon eçeri payurxo moroxey: p'as's'e gümüşi sini, pas's'e gümüşi ləən saal p'as's'e q'ızıli kasa. ");
INSERT INTO udi_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Hər gümüşi sinin bı̌hiluğ ı̌vel gala bakala şek'ela görə sabaç̌ otuz şek'el, hər gümüşi ləəni bı̌hiluğal yetmiş şek'eley. Bito ləənxoy q'a siniğoy bı̌hiluğ sagala isə p'ə̌ hazar bip'baç̌ şek'eley. ");
INSERT INTO udi_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Hər soğo ı̌vel gane şek'elen vis' şek'el bakala qızıli kasoğoy bı̌hiluğ isə bito sagala sabaç̌ q'a şek'eley (kasoox bok'ospseynak' bakala şaat' adeğala oyurxon buyey). ");
INSERT INTO udi_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Taxıli payaxun sagala eçala bok'ospsuni q'urbaneynak' p'as's'e dənə arak', p'as's'e dənə q'oç eğel, p'as's'e dənə sa usenin ərkəy q'uzi saal günaxxo os'kseynak' bakala q'urbaneynak' p'as's'e dənə ərkəy keçiyal eçeret'uniy. ");
INSERT INTO udi_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Serluği q'urbaneynak' isə bito sagala saq'o bip' dənə öküz, altmış q'oç eğel, altmış ərkəy keçi saal altmış dənə sa usenin ərkəy q'uzit'un eçerey. Q'urban eçala ganu lə̌ə̌mdit'uxun oşa şot'ay ı̌vel baksuna ak'est'eynak' eçeri payurxo moroxey. ");
INSERT INTO udi_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Moisey ı̌vel çadıra Q'ončuğoxun exlətpseynak' bağat'an, içuxun əyitk'ala səs irəziluği sanduği loxol bakala bağışlayinşbsuni q'apağaxune eysay. Me səs q'apaği loxol bakala p'ə̌ angeli aranexun, Q'ončuğoy bakala ganuxune eysay. Q'ončuğon Moiseyaxun metəre exlətpsay. ");
INSERT INTO udi_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Aarona metər upa: \"Pisosi vǔğ çirağa t'etər laxa ki, iz běšq'at'un işiğ saki\"». ");
INSERT INTO udi_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaronenal Q'ončuğon Moiseya əmirbi k'inək' bine: çirağxo pisosi loxol t'etəre laxi ki, şot'oğon běšt'un işiğbsay. ");
INSERT INTO udi_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Pisos isə dirist' q'ızılaxune t'ap'eśi düzbakey, iz turaxun burqi iz loxol bakala varde t'up'ulxol śirik'. Şot'o Q'ončuğon Moiseya ak'est'i k'inək't'un düzbey. ");
INSERT INTO udi_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«İsrailluğoy aranexun leviğo cöybi şot'oğo pakba. ");
INSERT INTO udi_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Şot'oğoy pak bakseynak' metər bsune lazım: pakbala xena içoğoy loxol çiləyinşa, barta içoğoy bel q'a loxol bakala popal xampi, içoğoy paltaral os'k'eq'at'un. Mot'oxun oşa şorox pak hesabbakalt'un. ");
INSERT INTO udi_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Mot'oxun oşa barta c'əyin lapi arumi xarinaxun bakala taxıli paya q'a şot'oxun sagala q'urban eçala arak'aq'at'un ext'i, hun isə günaxxo os'kseynak' šameğala arak'a ext'a. ");
INSERT INTO udi_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Leviğo ı̌vel çadıri běš eçeri, bütüm israilluğoval girba. ");
INSERT INTO udi_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Leviğo miya eçerit'uxun oşa israilluğon içoğoy kulmoğo şot'oğoy loxol laxalat'un, ");
INSERT INTO udi_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaronenal şot'oğo israilluğoxun bakala c'ək'eśi sa pay k'inək' Q'ončuğohəsrbalane ki, Şot'o q'ulluğbes bakat'un. ");
INSERT INTO udi_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Leviğon içoğoy kulmoğo arak'xoy loxol laxit'uxun oşa me arak'xoy soğo bok'ospsuni q'urban, t'e soğo isə günaxxo os'kseynak' bakala q'urban k'inək' içoğoy s'iyen Q'ončuğoynak' šameğalane. Me q'urbanxo eşt'unenal Q'ončuğo q'ulluğbseynak' c'ək'eśi leviyox pakbaki bakalt'un. ");
INSERT INTO udi_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Barta leviyox Aaroni q'a iz ğarmoğoy běš çurpi c'ək'eśi sa pay k'inək' Q'ončuğoq'at'unhəsrbaki. ");
INSERT INTO udi_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Metər, hun şot'oğo bütüm israilluğoxun c'ək'p'i Bezi balnu. ");
INSERT INTO udi_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Hun leviğo c'ək'eśi sa pay k'inək' Q'ončuğoynak' eçeri şot'oğo pakbit'uxun oşa şot'oğon ı̌vel çadıra q'ulluğbes bat'unkon. ");
INSERT INTO udi_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Şorox israilluğoy boşt'an Zaynak' c'ək'eśiyoroxe. Zu şot'oğo israilluğoy boş tapanexun c'eri k'ə süft'in ğar əyel nəəl süft'in ərkəy bala bunesa, şot'oğoy galaz ext'e. ");
INSERT INTO udi_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","İsrailluğoy bito süft'in ğar əyluxal, içoğoy heyvanxoy süft'in ərkəy baloxal Bezine. Zu şot'oğo Misirə bito süft'in nanaxun baki ğarmoğo əfçibala ğine Zaynak' c'ək'p'i Beziz bi. ");
INSERT INTO udi_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","İsəəl, bito israilluğoy süft'in ğar əyloğoy gala leviğoz Zaynak' exst'a. ");
INSERT INTO udi_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Şot'oğo israilluğoy boşt'an c'ək'p'i Aarona q'a iz ğarmoğoz tadi ki, ı̌vel çadıra bito israilluğoy gala q'ulluğbi şot'oğoy günaxxo os'k'es bakat'un. Şot'oğoy ı̌vel gala q'ulluğbsunal t'iya ı̌šalayinşakala israillun bel bələ nu eysuni toy bakale». ");
INSERT INTO udi_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Metərluğen, Moiseyen, Aaronen saal israilluğon Q'ončuğon Moiseya leviğoy barada pi əmirbit'oğo bitova bit'un. ");
INSERT INTO udi_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leviyox içoğo təmizbi paltaral os'ksunen pakt'unbaki, Aaronenal şot'oğo c'ək'eśi sa pay k'inək' Q'ončuğonehəsrbi. Leviğoy pak bakseynak' Q'ončuğoynak' q'ulluğbsuni toya ödəyinşala q'urbanxoval šameśi. ");
INSERT INTO udi_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Mot'oxun oşa leviyox Aaroni q'a iz ğarmoğoy kiin oq'a ı̌vel çadıri əşurxost'a köməybsat'un burqi. Q'ončuğon Moiseya leviğoy barada əmirbi piyoroxal bito baneki. ");
INSERT INTO udi_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Mone, leviğon me q'aydina əməlbalat'un: hər saq'o qo yəşə p'ap'ala levilu ı̌vel çadıri əşurxost'a köməybi q'ulluğbsa burqalane, ");
INSERT INTO udi_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","əlli yəşə p'ap'at'anal iz q'ulluğa efi ene t'iya nu köməybalane. ");
INSERT INTO udi_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Şot'in t'iya içoğoy q'ulluği vədə nu çark'i t'iyə̌mi viçimoğo köməybes banekon, ama için ene nu q'ulluğbalane. Mo ı̌vel çadıra bakala əşurxost'a leviğoy q'ulluğbsuni q'aydane». ");
INSERT INTO udi_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","İsrailluğoy Misirəxun c'eysun p'ə̌mci usena bağat'an, t'e usenin samci xaşe Q'ončuğon Moiseya Sinay ams'i oç̌ala pine: ");
INSERT INTO udi_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Barta israilluğon C'ovaksuni axsibaya Bez pi vədineq'at'un c'ovakest'i. ");
INSERT INTO udi_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Şot'o Bez pi ğine - me xaşe bip'es's'emci ğine, běğ batk'at'an c'ovakest'a burqanan. Axsibaya c'ovakest'at'an Bez laxi bito q'aydoğo q'a k'anunxo əməlbanan». ");
INSERT INTO udi_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Metərluğen, Moiseyen israilluğo C'ovaksuni axsibayi barada bitova pine, ");
INSERT INTO udi_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","şot'oğonal samci xaşe bip'es's'emci ğine běğ batk'at'an Sinay ams'i oç̌ala me axsibaya c'ovakest'undi. İsrailluğon bitova Q'ončuğon Moiseya pi k'inək't'un bi. ");
INSERT INTO udi_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ama bəzi amdarxo me ği içoğoy kul p'uri amdara lafst'una görə pak tet'un hesabbaksay, şot'o görəl me axsibaya c'ovakest'es tet'un baki. Şorox hat'e ği Moiseyi q'a Aaroni t'ǒğǒl hari ");
INSERT INTO udi_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","pit'un: «Beşi kul meyidə lafst'una görə yan pak teyan hesabbaksa. İsə yan Q'ončuğon laxi ğine bito israilluğoxun sagala Şot'aynak' q'urban eçes teyan bakal?» ");
INSERT INTO udi_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moiseyen şot'oğo pine: «Bartanan běğen, Q'ončuğon me barada k'ə nex». ");
INSERT INTO udi_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Q'ončuğonal Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Əgər axsibayi ğine efi nəəl və̌xun oşa bakalt'oğoy boşt'an şinesa iz kula meyidə duğsunen içu murdar bine baksasa, nəəl ki, me ğine yaq'a bakalane baksasa, şot'in hələ me axsibaya c'ovakest'es banekon. ");
INSERT INTO udi_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Barta t'e amdaren me axsibaya p'ə̌mci xaşe bip'es's'emci ğine běğ batk'at'anq'an c'ovakest'i. Q'urbanluğ q'uzin yeq'a ə̌yinsuz šumen q'a ağu oyurxon kəyi ");
INSERT INTO udi_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","savaxt'ineynak' şot'oxun hik'k'al maq'an efi. T'e q'urbanluğ heyvani ǔq'ěnxoxunal sayco nu xoxbakalane. T'e amdaren C'ovaksuni axsibayi bito q'aydoğo əməlbalane. ");
INSERT INTO udi_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ama əgər sunt'in pak baksun nəəl yaq'a təə, iz azuk'i arane baksun me axsibaya nu c'ovakest'ayin, t'e amdari tura azuk'i aranexun bot'anan. Şot'in Q'ončuğon laxi ğine Şot'aynak' q'urban nu eşt'una görə iz cazina zap'k'ale. ");
INSERT INTO udi_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Əgər ef arane yəşəyinşala sa q'əribenal me axsibaya c'ovakest'un çuresasa, barta şot'in me C'ovaksuni axsibayi bito q'aydoğo q'a k'anunxo əməlbeq'an. Və̌ynak'al, ef arane yəşəyinşala q'əribxoynak'al q'aydoox sane». ");
INSERT INTO udi_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ǐvel, yəni irəziluği çadıra laxit'uxun oşa, şot'ay loxol biyəsinəxun savaxt'inal śirik' bok'ala aruğo oşq'ardala sa asoye śiri. ");
INSERT INTO udi_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Mot'oxun oşal hametərey: ğenaxun çadıra bəc'ürk'ala asoy biyəsin arux k'inək'e baksay. ");
INSERT INTO udi_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Hər dəfəl asoy çadıri loxolxun ěqeğat'an israilluyox yaq'at'un bafst'ay. Eğala çurk'ala ganu isə asoy çurk'ala galat'un düzbsay. ");
INSERT INTO udi_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Şot'oğoy yaq'a bafst'unal, eğala çurk'ala ganu düzbsunal Q'ončuğon metəre ak'est'ay. Heq'ədər ki asoy çadıri loxole baksay, şorox içoğoy ganuxun tet'un galey. ");
INSERT INTO udi_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Asoy çadıri loxol boxoyal mandayin, israilluyox Q'ončuğoy əyitəxun nu c'eri içoğoy çurk'ala ganu tet'un badalbsay. ");
INSERT INTO udi_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Asoyi çadıri loxol sa hema ği çurk'ala vədəl baneksay. İsrailluyox isə Q'ončuğoy əyiten çurpi, Q'ončuğoy əyitenal yaq'at'un bafst'ay. ");
INSERT INTO udi_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Bəzi vədəmoğo asoy çadıri loxol saycə biyəsəxun savaxal śirik'e çurey, savaxt'an asoy ěqeğat'anal israilluyox yaq'at'un bafst'ay. Çuresa üşe, çuresa ğenaxun - asoy ěqeğat'an israilluyox yaq'at'un bafst'ay. ");
INSERT INTO udi_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","P'ə̌ ği, sa xaş nəəl lap sa usenq'an baki - heq'ədər ki asoy çadıri loxoleysa, israilluyox içoğoy çurk'ala ganuxun galtet'unney. T'e asoy ěqeğala k'inək' isə şorox yaq'at'un bafst'ay. ");
INSERT INTO udi_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Şot'oğo içoğoy çurk'ala ganu maya düzbsunal, hevaxt' yaq'a bafst'unal Q'ončuğon metəre ak'est'ay. Hametərəl, israilluğon Q'ončuğoy Moiseya pit'oğo bitova əməlt'unbsay. ");
INSERT INTO udi_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Çəküçen əşeśi gümüşəxun p'ə̌ dənə şeyp'ur düzba. Azuk'axun əyitk'at'an saal azuk'a xavarbi yaq'a baft'at'an şot'oğo farpi amdarxo girbalnu. ");
INSERT INTO udi_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","P'ə̌ şeyp'uri səs sunaxun eğat'an, barta dirist' azuk'q'an vi t'ǒğǒl ı̌vel çadıri běš gireśi. ");
INSERT INTO udi_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Şeyp'urxoy soğo fareğat'an isə vi t'ǒğǒl saycə israilluğoy tayfoğo görə c'ək'eśi kaloroxq'an gireśi. ");
INSERT INTO udi_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Şeyp'uri səs lap alloyaxun samci kərəm eğat'an, barta běğ c'eğalaç tərəf bakala dəst'ooxq'an yaq'a baft'i. ");
INSERT INTO udi_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Alloyaxun eğala şeyp'uri səsə p'ə̌mci kərəm ibakat'an, barta güney tərəf bakala dəst'ooxq'an yaq'a baft'i. Hametər, dəst'oox alloyaxun eğala şeyp'uri səsə ibakat'an yaq'a baft'alt'un. ");
INSERT INTO udi_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Camaataxun əyitpseynak' şot'oğo girbsun lazım bakat'anal şeyp'ura farpanan, ama yaq'a baft'at'an fareğala k'inək' ost'aar təə. ");
INSERT INTO udi_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Şeyp'urxo Aaroni nəsiləxun bakala běyinšxon fark'alat'un. Barta mo və̌ynak' nəsiləxun nəsilə c'ovakala həmişəluğ sa q'aydaq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Və̌n ef oç̌ala ef loxol eğala düşmənxoxun davina c'eğat'anal şeyp'ura farpanan. T'e vədə Q'ončuğon və̌x ibaki efi düşmənxoxun çark'est'ale. ");
INSERT INTO udi_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Efi mǔq ğimxo - axsibayxost'al, təzə xaşe c'eysuna c'ovakest'ala mərəkəyxost'al bok'ospsuni q'a serluği q'urbanxo eçat'an şeyp'ura farpanan. Barta mo Buxačuğon və̌x eyex efseynak'q'an baki. Ef Buxačux bakala Q'ončux Zuzu». ");
INSERT INTO udi_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","İsrailluğoy Misirəxun c'eysun p'ə̌mci usena bağat'an, t'e useni p'ə̌mci xaşe q'amci ğine asoy irəziluği çadıri loxolxun ěqeśi. ");
INSERT INTO udi_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","İsrailluyoxal Sinay ams'i oç̌alaxun c'eri yaq'at'un baft'i. Asoy hari P'aran uk'ala ams'i oç̌ala çurk'aminal şorox yaq't'un taśi. ");
INSERT INTO udi_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","İsrailluğoy Q'ončuğon Moiseya pi q'aydinen me yaq'a bafst'un samciney. ");
INSERT INTO udi_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Süft'ə İuday dəst'əne içoğo c'ək'p'est'ala nišana laxi yaq'a baft'i. Me dəst'in kalo Amminadavi ğar Naxşoney. ");
INSERT INTO udi_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","İssak'ari tayfin kalo Śuari ğar Net'aneleney. ");
INSERT INTO udi_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zevuluni tayfin kalo isə Xeloni ğar Eliavey. ");
INSERT INTO udi_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ǐvel çadıral tat'at'unpi. Gerşoni q'a Merarin nəsiləxun bakalt'oğonal t'e çadıra ext'it'un yaq'a baft'i. ");
INSERT INTO udi_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruveni dəst'əl içoğo c'ək'p'est'ala nišana laxi yaq'at'un baft'i. Me dəst'in kalo Şedeuri ğar Eliśurey. ");
INSERT INTO udi_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeoni tayfin kalo Śurişaddayi ğar Şelumieley. ");
INSERT INTO udi_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gade tayfin kalo isə Deueli ğar Elyasafey. ");
INSERT INTO udi_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","K'ohat'i nəsiləxun bakalt'oğonal ı̌vel şeymoğo ext'it'un yaq'a baft'i; şorox hari çurk'ala gala p'ap'amin ı̌vel çadır laxeğalaney. ");
INSERT INTO udi_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efraimi dəst'əl içoğo c'ək'p'est'ala nišana laxi yaq'at'un baft'i. Me dəst'in kalo Ammihudi ğar Elişamaney. ");
INSERT INTO udi_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Menaşşeni tayfin kalo P'edahśuri ğar Gamlieley. ");
INSERT INTO udi_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Binyamini tayfin kalo isə Gideoni ğar Avidaney. ");
INSERT INTO udi_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ən axırda Dane dəst'əne içoğo c'ək'p'est'ala nišana laxi yaq'a baft'i. Me dəst'in kalo Ammişaddayi ğar Axiezerey. ");
INSERT INTO udi_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aşeri tayfin kalo Ok'rani ğar P'agieley, ");
INSERT INTO udi_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naft'alin tayfin kalo isə Enani ğar Axiraney. ");
INSERT INTO udi_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Metərluğen, israilluğoy dəst'oox me q'aydinent'un yaq'a bafst'ay. ");
INSERT INTO udi_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moiseyen Xovava, iz q'ayinba midyanlu Reueli ğara pine: «Yan Q'ončuğon \"və̌x tadoz\" pi galayan yaq'a bafst'a. Eki yaxun tağen! Beş t'ǒğǒl hik'k'alaxun koruğ ten ak'al, axıri Q'ončuğon İsraila şaat'luğbsunane əyit tade». ");
INSERT INTO udi_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ama Xovaven şot'o pine: «Təə, tez tağal. Zu bez yurdnu, bez q'oom-ağrabin t'ǒğǒl tağoz». ");
INSERT INTO udi_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moiseyen pine: «Xaişezbsa, yaxun eki. Ams'i oç̌ala çurk'ala ganu maya düzbsunaxun vi bul c'enesa, yaynak' yaq' ak'est'al baka. ");
INSERT INTO udi_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Yaxun tağayin, Q'ončuğon yaynak' bala şaat'luğa vaxunal kamteyanbon». ");
INSERT INTO udi_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","İsrailluyox Q'ončuğoy buruğoxun c'eri xib ği yaq't'un taśi. Q'ončuğoy irəziluği sanduğa taşala leviyox běšt'un taysay, Q'ončuğonal şot'oğo üşe azuk'i çurk'ala ganune ak'est'ay. ");
INSERT INTO udi_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ğenaxun yaq'a baft'at'an isə Q'ončuğoy asoyal ěqeśi içoğoxune baksay. ");
INSERT INTO udi_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Şot'oğon sanduğa ext'i tağat'an Moiseyen nexey: «Ay Q'ončux, ěqeki! Barta Vi düşmənxo śareśeq'at'un, Va nifrətbalxo Vi běšt'an t'it'ereq'at'un!» ");
INSERT INTO udi_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sanduğa taşalorox çurk'at'an isə metəre nexey: «Ay hazarxon bakala israilluğoy Q'ončux, qaybaka!» ");
INSERT INTO udi_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Azuk'en içoğoy ak'ala çətinluğaxun şikəətbsane burqi, Q'ončuğonal mot'o ibakat'an İz əcuğ bəc'ük'eśi. Şot'in azuk' çurk'ala gala aruxe yaq'abi, şoval sa belxun baśi t'iyana bok'osp'i śinepi. ");
INSERT INTO udi_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Camaaten Moiseya şivanbi xoyinšebi, şot'inal Q'ončuğo k'alpi afırıpit'uxun oşa arux aneç̌i. ");
INSERT INTO udi_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","T'e gane s'iya T'averat'un laxi, şot'o görə ki, t'e gala Q'ončuğoy yaq'abi aruxe bok'i. ");
INSERT INTO udi_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Azuk'i arane Misirəxun içoğoxun sagala c'eri, q'erəz millətəxun bakaloroxal buney. Şot'oğon ukun c'ək'psa burqat'an israilluğonal şot'oğoxun barabar şikəətp'i ǒnepsat'un burqi: «Beş ük'en yeq'e çuresa! ");
INSERT INTO udi_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Misirə bakat'an yax nisyə çəli, k'ač'uli, yemiş, göyün, şik'lam, kenal tat'unst'ay. ");
INSERT INTO udi_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ama miya manninaxun başq'a hik'k'al at'eyanksa. Ene beş boşt'an c'eq'ene!» ");
INSERT INTO udi_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna iz ç̌oyexun həvici śiləne oşq'arst'ay, iz irəng isə nešusey. ");
INSERT INTO udi_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Amdarxon şot'o taśi girt'unbsay, oşa eçeri kiin ǰomok'ojen bert'unxsay nəəl toxmağen č'ak't'unney. Berxeśi mannina levet'a boxiyal, şot'oxun k'ok'al badiyal ukes baneksay. Şot'in zeytunu c'əyinen šareśi k'ok'ali tamane tast'ay. ");
INSERT INTO udi_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Üşe israilluğoy çurk'ala gala xo arśat'an me mannal şot'oxun barabar arest'ay. ");
INSERT INTO udi_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moiseyen amdarxoy içoğoy çadıra bağala gane běš şikəətbsun ǒnepsuna inebaki. Q'ončuğoy əcuğ bəc'ük'eśi, Moiseyal gelene beyköf baki. ");
INSERT INTO udi_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Şot'in Q'ončuğo pine: «Hun het'aynak'en me Vi k'ula koruğ tast'a, Vi piyes mani günaxa görəz pis ak'eśe? Het'u görən me azuk'a bez ə̌mnəbel laxi zaynak' yük be? ");
INSERT INTO udi_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Zaxune törəyinşake me azuk'? Şot'oğo me dünyəne zuz eçere? Vi əyit tadi oç̌ala şot'oğo het'aynak' zu taşalazu? Axıri het'aynak' şot'oğo mis'ik' əyel k'inək' t'iya bez q'ujel taşeri p'ap'esp'alazu? ");
INSERT INTO udi_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","İsə zu dirist' me azuk'eynak' yeq' mayin bə̌ğə̌baz? Bez t'ǒğǒl hari \"yan yeq' uksunyan çuresa\" uk'ala azuk'a k'ə coğab tadaz? ");
INSERT INTO udi_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ene batezaksa, me azuk'a yük bi bez ə̌mnəbel xorpsuna ene bez zor aytenesa! ");
INSERT INTO udi_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Əgər Hun hələl me əşlə za tapşurbalnusa, t'e vədə xoyinšezbsa, Vi piyes samalcəl bakayin şaat'luğ bə̌ğə̌bezusa, za besp'a ki, ene me koruğa ma ak'az!» ");
INSERT INTO udi_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Q'ončuğon Moiseya pine: «Azuk'i boşt'an hörmətlu saal kalo hesabbakala yetmiş ağsaq'q'ala girbi Bez t'ǒğǒl eça. Şot'oğo ı̌vel çadıri běš eçeri vi t'ǒğǒl çurdest'a. ");
INSERT INTO udi_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Zu śiri t'et'iya vaxun exlətp'oz. Vast'a bakala Urufaxun şot'oğoval tadoz ki, me azuk'a vi ə̌mnəbel taşt'unast'a va köməybat'un. Metərluğenal, me yükə tək zap'k'ala ten bakal. ");
INSERT INTO udi_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Azuk'a isə upa: \"Əyc'ineynak', efi yeq' ukala ğineynak' və̌x pakbanan. <Yeq'yan çuresa! Misirə yaynak' mot'oxun şaat'ey!> pi ǒnenanney. Mone, Q'ončuğon və̌x inebaki! Şot'in və̌x yeq' tadale, və̌nal boşşamin ukalnan! ");
INSERT INTO udi_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Və̌n sa ği, p'ə̌ ği, qo ği, vis' ği, q'a ği təə, ");
INSERT INTO udi_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","düz sa xaş, ef ǰomoxun baramin yeq' ukalnan! Şot'aynak' ki, ef arane bakala Q'ončuğo t'ǒǒxnanbi, ef bula alabi <het'aynak'yan Misirəxun c'eri> pi şikəətnanbi\"». ");
INSERT INTO udi_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moiseyen isə pine: «Miya bez t'ǒğǒl saycə ǔqbaç̌ hazar turin tağala işq'are bu, Hunal nexnu ki, kot'oğo sa xaş yeq' ukest'oz! ");
INSERT INTO udi_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Sürüğo bakala bütüm heyvanxo šamk'ayin, kot'oğo tene p'oyeğon! Dənizə bakala bütüm çəliğoval biq'ayin, kot'oğo bəstenebakon!» ");
INSERT INTO udi_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","T'e vədə Q'ončuğon Moiseya pine: «Q'ončuğoy kiyexun k'ə tene ayesa ki? İsə běğa Bez uk'alt'oğo hetərez bex p'ap'espsa!» ");
INSERT INTO udi_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moiseyen Q'ončuğoy əyitə azuk'a p'ap'esebi, azuk'i ağsaq'q'alxoxun yetmiş tana topbi çadıri běš çurdesedi. ");
INSERT INTO udi_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Q'ončuğonal asoyi boş śiri Moiseyaxun exlətebi. Şot'ost'a bakala Urufaxun t'e yetmiş ağsaq'q'alal tanedi. Şot'oğonal Urufen tadi əyitmoğon əyitpsat'un burqi. Q'ončuğon şot'oğoy İz c'ək'p'iyorox baksuna metər ak'est'it'uxun oşa ene tene əyitp'est'i. ");
INSERT INTO udi_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Siyəyinə haq'eśi t'e yetmiş ağsaq'q'ali boş Eldad saal Medad s'iyen p'ə̌ tane buy. Şorox çadıri běš tet'un taśey, şot'o görəl Uruf śiğat'an azuk'i çurk'ala galat'uniy. Ama Uruf şot'oğoy loxolal śire, şot'oğonal içoğoy bakala gala Urufen tadi əyitmoğon əyitpsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Sa cəyil t'it'eri Moiseya xavar tadi pine: «Urufen Eldada q'a Medada azuk'i çurk'ala gala əyitp'esest'a». ");
INSERT INTO udi_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Cəyilluğaxun Moiseyi köməyçi bakala Nune ğar Yeşuan pine: «Bez ağa Moisey, şot'oğo şip'ba!» ");
INSERT INTO udi_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moiseyen şot'o coğabe tadi: «Hun za görən metər nex? Ama Zu dirist' azuk'i xavareçal baksunaz çureğoy! Təki Q'ončuğon İz Urufaxun bütümt'u tadiniy!» ");
INSERT INTO udi_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moiseyal israilluğoy ağsaq'q'alxoxun sagala azuk'i çurk'ala galane qaybaki. ");
INSERT INTO udi_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Oşa Q'ončuğon dənizəxun eğala sa muşe yaq'abi. Me muşenal içuxun kala sa dəst'ə bildirçinxo eçeri azuk'i çurk'ala gane sa ğiluğ yaq'e hama bakala hərrəmine, p'ə̌ ə̌m hama boşuluğen śinepi. ");
INSERT INTO udi_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Dirist' t'e ği, t'e üşe saal əyc'indəri amdarxon c'eri bildirçint'un girbi. Ən mal girbalt'in vis' xomere girbi. T'e bildirçinxo eçeri azuk'i çurk'ala gane hərrəmine tak't'unpi. ");
INSERT INTO udi_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ama yeq'a hələ k'əc'p'i q'uc'tet'unpey, Q'ončuğoy əcuğ azuk'i loxol t'etəre bəc'ük'eśi ki, şot'oğoynak' dəhşətlu azare yaq'abi. ");
INSERT INTO udi_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","T'e gane s'iyal Qivrot'-Hattaavat'un laxi, şot'aynak' ki, t'iya içoğoy ük'en q'erəz ukun çureğalt'oğot'un oç̌alaxp'i. ");
INSERT INTO udi_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Amdarxo Qivrot'-Hattaavaxun c'eri Xaserot'a taśi t'iya çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moiseyen K'uş bölginəxun çuuxe haq'ey, Maryamen q'a Aaronenal mot'o görə t'ot'opsat'un burqi. ");
INSERT INTO udi_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Şot'oğon pit'un: «Saycə Moiseyene Q'ončuğoy əyitmoğo azuk'a p'ap'esp'e ki? Axıri yanal Q'ončuğoy əyitmoğo azuk'a peyan». Q'ončuğonal mot'o inebaki. ");
INSERT INTO udi_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moiseyen isə me dünyəne şuk'k'ali loxol alaxun oq'a běteneğoy. ");
INSERT INTO udi_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","T'e vədə Q'ončuğon Moiseya, Aarona saal Maryama pine: «Və̌n xiboval ı̌vel çadıra ekinan!» Şoroxal tat'unśi. ");
INSERT INTO udi_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Q'ončux ı̌vel çadıri bağala gala sa sütün k'inək' asoyi boş śiri Aarona q'a Maryama k'alepi. Şorox ı̌šalayinşakat'an ");
INSERT INTO udi_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Q'ončuğon pine: «İsə Bez əyitmoğo ibakanan! Ef çalxala xavareçalxoxun Zu şot'oğoynak' ak'eśi, İçoğoy nep'e boş baśiz Za çalxest'on. ");
INSERT INTO udi_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ama Moisey şot'oğoxun soğo tene! Şot'o dirist' Bez azuk'az tapşurbe! ");
INSERT INTO udi_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Şot'oxun sa dost' k'inək', hər şeya qayez əyite, Şot'inal Bez xojina aneksa. P'oy Bez c'ək'p'i k'ul bakala me Moiseyaxun t'ot'opsuna hetərnan ük' bi?» ");
INSERT INTO udi_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Q'ončuğoy şot'oğoy loxol gele əcuğone biq'i, Şo t'et'iin ə̌xilebaki. ");
INSERT INTO udi_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Asoy çadıri loxolxun ěqeśit'uxun oşa Maryami bədənə dirist' map'mas'i yaroğone haq'i. Aaronenal fırıpi běneği ki, Maryami bədənen qǒle tast'a. ");
INSERT INTO udi_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","T'e vədə Aaronen Moiseya pine: «Xoyinšezbsa, bez ağa, beşi axmağluğaxun əşp'est'i me günaxa görə yax caza zapesmada. ");
INSERT INTO udi_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ma barta ki, Maryami bədən p'uri nanaxun baki əylin bədən k'inək' bakane. Ma barta ki, nanay tapanexun p'uri, izi qı̌yo bašaybaki c'eri əylə oşq'ardane». ");
INSERT INTO udi_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moiseyenal Q'ončuğo k'alpi xoyinšebi: «Ay Buxačux, şot'o q'olayba!» ");
INSERT INTO udi_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Q'ončuğon isə Moiseya pine: «İz bavan şot'ay ç̌oyel ç̌upiniy, şo vǔğ ği amdarxoy piyexun biti qavuna c'eyes tene bakaliy, isəəl haketər banan! Kot'o ef çurk'ala ganuxun şəpekinan, barta vǔğ ği və̌xun ə̌xilq'an baki, vuğ ğinaxun oşa isə qaybakes banekon». ");
INSERT INTO udi_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Hametər, israilluğon Maryami tura içoğoy çurk'ala ganuxun vǔğ ğiluğ bot'unt'i, şo içoğoy arane qaybakes bakala ğinal śirik'əl azuk' yaq'a tene baft'i. ");
INSERT INTO udi_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Maryam qaybakit'uxun oşa israilluğon Xaserot'axun c'eri P'aran ams'i oç̌alat'un hari içoğoynak' çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Amdarxo yaq'aba ki, Zu israilluğoynak' həzirbi Kənan oç̌ala piyexun c'ovakest'eq'at'un. Hər tayfinaxun şot'oğoy boş kalo hesabbakalt'oğoxun soğoq'an taśi». ");
INSERT INTO udi_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moiseyenal Q'ončuğon əmirbi k'inək' içoğoy çurpi Paran ams'i oç̌alaxun şot'oğo yaq'anebi. Yaq'abiyorox bito içoğoy tayfoğoy boş kalo hesabbakalt'oğoxunt'uniy. ");
INSERT INTO udi_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","İçoğoy s'iyurxo metərey: Ruveni tayfinaxun Zak'k'uri ğar Şammua; ");
INSERT INTO udi_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeoni tayfinaxun Xorin ğar Şafat'; ");
INSERT INTO udi_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","İuday tayfinaxun Yefunneyi ğar K'alev; ");
INSERT INTO udi_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","İssak'ari tayfinaxun İosifi ğar İk'al; ");
INSERT INTO udi_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraimi tayfinaxun Nune ğar Xoşea; ");
INSERT INTO udi_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Binyamini tayfinaxun Rafuni ğar P'alt'i; ");
INSERT INTO udi_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zevuluni tayfinaxun Sodin ğar Gaddiel; ");
INSERT INTO udi_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","İosifaxun bakala Menaşşeni tayfinaxun Susin ğar Gaddi; ");
INSERT INTO udi_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dane tayfinaxun Gemallin ğar Ammiel; ");
INSERT INTO udi_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aşeri tayfinaxun Mixaili ğar Set'ur; ");
INSERT INTO udi_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naft'alin tayfinaxun Vofsin ğar Naxbi; ");
INSERT INTO udi_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gade tayfinaxun Mak'in ğar Geuel. ");
INSERT INTO udi_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ölkinə piyexun c'ovakest'eynak' Moiseyen yaq'abi amdarxo moroxey. Nune ğar Xoşea isə Moiseyen Yeşua s'ine tadi. ");
INSERT INTO udi_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moiseyen şot'oğo Kənan oç̌ala piyexun c'ovakest'eynak' yaq'abat'an pine: «Negevaxun c'ovaki buruxmux gala lakinan! ");
INSERT INTO udi_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","T'e ölkinə piyexun c'ovakest'anan. Běğanan běyn t'e oç̌al saal t'iya bakala amdarxo hetərt'un: zorbat'un yoxsa zəyif, gelet'un yoxsa mal? ");
INSERT INTO udi_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","İçoğoy yəşəyinşala ölkə hetəre: şaat'e yoxsa pis, běyn amdarxo mayat'un yəşəyinşbsa: ayizmoğo yoxsa q'alala şəhərmoğo? ");
INSERT INTO udi_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","İçoğoy k'ulal běğanan: běyn bar tadala k'ule yoxsa təə. Xodurxoy gele-mal baksunal fikir tadanan. Qaybakat'an t'e ölkin meyvoğoxun eçaynan lap şaat'e bakon». Hame vədə t'ulal p'ap'ala vədəney. ");
INSERT INTO udi_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Metərluğen, şot'oğon taśi Śin ams'i oç̌alaxun Levo-Xamat'i t'ǒğǒl bakala Rexoval śirik' t'e ölkinə piyexun c'ovakest'undi. ");
INSERT INTO udi_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Şorox Negeva c'ovaki hari Xevron şəhəret'un c'eri. Miya Anagaxun Aximani, Şeşayi saal T'almayi nəsiləxun bakaloroxe yəşəyinşbsay. Xevron şəhərə Misirə bakala Śoanaxun vǔğ usen běšt'un lasakey. ");
INSERT INTO udi_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Hari Eşk'ol uk'ala dərəne p'ap'at'an, t'iya t'etər sa ğuma t'ult'un çuki ki, şot'o durut'i loxol p'ə̌ tanene taşt'ay! T'et'iin ə̌lə̌m q'a inciləl çuket'uniy. ");
INSERT INTO udi_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Me gane s'iya t'iya çuki ğumina görət'un Eşk'ol laxi. ");
INSERT INTO udi_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Şot'oğon t'e ölkinə dirist' piyexun c'ovakest'undi, içoğoy taśi eysunenal q'ırx ğine zapi. ");
INSERT INTO udi_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Moiseyi, Aaroni saal bütüm israilluğoy t'ǒğǒl Paran ams'i oç̌ala bakala Qadeş şəhəre qaybakiyal içoğoy ak'it'oğoy barada exlətt'unbi. Şot'oğo t'e ölkinəxun eçeri meyvoğoval ak'est'undi. ");
INSERT INTO udi_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Şot'oğon Moiseya pit'un: «Yan vi pi ölkinə bayanki, şo həgigiyal muč'anaq' q'a uč' barala sa oç̌ale! Moval t'iyanin meyvoox! ");
INSERT INTO udi_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ama t'iya yəşəyinşala amdarxo gele zorbane, içoğoy şəhərmuxal ham kala, ham q'alalane. Hələ t'iya Anagi nəsiləxun bakalt'oğoval ayank'i! ");
INSERT INTO udi_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Şorox Negeva, xet'luyox, yevusluyox saal emorluyox buruxmux ganxo, kənanluyox isə dənizi q'a İordan oqe börinet'un yəşəyinşbsa». ");
INSERT INTO udi_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","K'aleven isə Moiseyi hərrəmine gireśi amdarxo şip'bsun çureśi pine: «Ekinan taśi t'iyana ext'en! Mo beş kiyelhik'k'ale!» ");
INSERT INTO udi_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ama şot'oxun sagala t'e ölkinə taśi amdarxon pit'un: «Şot'oğoxun davina c'eysuna beşi zor ayteneğon, şorox yaxun zorbat'un!» ");
INSERT INTO udi_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Şot'oğon içoğoy běği oç̌ala israilluğoy piyexun sakseynak' next'uniy: «Beşi běğseynak' taśi oç̌al bulukal oç̌ale! T'iyani amdarxoval bütüm alloy boyent'un! ");
INSERT INTO udi_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Yan t'iya Anagi nəsiləxun bakala t'etər kakala amdarxoyan ak'i ki, içoğoy t'ǒğǒl çərtk'ən k'inək'yan ak'esay. Şot'oğonal beşi loxol sa çərtk'əni loxol běğala k'inək't'un běğsay». ");
INSERT INTO udi_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","T'e üşe bütüm israilluğon şivanbi ǒnet'unpi. ");
INSERT INTO udi_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Camaaten Moiseyaxun q'a Aaronaxun t'ot'opi metərt'un nexey: «Mot'oxunsa Misirə nəəl me ams'i oç̌ala p'uriyaniy! ");
INSERT INTO udi_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Het'aynak'e Q'ončuğon yax me oç̌ala taşt'a? Yax q'ılıncen k'as'p'eq'at'un pi? Hələ beşi çupux q'a əyloxal düşmənxoy kiyel baft'alt'un. Şaat'o şone ki, Misirə qaybaken!» ");
INSERT INTO udi_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Hametər, amdarxoy arane \"ekinan yaynak' kalo c'ək'k'en, yax Misirəq'an qaydi\" k'inək' exlətxone taysay. ");
INSERT INTO udi_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","T'e vədə Moisey q'a Aaron bütüm israilluğoy běš ç̌ooq'a pastt'unśi. ");
INSERT INTO udi_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ölkinə běğseynak' taśit'oğoy boş baki Nune ğar Yeşuan q'a Yefunneyi ğar K'aleven isə amdarxoy Q'ončuğoxun ç̌o tarast'una nu portp'i, içoğoy paltara zığzığbi ");
INSERT INTO udi_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","israilluğo pit'un: «Beşi taśi běği ölkinə əyit butene! ");
INSERT INTO udi_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Əgər Q'ončuğoy piyes şaat' ak'eğayan, Şot'in yax t'e ölkinə taşale, t'e muč'anaq' q'a uč' barala oç̌ala yax tadale. ");
INSERT INTO udi_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Saycə Q'ončuğoy əleyinə ma ěqekinan! T'e ölkin amdarxoxunal ma q'ı̌banan, yan şot'oğoxun zorbayan, şot'oğo q'uc'yankon! Ene içoğoy umudbakala gaal tene mande, beşi isə Q'ončuxe bu. Şot'oğoxun ma q'ı̌banan!» ");
INSERT INTO udi_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ama camaaten \"kot'oğo ǰělayinşanan\" pine. T'e vədə Q'ončuğon bütüm israilluğo İz kalaluğa q'a tamtarağane ak'est'i. ");
INSERT INTO udi_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Q'ončuğonal Moiseya pine: «Me azuk'en hevaxt'al śirik' Za hörmətsuzluğbale? Hevaxt'al śirik' içoğo mema nišanxo ak'est'iyal bakayiz, Za tet'un věbakal? ");
INSERT INTO udi_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Kot'oğo tumexun əfçiboz! Vaxun isə kot'oğoxunal kala hamal zorba sa azuk' əmələ eçoz!» ");
INSERT INTO udi_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moiseyen isə Q'ončuğo pine: «T'e vədə Hun Vi zoren me azuk'a içoğoxun çark'est'i misirluğonal me barada ibakalt'un! ");
INSERT INTO udi_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Şot'oğon həysə me bakalt'oğoy barada me ölkin amdarxo exlətp'alt'un. T'e amdarxon isə Vi me azuk'i arane baksuna, şot'oğoxun qay exlətpsuna, Vi asoyi şot'oğoy loxol çurpi ğenaxun asoyi sütünen, üşe isə aruğoy sütünen şot'oğo taşt'una ibaket'un. ");
INSERT INTO udi_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","P'oy Hun həysə me azuk'a dirist' əfçibayin, şot'oğon k'ə fikirbalt'un? ");
INSERT INTO udi_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","\"Q'ončuğon şot'oğo İzi elasp'i əyit tadi ölkinə taşes tene baki, şot'o görəne şot'oğo ams'i oç̌ala k'as'p'i śipi!\" uk'alt'un. ");
INSERT INTO udi_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Barta isə Q'ončuğoy zora ak'eq'at'un! Vi bayanbi k'inək': ");
INSERT INTO udi_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","\"Q'ončux səbirlune, Q'ončux ük' bok'osp'ale! Şot'in taxsıra q'a günaxa bağışlayinşebsa, ama iz loxolxun tene c'ovaksa! Günaxa əşp'est'it'ay cazina izi əyloğoxun burqi nəvə nəticoğol śirik' zapesest'a\". ");
INSERT INTO udi_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ay Q'ončux, Misirəxun c'eri ğinaxun ğeyin ğinal śirik' baki k'inək', Vi nu badalbakala çuresuna ak'est'i me azuk'i günaxaxun c'eki!». ");
INSERT INTO udi_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Q'ončuğon metəre coğab tadi: «Vi upsuna görə şot'oğo bağışlayinşezbsa. ");
INSERT INTO udi_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ama Bez s'i Q'ončux tene bakon, Bez kalaluğenal me dünyənə tene haq'layinşon, ");
INSERT INTO udi_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","əgər Misirə saal ams'i oç̌ala Bezi kalaluğa q'a ak'est'i nišanxo içoğoy piin ak'it'uxun oşaal Za nu věbaki, Bezi içoğoy arane baksunaxun vis' kərəm şüpələyinşakit'oğoxun saycoq'a bakayin ");
INSERT INTO udi_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Bezi içoğoy bavoğo elasp'i əyit tadi t'e oç̌ala ak'es bakayt'un! Za hörmətsuzluğbit'oğoy sayco t'e oç̌ala tene bağal! ");
INSERT INTO udi_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ama bezi k'ul bakala K'alevi ük' q'erəze: şo sal sa vədine Bezi əyitəxun tene c'eri, şot'aynak'al şot'o iz taśi tarapi oç̌ala eçoz. Me oç̌alal şot'oxun bakala nəsili bakale! ");
INSERT INTO udi_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Və̌n isə əyc'ə ef yaq'a badalbanan! Amalegluyox q'a kənanluyox yəşəyinşala t'e oç̌ali dəroğo təə, Č'oč'a dənizi yaq'en ams'i oç̌ala takinan». ");
INSERT INTO udi_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«İz ük' pisluğen buy me azuk'en hələ heq'ədər zaxun t'ot'ok'ale? Şot'oğoy t'ot'ok'alt'oğo bitova izbaksa! ");
INSERT INTO udi_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Şot'oğo Bezi me əyitmoğo p'ap'esp'a: \"Bezi s'iyaz elase ki, efi t'ot'ok'at'an piyorox bito bakale! ");
INSERT INTO udi_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ef meyidxo me ams'i oç̌ala bašaybakale! Zaxun t'ot'opit'oğoy sayco, siyəyinə haq'eśi q'a saal q'a yəşəxun ala bakalt'oğoy sayco ");
INSERT INTO udi_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Bezi elasp'i və̌x tast'una əyit tadi oç̌ala tene bağal, Yefunneyi ğar K'alevaxun q'a Nune ğar Yeşuaxun başq'a! ");
INSERT INTO udi_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ama efi <düşmənxoy kiyel baft'alt'un> pi q'orişala əylux t'e oç̌ala bağalt'un! Şot'oğon efi baysun nu çureśi ölkinə çalxalt'un! ");
INSERT INTO udi_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Və̌n isə me ams'i oç̌ala biyalnan. ");
INSERT INTO udi_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Efi əyloğonal me ams'i oç̌ala eğel běğalt'un, və̌xun ən axırınciyo miya oç̌alaxeğamin, q'ırx usen efi me əşp'est'i günaxi cazina zap'k'alt'un. ");
INSERT INTO udi_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Efi t'e oç̌ala běğsun q'ırx ğine zapey. İsə t'e ğimxoy hər ğine gala sa usen caza zapsunen və̌n q'ırx usen əzyəti boş bakalnan! T'e vədə Bezi və̌xun ç̌o tarast'un k'ə upsuna avabakalnan\". ");
INSERT INTO udi_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mot'o Zu, Q'ončuğone nex! Bezi pit'uval booz! Bezi əyitəxun c'eri iz ük' pisluğen buy me azuk'i axır me ams'i oç̌ala eğale, korox bito hamiyal bašaybakalt'un!» ");
INSERT INTO udi_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Moiseyen t'e ölkinə běğseynak' yaq'abi, oşaal t'et'iin hari içoğoy běği oç̌ali barada avuzbsun əyitp'i, amdarxo Moiseyaxun irap't'it'oğoy ");
INSERT INTO udi_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","- t'e ölkin barada pis əyitp'it'oğoy - bito azar baft'i k'as't'unśi. Me cazina şot'oğoynak' Q'ončuğone yaq'abi. ");
INSERT INTO udi_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","T'e ölkinə běğseynak' taśit'oğoxun saycə Nune ğar Yeşua q'a Yefunneyi ğar K'aleve dirist' mandi. ");
INSERT INTO udi_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moiseyen hari Q'ončuğoy pit'oğo israilluğo p'ap'esp'at'an, dirist' azuk'en iz c'ilə t'api ǒnenepi. ");
INSERT INTO udi_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Əyc'indəri savaxt'an isə şorox t'e ölkin burux ganxoç yaq'a baft'i pit'un: «Düze, günaxyan əşp'est'i, ama ene teyan bal! Q'ončuğon yax əyit tadi oç̌ala taysuna həziryan, ekinan tağen!» ");
INSERT INTO udi_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ama Moiseyen pine: «Het'aynak'nan Q'ončuğoy əyitəxun c'eysa? Taşevk'alnan! ");
INSERT INTO udi_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ma takinan, efi düşmənxoxun bacartenanbal, axıri Q'ončux ene və̌xun tene! ");
INSERT INTO udi_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Efi běš c'eğala amalegluğon q'a kənanluğon və̌x k'as'k'alt'un! Və̌n Q'ončuğoxun ç̌onan taradi, Şoval ene və̌xun baki ef kula alabalatene». ");
INSERT INTO udi_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ama şorox içoğoy ǰomon taśi p'urumal t'e burux ganxo tağalat'un baki. Nə Moisey, nə Q'ončuğoy irəziluği sanduğ isə içoğoy ganuxun tene galpi. ");
INSERT INTO udi_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalegluyox q'a kənanluyoxal t'e burux ganxoxun śiri şot'oğo k'as't'unpi. İçoğoy běš badi Xorma şəhəre p'ap'amin şəp't'unśi. ");
INSERT INTO udi_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«İsrailluğo metər upa: \"Zu və̌x yəşəyinşbseynak' tadala oç̌ala baśit'uxun oşa ");
INSERT INTO udi_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Zaynak' belin, eğelin nəəl keçin q'urban eçeri, şot'ay bok'uni adenal Za irəzibsun çureğat'an - mo çuresa bok'ospsuni, çuresa niyətp'i, çuresa ef ük'exun c'ovaksuna görə bakala nəəl sa axsibaya görə šameğala q'urbanq'an baki - ");
INSERT INTO udi_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","şot'oxun sagala taxıli payal eçalanan. Me pay isə sa hine bip' payaxun sa pay zeytuni c'əyin lapi sa efin vis' payaxun sa pay xarine. ");
INSERT INTO udi_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Bok'ospsuni nəəl q'erəz s'iyen šameğala hər q'urbanluğ q'uzinaxun sagala sa hine bip' payaxun sa pay fiyal eça. Mo śipseynak' bakala q'urbane. ");
INSERT INTO udi_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Q'oç eğel q'urban eçat'an, şot'oxun sagala eçala taxıli pay sa hine xib payaxun sa pay zeytuni c'əyin lapi sa efin qo payaxun sa pay xari bakalane. ");
INSERT INTO udi_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Śipseynak' bakala pay k'inək' eçala fi isə sa hine xib payaxun sa pay bakalane. Mot'oğoy bok'uni ad Q'ončuğo irəzibala ad bakale. ");
INSERT INTO udi_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Zaynak' bok'ospsuni nəəl q'erəz s'iyen šameğala, niyətp'i nəəl serluği q'urban k'inək' arak' eçat'an, ");
INSERT INTO udi_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","şot'oxun sagala eçala taxıli pay qı̌ hin zeytuni c'əyin lapi sa efin vis' payaxun xib paye hama xari bakalane. ");
INSERT INTO udi_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Śipseynak' bakala pay k'inək' eçala fi isə qı̌ hin bakalane. Me bok'ospseynak' eçala q'urbani bok'uni adal Q'ončuğo irəzibala ad bakalane. ");
INSERT INTO udi_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Mot'oğo Zaynak' hər arak', q'oç, q'uzi nəəl çəpiş q'urban eçat'an əməlbalanan. ");
INSERT INTO udi_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Hema heyvan šamk'alnansa, şot'oxun sagala iz taxıli paya q'a śipseynak' bakala payal bok'osp'alnan. ");
INSERT INTO udi_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Barta bok'ospseynak' bakala pay eçeri, şot'ay bok'uni adenal Q'ončuğo irəzibsun çureğala hər israillunen me q'aydoğo əməlbeq'an. ");
INSERT INTO udi_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Əgər ef arane yəşəyinşala q'erəz azuk'axun bakalt'in nəəl ef t'ǒğǒl bakala q'erəz sunt'inal me cür q'urban eçeri Q'ončuğo irəzibsun çureğayin, barta şot'inal hər şeya efi balt'ullarik'q'an bi. ");
INSERT INTO udi_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Barta və̌ynak'al ef arane yəşəyinşala q'erəz azuk'axun bakalt'oğoynak'al q'aydoox saq'an baki. Mot'o nəsiləxun nəsilə c'ovakest'i və̌ynak' sa k'anun banan. Q'ončuğoy piyes və̌nal, ef t'ǒğǒl yəşəyinşala q'əribal sane. ");
INSERT INTO udi_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Me q'aydoğo q'a k'anunxo israillu bakalt'inal əməlbalane, ef arane yəşəyinşi, ama israillu nu bakalt'inal\"». ");
INSERT INTO udi_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«İsrailluğo metər upa: \"Zu və̌x taşala oç̌ala baśi yəşəyinşala vədine ");
INSERT INTO udi_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","t'e oç̌ali bara girbat'an şot'oxun Q'ončuğoynak' pay eçanan. ");
INSERT INTO udi_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Q'ončuğoynak' ef exp'i taxıli nübərəxun, süft'in xarinen šareśi boq'oyin šumaxun pay eçanan. Mot'o ef süft'in berxi arumaxun bakala pay k'inək' eçanan. ");
INSERT INTO udi_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Barta süft'in berxeśi arumaxun pay eşt'un nəsiləxun nəsilə c'ovaki və̌ynak' həmişəluğ sa q'aydaq'an baki\"». ");
INSERT INTO udi_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«\"Əgər və̌n nu avabaki Q'ončuğon Moiseya pit'oğoxun mat'unesa tenan əməlbesa ");
INSERT INTO udi_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","- şot'in Moiseya avabakest'i və̌x bürüşit'oğoxun - t'e vədə Q'ončuğon me q'aydoğo tadi ğinaxun burqi həmişə, mot'o nəsiləxun nəsilə c'ovakest'unen metər banan: ");
INSERT INTO udi_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","əgər me sərfə israilluğon nu avabakit'un biq'esa, t'e vədə azuk'en şot'ay bok'uni aden Q'ončuğo irəzibseynak' bok'ospsuni q'urban k'inək' sa arak' eçalane. T'e q'urbanaxun sagala iz taxıli paya q'a śipseynak' bakala payal eçalat'un. Günaxxo os'kseynak' bakala q'urban k'inək' isə sa keçi eçalat'un. ");
INSERT INTO udi_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Běyinšenal me q'urbanxo Q'ončuğoy běš šampi azuk'i əşp'est'i günaxxo os'kseynak' bakala toya ödəyinşi bakale. Metərluğen, azuk'i günaxxo bağışlayinşakale. Şot'aynak' ki, mo nu avabaki əşp'est'i günaxe, şot'o bağışlayinşbseynak' bakala bok'ospsuni q'a günaxxo os'kseynak' bakala q'urbanal eçeret'un. ");
INSERT INTO udi_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Şot'aynak'al bütüm israilluyox q'a şot'oğoy arane yəşəyinşala q'erəz azuk'axun bakalorox me nu avabaki əşp'est'i günaxa görə bağışlayinşakalt'un. ");
INSERT INTO udi_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ama günaxa nu avabaki əşp'est'iyo sa amdar bakayin, barta şot'in günaxxo os'kseynak' bakala q'urban k'inək' sa useni dişi keçiq'an běyinši t'ǒğǒl eçeri. ");
INSERT INTO udi_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Běyinšenal me q'urbana Q'ončuğoy běš eçeri q'əst'en nu əşp'est'i t'e günaxi toya ödəyinşi bakale. Günaxa q'əst'en nu əşp'est'i amdari günaxal bağışlayinşakale. ");
INSERT INTO udi_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Barta me cürə günax əşp'est'i israillu bakalt'oğoynak'al, israillu nu baki ef arane yəşəyinşalt'oğoynak'al q'ayda saq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ama əgər şinesa avabaksun günax əşp'est'ayin, mo Q'ončuğo nu çalxsun, Şot'o hik'k'albsun upsune, metərt'ay tural azuk'i aranexun bot'alanan. Mo israillu bakalt'uval, israillu nu baki ef arane yəşəyinşalt'uval aide. ");
INSERT INTO udi_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Metər amdar Q'ončuğoy laxi k'anuna t'ǒǒxbi, Şot'ay əyitəxun c'erine baksa, şot'o görəl iz cazina zap'k'ale. Şot'ay tura azuk'i aranexun bot'alnan!\"» ");
INSERT INTO udi_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","İsrailluyox ams'i oç̌ala bakat'an sa amdari Şamat' ğine uš girbsunat'un ak'i. ");
INSERT INTO udi_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Amdara uš girbat'an biq'it'oğon şot'o Moiseyi, Aaroni saal bütüm israilluğoy běšt'un eçeri. ");
INSERT INTO udi_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","T'e amdara biq'i t'ussağt'unbi, şot'o görə ki, Şamat' ğina pozmişala amdara k'ə bsuni barada sa q'ayda hələ buteney. ");
INSERT INTO udi_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","T'e vədə Q'ončuğon Moiseya pine: «Me amdara besp'anan. Barta azuk'en şot'o çurk'ala ganuxun ə̌xil c'evk'i ǰělayinşi besp'eq'an». ");
INSERT INTO udi_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","İsrailluğonal t'e amdara içoğoy çurk'ala ganuxun t'ǒǒx c'evk'i Q'ončuğon Moiseya əmirbi k'inək' ǰělayinşi best'unbi. ");
INSERT INTO udi_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«İsrailluğo upa ki, mot'oxun oşa həmişə içoğoy paltari ətəyi t'ǒğǔrxo s'os'ik'xoq'at'un ěbi. Hər s'os'ik'i boş isə göyin t'uriq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Me s'os'ik'xo ak'at'an Q'ončuğoy laxi k'anunxo q'a q'aydoğo eyexun nu c'evk'i şot'oğo əməlbalnan. Şot'oğon və̌x efi piin ak'alt'oğoy q'a ük'exun c'ovakalt'oğoy bač'anexun taysunaxun efale. ");
INSERT INTO udi_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Və̌nal bütüm Bezi əmirxo eyex badi şot'oğo əməlbalnan, metərluğenal Zaynak' ı̌vel sa azuk' bakalnan. ");
INSERT INTO udi_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ef Buxačux bakseynak' və̌x Misirəxun c'evk'i Q'ončux, ef Buxačux Zuzu. Zu Q'ončuxzu, ef Buxačuxzu!» ");
INSERT INTO udi_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Levin nəticə, K'ohat'i nəvə, Yiśariyal ğar bakala Goraxen Ruveni nəsiləxun bakala Eliavi ğarmux Dat'an q'a Aviramaxun saal P'elet'i ğar Onaxun əyitə sabi ");
INSERT INTO udi_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Moiseyi əleyinət'un ěqeśi. Şot'oğoy tərəf azuk'axun p'ə̌baç̌ əlli tane buy, içal bito s'ila, kala amdarxoney. ");
INSERT INTO udi_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Şorox gireśi Moiseyi q'a Aaroni t'ǒğǒl hari pit'un: «Bəse efiyo! Me azuk'i boş saycə və̌n təə, yan bito ı̌velyan, Q'ončuxal beş bitot'ay t'ǒğǒle! Ama və̌n və̌x bitot'uxun avuzinnan hesabbsa». ");
INSERT INTO udi_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Moiseyen me əyitmoğo ibaki ç̌ooq'a past'eśi. ");
INSERT INTO udi_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Oşa Goraxa q'a şot'ay tərəf bakalt'oğo pine: «Əyc'ə savaxt'an Q'ončuğon İçeynak' c'ək'p'it'u, ı̌vel bakalt'u, İz bakala gala baśi İçuxun əyitp'es bakalt'u ak'est'ale. Şu c'ək'k'alesa şoval İçu ı̌šalayinşakes bakale. ");
INSERT INTO udi_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Və̌n isə buxur bok'ospseynak' bakala q'avurxo ext'anan, ");
INSERT INTO udi_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","şot'oğoy boş əyc'ə bok'ala s'ile loxol şaat' adeğala oyurxo laxi Q'ončuğoy běš c'ekinan. Q'ončuğon şu c'ək'k'alesa, şoval ı̌vel hesab bakale. Bəse ene efiyo, ay leviyox!» ");
INSERT INTO udi_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moiseyen Goraxa pine: «Leviyox, ibakanan k'əz nex! ");
INSERT INTO udi_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","İsraillluğoy Buxačuğon və̌x azuk'i boşt'an c'ək'p'i İçu ı̌šane bi, və̌x ı̌vel çadıri əşurxost'a köməybi azuk'i s'iyen İçu q'ulluğbseynak'e laxi. ");
INSERT INTO udi_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Q'ončuğon və̌x, leviğo, İçu ı̌šane bi, ama və̌n isəəl běyinšluğbsunanan tamaxbsa! ");
INSERT INTO udi_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Hunal, me vaxun hariyoroxal, və̌n bito Aaroni təə, Q'ončuğoy əleyinənən ěqesa. Aaron şuva ki?» ");
INSERT INTO udi_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Oşa Moiseyen Eliavi ğarmux Dat'ana q'a Aviramane k'alpest'i, ama şot'oğon pit'un: «Yan teyan eğal! ");
INSERT INTO udi_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Yax t'e muč'anaq' q'a uč' barala ölkinəxun c'evk'i ams'i oç̌ala k'as'eseynak' eçeriyo male, hələ sa beş kalo baksunal çurensa? ");
INSERT INTO udi_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","İsəəl yax muč'anaq' q'a uč' barala oç̌ala ten taşt'a, q'oruğxo, t'ulluğxo ten tast'a, oşaal fikirenbsa ki, amdarxoy pulmux k'ač'ine? Teyan eğal!» ");
INSERT INTO udi_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","T'e vədə Moiseyen gele əcuğləyinşəki Q'ončuğo pine: «Kot'oğon tadala payurxo q'abulmaba! Kot'oğoxun sa elemal tez ext'i, kot'oğo sal sa pisluğ tezbe». ");
INSERT INTO udi_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moiseyen Goraxa pine: «Hun q'a me vi tərəf bakalorox isə əyc'ə Q'ončuğoy běš c'ekinan - hun, korox saal Aaron. ");
INSERT INTO udi_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Barta hərt'in iz buxur bok'ospseynak' bakala q'aval ext'eq'an. Bito sagala p'ə̌baç̌ əlli dənə q'av. Şot'oğoy boş şaat' adeğala oyurxo laxi Q'ončuğoynak' eçanan». ");
INSERT INTO udi_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Metərluğen, şot'oğon içoğoy buxur bok'ospseynak' bakala q'avurxo ext'i Moiseyaxun q'a Aaronaxun sagala ı̌vel çadıri bağala gane běš çurt'unpi. T'e q'avurxoy boş bok'ala s'ile loxol şaat' adeğala oyurxot'un laxey. ");
INSERT INTO udi_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Goraxen Moiseyi q'a Aaroni əleyinə c'eri iz tərəf bakalt'oğo bitova ı̌vel çadıri bağala gane běš topbit'uxun oşa, mone, dirist' azuk'en Q'ončuğoy tamtarağane ak'i. ");
INSERT INTO udi_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Ə̌xilbakanan me azuk'axun, kot'oğo həysə əfçiboz». ");
INSERT INTO udi_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ama Moiseyen q'a Aaronen ç̌ooq'a past'eśi xoyinšt'unbi: «Ay Buxačux! Ay iz boş nəfəs bakalt'oğo bitova elmux tadala Buxačux! Het'aynak'en sa amdaren əşp'est'i günaxa görə dirist' azuk'an əcuğo c'evksa?» ");
INSERT INTO udi_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","T'e vədə Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«İsrailluğo upa ki, Goraxi, Dat'ani saal Avirami çadıraxun ə̌xilbakeq'at'un!» ");
INSERT INTO udi_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moisey hayzeri israilluğoy ağsaq'q'alxoxun sagala Dat'ani q'a Avirami t'ǒğǒle taśi. ");
INSERT INTO udi_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Şot'in azuk'a xavardarluğbi pine: «Me içoğoy ük' pisluğen buy amdarxoy çadırxoxun ə̌xilbakanan! Kot'oğoy sal sa şeyal kul ma duğanan, tene me amdarxoy günaxxo görə və̌nal əfçibakalnan!» ");
INSERT INTO udi_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Amdarxoval Goraxi, Dat'ani saal Avirami çadırxoxun ə̌xilt'unbaki. Dat'an saal Aviram isə c'eri içoğoy çupuxxoxun q'a xuri-kala əyloğoxun sagala içoğoy çadırxoy bağala gane běš çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moiseyen pine: «Mone, zu bito me əşurxo bez beynə təə, ama Q'ončuğoy tapşuruğen bsuna metər avabakalnan: ");
INSERT INTO udi_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","əgər me amdarxo içoğoy acalen biyayt'un, içoğoy bel eğala əşurxost'al sa fərg nu bakayin, t'e vədə za Q'ončuğon tene yaq'abe. ");
INSERT INTO udi_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ama əgər oç̌al qı̌bakayin, koroxal dirist'-dirist', içoğoy bakal-nu bakalaxun sagala t'iya bağayt'un, əgər Q'ončuğon kot'oğoynak' nu ak'eśi metər sa bisun yaq'abayin, t'e vədə q'amişakalnan ki, me amdarxo Q'ončuğoxun tərs taśiyoroxe». ");
INSERT INTO udi_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Moiseyen iz ǰomoxun axırınci əyitə c'evksun q'a hametər baksun sane baki. T'e amdarxoy turin oq'a bakala oç̌al qı̌nebaki, ");
INSERT INTO udi_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","şoroxal bito - Goraxi tərəf bakalt'oğoy külfətə şu bunesa - içoğoy bakal-nu bakalaxun sagala oç̌ali oq'at'un taśi. ");
INSERT INTO udi_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Şorox dirist'-dirist't'un oç̌alaxeśi. Oç̌alen şot'oğo içoğoy bakal-nu bakalaxun sagala t'etəre q'uc'p'i ki, içoğoy gaal tene mandi. ");
INSERT INTO udi_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","T'iya bakala amdarxo bito şot'oğoy haraya ibaki t'it'unt'eri, şot'o görə ki, içoğoyal oç̌ali oq'a taysunaxun q'ı̌t'unbsay. ");
INSERT INTO udi_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Buxuri q'avurxoy boş şaat' adeğala oyurxo bok'osp'i amdarxoy loxol isə Q'ončuğon aruxe yaq'abi, p'ə̌baç̌ əlli tanal bito bok'i bart'undi. ");
INSERT INTO udi_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Běyinš Aaroni ğar Eleazara upa ki, bok'uni boşt'an q'avurxo girbi şot'oğoy boş bakala s'ilurxo ams'ibi ə̌xilq'an boseri, şot'o görə ki, t'e q'avurxo ı̌vele. ");
INSERT INTO udi_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Mo içoğoy elmoğoy toyen bakala günax əşp'est'it'oğoy q'avurxone. Barta t'e q'avurxo t'api t'ə̌p'ə̌k'bi q'urban eçala gane t'ǒğurxoq'at'un but'k'i. Şot'oğo Q'ončuğoynak't'un eçerey, şorox ene ı̌vele. İsrailluğoynak' isə mo eyex badala sa nišan bakale». ");
INSERT INTO udi_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eleazarenal bok'uni boşt'an mise buxuri q'avurxo girebi, şot'oğo t'api t'ə̌p'ə̌k'p'it'uxun oşal q'urban eçala gane t'ǒğurxot'un but'k'i. ");
INSERT INTO udi_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Hametər, Q'ončuğon Moiseya, Moiseyenal Eleazara pi k'inək' baneki. İsrailluğon isə me mise loxol hər běğat'an, içoğoy eyext'un bast'ay ki, Aaroni nəsiləxun bakalt'oğoxun başq'a şinesa Q'ončuğoy běš buxur bok'ospsun çureğayin, iz axır Goraxi q'a şot'ay tərəf bakit'oğoylarik' bakale. ");
INSERT INTO udi_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Əyc'indəri israilluyox p'urum gireśi Moiseyaxun q'a Aaronaxun t'ot'opsat'un burqi. Şot'oğon \"Q'ončuğoy amdarxo və̌nnan besp'i\" next'uniy. ");
INSERT INTO udi_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ama şorox topbaki Moiseyi q'a Aaroni běš c'eyseynak' ı̌vel çadıraç tağat'an, çadıra bürdən asoyene haq'i. Şot'oğon Q'ončuğoy tamtarağat'un ak'i. ");
INSERT INTO udi_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moisey q'a Aaron ǐvel çadıra ı̌šalayinşt'unbaki, ");
INSERT INTO udi_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Q'ončuğonal Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«Me azuk'axun ə̌xilbakanan, şot'o görə ki, həysə kot'oğo bitova əfçiboz!» Şot'in metər uk'ala k'inək' Moisey q'a Aaron ç̌ooq'a oç̌ala past'unśi. ");
INSERT INTO udi_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moiseyen Aarona pine: «Vi buxuri q'ava ext'i iz boş q'urban eçala ganuxun s'il laxa, oşa iz loxol şaat' adeğala oyurxoval laxi azuk'i t'ǒğǒl taki. Metər Q'ončuğon şot'oğo bağışlayinşi bakale. Mone, Q'ončuğon İz əcuğo azuk'i loxol śipi şot'oğoynak' k'as'esuna ene yaq'abene». ");
INSERT INTO udi_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaronenal Moiseyen içu pi k'inək' buxuri q'ava ext'i camaati t'ǒğǒle taśi. Şo eğat'an amdarxo k'as'esa burqeney, ama şot'in q'urban eçala ganuxun ext'i s'ile loxol şaat' adeğala oyurxo bok'osebi, şot'oğoy günaxxoval bağışlayinşest'ine baki. ");
INSERT INTO udi_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Şo p'urit'oğoy q'a dirist't'oğoy arane çurpi k'as'esuna enefi. ");
INSERT INTO udi_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Goraxa görə p'urit'oğo nu hesabbayin isə bip'es's'e hazar vǔğbaç̌ tane p'urey. ");
INSERT INTO udi_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Amdarxoy k'as'esun çurpit'uxun oşa Aaron azuk'i t'ǒğǒl, ı̌vel çadıri bağala gane běše qaybaki. ");
INSERT INTO udi_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«İsrailluğo upa ki, vaynak' p'as's'e dənə çombağq'at'un eçeri. Çombağa hər tayfin s'iyen iz kalat'in eçalane. Hər çombaği loxolal şot'o eçeri kalat'ay s'iya śampa. ");
INSERT INTO udi_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Levi tayfinaxun bakalt'oğoy çombaği loxol Aaroni s'iya śampa. Hər tayfin kalat'ay s'iyen sa çombağ bakalane. ");
INSERT INTO udi_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Çombağxo və̌n Zaxun exlətpseynak' eğala gala - ı̌vel çadıra bakala śameśi irəziluği běš laxa. ");
INSERT INTO udi_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Zu t'etər booz ki, Bez c'ək'p'i amdari çombağ göyünbakale, Zuval ene me azuk'i və̌xun t'ot'opsuna tez ibakal». ");
INSERT INTO udi_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moiseyen mot'oğo israilluğo exlətebi, şot'oğoy boşt'an c'ək'eśi kalat'oğonal hərt'in sa çombağt'un eçeri - bito sagala p'as's'e çombağ. Aaroni çombağal me çombağxoy boşey. ");
INSERT INTO udi_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moiseyen me çombağxo irəziluği çadıri boş, Q'ončuğoy běš lanexi. ");
INSERT INTO udi_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Əyc'indəri Moisey irəziluği çadıra bağat'an anek'i ki, Levi tayfin s'iyen bakala, Aaroni s'i śameśi çombağ göyünbakene. Şot'in lap t'up'ullayinşaki s'is'ik' qaypi badamal c'epeney. ");
INSERT INTO udi_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","T'e vədə Moiseyen Q'ončuğoy běš laxi çombağxo bitova ext'i israilluğoy běše c'eri. Şot'oğon çombağxo bět'unği, hərt'inal iz çombağa c'ək'p'i exedi. ");
INSERT INTO udi_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Q'ončuğon Moiseya pine: «Aaroni çombağa qaydi irəziluği çadıra, śameśi irəziluğ bakala gane běš laxa. Barta mo Q'ončuğoy əyitəxun c'erit'oğoynak' ene Şot'in c'ək'p'it'oğoxun nu t'ot'opseynak' sa nišan baki şot'oğo bisunaxun çark'est'eq'an». ");
INSERT INTO udi_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moiseyenal bitova Q'ončuğon içu pi k'inək' bine. ");
INSERT INTO udi_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","İsrailluğon Moiseya pit'un: «Beş axır butene! Əfçibakalyan! Yan bito əfçibakalyan! ");
INSERT INTO udi_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Q'ončuğoy ǐvel çadıra ı̌šalayinşakalo, şot'o ı̌ša bitalo bisane! Yəni yanal bito biyalyan?» ");
INSERT INTO udi_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Q'ončuğon Aarona pine: «Hun, vi ğarmoğon saal vi nəsiləxun bakalt'oğon ı̌vel ganu günax əşesunaxun efi nu murdarlayinşaksuna běğalanan. Běyinšluği ı̌vel mandi nu murdarlayinşaksun isə saycə vi q'a vi ğarmoğoy ozanene. ");
INSERT INTO udi_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Vi tayfinaxun bakala mandi leviğoval vi t'ǒğǒl ext'a ki, hun q'a vi ğarmoğon ı̌vel çadıra q'ulluğbat'an və̌x köməybat'un. ");
INSERT INTO udi_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Barta şot'oğon vi kiin oq'a əşp'i va köməybeq'at'un, ama nə q'urban eçala ganu, nə şot'ay sal sa ət't'əcə ı̌ša maq'at'un biti, tene və̌nal biyalnan, şoroxal. ");
INSERT INTO udi_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Barta ı̌vel çadıri bütüm əşurxost'a vaxun baki köməybeq'at'un, ama ef tayfinaxun nu bakala sal sa amdara t'iya ı̌ša bist'a barmatanan. ");
INSERT INTO udi_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ama çadıri boş baśi q'a q'urban eçala ganu ı̌ša biti biq'ala əşurxo və̌n banan, tene Bez əcuğ p'urum israilluğoy loxol bəc'ük'eğale. ");
INSERT INTO udi_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","İsrailluğoy boşt'an leviğo Zuz c'ək'p'i və̌x pay k'inək' tadi ki, və̌x köməybeq'at'un. Şorox ı̌vel çadıra q'ulluğbseynak't'un c'ək'eśe. ");
INSERT INTO udi_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ama běyinšluğbi q'urban eçala ganu q'a çadıri boş pərdin bač'ane bakala ən ı̌vel ganu ı̌šalayinşaksuna saycə va q'a vi ğarmoğoz icaza tast'a, mot'oğo sa pay k'inək' və̌xez tast'a. Və̌xun başq'a şunesa t'iya ı̌šalayinşakayin besp'anan». ");
INSERT INTO udi_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Q'ončuğon Aarona pine: «Mone, Zaynak' eçala payurxo bitova běğsuna va Zuz tapşurbi. Zaynak' eçala bito ı̌vel payurxo vi q'a vi ğarmoğoy bakale. Şorox və̌xe kofst'a, barta həmişəəl metərq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Mo Zaynak' eçeri ı̌vel paye - q'urbanxoy nu bok'osp'i hissooxe. Zaynak' eçala bito payurxoy - çuresa taxıli paye, çuresa günaxxo os'kseynak' bakala nəəl taxsıra os'kseynak' bakala q'urbanxoy me hissə efi bakale. ");
INSERT INTO udi_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Şot'o ən ı̌vel sa ukun k'inək' uka. Şot'o saycə işq'arxone ukes bakon, barta mo və̌ynak' ı̌velxoy ı̌velq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Zaynak' sa pay baksuna ak'est'eynak' alabiyoroxal bito vine. Şot'oğo va, vi ğarmoğo saal xuyərmoğoz tast'a, şorox və̌xe kofst'a, barta həmişəəl metərq'an baki. Vi külfəti boş pak bakala hər sunt'in şot'oxun ukes banekon. ");
INSERT INTO udi_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Q'ončuğoynak' samci nübər k'inək' eçala ən şaat' zeytuni c'əyinə, noč'a saal taxıli payal vaz tast'a. ");
INSERT INTO udi_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Oç̌alen tadi bito barurxoxun Q'ončuğoynak' eçala samci nübərxo vine. Vi külfəti boş pak bakala hər sunt'in şot'oxun ukes banekon. ");
INSERT INTO udi_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","İsrailluğoy boş Q'ončuğoynak' pay k'inək' cöybaki hər şey vine. ");
INSERT INTO udi_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Amdarxoy süft'in ğar əyeləl, heyvanxoy süft'in ərkəy balal - Q'ončuğoynak' bakala me payurxo - vine. Ama insani balin q'a haram hesabbakala heyvani balin gala təngə ext'a. ");
INSERT INTO udi_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Barta şorox sa xaşin bakat'an, va ı̌vel gane şek'elen qo şek'el gümüş tadi şot'oğo haq'eq'at'un (sa şek'el q'a gere). ");
INSERT INTO udi_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ama çure, eğeli saal keçin samci ərkəy balin gala hik'k'al exmada, şot'oğo šampa. Şorox ı̌vele; şot'oğoy p'iya q'urban eçala gane börüğo çəçədi içoğoy piyal bok'osp'a, şot'o görə ki, şot'oğoy bok'uni ad Q'ončuğo irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Şot'oğoy yeq' isə va mandale. Q'ončuğoynak' sa pay baksuna ak'est'eynak' alabaki döşe yeq' q'a yön bude yeq' va mandalt'ullarik'. ");
INSERT INTO udi_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","İsrailluğon Q'ončuğoynak' eçala bito ı̌vel payurxo va, vi ğarmoğo saal xuyərmoğoz tast'a. Şorox və̌xe kofst'a, barta həmişəəl metərq'an baki. Mo Bezi vaxun saal vi nəsiləxun ğaç̌eğala həmişəluğ, nu śareğala sa irəziluğe». ");
INSERT INTO udi_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Q'ončuğon Aarona pine: «Zu israilluğo tadala oç̌ala və̌ynak' miras butene, və̌x t'e oç̌alaxun pay koft'alatene, şot'o görə ki, və̌x koft'ala mirasi q'a paye gala hər şeya Zu və̌x p'ap'esp'oz. ");
INSERT INTO udi_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","İsrailluğon Zaynak' eçala içoğoy girbi bare vis' payaxun sa paya isə leviğoz tast'a. Mo şot'oğoy ı̌vel gala bala q'ulluği əvəze. ");
INSERT INTO udi_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ama israilluyox ǐvel çadıra maq'at'un ı̌šalayinşaki, tene iz caza bisun bakala günaxa baft'alt'un. ");
INSERT INTO udi_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Barta saycə leviğonq'an ı̌vel çadıra əşp'i q'ulluğbi, t'e gane pak mandi nu murdarlayinşaksunal şot'oğon běğalat'un. Mo və̌ynak' nəsiləxun-nəsilə c'ovakala həmişəluğ sa q'aydane. Zu israilluğo tadala oç̌alaxun şot'oğoynak' pay butene. ");
INSERT INTO udi_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Şot'ay gala leviğo israilluğon Zaynak' eçala paya - içoğoy girbi bare vis' payaxun sa payaz tast'a. Mot'o görəl leviğo və̌x tadala oç̌alaxun pay tene kofst'a». ");
INSERT INTO udi_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Leviğo metər upa: \"Zu və̌x miras k'inək' tadi paya, israilluğon Zaynak' eçala içoğoy girbi bare vis' paye sunt'u ext'at'an, şot'ay vis' paye sa paya Q'ončuğoynak' eçanan. ");
INSERT INTO udi_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Me paya israilluğon Zaynak' içoğoy exp'i arumaxun q'a bapi finaxun eçala pay k'inək' q'abulboz. ");
INSERT INTO udi_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Metərluğen, israilluğon içoğoy girbi bare vis' paye sunt'u və̌ynak' eçat'an, şot'oxun Zaynak' bakala hissinə cöybanan. Bez paya běyinš Aarona tadanan. ");
INSERT INTO udi_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Və̌ynak' eçala payurxoxun Q'ončuğoynak' ən şaat' ganu cöybanan, şot'o görə ki, me pay ı̌vel paye\". ");
INSERT INTO udi_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Leviğo upanan: \"Və̌ynak' eçeri payaxun Zaynak' ən şaat' ganu cöybat'an, Zu şot'o və̌xun ef exp'i arumaxun q'a ef bapi finaxun eçala pay k'inək' q'abulboz. ");
INSERT INTO udi_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Mandiyo isə efiq'an baki, efi külfəti boş bakalt'oğoy bitot'in şot'oxun ukes banekon. Mo efi ı̌vel gala bala q'ulluğin əvəze, şot'o efi ük'en çureğala gala ukes banankon. ");
INSERT INTO udi_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Və̌n Q'ončuğoynak' ən şaat' ganu cöybsunen, t'e pay ı̌vel mandi tene murdarlayinşaksa. Şot'o görəl t'e paya uksunen iz caza bisun bakala günaxa tenan bafst'a\"». ");
INSERT INTO udi_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Bezi israilluğoynak' laxi k'anuni q'aydoox moroxe: barta və̌ynak' sa dənə salamat hamal hələ çöle nu əşp'i č'oč'a ocasq'at'un eçeri. ");
INSERT INTO udi_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Şot'o běyinš Eleazara tadanan. Oşa bartanan t'e ocasa azuk'i çurk'ala ganuxun t'ǒǒx c'evk'i Eleazari piin běš šampeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazaren t'e ocasi p'iyaxun iz k'əşinen ext'i vǔğ kərəm ı̌vel çadıri bağala ganuç çəçədeq'an. ");
INSERT INTO udi_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ocasi t'ola, yeq'a, p'iya saal gödənxo isə şot'ay piin běš bok'osp'eq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Barta běyinšen şame xodaxun sa tay, issop uk'ala o saal tünd č'oč'a irəngen gombi xayaxun ext'i mot'oğoval bok'ala ocasi loxolq'an boseri. ");
INSERT INTO udi_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Oşa běyinšen iz paltara q'a iz bədənə os'k'eq'an. Mot'oxun oşa şo azuk'i çurk'ala gala qaybakes banekon, ama şo hələl t'e ğine biyəsəl śirik' pak tene hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ocasa bok'osp'i amdarenal iz paltara q'a iz bədənə os'k'eq'an. Şoval biyəsəl śirik' pak tene hesabbakal. ");
INSERT INTO udi_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Bok'i ocasaxun mandi jeq'a isə barta pak hesabbakala sa amdaren girbi azuk'i çurk'ala ganuxun ə̌xil, pak hesabbakala sa gala laxeq'an. Me jeq'a israilluğon pakbala xe düzbseynak' efalat'un, şo günaxxo os'kseynak' əşeğale. ");
INSERT INTO udi_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ocasaxun mandi jeq'a girbi amdarenal iz paltara os'k'eq'an, ama şoval biyəsəl śirik' pak tene hesabbakal. Barta mo israilluğoynak'al, içoğoy t'ǒğǒl yəşəyinşala q'erəz millətəxun bakalt'oğoynak'al həmişəluğ sa q'aydaq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","İz kula meyidə duği amdar vǔğ ği murdarlayinşakine hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Xibimci q'a vǔğǔmci ğine şot'in içu t'e jeq'axun gərbi xenen pakbalane, mot'oxun oşa şo pak hesabbakale. P'urina laft'it'uxun oşa xibimci q'a vǔğǔmci ğine içu nu pakbi amdar isə pak tene hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","İz kul meyidə laft'i, oşal içu nu pakbi amdaren Q'ončuğoyı̌vel çadır bakala ganu murdarlayinşine baksa, metər amdari tura azuk'i aranexun bot'anan. Şot'ay loxol pakbala xe tene çəçəpe, şo hələ murdarlayinşakine hesabbaksa, iz murdarlayinşaksun təmizbaki tene baksa. ");
INSERT INTO udi_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Mone, və̌ynak' metər sa k'anunez laxsa: əgər çadıra soğo p'urenesa t'iya bakaloroxal, t'e çadıra bağaloroxal vǔğ ği murdarlayinşakit'un hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","İz q'apağ gip nu arśi hər q'aval murdarlayinşakine hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Şinesa qavuna iz kula meyidə duğayin - çuresa q'ılıncaxun p'uriyo, çuresa iz acalen p'uriyoq'an baki - şoval vǔğ ği murdarlayinşakine hesabbaksa. Mo iz kul p'uri amdari ǔq'enxo q'a gərəmzoğo laft'it'uval aide. ");
INSERT INTO udi_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Murdarlayinşaki amdara pakbseynak' metər banan: t'e bok'i ocasi, yəni günaxxo os'kseynak' bakala q'urbani jeq'axun ext'i sa q'ave boş təzə eçeri xena bapi gərgürbanan. ");
INSERT INTO udi_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Oşa barta pak hesabbakala sa amdaren issop uk'ala oyen t'e xenaxun ext'i çadıri q'a iz boş bakala bito şeymoğoy loxol saal t'iya bakala amdarxoy loxol çəçədeq'an. Qavuna q'ılıncaxun nəəl iz acalen p'urit'ay meyidə, p'uri amdari ǔq'ěnxo nəəl gərəmzoğo iz kul laft'it'uval metər banan. ");
INSERT INTO udi_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Pak hesabbakala amdaren meyidəxun murdarlayinşakit'ay loxol xibimci q'a vǔğǔmci ğine xe çəçədalane. Metərluğenal, vǔğǔmci ğine şot'o pakbi bakale. Barta pakbaki amdaren iz paltara os'k'i, iz loxolal xeq'an lapi. T'e üşenaxun şo ene pak hesabbakale. ");
INSERT INTO udi_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ama əgər soğo murdarlayinşakit'uxun oşa qaybay pakbaksuni q'aydoğo nu əməlbayin, metər amdari tura azuk'i aranexun bot'anan. Şot'ay loxol pakbsuni xe tene çəçəpe, şo murdare hesabbaksa. Şot'in Q'ončuğoy ı̌vel çadır bakala ganu murdarlayinşebsa. ");
INSERT INTO udi_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Barta mo israilluğoynak' həmişəluğ sa q'aydaq'an baki. Pakbseynak' bakala xena çəçədalt'inal iz paltara os'k'alane. İz kul t'e xena laft'alo biyəsəl śirik' murdarlayinşakine hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Murdarlayinşaki amdari laft'i hər şey murdare hesabbaksa. Şot'ay laft'it'oğo kul duği amdaral biyəsəl śirik' murdarlayinşakine hesabbaksa». ");
INSERT INTO udi_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","İsrailluğoy Misirəxun c'eysun q'ırx useney. T'e useni samci xaşest'a israilluyox hari Śin ams'i oç̌alat'un c'eri. Şorox Qadeş şəhəre çurt'unpi. Miya Maryam p'ure, şot'oval hat'iya oç̌alaxt'unbi. ");
INSERT INTO udi_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Azuk'en xeneynak' koruğe aksay, amdarxonal Moiseya q'a Aaronane taxsırkərbsay. ");
INSERT INTO udi_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Şot'oğon Moiseyi t'ǒğǒl taśi pit'un: «Mot'oxunsa t'e p'urit'oğollarik' Q'ončuğon beş elmoğoval haq'iniy! ");
INSERT INTO udi_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Het'aynak'nan Q'ončuğoy azuk'a me ams'i oç̌ala eçere? Yaxal, beş heyvanxoval memiya bespseynak'? ");
INSERT INTO udi_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Het'aynak'nan yax Misirəxun c'evk'i me pis gala eçeri? Miya nə əkine bit'es baksa, nə incile bu, nə t'ul nəəl ə̌lə̌m! Ǔğseynak' xe hik'ə teyan bə̌ğə̌bsa!» ");
INSERT INTO udi_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","T'e vədə Moisey q'a Aaron amdarxo efi ı̌vel çadıri bağala gane běšt'un taśi. Şorox t'iya ç̌ooq'a oç̌ala pastt'unśi. Q'ončuğoy kalaluğ q'a tamtarağ şot'oğoynak' ak'eśi, ");
INSERT INTO udi_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Q'ončuğonal Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Çombağa ext'a, vi viçi Aaronaxun sagalal azuk'a girba. Oşa bütümt'ay piin běš q'ayana əmirba şot'inal və̌ynak' xe c'evk'ale. Hun q'ayanaxun c'eri xena azuk'a tadalnu, şot'oğonal boşşamin uğə̌lt'un, içoğoy heyvanxoval ǔgest'alt'un». ");
INSERT INTO udi_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moiseyenal Q'ončuğon içu əmirbi k'inək' ı̌vel çadıra bakala çombağa ext'i ");
INSERT INTO udi_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","iz viçi Aaronaxun sagala azuk'a q'ayani běš girebi. Oşa pine: «Ay gərgürçiluğ sakalxo! Mone, yax ene me q'ayanaxunal xe c'evk'est'alanan baki!» ");
INSERT INTO udi_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Metər pi, Moiseyen iz kula alabi q'ayana p'ə̌ kərəm çombağen duneği. Q'ayanaxun t'etər gele xene şağapi ki, dirist' azuk'enal, içoğoy heyvanxonal ǔği bot'unşi. ");
INSERT INTO udi_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ama Q'ončuğon Moiseya q'a Aarona pine: «İsə ki və̌n israilluğoy běš Bez pit'oğo üst'ün laxi Bez ı̌vel baksuna ç̌oyel tenan c'evk'i, şot'oğo Bezi tadala oç̌ala bast'un və̌x q'ısmat tene bakal». ");
INSERT INTO udi_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Me c'eri xene s'i isə Merivane, şot'o görə ki, miya israilluğon Q'ončuğoxun t'ot'ot'unpe, Q'ončuğon isə şot'oğo İz ı̌velluğane ak'est'ey. ");
INSERT INTO udi_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Qadeş şəhərexun Moiseyen Edomi padçaği t'ǒğǒl amdarxone yaq'abi ki, şot'o me əyitmoğo p'ap'esp'at'un: «Mone, vi viçi İsraili nəsiləxun bakalt'oğone vaxun xaişbsa! Beşi mani əzyətxoxun c'ovaksuna avanu: ");
INSERT INTO udi_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","hələ beş kalboğoy döörəxun Misirə hariyoyan, boxoy vaxt'al t'e oç̌alayan yəşəyinşe. Ama misirluğon nə beşi kalboğo, nəəl yax ği tet'un tade. ");
INSERT INTO udi_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Yan Q'ončuğoyan k'alpi xoyinšbi, Şot'inal yax inebaki, yaynak' çark'est'ala angele yaq'abi. Şot'in yax Misiri oç̌alaxun c'evek'i. İsə mone, yan Qadeş şəhəreyan, vi oç̌ali q'a beş arane sa dənə zahmane bu. ");
INSERT INTO udi_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","İcaza tada vi oç̌ali boşt'an c'ovaken! Nə vi əkinə, nə t'ulluğxo teyan ç̌axç̌uxk'al, vi kərizxoy xenaxunal teyan ǔğə̌l. Vi oç̌alaxun c'ovakamin, Kala yaq'axun nə tərs, nə yön tərəf teyan c'eğal». ");
INSERT INTO udi_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ama edomluğon şot'o pit'un: «Beşi oç̌ala efi tur tene laft'al! Bağaynan ef běš q'ılıncen c'eğalyan!» ");
INSERT INTO udi_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","İsrailluğon şot'oğo metərt'un coğab tadi: «Yan yaq'axun teyan c'eğal. Ef xenaxunal nə yan, nə beşi heyvanxon ǔğə̌yin, şot'ay tənginə tadalyan. Beşi çureğalo ef ölkinəxun c'ovaki taysune, q'erəz hik'k'al!» ");
INSERT INTO udi_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Amma edomluğon p'urumal \"və̌x beş oç̌ala barteyanne\" pi, israilluğoy běš kala sa q'oşun girbit'un c'eri. ");
INSERT INTO udi_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Hametər, edomluğon israilluğo içoğoy oç̌alaxun c'ovaksa bartet'unti, şoroxal fırıpi q'erəz yaq'ent'un taśi. ");
INSERT INTO udi_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","İsrailluyox Qadeş şəhərəxun yaq'a baft'i hari Hor buruğot'un c'eri. ");
INSERT INTO udi_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Edomi zahmana ı̌ša, me Hor buruğoy tume Q'ončuğon Moiseya q'a Aarona pine: ");
INSERT INTO udi_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Aaroni t'e dünyəne, ef bavoğoy t'ǒğǒl tağala vaxt' hari p'ap'ene. Və̌n Meriva xene t'ǒğǒl Bezi əyitəxun c'ernan, kot'o görəl Aaron Zu israilluğo tadala oç̌ala bağalatene. ");
INSERT INTO udi_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aarona q'a iz ğar Eleazaral ext'i Hor buruğo laki. ");
INSERT INTO udi_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Oşa Aaroni loxol bakala běyinšluği paltara c'evk'i iz ğar Eleazara lapest'a. Aaron isə t'iya biyale, şo iz bavoğoy t'ǒğǒl, t'e dünyəne tağale». ");
INSERT INTO udi_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moiseyenal Q'ončuğon içu əmirbi k'inək' bine. Şorox dirist' azuk'i piin běš buruğot'un laśi, ");
INSERT INTO udi_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","t'iyal Moiseyen Aaroni loxolxun běyinšluği paltara c'evk'i şot'ay ğar Eleazarane lapest'i. Aaron isə t'e buruğoy bel p'ure. Moiseyen q'a Eleazaren buruğoxun śiri ");
INSERT INTO udi_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","azuk'a Aaroni bisuni xavara tadat'an, israilluğon otuz ği yast'un efi. ");
INSERT INTO udi_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Negeva bakala Arad şəhəri padçağen inebaki ki, israilluyox At'arima tağala yaq'ent'un c'ovaksa. Me padçağ iç kənanluney. Şo azuk'i loxol davinane c'eri, israilluğoxunal şot'ay kiyel əsir baft'aloroxe baki. ");
INSERT INTO udi_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","T'e vədə israilluğon elasp'i Q'ončuğo əyitt'un tadi: «Əgər Q'ončuğon me azuk'a beş kiyel tadayin, yan şot'oğo k'as'p'i içoğoy şəhərmoğoval dirist' śarpi śik'alyan». ");
INSERT INTO udi_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Q'ončuğon israilluğoy me xoyinša inebaki. T'e aradlu kənanluğonal şot'oğo taşevt'unk'i. Azuk'en şot'oğoy şəhərmoğoval, t'iya yəşəyinşala kənanluğoval dirist' əfçinebi. Mot'oxun oşa t'e gane s'iya Xormat'un laxi. ");
INSERT INTO udi_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Azuk' Edom oç̌ala nu bayseynak' Hor buruğoxun c'erit'uxun oşa fırıpi Č'oč'a dənizi yaq'ene taśi. Yaq' boxoyey, amdarxonal ene porttet'unbsay. ");
INSERT INTO udi_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Şot'oğon Buxačuğoxun q'a Moiseyaxun t'ot'ot'unney: «Het'aynak'nan yax Misirəxun c'evk'i? Ams'i oç̌ala biseynak'? Nə xeya bu, nə šuma bu! Me hik'k'ala nu dərmən ukuni loxolal ene běğes teyan baksa!» ");
INSERT INTO udi_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","T'e vədə Q'ončuğon amdarxo duğseynak' azuk'i çurk'ala gala zəhərlu dizik'xone yaq'abi, şot'oğon amdarxo dut'unğsay, azuk'i boşt'anal gele amdare p'uri. ");
INSERT INTO udi_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","İsrailluğon Moiseyi t'ǒğǒl hari pit'un: «Yan günaxyan əşp'est'i, Q'ončuğoxun q'a vaxun t'ot'oyanpi, isə xoyinšyanbsa, Q'ončuğo k'alpa afırıpa, bərkə yax me dizik'xoxun çark'est'ane!» Moiseyen Q'ončuğo azuk'a görə xoyinšebi, ");
INSERT INTO udi_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Q'ončuğonal Moiseya pine: «Sa dizik' düzbi şot'o durut'i loxol ost'aarba. Barta dizik'en duğalt'in şot'ay loxolq'an běği, t'e vədə biyalatene». ");
INSERT INTO udi_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moiseyen misəxun sa dizik' düzbi şot'oboxoy durut'i loxol ost'aarebi, şuval dizik'en duğayin me misnə dizik'i loxol běğat'an bisateney. ");
INSERT INTO udi_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","İsrailluyox p'urum yaq'at'un baft'i, hariyal Ovot'a çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ovot'axun c'eri Moavi běğ c'eğalaç tərəf bakala ams'i oç̌ala, İye-Avarima çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Memiin p'urum yaq'a baft'i hari Zered uk'ala dərənet'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Oşa t'et'iinal c'eri hari Arnon oqe t'iyə̌mi tərəf bakala ams'i oç̌alat'un çurpi. Memiin emorluğoy oç̌ale burqesay. Arnon oq emorluğoy q'a Moav oç̌alxoy arane sa zahman k'inək'ey. ");
INSERT INTO udi_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Me barada \"Q'ončuğoy davoox\" uk'ala girke boş metəre śam: \"...Sufina bakala Vahev q'a dəroox, Arnon, ");
INSERT INTO udi_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Ar ayizexun c'ovaki Moavi zahmana bakala dərəni döşexun tağala yaq'...\" ");
INSERT INTO udi_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","T'et'iin israilluyox Beera Q'ončuğon Moiseya \"azuk'a girba, şot'oğo xe tadoz\" pi kərizin t'ǒğǒlt'un hari. ");
INSERT INTO udi_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Miyat'un israilluğon me mə̌ğə̌ mə̌ğpey: «J̌alpa buybaka, ay kəriz, Me kərizin barada mə̌ğpanan! ");
INSERT INTO udi_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Azuk'i kalat'oğon q'a s'ilat'oğon İçoğoy kiin ak'est'i gala kašeśi kərizin barada mə̌ğpanan!» Oşa israilluyox ams'i oç̌alaxun Mat't'anat'un taśi. ");
INSERT INTO udi_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mat't'anaxun Naxaliela, Naxalielaxun Bamot'a, ");
INSERT INTO udi_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamot'axun isə Moav oç̌ala bakala dərənet'un taśi. T'iya bakala P'isk'a buruğoy belxun dirist' me xam ga ak'esay. ");
INSERT INTO udi_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","İsrailluğon emorluğoy padçağ bakala Sixoneynak' xavar yaq'abi pit'un: ");
INSERT INTO udi_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Xaişyanbsa, vi oç̌alaxun c'ovaksuna yax icaza tada! Nə ef əkini, nə t'ulluğxoy boşt'an teyan c'ovakal, ef kərizxoy xenaxunal teyan ǔğə̌l. Vi oç̌alaxun c'ovakamin Kala yaq'axun teyan c'eğal». ");
INSERT INTO udi_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ama Sixonen israilluğo iz oç̌alaxun c'ovaksuna icaza tene tadi. Şot'in dirist' iz q'oşuna girbi davabseynak' ams'i oç̌ala şot'oğoy běše c'eri. Şorox Yahaśa ç̌o-ç̌oya hari davat'unbi. ");
INSERT INTO udi_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Davina isə israilluğone taşeri. Şot'oğo q'ılıncen k'as'p'i içoğoy oç̌alxo Arnon oqaxun burqi Yabboga oqe t'ǒğǒl bakala ammonluğoy zahmanal śirik' ext'undi. Ammonluğon isə içoğoy oç̌alxo şaat't'un q'orişbsay. ");
INSERT INTO udi_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Hametər, israilluğon emorluğoy Xeşbon şəhərə q'a şot'ay hərrəmine bakala ayizmoğo saal mandi bito şəhərmoğo kiyel badi baśi t'iya art'unśi. ");
INSERT INTO udi_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Xeşbon emorluğoy padçağ Sixoni arśala şəhərey. Şot'in Moavi mot'oxun běš baki padçağaxun davabi şot'oğoy Arnon oqal śirik' bakala bito oç̌alxo ext'eney. ");
INSERT INTO udi_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Me barada mə̌ğə̌l śameśeney: \"Xeşbona ekinan! Barta Sixoni şəhər təzədənq'an biq'eśi, Barta iz bariyox təzədənq'an laxeśi! ");
INSERT INTO udi_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Xeşbonaxun arux, Sixoni şəhərexun yalove c'eri! Şot'in Moav oç̌ala bakala Ar şəhərə, Arnon oqe t'ǒğǒl bakala ǰěyurxo bul k'os'balxo Bok'osp'i śinepi! ");
INSERT INTO udi_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Vay vi hala, ay Moav! Ay Kemoşa içeynak' buxačux bi azuk', əfçinbaki! Kemoşen vi ğarmoğo dədərgünebi, Vi xuyərmoğo emorluğoy padçağ Sixoni kiyele efi! ");
INSERT INTO udi_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mone, və̌x tayanşeri, Xeşbonaxun Divon şəhərel śirik' əfçiyanbi. Medvanaxun burqi Nofahal śirik' hər tərəfə vərənyanbi\". ");
INSERT INTO udi_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Hametər, israilluyox baśi emorluğoy oç̌ala art'unśi. ");
INSERT INTO udi_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Oşa Moiseyen Yazer şəhərəl piyexun c'vakest'eynak' amdarxone yaq'abi. İsrailluğon şot'ay hərrəmine bakala ayizmoğoxunal emorluğo şəp'eśi baśi t'iya art'unśi. ");
INSERT INTO udi_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","T'et'iin c'eri israilluyox yaq'en Başanaçt'un laśi. Başani padçağ bakala Ogenal dirist' iz q'oşuna girbi şot'oğoy běše c'eri. Şorox hari Edreyi şəhəre davinat'un c'eri. ");
INSERT INTO udi_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Q'ončuğon Moiseya pine: «Şot'oxun ma q'ı̌ba! Zu şot'o içuval, iz q'oşunal, iz ölkinəl va ene tadez! Xeşbona arśi emorluğoy padçağ Sixoni bel eçerit'u şot'ay belal eçalnu». ");
INSERT INTO udi_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","İsrailluğonal şot'oğo bitova - Oga içu, iz ğarmoğo, dirist' iz q'oşuna - k'as'p'i śit'unpi. Şot'oğoxun sayco dirist' tene mandi, içoğoy oç̌alxoval bito israilluğone mandi. ");
INSERT INTO udi_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","İsrailluyox p'urum yaq'at'un baft'i, hariyal Moavi düzənluğa, İordan oqe t'ǒğǒl bakala Yerixon şəhəri běš çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","T'e vədə Moavi padçağ Śip'p'ori ğar Balagey. Şot'in israilluğon emorluğoy bel eçerit'oğoy barada ibakeney. ");
INSERT INTO udi_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","İsrailluyox t'ema gelet'uniy ki, moavluğon şot'oğoy s'iya ibakat'an q'ı̌yat'un bafst'ay, içoğo t'ut'ultinene haq'say. ");
INSERT INTO udi_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moavluğon Midyani ağsaq'q'alxo metərt'un pi: «Belin sürünen çöle o nu efalt'ullarik', me azuk'enal beş loxol eğayin, yaxun hik'k'al tene efal». Moavi padçağ bakala Śip'p'ori ğar Balagenal ");
INSERT INTO udi_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","iz amdarxo Yevfrat oqe t'ǒğǒl bakala P'et'or şəhəre yaq'anebi ki, t'iya yəşəyinşala Beori ğar Bileama metərq'at'un pi: «Misirəxun c'eri azuk'en hər ganu haq'layinşene, isəəl hari beş oç̌alxoy t'ǒğǒle çurpe. ");
INSERT INTO udi_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Xaişezbsa, zaynak' sa əş biq'a: eki me azuk'i loxol q'arğiş śipa. Şorox həysə zaxun zorbat'un, ama şot'oğo zəyifləyinşa ki, zu şot'oğo bez ölkinəxun şəp'eśes bakaz. Axıri vi tadala xeyir-bərəkəten biq'ala k'inək', vi śik'ala q'arğişenal bineq'sa». ");
INSERT INTO udi_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moavi ağsaq'q'alxo q'a Midyani ağsaq'q'alxoval Bileami me biq'ala əşlin haq'q'a ext'i şot'ay t'ǒğǒlt'un taśi. Şot'oğon Balagi pit'oğo bitova p'ap'est'unbi. ");
INSERT INTO udi_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bileamen şot'oğo pine: «Və̌n me üşe memiya mandanan, zu Q'ončuğoy coğaba avabaki və̌x uk'oz». Moavi ağsaq'q'alxoval şot'ay k'oya mant'undi. ");
INSERT INTO udi_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Buxačux Bileameynak' ak'eśi pine: «Vi k'oya bakala me amdarxo şuva?» ");
INSERT INTO udi_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bileamen Buxačuğo coğabe tadi: «Moavi padçağ Śip'p'ori ğar Balagene me amdarxo yaq'abe ki, za izi muzin me əyitmoğo uk'at'un: ");
INSERT INTO udi_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","\"Mone, Misirəxun c'eri azuk'en oç̌ali ç̌oya haq'layinşene. Xaişezbsa, eki me azuk'i loxol q'arğiş śipa ki, zəyifləyinşəkeq'at'un, zuval şot'oğo bez ölkinəxun şəp'eśes bakaz\"». ");
INSERT INTO udi_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Buxačuğon Bileama pine: «Ma taki me amdarxoxun. T'e azuk'i loxol q'arğiş śimapa, şot'o görə ki, şot'oğo Zuz xeyir-bərəkət tade». ");
INSERT INTO udi_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Əyc'indəri savaxt'an Bileamen hayzeri Balagi yaq'abi ağsaq'q'alxo pine: «Ef ölkinə qaybakanan, Q'ončuğon za və̌xun taysa bartenne». ");
INSERT INTO udi_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moavi ağsaq'q'alxoval Balagi t'ǒğǒl qaybaki pit'un: «Bileam yaxun tene hari». ");
INSERT INTO udi_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","T'e vədə Balagen süft'int'uxun gele hamal şot'oğoxun hörmətlu saal s'ila ağsaq'q'alxone yaq'abi. ");
INSERT INTO udi_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Şorox Bileami t'ǒğǒl hari pit'un: «Śip'p'ori ğar Balagen metəre nex: \"bez vaxun xaişp'i əşlə nu bsuna kapmapa. ");
INSERT INTO udi_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Va k'ə çurensa tadoz, k'ə uk'alnu booz, saycə eki me azuk'a q'arğişp'a\"». ");
INSERT INTO udi_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileamen Balagi amdarxo coğab tadi pine: «Balagen za iz q'ızılen q'a gümüşen buy k'ojal tadayin, zu bez Buxačux bakala Q'ončuğoy nu çureğala sal sa əş biq'es tez bakon. ");
INSERT INTO udi_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ama Q'ončuğon za ene k'ə upsuna avabaksun çurnansasa, və̌nal me üşe memiya mandes banankon». ");
INSERT INTO udi_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Buxačuxal t'e üşe Bileama ak'eśi şot'o pine: «İsə ki me amdarxo va taşt'at'un hare - taki! Ama Zu va k'ə uk'ozsa, şot'o balnu». ");
INSERT INTO udi_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Savaxt'an Bileam hayzeri, iz elemi loxol palanal laxi Moavi ağsaq'q'alxoxun sagala yaq'ane baft'i. ");
INSERT INTO udi_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ama şo tağat'an Buxačuğoy əcuğ bəc'ük'eśi, Q'ončuğoy angelal běš c'eri iz yaq'a bot'esedi. Bileam elemi loxol tanesay, içuxunal p'ə̌ nökər. ");
INSERT INTO udi_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Elemen ak'at'an ki, yaq'e boş iz kiyel q'ılıncla Q'ončuğoy angele çurpe, yaq'axun c'eri q'oruğane baśi. Bileamen isə elema duği şot'o yaq'a qayst'une çureśi. ");
INSERT INTO udi_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","T'e vədə Q'ončuğoy angel p'ə̌ t'ulluği aranexun c'ovakala cığıri boşe çurpi, t'e cığıri p'ə̌ tərəfəl bariney. ");
INSERT INTO udi_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Elemen Q'ončuğoy angela ak'i barinane ləçəq'eśi. Bileami tural elemi q'a barin arane mandi p'ět'eśi. Bileamen elema p'urum duğsane burqi. ");
INSERT INTO udi_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Q'ončuğoy angel isə samalal běš hari t'etər sa q'ac' galane çurpi ki, t'iya nə tərse fırıpes baksay, nə yön. ");
INSERT INTO udi_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Bileami arśi elemen mot'o ak'i çökedi, Bileamiyal əcuğon biq'i elema k'ovalen duğsane burqi. ");
INSERT INTO udi_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","T'e vədə Q'ončuğon elema muzalebi, şot'inal Bileama pine: «Zu va k'əz be ki, mo xibimci kərəme za t'ap'enne?» ");
INSERT INTO udi_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileamen elema pine: «Za lağan haq'sa? Həysə bez kiyel sa q'ılınc bakayin va besezbon!» ");
INSERT INTO udi_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Elemen Bileama coğabe tadi: «Zu vi həmişənin c'idala elem tezu ki, memaçağ metər bezu?» Bileamen \"təə\" pine. ");
INSERT INTO udi_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","T'e vədə Q'ončuğon Bileami pulmoğo qayepi, şot'inal cığıri boş çurpi iz kiyel q'ılınc bakala Q'ončuğoy angela anek'i. Bileamen çökt'i iz ç̌oya oç̌alane duği. ");
INSERT INTO udi_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Q'ončuğoy angelen isə pine: «Me elema het'u görən xib kərəm t'api? Vi běš c'eri va taysa nu bark'alo zuzu. Şot'o görə ki, vi biq'ala əş Q'ončuğoy piyes düzgün tene ak'esa. ");
INSERT INTO udi_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Elemen za ak'i xib kərəm bez běšt'an fırınepi. Ke elem nu fırıpiniy, isə vi elmoğo haq'ezuy! Ama elema galdala tezuy!» ");
INSERT INTO udi_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bileamen Q'ončuğoy angela pine: «Günaxez əşp'est'i! Vi bez běšt'an bot'est'una tez avay. Ama bez biq'ala əş vi piyes pise ak'esasa, zu qaybakaz». ");
INSERT INTO udi_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Q'ončuğoy angelen Bileama metəre pi: «Taki me amdarxoxun, ama saycə zu va uk'alt'oğo əyitp'a». Bileamal Balagi yaq'abi ağsaq'q'alxoxun sagala taneśi. ");
INSERT INTO udi_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balagen Bileami eysuna ibaki, iz běš c'eyseynak' Arnon oqe t'ǒğǒl bakala İr-Moav şəhərene taśi. Me şəhər iz oç̌ali lap t'e beley. ");
INSERT INTO udi_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balagen Bileama pine: «Vi bač'anexun hema kərəm amdarez yaq'abi, het'u görə ten eysay? Yəni va vi çureğala k'inək' tez yaq'a badaliy?» ");
INSERT INTO udi_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileamen Balaga metəre coğab tadi: «Mone, həysə vi t'ǒğǒlzu. Ama k'ə pesez baksa? Buxačuğon za bürüşalt'oğoxun avuzin hik'k'al pes tez bakon». ");
INSERT INTO udi_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Oşa Balagen Bileama Qiryat'-Xuśot' şəhərene taşeri. ");
INSERT INTO udi_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Miya Balagen, beliğoy q'a eğelxoy q'urban šampest'i t'e yeq'axun Bileama q'a şot'oxun bakala ağsaq'q'alxone tadi. ");
INSERT INTO udi_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Əyc'indəri savaxt'an isə Balagen Bileama ext'i Bamot' Baal uk'ala bul k'os'bala galane laśi. Memiin Bileamen israilluğoy çurk'ala gane sa t'ǒğə̌ aneksay. ");
INSERT INTO udi_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bileamen Balaga pine: «Zaynak' memiya vǔğ dənə q'urban eçala ga düzbest'i, šamseynak'al vǔğ dənə arak' saal vǔğ dənə q'oç eğel eçest'a». ");
INSERT INTO udi_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balagenal Bileami pi k'inək' bine. Şot'oğon hər q'urban eçala gala sa arak' q'a sa dənə q'oç eğelt'un q'urban eçeri. ");
INSERT INTO udi_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Oşa Bileamen Balaga pine: «Hun miya, me eçeri q'urbanxoy t'ǒğǒl çurpa, zu isə samal t'ǒǒx tağoz. Bərkə Q'ončux za ak'eśi İzi əyitə pine. Za k'ə uk'ayin, hari va avabakest'oz». Metər piyal şo ams'i sa təpinene laśi. ");
INSERT INTO udi_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Miya Buxačux Bileama ak'eśi, Bileamenal Şot'o pine: «Vǔğ dənə q'urban eçala gaz düzbest'i, hərt'ay loxolal sa arak' q'a sa dənə q'oç eğelez q'urban eçeri». ");
INSERT INTO udi_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Q'ončuğon isə Bileama k'ə upsun lazım baksuna zombi tapşurebi: «İsə taki, mot'oğo Balaga p'ap'esp'a». ");
INSERT INTO udi_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bileam Balagi t'ǒğǒl qayebaki, hariyal Balaga q'a şot'oxun hari ağsaq'q'alxo eçeri q'urbanxoy t'ǒğǒl çurpine ak'i. ");
INSERT INTO udi_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Şo t'et'iya p'ap'ala k'inək' iz ǰomoxun Buxačuğon zombi əyitmuxe c'eri: «Balagen, Moavi padçağen za Aramaxun, Běğ c'eğala tərəf bakala buruxmoğoxune eçeri; \"Eki zaynak' İak'ova q'arğişp'a, Me israilluğoy loxol q'arğiş śipa\" pine. ");
INSERT INTO udi_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","P'oy Buxačuğon nu ləənətbit'u zu hetər ləənətbaz? Buxačuğon nu q'arğişbit'u zu hetər q'arğişbaz? ");
INSERT INTO udi_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mone, q'ayoğoy belxun şot'oğoy loxolez běğsa, Təpoğoy loxolxun şot'oğoz aksa! Me azuk' iç sa ölkəne, Sal sa azuk' şot'ay tay tene! ");
INSERT INTO udi_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","İak'ovi nəsiləxun bakalt'oğo bǒq'ə̌lpsun q'ume dənoğo bǒq'ə̌lpsun k'inək'e: Şot'oğoy bip' payaxun sunt'u tenan bǒq'ə̌lk'on! Barta bez bisunal me düzgünt'oğoy bisunallarik'q'an baki, Barta bez axıral mot'oğoy axırallarik'q'an baki!» ");
INSERT INTO udi_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balagen Bileama pine: «Hun mo za k'ən bi? Zu va bez düşmənxoy loxol q'arğiş śipseynak'ez k'alpi, hun isə xeyir-bərəkəti şot'oğoxun kam nu baksunaxunen əyite!» ");
INSERT INTO udi_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Bileamen coğabe tadi: «Zu Q'ončuğon za pit'oğoz nex». ");
INSERT INTO udi_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","T'e vədə Balagen şot'o pine: «Eki zaxun q'erəz gala tağen. T'et'iin azuk'a ak'es bakalnu, ama bitova təə, içoğoy çurk'ala gane sa t'ǒğə̌. Bezi əyitə oq'a ma saka, eki t'e ganuxun şot'oğo q'arğişp'a». ");
INSERT INTO udi_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hametər, Balagen şot'o P'isk'a buruğoy bel bakala Śofim, yəni \"běğala ga\" uk'ala q'oruğane taşeri. Miya vǔğ dənə q'urban eçala ga düzbi, hərt'ay loxolal sa arak' q'a sa dənə q'oç eğelt'un q'urban eçeri. ");
INSERT INTO udi_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bileamen Balaga pine: «Hun miya, me bok'osp'i q'urbanxoy t'ǒğǒl çurpa, zu isə samal běš taśi Buxačuğoxun əyitk'oz». ");
INSERT INTO udi_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Q'ončuxal Bileama ak'eśi şot'o k'ə upsun lazım baksuna zombi tapşurebi: «İsə taki, mot'oğo Balaga p'ap'esp'a». ");
INSERT INTO udi_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Bileam Balagi t'ǒğǒl qayebaki, hariyal şot'o eçeri q'urbanxoy t'ǒğǒl Moavi ağsaq'q'alxoxun sagala çurpine ak'i. Balagen şot'oxun xavare haq'i: «Q'ončuğon k'ə pi?» ");
INSERT INTO udi_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bileameni ǰomoxunal Buxačuğon zombi əyitmuxe c'eri: «Ay Balag, vi ǔmǔxxo qaypa ibaka! Ay Śip'p'ori ğar, za ǔmǔxlaxa! ");
INSERT INTO udi_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Əfçiduğsun amdarxoy əşe, Fikirə badalbsun - me dünyəni ədəte! Buxačux isə İz pi əyiti loxol çurene, Şot'ay əyit tadi bex nu p'ap'espsuna itenbakon! ");
INSERT INTO udi_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Şot'in xeyir-bərəkətə ene tadene, Zu isə me əyitmux bez ǰomoxun barst'eynak'ez c'ək'eśe! ");
INSERT INTO udi_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","İak'ovi nəsileynak' q'ı̌ tene bu, İsrailluğoy belxun sa popal tene bital! Şot'o görə ki, içoğoy Buxačux bakala Q'ončux içoğoxune, Şot'ot'un padçağ pi k'ale! ");
INSERT INTO udi_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Çölnə öküzi zore tade şot'oğo Buxačuğon, Misirəxune c'evk'e şot'oğo! ");
INSERT INTO udi_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","İak'ovi nəsilə əfçibsun falçin əş tene, İsrailluğo sal sa cadunen biteneq'sa! Me azuk'a běği \"mo Buxačuğoy əşe!\" next'un. ");
INSERT INTO udi_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Běğa hetəre aslan k'inək' ěqesa, Hetəre şir k'inək' amdarxoy loxol taysa! İz kiyel baft'alt'u śark'amin, Şot'ay p'iya xupi çark'est'amin kul tene haq'on!» ");
INSERT INTO udi_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","T'e vədə Balagen Bileama pine: «Efa! Nə vi q'arğişbsunaz çuresa, nə xeyir-bərəkət k'alpsuna!». ");
INSERT INTO udi_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileamen isə \"va tez pi ki, Q'ončuğon za k'ə uk'alesa, şot'o booz?\" pine. ");
INSERT INTO udi_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","T'e vədə Balagen Bileama metəre pi: «Va q'erəz sa gala taşoz! Banekon Buxačuğon şot'oğo vi t'et'iine çurpi q'arğişbsuna çuresa». ");
INSERT INTO udi_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Hametər, Balagen Bileama P'eor buruğoy bele taşeri. T'e ganuxun dirist' t'e xam ga ak'esay. ");
INSERT INTO udi_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Miya Bileamen Balaga pine: «Zaynak' memiya vǔğ dənə q'urban eçala ga düzbest'i, šamseynak'al vǔğ dənə arak' saal vǔğ dənə q'oç eğel eçest'a». ");
INSERT INTO udi_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balagen Bileamen pi k'inək' bine, hər q'urban eçala gane loxolal sa arak' q'a sa dənə q'oç eğel q'urban šampi bok'osebi. ");
INSERT INTO udi_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Bileamen isə Q'ončuğoy israilluğoxun İz xeyir-bərəkətə nu kambsuna q'amişakeney. Şot'in ene me azuk'i loxol q'arğiş śipseynak' Buxačuğoy içu sa nišan ak'est'una tene yaqběği, ama fırıpi t'e xam oç̌alxone běği. ");
INSERT INTO udi_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","T'iyal içoğoy tayfoğo görə dəst'ə-dəst'ə çurpi israilluğo ak'at'an, Buxačuğoy uruf şot'ay loxole śiri, ");
INSERT INTO udi_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","şot'o me əyitmoğone pest'i: «Mone, Beori ğar Bileamene əyite! Mone, efi nu ak'alt'oğo ak'alt'in, ");
INSERT INTO udi_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Efi nu ibakalt'oğo ibakalt'in, Ala Arśit'ay xoji iz piin běš eğalt'in, Şot'ay əyitmux iz ǔmǔğo laft'at'an oç̌ala past'eğalt'ine əyite! ");
INSERT INTO udi_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ay İak'ovi nəsiləxun bakalorox, efi çadırxo, Ay israilluyox, efi mandala ganxoy gözəlluğa əyit butene! ");
INSERT INTO udi_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Xene t'ǒğǒl bakala o k'inək'nan, Oqe börine bakala bağça, Q'ončuğon yaratmişi gözəl xodurxo, Arxe bel bakala şame xod k'inək'nan! ");
INSERT INTO udi_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Efi xazalxoxun xene k'at'e, Və̌xun bitala hər śil göyünebaksa! Ef padçağ Agak' padçağaxunal üst'ün bakale, T'e padçağluğen bitova çökt'est'ale! ");
INSERT INTO udi_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Buxačuğon şot'oğo Misirəxune c'evk'i, Şot'oğo çölnə öküzi zore tadi! Düşmənxoy pula haq'alt'un, Ǔq'ěnxo xoxp'i oxurxo şot'oğoy tapane basakalt'un! ");
INSERT INTO udi_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Mone, cupsuna həzir sa şir k'inək't'un arst'a, Bask'i aslani gözəlluğe bu şot'oğost'a! Şuva t'e aslana ı̌ša bitalo? Və̌x xeyir-bərəkət tadalt'aynak' xeyir-bərəkət, Və̌x q'arğişbalt'aynak' isə bələne eysa!» ");
INSERT INTO udi_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","T'e vədə Balagi əcuğon Bileami loxol t'etəre biq'i ki, iz kulmoğo yumburuğ biq'i pine: «Va bez düşmənxo q'arğişbseynak'ez k'alpe, yoxsa şot'oğo xeyir-bərəkət tast'eynak'? Mo xibimcine ki, şot'oğoynak' xeyir-bərəkəten k'ale. ");
INSERT INTO udi_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Aç̌a bez piin běšt'an! C'eki taki vi k'oya! Va şaat' hörmətbi vi çureğala k'inək' yaq'abadala fikirzax buy! Ama Q'ončuğon mot'o vaynak' gelene ak'i». ");
INSERT INTO udi_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileamen isə Balaga pine: «Bez bač'anexun yaq'abit'oğo tez pey ki, ");
INSERT INTO udi_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Balagen za iz q'ızılen q'a gümüşen buy k'ojal tadayin, zu Q'ončuğoy əyitəxun c'eri hik'k'al bes tez bakon? Zu saycə Q'ončuğon za uk'alt'oğo uk'oz. ");
INSERT INTO udi_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Baneki, zu bez ölkinə qayezbaksa! Ama barta hələ ki miyazu, va sa şeyal p'ap'esp'az. Gələcəye me azuk'en vi azuk'i bel eçalt'oğo ibaka!» ");
INSERT INTO udi_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Metər piyal Bileamen gələcəyə ak'ala əyitmoğone iz ǰomoxun c'evk'i: «Mone, Beori ğar Bileamene əyite! Mone, efi nu ak'alt'oğo ak'alt'in, ");
INSERT INTO udi_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Efi nu ibakalt'oğo ibakalt'in, Bitova Bacarbalt'uxun içeynak' sa alaxun ak'esun bakalt'in, Şot'ay əyitmux iz ǔmǒğo laft'at'an Oç̌ala past'eğalt'ine əyite! ");
INSERT INTO udi_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Şot'o azaksa, ama ı̌ša tene! İz loxolez běğsa, ama hələ ə̌xile! Mone, muč'uli c'eğalt'ullarik' İak'ovi nəsiləxunal sa padçağe c'eysa, İsrailluğoy boşt'an zorba sa kule ěqesa! Moavluğoy bula č'ak'k'ale, Şet'luğoy mə̌yə duği śark'ale! ");
INSERT INTO udi_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edoma iz kiyel badale, Seyra ext'i iz düşmənə turin oq'a sakale! İsrailluyox isə ěqeğalt'un! ");
INSERT INTO udi_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","İak'ovi nəsiləxun c'erit'in şot'oğo iz zora ak'est'ale, Şəhəre mandit'oğo bitova k'as'p'i śik'ale!» ");
INSERT INTO udi_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Oşa Bileamen amalegluğoy gələcəyəne ak'i pi: «Millətxoy boş bitot'uxun üst'üne amalegluyox, Ama içoğoy axır butene - bito əfçibakalt'un!» ");
INSERT INTO udi_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Bileamen K'ayini nəsiləxun bakalt'oğoy gələcəyəl anek'i: «Mone, həysə efi k'ojurxoynak' q'ı̌ butene, Efi mes q'ayani loxol k'inək'e. ");
INSERT INTO udi_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ama, ay K'ayinaxun bakiyorox, aşurluyox eğat'an xarabina mandalnan! Bito şot'oğoy kiyel baft'alnan». ");
INSERT INTO udi_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Bileamen gələcəyə ak'i saal pine: «Vay, Buxačuğon mot'oğo bit'uxun oşa şuva dirist' mandon? ");
INSERT INTO udi_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","K'it't'imluyox gəmiğon eğalt'un, Şot'oğon Aşura q'a Evera ext'alt'un, Ama axırda içanal əfçibakalt'un». ");
INSERT INTO udi_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Mot'oxun oşa Bileam c'eri iz k'oya, Balagal iz k'oyane qaybaki. ");
INSERT INTO udi_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","İsrailluyox Şit't'im uk'ala dərəne bakat'an, şot'oğon miya içoğoynak' moavluğoxun çuux haq'sat'un burqi. ");
INSERT INTO udi_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Me çupuxxon içoğoy buxačuxxoynak' šameğala q'urbani q'onaxluğxo işq'arxo k'alt'unney, israilluğonal taśi t'e q'urbani yeq'axun kəyi şot'oğoy buxačuxxo bult'un k'os'bsay. ");
INSERT INTO udi_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Metər, israilluyox Q'ončuğoxun ə̌xilbaki P'eor buruğoy bel bakala binik' buxačux Baalat'un bul k'os'bsa burqi, Q'ončuğoy əcuğal israilluğoy loxol bəc'ük'eśi. ");
INSERT INTO udi_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Q'ončuğon Moiseya pine: «Azuk'i boşt'an me günaxeynak' yaq' qaypi kalat'oğoy bitova besp'i şot'oğoy meyidxo camaati piin běš suruk'p'a. Metər, Bezi israilluğoy loxol bakala əcuğo bask'est'alnu, Zuval şot'oğoy me əşp'est'i günaxi loxolxun c'ovakoz». ");
INSERT INTO udi_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moiseyenal israilluğoy boş bakala divanbalxo pine: «Barta ef boşt'an hərt'in P'eor buruğo bakala Baala bul k'os'balt'oğoxun iz çalxalt'oğo besp'eq'an». ");
INSERT INTO udi_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Me vədine sa israillunen ı̌vel çadıri bağala gane běš ǒnek'ala Moiseyi q'a dirist' azuk'i piin běš sa midyanlu çuuxe k'oya eçeri. ");
INSERT INTO udi_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Mot'o ak'ala Eleazari ğar, běyinš Aaroni isə nəvə bakala P'inexasen amdarxoy boşt'an hayzeri, iz kiyel xişt'ik' ext'i ");
INSERT INTO udi_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","t'e israillun bač'anexun çadırane baśi. Şot'in me xişt'ik'ə işq'araxun deşibi c'ovakest'i çuğoy tapanene basaki. Hametər, şot'oğoy p'rannal - israillunal, t'e çuğoval t'e çadıri boş besebi. İsrailluğoy boş bakala k'as'esun hat'e saad çurepi. ");
INSERT INTO udi_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Buxačuğon yaq'abi azaraxun k'as'eśit'oğoy say isə saq'obip' hazar taney. ");
INSERT INTO udi_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Běyinš Aaroni nəvə, Eleazari isə ğar bakala P'inexasen Bezi israilluğoy loxol bəc'ük'eśi əcuğo çaxevek'i. Şot'in me azuk'i Za ak'est'i hörmətsuzluğa tene portp'i, şot'o görəl Zu şot'oğo Bez əcuğon biq'i tez əfçibi. ");
INSERT INTO udi_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","İsə şot'o upa ki, Zu içuxun serluğ q'a xeyir-bərəkət eçala sa irəziluğez ğaç̌esa. ");
INSERT INTO udi_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Me irəziluğa görəl həmişəluğ běyinšluğbsun şot'aynak' q'a şot'oxun oşa eğala nəsili bakale. Şot'in izi Buxačuğo hörmətsuzluğ ak'est'una tene portp'i. Metərluğenal, israilluğoy günaxa os'k'i taneşeri». ");
INSERT INTO udi_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Midyanlu çuğoxun sagala besp'i israillu işq'ari s'i Saluni ğar Zimriney. Şo Şimeoni tayfinaxun bakala sa nəsili kaloney. ");
INSERT INTO udi_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Besp'i midyanlu çuğoy s'i isə Śure xuyər K'ozbiney. Śural Midyana bakala sa nəsili kaloney. ");
INSERT INTO udi_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Midyanluğoy loxol düşmən piin běğanan, şot'oğo k'as'p'anan. ");
INSERT INTO udi_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Şot'o görə ki, şot'oğont'un və̌x P'eora bakala binik' buxačuğo bul k'os'best'i. Mot'o görə və̌ynak' k'as'esun eğat'an, içoğoy kalat'ay xuyərə, P'inexasen besp'i K'ozbina və̌ynak' yaq'abiyoroxal şoroxe». ");
INSERT INTO udi_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","İsrailluğoynak' yaq'abi k'as'esun çurpit'uxun oşa Q'ončuğon Moiseya q'a Aaroni ğar běyinš Eleazara pine: ");
INSERT INTO udi_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Bito israillu işq'arxo içoğoy əsilə q'a ailinə görə siyəyinə haq'anan. Siyəyinə q'a saal q'a yəşəxun ala bakala, davina tayes bakala işq'arxo haq'eğale». ");
INSERT INTO udi_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moavi düzənluğa, İordan oqe t'ǒğǒl bakala Yerixon şəhəri běš Moiseyen q'a běyinš Eleazaren amdarxoxun əyitp'i pit'un: ");
INSERT INTO udi_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Q'ončuğon Moiseya əmirbi k'inək', q'a saal q'a yəşəxun ala bakala bito işq'arxo siyəyinə haq'anan!» Misirəxun c'eri israilluyox isə moroxey: ");
INSERT INTO udi_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","İsraili süft'in ğar Ruvenaxun bakiyorox: Xanok' q'a şot'oxun baki nəsil; P'allun q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Xesron q'a şot'oxun baki nəsil saal K'armi q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Metərluğen, Ruvenaxun baki tayfin boş 43 730 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","9","İz ğarmoğoy s'i Nemuel, Dat'an saal Aviram bakala Eliav hame P'alluni ğarey. Dat'an q'a Aviram israilluğoy boş s'ila amdarxoney. Şoroxey Goraxi tərəf c'ovaki Moiseyaxun q'a Aaronaxun t'ot'opsunen Q'ončuğoy əleyinə ěqeśiyorox. ");
INSERT INTO udi_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Şot'oğoy turin oq'ane oç̌al qı̌bakey, şot'oğone oç̌alen Goraxaxun sagala q'uc'p'ey. İçoğo gərbaki 250 tan isə bok'i bart'undi. Moval israilluğoynak' sa dərse baki. ");
INSERT INTO udi_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ama Goraxi ğarmoğo Q'ončuğon tene galdi. ");
INSERT INTO udi_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeonaxun bakiyorox: Nemuel q'a şot'oxun baki nəsil; Yamin q'a şot'oxun baki nəsil, Yak'in q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Śerax q'a şot'oxun baki nəsil saal Şaul q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Metərluğen, Simeonaxun baki tayfin boş 22 200 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gadaxun bakiyorox: Śefon q'a şot'oxun baki nəsil; Xagi q'a şot'oxun baki nəsil; Şunin q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni q'a şot'oxun baki nəsil; Eri q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod q'a şot'oxun baki nəsil saal Areli q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Metərluğen, Gadaxun baki tayfin boş 40 500 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","İuday ğarmoğoy p'ǒğǒ Er q'a Onan Misirə tağalt'uxun běš, hələ Kənan oç̌ala bakat'an p'uret'uniy. ");
INSERT INTO udi_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Metərluğen, İudaxun bakala tayfa mot'oğoxune eysa: Şela q'a şot'oxun baki nəsil; P'ereś q'a şot'oxun baki nəsil saal Śerax q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","P'ereśaxun isə moroxe bakey: Xeśron q'a şot'oxun baki nəsil saal Xamul q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","İuday tayfin boş 76 500 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","İssak'araxun bakiyorox: T'olay q'a şot'oxun baki nəsil; P'uvay q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaşuv q'a şot'oxun baki nəsil saal Şimron q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Metərluğen, İssak'araxun baki tayfin boş 64 300 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zevulunaxun bakiyorox: Sered q'a şot'oxun baki nəsil; Elon q'a şot'oxun baki nəsil saal Yaxleel q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Metərluğen, Zevulunaxun baki tayfin boş 60 500 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","İosifaxun iz ğarmux Menaşşe q'a Efraimaxun baki tayfooxe eysa. ");
INSERT INTO udi_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Menaşşenaxun bakiyorox: Maxir q'a şot'oxun baki nəsil. Maxiraxun Gileade bakey. ");
INSERT INTO udi_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gileadaxun isə moroxe bakey: İezer q'a şot'oxun baki nəsil; Xeleq' q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel q'a şot'oxun baki nəsil; Şexem q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Şemida q'a şot'oxun baki nəsil saal Xefer q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Xeferi ğar Śelofexadaxun ğar tene bakey, şot'ay Maxla, Noa, Xok'la, Milk'a saal T'irśa s'iyen xuyərmuxe buy. ");
INSERT INTO udi_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Metərluğen, Menaşşenaxun baki tayfin boş 52 700 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efraimaxun bakiyorox: Şut'elax q'a şot'oxun baki nəsil; Bexer q'a şot'oxun baki nəsil saal T'axan q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Şut'elaxi nəsil isə şot'oxun baki ğar Eranaxune eysa. ");
INSERT INTO udi_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Metərluğen, Efraimaxun baki tayfin boş 32 500 tane buy. Morox bito İosifaxun bakiyoroxe. ");
INSERT INTO udi_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Binyaminaxun bakiyorox: Bela q'a şot'oxun baki nəsil; Aşbel q'a şot'oxun baki nəsil; Axiram q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Şefuf q'a şot'oxun baki nəsil saal Xufam q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belay nəsil isə şot'oxun baki ğarmux Ard q'a Naamanaxune eysa: Ard q'a şot'oxun baki nəsil; Naaman q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Metərluğen, Binyaminaxun baki tayfin boş 45 600 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Danaxun baki tayfa iz ğar Şuxamaxune eysa. ");
INSERT INTO udi_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Metərluğen, Şuxamaxun bakit'oğoy say 64 400 taney. ");
INSERT INTO udi_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aşeraxun bakiyorox: İmna q'a şot'oxun baki nəsil; İşvin q'a şot'oxun baki nəsil saal Beria q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriay nəsil şot'oxun baki ğarmux Xever q'a Malk'ielaxune eysa: Xever q'a şot'oxun baki nəsil; Malk'iel q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aşeri Serax s'iyen sa xuyərəl buney. ");
INSERT INTO udi_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Metərluğen, Aşeraxun baki tayfin boş 53 400 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naft'alinaxun bakiyorox: Yaxśeel q'a şot'oxun baki nəsil; Guni q'a şot'oxun baki nəsil; ");
INSERT INTO udi_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeśer q'a şot'oxun baki nəsil saal Şillem q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Metərluğen, Naft'alinaxun baki tayfin boş 45 400 tane buy. ");
INSERT INTO udi_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","İsrailluğoxun siyəyinə haq'eśi bito işq'arxoy say 601 730 taney. ");
INSERT INTO udi_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Oç̌ala me tayfoğoy arane içoğoy saya görə cöybalanan. ");
INSERT INTO udi_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","İz say gele bakala tayfina gele, iz say mal bakala tayfina mal tadanan. Hər tayfina siyəyinə haq'eśi izi saya görə oç̌al tadeğale. ");
INSERT INTO udi_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Mat'u mani oç̌al kofst'una isə çöp bost'unen avabakalnan. Hər tayfinen iz saya görə oç̌al haq'ale. ");
INSERT INTO udi_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Çuresa kala, çuresa mis'ik' - hər tayfina koft'ala paya çöp bost'unen avabakalanan». ");
INSERT INTO udi_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levinaxun bakiyorox moroxe: Gerşon q'a şot'oxun baki nəsil; K'ohat' q'a şot'oxun baki nəsil; Merari q'a şot'oxun baki nəsil. ");
INSERT INTO udi_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levinaxun baki tayfin boş me nəsilxoval buney: Livnin nəsil, Xevroni nəsil, Maxlin nəsil, Muşin nəsil, Goraxi nəsil. K'ohat' Amrami bavaney. ");
INSERT INTO udi_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amrami çuğoy s'i Yok'evedey. Şo leviğoxuney, şorox Misirə bakat'an t'iyane nanaxun bakey. Şot'in Amrameynak' Aarona, Moiseya saal şot'oğoy xunçi Maryamane eçerey. ");
INSERT INTO udi_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaronaxun Nadav, Avihu, Eleazar saal İt'amare bakey. ");
INSERT INTO udi_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadav q'a Avihu isə Q'ončuğoynak' q'urban eçat'an aruğo Şot'ay laxi q'aydinen tet'un bey, şot'aynak'al p'uret'uniy. ");
INSERT INTO udi_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Levin tayfina sa xaşin saal kot'oxun ala bakala bito ğar əyloğoy q'a işq'arxoy say 23 000 taney. Şorox cöyt'un siyəyinə haq'eśey, şot'o görə ki, şot'oğo oç̌ali pay tene kofst'ay. ");
INSERT INTO udi_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Metərluğen, Moiseyen q'a běyinš Aaronen Moavi düzənluğa, Yerixon şəhərəxun ç̌obaç̌o, İordan oqe t'ǒğǒl siyəyinə haq'i israilluyox moroxey. ");
INSERT INTO udi_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Me siyəyin boş Moiseyen q'a běyinš Aaronen Sinay ams'i oç̌ala bǒq'ə̌lpi israilluğoxun sayco tene mandey. ");
INSERT INTO udi_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Axıri Q'ončuğon peney ki, süft'in siyəyinə haq'eśiyorox bito ams'i oç̌ala biyalt'un. Şot'oğoxun Yefunneyi ğar K'alevaxun q'a Nune ğar Yeşuaxun başq'a şuk'k'al dirist' tene mandi. ");
INSERT INTO udi_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","İosifi ğar Menaşşenaxun Maxir, Maxiraxun Gilead, Gileadaxun Xefer, Xeferaxun isə Śelofexade bakey. Me Śelofexadi qo xuyəre buy. Xuyərmoğoy s'iyurxo Maxla, Noa, Xok'la, Milk'a saal T'irśaney. ");
INSERT INTO udi_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Sa ği şorox hari Moiseyi, běyinš Eleazari, ağsaq'q'alxoy q'a dirist' azuk'i běš c'eri, şot'oğo ı̌vel çadıri bağala gane běš pit'un: ");
INSERT INTO udi_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Goraxaxun sagala Q'ončuğoy əleyinə ěqeśit'oğoy boş beşi bava baki tene, şo iz əşp'est'i günaxa görəne ams'i oç̌ala p'ure. İzi ğaral butet'ux. ");
INSERT INTO udi_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","İsə beşi bavay ğar tene bake pi, izi s'i aç̌alane? İzi viçimoğo hetəresa, beşi baval hat'etər k'ule kofst'a! Şot'o yax tada!» ");
INSERT INTO udi_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moiseyen me əşlə hetər həlbsuna Q'ončuğoxun xavare haq'i, ");
INSERT INTO udi_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Şot'inal pine: ");
INSERT INTO udi_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Śelofexadi xuyərmoğon düzt'un nex. İçoğoy bava iz viçimoğoxun barabar k'ule kofst'a. Şot'ay k'ula iz xuyərmoğo tada. ");
INSERT INTO udi_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","İsrailluğo metər upa: əgər sa amdar biyayin, t'e amdariyal ğar butet'uxsa, t'e vədə şot'ay mülk iz xuyərəne c'ovaksa. ");
INSERT INTO udi_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Əgər t'e amdari xuyərəl butet'uxsa, t'e vədə şot'ay viçimoğone c'ovaksa. ");
INSERT INTO udi_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Əgər t'e amdari viçiyal butet'uxsa, t'e vədə mülkə izi bavay viçimoğo tadanan. ");
INSERT INTO udi_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","İzi bavay viçimuxal nu bakayin isə, t'e vədə ən ı̌ša bakala q'erəz sa q'ooma tadanan. Barta mo və̌ynak' həmişəluğ Q'ončuğon Moiseya pi k'anunxoxun soğoq'an baki». ");
INSERT INTO udi_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Q'ončuğon Moiseya pine: «Me Avarim uk'ala buruğxo laki. Zu israilluğo tadala ölkinə sa běğa. ");
INSERT INTO udi_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Hun me ölkin loxol běğalnu, oşa isə vi viçi Aaronallarik' t'e dünyəne, vi bavoğoy t'ǒğǒl tağalnu. ");
INSERT INTO udi_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Şot'aynak' ki, və̌n Śin ams'i oç̌ala Bezi əyitə əməltenanbi, Qadeşa bakala Meriva xene t'ǒğǒl Bez əleyinə ěqeśi azuk'i běš Bezi ı̌velluğa ç̌oyel tenan c'evk'i». ");
INSERT INTO udi_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moiseyen Q'ončuğo pine: ");
INSERT INTO udi_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","«Barta iz boş nəfəs bakala bito elmuxlat'oğoy Buxačux Q'ončuğon me azuk'eynak' běš c'eri şot'oğo iz bač'anexun taşes bakala sa amdarq'an c'ək'p'i. Barta Q'ončuğoy azuk' çobansuz sürü k'inək' maq'an mandi». ");
INSERT INTO udi_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Q'ončuğon Moiseya pine: «Nune ğar Yeşua vi t'ǒğǒl k'alpi vi kula iz bel laxa, şot'ost'a me əşlə bes bakala urufe bu. ");
INSERT INTO udi_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Şot'o běyinš Eleazari q'a bütüm azuk'i běš eçeri memaçağ vi bi me əşlə şot'o tapşurba. ");
INSERT INTO udi_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Barta israilluğon va bakala hörmətə şot'oval ak'est'i hər əşləst'a şot'o ǔmǔxlaxeq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Q'ončuğoy əyitə isə şot'o běyinš Eleazaren uk'ale. Şot'in iz samci běyinši döşlin boş bakala Urim uk'ala ǰěna bosi Q'ončuğoy q'ərara avabakale, metərluğenal Yeşua q'a bütüm israilluyox t'e q'əraren arśi-hayzalt'un». ");
INSERT INTO udi_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moiseyenal Q'ončuğon içu əmirbi k'inək' bine: Yeşua běyinš Eleazari q'a dirist' azuk'i běš eçeri ");
INSERT INTO udi_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","iz kula şot'ay bele laxi, metərluğenal Q'ončuğon içu pi k'inək' memaçağ izi ozane bakala əşlə şot'one tapşurbi. ");
INSERT INTO udi_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«İsrailluğo upa ki, Zaynak' hər iz vədə eğat'an bok'ospsuni q'urbanluğ pay eşt'una eyexun maq'at'un c'evk'i. Şot'oğoy bok'uni ad Za irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Şot'oğo upa ki, Zaynak' hər ği bok'ospsuni q'urban k'inək' p'ə̌ dənə sa usenin salamat q'uzi eçalat'un. ");
INSERT INTO udi_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Q'uzin sunt'u savaxt'an, t'e sunt'u isə běğ batk'at'anq'at'un q'urban eçeri. ");
INSERT INTO udi_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Hər q'urbanluğ q'uzinaxun sagala iz taxıli payal eçalanan, mo hine bip' payaxun sa pay zeytuni c'əyin lapi efin vis' payaxun sa pay xarine. ");
INSERT INTO udi_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Mo Q'ončuğon Sinay buruğo hər ği šamseynak' bürüşi, iz bok'uni aden İçu irəzibala q'urbane. ");
INSERT INTO udi_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Hər šameğala q'uzinaxun sagala iz śipseynak' bakala payal eçanan, mo sa hine bip' payaxun sa pay finağoybala ǔğǔn bakalane. Şot'o ı̌vel çadıri běš Q'ončuğoynak' śipi bok'osp'anan. ");
INSERT INTO udi_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","P'ə̌mci q'uzina běğ batk'at'an šampanan. Şot'oval savaxt'an šameśi q'urbanallarik' taxıli q'a śipseynak' bakala payaxun sagala eçanan. Me eçala payurxoy bok'uni ad Q'ončuğo irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Şamat' ğineyal p'ə̌ dənə sa usenin salamat q'uzi q'urban šamk'alat'un. Q'urbanaxun sagala taxıli pay k'inək' bakala c'əyin lapi efin qo payaxun sa pay xuri berxeśi xarina q'a śipseynak' bakala payal eçanan. ");
INSERT INTO udi_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Mo hər ği śipseynak' bakala payaxun sagala eçala q'urbanxoxun cöy, hər Şamat' ğine šameğala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Q'ončuğoynak' hər təzə xaş c'eğat'anal bok'ospsuni q'urbanxo šampanan. Šameğala heyvanxo p'ə̌ dənə salamat arak', sa q'oç eğel saal vǔğ dənə sa usenin q'uzi bakalane. ");
INSERT INTO udi_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Hər šameğala arak'axun sagala eçala taxıli pay zeytuni c'əyin lapi sa efin vis' payaxun xib pay xuri berxeśi xari, q'oç eğelaxun eçala pay sa efin qo payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xari, ");
INSERT INTO udi_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","hər q'uzinaxun sagala eçala taxıli pay isə sa efin vis' payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xariq'an baki. Me bok'ospsuni q'urbanxoy bok'uni ad Q'ončuğo irəzibala ade. ");
INSERT INTO udi_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Şot'oğoxun sagala śipseynak' bakala payal eçalat'un: hər q'urbanluğ arak'axun sagala qı̌ hin fi, q'oç eğelaxun sagala sa hine xib payaxun sa pay fi, hər q'urbanluğ q'uzinaxun sagala isə sa hine bip' payaxun sa pay fi. Mo usenast'a hər təzə xaş c'eğat'an eçala bok'ospsuni q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Śipseynak' bakala payaxun sagala hər ği šameğala q'urbanxoxun cöy, Q'ončuğoynak' günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šamk'alanan. ");
INSERT INTO udi_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Samci xaşe bip'es's'emci ğine Q'ončuğoyC'ovaksuni axsibaye. ");
INSERT INTO udi_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Me xaşe qos's'emci ğine isə Ə̌yinsuz šume axsibaye burqesa: vǔğ ği ə̌yinsuz šum ukalanan. ");
INSERT INTO udi_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","T'e ğimxoy samci ğine Za bul k'os'bseynak' bakala giresun c'ovakest'anan, q'erəz sa əşəl ma biq'anan. ");
INSERT INTO udi_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Q'ončuğoynak' bok'ospsuni pay k'inək' bok'ospsuni q'urbanxo eçanan: p'ə̌ dənə arak', sa q'oç eğel saal vǔğ dənə sa usenin q'uzi. Me heyvanxo bito salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Hər šameğala arak'axun sagala eçala taxıli pay zeytuni c'əyin lapi sa efin vis' payaxun xib pay xuri berxeśi xari, q'oç eğelaxun eçala pay sa efin qo payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xari, ");
INSERT INTO udi_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","hər q'uzinaxun sagala eçala taxıli pay isə sa efin vis' payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xariq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Mot'oxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan ki, şot'ay p'iyen ef günaxi toya ödəyinşi bakane. ");
INSERT INTO udi_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Me q'urbanxo hər savaxt'an eçala q'urbanxoxun cöy eçala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Metərluğen, me vǔğ ğine hərt'ust'a śipseynak' bakala payaxun sagala eçala q'urbanxoxun cöy, me Bez pi q'urbanxoval šamk'alanan. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Barta vǔğǔmci ğineyal Za bul k'os'bseynak' bakala giresunxq'an baki, me ği q'erəz sal sa əş ma biq'anan. ");
INSERT INTO udi_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Exe axsibayast'a Q'ončuğoynak' təzə arumaxun nübərluğ pay eçala ğine Q'ončuğo bul k'os'bseynak' bakala giresun c'ovakest'anan. Me ği q'erəz sal sa əş ma biq'anan. ");
INSERT INTO udi_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Q'ončuğoynak' bok'ospsuni q'urbanxo - p'ə̌ dənə arak', sa q'oç eğel saal vǔğ dənə sa usenin ərkəy q'uzi eçanan. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Hər šameğala arak'axun sagala eçala taxıli pay zeytuni c'əyin lapi sa efin vis' payaxun xib pay xuri berxeśi xari, q'oç eğelaxun sagala eçala pay sa efin qo payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xari, ");
INSERT INTO udi_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","hər šameğala q'uzinaxun sagala eçala taxıli pay isə sa efin vis' payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xariq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Mot'oxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan ki, şot'ay p'iyen ef günaxi toya ödəyinşi bakane. ");
INSERT INTO udi_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Me q'urbanxo q'a şot'oğoxun sagala śipseynak' bakala payurxo eçat'an efi hər ği taxıli payaxun sagala eçala q'urbanxoval eyexun ma c'evk'anan. Bito šameğala q'urbanluğ heyvanxo salamat heyvanxo bakalane». ");
INSERT INTO udi_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Vǔğǔmci xaşe samci ğine Za bul k'os'bseynak' bakala giresun c'ovakest'anan, q'erəz sal sa əşəl ma biq'anan. Me ği və̌ynak' mǔq'inaxun düzbi şeyp'ur fark'ala ği bakale. ");
INSERT INTO udi_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Q'ončuğoynak' bok'ospsuni q'urbanxo - salamat sa dənə arak', sa q'oç eğel saal vǔğ dənə sa usenin ərkəy q'uzi eçanan. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Hər šameğala arak'axun sagala eçala taxıli pay zeytuni c'əyin lapi sa efin vis' payaxun xib pay xuri berxeśi xari, q'oç eğelaxun eçala pay sa efin qo payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xari, ");
INSERT INTO udi_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","hər šameğala q'uzinaxun sagala eçala taxıli pay isə sa efin vis' payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xariq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mot'oğoxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan ki, şot'ay p'iyen ef günaxi toya ödəyinşi bakane. ");
INSERT INTO udi_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Me q'urbanxo eçat'an efi hər ği šamk'ala q'urbanxo q'a təzə xaş c'eğat'an šamk'ala q'urbanxo saal şot'oğoxun sagala eçala śipseynak' bakala q'a taxıli payurxo eyexun ma c'evk'anan. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Vǔğǔmci xaşe vis'imci ğineyal Za bul k'os'bseynak' giresun c'ovakest'anan. Me ği sal əş ma biq'anan, və̌x ukunaxunal, q'erəz şeymoğoxunal bot'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Q'ončuğoynak' bok'ospsuni q'urbanxo - sa arak', sa q'oç eğel saal vǔğ dənə sa usenin ərkəy q'uzi šampanan. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Hər šameğala arak'axun sagala eçala taxıli pay zeytuni c'əyin lapi sa efin vis' payaxun xib pay xuri berxeśi xari, q'oç eğelaxun eçala pay sa efin qo payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xari, ");
INSERT INTO udi_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","hər šameğala q'uzinaxun sagala eçala taxıli pay isə sa efin vis' payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xariq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mot'oğoxun cöy, iz p'iyen ef günaxxoy toya ödəyinşbseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo šamk'at'an efi hər ği izi śipseynak' bakala payaxun q'a taxıli payaxun sagala eçala q'urbanxo saal ef günaxxo os'kseynak' šameğala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Vǔğǔmci xaşe qos's'emci ğine Za bul k'os'bseynak' giresun c'ovakest'anan, q'erəz sa əşəl ma biq'anan. Q'ončuğoy s'iyal vǔğ ği axsibay c'ovakest'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Q'ončuğoynak'bok'ospsuni q'urbanxo - xibes's'e dənə arak', p'ə̌ dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uzi šampanan. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Hər šameğala arak'axun sagala eçala taxıli pay zeytuni c'əyin lapi sa efin vis' payaxun xib pay xuri berxeśi xari, hər q'oç eğelaxun eçala pay sa efin qo payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xari, ");
INSERT INTO udi_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","hər q'uzinaxun sagala eçala taxıli pay isə sa efin vis' payaxun sa pay zeytuni c'əyin lapi xuri berxeśi xariq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mot'oxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan ki, şot'ay p'iyen ef günaxi toya ödəyinşi bakane. Me q'urbana eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Axsibayi p'ə̌mci ğine p'as's'e dənə arak', p'ə̌ dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uzi šampanan. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçalanan. ");
INSERT INTO udi_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Mot'oğoxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Axsibayi xibimci ğine sas's'e dənə arak', p'ə̌ dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uzi šampanan. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçalanan. ");
INSERT INTO udi_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mot'oğoxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Axsibayi bip'imci ğine vis' dənə arak', p'ə dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uzi šampanan. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçalanan. ");
INSERT INTO udi_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Mot'oxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Axsibayi qomci ğine vuy dənə arak', p'ə̌ dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uzi šampanan. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçalanan. ");
INSERT INTO udi_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Mot'oğoxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Axsibayi ǔqǔmci ğine muğ dənə arak', p'ə̌ dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uziyal šampanan. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçalanan. ");
INSERT INTO udi_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Mot'oğoxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Axsibayi vǔğǔmci ğine vǔğ dənə arak', p'ə̌ dənə q'oç eğel saal bip'es's'e dənə sa usenin ərkəy q'uzi šampanan. Šameğala bito q'urbanluğ heyvanxo salamat heyvanxo bakalane. ");
INSERT INTO udi_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçalanan. ");
INSERT INTO udi_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Mot'oğoxun cöy, ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Muğumci ği axsibayi çark'ala ğine. Me ğine Za bul k'os'bseynak' giresun c'ovakest'anan, q'erəz sa əşəl ma biq'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Q'ončuğoynak'bok'ospsuni q'urbanxo - sa arak', sa q'oç eğel saal vǔğ dənə sa useni ərkəy q'uzi eçanan. Šameğala q'urbanluğ heyvanxo bito salamat heyvanxo bakalane. Mo iz bok'uni aden Q'ončuğo irəzibseynak' bakala q'urbanxone. ");
INSERT INTO udi_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Hər arak', q'oç eğel saal q'uzinaxun sagala iz taxıli q'a śipseynak' bakala payal eçanan. ");
INSERT INTO udi_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mot'oğoxun cöy ef günaxxo os'kseynak' bakala q'urban k'inək' sa ərkəy keçiyal šampanan. Me q'urbanxo eçat'an hər savaxt'an içoğoy taxıli q'a śipseynak' bakala payurxoxun sagala eçala q'urbanal eyexun ma c'evk'anan. ");
INSERT INTO udi_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Me šameğala heyvanxoval, içoğoxun sagala eçala taxıli q'a śipseynak' bakala payurxoval, serluği q'urbanxoval - morox bito axsibayxost'a eçala q'urbanxone. Efi niyətp'i nəəl ef ük'exun c'ovaksuna görə šameğala q'erəz q'urban buvə̌xsa, şot'oğo cöy šamk'alanan». ");
INSERT INTO udi_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moiseyenal Q'ončuğon içu əmirbi hər şeya israilluğo p'ap'esebi. ");
INSERT INTO udi_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moiseyen israilluğoy boş bakala tayfoğoy kalat'oğo pine: «Q'ončuğon metəre əmirbsa: ");
INSERT INTO udi_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","\"Əgər sa işq'aren Q'ončuğo elasp'i het'unesa əyite tadesa nəəl k'ənesa niyətebesa, iz əyitin loxol çurk'alane. Barta şot'in iz ǰomoxun c'eri hər əyitə bex p'ap'esp'eq'an. ");
INSERT INTO udi_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Əgər işq'ara nu taśi sa xuyəren iz bavay k'oya bakala vədine Q'ončuğo elasp'i het'unesa əyit tadayin nəəl k'ənesa niyətp'ayin, ");
INSERT INTO udi_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","iz bavanal me barada ibaki içu hik'k'al nu uk'ayin, me xuyərəl iz pi əyitin loxol çurk'alane. ");
INSERT INTO udi_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ama əgər iz bavan me barada ibaki şot'ay əyit tadit'oğo bex p'ap'espsuna icaza nu tadayin, t'e vədə me xuyər iz pi əyitəxun c'eyes banekon. Buxačuğon şot'ay iz tadi əyitəxun c'eysuna pis tene běğal, şot'o görə ki, t'e xuyərə iz bavan tene barti. ");
INSERT INTO udi_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Əgər sa xuyər işq'ara tağat'an şot'ay ozane Q'ončuğo elasp'i tadi əyit nəəl sa niyəte busa, ");
INSERT INTO udi_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","iz taśi işq'arenal me barada ibaki şot'o hik'k'al nextenesa, t'e vədə me xuyər iz pi əyitin loxol çurk'alane. ");
INSERT INTO udi_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ama əgər işq'aren me barada ibaki şot'ay əyit tadit'oğo bex p'ap'espsuna icaza nu tadayin, t'e vədə me xuyər iz pi əyitəxun c'eyes banekon. Buxačuğon şot'ay iz tadi əyitəxun c'eysuna pis tene běğal, şot'o görə ki, t'e xuyərə iz işq'aren tene barti. ");
INSERT INTO udi_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Süpür nəəl işq'araxun c'eri sa çuğon Q'ončuğo elasp'i het'unesa əyit tadayin, şo iz tadi əyiti loxol çurk'alane. ");
INSERT INTO udi_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Əgər işq'ara bakala sa çuğon iz işq'ari k'oya bakala vədine Q'ončuğo elasp'i het'unesa əyit tadayin nəəl k'ənesa niyətp'ayin, ");
INSERT INTO udi_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","iz işq'arenal me barada ibaki içu hik'k'al nu uk'ayin, me çuux iz pi əyiti loxol çurk'alane. ");
INSERT INTO udi_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ama əgər iz işq'aren me barada ibaki şot'ay əyit tadit'oğo bex p'ap'espsuna icaza nu tadayin, t'e vədə me çuux iz pi əyitəxun c'eyes banekon. Buxačuğon şot'ay iz tadi əyitəxun c'eysuna pis tene běğal, şot'o görə ki, t'e çuğo iz işq'aren tene barti. ");
INSERT INTO udi_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","İşq'ara bakala çuğoy Q'ončuğo elasp'i tadi hər əyitə nəəl içu het'uxunesa efsuna iz işq'aren icaza tadesal banekon, nu tadesal. ");
INSERT INTO udi_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ama əgər işq'aren iz çuğoy Q'ončuğo tadi əyitin barada ibaki ğine şot'o hik'k'al tene nexesa, metər bsunen şot'ay əyit tadit'oğo bex p'ap'espsuna icaza tadine baksa. Mot'o t'e işq'aren me barada ibaki, ama iz çuğo hik'k'al nu upsunene ak'est'a. ");
INSERT INTO udi_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Əgər işq'aren iz çuğoy Q'ončuğo tadi əyitin barada ibakit'uxun sa hema vədə oşa izi nu irəzi baksuna avabakest'ayin, t'e vədə Q'ončuğo tadi əyitin loxol nu çurpsuna görə coğaba için tadale\"». ");
INSERT INTO udi_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Mo işq'areynak' q'a iz çuğoynak', bavaynak' q'a iz k'oya bakala işq'ara nu taśi xuyəreynak' bakala, Q'ončuğon Moiseya tadi q'aydooxe. ");
INSERT INTO udi_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Q'ončuğon Moiseya metəre pi: ");
INSERT INTO udi_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Midyanluğoy israilluğo bi pisluği həyifə şot'oğoxun haq'a. Oşa p'uri t'e dünyəne, vi bavoğoy t'ǒğǒl tağalnu». ");
INSERT INTO udi_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moiseyenal azuk'a pine: «Azuk'i boş bakala işq'arxoxun davina c'eyseynak' sa q'oşun həzirbanan. Barta midyanluğoy loxol taśi Q'ončuğoy əleyinə c'eysuni həyifə şot'oğoxun haq'eq'at'un. ");
INSERT INTO udi_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Hər tayfinaxun sa hazar tan yaq'abanan». ");
INSERT INTO udi_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Metərluğen, israilluğon hər tayfinaxun sa hazar işq'ara - bito sagala p'as's'e hazarluğ sa q'oşuna davina c'eyseynak't'un həzirbi. ");
INSERT INTO udi_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moiseyen şot'oğoy loxol běyinš Eleazari ğar P'inexasa kalo laxi davinane yaq'abi, Eleazarenal ı̌vel ganu bakala şeymoğoxun q'a şeyp'urxo ext'i yaq'ane baft'i. Me şeyp'urxo farpi davina c'eğala q'oşuni k'ə bsuna avabakest'eynak'ey. ");
INSERT INTO udi_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Hametər, Q'ončuğon Moiseya əmirbi k'inək' şorox midyanluğoy loxol taśi şot'oğoy bito işq'arxo k'as'p'i śit'unpi. ");
INSERT INTO udi_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","P'urit'oğoy boş Midyani qo padçağ - Evi, Rek'em, Śur, Xur saal Reval buney. Beori ğar Bileamal israilluğoy q'ılıncaxun p'urit'oğoy boşey. ");
INSERT INTO udi_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","İsrailluğon bito midyanlu çupuxxo, əyloğo, şot'oğoy heyvanxoy sürüğo q'a içoğoy bakal nu bakala hər şeya içoğoy kiyelt'un badi. ");
INSERT INTO udi_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Midyanluğo yəşəyinşala bito şəhərmoğo q'a içoğoy çurk'ala ganxo bəc'ük't'undi. ");
INSERT INTO udi_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","İsrailluğon içoğoy kiyel badi hər şeya - amdarxo, heyvanxo, şot'oğoy bito mal-dövlətə ext'undi. ");
INSERT INTO udi_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Şot'oğon davabi midyanluğo tat'unşeri, içoğoy kiyel badi bito me amdarxo q'a şeymoğoval Moiseyi, běyinš Eleazari saal dirist' azuk'i běšt'un eçeri. Azuk' Moavi düzənluğa, İordan oqe t'ǒğǒl, Yerixon şəhəri běš düzbi çurk'ala galaney. ");
INSERT INTO udi_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moisey, běyinš Eleazar saal azuk'i bito ağsaq'q'alxo içoğoy çurk'ala ganuxun q'oşuni běšt'un c'eri. ");
INSERT INTO udi_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moisey davinaxun qaybaki q'oşuni kalat'oğoy - hazartani q'a sabaç̌tani kalat'oğoy loxol gele əcuğluney. ");
INSERT INTO udi_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Şot'in pine: «Het'aynak'nan çupuxxo bitova dirist' efi? ");
INSERT INTO udi_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Korox teney ki, Bileami əyiten beşi işq'arxo Q'ončuğoxun ə̌xilbi P'eora bakala binik'-buxačuğo bul k'os'best'alo? Kot'oğo görəne azuk'al k'as'eśi! ");
INSERT INTO udi_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","İsə bütüm ğar əyloğo q'a işq'araxun ı̌šaluğbi çupuxxo besp'anan. ");
INSERT INTO udi_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ama işq'araxun hələ ı̌šaluğ nu bi xuyərmoğo galmadanan. ");
INSERT INTO udi_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Ef boş isə amdar besp'i nəəl iz kul meyidə laft'i şu bunesa - çuresa azuk'axun bakala davina taśi işq'arq'an baki, çuresa Midyanaxun ext'i eçeri xuyər - vǔğ ği azuk'i çurk'ala ganuxun t'ǒǒx c'eğalane. Şot'oğon içoğo xib ğinaxun saal vǔğ ğinaxun oşa pakbalat'un. ");
INSERT INTO udi_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Bito paltarxo, keçin t'olaxun q'a xayaxun düzbaki nəəl durut'axun bakala bito şeymoğoval pakbanan». ");
INSERT INTO udi_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Běyinš Eleazaren davinaxun qaybaki əsk'ərxo pine: «Mone, Q'ončuğon Moiseyeynak' me q'aydoğone laxi: ");
INSERT INTO udi_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","bito q'ızıla, gümüşə, tunca, dəmirə, q'alaya q'a q'urq'uşuna ");
INSERT INTO udi_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","- aruğo nu bok'ala k'ə bunesa - bitova aruğoxun q'a pakbala xenaxun c'ovakest'anan. Mot'oxun oşa şorox pak bakale. Aruğo bok'ala şeyurxo isə saycə xenen pakbanan. ");
INSERT INTO udi_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Vǔğǔmci ğine ef paltarxo os'k'it'uxun oşa ef çurk'ala gala qaybakes banankon». ");
INSERT INTO udi_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Běyinš Eleazaraxun q'a israilluğoy tayfoğoxun c'ək'eśi kalat'oğoxun sagala Midyanaxun eçeri bito amdarxo q'a heyvanxo bǒq'ə̌lpa. ");
INSERT INTO udi_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Oşa mot'oğo bitova p'ə̌ gala - davina taśit'oğoy q'a nu taśit'oğoy arane - barabar cöyba. ");
INSERT INTO udi_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Davina taśit'oğo koft'i payaxun hər qobaç̌ amdaraxun soğo saal hər qobaç̌ bul belinaxun, elemaxun q'a eğelaxun sa bul Q'ončuğoy paye. ");
INSERT INTO udi_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Şot'oğoxun Q'ončuğoynak' ext'i me paya běyinš Eleazara tadanan. ");
INSERT INTO udi_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Davina nu taśi israilluğo koft'i payaxun isə hər əlli amdaraxun sunt'u saal hər əlli bul belinaxun, elemaxun q'a eğelaxun sa bula ext'a. Mot'o Q'ončuğoyı̌vel çadıra běğala leviğo tada». ");
INSERT INTO udi_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moiseyen q'a běyinš Eleazarenal Q'ončuğon Moiseya pi k'inək' bit'un. ");
INSERT INTO udi_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Metərluğen, əsk'ərxon Midyanaxun 675 000 eğel q'a keçi, ");
INSERT INTO udi_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72 000 beli, ");
INSERT INTO udi_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61 000 elem, ");
INSERT INTO udi_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","saal 32 000 hələ işq'araxun nu ı̌šaluğbi xuyərt'un eçeri. ");
INSERT INTO udi_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Mot'oğoxun davina taśit'oğo 337 500 bul eğel q'a keçi ");
INSERT INTO udi_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","(mot'oğoxun 675 bul Q'ončuğoy payey), ");
INSERT INTO udi_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36 000 bul beli (me beliğoxun 72 bul Q'ončuğoy payey), ");
INSERT INTO udi_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30 500 bul elem (me elemxoxun 61 bul Q'ončuğoy payey), ");
INSERT INTO udi_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","saal 16 000 amdare koft'i. Me amdarxoxun 32 tan Q'ončuğoy payey. ");
INSERT INTO udi_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moiseyenal şot'oğoxun Q'ončuğoynak' ext'i me paya, içu pi k'inək' běyinš Eleazarane tadi. ");
INSERT INTO udi_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Moiseyen davina nu taśit'oğoynak' cöybi pay, ");
INSERT INTO udi_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","mandi israilluğo koft'i pay isə money: 337 500 bul eğel q'a keçi, ");
INSERT INTO udi_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36 000 bul beli, ");
INSERT INTO udi_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30 500 bul elem, ");
INSERT INTO udi_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","saal 16 000 amdar. ");
INSERT INTO udi_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Moiseyen Q'ončuğon içu pi k'inək' me mandi israilluğo koft'i payaxun hər əlli bul heyvanaxun sa bula saal hər əlli amdaraxun sa amdara cöybi Q'ončuğoyı̌vel çadıra běğala leviğone tadi. ");
INSERT INTO udi_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Q'oşuni kalat'oğon - hazartani q'a baç̌tani kalat'oğon Moiseyi t'ǒğǒl hari pit'un: ");
INSERT INTO udi_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","«Yan, me vi k'ulurxon, beşi kiin oq'a bakala əsk'ərxo bǒq'ə̌lyanpi. Şot'oğoxun aç̌iyo butene. ");
INSERT INTO udi_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","İsəəl mone, beşi elmoğoy toya ödəyinşseynak' Q'ončuğoynak' Midyanaxun eçeri q'ızılxoyan eşt'a - ə̌mel q'a kiyel lavk'ala q'oxlangxo, boğoç̌alxo, sırığanxo saal śep'urxo». ");
INSERT INTO udi_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moiseyen q'a běyinš Eleazarenal bito me q'ızıli şeymoğo şot'oğoxun ext'undi. ");
INSERT INTO udi_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Hazartani q'a baç̌tani kalat'oğon Q'ončuğoynak' eçeri bito me q'ızıli bı̌hiluğ 16 750 şek'eley. ");
INSERT INTO udi_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Adi əsk'ərxoy eçeri q'ızıl isə içoğone mandi. ");
INSERT INTO udi_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Hametər, Moiseyen q'a běyinš Eleazaren hazartani q'a baç̌tani kalat'oğoxun q'ızıla ext'i ı̌vel çadırat'un laxi. İsrailluğon me q'ızıli loxol běği Q'ončuğoy içoğoy tərəf baki içoğoy elmoğo hetər çark'est'una eyex efalat'uniy. ");
INSERT INTO udi_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Azuk'i boş Ruveni q'a Gade nəsiləxun bakalt'oğoy heyvanxo geleney. Şot'oğonal Yaśer q'a Gilead uk'ala oç̌alxo ak'at'an, me ganxoy heyvan otarişbseynak' şaat' sa ga baksun içoğoy piyexun tene t'it'eri. ");
INSERT INTO udi_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Şorox Moiseyi, běyinš Eleazari saal azuk'i boş kalo c'ək'eśit'oğoy t'ǒğǒl hari pit'un: ");
INSERT INTO udi_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","«Q'ončuğon beş kiyel tadi me oç̌ala bakala At'arot', Dion, Yaśer, Nimra, Xeşbon, Eleale, Sevam, Nevo saal Beon şaat' heyvan otarişes bakala ganxone. Me vi k'ulurxoyal, avanu ki, heyvan gelene». ");
INSERT INTO udi_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Oşa saal pit'un: «Əgər yaynak' mot'o gele ten aksasa, me oç̌ala yax tada. Barta me gaq'an beşi baki, İordan oqe t'e tərəf yax ma taşa». ");
INSERT INTO udi_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moiseyen pine: «Yəni dirist' azuk'en taśi davabale, və̌n isə memiya arśalnan? ");
INSERT INTO udi_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Het'aynak'nan israilluğo Q'ončuğon içoğo tadi ölkinə taysunaxun çaxevksa? ");
INSERT INTO udi_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ef bavoğonal, Zu şot'oğo Kadeş-Barnea şəhərexun t'e oç̌ala běğsa yaq'abat'an haketərt'un bey. ");
INSERT INTO udi_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Şorox Eşk'ol dərənel śirik' taśi t'e oç̌ala bět'unği, ama oşa hari t'iya taysunaxun, Q'ončuğon içoğo tadi t'e ölkinə baysunaxun azuk'a qoşt'unbi. ");
INSERT INTO udi_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","T'e vədəne Q'ončuğoy əcuğ bəc'ük'eśi, Şot'inal elasp'i pine ki, ");
INSERT INTO udi_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","\"Zaxun ç̌o taradi Misirəxun c'erit'oğoxun sayco, q'a saal q'a yəşəxun ala bakalt'oğoxun sayco, Zu Avrama, İsaak'a saal İak'ova əyit tadi t'e oç̌ala bağalatene! ");
INSERT INTO udi_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Saycə Bezi əyitəxun nu c'eri k'enizlu Yefunneyi ğar K'alevaxun q'a Nune ğar Yeşuaxun başq'a\". ");
INSERT INTO udi_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Hametərəl Q'ončuğoy əcuğon israilluğoy loxol bineq'i. Şot'in azuk'a q'ırx usen, Q'ončuğoy piyes günax ak'eśi me əşlə biq'i nəsil əfçibakamin ams'i oç̌ala fırıpesedi. ");
INSERT INTO udi_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","İsəəl mone, ef bavoğoxun q'oş tenan manst'a! Və̌xlarik' günaxkərxoxun baki günaxkərxone Q'ončuğoy əcuğo p'urum me azuk'i loxol śiye! ");
INSERT INTO udi_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Və̌n həysə Q'ončuğoxun ç̌o taradaynan, Şot'in p'urum azuk'a me ams'i oç̌ala efi bašaybale! Və̌n me azuk'a əfçibalnan!» ");
INSERT INTO udi_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","T'e vədə Ruveni q'a Gade nəsiləxun bakalorox Moiseyi běš c'eri pit'un: «Beşi fikir t'etərey ki, miya beşi heyvanxoynak' ağılxo, ailoğoynak'al şəhərmux biq'i şot'oğo memiya efen. ");
INSERT INTO udi_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Yan isə taśi israilluğoxun sagala şot'oğo əyit tadeśi oç̌ala badamin davabalyan. Yan davina bakala vədine beşi əylox q'a çupuxxo q'alala şəhərmoğo, me oç̌ali amdarxoy kul nu p'ap'ala sa gala bakayt'un, yanal arxayinyan bakon. ");
INSERT INTO udi_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","İsrailluğoxun hərt'in içu koft'ala oç̌ali paya haq'amin beşi k'ojurxo teyan qaybakal. ");
INSERT INTO udi_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Yan İordan oqe t'e tərəf oç̌al teyan ext'al, şot'o görə ki, ene miya - İordan oqe běğ c'eğalaç tərəf bakala oç̌alxoxunyan ext'i». ");
INSERT INTO udi_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moiseyen şot'oğo metəre coğab tadi: «Əgər və̌n ef pit'ullarik' bi Q'ončuğoy s'iyen davina tağaynan, ");
INSERT INTO udi_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","İordani t'e tərəfəl Q'ončuğon İz düşmənxoxun oç̌alxo ext'i İz azuk'a tadamin davabaynan, ");
INSERT INTO udi_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","t'e vədə t'e ölkin amdarxon Q'ončuğo taşevk'it'uxun oşa və̌n ef k'ojurxo qaybakes banankon. Metər və̌n Q'ončuğoy q'a azuk'i běš ef borca ödəyinşi bakalnan, Q'ončuğonal və̌x me oç̌ala İz xeyir-bərəkətəxun sagala tadale. ");
INSERT INTO udi_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ama əgər ef pi əyitin loxol nu çurk'aynan, t'e vədə Q'ončuğoy piyes günax əşp'est'i bakalnan, əşp'est'i günaxi cazinal zap'k'alnan. ");
INSERT INTO udi_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","İsə takinan ef çupux-əyloğoynak' bakala şəhərmoğo q'a heyvanxoynak' bakala ağılxo biq'anan, ama efi tadi əyiti loxol çurpanan». ");
INSERT INTO udi_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gade q'a Ruveni nəsiləxun bakalt'oğon Moiseya pit'un: «Barta beş ağan pit'ullarik'q'an baki, yan vi k'ulurxoyan! ");
INSERT INTO udi_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Beşi çupux-əylox q'a bütüm heyvanxo miya - Gileada biq'i şəhərmoğo mandalt'un. ");
INSERT INTO udi_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Yan isə hun, beşi ağan, yax əmirbi k'inək' İordan oqe t'e tərəf, Q'ončuğoy s'iyen davina tağalyan». ");
INSERT INTO udi_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moiseyenal běyinš Eleazara, Nune ğar Yeşua saal israilluğoy tayfoğoxun c'ək'eśi kalat'oğo əmir tadi pine: ");
INSERT INTO udi_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«Əgər Gade q'a Ruveni nəsiləxun bakalt'oğon İordan oqe t'e tərəf c'ovaki Q'ončuğoy s'iyen davabayt'un, t'e vədə Q'ončuğon t'e oç̌alxo ef kiyel tadit'uxun oşa, şot'oğoy oç̌ali paya memiin - Gileadaxun tadanan. ");
INSERT INTO udi_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ama əgər və̌xun sagala davina nu tağayt'un, şot'oğoyal oç̌ali paya Kənanaxun tadanan». ");
INSERT INTO udi_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gade q'a Ruveni nəsiləxun bakalt'oğon pit'un: «Barta Q'ončuğon me vi k'ulurxo əmirbi k'inək'q'an baki. ");
INSERT INTO udi_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Yan oqe t'e tərəf bakala Kənan oç̌ala taśi Q'ončuğoy s'iyen davabalyan, yax koft'ala oç̌ali paya isə memiin, İordan oqe me tərəfəxun tadalnu». ");
INSERT INTO udi_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Metərluğen, Moiseyen emorluğoy padçağ Sixoni q'a Başani padçağ Oge kiin oq'a bakala bito oç̌alxo, içoğoy şəhərmoğoxun sagala Gade q'a Ruveni nəsiləxun bakalt'oğo saal İosifi ğar Menaşşeni nəsiləxun bakalt'oğone tadi. ");
INSERT INTO udi_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gade nəsiləxun bakalt'oğon Divon, At'arot', Aroer, ");
INSERT INTO udi_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","At'rot'-Şofa, Yazer, Yok'bohan, ");
INSERT INTO udi_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet'nimra saal Bet'haran uk'ala şəhərmoğo, iz hərrəmine bakala barina təzədən biq'i içoğoy heyvanxoynak'al ağılxot'un düzbi. ");
INSERT INTO udi_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruveni nəsiləxun bakalt'oğon isə Xeşbon, Eleale, Giryat'ayim, ");
INSERT INTO udi_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nevo saal Baal-Meon uk'ala şəhərmoğoy hərrəminət'un təzədən biq'i. Nevo saal Baal-Meon şəhərmoğoy s'iyurxoval badalt'unbi. Şot'oğon Sivma şəhərəl təzədən bit'unq'i. Metərluğen, bito me təzədən biq'eśi şəhərmoğoy s'iyurxo badalt'unbsay. ");
INSERT INTO udi_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Menaşşeni ğar Maxiri nəsiləxun bakalorox isə Gileadat'un baśi. Şot'oğon t'e oç̌ala kiyel badi t'iya bakala emorluğo şəp't'unśi. ");
INSERT INTO udi_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Hametər, Moiseyen Gileada Menaşşeni ğar Maxiri nəsiləxun bakalt'oğo tanedi, şoroxal baśi t'iya art'unśi. ");
INSERT INTO udi_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Menaşşeni nəsiləxun bakala Yairen miya sa hema ayizal ext'i şot'oğo \"Yairi ayizmux\" s'ine tadi. ");
INSERT INTO udi_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Novaxen isə Qenat şəhərəne izi hərrəmine bakala ayizmoğoxun sagala ext'i şot'o iz s'iya, yəni \"Novax\" s'i tadi. ");
INSERT INTO udi_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Moiseyen q'a Aaronen israilluğo dəst'inen Misirəxun c'evk'it'uxun oşa azuk'i ams'i oç̌ala taśi yaq'e loxol baki ganxo moroxe. ");
INSERT INTO udi_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moiseyen Q'ončuğon içu pi k'inək' içoğoy çurk'ala ga düzbi bito ganxoy siyəyinəne biq'ey. Moval şot'oğoy taśi yaq': ");
INSERT INTO udi_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","İsrailluyox Misirə bakala Ramses şəhərexun C'ovaksuni axsibayi əyc'indəri savaxt'an, samci xaşe qos's'emci ğinet'un c'eri. Şorox Misirəxun içoğoy bul ala, şuk'k'alaxunal nu zap'esunt'un c'eri. ");
INSERT INTO udi_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Misirluğon isə Q'ončuğon şot'oğoynak' bisun yaq'abi içoğoy süft'in ğar əyloğot'un oç̌alaxbsay, şot'aynak' ki, Q'ončuğon misirluğoy buxačuxxoy cazina ene tadeney. ");
INSERT INTO udi_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","İsrailluyox Ramsesaxun yaq'a baft'i hari Suk'k'ot'at'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Suk'k'ot'axun c'eri hari ams'i oç̌ali bel bakala Et'amat'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Et'amaxun c'eri qaybaki qoş, Baal-Śefon şəhəri běğ c'eğala tərəf bakala P'i-Gaxirot' şəhərəç, Migdol uk'ala şəhəri t'ǒğǒlt'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","P'i-Gaxirot'axun c'eri dənizəl c'ovakit'uxun oşa Et'am uk'ala ams'i oç̌alat'un hari. Miya xib ği yaq taśit'uxun oşa içoğoy Mara s'i tadi galat'un hari çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Marinaxun c'eri Elimat'un hari çurpi. Miya p'as's'e orayin saal yetmiş dənə xurmin xode buy. ");
INSERT INTO udi_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elimaxun c'eri hari Č'oč'a dənizi t'ǒğǒlt'un içoğoynak' çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","T'et'iin yaq'a baft'i hari Sin ams'i oç̌alat'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sin ams'i oç̌alaxun c'eri hari Dofqinat'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dofqinaxun c'eri Aluşat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Aluşaxun oşa hari Refidimat'un içoğoynak' çurk'ala ga düzbi. Miya azuk'en ǔğə̌lə xe tene bə̌ğə̌bsay. ");
INSERT INTO udi_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Refidimaxun oşa Sinay ams'i oç̌alat'un içoğoynak' çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sinay ams'i oç̌alaxun c'eri Qivrot'-Hattavinat'un hari çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Qivrot'-Hattavinaxun oşa Xaśerot'at'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Xaśerot'axun oşa Ritminat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ritminaxun oşa Rimmon-P'ereśat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimmon-P'ereśaxun Livninat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Livninaxun c'eri Rissinat'un hari çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rissinaxun c'eri Qehelatinat'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Qehelat'inaxun c'eri Şafer buruğoy tumet'un hari çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Şafer buruğoxun c'eri hari Xaradat'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Xaradaxun c'eri hari Maqelot'at'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Maqelot'axun c'eri T'axat'at'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","T'axat'axun c'eri T'araxat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","T'araxaxun c'eri Mit'qinat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mit'qinaxun c'eri Xaşmoninat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Xaşmoninaxun c'eri Moserot'at'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserot'axun c'eri Bene-Yaak'anat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Bene-Yaak'anaxun c'eri Xor-Hak'k'idk'adat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Xor-Hak'k'idk'adaxun c'eri Yotvat'inat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yotvat'inaxun c'eri Avroninat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Avroninaxun c'eri Eśyon-Qeverat'un hari. ");
INSERT INTO udi_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Eśyon-Qeveraxun c'eri hari Śin ams'i oç̌ala bakala Qadeş şəhəret'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Qadeşaxun c'eri hari Edom oç̌ali zahmani t'ǒğǒl bakala Hor buruğoy tumet'un içoğoynak' çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Běyinš Aaron Q'ončuğon içu bürüşi k'inək' t'e buruğo laneśi, israilluğoy Misirəxun c'eysuni q'ırxınci useni qomci xaşe samci ğineyal t'iya p'ure. ");
INSERT INTO udi_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaroni Hor buruğo biyat'an sabaç̌ saq'o xib yəşe buy. ");
INSERT INTO udi_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Hame vədinene Kənan oç̌ali Negev bölginə bakala Arad şəhəri padçağen ibaki ki, israilluyoxe eysa. ");
INSERT INTO udi_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","İsrailluğon Hor buruğoxun c'eri hari Śalmonat'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Śalmonaxun c'eri hari P'unonat'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punonaxun c'eri hari Ovot'at'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ovot'axun c'eri hari Moav oç̌ali zahmana bakala İye-Avarim şəhəret'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","İye-Avarimaxun c'eri hari Divon-Qadat'un çurk'ala ga düzbi. ");
INSERT INTO udi_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Divon-Qadaxun c'eri hari Almon-Divlat'ayimat'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almon-Divlat'ayimaxun c'eri hari Avarim uk'ala buruxmoğoy Nevoya ı̌ša çurt'unpi. ");
INSERT INTO udi_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Avarim uk'ala buruxmoğoxun c'eri hari Moavi düzənluğa, Yerixo şəhəri běš İordan oqe t'ǒğǒlt'un çurpi. ");
INSERT INTO udi_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Miya, Moavi düzənluğa bakala İordan oq'e t'ǒğǒl şot'oğoy çurk'ala ganen Bet'yeşimot' şəhərexun burqi Avel-Şit't'im şəhərəl śirik' bineq'say. ");
INSERT INTO udi_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Me Moavi düzənluğa, Yerixo şəhəri běš İordan oqe t'ǒğǒl, Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«İsrailluğo metər upa: \"İordan oqa c'ovaki Kənan ölkinə bağat'an ");
INSERT INTO udi_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","t'e ölkinə yəşəyinşala amdarxo bitova şəp'ekinan. İçoğoy bul k'os'bseynak' bakala ǰěne saal q'əliben düzbaki binik' buxačuxxo q'a bul k'os'bseynak' bakala mandi ganxoval bitova śarpi śipanan. ");
INSERT INTO udi_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","T'e oç̌ala ef kiyel badi baśi t'iya arśanan, şot'aynak' ki, şot'o və̌xez tade. ");
INSERT INTO udi_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Oç̌ala ef boş bakala tayfoğoy arane cöybanan. İz say gele bakala tayfin oç̌al gele, iz say mal bakala tayfin oç̌al isə mal bakale. Oç̌ala çöp bosi cöybanan: şu mani oç̌al koft'ayin, şot'o ext'ale. Koft'i oç̌al tayfin boş bakala nəsilxoy arane cöybakalane. ");
INSERT INTO udi_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ama əgər t'e ölkinə yəşəyinşala amdarxo nu şəp'eğaynan, şorox t'iya mandi və̌ynak' sa q'aratikən, ef piyel bağala sa maq bakalt'un. Şot'oğon və̌x t'e oç̌ala pul tadi işiğ tet'un tadal. ");
INSERT INTO udi_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","T'e vədə Zuval şot'oğoy bel eşt'un çureğalt'u ef bel eçoz\"». ");
INSERT INTO udi_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«İsrailluğo metər upa: \"Mone, Kənan oç̌ala ene ı̌šalayinşakenan, usumluğen baśi t'iya arśalnan. Moval Zu və̌x miras k'inək' tadi oç̌ali zahmanxo, şot'oğo çalxanan: ");
INSERT INTO udi_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ef oç̌alxoy güney tərəf bakala zahman Edomi zahmani t'ǒğǒl bakala Śin ams'i oç̌ali t'ǒğene taysa. Şo běğ c'eğalaç tərəf bakala Elaxoy dənizəxun bureqsa, ");
INSERT INTO udi_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","hari Sk'orp'ion uk'ala buruxmoğoy güney tərəfəxun, oşa Śin ams'i oç̌alaxun q'a Kadeş-Barnea şəhəriyal güney tərəfəxun c'ovaki Xasar-Addara, oşal Aśmonane c'eysa. ");
INSERT INTO udi_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Miya Misiri zahmani t'ǒğǒl bakala çəyləğen taśi hari Araluğ dənizi t'ǒğǒl çareksa. ");
INSERT INTO udi_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Ef oç̌alxoy běğ batk'ala tərəfəxun bakala zahman Araluğ dənizi t'ǒğene taysa. Me dəniz iç və̌ynak' běğ batk'ala tərəfin zahman bakale. ");
INSERT INTO udi_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Ef oç̌alxoy q'uzey tərəf bakala zahmana Araluğ dənizəxun Hor buruğo, ");
INSERT INTO udi_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hor buruğoxun Levo-Xamat'a, Levo-Xamat'axun Śedada, ");
INSERT INTO udi_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Śifrona p'ap'it'uxun oşal Xaśar-Enanal śirik' zapanan. Mo efi q'uzey tərəf bakala zahmane. ");
INSERT INTO udi_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Běğ c'eğala tərəfəxun isə zahmana Xaśar-Enanaxun Şefamal śirik', ");
INSERT INTO udi_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Şefamaxun Ayini běğ c'eğala tərəf bakala Rivlina, t'et'iinal Galileya göle běğ c'eğala tərəf bakala buruğoy döşe t'ǒğen zapanan. ");
INSERT INTO udi_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Oşa zahman İordan oqe t'ǒğen śiri taśi Elaxoy dənizi t'ǒğǒl çark'ale. Ef oç̌al q'a izi zahmanxo mone\"». ");
INSERT INTO udi_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moiseyenal israilluğo pine: «Mo efi oç̌ale, şot'o çöp bosi cöybalnan. Q'ončuğon şot'o vuyunqı̌ tayfin arane cöybsunane əmirbe. ");
INSERT INTO udi_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Şot'o görə ki, Ruveni q'a Gade tayfinen saal İosifi ğar Menaşşeni nəsiləxun bakalt'oğon ene içoğoy oç̌ali paya ext'et'un. ");
INSERT INTO udi_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Şot'oğon içoğoy oç̌ali paya Yerixo şəhəri běš, İordan oqe běğ c'eğalaç tərəfəxunt'un haq'e». ");
INSERT INTO udi_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Me oç̌alxo və̌x mülk k'inək' tast'eynak' me amdarxon cöybalt'un: běyinš Eleazaren q'a Nune ğar Yeşuan. ");
INSERT INTO udi_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Me əşləst'a köməybseynak' hər tayfin boşt'an sa kalo bakale. ");
INSERT INTO udi_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Me amdarxo moroxe: İuday tayfinaxun Yefunneyi ğar K'alev; ");
INSERT INTO udi_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simeoni tayfinaxun Ammihudi ğar Şemuel; ");
INSERT INTO udi_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Binyamini tayfinaxun K'isloni ğar Elidad; ");
INSERT INTO udi_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dane tayfinaxun Yoqlin ğar bakala, kalo c'ək'eśi Buqqi; ");
INSERT INTO udi_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","İosifi ğarmux bakala Menaşşeni nəsiləxun Efodi ğar, kalo c'ək'eśi Xanniel, ");
INSERT INTO udi_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Efraimi nəsiləxun isə Şift'ani ğar bakala, kalo c'ək'eśi Qemuel; ");
INSERT INTO udi_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zevuluni tayfinaxun P'arnak'i ğar bakala, kalo c'ək'eśi Eliśafan; ");
INSERT INTO udi_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","İssak'ari tayfinaxun Aśśani ğar bakala, kalo c'ək'eśi P'alt'iel; ");
INSERT INTO udi_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aşeri tayfinaxun Şelomin ğar bakala, kalo c'ək'eśi Axihud saal ");
INSERT INTO udi_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Naft'alin tayfinaxun Ammihudi ğar bakala, kalo c'ək'eśi P'edahel». ");
INSERT INTO udi_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Mo Q'ončuğon Kənan oç̌ala israilluğoy arane cöybseynak' c'ək'p'i amdarxone. ");
INSERT INTO udi_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Moavi düzənluğa, İordan oqe t'ǒğǒl bakala Yerixo şəhəri běš Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«İsrailluğo əmirba ki, içoğo mülk k'inək' koft'i oç̌alxoy boş leviğoynak' şəhərmuxq'at'un cöybi. Şəhərmoğoy hərrəmine heyvanxo otarişbseynak' bakala örüşxoval şot'oğoq'at'un tadi. ");
INSERT INTO udi_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Barta şot'oğoy yəşəyinşbseynak' şəhərmux, içoğoy heyvanxo otarişbseynak'al örüşxoq'an baki. ");
INSERT INTO udi_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Və̌n leviğo tadala şəhərmoğoy hərrəmine bakala örüşxo şəhəri bariğoxun burqi sa hazar ə̌m ə̌xil çark'alane. ");
INSERT INTO udi_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Şəhəri běğ c'eğala tərəfəxun p'ə̌ hazar ə̌m oç̌al, güney tərəfəxun p'ə̌ hazar, běğ batk'ala tərəfəxun p'ə̌ hazar, q'uzey tərəfəxun p'ə̌ hazar ə̌m usk'anan ki, şəhər bı̌yexq'an mandi. Leviğoynak' cöybaki şəhərmoğoy hərrəmine bakala örüşxo metər bakalane. ");
INSERT INTO udi_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Və̌n leviğo tadala şəhərmux amdar besp'it'oğoy t'it'eri c'ap'bakseynak' bakala ǔq şəhər saal q'erəz q'ırx p'ə̌ şəhər bakale. ");
INSERT INTO udi_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Bito sagala iz hərrəmine heyvanxo otarişbseynak' örüşxo bakala q'ırx muğ şəhər tadalnan. ");
INSERT INTO udi_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","İsrailluğoxun leviğoynak' şəhərmux ext'at'an tayfina koft'i oç̌ali kala-mis'ik'luğa běğanan. İz say gele bakala tayfinaxun gele, iz say mal bakala tayfinaxun mal şəhər ext'anan». ");
INSERT INTO udi_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Oşa Q'ončuğon Moiseya pine: ");
INSERT INTO udi_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«İsrailluğo upa: \"Və̌n İordan oqa c'ovaki Kənan oç̌ala bağat'an ");
INSERT INTO udi_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","amdara q'əst'en nu besp'it'oğoy t'it'eri c'ap'bakseynak' bakala şəhərmux c'ək'p'anan. ");
INSERT INTO udi_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Amdara q'əst'en nu besp'iyo me şəhərmoğo c'ap'bakalane ki, p'uri amdari həyifə haq'alt'in şot'ay şurin běš c'eri q'ərar tadeğamin şot'o nu besp'ane. ");
INSERT INTO udi_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Ef c'ək'p'i me ǔq şəhər t'it'eri c'ap'bakseynak' bakala şəhərmux bakale. ");
INSERT INTO udi_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Şot'oğoy xibara İordan oqe me tərəfəxun, t'e soğo xibara isə Kənan oç̌alaxun c'ək'p'anan. ");
INSERT INTO udi_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Me ǔq şəhər sunt'u q'əst'en nu besp'i ham israillu, hamal ef boş yəşəyinşala q'erəz azuk'axun bakalt'aynak' t'it'eri c'ap'bakala ga bakale. ");
INSERT INTO udi_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Əgər sunt'in t'iyə̌mint'u dəmiri sa şeyen duğayin, t'e amdaral mot'oxun biyayin, şot'in t'e amdara q'əst'en besp'ine baksa. Metər amdara besp'anan. ");
INSERT INTO udi_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Nəəl ki, sunt'in t'iyə̌mint'u sa ǰěnen duğayin, t'e amdaral mot'oxun biyayin, şot'inal t'e amdara q'əst'en besp'ine baksa. Metər amdara besp'anan. ");
INSERT INTO udi_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Sunt'in iz kiyel bakala durut'i sa şeyen t'iyə̌mint'u duğayin, şoval mot'oxun biyayin, şo q'əst'en amdar besp'ine baksa. Metər amdara içuval besp'alanan. ");
INSERT INTO udi_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Şot'o besp'alo bari p'iya oq'a nu efalo bakale, barta şot'o maya biq'ayin besp'eq'an. ");
INSERT INTO udi_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Əgər sunt'in t'iyə̌mint'u q'əst'en lik't'i nəəl izi loxol k'ənesa boserit'uxun oşa t'e amdar biyayin, ");
INSERT INTO udi_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","nəəl iz əcuğon biq'i şot'o duği besp'ayin, me amdara içuval besp'alanan, şot'o görə ki, şot'in amdara q'əst'ene besp'e. Barta p'urit'ay p'iya oq'a nu efalt'in şot'o maya biq'ayin hat'iya besp'eq'an. ");
INSERT INTO udi_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ama əgər iz ük'e pis niyət nu bakala sunt'in t'iyə̌mint'u nu avabaki lik't'ayin, iz loxol k'ənesa bosayin, ");
INSERT INTO udi_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","nəəl şot'ay loxol nu avabaki şot'o besp'es bakala ǰě bosayin, me içuxun sal sa düşmənçiluğ nu bakala amdaral mot'oxun biyayin, ");
INSERT INTO udi_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","t'e vədə barta azuk'i ağsaq'q'alxon amdara q'əst'en nu besp'it'ay q'a p'urit'ay p'iya oq'a nu efalt'ay arane bakala əşlə me q'aydinenq'at'un divanbi. ");
INSERT INTO udi_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Azuk'i boşt'an c'ək'eśi kalat'oğon amdar besp'it'u p'urit'ay p'iya oq'a nu efalt'ay kiyexun çark'est'eynak' şot'o qaydi t'it'eri c'ap'bakseynak' bakala şəhəre yaq'abalat'un. Barta ı̌vel c'əyin lə̌ə̌mst'unen c'ək'eśi samci běyinš biyamin şo t'iyaq'an yəşəyinşi. ");
INSERT INTO udi_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ama əgər amdara q'əst'en nu besp'iyo t'it'eri c'ap'bakseynak' bakala şəhərexun c'eğayin, ");
INSERT INTO udi_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","p'urit'ay p'iya oq'a nu efalt'inal şot'o ak'i besp'ayin, taxsırkər tene hesabbaksa. ");
INSERT INTO udi_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Şot'o görə ki, amdara q'əst'en nu besp'iyo samci běyinš biyamin t'e şəhəre mandalaney, şo saycə samci běyinš p'urit'uxun oşane iz k'oya qaybakes bakon. ");
INSERT INTO udi_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Me k'anuna maya yəşəyinşalnan yəşəyinşanan, nəsiləxun-nəsilə c'ovakest'unen həmişə əməlbalanan. ");
INSERT INTO udi_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Əgər sa amdaren şunesa besp'enesa, şot'ay bisuni q'ərara saycə me əşlə iz piin ak'it'oğoy şahidluğene tades bakon. Ama mot'aynak' sa amdari şahidluğ bəstenebaksa. ");
INSERT INTO udi_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Amdara q'əst'en besp'it'ay elmoğoy gala hik'k'al exmadanan, şo biyalane. ");
INSERT INTO udi_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Amdara q'əst'en nu besp'it'ay t'it'eri c'ap'bakala şəhərexun hari iz k'oya yəşəyinşes bakseynak'al təngə exmadanan, şo samci běyinš biyamin t'e şəhəre mandalane. ");
INSERT INTO udi_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Efi yəşəyinşala ölkinə murdarlayinşmabanan, şot'o görə ki, p'i śipsunen şot'o murdarlayinşebsa. Bari p'iyal saycə şot'o śipit'ay p'iyene os'k'i taşeri p'urum t'e oç̌ala pakbes bakon. ");
INSERT INTO udi_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ef mandala, Zuval efi t'ǒğǒl bakala ölkinə ləkələyinşmabanan, şot'o görə ki, ef t'ǒğǒl Zu, Q'ončuxe bu\"». ");
INSERT INTO udi_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Gilead İosifaxun baki Menaşşeni nəvə, Mak'iriyal ğarey. Şot'ay nəsiləxun ailoğo görə kalo c'ək'eśit'oğon Moiseyi q'a israilluğoy tayfoğoxun kalo c'ək'eśit'oğoy t'ǒğǒl hari ");
INSERT INTO udi_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","pit'un: «Q'ončuğon beş ağa me ölkinə israilluğoy arane çöp bosi cöybsuna əmirbat'an, beş viçi Śelofexada koft'ala oç̌ala iz xuyərmoğo tast'unane va əmirbi. ");
INSERT INTO udi_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ama Śelofexadi xuyərmux q'erəz tayfinaxun bakala sa israilluna işq'ara tağayt'un, içoğo koft'i oç̌alal t'e tayfina c'ovakale. Metərluğen, beş bavoğo koft'i oç̌al t'iyə̌mi tayfina c'ovaksunen malbaki bakale. ");
INSERT INTO udi_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","İsrailluğoy Qaydi Exst'uni usen eğat'anal t'e oç̌ala ext'es teyan bakal - oç̌al içoğoy işq'ara taśi tayfina mandale, beşi oç̌alxoval metərluğen malbakale». ");
INSERT INTO udi_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","T'e vədə Q'ončuğon Moiseya əmirebi, şot'inal israilluğo pine: «İosifaxun baki me tayfinen düze nex. ");
INSERT INTO udi_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Mone, Q'ončuğon Śelofexadi xuyərmoğoy barada metəre nex: şorox içoğoy çureğalt'u tayes bat'unkon. Saycə içoğoy işq'ara tağala amdar içoğoy tayfinaxun bakala əsiləxun bakalane ki, ");
INSERT INTO udi_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","israilluğo koft'i oç̌al tayfinaxun tayfina nu c'ovakane. Hər israillunen iz əsilə koft'i oç̌ala iz kiyexun nu tərbalane. ");
INSERT INTO udi_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","İsraili maninesa tayfinaxun içu iz bavaxun oç̌al mandi xuyər bunesa, şo saycə iç mani tayfin əsiləxunesa, t'e əsiləxun bakala amdarane işq'ara tayes bakon. Barta hər israillun iz bavaxun mandi oç̌al iz əsili boşq'an mandi. ");
INSERT INTO udi_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Oç̌al sa tayfinaxun q'erəz tayfina nu c'ovakalane. İsrailluğoy boş bakala hər tayfinen içu koft'i oç̌ala iz kiyexun nu tərbalane». ");
INSERT INTO udi_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Q'ončuğon Moiseya əmirbi k'inək'əl Śelofexadi xuyərmux ");
INSERT INTO udi_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Maxla, T'irśa, Xok'la, Milk'a saal Noa içoğoy əmin ğarmoğot'un işq'ara taśi. ");
INSERT INTO udi_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Şot'oğoy taśi işq'arxo İosifi ğar Menaşşeni tayfinaxuney, şot'o görəl içoğo koft'i oç̌al içoğoy bavay tərəfəxun bakala əsili kiyelxun tene c'eri. ");
INSERT INTO udi_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Metərluğen, Moavi düzənluğa, İordan oqe t'ǒğǒl bakala Yerixo şəhəri běš Q'ončuğon Moiseya israilluğo p'ap'espseynak' tadi q'aydoox q'a k'anunxo moroxe.");
INSERT INTO udi_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Pist'oğoy tadi maslaaten nu tağalo, Günaxkərxoy tağala yaq'a tur nu ç̌axk'alo, Düzgünluğa lağa haq'alt'oğoxun nu arśi-hayzalo he bəxt'əvəre! ");
INSERT INTO udi_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Şot'in iz mǔqluğa Q'ončuğoy k'anunast'ane aksa, Üşe-ğena Şot'ay k'anunaxune fikirbsa. ");
INSERT INTO udi_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Şo iz vədine bar tadala, İzi xazalxoval nu nešum bakala Xene t'ǒğǒl bit'eśi sa xod k'inək'e. Şot'in iz kula maya boxodayin buye c'eysa. ");
INSERT INTO udi_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Pis amdarxo isə metər tet'un! Şorox muşen taşala sa kološ k'inək't'un. ");
INSERT INTO udi_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Divanbakala ğine şot'oğoynak' şaat' q'ərar tene tadeğal, Günaxkərxoynak' düzgünt'oğoy arane ga tene bakal. ");
INSERT INTO udi_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Axıri Q'ončuğon düzgünt'oğoy tağala yaq'a q'orişebsa, Pist'oğoy yaq'e axır isə bisune. ");
INSERT INTO udi_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Azuk'xoy nairəzi baksunal, Millətxoy bul nu biq'ala fikirxoval içoğo mandale. ");
INSERT INTO udi_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Mone, dünyəni padçağxone giresa, Kalaluğbalxone sagala eysa. Q'ončuğoy q'a Şot'ay c'ək'p'it'ay əleyinə ěqeśi ");
INSERT INTO udi_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","\"Ekinan şot'oğoy yax ğaç̌p'i zincirxo k'as'k'en, Beş loxol lavk'i k'andalxo bosen!\" next'un. ");
INSERT INTO udi_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ala Arśit'in isə axšumene, Axšumi galane laxsa şot'oğo Q'ončuğon. ");
INSERT INTO udi_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Əcuğon biq'i töhmətbale şot'oğo, İz hirsen vəlvəlinə badale, ");
INSERT INTO udi_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","\"Bez ı̌vel burux bakala Siona Zuz c'ək'p'i laxe Bez padçağa\" uk'ale. Padçağ: ");
INSERT INTO udi_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","«Mone, Q'ončuğoy əyitəz və̌x p'ap'espsa, Za metəre pi: \"Hun Bez ğarnu, Zu ğeyinaxun vi Bava k'aleğoz. ");
INSERT INTO udi_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Zaxun çureki, Zuval azuk'xo vi kiyel tadaz, Bito oç̌alxo vi baz. ");
INSERT INTO udi_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Şot'oğo vi turin oq'a laxalnu, Sa q'əlik'ə xoxp'ala k'inək' duği xoxp'alnu\"». ");
INSERT INTO udi_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Şot'o görəl, ay padçağxo, ef haq'ıla ef bel topbanan, Müdrik bakanan, ay me dünyəne bakala kalaluğbalxo! ");
INSERT INTO udi_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Q'ončuğo çalxi Şot'o bul k'os'bsuni mǔqluğa aç̌espsunaxun q'ı̌banan! ");
INSERT INTO udi_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","K'os'baki Ğare turin oq'axun muçp'anan! Tene İz əcuğ bəc'ük'eğon, Ef tağala yaq'a və̌x k'as'p'i śinek'on, Axıri Şot'ay əcuğ kološ bəc'ük'eğala k'inək'e bəc'ük'esa! İzi hər şeya Şot'ost'a ak'alo he bəxt'əvəre! ");
INSERT INTO udi_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Davidi iz ğar Avşalomi kiyexun t'it'at'an śampi Ǐvel mə̌ğ. Ay Q'ončux, heq'ədər gele düşmənzax bu! Bez əleyinə gele amdare ěqeśe! ");
INSERT INTO udi_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Bez barada gelet'ine nex: «Buxačuğon kot'o tene çark'est'al». ");
INSERT INTO udi_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Ama Hun, ay Q'ončux, za q'orişalonu, Zaynak' hörmət eçalonu, Bez bula ala efalo Hunnu! ");
INSERT INTO udi_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Zu Q'ončuğo ost'aar k'alezney, Şot'inal İz ı̌vel buruğoxun za coğabe tast'ay. ");
INSERT INTO udi_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Zu basezksay, nep'axezsay, P'urum muğurezbaksay, şot'aynak' ki, Q'ončuğon za köməyebsay. ");
INSERT INTO udi_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Bez hərrəminə biq'est'i amdarxoy Geleluğaxun tez q'ı̌bsa. ");
INSERT INTO udi_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Hetər ki Hun bez düşmənxoy çəninəxun dunğsay, Pist'oğoy uluxxo śinney, Həysəəl bez bač'ane çurpa, ay Q'ončux Çark'est'a za, bez Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Çark'esun Q'ončuğoxune. Barta Vi xeyir-bərəkət Vi azuk'i loxolq'an baki! ");
INSERT INTO udi_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Mə̌ğk'alxoy dəst'in kalat'aynak'. Simlə ət't'əcxon farpi mə̌ğěğala Davidi Ǐvel mə̌ğ. Ay bezi taxsırsuz baksuna ç̌oyel c'evk'es bakala Buxačux, Va k'alk'at'an za ibaka! Hun bez t'ar ğine za p'ap'alonu, Za gorox eki, bez afırına ibaka! ");
INSERT INTO udi_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ay insanxo, bəse ene bezi s'iya batevk'iyo, Bəse efi ams'i şeymoğo bul k'os'bi əfçin qoşt'an taśiyo! ");
INSERT INTO udi_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Axıri düzgünt'u Q'ončuğon İçeynak' c'ək'p'ene, Zu Q'ončuğo k'alk'at'an, Şot'in za inebaksa. ");
INSERT INTO udi_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Q'ı̌banan, günax ma banan, Ef bula bernu laxat'an şip' baki saal ef ük'e bakalt'u yoxlayinşanan. ");
INSERT INTO udi_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Q'urbanxo Q'ončuğon pi k'inək' eçanan, Hər şeya Şot'in yönə badale. ");
INSERT INTO udi_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Gelet'ine \"şuva yax t'e şaat'luğ tadalo\" nex, Ay Q'ončux, barta yan Vi ük'e bask'en! ");
INSERT INTO udi_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Bol arum q'a fi bakalt'oğoy mǔqluğ Vi za tadala mǔqluği t'ǒğǒl hik'k'ale! ");
INSERT INTO udi_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Bezi bula bernu laxi bask'at'anal hik'k'alaxun tez q'ı̌bal, ay Q'ončux, Şot'aynak' ki, Hunen za Vi q'ənədi oq'a ext'i! ");
INSERT INTO udi_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Mə̌ğk'alxoy dəst'in kalat'aynak'. T'üt't'əyen farpi mə̌ğěğala Davidi Ǐvel mə̌ğ. Ay Q'ončux, bezi afırına ibaka! Bezi xoyinša coğabsuz ma efa! ");
INSERT INTO udi_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ay bezi Padçağ, bezi Buxačux, bezi haraya p'ap'a, Zu Vaz afırıpi xoyinšpsa! ");
INSERT INTO udi_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Ay Q'ončux, işiğ bitat'an Vi běš afırınenez eysa, Bezi afırına ibakamin Vi běš çökt'iz baksa! ");
INSERT INTO udi_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Hun pisluğa nu portp'ala Buxačuxnu, Vi t'ǒğǒl pist'aynak' ga butene! ");
INSERT INTO udi_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","İçu ala biq'alo Vi běš çurpes batenekon, Düz yaq'axun c'erit'oğo nifrətenbsa Hun. ");
INSERT INTO udi_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Şər bosalxo əfçinbsa, ay Q'ončux, Amdar besp'alxoxun q'a bic'luğ əşp'est'alt'oğoxun irit'enne Hun. ");
INSERT INTO udi_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ama zu, Vi nu badalbakala çuresuna görə Vi k'oya bayes bakoz, Vi s'iye q'a kalaluği běš bakala hörmətə ak'est'i Va bul k'os'boz t'e gala. ");
INSERT INTO udi_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Ay Q'ončux, za Vi laxi düzgünluği yaq'en taşa, Bezi tağala yaq'a hamavar ba, axıri bez düşmənxo gelene. ");
INSERT INTO udi_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Şot'oğoy ǰomoxun c'eğala əyiti sayco düz tene, İçoğoy ük'e bakala fikir bespsune. Şot'oğoy xirt't'əyəxun c'eğala nəfəsenal amdara gərəmzoğone taşon, Muzna bel eğala əyitmoğoy bito əfçine! ");
INSERT INTO udi_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Şot'oğoy taxsırkər baksuna ç̌oyel c'evk'a, ay Buxačux! Barta içoğoy pis niyətxo görə əfçibakeq'at'un! Me günaxkərxo Vi piin běšt'an ə̌xilba! Axıri şorox Vi əleyinət'un ěqeśi! ");
INSERT INTO udi_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Va bač'an taradalorox isə barta mǔqbakeq'at'un, Vi içoğoynak' bač'an baksuna görə barta içoğoy ük' mǔqluğen buybakeq'an! Va çureğalt'oğoy ç̌oyan axšumst'a Hun! ");
INSERT INTO udi_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Axıri Hun düzgün amdaraxun Vi xeyir-bərəkətə kamtenbsa, ay Q'ončux! Şot'oxun irəzi mandi Vi kula içuxun zaptenne! ");
INSERT INTO udi_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Mə̌ğk'alxoy dəst'in kalat'aynak'. Şeminit'en farpi mə̌ğěğala Davidi Ǐvel mə̌ğ. Ay Q'ončux, Vi əcuğ bəc'ük'eğat'an za töhmətmaba, Vi hirsen biq'at'an za caza ma tada! ");
INSERT INTO udi_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Za gorox eki, ay Q'ončux, zast'a ene zor tene mande! Za q'olayba, ay Q'ončux, bez elmoğost'a ene hal tene mande, ");
INSERT INTO udi_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Ük'eyal q'ı̌ baft'ene bezi, Mot'in hələ heq'ədər zap'k'ale, ay Q'ončux? ");
INSERT INTO udi_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Za gorox eki! Za bisunaxun efa, Vi nu badalbakala çuresuna görə za çark'est'a! ");
INSERT INTO udi_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Axıri p'urit'uxun oşa hetərez Va eyex badon? T'e oç̌alin oq'a taśit'uxun oşa hetərez Vi s'iya alabon? ");
INSERT INTO udi_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Zast'a hal tene mande, Hər şü ǒnepsunaxun bez ber xene boşe baksa. Bez piin neğen bez döşəyəne şəyinbsa. ");
INSERT INTO udi_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Dərdəxun bez pulmuxe bayinq'baki, Düşmənxon bez pulane k'ač'ibi. ");
INSERT INTO udi_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Zaxun ə̌xilbakanan, ay pis amdarxo, Q'ončuğon bez ǒnena ene inebaki! ");
INSERT INTO udi_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Bezi xoyinš p'anep'i Q'ončuğo, Q'ončuğon bezi haraya coğabsuz tene efi! ");
INSERT INTO udi_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Bez düşmənxo q'ı̌yen haq'ale, biyabur bakalt'un şorox! Xəcələti boş ç̌omə̌yin qaybaki qoş t'it'alt'un şorox! ");
INSERT INTO udi_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Davidi Binyamini tayfinaxun bakala K'uşa görə Q'ončuğoynak' şiqqayonen mə̌ğěğala Ǐvel mə̌ğ. Ay bez Buxačux bakala Q'ončux, Vaz bač'an tarast'a! Bez qoşt'an baft'it'oğoy kiyel za ma tada, za şot'oğoxun çark'est'a! ");
INSERT INTO udi_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Tene düşmənen sa aslan k'inək' za śarek'on, İz kiyexun haq'al nu bakayin tikə-tikəne bon! ");
INSERT INTO udi_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Ay bez Buxačux bakala Q'ončux! Əgər günax sa əş biq'ezusa, Əgər bez kiyexun pis əş c'erenesa, ");
INSERT INTO udi_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Zaynak' dost' bakalt'u pisluğbi Düşmən bakalt'u isə köməybezusa, ");
INSERT INTO udi_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Barta bez düşmənen za şəp'eśi biq'eq'an, Barta za oç̌alen saq'an bi! Barta bez papaq'a oq'a saki oç̌al qı̌bakayin bağalaq'an bi! ");
INSERT INTO udi_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Ay Q'ončux, hayza! Vi əcuğoy bəc'ük'esun k'ə baksuna ak'est'a, Bez düşmənxoy pisluğa bok'osp'i śipa! Şip' ma çurpa, ay Buxačux, Bezi əşlə Hun běğa, bitot'aynak' düzgün q'ərar c'evk'a! ");
INSERT INTO udi_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Mone, azuk'xo Vi hərrəmine gireğalt'un, Hunal alaxun, Vi taxt'e loxol arśi şot'oğoy loxol kalaluğbalnu! ");
INSERT INTO udi_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Q'ončuğon azuk'xo divanbale! Ay Q'ončux, Vi piin bez əşləl běğa, Bezi təmiz, taxsırsuz baksuna ç̌oyel c'evk'a. ");
INSERT INTO udi_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Ay düzgünt'oğoy tərəf bakala düzgün Buxačux, Ay amdarxoy ük'ə q'a fikirə k'alk'ala Buxačux, Pist'oğoy axıra duğa, şot'oğoy ük'e bakala fikirxo içoğoy boş efa! ");
INSERT INTO udi_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Za q'orişalo Buxačuxe! Şo iz ük' təmiz bakalt'oğo çark'est'alone! ");
INSERT INTO udi_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Buxačux düzgün divanbalone, Haq'suzt'oğoy hər ğina görə q'ərar tadalone! ");
INSERT INTO udi_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","İçoğoy tağala yaq'axun nu qaybakala pist'oğoynak' İzi q'ılınca ğayinbalone Buxačux! Şot'oğoynak' ox-kamana həzir biq'alone Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Mone, şot'oğoy elmoğo haq'ala silaxxo İz kiyel ext'ene, Şot'oğoy loxol tağala bok'ala oxurxo həzirbene! ");
INSERT INTO udi_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Əfçinen iz boş tum sakalo Pisluğa iz boş əyel taradala k'inək' taradalone. Şot'ay me dünyəne eçaloval serinaxun ə̌xil sa şeye bakon. ");
INSERT INTO udi_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","T'iyə̌mint'aynak' kur kašk'alo İçe t'e kurnu baft'on! ");
INSERT INTO udi_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","İz pisluğenal içune zərəl tadon, İz biq'ala əşurxo iz bele baron. ");
INSERT INTO udi_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Düzgün bakala Q'ončuğoy s'iyaz alabsa, Ala Arśit'u, Q'ončuğoz tərifbsa! ");
INSERT INTO udi_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Mə̌ğk'alxoy dəst'in kalat'aynak'. Git't'iten mə̌ğěğala Davidi Ǐvel mə̌ğ. Ay Həmişə Bakalo, ay beşi Q'ončux! Vi kala s'i dirist' oç̌ali ç̌oyel t'ap'esa! Vaynak' k'aleğala tərifi səs göynule c'eysa, ");
INSERT INTO udi_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Lap körpə əyloğo q'a döş ukala əyloğoval əyitp'esenst'a! Vi düşmənxoynak', Vi əleyinə c'eri vaynak' yaği bakalt'oğoynak' sa q'alan baki! Şoroxal hari t'e q'alina laft'i əfçit'unbaki! ");
INSERT INTO udi_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Vi yaratmişi me göyə q'a Vi kiin laxi me xaşa q'a muč'uliğo běğat'an, ");
INSERT INTO udi_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Fikirezbsa ki, amdar hik'k'ale! Ama Hun p'urumal şot'o eyexun ten c'evksa! İnsan şuva ki? Ama Hun p'urumal şot'ay fikirən zap'e! ");
INSERT INTO udi_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Şot'o yaratmişat'an saycə göynul bakala angelxoxunen oq'a biq'i, Şot'o taxt'an arśevk'i, kalaluğa iz kiyelen tadi. ");
INSERT INTO udi_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Şot'o Vi yaratmişit'oğoy loxol kalon laxi, Şot'ay kiin oq'ane bito: ");
INSERT INTO udi_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Eğelxo, keçiyox, öküzxo, Lap ə̌qnə heyvanxoval. ");
INSERT INTO udi_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Göynul purk'ala q'uşurxo q'a dənizə bakala çəliyoxal, Xene oq'a bakala k'ə bunesa bito. ");
INSERT INTO udi_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Ay Həmişə Bakalo, ay beşi Q'ončux! Vi kala s'i dirist' oç̌ali ç̌oyel t'ap'esa! ");
INSERT INTO udi_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Fark'alxoy dəst'in kalat'aynak'. Mut-labenen mə̌ğěğala Davidi Ǐvel mə̌ğ. Va ük'en şükürezbsa, ay Q'ončux, Vi ak'est'i möcüzoğoz bez muzel eşt'a. ");
INSERT INTO udi_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Vi biq'i əşurxon za mǔqest'a, za q'ənəd tadi purest'a, Vi s'iya alabala mə̌ğurxoz mə̌ğě, ay Ala Arśi Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Bez düşmənxo qoşt'un t'it'eri, Şorox Vi běš tet'un portp'i - k'as'eśi bart'undi! ");
INSERT INTO udi_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Metəren bez əşlə Vi düzgünluğen běği, Metəren bezi xeyirinə q'ərar c'evk'i. Taxt'a arśi düzgün Divanbalnu Hun! ");
INSERT INTO udi_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Azuk'xoy pulan haq'i Hun, pist'oğoy tuman əfçibi, Şot'oğoy s'iyurxon amdarxoy eyexun həmişəluğ c'evk'est'i! ");
INSERT INTO udi_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Düşmən uk'ala şey tene mandi, Şot'oğoy şəhərmoğon śarpi Hun! Şot'oğoy s'iyal duğal tene bakal ene! ");
INSERT INTO udi_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Q'ončuğoy kalaluğ həmişəluğe, Divanbseynak'e laxe Şot'in İz taxt'a. ");
INSERT INTO udi_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","İz düzgünluğen dünyəneynak' q'ərar c'evk'ale, Bitot'ay loxol sa piin běğale. ");
INSERT INTO udi_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Fağırxoynak' bač'ane Q'ončux, İçoğoy t'ar ğine kiyexun biq'alone Şo! ");
INSERT INTO udi_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Va çalxalt'oğoynak' umudi ganu Hun, Va qə̌věğalt'oğo nu bosalonu Hun! ");
INSERT INTO udi_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","İz taxt'a Siona Laxit'u mə̌ğpi tərifbanan, Azuk'xo Şot'ay biq'i əşurxo bayanbanan! ");
INSERT INTO udi_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Axıri bari p'iya oq'a nu Efalt'in fağırxo eyexun tene c'evk'on, Şot'oğoy xoyinša coğabsuz tene efon! ");
INSERT INTO udi_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Ay Q'ončux, běğa düşmənxon za he ğinat'un bade! Za gorox eki, bisuni kiyexun zapa ext'a za! ");
INSERT INTO udi_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Barta Yerusalimi camaati běš bez mǔqluğa ak'est'az, Barta za çark'est'una görə bitot'ay běš Vi s'iya alabaz! ");
INSERT INTO udi_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Azuk'xo içan kašp'i kurnut'un baft'i, İçan laxi torurxot'un ləc'üreśi! ");
INSERT INTO udi_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Mone, Q'ončuğon İzi düzgün divanbal baksuna ak'esedi: Pisorox t'iyə̌mint'aynak' düzbi təlinə içant'un baft'i. ");
INSERT INTO udi_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Pist'oğoy ga oç̌alin oq'ane, Q'ončuğo nu çalxala bito azuk'xoy axır bisune. ");
INSERT INTO udi_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Fağıri mə̌yin ği isə həmişəluğ tene, Əzyəti boş bakalt'aynak' umudi ga həmişə bune. ");
INSERT INTO udi_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Hayza, Vi şu baksuna ak'est'a, ay Q'ončux! Barta insanen hər şeyi iz kiyel nu baksuna, Azuk'xon Vi divanbsun k'ə baksuna ak'eq'at'un! ");
INSERT INTO udi_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Şot'oğoy pula haq'a, ay Q'ončux! Barta içoğoy adi insan baksuna q'amişakeq'at'un. ");
INSERT INTO udi_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Ay Q'ončux, het'aynak'nu ə̌xil? Het'aynak' t'ar ğine Va ten ak'est'a? ");
INSERT INTO udi_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Mone, pis amdar şuk'k'alaxun zaptenesa, Fağıra pul tadi işiğ tene tast'a. Barta iz laxi təloğo içq'an baft'i! ");
INSERT INTO udi_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Pis amdar iz ük'exun c'ovakalt'oğoxun fərəxləyinşebaksa, Q'ončuğo tene çalxsa, saycə iz q'azancaxune fikirbsa. ");
INSERT INTO udi_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","İçu ala biq'i Buxačuğoxun ə̌xile bist'a, \"Butene Şo\" pi sal iz fikire eteneşt'a! ");
INSERT INTO udi_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Metərt'oğoy əşurxo həmişə şaat'e taysa, Vi cazinen içoğo biq'sunaxun q'ı̌tet'unbsa, İçoğoy düşmənxoval hik'k'ali galat'un laxsa. ");
INSERT INTO udi_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","İz ük'e boş \"zaynak' q'ı̌ butene, Bələ zaxun ə̌xile tarak'on\" nexe. ");
INSERT INTO udi_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","İz ǰomoxun saycə q'arğiş, əfçi saal bic'luğe baron, İz muzexun şər q'a bələ eçala əyitmuxe c'eğon. ");
INSERT INTO udi_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Ayizmoğo, q'alasuz məəlnoğo tələne laxsa, Taxsırsuzt'u busmişi Şot'o c'əp'k'in gala besebsa. ");
INSERT INTO udi_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Şot'in sa şir k'inək' pusq'una çurpi yaq'eběğsa, Zəyift'ay loxol cupseynak'e həzirləyinşaksa. Biq'it'uxun oşal ext'i taneşt'a. ");
INSERT INTO udi_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Axıri zəyift'ay zor aytenesa, Pist'ay turin oq'a ç̌axç̌uxeśi tanesa! ");
INSERT INTO udi_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","İz ük' şəren buy bakalt'inal metəre nex: \"Buxačuğon İz ç̌oya taradene, ateneksa, İsə damaxune İz eyexun c'evk'e\". ");
INSERT INTO udi_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Hayza, ay Q'ončux, Vi şu baksuna ak'est'a, ay Buxačux! Fağırxo eyexun ma c'evk'a! ");
INSERT INTO udi_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Het'aynak'q'an pist'in Buxačuğo ǰamdi? Het'aynak'q'an İz ük'e boş \"za k'ə bese bakon\" pi? ");
INSERT INTO udi_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Ama Hun me zülümə q'a əzyətə anksa, Şuk'k'al Vi kiyexun tene çark'al. Fağırxoy umudi ganu Hun! Yetimxoy kiyexun biq'alonu Hun! ");
INSERT INTO udi_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Barta pis amdar biti xoreśeq'an. Şər bakalt'u tet'ər ğina bada ki, İz bi pisluğxoy sayco cazasuz maq'an mandi! ");
INSERT INTO udi_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Q'ončux həmişəluğ bakala Padçağe! Buxačuğo nu çalxalt'oğoynak' Şot'ay oç̌ala ga butene, Əfçibakalt'un şorox! ");
INSERT INTO udi_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ay Q'ončux, Hun fağırxoy xoyinša p'anpsa, Şot'oğo ük'en tast'a, Vi pul şot'oğoy loxole. ");
INSERT INTO udi_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Fağırxoy q'a yetimxoy bač'ane çurpa, Barta me dünyənexun bakalt'oğon şot'oğo zülüm tades maq'at'un baki! ");
INSERT INTO udi_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Zu Q'ončuğoz bač'an tarade, Za hetərnan \"q'uş baka buruğo purpa taki\" pes baksa? ");
INSERT INTO udi_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Mone, ük'təmizt'oğoy elmoğo haq'seynak' Pist'oğon ox-kamana həzirbet'un, Xişt'ik'xo kişp'i bayinq'una həzir çurpet'un. ");
INSERT INTO udi_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Binora lə̌q'bakit'uxun oşa Śaresuni běšinə̌mə düzgün amdaren hetəre haq'es bakon? ");
INSERT INTO udi_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","İz ı̌vel galane Q'ončux, Göynule Şot'ay taxt'. Şot'ay piyexun hik'k'al c'ap' tene mandon, Bito amdarxoy ük'e bakalt'une aksa Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Düzgünt'ay ük'exun c'ovakalt'oğone běğsa Q'ončuğon, Pisluğ q'a zülüm balt'u isə Şot'in nifrətəxun başq'a hik'k'al tene hisbon. ");
INSERT INTO udi_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Bok'ala s'il q'a ǰalk'a kükürd śik'ale Şot'in pist'oğoy loxol, Bok'osp'i śik'ala muş bakale şot'oğo mandalo. ");
INSERT INTO udi_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Axıri Q'ončux düzgüne, İz çureğaloval düzgünluğe. Düz yaq'en tağalo Şot'oxun ə̌xil tene bital. ");
INSERT INTO udi_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Fark'alxoy dəst'in kalat'aynak'. Şeminit'en farpi mə̌ğěğala Davidi Ǐvel mə̌ğ. Ay Q'ončux, yax köməyba, ene düzgün amdar tene mande, Amdarxoy boş Va ğaç̌ bakalo tene mande! ");
INSERT INTO udi_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Bitot'in suna əfçineduğsa, Ç̌oye muč'at'un əyite, ama içoğoy ük' pisluğen buye. ");
INSERT INTO udi_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Barta Q'ončuğon şot'oğoy əfçi əyitk'ala ǰomo but'k'eq'an, Lovğalayinşakala muza bot'eq'an! ");
INSERT INTO udi_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Barta maq'at'un fikirbi ki, \"beş muzen yax beş çureğala gala eçale, Me muz ki yast'a bune, şine yax efes bakon?\" ");
INSERT INTO udi_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","«Fağırxoy zülüməz ak'i, Kəsibxoyal şivanaz ibaki; İsə şot'oğo köməyboz, içoğoy haraya p'ap'oz» nexe Q'ončuğon. ");
INSERT INTO udi_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Q'ončuğoy pit'oğo əyit butene, Şo gam buxarin boş c'emaxun vǔğ kərəm xebi təmizbi gümüş k'inək'e. ");
INSERT INTO udi_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Ay Q'ončux, Hunen yax efsa! Pist'oğoy kiyexun Hunen yax çark'est'i həmişə q'orişbsa. ");
INSERT INTO udi_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Heq'ədər ki amdarxon pisluğbsuna şaat' piin běğalt'un, Pist'oğoy say avuzbakale. ");
INSERT INTO udi_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Ay Q'ončux, za hevaxt' eyex badalnu? Yəni həmişəluğen za eyexun c'evk'e? Hələ heq'ədər zaxun ç̌o taradalnu? ");
INSERT INTO udi_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Zu heq'ədər bez ük' buy tarak'oz? Bezi me hər ği q'ubarbsunen heq'ədər zap'k'ale? Hevaxt'al śirik' bezi düşmənxon bezi loxol axšumk'alt'un? ");
INSERT INTO udi_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Ay bez Buxačux bakala Q'ončux, bez loxol běğa, za ibaka! Bez piyel işiğ eça, Pula q'ic'p'i me dünyənexun taysunaxun efa. ");
INSERT INTO udi_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Barta bez pisə çureğalt'in \"şot'o sazki\" maq'an pi, Barta düşmənen bezi bist'una ak'i maq'an mǔqbaki. ");
INSERT INTO udi_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Vi nu badalbakala çuresunaxun şüpələyinştezbaksa zu, Vaxun eğala çark'esunene mǔqst'a za! ");
INSERT INTO udi_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Q'ončuğon zaynak' bit'oğoz muzel eşt'a zu, Şot'ay s'iya duği mə̌ğpsunene mǔqst'a za! ");
INSERT INTO udi_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Axmağxon içoğoy ük'e boş \"Buxačux butene\" next'un. Düz yaq'axun c'eret'un, pis əşurxoy qoşt'ant'un taysa şorox; Şaat' əş biq'al butene. ");
INSERT INTO udi_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Q'ončuğonal göynuxun amdarxoy loxole běğsa, Běneğsa běyn şot'oğoy boş müdrik baki İçu qə̌věğalo bune? ");
INSERT INTO udi_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Bitot'in Q'ončuğoxun ç̌oya taradene, Sa tanal bakayin şaat' əş biq'al tene mande. ");
INSERT INTO udi_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Hevaxt' haq'ullayinşakalt'un me pis əş biq'alxo, Bezi azuk'a saki ukalxo, İçoğoy t'arnu p'ap'alo Q'ončux baksuna nu q'amişakalxo? ");
INSERT INTO udi_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Ama Q'ončux düzgünt'oğoy tərəf bakale, Pist'oğoval q'ı̌yen haq'ale. ");
INSERT INTO udi_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Şot'oğon fağırxoy niyətət'un içoğoy boş efi, Ama Q'ončuxe t'e fağırxoy bač'ane çurpiyo! ");
INSERT INTO udi_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Ay İsraileynak' Sionaxun eğala çark'esun, mayanu?! Eki Q'ončuğoy azuk'a zülüməxun çark'est'a! Barta İak'ovi nəsilen mǔqluğq'an c'ovakest'i, Barta israilluğoy ç̌oyen axšumpeq'an! ");
INSERT INTO udi_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Davidi Ǐvel mə̌ğ Ay Q'ončux, şuva Vi ı̌vel gala yəşəyinşalo? Şuva Vi ı̌vel buruğo içeynak' məsk'ənbiyo? ");
INSERT INTO udi_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Mo düzgün yaq'en tağalo q'a İz əşurxost'a noxsan nu bakalone. Düz əyitə təmiz ük'en uk'alo q'a ");
INSERT INTO udi_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","İz muzen şər nu bosalone mo. İz ı̌šat'u pisluğ nu balo q'a T'iyə̌mint'u pis əyit nu uk'alone. ");
INSERT INTO udi_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Mo pis amdara nifrətp'i Buxačuğo çalxalt'u isə hörmətbalone. Ziyana bafaldayin, izi tadi elasi loxol çurk'alone mo. ");
INSERT INTO udi_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Borc tadat'an q'azayinşbsuni s'iyen nu tadalo, Taxsırsuzt'u taxsırkər c'evkseynak' rüşvət nu ext'alone mo. Metər bakalt'uxun bələ ə̌xile tarak'on! ");
INSERT INTO udi_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Davidi mikt'am Za q'orişi efa, ay Buxačux, Axıri zu Vaz bač'an tarade! ");
INSERT INTO udi_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Zu Q'ončuğo pizu: «Hun bez Q'ončuxnu, Hun tenusa, mandi bito əfçine!» ");
INSERT INTO udi_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Va çalxalorox isə me dünyəne kala s'iye q'ončuxe, Bezi mǔqbakala ga bunesa, şoroxe. ");
INSERT INTO udi_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Ama q'erəz buxačuxxoy qoşt'an t'it'alt'oğoy Dərde loxol dərd eğale! Śipseynak' bakala p'iye q'urbanxo etezçon t'e buxačuxxoynak' zu, Şot'oğoy s'iyal dutezğon! ");
INSERT INTO udi_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Ay Q'ončux, bez paynu koft'i, Bez k'odoğo śameśi neymət Hunnu! Vi kiyene bezi q'ısmat. ");
INSERT INTO udi_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Zaynak' śameśit'oğoxun irəzizu, Za koft'i payaxun şaat'o butene. ");
INSERT INTO udi_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Za nəsyət tadala Q'ončuğoy s'iya alaboz, Bask'i galal Şot'ay əyitmux bez ǔmǔğone. ");
INSERT INTO udi_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Q'ončuğoy həmişə bez t'ǒğǒl baksuna avazu, Za tək nu barst'una görəl bələ zaxun ə̌xile tarak'on. ");
INSERT INTO udi_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Mone, bez ük' mǔq, ç̌oyenal axšumene, Bez ük'ə buz k'inək'ez efe, q'ı̌ butene zaynak'. ");
INSERT INTO udi_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Axıri Hun bezi p'uri oç̌alin oq'a taysuna, Vaxun ç̌o nu taradalt'ay bašaybaki əfçibaksuna imkan ten tadon. ");
INSERT INTO udi_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Za yəşəyinş tadala yaq'en ak'est'i Hun, Va aksunen mǔqt'ale za. Vi t'ǒğǒl baksune zaynak' həmişəluğ bakala mǔqluğ! ");
INSERT INTO udi_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Davidi afırı Ay Q'ončux, me taxsırsuz bakalt'u ibaka, Bezi afırına coğabsuz ma efa, J̌omoxun əfçi əyit nu c'eğalt'ay haraya p'ap'a! ");
INSERT INTO udi_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Bezi əşlə Hun běğa, Barta Vi piin haq' bakalt'u q'a nu bakalt'u ak'eq'an. ");
INSERT INTO udi_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Üşe hari bez boş bakalt'oğon piyexun c'ovakest'i. Bez ük'e bakalt'oğon yoxlayinşi, ama taxsır ten bə̌ğə̌bi, Şot'o görə ki, bezi ǰomoxun günaxa taşala əyitmux tez c'evksa zu. ");
INSERT INTO udi_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Pis amdarxoxun, şot'oğoy biq'ala əşurxoxun ə̌xilez tarane, Vi əyiten, Vi ǰomoxun c'eri k'anunxonez taysa zu. ");
INSERT INTO udi_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Vi laxi yaq'az c'ək'p'e, Me yaq'axun c'eğalatezu zu. ");
INSERT INTO udi_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Vaz k'ale, ay Buxačux, avaz ki, za ibakalnu, Vi ç̌oya zaç tarada, bez afırına coğab tada. ");
INSERT INTO udi_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Vi nu badalbakala çuresuni k'ə baksuna za ak'est'a, Va bač'an taradalt'oğo içoğoy düşmənxoxun Vi zorba kula alabi çark'est'uni k'ə baksuna ak'est'a. ");
INSERT INTO udi_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Za Vi piin işiğ k'inək' q'orişa, Za Vi q'ənədxoy oq'a ext'a. ");
INSERT INTO udi_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Bezi əleyinə c'eri şər amdarxoxun, Bez hərrəminə biq'est'i za bespsun çureğala düşmənxoxun çark'est'a. ");
INSERT INTO udi_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Şot'oğost'a gorox eysun butene, İçoğo tərifbsunaxun başq'a hik'k'al avatet'un. ");
INSERT INTO udi_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Mone, bez bač'anexun baft'i za pes banekon biq'et'un, Bezi hərrəminə biq'est'i saksuni hayext'un. ");
INSERT INTO udi_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Busa şir k'inək't'un şorox, Ǒxə̌lə c'eri aslan k'inək' busq'una arśi yaq't'un běğsa şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Şot'oğoy běš c'eki, ay Q'ončux, Vi şu baksuna ak'est'i saka şot'oğo! Vi q'ılıncen şot'oğoy loxol taśi pist'oğoy kiyexun çark'est'a za! ");
INSERT INTO udi_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Vi kiin za metər amdarxoxun çark'est'a, ay Q'ončux, Me dünyənexun içoğoxun hik'k'al nu taşes bakalt'oğoxun çark'est'a za. Barta Vi şot'oğoynak' həzirbi caza içoğoy xirt't'əyel śirik'q'an baki, Barta me cazinaxun içoğoy əyloğo ukest'i Mandit'u nəvoğoynak'al efes bakeq'at'un! ");
INSERT INTO udi_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Ama zu taxsırsuz baksuna görə Vaxun ə̌xil tez bital, Bez pula qayk'at'an Va bez t'ǒğǒl aksun bəsbakale za! ");
INSERT INTO udi_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Fark'alxoy dəst'in kalat'aynak'. Q'ončuğon iz k'ul bakala Davida bito düşmənxoy q'a Şauli kiyexun çark'est'at'an Daviden Şot'aynak' mə̌ğpi Ǐvel mə̌ğ. Şot'in metəre mə̌ğpi: Va çurezsa, ay Q'ončux! Za zor tadalo Hunnu. ");
INSERT INTO udi_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Q'ončux zaynak' sa q'aya, alloy q'ala, çark'est'ale bezi Şo! Buxačux bezi bač'an, umudi ga, Bezi zorba çark'est'al, za q'orişalone Şo. ");
INSERT INTO udi_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Tərifləyinşbsuna laft'ala Q'ončuğo k'alk'oz, Şot'ine za düşmənxoxun çark'est'ey. ");
INSERT INTO udi_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Bisun ı̌šalayinşakeney za, Acal hari bez q'oq'exun ləçəq'eśeney. ");
INSERT INTO udi_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Sa p'uri k'inək'zuy zu, Bez sa tur gərəmzoğoney. ");
INSERT INTO udi_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","T'arnu baft'i Q'ončuğoz k'alpi zu, Bezi Buxačuğoz xoyinšp'i, Şot'inal İz ı̌vel ganu inebaki za, Bez haray p'anep'i Şot'o. ");
INSERT INTO udi_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","T'e vədə Q'ončuğoy əcuğ bəc'ük'eśi: Oç̌ale ǰı̌k'eśi, buruxmuxe iz ganuxun galpi. ");
INSERT INTO udi_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Şot'ay bǒxmǒğoxun k'üün, İz ǰomoxun hər şeya bok'osp'i śik'ala aruxe c'eri, Bok'ala s'ile bari ǰomoxun Şot'ay. ");
INSERT INTO udi_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Göyurxone t'ağaybi śiri Şo, Boç̌u asoyxoney turin oq'a Şot'ay. ");
INSERT INTO udi_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Angeli loxole purpi Şo, Muşane əmirbi, şot'inal İçu iz q'ənədi loxole ext'i taşeri. ");
INSERT INTO udi_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Boç̌u bayinq'luğene bəc'ürpi İçu, Mə̌yin asoyxone İz loxol lap't'i. ");
INSERT INTO udi_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Şot'ay s'alst'unaxun asoyxo qı̌baki təəre bari, Şot'ay sakala işiğaxun s'ə̌q'ene duği. ");
INSERT INTO udi_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Q'ončuğoy səsəxun göyene gürupi, Oç̌ala Ala Arśit'ay səsene haq'i. ");
INSERT INTO udi_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Şot'in İz oxurxo tərbi düşmənxone irap't'i, S'ə̌q'e duğsunaxun içoğoy yaq'at'un aç̌esp'i şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Oqurxoy tume ak'eśi t'e vədə, Oç̌ali binorane ç̌oyel c'eri! Dünyənə q'ı̌ya badala Vi səsene bi mot'oğo, ay Q'ončux, Bǒxmǒğoxun c'eğala nəfəsi zorene bi! ");
INSERT INTO udi_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Q'ončuğon alaxun za kule boxodi, Batk'i tağala ganuxun zapi c'evek'i. ");
INSERT INTO udi_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Za zorba düşməni kiyexune çark'est'i, Zaxun zorba bakala düşməni kiyexun! ");
INSERT INTO udi_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Bez bist'una ak'i, bez loxol hariyoroxey şorox, Ama Q'ončuxe bez bač'ane çurpi. ");
INSERT INTO udi_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Q'ı̌ nu bakala galane eçeri za Şot'in, İz piyes şaat' ak'eśit'u çark'esedi. ");
INSERT INTO udi_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Bezi düzgün baksuna görəne köməybi za Şot'in, Bez kiin saycə təmiz əşur biq'suni əvəzəne tadi. ");
INSERT INTO udi_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Axıri Q'ončuğoy yaq'enez taysa zu, Şot'oxun ç̌o taradi pisluğ tezbsa. ");
INSERT INTO udi_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Şot'ay k'anunxo bitova bez ǔmǔğo sırığanez bi, İz buyruğxoxun tez c'eri. ");
INSERT INTO udi_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Şot'ay běš bez ç̌o mas'ine, Günaxa za ı̌ša bist'a tez barte zu. ");
INSERT INTO udi_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Bez düzgün baksuni əvəzəne tadi za Q'ončuğon, Bez kiin saycə təmiz əşur biq'suna aneksa Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Vaxun ç̌o nu taradalt'uxun Hunal Vi ç̌oya taratenst'a, Şaat' bakalt'aynak' Hunal Vi şaat'luğa kamtenbsa. ");
INSERT INTO udi_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ük' təmizt'uxun iz muzinen əyite, Bic'luğ əşp'est'alt'uxun iz muzin. ");
INSERT INTO udi_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","İçu oq'a biq'i əyit běğalt'u çark'esendon Hun, İçu ala biq'i içoğoxun irəzi bakalt'oğoynak' oq'a bist'uni k'ə baksunan ak'est'on. ");
INSERT INTO udi_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Hun bezi yəşəyinşə işiğ sakalonu, ay Q'ončux! Za bayinq'luğa ašt'a nu bark'alonu, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Vi köməyenez q'oşuni loxol tağon zu, Hunen za q'aloğo śarpest'i şəhərmoğo ext'est'es bakon. ");
INSERT INTO udi_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Buxačuğoy laxi yaq'ast'a k'ori ga, İz əyitəst'al noxsan butene, İçu umudbakalt'oğo q'orişi efalone Şo. ");
INSERT INTO udi_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Q'ončuğoxun başq'a Buxačux bune ki? Şuva beşi Buxačuğoxun başq'a yax q'orişi efalo? ");
INSERT INTO udi_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Buxačuxe za zor tadalo, Bez yaq'a hamavar balo. ");
INSERT INTO udi_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Marali turmoğoxune tadi za Şot'in, Bez turmoğo oç̌ala lafst'a tene barti. ");
INSERT INTO udi_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Bez kulmoğo davineynak'e həzirbi, Lap misə k'oribala zore tadi za. ");
INSERT INTO udi_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ay Q'ončux, Vaxun eğala çark'esunene za q'orişi, Vi sa kul həmişə bez loxole baki, Vi ük' bok'ospsune bez s'iya alabalo. ");
INSERT INTO udi_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Bez tağala yaq'an gengbi Hun, Lə̌ngbat'an lamandalatezu zu. ");
INSERT INTO udi_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Bez düşmənxoy bač'anexun baft'i bizq'i şot'oğo zu, Əfçibinut'al qoş qaytezbaki. ");
INSERT INTO udi_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","K'as'p'i śizpi şot'oğo zu, hayzalatet'un ene, Bez turin oq'at'un past'eśi şorox. ");
INSERT INTO udi_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Hun za davineynak' zoren tadi, Bez loxol ěqeśit'oğo bez turin oq'an saki. ");
INSERT INTO udi_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Bez düşmənxo fırıpi t'it'alat'un baki, Za nifrətbalt'oğo əfçizbi zu. ");
INSERT INTO udi_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Şot'oğon şivanbi köməyt'un çureśi, ama çark'est'al tene baki, Şot'oğon Q'ončuğot'un k'alpi - Şot'inal İz kula tene boxodi, ");
INSERT INTO udi_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Şot'oğo č'ak'p'i muşen taşala tozez bi, Bezi turin oq'a oč'i bi ç̌axç̌uxezpi. ");
INSERT INTO udi_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Hun bez loxol ěqeśi azuk'axunen za çark'est'i, Millətxoy loxol kalon laxi za. Bez nu çalxala azuk'xo hari bez q'ulluğane çure, ");
INSERT INTO udi_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Bezi sa əyitə p'ə̌tet'unbsa. Q'erəz oç̌alxoxun bakalt'oğon bez turin oq'axunt'un muçe, ");
INSERT INTO udi_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Ük' tene mande şot'oğost'a, İçoğoy c'ap'baki ganuxun c'eğat'an t'ut'uk'at'un c'eysa. ");
INSERT INTO udi_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Həmişə dirist' bakala Q'ončuğo, Zaynak' sa q'aya bakalt'aynak' alxışq'an baki! Za çark'est'ala Buxačuğoy s'iya alabanan! ");
INSERT INTO udi_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Şo za pisluğbalt'oğoxun həyif haq'ala Buxačuxe, Bito azuk'xo bez kiyel tadala Buxačuxe. ");
INSERT INTO udi_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Hun za bez düşmənxoxunen çark'est'i, Bezi loxol ěqeśit'oğoy běš za alanbi, Q'əddar amdari kiyexunen za ext'i Hun. ");
INSERT INTO udi_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Zuval bito azuk'xoy boş Va alxışp'oz, Vi s'iya alabala mə̌ğur mə̌ğk'oz! ");
INSERT INTO udi_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Q'ončuxe İz c'ək'p'i padçağa düşmənxo saki ç̌axç̌uxp'est'alo, Şone Davideynak' q'a iz nəsileynak' nu badalbakala çuresun ak'est'alo! ");
INSERT INTO udi_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Q'ončuğoy kalaluğaxune əyite göyurxon, Şot'ay kiyexun c'eri əşləyən aksa beş bula alabi běğat'an. ");
INSERT INTO udi_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Hari c'ovaksunen ğimxon sunat'un exlətpsa mot'o, Hər c'ovakala şünen oşin eğala şünəne c'ovakest'a iz avabakalt'u. ");
INSERT INTO udi_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","J̌omoxun c'eri hari ǔmǔğo laft'ala səs tene mo, Əyiten p'ap'esp'ala exlət tene mo. ");
INSERT INTO udi_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Ama hetəresa p'urumal dirist' dünyənə haq'layinşebsa, Oç̌ali sa belxun baśi t'e soğo belxun c'enesa. Mone, göynul běğeynak' sa gane be Buxačuğon. ");
INSERT INTO udi_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","C'eğat'an biney otağaxun c'eğala təzə bəy k'inək', İçuxun běš t'it'al nu baksuna ava sa q'oççağ k'inək'e c'eysa şo. ");
INSERT INTO udi_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Göynul sa belxun c'eri Taśi t'e belxun fırıpi enesa, İzi gamluğ nu laft'ala sa şey tene manst'a. ");
INSERT INTO udi_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Q'ončuğoy k'anunast'a kamluğ butene, Amdari urufane təzələyinşbsa şot'in. Q'ončuğoy buyruğxo əyit butene, Ə̌xil nu ak'alt'u müdrike bsa şot'in. ");
INSERT INTO udi_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Q'ončuğoy tadi nəsyətxo bito düzgüne, Amdari ük'əne mǔqt'on şot'oğon. Q'ončuğoy bürüşiyorox piin işiğe, Tağala yaq'ane işiğbon şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Q'ončuğo çalxsunaxun şaat' şey butene, Şot'o bul k'os'bsun həmişəluğe. Q'ončuğoy k'anunxo bito serine, Bito haq' gala əşeğalone. ");
INSERT INTO udi_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Şorox lap q'ızılaxunal dəyərlune, Təmiz q'ızılaxun üst'üne şorox. Şorox uč'axunal muč'ane, Uč'e şamaxun barala uč'axun muč'a. ");
INSERT INTO udi_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Şoroxe me Vi k'ula efalo, Şot'oğo əməlbsuni əvəz kalane. ");
INSERT INTO udi_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","İz biq'i sərf əşlə ak'al butene, Bezi nu avabaki əşp'est'i günaxxo bağışlayinşa za. ");
INSERT INTO udi_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Q'əst'en əşp'est'ala günaxxoxun ə̌xil biq'a za, Ma barta şot'oğoy běš aciz bakaz zu! T'e vədə zu təmizez mandon Me kala günaxaxun murdarlayinşaki tez bakon! ");
INSERT INTO udi_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Barta bez ǰomoxun c'eğalorox q'a ük'e bakalorox Vi piyes şaat'q'an ak'eśi, ay Q'ončux, Ay bez Q'aya! Ay bez Çark'est'al bakala Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Barta Q'ončux vi t'ar ğina p'ap'eq'an, Barta İak'ovi Buxačuğon va q'orişi efeq'an. ");
INSERT INTO udi_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Barta Şo İz ı̌vel ganuxun va köməyq'an baki, Barta Sionaxun va kulq'an boxodi. ");
INSERT INTO udi_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Barta vi eçeri bito payurxoxun irəzi mandi Bok'ospsuni q'urbanxoval q'abulbeq'an. ");
INSERT INTO udi_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Barta Buxačuğon vi ük'en çureğalt'u va tadi Vi niyətxoval bitova bex p'ap'esp'eq'an. ");
INSERT INTO udi_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Yanal vi düşmənxo saki ç̌axç̌uxpsuna ak'i mǔqbaken, Bayrağxo alabi beşi Buxačuğoy yaxun baksuna ak'est'en. Barta Q'ončuğon vi İçuxun afırıpi çureğalt'oğo bitova p'ap'esp'eq'an! ");
INSERT INTO udi_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","İsə avazu ki, Q'ončuğon İz c'ək'p'it'u çark'esest'a, Alaxun, İz ı̌vel ganuxun şot'o inebaksa, İz sa kula şot'oxun tene zap'e. ");
INSERT INTO udi_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Soğo iz davin araboğo, t'e soğo iz ěkurxone umudbaksa, Yan isə beşi Buxačux bakala Q'ončuğoyan bač'an tarast'a. ");
INSERT INTO udi_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Mone, şorox nu portp'i bit'unti, oç̌alen sat'un baki, Yan isə turelyan, ost'aar çurpeyan. ");
INSERT INTO udi_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Ay Q'ončux, padçağa bist'a barmata! Va k'alk'at'an beş t'ar ğina p'ap'a! ");
INSERT INTO udi_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Ay Q'ončux, Vi zorene mǔqst'a padçağa, Vi içu çark'est'unene fərəxləyinşaksa şo. ");
INSERT INTO udi_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Şot'ay ük'exun c'ovakalt'oğo tam bex p'ap'esenbi Hun, Şot'ay ǰomoxun c'eğalt'oğo coğabsuz ten efi. ");
INSERT INTO udi_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Şot'o q'abulenbi Hun, şaat' şeyurxo içuxun kamtenbi, İz bel təmiz q'ızılaxun tacen laxi. ");
INSERT INTO udi_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Şot'in Vaxun yəşəyinşe çureśi, Hunal şot'o bol-bolen tadi, Şot'ay ömürə həmişəluğen boxoybi. ");
INSERT INTO udi_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Şot'o düşmənxoxun çark'est'i iz s'iyan alabi, Şot'o kala s'iye, hörməti q'ončuxen bi. ");
INSERT INTO udi_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Şot'o həmişəluğ bakala sa xeyir-bərəkəten tadi, Vi iz t'ǒğǒl baksuni mǔqluğan ak'est'i. ");
INSERT INTO udi_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Axıri padçağen Q'ončuğone bač'an tarast'a, Ala Arśit'ay nu badalbakala çuresuna görəl iz tur ǰěna tene lamanst'a. ");
INSERT INTO udi_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Vi zorba kula boxodi Vi düşmənxo biq'alnu, Va nu çureğalorox Vi kiyexun tet'un çark'al. ");
INSERT INTO udi_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Va ak'at'an içoğo bok'ala buxarin boş hisbalt'un, Vi əcuğon şot'oğo ašampi taşala arux k'inək' əfçibale. ");
INSERT INTO udi_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Şot'oğoxun törəyinşakalt'oğo etenfal, Oç̌ali ç̌oyelxun şot'oğoy nəsilə tumexun əfçibalnu Hun! ");
INSERT INTO udi_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Vi loxol düşməni piin běği Va pisluğbsunt'un çureśi, Vi əşurxoy nu bul biq'seynak' içoğoy kiyexun ayeğalt'u bit'un, ama tet'un başarbi. ");
INSERT INTO udi_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Vi běš badi şəp'eğalnu şot'oğo Hun, İçoğoy loxol eğala xişt'ik'xoxun t'it'alt'un şorox. ");
INSERT INTO udi_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Ay Q'ončux, hayza, Vi kalaluğa, Vi zora ak'est'a! Barta yanal mot'oğo ak'i Vi s'iya alabala mə̌ğur mə̌ğk'en! ");
INSERT INTO udi_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi \"Běğ c'eğat'an c'eğala ceyran\" faren mə̌ğěğala Ǐvel mə̌ğ. Ay bez Buxačux, bez Buxačux, za het'aynak'en tək barti? Het'aynak' bez t'ar ğine Va k'alk'at'an za kul ten boxost'a? ");
INSERT INTO udi_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Ay Buxačux, Va dirist' ği k'alezne - za itenbaksa, Üşez k'ale - p'urum sa irəətluğ tez bə̌ğə̌bsa. ");
INSERT INTO udi_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Hun ı̌velnu, İsrailluğoy tərifen ə̌leśi taxt'e loxol arśiyonu. ");
INSERT INTO udi_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Beş bavoox Vat'un güvəyinşaki, Vat'un bač'an taradi, Hunal şot'oğo kulen boxodi. ");
INSERT INTO udi_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Vat'un köməyə k'alpi - Hunal Va p'ap'esp'i şot'oğo çark'esendi, Vat'un umudbaki - Hunal şot'oğo ç̌omə̌yin ten efi. ");
INSERT INTO udi_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Za isə amdari gala laxal butene, sa meq k'inək'zu zu. Nə hörmətzax bu, nə s'i, saycə nifrəti q'ončuxzu. ");
INSERT INTO udi_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Ak'alt'in axšumene bez loxol, Bula ǰı̌k'p'i lağat'un haq'sa: ");
INSERT INTO udi_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","«P'oy Q'ončuğone umudbaksay? Şot'ay piyes şaat'e ak'esasa, Barta isə hari çark'est'eq'an ak'en». ");
INSERT INTO udi_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Ama Hun za nanay tapanexun me dünyəne eçeriyonu, Hələ körpə hamaq'un Vaz umud zu. ");
INSERT INTO udi_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Nanaxun bakat'an Vi kiyel tadeśiyozu, Hələ me işiğlu dünyəne eğamin Va Buxačuxez çalxe zu! ");
INSERT INTO udi_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Vi kula zap'mapa zaxun, Bələ hari bez best'a çurpene. Za kul boxodal bakala tene! ");
INSERT INTO udi_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Mone, düşmənxon bez hərrəminə sa sürü arak' k'inək' biq'est'ene, Bez loxol Başani vərkər arak'xo k'inək't'un eysa. ");
INSERT INTO udi_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","İz kiyexun nu çark'es bakala, İz ǰomo baft'alt'u śarpi śik'ala aslan k'inək't'un eysa. ");
INSERT INTO udi_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Bez xe es'eśene, Ǔq'enxon etenefsa za. Bez ük'əl xebakene ene. ");
INSERT INTO udi_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Zor tene mande zast'a, galdayin bitoz zu, Bez muzal t'amağene ləçəq'eśe. Mone, za tək oç̌alaxp'alane mande! ");
INSERT INTO udi_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Pis amdarxon bez hərrəminə biq'est'ene, Kašk'ala xə̌yox k'inək't'un eysa bez loxol, Bez kul-turat'un hə̌fst'a şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Sa t'ol sa ǔq'ene mande bez, Mot'o ak'iyal mǔqt'unbaksa. ");
INSERT INTO udi_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","İçoğoy arane bez paltarat'un cöybsa, Bez paltareynak' çöpt'un bost'a şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Ama, ay Q'ončux, Hun zaxun ç̌o ma tarada! Zaynak' bač'an bakala Buxačux, bez t'arnu p'ap'a! ");
INSERT INTO udi_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Za q'ılıncaxun çark'est'a, Me xə̌yoğoy ǰomo bafst'a ma barta, ");
INSERT INTO udi_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Aslani ǰomoxun ext'a za. Öküzxoy mǔq'oğoxunen çark'est'i za Hun! ");
INSERT INTO udi_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Vi s'iya bez viçimoğoy běš bayanboz, Şot'oğoy arane Vi s'iya alabi metər uk'oz: ");
INSERT INTO udi_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","«Ay Q'ončuğo çalxalorox, Şot'o tərifləyinşanan! İak'ovi nəsil, Şot'ay s'iya alabanan, Ay İsraili nəsil, Şot'o hörmətbanan! ");
INSERT INTO udi_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Şot'in koruği boş bakalt'u nu aksuna tene laxi, Şot'oxun İz ç̌oya tene taradi, Ama şot'ay xoyinša inebaki!» ");
INSERT INTO udi_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Bezi me gireśi viçimoğoy běš c'eysuni s'i Va tərifbsune, Va çalxalt'oğoy běš bez niyətp'it'oğo bex p'ap'esp'oz zu. ");
INSERT INTO udi_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Kəsibxoy boşşamin ukun bakale, şorox busa tet'un bakal, Q'ončuğoy əyiten tağalt'oğoy ǰomoxun Şot'ay s'i tene bital! Barta Buxačuğon ef elmoğo maq'an laft'i! ");
INSERT INTO udi_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Oç̌ali ç̌oyel Buxačuğo eyex nu badalo, Şot'o nu çalxalo tene mandal, Bito azuk'xon q'a tayfoğon Şot'o bul k'os'balt'un! ");
INSERT INTO udi_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Şot'o görə ki, padçağluğ Buxačuğoy kiyele, Şot'ine amdarxoy loxol kalaluğbsa. ");
INSERT INTO udi_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Dövlətlut'oğon q'a şaat' ği ak'alt'oğonal Şot'o bul k'os'balt'un, Me dünyənexun p'uri-tağalt'oğon q'a bisuni kiyexun nu çark'es bakalt'oğonal. ");
INSERT INTO udi_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","İçoğoy əyloğon Şot'o q'ulluğbale, İçoğoxun oşa eğala nəsilen Q'ončuğoy barada exlətp'ale. ");
INSERT INTO udi_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Nanaxun bakalt'in Şot'ay düzgünluğa q'a Şot'ay biq'i əşurxo avabakale! ");
INSERT INTO udi_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Davidi Ǐvel mə̌ğ Q'ončuğon za İz sürünə ext'i zaynak' sa çobane baki, Bezi het'uva eht'iyəc bakes bakon ene? ");
INSERT INTO udi_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Şot'in za göyün q'oruğxone otarişbsa, Şip' tağala xeyurxoy t'ǒğǒle taşt'a. ");
INSERT INTO udi_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Şot'in za ük'e tast'a, Düzgün bakala yaq'en taşeri İzi şu baksunane ak'est'a. ");
INSERT INTO udi_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Lap zülmət bayinq'luğenal tağayiz, Şərəxun tez q'ı̌bon zu, Şot'o görə ki, zaxunnu Hun. Vi sa kul bez loxol baksunen arxayinebsa za. ");
INSERT INTO udi_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Bez düşmənxoy běš zaynak' həzirluğen běği Hun, Bez bel c'əyin lə̌ə̌mdi ist'olin best'an arśevk'i, Bez pula hik'k'ali loxol ten efi Hun. ");
INSERT INTO udi_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Vi çuresun q'a Vi ük' bok'ospsun Hər ği zaxun baksuna avazu! Heq'ədər ki bez nəfəs bez boşe Həmişə Q'ončuğoyxrama hari bul k'os'boz zu! ");
INSERT INTO udi_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Davidi Ǐvel mə̌ğ. Oç̌al q'a me oç̌ali loxol bakalorox, Dünyə q'a me dünyəne yəşəyinşalorox - Morox bito Q'ončuğoye. ");
INSERT INTO udi_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Şot'ine oç̌ali binorina dənizxoy loxol laxi, Şot'ine dünyəni binorina xeyurxoy loxol alabi ost'aarbi. ");
INSERT INTO udi_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Şuva Q'ončuğoy buruğo lağalo? Şuva Şot'ay ı̌vel gala çurpes bakalo? ");
INSERT INTO udi_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Mo iz əməlxo q'a ük' təmiz bakalo, Ams'i şeyurxo bul nu k'os'balo, Əfçidən nu elask'alone. ");
INSERT INTO udi_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Metər amdaraxun Q'ončuğon İz xeyir-bərəkətə kamtenebal, Metər amdarast'a iz Buxačux bakala Çark'est'alen taxsır tene ak'al. ");
INSERT INTO udi_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Mone, Va qə̌věğala azuk' metəre, Va bul k'os'bsa eğalorox metəre, ay İak'ovi Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Ay ı̌vel gane darvazoox, ef bağala ganu gengbanan, Ay damna ç̌omxo, qayekinan! Mone, s'ila Padçağe eysa, bona bağale! ");
INSERT INTO udi_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Şuva me s'ila Padçağ? Zorba, bitova başarbala Q'ončux! Davoğo taşala Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Ay ı̌vel gane darvazoox, ef bağala ganu gengbanan, Ay damna ç̌omxo, qayekinan! Mone, s'ila Padçağe eysa, bona bağale! ");
INSERT INTO udi_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Şuva me s'ila Padçağ? Q'oşuniQ'ončux, Şone s'ila Padçağ! ");
INSERT INTO udi_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Davidi Ǐvel mə̌ğ Ay Q'ončux, bez ük'ə qaypi Vi běšez laxsa zu. ");
INSERT INTO udi_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Vaz bač'an tarast'a, ay Buxačux! Za ç̌omə̌yin ma ba, Düşmənxoy turin oq'a ç̌axç̌uxeśi taysa ma barta! ");
INSERT INTO udi_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Va bač'an taradalt'oğoy bač'an sal sa vədə k'os'tenebakon, Vaxun nahaq' gala ç̌o taradiyorox isə ç̌omə̌yint'un mandon. ");
INSERT INTO udi_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Ay Q'ončux, za Vi yaq'en taşa, Za Vi tağala cığırxo çalxest'a. ");
INSERT INTO udi_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Barta Vi düzgünluği q'a Vi laxi yaq'en taysuni k'ə baksuna zombakaz. Axıri za çark'est'ala Buxačux Hunnu, Vi za kul boxost'unaz yaq'běğsa həmişə zu. ");
INSERT INTO udi_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Ay Q'ončux, Vi nu badalbakala çuresuna q'a ük' bok'ospsuna zaxun kammaba, Me p'ə̌ şeye Vast'a nu es'esuna avazu. ");
INSERT INTO udi_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Bezi cəyilluğast'a əşp'est'i günaxxo q'a taxsırxo eyex ma bada, Vi nu badalbakala çuresuna saal ak'est'a, Axıri Hun şaat' bakalonu, ay Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Düzgün bakalo, şaat' bakalone Q'ončux, Günaxkərxo düz yaq'a laxalone Şo. ");
INSERT INTO udi_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","İzi əyitəxun nu c'eğalt'oğo yaq' ak'est'alo, Şot'oğo İz laxi yaq'en taysuni k'ə baksuna zombalone Şo. ");
INSERT INTO udi_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","İçuxun ğaç̌eśi irəziluğa əməlbalt'oğoxun İzi çuresuna kamtenebon Q'ončuğon Şot'oğo qı̌ yaq'a tene efon Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Ay Q'ončux, Vi Şu baksuna ak'est'a, Bez taxsırxo kalal bakayin, şot'oğo bağışlayinşa. ");
INSERT INTO udi_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Q'ončuğon İçu çalxalt'oğo Mani yaq'en taysuna ak'est'ale. ");
INSERT INTO udi_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Şot'oğo hər şeyi ən şaat't'u tadale, Şot'oğoxun bakala nəsilen miras koft'i oç̌ala tum sakale. ");
INSERT INTO udi_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","İçu çalxalt'oğone Q'ončuğon İz məsləətə tadon, Şot'oğone İzi irəziluğa əməlbsuni k'ə baksuna ak'est'on. ");
INSERT INTO udi_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Q'ončuğoz qə̌věsa həmişə zu, Şone za baft'i təloğoxun c'evk'alo. ");
INSERT INTO udi_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Bezi loxol běğa, Vi ük' bok'ospsun k'ə baksuna ak'est'a, Axıri bezi şuk'k'al butene, əzyətez aksa zu. ");
INSERT INTO udi_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Bez ük' buye, q'ubarezbsa zu, Za me zülüməxun çark'est'a. ");
INSERT INTO udi_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Za çətinluğxoy, dərde boş ma efa, Bezi günaxxo os'k'a taşa. ");
INSERT INTO udi_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Běğa heq'ədər düşmənzax bu, Za ak'ala pul tene bu şot'oğoy! ");
INSERT INTO udi_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Bez elmoğo haq'sa ma barta, za çark'est'a, Axıri Vaz bač'an taradi, Za ç̌omə̌yin ma ba. ");
INSERT INTO udi_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Barta bezi təmizluğen q'a düzgünluğen za q'orişeq'an, Vaz güvəyinşaksa zu. ");
INSERT INTO udi_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Ay Buxačux, c'evk'a israilluğo bito çətinluğxoxun! ");
INSERT INTO udi_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Davidi Ǐvel mə̌ğ Bezi taxsırsuz baksuna ç̌oyel c'evk'a, ay Q'ončux, Axıri zu düzgünez yəşəyinşe. Vaz bač'an tarade, ay Q'ončux, Vi laxi yaq'axun tez c'ere. ");
INSERT INTO udi_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Za sinəyinşa, ay Q'ončux, xaxalaxun c'ovakest'a, Bez ük'e, bez fikire bakalt'oğo yoxlayinşa. ");
INSERT INTO udi_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Vi nu badalbakala çuresuna həmişə azaksa, Vi za nu efi taysunaxun şüpələyinştezbaksa. ");
INSERT INTO udi_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Əfçiduğala amdarxoxun sagala artezst'a, P'ə̌ç̌olat'oğoxunal dost'luğtezbsa. ");
INSERT INTO udi_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Günaxkərxoy ç̌omoxun bona tez baysa, Pis amdarxoy mərəkəyəl tez gərbaksa. ");
INSERT INTO udi_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Zu bez taxsırsuz baksuna ak'est'oz, ay Q'ončux, Bez kula os'k'i Vaynak' q'urban eçala gane hərrəmine fırık'at'an ");
INSERT INTO udi_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Vi s'iya alaboz alloy səsen, Vi bi nu ak'eśi əşurxoxun exlətp'oz. ");
INSERT INTO udi_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Ay Q'ončux, Vi məsk'ən saki k'oja, Vi s'iye kalaluğ ak'eğala ganu çurezsa zu. ");
INSERT INTO udi_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Za günaxkərxoxun gərbi, İçoğoy kul p'iyen bakalt'oğoxun sa biq'i bez elmoğo ma haq'a. ");
INSERT INTO udi_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Vi laxi k'anunxoxun c'eğalt'oğoxun, Rüşvət ext'i, rüşvət tadalt'oğoxun sa biq'i ma əfçiba za. ");
INSERT INTO udi_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Düzgün yaq'enez taysa zu, bez əşurxost'a noxsan tezax bu, Çark'est'a za, Vi ük' bok'ospsuni k'ə baksuna ak'est'a! ");
INSERT INTO udi_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Düz galaz bez tura laxe zu, Q'ončuğoy s'iya Şot'o bul k'os'bseynak' gireśit'oğoy boş alaboz zu. ");
INSERT INTO udi_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Davidi Ǐvel mə̌ğ Q'ončux bez işiğ, zaynak' çark'esun eçalone, Het'uxun q'ı̌boz zu? Q'ončux bez yəşəyinşə q'orişalone, Şuxun zap'eğoz zu? ");
INSERT INTO udi_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Pis amdarxo bez loxol ěqeğat'an, Bez düşmənxon za saki uksun çureğat'an İçoğoy turin yaq' tene biq'al, Lamandi bitalt'un za pul tadi işiğ nu tadalorox. ");
INSERT INTO udi_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Bez hərrəminə sa q'oşunenal biq'est'ayin, Zu tez q'ı̌bon, Zaxun davinal c'eğayin, Bez ganuxun tez galk'on. ");
INSERT INTO udi_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Tək sa şeyez çuresa Q'ončuğoxun, Saycə mot'oz çuresa: Bez yəşəyinşi axıral śirik' Q'ončuğoy k'oya mandes bakaz. Hər ği Şot'ay kalaluği q'a ı̌velluği k'ə baksuna ak'es, Şot'ay məsk'ən saki gala hari Şot'o bul k'os'bi afırıpes bakaz. ");
INSERT INTO udi_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Bezi t'ar ğine za İz t'ǒğǒl, İz bakala gala efane, Za İz ı̌vel çadıren but'k'i Şuk'k'ali kul nu p'ap'ala gala zaynak' ga bane. ");
INSERT INTO udi_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Zuval t'e vədə bezi hərrəminə biq'est'i düşmənxo turin oq'a laxi ç̌axç̌uxezk'on, Q'ončuğoy çadıri běš bezi mǔqexun q'urbanxoz šamk'on, Şot'ay s'iya alabala mə̌ğur mə̌ğpi əçizk'on zu. ");
INSERT INTO udi_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Ay Q'ončux, Vaz k'ale, za ibaka, Vi ük' bok'ospsuni k'ə baksuna ak'est'i za coğab tada. ");
INSERT INTO udi_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Vi \"Za qə̌věkinan\" əyit bez ǔmǔğone! Mone, Va qə̌vězsa, ay Q'ončux, ");
INSERT INTO udi_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Zaxun ç̌o ma tarada, Me k'ule loxol əcuğon biq'i Vaxun ma ə̌xilba, Ay za kul boxodi Buxačux! Vi kula zaxun ma zapa, Ay bezi Çark'est'al bakala Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Lap bezi bava-nananal za bosayin, Q'ončuğon za tene boson. ");
INSERT INTO udi_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Ay Q'ončux, za Vi yaq'en taysuna zomba, Düşmənxoy niyətə içoğoy boş efa, za düz yaq'en taşa. ");
INSERT INTO udi_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Ma barta bez pisə çureğalt'oğoy kiyel baft'az, Ma barta c'eri əfçidən bez ç̌oyel çurk'alt'oğoy turin oq'a ç̌axç̌uxeśi tağaz. ");
INSERT INTO udi_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ama Q'ončuğon me dünyəne zaxun İz şaat'luğa kamtenebon, mot'o avazu! ");
INSERT INTO udi_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Q'ončuğo bač'an tarada! Ost'aar çurpa, ük'lü baka! Vi umudi ganu Q'ončuğost'a ak'a! ");
INSERT INTO udi_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Davidi Ǐvel mə̌ğ Ay Q'ončux, Vaz k'ale, Za q'orişalo Hunnu, za coğabsuz ma efa. Vaxun coğab nu ibakat'an Meyid k'inək'ez baksa zu. ");
INSERT INTO udi_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Va xoyinšp'at'an, Bez ç̌oya Vi ı̌vel k'ojaç biq'i afırık'at'an za ibaka. ");
INSERT INTO udi_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Za pist'oğoxun, şər əş biq'alt'oğoxun sagala əfçimaba, Ç̌oyel muč'a əyitp'i, ama içoğoy ük' pisluğen buy bakalt'oğoxun sa ma biq'a. ");
INSERT INTO udi_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Şot'oğoy cazina içoğoy əməlxo görə, İçoğoy biq'i pis əşurxo görə tada. Şot'oğoy cazina içoğoy kiin biq'i əşurxo görə bot'a, Ləəğa bada şot'oğoy. ");
INSERT INTO udi_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Şot'oğon Q'ončuğoy biq'i əşurxo hik'k'alt'unbsa, Şot'ay kiyexun c'eri əşurxoy kalaluğa tet'un aksa. Q'ončuğonal şot'oğo tumexun əfçibale, İçoğoy bula alabsuna imkan tene tadal ene. ");
INSERT INTO udi_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Q'ončuğo alxışq'an baki, Bez xoyinša inebaki Şot'in! ");
INSERT INTO udi_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Za zor tadalo, za q'orişalo Q'ončuxe, Şot'oz umudbaksa, bez ük'ə buz k'inək'ez efsa zu. Za kul boxodi bezi ük'əne mǔqt'i Şot'in, Şot'ay s'iya alabala mə̌ğur mə̌ğk'oz zu. ");
INSERT INTO udi_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Q'ončuxe İzi azuk'a zor tadalo, İzi c'ək'p'it'aynak' bač'an baki şot'o çark'est'alo. ");
INSERT INTO udi_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Çark'esun eça Vi azuk'eynak', Vaynak' c'ək'p'it'oğoxun Vi xeyir-bərəkətə kammaba! Şot'oğoynak' izi sürünə q'orişala sa çoban baka, Şot'oğo həmişə q'orişa! ");
INSERT INTO udi_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Davidi Ǐvel mə̌ğ Q'ončuğoy s'iya alabanan, ay göynul bakala angelxo, Şot'ay zora, Şot'ay kala s'iya ef muzel eçeri İz s'iya alabanan! ");
INSERT INTO udi_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Şot'ay hetər sa s'iye q'ončux baksuna ç̌oyel c'evk'anan, Şot'in İz işiğ sakala ı̌velluğa haq'i c'eğat'an İz běš bul k'os'banan! ");
INSERT INTO udi_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Q'ončuğoy səs xeyurxoy loxolxune c'eysa, Şot'ay kalaluği səse c'eysa mo, Göyen güruldayinşala k'inək'e güruldayinşbsa Şot'in t'e bə̌ğə̌loyuğxoy loxol! ");
INSERT INTO udi_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Ost'aare c'eysa Q'ončuğoy səs, Kalaluğa ak'est'ala səse şo. ");
INSERT INTO udi_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Şame xodurxone sakon t'e səsen, Livana bakala kala xodurxone tumexun c'evk'on. ");
INSERT INTO udi_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Buruxmoğone iz ganuxun galst'a şot'in! Livani buruğo sa mozi k'inək', Sirioni buruğo sa cəyil arak' k'inək' cupesest'a. ");
INSERT INTO udi_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Q'ončuğoy səsəxun s'ə̌q'ene duğsa, ");
INSERT INTO udi_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Oç̌ale ǰı̌k'esa Şot'ay səsəxun, Qadeş ams'i oç̌ale gale iz ganuxun. ");
INSERT INTO udi_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Mə̌xnə xodurxone k'os'bon, Xazalxone śik'on c'ələye bakala xodurxoxun t'e səsen. Mone, Şot'ay xrama sa səsen \"alxışq'an baki!\" next'un. ");
INSERT INTO udi_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Posk'ala xeyurxoy loxole laxe Q'ončuğon İz taxt'a, Həmişəluğ padçağluğbseynak'e laxe şot'o. ");
INSERT INTO udi_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","İz azuk'a zor tadalone Q'ončux, T'e azuk'axun İz bol xeyir-bərəkətə nu kambalone Şo! ");
INSERT INTO udi_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Davidi Ǐvel mə̌ğ Xrame qayesunast'a şot'ay ı̌vel baksuna ak'est'eynak' śameśi Ǐvel mə̌ğ. Ay Q'ončux, Vi s'iyaz alabsa, Şot'aynak' ki, Hun za çark'esendi, Za düşmənxoy turin oq'a ten saki, şot'oğo mǔqtendi. ");
INSERT INTO udi_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Ay Q'ončux, bez Buxačux, Vaz k'alpi zu, Hunal za q'olayenbi. ");
INSERT INTO udi_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Za p'uri ganuxunen qaydi, ay Q'ončux, Gərəmzinəxunen zapi c'evk'i za. ");
INSERT INTO udi_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Ay Q'ončuğoy laxi yaq'axun nu c'eğalorox, Şot'o tərifləyinşanan, Şot'ay ı̌vel s'iya alabala mə̌ğur mə̌ğpanan. ");
INSERT INTO udi_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Axıri Şot'ay əcuğ c'ovaki tağala, Yaynak' bala şaat'luğxo isə həmişəluğe. Üşe piyexun barala neğ Savaxt'an hari mǔqluğane fırık'on. ");
INSERT INTO udi_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Şaat' ğimxost'a bez turin oq'axun tez aksay, Lamandi bist'axun tez q'ı̌bsay. ");
INSERT INTO udi_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ay Q'ončux, zaxun Vi şaat'luğa nu kambat'an burux k'inək' ost'aarzuy zu, Zaxun Vi ç̌oya tarast'un q'a za q'ı̌yen haq'sun sane baki. ");
INSERT INTO udi_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Ay Q'ončux, zu Vaz k'alpi, Ala Arśit'u metərez xoyinšp'i: ");
INSERT INTO udi_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","«Bezi p'uri taysunen k'ə xeyirə eçon? Oç̌ala gərbaki bədənen nə Vi s'iyane alabes bakon, Nəəl Vi pi əyiti loxol həmişə çurpsuna bayanbes. ");
INSERT INTO udi_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","İbaka za, ay Q'ončux, gorox eki, P'ap'esp'a Va, çark'est'a za, ay Q'ončux»! ");
INSERT INTO udi_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Hun za yasaxun c'evk'i mǔqexun əçipsun k'ə baksunan ak'est'i, Mə̌yin paltara c'evk'i śampi lapsunan q'ısmat bi. ");
INSERT INTO udi_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Mone, zuval şip' tez çurk'al, Va tərifləyinşala əyitmux bez ǰomoxun tene bital. Həmişə Vi s'iya alabala mə̌ğur mə̌ğk'oz, Ay bez Buxačux bakala Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Fark'alxoy kalat'aynak'. Davidi Ǐvel mə̌ğ. Ay Q'ončux, zu Vaz bač'an tarast'a, Ç̌omə̌yin tez bakon zu. Vi düzgünluği k'ə baksuna ak'est'a, çark'est'a za! ");
INSERT INTO udi_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Za ibaka, eki za kul boxoda. Zaynak' sa q'aya baki bez bač'ane çurpa, Çark'eseynak' bakala sa q'ala baka zaynak'. ");
INSERT INTO udi_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Bez q'alal, q'ayal Hunnu, Za düzgün bakala yaq'en taşeri Vi şu baksuna ak'est'a! ");
INSERT INTO udi_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Vaz bač'an tarade, Zaynak' c'əp'k'in laxeśi təloğoxun ə̌xilba za. ");
INSERT INTO udi_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Bez urufa Vaz tapşurbsa, Za çark'est'a, ay Q'ončux, ay za eyexun nu c'evk'ala Buxačux. ");
INSERT INTO udi_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Ams'i şeymoğo, binik' buxačuxxobul k'os'balxo nifrətezbsa, Zu tək Q'ončuğoz umudbaksa. ");
INSERT INTO udi_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Vi nu badalbakala çuresunene mǔqst'a za, ç̌oyane axšumst'a bezi, Şot'o görə ki, bez əzyətən ak'i Hun, Bez boş zap'k'ala dərdən avabaki. ");
INSERT INTO udi_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Za düşməni kiyel ten tadi Hun, Q'ı̌ nu bakala galan eçeri za. ");
INSERT INTO udi_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Koruğazu zu, ay Q'ončux, Vi zaynak' ük' bok'ospsuna ak'est'i bağışlayinşa za. Dərdəxun bez piin işiğe mə̌yinbake, elmuxal tene mande zast'a, Bədənəl q'aribakene bezi. ");
INSERT INTO udi_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Bez ömürəz uksa dərde boş, Koruğxon bez usenxone haq'sa. Bez taxsırxoy kiyexun elmuxe c'eri bezi, Ǔq'enxonal za tene efsa. ");
INSERT INTO udi_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Bez düşmənxo gele baksuna görə q'onşiğonal za nifrətt'unbsa, Bez ı̌šat'oğoy ak'ala pul tene bu za, İçoğoy běš c'eğat'an t'it'unst'a zaxun. ");
INSERT INTO udi_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","P'uri taśi amdar k'inək' eyexun c'erezu, Xoxbaki sa q'ə̌lik' k'inək'zu zu. ");
INSERT INTO udi_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Bitot'ay za böht'an bost'unaz ibaksa, Bez bip' t'ǒğəl pisluğen haq'layinşene. Mone, za düşmən pi əyitə sabet'un, Bez elmoğo haq'seynak't'un giresa şorox. ");
INSERT INTO udi_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Ama zu Vaz umud, ay Q'ončux, \"Bez Buxačux Hunnu\" nexzu. ");
INSERT INTO udi_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Zaynak' bot'i ömür Vaxun asulune, Za bez düşmənxoy kiyexun, Bez bač'anexun baft'it'oğoy kiyexun çark'est'a. ");
INSERT INTO udi_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Ay Q'ončux, barta Vi ük'e bask'az! Vi nu badalbakala çuresuna me Vi k'ulaxun kammaba, çark'est'a za! ");
INSERT INTO udi_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Vaz k'ale, ay Q'ončux, Za ç̌omə̌yin ma ba! Barta pist'oğoy ç̌oyenq'an ot'p'i, Barta bisunen içoğoy səsə bot'eq'an! ");
INSERT INTO udi_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Barta t'iyə̌mint'oğoy loxol alaxun oq'a běğalt'ay, Düzgünt'u nifrətp'i şot'ay loxol böht'an bosalt'ay muz lalq'anbaki! ");
INSERT INTO udi_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Vast'a bakala şaat'luğ sa neyməte! Va çalxalt'oğoynak' efi, Va bač'an taradit'oğo pay k'inək' tadat'an bitot'in ak'es bakala sa neymət! ");
INSERT INTO udi_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Şot'oğo Vi xojina efi pist'oğoy niyətəxunen q'orişbsa, Vi bakala gala eçeri şər bakalt'oğoy ǰomo bafst'axunen çark'est'a. ");
INSERT INTO udi_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Q'ončuğo alxışq'an baki, Zu düşmənxon iz hərrəminə biq'est'i şəhəre mandi bakat'an Şot'in za İzi nu badalbakala çuresuni k'ə baksunane ak'est'i. ");
INSERT INTO udi_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Vəlvəlinə baft'i \"zaxun ç̌on taradi\" nexzuy, Ama bez xoyinša coğabsuz ten efi, Za kulen boxodi Hun. ");
INSERT INTO udi_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Ay Q'ončuğo çalxalorox, Şot'o çurekinan! Q'ončuğon İz laxi yaq'en tağalt'oğo q'orişebon, İçoğoy ǰomon tağalt'oğo isə mot'ay əvəzə xirt't'əyəl śirik'e tadon. ");
INSERT INTO udi_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Şot'o görəl ef ük'ə buz k'inək' efanan, Ost'aar çurpanan, ay Q'ončuğo bač'an taradiyorox bito! ");
INSERT INTO udi_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Davidi ögüd-nəsyət tadala Ǐvel mə̌ğ. İzi günaxxo os'eśi taśiyo, İzi taxsırxo bağışlayinşakiyo He bəxt'əvəre! ");
INSERT INTO udi_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Bəxt'əvəre Q'ončuğon günaxa şot'o əşp'est'it'ay ozane nu efalo, Bəxt'əvəre iz ük'e bic'luğ nu bakalo! ");
INSERT INTO udi_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Bezi günaxkər baksuna bez ozane ext'amin Dirist' ği bez bǒğǒltin səse eysay: Bez səse irameśey, halnuxunez bitey zu. ");
INSERT INTO udi_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Bezi şip' çurpsuni cazinaz zap'ey zu üşe-ğena, Běğe ç̌oyel q'aribaki xazal k'inək' q'aribakezuy. ");
INSERT INTO udi_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Mone, t'e vədə bez günaxxo bez ozane hazq'i, \"Barta Q'ončuğoxun hik'k'al c'ap' maq'an mandi\" pi Mot'oğoy bez ǰomon taysuni caza baksuna q'abulezbi. Hunal bez günaxxo bağışlayinşenbi, bez taxsırxo bez ozane ten efi. ");
INSERT INTO udi_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Barta Vi yaq'en tağalt'in heq'ədər ki cügünu, Va afırıpi k'alpeq'an, T'e vədə bito ganu selenal ç̌axk'ayin Şot'ay turin t'ǒğəl tene şəyinbakon. ");
INSERT INTO udi_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Hunnu bez bač'an, Hunnu za bəlinəxun q'orişi Çark'esunen eçala mǔqluği səsurxo za q'ısmat balo. ");
INSERT INTO udi_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Q'ončuğon za metəre pi: «Va zomboz, Va düz yaq' manunesa, şot'o ak'est'oz. Va ögüd-nəsyət tadoz, Bez kula vaxun tez zap'k'al. ");
INSERT INTO udi_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Oč'ina t'ə̌q'eśi elem k'inək', Biq'i efes nu bakala ěk k'inək' haq'ılsuz ma bakanan. Şorox saycə sunt'ay bač'anen k'oval kəyit'uxun oşa, T'e sunt'ayal ozanen kəndür ak'it'uxun oşane haq'ullayinşaksa». ");
INSERT INTO udi_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Pist'oğoy bel nu eğala əş tene mandon, Q'ončuğo umudbakalt'oğoxun isə Şot'in İz nu badalbakala çuresuna kamtenebon. ");
INSERT INTO udi_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Barta Q'ončuğon düzgün bakalt'oğo mǔqt'eq'an, Barta şot'oğoy ç̌oyen axšumpeq'an! Şot'ay s'iya alabala mə̌ğur mə̌ğpanan, ay ük' təmiz bakalorox! ");
INSERT INTO udi_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ay düzgün bakalorox, Q'ončuğoy s'iya alabanan! Ük' təmizt'oğo Şot'o tərifləyinşbsune yarayinşbsa. ");
INSERT INTO udi_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Tər farpi Şot'ay s'iya alabanan, Vis' simlə arfinaxun c'eğala səsen Şot'o tərifləyinşanan! ");
INSERT INTO udi_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Şot'aynak' me təzə mə̌ğə̌ mə̌ğpanan, Mǔq səsurxo c'evksun, Ef başarağa ak'est'un farpanan! ");
INSERT INTO udi_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Axıri Q'ončux İzi tadi əyiti loxol çurk'alone, Hər əşlə axıral śirik' bex p'ap'esp'alone. ");
INSERT INTO udi_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Düzgün bakalo, həmişə düz q'ərar c'evk'alone Şo, Dirist' dünyənə İz çuresunen buybalone. ");
INSERT INTO udi_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Q'ončuğon İz sa əyiten göyurxone yaratmişi, İz sa əmiren muč'uliğone t'ak'p'i Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Şot'in dənizi xeyurxone girbi, Aruma ambara bapi iz ç̌omo ğaç̌k'ala k'inək' Bə̌ğə̌loy xeyurxone sagala bapi iz běšinə̌mə biq'i. ");
INSERT INTO udi_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Barta dirist' dünyənen Q'ončuğoy şu baksuna q'amişakeq'an, Barta me dünyəne yəşəyinşalt'oğon Şot'ay kalaluği běš bulq'at'un k'os'bi. ");
INSERT INTO udi_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Şot'o görə ki, bito Şot'ay ǰomoxun c'eğala sa əyitene baki, Bito Şot'ay sa əmirene bex p'ap'i. ");
INSERT INTO udi_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Q'ončuğon q'erəz azuk'xoy ük'exun c'ovakalt'oğo içoğoy boşe efon, Buxačuğo nu çalxalt'oğon bsun çureğalt'oğo puçane c'evk'on. ");
INSERT INTO udi_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Q'ončuğon İz ük'e biq'est'iyorox isə həmişəluğe, Şot'ay həzirbiyorox nəsiləxun nəsilə c'ovakiyal tene əfçibakon. ");
INSERT INTO udi_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","İz Buxačux Q'ončux bakala azuk', Q'ončuğon İçeynak' c'ək'p'i azuk' he bəxt'əvəre! ");
INSERT INTO udi_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Göynulxun běğalone Q'ončux, Sal sa insani balina İz piyexun nu aç̌esp'alone Şo. ");
INSERT INTO udi_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","İz məsk'ən saki ganuxun běği Me dünyəne məsk'ən sakit'oğone aksa Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","İçoğoy beynəl śirik' İçin yaratmişit'oğo, Lap içoğoy ük'exun c'ovakalt'oğoval avabakalt'oğo. ");
INSERT INTO udi_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Nə padçaği çark'esun izi q'oşuni geleluğaxun asulu tene, Nəəl sa q'oççaği çark'esun izi zoraxun. ");
INSERT INTO udi_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Davina c'eğat'an ěka umudbakala şey tene, Şot'ay zor tene amdara çark'est'alo. ");
INSERT INTO udi_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Q'ončuğoy pul İçu çalxalt'oğoy loxole, Hər şeyi Şot'ay nu badalbakala çuresunaxun eysuna věbakalt'oğoy loxol. ");
INSERT INTO udi_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Şone şot'oğo bisunaxun çark'est'alo, Busaluğ eğat'an yəşəyinşest'alo. ");
INSERT INTO udi_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Yan Q'ončuğoyan umud, Şone beş t'arnu p'ap'alo, yax q'orişalo. ");
INSERT INTO udi_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Beşi mǔqbakala ga Şone, Şot'ay ı̌velluğayan bač'an tarast'a yan. ");
INSERT INTO udi_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Ay Q'ončux, beşi Va umudbakala k'inək', Hunal yaxun Vi nu badalbakala çuresuna kammaba. ");
INSERT INTO udi_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Daviden içu Avimelek'i t'ǒğǒl gije gala laxat'an şot'o t'et'iin şəp't'unsa, şoval c'eri tanesa. Davidi me hadisinəxun oşa śampi Ǐvel mə̌ğ. Q'ončuğo nu şükürbala vaxt' tezax bu, Bez ǰomoxun həmişə Şot'ay s'iya alabala əyitmuxe c'eysa. ");
INSERT INTO udi_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Q'ončuğoxunez fərəxləyinşaksa zu, Barta fağırxoy mot'o ibaki ük' qayeśeq'an. ");
INSERT INTO udi_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ekinan zaxun sagala Q'ončuğo tərifləyinşen, Sagala Şot'ay s'iya alaben! ");
INSERT INTO udi_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Zu Q'ončuğoz afırıpi k'alpi, Şot'inal za inebaki, Bez pula haq'ala şeyurxoxun za çark'esedi. ");
INSERT INTO udi_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Şot'o qə̌věğalt'oğoy ç̌oyen axšumek'on, Ç̌omə̌yin tet'un bakon şorox. ");
INSERT INTO udi_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Mone, me fağıren Q'ončuğo k'alpi xoyinšebi, Şot'inal İz kula boxonedi, Şot'o bito əzyətxoxune çark'est'i. ");
INSERT INTO udi_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Q'ončuğo çalxalt'oğoy bač'ane Şot'ay angele çurk'on, Şot'oğo çark'esedon. ");
INSERT INTO udi_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Q'ončuğo ı̌šabakanan - Şot'ay heq'ədər şaat' baksuna ef piin ak'alnan, Şot'o bač'an taradalo he bəxt'əvəre! ");
INSERT INTO udi_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Q'ončuğo çalxanan, ay Q'ončuğoy c'ək'p'i ı̌vel azuk', Şot'in İçu çalxalt'oğoxun hik'k'ala kamtenebon. ");
INSERT INTO udi_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Cəyil aslanxo busa manedon, Ama Q'ončuğo bač'an taradiyorox eht'iyəci boş tene mandon. ");
INSERT INTO udi_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ǐšabakanan, ay bez baloox, za ǔmǔxlaxanan, Ekinan və̌x Q'ončuğoy laxi yaq'en taysun k'ə baksuna zombaz. ");
INSERT INTO udi_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Ef yəşəyinşi mǔq c'ovaksuna, Boxoy ömür c'ovakest'i şaat' ğimxo aksun çurnansasa, ");
INSERT INTO udi_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ef ǰomoxun pisluğen buy, Muzna belxun böht'an bosala əyitmux maq'an c'eri. ");
INSERT INTO udi_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Şərəxun ə̌xil baki şaat'luğ banan, Serluğ qə̌věśi şot'o ef arane eşt'una çalışakanan. ");
INSERT INTO udi_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Q'ončuğoy pul düzgünt'oğoy loxole bakon, Şot'oğoy xoyinša ibakseynak' ǔmǔxsəsele bakon. ");
INSERT INTO udi_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Pist'oğoy loxol isə Q'ončuğoy əcuğe bəc'ük'eğon, Oç̌ali ç̌oyelxun şot'oğoy tumane əfçibon Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Q'ončuğon düzgünt'oğoy xoyinša inebakon, Şot'oğo bito əzyətxoxun çark'esedon. ");
INSERT INTO udi_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Q'ončuğon ük' xə̌xə̌t'oğo tək tene bark'on, Umud eğala ga nu bakalt'oğo çark'esedon. ");
INSERT INTO udi_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Düzgünt'ay bel nu eğala əş tene mandon, Ama Q'ončuğon şot'o bito bəloğoxun zapi c'evek'on. ");
INSERT INTO udi_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Q'ončuğon şot'o t'etəre q'orişon ki, Şot'ay sa ǔq'enal tene xoxbakon. ");
INSERT INTO udi_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Şəren pist'ay axıra c'eğale, Düzgünt'u nifrətbalt'in iz cazina zap'k'ale. ");
INSERT INTO udi_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Q'ončuğon İz yaq'en tağalt'oğo bisunaxune zapi c'evk'on, Şot'oğoynak'al pis q'ərar tene tadeğon. ");
INSERT INTO udi_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Davidi Ǐvel mə̌ğ Zaxun əyitk'alt'oğoy coğaba Hun tada, ay Q'ončux, Zaxun davina c'eğalt'oğoy běš Hun c'eki! ");
INSERT INTO udi_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Hayza, q'alxana ext'a, Şuk'k'ala ǐša bist'a nu bark'ala q'alxana ext'i bez köməyə eki! ");
INSERT INTO udi_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Xişt'ik'ə, tavara ext'i bez bač'anexun baft'it'oğoy běš c'eki, \"Va çark'est'alo Zuzu!\" pi bez ük'ə arxayinba. ");
INSERT INTO udi_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Barta bez bisuna çureğalt'oğoy niyət içoğoy boş mandi içoğoy ç̌oyen ot'p'eq'an, Bez pisa çureğalorox biyaburbakiq'at'un qoş qaybaki. ");
INSERT INTO udi_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Barta şorox Q'ončuğoy angeli běš Muşen fupi taşala kološ k'inək'q'at'un baki. ");
INSERT INTO udi_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Barta Q'ončuğoy angelen şot'oğo şəp'eğat'an İçoğoy t'it'ala yaq' bayinq' saal fırs'ek'alq'an baki. ");
INSERT INTO udi_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Nahaq' gala zaynak' tor laxsuna görə, Hik'k'ali loxol zaynak' kur kašpsuna görə. ");
INSERT INTO udi_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Barta içoğoy bel sal içan nu yaq'běğala bəlooxq'an hari, Laxi tora içoğoy turq'an ləc'üreśi, Kašp'i kura içanq'at'un baft'i. ");
INSERT INTO udi_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Zuval Q'ončuğon bit'oğo ak'i mǔqbakoz, Şot'oxun eğala çark'esuna ak'i bez ük' qayeğale! ");
INSERT INTO udi_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","\"Vallarik'o tene bu!\" pi bez ǔq'enxonal muz qayk'ale. Hun zəyift'u içuxun zorbat'ay kiyexun haq'alo, Kəsibxo q'a fağırxo içoğo fǔq'k'alt'oğoxun çark'est'alonu. ");
INSERT INTO udi_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Əfçi şahidxone hayzeri bez ç̌oyel çure, Bezi sal xavar nu bakala əşurxot'un bez ozane laxsa. ");
INSERT INTO udi_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Bez bi şaat'luğa pisluğent'un coğab tast'a, İz ǐšat'u aç̌esp'i sa amdar k'inək'zu zu. ");
INSERT INTO udi_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Zu isə şorox azarayinşakat'an mə̌yin lapi yasez efi, Ğurux efi busaz tarapi zu, Şot'oğoynak' heq'ədər Buxačuğoz k'alpi! Bez afırı coğabsuz mandat'an isə ");
INSERT INTO udi_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Dost'eynak', viçeynak' p'i mə̌yinbakala k'inək'e bez p'i mə̌yinbaki, Nana aç̌esp'i amdaren q'ubarbala k'inək'ez q'ubarbi zu şot'oğoynak'. ");
INSERT INTO udi_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","İsə mone, zu t'arnuzu - ama şorox mǔqt'unbaksa, Gireśi bez pisat'un əyite. Bezi memaçağ sal içoğoy ç̌oya nu ak'i me pist'oğo Bez ç̌oyel çurpest'unaxun mandak' tet'un baksa. ");
INSERT INTO udi_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Bez loxolt'un axšume me buxačuxsuzt'oğon, ak'ala pul tene bu za şot'oğoy! Bez loxolt'un eysa şorox kašk'ala xə̌ amdari loxol eğala k'inək'. ");
INSERT INTO udi_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Ay Q'ončux, hələ heq'ədər mot'o nu aksuna laxalnu? Ə̌xilba za me pisluğxoxun, Çark'est'a za me aslanxoy ǰomo bafst'axun! ");
INSERT INTO udi_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Va bul k'os'bseynak' gireśi viçimoğoy běš zu Vi s'iya alaboz, Camaati boş Va tərifləyinşoz. ");
INSERT INTO udi_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Ma barta zaxun nahaq' gala düşmənçiluğbalorox mǔqbakat'un, Ma barta za hik'k'ali loxol nifrətbalt'oğon suna himbat'un. ");
INSERT INTO udi_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Şot'oğon ǰomo serluğ eşt'eynak' təə, İçoğoy bula k'os'bi yəşəyinşalt'oğoy ç̌oyel əfçidən çurpseynak't'un ə̌mbsa. ");
INSERT INTO udi_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","İçoğoy ǰomo buybi \"Ak'eyan, ak'eyan, bitova beş piin ak'eyan\" next'un. ");
INSERT INTO udi_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Ay Q'ončux, Hun mot'oğo bitova anksa, şip' ma çurpa, Zaxun ə̌xil ma baka, ay Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Hayza, bez bač'ane çurpa, ay Buxačux! Bez əşlə Hun běğa, ay bez Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Vi düzgünluği k'ə baksuna ak'est'a, ay bez Buxačux bakala Q'ončux! Bez taxsırsuz baksuna ç̌oyel c'evk'a, Ma barta bez t'ar ğina ak'i mǔqbakat'un. ");
INSERT INTO udi_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Ma barta ki, \"mone, beşi çureğala k'inək'əl baneki\" uk'at'un, \"İz bula kəyyan\" pi mǔqbakat'un. ");
INSERT INTO udi_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","T'etər ba ki, bez pis ğina mǔqbakalorox ot'p'i biyaburbakeq'at'un, Bez loxol alaxun oq'a běğalorox ç̌omə̌yin baki Sal içoğoy bula alabes maq'at'un baki. ");
INSERT INTO udi_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Barta bez düzgün baksuni ç̌oyel c'eysuna çureğalt'oğoy ük'q'an qayeśi, \"İz k'ule şaat'a çureğala Q'ončuğo alxışq'an baki\" pi həmişə Vi s'iyaq'at'un alabi. ");
INSERT INTO udi_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Vi düzgünluğa bayanboz zu, Vi s'iya alabala əyitmux c'eğale bez ǰomoxun hər ği! ");
INSERT INTO udi_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Fark'alxoy dəst'in kalat'aynak'. Q'ončuğoyk'ul bakala Davidi Ǐvel mə̌ğ. Günaxbsun pis amdari ük'exune eysa, Buxačuğoxun q'ı̌tenebsa şot'in. ");
INSERT INTO udi_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","İçuxun t'ema irəzine ki, Nə iz taxsırane q'amişakes baksa, nə t'e taxsıra nifrətbes. ");
INSERT INTO udi_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","İz ǰomoxun pisluğ q'a əfçine c'eğon, Müdrikluği q'a şaat'luği k'ə baksuna tene ava şot'in. ");
INSERT INTO udi_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Bask'i galal pisluğbsunaxune fikirbsa, Pis yaq'en taysunane c'ək'p'e, Şər əş biq'sunaxun kultenehaq'sa şot'in. ");
INSERT INTO udi_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Ay Q'ončux, Vi nu badalbakala çuresun me dünyəne p'aq'ala şey tene, Vi beş bač'ane çurpsun göyurxone p'ap'sa. ");
INSERT INTO udi_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Vi düzgünluğ buruxmux k'inək' kalane, Vi düzgün divanbsun oqurxoy tum k'inək' bə̌ğə̌loye. Ay Q'ončux, insanal, heyvanal q'orişenbsa Hun! ");
INSERT INTO udi_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Ay Buxačux, Vi nu badalbakala çuresuni toy butene, Vi xojinane tarane insani baloox. ");
INSERT INTO udi_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Vi k'oje şot'oğo boşevk'ala bolluğ, Vi oq k'inək' tağala şaat'luğe şot'oğoy xenezaluğa bot'alo. ");
INSERT INTO udi_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Şot'aynak' ki, Vast'ane yəşəyinşi orayin, Vaxun eğala işiğe yax yəşəyinşest'alo. ");
INSERT INTO udi_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Va çalxalt'oğo Vi nu badalbakala çuresuni k'ə baksuna ak'est'a ki, Ük' təmizt'oğon Vi düzgünluği k'ə baksuna ak'eq'at'un. ");
INSERT INTO udi_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Ma barta içuxun irəzit'ay turin oq'a ç̌axç̌uxeśi tağaz, Ma barta pist'ay kul za p'ap'ane. ");
INSERT INTO udi_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Mone, bitet'un pisorox, turin oq'a ç̌axç̌uxeśi tat'unsa, İçoğoy bula alabes tet'un bakal ene şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Davidi Ǐvel mə̌ğ. Pisluğbalt'oğoy fikirə ma zapa, Haq'suzluğbalt'oğo paxılluğ ma ba, ");
INSERT INTO udi_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Şot'aynak' ki, şorox usumluğen o k'inək' q'aribakalt'un, Göyün bitk'i k'inək' nešum bakalt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Q'ončuğo umudbaka, şaat'luğ ba, Şotay laxi yaq'axun ma c'eki, me ölkinə şip'luği boş yəşəyinşa. ");
INSERT INTO udi_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Q'ončuğoxun mǔqbaka, Şot'inal vi ük'en çureğalt'oğo p'ap'esp'ale. ");
INSERT INTO udi_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Vi bütüm yəşəyinşə Q'ončuğo tapşurba, Şot'o ext'ibərba, Şot'inal vaynak' mot'oğo bale: ");
INSERT INTO udi_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Düzgünluğa savaxt'in işiğ k'inək' ç̌oyel c'evk'ale, Vi haq'q'a ğene işiğ k'inək' qay ak'est'ale. ");
INSERT INTO udi_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Q'ončuğoy běš naşükürluğ ma ba, Səbirlu baki yaq'běğa, Pist'oğoy běš baysuna, İçoğoy pis niyətxoy bex p'ap'suna fikir ma tada. ");
INSERT INTO udi_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Vi hirsə t'ǒǒx bosa, əcuğaxun zap'eki, Fikir ma tada, mot'oğon amdareynak' saycə zərəle eçon. ");
INSERT INTO udi_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Axıri haq'suzluğbalxo əfçibakalt'un, Q'ončuğo umudbakalt'oğon isə Şot'in əyit tadi ölkinə mülk k'inək' haq'alt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Samal yaq'běğa, haq'suzluğbalo əfçibakale, Lap iz baki galal qə̌věğayin, ten bə̌ğə̌bal. ");
INSERT INTO udi_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Fağırxon isə me oç̌ala mülk k'inək' haq'alt'un, Q'azayinşi bol xeyir-bərəkətəxun mǔqbakalt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Şər amdaren düzgün amdara pisluğ bsune çuresa, İz əcuğoxun uluxxone ğırıc'est'a. ");
INSERT INTO udi_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Ama Q'ončuğon haq'suzluğbalt'ay loxol axšumene, Axıri avane ki, şot'ay coğab tadala ği ı̌šane. ");
INSERT INTO udi_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Kəsibə, fağıra oq'a sakseynak', Düz yaq'en tağalt'u əfçibseynak' Haq'suzluğbalt'in q'ılınce c'evk'on, silaxe əşp'est'on. ");
INSERT INTO udi_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Ama şot'oğoy q'ılıncxo içoğoy ük'e t'ə̌q'ěğale, Silaxxo xə̌xə̌yeğale. ");
INSERT INTO udi_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Düzgün amdari kəsədluğ Pis amdari var-dövlətəxun şaat'e. ");
INSERT INTO udi_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Şot'aynak' ki, haq'suzluğbalt'oğoy zor irameğale, Düzgünt'oğo isə Q'ončuğon kul biq'ale. ");
INSERT INTO udi_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Düzgünt'oğoy yəşəyinş Q'ončuğoy piin běše, Şot'oğon me ölkinə həmişəluğ miras k'inək' haq'alt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Şot'oğon t'ar ğine tet'un ot'p'al, Q'idluğ bakala ğimxost'a boş tapanen tarak'alt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Ama haq'suzluğbalxo əfçibakalt'un, Q'ončuğoy düşmənxo q'oruği vardurxo k'inək' şerebakalt'un, K'üün k'inək' usumluğen əfçibakalt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Haq'suzluğbalen iz borcal tene qayst'a, Düzgün amdar isə bitot'aynak' kulqaye. ");
INSERT INTO udi_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Q'ončuğoxunxeyir-bərəkət haq'it'oğon ölkinə mülk k'inək' haq'alt'un, Şot'oxun ləənət haq'iyorox isə əfçibakalt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Əgər Q'ončux amdari tağala yaq'axun irəzinesa, Şot'o iz tağala yaq'a q'orişebon. ");
INSERT INTO udi_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Me amdar lamanaldayin tene biton, Şot'aynak' ki, Q'ončuğon şot'ay kulaxun bineq'on. ");
INSERT INTO udi_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Bez cəyilluğaxun həysət'inəl śirik', Bezi me q'oja vədine düzgün amdari t'ǒǒx bosesuna, İz əyloğoy šumeynak' dilənçiluğbsuna tez ak'e. ");
INSERT INTO udi_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Şot'in həmişə kulqayluğene borc tast'a, İz əyloğoxun xeyir-bərəkəte eysa. ");
INSERT INTO udi_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Şər əşləxun ə̌xilbaki şaat'luğba ki, Vi ömür boxoy bakane. ");
INSERT INTO udi_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Q'ončuğon düzgünluğe çuresa, Şot'aynak'al sal sa vədə İçu q'ulluğbalt'u tene boson. Şot'in düzgün amdarxo həmişə q'orişi efale, Haq'suzluğbalxo isə nəsilluğen əfçibale. ");
INSERT INTO udi_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Düzgün amdarxon ölkinə mülk haq'alt'un, Şot'oğon ölkinə həmişəluğ məsk'ən sakalt'un. ");
INSERT INTO udi_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Düzgün amdari ǰomoxun müdrik əyitmuxe c'eysa, İz muzen haq' əyite nex. ");
INSERT INTO udi_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Şot'aynak' ki, iz Buxačuğoy k'anun iz ük'est'ane, İz tural tene lamanst'a. ");
INSERT INTO udi_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Haq'suzluğbalt'in düzgün amdara irizləyinşebsa, Şot'o bespseynak' yaq'e qə̌věsa. ");
INSERT INTO udi_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Ama Q'ončuğon düzgün amdara haq'suzluğbalt'uxun q'orişebon, Şot'ay ç̌oyel əfçidən çurpi pis q'ərar tadesunaxun enefon. ");
INSERT INTO udi_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Q'ončuğo umudbaka, Şot'ay yaq'en taki, Şot'inal va ěqevk'i me ölkinə mülk tadale, Haq'suzluğbalxoy əfçibaksunal ak'alnu. ");
INSERT INTO udi_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Sa haq'suzluğbala zalım amdarez ak'ey, Şo barlu oç̌ala tum duği alloy xod k'inək' ěqesay. ");
INSERT INTO udi_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Ama şo əfçinebaki, iz gaal ams'ine mandi, Şot'o gelez qə̌věśi, tez bə̌ğə̌bi. ");
INSERT INTO udi_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Ük' təmizt'oğoy loxol běğa, Vi pul düzgün bakalt'ay loxolq'an baki, Şot'o görə ki, gələcəy serluğ çureğalt'oğoye. ");
INSERT INTO udi_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Ama günaxkərxo bito əfçibakalt'un, Haq'suzluğbalxoy axır tene bakal. ");
INSERT INTO udi_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Düzgün amdarxoy çark'esun Q'ončuğoxune, Şot'ot'un bač'an tarast'a şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Q'ončuğon şot'oğo köməyebsa, Şot'oğo haq'suzluğbalxoy kiyexun haq'i çark'esest'a, Şot'aynak' ki, Q'ončuxe şot'oğoy umudi ga. ");
INSERT INTO udi_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Davidi Q'ončuğon içu eyex bast'eynak' bakala Ǐvel mə̌ğ. Ay Q'ončux, hirsləyinşəki za töhmətmaba, Əcuğon biq'i za caza ma tada! ");
INSERT INTO udi_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Tə̌q'eśene za Vi tərbi oxurxo, Vi kiin tadala cazinen za biq'ene. ");
INSERT INTO udi_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Vi əcuğaxun bez bədənə dirist' ga tene mande, Bez günaxxo görə bez ǔq'enxoval azarine. ");
INSERT INTO udi_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Bez taxsırxon za haq'layinşene, Me yükə xork'ala zor tezax bu. ");
INSERT INTO udi_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Bezi axmağluğaxun Bezi yaroxal bašaybakene. ");
INSERT INTO udi_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Bez bač'an k'os'bakene, oç̌alane p'ap'sa, Dirist' ği q'ubarbsunez tarane zu. ");
INSERT INTO udi_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Bez bədən q'ızdırmin boş boneksa, Bez loxol dirist' ga tene mande. ");
INSERT INTO udi_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Halnuxun bitezu, mafarsuzzu. Ük'e q'ač'axun ıhıldayinşezbsa. ");
INSERT INTO udi_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Ay Q'ončux, Hun avanu zu k'əz çuresa, Bezi koruğxo Vaxun c'ap' tene. ");
INSERT INTO udi_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Bez ük'ene kape, ene zor tezax bu, Bez pulmuxal bayinq'bakene. ");
INSERT INTO udi_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Bez azara görə bez dost'urxon, çalxalxon za bot'unsi, Bez q'oomxo zaxun ə̌xilt'un baki. ");
INSERT INTO udi_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Za bespsun çureğalt'oğon zaynak' tələt'un laxsa, Pisluğ bsun çureğalt'oğon za q'arğişt'unbsa, Biyəbakamin bez loxol şərt'un bost'a. ");
INSERT INTO udi_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Ama za kare gala laxi itezbaksa, Lale gala laxi bez ǰomo tez ə̌mbsa. ");
INSERT INTO udi_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Zu hik'k'ala nu ibaksun, Şuk'k'ali coğabal tast'un nu çureğala sa amdar k'inək'zu. ");
INSERT INTO udi_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Ay Q'ončux, bez umud Vane mande, Vi yaq'az běğsa, Ay Ala Arśi bez Buxačux, şot'oğoy coğaba Hun tadalnu! ");
INSERT INTO udi_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Xoyinšezbsa, ma barta bez hala ak'i mǔqbakat'un, Bez lamanst'una görə içoğo zaxun ala biq'at'un. ");
INSERT INTO udi_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Zu ene bist'axzu, Bez q'ač'urxo həmişə zaxune. ");
INSERT INTO udi_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Bez günaxxo bez ozane exest'a, Bez taxsırxo görəz əzyət zap'e zu. ");
INSERT INTO udi_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Bez düşmənxo isə zorbat'un, hələ dirist't'un, Nahaq' gala za nifrətbalxo gelebaket'un. ");
INSERT INTO udi_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Zu şaat'luğezbsa - içan pisluğt'unbsa, Bezi şaat'luğ bsuna pisluğ bsunent'un coğab tast'a. ");
INSERT INTO udi_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Ay Q'ončux, za tək ma barta, Ay bez Buxačux, zaxun ə̌xil ma baka! ");
INSERT INTO udi_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Ay Q'ončux, usum bez köməyə eki, Bezi Çark'est'al Hunnu! ");
INSERT INTO udi_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Fark'alxoy kalo bakala Yedutuneynak' śameśi Davidi Ǐvel mə̌ğ. Za metərez pi: «Bez əyitmoğo fikir tadoz, Bez ǰomoxun c'eğalt'oğon za günaxa bast'una imkan tez tadal, Pis amdarxoxun ç̌o-ç̌oya eğat'an bez muza girboz». ");
INSERT INTO udi_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Ama bez muza efi vədine, Lap şaat' şeye barada nu əyitk'ala vədineyal, Dərde loxol dərde hari bezi. ");
INSERT INTO udi_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","T'e vədə bez ük'en za uksane burqi, Fikirbi t'e ğinaz baft'i ki, ene za efes tez baki, Bez ǰomo ə̌mbi əyitk'alaz baki, metərez pi zu: ");
INSERT INTO udi_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","«Ay Q'ončux, bezi me dünyəne sa q'onağ baksuna, Bisunaxun nu t'it'es baksuna ak'est'a za! Barta me dünyəni t'ǒğə nu biq'i çurpes baksuna q'amişakaz!» ");
INSERT INTO udi_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Pula q'ic'p'i qayk'amin zap'k'ala ömüren usk'i zaynak', Vi həmişəluğ baksuni běš hik'k'ale mo! Sa muş k'inək'e hari c'ovaksa insani ömür, şo həgigiyal hik'k'ale. ");
INSERT INTO udi_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Tarak'ala xoji k'inək'e insan, q'erəz hik'k'al, Ams'i galane çabalayinşbsa, İz girbi var-dövlət şu mandale, şot'oval avabakala şey tene sal. ");
INSERT INTO udi_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Ay Q'ončux, ene şuxun k'əz yaq'běğes bakon zu? Bez umudi ga saycə Hunnu! ");
INSERT INTO udi_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Os'k'a taşa bez taxsırxo bit'ova. Axmağxoynak' axšumi ga baksa ma barta. ");
INSERT INTO udi_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Şip'ez çurpi zu, bez səsə tez c'evksa, Axıri Vi tadi cazinaz zap'e zu. ");
INSERT INTO udi_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Ə̌xilba Vi kiin tadeğala cazina zaxun, Porttezbsa zu, şot'ay bı̌hı̌luği oq'axun c'eyes tez baksa. ");
INSERT INTO udi_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","İz biq'i əşurxoy cazinan tast'a Hun amdara, İz taxsırxo görə bakala əzyətə zapest'at'an İz girbit'oğoy puçbaki taysunan ak'est'a Hun şot'o. İnsan həgigiyal hik'k'ale! ");
INSERT INTO udi_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Ay Q'ončux, bezi xoyinša ibaka, Bezi Va k'alpsuna coğabsuz ma efa, Nu aksuna ma laxa bez neğ śipsuna. Bez bavoğoxun-kalboğoxun avuzin tezu zu, Me dünyəne sa q'onağ k'inək'ez hare zuval. ");
INSERT INTO udi_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Bez loxol bəc'ük'eśi əcuğo bask'est'a, bez loxol běğa samal, Barta t'e dünyəne tağamin bez ç̌oyenal axšumpeq'an. ");
INSERT INTO udi_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Zu Q'ončuğoz umudbaki yaq'běği, Şot'inal bez loxol běneği, bez şivana inebaki. ");
INSERT INTO udi_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Şot'in za kurnuxun, Oç̌alin oq'axune zapi c'evk'i. Za şuk'k'ali kul nu p'ap'seynak' q'ayani loxole laxi, Bez tura laxala ganune ost'aarbi. ");
INSERT INTO udi_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Təzə sa mə̌ğě mə̌ğpest'i za, Beşi Buxačuğo tərifbala mə̌ğ. İsə gelet'in Q'ončuğo çalxale, Şot'o güvəyinşaki içeynak' umudi ga bale. ");
INSERT INTO udi_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Q'ončuğo güvəyinşakalo he bəxt'əvəre! Bəxt'əvəre içoğoxun irəzit'oğoxun sa yaq'en nu tağalo, Əfçi şeymoğoy qoşt'an t'it'alt'oğo nu gərbakalo. ");
INSERT INTO udi_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Ay bez Buxačux bakala Q'ončux, Vi bit'oğoxun, Vi yaynak' həzirbit'oğoxun əyitp'i çark'ala şey tene - Vallarik'o butene! Hetərez Vi əşurxo bayanbes bakon? Mani əyitmoğonez mot'oğo bitova ak'est'es bakon? ");
INSERT INTO udi_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Vi çureğalo nə q'urbanxo, nəəl payurxo tene baki, Zaxun nə bok'ospsuni q'urbanxo, Nəəl günaxxo os'kseynak' bakala q'urbanxo ten çureśi. Zaxun bez ǔmǔğo qaypi Va ibaksunan çureśi Hun! ");
INSERT INTO udi_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Mot'o görəz pi: «Mone, ezsa zu, Bezi barada śameśi k'inək' ezsa! ");
INSERT INTO udi_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Vi çureğalt'oğo bex p'ap'espseynak'ez eysa, Zaxune Vi k'anunxo, ay Buxačux». ");
INSERT INTO udi_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Vi düzgünluği k'ə baksuna bayanezbi zu Va bul k'os'bseynak' gireśi viçimoğoy běš, Mot'o bez boş tez efi, avanu Hun, ay Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Bitot'ay pulaz qaypi, ak'esezdi Vast'a bakala düzgünluğa, Vi yaq'en tağalt'oğoy bač'ane çurpi şot'oğo kul boxost'una. At'unk'i t'e gireśi viçimoğon Vast'a bakala nu badalbakala çuresuna, İçoğoy şaat'a çureśi şot'oğoynak' ük' bok'ospsuna. ");
INSERT INTO udi_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Vi ük' bok'ospsuna zaxun kammaba, ay Q'ončux! Barta Vi nu badalbakala çuresunen q'a bezi bač'ane çurpsunen za həmişə q'orişeq'an! ");
INSERT INTO udi_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Hər t'ǒğǒlxun sa bələne c'eysa zaynak', Bəloğoy kiyexun galpes tez baksa, t'ema gelene şorox. Bez taxsırxon za t'etəre haq'layinşe ki, bez pulmuxe bayinq'baksa. Ük' tene mande zast'a, bez biin popaxun gele günaxzax bu bezi. ");
INSERT INTO udi_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Ay Q'ončux, bez loxol běğa, çark'est'a za, Eki p'ap'a, za kul boxoda, ay Q'ončux. ");
INSERT INTO udi_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Barta bez elmoğo haq'sun çureğalorox ot'p'i biyaburbakeq'at'un, Barta bez pis ğina mǔqbakalorox ç̌omə̌yin qoşq'at'un qaybaki. ");
INSERT INTO udi_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Barta bez loxol axšumpi k'əşinen ak'est'alt'oğon Sal içoğoy bula alabes maq'at'un baki! ");
INSERT INTO udi_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Va qə̌věğalorox isə barta mǔqbakeq'at'un, Barta ç̌oyenq'an axšumpi şot'oğoy, Barta Hun şot'oğo Vaxun eğala çark'esuna ak'est'at'an \"Q'ončux kalane\" pi içoğoy ük'q'an qayeśi. ");
INSERT INTO udi_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Zu isə gorox, fağır sa amdarzu, Barta Q'ončuğon İz kula zaxun maq'an zapi. Hunnu za çark'est'alo, za kul boxodalo, ay bez Buxačux! Barta bez pul yaq'a maq'an mandi! ");
INSERT INTO udi_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Kəsibxoy ğina ǒnek'alo he bəxt'əvəre! Şo t'arnu baft'at'an Q'ončuğon şot'o kule boxodon. ");
INSERT INTO udi_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Q'ončuğon şot'o q'orişi enefon, Bəxt'əvərluğe eçon şot'aynak' t'e oç̌ala, Düşmənxoy kiyel bafst'a tene bark'on şot'o. ");
INSERT INTO udi_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Azari běšinə̌mə haq'seynak' elmuxe tadon şot'o Q'ončuğon, Bask'i ganuxun hayzevk'i turelebon şot'o. ");
INSERT INTO udi_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Metərez afırıpi xoyinšp'i: «Ay Q'ončux, avazu, günaxkərzu zu, Za gorox eki, q'olayba za». ");
INSERT INTO udi_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Mone, bez pisat'un çuresa bez düşmənxon, \"Mo hevaxt' p'uri tağale, iz s'i əfçibakale\" pi ğit'un bǒq'ə̌le. ");
INSERT INTO udi_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Za lafst'a eğat'an bez ç̌oye axšumalk'ayt'un, İçoğoy ük' şəren buye: Ç̌omoxun c'eysun q'a bitot'ay t'ǒğǒl bez pisə əyitpsun sane baksa. ");
INSERT INTO udi_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","J̌omoz baft'i zu şot'oğoy, İçoğoy əş bez bač'anexun əyitpsune. ");
INSERT INTO udi_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","\"İz sa tur gərəmzoğone, Mandala tene, azaren sakene şot'o\" next'un. ");
INSERT INTO udi_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Lap bezi ǐša dost' k'inək' çalxiyo, Bez ük'ə iz t'ǒğǒl ams'ibiyo, Bezi šuma kəyi bez loxolxun ç̌axp'i c'ovakiyone baki. ");
INSERT INTO udi_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Ama Hun za gorox eki, ay Q'ončux! Za turelba, barta mot'ay əvəzə şot'oğoxun c'eğaz. ");
INSERT INTO udi_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Düşməni turin oq'a ç̌axç̌uxeśi nu tağayiz, Bezi Vi piyes şaat' ak'esuna avabakoz. ");
INSERT INTO udi_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Vi za kul boxost'una, Bezi düzgün baksuna görə za q'orişi efsuna avabakoz. Vaxun eğala şaat'luğen həmişəluğ mǔqt'ale za! ");
INSERT INTO udi_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","İsraili Buxačux bakala Q'ončuğo alxışq'an baki! Nəyniyal, ğeyal, əyc'əl - həmişə alxışq'an baki! Ammen! Ammen! ");
INSERT INTO udi_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Fark'alxoy dəst'in kalat'aynak'. Goraxi ğarmoğon śampi ögüd-nəsyət tadala Ǐvel mə̌ğ. Marali turmoğon içu xe tağala ganu eçala k'inək', Bez ük'enal za Vaçe eşt'a, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","İz ük' xeneynak' bok'ala amdaren xe qə̌věğala k'inək'ez qə̌věsa Va! Dirist' bakala Buxačuğoz qə̌věsa! Vi bakala gala hari Va bul k'os'bseynak' ğiz bǒq'ə̌le! ");
INSERT INTO udi_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Za hər dəfə \"p'oy maya vi Buxačux?\" uk'at'an Üşe-ğena ǒnepi neğen tapanez boşevk'i zu. ");
INSERT INTO udi_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Axsibay c'ovakest'ala azuk'i aranexun c'ovaki Vi ı̌vel gala taysun bez eyex baft'at'an ük'e q'aç̌e bezi. Amdarxon Va alxışp'at'an c'eğala mǔq səsurxoy həsrətəz zap'e. ");
INSERT INTO udi_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Het'aynak'en xə̌xə̌yesa, ay bez ük'? Het'aynak'en q'ubarbsa? Buxačuğost'a ak'a umudi ganu hun! Vi Çark'est'al bakala, vi şükürbi İz s'iya alabala Buxačuğost'a! ");
INSERT INTO udi_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Xə̌xə̌ne bez ük', Vane çuresa me İordan oç̌ala, Me Xermon q'a Miśar uk'ala buruxmoğo. ");
INSERT INTO udi_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Şot'oğoxun barala xenen za haq'i taşala k'inək'ez hisbsa za! Bito Vi dalğoox, bito Vi ləpooxe hari bez belxun c'ovaki. ");
INSERT INTO udi_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Ğenaxun Q'ončuğone za İz nu badalbakala çuresuna ak'est'a, Üşemoğo isə Şot'o k'alpi afırıpsunen, Za yəşəyinş tadi Buxačuğoy s'iya alabala mə̌ğur mə̌ğpsunenez c'ovakest'a zu. ");
INSERT INTO udi_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Zaynak' sa q'aya bakala Buxačuğo metər uk'oz: «Het'aynak'en za eyexun c'evk'i? Het'aynak'en za düşməni turin oq'a tadi neğ śipest'i?» ");
INSERT INTO udi_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Axšumi gaz bake düşmənxoynak', Za hər dəfə \"maya p'oy vi Buxačux?\" uk'at'an Bez ük'e xançal badala k'inək'e baksa. ");
INSERT INTO udi_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Het'aynak'en xə̌xə̌yesa, ay bez ük'? Het'aynak'en q'ubarbsa? Buxačuğost'a ak'a umudi ganu hun! Vi Çark'est'al bakala, vi şükürbi İz s'iya alabala Buxačuğost'a! ");
INSERT INTO udi_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Ay Buxačux, bezi me buxačuxsuzt'oğoxun bakala əşlə Hun běğa, Bezi taxsırsuz baksuna ç̌oyel c'evk'a. Əfçiduğalxoxun q'a içoğoy ük' şəren buy bakalt'oğoxun çark'est'a za! ");
INSERT INTO udi_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Bezi bač'an Hunnu, ay Buxačux! Het'aynak'en zaxun ç̌o taradi? Het'aynak' zu düşmənxoynak' axšumi ga baki ǒnek'a tarak'az? ");
INSERT INTO udi_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Barta Vaxun eğala işiğen q'a Vi seri əyitmoğonq'an za yaq' ak'est'i, Barta za Vi ı̌vel buruğo taşeri Vi bakala ganuq'at'un eçeri. ");
INSERT INTO udi_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Zuval Buxačuğoynak' q'urban eçala ganu, Za mǔqt'ala, bez ç̌oya axšumdala Buxačuğoy t'ǒğǒlez eğon. Vaynak' arfa farpi Vi s'iyaz alabon, Ay Buxačux, ay bez Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Het'aynak'en xə̌xə̌yesa, ay bez ük'? Het'aynak'en q'ubarbsa? Buxačuğost'a ak'a umudi ganu hun! Vi Çark'est'al bakala, vi şükürbi İz s'iya alabala Buxačuğost'a! ");
INSERT INTO udi_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Fark'alxoy dəst'in kalat'aynak'. Goraxi ğarmoğon śampi ögüd-nəsyət tadala Ǐvel mə̌ğ. Ay Buxačux, beş bavoğon exlətp'at'an Beş ǔmǔğonyan ibake Vi bit'oğoy barada, Vi içoğoy kalboğoxunal běš, Hələ lap damna döörəst'ə bit'oğoy barada. ");
INSERT INTO udi_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Hetəren Hun q'erəz millətxo şəp'eśi Beş bavoğo eçeri me oç̌ala arśest'i. Hetəren t'e azuk'xoy ğina mə̌yinbi, Beş bavoğo isə işiğa c'evk'i. ");
INSERT INTO udi_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Davabi tet'un haq'i şot'oğon me oç̌ala, Zor əşp'est'i tet'un içoğoy kiyel badi. Vi kiin, Vi zorent'un haq'i! Vi ük'e basksuna görə, Şot'oğoxun Vi çuresuna nu kambsuna görət'un baśi arśes baki. ");
INSERT INTO udi_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ay Buxačux, Hunnu bez Padçağ, Hunnu İak'ovi nəsiləxun davabalt'oğo taşevk'est'alo! ");
INSERT INTO udi_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Yan Vi köməyenyan beşi düşmənxo şəp'esa, Vi yax tadala zorenyan beşi loxol ěqeśit'oğo ç̌axç̌uxp'es baksa. ");
INSERT INTO udi_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Bezi dǒpt'i sakes baksuna tez güvəyinşaksa zu, Bez q'ılınc tene bezi loxol eğalt'u sakalo. ");
INSERT INTO udi_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Hunnu yax beş düşmənxoy kiyexun çark'est'alo, Yax nifrətp'alt'oğo biyaburbi ot'p'est'alo. ");
INSERT INTO udi_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Beşi ği Buxačuğo alxışpsunene c'ovaksa, Vi s'iya alabalyan yan həmişə! ");
INSERT INTO udi_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Ama, mone, yaxun ç̌on taradi Hun, Yanal biyaburbaki ç̌omə̌yinyan mandi, Düşməni loxol tağat'anal beş q'oşunaxun ten baksa ene Hun. ");
INSERT INTO udi_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Yax şot'oğoy běš badi şəp'eśesendi, Yax nifrətp'alt'oğon hari yax fǔq't'unpi. ");
INSERT INTO udi_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Eğela canavari ǰomo tadala k'inək' yax şot'oğoy ǰomon tadi Hun, Millətxoy arane gərgürbaki tayanśi. ");
INSERT INTO udi_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Xene toyenen toydi Vi azuk'a, Vi piyes sa köpiluğal teyan baki! ");
INSERT INTO udi_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Q'onşiğoynak' axšumi gayan bake, Ot'exun beş bula alabes teyan baksa yan. ");
INSERT INTO udi_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","T'iyə̌mi azuk'xoy ǰomo k'əc'yansa, K'əşinen ak'est'it'un axšume beş loxol. ");
INSERT INTO udi_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Bask'i-hayzeri me biyaburçiluğ zaxune, Oç̌al qı̌bakayin bazğon zu. ");
INSERT INTO udi_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Za nifrətbala düşməni axšume bez ak'alo, Bez loxol bosala əyitmuxe bez ibakalo. ");
INSERT INTO udi_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Manu ki, Vi laxi k'anunxoxun teyan c'eysay yan, Vaxun ğaç̌eśi irəziluğa əməlyanbsay, Ama p'urumal me əşure hari beş bel. ");
INSERT INTO udi_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Vaxun beş ük' tene irapey, Vi laxi yaq'axun teyan c'eysay yan, ");
INSERT INTO udi_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Ama Hun p'urumal oç̌alen sanbi yax. Beş k'ojurxo xarabinan c'urevk'i, Zülmət bayinq'luğenen bəc'ürpi Hun yax. ");
INSERT INTO udi_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Yəni yan beş Buxačuğoxun ç̌o taradi bakiyaniy, Kula alabi q'erəz buxačuğo k'alpi bakiyaniy, ");
INSERT INTO udi_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Bitot'oğoy ük'e boş bakalt'oğo ak'ala Buxačuğoxun c'ap' manedoy ki mo? ");
INSERT INTO udi_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Yan Vi laxi yaq'en taysuna görə beşi elmoğot'un haq'sun çuresa hər ği, Šameseynak' bakala sa eğeli loxol běğala k'inək't'un běğsa beş loxol! ");
INSERT INTO udi_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Ay Q'ončux, het'aynak'en şip' çurpe? Hayza, Vi şu baksuna ak'est'a! Vi kula yaxun ma zapa həmişəluğ. ");
INSERT INTO udi_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Het'aynak'en yaxun Vi ç̌oya taradi? Het'aynak'en beş dərdə q'a əzyətxo nu aksuna laxi? ");
INSERT INTO udi_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Oç̌alen sayanbaki yan, Bula alabi hayzes teyan bakon ene. ");
INSERT INTO udi_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Hayza, kul biq'a yax! Vi nu badalbakala çuresuna ak'est'i yax çark'est'a! ");
INSERT INTO udi_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Fark'alxoy dəst'in kalat'aynak'. Goraxi ğarmoğoy \"Gěše vard k'inək' gözəl bakala irəziluğ\" uk'ala faren mə̌ğěğala Ǐvel mə̌ğ. Lašk'oyi mə̌ğ Bez ük' şaat' əyitmoğon buye, Padçağeynak'ez mə̌ğě! Bez ǰomoxun c'eğala mə̌ğ Başarağlu şairi q'ələməxun c'eğala şeir k'inək'e! ");
INSERT INTO udi_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Vi loxol běğat'an amdari ük'e qayesa, ay padçağ, Vi ǰomoxun uč'e barst'a, Buxačuğoy xeyir-bərəkət həmişəluğ içuxun bakalonu hun! ");
INSERT INTO udi_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Ext'a vi q'ılınca, vi bı̌yex ğaç̌p'a, ay q'oççağ! Vi zora, vi kalaluğa ak'est'a! ");
INSERT INTO udi_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Vi ěken taśi davoğo taşa, barta vi kala s'i t'ap'eśeq'an! Fağırxoy tərəf baki düzgünluği q'a düzgün divanbsuni k'ə baksuna ak'est'a, Şot'o görə ki, Vi kiyexun nu ayeğala əş tene bu! ");
INSERT INTO udi_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Barta vi şiş oxurxo taśi düşməni ük'eq'an t'ə̌q'eśi, Barta azuk'xo vi turin oq'aq'at'un biti. ");
INSERT INTO udi_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Buxačuğon va tadi taxt' İz taxt'allarik' həmişəluğe, Düzgünluğen efale vi padçağluğa. ");
INSERT INTO udi_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Hun düzgünluğan c'ək'p'i, pisluğa isə nifrətenbi. Kot'aynak'al, Buxačuğon, vi bakala Buxačuğon, Va kala mǔqluğen c'ək'p'i T'iyə̌mint'oğoxun bitot'oğoxun üst'üne bi. ");
INSERT INTO udi_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Vi paltaraxun mirrinen, aloyen saal k'assinen tadala şaat' adurxone adesa, File ǔq'enen bəzəyinşəki sarayxoy boşe mǔqst'a va Arfinaxun c'eğala səsen. ");
INSERT INTO udi_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Padçağxoy xuyərmuxe bu vi çuux baksuni hörmətə layiğ bakalt'oğoy arane, Vi yön tərəf çuux-padçağ bakseynak' c'ək'eśiyone arśe, Ən şaat' q'ızılxo laxine arśe vi t'ǒğǒl. ");
INSERT INTO udi_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","İbaka, ay xuyər, uk'alt'oğo yönbəri ǔmǔxlaxa! Vi azuk'a, vi bavay k'oja ene eyexun c'evk'a, ");
INSERT INTO udi_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Padçaği əyiten taki, şone vi q'ončux! Barta vi gözəlluğa ak'i va samalal geleq'an çureśi. ");
INSERT INTO udi_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Sur oç̌alaxun bakalt'oğon vaynak' payurxo eçalt'un, Azuk'xoy ən dövlətluyorox vi piyes şaat' ak'esun çureğalt'un. ");
INSERT INTO udi_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Mone, padçaği xuyər tamtarağen, İz loxol q'ızılen bəzəyinşəki paltaren sarayane baysa! ");
INSERT INTO udi_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Gözəl naxışxo laxeśi paltarin boşe eysa şo padçaği t'ǒğǒl, İçu köməybala xuyərmuxal iz bač'anexunt'un baysa! ");
INSERT INTO udi_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Axšumen, qay ük'ent'un tur ç̌axe Padçaği saraya şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Vi bavoğoxun mandi taxt'a vi ğarmux arśale, ay padçağ! Me oç̌ala kalaluğbal laxalnu hun şot'oğo. ");
INSERT INTO udi_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Vi s'i vaxun oşa eğala nəsilxoy ǰomoxunal tene bital, Millətxon me mə̌ğə̌ mə̌ğpi vi s'iya alabalt'un həmişə! ");
INSERT INTO udi_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Fark'alxoy dəst'in kalat'aynak'. Goraxi ğarmoğoy Alamot'en mə̌ğěğala Ǐvel mə̌ğ. Beş bač'an, yax zor tadalone Buxačux, T'ar ğine beş kiyexun biq'alone Şo. ");
INSERT INTO udi_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Mot'o görəl q'ı̌teyanbsa yan! Oç̌al ǰı̌k'eğayin, Buruxmux śareśi dənizi tume barayin, ");
INSERT INTO udi_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Xeyur ěqeśi buruxmoğo iz ganuxunal galdayin, Yaynak' q'ı̌ butene! ");
INSERT INTO udi_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Tağala oqure c'ovaksa Buxačuğoy şəhərexun, Mǔqluğe eşt'a Ala Arśit'ay məsk'ən saki ganu. ");
INSERT INTO udi_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Buxačuğon İçeynak' k'oj bi şəhər tene galk'on iz ganuxun, İşiğ bitat'an şot'ay loxole İz pul! ");
INSERT INTO udi_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Millətxone vəlvəlinə badon, Padçağluğxone çökt'est'on, Dünyəni səsəne bot'on Buxačuğoxun c'eğala səsen! ");
INSERT INTO udi_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Q'oşuniQ'ončux yaxune, İak'ovi Buxačux beş bač'ane. ");
INSERT INTO udi_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ekinan, Q'ončuğoy bi əşurxo běğanan, Oç̌ali ç̌oyexun əfçibit'oğo ak'anan. ");
INSERT INTO udi_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Dünyəni sa belxun baśi t'e belxune c'eri: Davoğone efi Şot'in, Xişt'ik'xo q'a oxurxone xoxp'i śipi, Davin araboğone bəc'ük't'i. ");
INSERT INTO udi_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","\"Bəsp'anan, Zuzu Buxačux! Bez s'i t'ap'eğale azuk'xoy boş, Zuzu me dünyəni kalo\" nexe. ");
INSERT INTO udi_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Q'oşuniQ'ončux yaxune! İak'ovi Buxačux beş bač'ane! ");
INSERT INTO udi_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Fark'alxoy dəst'in kalat'aynak'. Goraxi ğarmoğoy Ǐvel mə̌ğ. Ay bütüm azuk'xo, çəpibanan, Mǔq səsen Buxačuğo alxışp'anan! ");
INSERT INTO udi_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Şot'aynak' ki, şuk'k'alen Şot'ay sa əyitə p'ə̌ bes nu bakalone Q'ončux,Ala Arśiyone, Dirist' dünyəni kala Padçağe Şo. ");
INSERT INTO udi_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Azuk'xone beş běš eçeri bač'an k'os'best'i Şot'in, Millətxone beş turin oq'a saki. ");
INSERT INTO udi_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","İz çureğala İak'ovi piin işiğ bakala oç̌ala İçine c'ək'p'i, Şot'o yax tadi həmişəluğ beşine bi. ");
INSERT INTO udi_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Mone, mǔq səsure c'eysa Buxačux ěqeğat'an, Şeyp'urt'un fare Q'ončux İz ganuxun galk'at'an. ");
INSERT INTO udi_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Mə̌ğpanan! Buxačuğo tərifləyinşala mə̌ğur mə̌ğpanan! Mə̌ğpanan! Beşi Padçağa tərifləyinşala mə̌ğur mə̌ğpanan! ");
INSERT INTO udi_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Şot'aynak' ki, dirist' dünyəni padçağe Buxačux, Mə̌ğurxoy ən şaat't'u mə̌ğpanan Şot'aynak'! ");
INSERT INTO udi_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Bito azuk'xoy padçağ bakalone Buxačux, İz ı̌vel taxt'a arśiyone Şo! ");
INSERT INTO udi_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Bito azuk'xoy kaloroxe giresa Avrahami Buxačuğoy bel, Şot'ay kiyelt'un me dünyəni kalaluğbalxo, Bitot'uxun üst'üne Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Goraxi ğarmoğoy Ǐvel mə̌ğ. Q'ončux kalane. Şot'ay s'iya duği mə̌ğurt'un mə̌ğě Buxačuğoy şəhəre, Şot'ay s'iyat'un alabsa İz ı̌vel buruğo. ");
INSERT INTO udi_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","İz alloyluğen içu gözəlluğ tadala Sion buruğo, Dirist' dünyəneynak' mǔqluğ eçala, Śafon burux k'inək' gözəl, kala Padçaği məsk'ən bakala t'e şəhəre! ");
INSERT INTO udi_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Q'alane Buxačux t'e şəhəreynak', Sa q'orişal k'inək't'un aksa Şot'o t'e ganu ı̌ša bitalt'oğon. ");
INSERT INTO udi_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Mone, padçağxon içoğoy q'oşunxot'un girbi, Şot'ay loxol tayseynak't'un c'eri şorox. ");
INSERT INTO udi_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Ama hari ak'at'an vəlvəlinət'un baft'i, İçoğo q'ı̌yen haq'i qoşt'un qaybaki. ");
INSERT INTO udi_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Əyel eçala çuğon zap'k'ala koruğat'un zapi, Pulan haq'i Hun şot'oğoy. ");
INSERT INTO udi_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Běğ c'eğala tərəfəxun eğala muşen iz běš c'eğala kala gəminə śarpi śik'ala k'inək', Hunal şot'oğon oç̌alen sa bi. ");
INSERT INTO udi_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Beşi ibakit'oğoy düz baksuna beş piinyan ak'i: Beşi Buxačuğoy şəhəri, Bitova Başarbala Q'ončuğoy şəhəri binorina Buxačuğon həmişəluğe laxe. ");
INSERT INTO udi_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Vi nu badalbakala çuresunayan aksa Vi xrama bağat'an, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Dünyəni t'e bele t'ap'esa Vi s'i, J̌omo muz bakalt'in Vi kalaluğaxune əyite, Düzgün divanbsunast'ane Vi zor, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Sion buruxe mǔqbaksa, İudeyina bakalt'oğoy ük'e qayesa Vi düzgünluğa ak'i! ");
INSERT INTO udi_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Sioni hərrəmine fırıpi şot'o běğanan, Şot'ay q'aloğo bǒq'ə̌lpanan, ");
INSERT INTO udi_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","İz bariğoy ost'aarluğa, Düşməni ı̌ša nu bites bakala me ganu fikir tadi ef eyex efanan. Eyex efanan ki, və̌xun oşa eğala nəsileynak' exlətp'es bakanan. ");
INSERT INTO udi_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Axıri me Buxačux yaynak' həmişəluğ bakala Buxačuxe. Axıral śirik' yaxun baki Yax yaq' ak'est'alone! ");
INSERT INTO udi_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Fark'alxoy dəst'in kalat'aynak'. Goraxi ğarmoğoy Ǐvel mə̌ğ. Ǔmǔxlaxanan bez uk'alt'oğo, ay bito azuk'xo, İbakanan, ay me dünyəne yəşəyinşalorox! ");
INSERT INTO udi_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","S'ila bakalt'inal, nu bakalt'inal, Kəsibenal, varlunenal iz ǔmǔxxo qaypeq'an! ");
INSERT INTO udi_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Müdrik əyitmux uk'oz və̌x, Bez ük'exun mani fikirxoy c'ovaksuna və̌x p'ap'esp'oz. ");
INSERT INTO udi_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Məsəloğo ǔmǔxlaxi şot'oğoy k'ə upsuna q'amişakoz, Oşal me müdrikluğa eçeri faren ef mə̌xinə laxoz. ");
INSERT INTO udi_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","T'ar ğinaxun, Bez hərrəmine bakala pisluğen buy əfçiduğalxoxun het'aynak' q'ı̌boz? ");
INSERT INTO udi_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","İçoğoy var-dövlətə güvəyinşakalt'oğoy, Girbit'oğo bitot'ay piye badi fərəxləyinşakalt'oğoy het'uxun zap'eğoz? ");
INSERT INTO udi_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Elmoğo toyen haq'ala şey tene, Buxačuğoxun təngə tadi ext'es bakala şey tene elmux. ");
INSERT INTO udi_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Şot'o görə ki, tene bu şot'ay toy, İnsani kiyexun ayeğala şey tene mo. ");
INSERT INTO udi_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Şuva həmişəluğ me dünyəne yəşəyinşalo? Bito p'uri oç̌ali oq'ane taysa! ");
INSERT INTO udi_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Bitot'in aneksa: nə müdrik bakalt'ine me dünyəni t'ǒğə biq'i çurpes bake, Nəəl axmağen q'a q'ammazen. Bito p'uri tanesa, içoğoy girbiyoroxal q'ert'une manst'a. ");
INSERT INTO udi_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","İçoğoy pul boteneşt'a, Oç̌alxot'un exst'a ki, içoğoxun oşa eğala nəsileynak' efalt'un. Ama mone, gərəmzoğo bakala sa p'at'ar oç̌ale içoğo mandalo! ");
INSERT INTO udi_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Hetər s'iye q'ončux bakalnu baka, T'e çöle tarak'ala heyvanaxun sa fərg tene bu insani! Bitot'ay axır bisune! ");
INSERT INTO udi_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Mone içu güvəyinşakalt'oğoy q'a şot'oğollarik' bakalt'oğoy me dünyəne tağala yaq'e axır! Ama maya? Pula q'ic'p'i tağamin mot'o tet'un q'amişaksa! ");
INSERT INTO udi_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Sürünen iz bula k'os'bi tağala k'inək' tağalt'un şorox t'e dünyəne, Bisun iç şot'oğoynak' yaq' ak'est'ala çoban bakale! P'uri oç̌alin oq'a tağalt'un, bašaybaki əfçibakalt'un t'iya! Pula qayk'at'an isə düzgünt'oğoy döör eğale. ");
INSERT INTO udi_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Zaal p'uri oç̌alin oq'a taysa tene bark'al Buxačuğon. İz t'ǒğǒl ext'ale za Şot'in! ");
INSERT INTO udi_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Dövlətlut'ay hik'k'ala tamaxmaba, S'iye q'ončux bakalt'oğoy hörməti avuzbaksuna ak'i paxılluğmaba. ");
INSERT INTO udi_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Şot'o görə ki, hələ şuk'k'alen içuxun hik'k'al taşeri tene me dünyənexun, Nəəl s'iya biq'i çurk'ala şey tene. ");
INSERT INTO udi_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","İz pul qay vədine bəxt'əvəre hesabbsa içu, Axıri amdari əşurxo şaat' tağat'an bitot'aynak' piin işiğe! ");
INSERT INTO udi_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Ama tene ava ki, bito p'uri tağamine, Pula q'ic'p'i t'e dünyəne, iz bavoğoy t'ǒğǒl tağamin! ");
INSERT INTO udi_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Hetər s'iye q'ončux bakalnu baka, Müdrikluğ nu bakala insani çöle tarak'ala heyvanaxun sa fərg tene bu! Bitot'ay axır bisune! ");
INSERT INTO udi_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asafi Ǐvel mə̌ğ. Mone, Bitova Başarbala Buxačuğon, Q'ončuğon İz əyitə upseynak' azuk'xone k'ale, Dünyəni sa belxun t'e soğo bel śirik' k'ə azuk' bunesa k'alpi girebsa. ");
INSERT INTO udi_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Sionaxune Şot'in yaynak' İz işiğ sakala kalaluğa ak'est'a, İzi gözəlluğaxun ene şuk'k'alast'a nu bakala Sionaxun! ");
INSERT INTO udi_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Enesa beş Buxačux, ama şip' çurpseynak' tene eysa! Bok'osp'i śik'ala arux k'inək', Ěqeśi tufan k'inək'e eysa! ");
INSERT INTO udi_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Göyurxo q'a oç̌ala k'alpi Şot'oğoy běš İz azuk'ane divanbsa Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","\"Girbanan Bez yaq'en tağalt'oğo bitova, Q'urban šampi Zaxun irəziluğ ğaç̌eśit'oğo Bez t'ǒğǒl eçanan\" nexe. ");
INSERT INTO udi_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Mone, göyurxonal at'unksa Buxačuğoy divanbsuni k'ə baksuna, Şot'ay düzgünluğat'un car saksa şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","\"İbaka, ay Bez azuk', Zuz əyite! Mone, vi taxsırkər baksuna ç̌oyel c'evk'alo bakoz, ay israilluyox, Şot'o görə ki, Buxačuxzu, vi Buxačux Zuzu. ");
INSERT INTO udi_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ef taxsırxo q'urban eşt'unxost'a tez ak'al, Bok'ospsuni q'urbanxon Za irəzibsaxun tez əyite həysə Zu. ");
INSERT INTO udi_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Ef ağılxo bakala öküzxoxun, Sürünə bakala keçiğoxun tez əyite. ");
INSERT INTO udi_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Axıri c'ələye bakala bito heyvanxo, Hazarxon buruxmoğo bakala sürüyox İzi Bakalt'aynak' mo hik'k'ale! ");
INSERT INTO udi_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Buruxmoğo bakala bito q'uşurxoz soğo-soğo çalxsa, Çöle bakala heyvanxoy bitone Bez kiin oq'a. ");
INSERT INTO udi_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Zu busa bakayiz va pi k'ə booz? Dünyəl, dünyəne bakaloroxal Bezi baksunen va het'u görə uk'az? ");
INSERT INTO udi_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Zu nə öküzi yeq' ukalo tezu, Nəəl keçin p'i ǔğə̌lo.\" ");
INSERT INTO udi_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Buxačuğo şükürbsun bakale vi Şot'aynak' eçala q'urban, Vi niyətp'i tadi əyiti loxol çurpsuna ak'est'a Ala Arśit'u! ");
INSERT INTO udi_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","\"Vi t'ar ğine Za k'alpa, Zuval va çark'est'oz, Metər, Bez s'iya alabalo bakalnu hun.\" ");
INSERT INTO udi_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Buxačuğon pist'oğo metər uk'ale: \"Hun mani ç̌oyenen Bez k'anunxoxun əyitp'es baksa? Bezi azuk'axun ğaç̌eśi irəziluğa hetəren vi muzel eçes baksa? ");
INSERT INTO udi_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Bezi tadi nəsyətxo nifrətenbsa hun, Bezi piyorox vi sa ǔmǔğoxun baśi t'e soğo ǔmǔğoxun c'enesa. ");
INSERT INTO udi_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Sa oğri ak'ala bakayin gərenbaksa şot'o, Yaq'nuxun c'erit'oğoxun dost'luğenbsa. ");
INSERT INTO udi_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Vi ǰomoxun şəre barst'a, Muzexun əfçi əyitmuxe c'eysa. ");
INSERT INTO udi_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Vi viçey ç̌oyelen çure əfçidən hun, Sa nanay tapanexun c'eri doğma viçey loxol şəren bost'a! ");
INSERT INTO udi_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Hun me əşurxo biq'at'an Bezi şip' çurpsunaxun t'etəren q'amişaki ki, Zuval vallarik'zu. Ama təə! Mone, vi hetər baksuna ç̌oyel c'evk'oz, Vi taxsırxo bitova c'epi śik'oz! ");
INSERT INTO udi_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Mone, bito me pit'oğo ef eyex efanan, ay Buxačuğo eyexun c'evk'iyorox! Tene, və̌x k'ot'or-k'ot'or booz, Şuk'k'alen və̌x bez kiyexun haq'esal tene bakal. ");
INSERT INTO udi_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Buxačuğo şükürbsune efi Za çalxsuna ak'est'ala q'urban, Düz yaq'en tağalt'in Zaxun eğala çark'esuna ak'ale!\" ");
INSERT INTO udi_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Mə̌ğk'alxoy kalat'aynak'. Davidi Ǐvel mə̌ğ. Davidi günax əşp'est'i Bat'-Şevaxun ı̌šaluğbit'uxun oşa xavareçal Nat'ani iz t'ǒğǒl eğat'an śampi mə̌ğ. Vi nu badalbakala çuresuna ak'est'i za bağışlayinşa, ay Buxačux! Vi ük' bok'ospsuna zaxun kammaba, bez günaxxo silba! ");
INSERT INTO udi_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Bito bez taxsırxo os'k'a taşa, Za bezi günaxaxun təmizba. ");
INSERT INTO udi_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Vi əyitəxun c'eysuna avazu, Əşp'est'i günaxi bı̌hiluğal q'amişzu. ");
INSERT INTO udi_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Vi běšzu günaxkər, Vi k'anunxoxun c'eriz günax əşp'est'i, Vi piyes pis ak'eğala əşez biq'i zu. Şot'o görəl haq' galan divanbsa, Düzgün q'ərar c'evk'alonu Hun! ");
INSERT INTO udi_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Axıri zu nanaxun bakat'an ene günaxkərzuy, Hələ nanay tapane bakat'an bez günax zaxuney. ");
INSERT INTO udi_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ama Hun düzgünluğen qə̌věsa amdarast'a, Me müdrikluğaxun bez ük'eyal laxa Hun. ");
INSERT INTO udi_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Za issop'en təmizba, barta bez günaxxoxun təmiz bakaz, Za os'k'a, lap ǐǰaxunal mas'i bakaz. ");
INSERT INTO udi_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Za mǔqt'a, bez ç̌oya axšumda, Barta Vi xə̌xə̌pi ük' qayeśeq'an. ");
INSERT INTO udi_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Bez günaxxo bağışlayinşa, Bito bez taxsırxo os'k'a taşa. ");
INSERT INTO udi_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ay Buxačux, za təmiz ük' tada, Za təzələyinşa, barta Vi yaq'en tağaz. ");
INSERT INTO udi_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Za Vaxun ə̌xilmaba, Vi tadi Ǐvel Urufa zaxun ma ext'a. ");
INSERT INTO udi_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Vaxun eğala çark'esuni mǔqluğa za qayda, Za Vi əyiten tağala ba. ");
INSERT INTO udi_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","T'e vədə Vi əyitəxun c'eğalt'oğo Vi yaq'en taysuna zomboz, Günaxkərxoval Vaç qaybakalt'un. ");
INSERT INTO udi_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Ay Buxačux, ay za çark'est'es bakala Buxačux, Bez kiyel bakala p'iya os'k'a, Barta bez muzen Vi düzgünluğaxunq'an əyitp'i. ");
INSERT INTO udi_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Bez muza qaypa, ay Q'ončux, Barta bez ǰomoxun Vaynak' tərifq'an bari. ");
INSERT INTO udi_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Vi zaxun çureğalo q'urban eşt'un bakiyniy, ezçoy, Ama bok'ospsuni q'urbanen irəzibala şey tene Va! ");
INSERT INTO udi_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Va çalxsun, Vi çureğalt'oğo bsun - mone əsil q'urban! Mot'o q'amişaki q'abulbalt'u Hun Vaxun ə̌xiltenbon, ay Buxačux. ");
INSERT INTO udi_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Vi ük' bok'ospsuna ak'est'i Sioneynak' şaat'luğ ba, Yerusalimi hərrəmine bakala q'alina təzədən biq'a. ");
INSERT INTO udi_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","T'e vədə bütüm me eçala q'urbanxon Va irəzibale, Dirist' bok'ospseynak' šameğala q'urbanxo Vi piyes şaat' ak'eğale, T'e vədə Vi q'urban eçala gala arak'xoval eçalt'un. ");
INSERT INTO udi_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Fark'alxoy kalat'aynak'. Davidi ögüd-nəsyət tadala Ǐvel mə̌ğ. Edomlu Doegen taśi Şaula \"David Aximelek'i k'oyane\" pi xavar tadit'uxun oşa śameśi Ǐvel mə̌ğ. Va zorba hesabbi pisluğbsunaxunen fərəxləyinşaksa, ay q'oççağ? Buxačuğoy nu badalbakala çuresun həmişə zaxune! ");
INSERT INTO udi_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Əfçibaksune eşt'a amdarxoynak' vi muzen, Bic'luğ əşp'est'i ğayin me k'inək' k'as'p'i śinne. ");
INSERT INTO udi_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Şaat'a barti pisən c'ək'e, Düz əyiti təə, əfçin q'ončuxnu. ");
INSERT INTO udi_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Bisun eçala əyitmuxe c'eysa vi ǰomoxun, Əfçiduğalnu hun! ");
INSERT INTO udi_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Ama Buxačuğon va t'etər sakale ki, vi bula alabes ten bakal hun. Va vi k'ojaxun bale, Vi tuma əfçibale me dünyənexun Şot'in. ");
INSERT INTO udi_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Düzgünt'oğonal mot'o ak'i Buxačuğoy kalaluği běš bul k'os'balt'un, Vi loxol isə axšumpi metər uk'alt'un: ");
INSERT INTO udi_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","«Buxačuğo bač'an tarast'uni gala iz var-dövlətə umudbakalt'ay, T'iyə̌mint'oğo əfçibi q'azayinşit'oğoy axır metəre baksa!» ");
INSERT INTO udi_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Zu isə Buxačuğo ı̌šazu, Veçələyinşala sa zeytuni xod k'inək'zu Şot'ay bakala gala. Şot'ay nu badalbakala çuresunaz umudbaksa zu həmişə. ");
INSERT INTO udi_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Va věbakalt'oğoy běš Vi bit'oğo bez muzel eçeri Va həmişə şükürboz, Va umud bakoz, şot'o görə ki, Hun şaat' bakalonu! ");
INSERT INTO udi_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Fark'alxoy dəst'in kalat'aynak'. \"Maxalat'\" uk'ala faren mə̌ğěğala Davidi ögüd-nəsyət tadala Ǐvel mə̌ğ. Axmağxon içoğoy ük'e boş \"Buxačux butene\" next'un. Düz yaq'axun c'eret'un, pis əşurxoy qoşt'ant'un taysa şorox; Şaat' əş biq'al butene. ");
INSERT INTO udi_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Buxačuğonal göynuxun amdarxoy loxole běğsa, Běneğsa běyn şot'oğoy boş müdrik baki İçu qə̌věğalo bune? ");
INSERT INTO udi_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Bitot'in Buxačuğoxun ç̌oya taradene, Sa tanal bakayin şaat' əş biq'al tene mande. ");
INSERT INTO udi_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Hevaxt' haq'ullayinşakalt'un me pis əş biq'alxo? Bezi azuk'a saki ukalxo, İçoğoy t'arnu p'ap'alo Buxačux baksuna nu q'amişakalxo? ");
INSERT INTO udi_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Ama mone, q'ı̌yen haq'ene şot'oğo, İçoğoy pula haq'ala sa q'ı̌yen! Buxačuğon izt'oğoy loxol ěqeśit'oğoy ǔq'enxone xoxp'i, Biyaburebi şot'oğo, Şot'o görə ki, taradene şot'oğoxun İz ç̌oya! ");
INSERT INTO udi_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Ay İsraileynak' Sionaxun eğala çark'esun, mayanu?! Eki qayda Buxačuğoy azuk'eynak' t'e bəxt'əvər ğimxo! Barta İak'ovi nəsilen mǔqluğq'an c'ovakest'i, Barta israilluğoy ç̌oyen axšumpeq'an! ");
INSERT INTO udi_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Fark'alxoy dəst'in kalat'aynak'. Simlə ət't'əcxoy faren mə̌ğěğala Davidi ögüd-nəsyət tadala Ǐvel mə̌ğ. Zifluğon hari Şaula \"David beşi şəhərene c'ap'baksa\" pit'uxun oşa śameśi Ǐvel mə̌ğ. Ay Buxačux, Vi şu baksuna ak'est'i za çark'est'a, Bezi taxsırsuz baksuna Vi kiin c'evk'a ç̌oyel! ");
INSERT INTO udi_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Bezi afırına ibaka, Bezi Va k'alpsuna coğabsuz ma efa, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Mone, buxačuxsuzorox bez loxolt'un ěqesa, Bespsunt'un çuresa za me zalımxon! Buxačuğo nu çalxaloroxe şorox! ");
INSERT INTO udi_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Ama avazu, Buxačuğon za tək tene bare, Zaynak' bač'an bakalone Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Bez düşmənxoy pis əməlxo qaydi içoğoy bel śik'ale Şot'in, İz tadi əyiti loxol çurpi əfçibale şot'oğo! ");
INSERT INTO udi_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Bez ük'exun Vaynak' q'urban eşt'un c'ovakale, ay Q'ončux! Vi s'iya, Vi t'e gözəl s'iya alaboz zu! ");
INSERT INTO udi_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Bez bel eğala bəloğoxunen çark'est'i za Hun, Bez düşmənxoy biti ç̌axç̌uxesunan ak'est'i za! ");
INSERT INTO udi_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Fark'alxoy dəst'in kalat'aynak'. Simlə ət't'əcxoy faren mə̌ğěğala Davidi ögüd-nəsyət tadala Ǐvel mə̌ğ. Ay Buxačux, bez afırına ibaka, Bez xoyinša nu ibaksuna ma laxa, ");
INSERT INTO udi_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Bezi Va k'alpsuna coğab tada! Fikiren haq'ene za, q'ic'eśi manest'a zu ");
INSERT INTO udi_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Bez düşmənxoy səsə ibakat'an, Zalımxon za koruğ tadat'an! Bələt'un baki şorox zaynak', Əcuğləyinşəki bez loxolt'un ěqesa! ");
INSERT INTO udi_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Bez ük' c'ap'ebaksa, Bisuni q'ı̌yene haq'e za. ");
INSERT INTO udi_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Bula biq'i t'it'ala vəlvəlinaz baft'e, T'ut'ultinene haq'e za. ");
INSERT INTO udi_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Həysə t'etərzu ki, nexzu göyərçin baki purpi tağaz, Sa şip' ga bə̌ğə̌bi irəət nəfəs haq'az! ");
INSERT INTO udi_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Çara bakayin bez bula haq'i ə̌xil sa ams'i oç̌alaz tağon, T'iyaz yəşəyinşon! ");
INSERT INTO udi_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Nexzu amdari sa c'ap'bakala ga bakane, Muşe q'a tufani ı̌šalayinşaksuna ak'ala k'inək' t'it'eri c'ap'bakes bakane! ");
INSERT INTO udi_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Gərgürçiluğ saka me pist'oğoy arane, ay Q'ončux, Barta suna maq'at'un q'amişaki! T'iyə̌mint'ay loxol kul alabsunaxun q'a davabsunaxun başq'a sa şey tez aksa me şəhəre zu! ");
INSERT INTO udi_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Üşe-ğena amdari pulat'un c'eye şot'oğon, Şəhərə q'orişala barine bake pisluğ q'a şər. ");
INSERT INTO udi_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","K'as'esuni, əfçin q'a fırıldağin mese bake me şəhəri küçəmux! ");
INSERT INTO udi_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Düşməni pis əyitə porttezbsa, Za nu çureğalt'ay bez loxol alaxun oq'a běğsunal q'uc'ezne zu, ");
INSERT INTO udi_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ama hari va p'ap'at'an tez baksa! Axıri hun bezi ı̌šonu, Bezi dost'nu, zaynak' viçi k'inək' bakalonu! ");
INSERT INTO udi_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Beş ük'əyan ams'ipsay yan sunay t'ǒğǒl, Sagala xramayan taysay camaati boş! ");
INSERT INTO udi_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Barta bez düşmənxoynak' bisunq'an hari, Barta şorox dirist'-dirist' gərəmzəluğq'at'un baki! İçoğoy ük' şəren, K'ojurxo pisluğen buy bakaloroxe şorox! ");
INSERT INTO udi_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Zu isə Buxačuğo k'alk'oz, Q'ončuğonal za çark'est'ale. ");
INSERT INTO udi_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Savaxt'an, berezəre, biyəsin - Üşe-ğena çökt'i, ǒnek'a xoyinšezbsa zu, İbakale za Şot'in! ");
INSERT INTO udi_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Bez loxol ěqeśi sa sürü düşmənəxun davina c'eğat'an Bez belxun sa pop bist'al tene bark'al Şot'in! ");
INSERT INTO udi_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","İz padçağluğ həmişəluğ bakala Buxačuğon, T'e padçağluği nə burqesun, nə çarksun nu bakala Buxačuğon za ibakale! İbakiyal şot'oğoy səsə bot'ale, Şot'o görə ki, şorox badalbakalorox tene, Buxačuğoxun q'ı̌bsun tene bu şot'oğost'a! ");
INSERT INTO udi_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","İçeynak' viçi k'inək' bakalt'ay loxole alabi bez dost'en iz kula, Beşi \"sunay bač'ane çurk'alyan\" pi tadi əyiti loxol tene çurpi şo. ");
INSERT INTO udi_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Ç̌oye axšumene, ama iz ük' şəren buye. Muč'a-muč'ane əyite, ama izi hər əyit amdarane lafst'a. ");
INSERT INTO udi_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Vi ə̌mnəbel bakala yükə Q'ončuğo tapşurba hun, Şoval İç vi q'ayğina mandi vaynak' bač'an bakale. Şot'in tene bark'on ki, düzgün bakalt'ay tur lamandane! ");
INSERT INTO udi_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Pist'oğoy axır butene, ay Buxačux, Gərəmzəluğ balnu Hun şot'oğo! P'i śik'alxon q'a əfçiduğalxon içoğoy ömüri qǐt'u tet'un yəşəyinşal sal! Ama bez umudi ga Hunnu! ");
INSERT INTO udi_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Fark'alxoy dəst'in kalat'aynak'. \"Ə̌xil mə̌xluğa bakala göyərçin\" uk'ala faren mə̌ğěğala Davidi mikt'am. Filist'luğon Davida Gat' şəhəre biq'at'ane śameśe. Ay Buxačux, za gorox eki! Bez bač'anexun baft'iyorox hari za p'ap'saxt'un, Üşe-ğena bez loxolt'un eysa, za saki ç̌axç̌uxpsunt'un çuresa. ");
INSERT INTO udi_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Bezi hər ğina mə̌yint'unbsa şot'oğon, Za nu çureğalorox t'eq'ədəre ki, Bǒq'ə̌lpi çark'ala şey tene, ay ala arśi Buxačux. ");
INSERT INTO udi_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Za q'ı̌yen haq'ala vədine Saycə Vaz umudbaksa zu. ");
INSERT INTO udi_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Za tadi əyitə görə Va alxışp'i Vaz bač'an tarast'a zu. Umudi ganu Vast'a ak'i hik'k'alaxun tez q'ı̌bsa! Axıri Hun bakala gala insanen za k'ə bese bakon? ");
INSERT INTO udi_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Üşe-ğena bez turin oq'axunt'un kaše bez düşmənxon, Bezi əyitmoğo fırıdi za pisluğbsune içoğoy niyət. ");
INSERT INTO udi_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","C'əp'k'in gireśi əyitə sat'unbsa, Za busmişi bespsunt'un çuresa! ");
INSERT INTO udi_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Şot'oğoy me günaxa cazasuz ma efa, Vi əcuğoy bəc'ük'esuni k'ə baksuna ak'est'a, ay Buxačux. Me azuk'xo Vi turin oq'a laxi ç̌axç̌uxp'a! ");
INSERT INTO udi_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Bez dərdurxoy bitovan soğo-soğo ava Hun, Bez piyexun bari hər k'at' neğan bǒq'ə̌lpi. Vi girke boşen śampi Hun şot'oğoy bitova! ");
INSERT INTO udi_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Mone, Vaz köməyə k'ale zu, Bez düşmənxonal q'ı̌bi qoşt'un qaybaksa. Buxačuğoy zaxun baksuna metərez avabaksa zu! ");
INSERT INTO udi_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","İz tadi əyiti loxol çurk'ala Q'ončuğoz tərifləyinşbsa zu, İz tadi əyiti loxol çurk'ala Buxačuğoz tərifləyinşbsa zu, ");
INSERT INTO udi_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Umudi ganu Buxačuğost'a ak'i hik'k'alaxun tez q'ı̌bsa! Axıri insanen za k'ə bese bakon? ");
INSERT INTO udi_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Ay Buxačux, Va tadi əyiti loxol çurk'oz zu, Q'urbanxo eçeri Va şükürbsuna ak'est'oz. ");
INSERT INTO udi_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Axıri Hun bez elmoğon çark'est'i, Bez tur ǰěna lafst'a ten barti. Za Buxačuğon işiğ sakala me dünyəne yəşəyinşbsunen q'ısmatbi. ");
INSERT INTO udi_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Fark'alxoy dəst'in kalat'aynak'. \"Za efa\" uk'ala faren mə̌ğěğala mikt'am. Daviden Şauli kiyexun t'it'eri mağarina c'ap'bakat'an śampi mə̌ğ. Gorox eki za, ay bez Buxačux, za gorox eki, Vaz bač'an tarast'a, Vane bez umud! Me bələ bez belxun tağamin Vi q'ənədi oq'az zaynak' gabsa. ");
INSERT INTO udi_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ala Arśit'uz k'ale zu, Bez taxsırsuz baksuna ç̌oyel c'evk'ala Buxačuğoz k'ale! ");
INSERT INTO udi_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Şot'inal za kul biq'ale göynuxun, za çark'est'ale, Bez bač'anexun baft'it'oğo biyaburbale. İz nu badalbakala çuresuna kamtenebal zaxun Buxačuğon, Za qı̌ yaq'a tene efal Şot'in! ");
INSERT INTO udi_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Şirurxoy arane, Busabaki canavarxoy boş baft'i k'inək'zu həysə zu! Şiş xişt'ik'xo, t'ə̌q'ěğala oxur k'inək'e uluxxo şot'oğoy, Ğayin me k'inək'e bost'a muzen şot'oğoy. ");
INSERT INTO udi_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Barta Vi kalaluğ ala bakala göynuxunal c'ovaki ak'eśeq'an, Barta dirist' oç̌ali ç̌oyel Vi s'iq'an t'ap'eśi, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Tələt'un laxi za biq'seynak' şot'oğon, Dərdə baft'iyal çarasuzez mandi zu. Bezi yaq'e loxol kurt'un kašp'i, Ama içant'un t'iya baft'i. ");
INSERT INTO udi_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Vaxun arxayinzu, ay Buxačux, t'ema arxayinzu ki! Ǐvel mə̌ğur mə̌ğpi Vi s'iya alaboz zu! ");
INSERT INTO udi_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Mone, həzirzu, bez boş bakalt'oğo upseynak' mə̌ğk'oz! Běğ çərtk'amin hayzoz, Arfa q'a tər farpi mə̌ğk'oz zu! ");
INSERT INTO udi_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Ay Q'ončux, bito azuk'xo Va çalxest'i Vi s'iya alaboz, Bito millətxoy boş Va tərifləyinşoz! ");
INSERT INTO udi_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Şot'o görə ki, Vi nu badalbakala çuresun q'a bez bač'ane çurpsun t'emane ki, Göynul p'ap'i asoyxoxunal c'ovanek'sa! ");
INSERT INTO udi_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Barta Vi kalaluğ ala bakala göynuxunal c'ovaki ak'eśeq'an, Barta dirist' oç̌ali ç̌oyel Vi s'iq'an t'ap'eśi, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi \"za efa\" uk'ala faren mə̌ğěğala mikt'am. Ay kalaluğbalxo, efi c'evk'ala q'ərarxo düzgüne ki? Bitot'ay loxol sa piin běğinan divanbsa ki və̌n? ");
INSERT INTO udi_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Təə, insaf uk'ala şey tene bu ef ük'e, Zor əşp'est'un ən çureğala əşe efi! ");
INSERT INTO udi_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Hələ nanaxun bakat'an içoğoy yaq'a aç̌esp'iyoroxe me pisorox, Mis'ik' hamaq'un əfçiduğsune şot'oğoy əş, yaq'nuxun c'eret'un şorox. ");
INSERT INTO udi_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Şot'oğoy ǰomoxun c'eğala pisluğxo Dizik'i ǰomoxun c'eğala zəhər k'inək'e. İz ǔmǔğo laft'ala səsə için nu çureğayin nu ibakala, ");
INSERT INTO udi_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Dizik'əçidal heq'ədər başarağlu baalkayin, Şot'o farpi nu əçides bakala sa gürzə dizik'i zəhər k'inək'. ");
INSERT INTO udi_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Şot'oğoy uluxxo duğa śipa içoğoy ǰomoxun, ay Buxačux! Çəninə duğa saka şot'oğoy! ");
INSERT INTO udi_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Barta şorox bari tağala xe k'inək' əfçibakeq'at'un, Barta içoğoy bosala ox hələ kamanaxun c'eğamin xoxbakeq'an! ");
INSERT INTO udi_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Barta əlbiz yavaş-yavaş xebaki tağala k'inək' xebaki taśeq'at'un, Barta nanay tapane p'uri əylen me dünyəni işiğa ene nu ak'es bakala k'inək' Şoroxal me dünyəni işiğa həsrətq'at'un baki! ");
INSERT INTO udi_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Şot'oğon içoğoy bel harit'oğo hələ tam q'amişakinut əfçibaki tağalt'un. Muşen iz běš badi fupi taşala sa göyün o k'inək', Q'ari sa kološ k'inək'! ");
INSERT INTO udi_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Me pist'oğon içoğoy cazina zapsunen düzgün bakalt'oğo mǔqt'ale, Şot'oğoy axıra ak'i içoğoy ük' çaxeśi bakale! ");
INSERT INTO udi_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Amdarxonal t'e vədə metər uk'alt'un: «Düzgün bakalt'uxun Buxačuğon İz şaat'luğa kamtenebon, Həgigiyal Buxačux bune, Me dünyənə düzgün divanbala Buxačuxe Şo!» ");
INSERT INTO udi_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi \"za efa\" uk'ala faren mə̌ğěğala mikt'am. Şaulen Davida bespsun çureśi şot'ay k'oja busmişbseynak' amdar yaq'abat'an śameśi mə̌ğ. Ay bez Buxačux, bez düşmənxoy kiyexun çark'est'a za, Bez loxol ěqeśit'oğoxun q'orişa! ");
INSERT INTO udi_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Şər əş biq'alt'oğoxun ə̌xilba za, P'i śik'alxoy kiyexun ext'a. ");
INSERT INTO udi_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Mone, bez elmoğo haq'seynak' zat'un busmişbsa, Za pisluğbseynak' gireśi əyitət'un sabsa me zalımxon. Ama bezi sal sa taxsır nəəl günax tezax bu, ay Q'ončux. ");
INSERT INTO udi_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Sal sa pis əş tez biq'e zu, Ama şorox bez loxol eyseynak't'un kape, Eki p'ap'a, ay Buxačux! Bez dərdə nu aksuna ma laxa. ");
INSERT INTO udi_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Ay Q'oşuniQ'ončux bakala Buxačux! Ay İsraili Buxačux, Hayza Vi şu baksuna ak'est'a! Va nu çalxala bito me azuk'xoy cazina tada! İçoğoy boş şəren buy bakalorox, Tadi əyiti loxol nu çurpiyoroxe şorox! ");
INSERT INTO udi_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Me pisorox hər biyəs et'unsa, Hari şəhəri hərrəminət'un biq'est'a, Xə̌ k'inək' amdari loxolt'un eysa şorox! ");
INSERT INTO udi_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Sa běğa içoğoy ǰomoxun c'eğalt'oğon Het'əre ğayin me k'inək' bost'a! Axıri t'etərt'un fikirbsa ki, içoğo ibakal butene. ");
INSERT INTO udi_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Ama Hun axšumi ga balnu şot'oğo, ay Q'ončux, Axšumpest'alnu Va nu çalxala bito azuk'xoy loxol! ");
INSERT INTO udi_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Za zor tadalo, Umudi ganu Hun bezi, ay Buxačux! Bezi bač'an, ");
INSERT INTO udi_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Vi nu badalbakala çuresuna zaxun nu kambala Buxačuxnu Hun bezi! Qayk'ale bez yaq'a Buxačuğon, Bez düşmənxoy taşevk'i bezi turin oq'a bist'una ak'est'ale za! ");
INSERT INTO udi_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Ama ma besp'a şot'oğo! Barta biti xoreśeq'at'un, Barta Vi kiin zore k'ə baksuna ak'eq'at'un, ay beş bač'an bakala Buxačux! Tene bito usum eyexun c'eri tağale bez azuk'i. ");
INSERT INTO udi_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","İçoğoy muzen içoğo günaxa bast'uni cazina zapeq'at'un barta! İçoğo bitot'uxun üst'ün hesabsun, Şuk'k'alaxun nu q'ı̌bi ǰomoxun c'eğalt'oğo nu fikir tast'un K'ə baksuna ak'eq'at'un barta! İçoğoy ǰomoxun c'eri bito əfçiğoy q'a q'arğişxoy ");
INSERT INTO udi_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Əcuğo c'evk'a şot'oğoxun! Tumexun əfçiba şot'oğo! Barta dünyəni t'e belxun me bel bitot'in avabakeq'an ki, Buxačuğoy kule bu İak'ovi nəsili loxol! ");
INSERT INTO udi_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Me pisorox hər biyəs et'unsa, Hari şəhəri hərrəminət'un biq'est'a, Xə̌ k'inək' amdari loxolt'un eysa şorox! ");
INSERT INTO udi_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Ama barta hari fırıpi taysunaxun başq'a hik'k'al bes maq'at'un baki, Barta busa mandi ulayinşeq'at'un şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Zu isə Vi zoraxun əyitk'ala mə̌ğur mə̌ğk'oz, Savaxt'inaxun hayzeri Vi nu badalbakala çuresuna bez muzel eçoz! Axıri Hun bez bač'an, Bez umudi gan bake t'ar ğine zaynak'! ");
INSERT INTO udi_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Hun za zor tadalonu, Va tərifləyinşala mə̌ğur mə̌ğk'oz zu! Bez bač'annu Hun, ay Buxačux, Vi nu badalbakala çuresuna zaxun nu kambala Buxačuxnu Hun! ");
INSERT INTO udi_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi zombseynak' bakala mikt'am. \"Geše vard k'inək' gözəl bakala irəziluğ\" uk'ala faren mə̌ğěğala Ǐvel mə̌ğ. Daviden Naharayima q'a Sovina bakala aramluğoxun davabit'uxun saal Yoaven hari \"elaxoy dərə\" uk'ala ganu p'as's'e hazar edomluna k'as'p'it'uxun oşa śameśi mə̌ğ. Vi ç̌oya tarandi Hun yaxun, ay Buxačux, Yax oç̌alen san bi, Əcuxlunu Hun beş loxol! Ama yax gorox eki, beş loxol běğa p'urum! ");
INSERT INTO udi_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Oç̌ala iz ganuxunen galdi, şot'o bı̌yexun t'ǒpěvk'ala k'inək'en bi Hun! Q'olayba şot'ay t'ǒpi ganxo, mone, hələ ǰı̌k'esa şo! ");
INSERT INTO udi_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","T'etəren mə̌yinbi ki Vi azuk'i ğina Hun İçoğoy kəyit'oğo bǒxmǒğǒxun k'at'-k'at'en eçeri! ");
INSERT INTO udi_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Ama Vi bač'anexun tağalt'oğo Vi bayraği oq'an girbi Hun, İçoğoynak' q'ı̌ nu bakala, boseğala oxurxo içoğo nu laft'es bakala gala! ");
INSERT INTO udi_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Vi çureğalt'oğoy Va k'alpsuna ibaka Hun, çark'est'a şot'oğo! Barta Vi yön kul beş loxolq'an baki, efa yax! ");
INSERT INTO udi_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Axıri Buxačuğon İz bakala ı̌vel gala metəre pey: \"Bez kiyel badi Şekem şəhəri oç̌alxo və̌x payboz, Suk'k'ot' uk'ala ganu Bez azuk'i arane cöyboz. ");
INSERT INTO udi_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gileadi q'a Menaşşeni oç̌alxoval Bezine! Efraima arśiz kalaluğbsa, İudeyinaz laxe Bez taxt'a Zu! ");
INSERT INTO udi_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moava Bez tur os'k'ala ləənez be, Edomi loxol torok'al bosala ext'iyərzax bu Bezi. Mone, filist'luğoy oç̌alaxune c'eysa Bez səs!\" ");
INSERT INTO udi_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","P'oy isə şiin taşala yax t'e q'alala şəhəri loxol? Şu güvəyinşaki tağalyan Edoma exst'a? ");
INSERT INTO udi_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Buxačuğon yaxun İz ç̌oya taradit'uxun oşa, Beş q'oşun davina c'eğat'an Şo yaxun nu bakit'uxun oşa mümkün tene mo! ");
INSERT INTO udi_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Düşmənxo beş turin oq'a laxsuna köməyba yax, ay Buxačux! Axıri Hun nu bakala gala insanen hik'k'al bes tene bakon! ");
INSERT INTO udi_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Buxačuxe yax bitot'uxun zorba balo, Şone düşmənxo beş turin oq'a saki ç̌axç̌uxp'est'alo! ");
INSERT INTO udi_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Mə̌ğk'alxoy dəst'in kalat'aynak'. Simlə ət't'əcxoy faren mə̌ğěğala Davidi Ǐvel mə̌ğ. Ay Buxačux, bez şivana ibaka, Bez afırına coğabsuz ma efa. ");
INSERT INTO udi_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Dünyəni ošelxunez k'ale Va, Umuda bot'ezu ene zu. Hun za kul nu p'ap'ala sa q'ayana taşa, ");
INSERT INTO udi_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Şot'aynak' ki, Hunnu bezi umudi ga, Düşmənəxun za efala ost'aar q'ala. ");
INSERT INTO udi_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Barta həmişəluğ Vi ı̌vel çadıra yəşəyinşaz, Vi q'ənədxoy oq'a zaynak' gabes bakaz. ");
INSERT INTO udi_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Bez tadi elasxon ibaki Hun, ay Buxačux, Va çalxalt'oğoynak' həzirbi payaxunen za q'ısmatbi. ");
INSERT INTO udi_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Padçaği ömürə boxoyba Hun, Barta şot'ay padçağluğ nəsiləxun nəsilə c'ovaki ost'aarq'an baki. ");
INSERT INTO udi_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Barta Vi piyes şaat' ak'eśi həmişəluğq'an arśi iz taxt'e loxol, Barta Vi nu badalbakala çuresunen q'a şaat'luğen şot'o q'orişi efeq'an. ");
INSERT INTO udi_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","T'e vədə zu həmişə Vi s'iya alabala mə̌ğur mə̌ğk'oz, Bez tadi əyiti loxol çurpi hər ği q'urbanxo šamk'oz! ");
INSERT INTO udi_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Fark'alxoy kalo bakala Yedutuneynak' śameśi Davidi Ǐvel mə̌ğ. Tək Buxačuğoz arxayin zu, Zaynak' çark'esun Şot'oxun eğale! ");
INSERT INTO udi_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Tək Şone zaynak' q'aya bakalo, bez Çark'est'al, Şo bez bač'ane - hik'k'alen satenekon za! ");
INSERT INTO udi_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Hevaxt' kul haq'alnan və̌n me pisluğbsunaxun? Amdari loxol taśi Şot'o k'os'baki barina lik't'i sakala k'inək' saksunaxun, Barala çəpərə galdi oç̌alen sabala k'inək', Şot'oval saki oç̌alen sabsunaxun hevaxt' kul haq'alnan? ");
INSERT INTO udi_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","İçoğoy fikir amdara piyexun saki şot'o əfçibsune, Əfçinent'un nəfəs haq'sa şot'oğon! Ç̌oye muč'at'un əyite, Ük'e boş isə q'arğişt'un śiye şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Ay bez ük', Buxačuğo arxayinbaka, Tək Şot'one bez umud. ");
INSERT INTO udi_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Tək Şone zaynak' q'aya bakalo, bez Çark'est'al, Şo bez bač'ane - bitezton zu! ");
INSERT INTO udi_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Bezi çark'esunal, təmiz s'iyal Buxačuğone tast'a za, Şone zaynak' bač'an baki za İz q'ənədi oq'a ext'alo! ");
INSERT INTO udi_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Vi t'ar ğineyal, mǔq ğineyal Şot'o umudbaka, ay azuk'! Şot'o ams'iba vi ük'ə, Axıri Buxačuxe beş umudi ga. ");
INSERT INTO udi_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","İnsan hik'k'al tene, Əfçi əyite şot'o umudbaksun! Tərəzik'ə laxi ayzap'k'ala hik'k'al butene şot'ost'a, C'ovaki tağala sa muşaxun avuzin tene şo. ");
INSERT INTO udi_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Nə və̌st'a bakala zora umudmabakanan, Nəəl başq'i girbi malaxun fərəxləyinşmabakanan! Var-dövlət heq'ədər avuzal bakayin, ef pula k'ač'ibsa ma bartanan. ");
INSERT INTO udi_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","12","Buxačuğoy \"zor Zast'ane\" upsuna, Şot'ay \"Q'ončuğost'ane nu badalbakala çuresun\" əyitə ibakezu. Hərt'u iz biq'i əşlin əvəzən tast'a Hun, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Davidi İudeyin ams'i oç̌ala bakat'an śampi Ǐvel mə̌ğ. Ay Buxačux, Hunnu bez Buxačux! Bez ük'en Vane çuresa! Q'aribaki oç̌al t'ǒp'k'ala k'inək' bez cicirxone t'ǒpě Vaynak', Xesuz mandi bədən xeneynak' bok'ala k'inək'e boksa Vaynak' bez uruf! ");
INSERT INTO udi_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Vi bakala ı̌vel gala Vi loxolez běğsay zu, Vi kalaluğa, Vi zoraz aksay. ");
INSERT INTO udi_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Mone, bez muzen Vane tərifləyinşbsa, Şot'o görə ki, Vi nu badalbakala çuresun yəşəyinşaxunal üst'üne! ");
INSERT INTO udi_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Bez ömüri axıral śirik' Va alxışp'oz zu, Afırıpi Vi s'iya alaboz! ");
INSERT INTO udi_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Tikoğoy ən şaat'o bez elmoğo taśi k'inək' bakale t'e vədə, Bez ük' qayeğale, muzen mə̌ğpi Va tərifləyinşale! ");
INSERT INTO udi_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Bask'i galal Vaz eyex bast'a, Dirist' üşe Vi baradaz fikirbsa. ");
INSERT INTO udi_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Bez kiyexun biq'alonu Hun, Vi xojina baksunene mǔqst'a za. ");
INSERT INTO udi_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Bez ük' Vaxun ğaç̌e, Vi kula zaxun ten zap'e Hun. ");
INSERT INTO udi_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Bez bisuna çureğalorox isə Gərəmzəluğ bakalt'un! ");
INSERT INTO udi_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Q'ılıncaxun p'uri Aramt'orxoynak' yem bakalt'un şorox! ");
INSERT INTO udi_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Ama padçağ Buxačuğoxun mǔqbakale, Buxačuğo elask'alt'oğoyal bitot'in Şot'o alxışp'ale! Əfçi əyitk'alxoy isə ǰomo gireğale! ");
INSERT INTO udi_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Ay Buxačux, bezi Va afırıpi k'alpsuna, bez səsə ibaka, Bez ük'e q'ı̌ badala me düşmənxoxun bez elmoğo çark'est'a! ");
INSERT INTO udi_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Me zalımxon içoğoy ük'e biq'est'i pisluğxoxun, Şər bakalt'oğoy pis niyətxoxun za q'orişa! ");
INSERT INTO udi_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","İçoğoy ǰomoxun c'eğalt'oğon ğayin me k'inək'e bost'a, İçoğoy hər əyit hari ox k'inək'e t'ə̌q'esa amdara! ");
INSERT INTO udi_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Pusq'una arśi ǒxə̌lbal k'inək' arśi yaq't'unběğsa, Bürdənt'un dǒpst'a sal sa taxsır nu bakalt'u. Hik'k'alaxun q'ı̌tet'unbsa şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Hələ t'iyə̌mint'oğoval k'alpi pis əşur biq'seynak' yaq'nuxunt'un c'evksa, Təlinə hetər laxseynak't'un maslaatbsa. \"Şuk'k'ali xavaral tene bakal\" next'un. ");
INSERT INTO udi_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Mani bic'luğa əşp'est'una fikirbi bə̌ğə̌bit'uxun oşa \"Běğa he şaat'e beş haq'ılen bot'i\" pi fərəxləyinşt'unbaksa. İnsan həgigiyal bic' bakala şeye! ");
INSERT INTO udi_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Ama Q'ončuğon şot'oğo İz oxurxon yaralayinşale, T'e vədəl běğalt'un ki, taşevk'et'un. ");
INSERT INTO udi_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","T'iyə̌mint'oğoynak' piyorox bito içoğoy bel barale; Şot'oğoy axıra ak'alt'oğonal içoğoy bula ǰı̌k'k'alt'un, Şot'oğo axšumi ga balt'un. ");
INSERT INTO udi_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","İnsanxon mot'o ak'i q'ı̌balt'un, Buxačuğoy biq'i əşurxo muzel eçeri car sakalt'un! Me barada fikirbi Şot'ay bit'oğo p'urum içoğoy eyex badi bakalt'un! ");
INSERT INTO udi_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Barta düzgünt'oğon içoğoy mǔqluğa Q'ončuğost'aq'at'un ak'i, Şot'ay q'ənədi oq'aq'at'un gireśi! Barta ük'təmizt'oğon Şot'ay s'iya alabeq'at'un! ");
INSERT INTO udi_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Vi tərif Vaxune Siona, ay Buxačux, Bex p'ap'esp'alyan yan Va elasp'i tadi əyitmoğo! ");
INSERT INTO udi_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Va afırıpi k'alk'alt'oğo ibakalonu Hun, Vi t'ǒğǒl eğalt'un amdarxo bito! ");
INSERT INTO udi_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Günaxxoy boş batk'eyan tayansa, Ama Hun beş taxsırxoxun c'ovaki beş elmoğo çark'est'alonu. ");
INSERT INTO udi_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","He bəxt'əvəre Hun c'ək'p'i Va ı̌šabiyo, İçeynak' Vi bakala ı̌vel gala mesbiyo. Vi k'ojen, Vi ı̌vel ganen tadala neymətxon boşalyan yan! ");
INSERT INTO udi_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Ay Buxačux, ay yax çark'est'ala Buxačux, Hun heq'ədər zorba, heq'ədər düzgün baksunane ak'est'a Vi yax kul boxost'unen! Dirist' dünyəni, lap dənizxoy t'e ç̌oye bakalt'oğoynak' umudi ganu Hun! ");
INSERT INTO udi_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Kala zore q'ončux bakalo, Buruxmoğoy binorina Vi kiin ost'aarbi laxiyonu Hun! ");
INSERT INTO udi_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Dənizi guğultina bot'iyo, Ěqeśi ləpoğo bask'est'i k'inək', Ěqeśi azuk'xoval bask'est'iyonu Hun! ");
INSERT INTO udi_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Dünyəni t'e bel bakalt'oğonal Vi biq'i əşurxo ak'i Va bult'un k'os'bsa, Běğc'eğalaxun burqi běğ batk'ala tərəfəl śirik', Oç̌ali ç̌oyel bakalt'oğoy bitot'in Va tərifləyinşala mə̌ğure mə̌ğě. ");
INSERT INTO udi_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Oç̌ali q'ayğinan manst'a Hun, Şot'o xe duği bərəkətlun bsa. Buxačuğon xe duğala arxe ǰomo biq'teneğon, Şot'ay běğala oç̌alen tadala bar bole bakon, Axıri Hun Vi kiinen həzirbsa me oç̌ala! ");
INSERT INTO udi_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Hunen sərnoğo xenen buybsa, Ezbi ganxo ağalinen cugübi hamavarbsa. Vi xeyir-bərəkətene göyünbaksa biti hər śil! ");
INSERT INTO udi_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Beşi hər usen ext'ala baren Vi heq'ədər kulqay baksunane ak'est'a, Vi kul laft'ala hər ganen bolluğe eşt'a! ");
INSERT INTO udi_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Běğa xam ganu göyün oyen, Buruxmoğo mǔqluğen hetəre haq'e! ");
INSERT INTO udi_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Q'oruğxo sürüğoy, Dəroğo taxıli kiyexun ak'es tene baksa, Bitot'ay ük'e qayesa, muz qaypi mə̌ğt'unne şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Fark'alxoy dəst'in kalat'aynak' śameśi Ǐvel mə̌ğ. Ay me dünyəne bakala bito amdarxo, Mǔq səsur c'evk'i Buxačuğo alxışp'anan! ");
INSERT INTO udi_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Şot'ay s'iya mə̌ğur mə̌ğpi alabanan, Şot'o tərifləyinşanan! ");
INSERT INTO udi_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Metər upanan Buxačuğo: «Nu ak'eğala əşuren biq'sa Hun, Şuk'k'al iz běš nu çurpes bakala zore bu Vast'a. Düşmənxon diz çökt'est'a Hun, ");
INSERT INTO udi_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Dirist' dünyənene Va bul k'os'bsa! Vat'un tərifləyinşbsa, Vi s'iyat'un mə̌ğpi alabsa». ");
INSERT INTO udi_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Sa ekinan Buxačuğoy bit'oğo ak'anan, Şot'in amdarxoynak' bi əşurxoy kalaluğa běğanan! ");
INSERT INTO udi_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Dənizi xena t'ağaybi q'ariluğe bi Şot'in, Xenen buy oqa turine c'ovaki Şot'ay azuk'. Barta ef ük' qayeśeq'an Buxačuğoy kiyexun ayeğalt'oğo ak'i! ");
INSERT INTO udi_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Zorba bakalo, İz padçağluği axır nu bakalone Şo! İz pul azuk'xoy loxole, Şuk'k'al ěqeśes batenekon Şot'ay loxol! ");
INSERT INTO udi_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Ay azuk'xo, beşi Buxačuğoy s'iya alabanan, Barta efi Şot'o tərifləyinşala səsə bitot'in ibakeq'an! ");
INSERT INTO udi_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Şone yax q'orişi efalo, Beş tur ǰěna lafst'a nu bark'alo. ");
INSERT INTO udi_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Ay Buxačux, gümüşi təmizluğa gam buxarina yoxlayinşala k'inək', Hunal yax çətinluğxoxun c'ovakest'in yoxlayinşi! ");
INSERT INTO udi_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Zindanxon badest'i yax, Beş bač'ane bı̌hi yüken laxi. ");
INSERT INTO udi_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Düşmənxon saki ç̌axç̌uxk'alane baki yax, Aruğoxun c'ovaki, xenaxun baśi c'eğalayan baki! Ama mone, běğa hetər bolluğan c'evk'i Hun yax! ");
INSERT INTO udi_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Bok'ospsuni q'urbanxo eşt'eynak' eğoz zu Vi xrama, Bezi niyətp'i tadi əyiti loxol çurk'oz. ");
INSERT INTO udi_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Bezi ǰomoxun c'eri, Bez t'ar ğine niyətp'i tadi əyiti loxol. ");
INSERT INTO udi_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Kökbi heyvanxo q'urban eçeri bok'osboz Vaynak', Eğeli, arak'i saal keçin q'urbanxo šamk'oz. ");
INSERT INTO udi_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Ekinan, ay Buxačuğo çalxi Şot'ay yaq'en tağalorox, Ekinan Şot'in zaynak' bit'oğo exlətp'az ǔmǔxlaxanan. ");
INSERT INTO udi_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Bez bula alabi Şot'oz k'alpi zu, Bez ǰomoxun Şot'aynak'e tərifxo bari. ");
INSERT INTO udi_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Günaxa za ı̌ša bist'a bartiyzuy, Q'ončuğon za ǔmǔxtenelaxoy. ");
INSERT INTO udi_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Ama inebaki za Buxačuğon! Bez xoyinša coğabsuz tene efi, ");
INSERT INTO udi_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Bezi afırına nu ibaksuna tene laxi Şot'in! İzi nu badalbakala çuresuna zaxun nu kambi Buxačuğo alxışq'an baki! ");
INSERT INTO udi_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Fark'alxoy dəst'in kalat'aynak'. Simlə ət't'əcxon farpi mə̌ğěğala Ǐvel mə̌ğ. Ay Buxačux, Vi ük' bok'ospsuna q'a xeyir-bərəkətə yaxun kammaba, Barta Vi piyes şaat' ak'eśi Vi ük'el bask'es baken yan! ");
INSERT INTO udi_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Barta me dünyəne bakalt'oğoy bitot'in Vi yaq'en taysuni k'ə baksuna q'amişakeq'at'un, Bito millətxon Vaxun eğala çark'esuna ak'eq'at'un! ");
INSERT INTO udi_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Barta azuk'xon Vi s'iyaq'at'un alabi, Bito azuk'xonq'an Vi s'iya alabi, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Barta millətxo mǔqbakeq'at'un, Barta içoğoy ük' qayeśi mə̌ğpeq'at'un şot'oğon! Şot'o görə ki, Hun azuk'xo düzgün divanbalonu, Me dünyəne bakala bito millətxo yaq' ak'est'alonu! ");
INSERT INTO udi_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Barta azuk'xon Vi s'iyaq'at'un alabi, Bito azuk'xonq'an Vi s'iya alabi, ay Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Buxačuğon, beş Buxačuğon yaxun İz xeyir-bərəkətə kamtenebi, Oç̌alen yax iz bara bol-bole tadi. ");
INSERT INTO udi_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Barta Buxačuğon yax xeyir-bərəkətq'an tadi, Dünyəne me belxun burqi t'e bel śirik' şu bunesa bitot'in Şot'o çalxi bulq'at'un k'os'bi! ");
INSERT INTO udi_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi Ǐvel mə̌ğ. Hayza, Vi şu baksuna ak'est'a, ay Buxačux! Barta Vi düşmənxo śareśeq'at'un, Va nu çureğalorox Vi běš çurpes nu baki t'it'ereq'at'un! ");
INSERT INTO udi_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Barta zap'eśi tağala k'üünəxun hik'k'al nu mandala k'inək' Şot'oğoxunal hik'k'al maq'an mandi. Barta gam laft'ala mom xebaki piyexun aç̌ala k'inək' Şoroxal Buxačuğoy piyexun aç̌eq'at'un! ");
INSERT INTO udi_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Düzgün bakalt'oğoy isə barta ç̌oyenq'an axšumpi! Barta içoğoy ük' qayeśi Buxačuğoy bakala gala mə̌ğurq'at'un mə̌ğpi, Mǔqluğq'at'un c'ovakest'i şot'oğon! ");
INSERT INTO udi_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Buxačuğoynak' mə̌ğpanan, Şot'ay s'iya mə̌gěn alabanan, Asoyxoy loxol Tarak'alt'u tərifləyinşanan! Q'ončuxe Şot'ay s'i, Ak'est'anan ef mǔqluğa Şot'ay bakala gala! ");
INSERT INTO udi_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Yetimxoynak' bava, süpür mandi çupuxxoynak' bač'ane İz ı̌vel k'oya bakala Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Tək mandit'oğo k'oj-mes balone Buxačux, Türminə bakalt'oğo t'et'iin c'eysuni mǔqluğa q'ısmat balone Şo. Şot'ay laxi k'anunaxun c'eriyorox isə q'oruğa mandi k'inək't'un! ");
INSERT INTO udi_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Ay Buxačux, Hun azuk'i běš baśi tağat'an, Ams'i oç̌alaxun c'ovakat'an ");
INSERT INTO udi_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Oç̌ale ǰı̌k'esay Sinay buruğo İz azuk'axun irəziluğ ğaç̌eśi Buxačuğoy běš, Göynuxun ağalane barst'ay israilluğoy Buxačux bakala Q'ončuğoy běš! ");
INSERT INTO udi_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Ay Buxačux, me Vaxun mandi neyməteynak' Xesuz mandi oç̌aleynak' ağala k'inək'en baki Hun! T'ǒp-t'ǒpi oç̌alen xena q'uc'p'i içule hari! ");
INSERT INTO udi_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Vi azuk'e yəşəyinşbsa me məsk'əne, Goroxt'oğon Vast'a bakala şaat'luği k'ə baksunat'un aksa. ");
INSERT INTO udi_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Mone, Q'ončuğoy əmir hari p'anep'i, Sa dəst'ə çupuxxonal t'it'eri me mǔq xavarat'un yəymişi: ");
INSERT INTO udi_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","«Qoşt'un qaybaksa düşməni q'oşunxo, T'it'unst'a şot'oğoy padçağxo! Ekinan, ay işq'arxo davina yaq'abi israilluğoy çupuxxo, Ekinan düşməni kiyexun ext'it'oğo cöybanan! ");
INSERT INTO udi_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Heq'ədər arśalnan gam k'oya? Ekinan q'ənədxo gümüşi, Popurxoval q'ızıli xena çəpeśi göyərçin k'inək' bakanan!» ");
INSERT INTO udi_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Şəp'eśi Bitova Başarbalt'in me oç̌alaxun padçağxo, Śalmon buruğo hari ı̌ǰ barala k'inək'e bari şot'oğoy bel bələ! ");
INSERT INTO udi_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Ay iz kalaluğen amdari pula taşala Başan buruxmux, İz təpoox gele bakala Başan buruxmux! ");
INSERT INTO udi_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Het'aynak'nan Sion buruğoy paxılluğa zap'e? Buxačuğon İçeynak' çureśi buruğoy, Q'ončuğon İzi həmişəluğ bakala ga k'inək' c'ək'p'i buruğoy Paxılluğa het'aynak'nan zap'e, ay alloy buruxmux? ");
INSERT INTO udi_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Vis' hazarxon, baç̌ hazarxone Buxačuğoy davin araboğoy say, Şot'oğone eçeri Q'ončuğo Sinay buruğoxun İz bakala ı̌vel gala! ");
INSERT INTO udi_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Vi kiyel baft'i düşmənxo Vi bač'anexun badin laśi Hun t'e alloyluğa. Amdarxoy bitot'uxun payen ext'i Hun, Lap Vi əyitəxun c'erit'oğonal Vi bakala gala payt'un eçeri ki, T'iya məsk'ən sakes bakavax, ay beşi Buxačux bakala Q'ončux! ");
INSERT INTO udi_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","20","Q'ončuğo alxışq'an baki! Beş ə̌mnəbel bakala yükə ext'ala, Yax çark'est'es bakala Buxačuxe Şo. Bitot'uxun üst'ün bakala Q'ončux Buxačuxe yax bisuni kiyexun ext'alo! ");
INSERT INTO udi_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Duği śark'ale Buxačuğon İz düşmənxoy bula, Č'ak'k'ale yaq'a aç̌esp'it'oğoy q'açi nu laft'i kəllinə! ");
INSERT INTO udi_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Axıri əyite tade Buxačuğon: «Başan buruğoy belal lağayt'un bə̌ğə̌boz şot'oğo, Dənizi tumexunal bakayin zapi c'evk'oz! ");
INSERT INTO udi_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","T'e vədə vi ük' çaxeśi bakale şot'oğoy axıra ak'i, Xə̌yoğon lamk'alt'un şot'oğoxun bari p'iya». ");
INSERT INTO udi_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Çökt'esendi şot'oğo, ay Buxačux! İsə běğa düşmənxo İz turin oq'a laxi bez Padçağ, Bez Buxačux hetəre taysa İz ı̌vel gala! ");
INSERT INTO udi_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Běš ı̌vel mə̌ğur mə̌ğk'alxo, Bač'anexun fark'alxone taysa Şot'ay! Dəf duğala xuyərmuxal bune bı̌yex. ");
INSERT INTO udi_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Buxačuğoy s'iya alabanan, ay azuk', Q'ončuğo tərifləyinşanan, ay İsrailaxun törəyinşakiyorox. ");
INSERT INTO udi_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Mone, miyane tayfoğoy ən mis'ik'o bakala Binyamini tayfa, Miyane kalaluğbalxoxun bol bakala İuday tayfa! Zevuluni q'a Naft'alini tayfin boş bakala kalat'oğoval azaksa zu! ");
INSERT INTO udi_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Zorba bale vi kula Buxačuğon, va zor tadale! Ak'est'a yax Vast'a bakala zora, ay Buxačux, Həmişə yaxun baki k'inək', həysəəl yaxun baka. ");
INSERT INTO udi_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Yerusalima, Vi bakala gala Payurxo eçalt'un Vaynak' padçağxon! ");
INSERT INTO udi_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Əfçiba t'e ə̌qnə heyvana, İçoğost'a öküzi zor bakala t'e azuk'i bula č'ak'p'a! Barta biti xoreśeq'at'un, Barta Vaynak' gümüşə payq'at'un eçeri! Bask'est'a Vi loxol ěqeğala bito azuk'xo! ");
INSERT INTO udi_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Mone, Misiri padçağen iz elçiğone yaq'absa, K'uşluyoxal kulbuyt'un eysa Buxačuğoy t'ǒğǒl! ");
INSERT INTO udi_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Ay dünyəne bakala bito ölkoğoy amdarxo, Buxačuğoynak' mə̌ğpanan! Q'ončuğo tərifləyinşanan! ");
INSERT INTO udi_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Hələ burqesunast'a laxeśi göyurxoy loxol Tarak'alo, İz səsen İçust'a bakala zora ak'est'alone Şo! ");
INSERT INTO udi_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Buxačuğoy zora ef muzel eçeri car sakanan me barada! İz kul israilluğoy loxol bakalo, İz zor göynul p'ap'alone Şo! ");
INSERT INTO udi_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Ak'est'a Vi ı̌vel ganuxun Vi şu baksuna, ay israilluğoy Buxačux! Vi azuk'a zor tadalonu Hun, Şot'oğo düşmənxo çökt'est'es bakala elmux tadalonu Hun! Alxışq'an baki Buxačuğo! ");
INSERT INTO udi_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Fark'alxoy dəst'in kalat'aynak'. Davidi \"Gěše vard k'inək' gözəl bakala irəziluğ\" uk'ala faren mə̌ğěğala Ǐvel mə̌ğ. Çark'est'a za, ay Buxačux, xenen za q'uc'ene, Hari bez xirt't'əyel śirik' p'ap'ene! ");
INSERT INTO udi_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","T'etər sa batağluğaz baft'e ki, Bez tura laxala ga tez bə̌ğə̌bsa. Xenen taneşt'a za, bə̌ğə̌loy sa oqnu batk'ala k'inək'zu zu! ");
INSERT INTO udi_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Halnuxunez bite zu köməyə k'alpsaxun, Bez piin neğe q'aribaki Buxačuğoy yaq'a běğsaxun. ");
INSERT INTO udi_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Hik'k'ali loxol za nifrətbalorox bez biin popaxun gelene bake, Nahaq' gala bez bač'anexun baft'it'oğoy saye avuzbake. Zaxun het'u tadi ext'es tet'un baksa tez q'amişaksa. ");
INSERT INTO udi_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Bez biq'i əşurxo bito Vi piin běše, ay Buxačux, Bez günaxxo Vaxun c'ap' tene. ");
INSERT INTO udi_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Za ç̌omə̌yin ma efa, ay Buxačux, ay Q'oşuniQ'ončux! Tene Va umudbakalt'oğoyal bula k'os'bi bakoz, Va q'ə̌věğalt'oğoval ot'p'est'i bakoz zu, ay İsraili Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Axıri ǰame q'ončuxal bazki zu Vi yaq'en taysuna görə, Bezi ç̌oyel əyitəl hari vədə bakene. ");
INSERT INTO udi_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Bezi ı̌šat'oğone zaxun ç̌o taradi, Nanaxun sa viçimoğoy piyexunez biti zu. ");
INSERT INTO udi_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Şot'o görə ki, Va laft'ala hər əyit zaal lafest'a, Vi k'oja çuresunen za bok'osp'i-śinne, Vi bakala gane barada pis əyit ibakat'an bez pisa ibakala k'inək'ez baksa! ");
INSERT INTO udi_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Bezi ğurux efi ǒnepsunal Lağlağin gane bake, ");
INSERT INTO udi_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Mə̌yin lapi yas efat'anal bez loxolt'un axšume! ");
INSERT INTO udi_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Dirist' şəhəren zaxune əyite, Finağoyxoyal ǰomoz baft'e zu! ");
INSERT INTO udi_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Zu isə Vaz afırıpi k'ale, ay Q'ončux, Za coğabsuz ma efa zu Vi piyes şaat' ak'eğala vədine, Vi nu badalbakala çuresuna ak'est'i za çark'est'a. ");
INSERT INTO udi_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Zapa c'evk'a za me çeyilluğaxun, Bafst'a ma barta! Za bə̌ğə̌loy xeyurxoy boş batevk'ala me düşmənxoxun çark'est'a! ");
INSERT INTO udi_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Ma barta za selen taşeri bə̌ğə̌loy sa oqnu bosane, Bez baft'i kure ç̌oya but'esa ma barta! ");
INSERT INTO udi_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Vi nu badalbakala çuresuni k'ə baksuna ak'est'i za çark'est'a, ay Q'ončux, Bez loxol běğa, Vi ük' bok'ospsuna zaxun kammaba! ");
INSERT INTO udi_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Me Vi k'ula nu aksuna ma laxa, Eki bez t'arnu p'ap'a, za ibaka. ");
INSERT INTO udi_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Zaxun ə̌xil ma baka, eki za çark'est'a, Za bez düşmənxoy kiyexun haq'a! ");
INSERT INTO udi_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Anksa Hun bez düşmənxoy balt'oğo bitova: Şot'oğoy za bakala nifrətə q'a Za biyaburbi amdarxoy piyexun saksun çuresuna. ");
INSERT INTO udi_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Za uk'ala əyitmoğo ibaki bez ük'e xə̌xə̌yesa, Bez kiyexun hik'k'al tene ayesa! Nə zaynak' sa ük' bok'osp'ale bu, Nəəl sa ük' tadal. ");
INSERT INTO udi_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Busabakat'an ağut'un tadi za, Xenezaluğa oq'oyent'un bot'i şot'oğon. ");
INSERT INTO udi_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Barta q'urbani q'onaxluğxo c'ovakest'ala gala içoğoy kul-turq'an ğaç̌eśi, Barta içoğoxun sa ist'olin bel arśalorox içoğoy turin oq'axun kašk'aloroxq'an baki. ");
INSERT INTO udi_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Piin işiğq'an bari, Bač'anq'an xoxbaki şot'oğoy barta! ");
INSERT INTO udi_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Vi hirsləyinşaksuni k'ə baksuna ak'est'a şot'oğo, Barta Vi bok'osp'i śik'ala əcuğ şot'oğoy belq'an bari! ");
INSERT INTO udi_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","K'ojin işiğq'an aç̌i şot'oğoy, Çadırxoq'an xarabina mandi! ");
INSERT INTO udi_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Şot'o görə ki, Hun Vi ç̌oya taradit'oğoy bač'anexun baft'iyoroxe, Bitit'oğo samalal lik't'i sakaloroxe şorox. ");
INSERT INTO udi_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Śampa şot'oğoy me günaxal cazasuz nu mandala günaxxoy siyəyinə, Vi běš içoğo təmizə c'evksa ma barta şot'oğo! ");
INSERT INTO udi_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Silba şot'oğoy s'iya Vi girkəxun, Həmişəluğ yəşəyinş q'azayinşes bakala düzgünt'oğoxun sa siyəyinə maq'at'un baki barta. ");
INSERT INTO udi_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Zu isə goroxzu, dərde boş bakala sa amdarzu, Zapa c'evk'a za me əzyəti boşt'an, ay çark'est'es bakala Buxačux! ");
INSERT INTO udi_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Mə̌ğpi alaboz Buxačuğoy s'iya zu, Şükürbala mə̌ğur c'eğale bez ǰomoxun. ");
INSERT INTO udi_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Mo Q'ončuğoy piyes öküzi q'urbanaxunal şaat' ak'eğale, Bul-turaxun sagala q'urban eçala arak'axunal üst'ün bakale. ");
INSERT INTO udi_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Fağırxo mǔqbakale mot'o ak'i, Buxačuğo qə̌věğalt'oğoy ük' qayeğale! ");
INSERT INTO udi_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Axıri inebaksa Q'ončuğon eht'iyəci boş bakalt'oğo, İz azuk'axun əzyət ak'alt'oğoy saycət'u nu ibaksuna tene laxsa. ");
INSERT INTO udi_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Barta göyurxoxun q'a oç̌alaxun, Barta dənizxoxun q'a mot'oğoy boş bakalt'oğoy bitot'uxun Şot'ayn