﻿USE sofia;
DROP TABLE IF EXISTS sofia.ubu_nopenge_vpl;
CREATE TABLE ubu_nopenge_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ubu_nopenge_vpl WRITE;
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","⸤Isirele yambomanga ou pulu pulu anda kolepa⸥ Eporayamo kinie* pe yandopa ⸤enenga ye nomi kingi aili⸥ Depisi kinie eltene Yesusi Kirasi** kalko liringili mele i sipe: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eporayamone Aisake merimu; Aisakene Jekopo merimu; Jekopone Juda kinie Judanga angenupilime kinie merimu;* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judane Peresi kinie Sera kinie merimu, kanu yetolonga anumu Tema; Peresini Esirono merimu; Esironone Ramo merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramone Aminadape merimu; Aminadapene Nasono merimu; Nasonone Sallimono merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sallimonone Boasi merimu, Boasi yunge anumu Reapa; Boasini Opete merimu, Opete yunge anumu Rute; Opetene Jesi merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesini ye nomi kingi Depisi merimu.* Depisini Sollomono merimu. Sollomononga anumu ou Yurayanga ambo menumu molorumu. Pe Depisini kanu ambomo konopu monjipe Yuraya topa konjipe ambomo yu lirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sollomonone Riapoamo merimu; Riapoamone Apaya merimu; Apayane Eta merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Etane Josipate merimu; Josipatene Joramo merimu; Joramone Asaya merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asayane Jotamo merimu; Jotamone Eyasi merimu; Eyasini Esikaya merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esikayane Manasa merimu; Manasane Emosi merimu; Emosini Josaya merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josayane Jekonaya kinie yunge angenupilime kinie merimu. Josaya kolopili yunge malopili molangi opa tou yamboma Isirele yamboma kinie ongo opa tekolie toko munduku Isirele yambo aisili ka siku enenga kolea aili Bepillono mengo puringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka siku mengo puringi kinie pe Jekonayane Sialtele merimu; Sialtelene Serapapele merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serapapelene Apayate merimu; Apayatene Ellayakimu merimu; Ellayakimuni Eso merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esone Sedoke merimu; Sedokene Ekimu merimu; Ekimuni Ellayate merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ellayatene Elliesa merimu; Elliesane Matano merimu; Matanone Jekopo merimu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopone Josepo merimu. Josepo Maria menu. Josepone Maria ou naa lipili Maria yu ambolango olona monjipe molorumu. Pe ambo yetolo moloringili kinie Mariane Yesusi merimu. ⸤Pulu Yemone “Ene nokopa konjimbe ye nomi te lipu mundumbu.” ou nimbe mako torumu yemo pe Yesusi aku yemo omba molorumuna⸥ yunge imbi te pea sikulie ‘Kirasimu’* niringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eporayamo kinie Eporayamone yandopa yandopa kalopa lipe Depisi kalopa lipe terimu yema ⸤Yesusinge⸥ anda kolepa tene po* moloringi. Pe Depisini yandopa yandopa ou Bepillono yambomane Juda yambo mare ka siku Bepillono anju naa mengo pangi anda kolepa tene pola moloringi. Bepillono ka siku mengo puringi kinie pe yandopa ye nomi Kirasimu kinie kalko liringi ye tene pola moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesusi, Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu,* yu meringi temanemo i sipe: Yunge anumu Marianga pulu lerimu yambomane “Maria Josepone lipili.” ningu koronga niringi nakolo ou Josepo pea teluna naa peangili Mini Kake Telimuni Maria yunge olona ambolango te monjinjirimumu Maria yuyu pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kanu kinie yunge ye Josepo yu ye sumbi nilimu molorumuna Maria ambolango monjirimu kinie pilipelie ‘Maria olie naa polopili.’ nimbe ‘Yambo aisili molangi yu temu mele nimbu para naa sipu yu yuyu molomba kinie kiyongo nimbu we “Kamu pui.” niembo.’ konopu lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josepo aku sipe konopu lipe mundupe molopili Ailimunge angello tene Josepo uru kumbu sipelie nimbendo: “Josepo, ye nomi kingi Depisini kalopa lirimu yemo, Mini Kake Telimuni Maria ulu te terimuna yu ambolangomo olana monjilimo kene yu linindu pipili naa kolko li.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","“Yu kango kanopa limbe. Kanu kangomone yunge yamboma ‘Enenga konopuna ulu pulu keri telemelema pepili molkolie mindili nonge.’ nimbe ene lipe taponjipe, mindili nolemelka ulkena wendo lipe, yu kinie pea molko konjingí aulkena lipe monjimbe kene yunge imbi lelko “Yesusi”* nieni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aku sipe wendo orumu ulumanga pali koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye tene ulu mare pe wendo ombá ou nirimu mele kamu wendo orumu. Akumu i sipe: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pilieyo. Ambo wenepo tene ambolango olona monjipelie kango te memba. Kanu kinie yunge imbi lelko “Imenuele” ningí.”* nirimu. I imbimunge ungu pulumu ‘Pulu Yemo** olio kinie molemo’. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josepo uru pepa makilipelie Ailimunge angellomone nirimu mele pilipe lipe tepalie ambomo lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nakolo yu ambolangomo ou naa mepili “Teluna naa peambili.” nirimu. Pe Mariane kango te merimu kinie* Josepo yuni yunge imbi lepa “Yesusi” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erote kolea Judia disiriki yambomanga ye nomi kingi molopili Mariane kolea Judia, Betellieme taonona Yesusi merimu. Kanu walemanga ena wendo oli koleana pilipe konginjili peli ye pokore alieli ‘Ulu mare wendo okomonje piliemili.’ ningu kombukandipime mimi siku kanoko moloringime kolea aili Jerusalleme ongolie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda yambomanga ye nomi kingi molomba kango meringimu* tena molemoye? Olio ena wendo olemo koleana molopolie ye te ye nomi kingi molomba meringimu lipe ora sili kombukandipi te pulu pulu wendo omba angilirimu kanopolie nirimulumuni, yu popo topo imbi ambolopo ola linjimulundu okomolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ye nomi kingi Erote i ungumu pilipelie ‘Ye te yu kolo wangopa kingi molomba lepamo.’ nimbe pilipelie yu mini wale mundupe, Jerusalleme yamboma pali mini walela munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanu kinie yuni Juda yambomanga Pulu Yemo popo tonjiringi ye ailime pali kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema pali kinie* “Sukundu wai.” nimbelie ene walsipe pilipelie nimbendo: “Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye nomi Kirasimu** tena mengemondo niringiye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Enene yundu ningindu: “Kolea Judia sukundu Betellieme taonona yu menge. Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye ⸤Maikane⸥* pe aku sipe wendo ombamondo ou nimbe boku torumu akuna molemo kanumu. Yuni nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betellieme, kolea Juda* lemo kolea te, yu kolea Juda sukundu kolea ailimenga yu kolea manie te molo. Yunge sukundu ye nomi aili te wendo ombá, akumuni nanga Isirele yambomanga sipisipi tapu yemo molopa ene nokomba.”** nirimu kanumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kanu kinie yambo lupema naa kanoko naa pilku molangi Erotene pilipe konginjili peli yema “Wai.” nimbe kombukandipimu pulu pulu wendo omba angilirimu walemo walsipe pilipelie nirimumuni, yundu ningu siringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","pilipelie enendo nimbendo: “Ene Betellieme puku kangomo wamoko koropayo! Kanoko lenjikulie na ongo ningu sieyo. Na kepe yu ombo popo topo imbi ambolopo ola linjembo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kingimuni aku sipe nirimu pilkulie ene kelko puku kanopuringi. Kanu kinie ena wendo oli koleana molkolie kombukandipi kanoringimu ene puringine kumbi lepa pumbe pupelie kangomo molorumu ulke imuna pupe ola angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Enene kombukandipimu kanokolie konopu paa aili teko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ulkena sukundu pukulie kangomo kinie anumu Maria kinie moloringili puku kanoko lenjiringi. Kanokolie kangomonga kumbikerena koporongo langoko ma kanokolie yu popo toko imbi ambolko ola linjiringi. Linjikulie ene wale peanga mengo oringime apisiku mele peangama wendo liku yu siringi. Kou gollo kinie, paura kalemele kinie mune paa toli paura te kinie, kopongo wele mune paa toli te kinie, aku melema yu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kanu kinie Pulu Yemone ene uru kumbu sipelie enendo nimbendo: “Ene Erote molemona kelko pu naa pangi, molo.” nirimu kinie pilkulie ene aulke tenga lupe ongolie ulkendo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kanu kinie pilipe konginjili peli yema kelko puringi kinie Ailimunge angello tene Josepo uru kumbu sipelie nimbendo: “Ye nomi kingi Erotene nondopa yunge ami yemando “Kangomo koroko toko konjipai!” nimbé kene nu ola molkolie kangomo kinie anumu kinie liku mengo kolea Isipindu kowa puku molopayo. Ne anju molkolie ningímuni, pe nane “Kelko yando wai.” nimbú kinie wangi. Ou molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aku nirimu kinie pilipelie Josepo ola molopalie ipulueli anungulutolo lipe memba Isipindu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","‘Erote kolomba kinie kelepo ulkendo pumulú.’ ningu ou Isipi anju moloringi.* Aku teringimunge Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye tene ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Akumu i sipe: “Pulu Yemone nimbendo: “Nanga kangomondo “Kolea Isipi munduku kelko wendo oi.” nirindu.” nirimu.”** nimbe kanu ye ⸤Osiane⸥ nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kanu kinie anumu lapatolo Yesusi pea Isipi puku molangi, pilipe konginjili peli yemane Erote yu liku lou lenjiringi Erote yuni pilipelie mumindili paa pulumu kolorumu. Mumindili kolopalie ami ye marendo nimbendo: “Betellieme taono kinie Betellieme nondopa lemo koleama kinie kanumanga puku kango ponie talo omba puli kangoma kinie ponie talo naa pora nili kangoma kinie koroko toko konjipai!” nirimu. Kombukandipi kanoko pilipe konginjili peli yemane kombukandipimu pulu monjipe wendo omba angilirimu walemo yundu ningu siringi mele pilipelie ponie aku sipe nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aku sipe terimumunge koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Jeremayane ulu te pe wendo ombá ou nirimu mele wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yuni nimbendo: “Ene kolea Rama* suku ungu te piliringi; kola teringi pilku, yambo kolemele kinie kola telemele mele kola aku siku teringi piliringi. Ambo Reselene yunge ambolangomanga kola terimu. Yu ‘Konopu pe nipili.’ ningulie teringi nakolo yunge ambolangoma naa moloringine yu kondo kolopa mindi molorumu.”** nimbe Jeremayane ou aku nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pe Erote kolorumu kinie Ailimunge angello tene Josepo Isipi molopili uru kumbu sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ “Kangomo toko konjengi koropai.” nirimu yemo kolorumu kene ola molko anumu malotolo liku mengo kolea Isirelendo kelko pui.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","pilipelie yu ola molopa anumu malotolo lipe memba Isirelendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nakolo Akellesi yunge lapa Erote kolo wangopa ye nomi kingimu molopa kolea Judia disiriki nokorumu pilipelie Josepo yu kanuna altopa pumbendo pipili kolorumu. Kanu kinie Pulu Yemone uru kumbu sipelie nimbendo: “Marena tongenje kene akuna naa pui.” nimbe yundu lepi lepi torumu kinie yu kelepa kolea Gallilli disiriki pupe ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akuna lerimu Nasarete taonona pupe molorumuna Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane ⸤Yesusi kinie⸥ ulu te pe wendo ombá ou niringi mele kamu wendo orumu. Enene ningindu: “Yambomane “Yu Nasarete taono ye te.” ningí.” niringi kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","⸤Yesusi Nasarete taonona we molopili⸥ No Linjili Jono omba kolea Judia disiriki sukundu kolea ku leline opa ungu nimbelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pulu Yemo ye nomi kingimu molomba walemo nondopa wendo ombá tekemo kene enenga ulu pulu keri teringi konopuna pelemoma munduku kelko konopu alowa teai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kanu yemo ⸤ou naa molopili paa koronga ou⸥ Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye* Aisayane Pulu Yemonga ungu te nimbe sipe boku torumu. Kanu ungumu i sipe: “Kolea ku leline yambo tenga kerena ungu te nimbendo: “Ailimu ombá aulkemo teko mimi tenjei. Yu ombá aulke kangama toko sumbi siei.” nikimu.”** nirimu. ⸤Aisayane Jonone paa pe temba mele ou aku sipe nimbe panjipe boku torumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jono yu kongi kemelenga indini teli wale te pakopa, kongi kilumuni teli kako te topalie, kulikumbe kinie pilimu no kinie aku langitolo mindi nomba molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kanu kinie kolea aili Jerusalleme yamboma kinie Jerusalleme lerimu kolea Judia disiriki pali yamboma kinie kolea Jodane pali yamboma kinie kanu yemo molorumuna pukulie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","no Jodane sukundu pukulie enene ulu pulu keri teringime ningu para siringi kinie yuni ene no linjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yuni ⸤Juda yambomanga ye aili⸥ Parisime kinie Sadusime kinie* aisili no lingíndu oringi kanopalie nirimumuni, ene iri topalie nimbendo: “Kolo topa yamboma tepa kenjili wambiyemonga waloma, Pulu Yemo mumindili kolomba walemonga naene “Ene talopa lelko pai.” nimu kinie ene ‘Pulu Yemone naa tepa kenjipili.’ ningu ‘No liemili.’ ningu okomeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ene sumbi siku molko, ulu peangama mindi teko molonge kinie ene ulu pulu keri teringime paa sike munduku kelko konopu alowa tenge mele mona lemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Olio anda kolepa Eporayamone kalopa lirimuma molemolomonga yambo peangama molemolo.” ningu aku siku ningu naa pilieme. Nane ene nimbu sikiru: ‘Pulu Yemone i koumando “Eporayamone kalopa lirimu yamboma au leangi.” nilkenje kouma Eporayamone kalopa lirimu yamboma molemelka.’ nikiru. Ene Eporayamone kalopa lirimu yamboma molemelemonga uluri naa telemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Unju peko tomba loumu Pulu Yemone koronga unju puluna ambolopa ola lipe molemo. Unju mongo peanga naa tomba unjuma* yuni peko topalie tepena kalomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nane ulu pulu kerime siye kolko konopu alowa telemele yamboma sike no linjilio. Nakolo te na akilipe ombámo yuni ⸤Pulu Yemonga⸥ Mini Kake Telimu kinie tepemo kinie ene linjimbe ⸤lingí⸥. I na akilipe ombá yemo yunge tondolomo paa olandopa, nanga tondolomo paa maniendopa. Na yu kinie manda molo. Yambo ailimenga kongono keri teli kendemande yambomane sike enenga ailimenga kongono keri tenjingindu kimbu su wendo linjilimele nakolo na akilipe ombámonga kimbu su wendo linjimbu kanu kongonomo paa olandopa mele nane tenjimbu kapola naa telka, ⸤na ye paa keri⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Yuni yunge rasi witi apuruli apulu pokomo ambolopalie yunge rasi witi mongo kinie rasi witi kilu kinie apurumbendo molemo. Yunge rasi witi apuruli polomo tepa mimi tembando rasi witi pali ‘wendo liembo.’ nimbe apurupelie mongoma lipe rasi witi nosilimo mingine ‘Lepili.’ nimbe nosimbendo mingi topa, pe kiluma lipe maku topa tepe naa kumbulupe nomba pepa mindi pulimona kalomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jonone yamboma no linjipe molopili Yesusi kolea Gallilli disiriki mundupe kelepalie nirimumuni, ‘Jonone na no linjipili.’ nimbe Jono no Jodane molorumuna yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Orumu kinie Jonone nimbendo: “Aku paa molo. Nane nu no nambe tepo linjembo ningu nikinuye? Nuni na no linjilinanje papu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nakolo Yesusini pundu topa nimbendo: “Molo. Ulu kake teli uluma pali kapola tepili kene nikiru mele tei.” nirimu. Kanu kinie Jonone “Kapola.” nimbe yu no linjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesusi no lipe pora sipelie nona sumbi sipe wendo orumu. Wendo ombá orumu kinie mulúmu kengeya lepa anju yando purumu, Pulu Yemonga Minimu, kera waembono mele, manie omba Yesusi molorumuna pupe kangine ola molorumu kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kanu kinie muluna ola ungu te wendo ombalie, “I nanga konopu monjilio kangomo. Yu kinie konopu sipu molio.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesusi ⸤no lirimu kinie Pulu Yemonga Minimu yu kinie omba molopalie nirimumuni,⸥ Minimu yuni ‘⸤Kurumanga nomi⸥ depelemone* yu kondi topili.’** nimbe Yesusi kolea ku leline memba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akuna Yesusi oli te koro talo mele* langi naa noli we molopa perimu kinie yu engelene kolopa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kanu kinie ⸤kuru⸥ kondi toli ⸤Setene⸥ ombalie yundu nimbendo: “Nu Pulu Yemonga Malo* liemo i kouma ‘Pillawa kaloli au lepili.’ ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nakolo yuni pundu topa nimbendo: “Pulu Yemonga bokumuni nimbendo: ‘Langimene mindi yamboma konde mololi ulu pulumu naa silimo. Pulu Yemone ungu nilimoma pali pilku liku teko molonge kinie konde mololi ulu pulumu lingí.’ nimbe molemo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kanu kinie depelemone Yesusi lipe kolea aili Jerusalleme, akumundu ‘kolea aili kake teli’ nilimu, akuna memba pupe Pulu Yemo popo toko kaloringi ulke tembelena memba, paa ola imuna pupe anjipelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yundu nimbendo: “Nu Pulu Yemonga Malo liemo nu lipe taponjimbe kene pou ningu manie pui.” ⸤nirimu.⸥ “Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemone yunge angellomane ‘Nu ongo nokangi.’ nimbé. Enene nu ‘Kou tene kepe na topili.’ ningu nu enenga kimene oko polko lingí.’* nimbe molemo kanumu. Aku sipe nirimu kene pilkulie aku siku tei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesusini yundu nimbendo: “Pulu Yemonga yambomando ungu te pea nimbe molemola. Akumu i sipe: ‘Pulu Yemo enenga Ailimuni “Tembo.” nilimo mele ‘Sike nilimonje molo kolo tolemonje kanamili.’ ningu enene yu manda manjiku na teangi.’* nimbe molemola kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Altopa depelemone yu lipe mulu te paa olandopa lerimuna ola memba pupe anjipelie, yu ma koleama pali kinie koleamanga mele peangama pea lipe ora sipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yundu nimbendo: “Nu nanga kumbikerena koporongo langoko manie molko na popo toko nanga imbi ambolko ola linjinu liemo i nu kanokono ma koleana lemo melema pali nu simbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kanu kinie Yesusini yundu nimbendo: “Setene,* nu anju pa! Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemo enenga Ailimu manjiku popo toko imbi ambolko ola linjiku, yunge kongonoma manjiku tenjiku molangi.’** nimbe molemo kanumu.” nirimu.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kanu kinie depelemo Yesusi yu mundupe kelepa yu purumu. Purumu kinie mulu koleana angelloma ongo Yesusi nokoringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kanu kinie ⸤No Linjili⸥ Jono ka siku ka ulkena panjiringi* kinie pilipelie Yesusi kelepa kolea Gallilli disirikindu yando omba ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasarete taonona ombalie nirimumuni, pe aku taonomo mundupe kelepa Kapeniame taono, nomu Gallilli kélona lerimu, akuna pupe ‘Kinié i koleamo nanga molombo kamu koleamo lepili.’ nimbe akuna molorumu. Kapeniame ye Sepullano kinie Napatallaitolone kalko liringili yamboma ou moloringi koleana* lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","⸤Kapeniame taonona pupe molorumumunge⸥ koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane* ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Aisayane nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepullanone kalopa lirimu yamboma pelemele koleamo kinie, Napatallaine kalopa lirimu yamboma pelemele koleamo kinie, nomuna pulimo aulkemo no Jodane nekendo lemo koleamo kinie, kolea Gallilli wikindu yambo lupe aisili* molemele koleamo kinie, aku koleamanga molemele yamboma ⸤paa sumbulu toline molemele⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kanu yambo paa sumbulu toline molemelema pa tondolo paa aili tepa teli te kanoringi. Kololi ulu pulumu aki topa sumbulu tonjilimo koleana pelemele yambomanga koleana pa tenjikimu.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","⸤Kapeniame omba molorumu⸥ kanu walemonga Yesusini yamboma pulu monjipe unguma nimbe sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa nokomba walemo* nondopa wendo ombá tekemo kene ⸤‘Pulu Yemo yuni nokomba yambomanga talapena sukundu molamili.’ ningu⸥ ulu pulu keri telemelema munduku kelko konopu alowa teai.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesusi Nomu Gallilli kélona andopalie angenungulu talo kanorumu, akutolo Saimono kinie angenu Enderutolo oma lili wale te nomuna toko munduku moloringili kanorumu. Pe Saimononga imbi te Pita niringila. Oma liringili akumu eltenga kou kongono teringili kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aku siku teko moloringili kanopalie nimbendo: “Na lombili wangili. Oma lingilindu oma lili wale te liku nona manie mundulimbele kinie omama walena omba pelemo mele, pe ‘nanga kongonomo tengelendo nanga ungumu pilkulu ningu siliku andongele kinie yamboma nanga talapena sukundu ongo molangi.’ nimbu ‘Elte na lombili wale.’ nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aku nirimu kinie pilkululie tamburembu eltenga oma lili walema munduku kelkololie Yesusi lombili puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kanu kinie yu laye kolte wilsu pupelie angenungulu talo lupe kanorumu, akutolo Seperi malo Jemisi kinie Jemisi angenu Jonotolo, lapa Seperi kinie enenga nona andoli sipine sukundu oma lili walema toko tambulku moloringi kanopalie elte walsipelie “Na lombili wale.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aku nirimu kinie pilkululie eltenga lapa Seperi kinie nona andoli sipimu kinie tamburembu munduku kelkololie Yesusi lombili puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kanu kinie Yesusi kolea Gallilli disiriki sukundu koleamanga pali andopa, yamboma maku toko Pulu Yemonga ungumu piliringi ulkemanga yamboma ungu mane sipe, Pulu Yemo nondopa ye nomi kingimu molopa nokomba mele* temane peangamo topa sipe, yambo kuru lupe lupe torumuma kinie kangine ulu aisili terimuma kinie tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yu terimu mele temanemo kolea Siria poropinji koleamanga pali anju anju purumu pilkulie enenga yambo kuru lupe lupe torumu yamboma kinie, mindili lupe lupe nongo moloringi yamboma kinie, yambomanga konopuna kuru molko amboloringi yamboma kinie, kuru kopalli torumu yamboma kinie, kimbu ki kukurumu yamboma kinie, yu molorumuna mengo oringi kinie yuni ene tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yambo paa aisili yu lombili puringi. Kolea Gallilli disiriki yamboma kinie, ‘Kolea Aili Rureponga Talo’ niringi kolea yamboma kinie, kolea Judia disiriki lerimu kolea aili Jerusalleme yamboma kinie, kolea Judia sukundu lerimu we koleamanga moloringi yamboma kinie, no Jodane nekendo koleamanga yamboma kinie, paa aisili yu lombili puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesusini yambo aisili maku toko yu lombili puringime kanopalie ma pangine ola pupe molorumu kinie yu lombili andolime* yu molorumuna oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kanu kinie yuni ene ungu mane sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yambo konopuna koropa pulimo pilimele yamboma Pulu Yemo enenga ye nomi kingimu molopa* ene nokolemomonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Yambo kola teko konopu keri pepili molemele yamboma Pulu Yemone “Ene konopu peanga pepa toembo topili.” nimbemonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Yambo taka lelko molko yambo lupema pilku molemele yamboma ma koleama pali Pulu Yemone ene simbe lingímunge ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pulu Yemone “Teai.” nilimo ulu sumbi nilime tengendo waka kolko molemele yamboma manda molongemonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Yambo lupema kondo kolemele yamboma Pulu Yemone kondo kolombamonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Yambo konopu kake tepili molemele yambomane Pulu Yemo kanongemonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“‘Yamboma konopu teluna pupili molangi.’ nilimele yamboma Pulu Yemone ‘Ene nanga ambolangoma.’* nimbemonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pulu Yemone “Teai.” nilimo ulu sumbi nilime teko molemelemonga yambo lupemane ene mindili silimele ⸤akumunge⸥ Pulu Yemo enenga ye nomi kingimu molombamonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Na pilku molemele yamboma, ene nanga yamboma molemelemonga we yambomane ene ungu taka tonjiku mindili siku, ungu keri lupe lupema enenga bulkundu kolo toko ninjingí kinie ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","⸤Yambomane ene aku siku mele telemelemonga⸥ ene mulu koleana pungí kinie kanuna Pulu Yemone ene mele kalopa konjimbe kene konopu paa aili teko siku konopu peanga pepili molayo.* Yambomane kinié ene mindili silimele mele aku siku ene na molangi koro ou Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siliku andoringi yamboma** we yambomane ene kepe mindili siringila kanumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ene ma koleana yambomanga api kusa mele molemele. ⸤Akumu mele peanga⸥ nakolo yu songo na temba kinie ‘Yu kelepa songo tepili.’ nimbu ulu te manda temoloye? Yu kongono temba tondolo te altopa na pembamonga we topo ele temolo kinie yamboma kimbu kongono teko andoko kambilingí kinie papu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ene ma koleana yambomanga pa tenjilime molemele.* Kolea aili ma pangine ola lembamo manda lopi na tenge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yambomane tepe llame kandokolie mingine suku na panjilimele. ‘Melema kanangi, ulke sukundu pa tepili.’ ningu polo tenga ola nosilimele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aku sipe mele ‘Olione ulu peangama telemolo mele yambomane kanokolie olionga Lapa, mulu koleana molemomo, kapi niengi.’ ningu* enenga pa telemomone yamboma kanangi, pa tenjengi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nane ‘Pulu Yemonga ungu manema ⸤Mosisini⸥ bokuna torumu unguma kinie Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane bokuna toringi unguma kinie* ‘manie pupili.’ nimbé okomo.’ ningu na piliengi! Nane ‘Kanu unguma kamu manie pupili.’ nimbú naa okoro. ‘Aku ungumanga ungu pulu pelemoma kamu wendo opili.’ nimbú okoro. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nane enendo paa sike nikiru: Mulu matolo ou pora na nipili Pulu Yemonga ungu manemanga ungu wallo kolte kepe paa we manie na pumbe. Ungu manemanga pali ungu aili kangamanga pali kongonoma ou wendo ombá.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Akumunge, yambo tene kanu ungu manemanga ungu mane kanga te kepe pulue topa,* yambo lupema mane sipelie “Pulue tangi.” nimbé yambomo Pulu Yemo ye nomi kingi molopa nokolemo koleana** yunge imbi paa manie molomba. Nakolo yambo tene kanu ungu manema pilipe lipe tenge panjipe molopa, yambo lupema mane simbe yambomo Pulu Yemo ye nomi kingi molopa nokolemo koleana yunge imbi paa olandopa molomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nane ene nimbu sikiru: Parisime kinie Pulu Yemonga ungu manemanga puluma mane silimele yema kinie* enene ulu sumbi nilime telemele ulumanga olandopa ene we yambomane na tengi liemo, Pulu Yemo ye nomi kingi molopa yambo nokolemo talapena sukundu ene paa na puku molonge. ⸤Kanu yemane ungu manema pilkulie telemele mele lupe. Pulu Yemone kanopa ulu sumbi nilime nimbe kanolemo mele lupe.⸥” ⸤nirimu.⸥** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Koro ou ⸤Mosisini⸥ anda kolepalimendo ungu mane te sirimumu ene pilimele. Kanu ungu manemo i sipe: “Ene yamboma toko na konjengi.* Yambo topa konjimbe yambomo mongo limbe, ⸤kote pilimele yambomane⸥ yu kote tenjikulie mongo liku singí.”** nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nakolo kinié nane ene kanu ungu manemonga ungu pulumu i nimbu simbu tekero: Yambo tene yunge angenu kinie mumindili kolomba yambomo willisi kotena mengo puku kote tenjingí. Yambo tene yunge angenundu “Nu kamakoye?” nimbé yambomo poropinjili kotena mengo puku kote tenjingí. Yambo tene yambo tendo “Nu paa kongi mele aroma tolimu!” nimbé yambomo tepe koleana pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aku siku tenge yamboma mongo lingí kene nuni ‘Pulu Yemone na kanopa peanga kanopili.’ ningu yunge melema tepena kaloli polona Pulu Yemo kongi molo kera popo toko kalko sinindu mengo ongolie nu angenane nu kinie we mumindili te kolomba pilkulie ninimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nu Pulu Yemo kalko sini melema Pulu Yemo popo toko kaloli polo alsekondo we lepili nosikulie kelko anju puku angenando “Teluna kapola kapola molambili.” ningu puku nipukulie, pe kelko ongo nu Pulu Yemo kaloni melema ongo yu kalko sieni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu kote tenjimbe temba yambomo ‘Kapola kapola molambili ulu te teambo.’ ningulie welea teani. Aku na tenu liemo nu kote tenjimbe yambomone nunge kote pilili yemo molombana memba pupe simbenje. Pe kote pilili yemone nu ka ulke nokoli yemo lipe simbe, yuni nu ka ulkena lipe mundumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nane nundu paa sike nimbu sikirumu: Nu ka ulkena wendo onindu pundu paa pali tokolie mindi wendo onimu. We manda wendo na oni.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“⸤Ou Mosisini⸥ ungu mane te sirimumu ene pilimele. Kanu ungu manemo i sipe: ‘Ambo ye pulime ye lupema kinie wa ulu kerinele na teko, ye ambo lilime ambo lupema kinie wa ulu kerinele na teangi.’* nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nakolo kinié nane ene ⸤kanu ungu manemonga ungu pulumu⸥ i nimbu sikiru: Ye tene ambo te kanopalie ‘Yu pea tapu topo pelembelkanje papu.’ konopu lemo akumu konopu sukundu ambomo kinie kamu wa ulu kerinele telemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nunge mongotolone melte kanokolie konopuni ‘Liemboa.’ ningu pilku ulu pulu keri te tenu liemo mongotolo akuku ele teani. Nunge mongotolo angilipili nu tepe koleana liku mundungí kinie kapola na temba kene kangimunge melte wendo liku ele tekolie molko konjini kinie papu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nunge kitolone ulu pulu keri te tenu liemo aku kitolo kari lelko ele teani. Nunge kitolo angilipili nu tepe koleana liku mundungí kinie kapola na temba kene kangimunge melte wendo liku ele tekolie molko konjini kinie papu.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“⸤Ou Mosisini⸥ ungu mane te sipelie nimbendo: “Ye tene yunge ambomondo ‘Kamu pupili.’ nimbe makorombando ambomo “Kamu pui.” nimbé mele pepá te topa ambomo sipelie yundu “Kamu pui.” nimbe aku tepili.” nirimu kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nakolo nane kinié ene nimbu sikiru: Ye puli ambo te ye te kinie wa ulu kerinele na tepili yunge yemone yu makoropa “Kamu pui.” nimu liemo ‘Wa ulu kerinele teli ambomo molopili.’ nimbe aku telemo. “Pui.” nimbe makorolemo ambomo pe ye tene yu limo kinie kanu yemo kepe wa ulu kerinele telemola.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Koro ou ⸤Mosisini⸥ anda kolepalimendo ungu mane te pea sirimumu ene pilimele. Kanu ungu manemo i sipe: ‘ “Paa sike tembo.” ningu, ningu panjiku mi lenge ungumu pulue na tangi. Ailimundu “Paa sike tembo.” ningu, ningu panjiku mi lenge mele paa sike aku siku teangi.’* nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nakolo kinié nane ene nimbu sikiru: ‘ ‘Paa sike nikimu.’ ningu piliengi!’ ningu mele aili tenga imbi lelko paa mi na leangi. Mulu koleamo kepe imbi lelko mi na leangi. Aku koleamo Pulu Yemo molopa melema nokolemo koleamo kene aku na teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma koleamo kepe imbi lelko mi na leangila. Akumu Pulu Yemo yunge kimbu mundulimo polomo kanumu. Jerusalleme kepe imbi naa la leangi. Akumu Ye Nomi Kingi Paa Ailimunge* kolea ailimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nunge penge kepe. Akumu nuni penge indi te ‘Kake tepili.’ molo ‘Pombera topili.’ ningu ulu te manda na teni kene pengemo walsiku imbi lelko mi na leai. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ulu te sike teni liemo sumbi siku “Tembo.” nieni. Naa teni liemo “Naa tembo.” nieni. Ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥ muni* ambolemo yambomane mindi ungu sulu teko niliku puku mi lemele.” ⸤nirimu.⸥** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“⸤Ou Mosisini⸥ ungu mane te sirimumu ene pilimele. Kanu ungu manemo i sipe: “Yambo tene yambo tenga mongomo topa akumbe kinie yunge mongomo toko akunjengila. Yambo tene yambo tenga ungú topa langomba kinie yunge ungú toko langonjengila.”* nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nakolo kinié nane ene nimbu sikiru: Ene tepa kenjimbe yambomo anju uluri na teko, ‘We tepa kenjipili.’ niengi. Yambo tene nunge kumbikere ekendonga laruwe tomba kinie topele toko ‘ekendonga kamu laruwe topili.’ nieni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yambo tene ‘Nunge wale pakolimu liembo.’ nimbe kote tenjimbe temba yambomo nunge wale sulu peangamo kepe ‘pea we lipili.’ nieni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","⸤Romo ami⸥ ye tene nu ambolopalie “Nuni na liku taponjiku mako tenga ⸤nanga melema menjeni⸥ pambili.” nimbé kinie mako tenga pea yu we liku taponjiku melema menjiku pani. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Melte si.” nimbe mawa temba yambomo mawa temba melemo we sieni. “Kou te pundu anjiku si.” nimbé yambomo “Molo.” na nieni.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“⸤Ou Mosisini⸥ ungu mane te sirimumu ene pilimele. Kanu ungu manemo i sipe: “Opa lkerayemo konopu monjiku,* opa toumu kanoko keri kanani.”** nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nakolo kinié nane ene nimbu sikiru: Enene enenga opa touma konopu monjiku, ene teko kenjilimele yamboma ‘Pulu Yemone tepa konjipili.’ ningu Pulu Yemo enenga mawa tenjengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Enenga ‘Lapa mulu koleana molemomonga ambolangoma* molamili.’ ningu aku siku teangi. Yuni yambo keri peangama molemelena ‘Ena topili.’ nilimo. Yambo ulu sumbi nilime telemele yamboma kepe yambo ulu sumbi nilime na telemele yamboma kepe enenga pea pali ‘Lo topili.’ nilimola. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Ene konopu monjilimele yamboma mindi konopu monjilimele kinie Pulu Yemone kanopa peanga kanombaye? ⸤Romo gapomano⸥ kou takisi limele yambo ⸤kerime⸥ kepe* anju yando akula telemele kene ⸤ene kanoko keri kanolemele yamboma pea konopu monjingí kinie peanga⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Enene enenga pulu lemo yambomando mindi “Ene manda molemeleye?” nilimele kinie we yambomane telemele mele maniendopa, enene telemele mele olandopaye? Ulsukundu yambomane aku sikula na telemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Akumunge ⸤Mosisini sirimu ungu manema we pilku na teko,⸥ enenga Lapa mulu koleana molemo ye paa sumbi nilimu molemo mele ene aku siku yambo sumbi nilime molangi.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","⸤Yesusini ungu mare nimbe molopalie ungu mare pea nimbendo:⸥* “‘Yambomane ‘Olio yambo paa peangama. Uluma paa tepo konjilimolo.’ ningu kanangi.’ ningu yamboma kanoko molangi enenga ulu peangama paa na teangi. Aku siku tenge kinie yambomane ene kapi ningí. Kanu kapi ningí unguma enenga mele kalolimu lingímunge enenga mulu koleana molemo Lapamone ene mele na kalomba.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“⸤Enenga mulu koleana molemo Lapamone aku siku tenge yamboma mele na kalomba⸥ kene enene yambo koropa pulime kondo kolko ‘Lipu taponjemili.’ ningu kou mone te singíndu ‘Temolo mele yambomane kanangi.’ ningu, ru ningu melte naa siengi. Topele mapele toli yemane* ‘Na yambomane kapi niengi.’ ningu yamboma maku toko Pulu Yemonga ungumu pilili ulkemanga kinie aulkemanga kinie we yambo aisilini mongone kanangi yambo koropama liku taponjilimele. Aku yemane telemele mele enene aku siku na teangi. Nane enendo paa sike nimbu sikiru: Aku telemelemonga ene yambomane kapi nilimele unguma enenga mele kalolimu koronga limele.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Nakolo enene yambo koropama kondo kolko melte singíndu ‘Yambomane paa naa kanangi. Yambo te pea tapu topo andolembolomone kepe naa kanopili, lopi tepo kiyongo nimbu lipu taponjembo.’ niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kanu kinie yambomane naa kanangi, tenge mele yambo te naa ningu sikulie koropa puli yambo te liku taponjingí kinie enenga ⸤mulu koleana molemo⸥ Lapamone lopi teko telemele uluma kanolemomone ene mele kalomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ene Pulu Yemo kinie ungu ningindu topele mapele toli yemane* Pulu Yemo kinie ungu nilimele mele aku siku naa teayo. Kanu topele mapele toli yemane ‘Na ye paa peangamo molio mele yambo aisilini mongone kanoko na kapi niengi.’ ningu yamboma maku toko Pulu Yemonga ungu pilili ulkemanga kinie aulkemanga kinie yamboma kanoko molangi konopu siku angilku Pulu Yemo kinie ungu nilimele. Nane enendo paa sike nimbu sikiru: Aku siku telemelemonga ene enenga mele kalolimu koronga limele kanumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nakolo ene Pulu Yemo kinie ungu ningindu enenga suluminiana sukundu puku nambune sikulie kanu lopi teli koleana enenga ⸤mulu koleana molemo⸥ Lapa naa kanolemele yemo kinie ungu nieyo. ⸤Yu akuna molemo.⸥ Aku tenge kinie enenga ⸤mulu koleana molemo⸥ Lapa lopi teko telemele uluma kanolemomone ene pe mele kalomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“‘Na Pulu Yemo kinie ungu niembo.’ ningulie Isirele talapemonga ulsu molemele yambomane* enenga kuruma molo pulu ye kolo tolime kinie ungu ningindu we ungu aisili nilimele mele aku siku naa teangi. Kanu yambomane ‘Na ungu aisili nimbú kinie pilimbe.’ ningu aku siku nilimele kanumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Enenga ⸤mulu koleana molemo⸥ Lapamo ou mawa naa teangi ene molo tolemo melema yuni pilipe kanolemo kene aku yambomane telemele mele aku siku naa teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ene Pulu Yemo kinie ungu ningindu i siku niengi: “Olionga mulu koleana moleno Lapamo, yambomane ‘Nu imbi ola molopa ye kake teli peangamo moleno.’ ningu molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu ye nomi kingimu molko yamboma nokoni walemo* wendo opili. Nunge ungumu mulu koleana pilku liku telemele mele aku siku ya ma koleana pilku liku teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Olio kinié langi nomolo mele kinié siyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yambomane olio teko kenjíngi kinie siye kolopo ulu te na temulu mele aku sikula olione nu tepo kenjímulu uluma siye kolko olio ulu te na teyo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Olio ‘Ulu tene kondi topili.’ naa ningu ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥ muni* ‘olio na ambolopili.’ ningu yunge kíne wendo liyo. (Nu koleama kinie melemanga pali ye nomi kingimu molko, tondolo olandopamo nu kinie pepa, nu imbi paa olandopa molopa nu kinie pa tondolo tepa tepili alieli molko mindi pulino kene aku sipe tepili.)”** ningu aku siku Pulu Yemo kinie niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yambomane ene teko kenjingí uluma ‘We manie pupili.’ ningu siye kolongi liemo enenga mulu koleana molemo Lapamone enenga ulu pulu kerime ‘Manie pupili.’ nimbe siye kolombala. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nakolo yambomane ene teko kenjingí uluma ‘We manie naa pupili.’ ningu siye naa kolongi liemo enenga ⸤mulu koleana molemo⸥ Lapamone enenga ulu pulu kerime ‘Manie naa pupili.’ nimbe siye naa kolombala.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ene langi naa nongo mi toko we molonge ulu pulumu tengendo topele mapele toli yemane* ‘Na nono nimbu molambo.’ nilimele mele aku siku naa niengi. Kanu yemane ‘Na langi naa nombondo mi topo molio mele yambomane kanangi.’ ningu ene kumbikere teko enenga kumbikerema teko kenjiku molemele. Nane enendo paa sike nimbu sikiru: Kanu yemane aku telemelemonga yambomane ene kapi nilimele unguma enenga mele kalolimu koronga limele.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","“Nakolo ene langi na nongo mi toko we molongendo ‘We yambomane na aku tekero mele naa kanangi. Tarane manjipe kanopili.’ ningu we yambomane kanonge uluma naa teangi. Aku tenge kinie enenga ⸤mulu koleana molemo⸥ Lapa lopi teko telemele uluma kanolemomone ene mele kalomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ya ma koleana mele nosilimelema urelo tepa koka molo lkurinia melemane ongo teko kenjiku, wa lili yema ongo melema wa limele kene ‘⸤ya mana⸥ kamako molopo mele aisili lipu nosemili.’ ni naa niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aku naa tekolie mulu koleana melema urelo naa tepa koka molo lkurinia meltene omba tepa na kenjipe, wa lili yema ongo wa na limele kene ene mulu koleana ⸤pe pungímunge⸥ ‘mele aisili pe limulúma ou lepili.’ ningu ya ma koleana ulu peangama teko molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Enenga nosilimele melema lemo kolea akuna ene konopuni pilku konopu monjiku molemele kene ⸤‘mulu koleana mindi melema lepili.’ ningu molangi.” nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nunge mongomo nunge kangimunge tepe llame mélemo. Aku kene nunge mongo peanga angilimo kinie nu kangi pali pa tepili moleno kinie nu molko konjilino. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nakolo nunge mongomo keri lemba kinie nunge kangi pali sumbulu topili andoni. Kanu kinie nunge kangine pa teli pembamo alowa tepa sumbulu tomba kinie akumu paa kamu sumbulu tomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yambo tene ye aili talonga kongono lipe tere lepa manda naa tenjimbe. Ye aili te konopu keri panjipe, te konopu monjimbe. Molo aku naa temu liemo ye aili tenga ungu nimbéma paa konopu sipe pilipe lipe kongono nimbéma tondolo mundupe tenjipe, te konopu keri panjipe yunge ungu nimbéma ta nimbé. Yambomane Pulu Yemonga kongonomo kinie Kou Monemonga kongonomo kinie liku tere lelko manda na tenjingí.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Akumunge nane ene ⸤tenge mele⸥ nimbu siembo. ‘Kangikundu molopo konjemili.’ ningu konopu aisili liku na mundengi. Langi nongemonga kepe no nongemonga kepe mulu wambale pakongemonga kepe akumanga konopu aisili liku munduku naa molangi. Ene kapola molonge mele ulu pulumu langi kinie mulu wambale kinie mindiye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kerama kaname. Langi te panjikulie nou lemo kinie liku mengo ulkendo puku nosiku naa nolemele nakolo ene yambomanga mulu koleana molemo Lapamone kerama langi silimo. Kerama we mele ene yamboma olandopamonga yuni ene naa nokombaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Enenga yambo tene konopu aisili lipe mundumbemone yu kolomba ena te manda ‘We lepili.’ nimbeye? Manda naa nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ene pakonge melemanga konopu aisili nambemuna liku mundulimeleye? Pillawa sindime mana olemo mele ene naa kanolemeleye? Pillawa sindimene kongono mindili siku na teko, mulu wambale te teko mimi naa telemele ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","nakolo pillawa sindime molemele mele olandopa, ⸤ye nomi kingi⸥ Sollomono* kongono aisili tepalie wale paa peangama pakopa au nirimu mele maniendopa. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Era sindi tolemoma kinié mele molemo, opali mele poroko tepena kalemelema Pulu Yemone aku sipe nokopa konjilimo liemo ene ‘Pulu Yemone olio manda nokombanje.’ ningu laye kolte mindi pilimele yamboma pakonge melemanga yuni manda lipe naa taponjimbeye? Ene paa sike lipe taponjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“⸤Pulu Yemone kerama kinie era sindime kinie aku we melema aku sipe nokolemo⸥ kene ene konopu aisili liku mundukulie ‘Esi, langi te tena lipu nomolonje?’; molo ‘No tena kolopo nomolonje?’; molo ‘Wale pakoli tena lipu pakomolonje?’ ningu pilku naa molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pulu Yemonga yamboma naa molko ulsukundu molemele yambomane aku siku telemele nakolo enenga mulu koleana molemo Lapamone ene yunge yambomanga mele molo tolemoma kanopa molemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","⸤Ene langi nongemanga kinie mulu wambale pakongemanga kinie konopu naa liku munduku,⸥ Pulu Yemo ye nomi kingi molopa yamboma nokolemo* uluma kinie yu kanopa kake telemo kanolemo uluma kinie melema kinie ‘Kumbi lepo teambo.’ konopu lelko molangi. Aku tenge kinie yuni we melema kepe ene simbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yuni aku temba kene ‘Opali nambe tembonje?’ ningu kinié konopu aisili liku na mundengi. Opalimunge langi molo melema aku opali, kiniémonga langi molo melema kinie, opalimunge kinie, liku tere lelko naa piliengi! Enamanga yu mele mele umbunime pelemo pembama kanu enamanga mindi. Kinié umbuni wendo ombáma kinie, opali talu umbuni wendo ombámanga kinie tere lelko konopu liku naa mundengi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","⸤Yesusini ungu mare nimbe molopalie ungu mare pea nimbendo:⸥* “Enene anju yamboma ⸤telemele uluma⸥ apurungí kinie aku sipe ⸤Pulu Yemone⸥ ene telemele mele yando apurumbela.** Enene anju yambomane telemele mele apuruku kanokolie “Teko kenjikimili. Tekemele mele Pulu Yemone kanopa keri kanopili.” ningí mele ⸤Pulu Yemone⸥ aku sipe ene apurumbe. Aku temba kene ‘⸤Pulu Yemone⸥ olio ulu telemoloma naa apurupili.’ ningu enene yamboma telemele uluma naa apurengila.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nuni angenanga mongona nurupulu te lemo kanoleno nakolo nunge mongona unju aili te lemomo naa kanoleno akumu nambemuna telenoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nunge mongona unju aili lemomo naa kanokolie angenando “Ano, nunge mongona nurupulu te lemomo wendo linjembo.” nambe teko nilinoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Topele mapele toli yambomo,* nuni nunge mongona lemo unju ailimu ou wendo likulie pe kanoko konjiku angenanga mongona lemo nurupulumu manda wendo linjini.” ⸤nirimu.⸥** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“‘Pulu Yemonga’ nilimele melema liku owa naa sieme. Nombalie pe topele topa ene nombanje kene aku naa teangi. Enenga mele peangama kongi angilimbena toko naa mundengi. Kimbuni kambilimbenje kene aku naa teangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“⸤Lapa, mulu koleana molemo yemo⸥ melema mawa teko “Si.” niengi. Aku tenge kinie melema sike simbe lingí. ⸤Lapa molemona⸥ melema korangi. Aku tenge kinie melema sike kanoko lingí. Ulke kerepuluna angilku “Sukundu wamili.” niengi. Aku ningí kinie “Sukundu wai.” nimbe nambune tonjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mawa tenge melema sike simbe lingí, koronge melema sike kanoko lingí, “Sukundu wamili.” ningí kinie sike nambune tonjimbe. Aku temba kene aku teai.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Enenga ye te yunge malo ombalie “Tara, pillawa kaloli te nambo si.” nimbé kinie yunge lapane yu kou mulú te simbeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Molo kangomone “Tara, oma te nambo si.” nimbé kinie yunge lapane wambiye te simbeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pe ene konopu keri pepili molemele yambomane aku siku enenga ambolangoma mele peangama silimele liemo enenga Lapa mulu koleana molemomone “Melema si.” ningu mawa tenge yamboma mele peangama paa olandopa na simbeye? ⸤Paa simbemo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Akumunge, ‘Yambomane nu kinie teangi.’ konopu leno mele nuni anju yamboma aku siku teani. ‘Aku teangi.’ nikinu ulumuni Mosisini Pulu Yemonga ungu mane sirimu bokuna torumumanga pulumu kinie, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane bokuna toringi ungumanga pulumu kinie,* lipe tere lepa nilimo kene aku siku anju yando yamboma kinie teko konjengi.”** ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ene pala kerepulu kangamonga paa pangi.* Kolea kerine pulimo kerepulumu paa ailimu, akuna pulimo aulkemo paa anju yando pupe paa pará lemo akuna yambo aisili mindili naa siku we we teko pulimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nakolo alieli konde molopa konjipe mindi puli koleana* pulimo kerepulumu paa kanga, yunge aulkemo paa tengepea teli kangamo lemona yamboma akuna pungindu mindili silimelemonga yambo telu telu ningu mindi aku aulkemo kanokolie pulimele.** Aku telemele kene ene kanu kerepulu kangamonga pangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pulu Yemone ungu umbu tonjilime na pilku we kolo toko yando ningu singí yema onge kene kanoko konjiku molayo. Kongi sipisipi paa taka lelko molemele mele aku siku kanu yamboma ongo molonge nakolo owa takara* paa engelene kolkolie ‘Melte topo namili.’ ningu andoko molemele mele aku siku kanu yambomane ‘Ene mindili nangi. Ene tepo kenjemili.’ ningu molemele.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kanu kolo toli yamboma ongo ulu tengema kanokolie, ‘Ene sike kolo tolime.’ ningu kanonge. ‘Amu namili.’ ningu takeme manda olko toko nolemelkaye? Molo ‘Me te namili.’ ningu silipu manda akuku nolemelkaye? Paa molo. ‘Amu lupe takeme lupela, me lupe silipu lupela.’ ningu kanolemele. ⸤Aku siku mele Pulu Yemone sike ungu umbu tonjilime pilku yamboma sike ningu silimele mele lupe, Pulu Yemone ungu umbu na tonjilime yamboma kolo toko ningu silimele mele lupela ningu kanonge.⸥ Unjuma mongo tolemo kinie kanokolie ‘Ime nomolo lemo. Ime naa nomolo lemo.’ ningu kanoko imbi silimele kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Unju peangamone mongo peangamo tolemo; unju kerimuni mongo kerimu tolemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Unju peangamone mongo keri te manda naa tomba; unju kerimuni mongo peanga te manda naa tombala.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Unju mongo peangama naa tomba unjuma pali peko tokolie tepena kalemele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unjuma mongo tolemo kinie kanokolie, “Imu peanga, imu keri.” ningu apurulimele mele, onge yambo kanumane tenge uluma enene kanokolie yamboma molemele mele sike aku siku kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘Yambomane nando ‘Ailimu.’ nilimele yamboma pali Pulu Yemone nokolemo mulu koleana* suku pungí.’ ningu na pilieyo. Tara mulu koleana molemomonga unguma pilku liku tenge yamboma mindi akuna pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yamboma apurumbe wale kanumu wendo ombá kinie yambo aisilini nando ningindu: “Ailimu, nane nunge imbi lepo* nunge unguma nimbu sirindu kanumu; nunge imbi lepo yambomanga konopuna kuru moloringime “Ongo ulsu pai.” nirindu kanumu; nunge imbi lepo ulu tondolo aisili terindu kanumu.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nakolo aku siku ningí kinie nane enendo nimbundu: “Na enenga imbime paa na pilipu ene kanopo imbi naa silio.* Ene Pulu Yemonga ungumu na pilku liku teringi kene nanga kumbikerena naa ongo anju pai.” nimbú. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Akumunge, i nanga unguma pilku liku tenge yamboma ene ye te molemo mele niembo: Ye pilipe konginjili perimu ye te yuni yunge ulkemo ‘Ingi nimbe angilipili.’ nimbe kou polona ola takorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe lo topa no topa poporome topalie ulkemo paa topa kalalu simbe terimu nakolo ulke simumu kou polona angilirimuna topa tekisi naa tekisipe ingi nimbe we angilirimu. Nanga unguma pilku liku telemele yamboma ene kanu yemo mele molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“I nanga unguma pilku liku na tenge yamboma ene ye te molemo mele niembo: Ye pilipe konginjili naa perimu ye tene yunge ulkemo okiana ola takorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe lo topa no topa poporome topalie ulke kanumu topa kalalu sipe paa bulu balu sirimu. Nanga unguma na pilku liku tenge yamboma ene kanu yemo mele molemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesusini aku unguma nimbe pora sirimu kinie yuni mane sirimu pilku moloringi yambomane yuni ungu mane sirimu mele pilkulie mini wale munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pulu Yemonga ungu manemanga puluma pilku ene mane siringi yemane* we mane siringi mele Yesusini aku sipe mane naa sirimu. Namba lerimu yemane pipili naa kolko tondolo munduku mane siringi mele aku sipe mane sirimuna pilkulie ene mini wale munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusi ma pangine maniendo ombá orumu kinie* yambo aisili liku maku toko yu lombili oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kanu kinie ye te kuru kendi nomba perimumu Yesusi orumuna omba yunge kumbikerena koporongo langopalie yundu nimbendo: “Ailimu, nunge konopumuni na ‘konde pambo.’ konopu lenu liemo nuni na manda teko konde lini.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesusini yemo kini ambolopalie yundu nimbendo: “‘Nu konde pani.’ konopu lekero kene konde pui.” nirimu kinie tamburembu kuru kendimu nomba kelerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kanu kinie Yesusini yundu altopa nimbendo: “Nuni ya ulu tekeromo yambo telurindu kepe paa naa niyo. Sumbi siku puku Pulu Yemo popo tonjili yemo* nunge kangimu liku ora siku, ‘Na altopo kangi peanga lepili molkoro kene.’ ningu Mosisini “Tei.” nimbe panjirimu mele pilku liku tenindu “Pulu Yemo popo toko kalko si.” nirimu mélemo liku Pulu Yemo popo tonjili yemondo “Kalonji.” ningu yu sieni. Pe yambomane nu kanokolie ‘Yu sike kangi peanga lepili molemo.’ ningu piliengi kene nikiru mele isili ou tepui.” nirimu. ⸤“Aku siku teni kinie yambomane nu kanoko keri naa kanonge, nu altoko we yamboma molemelena manda teluna puku moloni.” nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesusi Kapeniame taonona sukundu purumu kinie Romo yambomanga ami ye wane anderete nokorumu ye te yu orumuna omba yundu mawa tepalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ailimu, nanga kendemande yemo kimbu ki kolopa pora sipe mindili nomba perepa ulkena lepili okoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusini yundu “Ombo tepo konde limbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","⸤Aku nirimu kinie pilipelie⸥ ami ye wane anderete nokorumu yemone yundu pundu topa nimbendo: “Ailimu, na ye kerimu mele molio, nu nanga ulkena oni kinie kapola naa temba. Na ye tene kepe nokopa molemo, yunge ungumu pilipu lipu telio. Nane kepe ami ye mare nokopo molio. Kanu yemanga tendo “Pui.” nilio kinie yu pulimo. Molo tendo “Oi.” nilio kinie yu olemo. Molo nanga kongono tenjili kendemande yambo tendo “I siku tei.” nilio kinie yu aku sipe telemo kanumu. Aku sipela, nuni ungu te we nini kinie nanga kendemande yemo konde pumbe kene nuni we ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusini yu nirimu mele pilipelie yu konopu aisili lipe mundupelie yu lombili oringi yambomando nimbendo: “Nane enendo paa sike nimbu sikirumu: I Isirele yambomanga talapena ulsu mololi yemone na ungumuni mindi manda tembo mele nimbe tondolo mundupe pilimo mele koleamanga pali, Isirele koleana sukundu kepe, yambo telurini kepe aku siku ningu piliringi mele paa na kanorundu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nane enendo paa sike nimbu sikirumu: Ena mundi olemo koleamanga kinie ena pulimo koleamanga kinie yambo aisili wendo ongo Pulu Yemo ye nomi kingimu molopa nokolemo* mulu koleana sukundu Eporayamo kinie Aisake kinie Jekopo kinie pea ongo langi nongo molonge.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nakolo Pulu Yemone ‘yunge yamboma’ nimbe mako torumu ⸤Isirele⸥ yamboma yu nokopa molemo koleana puku molemelka yamboma yuni topa makoropa sumbulu toline mundumbe. Kanuna paa mindili nongolie kola teko pereko molonge.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aku nimbelie yuni ami ye wane anderete nokorumu yemondo nimbendo: “Nane nu ‘manda tenjimbe’ konopu lenu mele* tenjindu kene pui.” nirimu. Kanu kinie yuni aku sipe nirimu enamonga kendemande yemo yu kuru topa kelepa konde pupe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","⸤Kanu kinie⸥ Yesusi Pitanga ulkena sukundu ombalie Pitanga kolepa ambomo kuru topa kangi norumuna aniembo lerimu kanopalie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","yunge kimu ambolorumu kinie kangi nomba kelerimu kinie ambomo ola angilipe wendo ombalie Yesusi langi sipe yu nokorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pe kolea ipu lemba terimu kinie konopuna kuru molorumu yambo aisili Yesusi molorumuna mengo oringi kinie yuni kurumando “Ongo wendo pai.” nirimu kinie ongo wendo puringi. Kuru torumu yamboma pali tepa konde lirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aku sipe terimumunge koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye* Aisayane ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Aisayane nimbendo: “Yuni yuyu olio kuru torumuma makoropa, olio aniembo lerimulu kuruma lipe ulsu mundurumu.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","⸤Walse⸥* Yesusi ⸤nomu Gallilli kélona molopili⸥ yambo aisili liku maku toko yu liku makaye teko moloringi kanopalie nirimumuni, ⸤lombili andolimendo⸥ “Nomuna nekendo pamili wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","⸤Nakolo ou naa pupe we angilipili⸥ Pulu Yemonga ungu manemanga puluma pilipe mane sirimu ye te* yu angilirimuna omba yundu nimbendo: “Ungu Mane Silimu, nu puni koleamanga pali nu lombili ombó.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","⸤Aku nirimu kinie⸥ Yesusini yundu nimbendo: “Pílie! Owa takarama ulke pelemelemanga pelemele; kerama enenga mi takolemelemanga pelemele, nakolo Manie Omba Mana Ye Au Lerimu Yemonga pelemo kolea te naa lemo ⸤kene, nu ‘Yu lombili pupulie kapola naa molombo.’ ningu pilkulie na lombili wani. We naa wani.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kanu kinie yu lombili andorumu ye tene* yundu nimbendo: “Ailimu, nu kamu lombili wambo mangali ou pupu nanga lapamo ⸤kinie pea molambo. Pe yu kolomba kinie⸥ ono tepolie nu lombili ombó.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nakolo Yesusini yundu nimbendo: “⸤Nanga ungumu naa pilku⸥ yambo kololi ⸤none teli⸥ yambomane yambo kolongema ono teangi. Nakolo nu na lombili oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aku nimbelie ⸤nomu Gallilli nekendo pumbendo⸥ nona andoli sipi tenga sukundu purumu kinie yu lombili andolime yu lombili sukundu puringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kanu kinie ⸤nomuna pungí puringi kinie⸥ poporome aili te nomuna torumu. Aku terimuna nomumu apisipe ola ombalie sipimu lipe aki tomba terimu nakolo Yesusi we uru perimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanu kinie enene yu uru perimuna puku toko makinjikulie ningindu: “Ailimu, olio liku taponjiyo. Olio no wangokomolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yu ⸤makilipelie⸥ enendo nimbendo: “‘Pulu Yemone olio nokomba.’ ningu konopu tondolo naa pekemo yema, ene nambemuna mini wale mundukumiliye?” nirimu. Aku nimbelie ola molopa poporomemo kinie nomumu kinie iri torumu. Kanu kinie poporomemo topa kelepa nomumu lope naa tepa paa we lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","⸤Yuni terimu mele kanokolie⸥ yemane mini wale mundukulie ningindu: “Apa! I yemo nambolka yerenje? Poporomemone kepe nomumuni kepe yunge ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kanu kinie yu ⸤lombili andolime kinie pea⸥ nomu nekendo pupe kolea Gadara puringi kinie kanu kolea Gadara ye talo, konopuna kuru molorumu yetolo, yambo ono koleana wendo ongolo yu molorumuna oringili. Elte paa enge ningulu yamboma tongele teringilimunge we yamboma elte peringili koleana ‘Eltene ene tongele.’ ningu aulkena ongo naa puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesusi kanokololie tondolo munduku walsikululie ningilindu: “Pulu Yemonga Malo, olio kinie ulu nambolka uluri tenindu onuye? Olio mongo lipe simbe walemo ou wendo naa opili nuni isili ou olio mindili liku sini okonoye?” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akuna anjupe kolea tenga umbu kongi aisili ímu nongo moloringi ⸤kanokolie⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kurumane Yesusi mawa tekolie ningindu: “Olio toko makorokolie ‘ne kongimenga konopuna molopangi.’ ni.” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yuni enendo nimbendo: “Kapola, akuna pangi.” nirimu kanu kinie ⸤kuruma⸥ kanu yetolonga konopuna wendo ongolie kongi akuna moloringimenga konopuna puku moloringi kinie kanu kongime pali kekelepa toko lkisiku puku kopona pukue toko nomuna suku puku no wangoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","⸤Ulu akuma wendo orumu kinie kanokolie⸥ kongi tapu teko moloringi yema talopa lelko pukulie niringimuni, taonona puku akuna moloringi yamboma enenga kongime terimu mele kepe kuruma konopuna moloringi yetolo terimu mele kepe temane toko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Niringi mele pilkulie taonona moloringi yamboma pali Yesusi molorumuna ongo kanokolie yu mawa tekolie ningindu: “Olionga koleana naa mololi kelko pui.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanu kinie Yesusi altopa nona andoli sipi tenga sukundu pupelie nirimumuni, nomu ⸤Gallilli⸥ yakondo omba yunge kolea ⸤Kapeniame taono⸥ orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yu ⸤Kapeniame kelepa⸥ omba molorumuna ye marene kimbu ki kolopa pora sirimu ye te taropola teko mengo oringi. Enene ‘Yesusini i yemo manda tepa konde limbe.’ ningu pilkulie yu mengo oringi, Yesusini kanopa pilipelie kimbu ki kolopa pora sirimu yemondo nimbendo: “Nanga kangomo, nunge konopu wayongo nipili. Nunge konopuna ulu pulu keri terinu pelemoma manie pupili, siye kolkoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aku nirimu kinie pilkulie Pulu Yemonga ungu manemanga puluma pilku mane siringi ye marene* eneno konopuni pilkulie, ‘I yemone Pulu Yemo marake tekemo.’ ningu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ene konopu leringi mele Yesusini pilipelie nimbendo: “Ene nambemuna konopu lelko kenjikimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","I yemondo “Nunge ulu pulu kerime manie pupili, siye kolkoro.” nimbú kinie ene ulu te naa kanokolie ‘We we tepa nikimu.’ konopu lengeye? Molo “Ola angilku nunge kunungumu liku mengo kimbu kongono teko andoi.” nimbú kinie yu ola angilimbene naa angilimbenje mona lemba manda kanokolie ‘Aku sipe mindili sipe nikimunje?’ konopu lengeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nakolo ‘ ‘Manie Omba Mana Ye Au Lerimu Yemo* tondolo pelemomone ya ma koleana yambomanga ulu pulu kerime “Manie pupili, siye kolkoro.” manda nimbé.’ ningu piliengi!’ nimbu aku sipu nindu.” nirimu. Aku nimbelie kimbu ki kolopa pora sili yemondo nimbendo: “Nu ola angilku nunge kunungumu liku mengo ulkendo pui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aku nirimu kinie yemo ola angilipe ulkendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yambo aisili akuna maku toko moloringimene yu aku terimu kanoko mini wale mundukulie, mana yamboma ulu tondolo aku mele tenge tondolomo sirimu Pulu Yemonga imbi ambolko ola linjiku kapi niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kanu kinie Yesusi pumbe pupelie nirimumuni, kou takisi lipe molorumu ye te, yunge imbi Mateyu, kanopalie yundu “Na kinie pea pambili lombili oi.” nirimu. Kanu kinie Mateyu yu ola angilipe yu lombili purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe Yesusi Mateyunge ulkena langi nomba molorumu kinie kou takisi lili yema kinie, ⸤Juda ye ailimene⸥ “ulu pulu kerime teli ye” ⸤niringi⸥ wema kinie aisili ongo Yesusi kinie yu lombili andoli yema kinie* ene pea manie molko langi noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","⸤Ene aku siku teluna langi nongo moloringine⸥ Parisi yemane kanokolie yu lombili andolimendo walsiku pilkulie ningindu: “Enenga ungu mane sili yemo kou takisi lili yema kinie ulu pulu kerime teli ye wema kinie ene kinie yu nambemuna langi pea nokomeleye?” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aku siku niringi mele pilipelie Yesusini enendo nimbendo: “Kuru naa tolemo yamboma doketana naa pulimele. Kuru tolemo yamboma mindi doketana pulimele kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nane “Yambo sumbi nilime na molombona wangi.” nimbundu ma koleana naa orundu.* ‘Ulu pulu keri teli yamboma na molombona wangi.’ nimbundu orundu. Ulu pulu keri teli yamboma lipu taponjimbundu orundu kene** ene puku Pulu Yemonga bokuna molemo ungu tenga pulumu puku pilipayo. Pulu Yemone nimbendo: “‘Na melema popo toko kalko siengi.’ nimbu pilipu naa molio. ‘Ene yambo lupema konopu monjiku kondo kolangi.’ nimbu pilipu mindi molio.”*** nirimu kanumu.” nimbe Yesusini nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pe ⸤No Linjili⸥ Jono lombili andoringi yema Yesusi molorumuna ongolie yundu walsiku pilkulie ningindu: “Olio kinie Parisi yema kinie olio alieli langi mi topo naa nolemolo* nakolo nu lombili andolime aku siku naa telemele akumu nambemuna na telemeleye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","⸤Aku siku niringi kinie pilipelie⸥ Yesusini pundu topa enendo ⸤ungu iku te topa yu kinie ulu te wendo ombá mele nimbelie⸥ nimbendo: “Ambo limbe ye te yunge pulu lemo yema kinie molemo kinie ene konopu sikulie “Kola tepo langi naa namili.” manda ningíye? Manda na ningí. Pe mindi, ambo limbe yemo ene molongena ongo wendo liku ⸤tonge⸥ kinie kanu walemanga sike ⸤konopu keri panjiku⸥ langi naa nongendo mi tonge. ⸤Isili ou molo.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mulu wambale ou te sungu nilimo kinie olione mulu wambale paa konde tenga te kopisipu lipu, sungu nilimomonga naa topo tambululimolo kanumu. Yambo tene aku sipe topa tambulkenje kanu mulu wambalemo nona panjilke kinie mulu wambale konde kopisilimu kanga lepa lli nimbelie mulu wambale oumu kelepa kamu aili tepa sungu nilke.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Kongi meme kalumuni teli mingi ou tenga no waene konde naa la kolemolo kanumu. Yambo tene mingi ou tenga no waene konde te kolkanje kanu no waenemo mingine sukundu pepalie pe akolka kinie kanu mingi oumu naa akopa sungu nilke. Kanu kinie nomo kepe mingimu kepe kamu keri lelka. Akumunge no waene konde kongi meme kalumuni teli mingi kondena mindi kolemolo kanumu. ⸤Pe nomo akolemo kinie kalumuni teli mingi kondemo anju yando pupe sungu naa nilimomonga⸥ nomo kinie mingi kondemo pea kapola lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusini Jononga lombili andoli yemando ungu nimbe molopili ⸤Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke te⸥ nokorumu ye te Yesusi molorumuna omba yunge kumbikerena koporongo langopa yundu nimbendo: “Nanga ambolamo kinié isili kolopa pora sikimu. Nakolo nu ongo yu kimuni amboloni kinie yu konde pumbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aku nirimu kinie Yesusi ola angilipe yu lombili purumu. Yesusi lombili andolime pea puringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kanu kinie ambo te molorumu kanumunge pena perimu walema pora na nirimu. Yu pena mindi pepili ponie engaki rurepo omba purumu. Kanu ambomone ‘Yunge wale pakolimu mindi ambolondu liemo na konde pumbu.’ nimbe pilipelie Yesusi pumbe purumu kinie bulkundu omba, yunge wale pakolimunge pundumu ambolorumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ambolorumu kinie Yesusi topele topa yu kanopalie nimbendo: “Ambolamo, nu konopu wayongo nipili moloyo. ‘Nu manda tepa konde limbe.’ konopu lenu kanu ulumuni nu konde pukunu.” nirimu. Kanu enamonga ambomo konde pupelie we molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kanu kinie Yesusi ⸤Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkemo⸥ nokoli yemonga ulkena sukundu ombalie yambo aisili molko kondo kolko, kolape mingi langoko, kola aili teko teko moloringi kanopalie yuni nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Ene anju pame! Ambolamo kolou na kolomu. We uru mindi pelemo.” nirimu.* Aku nirimu kinie ⸤ambola kanumu sike kolopa pora sirimu pilkulie yuni “We uru pelemo.” nirimumunge⸥ yu ungu taka tonjiku tae tenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kanu kinie yambo maku toko moloringime pulu sipe pena pena tepalie ⸤ambola onomo lerimu⸥ suluminiana pupe yunge kimu ambolorumu kinie ambolamo ola molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","I ulu tondolo terimumunge temanemo kanu koleamonga sukundu lerimu koleamanga pali anju anju purumu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesusi kanu koleamo mundupe kelepa pumbe purumu kinie mongo keri lerimu ye talo yu lombili ongo walsikululie ningilindu: “Ye nomi kingi Depisini kalopa lirimu yemo,* nu olto kondo koloi.” ningu wale aisili niliku oringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yu ulke tenga sukundu purumu kinie mongo keri leli yetolo yu molorumuna lombili oringili kinie yuni elte walsipelie: “Elte na mawa tekembele mele ‘Manda temba.’ konopu lekembele* molo moloye?” nirimu kinie eltene ningilindu: “Ailimu, ‘Manda teni.’ konopu lekembolo.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kanu kinie yuni eltenga mongotolonga ambolopalie nimbendo: “Nane ‘manda temba.’ konopu lekembele mele aku sipe wendo opili.” nirimu ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","kinie eltenga mongotolo peanga lerimu, melema altoko kanoringili. Yesusini elte tondolo mundupe mane sipelie nimbendo: “Eltene i ulu wendo okomomo yambo teluri kepe paa naa piliengi, naa ningu siele!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nakolo elte pena pukulu Yesusini terimu mele aku koleamonga sukundu lerimu koleamanga pali temane toko silikulu andoringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kanu yetolo Yesusi munduku kelkolo pungilí puringili kinie ye te konopuna kuru molorumumunge ungu te naa nirimu ye te Yesusi molorumuna mengo oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesusini yemonga konopuna molorumu kuru kanumu topa makororumu kinie ungu naa nirimu ye kanumuni ungu nirimuna yambo maku toko moloringimene kanokolie konopu aisili liku mundukulie ningindu: “Ou Isirele koleana sukundu i sipe ulu te wendo na orumu kanumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nakolo Parisi yemane* ningindu: “Kurumanga nomimuni yu lipe taponjilimona yuni kuruma topa makorolemo.” niringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesusi kolea ailimenga kinie, kolea kangamanga kinie pelipe andopalie nirimumuni, Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkemanga pupe ungu mane sipe; Pulu Yemo ye nomi kingi molopa yamboma nokolemo* nokomba ungu pulumunge temane peangama topa sipe; kuru lupe lupema torumu yamboma tepa konde lirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yambo paa aisili yu molorumuna ongo liku maku toko moloringime kanopalie ene umbu konopu naa pepili andoko, kangime enge naa perimuna ene eneno manda liku na taponjiku molkolie ene kongi sipisipime enenga tapu ye te na molorumumunge we moloringi mele ene aku siku moloringine* kanopalie ene paa kondo kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanu kinie ⸤yambo aisili ‘Yuni lipe taponjipili.’ ningu moloringine kanopalie⸥ lombili andolimendo nimbendo: “Langi pulumu poniena nou lemo nakolo kongono ye aisili molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","⸤Na ye telumu mindi i kongonomo tekero kene⸥ Langi Pulu Yemo mawa tekolie yuni “Langi nou lelime lingí kongono tenge yamboma yunge poniena lipe mundupili.” niei.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesusini yu lombili andoli ye engaki rurepondo* “Yando wai.” nimbelie enene yambomanga konopuna kuru molemoma “Ongo wendo pai.” ningu toko makoronge tondolomo sipelie, yambo kuru tolime kinie kangi pange mange telime kinie ‘Konde pangi.’ ningí nambamo sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yuni “Nanga kongonomo tenjipai.” nimbe lipe mundurumu ye* engaki rureponga imbime i sipe: Ou Saimono, yunge imbi te ‘Pita’ niringila, yu keme yunge angenu Enderu keme, Jeperinge malo Jemisi keme Jemisi yunge angenu Jono keme, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pillipu keme Batollomiu keme, Tomasi keme kou takisi lirimu ye Mateyu keme, Allapiasinge malo Jemisi keme Tadiasi keme, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Olio Juda yamboma oliolio gapomano molamili.” niringi talape ye Saimono keme Yesusi pe lipe opa touma sirimu ye Judasi Isikeriote* keme, akuma. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesusini aku ye engaki rurepo lipe mundupelie enendo nimbendo: “Yambo lupema molemelena naa la pangi. Sameria yambomanga* taono tenga naa la pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isirele yamboma mindi enenga kongi sipisipi pena lou lelko pelemele mele* aku siku molemele yamboma molemelena mindi pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ene molemelena pungí pukulie, enendo “Pulu Yemo ye nomi kingi molopa yamboma nokomba walemo* nondopa wendo ombá tekemo.” niliku pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Kuru tomba yamboma teko konde liku, kolko lenge yamboma ‘Lomboroko ola molai.’ ningu, kuru laká nombá yamboma* ‘Umbu kangi angilipili.’ ningu, kuru konopuna molopili molonge yamboma ‘Konopuna naa molangi, ongo wendo pangi.’ ningu teliku pangi. I kongonomo tengemonga tondolomo kou te molo meltene topo toko naa likimili kene anju yamboma aku siku liku taponjikulie ningímuni, ‘Kou te liemili.’ ningu naa la teangi. We teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Pungindu kou gollo mare molo kou sillipa mare molo kou kopa mare kakona panjiku mengo pu naa pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mele wale kepe wale pakoli talo kepe kimbu su kepe apulu mingi kepe naa mengo we pangi. Yambo kongono tenjilimomo kongono tenjilimo yambomone langi simbe kinie papu kene* melte mei naa meangi. We pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pe kolea aili tenga molo kolea kanga tenga suku pukulie ningímuni, yamboma walsiku pilkulie “Ye nae ye peanga te molemomonga oliondo “Pea peamili wai.” nimbeye?” niengi. Kanu kinie te ningu singí kinie pilku yu kanoko lenjikulie kanu yemonga ulkena puku yu kinie mindi pea peko molkolie pe aku koleamo munduku kelko pangi. ⸤Ulke pinie pinie na andoko ulke teluringe mindi langi nongo peangi.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","⸤Kolea tenga puku ye peanga te liku ora singí kinie kanoko lenjiku⸥ yunge ulkena sukundu pukulie ningímuni, ulke pulu yambomando “Ene konopu peanga pepili molai.” nieyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kanu kinie kanu yambomane “Pea peamili sukundu wai.” níngi liemo, enenga ungu peanga ningí kanumu kanu yamboma kinie pepili. Nakolo kanu yambomane konopu peanga naa panjiku, “Pea peamili wai.” na níngi liemo ungu peanga ou sukundu pukulie ningí kanumu “Ene kinie naa pepili.” ningu, kelko mengo ⸤ene munduku kelko yando wangi⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Yambo tene enendo “Pea peamili wai.” ni naa ningu enene ungu ningíme pilku naa língi liemo kanu ulkemo molo kanu taonona yambo kerime munduku kelko pungindu ⸤kanu koleana yamboma ‘Kamu molko kenjengi! Pulu Yemone ene lipe naa taponjimbe mele piliengi.’ ningu⸥ enenga kimbuna kanu koleamanga ma angilimbe mamo kulu toko pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nane ene paa sike nimbu sikirumu: Kote walemo wendo ombá kinie kolea aili Sodomo kinie Gomoratolo eltenga yamboma ⸤ou ulu pulu keri aisili sike teringi* nakolo⸥ eltenga kote kanga mele pemba. Nakolo i yambo enendo “Sukundu wai.” ni naa ningu enenga ungu pilku na lingí yamboma kote walemo wendo ombá kinie enenga kote ailimu pemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ene lipu mundukuru yema ene sipisipi melema, yambo owa takara aili kerimene* sipisipi** topa nolemo mele yamboma molemelena ene lipu mundukuru. ⸤Nanga ungumu andoko ningu singí kinie pilku keri pilkulie yambomane ene mindili liku singí.⸥ Yamboma owa takara mele aku siku molemele kene kongi ka wambiyema pilipe konginjilimu paa pelemona uluma tembando mimi sipe pilipe telemo mele ene aku wambiyema mele molko, kera waembono molemo mele molangi. ⸤Aku keramone melema mindili sipe tepa kenjimbe ulu pulu te naa pelemo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Yamboma mimi siku kanangi. Enene ⸤‘Na lombili andoli yamboma mindili nongo, kolangi.’ ningu,⸥ ene ⸤mare liku ambolkolie⸥ kanjollomanga makumanga mengo puku kote tenjiku, ene ⸤mare⸥ Juda yamboma maku toko Pulu Yemonga ungumu pilimele ulkemanga liku mengo puku kopene tongela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ene nanga yamboma molongemonga ene ⸤mare ka siku⸥ yambo lupemanga gapomano ye ailime kinie ye nomi kingime kinie molongena ⸤kote tenjingindu⸥ mengo pungíla. Aku siku tenge kene ene eneno kanoko konjiku molayo. Nakolo kote tenjingí kinie kotena angilkulie kanu yema kinie kanu yema nokonge ye nomime kinie enene ‘Nanga ungumu piliengi!’ ningu ene ningu singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nakolo ene ka siku kote tenjingí kinie ‘Kotena nambolka unguri nimulúnje? Olio ungu te walsiku pilingí kinie nambolka unguri pundu topo nimulúnje?’ ningu mini wale naa mundengi. Aku tenge enamonga ene ungu ningí mele pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ene ungu ningíme eneno pilkulie naa ningí. Enenga ⸤mulu koleana molemo⸥ Lapanga Minimu enenga kerena molopalie nimbe simbe unguma enene anju ningí kene konopu kimbu naa siku, pilingí mele niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“⸤Aku walemanga⸥ angenuni yunge angenu ⸤nanga yambo molombamonga⸥ ‘Kolopili toko konjengi.’ nimbe kote tenjimbe. Lapane yunge ambolangoma akula temba. Ambolangomane kepe enenga anupili lapali kinie mumindili kolko kotena mengo puku “Toko konjengi.” ningíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nanga yamboma molongemonga yambomane pali ene kinie konopu keri panjingí, nakolo na munduku naa kelko walema pora naa nipili tondolo munduku molonge yamboma ⸤Pulu Yemone⸥ lipe taponjipe ‘Mindili nonge koleana naa puku pea molopo konjipu mindi pamili.’ nimbé.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kolea tenga yambomane ‘ene mindili nangi.’ ningu teko kenjingí kinie kolea tenga kowa pangi. Nane enendo paa sike nikirumu: Ene kolea Isirele sukundu koleamanga pali andoko nanga kongonomo teko pora naa sinjengi Manie Omba Mana Ye Au Lerimu Yemo* ⸤kelepa yando⸥ ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mane sili ye te lombili puku unguma pilimele yamboma ‘Enenga mane silimu maniendopa, ene olandopa.’ manda naa ningí. Kendemande yambo tene ‘yunge nokoli yemo maniendopa, yu olandopa.’ manda naa la nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lombili pupe unguma pilimo yambomo kinie yunge ungu mane silimo yemo kinie kapola kapola molembele akumu manda. Kendemande yambomo kinie yunge nokoli yemo kinie kapola kapola molembele akumu mandala. Ulke pulu yemonga ungu na pilimele yambomane yu kinie mumindili kolko iri tongendo ⸤kurumanga nomi Setenenga imbi manda lelko⸥ “Yu Belsipuli” ningu imbi lemele kanumu.* Pe kinié ulke pulu yemondo aku siku níngi liemo yunge ulkena pelemele yambomando pali paa aili teko olandopa ungu kerime ningíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“⸤Nanga opa toumane na teko kenjilimele mele ene na lombili andoli yema sike teko kenjingíla⸥ akumunge ene kanu yamboma pipili naa kolayo. Aki tolemo ulumanga telu kepe pe aki naa topa pali mona lemba. Lopi telemo ulumanga telu kepe pe lopi naa temba. Kanu uluma kinie unguma pali yambomane pali pilingí kene pipili naa kolangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nane enendo sumbulu toline nilio unguma pa teline nieyo. Ungu ólo toko ningí eneno komuna pilingí unguma ulke imuna ola angilku ru ningu niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kangimu mindi toko konjikulie minimu manda toko naa konjingí yamboma pipili naa kolayo. ⸤Pulu Yemo mindi pipili kolayo⸥. Yuni kangimu kinie minimu kinie peatolo tepe koleana manda topa konjimbe kene yu mindi pipili kolai.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Kera kalsindipele paa kangamo molemo, topo toko lingíndu kera talo pea tene toya mele mindi pulimo kanumu. Nakolo te kolopa we manie naa pulimo. Kanu kerama na lombili andoli yambomanga ⸤mulu koleana molemo⸥ Lapamone kanolemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ene ⸤na lombili andolime⸥, enenga penge indime kepe yuni koronga telu telu nimbe pali kambu torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Enenga ⸤mulu koleana molemo⸥ Lapamone aku sipe ene molemele mele kanopa mololipe pulimo kene ⸤‘Yambomane olio teko kenjingí.’ ningu⸥ pipili naa kolayo. Kera kalsindipele yu kou paa wallotolo mele pulimo nakolo kanu keramo Pulu Yemone kanopa molemo. Ene yamboma paa olandopa ailime kanopalie ene paa nokopa konjipe molomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yambo tene yambomanga kumbikerena ola angilipe “Na Yesusinge yambomo molio.” nimbé kinie nane Tara mulu koleana molemomonga kumbikerena ola angilipu “Kanu yambomo nanga yambomo.” nimbula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nakolo yambomanga kumbikerena “Yesusi yu naeye? Yu na naa pilkiru.” aku mele nimbé yambomo yu nane Tara mulu koleana molemomonga kumbikerena “Aku yambomo yu naeye? Yu na naa pilkiru.” nimbúla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“‘ ‘Ya mana yamboma opa naa teko teluna kapola kapola molangi.’ nimbu orundu.’ konopu naa leangi. Ene yamboma ‘Taka lelko molko kapola kapola molangi.’ nimbundu naa orundu. ‘Mumindili kolko opa teangi.’ nimbundu orundu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","‘Yambomane teangi.’ nimbundu orundu mele i sipe: “Ye tene yunge lapa kinie opa tepili, lemenu tene yunge anumu kinie opa tepili, malo tenga menuni yunge bamu kinie opa tepili. Ulke teluna pelemele yamboma opa tou molonge.”* ‘Aku teangi.’ nimbundu orundu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yambo tene na olandopa konopu naa monjipe, yunge lapa molo anumu olandopa konopu monjimbe yambomo ‘Nanga yambomo molopili.’ nimbú kapola naa temba. Yambo tene na olandopa konopu naa monjipe, yunge malo molo lemenu olandopa konopu monjimbe yambomo ‘Nanga yambomo molopili.’ nimbú kapola naa temba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yambo tene ‘Yu lombili pambo.’ nimbelie yamboma unju perana angilku mindili nongo kolemele mele yuni unju pera mele gomo lembando ‘Na yu lombili pumbundu mindili nondu liemo papula; kolondu liemo papula.’ naa nimu liemo ‘Nanga yambomo molopili.’ nimbú kapola naa temba.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yambo te ya ma koleana ‘Na molopo konjipu, nondopo naa kolambo.’ nimbe pilimo yambomo kolopalie kolea kerine mindili nomba molopa mindi pumbe. Nakolo yambo te na lombili andopa nanga kongonomo tenjimbendo ‘Ya mana mindili nombo molombo kinie mandala, kolombo kinie mandala.’ nimbé yambomo konde molopa konjipe mindi pumbe.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ene kolea tenga pungí kinie yambo tene ‘Pea molamili wai.’ nimbe lipe taponjilimo yambomo na pea aku sipe lipe taponjilimo. Na ‘Pea molambili oi.’ nilimo yambomone na “Ma koleana pui.” nimbe lipe mundurumu yemo ‘Pea molambili oi.’ nilimola.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yambo tene Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo yambo te olemo kinie ‘Yu Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo yambo te* kene’ nimbe pilipelie “Pea molambili oi.” nimbe lipe taponjilimo yambomo Pulu Yemone yunge ungumu nimbe silimo yambomo mele kalomba mele kanu lipe taponjilimo yambomo kepe telu sipe mele kalombala. Yambo tene Pulu Yemonga ungumu pilipe lipe konopu sumbi nipili molemo yambo te olemo kinie ‘Yu Pulu Yemonga ungumu pilipe lipe konopu sumbi nipili molemo yambo te kene.’ nimbe pilipelie ‘Pea molambili oi.’ nimbe lipe taponjilimo yambomo ⸤Pulu Yemone⸥ kanu yambo sumbi nilimu mele kalomba kinie yu lipe taponjilimo yambomo kepe telu sipe mele kalombala. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yambo tene ene nanga lombili andoli yambo imbi naa mololi yambo te* kanopa ‘yu nanga lombili andoli yambo te kene’ nimbe kanopalie yu lipe taponjipe we no kepe kolopa simu liemo nane ene paa sike nimbu sikirumu, kanu yambomo paa sike mele kalolimu limbe.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusini yu lombili andoli ye rurepondo yunge kongono tenjingí mele mane sipe pora sipelie nirimumuni,* yu aku koleamo mundupe kelepa kolea Gallilli disiriki taonomanga andopa mane sipe ⸤Pulu Yemonga⸥ ungumu nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","⸤Pulu Yemone “Nanga yamboma nokopa konjimbe ye te lipu mundumbu.” nimbe ou mako torumu ye nomi⸥ Kirasimuni* ulu tondoloma terimumunge Jono ka ulkena pepa pilipelie nirimumuni, “Yesusindu i siku i siku walsiku pilinjengi!” nimbe yu lombili andoli mare Yesusi molorumuna lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kanu yema Yesusi molorumuna ongo yu walsiku pilinjikulie ningindu: “Pulu Yemone olio nokopa konjimbe yere “Lipu mundumbu.” nimbe, nimbe panjirimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo te lupe ombámo nokopo molamiliye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusini enendo pundu topa nimbendo: “Enene ya kanokomele mele kepe pilkimili mele kepe puku Jono ningu sipayo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mongo keri leli yamboma mongone kanoko, kimbu keri leli yamboma kapola andoko, kuru laká nolime* umbu kangi angilipe, komu silime komuni pilku, kolopa lelime ola molemele kepe, koropa pulime temane peangamo topo silio pilimelela kanumu.** Aku siku Jono ningu sieyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na kanokolie ‘Yu sike kanu yemo molemo.’ ningu tondolo munduku pilkulie, altoko konopu talo naa panjiku molonge yamboma ene malo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jono lombili andolime pungí puringi kinie Yesusini kelepa yambo aisili maku toko moloringimendo Jonondo nimbendo: “⸤Kolea ku leline Jono no linjipe molorumu kinie⸥ ene kanu kolea ku leline nambolka kanonge puringiye? Lkepanie mele poporomene lope lope tenjipe molorumu te kanonge puringiye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","⸤Molo kanumu. Alieli kanolemele mele kanonge naa puringi liemo⸥ ulu nambolkare kanongendo puringiye? Ye te mulu wambale paa peangama pakopa molorumuna kanonge puringiye? Akumu molola. Yambo mulu wambale paa peangama pakolemelema ye nomi kingimenga ulkena manjiku molemele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“⸤Aku sili te kanonge na puringi liemo⸥ Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe sili ye te* kanonge puringiye? Akumu sike nakolo nane enendo nimbu sikiru: Jono yu sike Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe sili ye te nakolo yu Pulu Yemone ungu umbu tonjirimuma pilipe nimbe sili ye we te molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yuni Pulu Yemone ou “Lipu mundumbu.” nirimu yemonga* aulkemo tepa mimi temu kanumu.** Kanu yemondo Pulu Yemonga bokuna sukundu molemo ungu te i sipe: ‘⸤Pulu Yemone yunge Malondo nimbendo:⸥ “Pilieyo. Nanga ungu te ninjimbe yemo nane nu puni aulkena yu kumbi lepo lipu mundukuru. Yuni nunge aulkemo akisinjimbe.” nirimu.’*** kanu ungumu bokuna molemo.**** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nane enendo paa sike nimbu sikirumu: Ou mana moloringi yambomanga te No Linjili Jono kinie manda molo. Jono olandopa mele. Nakolo kinié wale kondemo wendo okomo. Kanu walemo Pulu Yemo ye nomi kingi molopa nokolemo* yambomanga te paa imbi naa molopa paa koropa puli yambomo olandopa; Jono yu maniendopa. ⸤Ou moloringi yamboma manie mele; kinié na ‘Sike.’ ningu tondolo munduku pilingímunge konopu peanga pemba yamboma olandopa.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Jono ou mana na omba molopili ungu manema pelemo boku Mosisini torumuma kinie, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siku bokuna toringi bokuma kinie, aku bokumane* Pulu Yemonga unguma ningu siku, Jono kinie Pulu Yemone “Ene nokomba ye nomi te lipu mundumbu.” nimbe panjirimu yemo kinie** ongele mele unguma niringi. Nakolo Jono orumu kinie yandopa Pulu Yemo ye nomi kingi molopa yamboma nokolemo ulumu paa tondolo mundupe wendo omba yunge opa touma topa manie mundulimola; ye enge nilimene aku ulumu ambolongendo tondolo munduku karaye teko lingí tekemelela.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ungu te nimbú tekeromo pilimulú konopu lingí liemo piliengi! Pulu Yemonga bokuna “⸤Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe simbe ye⸥ Illainja ombá.” nirimu* ye kanumu Jonondo nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","I nikiru mele komu angilimo yambomane paa mimi siku piliei!” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kinié mana molemele yamboma nambolka melte ene manda lepo manda nimbunje? ⸤Ene molemele mele i sipu nimbu siembo:⸥ Ene yamboma maku tolemele koleana ambolangoma pepe pereko molemele mele. Aku ambolangomanga marene ne anju molemele ambolango mare ⸤pea pepe pereko molonge aulke te koroko kelkolie⸥ enendo walsikulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Konana nímulu kinie ene ‘Pea konana niemili.’ na ningu “Molo.” níngi. Pe kelepo kola temulu kinie ene ‘Pea kola teamili.’ ni na níngi. ⸤Pea pepe perepo molomolo aulke te molo lepamo.⸥” nilimele. ⸤Kinié molemele yamboma ene aku ambolangoma mele molemele.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","⸤Na kinie No Linjili Jono kinie oltone nilimbolo unguma enene pilku keri pilimele; telembolo mele kanoko keri kanolemelela⸥. Jono ombalie ga kinie no waene kinie na nomba molorumu kinie ⸤kanoko keri kanokolie⸥ ningindu: “Yunge konopuna kuru te molemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pe Manie Omba Mana Ye Au Lerimu Yemo omba ga kinie no waene kinie norumu kinie ⸤kanoko kerila kanokolie⸥ ningindu: “Yu ga aisili nomba keri pilipe, no waene aisili nomba kekelepa topa telemo yemo. Yu kou takisi lili yema kinie,* ulu pulu keri telemele yambo wema kinie ‘Yu kinie pulu lepili pea tapu topo molamili.’ nimbe telemo.” nilimelela. ⸤Enene aku siku Jono kanoko kerila kanolemele. Na kanoko kerila kanolemele.⸥ Nakolo pilipe konginjili ulu pulumu Pulu Yemo kinie pelemona yuni telemo temba mele kanokolie ‘Papu telemo.’ ningí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aku nimbelie Yesusi kolea ou andopa ulu tondolo aisili terimu koleamanga ⸤moloringi yamboma⸥* yuni terimu mele kanokolie enenga ulu pulu kerime kanoko keri kanoko munduku kelko konopu alowa naa teringi kanopalie yuni ene iri topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolea Korasini kinie Besaida taonotolonga ⸤molemele yamboma⸥ mindili nongo paa molko kenjingí! Kanu koleatolonga sukundu ulu tondolo aisili terindu ⸤nakolo akuna molemele yamboma konopu alowa naa telemele⸥. Kolea aili Taya kinie Saidonotolonga sukundu* ⸤ulu tondolo te naa terindu** nakolo kanu koleatolonga sukundu⸥ nane ulu tondolo aku sipu telka kanolemelkanje kanu koleatolonga ⸤yambomane⸥ ene ulu pulu keri telemelema koronga munduku kelko, bulu siku, konopu alowa telemelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akumunge nane enendo nimbu sikiru: Pe kote walemo wendo ombá kinie kanu kolea Taya kinie Saidonotolonga ⸤yamboma ulu pulu keri telemelemonga⸥ enenga kote kanga mele pemba. Nakolo ene kolea Korasini kinie Besaidatolonga ⸤yamboma nane ulu tondoloma terindu kinie kanokolie konopu alowa naa teringimunge⸥ kote walemo wendo ombá kinie enenga kote aili mele pemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapeniame taono ⸤yamboma enene⸥ ‘Mulu koleana pupu molamili.’ konopu lekemeleye? Aku manda molo. ⸤Enene nanga unguma alieli pilimele nakolo konopu alowa naa telemelemonga⸥ ene kolea kerine puku molonge.* Enenga koleana sukundu ulu tondolo aisili terindu ⸤nakolo ene konopu alowa na teringi⸥. Kolea aili Sodomo sukundu** ⸤ulu tondolo te na terindu nakolo kanu koleana sukundu⸥ nane ulu tondolo aku sipu telka kanolemelkanje yamboma konopu alowa telemelka, pe kinié kepe kanu koleamo we lelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akumunge nane ene ⸤Kapeniame yambomando⸥ nimbu sikirumu: Kote walemo wendo ombá kinie kolea Sodomo ⸤yamboma ou ulu pulu keri aisili sike teringi nakolo⸥ enenga kote kanga mele pemba. Nakolo ene kolea Kapeniame ⸤yamboma nane ulu tondolo terinduma kanokolie konopu alowa na teringi yamboma,⸥ kote walemo wendo ombá kinie enenga kote aili mele pemba.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aku walemanga Yesusini nimbendo: “Tara, Mulu Matolo Nokoko Moleno Ye Nomimu, nane nu kinie ‘Ange’ nikiru. “Olio pilipe konginjili pelemo. Olio oliolio ungumanga puluma pali pilipu konjilimolo.” ningu pilimele yamboma ene nane kinié telio ulumanga pulumu nuni ‘Naa piliengi!’ ningu naa ningu sirinu. Yambo ambolango pame mele molko nane nilio unguma komu tenjiku molemele yamboma mindi nane telio ulumanga pulumu ‘Piliengi!’ ningu, ene ningu sirinu kanumunge nu kapi nimbu ‘Papu terinu.’ nikiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sike, Tara, nuni ‘aku sipe wendo ombá kinie konopu simbu.’ ningu aku siku terinumunge ⸤aku sipe wendo okomo⸥.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","⸤Pulu Yemondo aku sipe nimbelie kelepa yambo moloringimendo nimbendo:⸥ “Melema pali Tarane na sirimu.* Yambo tene Malo paa sike molemo mele pilipe kanopa imbi silimo yambo te molo; Lapane mindi yu kanopa imbi silimo. Yambo tene Lapa paa sike molemo mele pilipe kanopa imbi silimo yambo te molo. Malone mindi kanopa imbi silimo; Malone ‘Lapa lipu ora siembo.’ nimbé yamboma ene Lapa kanoko imbi singíla.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ene kongono mindili siku telemele yamboma kinie, konopuna umbuni telemo yamboma kinie, na moliona wayo. Onge kinie na pea konopu teluna pumbemonga nane ‘Konopu pe nipili koro molai.’ nimbú. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nando “Nunge kongono teleno mele pea ambolambili. Nu nanga ungu mane silimu molani. Nunge ungu ninime pilipu lipu molambo.” ningu teayo. Na taka lepo molopo, yambomane na teko kenjilimele kinie pilipu siye kolopo moliona i nikiru mele ene na molombona ongo tenge kinie enenga konopuma pe nimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nanga kongono teliomo pea ambolombolo kinie taka lelko teni. Mele pe nilime mindi silio kene* moliona wai.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Walse, ⸤Juda yambomanga koro moloringi⸥ wale Sambate tenga,* Yesusi kinie yu lombili andolime kinie rasi witi poniemanga ongo puringi kinie yu lombili andoli yema engelene kolkolie rasi witi mongo mare inie toko noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aku teringi kinie kanokolie Parisi yemane* Yesusi yundu ningindu: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa teangi.’ nimbe pelemo ungu manemo** nu lombili andoli yemane manemo pulue tokolie aku siku tekemele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesusini pundu topa nimbendo: “Ene Pulu Yemonga bokuna sukundu ⸤anda kolepa ye nomi kingi⸥ Depisini* terimu mele nimbe molemo temanemo kanokolie temanemonga pulumu naa pilimeleye? Depisi kinie yu pea puringi yema kinie ene engelene kolkolie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Depisi Pulu Yemo molorumu sele ulkena sukundu pupe, Pulu Yemonga kumbi kerena lerimu pillawa kalolime lipe nomba, yu pea puringi yema sirimu noringila kanumu.* Kanu pillawa kalolimendo Pulu Yemone ungu mane te sipelie nimbendo: “We yambomane paa na nangi! Pulu Yemo popo tonjili yema manjiku nangi!”** aku sipe mele nirimu ⸤kanu ungu manemo pulue torumu⸥ kanumu. ⸤Ene konopu talo nambemuna lemeleye? Depisi yuni ou aku terimu mele ene pilku keri naa pilimelemonga pe kinié na lombili andoli yemane tekemele mele na kanoko keri kanai.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ungu mane te pelemola. “Pulu Yemo popo tonjili yemane* koro mololi wale Sambatemanga Pulu Yemonga ulkena kongono telemele kinie Sambate walemanga ungu manemo pulue tolemele nakolo aku kongono telemelemonga mongo naa pemba.” nimbe molemo** akumu naa la pilimeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nane enendo nimbu sikiru: Mele konde te* kinié pelemo akumu Pulu Yemo popo toko kalemele ulke tembelemonga olandopamo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","⸤Pulu Yemone nirimu ungu te yunge bokuna molemo mele i sipe:⸥ “Enene yamboma kondo kolemele kinie kanopo peanga kanolio. Na popo toko kongime kalemele akumu uluri molo.”* nilimo, akumunge ungu pulumu ene Parisi yemane pilimelkanje i ye ulu teko naa kenjikimili yema “Teko kenjikimili.” na nilimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Manie Omba Mana Ye Au Lerimu Yemone* Sambate walema nokolemo yemo molemona ⸤Sambate wale kinie yamboma molko konjingindu tenge mele manda nimbé kanumu⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kanu kinie Yesusi aku koleamo mundupe kelepa pupe Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke tenga purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kanu ulkena ye te molorumu, yunge ki te kamu kolopa kukurumu. Kanu kinie akuna moloringi ye marene ‘Yesusini tepa kenjimbe kinie kote tenjemili.’ ningu yu walsiku pilkulie ningindu: “Koro molemolo wale Sambate kinie yambo kuru tolemoma tepo konde limulú kinie manda molo aku temulu liemo Pulu Yemonga ungu manemo pulue tomoloye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesusini yemando pundu topa nimbendo: “Sambate wale kinie ye tenga kongi sipisipi te muruna topa manie mundumbe kinie sipisipi ari telemo yemone kundupe ola lipe memba naa ombáye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aku liemo sipisipi maniendopa mele, yamboma paa olandopa, akumunge Sambate wale kinie ulu peangama manda na temoloye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aku nimbelie ki kolopa kukurumu yemondo nimbendo: “Nunge kimu sinio si.” nirimu kinie yemone yunge kimu sinio sirimu kinie yunge ki ekendo peanga lerimu mele ki keri lerimumu altopa kamu peanga lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nakolo ⸤Yesusini aku terimu kinie kanokolie⸥ Parisi yemane pena puku maku toko “Yu nambe tepo topo konjimulúye?” ningu aulke te kororingi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","⸤Parisi yemane⸥ yu tonge teringi pilipelie Yesusi aku koleamo mundupe kelepa purumu. Kanu kinie yambo aisili Yesusi purumu mele yu lombili puringi kinie yuni yambo kuru torumuma pali tepa konde lipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nimbendo: “Na sike yemo molopolie i ulu tondoloma tekero mele enene yambo lupe marendo na ningu siei!” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aku sipe wendo orumumunge koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane* ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Aisayane nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“I yemo nanga mako torundu kongonomo tenjili yemo; nane i yemo konopu monjipu, yu kanopo paa peanga kanolio yemo. Nanga Minimu yunge konopuna panjinjimbu. Yuni ma koleana yamboma pali* nane ene sumbi sipu nokombo mele nimbe simbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yambomane yu iri tonge kinie yuni pundu topa ungu te naa nimbe, ungu te tondolo mundupe naa nimbe, yamboma andoko molemele koleamanga yuni opa ungu naa nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kamaye enge naa nilimo te elke naa topa, tepe llame mimi sipe naa nolemo kinie kamu topa naa kumunjimbe.* ‘Pulu Yemone yamboma kamu sumbi sipe nokomba walemo kamu wendo opili.’ nimbe yu aku sipe naa tepa taka lepa molomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanu kinie mana yamboma pali ‘Yuni ‘olio mongo naa liemili.’ nimbe lipe taponjimbe.’ ningu molonge.”* nirimu ungu akumu wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kanu kinie ye te yunge konopuna kuru te molorumuna mongo keri lepa melema naa kanopa ungu naa nirimu ye te Yesusi molorumuna mengo oringi kinie Yesusini yemo tepa konde lirimu kinie kanu yemo ungu nimbe melema kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aku terimu kanokolie yambomane pali mini wale mundukulie ningindu: “I yemo ye nomi kingi Depisinge malonje?”* niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nakolo aku niringi ungumu pilkulie Parisi yemane* ningindu: “Molo. Kurumanga nomi Belsipuli** mindi i ye Yesusinge konopuna molopalie yu tondolo silimona yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Enene aku siku konopuni piliringi mele Yesusini pilipelie ⸤‘Yesusi ‘Setene kinie opa tou moloringimunge Setenene yu naa lipe taponjilke.’ ningu paa piliengi!’ nimbe⸥ enendo nimbendo: “Yambo talape te konopu teluna naa pupili molko suku singine owe panjiku ene eneno opa teko lupe lupe molemele kinie kanu talapemo pora nilimo. ⸤Molo⸥ kolea tenga yamboma molo ulke teluna pelemele yamboma konopu teluna pupili naa molko ene eneno opa telemele kinie kanu yambo talapemo sungu siku yu mele mele molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aku sipela, Setenene* yunge kuru te makorolkanje aku telkamonga yunge talapemo kinie opa mele telka. Pe yunge talapemo nambe tepa kapola molemelkaye? ⸤Pora nilke.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Ungu te piliengila! Nane Belsipulinge tondolomone kuruma makorolio liemo enenga yemane naenga tondolomone kuruma makorolemeleye? Akumunge ⸤enenga ye kuruma makorolemele yemane ‘Pulu Yemone olio tondolo silimona olione kuruma makorolemolo.’ ningu pilimelena⸥ enene nando i nikimili unguma kanu yemane pilku apurukulie “Ene kolo tokomele.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nakolo sike Pulu Yemonga Minimuni na tondolo silimona nane kuruma makorondu liemo Pulu Yemo ye nomi kingimu molopa yamboma nokomba walemo* ene molemelena koronga wendo omu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ungu te pea i sipe: Ye enge nili tene yunge ulkemo nokopa konjilimo kinie ye tene we manda sukundu omba melema wa lipe memba pulimoye? Akumu manda molo. Ou wa noli yemone ye enge nilimunge kimbu kime ka topalie yunge ulkena manda omba melema wa limo kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na naa lipe taponjilimo yambomone na kinie opa tou molemo. Yambo tene na lipe taponjipe ⸤kongi sipisipime⸥ sukundu naa limo yambomone ⸤kongi sipisipime⸥ topa bulu balu silimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Akumunge nane enendo nikiru: Yambo tene ulu pulu kerime tepa, ungu taka tonjipe nimbe kenjilimo uluma Pulu Yemone manda ‘Manie pupili.’ nimbe siye kolomba. Nakolo yambo tene Pulu Yemonga Minimu nimbe kenjipe ungu taka tonjimbe uluma Pulu Yemone ‘Manie naa pupili.’ nimbe siye naa kolomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Manie Omba Mana Ye Au Lerimu Yemo* ungu taka tonjipe ungu nimbe kenjilimo yambomo aku sipe ulu keri telemoma Pulu Yemone ‘Manie pupili.’ nimbe siye kolomba. Nakolo Mini Kake Telimu⸤ni ulu te telemo kinie⸥ yambo tene ungu taka tonjipe, opa tepa sipe ⸤“Yuni naa tekemo. Kurumanga nomi Setenene yu lipe taponjilimona aku telemo.⸥” nilimo yambomo aku sipe ulu keri telemomo kinié kepe mulu ma pora nimbé wale kinie kepe ‘Manie naa pupili.’ nimbe paa siye naa kolomba.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Unju peanga te kanokolie ‘Mongo peangama tomba nomolo.’ ningu kanolemele. Unju keri te kanokolie ‘Mongo kerime tomba manda naa nomolo.’ ningu kanolemele. Unju te mongo tolemo kinie kanokolie ‘I unjumu peanga, i unjumu keri.’ ningu apuruku kanolemelemonga aku siku ningu kanolemele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ene Parisi yema, kolo topa yamboma tepa kenjili wambiyemonga waloma,* ene ye keri molemelemane nambe teko ungu peangama manda ningíye? Yambo te yunge konopuna pelemo unguma mindi kerena nilimo akumunge ene ye kerimene nambe teko ungu peangama manda ningíye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aku sipe mele, yambo peanga tene yunge konopuna ulu peanga pelemoma telemo, nakolo yambo keri tene yunge konopuna ulu keri pelemoma telemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Akumunge nane enendo nimbu sikirumu: Pulu Yemone yamboma kote tenjimbe walemonga eneno ungu nilimelema apurupe pilipelie “Nu yambo peangamo, nu yambo kerimu.” nimbé akumunge yambomane mana we ungu nilimelema pali kepe apurupe pilipelie “Aku unguma nambemuna niringiye?” nimbé.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kanu kinie Parisi ye mare kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi ye mare* kinie enene Yesusindu ningindu: “Ungu Mane Silimu, ‘Nu sike Pulu Yemone ‘Kongono tenjeni.’ nimbe mana lipe mundurumunje olio kanamili.’ ningu Pulu Yemone mindi manda ulu tondolo telemo mele te tei.” niringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesusini pundu topa nimbendo: “Kinié mana molemele yamboma keri mindi molemele. Ene teko kenjiku Pulu Yemo liku su silimele yambomane “Pulu Yemone mindi ulu tondoloma manda telemo mele kanamili tei.” ningu na mawa telemele. Nakolo ⸤Pulu Yemone na lipe mundurumuna ombo molkoro. Yu kinie tapu topo kongono telembolo mele* lipe ora simbe ulu⸥ tondolo te wendo naa ombá. Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye** Jona kinie wendo orumu ulu akumuni mindi lipe ora silimo manda kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oma aili tene Jona topa penge mundurumu kinie yu omamonga olona ipulueli tangoli wale yepoko molopa perimu ⸤kinie omamone yu nomu kélona meku topa wendo mundurumu kinie yu altopa we molorumu⸥ mele* Manie Omba Mana Ye Au Lerimu Yemo ⸤ono teko panjingí kinie⸥ aku sipe ipulueli tangoli wale yepoko mana sukundu pepalie ⸤lomboropa ola molomba⸥.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ou kolea aili Ninipa yamboma ⸤sike molko kenjiringi nakolo Pulu Yemone ungu umbu tonjirimu mele⸥ Jonane ⸤pilipe⸥ Ninipa yamboma pupe nimbe sirimu kinie pilkulie teko kenjiringi mele kanoko keri kanoko konopu alowa teko molko konjiringi.* Aku teringimunge kinié molemele yambomane Jonanga olandopa ye te ya molemo yemonga ungumu liku su siku naa pilimelemonga kote walemo pe wendo ombá kinie Ninipa yambomane kotena angilku, kinié molemele yambomando “Teko kenjiringi. Mindili nonge kinie papu.” ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ou olio Isirele yambomanga ye nomi kingi Sollomono yu ye paa tondolo te molopa, yu ungu lupe lupema pilipe konginjilimu pepili molorumu mele kolea Sipa nokorumu ambo nomi kuinimu pilipelie, Sollomonone ungu peangama mindi nirimu mele pilimbendo yu kolea suluna molopalie ⸤Sollomono molorumuna⸥ wale aisili aulkena pelipe orumu.* Aku sipe terimumunge, ye nomi Sollomononga olandopa ya molemo yemone nilimo ungumu kinié mana molemele yambomane naa pilku, liku su silimelemonga kote walemo wendo ombá kinie kolea Sipa ambo nomi kuinimuni nimbendo: “Nane Sollomonone ungu peanga nirimu mele pilimbundu aulke suluna orundu nakolo Sollomononga olandopa molorumu yemone nirimu ungumu ene naa pilku, liku su siringi yamboma aku teringimunge ene papu mindili nonge.” nimbé.”** ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kuru te ye tenga konopuna wendo ombalie, no naa mololi koleamanga pupe manda koro molomba kolea te korolemo. Te naa kanopa lenjipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yuni nimbendo: “Na ou molopolie wendo ondu ulkena* kelepo pambo.” nimbe yu omba yu ou molopa purumu ulkemo kanolemo kinie ulke puri memba tepa peanga tepa we lepa yambo te naa molemo kinie kanopalie nilimomone, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yu kelepa anju pupelie kuru kara puli paa olandopa yepoko pakara lipe memba omba ene pea kanu ulkena sukundu puku molemele. Kanu kinie kanu yemo ou molopa kenjilimo nakolo pe paa kamu olandopa mele molopa kenjilimo. Aku sipe kinié ya teko kenjiku molemele yamboma pe kamu molko kenjingí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesusi yambo maku toko moloringime ungu mane sipe molopili yunge anumu kinie angenupili kinie yu kinie ungu ningindu ongo pena angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yambo tene yundu nimbendo: “Aminie kinie angenali kinie* enene nu kinie ungu ningindu ongo pena angilimele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesusini yundu pundu topa ⸤ungu iku topalie⸥ nimbendo: “Nanga anumu naeye? Nanga angenupili nameleye?” nimbelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","yu lombili andoli yamboma lipe ora sipelie nimbendo: “I yamboma nanga anumu kinie nanga angenupili kinie molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nanga Lapa, mulu koleana molemomone “Teangi.” nilimo mele pilku liku telemele yamboma nanga anumu kinie nanga angenupili kinie nanga kemulupili kinie molemelemonga aku sipu nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yambo maku toko moloringimendo aku sipe nimbe pora sipelie nirimumuni, Yesusi ulkena molopa pena pupe nomu kélona pupe manie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yambo paa aisili yu molorumuna ongo maku toko moloringimunge nona andoli sipi te nona ola lerimumunge suku pupe manie molorumu, yamboma nomu kélona angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yuni enendo ungu aisili nimbe simbendo ungu iku pokore torumu. Ungu iku te i sipe topalie nimbendo: “Pilieme! “Ye tene rasi witi umbu poniena andopa tanda sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tanda silipe andorumu kinie umbu mare aulkena manie purumu, kanuma keramane ongo liku noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Umbu mare kou perimuna manie pupelie ma wallo kolte mindi lerimuna nondopa mulie topa wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nakolo pulkeno naa mundurumuna ena terimu kinie kanuma kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Umbu mare kombulu siri ka mélemo molorumuna manie purumu, siri ka melemo wendo omba witi umbuma topa norumuna omba peanga naa lepa ⸤mongo te na torumu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Umbu mare ma peangana manie purumuma wendo omba mongo peangama torumu. Mare mongo tokapu kise mele topa, mare mongo tokapu yepoko mele topa, mare tokapu telu mele torumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","⸤Aku nimbelie⸥ “Yambo komu peo lemomane i ungumu piliei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesusi lombili andolime yu molorumuna ongolie yundu ningindu: “Nu yambomando ungu te ninindu ungu ikuma alieli nambemuna tolenoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yuni enendo pundu topa nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma kinie melema kinie nokolemomonga* ulu pulu yu yuyu pilirimu kanu ulu puluma ‘Kinié ene ⸤na lombili olemele yamboma⸥ piliengi!’ nimbelie ene nimbe sikimu. Nakolo we yamboma nimbe naa sikimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pulu Yemonga ungumu pilku molemele yamboma paa olandopa nimbe simbe pilingí. Pe paa aisili pilingí. Nakolo naa pilku molemele yamboma ene laye kolte pilimele ungumu kepe wendo limbe.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","‘Ene mongone kanokolie naa kanoko, komuni pilkulie naa pilimele.’* akumunge nane we yamboma enendo ‘Unguma nimbu siembo.’ nimbulie ungu ikuma mindi topo silio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Aku siku teko molemelemonga koronga ou Pulu Yemone ungu umbu tonjirimuma yamboma nimbe sirimu ye Aisayane “Aku siku tenge.” ou nirimu mele wendo olemo. Aisayane nimbendo: “Enene alieli komuni pilingí nakolo konopuni pilkulie paa naa pilingí; mongone kanonge nakolo melte paa sike na kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","I yambomanga konopuma paa pipi silimo; enene ungu pilingindu komu na tenjiku molemele; enenga mongoma kumbulku molemele. Aku siku teko molemelemonga na kanoko na pilku molemele. I uluma aku sipe na telkanje enene enenga mongone kanoko komuni pilku konopuni pilkulie alowa telemelka, kanu kinie nane ‘Ene konde pangi.’ nilke.”* nirimu. ⸤Aisayane aku sipe nirimu mele⸥ aku siku kinié we yamboma teko molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nakolo ⸤na lombili andolime⸥ enene mongone paa sike kanoko komuni paa sike pilku molemelemonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nane enendo paa sike nimbu sikirumu: Ou moloringi yamboma, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema kinie,* Pulu Yemonga unguma pilku liku sumbi siku moloringi yamboma kinie, kanu yambo aisili kinié ene mongone kanoko molemele melema kinie uluma kinie kanongendo “Kanamola!” ningu moloringi nakolo na kanoringi. Ene kinié komuni pilku molemele unguma pilingindu “Piliemola!” ningu moloringi nakolo naa piliringi akumunge ⸤nane ‘Kinié sike kanoko sike pilimelemonga ene malo.’ nikiru⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Akumunge, yambo tene rasi witi umbu tanda sirimu ungu ikumunge pulumu kinié niembo pilieyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","⸤Umbu mare tanda sirimu aulkena manie purumu kanumanga ungu pulumu i sipe:⸥ Yambo tene Pulu Yemo ye nomi kingimu molopa melema nokolemomonga ungumu pilipelie na pilimo kinie ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥ muni* omba umbu tanda sili konopuna pupe pelemoma walsikale toropa wendo limo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Umbu mare tanda sirimu kou perimuna manie purumuma yambo mare aku silime molemele. Enene ungumu pilkulie walsikale sumbi siku konopu siku pilku limele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nakolo ene pulkeno naa mundukulie ungumu laye kolte mindi pilku molemele. Pe ene konopuna umbuni telemo kinie molo ene Pulu Yemonga ungumu pilku liku molemele mele yambo lupemane kanoko keri kanokolie ungu taka tonjiku teko kenjiku mindili silimele kinie enenga pilimele unguma siye kolemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Umbu mare tanda sirimu siri ka mele molorumuna manie purumuma yambo mare kepe aku silime molemele. Enene ungumu pilimele kinie konopuna umbuni telemo umbunime kinie, mele aisili nosikulie ‘Aku melemane olio lipe taponjilimo taponjimbe.’ ningu pilku molemele uluma kinie,* kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinie ungumuni uluri naa tepa langi mongo na tolemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Umbu mare tanda sirimu ma peangana manie purumuma yambo mare aku silime molemele. Enene ungumu pilkulie ungu pulumu pilku konjilimele. Pe ene langi mongo tolemele. Kanu yambo marenga langi mongo tokapu kise mele topa, yambo marenga mongo tokapu yepoko mele topa, marenga mongo tokapu telu mele topa, aku sipe tolemo. Ungu ikumunge ungu pulumu aku sipe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesusini ungu iku te pea yamboma topa sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa melema nokolemo akumu i sipe mele: Ye tene yunge poniena rasi witi umbu peangama tanda sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nakolo yamboma uru peringi kinie yunge opa tou ye te omba era ⸤rasi witi none teli era⸥ umbu te witi poniena tanda sipelie kelepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kanu kinie umbu peangama wendo omba witi mongo torumu kinie era kinie pea wendo orumu mele mona molorumu kanoringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kanu kinie ponie pulu yemonga kongono tenjili yema ongo yundu ningindu: “Ailimu, nunge poniena langi umbu peangare tanda naa sirinuye? Pe kinié era nambe tepa wendo okomoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yuni enendo nimbendo: “Tena. Opa tou ye tene aku era umbuma omba tanda sirimu lepamo.” nirimu. Kongono tenjili yemane ningindu: “‘Era pea waka maka wendo okombele kene pupu erama akupu lipu maku tamili.’ konopu lekenoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nakolo yuni nimbendo: “Molo. Era tengi liemo witi pea pulu akungínje. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pe witi kamu lipu maku tomolondo ou pea ongolo molangili. Pe witi kamu limulú walemo wendo ombá kinie nane witi kari lelko linjingí yambomando nimbundu: “Ou era kalongendo liku piye teko maku tokolie ningímuni, pe witi liku nanga witi nosilio ulkena maku toko nosengi.” nimbú.” nirimu.” nimbe, Yesusini “Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu aku sipe mele.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ungu iku te pea yamboma topa sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu i sipe mele: Ye tene unju masetete umbu te lipe ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","yunge poniena umbumu mundurumu. Masetete umbu akumu langi umbumanga pali yu paa kangamo nakolo wendo omba ai lemo kinie poniena molemo melemanga pali yu paa ailimu. Kamu ai lepa unju mele angilimo kinie kerama kanu unjuna ongo kolamanga pelemele. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ungu iku te pea yamboma topa sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu i sipe mele: Ambo tene yu langi pillawa akoli mele isi wallo kolte pillawa aisilinge mundurumu kinie pillawa pali akorumu.* ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kanu unguma pali Yesusini yambomando nimbendo yu ungu iku mindi topa nirimu. We ungu te enendo sumbi sipe naa nimbe ungu iku manjipe topa nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aku sipe terimumunge koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye tene ou nirimu ungu te kamu wendo orumu. Akumu i sipe: “Nane i ⸤ungu nimbundu⸥ ungu iku ⸤manjipu⸥ topo nimbú. Pulu Yemone ou mulu matolo terimu kinie kepe yandopa yandopa kepe ⸤mona naa niringi⸥ lopi tepa perimu unguma ⸤nimbundu ungu iku mindi topo⸥ nimbú.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","⸤Yesusini ungu iku akuma topa pora sipelie,⸥ yu maku toko moloringi yamboma mundupe kelepa ulkendo purumu kinie yu lombili andolimene yu molorumuna ongolie ningindu: “Poniena era orumu ungu ikumunge ungu pulumu olio ningu para si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yuni pundu topa nimbendo: “Langi umbu peangama tanda sirimu yemo Manie Omba Mana Ye Au Lerimu Yemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Poniemo ma kolea pali. Langi umbu peangama yambo ‘Pulu Yemo nanga ye nomi kingimu molopili.’ nilimelemonga enenga konopumanga Pulu Yemone tapu tepa molopa nokolemo yamboma. Era umbu akuma ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥ munge* yamboma. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Era umbu tanda sirimu opa tou akumu ⸤kurumanga nomi⸥ depelemo.* Witi sukundu liku maku tonge wale akumu ma kolea pora nimbé walemo. Witi mongoma sukundu lingí yamboma mulu koleana angelloma. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Erama liku maku tokolie tepena kalemele mele ma kolea pora nimbé walemonga aku sipe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manie Omba Mana Ye Au Lerimu Yemone yunge angelloma lipe mundumbe, enene ‘Yamboma Pulu Yemonga unguma naa pilku, teko kenjiku molangi.’ nilimele yamboma pali kinie, ulu pulu keri telemele yamboma pali kinie, Pulu Yemone tapu tepa molopa nokolemo yamboma molongena wendo liku maku tokolie ningímuni,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tepe aili nomba pelemo koleana sukundu toko mundungí, kanuna yamboma kola teko paa mindili nongo pereko molonge.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kanu walemanga konopu sumbi nili yamboma enenga Lapa ye nomi kingimu molopa nokolemo koleana ena pa telemo mele ene aku siku kanuna pa tepili molonge. “Yambo komu peo lemomane i ungumu piliei.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","⸤Yesusini aku nimbelie kelepa nimbendo:⸥ “Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu i sipe mele: Sumele ombele te laku teko ponie tenga ou lopi teringi we perimu kanumu ye tene pe walse kanopa lipelie kelepa aki torumu. Aki topalie konopu sipe pupe yunge melema pali lipe makete tepa kou pokore yando lipelie kanu poniemo pupe topo topa yando lirimu. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu i sipela: Kou bisinete teli ye tene siripelu ‘pélle’ nili peangama koropa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kanu kinie siripelu pélle kou paa aisili puli te kanopalie nirimumuni, yu pupe yunge melema pali makete tepa kou yando lipelie kanu siripelu péllemo topo topa yando lirimu. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu i sipe melela: Oma lili wale te nomuna toko munduringi kanumuni oma lupe lupema lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Walemo paa peke lerimu kinie kunduku liku nomu kélona nosikulie, manie molko apurukulie peangama liku wale basikete pokorenga munduringi nakolo kerime toko ele teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Ma koleamo pora nimbé walemonga aku sipela. Mulu koleana angelloma ongolie ningímuni, yambo teko kenjiku molongema kinie yambo sumbi siku molko konjingíme kinie apuruku ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yambo teko kenjiku molongema liku tepe aili we nomba pelemo koleana toko suku mundungí, kanuna kola teko paa mindili nongo pereko molonge.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","⸤Ungu ikuma topa pora sipelie Yesusini lombili andolime walsipe pilipelie nimbendo:⸥ “Aku unguma pali ungu puluma ene pilíngiye?” nirimu. Enene yundu ningindu: “Pilímulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yuni enendo nimbendo: “Aku liemo Pulu Yemonga ungu manemanga puluma pilku mane silimele yemane* Pulu Yemo ye nomi kingimu molopa yamboma nokolemomonga unguma mane silimolo kinie pilku liku molemele kanu yema ene i sipe: Ulke pulu ye tene yunge mele peanga aisili nosilimomanga mele kondema kinie mele ouma kinie pea wendo limo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusini aku ungu ikuma topa pora sipelie kanu koleamo mundupe kelepa yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mundupe kelepa pupelie yunge pulu kolea ⸤Nasarete⸥ ombalie Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkena suku pupe yamboma mane sirimu kinie pilkulie ene suru ningu mini wale mundukulie ningindu: “I yemo yunge pilipe konginjilimu kinie yunge ulu tondolo telemomanga tondolomo kinie yu tena lirimuye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yu ulkema takorumu yemonga* malo moloye? Maria yunge anumu naa molemoye? Jemisi keme, Josepo keme, Saimono keme, Judasi keme, yunge angenupili moloye?** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yunge kemulupili kinie pali olio kinie pea na molemoloye? ⸤Yu paa sike aku yemo molemomo⸥. Aku liemo yunge pilipe konginjilimu kinie yunge ulu tondolo telemomanga tondolomo kinie yu tena lirimuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","⸤Aku siku unguma ningu⸥ yu ungu nimbe uluma tepa molorumu mele kanoko keri kanoko yu kinie paa konopu keri panjiringi. Kanu kinie ⸤ene yu kinie mumindili koloringimunge ulu pulumu pilipelie⸥ Yesusini enendo nimbendo: “Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye te* koleamanga pali imbi ola molemo, yambomane pali yunge unguma pilku limele. Nakolo yunge pulu koleana yu kinie pea tapu toko molemele yamboma mindi yuni nilimo ungumu pilkulie ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo unguma naa pilku, liku su silimele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kanu kinie yu ⸤ungu nimbe uluma tepa yu yuyu molorumu mele ‘Sike.’ ningu⸥ tondolo munduku naa piliringimunge yu kanu koleana ulu tondolo aisili na terimu, wallotolo mindi terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kanu walemanga kolea Gallilli disiriki nokorumu ye nomi kingi Erotene Yesusini terimu mele temane toringi pilipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yu kinie tapu toko molko yu liku taponjiringi tapu yemando nimbendo: “I uluma telemo yemo No Linjili Jono lepamo! Yu kolopalie lomboropa wendo omumunge ulu tondoloma temba tondolomo yu kinie pelemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","⸤Kingi Erotene aku sipe nirimu ungumunge pulumu i sipe:⸥ Ou walse Erotene yunge angenu Pillipunge ambo menu Erodiasi mangopa lirimu. ⸤No Linjili⸥ Jonone Erote aku sipe terimu kanopalie yundu alieli nimbendo: “Nuni ⸤Pulu Yemonga⸥ ungu mane te pulue toko angenanga ambomo mangoko lirinu. Akumu teko kenjirinu.” nirimu kinie Erotene yu lipe ka sipe ka ulkena panjirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka ulkena panjipelie ‘Yu topo konjembo.’ konopu lerimu nakolo we yambomane ‘Jono yu Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye te molemo.’* ningu kanoringimunge yu pipili kolopalie Jono topa na konjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe walse kingi Erotenga meringi walemo wendo orumu kinie Erodiasi lemenu ulkena sukundu omba, yema maku toko kanoko molangi yu denisi terimu. Erotene ambo wenepomo aku terimu kanopa paa peanga kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yundu nimbendo: “Nando “Si.” nini melemo paa sike simbu.” nimbe, nimbe panjipe Pulu Yemonga imbi lepa mi lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yuni aku sipe nirimuna anumuni pilipelie lemenu ungu te nimbe sirimu kinie pilipelie ambo wenepomone Erotendo nimbendo: “No Linjili Jononga ⸤nomimu karu lelko* yunge⸥ pengemo pellete tenga nosiku yando si.” nirimu. ⸤Jonone ou alieli “Erote kinie Erodiasitolone teko kenjiringili.” nirimumunge mumindili kolopalie Erodiasini ‘Yu kolopili. Sike kolomunje na kanambo.’ nimbe “Pengemo ongo si.” nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Yuni aku sipe mele mawa terimuna pilipelie Erote konopu umbuni terimu nakolo yuni “Paa sike simbu.” nimbe, nimbe panjipe Pulu Yemonga imbi lepa mi lerimu mele kepe, yu konopu alowa temba kinie yu kinie pea langi nongo moloringi yema yu kanoko keri kanonge mele kepe, aku ulutolo pilipelie, ka ulkena nokoringi yemando ungu te nimbe mundupelie “Yuni mawa tepa “Si.” nikimu mele siengi kene ⸤No Linjili⸥ Jononga ⸤nomimu karu lelko yunge⸥ pengemo yando mengo wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aku nirimu kinie pilkulie Jono toko konjiku, yunge pengemo pellete tenga nosiku, yando mengo ongo ambo wenepomo siringi kinie yuni lipe anumu molorumuna memba pupe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aku teringi pilkulie Jono lombili andoringi yema ongo yunge onomo liku mengo puku ono tekolie Yesusi molorumuna puku temane toko siringi. ⸤Kingi Erotene No Linjili Jono ou aku sipe topa konjirimu kolorumumunge pe Yesusini ulu tondoloma terimu mele pilipelie “Jono nomi karu lerindu yemo lomboropa ola molemo lemo.” nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","⸤Ye nomi kingi⸥ Erotene No Linjili Jono topa konjirimu pilipelie nirimumuni, Yesusi yu molorumu koleamo mundupe kelepa ‘Tenga nanu molambo.’ nimbe nona andoli sipi tenga sukundu pupe nomu ⸤Gallilli⸥ nekendo pupe kolea ku leli tenga yuyu pumbe purumu. Nakolo yambo aisili yu aku terimumu pilkulie enenga koleama munduku kelko kimbu kongono teko nomu kélona makaye teko puku yu purumuna akilku lombili puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesusi no kélona ombalie yambo paa aisili akuna maku toko moloringi kanopalie ene kondo kolopa enenga kuru torumuma ‘Konde pangi.’ nimbe ene tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pe ipupini ena pumbe terimu kinie yu lombili andolime yu molorumuna ongo yundu ningindu: “I koleana yambo te naa pelemo, ena kamu pukumu kene ya maku toko molemele yamboma ‘Puku kolea marenga langi topo toko lipangi.’ ni.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nakolo yuni yu lombili andolimendo pundu topa nimbendo: “Nambemuna ‘yambo akuma ‘We pangi.’ niembo.’ ningu nikimiliye? Enene eneno yamboma langi mare liku siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Enene yundu ningindu: “Ya langi aisili molo. Pillawa kaloli kanga te pakara kinie oma kaloli talo kinie aku langi pokore mindi lemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yuni “Na moliona yando mengo wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kanu kinie yambomando “Erana manie molai.” nimbelie yuni kanu pillawa kaloli te pakara kinie oma talo kinie lipelie mulu koleana olando sipe kanopa ⸤Pulu Yemo kinie⸥ “Ange.” nimbe pillawa kalolime ambolopa pike lepa ⸤oma kinie⸥ lombili andolime moke tepa sipelie “Anju yamboma siei.” nirimu, enene yamboma moke teko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ene pali kanu langime noringi kinie olo terimu. Pe lombili andolimene langi goli lerimuma liku maku toko wale basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Langi noringi yema manjipe pape tausini mele. Ambo ambolango ⸤mare pea langi noringi⸥ akuma olandopa. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","⸤Yamboma langi sirimu noringi⸥ kinie Yesusini yu lombili andoli yemando sumbi sipe nimbendo: “Maku toko molemele yamboma nane “Pangi.” niembo. Ene nona andoli sipine ola puku no nekendo kumbi lelko pai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yambomando “Pai.” nimbelie yu yuyu Pulu Yemo kinie ungu nimbendo ma pangine ola purumu. Kanu kinie ena pupe kolea kala torumu kinie akuna yuyu molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sipimu no nekendo pumbendo nomu ai suku singine kokele pumbe purumu kinie sipi kumbikundu mendo sipe poporomene topa, nomu torumula kinie nomo ola pupe manie omba terimu, sipimu topa ola munde manie munde tepa topele mapele torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kanu kinie ipulueli kolea muni naa lepili ⸤yu lombili andolime sipine ola molko⸥ puringine Yesusi nona ola kimbu kongono tepa ombá orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Enene yu nona ola kimbu kongono tepa orumu kanokolie niringimuni, pipili aili teko kolkolie “Kuru te okomaa!” ningu mini wale munduringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesusini tamburembu enendo nimbendo: “Ene konopu tondolo pupili molayo. Na mindi okoro. Pipili naa kolai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","⸤Yuni aku nirimu piliringi kinie⸥ Pitane pundu topa nimbendo: “Ailimu,* akumu sike nu nunu onu liemo nu okonona na nona ola angilipu wambo walsi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yuni “Oi.” nirimu kinie Pita sipine ulsu pupe pukue topa nona manie pupelie nona ola kimbu kambilipe Yesusi molorumuna pumbe purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nakolo poporome tondolo torumu kinie kanopalie pipili kolopa yu no wangomba tepalie, “Ailimu, na liku taponji!” nimbe ru nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kanu kinie Yesusini ki sinio sipe mundupe Pita kundupe ola lipelie yundu nimbendo: “Nane ulu telioma nu wallo kolte mindi pilino lemo. Ou ‘Yuni na lipe taponjimbe, sike nona ola manda pumbu.’ konopu lelkolie altoko konopu alowa nambemuna teko ‘Na no wangombonje?’ ningu pilinuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sipine suku puringili kinie poporome topa kelerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aku terimuna kanokolie sipine suku moloringi yemane Yesusinge imbi ambolko ola linjiku kapi ningu “Nu paa sike Pulu Yemonga Malo lepamo.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kanu kinie ⸤Yesusi kinie yu lombili andolime kinie⸥ nomu ⸤Gallilli⸥ nekendo pukulie nomu kélona kolea Geneserete lerimuna wendo oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","⸤Kanu koleana sipine manie oringi kinie⸥ akuna moloringi yemane Yesusi kanoko imbi sikulie akundu lerimu koleamanga moloringi yamboma pali ningu munduringi kinie yambomane kuru torumu yamboma pali yu omba molorumuna mengo ongolie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“‘Nunge wale pakoli pundumu kepe ambolangi.’ ni.” ningu mawa teringi. Kanu kinie kuru torumu yambomane yunge wale pakolimu amboloringi yamboma pali kamu konde puringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kanu kinie Parisi ye mare kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi ye mare kinie* ene Jerusalleme munduku kelko Yesusi molorumuna ongo yu walsiku pilkulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Olionga anda kolepalimene “Teai.” niringi ungu manemo nu lombili andolimene nambemuna pulue tolemeleye? ⸤Anda kolepalimene “Teai.” niringi mele mimi sipu pilipulie olione kíme kulumiye tolemolo mele⸥ enenga kíme aku siku kulumiye na toko langi we nolemele kanumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesusini pundu topa nimbendo: “Enene kepe enenga anda kolepalimene “Teai.” niringi mele mindi pilku liku tengendo Pulu Yemonga ungu manema nambemuna pulue tolemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akumunge Pulu Yemone nimbendo: “Aminieli lanielinge unguma pilku liku, liku ai siku teai.”* nimbe “Yambo tene yunge anumundu molo lapando ungu te nimbe kenjipe iri tomu liemo kanu yambomo toko konjengi.”** nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nakolo ene yemane ningindu: “Yambo tene yunge anumu lapatolondo nimbendo: “Nane elte mele mare lipu taponjipu silkema koronga ‘Pulu Yemo simbu.’ nimbu panjirindu kanumunge elte manda naa lipu taponjipu simbu.” nimbé kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","⸤aku sipe nimbemonga⸥ yunge lapa imbi ambolopa ola linjimbe ungu te naa pemba.” nilimele. Aku siku nilimele ungumuni ‘Anda kolepalimene mane siringi unguma olandopa.’ ningu ‘Pulu Yemone nirimu ungumu uluri molo. Manie pupili.’ nilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Ene ⸤ungu manema pilku mane silimele yema kinie Parisi yema kinie⸥ ene topele mapele toli yema molemele!* Pulu Yemone ungu umbu tonjirimuma pilku yamboma nimbe sirimu ye Aisayane enendo nirimu mele papu nirimu. ⸤Enene kinié telemele mele yuni ou nimbe Pulu Yemonga bokuna torumu molemo mele i sipe:⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","⸤Pulu Yemone nimbendo:⸥ “Kanu yamboma enenga keremane na kapi ningu ‘Ye aili olandopamo. Nu lipu ai silimolo.’ ningu na imbi ambolko ola linjilimele nakolo enenga konopuma kinie nanga konopumu kinie teluna naa pulimo. Lupe lupe pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enene ‘Nanga imbi ambolopo ola linjemili.’ ningu na we popo toko kapi nilimele. Mana yambomane mane silimele unguma mindi mane sikulie ‘I ungu manema Pulu Yemone “Teai.” nilimo ungu manema.’ ningu pilku liku telemele, akumunge na sike popo tonge kinie uluri naa temba.”* nirimu kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aku nimbelie Yesusini maku toko moloringi yambomando “Na moliona wai.” nimbelie enendo nimbendo: “Nane ⸤aku nikirumunge* ungu te⸥ nimbú tekero ungumu komu tenjiku ungumunge pulumu pilku konjeyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yambomanga kangine ulsukundu lepalie kerena pupe olona suku pulimo meltene ⸤Pulu Yemo manda popo tonge aulkemo pipi silimo⸥ kalaro te manda naa monjilimo. Yambomanga konopuna sukundu pepalie wendo olemo ulumane mindi yamboma kalaro monjilimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aku nirimu pilkulie niringimuni, yu lombili andolime yu molorumuna ongolie ningindu: “Nu aku siku nikinu mele pilkulie Parisi yemane paa pilku keri pilíngi mele nu pilkinuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nakolo Yesusini pundu topa ⸤ungu iku topa Parisime moloringi mele nimbelie⸥ nimbendo: “Nanga mulu koleana molemo Lapamone umbu naa panjirimuma pali pulu akumbe.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I yemane nilimele mele konopu kimbu siku naa pilku molangi. Ene mongo keri lelimene ⸤mongo keri lelime⸥ aulke liku ora silimele yema molemele. Mongo keri leli ye tene mongo keri leli ye te aulke te lipe ora sipe ki ambolopa memba pumbe kinie elte peatolo kombuna topa manie mundumbe.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","⸤Kalaro molemomonga ungu ikumu aku sipe torumu kinie pilipelie⸥ Pitane yundu nimbendo: “Aku ungu ikumunge pulumu nambolkanje? Ningu para si.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesusini enendo nimbendo: “Kinié kepe naa pilkimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yambo tenga kangine ulsu lepalie kerena pulimo melte olona suku pupe ulsu omba le muruna kamu pulimo mele naa pilkimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","19","Kerena sukundu pulimo melemane uluri na telemo kanumu. Ulu kerime ou konopuni pilkulie pe kamu wendo olemomonga konopuna pepalie kerena wendo olemo kanu melemane mindi ⸤Pulu Yemo popo tomba aulkemo pipi silimo⸥ kalaro te monjilimo. Kanu melema i sipe: Konopuni ulu kerime pilimele, yamboma toko konjilimele, ambo ye pulime molo ye ambo lilime yambo lupema kinie ulu kerinele telemele, wa ulu kerinele lupe lupema andoko telemele, wa nolemele, kolo toko yamboma kote tenjilimele, ‘Yamboma pipili kolko molko kenjengi!’ ningu ungu bulkundu ninjilimele, ulu pulu akuma pilku telemele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aku telemele ulu akumane yamboma ⸤Pulu Yemonga kumbikerena pungí aulkemo pipi silimo⸥ kalaro te monjilimo. Nakolo ki ou naa kulumiye toko langi we sumbi siku nolemele ulu pulumuni ⸤yambo tenga konopuna suku⸥ kalaro te naa monjilimo.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kanu kinie Yesusi molorumu kolea ⸤Geneserete⸥* mundupe kelepa ⸤Juda yamboma moloringi kolea Gallilli disiriki ulsukundu⸥ kolea aili Taya kinie Saidonotolo lerimu koleana sukundu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Akuna purumu kinie kolea Kenane ambo te* molorumu, yu wendo omba tondolo ru nimbelie nimbendo: “Ailimu, Ye Nomi Kingi Depisini Kalopa Lirimu Yemo,** nanga ambolamo kuru te konopuna sukundu molopa yu tondolo ambolemo kene nuni na kondo koloi!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nakolo Yesusini yundu ungu te pundu topa na nirimu. Kanu kinie yu lombili andolimene ongo yundu ningindu: “Ambomone nu walsilipe olio lombili okomomo ⸤siye tekemo⸥ kene ‘Anju pupili.’ ni.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","⸤Ambomo yu ambo lupe, Juda ambo te molo, nimbe kanopalie⸥ Yesusini ⸤yundu⸥ nimbendo: “Pulu Yemone na Isirele yambo talapemonga kongi sipisipi talopa lemele mele* molemele yamboma molemelena mindi lipe mundurumu kanumu. Yambo talape lupema molemelena lipe naa mundurumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aku sipe nirimu kinie pilipelie ambomo omba yunge kumbikerena koporongo langopa ma kanopalie nimbendo: “Ailimu, na liku taponji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aku nirimu kinie Yesusini pundu topa ⸤ungu iku te topalie⸥ nimbendo: “Ambolangomanga langime lipu owama simulú kinie kapola naa temba.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ambomone nimbendo: “Ailimu, sike nikinu nakolo owamane kepe enenga pulu yambomanga langi pundu manie pulimoma liku nolemele kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanu kinie Yesusini yundu nimbendo: “Ambomo, nu manda tembo mele tondolo munduku pilino lemo kene mawa tekeno mele aku sipe wendo opili.” nirimu kinie yuni aku sipe nirimu mele aku enamonga ambomonga lemenu konde pupe kapola molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kanu kinie Yesusi kanu koleamo mundupe kelepa nomu Gallilli kélona ⸤aulke te lerimuna⸥ omba pupe ma pangi tenga ola pupe manie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kanu kinie yu molorumuna yambo paa aisili oringi. Kimbu keri lerimuna aulke mimi siku na andoringi yamboma kinie, mongo keri lerimu yamboma kinie, kimbu ki karaye terimu yamboma kinie, ungu manda naa niringi yamboma kinie, aku sipe kuru lupe lupe torumu yambo aisili mengo ongo yu molorumuna nondoko nosiringi kinie yuni ene tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ungu naa niringi yamboma ungu niringi; kimbu ki karaye terimu yambomanga kimbu kime kelepa sumbi sipe angilirimu; kimbu keri lerimuna aulke mimi siku naa andoringi yamboma kapola andoringi; mongo keri lerimu yamboma mongone melema kanoringi; aku sipe ulu tondoloma wendo orumu kinie kanokolie we maku toko moloringi yambomane paa konopu aisili liku munduku, Pulu Yemo ene Isirele yamboma nokorumu popo toringi Pulu Yemo kapi ningu imbi ambolko ola linjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kanu kinie Yesusini yu lombili andolimendo “Na moliona wai.” nimbelie enendo nimbendo: “I yambo maku toko molemelema na kondo tekemo. Wale yepoko na kinie molongi, pe kinié ga nonge te naa lemo. Ene langi naa nongo we pungí kinie aulkena kimbu ki pange mange tepa, topa ne munde ya munde temba kene ‘ene engele tepa pepili ulkendo pai.’ naa nimbú.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aku nirimu kinie pilkulie yu lombili andolimene ningindu: “⸤Sike nikinu nakolo⸥ i kolea ku leline molemolo. I yambo paa aisili manda nonge mele pillawa kaloli tena lembana lipu simulúye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesusini enendo “Pillawa kaloli nambepa nosikimiliye?” nimbe walsirimu kinie enene “Pillawa kaloli yepoko pakara kinie oma wallotolo kinie nosikimulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kanu kinie yuni maku toko moloringi yambomando “Manie molai.” nimbelie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","pillawa kaloli yepoko pakara kinie omama kinie lipe Pulu Yemo kinie “Ange.” nimbe, langi akuma pike lepa yu lombili andolime sirimu kinie enene yamboma moke teko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yamboma pali nongo keri piliringi. Pe langi kakena lerimuma lombili andolimene liku wale basiketemanga lakiliringi, wale aili yepoko pakara peke lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ye po tausinini aku langime noringi. Ambo ambolangoma kinie pea langi noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kanu kinie Yesusini maku toko moloringi yambomando “Ulkendo pai.” nimbelie nirimumuni, nona andoli sipi tenga suku pupe, ⸤nomuna nekendo⸥ kolea Makatane* purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","⸤Kolea Makatane purumu⸥* kinie Yesusi molorumuna Parisi yema kinie Sadusi yema kinie** ene ongo, ‘Yuni nambe tembanje? Kanamili.’ ningu yu manda manjiku*** mawa tekolie ningindu: “Ungu Mane Silimu, ‘Nu sike Pulu Yemone ‘Kongono tenjeni.’ nimbe ya mana lipe mundurumunje kanamili.’ ningu mulu koleana molemo Pulu Yemone mindi manda ulu tondolo telemo mele te tei.” niringi.**** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesusini pundu topa nimbendo: “Ipupini ena pumbendo mulúmu kondoli telemo kinie kanokolie ‘wale peangamo wendo ombá.’ nilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ipulueli ou kolea tangombando kolea kupe topa mulúmu sumbulu tolemo kinie kanokolie* ‘Lo ombá lemo.’ ningu pilimele kanumu. Mulúmu kanokolie ‘koleamo i sipe i sipe temba.’ ningu kanolemele nakolo i walemanga uluma wendo olemoma kanokolie ulumanga pulumu manda naa pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kinié mana molemele yamboma yambo kerime mindi molemele. Ene teko kenjiku Pulu Yemo liku su silimele kanu yambomane “Pulu Yemone mindi ulu tondoloma manda telemo mele kanamili tei.” ningu na mawa telemele. Nakolo ⸤Pulu Yemone na lipe mundurumuna ya ombo molkoro. Yu kinie tapu topo kongono telembolo mele⸥ lipe ora simbe ulu tondolo te wendo naa ombá. ⸤Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye⸥ Jonane terimu* ulumuni mindi lipe ora silimo mele manda kanonge. Te pea wendo naa ombá.” nimbelie ene mundupe kelepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ene ⸤nomu Gallilli⸥ nekendo pungindu ⸤Yesusi⸥ lombili andoli yema pillawa kaloli komu siku na mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","⸤Kanu kinie⸥ Yesusini enendo ⸤lepi lepi topa ungu iku topalie⸥ nimbendo: “Paa mimi siku kanai! Parisi yema kinie Sadusi yema kinie* enene pillawa akoli mele isi nosilimelemo kanoko konjei!” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aku sipe nirimu kinie pilkulie yu lombili andoli yemane eneno kerepali ningulie ningindu: “Olio pillawa kaloli ⸤nomolo⸥ mare na lipu membo omulumunge aku sipe nikimunje.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aku siku niringi mele pilipelie Yesusini enendo nimbendo: “Ene ‘nane manda lipe taponjimbe.’ ningu wallo kolte mindi pilimele yema, “Pillawa kaloli naa memulu.” ningu nambemuna kerepali nikimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ene kinié kepe naa pilku konjilimeleye? Pillawa kaloli te pakara ye pape tausini moke teko siringi mele komu silimeleye? ⸤Nongo pora siringi kinie⸥ langi kakena lerimuma liku wale basikete aisili toko peke siringi mele komu siku na pilkimiliye?* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Molo pillawa kaloli yepoko pakara moke teko ye po tausini siringi mele naa pilku, ⸤nongo pora siringi kinie⸥ wale basikete aili mare langi kakena lerimuma toko peke siringi mele naa pilku molemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‘Yuni sike pillawa kalolimundu naa nikimu.’ ningu nambemuna naa pilíngiye?* ‘Parisi yema kinie Sadusi yema kinie pillawa akoli mele isi nosilimelemo mimi siku kanangi.’ nimbu nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yuni aku nirimu kinie pilkulie enene ‘pillawa kalongendo isi mundulimele akumundu naa nikimu. Parisi yema kinie Sadusi yema kinie enene ungu mane siringi ungumando nikimu.’ ningu piliringi. ⸤‘Parisi yema kinie Sadusi yema kinie enene ungu mane mare kolo toko siringime yunge lombili andolimene paa na piliengi!’ nimbe nirimu mele ningu piliringi.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesusi kolea aili Sisaria Pillipai lerimu koleana pupelie nirimumuni, yu lombili andolimendo walsipelie nimbendo: “Manie Omba Mana Ye Au Lerimu Yemondo yambomane yu imbi lelko nae nilimeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Enene yundu ningindu: “Marene “Nu No Linjili Jono ⸤kolorumu, kinié kelepa lomboropa ola molemo⸥.” ningu pilku, marene “Nu ⸤Pulu Yemone ou konde molopili olando lirimu ye⸥ Illainja* kelepa omba molemo.” ningu pilku, marene nu “Jeremaya** molo Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye ⸤ou kolorumu kinié lomboropa ola molemo⸥ te lupe.” nilimele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aku niringi pilipelie Yesusini enendo nimbendo: “⸤We yambomane aku siku nilimele⸥ nakolo ene eneno na nae nilimeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimono Pitane pundu topa nimbendo: “Nu Konde Molopa Mindi Puli Pulu Yemonga Malo,* ⸤Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ ou nimbe mako torumu ye nomi⸥ Kirasimu.”** nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yuni aku nirimu pilipelie Yesusini yundu nimbendo: “Jona* Malo Saimono, nu malo. I nikinumu mana yambo tene nu na nimbe simu. Tara mulu koleana molemomone nimbe simu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ungu te pea nundu nikirula: Nunge imbi Pita, (kanu imbimunge ungu pulumu ‘kou’ kanumu). Kanu koumunge ola* nanga yambo talapemo** lipu maku topo monjimbu. Kanu kinie kololi ulu pulumunge tondolomone i nanga talapemo topa manie manda na mundumbe, molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pulu Yemo ye nomi kingi molopa yamboma nokomba ulke kimu* nu simbu. Kanu kinie nuni mana meltendo “Molo.” nini mélemo mulu koleana sukundu “Molo.” nimbéla. Nu mana meltendo “Kapola.” nini mélemo mulu koleana sukundu “Kapola.” nimbéla.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kanu kinie yu lombili andolimene Yesusindu “Pulu Yemone “Ene nokopa konjimbe yere lipu mundumbu.” nimbe mako torumu ye nomi Kirasimu nu ongo moleno.” niringi kanu ungumundu yuni enendo tondolo mundupe nimbendo: “Enene anju yambo telurindu kepe na kanu yemo molio mele ⸤isili ou⸥ paa na ningu siei!” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kanu kinie Yesusi yu lombili andolimene yundu ⸤“Pulu Yemone olio “Nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu nu.” ningu, ningu para siringi kinie pilipelie⸥ yuni yu kinie wendo ombá mele pulu monjipe* ene sumbi sipe nimbe sipelie nimbendo: “‘Na mindili aisili nombondo kolea aili Jerusalleme paa pumbu.’ nimbu pilipu molio.** Juda yamboma nokolemele tapu yema kinie, Pulu Yemo popo tonjili ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane silimele yema kinie,*** enene na paa toko mindili konjingí. Na toko konjingí kolombo kinie wale talo omba pumbe kinie yepoko sipemonga Pulu Yemone nando ‘Lomboroko ola moloi.’ nimbé.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","⸤Aku nirimu kinie pilipelie⸥ Pitane yu anju lipe memba pupelie yu pulu monjipe iri topalie nimbendo: “Ailimu, aku siku paa naa ni! Nu nikinu mele aku sipe paa wendo naa ombámo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nakolo ⸤yuni kurumanga nomi Setenene ungu umbu tonjirimu mele pilipelie nirimuna pilipelie⸥ Yesusini topele topa Pitando nimbendo: “Setene,* nu anju pa! Pulu Yemone nando “Tei.” nirimu kongono tembo tekeromo pipi sini tekeno kene nu anju pa! Nuni na teko embambo sini tekeno. Nu Pulu Yemone konopu lemo mele naa leno. Yambomane konopu lemele mele mindi leno.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kanu kinie Yesusini yu lombili andolimendo nimbendo: “Yambo tene ‘Yu lombili pambo.’ nimbelie yuni yunge konopumuni pilimo melemanga ‘Topo manie mundembo.’ nimbe yamboma unju perana angilku mindili nongo kolemele mele yuni unju pera mele gomo lembando ‘Na yu lombili pumbundu mindili nondu liemo papula; kolondu liemo papula.’ nimbelie na lombili opili. We na opili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yambo tene yunge mana molopa na kololi ulu pulumu ambolomba temba kinie yu kolopalie sike molopa kenjipe mindi pumbe. Nakolo yambo tene na konopu monjipelie nanga kongonomo “Tenjembo.” nimbe temba kinie yu kolopalie yu konde molopa konjipe mindi puli ulu pulumu sike kanopa limbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","⸤Akumu nambemuna nikiruye?⸥ Yambo tene mana melema pali yu yuyu lipe nosipelie yu mini pali Pulu Yemo na molomba koleana pupe mindili nomba molopa kenjilkenje kanu melemane kanu yambomo nambe tepa lipe taponjilkenje? Lipe na taponjilkemo. Molo yambo tene ‘Na mini pali konde molopo konjipu mindi pambo.’ nimbelie yu nambolka meltene mini pali konde molopa konjipe mindi puli ulu pulumu topo topa lilkeye? Meltene manda topo topa na limbe.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Manie Omba Mana Ye Au Lerimu Yemo pe Lapanga tondolo pa telimu kinie* yunge ⸤mulu koleana⸥ angelloma kinie pea ombá. Ombalie yuni olio ya mana yamboma yu mele mele telemolo ulumanga olio yu mele mele pundu tombamonga nane aku nikiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nane enendo paa sike nimbu sikirumu: Ene ya angilkimilimenga mare ou kolou na kolangi Manie Omba Mana Ye Au Lerimu Yemo ye nomi kingimu omba molopa melema kinie yamboma kinie pali nokomba* ombá kanonge.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesusini ⸤yu lombili andolimendo aku sipe nimbe sirimu kinie⸥* pe koro te omba purumu kinie Pita keme Jemisi keme Jemisi angenu Jono keme ene lipe memba pupe mulú** paa olandopa polorumu tenga ola purumu. ‘Olio oliolio mindi molamili.’ nimbe ene akuna lipe memba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Akuna puringi kinie ene kanoko molangi yunge kangimu alowa tepa, yunge kumbikeremo ena tondolo topa yambomanga mongo takele telemo mele pa aili tepa tepa, yu pakorumu mulu wambalema pa telemo mele aku sipe kake terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yu aku sipe molopili, ⸤Juda yambomanga koronga ou moloringili ye aili talo,⸥ Mosisi kinie Illainjatolo ongolo Yesusi kinie ungu ningulu mona angiliringili kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kanu kinie Pitane Yesusindu nimbendo: “Ailimu, olio ya molopamolo peanga lepamo. Nuni “E.” ninu liemo, ulke takaye yepoko takonjimbu. Te nunge, te Mosisinge, te Illainjanga takonjimbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yuni aku sipe nimbe molopili kupe tondolo pa teli te omba ene aki torumu kinie kupena suku ungu te wendo ombalie nimbendo: “I yemo nanga konopu monjilio Malomo.* Yu kanopo paa peanga kanolio. Yuni ungu nimbéma pilku liengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aku nirimu pilkulie yu lombili andoli ye ⸤yepoko⸥ paa mini wale mundukulie mana manie molko tamalu peringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ene tamalu peringine Yesusi omba ene ambolopalie nimbendo: “Mini wale na munduku ola angiliei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe olando siku kanoringi kinie Yesusi yuyu molorumu kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mulú polorumumunge manie onge oringi kinie Yesusini ene mane sipelie nimbendo: “Enene kinié kanongi mele isili ou yambo teluri kepe ningu na siengi. Pe mindi, Manie Omba Mana Ye Au Lerimu Yemo kolopalie lomboropa ola molomba kinie temanemo toko anju siengi. Ou molo!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aku nirimu kinie pilkulie yu lombili andolimene ⸤yu sike molorumu mele ningu kanokolie⸥* yundu walsiku pilkulie ningindu: “⸤Pulu Yemone ‘olio nokopa konjipe lipe mundumbu.’ ou nimbe mako torumu ye nomi Kirasimu nu liemo⸥ Pulu Yemonga ungu manemanga puluma pilku mane silimele yemane “Illainja ⸤kelepa⸥ kumbi lepa ombá. ⸤Ye nomi Kirasimu pe akilipe ombá.⸥” nilimele mele** nambemuna nilimeleye? ⸤Illainja kelepa na opili nu koronga orunu moleno kanumu.⸥” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesusini pundu topa nimbendo: “ “Illainja ⸤kelepa⸥ kumbi lepa ombalie melema pali tepa mimi temba.” nilimele kanumu sike nilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nakolo ⸤akumunge ungu te pea nimbu sikirula.⸥ Pilieme. Illainja koronga orumu. Yu orumu kinie ⸤kanu yemane⸥ yu kanoko imbi na siku ‘Yu we yere.’ konopu lelkolie ‘Yu kinie temolo.’ ningu piliringi uluma pali teringi.* Aku siku mele Manie Omba Mana Ye Au Lerimu Yemo** mindili liku singíla.”*** nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aku sipe nirimu kinie pilkulie lombili andolimene ‘No Linjili Jonondo nikimu.’ ningu piliringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","⸤Yesusi kinie yu lombili andoli ye yepoko kinie⸥ ene ⸤muluna manie⸥ ongolie yamboma maku toko moloringine oringi kinie ye te Yesusi orumuna omba koporongo langopa ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mawa tepalie nimbendo: “Ailimu, nanga kangomo kondo koloyo. Yu kuru kopalli tolemona mindili aili tepa nolemo. Taki taki yu tepena pupe nomanga pulimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nu lombili andoli yema molongine kangomo membo ondu kinie enene yu manda teko konde na língi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aku nirimu kinie pilipelie Yesusini ⸤yamboma iri topalie⸥ nimbendo: “Kinié molemele yamboma ene ⸤‘Pulu Yemone uluma sike manda temba.’ ningu⸥ tondolo munduku na pilimele. Ene konopu karaye tepa pepili molemele yamboma, na ene wale nambe tepo mane sipu ulu mare lipu ora simbu kinie mimi siku pilingíye? ⸤Na ene kinie siye tekemo.⸥” nimbelie “Na moliona kangomo mengo wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mengo oringi kinie Yesusini kanu kurumu iri torumu kinie yu kangomonga ⸤konopuna⸥ omba wendo purumu kinie kanu enamonga kangomo manda molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aku terimu kinie kanokolie Yesusi lombili andoli yema Yesusi yuyu molorumuna ongo walsiku pilkulie ningindu: “Kuru akumu olione nambemuna manda na makoromuluye?” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesusini pundu topa nimbendo: “ ⸤‘Pulu Yemone sike olio lipe taponjimbe.’ ningu⸥ tondolo munduku na pilimelemonga ulu tondolo isilime manda na telemele. Nane ene paa sike nimbu sikirumu: Unju tenga mongo akumu mele paa kanga nakolo kanu mongomo mana mundulimele kinie unju akopa ai lepa angilimo mele, aku sipe enene ‘Pulu Yemone olionga unguma pilimbe. Olio lipe taponjimbe.’ ningu wallo kolte mindi pilkulie i polemo mulúmundu “Anju puku ne koleana angili.” ningí kinie sike aku sipe pupe angilimbe. ‘Teamili.’ ningí ulumanga ulu manda na tenge ulu te na pemba.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Pulu Yemo mawa teko langi mi toko na nongolie kuru isilime yambomanga konopumanga manda makoronge. Ulu tondolo isilime we manda na tenge.)” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","⸤Pe walse,⸥ kolea Gallilli disiriki puku moloringi kinie Yesusini yu lombili andolimendo nimbendo: “Manie Omba Mana Ye Au Lerimu Yemo ⸤ka sikulie yu tonge⸥ yema anju singí kinie* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","enene yu toko konjingí. Kolopalie wale yepoko sipemonga Pulu Yemone yundu ‘Lomboroko ola moloi.’ nimbé.” nirimu. Aku nirimu pilkulie enenga konopuna sukundu meme kulupi perimuna pilkulie paa kondo koloringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pe Yesusi kinie yu lombili andolime kinie Kapeniame taonona oringi kinie Pulu Yemo popo toringi ulke tembelemonga kou takisi* liringi yema ongo Pita walsikulie ningindu: “‘Nunge ungu mane sili yemone ulke tembelemonga kou takisi tolemo.’ konopu lekemolomo. Sikeye?” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitane “Tolemo.” nirimu. Kanu kinie Pita ulkena sukundu pupelie ungu te nimbé terimu kinie Yesusini yu ou walsipelie nimbendo: “Saimono, nu nambolka konopu lekenoye? Ye nomi kingimene kou takisi lupe lupema lingíndu namele “Tai.” nilimeleye? Enenga yamboma kinie kou takisi limele molo yambo lupema “Tai.” nilimeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitane pundu topa nimbendo: “Yambo lupemando “Takisi tai.” nilimele.” nirimu. Aku nirimu kinie pilipelie Yesusini yundu nimbendo: “Aku liemo kingimunge* yambomane takisi na tonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nakolo takisi na tombolo kinie ulke tembele takisi limele yemane olto kanoko keri kanonge kapola na temba kene* nomuna puku uku mundupani. Uku mundukulie oma te toni aku omamonga keremo aká tenjini kinie kou te** pemba, aku koumu likulie mengo puku oltonga pea liku tere lelko takisi toi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aku walemonga Yesusi lombili andolimene yu molorumuna ongo yu walsiku pilkulie ningindu: “Pulu Yemo ye nomi kingimu molopa nokolemo* yambomanga nae paa olandopa molemoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Enene walsiringi mele Yesusini pilipelie yu ambolango kanga te “Na moliona oi.” nimbe ene moloringine monjipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","enendo nimbendo: “Nane ene paa sike nimbu sikirumu: Ene konopu alowa teko ambolango kangama mele na molongi liemo Pulu Yemo ye nomi kingimu molopa yamboma nokolemo koleana* suku paa manda na pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akumunge yambo tene ‘Na we yambomo molambo. Nanga imbi te olandopa na molopili.’ nimbe i ambolango kangamo mele na molemo yambomo yu Pulu Yemo ye nomi kingimu molopa nokolemo kolea na yambo imbi paa mololimu molemo.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“⸤I ambolangomondo ungu te pea niembo:⸥ Yambo tene ‘Na Ailimunge yambomo molio.’ nimbe i ambolangomo mele lipe taponjimbe kinie kanu yambomone aku tembamonga na lipe taponjimbela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nakolo yambo tene i ⸤ambolango⸥ kangamonga ⸤mele yambo⸥ te ⸤na ‘Sike’ nimbe⸥ tondolo mundupe pilimo ⸤ambolango⸥ kanga te* ‘Ulu kerime tepili.’ nimbe kondi tombamonga kanu ⸤ambolango⸥ kangamo tondolo mundupe pilimo mele mundupe kelepa bulu simu liemo ⸤ambolango⸥ kangamo ou kondi na topili kou paa aili te** moko toko nomine lenjiku ‘Yu kamu kolopupili.’ ningu paka toko nomuna paa maniekondo mundulimelkanje paa papu.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“⸤Na⸥ ‘Sike’ ningu tondolo munduku pilimele yamboma kelko bulu siku munduku kelenge uluma ya mana lemomonga na ene kondo tekemo. Sike aku sipe uluma wendo ombá nakolo yambo tene nanga yambo te kondi tombamonga kanu yambomo na bulu sipe anju pumu liemo kanu kondi tomba yambomo mindili nomba paa molopa kenjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nunge kitolone molo kimbutolone ulu pulu keri te temu liemo aku kitolo molo kimbutolo karu lelko ele teani. Nu konde mololiku mindi puni koleana* kitolo molo kimbutolo na angilipili puni kinie peangamo. Nunge kimbu ki pali we angilipili tepe na kumbulupe nomba pepa mindi pumbe koleana liku toko mundungí kinie kerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Molo nunge mongotolone melte kanokolie konopuni ‘liemboa.’ ningu pilku ulu pulu keri te tenu liemo aku mongotolo akuku ele teani. Nu konde mololiku mindi puni koleana mongotolo na angilipili puni kinie peangamo. Mongo talo we angilipili nu tepe koleana suku liku toko mundungí kinie kerimu.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“I ambolango kangama ⸤mele yamboma⸥ nga te* kanoko keri kanoko ‘Yu koropamo.’ ningu paa na teangi. Enenga nokolemele mulu koleana angelloma** alieli Tara mulu koleana molemona pea molemele kene ⸤aku na teai⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Manie Omba Mana Ye Au Lerimu Yemone ‘Yambo aulke lou lelko molko kenjilimele yamboma koropo lipu taponjembo.’ nimbe orumu kanumu.)”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ene nambolka ningu pilkimiliye? ‘Ye tene kongi sipisipi pape paono monjilke kinie, te talopa lelkanje, yuni sipisipi po paono tene kelepa nani wema ma pangine molangi mundupe kelepa pupe, talopa lelka sipisipimu kanopa limbendo korolipe na pulke.’ konopu lekemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nane enendo paa sike nimbu sikirumu: Sipisipi talopa lelka kanumu kanopa lipelie kanu sipisipimu kinie paa olandopa konopu silke. Talopa na lemelkama we konopu silke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aku sipela enenga Lapa mulu koleana molemomone i ambolango kangama ⸤mele molemele yamboma⸥* ‘aulke lou lelko molko kenjingí kinie paa keri.’ nimbe molemola.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“⸤Na lombili andolimenga⸥ angenu tene nu* tepa kenjimu liemo nu puku tepa kenjimbe yambomo pea eltelte molangili kanu ulu pulu kerimu yuni nu temba mele ningu sieni. Nuni nini ungumu tepa kenjimbe angena pilimu liemo angena kinie elte altoko kapola kapola molongele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nakolo nuni nini ungumu yu na pilimu liemo pe nuni ‘I ungumu pora nipili kene tembo mele yambo mare kanoko molangi altopo niembo.’ ningulie, kanonge yambo talo molo yepoko liku angena molombana mengo ongo ene kanoko molangi angenando ‘Teluna molambili.’ altoko nieni.* Kanu kinie nuni teni kinie angenane temba mele kanu yambomane kanokolie yambo lupemando manda temane toko singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kanu kinie yuni enenga ungumu kepe na pilimu liemo Kirasinge yambo talapemondo* puku ningu sieni. Pe Kirasinge yambo talapemo* kepe angenane na pilimu liemo ‘Yu olionga angenu molo. Yu ulsukundu molko konopu alowa na teli yamboma mele** molemo lemo.’ ningu kanayo.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","* “Nane enendo paa sike nimbu sikirumu: Ya mana enene ⸤uluma kinie yamboma kinie⸥ “Molo.” ningí kinie Pulu Yemone mulu koleana sukundu “Molo.” nimbéla; enene mana “Kapola.” ningíme Pulu Yemone mulu koleana sukundu “Kapola.” nimbéla.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“⸤Akumunge⸥ nane enendo ungu te pea nimbu sikirumu: Enenga yambo talone ya mana “I sipu mawa teambili.” ningu panjíngili liemo eltene mawa tengele mele mulu koleana molemo Tarane eltenga mawa tengele mele aku sipe tenjimbe.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yambo ⸤wallotolo,⸥ talo molo yepoko, na enenga Ailimu imbi lelko walsiku, ‘Pea tapu topo molemolo.’ konopu lelko maku toko molemelemanga na ene kinie molemolona ⸤mawa tenge mele Tara yuni aku sipe tenjimbemo⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","⸤Yesusini yambo teko kenjilimelemando ungu mane aku sipe sirimu⸥ kinie yu molorumuna Pita nondopa ombalie yu walsipe pilipelie nimbendo: “Ailimu, nanga angenu tene na wale nambepa tepa kenjimbe kinie na we ‘Manie pupili.’ nimbu siye kolomboye? Wale sepene yuni temba mele siye kolopo we molopolie engaki sipemonga ‘Pundu topili.’ nimbú kinie papuye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesusini pundu topa nimbendo: “Nane “Wale sepene mindi yuni nu tepa kenjimbe kinie yuni tembama siye kolko altoko pilku na moloi.” ni na nikiru. “Wale sepene anderete sependi sepene yuni nu tepa kenjimbe walema pali yu tepili, siye kolko we moloi.” nikiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Akumunge Pulu Yemo ye nomi kingimu molopa melema nokolemo* akumu i sipe mele: “Walse ye nomi kingi tene yunge kongono nokonjiringi kendemandema kinie pundu angilirimuma ‘ “Kinié mimi sipu kanopolie pundu tangi.” niembo.’ nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aku sipe nirimu kinie kingimuni kou tene milliene kina mele* ou pundu angilirimu ye te kumbi lelko yu molorumuna mengo oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nakolo yu manda aku kou pundumu tomba aulke te paa na lerimuna ailimuni nimbendo: “Kapola, i yemo kinie yunge ambo ambolangoma kinie yunge melema pali kinie makete teko kou mone likulie* koumu ongo pundu tonjengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aku nirimuna pilipelie kendemandemo ye nomimunge kumbikerena koporongo langopa tamalu pepa mawa tepalie nimbendo: “Nuni na kondo kolko we nokoko moloyo. Nane pundu pali tombo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","⸤Kanu kinie⸥ ye nomimuni yunge kendemandemo paa kondo kolopa yu kendemandemo kinie pundu angilirimuma pali “Yu tepili. Altoko pundu na tani.” nimbe kamu siye kolopa yemo ka na sipe “We pui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nakolo ⸤ka singí teringi⸥ kendemande kanumu yu pena pupe kendemande te yunge kou wane anderete kina mele sirimumu kanopalie, yu pupe yunge nomine ambolopa ‘Yu kolopili.’ nimbe ambolopa elkele lakurupelie “Nanga kou sirindumu pundu toi!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aku terimu kinie yuni tomba terimu yemo yunge kumbikerena koporongo langopa tamalu pepa mawa tepalie nimbendo: “Nuni na kondo kolko we nokoko moloyo. Nane pundu pali tombo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nakolo kendemande lupemone “Molo, paa isili pundu tani.” nimbelie “Nu ka ulkena pekolie pundu toko pora siku wendo wani.” nimbe yu ka sipe ka ulkena panjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yuni aku terimu mele kendemande wemane kanokolie ene konopu keri panjiku puku enenga ye nomimundu kendemandetolo teringili kanoringi mele kondi toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kanu kinie ye nomimuni aku niringi pilipelie kendemande yunge pundu “Naa toko we pui.” nirimu kendemande kanumu “Yando oi.” nimbelie yundu nimbendo: “Kendemande kerimu, nuni na tondolo munduku mawa tenuna nu na kinie pundu paa aili tepa angilirimumu “Yu tepili, na toi.” nimbulie we siye kolondu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pe nane nu we kondo kolondu mele nuni aku siku kendemande te nambemuna kondo na kolonuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ye nomimuni yu mumindili kolopalie ka ulke nokoko ka ulkena peringi yamboma teko mindili konjiringi yema yu lipe sirimu. Yuni nimbendo: “Nu mindili nongolie pundu tani. Ou pundu pali toko pora sikulie pe mindi wendo wani. Ou molo.” nirimu.” ⸤nimbe Yesusini nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","⸤Yesusi yuni aku nimbelie ungu ikumunge pulumu kamu nimbendo:⸥ “Aku sipela, angenalini ene aku siku teko kenjingí kinie ene kerena mindi “Manie pupili. Siye kolkoro.” we ningu, sike munduku na kelko, we konopuni pilku molongi liemo, ⸤kendemandemonga ye nomimuni kendemandemo tepa kenjirimu mele⸥ mulu koleana molemo Tarane siye na kolko we konopuni pilku molonge yambo kanuma enenga ulu pulu kerime ‘Manie na pupili.’ nimbe, we siye na kolopa kanu ulu pulu kerimenga “Mindili nangi.” nimbe aku tembala.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesusini aku sipe unguma nimbe pora sipelie nirimumuni, kolea Gallilli disiriki mundupe kelepa kolea Judia disiriki pupe no Jodane lumbilipe nekendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kanu kinie yambo aisili yu lombili oringi kinie yuni kuru torumu yamboma tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi ye mare* yu molorumuna ongo ‘Yu nambolka nimbenje? Nimbe kenjimbenje manda manjipu piliemili.’ ningu** yu walsiku pilkulie ningindu: “Ye tene yu yuyu pilipelie yunge ambomo “Kamu pui.” nimbé kinie kapola temba molo aku temba kinie ungu mane te pulue tombaye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yuni anju pundu topa nimbendo: “Pulu Yemone ungu nirimu yunge bokuna molemo mele kanoko kambu na tongiye? Ou pulu pulu, Pulu Yemone melema tepalie, yuni yambo tembando yemo kinie ambomo kinie tepalie* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nimbendo: “Aku sipu tendumunge ye tene ambo te lipelie yunge anumu lapatolo mundupe kelepa yunge ambomo kinie eltelte teluna tapu toko peko kangi telumu mele ⸤molkolo eltenga konopu teluna pupili⸥ molongele.”* nirimu kanumu na pilíngiye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pulu Yemone aku sipe nirimuna ye te ambo te limo kinie kangi telumu mele molembelena elte altoko talo mele na molembele, elte yambo telumu mele molembele. Yambo telumu molembele kene Pulu Yemone ambo ye talo ‘Telumu molangili.’ nilimo ambo yetolo yambo tene liku lupe lupe na mundengi. Aku tengi liemo kapola na temba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aku sipe nirimu kinie enene ningindu: “Aku liemo Mosisini ungu mane te sirimu mele nambemuna sirimuye? Mosisini nimbendo: “Ye tene yunge ambomondo ‘Kamu pupili.’ nimbe makorombando ambomo “Kamu pui.” nimbé mele pepá te topa ambomo sipelie yundu “Kamu pui.” nimbe aku tepili.” nirimu kanumu.”* niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesusini nimbendo: “Mosisini sike aku sipe nirimu nakolo ene kara puku Pulu Yemone ambo yetolo kapola kapola molongele mele ungu mane sirimumu liku su siku na piliringine yuni “Aku teangi.” nirimu. Nakolo ou pulu pulu, ⸤Pulu Yemone melema kokele tepa mimi terimu kinie⸥, ungu mane aku sipe te na perimu kene ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","nane ene i sipu nimbu sikiru: Ye tene yunge ou limo ambomo makoropa “Kamu pui.” nimbelie kelepa ambo te limo kinie aku yemone wa ulu kerinele telemo. Yemonga ambomone ye te kinie wa ulu kerinele temu liemo manda topa makoromba. We molo. (“Pui.” nimbe makorolemo ambomo pe ye tene yu limo kinie kanu yemo kepe wa ulu kerinele telemola.)”* nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","⸤Yuni aku nirimu kinie pilkulie⸥ yu lombili andoli yemane yundu ningindu: “Ye tene ambo limo kinie nuni nikinu mele aku siku molongele mele ungu mane te pelemo liemo ye te ambo na lilkenje papu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nakolo Yesusini pundu topa nimbendo: “I ungu ⸤mane sikirumu⸥ yambomane pali manda na pilku lingí. ⸤Pulu Yemone⸥ mako topa tondoloma simbe yamboma mindi manda ⸤amboma ye na puku yema ambo na liku⸥ tenge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye mare anupilini melemele kinie amboma kinie teluna tapu toko peko ulu kerime tenge enge te na pelemo. Ye mare ‘Amboma kinie teluna na peangi.’ ningu enenga láka tonjilimele.* Marene eneno ‘Ye nomi kingi Pulu Yemonga yema molopo yunge kongonoma manjipu tenjemili.’ ningu ene eneno mi lelko ambo na limele. I ungumu yambo pilku lingí yamboma piliengi!” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kanu kinie yambomane enenga ambolangoma ‘Yesusi yunge kimuni ambolopa Pulu Yemo kinie enenga mawa tenjipili.’ ningu yu molorumuna mengo oringi. Nakolo yu lombili andolimene iri toko ⸤“Naa mengo wai.”⸥ niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","⸤“Molo.” niringi kinie⸥ kanopalie Yesusini nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yambo talape* akumu i ambolangoma mele molemele yamboma enenga yambo talapemo kene enene i ambolangoma na moliona wangi pipi siku “Molo.” na niei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aku nimbelie yuni ambolangoma ⸤kondo kolopa⸥ yunge kimuni ene telu telu nimbe ambolopalie kanu koleana mundupe kelepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Walse ye te Yesusi molorumuna omba yundu walsipe pilipelie nimbendo: “Ungu Mane Silimu, na nambolka ulu peangamo tembo kinie konde molopa konjipe mindi puli ulu pulumu limbuye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesusini yundu nimbendo: “Nuni na nambemuna ulu peangamondo walsiku pilkinuye? Yambo telu mindi peanga molemo. Nuni ‘konde molopo konjipu mindi puli ulu pulumu limbu.’ konopu lenu liemo ⸤Pulu Yemonga⸥ ungu mane ⸤Mosisini yando nimbe sirimuma⸥ tenge panjiku teko molani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yemone walsipelie nimbendo: “Aku ungu manemanga temando nikinuye?” nimbe walsirimu kinie Yesusini pundu topa nimbendo: “ “Yambo toko na konjengi.” nimbe, “Ambo ye pulime molo ye ambo lilime yambo lupema kinie wa ulu kerinele na teangi.” nimbe, “Melema wa na liengi.” nimbe, “Yambomanga kote kolo toko na tenjengi.” nimbe, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Aminieli lanieli kinie teko konjiku, ungu ningí mele pilku liku teko molangi.” nimbe,* “Ene eneno yu mele mele konopu monjiku enenga kangimu eneno kondo kolko nokolemele mele aku sikula pulu lemo yamboma konopu monjiku nokoko molangi.” nimbe,** ungu mane akuma sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aku nirimu kinie pilipelie kanu kango yemone nimbendo: “Na kanu ungu manema pali pilipu lipu tepo molio. Pe kinié nambolka uluri olandopa teamboye?” nimbe walsirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesusini yundu pundu topa nimbendo: “Nu ‘kamu ye sumbi nilimu* molambo.’ konopu lenu liemo nu puku nunge mele nosilinoma pali kou mone lipukulie, kou mone linime yambo koropama moke teko sikulie na lombili oi.” nirimu. “Nunge ⸤mana⸥ melema aku teni kinie mulu koleana nunge mele aisili lemba.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kanu kango yemo mele paa aisili nosirimuna Yesusini yundu aku nirimu kinie pilipelie yu konopu keri panjilipe anju purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","⸤Aku terimuna kanopalie⸥ Yesusini yu lombili andolimendo nimbendo: “Pulu Yemo ye nomi kingi molopa nokolemo koleana suku pungindu yambo kamakoma paa mindili siku suku pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Enendo altopo nikiru: Kongi kemele ⸤kongi paa aili te* nakolo⸥ kale suru toline suku pumbendo mindili kanga mele sipelie pumbe. Nakolo yambo kamakoma Pulu Yemo ye nomi kingi molopa nokolemo koleana** suku pungindu mindili paa aili mele siku pungí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aku nirimu kinie pilkulie yu lombili andolime paa mini wale munduku suru ningulie anju yando ungu mele tekolie ningindu: “Aku liemo mindili nolemelka aulkena nae manda wendo pupe, molopo konjimulu aulkena pumbeye?* Te molonje.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesusini ene nemo nemo nimbe kanopalie nimbendo: “Sike yamboma eneno manda molo nakolo Pulu Yemone manda tenjimbe. Pulu Yemo yuni uluma pali kapola telemo. Ulu te yuni manda na temba te molo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yuni aku nirimu kinie pilipelie Pitane yundu nimbendo: “⸤Pe olio kinie nambolka uluri wendo ombáye?⸥ Olio olionga melema pali mundupu kelepo nu lombili purumulu pulimolo kene mele nambolka melema limulúye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesusini nimbendo: “Nane enendo paa sike nimbu sikirumu: Pe ⸤Pulu Yemone⸥ melema pali ‘konde pupili.’ nimbé kinie Manie Omba Mana Ye Au Lerimu Yemo yunge ye nomi kingi polo pa tondolo teline molopa yamboma nokomba kinie, ene na lombili andolemele yema pea ye nomi kingi polo rureponga molkolie ningímuni, Isirele yambo talape rurepo* nokonge.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yambo na konopu monjiku nanga kongono tenjingindu enenga ulkema, angenupili, kemulupili, anupili, lapali, ambolangoma, koleama, akuma munduku keleringi yamboma pali, ya mana paa olandopa mele aisili likulie, konde molko konjiku mindi puli ulu pulumu lingíla.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nakolo kinié aili molemele yambomanga aisili pe ⸤Pulu Yemo ye nomi kingi molopa nokomba koleana⸥ yambo koropama molonge; kinié koropa pupili molemele yamboma pe yambo ailime molonge.” ⸤nimbe Yesusini nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aku nikiru ungumunge* ⸤ungu te niembo⸥: Pulu Yemone ye nomi kingimu molopa yamboma nokolemo** akumu i sipe mele: “Walse ponie pulu ye tene ‘Kongono tenjili ye mare yunge unju waene poniena kongono tenjengi.’ nimbe paa ipulueli ou pupe lipurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Kongono teangi.” nimbe lirimu yemando nimbendo: “Kinié tenge walemonga ene kou mone pape kina* pape kina nimbu mele kalombo.” nirimu kinie enene “Kapola.” niringi kinie yuni ene yunge unju waene poniena “Kongono teangi pai.” nimbe ene lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pe, ipulueli ou nani killoko mele terimu kinie, yu kelepa yamboma maku toringi koleana pupe ye mare akuna we angiliringi kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","enendo nimbendo: “Ene kepe ⸤nanga⸥ unju waene poniena kongono tenjengi payo. Pe nane ene kou kapola mele kalombo.” nirimu ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","kinie ene puringi. Pe ai tangoli terimu kinie kepe, ipupini tere killoko mele terimu kinie kepe, kelepa aku sipe pupe ye mare pea lirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ipupini pape killoko mele terimu kinie ⸤altopa⸥ pupe ye mare we angiliringi kanopalie enendo nimbendo: “Walemonga pali kongono na teko ya inie nambemuna we angilimeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Enene yundu ningindu: “Ye tene olio kongonona na limuna we angilimolo.” niringi. Yuni enendo nimbendo: “Ene kepe ⸤nanga⸥ unju waene poniena kongono tenjipai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ena pora nirimu kinie unju waene ponie pulu yemone yunge kongono nokoli yemondo nimbendo: “Kongono tekemele yema ‘sukundu wai.’ ningu ene kongono tengimunge mele kalonindu paa akilku ongi yema pulu monjiku mele kaloliku puku kumbi lelko ongi yema paa akilku mele kaloi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","⸤Aku nirimu kinie⸥ ipupini pape killoko mele terimu kinie “Kongono tenjengi.” nimbe lirimu yema ⸤kumbi lelko⸥ ongo pape kina pape kina nimbe sirimu liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Akilku ongo kongono tenjiringi yema kou aku siku liringi kanokolie kumbi lelko ongo kongono tenjiringi yema ongolie ‘Olio kou olandopa mele limulú.’ konopu leringi nakolo ene pape kina pape kina nimbe sirimu liringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Likulie enene ponie pulu yemondo iri tokolie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Akilku ongi yema ena telu manjiku kongono tengi, olio ipulueli ou ombo kongono aili tepo temulu, ena aili tomumuni olio paa nomu kanumu, nakolo ene kinie olio kinie kou kapola kapola teko sikinumu, kapola na tekemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yuni enenga ye tendo pundu topa nimbendo: “Kangomo, nane nu tepo na kenjikiru. “Pape kina simbu.” nindu kinie “Kapola.” ninu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kou sikirumu liku mengo puyo. Nanga konopuni mindi pilipulie akilipe omu yemo nu sikiru mele yu aku sipu sindu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nanga nosilio melemanga konopuni pilipulie manda na temboye? Molo pe ongi yema kou aili tepo sindumunge nu konopu keri panjikinuye?” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","⸤Ungu iku akumu topa pora sipelie ungu ikumunge pulumu kamu nimbendo:⸥ “Aku sipela, akilku onge yamboma ⸤Pulu Yemone nokolemo talapena sukundu⸥ kumbi lelko pungí; kumbi lelko onge yamboma akilku pungí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kanu kinie Yesusi kolea aili Jerusalleme pumbe purumu kinie yu lombili andoli engaki rurepo* ‘na kinie ene kinie oliolio molamili.’ nimbe ene lipe anju memba pupelie enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pilieme! Olio Jerusalleme pumulú pukumulu.* Akuna pumulú kinie Manie Omba Mana Ye Au Lerimu Yemo ye tene ‘Tangi.’ nimbe Pulu Yemo popo tonjili ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane silimele yema kinie,** lipe simbe, enene yu kote tenjiku ‘Yu kolopili tangi.’ ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Juda ye na molemele yema liku singí.* Kanu kinie kanu yemane yu ungu taka tonjiku, ka pulsene toko, ‘Yu kolopili.’ ningu unju perana uku toko panjingí. Kolopalie wale yepoko sipemonga Pulu Yemone yundu ‘Lomboroko ola moloi.’ nimbé.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kanu kinie Seperi malo Jemisi kinie Jonotolonga anumu Yesusi molorumuna omba koporongo langopa yundu “‘Nu ulu te teani.’ nimbu mawa tembo okoro.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","yuni yundu nimbendo: “Nambolka uluri ‘nane tenjembo.’ ningu nikinuye?” nirimu. Ambomone nimbendo: “Nu pe ye nomi kingimu moloni kinie i nanga kango talo ⸤‘elte nu kinie pea ye nomime molamili.’ ningu⸥ ‘eltenga te nunge ki umbukundu monjiku te nunge ki tarokondo monjeni.’* nimbu mawa tekero.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesusini enendo nimbendo: “Mawa tekemele mele ene pilku na konjikimili. Na no mingine no nondopo nombomo elte manda nongeleye?”* nirimu kinie eltene “Manda nombolo.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yuni eltendo nimbendo: “Na no mingine no nombomo pe elte paa sike nongele nakolo nane elte “Nanga wangutolonga ongo molangili.” nimbumu kapola na temba. Tarane yuyu akuna molongeletolo koronga mako torumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Angenungulu ⸤Jemisi kinie Jonotolone ‘Yesusinge wangutolonga molambili.’⸥ ningu mawa teringili mele pilkulie lombili andoli ye rureponga talo* ⸤wemane⸥ elte kinie konopu keri panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanu kinie Yesusini ene “Wai.” nimbelie nirimumuni, enendo nimbendo: “Olio Juda yambomanga ulsu molemele yambo talapemanga ye nomime enenga yamboma tondolo munduku nokoko kongono enge nilime alieli silimele. Ye imbi ola molemo yema enenga yamboma ‘Mindili nangi.’ ningu nokolemele. Yambomane enenga ye nomimenga unguma liku su singí aulke te na lemo. Aku siku telemele mele enene pilimele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nakolo ⸤we yambomanga ye nomimene enenga yamboma tondolo munduku nokolemele mele na lombili andoli yema⸥ ene eneno aku siku anju yando na teangi. Enenga ye te ‘Na imbi olandopa molopili. Na ye ailimu molambo.’ nimbé yemo enenga kongono tenjili yemo molopili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘Na enenga ye nomimu molopo ene nokambo.’ nimbé yemo enenga kongono kendemande tenjili yemo molopili.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aku sipela, Manie Omba Mana Ye Au Lerimu Yemo* kepe ‘Yambomanga ye ailimu molopo ene nokambo. Enene nanga kongono tenjili kendemande yamboma molangi.’ nimbe na orumu. ‘Yambomanga kongono tenjili kendemande yemo molopo ene lipu taponjipu, ulu pulu kerimene ene ka sipe nokolemo mele na tepili kapola molangi kene na yambo aisilinge nimbu pundu tonjipu nanga kangimu sipu, enenga kolo wangopo kolonjembo.’** nimbe orumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesusi kinie yu lombili andolime kinie ene kolea aili Jeriko munduku kelko pungí puringi kinie we yambo aisili yu lombili puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kanu kinie mongo keri lerimu ye talo aulke alselsena molkolo Yesusi omba purumu mele pilkululie yundu tondolo ru ningu walsikulie ningilindu: “Ailimu, ⸤ye nomi kingi⸥ Depisini kalopa lirimu yemo,* olto kondo koloi.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yambomane elte iri toko “Ungu na nili taka lelko molale.” niringi. Nakolo eltene paa tondolo ru ningu walsikululie ningilindu: “Ailimu, Depisini kalopa lirimu yemo, olto kondo koloi.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesusi we angilipelie “Elte wale.” nimbelie eltendo nimbendo: “Nane elte nambe teambo konopu lekembeleye?” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","mongo keri lerimu yetolone ningilindu: “Ailimu, ‘oltonga mongotolo ‘Altopa umbu mongo angilipili.’ nieni.’ konopu lekembolo.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kanu kinie Yesusini elte kondo kolopa mongona ambolorumu kinie elte tamburembu mongoma peanga lerimu, melema kanokololie, Yesusi lombili puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","⸤Yesusi kinie yu lombili andolime kinie⸥ ene kolea aili Jerusalleme nondoko ongo, ma pangi te ‘Ma Pangi Unju Ollipi Ponie’ nili akuna lemo kolea kanga Betepasi oringi. Kanu kinie Yesusini yu lombili andoli ye talo lipe mundupelie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","eltendo nimbendo: “Ne kolea kanga kanokombelena pukululie kongi dongi te ka teko panjingímu kinie yunge walomo pea ne sukundu molongele kanongele, kanutolo puku posiku yando mengo wangili pale. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Posingilí teko molongele kinie yambo tene eltendo ungu te nimu liemo eltene i siku niengili: “Ailimu yu ‘Dongimuni mepili.’ nimuna ombo likimbulu.” niengili. Aku ningilí kinie yuni sumbi sipe “Kapola, mengo pale.” nimbé.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aku sipe wendo orumumunge koronga ou Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye tene ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Akumu i sipe: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Enene kolea aili Sayono* yambomando i siku niengi: “Kanayo! Ene molemelena enenga ye nomi kingimu okomo. Yu ye imbi na mololi yemo mele taka lepa molemomo kongi dongi bulu mingine molopa okomo. Kongi dongi tenga walomonga bulu mingine molopa okomo.” ningu, ningu siei.”** nirimu kanumu. ⸤Aku nirimu mele Yesusi terimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kanu kinie lombili andolitolo pukulu Yesusini “Tepale.” nirimu mele tepuringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Eltene kongi dongimu kinie yunge walomo kinie mengo ongololie, enene enenga mulu wambalema kulku dongitolonga bulu mingine ola pauwe toringi kinie Yesusi kanuna ola molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yambo maku toringimenga aisilini enenga mulu wambalema kulku yu ombá aulkena pauwe toliku puku, marene kipiyala gomo langoko liku yu ombá aulkena pauwe toliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kumbi lelko puringi yambomane kepe akilku oringi yambomane kepe naka lelko unju ambololiku pukulie ningindu: “⸤Ye Nomi Kingi⸥ Depisini Kalopa Lirimu Yemo* ‘Imbi ola molopili.’ niemili. Pulu Ye Yawene lipe mundurumuna yunge kongonomo tenjimbe okomo yemo molopa konjipili.** Mulu koleana ola yu imbi ola molopili.” niliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesusi Jerusalleme suku purumu kinie kanu kolea ailimunge sukundu moloringi yamboma pali konopu aisili liku mundukulie “Imu naeye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Maku toko moloringi yambomane ningindu: “Imu Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye Yesusi,* kolea Gallilli disiriki Nasarete taono ye te.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesusi ⸤Jerusalleme suku pupelie nirimumuni⸥ Pulu Yemo popo toko kaloringi ulke tembelena ⸤“Juda yambo na molemele yamboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ suku pupe kanopalie akuna melema makete teko moloringi yamboma kinie, melema topo toko liku moloringi yamboma kinie akuma kanopalie ene pali topa makoropa, kou mone lupe lupema alowa teko anju siringi yambomanga poloma kinie, kera waembono makete teringi yambomanga manie moloringi poloma kinie, topele topa, topa bulu balu sipelie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","enendo nimbendo: “Pulu Yemonga bokuna ungu te i sipe nilimo: ‘Yambomane nanga ulkemondo “Pulu Yemo kinie ungu nilimolo ulkemo.” ningí.’* kanumu. Ungu aku sipe molemo nakolo enene i ulkemo ‘wa nolemele yamboma lopi teko molemele ulkemo’ mele** ningu pilkulie aku siku telemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kanu kinie Yesusi ulke tembelena molopili yambo mongo keri lepa, kimbu ki keri lerimu yambo aisili yu molorumuna oringi kinie yuni ene tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nakolo yuni we yambo tene manda na telka ulu tondolo peangama terimu mele kinie, ulke tembelena ambolangomane tondolo ru ningulie: “Ye Nomi Kingi Depisini Kalopa Lirimu Yemo* ‘Imbi ola molopili.’ niemili.” niringi mele kinie, kanu ulutolo wendo orumu mele kanokolie Pulu Yemo popo tonjiringi ye ailime kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie** enene konopu keri panjikulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yesusi walsikulie: “Andi ambolangomane ungu nikimili mele nu ⸤naa⸥ pilkinuye?” niringi.* ⸤Nakolo⸥ Yesusini enendo nimbendo: “Na pilkiru. ⸤Andi ambolangomane tekemele mele⸥ ungu te bokuna molemo mele ene na kanolemeleye? Kanumu i sipe molemo: ‘Ambolango kangama kinie ambolango pamema kinie ⸤Pulu Yemo⸥ nu paa kapi ningí mele mane sirinu.’** aku ungumu bokuna molemo mele ene na kanolemeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aku nimbelie yu kanu yema mundupe kelepa kolea aili ⸤Jerusalleme⸥ ulsukundu pupe kolea kanga Betani pupe akuna perimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ipulueli ou ⸤Jerusalleme nondopa lerimu kolea Betani mundupe kelepa Yesusi⸥ kelepa kolea aili ⸤Jerusalleme⸥ pumbe purumu kinie yu engele terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kanu kinie yu orumu aulke kélona unju piki te angilirimu kanopalie nondopa pupe kanorumu kinie unju mongo te topa na perimu, gomo mindi terimu kanorumu. ⸤Gomo mindi terimuna⸥ kanopalie “Nu altoko mongo te na tani.” nirimu kinie unju piki kanumu walsikale kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aku ulumu wendo orumu kinie kanokolie yu lombili andolimene paa mini wale mundukulie ningindu: “I unju pikimu nambe tepalie walsikale kolomuye?” ningu walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesusini pundu topa nimbendo: “Nane enendo paa sike nimbu sikirumu: Ene konopu talo tepa na pepili ⸤Pulu Yemone nanga ungumu sike pilimbemonga nimbú mele ‘paa sike wendo ombá.’ ningu⸥ tondolo munduku pilíngi liemo nane i unju pikimu tendu mele manda tenge. Unjuma mindi molola. Ne ma pangimundu “Ungú toko nomu kusana sukundu pui.” ningí kinie pumbela.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","‘Olio ⸤Pulu Yemone paa sike lipe taponjimbemonga ‘Teamili.’ nimulú mele sike manda aku sipu temolo.’ molo ‘Nimulú kinie sike aku sipe wendo ombá.’ ningu⸥ tondolo munduku pilkulie ⸤Pulu Yemo kinie⸥ ungu ningu mawa tenge mele pali Pulu Yemone sike tenjimbemonga kanu uluma sike wendo ombá.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kanu kinie Yesusi ⸤kamu Jerusalleme omba⸥ ulke tembele kerepuluna omba, yamboma ungu mane sipe molorumu kinie ye mare, Pulu Yemo popo tonjiringi ye ailime kinie, Juda yambomanga tapu yema kinie* ene ongo yu walsiku pilkulie ningindu: “Nu namba nambolka nambamo likulie i kongonomo telenoye? Naene i kongonomo ‘Tepui.’ nimbe nu nambamo sipe lipe mundurumuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesusini enendo pundu topa nimbendo: “Nane ene ungu te walsipu piliembola. Pe nane ene walsimbu mele enene na sumbi siku pundu toko níngi liemo ‘Na i kongonomo teambo.’ nimbe namba sirimumunge pulumu ene nimbu simbula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","⸤Nane i sipu ene walsipu pilkiru:⸥ Ou ⸤No Linjili⸥ Jono omba yamboma no linjirimu kinie yu mulu koleana molemo yemonga kongonomo tenjimbendo yamboma no linjirimu molo ya mana yambomanga kongonomo tenjimbendo yamboma no linjirimuye? ⸤Naene “Tei.” nirimuna terimuye? Ningu siei.⸥” nirimu. ⸤Yuni aku sipe walsirimu mele pilkulie⸥ enene eneno kerepali ningulie ningindu: “Yuni walsikimu mele olione pundu topo, ‘⸤Jono⸥ yu mulu koleana ⸤molemo yemonga kongono tenjimbendo yamboma no linjirimu⸥.’ nímulu liemo yuni oliondo nimbendo: ‘Aku liemo ene Jonone nirimu ungumu nambemuna ‘I ungumu sike.’ ningu na pilku liringiye?’ nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Molo olione nimulundu: ‘Yu mana yambomanga ⸤kongono tenjimbendo yamboma no linjirimu⸥.’ nímulu liemo we yambomane ‘olio tongenje’ nimbu pipili kolkomolo. We yambomane ‘⸤No Linjili Jono⸥ yu paa sike Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye te* molorumu.’ ningu pilimele kene olio nambe temolonje?” ningu eneno aku siku kerepali niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","⸤Eneno aku siku anju yando kerepali ningulie⸥, Yesusindu pundu toko ningindu: “⸤Nuni walsikinu mele⸥ olio na pilkimulu.” niringi. Aku siku niringi kinie pilipelie Yesusini enendo nimbendo: “Kapola. ⸤Nane ene walsikiru ungumunge ungu te pundu toko na nikimilimunge⸥ enene na walsikimili ungumunge ungu te pundu topo nando i kongonomo ‘Tepui.’ nimbe na lipe mundupe namba sirimu yemonga imbimu ene na nimbu simbula.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","⸤Yesusini kelepa kanu Juda yambomanga ye ailimendo* nimbendo:⸥ “Ene nambolka konopu lekemeleye? Ye te yunge kango talo moloringili. Yu pupe kango komomondo nimbendo: “Kangomo, kinié nu unju waene poniena puku kongono tepui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Yuni pundu topa lapando “Molo, na na pumbu.” nirimu, nakolo pe yu konopu alowa tepalie purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Lapa pupe komomondo nirimu mele aku sipe akiliomondo nirimu ⸤kinie⸥ yuni pundu topa “Tepumbu.” nirimu, nakolo na purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Kanu kangotolonga naene lapanga ungumu pilipe lipe terimuye?” nirimu. Enene pundu toko “Komomo.” niringi. Yesusini enendo nimbendo: “Nane enendo paa sike nimbu sikirumu: Ene ⸤Juda yambomanga ye ailime⸥ Pulu Yemo ye nomi kingimu molopa nokolemo talapena sukundu* ⸤kumbi lelko na pungí⸥.. Kou takisi lili yema kinie wapora toli amboma kinie ⸤kanu yamboma, ene Juda yambomanga ye ailimene kanoko keri kanolemelema⸥ kumbi lelko pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","⸤No Linjili⸥ Jono omba ene sumbi siku molonge aulkemo lipe ora sirimu kinie enene yu nirimumu ‘Kolo tokomo.’ konopu lelko yunge ungumu pilku na liringi nakolo kou takisi lili yema kinie wapora toli amboma kinie yuni nirimu ungumu ‘Sike.’ ningu tondolo munduku piliringi. Nakolo kanu ambo ye kerimene aku teringi kinie kepe kanokolie ‘Konopu alowa tepo ‘Yuni sike nikimu.’ nimbu tondolo mundupu piliemili.’ na niringila. Akumunge ⸤kanu ambo ye “Tepo kenjilimolo.” ningu konopu alowa telemelema Pulu Yemo molemona kumbi lelko pungí⸥.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","⸤Aku nimbelie Yesusini kanu ye ailimendo* altopa nimbendo:⸥ “Ungu iku te pea tambo pilieyo. “Kolea pulu ye tene unju waene ponie tepalie pala terimu. Poniena sukundu loyekolo akupe waene no ingi tepa monjimbendo tepa mimi tepalie nirimumuni, pe ponie nokonge ulke takaye te polo kulupe ola takorumu. Ye mare kanopa lipelie enendo nimbendo: “Nanga poniemo tapu tenjiku unju mongoma inie toko nokonjengi. Pe waene mongo polo tomba kinie unju mongoma moke tepo, kongono tenjingí mele mare ene liengi mare na liembo.” nimbe kanu poniemo ene sipelie yu kolea paa suluringe pupe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kanu kinie pe waene mongo polo tomba terimu kinie ponie pulu yemone yunge kendemande ye mare “Nanga waene mongo siengi puku liku menjiku wangi pai.” nimbe ponie nokoringi yema moloringine lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nakolo kendemande yema ⸤oringi kinie⸥ ponie nokoli yemane ene ambolko likulie te kopene toko, te toko konjiku, te kouni toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Altopa ponie pulu yemone kendemande ye mare aisili mele lipe “Nanga waene mongo linjipai.” nimbe lipe mundurumu, ou kendemande ye wallotolo mele lipe mundurumu. Nakolo ponie nokoli yemane ou pulu pulu oringi kendemande yema kinie teringi mele pe kendemande oringi yema kinie akula teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kanu kinie ponie pulu yemo yuni ⸤konopuni pilipelie⸥ ‘Nanga kangomo pipili kolko yunge unguma pilku liku, yu waene mongoma singí.’ konopu lepalie yunge malomo lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nakolo ponie nokoli yemane ponie pulu yemonga malo ombá orumu kanokolie enene eneno ningindu: “Andi okomo yemo pe lapanga melema limbe yemo okomo. Yu topo konjipu i poniemo olio kamu liemili.” ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","enene yu ambolko liku poniena ulsu mundukulie yu toko konjiringi.”* ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","⸤Yesusini ungu iku akumu topa pora simbendo kanu Juda yambomanga ye ailimendo walsipelie nimbendo:⸥ “Ponie nokoli yemane aku teringimunge ponie pulu yemo ombalie kanu ponie nokoli yema kinie yuni nambolka uluri temba konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Enene yundu pundu toko ningindu: “Yuni kanu ye kerime ‘kamu molko kenjengi.’ nimbe tepa kenjipelie ponie nokonge ye lupe mare lipe waene mongo polo tomba kinie waene mongoma moke teko, mare ponie pulu yemo singí yema poniemo simbe.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesusini ⸤Pulu Yemonga Juda yamboma nokoringi yemane yu toko konjingí mele pilipelie⸥* enendo nimbendo: “Pulu Yemonga bokuna sukundu molemo ungu te kanoko na pilimeleye? ⸤Aku ungumu i sipe mele:⸥ “Ulke takoringi yemane kanoko keri kanoko toko ele teringi kou kanumu kinié kelepa ulke simu mele ulke enge sinjili kou aili peangamo. Ailimuni aku ulumu terimu olione kanopo paa peanga kanolemolo.”** nimbe molemo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aku ⸤nirimu⸥ munge nane ene ⸤Pulu Yemonga Juda yamboma⸥ nimbu sikirumu: Pulu Yemo enenga ye nomi kingi molopa ene nokolemo mele mundupe kelepalie nimbémone, yambo talape lupe tene yunge ungumu pilku liku teko molongema lipe nokomba.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(I kou ⸤nikiru⸥ munge ola yambo te a topa topalie ombele melema elke tomba. Nakolo yambo te molombana ola koumu omba yu topalie kanu yambomo topa nurupulu tomba.)” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kanu kinie Pulu Yemo popo tonjiringi ye ailime kinie Parisi yema kinie* Yesusini ungu iku torumuma pilkulie enene yu tonge teko moloringi mele yuni nirimu pilkulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","enene yu ka singí teringi nakolo yambomane ‘Yu Pulu Yemone ungu umbu tonjilimoma pilipe yando nimbe silimo ye te.’* konopu leringine yamboma pipili kolkolie yu isili ou ambolko ka na siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesusini kelepa ungu mare ⸤Juda ye ailimendo nimbendo⸥ ungu iku te pea topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pulu Yemo ye nomi kingimu molopa yamboma nokolemo* akumu i sipe mele: “Ye nomi kingi tene yunge malo ambo limbemonga langi aisili kalonjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koronga “Ye ambo limbe langi pea namili sukundu wangi.” nirimu yamboma yunge kendemandemando “ “Kinié langi namili wai.” nipai.” nimbe mundurumu, nakolo puku aku siku niringi kinie ene “Naa omolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Altopa kendemande mare lupe lipe mundupelie nimbendo: “ “Langi pea namili wangi.” nirindu yambomando puku ningindu: “Langi tepa mimi tepa pora simu. Yunge kongi kao peleama kinie kongi kao walo wami telime kinie tomu. Langi pali tepa mimi tepa nosilimo kene ye ambo limbemonga langi pea namili wai.” nipai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nakolo puku niringi kinie na pilku siye kolko, te yunge poniena pupe, te yunge bisinetena pupe, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","marene kingimunge kendemandema ambolko liku teko kenjikulie toko konjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","⸤Aku teringimunge⸥ kingimu mumindili kolopalie yunge ami yemando nimbendo: “Ene molemelena puku toko konjiku enenga koleamo tepe lelko topai.” nimbe ene lipe mundurumu kinie pukulie, nirimu mele teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kanu kinie kingimuni yunge kendemandemando nimbendo: “Ye ambo limbemonga langi nosilimolo nakolo “Pea namili wangi.” nirindu yamboma nonge kapola na temba kene ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ene pukulie aulke lupe lupe lemomanga pali puku yambo kanongema “Ye ambo limbemonga langi pea namili wai.” nipai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pilkulie kanu kendemandema aulkemanga pali puku yambo kanoringime pali liku maku toringi. Yambo peangama kinie yambo kerime kinie pea liku maku toringi. Kanu kinie ye ambo limbemonga koleana yamboma paa ongo si siku moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ongo moloringi kinie kingimu “Yambo maku toko molemelema kanambo.” nimbe ene moloringine ombalie, yamboma ye ambo limbe ⸤makuna ongemonga wale pakoli kamuma ‘pakoko sukundu wangi.’ ningu siringi⸥ wale pakolimenga* ye te wale pakoli akumanga te na pakopa molorumu kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","yundu nimbendo: “Kangomo, nu ye ambo limbe wale te na pakokono kanokoro kene nu aulke tena sukundu onuye?” nirimu kinie kanu yemone unguri na nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanu kinie kingimuni langi nokoringi kendemandemando nimbendo: “I yemo kimbu kime ka tokolie pena kolea sumbulu tokomona toko pena mundei!” nirimu. Akuna yamboma paa mindili nongolie kola teko pereko molonge.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","⸤Aku nimbelie Yesusini ungu ikumunge pulumu kamu nimbendo:⸥ “Sike ⸤Pulu Yemone⸥ yambo aisilindu “Wai.” nilimo nakolo yambo wallotolo mindi* mako topa “Sukundu wai.” nilimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","⸤Yesusini aku sipe nirimu⸥ kinie ⸤pilkulie⸥ Parisi yema* ulsu puku ene eneno liku maku tokolie ningindu: “‘Yesusini ungu te nimbe kenjipili.’ nimbu nambe teamiliye?” ningu kerepali ningulie niringimuni,** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ene lombili andolime kinie ye nomi kingi Erotenga talape ye mare kinie liku Yesusi molorumuna liku munduringi, ene puku Yesusindu ningindu: “Ungu Mane Silimu, olio pilimolo, ‘nuni ungu sikema mindi ningu, Pulu Yemone “Teai.” nilimo uluma paa sike unguma mane siku, nu yambo teluringe kepe konopu kimbu na siku, yamboma pipili na kolko enendo pali ungu telu siku kapola kapola ningu silino.’ konopu lemolo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aku siku ningu molenomonga nu nambolka konopu lekenoye? Olione Romo Gapomano Ye Paa Aili Kumbine ‘Sisa’ nilimu kou takisi tomulu liemo kapola molo moloye? Pulu Yemone akumundu ungu mane sirimu ungu mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nakolo Yesusini yu kinie konopu keri panjiku yu teko kenjingí teringi pilipelie enendo nimbendo: “Ene kolo toko topele mapele toli yema,* ‘Yuni nimbe kenjipili.’ ningu nambemuna na manda manjiku kolo toko walsikimiliye?** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi tolemele kou mongo te na liku ora siei.” nirimu. Enene yu molorumuna te mengo ongo yu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kanu kinie Yesusini enendo nimbendo: “I kouna naenga kumbikeremo kinie imbimu kinie molemoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Enene yundu ningindu: “Romo Gapomano Ye Paa Aili Kumbine Sisamonga kumbikeremo kinie imbimu kinie molemo.” niringi. Kanu kinie yuni enendo nimbendo: “⸤Kou monemo Sisamonga⸥ kene Sisamonga melema Sisamo yuyu siku, Pulu Yemonga melema Pulu Yemo yuyu siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yuni aku sipe ⸤paa sumbi sipe⸥ nirimu mele pilkulie ⸤‘Yu paa pilipe konginjili pelemo yemo lepamo.’ ningu pilku⸥ konopu aisili liku mundukulie yu munduku kelko ene puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","⸤Kanu yema Yesusi kinie kou takisi toli ungumu ningu pora siringi kinie⸥ pe aku enamonga Sadusi ye mare* Yesusi molorumuna oringi. Sadusi yema ene ‘Pulu Yemone pe kolemele yamboma topa na makinjimbe, lomboroko ola na molonge.’ ningu pilku moloringi talapemo. Aku Sadusi yema ongo Yesusi walsiku pilkulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ungu Mane Silimu, ⸤Pulu Yemonga ungu manema olio sirimu ye⸥ Mosisini ungu mane sipelie nimbendo: “Ambo limbe ye te ambolango na membalie kolomba kinie kanu yemo yunge angenu molombamone yunge ambo wayemo lipe angenu lipe taponjipe ambolango menjipili.”* nirimu aku sipe bokuna molemo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","⸤Aku ungu manemonga ulu te olionga ye mare kinie wendo orumu mele nu walsipu piliemili.⸥ “Angenupili yepoko pakara moloringi. Komomo ambo lipelie kolorumu. Ambolango te na molopili kolorumuna yunge bulkundu angenumuni ⸤yunge angenu kolorumumunge⸥ ambolango ‘Menjembo.’ nimbe ambo wayemo kelepa lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nakolo ambolango te na menjipelie yu we kolorumula. Yunge bulkundumuni kanu ambomo lirimula nakolo yu kepe we kolorumula. Aku teliku pukulie ye yepoko pakara pali ambolango telu kepe na mengolie kolko pora siringi kinie akiliomo we kolorumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pe ambomo yu kolorumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akumunge, kolemele yamboma pe lomboroko ola molonge kinie kanu ambomo ye yepoko pakara pali ya mana liringine ambomo yu ye paa naenga menu molombaye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusini enendo pundu topa nimbendo: “Ene Pulu Yemonga bokuna ungu molemoma kinie, Pulu Yemo kinie tondolo pelemo mele kinie, na pilku lou lemelemonga ⸤yamboma pe tengemondo nikimili mele pilku sunduku kolo tokomele⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lomboroko ola molonge yambomanga yema ambo na liku, amboma ye na puku, aku paa na tenge. Mulu koleana molemele angelloma molemele mele aku siku molonge. ⸤Angellomane mana yamboma telemele mele na telemele kanumu.⸥ Aku tengemonga ⸤‘Ene Pulu Yemonga ungumu pilku sunduku lawa telemele.’ nikiru.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","“Nakolo ⸤ene Sadusimene⸥ ‘Kolemele yamboma lomboroko ola na molonge.’ konopu lemelemonga ungu te Pulu Yemone enendo nirimumu enene na kanoko pilimeleye? Yuni i sipe nimbendo: “Na Eporayamo kinie Aisake kinie Jekopo kinie enenga Pulu Yemo molio.” nirimu.* Pulu Yemonga bokuna aku ungu molemomo na kanoko pilimeleye? ⸤‘Enenga Pulu Yemo molorundu.’ na nirimu. ‘Enenga Pulu Yemo molio.’ nirimu kanumu.⸥ Pulu Yemo yu kololi yambomanga Pulu Yemo molo; yu konde mololi yambomanga Pulu Yemo.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yuni aku nirimu mele yambo maku toko moloringimene pilkulie yunge ungu mane sirimu unguma pilkulie pungu pungu ningu paa konopu aisili liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nakolo Yesusini aku ungu nirimumuni Sadusi yemanga ungumu pipi sinjirimu, ene ungu te na perimuna Parisi yemane* pilkulie ene liku maku toko ⸤Yesusi molorumuna⸥ oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","⸤Oringi kinie⸥ enenga ye te, yu Pulu Yemonga ungu manemanga puluma pilipe konjirimu yemone ‘Yuni nimbe kenjimbenje manda manjipu piliembo.’ nimbe* Yesusindu walsipe pilipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ungu Mane Silimu, Pulu Yemone ungu mane sirimu pelemomanga nambolka ungu manemo yu olandopaye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesusini yundu nimbendo: “Ungu mane olandopamo i sipe: ‘Enene enenga kamelema kinie, enenga minime kinie, enenga pilipe konginjilime kinie, akumane Ailimu enenga Pulu Yemo manjiku tondolo munduku konopu monjengi.’ aku nimbe pelemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aku ungu manemo yu paa tondolo, olandopamo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Talo sipe ungu manemo yu kinie telu sipe mele. Akumu i sipe: ‘Enene eneno yu mele mele konopu monjiku enenga kangimu eneno kondo kolko nokolemele mele aku sikula pulu lemo yamboma konopu monjiku nokoko molangi.’ nimbe pelemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pulu Yemonga ungu mane Mosisini sirimuma pali kinie, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane bokuna toringi unguma pali kinie,* kanu ungumanga pulumu aku ungu manetolo mindi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kanu kinie Parisi yema aku siku we maku toko molangi Yesusini enendo i sipe walsipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimundu* enene nambolka konopu lekemeleye? Yu nae? Yu naene kalopa limbe konopu lemeleye?” nirimu kinie enene ningindu: “⸤Ye nomi Kirasimu yu ye nomi kingi⸥ Depisini kalopa limbe ye te.”** niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yuni altopa ene walsipelie nimbendo: “Aku liemo ⸤Pulu Yemonga⸥ Minimu Depisinge konopuna molopalie ungu te nirimu kinie Depisini pilipelie ye nomi Kirasimundu “Ailimu” nirimu akumu nambemuna nirimu konopu lekemeleye? Depisi yuni ⸤ye Kirasimu molomba mele⸥ i sipe nirimu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Aili ⸤Pulu Ye Yawene⸥ nanga Ailimundu nimbendo: “‘Nunge opa touma nuni nokani.’ nimbu, pe ene topo manie mundunjimbu kene isili ou nu ⸤na kinie pea tapu topolo ye nomitolo molopolo melema nokambili⸥ nanga ki umbukundu ongo molani.” nirimu.”* nimbe Depisini nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depisini ⸤ye nomi Kirasimu⸥ yundu “Nu nanga Ailimu.” nirimu liemo yu pe nambe tepa Depisini kalopa limbe ye te ⸤mindi⸥ molombaye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","⸤Yesusini aku sipe walsirimu mele pilkulie⸥ ye akuna moloringimenga tene ungu telu kepe pundu toko manda na niringi. ⸤Enene yu walsiku piliringi unguma pali yuni pundu topa anju nimbe konjirimu pilkulie⸥ pe altoko yu ungu te walsiku pilingindu pipili kolko na walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kanu kinie Yesusini yambo maku toringime kinie, yunge lombili andoli yema kinie, ungu nimbe sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pulu Yemonga ungu manemanga puluma pilku mane silimele yema kinie Parisi yema kinie* enene Mosisini ungu manemanga puluma mane sirimu mele yandopa mane silimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Akumunge kanu yemane ene mane silimelema pali mimi siku pilku teangi, nakolo kanu yemane mane silimele mele kanu yema eneno pilku liku na telemelemonga kanu yema enene ulu telemelema manda lelko na teangi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yambo tene wale umbuni teli te tepa mimi tepalie yambo te ‘mepili.’ nimbe ola lipe buluna menjilimo mele ⸤aku siku kanu yemane yambomando ungu mane siku “I siku i siku teai.” ningu⸥ umbuni silimele nakolo laye kolte kepe ‘Lipu taponjipu meamili.’ na nilimele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kanu yemane ulu telemelema ‘we teamili.’ ningu na telemele. ‘Yambomane olio kanokolie ‘molko konjilimele.’ ningu kanangi.’ ningu uluma telemele. Pulu Yemonga ungu manema molemo pepá te kulupi toko mambelena molo kíne ka tongendo ‘Yamboma paa kanangi.’ ningu kulupi paa aili teko toko,* enenga wale pakolimenga ka moko toko monjingindu ka sulu peanga mare aili teko moko toko monjilimele.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yambomane langi nongo yambomando “Namili wai.” nilimele kinie kanu yema ongolie ye ailimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. Yamboma maku toko Pulu Yemonga ungumu pilimele ulkena sukundu pukulie manie molongendo ye ailime molemele polo peanga akuna ‘molamili.’ ningu mendo puku polo akuna konopu siku molemelela.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yamboma maku toko molemele koleana andongendo mongo kenge teko ‘We yambomane olio kanoko kapi niengi.’ ningu pilkulie konopu siku pilku andoko molemelela. Yambomane enendo ‘Rapai’* nilimele kinie paa konopu silimelela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“⸤Kanu yemane aku telemele⸥ nakolo enenga nokoli ye aili telumu mindi molemo, ene pali angenupili molemele kene yambomane “ene olionga Rapaime.” na niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Enenga Lapa telumu mindi molemo, akumu mulu koleana molemo, akumunge mana yambo tendo ⸤‘olionga ye ailimu’ ningu⸥ “Tara” na niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu* mindi enenga nokoli ye ailimu molemo kene yambomane enendo ⸤‘olio nokolemo yemo’ ningu⸥ “Ye Ailimu” naa la niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Yambo tene yunge imbimu yuyu ambolopa ola limbe kinie ⸤Pulu Yemone⸥ yunge imbimu topa manie mundumbe; yambo tene yunge imbimu yuyu topa manie mundumbe kinie ⸤Pulu Yemone⸥ yunge imbimu ambolopa ola linjimbe kene enenga ye te ene nokomba ye aili te molopa enenga kongono kendemande yemo molopili.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","⸤Yu lombili andolimendo ungu nimbe kelepalie Yesusini Juda yambomanga ye aili moloringimendo nimbendo⸥: “Ene Pulu Yemonga ungu manemanga puluma pilku mane silimele yema kinie, Parisi yema kinie, ene mindili nongo paa molko kenjingí! Ene topele mapele toli yema!* Enene yamboma Pulu Yemo ye nomi kingi molopa nokolemo** mulu koleana pungí pulimele kerepulumu pipi silimele. Ene eneno sukundu na pulimele; yambo lupema pungí telemele kinie aulkemo pipi siku “Molo.” nilimelela.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“(Ene ungu manemanga puluma pilku mane silimele yema kinie Parisi yema kinie ene mindili nongo paa molko kenjingí! Ene topele mapele toli yema! Enene ambo wayema liku lou siku enenga ulkema wa liku, enene ‘Yamboma kanangi.’ ningu Pulu Yemo kinie unguma sulu teko we ningu angilimele, akumunge kote walemo wendo ombá kinie ene kinie umbuni aili tepa pemba.)* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ene ungu manemanga puluma pilku mane silimele yema kinie Parisi yema kinie ene mindili nongo paa molko kenjingí! Ene topele mapele toli yema! ‘Yambo telu mindi kepe konopu alowa tepa olio lombili andomba kinie papu.’ ningu ma koleamanga kimbu kongono teko kolea sulumanga puku, nomu kusa sipimenga andolemele nakolo pe yambo te sike enene nilimele unguma pilipe lipe konopu alowa tepa lombili andolemo kinie kanu yambomo tepa kenjilimo mele paa olandopa, enene teko kenjilimele mele maniendopa, akumunge yu tepe koleana paa sike pumbe aulkemo akisinjilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ene mongo keri lelimene “⸤Mongo keri leli⸥ yamboma aulkemo lipu ora siemili.” nilimele yema ene mindili nongo paa molko kenjingí! Enene yamboma mane sikulie ningindu: “Yambo tene mi lembando ‘ulke tembelemo’ imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele na temba kinie uluri molo. Nakolo yambo tene mi lembando “ulke tembelena ape kanjiringi kou gollomo” imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele na temba kinie kapola na temba. Yu sike kamu tepili.” nilimele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ene aroma toko mongo keri leli yema! Mele nambolka melemo olandopaye? Kou gollo akumu mele olandopamo molo Pulu Yemo molemo ulke tembelemone kou gollo mako topa ‘Pulu Yemonga’ nimbe kake tenjilimo ulkemo olandopaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Enene ungu te pea yamboma mane sikulie ningindu: “Yambo tene mi lembando ‘Pulu Yemo popo toko melema kalemele polomo’ imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele na temba kinie uluri molo. Nakolo yambo tene mi lembando “aku polona ola melte singímu” imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele na temba kinie kapola na temba. Yu sike kamu tepili.” nilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ene mongo keri leli yema! Mele nambolka melemo olandopaye? Polona ola ‘Pulu Yemo popo toko kalonjengi.’ ningu silimele melemo olandopamo molo polomone kanu melema mako topa ‘Pulu Yemonga’ nimbe kake tenjilimo polomo olandopaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Akumunge, yambo tene mi lembando ‘Pulu Yemo popo toko melema kalemele polomo’ imbi lemba kinie mele polona ola lemba melemo kepe imbi lepa mi lemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aku sipela yambo tene mi lembando ‘ulke tembelemo’ imbi lemba kinie ulke tembelemo kinie akuna sukundu molemo yemo kinie imbi lepa mi lemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yambo tene mi lembando ‘mulu koleamo’ imbi lemba kinie Pulu Yemo ye nomi kingimu molopa kolea nokombando molemo polomo kepe aku polona ola molemo yemo kepe imbi lepa mi lembala. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ene ungu manemanga puluma pilku mane silimele yema kinie, Parisi yema kinie, ene mindili nongo paa molko kenjingí! Ene ‘sike unguma nikimulu.’ ningu kolo toko topele mapele toli yema!* Langi kalongendo ‘songo tepili.’ ningu enenga poniena mele kanga lupe lupe olemomanga inie toko langine mundulimele akumanga ungu mane te pelemomo pilku tene tene ningu nosilimelemanga telu telu Pulu Yemonga ningu yu silimele.** Aku telemele nakolo ungu mane tondolo olandopa mare munduku kelko na pilku telemele. ‘Yamboma apuruku yambo ailime liku taponjiku yambo kerime teko kenjiku na teko, yamboma na apuruku pali kondo kolko, Pulu Yemo ‘Sike.’ ningu tondolo munduku pilku “Temolo.” nilimele mele sumbi siku teko molko, aku teangi.’ nimbe pelemo ungu manemando nikiru.*** Ungu mane wema pilku telemelema munduku na kelko ‘mare na telemele’ nikiru akuma pali telemelkanje papu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ene mongo keri lelimene “⸤Mongo keri leli⸥ yamboma aulkemo lipu ora siemili.” nilimele yema,* ene ⸤ungu mane wema tondolo munduku pilku teko, ungu mane tondoloma na pilku telemele aku telemele mele ungu iku topo niembo:⸥ Langi nongendo mele kanga lopalo molo lomou langine pelemo kanokolie ‘Naa namili.’ ningu wendo liku ele telemele, nakolo kongi kao te langine pelemo kinie na kanoko we liku toko penge mundulimele.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ene ungu manemanga puluma pilku mane silimele yema kinie Parisi yema kinie, ene mindili nongo paa molko kenjingí! Ene topele mapele toli yema! Pellete kapomanga ulsukundu kulumiye toko konjilimele nakolo akumanga sukundu langi pelemoma enene tondolo munduku wa liku, enene eneno waka kolko eneno konopu kimbu siku limele uluma.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ene mongo keri leli Parisi yema! Pellete kapomanga sukundu kulumiye tonge kinie ulsukundu kepe kake temba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ene ungu manemanga puluma pilku mane silimele yema kinie Parisi yema kinie, ene mindili nongo paa molko kenjingí! Ene topele mapele toli yema! ‘Yambo ono koleamo kanoko peanga kanangi.’ ningu pene kake telimu ape kanjilimele mele ene aku silime mele molemele. Yambo ono koleama sike ulsukundu peanga lemo kanolemele nakolo sukundu yambo kololimenga ombelema kinie mele puruli nurupuluma kinie peke lepa pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ene aku siku mele molemele. Yambomane enenga kangikundu kanokolie ‘Ene ye sumbi nilime’ konopu lemele nakolo enenga konopuna sukundu kolo toli uluma kinie ulu pulu kerime kinie mindi si nimbe pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ene ungu manemanga puluma pilku mane silimele yema kinie Parisi yema kinie ene mindili nongo paa molko kenjingí! Ene topele mapele toli yema! Pulu Yemone ungu umbu tonjilimoma pilku yando ningu silime kolemele kinie enenga ono telemele koleama teko mimi teko, sumbi nili yambomanga ono koleama au silimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aku tekolie enene ningindu: “Olio olionga anda kolepalime kinie molemelkanje enene Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema* toko konjiringi kinie olionga anda kolepali na lipu taponjipu ene na tolemelka.” nilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aku nilimelemonga ‘Kanu yema toko konjiringi yambomane kalko liringi yema molemolo.’ ningu eneno liku ora silimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aku liemo kapola enenga anda kolepalimene pulu monjiku teko kenjiringi mele enene kamu teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“⸤Yamboma nongo konjili⸥ wambiyema! Ene kolo topa yamboma tepa kenjili wambiyemonga waloma!* Pulu Yemone enendo “Teko kenjiringimunge tepe koleana pai.” nimbé kinie ene manda kowa pungí aulke te lembaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Akumunge nane Pulu Yemone ungu umbu tonjimbema pilku yamboma ningu singí yema kinie, pilipe konginjili pemba yema kinie, mane singí yema kinie, ene molemelena lipu mundukuru. Aku yemanga mare toko konjiku, mare ‘Kolangi.’ ningu unju perana uku toko monjiku, mare ene maku toko Pulu Yemonga ungumu pilili ulkemanga mengo puku ka pulsene toko, koleamanga ‘tamili.’ ningu pulú siku akilku lombili pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aku tengemonga ou pulu pulu ⸤Pulu Yemone mulu matolo terimu kinie⸥ kepe yandopa kinié kepe yambo sumbi nilime toko konjiringimunge ulu umbunime ene ⸤Juda yambomanga ye ailime⸥ kinie pemba. ⸤Pulu Yemonga bokuna⸥ ou pulu pulu sumbi nili ye Epele kinie, yandopa moloringi yambo sumbi nilime kinie, yandopa ⸤Pulu Yemonga bokumu pora nilimo akuna⸥ Berekia malo Sekaraya kinie toko konjiringi akumanga pali* ulu umbunime ene kinie pemba. Sekaraya akumu Pulu Yemonga ulke suluminia lerimu ulkemo kinie Pulu Yemo popo toko melema kaloringi polomo kinie ai suku singine toringi kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nane paa sike enendo nikiru: Ou teko kenjiringi ulumanga pali ulu umbunime i yambo kinié molkomelema kinie pemba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","⸤Aku nimbelie Yesusini Jerusalleme moloringi yamboma yu kondo kolopa akumundu ungu te nimbelie nimbendo:⸥ “O Jerusalleme ⸤yamboma⸥, Jerusalleme ⸤yamboma⸥, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema toko konjiku, yuni yamboma ‘liku taponjengi.’ nimbe ene moloringine lipe mundurumu yema kouni toko konjiku telemele yamboma, kera gulta anumumuni yunge waloma lipe yunge kongona lopi tepa nokolemo mele nane wale aisili ene aku sipu nokolka nakolo eneno “Molo!” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akumunge pilieme! ⸤Opa touma ene tonge onge kinie Pulu Yemone altopa ene na nokopa na lipe taponjimbemonga⸥ opa toumane ongo sike toko munduku enenga koleamo kinie enenga ulke tembelemo kinie kamu toko kalongemonga ene ku penge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Akumunge ⸤nane ene ungu te pea nimbu sikiru:⸥ Ene Jerusalleme yamboma, enene nando “Pulu Ye Yawene lipe mundurumuna okomo yemo imbi ola molopa, molopa konjipili.”* ningí walemonga na altoko kanonge. Ou molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kanu kinie Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena ulsu pupe aulkena pumbe purumu kinie yu lombili andolime ongo ulke tembelemonga ulke lupe lupe ⸤paa peanga angiliringime⸥* yu “Kanoi.” ningu liku ora siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","⸤Aku teringi kinie⸥ yuni enendo nimbendo: “Ya ⸤ulke tembele peanga angilimo⸥ kanokomele melema pali paa sike nimbu sikirumu: ⸤Pe walse ya kolea aili Jerusalleme yamboma mindili nonge walemo wendo ombá kinie⸥ i ulke tembelemo tekisikulie kouma pali toko manie mundungí.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kanu kinie yu ma pangi Unju Ollipi Poniena ola pupe manie molorumuna we yamboma na molangi yunge lombili andoli yema ongo ene eneno molkolie yundu walsiku pilkulie ningindu: “Nuni nikinu mele tewale wendo ombáye? Pe nu nondoko oni teni walemo kinie kepe ma pora nimbé walemo kinie kepe wendo ombándo ou nambolka uluri temba kinie olio kanopolie “Kinié ombá tekemo.” nimbu pilimulúye? Ningu si.” ningu walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yuni enendo nimbendo: “⸤Kanu uluma wendo ombámonga ungu mare⸥ yambomane ene kolo toko singí kene kanoko konjiku molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ye aisili ongo na molio mele yu mele mele kolo toko ningindu: “⸤Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasi⸥ akumu na.” ningulie aku siku kolo toko singí kene kanoko konjiku molangi. Yambo aisilini kanu yemanga unguma pilku liku “Sike nikimili.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Kolea marenga opa aili teko tenge mele pilku, ‘Opali talu opa aili i sipe i sipe wendo ombá.’ ningu we ningí kinie pilkulie mini wale na mundengi. Opa tengema kinie aku uluma Pulu Yemone ‘Ou wendo opili. Laye pe mele ya ma koleamo pora nimbé.’ nimbe, nimbe panjirimumunge aku uluma sike wendo ombá nakolo aku kinie mulu matolo ou na pora nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","⸤Mulu ma pora nimbé walemo ou wendo na opili⸥ yambo talape aili te kinie talape aili te kinie opa tekolo, ye nomi kingi marenga talapema kinie marenga talapema kinie opa tenge. Ya ma kolea tenga tenga engele lepa, ma jimi jimi tepa, aku sipe temba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ambo tene ambolango kokele kanopa limbendo ou mini topa mindili nolemo mele, mulu ma pora nimbé walemo kokele wendo ombándo umbuni lupe lupe aku sipema ou wendo ombá.” ⸤nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kanu uluma wendo ombá walemanga ‘⸤Na lombili andoli yamboma⸥ mindili nongo, kolangi.’ ningu ⸤ene mare⸥ kote teko ka singí. Nanga yamboma molko nanga unguma andoko ningu singímunge koleamanga pali yambomane ene kinie mumindili kolko konopu keri panjingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","⸤Kanu umbunime wendo ombá⸥ walemanga na ‘Sike.’ ningu tondolo munduku pilingí yambo aisili tondolo munduku pilingí mele siye kolko anju yando eneno konopu keri panjiku, ‘Kirasinge yamboma molemelemonga mindili nangi.’ ningu enenga opa touma liku singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","⸤Kanu walemanga⸥ Pulu Yemone ungu umbu tonjilimoma na pilku we kolo toko yando ningu singí yambo aisili wendo ongela. Aku tenge kinie we yambo aisilini ‘Sike nikimili.’ ningu enenga unguma pilku lingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ulu paa keri aisili olandopa olandopa wendo ombámonga nanga yambomane ⸤anju yando⸥ konopu monjingí mele ⸤kinie, na konopu monjingí mele kinie⸥ siye kolongela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nakolo nanga ungumu munduku na kelko mulu ma pora na nipili tondolo munduku molonge yamboma ⸤Pulu Yemone⸥ lipe taponjipe ‘Mindili nonge koleana na puku pea molopo konjipu mindi pamili.’ nimbé.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pulu Yemone ye nomi kingimu molopa yamboma nokombamonga* temane peangamo ‘Yamboma pali piliengi!’ ningu koleamanga pali andoko ningu singí kinie pe mulu ma pora nimbé walemo kamu wendo ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(⸤Na i bokumu tokoro yemone ene boku kanokomele yambomando ungu te niembo:⸥ ‘⸤Yesusini nirimu⸥ ungumu inie anjukundu molemo akumu ene imbi kanokomele yambomane ungu pulumu paa pilku konjengi.’ nimbu nikiru: ⸤Yesusini nimbendo:⸥) “Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Denielene bokuna imbi topa nimbe sirimu mele yambo tepa pipili konjili mele paa kerimu ⸤ulke tembelena suku⸥ Pulu Yemonga ulke suluminia kake teline angilimbemonga kolea akumu paa kalaro molomba mele nirimu, bokuna molemo. Aku mélemo akuna wendo omba angilimbe kanokolie* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","⸤‘Umbuni ailime wendo ombá tekemo.’ ningu pilku⸥ kolea Judia poropinji koleamanga molonge yamboma ⸤enenga koleama munduku kelko⸥ ma pangi lembamanga kowa pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yambo te ulke imuna ola molopili ⸤aku sipe wendo ombá kinie kanopalie⸥ kowa pumbendo manie omba ‘Melema lipu membo pambo.’ nimbe ulkena sukundu na pupili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yambo te poniena molopalie ⸤‘Kowa pambo.’ nimbe⸥ kelepa ulkendo pupe yunge ali wale sulumu na lipili. ⸤Sumbi siku kowa mindi pangi.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aku sipe wendo ombá walemonga ambo ambolango monjingíme kinie, ambo ambolango ame singíme kinie, ⸤ene manda lkisiku kowa na pungímunge⸥ ene kinie paa umbuni wendo ombámonga ene kondo tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Pulu Yemo mawa tekolie, ‘Ali telemo olimenga kinie ⸤koro molopo manda na andomolo⸥ wale Sambatemanga kinie manda kowa na pumulú kene kanu walemanga kanu umbunime wendo na opili.’ nieyo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kanu walemanga umbuni paa ailime wendo ombá, ou mulu matolo pulu monjipe terimu kinie kepe, yandopa kinié kepe umbuni aku sipe te wendo na orumu. Pe kepe aku sipe umbuni ailime na wendo ombála. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","⸤Kanu umbunime wendo ombá kinie Pulu Yemone⸥ ‘Nondopa pora nipili.’ nimbe ou na nimbe panjilkenje yamboma pali kolemelka. Nakolo Pulu Yemone ‘Nanga yamboma molangi.’ nimbe mako torumu yamboma ‘Pali na kolangi.’ nimbe ‘Umbuni wale akuma nondopa pora nipili.’ nimbe, nimbe panjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kanu umbunime omba pemba walemanga yambo marene ningindu: “Kanai! Pulu Yemone “Olio nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu ya omba molemo.” ningí molo “Nena omba molemo.” ningí kinie enenga unguma na pilku, ‘Sike nikimili.’ ningu na piliengi! ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ye mare ongo kolo tokolie ningindu: “Pulu Yemone mako torumu ye nomi Kirasimu na.” ningí, molo kolo tokolie “Pulu Yemone ungu umbu tonjimuma pilipulie ombo nimbu sikimulu.” ningí. ‘Yamboma pali, Pulu Yemone ‘Nanga yamboma molangi.’ nimbe mako torumu yambomane kepe lipu lou sipu, nikimulu mele ‘Sike.’ ningu tondolo munduku piliengi!’ ningu Pulu Yemone mindi ulu tondolo kapola telemoma mele manda lelko ulu paa tondolo aisili tenge. Nakolo Pulu Yemonga yamboma aku siku kondi tonge kinie enenga unguma na pilku, liku su singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pe ulu akuma wendo ombá mele ‘Ene ou piliengi!’ nimbu ya nimbu sikiru mele piliei. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“⸤Wendo ombá mele nimbu sikiru, pilkimili⸥ kene pe yambo tene nimbendo: “⸤Ye nomi Kirasimu⸥* ne yambo na peli kolea ku leline molemo.” nimbé kinie ‘Kanamili.’ ningu akuna na payo. Molo “I ulkemonga suluminiana molemo.” níngi liemo enene ‘Sike nikimili.’ ningu na piliengi! Muluna kariapá telemo kinie ena mundi wendo olemo koleana kepe ena pulimo koleana kepe kariapá telemo walsikale kanolemele, aku sipe Manie Omba Mana Ye Au Lerimu Yemo ⸤altopa⸥ manie ombá kinie koleamanga pali yambomane yu walsikale kanonge aku kene “Ya molemo ongo kanai.” ningí kinie, molo “Ne molemo puku kanopai.” ningí kinie, enenga unguma na piliengi! ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mele kololi te lemo koleana kera ilsepema ongo maku tolemele kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kanu walemanga aku mindili nonge nikiru uluma wendo ombá kinie pe sumbi sipe ⸤ulu lupe lupe mare wendo ombála. Akuma i sipe:⸥ ‘Kolea tangombando ena pa telemo mele na tepa, sumbulu topa, oli ipulueli pa telemo mele na tepa, kombukandipime muluna manie omba, muluna angilimo mele tondoloma* lope lope tepa anju yando pupe, aku sipe ulu lupe lupema wendo ombá.’** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kanu uluma wendo ombá kinie Manie Omba Mana Ye Au Lerimu Yemo kamu ombá temba mele lipe ora simbe melte muluna angilimbe kinie ⸤kanokolie⸥ koleamanga pali yambomane paa kola aili teko tenge. Pe kanoko molangi Manie Omba Mana Ye Au Lerimu Yemo tondolo pulimu kinie, pa aili tepa telimu kinie kupe tenga suku molopa kamu manie ombá yambomane kanonge.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kanu kinie biyukele ungu paa tondolo tepa nipili* yuni yunge angelloma lipe mundumbe kinie ene winju mendo anju yando mulu ⸤ma koleamanga⸥ pali puku Pulu Yemone ‘Nanga yamboma molangi.’ nimbe ou mako torumu yamboma sukundu sukundu lingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Unju pikimuni telemo aku sipe ungu iku mele pelemo kene pilkulie ungu pulumu piliei. Unju piki kuku topa gomo tolemo kinie kanokolie ‘Kinié ena temba walemo wendo ombá tekemo lemo.’ ningu pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aku sipela, i ulu “Wendo ombá.” nikiruma sike wendo ombá kinie kanokolie ningímuni ‘Yu paa sike nondopa ombá tekemo. Yu paa kamu okomo.’ ningu pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nane enendo paa sike nimbu sikirumu: Kinié molemele yamboma ou na kolangi i “Wendo ombá.” nikiru uluma pali wendo ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mulúmu kinie mamo kinie pora nimbé nakolo nanga ungu nilioma paa pora na nimbé.* ⸤Nilio mele pali paa sike wendo ombá.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“⸤Manie Omba Mana Ye Au Lerimu Yemo paa sike ombá⸥ nakolo yu ombá walemo na pilimolo. Ipulueli ombáne, tangoli ombáne na pilimolo. Mulu koleana angelloma kepe na pilimelela. Pulu Yemonga Malo kepe naa la pilimo. Tara yuyu mindi ⸤aku walemo⸥ pilipe molemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ou ye Noa molopili yambomane teringi mele Manie Omba Mana Ye Au Lerimu Yemo ombá temba kinie yambomane aku siku tengela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","⸤Ma koleamanga pali⸥ no ou na topili yamboma langi nongo, yema ambo liku, amboma ye puku, aku uluma mindi teko mololiku puringi.* Noa nona andoli sipi ulkemonga suku purumu kinie kepe ene aku uluma mindi we teko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ene ⸤Noanga ungumu⸥ na pilku aku siku uluma mindi teko molangi no topa ⸤koleama pali none aki topa⸥ yamboma pali topa konjirimu.* Pe Manie Omba Mana Ye Au Lerimu Yemo kelepa ombá walemonga ou Noa molopili teko moloringi nikiru mele aku siku teko molongela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yu ombá walemonga ye talo lamana* unju toko angilingilí kinie ⸤Pulu Yemonga angello tene omba⸥ ye te we molopili mundupe kelepa te lipe memba pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ambo talo langi kalongele teko molongele kinie ⸤angello te omba⸥ ambo te we molopili mundupe kelepa te lipe memba pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Akumunge enenga Ailimu ombá walemo paa na pilimele kene ‘Yu ombá.’ ningu kanoko molai.” ⸤nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Ene i ungumu konopu liku munduku pilieyo: Ulke pulu ye tene ipulueli wa noli ye tene yunge ulkemo omba bulsupe melema wa limbe mele pilkenje ‘Wa noli yemo ombá.’ nimbe nokopa molka kinie wa noli yemo yu manda suku na olka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aku siku ene nokoko molai. Manie Omba Mana Ye Au Lerimu Yemo* ombá enamo na pilimele kene ‘Yu sike ombá.’ ningu aku siku nokoko molangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“⸤Akumunge ungu te niembo:⸥ Kongono tenjili kendemande ye naene kongono tepa konjinjilimo kinie kanopalie yunge ye ailimuni ‘Yuni kongono silioma sumbi sipe telemomonga yu kongono simbu kinie tepa konjimbemonga na altopo konopu kimbu sipu na molombo.’ nilimoye? Kendemande ye te aku sipe mele tepa konjipe molemomo kanopalie yunge ye ailimuni yu mako topalie yundu nimbendo: “Kongono tenjili kendemandema pali nokonjiku enenga langi nongema ena mako toliomonga ene nangi moke teko sieni, nokonjiku moloi.” nimbe ⸤yu tenga pulimo⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pe ye ailimuni kongono simumu kanu kongono tenjili kendemandemone mimi sipe tenjipe molopili ailimu kelepa omu liemo kendemandemo yu konopu sipili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nane enendo paa sike nimbu sikirumu: Kanu ye ailimuni kanu kendemandemondo “Nanga mele nosilioma pali nuni nokonji.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Nakolo ⸤ye ailimuni kanu kendemande yemondo nimbendo: “Nanga kendemande yamboma pali nokonji.” nimbe tenga pulimo kinie⸥ kanu kendemande yemone tepa kenjipe “Nanga ailimu welea na ombá.” konopu lepalie yuni nokonjilimo kendemande yamboma kopene topa, no nongo kekelepa toli yema kinie langi nomba no tondoloma nombalie, aku sipe tepa kenjipe molomu liemo ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","walse kanu kendemande yemo ‘Yunge ye ailimu ombá.’ nimbe na pilipe ⸤kongono sirimu mele na tepa⸥ walu tepa kenjipe molomba kinie ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Omba ⸤kanu yemo tepa molomba mele kanopalie⸥ yu paa kopene topa konjipelie, kolo tolemele yambo topele mapele toli yamboma* ⸤kolea keri⸥ molemelena ‘Pupili.’ nimbe lipe mundumbe. Kanu koleana yamboma paa mindili nongo kola teko pereko molonge.”** ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","⸤Aku nimbelie nirimumuni, Yesusini yuyu kelepa ombá mele ungu mare pea nimbelie nimbendo:⸥* “⸤Manie Omba Mana Ye Au Lerimu Yemo kelepa wale talo sipe mana manie ombá kinie⸥ Pulu Yemo ye nomi kingimu molopa yamboma nokomba** akumu i sipe mele: “Ye te ambo limbe uluma yamboma pea tengendo kanu yamboma maku toko moloringine yemo ombá terimu kinie pilkulie ‘Ipulueli ombá.’ ningu ambo wenepo rureponga talo enenga tepe llamema liku “Yu aulkena limulú.” ningu puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kanu ambo wenepomanga te pakara konopu na pepili aroma toko moloringi; te pakara pilipe konginjili pepili moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Konopu na pepili aroma toko moloringi ambo wenepomane enenga tepe llamema mengo puringi nakolo llame karasene pea na mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nakolo pilipe konginjili pepili moloringimene karasene kinie enenga tepe llamema kinie mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ambo limbe yemo welea na orumuna ambo wenepoma pali uru orumuna uru peringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kanu kinie ai burumi ungu te wendo omba nimbendo: “Ambo limbe yemo okomo kanayo! Aulkena liengi wai!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kanu kinie ambo wenepoma ola angilku tepe llame ‘Aili tepa nopili.’ ningu teko mimi teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Konopu na pepili moloringimene pilipe konginjili pepili moloringimendo ningindu: “Olionga tepe llamema kumbulkumu kene enenga karasene mare olio liku munduku siei.” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","pilipe konginjili pepili moloringimene pundu toko ningindu: “Karasene ene kinie olio kinie manda na tembanje. Ene sitoana puku enenga topo toko lipai.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanu kinie sitoana topo toko lingíndu puringi kinie ambo limbe yemo orumu. Kanu kinie ye ambo limbemonga langi akuna nongendo maku toringi yamboma, pilipe konginjili pepili moloringi wenepoma pea ulkena suku puringi. Kanu kinie ulke kune toko ingi siku langi nongo moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pe langi nongo molangi ambo wenepo sitoana puringime ongolie ningindu: “Ailimu, Ailimu, olionga kune ongo linji.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nakolo yuni enendo pundu topa nimbendo: “Nane enendo paa sike nimbu sikirumu: Na enenga imbime na pilkiru. ⸤Ulsu molemelema manda sukundu na onge.⸥” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","⸤Aku nimbelie yuni altopa nimbendo:⸥ “Aku sipe temba kene Manie Omba Mana Ye Au Lerimu Yemo kelepa ombá walemo kepe ene na pilku, ipulueli ou ombáne tangoli ombáne, ipulueli ombáne, na pilimele kene yu ombá nokoko konjiku molai.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","⸤Nimbelie Yesusini ungu iku te pea topalie nimbendo:⸥ “⸤Pulu Yemone ye nomi kingimu molopa yamboma nokolemo akumu⸥ i sipe melela:* “Ye te kolea tenga pupe molombando yunge kendemande yema “Wai.” nimbe yunge melema “Nokonjei.” nimbelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","enene kongono telemele mele pilipe apurupe yunge melema ene moke tepalie ye te kou pape tausini kina mele sipe, te kou tu tausini kina mele sipe, te wane tausini kina mele sirimu. Aku tepalie yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ye pape tausini kina lirimumu sumbi sipe pupe kanu koumuni bisinete tepalie nirimumuni, kou pape tausini kina olandopa pupe lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aku sipela ye tu tausini kina lirimumu olandopa tu tausini kina pupe lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nakolo wane tausini kina lirimumu pupe ‘Lopi teambo.’ nimbe yuni mana muru akupe yunge nokoli yemonga koumu lowa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kanu kinie wale aisili omba purumu kinie kanu kendemandemanga nokoli yemo omba enendo nimbendo: “Kouma ene teringi mele kanambo liku ora siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kanu kinie pape tausini kina lirimu yemone pape tausini kina olandopa pupe lirimumu memba ombalie nimbendo: “Ailimu, nuni na pape tausini kina sirinu kanumu. Nane pape tausini kina olandopa pupu lirindumu i ambolkoro kanoi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nokoli yemone yundu nimbendo: “Kendemande ye peangamo, paa papu terinu. Kongono wallo kolte mele sirindumu nuni teko konjirinumunge “Nuni nanga mele aisili nokonji.” nimbú kene nu ongo na pea tapu topo konopu sipu molambili oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ye tu tausini kina lirimu yemo yu kepe ombalie nimbendo: “Ailimu, nuni na tu tausini kina sirinu kanumu. Nane tu tausini kina olandopa pupu lirindumu i ambolkoro kanoi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yunge nokolimuni yundu nimbendo: “Kendemande ye peangamo, paa papu terinu. Kongono wallo kolte mele sirindumu nuni teko konjirinumunge nanga mele aisili “Nu nokonji.” nimbú kene nu ongo na pea tapu topo konopu sipu molambili oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kanu kinie wane tausini kina lirimu yemo kepe ombalie nimbendo: “Ailimu, nane pilipulie, ‘Nu bisinete tondolo munduku teko ‘Kou mone lipu nosimbumunge yamboma mindili nongi liemo mandala.’ ningu ⸤kendemande yamboma ‘Kongono mindili siku teangi.’ ningu siku, ene mele wallotolo siku melema pali nunu mindi lino yemo;⸥ ponie yambomane panjinjilimele kinie nu nunu langi melema we akuku liku; rasi witimunge kilu kinie mongotolo yambo wemane kilu toko apurunjilimele kinie nu nunu rasi witi mongo we lino mele.’ na pilirindu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","⸤Aku siku telenomonga⸥ nane nu pipili kolopolie na pupu nunge kou na sirinumu mana lowa terindu. Kanu koumu i ambolkoro kanoyo. I nunge koumu nunu sikiru li.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aku nirimu kinie pilipelie nokoli yemone yundu pundu topa nimbendo: “Teko kenjili kendemande ye kerimu, nuni pilkulie, ‘Ponie yambomane panjinjilimele akuna na nanu langi melema we akupu lipu; rasi witimunge kilu kinie mongotolo yambo lupemane apurunjilimele kinie na nanu rasi witi we lio.’ ningu pilirinu lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aku siku pilkulie nanga kou monemo kou benge ulkena nosilinanje papu. Aku telenanje na ombo nanga koumu wendo lipulie kou wallo kolte ola panjiku silimelka lilkela.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","⸤Kanu kendemande yemondo aku sipe nimbe pora sipelie yuni we kendemande yemando nimbendo:⸥ “I yemo tepa kenjirimu kene yunge koumu wendo likulie tene tausini kina ambolkomo yemo siei.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Melema nosilimo yambomo* nane mare pea simbu, yu paa aisili nosimbe. Nakolo melema na nosilimo yambomo** yu nosilimoma kepe wendo limbu kene*** aku siku tekolie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","kendemande ye kerimu sumbulu toline liku paka toko pena mundeyo. Akuna yamboma paa mindili nongolie kola teko pereko molonge.”* nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","⸤Aku nimbelie yu pe kelepa omba temba mele nimbelie nimbendo:⸥ “Manie Omba Mana Ye A Lerimu Yemo yunge tondolo pa telimu kinie ombalie nimbemone, yunge mulu koleana angelloma kinie pali onge kinie tondolo pa teline suku ye nomi kingi polomo lembana yu molomba.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yunge kumbikerena ma koleana yamboma pali liku maku tonjingí. Kanu kinie kongi tapu teli ye tene yunge kongime apurupelie kongi sipisipime lupe lipe mundupe, kongi memema lupe lipe mundulimo mele aku sipe Ye Nomi Kingimuni yambo maku toko molongema apurupelie nimbemone, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","yambo kongi sipisipi mele molongema yunge ki umbukundu lipe mundupe, kongi memema mele molongema yunge ki tarokondo lipe mundumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Aku tepalie, yuni yunge ki umbukundu molonge yambomando nimbendo: “Na engelene kolorundu kinie enene na langi siringi. Na no waka kolorundu kinie enene no kolko siringi. Na aulke ponenge orundu kinie enene na “Pea molamili oi.” niringi. Na pulue wambale na panjipu we we andorundu kinie mulu wambale te siringi. Na kuru torumu kinie nokoringi. Na ka ulkena perindu kinie ongo kanoringi. Tarane ‘Ene molko konjengi.’ nirimuna konopu peanga pepili molemele yamboma, enene ulu akuma na kinie teringi kene, ya ongo, ou mulu matolo na lepili Tarane yu nokomba koleana ene pea ‘Tapu topo molomolo.’ nimbe, nimbe panjirimu koleana sukundu wai.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aku sipe nimbé kinie pilkulie sumbi nili yambomane pundu toko yundu ningindu: “Ailimu,* tewale nu engelene kolorunu kinie kanopolie nu langi sirimuluye? Tewale nu no waka kolorunu kinie kanopolie nu no kolopo sirimuluye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nu ye ponengemo tena molorunu kinie kanopolie “Ulke sukundu molamili oi.” nirimuluye? Mulu wambale na pakoko we we andorunu kinie kepe nu tena kanopolie mulu wambale sirimuluye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nu kuru torumu kinie kepe, ka ulkena perinu kinie kepe, tewale ombo kanorumuluye?” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","⸤Aku siku ningí kinie⸥ Ye Nomi Kingimuni enendo pundu topa nimbendo: “Nane enendo paa sike nimbu sikirumu: I nikiru mele i nanga angenupili imbi na mololi te kepe liku taponjiringi akumu na liku taponjiringi.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Kanu kinie yunge ki tarokondo molonge yambomando nimbendo: “Pulu Yemone ‘Ene molko kenjengi.’ nilimo yamboma, na engelene kolorundu kinie enene na langi te na siringi. Na no waka kolorundu kinie enene na ‘no nambo.’ ningu kolko na siringi. Na aulke ponengemo orundu kinie na “Pea molamili oi.” na niringi. Na mulu wambale te na pakopo we we andorundu kinie na mulu wambale te na siringi. Na kuru torumu kinie na na nokoringi. Na ka ulkena perindu kinie na na ongo kanoringi. ⸤Enene na aku siku na liku taponjiringi⸥ kene ene nanga kumbikerena na ongo anju puku, depelemo* kinie yunge angelloma kinie enenga tepe we nomba pepa mindi pulimo pumbe tepe kalonjirindu** akuna anju pai.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aku sipe nimbé kinie pilkulie kanu yambomane kepe pundu toko ningindu: “Ailimu, nu engelene kolorunu kinie kepe, no waka kolorunu kinie kepe, nu ponenge lelko orunu kinie kepe, we we andorunu kinie kepe, kuru torumu kinie kepe, ka ulkena perinu kinie kepe, olione nu aku siku molorunu kinie tewale kanopolie nu na lipu taponjirimuluye?” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","⸤Aku siku ningí kinie⸥ yuni enendo pundu topa nimbendo: “Nane enendo paa sike nimbu sikirumu: Enene i nanga angenupili yambomanga imbi na mololi te na liku taponjiringi aku kinie na naa la liku taponjiringi.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kanu kinie kanu ⸤teko kenjilimele⸥ yamboma puku kamu kamu molko kenjiku mindi puli koleana pungí, nakolo sumbi nili yamboma puku kamu kamu molko konjiku mindi puli koleana* pungí.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesusini ⸤yu pe yando ombá mele⸥ ungu akuma nimbe pora sipelie yunge lombili andolimendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ene pilkimili, wale talo we omba pumbe kinie Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu Mele Pilimolo Walemo* wendo ombá. Aku walemo wendo ombá kinie Manie Omba Mana Ye Au Lerimu Yemo “Kolopili unju perana ola uku tangi.” ningu liku anju singí.”** nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesusini aku sipe nirimu walemonga Pulu Yemo popo tonjiringi ye ailime kinie, Juda yamboma nokoringi tapu yema kinie,* ene Pulu Yemo popo tonjiringi ye aili olandopa ‘Kayapasi’ nili ye akumunge ulkena puku liku maku tokolie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesusi kiyongo ningu ka siku tongendo langi ningu moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ningu molkolie ningindu: “⸤Nondopo tamili,⸥ nakolo Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu Mele Pilimolo Walemanga ⸤‘uluma tepo molamili.’ ningu⸥ yambo aisili ya Jerusalleme ongo maku toko molongemonga yu isili ou tomolo kinie enene olio kinie mumindili kolko opa tenge kene isili ou na topo, keleamili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kolea kanga Betani ye te ou kuru laká nombalie kelerimu ye te,* imbi lelko “Ye Kuru Laká Noli Saimono” niringi kanumunge ulkena Yesusi molopili ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ambo te kopongo wele ma mingi paa peanga te yu molorumuna memba orumu. Kanu wele paa mune tolimunge kou mone paa aili tepa purumu. Akumu memba ombalie Yesusi langi noli polo molorumuna memba omba ⸤‘Yu tepo konjembo.’ nimbe⸥ pengena ondo lenjirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yuni aku terimu kinie kanokolie Yesusi lombili andolime konopu keri panjikulie ningindu: “Aku kopongo welemo nambemuna we teko kenjikinuye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aku welemo kou mone limelkanje kou aisili lipulie yambo koropama moke tepo silimelka.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","⸤Enene ambomondo⸥ aku siku ⸤niringi⸥ pilipelie Yesusini enendo nimbendo: “I ambomo kinie nambemuna ungu aisili nikimiliye? Yuni na kinie ulu peanga te temu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yambo koropama ene kinie alieli molonge nakolo na ene kinie alieli na molombo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na ono tengemonga yuni i wele mune tolimu nanga kangine ondo lenjimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nane enendo paa sike nimbu sikirumu: Ma koleamanga pali i ⸤nanga⸥ temane peangamo andoko toko singí kinie i ambomone kinié temu temanemo kepe ‘Yambomane pilkulie ‘Yuni tepa konjirimu.’ ningu piliengi!’ ningulie aku temanemo toko singíla.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kanu walemonga Yesusi yu lombili andoli ye rurepo akumanga ye te, yunge imbimu Judasi Isikeriote, Pulu Yemo popo tonjiringi ye ailime moloringine pupe, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ene walsipe pilipelie nimbendo: “Nane ene Yesusi ambolko ka singí aulke te lipu ora sindu liemo enene na ⸤kou⸥ nambepa singíye?” nirimu. ⸤Aku nirimu kinie pilkulie⸥ enene kou sillipa mongo wane paono tene* kambu toko yu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kanu kinie yu kelepa yando ombalie Yesusi lipe ene simbe aulke te koropa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi* Koromonga pulu pulu walemo wendo orumu kinie ⸤Juda yambomane Pulu Yemone ou enenga anda kolepalime Naa Topa We Omba Purumu mele* pilingindu kongi sipisipi walo te toko nonge mele pilkulie niringimuni,⸥ Yesusi lombili andoli yema yu molorumuna ongo walsiku pilkulie ningindu: “Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walo te kinié nonimu kolea tena pupu tepo mimi tepamili konopu lekenoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","⸤Aku siku ningu walsiringi kinie⸥ Yesusini ⸤ye te molomba mele ene lipe ora sipelie⸥ nimbendo: “Ne kolea aili ⸤Jerusalleme⸥ suku pukulie, ne ye akumu molombana* puku yundu i siku niengi: “Ungu Mane Silimuni i sipe nimu: “Na kinie ulu te wendo ombá walemo nondopa wendo ombá tekemo.** Nunge ulkena sukundu na kinie na lombili andolime kinie olio Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu mele pilimulú kongi sipisipi walomo nomolo.” nimu.” niengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kanu kinie lombili andolime puku Yesusini nirimu mele tepukulie niringimuni, Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele pilingí kongi sipisipi walo nongemo teko mimi teko nosiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kanu kinie, ipupini ena pupe kala torumu kinie Yesusi kinie lombili andoli ye rurepo kinie ⸤ongo⸥ langi noli polona moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Langi nongo moloringi kinie Yesusini nimbendo: “Nane enendo paa sike nimbu sikirumu: Enenga ye tene na lipe nanga opa touma simbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","⸤Aku nirimu kinie pilkulie⸥ enenga konopuna umbuni aili tepa terimu pilkulie yu mele mele walsikulie ningindu: “Ailimu, nando nikinuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesusini pundu topa nimbendo: “⸤Ene nanga ye rureponga⸥ ye te na kinie langime polo ai suku singine ola lemo te walsikale lipu nombolo yemone na lipe, opa touma anju simbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kinié Manie Omba Mana Ye Au Lerimu Yemo kinie tenge mele koronga ou ningu panjiringi temanemo ⸤Pulu Yemonga⸥ bokuna molemo mele* sike opa toumane tenge, nakolo yu lipe opa touma simbe yemo mindili nomba paa molopa kenjimbe. Yu molopa kenjimbemonga ye akumu anumuni na melkanje papu. Yu mindili na nolka.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yesusini aku sipe nirimu pilipelie Judasi, yu lipe anju simbe terimu yemo, yuni yundu nimbendo: “Rapai,* nikinu yemo na molonje?” nimbe walsirimu kinie Yesusini yundu “Sike, nu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ene langi nongo moloringi kinie Yesusini berete te lipe Pulu Yemo kinie “Ange.” nimbe ambolopa pike lepa yu lombili andolime sipelie nimbendo: “Imu nanga kangimu ene liku nangi.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pe no waene kapo te lipelie Pulu Yemo kinie “Ange.” nimbe ene sipelie nimbendo: “⸤I no waenemo⸥ ene pali liku nangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I ⸤no waene⸥ sikirumu nanga mememo. Pulu Yemone ⸤yu kinie yunge yamboma kinie molonge mele⸥ ungu te nimbe panjipe mi lerimu kanu ungumu* ‘Kamu wendo omba pepili.’ nimbu ‘Yambo aisilinge ulu pulu kerime kamu manie pupili. Pulu Yemone altopa na kanopa siye kolopili.’ nimbu nanga mememo ondo lenjipulie ⸤kolombo⸥ aku mememo imu.** Akumu ene pali liku nangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nane enendo i sipu nimbu sikirumu: Isili ou na no waene altopo paa na nombó. Pe mindi, Pulu Yemo ye nomi kingimu molopa nokolemo koleana* ene kinie no waene kondemo kelepo nombó.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","⸤Langi nongo pora sikulie⸥ ene Pulu Yemonga konana te ningulie, pena puku ma pangi Unju Ollipi Poniena ola puringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kanu kinie Yesusini yu lombili andolimendo nimbendo: “Paa kinié ipulueli ⸤opa toumane⸥ na kinie tenge ulumu kanokolie enene pali na munduku kelenge. ⸤Aku siku tenge mele⸥ Pulu Yemone ou nirimu yunge bokuna molemo kanumu. Pulu Yemone ⸤ungu iku te topalie⸥ nimbendo: “ “Kongi sipisipi tapu yemo tangi.” nimbú, yu tonge kinie sipisipime bulu balu ningí.”* nirimu, ⸤aku mele kinié wendo ombá⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","⸤Isili ou na toko konjingí kinie ene sike bulu balu ningí⸥ nakolo na lomboropo ola molopolie nimbumuni, na kumbi lepo kolea Gallillindu pumbu, ⸤ene pe akilku akuna onge kinie altopo pea molomolo⸥.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","⸤Yesusini aku sipe nirimu kinie pilipelie⸥ Pitane nimbendo: “Nu kinie ulu te wendo ombámonga kanokolie enene pali ‘Nu sike.’ ningu tondolo munduku pilimele mele manie pumbe kinie nu munduku kelengi liemo nane nu aku sipe paa mundupu na kelembo, paa molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesusini pundu topa nimbendo: “Nane nu paa sike nimbu sikirumu: Paa kinié ipulueli, kera gulta ou ko na topili nuni ⸤pipili kolkolie⸥ wale yepoko nando kolo toko “Yu naeye? Na na kanolio.” nini.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nakolo Pitane yundu nimbendo: “Na nu kinie tapu tolembolomonga olto pea “Tomolo.” níngi liemo kepe nu “Naa kanolio.” paa na nimbú.” nirimu. Lombili andoli ye wemane pali “ “Nu na kanolemolo.” paa na nimulú.” niringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kanu kinie Yesusi kinie yu lombili andoli yema kinie kolea ‘Gesemani’ niline puringi. ⸤Akuna puringi⸥ kinie yuni enendo nimbendo: “Na anju pupu Pulu Yemo kinie ungu nipukuru kene ene ya molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aku nimbelie Pita kinie Seperi malo ⸤Jemisi kinie Jonotolo⸥ pea lipe memba pupelie ⸤‘Na teko kenjingí ulumu paa nondopa wendo ombá tekemo.’ nimbe pilipelie⸥ yu yuyu kondo kolopa konopu keri panjipe kamelena mindili tepili molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yuni enendo nimbendo: “Nanga konopuna umbuni paa aili te tepamo kene na kolkoro none tekemo. Ene uru na peko na kinie pea tapu topo nokopo konjipu molamili, ene ya we mimi siku kanoko molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","⸤Aku nimbelie⸥ yu yuyu laye kolte anju pupe koporongo langopa tamalu pepalie Pulu Yemo kinie ungu nimbe mawa tepalie nimbendo: “Nanga Tara, na nondopo ⸤mindili noli⸥ no mingine no nombómo* ‘Naa nambo.’ nini aulke te lemo liemo paa papu nakolo ‘Nane tepolie nanu konopu simbu.’ konopu lekero mele na teambo. Nuni kanoko peanga kanoni ulumu mindi teambo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aku nimbelie kelepa yunge lombili andoli ye yepoko moloringine yando omba ene uru peringi kanopalie Pitando nimbendo: “Ene uru na peko na kinie ena laye kolte manda we kanoko konjiku na molemelkaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","‘⸤Kurumanga nomi Setenene⸥ olio kondi tomba kinie tepo kenjimulú kene.’ ningulie ⸤uru na peko⸥ Pulu Yemo kinie ungu ningu kanoko konjiku molayo. Sike ‘tepo konjemili.’ nimbu konopumane pilimolo nakolo temolondo kangimu siye tepa tondolo na pulimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aku sipe nimbelie yu altopa anju pupe ou Pulu Yemo kinie ungu nimbe mawa terimu mele altopa nimbendo: “Nanga Tara, na ‘⸤Mindili noli⸥ no mingine nomo nani.’ nirinu nomo na nombó kinie we pemba liemo nuni ‘Wendo opili.’ konopu leno mele na kinie wendo opili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Altopa yando orumu kinie ene uru orumuna altoko uru peringi kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","yu altopa wale yepoko sipe anju pupe Pulu Yemo kinie ungu ou nimbe mawa terimu mele altopala nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kelepa yando ombalie lombili andolimendo nimbendo: “Nambemuna we uru peko mulu pilku molemeleye?* Kaname! Yemone Manie Omba Mana Ye Au Lerimu Yemo ⸤tonge⸥ ulu pulu keri telemele yema lipe simbe enamo** wendo ombá tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ola angilku pamili wame! Na lipe anju simbe yemo okomo kanai!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesusini ⸤kolea Gesemani yu lombili andolimendo⸥ aku nimbe molopili yu lombili andoli rurepo akumanga ye Judasi orumu. Pulu Yemo popo tonjiringi ye ailime kinie,* Juda yambomanga tapu yema kinie, kanu yemane liku munduringi ye aisili, yambo toli lou pulsema kinie kopema kinie mengo, Judasi kinie oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ou Yesusi molorumuna naa wangi Yesusi Juda ye ailime lipe simbe nimbe panjirimu ye ⸤Judasini⸥ ene Yesusi yu ipulueli manda kanonge mele nimbe sipelie nimbendo: “Nane ye te kanopolie kangulumbu akumu Yesusi. Yu ambolko ka siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","⸤Aku yema⸥ oringi kinie ⸤Judasi⸥ yu Yesusi molorumuna sumbi sipe ombalie “Rapai,* nu akuna angilinu lemo.” nimbe omba yu kangulurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aku terimu kinie Yesusini yundu nimbendo: “Ano, nuni teni okono mele sumbi siku tei.” nirimu. ⸤Judasini Yesusi kinie terimu mele⸥ kanokolie oringi yemane yu liku ka siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aku teringi kinie kanopalie Yesusi pea tapu toko angiliringi ye tene* yunge lou pokete napimu kulu topa wendo lipe Pulu Yemo popo tonjiringi ye aili olandopamonga kendemande ye te topa yunge komu te topa laká lenjirimu, aku komumu wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","⸤Yuni aku terimu kinie kanopalie⸥ Yesusini yundu nimbendo: “Nunge lou pokete napimu altoko lakilí! Lou napi liku yambo tonge yamboma lou napini toko konjingíla, aku kene ⸤‘Molo.’ nimbu lou napimene ulu te na teamili⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nane nanga Tara walsipulie “Liku taponji.” nilkenje yuni angello ami talape rurepo,* molo olandopa malapunge telu molo talo, tamburembu na “Liku taponjengi pai.” nimbe lipe mundulke akumu nu na pilkinuye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nakolo ⸤angellomane ongo opa toumane na ‘na tangi.’ ningu liku taponjilimelkanje⸥ Pulu Yemonga bokuna na kinie wendo ombá nimbe molemo mele nambe tepa wendo olkaye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","⸤Aku nimbelie⸥ Yesusini ⸤yu ka singí oringi⸥ ye aisili ongo moloringimendo nimbendo: “Na ‘yambo topa wa noli yere molemo.’ konopu lelkolie na ka singíndu yambo toli lou pulsema kinie kopema kinie mengo okomeleye? Ulke tembele ⸤kerepuluna we yamboma maku toko molemele⸥ koleana alieli ene pea molemolo kinie ungu mane sipu molio kinie na liku ka na silimele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nakolo i sipe wendo okomo ulumanga pali Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi ye marene ulu mare ⸤na kinie⸥ pe wendo ombá mele ou ningu bokuna toringi molemo mele kamu wendo okomo.” nirimu. Kanu kinie yu lombili andolime pali ⸤‘Olio pea ka singínje.’ ningu pilkulie⸥ yu munduku kelko ene talopa lelko puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kanu kinie Yesusi ka sikulie Pulu Yemo popo tonjiringi ye aili olandopa Kayapasi molorumuna mengo puringi. Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* Juda yambomanga tapu yema kinie, enene ⸤‘Yesusi kote tenjipu piliemili.’ ningu⸥ akuna ou ongo maku toko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nakolo ⸤Yesusi mengo puringi kinie⸥ Pita lombili aki lipe taka lepa pupe, Pulu Yemo popo tonjiringi ye aili olandopamonga ulkena, ulke angilipe pala mele makapu terimu, ai suku singine yambo maku toringi kolea we lerimuna paa sukundu pupe, ‘Yesusi nambe tengenje piliembo.’ nimbe ⸤Yesusi nokoko moloringi⸥ ele yema kinie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pulu Yemo popo tonjiringi ye ailime kinie, Juda yambomanga kanjollo yema* pali kinie, akumane Yesusi yu toko konjingindu ulu te tepa kenjirimu ulu te ‘Yambo tene ‘yu i sipe i sipe tepa kenjirimu.’ nimbe kolo topa nipili.’ ningu yambo te koroko moloringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","yambo aisili ongo ungu mare kolo toko niringi nakolo enene yu manda toko konjingí ungu te na niringi. Laye pe mele yambo talo ongolo ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","⸤kolo toko⸥ ningilindu: “I yemo i sipe nirimu ⸤pilirimbulu⸥: “I Pulu Yemo ⸤popo toko kaloli⸥ ulke tembelemo nane topo tekisipulie wale yepoko omba pupili ulke tembele ⸤konde⸥ te manda kolo wangopo takombo.” nirimu.* ⸤Yuni aku nirimumunge ‘Yu Pulu Yemo mele molio.’ konopu lepalie aku nirimumu nimbe kenjirimunje⸥.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aku niringili pilipelie Pulu Yemo popo tonjiringi ye aili olandopamo ola angilipe Yesusi walsipelie nimbendo: “Ungu te pundu toko na nikinuye? Nu ⸤ningu kenjirinu mele⸥ nikimbilimu nambolka ulumu ningu kenjirinumundu nikimbiliye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nakolo Yesusi ungu te pundu topa na nimbe we angilirimu. Pulu Yemo popo tonjiringi ye aili olandopamone yundu altopa nimbendo: “⸤Nu moleno mele paa sike ningu sieni.⸥ Konde Molopa Mindi Puli Pulu Yemo pilipe molopili “Paa sike nikiru.” ningu mi lelkolie, Pulu Yemo yunge Malo,* yuni olio “Nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye nomi Kirasimu** sike nu molo moloye? Olio paa ningu si!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesusini nimbendo: “Akumu na.” ⸤nirimu⸥. “Ungu te pea enendo pali nikirula. Pe walse Manie Omba Mana Ye Au Lerimu Yemo, Ye Tondolo Olandopa Pulimu ⸤kinie melema nokombando⸥ yunge ki umbukundu molopa, kupemanga ola molopa manie ombá ene kanonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aku sipe nirimumunge ⸤‘Yu Pulu Yemo mele molio.’ nimbe nirimuna⸥ pilipelie Pulu Yemo popo tonjiringi ye aili olandopamone ⸤paa pilipe keri pilipe⸥ yunge wale pakolimu yuyu ambolopa sungu sipelie nimbendo: “Kinié yu yuyu paa sike Pulu Yemo ungu taka tonjikimu kene pilipulie mongo lirimu mele nimbe simbe yambo te pea nambemuna koromoloye? Yu yuyu paa sike Pulu Yemo ungu taka tonjikimu pilkimulu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nambolka konopu lekemeleye? ⸤Yu kinie nambe teamiliye?⸥” nirimu kinie enene ningindu: “Yu Pulu Yemo ungu taka tonjimumunge topo konjímulu liemo papu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kanu kinie enene yunge kumbikerena lkambe toko munduku, ki lumuni toringi. Marene yu laruwe tokolie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nu ‘Pulu Yemone olio nokopa konjimbe ye te “Lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu molio.’ nilino kene naene nu tokomonje ningu si.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kanu kinie Pita yu pena mele, yamboma liku maku toringi koleana molorumu kinie* kongono tenjili kendemande ambo te Pita molorumuna omba yundu nimbendo: “Nu kepe Gallilli disiriki ye Yesusi kinie pea tapu toko moloringi kanumanga ye te lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nakolo akuna moloringi yamboma pali kanoko molangi Pitane kolo topalie “Molo.” nimbe “Nu nikinu mele na na pilkiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aku nimbelie Pita yu ulke kerepuluna pupe molopili kongono tenjili kendemande ambo tene yu kanopalie akuna moloringi yambomando nimbendo: “I yemo yu Nasarete ye Yesusi kinie pea tapu toko molongi ye te lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitane altopa “Molo. Nuni nikinu yemo na na kanolio.” nimbelie Pulu Yemonga imbi lepa mi lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Laye kolte pe mele, Pita angilirimuna nondoko angiliringi yemane ⸤yu ungu laye lupe mele nirimu mele pilkulie⸥ yu angilirimuna ongolie yundu ningindu: “Kolea Gallilli disiriki yambomane ungu nilimele mele nu aku siku ungu nikinu pilkimulu. ⸤Yesusi kinie yu lombili andoli yema kinie kolea Gallilli disiriki yemala,⸥ nu kepe Gallilli ye te, aku kene ‘Nu paa sike yu lombili andoli ye te lemo.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aku niringi kinie Pitane Pulu Yemonga imbi lepa tondolo mundupe mi lepalie nimbendo: “Paa sike nikiru. Ene nikimili yemo paa na kanolio. Kolo tokoro liemo Pulu Yemone na topa konjipili.” nirimu. Aku nirimu kinie tamburembu kera gulta ko torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aku terimu kinie pilipelie Yesusini yundu “Kera gulta ou ko na topili nuni wale yepoko kolo tokolie “Yu na kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilirimu.* Pilipelie ⸤‘Ama, paa tepo kenjindu lepamo. ‘Paa na tembo.’ konopu lerindu mele sike tendu.’ nimbe pilipelie⸥ pena pupe kola paa aili tepa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ipulueli ou kolea kokele tangorumu kinie Pulu Yemo popo tonjiringi ye ailime kinie,* Juda yambomanga tapu yema kinie enene pali ⸤Yesusinge kotemo pilku pora sikulie⸥ ‘Yu topo konjemili.’ ningu, ningu panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aku ningu panjikulie yu liku, ka toko, mengo puku, ⸤Romo⸥ gapomano ye nomi Paillate molorumuna mengo puku kote tenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kanu kinie Judasi, yu Yesusi lipe yunge opa touma sirimu ye kanumu, Yesusinge kotemo pilkulie “Kolopili, toko konjengi.” niringi kinie pilipelie yuni Yesusi ene lipe sirimu mele pilipe keri pilipelie kelepa konopu alowa tepa enenga kou sillipa wane paono tene ou yu siringime kelepa memba pupe Pulu Yemo popo tonjiringi ye ailime kinie Juda yambomanga tapu yema kinie sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nane ye ene lipu sindu kanu yemo yu ulu te tepa na kenjili yemo* ‘Toko konjengi.’ nimbu lipu sindumu paa ulu pulu keri te tendu.” nirimu. Nakolo enene pundu toko ningindu: “Akumu olionga ungu te molo. ⸤Nu nunu mindi olio liku sinu.⸥ Akumu nunge kongonomo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kanu kinie Judasi yuni kou sillipa kanuma memba pupe ⸤Pulu Yemo popo toringi⸥ ulke tembele palana topa anjukundu mundupelie yu ene mundupe kelepa anju purumu. Anju pupelie ‘Ka nombo kolambo.’ nimbelie ka te lipe memba pupelie ka nomba kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pulu Yemo popo tonjiringi ye ailimene kou kanuma ⸤manie polona⸥ lerimu kanoko likulie ningindu: “I kouma yambo topo konjimulundu símuluma kene ulke tembele kouma kinie tere lepo nosimulú kinie kapola na temba. Akumunge ungu mane te pelemo kene na nosemili.” ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ungu te ningu panjikulie ningindu: “I kou monemane mingi sosipene mane tepa mimi telemo yemonga mamo topo topo liemili. Yambo ma te na lepa enenga kolea suluna yambo ya ongo molemelemanga yambo kolongema akuna ono teangi.” ningulie aku siku topo toko liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","⸤Kanu kou monemane ye te toko konjingí aulkemo akisinjiringi koumane⸥ aku teringimunge kanu mamo imbi lelko ‘Yambo Toko Meme Ondoringi Mamo’ niringi mele kinié kepe aku sipu nilimolo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","⸤Juda ye ailimene⸥ aku siku teringimunge Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Jeremayane ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Yuni nimbendo: “Ailimuni nando “Tei.” nirimu mele ene aku siku tengendo Isirele yambomane “Ye akumu kou sillipa wane paono tenene topo toko liengi.” niringi kouma likulie, kanu koumane mingi sosipene mane tepa mimi terimu yemonga mamo topo toko liringi.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Judasi aku sipe tepa molopili Yesusi Romo gapomano ye nomi ⸤Paillate⸥ molorumumunge kumbikerena angilirimu kinie kanu ye nomimuni ⸤yunge kotemo pilipelie⸥ yu walsipe pilipelie nimbendo: “Nu Juda yambomanga ye nomi kingimu molo moloye?” nirimu. Yesusini pundu topa nimbendo: “Sike nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pulu Yemo popo tonjiringi ye ailime kinie, ⸤Juda yambomanga⸥ tapu yema kinie, enene Yesusi kote tenjiku Paillatendo ⸤kolo toko⸥ ungu aisili ningulie ningindu “Yesusi yu tepa kenjilimo.” ningu yu kote tenjiringi kinie Yesusi yu ungu te na nimbe we angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","⸤Yesusini ungu te na nirimu kanopalie⸥ Paillatene yundu nimbendo: “Nu ulu keri aisili terinu nikimili mele nu na pilkinuye?” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesusi ⸤yu tepa kenjirimu niringi mele⸥ pundu topa ungu telu kepe na nimbe ⸤karaye na tepa we angilirimu kinie kanopalie Romo⸥ gapomano ye nomi kanumuni paa mini wale mundupe konopu aisili lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","⸤Yesusi kote tenjiku molangi,⸥ ye te, yunge imbi Barapasi, yu mongo lirimu mele yamboma pali pilku moloringi kanu yemo yu ka ulkena perimu. ⸤Ponie tenga tenga, Juda yambomane kolea aili Jerusalleme ongo akuna suku⸥ Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele pilingindu* langi noringi walema wendo orumu kinie enene ka ulkena perimu ye te imbi lelko “Wendo liku mundoi.” ningu mawa teringi kinie ⸤Romo⸥ gapomano ye nomimuni kanu yemo wendo lipe yamboma sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","⸤Aku siku te pu opu teringi walema kamu wendo omba pepili Yesusi kote tenjiringi pilipelie nirimumuni,⸥ Juda yamboma liku maku toko moloringi kinie Paillatene ene walsipelie nimbendo: “Ye nae ka ulkena wendo lipu ene siembo konopu lekemeleye? Ye Barapasi wendo lipu siembo, molo enene “Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu.”* nilimele ye Yesusi wendo lipu siemboye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","⸤We yamboma Juda yambomanga ye ailime munduku kelko enenga unguma liku su siku Yesusinge ungumu pilku yu lombili andoringimunge Juda yambomanga ye ailime⸥ Yesusi kinie konopu keri panjikulie* kote tenjiringine pilipelie Paillatene aku sipe nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paillate kote pilili polona ⸤molopa ‘Juda ye ailimene pundu toko ungu te ningínje.’ nimbe nokopa⸥ molorumu kinie yunge menuni ungu te yu molorumuna nimbe mundupelie nimbendo: “Nuni andi ye sumbi nilimu ulu te na tei. Kinié yu kumbu tepo kanondumunge nanga konopuna umbuni aisili wendo omu kene yu ulu te paa na tei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","⸤Paillatene “Ka ye nae wendo lipu siemboye?” nirimu kinie pilkulie⸥ Pulu Yemo popo tonjiringi ye ailime kinie, ⸤Juda yambomanga⸥ tapu yema kinie, enene we yamboma kondi toko ungu umbu tonjikulie “ “Yesusi topa konjipili. Barapasi wendo lipe sipili.” niei.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","⸤Aku niringi kinie pilipelie Romo⸥ gapomano ye nomimuni enendo “yetolonga ‘nae wendo lipu siembo.’ konopu lekemeleye?” nimbe walsirimu kinie enene pundu toko ningindu: “Ye Barapasi ⸤wendo liku yando si.⸥” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aku niringi kinie pilipelie Paillatene enendo nimbendo: “Aku liemo, enene “Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu.” nilimele ye Yesusi, nambe teamboye?” nimbe walsirimu kinie enene pali “Yu unju perana kolopili uku toko panji!” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aku niringi pilipelie yuni enendo nimbendo: “Aku nambemunaye? Yu mongo nambolka mongore limuye?” nirimu. Nakolo enene ⸤altoko⸥ paa tondolo munduku ningindu: “Molo! Yu kolopili, unju perana uku toko panji!” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yunge ungumu na pilku, opa tenge teringi kanopalie Paillatene no mare kolopa lipe, yambo liku maku toko angiliringime kanoko molangi ki kulumiye topalie nimbendo: “I yemo toko konjingí kolomba kinie* ene kinie ungu pemba; nanga ungu te na pemba.”** nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","⸤Aku sipe nirimu kinie pilkulie⸥ yambomane pundu toko ningindu: “Yu tonge kolombamonga umbuni pembamo olio kinie olionga ambolangoma kinie pepili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kanu kinie ye Barapasi ka ulkena wendo lipe ene sirimu. ⸤Aku tepalie⸥ Yesusi lipe ⸤yunge ami yema⸥ sipelie nimbendo: “Yu ka pulsene tokolie pe ‘Unju perana kolopili.’ ningu mengo puku unju perana uku toko panjipai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kanu kinie ⸤Romo⸥ gapomano ye nomimunge ami yemane Yesusi liku kanu ye nomimu perimu ulke aili* akuna suku ⸤yamboma liku maku toko moloringi koleana⸥ pukulie, enenga ami talape yema pali “⸤Yesusi ya molemona⸥ sukundu sukundu wai.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kanu kinie yunge mulu wambalema kulku wendo linjiku, ‘Yu ye nomi kingi te none tepili.’ ningu mulu wambale kondoli peanga te pakonjiku, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","unju ka koko molorumu te mulkupiye teko ‘Ye nomi kingimunge waniemo.’ ningu pengena mere mundunjiku, kingimene unju kope te we ambolemele mele koló te liku yunge ki umbukundu amonjikulie niringimuni, yu angilirimuna koporongo langoko ungu taka tonjiku imbi we kólo toko ola linjingindu “Juda yambomanga ye nomi kingimu, nu angilinoye?” ningu ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","yunge kumbikerena lkambe toko kanjiku, koló kope ambolorumumu liku yunge pengena kope to pu opu teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yu aku siku ungu taka tonjiku pora sikulie mulu wambale kondolimu kulunjiku, yunge ou panjirimu mulu wambalema altoko panjinjikulie “Yu unju perana kolopili, panjipamolo.” ningu yu liku mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","⸤Romo ami yemane Yesusi Jerusalleme palana⸥ ulsu mengo pungí pukulie niringimuni,* kolea Sairini** ye te, yunge imbi Saimono, ambolko liku ka mele siku Yesusi kolomba unju peramo “Kolo wangoko menji.” ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","⸤Pukulie⸥ kolea Golkota puku akuna moloringi. (Golkotanga ungu pulumu ‘penge ombele leli koleamo’.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","⸤Yesusi akuna mengo pukulie niringimuni, ‘Yamboma mindili na nangi.’ ningu⸥ no waenena suku maratene kombili teli te munduku nosiringi aku no waenemo* ‘Yu nopili.’ ningu, siringi nakolo aku no waenemo nomba pilipelie “Molo.” nimbe na norumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kanu kinie ⸤ami yemane⸥ yu unju perana ola panjikulie unjumu liku ola anjiringi. ⸤Aku tekolie, ou unjuna ola uku toko na panjikulie⸥ yunge mulu wambale ⸤kulunjiku nosiringime⸥ ‘Moke teamili.’ ningu ene yu mele mele lingí mele pilingindu kou kate teko pe mulu wambalema liringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe yu unju perana ola angilipili tapu teko kanoko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","‘Yu mongo lirimu mele yamboma kanangi.’ ningu I YE YESUSI JUDA YAMBOMANGA YE NOMI KINGIMU ningu imbi toko yunge pengena olakondo unjuna monjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Opa tekolo melema wa liringili ye talo pea unju pera talonga uku toko panjiringila. Te Yesusi yunge ki umbukundu uku toko, te ki tarokondo uku toko panjiringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Akuna ongo puringi yambomane Yesusi ⸤kanoko keri kanokolie yu⸥ ungu taka tonjiku iri mele tokolie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ningindu: “Aa! “Ulke tembelemo tekisipulie altopo wale yepoko omba pupili takopo limbu.” nirinu yemo,* ‘Naa kolambo.’ ningu nu nunu liku taponji. Nu sike Pulu Yemonga Malo liemo unju perana manie oi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aku sikula Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* ⸤Juda yambomanga⸥ tapu yema kinie, enene kepe yu ungu taka tonjikulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yu yambo wema ‘Naa kolangi.’ nimbe lipe taponjirimu nakolo yu yuyu ‘Naa kolambo.’ nimbe manda na lipe taponjikimu. Yu ‘Isirele yambomanga ye nomi kingimu ⸤molio.’ nilimo mele sike aku sipe⸥ molemo liemo yu yuyu unjuna manie opili. Yu yuyu unjuna manie ombá kinie kanopolie ‘Yu sike olionga ye nomi kingimu.’ nimbu tondolo mundupu pilimolo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yuni ‘Pulu Yemone na lipe taponjimbe.’ nimbe tondolo mundupe pilipe molemo kanumu; yu “Pulu Yemonga Malo molio.” nilimo* kene Pulu Yemone yu kanopa peanga kanopa, ‘Yu manie we olkanje papu.’ konopu lemu liemo kapola, yu omba yu lipe taponjipe ⸤unjuna wendo lipili⸥. ⸤Aku sipe temu liemo ‘Yu sike Pulu Yemonga Malo.’ nimbu tondolo mundupu pilimolo⸥.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wa noli ye talo yu kinie unjutolonga uku toko panjiringi yetolone yu aku siku ungu taka tonjiringilila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","⸤Yesusi unjuna ola we angilipili⸥ ai tangoli ena tuwellepo killoko terimu kinie kolea pali sumbulu topalie, pe ipupini ena tere killoko terimu kinie kelerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ipupini ena tere killoko mele terimu kinie Yesusini ru nimbelie nimbendo: “Elloi, Elloi, llama sapakatani.” nirimu. Akumu Juda yambomanga ungu te. Akumunge pulumu i sipe: “Nanga Pulu Yemo, nanga Pulu Yemo, na nambemuna munduku kelenuye?”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Akuna nondoko angiliringimenga marene yuni aku nirimu kinie pilku ⸤sundukulie⸥ ningindu: “Pilieme. Yu Illainja walsikimu.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aku nirimu kinie piliringimenga ye te tamburembu lkisipe pupe ulú pinje mele te lipe no waene kombili teli mare akuna panjipelie, ‘Yesusi no waene kombili teli pinjena pelemomo nopili.’* nimbe memba omba unju pepena tenga ka topa olando sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","⸤Nakolo yu no waenemo sirimu mele kanokolie⸥ we yambomane ningindu: “Molo. Kinié unjuna we angilipili. Illainjane sike yu ‘Naa kolopili.’ nimbe lipe taponjipe manie limbendo okomonje, kanopo kanamili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesusini ungu te tondolo ru nimbelie,* pe yunge minimundu ‘Pui.’ nimbe yu kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yu aku sipe kolorumu kinie ⸤ulu aili mare⸥ walsikale ⸤wendo orumu.⸥ Pulu Yemo popo toko kaloringi ulke tembele ⸤Jerusalleme suku angilirimu akuna sukundu Pulu Yemo molorumu⸥ suluminia paa kake telimunge kerepuluna ⸤‘Yamboma sukundu na pangi.’ ningu ou alieli⸥ mulu wambale aili tene pipi siku panjiringi angilirimu. ⸤Yesusi kolopa pora sirimu kinie⸥ kanu mulu wambalemo ai suku singine olakondo maniendo sipe olá torumu.* ⸤Aku tepa,⸥ ma jimi jimi te tepa, kou ailime topa ungu mengu topa, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","yambo ou ono teringi koleama anju yando pupe, Pulu Yemonga yambo kake teli ou koloringime* ⸤Pulu Yemone⸥ topa makinjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lomboroko ola molko ono kolea peringine wendo ongolie, Yesusi pe lomboropa ola molorumu kinie Pulu Yemonga kolea aili kake teline* suku pukulie yambo aisili ‘Kanangi.’ ningu puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","⸤Romo⸥ ami ye wane anderete nokorumu yemo kinie, yu pea Yesusi terimu mele tapu teko kanoko moloringi ami yema kinie, enene ma jimi jimi tepa ulu lupe lupema wendo orumu kinie kanokolie ene paa mini wale mundukulie ningindu: “I yemo yu paa sike Pulu Yemonga Malo lepamo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ambo aisili mele, ⸤Yesusi unju perana kolorumu⸥ akuna sulu teko kanoko angiliringi. Ou kanu amboma ⸤enenga pulu⸥ kolea Gallilli disiriki munduku kelko Yesusi lombili andoko liku taponjiku nokoko ⸤Jerusalleme pea⸥ oringi amboma. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Enenga ambo te Makatalla taono ambo Maria, te Jemisi kinie Josese kinie eltenga anumu Maria, te ye Seperinge malotolonga anumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ipupini, kolea kala tomba terimu kinie Arimatia taono ye kamako te, yunge imbi Josepo, yu kepe Yesusi lombili andorumu ye te, yu omba ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","⸤Romo gapomano ye nomi⸥ Paillate molorumuna pupe, “Yesusinge onomo na si.” nimbe mawa terimu kinie Paillatene yu “Onomo lipili.” nimbe ⸤ami yemando nimbe mundurumu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","⸤Paillatene “Kapola.” nirimu kinie⸥ Josepo pupe onomo manie lipe, mulu konde tene lipe kulupi torumu. Kulupi topalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kou kande konde te, Josepo yu ‘Kolombo kinie akuna na ono teangi.’ nimbe kou kande te akupe nosirimu kou kandemonga suku memba pupe nosirimu. Nosipelie kou kande kerepuluna kou aili te perele marele memba omba pipi sipelie yu kelepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makatalla taono ambo Maria kinie Maria te kinie* elte kou kandemo lerimu kerepuluna nondoko ⸤yu onomo kou kandena nosirimu mele kanoko⸥** moloringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","⸤Kanu kinie,⸥ ‘Opali ⸤koro molomolo wale⸥ Sambatemo.’* ningu pilkulie, kinié mele, melema undu undu siringi kanu walemo pora nirimu kinie opalikundu Pulu Yemo popo tonjiringi ye ailime kinie, Parisi yema kinie,** ene ⸤Romo gapomano ye nomi⸥ Paillate molorumuna puku liku maku toko angilkulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ningindu: “Ye Ailimu, ye kanumu ou na kolopa we molopalie yambomane ‘Sike.’ ningu pilingí unguma kolo topa nirimu kanu yemo yu “Kolopolie wale yepoko omba pumbe kinie lomboropo ola molombo.” nirimu* olio pilirimulu kene ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","⸤nuni ami yemando⸥ “Kanu yemo ⸤bonongo⸥ ono tengi kou kandemo wale yepoko paa mimi siku nokai!” nieni. Naa nokonge kinie yunge lombili andoli yemane onomo ongo wa liku mengo pukulie “Yu lomboropa ola molopa omba pumu.” ningí. Aku siku kolo toko ningí kinie yu ou ‘ ‘Sike nikimu.’ niengi.’ nimbe kolo torumu ungumu maniendopa, enene ‘Yambomane ‘Yuni sike aku sipe temu.’ niengi.’ ningu kolo tonge ungumu paa olandopa pemba.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paillatene ⸤Juda ye ailimendo⸥ pundu topa nimbendo: “⸤Aku liemo,⸥ ami ye mare liku mengo puku, “Yemo ono tengi koleamo nokoko konjengi.” ningu monjiku, ‘Yambomane ono koleamo ulu te na teangi.’ ningu ‘Aulkemo tondolo pipi siemili.’ konopu lenge mele teangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","⸤Aku nirimu kinie⸥ pilkulie ami ye mare liku mengo puku, yambo ono kou kandemo pipi siringi koumu pala teko pele lelko enenga imbimu akuna toko monjikulie, “Ami yema akuna nokoko molangi.” ningu monjikulie ⸤ene puringi⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","⸤Juda yambomanga koro moloringi⸥ wale Sambatemo pora nimbe, enenga pulu pulu kongono walemo* wendo ombando kolea tangombando muni lerimu kinie Makatalla taono ambo Maria kinie, Maria te kinie,** pukulu ⸤Yesusinge⸥ onomo nosiringi kou kandena ⸤onomo⸥ kanongele puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ailimunge mulu koleana angello te manie orumu kinie ma jimi jimi paa tondolo tepa terimu.* Angellomone omba kou kandena pupe kou kande kerepulumu pipi siringi koumu wendo lipe perele marele memba pupe nosipe akuna ola molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kanu angellomonga kumbikeremo kariapá tepa pa telemo mele pa tepa, mulu pakorumuma kalopera topa paa kake telemo mele kake terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yesusi ono kolea nokoringi ami yema angellomo kanoko paa mini wale munduku pungu pungu ningulie yambo kololimene ungu na ningu ulu te na telemele mele ene aku siku uluri na teko we moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angellomone ambotolondo nimbendo: “Pipili na kolale. Yesusi ‘Kolopili.’ ningu talko unju perana uku toko panjiringi kanu yemo kanongele okombele na pilkiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yu ya na lemo. ⸤“Kolopolie wale yepoko sipemonga⸥ lomboropo ola molombo.” ou nirimu aku mele temu. Onomo ou lerimu koleamo ongo kanale. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kanokololie popenge teko pukulu yunge lombili andolime i siku ningu siengili: “Yesusi ono koleana lepalie lomboropa ola molopa kolea Gallilli disirikindu kumbi lepa pulimo kene ene akuna yu kanonge.”* ningu siengili. ⸤Ungu nimbu sinjimbundu ondu⸥ kanu ungumu nimbu pora sikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","⸤Angellomo aku sipe omba mona molopalie nirimu mele⸥ kanoko pilkululie ambotolo pipili kolkolo kamele paa akokolo, aku sipe konopu talo pepili lkisiku pukulu yunge lombili andolime ningu singilí puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","⸤Lkisiku pungilí puringili kinie⸥ Yesusi lipe sinjipe elte aulkena kanopa lipelie “Okombeleye?” nirimu. Kanu kinie eltene yunge kimbukundu puku kangulkulu yu kapi ningu imbi ola linjiringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kanu kinie Yesusini eltendo nimbendo: “Pipili na kolkololie, elte pukulu nanga angenupilindu ningilindu: “Kolea Gallillindu pangi. Yu akuna kanonge.” nipale.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ambotolo kelko yando ongele oringili kinie Yesusinge ono kou kandemo nokoringi ami ye mare kolea aili ⸤Jerusalleme⸥ suku puku Pulu Yemo popo tonjiringi ye ailimendo* uluma wendo orumu mele pali ningu sipuringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","⸤Piliringi kinie⸥ popo tonjiringi ye ailime, Juda yambomanga ye ailime kinie pea maku tokolie ene kinie ⸤ungu ningulie ningindu: “We yamboma i uluma wendo omu mele pilkulie “Yesusi lomboropa ola molomunje.” ningí kene ‘Naa piliengi!’ nimbu nambe teamolonje?” ningu⸥ kerepali ningulie tenge mele ningu panjikulie niringimuni, ami yema kou mone aisili sikulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","enendo ningindu: “Yambomane “Yesusi nambe temuye?” ningu walsingí kinie enene i siku niengi: “Ipulueli uru pemulu kinie yunge lombili andolimene kiyongo ningu ongo yu liku mengo púngi.” niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","⸤Olio Juda yamboma nokolemo Romo⸥ gapomano ye nomimuni ⸤aku tengi mele⸥ ungu te pilimu liemo ‘Ene mongo na liengi.’ nimbu olione enenga lipu taponjipu yu kinie ungu nimulú, kanu kinie ‘Enene ono koleamo mimi siku na nokoko we uru pengi.’ konopu lembamonga mongo na lingí.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aku niringimunge pilkulie ami yemane kou mone liku enene “Niei.” niringi mele yambomando niringi. Akumunge yandopa kinié i ⸤boku tokoro⸥ walemo kepe Juda yambomanga koleamanga pali i ungumu anju anju pulimo pilkulie yambo aisilini kanu temanemo toko molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","⸤Amboma pukulie kanoko piliringi mele temane toko siringi⸥ kinie pilkulie Yesusi lombili andoli ye rureponga yepoko kolea Gallilli disiriki puku, Yesusini ma pangi te imbi lepa ou “Akuna wangi.” nirimu ma pangine puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akuna puku Yesusi kanokolie niringimuni, yu kapi ningu yunge imbi ambolko ola linjiringi nakolo marene ‘Yesusi kolorumu. Imu Yesusi molo naenje?’ ningu konopu talo teko leringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kanu kinie Yesusi yu nondopa omba enendo nimbendo: “Tarane nando “Nu nunu mulu koleana melema kinie yamboma kinie, ma koleana melema kinie yamboma kinie nokani.” nimbe tondolomo* na sirimu, na kinie pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aku ⸤tondolo na sirimumu ene simbu ene kinie pemba⸥ kene ene ma koleamanga pali puku ‘Yamboma pali nanga ungumu pilku liku, nanga lombili andolime molangi.’ ningu, puku ningu sipukulie ningímuni, ⸤pilku liku molonge⸥ yamboma no linjingindu Lapa kinie Malo kinie Mini Kake Telimu kinie enenga imbi lelko* ene no linjiku, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","enendo “Na lombili andolimene teangi.” nirindu mele pali ‘Aku yamboma teangi.’ ningu ene mane siengi. Aku siku niliku andoko molonge kinie na ene kinie alieli molambo mulu matolo pora nimbé.” nirimu.* ⸤Aku pea.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesusi, Pulu Yemone mako topa “Olio nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu, Pulu Yemonga Malo,* yunge temane peangamo pulu polorumu mele** ⸤ya inie tombo tokoro⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","⸤Yesusi, Pulu Yemone mako torumu ye nomi Kirasimunge temane peanga imu wendo ombándo ye te ou omba temba mele⸥ Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane* Pulu Yemonga ungu te nimbe boku torumu akuna molemo mele i sipe: ‘⸤Pulu Yemone nimbendo: “⸤Pílie!⸥ Nane ‘ ‘Nanga ungu umbu tonjilime pilipe nimbe sipili.’ nimbu lipu mundumbu yemone nunge aulkemo akisinjipili.’ nimbu yu “Kumbi lelko pui.” nikiru.’** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Kolea ku leline ⸤kumbi lepa pumbe⸥ ye tenga kerena ungu te nimbendo: “Ailimu ombá aulkemo teko mimi teame. Yu ombá aulke kangama toko sumbi siei.” nikimu.’* nimbe ⸤Aisayane Jonone paa pe temba mele ou aku sipe nimbe sipe bokuna torumu molemo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Akumunge, ⸤temane peangamo pulu monjimbendo No Linjili⸥ Jono kolea ku leli tenga wendo omba ⸤aku sipe⸥ ungu mare yamboma nimbe sipe molorumu. Kolea Judia disiriki yamboma pali kinie kolea Judianga kolea aili Jerusalleme yamboma pali kinie ene yu molorumuna puku yunge ungumu pilingí puringi. Yuni ungu te enendo nimbe sipelie nimbendo: “Ene ulu pulu keri telemelema kanoko keri kanoko konopu alowa tekolie ‘Pulu Yemone olionga ulu pulu kerime ‘We manie pupili.’ nimbe siye kolopili.’ ningu ‘No liemili.’ ningu wai.” nirimu. Aku sipe nirimu kinie enenga ulu pulu keri teringime ningu para siringi kinie yuni ene no Jodane kolo no linjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jono kongi kemelenga indini teli wale pakoli te pakopa, kongi kilumuni teli kakomo topalie, kulikumbe kinie pilimu no kinie aku langitolo mindi nomba molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Yuni yamboma ungu nimbe sirimu mele i sipe: “Nane sike ene no linjilio nakolo ye te akilipe ⸤nondopa⸥ ombá ⸤tekemo⸥mo yuni ene ⸤Pulu Yemonga⸥ Mini Kake Telimu linjimbe ⸤lingí⸥.. I na akilipe ombá yemo yunge tondolomo paa olandopa, nanga tondolomo paa maniendopa, na yu kinie manda molo. Yambo ailimenga kongono keri tenjili kendemande yambomane sike enenga ailimenga kongono keri tenjingindu manie molko enenga yambo ailimenga kimbu suma ka pilke tonjilimele nakolo na ye paa kerimu moliomonga kanu ombá yemo yunge kimbu su ka pilke tonjili kanu kongonomo paa olandopa mele, nane tenjilkenje kapola naa telka. ⸤Na ye paa kerimu, yu ye paa ailimu.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","⸤Jono yamboma no linjipe molorumu⸥ kanu walemo kinie Yesusi kolea Gallilli disiriki Nasarete taono mundupe kelepa ⸤Jono molorumuna⸥ orumu kinie Jonone yu no Jodane kolo no linjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","⸤Yesusi no lipe pora sipelie⸥ nona wendo omba angilirimu kinie sumbi sipe mulúmu kengeya lepa anju yando purumu kanopalie, Pulu Yemonga Minimu, kera waembono mele, manie omba Yesusi molorumuna pupe kangine ola molorumu kanorumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kanu kinie muluna ola ungu te wendo ombalie nimbendo: “Nu nanga konopu monjilio kangomo. Nu kinie konopu sipu molio.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","⸤Yesusi no lirimu kinie Pulu Yemonga Minimu yu kinie omba molopalie nirimumuni,⸥ sumbi sipe Minimuni Yesusi kolea ku leline pulu sipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","⸤Akuna purumu kinie,⸥ oli te koro talo Yesusi aku kolea ku leline takara melema kinie molopili ⸤kurumanga nomi⸥ Setene* omba yu kondi torumu.** Kanu kinie ⸤mulu koleana⸥ angelloma ongo yu nokoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kanu kinie ⸤No Linjili⸥ Jono ka siku ka ulkena panjiringi* kinie pilipelie Yesusi kelepa kolea Gallilli disiriki omba Pulu Yemonga temane peangamo topa silipe andorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","⸤Topa silipe andopalie⸥ nimbendo: “Kinié enamo kamu wendo okomo, Pulu Yemo ye nomi kingimu molomba enamo* nondopa wendo okomo kene ulu pulu kerime munduku kelko konopu alowa teko, ‘Temane peangamo yu sike ungumu.’ ningu tondolo munduku piliei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","⸤Aku sipe nilipe andopa⸥ nomu Gallilli kélona andopalie Yesusini Saimono kinie Saimono angenu Enderutolo oma lili wale te nomuna toko munduku moloringili kanorumu. Oma liringili akumu eltenga kou kongono teringili kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","⸤Aku siku teko moloringili kanopalie⸥ Yesusini eltendo nimbendo: “Na lombili wale. Oma lingilindu oma lili wale te liku nona manie mundulimbele kinie omama walena omba pelemo mele, pe ‘nanga kongonomo tengelendo nanga ungumu pilkulu ningu siliku andongele kinie yamboma nanga talapena sukundu ongo molangi.’ nimbu ‘Elte na lombili wale.’ nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","⸤Aku nirimu kinie pilkululie⸥ tamburembu eltenga oma lili walema munduku kelkololie Yesusi lombili puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","⸤Kanu kinie⸥ yu laye kolte wilsu pupelie, Seperinge malo Jemisi kinie Jemisi angenu Jono kinie eltenga nona andoli sipine sukundu molkolo oma lili walema toko tambuluringili kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","walsikale eltendo “Wale.” nirimu. Kanu kinie lapa Seperi kinie kongono yema kinie sipine sukundu molangi munduku kelkololie Yesusi lombili puringili.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","⸤Kanu ye pokore Yesusi lombili puringi kinie⸥ yu kinie ene Kapeniame taono puringi. Kanu kinie ⸤Juda yambomanga⸥ koro moloringi wale Sambatemo* wendo orumu kinie Yesusi Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkena suku pupe yamboma mane sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mane sirimu kinie Pulu Yemonga ungu manemanga puluma pilku ene mane siringi yemane* we mane siringi mele Yesusini aku sipe mane naa sirimu. Namba lerimu yemane pipili naa kolko tondolo munduku mane siringi mele yuni aku sipe mane sirimuna pilkulie yambomane mini wale munduringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kanu kinie ulke kanuna suku kuru te ye tenga konopuna molopa ya ambolorumu ye te molorumu, ⸤yemonga konopuna suku molorumu kanu kurumuni yu “Ungu ni.” nimbe tópe sirimuna⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yuni opa ungu nimbelie nimbendo: “Nasarete taono ye Yesusi, nu pea olio ⸤kuruma⸥ kinie teluna tapu topo manda naa molomolo. Nu olio kinie nambemuna onuye? Nu olio toko konjini onuye? Nane nunge imbi pilio. Nu Pulu Yemonga Ye Kake Telimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","⸤Aku sipe nirimuna pilipelie⸥ Yesusini kanu kurumu iri topalie yundu nimbendo: “Nu ungu naa ningu yemonga konopuna ongo wendo pui.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kurumuni yemo ambolopa tondolo mundupe puru puru sipelie kalle nilipe omba wendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","⸤Yesusini aku terimu kanokolie⸥ yamboma suru ningu, mini wale munduku ene eneno anju yando ningindu: “I ulumu nambolka uluri tekemonje? Ungu mane konde te wendo ombamo. Ye namba leli tene we yambomando “Teai.” nilimo mele i yemone kurumando kepe aku sipe nilimo kinie kanu kuruma yunge ungumu pilku liku telemele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanu kinie kolea Gallilli disiriki koleamanga pali yuni aku sipe terimu mele temanemo tamburembu anju anju purumu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kanu kinie ⸤Yesusi kinie, yu lombili andoli yema kinie⸥ ene kanu maku toko Pulu Yemonga ungumu piliringi ulkemo munduku kelko wendo ongolie niringimuni, ene kinie, Jemisi Jonotolo kinie ene puku Saimono kinie Enderutolonga ulkena puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ulkena sukundu puringi kinie Saimononga kolepa ambomo kuru topa kangi nopili lerimumu Yesusi ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aku siku niringi pilipelie ambomo lerimuna pupe yunge kimu ambolopalie yu ola lirimu kinie kangi nomba kelerimu kinie ambomone ⸤ola angilipe wendo ombalie⸥ oringi yema langi sipe nokorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pe kolea kalá topa ena purumu kinie, kuru torumu yamboma kinie, konopuna kuru molorumu yamboma kinie, Yesusi molorumuna mengo oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kanu koleana moloringi yamboma pali Saimononga ulke kerepuluna ongo maku toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kanu kinie Yesusini yambo kuru lupe lupe torumu aisili tepa konde lipe, yambomanga konopuna moloringi kuru aisili topa makororumula.* Kurumane Yesusi ⸤Pulu Yemonga Malo, yu Pulu Yemone mako topa lipe mundurumu ye nomi Kirasimu⸥ molorumu mele piliringine yuni enendo “Molio mele anju ningu naa siei.” nimbe enenga kerema pipi sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ipulueli ou, kolea muni ou naa lepa sumbulu topa pepili Yesusi ola molopa penando pupelie nirimumuni, kolea ku leli tenga pupe, akuna Pulu Yemo kinie ungu nimbe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimono kinie pea moloringi yema kinie ene yu koroliku lombili pukulie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","yu kanoko lenjikulie yundu ningindu: “Yambomane pali nu korokomele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","⸤Aku niringi pilipelie⸥ yuni enendo nimbendo: “Na kolea marenga kepe ungu nimbu siembo kene i koleamo mundupu kelepo kolea tenga pamili. Ne nondopa lemo koleamanga pamili. Na koleamanga pali ungu nimbu simbundu mana manie orundu kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aku nimbelie yu kolea Gallilli disiriki sukundu koleamanga pali andopa Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkemanga sukundu pupe ungu nimbe sipe, yambomanga konopuna kuru moloringime topa makororumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Walse ye te kuru laká nomba perimumu* Yesusi molorumuna omba yunge kumbikerena koporongo langopa yu mawa tepalie nimbendo: “Nunge konopumuni na ‘Konde pambo.’ konopu lenu liemo nuni na manda teko konde lini.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kanu kinie Yesusini yu paa kondo kolopalie yunge kimuni yemo ambolopalie yundu nimbendo: “‘Nu konde pani.’ konopu lekero kene konde pui.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","kuru lakámo tamburembu nomba kelerimu, yemo konde pupe umbu kangi lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kanu kinie Yesusini yu ungu te tondolo mundupe nimbendo: “Nuni ya ulu tekeromo yambo telurindu kepe paa naa ni!* Sumbi siku puku Pulu Yemo popo tonjili yemo** nunge kangimu liku ora siku, ‘Na altopo kangi peanga lepili molkoro kene.’ ningu Mosisini “Tei.” nimbe ungu mane sirimumu pilku liku tenindu “Pulu Yemo popo toko kalko si.” nirimu mélemo liku Pulu Yemo popo tonjili yemondo “Kalonji.” ningu yu sieni. Pe yambomane nu kanokolie ‘Yu sike kangi peanga lepili molemo.’ ningu piliengi kene nikiru mele isili ou tepui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nakolo yemo yu anju pupelie ungu aisili yambo aisilindu anju anju nimbe para silipe andopa, Yesusini yu kinie terimu temanemo topa sirimu. Yemone aku terimuna Yesusi ⸤‘Yambo aisili na molombona nondoko nondoko ongo maku naa tangi.’ nimbe⸥ altopa taonomanga sukundu mona manda naa andopalie kolea ku leline molorumu, nakolo kanuna yambo aisili kolea lupe lupemanga molko sukundu sukundu ongo yu molorumuna maku toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wale mare omba purumu kinie Yesusi Kapeniame taono altopa sukundu purumu. Yu ou perimu ulkena altopa omba molorumu yambomane pilkulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ene aisili ongo ulkena sukundu sukundu ongo liku maku toko moloringi kinie ulke kanuna ekelepa terimuna yambo mare molonge kolea te naa lerimuna pena moloringila. Yuni ene ⸤Pulu Yemonga⸥ ungumu nimbe sipe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","⸤Yuni nirimu mele aku siku maku toko pilku molangi⸥ yambo mare kimbu ki kolopa pora sirimu ye te mengo oringi. Kanu yambomanga ye kisene kanu yemo taropola teko mengo Yesusi molorumuna onge oringi nakolo ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","yambo aisili ulkena ekelepa teko angiliringine yu molorumuna nondoko mengo pungí aulke te naa lerimuna ulke imuna mengo ola pukulie* Yesusi molorumuna kana kana ulkemo tekisikulie yemo taropola pali moko toko manie munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","⸤‘Yesusini i yemo manda tepa konde limbe.’ ningu⸥ tondolo munduku pilkulie* yu mengo oringi kanopa pilipelie Yesusini kimbu ki kolopa pora sirimu yemondo nimbendo: “Nanga kangomo, nunge konopuna ulu pulu keri terinu pelemoma manie pupili, we siye kolkoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","⸤Kanu kinie,⸥ Pulu Yemonga ungu manemanga puluma pilku mane siringi ye mare* eneno akuna molko ⸤Yesusini aku nirimu kinie pilkulie pilku keri pilku⸥ konopu kimbu sikulie, “Nendi yemone ungu aku sipe nambemuna nikimuye? Yu Pulu Yemo marake tekemo. Yambomane ulu pulu keri telemelema naene ‘Manie pupili, siye kolkoro.’ manda nimbeye? Pulu Yemone mindi manda telemo.” ningu eneno ningu pilku molko konopu kimbú siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kanu kinie Yesusini ene aku siku konopu kimbú siku moloringi mele yunge konopuni sumbi sipe pilipelie enendo nimbendo: “Enene ⸤nane nikirumunge⸥ aku siku nambemuna konopu kimbú sikimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","I yemondo “Nunge ulu pulu kerime manie pupili, we siye kolkoro.” nimbú kinie ene ulu te naa kanokolie ‘We we tepa nikimu.’ konopu lengeye? Molo “Ola angilku nunge kunungumu liku mengo kimbu kongono teko andoi.” nimbú kinie yu ola angilimbene naa angilimbenje mona lemba manda kanokolie ‘Aku sipe mindili sipe nikimunje.’ konopu lengeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nakolo ‘ ‘Manie Omba Mana Ye Au Lerimu Yemo* tondolo pelemomone ya ma koleana yambomanga ulu pulu kerime “Manie pupili, we siye kolkoro.” manda nimbé.’ ningu piliengi!’ nimbu aku sipu nindu.” nirimu. Aku nimbelie kimbu ki kolopa pora sili yemondo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nane ‘Nu ola angilku nunge kunungumu liku mengo ulkendo pui.’ nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aku nirimu kinie yemo ola angilipe tamburembu kunungumu lipe memba, ene pali kanoko molangi omba pena purumu. Yu aku terimu kanokolie ene suru ningu mini wale mundukulie Pulu Yemonga imbi ambolko ola linjiku yu kapi ningulie ningindu: “Olio i ulu wendo okomo kanokomolo mele ou walse kepe ulu te aku sipu paa naa kanorumulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesusi ⸤ulkemo mundupe kelepa⸥ pena pupelie altopa nomu Gallilli kélona pupe andopa molorumu. Kanu kinie yu molorumuna yambo aisili ongo liku maku toko moloringi kinie yuni ene mane sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kanu kinie yu pumbe pupelie nirimumuni, Allapiasi malo LLipai* kou takisi liringi ulkena ⸤kou takisi lipe⸥ molorumu kanopalie yundu “Nu na kinie pea pambili lombili oi.” nirimu. Kanu kinie LLipai yu ola angilipe yu lombili purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pe Yesusi LLipainge ulkena langi nomba molorumu kinie kou takisi lili yema kinie, ⸤Juda ye ailimene⸥ “ulu pulu keri teli ye” ⸤niringi⸥ wema kinie aisili ongo Yesusi kinie yu lombili andoli yema kinie ene pea manie molko langi noringi. Aku sili yambo aisili alieli yu lombili andoringimunge ene aisili ⸤akuna lombili puku⸥ pea langi nongo moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yesusi yu “ulu pulu keri telime” niringi yambo wema kinie kou takisi lili yema kinie pea langi nongo moloringi kanokolie Parisi ye marene,* Pulu Yemonga ungu manemanga puluma pilku mane siringi kanu yemane, Yesusi lombili andolimendo ningindu: “Kou takisi lili yema kinie, ulu pulu kerime teli wema kinie, ene kinie yu nambemuna langi pea nokomeleye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aku siku niringi pilipelie Yesusini enendo nimbendo: “Kuru naa tolemo yamboma doketana naa pulimele. Kuru tolemo yamboma mindi doketana pulimele kanumu.* Nane “Yambo sumbi nilime na molombona wangi.” nimbundu ma koleana naa orundu.** ‘Ulu pulu keri teli yamboma na molombona wangi.’ nimbundu orundu. Ulu pulu keri teli yamboma lipu taponjimbundu orundu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","No Linjili Jono lombili andoringi yema kinie, Parisi yema lombili andoringime kinie, ene walse walse langi mi toko naa noringi mele* walse aku siku teko moloringila. ⸤Aku teringine⸥ yambo mare Yesusi molorumuna ongo yu walsiku pilkulie ningindu: “Jono lombili andolime kinie,** Parisi yema lombili andolime kinie,** alieli langi mi toko naa nolemele nakolo nu lombili andolime** aku siku naa telemele akumu nambemuna naa telemeleye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","⸤Aku siku niringi kinie pilipelie⸥ Yesusini pundu topa enendo ⸤ungu iku te topa yu kinie ulu te wendo ombá mele nimbelie⸥ nimbendo: “Ambo limbe ye te yunge pulu lemo yema kinie molemo kinie ene konopu sikulie “Langi mi topo naa namili.” manda ningíye? ⸤Manda naa ningí.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nakolo pe, ambo limbe yemo ene molongena ongo wendo lingí kinie kanu walemanga sike ⸤konopu keri panjiku⸥ langi naa nongendo mi tonge. ⸤Isili ou molo.⸥”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","* “Mulu wambale ou te sungu nilimo kinie olione mulu wambale paa konde tenga te kopisipu lipu, sungu nilimomonga naa topo tambululimolo kanumu. Yambo tene aku sipe topa tambulkenje kanu mulu wambalemo nona panjilke kinie mulu wambale konde kopisilimu kanga lepa lli nimbelie mulu wambale oumu kelepa kamu aili tepa sungu nilke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kongi meme kalumuni teli mingi ou tenga* no waene konde naa la kolemolo kanumu. Yambo tene mingi ou tenga no waene konde te kolkanje kanu no waenemo mingine sukundu pepalie pe akolka kinie kanu mingi oumu naa akopa sungu nilke. Kanu kinie nomo kepe mingimu kepe kamu keri lelka. Akumunge no waene konde kongi meme kalumuni teli mingi kondena mindi kolemolo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Walse, ⸤Juda yambomanga koro moloringi⸥ wale Sambate tenga,* Yesusi kinie yu lombili andolime kinie rasi witi poniemanga ongo puringi kinie yu lombili andoli yemane rasi witi mongo mare ⸤nongendo⸥ inie toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aku teringi kanokolie Parisi yemane* Yesusindu ningindu: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa teangi.’ nimbe pelemo ungu manemo** nambemuna nu lombili andoli yemane manemo pulue tokolie aku siku tekemeleye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesusini pundu topa nimbendo: “Ene Pulu Yemonga bokuna sukundu ⸤anda kolepa ye nomi kingi⸥ Depisini* terimu mele nimbe molemo temanemo kanokolie ⸤temanemonga pulumu⸥ naa pilimeleye? Depisi kinie yu pea puringi yema kinie ene ⸤langi⸥ molo torumu⸤munge⸥ engelene kolkolie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pulu Yemo popo tonjiringi ye aili olandopa Apayata molopili Depisi Pulu Yemo molorumu sele ulkena sukundu pupe, Pulu Yemonga kumbikerena lerimu pillawa kalolime lipe nomba, yu pea puringi yema sirimu noringila kanumu.* Kanu pillawa kalolimendo Pulu Yemone ungu mane sipelie nimbendo: “We yambomane paa naa nangi! Pulu Yemo popo tonjili yema manjiku nangi!”** nirimu ⸤kanu ungu manemo pulue torumu⸥ kanumu. ⸤Ene konopu talo nambemuna lemeleye? Depisi yuni ou aku terimu mele ene pilku keri naa pilimelemonga pe kinié na lombili andoli yemane tekemele mele kanoko keri naa la kanai!⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aku nimbelie ungu te pea nimbendo: “Pulu Yemone ‘Yamboma molko konjengi.’ nimbe koro molonge wale Sambatemo lipe ene sirimu kanumu. ‘Sambate walemo pepa konjipili.’ nimbe yamboma lipe Sambate walemo naa sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akumunge Sambate walemo kepe Manie Omba Mana Ye Au Lerimu Yemo nokolemo yemo molemona ⸤Sambate wale kinie yamboma molko konjingindu tenge mele manda nimbé kanumu⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pe walse Yesusi pupe Juda yamboma maku toko Pulu Yemonga ungu piliringi ulke tenga purumu. Kanu ulkena ye te molorumu, yunge ki te kamu kolopa kukurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kanu kinie akuna moloringi ye marene ‘Yesusini ulu te tepa kenjimbe kinie yu kote tenjimulú.’ ningu ulu te tepa kenjimbe te ⸤alieli koroko molkolie⸥ ‘⸤Koro molemolo⸥ wale Sambate kinie* yuni yemo tepa konde limbenje.’ ningu yu mimi siku kanoko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesusini kanu ki kolopa kukurumu yemondo nimbendo: “Yamboma molemelena ongo ola angilieni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kanu kinie yemando nimbendo: “Sambate wale kinie ulu nambolka ulu te manda temoloye? ‘Sambate walemonga ungu manemone “Teangi.” nilimo mele teamili.’ nimbu yamboma lipu taponjimulú kinie manda molo tepo kenjimulú kinie mandaye? ‘Naa kolangi konde pangi.’ nimbu temolomo manda molo topo konjimulúmu mandaye?” nimbe walsirimu kinie pilkulie enene ungu te pundu toko naa ningu we moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yuni ene nemo nemo nimbe kanopalie mumindili kolopa ene yemo kondo naa koloringi kanopalie lakopa konopu keri panjipelie ki kolopa kukurumu yemondo nimbendo: “Nunge kimu sinio si.” nirimu kinie yemone yunge kimu sinio sirimu kinie ki kolopa kukurumumu altopa kamu peanga lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","⸤Yesusini aku terimu kinie kanokolie⸥ Parisi yema* pena puku, ene kinie ye nomi kingi Erotenga talapena yema kinie maku toko “Yu nambe tepo topo konjimulúye?” ningu aulke te kororingi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesusi kinie yu lombili andolime kinie* ene nomu Gallilli puringi kinie yambo aisili lombili puringila.* Kolea Gallilli disiriki yamboma kinie, Judia disiriki yamboma kinie, kolea aili Jerusalleme yamboma kinie, Idumia disiriki yamboma kinie, no Jodane nekendo lemo koleamanga yamboma kinie, kolea aili Taya kinie Saidonotolo lerimu koleamanga yamboma kinie, aku koleamanga moloringi yamboma pali Yesusi uluma tepa molorumu mele pilkulie yu molorumuna oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesusini yambo aisili tepa konde lirimuna yambo kuru lupe lupe torumumane ‘Yu ambolamili.’ ningu* yu angilirimuna nondoko pungindu ekelepa teringine Yesusini yu lombili andolimendo nimbendo: “Yambo paa aisili ongo molemele. Yamboma na molombona nondoko ongo ekelepa naa teangi kene sipi te nondoko mengo ongo nosengi. Na molombona yamboma nondoko ongo ekelepa tenge kinie sipine suku pumbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","⸤Yambomanga konopuna⸥ kuru moloringimene yu kanokolie alieli koporongo langoko tondolo ru ningulie ningindu: “Nu Pulu Yemonga Malo.”* niringi ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","nakolo Yesusini enendo nimbendo: “Yu ⸤sike⸥ molemo mele ⸤yambomane naa piliengi kene⸥ paa naa ningu para siei!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","⸤Pe walse⸥ Yesusi yu ma pangi tenga ola pupelie yuyu pilipelie ‘yu kinie pea tapu topo molamili.’ nimbe pilirimu yemando “Wai.” nirimu kinie yu molorumuna oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Oringi yemanga ye engaki rurepo lipe, yu kinie pea tapu toko molko, “Ene nanga kongonomo tenjipangi lipu mundumbu yema molangi.” nimbe ene mako torumu.* ‘Ene koleamanga andoko Pulu Yemonga temane peangamo toko sipuku, yambomanga konopuna kuru molombama toko makoronge tondolomo ene kinie pepili andoko toko makorangi lipu mundumbu.’ nimbe kanu ye engaki rurepo aku sipe lipe mako torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kanu ye rurepo mako torumumanga imbime i sipe: Saimono (yunge imbi te Pita) yu keme, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Seperi malo Jemisi keme, Jemisi angenu Jono keme, (elte imbi te Boanekesi sirimula. Boanekesi yunge ungu pulumu mulú tolimunge malotolo.) elte kinie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","⸤Pita angenu⸥ Enderu keme, Pillipu keme, Batollomiu keme, Mateyu keme, Tomasi keme, Allapiasinge malo Jemisi keme, Tadiasi keme, “Olio Juda yamboma oliolio gapomano molamili.” niringi talape ye Saimono keme, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judasi Isikeriote, Yesusi pe lipe opa touma sirimu yemo keme, ⸤aku yema ‘yunge kongonomo tenjipangi lipu mundumbu.’ nimbe mako torumu yema⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kanu kinie Yesusi kinie yu lombili andolime kinie ene ulke tenga sukundu puringi kinie yambo aisili akuna ongo liku maku toko moloringine ene langi nonge ena te kepe paa naa lerimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kanu kinie Yesusi pulu lerimu yamboma ⸤Yesusini aku terimu mele⸥ pilkulie “Kangomo paa kekelepa tomu.” ningu yu lingí oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pulu Yemonga ungu manemanga puluma pilku mane siringi ye mare* Jerusalleme molko oringi kanu yemane ningindu: “Kurumanga nomi Belsipuli** Yesusinge konopuna molopalie yu tondolo silimona yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aku siku niringi pilipelie ⸤Yesusi Setene kinie opa tou moloringilimunge ‘Setenene yu naa lipe taponjilke paa piliengi!’ nimbe⸥ Yesusini enendo “Wai.” nimbelie enendo ungu iku topa nimbendo: “Setenene Setene yuyu* nambe tepa topa makorombaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yambo talape te konopu teluna naa pupili molko suku singine owe panjiku ene eneno opa teko lupe lupe molemele kinie kanu talapemo pora nilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","⸤Molo⸥ ulke teluna pelemele yamboma konopu teluna pupili naa molko ene eneno opa telemele kinie kanu yambo talapemo sungu siku yu mele mele molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aku sipela, Setenene* yunge kuru te makorolkanje aku telkamonga yunge talapemo kinie opa mele telka. Pe yunge talapemo kapola naa molemelka. Pora nilke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ye enge nili tene yunge ulkemo nokopa konjilimo kinie ye tene we manda sukundu omba melema wa lipe memba pulimoye? Akumu manda molo. Ou wa noli yemone ye enge nilimunge kimbu kime ka topalie yunge ulkena manda omba melema wa limo kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“⸤Akumunge⸥ nane enendo paa sike nimbu sikiru: Yambomane ulu pulu kerime teko ⸤Pulu Yemo⸥ ungu taka tonjiku ningu kenjilimele uluma kinie, enenga ulu pulu keri wema kinie pali ⸤Pulu Yemone⸥ ‘Manie pupili.’ nimbe siye kolomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nakolo yambo tene Mini Kake Telimu ungu taka tonjipe, nimbe kenjipe, marake telemo yambomo yu Pulu Yemone aku sipe ulu pulu keri telemoma ‘Manie naa pupili.’ nimbe paa siye naa kolomba. ‘Alieli pepa mindi pupili.’* nimbé.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Enene “Yu kuru te yunge konopuna molemo.” niringimunge ⸤aku siku Mini Kake Telimu ningu kenjiringimunge⸥ Yesusini enendo aku sipe nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kanu kinie yambo aisili manie ⸤molko⸥ Yesusini ⸤mane sirimu unguma pilku⸥ molangi yunge anumu kinie angenupili kinie yu kinie ungu ningindu ongo pena angilku “Yu kinie ungu niemili opili.” ningu ungu te ningu munduringi kinie yambomane yundu ningindu: “Aminie kinie angenali kinie nu kinie ungu ningindu ongo pena angilimele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesusini enendo pundu topa nimbendo: “Nanga anumu naeye? Nanga angenupili nameleye?” nimbelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","yunge ungumu manie molko pilku moloringi yamboma nemo nemo nimbe kanopalie nimbendo: “I yamboma nanga anumu kinie nanga angenupili kinie molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pulu Yemone “Teangi” nilimo mele pilku liku telemele yamboma nanga anumu kinie nanga angenupili kinie nanga kemulupili kinie molemelemonga aku sipu nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Walse Yesusi altopa nomu ⸤Gallilli⸥ kélona pupe yamboma mane sipe molorumu kinie yambo paa aisili yu molorumuna ongo maku toko moloringimunge nona andoli sipi te lerimumunge suku pupe manie molorumu, yamboma nomu kélona angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yuni enendo ungu aisili nimbe simbendo ungu iku pokore torumu. ‘Ene mane siembo.’ nimbelie ungu iku te i sipe topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pilieme. Ye tene rasi witi umbu poniena andopa tanda sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tanda silipe andorumu kinie umbu mare aulkena manie purumu, kanuma keramane ongo liku noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Umbu mare kou perimuna manie pupelie ma wallo kolte mindi lerimuna nondopa mulie topa wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nakolo pulkeno naa mundurumuna ena terimu kinie kanuma kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Umbu mare kombulu siri ka mele molorumuna manie purumu, siri ka melemo wendo omba witi umbuma topa norumuna omba peanga naa lepa mongo te naa torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Umbu mare ma peangana manie purumuma wendo wendo omba akopalie mongo peangama torumu. Mare mongo tokapu telu mele topa, mare mongo tokapu talo mele topa, mare tokapu kise mele torumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aku nimbelie “Yambo komu peo lemomane i ungumu piliei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pe we yamboma pali puringi kinie yu lombili andoli ye engaki rurepo kinie yambo mare pea yu kinie moloringime kinie, enene yu walsikulie ningindu: “Nu yambomando ungu te ninindu nambemuna ungu iku tolenoye?”* niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Yuni enendo pundu topa nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma kinie melema kinie nokolemomonga ulu pulu* ou yuyu pilirimu kanu ulu puluma ‘Kinié ene ⸤na lombili olemele yamboma⸥ piliengi!’ nimbelie ene nimbe sikimu. Nakolo ulsu molemele yamboma ‘Unguma nimbu siembo.’ nimbulie ungu ikuma mindi topo silio. ⸤Pulu Yemone Aisayanga kerena nimbendo:⸥ ‘Ene mongone kanokolie naa kanoko, komuni pilkulie naa pilimele. Konopuni pilkulie alowa telemelka kinie, ⸤Pulu Yemone⸥ enenga ulu pulu kerime ‘manie pupili.’ nimbe siye kolka.’** nirimu akumunge we yambomando ungu ikuma mindi tolio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aku nimbelie Yesusini enendo kelepa nimbendo: “Ungu iku topo nindu* akumunge ungu pulumu naa pilimeleye? Akumu naa pilkulie we ungu ikumanga pali ungu puluma nambe teko pilingíye? ⸤Ungu ikumunge pulumu i sipe:⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Langi umbu tanda sirimu yemone tanda sirimu umbuma ⸤Pulu Yemonga⸥ ungumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Umbu mare tanda sirimu aulkena manie purumuma yambo mare i siku mele molemele. Enene ungumu pilimele kinie pe ⸤kurumanga nomi⸥ Setenene* sumbi sipe omba ungu tanda sili konopuna pupe pelemoma wendo limo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aku sipela, umbu mare tanda sirimu kou perimuna manie purumuma yambo mare i siku mele molemele. Enene ungumu pilkulie walsikale sumbi siku konopu siku pilku limele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nakolo ene pulkeno naa mundukulie ungumu laye kolte mindi pilku molemele. Pe ene konopuna umbuni telemo kinie molo ene ⸤Pulu Yemonga⸥ ungumu pilku liku molemele mele yambo lupemane kanoko keri kanokolie ungu taka tonjiku teko kenjiku mindili silimele kinie enenga pilimele unguma siye kolemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Umbu mare tanda sirimu siri ka mele molorumuna manie purumuma yambo mare kepe i siku mele molemele. Enene ungumu pilimele ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nakolo konopuna umbuni telemo umbunime kinie, mele aisili nosikulie ‘Aku melemane olio lipe taponjilimo taponjimbe.’ ningu pilku molemele uluma kinie,* mele naa nosilimelema waka kolko ‘liemili.’ konopu lemele ulu mare kinie, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinie ungumuni uluri naa tepa langi mongo naa tolemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Umbu mare tanda sirimu ma peangana manie purumuma yambo mare i siku mele molemele. Enene ungumu pilkulie ungu pulumu pilku konjiku ungumu kamu pilku limele. Pe ene langi mongo mele tolemele. Kanu yambo marenga langi mongo tokapu telu mele topa, yambo marenga mongo tokapu talo mele topa, marenga mongo tokapu kise mele topa, aku sipe tolemo.* ⸤Ungu ikumunge ungu pulumu aku sipe.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","⸤Aku nimbelie ungu iku te pea topa nimbendo:⸥ “Yambomane tepe llame kandokolie mingine suku panjilimeleye? Molo polo maniekondo nosilimeleye? Polo tenga ola nosilimele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aku sipe mele, kinié lopi telemo melema pe walse mona lemba yamboma kanonge; kinié aki topa lemo melema pe walse pa temba kinie yambomane kanu melema kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yambo komu peo lemomane ⸤ungu nikirumu⸥ piliei.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Enene ungu pilimele akumu mimi siku piliengi! Enene melema yamboma silimele mele ⸤Pulu Yemone⸥ ene aku sipe mele kalomba. Mare olandopa simbela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Melema nosilimo yambomo nane mare pea simbu, yu paa aisili nosimbe. Nakolo melema naa nosilimo yambomo yu nosilimoma kepe wendo limbu.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesusini ungu te pea nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu* i sipe mele: “Ye tene langi umbu mana tanda silimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aku yemo ipulueli uru pepa, tangoli ola molopa ⸤andopa kongono tepa⸥, telemo kinie langi umbu tanda silimoma mulie topa omba ai lemo nakolo aku sipe telemomonga pulumu yemone nimbe naa kanopa naa pilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Langi umbu tolemoma mamone yu yuyu ‘wendo opili.’ nilimo. Ou kumbi lepa mulie tolemo. Pe gomo angilimo. Pe langi mongo tolemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pe langi nou lemo kinie ‘Langi inie topo sukundu sukundu limbu walemo wendo okomo.’ nimbelie* langi umbu tolemo yemone langi inie tolemo. ⸤Pulu Yemo ye nomi kingi molopa yamboma nokolemo aku sipe molemo.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pe Yesusini enendo kelepa nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokolemo akumu nambolka melte mele niemboye? ‘Yu kingimu molopa yamboma nokolemo mele piliengi nimbu siembo.’ nimbulie nambolka ungu ikumu topo niemboye?” ⸤nimbelie nirimumuni, altopa ungu iku te pea topalie nimbendo:⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Pulu Yemo ye nomi kingi molopa yamboma nokolemo akumu unju masetete umbu mele: Yamboma langi umbu poniena mundulimelemanga pali unju masetete umbumu yu paa kangamo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nakolo poniena mundulimele kinie wendo omba ai lemo kinie poniena molemo melemanga pali yu paa ailimu. Kamu ai lepa unju mele angilimo kinie kerama kanu unju kolamanga ongo pelemele. Pulu Yemo ye nomi kingi molomba mele aku sipe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusini unguma yamboma nimbe simbendo ungu iku aisili aku sipema topa sirimu. Ene manda pilingí mele topa sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ene ungu te nimbe simbendo ungu iku te mindi torumu. ⸤Ungu te sumbi sipe naa nimbe sirimu.⸥ Nakolo yu kinie yu lombili andolime kinie* ene eneno moloringi kinie yuni yunge ungumanga puluma pali ene sumbi sipe nimbe para sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kanu walemonga kolea kala torumu kinie Yesusini yu lombili andoli yemando nimbendo: “Nomu nekendo pamolo.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","nona andoli sipi tenga Yesusi ou suku molopalie unguma nirimu* akuna suku yu we molopili nomu kélona maku toko moloringi yamboma munduku kelko yu mengo puringi. Sipine puringi kinie sipi mare pea puringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kanu kinie, nomuna pungí puringi kinie poporome paa aili te nomuna torumu. Aku terimuna nomumu apisipe ola ombalie no sipine sukundu sukundu omba peke lepalie sipimu memba nona manie pumbe terimu ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","nakolo Yesusi sipimunge bulkundu penge kanda wale tenga we uru perimu. Yu lombili andoli yemane yu toko makinjikulie ningindu: “Ungu Mane Silimu, olio no wangopo kolomolomonga nu mini wale naa pukumuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yu makilipelie poporomemo iri topa nomumundu nimbendo: “Taka lelko moloi!” nirimu kinie poporomemo topa kelepa nomumu lope naa tepa paa we lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kanu kinie yuni lombili andolimendo nimbendo: “‘Pulu Yemone olio nokomba.’ ningu konopu tondolo naa pekemo yema, ene nambemuna mini wale mundukumiliye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","⸤Yuni terimu mele kanokolie⸥ yemane mini wale munduku pipili aili teko kolkolie anju yando eneno walsikulie ningindu: “Apa! I yemo naenje? Poporomemone kepe nomumuni kepe yunge ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kanu kinie, ⸤Yesusi kinie yu lombili andoli yema kinie⸥ ene ⸤nona andoli sipine⸥ nomu nekendo puku kolea Gerasa puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Akuna oringi kinie Yesusi sipine wendo orumu kinie konopuna kuru molorumu ye te, yambo ono koleana pelipe andorumumu tamburembu wendo omba yu molorumuna orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Kanu yemo, yambo ono koleana yunge perimu koleamo lerimu. ⸤Kurumu yunge konopuna molorumumunge yu paa enge nirimuna⸥ yambomane yu taki taki ka wemane kinie, ka senene kinie kepe yu kimbu kime ka toringi ka senema yu sungu sipe, kimbutolo anakapa panjiringimu elke malke tonjirimu. Ye teluri kepe enge te perimuna ‘Yu taka lepa molopili.’ nimbe manda ambolopa nokomba ye te paa naa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Alieli, ipulueli kepe tangoli kepe, yambo ono koleana kinie ma pangimenga kinie kalle nilipe andopa, yunge kangimu yu yuyu kou ⸤nee angilili⸥ marene kopisilipe andopa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Kanu yemone sulu tepa molopa Yesusi kanopalie yu molorumuna lkisipe orumu. ⸤Orumu kinie⸥ Yesusini nimbendo: “Kurumu, i yemonga konopuna ongo wendo pui!” nirimu mele pilipelie yemone yunge kumbikerena koporongo langopa tamalu pepa yundu tondolo ru nimbelie nimbendo: “Yesusi, Pulu Ye Paa Olandopa Ailimunge Malo,* na kinie ulu nambolka uluri tenindu onuye? ‘Pulu Yemonga imbimu lelko mi lelko “Paa sike nikiru. Na mindili paa naa lipu simbu.” ni!’ nimbu mawa tekero.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aku nirimu kinie Yesusini yemondo walsipelie nimbendo: “Nunge imbi naeye?” nirimu kinie yuni nimbendo: “⸤Olio paa aisili kene⸥ nanga imbi Paa Aisili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aku nimbelie wale aisili Yesusi mawa tepalie nimbendo: “Olio ‘ongo wendo pangi.’ ningu toko makorokolie “I koleamo munduku kelko kolea luperenga pai.” ni naa ni.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akuna ma pangi tenga umbu kongi aisili ímu nongo moloringi kanokolie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kurumane Yesusi mawa tekolie ningindu: “Olio ⸤toko makorokolie⸥ “Ne kongime molemelena puku, enenga konopuna molopangi.” ni.” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yuni “Kapola, akuna pangi.” nirimu kinie kuruma kanu yemonga konopuna wendo ongolie kongi akuna moloringimenga konopuna puku moloringi kinie kanu kongime kekelepa toko lkisiku puku kopona pukue toko nomuna suku puku no wangoringi. Kongi kanuma ⸤paa aisili,⸥ tausini talo mele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","⸤Ulu akuma wendo orumuna kanokolie⸥ kongi tapu teko moloringi yema talopa lelko pukulie niringimuni, kolea ailine moloringi yamboma kinie, kolea kangamanga moloringi yamboma kinie, ulu akuma wendo orumu mele temane toko siliku puringi. Kanu temanemo piliringi yamboma ‘Uluma wendo orumu mele kanamili.’ ningu wendo puku ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusi molorumuna ongolie ou kuru paa aisili konopuna molko ongo wendo puringi yemo mulu wambale pakopa, umbu konopu pepili molorumu kanokolie ene pipili koloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yesusini terimu mele mongone kanoringi yambomane pe oringi yamboma ningu siringi. Kuru aisili konopuna moloringi yemo kinie, kongime kinie uluma wendo orumu mele temanemo toko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kanu kinie yamboma ⸤paa mini wale mundukulie⸥ Yesusi mawa tekolie ningindu: “Olionga koleana naa mololi kelko pui.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aku siku niringi pilipelie Yesusi pumbendo nona andoli sipine suku pumbe purumu kinie kuru aisili konopuna ou molko wendo oringi yemone yundu nimbendo: “Pea pambili.” nimbe mawa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nakolo Yesusini “Molo.” nimbe yundu nimbendo: “Nu ulkendo puku Ailimuni nu kondo kolopa ‘Molko kenjinu mele pora nipili.’ nimbe, lakopa tepa konjimu mele nunge pulu lemo yamboma ningu sipui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yesusini aku nirimuna pilipelie ye kanumu pupe yunge kolea, ‘Kolea Aili Rureponga Talo’ niringi koleana andopa Yesusini lakopa tepa konjirimu mele nimbe sirimu. Nimbe sirimu kinie pilkulie yamboma pali paa suru ningu mini wale munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesusi ⸤yu lombili andolime kinie⸥ nona andoli sipine suku pupe nomu yakondo altopa ombalie nomu kélona wendo orumu kinie yambo aisili yu molorumuna ongo liku maku toko kakapu teko moloringi. Yu nomu kélo akuna molopili ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke te nokorumu ye te, yunge imbi Jairasi, Yesusi molorumuna orumu. Kanu kinie yu Yesusi kanopalie Yesusi yunge kimbuna nondopa omba manie molopa tamalu pepa ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yundu tondolo mundupe mawa tepalie nimbendo: “Nanga ambola nanamo nondopa kolomba tekemo kene ‘Yu konde pupe kapola molopili.’ ningu ongo yu kimuni amboloi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aku nirimuna pilipelie Yesusi yu pea puringili. Pungilí puringili kinie yambo aisili liku maku toko lombili puku yu kakapu teko ekelepa teko pea puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kanu kinie ambo te molorumu kanumunge pena perimu walema pora naa nirimu. Yu pena mindi pepili ponie engaki rurepo omba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yu doketa aisilimenga yunge kurumu ‘Pora nipili.’ nimbe andorumu nakolo mindili mindi siringi. Yunge kou mone pali ene sirimu nakolo yunge kuru pora naa nirimu. We topa olandopa mindi purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kanu ambomo Yesusi ulu tondoloma terimu mele temanema pilipelie yamboma maku toko angiliringine sukundu omba Yesusinge bulkundu omba yunge wale pakolimu ambolorumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‘Yunge wale pakolimu mindi ambolondu liemo na konde pumbu.’ nimbe pilipelie aku terimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","⸤Ambolorumu kinie⸥ walsikale yunge kuru torumu kanumu pora nirimu, yunge kangimu ou umbuni perimu mele wayongo nirimu pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nakolo ⸤yu Yesusinge wale pakolimu ambolorumu kinie⸥ Yesusi yuni yamboma lipe taponjili tondolo mare yunge kangine omba ulsu purumu sumbi sipe pilipelie topele topa kanopa yambomando walsipe pilipelie, “Nanga wale pakolimu naene ambolomuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nakolo ⸤yuni walsirimu mele pilkulie⸥ yu lombili andoli yemane pundu toko ningindu: “Yambo aisili nu angilinona nondoko nondoko ongo kakapu teko ekelepa teko angilkimili kanumu. Pe nambemuna “Naene na ambolomuye?” nikinuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nakolo Yesusi mongo male male tepa koropalie “Akumu naene temuye?” nimbe we angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kanu kinie tondolo tene yunge kangine kurumu pora nirimu pilipelie ambomo paa pipili kolopa kangime puru puru nipili Yesusi molorumuna omba manie molopa tamalu pepalie yu ulu terimuma pali nimbe para sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesusini yundu nimbendo: “Ambolamo, ‘Nu manda tepa konde limbe.’ ningu tondolo munduku pilinu kanu ulumuni nu konde pukunu. Nu kuru pora nimbe konopu pe nipili molopani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesusini ambomondo aku sipe nimbe molorumu kinie, ye mare, yamboma maku toko Pulu Yemonga piliringi ulke nokoli ye Jairasinge ulkena molkolie ongo ⸤Jairasindu⸥ ningindu: “Nunge ambolamo kolopa pora simu. Nambemuna Ungu Mane Silimu ‘Mindili nopili.’ ningu we mengo oniye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nakolo Yesusini ene niringi ungumu pilipe naa lipelie ulke nokoli yemondo nimbendo: “Mini wale naa munduyo. ⸤Nunge ambolamo nane ‘Manda lipe taponjimbe.’ ningu⸥ tondolo munduku pilí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kanu kinie yuni maku toringi yambomando “Naa ongo anju pai.” nimbelie Pita keme Jemisi keme angenu Jono keme akuma mindi lipelie “Pea pamolo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ulke nokoli yemonga ulkena oringi kinie yambo aisili molko kondo kolko kola aili teko teko moloringi kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yu ulke suku pupelie yambo moloringimendo nimbendo: “Ene nambemuna kola teko kalle ningu molemeleye? Ambolamo kolou naa kolomu. We uru mindi pelemo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nakolo aku nirimu kinie enene yu ungu taka tonjiku tae tenjiringi.* Ene pali makoropa pena pena tepalie, ambolamonga anumu lapatolo kinie, kanu lombili andoli ye pokore kinie lipe memba ambola onomo lerimu suluminiana purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pupelie ambolamonga kimu ambolopa Juda yambomanga ungu lepa yundu “Tallita kumi!” nirimu. (Ungu akumunge pulumu i sipe: “ “Ambolamo, nu ola moloi.” nikiru.” nirimu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aku nirimu kinie ambolamo tamburembu ola molopalie andorumu. (Ambola kanumu ponie engaki rurepo mele omba pupili yu molopalie kolorumu kinie Yesusini omba tepa konde lirimu.) ⸤Akumu kanokolie⸥ yu kinie moloringi yamboma suru ningu mini wale aili teko munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kanu kinie Yesusi yuni enendo tondolo mundupe nimbendo: “Ulu i tekeromo yambo telurindu kepe anju puku paa naa ningu siei!” nimbelie ⸤anumundu⸥ nimbendo: “Ambolamo langi mare liku si.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesusi molorumu koleamo mundupe kelepa yunge pulu kolea ⸤Nasarete⸥ purumu, yu lombili andoli yema pea puringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","⸤Juda yambomanga koro moloringi⸥ wale Sambatemo* wendo orumu kinie ene maku toko Pulu Yemonga ungumu piliringi ulkena suku pupelie yamboma mane sipe molorumu. Yunge ungumu pilku moloringi yambo aisilini suru ningu mini wale mundukulie ningindu: “Ne yemo aku unguma tena lirimunje? Yunge pilipe konginjilimu kinie yunge ulu tondolo telemomanga tondolomo kinie yu tena lirimuye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yu ulkema takonjirimu yemo* moloye? Yu Maria malo moloye? Jemisi keme Josepo keme, Judasi keme Saimono keme, enenga angenu moloye? Yunge kemulupili olio kinie pea naa molemoloye? ⸤Yu paa sike aku yemo molemomo⸥.” niringi. ‘Yu paa we yemo nambe tepa i tondoloma yu kinie pelemoye?’ ningu pilkulie ene yu kanoko keri kanoko yu kinie paa konopu keri panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kanu kinie ⸤ene yu kinie mumindili koloringimunge ulu pulumu pilipelie⸥ Yesusini enendo nimbendo: “Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye te* koleamanga pali imbi ola molemo, yambomane pali yunge unguma pilku limele. Nakolo yunge koleana yu kinie pea tapu toko molemele yamboma kinie, yunge pulu lemo yamboma kinie, ene mindi yuni nilimo ungumu pilkulie ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo unguma naa pilku, liku su silimele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","⸤Yunge ungumu liku su siringine⸥ kolea akuna yuni ulu tondoloma manda naa terimu. Kuru torumu yambo telu telu nimbe mindi kimuni ambolopalie tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yu ⸤ungu nimbe uluma tepa molorumu mele⸥ ‘Sike.’ ningu tondolo munduku naa piliringimunge yu paa konopu aisili lerimu. Kanu kinie Yesusi kolea kanga lupe lupemanga andopalie ⸤Pulu Yemonga ungumu⸥ mane silipe andorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesusini yu lombili andoli engaki rurepondo “Wai.” nimbelie enene yambomanga konopuna kuru molemoma “Ongo wendo pai.” ningu toko makoronge tondolomo sipelie ene talo talo nimbe “Koleamanga andopai.” nimbe lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","⸤Lipe mundupelie⸥ ene tenge mele ungu mane sipelie nimbendo: “Pungindu ene melema naa meangi. Apulu mingime mindi liku ambolko pangi. Kimbu su monjingí manda nakolo wale pakoli talo kepe langi kepe mele wale kepe naa mengo, kou mone kakona kepe naa panjiku we pangi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Pe kolea tenga suku pukulie akuna molongendo ulke teluringe suku pukulie akuna mindi peko molkolie pe aku koleamo munduku kelko pangi. ⸤Ulke pinie pinie naa andoko ulke teluringe mindi langi nongo peangi.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kolea marenga suku pungí kinie kolea pulu yambomane “Pea peamili wai.” ni naa ningu enene ungu ningíme pilku naa língi liemo kanu koleana yambo kerime munduku kelko pungindu kanu koleana yambomane ene liku su singímunge ‘Ene kamu molko kenjengi! Pulu Yemone ene lipe naa taponjimbe mele piliengi!’ ningu enenga kimbuna kanu koleamanga ma angilimbema kulu toko pangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","⸤Yu lombili andolime yuni aku sipe lipe mundurumuna pilku⸥ pukulie yambomando ningindu: “Ulu pulu keri telemelema kanoko keri kanoko konopu alowa teai.” ningu ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","yambomanga konopuna kuru aisili moloringime ⸤‘Ongo wendo pai.’ ningu⸥ toko makoroko, kuru torumu yambo aisili ‘Konde pangi.’ ningu enenga kangine ollipi kopongo ondo lelko kanjinjiku teko konde liku, teliku andoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kanu kinie Yesusi yunge imbimu yamboma pilku leringimunge ye nomi kingi Erote Yesusini terimu mele temane toringi pilirimula. ⸤Yesusini tepa nirimu mele pilkulie⸥ yambo marene ningindu: “I uluma telemo yemo No Linjili Jono lepamo! Yu kolopalie lomboropa wendo omumunge ulu tondoloma temba tondolomo yu kinie pelemo.” ningu moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yambo marene ningindu: “Yu ⸤ou konde molopili Pulu Yemone olando lirimu* ye⸥ Illainja kelepa omba molemo.”** niringi. Yambo marene ningindu: “Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi ye koro ou moloringi yema mele yu aku sipe Pulu Yemonga ungu umbu tonjilimoma pilipe yando nimbe silimo yemo molemo.”** niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nakolo ye nomi kingi Erotene ⸤Yesusi yuni terimu mele temane toringi⸥ pilipelie nimbendo: “I uluma telemo yemo ⸤No Linjili⸥ Jono, ‘Yunge pengemo wendo pupili.’ nimbu nomi karu lerindu kanu yemo. Yu kolopalie lomboropa wendo omu lepamo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","⸤Kingi Erotene aku sipe nirimu ungumunge pulumu i sipe:⸥ Ou walse Erotene yunge angenu Pillipunge ambo menu Erodiasi mangopa lirimu. ⸤No Linjili⸥ Jonone Erote aku sipe terimu kanopalie yundu alieli nimbendo: “Nuni ⸤Pulu Yemonga⸥ ungu mane te pulue toko* angenanga ambomo mangoko lirinu. Akumu teko kenjirinu.” nirimu kinie Erotene yu lipe ka sipe ka ulkena panjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Jonone aku nirimumunge ambo Erodiasini yu mumindili kolopa “Yu topo konjembo.” nimbe molorumu nakolo Erotene ‘Jono yu konopu sumbi sipe pepa Pulu Yemonga ye kake telimu molemo.’ nimbe kanopa yu pipili kolopalie nokopa konjirimumunge ambo Erodiasini Jono kinie ulu te manda naa terimu. Jonone ungu nirimuma pilipelie ye nomi kingi Erote yu paa konopu aisili lipe mundupe mini wale mundurumu nakolo aku unguma yu paa konopu sipe pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe walse, ⸤ambo Erodiasi⸥ konopuni pilipe molorumu ulumu manda temba walemo wendo orumu. Wendo orumu mele i sipe: Kingi Erote meringi walemo wendo orumu kinie yunge kendemande ailime kinie, yunge ami yemanga ye nomime kinie, kolea Gallilli disiriki yambomanga ye nomi ailime kinie, enendo “Langi pea namili wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","⸤Ene ongo yu kinie pea langi nongo molangi⸥ Erodiasi lemenu ulkena sukundu omba ene moloringine denisi terimu. Erote kinie, yu kinie pea langi nongo moloringi yema kinie enene ambo wenepomo aku terimu kanoko paa peanga kanoringi. Kingimuni paa kanopa peanga kanopalie ambo wenepomondo nimbendo: “Nuni konopu monjikinu melte na mawa téa. Mawa teni melemo nu simbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pulu Yemonga imbi lepa mi lepalie yundu kelepa nimbendo: “Paa sike nikiru. Nuni na mawa teni mele te paa sike simbu. Nane ye nomi kingi molopo nokolio koleamo ekendo kepe “Si.” ninu liemo paa sike simbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Erotene yundu nirimu mele pilipelie ambo wenepomo pena pupe, anumu molorumuna pupe walsipelie nimbendo: “Mele nambolka melemo ‘Si.’ niemboye?” nirimu kinie anumuni nimbendo: “ “No Linjili Jononga ⸤nomimu karu lelko yunge⸥ pengemo si.” ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anumuni aku nirimu pilipelie yu kingimu molorumuna tamburembu lkisipe omba mawa tepalie nimbendo: “Paa isili ou No Linjili Jono ⸤nomi karu lelko⸥* yunge pengemo pellete tenga nosiku yando si.” nirimu. ⸤Jonone ou alieli “Erote kinie Erodiasitolone teko kenjiringili.” nirimumunge mumindili kolopalie Erodiasini ‘Yu kolopili. Sike kolomunje na kanambo.’ nimbe “Pengemo ongo si.” nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yuni aku sipe mele mawa terimu kinie pilipelie Erote paa konopu umbuni terimu nakolo yuni “Paa sike simbu.” nimbe, nimbe panjipe Pulu Yemonga imbi lepa mi lerimu mele kepe, yu konopu alowa temba kinie yu kinie pea langi nongo moloringi yema yu kanoko keri kanonge mele kepe, aku ulutolo pilipelie, “Yuni mawa tepa “Si.” nikimu mele “Molo.” manda naa nimbú.” nimbe pilipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","yu nokoringi ami yemanga te lipe mundupelie “⸤No Linjili⸥ Jono ⸤nomi karu lelko⸥ yunge pengemo yando mengo oi.” nirimu kinie kanu ami yemone ka ulkena pupe Jononga nomimu karu lepalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","yunge pengemo pellete tenga nosipe yando memba omba ambo wenepomo sirimu kinie yuni anumu sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aku teringi pilkulie Jono lombili andoringi yema ongo yunge onomo liku mengo puku ono teringi. ⸤Kingi Erotene No Linjili Jono ou aku sipe topa konjirimu kolorumumunge pe Yesusini ulu tondoloma terimu mele pilipelie “Jono nomi karu lerindu yemo lomboropa ola molemo lemo.” nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","* Yesusini “Nanga kongonomo tenjipai.” nimbe lipe mundurumu yema** yu molorumuna kelko yando ongolie niringimuni, ulu teringime kinie yamboma ungu mane siringime kinie yu temane toko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nakolo yambo aisili ongo puku ongo puku ⸤teko ungu ningu panjiku⸥ teringimunge Yesusi kinie ⸤yuni lipe mundurumu ye yando oringime⸥ kinie langi nonge ena wallo kolte kepe naa lerimumunge* kanopalie Yesusini yemando nimbendo: “Ene eneno yambo naa mololi kolea ku tenga laye kolte mulu piliengi kene na kinie pea pamili wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanu kinie ene eneno mindi nomuna andoli sipi tenga suku puku yambo naa mololi kolea ku leli tenga puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nakolo pungí puringi kinie kanokolie yambo aisili Yesusi kinie yu lombili andolime kinie kanoko imbi siringimunge koleamanga yamboma pali kimbu kongono teko lkisiku nomu kélona makaye teko puku ene nomuna wendo pungí koleana kumbi lelko puku nokoko angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesusi nomu kélona ulsu omba kanopa yambo paa aisili akuna ongo maku toko moloringi kanopalie ene kongi sipisipi tapu teli ye te naa mololi sipisipime mele* ku peko moloringine nimbe kanopalie ene kondo kolopa ungu aisili mane simbe terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kanu kinie ⸤mane sipe molopili⸥ ena pumbe terimumunge yu lombili andolime yu molorumuna ongo yundu ningindu: “I koleana yambo te naa pelemo, ena kamu pukumu kene ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ya maku toko molemele yamboma “Puku kolea marenga langi topo toko lipangi.” ni.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nakolo yuni ⸤yu lombili andolimendo⸥ pundu topa nimbendo: “Enene eneno yamboma langi mare liku siei.” nirimu. Enene yu walsikulie ningindu: “‘Kakopoi ye tene oli engaki kongono tepalie mele kalolimu limo kou monemane* olio langime topo topo lipulie yamboma siemili.’ ningu nikinuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","⸤Aku siku niringi pilipelie⸥ yuni ene walsipe pilipelie nimbendo: “Pillawa kaloli nambepa nosikimiliye? Puku kanopai.” nirimu. Puku koroko kanoko lenjiku yu molorumuna kelko ongolie ningindu: “Ya langi aisili molo. Pillawa kaloli kanga te pakara kinie oma kaloli talo kinie ⸤aku langi pokore mindi lemo⸥.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kanu kinie Yesusini nimbendo: “Yambomando “Era kondili niline maku toko manie molangi.” niei.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","yamboma tokapu talo molo tokapu kise ningu maku toko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kanu kinie Yesusini pillawa kaloli te pakara kinie oma talo kinie kanuma lipelie mulu koleana olando sipe kanopa ⸤Pulu Yemo kinie⸥ “Ange.” nimbe pillawa kalolime ambolopa pike lepa lombili andolime moke tepa sipelie “Anju yamboma siei.” nirimu, ⸤enene⸥ yamboma ⸤moke teko siringi⸥. Oma talo kepe lipe moke tepa yamboma pali sirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ene pali kanu langime noringi kinie olo terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kanu kinie lombili andolimene pillawa kaloli kinie oma kinie kanumanga goli lerimuma liku maku toko wale basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Langi noringi yema manjipe pape tausini mele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","⸤Yamboma langi sirimu noringi⸥ kinie Yesusini yu lombili andoli yemando sumbi sipe nimbendo: “Maku toko molemele yamboma nane “Pangi.” niembo. Ene nona andoli sipine ola puku no nekendo, Besaida taono lemona, kumbi lelko pai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kanu kinie yamboma mundupe kelepalie yu yuyu Pulu Yemo kinie ungu nimbendo ma pangine ola purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kanu kinie ena pupe kolea kala torumu kinie sipimu nomu ai suku singine purumu, Yesusi yuyu ma ⸤pangi⸥ ne molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sipi kumbikundu mendo sipe poporomene torumumunge ⸤yu lombili andoli yema sipine suku molkolie⸥ sipimu nomu kélona mengo pungindu pereringi kanopalie ipulueli kolea muni naa lepili ene puringine yu nona ola kimbu kongono tepa ombá ombalie ene sipine puku molangi yuni ene topa akilinjipe yu kumbi lepa pumbe orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nakolo yu lombili andolimene pali yu nona ola kimbu kongono tepa orumu kanokolie niringimuni, paa pipili aili teko kolkolie “Kuru te okomaa!” ningu mini wale munduringi kinie Yesusini tamburembu enendo nimbendo: “Ene konopu tondolo pupili molayo. Na mindi okoro. Pipili naa kolai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Kanu kinie yu sipine suku purumu kinie poporome topa kelerimu. Aku terimuna kanokolie paa mini wale munduringi. Yuni ⸤ou tangoli⸥ pillawa kalolime ⸤moke⸥ terimumunge pulumu naa pilku we konopu lou lelko moloringi. Yu kinie tondolo te perimuna pillawa kalolime kinie ulu tondolo te terimu mele mimi siku naa pilkulie ene konopu naa perimuna kanu tondolomone poporomemo topa kelerimu mele kepe naa pilkulie* poporomemo topa kelerimu kinie kanokolie ene paa mini wale munduringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","⸤Yesusi kinie yu lombili andolime kinie⸥ nomu ⸤Gallilli⸥ nekendo pukulie nomu kélona kolea Geneserete lerimuna wendo ongolie sipimu ka teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sipine manie oringi kinie akuna moloringi yambomane Yesusi tamburembu kanoko imbi sikulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","akundu lerimu koleamanga pali lkisiku puku yu andorumu koleama pilkulie enenga kuru torumu yamboma liku taropola teko yu andorumuna mengo oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yu andorumu koleamanga pali, kolea kangamanga kinie, kolea ailimenga kinie, kolea wemanga kinie, aku koleamanga yamboma maku toko moloringi koleamanga kuru torumu yamboma mengo ongo nosikulie, “‘Nunge wale pakoli pundumu kepe ambolangi.’ ni.” ningu mawa teringi. Kanu kinie kuru torumu yambomane yunge wale pakolimu amboloringi yamboma pali kamu konde puringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","⸤Walse⸥ Parisi ye mare kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi ye mare kinie* ene Jerusalleme munduku kelko Yesusi molorumuna ongo maku toko moloringimene ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","yu lombili andolimene* ki kalaro molopili ou kulumiye naa toko langi we ambolko noringi kinie kanokolie kanoko keri kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(⸤Sike kalaro naa molorumu nakolo⸥ Parisi yema kinie we Juda yamboma kinie enenga anda kolepalimene “Teai.” niringi mele pilku liku tengendo ou ki pali nona munduku kulumiye toko konjikulie langi pe noringi. We naa noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Makete koleana puku ulkendo ongolie ki ou kulumiye naa tokolie ⸤maketena topo toko liringi⸥ langime naa noringi. Anda kolepalimenga teringi ulu pulu lupe lupe aisili pilku liku teko moloringila. Kápoma kinie, mingime kinie, langi noringi poloma kinie, aku sipe melema taki taki we kulumiye toringi.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","⸤Juda yambomane aku siku teringi⸥ ne Parisi yema kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, enene ⸤Yesusi lombili andolimene aku siku ki kulumiye naa toko langi we noringi kanokolie⸥ Yesusindu walsiku pilkulie ningindu: “Anda kolepalimene “Teai.” niringi mele nunge lombili andolimene nambemuna naa pilku liku telemeleye? Enenga kime kalaro molopili langi nolemele kanumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesusini enendo pundu topa nimbendo: “Ene ⸤ungu manema pilku mane silimele yema kinie Parisi yema kinie⸥ ene topele mapele toli yema molemele!* Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane enendo nirimu mele papu nirimu. ⸤Enene kinié telemele mele yuni ou nimbe Pulu Yemonga⸥ bokuna torumu molemo mele i sipe: ⸤Pulu Yemone nimbendo:⸥ “Kanu yamboma enenga keremane na kapi ningu ‘Ye aili olandopamo. Nu lipu ai silimolo.’ ningu na imbi ambolko ola linjilimele nakolo enenga konopuma kinie nanga konopumu kinie teluna naa pulimo. lupe lupe pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Enene ‘Nanga imbi ambolopo ola linjemili.’ ningu na we popo toko kapi nilimele. Mana yambomane mane silimele unguma mindi mane sikulie ‘I ungu manema Pulu Yemone “Teai.” nilimo ungu manema.’ ningu pilku liku telemele, akumunge na popo tonge kinie uluri naa temba.”* nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pulu Yemone “Teai.” nirimu ungu manema munduku kelkolie anda kolepalimene “Teai.” niringi mele mindi ambolko molemele.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","⸤Yesusini⸥ ungu mare pea enendo nimbendo: “Enenga anda kolepalimene “Teai.” niringi mele pilku liku tengendo Pulu Yemone “Teai.” nirimu ungu manema bulu silimele mele papu telemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Akumunge Mosisini nimbendo: “Aminieli lanielinge unguma pilku liku, liku ai siku teai.”* nimbe “Yambo tene yunge anumundu molo lapando ungu te nimbe kenjipe iri tomu liemo kanu yambomo toko konjengi.”** nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nakolo ene yemane ningindu: “Ye tene yunge anumu lapatolondo nimbendo: “Nane elte mele mare lipu taponjipu silkema koronga ‘Pulu Yemo simbu.’ nimbu panjirindu kanumunge elte manda naa lipu taponjipu simbu.” nimbelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yunge anumu lapatolo naa lipe taponjimbe kinie papu.” ningu mane silimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aku siku mane silimele ungumuni ‘Anda kolepalimene mane siringi ulu puluma olandopa.’ ningu ‘Pulu Yemone nirimu ungumu uluri molo. Manie pupili.’ nilimele. Enene ulu lupe lupe aisili aku siku teko molemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aku nimbelie Yesusini maku toko moloringi yambomando “Na moliona wai.” nimbelie enendo nimbendo: “Nane ⸤aku nikirumunge* ungu te⸥ nimbú tekero ungumu enene pali komu tenjiku ungumunge pulumu pilku konjeyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yambomanga kangine ulsukundu lepalie kerena pupe olona suku pulimo meltene ⸤Pulu Yemo manda popo tonge aulkemo pipi silimo⸥ kalaro te manda naa monjilimo. Yambomanga konopuna sukundu pepalie wendo olemo ulumane mindi yamboma kalaro monjilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Yambo komu peo lemba yamboma i ungumu mimi siku piliengi!” nirimu.)* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kanuna maku toko moloringi yamboma Yesusini mundupe kelepa ulkena suku purumu kinie yu lombili andolimene yu walsiku pilkulie ningindu: “Aku ungu ikumunge pulumu nambolkanje? Ningu para sieni.” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesusini enendo nimbendo: “Kinié kepe naa pilkimiliye? Yambo tenga kangine ulsu lepalie sukundu pulimo melte yunge konopuna naa pupe, olona suku pupe ulsu omba le muruna kamu pulimomonga yu kalaro manda naa monjilimo mele naa pilkimiliye?” nirimu. (Yesusini aku sipe nirimumunge “Langimene pali yamboma kalaro te naa monjilimo.” nimbendo nirimu.)* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","⸤“Kerena sukundu pulimo melemane aku sipe uluri naa telemo.” nimbelie⸥ yuni kelepa nimbendo: “Yambo tenga konopuna sukundu pepalie wendo olemo kanu melemane yambo te ⸤Pulu Yemo popo tomba aulkemo pipi silimo⸥ kalaro te monjilimo. Ulu pulu kerime ou konopumuni pilkulie ⸤pe kamu telemelemonga⸥ “Konopuna pepalie wendo olemo melemane kalaro monjilimo. ⸤We naa telemele.⸥” ⸤nikiru.⸥ Kanu melema i sipe: konopumuni ulu kerime pilimele; wa ulu kerinele lupe lupema andoko telemele; wa nolemele; yamboma toko konjilimele; ambo ye pulime molo ye ambo lilime yambo lupema kinie ulu kerinele telemele; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yambomanga mele nosilimelema ‘Na liembo.’ nilimele; ulu pulu keri lupe lupema telemele; kolo tolemele; yambomane kanokolie pipili kolemele uluma pipili naa kolko sumbi siku telemele, yambo lupema molemele mele kepe enenga melema yama mengo ‘Yu malo.’ konopu lemele; ‘Yamboma pipili kolko molko kenjengi!’ ningu ungu bulkundu ninjilimele; ‘Na imbi ola molemo. Na pilipe konginjili olandopa pelemo. Yambo lupema tondolo te naa pelemo.’ ningu kara pulimele; kekelepa toli uluma telemele; ulu pulu akuma pilku telemele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aku ulu pulu kerime pali yambomanga konopuna sukundu pepa wendo olemomane yamboma ⸤Pulu Yemonga kumbikerena pungí aulkemo pipi silimo⸥ kalaro monjilimo. ⸤Ulsu lepa olona pulimo melemane uluri naa telemo⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kanu kinie Yesusi molorumu kolea ⸤Geneserete⸥* mundupe kelepa ⸤Juda yamboma moloringi kolea Gallilli disiriki ulsukundu⸥ kolea aili Taya kinie Saidonotolo lerimu koleana sukundu purumu. Akuna purumu kinie yu ‘Yamboma na naa kanangi.’ nimbe ulke tenga sukundu pupe molorumu nakolo yu omba molorumu mele yamboma piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yesusi yu omba molorumu akumu pilipelie ambo te yu molorumuna sumbi sipe omba yunge kumbikerena manie molopa tamalu perimu. Kanu ambomo yu ⸤Pulu Yemonga⸥ Juda yambomanga talapena ulsukundu ambo te, kolea Siria poropinji sukundu kolea Ponisia disiriki yunge pulu koleamo. Ambomonga lemenunge konopuna kuru te molopa ambolorumuna Yesusi molorumuna omba manie molopa tamalu pepa yundu mawa tepalie nimbendo: “Nanga ambolamo kuru te konopuna sukundu molemo kene yu ⸤kondo kolko⸥ kurumu toko makoroi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","⸤Ambomo yu ambo lupe, Juda ambo te molo, nimbe kanopalie⸥ Yesusini ambomondo ⸤ungu iku te topalie⸥ nimbendo: “Ambolangoma langi ou nangi olo tepili. Enenga langime lipu owama simulú kinie kapola naa temba.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ambomone yundu nimbendo: “Ailimu,* sike nikinu nakolo owamane kepe ambolangomanga langi pundu manie pulimoma liku nolemele kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kanu kinie Yesusini yundu nimbendo: “Ambomo, nu aku siku nikinumu papu nikinu. Aku siku nikinumunge kuru kanumu nunge ambolamonga konopuna sukundu molopa omba wendo pumu kene nu ⸤konopu wayongo siliku⸥ pui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","⸤Yesusini aku sipe nirimu pilipelie⸥ ambomo kelepa ulkendo pupe kanorumu kinie lemenu konopuna kuru te naa molopili uru peli polona ola we molorumu kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesusi kolea aili Taya mundupe kelepa kolea aili Saidono sukundu omba pupe, ‘Kolea Aili Rureponga Talo’ niringi koleana sukundu omba pupe, nomu Gallilli kélona ⸤sukundu⸥ orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akuna moloringi yambomane yu molorumuna ye komu sipe ungu sumbi sipe naa nirimu ye te mengo ongo “⸤Yu konde pupili⸥ nunge kimuni amboloi.” ningu tondolo munduku mawa teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kanu kinie yambo kakapu teko moloringime mundupe kelepa “Oltolo molambili.” nimbe kanu yemo tenga memba pupelie nirimumuni, komutolonga ki sundu suku mundupe, lkambe topa yemonga alimbelumu kimuni ambolopalie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mulúna olando sipe kanopa, tondolo mundupe múlu lipe, Juda yambomanga ungu lepa yemondo nimbendo: “Epata!” nirimu. (Kanu ungumunge pulumu “Komumuni pilí!” nirimu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aku nirimu kinie tamburembu yemo komu peo lepa yu ungu kapola pilipe, alimbelumu takele terimu kanumu pe nimbe umbu alimbelu angilirimu kinie yu ungu sumbi sipe nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kanu kinie Yesusini enendo tondolo mundupe nimbendo: “Nane i ulu tekero mele anju yambo telurindu kepe paa naa ningu siei!” nirimu. Nakolo yu “Molo.” nimbe karaye terimu mele ta ningu anju yamboma yuni terimu mele temane toko siliku mindi andoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","⸤Yu terimu mele kanoringi yamboma kinie, anju temane toko siringi piliringi yamboma kinie⸥ ene paa mini wale munduku suru ningulie ningindu: “Apa! Yu telemo uluma peangama mindi telemo. “Komu silimoma ungu pilku, ungu naa nilimelema ungu ningu, teai.” nilimo kinie kepe unguma pilku unguma ningu telemele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Walse Yesusi molorumuna yambo aisili altoko ongo liku maku toko moloringi. Moloringi koleana nonge langi te naa lerimuna Yesusini yu lombili andolimendo* “Na moliona wai.” nimbelie enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“I yambo maku toko molemelema na kondo tekemo. Wale yepoko na kinie molongi, pe kinié ga nonge te naa lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mare aulke suluna oringimunge nane “Ene engele tepa pepili ulkendo pai.” nilkenje ene aulkena kimbu ki pange mange tepa, topa ne munde ya munde telka.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aku nirimu kinie pilkulie yu lombili andolimene yundu pundu toko ningindu: “⸤Sike nikinu nakolo⸥ i kolea ku leline molemolo. I yamboma manda nonge mele pillawa kaloli tena lembana lipu simulúye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesusini enendo “Pillawa kaloli nambepa nosikimiliye?” nimbe walsirimu kinie enene “Yepoko pakara nosikimulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kanu kinie yuni maku toko moloringi yambomando “Manie molai.” nimbelie, pillawa kaloli yepoko pakara lipe ⸤Pulu Yemo kinie⸥ “Ange.” nimbe, akuma pike lepa yu lombili andolimendo “Yamboma moke teko siei.” nimbe ene sirimu. Nirimu kanu mele teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ene oma kaloli kanga pokore kepe nosiringila, akuma lipe ⸤Pulu Yemo kinie⸥ “Angela.” nimbelie yu lombili andolimendo “Ime yamboma moke teko siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yamboma ⸤langime⸥ noringi kinie olo terimu. Pe langi kakena lerimuma lombili andolimene liku wale basiketemanga lakiliringi, wale aili yepoko pakara peke lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ye po tausinini aku langime noringi. Kanu kinie Yesusini maku toko moloringi yambomando “Ulkendo pai.” nimbelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yu lombili andolime kinie yu kinie ene nona andoli sipine suku puku, ⸤nomuna nekendo⸥ kolea Dallamanuta* puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Akuna puringi kinie Parisi yema* Yesusi molorumuna ongo, ‘Yuni nambe tembanje? Kanamili.’ ningu yu manda manjiku** mawa tekolie ningindu: “⸤Ungu Mane Silimu,⸥ ‘Nu sike Pulu Yemone ‘Kongono tenjeni.’ nimbe ya mana lipe mundurumunje kanamili.’ ningu mulu koleana molemo ⸤Pulu⸥ Yemone mindi manda ulu ⸤tondolo⸥ telemo mele te tei.” niringi.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","⸤Aku siku walsiringi kinie pilipe keri pilipelie Yesusi⸥ yunge konopuna paa umbuni terimuna múlu aili tepa lipelie nimbendo: “Kinié mana molemele yambomane “Pulu Yemone mindi ulu tondoloma manda telemo mele kanamili tei.” ningu na nambemuna mawa telemeleye? ⸤Na molio mele nambemuna “Sike.” we naa ningu tondolo munduku pilimeleye?⸥ Nane ene sike nimbu sikiru: ⸤Na Pulu Yemo kinie tapu topo kongono telembolo mele⸥ lipe ora simbe kanonge ulu tondolo te, kinié mana molemele yamboma kinie wendo naa ombá.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aku sipe nimbelie nirimumuni, ene mundupe kelepa sipine suku kelepa pupelie nomuna nekendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","⸤Kanu kinie ene nomuna nekendo pungindu Yesusi lombili andoli yema⸥ pillawa kaloli komu siku naa mengo puringi. Pillawa kaloli telu mindi sipine suku lerimu, te pea molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kanu kinie Yesusini enendo lepi lepi topa ⸤ungu iku topalie⸥ nimbendo: “Paa mimi siku kanai! Parisi yema kinie ⸤ye nomi kingi⸥ Erote yunge yema kinie enene pillawa akoli mele isi nosilimelemo kanoko konjei!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aku sipe nirimu kinie pilkulie yu lombili andoli yemane eneno kerepali ningulie ningindu: “Olio pillawa kaloli ⸤nomolo⸥ mare naa lipu membo omulumunge aku sipe nikimunje.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aku siku niringi mele pilipelie Yesusini enendo nimbendo: “Enene “Pillawa kaloli naa memulu.” ningu nambemuna kerepali nikimiliye? Ene kinié kepe naa kanoko, mimi siku naa pilkimiliye? Na tondolo te perimuna pillawa kalolime kinie ulu tondolo te terindu mele ene naa piliringiye? Ene konopu naa pepili molemelemonga nane nikiru mele ungu pulumu naa pilkimiliye?* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ene mongo angilimo nakolo melema naa kanokomeleye? Komu angilimo nakolo unguma naa pilkimiliye? Pillawa kaloli te pakara lipu pike lepo ye pape tausini moke tepo sirindu kanumu ene komu sikimiliye? ⸤Nongo pora siringi kinie⸥ langi kakena lerimuma liku wale basikete nambepa toko peke siringiye?”* nirimu kinie ⸤yu lombili andolimene⸥ yundu pundu toko “Engaki rurepo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","⸤Yuni enendo kelepa nimbendo:⸥ “Pe pillawa kaloli yepoko pakara lipu pike lepo ⸤yambo⸥ po tausini moke tepo sirindu kinie ⸤nongo pora siringi kinie⸥ wale basikete aili nambepa langi kakena lerimuma toko peke siringiye?” nimbe walsirimu kinie enene yundu pundu toko “Yepoko pakara.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yuni enendo ⸤kelepa⸥ nimbendo: “Enene kinié kepe mimi siku naa pilkimiliye?”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesusi kinie, yu lombili andolime kinie, ene Besaida taonona puringi kinie mongo keri lerimu ye te Yesusi molorumuna mengo ongo mawa tekolie ningindu: “Nuni i yemo kini amboloi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aku niringi kinie Yesusini mongo keri lerimu yemo ki ambolopa taono ulsukundu memba pupelie yunge mongotolonga lkambe topa kanjipe kimuni ambolopalie nimbendo: “Nu kinié melte kanokono molo moloye?” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","yemone olando sipe kanopalie nimbendo: “Na kinié yambo mare, ene unju melema ongo pukumili kanokoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesusini yunge mongotolonga kelepa ambolorumu kinie yemo yu mongo makilipe melema pali mongotolone sumbi sipe kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesusini yemondo “Ulkendo pui.” nimbelie nimbendo: “Nu kelko ulkendo punindu ne kolea ⸤molopo wendo ombulu⸥ akuna ⸤kelko yando⸥ naa pui.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesusi kinie yu lombili andolime kinie puku kolea aili Sisaria Pillipai nondopa lerimu kolea kangamanga pungí puringi. Akuna pungí puringi kinie Yesusini yu lombili andolimendo walsipelie nimbendo: “Yambomane na imbi lelko nae nilimeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Enene yundu ningindu: “Marene “Nu No Linjili Jono ⸤kolorumu kinié kelepa lomboropa ola molemo⸥.” ningu pilku, marene “Nu ⸤Pulu Yemone ou konde molopili olando lirimu ye⸥ Illainja kelepa omba molemo.” ningu pilku, marene “Nu Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye te ⸤ou kolorumu kinié lomboropa ola molemo.⸥” ningu pilimele.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aku niringi pilipelie Yesusini enendo walsipe pilipelie nimbendo: “⸤We yambomane aku siku nilimele⸥ nakolo ene eneno na nae nilimeleye?” nirimu. Pitane pundu topa nimbendo: “Nu Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ ou nimbe mako torumu ye nomi Kirasimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","⸤Pitane aku nirimu pilipelie⸥ Yesusini enendo tondolo mundupe nimbendo: “Na molio mele ⸤Pitane kinié nikimumu⸥ enene anju yambo telurindu kepe ⸤isili ou⸥ paa naa ningu siei!” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kanu kinie Yesusi yu lombili andolimene yundu ⸤“Pulu Yemone olio “Nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye nomi Kirasimu nu.” ningu, ningu para siringi kinie pilipelie⸥ yuni yu kinie wendo ombá mele pulu monjipe* ene mane sipelie nimbendo: “Manie Omba Mana Ye Au Lerimu Yemo mindili aisili nombá. Juda yamboma nokolemele tapu yema kinie, Pulu Yemo popo tonjili ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane sili yema kinie,** enene ⸤ningindu: “Yu Pulu Yemone naa lipe mundurumu. Yu Pulu Yemonga Malo naa molemo.” ningu⸥ yu liku bulu siku yu toko konjingí. Yu toko konjingí kolomba kinie wale talo omba pumbe kinie yepoko sipemonga yu lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesusi yu kinie wendo ombá mele aku sipe sumbi sipe nimbe para sirimu kinie pilipelie Pitane yu anju lipe memba pupelie ⸤Yesusi yuni “Na toko konjingí.” nirimumunge⸥ yu pulu monjipe iri torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nakolo ⸤yuni kurumanga nomi Setenene* ungu umbu tonjirimu mele pilipelie nirimuna pilipelie⸥ Yesusini topele topa yu lombili andolime kanopalie Pita iri topalie yundu nimbendo: “Setene, nu anju pa! Nu Pulu Yemone konopu lemo mele naa leno. Yambomane konopu lemele mele mindi leno kene anju pui!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kanu kinie yambo akuna liku maku toko moloringime pali kinie yu lombili andolime pea “Na moliona wai.” nimbelie enendo nimbendo: “Yambo tene ‘Yu lombili pambo.’ nimbelie yuni yunge konopumuni pilimo melemanga ‘Topo manie mundembo.’ nimbe yamboma unju perana angilku mindili nongo kolemele mele yuni unju pera mele gomo lembando ‘Na yu lombili pumbundu mindili nondu liemo papula; kolondu liemo papula.’ nimbelie na lombili opili. We naa opili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yambo tene yunge mana molopa naa kololi ulu pulumu ambolomba temba kinie yu kolopalie sike molopa kenjipe mindi pumbe. Nakolo yambo te na konopu monjipe nanga yambomo molopa, ‘Yamboma temane peangamo piliengi!’ nimbe ene nimbe sipe molomba kinie yu kolopalie yu konde molopa konjipe mindi puli ulu pulumu sike kanopa limbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","⸤Akumu nambemuna nikiruye?⸥ Yambo tene mana melema pali yuyu lipe nosipelie yu mini pali Pulu Yemo naa molomba koleana pupe mindili nomba molopa kenjilkenje kanu melemane kanu yambomo nambe tepa lipe taponjilkenje? Lipe naa taponjilkemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yambo tene ‘Na mini pali konde molopo konjipu mindi pambo.’ nimbelie yu nambolka meltene mini pali konde molopa konjipe mindi puli ulu pulumu topo topa lilkeye? Meltene manda topo topa naa limbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Nanga yambo mare ulu pulu keri teko Pulu Yemo munduku kelko mele lupema imbi ambolko ola linjiku molemele yamboma kinie molkolie pipili kolko ningindu: “Olio Yesusinge unguma pilipu lipu, yu lombili andopo molemolo mele we yambomane naa piliengi!” ningulie na kiyongo ningu lombili andolemele yamboma, ene kinie ulu te pe wendo ombá mele nimbu siembo: Manie Omba Mana Ye Au Lerimu Yemo* pe Lapanga tondolo pa telimu kinie ⸤mulu koleana⸥ angello kake telime kinie ⸤manie⸥ ombá temba kinie, kanu we yamboma molongena yunge yamboma mona molongendo we yamboma molongena kanokolie, yu ou naa opili ‘Olio yunge yamboma molemolo mele we yambomane naa piliengi!’ ningu pipili kolko lopi teko molonge yamboma yuni lipe wekendo kanopa, “Na moliona naa wai!” nimbéla.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesusi yuni enendo ungu te pea nimbendo: “Nane enendo paa sike nimbu sikirumu: Ene ya angilkimilimenga mare ou kolou naa kolangi Pulu Yemo ye nomi kingimu omba,* enge nimbe molopa, melema kinie yamboma kinie pali nokomba ombá kanonge.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesusini ⸤yu lombili andolimendo aku sipe nimbe sirimu kinie⸥* pe koro te omba purumu kinie Pita keme Jemisi keme Jono keme ene lipe memba pupe mulú** paa olandopa polorumu tenga ola purumu. ‘Olio oliolio mindi molamili.’ nimbe ene akuna lipe memba purumu. Akuna puringi kinie ene kanoko molangi yunge kangimu alowa tepa, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","yu pakorumu mulu wambalema ena tondolo topa mongo paa takele telemo mele aku sipe paa kake terimu. Ya mana yambo tene wale pakoli te sopone kulumiye topa kake tenjimbe mele kapola molo. ⸤Yunge mulu wambalema kake terimu mele paa olandopa.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yu aku sipe molopili, ⸤Juda yambomanga koronga ou moloringili ye aili talo,⸥ Illainja kinie Mosisitolo ongolo Yesusi kinie ungu ningulu mona angiliringili kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kanu kinie Pitane Yesusindu nimbendo: “Rapai,* olio ya molopamolo peanga lepamo. Olione ulke takaye yepoko takonjemili. Te nunge, te Mosisinge, te Illainjanga takonjemili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Nakolo aku nirimumu ene pipilini paa koloringine yuni nimbé mele naa pilipe ungu te walu nirimu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kanu kinie kupe te omba ene aki torumu kinie kupena suku ungu te wendo ombalie nimbendo: “I yemo nanga konopu monjilio Malomo. Yuni ungu nimbéma pilku liengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe walsikale, ene mongo male male teko kanokolie yetolo altoko naa kanoringi. Yesusi yu mindi ene kinie molorumu kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mulu polorumumunge manie onge oringi kinie Yesusini ene mane sipelie nimbendo: “Enene kinié kanongi mele isili ou yambo teluri kepe ningu naa siengi. Pe mindi, Manie Omba Mana Ye Au Lerimu Yemo* kolopalie altopa lomboropa ola molomba kinie temanemo toko anju siengi. Ou molo!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aku nirimu kinie ene yunge ungumu pilku liku ou anju naa niringi nakolo “yu “kolopolie altopo lomboropo ola molombo.” nikimu ungu kanumunge pulumu nambolka ulurindu nikimunje?” ningu ene eneno kerepali niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kanu kinie yu lombili andolimene ⸤yu sike molorumu mele ningu kanokolie⸥ yundu walsiku pilkulie ningindu: “⸤Pulu Yemone ‘olio nokopa konjipe lipe taponjimbe.’ nimbe mako torumu ye nomi Kirasimu nu liemo⸥ Pulu Yemonga ungu manemanga puluma pilku mane silimele yemane “Illainja ⸤kelepa⸥ kumbi lepa ombá. ⸤Ye nomi Kirasimu pe akilipe ombá.⸥” nilimele akumu nambemuna nilimeleye? ⸤Illainja kelepa naa opili nu koronga orunu moleno kanumu.⸥” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesusini pundu topa nimbendo: “ “Illainja ⸤kelepa⸥ kumbi lepa ombalie melema pali tepa mimi temba.” nilimele kanumu sike nilimele. Aku liemo Manie Omba Mana Ye Au Lerimu Yemo kanoko keri kanoko mindili liku singí mele ⸤Pulu Yemonga⸥ bokuna nambemuna imbi toringi molemoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nakolo ⸤akumunge ungu te pea nimbu sikiru.⸥ Pilieme! Illainja koronga orumu. Yu orumu kinie ⸤kanu yemane yu kanoko imbi naa siku⸥ ‘yu we yere.’ konopu lelkolie ‘yu kinie temolo.’ ningu piliringi uluma pali teringi.* Yu kinie aku siku tenge mele ou bokuna imbi toringi molemola.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","⸤Yesusi kinie yu lombili andoli ye yepoko kinie⸥ ene yu lombili andoli ye wema moloringine yando ongo, yambo paa aisili akuna kakapu teko maku toko moloringi kanoringi. Pulu Yemonga ungu manemanga puluma pilku mane siringi yemane* Yesusi lombili andoli ye wema kinie ungu ningu, ungu mare walsiku pilku moloringi kanoringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yesusi orumu kinie kanokolie kanu maku toko moloringi yamboma suru aili teko ningu yu orumuna lkisiku ongo yundu “⸤Ailimu,⸥ nu okonoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kanu kinie yuni enendo “Enene ungu nambolka ungumu kerepali nikimiliye?” nimbe walsirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","kanu maku toko moloringi yambomanga ye tene pundu topa yundu nimbendo: “Ungu Mane Silimu, nanga kangomo, kuru te yunge konopuna molemomonga ungu manda naa nilimona nu molonu ⸤konopu lepolie⸥ membo ondu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kurumuni kangomo wale marenga ambolopalie yu topa manie mundulimo kinie yu kuru kopalli topa, apapu memba, ungú kinirokó lipe telemo. Nu lombili andolimendo aku temanemo topo sipu enene kanu kurumu ‘Makorangi.’ nimbu mawa tendu nakolo ene manda naa tengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aku nirimu kinie pilipelie Yesusini yamboma ⸤iri topalie⸥ nimbendo: “Kinié molemele yamboma ene ⸤‘Pulu Yemone uluma sike manda temba.’ ningu⸥ tondolo munduku naa pilku molemele yamboma, na ene kinie molopo, wale nambe tepo mane sipu ulu mare lipu ora simbu kinie mimi siku pilingíye? ⸤Na ene kinie siye tekemo.⸥” nimbelie “Na moliona kangomo mengo wai.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","kangomo yu molorumuna mengo oringi. Mengo oringi kinie ⸤kangomonga konopuna molorumu⸥ kurumuni Yesusi kanopalie kangomo topa manie mundurumu kinie kangomo kimbu kime peue mundupe apapu merimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aku terimu kinie kanopalie Yesusini kangomonga lapa walsipelie nimbendo: “Kangomo i kurumu tewale pulu monjirimuye?” nirimu. Lapane nimbendo: “Yu kokele anumuni merimu kinie aku sipe terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wale aisili yu kopalli topa tepena topa mundupe, nona topa mundupe telemo kene nuni manda liku taponjinu liemo olio kondo kolko liku taponji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesusini nimbendo: “Nuni nambemuna “Manda liku taponjini molo moloye?” nikinuye? ‘Nane nu manda lipe taponjimbe.’ ningu tondolo munduku pilinu liemo* uluma pali sike wendo ombá.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesusini aku nirimu kinie pilipelie kangomonga lapane tondolo ru nimbelie nimbendo: “Nane ‘sike nuni liku taponjini.’ nimbu pilkiru nakolo ‘Sike.’ nimbu pilkiru ungumu tondolo mundupu ambolombo mele manda naa tekemo kene ‘Sike.’ nimbu pilkiru mele ‘tondolo pupili.’ ningu liku taponjeni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","⸤Kanu kinie⸥ yamboma lkisiku sukundu sukundu kanonge onge oringi kanopalie Yesusini kurumu iri topalie nimbendo: “Kere pipi siku, komu pipi siku teleno kurumu, kangomonga konopuna ongo wendo puku, altoko paa naa ongo molani. Kamu pui!” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","kurumuni kangomo tondolo topa manie mundurumu kinie yu kimbu kime peue mundurumu kinie kurumu kalle nimbe yunge konopuna wendo orumu. Kanu kinie kangomo yu kolopa lerimu none terimu kanokolie yambo aisilini “Yu kolomu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nakolo Yesusini yunge kimu ambolopalie yu ola lirimu kinie ola angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","⸤Kanu kinie Yesusini kurumu topa makoropa pora sipelie⸥ ulkena sukundu ⸤yu lombili andolime kinie⸥ purumu kinie lombili andolime enene Yesusi pea eneno molkolie yu walsiku pilkulie ningindu: “Kuru akumu olione nambemuna manda naa makoromuluye?” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesusini pundu topa nimbendo: “I ulumu mele temolondo Pulu Yemo kinie ungu nimbu mawa temolomone mindi manda temolo. We manda naa temolomo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","⸤Yesusi kinie yu lombili andolime kinie⸥ ene aku koleamo munduku kelko ⸤yamboma moloringi koleama naa puku⸥ kolea Gallilli disiriki sumbi siku ongo pungí puringi. Akuna pungí puringi kinie yu lombili andolime ungu mane silipe purumuna ‘Na lombili andolime ungu mane sikiru mele we yambomane naa piliengi kene olio we yambomane naa kanangi, pea naa pamili.’ nimbe yu kinie yu lombili andolime kinie eneno kiyongo ningu puringi. ⸤Yu kinie pe wendo ombá mele⸥ yuni ene ungu mane silipe purumu mele i sipe: “Manie Omba Mana Ye Au Lerimu Yemo ka sikulie ⸤yu tonge⸥ yema anju singí kinie* enene yu toko konjingí. Kolopalie wale yepoko sipemonga yu lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nakolo yuni nirimu ungumu pilku sundukulie ‘I ungumunge pulumu nambolkarenje, naa pilkimulu.’ niringi nakolo “Nambolka ningu nikinuye?” ningu walsiku pilingindu pipili kolko naa walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","⸤Ongolie⸥ kamu Kapeniame taonona suku oringi. Molonge ulkena suku puku moloringi kinie Yesusini yu lombili andolime walsipe pilipelie nimbendo: “Ene aulkena ungu nambolkarenga kerepali niliku ongiye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nakolo enene ‘Olionga ye nae paa olandopa molemoye?’ ningu kerepali ningu keru kuru liringine Yesusindu ene niringi mele ningu para singímunge pipili kolkolie molko duma liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanu kinie Yesusi yu manie molopalie yu lombili andoli rurepondo “Na moliona wai.” nimbelie nimbendo: “Yambo tene ‘Yambomanga ailimu molambo.’ nimbelie yu we yambomo molopa yambomanga kendemandemo molopili.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aku nimbelie ambolango kanga te lipe ⸤yu lombili andolime⸥ angiliringine monjipelie nirimumuni, aku ambolangomo yuni kangulupe enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yambo tene ‘Na Ailimunge yambomo molio.’ nimbe* i ambolangomo mele lipe taponjimbe kinie kanu yambomone aku tembamonga na lipe taponjimbela. Na lipe taponjimbe yambomone na manjipe naa lipe taponjimbe. Ambolangomo lipe taponjimbemonga kanu yambomo yuni na lipe mundurumu yemo lipe taponjimbela.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","⸤Yesusi lombili andoli ye⸥ Jonone Yesusindu nimbendo: “Ungu Mane Silimu, olio kanomulu, ye tene nunge imbimu lepa* kuru mare yambomanga konopuna molongime “Ongo wendo pai!” nimbe topa makoropa molomu kanomulu. Kanopolie yu olio pea tapu topo naa molemolo kene yundu “Nu aku siku naa tei!” nímulu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aku nirimu kinie pilipelie Yesusini yundu ⸤kanu yemone terimu ulumundu⸥ nimbendo: “Yambo tene nanga imbi lepa ulu tondolo te tepalie yuni kelepa nondopa nando ungu te manda nimbe naa kenjimbe kene enene yundu “Molo!” naa niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yambo te olio kinie opa toumu naa molemomo olionga opa lkerayemo molemo kanumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Nane enendo paa sike nimbu sikirumu: Ene no waka lemba kinie yambo tene ‘Ene Kirasinge yamboma molemele kene no te nangi kolopo siembo.’ nimbe ene te kolopa simu liemo, Kirasinge kongono tenjingí yamboma yuni mele kalomba kinie kanu yambomo kepe komu naa sipe yu konopu lipe mundupe mele kalombala.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yambo tene i ambolangomonga ⸤mele yambo⸥ te na ‘Sike’ nimbe tondolo mundupe pilimo ambolangomo* ‘Ulu kerime tepili.’ nimbe kondi tombamonga kanu ambolangomo tondolo mundupe pilimo mele mundupe kelepa bulu simu liemo ⸤ambolangomo ou kondi naa topili⸥ yu kou paa aili te** moko toko nomine lenjiku ‘Yu kamu kolopupili.’ ningu paka toko nomuna paa maniekondo mundulimelkanje paa papu.*** Aku siku toko mundulimelka kinie yu kolopalie pe yu Pulu Yemonga ambolango tendo ‘Ulu kerime tepili.’ nimbe kondi manda naa tolka. Nakolo yu aku siku nomuna naa mundulimelka kinie yu yamboma kondi tombamonga Pulu Yemone yu mongo aili silke kene enene yu nomuna papu paka toko mundulimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Nunge kitolone ulu pulu keri te temu liemo aku kitolo karu lelko ele teani. Nu konde mololiku mindi puni koleana* kitolo naa angilipili puni kinie peangamo. Nunge ki talo we angilipili nu tepe kolea, (‘akuna Pulu Yemo teko kenjilimele yambomanga korowama kolou naa kolopa nolipe mindi pulimo, tepe toko kumunji naa kumunjilimele kolea’)** akuna suku toko mundungí kinie kerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Molo nunge kimbutolone ulu pulu keri te temu liemo aku kimbutolo karu lelko ele teani. Nu konde mololiku mindi puni koleana kimbutolo naa angilipili puni kinie peangamo. Nunge kimbu talo we angilipili nu tepe kolea, (‘akuna Pulu Yemo teko kenjilimele yambomanga korowama kolou naa kolopa nolipe mindi pulimo, tepe toko kumunji naa kumunjilimele kolea’) akuna suku toko mundungí kinie kerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","“Molo nunge mongotolone melte kanokolie konopuni ‘liembo.’ ningu pilku ulu pulu keri te tenu liemo aku mongotolo akuku ele teani. Nu Pulu Yemo ye nomi kingimu molopa nokolemo koleana* mongotolo naa angilipili puni kinie peangamo. Mongo talo we angilipili nu tepe kolea, ‘akuna Pulu Yemo teko kenjilimele yambomanga korowama kolou naa kolopa nolipe mindi pulimo, tepe toko kumunji naa kumunjilimele kolea’** akuna suku toko mundungí kinie kerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Yambomane Pulu Yemo popo toko kalemele melema singíndu ‘Pulu Yemone kanopalie ‘Langi kake telime.’ nimbe kanopili.’ ningu api kusa mundukulie silimele* aku siku mele yamboma molongena tepemo, api kusa mele, yamboma kinie pali wendo ombá.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Api kusa yu mele peangamo nakolo yu songo naa temba kinie ‘Yu kelepa songo tepili.’ ningu ulu te manda telemeleye?* ⸤Api kusa langimenga mundulimele kinie songo telemo aku siku⸥ ene api kusa mele molko yamboma kinie anju yando konopu teluna pupili taka lelko molangi.” ** nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kanu kinie Yesusi molorumu koleamo mundupe kelepa kolea Judia disiriki pupe no Jodane lumbilipe nekendo purumu. Kanu kinie altoko yambo aisili yu molorumuna ongo maku toringi kinie alieli aku teringi kinie yuni yamboma ungu mane sirimu mele maku toringime altopa mane sirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi ye mare* yu molorumuna ongo ‘Yu nambolka nimbénje? Nimbe kenjimbenje manda manjipu piliemili.’ ningu** yu walsiku pilkulie ningindu: “Ye tene yu yuyu pilipelie yunge ambomo “Kamu pui.” nimbé kinie kapola temba molo aku temba kinie ungu mane te pulue tombaye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yuni anju pundu topa nimbendo: “Mosisini aku ulumundu ungu mane sipe nambolka nirimuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Enene ningindu: “Mosisini nimbendo: “Ye tene yunge ambomondo ‘Kamu pupili.’ nimbe makorombando ambomo “Kamu pui.” nimbé mele pepá tenga topa ambomo sipelie yundu “Kamu pui.” nimbe aku tepili.”* nirimu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesusini nimbendo: “Mosisini sike aku sipe bokuna torumu nakolo ene kara puku Pulu Yemone ambo yetolo kapola kapola molongele mele ungu mane sirimumu liku su siringi naa piliringine yuni “Aku teangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nakolo ou pulu pulu Pulu Yemone melema tepalie yuni yambo tembando yemo kinie ambomo kinie terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Aku sipe terimumunge ye tene ambo te lipelie yunge anumu lapatolo mundupe kelepa yunge ambomo kinie eltelte teluna tapu toko peko, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kangi telumu mele ⸤molkolo eltenga konopu teluna pupili⸥ molongele.’* Ye te ambo te limo kinie kangi telumu mele molembelena elte altoko talo mele naa molembele, elte yambo telumu mele molembele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yambo telumu molembele kene Pulu Yemone ambo ye talo ‘Telumu molangili.’ nilimo ambo yetolo yambo tene liku lupe lupe naa mundengi. Aku tengi liemo kapola naa temba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Altoko ulkena suku puku moloringi kinie yu lombili andolimene Yesusi yundu aku ungumunge pulumu walsiku piliringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","yuni enendo pundu topa nimbendo: “Ye tene yunge ou limo ambomo makoropa “kamu pui.” nimbelie kelepa ambo te limo kinie aku yemone wa ulu kerinele tepa, ou limo ambomo tepa kenjilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Molo ambo te yunge ou pulimo yemo mundupe kelepa wendo pupe ye te pulimo kinie aku ambomone wa ulu kerinele telemola.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kanu kinie yambomane enenga ambolangoma ‘Yesusi yunge kimuni ambolopili.’ ningu yu molorumuna mengo oringi. Nakolo yu lombili andolimene iri toko ⸤“Naa mengo wai!”⸥ niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","⸤“Molo.” niringi kinie⸥ kanopalie Yesusini konopu keri panjipe ⸤yu lombili andolime⸥ enendo nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yambo talape akumu* i ambolangoma mele molemele yamboma enenga yambo talapemo kene enene i ambolangoma na moliona wangi pipi siku “Molo.” naa niei!” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Nane enendo paa sike nimbu sikirumu: Ambolangomane* ‘Pulu Yemo olionga ye nomi kingimu molopili.’ ningu molemele mele aku siku naa nilimele yamboma yunge koleana suku paa naa pungí, molo.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aku nimbelie yuni ambolangoma kangulupe yunge kimuni ene telu telu nimbe pengena ambolopa ene tepa konjimbendo “Pulu Yemone “Ene molko konjengi.” nipili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kanu kinie Yesusi ola angilipe kolea marenga pumbe purumu kinie ye te yu pumbe purumuna lkisipe omba yunge kumbikerena koporongo langopa yundu walsipe pilipelie nimbendo: “Ungu Mane Sili peangamo, na nambolka uluri tembo kinie na konde molopa konjipe mindi puli ulu pulumu limbuye?”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesusini yundu nimbendo: “Nuni na nambemuna “Peangamo” nikinuye? Yambo peanga te molo. Pulu Yemo mindi peangamo.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","⸤Aku nimbelie yemone walsirimumunge pundu topa nimbendo:⸥ “Nu ⸤Pulu Yemonga⸥ ungu manema ⸤Mosisini yando nimbe sirimuma⸥ pilino. Yuni nimbendo: “Yambo toko naa konjengi.” nimbe, “Ambo ye pulime molo ye ambo lilime yambo lupema kinie wa ulu kerinele naa teangi.” nimbe, “Melema wa naa liengi.” nimbe, “Yambomanga kote kolo toko naa tenjengi.” nimbe, “Yambomanga melema kolo toko we naa liengi.” nimbe, “Aminieli lanieli kinie teko konjiku, ungu ningí mele pilku liku teko molangi.”* nimbe, ungu mane akuma sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aku nirimu kinie pilipelie kanu yemone nimbendo: “Ungu Mane Silimu, na kangomo molopolie aku ungu manema pali pilipu lipu tepo molorundu mele yandopa kinié kepe tepo molioko.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesusini yu nemo nemo nimbe kanopa konopu monjipelie yundu nimbendo: “Papu teleno nakolo ulu telu mindi naa teleno. Nu puku nunge mele nosilinoma pali kou mone lipukulie, kou mone linime yambo koropama moke teko sikulie na lombili oi.” nirimu. “Nunge ⸤mana⸥ melema aku teni kinie mulu koleana nunge mele aisili lemba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kanu yemo mele paa aisili nosirimuna Yesusini yundu aku nirimu kinie pilipelie yu kumbikere tepa konopu keri panjilipe anju purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","⸤Aku terimuna kanopalie⸥ Yesusi topele topa yunge lombili andolimendo nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo koleana* suku pungindu yambo kamakoma paa mindili siku suku pungí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aku ungumu nirimu ⸤kinie pilkulie⸥ yu lombili andolimene mini wale munduringi. Nakolo Yesusini altopa enendo nimbendo: “Kangoma, Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungindu yamboma paa mindili siku pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kongi kemele ⸤kongi paa aili te nakolo⸥ kale suru toline suku pumbendo mindili kanga mele sipelie pumbe. Nakolo yambo kamakoma Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungindu mindili paa aili mele siku pungí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","⸤Aku nirimu kinie pilkulie⸥ yu lombili andolime paa mini wale munduku suru ningu anju yando ungu mele tekolie ningindu: “Aku liemo mindili nolemelka aulkena nae manda wendo pupe, molopo konjimulu aulkena pumbeye?* Te molonje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesusini ene nemo nemo nimbe kanopalie nimbendo: “Sike yamboma eneno manda molo, nakolo Pulu Yemone manda tenjimbe. Pulu Yemo yuni uluma pali kapola telemo. Ulu te yuni manda naa temba te molo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yuni aku nirimu kinie pilipelie Pitane yundu nimbendo: “⸤Pe olio kinie nambolka uluri wendo ombáye?⸥ Olio olionga melema pali mundupu kelepo nu lombili purumulu mele pulimolo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesusini nimbendo: “Nane enendo paa sike nimbu sikirumu: Yambo na konopu monjiku nanga kongono tenjiku temane peangamo toko siliku andongendo enenga ulkema, angenupili, kemulupili, anupili, lapali, ambolangoma, koleama, akuma munduku keleringi yamboma pali ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya mana paa olandopa mele aisili likulie, pe pungí koleana konde molko konjiku mindi puli ulu pulumu lingíla.* Ya mana ulkema, angenupili, kemulupili, anupili, ambolangoma,** koleama kinie, akuma pali aisili olandopa lingíla; ⸤na konopu naa monjingí yambomane⸥ ene mindili singíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nakolo kinié aili molemele yambomanga aisili pe ⸤Pulu Yemo ye nomi kingimu molopa nokomba koleana⸥* yambo koropama molonge; kinié koropa pupili molemele yamboma pe yambo ailime molonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kanu kinie ⸤Yesusi kinie yu lombili andolime kinie⸥ ene kolea aili Jerusalleme pungí puringi. Yesusi kumbi lerimuna lombili andolime paa konopu aisili liku munduliku yu lombili puringi. We yambo akilku lombili oringime kepe mini wale munduku pipili kololiku puringi. Yesusini ⸤yu lombili andoli⸥ ye engaki rurepo ‘na kinie ene kinie oliolio molamili.’ nimbe ene lipe anju memba pupelie yu kinie wendo ombá mele altopa pulu monjipe nimbe sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Pilieme. Olio Jerusalleme pumulú pukumulu. Akuna pumulú kinie Manie Omba Mana Ye Au Lerimu Yemo ye tene ‘Tangi.’ nimbe Pulu Yemo popo tonjili ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane sili yema kinie,* lipe simbe, enene yu kote tenjiku ‘Yu kolopili tangi.’ ningulie Juda ye naa molemele yema liku singí.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kanu kinie kanu yemane yu ungu taka tonjiku yunge kumbikerena lkambe toko yu ka pulsene toko yu toko konjingí. Yu toko konjingí kinie wale yepoko sipemonga lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kanu kinie Seperi malo Jemisi kinie Jonotolo elte Yesusi molorumuna ongololie ningilindu: “Ungu Mane Silimu, nuni ‘Olto ulu te teani.’ nimbu mawa tembolo okombolo.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yuni eltendo nimbendo: “Nambolka uluri ‘nane elte kinie tenjembo.’ ningu nikimbiliye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eltene pundu toko ningilindu: “Nu pe nunge kolea tondolo pa teline ⸤ye nomi kingimu molkolie ninimuni, ‘olto nu kinie pea ye nomime molamili.’ ningu⸥ ‘olto te nunge ki umbukundu monjiku te nunge ki tarokondo monjeni.’ nimbu mawa tekembolo.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesusini eltendo nimbendo: “Mawa tekembele mele elte pilku naa konjikimbili. Na no mingine no nombomo elte manda nongeleye? Molo na no limbumu elte manda lingilíye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eltene yundu pundu toko ningilindu: “Manda tembolo.” niringili. Yuni eltendo nimbendo: “Na no mingine no nombomo pe elte sike nongelela. No limbumu pe sike lingilíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nakolo nane elte “Nanga wangutolonga ongo molangili.” nimbumu kapola naa temba. ⸤Pulu Yemone yuyu⸥ akuna molongeletolo koronga mako torumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jemisi Jonotolone ⸤‘Yesusinge wangutolonga molambili.’⸥ ningu mawa teringili mele pilkulie lombili andoli rureponga talo* wemane elte kinie konopu keri panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanu kinie Yesusini ene “Wai.” nimbelie nirimumuni, enendo nimbendo: “Olio Juda yambomanga ulsu molemele yambo* talapemanga ye nomime enenga yamboma tondolo munduku nokoko kongono enge nilime alieli silimele. Ye imbi ola molemo yema enenga yamboma ‘Mindili nangi.’ ningu nokolemele. ⸤Yambomane enenga ye nomimenga unguma liku su singí aulke te naa lemo mele⸥ ene pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nakolo ⸤we yambomanga ye nomimene enenga yamboma tondolo munduku nokolemele mele na lombili andoli yema⸥ ene eneno aku siku anju yando naa teangi. Enenga ye te ‘Na imbi olandopa molopili. Na ye ailimu molambo.’ nimbé yemo enenga kongono tenjili yemo molopili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","‘Na enenga ye nomimu molopo ene nokambo.’ nimbé yemo enenga pali kongono kendemande tenjili yemo molopili.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aku sipela, Manie Omba Mana Ye Au Lerimu Yemo kepe ‘Yambomanga ye ailimu molopo ene nokambo. Enene nanga kongono tenjili kendemande yamboma molangi.’ nimbe naa orumu. ‘Yambomanga kongono tenjili kendemande yemo molopo ene lipu taponjipu, ulu pulu kerimene ene ka sipe nokolemo mele naa tepili kapola molangi kene na yambo aisilinge nimbu pundu tonjipu nanga kangimu sipu, kolo wangopo kolonjembo.’ nimbe orumu.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kanu kinie Yesusi kinie yu lombili andolime kinie ene kolea aili Jeriko oringi. Ongolie ene kinie we yambo aisili kinie Jeriko munduku kelko pungí puringi kinie mongo keri lerimu ye te, imbi Ba Timiasi, (akumunge pulumu Timiasi malo,) aulke alselsena molopa yamboma “Kou mone siei.” nimbe mawa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kolea Nasarete ye Yesusi omba purumu mele pilipelie mongo keri lerimu yemo yuni pulu monjipe tondolo ru nimbe walsipelie nimbendo: “Yesusi, ⸤ye nomi kingi⸥ Depisini kalopa lirimu yemo,* na kondo koloi!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yambo aisilini yu iri toko “Nu ungu naa nili taka lelko moloi!” niringi. Nakolo yuni paa tondolo ru nimbe walsipelie nimbendo: “Depisini kalopa lirimu yemo, na kondo koloi!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesusi we angilipelie “Yu opili niei.” nirimu. Aku nirimuna ene mongo keri lerimu yemo walsikulie ningindu: “Yuni “Nu oi.” nikimu kene konopu wayongo siku ola angilku ongo pui.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yu popenge tepa ola pakorumu wale pakolimu kulupe ola angilipe Yesusi molorumuna orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesusini yundu nimbendo: “Nane nu nambe teambo konopu lekenoye?” nirimu kinie mongo keri lerimu yemone nimbendo: “Raponai,* na mongone melema kanambo nanga mongotolo teko peanga tenjeni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesusini nimbendo: “‘Nane nunge mongotolo kapola tenjimbu.’ konopu lenumunge nu umbu mongo kapola angilkimu kene pui.” nirimu. Yesusini aku nirimu kinie yu tamburembu mongotolo peanga lerimu, melema kanopalie, Yesusi purumu aulkena lombili purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","⸤Yesusi kinie yu lombili andolime kinie⸥ ene kolea aili Jerusalleme nondoko ongo, ma pangi te ‘Ma Pangi Unju Ollipi Ponie’ nili akuna lemo kolea kanga talo, Betepasi kinie Betanitolonga oringi. Kanu kinie Yesusini yu lombili andoli ye talo lipe mundupelie,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","eltendo nimbendo: “Ne kolea kanga kanokombelena pukululie kongi dongi walo te, yambo te yunge bulu mingine walsikale kepe naa molopa andorumumu ka teko panjingímu ne sukundu molomba kanongele, kanumu puku posiku yando mengo wangili pale. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Posingilí teko molongele kinie yambo tene eltendo “Aku nambemuna tekembeleye?” nimu liemo eltene i siku niengili: “Ailimu* yu ‘Dongimuni mepili.’ nimuna ombo likimbulu. Yu dongi walomo altopa nondopa yando lipe mundumbe.” niengili.” nimbe elte lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lipe mundurumu yetolo pukulu, kongi dongi walo te, ulke kerepuluna ka teko panjiringimu kanokololie kongi kanumu puku posiringili. Aku siku tengele teringili kanokolie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","akuna angiliringi yambo marene eltendo “Kongi dongi walomo nambemuna posikimbiliye?” ningu walsiku piliringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","eltene, Yesusini ‘i siku i siku niengili.’ nirimu mele niringili kinie “Kapola, ⸤dongi walomo⸥ mengo pangili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kanu kinie eltene kongi dongi walomo Yesusi molorumuna mengo ongololie, enene enenga mulu wambalema kulku dongimunge bulu mingine ola pauwe toringi kinie Yesusi kanuna ola molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yambo aisilini enenga mulu wambalema kulku yu ombá aulkena pauwe toliku puku, marene unju kipiyala poniena puku kipiyala gomo langoko liku yu ombá aulkena pauwe toliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kumbi lelko puringi yambomane kepe akilku puringi yambomane kepe naka lelko unju ambololiku pukulie ningindu: “‘Yunge imbi ola molopili.’ niemili! ‘Pulu Ye Yawene lipe mundurumuna yunge kongonomo tenjimbe okomo yemo* molopa konjipili!’** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Olionga anda kolepa ye nomi kingi Depisi⸤ni kalopa lirimu yemo⸥ ye nomi kingi molomba tekemo yemo* Pulu Yemone tepa konjipe ‘Yu tondolo pupili.’ nipili. Mulu koleana ola yu imbi ola molopili!”** niliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kanu kinie Yesusi Jerusalleme suku pupelie Pulu Yemo popo toko kaloringi ulke tembelena pupe akuna suku ⸤teko moloringi uluma⸥ pali kanorumu, nakolo kolea ipu lerimuna kanopalie ⸤‘Isili ou ulu te naa teambo.’ nimbe⸥ yu lombili andoli ye engaki rurepo kinie ⸤Jerusalleme⸥ ulsukundu puku, kolea kanga Betani ⸤pengé⸥ puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ipulueli ou ⸤Jerusalleme nondopa lerimu⸥ kolea kanga Betani munduku kelkolie ⸤kelko Jerusalleme pungí puringi kinie⸥ Yesusi yu engele terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kanu kinie yu unju piki te gomo tepa angilirimumu sulu tepa kanopalie ‘Mongo te tomunje.’ nimbe nondopa pupe kanorumu nakolo, piki mongo torumu walemo ou wendo naa orumumunge unju mongo topa te naa perimu, gomoma mindi terimu kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","⸤Gomo mindi terimuna⸥ kanopalie “Nu altoko yambomane nonge mongo te naa tani!” nirimu. Aku nirimumu yu lombili andolimene piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalleme kamu oringi kinie Yesusi yu Pulu Yemo popo toko kaloringi ulke tembelena ⸤“Juda yambo naa molemele yamboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ suku pupe kanopalie akuna melema makete teko moloringi yamboma kinie, melema topo toko liku moloringi yamboma kinie, akuma kanopalie ene pali topa makoropa, kou mone lupe lupema alowa teko anju siringi yambomanga poloma kinie, kera waembono makete teko manie moloringi poloma kinie, lipe topele topa, topa bulu balu sipelie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","yambomando nimbendo: “Yamboma kou mone lingí makete tenge melema kolea tenga lupe makete tenge pungindu ulke tembele palana naa pangi. ⸤Anekale teko pangi.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ene mane sipelie nimbendo: “Pulu Yemonga bokuna ungu te i sipe nilimo: ‘Yambomane nanga ulkemondo “Koleamanga pali yambo talapemane* Pulu Yemo kinie ungu nilimolo ulkemo.” ningí.’** kanumu ene naa pilimeleye? Ungu aku sipe molemo nakolo enene i ulkemo ‘wa nolemele yamboma lopi teko molemele ulkemo’ mele*** ningu pilkulie aku siku telemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesusini aku nirimuna pilkulie Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* ene yu toko konjingí aulke te kororingi. We yamboma yuni mane sirimu mele pilkulie mini wale munduringine kanokolie kanu Juda yambomanga ye ailimene yu pipili kolko yu toko konjingí aulke te kororingi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pe ipupini, kolea kala tomba terimu kinie ⸤Jerusalleme⸥ ulsu pupe ⸤tenga* pepurumu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ipulueli ou, ⸤unju piki angilirimu koleana⸥ ongo pukulie kanu unju pikimu kamu pulu pali kolorumu kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aku sipe terimu mele Pitane kanopalie ⸤Yesusini unjumundu bonongokondo nirimu mele⸥ kelepa pilipelie yundu nimbendo: “Rapai,* kána! I unju piki nuni ⸤bonongo⸥ iri tonumu ⸤walsikale⸥ kolomu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesusini pundu topa nimbendo: “Pulu Yemone nanga ungumu sike pilimbe⸤monga nimbú mele ‘Paa sike wendo ombá.’ ningu⸥ tondolo munduku piliengi! ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nane ene paa sike nimbu sikirumu: Yambo tene ‘nane nimbú mele paa sike wendo ombá.’ nimbe konopu talo tepa naa pepili ne ma pangimundu “Ungú toko nomu kusana sukundu pui!” nimbé kinie yu nimbé mele paa sike wendo ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Akumunge ene i sipu nimbu siembo: ‘Olio ⸤Pulu Yemone paa sike lipe taponjimbemonga ‘Teamili.’ nimulú mele sike manda aku sipu temolo.’ molo ‘Nimulú kinie sike aku sipe wendo ombá.’ ningu⸥ tondolo munduku pilkulie Pulu Yemo kinie ungu ningu mawa tenge mele pali Pulu Yemone sike tenjimbemonga kanu uluma sike wendo ombá.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“‘Ulu pulu keri temuluma olionga Lapa, mulu koleana molemomone ‘We manie pupili, siye kolambo.’ nipili.’ ningu, Pulu Yemo kinie ungu ningu angilkulie yambomane ene teko kenjingímunge konopu keri panjiku molonge uluma ‘We manie pupili. Siye kolamili.’ niengila.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Nakolo yambomane ene teko kenjingí uluma ‘We manie pupili.’ ningu siye naa kolongi liemo enenga Lapa, mulu koleana molemomone kepe enene ulu pulu keri tengema ‘Manie pupili.’ naa la nimbe siye naa la kolomba.)” * nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalleme altoko oringi kinie Yesusi yu ulke tembelena suku andorumu kinie ye mare, Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, Juda yambomanga tapu yema kinie,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ene ongo yu walsiku pilkulie ningindu: “Nu namba nambolka nambamo likulie i kongonomo telenoye? Naene i kongonomo ‘Tepui.’ nimbe nu nambamo sipe lipe mundurumuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesusini enendo pundu topa nimbendo: “Nane ene ungu te walsipu piliembola. Pe nane ene walsimbu mele na sumbi siku pundu toko níngi liemo ‘Na i kongonomo teambo.’ nimbe namba sirimumunge pulumu ene nimbu simbula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","⸤Nane i sipu ene walsipu pilkiru:⸥ Ou ⸤No Linjili⸥ Jono omba yamboma no linjirimu kinie yu mulu koleana molemo yemonga kongonomo tenjimbendo yamboma no linjirimu molo ya mana yambomanga kongonomo tenjimbendo yamboma no linjirimuye? ⸤Naene “Tei.” nirimuna terimuye?⸥ Ningu siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","⸤Yuni aku sipe walsirimu mele pilkulie⸥ enene eneno kerepali ningulie ningindu: “Yuni walsikimu mele olione pundu topo, ‘⸤Jono⸥ yu mulu koleana ⸤molemo yemonga kongono tenjimbendo yamboma no linjirimu⸥.’ nímulu liemo yuni oliondo nimbendo: ‘Aku liemo ene Jonone nirimu ungumu nambemuna ‘I ungumu sike.’ ningu naa pilku liringiye?’ nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Molo olione nimulundu: ‘Yu mana yambomanga ⸤kongono tenjimbendo yamboma no linjirimu⸥.’ nímulu liemo we yambomane olio tongenje.” ningu aku siku ningindu pipili koloringi. “We yambomane ‘⸤No Linjili⸥ Jono yu paa sike Pulu Yemone ungu umbu tonjirimumu pilipe yamboma nimbe sirimu ye te molorumu.’* ningu pilimele kene olio nambe temolonje?” ningu eneno aku siku kerepali niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","⸤Eneno aku siku anju yando kerepali ningulie⸥, Yesusindu pundu toko ningindu: “⸤Nuni walsikinu mele⸥ olio naa pilkimulu.” niringi. Aku siku niringi kinie pilipelie Yesusini enendo nimbendo: “Kapola. ⸤Nane ene walsikiru ungumunge ungu te pundu toko naa nikimilimunge⸥ enene na walsikimili ungumunge ungu te pundu topo, nando i kongonomo ‘Tepui.’ nimbe na lipe mundupe namba sirimu yemonga imbimu ene naa nimbu simbula.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Walse Yesusini ⸤Juda yambomanga ye ailimendo⸥ ungu ikuma ene topa simbendo ungu iku te i sipe torumu: “Ye tene unju waene ponie tepalie pala terimu. Poniena sukundu loyekolo akupe waene no ingi tepa monjimbendo tepa mimi tepalie nirimumuni, pe ponie nokonge ulke takaye te polo kulupe ola takorumu. Ye mare kanopa lipelie enendo nimbendo: “Nanga poniemo tapu tenjiku unju mongoma inie toko nokonjengi. Pe waene mongo polo tomba kinie unju mongoma moke tepo, kongono tenjingí mele mare ene liengi, mare na liembo.” nimbe kanu poniemo ene sipelie yu kolea paa suluringe pupe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kanu kinie pe waene mongo polo tomba terimu kinie ponie pulu yemone yunge kendemande ye te “Nanga waene mongo siengi puku liku menjiku wani pui.” nimbe ponie nokoringi yema moloringine lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nakolo kendemande yemo ⸤orumu kinie⸥ ponie nokoli yemane yu ambolko likulie yu wale aisili kopene toko waene mongo mare naa siku yando we liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Altopa ponie pulu yemone kendemande ye te lipe ⸤“Nanga waene mongo linjipui.” nimbe lipe⸥ mundurumu. Nakolo yu ⸤orumu kinie⸥ ponie nokoli yemane yu ambolko likulie toko pengemo toko siku yu teko kenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Altopa ponie pulu yemone kendemande ye te lipe mundurumu kinie enene yu toko konjiringi. Kendemande ye mare aisili mele lipe mundurumumanga mare wale aisili kopene toko, mare toko konjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kanu kinie ponie pulu yemo yunge ye telu mindi molorumu, yunge malo, yu konopu monjirimu kangomo. Yuni ⸤konopuni pilipelie⸥ ‘Nanga kangomo pipili kolko liku ai siku, yu waene mongo mare singí.’ konopu lepalie yunge malomo kamu lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nakolo ponie nokoli yemane ponie pulu yemonga malo ombá orumu kanokolie enene eneno ningindu: “Andi okomo yemo pe lapanga melema limbe yemo okomo. Yu topo konjipu i poniemo olio kamu liemili.” ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","enene yu ambolko liku toko konjiku ⸤yunge onomo⸥ poniena toko ulsu munduringi.”* ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","⸤Yesusini ungu iku akumu topa pora simbendo kanu Juda yambomanga ye ailimendo walsipelie nimbendo:⸥ “Ponie nokoli yemane aku teringimunge pe ponie pulu yemone ene kinie nambolka uluri tembaye? Yu omba kanu ye kerime topa konjipelie ‘Ye marene lupe poniemo nokonjengi.’ nimbe lipe simbe.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","⸤Yesusini Pulu Yemonga Juda yamboma nokoringi yemane yu toko konjingí mele pilipelie* enendo nimbendo:⸥ “Pulu Yemonga bokuna sukundu ungu te kanoko naa pilimeleye? ⸤Aku ungumu i sipe mele:⸥ ‘Ulke takoringi yemane kanoko keri kanoko toko ele teringi kou kanumu kinié kelepa ulke simu mele ulke enge sinjili kou aili peangamo.’** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","‘Ailimuni aku ulumu terimu olione kanopo paa peanga kanolemolo.’* nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","⸤Kanu Juda yambomanga ye ailime⸥ enene Yesusini ungu iku torumu kanumu pilkulie enene yu tonge teko moloringi mele yuni nirimu pilkulie enene yu ka singí teringi nakolo kanu ye ailimene we yamboma pipili kolkolie yu liku ka naa siringi. Yu munduku kelkolie anju puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pe walse ⸤Juda yambomanga ye ailimene⸥* Parisi ye mare kinie** ye nomi kingi Erotenga talape ye mare kinie liku, “‘Yesusini ungu te nimbe kenjipili.’ ningu i siku i siku yundu niengi.” ningu Yesusi molorumuna liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Liku munduringi yemane Yesusi molorumuna ongo yundu ningindu: “Ungu Mane Silimu, olio pilimolo, ‘nuni ungu sikema mindi ningu, nu yambo teluringe kepe konopu kimbu naa siku, yamboma pipili naa kolko enendo pali ungu telu siku kapola kapola ningu siku, Pulu Yemone “Teai.” nilimo uluma paa sike unguma mane siku, aku siku teleno.’ konopu lemolo. ⸤Aku siku teko molenomonga nu nambolka konopu lekenoye?⸥ Olione Romo Gapomano Ye Paa Aili Kumbine ‘Sisa’ nilimu kou takisi tomulu liemo kapola molo moloye? Yu ⸤kou takisi⸥ simulúne naa simulúne? Pulu Yemone akumundu ungu mane sirimu ungu mane nambolkamo pelemoye?* Ningu si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nakolo Yesusini, ene topele mapele toli yema* molemele mele pilipelie enendo nimbendo: “‘Yuni nimbe kenjipili.’ ningu nambemuna na manda manjiku kolo toko walsikimiliye?** ⸤Takisi tolemele⸥ kou mongo te kanambo, mengo ongo siei.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","enene yu molorumuna te mengo ongo yu siringi. Kanu kinie Yesusini enendo nimbendo: “I kouna naenga kumbikeremo kinie imbimu kinie molemoye?” nirimu. Enene yundu ningindu: “Romo Gapomano Ye Paa Aili Kumbine Sisamonga kumbikeremo kinie imbimu kinie molemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kanu kinie yuni enendo nimbendo: “⸤Kou monemo Sisamonga⸥ kene Sisamonga melema Sisamo yuyu siku, Pulu Yemonga melema Pulu Yemo yuyu siei.” nirimu. Yuni aku sipe ⸤paa sumbi sipe⸥ nirimu mele pilkulie ⸤‘Yu paa pilipe konginjili pelemo yemo lepamo.’ ningu pilkulie⸥ konopu aisili liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","⸤Kanu yema Yesusi kinie kou takisi toli ungumu ningu pora siringi kinie⸥ pe Sadusi ye mare* Yesusi molorumuna oringi. Sadusi yema ene ‘Pulu Yemone pe kolemele yamboma topa naa makinjimbe, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Aku Sadusi yema ongo Yesusi walsiku pilkulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ungu Mane Silimu, ⸤Pulu Yemonga ungu manema olio sirimu ye⸥ Mosisini ungu mane sipelie nimbendo: “Ambo limbe ye te ambolango naa membalie ambomo we molopili kolomba kinie kanu yemo yunge angenu molombamone yunge ambo wayemo lipe angenu lipe taponjipe ambolango menjipili.”* nirimu aku sipe nimbe bokuna torumu molemo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","⸤Aku ungu manemonga ulu te olionga ye mare kinie wendo orumu mele nu walsipu piliemili.⸥ “Angenupili yepoko pakara moloringi. Komomo ambo lipe ambolango te naa membalie kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","⸤Ambolango te naa molopili kolorumuna⸥ yunge bulkundu angenumuni ⸤yunge angenu kolorumumunge ambolango ‘Menjembo.’ nimbe⸥ ambo wayemo kelepa lirimu. Yu ambolango te naa menjipelie yu we kolorumula. Yunge angenu bulkundumuni kanu ambomo lirimula nakolo yu kepe we kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aku teliku pukulie ye yepoko pakara pali ambolango telu kepe naa mengolie kolko pora siringi kinie akiliomo we kolorumula. Pe ambomo yu kolorumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Akumunge, kolemele yamboma pe lomboroko ola molonge kinie kanu ambomo ye yepoko pakara pali ya mana liringine ambomo yu ye paa naenga menu molombaye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesusini enendo pundu topa nimbendo: “Ene Pulu Yemonga bokuna ungu molemoma kinie, Pulu Yemo kinie tondolo pelemo mele kinie, naa pilku lou lemelemonga ⸤yamboma pe tengemondo nikimili mele pilku sunduku kolo tokomele⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lomboroko ola molonge yambomanga yema ambo naa liku, amboma ye naa puku, aku paa naa tenge. Mulu koleana molemele angelloma molemele mele aku siku molonge. ⸤Angellomane mana yamboma telemele mele naa telemele kanumu.⸥ Aku tengemonga ⸤‘Ene Pulu Yemonga ungumu pilku sunduku lawa telemele.’ nikiru⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Nakolo ⸤ene Sadusimene⸥ ‘Kolemele yamboma lomboroko ola naa molonge.’ konopu lemelemonga ungu te niembola. Mosisi unju kanga tenga ⸤tepe nomba perimu tepemone unjumu naa norumu kanopalie nirimumuni⸥ akuna Pulu Yemonga ungu te wendo omba Mosisindu ungu te nirimu temanemo enene naa kanoko pilimeleye? Pulu Yemone Mosisindu nimbendo: “Na Eporayamo kinie Aisake kinie Jekopo kinie enenga Pulu Yemo molio.” nirimu.* Pulu Yemonga bokuna Mosisini torumu aku ungu molemomo naa kanoko pilimeleye? ⸤‘Enenga Pulu Yemo molorundu.’ naa nirimu. ‘Enenga Pulu Yemo molio.’ nirimu kanumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pulu Yemo yu kololi yambomanga Pulu Yemo molo; yu yambo kondemanga Pulu Yemo. Aku siku pilku sundukulie ene lou lemele.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","⸤Sadusi yema kinie Yesusi kinie⸥ aku siku kerepali ningu molangi Pulu Yemonga ungu manemanga puluma pilipe mane sirimu ye te* omba ene anju yando ungu mele teko kerepali ningu moloringi omba pilirimu. Enene ungu mare Yesusindu walsiku piliringi kinie yuni anju pundu topa nimbe konjirimu mele pilipelie ungu mane sirimu yemone Yesusindu walsipe pilipelie nimbendo: “Pulu Yemone ungu mane sirimu pelemomanga pali nambolka ungu manemo yu olandopamoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesusini pundu topa nimbendo: “Ungu mane olandopamo i sipe: ‘Isirele yamboma, pilieme! Aili Yawe olionga Pulu Yemo yu mindi Aili telumu molemo, te lupe molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Enene enenga kamelema kinie, enenga minime kinie, enenga pilipe konginjilime kinie, enenga tondolomo kinie, akumane Aili Yawe enenga Pulu Yemo manjiku tondolo munduku konopu monjengi.’* nimbe, ungu mane paa olandopamo aku sipe ⸤nimbe⸥ molemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ungu mane talo sipemo i sipe: ‘Enene eneno yu mele mele konopu monjiku enenga kangimu eneno kondo kolko nokolemele mele aku sikula pulu lemo yamboma konopu monjiku nokoko molangi.’* nimbe molemo. Aku ungu manetolonga olandopa te paa naa pelemo, molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","⸤Yesusini aku nirimu pilipelie⸥ yemone yundu nimbendo: “Ungu Mane Silimu, papu nikinumu. Nuni ninindu: “Pulu Yemo telumu mindi molemo. We te lupe naa molemo. Yu yuyu molemo.” nikinumu paa sike nikinu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‘Yu konopu monjingíndu enene enenga kamelema kinie, enenga pilipe konginjilime kinie, enenga tondolomo kinie, akumane ⸤Ailimu enenga Pulu Yemo⸥ manjiku tondolo munduku konopu monjengi.’ nimbe pelemo ungu manemo kinie ‘Ene enenga kangime eneno kondo kolemele mele yambo pulu lemoma* aku siku kondo kolangi.’ nimbe pelemo ungu manemo kinie, aku ungu manetolo temolo kinie olandopa; Pulu Yemo kongime kinie melema popo topo kalopo “Imu nu sikiru.” nilimolo akumu maniendopa.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yuni pundu topa nimbe konjirimu pilipelie Yesusini yundu nimbendo: “Nu konopu lelko molenomonga Pulu Yemone ye nomi kingi molopa nokolemo yambo talapena sukundu* nondoko puni tekeno lemo.” nirimu. Kanu kinie ⸤Yesusindu walsiku piliringi unguma pali yuni pundu topa anju nimbe konjirimu pilkulie⸥ altoko yu ungu te walsiku pilingindu pipili kolko naa walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena suku yamboma ungu mane sipe molorumu. Mane sipe molopalie ungu te nimbendo: “Pulu Yemonga ungu manemanga puluma pilku mane sili yemane ningindu: “Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu ⸤ye nomi kingi⸥ Depisini kalopa limbe yemo molomba.” nilimele akumu nambemuna “Yu Depisini kalopa limbe yemo molomba.” nilimeleye?* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","⸤Aku nilimele yemane⸥ Depisi yuni yuyu ⸤kanu yemondo nirimu mele naa pilimelenje.⸥ Mini Kake Telimu Depisinge konopuna molorumu kinie Depisi yuni ⸤ye Kirasimu molomba mele⸥ nimbendo: “Aili ⸤Pulu Ye Yawene⸥ nanga Ailimundu nimbendo: “‘Nunge opa touma nuni nokani.’ nimbu, pe ene topo manie mundunjimbu kene isili ou nu ⸤na kinie pea tapu topolo ye nomitolo molopolo melema nokambili⸥ nanga ki umbukundu ongo molani.” nirimu.”* nimbe Depisini nirimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depisini ⸤ye nomi Kirasimu⸥ yundu “Nu nanga Ailimu.” nirimu. Pe enene “Yu Depisini kalopa limbe yemo ⸤mindi⸥ molomba.” nambe teko pilkulie nilimeleye?” nirimu. We yambo aisili maku toko moloringime Yesusini nirimu unguma pilkulie konopu aili teko siku pilku moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesusini ungu mane sipe molopalie nirimumuni ⸤lepi lepi topa⸥ ungu te nimbendo: “Enene Pulu Yemonga ungu manemanga puluma pilku mane sili yema* mimi siku kanoko konjiku ⸤enene telemele mele manda lelko naa teko⸥ molayo. ⸤‘Yambomane olio kanoko “Ye peangama” niengi.’ ningu⸥ kanu yemane wale pakoli paa sulu peangama, ⸤ye nomime pakolemele mele,⸥ pakoko andolemele. Yamboma maku toko molemele koleamanga mongo kenge teko andonge kinie ‘We yambomane olio kapi niengi.’ ningu pilkulie konopu siku pilku andoko molemelela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yamboma maku toko Pulu Yemonga ungumu pilimele ulkemanga sukundu pukulie manie molongendo ye ailime molemele polo peanga akuna mendo puku polo akuna konopu siku molemelela.* Yambomane langi nongo yambomando “Namili wai.” nilimele kinie kanu yema ongolie ye ailimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Yema kolemele kinie enene kanu yemanga ambo wayema toko makoroko mundukulie ulkema ‘Olionga’ ningu we limele. Pulu Yemo kinie ungu ningindu ningu sulu munduku we kolo toko nilimele.* Pulu Yemone we yamboma ulu pulu keri telemelemonga ene sike mongo lipe simbe nakolo ya ye nikirumane aku uluma telemelemonga Pulu Yemone aku yema mongo aili tepa lipe simbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesusi ⸤Pulu Yemo popo toko kaloringi ulke tembele⸥ kerepuluna ulke tembelena sukundu kongono tenge kou monema munduringi unju ketena nondopa manie molopalie yambo aisilini aku unju ketena kou mone ongo munduringi mele kanopa molorumu. Kanopa molorumu kinie yambo kamakomane kou mone aisili ongo munduringi kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","⸤Aku sipe kanopa molorumu kinie⸥ ambo waye paa koropa te omba yu kou kololi talo mindi mundurumu. Kanu kou kololitolo lipe tere lepa wane toya mele mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","⸤Ambo wayemone aku terimu kanopalie⸥ Yesusini yu lombili andolime walsipe “Wai.” nimbelie enendo nimbendo: “Nane enendo paa sike nimbu sikirumu: Andi ambo waye koropamo yuni kou mone mundukumumu paa olandopa mele mundukumu, we mundukumilime maniendopa mele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ene kou mone aisili nosilimelemanga layetolo mindi ongo mundukumili. Nakolo ambo wayemo kou mone te paa naa nosilimo. Yunge kou layetolo nosimutolo pali memba omba mundumu. Langi nombá kepe te naa nosilimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kanu kinie Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena ulsu pumbe purumu kinie yu lombili andolimenga tene yundu nimbendo: “Ungu Mane Silimu, tembelemonga ulke lupe lupema kinie, ulkema takoringi kou peanga lupe lupema kanoi.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","⸤Aku nirimu kinie⸥ Yesusini yundu nimbendo: “Ya ⸤tembelemonga⸥ ulke lupe lupe peanga angilimo kanokomelema, pe ⸤walse ya kolea aili Jerusalleme yamboma mindili nonge walemo wendo ombá kinie⸥ i tembelemonga ulkema pali tekisikulie kouma pali toko manie mundungí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kanu kinie yu ma pangi Unju Ollipi Poniena ola pupe ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena wilkindu manie molorumuna we yamboma naa molangi ⸤yu lombili andoli ye mare⸥ Pita keme, Jemisi keme, Jono keme, Enderu keme ene ongo, ene eneno molkolie yundu walsiku pilkulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nuni nikinu mele tewale wendo ombáye? Pe nuni i nikinu uluma nondopa wendo ombándo ou nambolka uluri temba kinie olio kanopolie ‘Uluma i wendo ombá tepamo.’ nimbu pilimulúye? Olio ningu si.” ningu walsiringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","yuni enendo nimbendo: “⸤Kanu uluma wendo ombámonga ungu mare⸥ yambomane ene kolo toko singí kene kanoko konjiku molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ye aisili ongo na molio mele yu mele mele kolo toko ningindu: “⸤Pulu Yemone ‘Nanga yamboma nokopa konjimbe lipu mundumbu.’ nimbe mako torumu ye nomi Kirasi⸥ akumu na.” ningulie aku siku kolo toko singí kene kanoko konjiku molangi. Yambo aisilini kanu yemanga unguma pilku liku “Sike nikimili.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kolea marenga opa aili teko tenge mele pilku, ‘Opali talu opa aili i sipe i sipe wendo ombá.’ ningu we ningí kinie pilkulie mini wale naa mundengi. Opa tengema kinie aku uluma Pulu Yemone ‘Ou wendo opili. Laye pe mele ya ma koleamo pora nimbé.’ nimbe, nimbe panjirimumunge aku uluma sike wendo ombá nakolo aku kinie mulu matolo ou naa pora nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","⸤Mulu ma pora nimbé walemo ou wendo naa opili umbuni aili mare wendo ombá.⸥ yambo talape aili te kinie talape aili te kinie opa tekolo, ye nomi kingi marenga talapema kinie marenga talapema kinie opa tenge. Ya ma kolea tenga tenga ma jimi jimi tepa, engele lepa, aku sipe temba. Ambo tene ambolango kokele kanopa limbendo ou mini topa mindili nolemo mele, mulu ma pora nimbé walemo kokele wendo ombándo umbuni lupe lupe aku sipema ou wendo ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“⸤Kanu uluma wendo ombá walemanga⸥ yamboma mimi siku kanangi. Enene ⸤‘Na lombili andoli yamboma mindili nongo, kolangi.’ ningu,⸥ ene ⸤mare liku ambolkolie⸥ kanjollomanga makumanga mengo puku kote tenjiku, ene ⸤mare⸥ Juda yamboma maku toko Pulu Yemonga ungumu pilimele ulkemanga liku mengo puku kopene tongela. Ene nanga yamboma molongemonga ene ⸤mare ka siku⸥ gapomano ye ailime kinie ye nomi kingime kinie molongena ⸤kote tenjingindu⸥ mengo pungíla. Aku siku tenge kene ene eneno kanoko konjiku molayo. ⸤Nakolo kote tenjingí kinie kotena angilkulie kanu yema kinie kanu yema nokonge ye nomime kinie⸥ enene ‘Nanga ungumu piliengi!’ ningu ene ningu singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Temane peangamo ‘Yamboma pali piliengi!’ ningu koleamanga pali andoko ou ningu singí ⸤kinie, pe mulu ma pora nimbé walemo kamu wendo ombá⸥..* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ene ka siku kote tenjingí kinie ou ‘Kotena nambolka unguri nimulúnje? Olio ungu te walsiku pilingí kinie nambolka unguri pundu topo nimulúnje?’ ningu mini wale naa mundengi. Ene ungu ningíme eneno pilkulie naa ningí. Mini Kake Telimuni enenga kerena molopalie nimbe simbe unguma enene anju ningí kene aku tenge enamonga ene ungu ningí mele pilkulie aku siku ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“⸤Aku walemanga⸥ angenuni yunge kandi angenu ⸤nanga yambo molombamonga⸥ ‘Kolopili toko konjengi.’ nimbe kote tenjimbe. Lapane yunge kandi ambolangoma akula temba. Ambolangomane kepe enenga kandi anupili lapali kinie mumindili kolko kotena mengo puku “Toko konjengi.” ningíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nanga yamboma molongemonga yambomane pali ene kinie konopu keri panjingí, nakolo na munduku naa kelko walema pora naa nipili tondolo munduku molonge yamboma Pulu Yemone lipe taponjipe ‘Mindili nonge koleana naa puku pea molopo konjipu mindi pamili.’ nimbé.” * ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(⸤Na i bokumu tokoro yemone⸥ ene bokumu kanokomele yambomando ungu te niembo: ‘⸤Yesusini nirimu⸥ ungumu inie maniekondo molemo akumu ene imbi kanokomele yambomane ungu pulumu paa pilku konjengi.’ ⸤nikiru: Yesusini nimbendo:⸥ ) “⸤Yambo⸥ tepa pipili kondoli mele paa kerimu ⸤ulke tembelena suku Pulu Yemonga Ulke Suluminia Kake Teline Pulu Yemone⸥ “We yamboma naa pangi!” nimbe mi tolemona* yu manda naa pupe angilimbe, nakolo walse akuna angilipelie kolea akumu paa tepa kalaro monjimbe. Aku melemo akuna ⸤wendo omba⸥ angilimbe kanokolie** ⸤‘Umbuni ailime wendo ombá tekemo.’ ningu pilku⸥ kolea Judia poropinji koleamanga molonge yamboma ⸤enenga koleama munduku kelko⸥ ma pangi lembamanga kowa pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yambo te ulke imuna ola molopili ⸤aku sipe ulu te wendo ombá kinie kanopalie kowa pumbendo⸥ manie omba ‘Melema lipu membo pambo.’ nimbe ulkena sukundu manda naa pupili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yambo te poniena molopalie ⸤‘Kowa pambo.’ nimbe⸥ kelepa ulkendo pupe yunge ali wale sulumu naa lipili. ⸤Sumbi siku kowa mindi pangi.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aku sipe wendo ombá walemonga ambo ambolango monjingíme kinie, ambo ambolango ame singíme kinie, ⸤ene manda lkisiku kowa naa pungímunge⸥ ene kinie paa umbuni wendo ombamonga ene kondo tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Pulu Yemondo mawa tekolie, ‘Ali telemo olimenga kanu umbunime wendo naa opili.’ nieyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kanu walemanga umbuni paa ailime wendo ombá, Pulu Yemone ou mulu ma pulu monjipe terimu kinie kepe, yandopa kinié kepe umbuni aku sipe te wendo naa orumu. Pe kepe aku sipe umbuni ailime naa wendo ombála. Akumunge aku siku Pulu Yemo kinie mawa teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","⸤Kanu umbunime wendo ombá kinie⸥ Aili ⸤Pulu Yemo⸥ ne ‘Nondopa pora nipili.’ nimbe ou naa nimbe panjilkenje yamboma pali kolemelka. Nakolo Pulu Yemone mako topa ‘Nanga yamboma molangi.’ nirimu yamboma ‘Naa kolangi.’ nimbe ‘Umbuni wale akuma nondopa pora nipili.’ nimbe, nimbe panjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kanu umbuni omba pemba walemanga yambo marene ningindu: “Kanai! Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ ou nimbe mako torumu ye nomi Kirasimu ya omba molemo.” ningí molo “Nena omba molemo.” ningí kinie enenga unguma naa pilku, ‘Sike nikimili.’ ningu naa piliengi! ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ye mare ongolie kolo toko ningindu: “Pulu Yemone mako torumu ye nomi Kirasimu na.” ningí, molo kolo tokolie “Pulu Yemone ungu umbu tonjimuma pilipulie ombo nimbu sikimulu.” ningí. ‘Yamboma pali, Pulu Yemone ‘Nanga yamboma molangi.’ nimbe mako torumu yambomane kepe lipu lou sipu, nikimulu mele ‘Sike.’ ningu tondolo munduku piliengi!’ ningu Pulu Yemone mindi ulu tondolo kapola telemoma mele manda lelko ulu tondolo lupe lupema tenge. Nakolo Pulu Yemonga yamboma aku siku kondi tonge kinie enenga unguma naa pilku, liku su singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akumunge, pe ulu akuma wendo ombá mele ‘Ene ou piliengi!’ nimbu ya nimbu sikiru mele pilkulie kanoko konjiku molai!” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kanu walemanga aku mindili nonge nikiru uluma wendo ombá kinie pe ⸤ulu lupe lupe mare wendo ombála. Aku uluma i sipe:⸥ ‘Kolea tangombando ena pa telemo mele naa tepa, sumbulu topa, oli ipulueli pa telemo mele naa tepa, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kombukandipime muluna manie omba, muluna angilimo mele tondoloma* lope lope tepa anju yando pupe, aku sipe ulu lupe lupema wendo ombá.’** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aku temba walemonga Manie Omba Mana Ye Au Lerimu Yemo tondolo pulimu kinie, pa aili tepa telimu kinie kupe tenga suku molopa kamu manie ombá* yambomane kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ombalie yuni yunge angelloma lipe mundumbe kinie ene winju mendo anju yando mulu ma koleamanga pali puku Pulu Yemone ‘Nanga yamboma molangi.’ nimbe ou mako torumu yamboma sukundu sukundu lingí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Unju pikimuni telemo aku sipe ungu iku mele pelemo kene pilkulie ungu pulumu piliei. Unju piki kuku topa gomo tolemo kinie kanokolie ‘Kinié ena temba walemo wendo ombá tekemo lemo.’ ningu pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aku sipela, i ulu “Wendo ombá.” nikiruma sike wendo ombá kinie kanokolie ningímuni ‘Yu paa sike nondopa ombá tekemo. Yu paa kamu okomo.’ ningu pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Nane enendo paa sike nimbu sikirumu: Kinié molemele yamboma ou naa kolangi i “Wendo ombá.” nikiru uluma pali wendo ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mulumu kinie mamo kinie pora nimbé nakolo nanga ungu nilioma paa pora naa nimbé. ⸤Nilio mele pali paa sike wendo ombá.⸥” * ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“⸤Manie Omba Mana Ye Au Lerimu Yemo paa sike ombá⸥ nakolo yu ombá walemo naa pilimolo. Ipulueli ombáne, tangoli ombáne naa pilimolo. Mulu koleana angelloma kepe naa pilimelela. Pulu Yemonga Malo kepe naa la pilimo. Tara yuyu mindi ⸤aku walemo⸥ pilipe molemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yu kelepa ombá walemo ene naa pilimele kene yu ombá kanoko konjiku, uru naa peko (Pulu Yemo kinie ungu ningu)* molayo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yu ombá walemo i sipe: Ye te kolea marenga wale mare molomba pumbe telemo kinie yunge koleamo mundupe kelembando yunge kendemandemando “Nanga koleamo nokonjei.” nimbelie yunge kongonomo tenjingí mele ene yu mele mele moke tepa sipe ulke kerepulu nokolemo yemondo “Na walse ombó kene kanoko moloi.” nimbelie pulimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ulke pulu yemo sike ombá nakolo yu ombá walemo naa pilimele kene ‘Yu ombá.’ ningu kanoko molayo. Ipupini ombá, molo ai burumi ombá, molo kolea tangombando kera gulta ko tolemo kinie ombá, molo ipulueli ou ombánje, ene naa pilimele kene ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","‘ ‘Na uru peambo walsikale yu lipe sinjipe omba na kanomba.’ ningu, kanoko molangi.’ nimbu nikiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Enendo i nikiru mele yambomando pali nikirula, ‘⸤‘Ombá.’ ningu⸥ kanoko molangi.’ nimbu nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","⸤Juda yambomane ponie tenga tenga kolea aili Jerusalleme ongo akuna suku⸥ Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele* pilku, Pillawa Akoli Mele Isi Naa Munduku Pillawa We Kalko Noringi Walemo* talu mele wendo ombándo, kinié mele Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,** enene Yesusi kiyongo ningu ka siku tonge aulke te koroko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akumundu ungu mele tekolie ningindu: “⸤Nondopo tamili,⸥ nakolo Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu Mele ⸤Pilimolo⸥ Walemanga ⸤‘uluma tepo molamili.’ ningu⸥ yambo aisili ya Jerusalleme ongo maku toko molongemonga yu isili ou tomolo kinie enene olio kinie mumindili kolko opa tenge kene isili ou naa topo, keleamili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kolea kanga Betani ye te ou kuru laká nombalie kelerimu ye te,* imbi lelko “Ye Kuru Laká Noli Saimono” niringi kanumunge ulkena Yesusi pupe langi nomba molopili ambo te kopongo wele ma mingi paa peanga te yu molorumuna memba orumu. Kanu wele paa mune tolimunge kou mone paa aili tepa purumu. Akumu memba ombalie Yesusi langi noli polo molorumuna memba omba ⸤‘Yu tepo konjembo.’ nimbe⸥ mingimu kako topa welemo pengena ondo lenjirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yuni aku terimu kinie kanokolie kanuna moloringimenga marene konopu keri panjikulie anju yando eneno ningindu: “Aku kopongo welemo nambemuna we tepa kenjikimuye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aku welemo kou mone limelkanje kou aisili, kou mongo wane tausini mele, lipulie yambo koropama moke tepo silimelka.” ningu ambomo tondolo munduku iri toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","⸤Enene ambomondo aku siku niringi pilipelie⸥ Yesusini enendo nimbendo: “I ambomo kinie nambemuna ungu aisili nikimiliye? Yuni na kinie ulu peanga te temu kene yu kinie ungu aisili naa ningu munduku keleangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yambo koropama ene kinie alieli molonge kene ‘Ene lipu taponjemili.’ ningí walemanga pali ene manda liku taponjingí nakolo na ene kinie alieli naa molombo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ambomone ‘Manda tembo.’ konopu lemu mele temu. Na ono tengemonga yuni isili ou i wele mune tolimu nanga kangine omba ondo lenjimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nane enendo paa sike nimbu sikirumu: Ma koleamanga pali ⸤nanga⸥ temane peangamo andoko toko singí kinie i ambomone kinié temu temanemo kepe ‘Yambomane pilkulie ‘Yuni tepa konjirimu.’ ningu piliengi!’ ningulie aku temanemo toko singíla.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kanu kinie ⸤Yesusi yu lombili andoli⸥ ye rurepo akumanga ye te, Judasi Isikeriote, ‘Pulu Yemo popo tonjiringi ye ailimene ka singí aulkemo yuni akisinjembo.’ nimbe ene moloringine pupe, temba mele nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yuni temba mele nirimu kinie pilkulie ene konopu aili teko siku “Nu kou mone te simulú.” ningu, ningu panjiringi. Kanu kinie yu Yesusi ene lipe simbe mele aulkemo koropa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Koromonga* pulu pulu walemo wendo orumu kinie Juda yambomane Pulu Yemone ou enenga anda kolepalime Naa Topa We Omba Purumu mele pilingindu kongi sipisipi walo te toko nonge mele pilkulie* niringimuni, Yesusi lombili andoli yema yu molorumuna ongo walsiku pilkulie ningindu: “Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu mele pilimulundu kongi sipisipi walo te kinié nonimu kolea tena pupu tepo mimi tepamili konopu lekenoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aku siku ningu walsiringi kinie yuni yu lombili andoli talo lipe mundupelie nimbendo: “Ne kolea aili ⸤Jerusalleme⸥* suku pukululie, ye te mingine no kolopa memba ombá aulkena puku kane kane tokololie yu lombili pangili.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yu suku pumbe ulkena ⸤suku pukululie⸥, ulke pulu yemondo ningilindu: “Ungu Mane Silimuni i sipe walsipelie nimbendo: “Na kinie na lombili andolime kinie* olione Pulu Yemone olionga anda kolepalime naa topa we omba purumu mele pilimulundu kongi sipisipi walomo tena nomoloye? Nomolo suluminiamo tena lemoye?” nimu.” niengili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aku ningilí kinie yuni elte ulkemonga olakondo suluminia aili te, akuna langi noli polo te kinie, manie molomolo poloma kinie, melema pali ou teko mimi tengi lembamo, lipe ora simbe. Aku suluminiamonga ⸤nomolo sipisipi walomo⸥ teko mimi teangili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kanu kinie yu lombili andoli ye akutolo kolea aili akumunge suku pukulu, Yesusini nirimu kanu mele ulu akuma teli lerimu kanoko lenjikululie, akuna Pulu Yemone enenga anda kolepalime naa topa we omba purumu mele pilingí kongi sipisipi walo nongemo teko mimi teko nosiringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ipupini ena pupe kolea kala torumu kinie Yesusi kinie yu lombili andoli rurepo kinie oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Langi nongo moloringi kinie Yesusini nimbendo: “Nane enendo paa sike nimbu sikirumu: Ene pea molopo langi nokomolomanga ye tene na lipe nanga opa touma simbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","⸤Aku nirimu kinie pilkulie⸥ enenga konopuna umbuni terimu pilkulie yu mele mele walsikulie ningindu: “Ailimu, nando nikinuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesusini pundu topa nimbendo: “Ene nanga ye rureponga ye te na kinie langime polo ai suku singine ola lemo te walsikale lipu nombolo yemone na lipe, opa touma anju simbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Kinié Manie Omba Mana Ye Au Lerimu Yemo kinie tenge mele koronga ou ningu panjiringi temanemo ⸤Pulu Yemonga⸥ bokuna sukundu molemo mele* sike opa toumane tenge, nakolo yu lipe opa touma simbe yemo mindili nomba paa molopa kenjimbe. Yu molopa kenjimbemonga yu anumuni naa melkanje papu. ⸤Yu mindili naa nolka.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ene langi nongo moloringi kinie Yesusini berete te lipe Pulu Yemo kinie “Ange.” nimbelie ambolopa pike lepa ⸤yu lombili andolime⸥ sipelie nimbendo: “Imu nanga kangimu ene liku ⸤nangi⸥.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pe no waene kapo te lipelie Pulu Yemo kinie “Ange.” nimbe ene sirimu kinie enene pali ⸤kanu no waenemo⸥ noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yuni nimbendo: “I ⸤no waene⸥ sikirumu nanga mememo. Pulu Yemone ⸤yu kinie yunge yamboma kinie molonge mele⸥ ungu te nimbe panjipe mi lerimu kanu ungumu* ‘Kamu wendo omba pepili.’ nimbu yambo aisilinge nimbu nanga mememo ondo lenjipulie ⸤kolombo⸥ aku mememo imu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nane enendo paa sike nimbu sikirumu: Isili ou na no waene altopo paa naa nombó. Pe mindi, Pulu Yemo ye nomi kingimu molopa nokolemo koleana* no waene kondemo kelepo nombó.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","⸤Langi nongo pora sikulie⸥ ene Pulu Yemonga konana te ningulie, pena puku ma pangi Unju Ollipi Poniena ola puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kanu kinie Yesusini lombili andolimendo nimbendo: “Pe ⸤opa toumane na kinie tengemonga kanokolie⸥ enene pali na munduku kelenge. Aku siku tenge mele Pulu Yemone ou nirimu yunge bokuna molemo kanumu. Pulu Yemone ⸤ungu iku te topalie⸥ nimbendo: “ “Kongi sipisipi tapu yemo tangi.” nimbú, yu tonge kinie sipisipime bulu balu ningí.”* nirimu, ⸤aku mele kinié wendo ombá⸥.. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","⸤Isili ou na toko konjingí kinie ene sike bulu balu ningí⸥ nakolo na lomboropo ola molopolie nimbumuni, na kumbi lepo kolea Gallillindu pumbu, ene pe akilku akuna onge kinie ⸤altopo pea molomolo⸥.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","⸤Yesusini aku sipe nirimu kinie pilipelie⸥ Pitane nimbendo: “Enene pali ‘Nu sike’ ningu tondolo munduku pilimele mele manie pumbe kinie nu munduku kelengi liemo nane nu aku sipu paa mundupu naa kelembo, paa molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesusini pundu topa nimbendo: “Nane nu paa sike nimbu sikirumu: Paa kinié ipulueli, kera gulta wale talo sipemo ou ko naa topili nuni pipili kolkolie wale yepoko nando kolo toko “Yu naeye? Na naa kanolio.” nini.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nakolo Pitane tondolo mundupe nimbendo: “Na nu kinie tapu tolembolomonga olto pea “Tomolo.” níngi liemo kepe nu “Naa kanolio.” paa naa nimbú.” nirimu. Lombili andoli ye wemane pali “ “Nu naa kanolemolo.” paa naa nimulú.” niringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","⸤Kanu kinie⸥ Yesusi kinie yu lombili andoli yema kinie kolea ‘Gesemani’ niline puringi. Akuna puringi kinie yuni enendo nimbendo: “Na Pulu Yemo kinie ungu nipukuru kene ene ya molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aku nimbelie Pita keme Jemisi keme Jono keme lipe memba pupelie ⸤‘Na teko kenjingí ulumu paa nondopa wendo ombá tekemo.’ nimbe pilipelie⸥ yu yuyu kondo kolopa konopu keri panjipe kamelena mindili tepili molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yuni enendo nimbendo: “Nanga konopuna umbuni paa aili te tepamo kene na kolkoro none tekemo. Ene uru naa peko, ya kanoko konjiku molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aku nimbelie yu yuyu laye kolte anju pupe koporongo langopa tamalu pepalie yu kinie nondopa wendo ombá mele ‘Wendo naa omu liemo paa papu.’ nimbe* Pulu Yemo kinie ungu nimbe mawa tepalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Nanga Tara, nuni uluma pali manda teleno kene na mindili noli no mingine no nombómo* ‘Naa nambo.’ nieni. Nakolo ‘Nane tepolie nanu konopu simbu.’ konopu lekero mele naa teambo. Nuni kanoko peanga kanoni ulumu mindi teambo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aku nimbelie kelepa yunge lombili andoli ye yepoko moloringine yando omba ene uru peringi kanopalie Pitando nimbendo: “Saimono, nu uru penu lemo. Nu uru naa peko ena laye kolte manda we kanoko konjiku naa molenaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‘⸤Kurumanga nomi Setenene⸥ olio kondi tomba kinie tepo kenjimulú kene.’ ningulie ⸤uru naa peko⸥ Pulu Yemo kinie ungu ningu kanoko konjiku molayo. Sike ‘tepo konjemili.’ nimbu konopumane pilimolo nakolo temolondo kangimu siye tepa tondolo naa pulimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aku sipe nimbelie yu altopa anju pupe ou Pulu Yemo kinie ungu nimbe mawa terimu mele altopa nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Altopa yando orumu kinie ene uru paa orumuna altoko uru peringi kanorumu. Enene uru peringimunge pipili kolkolie yundu ningí mele naa piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","⸤Altopa⸥ wale yepoko sipemonga ⸤anju pupe Pulu Yemo kinie ungu nimbé pupe⸥ kelepa yando ombalie yuni enendo nimbendo: “Nambemuna we uru peko múlu pilku molemeleye?* Manda peame! Manie Omba Mana Ye Au Lerimu Yemo ⸤tonge⸥ ulu pulu keri telemele yema liku singí enamo** wendo ombá tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ola angilku pamili wame! Na lipe anju simbe yemo okomo kanai!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesusini ⸤kolea Gesemani yu lombili andolimendo⸥ aku nimbe molopili yu lombili andoli rurepo akumanga ye Judasi orumu. Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* Juda yambomanga tapu yema kinie, kanu yemane liku munduringi ye aisili, yambo toli lou pulsema kinie kopema kinie mengo Judasi kinie oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ou Yesusi molorumuna naa wangi Yesusi Juda ye ailime lipe simbe nimbe panjirimu ye ⸤Judasini⸥ ene Yesusi yu ipulueli manda kanonge mele nimbe sipelie nimbendo: “Nane ye te kanopolie kangulumbu akumu Yesusi. Yu ambolko ka siku mengo pangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","⸤Aku yema⸥ oringi kinie ⸤Judasi⸥ yu Yesusi molorumuna sumbi sipe ombalie “Rapai,* nu akuna angilinu lemo.” nimbe omba yu kangulurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aku terimu kinie kanokolie Yesusi liku ka siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aku teringi kinie kanopalie ⸤Yesusi kinie⸥ nondoko angiliringi ye tenga* lou pokete napimu kulu topa wendo lipe Pulu Yemo popo tonjiringi ye aili olandopamonga kendemande ye te yunge komu te topa laka lenjirimu, aku komumu wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kanu kinie Yesusini ⸤yu ka singí oringi⸥ yemando nimbendo: “Na ‘yambo topa wa noli yere molemo.’ konopu lelkolie na ka singíndu yambo toli lou pulsema kinie kopema kinie mengo okomeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ulke tembele ⸤kerepuluna we yamboma maku toko molemele⸥ koleana alieli ene pea molemolo kinie ungu mane sipu molio kinie na liku ka naa silimele kanumu. Nakolo ⸤Pulu Yemonga⸥ bokuna toringi molemo mele kamu wendo ombámonga enene tenge tekemele uluma wendo okomo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kanu kinie yu lombili andolime pali ⸤‘Olio pea ka singínje.’ ningu pilkulie⸥ yu munduku kelko ene talopa lelko puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kango ye te múlu telu mindi pakopa Yesusi lombili andorumu. Kanu kangomo ⸤Yesusi ka siringi yemane⸥ amboloringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yunge múlumu ⸤mindi⸥ ambolko molangi, melte naa panjipe we we talopa lepa purumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kanu kinie Yesusi ⸤ka sikulie⸥ Pulu Yemo popo tonjiringi ye aili olandopamo molorumuna mengo puringi. Pulu Yemo popo tonjiringi ye ailime kinie, Juda yambomanga tapu yema kinie, ⸤Pulu Yemonga⸥ ungu manemanga puluma pilku mane siringi yema kinie,* enene pali ⸤‘Yesusi kote tenjipu piliemili.’ ningu⸥ akuna ongo maku toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesusi ⸤mengo puringi⸥ kinie Pita lombili akilipe taka lepa pupe, Pulu Yemo popo tonjiringi ye aili olandopamonga ulkena, ulke angilipe makaye terimu, ai suku singine yambo maku toringi kolea we lerimuna paa sukundu pupe, ⸤Yesusi nokoko moloringi⸥ ele yema kinie tepe pilipe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pulu Yemo popo tonjiringi ye ailime kinie, Juda yambomanga kanjollo yema pali* kinie, akumane Yesusi yu toko konjingindu ulu te tepa kenjirimu ulu te ‘Yambo tene ‘yu i sipe i sipe tepa kenjirimu.’ nipili.’ ningu yambo te kororingi nakolo yambo te naa kanoko liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yambo aisilini ongo ungu mare kolo toko “I sipe i sipe tepa kenjirimu.” niringi nakolo enenga unguma kapola naa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kanu kinie ye marene yu tepa kenjirimu mele ola angilku kolo toko ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“I yemo i sipe nirimu pilirimulu: “I ⸤Pulu Yemo popo toko kalemolo⸥ ulke tembelemo, mana yemane takoringimu nane topo tekisipulie mana yemane manda naa takonge ulke te wale yepoko omba pupili kolo wangopo takombo.” nirimu.* ⸤Yuni aku nirimumunge ‘Yu Pulu Yemo mele molio.’ konopu lepalie aku nirimumu nimbe kenjirimunje⸥.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ene kepe laye lupe lupe niringi, enenga unguma kapola naa la terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aku niringi pilipelie Pulu Yemo popo tonjiringi ye aili olandopamo ene maku toringine ola angilipe Yesusi walsipelie nimbendo: “Ungu te pundu toko naa nikinuye? Nu teko kenjirinu mele nikimilimu nambolka ulumu teko kenjirinumundu nikimiliye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nakolo Yesusi ungu te pundu topa naa nimbe we angilirimu. Pulu Yemo popo tonjiringi ye aili olandopamone yu altopa walsipe pilipelie nimbendo: “Pulu Yemone olio ‘Nokopa konjimbe ye te lipu mundumbu.’ ou nimbe mako torumu ye nomi Kirasimu sike nu molo moloye? Kapi Nimbu Imbi Ambolopo Ola Linjilimolomonga Malo nu molo moloye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesusini nimbendo: “Akumu na.” nirimu. “Pe walse Manie Omba Mana Ye Au Lerimu Yemo,* Ye Tondolo Olandopa Pulimu ⸤kinie melema nokombando⸥ yunge ki umbukundu molopa, kupemanga ola molopa manie ombá ene kanonge.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aku sipe nirimumunge ⸤yu ‘Pulu Yemo mele molio.’ nimbe nirimuna⸥ pilipelie Pulu Yemo popo tonjiringi ye aili olandopamone ⸤paa pilipe keri pilipe⸥ yunge wale pakolimu yuyu ambolopa sungu sipelie nimbendo: “Kinié yuni mongo lirimu mele nimbe simbe yambo te pea nambemuna koromoloye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yu yuyu paa sike Pulu Yemo ungu taka tonjikimu pilkimulu. Nambolka konopu lekemeleye? ⸤Yu kinie nambe teamiliye?⸥” nirimu kinie enene ningindu: “Yu Pulu Yemo ungu taka tonjimumunge topo konjímulu liemo papu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kanu kinie enenga ye marene yunge kumbikerena lkambe toko munduku, yunge kumbikeremo múlu tene pipi sinjikulie ki lumuni toko ⸤“Nu ‘Pulu Yemonga yere molio.’ konopu leno kene⸥ naene nu tokomonje ningu si!” niringi. Ele yemane yu liku laruwene toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kanu kinie Pita ulke maniekondo, yamboma liku maku toko moloringi koleana molorumu kinie* Pulu Yemo popo tonjiringi ye aili olandopamonga kendemande ambo te Pita molorumuna ombalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","yu tepe pilipe molorumu kanopalie nemo nemo nimbe kanopalie nimbendo: “Nu kepe Nasarete ye Yesusi kinie pea tapu toko moloringi kanumanga ye te lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pitane kolo topalie “Molo!” nimbe “Nu nikinu mele na naa pilkiru!” nirimu. Aku sipe nimbelie ulke kerepuluna purumu kinie kera gulta ko torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita yu ulke kerepuluna pupe molopili kanu kendemande ambomone yu kanopalie akuna angiliringi yambomando altopa nimbendo: “I yemo Yesusinge talape ye te lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitane altopa “Molo!” nirimu. Laye kolte pe mele Pita angilirimuna nondoko angiliringi yemane ⸤yu ungu laye lupe mele nirimu pilkulie⸥ yundu ningindu: “Kolea Gallilli disiriki yambomane ungu nilimele mele nu aku siku ungu nikinu pilkimulu. ⸤Yesusi kinie yu lombili andoli yema kinie kolea Gallilli disiriki yemala,⸥ nu kepe Gallilli ye te, aku kene ‘Nu paa sike yu lombili andoli ye te.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aku niringi kinie Pitane Pulu Yemonga imbi lepa tondolo mundupe mi lepalie nimbendo: “Paa sike nikiru. Ene nikimili yemo paa naa kanolio! Kolo tokoro liemo Pulu Yemone na topa konjipili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aku nirimu kinie tamburembu kera gulta wale talo sipe ko torumu. Aku terimu kinie pilipelie Yesusini yundu “Kera gulta wale talo sipe ko naa topili nuni wale yepoko kolo tokolie “Yu naa kanolio.” nini.” nirimu ungu kanumu* Pita kelepa pilirimu. Pilipelie ⸤‘Ama, paa tepo kenjindu lepamo. ‘Paa naa tembo.’ konopu lerindu mele sike tendu.’ nimbe pilipelie⸥ kola paa aili tepa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ipulueli ou kolea kokele tangorumu kinie Pulu Yemo popo tonjiringi ye ailime kinie, Juda yambomanga tapu yema kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, kanjollo yema pali,* ⸤Yesusinge kotemo pilku pora sikulie⸥ enene pali ⸤yu tenge mele⸥ ungu te ningu panjiringi. Aku ningu panjikulie yu liku, ka toko, mengo puku, ⸤Romo gapomano ye nomi⸥ Paillate molorumuna mengo puku kote tenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paillatene ⸤Yesusinge kotemo pilipelie⸥ yu walsipe pilipelie nimbendo: “Nu Juda yambomanga ye nomi kingimu molo moloye?” nirimu. Yesusini pundu topa nimbendo: “Sike nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pulu Yemo popo tonjiringi ye ailimene Yesusi kote tenjiku Paillatendo ⸤kolo toko⸥ ungu aisili ningulie ningindu “Yesusi yu tepa kenjilimo.” ningu yu kote tenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aku niringimunge Paillatene Yesusindu nimbendo: “Nu ulu keri aisili terinu nikimili mele pilkulie ungu te pundu toko naa nikinuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nakolo Yesusi ⸤yu tepa kenjirimu niringi mele⸥ pundu topa ungu telu kepe naa nimbe ⸤karaye naa tepa we angilirimu kinie kanopalie⸥ Paillate mini wale mundupe konopu aisili lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","⸤Yesusi kote tenjiku molangi,⸥ ye te, yunge imbi Barapasi, yu kinie ye mare kinie ‘Romo gapomanomone olio Juda yamboma naa nokopili.’ ningu ou Romo gapomanomo kinie opa tekolie yambo mare toko konjiringimunge ka ulkena peringi. ⸤Ponie tenga tenga Juda yambomane kolea aili Jerusalleme ongo akuna suku⸥ Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele pilingindu langi noringi walema wendo orumu kinie* enene ka ulkena perimu ye te imbi lelko ‘Wendo liku mundoi.’ ningu mawa teringi kinie ⸤Romo gapomano ye nomimuni⸥ kanu yemo wendo lipe yamboma sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","⸤Romo ye nomimuni kanu walemo wendo orumu kinie aku terimu mele pilkulie⸥ yamboma ongo yundu mawa tekolie ningindu: “Ou ponie telu telu ningu i walemo kinie teleno mele kinié kepe aku siku teani.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aku niringi pilipelie Paillatene enendo walsipelie nimbendo: “‘Juda yambomanga ye nomi kingimu wendo lipu ene siembo.’ konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","⸤We yambomane Juda yambomanga ye ailime munduku kelko enenga unguma liku su siku Yesusinge ungumu pilku yu lombili andoringimunge⸥ Pulu Yemo popo tonjiringi ye ailimene Yesusi kinie konopu keri panjikulie* kote tenjiringine pilipelie Paillatene aku sipe nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nakolo Pulu Yemo popo tonjiringi ye ailime we yamboma kondi toko ungu umbu tonjikulie “ “Yesusi molo. Barapasi wendo lipe sipili.” niei!” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aku niringi kinie pilipelie Paillatene enendo nimbendo: “Aku liemo ‘Judamanga ye nomi kingi’ nilimelemo nambe teambonje.” nimbe walsirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","enene tondolo munduku ningindu: “Yu unju perana kolopili uku toko panji!” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aku niringi pilipelie yuni enendo nimbendo: “Aku nambemunaye? Yu mongo nambolka mongore limuye?” nirimu. Nakolo enene ⸤altoko⸥ paa tondolo munduku ningindu: “Molo! Yu kolopili, unju perana uku toko panji!” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kanu kinie Paillatene ‘Na kinie konopu peanga leangi.’ nimbelie ye Barapasi ka ulkena wendo lipe ene sirimu. ⸤Aku tepalie⸥ Yesusi lipe ⸤yunge ami yema⸥ sipelie nimbendo: “Yu ka pulsene tokolie pe ‘Unju perana kolopili.’ ningu mengo puku unju perana uku toko panjipai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kanu kinie ⸤Romo⸥ ami yemane Yesusi liku gapomano ye nomimu perimu ulke aili* akuna suku yamboma liku maku toringi koleana pukulie, enenga ami talape yema pali “⸤Yesusi ya molemona⸥ sukundu sukundu wai.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Akuna ongolie niringimuni ⸤‘Yu ye nomi kingi te none tepili.’ ningu⸥ mulu wambale kondoli peanga te pakonjiku unju ka koko molorumu te mulkupiye teko ‘Ye nomi kingimunge waniemo.’ ningu pengena mere mundunjiku, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","pe yu ⸤ungu taka tonjiku⸥ imbi we kólo toko ambolko ola linjingindu “Juda yambomanga ye nomi kingimu, nu angilinoye?” ningu ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","⸤koló kope liku⸥ yu pengena kope to pu opu tekolie kumbikerena lkambe toko kanjiku, yu angilirimuna ongo koporongo langoko tamalu peko yu we kólo toko kapi ningu imbi ambolko ola linjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yu aku siku ungu taka tonjiku pora sikulie mulu wambale kondolimu kulunjiku yunge ou panjirimu mulu wambalema altoko panjinjikulie “Yu unju perana kolopili uku topo panjipamolo.” ningu yu liku ulsukundu* mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","⸤Romo ami yemane Yesusi Jerusalleme pala ulsukundu mengo pungí pukulie niringimuni,⸥ kolea Sairini* ye te, yu Allekesanda kinie Rupasitolonga lapa Saimono, yu Jerusalleme pumbe orumu kinie kanokolie yu ambolko liku ka mele siku Yesusi kolomba unju peramo “Kolo wangoko menji!” ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pukulie kolea Golkota Yesusi mengo puku akuna moloringi. (Golkotanga ungu pulumu ‘penge ombele leli koleamo’.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","⸤Yesusi akuna mengo pukulie niringimuni, ‘Yamboma mindili naa nangi.’ ningu⸥ no waenena suku maratene ‘mo’ nili te munduku nosiringi aku no waenemo ‘Yu nopili.’ ningu, siringi nakolo naa lipe norumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kanu kinie ⸤ami yemane⸥ yu unju perana ola uku toko panjikulie unjumu liku ola anjiringi. ⸤Aku tekolie, ou unjuna ola uku toko naa panjikulie⸥ yunge mulu wambale ⸤kulunjiku nosiringime⸥ ‘Moke teamili.’ ningu ene yu mele mele lingí mele pilingindu kou kate teko pe mulu wambalema liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ena topa nane killoko terimu kinie yu unju perana panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","‘Yu mongo lirimu mele yamboma kanangi.’ ningu I YEMO JUDA YAMBOMANGA YE NOMI KINGIMU ningu imbi toko unjuna ola monjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Opa tekolo melema wa liringili ye talo pea unju talonga uku toko panjiringila. Te Yesusi yunge ki umbukundu uku toko, te ki tarokondo uku toko panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Aku teringimunge ungu te ou Aisayane nimbe boku torumu mele wendo orumu. Aku ungumu i sipe: “Yu kinie yambo mongo liku ulu pulu kerime teli yamboma kinie liku tere lelko mako toringi.”* nirimu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Akuna ongo puringi yambomane Yesusi ⸤kanoko keri kanokolie yu⸥ ungu taka tonjiku iri mele tokolie ningindu: “Aa! “Ulke tembelemo tekisipulie altopo wale yepoko omba pupili takopo limbu.” nirinu yemo,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","‘Naa kolambo.’ ningu nu nunu liku taponjiku unju perana manie oi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aku sikula Pulu Yemo popo tonjiringi ye ailime kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie* enene kepe yu ungu taka tonjikulie ningindu: “Yu yambo wema ‘Naa kolangi.’ nimbe lipe taponjirimu nakolo yu yuyu ‘Naa kolambo.’ nimbe manda naa lipe taponjikimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yu sike Pulu Yemone olio ‘Nokopa konjimbe ye te lipu mundumbu.’ ou nimbe mako torumu ye nomi Kirasimu omba molopa, yu sike olio Isirele yambomanga ye nomi kingimu* molemo liemo yu yuyu unjuna manie opili. Yu yuyu manie ombá kinie kanopolie ‘yu sike Pulu Yemone mako topa lipe mundurumu ye nomi Kirasimu. Yu sike olionga ye nomi kingimu.’ nimbu tondolo mundupu pilimulú.” niringi. Ye talo yu kinie unjutolonga uku toko panjiringi yetolone yu aku siku ungu taka tonjiringilila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","⸤Yesusi unjuna ola we angilipili⸥ ai tangoli ena tuwellepo killoko terimu kinie kolea pali sumbulu topalie, pe ipupini ena tere killoko terimu kinie kelepa tangorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ipupini ena tere killoko terimu kinie Yesusini ru nimbelie nimbendo: “Elloi, Elloi, llama sapakatani.” nirimu. Akumu Juda yambomanga ungu te. Akumunge ungu pulumu i sipe: “Nanga Pulu Yemo, nanga Pulu Yemo, na nambemuna munduku kelenuye?”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akuna nondoko angiliringimenga marene yuni aku nirimu kinie pilku ⸤sundukulie⸥ ningindu: “Pilieme! Yu Illainja walsikimu.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aku nirimu kinie piliringimenga ye te lkisipe pupe ulú pinje mele te lipe no waene kombili teli mare akuna panjipelie, ‘Yesusi no waene kombili teli pinjena pelemomo nopili.’* nimbe memba omba unju pepena tenga ka topa olando sirimu. Sipelie yuni nimbendo: “Kinié unjuna we angilipili. Illainjane sike yu ⸤unjuna⸥ manie limbendo okomonje, kanopo kanamili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesusi ungu te tondolo mundupe nimbelie* kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","⸤Romo⸥ ami ye wane anderete nokorumu ye te Yesusi toringi ami yema nokopa molorumu kanu yemone Yesusi ungu te nimbe kolorumu mele pilipe kanopalie nimbendo: “I yemo yu paa sike Pulu Yemonga malo lepamo.” nirimu. ⸤Yesusi aku sipe kolorumu kinie ulu aili te walsikale wendo orumu.⸥ Pulu Yemo popo toko kaloringi ulke tembele ⸤Jerusalleme suku angilirimu akuna sukundu Pulu Yemo molorumu⸥ Suluminia Paa Kake Telimunge kerepuluna ⸤‘Yamboma sukundu naa pangi.’ ningu ou alieli⸥ mulu wambale aili tene pipi siku panjiringi angilirimu. ⸤Yesusi kolopa pora sirimu kinie⸥ kanu mulu wambalemo* ai suku singine olakondo maniendo sipe olá torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ambo mare ⸤Yesusi toringi mele⸥ sulu teko kanoko angiliringi. Enenga ambo te Makatalla taono ambo Maria, te Josese kinie angenu Jemisi kinie eltenga anumu Maria, te ambo Sallomi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesusi kolea Gallilli disiriki, ⸤kanu ambomanga pulu kolea,⸥ akuna ou we andorumu kinie kanu amboma yu lombili andoko liku taponjiku nokoringi. Yu kinie, Jerusalleme olando oringi ambo aisili wema kepe, ambo pokore kanoko angiliringi akuna ene kepe ⸤Yesusi toringi mele⸥ kanoko angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Opalikundu ⸤Juda yambomanga koro moloringi⸥ wale Sambatemo* nondopa wendo ombá terimu. Sambate walemo wendo ombá kinie koro molongendo kinié mele melema liku undu undu siringi walemo wendo orumu, aku walemonga ⸤Yesusi ou kolopili⸥ kolea kala tomba terimu kinie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatia taono ye Josepo, yu Juda yambomanga kanjollo ye aili te molopa, yu kepe ‘Pulu Yemo ye nomi kingimu molopa olio nokomba walemo* wendo opili.’ nimbe nokopa molorumu yemo. Yu omba pipili naa kolopa** ⸤Romo gapomano ye nomi⸥ Paillate molorumuna sumbi sipe pupe “Yesusinge onomo na si.” nimbe mawa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesusi walsikale kolorumu pilipelie Paillate yuni ⸤‘Yamboma unju perana uku topo panjilimolo kinie ena aisili omba pupili we pelemele. Pe kinié yu sike walsikale kolomunje molo nambe temunje?’ nimbe pilipe⸥ konopu lipe mundupe ami ye wane anderete nokorumu yemo “Opili.” nimbelie yundu walsipelie “Yesusi koronga kolomuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ami yema nokoli yemone “E.” nirimu kinie pilipelie yuni ami yema nokolimundu nimbendo: “Kapola, ya yemone ⸤Yesusinge⸥ onomo lipili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","⸤Paillatene “Kapola.” nirimu kinie⸥ Josepo pupe mulu wambale te topo topa lipe onomo manie lipe, múlumuni kulupi topalie kou kande te akuku nosiringi kou kandemonga suku memba pupe nosirimu. Nosipelie kou kande kerepuluna kou aili te perele marele memba omba pipi sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makatalla taono ambo Maria kinie Josese anumu Mariatolone yunge onomo ⸤kou kandena⸥ nosirimu mele kanoringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena pupe ipu lerimu kinie ⸤Juda yambomanga koro moloringi⸥ wale Sambatemo* omba purumu kinie Makatalla taono ambo Maria keme Jemisi anumu Maria keme ambo Sallomi keme enene ‘Yesusinge onona kopongo wele mune toli pokore ape kanjinjemili.’ ningu mare topo toko liku ⸤nosiku peringi⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pekolie paa ipulueli ou, enenga pulu pulu kongono walemo wendo ombando ena mundi orumu kinie kanu amboma puku ⸤Yesusinge⸥ onomo nosiringi kou kandena pungí pukulie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","anju yando walsikulie ningindu: “Kou kande kerepulumu pipi siringi koumu naene wendo lipe perele marele memba pupe nosinjimbenje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nakolo ongo olando siku kanoringi kinie kou kanumu, paa kou kapo ailimu, ou wendo liku perele marele mengo puku nosiringi, ⸤kerepulumu we lerimu⸥ kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kou kandena suku pukulie kou kandemonga ki umbukundu ye kango te mulu maminia sulu paa kake te pakopa molorumumu kanokolie mini wale munduku konopu liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kanu kinie yuni enendo nimbendo: “Konopu liku naa mundeyo. Kolea Nasarete ye Yesusi ‘Kolopili.’ ningu talko unju perana uku toko panjiringi kanu yemo kanonge okomelemo na pilkiru. Yu lomboropa ola molopa omba pumu. Ya naa lemo. Onomo ou nosiringi koleamo ongo kaname. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kanokolie anju puku Pita keme* yu lombili andolime kinie pali i siku ningu siengi: “Yesusi kolea Gallilli disiriki kumbi lepa pulimo kene akuna “Ene na kanonge.” ou nirimu mele** sike ene akuna yu kanonge.” ningu sipai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","⸤Angellomone aku sipe omba mona molopalie nirimu mele⸥ kanoko pilkulie amboma pungu pungu ningu konopu aisili liku mundukulie kou kandena ulsu puku munduku kelko paa lkisiku puringi. Pipili kolkolie yambo telu kepe kanoko piliringi mele ningu naa siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Juda yambomanga pulu pulu kongono walemo kinie,* paa ipulueli ou, Yesusi lomboropa ola molopalie nirimumuni, ulke kolea Makatalla ambo Maria, ou walse kuru yepoko pakara konopuna moloringime Yesusini topa makororumu ambo kanumu molorumuna pupe ⸤‘Na lomboropo ola molondu we molio mele kanopili.’ nimbe⸥ lipe ora sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kanu kinie Yesusi ⸤mona angilirimu⸥ kanopalie ambomo yu pupe, ou Yesusi kinie moloringi yamboma kamelena mindili nongo kola teko moloringine pupelie kanorumu mele ene nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yuni ene Yesusi konde molorumu mele kanopalie nimbe sirimu kinie pilkulie ‘Yu kolo tokomo.’ ningu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","⸤Makatalla ambo Maria Yesusi yu lipe ora sipelie nirimumuni,⸥ pe ⸤yu lombili andoringimenga⸥ yambo talo ⸤ulke kolea aili Jerusalleme munduku kelko⸥ aulke tenga puringiline Yesusi yu kumbikere kangi alowa tepa ‘Na kanangili.’ nimbe omba mona angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe yu kanoko imbi sikululie kanu yambotolo kelko yando ongolo ⸤lombili andoli⸥ wemando eltene kanoringili mele ningu siringili nakolo eltene ningu siringili mele kepe ‘Kolo tokombele.’ ningu piliringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pe walse lombili andoli rureponga yepoko langi nongo moloringine Yesusi omba mona molopalie nirimumuni, ene iri topalie nimbendo: “Enene na ‘Lomboropa ola molomu.’ ningu tondolo munduku naa pilku, na konde molondu mele yambo marene kanokolie ene ningu síngi kinie ‘Kolo tokomele. Aku paa naa temu, manda naa temba.’ ningu piliengi, akumu nambemuna aku siku karaye teko ningu pilíngiye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","⸤Aku nimbelie⸥ yuni enendo nimbendo: “Ene ma koleamanga pali puku yamboma pali temane peangamo toko siliku andopayo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ningí mele pilkulie ‘Akumu sike nikimili.’ ningu tondolo munduku pilkulie no lingí yamboma ⸤kote walemo wendo ombá kinie⸥ Pulu Yemone ene lipe taponjipe ‘Ene mindili nolemelka koleana naa puku, molko konjiku mindi pangi.’ nimbé.* Nakolo ⸤ene lombili andolimene⸥ ningí mele pilkulie ‘Akumu kolo tokomele.’ ningu pilkulie liku su singí yamboma ⸤kote walemo wendo ombá kinie⸥ Pulu Yemone ‘Ene mindili nongo mindi pungí koleana pangi.’ nimbé.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“‘Aku temanemo sike.’ ningu tondolo munduku pilingí yamboma ‘Na ene kinie sike molio we yambomane ningu kanangi.’ nimbú kinie ulu tondoloma tenge kinie yamboma kanonge mele i sipe: Ene nanga tondolomone* kuru mare yambomanga konopuna molongema toko makoroko; umbu ungu lupe lupe naa pilingíme ningu; ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yambo nongo konjili kongi ka wambiyema naa kanoko kimuni ambolonge kinie akumane ene naa nongo konjingí; tomo pelemo no te naa pilku nonge kinie uluri paa naa temba; kuru tomba yamboma kimuni ambolonge kinie konde pungí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aili Yesusini ⸤yu lombili andolime⸥ ndo aku sipe nimbe pora sirimu kinie ⸤Pulu Yemone⸥ yu mulu koleana olando lirimu. Akuna ⸤imbi ola molopili Pulu Yemo kinie melema nokombando⸥ Pulu Yemonga ki umbukundu pupe molorumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesusi yu mulu koleana olando purumu kinie yu lombili andolime koleamanga pali puku Yesusinge temane peangamo yamboma toko siliku andoringi kinie ‘Enene nanga unguma yamboma ningu singí kinie kanu yambomane ‘Ungu sikemo.’ ningu pilku liengi.’ nimbe Ailimu ene kinie pupe lipe taponjirimu kinie yuni lipe mundurumu yamboma enene ‘Pulu Yemone mindi ulu tondoloma manda telka mele teangi.’ nimbe lipe taponjirimu. ⸤Aku pea.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ye paa aili Tiopillasi, olio molemolo koleana Yesusi kinie ulu wendo orumuma pulu pulu wendo orumu kinie kanoko, yandopa wendo orumuma kanoko andoko moloringi yambomane pe olio temane toko siringi mele, aku temanemo “Sike.” nimbu tondolo mundupu pilimolo kanumu yambo aisilini ‘Aku temanemo bokuna kamu molopili tamili.’ ningu boku toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Akumunge pe kelepo nane kepe ‘ ‘Temanemonga pulumu paa pilipu konjembo.’ nimbu ou pulu pulu wendo orumu mele kepe yandopa ulu lupe lupema wendo orumu mele kepe akuma pali walsipu pilipu konjipu molorunduna nane ‘Aku ulumando yambo marene Tiopillasi nundu temane toko ungu mane silimele mele aku sipe wendo orumu uluma nu pilieni.’ nimbu, ‘Nane nundu ulumanga pali paa sike wendo orumu mele temane topo nimbu siembo.’ nimbu, boku topo nu simbu kinie papu.’ nimbu pilipulie aku temanemo topo i bokumu tokoro. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ye Nomi Kingi Erote kolea Judia nokopa molorumu kinie Pulu Yemo popo tonjirimu ye te molorumu,* yunge imbi Sekaraya. Pulu Yemo popo tonjiringi yambomanga talape tenga imbi Apaya, Sekaraya yu kanu talapemonga ye te. Sekaraya menu ambo Illisapete Pulu Yemo popo tonjiringi yemanga talape tenga ambo te. Eltenga pea pulu pulu anda kolepamo Pulu Yemo popo tonjiringi yemanga pulu pulu ye nomi aili Erono.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aku ambo yetolo moloringili mele Pulu Yemone kanopa ‘Yambo sumbi nilitolo.’ nimbe kanorumu. Eltene yunge ungu manema kinie “Yamboma teai.” nirimu unguma pali pilku liku teko konjiku moloringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nakolo Illisapete we wayongono perimu, ambolango te naa meringili. Elte we ambu anda lelko moloringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Walse Sekarayanga talapemone Pulu Yemo popo toko kaloringi kongono tenjiringi kinie yu kepe pea Pulu Yemonga kumbikerena kanu kongonomo tenjiringi. Aku tenjiku molkolie niringimuni, Pulu Yemo popo tonjiringi yemane teringi mele tengendo enenga talapena ye te Pulu Yemo popo toko kaloringi ulke tembele akumunge suluminiana suku ‘Nae pupe mune tolemo paura kekumu yambomanga nimbe kalonjimbenje piliemili.’ ningu kou kate teringi. Aku tekolie ‘Sekaraya yu kanu kongonomo tenjimbe.’ ningu kanoringine yu ulke tembele suluminiana suku pupe mune toli paura kekumu kalonjipurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aku tepa angilirimu kinie ulke tembelena we yamboma maku toko Pulu Yemo popo toringi koleana yambo aisili Pulu Yemo kinie ungu ningu angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","⸤Sekaraya mune toli paura kekumu kalonjipe angilirimu kinie⸥ kanu paura kekumu kalonji pu opu teringi polomonga ki umbukundu Ailimunge angello te omba mona angilirimu kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Akumu kanopalie pungu pungu nimbe pipili aili tepa kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kanu kinie angellomone yundu nimbendo: “Sekaraya, pipili naa koloi.” nirimu. “Nu Pulu Yemo kinie mawa teleno mele Pulu Yemo yuni pilirimu. Nunge ambomo kango te kanopa limbe. Yunge imbi “Jono” ningu leani. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yu molombamonga nu konopu aili teko siku kamele akoko moloni. Yu mengele kinie yambo aisili konopu singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ailimuni yu kanopa ye aili peangamo nimbe kanomba. No waene kinie no tondoloma kinie walsikale kepe paa naa nopili. Anumunge olona we sukundu molomba kinie Pulu Yemonga Mini Kake Telimu omba yunge konopuna molopa kapola temba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Isirele yambomane enenga Aili Pulu Yemo* liku bulu siringi yambomanga aisili Jonone tembamonga altoko konopu alowa teko Aili Pulu Yemo pea altoko pilku kapola kapola molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","⸤Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye⸥ Illainja tondolo pepili uluma tepa molorumu mele Jono yu aku sipe tondolo pepili uluma tepa molomba. Aku sipe tondolo pepili uluma tepa molombamonga lapalini konopu alowa teko ambolangoma kelko konopu monjingíla; Pulu Yemonga ungu manema liku su silimele yambomane konopu alowa teko, konopu sumbi nili yambomane telemele mele ‘Aku sipu teamili.’ ningu molongela; Jono yuni tembamonga Ailimu ombá kinie Ailimu yunge ungumu sumbi siku pilku lingí yambo talape te molongela.” nimbe angellomone Sekarayando nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aku nirimu kinie pilipelie Sekarayane angellomondo walsipelie nimbendo: “Aku nikinumu nambe tepo nane ‘Sike nikinu.’ nimbu pilimbuye?” nirimu. “Na anda lepo nanga ambomo ambu lerimu kanumu. Pe i nikinumu nambe tepa wendo ombamondo nikinuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angellomone pundu topa nimbendo: “Nanga imbi Geperiele. Na Pulu Yemonga kumbikerena angilio. I kinié nundu nikiru mele Pulu Yemone “Aku siku nipui.” nimbe lipe mundumuna nundu ombo i temane peangamo topo sikiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nakolo nane “Kango mengele.” nikirumu ‘Kolo tokomonje?’ ningu pilkinu kene i ulumu ou wendo naa opili nu ungu naa nili moloni. Pe “Wendo ombá.” nikiru mele amboma ambolango olona monjikulie melemelemanga walema omba pulimo mele aku sipe walema omba pumbe kinie i nikiru ungumu paa sike wendo ombá.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aku siku ungu ningu angiliengili Sekaraya ulke tembelemonga suluminiana sukundu koronga ou pupe molopa, welea wendo naa orumuna yamboma ulsukundu yu nokoko angiliringime konopu aisili liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kanu kinie yu wendo ombalie nirimumuni, ungu te kerena manda naa nimbe kimuni mindi manda lepa angilirimu kinie kanokolie, ‘Sekaraya yu suluminiana suku molopalie melte omba angilili none tepa kumbikere lipe pinjimuna kanomu.’ konopu leringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pe ulke tembelena yunge kongono walema pora nirimu kinie yunge ulkendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ulkendo pupe ⸤ambo Illisapete kinie pekolo moloringili kinie⸥ pe Illisapete ambolango olona monjirimu. Monjipelie oli te pakara ‘Yambomane yu naa kanangi.’ nimbe lopi tepa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yuni nimbendo: “Kinié na kinie ulu tekemomo Ailimuni nanga nimbe tenjikimu. Na ambolango te naa merindumunge yamboma na kanoko keri kanoringi kinie pipili kolorundumunge Ailimu yuni na kondo kolomu lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","⸤Illisapete ambolango olona monjipili oli te pakara kolopa⸥ talo pakara sipemo ke topa angilirimu kinie Pulu Yemone mulu koleana angello Geperiele kolea Gallilli disiriki Nasarete taonona lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kanuna ambo wenepo te, ye te kinie ou naa peli we molorumu ambo wenepo te molorumuna mundurumu. Kanu ambo wenepomo yunge pulu lerimu yambomane ‘Yu ye te pupili.’ ningu mako toringi yemonga imbi Josepo. Kanu yemo yunge anda kolepa te ⸤ye nomi kingi⸥ Depisi. Ambo wenepomonga imbi Maria. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maria molorumuna angello Geperiele ombalie yundu nimbendo: “Ambomo, nu molonuna na okoro. Nu malo. Ailimu nu pea tapu toko molembele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nakolo kanu ungumu pilipelie yu konopu aisili lipe mundupelie, ‘A! I nikimumu nambolka unguri nimbe nikimunje?’ nimbe pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angellomone yundu nimbendo: “Maria, Pulu Yemone nu kanopa peanga kanokomo kene pipili naa koloyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pílie. Nu pe olona kango te monjikulie menimu. Mengolie yunge imbi “Yesusi” ningu leani. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yu ye nomi molomba, yu imbi lelko ‘Paa Olandopa Molemomonga Malo.’ ningíla; Aili Pulu Yemone ‘Yunge anda kolepa Depisi Isirele yambomanga ye nomi kingi tondolomo molorumu mele yu aku sipe molopili.’ nimbéla; ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Enenga anda kolepa Jekopone kalopa lirimu yamboma yuni kamu kamu nokombala; Yu ye nomi kingi ailimu molopa mindi pumbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariane angellomondo nimbendo: “I nikinu ulumu nambe tepa tembamondo nikinuye? Na ye te naa purundu kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angellomone yundu nimbendo: “Nu molonine Paa Olandopa Yemonga Mini Kake Telimu omba nunge olona kango te monjinjimbe. Aku tembamonga kango nuni menimu yu kango kake telimu molomba; yu imbi lelkolie ‘Pulu Yemonga Malo’.* ningíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","⸤Pulu Yemone nu “Tembo.” nikimu mele sike temba. Ulu tondolo te “Tembo.” nimbelie terimu mele niembo.⸥ Nunge pulu lemo ambo Illisapetendo “Ambo wayongono pelemo.” nilimele nakolo kinié yu ambo ambu lepili oli te pakara kolopa talo pakara sipemo ke topa angilipili yu kango te olona monjikimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pulu Yemone ulu manda naa temba ulu te paa naa pelemo. Yuni uluma pali kapola telemo kanumu.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","⸤Angellomone yundu aku sipe nirimu kinie pilipelie⸥ Mariane nimbendo: “Na Ailimunge kongono kendemande ambomo molio. Nuni nikinu mele Pulu Yemo yuni na kinie aku sipe tepili.” nirimu. Kanu kinie angellomone Maria mundupe kelepa yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","⸤Mulu koleana angellomone Mariando ungu nimbe pora sipelie kelepa purumu kinie⸥ pe Maria kolea Judia disiriki pupe ma pangi tenga ola taono te lerimuna purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pupe akuna ye Sekarayanga ulkena suku pupelie ambo Illisapete kanopa “Na okoro.” nirimu kinie kanguluringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Illisapetene Marianga ungumu pilirimu kinie Illisapete yunge olona ambolangomo pukue topa ola manie terimu pilirimu. Kanu kinie Pulu Yemonga Mini Kake Telimu Illisapetenga konopuna pupe molopa kapola terimu kinie “I siku i siku ni.” nirimu mele ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Illisapetene ungu tondolo tepa nimbelie nimbendo: “Ambo molemelemanga pali nu malo. Ambomanga pali Pulu Yemone nu olandopa tepa konjirimu. Ambolango nu olona monjilinomo kepe yuni tepa konjimbela.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na ambo keri te molonduna nanga Ailimunge anumu nu onumunge na konopu aisili lipu mundukuru. Aku tenumunge na kinie teko peanga sikinu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu ongolie “Na okoro.” ninuna komuni pilindu kinie nanga olona molomu ambolangomo paa konopu sipe pukue topa ola manie temu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ailimuni nundu nirimu ungumu pilkulie ‘Sike nikimu. Yuni “Tembo.” nikimu mele sike aku temba.’ ningu tondolo munduku pilirinumunge* yuni nu tepa konjikimu mele tepa konjimbe kene nu konopu siku molani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Illisapetene nimbe pora sirimu kinie Mariane nimbendo: “Pulu Yemo nanga Lipe Taponjipe, Mindili Nombo Molopo Kenjilio Aulkena Wendo Lipe, Kapola Molopo Molopo Konjimbu Aulkena Lipe Monjimbe Yemo kinie* na konopu paa aili tepo sikirumunge nanga konopumuni Ailimu kapi nimbe imbi ambolopa ola linjikimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pulu Yemo yuni yunge we ambo kendemande kerimu siye naa kolopa konopu lipe mundurumumunge nanga konopumuni aku sipe yu kapi nikimu. Yambomane pe pe kepe kalko lingí yambomane nando “Pulu Yemone nu tepa konjikimu. Nu malo.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tondolo Pulimuni na ulu tondoloma tenjirimumunge nando aku siku ningí. Tondolo Pulimu yu ye kake telimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yu kinie pipili kolko pilku limele yamboma yu kondo kolopa molemo. Enene pe pe kepe kalko lingíme kepe kondo kolopa molopa mindi pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yuni yuyu ulu tondoloma terimu. Yambo kara puku enenga konopuna eneno kapi ningu molemele yamboma yuni anju anju topa makoropa mundulimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yamboma nomi molko koleama nokoko molemelema yuni topa manie mundupe, yamboma enenga imbime ene eneno topa manie mundumbema yuni enenga imbime ambolopa ola linjilimo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Engelene kolemele yamboma yuni ‘Olo tepili.’ nimbe langi peangama sipe, yambo kamakoma mele teluri kepe naa sipe “We pai.” nimbe makorolemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yuni olionga pulu pulu anda kolepalimendo “Tembo.” nimbe, nimbe panjirimu ungumu komu naa sipe pilipe molopalie, ⸤anda kolepa⸥ Eporayamo kinie, Eporayamo yuni yandopa yandopa kalopa lirimu yamboma kinie, enendo “Tembo.” nimbe, nimbe panjirimu mele tembando olio Pulu Yemo yunge kendemande Isirele yambo molemolo akuma yuni kondo kolopa lipe taponjimbe tepa molemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Illisapete kinie pea molangili oli yepoko omba purumu kinie pe Maria yu yunge ulke koleando kelepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Illisapete ambolango memba walemo wendo orumu kinie yuni kango te kanopa lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yunge ulke kere pongolo yamboma kinie yunge pulu lerimu yamboma kinie Ailimuni yu kondo aili tepa kolorumu mele pilkulie ene yu pea konopu siku moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wale yepoko pakara kangomo kanopa lipe nosipe molorumu kinie wale engaki sipemonga yamboma sukundu sukundu ongo maku tokolie yunge kangi te kopisiku makaye teko wendo liku ele tekolie niringimuni,* yunge imbimu yunge lapanga imbi manda lelko “‘Sekaraya’ niemili.” niringi ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","nakolo kangomonga anumuni “Molo.” nimbelie “Yunge imbi ‘Jono’ nimulú.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Enene yundu ningindu: “Eltenga pulu lemo yambo tenga imbi aku sipe naa molemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kanu kinie enene “Lapane nambolka konopu lekemone, yunge imbi lepa nae nimbéne, walsipu piliemili.” ningu lapando kimuni manda leringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","yuni pundu topa kimuni manda lepalie “Boku siei.” nimbelie, yuni bokuna topalie nimbendo: “Yunge imbi Jono.” nirimu. Akumu kanokolie yambomane paa konopu aisili leringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kanu kinie walsikale Sekaraya yunge kerena kelepa ungu nimbelie Pulu Yemo kapi nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aku terimuna kanokolie yunge ulke kere pongolo yambomane pipili paa koloringi. Kolea Judia disiriki ma pangima polorumu koleamanga pali aku temanemo mindi toliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aku ulumu piliringi kinie yambomane pali konopu liku mundukulie ningindu: “Ulu akumu we naa telemo. Ailimu i kangomo kinie molombamonga aku tekemo lemo.” ningu pilkulie “I kangomo pe nambe tepa molombanje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mini Kake Telimu Jono lapa Sekarayanga konopuna omba molopa kapola terimu kinie Sekaraya yuni Pulu Yemone ungu umbu tonjirimu ungu te pilipe, pe wendo ombá mele yamboma nimbe sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ailimu, Isirele yambomanga Pulu Yemo, yu kapi nimbu imbi ambolopo ola linjemili. Yu omba yunge yamboma lipe taponjipe umbuni tene ene ambolorumuna mindili nongo moloringi kanu umbunimunge wendo limuna* pilipulie aku teamili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pulu Yemo yuni yunge kendemande ⸤olionga ye nomi kingi⸥ Depisini kalopa lirimu yambomanga ye tondolo peli te olio ‘Lipe taponjipe mindili nombo molopo kenjilimolo aulkena wendo lipe, kapola molopo konjimulú aulkena lipe monjipili.’ nimbe simu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Yuni ungu umbu tonjirimuma pilku yando ningu siringi yemane pe tembamondo koronga ou ningindu:) ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Yuni olio lipe taponjipe olionga opa touma topa mundunjipe,* olio kanoko keri kanoko mindili silimele yamboma ‘Aku siku naa teangi. Wendo ongo kapola molangi.’ nimbe aku siku telemele aulkena wendo limbe.”* niringi mele kinié aku temba tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Olionga anda kolepalime kondo kolopa, olionga pulu pulu anda kolepa Eporayamo kinie “Tembo.” nimbe, nimbe panjipe mi lerimu mele* “komu naa sipu, nirindu mele teambo.” nimbelie aku temba tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Pipili naa kolko, nanga kongonomo tondolo munduku tenjiku, konopu kake tepili molko nane kanopo peanga kanolio uluma mindi mana teko mololiku pangi.’ nimbelie olionga opa toumane olio toko mindili silimelema ‘Naa teangi. Olio we molamili. Lipu taponjipu tokomele aulkena wendo limbu.’ nimbe,* nimbe panjipe mi lerimu mele ‘Teambo.’ nimbelie aku tekemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nanga kango ⸤Jono⸥, nu kumbi lelko puku Ailimu ombá aulkemo akisinjinímunge pilkulie ningímuni, yambomane pe nundu ‘Olandopa Molemomonga ungu umbu tonjilime pilipe yando nimbe sili yemo.’* ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","‘Ailimu yunge aulkemo akisinjembo.’ ningulie nuni yunge yambomando i siku ningu sini: “Ailimu yuni enenga ulu pulu keri telemelema ‘Manie pupili.’ nimbe siye kolopalie ene lipe taponjipe mindili nolemelka aulkena wendo lipe, yu kinie pea molko konjingí aulkena lipe monjimbe.” ningu, aku ungumu enendo ningu sini.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Pulu Yemone olio kondo aili tepa kolopalie olio sumbulu toline molopo kololi aulkena molomoloma konopu pe nipili molomolo aulkena ‘Manda kanoko pangi.’ nimbe ‘Pa tenjipili.’ nimbe olio molemolona pa tenjilimu lipe mundukumu.” nimbe Sekarayane nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kango Jono yu ai lepa konopu tondolo pupe kapola molorumu.* Yu pe Isirele yambomanga kumbikerena kongono tepa molombando ou kolea ku leline pupe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","⸤Jono pamemo molopili⸥ Romo Gapomano Ye Paa Aili Kumbine ‘Sisa Okasitasi’ nilimuni ungu mane te nimbe panjipelie “Romo gapomanomone nokolemo koleamanga molemele yamboma pali imbi tamili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kiriniasi kolea Siria poropinji nokorumu yemo molopili Romo gapomanomone yambomanga imbime pulu pulu torumu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","⸤Ungu mane akumu Okasitasini nimbe panjirimu kinie⸥ yamboma pali enenga anda kolepalimene kalko liringi koleamanga yu mele mele ene puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ye Josepo kolea Gallilli disiriki Nasarete taonona molopa, ⸤Romo ye nomimuni ‘Yamboma imbi tamili.’ nirimu⸥ pilipelie nirimumuni, Nasarete mundupe kelepa yu kalopa lirimu anda kolepa Depisi ou perimu kolea Judia disiriki pupe Betellieme taonona* purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akuna “Oltonga imbitolo tangi pambili.” ningulu yu nondopa limbe ambo Maria kinie elte akuna puringili. Maria ulke pelimu pea puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Betellieme suku pukululie, yambo ponenge ongo pe pu opu teringi ulkemo si nirimuna ⸤elte kongi dongi kinie kaoma panjiringi ulkena puku peringili. Akuna peringili kinie⸥ Maria ambolango mini torumu. Pe kango te kanopa lirimu. Aku kangomo yunge komolayemo. Kanopa lipelie mulu wambale marene lipe kangomo okopa, kongime langi noli kete tenga suku nosirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","⸤Betellieme⸥ ulsukundu kongi sipisipi tapu ye mare era poniemanga ipulueli enenga sipisipime tapu teko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kanu kinie ene moloringine Ailimunge angello te omba mona angilirimu kanoko, Ailimunge pa tondolo tepa telimu omba ene moloringi kolea pa terimu kanokolie, ene mini wale aili teko munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nakolo angellomone nimbendo: “Nane ene temane peanga te topo simbu okoro kene pipili naa kolayo. I temanemo yamboma pali konopu singí temanemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kinié ⸤ou molorumu ye nomi kingi⸥ Depisinge taonona* ambo tene kango te memu. Yu Yamboma Lipe Taponjipe Mindili Nongo Molko Kenjilimele Aulkena Wendo Lipe, Kapola Molko Konjingí Aulkena Lipe Monjimbe Kangomo;** yu Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu; yu Ailimu.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sike nikiru molo kolo tokoronje ene puku kanangi mele nimbu siembo. Ambolango kiki te mulu wambalene okoko, kongime langi noli kete tenga nosíngi puku kanoko lenjingí. Aku siku kanoko lenjikulie nane ‘Sike nimu lemo.’ ningu pilingí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aku nirimu kinie tamburembu mulu koleana angello paa aisili ou orumu angellomo angilirimuna ongo mona angilkulie niringimuni, Pulu Yemonga imbi ambolko ola linjiku yu kapi ningulie ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mulu Koleana Paa Olandopa Pulu Yemonga imbi paa ola molopili. Mana yambo yuni kanopa peanga kanolemo yamboma, konopu wayongo siku molangi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aku ningulie ene kongi sipisipi tapu yema munduku kelko mulu koleana kelko olando puringi. Angelloma kelko mulu koleana olando puringi kinie sipisipi tapu yemane anju yando ningindu: “Olio Betellieme pupu i ulu kinié wendo okomo mele Ailimuni nimbe simumu kanopamolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aku ningulie popenge teko pukulie niringimuni, Maria Josepotolo moloringili kanoko, ambolango kikimu kongimenga langi noli ketena suku lerimu kanoko lenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yu kanokolie, ou angellomone ene aku ambolangomondo nimbe sirimu mele yamboma ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kanu kinie sipisipi tapu yemane ningu siringi mele pilkulie yambomane konopu aisili liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nakolo Maria i unguma kinie ulu wendo orumuma pali konopuna panjipelie, pe kepe konopu kimbu sipe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisipi tapu yema kelko yando ongolie niringimuni, angellomone nimbe sirimu mele pali pilku kanoringimunge Pulu Yemo kapi niliku yunge imbi ambolko ola linjiliku yando oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kangomo kanoko liku nosiku molangi wale yepoko pakara omba purumu kinie wale engaki sipemonga yunge kangi te kopisiku makaye tekolie,* anumuni yu olona naa monjipili angellomone nirimu mele pilkulie yunge imbi “Yesusi” ningu leringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Josepo kinie Mariatolo, elte kamu kake tepili molongele walemo wendo orumu kinie, Mosisini ungu mane sirimu te* pilku liku tengelendo kolea aili Jerusalleme pukululie niringilimuni, kake tepili molongelendo Pulu Yemo popo toko kalopuringili. Ailimunge ungu mane te ou sirimu perimu akumu i sipe: ⸤‘Ambo tene ambolango kanopa lipelie yu pena pemba mele molomba. Pena pemba walema pora nimbé kinie kake tepili molombando⸥ kera waembono mele talo molo kera imili mele talo Pulu Yemo popo topa kalopa sipili.’** nimbe ungu mane aku sipe nimbe perimu kanumu pilkulie tengelendo puringili. Ailimunge ungu mane nimbe perimu te pea pilku liku tengelendo puringilila. Aku ungu manemo i sipe: ‘Kango komo kanoko lingíme pali “Ailimunge” ningu yu siengi.’*** nimbe perimu kanumu. Aku ungu manemo nimbe perimuna pilkululie ‘Oltonga kango komomo Pulu Ye Ailimu siembili.’ ningululie Jerusalleme pungilindu Yesusi mengo puringilila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ye anda te Jerusalleme molopili elte puringili, yunge imbi Simiono. Yu sumbi nirimu yemo; yu Pulu Yemonga ungu pilipe alieli Pulu Yemo kinie ungu nirimu yemo; yu Isirele yamboma kapola kapola molangi omba tenjimbe yemo kanombando nokopa molorumu;* Mini Kake Telimu yunge konopuna sukundu molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mini Kake Telimuni yundu ungu te ou nimbendo: “Nu ou we naa koloni. Nu ou Ailimuni “Ene nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye nomi Kirasimu kanokolie pe koloni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mini Kake Telimuni Simiono yu lipe mundurumuna yu Pulu Yemo popo toko kaloringi ulke tembelena purumu. Kanu kinie Yesusi anumu lapatolo ungu manemone kangomando “Teai.” nimbe sirimu mele tengelendo kango Yesusi mengolo ulke tembelena sukundu puringili kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simionone omba kangomo kangulupe lipe Pulu Yemonga imbi ambolopa ola linjipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ye Aili Tondolo Olandopamo, yamboma lipe taponjipe mindili nolemelka aulkena wendo lipe nu kinie pea molko konjingí aulkena lipe monjimbe ye sikinumu* na kinié nanga mongone kanokoro kinie ou nando ningu panjirinu mele wendo okomo kene kinié na nunge kendemande yemo konopu pe nipili kolombo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","“‘Kanu lipe taponjipe wendo lili ulumu koleamanga pali yambomane kanangi.’ ningu tekeno. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yu Isirele yambomanga ulsu molemele yambomanga pa tenjipe, nunge Isirele yambomanga imbi ambolopa ola linjimbendo pa tenjili mélemo molemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Anumu lapatolo Simionone kango Yesusindu nirimu mele pilkululie konopu aisili liku munduringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionone “Pulu Yemone ene tepa konjipili.” nimbelie Yesusi anumu Mariando nimbendo: “Pílie. I kangomo molombamonga Isirele yambo aisili imbi ou molorumuma pe manie pungíla; aisili imbi ou naa molorumuma pe kinié imbi molombala. Yu molomba kinie yambomane kanokolie bulu siku ungu taka tonjingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ambomo, nu kepe ulu te wendo ombá. Nunge kamelena mindili aili tepa temba kinie yambo aisili konopu lenge mele mona lemba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ambo te, yunge imbi Ana, yu Juda yambomanga talape kanga Asa, ye Panuelenga lemenu; yu paa ambu lerimu; yunge menu yemo pea molangili ponie yepoko pakara omba purumu, pe yunge menu kolorumu kinie yu wayemo molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yu mana molopili yunge ponie paono kise kelepa yepoko omba pupe paono kise kelepa kise sipemonga yu we molorumu. Yu ulke tembelemo mundupe naa kelepalie alieli kanuna mindi molopa ipulueli kepe tangoli kepe Pulu Yemonga popo topa imbi ambolopa ola linjimbendo taki taki langi naa nomba Pulu Yemo kinie ungu nimbe mawa tepa mindi molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simionone Yesusindu ungu nimbe molopili ene moloringine kanu ambomo yu ombalie ⸤Pulu Yemone kanu kangomo Juda yamboma sirimumunge⸥ Pulu Yemo kinie “Ange, papu tekeno.” nirimu. Kanu kinie pe Jerusalleme yamboma lipe taponjipe, umbuni tene ene ambolorumuna mindili nongo moloringi kanu umbunimunge wendo limbendo* ombá yemo ‘Ombá.’ ningu nokoko moloringi yambomando Ana yuni kango akumu orumu mele kinie temba mele kinie nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josepo Mariatolo eltene Ailimunge ungu manetolo nimbe perimu mele pali pilku liku tekololie niringilimuni, elte Yesusi kinie kelko kolea Gallilli disiriki pukulu eltenga kolea kanga Nasarete yando oringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kangomo ai lepa enge nimbe molopa yunge konopuna pilipe konginjili aisili omba pepili molorumu, Pulu Yemone yu kanopa peanga kanopa yu tepa konjirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Juda yambomane ponie tenga tenga kolea aili Jerusalleme ongo akuna suku Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele* pilku ulu mare teringi kanu walema Yesusi anumu lapatolo kepe ‘Kanu walemo piliembili.’ ningulu ponie tenga tenga Jerusalleme olando puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kango Yesusi molopili yu ponie engaki rurepo omba purumu kinie kanu wale ‘Pulu Yemonga wale.’ ningu koro moloringi walemo altopa wendo orumu kinie alieli Juda yamboma Jerusalleme puringi mele Yesusi anumu lapatolo kinie yu kinie pea olando puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","⸤Jerusalleme puku⸥ kanu ulumu piliringi walema pali pora nirimu kinie anumu lapatolo ulkendo pungilí puringili kinie kango Yesusi anju molorumu elte naa kanoringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","‘Olionga yambo mare kinie okomo.’ konopu lelkolo wale telumunge we pukululie niringilimuni, pe ipupini kolea kalá torumu kinie puku aulkena pengendo eltenga pulu lerimu yamboma kinie we yamboma kinie pea puku moloringimendo walsiku piliku andoko kororingili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yu naa kanoko lenjikulie Jerusalleme altoko puku koropuringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wale talo koroko kelkololie niringilimuni, pe wale yepoko sipemonga ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena puku kanoringili kinie yu akuna suku molorumu kanoko lenjiringili. Yu ungu manemanga puluma pilku mane siringi yema* kinie pea moloringi, yuni enenga ungu niringime pilipelie, anju enendo walsipe pilirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yu enene niringime mimi sipe pilirimu mele kepe, pundu topa nimbe konjirimu mele kepe, yambo moloringimene pilkulie enene ‘Yunge pilipe konginjili paa pepamo.’ ningu pilku konopu liku munduku mini wale munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eltene yu kanu ulkena molorumu puku kanokololie suru ningulu anumuni yundu nimbendo: “Kangomo, olto kinie pea pamili ou naa oli, nambemuna tenuye? Lanie olto mini wale mundulipulu nu andopo koropo kelembulu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aku nirimu kinie yuni anumu lapatolondo nimbendo: “Elte ⸤koleamanga pali⸥ nambemuna na andoko korongiliye? ‘Na ya Taranga ulkena molemo.’ konopu naa lengiliye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nakolo yuni nirimu ungu pulumu eltene naa piliringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yu elte kinie Nasarete taono maniendo pupelie nirimumuni, eltenga unguma pilipe tenge panjipe molorumu. Yunge anumuni kanu uluma konopuna panjipe pilipe mindi molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesusi yu ai lemba lerimu kinie yu pilipe konginjili olandopa olandopa pemba perimu; Pulu Yemo kinie yamboma kinie yu kanoko paa peanga kanoko moloringila.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ye Tapiriasi Sisa, Romo gapomanomone nokorumu koleamanga pali, Isirele yambomanga kolea akumanga pali kepe yu ye paa aili kumbinemo molorumu. Yu kanu koleamanga pali Romo ye paa aili kumbinemo molopili ponie tene po omba pupe ponie tene pape sipemo wendo orumu kinie yu aku sipe we molorumu. Kanu poniemonga Pondiasi Paillate kolea Judia disiriki yambomanga ye nomimu molorumu; Erote kolea Gallilli disiriki yambomanga ye nomimu molorumu; Erote angenu Pillipu kolea Ituria disiriki kinie Terekonaitisi disirikitolo yambomanga ye nomimu molorumu; LLaiseniasi kolea Apillini disiriki yambomanga ye nomimu molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ene aku koleama nokoko molangi Anasi kinie Kayapasitolo Pulu Yemo popo tonjiringi ye aili olandopatolo molangili Sekaraya malo Jono kolea ku leline molorumu kinie Pulu Yemone Jono yu ungu umbu tonjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pulu Yemone ungu umbu tonjirimu kinie pilipelie Jono yu pupe no Jodane nekendo yakondo andopa yamboma ungu mane sipelie nimbendo: “Ene ulu pulu keri telemelema kanoko keri kanoko konopu alowa tekolie ‘Pulu Yemone olionga ulu pulu kerime ‘We manie pupili.’ nimbe siye kolopili.’ ningu ‘No liemili.’ ningu wai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","⸤Aku kongonomo Jonone terimu mele yu naa molopili koronga ou yuni yamboma Yesusinge unguma sumbi siku pilku lingí aulkemo lipe nosinjimbe mele⸥ Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane nimbe boku torumu akuna molemo mele i sipe: “Kolea ku leline ⸤kumbi lepa pumbe⸥ ye tenga kerena ungu te nimbendo: “Ailimu ombá aulkemo teko mimi teame. Yu ombá aulke kangama toko sumbi siei.” nikimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Ma pangima akuku kalalu siku, kolo lemomanga akuku pe toko, aulke anekale manekale telemoma toko sumbi siku, aulke ola manie pulimoma kolta lenge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aku tenge kinie Pulu Yemone olio lipe taponjipe ‘Mindili nolemelka aulkena wendo ongo yu kinie pea molko konjingí aulkena pangi.’ nimbe lipe mundumbe yemo yambomane pali kanonge.” nikimu.”* nimbe ⸤Jonone pe temba mele Aisayane ou aku sipe nimbe sipe bokuna torumu molemo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yambo aisili Jono molorumuna ‘Yuni olio no linjipili.’ ningu onge oringi kinie yu kanopalie nirimumuni, ene iri topalie nimbendo: “Kolo topa yamboma tepa kenjili wambiyemonga waloma, Pulu Yemo mumindili kolomba walemonga naene “Ene talopa lelkolie pai.” nimu kinie ene ‘Pulu Yemone naa tepa kenjipili.’ ningu ‘No liemili.’ ningu okomeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ene sumbi siku molko, ulu peangama mindi teko molonge kinie ene ulu pulu keri teringime paa sike munduku kelko konopu alowa tenge mele mona lemba. “Olio anda kolepa Eporayamone kalopa lirimuma molemolomonga yambo peangama molemolo.” ningu aku siku ningu naa pilieme. Nane ene nimbu sikiru: ‘Pulu Yemone i koumando “Eporayamone kalopa lirimu yamboma au leangi.” nilkenje kouma Eporayamone kalopa lirimu yamboma molemelka.’ nikiru. Ene Eporayamone kalopa lirimu yamboma molemelemonga uluri naa telemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Unju peko tomba loumu Pulu Yemone koronga unju puluna ambolopa ola lipe molemo. Unju mongo peanga naa tomba unjuma* yuni peko topalie tepena kalomba.” nimbe Jonone aku nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","⸤Yambo Pulu Yemo kanopa peanga kanolemo ulu puluma naa telemelema Pulu Yemo yuni mongo simbe mele Jonone nimbe sirimu kinie pilkulie⸥ ongo maku toringi yambomane ningindu: “ ⸤‘Yuni olio mongo naa sipili.’ nimbu⸥ nambe temoloye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yuni enendo pundu topa nimbendo: “Wale pakoli talo nosilimele yamboma enene yambo wale pakoli te naa nosingíme moke teko siengi. Langime kepe aku siku teangila.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kou takisi lili yema kepe ‘No liemili.’ ningu oringi. Yuni ungu nirimumu pilkulie yundu walsiku pilkulie ningindu: “Ungu Mane Silimu, olio nambe temolo kinie Pulu Yemo yuni olio kanopa peanga kanombaye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yuni enendo nimbendo: “Ene kou takisi likulie gapomano yuni “Kou i siku liei.” nimbe mako topa simbe mele liengi. Enene kolo toko mare ola panjiku limele aku mele naa liengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kanu kinie ami ye mare yu walsiku pilkulie, “Olio kepe nambe teamiliye?” niringi. Yuni pundu topa nimbendo: “Enene yambomanga kou mone wa lingíndu kolo toko kopene we naa tangi. Gapomanomone mele kalomba koumu mindi liku nosiku, taka lelko molangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jonone terimu mele kanokolie yambomane yu kinie konopu aisili liku munduku, ‘Pulu Yemone olionga anda kolepalimendo “Ene nokopa konjimbe ye te lipu mundumbu.” nirimu ye nomi Kirasimu* i yemonje?’ ningu pilku moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ningu piliringi mele pilipelie Jonone pundu topa enendo nimbendo: “Nane yamboma no mindi linjilio. Nakolo ye te ombámo yuni ⸤Pulu Yemonga⸥ Mini Kake Telimu kinie tepemo kinie ene linjimbe ⸤lingí⸥. I ombá yemo yunge tondolomo paa olandopa, nanga tondolomo paa maniendopa. Na yu kinie manda molo. ⸤Yambo ailimenga kongono keri teli kendemande yambomane sike enenga ailimenga kongono keri tenjingindu kimbu su wendo linjilimele nakolo⸥ ombá yemonga kimbu su wendo linjimbu kanu kongonomo paa olandopa mele nane tenjimbu kapola naa telka, na ye paa keri. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yuni yunge rasi witi apuruli apulu pokomo ambolopalie yunge rasi witi mongo kinie rasi witi kilu kinie apurumbendo molemo. Yunge rasi witi apuruli polomo tepa mimi tembando rasi witi pali ‘wendo liembo.’ nimbe apurupelie mongoma lipe rasi witi nosilimo mingine ‘Lepili.’ nimbe nosimbendo mingi topa, pe kiluma lipe maku topa tepe naa kumbulupe nomba pepa mindi pulimona kalomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","‘Yambomane “Olio yambo molopo kenjilimolo yamboma. Olio ulu pulu kerime mundupu kelepo konopu alowa teamili.” niengi.’ nimbe Jonone yamboma ungu mane aisili aku sipe sipe, temane peangamo topa sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Walse, pe mele, Jonone kolea Gallilli disiriki yambomanga ye nomi kingi Erote iri torumula. Yu angenunge ambo menu Erodiasi ⸤mangopa lirimu⸥ ulumu kinie ulu pulu keri lupe aisili terimuma kinie nimbe para sipe yu iri torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jonone yu iri torumumunge Erotene mumindili kolopalie yu ka sipe ka ulkena panjirimu. Yuni aku terimumu tepa kenjirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","⸤Erotene Jono ou ka naa sipili⸥ yambo aisili Jono no linjipe molorumuna ongo no liringi kinie Yesusi kepe omba no lirimula. No lipelie Pulu Yemo kinie ungu nimbe angilirimu kinie mulumu kengeya lepa anju yando purumu, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pulu Yemonga Minimu, kera waembono mele, manie omba Yesusi molorumuna pupe kangine ola molorumu. Muluna ungu te wendo ombalie nimbendo: “Nu nanga konopu monjilio kangomo. Nu kinie konopu sipu molio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesusi yu mana molopili ponie wane paono tene mele omba purumu kinie yunge kongonomo pulu monjipe terimu. Yambomane Yesusindu ‘Josepo malo.’ ningu piliringi. Josepo yunge lapa Illai. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Illai lapa Matate. Matate lapa LLipai. LLipai lapa Melkai. Melkai lapa Janai. Janai lapa Josepo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josepo lapa Matatayasi. Matatayasi lapa Emosi. Emosi lapa Neame. Neame lapa Esillai. Esillai lapa Nakai. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai lapa Meate. Meate lapa Matatayasi. Matatayasi lapa Semene. Semene lapa Joseke. Joseke lapa Joda. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda lapa Joanane. Joanane lapa Resa. Resa lapa Serapapele. Serapapele lapa Sialtele. Sialtele lapa Nerai. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai lapa Melkai. Melkai lapa Edai. Edai lapa Kosame. Kosame lapa Ellemadame. Ellemadame lapa Ere. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere lapa Josua. Josua lapa Elliesa. Elliesa lapa Jorimu. Jorimu lapa Matate. Matate lapa LLipai. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","LLipai lapa Simiono. Simiono lapa Juda. Juda lapa Josepo. Josepo lapa Jonamo. Jonamo lapa Ellayakimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ellayakimu lapa Mellia. Mellia lapa Mena. Mena lapa Matata. Matata lapa Netane. Netane lapa ⸤Ye Nomi Kingi⸥ Depisi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depisi lapa Jesi. Jesi lapa Opete. Opete lapa Boasi. Boasi lapa Sallimono. Sallimono lapa Nasono. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasono lapa Aminadape. Aminadape lapa Ramo. Ramo lapa Esirono. Esirono lapa Peresi. Peresi lapa Juda. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda lapa Jekopo. Jekopo lapa Aisake. Aisake lapa Eporayamo. Eporayamo lapa Tira. Tira lapa Neyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyo lapa Serake. Serake lapa Reu. Reu lapa Pelleke. Pelleke lapa Epe. Epe lapa Silla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silla lapa Kenane. Kenane lapa Apakisate. Apakisate lapa Seme. Seme lapa Noa. Noa lapa LLameke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","LLameke lapa Metusalla. Metusalla lapa Inoke. Inoke lapa Jarete. Jarete lapa Mallallele. Mallallele lapa Kenane. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane lapa Inosi. Inosi lapa Sete. Sete lapa Adame. Adame lapa Pulu Yemo. Adame Pulu Yemonga malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesusi ⸤no lirimu kinie⸥ Mini Kake Telimu yu kinie omba molopa yunge konopuna molopa paa tengepea tepili no Jodane mundupe kelepalie nirimumuni, Mini Kake Telimuni yu kolea ku leline memba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Akuna Yesusi ⸤Mini Kake Telimu kinie molopili⸥ ⸤kurumanga nomi⸥ depelemo* omba yu kondi topa molopili** oli te koro talo*** omba purumu. Kanu walemanga langi naa noli we molopa perimu kinie yu engelene kolopa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kanu kinie ⸤kurumanga nomi⸥ depelemone yu ⸤kondi topalie⸥ nimbendo: “Nu Pulu Yemonga Malo liemo i kouma ‘Pillawa kaloli au lepili.’ ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nakolo yuni pundu topa nimbendo: “Pulu Yemonga bokumuni nimbendo: “Langimene mindi yamboma konde mololi ulu pulumu naa silimo.”* nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kanu kinie depelemone Yesusi yu lipe memba pupe ⸤ma pangi⸥ paa olana tenga anjipelie, yu ma koleama pali walsikale lipe ora sipelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","yundu nimbendo: “I koleamanga pali tondolomo kinie mele peangama kinie Pulu Yemone nando “Nokoi.” nimbe koronga sirimu. Ime nane ‘Yambo te simbu.’ nindu liemo manda simbu. Nu na popo toko nanga imbi ambolko ola linjinu liemo i tondolomo kinie mele peangama kinie pali nu lieni simbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kanu kinie Yesusini depelemondo nimbendo: “Pulu Yemonga bokumuni nimbendo: “Pulu Yemo enenga Ailimu manjiku popo toko imbi ambolko ola linjiku, yunge kongonomo manjiku tenjiku molangi.”* nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Kanu kinie depelemo yuni Yesusi lipe kolea aili Jerusalleme memba pupe, ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelemonga memba, paa ola imuna memba pupe anjipelie nirimumuni, yundu nimbendo: “Nu Pulu Yemonga Malo liemo nu lipe taponjimbe kene pou ningu manie pui.” ⸤nirimu.⸥ “Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemone yunge mulu koleana angellomane ‘Nu ongo nokangi.’ nimbé. Enene nu ‘Kou tene kepe naa topili.’ ningu nu enenga kimene oko polko lingí.’* nimbe molemo kanumu. Aku sipe nirimu kene pilkulie aku siku tei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesusini yundu pundu topalie nimbendo: “Pulu Yemonga yambomando ungu te pea nimbe molemola. Akumu i sipe: ‘Pulu Yemo enenga Ailimuni “Tembo.” nilimo mele ‘Sike nilimonje molo kolo tolemonje kanamili.’ ningu enene yu manda manjiku naa teangi.’* nimbe molemola kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Depelemone Yesusi kondi pali topa pora sipelie nirimumuni, ‘Pe yu manda altopo kondi tombo wale te nondopo pilipulie kelepo ombo.’ nimbe yu mundupe kelepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kanu kinie Minimunge tondolomone Yesusi kelepa kolea Gallilli disirikindu yando memba orumu kinie akuna andopa terimu mele temanemo koleamanga pali anju anju purumu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yuni Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkemanga pupe ungu mane sirimu kinie yambomane pali yu kapi niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesusi kolea Gallilli disiriki yamboma ungu mane silipe andopalie nirimumuni, yu Gallilli lerimu kolea Nasarete taono ou molopa ai lerimuna kelepa orumu. Ombalie ⸤Juda yambomanga koro moloringi⸥ wale Sambatemonga* koleamanga pali ene maku toko Pulu Yemonga ungumu piliringi ulkemanga yu alieli purumu mele Nasarete ungu piliringi ulke akuna aku sipe purumu. ⸤Maku toko moloringi kinie⸥ yuni “Na bokumu kanopo niembo.” nimbe ola angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","⸤Pulu Yemonga bokuma nokorumu yemone⸥ Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane* koronga ou torumu bokumu lipe sirimu kinie, Yesusini lipe sukundu ungu molorumu te kanopalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“⸤Aisayane i sipe nimbendo:⸥ “Ailimunge Minimu na kinie molemomo yuni nando nimbendo: “Yambo koropama temane peangamo toko siku, ka ulkena pelemele yambomando ‘Wendo ongo we molangi.’ ningu mongo keri leli yambomando ‘Mongo peanga lepili kanangi.’ ningu, mindili nongo molemele yamboma ‘Mindili naa nongo, molko konjengi’ ningu, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Kinié poniena Ailimuni yamboma kanopa kondo kolomba poniemo wendo okomo.’ ningu siliku andoi.” nimbe Minimuni aku sipe ye te mako topalie nirimu.”* nimbe Aisayane nirimu.” nimbe Yesusini aku sipe boku kambu topa nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ungu akumu kanopa nimbe pora sipelie bokumu altopa pipi sipe bokuma nokorumu yemo sipe, ⸤“Ungu te niembo.” nimbe⸥ Yesusi yu manie molorumu. Yamboma pali yu mindi nemo nemo ningu kanoko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kanu kinie yuni enendo nimbendo: “Kinié Pulu Yemonga bokuna ungumu kanopo nindu pilíngi akuna Aisayane “Wendo ombá.” nimbe, ou nirimu mele kinié wendo okomo. ⸤Kinié na tembo okoro ulu akumanga ou nirimu.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Moloringi yambomane “Yu ye peangamo. Yu paa telemo.” ningu yu nirimu mele pilkulie “Paa nimbe konjikimu.” ningulie mini wale munduringi. ⸤Nakolo⸥ enene ningindu: “I yemo ⸤yu nae konopu lekemoye?⸥ Yu Josepo malo mindi, ⸤olionga we ye te mindi lemo⸥.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","⸤Nakolo⸥ Yesusini ⸤yuyu molorumu mele nirimu kinie pilkulie yu konopu keri panjiringi mele pilipelie⸥* enendo nimbendo: “Ungu iku tolemelemanga te nando toko ningí teko molemelenje konopu lekero. Enene nando i siku ningí tekemelenje: “Nu sike doketa moleno liemo nu kuru tomba kinie nunge maratenemo nunu liku nani. Pe nu konde puni ⸤kinie kanopolie ‘Nu sike doketa moleno lemo.’ nimbu pilimulú.” ningu aku ungu ikumu na toko singí tekemelenje?⸥ Nando ningindu: “Nuni Kapeniame taono ulu tondoloma terinu pilirimulu mele ya nunge pulu kolea ⸤Nasarete⸥ akuna aku siku teani. ⸤Kanopolie nu “molio.” nikinu mele ‘Sike nikinu lemo.’ nimbu pilimolo.⸥” ningí tekemelenje? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Nane enendo sike nimbu sikirumu: Yambomane ulu pulu te telemele mele i sipe: Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye tene yunge pulu koleamonga yamboma ungu nimbe silimo kinie pilkulie nilimelemone, enene ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo unguma naa pilku liku su silimele. ⸤Kolea lupe yambo marene ongo ungu ningu silimele kinie aku unguma mindi pilku limele. Yambomane aku siku telemele mele enene aku sikula telemele.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","‘Nane paa sike nimbu sikiru mele ene piliengi!’ nimbu ⸤temane talo tambo.⸥ “Illainja Pulu Yemone ungu umbu tonjirimuma pilipe ⸤yunge pulu lerimu⸥ Isirele yamboma nimbe sipe molopili ulu te wendo orumumu niembo. Pulu Yemone “Lo naa opili.” nirimu kinie ponie yepoko kelepa oli kise talo pakara lo naa omba paa engele lerimu kinie Isirele koleana sukundu ambo waye aisili ⸤engelene kolko⸥ moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nakolo Pulu Yemone “Isirele ambo waye te liku taponjiku langi sieni.” nimbe Illainja akuna naa lipe mundurumu. ⸤Isirele ulsukundu lerimu⸥ kolea aili Saidono nondopa lerimu kolea kanga Sarepate ambo waye te ⸤‘Langi pora naa nipili.’ nimbe Pulu Yemone kanu ulsukundu ambomo⸥ molorumuna Illainja lipe mundurumu kanumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Illaisia kepe ou Pulu Yemone ungu umbu tonjirimuma pilipe ⸤yunge pulu lerimu Isirele yamboma⸥ nimbe sipe molopili Isirele koleana sukundu yambo aisili kuru kendi norumu, nakolo ene pali telu kepe konde naa puringi, kuru kendi nomba we perimu. ⸤Kolea Isirele ulsukundu lerimu⸥ kolea Siria ye Nemana mindi kuru kendi norumu kinie Illaisiane yu ⸤lipe taponjipe⸥ tepa konde lirimu.* ⸤Pulu Yemone Illainja kinie Illaisiatolo lipe mundurumuna ulsukundu yambo talo aku siku liku taponjiringili nikiru mele paa sike nikiru piliei.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aku sipe mele nirimu kinie pilku keri pilkulie Pulu Yemonga ungumu piliringi ulkena sukundu moloringi yamboma pali paa lakoko mumindili koloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mumindili kolkolie ola angilku yu kanu koleana ulsu toko pulu siku munduku, kanu koleana nondopa kopó te lerimuna toko manie mundungí teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nakolo yu ene maku toko angiliringine sumbi sipe pupe tenga lupe pumbe purumu, yu manda naa amboloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kanu kinie Yesusi yu kolea Gallilli disiriki lerimu taono te Kapeniame akuna maniendo purumu. Akuna ⸤Juda yambomanga koro moloringi⸥ wale Sambatemo* wendo orumu kinie Yesusi ⸤Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke kanuna suku pupe⸥ ene ungu mane sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mane sirimu kinie yu namba lerimu yemane pipili naa kolko tondolo munduku mane siringi mele yuni aku sipe mane sirimuna pilkulie yambomane mini wale munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kanu kinie ulke kanuna suku kuru te ye tenga konopuna molopa ya ambolorumu ye te molorumu, ⸤yemonga konopuna suku molorumu kanu kurumuni yu “Ungu ni.” nimbe tópe sirimuna⸥ opa ungu tondolo mundupe nimbelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kolea Nasarete ye Yesusi, nu pea olio ⸤kuruma⸥ kinie teluna tapu topo manda naa molomolo. Nu olio kinie nambemuna onuye? Nu olio toko konjini onuye? Nane nunge imbi pilio. Nu Pulu Yemonga Ye Kake Telimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","⸤Aku sipe nirimuna pilipelie⸥ Yesusini kanu kurumu iri topalie yundu nimbendo: “Nu ungu naa ningu yemonga konopuna ongo wendo pui!” nirimu kinie kurumuni yemo topa manie mundupelie omba wendo purumu. Yemo yu uluri naa terimu, we manda molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","⸤Yesusini aku terimu kanokolie⸥ yamboma suru ningu, mini wale munduku, enene eneno anju yando ningindu: “I ulumu nambolka uluri tekemonje? Ungu mane konde te wendo ombámo. Ye namba leli tene we yambomando “Teai.” nilimo mele i yemone kurumando kepe aku sipe nilimo kinie kanu kuruma yunge ungumu pilku liku wendo olemele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kanu kinie yuni aku sipe terimu mele temanemo kanu koleamonga sukundu lerimu koleamanga pali anju anju purumu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kanu kinie kanu maku toko Pulu Yemonga ungumu piliringi ulkemo Yesusi mundupe kelepa pupelie nirimumuni, Yesusi Saimononga ulkena suku purumu. Akuna Saimononga kolepa ambomo kuru topa kangi nomba konjipili lerimuna Yesusindu “Liku taponji.” ningu mawa teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aku siku yu mawa teringi kinie ambomo lerimuna pupe angilipelie nimbendo: “Kangi manda noi.” nirimu kinie kangi nomba kelerimu. Ambomone sumbi sipe ola angilipe wendo ombalie, oringi yema langi sipe nokopa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kanu walemonga ipupini, ena pumbe purumu kinie, kuru lupe lupe torumu yamboma Yesusi molorumuna mengo oringi kinie kanu yamboma ene yu mele mele kini ambolopalie ene pali tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","⸤Konopuna kuru molorumu⸥ yambo aisili ⸤oringi.⸥ Kanu kuruma⸤ndo “Ongo wendo pai.” nirimu kinie⸥ ongo wendo puku ru ningulie ningindu: “Nu Pulu Yemonga Malo moleno.”* niringi. Kurumane yu aku siku imbi sikulie yu ⸤Pulu Yemone mako topa lipe mundurumu ye nomi⸥ Kirasimu** molorumu mele piliringine yuni ene iri topa “Molio mele anju ningu naa siei.” nimbe enenga kerema pipi sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ipulueli ou Yesusi ola molopa penando pupe kolea ku leli tenga purumu kinie yambo aisili yu koroko yu molorumuna ongo yundu ningindu: “Olio kinie pea kamu molamili. Tenga naa pui.” ningu mawa teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yuni enendo pundu topa nimbendo: “⸤Pea molamili mangali⸥ kolea wemanga pea pupu, Pulu Yemo omba ye nomi kingi molomba* temane peangamo topo silipu andombo. Akumunge na yando lipe mundurumu kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aku nimbelie yu pupe kolea Gallilli ⸤disiriki⸥ sukundu andopa, kolea lupe lupemanga pupe Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkemanga pupe kanu temane peangamo topa silipe andorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Walse, Yesusi nomu Geneserete, ⸤akumundu ‘Nomu Gallilli’ niringila kanumu,⸥ aku nomu kélona angilipe yamboma Pulu Yemonga ungumu nimbe sirimu kinie pilingindu ene yu angilirimuna puku maku toko nondoko nondoko puku ekelepa teko molko piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kanu kinie yuni nona andoli sipi talo nomu kélona lerimutolo kanopalie, oma lili yema koronga nomu kélona wendo puku enenga oma lili walema kulumiye toko moloringi kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sipi te Saimono Pitanga, akuna sukundu pupelie yuni yundu mawa tepalie nimbendo: “Sipimu laye kolte paka toko nona sukundu mundoi.” nirimu. Paka topa nona sukundu mundurumu kinie aku sipimunge suku yu manie molopalie nirimumuni, no kélona liku maku toko moloringi yamboma ungu mane sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ene ungu mane sipe pora sipelie yuni Saimonondo nimbendo: “Sipimu nomu ai suku singine kunduku mengo pukulie oma lili walema nona manie mundu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimonone pundu topa nimbendo: “Ye Nomimu,* sumbulu telu oma lili kongono tondolo mundupu tepo molopo tangonjipulie** oma te paa naa límulu. Nakolo aku nikinu kene walemo nona manie mundembo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kanu kinie walema nona manie munduringi kinie oma aisili walemanga sukundu puringine walema nomu sipine sukundu lingí teringi kinie sungu nimbé terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Walema sungu nimbé terimu kanokolie enene enenga oma lili kongono pea tapu toko teringi yema, sipi tenga moloringime walsikulie “Ongo liku taponjengi wai.” niringi. Oringi kinie sipi talo pea peke siringi umbuni tepa nona manie pumbe terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aku ulumu kanopalie Saimono Pita Yesusinge kumbikerena omba manie molopa tamalu pepalie nimbendo: “Ye Ailimu,* na ulu pulu keri ambololi yemo ⸤nu kake teli yemo⸥. ⸤Teluna molkombolo kapola naa tekemo⸥ kene anju puku nu lupe moloi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yu kinie, yu kinie pea moloringime kinie, enene oma aisili walsikale tangoli liringi kanokolie ene suru ningu mini wale munduringine ⸤Saimonone aku sipe nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Seperinge malo Jemisi kinie Jonotolo elte Saimono Pita kinie kongono teluna tapu toko teringili yetolo, elte pea mini wale munduringilila. Kanu kinie Saimonone nirimumu pilipelie Yesusini yundu nimbendo: “Nu pipili naa koloyo. Kinié oma linindu oma lili wale liku nona manie mundulino kinie omama walena omba pelemo mele, pe nanga kongono tenjinindu nanga ungumu pilku ningu siliku andoni kinie yamboma nanga talapena sukundu ongo molonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kanu kinie enenga sipitolo nomu kélona mengo ulsu ongolie, sipitolo melema pali lepili munduku kelko Yesusi lombili puringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","⸤Kolea Gallilli disiriki sukundu lerimu⸥ koleamanga tenga Yesusi molorumu kinie ye te kuru kendi aili tepa nomba perimumu omba Yesusi kanopalie manie molopa tamalu pepa yu mawa tepalie nimbendo: “Ailimu, nunge konopumuni na ‘Konde pambo.’ konopu lenu liemo nuni na manda teko konde lini.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusini yemo kini ambolopalie yundu nimbendo: “‘Nu konde pani.’ konopu lekero kene konde pui.” nirimu kinie tamburembu kuru kendimu nomba kelerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kanu kinie Yesusini yu ungu te tondolo mundupe nimbendo: “Nuni ya ulu tekeromo yambo telurindu kepe paa naa ni! Sumbi siku puku Pulu Yemo popo tonjili yemo nunge kangimu liku ora siku, ‘Na altopo kangi peanga lepili molkoro kene.’ ningu Mosisini “Tei.” nimbe ungu mane sirimumu* pilku liku tenindu “Pulu Yemo popo toko kalko si.” nirimu melemo liku Pulu Yemo popo tonjili yemondo “Kalonji.” ningu yu sieni. Pe yambomane nu kanokolie ‘Yu sike kangi peanga lepili molemo.’ ningu piliengi kene nikiru mele isili ou tepui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nakolo yuni terimu mele anju anju yambo aisilini pilkulie niringimuni, yu molorumuna sukundu sukundu ongo yu temane peanga topa nirimumu pilingindu ongo, yuni ‘Ene tepa konde lipili.’ ningu oringi kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","yu ene oringine mundupe kelepa kolea ku leli tenga pupe Pulu Yemo kinie ungu nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Walse Yesusi yuni yamboma ungu mane sipe molorumu. Kuru toli yamboma tepa konde lili tondolomo yu kinie pepili molorumu. Pulu Yemone kanu tondolomo yu sirimu. Parisi yema kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* yu ungu mane sirimuma pilku moloringila. Kanu yema, kolea Gallilli disiriki sukundu lerimu koleamanga moloringime kinie, kolea Judia disiriki sukundu lerimu koleamanga moloringime kinie, kolea aili Jerusalleme moloringime kinie, Yesusi molorumuna ongo maku toko yu ungu mane sirimuma pilku moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Yu molorumuna ye marene kimbu ki kolopa pora sirimu ye te taropola teko mengo onge oringi nakolo yambo aisili ulke kerepuluna ekelepa teko angiliringine ulkena suku Yesusi molorumuna nondoko mengo pungí aulke te naa kanokolie niringimuni, ulke imuna mengo ola pukulie* Yesusi molorumuna ⸤kana kana ulkemo tekisikulie⸥ yemo taropola pali moko toko manie munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","‘Yesusini i yemo manda tepa konde limbe.’ ningu tondolo munduku pilkulie yu mengo oringi kanopa pilipelie Yesusini kanu yemondo nimbendo: “Kangomo, nunge konopuna ulu pulu keri terinu pelemoma manie pupili, we siye kolkoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisi yema kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, Yesusini aku nirimu pilkulie ⸤pilku keri pilku⸥ konopu kimbú sikulie, “I ye Pulu Yemo marake tekemo yemo naeye? Yambomane ulu pulu keri telemelema naene ‘Manie pupili, we siye kolkoro.’ manda nimbeye? Pulu Yemone mindi manda telemo.” ningu eneno ningu pilku molko konopu kimbu siringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kanu kinie Yesusini ene aku siku konopu kimbú siku moloringi mele pilipelie enendo nimbendo: “Enene ⸤nane nikirumunge⸥ aku siku nambemuna konopu kimbú sikimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","I yemondo “Nunge ulu pulu kerime manie pupili, we siye kolkoro.” nimbú kinie ene ulu te naa kanokolie ‘We we tepa nikimu.’ konopu lengeye? Molo “Ola angilku nunge kunungumu liku mengo kimbu kongono teko andoi.” nimbú kinie yu ola angilimbene naa angilimbenje mona lemba manda kanokolie ‘Aku sipe mindili sipe nikimunje?’ konopu lengeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nakolo ‘ ‘Manie Omba Mana Ye Au Lerimu Yemo tondolo pelemomone ya ma koleana yambomanga ulu pulu kerime “Manie pupili, siye kolkoro.” manda nimbé.’ ningu piliengi!’ nimbu ⸤aku sipu nindu⸥.” nirimu. Aku nimbelie kimbu ki kolopa pora sili yemondo nimbendo: “Nane ‘Nu ola angilku nunge kunungumu liku mengo ulkendo pui.’ nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aku nirimu kinie ene kanoko molangi yemo sumbi sipe ola angilipe yunge kunungumu lipe memba omba pena pupelie Pulu Yemo kapi nilipe ulkendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","⸤Yu aku terimu kanokolie⸥ ene suru ningu mini wale munduku Pulu Yemo paa pipili kolko yunge imbi ambolko ola linjiku yu kapi ningulie ningindu: “Olio i ulu wendo okomo kanokomolomo ulu paa te lupe lepamo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kanu kinie Yesusi ⸤ulkemo mundupe kelepa⸥ pena pupelie nirimumuni, kou takisi lirimu ye te, yunge imbi LLipai, kou takisi lipe molorumu kanopalie yundu “Na kinie pea pambili lombili oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kanu kinie LLipai yu ola angilipe kou takisi melema we lepili mundupe kelepa yu lombili purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pe LLipaini yunge ulkena Yesusinge langi aisili kalonjirimu. Akuna kou takisi lili ye aisili kinie, we ye mare kinie, ene Yesusi LLipaitolo kinie pea manie molko kanu langime noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aku teringi kanokolie Parisi yema kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* enene Yesusi yu lombili andolimendo ningindu: “Ene kou takisi lili yema kinie ulu pulu kerime teli wema kinie ene pea nambemuna langi nokomeleye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aku siku niringi pilipelie Yesusini enendo nimbendo: “Kuru naa tolemo yamboma doketana naa pulimele. Kuru tolemo yamboma mindi doketana pulimele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nane ‘Yambo sumbi nilime na molombona wangi.’ nimbundu ma koleana naa orundu.* Ulu pulu keri teli yamboma ⸤lipu taponjipu⸥ enendo ‘Ene ulu pulu keri telemelema kanoko keri kanoko konopu alowa teko ⸤na molombona wangi⸥.’ nimbundu orundu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","⸤Kanu kinie⸥ enene Yesusindu walsiku pilkulie ningindu: “⸤No Linjili⸥ Jono lombili andolime kinie, Parisi yema lombili andolime kinie, enene walse walse langi mi toko naa nongo* Pulu Yemo kinie mawa telemele nakolo nu lombili andolimene aku siku naa telemele, langi kinie no kinie we nolemele. ⸤Pe nu lombili andolimene telemele mele papuye⸥?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aku siku niringi pilipelie Yesusini pundu topa enendo ⸤ungu iku te topa yu kinie ulu te wendo ombá mele nimbelie⸥ nimbendo: “Ambo limbe ye te yunge pulu lemo yema kinie molemo kinie ene konopu sikulie “Langi mi topo naa namili.” manda ningíye? Manda naa ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe mindi, ambo limbe yemo* ene molongena ongo wendo lingí kinie kanu walemanga sike ⸤konopu keri panjiku⸥ langi naa nongendo mi tonge. ⸤Isili ou molo.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesusini aku nimbelie nirimumuni, ⸤‘Ou Juda yambomane ulu teringi uluma kinie pe ulu konde wendo okomomo kinie teluna manda naa pengele mele paa piliengi!’ nimbe⸥ ungu iku talo topalie nimbendo: “Mulu wambale ou te sungu nilimo kinie olione mulu wambale paa konde tenga te kopisipu lipu, sungu nilimomonga naa topo tambululimolo kanumu. Yambo tene aku sipe topa tambulkenje kanu mulumbalemo nona panjilke kinie mulu wambale konde kopisilimu kanga lepa lli nimbelie mulu wambale oumu kelepa kamu aili tepa sungu nilke. Ulu te i sipela: Mulu wambale oumu kinie mulu kopisili kondemo telu sipe molo akumunge kapola kapola molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kongi meme kalumuni teli mingi ou tenga* no waene konde naa kolemolo kanumu. Yambo tene mingi ou tenga no waene konde te kolkanje kanu no waenemo mingine sukundu pepalie pe akolka kinie kanu mingi oumu naa akopa sungu nilke. Kanu kinie nomo kepe mingimu kepe kamu keri lelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Akumunge no waene konde kongi meme kalumuni teli mingi kondena mindi kolemolo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ye tene no waene ou te nombalie kanu waene oumu nomba peanga pilipelie no waene konde waka naa kolemo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Walse, ⸤Juda yambomanga koro moloringi⸥ wale Sambate tenga, Yesusi kinie yu lombili andolime kinie rasi witi poniemanga ongo puringi kinie yu lombili andoli yemane* rasi witi mongo mare nongendo inie toko liku kilu toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aku teringi kanokolie Parisi yemane* Yesusi yundu ningindu: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa teangi.’ nimbe pelemo ungu manemo** nambemuna nunge lombili andoli yemane ungu manemo pulue tokolie aku siku tekemeleye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesusini pundu topa nimbendo: “Ene Pulu Yemonga bokuna sukundu ⸤anda kolepa ye nomi kingi⸥ Depisini* terimu mele nimbe molemo temanemo kanokolie temanemonga pulumu naa pilimeleye? Depisi kinie yu pea puringi yema kinie ene engelene kolkolie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Depisi Pulu Yemo molorumu sele ulkena sukundu pupe, Pulu Yemonga kumbikerena lerimu pillawa kalolime lipe nomba, yu pea puringi yema sirimu noringila kanumu.* Kanu pillawa kalolimendo Pulu Yemone ungu mane sipelie nimbendo: “We yambomane paa naa nangi. Pulu Yemo popo tonjili yema manjiku nangi.”** nirimu ⸤kanu ungu manemo pulue torumu⸥ kanumu. ⸤Ene konopu talo nambemuna lemeleye? Depisi yuni ou aku terimu mele ene pilku keri naa pilimelemonga pe kinié na lombili andoli yemane tekemele mele kanoko keri naa la kanai.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Manie Omba Mana Ye Au Lerimu Yemone Sambate walema nokolemona ⸤Sambate wale kinie yamboma molko konjingindu tenge mele manda nimbé kanumu⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pe walse, koro mololi wale Sambate tenga, Yesusi omba Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulkena suku pupelie ungu mane sirimu. Kanu ulkena ye te molorumu, yunge ki umbukundu kamu kolopa kukurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kanu kinie akuna moloringi Parisi yema kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* enene ‘Yesusini ulu te tepa kenjimbe kinie yu kote tenjimulú.’ ningu ulu te tepa kenjimbe te ⸤alieli koroko molkolie⸥ ‘⸤Koro molemolo⸥ wale Sambate kinie yuni yemo tepa konde limbenje.’ ningu yu mimi siku kanoko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ene konopuni piliringi mele pilipelie Yesusini kanu ki kolopa kukurumu yemondo nimbendo: “Yamboma molemelena ongo ola angilieni.” nirimu kinie yemo yu akuna omba ola angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kanu kinie yemando nimbendo: “Ene i sipu walsipu pilkiru. ‘Sambate wale kinie ulu nambolka ulu te manda temoloye? ‘Sambate walemonga ungu manemone “Teangi.” nilimo mele teamili.’ nimbu yamboma lipu taponjimulú kinie manda molo tepo kenjimulú kinie mandaye? ‘Naa kolangi. Konde pangi.’ nimbu temolomo manda molo topo konjimulúmu mandaye?’ nimbu walsikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aku sipe ene nimbe walsipelie yuni ene pali nemo nemo nimbe kanopalie ki kukuli yemondo nimbendo: “Nunge kimu sinio si.” nirimu kinie yemone yunge ki sinio sirimu kinie ki kolopa kukurumumu altopa kamu peanga lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aku terimu kanokolie mumindili aili teko kolko enene eneno anju yando ungu mele teko ningindu: “Tepa kenjikimumunge yu nambe teamiliye?” ningu moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pe walse ipulueli Yesusi yu Pulu Yemo kinie ungu nimbendo ma pangi tenga ola pupe Pulu Yemo kinie ungu nimbe molopili kolea tangorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ipulueli ou yu lombili andolimendo “Wai.” nimbelie ‘Enenga ye engaki rurepo nanga kongonomo teangi lipu mundembo.’ nimbelie aku yema mako topalie enendo nimbendo: “Ene ‘Nanga kongonomo tenjipangi.’ nimbu lipu mundukuru yema.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","⸤Kanu ye engaki rurepo mako torumumanga imbime i sipe:⸥ Saimono (yunge imbi te Pita) yu keme, Pita angenu Enderu keme, Jemisi keme, Jono keme, Pillipu keme, Batollomiu keme, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateyu keme, Tomasi keme, Allapiasinge malo Jemisi keme, “Olio Juda yamboma oliolio gapomano molamili.” niringi talape ye Saimono keme, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemisi malo Judasi keme, Judasi Isikeriote, Yesusi pe lipe opa touma sirimu yemo keme, ⸤aku yema ‘nanga kongono tenjipangi lipu mundukuru.’ nimbe mako torumu yema⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kanu kinie yu kinie, yuni “Nanga kongonomo tenjipangi.” nimbe lipe mundurumu yema kinie, ma pangine manie oringi kinie yu lombili andoringi yambo aisili kinie, kolea Judia disiriki moloringi yambo aisili kinie, kolea aili Jerusalleme peringi yambo aisili kinie, nomu kusa kélona lerimu kolea aili Taya kinie Saidonotolonga peringi yambo aisili kinie, yu molorumuna sukundu sukundu ongo liku maku toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yu temane peanga topa, ungu mane sipe terimu pilingindu ongo, yuni ene kuru torumuma ‘Tepa konde lipili.’ ningu oringi. Enenga yambo mare konopuna kuru keri molorumuma tepa konde lirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yamboma tepa konde lili tondolomo yu pepili molorumuna ene oringime pali ‘Yu ambolamili.’ ningu yu molorumuna nondoko nondoko oringi. Kanu kinie ongo yu amboloringi kinie kanu tondolomone ene pea pali tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kanu kinie Yesusi manie molopa yu lombili andoringime olando sipe kanopalie enendo nimbendo: “Ene koropa pulimoma Pulu Yemo enenga ye nomi kingimu molopa ene nokolemomonga* ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ene kinié engele telemoma ene pe walse olo tembamonga ene malo. Ene kinié kola telemelema ene pe walse tae tengemonga ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Manie Omba Mana Ye Au Lerimu Yemo pilku molemele yamboma, ene nanga yamboma molemelemonga we yambomane ene kinie konopu keri panjiku, “Olio molemolona anju pai.” ningu, enendo “Ene yambo kerime.” ningu, ningu kenjiku, enenga imbime pilku keri pilku tenge kinie ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“⸤Yambomane ene aku siku mele telemelemonga⸥ ene mulu koleana pungí kinie kanuna ⸤Pulu Yemone⸥ ene mele kalopa konjimbe kene ⸤kanu yambomane ene aku siku teko kenjingí⸥ kinie konopu aili teko siku, konopu paa peanga pepili molangi.* Yambomane kinié ene mindili silimele mele, aku siku ene naa molangi koro ou Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siliku andoringi yamboma we yambomane ene kepe mindili siringila kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nakolo ene kamako lemelema, ou kinié ene molko konjiku konopu peanga pepili molemele melema koronga nosilimele, pe aku siku naa molongemonga mindili nongo molko kenjingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ene kinié olo telemo yamboma pe walse engelene kolongemonga mindili nongo molko kenjingí. Ene kinié tae telemele yamboma pe walse ene kola tengemonga mindili nongo molko kenjingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","We yambomane pali ene kapi ningu taki taki enendo “Yambo peangama.” ningí kinie ene mindili nongo molko kenjingí. Kanu yambomane enendo ungu peangama ningu kapi ningí mele ou ene naa molangi koro ou Pulu Yemone ungu umbu tonjirimuma naa pilku we kolo toko yambo ningu siringi yambomando i yambomanga anda kolepalimene ungu peangama aku siku niringila. Pulu Yemonga unguma sumbi siku niringi yambomando kapi naa ningu mindili siringi kanumu.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","⸤Aku nimbelie Yesusini we moloringi yambomando nimbendo:⸥ “⸤Akumu na lombili andolimendo nikiru⸥ nakolo nane ungu nikiruma pilku molemele yamboma, enendo ungu te pea niembo piliengila! Enene enenga opa touma konopu monjiku, ene kinie konopu keri panjilimele yamboma teko konjiku teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Enendo ‘Yambo kerime kene molko kenjengi!’ nilimele yambomando ‘Ene yambo peangama kene molko konjengi.’ niengi. Ene teko kenjilimele yamboma ‘Pulu Yemone lipe taponjipili.’ ningu enene enenga mawa tenjengi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Yambo tene nunge kumbikere ekendonga laruwe tomba kinie topele toko ‘ekendonga kamu laruwe topili.’ nieni. ‘Nunge wale sulu peangamo liembo.’ nimbé yambomo nunge wale pakolimu kepe ‘pea we lipili.’ nieni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Melema si.” ningu mawa tenge yamboma pali melema we sieni. Nunge melema we limbe yambomondo “Altoko nanu si.” ni naa nieni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“‘Yambomane nu kinie teangi.’ konopu leno mele, nuni anju yamboma aku siku teani.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ulu pulu keri telemele yamboma kepe eneno anju yando kondo kolemele pilkulie ene yando kondo kolemele yamboma mindi kondo kolonge manda molo. Ene kanoko keri kanolemele yamboma pea kondo kolangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ulu pulu keri telemele yamboma kepe eneno anju yando kondo kolko teko konjilimele pilkulie ene yando kondo kolko teko konjilimele yamboma mindi teko konjingí manda molo. Ene teko kenjilimele yamboma pea teko konjengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ulu pulu keri telemele yamboma kepe eneno anju yando pundu anjiku, ‘Walse altopo sukundu limbu’ ningu pundu anjilimele pilkulie, ene yando pundu tolemele yamboma mindi pundu anjingí manda molo. Ene pundu naa tolemele yamboma pea pundu anjengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“⸤Ulu pulu keri telemele yamboma eneno anju yando telemele mele ene ulu te olandopa teangila.⸥ Enene enenga opa touma kepe kondo kolko, teko konjiku, pundu anjiku, teangi. ‘Enene pe walse altoko aku siku yando teangi.’ ni naa ningu, we teangi. Aku siku tenge kinie Pulu Yemonga ambolangoma molkolie,* yuni ene mele aisili kalomba lingí. Pulu Yemo yuni mana yamboma kinie aku sipe tepa molemola. Yu teko kenjilimele yamboma kinie, yundu ‘Ange.’ naa ningu we molemele yamboma kinie kanuma tepa konjilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Enenga Lapa Pulu Yemo teko kenjilimele yamboma kepe yu aku sipe kondo kolopa we tepa konjilimo mele ene teko kenjingí yamboma aku siku kondo kolko teko konjengi.” ⸤nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Enene yamboma telemele uluma naa apurungí kinie ⸤Pulu Yemone⸥ ene ulu telemelema naa apurumbela. Enene anju yambomane telemele mele apuruku kanokolie “Teko kenjikimili. Tekemele mele ⸤Pulu Yemone⸥ kanopa keri kanopili.” naa ningí kinie ⸤Pulu Yemone⸥ enene telemele mele apurupe kanopalie “Teko kenjikinu. Tekeno mele kanopo keri kanokoro.” naa nimbéla.* Yambomane ene kinie teko kenjingí uluma ‘Manie pupili.’ ningu siye kolonge kinie ⸤Pulu Yemone⸥ enenga ulu pulu kerime ‘Manie pupili.’ nimbe siye kolombala.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Enene yamboma pe pe kepe ‘Pundu naa tangi.’ ningu melema we singí kinie yuni ene aku sipe we simbela. Melema simbendo layetolo naa simbe; olandopa olandopa simbe. Enene anju singí kanopalie ene yando aku sipe simbela.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesusini enendo ungu iku wallo te topa sirimula. Akumu i sipe: “Mongo keri leli ye tene mongo keri leli ye te aulke manda lipe ora simbeye? Peatolo kombuna manda naa tolkaye?* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ungu mane pilku mololi yamboma enenga ungu mane silimu toko manie naa mundulimele. Ou ungu mane pilku puku pora silimele kinie pe mindi enenga ungu mane silimu pea kapola kapola mele molemele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nuni angenanga mongona nurupulu te lemo kanoleno nakolo nunge mongona unju aili te lemomo naa kanoleno akumu nambemuna telenoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nunge mongona unju aili lemomo naa kanokolie angenando “Ano, nunge mongona nurupulu te lemomo wendo linjembo.” nambe teko nilinoye? Topele mapele toli yambomo,* nuni nunge mongona lemo unju ailimu ou wendo likulie pe kanoko konjiku angenanga mongona lemo nurupulumu manda wendo linjini.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","⸤Kanu kinie Yesusini ungu te pea nimbelie ungu iku pokore topalie nimbendo:⸥ “Unju peangamone mongo keri te manda naa tomba; unju kerimuni mongo peanga te manda naa tombala. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Unju mongo te kanokolie kanu mongo torumu unjumu imbi manda silimele.* ‘Amu nambo.’ ningu, takeme manda olko toko naa nolemelka. Molo ‘Me te nambo.’ ningu, silipu manda mengo naa nolemelka. Amu lupela takeme lupela kanoko, me lupela silipu lupela kanolemele kanumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aku sipe mele, yambo peanga tene yunge konopuna ulu peanga pelemoma telemo, nakolo yambo keri tene yunge konopuna ulu keri pelemoma telemo. Yambo te yunge konopuna pelemo unguma mindi kerena nilimo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nane nilio unguma pilku liku naa tekolie enene nando “Ailimu” we nambemuna nilimeleye?” ⸤nimbelie pe yuni ungu iku te pea enendo topa nimbéndo:⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“I nanga unguma pilku liku tenge yamboma ene ye te molemo mele niembo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ye te yuni yunge ulkemo ‘Ingi nimbe angilipili.’ nimbe we ma kinie okia kinie akupe ele tepalie, akuna manie kou polona ola takorumu. Ulkemo aku sipe takopa konjirimuna pe no topa ulkemo paa topa kalalu simbe terimu kinie topa tekisi naa tekisipe ingi nimbe we angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Nakolo i nanga unguma pilku liku naa tenge yamboma ene ye te molemo mele niembo: Ye te yunge ulke we ma pange teline ola walu takorumu. Pe no topa ulke kanumu topalie ulkemo walsikale kamu topa kalalu sirimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yamboma piliengi kanu unguma nimbe pora sipelie Yesusi Kapeniame taonona sukundu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akuna Romo yambomanga ami ye wane anderete nokorumu ye tenga kendemande te yu paa konopu monjirimumu kuru aili tepa topalie yu kolomba tepa lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kanu ami ye nomimuni Yesusi orumu pilipelie yuni Juda tapu ye mare* lipe Yesusi molorumuna mundupelie nimbendo: “Nanga kendemandemo ⸤kuru aili tepa tomu kene⸥ ongo teko konde li.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Kanu Juda tapu yemane Yesusi molorumuna ongo aku siku ningu, yunge ningu tondolo munduku mawa tenjikulie ningindu: “I kendemande kolkomomonga ami ye nomimu yu paa peanga. ⸤Yu Juda ye te molo⸥ nakolo olio Juda yamboma konopu monjipe, olio maku topo Pulu Yemonga ungumu pilimolo ulkemo yuni takonjirimu kene nuni yu liku taponjinu liemo papu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aku niringi pilipelie Yesusi ene kinie kanu yemonga ulkena pumbe purumu. Kanu ulkemonga nondopa orumu kinie kanu ami ye nomimuni yunge pulu lemo yambo mare Yesusi orumuna lipe mundurumu ongolie yundu ningindu: “Ami ye nomimuni i sipe nikimu: “Ailimu,* na ye kerimu mele molio, nu nanga ulkena oni kinie kapola naa temba kene nu mindili siku ya naa wani. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Nu molenona na ye kerimu manda naa ombóla konopu lendu. Na ye tene kepe nokopa molemo, yunge ungumu pilipu lipu telio. Nane kepe ami ye mare nokopo molio. Kanu yemanga tendo “Pui.” nilio kinie yu pulimo. Molo tendo “Oi.” nilio kinie yu olemo. Molo nanga kongono tenjili kendemande yambo tendo “I siku tei.” nilio kinie yu aku sipe telemo kanumu. Aku sipela, nuni ungu te we nini kinie nanga kendemande ⸤yemo⸥ we konde pumbe kene nu we ni.” nikimu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusini Romo ami ye nomimuni nimbe mundurumu mele pilipelie yu konopu aisili lipe mundupelie yu lombili oringi yambomando nimbendo: “Nane enendo paa sike nimbu sikirumu: I Isirele yambomanga talapena ulsu mololi yemone na ungumuni mindi manda temba mele nimbe tondolo mundupe pilimo mele koleamanga pali, Isirele koleana sukundu kepe, yambo telurini kepe aku siku piliringi mele paa naa kanorundu.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aku nirimu pilkulie ami ye nomimuni Yesusi molorumuna mundurumu yema kanu ami yemonga ulkena yando ongolie kendemandemo konde purumu kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesusi Nene taonondo purumu, yu lombili andolime kinie yambo mare aisili kinie pea puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yu taono pala kerepuluna nondopa purumu kinie Nene ye te kolorumumu ono tengendo taropola teko mengo ulsu pungí oringi. Kanu kolorumu yemo yunge anumu lapatolone yu komolayemo meringili kinie pe te lupe naa meangili lapa kolorumu. Pe yunge anumu ambo wayemo molopili yu kolorumula. Kango kanumu ono tengendo yambo aisili anumu kinie tapu toko puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ailimuni ambomo kanopalie paa kondo kolopa yundu “Kola naa tei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kanu kinie yu yambo taropolamonga nondopa omba taropolamo omba ambolopalie, meringi yema we mengo angiliengi yuni nimbendo: “Kango yemo, ola moloi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kanu kinie kolorumu yemo ola molopa yu ungu nirimu. Kanu kinie Yesusini ye kolorumumu lipe yemo yunge anumu yuyu sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yesusini aku terimuna yambomane pipili kolkolie ningindu: “Pulu Yemonga ungu umbu tonjilime pilipe yamboma nimbe sili ye aili te olio molemolona wendo omu lepamo.” ningu Pulu Yemo yunge imbi ambolko ola linjikulie ningindu: “Pulu Yemo yunge yamboma molemelena omba lipe taponjimu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","I Yesusini terimumunge temanemo kolea Judia disiriki pali kinie Judia ulsu kolea lupe lupema pali kinie anju anju purumu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesusini terimu mele Jono yu lombili andolimene yundu ningu siringi kinie yuni yu lombili andolimenga talo “Yando wale.” nimbelie Yesusi molorumuna elte lipe mundupelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“⸤Pulu Yemone olio nokopa konjimbe yere⸥ “Lipu mundumbu.” nimbe, nimbe panjirimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo te lupe ombámo nokopo molamiliye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kanu yetolone Yesusi molorumuna ongolo yundu ningilindu: “No Linjili Jonone olto lipe mundupelie nimbendo: “⸤Pulu Yemone olio nokopa konjimbe yere⸥ “Lipu mundumbu.” nimbe, nimbe panjirimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo te lupe ombá nokopo molamiliye?” nimu.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aku siku walsiku pilkululie niringilimuni, ena tenga ⸤we kanoko angiliengili⸥ Yesusini kuru lupe lupe torumu yamboma kinie, konopuna kuru molorumu yamboma kinie, mongo keri lerimu yambo aisili kinie, tepa konde lipe molorumu kanoringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe Yesusini eltendo pundu topa nimbendo: “Eltene ya kanokombele mele kepe pilkimbili mele kepe Jono ningu sipale. Mongo keri leli yamboma mongone kanoko, kimbu keri leli yamboma kapola andoko, kuru laká nolime umbu kangi angilipe, komu silime komuni pilku, kolopa lelime ola molemele kepe, koropa pulime temane peangamo topo silio pilimelela kanumu.* Aku siku Jonondo ningu siele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na kanokolie ‘Yu sike kanu yemo molemo.’ ningu tondolo munduku pilkulie, altoko konopu talo naa panjiku molonge yamboma ene malo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonone mundurumu yetolo kelko nendo puringili kinie Yesusini kelepa yambo aisili maku toko moloringimendo Jonondo nimbendo: “⸤Kolea ku leline Jono no linjipe molorumu kinie⸥ ene kanu kolea ku leline nambolka kanonge puringiye? ⸤Molo⸥ lkepanie mele poporomene lope lope tenjipe molorumu te kanonge puringiye? ⸤Jono yu aku sipe mele molo kanumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","⸤Alieli kanolemele mele kanonge naa puringi liemo⸥ ulu nambolkare kanongendo puringiye? Ye te mulu wambale paa peangama pakopa molorumu kanonge puringiye? Akumu molola. Yambo kamako molko, mele aisili nosiku, mulu wambale paa peangama pakolemelema ye nomi kingimenga ulkena manjiku molemele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“⸤Aku sili te kanonge naa puringi liemo⸥ Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe sili ye te kanonge puringiye? Akumu sike nakolo nane enendo nimbu sikiru. Jono yu sike Pulu Yemonga ungu umbu tonjirimuma pilipe nimbe sili ye te nakolo yu Pulu Yemone ungu umbu tonjirimuma pilipe nimbe sili ye we te molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yuni Pulu Yemone ou “Lipu mundumbu.” nirimu yemonga* aulkemo tepa mimi temu kanumu.** Kanu yemondo Pulu Yemonga bokuna sukundu molemo ungu te i sipe: ‘⸤Pulu Yemone yunge Malondo nimbendo:⸥ “Piliyo! Nanga ungu ninjimbe yemo nane nu puni aulkena yu kumbi lepo lipu mundukuru. Yuni nunge aulkemo akisinjimbe.” nirimu.’*** kanu ungumu bokuna molemo.**** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nane enendo paa sike nimbu sikirumu: Ou mana moloringi yambomanga te ⸤No Linjili⸥ Jono kinie manda molo. Jono olandopa mele. Nakolo kinié wale kondemo wendo okomo. Kanu walemo Pulu Yemo ye nomi kingi molopa nokolemo yambomanga* te paa imbi naa molopa paa koropa puli yambomo olandopa; Jono yu maniendopa. ⸤Ou moloringi yamboma manie mele; kinié na ‘Sike.’ ningu tondolo munduku pilingímunge konopu peanga pemba yamboma olandopa.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesusini aku sipe nirimu pilkulie we yamboma kinie kou takisi liringi yema kinie Yesusini Jonondo nirimu ungumu pilku peanga pilku Pulu Yemo kapi niringi. Kanu yambomane ou ⸤No Linjili⸥ Jonone nirimu ungumu pilku peanga pilkulie ene ulu pulu keri teringime bulu siku, konopu alowa teko ‘Olio Jonone no linjipili.’ ningu no liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nakolo Parisi yema kinie,* Pulu Yemonga ungu manemanga puluma pilku konjiringi yema kinie, enene ‘Pulu Yemone Jono naa mundurumu.’ ningu pilkulie, Pulu Yemone “Yambomanga lipu taponjipu tenjimbu.” nirimu ungumu pilku keri pilku bulu sikulie pe ‘Jonone olio no naa linjipili.’ ningu no naa liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kanu kinie Yesusini ungu te pea nimbendo: “Kinié mana molemele yamboma nambolka melte ene manda lepo manda nimbunje? ⸤Ene molemele mele i sipu nimbu siembo:⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ene yamboma maku tolemele koleana ambolangoma pepe pereko molemele mele.* Kanu ambolangomanga marene ne anju molemele ambolango mare ⸤pea pepe pereko molonge aulke te koroko kelkolie⸥ enendo walsikulie ningindu: “Konana nímulu kinie ene ‘Pea konana niemili.’ naa ningu “Molo.” níngi. Pe kelepo kola temulu kinie ene ‘Pea kola teamili.’ ni naa níngi. ⸤Pea pepe perepo molomolo aulke te molo lepamo.⸥” nilimele. ⸤Kinié molemele yamboma ene kanu ambolangoma mele molemele.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","⸤Na kinie No Linjili Jono kinie oltone nilimbolo unguma enene pilku keri pilimele; telembolo mele kanoko keri kanolemelela⸥. Jono ombalie ga kinie no waene kinie naa nomba molorumu kinie ⸤kanoko keri kanokolie⸥ ningindu: “Yunge konopuna kuru te molemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pe Manie Omba Mana Ye Au Lerimu Yemo omba ga kinie no waene kinie norumu kinie ⸤kanoko kerila kanokolie⸥ ningindu: “Yu ga aisili nomba keri pilipe, no waene aisili nomba kekelepa topa telemo yemo. Yu kou takisi lili yema kinie,* ulu pulu keri telemele yambo wema kinie ‘Yu kinie pulu lepili pea tapu topo molamili.’ nimbe telemo.” nilimelela. ⸤Enene aku siku Jono kanoko kerila kanolemele. Na kanoko kerila kanolemele.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nakolo pilipe konginjili ulu pulumu Pulu Yemo kinie pelemona yunge ambolangomane pali yuni telemo melemando ‘Papu telemo.’ ningí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Walse, Parisi ye tene Yesusindu “Langi pea nambili oi.” nirimu kinie yunge ulkena suku pupe akuna langi polona nondopa polo tenga manie molorumu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","kanu koleana molorumu ambo ulu pulu keri teli tene Yesusi yu kanu Parisi yemonga ulkena suku langi nomba molorumu pilipelie, yu kopongo wele paa peanga te mingi pali lipe akuna memba pupelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesusi molorumuna bulkundu kimbuna nondopa kola tepa angilipelie, pe Yesusi yunge kimbutolo kola mongone kulumiye tonjipe, pe ambomo yunge penge lapisemo lipe kanu kimbutolo kulu tonjipe, kimbutolo kangulupe, kopongo wele memba orumu kanumuni kimbuna ape kanjinjirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kanu ulke pulu ye Parisi ⸤Saimono⸥ yuni ambomone aku terimu kanopalie yuyu konopuni pilipelie ‘I yemo paa sike Pulu Yemone ungu umbu tonjilimo pilimo ye te* molkanje i ambo yu ambolkomomo molemo mele kinie ulu keri telemo mele kinie manda pilipelie “Na naa ambolko, ongo wendo pui.” nilke.’ konopu lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesusini ⸤Saimono⸥ konopuni pilirimu mele pilipelie yundu nimbendo: “Saimono, nu ungu te niembo.” nirimu kinie Saimonone pundu topa nimbendo: “Ungu Mane Silimu, kapola, ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","⸤Aku nirimu kinie Yesusini yundu temane te topa nimbendo:⸥ “Ye tene ye talo kou mone pundu anjipe sirimu. Ye te wane anderete kina mele sipe, ye te tene kina mele sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pe elte pea pundu manda naa tonjiringili kinie ye pundu anjirimu kanu yemone pundutolo we siye kolopa “Uluri molo, yu tepili.” nirimu. Aku nirimumunge yetolonga naene yu konopu olandopa monjirimu konopu lekenoye?” nimbe Yesusini Parisi yemondo aku nimbe walsirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","⸤Kanu Parisi ye⸥ Saimonone yundu pundu topa nimbendo: “Pundu aili anjirimu yemo, konopu lekero.” nirimu kinie Yesusini “Paa nikinu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanu kinie Yesusini topele topa kanu ambomo angilirimuna kanopalie Saimonondo nimbendo: “I ambomo kána! Na nunge ulkena sukundu ondu kinie ⸤olio Isirele yambomane ye ponenge kokele olemo kinie telemolo mele⸥ nuni nando aku naa tenu. Nuni “Kimbu kulumiye toi.” ningu no naa sinu nakolo i ambomone nanga kimbumu yunge kola mongone kulumiye tonjipe, yunge penge lapisemo lipe nanga kimbumu kulu tonjimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na ondu kinie nuni na naa kangulunu nakolo i ambomone na ondu kinie kepe yandopa kinié kepe nanga kimbumu kangulupe molemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na ondu kinie nuni nanga pengena kopongo wele liku ape naa kanjinu nakolo i ambomone nanga kimbutolo kopongo wele peanga tene ape kanjinjimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yuni ulu pulu keri aisili terimuma manie pumumunge na konopu aili tepa monjipelie aku sipe temu. Nakolo ulu pulu keri layetolo mindi telemo yambomo yunge terimu mele ‘Manie pupili, siye kolkoro.’ nimbé yemo konopu laye tepa monjimbela.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ye Saimonondo aku sipe nimbe pora sipelie nirimumuni, ambomondo nimbendo: “Nunge konopuna ulu pulu keri terinu pelemoma manie pupili, siye kolkoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aku nirimu pilkulie yu kinie langi nongo moloringime yuni nirimu mele pilku keri pilkulie enene anju yando ungu mele teko ningindu: “Yambomane ulu pulu keri telemelema i yemone “Manie pupili, siye kolkoro.” nikimu yemo yu naeye? ⸤‘Na Pulu Yemo.’ konopu lepalie nikimunje?⸥” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kanu kinie Yesusini ambomondo kamu nimbendo: “Nane nu ulu pulu keri terinu mele ‘ ‘Omba wendo pupili.’ manda nimbú.’ ningu pilku onumunge na sike aku sipu manda lipu taponjikiru kene nu konopu pe nipili mololiku pani.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kanu kinie pe Yesusi pupe, kolea ailime kinie kangama kinie akumanga andopalie nirimumuni, Pulu Yemo ye nomi kingimu molopa yamboma nokomba* temane peangamo topa silipe, yamboma ungu mane silipe andorumu. Yu lombili andoli ye engaki rurepo kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ambo mare kinie yu pea andoringi. Kanu ambomanga mare ou kuru topa, mare ou kuru enenga konopuna perimu kinie Yesusini ene pali tepa konde lirimu. Te, kolea Makatalla ambo Maria, ou yunge konopuna kuru yepoko pakara moloringimendo Yesusini “Ongo wendo pai.” nirimu kinie ongo wendo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te, ambo Joana, Susa menu. Susa yu kolea Gallilli disiriki ye nomi kingi Erotenga ulke tapu yemo. Te, ambo Susana. Ene kinie we ambo aisili kinie Yesusi nokoringi. Kanu ambomane enenga kou mone nosiringime likulie Yesusi kinie yu lombili andolime kinie enenga langi kinie melema topo toko liku siku nokoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kanu kinie Yesusi molorumuna kolea lupe lupemanga moloringi yamboma sukundu sukundu ongo, liku maku toringi kinie yuni enendo ungu iku te topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ye tene rasi witi umbu poniena andopa tanda sirimu. Tanda silipe andorumu kinie umbu mare aulkena manie purumu, kanuma yambomane kimbuni kambiliringi; keramane ongo liku noringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Umbu mare kou perimuna manie pupelie akuna no naa molorumuna mulie topa wendo omba walsikale kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Umbu mare kombulu siri ka mele molorumuna manie purumu, siri ka melemo wendo omba witi umbuma topa norumuna omba peanga naa lepa ⸤mongo te naa torumu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Umbu mare ma peangana manie purumuma wendo omba mongo peangama topa, mongo tokapu kise mele torumu.” ⸤nirimu.⸥ ⸤Aku nimbelie⸥ “Yambo komu peo lemomane i ungumu piliei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","⸤Yesusini aku nirimu kinie⸥ yu lombili andolimene yundu ningindu: “Aku ungu ikumunge pulumu ningu si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kanu kinie yuni enendo nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma kinie melema kinie nokolemomonga* ulu pulu ou yuyu pilirimu kanu ulu puluma ‘Ene kinié ⸤na lombili olemele yamboma⸥ piliengi!’ nimbelie ene ‘Ungu ikumanga puluma piliengi!’ nimbelie ene nimbe sikimu. Nakolo we yamboma ‘Unguma nimbu siembo.’ nimbulie ungu ikuma mindi topo silio. ⸤Pulu Yemone Aisayanga kerena nimbendo:⸥ ‘Ene mongone kanokolie naa kanoko, komuni pilkulie naa pilimele.’** nirimu akumunge we yambomando ungu ikuma mindi tolio.” nirimu.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aku nimbelie yuni nimbendo: “Aku ungu ikumunge* pulumu i sipe: “Langi umbu tanda sirimu kanu umbuma Pulu Yemonga ungumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Umbu mare aulkena manie purumuma yambo mare aku silime molemele. Enene ungumu pilimele kinie pe ⸤kurumanga nomi⸥ depelemo* omba ‘Aku ungumu kamu tondolo munduku pilíngi liemo Pulu Yemone ene lipe taponjipe aulke kerine wendo limbe** kinie manda molo.’ nimbe ungu tanda sili konopuna pupe pelemoma wendo limo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Umbu mare tanda sirimu kou perimuna manie purumuma yambo mare aku silime molemele. Enene ungumu pilkulie konopu siku pilku limele. Nakolo ene pulkeno naa mundukulie ungumu laye kolte mindi pilku molemele. Pe ene konopuna umbuni temba kinie molo ⸤Setene omba⸥ manda manjipe kondi ka temba kinie, ene pilimele ungumu siye kolemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Umbu mare tanda sirimu kombulu siri ka mele molorumuna manie purumuma yambo mare aku silime molemele. Enene ungumu pilkulie pe aulkena pungí pungí kinie konopuna umbuni telemo umbunime kinie, mele aisili nosilimele melema kinie ya ma koleana uluma teko konopu singí uluma kinie, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinie ungumuni uluri naa tepa langi mongo kamu naa tolemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Umbu mare tanda sirimu ma peangana manie purumuma yambo mare aku silime molemele. Enene enenga konopu peanga pepili molko ungumu pilkulie kanu ungumu kamu liku tondolo munduku pilkulie, tondolo pupili molemele kinie kanu umbuma langi mongo ⸤aisili⸥ tolemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","⸤Yesusini enendo ungu iku te pea topa nimbendo:⸥ “Yambomane tepe llame kandokolie mingine suku naa panjiku polo maniekondo naa nosikulie nilimelemone, ‘Yambo ongema kolea kanangi ulkena suku pa tepili.’ ningu polo tenga ola nosilimele.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aku sipe mele, kinié lopi telemo melema pe walse mona lemba yamboma kanonge; kinié aki topa lemo melema pe walse pa temba kinie yambomane kanu melema kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Aku temba kene enene ungu pilimele akumu mimi siku piliengi! Pulu Yemonga ungumu pilku molemele yamboma paa olandopa nimbe simbe pilingí. Pe paa aisili pilingí. Nakolo naa pilku molemele yamboma ene laye kolte pilimele ungumu kepe wendo limbe.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Walse Yesusi ulke tenga suku molorumu kinie yunge anumu kinie angenupili kinie yu kanongendo oringi. Akuna yambo aisili ekelepa teko moloringine yu molorumuna nondoko manda naa ongolie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","⸤ungu te ningu munduringi kinie⸥ yambomane yundu ningindu: “Aminie kinie angenali kinie nu kanongendo ongo pena angilimele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesusini enendo pundu topa nimbendo: “Pulu Yemonga ungumu pilku liku telemele yamboma nanga anumu kinie nanga angenupili kinie molemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Walse, Yesusi kinie yu lombili andolime kinie ene nona andoli sipi tenga sukundu puringi kinie pukulie, yuni enendo nimbendo: “Nomu nekendo pamolo.” nirimu kinie akuna pungí puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sipine pungí puringi kinie Yesusi yu uru perimu. Yu uru pepili poporome aili te nomuna torumu. Aku terimuna ⸤nomumu apisipe ola ombalie⸥ no sipine sukundu sukundu omba peke lepalie sipimu memba nona manie pumbe terimu kinie ene no wangonge teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanu kinie yu uru perimuna puku toko makinjikulie ningindu: “Ye Nomimu,* Ye Nomimu, olio no wangokomolo.” niringi kinie yu makilipelie poporomemo kinie no apisipe ola orumu nomumu kinie iri torumu. Kanu kinie poporomemo topa kelepa, nomumu lope naa tepa we lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kanu kinie yuni lombili andolimendo nimbendo: “‘⸤Pulu Yemone olio nokomba.’ ningu⸥ tondolo munduku naa pilkimiliye?” nirimu. ⸤Yuni terimu mele kanokolie⸥ yemane pipili kolko mini wale mundukulie anju yando eneno walsikulie ningindu: “Apa! I yemo naenje? Poporomemone kepe nomumuni kepe yuni eltendo “Teale.” nilimo ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kanu kinie nomuna nekendo puku kolea Gerasa puringi. Nomu yakondo kolea Gallilli, nomu nekendo kolea Gerasa kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Akuna oringi kinie Yesusi sipine wendo omba kélona angilirimu kinie kanu kolea ye te yu molorumuna orumu. Kanu yemo kuru aisili yunge konopuna molorumumunge mulu wambale telu kepe naa panjipe, we we andopa, ulke tenga naa pepa, yambo ono koleana pelipe andopa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kurumuni kanu yemo taki taki lirimuna yambomane ka senene yu kimbu kime ka toko yu nokoko moloringi nakolo ka senema sungu sirimu kinie pe kurumuni kolea ku leline yu memba purumu. Kanu yemone Yesusi kanopalie kalle nimbe yu angilirimuna manie molopa tamalu pepa tondolo mundupelie nimbendo: “Yesusi, Pulu Ye Paa Olandopa Ailimunge Malo, na kinie ulu nambolka uluri tenindu onuye? ‘ “Na mindili paa naa lipu simbu.” ni.’ nimbu mawa tekero.” nirimu. ⸤Yu kokele ombá orumu kinie⸥ Yesusini ou nimbendo: “Kurumu, i yemonga konopuna ongo wendo pui.” nirimu mele pilipelie yemone aku sipe “Naa tei.” nimbe mawa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aku nirimu kinie Yesusini yemondo walsipelie nimbendo: “Nunge imbi naeye?” nirimu kinie yemo yunge konopuna kuru aisili molorumuna pilipelie yuni “Nanga imbi Paa Aisili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kanu kuru aisilimene wale aisili Yesusi mawa tekolie ningindu: “Olio ‘ongo wendo pangi.’ ningu toko makorokolie “⸤I ma koleamo munduku kelko⸥ Pulu Yemone kowa muru paa lepa mindi pupe naa pora nilimo murumunge ⸤olionga ye nomi Setene walse lipe mundumbe⸥ kanu murumunge* pai.” ni naa ni.” ningu mawa teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akuna ma pangi tenga umbu kongi aisili ímu nongo moloringi kanokolie Yesusi mawa tekolie ningindu: “Olio ⸤toko makorokolie⸥ ‘Ne kongimenga konopuna molopangi.’ ni.” niringi kinie yuni “Kapola, akuna pangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aku sipe nirimu kinie kuruma kanu yemonga konopuna wendo ongolie kongi akuna moloringimenga konopuna puku moloringi kinie kanu kongime kekelepa toko lkisiku puku kopona pukue toko nomuna suku puku no wangoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ulu akuma wendo orumuna kanokolie kongi tapu teko moloringi yema talopa lelko pukulie niringimuni, kolea ailine moloringi yamboma kinie, kolea kangamanga moloringi yamboma kinie, ulu akuma wendo orumu mele temanemo toko siliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kanu temanemo piliringi yamboma ‘Uluma wendo orumu mele kanamili.’ ningu wendo puku Yesusi molorumuna ongolie ou kuru aisili konopuna molko ongo wendo puringi yemo mulu wambale pakopa, umbu konopu pepili Yesusi molorumuna nondopa manie molorumu kanokolie ene pipili koloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yesusini terimu mele mongone kanoringi yambomane pe oringi yamboma ningu siringi. Kuru aisili konopuna moloringi yemonga konopuna kuruma ongo wendo puringi kinie yemo yu umbu konopu pepili molorumu mele ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kanu kinie kolea Gerasa yamboma pali paa mini wale mundukulie Yesusi mawa tekolie ningindu: “Olionga koleana naa mololi kelko pui.” niringi kinie yu kelepa pumbendo nona andoli sipine suku purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","⸤Yu pumbe terimu kanopalie⸥ kuru aisili konopuna ou molko wendo oringi yemone yundu nimbendo: “Pea pambili.” nimbe mawa terimu. Nakolo Yesusini “Molo.” nimbe yundu nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nu ulkendo puku Pulu Yemone nu lakopa tepa konjimu mele nunge yamboma ningu sipui.” nirimu. Yesusini aku nirimuna pilipelie ye kanumu pupe kolea ailine suku moloringi yamboma pali Yesusini yu kinie lakopa tepa konjirimu mele nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kanu kinie Yesusi yu nomu yakondo orumu kinie yu ‘Ombá.’ ningu maku toko nokoko moloringi yambomane “Nu papu okono.” ningu konopu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke te nokorumu ye te, yunge imbi Jairasi, Yesusi molorumuna orumu. Kanu kinie yu Yesusinge kimbuna nondopa omba manie molopa tamalu pepa yundu mawa tepalie nimbendo: “Nanga ulkendo pea pambili oi.” nirimu. Yemo yunge ambolamo, yunge lemenu telu mindi, yu ponie engaki rurepo mele omba purumu kanu ambolamo, kuru paa aili tepa torumumunge yu nondopa kolomba tepa lerimumunge ⸤yemone Yesusi aku sipe mawa terimu.⸥ Pe Yesusi kanu ulkena pumbe purumu kinie yambo aisili liku maku toko yu kakapu teko ekelepa teko pea puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kanu yambo pea puringimenga ambo te yunge pena perimu walema pora naa nirimu. Yu pena mindi pepili ponie engaki rurepo omba purumu. Yu doketamanga yunge kurumu ‘Pora nipili.’ nimbe andopa, yunge kou mone pali ene sirimu nakolo kuru kanumu pora naa nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kanu ambomo Yesusi pumbe purumu kinie bulkundu omba, yunge wale pakolimunge pundumu ambolorumu kinie walsikale yunge kuru torumu kanumu pora nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aku terimu kinie Yesusini nimbendo: “Na naene ambolomuye?” nirimu. Enene pali “Na molo.” niringi kinie ⸤yu lombili andoli ye⸥ Pitane yundu nimbendo: “Ye Nomimu,* yambo aisili nu angilinona nondoko nondoko ongo kakapu teko ekelepa teko angilkimili kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nakolo Yesusini altopa nimbendo: “Na yambo lipu taponjilio tondolo mare nanga kangine omba ulsu pumuna pilipulie yambo tene na ambolomumundu nikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aku sipe nirimu pilipelie ambomo yu lopi manda naa tepa, yu terimu mele Yesusi pilipe molorumu kanopalie yu kimbu ki pungu pungu nipili Yesusi molorumuna omba manie molopa tamalu pepalie, yamboma pilku angiliengi yuni ‘Kuru pora nipili.’ nimbe omba yu ambolorumu kinie walsikale konde purumu mele nimbe para sirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesusini yundu nimbendo: “Ambomo, ‘Nu manda tepa konde limbe.’ ningu tondolo munduku pilinu kanu ulumuni nu konde pukunu. Konopu pe nipili mololiku pani.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusini ambomondo aku sipe nimbe molorumu kinie, ye te, yamboma maku toko Pulu Yemonga ungu piliringi ulke nokoli ye ⸤Jairasi⸥ nge ulkena molopalie omba ⸤Jairasindu⸥ nimbendo: “Nunge ambolamo kolopa pora simu. Ungu Mane Silimu ‘Mindili nopili.’ ningu we naa mengo wani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yuni nirimu mele Yesusini pilipelie ⸤ulke nokoli yemondo⸥ nimbendo: “Mini wale naa munduyo. Nunge ambolamo nane ‘Manda lipe taponjimbe.’ ningu tondolo munduku pilku moloni kinie* yu konde pumbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Kanu kinie Yesusi yemonga ulkena ombalie ulkena sukundu yambo aisili ambola kolorumumu kondo kolko kola teko moloringi kanopalie enendo nimbendo: “Ambolamo kolou naa kolomu. We uru mindi pelemo* kene kola naa teai.” nirimu. Nakolo yu sike kolopa pora sirimu pilkulie yuni “We uru pelemo.” nirimumunge enene yu ungu taka tonjiku tae tenjiringi. Pe yu ⸤ambolamonga suluminiana⸥ pumbe purumu kinie ‘We yamboma pali naa ongo anju pai.’ nimbelie Pita keme, Jono keme, Jemisi keme, kanu ambolamonga anumu lapatolo kinie “Ene mindi pea pamili.” nimbe ⸤ambola onomo lerimu⸥ suluminiana ene memba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pupelie ambolamonga kimu ambolopa yundu walsipelie nimbendo: “Ambolamo, nu ola moloi.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","yunge mini purumu kanu minimu altopa sukundu orumu kinie ambolamo walsikale ola molorumu. Kanu kinie Yesusini ⸤anumundu⸥ nimbendo: “Ambolamo langi mare liku si.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yuni terimu mele kanokololie ambolamonga anumu lapatolo elte paa mini wale munduringili nakolo yuni eltendo tondolo mundupe nimbendo: “Ulu i tekeromo yambo telurindu kepe anju puku paa naa ningu siele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Walse Yesusini yu lombili andoli ye engaki rurepondo “Yando wai.” nimbelie, enene yambomanga konopuna kuru molemoma “Ongo wendo pai.” ningu toko makoronge tondolomo sipelie, yambo kuru tolime ‘Konde pangi.’ ningí nambamo sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aku sipe tepalie enendo nimbendo: “Ene puku, Pulu Yemo omba ye nomi kingimu molomba* temane peangamo yamboma toko siliku andoko, kuru tolime teko konde liliku pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Pungindu, ene melema naa mengo we pangi. Apulu mingi kepe, mele wale kepe, langi kepe, kou mone kepe, wale pakoli talo kepe naa mengo we pangi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Pe kolea tenga suku pukulie akuna molongendo ulke teluringe suku pukulie akuna mindi peko molkolie pe aku koleamo munduku kelko pangi. ⸤Ulke pinie pinie naa andoko, ulke teluringe mindi langi nongo peangi.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kolea marenga suku pungí kinie kolea pulu yambomane “Papu ongi. Pea peamili wai.” ni naa ningu enene ungu ningíme pilku naa língi liemo kanu koleana yambo kerime munduku kelko pungindu ene liku su singímunge kanu koleana yamboma ‘Kamu molko kenjengi! Pulu Yemone ene lipe naa taponjimbe mele piliengi!’ ningu enenga kimbuna kanu koleamanga ma angilimbema kulu tokolie pangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aku nirimu kinie kanu yema puku, koleamanga andoko, Pulu Yemonga temane peangamo toko siliku, kuru torumu yamboma teko konde liliku, teliku andoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kolea Gallilli disiriki nokorumu ye nomi kingi Erotene Yesusini terimu mele temane toringi pilipelie, ‘I yemo naenje?’ nimbe pilipe sundurumu. Yambo marene ningindu: “I yemo ⸤No Linjili⸥ Jono ⸤talko kolorumu kanumu⸥ lomboropa wendo omunje.” ningu moloringi. Marene ningindu: “⸤Pulu Yemone ou konde molopili olando lirimu ye⸥ Illainja* kelepa omba molemo.” ningu moloringi. Marene ningindu: “Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi ye koro ou moloringimenga ye te kolopalie lomboropa wendo orumu.” ningu moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","⸤Ye nomi kingi⸥ Erotene ⸤Yesusini terimu mele temane toringi⸥ pilipelie nimbendo: “⸤No Linjili⸥ Jono ‘yunge pengemo wendo pupili.’ nimbu nomimu karu lerindu yu kolorumu* nakolo i ulu tondolo lupe lupe telemo pilio yemo yu naenje?” nirimu. Aku sipe nimbelie “I ye Yesusi kanamboa!” nimbe molorumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusini “Nanga kongonomo tenjipai.” nimbe lipe mundurumu yema* yu molorumuna kelko yando ongolie niringimuni ulu teringime yu temane toko siringi. Kanu kinie kanu yema lipe memba pupe ‘Tenga oliolio molamili.’ nimbe ene Besaida taonona memba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nakolo yambo paa aisili ene akuna puringi mele pilkulie yu purumuna akilku lombili puringi. We yamboma oringi kanopalie Yesusini enendo “Papu ongi.” nimbelie ene Pulu Yemo omba ye nomi kingi molomba temane peangamo topa sipe, enenga yambo kuru torumuma ‘Konde pangi.’ nimbe ene tepa konde lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pe ipupini ena pumbe terimu kinie yu lombili andoli ye engaki rurepo yu molorumuna ongo yundu ningindu: “I koleana yambo te naa pelemo kene ya maku toko molemele yamboma ‘Puku kolea marenga langi topo toko liku nongo pepangi.’ ni.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aku niringi kinie Yesusini lombili andolimendo nimbendo: “Enene eneno yamboma langi mare liku siengi.” nirimu. Enene yundu ningindu: “Ya langi aisili molo. Pillawa kaloli kanga te pakara kinie oma kaloli talo kinie, aku langi pokore mindi lemo. Molo nuni ‘Olio kolea tenga puku i yambomanga langi topo toko linjipangi.’ ningu nikinuye?” ningu walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Kanu yamboma layetolo molo, ye pape tausini mele akuna moloringi.)* Kanu kinie Yesusini enendo nimbendo: “Yambomando ‘ene tokapu talo talo** ningu manie molangi.’ niengi.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","enene aku siku yambomando niringi kinie yamboma pilku liku aku siku manie moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kanu kinie Yesusini pillawa kaloli te pakara kinie oma talo kinie kanuma lipelie mulu koleana olando sipe kanopa ⸤Pulu Yemo kinie⸥ “Ange.” nimbe langi akuma ambolopa pike lepa lombili andolime moke tepa sipelie “Anju yamboma siei.” nirimu, ⸤enene yamboma moke teko siringi⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ene pali kanu langime noringi kinie olo terimu. Pe lombili andolimene langi goli lerimuma liku maku toko wale basikete engaki rurepo toko peke siringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Walse, Yesusi yuyu Pulu Yemo kinie ungu nimbe molorumu kinie yu lombili andoli ye pea moloringimendo walsipelie nimbendo: “Yambomane na imbi lelko nae nilimeleye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Enene yundu pundu toko ningindu: “Marene “Nu No Linjili Jono ⸤kolorumumu kinié kelepa lomboropa ola molemomo⸥.” ningu pilku, marene “Nu, ⸤Pulu Yemone ou konde molopili olando lirimu ye⸥ Illainja kelepa omba molemo.” ningu pilku, marene “Nu Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye te ou kolorumumu kinié lomboropa ola molemo.” ningu pilimele.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","⸤Aku niringi kinie⸥ yuni enendo walsipe pilipelie nimbendo: “⸤We yambomane aku siku nilimele⸥ nakolo enene eneno na nae nilimeleye?” nimbe walsirimu. Pitane pundu topa nimbendo: “Nu ⸤Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ ou nimbe mako torumu ye nomi⸥ Kirasimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitane aku nirimu pilipelie Yesusini enendo tondolo mundupe nimbendo: “Na molio mele ⸤Pitane kinié nikimumu⸥ enene anju yambo telurindu kepe ⸤isili ou⸥ paa naa ningu siei.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","⸤Nimbelie⸥ yuni ⸤yu kinie wendo ombá mele⸥ ene nimbe sipelie nimbendo: “Manie Omba Mana Ye Au Lerimu Yemo* sike mindili aisili nombá. Juda yamboma nokolemele tapu yema kinie,* Pulu Yemo popo tonjili ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane sili yema kinie,** enene ⸤ningindu: “Yu Pulu Yemone naa mundurumu. Yu Pulu Yemonga Malo naa molemo.” ningu⸥ yu liku bulu siku yu toko konjingí. Yu toko konjingí kolomba kinie wale talo omba pumbe kinie yepoko sipemonga Pulu Yemone yundu ‘Lomboroko ola moloi.’ nimbé.” nirimu.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kanu kinie Yesusini akuna maku toko moloringimendo pali* nimbendo: “Yambo tene ‘Yu lombili pambo.’ nimbelie yuni alieli yunge konopumuni pilimo melemanga ‘Topo manie mundembo.’ nimbe, yamboma unju perana angilku mindili nongo kolemele mele yuni unju pera mele gomo lembando ‘Na yu lombili pumbundu mindili nondu liemo papula; kolondu liemo papula.’ nimbelie na lombili opili. We naa opili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yambo tene yunge mana molopa naa kololi ulu pulumu ambolomba temba kinie yu kolopalie sike molopa kenjipe mindi pumbe. Nakolo yambo tene na konopu monjipelie nanga kongono “Tenjembo.” nimbe temba kinie yu kolopalie yu konde molopa konjipe mindi puli ulu pulumu sike kanopa limbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","⸤Akumu nambemuna nikiruye?⸥ Yambo tene mana melema pali yuyu lipe nosipelie yu mini pali Pulu Yemo naa molomba koleana pupe mindili nomba molopa kenjilkenje kanu melemane kanu yambomo nambe tepa lipe taponjilkenje? Lipe naa taponjilkemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Nanga yambo mare we yamboma kinie molkolie ningindu: “Olio Yesusinge unguma pilipu lipu, yu lombili andopo molemolo mele we yambomane naa piliengi!” ningulie, na kiyongo ningu lombili andolemele yamboma ene kinie ulu te pe wendo ombá mele nimbu siembo: Manie Omba Mana Ye Au Lerimu Yemo pe Lapanga tondolo pa telimu kinie ⸤mulu koleana⸥ angello kake telime kinie ⸤manie⸥ ombá temba kinie, kanu we yamboma molongena yunge yamboma mona molongendo we yamboma molongena kanokolie yu ou naa opili ‘Olio yunge yamboma molemolo mele we yambomane naa piliengi!’ ningu pipili kolko lopi teko molonge yamboma yuni lipe wekendo kanopa, “Na moliona naa wai.” nimbéla.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Nane enendo paa sike nimbu sikirumu: Ene ya angilkimilimenga mare ou kolou naa kolangi Pulu Yemo ye nomi kingimu omba molopa kolea nokombando* ombá kanonge.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusini ⸤yu lombili andolimendo aku sipe nimbe sirimu kinie⸥* pe koro te omba purumu kinie Pita keme, Jemisi keme, Jono keme, ene lipe memba pupe ‘Pulu Yemo kinie ungu niembo.’ nimbelie ma pangine** ola ene lipe memba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yuni akuna Pulu Yemo kinie ungu nimbe molopili yunge kumbikeremo alowa tepa, yu pakorumu mulu wambalema ena tondolo topa yambomanga mongo takele telemo mele aku sipe kake terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yu aku sipe molopili, ⸤Juda yambomanga koronga ou moloringili ye aili talo,⸥ Mosisi kinie Illainjatolo, ongolo pa terimuna ongo angilkululie elte kinie Yesusi kinie enene Yesusi yu kolea aili Jerusalleme akuna Pulu Yemone yundu ‘Tei.’ nirimu mele tepa kolomba mele ningu moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita kinie, yu pea akuna moloringi yetolo kinie, ene siye tepa uru ombá terimu nakolo pe ene makilku umbu konopu pepili molkolie Yesusi yunge kangi alowa tepa molorumu mele kinie, yunge tondolo pa terimu mele kinie, yu kinie angiliringili yetolo pea kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kanu kinie aku yetolo pungilí puringili kinie Pitane Yesusindu nimbendo: “Ye Nomimu,* olio ya molopamolo peanga lepamo. Olione ulke takaye yepoko takonjemili. Te nunge, te Mosisinge, te Illainjanga takonjemili.” nirimu. (Nakolo aku nirimumu ⸤pipili paa kolopalie⸥ yuni nimbé mele naa pilipe ungu te walu nirimu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitane aku sipe nimbe molopili kupe te omba ene aki torumu. Kupena sukundu puringi kinie ene pipili terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kupe torumuna sukundu ungu te wendo ombalie nimbéndo: “I yemo nanga Malomo.* Nane ⸤‘Enenga’ nimbu⸥ yu mako topo lipu mundurundu. Yuni ungu nimbéma pilku liengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aku ungumu nimbe kelerimu kinie Yesusi yu mindi molorumu kanoringi. Enene aku siku kanoringi mele anju naa ningu para siku, yambo teluri kepe ou naa ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Opali, ipulueli ou ⸤Yesusi kinie yu lombili andoli ye yepoko kinie⸥ ene ma pangine maniendo onge oringi kinie yambo aisili yu lingí oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oringi yambomanga ye tene Yesusindu nimbendo: “Ungu Mane Silimu, ‘Nanga kango nanamo, yu nanga kango telumu mindi, kondo kolko liku taponjeni.’ nimbu mawa tekero. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yunge konopuna kuru te pelemomone yu lipe mindili sipe tolemo kinie kangomone kalle nimbe, yu kuru kopalli topalie apapu memba molemo. Yu aku sipe taki taki telemona kangomo yu kangime pange mange telemola. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nu lombili andolimendo aku temanemo topo sipu enene kanu kurumu ‘Makorangi.’ nimbu mawa tendu nakolo ene manda naa tengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","⸤Aku nirimu kinie⸥ pilipelie Yesusini ⸤yamboma iri topalie⸥ nimbendo: “Kinié molemele yamboma ene ⸤‘Pulu Yemone uluma sike manda temba.’ ningu⸥ tondolo munduku naa pilimele. Ene konopu karaye tepa pepili molemele yamboma, na ene kinie molopo, wale nambepa molopo mane sipu ulu mare lipu ora simbu kinie mimi siku pilingíye? ⸤Na ene kinie siye tekemo.⸥” nimbelie pe kanu yemondo nimbendo: “Nunge kangomo na moliona mengo oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Memba ombá orumu kinie kanu kurumuni kango kanumu topa lipe manie mundupelie yu torumu kinie Yesusini kurumu iri topa kangomo tepa konde lipelie, yu konde molorumu kinie lapa sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aku sipe terimu kanokolie yamboma Pulu Yemonga tondolomo konopuni pilkulie mini wale munduringi. Yuni terimu mele ene suru ningu mini wale munduku molangi Yesusini yu lombili andolimendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“I nikiru mele pilku konjeyo. Manie Omba Mana Ye Au Lerimu Yemo ⸤ka sikulie yu tonge⸥ yema anju singí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nakolo yuni nirimu ungumu pilku sundukulie ‘I ungumunge pulumu nambolkarenje, naa pilkimulu.’ niringi nakolo “Nambolka ningu nikinuye?” ningu walsiku pilingindu pipili kolko naa walsiringi. Pulu Yemone ‘Ene kanu ungumunge pulumu isili ou naa piliengi!’ nimbe terimu kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","⸤Walse Yesusi lombili andolimene⸥ ene eneno anju yando ungu mele tekolie ningindu: “Olionga ye nae paa olandopa molemoye?” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Enene konopu leringi mele pilipelie, Yesusi ambolango kanga te lipe yu molorumuna nondopa monjipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","enendo nimbendo: “Yambo tene ‘Na Ailimunge yambomo molio.’ nimbe i ambolangomo* lipe taponjimbe kinie kanu yambomone aku tembamonga na lipe taponjimbela. Kanu kinie na lipe taponjimbe yambomone na lipe mundurumu yemo lipe taponjimbela. Enenga ye tene ‘Nanga imbi ola naa molopili.’ nimbe, ‘Ye tenga lupe imbi ola molopili.’ nilimo yemo yu enenga paa olandopa molombamonga ⸤aku sipe ulumu pemba⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yesusi lombili andoli ye Jonone Yesusindu nimbendo: “Ye Nomimu,* olio kanomulu, ye tene nunge imbi lepa** kuru mare yambomanga konopuna molongime “Ongo wendo pai.” nimbe topa makoropa molomu kanomulu. Kanopolie yu olio pea tapu topo naa molemolo kene yundu “Nu aku siku naa tei.” nímulu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aku nirimu kinie pilipelie Yesusini yundu ⸤kanu yemone terimu ulumundu⸥ nimbendo: “Yambo te olio kinie opa tou naa molemo yambomo olionga opa lkerayemo molemo kene enene yundu “Molo.” naa niengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kanu kinie Yesusi kolea aili Jerusalleme yu kolopalie pe mulu koleana olando pumbe walemo nondopa wendo orumu pilipelie konopu tondolo mundupe ‘Jerusallemendo pambo.’ nimbelie pumbe purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yu lombili andoli ye mare lipe mundupelie nimbendo: “Kinié ipulueli kolea Sameria lerimu taono te nondopa lembana peamili kene ene akuna puku olio manda pemolo ulke te koroko liengi.” nirimu kinie puku kororingi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nakolo kanu Sameria yamboma ⸤ene kinie Isirele yamboma kinie opa tou molkolie⸥* yu Jerusallemendo pumbe purumu kanokolie enene “Molo, ya manda naa penge.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aku siku niringi kanokolie yu lombili andoli ye Jemisi kinie Jonotolone yundu ningilindu: “Ailimu, ‘oltone ‘Mulu koleana tepe wendo omba i Sameria yamboma nomba konjipili.’ niembili.’ konopu lekenoye?” ningu walsiringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nakolo yu topele topa elte kanopa iri topa “Aku ningu kenjikimbili.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yu kinie ene kinie kolea tenga puku pepuringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ene aulkena pungí puringi kinie ye te omba Yesusindu nimbendo: “Nu puni koleamanga pali nu lombili ombó.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusini yundu nimbendo: “Pílie! Owa takarama ulke pelemelemanga pelemele; kerama enenga mi takolemelemanga pelemele; nakolo Manie Omba Mana Ye Au Lerimu Yemonga* pelemo kolea te naa lemo ⸤kene, nu ‘Yu lombili pupulie kapola naa molombo.’ ningu pilkulie na lombili wani. We naa wani.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kanu kinie yuni ye tendo nimbendo: “Na pea pambili lombili oi.” nirimu kinie kanu yemone yundu pundu topa nimbendo: “Ailimu, ⸤nu kamu lombili wambo mangali⸥ ou pupu nanga lapamo kinie pea molambo. Pe yu kolomba kinie ono tepolie nu lombili ombó.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nakolo Yesusini yundu altopa nimbendo: “⸤Nanga ungumu naa pilku⸥ yambo kololi ⸤none teli⸥ yambomane yambo kolongema ono teangi.* Nu ‘Pulu Yemo omba ye nomi kingimu molopa yamboma nokomba** temane peangamo yamboma piliengi!’ ningu toko siliku andani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kanu kinie ye tene yundu nimbendo: “Ailimu, nu lombili ombó nakolo ou pupu nanga yamboma kondo kolopo ‘Molai.’ nimbulie pe nu lombili ombó.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesusini yundu nimbendo: “Na ‘Lombili ombómo.’ nimbe ombalie nondopa siye kolomba yambo te yu Pulu Yemo ye nomi kingi molopa nokomba koleamonga kongonomo manda naa temba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kanu kinie Yesusi kolea aili Jerusallemendo pumbe pupelie nirimumuni, yu pumbe purumu kolea marenga ye pokore kumbi lepa lipe mundurumu. Yuni ye tokapu yepoko mako topa ye talo talo nimbe lipe mundupelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ene ungu iku mele topa nimbendo: “Poniena langi aisili nou lepa pelemo nakolo kanu langime puku liku nosingí yamboma layetolo kene Ponie Pulu Yemone ‘Kanu langime liku nosili kongonomo puku tenge yamboma poniena lipe mundupili.’ ningu mawa teangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ene lipu mundukuru yema ene sipisipi melema, yambo owa takara aili kerimene sipisipi topa nolemo mele yamboma molemelena lipu mundukuru.* ⸤Nanga ungumu andoko ningu singí kinie pilku keri pilkulie yambomane ene mindili liku singí.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pukulie, wale tapi kepe, kou mone kepe, mele wale kepe, kimbu su alowa teko monjingíme kepe naa mengo we pangi. Aulkena pukulie yamboma kanoko enendo ungu te naa ningu we pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kolea tenga sukundu pukulie akuna molongendo ulke teluringe puku pepukulie ou aku ulke pulu yambomando ningindu: “Ene konopu peanga pepili molangi.” niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aku ningí kinie kanu ulkena ‘Konopu peanga pepili molambo.’ nimbé yambo te molomu liemo yu konopu peanga pepili molomba. Molo aku ningí kinie kanu ulkena ‘Konopu peanga pepili molambo.’ nimbé yambo te naa molomu liemo ene akuna ‘Pangi.’ nimbu mundukuru yema eneno konopu peanga pepa umbuni te naa tepili molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kongono telemo yemo yu mele papu kalemele kene* pungí ulkena peko, ulke pulu yemone langi simbema nangi. Ulke pinie pinie naa andoko, ulke teluna mindi langi nongo peangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kolea tenga suku pukulie ningímuni, kanu kolea pulu yambomane enendo “Papu ongi. Olio pea molamili wai.” níngi liemo ene langi singíme nongo, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","akuna kuru tomba yamboma teko konde liku, enendo ningindu: “Pulu Yemo omba ye nomi kingi molopa olio nokomba walemo* ene molemelena nondopa ombá.” niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Molo kolea tenga suku pukulie aku kolea pulu yambomane enendo “Ene nambemuna ongiye?” ningu, “Pea peamili wai.” naa níngi liemo ⸤aku koleamo munduku kelko pungindu⸥ aulkena puku angilkulie yambomando ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Enene olio liku su síngimunge ‘Ene kamu molko kenjengi! Pulu Yemone ene lipe naa taponjimbe mele paa piliengi!’ nimbu, olionga kimbuna ya koleamonga ma angilkimuma kepe kulu topolie pukumulu.” niengi. ‘Akumu piliengi!’ ningu aku siku ningulie pe ungu te pea enendo kamu ningindu: “⸤Ene lepi lepi tamili piliengi!⸥ Pulu Yemo omba ye nomi kingi molopa yamboma nokomba walemo nondopa ombá.” niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Nane enendo paa sike nimbu sikirumu: Kote walemo wendo ombá kinie kolea aili Sodomo ⸤yamboma* ou ulu pulu keri aisili sike teringi** nakolo⸥ enenga kote kanga mele pemba. Nakolo i yambo ⸤enendo “Pea molamili wai.” ni naa ningu, enenga ungu pilku naa lingí yamboma,⸥ kote walemo wendo ombá kinie enenga kote aili mele pemba.” nirimu.*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kolea Korasini kinie Besaida taonotolo ⸤akuna molemele yamboma⸥ mindili nongo paa molko kenjingí. Kanu koleatolonga sukundu ulu tondolo aisili terindu ⸤nakolo akuna molemele yamboma konopu alowa naa telemele⸥. Kolea aili Taya kinie Saidonotolonga sukundu* ulu tondolo naa terindu** nakolo kanu koleatolonga sukundu nane ulu tondolo aku sipu telka kanolemelkanje kanu koleatolonga ⸤yambomane⸥ ene ulu pulu keri telemelema koronga munduku kelko, bulu siku, konopu alowa telemelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","⸤Akumunge⸥ kote walemo wendo ombá kinie kanu kolea aili Taya kinie Saidonotolonga ⸤yamboma ulu pulu keri sike telemelemonga⸥ enenga kote kanga mele pemba. Nakolo ene kolea Korasini kinie Besaidatolonga ⸤yamboma⸥ ⸤na ulu tondoloma terindu kinie kanokolie konopu alowa naa teringimunge⸥ kote walemo wendo ombá kinie enenga kote aili mele pemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Kapeniame taono ⸤yamboma enene⸥ ‘Mulu koleana pupu molamili.’ konopu lekemeleye? Aku manda molo. ⸤Enene nanga unguma alieli pilimele nakolo konopu alowa naa telemelemonga⸥ ene kolea kerine puku molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","⸤Aku nimbelie yuni lipe mundumbe terimu yemando ungu te pea nimbendo:⸥ “Enene ungu ningíme pilipe limbe yambomone nane ungu nilio ungumu pilipe limbela. Enene ungu ningíme naa pilipe ‘Olio pea molamili.’ naa nimbe temba yambomone na kinie ‘Pea naa molambili.’ nimbéla. Nando ‘Pea naa molambili.’ nimbé yambomone na ma koleana lipe mundurumu ye kanumundu ‘Pea naa molambili.’ nimbéla.” nirimu. Yesusini aku nimbe pora sipelie ‘Yunge kongono tenjipangi.’ nimbe ene lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","⸤Walse⸥ Yesusini lipe mundurumu ye tokapu yepoko yu molorumuna paa konopu siku yando ongolie enene yundu ningindu: “Ailimu, olione nunge imbi lepolie kuru kerime kepe olione ungu nirimuluma pilku liku teringi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesusini enendo nimbendo: “Aku siku teliku andoringi kinie ⸤kurumanga nomi⸥ Setene* kariapá mele tepa, topa manie mundurumu nane kanorundu, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pilieme! Ene tondolo te sirindu. Yambo nomba konjili kongi ka wambiye molo kiriwara* aku melema ene naa kanoko kambilingí kinie aku melemane ene nanga yamboma ‘Uluri naa tepili.’ nimbu ene kanu tondolomo sirindu.** Olio kinie opa tou ⸤Setene⸥ yu sike tondolo pulimo nakolo ene kanu tondolo sirindumunge yuni ene uluri manda naa temba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nakolo aku sipu nikirumunge konopu naa siku, kuruma enenga ungumu pilku liku telemelemonga konopu naa siku; ⸤Pulu Yemone⸥ mulu koleana ⸤molopa⸥ enenga imbime topa monjirimumunge konopu siku molangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yesusini Pulu Yemonga Mini Kake Telimu kinie konopu aili tepa sipelie Pulu Yemondo nimbendo: “Tara, Mulu Matolo Kinie Nokoko Moleno Ye Nomimu, nane nu kinie “Ange.” nikiru. ‘Olio pilipe konginjili pelemo. Olio oliolio ungumanga puluma pali pilipu konjilimolo.’ ningu pilimele yamboma ene nane telio ulumanga pulumu ‘Naa piliengi!’ ningu naa ningu sirinu. Yambo ambolango pame ⸤mele⸥* molko, nane nilio unguma komu tenjiku molemele yamboma mindi nane telio ulumanga pulumu ‘Piliengi!’ ningu, ene ningu sirinu kanumunge nu kapi nimbu “Papu terinu.” nikiru. Sike Tara, nuni ‘aku sipe wendo ombá kinie konopu simbu.’ ningu aku siku terinumunge ⸤aku sipe wendo okomo.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","⸤Pulu Yemondo aku sipe nimbelie kelepa yambo moloringimendo nimbendo:⸥ “Melema pali Tarane na sirimu. Yambo tene Malo paa sike molemo mele pilipe kanopa imbi silimo yambo te molo; Lapane mindi kanopa imbi silimo. Yambo tene Lapa paa sike molemo mele pilipe kanopa imbi silimo yambo te molo. Malone mindi kanopa imbi silimo; Malone ‘Lapa lipu ora siembo.’ nimbé yamboma ene Lapa kanoko imbi singíla.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kanu kinie yu lombili andoli yema ene eneno moloringine pupe ‘Ene mindi piliengi!’ nimbe enendo nimbendo: “Ene mongone kanolemele melema kinie uluma kinie kanolemele yamboma ene malo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nane enendo paa sike nimbu sikirumu: Ou moloringi yamboma, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema kinie, ye nomi kingime kinie, kanu yambo aisili kinié ene mongone kanoko molemele melema kinie uluma kinie kanongendo “Kanamola!” ningu moloringi nakolo naa kanoringi. Ene kinié komuni pilku molemele melema pilingindu “Piliemola!” ningu moloringi nakolo naa piliringi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pulu Yemonga ungu manemanga puluma pilipe konjirimu ye tene ‘Yuni nimbe kenjimbenje manda manjipu piliembo.’ nimbe Yesusindu walsipe pilipelie nimbendo: “Ungu Mane Silimu, na nambe tembo kinie konde molopo konjipu mindi puli ulu pulumu limbuye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesusini yundu nimbendo: “Pulu Yemonga ungu manema Mosisini bokuna torumu bokuna kanokolie nambolka nimbe molemo kanolenoye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yuni pundu topa nimbendo: “Pulu Yemonga ungu manemane nimbendo: ‘Enene enenga kamelema kinie, enenga minime kinie, enenga tondolomo kinie, enenga pilipe konginjilime kinie, akumane Aili Yawe enenga Pulu Yemo manjiku tondolo munduku konopu monjengi.’ nimbe pepa, ‘Enene eneno yu mele mele konopu monjiku enenga kangimu eneno kondo kolko nokolemele mele aku sikula pulu lemo yamboma konopu monjiku nokoko molangi.’ nimbe pelemo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusini yundu nimbéndo: “Nu paa sike nikinumu. Nu aku siku tenu liemo molopa mindi puli aulkena puni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nakolo Pulu Yemonga ungumanga puluma pilipe yamboma mane sili yemone* ‘Yambomane ‘Na paa pilimo yemo’ ningu piliengi!’ nimbelie kelepa nimbendo: “Nanga pulu lemo yamboma nameleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesusini ungu te pundu topa nimbendo: “Juda ye te kolea aili Jerusalleme mundupe kelepa kolea aili Jeriko pumbe purumu kinie wa noli yema ongo yunge mulu wambale toroko kulku liku yu toko nosiku ene puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kanu kinie Pulu Yemo popo tonjili ye te* kanu aulkemonga maniendo pumbe pupelie nirimumuni, yemo aulkena lerimumu omba kanopalie yu lerimuna siye kolopa aulke kiririme ekendonga omba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pe aku sipela Pulu Yemonga kongono tenjili talape LLipai ye te* yemo toko nosiringine omba kanopalie yu lepili siye kolopa aulke kiririme ekendonga omba yu purumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nakolo Sameria ye te* kanu aulkena pumbe ombalie yemo lerimuna omba kanopalie yu kondo kolopa, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","lerimuna nondopa pupe kangi toringimenga kopongo kinie no waene kinie ondo lepa kanjinjipelie banisini ka tonjipelie nirimumuni, pe yuni yu kangulupe ola lipe yunge kongi dongi bulu mingine ola nosipe memba pupelie yambo ponenge ongo pe pu opu teringi ulke tenga memba pupe nosipe nokopa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Peringili kinie ipulueli ou yu pumbe tepalie nirimumuni, kou pape kina mele wendo lipe ulke pulu yemo sipelie nimbendo: “Yu nokoko konjiyo. Pe i sikiru koumu manda naa tepa nunge kou mare olandopa pumu liemo pe kelepo yando ombolie nunge kou pundu tombo.” nimbe Sameria yemone nirimu.” ⸤nimbe Yesusini aku nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","⸤Aku nimbelie kelepa nimbendo:⸥ “I ye yepoko ongo puringimenga ye wa nolimene toko nosiringi yemonga pulu lerimu yemo naeye? Juda ye ou pulu pulu ongo kanokolo we ongo puringili yetolonga te molo yunge opa tou ye akilipe orumu yemoye?” nimbe walsipe pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pulu Yemonga ungumanga puluma pilipe yamboma mane sili yemo yuni nimbendo: “Yemone yu we kondo kolorumu yemo lemo.” nirimu. Kanu kinie Yesusini yundu nimbendo: “Nu puku aku siku tepui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kanu kinie Yesusi kinie yu lombili andolime kinie ene ongo pukulie kolea tenga pupe ambo Mata yunge ulkena “Pea molamili oi.” nirimu kinie yu akuna purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata yunge angenu Maria molopalie yu Yesusini ungu peanga nilimo nimbémo ‘Piliembo.’ nimbe Yesusi molorumuna omba nondopa manie molopalie nirimumuni, Yesusi ungu nimbe molorumu mele yu pilipe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nakolo Mata yuyu langi kalonjipe, kongono tepa molopalie yu kongono takaraki lerimuna kanu kongonomo mindi pilipelie Yesusi molorumuna pupe nimbendo: “Ailimu, nanga angenu na lipe naa taponjikimuna na nanu mindi langi simbundu kongono tepo molkoro kanokolie kondo naa tekemoye? Yuni na ‘Omba lipe taponjipili.’ ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aku nirimu kinie pilipelie Yesusini yundu pundu topa nimbendo: “Ambo Mata, ulu aisili mele nu konopu aisili liku munduku konopu umbuni tepili moleno ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nakolo ulu telu mindi nu naa pilku teleno. Kanu ulu peangamo Mariane ‘Teambo.’ nimbelie ⸤nanga ungumu pilipe⸥ molemo. Kanu ulu peangamo yuni naa temba aulke te molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Walse, kolea tenga, Yesusi yu Pulu Yemo kinie ungu nimbe molopalie pe nimbe pora sirimu kinie yu lombili andoringi ye tene yundu nimbendo: “Ailimu,* olio Pulu Yemo kinie ungu nimulú mele mane sieni. ⸤No Linjili⸥ Jono yu lombili andoringi yema mane sirimu mele olio aku siku mane sieni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","⸤Aku sipe nirimu kinie pilipelie⸥ Yesusini enendo nimbendo: “Ene Pulu Yemo kinie ungu ningindu i siku mele niengi: “Tara, yambomane ‘Nu imbi ola molopa, ye kake teli peangamo moleno.’ ningu molangi. Nu ye nomi kingimu molko yamboma nokoni walemo wendo opili.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kinié kepe pe alieli kepe olio nomolo langime siyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yambomane olio teko kenjilimele kinie siye kolopo ulu te naa telemolo kene olione nu tepo kenjilimolo kinie nuni aku sikula siye kolko olio ulu te naa teyo. Olio ‘Ulu tene kondi topili.’ naa nieni.” ningu aku siku niengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aku nimbelie pe enendo ungu te pea nimbendo: “Nu nunge pulu lemo yambo te paa ipulueli ai burumi molombana pukulie yundu ninindu: “Ano, ga mare siyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ye ponenge te kolea tenga pumbendo nanga ulkena pemba okomo nakolo na ga te naa lemo kene nuni na ga mare si.” nilina kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yuni nundu nimbendo: “Nuni na umbuni te aku siku naa si.” nilke. “Ambolangoma kinie ou nambune sipu uru pemulu kene na ola molopo wendo ombo melte nu manda naa simbu, molo.” nilke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Nane enendo nimbu sikiru: Yu angena molemomonga ola molopa ga naa silke nakolo nuni yu kimbu kimbu siku mawa telinamonga yu siye kolopa wendo omba ga silke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Aku telkamonga ene ⸤nanga lombili andolime⸥ ndo ungu te pea nikirula: ⸤Lapa, Mulu Koleana Molemo Yemo,⸥ melema mawa teko “Si.” niengi. Aku tenge kinie melema sike simbe lingí. ⸤Lapa molemona⸥ melema korangi. Aku tenge kinie melema sike kanoko lingí. Ulke kerepuluna angilku “Sukundu wamili.” niengi. Aku ningí kinie “Sukundu wai.” nimbe nambune tonjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mawa tenge melema sike simbe lingí, koronge melema sike kanoko lingí, “Sukundu wamili.” ningí kinie sike nambune tonjimbe. Aku temba kene aku teai.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Enenga ye te yunge malo ombalie “Tara, oma te nambo si.” nimbé kinie yunge lapane wambiye te simbeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Molo kangomone “Tara, kera mulu te nambo si.” nimbé kinie yunge lapane kiriwara* molo makena* te lipe simbeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe ene konopu keri pepili molemele yambomane aku siku enenga ambolangoma mele peangama silimele liemo, enenga mulu koleana molemo Lapamone ⸤mele paa olandopa naa simbeye? Olandopa simbemo.⸥ Yambomane yundu “Mini Kake Telimu olionga konopuna omba pepili si.” ningu mawa tenge yamboma yuni ene simbe lingí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Walse ye te yunge konopuna kuru te molorumuna ungu manda naa nirimu kinie Yesusini kanu kurumu makoromba makororumu. Kurumu wendo omba ulsu purumu kinie kanu yemo ungu nirimu. Aku terimu kanokolie yambomane mini wale munduku moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nakolo yambo mare ⸤Yesusi kinie konopu keri panjiringi⸥ kanumane ningindu: “Kurumanga nomi Belsipuli* Yesusinge konopuna molopalie yu tondolo silimona yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yambo marene Yesusi manda manjiku “Nambolka nimbenje.” ningu* yundu ningindu: “Nu sike Pulu Yemone ‘Kongono tenjeni.’ nimbe lipe mundurumunje kanamili, mulu koleana ⸤Pulu Yemone mindi manda temba⸥ ulu tondolo te tei.” niringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Enene aku siku konopuni piliringi mele Yesusini pilipelie ‘⸤Yesusi Setene kinie opa tou moloringilimunge Setenene yu naa lipe taponjilke mele paa piliengi!’ nimbe⸥ enendo nimbendo: “Yambo talape te konopu teluna naa pupili molko suku singine owe panjiku ene eneno opa teko lupe lupe molemele kinie kanu talapemo pora nilimo. ⸤Molo⸥ ulke teluna pelemele yamboma konopu teluna pupili naa molko ene eneno opa telemele kinie kanu yambo talapemo sungu siku lupe lupe molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aku sipela, Setenene yunge kuru te makorolkanje aku telkamonga yunge talapemo kinie opa mele telka. Pe yunge talapemo nambe tepa kapola molemelkaye? ⸤Pora nilke.⸥ Enene nando “Belsipulini yu lipe taponjilimona yuni kuruma makorolemo.” nikimili kanumu. Sike aku telkanje Belsipuli yunge talapemo pora nilke.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Ungu te piliengila! Nane Belsipulinge tondolomone kuruma makorolio liemo enenga yemane naenga tondolomone kuruma makorolemeleye? Akumunge, ⸤enenga ye kuruma makorolemele yemane ‘Pulu Yemone olio tondolo silimona olione kuruma makorolemolo.’ ningu pilimelena⸥ enene nando i nikimili unguma kanu yemane pilku apurukulie “Ene kolo tokomele.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nakolo sike Pulu Yemone na tondolo silimona nane kuruma makorondu liemo Pulu Yemo ye nomi kingimu molomba walemo* ene molemelena koronga wendo omu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ye enge nili tene opa melema ambolopa yunge ulkemo nokopa konjilimo kinie ye tene we manda sukundu omba melema wa naa limo. Yunge ulke lemo melema kapola lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kanu ulke nokolemo pulu yemone ‘Nanga opa melema ambolopolie nanga melema manda nokopo konjimbu.’ nilimo nakolo yunge opa tou ye te tondolo olandopa pulimomo omba yu tomba tepalie opa toumuni ulke nokolemo yemo topa manie mundupe yu ambolemo opa melema anju lipe, yunge ulkena lemo melema lipe memba pupe yunge pulu lemo yamboma moke tepa silimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na naa lipe taponjilimo yambomone na kinie opa tou molemo. Yambo tene na lipe taponjipe ⸤kongi sipisipime⸥ sukundu naa limo yambomone ⸤kongi sipisipime⸥ topa bulu balu silimo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","⸤Yesusini ungu te pea nimbendo:⸥ “Kuru te ye tenga konopuna wendo ombalie, no naa mololi koleamanga pupe manda koro molomba tenga korolemo. Te naa kanopa lenjipelie yuni nimbendo: ‘Na ou molopolie wendo ondu ulkena* kelepo pambo.’ nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aku nimbelie yu omba yu ou molopa purumu ulkemo kanolemo kinie, ulke puri memba tepa peanga tepa we lemo kinie kanopalie nilimomone, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yu kelepa anju pupelie, kuru kara puli paa olandopa yepoko pakara lipe memba omba ene pea kanu ulkena sukundu puku molemele. Kanu kinie aku yemo ou molopa kenjilimo nakolo pe paa kamu olandopa mele molopa kenjilimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusini aku sipe nimbe molopili maku toko moloringine ambo tene ungu tondolo tepa nimbendo: “Nu paa teko konjilinomonga ambo nu memba ame sirimumu yu malo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesusini nimbendo: “Sike nakolo yambo Pulu Yemonga ungumu pilku liku teko molemele yamboma ene malo paa olandopa.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesusi molorumuna yambo aisili sukundu sukundu ongo liku maku toringi kinie yuni enendo nimbendo: “Kinié mana molemele yamboma kerime mindi molemele. Ene teko kenjiku Pulu Yemo liku su silimele yambomane “Na molopo nilio mele sikenje, kanamili kene Pulu Yemone mindi ulu tondoloma manda telemo mele tei.” ningu na mawa telemele. Nakolo ⸤na Pulu Yemo kinie tapu topo kongono telembolo mele lipe ora simbe ulu⸥ te* wendo naa ombá. ⸤Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye⸥ Jona kinie wendo orumu ulu akumuni mindi lipe ora silimo manda kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona kinie ⸤oma aili te kinie⸥ ulu tondolo te wendo orumu ulumuni Ninipa yamboma ⸤kinie ulu umbuni te wendo ombá mele⸥ lipe ora sirimu aku sipe mele Manie Omba Mana Ye Au Lerimu Yemo kinie ulu tondolo te wendo ombá ulumuni kinié molemele yamboma kinie ulu te pe wendo ombá mele lipe ora simbe. ⸤Lipe ora simbe ulu te lupe wendo naa ombá, naa kanonge.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“Ou kolea aili Ninipa yamboma ⸤sike molko kenjiringi nakolo Pulu Yemone ungu umbu tonjirimu mele⸥ Jonane ⸤pilipe⸥ pupe Ninipa yamboma nimbe sirimu kinie pilkulie teko kenjiringi mele kanoko keri kanoko konopu alowa teko molko konjiringi.* Aku teringimunge kinié molemele yambomane Jonanga olandopa ye te ya molemo yemonga ungumu liku su siku naa pilimelemonga kote walemo pe wendo ombá kinie Ninipa yambomane kotena angilku, kinié molemele yambomando “Teko kenjiringi. Mindili nonge kinie papu.” ningí. “Ou ⸤olio Isirele yambomanga ye nomi kingi⸥ Sollomono yu ye paa tondolo te molopa, yu ungu lupe lupema pilipe konginjilimu pepili molorumu mele kolea Sipa nokorumu ambo nomi kuinimu pilipelie, Sollomonone ungu peangama mindi nirimu mele pilimbendo yu kolea suluna molopalie ⸤Sollomono molorumuna⸥ wale aisili aulkena pelipe orumu.** Aku sipe terimumunge, ye nomi Sollomononga olandopa ya molemo yemone nilimo ungumu kinié mana molemele yambomane naa pilku, liku su silimelemonga kote walemo wendo ombá kinie kolea Sipa ambo nomi kuinimuni nimbendo: “Nane Sollomonone ungu peanga nirimu mele pilimbundu aulke suluna orundu nakolo Sollomononga olandopa molorumu yemone nirimu ungumu ene naa pilku, liku su siringi yamboma aku teringimunge ene papu mindili nonge.” nimbé.” ⸤nirimu.⸥*** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","⸤Aku nimbelie Yesusini ungu te pea nimbendo:⸥ “Yambomane tepe llame kandokolie loyekolona naa nosiku, mingine suku naa nosikulie nilimelemone, ‘Ulkena suku pa tepili. Yambo ongema kolea kanangi.’ ningu polona ola nosilimele.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Nunge mongomo nunge kangimunge tepe llame mélemo. Aku kene nunge mongo peanga angilimo kinie nu kangi pali pa tepili moleno kinie nu molko konjilino. Nakolo nunge mongomo keri lemba kinie* nunge kangi pali sumbulu topili andoni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akumunge, nunge kangine pa teli pembamo ‘alowa tepa sumbulu naa topili.’ ningu ⸤kangi pa tepili molemo mele molko konjiyo⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nunge kangine pa tepa tengepea tepili molko sumbulu telu kepe naa topili moloni kinie nunge kangi konopuma pali pa tepili moloni. Tepe llame pa telemo kanolemolo mele nunge kangi konoputolo pa tepili moloni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusini ungumu nimbe pora sirimu kinie kanu Parisi yemanga tene* Yesusindu nimbendo: “Langi pea nambili oi.” nimbelie yu kinie pupe langi nombando manie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nakolo yu ou ki kulumiye naa topalie ga we norumu kanopalie kanu Parisi yemone konopu aisili lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesusini ⸤yu konopu lipe mundurumu mele⸥ pilipelie ⸤ungu iku mele topa⸥ yundu nimbendo: “Ene Parisi yema pellete kinie kapo kinie ulsukundu kulumiye tolemele nakolo akumunge sukundu, enenga konopuna sukundu mele, kalaro aisili molemo. Ulu pulu kerime kinie, melema wa limele ulu pulumu kinie akuna pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ene paa aroma tolemele. Kangi terimu yemone konopumu pea naa terimuye? ⸤Peatolo terimu kene⸥ ene kangi no lelko kake tepili molemele mele aku siku enenga konopu kake tepili molongi liemo papu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ene konopu alowa tekolie yambo koropama kondo kolko enenga nosilimele melema singí kinie enenga konopu kalaro molemomo kolo wangopa kake tepili molonge mele yambomane kanonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Parisi yema, ene mindili nongo paa molko kenjingí! Enene poniena olemo mele kangama lkepa kulue kemu aku sipe melema mengo kambu toko tene tene ningu liku nosikulie telu telu ningu wendo liku ‘Pulu Yemonga kongono tenjili yema siemili.’ ningu silimele. Pulu Yemone aku siku ‘Teai.’ nirimu mele ene papu telemele nakolo ulu olandopa uluma naa telemele. We yamboma kondo naa kolko, Pulu Yemone yamboma konopu monjilimo mele ene manda lelko yamboma konopu naa monjilimele. Aku siku ulu olandopa mele telemelkanje papu. Kinié ulu maniendopama telemele mele munduku naa kelkolie aku uluma kinie ulu olandopama kinie peatolo telemelkanje papu.* Nakolo aku siku naa telemelemonga ene mindili nongo paa molko kenjingí! ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Parisi yema, ene Juda yamboma maku toko Pulu Yemonga ungumu pilimele ulkena sukundu pukulie manie molongendo ye ailime molemele polo peanga akuna ‘molamili.’ ningu mendo puku polo akuna konopu siku molemele.* Yamboma maku toko molemele koleamanga mongo kenge teko andonge kinie ‘We yambomane olio kanoko kapi niengi.’ ningu pilkulie konopu siku pilku molemelela. Aku telemelemonga ene mindili nongo paa molko kenjingí!** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“⸤Parisi yema,⸥ ene yambo ono kolea tenga ‘Yambo inie ono telemele.’ ningu naa pilku walu siku kimbu kambilimele mele ene aku siku molemelemonga mindili nongo paa molko kenjingí!” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesusini aku sipe nirimu pilkulie Pulu Yemonga ungu manemanga puluma pilipe konjirimu ye tene yundu nimbendo: “Ungu Mane Silimu, ‘Nuni Parisi yema aku siku iri tokonomonga olio kepe iri tokono.’ konopu lekemolo.” nirimu kinie pilipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesusini kelepa ene ⸤iri topalie⸥ nimbendo: “Sike nikinu. Ene Pulu Yemonga ungu manemanga puluma pilku konjili yema mindili nongo paa molko kenjingíla! Enene ungu mane siku ‘Teai.’ nilimele mele we yamboma ene pilkulie tengendo umbuni kolemele. Aku siku umbuni aisili mindili siku menge mele ‘Meangi.’ ningu sikulie enene eneno laye kolte kepe ‘Lipu taponjipu meamili.’ naa ningu molemelemonga ene ⸤kepe⸥ mindili nongo paa molko kenjingíla!* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“⸤Ene Pulu Yemonga ungu manemanga puluma pilku konjili yema,⸥ enenga anda kolepalimene Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema* toko konjiringi. Kinié, yandopa, ene kanu yema ono teringi koleama au silimele.** Anda kolepalime enene kanu yema toko konjiringi pilku peanga pilkulie pe kinié ene kanu yema ‘Papu toringi.’ ningu enene ono teringi koleama au silimelemonga ene mindili nongo paa molko kenjingí! ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“⸤Ou enenga anda kolepalimene aku siku teringi, kinié enene aku siku telemele⸥ monga Pulu Yemo yuyu ungu pali pilipe konginjili yemone ou nimbendo: “Nane ye mare ungu umbu tonjipu ‘Enene yamboma ningu siengi.’ nimbu lipu mundupu, ye mare ‘Nanga kongonomo tenjipai.’ nimbu lipu mundumbu kinie* yambomane mundumbu yemanga mare mindili siku, mare toko konjingí.” Pulu Yemone nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","“Koro ou Pulu Yemone ma kokele tepa wamorumu kinie enene Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi ye kanuma toko, pe yandopa yandopa kanu sili yema pali toko konjiringi. Koro ou Adame malo Epele toko konjiku, pe yandopa yandopa kanu sili ye lupe lupema toliku puku, pe kamu Pulu Yemone ungu umbu tonjirimu unguma pilipe yamboma nimbe sirimu ye Sekaraya Pulu Yemo ⸤popo toko kaloli⸥ ulke tembelena sukundu toko konjiringi. Kanuna sukundu suluminia kake telimu anjukundu lepa, Pulu Yemo popo toko melema kaloringi polomo yakondo lerimu, kanu suku singine yu toko konjiringi. Ou moloringi yambomane kanu yema toko konjiringimunge Pulu Yemone ene sike mongo sirimu nakolo kinié molemele yambomane ene Pulu Yemone kote pilipelie anda kolepalimene aku siku teringimunge ene mongo simbela.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Pulu Yemonga ungu manemanga puluma pilku konjili yema, enene ungu manemanga puluma pilku konjilimele nakolo “We yambomane naa piliengi!” ningu ene pilingí aulkemo pipi silimele. Ene Pulu Yemonga bokuna molemo ungumu alieli kanolemele nakolo apurukulie Pulu Yemone “‘Ye te ene lipe taponjipili.’ nimbu lipu mundumbu.” nirimu yemondo nimbe bokuna molemo unguma kanokolie pilku sundulimele. Sumbi siku pilingí aulkemo ene naa pulimele; bokuna aku yemondo nilimo unguma ‘Piliemili pamili.’ ningu molemele yambo lupema pilingí aulkemo “Molo.” ningu pipi silimelela. Aku telemelemonga ene mindili nongo paa molko kenjingí!” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesusini ⸤aku ungumu nimbe pora sipelie⸥ aku ulkemo mundupe kelepa pumbe purumu kinie yuni iri torumu ye Parisime kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie* enene ‘Yu ungu nambolka ungu mare pea nimbelie, yu ungu nimbe kenjimbe kinie yu kote tenjimulú.’ ningulie enene ungu lupe lupe aisili popenge teko walsiku pilkulie “Pundu toko ni.” ningu tondolo munduku niringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kanu kinie Yesusi molorumuna yambo tausini aisili liku maku toko angiliringine ekelepa tepili angiliringi kinie yu lombili andoringimendo ou kumbi lepa nimbendo: “Ene lepi lepi topo, ‘Parisi yema pillawa akoli mele isi nosilimelemo kanoko konjei.’ nikiru.* Enenga isi nosilimele akumu enene ⸤“Pulu Yemonga ulu peangama telemolo.” ningu⸥ kolo toko topele mapele tolemele ulumu. ⸤‘Akumu manda lelko naa teangi.’⸥ nimbu lepi lepi tokoro.** ⸤Parisi yemane sike teko kenjiku molemele mele kamu lopi manda naa tenge.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aki tolemo ulumanga telu kepe pe aki naa topa pali mona lemba. Lopi telemo ulumanga telu kepe pe lopi naa temba. Kanu uluma kinie unguma pali yambomane pali pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sumbulu toline ungu niringime yambomane pa teline pilingí. Ulke suluminiana ungu ólo toko niringi unguma ulke imuna ola angilku ru ningu ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nanga pulu lemo yamboma, enendo ungu te nimbu siembo: Kangimu mindi toko konjikulie pe kelko minimu pea ulu te manda naa tenge yamboma pipili naa kolangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nakolo ene paa pipili kolonge yemo nimbu siembo: Kangi topa konjipelie pe mini pali tepe koleana manda topa mundumbe ⸤Pulu Yemo⸥ yu pipili kolangi. Paa sike nimbu sikiru. Yu pipili kolangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kera kalsindipele paa kangamo molemo, topo toko lingíndu kera te pakara kou kololi talo mindi pulimo kanumu. Nakolo Pulu Yemone kanu kerama nokombando komu naa silimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pilieme! Ene ⸤na lombili andolime⸥, enenga penge indime kepe yuni koronga telu telu nimbe pali kambu torumu. Kera kalsindipele yu kou paa layetolo mele pulimo nakolo kanu keramo Pulu Yemone kanopa molemo. Ene yamboma paa olandopa ailime kanopalie ene paa nokopa konjipe molomba ⸤kene pipili naa kolai.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nane enendo ungu te nimbu siembo: Yambo tene yambomanga kumbikerena ola angilipe ‘Na Yesusinge yambomo molio.’ nimbé kinie pe Pulu Yemonga angellomanga kumbikerena Manie Omba Mana Ye Au Lerimu Yemone ola angilipe “Kanu yambomo nanga yambomo.” nimbéla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nakolo yambomanga kumbikerena “Yesusi yu naeye? Yu na naa pilkiru.” aku mele nimbé yambomo pe Pulu Yemonga angellomanga kumbikerena Manie Omba Mana Ye Au Lerimu Yemone “Aku yambomo yu naeye? Yu na naa pilkiru.” nimbéla.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Manie Omba Mana Ye Au Lerimu Yemo ungu taka tonjipe ungu nimbe kenjilimo yambomo aku sipe ulu keri telemoma ⸤Pulu Yemone⸥ ‘Manie pupili.’ nimbe siye kolomba. Nakolo Mini Kake Telimu ungu taka tonjipe, ungu nimbe kenjipe, marake telemo yambomo aku sipe ulu keri telemomo ‘Manie pupili.’ naa nimbe, paa siye naa kolomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kanu kinie pe ene ⸤nanga yamboma molonge kanokolie⸥ ene ongo ka siku, ene maku toko Pulu Yemonga ungumu pilimele ulkemanga ye ailime kinie, ye nomime kinie, gapomano ye ailime kinie ene molongena ene mengo puku kote tenjingí kinie ‘Kotena nambolka unguri nimulúnje? Olio ungu te walsiku pilingí kinie nambolka unguri pundu topo nimulúnje?’ ningu mini wale naa mundengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akuna Mini Kake Telimuni enene anju ningí mele mane simbe kene mini wale naa mundengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesusi molorumuna liku maku toringi yambomanga tene yundu nimbendo: “Ungu Mane Silimu, nanga angenumu kinie oltonga lapane sirimu monge melema yuni ‘Na mare moke tepa sipili.’ ni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nakolo Yesusini yundu pundu topa nimbéndo: “Yemo, ‘Nane enenga kote pilinjiku enenga melema moke tenji.’ nimbe naene na mako torumuye? Yambo tene nando aku sipe naa nirimu kanumu. Nanga kongono te molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aku nimbelie yuni enendo kelepa nimbendo: “‘Mele aisili lipu nosipu kamako molambo.’ ni naa ningu, ‘Melema lili ulu pulumu yu ulu pulu kerimu kene aku naa teambo.’ konopu lelko molangi. Yambo tene mele aisili lipe nosilimomonga mini pali konde molopa konjimbe aulkemo naa lemo.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","⸤Aku nimbelie Yesusini ‘Enendo nikiru ungumanga pulumu kamu piliengi!’ nimbe⸥ yuni ungu iku te topalie nimbendo: “Walse ye kamako te molopalie yunge poniena langi paa aisili orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akumunge yuni yuyu nimbendo: “Langi nosilio ulkema pali si nimu, langi aisili goli lepa we lemo kene na nambe teamboye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pe kelepa yuni yuyu nimbendo: “Kinié na pilipero. Na i sipu teambo. Na langi nosilio ulkema tekisipulie langi nosimbu ulke paa ailime kelepo takopolie akumanga nanga rasi witi kinie langi kinie nanga poniena olemo langime pali nosembo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Akuna nosipulie na nanu pilipulie nimbundu: Na papu. Na langi aisili, ponie aisili omba pumbe kinie nombo molombo mele lemo kene koro molopo, kongi nombo, no waene nombo, konopu sipu molambo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nakolo Pulu Yemone kanu yemondo nimbendo: “Ye aromamo. Kinié ipulueli nane nunge minimu ombo limbu kinie nunge nosilino melema naene limbeye?” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","⸤Ungu ikumu topa pora sipelie ungu te pea nimbendo:⸥ “Aku sipe mele, ‘Na mele aisili nosilio.’ nilimele yamboma Pulu Yemone ene kanopalie ene yambo koropa pulime nimbe kanolemo. Pulu Yemo kanopa peanga kanolemo ulu puluma naa teko molemele yamboma enenga minime koropa pupili mele molemele. Kanu yamboma ene aku ungu iku tokoro yemo mele molemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","⸤We yambomando⸥ aku sipe nimbelie Yesusini yu lombili andolimendo kelepa nimbendo: “⸤Kolonge kinie mana melemane ene naa lipe taponjimbe⸥ kene nane enendo ungu te nimbu siembo: ‘Kangikundu molopo konjemili.’ ningu konopu aisili liku naa mundengi. Langi nongemonga kepe no nongemonga kepe mulu wambale pakongemonga kepe akumanga konopu aisili liku munduku naa molangi. Ene kapola molonge mele olandopa, langi nonge mele maniendopa; enenga kangi yu olandopa mele, mulu wambale pakonge maniendopa mele kene langi nonge mele kinie, mulu wambale pakonge mele kinie, konopu aisili liku naa mundengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kerama kaname. Langi te panjikulie nou lemo kinie liku mengo ulkendo puku nosiku naa nolemele nakolo Pulu Yemone kerama langi silimo. Kerama we mele, ene yamboma olandopamonga yuni ene paa nokomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Enenga yambo tene konopu aisili lipe mundumbemone yu kolomba ena te manda ‘We lepili.’ nimbéye? Manda naa nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Enene ulu wallo kolte aku sipe mele te manda naa telemelemonga ulu wema ene nambemuna konopu aisili liku munduku molemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pillawa sindime kaname. Pillawa sindimene kongono mindili siku naa teko, mulu wambale te teko mimi naa telemele nakolo pillawa sindime molemele mele olandopa, ⸤ye nomi kingi⸥ Sollomono* kongono aisili tepalie wale paa peangama pakopa au nirimu mele maniendopa. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Era sindi tolemoma kinié mele molemo, opali mele poroko tepena kalemelema Pulu Yemone aku sipe nokopa konjilimo liemo ene ‘Pulu Yemone olio manda nokombanje?’ ningu laye kolte mindi pilimele yamboma pakonge melemanga yuni manda lipe naa taponjimbeye? Ene lipe taponjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“⸤Pulu Yemone kerama kinie era sindime kinie aku we melema aku sipe nokolemo⸥ kene ene konopu aisili liku mundukulie ‘Esi, langi te tena lipu nomolonje?’; molo ‘No tena kolopo nomolonje?’ ningu pilku naa molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pulu Yemonga yamboma naa molko ulsukundu molemele yambomane* aku siku telemele nakolo enenga Lapa ⸤Pulu Yemone⸥ ene yunge yambomanga mele molo tolemoma kanopa molemo ⸤kene ene langi nongemanga kinie mele pakongemanga kinie konopu naa liku mundengi⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","⸤Pulu Yemo⸥ ye nomi kingi molopa yamboma nokolemo uluma* ‘Kumbi lepo teambo.’ konopu lelko molangi. Aku tenge kinie yuni we melema kepe ene simbe.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nanga kongi sipisipi layetolo, enenga Lapa walse ye nomi kingi molopa yamboma nokomba kinie ‘Ene pea ye nomime molko yamboma nokangi.’ nimbé. Yu aku sipe tembando konopu sipe molemomonga pipili kolko naa molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akumunge ene nosilimele melema kou mone liku aku kou mone lingíme yambo koropama moke teko siengi.* Aku siku tekolie pe kou kamu manie naa puli koumu liku nosiku, mele aisili liku mulu koleana ⸤pe pungímunge⸥ nosiku teangi. Akuna wa lili yema ongo wa naa liku, koka molo lkurinia melemane ongo teko kenjiku naa tenge. Ene akuna nosingí melema kamu kapola lemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Enenga nosilimele melema lemo kolea akuna ene konopuni pilku konopu monjiku molemele kene ⸤‘mulu koleana mindi melema lepili.’ ningu molangi.” nirimu⸥.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“⸤Na lombili andolime,⸥ enene ‘Ailimu kinié ombánje.’ ningu mulu wambale pakoko, kako toko, kiye kandoko, molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ye aili te tenga pupe ye te ambo limbe langi koyolemele yamboma kinie anju langi nomba molemo kinie yu kelepa ulkendo ombámonga yunge kendemande yambomane ‘Yu ombá.’ ningu ulke kune linjingindu nokoko molemele mele ene aku siku molangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kanu kendemandemanga nokolimu omba yunge kendemandema kanopalie, uru naa peko we molonge kanomba kendemandema ene konopu siku molonge. “Nane enendo paa sike nimbu sikirumu: ⸤Alieli kendemandemane enenga ailimu nokoko langi kalonjiku silimele mele yu aku siku nokolemelka nakolo kendemandemanga⸥ ye ailimuni ⸤kanu kendemande peangama konopu sipe⸥ yuni kongono mulu wambale pakopa enendo “Langi noli polona molai.” nimbe ‘Langi nangi.’ nimbe enenga kongono tenjipe ene nokomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ipulueli ai burumi ombáne, kera gulta ko tomba kinie ombánje, ene uru naa peko nokoko molongi kanomu liemo ene konopu siku molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“I ungumu konopu liku munduku pilieyo. Ulke pulu ye tene wa noli ye te yunge ulkemo omba bulsupe melema wa limbe enamo pilkenje ‘Wa noli yemo ombá.’ nimbe nokopa molka kinie wa noli yemo yu manda suku naa olka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aku siku ene nokoko molai. Manie Omba Mana Ye Au Lerimu Yemo ombá enamo naa pilimele kene ‘Yu sike ombá.’ ningu aku siku nokoko molangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitane yundu nimbendo: “Ailimu, aku ungu iku toko ningu sikinumu olio ⸤nunge lombili andolimendo manjiku⸥ ningu sikinu molo yambo wemando pea ningu sikinuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aili Yesusini pundu topa nimbendo: “Kongono tenjili kendemande ye naene kongono tepa konjinjilimo kinie kanopalie yunge ye ailimuni ‘Yuni kongono silioma sumbi sipe telemomonga yu kongono simbu kinie tepa konjimbemonga na altopo konopu kimbu sipu naa molombo.’ nilimoye? Kendemande ye te aku sipe mele tepa konjipe molemomo kanopalie yunge ye ailimuni yu mako topalie yundu nimbendo: “Nuni kongono tenjili kendemandema pali nokonjiku enenga langi nongema ena mako toliomonga ene nangi moke teko sieni, nokonjiku moloi.” nimbe ⸤yu tenga pulimo⸥.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pe ye ailimuni kongono simumu kanu kongono tenjili kendemandemone mimi sipe tenjipe molopili ailimu kelepa omu liemo kendemandemo yu konopu sipili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nane enendo paa sike nimbu sikirumu: Kanu ye ailimuni kanu kendemandemondo “Nanga mele nosilioma pali nuni nokonji.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Nakolo ⸤ye ailimuni kanu kendemande yemondo nimbendo: “Nanga kendemande yamboma pali nokonji.” nimbe tenga pulimo kinie⸥ kanu kendemande yemone “Nanga ailimu welea naa ombá.” konopu lepalie yuni nokonjilimo kendemande yamboma kopene topa, langi nomba no tondoloma nomba kekelepa topalie, aku sipe tepa kenjipe molomu liemo ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","walse kanu kendemande yemo ‘Yunge ye ailimu ombá.’ nimbe naa pilipe ⸤kongono sirimu mele naa tepa⸥ walu tepa kenjipe molomba kinie ombá. Omba ⸤kanu yemo tepa molomba mele kanopalie⸥ yu paa kopene topa konjipelie, yunge ungumu pilku su siku kongono ambolko naa konjili yamboma ⸤kolea keri⸥ molemelena ‘Pupili.’ nimbe lipe mundumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kongono teli yambo te yunge ailimuni “I siku i siku tei.” nimbé ungumu sumbi sipe pilipelie ungumu ta nimbé, molo ‘Nikimu mele naa tembo.’ nimbe pilipe aku sipe pilipe lipe naa temba yambo kanumu yunge ailimuni pe yu mongo paa aisili simbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nakolo “Tei.” nimbé mele mimi sipe naa pilipelie we walu tepa kenjimbe yambomo yunge ailimuni mongo laye kolte mele simbe. Yambo mele aisili siringi lipe nosirimu yambomo “Pundu toko mele aisili si.” ningí. Yambo “Mele aisili nokoko moloi.” niringi yambomo “Kelko mele aisili si.” ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“⸤Na lombili andolime,⸥* na ya ma koleana tepe mundumbu orundu. Kanu tepemo isili ou welea nolkanje papu. Na konopu silke.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Na no limbu ulu akumu na kinie wendo ombá. Ulu akumu isili ou wendo naa okomomonga na konopu umbuni tepili molio.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“‘Ya mana yamboma opa naa teko teluna kapola kapola molangi.’ nimbu orundu konopu lekemeleye? Aku molo. ‘Yamboma konopu lupe lupe pepili anju yando opa tou mele molangi.’ nimbu orundu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kinié kepe pe anjupe kepe ulke teluna pelemele yambomanga ⸤marene nanga ungumu pilku molko marene nanga ungumu liku su siku molkolie,⸥ ene eneno opanale teko yambo te pakara ulke teluna peko, yepoko eneno molonge, talo eltelte molongele, yu mele mele molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lapane malo kinie opa tepa, malone lapa kinie opa tepa, teluna kapola naa molongele. Anumuni lemenu kinie opa tepa, lemenuni anumu kinie opa tepa, teluna kapola naa molongele. Bamuni yunge malonga menu kinie opa tepa, malonga menuni bamu kinie opa tepa, teluna kapola naa molongele. ⸤Kanu yamboma kapola naa molonge.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aku nimbelie Yesusini liku maku toringimendo nimbendo: “Enene kolea kolopalie kupe tolemo kinie kanokolie “Lo ombá lemo.” nilimele kinie lo sike olemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe kelepa ipulueli poporome topa, kombukandipi angilimo kinie kanokolie “Ena tondolo temba lemo.” ningu pilimele kinie ena sike telemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“⸤Naa pilkimulu.” nilimele nakolo sike pilimele⸥ yambo kolo toko topele mapele tolime!* Ene mulumu kinie ya mamo kinie kanokolie ‘kolea i sipe i sipe temba.’ ningu kanolemele nakolo kinié ⸤na mana orundu kinie⸥ wendo olemo uluma kanoko molkolie kanu ulumanga ulu pulumu naa pilimele. Aku nambemuna ⸤lipe ora silimo mele⸥ naa kanoko naa pilimeleye?” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Enene nambemuna uluma pilku apuruku ulu peangama pilku naa telemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu kote tenjimbe temba yambomo ‘Kapola kapola molambili ulu te teambo.’ ningulie welea teani. Aku naa tenu liemo nu kote tenjimbe yambomone nunge kote pilili yemo molombana memba pupe simbenje? Pe kote pilili yemone nu ka ulke nokoli yemo lipe simbe, yuni nu ka ulkena lipe mundumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nane nundu paa sike nimbu sikirumu: Nu ka ulkena wendo onindu pundu paa pali tokolie mindi wendo onimu. We manda wendo naa oni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanu kinie Yesusini ungu mane sirimuna moloringi yambo marene yundu temane toko sikulie ningindu: “Kolea Gallilli disiriki yambo marene Pulu Yemo popo melema toko kalko molangi ⸤Romo gapomano ye aili⸥ Paillatene ene topa konjirimu.” ningu temane toringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aku temanemo toringi kinie pilipelie Yesusini enendo nimbendo: “Kanu kolea Gallilli yamboma aku siku mindili noringine pilkulie ‘Gallilli yambo moloringi lupe wemane ulu pulu keri teringi mele maniendopa, kanu mindili noringi yamboma ulu pulu keri teringi mele paa olandopa.’ konopu lekemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Paa sike nane enendo “Aku sipe molo.” nikiru. Ya molkomele yamboma, ene ulu pulu keri telemelema bulu siku munduku kelko konopu alowa naa tengi liemo ene aku siku toko konjingíla.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pe kelepa Yesusini temane te topalie nimbendo: “Kolea aili Jerusalleme sukundu kolea kanga Silloamo kouni takoli ulke aili olana te topa kalalu sipe topa manie mundupelie yambo tene eti* topa konjirimu koloringi. Kanu yamboma ‘Kolea aili Jerusalleme yambo lupe moloringimene pali ulu pulu keri teringi mele maniendopa, koloringi yambomane ulu pulu keri teringi mele paa olandopa.’ konopu lekemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Paa sike nane enendo ‘Aku sipe molo.’ nikiru. Ya molkomele yamboma, ene ulu pulu keri telemelema bulu siku munduku kelko konopu alowa naa tengi liemo ene aku siku kolongela.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aku nimbelie kelepa ungu iku te topalie enendo nimbendo: “Ye tene unju piki te yunge unju waene poniena umbu lerimu. Pe ‘Piki mongo tomba.’ nimbe omba kanorumu kinie te naa torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Piki mongo te naa torumuna yunge unju waene ponie tapu yemondo nimbendo: “Pílie. Ponie talo yepoko pea i unju piki angilimomonga ombo kanorundu nakolo piki mongo telu kepe naa torumu kene yuni ma kopongo we nolemo kene peko toko ele tei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ponie pulu yemo aku sipe nirimu kinie ponie tapu yemone yundu pundu topa nimbendo: “Ailimu, i ponie telumu mindi aku unjumu we angilipili. ‘Unjumu akopa mongo topili.’ nimbu unju puluna era tepo, ma mundupu, kongi le lipu mundupu, teambo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pe nekendo poniemonga mongo tomu liemo papu. Naa tomu liemo kamu peko tani.” nirimu.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Walse, ⸤Juda yambomanga koro moloringi⸥ wale Sambate tenga* Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke tenga suku Yesusi pupelie yamboma ungu mane sipe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Akuna ambo te molorumu, yu kuru topa bulu langorumuna ola angilipe sinio simbendo perepa molorumu. Yu aku sipe molopili ponie tene eti omba purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesusini kanu ambomo kanopalie yundu “Oi.” nimbelie nimbendo: “Ambomo, nu kuru torumumu topa kelepili.” nimbelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ambomo kini ambolorumu kinie yu tamburembu sumbi sipe ola angilipelie Pulu Yemo kapi nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nakolo kanu ulkemo nokorumu yemo yuni Yesusi ⸤koro mololi⸥ wale Sambatemonga yambo tepa konde lirimuna kanopa keri kanopalie akuna maku toringi yambomando nimbendo: “Kongono wale talo pakara lemomanga ‘Konde pamili.’ ningu onge manda. ⸤Koro mololi⸥ Sambate walemonga manda molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yemone aku sipe nirimu kinie Yesusini nimbendo: “Ene topele mapele toli yema,* alieli ⸤koro mololi⸥ wale Sambate wendo olemo kinie ene pali yu mele mele enenga kongi kao molo kongi dongi langi nomba molorumuna moki lelko no olemo kolea tenga ‘No nopili.’ ningu mengo pulimele kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ene enenga kongime Sambate walemonga papu moki lelko nokolemele kene i ambomo Sambate walemonga papu lipu taponjikirula. Kongimu maniendopa mele, ambomo olandopa mele kanumu. Akumunge i ambomo, yu Eporayamone kalopa lirimu ambo te, ⸤kurumanga nomi⸥ Setenene* yu ponie tene eti ka mele sirimu ambomo Sambate walemonga moki lepo nokokoromo tepo kenjikiruye?” nimbe walsirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yuni aku sipe nirimu kinie kanu ungumuni yu terimu mele kanoko keri kanoringime olie poloringi nakolo we yambomane yu ulu tondolo peangama terimu kanokolie konopu aili teko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kanu kinie Yesusini ⸤yambomando⸥ kelepa nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokomba,* mele nambolka mele kanu silimu lembaye? ‘Pulu Yemo ye nomi kingimu molopa yamboma nokolemo mele piliengi!’ nimbu akumu nambe tepo nimbu simbuye? ⸤Nimbu siembo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Akumu i sipe mele: Ye tene yu unju masetete umbu te lipe yunge poniena umbumu mundurumu kinie kanu unju umbumu wendo omba ai lepa unjumu angilirimu kinie aku unjumunge kolamanga kerama ongo peringi. Pulu Yemo ye nomi kingi molomba mele aku sipe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aku nimbelie kelepa walsipe pilipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokomba mele pilingí nambe tepo nimbu siemboye? ⸤Nimbu siembo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Akumu i sipe mele: Ambo tene yu langi pillawa akoli mele isi* wallo kolte lipelie pillawa aisilinge mundurumu kinie pillawa pali akorumu. Pulu Yemo ye nomi kingi molomba mele aku sipe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aku sipe nimbelie pe Yesusi kolea aili Jerusalleme pulimo aulkena pumbe pupelie kolea ailime kinie kangama kinie pupe, akumanga moloringi yamboma ungu mane sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kanu yambomanga tene yu walsipe pilipelie nimbendo: “Ailimu, mindili nomolo aulke molemolona Pulu Yemone yamboma lipe taponjipe wendo lipe yu kinie molko konjingí aulkena lipe monjimbe* yamboma wallotolo mindiye?” nimbe walsirimu. Pilipelie yuni enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ulke kerepulu paa kanga si niline yambo aisili ongo suku pungindu perenge. Akumunge ‘Kanu kerepuluna ene ongo sukundu puku molongendo mindili siku pangi.’ nimbu nikiru.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ulke pulu yemone ola angilipe kune anjimbe kinie ene pena molkolie ningímuni, kune toko walsikulie ningindu: “Ailimu, olio nu kinie pea molamili wamili kene olionga kune linji.” ningí kinie yuni enendo nimbendo: “Enenga imbime na naa pilipu ene kepe enenga koleama kepe na naa kanolio.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Yuni aku nimbé kinie enene yundu ningindu: “Nu pea ga norumulu. Olionga koleamanga nu ongolie olio ungu mane sirinu.” ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Nakolo yuni enendo nimbendo: “Ene niembo piliei. Enenga imbime na naa pilipu enenga koleama na naa kanolio. Ene ulu pulu keri teko molemele yamboma pali na moliona anju pai.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akuna ulsu molkolie ene ⸤anda kolepali⸥ Eporayamo kinie, Aisake kinie, Jekopo kinie, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema pali kinie, ene Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu molonge kanokolie ene eneno akuna ulsu molonge kanokolie ene eneno mumindili kolko kola teko mini wale mundungí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Isirele yamboma ene Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu ene manjiku naa pungí ‘Piliengi!’ nimbelie yuni kelepa nimbendo: “Ma koleana pali yambo mare Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu puku Pulu Yemo pea langi nonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pilieme. Akilku olemele yambo mare Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu kumbi lelko pungí. Kumbi lelko oringi yambo mare akilku pungí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Walse, Yesusi ou Jerusalleme naa pupelie kolea tenga ungu nimbe molorumu kinie Parisi ye marene* ongo yundu ningindu: “⸤Ye nomi kingi⸥ Erotene ‘Nu topo konjembo.’ nimbe molemo kene nu ya naa molkolie tenga kowa pui.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesusini enendo nimbendo: “Na tomba tekemo yemo, yu kolo topa konopu keri peli owa takara pokisi* mele akumu molemona i ungumu puku ningu sipai.” nimbelie nimbendo: “Kinié mele kepe opali talu mele kepe kuruma yambomanga konopuna pelemoma makoropo, kuru toli yamboma tepo konde lipu, molopolie laye pe mele na kongono tepo moliomo pora simbu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nakolo Jerusalleme pumbundu kinié kepe opali talu kepe na we kongono telipu pumbu. Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye te kolea aili Jerusalleme ulsukundu manda naa kolomba kene ⸤na Pulu Yemone ungu umbu tonjilimoma pilipulie yamboma nimbe silimo yemo molio kene⸥ na Jerusalleme ulsukundu manda naa kolombo.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","⸤Aku nimbelie Yesusini Jerusalleme moloringi yamboma yu kondo kolopa akumundu ungu te nimbelie nimbendo:⸥ “O Jerusalleme ⸤yamboma⸥, Jerusalleme ⸤yamboma⸥, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema toko konjiku, yuni ene molemelena lipe mundulimo yema kouni toko konjiku telemele yamboma, kera gulta anumumuni yunge waloma lipe yunge kongona lopi tepa nokolemo mele nane wale aisili ene aku sipu nokolka nakolo eneno “Molo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akumunge pilieme. ⸤Opa touma ene tonge onge kinie Pulu Yemone altopa ene naa nokopa naa lipe taponjimbemonga⸥ opa toumane ongo sike toko munduku enenga koleamo kinie enenga ulke tembelemo kinie kamu toko kalongemonga ene ku penge.* Nane ene ungu te pea nimbu sikiru: Ene Jerusalleme yamboma, enene nando “Pulu Ye Yawene lipe mundurumuna okomo yemo imbi ola molopa, molopa konjipili.”** ningí walemonga na altoko kanonge. Ou molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","⸤Juda yambomanga koro moloringi⸥ wale Sambate tenga* Parisi ye aili tenga ulkena Yesusi langi pea nongendo purumu. Omba molorumu kinie pea langi nongo moloringi yemane yu nemo nemo ningu kanoko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yunge kumbikerena ye kangi akorumu te molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pulu Yemonga ungu manemanga puluma pilku konjiringi yema kinie, Parisi yema kinie,* ene Yesusini walsipelie nimbendo: “⸤Koro mololi⸥ wale Sambate kinie kuru toli yambo te tepo konde limelkanje kapola molo moloye?” nirimu. “Pulu Yemonga ungu manemanga sukundu nambolka nimbe molemoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nakolo yundu ungu te pundu toko naa ningu we moloringi. Kanu kinie yuni kanu yemo lipe tepa konde lipelie yundu “Pui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aku tepalie Yesusi yuni pea moloringi yambomando nimbendo: “Ene molkomele yambomanga ye tenga kango te molo kongi kao te Sambate wale tenga no muru tenga manie tomu liemo kanu yemone yunge kangomo molo kongi kaomo tamburembu wendo naa limbeye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aku nirimu pilkulie ‘Olione “Sambate wale tenga kango molo kongi kao wendo limbe akumu papu.” nímulu liemo yuni “Yemo papu Sambate walemo kinie lipu taponjikiru.” nimbe.’ ningu pilkulie ungu te pundu toko ningí aulke te naa lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Parisi ye ailimunge ulkena langi nongendo oringi yamboma ye ailimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku moloringi* kanopalie Yesusini ene ungu mane sipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Ye tene nu kinie yambo mare pea “Langi namili wai.” nimbé kinie nu ongolie ye ailimenga polo kumbikundu tenga puku naa molani. Nu kanu polomonga moloni kinie pe ye aili te yu imbi olandopa molomba ye te yu kepe ‘Langi pea namili oi.’ nimbé ye te ombá kinie ulke pulu yemone nundu nimbendo: “I ye ailimu nu moleno polo akuna molopili polomo si.” nimbé kinie nu pipili kolkolie polo te lupe, namba naa leli yambomanga polo tenga puku moloni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Akumunge, ye tene nundu “Langi pea namili oi.” nimbé kinie yunge ulkena puku namba naa leli yambomanga polo tenga puku molani. Akuna moloni kinie ulke pulu yemone nu molonine ombalie nundu nimbendo: “Ano, i polona naa molko ye ailimenga polona ongo moloi.” nimbé kinie langi pea nongo molonge yambomane nu kinie temba mele kanokolie nu ‘Ye ailimu.’ ningu kanonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Yambomane eneno imbime ambolko ola limele yamboma ⸤Pulu Yemone⸥ topa manie mundumbe, nakolo yambo eneno toko manie mundulimele yamboma yuni enenga imbime ambolopa ola limbe kanumu.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kanu kinie Yesusini ulke pulu yemondo nimbendo: “Nu yambomanga langi kalonjikulie nunge pulu lemoma kinie, nunge angenali kinie, ye kamakoma kinie enendo ‘Langi pea namili wai.’ ni naa nieni. ‘Enene walse altoko pundu mele toko, nando ‘Langi pea namili oi.’ niengi.’ ni naa nieni, molo! ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nu yambomanga langi kalonjikulie yambo koropama kinie, kimbu ki lkinuwa tambulurumu yamboma kinie, kimbu keri lerimuna mimi siku aulke naa andoringi yamboma kinie, mongo keri lerimu yamboma kinie enendo ‘Langi pea namili wai.’ nieni. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Enene aku langime pundu paa manda naa tongemonga nu konopu siku molko konjini. Walse konopu sumbi nimbe pepili molemele yamboma kolko lomboroko ola molonge aku walemonga ya nikiru mele nu aku siku tenimunge mele kalomba lini.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Parisi yemonga ulkena Yesusi pea langi nongo moloringi ye tene Yesusindu nimbendo: “Pulu Yemo ye nomi kingimu molopa nokomba koleana* langi nomolo yamboma ⸤olio⸥ malo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nakolo Pulu Yemonga Isirele yamboma Yesusi yunge ungumu naa pilku liku su siringimunge mulu koleana puku naa molonge pilipelie yemone nirimu ungumu pilipelie Yesusini ungu te pundu topa ungu iku te topalie nimbendo: “Ye tene ‘Yambo aisili pea langi namili kalambo.’ nimbelie yambo aisilindu “‘Langi kalopolie namili wai.’ nimbú kinie wangi.” nimbe, nimbe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Langi nonge enamo wendo orumu kinie yunge kendemandemondo nimbe mundupelie nimbendo: “Oi “Langi pea namili wai.” nirindu yambomando “Kinié enamonga langi kalonjindu kene namili wangi.” nipui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nakolo ene pali naa ongendo yu mele mele “Takaraki lekemo kene naa omolo.” niringi. Tene nimbendo: “Na ma konde te topo tondumu kanopumbundu na naa ombó kene ninji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tene nimbendo: “Nane kongono teli kongi kao rureponga talo topo tonduma pupu kanopumbundu manda naa ombó kene ninji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tene nimbendo: “Kinié mindi ambo lindumunge na manda naa ombó.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","⸤Aku siku niringi kinie pilipelie⸥ kendemandemo kelepa yando ombalie niringi mele yunge ye ailimu nimbe sirimu. Kanu kinie ulke pulu yemone mumindili kolopalie kendemandemondo nimbendo: “Nu welea lkisiku puku, i kolea ailimunge aulke ailimenga kinie aulke kangamanga kinie puku, yambo koropama kinie kimbu ki lkinuwa tambulurumu yamboma kinie, mongo keri lerimu yamboma kinie kimbu keri lerimuna mimi siku aulke naa andoringi yamboma kinie, ene liku mengo oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kendemandemone aku tepalie kelepa omba nimbendo: “Ailimu, ninu mele tendu nakolo langi noli polona kolea mare we lemola.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanu kinie Ailimuni yunge kendemandemondo nimbendo: “Aku tekemo kene nu altoko puku, kolea ailine ulsu puku aulke ailimenga kinie aulke paka makamanga puku, yambo kanoko lenjinime pali mengo wani. “Molo.” ningí yamboma kepe karaye teko mengo wani. Nanga ulkemo si nipili kene aisili wangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Paa tambu ya kana. Na paa sike ene nimbu sikirumu: Nane pulu pulu “Langi pea namili wai.” nimbu, nimbu mundurundu yambomanga telu kepe paa naa ongo langi nonge. Paa molo.” nirimu.” nimbe ⸤Yesusini aku sipe ungu iku te torumu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesusi aulkena omba purumuna yambo aisili liku maku toko yu lombili andoringi kinie yu we angilipe topele topa kanopalie enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yambo tene na lombili ombando na olandopa konopu naa monjipelie na lombili manda naa ombá. Yunge lapa kinie, anumu kinie, menu kinie, ambolangoma kinie, angenupili kinie, kemulupili kinie, yu yuyu kepe, ene pea olandopa konopu monjipe, na manjipe konopu naa monjipelie na lombili manda naa ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yambo tene ‘Yu lombili pambo.’ nimbelie yamboma unju perana angilku mindili nongo kolemele mele yuni unju pera mele gomo lembando ‘Na yu lombili pumbundu mindili nondu liemo papula; kolondu liemo papula.’ naa nimu liemo na lombili manda naa ombála.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Enenga ye tene ulke aili tondolo te takombando yu ou naa takopalie kanu ulkemonga konopu lipe mundupelie yuyu nimbendo: ‘Ulke takopo pora simbumunge kou mone manda nosilionje molo molo tombanje?’ nimbe pilipelie ‘Nanga kou mone manda nosindu liemo manda takombo.’ konopu kimbu sipe naa molombaye? ⸤Aku sipe temba kanumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yu aku sipe ou naa telkanje pe yu kanu ulkemo takombando unju pote mindi topo topa lipe polopalie pe kou mone molo tomba kinie kamu manda naa takopa pelka. Akumunge yambomane yu ungu taka tonjiku tae tenjilimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Enene tae tenjiku ungu ururumi toko ningindu: “I yemo ulke aili tondolo te takomba takorumu nakolo yunge kou mone molo torumuna yu manda naa takopa pora sirimu.” ningu tae tenjilimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“⸤Te walsikirula.⸥ Enenga ye nomi tenga talapemo kinie ye nomi kingi tenga lupe talapemo kinie opa tengele kinie te yu tomba temba, te yunge koleana we molomba. Ene omba tomba ye nomi kingimu yu opa teli ye tuwendi tausini memba ombá. Nakolo we molomba ye nomimu yunge opa teli ye tene tausini mindi molonge. Kokele tonge onge kinie we molomba ye nomimu yunge yema walsipe pilipelie nimbendo: “Olio opa teli ye tene tausini mindi molopolie olio ongo tonge yamboma anju manda tamili molo moloye?” ni naa nimbéye? ⸤Aku sipe manda manjipe pilipe molomba kanumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kanu kinie kanu ye nomi kingimu yuni ‘Olione ene anju manda naa tamili.’ nimbe pilimu liemo yunge ye mare lipelie, ye tuwendi tausini memba ombá ye nomimu aulke suluna ombámonga “Pai.” nimbe lipe mundupelie nimbendo: “‘Opa naa tepo we taka lepo molamili kene nane nambolka ulu te teamboye?’ ningu walsiku pilipai.” nimbé.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","⸤Ungu ikutolo topa kelepalie nirimumuni, pe ungu ikutolonga ye talone telembelka melemonga ungu pulumu ene nimbe sipelie nimbendo:⸥ “⸤Kanu yetolone telembelka⸥ aku sipe mele enenga yambo te yuni ‘Na lombili wambo.’ nimbelie yunge melema pali kinie, yunge yamboma kinie, yunge kou mone kinie, yunge kangi kinie, aku melema mindi konopu monjipe na olandopa konopu naa monjilimo yambomo na lombili manda naa ombá.”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","⸤Aku nimbelie kelepa nimbendo:⸥ “Api kusa akumu mele peangamo nakolo yu songo naa temba kinie ‘Yu kelepa songo tepili.’ ningu ulu te manda temoloye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kanu api kusa songo naa telimu nambe temoloye? ‘Poniena lipu mundumulú kinie langi manda naa ombá; yu ma kopongo te molo.’ nimbu kanopolie we ele temolo.”* ⸤nimbelie⸥ “Yambo komu peo lemba yambomane i nikiru mele piliei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kou takisi lili yema kinie ulu pulu kerime teli ye wema kinie ene pali Yesusinge ungu pilingindu yu molorumuna nondoko oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi yema kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie enene aku teringi mele kanokolie konokono ningu ningindu: “I yemo yu tepa kenjikimu. Ulu pulu kerime ambololi yamboma “Pea molamili wai.” nimbelie, langi alieli ene pea nongo molemelela.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesusini ene aku siku niringi pilipelie ⸤i ungu ikuma ene topa sirimu.⸥ Ungu iku imu topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Enenga ye tene kongi sipisipi* pape paono monjilke kinie te talopa lelkanje yuni sipisipi po paono tene kelepa nani wema kolea ku leline molangi kelepa pupe, talopa lelka sipisipimu kanopa limbendo korolipe naa pulkeye? ⸤Korolipe pulke.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pe kanopa lipelie yuni konopu sipe apu topa ulkendo memba pulke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kanu kinie ulkendo ombalie yemone yunge pulu lemo yambomando kinie yunge ulke kere pongolo pelemelka yambomando kinie walsipelie nimbendo: “Nanga kongi sipisipi* talopa lemumu kanopo lindu kene pea konopu sipu molamili wai.” nilke.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","⸤Nimbelie ungu ikumunge pulumu nimbe para sipelie nimbendo:⸥ “Nane ene ungu te nimbu sikirumu: Yambo konopu sumbi nimbe pepili molemele yamboma aku siku molemelena ene ulu pulu kerime munduku kelko konopu alowa tenge aulke te naa lemo kanumu,* kanu yamboma mulu koleana angellomane konopu we silimele. Nakolo sipisipi nokoli yemone yunge sipisipi talopa lelimu kanopa lipelie paa olandopa konopu silke mele aku sipe ulu pulu keri ambololi yambo te yunge ulu pulu keri telemoma pilipe keri pilipe mundupe kelepa konopu alowa tembamonga angellomane paa olandopa konopu singí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","⸤Nimbelie kelepa ungu iku te pea topalie nimbendo:⸥* “Te i walsikirula: Ambo te kou mone suruli mele engaki rureponga talo nosipelie nilkemone, pe kanu kou suruli mele te manie pulkenje yu tepe llame kandopa ulke puri memba kanopa limbendo naa korolkaye? ⸤Paa korolkamo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kanu kinie kanu koumu kanopa lipelie yunge pulu lemo yamboma kinie yunge ulke kere pongolo pelemelka yamboma kinie walsipelie nimbendo: “Nanga kou mone suruli manie pumumu kanopo lindu kene pea konopu sipu molamili wai.” nilke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Nane ene nimbu sikirumu: Kanu ambomo konopu silke mele aku sipe ulu pulu keri ambololi yambo te yunge ulu pulu keri telemoma pilipe keri pilipe mundupe kelepa konopu alowa tembamonga Pulu Yemonga angellomane konopu singí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","⸤Aku nimbelie⸥ Yesusini kelepa ⸤ungu iku yepoko sipemo pea topa ye ailime mane sipelie⸥* nimbendo: “Ye te, yunge kango talo moloringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Walse akiliomone lapando nimbendo: “Tara, nu kolonimunge monge melema isili ou moke teko na sini mele sieni.” nirimu kinie kanu yemone yunge nosirimu melema moke tepalie yunge kangotolo sirimu liringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kanu melema elte sirimu kinie akiliomo wale pokore mindi molopalie, pe mele sirimuma pali lipe memba aulke sulu tenga purumu. Aulke sulu pupelie nirimumuni, kolea tenga pupe molopalie yu ‘Langi peangama nambo.’ nimbe, ‘Mulu wambale peangama pakambo.’ nimbe kou mone aili tepa pulimo melema topo topa lipe panjipelie, ‘No nambo.’ nimbe topo topa lipe, ‘Amboma pea peamili.’ nimbe kou mone sipe, aku telipe purumu kinie yunge kou mone melema pali pora nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yunge melema kinie kou mone kinie pora nirimu kinie yu paa koropa purumu. Kanu kinie yu molorumu koleana engele aili tepa lerimu kinie yu melema pali molo torumu kinie yu paa engelene kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yu engele terimuna yu kanu kolea pulu ye te molorumuna pupe “Kou kongono te teambo si.” nimbe mawa terimu kinie yuni nimbendo: “Kapola, nanga kongi tapu tenjiku langi nurupuluma ‘Nangi.’ ningu liku si.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ga kiluma kinie konapa buluma kinie kongi sirimuma ‘Nambo.’ nimbe pilipe molorumu nakolo yu te naa siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kanu kinie pe yu konopu lipe mundupe pilipelie yu yuyu nimbendo: ‘Taranga kongono tenjilimele yamboma ga aisili nongo olo telemo nakolo na ya engelene kolopolie kamu kolombo tekero. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akumunge na pupu Tara molemona pupulie yundu nimbundu: “Tara, nu kinie Mulu Koleana Molemo Yemo kinie nane tepo kenjirindu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na kango kerimu kene nunge marena molombo kapola naa temba kene nunge kongono ye te molambo.” nimbú.’ nimbe pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aku nimbe pilipelie yu molorumu koleamo mundupe kelepa, lapa molorumuna pumbe purumu. Yu ulkendo pumbe purumu kanu kinie yunge lapane yu sulu tepa orumu kanopalie yu kondo kolopa lkisipe pupe yu kangulurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kanu kinie kangomone lapando nimbendo: “Tara, nu kinie Mulu Koleana Molemo Yemo kinie nane tepo kenjirindu. Na kango kerimu kene nunge marena molombo kapola naa temba kene nunge kongono ye te molambo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aku sipe nimbe molorumu kinie lapane yunge kongono tenjiringi kendemande yemando nimbendo: “Welea puku nanga mulu wambale peangamo liku mengo ongo yu pakonjiku, ki ongi te liku yunge kíne monjinjiku, kimbu su liku yunge kimbuna monjinjeyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Aku tekolie kongi kao walo ailimu toko kalonjiku molombolona mengo wai.” nirimu. “Nanga kangomo yu koronga ou purumu, ‘Yu kolorumunje.’ nimbu pilirindu nakolo kinié yu kelepa okomo. Yu ou pupe tepa nema lirimu nakolo kinié altopa okomo kanopo likimulu kene konopu sipu kongi kao nombo molamili.” nirimu kinie ene aku siku konopu siku kongi nongo moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nakolo yunge kango komomo poniena kongono tepa molopalie pe ipupini ulkendo ombá orumu kinie ene konopu siku musiki toko denisi teko moloringi ungumu pilipelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","yuni kongono kendemande ye tendo “Ungu te niembo oi.” nimbelie nirimumuni, yundu walsipelie nimbendo: “Ulu tekemelemo nambemuna tekemeleye?” nimbe walsirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kanu kongono kendemande yemone yundu pundu topa nimbendo: “Angena omuna laniene kanopa yu manda mele molopa ulu te naa tepa omuna kanopalie konopu sipe “Kongi kao walo ailimu namili.” nimbe topa kalomu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aku sipe nirimu pilipelie komomo yu mumindili kolopalie “Na ulkena suku paa naa pumbu!” nirimu. Aku nirimu pilipelie lapane wendo omba yundu nimbendo: “Olio pea konopu sipu molamili oi.” nimbe mawa terimu kanu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","lapando pundu topa nimbendo: “Pílie! Na alieli, ponie aisili, nunge kongono tenjipu molopolie nu nilino unguma alieli pilipu lipu tenge panjipu, walse kepe nunge ungu te karaye naa tepo molio nakolo nuni nando walse kepe kongi meme walo te ‘Kangoma kinie pea konopu siku nongo molangi.’ ningu naa silino. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nakolo kinié nunge kango te omba, yuni ambomando “Na pea peambili kou mone siembo.” nimbe nunge kou mone ene sipe pora sirimu, kanu kangomo omu kinie nu konopu siku ‘Kongi kao walo ailimu namili.’ ningu tonu lepamo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Lapane yundu pundu topa nimbendo: “Kangomo, nu kinie na pea alieli molembolo kinie nanga melema pali oltonga. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nakolo kinié angena kolorumu kanumu altopa omu. Yu ou pupe tepa nema lirimu, kinié kelepa omu kanopo likimulu kene olio papu konopu sipu musiki topo langi nombo molkomolo.” nirimu.” ⸤nimbe Yesusini⸥ nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","⸤Aku nimbelie⸥ Yesusini yu lombili andolimendo nimbendo: “Walse ye kamako te molorumu kinie yunge mele nosirimumanga nokoli ye te molorumula. Walse yambo marene kamakomo molorumuna ongo, yunge melema nokonjili yemone terimu mele ongolie yundu ningindu: “Nunge mele nosilinomanga nokonjili yemone nu tepa kenjipe, nunge melema ‘We manie pupili.’ nimbe yu akuma nokopa naa konjilimo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aku niringi pilipelie kamakomone kanu yemondo ‘Oi.’ nimbelie yundu iri topa nimbendo: “I ungu nambolka ungumu nikimiliye? Nuni nanga melema teko kenjilino mele níngi kinie pilipulie nuni nanga melema terinu teleno mele bokuna toko, yando sikulie pe pani. Nu nanga melema altoko manda naa nokani. Nu makorombo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kanu melema nokonjili yemo yuyu nimbendo: “Apa! Kinié nambe teamboye? Nanga ailimuni nanga kongono teliomo wendo lipe na makoromba tekemo kene na nambe teamboye? Na ma akumbundu tondolo naa pulimona aku kongonomo manda naa tembo. Yamboma langi mawa tembondo pipili kolombo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akumunge na tembo mele kinié pilipero. ⸤Nanga ailimuni pundu anjirimu yamboma lipu taponjipulie enendo ‘Pundu ekendo mindi tangi, ekendo manie pupili.’ nimbú kinie⸥ pe na makoromba kinie kanu yambomane na konopu siku liku taponjikulie nando “Pea peamili oi.” ningí.” nimbelie nirimumuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","yunge ailimuni pundu anjirimu yamboma ‘Yu mele mele wangi.’ nimbe kumbi lepa orumu yemondo nimbendo: “Nanga ailimuni nu kinie nambolka mele pundu anjirimuye?” nimbe walsirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","yuni pundu topa nimbendo: “Wele mingi pape paono pundu anjirimu.” nirimu kinie kamakomonga melema nokonjili yemone yundu altopa nimbendo: “Pundu anjili bokumu i sikiru; ya manie molko, pape paono toko monjiringi gomomo ora toko ele tekolie kolo wangoko gomo kondena wele mingi tu paono tene welea toko monji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yunge bulkundu orumu yemondo nimbendo: “Nanga ailimuni nu kinie nambolka mele pundu anjirimuye?” nimbe walsirimu kinie yuni pundu topa nimbendo: “Rasi witi wale pape paono pundu anjirimu.” nirimu kinie melema nokonjili yemone yundu altopa nimbendo: “Pundu anjili bokumu i sikiru; ya manie molko, rasi witi wale pape paono toko monjiringi gomomo ora toko ele tekolie kolo wangoko gomo kondena rasi witi wale po paono welea toko monji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yu aku terimu pilipelie ye kamako ailimuni kanu tepa kenjili yemo yu kapi nirimu. Yunge melema sike wa mele lipe tepa kenjirimu nakolo yunge pilipe konginjilimu paa olandopa perimu pilipelie yu kapi nirimu. “Ya mana molko, Pulu Yemo konopu naa monjilimele yamboma, enenga pilipe konginjilimu paa olandopa; pa teline molko Pulu Yemo konopu monjilimele yamboma enenga pilipe konginjilimu maniendopa. We yambomane yambo te kinie kou kongono tengendo, molo ulu te tengendo aulkemo sumbi siku kanoko akisiku konjilimele; pa teline melemele yamboma aku sipe tondolomo maniendopa pelemo. We yamboma aku siku molemelemonga ⸤ye ailimuni tepa kenjili yemo aku sipe kapi nirimu.⸥” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nane enendo nimbu siembo: Kinié ya mana molkolie mana melema liku ‘Yamboma nunge angenali mele molangi.’ ningu nunge mele nosilinomanga ene liku taponjeni. Pe melema pora nimbé kinie nu kolea peanga kamu kamu lembana puni kinie akuna molongemane nundu “Ya kamu pea molamili.” ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yambo tene yambo tenga mele layetolo nokopa konjinjilimo kinie kanopalie ‘Mele aisili simbu kinie nokopa konjinjimbe lemo.’ nilimo. Yambo tene yambo tenga mele layetolo nokopa kenjinjilimo kinie kanopalie “Mele aisili simbu kinie nokopa kenjinjimbe lemo.” nilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nuni ya mana nosilimele melema nokoko naa konjinu liemo nu paa sike mele aisili peanga lupema, Pulu Yemone silimo mele aisili peangama, ‘Nokonjeni.’ manda naa nimbé. ⸤Ya mana nosilimele melema maniendopa, Pulu Yemone silimo mele aisili peanga lupema olandopa kanumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nuni ya mana nosilino melema paa sike nunge molo, kanu melema Pulu Yemonga. Akumunge nuni yunge melema nokoko naa konjinjinu liemo pe yuni ‘nunge noseni.’ nimbe simbe tepa molemo melema manda simbeye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kendemande yambo teluni ye aili talonga kongono lipe tere lepa manda naa tenjimbe. Ye aili te konopu keri panjipe, te konopu monjimbe. Molo aku naa temu liemo ye aili tenga ungu nimbéma paa konopu sipe pilipe lipe kongono nimbéma tondolo mundupe tenjipe, te konopu keri panjipe yunge ungu nimbéma ta nimbé. Yambomane Pulu Yemonga kongonomo kinie Kou Monemonga kongonomo kinie liku tere lelko manda naa tenjingí.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesusini aku sipe nirimu pilkulie Parisi yema ene kou mone kepe melema kepe konopu paa aisili monjiringimunge yuni ungu nirimumu liku su siku tae teringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesusini enendo nimbendo: “Ene eneno i siku ningindu: ‘We yambomane olio Parisi yema konopu sumbi sipe pepa, peangama molemolo kanoko niengi.’ ningu molemele nakolo enenga konopuna paa sike pelemo mele Pulu Yemone kanopa molemo. Mana yambomane kanokolie ‘Mele paa peanga, mele paa olandopamo.’ nilimele melema Pulu Yemone kanopa keri kanolemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“⸤No Linjili⸥ Jono ou mana naa omba molopili Pulu Yemone yamboma ‘Teai.’ nirimu mele ⸤Pulu Yemonga ungu manema yando nimbe sirimu ye⸥ Mosisini torumu bokuma kinie, Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane boku toringime kinie, kanu bokumanga molorumu, yandopa yandopa mane siku yamboma ningu siringi.* Nakolo kinié, Pulu Yemone omba ye nomi kingimu molopa yamboma nokopa konjimbe temane peangamo topo silipu andolemolo. Pulu Yemo ye nomi kingimu molopa yamboma nokomba yambo talapena** sukundu puku molongendo yamboma ekelepa teko pulimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mulu kinie ma kinie walse manda pora nimbé nakolo Pulu Yemone ungu manema Mosisini yando nimbe sipe boku torumu bokumanga molemo ungumanga imbi torumumanga imbi telu paa wallo kolte kepe manie manda naa pumbe.* Pulu Yemonga ungu manema pali lepa mindi pumbe.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ye tene yunge ou limo ambomo makoropa “Kamu pui.” nimbelie kelepa ambo te limo kinie aku yemone wa ulu kerinele telemo. “Pui.” nimbe makorolemo ambomo pe ye tene yu limo kinie kanu yemo kepe wa ulu kerinele telemola.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","⸤Nimbelie Yesusini kelepa temane te topalie nimbendo:⸥ “Ye kamako te molorumu. Yunge wale pakoli paa peanga kou paa olandopa pulime pakopa, alieli yunge ulkena langi peangama mindi nomba perimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ye koropa te molorumula, kanumunge imbi LLasirasi. Yu enamanga taki taki ‘Kamakomone yu kondo kolopa kou mone te molo langi te simbenje.’ ningu yunge ulke kerepuluna ‘Molopili.’ ningu mengo ongo monjiringi. Yunge kangime pali ereli terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aku erelime owamane ongo pene mane leringi. Yu ‘Kamakomonga langi pundu manie pumbema lipu nombó.’ nimbe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pe walse koropamo kolorumu. Kolorumu kinie angellomane yunge minimu liku, ⸤Juda yambomanga pulu pulu anda kolepa⸥ Eporayamo molorumuna mengo puringi. Kamakomo kolorumula. Yambomane yu ono teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kanu kinie yu tepe koleana mindili nomba molopalie, yuni mongone olando sipe kanopa aulke suluna Eporayamo kanopa LLasirasi pea moloringili kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanopalie ungu te tondolo mundupe nimbendo: “Toto Eporayamo, na kondo kolkolie ‘LLasirasini nona ki sundumu manie mundupelie ‘Nanga alimbeluna koma lepili.’ nimbe tenjipili.’ ningu yu yando munduyo. Na i tepemonga paa mindili nombo molio.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nakolo Eporayamone yundu nimbendo: “Toto, ou moloringili mele pílie! Elte mana moloringili kinie nu mele aisili nosiku kapola molorunu; LLasirasi yunge mele kerime nosipe, molopa kenjirimu kanumu. Pe kinié yu konopu peanga pepili molemo, nu mindili nongo moleno. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Molo nane “E.” nilkenje yu andine manda naa la olka. Olio kinie ene kinie ai suku singine ⸤Pulu Yemone⸥ kombu ailimu lirimu lemo kanumu. Pe kinié ya molemolo yamboma ‘Ene molemelena anju pamili.’ ningí kinie manda naa pungíla; enenga yamboma ‘Yando wamili.’ ningí kinie yando manda naa ongela.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kanu kinie kamakomone nimbendo: “Aku lepamo kene, Toto, yu nanga pulu koleana pupili mundeni nimbu mawa tekero. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nanga angenupili te pakara molemele kanumu. I kolea mindili noli koleana ene kepe naa wangi kene yuni ene lepi lepi topa ungu nimbe sipe konjipili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nakolo Eporayamone yundu nimbendo: “Mosisini boku torumu bokuma kinie Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane boku toringi bokuma kinie* nosilimele kanumu. Enene kanu bokuma kanoko piliengi!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kanu kinie kamakomone nimbendo: “Toto Eporayamo, aku manda molo. Kolorumu yambo te lomboropa ola molopa ene molemelena pupe nimbe simu liemo ulu pulu keri telemelema pilku keri pilkulie siye kolko konopu alowa tenge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eporayamone yundu nimbendo: “Mosisinge unguma kinie Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemanga unguma kinie ⸤bokumanga toringi molemo akuma⸥ pilí naa pilíngi liemo kolorumu yambo te lomboropa ola molopa pupe nimu liemo yunge ungumu naa la pilingí.” nirimu.” nimbe Yesusini temane te aku sipe torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusini yu lombili andolimendo* nimbendo: “⸤Na⸥ ‘Sike’ ningu tondolo munduku pilimele yamboma kelko bulu siku munduku kelenge uluma sike wendo ombá nakolo yambo tene nanga yambo te kondi tombamonga aku yambomo na bulu sipe anju pumu liemo kanu kondi tomba yambomo mindili nomba paa molopa kenjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nanga yamboma aku sipe kondi tomba yambomo yu kou paa aili te* moko toko nomine lenjiku ‘Yu kamu kolopupili.’ ningu paka toko nomuna paa maniekondo mundulimelkanje paa papu. Aku siku toko mundulimelka kinie yu kolopalie pe yu Pulu Yemonga ambolango tendo ‘Ulu kerime tepili.’ nimbe kondi manda naa tolka. Nakolo yu aku siku nomuna naa mundulimelka kinie yu yamboma kondi tombamonga Pulu Yemone yu mongo aili tepa silke kene enene yu nomuna papu paka toko mundulimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Nanga yamboma, ene eneno telemele mele kanoko konjeme. “Angena tene nu kinie ulu te tepa kenjimbe kinie yu molombana puku ninindu: “Ano, nuni na teko kenjinu.” nieni. Aku nini kinie yu pilipelie nimbéndo: “Ano, sike tepo kenjindu kene kondo kolambo.” nimbé kinie nu kinie kanu ulu keri temba ulumu ‘Manie pupili.’ ningu siye kolani. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kanu kinie ena telumunge yu wale yepoko pakara aku sipe nu kinie tepa kenjipe, pe kelepa wale yepoko pakara konopu alowa tepa nundu “Ano, kondo kolambo.” nimbé kinie kapola, nu wale yepoko pakara kanu ulu keri tembama ‘Manie pupili.’ ningu siye kolani.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kanu kinie Yesusini ou “Nanga kongonomo tenjipai.” nimbe lipe mundurumu yemane* yundu ningindu: “Ailimu, nu ungu nilino mele olio ‘Sike ungumu.’ nimbu laye tepo mindi pilipu lipu ambolemolo kene nuni ‘aili teko pilku liku tondolo munduku ambolangi.’ ningu liku taponjeni.” ningu mawa teringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","⸤Ailimuni⸥ enendo pundu topa nimbendo: “Unju tenga mongo akumu mele paa kangamo nakolo kanu mongomo mana mundulimolo kinie unju akopa ai lepa angilimo kanumu. Aku sipe mele, ene nane ungu nilio mele unju mongo kanga mele paa wallo kolte mindi pilku liku ambolemelkanje, enene ‘Pulu Yemone nanga ungumu manda pilimbe.’ ningu ya angilkimu unju aili akumundu “Nu pulkeno pali lkuruku puku, nomuna kelko angili.” nilimelka kinie kanu unjumu enenga ungumu pilipe lipelie aku sipe manda telka.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","⸤Nimbelie ungu te pea nimbéndo:⸥ “Enenga ye te yunge kendemande ye tene ponie tenjimbe molo kongi sipisipi tapu tenjimbe kinie pe ipupini ulkendo ombá kinie yunge ailimuni yundu “Ya ongo manie molko ga noi.” nimbéye? ⸤Aku manda naa nimbé.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kanu kongono tenjili yemo yu kongono tepa kelepa ulkendo ombá kinie yunge ailimuni yundu i sipe nimbé: “Nanga ga kalonjiku boroko sikulie pe na nanu ga nombo pora simbu kinie nu puku nunge ga kalko nani.” nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ye ailimuni ‘Tei.’ nimbé mele yunge kendemande yemone pilipe lipe tembamonga “Ange, papu tenu.” nimbéye? Aku naa nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Aku sipela, enene Pulu Yemone enendo “Kongono tenjei.” nilimo mele pali teko likulie ene eneno ningindu: ‘Olio kendemande kerime.’ niengi. ‘Yuni olio “Teai.” nilimo mele manjipu tepo, kongono olandopa te naa tepolie olio kendemande kerime molemolo.’ niengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesusi kolea aili Jerusalleme pumbe pupelie nirimumuni,* kolea Gallilli kolea Sameria disirikitolo aulke ai suku singine pupelie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kolea kanga tenga sukundu purumu. Sukundu purumu kinie kuru kendi noli ye rureponga talo yu aulke omba purumuna ongo anju siku angilku ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","enene ru ningulie ningindu: “Yesusi, Ye Nomimu,* olio kondo koloi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yuni ene kanopalie nimbendo: “Pulu Yemo popo tonjili yema molemelena puku, enenga kangime liku ora sipai.”* nirimu. Kanu kinie ene pungí puringi kinie ene kuru pora nimbe umbu kangi angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Enene konde pukulie kanoringi kinie ye akumanga te yando omba ungu tondolo nimbe Pulu Yemonga imbi ambolopa ola linjilipe omba ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesusi angilirimuna manie pupe tamalu pepa yundu “Paa ange.” nirimu. Kanu yemo yu Sameria yemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kanu kinie Yesusini nimbendo: “Nane ye rureponga talo tepo konde naa linduye?* Pe kinié rureponga telu akuma tena molemeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Te pea yando ongo Pulu Yemonga imbi ambolko ola naa linjikimiliye? I ye lupemo mindi okomoye? Isirele ye kuru kendi nomu tepo konde linduma tena molemeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kanu kinie yuni Sameria yemondo nimbendo: “Ola angilku puyo. Nane nu manda tembomonga tondolo munduku pilinumuni nu konde punu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi yemane* Yesusi walsiku pilkulie ningindu: “Pulu Yemo ye nomi kingimu molopa yamboma nokomba walemo tewale wendo ombáye?” niringi. Yesusini enendo pundu topa nimbendo: “Pulu Yemo ye nomi kingimu molopa yamboma nokomba walemo wendo ombándo yamboma mongone kanonge ulu te naa wendo ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ene kinié ya molemelena Pulu Yemo koronga ye nomi kingimu molopa yambo mare nokolemona yu ye nomi kingimu molopa yamboma kinie melema pali nokomba ulumundu yambo tene “Kaname! I wendo okomo.” ningu, “Andi wendo okomo.” ningu, aku mele manda naa ningí. Kanu walemo koronga wendo okomo lemo.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aku nimbelie Yesusini yunge lombili andolimendo nimbendo: “Enene “Manie Omba Mana Ye Au Lerimu Yemo wallo kolte kanamili.” ningí walema wendo ombá nakolo naa kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yambomane “Wine molemo.”, “Ya molemo.”, ningí. Nakolo aku sipe ningí kinie kolo tonge kene ene lombili naa pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kariapá lipe sinjipe telemo kinie koleama pali pa telemo yambomane pali kanolemele. Manie Omba Mana Ye Au Lerimu Yemo aku sipe mele kelepa ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nakolo ou yu mindili aili tepa nombá, kinié molemele yambomane yu liku su siku bulu singí. ⸤Kanu kinie kolopa lomboropa ola molopalie nimbemone,⸥ pe “Ombá.” nikiru mele ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ou ye Noa molopili yambomane teringi mele Manie Omba Mana Ye Au Lerimu Yemo ombá temba kinie yambomane aku siku tengela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","⸤Ma koleamanga pali⸥ no ou naa topili yamboma langi nongo, yema ambo liku, amboma ye puku, aku uluma mindi teko mololiku puringi.* Noa nona andoli sipi ulkemonga suku purumu kinie kepe ene aku siku uluma mindi teko molangi no topa ⸤koleama pali none aki topa⸥ yamboma pali topa konjirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“LLote pea moloringi yambomane aku siku teringila. Ene langi nongo bisinete teko ponie panjiku ulke takoko, we ulu akuma teko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nakolo LLote kolea aili Sodomo mundupe kelepa kowa purumu kanu walemonga tepe kinie kou tepene nolime kinie lo mele muluna manie omba Sodomo moloringi yamboma pali topa konjirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Manie Omba Mana Ye Au Lerimu Yemo kelepa ombá walemonga ou teringi nikiru mele pe aku siku teko molongela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Yu ombá kanu walemo wendo ombá kinie ulke imuna ola molonge yamboma altoko ulkendo puku enenga ulke sukundu nosingí melema puku naa lipangi. Aku sikula poniena molonge yamboma melema lepili nosiku poniena pungí kinie kanu walemo wendo ombá kinie nosingí melema altoko puku naa lipangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","LLote menu terimu mele pilieme. ⸤LLote pea Sodomo munduku kelkolo kowa puringili nakolo Sodomo tepe manie orumuna pilipelie Pulu Yemonga angello tene ou “Iki teko naa kanokolo we sumbi siku kowa pale.” nirimu mele LLote menu naa pilipe lipe, iki tepa kanorumu kinie api kusa au lepa kou mele we angilirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","‘Na naa kolopo konopu simbu uluma mindi tepo molambo.’ ningu Pulu Yemonga ungu naa pilku lingí yamboma sike kolonge. Nakolo ‘Na kolondu liemo papula.’ ningu Pulu Yemonga ungu pilku liku teko molonge yamboma naa kolko molko mindi pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nane enendo paa sike nimbu sikirumu: Manie Omba Mana Ye Au Lerimu Yemo kelepa ombá walemonga ipulueli yambo talo suluminia teluna pengele kinie ⸤Pulu Yemonga angello tene⸥ omba yambo te we pepili mundupe kelepa te lipe memba pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ambo talo langi kalongele teko molongele kinie ⸤angello te omba⸥ ambo te we molopili mundupe kelepa te lipe memba pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ye talo lamana* unju toko angilingilí kinie ⸤Pulu Yemonga angello tene omba⸥ ye te we molopili mundupe kelepa te lipe memba pumbe.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","⸤Yuni nirimu mele pilkulie⸥ enene ningindu: “Ailimu, aku ulumu tena tembaye?” niringi. Yesusini pundu topa ungu iku te topalie nimbendo: “Melema kolopa lemo koleamanga mele kololime nolemele kera ilsepema mele kolopa lemoma kanokolie nongendo manie ongo liku maku tolemele.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Walse, Yesusini ‘Ene alieli Pulu Yemo kinie ungu ningu siye naa kolangi.’ nimbe yu lombili andolimendo ungu iku te topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Walse, kolea tenga kote pilirimu ye te molorumu. Kanu kote pilirimu yemo yu Pulu Yemo kepe mana yamboma kepe, pipili naa kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aku koleana ambo waye te molorumula. Kanu ambomo yuni kote pilili yemo molorumuna alieli omba yundu nimbendo: “Na tepa kenjirimu yemo kote tenjembo. Nuni na liku taponjiku kote pilinji.” nimbe mawa te pu opu terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ambomo ou kokele orumu kinie kote pilili yemone yundu “Molo, nunge kote naa pilinjimbu.” nirimu nakolo ambomo yu alieli omba mawa terimumunge kote pilili yemo pilipe keri pilipelie yu yuyu nimbendo: ‘Na Pulu Yemo pipili naa kolopo, yamboma kondo naa kolopo molio ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nakolo i ambo wayemo alieli omba walsilimomonga pe altopa omba mawa temba kinie na kamu pilipu keri pilimbu kene yunge kote pilinjembo.’ nirimu.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aili ⸤Yesusini aku ungu ikumu topa pora sipelie⸥ ungu te pea nimbendo: “Kote pilirimu ye kerimuni ambo wayemondo terimu mele pilieyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aku sipe mele Pulu Yemone yunge yamboma umbuni silimele yamboma aku telemelemonga kote pilili yemo molopalie kote naa tenjimbeye? Yunge ou mako torumu yambomane ipulueli kepe tangoli kepe alieli “Olionga kote pilinji.” ningu mawa telemele kinie yuni enenga kote naa pilinjimbeye? Yu ou we molopa pe mele “Ene lipu taponjembo.” nimbe taka lepa ombáye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yu temba mele nimbu siembo: Pulu Yemo yu welea omba yunge yamboma lipe taponjimbendo, ene umbuni silimele yamboma kote tenjipelie mindili simbe. Nakolo Manie Omba Mana Ye Au Lerimu Yemo kelepa wale talo sipe manie ombá kinie “Yambo marene ‘Yuni ene lipe taponjimbe.’ ningu yu mawa teko molonge molo molonje?” nimbe omba kanomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yambo mare ene enene pilkulie ‘Na peanga. Na sumbi sipu molio, yambo lupema molko kenjilimele. Ene yambo kerime. Ene kinie tapu topo naa molambo.’ ningu pilku andoko moloringi yambomando Yesusini i ungu ikumu topalie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ye talo yu mele mele ‘Pulu Yemo kinie ungu niembili.’ ningulu Pulu Yemo popo toko kaloringi ulke tembelena puringili. Te Parisi ye te, te kou takisi lili ye te. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi yemo* pende tepa ola angilipelie yu yuyu konopuni pilirimu unguma nimbendo: “Pulu Yemo, yambo lupe molemele mele na aku sipu naa moliomonga nu “Ange.” nikiru. Ene wa nongo, ulu pulu kerime teko, ambo yema wa ulu kerinele teko, telemele. I kou takisi lili yemo tepa molemo mele kepe na naa telio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na koro tenga tenga wale talo langi mi topo naa nombo,* kou mone kinie melema kinie mele tene tene nimbu liomanga telu telu nimbu nu silio.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nakolo kou takisi lili yemo nondopa naa omba anju tenga lupe ma kanopa angilipe, ‘Na ye paa keri te.’ nimbe pilipelie pipili kolopa ki lumuni yunge luwine topa angilipelie nimbendo: “Pulu Yemo, na konopuna ulu pulu keri peli yemo kondo koloi.” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nane enendo paa sike nimbu sikirumu: I yetolonga Pulu Yemone kou takisi lili yemonga ulu pulu kerime siye kolopa, yu ‘ye sumbi nilimu.’ nimbe kanopa molopili ulkendo purumu, nakolo Parisi yemo yunge ulu pulu kerime konopuna we pepili ulkendo purumu.* Yambo eneno imbi ambolko ola limele yamboma Pulu Yemone topa manie mundumbe, nakolo yambo eneno toko manie mundulimele yamboma yuni enenga imbime ambolopa ola linjimbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kanu kinie yambomane enenga ambolango kangama ‘Yesusi yunge kimuni ambolopili.’ ningu yu molorumuna mengo oringi. Mengo onge oringi kanokolie Yesusi lombili andolimene iri toko ⸤“Naa mengo wai.”⸥ niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nakolo Yesusini ambolangomando “Wai.” nimbelie ⸤yu lombili andolimendo⸥ nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yambo talape akumu* i ambolangoma mele molemele yamboma enenga yambo talapemo kene enene i ambolangoma na moliona wangi pipi siku “Molo.” naa niei.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Nane enendo paa sike nimbu sikirumu: Ambolangomane* ‘Pulu Yemo olionga ye nomi kingimu molopili.’ ningu molemele mele aku siku naa nilimele yamboma yunge koleana suku paa naa pungí, molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","⸤Walse⸥ ⸤Juda yambomanga⸥ ye nomi te Yesusi molorumuna omba yundu walsipe pilipelie nimbendo: “Ungu Mane Sili Peangamo, na nambolka uluri tembo kinie na konde molopa konjipe mindi puli ulu pulumu limbuye?” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesusini yundu nimbendo: “Nuni na nambemuna “Peangamo.” nikinuye? Yambo peanga te molo. Pulu Yemo mindi peangamo.” ⸤nirimu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","⸤Aku nimbelie yemone walsirimumunge pundu topa nimbendo:⸥ “Nu ⸤Pulu Yemonga⸥ ungu manema ⸤Mosisini yando nimbe sirimuma⸥ pilino. Yuni nimbendo: “Ambo ye pulime molo ye ambo lilime yambo lupema kinie wa ulu kerinele naa teangi.” nimbe, “Yambo toko naa konjengi.” nimbe, “Melema wa naa liengi.” nimbe, “Yambomanga kote kolo toko naa tenjengi.” nimbe, “Aminieli lanieli kinie teko konjiku, ungu ningí mele pilku liku teko molangi.” nimbe,* ungu mane akuma sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aku nirimu kinie pilipelie kanu yemone nimbendo: “Na kangomo molopolie aku ungu manema pali pilipu lipu tepo molorundu mele yandopa kinié kepe tepo molioko.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yu aku nirimu pilipelie Yesusini yundu nimbendo: “Papu teleno nakolo ulu telu mindi naa teleno. Nu puku nunge mele nosilinoma pali kou mone lipukulie, kou mone linime yambo koropama moke teko sikulie na lombili oi.” nirimu. “Nunge ⸤mana⸥ melema aku teni kinie mulu koleana nunge mele aisili peangama lemba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kanu ye nomimu mele paa aisili nosirimuna Yesusini aku nirimu kinie pilipelie yu konopu keri panjipe konopu umbuni paa tepili anju purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yu aku sipe purumu kanopalie Yesusini yu lombili andolimendo nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungindu yambo kamakoma paa mindili siku suku pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kongi kemele ⸤kongi paa aili te* nakolo⸥ kale suru toline suku pumbendo mindili kanga mele sipelie pumbe. Nakolo yambo kamakoma Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungindu mindili paa aili mele siku pungí.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yuni aku nirimu piliringi yambomane ningindu: “Aku liemo mindili nolemelka aulkena nae manda wendo pupe, molopo konjimulu aulkena pumbeye?* Te molonje?” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","yuni enendo nimbendo: “Yambomane paa manda naa telemele uluma Pulu Yemone manda temba. Pulu Yemo yuni uluma pali kapola telemo. Ulu te yuni manda naa temba te molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","⸤Yuni aku nirimu kinie pilipelie⸥ Pitane yundu nimbendo: “⸤Pe olio kinie nambolka uluri wendo ombáye?⸥ Olio olionga melema pali mundupu kelepo nu lombili purumulu mele pulimolo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesusini nimbendo: “Nane enendo paa sike nimbu sikirumu: Pulu Yemo omba ye nomi kingimu molopa nokomba walemo* wendo ombá mele ‘Yamboma piliengi!’ ningu siliku andongendo enenga ulkema kinie, menupili kinie, angenupili kinie, anupili lapali kinie, ambolangoma kinie, akuma siye kolonge yamboma pali ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ya mana paa olandopa mele aisili likulie pe pungí koleana konde molko konjiku mindi puli ulu pulumu lingíla.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kanu kinie Yesusini ⸤yu lombili andoli⸥ ye engaki rurepo ‘na kinie ene kinie oliolio molamili.’ nimbe ene lipe anju memba pupelie enendo nimbendo: “Pilieme. Olio kolea aili Jerusalleme pumulú pukumulu.* Akuna pumulú kinie ou Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane wendo ombá mele ningu bokuna toringi uluma pali Manie Omba Mana Ye Au Lerimu Yemo kinie kamu wendo ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Juda yambomanga ye ailimene Manie Omba Mana Ye Au Lerimu Yemo liku Juda ye naa molemele yema singí.* Enene yu ungu taka tonjiku yu teko kenjiku yunge kumbikerena lkambe toko, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","yu ka pulsene toko yu toko konjingí. Yu toko konjingí kinie wale yepoko sipemonga lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nakolo yuni ungu nirimumu pilku sunduringi. Ungu pulumu naa pilkulie ungu nirimumu pilku sunduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kanu kinie Yesusi Jeriko taono nondopa ombá orumu kinie mongo keri lerimu ye te aulke alselsena molopa yamboma “Kou mone siei.” nimbe mawa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kanu yemone yambo aisili ongo pungí puringi pilipelie yuni “Nambe tekemeleye?” nimbe walsirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","enene yundu ningindu: “Nasarete ye Yesusi omba pukumu.” ningu, ningu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aku niringi pilipelie yuni tondolo ru nimbe walsipelie nimbendo: “Yesusi, ⸤ye nomi kingi⸥ Depisini kalopa lirimu yemo, na kondo koloi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kumbi lelko puringi yambomane yu iri toko “Nu ungu naa nili taka lelko moloi.” niringi. Nakolo yuni paa tondolo ru nimbe walsipelie nimbendo: “Depisini kalopa lirimu yemo, na kondo koloi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesusi we angilipelie “Yu yando mengo wai.” nirimu. Yu Yesusi angilirimuna nondopa orumu kinie Yesusini yundu walsipe pilipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nane nu nambe teambo konopu lekenoye?” nirimu. Yuni pundu topa nimbendo: “Ailimu,* na mongone melema kanambo nanga mongotolo teko peanga tenjeni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesusini yundu nimbendo: “‘Nane nunge mongotolo kapola tenjimbu.’ konopu lenumunge nu umbu mongo kapola angilipili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesusini aku nirimu kinie yu tamburembu mongotolo peanga lerimu, melema kanopalie Pulu Yemo kapi nimbe yunge imbi ambolopa ola linjilipe Yesusi lombili purumu. Yambomane pali kanu ulu ⸤tondolo wendo orumumu⸥ kanokolie enene kepe Pulu Yemo kapi niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesusi yu Jeriko taono omba pumbe purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","⸤Jeriko akuna⸥ kou takisi lipe takisi liringi yema nokorumu ye te, yunge imbi Sakiasi, yu akuna molorumu. Yu mele aisili nosipe yu kamakomo molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kanu yemone Yesusi orumu kanomba terimu. Yesusi orumuna yambo aisili liku maku toringine Sakiasi yu ye ponjilimu molopalie Yesusi manda naa kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Akumunge Yesusi orumuna yu lkisipe kumbi lepa pupelie unju sikamo piki te Yesusi ombá orumu aulkena nondopa angilirimu unju tenga omba ola purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusi akuna ombalie we angilipe olando sipe kanopalie yundu nimbendo: “Sakiasi, nunge ulkena kinié na pea molambili pambili welea manie oi.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","yu popenge tepa manie omba yundu “Kapola.” nimbe konopu sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yesusi Sakiasinge ulkena pea puringili kanokolie ou akuna liku maku toringi yambomane ningindu: “Yu ulu pulu keri teli ye te kinie ‘Molambili.’ nimbe pukumu.” ningulie yu terimu mele kanoko keri kanoringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanu kinie Yesusi kinie Sakiasi kinie elte ulkena suku molkololie Sakiasi ola angilipe Ailimundu nimbendo: “Ailimu, nane nundu ungu te niembo pílie. Nanga mele nosilioma ekendo lipu yambo koropama sipulie, pe kou te molo melte kolo topo wa mele lirindu melte altopo wa lirindu mele pundu topo yepoko ola panjipu anju simbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yuni aku sipe nirimu kinie Yesusini yundu nimbendo: “Kinié i ulke pulu yamboma Pulu Yemone lipe taponjipe ‘mindili nolemelka aulkena wendo ongo, yu kinie pea molko konjingí aulkena pangi.’ nilimo ulu pulumu likimili.* Kinié i ulke pulu yemo yu kepe anda kolepa Eporayamone kalopa lirimu ye te kanumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Manie Omba Mana Ye Au Lerimu Yemone* ‘Yambo aulke lou lelko molko kenjilimele yamboma koropo, ene lipu taponjipu mindili nolemelka aulkena** wendo lipu na kinie molko konjingí aulkena lipu monjimbu.’*** nimbe orumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aku sipe nirimu pilkulie Yesusi yu kolea aili Jerusalleme nondopa ombá terimuna* kanokolie we yamboma enene ‘Pulu Yemo omba ye nomi kingimu molomba walemo paa nondopa ombá.’ konopu lelko moloringi. Enene aku siku pilku moloringi pilipelie ⸤Yesusi⸥ yuni enendo ungu iku te topalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nimbendo: “Ye nomi tenga malo kolea tenga aulke sulu pupe yu kingi molomba namba tondolo te lipupelie ‘Pe yando ombó.’ nimbelie yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ou naa pupili yunge kendemande rureponga talondo “Wai.” nimbelie kou kulupi rureponga talo moke tepa ene yu mele mele kou kulupi telu telu nimbe sipelie enendo nimbendo: “Na wele anju molambo i kou mone sikiru likimilimunge ‘Kou te olandopa pea liemili.’ ningu konopu tondolo munduku teko molangi. Pe ombó.” nimbe yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kanu yemo purumu kinie yunge talapena yamboma yu kinie konopu keri piliringine enenga ye te ‘Yu akilipe pupili.’ ningu liku mundukulie ningindu: “‘ “I ye nomimu olionga ye nomi kingi naa molopili.” nimbu molemolo.’ ninji.” ningu yu liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pe kanu yemo kingi nambamo sike lipe memba yando orumu kinie ou kou mone sipe purumu kendemandemando “Wai.” nimbelie “Ene kou mone sirindumunge olandopa kou nambepa liringiye?” nimbe walsirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ou kumbi lepa sirimu yemone omba yundu nimbendo: “Ailimu, nunge kou kulupi te sirinu kanumunge ola panjipu kulupi rureponga talo lirindu.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ye nomi kingimuni yundu nimbendo: “Kendemande peangamo. Papu terinu. Mele kanga sirindumunge nu teko konjirinu kene nu kolea aili rureponga talo nokani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ye talo sipemone omba yundu nimbendo: “Ailimu, nunge kou kulupi te sirinu kanumunge ola panjipu kulupi te pakara lirindu.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ye nomi kingimuni yundu nimbendo: “Aku siku terinumunge nu kolea aili te pakara nokani.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pe kendemande te omba yundu nimbendo: “Ailimu, nane pilipulie ‘Nu bisinete tondolo munduku teko, ‘Kou mone lipu nosimbumunge yamboma mindili nongi liemo mandala.’ ningu ⸤kendemande yamboma ‘Kongono mindili siku teangi.’ ningu siku, ene mele layetolo siku melema pali nunu mindi lino yemo;⸥ ponie yambomane panjinjilimele kinie nu nunu langi melema we akuku liku; ponie naa teleno poniena langi liku nosiku, nu aku siku teko moleno yemo.’ pilipulie pipili kolopo nuni na sirinu koumu kulupi topo nosirindumu i sikiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aku nirimu kinie pilipelie ye nomimuni iri topalie yundu nimbendo: “Nu kendemande kerimu. ⸤Nane nunge kote pilimbu kinie⸥ nunge nikinu ungumuni nunu kote tenjimbe. Nuni pilkulie ‘Ponie yambomane panjinjilimele kinie na nanu langi melema we akupu lipu; ponie naa telio poniena langi lipu nosipu, na aku sipu tepo molio.’ ningu pilku molenoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aku ningu pilkulie nanga kou monemo kou benge ulkena nambemuna naa nosirinuye? Aku telenanje na ombo nanga koumu wendo lipulie kou wallo kolte ola panjiku silimelka lilkela.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","⸤Kanu kendemande yemondo aku sipe nimbe pora sipelie⸥ yuni nondoko angiliringi yambomando nimbendo: “I yemo tepa kenjirimu kene yunge koumu wendo likulie kou kulupi rureponga talo ambolkomo yemo siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Enene yundu ningindu: “Ailimu, yu kou kulupi rureponga talo ambolkomo kanumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Enene aku niringi kinie ye nomi kingimuni kelepa nimbendo: “Enendo nimbu siembo: Melema nosilimo yambomo* nane mare pea simbu, yu paa aisili nosimbe. Nakolo melema naa nosilimo yambomo** yu nosilimoma kepe wendo limbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aku sipe nimbelie kanu ye nomi kingimu yuni ungu te pea nimbendo: “Kinié na teko kenjiringi yamboma mengo wame. Enene nando ningindu: ‘I yemo olionga ye nomi kingimu naa molopili.’ niringi kanu yamboma mengo ongo na kanopo molambo ene toko konjei.” nirimu.” nimbe ⸤Yesusini aku sipe kanu ungu ikumu topa pora sirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Topa pora sipelie kolea aili Jerusallemendo kelepa pumbe purumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kanu kinie Yesusi ⸤kinie yu lombili andolime kinie⸥ ene kolea aili Jerusalleme nondoko ongo, ma pangi te ‘Ma Pangi Unju Ollipi Ponie’ nili akuna lemo kolea kanga talo, Betepasi kinie Betanitolonga oringi. Kanu kinie Yesusini yu lombili andoli ye talo lipe mundupelie, eltendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ne kolea kanga kanokombelena pukululie kongi dongi walo te, yambo te yunge bulu mingine walsikale kepe naa molopa andorumumu ka teko panjingímu ne sukundu molomba kanongele kanumu puku posiku mengo wangili pale. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Posingilí teko molongele kinie yambo tene eltendo “Dongimu nambemuna posikimbiliye?” nimbe walsimu liemo eltene i siku niengili: “Ailimu yu ‘Dongimuni mepili.’ nimuna ombo likimbulu.” niengili.” nimbe elte lipe mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kanu lipe mundurumu yetolo pukulu yuni nirimu mele kanoko lenjikululie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","pe kanu kongi dongi walomo posikulu moloringili kinie dongi pulu yemane eltendo ningindu: “Olionga dongimu nambemuna posikimbiliye?” ningu walsiringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","eltene “Ailimu yu ‘Dongimuni mepili.’ nimuna ombo likimbulu.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kanu kinie dongi kanumu likulu Yesusi molorumuna mengo ongololie enene enenga mulu wambalema kulku, dongimunge bulu mingine ola pauwe tonjiku Yesusi kanuna ola monjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Marene enenga mulu wambalema kulku yu ombá aulkena pauwe toliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kanu kinie yu Jerusalleme paa nondopa omba, ‘Ma Pangi Unju Ollipi Ponie’ nili akuna manie ombá orumu kinie yu lombili puringi yambo aisili konopu aili teko siku ⸤Yesusini⸥ ulu tondolo aisili terimu kanoringimenga Pulu Yemo kapi ningu ungu tondolo munduku ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pulu Ye Yawene lipe mundurumuna yunge kongonomo tenjimbe okomo* ye nomi kingimu molopa konjipili.** Mulu koleana konopu pe nipili molomolo walemo welea opili. Mulu koleana molemo ⸤Pulu Yemonga⸥ imbi paa ola molopili lakopo kapi niemili.”*** niliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aku siku niringi pilkulie pea oringi Parisi ye marene* ⸤we yambomane aku siku niringi mele pilku keri pilkulie⸥ yundu ningindu: “Ungu Mane Silimu, nu lombili andolimene nikimili mele ‘Naa niengi.’ ningu ene iri toi.” niringi kinie** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesusini enendo nimbendo: “Nane enendo i sipu nikiru: I yambomane i siku naa ningu we molongi liemo ya kou lemomane ru ningí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kolea aili Jerusalleme paa nondopa omba kanumu kanopalie nirimumuni, Yesusini kola tepalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nimbendo: “⸤Jerusalleme yamboma,⸥ kinié ene kepe mindili naa nongo kapola kapola molonge aulkemo pilimelkanje papu. Nakolo kinié naa pilimele, naa pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ene molongena wale mare wendo ombá, kanu walemanga enenga opa touma ongo ‘Enenga koleamonga aulke naa lepili.’ ningu ma liku maku toko, pala mele teko opa touma ene molko makaye teko ‘Ene sukundu molangi.’ ningu aku tenge.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aku tekolie ningímuni, pe Jerusalleme ulkema pali toko tekisiku bulu balu sikulie suku molonge yamboma tonge, aku siku tenge walema wendo ombá lemo. Pulu Yemone ⸤ene lipe taponjimbendo⸥ omu walemo enene naa pilingimunge kanu walema wendo ombá.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesusi Jerusalleme suku pupelie nirimumuni, Pulu Yemo popo toko kaloringi ulke tembelena ⸤“Juda yambo naa molemele yamboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ suku pupe kanopalie akuna melema makete teko moloringi yamboma topa makoromba makoropalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","enendo nimbendo: “Pulu Yemonga bokuna ungu te i sipe nilimo: ‘Yambomane nanga ulkemondo “Pulu Yemo kinie ungu nilimolo ulkemo.” ningí.’* kanumu. Ungu aku sipe molemo nakolo enene i ulkemo ‘wa nolemele yamboma lopi teko molemele ulkemo’ mele** ningu pilkulie aku siku telemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yuni enamanga taki taki ulke tembelena suku ⸤“Juda yambo naa molemele yamboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ yamboma ungu mane sirimu. Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* Juda yamboma nokoringi ye ailime kinie, enene yu toko konjingí aulke te kororingi ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nakolo we yambomane yunge ungu komu tenjiku pilku moloringine enene yu toko konjingí aulke te naa kanoko liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Walse ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena Yesusi akuna maku toringi yamboma ungu mane sipe, temane peangamo topa sipe molorumu kinie ye mare, Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, Juda yambomanga tapu yema kinie,* ene ongo ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","yu walsiku pilkulie ningindu: “Nu namba nambolka nambamo likulie i kongonomo telenoye? Naene i kongonomo “Tepui.” nimbe nu nambamo sipe lipe mundurumuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesusini enendo pundu topa nimbendo: “Nane ene ungu te walsipu piliembola. Ene walsimbu mele enene na pundu toko niengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ou ⸤No Linjili⸥ Jono omba yamboma no linjirimu kinie yu mulu koleana ⸤molemo yemonga⸥ kongonomo tenjimbendo yamboma no linjirimu molo ya mana yambomanga kongonomo tenjimbendo yamboma no linjirimuye? ⸤Naene “Tei.” nirimuna terimuye? Ningu siei.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","⸤Yuni aku sipe walsirimu mele pilkulie⸥ enene eneno kerepali ningulie ningindu: “Yuni walsikimu mele olione pundu topo, “⸤Jono⸥ yu mulu koleana ⸤molemo yemonga kongono tenjimbendo yamboma no linjirimu⸥.” nímulu liemo yuni oliondo nimbendo: “Aku liemo ene Jonone nirimu ungumu nambemuna ‘I ungumu sike.’ ningu naa pilku liringiye?”* nimbé. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Molo olione nimulundu: “Yu mana yambomanga ⸤kongono tenjimbendo yamboma no linjirimu⸥.” nímulu liemo we yambomane olio kouni tonge. We yambomane ‘Jono yu paa sike Pulu Yemone ungu umbu tonjirimumu pilipe yamboma nimbe sirimu ye te molorumu.’ ningu pilimele kene enene olio kouni tonge.” ningu eneno aku siku kerepali niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","⸤Eneno aku siku anju yando kerepali ningulie⸥, Yesusindu pundu toko ningindu: “Yuni Pulu Yemonga kongono tenjipelie yamboma no linjirimu, molo mana yambomanga kongono tenjipelie yamboma no linjirimunje. Olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aku siku niringi kinie pilipelie Yesusini enendo nimbendo: “Kapola. ⸤Nane ene walsikiru ungumunge ungu te pundu toko naa nikimilimunge⸥ enene na walsikimili ungumunge ungu te pundu topo nando i kongonomo ‘Tepui.’ nimbe na lipe mundupe namba sirimu yemonga imbimu ene naa nimbu simbula.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kanu kinie maku toko moloringi yambomando Yesusini ungu iku imu topalie nimbendo: “Ye tene unju waene ponie terimu. Ye mare kanopa lipelie enendo nimbendo: “Nanga poniemo tapu tenjiku unju mongoma inie toko nokonjengi. Pe waene mongo polo tomba kinie unju mongoma moke tepo, kongono tenjingí mele mare ene liengi, mare na liembo.” nimbe kanu poniemo ene sipelie yu kolea paa suluringe pupe akuna wale aisili molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kanu kinie pe waene mongo polo tomba terimu kinie ponie pulu yemone yunge kendemande ye te “Nanga waene mongo siengi puku liku menjiku wani pui.” nimbe ponie nokoringi yema moloringine lipe mundurumu. Nakolo kendemande yemo ⸤orumu kinie⸥ ponie nokoli yemane yu wale aisili kopene toko, waene mongo mare naa siku, ⸤“Yemo molemona kelko pui.” ningu⸥ yando we liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Altopa ponie pulu yemone kendemande ye te lipe ⸤“Nanga waene mongo linjipui.” nimbe lipe⸥ mundurumu. Nakolo kendemande yemo ⸤orumu kinie⸥ ponie nokoli yemane yu ambolko likulie kopene toko, teko kenjiku, waene mongo mare naa siku yando we liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Altopa ponie pulu yemone kendemande ye te lipe mundurumu kinie enene yu tokolie poniena ulsu munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aku siku teringimunge ponie pulu yemone ⸤konopuni pilipelie⸥ ‘Kinié na tembo mele pilipero. Nanga malo, na konopu monjilio kangomo,* ene yu pipili kolko liku ai siku yu waene mongo mare singínje.’ konopu lepalie ⸤yunge malo lipe mundurumu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nakolo ponie nokoli yemane ponie pulu yemonga malo ombá orumu kanokolie enene eneno ningindu: “Andi okomo yemo pe lapanga monge melema limbe yemo okomo. Yu topo konjipu, i poniemo olio kamu liemili.” ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","enene yu ambolko liku poniena ulsu mundukulie* yu toko konjiringi.” ⸤nimbe Yesusini nirimu.⸥ ⸤Nimbelie ungu iku akumu topa pora simbendo akuna maku toko moloringi yambomando nimbendo:⸥ “Ponie nokoli yemane aku siku teringimunge pe ponie pulu yemone ene kinie nambolka uluri tembaye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yu omba kanu ye kerime topa konjipelie ‘Ye marene lupe poniemo nokonjengi.’ nimbe lipe simbe.” nirimu. Kanu kinie Yesusini aku sipe nirimu kinie pilkulie enene ningindu: “Pulu Yemone ‘Aku sipe wendo naa opili, paa molo!’ nipili.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusini ⸤Pulu Yemonga Juda yamboma nokoringi yemane yu toko konjingí mele pilipelie⸥* enendo nimbendo: “Pulu Yemonga ungu te bokuna molemomonga ungu pulumu nambolkanje konopu lemeleye? Aku ungumu i sipe mele: ‘Ulke takoringi yemane kanoko keri kanoko toko ele teringi kou kanumu kinié kelepa ulke simu mele ulke enge sinjili kou aili peangamo.’** nimbe molemo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","I kou ⸤nikiru⸥ munge ola yambo te a topa topalie ombele melema elke tomba. Nakolo yambo te molombana ola koumu omba yu topalie kanu yambomo topa nurupulu tomba.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kanu kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, Pulu Yemo popo tonjiringi ye ailime kinie,* ene Yesusini ungu iku torumu kanumu** pilkulie enene teko kenjiku yu tonge teko moloringi mele yuni nirimu pilkulie enene kanu enamonga yu ka singí teringi nakolo kanu ye ailimene we yamboma pipili kolkolie yu naa liku ka siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanu kinie ⸤Juda yambomanga ye ailimene⸥ ‘Yesusi ka sipu ⸤kote tenjimulundu⸥ gapomano yemo molombana membo pumulú.’ ningu molkolie yu kanoko moloringi. ‘Yuni ungu te nimbe kenjimbe kinie ka simulú.’ ningulie ye mare, ‘Konopu sumbi nimbe pepili molemolo. Yunge ungumu konopu sipu pilipu molemolo.’ ningu kolo toko molonge ye mare, liku yu molorumuna liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kanu yemane ongo yundu ⸤kondi tokolie⸥* ningindu: “Ungu Mane Silimu, olio pilipulie, ‘Nu alieli ungu sikema mindi sumbi siku ningu, ungu mane sikema manjiku sumbi siku mane siku tekolie, nu yambo teluringe kepe konopu kimbú naa siku, yamboma pipili naa kolko, enendo pali ungu telu siku kapola kapola ningu siku, Pulu Yemone “Teai.” nilimo uluma paa sike unguma mane siku, aku siku teleno.’ konopu lemolo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","⸤Aku siku teko molenomonga nu nambolka konopu lekenoye?⸥ Olione Romo Gapomano Ye Paa Aili Kumbine Sisamo kou takisi tomulu liemo kapola molo moloye? Pulu Yemone akumundu ungu mane sirimu ungu mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nakolo Yesusini enene yu teko kenjingindu aku siku liku lou siku walsiringi pilipelie enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“⸤Takisi tolemele⸥ kou mongo te na liku ora siei.” ⸤nimbelie enendo kelepa walsipe pilipelie nimbendo:⸥ “I kouna naenga kumbikeremo kinie imbimu kinie molemoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Enene yundu ningindu: “Romo Gapomano Ye Paa Aili Kumbine Sisamonga ⸤kumbikeremo kinie imbimu kinie molemo⸥.” niringi. Kanu kinie yuni enendo nimbendo: “⸤Kou monemo Sisamonga⸥ kene Sisamonga melema Sisamo yuyu siku, Pulu Yemonga melema Pulu Yemo yuyu siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yuni aku sipe ⸤paa sumbi sipe⸥ nirimu mele pilkulie ‘Olionga ungumu paa pundu topa nimbe konjikimu.’ ningu pilku konopu aisili liku mundukulie ungu te altoko naa niringi. Yamboma kanoko molangi yu liku lou siku walsiringi kinie yuni ungu te nimbe na kenjirimumunge “Yu ka siemili.” ningí aulke te naa lerimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","⸤Kanu yema Yesusi kinie kou takisi toli ungumu ningu pora siringi kinie⸥ pe Sadusi ye mare Yesusi molorumuna oringi. Sadusi yema ene ‘Pulu Yemone pe kolemele yamboma topa naa makinjimbe, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo.* Kanu Sadusi yema ongo ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yesusi walsiku pilkulie ningindu: “Ungu Mane Silimu, ⸤Pulu Yemonga ungu manema olio sirimu ye⸥ Mosisini ungu mane sipelie nimbendo: “Ambo limbe ye te ambolango naa membalie ambomo we molopili kolomba kinie kanu yemo yunge angenu molombamone yunge ambo wayemo lipe angenu lipe taponjipe ambolango menjipili.”* nirimu aku sipe nimbe bokuna torumu molemo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","⸤Aku ungu manemonga ulu te olionga ye mare kinie wendo orumu mele nu walsipu piliemili.⸥ “Angenupili yepoko pakara moloringi. Komomo ambo lipe ambolango te naa membalie kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","⸤Ambolango te naa molopili kolorumuna⸥ yunge bulkundu angenumuni ⸤yunge angenu kolorumumunge ambolango ‘Menjembo.’ nimbe⸥ ambo wayemo kelepa lirimu. Yu ambolango te naa menjipelie yu we kolorumula. Yunge angenu bulkundumuni kanu ambomo lirimula nakolo yu kepe we kolorumula. Aku teliku pukulie ye yepoko pakara pali ambolango telu kepe naa mengolie kolko pora siringi kinie akiliomo we kolorumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pe ambomo yu kolorumula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akumunge, kolemele yamboma pe lomboroko ola molonge kinie kanu ambomo ye yepoko pakara pali ya mana liringine ambomo yu ye paa naenga menu molombaye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesusini enendo pundu topa nimbendo: “Ya mana molemele yambomanga yema ambo liku, amboma ye puku telemele ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nakolo Pulu Yemone ‘Yambo kolkolie manda lomboroko ola molko mulu koleana puku molangi.’ nilimo yambomanga yema ambo naa liku, amboma ye naa puku, aku paa naa tenge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kanu yamboma lomboroko ola molongena ene mulu koleana molemele angelloma molemele mele aku siku molkolie, kelko kolou naa kolkolie Pulu Yemonga ambolangoma molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nakolo ⸤ene Sadusimene⸥ ‘Kolemele yamboma lomboroko ola naa molonge.’ konopu lemelemonga ungu te niembola. Mosisini olio lipe ora sirimu mele niembo: Walse Mosisi unju kanga tenga ⸤tepe nomba perimu tepemone unjumu naa norumu kanopalie nirimumuni,⸥ akuna yuni ⸤Pulu Ye⸥ Yawendo imbi lepalie nimbendo: “Eporayamo kinie, Aisake kinie, Jekopo kinie* enenga Pulu Yemo.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pulu Yemo yu kololi yambomanga Pulu Yemo molo. Yu yamboma pali konde molemele kanopalie yu konde mololi yambomanga Pulu Yemo.” nimbe Yesusini nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Aku nirimu pilkulie Pulu Yemonga ungu manemanga puluma pilku mane siringi ye marene altoko yu ungu te walsiku pilingindu pipili kolkolie yundu ningindu: “Ungu Mane Silimu, nuni papu nikinu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kanu kinie ⸤Juda yambomanga ye aili mare aku siku we moloringi kinie⸥ Yesusini enendo altopa ungu te nimbendo: “‘Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu* yu ⸤ye nomi kingi⸥ Depisinge kalopa limbe ye te molomba.’ ningu pilimele, ⸤nakolo yu aku sipe manjipe molo⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","⸤Aku nilimele yemane⸥ Depisi yuni yuyu ⸤kanu yemondo nirimu mele naa pilimelenje.⸥ Depisini ⸤ye nomi Kirasimu molomba mele⸥ konana te konopuni pilipelie bokuna torumu mele i sipe: “Aili ⸤Pulu Ye Yawene⸥ nanga Ailimundu nimbendo: “‘Nunge opa touma nuni nokani.’ nimbu, pe ene topo manie mundunjimbu kene isili ou nu ⸤na kinie pea tapu topolo ye nomitolo molopolo melema nokambili⸥ nanga ki umbukundu ongo molani.” nirimu.”* nimbe Depisini nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Depisini ⸤ye nomi Kirasimu⸥ yundu “Nu nanga Ailimu.” nirimu. Pe enene “Yu Depisini kalopa limbe yemo ⸤mindi⸥ molomba.” nambe teko pilkulie nilimeleye?” nimbe Yesusini nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesusi molorumuna yambo aisili liku maku toko moloringime pilku molangi Yesusini yu lombili andolimendo ⸤lepi lepi topa⸥ ungu te nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Enene Pulu Yemonga ungu manemanga puluma pilku mane sili yema* mimi siku kanoko konjiku ⸤enene telemele mele manda lelko naa teko⸥ molayo. ⸤‘Yambomane olio kanoko “Ye peangama” niengi.’ ningu⸥ wale pakoli paa sulu peangama, ⸤ye nomime pakolemele mele,⸥ pakoko andolemele. Yamboma maku toko molemele koleamanga andongendo mongo kenge teko ‘We yambomane olio kapi niengi.’ ningu pilkulie konopu siku pilku andoko molemelela.** Yamboma maku toko Pulu Yemonga ungumu pilimele ulkena sukundu pukulie manie molongendo ye ailime molemele polo peanga akuna ‘molamili.’ ningu mendo puku polo akuna konopu siku molemelela. Yambomane langi nongo yambomando “Namili wai.” nilimele kinie kanu yema ongolie ye ailimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Yema kolemele kinie enene kanu yemanga ambo wayema toko makoroko mundukulie ulkema ‘Olionga’ ningu we limele. Pulu Yemo kinie ungu ningindu ningu sulu munduku kolo toko nilimele.* Pulu Yemone we yamboma ulu pulu keri telemelemonga ene sike mongo lipe simbe nakolo ya ye nikirumane aku uluma telemelemonga Pulu Yemone aku yema mongo aili tepa lipe simbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesusi ⸤Pulu Yemo popo toko kaloringi ulke tembele kerepuluna molopa⸥ ulke tembelena sukundu kongono tenge kou mone munduringi unju ketena nondopa molorumu. Akuna molopalie yu olando sipe kanopalie ye kamakomane kanu ketena kou mone ongo munduringi kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","⸤Aku sipe kanopa molorumu kinie⸥ ambo waye paa koropa te omba yu kou kololi talo mindi mundurumu kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","nimbendo: “Nane enendo paa sike nimbu sikirumu: Andi ambo waye koropamo yuni kou mone mundukumumu paa olandopa mele mundukumu, we mundukumilime maniendopa mele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ene kou mone aisili nosilimelemanga wallotolo mindi ongo mundukumili. Nakolo ambo wayemo kou mone te paa naa nosilimo. Yunge layetolo nosimutolo pali memba omba mundumu. Langi nombá te kepe naa nosilimo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kanu kinie Yesusi kinie yu lombili andoli yema kinie ene ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembele kolea akuna molkolie ulke tembelemo paa peanga angilirimu mele kinie* ulke tembelemo takoringi kou paa peanga lupe lupema kinie aku kouna au siringi mele kinie kanoko, marene ungu anju yando ningu moloringi kinie Yesusini enendo nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ya ⸤ulke tembele peanga angilimo⸥ kanokomele melema ⸤pe walse ya kolea aili Jerusalleme yamboma mindili nonge walemo wendo ombá kinie⸥ i ulke tembelemo tekisikulie kouma pali toko manie mundungí.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesusini aku nirimu pilkulie enene yundu walsiku pilkulie ningindu: “Ungu Mane Silimu, nuni nikinu mele tewale wendo ombáye? Pe nuni i nikinu uluma nondopa wendo ombándo ou nambolka uluri temba kinie olione kanopolie ‘Sike i wendo ombá tepamo.’ nimbu pilimulúye?” ningu walsiringi kinie* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","yuni enendo nimbendo: “⸤Aku uluma wendo ombámonga ungu mare⸥ yambomane ene kolo toko singí kene kanoko konjiku molangi. Ye aisili nanga imbi lelko* ongolie yu mele mele kolo toko ningindu: “⸤Pulu Yemone ‘Nanga yamboma nokopili lipu mundumbu.’ ou nimbe mako torumu ye nomi Kirasi⸥ akumu na.” ningulie, “⸤Ma pora nimbé⸥ wale nirimumu wendo ombá tekemo.” ningíla. Ene lombili naa pangi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kolea marenga opa aili teko tenge mele pilku, yambomane enenga ye nomime tonge pilkulie mini wale naa mundengi. Opa tengema kinie aku uluma Pulu Yemone ‘Ou wendo opili. Laye pe mele ya ma koleamo pora nimbé.’ nimbe, nimbe panjirimumunge aku uluma sike wendo ombá nakolo aku kinie mulu matolo ou naa pora nimbé.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kanu kinie Yesusini yu lombili andolimendo kelepa nimbendo: “⸤Mulu ma pora nimbé walemo ou wendo naa opili⸥ yambo talape aili te kinie talape aili te kinie opa tekolo, ye nomi kingi marenga talapema kinie marenga talapema kinie opa tenge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ya mana kolea tenga tenga ma jimi jimi aili tepa tepa, engele lepa, kuru aili tepa topa, aku sipe temba. Yamboma pipili aili tepa tepa konjili ulu tondoloma muluna wendo ombá kanongela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Aku sipe mele ⸤pe wendo ombá nakolo⸥ ou naa wendo opili ene nanga yamboma molongemonga* ene ⸤mare⸥ liku ambolko, teko kenjingí. Ene ⸤mare⸥ Juda yamboma maku toko Pulu Yemonga ungumu pilimele ulkemanga liku mengo puku ⸤akuna kote tenjiku⸥, ene ⸤mare⸥ ka ulkena mengo puku panjiku, ene ⸤mare ka siku⸥ ye nomi kingime kinie gapomano ye ailime kinie molongena ⸤kote tenjingindu⸥ mengo pungíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","⸤Ka siku kote tenjingí kinie kotena angilkulie kanu yema kinie kanu yema nokonge ye nomime kinie⸥ enene ‘Nanga ungumu piliengi!’ ningu, ene ningu singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Ene ka siku kote tenjingí kinie ‘Enenga kere kinie konopu kinie tondolo pupili.’ nimbú kinie enene ningí unguma ene teko kenjingí tenge yambomane enene ungu ningí mele ungu ningu pundu tongendo perenge. Akumunge ene ou ongo ka naa siengi ‘Kotena nambolka unguri nimulúnje? Olio ungu te walsiku pilingí kinie nambolka unguri pundu topo nimulúnje?’ ningu mini wale naa mundengi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Enenga kandi aminieli lanieli kinie angenali kinie, pulu lemba yamboma kinie, enene kepe liku ka siku kote tenjikulie ene mare toko konjingíla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nanga yamboma molongemonga yambomane pali ene kinie konopu keri panjingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nakolo enenga kangine uluri naa tepa penge indi kepe telu omba manie naa pumbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","⸤Nanga yamboma molongemonga enene ene aku siku teko kenjingí kinie⸥ na munduku naa kelko tondolo munduku molonge yamboma mini pali konde molko konjiku mindi puli ulu pulumu lingí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pe walse, ami yema i kolea aili Jerusalleme yamboma tongendo ongo liku makaye teko molonge kanokolie i kolea Jerusalleme yamboma toko mundungí walemo nondopa wendo ombá mele pilingí.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","⸤Aku siku mele wendo ombá kanokolie ‘Umbuni ailime wendo ombá tekemo.’ ningu pilku⸥ kolea Judia disiriki lerimu koleamanga molonge yamboma ⸤enenga koleama munduku kelko⸥ ma pangi lembamanga kowa puku, Jerusalleme suku molonge yamboma wendo ongo kowa puku, Jerusalleme ulsu molonge yamboma altoko suku naa pangi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aku walemanga Jerusalleme yambomane ou taki taki Pulu Yemo teko kenjiringimunge yuni ene mongo simbe. Koronga ou yuni ‘Walse aku sipu tembo.’ nimbe, nimbe panjirimu kanu ungumu yunge ye marene yunge bokuna toringi molemo kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“⸤Pulu Yemone⸥ Jerusalleme yamboma mumindili kolopalie ‘Ami yema ene kinie mumindili kolko ongo tangi.’ nimbé kinie ulu umbuni teli aisili ene molongena wendo ombá. “Aku sipe wendo ombá kinie ambo ambolango monjingíme kinie, ambo ambolango ame singíme kinie, ⸤ene manda lkisiku kowa naa pungímunge⸥* ene kinie paa umbuni wendo ombámonga ene kondo tekemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jerusalleme yamboma tonge walemanga yambo toli lou pulsemane yambo mare toko konjingí, mare ka siku kolea sulu lupe lupemanga mengo pungí. Juda yambomanga talapena ulsu mololi yamboma* ya Juda yambomanga kolea aili Jerusalleme suku ongo toko munduku kolea liku kolo wangoko molonge. Kanu kinie pe Pulu Yemone ‘Enenga walema pora nipili.’ nimbé kinie Juda yamboma Jerusalleme kelko ongo molonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“⸤Aku mindili nonge nikiru uluma wendo ombá kinie⸥ ena kinie óli kinie kombukandipime kinie ⸤pali⸥ uluma temba yambomane kanokolie pilingí. Ma koleana nomu kusane ungu paa aili tepa nimbe, paa aili tepa topa piki maka lepa no tomba kanongela. Uluma aku sipe wendo ombá kinie yambo talapema mini wale mundungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Muluna angilimo mele tondoloma lope lope tepa anju yando pumbe kinie yamboma pipili paa aili teko kolko ‘Ma koleana nambolka uluri wendo ombá tekemonje?’ ningu pilku konopu paa aisili liku mundungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aku uluma wendo ombá kinie Manie Omba Mana Ye Au Lerimu Yemo tondolo pulimu kinie, tondolo pa aili tepa telimu kinie, kupe tenga suku molopa, kamu manie ombá* yambomane kanonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Aku uluma pulu monjipe temba kinie Pulu Yemone ene ulu pulu kerimene ka sipe nokolemomonga mindili siku molemele koleana wendo lipe,* yu kinie kamu tapu toko kapola molonge kolea peangana sukundu limbe walemo nondopa wendo ombá kene aku uluma wendo ombá kinie ene ola angilku olando siku kanangi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","⸤Yesusini aku sipe nimbelie nirimumuni, yu ombá walemo ‘Piliengi!’ nimbe⸥ ungu iku te topalie nimbendo: “Unju piki kinie we unjuma pali kinie kuku topa gomo tolemo kinie kanokolie ‘Kinié ena temba walemo wendo ombá tekemo lemo.’ ningu pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aku sipela i ulumu “Wendo ombá.” nikiruma sike wendo ombá kinie kanokolie ningímuni, “Pulu Yemo ye nomi kingimu molomba walemo* nondopa wendo ombá tekemo.” ningu pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nane enendo paa sike nimbu sikirumu: Kinié molemele yamboma ou naa kolangi ⸤i “Wendo ombá.” nikiru⸥ uluma pali wendo ombá. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mulumu kinie mamo kinie pora nimbé nakolo nanga ungu nilioma paa pora naa nimbé. ⸤Nilio mele pali paa sike wendo ombá.⸥”* ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Akumunge naa kanoko molangi kanu walemo ombá paa piliei! Lopa te yunge tapu andolemona ‘Pumbu.’ nimbe olemo kinie melu lelko panjilimelemo naa kanopa ‘Yu tomba.’ konopu naa lepa walu olemo kinie pe meluna walsikale tolemo, aku siku ene no tondolo nongo kekelepa toko we umbuni tepili molko konopu naa makilipili molongi liemo ⸤Manie Omba Mana Ye Au Lerimu Yemo⸥ yu ombá kanu walemo ene naa kanangi lipe sinjipe wendo ombá kene kanoko konjiku pilku molayo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aku walemo ma koleana pali yamboma molongena wendo ombá kene ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","enene Pulu Yemo kinie mawa tekolie ningindu: “‘Na pe Manie Omba Mana Ye Au Lerimu Yemonga kumbikerena pupu ola angiliembo kene na enge nipili, i ulu wendo ombámane na topa manie naa mundupili.’ ni.” ningu alieli kanoko konjiku pilku molai!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesusini enamanga taki taki ulke tembelena yamboma ungu mane si pu opu tepa, ipulueli taki taki Jerusalleme ulsukundunge pupe ma pangi Unju Ollipi Poniena ola pupe pe pu opu terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yamboma pali paa ipulueli ou ‘Yu ungu mane simbema piliemili.’ ningu ulke tembelena ongo maku to pu opu teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","⸤Juda yambomane ponie tenga tenga kolea aili Jerusalleme ongo akuna suku⸥ Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele* piliringi walema, akumu imbi lelko ‘Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Walemo’* niringila, aku walemo nondopa wendo orumu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* enene Yesusi toko konjingí aulke te koroko moloringi nakolo enene ⸤“Olio yambomane kanangi yu ka simulú kinie yambomane olio kinie mumindili kolko iri tonge.” ningu⸥ pipili kolko we moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanu kinie Yesusi yu lombili andoli ye rurepo akumanga ye Judasi, yunge imbi te ‘Isikeriote’ nili, kanumunge konopuna ⸤kurumanga nomi⸥ Setene* omba sukundu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","⸤Setene yunge konopuna suku purumu⸥ kinie yu Pulu Yemo popo tonjiringi ye ailime kinie, ulke tembele nokoli ele yemanga ele ye ailime kinie, ene moloringine pupelie, ene Yesusi ka singí aulkemo yuni akisinjimbe mele ene kinie kerepali niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yuni temba mele nirimu kinie pilkulie ene konopu aili teko siku “Nu kou mone te simulú.” ningu, ningu panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuni enenga unguma pilipelie “Kapola.” nimbe, we yamboma Yesusi pea naa molonge kinie yu ene lipe simbe mele aulkemo koropa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Walemo wendo orumu kinie Juda yambomane Pulu Yemone ou enenga anda kolepalime Naa Topa We Omba Purumu mele pilingindu kongi sipisipi walo te toko nonge mele pilipelie nirimumuni,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesusini Pita kinie Jonotolo lipe mundupelie nimbendo: “Elte pukulu, Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walo te kinié nomolomo teko mimi tepale.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eltene walsikululie ningilindu: “Tena tepo mimi tepambili konopu lelko nikinuye?” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yuni eltendo pundu topa nimbendo: “Piliele. Ne ulke kolea aili ⸤Jerusallemendo⸥ pukululie, ye te mingine no kolopa memba ombá aulkena puku kane kane tokololie,* yu pumbe mele lombili pukulu yu suku pumbe ulkena suku pukululie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ulke pulu yemondo ningilindu: “Ungu Mane Silimuni i sipe walsipelie nimbendo: “Na kinie na lombili andoli yema kinie olione Pulu Yemone olionga anda kolepalime Naa Topa We Omba Purumu mele pilimulundu kongi sipisipi walomo tena nomoloye? Nomolo suluminiamo tena lemoye?” nimu.” niengili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aku ningilí kinie yuni elte ulkemonga olakondo suluminia aili te, akuna langi noli polo te kinie, manie molomolo poloma kinie, melema kinie akuna ou lemoma, lipe ora simbe. Aku suluminiamonga ⸤nomolo sipisipi walomo⸥ teko mimi teangili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kanu kinie elte pukululie, Yesusini nirimu kanu mele aku uluma teli lerimu kanoko lenjikululie, akuna Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele pilingí kongi sipisipi walo nongemo kinie langi nongema teko mimi teko nosiringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Juda yambomane ipupini kolea kalá torumu kinie Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu Walemo pilingindu kongi sipisipi walomo nonge enamo* kamu wendo orumu kinie, Yesusi kinie yunge kongonomo ‘tenjipai.’ nimbe lipe mundurumu yema kinie** ene langi noli polona moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Langi nongo moloringi kinie yuni enendo nimbendo: “‘Na mindili ou naa nombolie i wale wendo okomomonga langime ene kinie pea namili.’ paa tondolo mundupu konopu lepo andopo molorundu mele yandopa paa konopu lepo pilipu molio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nane enendo i sipu nimbu sikirumu: Isili ou i langime na altopo naa nombó. Pulu Yemo ye nomi kingimu kamu molomba walemo* wendo ombalie i langimenga sike ulu pulumu wendo ombá kinie altopo nombó.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Yu no waene kapomo lipe ambolopalie Pulu Yemondo “Ange.” nimbelie nimbendo: “Imu ene eneno moke teko nayo. Nane enendo i sipu nimbu sikirumu: Isili ou na no waene altopo paa naa nombó. Pe mindi, Pulu Yemo ye nomi kingimu molopa nokolemo walemo wendo ombá kinie na no waene kondemo kelepo nombó kene ⸤ene eneno isili ou nangi⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Berete te lipe Pulu Yemo kinie “Ange.” nimbelie ambolopa pike lepa ⸤yu lombili andolime⸥ sipelie nimbendo: “Imu nanga kangimu ⸤ene liku nangi⸥. ‘Nanga kangimu ‘enenga’ nimbu ⸤lipu taponjembo.’ nimbu tangi⸥ simbu tekero imu. Pe pe kepe, ‘Ene lipu taponjembo.’ nimbu nanga kangimu enenga nimbu ‘Na tangi.’ nimbu simbu tekero mele ‘Altopo piliemili.’ ningu i beretemo “Nanga kangimu.” nimbu sikiru mele ene aku siku berete te nongolie piliengi!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pe ene langime nongo pora siringi kinie yuni ⸤berete te kinie terimu mele⸥ aku sipela no waene kapomo lipe ⸤ene sipelie⸥ nimbendo: “I ⸤no waene⸥ kapo ⸤ene sikirumu⸥ nanga mememo. ⸤Pulu Yemone ‘Ene kinie tembo.’ nimbe,⸥ ungu te nimbe panjipe mi lerimu kanu ungumu* ‘Kamu wendo omba pepili.’ nimbu nane enenga nimbu nanga mememo ondo lenjipulie ⸤kolombo⸥ aku mememo i no waenemo.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nakolo na lipe nanga opa touma simbe yemo na kinie pea i langi nokomolo polona molemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","“Kinié Manie Omba Mana Ye Au Lerimu Yemo kinie tenge mele Pulu Yemone koronga ou nimbe panjirimu mele sike opa toumane tenge, nakolo yu lipe opa touma simbe yemo mindili nomba molopa kenjimbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aku nirimu kinie pilkulie ⸤yu lombili andolimene⸥ anju yando walsikulie ningindu: “Olionga ye naene ulu akumu tembanje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aku walemo kinie ungu te pea wendo orumula. ⸤Yesusi lombili andolimene⸥ ene eneno anju yando ungu mele tekolie ningindu: “Olionga ye nae paa olandopa molemoye?” ningu keru kuru liku moloringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesusini enendo nimbendo: “Olio Juda yambomanga ulsu molemele yambo talapemanga ye nomime enenga yamboma tondolo munduku nokoko kongono enge nilime alieli silimele. Ye imbi ola molemo yema enenga yamboma ‘Mindili nangi.’ ningu nokolemele yemane ene eneno imbi ambolko ola liku, “Olio yamboma nokopo konjipu lipu taponjili yema.” nilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nakolo ⸤we yambomanga ye nomimene enenga yamboma tondolo munduku nokolemele mele na lombili andoli yema⸥ ene eneno aku siku anju yando naa teangi. Enenga ye te imbi ola molomba kinie aku yemo ye koropa mele molopili. Ye nomi molopa we yema nokomba yemo ye kendemandemo mele molopa we yemanga kongono tenjipili.” ⸤nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ye nae paa ye olandopamoye? Langi nolemo yemo ye olandopamo molo langi peko topa kalopa pellete kulumiye topa aku kongonoma tenjilimo yemo ye olandopamoye? Langi nolemo ye akumu ye nomimu lemo. Aku sipe, nakolo na aku sipe molo. Na ⸤sike enenga ye ailimu⸥ nakolo enenga kongono tenjili kendemande mele molopo ene lipu taponjili yemo molio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","⸤Yesusini yu lombili andoli engaki rurepondo kelepa nimbendo:⸥ “Na mindili sipu molorundu molio mele ene na kinie pea tapu topo mindili sipu molorumulu molemolola. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nanga Lapa ye nomi kingimu omba molopa yamboma nokomba kinie nando ‘Akuna yamboma nokonjipilila.’ nilimo nimbé mele nane enendo ‘Akuna yamboma nokonjengi.’ nilio nimbula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Akuna na ye nomi kingi molopo yamboma nokombo kinie ene na kinie pea langi polona molopo ga nombo molomolo. Ene ye nomi kingi polomanga molkolie ningímuni, Isirele yambo talape rurepo* nokonge.” ⸤nirimu.⸥** ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","⸤Nimbelie, Yesusini lombili andoli ye Pitando nimbendo:⸥ “Saimono, pílie! ⸤Kurumanga nomi⸥ Setenene* Pulu Yemondo mawa tepalie nimbendo: “Ene teko kenjingínje manda manjipu kondi topo kanambo.” nirimu kinie Pulu Yemone “Manda.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nakolo Saimono, nane Pulu Yemo kinie ungu nimbu nunge mawa tenjipulie nimbundu: “Setene yuni nu aku temba kinie Pita yuni na naa mundupe kelepa na pilipe molopili.” nindu. Saimono, Setene laye kolte pilku na munduku kelkolie, pe konopu alowa teko na kelko tondolo munduku pilku molkolie ninimuni, angenalime tondolo mundunji.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nakolo Pitane nimbendo: “Ailimu,* nane nu pe siye kolopo talopa lepo pumbu ningu nikinuye? Manda molo. Olto pea “Ka siemili.” níngi liemo papula. Molo olto pea “Topo konjemili.” níngi liemo uluri molo. Pea kolambili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusini Pitando nimbendo: “Pita, nane nundu i sipu nimbu sikirumu: Kinié kera gulta ou ko naa topili nuni pipili kolkolie wale yepoko nando kolo toko “Yu naeye? Na naa kanolio.” nini.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nimbelie Yesusini yu ye ⸤rurepondo⸥ pali kelepa nimbendo: “Nane ene ou ⸤‘Kongono tepangi.’ nimbu⸥ lipu mundurundu kinie ‘Kou naa mengo, mele wale naa mengo, kimbu su naa mengo, we pangi.’ nimbu lipu mundurundu kinie ene melte molo torumu molo moloye?” nimbe walsipe pilirimu kinie enene “Mele telu kepe molo naa torumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yuni enendo kelepa nimbendo: “Nakolo kinié na kinie uluri wendo ombámonga, kou mone nosilimo yemo kanu kou monemo lipe ambolopa, mele wale nosilimo yemo kanu walemo lipe ambolopa, aku siku teko molangi. Opa teli lou pulse naa nosilimo yemo yunge wale pakoli te anju sipe lou pulse te yando lipili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","⸤Nane aku sipu nambemuna nikiru, niembo.⸥ Ou yambomane nando ningu Pulu Yemonga bokuna toringi molemo mele kinié wendo ombá tekemo mele i sipe: “Yu kinie, yambo mongo liku ulu pulu kerime teli yamboma kinie, liku tere lelko mako toringi.”* niringi bokuna molemo kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yuni aku nirimu mele pilku sundukulie enene yundu ningindu: “Ailimu, ya opa teli lou pulse talo nosilimolo kanoi.” niringi kinie yuni enendo nimbendo: “Ungu manda nimbu, ⸤pamolo.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kanu kinie Yesusi ⸤ulke mundupe kelepa kolea aili Jerusalleme⸥ ulsukundu pupelie nirimumuni, yu taki taki ma pangi Unju Ollipi Poniena ola pu pu opu terimu mele akuna purumu. Yu lombili andolime yu lombili akilku pea puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akuna purumu kinie yuni yu lombili andolimendo nimbendo: “⸤Kurumanga nomi⸥ Setenene ‘Olio kondi tomba kinie tepo kenjimulú kene’ ningulie Pulu Yemo kinie ungu ningu mawa teko molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nimbelie yu yuyu laye kolte anju pupe koporongo langopa, Pulu Yemo kinie ungu nimbe mawa tepalie nimbendo:* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tara, na mindili noli no mingine no nombómo ‘Naa nambo.’ konopu lenu liemo aku siku teani nakolo ‘Nane tepolie nanu konopu simbu.’ konopu lekero mele naa teambo. Nuni kanoko peanga kanoni ulumu mindi teambo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aku nirimu kinie angello tene mulu koleana mundupe kelepa Yesusi yu molorumuna omba ‘Yu tondolo pupili.’ nimbe terimu mele Yesusini yu kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kanu kinie yu konopuna umbuni aili tepa tepa, kamelena mindili tepili molopalie yu Pulu Yemo kinie tondolo mundupe ungu nimbe mawa terimuna yunge kangine kúru omba kanu kúrumu meme none tepa mana manie purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yu Pulu Yemo kinie aku sipe ungu nimbelie ola angilipe yu lombili andoli yema moloringine yando omba enene yu kondo kolko molkolie uru peringi kanopalie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","enendo nimbendo: “Ene uru nambemuna pekemeleye? ‘⸤Kurumanga nomi Setenene⸥ olio kondi tomba kinie tepo kenjimulú kene’ ningulie ola molko Pulu Yemo kinie ungu ningu mawa teko molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesusini aku nimbe molopili ene moloringine ye aisili oringi. Oringi yemanga te kumbi lepa orumu yemo yu ye Judasi, Yesusi lombili andoli rureponga ye te. Judasi yu Yesusi molorumuna nondopa omba yu kangulurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aku terimu kinie Yesusini yundu nimbendo: “Judasi, opa tou yemane Manie Omba Mana Ye Au Lerimu Yemo ‘kanoko imbi siku ka siengi.’ ningu nuni na kangulkunuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kanu kinie Yesusi pea tapu toko angiliringi yemane yu ulu temba terimu mele kanokolie enene yundu ningindu: “Ailimu, opa teli lou pulsemane i yema tamiliye?” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","enenga ye tene ⸤yunge lou pokete napimu lipe ambolopalie⸥* Pulu Yemo popo tonjiringi ye aili olandopamonga kendemande ye tenga komumu topa laká lerimu kinie komumu omba manie purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aku terimu kanopalie Yesusini yundu nimbendo: “Kinié manda, kelei!” nimbelie torumu yemonga komumu lipe ambolopa tambu sinjirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesusi ka singí oringi yema i sipe: Pulu Yemo popo tonjiringi ye aili mare kinie, tembele ulkemo nokoko moloringi ami yema nokoringi ye mare kinie, Juda yambomanga tapu ye mare kinie,* enene Yesusi ka singí oringi kinie kanopalie enendo nimbendo: “Na ‘yambo topo wa noli yere molemo.’ konopu lelkolie lou pulsema kinie kopema kinie mengo okomeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ulke tembele kerepuluna alieli ene pea molemolo kinie na ambolko liku ka naa silimele kanumu.* Nakolo kinié i ena wendo okomomo Pulu Yemone ou ‘Enenga.’ nirimu enamo wendo okomo. Sumbulu tolimunge tondolomo kinie olandopa pelemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kanu kinie enene Yesusi ka sikulie Pulu Yemo popo tonjiringi ye aili olandopamonga ulkena sukundu mengo puringi. Yesusi mengo puringi kinie Pita lombili akilipe taka lepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yesusi mengo oringi ulke kanumunge ulke angilipe makaye terimu, suku we lerimuna* tepe kalko pilku moloringine Pita pupe ene kinie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yu akuna molopili ⸤Pulu Yemo popo tonjiringi ye aili olandopamonga⸥* kendemande ambo te omba tepe nomba pa terimuna Pita molorumu kanopalie yu nemo nemo nimbe kanopalie nimbendo: “I yemo Yesusi pea moloringili kanorundu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nakolo Pitane kolo topalie nimbendo: “Ambomo, aku nikinu yemo na naa kanolio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Laye pe mele ye te Pita kanopalie yundu nimbendo: “Nu Yesusinge talape ye te lepamo.” nirimu kinie Pitane yundu nimbendo: “Yemo, na akumu molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pe ena mongo telu mele omba purumu kinie yambo te ⸤Pita yu ungu laye lupe mele nirimu mele pilkulie⸥ yuni tondolo mundupelie nimbendo: “Kolea Gallilli disiriki yambomane ungu nilimele mele yu aku sipe ungu nikimu pilkiru. ⸤Yesusi kinie yu lombili andoli yema kinie kolea Gallilli disiriki yemala,⸥ yu kepe Gallilli ye te, aku kene ‘Yu paa sike Yesusi lombili andoli ye te.’ konopu lekero.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aku nirimu kinie Pitane yundu nimbendo: “Yemo, nu nikinu mele na paa naa pilkiru.” nirimu. Aku sipe nimbe molopili kera gulta ko torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kanu kinie Yesusini topele topa Pita kanorumu kinie Yesusini yundu “Kera gulta ou ko naa topili nuni wale yepoko kolo tokolie “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pilipelie ⸤‘Ama, paa tepo kenjindu lepamo. ‘Paa naa tembo.’ konopu lerindu mele sike tendu.’ nimbe pilipelie⸥ pena pupe kola paa aili tepa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kanu kinie Yesusi akuna nokoko moloringi ele yemane yu ungu taka tonjiku, yu laruwe toko, teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yunge kumbikeremo múlu tene pipi sinjikulie ki lumuni toko ⸤“Nu ‘Pulu Yemonga yere molio.’ konopu leno kene⸥ naene nu tokomonje ningu si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ungu taka tonjingindu enene yu aku mele ulu aisili teko ungu aisili ningu yu aku siku teko kenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kolea tangorumu kinie Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie, kanu Juda yambomanga tapu ye kanjolloma pali ‘Yesusinge kote piliemili.’ niringi.* ⸤Enenga ele yemane⸥ yu ene liku maku toko moloringine mengo puringi kinie enene yundu ningindu: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Pulu Yemone olio “Nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu sike nu molo moloye? Ningu si.” niringi. Yuni enendo nimbendo: “ “Na akumu molio.” nilkenje enene naa pilku “Kolo tokono.” nilimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nane enendo ungu te walsipu pilkenje yando ungu te naa la nilimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nakolo Manie Omba Mana Ye Au Lerimu Yemo kinié kepe pe pe kepe tondolo pali pelemo Pulu Yemo ⸤kinie melema nokombando⸥ yunge ki umbukundu molomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Enene pali yundu ningindu: “Nu “Pulu Yemonga Malo molio.” ningu nikinuye?” niringi kinie yuni nimbendo: “Akumu na.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Enene ningindu: “Yuni mongo lirimu mele nimbe simbe yambo te pea nambemuna koromoloye? Yuni yuyu nimbe kenjikimu pilkimulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aku ningulie Juda yambomanga ye ailime pali ene ola angilku Yesusi liku mengo puku ⸤Romo gapomano ye nomi⸥ Paillate molorumuna mengo puku kote tenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yu kote tenjikulie Paillatendo ningindu: “I yemone nimbendo: “Romo gapomanomone olio Juda yamboma naa nokopili.” nimbe, “Romo Gapomano Ye Paa Aili Kumbine Sisamo kou takisi naa tangi.” nimbe,* “Yu yuyu “Pulu Yemone olio nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye Kirasimu, ye nomi kingimu molio.” nimbe molemomo olio pilipu kanolemolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ene aku siku niringi kinie pilipelie Paillatene ⸤Yesusinge kotemo⸥ yu walsipe pilipelie nimbendo: “Nu Juda yambomanga ye nomi kingimu molo moloye?” nirimu. Yesusini pundu topa nimbendo: “Sike nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yuni aku nirimu kinie pilipelie Paillatene Pulu Yemo popo tonjiringi ye ailime kinie, we yamboma akuna liku maku toringime kinie, enendo nimbendo: “I yemo ulu te naa tepa kenjimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nakolo enene karaye teko tondolo munduku ningindu: “Yuni ungu mane sipelie “We yamboma ulu teko kenjiku, mongo liku teangi.” nimbe mane sirimu. Yuni ou pulu pulu kolea Gallilli disiriki ungu akumu mane sipe, pe yandopa kolea Judia disiriki koleama pali silipe andopalie, pe kamu ya kolea aili Jerusalleme omba ungu akumu mane sipe molemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Kolea Gallilli” niringi kinie pilipelie Paillatene enendo walsipe pilipelie nimbendo: “I yemo yu Gallilli ye teye?” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","enene “E.” niringi pilipelie yuni nimbendo: “⸤Ye nomi kingi⸥ Erote, Gallilli disiriki nokoli yemo, Yesusinge kotemo yuni pilipili yu molemona mengo pai.” nirimu. Aku walemonga kanu ⸤ye nomi kingi⸥ Erote yu Jerusalleme omba molorumuna pilipelie, “Yu molemona mengo pai.” nirimu. ⸤Paillate yu Jerusalleme lerimu kolea Judia disiriki nokorumu yemo.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erote ⸤molorumuna mengo puringi kinie⸥ yu Yesusi kanopalie konopu sirimu. Yu Yesusini ulu terimu mele ungu aisili pilipelie, ‘Kanu yemo kanamboa!’ nimbe molopa, ‘Yuni ulu tondolo te tepili kanamboa!’ konopu lepa molorumuna* yu orumu kinie kanopa konopu sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Akumunge Erote Yesusi ungu aisili walsipe pilirimu nakolo Yesusini ungu te pundu topa naa nimbe we molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pulu Yemo popo tonjiringi ye ailime kinie, Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie,* akuna angilkulie enene Erotendo ningindu: “Yesusini i sipe ungu nimbe kenjipe, i sipe ulu aisili tepa kenjipe molemo.” ningu tondolo munduku niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kanu kinie Erote kinie yunge ami yema kinie enene ‘Yesusi yu ye nomi molo, yu we yere.’ ningu ye nomimene pakolemele mulu wambale peanga te liku pakonjiku, yu ungu taka tonjiku tae teringi. Kanu kinie Paillate molorumuna Erotene Yesusi lipe yando mundurumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Paillatene Erote molorumuna Yesusi ou naa lipe mundupili Paillate kinie Erote elte opa tou moloringili. Nakolo Yesusi aku teringili walemonga pe elte angenungulu mele moloringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesusi Paillate molorumuna yando mengo oringi kinie Paillatene Pulu Yemo popo tonjiringi ye ailime kinie, Juda yambomanga tapu yema kinie, we yamboma kinie, enendo “Wai.” nimbelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Enene “I yemone yambomando ‘Romo gapomanomo olio naa nokopili.’ nimbe ‘Ene mongo liku teangi.’ nimbe molemo.” ningu* na moliona mengo ongi. Kanu kinie ene kanoko molangi nane kote pilipulie enene ‘Yu tepa kenjirimu.’ níngi mele na ulu te naa pilkiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","⸤Gallilli disiriki ye nomi kingi⸥ Erote, yu pea i yemo ulu te tepa kenjirimu te naa la pilipelie yu altopa yando mundumu. Pilkimiliye? Yu ulu te tepa naa kenjimu. Yu we nambemuna topo konjimulúye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ulu te tepa naa kenjimumunge nane yu we kopene topolie “Kelko pui.” niembo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","(Kolea aili Jerusalleme sukundu ye te, yunge imbi Barapasi, ⸤yu kinie ye mare kinie⸥ ‘Romo gapomanomone olio Juda yamboma naa nokopili.’ ningu ou Romo gapomanomo kinie opa tekolie yambo mare toko konjiringimunge yu ka siringi. ⸤Romo gapomano ka ulkena kanu ye Barapasi we pepili Juda ye ailimene Yesusi kote tenjiringi⸥. Juda yambomane ponie tenga tenga kolea aili Jerusalleme ongo akuna suku Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele piliringi walemo* wendo orumu kinie Romo gapomano ye ailimuni ka ye te ka ulkena wendo lipe mundupe “Pui.” nirimu.)** ⸤Aku sipe terimu mele piliringimunge Paillatene “Yesusindu “Pui.” niembo.” nirimu kinie pilkulie⸥ enene pali yundu tondolo mundukulie ningindu: “I yemo molo. Yu ⸤kolopili⸥ mengo pukulie, Barapasi, ⸤ka ulkena⸥ wendo liku si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paillatene ‘Yesusi we pupili.’ nimbelie enendo ungu te pea nirimu ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","nakolo enene yundu wale aisili tondolo munduku ningindu: “Yu kolopili unju perana uku toko panji!” ningu moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aku niringi kinie yuni enendo altopa wale yepoko sipe walsipelie nimbendo: “Aku nambemunaye? Yu mongo nambolka mongore limuye? Yu ulu te tepa naa kenjimu. Yu we nambemuna topo konjimulúye? Nane yu we kopene topolie “Kelko pui.” niembo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nakolo enene karaye teko ungu tondolo mundukulie ningindu: “Yu kolopili unju perana uku toko panji!” niringi kinie enene tondolo munduku niringi mele pilipelie Paillatene ene niringi mele temba terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanu kinie Paillatene kote pilipelie enene yu kinie “Paa tei.” ningu karaye teko mawa teringi mele ‘Aku sipe tepili.’ nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","⸤ye Barapasi,⸥ ‘Romo gapomanomone olio Juda yamboma naa nokopili.’ nimbe ou Romo gapomanomo kinie opa tepalie yambo mare topa konjirimumunge ka ulkena perimu kanu yemo, wendo lipe ene sipelie nirimumuni, pe enene ‘Yesusi kolopili.’ niringi mele pilipelie “Yu toko konjengi.” nimbe ami yema sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","⸤Romo ami yemane⸥ Yesusi mengo pungí pukulie niringimuni, kolea Sairini* ye te, yunge imbi Saimono, yu Jerusalleme pumbe orumu kinie kanoko yu ambolko liku ka mele siku Yesusi kolomba unju peramo liku pendekona ola nosinjikulie “Imu menjiku yu lombili aki liku pui.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yambo aisili yu lombili puringi. Ambo mare yu tongemonga kola teliku puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kanu kinie Yesusini topele topa kanu ambomando nimbendo: “Jerusalleme amboma, ene na kolombomonga pilkulie kola naa teangi. Ene eneno kinie enenga ambolangoma kinie ulu pe wendo ombámonga pilkulie kola teangi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aku sipu nikirumu, nambemuna nikiruye? Niembo: Walse ene Jerusalleme yamboma mongo simbe walemo wendo ombá kinie ene kinie enenga ambolangoma kinie mindili nonge kinie yambomane ningindu: “Ambo ambolango te naa mengo, ambolango ame naa siku, wayongono molemele amboma, enenga ambolango te mindili nomba ene naa kanongemonga ene malo.” ningí.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pe ‘yamboma kelko mulu aili polemomando “Ma ange topa olio topili.” ningu, ma pangimendo “Ma ange topa olio aki topili.” ningí.’”* nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","⸤Nimbelie pe kamu ungu iku te topa enendo nimbendo:⸥ “Unju konde angilimomo peko tokomele. Pe unju kololimu nambe tengeye?* Akumunge ⸤enene ene aku siku umbuni singí, mindili nonge⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye talo pea ‘Yesusi kinie kolangi.’ ningu unjuna ola uku toko panjingindu mengo puringi. Aku yetolo mongo liringili yetolo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kolea ‘Penge Ombele’ niline oringi kinie yu kinie mongo liringili yetolo kinie unju pera yepokonga ola uku toko panjiringi. Mongo liringili yetolonga te Yesusi yunge ki umbukundu uku toko, te Yesusi yunge ki tarokondo uku toko panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aku teringi kinie Yesusini nimbendo: “Tara, na kinie tekemele mele tekemele yambomane naa pilkimili kene nuni tekemelemonga mongo naa siku siye koloi.” nirimu. ⸤Aku tekolie, ou unjuna ola uku toko naa panjikulie⸥ yunge mulu wambale ⸤kulunjiku nosiringime⸥ ‘Moke teamili.’ ningu ene yu mele mele lingí mele pilingindu kou kate teko pe mulu wambalema liringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","We yamboma enene yu teringi mele kanoko we angiliringi nakolo enenga ye ailimene yundu ungu taka tonjiku ningindu: “Yu yambo wema ‘Naa kolko konde pangi.’ nimbe lipe taponjirimu mele kinié yuni ‘Naa kolopo unju perana wendo pambo.’ nimbe yu yuyu lipe taponjipe unju perana wendo opili. Yu sike Pulu Yemone mako topa olio ‘Nokopa konjipili.’ nimbe lipe mundurumu ye nomi Kirasimu omba molomu liemo kinié yu yuyu aku sipe lipe taponjipili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ami yema pea yu ungu taka tonjiku molkolie no waene kombili teli te ‘Nopili siemili.’ ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yundu ningindu: “Nu Juda yambomanga ye nomi kingi molonu liemo ‘Naa kolambo.’ ningu nu nunu liku taponji.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","‘Yu mongo lirimu mele yamboma kanangi.’ ningu I YEMO JUDA YAMBOMANGA YE NOMI KINGIMU ningu imbi toko unjuna ola monjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mongo liringili yetolo unju perana ola uku toko panjiringi yetolonga tene Yesusindu ungu taka tonjipelie nimbendo: “Nuni “Pulu Yemone mako topa olio ‘Nokopa konjipili.’ nimbe lipe mundurumu ye nomi Kirasimu ⸤molio.” nilino mele sike molo moloye? Sike aku siku⸥ moleno liemo nu kinie olto kinie pea ‘Naa kolamili.’ ningu liku taponjiku unju perana wendo li.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nakolo mongo liringili yetolonga tene yuni nirimu mele pilipelie yu iri topalie nimbendo: “Nu kinie yu kinie mongo telu siku mele síngimunge Pulu Yemo pipili naa kolkonoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu kinie olto tepo kenjirimbulumunge mongo papu síngi. Nakolo i yemo yu mongo te naa lirimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aku nimbelie yuni ⸤Yesusindu⸥ nimbendo: “Yesusi, nu ye nomi kingimu molko melema nokokolie ninimuni, na konopu liku mundu.” nirimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesusini pundu topa yundu nimbendo: “Nane nundu paa sike nimbu sikirumu: Kinié nu na kinie pea Yamboma Molko Konjilimele Kolea Peangana* pupu molombolo lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yesusi unju perana ola we pepili ai tangoli ena tuwellepo killoko terimu kinie kolea pali sumbulu topalie pe ipupini ena tere killoko kinie ena kelepa topa kolea tangorumu. ⸤Ulu aili te walsikale wendo orumula. Pulu Yemo popo toko kaloringi⸥ ulke tembele ⸤Jerusalleme suku angilirimu akuna sukundu Pulu Yemo molorumu⸥ suluminia paa kake telimunge kerepuluna ⸤‘Yamboma sukundu naa pangi.’ ningu ou alieli⸥ mulu wambale aili tene pipi siku panjiringi angilirimu. Kanu mulu wambalemo ai suku singine olá torumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesusini ungu te tondolo mundupe nimbendo: “Tara, nanga minimu ‘Nu molenona opili.’ nimbu nu sikiru.” nirimu. Aku nimbelie yu kolorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","⸤Romo⸥ ami ye wane anderete nokorumu ye te Yesusi toringi ami yema nokopa molorumu kanu yemone Yesusi ungu te nimbe kolorumu mele pilipe kanopalie yuni Pulu Yemo kapi nimbelie nimbendo: “I yemo yu paa sike ye konopu sumbi nili te lepamo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kanu kinie ‘Yu unju perana uku toko panjingí kanomolo.’ ningu ou liku maku toringi yamboma yu terimu mele kanoko bulu balu ningu ungu aisili konopu liku munduku kondo kololiku ulkendo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yu kinie ou tapu toko andoringi yema kinie, kolea Gallilli disiriki munduku kelko yu lombili andoko ⸤Jerusalleme⸥ pea oringi amboma kinie* enene ⸤yu toringi kolorumu mele⸥ sulu teko kanoko angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yesusi kolorumu kinie ye te, yunge imbi Josepo, yu Juda yambomanga kanjollo ye aili te molopa, ulu peangama manjipe tepa molorumu. Yu konopu sumbi nili ye te, kolea Judia disiriki Arimatia taono yemo. Yu ‘Pulu Yemo ye nomi kingimu molopa olio nokomba walemo* wendo opili.’ nimbe nokopa molorumu yemo. Yu Juda yambomanga kanjollomo sike molorumu, nakolo kanjollo yemane ⸤ou ene eneno kote pilkulie⸥ “Yesusi kolopili.” niringi kinie** yuni “E.” naa nimbe we molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kanu yemone ⸤Romo gapomano ye nomi⸥ Paillate molorumuna pupelie “Yesusinge onomo na si.” nimbe mawa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paillatene “Kapola.” nirimu kinie Josepo pupe onomo manie lipe, mulu konde tene lipe kulupi topalie, kou kande tenga memba pupe suku nosirimu. Aku kou kandena yambo ono te ou naa nosiringi, yu mindi pulu pulu nosirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yesusi ono terimu walemo yu kinié mele, opali mele ⸤Juda yambomanga koro moloringi⸥ wale Sambatemo* nondopa wendo ombá terimu. Sambate walemo wendo ombá kinie koro molongendo kinié mele melema liku undu undu siringi walemo wendo orumu, aku walemonga Yesusi ono teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ou Yesusi kinie kolea Gallilli disiriki munduku kelko yu pea ⸤Jerusalleme⸥ oringi amboma Josepone Yesusi ono terimu kou kandemo kanoko akuna suku onomo nosirimu mele nemo nemo ningu kanokolie niringimuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","pe kanoko pora sikulie yando ongo, ‘Yunge onona kopongo welema kinie mele lupe mune tolime kinie kanjinjemili.’ ningu teko mimi teringi. Nakolo Sambate walemo wendo orumu kinie Pulu Yemonga ungu manemone ‘Sambate wale kinie koro molangi.’* nirimu mele pilku likulie mele teko mimi teringi melema sumbi siku ono koleana naa mengo pukulie we nosiku koro moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","⸤Juda yambomanga koro moloringi⸥ wale Sambatemo* pora nimbe, enenga pulu pulu kongono walemo wendo ombando kolea tangomba muni lerimu kinie amboma kopongo mune toli ou teko nosiringime liku mengo puku, ⸤Yesusinge⸥ onomo nosiringi kou kandena mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Akuna pukulie kou kande kerepulumu pipi siringi koumu perele marele pupe wilkindu lerimu kanokolie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","suku puringi kinie akuna Ye Aili Yesusinge onomo ou lerimuna naa lerimu kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanu kinie ‘Onomo nambe temunje?’ ningu konopu liku munduku moloringi kinie ye talo kariapá tepalie pa telemo mele teli wale pakoli pakoringili yetolo ene moloringine angiliringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kanokolie amboma mini wale munduku tamalu peringi kinie yetolone enendo ningilindu: “Konde molemomo, ya ono koleana nambemuna korokomeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yu ya naa lemo. Lomboropa ola molopa wendo pumu.” ⸤niringili.⸥ “Yu ⸤ene kinie⸥ kolea Gallilli molopa enendo nirimu mele pilieyo. Yuni nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“⸤Juda yambomanga ye ailimene⸥ Manie Omba Mana Ye Au Lerimu Yemo liku talape lupe yambo ulu pulu keri telime yu liku singí, enene yu unju perana kolopili uku toko panjingí kinie kolopalie wale yepoko sipemonga lomboropa ola molomba.” nirimu kanumu.” niringili.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kanu kinie Yesusini ou aku nirimu mele ambomane altoko piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kou kandemo munduku kelko, kelko yando ongolie niringimuni, lombili andoli rureponga yepoko kinie akuma pea moloringi yamboma kinie enendo pilku kanoringi mele temane toko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kolea Makatalla ambo Maria keme, ambo Joana keme, Jemisi anumu Maria keme, ene pea puringi amboma keme, kanu ambomane Yesusini ou “Nanga kongonomo tenjipai.” nimbe lipe mundurumu ye rureponga yepoko* aku temanemo toko siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nakolo ambomane niringi ungumu pilkulie ‘Ene kolo tokomele.’ ningu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aku ningu piliringi nakolo Pita ola angilipe ono nosiringi kou kandena lkisipe pupelie, wake tepa kanopa Yesusinge onomo kulupi toringi múluma yuyu akuna we lerimu kanopalie konopu aisili lipe mundupe ‘I nambolka uluri temunje?’ nimbe pilipe yando orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yesusi lomboropa ola molorumu aku walemonga ⸤yu lombili andoringimenga⸥ yambo talo* kolea kanga Emeasi pungilí puringili. Aku kolea kangamo kinie kolea aili Jerusalleme kinie aulkemo laye sulu mele, illepene killomita mele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eltene Yesusi kolorumumundu anju yando ungu mele teliku puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aulkena aku ulumando ungu mele teliku pangili Yesusi yuyu elte puringiline omba elte kinie tapu topa purumu, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","nakolo Yesusi yu ‘We ye lupere okomo konopu leangili.’ nimbelie terimu, eltene yu naa kanoko imbi siringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yuni elte walsipelie nimbendo: “Elte nambolkamondo ungu mele teliku pukumbiliye?” nirimu. Elte Yesusi toringi kolorumumunge nono ningu we angiliringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tenga imbi Killopasi,* akumuni yundu walsipelie nimbendo: “Jerusalleme sukundu talko ulu wendo orumuma nu naa kanorunuye? Yambo aisili akuna ongo maku tokolie kanoringi nakolo nu pea naa molko kanoringi. Tenga lupe molkolie okono lepamo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Orumu yemone “Nambolka ulumaye?” nirimu. Eltene ningilindu: “Kolea Nasarete ye Yesusinge ulu kanuma.” niringili. “Yesusi yu Pulu Yemone ungu umbu tonjilime pilipe yando nimbe sili ye te* molopalie Pulu Yemo kinie olio mana yamboma kinie kanopo molamili ungu tondoloma nimbe ulu tondoloma terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanu kinie olionga ningu Pulu Yemo popo tonjili ye ailime kinie* olio nokolemele ye ailime kinie ‘Yu kote pilku “Kolopili.” ningu tangi.’ ningu ⸤Romo gapomano yema⸥ anju siringi enene ‘Yu kolopili.’ ningu unju perana uku toko panjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nakolo olio pilirimulu, ‘Yu Pulu Yemone lipe mundurumu, ⸤Romo gapomano yambomane olio⸥ Isirele yamboma ⸤tondolo munduku nokolemelemonga⸥ mindili nombo umbuni tepili molemolomonga olio lipe taponjipe ⸤enenga kíne⸥ wendo lipe ‘Molko konjengi.’ nimbe ⸤kolo wangopa⸥ olionga ye nomi kingimu molopa olio nokopa konjimbe.’ nimbu pilipu konopu sipu molorumulu nakolo yu toringi. Akumunge ungu te pea i sipe: Talko toringi, kinié wale yepoko sipe mele omba pukumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Pe kinié ulu te lupe wendo omula. Yu lombili andorumulumanga ambo pokore kinié ongo níngi mele pilipulie mini wale mundúmulu. Kinié paa ipulueli ou kanu amboma yu ono teringi kou kandena puku kanongi nakolo yunge onomo naa lemu. Ene ongo oliondo ningindu: “Mulu koleana angello talo kanomulu, eltene “Yu we molemo.” níngili.” níngi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanu kinie olio pea molomulu ye talo ono kou kandena pukululie ambomane níngi mele kanongili, nakolo yu naa kanongili.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aku niringili kinie elte lombili akilipe orumu yemone eltendo nimbendo: “Elte aroma topambele. Elte konopu naa pelemomonga ou Pulu Yemone ungu umbu tonjiringime pilku yamboma ningu siringi yemane yundu niringi bokuna molemo mele mongone kanoko komuni pilkululie konopuna liku mengo andolembelkanje ⸤Yesusi kinie talko teringi mele kinie yuni terimu tekemo mele kinie⸥ kamu kamu pilimbelka lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu manie ombalie, ya ye nikimbilimu talko mindili norumu mele mindili nomba mulu koleana ye nomi aili pupe molomba mele ou ningu naa siringiye? Ningu siringi kanumu. Pe kinié ou ningu siringi mele yu aku temu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aku nimbelie Mosisini Yesusi yu yuyu temba mele ou boku marenga topa nirimu mele pulu monjipe nimbe sipe, yandopa yandopa Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemane yu temba mele ou boku marenga toko niringi mele nimbe sipe, aku Pulu Yemonga bokumuni nilimo mele pali* nimbe silipe yambotolo kinie aulkena purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yambotolo puringili koleamo nondoko wendo oringi kinie Yesusi we sumbi sipe tenga lupe pumbe terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nakolo eltene karaye tekolie ningilindu: “Molo. Ena pupe ipu nondopa lemba kene pea peamili.” niringiline yu elte kinie pupe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kanu kinie elte pea kere nongo moloringi kinie yuni pillawa kaloli te lipe Pulu Yemo “Ange.” nimbe, ambolopa pike lepa elte sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aku terimu kinie elte yu kanokolo eltenga Aili Yesusi ningu kanoringili kinie tepa nema lirimu altoko naa kanoringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kanu kinie elte eltelte anju yando kerepali ningulu ningilindu: “Aulkena olto kinie omba ungu nimbe Pulu Yemonga bokumuni nilimo mele ungu pulumu nimbe silipe omu kinie olto kamele kongulu topili ombulu kanumu. Aili Yesusi kinie ombulumunge aku temu lepamo.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kanu kinie elte ola angilku kelko sumbi siku Jerusalleme yando ongolo, lombili andoli ye rureponga yepoko kinie ene pea maku toko moloringi yambo lupema kinie moloringine puringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Suku puringili kinie enene eltendo ningindu: “Ailimu* paa sike lomboropa ola molomu lemo. Yu yuyu Saimono molomuna pupe mona angilimu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kanu kinie yambotolone aulkena puringili kinie ye te omba nirimu mele kepe kanu yemone pillawa kaloli te ambolopa pike lerimu kinie kanokolo ‘Yu Yesusi.’ ningu kanoringili mele kepe enendo temane toko siringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","⸤Yesusi lombili andoli⸥ yambomane ⸤Yesusi yu lomboropa ola molorumu kanoringimundu⸥ ungu mele teko molangi Yesusi yu omba ene moloringine sumbi sipe angilipelie “Ene konopu pe nipili molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ene ‘Yambo kololi tenga minimu kanokomolo.’ konopu lelkolie pungu pungu ningu pipili koloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yuni enendo nimbendo: “Mini wale munduku konopu talo panjiku nambemuna molemeleye?” ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Nanga kitolo kinie kimbuma kanoko ‘Imu na nanu.’ ningu kanayo. Ambolko pilieme. Nanga kangi kinie ombele kinie angilkimu mele minimenga aku sipe angilimoye? ⸤Aku sipe naa angilimo kanumu.⸥” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aku nimbelie yunge kimbu ki pirimu toringime ene lipe ora sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kanu kinie ene yu kanokolie pondeanga konopu siku paa konopu liku munduringi nakolo ‘Sikenje molo nambolkare kanokomolonje?’ ningu konopu talo panjiku we moloringine yuni ene mawa tepalie nimbendo: “Langi nombó te ya lemoye? Siei.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Enene yu oma kaloli te liku siringi, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akumu lipe ene kanoko molangi norumu. ⸤‘Minimu naa molopo yambomo molkoro kanangi.’ nimbe aku terimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yuni enendo nimbendo: “Na ou naa kolopo ene kinie molopolie ene ulu wendo ombá mele nimbu sirindu kanu ulumu i wendo okomo. “Mosisi kinie Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema kinie enene nando ningu boku marenga toringi uluma kinie, Pulu Yemonga konana niringi bokuna molemo konanamane nando nilimo uluma kinie,* kanu uluma sike wendo ombá.” nirindu kanumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Aku nimbelie ‘Pulu Yemonga bokumuni nilimo mele pilku konjengi.’ nimbe yuni ungu pulumu ene nimbe sipelie nimbendo: “Bokuna toringi molemo mele i sipe: ‘Pulu Yemone “Ene nokopa konjimbe ye te lipu mundumbu.” ou nimbe mako torumu ye nomi Kirasimu mindili nomba kolopalie wale yepoko sipemonga ono koleana lomboropa ola molomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aku temba kinie kanu ye Kirasimu yunge talape yambomane yunge tondolomone yamboma ulu pulu keri tengema pilku keri pilku konopu alowa tenge mele kinie, ulu pulu keri tengema Pulu Yemone siye kolopa altopa naa pilipe mongo naa simbe mele kinie,* ningu singíndu Isirele yambomanga kolea aili Jerusalleme pulu monjiku ningu siku koleamanga pali pukulie ningu siliku andonge.’, ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","aku mele nando ou ningu boku toringi.* “Pe kinié nane terindu uluma kinie na kinie teringi uluma kinie kanoringi teringi kanokomelemonga yamboma manda ningu singí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nakolo we naa teangi. Pulu Yemone “Simbu.” nimbe nimbe panjirimu Minimu nane olando pupulie lipu mundumbu kene aku Mini Tondolomo yu mulu koleana manie omba ‘Ene tondolo pupili molangi.’ nimbe ene kinie molomba kene ou tenga lupe naa puku Jerusalleme suku we nokoko molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesusi yu lombili andoringi yamboma kolea kanga Betani lerimuna nondopana memba pupelie nirimumuni, ‘Pulu Yemone ene sewe anjipili.’ nimbe yunge kitolo ola mundupe, “Pulu Yemone ene nokopa konjipe ‘Ene konopu enge nipili molangi.’ nipili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Enendo aku sipe nimbe molopili ⸤Pulu Yemone⸥ yu mulu koleana olando lirimu kinie ene mundupe kelepa mulu koleana olando purumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kanu kinie enene ⸤Yesusi⸥ yu kapi ningu imbi ambolko ola linjikulie kamele paa akoliku, Jerusallemendo kelko yando oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akuna pukulie ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena taki taki molko, Pulu Yemone terimumunge “Ange.” ningu yu kapi ningu yunge imbi ambolko ola linjiringi. ⸤Yesusinge temane peanga ekendo topo pora sikiru.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Paa koronga ou, ⸤mulu matolo kepe melte naa lepili,⸥ Ungumu molorumu. Aku Ungumu Pulu Yemo kinie moloringili. Aku Ungumu yu Pulu Yemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paa koronga ou, melte mana naa lepili, yu Pulu Yemo kinie moloringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ungumu yuni yuyu melema pali terimu. Melte we pora naa purumu. Mele wendo orumuma pali yuni terimuna wendo orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mololi ulu pulumu yu kinie mindi perimu.* Kanu mololi ulu pulumu yambomanga pa tenjilimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aku pa telimuni sumbulu tolemomo pa tenjilimo. Sumbulu tolemomone altopa pa telimu manda pipi sipe sumbulu altopa naa tomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ye te orumumu Pulu Yemone lipe mundurumuna orumu, yunge imbi Jono. ⸤Yu No Linjili Jono kanumu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jonone pa tenjilimunge pulumu nimbe simbe orumu. ‘Yambomane “Nondopa ombá yemo yu sike aku pa tenjilimu.” ningu tondolo munduku piliengi!’* nimbe omba nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jono yu aku pa tenjilimu molo. Yu aku pa tenjilimu ombá mele nimbe simbe orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jonone yamboma ungu nimbe sipe molopili paa sike pa tenjilimuni yamboma pali pa tenjilimo kanumu mana ombá orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yu ma koleana omba molorumu. Yuni yuyu ma koleamo terimu nakolo ma koleana yambomane yu kanokolie ‘Yu ma kolea terimu Pulu Yemo.’ ningu naa kanoko ‘Yu we mana ye te.’ ningu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yu yunge koleana omba molorumu nakolo yunge yambomane “Nu olionga Ailimu okono kene olio ongo nokoko moloi.” ni naa niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nakolo yundu “Nu sike ⸤Pulu Yemone lipe mundurumuna orunu yemo kene⸥* olio nokani pea molamili oi.” ningu yunge unguma tondolo munduku pilku liringi yamboma yuni “Pulu Yemonga ambolangoma molangi.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nakolo kanu yamboma Pulu Yemonga ambolangoma au leringi, aku ulumu kangimunge kongonomo molo. Anupili lapalini “Pulu Yemonga ambolangoma meamili.” ni naa niringila. Pulu Yemone yuyu mindi enendo “Nanga ambolangoma.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ungumu ⸤Pulu Yemo pea moloringilimu⸥ manie omba mana ye au lepa olio kinie pea wale wallo kolte molorumu. Yu mana omba molorumu kinie nemo nemo nimbu kanopolie, yu ye paa peanga, imbi molemo ye tondolomo, kanopo pilirimulu. Kanu ye paa peanga tondolomo Malo telu molorumumu Lapa molorumuna yu pea molkololie mana manie orumumunge yu ye paa peanga lepa imbi paa ola mololi ye tondolomo mindi kanopo pilirimulu. Yu kondo kololi ulu pulumu kinie sike nili ulu pulumu kinie yunge konopuna pepa tengepea terimu yemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","⸤Jono yamboma no linjipe molopili Yesusi Pulu Yemonga Ungumu orumu kinie⸥ Jono yuni yamboma kanu yemo lipe ora sipe yu molorumu mele nimbe sirimu. Yuni ru nimbelie nimbendo: “I yemo nane enendo ou “Nondopa ombá.” nimbu sirindu kanu yemo imu. Na naa molambo i yemo yu koronga ou Pulu Yemo kinie molorumuna “Yu ye nomi ailimu na paa we koropamo.” nirindu* kanu yemo imu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yuni olio we kondo kolemo ulu pulumu yu kinie pelemomonga yuni olio alieli kondo kolopa mindi molopa olio ‘Konopu wayongo siengi.’ nimbe taki taki sewe anjilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosisini olio Pulu Yemonga ungu mane sirimuma mindili sipu tepo molorumulu.* Nakolo olio we kondo kololi ulu pulumu kinie sike unguma kinie aku uluma Yesusi Kirasi yu kinie mindi pepili orumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana yambo tene ou kepe, kinié kepe, Pulu Yemo naa kanolemele. Pulu Yemonga Malo telu mindi molemo, akumu Lapa kinie pea tapu toko molembele, akumuni mindi ‘Pulu Yemo molemo mele kanangi.’ nimbe yu lipe ora sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda yamboma⸤nga ye aili⸥* kolea aili Jerusalleme moloringi ⸤kanu yemane⸥ Pulu Yemo popo tonjiringi ye pokore kinie,** LLipai ye pokore kinie Jono no linjipe molorumuna liku mundukulie, “Jonondo “Nu naeye?” ningu walsiku piliengi pai.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ene ongo yu walsiku piliringi kinie yuni kolo naa topa sumbi sipe nimbelie nimbendo: “Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ nimbe mako torumu ye nomi Kirasimu* na molo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Enene “Nu aku yemo molo liemo nu naeye? Nu Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Illainja, ⸤Pulu Yemone ou olando lirimu akumu⸥* nu kelko onuye?” ningu walsiku piliringi. Yuni “Na akumu molo.” nirimu. Enene ningindu: “Aku liemo ‘Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe simbe ye te pe ombá.’ ⸤ou niringi yemo⸥ nuye?”.** niringi. Yuni “Molo!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kanu kinie enene yundu ningindu: “Nu naeye? Olio liku mundungi yemane ‘Ongo ningu singí.’ ningu nokoko molemele kene nunge imbi lelko si. Nunu nae konopu lekenoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jonone nimbendo: “Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe sirimu ye Aisayane koronga ou nimbendo: “Kolea ku leline ye tene “Ailimunge ombá aulkemo sumbi sinji.” nikimu pilkiru.”* nirimu. Aisayane kanu ou pilirimu ungumu nane kinié nikiru.” nimbe Jonone nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","⸤Kanjollomane⸥ munduringi ongo moloringi yemanga Parisi ye mare moloringila.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aku Parisi yemane yundu walsiku pilkulie ningindu: “Nu ye nomi Kirasimu molola, Illainja molola, ‘Pulu Yemone ungu umbu tonjirimuma pilipe yamboma nimbe simbe ye te pe ombá.’ ou niringi yemo molola. Pe kinié nu nambemuna yambo no linjilinoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonone enendo pundu topa nimbendo: “Na sike no linjilio nakolo nanga kongonomo manie. Ye te olionga koleana sukundu molemo akumu ene kanokolie ‘we yere’ konopu lelko, kanoko imbi naa silimele, ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","akumu na lombili akilipe okomo yemo. ⸤Yambo ailimenga kongono keri teli yambomane sike enenga ailimenga kongono keri tenjingindu enenga kimbu su ka pilke toko su wendo linjilimele nakolo⸥ i ye na lombili akilipe okomomonga kimbu su ka pilke topo su wendo linjimbu kongonomo kepe paa olandopa mele, nane manda naa tenjimbu. Na ye paa keri mele; yu ye paa nomi ailimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","I ulu wendo orumuma Betani taono, no Jodane nekendo lemo koleana, wendo orumu. Jonone akuna yambo no linjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Opalikundu ⸤No Linjili⸥ Jono molorumuna Yesusi ombá orumu kanopalie nirimumuni, yambomando nimbendo: “Kaname! Pulu Yemonga Kongi Sipisipi Walomo* okomo. Yu yambomanga pali ulu pulu keri teringi telemelema kulu tonjilimo tonjimbe yemo okomo.” ⸤nirimu⸥. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Ou nane ye te nirindu kanumu andi okomo ye akumundu nirindu. Ou nane nimbundu: “Ye na lombili ombá ye te na naa molambo yu koronga ou molorumuna yu olandopa na maniendopa.” nirindu kanumu i yemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na kepe yu naa kanorundu nakolo ‘Isirele yamboma yu kanokolie piliengi lipu ora siembo.’ nimbu na ombo yamboma no linjilio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonone yundu ungu te pea nimbendo: “Yu no linjipu molopo kanondu kinie Mini ⸤Kake Telimu⸥ kera waembono mele mulu koleana maniendo omba yu molomuna omba molomu kanondu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nane yu kanopolie yu imbi naa pilipu ‘Yu we yere.’ konopu lelka nakolo nando “Yamboma no linjipui.” nimbe lipe mundurumu yemone na nimbe sipelie nimbendo: “Mini ⸤Kake Telimu⸥ manie omba ye tenga kangi tenga ola omba molomba kanoni kinie aku yemone yamboma Mini ⸤Kake Telimu⸥ linjimbe yemo.” nirimuna pilipulie yu kanopo imbi sipulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","enendo “Yu Pulu Yemonga Malo.” nilio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Opalikundu ⸤No Linjili⸥ Jono no Jodane kelo akuna altopa angilipelie nirimumuni, yu lombili andolimenga* ye talo pea angiliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kanu kinie Yesusi omba purumu kinie yuni kanopalie nimbendo: “Kanale! Pulu Yemonga Kongi Sipisipi Walomo* omba pukumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yu lombili andolitolo yuni nirimumu pilkululie Yesusi lombili puringili.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesusi topele topa elte yu lombili oringili kanopalie eltendo nimbendo: “Nambolka korokombeleye?” nirimu. Eltene yundu “Rapai, nu tena pelenoye?” niringili. (Rapainge ungu pulumu ‘Ungu Mane Silimu’.)* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yuni eltendo “Kanangili wale.” nirimu. Elte yu perimuna puku kanokololie ipupini po killoko mele terimuna kanu enamonga yu pea peringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ye talo Jonone nirimumu pilkululie Yesusi lombili puringili yetolonga te Enderu, Saimono Pitanga angenu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yu sumbi sipe pupe angenu Saimono koropa kanopa lenjipelie yundu nimbendo: “Pulu Yemone “olio nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye nomi Mesayamo* kanopo lenjímulu.” nirimu. (‘Mesaya’ akumu Juda yambomanga ungu te. Mesayamondo Giriki unguna ‘Kirasimu’ nilimele.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aku nimbelie Enderuni angenu Saimono Yesusi molorumuna memba purumu. Yesusini yu kanopalie nimbendo: “Nu Saimono, ‘Jono’ nili ye tenga malo. Nunge imbi te ‘Sipasi’ ningu lenge.” nirimu. (Sipasindu ‘Pita’ niringila. Juda yambomanga unguna ‘Sipasi’ ningu, Giriki unguna ‘Pita’ nilimele, aku ungutolonga pulumu ‘kou mulu’.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Opalikundu Yesusi ‘Kolea Gallilli disiriki pambo.’ konopu lepa pumbe purumu. Pupelie Pillipu aulkena angilirimu kanopalie, “Na lombili oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pillipu kepe Besaida taono yemo, Enderu kinie Pitatolonga koleamo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pillipu Nataniele kanopa lenjipelie yuni yundu nimbendo: “Mosisini boku torumu bokumanga* ‘Ye te ombá.’ nimbe temane torumu kanu yemo kepe, Pulu Yemone ungu umbu tonjirimuma pilku yando ningu siringi yemane enenga bokumanga ‘Ye te ombá.’ ningu temane toringi kanu yemo kepe, kinié olio kanopo lenjímulu. Yu Nasarete taono ye Yesusi, Josepo malo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nakolo ‘Aku kolea kelóna ye aili te manda wendo naa ombá.’ nimbe pilipelie Natanielene Pillipundu nimbendo: “Nasarete taonona ulu peanga te manda wendo ombáye?” nirimu. Pillipuni Natanielendo nimbendo: “Ongo kanoi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kanu kinie Nataniele ombá orumu kinie Yesusini kanopalie, yundu nimbendo: “I ye okomomo paa sike Isirele yemo, yu kolo toli ungu te paa naa pelemo yemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanielene Yesusindu nimbendo: “Nuni na nambe teko kanoko imbi sikulie aku nikinuye?” nirimu. Yesusini pundu topa nimbendo: “Molo. Pillipuni nu ou naa walsipili nu unju piki puluna molonu kinie nu kanopo imbi sindu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aku nirimu kinie Natanielene tondolo mundupe nimbendo: “Rapai,* nu Pulu Yemonga Malo,** olio Isirele yambomanga ye nomi kingimu*** lepamo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesusini nimbendo: “Nane ‘Nu unju piki puluna molonu kinie kanondu.’ nindu kanumunge nuni na ‘Pulu Yemonga Malo molemo.’ ningu pilkinuye? Kinié nane nundu nindu mele maniendopa. Pe ulu tondolo paa olandopama wendo ombá kanoni.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aku nimbelie Yesusini ungu te pea nimbendo: “Nane enendo paa sike nimbu sikirumu: Pe mulu koleana anju yando pupe, Pulu Yemonga angelloma Manie Omba Mana Ye Au Lerimu Yemo* molombana olando puku maniendo ongo tenge kanonge.” nirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wale yepoko sipemonga Kena taono, kolea Gallilli disiriki sukundu lerimu, akuna ye te ambo limbendo langi koyopa yamboma simbe terimu, akuna Yesusi anumu pea maku toko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesusi kinie yu lombili andolime kinie* kanu ambo limbe yemone “Ene kepe langi pea namili wai.” nirimuna ene ongo langi pea noringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Langi nongo molangi no waene pora nirimu kinie Yesusi anumuni Yesusi yundu nimbendo: “Enenga no waene pora nimuna mini wale mundukumili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusini yundu nimbendo: “Ambomo, nane ulu temboma nunge kongono te molo. Nane ungu tembo walemo ou wendo naa oli.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yunge anumuni ⸤ulke pulu yemonga⸥ kendemande yambomando nimbendo: “Yuni enendo “Teai.” nimbé mele aku siku teai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juda yambomane no lengendo no kolko monjiringi ma mingi aili talo pakara akuna angilirimu. Mingimenga tenga tenga nimbe no wane anderete llita molo wane anderete teti llita mele manda molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusini ⸤ulke pulu yemonga⸥ kendemande yambomando nimbendo: “Mingi kanga marenga no puku kolkolie, andi mingi aili lemomanga munduku peke siei.” nirimu. Kanu kinie ene no kolko paa peke siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yuni enendo kelepa nimbendo: “Olama liku mundukulie langi nokoli yemo mengo puku siei.” nirimu. Kanu kinie mengo puku yu siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kanu langi nokoli yemone umbu nomo no waene au lerimu naa kanopalie nomo we nomba pilirimu. Nakolo kendemande no koloringimene nomo kanoko imbi siringi. Langi nokoli yemone nomba pilipelie ambo limbe yemondo “Oi.” nimbelie ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yundu nimbendo: “Yemane pali alieli no waene peangamo ou sikulie, pe yambomane no aisili nongo pora siku altoko ko naa pilimele kinie no keri mele silimele. Nakolo nuni no waene peangamo ou we nosikulie pe kinié sikinumu, ⸤paa papu sikinu⸥.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kolea Gallilli disiriki sukundu lerimu kolea Kena taonona Yesusini terimu ulu akumu pe yu molopa kongono terimu mele lipe ora sirimu ulu tondoloma* tembando i ulumu pulu pulu terimu. Aku sipe yu we ye te molo, yu Pulu Yemonga tondolo peli yemo ‘ene kanangi.’ nimbe lipe ora sirimu. Kanu kinie yu lombili andolimene ‘Yu paa sike ⸤Pulu Yemone lipe mundurumu⸥.’ ningu tondolo munduku piliringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ye ambo limbemonga langi nongo pora sikulie Yesusi kinie anumu kinie angenupili keme lombili andolime keme Kapeniame taonondo pukulie, akuna wale pokore moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda yambomane ponie tenga tenga kolea aili Jerusalleme ongo akuna suku Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele piliringi walema* nondopa wendo ombá terimu kinie Yesusi Kapeniame taono mundupe kelepa kolea aili Jerusalleme olando purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","⸤Pulu Yemo popo toko kaloringi⸥ ulke tembele akuna sukundu pupe kanorumu kinie kongi pirimu kao kondema kinie kongi sipisipi kondema kinie kera waembono kondema kinie kou mone liku bisinete teringi yamboma kepe, kou mone alowa teringi yamboma kepe akuna sukundu aku teko moloringi kanorumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanopa keri kanopalie nirimumuni, ka mare lipe lakopalie kanu ka pulsemone kongime pali ulke tembelena topa makoropa pena pena tepa, kou alowa teringi yambomanga kou mone walena perimuma lipe ondo lepa enenga kou nosiringi poloma lipe topele topalie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","kera monjiku bisinete teringi yambomando nimbendo: “I Taranga ulkena bisinete naa teko i melema wendo liku mengo pame! I Taranga ulkemo sitoamoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yuni aku terimumu yu lombili andolimene kanokolie enene ungu te Pulu Yemonga bokuna sukundu nimbe molemomo konopuni piliringi. Aku ungumuni nimbendo: “Na paa mindili sipulie nunge ulkemo ‘Angilipe peanga tepili.’ nimbu nokopo molio.”* nimbe molemo kanu ungumu konopuni piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kanu kinie yuni terimumu Juda ⸤ye aili⸥ mene* kanokolie yundu ningindu: “Nu namba nambolka nambare likulie aku siku tekenoye? ‘Lipu ora siembo.’ ningu Pulu Yemone “Tei.” nimu liemo Pulu Yemone telemo mele ulu tondolo te olio kanamili tei.” niringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesusini enendo pundu topa nimbendo: “Enene i ulke tembelemo tekisingí kinie nane wale talo takopo yepoko sipemonga takopo limbu.” nirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nirimu mele Juda ⸤ye aili⸥ mene pilkulie ningindu: “I ulke tembelemo ponie paono talo omba pupe kelepa ponie talo pakara omba purumu kinie takoko liringi kanumu. Pe nuni “Wale talo takopo yepoko sipemonga takopo limbu.” nikinuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nakolo yuni “ulke tembelemo” nirimu akumu yunge kangimundu nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanu kinie pe Yesusi kolopa wale talo ono koleana pepa yepoko sipemonga lomboropa ola molorumu kinie yu lombili andolimene yuni ou ulke tembelemondo nirimu mele kelko piliringi. Pilkulie Pulu Yemonga bokuna ⸤Yesusindu⸥ nimbe molorumu ungumu kinie Yesusini nirimu ungumu kinie ‘Sike.’ ningu tondolo munduku piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pulu Yemone Juda yambomanga anda kolepalime Naa Topa We Omba Purumu mele piliringi walemanga* Yesusi Jerusalleme molopalie yambomane yuni yu molopa kongono terimu mele lipe ora sirimu ulu tondolo terimuma kanokolie ‘Yu sike Pulu Yemone ‘Ene nokopa konjimbe ye te lipu mundumbu.’ nimbe mako torumu yemo omba molemo.’** ningu tondolo munduku piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Nakolo Yesusini yamboma pali teko moloringi mele pilipe kelepalie uluma pali yambo tene yu lipe ora sipe naa nipili yu yuyu pilipe molorumu. Enene ningu piliringi mele yuni konopuni pilipelie, ⸤‘We ningu pilimele. Sike kinié aku siku ningu pilimele nakolo opali kepe talu kepe konopu alowa tekolie na ‘Tamili.’ ningu pilingí.’ nimbe pilipelie,⸥ ‘Ene kinie we walu sipu molambo.’ ni naa nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","⸤Juda yambomanga ye mare Parisi moloringi. Aku⸥ ye Parisimenga ye te, imbi ‘Nikodimasi’, yu Juda yamboma nokorumu kanjollo ye te,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yu Yesusi molorumuna ipulueli* ombalie nirimumuni, yundu nimbendo: “Rapai,** ‘Nu Pulu Yemo pea molkololie ungu mane sinindu orunu.’ nimbu pilimolo. Ye te ‘Pulu Yemo kinie naa molkanje Pulu Yemone ulu tondoloma telemo mele nuni teleno aku sipe yuni manda naa telka. Ulu telenomane Pulu Yemo pea molembele mele lipe ora silimo.’*** nimbu pilimolo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesusini pundu topa yundu nimbendo: “Nane nundu paa sike nimbu sikirumu: Yambo te kelko naa mengi liemo* kanu yambomone Pulu Yemone ye nomi kingimu molopa yamboma nokolemo koleamo** manda naa kanopa yunge talapena manda naa molomba.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimasini yundu nimbendo: “Yambo te anda lepa molemo kinie yu nambe teko mengeye? Yu anumunge olona altopa manda suku pumbe, yuni yu manda membaye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesusini pundu topa nimbendo: “Nane nu paa sike nimbu sikirumu: Yambo te nomone kepe Minimuni kepe mei naa mengili liemo kanu yambomo Pulu Yemonga ambolango* naa molopa Pulu Yemo ye nomi kingi molopa nokolemo koleana suku manda naa pumbe, molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Méle kangimuni melemó méle akumu kangimu, yu mana molomba mélemo mindi; méle Pulu Yemonga Minimuni melemó méle akumu minimu, aku mélemo mindi Pulu Yemo molemona manda pupe molomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Akumunge nane nundu nimbundu: “‘Pulu Yemo ye nomi kingimu molopa nokolemo koleana pamili.’ ningí yamboma pali ou altoko meangi.” nikirumundu konopu aisili naa lieyo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poporomemo yuyu pilipe kolea lupe lupemanga tolemo kinie enene yunge ungumu pilku, melema lope lope telemo kanolemele, nakolo yu naa kanoko yu wendo olemona kepe pulimona kepe naa kanolemele. Pulu Yemonga Minimu aku sipela. Minimuni melemó yamboma mini konde pepili ene paa yambo lupe méle molemele yambomane kanolemele, nakolo ⸤Pulu Yemonga⸥ Minimuni kanu yamboma mini kondema silimo kanu Minimu naa kanolemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimasini yundu nimbendo: “I uluma nambe tepa wendo okomoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesusini yundu nimbendo: “Nu Isirele yambomanga ungu mane sili ye te nakolo i nikiru mele naa pilkinu lepamo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nane nundu paa sike nimbu sikirumu: Olio pilimolomando nilimolo; kanolemolomando nimbu silimolo. Nakolo i ungu nilimolo unguma enene pali pilku limele yambo te molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya ma koleana uluma ene nimbu silio kinie enene ‘Kolo tokomonje.’ ningu pilimelemonga pe kinié mulu koleana uluma nimbu sindu liemo ‘Sike nikimu’ ningu nambe teko manda tondolo munduku pilingíye? Manda naa pilingí lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yambo telu kepe olando siku mulu koleana suku naa puringi. Ye telumu mindi, mulu koleana maniendo sipe orumu yemo mindi ou mulu koleana molorumu. Yu Manie Omba Mana Ye Au Lerimu Yemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ou Mosisini yambo naa peli kolea kune kongi ka wambiye kapane telimu lipe ola uku topa monjirimumu mele* aku siku yambomane Manie Omba Mana Ye Au Lerimu Yemo liku ola uku toko panjingí.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kanu kinie, ⸤ou yambo wambiyemane nongo konjiringi kolonge teringi yambomane Mosisini lipe ola uku topa monjirimu wambiye kapane telimu kanokolie konde puringi kanu mele⸥ pe kinié aku siku ‘Yambomane yu mele mele ‘Manie Omba Mana Ye Au Lerimu Yemo yu uluma tepa molemo mele sike.’ ningu tondolo munduku pilingí* yamboma pali molko konjiku mindi pangi.’ nimbe Pulu Yemone ‘Yu unjuna ola uku toko panjengi.’ nimbé nirimu.” nimbe Yesusini nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Pulu Yemone mana yamboma konopu paa aili tepa monjipelie ‘Ene mindili nongo molko kenjingí koleana naa puku, alieli molko konjiku mindi pangi.’ nimbe yunge Malo telumu mindi molorumu nakolo kanumu mana yamboma sirimu. Pe kinié yambomane yu mele mele ‘Yu sike ⸤Pulu Yemonga Malo, olio mindili nolemelka aulkena wendo lili yemo⸥.’ ningu tondolo munduku pilku molonge yamboma mindili nongo molko kenjingí koleana naa puku, alieli molko konjiku mindi pungí.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Pulu Yemone Malondo “Nuni mana yamboma kote pilku ene ka ulkena liku mundeni pui.” ni naa nirimu. ‘Nanga kangomo ene lipe taponjipe mindili nolemelka aulkena wendo lipe na kinie molko konjingí aulkena lipe monjipili.’ nimbe yuni Malondo “Ma koleana manie pui.” nimbe yu lipe mundurumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yambo “Yu sike ⸤Pulu Yemonga Malo, olionga nimbe tenjirimu yemo⸥.” nimbe tondolo mundupe pilipe molomba yambomonga kote naa pemba. Nakolo yambo tene ‘Yu aku sipe naa molemo. Nanga nimbe ulu te naa tenjirimu.’* nimbe pilimbe yambomo, yunge kotemo koronga wendo okomo. Kanu yambomone Pulu Yemonga Malo telumu mindi molemo kanumundu ‘Yu sike Pulu Yemonga Malo.’ nimbe naa pilimuna kanu yambomo kote pilimo yemone lipe kote tenjipe “Yu kolopili.” nimbe koronga ou tenjirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Kotemonga ungu pulumu i sipe: Pa telimu mana wendo orumu* nakolo mana yambomane ulu pulu kerime mindi tekolie pa telimu konopu naa monjiku sumbulu tolimu mindi konopu monjilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yambo ulu pulu kerime telemelemane pa telimu kanoko keri kanokolie, ‘Pa telimuni nanga uluma mona lenjimbe.’ ningu pa telimunge wendo naa olemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nakolo yambo ulu sikema telemo yambomone ‘Pulu Yemone na lipe taponjilimona i ulu pulu sikema telio kene telio uluma yambomane kanangi.’ nimbe pa telimunge yu wendo olemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pe Yesusi kinie yunge lombili andoli yema kinie* kolea Judia disiriki lerimu kolea tenga pukulie niringimuni, akuna wale mare yu ene kinie molkolie, yuni yamboma no linjirimu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jono yu yamboma no linjipe molorumula. Kolea Sellimi nondopa kolea Inono no aisili omba purumuna Jono yuni akuna yamboma no linjirimu, yambo aisili yu molorumuna no lingí oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jono yu ye nomi kingi Erotene ka ou naa sipili* aku tepa molorumu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Walse ⸤No Linjili⸥ Jononga lombili andoli yema kinie Juda ye te kinie anju yando tondolo kerepali ningulie, “Olio no nambe tepo lemolo kinie Pulu Yemone olio kake temba kanombaye?” ningu kerepali niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe Jononga lombili andolime Jono yu molorumuna ongolie ningindu: “Rapai,* ye te no Jodane nekendo nu pea moloringili kinie nuni yu molemo mele ningu sirinu kanu yemone no linjipe molemona yambo aisili pukumili.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aku niringi pilipelie Jonone pundu topa nimbendo: “Mulu koleana Pulu Yemone ‘Ye te ulu te tepili.’ ni naa nilkenje kanu yemone manda naa telka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nane ene ou nimbu sirindu piliringi mele i sipe: Nane nimbundu: “Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ nimbe mako torumu ye nomi Kirasimu* na molo. Pulu Yemone ‘Kirasi yu ombá.’ nimbe na ou kumbi lepa lipe mundurumu.” nirindu piliringi kanumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ye ambo limbemo yemo yunge mindi. Ye ambo limbe yemonga pulu lemba yemone ambo limbe yemone ungu nimbé mele pilimbendo pulu lemba yemo komu tenjipe molomba. Yunge ungumu pilipelie paa konopu simbe. Akumunge yemo kinie pulu lemba yemo konopu simbe mele na aku sipu kamu konopu silio. Ambo limbe yemo olandopa. Yunge pulu lemo yemo yu kinie we tapu topa molemo, aku yemo maniendopa. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aku sipe mele ne no linjipe molemo yemo yunge imbimu sike paa olandopa pumbe. Nanga imbimu sike manie pumbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ye wi ola molopalie maniendo orumu yemo yambomanga pali yu olandopamo. Olio mana yambo molemoloma mana melemanga mindi molopo, mana melemanga mindi imbime nimbu sipu temane tolemolo. Olio maniendopa, mulu koleana molopalie manie orumu yemo yu yambomanga pali olandopa. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yuni mulu koleana kanopa pilirimu mele nimbe silimo nakolo yambomane “Kolo tokomo.” ningu liku su siku naa pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yambo tene yunge ungumu pilipe lipe “Sike nikimu.” nimbe yambomone aku sipe “Pulu Yemone sike nilimo.” nimbéla. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","I Pulu Yemone lipe mundurumu yemo Pulu Yemo yunge Minimu paa aili tepa silimo konopuna pepa kapola telemona yuni Pulu Yemonga ungumu sumbi sipe nilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lapane Malo konopu monjipelie ‘Melema pali Malo nokopili.’ nimbe sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yambo te ‘⸤Yu sike nikimu.⸥ Yu sike Pulu Yemonga Malo.’ nimbe tondolo mundupe pilimbe yambomo alieli konde molopa mindi pumbe, nakolo yambo te Malo bulu sipe yunge ungumu lipe su sipe naa pilimbe yambomo konde mololi ulu pulumu naa limbe. Aku yambomo kinié kepe pe kamu kamu kepe Pulu Yemone mindili lipe simbe ulu pulumu yu kinie pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi yemane* ungu te piliringi mele i sipe: “Yesusi molemona yambo aisili ‘No linjipili.’ ningu pulimele Jono molemona yambo layetolo mele ‘No linjipili.’ ningu pulimele.” niringi ungumu piliringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Nakolo Yesusi yu lombili puringi yamboma yuni no naa linjirimu, yu lombili andoli yemane* yamboma no linjiringi.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","⸤Yesusini yambo no linjirimu⸥ temane akumu Parisi yemane piliringi mele pilipelie Ailimuni kanu walemonga kolea Judia disiriki mundupe kelepa kolea Gallilli disirikindu kelepa pumbe purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yu Gallilli purumu aulke akumu kolea Sameria ai suku singine lepa purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aulkemo aku sipe lerimuna yu kolea Sameria taono tenga orumu, aku taonomonga imbimu Saika. Aku koleamo Juda yambomanga anda kolepa Jekopone yunge malo Josepo sirimu mamonga nondopa lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekopone ‘No molopili.’ nimbe muru akurumu aku no mongolomo kanu kolea Saika lerimu.* Yesusi aulke suluna orumumunge siye terimuna aku no kélona omba manie molopa mulu pilirimu. Kolea ai tangoli mele akuna omba molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","(Yesusi yu lombili andoli ye pea oringime yu mulu pilipe molopili ene langi topo toko lingíndu Saika taonona puringi.) Pe yu mulu pilipe molorumu kinie Sameria ambo te no kolombando orumu kinie Yesusini yundu nimbendo: “No te nambo si.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sameria ambomone yundu nimbendo: “Nu Juda yemo. Na Sameria ambomo. Pe nambemuna nando “No si.” nikinuye?” nirimu. (Aku nirimumunge ungu pulumu i sipe: Juda yambomane Sameria yamboma konopu keri panjiku langi telumu moke teko naa nongo, ene kinie teluna tapu toko naa andoringimunge aku nirimu kanumu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesusini pundu topalie ambomondo nimbendo: “Pulu Yemone melemo we silimo mele pilku, i ye “No si.” nikimu yemo kanoko imbi silinanje yundu “No si.” nilina kinie yuni konde molopa mindi puli nomo* nu silke.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ambomone pundu topa nimbendo: “Ailimu, nu no koloni mingi te naa menu, no mongomo paa maniendopa lemo. Pe i no konde molopa mindi puli nikinu nomo nu tena kolkolie siniye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Olionga anda kolepa i no mongolo sirimu ye Jekopo, yu kinie yunge ambolangoma kinie kongime kinie i nomo noringi, ‘kanu yemo maniendopa nu olandopa.’ ningu nikinuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusini pundu topa nimbendo: “I no mongolona no nonge yamboma altopa no waka lemba, ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nakolo nane no simbu nonge yamboma pe ene no paa waka naa lemba. Nane paa sike nikiru: Nane no simbu akumu nonge yambomanga konopuna no pikipe mindi molopa, konde molko mindi pungí ulu pulumu simbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","⸤Yesusini ungu iku torumu mele naa pilipelie nirimumuni,⸥ ambomone yundu nimbendo: “Ailimu, na no altopa waka naa lepili, ya altopo taki taki ombo no naa kolambo kene nuni no nikinumu nambo si.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yuni yundu nimbendo: “Nunge yemo pea kelko wangili, puku walsipui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ambomone pundu topa nimbendo: “Nanga ye te naa molemo.” nirimu. Yesusini yundu nimbendo: “ “Nunge ye te naa molemo.” nikinumu sike nikinu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ou nu ye te pakara purunu. Pe kinié nu ye te pea pelembelemo nunge emena molo. Nuni kinié ungu nikinumu sike nikinu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ambomone yundu nimbendo: “Ailimu, na pilkiru nu Pulu Yemone ungu umbu tonjilimoma pilku yamboma ningu silino ye te lepamo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Olionga anda kolepalimene i ma pangine Pulu Yemo popo toko kapi niringi nakolo ene Juda yambomane ningindu: “Pulu Yemo popo toko kapi ningí koleamo paa Jerusalleme mindi.” nilimele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesusini tondolo mundupe nimbendo: “Ambomo, nane ya nikirumu nu pilku lini. Wale te wendo ombá kanu walemonga i ma pangine kepe Jerusalleme kepe yambomane Lapa popo toko kapi naa ningí.” nirimu. ⸤Aku ungumunge pulumu: “Koleamanga pali Pulu Yemo popo toko kapi ningí.” nirimu kanumu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Ene Sameria yambomane popo toko kapi nilimele yemo pilku sunduku we nilimele. Olio Juda yambomane popo topo kapi nilimolo yemo molemo mele pilipu konjilimolo. Nambemuna, mana yamboma Pulu Yemone lipe taponjipe, mindili nolemelka aulkena wendo lipe, yu kinie pea molko konjingí aulkena lipe monjilimo ulu pulumu Juda yamboma kinie wendo ombá, enene koleamanga pali yamboma liku ora singímunge aku sipe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nakolo Pulu Yemo sike popo toko kapi ningí yambomane Taranga ungumu ‘Sike ungumu.’ ningu pilku yunge Minimuni tondolo silimomonga Pulu Yemo popo toko kapi ningí wale wendo ombámo koronga wendo omu. Pulu Yemo aku siku popo toko kapi ningí yamboma Tarane korolemomonga kanu walemo wendo omu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pulu Yemo yu minimu, akumunge yu popo toko kapi ningí yambomane yunge Minimuni tondolo silimomonga ‘Yunge ungumu sike ungumu.’ ningu sumbi siku aku tenge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ambomone nimbendo: “Ye nomi Mesayamo* ombá. Yu ombalie ungumanga puluma pali olio mimi sipe nimbe simbe mele na pilipu molio.” nirimu. (Ipuru unguna ‘Mesaya’ niringi akumu, Giriki unguna ‘Kirasi’.* niringi aku ungutolonga pulumu telumu. Ungutolonga pulumu i sipe: Pulu Yemone “Olio nokopa konjimbe ye te lipu mundumbu.” nimbe mako torumu ye nomi kanumu.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kanu kinie Yesusini tondolo mundupe nimbendo: “Nu “Ye nomi Mesayamo ombá.” nikinu akumu na. Na nu kinie ungu nimbu molkombolo yemo kinie, nuni “Ye nomi Mesaya” nikinu kanu yemo kinie, ye telumu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yu aku nimbe molopili yu lombili andoli yema kelko yando ongolie niringimuni, yu ambo te kinie ungu ningu moloringili kanokolie konopu aisili liku munduringi. Nakolo enenga ye tene “Nu nambolka melte lini tekenoye?”, molo “Yu kinie nambemuna ungu ningu molembeleye?” ningu tene kepe naa walsiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kanu kinie ambo kanumu yunge no mingimu mundupe kelepa yu kelepa kanu taonona yando pupe yambomando nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Na ulu terinduma pali ye tene na nimbe simu yemo ene ongo kaname! Pulu Yemone “Olio nokopa konjimbe ye te lipu mundumbu.” nirimu ye nomi Kirasimu yunje.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aku nirimuna pilkulie yamboma taono munduku kelko Yesusi molorumuna onge oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aku teko molangi yu lombili andolimene yu paa karaye tekolie ningindu: “Rapai,* langi te nou.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nakolo yuni enendo nimbendo: “Na langi nombómo lemo, nakolo akumu ene naa pilku naa kanolemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aku nirimu pilkulie yu lombili andolimene anju yando kerepali ningulie ningindu: “Yambo tene langi ou memba omba simunje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesusini nimbendo: “Nanga langi i sipe: Na ‘kongono teani pui.’ nimbe lipe mundurumu yemone* konopu silimo uluma tepo, yunge kongonomo tepo pora simbu. Akumu nanga langimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Enene “Oli kise omba pumbe kinie rasi witi nou lemba, inie topo lipu nosimulú.” nilimele kanumu. Nakolo nane enendo nimbundu: Poniema kaname! Langi pali koronga nou lemu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Langi inie tonjilimo yemo langi inie tonjilimomonga mele kaloli koronga lipe, ‘Lepa mindi pupili.’ nimbe langime inie tonjipe molemo. Aku tenjilimomonga ponie tepa langi panjirimu yemo kinie langi inie tonjilimo yemo kinie peatolo konopu singilí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Akumunge ungu te pelemomo sike. ‘Ye tene langi umbu tonjilimo. Tene langi inie tolemo.’ nilimele ungumu sike. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Langi enene umbu naa toringime nane “Ene inie topai.” nimbu lipu mundurundu. Yambo lupemane ponie mindili siku teringi, nakolo yambo lupemane teringi langime ene inie tolemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ambomone “Na ulu terinduma pali yuni na nimbe simu.” nirimuna pilkulie kanu taonona moloringi Sameria yambo* aisili ‘Yu sike ⸤Pulu Yemone ‘Ene nokopa konjimbe ye te lipu mundumbu.’ nimbe ou mako torumu⸥ ye nomi Kirasimu.’ ningu tondolo munduku piliringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Akumunge Sameria yamboma yu molorumuna ongo, “Nu paa ya pea molamili.” niringi, kanu kinie wale talo yu ene kinie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kanu kinie yambo aisili pea yu yuyu ungu nirimumu pilkulie ‘Yu sike ⸤ye nomi Kirasimu omba molemo. Yuni sike nikimu.⸥’ ningu tondolo munduku piliringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Enene ambomondo ningindu: “Nuni ou ungu ninumu pilipu ‘Yu sike.’ nimbu tondolo mundupu pilímulu nakolo kinié olio oliolio yunge ungumu pilipulie ‘Sike i yemo olio mana yamboma Lipe Taponjipe Mindili Nolemelka Aulkena Wendo Limo Yemo* molemo.’ nimbu tondolo mundupu pilimolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sameria yamboma kinie wale talo molopalie Yesusi ene mundupe kelepa kolea Gallilli disiriki pumbe purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Gallilli Yesusi yunge pulu koleamo. Ou walse Yesusi yuni nimbendo: “Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye tene yunge pulu koleamonga yamboma ungu nimbe silimo kinie pilkulie nilimelemone, enene ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo unguma naa pilku liku su silimele.” nirimu kanumu.)* ⸤‘We koleamanga yambomane kanu yemonga ungumu limele nakolo yunge pulu lemo yambomane naa pilku limele.’ nimbe nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yu Gallilli suku purumu kinie Gallilli yamboma yu orumu kanokolie “Papu okono.” ningu konopu siringi. Ou Pulu Yemone Juda yambomanga anda kolepalime Naa Topa We Omba Purumu mele* piliringi walema wendo orumu kinie ene Jerusalleme puku molangi yuni akuna ulu mare terimu kanoringimunge enene aku siku teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesusi kolea Gallilli disiriki pupelie altopa Kena taonona sukundu orumu. Kanu taonomonga ou yuni umbu no koloringime no waene au lenjirimu.* Kapeniame taono ye nomi kingimunge kongono tenjili ye aili te kanu kolea Kena molorumu, kanumunge malo kuru aili te torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","‘Yesusi kolea Judia disiriki mundupe kelepa kolea Gallilli disiriki sukundu orumu.’ pilipelie nirimumuni, kanu yemo Yesusi molorumuna pupelie nirimumuni, yundu mawa tepalie nimbendo: “Nanga kangomo nondopa kolomba tekemo kene maniendo ongo yu teko konde li.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aku nirimu kinie pilipelie Yesusini yundu nimbendo: “‘Na sike ⸤Pulu Yemo kinie molopalie mana maniendo orumu⸥.’ we ningu naa pilingí lemo. Pulu Yemone ulu tondoloma telemo mele ‘Yuni aku sipe mele temba kinie kanopolie ‘Yu sike ⸤Pulu Yemo kinie molopalie mana maniendo orumu⸥.’ nimbu tondolo mundupu pilimolo.’ ningu nando alieli “Ulu tondoloma ongo tei.” ningu mawa telemele.”.* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kingimunge kongono tenjili ye ailimuni yundu nimbendo: “Ailimu, nanga kangomo mini ou naa pupili nu welea maniendo oi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesusini yundu nimbendo: “Marena konde pumu kene pui.” nirimu. Yemone Yesusini nirimu mele pilipelie ‘Sike nikimu.’ nimbe tondolo mundupe pilipe yu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Maniendo pumbe purumu kinie yunge kendemandema aulkena ongo yu maniendo orumu kanoko likulie enene yundu ningindu: “Marena konde pumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kanu kinie yuni enendo nimbendo: “Ena nambolkana kuru topa kelemuye?” nimbe walsipe pilirimu. Enene yundu ningindu: “Bonongo ai tangoli wane killoko mele kangi nomba kelemu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lapane pilipelie Yesusini “Marena konde pumu.” nirimu kanu enamonga ‘Kangi nomba kelemu lepamo.’ nimbe pilipelie, yu kinie yunge ulke peringi yamboma kinie enene ‘Yesusi yu sike ⸤Pulu Yemo kinie molopalie mana manie orumu lepamo⸥.’ ningu tondolo munduku piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kolea Judia disiriki mundupe kelepa* kolea Gallilli disiriki omba molopalie Yesusini kangomo tepa konde lirimu kanu ulumu aku koleana yu molorumu mele lipe ora sirimu ulu tondolo talo sipe mele terimu. Te ou walse aku koleana umbu no koloringime no waene au lenjirimu kanumu.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pe walse, Juda yambomane ponie tenga tenga ningu Jerusalleme puku Pulu Yemo kinie ulu te teringi wale te* wendo orumu kinie Yesusi Jerusalleme olando purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalleme sukundu, kongi sipisipimenga pala kerepuluna nondopa, no mongo te molorumu, kanu no mongomondo Ipuru unguna ‘Beteseda’ niringi, akuna ulke takaye te pakara angilipe makaye terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Akuna kuru torumu yambo aisili aniembo leringi. Mongo keri lerimu yamboma kinie, kimbu pange tepa karaye tepa perimu yamboma kinie, kimbu kolopa kukurumu yamboma kinie enene (‘Nomo lope lope temba.’ ningu nokoko moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Walse walse nimbe Ailimunge angello te manie omba nomo lope lope tenjirimu kinie yambo te kumbi lepa nona suku purumu yambomo konde purumu.)* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ye te akuna molorumu ponie wane paono tene eti* kuru torumu yu aniembo lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesusi omba, yemo aniembo lerimu kanopa, yu koro ou lipe aniembo lerimu pilipelie, yemo walsipelie nimbendo: “Nu ‘kuru wayongo nipili.’ konopu lekenoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aniembo lerimu yemone pundu topa nimbendo: “Ailimu, no lope lope telemo kinie yambo te na lipe taponjipe nona memba pumbe te naa molemo. Na nanu pumbu telio kinie yambo mare ou kumbi lelko nona pulimele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aku nirimu kinie Yesusini yundu nimbendo: “Nu ola angilku nunge uru peleno kunungumu liku mengo ongo pui.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aku nirimu kinie walsikale yemonga kurumu pora nirimu kinie yu ola angilipe yunge kunungumu lipe memba purumu. I ulu wendo orumu wale akumu ⸤Juda yambomanga koro moloringi⸥ wale Sambate te,* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","akumunge Juda ye ⸤aili⸥* marene kuru pora nirimu yemondo ningindu: “Kinié ⸤koro mololi⸥ wale Sambatemonga nambemuna nunge kunungumu mengo ongo pukunuye? ‘Sambate wale kinie melema naa mengo andai.’ nimbe ungu mane pelemo kanumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nakolo yemone pundu topa nimbendo: “Na tepa konde limu yemone nimbendo: ‘Nunge kunungumu liku ambolko pui.’ nimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aku nirimumunge enene yu altoko walsikulie ningindu: “Ye naene ‘Nunge kunungumu liku ambolko pui.’ nimuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nakolo ye kuru pora nirimu yemo ou aniembo lerimu koleana yambo aisili moloringine Yesusi kiyongo nimbe purumumunge yuni manda yunge imbimu walsipe naa pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pe Yesusi kanu yemo ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena kanopalie yundu nimbendo: “Piliei. Kinié nunge kuru pora nimu nu altoko konde moleno kene nu ulu pulu kerime manda teko, altoko naa tei! Altoko tenu liemo nu ulu umbuni aili te wendo ombánje.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ye kanumuni anju pupe Juda ye ailimendo nimbendo: “Na tepa konde limu kanumu Yesusi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesusini ene koro moloringi wale Sambatemonga* aku sipe uluma terimuna Juda ye ailimene Yesusi yu pulu monjiku teko kenjiku umbuni siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesusini enendo nimbendo: “Tarane ou yamboma walemanga pali lipe taponjirimu mele kinié kepe aku sipe tepa molemo. Na aku sipe Sambate walemanga kongono teliola.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yuni aku nirimuna pilku Juda ye ailimene ‘Yesusi yu paa kamu topo konjimulu.’ konopu lelko aulke te koroko moloringi. Ou Sambate walemonga ungu manemo pulue torumumunge pilku yu mumindili kolkolie; pe “Pulu Yemo yunge lapa.” nirimumunge yu ‘Pulu Yemo kinie kapola kapola molembolo.’ nimbe nirimumunge yu kamu mumindili kolko yu tonge teringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesusini enendo pundu topa nimbendo: “Nane ene paa sike nimbu sikirumu: Malone yuyu uluma manda naa telemo temba. Yunge Lapane telemo mele kanopalie manda lepa telemo. Lapane telemo uluma mindi Malone telemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nambemuna, Lapane Malo konopu monjipelie yuni telemo mele pali Malo lipe ora silimo. Ye tepa konde limu akumu maniendopa. Paa sike pe ene paa kanoko konopu aisili liku mundungí ulu tondolo olandopama Lapane Malo lipe ora simbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Akumu nambe tepa wendo ombáye? Lapane yambo kololime topa makinjipelie ‘Konde molangi.’ nilimo mele aku sipe Malone yambo kololime ‘Konde pangi.’ konopu lemo yamboma tepa konde limo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ungu te pea i sipe: ‘Yambomane Lapanga imbimu ambolko ola linjilimele mele Malonga imbimu aku siku ambolko ola linjengi.’ nimbe Lapane kote pilipe yamboma naa apurupe kote pilili kongono akumu Malo sirimu. Akumunge yambomane Malonga imbimu ambolko ola naa linjilimele yambomane aku siku Malo yando lipe mundurumu Lapanga imbimu kepe ambolko ola naa linjilimelela. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nane enendo paa sike nimbu sikirumu: Nanga ungumu pilku, na lipe mundurumuna orundu yemo ‘Yu sike Pulu Yemo.’ ningu tondolo munduku pilimele* yamboma konde molopa mindi puli ulu pulumu ene kinie pelemo. Pe kote walemo wendo ombá kinie ene kotena naa angilingíla. Kanu yamboma kololi ulu pulumu pelemo aulkemo munduku kelko konde molopa mindi puli aulkena pulimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nane enendo paa sike nimbu sikirumu: Wale wendo ombámo kinié koronga wendo omu. Kanu walemonga Pulu Yemo Malonga ungumu kololi yamboma pilingí. Kanu kinie yunge ungumu ‘Sike’ ningu pilku liku molonge yamboma konde molonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Melema konde mololi ulu pulumu Lapa kinie pelemo mele aku sipe Lapane ‘Melema konde mololi ulu pulumu Malo kinie pepili.’ nirimula. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Malo yu Manie Omba Mana Ye Au Lerimu Yemo molemomonga Lapane ‘Malo yambomanga kote pilipili.’ nimbe nambamo sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Nakolo akumunge mindi ene konopu aisili liku naa mundengi. Nambemuna, wale te wendo ombá, kanu walemonga yambo ono koleana pelemelemane Malonga ungumu pilkulie ningímuni, ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ono koleamo munduku kelko wendo onge. Kanu kinie lomboroko ola molonge yambomanga ou mana konde molkolie teko konjiku moloringi yamboma konde molonge; ou mana teko kenjiku moloringi yamboma pe kotena angilkulie pe mindili nonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na nanu ulu te manda naa tembo. Tarane nilimo mele pilipulie yambomanga kotema apurupu pilio. ‘Na nanu konopu siembo.’ nimbu uluma naa tepo, ‘Na lipe mundurumu yemo konopu sipili.’ nimbu uluma teliomonga kote sumbi sipu pilipu apurupu konjilio. ⸤nirimu.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sike na molio mele na nanu nimbu sindu liemo ‘Kolo tokomonje.’ ningu pilíngi liemo papu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ye tene lupe* na molio mele nimbe silimo, akumu na pilkiru nando nilimo mele paa sike nilimo, ‘Kolo tokomonje.’ manda naa ningí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Enene ye mare ⸤No Linjili⸥ Jono molorumuna “Pai.” ningu liku munduringi kinie yuni na molio mele ‘sike’ nimbe sirimu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mana yambo tene na molio mele yamboma nimbe sipe “Sike nikimu. Sike aku sipe molemo.” nimu liemo na konopu aisili lipu naa mundupu, ‘Uluri molo.’ konopu lelio, nakolo ‘Pulu Yemone ene lipe taponjipe mindili nolemelka aulkena wendo lipili.’* nimbu Jonone nando nirimu mele ene nimbu sikiru. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonone kongono terimumunge yu kiye mele nomba yamboma pa tenjirimu. Kanu kinie layekolo ene konopu siku kanu pa tenjirimuna moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nakolo Jonone na lipe taponjipe na molio mele ene nimbe sirimu mele maniendopa. Ulu te na molio mele lipe taponjipe lipe ora silimo mele olandopa. Tarane “Ulu tondolo teko pora sieni.” nimbe na sirimu ulu tondolo telio kanumane na lipe taponjipe, Tarane na “Pui.” nimbe lipe mundurumu mele ene lipe ora silimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tarane na “Pui.” nimbe lipe mundurumuna orundumuni kepe nanga nimbe para sinjílimu molopa na molio mele nimbe sirimu. Enene yunge kerena ungu nirimuma walsikale kepe komumuni naa pilku,* yunge kumbikeremo mongone naa kanoringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ungu te pea kepe. Tarane lipe mundurumu yemonga ungumu “Kolo tokomo.” ningu pilimelemonga yu lipe mundurumu Lapanga ungumu enenga konopumanga naa pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","‘Pulu Yemonga bokuna ungu molemomane olio alieli konde molopo mindi pumulú ulu pulumu simbe.’ ningu mimi siku kanolemele. Aku mimi siku kanolemele bokumuni na molio mele nimbe silimo ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nakolo ‘Konde molopo mindi pumulú ulu pulumu liemili.’ naa ningu, na moliona ‘naa omolo.’ ningu karaye telemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“‘Yambomane na kapi ningu nanga imbi ambolko ola linjingí kinie na ailimu molambo.’ nimbu aku naa telio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ene molemele mele nane pilio. Pulu Yemo konopu monjili ulu pulumu ene kinie naa pelemo pilio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nanga Tarane na namba sipe yunge kongonomo ‘tenjipui.’ nimbe na lipe mundurumuna orundu* nakolo nanga ungumu ene naa pilku limele. Nakolo yambo tene yuyu namba lipe omba kongono telkanje aku yambomonga ungumu pilku limelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ene eneno anju yando ‘imbi molopili.’ ningu, Pulu Ye telumu mindi molemo akumuni enenga imbi ‘ambolopa ola linjipili.’ naa nilimele liemo na molio mele nimbu silio ungumu ‘Sike nikimu.’ ningu nambe teko pilingíye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nakolo ⸤na kinie⸥ teko kenjilimelemonga ‘Pulu Yemonga kote walemo wendo ombá kinie Tarane kote pilipe molopili nane nanu kote tenjimbe.’ ningu naa piliengi! ‘Mosisini* ene lipe taponjimbe.’ konopu lemele yemone enenga kote tenjimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosisini na ombo molombo mele boku torumuna enene ‘Mosisini nirimu unguma sike nirimu.’ ningu pilimelkanje nanga ungumu kepe ‘Sike nikimu.’ ningu pilimelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nakolo yuni nanga temane bokuna torumumu ‘Sike nikimu.’ ningu naa pilimelemonga nanga ungu nikirumu ‘Sike nikimu.’ ningu nambe teko pilingíye?” nimbe Yesusini nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pe walse Yesusi Nomu Gallilli nona andoli sipine molopa nekendo purumu. (Aku nomumunge imbi te ‘Nomu Tapiriasi’ niringi.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aku nomuna nekendo purumu kinie kuru torumu yamboma tepa konde lirimu kanokolie ‘Pulu Yemone mindi ulu tondoloma telemo mele yuni aku sipe tekemo.’ ningu kanokolie* yambo paa aisili yu purumuna akiliku lombili puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesusi ma pangine ola pupe lombili andolime* pea puku manie moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juda yambomane ⸤ponie tenga tenga kolea aili Jerusalleme ongo akuna suku⸥ Pulu Yemone enenga anda kolepalime Naa Topa We Omba Purumu mele* pilingindu Pulu Yemo kinie ulu te teringi walema nondopa wendo ombá terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesusi ma pangine ola molopa maniendo sipe kanopalie yambo paa aisili yu orumu aulkena lombili oringi kanorumu. Kanopalie yuni yu lombili andoli ye Pillipundu nimbendo: “I yamboma nonge langime tena topo topo linjemili konopu lekenoye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yuni aku sipe Pillipundu we walsipe pilirimu. Yesusi yuni temba mele yuyu pilipe molorumu nakolo ‘Pillipu yuni nambolka nimbenje? ‘Nane ulu tondolo te tepolie manda langi simbu.’ konopu lemba, molo we mini wale mundumbenje piliembo.’ nimbelie yuni aku sipe Pillipundu walsipe pilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pillipuni yundu nimbendo: “Kakopoi ye tene oli engaki kongono tepalie mele kalolimu limo kou monemane langi topo topo limelkanje yambo mare mindi laye kolte liku nolemelka. Mare molo tolka naa nolemelka.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lombili andoli te, Saimono Pitanga angenu Enderu, yuni nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ya kango te rasi balli pillawa kaloli kanga te pakara kinie oma kaloli talo kinie nosipe molemo. Nakolo akumu layetolo, yambo paa aisili. Kapola naa temba lemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesusini “Yamboma “Manie molangi.” niengi.” nirimu. Aku koleana era aisili orumuna manie moloringi. Ye pape tausini mele akuna manie moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kanu kinie Yesusini balli pillawa kalolime lipe ambolopalie Pulu Yemondo “Ange.” nimbe yambo moloringime moke tepa ene manda nonge mele sirimu. Omatolo aku sipela moke terimu. Nongo olo tenjiringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kanu langi noringi olo terimu kinie yuni yu lombili andolimendo nimbendo: “Langi kakena lemoma we manie pupe lemba kapola naa temba kene liku maku tai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kanu kinie nongo pora siringi kinie kakena lerimuma lombili andolimene liku maku toko wale basikete engaki rurepo lakilku toko peke siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesusini Pulu Yemone mindi ulu tondolo manda telka mele akumu terimu kinie kanokolie yambomane pulu monjiku ningindu: “ “Pulu Yemone ungu umbu tonjilime pilipe yando nimbe simbe ye te ma koleana omba olio nokomba.” ningu panjiringimu* paa sike i yemo yu lepamo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aku ningu pilkulie enene ‘Yu olionga ye nomi kingimu molopili.’ ningu yu tondolo munduku ambolko liku ‘enenga kingimu molopili.’ ningí teringi. Aku tenge teringi pilipelie yu yuyu molombando ma pangine ola altopa pupe molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena pupe kolea kala torumu kinie yu lombili andolime ma pangine maniendo puku nomu kélona maniendo puku ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","akuna nona andoli sipi tenga ola puku nomuna yakondo ongo Kapeniame taono ongo pungí puringi. Aku kinie sumbulu torumu nakolo Yesusi naa orumuna lombili andolime eneno puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","⸤Sipine ola molko pungí puringi kinie⸥ poporome tondolo torumu kinie nomo ola pupe manie omba terimu, sipimu topa ola munde manie munde tepa topele mapele torumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sipimu kunduringi nomu ai suku síngi melena purumu kinie Yesusi nomuna ola kimbu kongono tepa sipimu purumuna orumu kanokolie ‘Kuru te okomo.’ konopu lelkolie paa mini wale aili teko munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nakolo yuni enendo nimbendo: “Na mindi okoro, pipili naa kolai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aku nirimuna pilkulie “⸤Ailimu okomo lepamo.⸥ Sipine pea molamili.” ningu enene konopu siku yu sipimunge sukundu liringi. Sukundu orumu kinie ene pungí puringi nomu kélona sipimu walsikale purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ipulueli ou yamboma nomu kélo nekendo ipulueli moloringime konopu kimbu sikulie niringimuni, ‘Bonongo ipulueli nomuna andoli sipi telu mindi ya lemu, Yesusi akuna suku naa pumu, yu lombili andolime eneno akuna suku puku nomu kélo nekendo púngi.’ ningu piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kanu kinie bonongo Ailimuni langi wallo kolte lipe ambolopa Pulu Yemondo “Ange.” nimbe yamboma sirimu noringi koleana nondopa kolea aili Tapiriasi yambomanga sipi mare nomu kélona oringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yesusini langi sirimu noringi koleana yambomane Yesusi yu korokolie niringimuni, yu kinie yu lombili andolime kinie akuna naa moloringi kanokolie sipi ene moloringine nomu kélona nondoko ongo leringimenga suku puku Kapeniame taonondo Yesusi koronge puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nomu nekendo ongo Yesusi kanoko lenjikulie enene yu walsiku pilkulie ningindu: “Rapai,* nu tewale yando onuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nakolo yu orumu mele nimbe para naa sipelie pundu topa enendo nimbendo: “Nane enendo paa sike nimbu sikirumu: Nane ⸤Pulu Yemone na lipe taponjilimo mele⸥ lipe ora silimo ulu tondoloma* teliomonga enene na naa korokomele. Nane ene langi sindu nongo olo tenjíngi kanumunge mindi na korokomele lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ene langi nondopa purulimoma ‘Lipu nomolo.’ ningu kongono naa teayo.* Kanu langime nongolie nilimelemone, kolonge walema wendo olemo kinie kolemelela. Langi, Manie Omba Mana Ye Au Lerimu Yemone** silimo langi, kanumu naa purulimo, kanumu nolemele kinie konde molko konjiku mindi pulimele kanu langimu ‘Lipu namili.’ ningu mindi kongono teayo. ‘ ‘Ye akumuni sike kanu langimu yamboma simbe.’ ningu piliengi!’ nimbe Pulu Yemone ulu tondoloma telemo mele ‘Aku yemone ulu tondoloma aku sipe tepili.’ nimbe Pulu Yemo yuni yu sirimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","⸤‘Sike langimundu nikimu.’ ningu pilku yuni nirimu ungumu pilku sundukulie niringimuni,*⸥ enene yundu walsiku pilkulie ningindu: “Konde molopo mindi pumulú langi lipu namili kene olio nambe tepolie Pulu Yemone kanopa peanga kanomba kongonoma temoloye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yuni pundu topa nimbendo: “Pulu Yemonga kongonomo i sipe: ‘Pulu Yemone ma koleana lipe mundurumu yemo yu sike Pulu Yemonga malo, ⸤yu sike olio molopo konjipu mindi pumulú ulu pulumu simbe yemo⸥.’ ningu tondolo munduku pilku molai.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aku nirimu pilkulie enene yundu walsikulie ningindu: “Nuni ‘ “Na sike Pulu Yemone lipe mundurumu. Nane nikiru unguma sike unguma.” nilio akumu ‘Sike.’ ningu tondolo munduku piliengi.’ ningu Pulu Yemone mindi ulu tondolo manda telemo uluma mele nuni aku siku nambolka ulu tondolo te liku ora siniye? Nambe teni kinie kanopolie ‘Nuni sike nikinu.’ nimbu pilimulúnje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“Olionga anda kolepali ou moloringime kolea ku leline langi mena noringi.* Langi mena orumu mele Pulu Yemonga bokuna temanemo molemo: ‘Yuni ‘Ene mulu koleana yando langi nangi.’ nimbelie sirimu.’** ungu akumu molemo. ⸤Nuni olionga aku siku tenjini molo nambe tenjiniye?⸥” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesusini enendo nimbendo: “Nane enendo paa sike nimbu sikirumu: Moloringi yamboma mulu koleana yando langi sirimu yemo Mosisi molo. Tarane sirimu. Molko konjiku mindi puli ulu pulu pelemo langi nikiru kanu sike langimu mulu koleana yando silimo yemo Tara mindila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mulu koleana manie omba mana yamboma molko konjiku mindi pungí ulu pulumu silimomo yu Pulu Yemone silimo langimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesusini nirimu mele pilku sundukulie, “Ailimu,* aku langimu kinié kepe pe pe kepe si.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kanu kinie Yesusini enendo nimbendo: “Molko konjiku mindi pungí langimu na.* Umbu langi nongolie engele naa kolko kangi tondolo pupili molemele mele aku sipe na molombona onge yamboma enenga minimu engele naa kolomba, konopu tondolo pupili molonge. Umbu no nongolie no waka naa kolko kapola molemele aku mele na nilio unguma kepe molio mele kepe manda tembo mele kepe ‘Sike.’ ningu tondolo munduku pilingí yamboma altoko alieli minimu no waka naa lepili molonge.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aku tenge yamboma aku siku molonge nakolo “Enene na ⸤Pulu Yemonga ulu tondoloma telio mele⸥ kanokolie kanoko sunduku ‘We telemo. Yu Pulu Yemone naa lipe mundurumu.’ ningu pilimele.” ou nimbu sirindu kanu mele kinié kepe aku siku we teko molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tarane ‘Nanga yamboma molangi.’ nimbe mako tonjilimo yamboma pali na molombona ongo na tondolo munduku pilingí. Kanu kinie na lombili andongendo na molombona onge yamboma telurindu kepe “Lombili naa ongo anju pui.” paa naa nimbumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“‘Na nanu konopuna pilkiru mele teambo.’ nimbu na mulu koleana mundupu kelepo mana maniendo naa orundu, molo. Na lipe mundurumumuni konopuni pilimo mele tembo orundu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na lipe mundurumu yemone konopuni pilirimu mele i sipe: ‘Nane ⸤Malo⸥ simbu yamboma pali ⸤Malone⸥ nokopa konjipe, telu kepe mundupe kelepalie, mindili nonge koleana paa naa pumbe,* ma kolea pora nimbé walemonga ene pali topa makinjipe olando lipili.’ konopu lemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na lipe mundurumu Tarane konopuni pilirimu mele i sipe: ‘Nanga malo* ‘olio lipe taponjipe, mindili nolemolka aulkemo wendo limbe.’ ningu tondolo munduku pilingí yamboma molko konjiku mindi pangi.’ nimbe konopuni pilimo. Kanu kinie aku tenge yamboma ma kolea pora nimbé walemonga kinie nane topo makinjipu olando limbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesusini “Na mulu koleana maniendo orundu langimu.” nirimu pilku keri pilkulie Juda ye ailimene* yu mumindili kolko eneno pulu monjiku konokono ningulie ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ningindu: “Aku ungu nikimu yemo Joseponga malo Yesusi mindi. Yunge anumu lapatolo kanolemolo kanumu. Pe yu “Mulu koleana molopo mana maniendo orundu.” nikimumu nambe tepa nikimuye?” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesusini nimbendo: “Ene anju yando konokono manda nieme! ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yambo teluri kepe na we manda naa lombili onge. Na lipe mundurumu Tarane konopuna kundulimo yamboma mindi na lombili olemele. Na moliona ongo na tondolo munduku pilimele yamboma kolea pora nimbé walemonga nane topo makinjipu olando limbu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yemanga bokuna molemo ungu te i sipe: “Pulu Yemone yamboma pali ungu mane simbe.”* ningu toringi bokuna aku sipe molemo. Tarane nilimo mele pilkulie kanu ungumanga puluma pilku limele yamboma pali na moliona olemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Taranga ungumu pilimele nikiru akumu paa sike yunge ungumu pilimelemondo nikiru nakolo yu mongone naa kanolemele. Ma koleana yambo telurini kepe Tara naa kanoringi naa kanolemele. Yambo telumuni mindi yu kanorumu. Tara kinie molopalie manie orumumuni mindi yu kanorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nane enendo paa sike nimbu sikirumu: Nilio unguma ‘Sike nilimo.’ ningu tondolo munduku pilimele yamboma molko konjiku mindi pungí ulu pulumu ene kinie pelemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mini pali molko konjiku mindi pungí gamo na.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Enenga koro ou moloringi yambomane kolea ku leline langi mena* noringi nakolo molko mindi naa puringi. Enenga kolonge walema wendo orumu kinie koloringila. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Nakolo i kinié nikiru langimu mulu koleana maniendo okomo langimu. Akumu nonge yamboma mini pali naa kolonge. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pora naa nimbe we lepa mindi puli langimu, akuna suku molko konjiku mindi puli ulu pulumu pelemo langimu, akumu mulu koleana maniendo orumu langimu na.* Aku langimu nanga kangimu. ‘Ma koleana yamboma, mini pali molko konjiku mindi pangi.’ nimbu nane nanga kangimu enenga langi simbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","⸤Yesusini aku nirimu pilku sundukulie⸥ yambomane kerepali ningulie, “I yemo olio yunge kangimu “Nangi.” nimbe nambe tepa manda simbendo nikimuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesusini enendo nimbendo: “Nane enendo paa sike nimbu sikirumu: Enene Manie Omba Mana Ye Au Lerimu Yemonga kangimu naa nongo yunge mememo naa nongi liemo molko konjiku mindi puli ulu pulumu ene kinie manda naa pemba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nanga kangimu kinie mememotolo nonge yamboma alieli molko konjiku mindi pungí ulu pulumu ene kinie pelemo. Kanu yamboma ma kolea pora nimbé walemonga nane topo makinjipu olando limbu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Nanga kangimu sike langimu; nanga mememo sike nomo. Umbu ga kinie no kinie nongolie, kolonge wale wendo olemo kinie kolemele. Nakolo nanga kangimu kinie mememotolo nolemele yamboma molko konjiku mindi pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nanga kangimu kinie mememotolo nolemele yamboma ene na kinie tapu toko molemele, na ene kinie tapu topo molio.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Molopa mindi pulimo Tarane na lipe mundurumu, yuni na ‘Molko mindi pani.’ nirimuna molopo mindi pulio, aku siku melela na nonge yamboma ‘Molko mindi pangi.’ nimbú, kanu kinie ene mini pali molko mindi pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aku langimu mulu koleana maniendo orumu langimu. Olionga ou anda kolepali moloringimene langi mena nongolie ⸤kolonge walema wendo orumu kinie⸥ koloringi, nakolo pe kinié orumu langimu kinie ou orumu langi menamo kinie telu sipe molo. Pe kinié orumu langi imu* nonge kinie alieli molko konjiku mindi pungí.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Juda yamboma maku toko Pulu Yemonga ungumu piliringi ulke te, Kapeniame taonona angilirimu, akuna suku Yesusini yamboma ungu mane sipe aku unguma nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesusini ⸤yunge kangimu kinie mememotolo langi kinie no kinie nongemonga⸥ nirimu mele pilkulie Yesusi lombili andoringi yambo* aisilini ningindu: “I ungumu aroma topa nikimu. Naene manda pilipe limbeye? Olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yu lombili andoringi yamboma yu nirimumunge pilku keri pilku anju yando konokono ningu kerepali niringi Yesusini pilipelie nirimumuni, yuni enendo nimbendo: “I ungumu ene pilku keri pilkimiliye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pe kinié Manie Omba Mana Ye Au Lerimu Yemo ou molorumuna kelepa olando pumu kanongi liemo nambe tengeye? Kamu mumindili kolongenje? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Minimuni konde molko puli ulu pulumu silimo; kangimuni konde molko pungí uluri naa telemo. Nane enendo ungu nindu akuma konde molko mindi puli ulu pulumu. Akuma enenga konopuna suku pemba kinie ene mini pali konde molko mindi pungí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nakolo ene molemele yambo marene ‘yu kolo tokomo.’ ningu pilkimili.” nirimu. Yuni pilipe ‘Yu kolo toli yemo.’ ningu pilingí yamboma kinie ‘Yu sike ungu nili yemo.’ ningu pilingí yamboma kinie koronga apurupe pilipe, Yesusi yu yunge opa touma lipe simbe yemo koronga pilipe molorumuna “Ene mare na ‘Kolo tokomo.’ ningu pilkimili.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yuni ungu te pea nimbendo: “Ene marene na ‘Kolo tolemo.’ ningu pilimelemonga ‘Tarane “Na moliona pai.” ni naa nilimo yamboma na moliona manda naa ongo, na tondolo munduku manda naa pilku andonge.’ ou nimbu sindu kanumu.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aku ungu nirimu enamonga kepe pe enamanga kepe yu lombili andoringi yambo aisili yuni nirimu mele pilku keri pilkulie yu munduku kelko bulu siku altoko yu lombili naa puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yu munduku keleringi kinie yu lombili andoli rurepondo yuni walsipe pilipelie nimbendo: “Ene kepe na ‘mundupu kelepo anju pumulú.’ konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimono Pitane pundu topa nimbendo: “Ailimu, nae molemona pumulúye? Molopo konjipu mindi pumulú unguma nu kinie pelemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Olio pilipu nu ‘Pulu Yemonga Kake Teli Yemo’ nimbu tondolo mundupu pilimolo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusini pundu topa nimbendo: “Nane nanu ene rurepondo pali ‘Nanga yema molangi.’ nimbu mako torundu nakolo enenga ye te depele* mele molemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Aku nirimumu Saimono Isikeriote malo Judasini tembamondo pilipelie nirimu. Judasi Isikeriote yu ene ye rurepo akumanga ye te nakolo yuni pe Yesusi lipe yunge opa touma sirimuna toringi.)* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kanu kinie pe Yesusi kolea Gallilli disiriki andopa molorumu. Juda ye aili kolea Judia disiriki moloringimene yu tonge nokoko moloringimunge pilipelie yu kelepa ‘Judia naa pumbu.’ nimbe anju molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nakolo Juda yambomane ou kolea ku leline sele ulke takoko peringi walema* piliringi wale kake telime nondopa wendo ombá terimu kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesusi yunge angenupilini yundu ningindu: “‘Nuni ‘ulu tondoloma teleno mele nu lombili andolemele yamboma* kanangi.’ ningu nu ya munduku kelko Judiando pani.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“Yambo tene ‘yu kongono tepa molemo mele pilku yu kanoko imbi siengi.’ nimbe uluma lopi tepa naa telemo. Akumunge nu aku uluma sike teleno liemo yambomane pali kanangi puku tepui.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesusi angenupilini kepe ‘Yesusi yu Pulu Yemone lipe mundurumuna orumu yemo.’ ningu naa pilkulie aku siku niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aku niringimunge Yesusini enendo nimbendo: “Nanga walemo ou wendo naa oli.* Kinié alieli ulu tenge walema enenga walema. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma kolea yambomane ene kinie konopu keri naa panjilimele nakolo nane yambomando “Ulu telemelema teko kenjilimele.” niliomonga na kinie konopu keri panjilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ene wale kake telimu wendo ombá pilipungí liemo pangi. Nakolo nanga walemo ou naa wendo okomona na ⸤isili ou⸥ naa pumbu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aku nimbelie yu Gallilli we molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nakolo Yesusi yunge angenupili ‘Wale kake telime* pea piliemili.’ ningu ou puringi kinie Yesusi kepe purumu. Nakolo Yesusi yu ‘naa kanoko imbi siengi.’ nimbe kiyongo nimbe kolea Judia disiriki pupe kolea aili Jerusalleme purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akuna Juda yambomanga wale kake telime piliringi Juda ye ailimene* ‘Yesusi omunje.’ ningu koroko molkolie eneno ningindu: “Kanu yemo tena molemonje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","We yambomanga aisilini yundu olo toko ningu andoko moloringi. Marene ningindu: “Yu ye peangamo.” niringi. Nakolo marene ningindu: “Yu yandopa yamboma kolo topa silimo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nakolo ene Juda ye ailime pipili kolkolie ‘Olio nikimulu mele ene pilingí kinie mongo limulú.’ ningu ungu tondolo teko naa niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kake teli walema ou wendo orumu suku singine Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena pupe yamboma mane sirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda ye ailimene konopu aisili liku mundukulie ningindu: “Nambe tepa i yemo pilipe konginjili pelemoye? Yu sukuli aili tenga naa purumu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesusini pundu topa nimbendo: “I ungu nimbu siliomo nanga ungu te molo. Na lipe mundurumuna orundu yemonga ungumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","‘Pulu Yemone “Teai.” nilimo uluma pilipu lipu teambo.’ konopu lepa molemo yambomone nane ungu nilio ungumunge pulumu pilipelie, ‘Nane Pulu Yemonga ungumu nilimo.’ molo ‘Yuni yuyu konopuni pilipe nilimo.’ nimbe pilimbe. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yambo tene yuyu konopuni pilipelie ungu nimbe silimomone ‘Nanga imbi ola molopili.’ nimbe telemo, nakolo yambo tene ‘Lipe mundurumu yemonga imbimu ambolopo ola linjembo.’ nimbe kongono telemo yambomo yu sumbi nili yambo te molopa, tepa kenjipe kolo toli yambo te naa molemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ou Mosisini ene Pulu Yemonga ungu manema naa sinjirimuye? Sirimu nakolo ene molemelemanga telurini kepe kanu ungu manema pilku tenge panjiku naa telemele. Aku liemo ‘Na kanu ungu manema pulue tolemo.’ ningu nambemuna toko konjingí tekemeleye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yuni aku sipe nirimu pilkulie yambomane pundu toko ningindu: “Naene nu topa konjimbe tekemoye? Nunge konopuna kuru te molemomonga pilkulie aku siku nikinu lepamo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesusini enendo pundu topa nimbendo: “Nane ulu tondolo te terindu kinie ene konopu aisili liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosisini ‘Kangomanga kangi te makaye teko kopisiengi.’ nimbe ungu mane sipe panjirimumunge ene koro molemele wale Sambatemo* kinie kangomanga kangi te makaye teko kopisilimele. (Sike Mosisini ou pulu pulu ‘aku ulumu teamili.’ ni naa nirimu. Ou enenga anda kolepalimene aku ulumu teringi, nakolo pe Mosisini kanu ungu manemo sipe panjirimumunge pilkulie telemele.) ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Enene Mosisini ungu mane sirimumu pilku likulie kango tenga kangi te kopisingí walemo* ene koro molemele wale Sambatemo wendo olemo kinie kopisilimele liemo kapola na Sambate walemo kinie ye te tepo konde lirindumunge na kinie nambemuna mumindili kolemeleye? ⸤Sambate walemo kinie kango tenga kangi te kopisiku wendo likulie ‘Papu tekemolo.’ níngi liemo Sambate walemo kinie nane ye tenga kangi pali tepo konde lio akumu papula telio.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Enene mongone kanolemele uluma kanokolie sumbi siku ‘Imu sike. Imu kolo.’ ningu naa piliengi! Uluma mimi siku kanoko konopuni pilkulie sumbi siku apuruku konjengi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yu aku sipe nimbe molopili Jerusalleme moloringi yambo marene ene eneno walsiku pilkulie ningindu: “I yemo ‘Topo konjemili.’ ningu molemele yemo naa molemoye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nakolo kaname. Yambo aisili molemelena yu mona omba angilipe ungu mane sikimu nakolo ye ailimene yu ulu te naa tekemele. Enene ‘Yu sike Pulu Yemone ‘Olio nokopa konjimbe ye te lipu mundumbu.’ nirimu ye nomi Kirasimu.’ ningu pilkimilinje? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nakolo olione i yemonga pulu koleamo kanolemolo. Pulu Yemone lipe mundumbe ye nomi Kirasimu ombá kinie yambo tene yu molopa ombá koleamo naa kanopa imbi simbe.”* niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kanu kinie Yesusi, ou ulke tembelena ungu mane sipe molorumu mele we sipe molopalie, ru nimbelie nimbendo: “Sike enene na kanoko imbi siku, na molopo ondu koleamo kanolemeleye? Na nanu konopuni pilipulie naa orundu. Na lipe mundurumuna orundu yemo yu kinie sike ulu pulumu pelemo yemo. Kanu yemo ene naa pilimele ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nakolo na yu pea molopolie, yuni na lipe mundurumuna orundu akumunge nane yu kanopo imbi silio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aku nirimuna pilkulie yu ambolko liku ka singí teringi nakolo yu tonge walemo ou wendo naa orumuna yambo tene yu naa ambolorumu.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yambo aisilini aku tenge teringi nakolo yambo aisilini ningindu: “Pulu Yemone ‘Lipu mundumbu.’ nimbe mako torumu ye nomi Kirasimu* ombalie nimbemone, i yemone yu molemo mele lipe ora silimo ulu tondoloma** telemo mele kanu yemone ulu tondolo olandopama manda tembaye? ‘Ye nomi Kirasimuni temba.’ nimbu pilimolo uluma i yemone telemo.” ningulie ‘Yu sike kanu yemo.’ ningu tondolo munduku piliringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yambomane aku sipe Yesusi molorumu mele aku siku anju yando olo toko kerepali niringi mele Juda ye aili Parisimene pilkulie niringimuni, ene kinie Pulu Yemo popo tonjiringi ye ailime kinie enene* ulke tembele ele ye mare “Yesusi puku ka sipai!” ningu liku munduringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kanu kinie Yesusini nimbendo: “Layekolo mindi ene kinie molopolie, pe na lipe mundurumu yemo molemona kelepo pumbu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pe enene na koronge nakolo naa kanoko, molombona manda naa onge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda ye ailimene eneno anju yando kerepali ningulie ningindu: “Yu tena pumbena olio manda yu naa pupu kanomoloye? Aku liemo olionga Juda yambo mare ou kolea lupemanga puringi molemele koleamanga pupe yambo talape lupema* ungu mane sipe molombana naa kanomolonje? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yuni ou nimbendo: “Na koronge nakolo enene na naa kanonge. Na molombona ene manda naa onge.” nimu kanumu ungu pulumu nambolkanje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pe, yamboma Jerusalleme ongo maku toko kake teli walemanga* uluma teringi walema pora nimbéndo wale ailimu wendo orumu kinie Yesusi ola angilipelie tondolo mundupelie nimbendo: “Yambo te no waka kolomu liemo na moliona omba no nopili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na molio nilio mele “Sike.” ningu tondolo munduku pilingí* yamboma enenga konopumanga konde molopa mindi puli noma pikipe wendo ombá.** Pulu Yemonga bokuna ungu te aku sipe nimbe molemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yuni ungu nirimumunge pulumu i sipe: “Yu Pulu Yemone sike lipe mundurumu, olio lipe taponjimbe yemo molemo.” ningu tondolo munduku pilingí yamboma pe walse Pulu Yemonga Minimu enenga konopumanga omba molomba lingímundu nirimu. Yesusi ou kolopa lomboropa ola molopa mulu koleana kelepa olando naa purumuna Minimu ou naa oli. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yambomane Yesusini ungu nirimuma pilkulie, marene ningindu: “I yemo Mosisini ‘Pulu Yemonga ungu umbu tonjimbema pilipe yamboma nimbe simbe ye te ombá.’ nirimumu* i yemo lemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Marene ningindu: “Yu Pulu Yemone ‘olio nokopa konjimbe lipu mundumbu.’ nimbe mako torumu ye nomi Kirasimu.” niringi. Marene ningindu: “Pulu Yemone lipe mundumbe ye nomi Kirasimu kolea Gallilli disiriki molopalie ombáye? Yu Gallilli naa menge. Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemone lipe mundumbe ye nomi Kirasimu ye nomi kingi Depisini kalopa limbe. Depisi yu meringi Betellieme taono akuna ye nomi Kirasimu menge.’ nilimo* kanumunge yu Gallilli disiriki manda naa menge lemo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aku siku yamboma Yesusi molorumu mele kerepali ningu konopu lupe lupe leringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yambo marene ‘Yesusi ka siemili.’ konopu lelko moloringi nakolo tene yu pupe ambolopa naa lirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ulke tembele ele yema Yesusi kinie yamboma kinie ningu moloringi mele pilku molkolie, pe we kelko yando ongo Pulu Yemo popo tonjiringi ye ailime kinie Parisi yema kinie moloringine puringi. Yesusi ka siku naa mengo oringine kanokolie enene ele yemando ningindu: “Yemo nambemuna naa mengo ongiye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ele yemane ningindu: “Molo. Ye tene ou ungu mane silimele mele yuni aku sipe naa simu. Yuni ungu mane paa olandopa simu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisimene pilku keri pilkulie ningindu: “Yuni kolo topa ungu nimuma ‘Sike nimu.’ konopu lelko ene we kelko yando ongiye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Olionga ye ailime kinie Parisi yema kinie olionga ye tene “Yu molemo nilimo mele sike akumu molemo.” nimbe pilimuye? ⸤Molo, tene aku sipe naa nimbe pilimu kanumu.⸥* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nakolo we yambo maku toko molongime Mosisini ungu mane sirimu pelemoma paa naa pilimele. Pulu Yemone enenga kotemo koronga pilipe, kolonge kinie ‘Mindili nangi.’ nimbe panjirimu.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimasi, yu ou walse Yesusi molorumuna purumu ye kanumu,* Parisi ye kanumanga te yu, yuni ene walsipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Olionga ungu manemane ‘Yambo te kote naa pilkulie we mongo liku siei.’ nilimoye? Yu ou kotena ombalie nilimo mele pilipulie pe ungu nilimomanga puluma apurupu pilimolo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Parisi yemane yundu pundu toko ningindu: “Aku nu kepe kolea Gallilli ye teye? Pulu Yemonga bokuna sukundu mimi siku kanani. Mimi siku kanokolie, ‘Pulu Yemone ungu umbu tonjilime pilipe yando nimbe simbe ye te Gallilli wendo ombá.’ nimbe pelemo kanoniye?” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yamboma pali ulkendo bulu balu ningu puringi ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","nakolo Yesusi ma pangi te ‘Ma Pangi Unju Ollipi Ponie’ nili akuna olando purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kanu kinie kolea tangorumu kinie ipulueli ou yu kelepa ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena purumu kinie yamboma yu molorumuna ongo maku toko moloringi kinie ene ungu mane simbendo yu manie molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kanu kinie Pulu Yemonga ungu manemanga puluma pilku mane siringi yema kinie* Parisi yema kinie** enene ambo ye puli te ye te kinie wa ulu kerinele teringilimu liku mengo ongo yamboma moloringi kumbikerena ongo anjikulie, ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesusindu ningindu: “Ungu Mane Silimu, i ambo ye pulimu ye te kinie wa ulu kerinele teko molongili yambomane kanongine membo okomolo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosisini ungu mane te sipe panjipelie nimbendo: “Ambo aku tembamo kouni toko konjei.” nirimu* kene nuni nambolka niniye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nakolo enene sike pilingindu naa niringi. ‘Yuni nambolka nimbenje? Nimbe kenjimbe kinie kote tenjimulú.’ ningu aku siku walsiringi.* Nakolo Yesusi ma kanopa kimuni mana ⸤we⸥ imbi topa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kanu kinie yu alieli walsi pu opu teringine olando sipe kanopalie enendo nimbendo: “Enenga ye te ulu pulu keri te naa pelemo ye tene i ambomo kumbi lepa kouni topili.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aku nimbelie yu kelepa ma kanopa mana we imbi topa molorumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aku nirimuna pilkulie ye ailime ene te talo ningu pena pena puku Yesusi munduku kelko ene puringi. Ye ailimenga ye nomime ou kumbi lelko puringi kinie we ye ailime akiliku puringi kanu kinie ye aili te Yesusi kinie naa molopa yuyu molopa, ambomo yu molorumuna we angilirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kanu kinie Yesusi olando sipe kanopalie ambomo walsipelie nimbendo: “Ambomo, yema tena molemeleye? Ye tene nu ‘Teko kenjinumunge kote tenjembo.’ naa nimuye?” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ambomone nimbendo: “Ailimu, tene na kote naa tenjimbe tekemo.” nirimu. Yesusini nimbendo: “Nane kepe ‘Nuni teko kenjinumunge mongo lieni.’ naa nikiru kene nu pukulie ulu pulu keri teleno mele munduku kelko altoko naa tei!” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yambo moloringimendo Yesusini kelepa nimbendo: “Na ma koleamanga pali yambomanga pa tenjilimu.* Na andopo molombona lombili andoko molonge yamboma sumbulu toline naa andoko molonge. Konde mololi ulu pulumu silimo pa telimu kinie molonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aku nirimuna ye aili Parisimene* pilkulie yu karaye tekolie ningindu: “Nu moleno mele nunu ningu silino kene nuni ungu nikinuma pilipulie ‘Sike nikimu.’ nimbu pilimelkanje manda naa telka.” niringi.** ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusini pundu topa nimbendo: “Na ou molopo orundu koleamo kinie kelepo pumbu tekero koleamo kinie pilipu moliomonga na molio mele sike nanu nilio nakolo nane i ungu nikirumu sike ungumu. Nakolo na molopo orundu koleamo kepe pe pumbu tekero koleamo kepe ene naa pilkimili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mana yambomane pilku apuruku telemele mele ene Parisi yemane aku siku pilkulie apurulimele, nakolo nane yambo te naa apurulio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nakolo nane sike pilipu apurulkenje na nanu manjipu naa apurulkemonga sumbi sipu apurulke. Na lipe mundurumu ye Tara kinie pea tapu topo molembolomonga sumbi sipu pilipu apurulke. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enenga ungu mane te bokuna molemo kanumu i sipe: ‘Yambo talone ungu te ningu síngili liemo ‘Aku ungumu sike.’ niengi.’ aku sipe nimbe pelemo.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Akumunge na molio mele nanu nimbu silio kepe; na lipe mundurumu ye Tarane na molio mele nimbe silimola.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kanu kinie enene walsikulie ningindu: “Lanie tena molemoye?”* niringi. Yesusini pundu topa nimbendo: “Enene na kepe nanga Lapamo kepe naa kanoko imbi silimele. Enene na kanoko imbi silimelkanje Tara kepe kanoko imbi silimelka.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesusi ulke tembelena sukundu, Pulu Yemonga ningu yambomane kou mone siringi unju ketema lerimu koleana molopa yamboma ungu mane sipe molopalie i unguma nirimu. Nakolo yunge walemo* wendo naa orumuna yambo tene yu ambolko liku ka naa siringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesusini altopa Juda ye ailimendo nimbendo: “Na kinie pumbu tekero, kanu kinie enene na koroko kelkolie enenga ulu pulu kerime konopuna pepili kolonge. Na pumbu koleana ene manda naa onge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aku nirimuna pilkulie Juda ye ailimene eneno kerepali ningu walsikulie ningindu: “Aku nambemuna ‘Na pumbu koleana ene manda naa onge.’ nikimuye? Aku liemo yu yuyu topa konjimbenje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesusini kelepa nimbendo: “Ene manie yamboma, na ola yemo. Ene ma kolea pulu yamboma, na ma kolea pulu ye te molo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nane enendo ou nimbundu: “Ulu pulu kerime konopuna we pepili kolonge.” nindu kanumu. Akumu “Na kinié molio ou pulu pulu molorundu pe molopo mindi pumbu yemo.” nimbu silio mele enene ‘Sike akumu molemo.’* ningu tondolo munduku naa pilíngi liemo pe ene kolonge kinie sike enenga ulu pulu kerime konopuna we pepili kolonge.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Parisi yemane yu walsikulie ningindu: “Nu naeye?” niringi. Yesusini pundu topa nimbendo: “Na molio mele ene alieli nimbu silio kanumu na mindi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nane ene molko ulu telemele mele pilipu apurupulie enene teko kenjilimele mele ungu aisili nimbu silke nakolo nanu konopuni pilipulie unguma naa nilio. Na lipe mundurumu yemo, yu ulu sikema mindi tepa ungu sikema mindi nilimo ye, kanumuni nilimo mele mindi pilipulie mana yamboma nimbu silio.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yuni Lapando nirimu nakolo ene yuni nirimu mele pulumu naa piliringine ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesusini enendo nimbendo: “Pe enene Manie Omba Mana Ye Au Lerimu Yemo ola uku toko panjingí kinie* enene pilkulie “Na kinie molio ou pulu pulu molorundu pe molopo mindi pumbu yemo.” nimbu silio mele enene ‘Sike akumu molemo.’** ningu pilkulie kepe, “Na nanu konopuni pilipulie naa telio.*** Tarane na mane silimo mele mindi pilipulie nilio.” alieli nimbu silio ‘Akumu sike lemo.’ ningu pilingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na lipe mundurumuna orundu yemo na kinie pea tapu topo molembolo; alieli yu kanopa peanga kanolemo uluma mindi teliomonga yuni walsikale kepe na mundupe naa kelemo.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yuni aku sipe nimbe molopili kepe yambo aisili ‘Yesusi yu Pulu Yemone sike lipe mundurumu.’ ningu tondolo munduku piliringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","‘Yu sike.’ ningu piliringi Juda yambomando Yesusini nimbendo: “Nane ungu mane silioma sike pilku liku tenge panjiku molongi liemo ene sike nanga lombili andolime molonge.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aku tekolie, enene sike ungumu pilingí kinie ene ka silimo melema sike ungumuni wendo linjipe ‘ene we molko konjengi.’ nimbé.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Enene pundu toko yundu ningindu: “Olio Eporayamone kalopa lirimu yamboma molopo, yambo tenga ka kongono te naa tenjipu molorumulu.* Aku liemo nuni ‘Ka silimo melema wendo pumbe olio molko konjingí.’ ninu kanumu nambe teko pilkulie ninuye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesusini pundu topalie nimbendo: “Nane ene paa sike nimbu sikirumu: Yambo ulu pulu keri telemelema ulu pulu kerimene ka silimo kinie aku ulu pulu kerimenga ka kongono telemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ka kongono telemo kendemandemo ulke pulu yamboma kinie pea kamu naa molemo, nakolo ambolango te yunge ulke pulu yamboma kinie alieli teluna tapu toko molemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Akumunge ⸤Ulke Pulu Yemonga⸥ Malone ‘Ene ka silimo melema mundupe kelepili, ene we molko konjengi.’ nimu liemo meltene sike ka naa simbe, we paa sike molko konjingí. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","‘Ene Eporayamone kalopa lirimu yamboma molemele.’ na pilipu molio nakolo enenga konopuna nanga ungumu naa pelemomonga na toko konjingí tekemele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nane Tara kinie molopolie kanorundu mele ene nimbu silio. Enene enenga laniene nilimo mele pilkulie telemele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesusini yambomando “Ene lanienga ungumu pilkulie telemele.” nirimu kinie pilkulie Juda yambomane pundu toko ningindu: “Olionga lapa kalopa lirimumu Eporayamo.”* niringi. Yesusini nimbendo: “Molo. Ene sike Eporayamone kalopa lirimu yamboma molemelkanje Eporayamone terimu mele ene aku siku telemelka. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nakolo aku naa telemele. Pulu Yemone na nimbe sirimu unguma na pilirindu ungu sikema ene nimbu silio yemo toko konjingí tekemele. Eporayamone aku sipe naa terimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ene enenga laniene telemo mele manda lelko telemele.” nirimu. Enene tondolo karaye tekolie ningindu: “Olionga anumu ye te lupe kinie wapora topalie olio naa merimu. Olionga lapa kanumu Pulu Yemo telu mindi.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesusini enendo nimbendo: “Na Pulu Yemo kinie molopolie orundu ya moliomonga Pulu Yemo yu sike enenga Lapa lelkanje enene na konopu monjilimelka. Na nanu konopuni pilipulie naa orundu. Yuni na lipe mundurumuna orundu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nane ungu niliomanga pulumu nambemuna sumbi siku naa pilimeleye? ‘Ungu pulumu naa pilimolo.’ ningu liku su silimele akumunge nanga ungumu ene naa pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ene Depelemonga* ambolangoma, Setene enenga lapamo. Laniene kanopa peanga kanolemo mele ‘teamili.’ ningulie yuni “Ene teai.” nilimo mele ‘Paa teamili.’ nilimele. Ou pulu pulu mulu matolo kokele wendo orumu kinie yu yambo topa konjili yemo molorumu mele aku silimu yandopa kinié we molemo. Yu sike ungu pulu te naa perimuna sike ungu te walsikale kepe paa naa nirimu. Yu kolo tolemo yemo; yu sike kolo toli ungumunge pulu yemo molemomonga ou yu kolo torumu mele yandopa kinié kepe pe kepe kolo mindi tolemo tomba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nakolo nane ungu sikema nimbu siliomonga ene naa pilku ‘Kolo tolemo.’ ningu pilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Naene nanga konopuna ulu pulu keri telu kepe pelemo manda lipe ora simbeye? Te naa pelemo nakolo nane ungu sikemo nindu liemo ‘Sike nikimu.’ ningu ene nambemuna naa pilimeleye? ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pulu Yemonga ambolangomane Pulu Yemone nilimo ungumu pilku limele. Ene Pulu Yemonga ambolangoma naa molkolie* yunge ungumu nane nimbu silioma “Naa pilimulú.” ningu naa pilku limele.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda ye ailimene* yundu pundu toko ningindu: “ “Nu Sameria ye te moleno, nunge konopuna kuru te molemo.” nilimolo kanumu sike nilimolo.” niringi. ⸤Juda yambomane Sameria yamboma kinie konopu keri panjiringi kanumunge** yu iri toko ungu taka tonjiku “Yu ye keri te.” ningindu “Nu Sameria ye te.” niringi.⸥ ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Niringi mele pilipelie Yesusini pundu topa enendo nimbendo: “Nanga konopuna kuru te naa molemo. Nane Taranga imbi ola linjilio, nakolo enene nanga imbi teko kenjinjilimele. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nanu ‘Imbi ola molopili.’ naa nilio, nakolo ye te molemo akumuni ‘Na imbi ola molopili.’ nimbe nanga imbi ambolopa ola linjilimo. Kanu yemone nane nilio mele kepe enene nilimele mele kepe mimi sipe pilipe apurupe tene ‘Sike nikimu.’ nimbe pilipe molemo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nane enendo paa sike nimbu sikirumu: Yambo te nanga ungumu pilipe lipe tepa molomba yambomo paa kamu naa kolopa molopa mindi pumbe.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda ye ailimene yundu ningindu: “Kinié olio pilkimulu, kuru te paa sike nunge konopuna molemo lemo. Anda kolepa Eporayamo kolorumu;* Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yema** koloringila. Nakolo nuni ninindu: “Nanga ungumu pilipe lipe molomba yambomo kamu naa kolomba.” nikinu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eporayamonga imbi manie mele molopa nunge imbi ola molemoye? Yunge imbi paa ola, nakolo yu kepe kolorumula. Pulu Yemone ungu umbu tonjirimuma pilku yamboma ningu siringi yamboma kepe imbi ola molorumu nakolo koloringila. Nunge imbimu ola enenga imbime manieye? Paa molo! Nu koropamo.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesusini pundu topa nimbendo: “Nane nanga imbi nanu ambolopo ola lilkenje na imbi paa sike ola naa molka, na we mindi nilke. Nakolo akumu molo. Tara, yundu enene “Olionga Pulu Yemo.” nilimele kanumuni nanga imbi ambolopa ola linjilimo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Enene yu naa kanoko naa pilimele nakolo nane yu kanopo pilio. Nane “Yu naa kanopo naa pilio.” nilkenje ene kolo tolime molemele mele na aku sipu molka. Nakolo nane yu paa sike kanopo pilipu, yunge ungumu pilipu lipu tepo molio. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Enenga anda kolepa Eporayamone na mana manie ombó walemo kanomba pilipelie konopu sipe molorumu. Kanu walemo kamu kanopalie konopu sirimu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kanu kinie Juda ye ailimene yundu ningindu: “Nunge ponie tokapu talo ou naa pora nili. Nu kango yemo mindi. Pe nu “Eporayamo kanorundu.” nikinuye? Nuni yu manda naa kanorunu. Kolo tokono.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesusini enendo nimbendo: “Nane enendo paa sike nimbu sikirumu: Eporayamo sike paa koronga ou molopa kolorumu nakolo yu ou naa molopili na molorundu.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aku nirimuna pilkulie enene “Yu topo konjemili.” ningu kou liku yu tonge teringi. Nakolo Yesusi lopi tepalie, ulke tembelena kiyongo nimbe omba ulsu purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesusi aulkena pumbe purumu kinie mongo keri lerimu ye te molorumu kanorumu. Anumuni olona sukundu mongo keri lelimu merimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pe yu lombili andoli yemane yu walsikulie ningindu: “Rapai,* naene ulu pulu keri terimumunge i yemonga anumuni yu olona sukundu mongo keri lelimu merimuye? Yemo yuyu terimu molo anumu lapatolone teringiliye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesusini nimbendo: “Yemo yuni kepe anumu lapatolone kepe ulu pulu keri te teringine yu mongo keri naa lerimu. ‘Pulu Yemonga ulu tondolo te i yemo kinie mona wendo opili yamboma pali kanangi.’ nimbe i yemo mongo keri lerimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I walemo pora naa nimbe ena ou naa pupili na lipe mundurumu yemonga kongono paa temolo. Ipu lemba kinie yambo tene manda kongono naa temba. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na i ma koleana molopolie, na ma koleana yambomanga pa tenjilimu molio.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aku nimbelie yu mana lkambe topalie mamo kinie ambolopa topele mapele topalie yemonga mongotolonga kanjipelie nimbendo: ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Nu no mongo Silloamo puku kumbikerena no lepui.” nirimu. (Silloamonga ungu pulumu ‘lipe munduli’.) Yu akuna pupe kumbikerena no lerimu kinie mongotolo peanga lerimu, melema kanolipe ulkendo purumu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kanu kinie yunge kolea yamboma kinie “Yu kou mone siei.” nimbe ou aulkena mawa tepa molorumu kanoringi yamboma kinie yu aku sipe orumu kanokolie enene eneno anju yando kerepali ningu walsikulie ningindu: “I yemo ou “Kou mone siei.” nimbe mawa tepa molorumu kanu yemonje?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Marene ningindu: “Sike, yu aku yemo mindi.” niringi. Marene ningindu: “Molo. Elte kumbikere telu sipe nakolo i yemo lupe.” niringi. Nakolo yemo yuyu tondolo mundupelie nimbendo: “Ye kanumu na mindi.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Enene pundu tokolie ningindu: “Nunge mongotolo nambe tenu kinie peanga lemuye?” niringi kinie ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","yuni pundu topa nimbendo: “Ye te ‘Yesusi’ nilimele kanumuni olí lipe mongotolonga ape kanjipelie nimbendo: “No mongo Silloamo puku kumbikerena no lepui.” nimu kinie pupu kumbikerena no lepundu kinie nanga mongotolo peanga lemuna kolea kanondu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Aku yemo tena molemoye?” niringi kinie “Na naa kanondu.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ye ou mongo keri lerimumu yambomane Parisi yema* moloringine mengo puringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kanu kinie, Yesusini le olí lipe yemonga mongotolonga ape kanjipelie yemonga mongotolo ‘altopa peanga lepili.’ nirimu kanu walemo ⸤Juda yamboma koro moloringi⸥ wale Sambate kinie* terimu, ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","akumunge Parisi yemane kepe yu walsikulie ningindu: “Nunge mongotolo nambe tepa peanga lemuye?” niringi. Yemone pundu topa nimbendo: “Nanga mongotolonga oli ape kanjimu kinie na kumbikerena no lepolie kinie na mongone kanokoro.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi ye marene ningindu: “I yemo Sambate walemo naa pilipe we andolemo, aku sipe ulu pulu keri telemomonga Pulu Yemone yu naa lipe mundurumu lemo.”* niringi. Nakolo marene ningindu: “Pulu Yemone lipe taponjimbe kinie mindi yambo tene i ulu tondoloma mele manda temba** aku sipe mele ye ulu pulu keri telemo tene manda telkaye?” niringi. Akumunge ene anju yando kerepali ningu konopu teluna pupili naa moloringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Akumunge mongo ou keri lerimu yemo altoko walsikulie ningindu: “Kanu yemone nunge mongomo tepa peanga tenjimu akumunge yundu nu nambolka konopu lekenoye?” niringi. Yemone pundu topalie nimbendo: “Yu Pulu Yemone ungu umbu tonjilimoma pilipe yamboma nimbe silimo ye te.”* nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nakolo Juda ye ailimene* “‘I yemo ou yunge mongomo paa sike keri lerimu, pe kinié peanga lemu.’ nimbu ‘sike lemo.’ we naa nimulú. Yu olio kanopo imbi naa silimolo kene anumu lapatolo walsipu piliemili wale.” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kanu kinie anumu lapatolo oringili kinie walsikulie ningindu: “I yemo eltenga marenaye? “Anumuni merimu kinie mongomo keri lerimu.” nilimbele kanu yemo imuye? Aku liemo kinié nambe tepa mongone kanolemoye?” niringi. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Anumu lapatolone pundu tokolo ningilindu: “Yu sike oltonga malo, anumuni merimu kinie yunge mongomo keri lelimu merimu yemo olto kanokombolo. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nakolo kinie yunge mongotolo peanga lemumu nambe tepa temunje olto naa kanombulu. Yu naene mongotolo tepa peanga tenjimunje akumu olto naa la kanombulu. Yu yemo molemo kene yu temu mele yuyu nimbe sipili yu walsiku piliei.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anumu lapatolo Juda ye ailime pipili kolkololie aku siku niringili. Juda ye ailimene ou ningu panjikulie ningindu: “Yambo tene ‘Yesusi yu sike Pulu Yemone lipe mundurumu ye nomi Kirasimu.’ nimu liemo aku yambomo ulke maku topo Pulu Yemonga ungumu pilimolo ulkemanga naa opili kamu makoromolo.” niringimunge aku siku niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ou ye ailimene aku siku ningu panjiringimu anumu lapatolo pilkululie “Yu yemo kene yuyu nipili walsiku piliei.” niringili. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Juda ye ailimene kelko talo siku ou mongo keri lerimu yemo “Oi.” ningulie yundu ningindu: “Nuni ‘Pulu Yemo pilipe molemo.’ ningu kolo naa toko, nu temu mele sumbi siku olio piliemili ningu si! ⸤Olio Pulu Yemonga ungumu mimi sipu pilimolo yemane pilkimulu,⸥ ‘ ‘Nunge mongo tepa peanga tenjimu.’ nikinu yemo yu ulu pulu keri teli yemo.’ nimbu pilkimulu.” niringi.* ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yuni enendo pundu topa nimbendo: “Na mongo tepa peanga tenjimu yemo ulu pulu keri teli yemo molo molonje, na naa pilkiru. Nakolo ulu te na paa sike pilkiru. Ou nanga mongotolo paa sike keri lerimu nakolo kinie nanga mongotolo peanga lemuna kolea kanokoro, akumu na paa pilkiru.” nirimu. ");
INSERT INTO ubu_nopenge_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kanu kinie enene yu walsiku pilkulie ningindu: “Yuni n