﻿USE sofia;
DROP TABLE IF EXISTS sofia.ubu_kala_vpl;
CREATE TABLE ubu_kala_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ubu_kala_vpl WRITE;
INSERT INTO ubu_kala_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","⸤Isirele yembomanga ou pulu pulu anda kolepa⸥ Eporayamo kinie pe yandopa ⸤enonga ye nomi kingi awili⸥ Depisi kinie elone Yesusi Kirasi kalko lsingili mele isipe: ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eporayamone Aisake merimu; Aisakene Jekopo merimu; Jekopone Juda kinie Judanga angenupilime kinie merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judane Peresi kinie Sera kinie merimu, kanu yeselonga anumu Tema; Peresini Esirono merimu; Esironone Ramo merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramone Aminadape merimu; Aminadapene Nasono merimu; Nasonone Sallimono merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sallimonone Boasi merimu, Boasi yunge anumu Reapa; Boasini Opete merimu, Opete yunge anumu Rute; Opetene Jesi merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesini ye nomi kingi Depisi merimu. Depisini Sollomono merimu. Sollomononga anumu ou Yurayanga ambo menumu molorumu. Pe Depisini kanu ambomo konopu mondopa Yuraya topa kondopa ambomo yu lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sollomonone Riapoamo merimu; Riapoamone Apaya merimu; Apayane Eta merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Etane Josipate merimu; Josipatene Joramo merimu; Joramone Asaya merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asayane Jotamo merimu; Jotamone Eyasi merimu; Eyasini Esikaya merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esikayane Manasa merimu; Manasane Emosi merimu; Emosini Josaya merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josayane Jekonaya kinie yunge angenupilime kinie merimu. Josaya kolopili yunge malopili molangi opa pulue yemboma Isirele yemboma kinie ongo opa tekolie toko munduku Isirele yembo awisili ka siku enonga kolea awili Bepillono mengo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka siku mengo puringi kinie pe Jekonayane Sialtele merimu; Sialtelene Serapapele merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serapapelene Apayate merimu; Apayatene Ellayakimu merimu; Ellayakimuni Eso merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esone Sedoke merimu; Sedokene Ekimu merimu; Ekimuni Ellayate merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ellayatene Elliesa merimu; Elliesane Matano merimu; Matanone Jekopo merimu; ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopone Josepo merimu. Josepo Maria menu. Josepone Maria ou naa lipili Maria yu ambolango olona mondopa molorumu. Pe ambo yeselo moloringili kinie Mariane Yesusi merimu. ⸤Pulu Yemone “Eno nokopa kondomba ye nomi te lipu mundumbo.” ou nimbe mako torumu yemo pe Yesusi aku yemo omba molorumu kulu⸥ yunge imbi te pea sikulie ‘Kirasimu’. niringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eporayamo kinie Eporayamone yandopa yandopa kalopa lipe Depisi kalopa lipe terimu yema ⸤Yesusinge⸥ anda kolepa tene-po on moloringi. Pe Depisini yandopa yandopa ou Bepillono yembomane Juda yembo mare ka siku Bepillono anjo naa mengo pangi anda kolepa tene-pola moloringi. Bepillono ka siku mengo puringi kinie pe yandopa ye nomi Kirasimu kinie kalko lsingi ye tene-pola moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesusi, Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu, yu meringi temanemo isipe: Yunge anumu Marianga pulu lierimu yembomane “Maria Josepone lipili.” ningu koronga niringi nalo ou Josepo pea telune naa peangili Mini Kake Telimuni Maria yunge olona ambolango te mondondorumumu Maria yuyu pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kanu kinie yunge ye Josepo yu ye sumbi nilimu molorumu kulu Maria ambolango mondorumu kinie pilipelie ‘Maria olie naa polopili.’ nimbe ‘Yembo awisili molangi yu temu mele nimbu para naa sipu yu yuyu molomba kinie kiyengo nimbu we “Kamu pu.” niembo.’ konopu lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josepo aku sipe konopu lipe mundupe molopili Awilimunge angello tene Josepo uru kumbu sipelie nimbendo: “Josepo, ye nomi kingi Depisini kolopa lsimu yemo, Mini Kake Telimuni Maria ulu te terimu kulu yu ambolangomo olana mondolemo kene yu linindu pipili naa kolko li.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","“Yu kango kanopa limbe. Kanu kangomone yunge yemboma ‘Enonga konopune ulu pulu keri telemelema pepili molkolie mindili nonge.’ nimbe eno lipe tapondopa, mindili nolemela aulkena wendo lipe, yu-kinie pea molko kondonge aulkena lipe mondomba kene yunge imbi leko “Yesusi”. nieni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aku sipe wendo orumu ulumenga pali koronga ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye tene ulu mare pe wendo ombá ou nirimu mele kamu wendo orumu. Akumu isipe: ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pilieyo. Ambo wenepo tene ambolango olona mondopalie kango te memba. Kanu kinie yunge imbi leko “I menuele” ninge.”. nirimu. I imbimunge ungu pulumu ‘Pulu Yemo olio-kinie molemo’. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josepo uru pepa makilipelie Awilimunge angellomone nirimu mele pilipe lipe tepalie ambomo lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nalo yu ambolangomo ou naa mepili “Telune naa peambili.” nirimu. Pe Mariane kango te merimu kinie Josepo yuni yunge imbi lepa “Yesusi” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erote kolea Judia disiriki yembomanga ye nomi kingi molopili Mariane kolea Judia, Betellieme taonona Yesusi merimu. Kanu walemanga ena wendo oli koleana pilipe konginjeli peli ye pokore alieli ‘Ulu mare wendo okomonje piliemili.’ ningu kombukandipime mimi siku kanoko moloringime kolea awili Jerusalleme ongolie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda yembomanga ye nomi kingi molomba kango meringimu tena molemoye? Olio ena wendo olemo koleana molopolie ye te ye nomi kingi molomba meringimu lipe ora sili kombukandipi te pulu pulu wendo omba angilierimu kanopolie nirimulumuni, yu popo topo imbi lipu ola mundundumolondo okomolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ye nomi kingi Erote iungumu pilipelie ‘Ye te yu kolo wangopa kingi molomba lepamo.’ nimbe pilipelie yu mini-wale mundupe, Jerusalleme yemboma pali mini-walela mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanu kinie yuni Juda yembomanga Pulu Yemo popo tondoringi ye awilime pali kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema pali kinie “Sukundu waa.” nimbelie eno walsipe pilipelie nimbendo: “Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu ye nomi Kirasimu tena mengemondo niringiye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Enone yundu ningendo: “Kolea Judia sukundu Betellieme taonona yu menge. Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye ⸤Maikane⸥ pe aku sipe wendo ombamondo ou nimbe boku torumu akune molemo kanumu. Yuni nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betellieme, kolea Juda lemo kolea te, yu kolea Juda sukundu kolea awilimenga yu kolea manie te molo. Yunge sukundu ye nomi awili te wendo ombá, akumuni nanga Isirele yembomanga sipisipi tapu yemo molopa eno nokomba.”. nirimu kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kanu kinie yembo lupema naa kanoko naa pilku molangi Erotene pilipe konginjeli peli yema “Waa.” nimbe kombukandipimu pulu pulu wendo omba angilierimu walemo walsipe pilipelie nirimumuni, yundu ningu siringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","pilipelie enondo nimbendo: “Eno Betellieme puku kangomo wamoko koro-payo! Kanoko lendekolie na ongo ningu sieyo. Na kepe yu ombo popo topo imbi lipu ola mundundembo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kingimuni aku sipe nirimu pilkulie eno kelko puku kano-poringi. Kanu kinie ena wendo oli koleana molkolie kombukandipi kanoringimu eno puringine kumbi lepa pumbe pupelie kangomo molorumu ulke imune pupe ola angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Enone kombukandipimu kanokolie konopu paa awili teko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ulkena sukundu pukulie kangomo kinie anumu Maria kinie moloringili puku kanoko lenderingi. Kanokolie kangomonga kumbikerena koporongo langoko ma kanokolie yu popo toko imbi liku ola mundundoringi. Mundundukulie eno wale peanga mengo oringime apisiku mele peangama wendo liku yu siringi. Kou gollo kinie, paura kalemele kinie mune paa toli paura te kinie, kopongo wele mune paa toli te kinie, aku melema yu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kanu kinie Pulu Yemone eno uru kumbu sipelie enondo nimbendo: “Eno Erote molemona kelko pu naa pangi, molo.” nirimu kinie pilkulie eno aulke tenga lupe ongolie lkondo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kanu kinie pilipe konginjeli peli yema kelko puringi kinie Awilimunge angello tene Josepo uru kumbu sipelie nimbendo: “Ye nomi kingi Erotene nondopa yunge ami yemando “Kangomo koroko toko kondo-paa!” nimbé kene nu ola molkolie kangomo kinie anumu kinie liku mengo kolea Isipindu kowa puku molo-payo. Ne anjo molkolie ningemone, pe nane “Kelko yando waa.” nimbo kinie wangi. Ou molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aku nirimu kinie pilipelie Josepo ola molopalie ipulueli anunguluselo lipe meli Isipindu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","‘Erote kolomba kinie kelepo ulkendo pumolo.’ ningu ou Isipi anjo moloringi. Aku teringimunge Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye tene ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Akumu isipe: “Pulu Yemone nimbendo: “Nanga kangomondo “Kolea Isipi munduku siye kolko wendo ou.” nirindu.” nirimu.”. nimbe kanu ye ⸤Osiane⸥ nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kanu kinie anumu lapaselo Yesusi pea Isipi puku molangi, pilipe konginjeli peli yemane Erote yu liku lou lenderingi Erote yuni pilipelie mumindili paa awili tepa kolorumu. Mumindili kolopalie ami ye marendo nimbendo: “Betellieme taono kinie Betellieme nondopa lemo koleamakinie kanumenga puku kango ponie talo omba puli kangoma kinie ponie talo naa pora nili kangoma kinie koroko toko kondo-paa!” nirimu. Kombukandipi kanoko pilipe konginjeli peli yemane kombukandipimu pulu polopa wendo omba angilierimu walemo yundu ningu siringi mele pilipelie ponie aku sipe nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aku sipe terimumunge koronga-ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Jeremayane ulu te pe wendo ombá ou nirimu mele wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yuni nimbendo: “Eno kolea Rama suku ungu te pilieringi; kola teringi pilku, yembo kolemele kinie kola telemele mele kola aku siku teringi pilieringi. Ambo Reselene yunge ambolangomanga kola terimu. Yu ‘Konopu pe nipili.’ ningulie teringi nalo yunge ambolangoma naa moloringi kulu yu kondo kolopa mindi molorumu.”. nimbe Jeremayane ou aku nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pe Erote kolorumu kinie Awilimunge angello tene Josepo Isipi molopili uru kumbu sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ “Kangomo toko kondangi koro-paa.” nirimu yemo kolorumu kene ola molko anumu maloselo liku mengo kolea Isirelendo kelko pu.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","pilipelie yu ola molopa anumu maloselo lipe memba Isirelendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nalo Akellesi yunge lapa Erote kolo wangopa ye nomi kingimu molopa kolea Judia disiriki nokorumu pilipelie Josepo yu kanune altopa pumbendo pipili kolorumu. Kanu kinie Pulu Yemone uru kumbu sipelie nimbendo: “Marena tongenje kene akune naa pu.” nimbe yundu liepi liepi torumu kinie yu kelepa kolea Gallilli disiriki pupe ");
INSERT INTO ubu_kala_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akune lierimu Nasarete taonona pupe molorumu kulu Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane ⸤Yesusi kinie⸥ ulu te pe wendo ombá ou niringi mele kamu wendo orumu. Enone ningendo: “Yembomane “Yu Nasarete taono ye te.” ninge.” niringi kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","⸤Yesusi Nasarete taonona we molopili⸥ No Lindeli Jono omba kolea Judia disiriki sukundu kolea ku lieline opa-ungu nimbelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pulu Yemo ye nomi kingimu molomba walemo nondopa wendo ombá tekemo kene enonga ulu pulu keri teringi konopune pelemoma munduku siye kolko konopu alowa teaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kanu yemo ⸤ou naa molopili paa koronga ou⸥ Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane Pulu Yemonga ungu te nimbe sipe boku torumu. Kanu ungumu isipe: “Kolea ku lieline yembo tenga kerena ungu te nimbendo: “Awilimu ombá aulkemo teko mimi tendaa. Yu ombá aulke kangama toko sumbi siee.” nikimu.”. nirimu. ⸤Aisayane Jonone paa pe temba mele ou aku sipe nimbe panjipe boku torumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jono yu kongi kemelenga indini teli wale te pakopa, kongi kilumuni teli kako te topalie, kuli-kumbe kinie pilimu-no kinie aku langiselo mindi nomba molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kanu kinie kolea awili Jerusalleme yemboma kinie Jerusalleme lierimu kolea Judia disiriki pali yemboma kinie kolea Jodane pali yemboma kinie kanu yemo molorumune pukulie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","no Jodane sukundu pukulie enone ulu pulu keri teringime ningu para siringi kinie yuni eno no linderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yuni ⸤Juda yembomanga ye awili⸥ Parisime kinie Sadusime kinie awisili no lingendo oringi kanopalie nirimumuni, eno iri topalie nimbendo: “Kolo topa yemboma tepa kenjeli wambiyemonga waloma, Pulu Yemo mumindili kolomba walemonga nawene “Eno talopa leko paa.” nimu kinie eno ‘Pulu Yemone naa tepa kenjepili.’ ningu ‘No liemili.’ ningu okomeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Eno sumbi siku molko, ulu peangama mindi teko molonge kinie eno ulu pulu keri teringime paa sike munduku siye kolko konopu alowa tenge mele mona lemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Olio anda kolepa Eporayamone kalopa lsimume molemolomonga yembo peangama molemolo.” ningu aku siku ningu naa pilieme. Nane eno nimbu sikiru: ‘Pulu Yemone ikoumendo “Eporayamone kalopa lsimu yemboma a leangi.” nilkenje koume Eporayamone kalopa lsimu yemboma molemela.’ nikiru. Eno Eporayamone kalopa lsimu yemboma molemelemonga uluri naa telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Unjo peke tomba loumu Pulu Yemone koronga unjo pulune ambolopa ola lipe molemo. Unjo mongo peanga naa tomba unjoma 0. Unjo kerime to yuni peke topalie tepena kalomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nane ulu pulu kerime siye kolko konopu alowa telemele yemboma sike no lindilio. Nalo te na akilipe ombámo yuni ⸤Pulu Yemonga⸥ Mini Kake Telimu kinie tepemo kinie eno lindimbe ⸤linge⸥.. Ina akilipe ombá yemo yunge tondolomo paa olandopa, nanga tondolomo paa maniendopa. Na yu-kinie manda molo. Yembo awilimenga kongono keri teli kendemande yembomane sike enonga awilimenga kongono keri tendengendo kimbu su wendo lindilimele nalo na akilipe ombámonga kimbu su wendo lindimbo kanu kongonomo paa olandopa mele nane tendembo kapola naa telka, ⸤na ye paa keri⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Yuni yunge rasi-witi apuroli apulu pokomo ambolopalie yunge rasi witi mongo kinie rasi witi kilu kinie apurumbendo molemo. Yunge rasi witi apuroli polomo tepa mimi tembando rasi witi pali ‘wendo liembo.’ nimbe apurupelie mongoma lipe rasi witi nosilimo mingine ‘Liepili.’ nimbe nosimbendo mingi topa, pe kilume lipe maku topa tepe naa kumbulupe nomba pepa mindi pulimona kalomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jonone yemboma no lindipe molopili Yesusi kolea Gallilli disiriki mundupe siye kolopalie nirimumuni, ‘Jonone na no lindepili.’ nimbe Jono no Jodane molorumune yu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Orumu kinie Jonone nimbendo: “Aku paa molo. Nane nu no nambepo lindembo ningu nikinuye? Nuni na no lindilinanje papu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nalo Yesusini topondopa nimbendo: “Molo. Ulu kake teli ulume pali kapola tepili kene nikiru mele tei.” nirimu. Kanu kinie Jonone “Kapola.” nimbe yu no linderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesusi no lipe pora sipelie nona sumbi sipe wendo orumu. Wendo ombá orumu kinie mulúmu kengeya lepa anjo yando purumu, Pulu Yemonga Minimu, kera waembono mele, manie omba Yesusi molorumune pupe kangine ola molorumu kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kanu kinie mulune ola ungu te wendo ombalie, “I nanga konopu mondolio kangomo. Yu-kinie konopu sipu molio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesusi ⸤no lsimu kinie Pulu Yemonga Minimu yu-kinie omba molopalie nirimumuni,⸥ Minimu yuni ‘⸤Kurumenga nomi⸥ depelemone yu kondi topili.’ nimbe Yesusi kolea ku lieline meli purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akune Yesusi oli te koro talo mele langi naa noli we molopa perimu kinie yu engelene kolopa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kanu kinie ⸤kuru⸥ kondi toli ⸤Setene⸥ ombalie yundu nimbendo: “Nu Pulu Yemonga Malo liemo ikoume ‘Pillawa kaloli a liepili.’ ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nalo yuni topondopa nimbendo: “Pulu Yemonga bokumuni nimbendo: ‘Langimene mindi yemboma konde mololi ulu pulumu naa silimo. Pulu Yemone ungu nilimoma pali pilku liku teko molonge kinie konde mololi ulu pulumu linge.’ nimbe molemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kanu kinie depelemone Yesusi lipe kolea awili Jerusalleme, akumundu ‘kolea awili kake teli’ nilimu, akune memba pupe Pulu Yemo popo toko kaloringi ulke tembelena memba, paa ola imune pupe anjipelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yundu nimbendo: “Nu Pulu Yemonga Malo liemo nu lipe tapondomba kene pou ningu manie pu.” ⸤nirimu.⸥ “Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemone yunge angellomane ‘Nu ongo nokangi.’ nimbé. Enone nu ‘Kou tene kepe naa topili.’ ningu nu enonga kimene oko polko linge.’ nimbe molemo kanumu. Aku sipe nirimu kene pilkulie aku siku tei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesusini yundu nimbendo: “Pulu Yemonga yembomando ungu te pea nimbe molemola. Akumu isipe: ‘Pulu Yemo enonga Awilimuni “Tembo.” nilimo mele ‘Sike nilimonje molo kolo tolemonje kanamili.’ ningu enone yu manda manjiku naa teangi.’ nimbe molemola kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Altopa depelemone yu lipe mulu te paa olandopa lierimune ola memba pupe anjipelie, yu ma koleama pali kinie koleamanga mele peangama pea lipe ora sipelie ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yundu nimbendo: “Nu nanga kumbikerena koporongo langoko manie molko na popo toko nanga imbi liku ola mundundonu liemo inu kanokono ma koleana lemo melema pali nu simbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kanu kinie Yesusini yundu nimbendo: “Setene, nu anjo pa! Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemo enonga Awilimu manjiku popo toko imbi liku ola mundunduku, yunge kongonoma manjiku tendeko molangi.’ nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kanu kinie depelemo Yesusi yu mundupe siye kolopa yu purumu. Purumu kinie mulu koleana angelloma ongo Yesusi nokoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kanu kinie ⸤No Lindeli⸥ Jono ka siku ka ulkena panjeringi kinie pilipelie Yesusi kelepa kolea Gallilli disirikindu yando omba ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasarete taonona ombalie nirimumuni, pe aku taonomo mundupe siye kolopa Kapeniame taono, nomu Gallilli kélona lierimu, akune pupe ‘Kinié ikoleamo nanga molombo kamu koleamo liepili.’ nimbe akune molorumu. Kapeniame ye Sepullano kinie Napatallaiselone kalko lsingili yemboma ou moloringi koleana lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","⸤Kapeniame taonona pupe molorumumunge⸥ koronga-ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Aisayane nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepullanone kalopa lsimu yemboma pelemele koleamo kinie, Napatallaine kalopa lsimu yemboma pelemele koleamo kinie, nomune pulimo aulkemo no Jodane nekendo lemo koleamo kinie, kolea Gallilli wikindu yembo lupe awisili molemele koleamo kinie, aku koleamanga molemele yemboma ⸤paa sumbulu toline molemele.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kanu yembo paa sumbulu toline molemelema pa tondolo paa awili tepa teli te kanoringi. Kololi ulu pulumu aki topa sumbulu tondolemo koleana pelemele yembomanga koleana pa tendekemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","⸤Kapeniame omba molorumu⸥ kanu walemonga Yesusini yemboma pulu polopa ungume nimbe sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa nokomba walemo nondopa wendo ombá tekemo kene ⸤‘Pulu Yemo yuni nokomba yembomanga talapena sukundu molamili.’ ningu⸥ ulu pulu keri telemelema munduku siye kolko konopu alowa teaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesusi Nomu Gallilli kélona andopalie angenungulu talo kanorumu, akuselo Saimono kinie angenu Enderuselo oma lili wale te nomune toko munduku moloringili kanorumu. Pe Saimononga imbi te Pita niringila. Oma lsingili akumu elonga kou-kongono teringili kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aku siku teko moloringili kanopalie nimbendo: “Na lombili wangili. Oma lingelendo oma lili wale te liku nona manie mundulimbele kinie omama walena omba pelemo mele, pe ‘nanga kongonomo tengelendo nanga ungumu pilkulu ningu siliku andongele kinie yemboma nanga talapena sukundu ongo molangi.’ nimbu ‘Elo na lombili wale.’ nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aku nirimu kinie pilkululie tamburumbu elonga oma lili walema munduku siye kolkololie Yesusi lombili puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kanu kinie yu laye kolte welto pupelie angenungulu talo lupe kanorumu, akuselo Seperi malo Jemisi kinie Jemisi angenu Jonoselo, lapa Seperi kinie enonga nona andoli sipine sukundu oma lili walema toko tambulku moloringi kanopalie elo walsipelie “Na lombili wale.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aku nirimu kinie pilkululie elonga lapa Seperi kinie nona andoli sipimu kinie tamburumbu munduku siye kolkololie Yesusi yu lombili puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kanu kinie Yesusi kolea Gallilli disiriki sukundu koleamanga pali andopa, yemboma maku toko Pulu Yemonga ungumu pilieringi ulkemanga yemboma ungu mane sipe, Pulu Yemo nondopa ye nomi kingimu molopa nokomba mele temane peangamo topa sipe, yembo kuru lupe lupe torumume kinie kangine ulu awisili terimume kinie tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yu terimu mele temanemo kolea Siria poropinji koleamanga pali anjo anjo purumu pilkulie enonga yembo kuru lupe lupe torumu yemboma kinie, mindili lupe lupe nongo moloringi yemboma kinie, yembomanga konopune kuru molko amboloringi yemboma kinie, kuru kopari torumu yemboma kinie, kimbu ki kukorumu yemboma kinie, yu molorumune mengo oringi kinie yuni eno tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yembo paa awisili yu lombili puringi. Kolea Gallilli disiriki yemboma kinie, ‘Kolea Awili Rureponga Talo’ niringi kolea yemboma kinie, kolea Judia disiriki lierimu kolea awili Jerusalleme yemboma kinie, kolea Judia sukundu lierimu we koleamanga moloringi yemboma kinie, no Jodane nekendo koleamanga yemboma kinie, paa awisili yu lombili puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesusini yembo awisili maku toko yu lombili puringime kanopalie ma pangine ola pupe molorumu kinie yu lombili andolime yu molorumune oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kanu kinie yuni eno ungu mane sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yembo konopune koropa pulimo pilimele yemboma Pulu Yemo enonga ye nomi kingimu molopa eno nokolemomonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Yembo kola teko konopu keri pepili molemele yemboma Pulu Yemone “Eno konopu peanga pepa toyombo topili.” nimbemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Yembo taka liku molko yembo lupema pilku molemele yemboma ma koleama pali Pulu Yemone eno simbe lingemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pulu Yemone “Teaa.” nilimo ulu sumbi nilime tengendo waka kolko molemele yemboma manda molongemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Yembo lupema kondo kolemele yemboma Pulu Yemone kondo kolombamonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Yembo konopu kake tepili molemele yembomane Pulu Yemo kanongemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“‘Yemboma konopu telune pupili molangi.’ nilimele yemboma Pulu Yemone ‘Eno nanga ambolangoma.’ nimbemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pulu Yemone “Teaa.” nilimo ulu sumbi nilime teko molemelemonga yembo lupemane eno mindili silimele ⸤akumunge⸥ Pulu Yemo enonga ye nomi kingimu molombamonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Na pilku molemele yemboma, eno nanga yemboma molemelemonga we yembomane eno ungu taka tondoko mindili siku, ungu keri lupe lupema enonga bulkundu kolo toko nindinge kinie eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","⸤Yembomane eno aku siku mele telemelemonga⸥ eno mulu koleana punge kinie kanune Pulu Yemone eno mele kalopa kondomba kene konopu paa awili teko siku konopu peanga pepili molayo. Yembomane kinié eno mindili silimele mele aku siku eno naa molangi koro ou Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siliku andoringi yemboma we yembomane eno kepe mindili siringila kanumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Eno ma koleana yembomanga api kusa mele molemele. ⸤Akumu mele peanga⸥ nalo yu songo naa temba kinie ‘Yu kelepa songo tepili.’ nimbu ulu te manda temoloye? Yu kongono temba tondolo te altopa naa pembamonga we topo ltemolo kinie yemboma kimbu kongono teko andoko kambilinge kinie papu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Eno ma koleana yembomanga pa tendelime molemele. Kolea awili ma pangine ola lembamo manda lopi naa tenge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yembomane tepe-llame kandokolie mingine suku naa panjilimele. ‘Melema kanangi, ulke sukundu pa tepili.’ ningu polo tenga ola nosilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aku sipe mele ‘Olione ulu peangama telemolo mele yembomane kanokolie olionga Lapa, mulu koleana molemomo, kapi niengi.’ ningu enonga pa telemomone yemboma kanangi, pa tendangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nane ‘Pulu Yemonga ungu manema ⸤Mosisini⸥ bokune torumu ungume kinie Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane bokune toringi ungume kinie ‘manie pupili.’ nimbé okomo.’ ningu naa piliengi! Nane ‘Kanu ungume kamu manie pupili.’ nimbo naa okoro. ‘Aku ungumenga ungu pulu pelemoma kamu wendo opili.’ nimbo okoro. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nane enondo paa sike nikiru: Mulu maselo ou pora naa nipili Pulu Yemonga ungu manemanga ungu wallo kolte kepe paa we manie naa pumbe. Ungu manemanga pali ungu awili kangamanga pali kongonoma ou wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Akumunge, yembo tene kanu ungu manemanga ungu mane kanga te kepe pulue topa, yembo lupema mane sipelie “Pulue tangi.” nimbé yembomo Pulu Yemo ye nomi kingi molopa nokolemo koleana yunge imbi paa manie molomba. Nalo yembo tene kanu ungu manema pilipe lipe tenge panjipe molopa, yembo lupema mane simbe yembomo Pulu Yemo ye nomi kingi molopa nokolemo koleana yunge imbi paa olandopa molomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nane eno nimbu sikiru: Parisime kinie Pulu Yemonga ungu manemanga pulume pilku mane silimele yema kinie enone ulu sumbi nilime telemele ulumenga olandopa eno we yembomane naa tengi liemo, Pulu Yemo ye nomi kingi molopa yembo nokolemo talapena sukundu eno paa naa puku molonge. ⸤Kanu yemane ungu manema pilkulie telemele mele lupe. Pulu Yemone kanopa ulu sumbi nilime nimbe kanolemo mele lupe.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Koro-ou ⸤Mosisini⸥ anda kolepalimendo ungu mane te sirimumu eno pilimele. Kanu ungu manemo isipe: “Eno yemboma toko naa kondangi. Yembo topa kondomba yembomo mongo limbe, ⸤kote pilimele yembomane⸥ yu kote tendekolie mongo liku singe.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nalo kinié nane eno kanu ungu manemonga ungu pulumu i nimbu simbo tekero: Yembo tene yunge angenu kinie mumindili kolomba yembomo willisi kotena mengo puku kote tendenge. Yembo tene yunge angenundu “Nu kamakoye?” nimbé yembomo poropinjili kotena mengo puku kote tendenge. Yembo tene yembo tendo “Nu paa kongi mele aroma tolimu!” nimbé yembomo tepe koleana pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aku siku tenge yemboma mongo linge kene nuni ‘Pulu Yemone na kanopa peanga kanopili.’ ningu yunge melema tepena kaloli polona Pulu Yemo kongi molo kera popo toko kalko sinindu mengo ongolie nu angenane nu-kinie we mumindili te kolomba pilkulie ninimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nu Pulu Yemo kalko sini melema Pulu Yemo popo toko kaloli polo alsekondo we liepili nosikulie kelko anjo puku angenando “Telune kapola kapola molambili.” ningu puku ni-pukulie, pe kelko ongo nu Pulu Yemo kaloni melema ongo yu kalko sieni. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu kote tendemba temba yembomo ‘Kapola kapola molambili ulu te teambo.’ ningulie welea teani. Aku naa tenu liemo nu kote tendemba yembomone nunge kote pilieli yemo molombana memba pupe simbenje. Pe kote pilieli yemone nu ka ulke nokoli yemo lipe simbe, yuni nu ka ulkena lipe mundumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nane nundu paa sike nimbu sikirumu: Nu ka ulkena wendo onindu pundu paa pali tokolie mindi wendo onimu. We manda wendo naa oni.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“⸤Ou Mosisini⸥ ungu mane te sirimumu eno pilimele. Kanu ungu manemo isipe: ‘Ambo ye pulime ye lupema kinie wa ulu kerinele naa teko, ye ambo lilime ambo lupema kinie wa ulu kerinele naa teangi.’ nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nalo kinié nane eno ⸤kanu ungu manemonga ungu pulumu⸥ inimbu sikiru: Ye tene ambo te kanopalie ‘Yu pea tapu topo pelembelanje papu.’ konopu lemo akumu konopu sukundu ambomo kinie kamu wa ulu kerinele telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nunge mongoselone melte kanokolie konopuni ‘Liemboa.’ ningu pilku ulu pulu keri te tenu liemo mongoselo akuku lteani. Nunge mongoselo angiliepili nu tepe koleana liku mundunge kinie kapola naa temba kene kangimunge melte wendo liku ltekolie molko kondoni kinie papu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nunge kiselone ulu pulu keri te tenu liemo aku kiselo kari leko lteani. Nunge kiselo angiliepili nu tepe koleana liku mundunge kinie kapola naa temba kene kangimunge melte wendo liku ltekolie molko kondoni kinie papu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“⸤Ou Mosisini⸥ ungu mane te sipelie nimbendo: “Ye tene yunge ambomondo ‘Kamu pupili.’ nimbe makorombando ambomo “Kamu pu.” nimbé mele pepá te topa ambomo sipelie yundu “Kamu pu.” nimbe aku tepili.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nalo nane kinié eno nimbu sikiru: Ye puli ambo te ye te kinie wa ulu kerinele naa tepili yunge yemone yu makoropa “Kamu pu.” nimu liemo ‘Wa ulu kerinele teli ambomo molopili.’ nimbe aku telemo. “Pu.” nimbe makorolemo ambomo pe ye tene yu limo kinie kanu yemo kepe wa ulu kerinele telemola.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Koro-ou ⸤Mosisini⸥ anda kolepalimendo ungu mane te pea sirimumu eno pilimele. Kanu ungu manemo isipe: “‘Paa sike tembo.” ningu, ningu panjiku mi lenge ungumu pulue naa tangi. Awilimundu “Paa sike tembo.” ningu, ningu panjiku mi lenge mele paa sike aku siku teangi.’ nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nalo kinié nane eno nimbu sikiru: “Paa sike nikimu.’ ningu piliengi!’ ningu mele awili tenga imbi leko paa mi naa leangi. Mulu koleamo kepe imbi leko mi naa leangi. Aku koleamo Pulu Yemo molopa melema nokolemo koleamo kene aku naa teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma koleamo kepe imbi leko mi naa leangila. Akumu Pulu Yemo yunge kimbu mundulimo polomo kanumu. Jerusalleme kepe imbi naa laleangi. Akumu Ye Nomi Kingi Paa Awilimunge kolea awilimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nunge penge kepe. Akumu nuni penge indi te ‘Kake tepili.’ molo ‘Pombera topili.’ ningu ulu te manda naa teni kene pengemo walsiku imbi leko mi naa leaa. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ulu te sike teni liemo sumbi siku “Tembo.” nieni. Naa teni liemo “Naa tembo.” nieni. Ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥.muni ambolemo yembomane mindi ungu sulu teko niliku puku mi lemele.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“⸤Ou Mosisini⸥ ungu mane te sirimumu eno pilimele. Kanu ungu manemo isipe: “Yembo tene yembo tenga mongomo topa akumbe kinie yunge mongomo toko akundengila. Yembo tene yembo tenga ungú topa langomba kinie yunge ungú toko langondangila.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nalo kinié nane eno nimbu sikiru: Eno tepa kenjimbe yembomo anjo uluri naa teko, ‘We tepa kenjepili.’ niengi. Yembo tene nunge kumbikere ekendonga larauwe tomba kinie topele toko ‘Ekendonga kamu larauwe topili.’ nieni. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yembo tene ‘Nunge wale pakolimu liembo.’ nimbe kote tendemba temba yembomo nunge wale sulu peangamo kepe ‘pea we lipili.’ nieni. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","⸤Romo ami⸥ ye tene nu ambolopalie “Nuni na liku tapondoko mako tenga ⸤nanga melema mendani⸥ pambili.” nimbé kinie mako tenga pea yu we liku tapondoko melema mendeko pani. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Melte si.” nimbe mawa temba yembomo mawa temba melemo we sieni. “Kou te pundu anjiku si.” nimbé yembomo “Molo.” naa nieni.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“⸤Ou Mosisini⸥ ungu mane te sirimumu eno pilimele. Kanu ungu manemo isipe: “Opa lkerayemo konopu mondoko, opa puluemo kanoko keri kanani.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nalo kinié nane eno nimbu sikiru: Enone enonga opa puluema konopu mondoko, eno teko kenjilimele yemboma ‘Pulu Yemone tepa kondopili.’ ningu Pulu Yemo enonga mawa tendangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Enonga ‘Lapa mulu koleana molemomonga ambolangoma molamili.’ ningu aku siku teangi. Yuni yembo keri peangama molemelena ‘Ena topili.’ nilimo. Yembo ulu sumbi nilime telemele yemboma kepe yembo ulu sumbi nilime naa telemele yemboma kepe enonga pea pali ‘Lo topili.’ nilimola. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Eno konopu mondolemele yemboma mindi konopu mondolemele kinie Pulu Yemone kanopa peanga kanombaye? ⸤Romo gapomano⸥ kou takisi limele yembo ⸤kerime⸥ kepe anjo yando akula telemele kene ⸤eno kanoko keri kanolemele yemboma pea konopu mondonge kinie peanga⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Enone enonga pulu lemo yembomando mindi “Eno manda molemeleye?” nilimele kinie we yembomane telemele mele maniendopa, enone telemele mele olandopaye? Ulsukundu yembomane aku sikula naa telemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Akumunge ⸤Mosisini sirimu ungu manema we pilku naa teko,⸥ enonga Lapa mulu koleana molemo ye paa sumbi nilimu molemo mele eno aku siku yembo sumbi nilime molangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","⸤Yesusini ungu mare nimbe molopalie ungu mare pea nimbendo:⸥ “‘Yembomane ‘Olio yembo paa peangama. Ulume paa tepo kondolemolo.’ ningu kanangi.’ ningu yemboma kanoko molangi enonga ulu peangama paa naa teangi. Aku siku tenge kinie yembomane eno kapi ninge. Kanu kapi ninge ungume enonga mele kalolimu lingemonga enonga mulu koleana molemo Lapamone eno mele naa kalomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“⸤Enonga mulu koleana molemo Lapamone aku siku tenge yemboma mele naa kalomba⸥ kene enone yembo koropa pulime kondo kolko ‘Lipu tapondamili.’ ningu kou mone te singendo ‘Temolo mele yembomane kanangi.’ ningu, ru ningu melte naa siengi. Topele mapele toli yemane ‘Na yembomane kapi niengi.’ ningu yemboma maku toko Pulu Yemonga ungumu pilieli ulkemanga kinie aulkemanga kinie we yembo awisilini mongone kanangi yembo koropama liku tapondolemele. Aku yemane telemele mele enone aku siku naa teangi. Nane enondo paa sike nimbu sikiru: Aku telemelemonga eno yembomane kapi nilimele ungume enonga mele kalolimu koronga limele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Nalo enone yembo koropama kondo kolko melte singendo ‘Yembomane paa naa kanangi. Yembo te pea tapu topo andolembolomone kepe naa kanopili, lopi tepo kiyengo nimbu lipu tapondambo.’ niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kanu kinie yembomane naa kanangi, tenge mele yembo te naa ningu sikulie koropa puli yembo te liku tapondonge kinie enonga ⸤mulu koleana molemo⸥ Lapamone lopi teko telemele ulume kanolemomone eno mele kalomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Eno Pulu Yemo kinie ungu ningendo topele mapele toli yemane Pulu Yemo kinie ungu nilimele mele aku siku naa teayo. Kanu topele mapele toli yemane ‘Na ye paa peangamo molio mele yembo awisilini mongone kanoko na kapi niengi.’ ningu yemboma maku toko Pulu Yemonga ungu pilieli ulkemanga kinie aulkemanga kinie yemboma kanoko molangi konopu siku angilku Pulu Yemo kinie ungu nilimele. Nane enondo paa sike nimbu sikiru: Aku siku telemelemonga eno enonga mele kalolimu koronga limele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nalo eno Pulu Yemo kinie ungu ningendo enonga suluminiana sukundu puku nambune sikulie kanu lopi teli koleana enonga ⸤mulu koleana molemo⸥ Lapa naa kanolemele yemo-kinie ungu nieyo. ⸤Yu akune molemo.⸥ Aku tenge kinie enonga ⸤mulu koleana molemo⸥ Lapa lopi teko telemele ulume kanolemomone eno pe mele kalomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“‘Na Pulu Yemo kinie ungu niembo.’ ningulie Isirele talapemonga ulsu molemele yembomane enonga kurume molo pulu ye kolo tolime kinie ungu ningendo we ungu awisili nilimele mele aku siku naa teangi. Kanu yembomane ‘Na ungu awisili nimbo kinie pilimbe.’ ningu aku siku nilimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Enonga ⸤mulu koleana molemo⸥ Lapamo ou mawa naa teangi eno molo tolemo melema yuni pilipe kanolemo kene kanu yembomane telemele mele aku siku naa teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Eno Pulu Yemo kinie ungu ningendo i siku niengi: “Olionga mulu koleana moleno Lapamo, yembomane ‘Nu imbi ola molopa ye kake teli peangamo moleno.’ ningu molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu ye nomi kingimu molko yemboma nokoni walemo wendo opili. Nunge ungumu mulu koleana pilku liku telemele mele aku siku ya ma koleana pilku liku teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Olio kinié langi nomolo mele kinié siyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yembomane olio teko kenjengi kinie siye kolopo ulu te naa temulu mele aku sikula olione nu tepo kenjemulu ulume siye kolko olio ulu te naa teyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Olio ‘Ulu tene kondi topili.’ naa ningu ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥.muni ‘olio naa ambolopili.’ ningu yunge kíne wendo liyo. (Nu koleama kinie melemanga pali ye nomi kingimu molko, tondolo olandopamo nu-kinie pepa, nu imbi paa olandopa molopa nu-kinie pa tondolo-tepa tepili alieli molko mindi pulino kene aku sipe tepili.)” ningu aku siku Pulu Yemo kinie niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yembomane eno teko kenjinge ulume ‘We manie pupili.’ ningu siye kolongi liemo enonga mulu koleana molemo Lapamone enonga ulu pulu kerime ‘Manie pupili.’ nimbe siye kolombala. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nalo yembomane eno teko kenjinge ulume ‘We manie naa pupili.’ ningu siye naa kolongi liemo enonga ⸤mulu koleana molemo⸥ Lapamone enonga ulu pulu kerime ‘Manie naa pupili.’ nimbe siye naa kolombala.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Eno langi naa nongo mi toko we molonge ulu pulumu tengendo topele mapele toli yemane ‘Na nono nimbu molambo.’ nilimele mele aku siku naa niengi. Kanu yemane ‘Na langi naa nombondo mi topo molio mele yembomane kanangi.’ ningu eno kumbikere teko enonga kumbikerema teko kenjiku molemele. Nane enondo paa sike nimbu sikiru: Kanu yemane aku telemelemonga yembomane eno kapi nilimele ungume enonga mele kalolimu koronga limele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","“Nalo eno langi naa nongo mi toko we molongendo ‘We yembomane na aku tekero mele naa kanangi. Tatane manjipe kanopili.’ ningu we yembomane kanonge ulume naa teangi. Aku tenge kinie enonga ⸤mulu koleana molemo⸥ Lapa lopi teko telemele ulume kanolemomone eno mele kalomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ya ma koleana mele nosilimelema urelo tepa koka molo lkurinia melemane ongo teko kenjiku, wa lili yema ongo melema wa limele kene ‘⸤ya mana⸥ kamako molopo mele kande kandema lipu nosiemili.’ ni naa niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aku naa tekolie mulu koleana melema urelo naa tepa koka molo lkurinia meltene omba tepa naa kenjipe, wa lili yema ongo wa naa limele kene eno mulu koleana ⸤pe pungemonga⸥ ‘mele kande kande pe limoloma ou liepili.’ ningu ya ma koleana ulu peangama teko molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Enonga nosilimele melema lemo kolea akune eno konopuni pilku konopu mondoko molemele kene ⸤‘mulu koleana mindi melema liepili.’ ningu molangi.” nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nunge mongomo nunge kangimunge tepe-llame mélemo. Aku kene nunge mongo peanga angilimo kinie nu kangi pali pa tepili moleno kinie nu molko kondoleno. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nalo nunge mongomo keri lemba kinie nunge kangi pali sumbulu topili andoni. Kanu kinie nunge kangine pateli pembamo alowa tepa sumbulu tomba kinie akumu paa kamu sumbulu tomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yembo tene ye awili talonga kongono lipe tere lepa manda naa tendemba. Ye awili te konopu keri panjipe, te konopu mondomba. Molo aku naa temu liemo ye awili tenga ungu nimbéma paa konopu sipe pilipe lipe kongono nimbéma tondolo mundupe tendepa, te konopu keri panjipe yunge ungu nimbéma ta nimbé. Yembomane Pulu Yemonga kongonomo kinie Kou Monemonga kongonomo kinie liku tere leko manda naa tendenge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Akumunge nane eno ⸤tenge mele⸥ nimbu siembo. ‘Kangikundu molopo kondamili.’ ningu konopu awisili liku naa mundengi. Langi nongemonga kepe no nongemonga kepe mulumbale pakongemonga kepe akumenga konopu awisili liku munduku naa molangi. Eno kapola molonge mele ulu pulumu langi kinie mulumbale kinie mindiye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kerama kaname. Langi te panjikulie nou lemo kinie liku mengo ulkendo puku nosiku naa nolemele nalo eno yembomanga mulu koleana molemo Lapamone kerama langi silimo. Kerama we mele eno yemboma olandopamonga yuni eno naa nokombaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Enonga yembo tene konopu awisili lipe mundumbemone yu kolomba ena te manda ‘We liepili.’ nimbeye? Manda naa nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Eno pakonge melemanga konopu awisili nambemune liku mundulimeleye? Pillawa sindime mana olemo mele eno naa kanolemeleye? Pillawa sindimene kongono mindili siku naa teko, mulumbale te teko mimi naa telemele ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","nalo pillawa sindime molemele mele olandopa, ⸤ye nomi kingi⸥ Sollomono kongono awisili tepalie wale paa peangama pakopa a nirimu mele maniendopa. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Era sindi tolemoma kinié mele molemo, opali mele poroko tepena kalemelema Pulu Yemone aku sipe nokopa kondolemo liemo eno ‘Pulu Yemone olio manda nokombanje.’ ningu laye kolte mindi pilimele yemboma pakonge melemanga yuni manda lipe naa tapondombaye? Eno paa sike lipe tapondomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“⸤Pulu Yemone kerama kinie era sindime kinie aku we melema aku sipe nokolemo⸥ kene eno konopu awisili liku mundukulie ‘Esi, langi te tena lipu nomolonje?’; molo ‘No tena kolopo nomolonje?’; molo ‘Wale pakoli tena lipu pakomolonje?’ ningu pilku naa molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pulu Yemonga yemboma naa molko ulsukundu molemele yembomane aku siku telemele nalo enonga mulu koleana molemo Lapamone eno yunge yembomanga mele molo tolemoma kanopa molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","⸤Eno langi nongemanga kinie mulumbale pakongemanga kinie konopu naa liku munduku,⸥ Pulu Yemo ye nomi kingi molopa yemboma nokolemo ulume kinie yu kanopa kake telemo kanolemo ulume kinie melema kinie ‘Kumbi lepo teambo.’ konopu leko molangi. Aku tenge kinie yuni we melema kepe eno simbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yuni aku temba kene ‘Opali nambe-embonje?’ ningu kinié konopu awisili liku naa mundengi. Opalimunge langi molo melema aku opali, kiniémonga langi molo melema kinie, opalimunge kinie, liku tere leko naa piliengi! Enamanga yu mele mele umbunema pelemo pembama kanu enamanga mindi. Kinié umbune wendo ombáma kinie, opali talou umbune wendo ombámanga kinie, tere leko konopu liku naa mundengi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","⸤Yesusini ungu mare nimbe molopalie ungu mare pea nimbendo:⸥ “Enone anjo yemboma ⸤telemele ulume⸥ apurunge kinie aku sipe ⸤Pulu Yemone⸥ eno telemele mele yando apurumbela. Enone anjo yembomane telemele mele apuruku kanokolie “Teko kenjikimili. Tekemele mele Pulu Yemone kanopa keri kanopili.” ninge mele ⸤Pulu Yemone⸥ aku sipe eno apurumbe. Aku temba kene ‘⸤Pulu Yemone⸥ olio ulu telemoloma naa apuropili.’ ningu enone yemboma telemele ulume naa apurengila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nuni angenanga mongona nurupulu te lemo kanoleno nalo nunge mongona unjo awili te lemomo naa kanoleno akumu nambemune telenoye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nunge mongona unjo awili lemomo naa kanokolie angenando “Ano, nunge mongona nurupulu te lemomo wendo lindembo.” nambeko nilinoye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Topele mapele toli yembomo, nuni nunge mongona lemo unjo awilimu ou wendo likulie pe kanoko kondoko angenanga mongona lemo nurupulumu manda wendo lindení.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“‘Pulu Yemonga’ nilimele melema liku owa naa sieme. Nombalie pe topele topa eno nombanje kene aku naa teangi. Enonga mele peangama kongi angilimbena toko naa mundengi. Kimbuni kambilimbenje kene aku naa teangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“⸤Lapa, mulu koleana molemo yemo⸥ melema mawa teko “Si.” niengi. Aku tenge kinie melema sike simbe linge. ⸤Lapa molemona⸥ melema korangi. Aku tenge kinie melema sike kanoko linge. Ulke kerepulune angilku “Sukundu wamili.” niengi. Aku ninge kinie “Sukundu waa.” nimbe nambune tondomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mawa tenge melema sike simbe linge, koronge melema sike kanoko linge, “Sukundu wamili.” ninge kinie sike nambune tondomba. Aku temba kene aku teaa. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Enonga ye te yunge malo ombalie “Tata, pillawa kaloli te nambo si.” nimbé kinie yunge lapane yu kou mulú te simbeye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Molo kangomone “Tata, oma te nambo si.” nimbé kinie yunge lapane wambiye te simbeye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pe eno konopu keri pepili molemele yembomane aku siku enonga ambolangoma mele peangama silimele liemo enonga Lapa mulu koleana molemomone “Melema si.” ningu mawa tenge yemboma mele peangama paa olandopa naa simbeye? ⸤Paa simbemo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Akumunge, ‘Yembomane nu-kinie teangi.’ konopu leno mele nuni anjo yemboma aku siku teani. ‘Aku teangi.’ nikinu ulumuni Mosisini Pulu Yemonga ungu mane sirimu bokune torumumenga pulumu kinie, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane bokune toringi ungumenga pulumu kinie, lipe tere lepa nilimo kene aku siku anjo yando yemboma-kinie teko kondangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Eno pala kerepulu kangamonga paa pangi. Kolea kerine pulimo kerepulumu paa awilimu, akune pulimo aulkemo paa anjo yando pupe paa pará lemo akune yembo awisili mindili naa siku we we teko pulimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nalo alieli konde molopa kondopa mindi puli koleana pulimo kerepulumu paa kanga, yunge aulkemo paa tengepea teli kangamo lemo kolo yemboma akune pungendo mindili silimelemonga yembo telu telu ningu mindi aku aulkemo kanokolie pulimele. Aku telemele kene eno kanu kerepulu kangamonga pangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pulu Yemone ungu umbu tondolime naa pilku we kolo toko yando ningu singe yema onge kene kanoko kondoko molayo. Kongi sipisipi paa taka liku molemele mele aku siku kanu yemboma ongo molonge nalo owa takera paa engelene kolkolie ‘Melte topo namili.’ ningu andoko molemele mele aku siku kanu yembomane ‘Eno mindili nangi. Eno tepo kenjemili.’ ningu molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kanu kolo toli yemboma ongo ulu tengema kanokolie, ‘Eno sike kolo tolime.’ ningu kanonge. ‘Amu namili.’ ningu akeme manda olko toko nolemelaye? Molo ‘Me te namili.’ ningu silipu manda akuku nolemelaye? Paa molo. ‘Amu lupe akeme lupela, me lupe silipu lupela.’ ningu kanolemele. ⸤Aku siku mele Pulu Yemone sike ungu umbu tondolime pilku yemboma sike ningu silimele mele lupe, Pulu Yemone ungu umbu naa tondolime yemboma kolo toko ningu silimele mele lupela ningu kanonge.⸥ Unjoma mongo tolemo kinie kanokolie ‘Ime nomolo lemo. Ime naa nomolo lemo.’ ningu kanoko imbi silimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Unjo peangamone mongo peangamo tolemo; unjo kerimuni mongo kerimu tolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Unjo peangamone mongo keri te manda naa tomba; unjo kerimuni mongo peanga te manda naa tombala. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Unjo mongo peangama naa tomba unjoma pali peke tokolie tepena kalemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unjoma mongo tolemo kinie kanokolie, “I mu peanga, imu keri.” ningu apurulimele mele, onge yembo kanumene tenge ulume enone kanokolie yemboma molemele mele sike aku siku kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘Yembomane nando ‘Awilimu.’ nilimele yemboma pali Pulu Yemone nokolemo mulu koleana suku punge.’ ningu naa pilieyo. Tata mulu koleana molemomonga ungume pilku liku tenge yemboma mindi akune punge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yemboma apurumbe wale kanumu wendo ombá kinie yembo awisilini nando ningendo: “Awilimu, nane nunge imbi lepo nunge ungume nimbu sirindu kanumu; nunge imbi lepo yembomanga konopune kuru moloringime “Ongo ulsu paa.” nirindu kanumu; nunge imbi lepo ulu tondolo awisili terindu kanumu.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nalo aku siku ninge kinie nane enondo nimbondo: “Na enonga imbime paa naa pilipu eno kanopo imbi naa silio. Eno Pulu Yemonga ungumu naa pilku liku teringi kene nanga kumbikerena naa ongo anjo paa.” nimbo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Akumunge, inanga ungume pilku liku tenge yemboma eno ye te molemo mele niembo: Ye pilipe konginjeli perimu ye te yuni yunge ulkemo ‘Ingi nimbe angiliepili.’ nimbe kou-polona ola takorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe lo topa no topa poporome topalie ulkemo paa topa kalalu simbe terimu nalo ulke simumu kou-polona angilierimu kulu topa tekise naa tekisipe ingi nimbe we angilierimu. Nanga ungume pilku liku telemele yemboma eno kanu yemo mele molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“I nanga ungume pilku liku naa tenge yemboma eno ye te molemo mele niembo: Ye pilipe konginjeli naa perimu ye tene yunge ulkemo ukiana ola takorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe lo topa no topa poporome topalie ulke kanumu topa kalalu sipe paa bulu-balo sirimu. Nanga ungume naa pilku liku tenge yemboma eno kanu yemo mele molemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesusini aku ungume nimbe pora sirimu kinie yuni mane sirimu pilku moloringi yembomane yuni ungu mane sirimu mele pilkulie mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pulu Yemonga ungu manemanga pulume pilku eno mane siringi yemane we mane siringi mele Yesusini aku sipe mane naa sirimu. Namba lierimu yemane pipili naa kolko tondolo munduku mane siringi mele aku sipe mane sirimu kulu pilkulie eno mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusi ma pangine maniendo ombá orumu kinie yembo awisili liku maku toko yu lombili oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kanu kinie ye te kuru kendi nomba perimumu Yesusi orumune omba yunge kumbikerena koporongo langopalie yundu nimbendo: “Awilimu, nunge konopumuni na ‘konde pambo.’ konopu lienu liemo nuni na manda teko konde lini.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesusini yemo kini ambolopalie yundu nimbendo: “‘Nu konde pani.’ konopu lekero kene konde pu.” nirimu kinie tamburumbu kuru kendimu nomba kelierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kanu kinie Yesusini yundu altopa nimbendo: “Nuni ya ulu tekeromo yembo telurindu kepe paa naa niyo. Sumbi siku puku Pulu Yemo popo tondoli yemo nunge kangimu liku ora siku, ‘Na altopo kangi peanga liepili molkoro kene.’ ningu Mosisini “Tei.” nimbe panjerimu mele pilku liku tenindu “Pulu Yemo popo toko kalko sie.” nirimu mélemo liku Pulu Yemo popo tondoli yemondo “Kalondou.” ningu yu sieni. Pe yembomane nu kanokolie ‘Yu sike kangi peanga liepili molemo.’ ningu piliengi kene nikiru mele isili-ou te-pou.” nirimu. ⸤“Aku siku teni kinie yembomane nu kanoko keri naa kanonge, nu altoko we yemboma molemelena manda telune puku moloni.” nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesusi Kapeniame taonona sukundu purumu kinie Romo yembomanga ami ye wane anderete nokorumu ye te yu orumune omba yundu mawa tepalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Awilimu, nanga kendemande yemo kimbu ki kolopa pora sipe mindili nomba perepa ulkena liepili okoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusini yundu “Ombo tepo konde limbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","⸤Aku nirimu kinie pilipelie⸥ ami ye wane anderete nokorumu yemone yundu topondopa nimbendo: “Awilimu, na ye kerimu mele molio, nu nanga ulkena oni kinie kapola naa temba. Na ye tene kepe nokopa molemo, yunge ungumu pilipu lipu telio. Nane kepe ami ye mare nokopo molio. Kanu yemanga tendo “Pu.” nilio kinie yu pulimo. Molo tendo “Ou.” nilio kinie yu olemo. Molo nanga kongono tendeli kendemande yembo tendo “I siku tei.” nilio kinie yu aku sipe telemo kanumu. Aku sipela, nuni ungu te we nini kinie nanga kendemande yemo konde pumbe kene nuni we ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusini yu nirimu mele pilipelie yu konopu awisili lipe mundupelie yu lombili oringi yembomando nimbendo: “Nane enondo paa sike nimbu sikirumu: I Isirele yembomanga talapena ulsu mololi yemone na ungumuni mindi manda tembo mele nimbe tondolo mundupe pilimo mele koleamanga pali, Isirele koleana sukundu kepe, yembo telurini kepe aku siku ningu pilieringi mele paa naa kanorundu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nane enondo paa sike nimbu sikirumu: Ena mundi olemo koleamanga kinie ena pulimo koleamanga kinie yembo awisili wendo ongo Pulu Yemo ye nomi kingimu molopa nokolemo mulu koleana sukundu Eporayamo kinie Aisake kinie Jekopo kinie pea ongo langi nongo molonge. nie anjokondo 13:42,50, 22:13, 24:51, 25:30. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nalo Pulu Yemone ‘yunge yemboma’ nimbe mako torumu ⸤Isirele⸥ yemboma yu nokopa molemo koleana puku molemela yemboma yuni topa makoropa sumbulu toline mundumbe. Kanune paa mindili nongolie kola teko pereko molonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aku nimbelie yuni ami ye wane anderete nokorumu yemondo nimbendo: “Nane nu ‘manda tendemba’ konopu lienu mele tendendu kene pu.” nirimu. Kanu kinie yuni aku sipe nirimu enamonga kendemande yemo yu kuru topa kelepa konde pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","⸤Kanu kinie⸥ Yesusi Pitanga ulkena sukundu ombalie Pitanga kolepa ambomo kuru topa kangi norumu kulu aniembo lierimu kanopalie, ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","yunge kimu ambolorumu kinie kangi nomba kelierimu kinie ambomo ola angilipe wendo ombalie Yesusi langi sipe yu nokorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pe kolea ipu lemba terimu kinie konopune kuru molorumu yembo awisili Yesusi molorumune mengo oringi kinie yuni kurumendo “Ongo wendo paa.” nirimu kinie ongo wendo puringi. Kuru torumu yemboma pali tepa konde lsimula. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aku sipe terimumunge koronga-ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Aisayane nimbendo: “Yuni yuyu olio kuru torumume makoropa, olio aniembo lierimulu kurume lipe ulsu mundorumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","⸤Walse⸥ Yesusi ⸤nomu Gallilli kélona molopili⸥ yembo awisili liku maku toko yu liku makapu teko moloringi kanopalie nirimumuni, ⸤lombili andolimendo⸥ “Nomune nekendo pamili waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","⸤Nalo ou naa pupe we angiliepili⸥ Pulu Yemonga ungu manemanga pulume pilipe mane sirimu ye te yu angilierimune omba yundu nimbendo: “Ungu Mane Silimu, nu puni koleamanga pali nu lombili ombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","⸤Aku nirimu kinie⸥ Yesusini yundu nimbendo: “Pílie! Owa takerama ulke pelemelemanga pelemele; kerama enonga mi takolemelemanga pelemele, nalo Manie Omba Mana Ye A Lierimu Yemonga pelemo kolea te naa lemo ⸤kene, nu ‘Yu lombili pupulie kapola naa molombo.’ ningu pilkulie na lombili wani. We naa wani.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kanu kinie yu lombili andorumu ye tene yundu nimbendo: “Awilimu, nu kamu lombili wambo mangali ou pupu nanga lapamo ⸤kinie pea molambo. Pe yu kolomba kinie⸥ ono tepolie nu lombili ombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nalo Yesusini yundu nimbendo: “⸤Nanga ungumu naa pilku⸥ yembo kololi ⸤none teli⸥ yembomane yembo kolongema ono teangi. Nalo nu na lombili ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aku nimbelie ⸤nomu Gallilli nekendo pumbendo⸥ nona andoli sipi tenga sukundu purumu kinie yu lombili andolime yu lombili sukundu puringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kanu kinie ⸤nomune punge puringi kinie⸥ poporome awili te nomune torumu. Aku terimu-ne nomumu apisipe ola ombalie sipimu lipe aki tomba terimu nalo Yesusi we uru perimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanu kinie enone yu uru perimune puku toko makinjindikulie ningendo: “Awilimu, olio liku tapondoyo. Olio no wangokomolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yu ⸤makilipelie⸥ enondo nimbendo: “‘Pulu Yemone olio nokomba.’ ningu konopu tondolo naa pekemo yema, eno nambemune mini-wale mundukumiliye?” nirimu. Aku nimbelie ola molopa poporomemo kinie nomumu kinie iri torumu. Kanu kinie poporomemo topa kelepa nomumu lope naa tepa paa we lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","⸤Yuni terimu mele kanokolie⸥ yemane mini-wale mundukulie ningendo: “Apa! Iyemo nambolka yerenje? Poporomemone kepe nomumuni kepe yunge ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kanu kinie yu ⸤lombili andolime kinie pea⸥ nomu nekendo pupe kolea Gadara puringi kinie kanu kolea Gadara ye talo, konopune kuru molorumu yeselo, yembo ono koleana wendo ongolo yu molorumune oringili. Elo paa enge ningulu yemboma tongele teringilimunge we yemboma elo peringili koleana ‘Elone eno tongele.’ ningu aulkena ongo naa puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesusi kanokololie tondolo munduku walsikululie ningelendo: “Pulu Yemonga Malo, olio-kinie ulu nambolka uluri tenindu onuye? Olio mongo lipe simbe walemo ou wendo naa opili nuni isili ou olio mindili liku sini okonoye?” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akune anjopa kolea tenga umbu kongi awisili ímu nongo moloringi ⸤kanokolie⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kurumene Yesusi mawa tekolie ningendo: “Olio toko makorokolie ‘ne kongimenga konopune molo-pangi.’ ni.” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","yuni enondo nimbendo: “Kapola, akune pangi.” nirimu kanu kinie ⸤kurume⸥ kanu yeselonga konopune wendo ongolie kongi akune moloringimenga konopune puku moloringi kinie kanu kongime pali kekelepa toko lkisiku puku kopona pukue toko nomune suku puku no wangoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","⸤Ulu akume wendo orumu kinie kanokolie⸥ kongi tapu teko moloringi yema talopa leko pukulie niringimuni, taonona puku akune moloringi yemboma enonga kongime terimu mele kepe kurume konopune moloringi yeselo terimu mele kepe temane toko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Niringi mele pilkulie taonona moloringi yemboma pali Yesusi molorumune ongo kanokolie yu mawa tekolie ningendo: “Olionga koleana naa mololi kelko pu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanu kinie Yesusi altopa nona andoli sipi tenga sukundu pupelie nirimumuni, nomu ⸤Gallilli⸥ yakondo omba yunge kolea ⸤Kapeniame taono⸥ orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yu ⸤Kapeniame kelepa⸥ omba molorumune ye marene kimbu ki kolopa pora sirimu ye te taropola teko mengo oringi. Enone ‘Yesusini iyemo manda tepa konde limbe.’ ningu pilkulie yu mengo oringi, Yesusini kanopa pilipelie kimbu ki kolopa pora sirimu yemondo nimbendo: “Nanga kangomo, nunge konopu waengo nipili. Nunge konopune ulu pulu keri terinu pelemoma manie pupili, mundupu siye kolkoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aku nirimu kinie pilkulie Pulu Yemonga ungu manemanga pulume pilku mane siringi ye marene enono konopuni pilkulie, ‘Iyemone Pulu Yemo marake tekemo.’ ningu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Eno konopu lieringi mele Yesusini pilipelie nimbendo: “Eno nambemune konopu leko kenjikimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Iyemondo “Nunge ulu pulu kerime manie pupili, siye kolkoro.” nimbo kinie eno ulu te naa kanokolie ‘We we tepa nikimu.’ konopu lengeye? Molo “Ola angilku nunge kunungumu liku mengo kimbu kongono teko andou.” nimbo kinie yu ola angilimbene naa angilimbenje mona lemba manda kanokolie ‘Aku sipe mindili sipe nikimunje?’ konopu lengeye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nalo “Manie Omba Mana Ye A Lierimu Yemo tondolo pelemomone ya ma koleana yembomanga ulu pulu kerime “Manie pupili, siye kolkoro.” manda nimbé.’ ningu piliengi!’ nimbu aku sipu nindu.” nirimu. Aku nimbelie kimbu ki kolopa pora sili yemondo nimbendo: “Nu ola angilku nunge kunungumu liku mengo ulkendo pu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aku nirimu kinie yemo ola angilipe ulkendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yembo awisili akune maku toko moloringimene yu aku terimu kanoko mini-wale mundukulie, mana yemboma ulu tondolo aku mele tenge tondolomo sirimu Pulu Yemonga imbi liku ola mundunduku kapi niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kanu kinie Yesusi pumbe pupelie nirimumuni, kou takisi lipe molorumu ye te, yunge imbi Mateyu, kanopalie yundu “Na-kinie pea pambili lombili ou.” nirimu. Kanu kinie Mateyu yu ola angilipe yu lombili purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe Yesusi Mateyunge ulkena langi nomba molorumu kinie kou takisi lili yema kinie, ⸤Juda ye awilimene⸥ “ulu pulu kerime teli ye” ⸤niringi⸥ wema kinie awisili ongo Yesusi kinie yu lombili andoli yema kinie eno pea manie molko langi noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","⸤Eno aku siku telune langi nongo moloringi kulu⸥ Parisi yemane kanokolie yu lombili andolimendo walsiku pilkulie ningendo: “Enonga ungu mane sili yemo kou takisi lili yema kinie ulu pulu kerime teli ye wema kinie eno-kinie yu nambemune langi pea nokomeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aku siku niringi mele pilipelie Yesusini enondo nimbendo: “Kuru naa tolemo yemboma doketana naa pulimele. Kuru tolemo yemboma mindi doketana pulimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nane “Yembo sumbi nilime na molombona wangi.” nimbondo ma koleana naa orundu. ‘Ulu pulu keri teli yemboma na molombona wangi.’ nimbondo orundu. Ulu pulu keri teli yemboma lipu tapondombondo orundu kene eno puku Pulu Yemonga bokune molemo ungu tenga pulumu puku pili-peyo. Pulu Yemone nimbendo: “‘Na melema popo toko kalko siengi.’ nimbu pilipu naa molio. ‘Eno yembo lupema konopu mondoko kondo kolangi.’ nimbu pilipu mindi molio.” nirimu kanumu.” nimbe Yesusini nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pe ⸤No Lindeli⸥ Jono lombili andoringi yema Yesusi molorumune ongolie yundu walsiku pilkulie ningendo: “Olio kinie Parisi yema kinie olio alieli langi mi topo naa nolemolo nalo nu lombili andolime aku siku naa telemele akumu nambemune naa telemeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","⸤Aku siku niringi kinie pilipelie⸥ Yesusini topondopa enondo ⸤ungu iko te topa yu-kinie ulu te wendo ombá mele nimbelie⸥ nimbendo: “Ambo limbe ye te yunge pulu lemo yema kinie molemo kinie eno konopu sikulie “Kola tepo langi naa namili.” manda ningeye? Manda naa ninge. Pe mindi, ambo limbe yemo eno molongena ongo wendo liku ⸤tonge⸥ kinie kanu walemanga sike ⸤konopu keri panjiku⸥ langi naa nongendo mi tonge. ⸤Isili-ou molo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mulumbale ou te sungu nilimo kinie olione mulumbale paa konde tenga te kopisipu lipu, sungu nilimomonga naa topo tambululimolo kanumu. Yembo tene aku sipe topa tambulkenje kanu mulumbalemo nona panjilke kinie mulumbale konde kopiselimu kanga lepa lli nimbelie mulumbale oumu kelepa kamu awili tepa sungu nilke. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Kongi-meme kalumuni teli mingi-ou tenga no waene konde naa lakolemolo kanumu. Yembo tene mingi-ou tenga no waene konde te kolkanje kanu no waenemo mingine sukundu pepalie pe akolka kinie kanu mingi oumu naa akopa sungu nilke. Kanu kinie nomo kepe mingimu kepe kamu keri lelka. Akumunge no waene konde kongi-meme kalumuni teli mingi kondena mindi kolemolo kanumu. ⸤Pe nomo akolemo kinie kalumuni teli mingi kondemo anjo yando pupe sungu naa nilimomonga⸥ nomo kinie mingi kondemo pea kapola lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusini Jononga lombili andoli yemando ungu nimbe molopili ⸤Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke te⸥ nokorumu ye te Yesusi molorumune omba yunge kumbikerena koporongo langopa yundu nimbendo: “Nanga ambolamo kinié isili kolopa pora sikimu. Nalo nu ongo yu kimuni amboloni kinie yu konde pumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aku nirimu kinie Yesusi ola angilipe yu lombili purumu. Yesusi lombili andolime pea puringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kanu kinie ambo te molorumu kanumunge pena perimu walema pora naa nirimu. Yu pena mindi pepili ponie engaki rurepo omba purumu. Kanu ambomone ‘Yunge wale pakolimu mindi ambolondu liemo na konde pumbo.’ nimbe pilipelie Yesusi pumbe purumu kinie bulkundu omba, yunge wale pakolimunge pundumu ambolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ambolorumu kinie Yesusi topele topa yu kanopalie nimbendo: “Ambolamo, nu konopu waengo nipili moloyo. ‘Nu manda tepa konde limbe.’ konopu lienu kanu ulumuni nu konde pukunu.” nirimu. Kanu enamonga ambomo konde pupelie we molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kanu kinie Yesusi ⸤Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkemo⸥ nokoli yemonga ulkena sukundu ombalie yembo awisili molko kondo kolko, kolape-mingi langoko, kola awili-teko teko moloringi kanopalie yuni nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Eno anjo pame! Ambolamo kolou naa kolomu. We uru mindi pelemo.” nirimu. Aku nirimu kinie ⸤ambola kanumu sike kolopa pora sirimu pilkulie yuni “We uru pelemo.” nirimumunge⸥ yu ungu taka tondoko tawe tenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kanu kinie yembo maku toko moloringime pulu sipe pena-pena tepalie ⸤ambola onomo lierimu⸥ suluminiana pupe yunge kimu ambolorumu kinie ambolamo ola molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iulu tondolo terimumunge temanemo kanu koleamonga sukundu lierimu koleamanga pali anjo anjo purumu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesusi kanu koleamo mundupe siye kolopa pumbe purumu kinie mongo keri lierimu ye talo yu lombili ongo walsikululie ningelendo: “⸤Ye nomi kingi⸥ Depisini kalopa lsimu yemo, nu olto kondo kolou.” ningu wale awisili niliku oringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yu ulke tenga sukundu purumu kinie mongo keri lieli yeselo yu molorumune lombili oringili kinie yuni elo walsipelie: “Elo na mawa tekembele mele ‘Manda temba.’ konopu lekembele molo moloye?” nirimu kinie elone ningelendo: “Awilimu, ‘Manda teni.’ konopu lekembolo.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kanu kinie yuni elonga mongoselonga ambolopalie nimbendo: “Nane ‘manda temba.’ konopu lekembele mele aku sipe wendo opili.” nirimu ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","kinie elonga mongoselo peanga lierimu, melema altoko kanoringili. Yesusini elo tondolo mundupe mane sipelie nimbendo: “Elone iulu wendo okomomo yembo teluri kepe paa naa piliengi, naa ningu siele!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nalo elo pena pukulu Yesusini terimu mele aku koleamonga sukundu lierimu koleamanga pali temane toko silikulu andoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kanu yeselo Yesusi munduku siye kolkolo pungele puringili kinie ye te konopune kuru molorumumunge ungu te naa nirimu ye te Yesusi molorumune mengo oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesusini yemonga konopune molorumu kuru kanumu topa makororumu kinie ungu naa nirimu ye kanumuni ungu nirimu kulu yembo maku toko moloringimene kanokolie konopu awisili liku mundukulie ningendo: “Ou Isirele koleana sukundu isipe ulu te wendo naa orumu kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nalo Parisi yemane ningendo: “Kurumenga nomimuni yu lipe tapondolemo-na yuni kurume topa makorolemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesusi kolea awilimenga kinie, kolea kangamanga kinie pelipe andopalie nirimumuni, Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkemanga pupe ungu mane sipe; Pulu Yemo ye nomi kingi molopa yemboma nokolemo nokomba ungu pulumunge temane peangama topa sipe; kuru lupe lupema torumu yemboma tepa konde lsimula. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yembo paa awisili yu molorumune ongo liku maku toko moloringime kanopalie eno umbu konopu naa pepili andoko, kangime enge naa perimu kulu eno enono manda liku naa tapondoko molkolie eno kongi sipisipime enonga tapu ye te naa molorumumunge we moloringi mele eno aku siku moloringi kulu kanopalie eno paa kondo kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanu kinie ⸤yembo awisili ‘Yuni lipe tapondopili.’ ningu moloringi kulu kanopalie⸥ lombili andolimendo nimbendo: “Langi awisili poniena nou lemo nalo kongono ye awisili molo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","⸤Na ye telumu mindi ikongonomo tekero kene⸥ Langi Pulu Yemo mawa tekolie yuni “Langi nou lielime linge kongono tenge yemboma yunge poniena lipe mundopili.” niee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesusini yu lombili andoli ye engaki rurepondo “Yando waa.” nimbelie enone yembomanga konopune kuru molemoma “Ongo wendo paa.” ningu toko makoronge tondolomo sipelie, yembo kuru tolime kinie kangi pange-mange telime kinie “Konde pangi.” ninge nambamo sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yuni “Nanga kongonomo tende-paa.” nimbe lipe mundorumu ye engaki rureponga imbime isipe: Ou Saimono, yunge imbi te ‘Pita’ niringila, yu keme yunge angenu Enderu keme, Jeperinge malo Jemisi keme Jemisi yunge angenu Jono keme, ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pillipu keme Batollomiu keme, Tomasi keme kou takisi lsimu ye Mateyu keme, Allapiasinge malo Jemisi keme Tadiasi keme, ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Olio Juda yemboma oliolio gapomano molamili.” niringi talape ye Saimono keme Yesusi pe lipe opa puluema sirimu ye Judasi Isikeriote keme, akume. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesusini aku ye engaki rurepo lipe mundupelie enondo nimbendo: “Yembo lupema molemelena naa lapangi. Sameria yembomanga taono tenga naa lapangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isirele yemboma mindi enonga kongi sipisipi pena lou leko pelemele mele aku siku molemele yemboma molemelena mindi pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Eno molemelena punge pukulie, enondo “Pulu Yemo ye nomi kingi molopa yemboma nokomba walemo nondopa wendo ombá tekemo.” niliku pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Kuru tomba yemboma teko konde liku, kolko lenge yemboma ‘Lomboroko ola molaa.’ ningu, kuru laká nombá yemboma ‘Umbu kalu angiliepili.’ ningu, kuru konopune molopili molonge yemboma ‘Konopune naa molangi, ongo wendo pangi.’ ningu teliku pangi. Ikongonomo tengemonga tondolomo kou te molo meltene topo toko naa likimili kene anjo yemboma aku siku liku tapondokolie ningemone, ‘Kou te liemili.’ ningu naa lateangi. We teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Pungendo kou gollo mare molo kou sillipa mare molo kou kopa mare kakona panjiku mengo pu naa pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mele wale kepe wale pakoli talo kepe kimbu-su kepe apulu mingi kepe naa mengo we pangi. Yembo kongono tendelemomo kongono tendelemo yembomone langi simbe kinie papu kene melte mei naa meangi. We pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pe kolea awili tenga molo kolea kelo tenga suku pukulie ningemone, yemboma walsiku pilkulie “Ye nawe ye peanga te molemomonga oliondo “Pea peamili waa.” nimbeye?” niengi. Kanu kinie te ningu singe kinie pilku yu kanoko lendekolie kanu yemonga ulkena puku yu kinie mindi pea peko molkolie pe aku koleamo munduku siye kolko pangi. ⸤Ulke pinie-pinie naa andoko ulke teluringe mindi langi nongo peangi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","⸤Kolea tenga puku ye peanga te liku ora singe kinie kanoko lendeko⸥ yunge ulkena sukundu pukulie ningemone, ulke pulu yembomando “Eno konopu peanga pepili molaa.” nieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kanu kinie kanu yembomane “Pea peamili sukundu waa.” ningi liemo, enonga ungu peanga ninge kanumu kanu yemboma kinie pepili. Nalo kanu yembomane konopu peanga naa panjiku, “Pea peamili waa.” naa ningi liemo ungu peanga ou sukundu pukulie ninge kanumu “Eno kinie naa pepili.” ningu, kelko mengo ⸤eno munduku siye kolko yando wangi⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Yembo tene enondo “Pea peamili waa.” ni naa ningu enone ungu ningema pilku naa lingi liemo kanu ulkemo molo kanu taonona yembo kerime munduku siye kolko pungendo ⸤kanu koleana yemboma ‘Kamu molko kenjengi! Pulu Yemone eno lipe naa tapondomba mele piliengi!’ ningu⸥ enonga kimbune kanu koleamanga ma angilimbe mamo kulu toko pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nane eno paa sike nimbu sikirumu: Kote walemo wendo ombá kinie kolea awili Sodomo kinie Gomoraselo elonga yemboma ⸤ou ulu pulu keri awisili sike teringi nalo⸥ elonga kote kelo mele pemba. Nalo iyembo enondo “Sukundu waa.” ni naa ningu enonga ungu pilku naa linge yemboma kote walemo wendo ombá kinie enonga kote awilimu pemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Eno lipu mundukuru yema eno sipisipi melema, yembo owa takera awili kerimene sipisipi topa nolemo mele yemboma molemelena eno lipu mundukuru. ⸤Nanga ungumu andoko ningu singe kinie pilku keri pilkulie yembomane eno mindili liku singe.⸥ Yemboma owa takera mele aku siku molemele kene kongi-ka wambiyema pilipe konginjelimu paa pelemo-na ulume tembando mimi sipe pilipe telemo mele eno aku wambiyema mele molko, kera waembono molemo mele molangi. ⸤Aku keramone melema mindili sipe tepa kenjimbe ulu pulu te naa pelemo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Yemboma mimi siku kanangi. Enone ⸤‘Na lombili andoli yemboma mindili nongo, kolangi.’ ningu,⸥ eno ⸤mare liku ambolkolie⸥ kanjollomanga makumenga mengo puku kote tendeko, eno ⸤mare⸥ Juda yemboma maku toko Pulu Yemonga ungumu pilimele ulkemanga liku mengo puku kopene tongela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eno nanga yemboma molongemonga eno ⸤mare ka siku⸥ yembo lupemanga gapomano ye awilime kinie ye nomi kingime kinie molongena ⸤kote tendengendo⸥ mengo pungela. Aku siku tenge kene eno enono kanoko kondoko molayo. Nalo kote tendenge kinie kotena angilkulie kanu yema kinie kanu yema nokonge ye nomime kinie enone ‘Nanga ungumu piliengi!’ ningu eno ningu singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nalo eno ka siku kote tendenge kinie ‘Kotena nambolka unguri nimolonje? Olio ungu te walsiku pilinge kinie nambolka unguri topondopo nimolonje?’ ningu mini-wale naa mundengi. Aku tenge enamonga eno ungu ninge mele pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eno ungu ningema enono pilkulie naa ninge. Enonga ⸤mulu koleana molemo⸥ Lapanga Minimu enonga kerena molopalie nimbe simbe ungume enone anjo ninge kene konopu kimbu naa siku, pilinge mele niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“⸤Aku walemanga⸥ angenuni yunge angenu ⸤nanga yembo molombamonga⸥ ‘Kolopili toko kondangi.’ nimbe kote tendemba. Lapane yunge ambolangoma akula temba. Ambolangomane kepe enonga anupili lapali-kinie mumindili kolko kotena mengo puku “Toko kondangi.” ningela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nanga yemboma molongemonga yembomane pali eno-kinie konopu keri panjinge, nalo na munduku siye naa kolko walema pora naa nipili tondolo munduku molonge yemboma ⸤Pulu Yemone⸥ lipe tapondopa ‘Mindili nonge koleana naa puku pea molopo kondopo mindi pamili.’ nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kolea tenga yembomane ‘eno mindili nangi.’ ningu teko kenjinge kinie kolea tenga kowa pangi. Nane enondo paa sike nikirumu: Eno kolea Isirele sukundu koleamanga pali andoko nanga kongonomo teko pora naa sindengi Manie Omba Mana Ye A Lierimu Yemo ⸤kelepa yando⸥ ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mane sili ye te lombili puku ungume pilimele yemboma ‘Enonga mane silimu maniendopa, eno olandopa.’ manda naa ninge. Kendemande yembo tene ‘yunge nokoli yemo maniendopa, yu olandopa.’ manda naa lanimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lombili pupe ungume pilimo yembomo kinie yunge ungu mane silimo yemo kinie kapola kapola molembele akumu manda. Kendemande yembomo kinie yunge nokoli yemo kinie kapola kapola molembele akumu mandala. Ulke pulu yemonga ungu naa pilimele yembomane yu-kinie mumindili kolko iri tongendo ⸤kurumenga nomi Setenenga imbi manda manjiku⸥ “Yu Belsipuli” ningu imbi lemele kanumu. Pe kinié ulke pulu yemondo aku siku ningi liemo yunge ulkena pelemele yembomando pali paa awili teko olandopa ungu kerime ningela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“⸤Nanga opa puluemane na teko kenjilimele mele eno na lombili andoli yema sike teko kenjingela⸥ akumunge eno kanu yemboma pipili naa kolayo. Aki tolemo ulumenga telu kepe pe aki naa topa pali mona lemba. Lopi telemo ulumenga telu kepe pe lopi naa temba. Kanu ulume kinie ungume pali yembomane pali pilinge kene pipili naa kolangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nane enondo sumbulu toline nilio ungume pa teline nieyo. Ungu ólo toko ninge enono komune pilinge ungume ulke imune ola angilku ru ningu niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kangimu mindi toko kondokolie minimu manda toko naa kondonge yemboma pipili naa kolayo. ⸤Pulu Yemo mindi pipili kolayo⸥.. Yuni kangimu kinie minimu kinie peaselo tepe koleana manda topa kondomba kene yu mindi pipili kolaa. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Kera kalsindipele paa kangamo molemo, topo toko lingendo kera talo pea tene toya mele mindi pulimo kanumu. Nalo te kolopa we manie naa pulimo. Kanu kerama na lombili andoli yembomanga ⸤mulu koleana molemo⸥ Lapamone kanolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Eno ⸤na lombili andolime⸥., enonga penge indime kepe yuni koronga telu telu nimbe pali kambu torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Enonga ⸤mulu koleana molemo⸥ Lapamone aku sipe eno molemele mele kanopa mololipe pulimo kene ⸤‘Yembomane olio teko kenjinge.’ ningu⸥ pipili naa kolayo. Kera kalsindipele yu kou paa koltalo mele pulimo nalo kanu keramo Pulu Yemone kanopa molemo. Eno yemboma paa olandopa awilime kanopalie eno paa nokopa kondopa molomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yembo tene yembomanga kumbikerena ola angilipe “Na Yesusinge yembomo molio.” nimbé kinie nane Tata mulu koleana molemomonga kumbikerena ola angilipu “Kanu yembomo nanga yembomo.” nimbola. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nalo yembomanga kumbikerena “Yesusi yu naweye? Yu na naa pilkiru.” aku mele nimbé yembomo yu nane Tata mulu koleana molemomonga kumbikerena “Aku yembomo yu naweye? Yu na naa pilkiru.” nimbola. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“‘‘Ya mana yemboma opa naa teko telune kapola kapola molangi.’ nimbu orundu.’ konopu naa leangi. Eno yemboma ‘Taka liku molko kapola kapola molangi.’ nimbondo naa orundu. ‘Mumindili kolko opa teangi.’ nimbondo orundu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","‘Yembomane teangi.’ nimbondo orundu mele isipe: “Ye tene yunge lapa kinie opa tepili, lemenu tene yunge anumu kinie opa tepili, malo tenga menuni yunge bamu kinie opa tepili. Ulke telune pelemele yemboma opa pulue molonge.” ‘Aku teangi.’ nimbondo orundu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yembo tene na olandopa konopu naa mondopa, yunge lapa molo anumu olandopa konopu mondomba yembomo ‘Nanga yembomo molopili.’ nimbo kapola naa temba. Yembo tene na olandopa konopu naa mondopa, yunge malo molo lemenu olandopa konopu mondomba yembomo ‘Nanga yembomo molopili.’ nimbo kapola naa temba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yembo tene ‘Yu lombili pambo.’ nimbelie yemboma unjo perana angilku mindili nongo kolemele mele yuni unjo pera mele gomo lembando ‘Na yu lombili pumbondo mindili nondu liemo papula; kolondu liemo papula.’ naa nimu liemo ‘Nanga yembomo molopili.’ nimbo kapola naa temba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yembo te ya ma koleana ‘Na molopo kondopo, nondopo naa kolambo.’ nimbe pilimo yembomo kolopalie kolea kerine mindili nomba molopa mindi pumbe. Nalo yembo te na lombili andopa nanga kongonomo tendembando ‘Ya mana mindili nombo molombo kinie mandala, kolombo kinie mandala.’ nimbé yembomo konde molopa kondopa mindi pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Eno kolea tenga punge kinie yembo tene ‘Pea molamili waa.’ nimbe lipe tapondolemo yembomo na pea aku sipe lipe tapondolemo. Na ‘Pea molambili ou.’ nilimo yembomone na “Ma koleana pu.” nimbe lipe mundorumu yemo ‘Pea molambili ou.’ nilimola. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yembo tene Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo yembo te olemo kinie ‘Yu Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo yembo te kene’ nimbe pilipelie “Pea molambili ou.” nimbe lipe tapondolemo yembomo Pulu Yemone yunge ungumu nimbe silimo yembomo mele kalomba mele kanu lipe tapondolemo yembomo kepe telu sipe mele kalombala. Yembo tene Pulu Yemonga ungumu pilipe lipe konopu sumbi nipili molemo yembo te olemo kinie ‘Yu Pulu Yemonga ungumu pilipe lipe konopu sumbi nipili molemo yembo te kene.’ nimbe pilipelie ‘Pea molambili ou.’ nimbe lipe tapondolemo yembomo ⸤Pulu Yemone⸥ kanu yembo sumbi nilimu mele kalomba kinie yu lipe tapondolemo yembomo kepe telu sipe mele kalombala. ");
INSERT INTO ubu_kala_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yembo tene eno nanga lombili andoli yembo imbi naa mololi yembo te kanopa ‘yu nanga lombili andoli yembo te kene’ nimbe kanopalie yu lipe tapondopa we no kepe kolopa simu liemo nane eno paa sike nimbu sikirumu, kanu yembomo paa sike mele kalolimu limbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusini yu lombili andoli ye rurepondo yunge kongono tendenge mele mane sipe pora sipelie nirimumuni, yu kanu koleamo mundupe siye kolopa kolea Gallilli disiriki taonomanga andopa mane sipe ⸤Pulu Yemonga⸥ ungumu nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","⸤Pulu Yemone “Nanga yemboma nokopa kondomba ye te lipu mundumbo.” nimbe ou mako torumu ye nomi⸥ Kirasimuni ulu tondoloma terimumunge Jono ka ulkena pepa pilipelie nirimumuni, “Yesusindu i siku i siku walsiku pilindengi!” nimbe yu lombili andoli mare Yesusi molorumune lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kanu yema Yesusi molorumune ongo yu walsiku pilindikulie ningendo: “Pulu Yemone olio nokopa kondomba yere “Lipu mundumbo.” nimbe, nimbe panjerimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo te lupe ombámo nokopo molamiliye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusini enondo topondopa nimbendo: “Enone ya kanokomele mele kepe pilkimili mele kepe puku Jono ningu si-peyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mongo keri lieli yemboma mongone kanoko, kimbu keri lieli yemboma kapola andoko, kuru laká nolime umbu kangi angilipe, komu silime komuni pilku, kolopa lielime ola molemele kepe, koropa pulime temane peangamo topo silio pilimelela kanumu. Aku siku Jono ningu sieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na kanokolie ‘Yu sike kanu yemo molemo.’ ningu tondolo munduku pilkulie, altoko konopu talo naa panjiku molonge yemboma eno malo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jono lombili andolime punge puringi kinie Yesusini kelepa yembo awisili maku toko moloringimendo Jonondo nimbendo: “⸤Kolea ku lieline Jono no lindipe molorumu kinie⸥ eno kanu kolea ku lieline nambolka kanonge puringiye? Lkepanie mele poporomene lope-lope tendepa molorumu te kanonge puringiye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","⸤Molo kanumu. Alieli kanolemele mele kanonge naa puringi liemo⸥ ulu nambolkare kanongendo puringiye? Ye te mulumbale paa peangama pakopa molorumu-ne kanonge puringiye? Akumu molola. Yembo mulumbale paa peangama pakolemelema ye nomi kingimenga ulkena manjiku molemele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“⸤Aku sili te kanonge naa puringi liemo⸥ Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe sili ye te kanonge puringiye? Akumu sike nalo nane enondo nimbu sikiru: Jono yu sike Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe sili ye te nalo yu Pulu Yemone ungu umbu tondorumume pilipe nimbe sili ye we te molo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yuni Pulu Yemone ou “Lipu mundumbo.” nirimu yemonga aulkemo tepa mimi temu kanumu. Kanu yemondo Pulu Yemonga bokune sukundu molemo ungu te isipe: ‘⸤Pulu Yemone yunge Malondo nimbendo:⸥ “Pilieyo. Nanga ungu te nindimbe yemo nane nu puni aulkena yu kumbi lepo lipu mundukuru. Yuni nunge aulkemo akisindimbe.” nirimu.’ kanu ungumu bokune molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nane enondo paa sike nimbu sikirumu: Ou mana moloringi yembomanga te No Lindeli Jono kinie manda molo. Jono olandopa mele. Nalo kinié wale kondemo wendo okomo. Kanu walemo Pulu Yemo ye nomi kingi molopa nokolemo yembomanga te paa imbi naa molopa paa koropa puli yembomo olandopa; Jono yu maniendopa. ⸤Ou moloringi yemboma manie mele; kinié na ‘Sike.’ ningu tondolo munduku pilingemonga konopu peanga pemba yemboma olandopa.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Jono ou mana naa omba molopili ungu manema pelemo boku Mosisini torumume kinie, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siku bokune toringi bokume kinie, aku bokumene Pulu Yemonga ungume ningu siku, Jono kinie Pulu Yemone “Eno nokomba ye nomi te lipu mundumbo.” nimbe panjerimu yemo kinie ongele mele ungume niringi. Nalo Jono orumu kinie yandopa Pulu Yemo ye nomi kingi molopa yemboma nokolemo ulumu paa tondolo mundupe wendo omba yunge opa puluema topa manie mundulimola; ye enge nilimene aku ulumu ambolongendo tondolo munduku karaye teko linge tekemelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ungu te nimbo tekeromo pilimolo konopu linge liemo piliengi! Pulu Yemonga bokune “⸤Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe simbe ye⸥ Illainja ombá.” nirimu ye kanumu Jonondo nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inikiru mele komu angilimo yembomane paa mimi siku piliee!” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kinié mana molemele yemboma nambolka melte eno manda manjipu manda nimbonje? ⸤Eno molemele mele isipu nimbu siembo:⸥ Eno yemboma maku tolemele koleana ambolangoma pepe pereko molemele mele. Kanu ambolangomanga marene ne anjo molemele ambolango mare ⸤pea pepe pereko molonge aulke te koroko kelkolie⸥ enondo walsikulie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Konana nimulu kinie eno ‘Pea konana niemili.’ naa ningu “Molo.” ningi. Pe kelepo kola temulu kinie eno ‘Pea kola teamili.’ ni naa ningi. ⸤Pea pepe perepo molomolo aulke te molo lepamo.⸥” nilimele. ⸤Kinié molemele yemboma eno kanu ambolangoma mele molemele.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","⸤Na kinie No Lindeli Jono kinie oltone nilimbolo ungume enone pilku keri pilimele; telembolo mele kanoko keri kanolemelela⸥.. Jono ombalie ga kinie no waene kinie naa nomba molorumu kinie ⸤kanoko keri kanokolie⸥ ningendo: “Yunge konopune kuru te molemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pe Manie Omba Mana Ye A Lierimu Yemo omba ga kinie no waene kinie norumu kinie ⸤kanoko kerila kanokolie⸥ ningendo: “Yu ga awisili nomba keri pilipe, no waene awisili nomba kekelepa topa telemo yemo. Yu kou takisi lili yema kinie, ulu pulu keri telemele yembo wema kinie ‘Yu kinie pulu liepili pea tapu topo molamili.’ nimbe telemo.” nilimelela. ⸤Enone aku siku Jono kanoko kerila kanolemele. Na kanoko kerila kanolemele.⸥ Nalo pilipe konginjeli ulu pulumu Pulu Yemokinie pelemo-na yuni telemo temba mele kanokolie ‘Papu telemo.’ ninge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aku nimbelie Yesusi kolea ou andopa ulu tondolo awisili terimu koleamanga ⸤moloringi yemboma⸥ yuni terimu mele kanokolie enonga ulu pulu kerime kanoko keri kanoko munduku siye kolko konopu alowa naa teringi kanopalie yuni eno iri topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolea Korasini kinie Besaida taonoselonga ⸤molemele yemboma⸥ mindili nongo paa molko kenjinge! Kanu koleaselonga sukundu ulu tondolo awisili terindu ⸤nalo akune molemele yemboma konopu alowa naa telemele⸥.. Kolea awili Taya kinie Saidonoselonga sukundu ⸤ulu tondolo te naa terindu nalo kanu koleaselonga sukundu⸥ nane ulu tondolo aku sipu telka kanolemelanje kanu koleaselonga ⸤yembomane⸥ eno ulu pulu keri telemelema koronga munduku siye kolko, bulu siku, konopu alowa telemela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akumunge nane enondo nimbu sikiru: Pe kote walemo wendo ombá kinie kanu kolea Taya kinie Saidonoselonga ⸤yemboma ulu pulu keri telemelemonga⸥ enonga kote kanga mele pemba. Nalo eno kolea Korasini kinie Besaidaselonga ⸤yemboma nane ulu tondoloma terindu kinie kanokolie konopu alowa naa teringimunge⸥ kote walemo wendo ombá kinie enonga kote awili mele pemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapeniame taono ⸤yemboma enone⸥ ‘Mulu koleana pupu molamili.’ konopu lekemeleye? Aku manda molo. ⸤Enone nanga ungume alieli pilimele nalo konopu alowa naa telemelemonga⸥ eno kolea kerine puku molonge. Enonga koleana sukundu ulu tondolo awisili terindu ⸤nalo eno konopu alowa naa teringi⸥.. Kolea awili Sodomo sukundu ⸤ulu tondolo te naa terindu nalo kanu koleana sukundu⸥ nane ulu tondolo aku sipu telka kanolemelanje yemboma konopu alowa telemela, pe kinié kepe kanu koleamo we lelka. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akumunge nane eno ⸤Kapeniame yembomando⸥ nimbu sikirumu: Kote walemo wendo ombá kinie kolea Sodomo ⸤yemboma ou ulu pulu keri awisili sike teringi nalo⸥ enonga kote kanga mele pemba. Nalo eno kolea Kapeniame ⸤yemboma nane ulu tondolo terindume kanokolie konopu alowa naa teringi yemboma,⸥ kote walemo wendo ombá kinie enonga kote awili mele pemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aku walemanga Yesusini nimbendo: “Tata, Mulu Maselo Nokoko Moleno Ye Nomimu, nane nu-kinie ‘Ange’ nikiru. “Olio pilipe konginjeli pelemo. Olio oliolio ungumenga pulume pali pilipu kondolemolo.” ningu pilimele yemboma eno nane kinié telio ulumenga pulumu nuni ‘Naa piliengi!’ ningu naa ningu sirinu. Yembo ambolango pame mele molko nane nilio ungume komu tendeko molemele yemboma mindi nane telio ulumenga pulumu ‘Piliengi!’ ningu, eno ningu sirinu kanumunge nu kapi nimbu ‘Papu terinu.’ nikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sike, Tata, nuni ‘aku sipe wendo ombá kinie konopu simbo.’ ningu aku siku terinumunge ⸤aku sipe wendo okomo⸥..” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","⸤Pulu Yemondo aku sipe nimbelie kelepa yembo moloringimendo nimbendo:⸥ “Melema pali Tatane na sirimu. Yembo tene Malo paa sike molemo mele pilipe kanopa imbi silimo yembo te molo; Lapane mindi yu kanopa imbi silimo. Yembo tene Lapa paa sike molemo mele pilipe kanopa imbi silimo yembo te molo. Malone mindi kanopa imbi silimo; Malone ‘Lapa lipu ora siembo.’ nimbé yemboma eno Lapa kanoko imbi singela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Eno kongono mindili siku telemele yemboma kinie, konopune umbune telemo yemboma kinie, na moliona wayo. Onge kinie na pea konopu telune pumbemonga nane ‘Konopu pe nipili koro molaa.’ nimbo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nando “Nunge kongono teleno mele pea ambolambili. Nu nanga ungu mane silimu molani. Nunge ungu ninime pilipu lipu molambo.” ningu teayo. Na taka lipu molopo, yembomane na teko kenjilimele kinie pilipu siye kolopo molio-na inikiru mele eno na molombona ongo tenge kinie enonga konopume pe nimbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nanga kongono teliomo pea ambolombolo kinie taka liku teni. Mele pe nilime mindi silio kene boma moloringi. moliona wa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Walse, ⸤Juda yembomanga koro moloringi⸥ wale Sambate tenga, Yesusi kinie yu lombili andolime kinie rasi-witi poniemanga ongo puringi kinie yu lombili andoli yema engelene kolkolie rasi-witi mongo mare inie toko noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aku teringi kinie kanokolie Parisi yemane Yesusi yundu ningendo: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa teangi.’ nimbe pelemo ungu manemo nu lombili andoli yemane manemo pulue tokolie aku siku tekemele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesusini topondopa nimbendo: “Eno Pulu Yemonga bokune sukundu ⸤anda kolepa ye nomi kingi⸥ Depisini terimu mele nimbe molemo temanemo kanokolie temanemonga pulumu naa pilimeleye? Depisi kinie yu pea puringi yema kinie eno engelene kolkolie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Depisi Pulu Yemo molorumu sele ulkena sukundu pupe, Pulu Yemonga kumbi kerena lierimu pillawa kalolime lipe nomba, yu pea puringi yema sirimu noringila kanumu. Kanu pillawa kalolimendo Pulu Yemone ungu mane te sipelie nimbendo: “We yembomane paa naa nangi! Pulu Yemo popo tondoli yema manjiku nangi!” aku sipe mele nirimu ⸤kanu ungu manemo pulue torumu⸥ kanumu. ⸤Eno konopu talo nambemune lemeleye? Depisi yuni ou aku terimu mele eno pilku keri naa pilimelemonga pe kinié na lombili andoli yemane tekemele mele naa kanoko keri kanaa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ungu mane te pelemola. “Pulu Yemo popo tondoli yemane koro mololi wale Sambatemanga Pulu Yemonga ulkena kongono telemele kinie Sambate walemanga ungu manemo pulue tolemele nalo aku kongono telemelemonga mongo naa pemba.” nimbe molemo akumu naa lapilimeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nane enondo nimbu sikiru: Mele konde te kinié pelemo akumu Pulu Yemo popo toko kalemele ulke tembelemonga olandopamo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","⸤Pulu Yemone nirimu ungu te yunge bokune molemo mele isipe:⸥ “Enone yemboma kondo kolemele kinie kanopo peanga kanolio. Na popo toko kongime kalemele akumu uluri molo.” nilimo, akumunge ungu pulumu eno Parisi yemane pilimelanje iye ulu teko naa kenjikimili yema “Teko kenjikimili.” naa nilimela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Manie Omba Mana Ye A Lierimu Yemone Sambate walema nokolemo yemo molemo-na ⸤Sambate wale kinie yemboma molko kondongendo tenge mele manda nimbé kanumu⸥..” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kanu kinie Yesusi aku koleamo mundupe siye kolopa pupe Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke tenga purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kanu ulkena ye te molorumu, yunge ki te kamu kolopa kukorumu. Kanu kinie akune moloringi ye marene ‘Yesusini tepa kenjimbe kinie kote tendamili.’ ningu yu walsiku pilkulie ningendo: “Koro molemolo wale Sambate kinie yembo kuru tolemoma tepo konde limolo kinie manda molo aku temulu liemo Pulu Yemonga ungu manemo pulue tomoloye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesusini yemando topondopa nimbendo: “Sambate wale kinie ye tenga kongi sipisipi te murune topa manie mundumbe kinie sipisipi ari telemo yemone kundupe ola lipe memba naa ombáye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aku liemo sipisipi maniendopa mele, yemboma paa olandopa, akumunge Sambate wale kinie ulu peangama manda naa temoloye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aku nimbelie ki kolopa kukorumu yemondo nimbendo: “Nunge kimu sinio si.” nirimu kinie yemone yunge kimu sinio sirimu kinie yunge ki ekendo peanga lierimu mele ki keri lierimumu altopa kamu peanga lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nalo ⸤Yesusini aku terimu kinie kanokolie⸥ Parisi yemane pena puku maku toko “Yu nambepo topo kondomoloye?” ningu aulke te kororingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","⸤Parisi yemane⸥ yu tonge teringi pilipelie Yesusi aku koleamo mundupe siye kolopa purumu. Kanu kinie yembo awisili Yesusi purumu mele yu lombili puringi kinie yuni yembo kuru torumume pali tepa konde lipelie ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nimbendo: “Na sike yemo molopolie iulu tondoloma tekero mele enone yembo lupe marendo naa ningu siee!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aku sipe wendo orumumunge koronga-ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Aisayane nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“I yemo nanga mako torundu kongonomo tendeli yemo; nane iyemo konopu mondopo, yu kanopo paa peanga kanolio yemo. Nanga Minimu yunge konopune panjindimbo. Yuni ma koleana yemboma pali nane eno sumbi sipu nokombo mele nimbe simbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yembomane yu iri tonge kinie yuni topondopa ungu te naa nimbe, ungu te tondolo mundupe naa nimbe, yemboma andoko molemele koleamanga yuni opa ungu naa nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kamaye enge naa nilimo te elke naa topa, tepe-llame mimi sipe naa nolemo kinie kamu topa naa kumundumbe. ‘Pulu Yemone yemboma kamu sumbi sipe nokomba walemo kamu wendo opili.’ nimbe yu aku sipe naa tepa taka lipe molomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanu kinie mana yemboma pali ‘Yuni ‘olio mongo naa liemili.’ nimbe lipe tapondomba.’ ningu molonge.” nirimu ungu akumu wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kanu kinie ye te yunge konopune kuru te molorumu-ne mongo keri lepa melema naa kanopa ungu naa nirimu ye te Yesusi molorumune mengo oringi kinie Yesusini yemo tepa konde lsimu kinie kanu yemo ungu nimbe melema kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aku terimu kanokolie yembomane pali mini-wale mundukulie ningendo: “I yemo ye nomi kingi Depisinge malonje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nalo aku niringi ungumu pilkulie Parisi yemane ningendo: “Molo. Kurumenga nomi Belsipuli mindi iye Yesusinge konopune molopalie yu tondolo silimo-na yuni kurume topa makorolemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Enone aku siku konopuni pilieringi mele Yesusini pilipelie ⸤‘Yesusi ‘Setene-kinie opa pulue moloringimunge ‘Setenene yu naa lipe tapondolka.’ ningu paa piliengi!’ nimbe⸥ enondo nimbendo: “Yembo talape te konopu telune naa pupili molko suku-singine owe panjiku eno enono opa teko lupe lupe molemele kinie kanu talapemo pora nilimo. ⸤Molo⸥ kolea tenga yemboma molo ulke telune pelemele yemboma konopu telune pupili naa molko eno enono opa telemele kinie kanu yembo talapemo sungu siku yu-mele-mele molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aku sipela, Setenene yunge kuru te makorolkanje aku telkamonga yunge talapemo kinie opa mele telka. Pe yunge talapemo nambepa kapola molemelaye? ⸤Pora nilke.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Ungu te piliengila! Nane Belsipulinge tondolomone kurume makorolio liemo enonga yemane nainge tondolomone kurume makorolemeleye? Akumunge ⸤enonga ye kurume makorolemele yemane ‘Pulu Yemone olio tondolo silimo-na olione kurume makorolemolo.’ ningu pilimele-na⸥ enone nando inikimili ungume kanu yemane pilku apurukulie “Eno kolo tokomele.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nalo sike Pulu Yemonga Minimuni na tondolo silimo-na nane kurume makorondu liemo Pulu Yemo ye nomi kingimu molopa yemboma nokomba walemo eno molemelena koronga wendo omu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ungu te pea isipe: Ye enge nili tene yunge ulkemo nokopa kondolemo kinie ye tene we manda sukundu omba melema wa lipe meli pulimoye? Akumu manda molo. Ou wa noli yemone ye enge nilimunge kimbu kime ka topalie yunge ulkena manda omba melema wa limo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na naa lipe tapondolemo yembomone na-kinie opa pulue molemo. Yembo tene na lipe tapondopa ⸤kongi sipisipime⸥ sukundu naa limo yembomone ⸤kongi sipisipime⸥ topa bulu-balo silimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Akumunge nane enondo nikiru: Yembo tene ulu pulu kerime tepa, ungu taka tondopa nimbe kenjilimo ulume Pulu Yemone manda ‘Manie pupili.’ nimbe siye kolomba. Nalo yembo tene Pulu Yemonga Minimu nimbe kenjipe ungu taka tondomba ulume Pulu Yemone ‘Manie naa pupili.’ nimbe siye naa kolomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Manie Omba Mana Ye A Lierimu Yemo ungu taka tondopa ungu nimbe kenjilimo yembomo aku sipe ulu keri telemoma Pulu Yemone ‘Manie pupili.’ nimbe siye kolomba. Nalo Mini Kake Telimu⸤ni ulu te telemo kinie⸥ yembo tene ungu taka tondopa, opa tepa sipe ⸤“Yuni naa tekemo. Kurumenga nomi Setenene yu lipe tapondolemo-na aku telemo.”⸥ nilimo yembomo aku sipe ulu keri telemomo kinié kepe mulu ma pora nimbé wale kinie kepe ‘Manie naa pupili.’ nimbe paa siye naa kolomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Unjo peanga te kanokolie ‘Mongo peangama tomba nomolo.’ ningu kanolemele. Unjo keri te kanokolie ‘Mongo kerime tomba manda naa nomolo.’ ningu kanolemele. Unjo te mongo tolemo kinie kanokolie ‘Iunjomo peanga, iunjomo keri.’ ningu apuruku kanolemelemonga aku siku ningu kanolemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Eno Parisi yema, kolo topa yemboma tepa kenjeli wambiyemonga waloma, eno ye keri molemelemane nambeko ungu peangama manda ningeye? Yembo te yunge konopune pelemo ungume mindi kerena nilimo akumunge eno ye kerimene nambeko ungu peangama manda ningeye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aku sipe mele, yembo peanga tene yunge konopune ulu peanga pelemoma telemo, nalo yembo keri tene yunge konopune ulu keri pelemoma telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Akumunge nane enondo nimbu sikirumu: Pulu Yemone yemboma kote tendemba walemonga enono ungu nilimelema apurupe pilipelie “Nu yembo peangamo, nu yembo kerimu.” nimbé akumunge yembomane mana we ungu nilimelema pali kepe apurupe pilipelie “Aku ungume nambemune niringiye?” nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kanu kinie Parisi ye mare kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi ye mare kinie enone Yesusindu ningendo: “Ungu Mane Silimu, ‘Nu sike Pulu Yemone ‘Kongono tendani.’ nimbe mana lipe mundorumunje olio kanamili.’ ningu Pulu Yemone mindi manda ulu tondolo telemo mele te tei.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesusini topondopa nimbendo: “Kinié mana molemele yemboma keri mindi molemele. Eno teko kenjiku Pulu Yemo liku su silimele yembomane “Pulu Yemone mindi ulu tondoloma manda telemo mele kanamili tei.” ningu na mawa telemele. Nalo ⸤Pulu Yemone na lipe mundorumu-ne ombo molkoro. Yu kinie tapu topo kongono telembolo mele lipe ora simbe ulu⸥ tondolo te wendo naa ombá. Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Jona-kinie wendo orumu ulu akumuni mindi lipe ora silimo manda kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oma awili tene Jona topa penge mundorumu kinie yu omamonga olona ipulueli tangoli wale yepoko molopa perimu ⸤kinie omamone yu nomu kélona meku topa wendo mundorumu kinie yu altopa we molorumu⸥ mele Manie Omba Mana Ye A Lierimu Yemo ⸤ono teko panjinge kinie⸥ aku sipe ipulueli tangoli wale yepoko mana sukundu pepalie ⸤lomboropa ola molomba⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ou kolea awili Ninipa yemboma ⸤sike molko kenjeringi nalo Pulu Yemone ungu umbu tondorumu mele⸥ Jonane ⸤pilipe⸥ Ninipa yemboma pupe nimbe sirimu kinie pilkulie teko kenjeringi mele kanoko keri kanoko konopu alowa teko molko kondoringi. Aku teringimunge kinié molemele yembomane Jonanga olandopa ye te ya molemo yemonga ungumu liku su siku naa pilimelemonga kote walemo pe wendo ombá kinie Ninipa yembomane kotena angilku, kinié molemele yembomando “Teko kenjeringi. Mindili nonge kinie papu.” ninge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ou olio Isirele yembomanga ye nomi kingi Sollomono yu ye paa tondolo te molopa, yu ungu lupe lupema pilipe konginjelimu pepili molorumu mele kolea Sipa nokorumu ambo nomi kuinimu pilipelie, Sollomonone ungu peangama mindi nirimu mele pilimbendo yu kolea sulune molopalie ⸤Sollomono molorumune⸥ wale awisili aulkena pelipe orumu. Aku sipe terimumunge, ye nomi Sollomononga olandopa ya molemo yemone nilimo ungumu kinié mana molemele yembomane naa pilku, liku su silimelemonga kote walemo wendo ombá kinie kolea Sipa ambo nomi kuinimuni nimbendo: “Nane Sollomonone ungu peanga nirimu mele pilimbondo aulke sulune orundu nalo Sollomononga olandopa molorumu yemone nirimu ungumu eno naa pilku, liku su siringi yemboma aku teringimunge eno papu mindili nonge.” nimbé.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kuru te ye tenga konopune wendo ombalie, no naa mololi koleamanga pupe manda koro molomba kolea te korolemo. Te naa kanopa lendepalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yuni nimbendo: “Na ou molopolie wendo ondu ulkena kelepo pambo.” nimbe yu omba yu ou molopa purumu ulkemo kanolemo kinie ulke puri memba tepa peanga tepa we lepa yembo te naa molemo kinie kanopalie nilimomone, ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yu kelepa anjo pupelie kuru kara puli paa olandopa yepoko pakera lipe memba omba eno pea kanu ulkena sukundu puku molemele. Kanu kinie kanu yemo ou molopa kenjilimo nalo pe paa kamu olandopa mele molopa kenjilimo. Aku sipe kinié ya teko kenjiku molemele yemboma pe kamu molko kenjinge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesusi yembo maku toko moloringime ungu mane sipe molopili yunge anumu kinie angenupili kinie yu-kinie ungu ningendo ongo pena angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yembo tene yundu nimbendo: “Aminie kinie angenali kinie enone nu-kinie ungu ningendo ongo pena angilimele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesusini yundu topondopa ⸤ungu iko topalie⸥ nimbendo: “Nanga anumu naweye? Nanga angenupili nameleye?” nimbelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","yu lombili andoli yemboma lipe ora sipelie nimbendo: “I yemboma nanga anumu kinie nanga angenupili kinie molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nanga Lapa, mulu koleana molemomone “Teangi.” nilimo mele pilku liku telemele yemboma nanga anumu kinie nanga angenupili kinie nanga kemulupili kinie molemelemonga aku sipu nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yembo maku toko moloringimendo aku sipe nimbe pora sipelie nirimumuni, Yesusi ulkena molopa pena pupe nomu kélona pupe manie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yembo paa awisili yu molorumune ongo maku toko moloringimunge nona andoli sipi te nona ola lierimumunge suku pupe manie molorumu, yemboma nomu kélona angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yuni enondo ungu awisili nimbe simbendo ungu iko pokore torumu. Ungu iko te isipe topalie nimbendo: “Pilieme! “Ye tene rasi-witi umbu poniena andopa tanda sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tanda silipe andorumu kinie umbu mare aulkena manie purumu, kanume keramane ongo liku noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Umbu mare kou perimune manie pupelie ma wallo kolte mindi lierimu kulu nondopa muli topa wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nalo pulkinio naa mundorumu kulu ena terimu kinie kanume kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Umbu mare kombulu-siri ka mélemo molorumune manie purumu, siri ka melemo wendo omba witi umbume topa norumu kulu omba peanga naa lepa ⸤mongo te naa torumu⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Umbu mare ma peangana manie purumume wendo omba mongo peangama torumu. Mare mongo tokapu kise mele topa, mare mongo tokapu yepoko mele topa, mare tokapu telu mele torumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","⸤Aku nimbelie⸥ “Yembo komu-peo lemomane iungumu piliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesusi lombili andolime yu molorumune ongolie yundu ningendo: “Nu yembomando ungu te ninindu ungu ikoma alieli nambemune tolenoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yuni enondo topondopa nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma kinie melema kinie nokolemomonga ulu pulu yu yuyu pilierimu kanu ulu pulume ‘Kinié eno ⸤na lombili olemele yemboma⸥ piliengi!’ nimbelie eno nimbe sikimu. Nalo we yemboma nimbe naa sikimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pulu Yemonga ungumu pilku molemele yemboma paa olandopa nimbe simbe pilinge. Pe paa awisili pilinge. Nalo naa pilku molemele yemboma eno laye kolte pilimele ungumu kepe wendo limbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","‘Eno mongone kanokolie naa kanoko, komuni pilkulie naa pilimele.’ akumunge nane we yemboma enondo ‘Ungume nimbu siembo.’ nimbulie ungu ikoma mindi topo silio. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Aku siku teko molemelemonga koronga-ou Pulu Yemone ungu umbu tondorumume yemboma nimbe sirimu ye Aisayane “Aku siku tenge.” ou nirimu mele wendo olemo. Aisayane nimbendo: “Enone alieli komuni pilinge nalo konopuni pilkulie paa naa pilinge; mongone kanonge nalo melte paa sike naa kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iyembomanga konopume paa pipi silimo; enone ungu pilingendo komu naa tendeko molemele; enonga mongoma kumbulku molemele. Aku siku teko molemelemonga naa kanoko naa pilku molemele. Iulume aku sipe naa telkanje enone enonga mongone kanoko komuni pilku konopuni pilkulie alowa telemela, kanu kinie nane ‘Eno konde pangi.’ nilke.” nirimu. ⸤Aisayane aku sipe nirimu mele⸥ aku siku kiniéweyemboma teko molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nalo ⸤na lombili andolime⸥ enone mongone paa sike kanoko komuni paa sike pilku molemelemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nane enondo paa sike nimbu sikirumu: Oumoloringi yemboma, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema kinie, Pulu Yemonga ungume pilku liku sumbi siku moloringi yemboma kinie, kanu yembo awisili kinié eno mongone kanoko molemele melema kinie ulume kinie kanongendo “Kanamola!” ningu moloringi nalo naa kanoringi. Eno kinié komuni pilku molemele ungume pilingendo “Piliemola!” ningu moloringi nalo naa pilieringi akumunge ⸤nane ‘Kinié sike kanoko sike pilimelemonga eno malo.’ nikiru⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Akumunge, yembo tene rasi-witi umbu tanda sirimu ungu ikomonga pulumu kinié niembo pilieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","⸤Umbu mare tanda sirimu aulkena manie purumu kanumenga ungu pulumu isipe:⸥ Yembo tene Pulu Yemo ye nomi kingimu molopa melema nokolemomonga ungumu pilipelie naa pilimo kinie ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥.muni omba umbu tanda sili konopune pupe pelemoma walsikele toropa wendo limo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Umbu mare tanda sirimu kou perimune manie purumume yembo mare aku silime molemele. Enone ungumu pilkulie walsikele sumbi siku konopu siku pilku limele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nalo eno pulkinio naa mundukulie ungumu laye kolte mindi pilku molemele. Pe eno konopune umbune telemo kinie molo eno Pulu Yemonga ungumu pilku liku molemele mele yembo lupemane kanoko keri kanokolie ungu taka tondoko teko kenjiku mindili silimele kinie enonga pilimele ungume siye kolemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Umbu mare tanda sirimu siri ka mele molorumune manie purumume yembo mare kepe aku silime molemele. Enone ungumu pilimele kinie konopune umbune telemo umbunema kinie, mele awisili nosikulie ‘Aku melemane olio lipe tapondolemo tapondomba.’ ningu pilku molemele ulume kinie, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinie ungumuni uluri naa tepa langi mongo naa tolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Umbu mare tanda sirimu ma peangana manie purumume yembo mare aku silime molemele. Enone ungumu pilkulie ungu pulumu pilku kondolemele. Pe eno langi mongo tolemele. Kanu yembo marenga langi mongo tokapu kise mele topa, yembo marenga mongo tokapu yepoko mele topa, marenga mongo tokapu telu mele topa, aku sipe tolemo. Ungu ikomonga ungu pulumu aku sipe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesusini ungu iko te pea yemboma topa sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa melema nokolemo akumu isipe mele: Ye tene yunge poniena rasi-witi umbu peangama tanda sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nalo yemboma uru peringi kinie yunge opa pulue ye te omba era ⸤rasi-witi none teli era⸥ umbu te witi poniena tanda sipelie kelepa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kanu kinie umbu peangama wendo omba witi mongo torumu kinie era kinie pea wendo orumu mele mona molorumu kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kanu kinie ponie pulu yemonga kongono tendeli yema ongo yundu ningendo: “Awilimu, nunge poniena langi umbu peangare tanda naa sirinuye? Pe kinié era nambepa wendo okomoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yuni enondo nimbendo: “Tena. Opa pulue ye tene aku era umbume omba tanda sirimu lepamo.” nirimu. Kongono tendeli yemane ningendo: “‘Era pea waka-maka wendo okombele kene pupu erama akupu lipu maku tamili.’ konopu lekenoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nalo yuni nimbendo: “Molo. Era tengi liemo witi pea pulu akungenje. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pe witi kamu lipu maku tomolondo ou pea ongolo molangili. Pe witi kamu limolo walemo wendo ombá kinie nane witi kari leko lindinge yembomando nimbondo: “Ou era kalongendo liku piye teko maku tokolie ningemone, pe witi liku nanga witi nosilio ulkena maku toko nosiengi.” nimbo.” nirimu.” nimbe, Yesusini “Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu aku sipe mele.” nirimu. Ungu Ikomo Kinie Pillawa Akoli Mele Isimunge Ungu Ikoselo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ungu iko te pea yemboma topa sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipe mele: Ye tene unjo masetete umbu te lipe ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","yunge poniena umbumu mundorumu. Masetete umbu akumu langi umbumenga pali yu paa kelomo nalo wendo omba awi lemo kinie poniena molemo melemanga pali yu paa awilimu. Kamu awi lepa unjo mele angilimo kinie kerama kanu unjona ongo kolamanga pelemele. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe⸥..” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ungu iko te pea yemboma topa sipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipe mele: Ambo tene yu langi pillawa akoli mele isi wallo kolte pillawa awisilinge mundorumu kinie pillawa pali akorumu. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe⸥..” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kanu ungume pali Yesusini yembomando nimbendo yu ungu iko mindi topa nirimu. We ungu te enondo sumbi sipe naa nimbe ungu iko manjipe topa nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aku sipe terimumunge koronga-ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye tene ou nirimu ungu te kamu wendo orumu. Akumu isipe: “Nane i⸤ungu nimbondo⸥ ungu iko ⸤manjipu⸥ topo nimbo. Pulu Yemone ou mulu maselo terimu kinie kepe yandopa yandopa kepe ⸤mona naa niringi⸥ lopi tepa perimu ungume ⸤nimbondo ungu iko mindi topo⸥. nimbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","⸤Yesusini ungu iko akume topa pora sipelie,⸥ yu maku toko moloringi yemboma mundupe siye kolopa ulkendo purumu kinie yu lombili andolimene yu molorumune ongolie ningendo: “Poniena era orumu ungu ikomonga ungu pulumu olio ningu para si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yuni topondopa nimbendo: “Langi umbu peangama tanda sirimu yemo Manie Omba Mana Ye A Lierimu Yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Poniemo ma kolea pali. Langi umbu peangama yembo ‘Pulu Yemo nanga ye nomi kingimu molopili.’ nilimelemonga enonga konopumenga Pulu Yemone tapu tepa molopa nokolemo yemboma. Era umbu akume ulu kerimenga pali ulu pulumu pelemo ⸤kuru⸥.munge yemboma. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Era umbu tanda sirimu opa pulue akumu ⸤kurumenga nomi⸥ depelemo. Witi sukundu liku maku tonge wale akumu ma kolea pora nimbé walemo. Witi mongoma sukundu linge yemboma mulu koleana angelloma. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Erama liku maku tokolie tepena kalemele mele ma kolea pora nimbé walemonga aku sipe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Manie Omba Mana Ye A Lierimu Yemone yunge angelloma lipe mundumbe, enone ‘Yemboma Pulu Yemonga ungume naa pilku, teko kenjiku molangi.’ nilimele yemboma pali kinie, ulu pulu keri telemele yemboma pali kinie, Pulu Yemone tapu tepa molopa nokolemo yemboma molongena wendo liku maku tokolie ningemone, ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tepe awili nomba pelemo koleana sukundu toko mundunge, kanune yemboma kola teko paa mindili nongo pereko molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kanu walemanga konopu sumbi nili yemboma enonga Lapa ye nomi kingimu molopa nokolemo koleana ena pa telemo mele eno aku siku kanune pa tepili molonge. “Yembo komu-peo lemomane iungumu piliee.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","⸤Yesusini aku nimbelie kelepa nimbendo:⸥ “Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipe mele: Sumele ombele te laku teko ponie tenga ou lopi teringi we perimu kanumu ye tene pe walse kanopa lipelie kelepa aki torumu. Aki topalie konopu sipe pupe yunge melema pali lipe makete tepa kou pokore yando lipelie kanu poniemo pupe topo topa yando lsimu. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipela: Kou-bisinete teli ye tene siripelu ‘pélle’ nili peangama koropa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kanu kinie siripelu pélle kou paa awisili puli te kanopalie nirimumuni, yu pupe yunge melema pali makete tepa kou yando lipelie kanu siripelu péllemo topo topa yando lsimu. ⸤Pulu Yemo ye nomi kingimu molomba mele aku sipe.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipe melela: Oma lili wale te nomune toko mundoringi kanumuni oma lupe lupema lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Walemo paa peke lierimu kinie kunduku liku nomu kélona nosikulie, manie molko apurukulie peangama liku wale basikete pokorenga mundoringi nalo kerime toko lteringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Ma koleamo pora nimbé walemonga aku sipela: Mulu koleana angelloma ongolie ningemone, yembo teko kenjiku molongema kinie yembo sumbi siku molko kondongema kinie liku apuruku ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yembo teko kenjiku molongema liku tepe awili we nomba pelemo koleana toko suku mundunge, kanune kola teko paa mindili nongo pereko molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","⸤Ungu ikoma topa pora sipelie Yesusini lombili andolime walsipe pilipelie nimbendo:⸥ “Aku ungume pali ungu pulume eno piliengiye?” nirimu. Enone yundu ningendo: “Piliemulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yuni enondo nimbendo: “Aku liemo Pulu Yemonga ungu manemanga pulume pilku mane silimele yemane Pulu Yemo ye nomi kingimu molopa yemboma nokolemomonga ungume mane silimolo kinie pilku liku molemele kanu yema eno isipe: Ulke pulu ye tene yunge mele peanga kande kande nosilimomanga mele kondema kinie mele oume kinie pea wendo limo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusini aku ungu ikoma topa pora sipelie kanu koleamo mundupe siye kolopa yu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mundupe siye kolopa pupelie yunge pulu kolea ⸤Nasarete⸥ ombalie Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkena suku pupe yemboma mane sirimu kinie pilkulie eno suru ningu mini-wale mundukulie ningendo: “I yemo yunge pilipe konginjelimu kinie yunge ulu tondolo telemomanga tondolomo kinie yu tena lsimuye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yu ulkema takorumu yemonga malo moloye? Maria yunge anumu naa molemoye? Jemisi keme, Josepo keme, Saimono keme, Judasi keme, yunge angenupili moloye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yunge kemulupili kinie pali olio kinie pea naa molemoloye? ⸤Yu paa sike aku yemo molemomo⸥.. Aku liemo yunge pilipe konginjelimu kinie yunge ulu tondolo telemomanga tondolomo kinie yu tena lsimuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","⸤Aku siku ungume ningu⸥ yu ungu nimbe ulume tepa molorumu mele kanoko keri kanoko yu-kinie paa konopu keri panjeringi. Kanu kinie ⸤eno yu-kinie mumindili koloringimunge ulu pulumu pilipelie⸥ Yesusini enondo nimbendo: “Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye te koleamanga pali imbi ola molemo, yembomane pali yunge ungume pilku limele. Nalo yunge pulu koleana yu kinie pea tapu toko molemele yemboma mindi yuni nilimo ungumu pilkulie ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo ungume naa pilku, liku su silimele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kanu kinie yu ⸤ungu nimbe ulume tepa yu yuyu molorumu mele ‘Sike.’ ningu⸥ tondolo munduku naa pilieringimunge yu kanu koleana ulu tondolo awisili naa terimu, koltalo mindi terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kanu walemanga kolea Gallilli disiriki nokorumu ye nomi kingi Erotene Yesusini terimu mele temane toringi pilipelie ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yu-kinie tapu toko molko yu liku tapondoringi tapu yemando nimbendo: “I ulume telemo yemo No Lindeli Jono lepamo! Yu kolopalie lomboropa wendo omumunge ulu tondoloma temba tondolomo yu-kinie pelemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","⸤Kingi Erotene aku sipe nirimu ungumunge pulumu isipe:⸥ Ou walse Erotene yunge angenu Pillipunge ambo menu Erodiasi mangopa lsimu. ⸤No Lindeli⸥ Jonone Erote aku sipe terimu kanopalie yundu alieli nimbendo: “Nuni ⸤Pulu Yemonga⸥ ungu mane te pulue toko angenanga ambomo mangoko lsinu. Akumu teko kenjerinu.” nirimu kinie Erotene yu lipe ka sipe ka ulkena panjerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka ulkena panjipelie ‘Yu topo kondambo.’ konopu lierimu nalo we yembomane ‘Jono yu Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye te molemo.’ ningu kanoringimunge yu pipili kolopalie Jono topa naa kondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe walse kingi Erotenga meringi walemo wendo orumu kinie Erodiasi lemenu ulkena sukundu omba, yema maku toko kanoko molangi yu denisi terimu. Erotene ambo wenepomo aku terimu kanopa paa peanga kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yundu nimbendo: “Nando “Si.” nini melemo paa sike simbo.” nimbe, nimbe panjipe Pulu Yemonga imbi lepa mi lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yuni aku sipe nirimu-ne anumuni pilipelie lemenu ungu te nimbe sirimu kinie pilipelie ambo wenepomone Erotendo nimbendo: “No Lindeli Jononga ⸤nomimu karu leko yunge⸥ pengemo pellete tenga nosiku yando si.” nirimu. ⸤Jonone ou alieli “Erote kinie Erodiasiselone teko kenjeringili.” nirimumunge mumindili kolopalie Erodiasini ‘Yu kolopili. Sike kolomunje na kanambo.’ nimbe “Pengemo ongo si.” nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Yuni aku sipe mele mawa terimu-ne pilipelie Erote konopu umbune terimu nalo yuni “Paa sike simbo.” nimbe, nimbe panjipe Pulu Yemonga imbi lepa mi lierimu mele kepe, yu konopu alowa temba kinie yu-kinie pea langi nongo moloringi yema yu kanoko keri kanonge mele kepe, aku uluselo pilipelie, ka ulkena nokoringi yemando ungu te nimbe mundupelie “Yuni mawa tepa “Si.” nikimu mele siengi kene ⸤No Lindeli⸥ Jononga ⸤nomimu karu leko yunge⸥ pengemo yando mengo waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aku nirimu kinie pilkulie Jono toko kondoko, yunge pengemo pellete tenga nosiku, yando mengo ongo ambo wenepomo siringi kinie yuni lipe anumu molorumune memba pupe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aku teringi pilkulie Jono lombili andoringi yema ongo yunge onomo liku mengo puku ono tekolie Yesusi molorumune puku temane toko siringi. ⸤Kingi Erotene No Lindeli Jono ou aku sipe topa kondorumu kolorumumunge pe Yesusini ulu tondoloma terimu mele pilipelie “Jono nomi karu lierindu yemo lomboropa ola molemo lemo.” nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","⸤Ye nomi kingi⸥ Erotene No Lindeli Jono topa kondorumu pilipelie nirimumuni, Yesusi yu molorumu koleamo mundupe siye kolopa ‘Tenga nanu molambo.’ nimbe nona andoli sipi tenga sukundu pupe nomu ⸤Gallilli⸥ nekendo pupe kolea ku lieli tenga yuyu pumbe purumu. Nalo yembo awisili yu aku terimumu pilkulie enonga koleama munduku siye kolko kimbu kongono teko nomu kélona makaye teko puku yu purumune akiliku lombili puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesusi no kélona ombalie yembo paa awisili akune maku toko moloringi kanopalie eno kondo kolopa enonga kuru torumume ‘Konde pangi.’ nimbe eno tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pe ipupene ena pumbe terimu kinie yu lombili andolime yu molorumune ongo yundu ningendo: “I koleana yembo te naa pelemo, ena kamu pukumu kene ya maku toko molemele yemboma ‘Puku kolea marenga langi topo toko li-pengi.’ ni.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nalo yuni yu lombili andolimendo topondopa nimbendo: “Nambemune ‘yembo akume ‘We pangi.’ niembo.’ ningu nikimiliye? Enone enono yemboma langi mare liku siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Enone yundu ningendo: “Ya langi awisili molo. Pillawa kaloli kanga kise pakera kinie oma kaloli talo kinie aku langi pokore mindi lemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yuni “Na moliona yando mengo waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kanu kinie yembomando “Erana manie molaa.” nimbelie yuni kanu pillawa kaloli kise pakera kinie oma talo kinie lipelie mulu koleana olando sipe kanopa ⸤Pulu Yemo kinie⸥ “Ange.” nimbe pillawa kalolime ambolopa pike lepa ⸤oma kinie⸥ lombili andolime moke tepa sipelie “Anjo yemboma siee.” nirimu, enone yemboma moke teko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eno pali kanu langime noringi kinie olo terimu. Pe lombili andolimene langi goli lierimume liku maku toko wale-basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Langi noringi yema manjipe pape tausini mele. Ambo ambolango ⸤mare pea langi noringi⸥ akume olandopa. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","⸤Yemboma langi sirimu noringi⸥ kinie Yesusini yu lombili andoli yemando sumbi sipe nimbendo: “Maku toko molemele yemboma nane “Pangi.” niembo. Eno nona andoli sipine ola puku no nekendo kumbi leko paa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yembomando “Paa.” nimbelie yu yuyu Pulu Yemo kinie ungu nimbendo ma pangine ola purumu. Kanu kinie ena pupe kolea kala torumu kinie akune yuyu molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sipimu no nekendo pumbendo nomu awi suku singine kokele pumbe purumu kinie sipi kumbikundu mendo sipe poporomene topa, nomu torumula kinie nomo ola pupe manie omba terimu, sipimu topa ola-munde manie-munde tepa topele-mapele torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kanu kinie ipulueli kolea muni naa liepili ⸤yu lombili andolime sipine ola molko⸥ puringine Yesusi nona ola kimbu kongono tepa ombá orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Enone yu nona ola kimbu kongono tepa orumu kanokolie niringimuni, pipili awili teko kolkolie “Kuru te okomaa!” ningu mini-wale mundoringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesusini tamburumbu enondo nimbendo: “Eno konopu tondolo pupili molayo. Namindi okoro. Pipili naa kolaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","⸤Yuni aku nirimu pilieringi kinie⸥ Pitane topondopa nimbendo: “Awilimu, akumu sike nu nunu onu liemo nu okonona na nona ola angilipu wambo walsei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yuni “Ou.” nirimu kinie Pita sipine ulsu pupe pukue topa nona manie pupelie nona ola kimbu kambilipe Yesusi molorumune pumbe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nalo poporome tondolo torumu kinie kanopalie pipili kolopa yu no wangomba tepalie, “Awilimu, na liku tapondou!” nimbe ru nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kanu kinie Yesusini ki sinio sipe mundupe Pita kundupe ola lipelie yundu nimbendo: “Nane ulu telioma nu wallo kolte mindi pilino lemo. Ou ‘Yuni na lipe tapondomba, sike nona ola manda pumbo.’ konopu lekolie altoko konopu alowa nambemune teko ‘Na no wangombonje?’ ningu pilienuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sipine suku puringili kinie poporome topa kelierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aku terimu-ne kanokolie sipine suku moloringi yemane Yesusinge imbi liku ola mundunduku kapi ningu “Nu paa sike Pulu Yemonga Malo lepamo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kanu kinie ⸤Yesusi kinie yu lombili andolime kinie⸥ nomu ⸤Gallilli⸥ nekendo pukulie nomu kélona kolea Geneserete lierimune wendo oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","⸤Kanu koleana sipine manie oringi kinie⸥ akune moloringi yemane Yesusi kanoko imbi sikulie akundu lierimu koleamanga moloringi yemboma pali ningu mundoringi kinie yembomane kuru torumu yemboma pali yu omba molorumune mengo ongolie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“‘Nunge wale pakoli pundumu kepe ambolangi.’ ni.” ningu mawa teringi. Kanu kinie kuru torumu yembomane yunge wale pakolimu amboloringi yemboma pali kamu konde puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kanu kinie Parisi ye mare kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi ye mare kinie eno Jerusalleme munduku siye kolko Yesusi molorumune ongo yu walsiku pilkulie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Olionga anda kolepalimene “Teaa.” niringi ungu manemo nu lombili andolimene nambemune pulue tolemeleye? ⸤Anda kolepalimene “Teaa.” niringi mele mimi sipu pilipulie olione kíme kulumiye tolemolo mele⸥ enonga kíme aku siku kulumiye naa toko langi we nolemele kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesusini topondopa nimbendo: “Enone kepe enonga anda kolepalimene “Teaa.” niringi mele mindi pilku liku tengendo Pulu Yemonga ungu manema nambemune pulue tolemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akumunge Pulu Yemone nimbendo: “Aminieli lanielinge ungume pilku liku, liku awi siku teaa.” nimbe “Yembo tene yunge anumundu molo lapando ungu te nimbe kenjipe iri tomu liemo kanu yembomo toko kondangi.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nalo eno yemane ningendo: “Yembo tene yunge anumu lapaselondo nimbendo: “Nane elo mele mare lipu tapondopo silkema koronga ‘Pulu Yemo simbo.’ nimbu panjerindu kanumunge elo manda naa lipu tapondopo simbo.” nimbé kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","⸤aku sipe nimbemonga⸥ yunge lapa imbi lipe ola mundundumbe ungu te naa pemba.” nilimele. Aku siku nilimele ungumuni ‘Anda kolepalimene mane siringi ungume olandopa.’ ningu ‘Pulu Yemone nirimu ungumu uluri molo. Manie pupili.’ nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Eno ⸤ungu manema pilku mane silimele yema kinie Parisi yema kinie⸥ eno topele mapele toli yema molemele! Pulu Yemone ungu umbu tondorumume pilku yemboma nimbe sirimu ye Aisayane enondo nirimu mele papu nirimu. ⸤Enone kinié telemele mele yuni ou nimbe Pulu Yemonga bokune torumu molemo mele isipe:⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","⸤Pulu Yemone nimbendo:⸥ “Kanu yemboma enonga keremane na kapi ningu ‘Ye awili olandopamo. ‘Nu lipu awi silimolo.’ ningu na imbi liku ola mundundulimele nalo enonga konopume kinie nanga konopumu kinie telune naa pulimo. Lupe lupe pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enone ‘Nanga imbi lipu ola mundundemili.’ ningu na we popo toko kapi nilimele. Mana yembomane mane silimele ungume mindi mane sikulie ‘Iungu manema Pulu Yemone “Teaa.” nilimo ungu manema.’ ningu pilku liku telemele, akumunge na sike popo tonge kinie uluri naa temba.” nirimu kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aku nimbelie Yesusini maku toko moloringi yembomando “Na moliona waa.” nimbelie enondo nimbendo: “Nane ⸤aku nikirumunge ungu te⸥ nimbo tekero ungumu komu tendeko ungumunge pulumu pilku kondayo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yembomanga kangine ulsukundu lepalie kerena pupe olona suku pulimo meltene ⸤Pulu Yemo manda popo tonge aulkemo pipi silimo⸥ kalaro te manda naa mondolemo. Yembomanga konopune sukundu pepalie wendo olemo ulumene mindi yemboma kalaro mondolemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aku nirimu pilkulie niringimuni, yu lombili andolime yu molorumune ongolie ningendo: “Nu aku siku nikinu mele pilkulie Parisi yemane paa pilku keri piliengi mele nu pilkinuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nalo Yesusini topondopa ⸤ungu iko topa Parisime moloringi mele nimbelie⸥ nimbendo: “Nanga mulu koleana molemo Lapamone umbu naa panjerimume pali pulu akumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iyemane nilimele mele konopu kimbu siku naa pilku molangi. Eno mongo keri lielimene ⸤mongo keri lielime⸥ aulke liku ora silimele yema molemele. Mongo keri lieli ye tene mongo keri lieli ye te aulke te lipe ora sipe ki ambolopa memba pumbe kinie elo peaselo kombune topa manie mundumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","⸤Kalaro molemomonga ungu ikomo aku sipe torumu kinie pilipelie⸥ Pitane yundu nimbendo: “Aku ungu ikomonga pulumu nambolkanje? Ningu para sie.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesusini enondo nimbendo: “Kinié kepe naa pilkimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yembo tenga kangine ulsu lepalie kerena pulimo melte olona suku pupe ulsu omba le-murune kamu pulimo mele naa pilkimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","19","Kerena sukundu pulimo melemane uluri naa telemo kanumu. Ulu kerime ou konopuni pilkulie pe kamu wendo olemomonga konopune pepalie kerena wendo olemo kanu melemane mindi ⸤Pulu Yemo popo tomba aulkemo pipi silimo⸥ kalaro te mondolemo. Kanu melema isipe: Konopuni ulu kerime pilimele, yemboma toko kondolemele, ambo ye pulime molo ye ambo lilime yembo lupema kinie ulu kerinele telemele, wa ulu kerinele lupe lupema andoko telemele, wa nolemele, kolo toko yemboma kote tendelemele, ‘Yemboma pipili kolko molko kenjengi!’ ningu ungu bulkundu nindilimele, ulu pulu akume pilku telemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aku telemele ulu akumene yemboma ⸤Pulu Yemonga kumbikerena punge aulkemo pipi silimo⸥ kalaro te mondolemo. Nalo ki ou naa kulumiye toko langi we sumbi siku nolemele ulu pulumuni ⸤yembo tenga konopune suku⸥ kalaro te naa mondolemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kanu kinie Yesusi molorumu kolea ⸤Geneserete⸥ mundupe siye kolopa ⸤Juda yemboma moloringi kolea Gallilli disiriki ulsukundu⸥ kolea awili Taya kinie Saidonoselo lierimu koleana sukundu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Akune purumu kinie kolea Kenane ambo te molorumu, yu wendo omba tondolo ru nimbelie nimbendo: “Awilimu, Ye Nomi Kingi Depisini Kalopa Lsimu Yemo, nanga ambolamo kuru te konopune sukundu molopa yu tondolo ambolemo kene nuni na kondo kolou!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nalo Yesusini yundu ungu te topondopa naa nirimu. Kanu kinie yu lombili andolimene ongo yundu ningendo: “Ambomone nu walsilipe olio lombili okomomo ⸤siye tekemo⸥ kene ‘Anjo pupili.’ ni.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","⸤Ambomo yu ambo lupe, Juda ambo te molo, nimbe kanopalie⸥ Yesusini ⸤yundu⸥ nimbendo: “Pulu Yemone na Isirele yembo talapemonga kongi sipisipi talopa lemele mele molemele yemboma molemelena mindi lipe mundorumu kanumu. Yembo talape lupema molemelena lipe naa mundorumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aku sipe nirimu kinie pilipelie ambomo omba yunge kumbikerena koporongo langopa ma kanopalie nimbendo: “Awilimu, na liku tapondou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aku nirimu kinie Yesusini topondopa ⸤ungu iko te topalie⸥ nimbendo: “Ambolangomanga langime lipu owama simolo kinie kapola naa temba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ambomone nimbendo: “Awilimu, sike nikinu nalo owamane kepe enonga pulu yembomanga langi pundu manie pulimoma liku nolemele kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanu kinie Yesusini yundu nimbendo: “Ambomo, nu manda tembo mele tondolo munduku pilino lemo kene mawa tekeno mele aku sipe wendo opili.” nirimu kinie yuni aku sipe nirimu mele aku enamonga ambomonga lemenu konde pupe kapola molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kanu kinie Yesusi kanu koleamo mundupe siye kolopa nomu Gallilli kélona ⸤aulke te lierimune⸥ omba pupe ma pangi tenga ola pupe manie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kanu kinie yu molorumune yembo paa awisili oringi. Kimbu keri lierimu-ne aulke mimi siku naa andoringi yemboma kinie, mongo keri lierimu yemboma kinie, kimbu ki karaye terimu yemboma kinie, ungu manda naa niringi yemboma kinie, aku sipe kuru lupe lupe torumu yembo awisili mengo ongo yu molorumune nondoko noseringi kinie yuni eno tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ungu naa niringi yemboma ungu niringi; kimbu ki karaye terimu yembomanga kimbu kime kelepa sumbi sipe angilierimu; kimbu keri lierimu-ne aulke mimi siku naa andoringi yemboma kapola andoringi; mongo keri lierimu yemboma mongone melema kanoringi; aku sipe ulu tondoloma wendo orumu kinie kanokolie we maku toko moloringi yembomane paa konopu awisili liku munduku, Pulu Yemo eno Isirele yemboma nokorumu popo toringi Pulu Yemo kapi ningu imbi liku ola mundundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kanu kinie Yesusini yu lombili andolimendo “Na moliona waa.” nimbelie enondo nimbendo: “I yembo maku toko molemelema na kondo tekemo. Wale yepoko na-kinie molongi, pe kinié ga nonge te naa lemo. Eno langi naa nongo we punge kinie aulkena kimbu ki pange-mange tepa, topa ne munde ya munde temba kene ‘Eno engele tepa pepili ulkendo paa.’ naa nimbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aku nirimu kinie pilkulie yu lombili andolimene ningendo: “⸤Sike nikinu nalo⸥ ikolea ku lieline molemolo. Iyembo paa awisili manda nonge mele pillawa kaloli tena lembana lipu simoloye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesusini enondo “Pillawa kaloli nambeko nosikimiliye?” nimbe walserimu kinie enone “Pillawa kaloli yepoko pakera kinie oma koltalo kinie nosikimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kanu kinie yuni maku toko moloringi yembomando “Manie molaa.” nimbelie, ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","pillawa kaloli yepoko pakera kinie omama kinie lipe Pulu Yemo kinie “Ange.” nimbe, langi akume pike lepa yu lombili andolime sirimu kinie enone yemboma moke teko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yemboma pali nongo keri pilieringi. Pe langi kakena lierimume lombili andolimene liku wale basiketemanga lakilieringi, wale awili yepoko pakera peke lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ye po tausinini aku langime noringi. Ambo ambolangoma kinie pea langi noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kanu kinie Yesusini maku toko moloringi yembomando “Ulkendo paa.” nimbelie nirimumuni, nona andoli sipi tenga suku pupe, ⸤nomune nekendo⸥ kolea Makatane purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","⸤Kolea Makatane purumu⸥ kinie Yesusi molorumune Parisi yema kinie Sadusi yema kinie eno ongo, ‘Yuni nambe-embanje? Kanamili.’ ningu yu manda manjiku mawa tekolie ningendo: “Ungu Mane Silimu, ‘Nu sike Pulu Yemone ‘Kongono tendani.’ nimbe ya mana lipe mundorumunje kanamili.’ ningu mulu koleana molemo Pulu Yemone mindi manda ulu tondolo telemo mele te tei.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesusini topondopa nimbendo: “I pupene ena pumbendo mulúmu kondoli telemo kinie kanokolie ‘wale peangamo wendo ombá.’ nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ipulueli-ou kolea tangombando kolea kupe topa mulúmu sumbulu tolemo kinie kanokolie ‘Lo ombá lemo.’ ningu pilimele kanumu. Mulúmu kanokolie ‘koleamo isipe isipe temba.’ ningu kanolemele nalo iwalemanga ulume wendo olemoma kanokolie ulumenga pulumu manda naa pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kinié mana molemele yemboma yembo kerime mindi molemele. Eno teko kenjiku Pulu Yemo liku su silimele kanu yembomane “Pulu Yemone mindi ulu tondoloma manda telemo mele kanamili tei.” ningu na mawa telemele. Nalo ⸤Pulu Yemone na lipe mundorumu-ne ya ombo molkoro. Yu-kinie tapu topo kongono telembolo mele⸥ lipe ora simbe ulu tondolo te wendo naa ombá. ⸤Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye⸥ Jonane terimu ulumuni mindi lipe ora silimo mele manda kanonge. Te pea wendo naa ombá.” nimbelie eno mundupe siye kolopa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Eno ⸤nomu Gallilli⸥ nekendo pungendo ⸤Yesusi⸥ lombili andoli yema pillawa kaloli komu sindiku naa mengo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","⸤Kanu kinie⸥ Yesusini enondo ⸤liepi-liepi topa ungu iko topalie⸥ nimbendo: “Paa mimi siku kanaa! Parisi yema kinie Sadusi yema kinie enone pillawa akoli mele isi nosilimelemo kanoko kondaa!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aku sipe nirimu kinie pilkulie yu lombili andoli yemane enono kerepale ningulie ningendo: “Olio pillawa kaloli ⸤nomolo⸥ mare naa lipu membo omulumunge aku sipe nikimunje.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aku siku niringi mele pilipelie Yesusini enondo nimbendo: “Eno ‘nane manda lipe tapondomba.’ ningu wallo kolte mindi pilimele yema, “Pillawa kaloli naa memulu.” ningu nambemune kerepale nikimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Eno kinié kepe naa pilku kondolemeleye? Pillawa kaloli kise pakera ye pape tausini moke teko siringi mele komu sindilimeleye? ⸤Nongo pora siringi kinie⸥ langi kakena lierimume liku wale basikete awisili toko peko siringi mele komu sindiku naa pilkimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Molo pillawa kaloli yepoko pakera moke teko ye po tausini siringi mele naa pilku, ⸤nongo pora siringi kinie⸥ wale basikete awili mare langi kakena lierimume toko peko siringi mele naa pilku molemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‘Yuni sike pillawa kalolimundu naa nikimu.’ ningu nambemune naa piliengiye? ‘Parisi yema kinie Sadusi yema kinie pillawa akoli mele isi nosilimelemo mimi siku kanangi.’ nimbu nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yuni aku nirimu kinie pilkulie enone ‘pillawa kalongendo isi mundulimele akumundu naa nikimu. Parisi yema kinie Sadusi yema kinie enone ungu mane siringi ungumendo nikimu.’ ningu pilieringi. ⸤‘Parisi yema kinie Sadusi yema kinie enone ungu mane mare kolo toko siringime yunge lombili andolimene paa naa piliengi!’ nimbe nirimu mele ningu pilieringi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesusi kolea awili Sisaria-Pillipai lierimu koleana pupelie nirimumuni, yu lombili andolimendo walsipelie nimbendo: “Manie Omba Mana Ye A Lierimu Yemondo yembomane yu imbi leko nawe nilimeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Enone yundu ningendo: “Marene “Nu No Lindeli Jono ⸤kolorumu, kinié kelepa lomboropa ola molemo⸥..” ningu pilku, marene “Nu ⸤Pulu Yemone ou konde molopili olando lsimu ye⸥ Illainja kelepa omba molemo.” ningu pilku, marene nu “Jeremaya molo Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye ⸤oukolorumu kinié lomboropa ola molemo⸥ te lupe.” nilimele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aku niringi pilipelie Yesusini enondo nimbendo: “⸤We yembomane aku siku nilimele⸥ nalo eno enono na nawe nilimeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimono Pitane topondopa nimbendo: “Nu Konde Molopa Mindi Puli Pulu Yemonga Malo, ⸤Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ ou nimbe mako torumu ye nomi⸥ Kirasimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yuni aku nirimu pilipelie Yesusini yundu nimbendo: “Jona Malo Saimono, nu malo. Inikinumu mana yembo tene nu naa nimbe simu. Tata mulu koleana molemomone nimbe simu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ungu te pea nundu nikirula: Nunge imbi Pita, (kanu imbimunge ungu pulumu ‘kou’ kanumu). Kanu koumunge ola nanga yembo talapemo lipu maku topo mondombo. Kanu kinie kololi ulu pulumunge tondolomone inanga talapemo topa manie manda naa mundumbe, molo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pulu Yemo ye nomi kingi molopa yemboma nokomba ulke kimu nu simbo. Kanu kinie nuni mana meltendo “Molo.” nini mélemo mulu koleana sukundu “Molo.” nimbéla. Nu mana meltendo “Kapola.” nini mélemo mulu koleana sukundu “Kapola.” nimbéla.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kanu kinie yu lombili andolimene Yesusindu “Pulu Yemone “Eno nokopa kondomba yere lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu nu ongo moleno.” niringi kanu ungumundu yuni enondo tondolo mundupe nimbendo: “Enone anjo yembo telurindu kepe na kanu yemo molio mele ⸤isili-ou⸥ paa naa ningu siee!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kanu kinie Yesusi yu lombili andolimene yundu ⸤“Pulu Yemone olio “Nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu nu.” ningu, ningu para siringi kinie pilipelie⸥ yuni yu-kinie wendo ombá mele pulu polopa eno sumbi sipe nimbe sipelie nimbendo: “‘Na mindili awisili nombondo kolea awili Jerusalleme paa pumbo.’ nimbu pilipu molio. Juda yemboma nokolemele tapu yema kinie, Pulu Yemo popo tondoli ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane silimele yema kinie, enone na paa toko mindili kondonge. Na toko kondonge kolombo kinie wale talo omba pumbe kinie yepoko sipemonga Pulu Yemone nando ‘Lomboroko ola molou.’ nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","⸤Aku nirimu kinie pilipelie⸥ Pitane yu anjo lipe memba pupelie yu pulu polopa iri topalie nimbendo: “Awilimu, aku siku paa naa ni! Nu nikinu mele aku sipe paa wendo naa ombámo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nalo ⸤yuni kurumenga nomi Setenene ungu umbu tondorumu mele pilipelie nirimu kulu pilipelie⸥ Yesusini topele topa Pitando nimbendo: “Setene, nu anjo pa! Pulu Yemone nando “Tei.” nirimu kongono tembo tekeromo pipi sini tekeno kene nu anjo pa! Nuni na teko embambo sini tekeno. Nu Pulu Yemone konopu lemo mele naa leno. Yembomane konopu lemele mele mindi leno.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kanu kinie Yesusini yu lombili andolimendo nimbendo: “Yembo tene ‘Yu lombili pambo.’ nimbelie yuni yunge konopumuni pilimo melemanga ‘Topo manie mundembo.’ nimbe yemboma unjo perana angilku mindili nongo kolemele mele yuni unjo pera mele gomo lembando ‘Na yu lombili pumbondo mindili nondu liemo papula; kolondu liemo papula.’ nimbelie na lombili opili. We naa opili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yembo tene yunge mana molopa naa kololi ulu pulumu ambolomba temba kinie yu kolopalie sike molopa kenjipe mindi pumbe. Nalo yembo tene na konopu mondopalie nanga kongonomo “Tendambo.” nimbe temba kinie yu kolopalie yu konde molopa kondopa mindi puli ulu pulumu sike kanopa limbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","⸤Akumu nambemune nikiruye?⸥ Yembo tene mana melema pali yu yuyu lipe nosipelie yu mini pali Pulu Yemo naa molomba koleana pupe mindili nomba molopa kenjilkenje kanu melemane kanu yembomo nambepa lipe tapondolkanje? Lipe naa tapondolkamo. Molo yembo tene ‘Na mini pali konde molopo kondopo mindi pambo.’ nimbelie yu nambolka meltene mini pali konde molopa kondopa mindi puli ulu pulumu topo topa lilkeye? Meltene manda topo topa naa limbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Manie Omba Mana Ye A Lierimu Yemo pe Lapanga tondolo pa telimu kinie yunge ⸤mulu koleana⸥ angelloma kinie pea ombá. Ombalie yuni olio ya mana yemboma yu-mele-mele telemolo ulumenga olio yu-mele-mele pundu tombamonga nane aku nikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nane enondo paa sike nimbu sikirumu: Eno ya angilkimilimenga mare ou kolou naa kolangi Manie Omba Mana Ye A Lierimu Yemo ye nomi kingimu omba molopa melema kinie yemboma kinie pali nokomba ombá kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesusini ⸤yu lombili andolimendo aku sipe nimbe sirimu kinie⸥ pe koro te omba purumu kinie Pita keme Jemisi keme Jemisi angenu Jono keme eno lipe meli pupe mulú paa olandopa polorumu tenga ola purumu. ‘Olio oliolio mindi molamili.’ nimbe eno akune lipe memba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Akune puringi kinie eno kanoko molangi yunge kangimu alowa tepa, yunge kumbikeremo ena tondolo topa yembomanga mongo takele telemo mele pa awili-tepa tepa, yu pakorumu mulumbalema pa telemo mele aku sipe kake terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yu aku sipe molopili, ⸤Juda yembomanga koronga-ou moloringili ye awili talo,⸥ Mosisi kinie Illainjaselo ongolo Yesusi kinie ungu ningulu mona angilieringili kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kanu kinie Pitane Yesusindu nimbendo: “Awilimu, olio ya molopamolo peanga lepamo. Nuni “E.” ninu liemo, ulke takaye yepoko takondombo. Te nunge, te Mosisinge, te Illainjanga takondombo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yuni aku sipe nimbe molopili kupe tondolo pa teli te omba eno aki torumu kinie kupena suku ungu te wendo ombalie nimbendo: “I yemo nanga konopu mondolio Malomo. Yu kanopo paa peanga kanolio. Yuni ungu nimbéma pilku liengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aku nirimu pilkulie yu lombili andoli ye ⸤yepoko⸥ paa mini-wale mundukulie mana manie molko tamalu peringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Eno tamalu peringine Yesusi omba eno ambolopalie nimbendo: “Mini wale naa munduku ola angiliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe olando siku kanoringi kinie Yesusi yuyu molorumu kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mulú polorumumunge manie onge oringi kinie Yesusini eno mane sipelie nimbendo: “Enone kinié kanongi mele isili-ou yembo teluri kepe ningu naa siengi. Pe mindi, Manie Omba Mana Ye A Lierimu Yemo kolopalie lomboropa ola molomba kinie temanemo toko anjo siengi. Ou molo!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aku nirimu kinie pilkulie yu lombili andolimene ⸤yu sike molorumu mele ningu kanokolie⸥ yundu walsiku pilkulie ningendo: “⸤Pulu Yemone ‘olio nokopa kondopa lipe mundumbo.’ nimbe mako torumu mako torumu ye nomi Kirasimu nu liemo⸥ Pulu Yemonga ungu manemanga pulume pilku mane silimele yemane “I llainja ⸤kelepa⸥ kumbi lepa ombá. ⸤Ye nomi Kirasimu pe akilipe ombá.⸥” nilimele mele nambemune nilimeleye? ⸤Illainja kelepa naa opili nu koronga orunu moleno kanumu.⸥” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesusini topondopa nimbendo: “‘‘I llainja ⸤kelepa⸥ kumbi lepa ombalie melema pali tepa mimi temba.” nilimele kanumu sike nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nalo ⸤akumunge ungu te pea nimbu sikirula.⸥ Pilieme. Illainja koronga orumu. Yu orumu kinie ⸤kanu yemane⸥ yu kanoko imbi naa siku ‘Yu we yere.’ konopu lekolie ‘Yu-kinie temolo.’ ningu pilieringi ulume pali teringi. Aku siku mele Manie Omba Mana Ye A Lierimu Yemo mindili liku singela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aku sipe nirimu kinie pilkulie lombili andolimene ‘No Lindeli Jonondo nikimu.’ ningu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","⸤Yesusi kinie yu lombili andoli ye yepoko kinie⸥ eno ⸤mulune manie⸥ ongolie yemboma maku toko moloringine oringi kinie ye te Yesusi orumune omba koporongo langopa ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mawa tepalie nimbendo: “Awilimu, nanga kangomo kondo koloyo. Yu kuru kopari tolemo-na mindili awili tepa nolemo. Taki-teki yu tepena pupe nomanga pulimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nu lombili andoli yema molongine kangomo membo ondu kinie enone yu manda teko konde naa lingi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aku nirimu kinie pilipelie Yesusini ⸤yemboma iri topalie⸥ nimbendo: “Kinié molemele yemboma eno ⸤‘Pulu Yemone ulume sike manda temba.’ ningu⸥ tondolo munduku naa pilimele. Eno konopu karaye tepa pepili molemele yemboma, na eno wale nambepo mane sipu ulu mare lipu ora simbo kinie mimi siku pilingeye? ⸤Na eno-kinie siye tekemo.⸥” nimbelie “Na moliona kangomo mengo waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mengo oringi kinie Yesusini kanu kurumu iri torumu kinie yu kangomonga ⸤konopune⸥ omba wendo purumu kinie kanu enamonga kangomo manda molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aku terimu kinie kanokolie Yesusi lombili andoli yema Yesusi yuyu molorumune ongo walsiku pilkulie ningendo: “Kuru akumu olione nambemune manda naa makoromuluye?” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesusini topondopa nimbendo: “⸤‘Pulu Yemone sike olio lipe tapondomba.’ ningu⸥ tondolo munduku naapilimelemonga ulu tondolo i-silime manda naa telemele. Nane eno paa sike nimbu sikirumu: Unjo tenga mongo akumu mele paa kanga nalo kanu mongomo mana mundulimele kinie unjo akopa awi lepa angilimo mele, aku sipe enone ‘Pulu Yemone olionga ungume pilimbe. Olio lipe tapondomba.’ ningu wallo kolte mindi pilkulie ipolemo mulúmundu “Anjo puku ne koleana angiliei.” ninge kinie sike aku sipe pupe angilimbe. ‘Teamili.’ ninge ulumenga ulu manda naa tenge ulu te naa pemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Pulu Yemo mawa teko langi mi toko naa nongolie kuru i-silime yembomanga konopumenga manda makoronge. Ulu tondolo i-silime we manda naa tenge.)” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","⸤Pe walse,⸥ kolea Gallilli disiriki puku moloringi kinie Yesusini yu lombili andolimendo nimbendo: “Manie Omba Mana Ye A Lierimu Yemo ⸤ka sikulie yu tonge⸥ yema anjo singe kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","enone yu toko kondonge. Kolopalie wale yepoko sipemonga Pulu Yemone yundu ‘Lomboroko ola molou.’ nimbé.” nirimu. Aku nirimu pilkulie enonga konopune sukundu meme kulupi perimu kulu pilkulie paa kondo koloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pe Yesusi kinie yu lombili andolime kinie Kapeniame taonona oringi kinie Pulu Yemo popo toringi ulke tembelemonga kou takisi lsingi yema ongo Pita walsikulie ningendo: “‘Nunge ungu mane sili yemone ulke tembelemonga kou takisi tolemo.’ konopu lekemolomo. Sikeye?” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitane “Tolemo.” nirimu. Kanu kinie Pita ulkena sukundu pupelie ungu te nimbé terimu kinie Yesusini yu ou walsipelie nimbendo: “Saimono, nu nambolka konopu lekenoye? Ye nomi kingimene kou takisi lupe lupema lingendo namele “Taa.” nilimeleye? Enonga yemboma kinie kou takisi limele molo yembo lupema “Taa.” nilimeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitane topondopa nimbendo: “Yembo lupemando “Takisi taa.” nilimele.” nirimu. Aku nirimu kinie pilipelie Yesusini yundu nimbendo: “Aku liemo kingimunge yembomane takisi naa tonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nalo takisi naa tombolo kinie ulke tembele-takisi limele yemane olto kanoko keri kanonge kapola naa temba kene nomune puku uku mundu-peni. Uku mundukulie oma te toni aku omamonga keremo aká tendeni kinie kou te pemba, aku koumu likulie mengo puku oltonga pea liku tere leko takisi tou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aku walemonga Yesusi lombili andolimene yu molorumune ongo yu walsiku pilkulie ningendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yembomanga nawe paa olandopa molemoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Enone walseringi mele Yesusini pilipelie yu ambolango kanga te “Na moliona ou.” nimbe eno moloringine mondopalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","enondo nimbendo: “Nane eno paa sike nimbu sikirumu: Eno konopu alowa teko ambolango kangama mele naa molongi liemo Pulu Yemo ye nomi kingimu molopa yemboma nokolemo koleana suku paa manda naa punge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akumunge yembo tene ‘Na we yembomo molambo. Nanga imbi te olandopa naa molopili.’ nimbe i ambolango kangamo mele naa molemo yembomo yu Pulu Yemo ye nomi kingimu molopa nokolemo kolea na yembo imbi paa mololimu molemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“⸤I ambolangomondo ungu te pea niembo:⸥ Yembo tene ‘Na Awilimunge yembomo molio.’ nimbe i ambolangomo mele lipe tapondomba kinie kanu yembomone aku tembamonga na lipe tapondombala. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nalo yembo tene i⸤ambolango⸥ kangamonga ⸤mele yembo⸥ te ⸤na ‘Sike’ nimbe⸥ tondolo mundupe pilimo ⸤ambolango⸥ kanga te ‘Ulu kerime tepili.’ nimbe kondi tombamonga kanu ⸤ambolango⸥ kangamo tondolo mundupe pilimo mele mundupe siye kolopa bulu simu liemo ⸤ambolango⸥ kangamo ou kondi naa topili kou paa awili te moko toko nomine lendeko ‘Yu kamu kolo-popili.’ ningu paka toko nomune paa maniekondo mundulimelanje paa papu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“⸤Na⸥ ‘Sike’ ningu tondolo munduku pilimele yemboma kelko bulu siku munduku siye kolonge ulume yamana lemomonga na eno kondo tekemo. Sike aku sipe ulume wendo ombá nalo yembo tene nanga yembo te kondi tombamonga kanu yembomo na bulu sipe anjo pumu liemo kanu kondi tomba yembomo mindili nomba paa molopa kenjimbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nunge kiselone molo kimbuselone ulu pulu keri te temu liemo aku kiselo molo kimbuselo kari leko lteani. Nu konde mololiku mindi puni koleana kiselo molo kimbuselo naa angiliepili puni kinie peangamo. Nunge kimbu ki pali we angiliepili tepe naa kumbulupe nomba pepa mindi pumbe koleana liku toko mundunge kinie kerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Molo nunge mongoselone melte kanokolie konopuni ‘liemboa.’ ningu pilku ulu pulu keri te tenu liemo aku mongoselo akuku lteani. Nu konde mololiku mindi puni koleana mongoselo naa angiliepili puni kinie peangamo. Mongo talo we angiliepili nu tepe koleana suku liku toko mundunge kinie kerimu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“I ⸤ambolango⸥ kangama ⸤mele yemboma⸥.nga te kanoko keri kanoko ‘Yu koropamo.’ ningu paa naa teangi. Enonga nokolemele mulu koleana angelloma alieli Tata mulu koleana molemona pea molemele kene ⸤aku naa teaa⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Manie Omba Mana Ye A Lierimu Yemone ‘Yembo aulke lou leko molko kenjilimele yemboma koropo lipu tapondambo.’ nimbe orumu kanumu.)” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Eno nambolka ningu pilkimiliye? ‘Ye tene kongi sipisipi pape paono mondolka kinie, te talopa lelkanje, yuni sipisipi po paono tene kelepa nani wema ma pangine molangi mundupe siye kolopa pupe, talopa lelka sipisipimu kanopa limbendo korolipe naa pulke.’ konopu lekemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nane enondo paa sike nimbu sikirumu: Sipisipi talopa lelka kanumu kanopa lipelie kanu sipisipimu-kinie paa olandopa konopu silke. Talopa naa lemelama we konopu silke. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aku sipela enonga Lapa mulu koleana molemomone i ambolango kangama ⸤mele molemele yemboma⸥ ‘aulke lou leko molko kenjinge kinie paa keri.’ nimbe molemola.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“⸤Na lombili andolimenga⸥ angenu tene nu tepa kenjemu liemo nu puku tepa kenjimbe yembomo pea elolo molangili kanu ulu pulu kerimu yuni nu temba mele ningu sieni. Nuni nini ungumu tepa kenjimbe angena piliemu liemo angena kinie elo altoko kapola kapola molongele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nalo nuni nini ungumu yu naa piliemu liemo pe nuni ‘I ungumu pora nipili kene tembo mele yembo mare kanoko molangi altopo niembo.’ ningulie, kanonge yembo talo molo yepoko liku angena molombana mengo ongo eno kanoko molangi angenando ‘Telune molambili.’ altoko nieni. Kanu kinie nuni teni kinie angenane temba mele kanu yembomane kanokolie yembo lupemando manda temane toko singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kanu kinie yuni enonga ungumu kepe naa piliemu liemo Kirasinge yembo talapemondo puku ningu sieni. Pe Kirasinge yembo talapemo kepe angenane naa piliemu liemo ‘Yu olionga angenu molo. Yu ulsukundu molko konopu alowa naa teli yemboma mele molemo lemo.’ ningu kanayo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nane enondo paa sike nimbu sikirumu: Ya mana enone ⸤ulume kinie yemboma kinie⸥ “Molo.” ninge kinie Pulu Yemone mulu koleana sukundu “Molo.” nimbéla; enone mana “Kapola.” ningema Pulu Yemone mulu koleana sukundu “Kapola.” nimbéla. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“⸤Akumunge⸥ nane enondo ungu te pea nimbu sikirumu: Enonga yembo talone ya mana “I sipu mawa teambili.” ningu panjengili liemo elone mawa tengele mele mulu koleana molemo Tatane elonga mawa tengele mele aku sipe tendemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yembo ⸤koltalo,⸥ talo molo yepoko, na enonga Awilimu imbi leko walsiku, ‘Pea tapu topo molemolo.’ konopu leko maku toko molemelemanga na eno-kinie molemolo-na ⸤mawa tenge mele Tata yuni aku sipe tendembamo⸥..” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","⸤Yesusini yembo teko kenjilimelemando ungu mane aku sipe sirimu⸥ kinie yu molorumune Pita nondopa ombalie yu walsipe pilipelie nimbendo: “Awilimu, nanga angenu tene na wale nambepa tepa kenjimbe kinie na we ‘Manie pupili.’ nimbu siye kolomboye? Wale sepene yuni temba mele siye kolopo we molopolie engaki sipemonga ‘Pundu topili.’ nimbo kinie papuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesusini topondopa nimbendo: “Nane “Wale sepene mindi yuni nu tepa kenjimbe kinie yuni tembama siye kolko altoko pilku naa molou.” ni naa nikiru. “Wale sepene anderete sependi sepene yuni nu tepa kenjimbe walema pali yu tepili, siye kolko we molou.” nikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Akumunge Pulu Yemo ye nomi kingimu molopa melema nokolemo akumu isipe mele: “Walse ye nomi kingi tene yunge kongono nokondoringi kendemandema kinie pundu angilierimume “‘Kinié mimi sipu kanopolie pundu tangi.” niembo.’ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aku sipe nirimu kinie kingimuni kou tene milliene kina mele ou pundu angilierimu ye te kumbi leko yu molorumune mengo oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nalo yu manda aku kou pundumu tomba aulke te paa naa lierimu kulu awilimuni nimbendo: “Kapola, iyemo kinie yunge ambo ambolangoma kinie yunge melema pali kinie makete teko kou mone likulie koumu ongo pundu tondangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aku nirimu kulu pilipelie kendemandemo ye nomimunge kumbikerena koporongo langopa tamalu pepa mawa tepalie nimbendo: “Nuni na kondo kolko we nokoko moloyo. Nane pundu pali tombo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","⸤Kanu kinie⸥ ye nomimuni yunge kendemandemo paa kondo kolopa yu kendemandemo kinie pundu angilierimume pali “Yu tepili. Altoko pundu naa tani.” nimbe kamu siye kolopa yemo ka naa sipe “We pu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nalo ⸤ka singe teringi⸥ kendemande kanumu yu pena pupe kendemande te yunge kou wane anderete kina mele sirimumu kanopalie, yu pupe yunge nomine ambolopa ‘Yu kolopili.’ nimbe ambolopa elkele lakurupelie “Nanga kou sirindumu pundu tou!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aku terimu kinie yuni tomba terimu yemo yunge kumbikerena koporongo langopa tamalu pepa mawa tepalie nimbendo: “Nuni na kondo kolko we nokoko moloyo. Nane pundu pali tombo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nalo kendemande lupemone “Molo, paa isili pundu tani.” nimbelie “Nu ka ulkena pekolie pundu toko pora siku wendo wani.” nimbe yu ka sipe ka ulkena panjerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yuni aku terimu mele kendemande wemane kanokolie eno konopu keri panjiku puku enonga ye nomimundu kendemandeselo teringili kanoringi mele kondi toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kanu kinie ye nomimuni aku niringi pilipelie kendemande yunge pundu “Naa toko we pu.” nirimu kendemande kanumu “Yando ou.” nimbelie yundu nimbendo: “Kendemande kerimu, nuni na tondolo munduku mawa tenu-ne nu na-kinie pundu paa awili tepa angilierimumu “Yu tepili, naa tou.” nimbulie we siye kolondu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pe nane nu we kondo kolondu mele nuni aku siku kendemande te nambemune kondo naa kolonuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ye nomimuni yu mumindili kolopalie ka ulke nokoko ka ulkena peringi yemboma teko mindili kondoringi yema yu lipe sirimu. Yuni nimbendo: “Nu mindili nongolie pundu tani. Ou pundu pali toko pora sikulie pe mindi wendo wani. Ou molo.” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","⸤Yesusi yuni aku nimbelie ungu ikomonga pulumu kamu nimbendo:⸥ “Aku sipela, angenalini eno aku siku teko kenjinge kinie eno kerena mindi “Manie pupili. Siye kolkoro.” we ningu, sike munduku siye naa kolko, we konopuni pilku molongi liemo, ⸤kendemandemonga ye nomimuni kendemandemo tepa kenjerimu mele⸥ mulu koleana molemo Tatane siye naa kolko we konopuni pilku molonge yembo kanume enonga ulu pulu kerime ‘Manie naa pupili.’ nimbe, we siye naa kolopa kanu ulu pulu kerimenga “Mindili nangi.” nimbe aku tembala.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesusini aku sipe ungume nimbe pora sipelie nirimumuni, kolea Gallilli disiriki mundupe siye kolopa kolea Judia disiriki pupe no Jodane lumbilipe nekendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kanu kinie yembo awisili yu lombili oringi kinie yuni kuru torumu yemboma tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi ye mare yu molorumune ongo ‘Yu nambolka nimbenje? Nimbe kenjimbenje manda manjipu piliemili.’ ningu yu walsiku pilkulie ningendo: “Ye tene yu yuyu pilipelie yunge ambomo “Kamu pu.” nimbé kinie kapola temba molo aku temba kinie ungu mane te pulue tombaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yuni anjo topondopa nimbendo: “Pulu Yemone ungu nirimu yunge bokune molemo mele kanoko kambu naa tongiye? Ou pulu pulu, Pulu Yemone melema tepalie, yuni yembo tembando yemo kinie ambomo kinie tepalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nimbendo: “Aku sipu tendumunge ye tene ambo te lipelie yunge anumu lapaselo mundupe siye kolopa yunge ambomo kinie elolo telune tapu toko peko kangi telumu mele ⸤molkolo elonga konopu telune pupili⸥ molongele.” nirimu kanumu naa piliengiye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pulu Yemone aku sipe nirimu kulu ye te ambo te limo kinie kangi telumu mele molembele-na elo altoko talo mele naa molembele, elo yembo telumu mele molembele. Yembo telumu molembele kene Pulu Yemone ambo ye talo ‘Telumu molangili.’ nilimo ambo yeselo yembo tene liku lupe lupe naa mundengi. Aku tengi liemo kapola naa temba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aku sipe nirimu kinie enone ningendo: “Aku liemo Mosisini ungu mane te sirimu mele nambemune sirimuye? Mosisini nimbendo: “Ye tene yunge ambomondo ‘Kamu pupili.’ nimbe makorombando ambomo “Kamu pu.” nimbé mele pepá te topa ambomo sipelie yundu “Kamu pu.” nimbe aku tepili.” nirimu kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesusini nimbendo: “Mosisini sike aku sipe nirimu nalo eno kara puku Pulu Yemone ambo yeselo kapola-kapola molongele mele ungu mane sirimumu liku su siku naa pilieringi kulu yuni “Aku teangi.” nirimu. Nalo ou pulu pulu, ⸤Pulu Yemone melema kokele tepa mimi terimu kinie⸥., ungu mane aku sipe te naa perimu kene ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","nane eno isipu nimbu sikiru: Ye tene yunge ou limo ambomo makoropa “Kamu pu.” nimbelie kelepa ambo te limo kinie aku yemone wa ulu kerinele telemo. Yemonga ambomone ye te kinie wa ulu kerinele temu liemo manda topa makoromba. We molo. (“Pu.” nimbe makorolemo ambomo pe ye tene yu limo kinie kanu yemo kepe wa ulu kerinele telemola.)” nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","⸤Yuni aku nirimu kinie pilkulie⸥ yu lombili andoli yemane yundu ningendo: “Ye tene ambo limo kinie nuni nikinu mele aku siku molongele mele ungu mane te pelemo liemo ye te ambo naa lilkenje papu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nalo Yesusini topondopa nimbendo: “I ungu ⸤mane sikirumu⸥ yembomane pali manda naa pilku linge. ⸤Pulu Yemone⸥ mako topa tondoloma simbe yemboma mindi manda ⸤amboma ye naa puku yema ambo naa liku⸥ tenge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye mare anupilini melemele kinie amboma kinie telune tapu toko peko ulu kerime tenge enge te naa pelemo. Ye mare ‘Amboma kinie telune naa peangi.’ ningu enonga láka tondolemele. Marene enono ‘Ye nomi kingi Pulu Yemonga yema molopo yunge kongonoma manjipu tendamili.’ ningu eno enono mi leko ambo naa limele. Iungumu yembo pilku linge yemboma piliengi!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kanu kinie yembomane enonga ambolangoma ‘Yesusi yunge kimuni ambolopa Pulu Yemo kinie enonga mawa tendepili.’ ningu yu molorumune mengo oringi. Nalo yu lombili andolimene iri toko ⸤“Naa mengo waa.”⸥ niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","⸤“Molo.” niringi kinie⸥ kanopalie Yesusini nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yembo talape akumu i ambolangoma mele molemele yemboma enonga yembo talapemo kene enone i ambolangoma na moliona wangi pipi siku “Molo.” naa niee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aku nimbelie yuni ambolangoma ⸤kondo kolopa⸥ yunge kimuni eno telu telu nimbe ambolopalie kanu koleana mundupe siye kolopa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Walse ye te Yesusi molorumune omba yundu walsipe pilipelie nimbendo: “Ungu Mane Silimu, na nambolka ulu peangamo tembo kinie konde molopa kondopa mindi puli ulu pulumu limboye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesusini yundu nimbendo: “Nuni na nambemune ulu peangamondo walsiku pilkinuye? Yembo telu mindi peanga molemo. Nuni ‘konde molopo kondopo mindi puli ulu pulumu limbo.’ konopu lienu liemo ⸤Pulu Yemonga⸥ ungu mane ⸤Mosisini yando nimbe sirimume⸥ tenge panjiku teko molani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yemone walsipelie nimbendo: “Aku ungu manemanga temando nikinuye?” nimbe walserimu kinie Yesusini topondopa nimbendo: “‘‘Yembo toko naa kondangi.” nimbe, “Ambo ye pulime molo ye ambo lilime yembo lupema kinie wa ulu kerinele naa teangi.” nimbe, “Melema wa naa liengi!” nimbe, “Yembomanga kote kolo toko naa tendangi.” nimbe, ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Aminieli lanieli kinie teko kondoko, ungu ninge mele pilku liku teko molangi.” nimbe, “Eno enono yu mele mele konopu mondoko enonga kangimu enono kondo kolko nokolemele mele aku sikula pulu lemo yemboma konopu mondoko nokoko molangi.” nimbe, ungu mane akume sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aku nirimu kinie pilipelie kanu kango yemone nimbendo: “Na kanu ungu manema pali pilipu lipu tepo molio. Pe kinié nambolka uluri olandopa teamboye?” nimbe walserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesusini yundu topondopa nimbendo: “Nu ‘kamu ye sumbi nilimu molambo.’ konopu lienu liemo nu puku nunge mele nosilinoma pali kou mone li-pukulie, kou mone linime yembo koropama moke teko sikulie na lombili ou.” nirimu. “Nunge ⸤mana⸥ melema aku teni kinie mulu koleana nunge mele kande kandema lemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kanu kango yemo mele paa awisili noserimumunge Yesusini yundu aku nirimu kinie pilipelie yu konopu keri panjilipe anjo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","⸤Aku terimu kulu kanopalie⸥ Yesusini yu lombili andolimendo nimbendo: “Pulu Yemo ye nomi kingi molopa nokolemo koleana suku pungendo yembo kamakoma paa mindili siku suku punge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Enondo altopo nikiru: Kongi kemele ⸤kongi paa awili te nalo⸥ kale suru toline suku pumbendo mindili kanga mele sipelie pumbe. Nalo yembo kamakoma Pulu Yemo ye nomi kingi molopa nokolemo koleana suku pungendo mindili paa awili mele siku punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aku nirimu kinie pilkulie yu lombili andolime paa mini-wale munduku suru ningulie anjo yando ungu-mele tekolie ningendo: “Aku liemo mindili nolemela aulkena nawe manda wendo pupe, molopo kondomolo aulkena pumbeye? Te molonje.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesusini eno neme-neme nimbe kanopalie nimbendo: “Sike yemboma enono manda molo nalo Pulu Yemone manda tendemba. Pulu Yemo yuni ulume pali kapola telemo. Ulu te yuni manda naa temba te molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yuni aku nirimu kinie pilipelie Pitane yundu nimbendo: “⸤Pe olio-kinie nambolka uluri wendo ombáye?⸥ Olio olionga melema pali mundupu siye kolopo nu lombili purumulu pulimolo kene mele nambolka melema limoloye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesusini nimbendo: “Nane enondo paa sike nimbu sikirumu: Pe ⸤Pulu Yemone⸥ melema pali ‘konde pupili.’ nimbé kinie Manie Omba Mana Ye A Lierimu Yemo yunge ye nomi kingi polo pa tondolo teline molopa yemboma nokomba kinie, eno na lombili andolemele yema pea ye nomi kingi polo rureponga molkolie ningemone, Isirele yembo talape rurepo nokonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yembo na konopu mondoko nanga kongono tendengendo enonga ulkema, angenupili, kemulupili, anupili, lapali, ambolangoma, koleama, akume munduku siye koloringi yemboma pali, ya mana paa olandopa mele awisili likulie, konde molko kondoko mindi puli ulu pulumu lingela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nalo kinié awili molemele yembomanga awisili pe ⸤Pulu Yemo ye nomi kingi molopa nokomba koleana⸥ yembo koropama molonge; kinié koropa pupili molemele yemboma pe yembo awilime molonge.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aku nikiru ungumunge ⸤ungu te niembo⸥: Pulu Yemone ye nomi kingimu molopa yemboma nokolemo akumu isipe mele: “Walse ponie pulu ye tene ‘Kongono tendeli ye mare yunge unjo waene poniena kongono tendangi.’ nimbe paa ipulueli-ou pupe li-porumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Kongono teangi.” nimbe lsimu yemando nimbendo: “Kinié tenge walemonga eno kou mone pape kina pape kina nimbu mele kalombo.” nirimu kinie enone “Kapola.” niringi kinie yuni eno yunge unjo waene poniena “Kongono teangi paa.” nimbe eno lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pe, ipulueli-ou nani killoko mele terimu kinie, yu kelepa yemboma maku toringi koleana pupe ye mare akune we angilieringi kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","enondo nimbendo: “Eno kepe ⸤nanga⸥ unjo waene poniena kongono tendangi payo. Pe nane eno kou kapola mele kalombo.” nirimu ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","kinie eno puringi. Pe awi-tangoli terimu kinie kepe, ipupene tere killoko mele terimu kinie kepe, kelepa aku sipe pupe ye mare pea lsimula. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ipupene pape killoko mele terimu kinie ⸤altopa⸥ pupe ye mare we angilieringi kanopalie enondo nimbendo: “Walemonga pali kongono naa teko ya inie nambemune we angilimeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Enone yundu ningendo: “Ye tene olio kongonona naa limu-ne we angilimolo.” niringi. Yuni enondo nimbendo: “Eno kepe ⸤nanga⸥ unjo waene poniena kongono tende-paa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ena pora nirimu kinie unjo waene ponie pulu yemone yunge kongono nokoli yemondo nimbendo: “Kongono tekemele yema ‘sukundu waa.’ ningu eno kongono tengimunge mele kalonindu paa akilku ongi yema pulu polko mele kaloliku puku kumbi leko ongi yema paa akilku mele kalou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","⸤Aku nirimu kinie⸥ i pupene pape killoko mele terimu kinie “Kongono tendangi.” nimbe lsimu yema ⸤kumbi leko⸥ ongo pape kina pape kina nimbe sirimu lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Akilku ongo kongono tenderingi yema kou aku siku lsingi kanokolie kumbi leko ongo kongono tenderingi yema ongolie ‘Olio kou olandopa mele limolo.’ konopu lieringi nalo eno pape kina pape kina nimbe sirimu lsingila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Likulie enone ponie pulu yemondo iri tokolie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Akilku ongi yema ena telu manjiku kongono tengi, olio ipulueli-ou ombo kongono awili tepo temulu, ena awili tomumuni olio paa nomu kanumu, nalo eno kinie olio kinie kou kapola kapola teko sikinumu, kapola naa tekemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yuni enonga ye tendo topondopa nimbendo: “Kangomo, nane nu tepo naa kenjikiru. “Pape kina simbo.” nindu kinie “Kapola.” ninu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kou sikirumu liku meli puyo. Nanga konopuni mindi pilipulie akilipe omu yemo nu sikiru mele yu aku sipu sindu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nanga nosilio melemanga konopuni pilipulie manda naa temboye? Molo pe ongi yema kou awili tepo sindumunge nu konopu keri panjikinuye?” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","⸤Ungu iko akumu topa pora sipelie ungu ikomonga pulumu kamu nimbendo:⸥ “Aku sipela, akilku onge yemboma ⸤Pulu Yemone nokolemo talapena sukundu⸥ kumbi leko punge; kumbi leko onge yemboma akilku punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kanu kinie Yesusi kolea awili Jerusalleme pumbe purumu kinie yu lombili andoli engaki rurepo ‘na kinie eno kinie oliolio molamili.’ nimbe eno lipe anjo memba pupelie enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pilieme. Olio Jerusalleme pumolo pukumulu. Akune pumolo kinie Manie Omba Mana Ye A Lierimu Yemo ye tene ‘Tangi.’ nimbe Pulu Yemo popo tondoli ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane silimele yema kinie, lipe simbe, enone yu kote tendeko ‘Yu kolopili tangi.’ ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Juda ye naa molemele yema liku singe. Kanu kinie kanu yemane yu ungu taka tondoko, ka pulsene toko, ‘Yu kolopili.’ ningu unjo perana uku toko panjinge. Kolopalie wale yepoko sipemonga Pulu Yemone yundu ‘Lomboroko ola molou.’ nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kanu kinie Seperi malo Jemisi kinie Jonoselonga anumu Yesusi molorumune omba koporongo langopa yundu “‘Nu ulu te teani.’ nimbu mawa tembo okoro.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","yuni yundu nimbendo: “Nambolka uluri ‘nane tendambo.’ ningu nikinuye?” nirimu. Ambomone nimbendo: “Nu pe ye nomi kingimu moloni kinie inanga kango talo ⸤‘elo nu kinie pea ye nomime molamili.’ ningu⸥ ‘elonga te nunge ki umbukundu mondoko te nunge ki tarokondo mondani.’ nimbu mawa tekero.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesusini enondo nimbendo: “Mawa tekemele mele eno pilku naa kondokomele. Na no mingine no nondopo nombomo elo manda nongeleye?” nirimu kinie elone “Manda nombolo.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yuni elondo nimbendo: “Na no mingine no nombomo pe elo paa sike nongele nalo nane elo “Nanga wanguselonga ongo molangili.” nimbomo kapola naa temba. Tatane yuyu akune molongeleselo koronga mako torumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Angenungulu ⸤Jemisi kinie Jonoselone ‘Yesusinge wanguselonga molambili.’⸥ ningu mawa teringili mele pilkulie lombili andoli ye rureponga talo ⸤wemane⸥ elo-kinie konopu keri panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanu kinie Yesusini eno “Waa.” nimbelie nirimumuni, enondo nimbendo: “Olio Juda yembomanga ulsu molemele yembo talapemanga ye nomime enonga yemboma tondolo munduku nokoko kongono enge nilime alieli silimele. Ye imbi ola molemo yema enonga yemboma ‘Mindili nangi.’ ningu nokolemele. Yembomane enonga ye nomimenga ungume liku su singe aulke te naa lemo. Aku siku telemele mele enone pilimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nalo ⸤we yembomanga ye nomimene enonga yemboma tondolo munduku nokolemele mele na lombili andoli yema⸥ eno enono aku siku anjo yando naa teangi. Enonga ye te ‘Na imbi olandopa molopili. Na ye awilimu molambo.’ nimbé yemo enonga kongono tendeli yemo molopili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘Na enonga ye nomimu molopo eno nokambo.’ nimbé yemo enonga kongono kendemande tendeli yemo molopili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aku sipela, Manie Omba Mana Ye A Lierimu Yemo kepe ‘Yembomanga ye awilimu molopo eno nokambo. Enone nanga kongono tendeli kendemande yemboma molangi.’ nimbe naa orumu. ‘Yembomanga kongono tendeli kendemande yemo molopo eno lipu tapondopo, ulu pulu kerimene eno ka sipe nokolemo mele naa tepili kapola molangi kene na yembo awisilinge nimbu pundu tondopo nanga kangimu sipu, enonga kolo wangopo kolondambo.’ nimbe orumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesusi kinie yu lombili andolime kinie eno kolea awili Jeriko munduku siye kolko punge puringi kinie we yembo awisili yu lombili puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kanu kinie mongo keri lierimu ye talo aulke alselsena molkolo Yesusi omba purumu mele pilkululie yundu tondolo ru ningu walsikulie ningelendo: “Awilimu, ⸤ye nomi kingi⸥ Depisini kalopa lsimu yemo, olto kondo kolou.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yembomane elo iri toko “Ungu naa nili taka liku molale.” niringi. Nalo elone paa tondolo ru ningu walsikululie ningelendo: “Awilimu, Depisini kalopa lsimu yemo, olto kondo kolou.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesusi we angilipelie “Elo wale.” nimbelie elondo nimbendo: “Nane elo nambe-eambo konopu lekembeleye?” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","mongo keri lierimu yeselone ningelendo: “Awilimu, ‘oltonga mongoselo ‘Altopa umbu mongo angiliepili.’ nieni.’ konopu lekembolo.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kanu kinie Yesusini elo kondo kolopa mongona ambolorumu kinie elo tamburumbu mongoma peanga lierimu, melema kanokololie, Yesusi lombili puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","⸤Yesusi kinie yu lombili andolime kinie⸥ eno kolea awili Jerusalleme nondoko ongo, ma pangi te ‘Ma Pangi Unjo Ollipi Ponie’ nili akune lemo kolea kanga Betepasi oringi. Kanu kinie Yesusini yu lombili andoli ye talo lipe mundupelie, ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","elondo nimbendo: “Ne kolea kanga kanokombelena pukululie kongi dongi te ka teko panjingemo kinie yunge walomo pea ne sukundu molongele kanongele, kanuselo puku posiku yando mengo wangili pale. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Posingele teko molongele kinie yembo tene elondo ungu te nimu liemo elone i siku niengili: “Awilimu yu ‘Dongimuni mepili.’ nimu-ne ombo likimbulu.” niengili. Aku ningele kinie yuni sumbi sipe “Kapola, mengo pale.” nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aku sipe wendo orumumunge koronga ou Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye tene ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Akumu isipe: ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Enone kolea awili Sayono yembomando i siku niengi: “Kanayo! Eno molemelena enonga ye nomi kingimu okomo. Yu ye imbi naa mololi yemo mele taka lipe molemomo kongi dongi bulu mingine molopa okomo. Kongi dongi tenga walomonga bulu mingine molopa okomo.” ningu, ningu siee.” nirimu kanumu. ⸤Aku nirimu mele Yesusi terimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kanu kinie lombili andoliselo pukulu Yesusini “Te-pale.” nirimu mele te-poringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Elone kongi dongimu kinie yunge walomo kinie mengo ongololie, enone enonga mulumbalema kulku dongiselonga bulu mingine ola pauwe toringi kinie Yesusi kanune ola molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yembo maku toringimenga awisilini enonga mulumbalema kulku yu ombá aulkena pauwe toliku puku, marene kipiyala gomo langoko liku yu ombá aulkena pauwe toliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kumbi leko puringi yembomane kepe akilku puringi yembomane kepe naka leko unjo ambololiku pukulie ningendo: “⸤Ye Nomi Kingi⸥ Depisini Kalopa Lsimu Yemo ‘Imbi ola molopili.’ niemili. Pulu Ye Yawene lipe mundorumu-ne yunge kongonomo tendemba okomo yemo molopa kondopili. Mulu koleana ola yu imbi ola molopili.” niliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesusi Jerusalleme suku purumu kinie kanu kolea awilimunge sukundu moloringi yemboma pali konopu awisili liku mundukulie “I mu naweye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Maku toko moloringi yembomane ningendo: “I mu Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye Yesusi, kolea Gallilli disiriki Nasarete taono ye te.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesusi ⸤Jerusalleme suku pupelie nirimumuni⸥ Pulu Yemo popo toko kaloringi ulke tembelena ⸤“Juda yembo naa molemele yemboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akune⸥ suku pupe kanopalie akune melema makete teko moloringi yemboma kinie, melema topo toko liku moloringi yemboma kinie akume kanopalie eno pali topa makoropa, kou mone lupe lupema alowa teko anjo siringi yembomanga poloma kinie, kera waembono makete teringi yembomanga manie moloringi poloma kinie, topele topa, topa bulu-balu sipelie, ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","enondo nimbendo: “Pulu Yemonga bokune ungu te isipe nilimo: ‘Yembomane nanga ulkemondo “Pulu Yemo kinie ungu nilimolo ulkemo.” ninge.’ kanumu. Ungu aku sipe molemo nalo enone iulkemo ‘wa nolemele yemboma lopi teko molemele ulkemo’ mele ningu pilkulie aku siku telemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kanu kinie Yesusi ulke tembelena molopili yembo mongo keri lepa, kimbu ki keri lierimu yembo awisili yu molorumune oringi kinie yuni eno tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nalo yuni we yembo tene manda naa telka ulu tondolo peangama terimu mele kinie, ulke tembelena ambolangomane tondolo ru ningulie: “Ye Nomi Kingi Depisini Kalopa Lsimu Yemo ‘Imbi ola molopili.’ niemili.” niringi mele kinie, kanu uluselo wendo orumu mele kanokolie Pulu Yemo popo tondoringi ye awilime kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie enone konopu keri panjikulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yesusi walsikulie: “Andi ambolangomane ungu nikimili mele nu ⸤naa⸥ pilkinuye?” niringi. ⸤Nalo⸥ Yesusini enondo nimbendo: “Na pilkiru. ⸤Andi ambolangomane tekemele mele⸥ ungu te bokune molemo mele eno naa kanolemeleye? Kanumu isipe molemo: ‘Ambolango kangama kinie ambolango pamema kinie ⸤Pulu Yemo⸥ nu paa kapi ninge mele mane sirinu.’ aku ungumu bokune molemo mele eno naa kanolemeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aku nimbelie yu kanu yema mundupe siye kolopa kolea awili ⸤Jerusalleme⸥ ulsukundu pupe kolea kanga Betani pupe akune perimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ipulueli-ou ⸤Jerusalleme nondopa lierimu kolea Betani mundupe siye kolopa Yesusi⸥ kelepa kolea awili ⸤Jerusalleme⸥ pumbe purumu kinie yu engele terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kanu kinie yu orumu aulke kélona unjo piki te angilierimu kanopalie nondopa pupe kanorumu kinie unjo mongo te topa naa perimu, gomo mindi terimu kanorumu. ⸤Gomo mindi terimu-ne⸥ kanopalie “Nu altoko mongo te naa tani.” nirimu kinie unjo piki kanumu walsikele kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aku ulumu wendo orumu kinie kanokolie yu lombili andolimene paa mini-wale mundukulie ningendo: “I unjo pikimu nambepalie walsikele kolomuye?” ningu walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesusini topondopa nimbendo: “Nane enondo paa sike nimbu sikirumu: Eno konopu talo tepa naa pepili ⸤Pulu Yemone nanga ungumu sike pilimbemonga nimbo mele ‘paa sike wendo ombá.’ ningu⸥ tondolo munduku piliengi liemo nane iunjo pikimu tendu mele manda tenge. Unjoma mindi molola. Ne ma pangimundu “Ungú toko nomu kusana sukundu pu.” ninge kinie pumbela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","‘Olio ⸤Pulu Yemone paa sike lipe tapondombamonga ‘Teamili.’ nimolo mele sike manda aku sipu temolo.’ molo ‘Nimolo kinie sike aku sipe wendo ombá.’ ningu⸥ tondolo munduku pilkulie ⸤Pulu Yemo kinie⸥ ungu ningu mawa tenge mele pali Pulu Yemone sike tendembamonga kanu ulume sike wendo ombá.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kanu kinie Yesusi ⸤kamu Jerusalleme omba⸥ ulke tembele kerepulune omba, yemboma ungu mane sipe molorumu kinie ye mare, Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga tapu yema kinie eno ongo yu walsiku pilkulie ningendo: “Nu namba nambolka nambamo likulie ikongonomo telenoye? Nawene ikongonomo ‘Te-pou.’ nimbe nu nambamo sipe lipe mundorumuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesusini enondo topondopa nimbendo: “Nane eno ungu te walsipu piliembola. Pe nane eno walsimbo mele enone na sumbi siku topondoko ningi liemo ‘Na ikongonomo teambo.’ nimbe namba sirimumunge pulumu eno nimbu simbola. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","⸤Nane isipu eno walsipu pilkiru:⸥ Ou ⸤No Lindeli⸥ Jono omba yemboma no linderimu kinie yu mulu koleana molemo yemonga kongonomo tendembando yemboma no linderimu molo ya mana yembomanga kongonomo tendembando yemboma no linderimuye? ⸤Nawene “Tei.” nirimu-ne terimuye? Ningu siee.⸥” nirimu. ⸤Yuni aku sipe walserimu mele pilkulie⸥ enone enono kerepale ningulie ningendo: “Yuni walsikimu mele olione topondopo, ‘⸤Jono⸥ yu mulu koleana ⸤molemo yemonga kongono tendembando yemboma no linderimu⸥..’ nimulu liemo yuni oliondo nimbendo: ‘Aku liemo eno Jonone nirimu ungumu nambemune ‘Iungumu sike.’ ningu naa pilku lsingiye?’ nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Molo olione nimolondo: ‘Yumana yembomanga ⸤kongono tendembando yemboma no linderimu⸥..’ nimulu liemo we yembomane ‘olio tongenje’ nimbu pipili kolkomolo. We yembomane ‘⸤No Lindeli Jono⸥ yu paa sike Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye te molorumu.’ ningu pilimele kene olio nambe-emolonje?” ningu enono aku siku kerepale niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","⸤Enono aku siku anjo yando kerepale ningulie⸥., Yesusindu topondoko ningendo: “⸤Nuni walsikinu mele⸥ olio naa pilkimulu.” niringi. Aku siku niringi kinie pilipelie Yesusini enondo nimbendo: “Kapola. ⸤Nane eno walsikiru ungumunge ungu te topondoko naa nikimilimunge⸥ enone na walsikimili ungumunge ungu te topondopo nando ikongonomo ‘Te-pou.’ nimbe na lipe mundupe namba sirimu yemonga imbimu eno naa nimbu simbola.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","⸤Yesusini kelepa kanu Juda yembomanga ye awilimendo nimbendo:⸥ “Eno nambolka konopu lekemeleye? Ye te yunge kango talo moloringili. Yu pupe kango komomondo nimbendo: “Kangomo, kinié nu unjo-waene poniena puku kongono te-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Yuni topondopa lapando “Molo, na naa pumbo.” nirimu, nalo pe yu konopu alowa tepalie purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Lapa pupe komomondo nirimu mele aku sipe akiliomondo nirimu ⸤kinie⸥ yuni topondopa “Te-pumbo.” nirimu, nalo naa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Kanu kangoselonga nawene lapanga ungumu pilipe lipe terimuye?” nirimu. Enone topondoko “Komomo.” niringi. Yesusini enondo nimbendo: “Nane enondo paa sike nimbu sikirumu: Eno ⸤Juda yembomanga ye awilime⸥ Pulu Yemo ye nomi kingimu molopa nokolemo talapena sukundu ⸤kumbi leko naa punge⸥.. Kou takisi lili yema kinie wapora toli amboma kinie ⸤kanu yemboma, eno Juda yembomanga ye awilimene kanoko keri kanolemelema⸥ kumbi leko punge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","⸤No Lindeli⸥ Jono omba eno sumbi siku molonge aulkemo lipe ora sirimu kinie enone yu nirimumu ‘Kolo tokomo.’ konopu leko yunge ungumu pilku naa lsingi nalo kou takisi lili yema kinie wapora toli amboma kinie yuni nirimu ungumu ‘Sike.’ ningu tondolo munduku pilieringi. Nalo kanu ambo ye kerimene aku teringi kinie kepe kanokolie ‘Konopu alowa tepo ‘Yuni sike nikimu.’ nimbu tondolo mundupu piliemili.’ naa niringila. Akumunge ⸤kanu ambo ye “Tepo kenjilimolo.” ningu konopu alowa telemelema Pulu Yemo molemona kumbi leko punge⸥..” ⸤nirimu.⸥ u ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","⸤Aku nimbelie Yesusini kanu ye awilimendo altopa nimbendo:⸥ “Ungu iko te pea tambo pilieyo. “Kolea pulu ye tene unjo waene ponie tepalie pala terimu. Poniena sukundu loyekolo akupe waene-no ingi tepa mondombando tepa mimi tepalie nirimumuni, pe ponie nokonge ulke takaye te polo kulupe ola takorumu. Ye mare kanopa lipelie enondo nimbendo: “Nanga poniemo tapu tendeko unjo mongoma inie toko nokondangi. Pe waene mongo polo tomba kinie unjo mongoma moke tepo, kongono tendenge mele mare eno liengi mare na liembo.” nimbe kanu poniemo eno sipelie yu kolea paa suluringe pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kanu kinie pe waene mongo polo tomba terimu kinie ponie pulu yemone yunge kendemande ye mare “Nanga waene-mongo siengi puku liku mendeko wangi paa.” nimbe ponie nokoringi yema moloringine lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nalo kendemande yema ⸤oringi kinie⸥ ponienokoli yemane eno ambolko likulie te kopene toko, te toko kondoko, te kouni toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Altopa ponie pulu yemone kendemande ye mare awisili mele lipe “Nanga waene mongo lindi-pee.” nimbe lipe mundorumu, ou kendemande ye koltalo mele lipe mundorumu. Nalo ponie nokoli yemane ou-pulu-pulu oringi kendemande yema-kinie teringi mele pe kendemande oringi yema-kinie akula teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kanu kinie ponie pulu yemo yuni ⸤konopuni pilipelie⸥ ‘Nanga kangomo pipili kolko yunge ungume pilku liku, yu waene-mongoma singe.’ konopu lepalie yunge malomo lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nalo ponie nokoli yemane ponie pulu yemonga malo ombá orumu kanokolie enone enono ningendo: “Andi okomo yemo pe lapanga melema limbe yemo okomo. Yu topo kondopo iponiemo olio kamu liemili.” ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","enone yu ambolko liku poniena ulsu mundukulie yu toko kondoringi.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","⸤Yesusini ungu iko akumu topa pora simbendo kanu Juda yembomanga ye awilimendo walsipelie nimbendo:⸥ “Ponie nokoli yemane aku teringimunge ponie pulu yemo ombalie kanu ponie nokoli yema-kinie yuni nambolka uluri temba konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Enone yundu topondoko ningendo: “Yuni kanu ye kerime ‘kamu molko kenjengi.’ nimbe tepa kenjipelie ponie nokonge ye lupe mare lipe waene-mongo polo tomba kinie waene-mongoma moke teko, mare ponie pulu yemo singe yema poniemo simbe.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesusini ⸤Pulu Yemonga Juda yemboma nokoringi yemane yu toko kondonge mele pilipelie⸥ enondo nimbendo: “Pulu Yemonga bokune sukundu molemo ungu te kanoko naa pilimeleye? ⸤Aku ungumu isipe mele:⸥ “Ulke takoringi yemane kanoko keri kanoko toko lteringi kou kanumu kinié kelepa ulke simu mele ulke enge sindeli kou awili peangamo. Awilimuni aku ulumu terimu olione kanopo paa peanga kanolemolo.” nimbe molemo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aku ⸤nirimu⸥.munge nane eno ⸤Pulu Yemonga Juda yemboma⸥ nimbu sikirumu: Pulu Yemo enonga ye nomi kingi molopa eno nokolemo mele mundupe siye kolopalie nimbémone, yembo talape lupe tene yunge ungumu pilku liku teko molongema lipe nokomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Ikou ⸤nikiru⸥.munge ola yembo te a topa topalie ombele melema elke tomba. Nalo yembo te molombana ola koumu omba yu topalie kanu yembomo topa nurupulu tomba.)” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kanu kinie Pulu Yemo popo tondoringi ye awilime kinie Parisi yema kinie Yesusini ungu iko torumume pilkulie enone yu tonge teko moloringi mele yuni nirimu pilkulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","enone yu ka singe teringi nalo yembomane ‘Yu Pulu Yemone ungu umbu tondolemoma pilipe yando nimbe silimo ye te.’ konopu lieringi kulu yemboma pipili kolkolie yu isili-ou ambolko ka naa siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesusini kelepa ungu mare ⸤Juda ye awilimendo nimbendo⸥ ungu iko te pea topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipe mele: “Ye nomi kingi tene yunge malo ambo limbemonga langi awisili kalondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koronga “Ye ambo limbe langi pea namili sukundu wangi.” nirimu yemboma yunge kendemandemando “‘‘Kinié langi namili waa.” ni-pee.” nimbe mundorumu, nalo puku aku siku niringi kinie eno “Naa omolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Altopa kendemande mare lupe lipe mundupelie nimbendo: “‘‘Langi pea namili wangi.” nirindu yembomando puku ningendo: “Langi tepa mimi tepa pora simu. Yunge kongi kao peleama kinie kongi kao walo wami telime kinie tomu. Langi pali tepa mimi tepa nosilimo kene ye ambo limbemonga langi pea namili waa.” ni-pee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nalo puku niringi kinie naa pilku siye kolko, te yunge poniena pupe, te yunge bisinetena pupe, ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","marene kingimunge kendemandema ambolko liku teko kenjikulie toko kondoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","⸤Aku teringimunge⸥ kingimu mumindili kolopalie yunge ami yemando nimbendo: “Eno molemelena puku toko kondoko enonga koleamo tepe leko to-paa.” nimbe eno lipe mundorumu kinie pukulie, nirimu mele teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kanu kinie kingimuni yunge kendemandemando nimbendo: “Ye ambo limbemonga langi nosilimolo nalo “Pea namili wangi.” nirindu yemboma nonge kapola naa temba kene ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","eno pukulie aulke lupe lupe lemomanga pali puku yembo kanongema “Ye ambo limbemonga langi pea namili waa.” ni-pee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pilkulie kanu kendemandema aulkemanga pali puku yembo kanoringime pali liku maku toringi. Yembo peangama kinie yembo kerime kinie pea liku maku toringi. Kanu kinie ye ambo limbemonga koleana yemboma paa ongo si siku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ongo moloringi kinie kingimu “Yembo maku toko molemelema kanambo.” nimbe eno moloringine ombalie, yemboma ye ambo limbe ⸤makune ongemonga wale-pakoli kamume ‘pakoko sukundu wangi.’ ningu siringi⸥ wale-pakolimenga ye te wale-pakoli akumenga te naa pakopa molorumu kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","yundu nimbendo: “Kangomo, nu ye ambo limbe wale te naa pakokono kanokoro kene nu aulke tena sukundu onuye?” nirimu kinie kanu yemone unguri naa nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanu kinie kingimuni langi nokoringi kendemandemando nimbendo: “I yemo kimbu kime ka tokolie pena kolea sumbulu tokomona toko pena mundee!” nirimu. Akune yemboma paa mindili nongolie kola teko pereko molonge.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","⸤Aku nimbelie Yesusini ungu ikomonga pulumu kamu nimbendo:⸥ “Sike ⸤Pulu Yemone⸥ yembo awisilindu “Waa.” nilimo nalo yembo koltalo mindi mako topa “Sukundu waa.” nilimo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","⸤Yesusini aku sipe nirimu⸥ kinie ⸤pilkulie⸥ Parisi yema ulsu puku eno enono liku maku tokolie ningendo: “‘Yesusini ungu te nimbe kenjepili.’ nimbu nambe-eamiliye?” ningu kerepale ningulie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","eno lombili andolime kinie ye nomi kingi Erotenga talape ye mare kinie liku Yesusi molorumune liku mundoringi, eno puku Yesusindu ningendo: “Ungu Mane Silimu, olio pilimolo, ‘nuni ungu sikema mindi ningu, Pulu Yemone “Teaa.” nilimo ulume paa sike ungume mane siku, nu yembo teluringe kepe konopu kimbu naa siku, yemboma pipili naa kolko enondo pali ungu telu siku kapola kapola ningu silino.’ konopu lemolo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aku siku ningu molenomonga nu nambolka konopu lekenoye? Olione Romo Gapomano Ye Paa Awili Kumbine ‘Sisa’ nilimu kou takisi tomulu liemo kapola molo moloye? Pulu Yemone akumundu ungu mane sirimu ungu mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nalo Yesusini yu-kinie konopu keri panjiku yu teko kenjinge teringi pilipelie enondo nimbendo: “Eno kolo toko topele mapele toli yema, ‘Yuni nimbe kenjepili.’ ningu nambemune na manda manjiku kolo toko walsikimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi tolemele kou mongo te na liku ora siee.” nirimu. Enone yu molorumune te mengo ongo yu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kanu kinie Yesusini enondo nimbendo: “I koune nainge kumbikeremo kinie imbimu kinie molemoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Enone yundu ningendo: “Romo Gapomano Ye Paa Awili Kumbine Sisamonga kumbikeremo kinie imbimu kinie molemo.” niringi. Kanu kinie yuni enondo nimbendo: “⸤Kou monemo Sisamonga⸥ kene Sisamonga melema Sisamo yuyu siku, Pulu Yemonga melema Pulu Yemo yuyu siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yuni aku sipe ⸤paa sumbi sipe⸥ nirimu mele pilkulie ⸤‘Yu paa pilipe konginjeli pelemo yemo lepamo.’ ningu pilku⸥ konopu awisili liku mundukulie yu munduku siye kolko eno puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","⸤Kanu yema Yesusi kinie kou takisi toli ungumu ningu pora siringi kinie⸥ pe aku enamonga Sadusi ye mare Yesusi molorumune oringi. Sadusi yema eno ‘Pulu Yemone pe kolemele yemboma topa naa makinjindimbe, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Aku Sadusi yema ongo Yesusi walsiku pilkulie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ungu Mane Silimu, ⸤Pulu Yemonga ungu manema olio sirimu ye⸥ Mosisini ungu mane sipelie nimbendo: “Ambo limbe ye te ambolango naa membalie kolomba kinie kanu yemo yunge angenu molombamone yunge ambo wayemo lipe angenu lipe tapondopa ambolango mendepili.” nirimu aku sipe bokune molemo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","⸤Aku ungu manemonga ulu te olionga ye mare-kinie wendo orumu mele nu walsipu piliemili.⸥ “Angenupili yepoko pakera moloringi. Komomo ambo lipelie kolorumu. Ambolango te naa molopili kolorumu kulu yunge bulkundu angenumuni ⸤yunge angenu kolorumumunge⸥ ambolango ‘Mendambo.’ nimbe ambo wayemo kelepa lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nalo ambolango te naa mendepalie yu we kolorumula. Yunge bulkundumuni kanu ambomo lsimula nalo yu kepe we kolorumula. Aku teliku pukulie ye yepoko pakera pali ambolango telu kepe naa mengolie kolko pora siringi kinie akiliomo we kolorumula. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pe ambomo yu kolorumula. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akumunge, kolemele yemboma pe lomboroko ola molonge kinie kanu ambomo ye yepoko pakera pali ya mana lsingi kulu ambomo yu ye paa nainge menu molombaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusini enondo topondopa nimbendo: “Eno Pulu Yemonga bokune ungu molemoma kinie, Pulu Yemo kinie tondolo pelemo mele kinie, naa pilku lou lemelemonga ⸤yemboma pe tengemondo nikimili mele pilku sunduku kolo tokomele⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lomboroko ola molonge yembomanga yema ambo naa liku, amboma ye naa puku, aku paa naa tenge. Mulu koleana molemele angelloma molemele mele aku siku molonge. ⸤Angellomane mana yemboma telemele mele naa telemele kanumu.⸥ Aku tengemonga ⸤‘Eno Pulu Yemonga ungumu pilku sunduku lawa telemele.’ nikiru.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","“Nalo ⸤eno Sadusimene⸥ ‘Kolemele yemboma lomboroko ola naa molonge.’ konopu lemelemonga ungu te Pulu Yemone enondo nirimumu enone naa kanoko pilimeleye? Yuni isipe nimbendo: “Na Eporayamo kinie Aisake kinie Jekopo kinie enonga Pulu Yemo molio.” nirimu. Pulu Yemonga bokune aku ungu molemomo naa kanoko pilimeleye? ⸤‘Enonga Pulu Yemo molorundu.’ naa nirimu. ‘Enonga Pulu Yemo molio.’ nirimu kanumu.⸥ Pulu Yemo yu kololi yembomanga Pulu Yemo molo; yu konde mololi yembomanga Pulu Yemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yuni aku nirimu mele yembo maku toko moloringimene pilkulie yunge ungu mane sirimu ungume pilkulie pungu-pungu ningu paa konopu awisili liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nalo Yesusini aku ungu nirimumuni Sadusi yemanga ungumu pipi sinderimu, eno ungu te naa perimu-ne Parisi yemane pilkulie eno liku maku toko ⸤Yesusi molorumune⸥ oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","⸤Oringi kinie⸥ enonga ye te, yu Pulu Yemonga ungu manemanga pulume pilipe kondorumu yemone ‘Yuni nimbe kenjimbenje manda manjipu piliembo.’ nimbe Yesusindu walsipe pilipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ungu Mane Silimu, Pulu Yemone ungu mane sirimu pelemomanga nambolka ungu manemo yu olandopaye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesusini yundu nimbendo: “Ungu mane olandopamo isipe: ‘Enone enonga kamelema kinie, enonga minime kinie, enonga pilipe konginjelime kinie, akumene Awilimu enonga Pulu Yemo manjiku tondolo munduku konopu mondangi.’ aku nimbe pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aku ungu manemo yu paa tondolo, olandopamo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Talo sipe ungu manemo yu-kinie telu sipe mele. Akumu isipe: ‘Enone enono yu-mele-mele konopu mondoko enonga kangimu enono kondo kolko nokolemele mele aku sikula pulu lemo yemboma konopu mondoko nokoko molangi.’ nimbe pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pulu Yemonga ungu mane Mosisini sirimume pali kinie, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane bokune toringi ungume pali kinie, kanu ungumenga pulumu aku ungu maneselo mindi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kanu kinie Parisi yema aku siku we maku toko molangi Yesusini enondo isipe walsipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimundu enone nambolka konopu lekemeleye? Yunawe? Yu nawene kalopa limbe konopu lemeleye?” nirimu kinie enone ningendo: “⸤Ye nomi Kirasimu yu ye nomi kingi⸥ Depisini kalopa limbe ye te.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yuni altopa eno walsipelie nimbendo: “Aku liemo ⸤Pulu Yemonga⸥ Minimu Depisinge konopune molopalie ungu te nirimu kinie Depisini pilipelie ye nomi Kirasimundu “Awilimu” nirimu akumu nambemune nirimu konopu lekemeleye? Depisi yuni ⸤ye Kirasimu molomba mele⸥ isipe nirimu: ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Awili ⸤Pulu Ye Yawene⸥ nanga Awilimundu nimbendo: “‘Nunge opa puluema nuni nokani.’ nimbu, pe eno topo manie mundundumbo kene isili-ou nu ⸤na kinie pea tapu topolo ye nomiselo molopolo melema nokambili⸥ nanga ki umbukundu ongo molani.” nirimu.” nimbe Depisini nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depisini ⸤ye nomi Kirasimu⸥ yundu “Nu nanga Awilimu.” nirimu liemo yu pe nambepa Depisini kalopa limbe ye te ⸤mindi⸥ molombaye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","⸤Yesusini aku sipe walserimu mele pilkulie⸥ ye akune moloringimenga tene ungu telu kepe topondoko manda naa niringi. ⸤Enone yu walsiku pilieringi ungume pali yuni topondopa anjo nimbe kondorumu pilkulie⸥ pe altoko yu ungu te walsiku pilingendo pipili kolko naa walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kanu kinie Yesusini yembo maku toringime kinie, yunge lombili andoli yema kinie, ungu nimbe sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pulu Yemonga ungu manemanga pulume pilku mane silimele yema kinie Parisi yema kinie enone Mosisini ungu manemanga pulume mane sirimu mele yandopa mane silimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Akumunge kanu yemane eno mane silimelema pali mimi siku pilku teangi, nalo kanu yemane mane silimele mele kanu yema enono pilku liku naa telemelemonga kanu yema enone ulu telemelema manda manjiku naa teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yembo tene wale umbune teli te tepa mimi tepalie yembo te ‘mepili.’ nimbe ola lipe bulune mendelemo mele ⸤aku siku kanu yemane yembomando ungu mane siku “I siku i siku teaa.” ningu⸥ umbune silimele nalo laye-kolte kepe ‘Lipu tapondopo meamili.’ naa nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kanu yemane ulu telemelema ‘we teamili.’ ningu naa telemele. ‘Yembomane olio kanokolie ‘molko kondolemele.’ ningu kanangi.’ ningu ulume telemele. Pulu Yemonga ungu manema molemo pepá te kulupi toko mambelena molo kíne ka tongendo ‘Yemboma paa kanangi.’ ningu kulupi paa awili teko toko, enonga wale-pakolimenga ka moko toko mondongendo ka sulu peanga mare awili teko moko toko mondolemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yembomane langi nongo yembomando “Namili waa.” nilimele kinie kanu yema ongolie ye awilimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. Yemboma maku toko Pulu Yemonga ungumu pilimele ulkena sukundu pukulie manie molongendo ye awilime molemele polo peanga akune ‘molamili.’ ningu mendo puku polo akune konopu siku molemelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yemboma maku toko molemele koleana andongendo mongo-kenge teko ‘We yembomane olio kanoko kapi niengi.’ ningu pilkulie konopu siku pilku andoko molemelela. Yembomane enondo ‘Rapai’ nilimele kinie paa konopu silimelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“⸤Kanu yemane aku telemele⸥ nalo enonga nokoli ye awili telumu mindi molemo, eno pali angenupili molemele kene yembomane “eno olionga Rapaime.” naa niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Enonga Lapa telumu mindi molemo, akumu mulu koleana molemo, akumunge mana yembo tendo ⸤‘olionga ye awilimu’ ningu⸥ “Tata” naa niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu mindi enonga nokoli ye awilimu molemo kene yembomane enondo ⸤‘olio nokolemo yemo’⸥ ningu “Ye Awilimu” naa laniengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Yembo tene yunge imbimu yuyu lipe ola mundumbe kinie ⸤Pulu Yemone⸥ yunge imbimu topa manie mundumbe; yembo tene yunge imbimu yuyu topa manie mundumbe kinie ⸤Pulu Yemone⸥ yunge imbimu lipe ola mundundumbe kene enonga ye te eno nokomba ye awili te molopa enonga kongono kendemande yemo molopili.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","⸤Yu lombili andolimendo ungu nimbe kelepalie Yesusini Juda yembomanga ye awili moloringimendo nimbendo⸥.: “Eno Pulu Yemonga ungu manemanga pulume pilku mane silimele yema kinie, Parisi yema kinie, eno mindili nongo paa molko kenjinge! Eno topele mapele toli yema! Enone yemboma Pulu Yemo ye nomi kingi molopa nokolemo mulu koleana punge pulimele kerepulumu pipi silimele. Eno enono sukundu naa pulimele; yembo lupema punge telemele kinie aulkemo pipi siku “Molo.” nilimelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“(Eno ungu manemanga pulume pilku mane silimele yema kinie Parisi yema kinie eno mindili nongo paa molko kenjinge! Eno topele mapele toli yema! Enone ambo wayema liku lou siku enonga ulkema wa liku, enone ‘Yemboma kanangi.’ ningu Pulu Yemo kinie ungume sulu teko we ningu angilimele, akumunge kote walemo wendo ombá kinie eno-kinie umbune awili tepa pemba.) ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Eno ungu manemanga pulume pilku mane silimele yema kinie Parisi yema kinie eno mindili nongo paa molko kenjinge! Eno topele mapele toli yema! ‘Yembo telu mindi kepe konopu alowa tepa olio lombili andomba kinie papu.’ ningu ma koleamanga kimbu kongono teko kolea sulumenga puku, nomu-kusa sipimenga andolemele nalo pe yembo te sike enone nilimele ungume pilipe lipe konopu alowa tepa lombili andolemo kinie kanu yembomo tepa kenjilimo mele paa olandopa, enone teko kenjilimele mele maniendopa, akumunge yu tepe koleana paa sike pumbe aulkemo akisindilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Eno mongo keri lielimene “⸤Mongo keri lieli⸥ yemboma aulkemo lipu ora siemili.” nilimele yema eno mindili nongo paa molko kenjinge! Enone yemboma mane sikulie ningendo: “Yembo tene mi lembando ‘ulke tembelemo’ imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele naa temba kinie uluri molo. Nalo yembo tene mi lembando “ulke tembelena ape kandoringi kou-gollomo” imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele naa temba kinie kapola naa temba. Yu sike kamu tepili.” nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Eno aroma toko mongo keri lieli yema! Mele nambolka melemo olandopaye? Kou-gollo akumu mele olandopamo molo Pulu Yemo molemo ulke tembelemone kou gollo mako topa ‘Pulu Yemonga’ nimbe kake tendelemo ulkemo olandopaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Enone ungu te pea yemboma mane sikulie ningendo: “Yembo tene mi lembando ‘Pulu Yemo popo toko melema kalemele polomo’ imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele naa temba kinie uluri molo. Nalo yembo tene mi lembando “aku polona ola melte singemo” imbi lepa “Paa sike tembo.” nimbelie pe “Tembo.” nimbe panjimbe mele naa temba kinie kapola naa temba. Yu sike kamu tepili.” nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Eno mongo keri lieli yema! Mele nambolka melemo olandopaye? Polona ola ‘Pulu Yemo popo toko kalondangi.’ ningu silimele melemo olandopamo molo polomone kanu melema mako topa ‘Pulu Yemonga’ nimbe kake tendelemo polomo olandopaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Akumunge, yembo tene mi lembando ‘Pulu Yemo popo toko melema kalemele polomo’ imbi lemba kinie mele polona ola lemba melemo kepe imbi lepa mi lemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aku sipela yembo tene mi lembando ‘ulke tembelemo’ imbi lemba kinie ulke tembelemo kinie akune sukundu molemo yemo kinie imbi lepa mi lemba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yembo tene mi lembando ‘mulu koleamo’ imbi lemba kinie Pulu Yemo ye nomi kingimu molopa kolea nokombando molemo polomo kepe aku polona ola molemo yemo kepe imbi lepa mi lembala. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Eno ungu manemanga pulume pilku mane silimele yema kinie, Parisi yema kinie, eno mindili nongo paa molko kenjinge! Eno ‘sike ungume nikimulu.’ ningu kolo toko topele mapele toli yema! Langi kalongendo ‘songo tepili.’ ningu enonga poniena mele kanga lupe lupe olemomanga inie toko langine mundulimele akumenga ungu mane te pelemomo pilku tene tene ningu nosilimelemanga telu telu Pulu Yemonga ningu yu silimele. Aku telemele nalo ungu mane tondolo olandopa mare munduku siye kolko naa pilku telemele. ‘Yemboma apuruku yembo awilime liku tapondoko yembo kerime teko kenjiku naa teko, yemboma naa apuruku pali kondo kolko, Pulu Yemo ‘Sike.’ ningu tondolo munduku pilku “Temolo.” nilimele mele sumbi siku teko molko, aku teangi.’ nimbe pelemo ungu manemando nikiru. Ungu mane wema pilku telemelema munduku siye naa kolko ‘mare naa telemele’ nikiru akume pali telemelanje papu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eno mongo keri lielimene “⸤Mongo keri lieli⸥ yemboma aulkemo lipu ora siemili.” nilimele yema, eno ⸤ungu mane wema tondolo munduku pilku teko, ungu mane tondoloma naa pilku telemele aku telemele mele ungu iko topo niembo:⸥ Langi nongendo mele kanga lopalo molo lomou langine pelemo kanokolie ‘Naa namili.’ ningu wendo liku ltelemele, nalo kongi kao te langine pelemo kinie naa kanoko we liku toko penge mundulimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Eno ungu manemanga pulume pilku mane silimele yema kinie Parisi yema kinie, eno mindili nongo paa molko kenjinge! Eno topele mapele toli yema! Pellete kapomanga ulsukundu kulumiye toko kondolemele nalo akumenga sukundu langi pelemoma enone tondolo munduku wa liku, enone enono waka kolko enono konopu kimbu siku limele ulume. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Eno mongo keri lieli Parisi yema! Pellete kapomanga sukundu kulumiye tonge kinie ulsukundu kepe kake temba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Eno ungu manemanga pulume pilku mane silimele yema kinie Parisi yema kinie, eno mindili nongo paa molko kenjinge! Eno topele mapele toli yema! ‘Yembo ono koleamo kanoko peanga kanangi.’ ningu pene kake telimu ape kandolemele mele eno aku silime mele molemele. Yembo ono koleama sike ulsukundu peanga lemo kanolemele nalo sukundu yembo kololimenga ombelema kinie mele puroli nurupulume kinie peke lepa pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eno aku siku mele molemele. Yembomane enonga kalkundu kanokolie ‘Eno ye sumbi nilime’ konopu lemele nalo enonga konopune sukundu kolo toli ulume kinie ulu pulu kerime kinie mindi si nimbe pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Eno ungu manemanga pulume pilku mane silimele yema kinie Parisi yema kinie eno mindili nongo paa molko kenjinge! Eno topele mapele toli yema! Pulu Yemone ungu umbu tondolemoma pilku yando ningu silime kolemele kinie enonga ono telemele koleama teko mimi teko, sumbi nili yembomanga ono koleama asilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aku tekolie enone ningendo: “Olio olionga anda-kolepalime-kinie molemelanje enone Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema toko kondoringi kinie olionga anda-kolepali naa lipu tapondopo eno naa tolemela.” nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aku nilimelemonga ‘Kanu yema toko kondoringi yembomane kalko lsingi yema molemolo.’ ningu enono liku ora silimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aku liemo kapola enonga anda-kolepalimene pulu polko teko kenjeringi mele enone kamu teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“⸤Yemboma nongo kondoli⸥ wambiyema! Eno kolo topa yemboma tepa kenjeli wambiyemonga waloma! Pulu Yemone enondo “Teko kenjeringimunge tepe koleana paa.” nimbé kinie eno manda kowa punge aulke te lembaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Akumunge nane Pulu Yemone ungu umbu tondombama pilku yemboma ningu singe yema kinie, pilipe konginjeli pemba yema kinie, mane singe yema kinie, eno molemelena lipu mundukuru. Aku yemanga mare toko kondoko, mare ‘Kolangi.’ ningu unjo perana uku toko mondoko, mare eno maku toko Pulu Yemonga ungumu pilieli ulkemanga mengo puku ka-pulsene toko, koleamanga ‘tamili.’ ningu pulú siku akiliku lombili punge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aku tengemonga ou pulu pulu ⸤Pulu Yemone mulu maselo terimu kinie⸥ kepe yandopa kinié kepe yembo sumbi nilime toko kondoringimunge ulu umbunema eno ⸤Juda yembomanga ye awilime⸥-kinie pemba. ⸤Pulu Yemonga bokune⸥ ou pulu pulu sumbi nili ye Epele kinie, yandopa moloringi yembo sumbi nilime kinie, yandopa ⸤Pulu Yemonga bokumu pora nilimo akune⸥ Berekia malo Sekaraya kinie toko kondoringi akumenga pali ulu umbunema eno-kinie pemba. Sekaraya akumu Pulu Yemonga ulke suluminia lierimu ulkemo kinie Pulu Yemo popo toko melema kaloringi polomo kinie awi-suku-singine toringi kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nane paa sike enondo nikiru: Ou teko kenjeringi ulumenga pali ulu umbunema iyembo kinié molkomelema-kinie pemba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","⸤Aku nimbelie Yesusini Jerusalleme moloringi yemboma yu kondo kolopa akumundu ungu te nimbelie nimbendo:⸥ “O Jerusalleme ⸤yemboma⸥., Jerusalleme ⸤yemboma⸥., Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema toko kondoko, yuni yemboma ‘liku tapondangi.’ nimbe eno moloringine lipe mundorumu yema kouni toko kondoko telemele yemboma, kera gulta anumumuni yunge waloma lipe yunge kongona lopi tepa nokolemo mele nane wale awisili eno aku sipu nokolka nalo enono “Molo!” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akumunge pilieme! ⸤Opa puluema eno tonge onge kinie Pulu Yemone altopa eno naa nokopa naa lipe tapondombamonga⸥ opa puluemane ongo sike toko munduku enonga koleamo kinie enonga ulke tembelemo kinie kamu toko kalongemonga eno ku penge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Akumunge ⸤nane eno ungu te pea nimbu sikiru:⸥ Eno Jerusalleme yemboma, enone nando “Pulu Ye Yawene lipe mundorumu-ne okomo yemo imbi ola molopa, molopa kondopili.” ninge walemonga na altoko kanonge. Ou molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kanu kinie Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena ulsu pupe aulkena pumbe purumu kinie yu lombili andolime ongo ulke tembelemonga ulke lupe lupe ⸤paa peanga angilieringime⸥ yu “Kanou.” ningu liku ora siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","⸤Aku teringi kinie⸥ yuni enondo nimbendo: “Ya ⸤ulke tembele peanga angilimo⸥ kanokomele melema pali paa sike nimbu sikirumu: ⸤Pe walse ya kolea awili Jerusalleme yemboma mindili nonge walemo wendo ombákinie⸥ i ulke tembelemo tekisikulie koume pali toko manie mundunge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kanu kinie yu ma pangi Unjo Ollipi Poniena ola pupe manie molorumune we yemboma naa molangi yunge lombili andoli yema ongo eno enono molkolie yundu walsiku pilkulie ningendo: “Nuni nikinu mele tewale wendo ombáye? Pe nu nondoko oni teni walemo kinie kepe ma pora nimbé walemo kinie kepe wendo ombándo ou nambolka uluri temba kinie olio kanopolie “Kinié ombá tekemo.” nimbu pilimoloye? Ningu si.” ningu walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yuni enondo nimbendo: “⸤Kanu ulume wendo ombámonga ungu mare⸥ yembomane eno kolo toko singe kene kanoko kondoko molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ye awisili ongo na molio mele yu mele mele kolo toko ningendo: “⸤Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasi⸥ akumu na.” ningulie aku siku kolo toko singe kene kanoko kondoko molangi. Yembo awisilini kanu yemanga ungume pilku liku “Sike nikimili.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Kolea marenga opa awili teko tenge mele pilku, ‘Opali talou opa awili isipe isipe wendo ombá.’ ningu we ninge kinie pilkulie mini-wale naa mundengi. Opa tengema kinie aku ulume Pulu Yemone ‘Ou wendo opili. Laye pe mele ya ma koleamo pora nimbé.’ nimbe, nimbe panjerimumunge aku ulume sike wendo ombá nalo aku kinie mulu maselo ou naa pora nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","⸤Mulu ma pora nimbé walemo ou wendo naa opili⸥ yembo talape awili te kinie talape awili te kinie opa tekolo, ye nomi kingi marenga talapema kinie marenga talapema kinie opa tenge. Ya ma kolea tenga tenga engele lepa, ma jimi-jimi tepa, aku sipe temba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ambo tene ambolango kokele kanopa limbendo ou mini topa mindili nolemo mele, mulu ma pora nimbé walemo kokele wendo ombándo umbune lupe lupe aku sipema ou wendo ombá.” ⸤nirimu⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kanu ulume wendo ombá walemanga ‘⸤Na lombili andoli yemboma⸥ mindili nongo, kolangi.’ ningu ⸤eno mare⸥ kote teko ka singe. Nanga yemboma molko nanga ungume andoko ningu singemonga koleamanga pali yembomane eno kinie mumindili kolko konopu keri panjinge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","⸤Kanu umbunema wendo ombá⸥ walemanga na ‘Sike.’ ningu tondolo munduku pilinge yembo awisili tondolo munduku pilinge mele munduku siye kolko anjo yando enono konopu keri panjiku, ‘Kirasinge yemboma molemelemonga mindili nangi.’ ningu enonga opa puluema liku singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","⸤Kanu walemanga⸥ Pulu Yemone ungu umbu tondolemoma naa pilku we kolo toko yando ningu singe yembo awisili wendo ongela. Aku tenge kinie we yembo awisilini ‘Sike nikimili.’ ningu enonga ungume pilku linge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ulu paa keri awisili olandopa olandopa wendo ombámonga nanga yembomane ⸤anjo yando⸥ konopu mondonge mele ⸤kinie, na konopu mondonge mele kinie⸥ munduku siye kolongela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nalo nanga ungumu munduku siye naa kolko mulu ma pora naa nipili tondolo munduku molonge yemboma ⸤Pulu Yemone⸥ lipe tapondopa ‘Mindili nonge koleana naa puku pea molopo kondopo mindi pamili.’ nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pulu Yemone ye nomi kingimu molopa yemboma nokombamonga temane peangamo ‘Yemboma pali piliengi!’ ningu koleamanga pali andoko ningu singe kinie pe mulu ma pora nimbé walemo kamu wendo ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(⸤Na ibokumu tokoro yemone eno boku kanokomele yembomando ungu te niembo:⸥ ‘⸤Yesusini nirimu⸥ ungumu inie anjokondo molemo akumu eno imbi kanokomele yembomane ungu pulumu paa pilku kondangi.’ nimbu nikiru: ⸤Yesusini nimbendo:⸥ ) “Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Denielene bokune imbi topa nimbe sirimu mele yembo tepa pipili kondoli mele paa kerimu ⸤ulke tembelena suku⸥ Pulu Yemonga ulke suluminia kake teline angilimbemonga kolea akumu paa kalaro molomba mele nirimu, bokune molemo. Aku mélemo akune wendo omba angilimbe kanokolie ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","⸤‘Umbune awilime wendo ombá tekemo.’ ningu pilku⸥ kolea Judia poropinji koleamanga molonge yemboma ⸤enonga koleama munduku siye kolko⸥ ma pangi lembamanga kowa pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yembo te ulke imune ola molopili ⸤aku sipe wendo ombá kinie kanopalie⸥ kowa pumbendo manie omba ‘Melema lipu membo pambo.’ nimbe ulkena sukundu naa pupili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yembo te poniena molopalie ⸤‘Kowa pambo.’ nimbe⸥ kelepa ulkendo pupe yunge ali-wale sulumu naa lipili. ⸤Sumbi siku kowa mindi pangi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aku sipe wendo ombá walemonga ambo ambolango mondongema kinie, ambo ambolango ame singema kinie, ⸤eno manda lkisiku kowa naa pungemonga⸥ eno-kinie paa umbune wendo ombámonga eno kondo tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Pulu Yemo mawa tekolie, ‘Ali telemo olimenga kinie ⸤koro molopo manda naa andomolo⸥ wale Sambatemanga kinie manda kowa naa pumolo kene kanu walemanga kanu umbunema wendo naa opili.’ nieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kanu walemanga umbune paa awilime wendo ombá, ou mulu maselo pulu polopa terimu kinie kepe, yandopa kinié kepe umbune aku sipe te wendo naa orumu. Pe kepe aku sipe umbune awilime naa wendo ombála. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","⸤Kanu umbunema wendo ombá kinie Pulu Yemone⸥ ‘Nondopa pora nipili.’ nimbe ou naa nimbe panjilkenje yemboma pali kolemela. Nalo Pulu Yemone ‘Nanga yemboma molangi.’ nimbe mako torumu yemboma ‘Pali naa kolangi.’ nimbe ‘Umbune wale akume nondopa pora nipili.’ nimbe, nimbe panjerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kanu umbunema omba pemba walemanga yembo marene ningendo: “Kanaa! Pulu Yemone “Olio nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu ya omba molemo.” ninge molo “Nena omba molemo.” ninge kinie enonga ungume naa pilku, ‘Sike nikimili.’ ningu naa piliengi! ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ye mare ongo kolo tokolie ningendo: “Pulu Yemone mako torumu ye nomi Kirasimu na.” ninge, molo kolo tokolie “Pulu Yemone ungu umbu tondomume pilipulie ombo nimbu sikimulu.” ninge. ‘Yemboma pali, Pulu Yemone ‘Nanga yemboma molangi.’ nimbe mako torumu yembomane kepe lipu lou sipu, nikimulu mele ‘Sike.’ ningu tondolo munduku piliengi!’ ningu Pulu Yemone mindi ulu tondolo kapola telemoma mele manda manjiku ulu paa tondolo awisili tenge. Nalo Pulu Yemonga yemboma aku siku kondi tonge kinie enonga ungume naa pilku, liku su singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pe ulu akume wendo ombá mele ‘Eno ou piliengi!’ nimbu ya nimbu sikiru mele piliee. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“⸤Wendo ombá mele nimbu sikiru, pilkimili⸥ kene pe yembo tene nimbendo: “⸤Ye nomi Kirasimu⸥ ne yembo naa peli kolea ku lieline molemo.” nimbé kinie ‘Kanamili.’ ningu akune naa payo. Molo “I ulkemonga suluminiana molemo.” ningi liemo enone ‘Sike nikimili.’ ningu naa piliengi! Mulune kariapá telemo kinie ena mundi wendo olemo koleana kepe ena pulimo koleana kepe kariapá telemo walsikele kanolemele, aku sipe Manie Omba Mana Ye A Lierimu Yemo ⸤altopa⸥ manie ombá kinie koleamanga pali yembomane yu walsikele kanonge aku kene “Ya molemo ongo kanaa.” ninge kinie, molo “Ne molemo puku kano-paa.” ninge kinie, enonga ungume naa piliengi! ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mele kololi te lemo koleana kera ilsepema ongo maku tolemele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kanu walemanga aku mindili nonge nikiru ulume wendo ombá kinie pe sumbi sipe ⸤ulu lupe lupe mare wendo ombála. Akume isipe:⸥ ‘Kolea tangombando ena pa telemo mele naa tepa, sumbulu topa, oli ipulueli pa telemo mele naa tepa, kombukandipime mulune manie omba, mulune angilimo mele tondoloma lope lope tepa anjo yando pupe, aku sipe ulu lupe lupema wendo ombá.’ ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kanu ulume wendo ombá kinie Manie Omba Mana Ye A Lierimu Yemo kamu ombá temba mele lipe ora simbe melte mulune angilimbe kinie ⸤kanokolie⸥ koleamanga pali yembomane paa kola awili-teko tenge. Pe kanoko molangi Manie Omba Mana Ye A Lierimu Yemo tondolo pulimu kinie, pa awili-tepa telimu kinie kupe tenga suku molopa kamu manie ombá yembomane kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kanu kinie biyukele ungu paa tondolo tepa nipili yuni yunge angelloma lipe mundumbe kinie eno winjo mendo anjo yando mulu ⸤ma koleamanga⸥ pali puku Pulu Yemone ‘Nanga yemboma molangi.’ nimbe ou mako torumu yemboma sukundu sukundu linge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Unjo pikimuni telemo aku sipe ungu iko mele pelemo kene pilkulie ungu pulumu piliee. Unjo piki kuku topa gomo tolemo kinie kanokolie ‘Kinié ena temba walemo wendo ombá tekemo lemo.’ ningu pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aku sipela, iulu “Wendo ombá.” nikirume sike wendo ombá kinie kanokolie ningemone ‘Yu paa sike nondopa ombá tekemo. Yu paa kamu okomo.’ ningu pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nane enondo paa sike nimbu sikirumu: Kinié molemele yemboma ou naa kolangi i “Wendo ombá.” nikiru ulume pali wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mulúmu kinie mamo kinie pora nimbé nalo nanga ungu nilioma paa pora naa nimbé. ⸤Nilio mele pali paa sike wendo ombá.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“⸤Manie Omba Mana Ye A Lierimu Yemo paa sike ombá⸥ nalo yu ombá walemo naa pilimolo. Ipulueli ombáne, tangoli ombáne naa pilimolo. Mulu koleana angelloma kepe naa pilimelela. Pulu Yemonga Malo kepe naa lapilimo. Tata yuyu mindi ⸤aku walemo⸥ pilipe molemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ou ye Noa molopili yembomane teringi mele Manie Omba Mana Ye A Lierimu Yemo ombá temba kinie yembomane aku siku tengela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","⸤Ma koleamanga pali⸥ no ou naa topili yemboma langi nongo, yema ambo liku, amboma ye puku, aku ulume mindi teko mololiku puringi. Noa nona andoli sipi ulkemonga suku purumu kinie kepe eno aku ulume mindi we teko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Eno ⸤Noanga ungumu⸥ naa pilku aku siku ulume mindi teko molangi no topa ⸤koleama pali none aki topa⸥ yemboma pali topa kondorumu. Pe Manie Omba Mana Ye A Lierimu Yemo kelepa ombá walemonga ou Noa molopili teko moloringi nikiru mele aku siku teko molongela. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yu ombá walemonga ye talo lamana unjo toko angilingele kinie ⸤Pulu Yemonga angello tene omba⸥ ye te we molopili mundupe siye kolopa te lipe memba pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ambo talo langi kalongele teko molongele kinie ⸤angello te omba⸥ ambo te we molopili mundupe siye kolopa te lipe memba pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Akumunge enonga Awilimu ombá walemo paa naa pilimele kene ‘Yu ombá.’ ningu kanoko molaa.” ⸤nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Eno iungumu konopu liku munduku pilieyo: Ulke pulu ye tene ipulueli wa noli ye tene yunge ulkemo omba bulsupe melema wa limbe mele pilkenje ‘Wa noli yemo ombá.’ nimbe nokopa molka kinie wa noli yemo yu manda suku naa olka. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aku siku eno nokoko molaa. Manie Omba Mana Ye A Lierimu Yemo ombá enamo naa pilimele kene ‘Yu sike ombá.’ ningu aku siku nokoko molangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“⸤Akumunge ungu te niembo:⸥ Kongono tendeli kendemande ye nawene kongono tepa kondondolemo kinie kanopalie yunge ye awilimuni ‘Yuni kongono silioma sumbi sipe telemomonga yu kongono simbo kinie tepa kondombamonga na altopo konopu kimbu sipu naa molombo.’ nilimoye? Kendemande ye te aku sipe mele tepa kondopa molemomo kanopalie yunge ye awilimuni yu mako topalie yundu nimbendo: “Kongono tendeli kendemandema pali nokondoko enonga langi nongema ena mako toliomonga eno nangi moke teko sieni, nokondoko molou.” nimbe ⸤yu tenga pulimo⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pe ye awilimuni kongono simumu kanu kongono tendeli kendemandemone mimi sipe tendepa molopili awilimu kelepa omu liemo kendemandemo yu konopu sipili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nane enondo paa sike nimbu sikirumu: Kanu ye awilimuni kanu kendemandemondo “Nanga mele nosilioma pali nuni nokondou.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Nalo ⸤ye awilimuni kanu kendemande yemondo nimbendo: “Nanga kendemande yemboma pali nokondou.” nimbe tenga pulimo kinie⸥ kanu kendemande yemone tepa kenjipe “Nanga awilimu welea naa ombá.” konopu lepalie yuni nokondolemo kendemande yemboma kopene topa, no nongo kekelepa toli yema kinie langi nomba no tondoloma nombalie, aku sipe tepa kenjipe molomu liemo ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","walse kanu kendemande yemo ‘Yunge ye awilimu ombá.’ nimbe naa pilipe ⸤kongono sirimu mele naa tepa⸥ walu tepa kenjipe molomba kinie ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Omba ⸤kanu yemo tepa molomba mele kanopalie⸥ yu paa kopene topa kondopalie, kolo tolemele yembo topele mapele toli yemboma ⸤kolea keri⸥ molemelena ‘Pupili.’ nimbe lipe mundumbe. Kanu koleana yemboma paa mindili nongo kola teko pereko molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","⸤Aku nimbelie nirimumuni, Yesusini yuyu kelepa ombá mele ungu mare pea nimbelie nimbendo:⸥ “⸤Manie Omba Mana Ye A Lierimu Yemo kelepa wale talo sipe mana manie ombá kinie⸥ Pulu Yemo ye nomi kingimu molopa yemboma nokomba akumu isipe mele: “Ye te ambo limbe ulume yemboma pea tengendo kanu yemboma maku toko moloringine yemo ombá terimu kinie pilkulie ‘Ipulueli ombá.’ ningu ambo wenepo rureponga talo enonga tepe-llamema liku “Yu aulkena limolo.” ningu puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kanu ambo wenepomanga kise pakera konopu naa pepili aroma toko moloringi; kise pakera pilipe konginjeli pepili moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Konopu naa pepili aroma toko moloringi ambo wenepomane enonga tepe-llamema mengo puringi nalo llame karasene pea naa mengo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nalo pilipe konginjeli pepili moloringimene karasene kinie enonga tepe-llamema kinie mengo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ambo limbe yemo welea naa orumu kulu ambo wenepoma pali uru orumu-ne uru peringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kanu kinie awi-burumi ungu te wendo omba nimbendo: “Ambo limbe yemo okomo kanayo! Aulkena liengi waa!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kanu kinie ambo wenepoma ola angilku tepe-llame ‘Awili tepa nopili.’ ningu teko mimi teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Konopu naa pepili moloringimene pilipe konginjeli pepili moloringimendo ningendo: “Olionga tepe-llamema kumbulkumu kene enonga karasene mare olio liku munduku siee.” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","pilipe konginjeli pepili moloringimene topondoko ningendo: “Karasene eno kinie olio kinie manda naa tembanje. Eno sitoana puku enonga topo toko li-pee.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanu kinie sitoana topo toko lingendo puringi kinie ambo limbe yemo orumu. Kanu kinie ye ambo limbemonga langi akune nongendo maku toringi yemboma, pilipe konginjeli pepili moloringi wenepoma pea ulkena suku puringi. Kanu kinie ulke kune toko ingi siku langi nongo moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pe langi nongo molangi ambo wenepo sitoana puringime ongolie ningendo: “Awilimu, Awilimu, olionga kune ongo lindei.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nalo yuni enondo topondopa nimbendo: “Nane enondo paa sike nimbu sikirumu: Na enonga imbime naa pilkiru. ⸤Ulsu molemelema manda sukundu naa onge.⸥” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","⸤Aku nimbelie yuni altopa nimbendo:⸥ “Aku sipe temba kene Manie Omba Mana Ye A Lierimu Yemo kelepa ombá walemo kepe eno naa pilku, ipulueli-ou ombáne tangoli ombáne, ipulueli ombáne, naa pilimele kene yu ombá nokoko kondoko molaa.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","⸤Nimbelie Yesusini ungu iko te pea topalie nimbendo:⸥ “⸤Pulu Yemone ye nomi kingimu molopa yemboma nokolemo akumu⸥ isipe melela: “Ye te kolea tenga pupe molombando yunge kendemande yema “Waa.” nimbe yunge melema “Nokondaa.” nimbelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","enone kongono telemele mele pilipe apurupe yunge melema eno moke tepalie ye te kou pape tausini kina mele sipe, te kou tu tausini kina mele sipe, te wane tausini kina mele sirimu. Aku tepalie yu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ye pape tausini kina lsimumu sumbi sipe pupe kanu koumuni bisinete tepalie nirimumuni, kou pape tausini kina olandopa pupe lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aku sipela ye tu tausini kina lsimumu olandopa tu tausini kina pupe lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nalo wane tausini kina lsimumu pupe ‘Lopi teambo.’ nimbe yuni mana muru akupe yunge nokoli yemonga koumu lowa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kanu kinie wale awisili omba purumu kinie kanu kendemandemanga nokoli yemo omba enondo nimbendo: “Koume eno teringi mele kanambo liku ora siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kanu kinie pape tausini kina lsimu yemone pape tausini kina olandopa pupe lsimumu memba ombalie nimbendo: “Awilimu, nuni na pape tausini kina sirinu kanumu. Nane pape tausini kina olandopa pupu lsindumu i ambolkoro kanou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nokoli yemone yundu nimbendo: “Kendemande ye peangamo, paa papu terinu. Kongono wallo kolte mele sirindumu nuni teko kondorunumunge “Nuni nanga mele awisili nokondou.” nimbo kene nu ongo na pea tapu topo konopu sipu molambili ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ye tu tausini kina lsimu yemo yu kepe ombalie nimbendo: “Awilimu, nuni na tu tausini kina sirinu kanumu. Nane tu tausini kina olandopa pupu lsindumu i ambolkoro kanou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yunge nokolimuni yundu nimbendo: “Kendemande ye peangamo, paa papu terinu. Kongono wallo kolte mele sirindumu nuni teko kondorunumunge nanga mele awisili “Nu nokondou.” nimbo kene nu ongo na pea tapu topo konopu sipu molambili ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kanu kinie wane tausini kina lsimu yemo kepe ombalie nimbendo: “Awilimu, nane pilipulie, ‘Nu bisinete tondolo munduku teko ‘Kou mone lipu nosimbomonga yemboma mindili nongi liemo mandala.’ ningu ⸤kendemande yemboma ‘Kongono mindili siku teangi.’ ningu siku, eno mele koltalo siku melema pali nunu mindi lino yemo;⸥ ponie yembomane panjindilimele kinie nu nunu langi melema we akuku liku; rasi-witimunge kilu kinie mongoselo yembo wemane kilu toko apurundulimele kinie nu nunu rasi-witi mongo we lino mele.’ na pilierindu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","⸤Aku siku telenomonga⸥ nane nu pipili kolopolie na pupu nunge kou na sirinumu mana lowa terindu. Kanu koumu i ambolkoro kanoyo. Inunge koumu nunu sikiru li.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aku nirimu kinie pilipelie nokoli yemone yundu topondopa nimbendo: “Teko kenjeli kendemande ye kerimu, nuni pilkulie, ‘Ponie yembomane panjindilimele akune na nanu langi melema we akupu lipu; rasi-witimunge kilu kinie mongoselo yembo lupemane apurundulimele kinie na nanu rasi-witi we lio.’ ningu pilierinu lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aku siku pilkulie nanga kou monemo kou-benge ulkena nosilinanje papu. Aku telenanje na ombo nanga koumu wendo lipulie kou wallo-kolte ola panjiku silimela lilkela.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","⸤Kanu kendemande yemondo aku sipe nimbe pora sipelie yuni we kendemande yemando nimbendo:⸥ “I yemo tepa kenjerimu kene yunge koumu wendo likulie tene tausini kina ambolkomo yemo siee.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Melema nosilimo yembomo nane mare pea simbo, yu paa awisili nosimbe. Nalo melema naa nosilimo yembomo yu nosilimoma kepe wendo limbo kene aku siku tekolie, ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","kendemande ye kerimu sumbulu toline liku paka toko pena mundeyo. Akune yemboma paa mindili nongolie kola teko pereko molonge.” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","⸤Aku nimbelie yu pe kelepa omba temba mele nimbelie nimbendo:⸥ “Manie Omba Mana Ye A Lierimu Yemo yunge tondolo pa telimu kinie ombalie nimbemone, yunge mulu koleana angelloma kinie pali onge kinie tondolo pa teline suku ye nomi kingi polomo lembana yu molomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yunge kumbikerena ma koleana yemboma pali liku maku tondonge. Kanu kinie kongi tapu teli ye tene yunge kongime apurupelie kongi sipisipime lupe lipe mundupe, kongi memema lupe lipe mundulimo mele aku sipe Ye Nomi Kingimuni yembo maku toko molongema apurupelie nimbemone, ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","yembo kongi sipisipi mele molongema yunge ki-umbukundu lipe mundupe, kongi memema mele molongema yunge ki-tarokondo lipe mundumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Aku tepalie, yuni yunge ki-umbukundu molonge yembomando nimbendo: “Na engelene kolorundu kinie enone na langi siringi. Na no waka kolorundu kinie enone no kolko siringi. Na aulke ponenge orundu kinie enone na “Pea molamili ou.” niringi. Na pulue wambale naa panjipu we-we andorundu kinie mulumbale te siringi. Na kuru torumu kinie nokoringi. Na ka ulkena perindu kinie ongo kanoringi. Tatane ‘Eno molko kondangi.’ nirimu-ne konopu peanga pepili molemele yemboma, enone ulu akume na-kinie teringi kene, ya ongo, ou mulu maselo naa liepili Tatane yu nokomba koleana eno pea ‘Tapu topo molomolo.’ nimbe, nimbe panjerimu koleana sukundu waa.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aku sipe nimbé kinie pilkulie sumbi nili yembomane topondoko yundu ningendo: “Awilimu, tewale nu engelene kolorunu kinie kanopolie nu langi sirimuluye? Tewale nu no waka kolorunu kinie kanopolie nu no kolopo sirimuluye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nu ye ponengemo tena molorunu kinie kanopolie “Ulke sukundu molamili ou.” nirimuluye? Mulumbale naa pakoko we-we andorunu kinie kepe nu tena kanopolie mulumbale sirimuluye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nu kuru torumukinie kepe, ka ulkena perinu kinie kepe, tewale ombo kanorumuluye?” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","⸤Aku siku ninge kinie⸥ Ye Nomi Kingimuni enondo topondopa nimbendo: “Nane enondo paa sike nimbu sikirumu: Inikiru mele inanga angenupili imbi naa mololi te kepe liku tapondoringi akumu na liku tapondoringi.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Kanu kinie yunge ki-tarokondo molonge yembomando nimbendo: “Pulu Yemone ‘Eno molko kenjengi!’ nilimo yemboma, na engelene kolorundu kinie enone na langi te naa siringi. Na no waka kolorundu kinie enone na ‘no nambo.’ ningu kolko naa siringi. Na aulke ponengemo orundu kinie na “Pea molamili ou.” naa niringi. Na mulumbale te naa pakopo we-we andorundu kinie na mulumbale te naa siringi. Na kuru torumu kinie na naa nokoringi. Na ka ulkena perindu kinie na naa ongo kanoringi. ⸤Enone na aku siku naa liku tapondoringi⸥ kene eno nanga kumbikerena naa ongo anjo puku, depelemo kinie yunge angelloma kinie enonga tepe we nomba pepa mindi pulimo pumbe tepe kalondorundu akune anjo paa.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aku sipe nimbé kinie pilkulie kanu yembomane kepe topondoko ningendo: “Awilimu, nu engelene kolorunu kinie kepe, no waka kolorunu kinie kepe, nu ponenge leko orunu kinie kepe, we-we andorunu kinie kepe, kuru torumu kinie kepe, ka ulkena perinu kinie kepe, olione nu aku siku molorunu kinie tewale kanopolie nu naa lipu tapondorumuluye?” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","⸤Aku siku ninge kinie⸥ yuni enondo topondopa nimbendo: “Nane enondo paa sike nimbu sikirumu: Enone inanga angenupili yembomanga imbi naa mololi te naa liku tapondoringi aku kinie na naa laliku tapondoringi.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kanu kinie kanu ⸤teko kenjilimele⸥ yemboma puku kamu-kumu molko kenjiku mindi puli koleana punge, nalo sumbi nili yemboma puku kamu-kumu molko kondoko mindi puli koleana punge.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesusini ⸤yu pe yando ombá mele⸥ ungu akume nimbe pora sipelie yunge lombili andolimendo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Eno pilkimili, wale talo we omba pumbe kinie Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu Mele Pilimolo Walemo wendo ombá. Aku walemo wendo ombá kinie Manie Omba Mana Ye A Lierimu Yemo “Kolopili unjo perana ola uku tangi.” ningu liku anjo singe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesusini aku sipe nirimu walemonga Pulu Yemo popo tondoringi ye awilime kinie, Juda yemboma nokoringi tapu yema kinie, eno Pulu Yemo popo tondoringi ye awili olandopa ‘Kayapasi’ nili ye akumunge ulkena puku liku maku tokolie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesusi kiyengo ningu ka siku tongendo langi ningu moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ningu molkolie ningendo: “⸤Nondopo tamili,⸥ nalo Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu Mele Pilimolo Walemanga ⸤‘ulume tepo molamili.’ ningu⸥ yembo awisili ya Jerusalleme ongo maku toko molongemonga yu isili-ou tomolo kinie enone olio kinie mumindili kolko opa tenge kene isili-ou naa topo, keleamili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kolea kanga Betani ye te ou kuru laká nombalie kelierimu ye te, imbi leko “Ye Kuru Laká Noli Saimono” niringi kanumunge ulkena Yesusi molopili ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ambo te kopongo wele ma-mingi paa peanga te yu molorumune meli orumu. Kanu wele paa mune tolimunge kou mone paa awili tepa purumu. Akumu memba ombalie Yesusi langi noli polo molorumune meli omba ⸤‘Yu tepo kondambo.’ nimbe⸥ pengena ondo lenderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yuni aku terimu kinie kanokolie Yesusi lombili andolime konopu keri panjikulie ningendo: “Aku kopongo welemo nambemune we teko kenjikinuye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aku welemo kou mone limelanje kou awisili lipulie yembo koropama moke tepo silimela.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","⸤Enone ambomondo⸥ aku siku ⸤niringi⸥ pilipelie Yesusini enondo nimbendo: “I ambomo-kinie nambemune ungu awisili nikimiliye? Yuni na-kinie ulu peanga te temu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yembo koropama eno-kinie alieli molonge nalo na eno-kinie alieli naa molombo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na ono tengemonga yuni iwele mune tolimu nanga kangine ondo lendemu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nane enondo paa sike nimbu sikirumu: Ma koleamanga pali i⸤nanga⸥ temane peangamo andoko toko singe kinie i ambomone kinié temu temanemo kepe ‘Yembomane pilkulie ‘Yuni tepa kondorumu.’ ningu piliengi!’ ningulie aku temanemo toko singela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kanu walemonga Yesusi yu lombili andoli ye rurepo akumenga ye te, yunge imbimu Judasi Isikeriote, Pulu Yemo popo tondoringi ye awilime moloringine pupe, ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","eno walsipe pilipelie nimbendo: “Nane eno Yesusi ambolko ka singe aulke te lipu ora sindu liemo enone na ⸤kou⸥ nambeko singeye?” nirimu. ⸤Aku nirimu kinie pilkulie⸥ enone kou-sillipa mongo wane-paono-tene kambu toko yu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kanu kinie yu kelepa yando ombalie Yesusi lipe eno simbe aulke te koropa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Koromonga pulu-pulu walemo wendo orumu kinie ⸤Juda yembomane Pulu Yemone ou enonga anda-kolepalime Naa Topa We Omba Purumu mele pilingendo kongi sipisipi walo te toko nonge mele pilkulie niringimuni,⸥ Yesusi lombili andoli yema yu molorumune ongo walsiku pilkulie ningendo: “Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu mele pilimolondo kongi sipisipi walo te kinié nonimu kolea tena pupu tepo mimi te-pamili konopu lekenoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","⸤Aku siku ningu walseringi kinie⸥ Yesusini ⸤ye te molomba mele eno lipe ora sipelie⸥ nimbendo: “Ne kolea awili ⸤Jerusalleme⸥ suku pukulie, ne ye akumu molombana puku yundu i siku niengi: “Ungu Mane Silimuni isipe nimu: “Na-kinie ulu te wendo ombá walemo nondopa wendo ombá tekemo. Nunge ulkena sukundu na kinie na lombili andolime kinie olio Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu mele pilimolo kongi sipisipi walomo nomolo.” nimu.” niengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kanu kinie lombili andolime puku Yesusini nirimu mele te-pukulie niringimuni, Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilinge kongi sipisipi walo nongemo teko mimi teko noseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kanu kinie, ipupene ena pupe kala torumu kinie Yesusi kinie lombili andoli ye rurepo kinie ⸤ongo⸥ langi noli polona moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Langi nongo moloringi kinie Yesusini nimbendo: “Nane enondo paa sike nimbu sikirumu: Enonga ye tene na lipe nanga opa puluema simbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","⸤Aku nirimu kinie pilkulie⸥ enonga konopune umbune awili tepa terimu pilkulie yu mele mele walsikulie ningendo: “Awilimu, nando nikinuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesusini topondopa nimbendo: “⸤Eno nanga ye rureponga⸥ ye te na kinie langime polo awi-suku-singine ola lemo te walsikele lipu nombolo yemone na lipe, opa puluema anjo simbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kinié Manie Omba Mana Ye A Lierimu Yemo-kinie tenge mele koronga-ou ningu panjeringi temanemo ⸤Pulu Yemonga⸥ bokune molemo mele sike opa puluemane tenge, nalo yu lipe opa puluema simbe yemo mindili nomba paa molopa kenjimbe. Yu molopa kenjimbemonga ye akumu anumuni naa melkanje papu. Yu mindili naa nolka.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yesusini aku sipe nirimu pilipelie Judasi, yu lipe anjo simbe terimu yemo, yuni yundu nimbendo: “Rapai, nikinu yemo na molonje?” nimbe walserimu kinie Yesusini yundu “Sike, nu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eno langi nongo moloringi kinie Yesusini berete te lipe Pulu Yemo kinie “Ange.” nimbe ambolopa pike lepa yu lombili andolime sipelie nimbendo: “I mu nanga kalumu eno liku nangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pe no waene kapo te lipelie Pulu Yemo kinie “Ange.” nimbe eno sipelie nimbendo: “⸤Ino-waenemo⸥ eno pali liku nangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I⸤no-waene⸥ sikirumu nanga mememo. Pulu Yemone ⸤yu kinie yunge yemboma kinie molonge mele⸥ ungu te nimbe panjipe mi lierimu kanu ungumu ‘Kamu wendo omba pepili.’ nimbu ‘Yembo awisilinge ulu pulu kerime kamu manie pupili. Pulu Yemone altopa naa kanopa siye kolopili.’ nimbu nanga mememo ondo lendepolie ⸤kolombo⸥ aku mememo imu. Akumu eno pali liku nangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nane enondo isipu nimbu sikirumu: Isili-ou na no-waene altopo paa naa nombó. Pe mindi, Pulu Yemo ye nomi kingimu molopa nokolemo koleana eno-kinie no waene kondemo kelepo nombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","⸤Langi nongo pora sikulie⸥ eno Pulu Yemonga konana te ningulie, pena puku ma pangi Unjo Ollipi Poniena ola puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kanu kinie Yesusini yu lombili andolimendo nimbendo: “Paa kinié ipulueli ⸤opa puluemane⸥ na-kinie tenge ulumu kanokolie enone pali na munduku siye kolonge. ⸤Aku siku tenge mele⸥ Pulu Yemone ou nirimu yunge bokune molemo kanumu. Pulu Yemone ⸤ungu iko te topalie⸥ nimbendo: “‘‘Kongi sipisipi tapu yemo tangi.” nimbo, yu tonge kinie sipisipime bulu-balu ninge.” nirimu, ⸤aku mele kinié wendo ombá⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","⸤Isili-ou na toko kondonge kinie eno sike bulu-balu ninge⸥ nalo na lomboropo ola molopolie nimbomone, na kumbi lepo kolea Gallillindu pumbo, ⸤eno pe akilku akune onge kinie altopo pea molomolo⸥..” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","⸤Yesusini aku sipe nirimu kinie pilipelie⸥ Pitane nimbendo: “Nu-kinie ulu te wendo ombámonga kanokolie enone pali ‘Nu sike.’ ningu tondolo munduku pilimele mele manie pumbe kinie nu aku sipe munduku siye kolongi liemo nane nu paa mundupu siye naa kolombo, paamolo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesusini topondopa nimbendo: “Nane nu paa sike nimbu sikirumu: Paa kinié ipulueli, kera gulta ou ko naa topili nuni ⸤pipili kolkolie⸥ wale yepoko nando kolo toko “Yu naweye? Na naa kanolio.” nini.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nalo Pitane yundu nimbendo: “Na nu-kinie tapu tolembolomonga olto pea “Tomolo.” ningi liemo kepe nu “Naa kanolio.” paa naa nimbo.” nirimu. Lombili andoli ye wemane pali “‘‘Nu naa kanolemolo.” paa naa nimolo.” niringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kanu kinie Yesusi kinie yu lombili andoli yema kinie kolea ‘Gesemani’ niline puringi. ⸤Akune puringi⸥ kinie yuni enondo nimbendo: “Na anjo pupu Pulu Yemo kinie ungu ni-pukuru kene eno ya molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aku nimbelie Pita kinie Seperi malo ⸤Jemisi kinie Jonoselo⸥ pea lipe memba pupelie ⸤‘Na teko kenjinge ulumu paa nondopa wendo ombá tekemo.’ nimbe pilipelie⸥ yu yuyu kondo kolopa konopu keri panjipe kamelena mindili tepili molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yuni enondo nimbendo: “Nanga konopune umbune paa awili te tepamo kene na kolkoro none tekemo. Eno uru naa peko na-kinie pea tapu topo nokopo kondopo molamili, eno ya we mimi siku kanoko molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","⸤Aku nimbelie⸥ yu yuyu laye kolte anjo pupe koporongo langopa tamalu pepalie Pulu Yemo kinie ungu nimbe mawa tepalie nimbendo: “Nanga Tata, na nondopo ⸤mindili noli⸥ no mingine no nombómo ‘Naa nambo.’ nini aulke te lemo liemo paa papu nalo ‘Nane tepolie nanu konopu simbo.’ konopu lekero mele naa teambo. Nuni kanoko peanga kanoni ulumu mindi teambo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aku nimbelie kelepa yunge lombili andoli ye yepoko moloringine yando omba eno uru peringi kanopalie Pitando nimbendo: “Eno uru naa peko na-kinie ena laye-kolte manda we kanoko kondoko naa molemelaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","‘⸤Kurumenga nomi Setenene⸥ olio kondi tomba kinie tepo kenjimolo kene.’ ningulie ⸤uru naa peko⸥ Pulu Yemo kinie ungu ningu kanoko kondoko molayo. Sike ‘tepo kondamili.’ nimbu konopumene pilimolo nalo temolondo kangimu siye tepa tondolo naa pulimo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aku sipe nimbelie yu altopa anjo pupe ou Pulu Yemo kinie ungu nimbe mawa terimu mele altopa nimbendo: “Nanga Tata, na ‘⸤Mindili noli⸥ no mingine nomo nani.’ nirinu nomo naa nombó kinie we pemba liemo nuni ‘Wendo opili.’ konopu leno mele na-kinie wendo opili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Altopa yando orumu kinie eno uru orumu kulu altoko uru peringi kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","yu altopa wale yepoko sipe anjo pupe Pulu Yemo kinie ungu ou nimbe mawa terimu mele altopala nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kelepa yando ombalie lombili andolimendo nimbendo: “Nambemune we uru peko mulu pilku molemeleye? Kaname! Yemone Manie Omba Mana Ye A Lierimu Yemo ⸤tonge⸥ ulu pulu keri telemele yema lipe simbe enamo wendo ombá tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ola angilku pamili wame! Na lipe anjo simbe yemo okomo kanaa!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesusini ⸤kolea Gesemani yu lombili andolimendo⸥ aku nimbe molopili yu lombili andoli rurepo akumenga ye Judasi orumu. Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga tapu yema kinie, kanu yemane liku mundoringi ye awisili, yembo toli lou-pulsema kinie kopema kinie mengo, Judasi kinie oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ou Yesusi molorumune naa wangi Yesusi Juda ye awilime lipe simbe nimbe panjerimu ye ⸤Judasini⸥ eno Yesusi yu ipulueli manda kanonge mele nimbe sipelie nimbendo: “Nane ye te kanopolie kangulumbo akumu Yesusi. Yu ambolko ka siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","⸤Aku yema⸥ oringi kinie ⸤Judasi⸥ yu Yesusi molorumune sumbi sipe ombalie “Rapai, nu akune angilienu lemo.” nimbe omba yu kangulorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aku terimu kinie Yesusini yundu nimbendo: “Ano, nuni teni okono mele sumbi siku tei.” nirimu. ⸤Judasini Yesusi kinie terimu mele⸥ kanokolie oringi yemane yu liku ka siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aku teringi kinie kanopalie Yesusi pea tapu toko angilieringi ye tene yunge lou pokete-napimu kulu topa wendo lipe Pulu Yemo popo tondoringi ye awili olandopamonga kendemande ye te topa yunge komu te topa laká lenderimu, aku komumu wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","⸤Yuni aku terimu kinie kanopalie⸥ Yesusini yundu nimbendo: “Nunge lou pokete-napimu altoko lakilí! Lou napi liku yembo tonge yemboma lou napini toko kondongela, aku kene ⸤‘Molo.’ nimbu lou napimene ulu te naa teamili⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nane nanga Tata walsipulie “Liku tapondou.” nilkenje yuni angello ami talape rurepo, molo olandopa malapunge telu molo talo, tamburumbu na “Liku tapondangi paa.” nimbe lipe mundulke akumu nu naa pilkinuye? ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nalo ⸤angellomane ongo opa puluemane na ‘naa tangi.’ ningu liku tapondolemelanje⸥ Pulu Yemonga bokune na-kinie wendo ombá nimbe molemo mele nambepa wendo olkaye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","⸤Aku nimbelie⸥ Yesusini ⸤yu ka singe oringi⸥ ye awisili ongo moloringimendo nimbendo: “Na ‘yembo topa wa noli yere molemo.’ konopu lekolie na ka singendo yembo toli lou pulsema kinie kopema kinie mengo okomeleye? Ulke tembele ⸤kerepulune we yemboma maku toko molemele⸥ koleana alieli eno pea molemolo kinie ungu mane sipu molio kinie na liku ka naa silimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nalo isipe wendo okomo ulumenga pali Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi ye marene ulu mare ⸤na-kinie⸥ pe wendo ombá mele ou ningu bokune toringi molemo mele kamu wendo okomo.” nirimu. Kanu kinie yu lombili andolime pali ⸤‘Olio pea ka singenje.’ ningu pilkulie⸥ yu munduku siye kolko eno talopa leko puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kanu kinie Yesusi ka sikulie Pulu Yemo popo tondoringi ye awili olandopa Kayapasi molorumune mengo puringi. Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Juda yembomanga tapu yema kinie, enone ⸤‘Yesusi kote tendepo piliemili.’ ningu⸥ akune ou ongo maku toko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nalo ⸤Yesusi mengo puringi kinie⸥ Pita lombili akilipe taka lipe pupe, Pulu Yemo popo tondoringi ye awili olandopamonga ulkena, ulke angilipe pala mele makapu terimu, awi suku singine yembo maku toringi kolea we lierimune paa sukundu pupe, ‘Yesusi nambe-engenje piliembo.’ nimbe ⸤Yesusi nokoko moloringi⸥ ele yema kinie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga kanjollo yema pali kinie, akumene Yesusi yu toko kondongendo ulu te tepa kenjerimu ulu te ‘Yembo tene ‘yu isipe isipe tepa kenjerimu.’ nimbe kolo topa nipili.’ ningu yembo te koroko moloringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","yembo awisili ongo ungu mare kolo toko niringi nalo enone yu manda toko kondonge ungu te naa niringi. Laye pe mele yembo talo ongolo ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","⸤kolo toko⸥ ningelendo: “I yemo isipe nirimu ⸤pilierimbulu⸥.: “I Pulu Yemo ⸤popo toko kaloli⸥ ulke tembelemo nane topo tekisipulie wale yepoko omba pupili ulke tembele ⸤konde⸥ te manda kolo wangopo takombo.” nirimu. ⸤Yuni aku nirimumunge ‘Yu Pulu Yemo mele molio.’ konopu lepalie aku nirimumu nimbe kenjerimunje⸥..” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aku niringili pilipelie Pulu Yemo popo tondoringi ye awili olandopamo ola angilipe Yesusi walsipelie nimbendo: “Ungu te topondoko naa nikinuye? Nu ⸤ningu kenjerinu mele⸥ nikimbilimu nambolka ulumu ningu kenjerinumundu nikimbiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nalo Yesusi ungu te topondopa naa nimbe we angilierimu. Pulu Yemo popo tondoringi ye awili olandopamone yundu altopa nimbendo: “⸤Nu moleno mele paa sike ningu sieni.⸥ Konde Molopa Mindi Puli Pulu Yemo pilipe molopili “Paa sike nikiru.” ningu mi lekolie, Pulu Yemo yunge Malo, yuni olio “Nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu ye nomi Kirasimu sike nu molo moloye? Olio paa ningu si!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesusini nimbendo: “Akumu na.” ⸤nirimu⸥. “Ungu te pea enondo pali nikirula. Pe walse Manie Omba Mana Ye A Lierimu Yemo, Ye Tondolo Olandopa Pulimu ⸤kinie melema nokombando⸥ yunge ki-umbukundu molopa, kupemanga ola molopa manie ombá eno kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aku sipe nirimumunge ⸤‘Yu Pulu Yemo mele molio.’ nimbe nirimu kulu⸥ pilipelie Pulu Yemo popo tondoringi ye awili olandopamone ⸤paa pilipe keri pilipe⸥ yunge wale-pakolimu yuyu ambolopa sungu sipelie nimbendo: “Kinié yu yuyu paa sike Pulu Yemo ungu taka tondokomo kene pilipulie mongo lsimu mele nimbe simbe yembo te pea nambemune koromoloye? Yu yuyu paa sike Pulu Yemo ungu taka tondokomo pilkimulu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nambolka konopu lekemeleye? ⸤Yu-kinie nambe-eamiliye?⸥” nirimu kinie enone ningendo: “Yu Pulu Yemo ungu taka tondomumunge topo kondomulu liemo papu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kanu kinie enone yunge kumbikerena olkambe toko munduku, ki lumuni toringi. Marene yu larauwe tokolie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nu ‘Pulu Yemone olio nokopa kondomba ye te “Lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu molio.’ nilino kene nawene nu tokomonje ningu si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kanu kinie Pita yu pena mele, yemboma liku maku toringi koleana molorumu kinie kongono tendeli kendemande ambo te Pita molorumune omba yundu nimbendo: “Nu kepe Gallilli disiriki ye Yesusi kinie pea tapu toko moloringi kanumenga ye te lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nalo akune moloringi yemboma pali kanoko molangi Pitane kolo topalie “Molo.” nimbe “Nu nikinu mele na naa pilkiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aku nimbelie Pita yu ulke kerepulune pupe molopili kongono tendeli kendemande ambo tene yu kanopalie akune moloringi yembomando nimbendo: “I yemo yu Nasarete ye Yesusi kinie pea tapu toko molongi ye te lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitane altopa “Molo. Nuni nikinu yemo na naa kanolio.” nimbelie Pulu Yemonga imbi lepa mi lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Laye-kolte pe mele, Pita angilierimune nondoko angilieringi yemane ⸤yu ungu laye lupe mele nirimu mele pilkulie⸥ yu angilierimune ongolie yundu ningendo: “Kolea Gallilli disiriki yembomane ungu nilimele mele nu aku siku ungu nikinu pilkimulu. ⸤Yesusi kinie yu lombili andoli yema kinie kolea Gallilli disiriki yemala,⸥ nu kepe Gallilli ye te, aku kene ‘Nu paa sike yu lombili andoli ye te lemo.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aku niringi kinie Pitane Pulu Yemonga imbi lepa tondolo mundupe mi lepalie nimbendo: “Paa sike nikiru. Eno nikimili yemo paa naa kanolio. Kolo tokoro liemo Pulu Yemone na topa kondopili.” nirimu. Aku nirimu kinie tamburumbu kera gulta ko torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aku terimu kinie pilipelie Yesusini yundu “Kera gulta ou ko naa topili nuni wale yepoko kolo tokolie “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilierimu. Pilipelie ⸤‘Ama, paa tepo kenjendu lepamo. ‘Paa naa tembo.’ konopu lierindu mele sike tendu.’ nimbe pilipelie⸥ pena pupe kola paa awili tepa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ipulueli-ou kolea kokele tangorumu kinie Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga tapu yema kinie enone pali ⸤Yesusinge kotemo pilku pora sikulie⸥ ‘Yu topo kondamili.’ ningu, ningu panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aku ningu panjikulie yu liku, ka toko, mengo puku, ⸤Romo⸥ gapomano ye nomi Paillate molorumune mengo puku kote tenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kanu kinie Judasi, yu Yesusi lipe yunge opa puluema sirimu ye kanumu, Yesusinge kotemo pilkulie “Kolopili, toko kondangi.” niringi kinie pilipelie yuni Yesusi eno lipe sirimu mele pilipe keri pilipelie kelepa konopu alowa tepa enonga kou sillipa wane paono tene ou yu siringime kelepa memba pupe Pulu Yemo popo tondoringi ye awilime kinie Juda yembomanga tapu yema kinie sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nane ye eno lipu sindu kanu yemo yu ulu te tepa naa kenjeli yemo ‘Toko kondangi.’ nimbu lipu sindumu paa ulu pulu keri te tendu.” nirimu. Nalo enone topondoko ningendo: “Akumu olionga ungu te molo. ⸤Nu nunu mindi olio liku sinu.⸥ Akumu nunge kongonomo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kanu kinie Judasi yuni kou sillipa kanume meli pupe ⸤Pulu Yemo popo toringi⸥ ulke tembele palana topa anjokondo mundupelie yu eno mundupe siye kolopa anjo purumu. Anjo pupelie ‘Ka nombo kolambo.’ nimbelie ka te lipe meli pupelie ka nomba kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pulu Yemo popo tondoringi ye awilimene kou kanume ⸤manie polona⸥ lierimu kanoko likulie ningendo: “I koume yembo topo kondomolondo simulume kene ulke tembele koume kinie tere lepo nosimolo kinie kapola naa temba. Akumunge ungu mane te pelemo kene naa nosiemili.” ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ungu te ningu panjikulie ningendo: “I kou monemane mingi sosipene mane tepa mimi telemo yemonga mamo topo topo liemili. Yembo ma te naa lepa enonga kolea sulune yembo ya ongo molemelemanga yembo kolongema akune ono teangi.” ningulie aku siku topo toko lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","⸤Kanu kou monemane ye te toko kondonge aulkemo akisinderingi koumene⸥ aku teringimunge kanu mamo imbi leko ‘Yembo Toko Meme Ondoringi Mamo’ niringi mele kinié kepe aku sipu nilimolo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","⸤Juda ye awilimene⸥ aku siku teringimunge Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Jeremayane ulu te pe wendo ombá ou nirimu mele kamu wendo orumu. Yuni nimbendo: “Awilimuni nando “Tei.” nirimu mele eno aku siku tengendo Isirele yembomane “Ye akumu kou sillipa wane paono tenene topo toko liengi.” niringi koume likulie, kanu koumene mingi sosipene mane tepa mimi terimu yemonga mamo topo toko lsingi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Judasi aku sipe tepa molopili Yesusi Romo gapomano ye nomi ⸤Paillate⸥ molorumumunge kumbikerena angilierimu kinie kanu ye nomimuni ⸤yunge kotemo pilipelie⸥ yu walsipe pilipelie nimbendo: “Nu Juda yembomanga ye nomi kingimu molo moloye?” nirimu. Yesusini topondopa nimbendo: “Sike nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pulu Yemo popo tondoringi ye awilime kinie, ⸤Juda yembomanga⸥ tapu yema kinie, enone Yesusi kote tendeko Paillatendo ⸤kolo toko⸥ ungu awisili ningulie ningendo “Yesusi yu tepa kenjilimo.” ningu yu kote tenderingi kinie Yesusi yu ungu te naa nimbe we angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","⸤Yesusini ungu te naa nirimu kanopalie⸥ Paillatene yundu nimbendo: “Nu ulu keri awisili terinu nikimili mele nu naa pilkinuye?” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesusi ⸤yu tepa kenjerimu niringi mele⸥ pundu topa ungu telu kepe naa nimbe ⸤karaye naa tepa we angilierimu kinie kanopalie Romo⸥ gapomano ye nomi kanumuni paa mini-wale mundupe konopu awisili lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","⸤Yesusi kote tendeko molangi,⸥ ye te, yunge imbi Barapasi, yu mongo lsimu mele yemboma pali pilku moloringi kanu yemo yu ka ulkena perimu. ⸤Ponie tenga tenga, Juda yembomane kolea awili Jerusalleme ongo akune suku⸥ Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilingendo langi noringi walema wendo orumu kinie enone ka ulkena perimu ye te imbi leko “Wendo liku mundou.” ningu mawa teringi kinie ⸤Romo⸥ gapomano ye nomimuni kanu yemo wendo lipe yemboma sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","⸤Aku siku te-pou-pou teringi walema kamu wendo omba pepili Yesusi kote tenderingi pilipelie nirimumuni,⸥ Juda yemboma liku maku toko moloringi kinie Paillatene eno walsipelie nimbendo: “Ye nawe ka ulkena wendo lipu eno siembo konopu lekemeleye? Ye Barapasi wendo lipu siembo, molo enone “Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu.” nilimele ye Yesusi wendo lipu siemboye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","⸤We yemboma Juda yembomanga ye awilime munduku siye kolko enonga ungume liku su siku Yesusinge ungumu pilku yu lombili andoringimunge Juda yembomanga ye awilime⸥ Yesusi-kinie konopu keri panjikulie kote tenderingi-ne pilipelie Paillatene aku sipe nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paillate kote pilieli polona ⸤molopa ‘Juda ye awilimene topondoko ungu te ningenje.’ nimbe nokopa⸥ molorumu kinie yunge menuni ungu te yu molorumune nimbe mundupelie nimbendo: “Nuni andi ye sumbi nilimu ulu te naa tei. Kinié yu kumbu tepo kanondumunge nanga konopune umbune awisili wendo omu kene yu ulu te paa naa tei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","⸤Paillatene “Ka ye nawe wendo lipu siemboye?” nirimu kinie pilkulie⸥ Pulu Yemo popo tondoringi ye awilime kinie, ⸤Juda yembomanga⸥ tapu yema kinie, enone we yemboma kondi toko ungu umbu tondokolie “‘‘Yesusi topa kondopili. Barapasi wendo lipe sipili.” niee.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","⸤Aku niringi kinie pilipelie Romo⸥ gapomano ye nomimuni enondo “Yeselonga ‘nawe wendo lipu siembo.’ konopu lekemeleye?” nimbe walserimu kinie enone topondoko ningendo: “Ye Barapasi ⸤wendo liku yando si⸥..” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aku niringi kinie pilipelie Paillatene enondo nimbendo: “Aku liemo, enone “Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu.” nilimele ye Yesusi, nambe-eamboye?” nimbe walserimu kinie enone pali “Yu unjo perana kolopili uku toko panjei!” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aku niringi pilipelie yuni enondo nimbendo: “Aku nambemuneye? Yu mongo nambolka mongore limuye?” nirimu. Nalo enone ⸤altoko⸥ paa tondolo munduku ningendo: “Molo! Yu kolopili, unjo perana uku toko panjei!” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yunge ungumu naa pilku, opa tenge teringi kanopalie Paillatene no mare kolopa lipe, yembo liku maku toko angilieringime kanoko molangi ki kulumiye topalie nimbendo: “I yemo toko kondonge kolomba kinie eno-kinie ungu pemba; nanga ungu te naa pemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","⸤Aku sipe nirimu kinie pilkulie⸥ yembomane topondoko ningendo: “Yu tonge kolombamonga umbune pembamo olio kinie olionga ambolangoma kinie pepili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kanu kinie ye Barapasi ka ulkena wendo lipe eno sirimu. ⸤Aku tepalie⸥ Yesusi lipe ⸤yunge ami yema⸥ sipelie nimbendo: “Yu ka-pulsene tokolie pe ‘Unjo perana kolopili.’ ningu mengo puku unjo perana uku toko panji-pee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kanu kinie ⸤Romo⸥ gapomano ye nomimunge ami yemane Yesusi liku kanu ye nomimu perimu ulke awili akune suku ⸤yemboma liku maku toko moloringi koleana⸥ pukulie, enonga ami talape yema pali “⸤Yesusi ya molemona⸥ sukundu sukundu waa.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kanu kinie yunge mulumbalema kulku wendo lindiku, ‘Yu ye nomi kingi te none tepili.’ ningu mulumbale kondoli peanga te pakondoko, ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","unjo ka koko molorumu te mulkupiye teko ‘Ye nomi kingimunge waniemo.’ ningu pengena mere mundunduku, kingimene unjo kope te we ambolemele mele koló te liku yunge ki umbukundu amondokolie niringimuni, yu angilierimune koporongo langoko ungu taka tondoko imbi we kólo toko liku ola mundundungendo “Juda yembomanga ye nomi kingimu, nu angilinoye?” ningu ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","yunge kumbikerena olkambe toko kandoko, koló kope ambolorumumu liku yunge pengena kope to-pou-pou teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yu aku siku ungu taka tondoko pora sikulie mulumbale kondolimu kulunduku, yunge ou panjerimu mulumbalema altoko panjindikulie “Yu unjo perana kolopili, panji-pemolo.” ningu yu liku meli puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","⸤Romo ami yemane Yesusi Jerusalleme palana⸥ ulsu mengo punge pukulie niringimuni, kolea Sairini ye te, yunge imbi Saimono, ambolko liku ka mele siku Yesusi kolomba unjo peramo “Kolo wangoko mendei.” ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","⸤Pukulie⸥ kolea Golkota puku akune moloringi. (Golkotanga ungu pulumu ‘penge ombele lieli koleamo’.) ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","⸤Yesusi akune mengo pukulie niringimuni, ‘Yemboma mindili naa nangi.’ ningu⸥ no waenena suku marasini kombili teli te munduku noseringi aku no waenemo ‘Yu nopili.’ ningu, siringi nalo aku no waenemo nomba pilipelie “Molo.” nimbe naa norumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kanu kinie ⸤ami yemane⸥ yu unjo perana ola panjikulie unjomo liku ola anjeringi. ⸤Aku tekolie, ou unjona ola uku toko naa panjikulie⸥ yunge mulumbale ⸤kulunduku noseringime⸥ ‘Moke teamili.’ ningu eno yu mele mele linge mele pilingendo kou kate teko pe mulumbalema lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe yu unjo perana ola angiliepili tapu teko kanoko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","‘Yu mongo lsimu mele yemboma kanangi.’ ningu IYE YESUSI JUDA YEMBOMANGA YE NOMI KINGIMU ningu imbi toko yunge pengena olakondo unjona mondoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Opa tekolo melema wa lsingili ye talo pea unjo pera talonga uku toko panjeringila. Te Yesusi yunge ki-umbukundu uku toko, te ki-tarokondo uku toko panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Akune ongo puringi yembomane Yesusi ⸤kanoko keri kanokolie yu⸥ ungu taka tondoko iri mele tokolie ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ningendo: “Aa! “Ulke tembelemo tekisipulie altopo wale yepoko omba pupili takopo limbo.” nirinu yemo, ‘Naa kolambo.’ ningu nu nunu liku tapondou. Nu sike Pulu Yemonga Malo liemo unjo perana manie ou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aku sikula Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, ⸤Juda yembomanga⸥ tapu yema kinie, enone kepe yu ungu taka tondokolie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yu yembo wema ‘Naa kolangi.’ nimbe lipe tapondorumu nalo yu yuyu ‘Naa kolambo.’ nimbe manda naa lipe tapondokomo. Yu ‘Isirele yembomanga ye nomi kingimu ⸤molio.’ nilimo mele sike aku sipe⸥ molemo liemo yu yuyu unjona manie opili. Yu yuyu unjona manie ombá kinie kanopolie ‘Yu sike olionga ye nomi kingimu.’ nimbu tondolo mundupu pilimolo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yuni ‘Pulu Yemone na lipe tapondomba.’ nimbe tondolo mundupe pilipe molemo kanumu; yu “Pulu Yemonga Malo molio.” nilimo kene Pulu Yemone yu kanopa peanga kanopa, ‘Yu manie we olkanje papu.’ konopu liemu liemo kapola, yu omba yu lipe tapondopa ⸤unjona wendo lipili⸥.. ⸤Aku sipe temu liemo ‘Yu sike Pulu Yemonga Malo.’ nimbu tondolo mundupu pilimolo⸥..” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wa noli ye talo yu-kinie unjoselonga uku toko panjeringi yeselone yu aku siku ungu taka tondoringilila. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","⸤Yesusi unjona ola we angiliepili⸥ awi tangoli ena tuwellepo killoko terimu kinie kolea pali sumbulu topalie, pe ipupene ena tere killoko terimu kinie kelierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ipupene ena tere killoko mele terimu kinie Yesusini ru nimbelie nimbendo: “Elloi, Elloi, llama sapakatani.” nirimu. Akumu Juda yembomanga ungu te. Akumunge pulumu isipe: “Nanga Pulu Yemo, nanga Pulu Yemo, na nambemune munduku siye kolonuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Akune nondoko angilieringimenga marene yuni aku nirimu kinie pilku ⸤sundukulie⸥ ningendo: “Pilieme. Yu Illainja walsikimu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aku nirimu kinie pilieringimenga ye te tamburumbu lkisipe pupe ulú-pinje mele te lipe no waene kombili teli mare akune panjipelie, ‘Yesusi no waene kombili teli pinjena pelemomo nopili.’ nimbe memba omba unjo pepena tenga ka topa olando sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","⸤Nalo yu no waenemo sirimu mele kanokolie⸥ we yembomane ningendo: “Molo. Kinié unjona we angiliepili. Illainjane sike yu ‘Naa kolopili.’ nimbe lipe tapondopa manie limbendo okomonje, kanopo kanamili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesusini ungu te tondolo ru nimbelie, pe yunge minimundu ‘Pu.’ nimbe yu kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yu aku sipe kolorumu kinie ⸤ulu awili mare⸥ walsikele ⸤wendo orumu.⸥ Pulu Yemo popo toko kaloringi ulke tembele ⸤Jerusalleme suku angilierimu akune sukundu Pulu Yemo molorumu⸥ suluminia paa kake telimunge kerepulune ⸤‘Yemboma sukundu naa pangi.’ ningu ou alieli⸥ mulumbale awili tene pipi siku panjeringi angilierimu. ⸤Yesusi kolopa pora sirimu kinie⸥ kanu mulumbalemo awi-suku-singine olakondo maniendo sipe olá torumu. ⸤Aku tepa,⸥ ma jimi-jimi te tepa, kou awilime topa ungu-mengu topa, ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","yembo ou ono teringi koleama anjo yando pupe, Pulu Yemonga yembo kake teli ou koloringime ⸤Pulu Yemone⸥ topa makinjinderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lomboroko ola molko ono kolea peringine wendo ongolie, Yesusi pe lomboropa ola molorumu kinie Pulu Yemonga kolea awili kake teline suku pukulie yembo awisili ‘Kanangi.’ ningu puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","⸤Romo⸥ ami ye wane anderete nokorumu yemo kinie, yu pea Yesusi terimu mele tapu teko kanoko moloringi ami yema kinie, enone ma jimi-jimi tepa ulu lupe lupema wendo orumu kinie kanokolie eno paa mini-wale mundukulie ningendo: “I yemo yu paa sike Pulu Yemonga Malo lepamo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ambo awisili mele, ⸤Yesusi unjo perana kolorumu⸥ akune sulu teko kanoko angilieringi. Ou kanu amboma ⸤enonga pulu⸥ kolea Gallilli disiriki munduku siye kolko Yesusi lombili andoko liku tapondoko nokoko ⸤Jerusalleme pea⸥ oringi amboma. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Enonga ambo te Makatalla taono ambo Maria, te Jemisi kinie Josese kinie elonga anumu Maria, te ye Seperinge maloselonga anumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ipupene, kolea kala tomba terimu kinie Arimatia taono ye kamako te, yunge imbi Josepo, yu kepe Yesusi lombili andorumu ye te, yu omba ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","⸤Romo gapomano ye nomi⸥ Paillate molorumune pupe, “Yesusinge onomo na si.” nimbe mawa terimu kinie Paillatene yu “Onomo lipili.” nimbe ⸤ami yemando nimbe mundorumu⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","⸤Paillatene “Kapola.” nirimu kinie⸥ Josepo pupe onomo manie lipe, mulu konde tene lipe kulupi torumu. Kulupi topalie ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kou kande konde te, Josepo yu ‘Kolombo kinie akune na ono teangi.’ nimbe kou kande te akupe noserimu kou kandemonga suku memba pupe noserimu. Nosipelie kou kande kerepulune kou awili te perele-marele memba omba pipi sipelie yu kelepa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makatalla taono ambo Maria kinie Maria te kinie elo kou kandemo lierimu kerepulune nondoko ⸤yu onomo kou kandena noserimu mele kanoko⸥ moloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","⸤Kanu kinie,⸥ ‘Opali ⸤koro molomolo wale⸥ Sambatemo.’ ningu pilkulie, kinié mele, melema undu-undu siringi kanu walemo pora nirimu kinie opalikundu Pulu Yemo popo tondoringi ye awilime kinie, Parisi yema kinie, eno ⸤Romo gapomano ye nomi⸥ Paillate molorumune puku liku maku toko angilkulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ningendo: “Ye Awilimu, ye kanumu ou naa kolopa we molopalie yembomane ‘Sike.’ ningu pilinge ungume kolo topa nirimu kanu yemo yu “Kolopolie wale yepoko omba pumbe kinie lomboropo ola molombo.” nirimu olio pilierimulu kene ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","⸤nuni ami yemando⸥ “Kanu yemo ⸤oleanga⸥ ono tengi kou kandemo wale yepoko paa mimi siku nokaa!” nieni. Naa nokonge kinie yunge lombili andoli yemane onomo ongo wa liku mengo pukulie “Yu lomboropa ola molopa omba pumu.” ninge. Aku siku kolo toko ninge kinie yu ou “Sike nikimu.’ niengi.’ nimbe kolo torumu ungumu maniendopa, enone ‘Yembomane ‘Yuni sike aku sipe temu.’ niengi.’ ningu kolo tonge ungumu paa olandopa pemba.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paillatene ⸤Juda ye awilimendo⸥ topondopa nimbendo: “⸤Aku liemo,⸥ ami ye mare liku mengo puku, “Yemo ono tengi koleamo nokoko kondangi.” ningu mondoko, ‘Yembomane ono koleamo ulu te naa teangi.’ ningu ‘Aulkemo tondolo pipi siemili.’ konopu lenge mele teangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","⸤Aku nirimu kinie⸥ pilkulie ami ye mare liku meli puku, yembo ono kou kandemo pipi siringi koumu pala teko pele leko enonga imbimu akune toko mondokolie, “Ami yema akune nokoko molangi.” ningu mondokolie ⸤eno puringi⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","⸤Juda yembomanga koro moloringi⸥ wale Sambatemo pora nimbe, enonga pulu-pulu kongono walemo wendo ombando kolea tangombando muni lierimu kinie Makatalla taono ambo Maria kinie, Maria te kinie, pukulu ⸤Yesusinge⸥ onomo noseringi kou kandena ⸤onomo⸥ kanongele puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Awilimunge mulu koleana angello te manie orumu kinie ma jimi-jimi paa tondolo tepa terimu. Angellomone omba kou kandena pupe kou kande kerepulumu pipi siringi koumu wendo lipe perele-marele memba pupe nosipe akune ola molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kanu angellomonga kumbikeremo kariapá tepa pa telemo mele pa tepa, mulu pakorumume kalopera topa paa kake telemo mele kake terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yesusi ono kolea nokoringi ami yema angellomo kanoko paa mini-wale munduku pungu-pungu ningulie yembo kololimene ungu naa ningu ulu te naa telemele mele eno aku siku uluri naa teko we moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angellomone amboselondo nimbendo: “Pipili naa kolale. Yesusi ‘Kolopili.’ ningu talko unjo perana uku toko panjeringi kanu yemo kanongele okombele na pilkiru. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yu ya naa lemo. ⸤“Kolopolie wale yepoko sipemonga⸥ lomboropo ola molombo.” ou nirimu aku mele temu. Onomo ou lierimu koleamo ongo kanale. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kanokololie popenge teko pukulu yunge lombili andolime i siku ningu siengili: “Yesusi ono koleana lepalie lomboropa ola molopa kolea Gallilli disirikindu kumbi lepa pulimo kene eno akune yu kanonge.” ningu siengili. ⸤Ungu nimbu sindimbondo ondu⸥ kanu ungumu nimbu pora sikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","⸤Angellomo aku sipe omba mona molopalie nirimu mele⸥ kanoko pilkululie amboselo pipili kolkolo kamele paa akokolo, aku sipe konopu talo pepili lkisiku pukulu yunge lombili andolime ningu singele puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","⸤Lkisiku pungele puringili kinie⸥ Yesusi lipe sinjipe elo aulkena kanopa lipelie “Okombeleye?” nirimu. Kanu kinie elone yunge kimbukundu puku kangulkulu yu kapi ningu imbi liku ola mundundoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kanu kinie Yesusini elondo nimbendo: “Pipili naa kolkololie, elo pukulu nanga angenupilindu ningelendo: “Kolea Gallillindu pangi. Yu akune kanonge.” ni-pele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amboselo kelko yando ongele oringili kinie Yesusinge ono kou kandemo nokoringi ami ye mare kolea awili ⸤Jerusalleme⸥ suku puku Pulu Yemo popo tondoringi ye awilimendo ulume wendo orumu mele pali ningu si-poringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","⸤Pilieringi kinie⸥ popo tondoringi ye awilime, Juda yembomanga ye awilime kinie pea maku tokolie eno kinie ⸤ungu ningulie ningendo: “We yemboma iulume wendo omu mele pilkulie “Yesusi lomboropa ola molomunje.” ninge kene ‘Naa piliengi!’ nimbu nambe-eamolonje?” ningu⸥ kerepale ningulie tenge mele ningu panjikulie niringimuni, ami yema kou mone awisili sikulie ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","enondo ningendo: “Yembomane “Yesusi nambe-emuye?” ningu walsinge kinie enone i siku niengi: “I pulueli uru pemulu kinie yunge lombili andolimene kiyengo ningu ongo yu liku meli pungi.” niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“⸤Olio Juda yemboma nokolemo Romo⸥ gapomano ye nomimuni ⸤aku tengi mele⸥ ungu te piliemu liemo ‘Eno mongo naa liengi!’ nimbu olione enonga lipu tapondopo yu-kinie ungu nimolo, kanu kinie ‘Enone ono koleamo mimi siku naa nokoko we uru pengi.’ konopu lembamonga mongo naa linge.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aku niringimunge pilkulie ami yemane kou mone liku enone “Niee.” niringi mele yembomando niringi. Akumunge yandopa kinié i⸤boku tokoro⸥ walemo kepe Juda yembomanga koleamanga pali iungumu anjo anjo pulimo pilkulie yembo awisilini kanu temanemo toko molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","⸤Amboma pukulie kanoko pilieringi mele temane toko siringi⸥ kinie pilkulie Yesusi lombili andoli ye rureponga yepoko kolea Gallilli disiriki puku, Yesusini ma pangi te imbi lepa ou “Akune wangi.” nirimu ma pangine puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akune puku Yesusi kanokolie niringimuni, yu kapi ningu yunge imbi liku ola mundundoringi nalo marene ‘Yesusi kolorumu. Imu Yesusi molo nawenje?’ ningu konopu talo teko lieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kanu kinie Yesusi yu nondopa omba enondo nimbendo: “Tatane nando “Nu nunu mulu koleana melema kinie yemboma kinie, ma koleana melema kinie yemboma kinie nokani.” nimbe tondolomo na sirimu, na-kinie pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aku ⸤tondolo na sirimumu eno simbo eno kinie pemba⸥ kene eno ma koleamanga pali puku ‘Yemboma pali nanga ungumu pilku liku, nanga lombili andolime molangi.’ ningu, puku ningu si-pukulie ningemone, ⸤pilku liku molonge⸥ yemboma no lindingendo Lapa kinie Malo kinie Mini Kake Telimu kinie enonga imbi leko eno no lindiku, ");
INSERT INTO ubu_kala_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","enondo “Na lombili andolimene teangi.” nirindu mele pali ‘Aku yemboma teangi.’ ningu eno mane siengi. Aku siku niliku andoko molonge kinie na eno-kinie alieli molambo mulu maselo pora nimbé.” nirimu. ⸤Aku pea.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesusi, Pulu Yemone mako topa “Olio nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu, Pulu Yemonga Malo, yunge temane peangamo pulu polorumu mele ⸤ya inie tombo tokoro⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","⸤Yesusi, Pulu Yemone mako torumu ye nomi Kirasimunge temane peanga imu wendo ombándo ye te ou omba temba mele⸥ Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane Pulu Yemonga ungu te nimbe boku torumu akune molemo mele isipe: ‘⸤Pulu Yemone nimbendo: “⸤Pílie!⸥ Nane “Nanga ungu umbu tondolime pilipe nimbe sipili.’ nimbu lipu mundumbo yemone nunge aulkemo akisindepili.’ nimbu yu “Kumbi leko pu.” nikiru.” ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Kolea ku lieline ⸤kumbi lepa pumbe⸥ ye tenga kerena ungu te nimbendo: “Awilimu ombá aulkemo teko mimi teame. Yu ombá aulke kangama toko sumbi siee.” nikimu.’ nimbe ⸤Aisayane Jonone paa pe temba mele ou aku sipe nimbe sipe bokune torumu molemo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Akumunge, ⸤temane peangamo pulu polombando No Lindeli⸥ Jono kolea ku lieli tenga wendo omba ⸤aku sipe⸥ ungu mare yemboma nimbe sipe molorumu. Kolea Judia disiriki yemboma pali kinie kolea Judianga kolea awili Jerusalleme yemboma pali kinie eno yu molorumune puku yunge ungumu pilinge puringi. Yuni ungu te enondo nimbe sipelie nimbendo: “Eno ulu pulu keri telemelema kanoko keri kanoko konopu alowa tekolie ‘Pulu Yemone olionga ulu pulu kerime ‘We manie pupili.’ nimbe siye kolopili.’ ningu ‘No liemili.’ ningu waa.” nirimu. Aku sipe nirimu kinie enonga ulu pulu keri teringime ningu para siringi kinie yuni eno no Jodane kolo no linderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jono kongi kemelenga indini teli wale pakoli te pakopa, kongi kilumuni teli kakomo topalie, kuli-kumbe kinie pilimu-no kinie aku langiselo mindi nomba molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Yuni yemboma ungu nimbe sirimu mele isipe: “Nane sike eno no lindilio nalo ye te akilipe ⸤nondopa⸥ ombá ⸤tekemo⸥mo yuni eno ⸤Pulu Yemonga⸥ Mini Kake Telimu lindimbe ⸤linge⸥. Ina akilipe ombá yemo yunge tondolomo paa olandopa, nanga tondolomo paa maniendopa, na yu-kinie manda molo. Yembo awilimenga kongono keri tendeli kendemande yembomane sike enonga awilimenga kongono keri tendengendo manie molko enonga yembo awilimenga kimbu sume ka pilke tondolemele nalo na ye paa kerimu moliomonga kanu ombá yemo yunge kimbu su ka pilke tondoli kanu kongonomo paa olandopa mele, nane tendelkanje kapola naa telka. ⸤Na ye paa kerimu, yu ye paa awilimu.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","⸤Jono yemboma no lindipe molorumu⸥ kanu walemo kinie Yesusi kolea Gallilli disiriki Nasarete taono mundupe siye kolopa ⸤Jono molorumune⸥ orumu kinie Jonone yu no Jodane kolo no linderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","⸤Yesusi no lipe pora sipelie⸥ nona wendo omba angilierimu kinie sumbi sipe mulúmu kengeya lepa anjo yando purumu kanopalie, Pulu Yemonga Minimu, kera waembono mele, manie omba Yesusi molorumune pupe kangine ola molorumu kanorumula. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kanu kinie mulune ola ungu te wendo ombalie nimbendo: “Nu nanga konopu mondolio kangomo. Nu-kinie konopu sipu molio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","⸤Yesusi no lsimu kinie Pulu Yemonga Minimu yu-kinie omba molopalie nirimumuni,⸥ sumbi sipe Minimuni Yesusi kolea ku lieline pulu sipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","⸤Akune purumu kinie,⸥ oli te koro talo Yesusi aku kolea ku lieline takera melema kinie molopili ⸤kurumenga nomi⸥ Setene omba yu kondi torumu. Kanu kinie ⸤mulu koleana⸥ angelloma ongo yu nokoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kanu kinie ⸤No Lindeli⸥ Jono ka siku ka ulkena panjeringi kinie pilipelie Yesusi kelepa kolea Gallilli disiriki omba Pulu Yemonga temane peangamo topa silipe andorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","⸤Topa silipe andopalie⸥ nimbendo: “Kinié enamo kamu wendo okomo, Pulu Yemo ye nomi kingimu molomba enamo nondopa wendo okomo kene ulu pulu kerime munduku siye kolko konopu alowa teko, ‘Temane peangamo yu sike ungumu.’ ningu tondolo munduku piliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","⸤Aku sipe nilipe andopa⸥ nomu Gallilli kélona andopalie Yesusini Saimono kinie Saimono angenu Enderuselo oma lili wale te nomune toko munduku moloringili kanorumu. Oma lsingili akumu elonga kou kongono teringili kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","⸤Aku siku teko moloringili kanopalie⸥ Yesusini elondo nimbendo: “Na lombili wale. Oma lingelendo oma lili wale te liku nona manie mundulimbele kinie omama walena omba pelemo mele, pe ‘nanga kongonomo tengelendo nanga ungumu pilkulu ningu siliku andongele kinie yemboma nanga talapena sukundu ongo molangi.’ nimbu ‘Elo na lombili wale.’ nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","⸤Aku nirimu kinie pilkululie⸥ tamburumbu elonga oma lili walema munduku siye kolkololie Yesusi lombili puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","⸤Kanu kinie⸥ yu laye kolte welto pupelie, Seperinge malo Jemisi kinie Jemisi angenu Jono kinie elonga nona andoli sipine sukundu molkolo oma lili walema toko tambuloringili kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","walsikele elondo “Wale.” nirimu. Kanu kinie lapa Seperi kinie kongono yema kinie sipine sukundu molangi munduku siye kolkololie Yesusi lombili puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","⸤Kanu ye pokore Yesusi lombili puringi kinie⸥ yu kinie eno Kapeniame taono puringi. Kanu kinie ⸤Juda yembomanga⸥ koro moloringi wale Sambatemo wendo orumu kinie Yesusi Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkena suku pupe yemboma mane sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mane sirimu kinie Pulu Yemonga ungu manemanga pulume pilku eno mane siringi yemane we mane siringi mele Yesusini aku sipe mane naa sirimu. Namba lierimu yemane pipili naa kolko tondolo munduku mane siringi mele yuni aku sipe mane sirimu kulu pilkulie yembomane mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kanu kinie ulke kanune suku kuru te ye tenga konopune molopa ya ambolorumu ye te molorumu, ⸤yemonga konopune suku molorumu kanu kurumuni yu “Ungu ni.” nimbe tópeb sirimu-ne⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yuni opa ungu nimbelie nimbendo: “Nasarete taono ye Yesusi, nu pea olio ⸤kurume⸥-kinie telune tapu topo manda naa molomolo. Nu olio-kinie nambemune onuye? Nu olio toko kondoni onuye? Nane nunge imbi pilio. Nu Pulu Yemonga Ye Kake Telimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","⸤Aku sipe nirimu kulu pilipelie⸥ Yesusini kanu kurumu iri topalie yundu nimbendo: “Nu ungu naa ningu yemonga konopune ongo wendo pu.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kurumuni yemo ambolopa tondolo mundupe puru-puru sipelie kalle nilipe omba wendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","⸤Yesusini aku terimu kanokolie⸥ yemboma suru ningu, mini-wale munduku eno enono anjo yando ningendo: “I ulumu nambolka uluri tekemonje? Ungu mane konde te wendo ombámo. Ye namba lieli tene we yembomando “Teaa.” nilimo mele iyemone kurumendo kepe aku sipe nilimo kinie kanu kurume yunge ungumu pilku liku telemele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanu kinie kolea Gallilli disiriki koleamanga pali yuni aku sipe terimu mele temanemo tamburumbu anjo anjo purumu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kanu kinie ⸤Yesusi-kinie, yu lombili andoli yema kinie⸥ eno kanu maku toko Pulu Yemonga ungumu pilieringi ulkemo munduku siye kolko wendo ongolie niringimuni, eno kinie, Jemisi Jonoselo kinie eno puku Saimono kinie Enderuselonga ulkena puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ulkena sukundu puringi kinie Saimononga kolepa ambomo kuru topa kangi nopili lierimumu Yesusi ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aku siku niringi pilipelie ambomo lierimune pupe yunge kimu ambolopalie yu ola lsimu kinie kangi nomba kelierimu kinie ambomone ⸤ola angilipe wendo ombalie⸥ oringi yema langi sipe nokorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pe kolea kalá topa ena purumu kinie, kuru torumu yemboma kinie, konopune kuru molorumu yemboma kinie, Yesusi molorumune mengo oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kanu koleana moloringi yemboma pali Saimononga ulke kerepulune ongo maku toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kanu kinie Yesusini yembo kuru lupe lupe torumu awisili tepa konde lipe, yembomanga konopune moloringi kuru awisili topa makororumula. Kurumene Yesusi ⸤Pulu Yemonga Malo, yu Pulu Yemone mako topa lipe mundorumu ye nomi Kirasimu⸥ molorumu mele pilieringi kulu yuni enondo “Molio mele anjo ningu naa siee.” nimbe enonga kerema pipi sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ipulueli-ou, kolea muni ou naa lepa sumbulu topa pepili Yesusi ola molopa penando pupelie nirimumuni, kolea ku lieli tenga pupe, akune Pulu Yemo-kinie ungu nimbe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimono kinie pea moloringi yema kinie eno yu koroliku lombili pukulie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","yu kanoko lendekolie yundu ningendo: “Yembomane pali nu korokomele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","⸤Aku niringi pilipelie⸥ yuni enondo nimbendo: “Na kolea marenga kepe ungu nimbu siembo kene ikoleamo mundupu siye kolopo kolea tenga pamili. Ne nondopa lemo koleamanga pamili. Na koleamanga pali ungu nimbu simbondo mana manie orundu kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aku nimbelie yu kolea Gallilli disiriki sukundu koleamanga pali andopa Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkemanga sukundu pupe ungu nimbe sipe, yembomanga konopune kuru moloringime topa makororumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Walse ye te kuru laká nomba perimumu Yesusi molorumune omba yunge kumbikerena koporongo langopa yu mawa tepalie nimbendo: “Nunge konopumuni na ‘Konde pambo.’ konopu lienu liemo nuni na manda teko konde lini.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kanu kinie Yesusini yu paa kondo kolopalie yunge kimuni yemo ambolopalie yundu nimbendo: “‘Nu konde pani.’ konopu lekero kene konde pu.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","kuru lakámo tamburumbu nomba kelierimu, yemo konde pupe umbu kalu lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kanu kinie Yesusini yu ungu te tondolo mundupe nimbendo: “Nuni ya ulu tekeromo yembo telurindu kepe paa naa ni! Sumbi siku puku Pulu Yemo popo tondoli yemo nunge kangimu liku ora siku, ‘Na altopo kangi peanga liepili molkoro kene.’ ningu Mosisini “Tei.” nimbe ungu mane sirimumu pilku liku tenindu “Pulu Yemo popo toko kalko sie.” nirimu mélemo liku Pulu Yemo popo tondoli yemondo “Kalondou.” ningu yu sieni. Pe yembomane nu kanokolie ‘Yu sike kangi peanga liepili molemo.’ ningu piliengi kene nikiru mele isili-ou te-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nalo yemo yu anjo pupelie ungu awisili yembo awisilindu anjo anjo nimbe para silipe andopa, Yesusini yu-kinie terimu temanemo topa sirimu. Yemone aku terimu kulu Yesusi ⸤‘Yembo awisili na molombona nondoko nondoko ongo maku naa tangi.’ nimbe⸥ altopa taonomanga sukundu mona manda naa andopalie kolea ku lieline molorumu, nalo kanune yembo awisili kolea lupe lupemanga molko sukundu sukundu ongo yu molorumune maku toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wale mare omba purumu kinie Yesusi Kapeniame taono altopa sukundu purumu. Yu ou perimu ulkena altopa omba molorumu yembomane pilkulie ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","eno awisili ongo ulkena sukundu sukundu ongo liku maku toko moloringi kinie ulke kanune ekelepa terimu kulu yembo mare molonge kolea te naa lierimu kulu pena moloringila. Yuni eno ⸤Pulu Yemonga⸥ ungumu nimbe sipe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","⸤Yuni nirimu mele aku siku maku toko pilku molangi⸥ yembo mare kimbu ki kolopa pora sirimu ye te mengo oringi. Kanu yembomanga ye kisene kanu yemo taropola teko mengo Yesusi molorumune onge oringi nalo ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","yembo awisili ulkena ekelepa teko angilieringi kulu yu molorumune nondoko mengo punge aulke te naa lierimu kulu ulke imune mengo ola pukulie Yesusi molorumune kana-kana ulkemo tekisikulie yemo taropola pali moko toko manie mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","⸤‘Yesusini iyemo manda tepa konde limbe.’ ningu⸥ tondolo munduku pilkulie yu mengo oringi kanopa pilipelie Yesusini kimbu ki kolopa pora sirimu yemondo nimbendo: “Nanga kangomo, nunge konopune ulu pulu keri terinu pelemoma manie pupili, we siye kolkoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","⸤Kanu kinie,⸥ Pulu Yemonga ungu manemanga pulume pilku mane siringi ye mare enono akune molko ⸤Yesusini aku nirimu kinie pilkulie pilku keri pilku⸥ konopu kimbu sikulie, “Nendi yemone ungu aku sipe nambemune nikimuye? Yu Pulu Yemo marake tekemo. Yembomane ulu pulu keri telemelema nawene ‘Manie pupili, siye kolkoro.’ manda nimbeye? Pulu Yemone mindi manda telemo.” ningu enono ningu pilku molko konopu kimbú siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kanu kinie Yesusini eno aku siku konopu kimbú siku moloringi mele yunge konopuni sumbi sipe pilipelie enondo nimbendo: “Enone ⸤nane nikirumunge⸥ aku siku nambemune konopu kimbú sikimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Iyemondo “Nunge ulu pulu kerime manie pupili, we siye kolkoro.” nimbo kinie eno ulu te naa kanokolie ‘We-we tepa nikimu.’ konopu lengeye? Molo “Ola angilku nunge kunungumu liku mengo kimbu kongono teko andou.” nimbo kinie yu ola angilimbene naa angilimbenje mona lemba manda kanokolie ‘Aku sipe mindili sipe nikimunje.’ konopu lengeye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nalo “Manie Omba Mana Ye A Lierimu Yemo tondolo pelemomone ya ma koleana yembomanga ulu pulu kerime “Manie pupili, we siye kolkoro.” manda nimbé.’ ningu piliengi!’ nimbu aku sipu nindu.” nirimu. Aku nimbelie kimbu ki kolopa pora sili yemondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nane ‘Nu ola angilku nunge kunungumu liku mengo ulkendo pu.’ nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aku nirimu kinie yemo ola angilipe tamburumbu kunungumu lipe mepa, eno pali kanoko molangi omba pena purumu. Yuaku terimu kanokolie eno suru ningu mini-wale mundukulie Pulu Yemonga imbi liku ola mundunduku yukapi ningulie ningendo: “Olio iulu wendo okomo kanokomolo mele ou walse kepe ulu te aku sipu paa naa kanorumulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesusi ⸤ulkemo mundupe siye kolopa⸥ pena pupelie altopa nomu Gallilli kélona pupe andopa molorumu. Kanu kinie yu molorumune yembo awisili ongo liku maku toko moloringi kinie yuni eno mane sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kanu kinie yu pumbe pupelie nirimumuni, Allapiasi malo LLipai kou takisi lsingi ulkena ⸤kou takisi lipe⸥ molorumu kanopalie yundu “Nu na-kinie pea pambili lombili ou.” nirimu. Kanu kinie LLipai yu ola angilipe yulombili purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pe Yesusi LLipainge ulkena langi nomba molorumu kinie kou takisi lili yema kinie, ⸤Juda ye awilimene⸥ “ulu pulu keri teli ye” ⸤niringi⸥ wema kinie awisili ongo Yesusi kinie yu lombili andoli yema kinie eno pea manie molko langi noringi. Aku sili yembo awisili alieli yu lombili andoringimunge eno awisili ⸤akune lombili puku⸥ pea langi nongo moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yesusi yu “ulu pulu keri telime” niringi yembo wema kinie kou takisi lili yema kinie pea langi nongo moloringi kanokolie Parisi ye marene, Pulu Yemonga ungu manemanga pulume pilku mane siringi kanu yemane, Yesusi lombili andolimendo ningendo: “Kou takisi lili yema kinie, ulu pulu kerime teli wema kinie, eno-kinie yu nambemune langi pea nokomeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aku siku niringi pilipelie Yesusini enondo nimbendo: “Kuru naa tolemo yemboma doketana naa pulimele. Kuru tolemo yemboma mindi doketana pulimele kanumu. Nane “Yembo sumbi nilime na molombona wangi.” nimbondo ma koleana naa orundu. ‘Ulu pulu keri teli yemboma na molombona wangi.’ nimbondo orundu. Ulu pulu keri teli yemboma lipu tapondombondo orundu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","No Lindeli Jono lombili andoringi yema kinie, Parisi yema lombili andoringime kinie, eno walse-walse langi mi toko naa noringi mele walse aku siku teko moloringila. ⸤Aku teringi kulu⸥ yembo mare Yesusi molorumune ongo yu walsiku pilkulie ningendo: “Jono lombili andolime kinie, Parisi yema lombili andolime kinie, alieli langi mi toko naa nolemele nalo nu lombili andolime aku siku naa telemele akumu nambemune naa telemeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","⸤Aku siku niringi kinie pilipelie⸥ Yesusini topondopa enondo ⸤ungu iko te topa yu-kinie ulu te wendo ombá mele nimbelie⸥ nimbendo: “Ambo limbe ye te yunge pulu lemo yema kinie molemo kinie eno konopu sikulie “Langi mi topo naa namili.” manda ningeye? ⸤Manda naa ninge.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nalo pe, ambo limbe yemo eno molongena ongo wendo linge kinie kanu walemanga sike ⸤konopu keri panjiku⸥ langi naa nongendo mi tonge. ⸤Isili-ou molo.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mulumbale ou te sungu nilimo kinie olione mulumbale paa konde tenga te kopisipu lipu, sungu nilimomonga naa topo tambululimolo kanumu. Yembo tene aku sipe topa tambulkenje kanu mulumbalemo nona panjilke kinie mulumbale konde kopiselimu kanga lepa llinimbelie mulumbale oumu kelepa kamu awili tepa sungu nilke. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kongi-meme kalumuni teli mingi ou tenga no-waene konde naa lakolemolo kanumu. Yembo tene mingi ou tenga no-waene konde te kolkanje kanu no-waenemo mingine sukundu pepalie pe akolka kinie kanu mingi oumu naa akopa sungu nilke. Kanu kinie nomo kepe mingimu kepe kamu keri lelka. Akumunge no-waene konde kongi-meme kalumuni teli mingi kondena mindi kolemolo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Walse, ⸤Juda yembomanga koro moloringi⸥ wale Sambate tenga, Yesusi kinie yu lombili andolime kinie rasi-witi poniemanga ongo puringi kinie yu lombili andoli yemane rasi-witi mongo mare ⸤nongendo⸥ inie toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aku teringi kanokolie Parisi yemane Yesusindu ningendo: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa teangi.’ nimbe pelemo ungu manemo nambemune nu lombili andoli yemane manemo pulue tokolie aku siku tekemeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesusini topondopa nimbendo: “Eno Pulu Yemonga bokune sukundu ⸤anda-kolepa ye nomi kingi⸥ Depisini terimu mele nimbe molemo temanemo kanokolie ⸤temanemonga pulumu⸥ naa pilimeleye? Depisi kinie yu pea puringi yema kinie eno ⸤langi⸥ molo torumu⸤munge⸥ engelene kolkolie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pulu Yemo popo tondoringi ye awili olandopa Apayata molopili Depisi Pulu Yemo molorumu sele-ulkena sukundu pupe, Pulu Yemonga kumbikerena lierimu pillawa kalolime lipe nomba, yu pea puringi yema sirimu noringila kanumu. Kanu pillawa kalolimendo Pulu Yemone ungu mane sipelie nimbendo: “We yembomane paa naa nangi! Pulu Yemo popo tondoli yema manjiku nangi!” nirimu ⸤kanu ungu manemo pulue torumu⸥ kanumu. ⸤Eno konopu talo nambemune lemeleye? Depisi yuni ou aku terimu mele eno pilku keri naa pilimelemonga pe kinié na lombili andoli yemane tekemele mele kanoko keri naa lakanaa!⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aku nimbelie ungu te pea nimbendo: “Pulu Yemone ‘Yemboma molko kondangi.’ nimbe koro molonge wale Sambatemo lipe eno sirimu kanumu. ‘Sambate walemo pepa kondopili.’ nimbe yemboma lipe Sambate walemo naa sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akumunge Sambate walemo kepe Manie Omba Mana Ye A Lierimu Yemo nokolemo yemo molemo-na ⸤Sambate wale kinie yemboma molko kondongendo tenge mele manda nimbé kanumu⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pe walse Yesusi pupe Juda yemboma maku toko Pulu Yemonga ungu pilieringi ulke tenga purumu. Kanu ulkena ye te molorumu, yunge ki te kamu kolopa kukorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kanu kinie akune moloringi ye marene ‘Yesusini ulu te tepa kenjimbe kinie yu kote tendemolo.’ ningu ulu te tepa kenjimbe te ⸤alieli koroko molkolie⸥ ‘⸤Koro molemolo⸥ wale Sambate kinie yuni yemo tepa konde limbenje.’ ningu yu mimi siku kanoko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesusini kanu ki kolopa kukorumu yemondo nimbendo: “Yemboma molemelena ongo ola angilieni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kanu kinie yemando nimbendo: “Sambate wale kinie ulu nambolka ulu te manda temoloye? ‘Sambate walemonga ungu manemone “Teangi.” nilimo mele teamili.’ nimbu yemboma lipu tapondomolo kinie manda molo tepo kenjimolo kinie mandaye? ‘Naa kolangi konde pangi.’ nimbu temolomo manda molo topo kondomolomo mandaye?” nimbe walserimu kinie pilkulie enone ungu te topondoko naa ningu we moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yuni eno neme-neme nimbe kanopalie mumindili kolopa eno yemo kondo naa koloringi kanopalie lakopa konopu keri panjipelie ki kolopa kukorumu yemondo nimbendo: “Nunge kimu sinio si.” nirimu kinie yemone yunge kimu sinio sirimu kinie ki kolopa kukorumumu altopa kamu peanga lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","⸤Yesusini aku terimu kinie kanokolie⸥ Parisi yema pena puku, eno kinie ye nomi kingi Erotenga talapena yema kinie maku toko “Yu nambepo topo kondomoloye?” ningu aulke te kororingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesusi kinie yu lombili andolime kinie eno nomu Gallilli puringi kinie yembo awisili lombili puringila. Kolea Gallilli disiriki yemboma kinie, Judia disiriki yemboma kinie, kolea awili Jerusalleme yemboma kinie, Idumia disiriki yemboma kinie, no Jodane nekendo lemo koleamanga yemboma kinie, kolea awili Taya kinie Saidonoselo lierimu koleamanga yemboma kinie, aku koleamanga moloringi yemboma pali Yesusi ulume tepa molorumu mele pilkulie yu molorumune oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesusini yembo awisili tepa konde lsimu kulu yembo kuru lupe lupe torumumene ‘Yu ambolamili.’ ningu yu angilierimune nondoko pungendo ekelepa teringi kulu Yesusini yu lombili andolimendo nimbendo: “Yembo paa awisili ongo molemele. Yemboma na molombona nondoko ongo ekelepa naa teangi kene sipi te nondoko mengo ongo nosiengi. Na molombona yemboma nondoko ongo ekelepa tenge kinie sipine suku pumbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","⸤Yembomanga konopune⸥ kuru moloringimene yu kanokolie alieli koporongo langoko tondolo ru ningulie ningendo: “Nu Pulu Yemonga Malo.” niringi ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","nalo Yesusini enondo nimbendo: “Yu ⸤sike⸥ molemo mele ⸤yembomane naa piliengi kene⸥ paa naa ningu para siee!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","⸤Pe walse⸥ Yesusi yu ma pangi tenga ola pupelie yuyu pilipelie ‘yu kinie pea tapu topo molamili.’ nimbe pilierimu yemando “Waa.” nirimu kinie yu molorumune oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Oringi yemanga ye engaki rurepo lipe, yu kinie pea tapu toko molko, “Eno nanga kongonomo tende-pangi lipu mundumbo yema molangi.” nimbe eno mako torumu. ‘Eno koleamanga andoko Pulu Yemonga temane peangamo toko si-puku, yembomanga konopune kuru molombama toko makoronge tondolomo eno-kinie pepili andoko toko makorangi lipu mundumbo.’ nimbe kanu ye engaki rurepo aku sipe lipe mako torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kanu ye rurepo mako torumumenga imbime isipe: Saimono (yunge imbi te Pita) yu keme, ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Seperi malo Jemisi keme, Jemisi angenu Jono keme, (elo imbi te Boanekesi sirimula. Boanekesi yunge ungu pulumu mulú tolimunge maloselo.) elo kinie, ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","⸤Pita angenu⸥ Enderu keme, Pillipu keme, Batollomiu keme, Mateyu keme, Tomasi keme, Allapiasinge malo Jemisi keme, Tadiasi keme, “Olio Juda yemboma oliolio gapomano molamili.” niringi talape ye Saimono keme, ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judasi Isikeriote, Yesusi pe lipe opa puluema sirimu yemo keme, ⸤aku yema ‘yunge kongonomo tende-pangi lipu mundumbo.’ nimbe mako torumu yema⸥.. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kanu kinie Yesusi kinie yu lombili andolime kinie eno ulke tenga sukundu puringi kinie yembo awisili akune ongo liku maku toko moloringi kulu eno langi nonge ena te kepe paa naa lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kanu kinie Yesusi pulu lierimu yemboma ⸤Yesusini aku terimu mele⸥ pilkulie “Kangomo paa kekelepa tomu.” ningu yu linge oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pulu Yemonga ungu manemanga pulume pilku mane siringi ye mare Jerusalleme molko oringi kanu yemane ningendo: “Kurumenga nomi Belsipuli Yesusinge konopune molopalie yu tondolo silimo-na yuni kurume topa makorolemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aku siku niringi pilipelie ⸤Yesusi Setene-kinie opa pulue moloringilimunge ‘Setenene yu naa lipe tapondolka paa piliengi!’ nimbe⸥ Yesusini enondo “Waa.” nimbelie enondo ungu iko topa nimbendo: “Setenene Setene yuyu nambepa topa makorombaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yembo talape te konopu telune naa pupili molko suku-singine owe panjiku eno enono opa teko lupe lupe molemele kinie kanu talapemo pora nilimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","⸤Molo⸥ ulke telune pelemele yemboma konopu telune pupili naa molko eno enono opa telemele kinie kanu yembo talapemo sungu siku yu mele mele molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aku sipela, Setenene yunge kuru te makorolkanje aku telkamonga yunge talapemo kinie opamele telka. Pe yunge talapemo kapola naa molemela. Pora nilke. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ye enge nili tene yunge ulkemo nokopa kondolemo kinie ye tene we manda sukundu omba melema wa lipe meli pulimoye? Akumu manda molo. Ou wa noli yemone ye enge nilimunge kimbu kime ka topalie yunge ulkena manda omba melema wa limo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“⸤Akumunge⸥ nane enondo paa sike nimbu sikiru: Yembomane ulu pulu kerime teko ⸤Pulu Yemo⸥ ungu taka tondoko ningu kenjilimele ulume kinie, enonga ulu pulu keri wema kinie pali ⸤Pulu Yemone⸥ ‘Manie pupili.’ nimbe siye kolomba. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nalo yembo tene Mini Kake Telimu ungu taka tondopa, nimbe kenjipe, marake telemo yembomo yu Pulu Yemone aku sipe ulu pulu keri telemoma ‘Manie naa pupili.’ nimbe paa siye naa kolomba. ‘Alieli pepa mindi pupili.’ nimbé.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Enone “Yu kuru te yunge konopune molemo.” niringimunge ⸤aku siku Mini Kake Telimu ningu kenjeringimunge⸥ Yesusini enondo aku sipe nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kanu kinie yembo awisili manie ⸤molko⸥ Yesusini ⸤mane sirimu ungume pilku⸥ molangi yunge anumu kinie angenupili kinie yu-kinie ungu ningendo ongo pena angilku “Yu-kinie ungu niemili opili.” ningu ungu te ningu mundoringi kinie yembomane yundu ningendo: “Aminie kinie angenali kinie nu-kinie ungu ningendo ongo pena angilimele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesusini enondo topondopa nimbendo: “Nanga anumu naweye? Nanga angenupili nameleye?” nimbelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","yunge ungumu manie molko pilku moloringi yemboma neme-neme nimbe kanopalie nimbendo: “I yemboma nanga anumu kinie nanga angenupili kinie molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pulu Yemone “Teangi” nilimo mele pilku liku telemele yemboma nanga anumu kinie nanga angenupili kinie nanga kemulupili kinie molemelemonga aku sipu nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Walse Yesusi altopa nomu ⸤Gallilli⸥ kélona pupe yemboma mane sipe molorumu kinie yembo paa awisili yu molorumune ongo maku toko moloringimunge nona andoli sipi te lierimumunge suku pupe manie molorumu, yemboma nomu kélona angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yuni enondo ungu awisili nimbe simbendo ungu iko pokore torumu. ‘Eno mane siembo.’ nimbelie ungu iko te isipe topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pilieme. Ye tene rasi-witi umbu poniena andopa tanda sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tanda silipe andorumu kinie umbu mare aulkena manie purumu, kanume keramane ongo liku noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Umbu mare kou perimune manie pupelie ma wallo-kolte mindi lierimu kulu nondopa muli topa wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nalo pulkinio naa mundorumu kulu ena terimu kinie kanume kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Umbu mare kombulu-siri ka mele molorumune manie purumu, siri ka melemo wendo omba witi umbume topa norumu kulu omba peanga naa lepa mongo te naa torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Umbu mare ma peangana manie purumume wendo wendo omba akopalie mongo peangama torumu. Mare mongo tokapu-telu mele topa, mare mongo tokapu-talo mele topa, mare tokapu kise mele torumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aku nimbelie “Yembo komu-peo lemomane iungumu piliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pe we yemboma pali puringi kinie yu lombili andoli ye engaki rurepo kinie yembo mare pea yu kinie moloringime kinie, enone yu walsikulie ningendo: “Nuyembomando ungu te ninindu nambemune ungu iko tolenoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Yuni enondo topondopa nimbendo: “Pulu Yemo yenomi kingimu molopa yemboma kinie melema kinie nokolemomonga ulu pulu nce ou yuyu pilierimu kanu ulu pulume ‘Kinié eno ⸤na lombili olemele yemboma⸥ piliengi!’ nimbelie eno nimbe sikimu. Nalo ulsu molemele yemboma ‘Ungume nimbu siembo.’ nimbulie ungu ikoma mindi topo silio. ⸤Pulu Yemone Aisayanga kerena nimbendo:⸥ ‘Eno mongone kanokolie naa kanoko, komuni pilkulie naa pilimele. Konopuni pilkulie alowa telemela kinie, ⸤Pulu Yemone⸥ enonga ulu pulu kerime ‘Manie pupili.’ nimbe siye kolka.’ nirimu akumunge we yembomando ungu ikoma mindi tolio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aku nimbelie Yesusini enondo kelepa nimbendo: “Ungu iko topo nindu akumunge ungu pulumu naa pilimeleye? Akumu naa pilkulie we ungu ikomanga pali ungu pulume nambeko pilingeye? ⸤Ungu ikomonga pulumu isipe:⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Langi umbu tanda sirimu yemone tanda sirimu umbume ⸤Pulu Yemonga⸥ ungumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Umbu mare tanda sirimu aulkena manie purumume yembo mare i siku mele molemele. Enone ungumu pilimele kinie pe ⸤kurumenga nomi⸥ Setenene sumbi sipe omba ungu tanda sili konopune pupe pelemoma wendo limo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aku sipela, umbu mare tanda sirimu kou perimune manie purumume yembo mare i siku mele molemele. Enone ungumu pilkulie walsikele sumbi siku konopu siku pilku limele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nalo eno pulkinio naa mundukulie ungumu laye kolte mindi pilku molemele. Pe eno konopune umbune telemo kinie molo eno ⸤Pulu Yemonga⸥ ungumu pilku liku molemele mele yembo lupemane kanoko keri kanokolie ungu taka tondoko teko kenjiku mindili silimele kinie enonga pilimele ungume siye kolemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Umbu mare tanda sirimu siri ka mele molorumune manie purumume yembo mare kepe i siku mele molemele. Enone ungumu pilimele ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nalo konopune umbune telemo umbunema kinie, mele awisili nosikulie ‘Aku melemane olio lipe tapondolemo tapondomba.’ ningu pilku molemele ulume kinie, mele naa nosilimelema waka kolko ‘liemili.’ konopu lemele ulu mare kinie, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinie ungumuni uluri naa tepa langi mongo naa tolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Umbu mare tanda sirimu ma peangana manie purumume yembo mare i siku mele molemele. Enone ungumu pilkulie ungu pulumu pilku kondoko ungumu kamu pilku limele. Pe eno langi mongo mele tolemele. Kanu yembo marenga langi mongo tokapu telu mele topa, yembo marenga mongo tokapu talo mele topa, marenga mongo tokapu kise mele topa, aku sipe tolemo. ⸤Ungu ikomonga ungu pulumu aku sipe.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","⸤Aku nimbelie ungu iko te pea topa nimbendo:⸥ “Yembomane tepe-llame kandokolie mingine suku panjilimeleye? Molo polo maniekondo nosilimeleye? Polo tenga ola nosilimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aku sipe mele, kinié lopi telemo melema pe walse mona lemba yemboma kanonge; kinié aki topa lemo melema pe walse patemba kinie yembomane kanu melema kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yembo komu-peo lemomane ⸤ungu nikirumu⸥ piliee.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Enone ungu pilimele akumu mimi siku piliengi! Enone melema yemboma silimele mele ⸤Pulu Yemone⸥ eno aku sipe mele kalomba. Mare olandopa simbela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Melema nosilimo yembomo nane mare pea simbo, yu paa awisili nosimbe. Nalo melema naa nosilimo yembomo yu nosilimoma kepe wendo limbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesusini ungu te pea nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu isipe mele: “Ye tene langi umbu mana tanda silimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aku yemo ipulueli uru pepa, tangoli ola molopa ⸤andopa kongono tepa⸥., telemo kinie langi umbu tanda silimoma muli topa omba awi lemo nalo aku sipe telemomonga pulumu yemone nimbe naa kanopa naa pilimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Langi umbu tolemoma mamone yu yuyu ‘wendo opili.’ nilimo. Ou kumbi lepa muli tolemo. Pe gomo angilimo. Pe langi mongo tolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pe langi nou lemo kinie ‘Langi inie topo sukundu sukundu limbo walemo wendo okomo.’ nimbelie langi umbu tolemo yemone langi inie tolemo. ⸤Pulu Yemo ye nomi kingi molopa yemboma nokolemo aku sipe molemo.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pe Yesusini enondo kelepa nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokolemo akumu nambolka melte mele niemboye? ‘Yu kingimu molopa yemboma nokolemo mele piliengi nimbu siembo.’ nimbulie nambolka ungu ikomo topo niemboye?” ⸤nimbelie nirimumuni, altopa ungu iko te pea topalie nimbendo:⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Pulu Yemo ye nomi kingi molopa yemboma nokolemo akumu unjo masetete umbu mele: Yemboma langi umbu poniena mundulimelemanga pali unjo masetete umbumu yu paa kangamo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nalo poniena mundulimele kinie wendo omba awi lemo kinie poniena molemo melemanga pali yu paa awilimu. Kamu awi lepa unjo mele angilimo kinie kerama kanu unjo kolamanga ongo pelemele. Pulu Yemo ye nomi kingi molomba mele aku sipe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusini ungume yemboma nimbe simbendo ungu iko awisili aku sipema topa sirimu. Eno manda pilinge mele topa sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eno ungu te nimbe simbendo ungu iko te mindi torumu. ⸤Ungu te sumbi sipe naa nimbe sirimu.⸥ Nalo yu kinie yu lombili andolime kinie eno enono moloringi kinie yuni yunge ungumenga pulume pali eno sumbi sipe nimbe para sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kanu walemonga kolea kala torumu kinie Yesusini yu lombili andoli yemando nimbendo: “Nomu nekendo pamolo.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","nona andoli sipi tenga Yesusi ou suku molopalie ungume nirimu akune suku yu we molopili nomu kélona maku toko moloringi yemboma munduku siye kolko yu mengo puringi. Sipine puringi kinie sipi mare pea puringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kanu kinie, nomune punge puringi kinie poporome paa awili te nomune torumu. Aku terimu-ne nomumu apisipe ola ombalie no sipine sukundu sukundu omba peke lepalie sipimu memba nona manie pumbe terimu ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","nalo Yesusi sipimunge bulkundu penge kanda wale tenga we uru perimu. Yu lombili andoli yemane yu toko makinjindikulie ningendo: “Ungu Mane Silimu, olio no wangopo kolomolomonga nu mini-wale naa pukumuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yu makilipelie poporomemo iri topa nomumundu nimbendo: “Taka liku molou!” nirimu kinie poporomemo topa kelepa nomumu lope naa tepa paa we lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kanu kinie yuni lombili andolimendo nimbendo: “‘Pulu Yemone olio nokomba.’ ningu konopu tondolo naa pekemo yema, eno nambemune mini-wale mundukumiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","⸤Yuni terimu mele kanokolie⸥ yemane mini-wale munduku pipili awili teko kolkolie anjo yando enono walsikulie ningendo: “Apa! Iyemo nawenje? Poporomemone kepe nomumuni kepe yunge ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kanu kinie, ⸤Yesusi kinie yu lombili andoli yema kinie⸥ eno ⸤nona andoli sipine⸥ nomu nekendo puku kolea Gerasa puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Akune oringi kinie Yesusi sipine wendo orumu kinie konopune kuru molorumu ye te, yembo ono koleana pelipe andorumumu tamburumbu wendo omba yu molorumune orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Kanu yemo, yembo ono koleana yunge perimu koleamo lierimu. ⸤Kurumu yunge konopune molorumumunge yu paa enge nirimu kulu⸥ yembomane yu taki-teki ka wemane kinie, ka senene kinie kepe yu kimbu kime ka toringi ka senema yu sungu sipe, kimbuselo anakapa panjeringimu elke-malke tondorumu. Ye teluri kepe enge te perimu-ne ‘Yu taka lipe molopili.’ nimbe manda ambolopa nokomba ye te paa naa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Alieli, ipulueli kepe tangoli kepe, yembo ono koleana kinie ma pangimenga kinie kalle nilipe andopa, yunge kangimu yu yuyu kou ⸤nee angilieli⸥ marene kopisilipe andopa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Kanu yemone sulu tepa molopa Yesusi kanopalie yumolorumune lkisipe orumu. ⸤Orumu kinie⸥ Yesusini nimbendo: “Kurumu, iyemonga konopune ongo wendo pu!” nirimu mele pilipelie yemone yunge kumbikerena koporongo langopa tamalu pepa yundu tondolo ru nimbelie nimbendo: “Yesusi, Pulu Ye Paa Olandopa Awilimunge Malo, na-kinie ulu nambolka uluri tenindu onuye? ‘Pulu Yemonga imbimu leko mi leko “Paa sike nikiru. Namindili paa naa lipu simbo.” ni!’ nimbu mawa tekero.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aku nirimu kinie Yesusini yemondo walsipelie nimbendo: “Nunge imbi naweye?” nirimu kinie yuni nimbendo: “⸤Olio paa awisili kene⸥ nanga imbi Paa-Awisili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aku nimbelie wale awisili Yesusi mawa tepalie nimbendo: “Olio ‘ongo wendo pangi.’ ningu toko makorokolie “I koleamo munduku siye kolko kolea luperenga paa.” ni naa ni.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akune ma pangi tenga umbu kongi awisili ímu nongo moloringi kanokolie ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kurumene Yesusi mawa tekolie ningendo: “Olio ⸤toko makorokolie⸥ “Ne kongime molemelena puku, enonga konopune molo-pangi.” ni.” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yuni “Kapola, akune pangi.” nirimu kinie kurume kanu yemonga konopune wendo ongolie kongi akune moloringimenga konopune puku moloringi kinie kanu kongime kekelepa toko lkisiku puku kopona pukue toko nomune suku puku no wangoringi. Kongi kanume ⸤paa awisili,⸥ tausini talo mele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","⸤Ulu akume wendo orumu-ne kanokolie⸥ kongi tapu teko moloringi yema talopa leko pukulie niringimuni, kolea awiline moloringi yemboma kinie, kolea kangamanga moloringi yemboma kinie, ulu akume wendo orumu mele temane toko siliku puringi. Kanu temanemo pilieringi yemboma ‘Ulume wendo orumu mele kanamili.’ ningu wendo puku ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusi molorumune ongolie ou kuru paa awisili konopune molko ongo wendo puringi yemo mulumbale pakopa, umbu konopu pepili molorumu kanokolie eno pipili koloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yesusini terimu mele mongone kanoringi yembomane pe oringi yemboma ningu siringi. Kuru awisili konopune moloringi yemo kinie, kongime-kinie ulume wendo orumu mele temanemo toko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kanu kinie yemboma ⸤paa mini-wale mundukulie⸥ Yesusi mawa tekolie ningendo: “Olionga koleana naa mololi kelko pu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aku siku niringi pilipelie Yesusi pumbendo nona andoli sipine suku pumbe purumu kinie kuru awisili konopune ou molko wendo oringi yemone yundu nimbendo: “Pea pambili.” nimbe mawa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nalo Yesusini “Molo.” nimbe yundu nimbendo: “Nu lkondo puku Awilimuni nu kondo kolopa ‘Molko kenjenu mele pora nipili.’ nimbe, lakopa tepa kondomu mele nunge pulu lemo yemboma ningu si-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yesusini aku nirimu-ne pilipelie ye kanumu pupe yunge kolea, ‘Kolea Awili Rureponga Talo’ niringi koleana andopa Yesusini lakopa tepa kondorumu mele nimbe sirimu. Nimbe sirimu kinie pilkulie yemboma pali paa suru ningu mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesusi ⸤yu lombili andolime kinie⸥ nona andoli sipine suku pupe nomu yakondo altopa ombalie nomu kélona wendo orumu kinie yembo awisili yu molorumune ongo liku maku toko kakapu teko moloringi. Yu nomu kélo akune molopili ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke te nokorumu ye te, yunge imbi Jairasi, Yesusi molorumune orumu. Kanu kinie yu Yesusi kanopalie Yesusi yunge kimbune nondopa omba manie molopa tamalu pepa ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yundu tondolo mundupe mawa tepalie nimbendo: “Nanga ambola nanamo nondopa kolomba tekemo kene ‘Yu konde pupe kapola molopili.’ ningu ongo yu kimuni ambolou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aku nirimu-ne pilipelie Yesusi yu pea puringili. Pungele puringili kinie yembo awisili liku maku toko lombili puku yu kakapu teko ekelepa teko pea puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kanu kinie ambo te molorumu kanumunge pena perimu walema pora naa nirimu. Yu pena mindi pepili ponie engaki rurepo omba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yu doketa awisilimenga yunge kurumu ‘Pora nipili.’ nimbe andorumu nalo mindili mindi siringi. Yunge kou mone pali eno sirimu nalo yunge kuru pora naa nirimu. We topa olandopa mindi purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kanu ambomo Yesusi ulu tondoloma terimu mele temanema pilipelie yemboma maku toko angilieringine sukundu omba Yesusinge bulkundu omba yunge wale pakolimu ambolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‘Yunge wale pakolimu mindi ambolondu liemo na konde pumbo.’ nimbe pilipelie aku terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","⸤Ambolorumu kinie⸥ walsikele yunge kuru torumu kanumu pora nirimu, yunge kalumu ou umbune perimu mele waengo nirimu pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nalo ⸤yu Yesusinge wale pakolimu ambolorumu kinie⸥ Yesusi yuni yemboma lipe tapondoli tondolo mare yunge kangine omba ulsu purumu sumbi sipe pilipelie topele topa kanopa yembomando walsipe pilipelie, “Nanga wale pakolimu nawene ambolomuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nalo ⸤yuni walserimu mele pilkulie⸥ yu lombili andoli yemane topondoko ningendo: “Yembo awisili nu angilinona nondoko nondoko ongo kakapu teko ekelepa teko angilkimili kanumu. Pe nambemune “Nawene na ambolomuye?” nikinuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nalo Yesusi mongo male-male tepa koropalie “Akumu nawene temuye?” nimbe we angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kanu kinie tondolo tene yunge kangine kurumu pora nirimu pilipelie ambomo paa pipili kolopa kangime puru-puru nipili Yesusi molorumune omba manie molopa tamalu pepalie yu ulu terimume pali nimbe para sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesusini yundu nimbendo: “Ambolamo, ‘Nu manda tepa konde limbe.’ ningu tondolo munduku pilienu kanu ulumuni nu konde pukunu. Nu kuru pora nimbe konopu pe nipili molo-pani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesusini ambomondo aku sipe nimbe molorumu kinie, ye mare, yemboma maku toko Pulu Yemonga pilieringi ulke nokoli ye Jairasinge ulkena molkolie ongo ⸤Jairasindu⸥ ningendo: “Nunge ambolamo kolopa pora simu. Nambemune Ungu Mane Silimu ‘Mindili nopili.’ ningu we mengo oniye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nalo Yesusini eno niringi ungumu pilipe naa lipelie ulke nokoli yemondo nimbendo: “Mini-wale naa mundoyo. ⸤Nunge ambolamo nane ‘Manda lipe tapondomba.’ ningu⸥ tondolo munduku piliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kanu kinie yuni maku toringi yembomando “Naa ongo anjo paa.” nimbelie Pita keme Jemisi keme angenu Jono keme akume mindi lipelie “Pea pamolo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ulke nokoli yemonga ulkena oringi kinie yembo awisili molko kondo kolko kola awili-teko teko moloringi kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yu ulke suku pupelie yembo moloringimendo nimbendo: “Eno nambemune kola teko kalle ningu molemeleye? Ambolamo kolou naa kolomu. We uru mindi pelemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nalo aku nirimu kinie enone yu ungu taka tondoko tawe tenderingi. Eno pali makoropa pena-pena tepalie, ambolamonga anumu lapaselo kinie, kanu lombili andoli ye pokore kinie lipe memba ambola onomo lierimu suluminiana purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pupelie ambolamonga kimu ambolopa Juda yembomanga ungu lepa yundu “Tallita kumi!” nirimu. (Ungu akumunge pulumu isipe: “ “Ambolamo, nu ola molou.” nikiru.” nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aku nirimu kinie ambolamo tamburumbu ola molopalie andorumu. (Ambola kanumu ponie engaki rurepo mele omba pupili yu molopalie kolorumu kinie Yesusini omba tepa konde lsimu.) ⸤Akumu kanokolie⸥ yu kinie moloringi yemboma suru ningu mini-wale awili teko mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kanu kinie Yesusi yuni enondo tondolo mundupe nimbendo: “Ulu itekeromo yembo telurindu kepe anjo puku paa naa ningu siee!” nimbelie ⸤anumundu⸥ nimbendo: “Ambolamo langi mare liku si.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesusi molorumu koleamo mundupe siye kolopa yunge pulu kolea ⸤Nasarete⸥ purumu, yu lombili andoli yema pea puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","⸤Juda yembomanga koro moloringi⸥ wale Sambatemo wendo orumu kinie eno maku toko Pulu Yemonga ungumu pilieringi ulkena suku pupelie yemboma mane sipe molorumu. Yunge ungumu pilku moloringi yembo awisilini suru ningu mini-wale mundukulie ningendo: “Ne yemo aku ungume tena lsimunje? Yunge pilipe konginjelimu kinie yunge ulu tondolo telemomanga tondolomo kinie yu tena lsimuye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yu ulkema takondorumu yemo moloye? Yu Maria malo moloye? Jemisi keme Josepo keme, Judasi keme Saimono keme, enonga angenu moloye? Yunge kemulupili olio kinie pea naa molemoloye? ⸤Yu paa sike aku yemo molemomo⸥.” niringi. ‘Yu paa we yemo nambepa itondoloma yu-kinie pelemoye?’ ningu pilkulie eno yu kanoko keri kanoko yu-kinie paa konopu keri panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kanu kinie ⸤eno yu-kinie mumindili koloringimunge ulu pulumu pilipelie⸥ Yesusini enondo nimbendo: “Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye te koleamanga pali imbi ola molemo, yembomane pali yunge ungume pilku limele. Nalo yunge koleana yu kinie pea tapu toko molemele yemboma kinie, yunge pulu lemo yemboma kinie, eno mindi yuni nilimo ungumu pilkulie ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo ungume naa pilku, liku su silimele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","⸤Yunge ungumu liku su siringi kulu⸥ kolea akune yuni ulu tondoloma manda naa terimu. Kuru torumu yembo telu telu nimbe mindi kimuni ambolopalie tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yu ⸤ungu nimbe ulume tepa molorumu mele⸥ ‘Sike.’ ningu tondolo munduku naa pilieringimunge yu paa konopu awisili lierimu. Kanu kinie Yesusi kolea kanga lupe lupemanga andopalie ⸤Pulu Yemonga ungumu⸥ mane silipe andorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesusini yu lombili andoli engaki-rurepondo “Waa.” nimbelie enone yembomanga konopune kuru molemoma “Ongo wendo paa.” ningu toko makoronge tondolomo sipelie eno talo talo nimbe “Koleamanga ando-paa.” nimbe lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","⸤Lipe mundupelie⸥ eno tenge mele ungu mane sipelie nimbendo: “Pungendo eno melema naa meangi. Apulu-mingime mindi liku ambolko pangi. Kimbu-su mondonge manda nalo wale pakoli talo kepe langi kepe mele-wale kepe naa mengo, kou mone kakona kepe naa panjiku we pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Pe kolea tenga suku pukulie akune molongendo ulke teluringe suku pukulie akune mindi peko molkolie pe aku koleamo munduku siye kolko pangi. ⸤Ulke pinie pinie naa andoko ulke teluringe mindi langi nongo peangi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kolea marenga suku punge kinie kolea pulu yembomane “Pea peamili waa.” ni naa ningu enone ungu ningema pilku naa lingi liemo kanu koleana yembo kerime munduku siye kolko pungendo kanu koleana yembomane eno liku su singemonga ‘Eno kamu molko kenjengi! Pulu Yemone eno lipe naa tapondomba mele piliengi!’ ningu enonga kimbune kanu koleamanga ma angilimbema kulu toko pangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","⸤Yu lombili andolime yuni aku sipe lipe mundorumu-ne pilku⸥ pukulie yembomando ningendo: “Ulu pulu keri telemelema kanoko keri kanoko konopu alowa teaa.” ningu ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","yembomanga konopune kuru awisili moloringime ⸤‘Ongo wendo paa.’ ningu⸥ toko makoroko, kuru torumu yembo awisili ‘Konde pangi.’ ningu enonga kangine ollipi-kopongo ondo leko kandondoko teko konde liku, teliku andoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kanu kinie Yesusi yunge imbimu yemboma pilku lieringimunge ye nomi kingi Erote Yesusini terimu mele temane toringi pilierimula. ⸤Yesusini tepa nirimu mele pilkulie⸥ yembo marene ningendo: “I ulume telemo yemo No Lindeli Jono lepamo! Yu kolopalie lomboropa wendo omumunge ulu tondoloma temba tondolomo yu-kinie pelemo.” ningu moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yembo marene ningendo: “Yu ⸤ou konde molopili Pulu Yemone olando lsimu ye⸥ Illainja kelepa omba molemo.” niringi. Yembo marene ningendo: “Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi ye koro ou moloringi yema mele yu aku sipe Pulu Yemonga ungu umbu tondolemoma pilipe yando nimbe silimo yemo molemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nalo ye nomi kingi Erotene ⸤Yesusi yuni terimu mele temane toringi⸥ pilipelie nimbendo: “I ulume telemo yemo ⸤No Lindeli⸥ Jono, ‘Yunge pengemo wendo pupili.’ nimbu nomi karu lierindu kanu yemo. Yu kolopalie lomboropa wendo omu lepamo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","⸤Kingi Erotene aku sipe nirimu ungumunge pulumu i sipe:⸥ Ou walse Erotene yunge angenu Pillipunge ambo menu Erodiasi mangopa lsimu. ⸤No Lindeli⸥ Jonone Erote aku sipe terimu kanopalie yundu alieli nimbendo: “Nuni ⸤Pulu Yemonga⸥ ungu mane te pulue toko angenanga ambomo mangoko lsinu. Akumu teko kenjerinu.” nirimu kinie Erotene yu lipe ka sipe ka ulkena panjerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Jonone aku nirimumunge ambo Erodiasini yu mumindili kolopa “Yu topo kondambo.” nimbe molorumu nalo Erotene ‘Jono yu konopu sumbi sipe pepa Pulu Yemonga ye kake telimu molemo.’ nimbe kanopa yu pipili kolopalie nokopa kondorumumunge ambo Erodiasini Jono-kinie ulu te manda naa terimu. Jonone ungu nirimume pilipelie ye nomi kingi Erote yu paa konopu awisili lipe mundupe mini-wale mundorumu nalo aku ungume yu paa konopu sipe pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe walse, ⸤ambo Erodiasi⸥ konopuni pilipe molorumu ulumu manda temba walemo wendo orumu. Wendo orumu mele isipe: Kingi Erote meringi walemo wendo orumu kinie yunge kendemande awilime kinie, yunge ami yemanga ye nomime kinie, kolea Gallilli disiriki yembomanga ye nomi awilime kinie, enondo “Langi pea namili waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","⸤Eno ongo yu kinie pea langi nongo molangi⸥ Erodiasi lemenu ulkena sukundu omba eno moloringine denisi terimu. Erote kinie, yu kinie pea langi nongo moloringi yema kinie enone ambo wenepomo aku terimu kanoko paa peanga kanoringi. Kingimuni paa kanopa peanga kanopalie ambo wenepomondo nimbendo: “Nuni konopu mondokono melte na mawa téa. Mawa teni melemo nu simbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pulu Yemonga imbi lepa mi lepalie yundu kelepa nimbendo: “Paa sike nikiru. Nuni na mawa teni mele te paa sike simbo. Nane ye nomi kingi molopo nokolio koleamo ekendo kepe “Si.” ninu liemo paa sike simbomo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Erotene yundu nirimu mele pilipelie ambo wenepomo pena pupe, anumu molorumune pupe walsipelie nimbendo: “Mele nambolka melemo ‘Si.’ niemboye?” nirimu kinie anumuni nimbendo: “‘‘No Lindeli Jononga ⸤nomimu karu leko yunge⸥ pengemo si.” ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anumuni aku nirimu pilipelie yu kingimu molorumune tamburumbu lkisipe omba mawa tepalie nimbendo: “Paa isili ou No Lindeli Jono ⸤nomi karu leko⸥ yunge pengemo pellete tenga nosiku yando si.” nirimu. ⸤Jonone ou alieli “Erote kinie Erodiasiselone teko kenjeringili.” nirimumunge mumindili kolopalie Erodiasini ‘Yu kolopili. Sike kolomunje na kanambo.’ nimbe “Pengemo ongo si.” nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yuni aku sipe mele mawa terimu kinie pilipelie Erote paa konopu umbune terimu nalo yuni “Paa sike simbo.” nimbe, nimbe panjipe Pulu Yemonga imbi lepa mi lierimu mele kepe, yu konopu alowa temba kinie yu-kinie pea langi nongo moloringi yema yu kanoko keri kanonge mele kepe, aku uluselo pilipelie, “Yuni mawa tepa “Si.” nikimu mele “Molo.” manda naa nimbo.” nimbe pilipelie ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","yu nokoringi ami yemanga te lipe mundupelie “⸤No Lindeli⸥ Jono ⸤nomi karu leko⸥ yunge pengemo yando mengo ou.” nirimu kinie kanu ami yemone ka ulkena pupe Jononga nomimu karu lepalie ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","yunge pengemo pellete tenga nosipe yando memba omba ambo wenepomo sirimu kinie yuni anumu sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aku teringi pilkulie Jono lombili andoringi yema ongo yunge onomo liku mengo puku ono teringi. ⸤Kingi Erotene No Lindeli Jono ou aku sipe topa kondorumu kolorumumunge pe Yesusini ulu tondoloma terimu mele pilipelie “Jono nomi karu lierindu yemo lomboropa ola molemo lemo.” nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesusini “Nanga kongonomo tende-paa.” nimbe lipe mundorumu yema yu molorumune kelko yando ongolie niringimuni, ulu teringime kinie yemboma ungu mane siringime kinie yu temane toko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nalo yembo awisili ongo puku ongo puku ⸤teko ungu ningu panjiku⸥ teringimunge Yesusi kinie ⸤yuni lipe mundorumu ye yando oringime⸥ kinie langi nonge ena wallo-kolte kepe naa lierimumunge kanopalie Yesusini yemando nimbendo: “Eno enono yembo naa mololi kolea ku tenga laye-kolte mulu piliengi kene na-kinie pea pamili waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanu kinie eno enono mindi nomune andoli sipi tenga suku puku yembo naa mololi kolea ku lieli tenga puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nalo punge puringi kinie kanokolie yembo awisili Yesusi kinie yu lombili andolime kinie kanoko imbi siringimunge koleamanga yemboma pali kimbu kongono teko lkisiku nomu kélona makaye teko puku eno nomune wendo punge koleana kumbi leko puku nokoko angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesusi nomu kélona ulsu omba kanopa yembo paa awisili akune ongo maku toko moloringi kanopalie eno kongi sipisipi tapu teli ye te naa mololi sipisipime mele ku peko moloringi kulu nimbe kanopalie eno kondo kolopa ungu awisili mane simbe terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kanu kinie ⸤mane sipe molopili⸥ ena pumbe terimumunge yu lombili andolime yu molorumune ongo yundu ningendo: “I koleana yembo te naa pelemo, ena kamu pukumu kene ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ya maku toko molemele yemboma “Puku kolea marenga langi topo toko li-pengi.” ni.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nalo yuni ⸤yu lombili andolimendo⸥ topondopa nimbendo: “Enone enono yemboma langi mare liku siee.” nirimu. Enone yu walsikulie ningendo: “‘Kakopoi ye tene oli engaki kongono tepalie mele kalolimu limo kou monemane olio langime topo topo lipulie yemboma siemili.’ ningu nikinuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","⸤Aku siku niringi pilipelie⸥ yuni eno walsipe pilipelie nimbendo: “Pillawa kaloli nambepa nosikimiliye? Puku kano-paa.” nirimu. Puku koroko kanoko lendeko yu molorumune kelko ongolie ningendo: “Ya langi awisili molo. Pillawa kaloli kanga kise pakera kinie oma kaloli talo kinie ⸤aku langi pokore mindi lemo⸥.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kanu kinie Yesusini nimbendo: “Yembomando “Era kondili niline maku toko manie molangi.” niee.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","yemboma tokapu talo molo tokapu kise ningu maku toko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kanu kinie Yesusini pillawa kaloli kise pakera kinie oma talo kinie kanume lipelie mulu koleana olando sipe kanopa ⸤Pulu Yemo kinie⸥ “Ange.” nimbe pillawa kalolime ambolopa pike lepa lombili andolime moke tepa sipelie “Anjo yemboma siee.” nirimu, ⸤enone⸥ yemboma ⸤moke teko siringi⸥. Oma talo kepe lipe moke tepa yemboma pali sirimula. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eno pali kanu langime noringi kinie olo terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kanu kinie lombili andolimene pillawa kaloli kinie oma kinie kanumenga goli lierimume liku maku toko wale-basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Langi noringi yema manjipe pape tausini mele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","⸤Yemboma langi sirimu noringi⸥ kinie Yesusini yu lombili andoli yemando sumbi sipe nimbendo: “Maku toko molemele yemboma nane “Pangi.” niembo. Eno nona andoli sipine ola puku no nekendo, Besaida taono lemona, kumbi leko paa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kanu kinie yemboma mundupe siye kolopalie yu yuyu Pulu Yemo kinie ungu nimbendo ma pangine ola purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kanu kinie ena pupe kolea kala torumu kinie sipimu nomu awi suku singine purumu, Yesusi yuyu ma ⸤pangi⸥.ne molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sipi kumbikundu mendo sipe poporomene torumumunge ⸤yu lombili andoli yema sipine suku molkolie⸥ sipimu nomu kélona mengo pungendo pereringi kanopalie ipulueli kolea muni naa liepili eno puringine yu nona ola kimbu kongono tepa ombá ombalie eno sipine puku molangi yuni eno topa akili lendepa yu kumbi lepa pumbe orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nalo yu lombili andolimene pali yu nona ola kimbu kongono tepa orumu kanokolie niringimuni, paa pipili awili teko kolkolie “Kuru te okomaa!” ningu mini-wale mundoringi kinie Yesusini tamburumbu enondo nimbendo: “Eno konopu tondolo pupili molayo. Na mindi okoro. Pipili naa kolaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Kanu kinie yu sipine suku purumu kinie poporome topa kelierimu. Aku terimu-ne kanokolie paa mini-wale mundoringi. Yuni ⸤ou tangoli⸥ pillawa kalolime ⸤moke⸥ terimumunge pulumu naa pilku we konopu lou leko moloringi. Yu-kinie tondolo te perimu-ne pillawa kalolime-kinie ulu tondolo te terimu mele mimi siku naa pilkulie eno konopu naa perimu-ne kanu tondolomone poporomemo topa kelierimu mele kepe naa pilkulie poporomemo topa kelierimu kinie kanokolie eno paa mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","⸤Yesusi kinie yu lombili andolime kinie⸥ nomu ⸤Gallilli⸥ nekendo pukulie nomu kélona kolea Geneserete lierimune wendo ongolie sipimu ka teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sipine manie oringi kinie akune moloringi yembomane Yesusi tamburumbu kanoko imbi sikulie ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","akundu lierimu koleamanga pali lkisiku puku yu andorumu koleama pilkulie enonga kuru torumu yemboma liku taropola teko yu andorumune mengo oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yu andorumu koleamanga pali, kolea kangamanga kinie, kolea awilimenga kinie, kolea wemanga kinie, aku koleamanga yemboma maku toko moloringi koleamanga kuru torumu yemboma mengo ongo nosikulie, “‘Nunge wale-pakoli pundumu kepe ambolangi.’ ni.” ningu mawa teringi. Kanukinie kuru torumu yembomane yunge wale-pakolimu amboloringi yemboma pali kamu konde puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","⸤Walse⸥ Parisi ye mare kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi ye mare kinie eno Jerusalleme munduku siye kolko Yesusi molorumune ongo maku toko moloringimene ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","yu lombili andolimene ki kalaro molopili ou kulumiye naa toko langi we ambolko noringi kinie kanokolie kanoko keri kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(⸤Sike kalaro naa molorumu nalo⸥ Parisi yema kinie we Juda yemboma kinie enonga anda-kolepalimene “Teaa.” niringi mele pilku liku tengendo ou ki pali nona munduku kulumiye toko kondokolie langi pe noringi. Wenaa noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Makete koleana puku ulkendo ongolie kiou kulumiye naa tokolie ⸤maketena topo toko lsingi⸥ langime naa noringi. Anda kolepalimenga teringi ulu pulu lupe lupe awisili pilku liku teko moloringila. Kápoma kinie, mingime kinie, langi noringi poloma kinie, aku sipe melema taki-teki we kulumiye toringi.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","⸤Juda yembomane aku siku teringi⸥ kulu Parisi yema kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, enone ⸤Yesusi lombili andolimene aku siku ki kulumiye naa toko langi we noringi kanokolie⸥ Yesusindu walsiku pilkulie ningendo: “Anda kolepalimene “Teaa.” niringi mele nunge lombili andolimene nambemune naa pilku liku telemeleye? Enonga kime kalaro molopili langi nolemele kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesusini enondo topondopa nimbendo: “Eno ⸤ungu manema pilku mane silimele yema kinie Parisi yema kinie⸥ eno topele mapele toli yema molemele! Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane enondo nirimu mele papu nirimu. ⸤Enone kinié telemele mele yuni ou nimbe Pulu Yemonga⸥ bokune torumu molemo mele isipe: ⸤Pulu Yemone nimbendo:⸥ “Kanu yemboma enonga keremane na kapi ningu ‘Ye awili olandopamo. Nu lipu awi silimolo.’ ningu na imbi liku ola mundundulimele nalo enonga konopume kinie nanga konopumu kinie telune naa pulimo. Lupe lupe pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Enone ‘Nanga imbi lipu ola mundundemili.’ ningu na we popo toko kapi nilimele. Mana yembomane mane silimele ungume mindi mane sikulie ‘Iungu manema Pulu Yemone “Teaa.” nilimo ungu manema.’ ningu pilku liku telemele, akumunge na popo tonge kinie uluri naa temba.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pulu Yemone “Teaa.” nirimu ungu manema munduku siye kolkolie anda-kolepalimene “Teaa.” niringi mele mindi ambolko molemele.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","⸤Yesusini⸥ ungu mare pea enondo nimbendo: “Enonga anda-kolepalimene “Teaa.” niringi mele pilku liku tengendo Pulu Yemone “Teaa.” nirimu ungu manema bulu silimele mele papu telemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Akumunge Mosisini nimbendo: “Aminieli lanielinge ungume pilku liku, liku awi siku teaa.” nimbe “Yembo tene yunge anumundu molo lapando ungu te nimbe kenjipe iri tomu liemo kanu yembomo toko kondangi.” nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nalo eno yemane ningendo: “Ye tene yunge anumu lapaselondo nimbendo: “Nane elo mele mare lipu tapondopo silkema koronga ‘Pulu Yemo simbo.’ nimbu panjerindu kanumunge elo manda naa lipu tapondopo simbo.” nimbelie ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yunge anumu lapaselo naa lipe tapondomba kinie papu.” ningu mane silimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aku siku mane silimele ungumuni ‘Anda-kolepalimene mane siringi ulu pulume olandopa.’ ningu ‘Pulu Yemone nirimu ungumu uluri molo. Manie pupili.’ nilimele. Enone ulu lupe lupe awisili aku siku teko molemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aku nimbelie Yesusini maku toko moloringi yembomando “Na moliona waa.” nimbelie enondo nimbendo: “Nane ⸤aku nikirumunge ungu te⸥ nimbo tekero ungumu enone pali komu tendeko ungumunge pulumu pilku kondayo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yembomanga kangine ulsukundu lepalie kerena pupe olona suku pulimo meltene ⸤Pulu Yemo manda popo tonge aulkemo pipi silimo⸥ kalaro te manda naa mondolemo. Yembomanga konopune sukundu pepalie wendo olemo ulumene mindi yemboma kalaro mondolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Yembo komu-peo lemba yemboma iungumu mimi siku piliengi!” nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kanune maku toko moloringi yemboma Yesusini mundupe siye kolopa ulkena suku purumu kinie yu lombili andolimene yu walsiku pilkulie ningendo: “Aku ungu ikomonga pulumu nambolkanje? Ningu para sieni.” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesusini enondo nimbendo: “Kinié kepe naa pilkimiliye? Yembo tenga kangine ulsu lepalie sukundu pulimo melte yunge konopune naa pupe, olona suku pupe ulsu omba le-murune kamu pulimomonga yu kalaro manda naa mondolemo mele naa pilkimiliye?” nirimu. (Yesusini aku sipe nirimumunge “Langimene pali yemboma kalaro te naa mondolemo.” nimbendo nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","⸤“Kerena sukundu pulimo melemane aku sipe uluri naa telemo.” nimbelie⸥ yuni kelepa nimbendo: “Yembo tenga konopune sukundu pepalie wendo olemo kanu melemane yembo te ⸤Pulu Yemo popo tomba aulkemo pipi silimo⸥ kalaro te mondolemo. Ulu pulu kerime ou konopumuni pilkulie ⸤pe kamu telemelemonga⸥ “Konopune pepalie wendo olemo melemane kalaro mondolemo. ⸤We naa telemele.⸥” ⸤nikiru.⸥ Kanu melema i sipe: Konopumuni ulu kerime pilimele; wa ulu kerinele lupe lupema andoko telemele; wa nolemele; yemboma toko kondolemele; ambo ye pulime molo ye ambo lilime yembo lupema kinie ulu kerinele telemele; ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yembomanga mele nosilimelema ‘Na liembo.’ nilimele; ulu pulu keri lupe lupema telemele; kolo tolemele; yembomane kanokolie pipili kolemele ulume pipili naa kolko sumbi siku telemele; yembo lupema molemele mele kepe enonga melema yama mengo ‘Yu malo.’ konopu lemele; ‘Yemboma pipili kolko molko kenjengi!’ ningu ungu bulkundu nindilimele; ‘Na imbi ola molemo. Na pilipe konginjeli olandopa pelemo. Yembo lupema tondolo te naa pelemo.’ ningu kara pulimele; kekelepa toli ulume telemele; ulu pulu akume pilku telemele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aku ulu pulu kerime pali yembomanga konopune sukundu pepa wendo olemomane yemboma ⸤Pulu Yemonga kumbikerena punge aulkemo pipi silimo⸥ kalaro mondolemo. ⸤Ulsu lepa olona pulimo melemane uluri naa telemo⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kanu kinie Yesusi molorumu kolea ⸤Geneserete⸥ mundupe siye kolopa ⸤Juda yemboma moloringi kolea Gallilli disiriki ulsukundu⸥ kolea awili Taya kinie Saidonoselo lierimu koleana sukundu purumu. Akune purumu kinie yu ‘Yemboma na naa kanangi.’ nimbe ulke tenga sukundu pupe molorumu nalo yu omba molorumu mele yemboma pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yesusi yu omba molorumu akumu pilipelie ambo te yu molorumune sumbi sipe omba yunge kumbikerena manie molopa tamalu perimu. Kanu ambomo yu ⸤Pulu Yemonga⸥ Juda yembomanga talapena ulsukundu ambo te, kolea Siria poropinji sukundu kolea Ponisia disiriki yunge pulu koleamo. Ambomonga lemenunge konopune kuru te molopa ambolorumu kulu Yesusi molorumune omba manie molopa tamalu pepa yundu mawa tepalie nimbendo: “Nanga ambolamo kuru te konopune sukundu molemo kene yu ⸤kondo kolko⸥ kurumu toko makorou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","⸤Ambomo yu ambo lupe, Juda ambo te molo, nimbe kanopalie⸥ Yesusini ambomondo ⸤ungu iko te topalie⸥ nimbendo: “Ambolangoma langi ou nangi olo tepili. Enonga langime lipu owama simolo kinie kapola naa temba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ambomone yundu nimbendo: “Awilimu, sike nikinu nalo owamane kepe ambolangomanga langi pundu manie pulimoma liku nolemele kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kanu kinie Yesusini yundu nimbendo: “Ambomo, nu aku siku nikinumu papu nikinu. Aku siku nikinumunge kuru kanumu nunge ambolamonga konopune sukundu molopa omba wendo pumu kene nu ⸤konopu waengo siliku⸥ pu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","⸤Yesusini aku sipe nirimu pilipelie⸥ ambomo kelepa ulkendo pupe kanorumu kinie lemenu konopune kuru te naa molopili uru peli polona ola we molorumu kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesusi kolea awili Taya mundupe siye kolopa kolea awili Saidono sukundu omba pupe, ‘Kolea Awili Rureponga Talo’ niringi koleana sukundu omba pupe, nomu Gallilli kélona ⸤sukundu⸥ orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akune moloringi yembomane yu molorumune ye komu sipe ungu sumbi sipe naa nirimu ye te mengo ongo “⸤Yu konde pupili⸥ nunge kimuni ambolou.” ningu tondolo munduku mawa teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kanu kinie yembo kakapu teko moloringime mundupe siye kolopa “Oltolo molambili.” nimbe kanu yemo tenga memba pupelie nirimumuni, komuselonga ki sundu suku mundupe, lkambe topa yemonga alumbelumu kimuni ambolopalie, ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mulúne olando sipe kanopa, tondolo mundupe múlu lipe, Juda yembomanga ungu lepa yemondo nimbendo: “Epata!” nirimu. (Kanu ungumunge pulumu “Komumuni pilie!” nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aku nirimu kinie tamburumbu yemo komu-peo lepa yu ungu kapola pilipe, alumbelumu takele terimu kanumu pe nimbe umbu alumbelu angilierimu kinie yu ungu sumbi sipe nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kanu kinie Yesusini enondo tondolo mundupe nimbendo: “Nane iulu tekero mele anjo yembo telurindu kepe paa naa ningu siee!” nirimu. Nalo yu “Molo.” nimbe karaye terimu mele ta ningu anjo yemboma yuni terimu mele temane toko siliku mindi andoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","⸤Yu terimu mele kanoringi yemboma kinie, anjo temane toko siringi pilieringi yemboma kinie⸥ eno paa mini-wale munduku suruningulie ningendo: “Apa! Yu telemo ulume peangama mindi telemo. “Komu silimoma ungu pilku, ungu naa nilimelema ungu ningu, teaa.” nilimo kinie kepe ungume pilku ungume ningu telemele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Walse Yesusi molorumune yembo awisili altoko ongo liku maku toko moloringi. Moloringi koleana nonge langi te naa lierimu kulu Yesusini yu lombili andolimendo “Na moliona waa.” nimbelie enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“I yembo maku toko molemelema na kondo tekemo. Wale yepoko na-kinie molongi, pe kinié ga nonge te naa lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mare aulke sulune oringimunge nane “Eno engele tepa pepili ulkendo paa.” nilkenje eno aulkena kimbu ki pange-mange tepa, topa ne-munde ya-munde telka.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aku nirimu kinie pilkulie yu lombili andolimene yundu topondoko ningendo: “⸤Sike nikinu nalo⸥ ikolea ku lieline molemolo. Iyemboma manda nonge mele pillawa kaloli tena lembana lipu simoloye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesusini enondo “Pillawa kaloli nambeko nosikimiliye?” nimbe walserimu kinie enone “Yepoko pakera nosikimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kanu kinie yuni maku toko moloringi yembomando “Manie molaa.” nimbelie, pillawa kaloli yepoko pakera lipe ⸤Pulu Yemo kinie⸥ “Ange.” nimbe, akume pike lepa yu lombili andolimendo “Yemboma moke teko siee.” nimbe eno sirimu. Nirimu kanu mele teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eno oma kaloli kanga pokore kepe noseringila, akume lipe ⸤Pulu Yemo kinie⸥ “Angela.” nimbelie yu lombili andolimendo “I me yemboma moke teko siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yemboma ⸤langime⸥ noringi kinie olo terimu. Pe langi kakena lierimume lombili andolimene liku wale basiketemanga lakilieringi, wale awili yepoko pakera pekelierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ye po tausinini aku langime noringi. Kanu kinie Yesusini maku toko moloringi yembomando “Ulkendo paa.” nimbelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yu lombili andolime kinie yu kinie eno nona andoli sipine suku puku, ⸤nomune nekendo⸥ kolea Dallamanuta puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Akune puringi kinie Parisi yema Yesusi molorumune ongo, ‘Yuni nambe-embanje? Kanamili.’ ningu yu manda manjiku mawa tekolie ningendo: “⸤Ungu Mane Silimu,⸥ ‘Nu sike Pulu Yemone ‘Kongono tendani.’ nimbe ya mana lipe mundorumunje kanamili.’ ningu mulu koleana molemo ⸤Pulu⸥ Yemone mindi manda ulu ⸤tondolo⸥ telemo mele te tei.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","⸤Aku siku walseringi kinie pilipe keri pilipelie Yesusi⸥ yunge konopune paa umbune terimu-ne múlu awili tepa lipelie nimbendo: “Kinié mana molemele yembomane “Pulu Yemone mindi ulu tondoloma manda telemo mele kanamili tei.” ningu na nambemune mawa telemeleye? ⸤Na molio mele nambemune “Sike.” we naa ningu tondolo munduku pilimeleye?⸥ Nane eno sike nimbu sikiru: ⸤Na Pulu Yemo kinie tapu topo kongono telembolo mele⸥ lipe ora simbe kanonge ulu tondolo te, kinié mana molemele yemboma-kinie wendo naa ombá.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aku sipe nimbelie nirimumuni, eno mundupe siye kolopa sipine suku kelepa pupelie nomune nekendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","⸤Kanu kinie eno nomune nekendo pungendo Yesusi lombili andoli yema⸥ pillawa kaloli komu sindiku naa mengo puringi. Pillawa kaloli telu mindi sipine suku lierimu, te pea molo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kanu kinie Yesusini enondo liepi-liepi topa ⸤ungu iko topalie⸥ nimbendo: “Paa mimi siku kanaa! Parisi yema kinie ⸤ye nomi kingi⸥ Erote yunge yema kinie enone pillawa akoli mele isi nosilimelemo kanoko kondaa!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aku sipe nirimu kinie pilkulie yu lombili andoli yemane enono kerepale ningulie ningendo: “Olio pillawa kaloli ⸤nomolo⸥ mare naa lipu membo omulumunge aku sipe nikimunje.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aku siku niringi mele pilipelie Yesusini enondo nimbendo: “Enone “Pillawa kaloli naa memulu.” ningu nambemune kerepale nikimiliye? Eno kinié kepe naa kanoko, mimi siku naa pilkimiliye? Na tondolo te perimu-ne pillawa kalolime-kinie ulu tondolo te terindu mele eno naa pilieringiye? Eno konopu naa pepili molemelemonga nane nikiru mele ungu pulumu naa pilkimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Eno mongo angilimo nalo melema naa kanokomeleye? Komu angilimo nalo ungume naa pilkimiliye? Pillawa kaloli kise pakera lipu pike lepo ye pape tausini moke tepo sirindu kanumu eno komu sindikimiliye? ⸤Nongo pora siringi kinie⸥ langi kakena lierimume liku wale basikete nambeko toko peke siringiye?” nirimu kinie ⸤yu lombili andolimene⸥ yundu topondoko “Engaki-rurepo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","⸤Yuni enondo kelepa nimbendo:⸥ “Pe pillawa kaloli yepoko pakera lipu pike lepo ⸤yembo⸥ po tausini moke tepo sirindu kinie ⸤nongo pora siringi kinie⸥ wale basikete awili nambeko langi kakena lierimume toko peko siringiye?” nimbe walserimu kinie enone yundu topondoko “Yepoko pakera.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yuni enondo ⸤kelepa⸥ nimbendo: “Enone kinié kepe mimi siku naa pilkimiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesusi kinie, yu lombili andolime kinie, eno Besaida taonona puringi kinie mongo keri lierimu ye te Yesusi molorumune mengo ongo mawa tekolie ningendo: “Nuni iyemo kini ambolou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aku niringi kinie Yesusini mongo keri lierimu yemo ki ambolopa taono ulsukundu meli pupelie yunge mongoselonga lkambe topa kandopa kimuni ambolopalie nimbendo: “Nu kinié melte kanokono molo moloye?” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","yemone olando sipe kanopalie nimbendo: “Na kinié yembo mare, eno unjo melema ongo pukumili kanokoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesusini yunge mongoselonga kelepa ambolorumu kinie yemo yu mongo makilipe melema pali mongoselone sumbi sipe kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesusini yemondo “Ulkendo pu.” nimbelie nimbendo: “Nu kelko ulkendo punindu ne kolea ⸤molopo wendo ombulu⸥ akune ⸤kelko yando⸥ naa pu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesusi kinie yu lombili andolime kinie puku kolea awili Sisaria Pillipai nondopa lierimu kolea kangamanga punge puringi. Akune punge puringi kinie Yesusini yu lombili andolimendo walsipelie nimbendo: “Yembomane naimbi leko nawe nilimeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Enone yundu ningendo: “Marene “Nu No Lindeli Jono ⸤kolorumu kinié kelepa lomboropa ola molemo⸥.” ningu pilku, marene “Nu ⸤Pulu Yemone ou konde molopili olando lsimu ye⸥ Illainja kelepa omba molemo.” ningu pilku, marene “Nu Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye te ⸤oukolorumu kinié lomboropa ola molemo.⸥” ningu pilimele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aku niringi pilipelie Yesusini enondo walsipe pilipelie nimbendo: “⸤We yembomane aku siku nilimele⸥ nalo eno enono na nawe nilimeleye?” nirimu. Pitane topondopa nimbendo: “Nu Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ ou nimbe mako torumu ye nomi Kirasimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","⸤Pitane aku nirimu pilipelie⸥ Yesusini enondo tondolo mundupe nimbendo: “Na molio mele ⸤Pitane kinié nikimumu⸥ enone anjo yembo telurindu kepe ⸤isili ou⸥ paa naa ningu siee!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kanu kinie Yesusi yu lombili andolimene yundu ⸤“Pulu Yemone olio “Nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu ye nomi Kirasimu nu.” ningu, ningu para siringi kinie pilipelie⸥ yuni yu-kinie wendo ombá mele pulu polopa eno mane sipelie nimbendo: “Manie Omba Mana Ye A Lierimu Yemo mindili awisili nombá. Juda yemboma nokolemele tapu yema kinie, Pulu Yemo popo tondoli ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane sili yema kinie, enone ⸤ningendo: “Yu Pulu Yemone naa lipe mundorumu. Yu Pulu Yemonga Malo naa molemo.” ningu⸥ yu liku bulu siku yu toko kondonge. Yu toko kondonge kolomba kinie wale talo omba pumbe kinie yepoko sipemonga yu lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesusi yu-kinie wendo ombá mele aku sipe sumbi sipe nimbe para sirimu kinie pilipelie Pitane yu anjo lipe memba pupelie ⸤Yesusi yuni “Na toko kondonge.” nirimumunge⸥ yu pulu polopa iri torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nalo ⸤yuni kurumenga nomi Setenene ungu umbu tondorumu mele pilipelie nirimu kulu pilipelie⸥ Yesusini topele topa yu lombili andolime kanopalie Pita iri topalie yundu nimbendo: “Setene, nu anjo pa! Nu Pulu Yemone konopu lemo mele naa leno. Yembomane konopu lemele mele mindi leno kene anjo pu!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kanu kinie yembo akune liku maku toko moloringime pali kinie yu lombili andolime pea “Na moliona waa.” nimbelie enondo nimbendo: “Yembo tene ‘Yu lombili pambo.’ nimbelie yuni yunge konopumuni pilimo melemanga ‘Topo manie mundembo.’ nimbe yemboma unjo perana angilku mindili nongo kolemele mele yuni unjo pera mele gomo lembando ‘Na yu lombili pumbondo mindili nondu liemo papula; kolondu liemo papula.’ nimbelie na lombili opili. We naa opili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yembo tene yunge mana molopa naa kololi ulu pulumu ambolomba temba kinie yu kolopalie sike molopa kenjipe mindi pumbe. Nalo yembo te na konopu mondopa nanga yembomo molopa, ‘Yemboma temane peangamo piliengi!’ nimbe eno nimbe sipe molomba kinie yu kolopalie yu konde molopa kondopa mindi puli ulu pulumu sike kanopa limbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","⸤Akumu nambemune nikiruye?⸥ Yembo tene mana melema pali yuyu lipe nosipelie yu mini pali Pulu Yemo naa molomba koleana pupe mindili nomba molopa kenjilkenje kanu melemane kanu yembomo nambepa lipe tapondolkanje? Lipe naa tapondolkamo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yembo tene ‘Na mini pali konde molopo kondopo mindi pambo.’ nimbelie yu nambolka meltene mini pali konde molopa kondopa mindi puli ulu pulumu topo topa lilkeye? Meltene manda topo topa naa limbe. ");
INSERT INTO ubu_kala_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Nanga yembo mare ulu pulu keri teko Pulu Yemo munduku siye kolko mele lupema imbi liku ola mundunduku molemele yemboma-kinie molkolie pipili kolko ningendo: “Olio Yesusinge ungume pilipu lipu, yu lombili andopo molemolo mele we yembomane naa piliengi!” ningulie na kiyengo ningu lombili andolemele yemboma, eno-kinie ulu te pe wendo ombá mele nimbu siembo: Manie Omba Mana Ye A Lierimu Yemo pe Lapanga tondolo patelimu kinie ⸤mulu koleana⸥ angello kake telime kinie ⸤manie⸥ ombá temba kinie, kanu we yemboma molongena yunge yemboma mona molongendo we yemboma molongena kanokolie, yu ou naa opili ‘Olio yunge yemboma molemolo mele we yembomane naa piliengi!’ ningu pipili kolko lopi teko molonge yemboma yuni lipe wekendo kanopa, “Na moliona naa waa!” nimbéla.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesusi yuni enondo ungu te pea nimbendo: “Nane enondo paa sike nimbu sikirumu: Eno ya angilkimilimenga mare ou kolou naa kolangi Pulu Yemo ye nomi kingimu omba, enge nimbe molopa, melema kinie yemboma kinie pali nokomba ombá kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesusini ⸤yu lombili andolimendo aku sipe nimbe sirimu kinie⸥ pe koro te omba purumu kinie Pita keme Jemisi keme Jono keme eno lipe meli pupe mulú paa olandopa polorumu tenga ola purumu. ‘Olio oliolio mindi molamili.’ nimbe eno akune lipe memba purumu. Akune puringi kinie eno kanoko molangi yunge kangimu alowa tepa, ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","yu pakorumu mulumbalema ena tondolo topa mongo paa takele telemo mele aku sipe paa kake terimu. Ya mana yembo tene wale pakoli te sopone kulumiye topa kake tendemba mele kapola molo. ⸤Yunge mulumbalema kake terimu mele paa olandopa.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yu aku sipe molopili, ⸤Juda yembomanga koronga-ou moloringili ye awili talo,⸥ Illainja kinie Mosisiselo ongolo Yesusi kinie ungu ningulu mona angilieringili kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kanu kinie Pitane Yesusindu nimbendo: “Rapai, olio ya molopamolo peanga lepamo. Olione ulke takaye yepoko takondamili. Te nunge, te Mosisinge, te Illainjanga takondamili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Nalo aku nirimumu eno pipilini paa koloringi kulu yuni nimbé mele naa pilipe ungu te walu nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kanu kinie kupe te omba eno aki torumu kinie kupena suku ungu te wendo ombalie nimbendo: “I yemo nanga konopu mondolio Malomo. Yuni ungu nimbéma pilku liengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe walsikele, eno mongo male-male teko kanokolie yeselo altoko naa kanoringi. Yesusi yu mindi eno-kinie molorumu kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mulu polorumumunge manie onge oringi kinie Yesusini eno mane sipelie nimbendo: “Enone kinié kanongi mele isili-ou yembo teluri kepe ningu naa siengi. Pe mindi, Manie Omba Mana Ye A Lierimu Yemo kolopalie altopa lomboropa ola molomba kinie temanemo toko anjo siengi. Ou molo!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aku nirimu kinie eno yunge ungumu pilku liku ou anjo naa niringi nalo “yu “kolopolie altopo lomboropo ola molombo.” nikimu ungu kanumunge pulumu nambolka ulurindu nikimunje?” ningu eno enono kerepale niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kanu kinie yu lombili andolimene ⸤yu sike molorumu mele ningu kanokolie⸥ yundu walsiku pilkulie ningendo: “⸤Pulu Yemone ‘olio nokopa kondopa lipe tapondomba.’ nimbe mako torumu ye nomi Kirasimu nuliemo⸥ Pulu Yemonga ungu manemanga pulume pilku mane silimele yemane “I llainja ⸤kelepa⸥ kumbi lepa ombá. ⸤Ye nomi Kirasimu pe akilipe ombá.⸥” nilimele akumu nambemune nilimeleye? ⸤Illainja kelepa naa opili nu koronga orunu moleno kanumu.⸥” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesusini topondopa nimbendo: “ “I llainja ⸤kelepa⸥ kumbi lepa ombalie melema pali tepa mimi temba.” nilimele kanumu sike nilimele. Aku liemo Manie Omba Mana Ye A Lierimu Yemo kanoko keri kanoko mindili liku singe mele ⸤Pulu Yemonga⸥ bokune nambemune imbi toringi molemoye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nalo ⸤akumunge ungu te pea nimbu sikiru.⸥ Pilieme! Illainja koronga orumu. Yu orumu kinie ⸤kanu yemane yu kanoko imbi naa siku⸥ ‘Yu we-yere.’ konopu lekolie ‘yu-kinie temolo.’ ningu pilieringi ulume pali teringi. Yu-kinie aku siku tenge mele ou bokune imbi toringi molemola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","⸤Yesusi kinie yu lombili andoli ye yepoko kinie⸥ eno yu lombili andoli ye wema moloringine yando ongo, yembo paa awisili akune kakapu teko maku toko moloringi kanoringi. Pulu Yemonga ungu manemanga pulume pilku mane siringi yemane Yesusi lombili andoli ye wema kinie ungu ningu, ungu mare walsiku pilku moloringi kanoringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yesusi orumu kinie kanokolie kanu maku toko moloringi yemboma suru awili teko ningu yu orumune lkisiku ongo yundu “⸤Awilimu,⸥ nu okonoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kanu kinie yuni enondo “Enone ungu nambolka ungumu kerepale nikimiliye?” nimbe walserimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","kanu maku toko moloringi yembomanga ye tene topondopa yundu nimbendo: “Ungu Mane Silimu, nanga kangomo, kuru te yunge konopune molemomonga ungu manda naa nilimo-na nu molonu ⸤konopu lepolie⸥ membo ondu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kurumuni kangomo wale marenga ambolopalie yu topa manie mundulimo kinie yu kuru kopari topa, apoupu memba, ungú kilkiyé lipe telemo. Nu lombili andolimendo aku temanemo topo sipu enone kanu kurumu ‘Makorangi.’ nimbu mawa tendu nalo eno manda naa tengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aku nirimu kinie pilipelie Yesusini yemboma ⸤iri topalie⸥ nimbendo: “Kinié molemele yemboma eno ⸤‘Pulu Yemone ulume sike manda temba.’ ningu⸥ tondolo munduku naa pilku molemele yemboma, na eno-kinie molopo, wale nambepo mane sipu ulu mare lipu ora simbokinie mimi siku pilingeye? ⸤Na eno-kinie siye tekemo.⸥” nimbelie “Na moliona kangomo mengo waa.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","kangomo yu molorumune mengo oringi. Mengo oringi kinie ⸤kangomonga konopune molorumu⸥ kurumuni Yesusi kanopalie kangomo topa manie mundorumu kinie kangomo kimbu kime peue mundupe apoupu merimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aku terimu kinie kanopalie Yesusini kangomonga lapa walsipelie nimbendo: “Kangomo ikurumu tewale pulu polorumuye?” nirimu. Lapane nimbendo: “Yu kokele anumuni merimu kinie aku sipe terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wale awisili yu kopari topa tepena topa mundupe, nona topa mundupe telemo kene nuni manda liku tapondonu liemo olio kondo kolko liku tapondou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesusini nimbendo: “Nuni nambemune “Manda liku tapondoni molo moloye?” nikinuye? ‘Nane nu manda lipe tapondomba.’ ningu tondolo munduku pilienu liemo ulume pali sike wendo ombá.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesusini aku nirimu kinie pilipelie kangomonga lapane tondolo ru nimbelie nimbendo: “Nane ‘sike nuni liku tapondoni.’ nimbu pilkiru nalo ‘Sike.’ nimbu pilkiru ungumu tondolo mundupu ambolombo mele manda naa tekemo kene ‘Sike.’ nimbu pilkiru mele ‘tondolo pupili.’ ningu liku tapondani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","⸤Kanu kinie⸥ yemboma lkisiku sukundu sukundu kanonge onge oringi kanopalie Yesusini kurumu iri topalie nimbendo: “Kere pipi siku, komu pipi siku teleno kurumu, kangomonga konopune ongo wendo puku, altoko paa naa ongo molani. Kamu pu!” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","kurumuni kangomo tondolo topa manie mundorumu kinie yu kimbu kime peue mundorumu kinie kurumu kalle nimbe yunge konopune wendo orumu. Kanu kinie kangomo yu kolopa lierimu none terimu kanokolie yembo awisilini “Yu kolomu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nalo Yesusini yunge kimu ambolopalie yu ola lsimu kinie ola angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","⸤Kanu kinie Yesusini kurumu topa makoropa pora sipelie⸥ ulkena sukundu ⸤yu lombili andolime kinie⸥ purumu kinie lombili andolime enone Yesusi pea enono molkolie yu walsiku pilkulie ningendo: “Kuru akumu olione nambemune manda naa makoromuluye?” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesusini topondopa nimbendo: “I ulumu mele temolondo Pulu Yemo kinie ungu nimbu mawa temolomone mindi manda temolo. We manda naa temolomo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","⸤Yesusi kinie yu lombili andolime kinie⸥ eno aku koleamo munduku siye kolko ⸤yemboma moloringi koleama naa puku⸥ kolea Gallilli disiriki sumbi siku ongo punge puringi. Akune punge puringi kinie yu lombili andolime ungu mane silipe purumu kulu ‘Na lombili andolime ungu mane sikiru mele we yembomane naa piliengi kene olio we yembomane naa kanangi, pea naa pamili.’ nimbe yu kinie yu lombili andolime kinie enono kiyengo ningu puringi. ⸤Yu-kinie pe wendo ombá mele⸥ yuni eno ungu mane silipe purumu mele i sipe: “Manie Omba Mana Ye A Lierimu Yemo ka sikulie ⸤yu tonge⸥ yema anjo singe kinie enone yu toko kondonge. Kolopalie wale yepoko sipemonga yu lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nalo yuni nirimu ungumu pilku sundukulie ‘Iungumunge pulumu nambolkarenje, naa pilkimulu.’ niringi nalo “Nambolka ningu nikinuye?” ningu walsiku pilingendo pipili kolko naa walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","⸤Ongolie⸥ kamu Kapeniame taonona suku oringi. Molonge ulkena suku puku moloringi kinie Yesusini yu lombili andolime walsipe pilipelie nimbendo: “Eno aulkena ungu nambolkarenga kerepale niliku ongiye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nalo enone ‘Olionga ye nawe paa olandopa molemoye?’ ningu kerepale ningu kere-kuru lsingi kulu Yesusindu eno niringi mele ningu para singemonga pipili kolkolie molko duma lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanu kinie Yesusi yu manie molopalie yu lombili andoli rurepondo “Na moliona waa.” nimbelie nimbendo: “Yembo tene ‘Yembomanga awilimu molambo.’ nimbelie yu we yembomo molopa yembomanga kendemandemo molopili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aku nimbelie ambolango kanga te lipe ⸤yu lombili andolime⸥ angilieringine mondopalie nirimumuni, aku ambolangomo yuni kangulupe enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yembo tene ‘Na Awilimunge yembomo molio.’ nimbe i ambolangomo mele lipe tapondomba kinie kanu yembomone aku tembamonga na lipe tapondombala. Na lipe tapondomba yembomone na manjipe naa lipe tapondomba. Ambolangomo lipe tapondombamonga kanu yembomo yuni na lipe mundorumu yemo lipe tapondombala.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","⸤Yesusi lombili andoli ye⸥ Jonone Yesusindu nimbendo: “Ungu Mane Silimu, olio kanomulu, ye tene nunge imbimu lepa kuru mare yembomanga konopune molongime “Ongo wendo paa!” nimbe topa makoropa molomu kanomulu. Kanopolie yu olio pea tapu topo naa molemolo kene yundu “Nu aku siku naa tei!” nimulu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aku nirimu kinie pilipelie Yesusini yundu ⸤kanu yemone terimu ulumundu⸥ nimbendo: “Yembo tene nanga imbi lepa ulu tondolo te tepalie yuni kelepa nondopa nando ungu te manda nimbe naa kenjimbe kene enone yundu “Molo!” naa niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yembo te olio kinie opa-puluemo naa molemomo olionga opa-lkerayemo molemo kanumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Nane enondo paa sike nimbu sikirumu: Eno no waka lemba kinie yembo tene ‘Eno Kirasinge yemboma molemele kene no te nangi kolopo siembo.’ nimbe eno te kolopa simu liemo, Kirasinge kongono tendenge yemboma yuni mele kalomba kinie kanu yembomo kepe komu naa sindipe yu konopu lipe mundupe mele kalombala.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yembo tene i ambolangomonga ⸤mele yembo⸥ te na ‘Sike’ nimbe tondolo mundupe pilimo ambolangomo ‘Ulu kerime tepili.’ nimbe kondi tombamonga kanu ambolangomo tondolo mundupe pilimo mele mundupe siye kolopa bulu simu liemo ⸤ambolangomo ou kondi naa topili⸥ yu kou paa awili te moko toko nomine lendeko ‘Yu kamu kolo-popili.’ ningu paka toko nomune paa maniekondo mundulimelanje paa papu. Aku siku toko mundulimela kinie yu kolopalie pe yu Pulu Yemonga ambolango tendo ‘Ulu kerime tepili.’ nimbe kondi manda naa tolka. Nalo yu aku siku nomune naa mundulimela kinie yu yemboma kondi tombamonga Pulu Yemone yu mongo awili silke kene enone yu nomune papu paka toko mundulimela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Nunge kiselone ulu pulu keri te temu liemo aku kiselo kari leko lteani. Nu konde mololiku mindi puni koleana kiselo naa angiliepili puni kinie peangamo. Nunge ki talo we angiliepili nu tepe kolea, (‘akune Pulu Yemo teko kenjilimele yembomanga korowama kolou naa kolopa nolipe mindi pulimo, tepe toko kumundou naa kumundulimele kolea’) akune suku toko mundunge kinie kerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Molo nunge kimbuselone ulu pulu keri te temu liemo aku kimbuselo kari leko lteani. Nu konde mololiku mindi puni koleana kimbuselo naa angiliepili puni kinie peangamo. Nunge kimbu talo we angiliepili nu tepe kolea, (‘akune Pulu Yemo teko kenjilimele yembomanga korowama kolou naa kolopa nolipe mindi pulimo, tepe toko kumundou naa kumundulimele kolea’) akune suku toko mundunge kinie kerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","“Molo nunge mongoselone melte kanokolie konopuni ‘liembo.’ ningu pilku ulu pulu keri te tenu liemo aku mongoselo akuku lteani. Nu Pulu Yemo ye nomi kingimu molopa nokolemo koleana mongoselo naa angiliepili puni kinie peangamo. Mongo talo we angiliepili nu tepe kolea, ‘akune Pulu Yemo teko kenjilimele yembomanga korowama kolou naa kolopa nolipe mindi pulimo, tepe toko kumundou naa kumundulimele kolea’ akune suku toko mundunge kinie kerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Yembomane Pulu Yemo popo toko kalemele melema singendo ‘Pulu Yemone kanopalie ‘Langi kake telime.’ nimbe kanopili.’ ningu api kusa mundukulie silimele aku siku mele yemboma molongena tepemo, api kusa mele, yemboma kinie pali wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Api kusa yu mele peangamo nalo yu songo naa temba kinie ‘Yu kelepa songo tepili.’ ningu ulu te manda telemeleye? ⸤Api kusa langimenga mundulimele kinie songo telemo aku siku⸥ eno api kusa mele molko yemboma kinie anjo yando konopu telune pupili taka liku molangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kanu kinie Yesusi molorumu koleamo mundupe siye kolopa kolea Judia disiriki pupe no Jodane lumbilipe nekendo purumu. Kanu kinie altoko yembo awisili yu molorumune ongo maku toringi kinie alieli aku teringi kinie yuni yemboma ungu mane sirimu mele maku toringime altopa mane sirimula. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi ye mare yu molorumune ongo ‘Yu nambolka nimbénje? Nimbe kenjimbenje manda manjipu piliemili.’ ningu yu walsiku pilkulie ningendo: “Ye tene yu yuyu pilipelie yunge ambomo “Kamu pu.” nimbé kinie kapola temba molo aku temba kinie ungu mane te pulue tombaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yuni anjo topondopa nimbendo: “Mosisini aku ulumundu ungu mane sipe nambolka nirimuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Enone ningendo: “Mosisini nimbendo: “Ye tene yunge ambomondo ‘Kamu pupili.’ nimbe makorombando ambomo “Kamu pu.” nimbé mele pepá tenga topa ambomo sipelie yundu “Kamu pu.” nimbe aku tepili.” nirimu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesusini nimbendo: “Mosisini sike aku sipe bokune torumu nalo eno kara puku Pulu Yemone ambo yeselo kapola kapola molongele mele ungu mane sirimumu liku su siringi naa pilieringi kulu yuni “Aku teangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nalo ou pulu pulu Pulu Yemone melema tepalie yuni yembo tembando yemo kinie ambomo kinie terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Aku sipe terimumunge ye tene ambo te lipelie yunge anumu lapaselo mundupe siye kolopa yunge ambomo kinie elolo telune tapu toko peko, ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kangi telumu mele ⸤molkolo elonga konopu telune pupili⸥ molongele.’ Ye te ambo te limo kinie kangi telumu mele molembele-na elo altoko talo mele naa molembele, elo yembo telumu mele molembele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yembo telumu molembele kene Pulu Yemone ambo ye talo ‘Telumu molangili.’ nilimo ambo yeselo yembo tene liku lupe lupe naa mundengi. Aku tengi liemo kapola naa temba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Altoko ulkena suku puku moloringi kinie yu lombili andolimene Yesusi yundu aku ungumunge pulumu walsiku pilieringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","yuni enondo topondopa nimbendo: “Ye tene yunge ou limo ambomo makoropa “Kamu pu.” nimbelie kelepa ambo te limo kinie aku yemone wa ulu kerinele tepa, ou limo ambomo tepa kenjilimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Molo ambo te yunge ou pulimo yemo mundupe siye kolopa wendo pupe ye te pulimo kinie aku ambomone wa ulu kerinele telemola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kanu kinie yembomane enonga ambolangoma ‘Yesusi yunge kimuni ambolopili.’ ningu yu molorumune mengo oringi. Nalo yu lombili andolimene iri toko ⸤“Naa mengo waa!”⸥ niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","⸤“Molo.” niringi kinie⸥ kanopalie Yesusini konopu keri panjipe ⸤yu lombili andolime⸥ enondo nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yembo talape akumu i ambolangoma mele molemele yemboma enonga yembo talapemo kene enone i ambolangoma na moliona wangi pipi siku “Molo.” naa niee!” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Nane enondo paa sike nimbu sikirumu: Ambolangomane ‘Pulu Yemo olionga ye nomi kingimu molopili.’ ningu molemele mele aku siku naa nilimele yemboma yunge koleana suku paa naa punge, molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aku nimbelie yuni ambolangoma kangulupe yunge kimuni eno telu telu nimbe pengena ambolopa eno tepa kondombando “Pulu Yemone “Eno molko kondangi.” nipili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kanu kinie Yesusi ola angilipe kolea marenga pumbe purumu kinie ye te yu pumbe purumune lkisipe omba yunge kumbikerena koporongo langopa yundu walsipe pilipelie nimbendo: “Ungu Mane Sili Peangamo, nanambolka uluri tembo kinie na konde molopa kondopa mindi puli ulu pulumu limboye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesusini yundu nimbendo: “Nuni na nambemune “Peangamo” nikinuye? Yembo peanga te molo. Pulu Yemo mindi peangamo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","⸤Aku nimbelie yemone walserimumunge topondopa nimbendo:⸥ “Nu ⸤Pulu Yemonga⸥ ungu manema ⸤Mosisini yando nimbe sirimume⸥ pilino. Yuni nimbendo: “Yembo toko naa kondangi.” nimbe, “Ambo ye pulime molo ye ambo lilime yembo lupema kinie wa ulu kerinele naa teangi.” nimbe, “Melema wa naa liengi.” nimbe, “Yembomanga kote kolo toko naa tendangi.” nimbe, “Yembomanga melema kolo toko we naa liengi.” nimbe, “Aminieli lanieli kinie teko kondoko, ungu ninge mele pilku liku teko molangi.” nimbe, ungu mane akume sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aku nirimu kinie pilipelie kanu yemone nimbendo: “Ungu Mane Silimu, na kangomo molopolie aku ungu manema pali pilipu lipu tepo molorundu mele yandopa kinié kepe tepo molioko.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesusini yu neme-neme nimbe kanopa konopu mondopalie yundu nimbendo: “Papu teleno nalo ulu telu mindi naa teleno. Nu puku nunge mele nosilinoma pali kou mone li-pukulie, kou mone linime yembo koropama moke teko sikulie na lombili ou.” nirimu. “Nunge ⸤mana⸥ melema aku teni kinie mulu koleana nunge mele kande kandema lemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kanu yemo mele paa kande kandema noserimu kulu Yesusini yundu aku nirimu kinie pilipelie yu kumbikere tepa konopu keri panjilipe anjo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","⸤Aku terimu kulu kanopalie⸥ Yesusi topele topa yunge lombili andolimendo nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungendo yembo kamakoma paa mindili siku suku punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aku ungumu nirimu ⸤kinie pilkulie⸥ yu lombili andolimene mini-wale mundoringi. Nalo Yesusini altopa enondo nimbendo: “Kangoma, Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungendo yemboma paa mindili siku punge. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kongi kemele ⸤kongi paa awili te nalo⸥ kale suru toline suku pumbendo mindili kanga mele sipelie pumbe. Nalo yembo kamakoma Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungendo mindili paa awili mele siku punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","⸤Aku nirimu kinie pilkulie⸥ yu lombili andolime paa mini-wale munduku suru ningu anjo yando ungu-mele tekolie ningendo: “Aku liemo mindili nolemela aulkena nawe manda wendo pupe, molopo kondomolo aulkena pumbeye? Te molonje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesusini eno neme-neme nimbe kanopalie nimbendo: “Sike yemboma enono manda molo, nalo Pulu Yemone manda tendemba. Pulu Yemo yuni ulume pali kapola telemo. Ulu te yuni manda naa temba te molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yuni aku nirimu kinie pilipelie Pitane yundu nimbendo: “⸤Pe olio-kinie nambolka uluri wendo ombáye?⸥ Olio olionga melema pali mundupu siye kolopo nu lombili purumulu mele pulimolo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesusini nimbendo: “Nane enondo paa sike nimbu sikirumu: Yembo na konopu mondoko nanga kongono tendeko temane peangamo toko siliku andongendo enonga ulkema, angenupili, kemulupili, anupili, lapali, ambolangoma, koleama, akume munduku siye koloringi yemboma pali ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya mana paa olandopa mele awisili likulie, pe punge koleana konde molko kondoko mindi puli ulu pulumu lingela. Ya mana ulkema, angenupili, kemulupili, anupili, ambolangoma, koleama kinie, akume pali awisili olandopa lingela; ⸤na konopu naa mondonge yembomane⸥ eno mindili singela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nalo kinié awili molemele yembomanga awisili pe ⸤Pulu Yemo ye nomi kingimu molopa nokomba koleana⸥ yembo koropama molonge; kinié koropa pupili molemele yemboma pe yembo awilime molonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kanu kinie ⸤Yesusi kinie yu lombili andolime kinie⸥ eno kolea awili Jerusalleme punge puringi. Yesusi kumbi lierimune lombili andolime paa konopu awisili liku munduliku yu lombili puringi. We yembo akiliku lombili oringime kepe mini-wale munduku pipili kololiku puringi. Yesusini ⸤yu lombili andoli⸥ ye engaki rurepo ‘na kinie eno kinie oliolio molamili.’ nimbe eno lipe anjo memba pupelie yu-kinie wendo ombá mele altopa pulu polopa nimbe sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Pilieme. Olio Jerusalleme pumolo pukumulu. Akune pumolo kinie Manie Omba Mana Ye A Lierimu Yemo ye tene ‘Tangi.’ nimbe Pulu Yemo popo tondoli ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane sili yema kinie, lipe simbe, enone yu kote tendeko ‘Yu kolopili tangi.’ ningulie Juda ye naa molemele yema liku singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kanu kinie kanu yemane yu ungu taka tondoko yunge kumbikerena olkambe toko yu ka pulsene toko yu toko kondonge. Yu toko kondonge kinie wale yepoko sipemonga lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kanu kinie Seperi malo Jemisi kinie Jonoselo elo Yesusi molorumune ongololie ningelendo: “Ungu Mane Silimu, nuni ‘Olto ulu te teani.’ nimbu mawa tembolo okombolo.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yuni elondo nimbendo: “Nambolka uluri ‘nane elo-kinie tendambo.’ ningu nikimbiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Elone topondoko ningelendo: “Nu pe nunge kolea tondolo pateline ⸤ye nomi kingimu molkolie ninimuni, ‘olto nu-kinie pea ye nomime molamili.’ ningu⸥ ‘olto te nunge ki umbukundu mondoko te nunge ki tarokondo mondani.’ nimbu mawa tekembolo.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesusini elondo nimbendo: “Mawa tekembele mele elo pilku naa kondokombele. Na no mingine no nombomo elo manda nongeleye? Molo na no limbomo elo manda lingeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Elone yundu topondoko ningelendo: “Manda tembolo.” niringili. Yuni elondo nimbendo: “Na no mingine no nombomo pe elo sike nongelela. No limbomo pe sike lingelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nalo nane elo “Nanga wanguselonga ongo molangili.” nimbomo kapola naa temba. ⸤Pulu Yemone yuyu⸥ akune molongeleselo koronga mako torumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jemisi Jonoselone ⸤‘Yesusinge wanguselonga molambili.’⸥ ningu mawa teringili mele pilkulie lombili andoli rureponga talo wemane elo-kinie konopu keri panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanu kinie Yesusini eno “Waa.” nimbelie nirimumuni, enondo nimbendo: “Olio Juda yembomanga ulsu molemele yembo talapemanga ye nomime enonga yemboma tondolo munduku nokoko kongono enge nilime alieli silimele. Ye imbi ola molemo yema enonga yemboma ‘Mindili nangi.’ ningu nokolemele. ⸤Yembomane enonga ye nomimenga ungume liku su singe aulke te naa lemo mele⸥ eno pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nalo ⸤we yembomanga ye nomimene enonga yemboma tondolo munduku nokolemele mele na lombili andoli yema⸥ eno enono aku siku anjo yando naa teangi. Enonga ye te ‘Na imbi olandopa molopili. Na ye awilimu molambo.’ nimbé yemo enonga kongono tendeli yemo molopili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","‘Na enonga ye nomimu molopo eno nokambo.’ nimbé yemo enonga pali kongono kendemande tendeli yemo molopili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aku sipela, Manie Omba Mana Ye A Lierimu Yemo kepe ‘Yembomanga ye awilimu molopo eno nokambo. Enone nanga kongono tendeli kendemande yemboma molangi.’ nimbe naa orumu. ‘Yembomanga kongono tendeli kendemande yemo molopo eno lipu tapondopo, ulu pulu kerimene eno ka sipe nokolemo mele naa tepili kapola molangi kene na yembo awisilinge nimbu pundu tondopo nanga kangimu sipu, kolo wangopo kolondambo.’ nimbe orumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kanu kinie Yesusi kinie yu lombili andolime kinie eno kolea awili Jeriko oringi. Ongolie eno kinie we yembo awisili kinie Jeriko munduku siye kolko punge puringi kinie mongo keri lierimu ye te, imbi Ba-Timiasi, (akumunge pulumu Timiasi malo,) aulke alselsena molopa yemboma “Kou mone siee.” nimbe mawa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kolea Nasarete ye Yesusi omba purumu mele pilipelie mongo keri lierimu yemo yuni pulu polopa tondolo ru nimbe walsipelie nimbendo: “Yesusi, ⸤ye nomi kingi⸥ Depisini kalopa lsimu yemo, na kondo kolou!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yembo awisilini yu iri toko “Nu ungu naa nili taka liku molou!” niringi. Nalo yuni paa tondolo ru nimbe walsipelie nimbendo: “Depisini kalopa lsimu yemo, na kondo kolou!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesusi we angilipelie “Yu opili niee.” nirimu. Aku nirimu kulu eno mongo keri lierimu yemo walsikulie ningendo: “Yuni “Nu ou.” nikimu kene konopu waengo siku ola angilku ongo pu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yu popenge tepa ola pakorumu wale pakolimu kulupe ola angilipe Yesusi molorumune orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesusini yundu nimbendo: “Nane nu nambe-eambo konopu lekenoye?” nirimu kinie mongo keri lierimu yemone nimbendo: “Raponai, na mongone melema kanambo nanga mongoselo teko peanga tendani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesusini nimbendo: “‘Nane nunge mongoselo kapola tendembo.’ konopu lienumunge nu umbu mongo kapola angilkimu kene pu.” nirimu. Yesusini aku nirimu kinie yu tamburumbu mongoselo peanga lierimu, melema kanopalie, Yesusi purumu aulkena lombili purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","⸤Yesusi kinie yu lombili andolime kinie⸥ eno kolea awili Jerusalleme nondoko ongo, ma pangi te ‘Ma Pangi Unjo Ollipi Ponie’ nili akune lemo kolea kanga talo, Betepasi kinie Betaniselonga oringi. Kanu kinie Yesusini yu lombili andoli ye talo lipe mundupelie, ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","elondo nimbendo: “Ne kolea kanga kanokombelena pukululie kongi dongi walo te, yembo te yunge bulu mingine walsikele kepe naa molopa andorumumu ka teko panjingemo ne sukundu molomba kanongele, kanumu puku posiku yando mengo wangili pale. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Posingele teko molongele kinie yembo tene elondo “Aku nambemune tekembeleye?” nimu liemo elone i siku niengili: “Awilimu yu ‘Dongimuni mepili.’ nimu-ne ombo likimbulu. Yu dongi walomo altopa nondopa yando lipe mundumbe.” niengili.” nimbe elo lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lipe mundorumu yeselo pukulu, kongi dongi walo te, ulke kerepulune ka teko panjeringimu kanokololie kongi kanumu puku poseringili. Aku siku tengele teringili kanokolie ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","akune angilieringi yembo marene elondo “Kongi dongi walomo nambemune posikimbiliye?” ningu walsiku pilieringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","elone, Yesusini ‘i siku i siku niengili.’ nirimu mele niringili kinie “Kapola, ⸤dongi walomo⸥ mengo pangili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kanu kinie elone kongi dongi walomo Yesusi molorumune mengo ongololie, enone enonga mulumbalema kulku dongimunge bulu mingine ola pauwe toringi kinie Yesusi kanune ola molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yembo awisilini enonga mulumbalema kulku yu ombá aulkena pauwe toliku puku, marene unjo kipiyala poniena puku kipiyala gomo langoko liku yu ombá aulkena pauwe toliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kumbi leko puringi yembomane kepe akiliku puringi yembomane kepe naka leko unjo ambololiku pukulie ningendo: “‘Yunge imbi ola molopili.’ niemili! ‘Pulu Ye Yawene lipe mundorumu-ne yunge kongonomo tendemba okomo yemo molopa kondopili!’ ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Olionga anda kolepa ye nomi kingi Depisi⸤ni kalopa lsimu yemo⸥ ye nomi kingi molomba tekemo yemo Pulu Yemone tepa kondopa ‘Yu tondolo pupili.’ nipili. Mulu koleana ola yu imbi ola molopili!” niliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kanu kinie Yesusi Jerusalleme suku pupelie Pulu Yemo popo toko kaloringi ulke tembelena pupe akune suku ⸤teko moloringi ulume⸥ pali kanorumu, nalo kolea ipu lierimu-ne kanopalie ⸤‘Isili-ou ulu te naa teambo.’ nimbe⸥ yu lombili andoli ye engaki rurepo kinie ⸤Jerusalleme⸥ ulsukundu puku, kolea kanga Betani ⸤pengé⸥ puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ipulueli-ou ⸤Jerusalleme nondopa lierimu⸥ kolea kanga Betani munduku siye kolkolie ⸤kelko Jerusalleme punge puringi kinie⸥ Yesusi yu engele terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kanu kinie yu unjo piki te gomo tepa angilierimumu sulu tepa kanopalie ‘Mongo te tomunje.’ nimbe nondopa pupe kanorumu nalo, piki mongo torumu walemo ou wendo naa orumumunge unjo mongo topa te naa perimu, gomoma mindi terimu kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","⸤Gomo mindi terimu kulu⸥ kanopalie “Nu altoko yembomane nonge mongo te naa tani!” nirimu. Aku nirimumu yu lombili andolimene pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalleme kamu oringi kinie Yesusi yu Pulu Yemo popo toko kaloringi ulke tembelena ⸤“Juda yembo naa molemele yemboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akune⸥ suku pupe kanopalie akune melema makete teko moloringi yemboma kinie, melema topo toko liku moloringi yemboma kinie, akume kanopalie eno pali topa makoropa, kou mone lupe lupema alowa teko anjo siringi yembomanga poloma kinie, kera waembono makete teko manie moloringi poloma kinie, lipe topele topa, topa bulu-balu sipelie, ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","yembomando nimbendo: “Yemboma kou mone linge makete tenge melema kolea tenga lupe makete tenge pungendo ulke tembele palana naa pangi. ⸤Anekale teko pangi.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eno mane sipelie nimbendo: “Pulu Yemonga bokune ungu te isipe nilimo: ‘Yembomane nanga ulkemondo “Koleamanga pali yembo talapemane Pulu Yemo kinie ungu nilimolo ulkemo.” ninge.’ kanumu eno naa pilimeleye? Ungu aku sipe molemo nalo enone iulkemo ‘wa nolemele yemboma lopi teko molemele ulkemo’ mele ningu pilkulie aku siku telemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesusini aku nirimu kulu pilkulie Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, eno yu toko kondonge aulke te kororingi. We yemboma yuni mane sirimu mele pilkulie mini-wale mundoringi kulu kanokolie kanu Juda yembomanga ye awilimene yu pipili kolko yu toko kondonge aulke te kororingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pe ipupene, kolea kala tomba terimu kinie ⸤Jerusalleme⸥ ulsu pupe ⸤tenga pe-porumu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ipulueli-ou, ⸤unjo piki angilierimu koleana⸥ ongo pukulie kanu unjo pikimu kamu pulu pali kolorumu kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aku sipe terimu mele Pitane kanopalie ⸤Yesusini unjomondo oleangakondo nirimu mele⸥ kelepa pilipelie yundu nimbendo: “Rapai, kána! Iunjo piki nuni ⸤oleanga⸥ iri tonumu ⸤walsikele⸥ kolomu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesusini topondopa nimbendo: “Pulu Yemone nanga ungumu sike pilimbe⸤monga nimbo mele ‘Paa sike wendo ombá.’ ningu⸥ tondolo munduku piliengi! ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nane eno paa sike nimbu sikirumu: Yembo tene ‘nane nimbo mele paa sike wendo ombá.’ nimbe konopu talo tepa naa pepili ne ma pangimundu “Ungú toko nomu kusana sukundu pu!” nimbé kinie yu nimbé mele paa sike wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Akumunge eno isipu nimbu siembo: ‘Olio ⸤Pulu Yemone paa sike lipe tapondombamonga ‘Teamili.’ nimolo mele sike manda aku sipu temolo.’ molo ‘Nimolo kinie sike aku sipe wendo ombá.’ ningu⸥ tondolo munduku pilkulie Pulu Yemo kinie ungu ningu mawa tenge mele pali Pulu Yemone sike tendembamonga kanu ulume sike wendo ombá.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“‘Ulu pulu keri temulume olionga Lapa, mulu koleana molemomone ‘We manie pupili, siye kolambo.’ nipili.’ ningu, Pulu Yemo kinie ungu ningu angilkulie yembomane eno teko kenjingemonga konopu keri panjiku molonge ulume ‘We manie pupili. Siye kolamili.’ niengila. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Nalo yembomane eno teko kenjinge ulume ‘We manie pupili.’ ningu siye naa kolongi liemo enonga Lapa, mulu koleana molemomone kepe enone ulu pulu keri tengema ‘Manie pupili.’ naa lanimbe siye naa lakolomba.)” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalleme altoko oringi kinie Yesusi yu ulke tembelena suku andorumu kinie ye mare, Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Juda yembomanga tapu yema kinie, ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","eno ongo yu walsiku pilkulie ningendo: “Nu namba nambolka nambamo likulie ikongonomo telenoye? Nawene ikongonomo ‘Te-pou.’ nimbe nu nambamo sipe lipe mundorumuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesusini enondo topondopa nimbendo: “Nane eno ungu te walsipu piliembola. Pe nane eno walsimbo mele na sumbi siku topondoko ningi liemo ‘Na ikongonomo teambo.’ nimbe namba sirimumunge pulumu eno nimbu simbola. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","⸤Nane isipu eno walsipu pilkiru:⸥ Ou ⸤No Lindeli⸥ Jono omba yemboma no linderimu kinie yu mulu koleana molemo yemonga kongonomo tendembando yemboma no linderimu molo ya mana yembomanga kongonomo tendembando yemboma no linderimuye? ⸤Nawene “Tei.” nirimu-ne terimuye?⸥ Ningu siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","⸤Yuni aku sipe walserimu mele pilkulie⸥ enone enono kerepale ningulie ningendo: “Yuni walsikimu mele olione topondopo, ‘⸤Jono⸥ yu mulu koleana ⸤molemo yemonga kongono tendembando yemboma no linderimu⸥.’ nimulu liemo yuni oliondo nimbendo: ‘Aku liemo eno Jonone nirimu ungumu nambemune ‘Iungumu sike.’ ningu naa pilku lsingiye?’ nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Molo olione nimolondo: ‘Yu mana yembomanga ⸤kongono tendembando yemboma no linderimu⸥.’ nimulu liemo “We yembomane olio tongenje.” ningu aku siku ningendo pipili koloringi. We yembomane ‘⸤No Lindeli⸥ Jono yu paa sike Pulu Yemone ungu umbu tondorumumu pilipe yemboma nimbe sirimu ye te molorumu.’ ningu pilimele kene olio nambe-emolonje?” ningu enono aku siku kerepale niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","⸤Enono aku siku anjo yando kerepale ningulie⸥, Yesusindu topondoko ningendo: “⸤Nuni walsikinu mele⸥ olio naa pilkimulu.” niringi. Aku siku niringi kinie pilipelie Yesusini enondo nimbendo: “Kapola. ⸤Nane eno walsikiru ungumunge ungu te topondoko naa nikimilimunge⸥ enone na walsikimili ungumunge ungu te topondopo, nando ikongonomo ‘Te-pou.’ nimbe na lipe mundupe namba sirimu yemonga imbimu eno naa nimbu simbola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Walse Yesusini ⸤Juda yembomanga ye awilimendo⸥ ungu ikoma eno topa simbendo ungu iko te isipe torumu: “Ye tene unjo waene ponie tepalie pala terimu. Poniena sukundu loyekolo akupe waene-no ingi tepa mondombando tepa mimi tepalie nirimumuni, pe ponie nokonge ulke takaye te polo kulupe ola takorumu. Ye mare kanopa lipelie enondo nimbendo: “Nanga poniemo tapu tendeko unjo mongoma inie toko nokondangi. Pe waene mongo polo tomba kinie unjo mongoma moke tepo, kongono tendenge mele mare eno liengi, mare na liembo.” nimbe kanu poniemo eno sipelie yu kolea paa suluringe pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kanu kinie pe waene mongo polo tomba terimu kinie ponie pulu yemone yunge kendemande ye te “Nanga waene-mongo siengi puku liku mendeko wani pu.” nimbe ponie nokoringi yema moloringine lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nalo kendemande yemo ⸤orumu kinie⸥ ponie nokoli yemane yu ambolko likulie yu wale awisili kopene toko waene mongo mare naa siku yando we liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Altopa ponie pulu yemone kendemande ye te lipe ⸤“Nanga waene mongo lindi-pou.” nimbe lipe⸥ mundorumu. Nalo yu ⸤orumu kinie⸥ ponie nokoli yemane yu ambolko likulie toko pengemo toko siku yu teko kenjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Altopa ponie pulu yemone kendemande ye te lipe mundorumu kinie enone yu toko kondoringi. Kendemande ye mare awisili mele lipe mundorumumenga mare wale awisili kopene toko, mare toko kondoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kanu kinie ponie pulu yemo yunge ye telu mindi molorumu, yunge malo, yu konopu mondorumu kangomo. Yuni ⸤konopuni pilipelie⸥ ‘Nanga kangomo pipili kolko liku awi siku, yu waene mongo mare singe.’ konopu lepalie yunge malomo kamu lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nalo ponie nokoli yemane ponie pulu yemonga malo ombá orumu kanokolie enone enono ningendo: “Andi okomo yemo pe lapanga melema limbe yemo okomo. Yu topo kondopo iponiemo olio kamu liemili.” ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","enone yu ambolko liku toko kondoko ⸤yunge onomo⸥ poniena toko ulsu mundoringi.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","⸤Yesusini ungu iko akumu topa pora simbendo kanu Juda yembomanga ye awilimendo walsipelie nimbendo:⸥ “Ponie nokoli yemane aku teringimunge pe ponie pulu yemone eno-kinie nambolka uluri tembaye? Yu omba kanu ye kerime topa kondopalie ‘Ye marene lupe poniemo nokondangi.’ nimbe lipe simbe.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","⸤Yesusini Pulu Yemonga Juda yemboma nokoringi yemane yu toko kondonge mele pilipelie enondo nimbendo:⸥ “Pulu Yemonga bokune sukundu ungu te kanoko naa pilimeleye? ⸤Aku ungumu isipe mele:⸥ ‘Ulke takoringi yemane kanoko keri kanoko toko lteringi kou kanumu kinié kelepa ulke simu mele ulke enge sindeli kou awili peangamo.” ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","‘Awilimuni aku ulumu terimu olione kanopo paa peanga kanolemolo.’ nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","⸤Kanu Juda yembomanga ye awilime⸥ enone Yesusini ungu iko torumu kanumu pilkulie enone yu tonge teko moloringi mele yuni nirimu pilkulie enone yu ka singe teringi nalo kanu ye awilimene we yemboma pipili kolkolie yu liku ka naa siringi. Yu munduku siye kolkolie anjo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pe walse ⸤Juda yembomanga ye awilimene⸥ Parisi ye mare kinie ye nomi kingi Erotenga talape ye mare kinie liku, “‘Yesusini ungu te nimbe kenjepili.’ ningu i siku i siku yundu niengi.” ningu Yesusi molorumune liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Liku mundoringi yemane Yesusi molorumune ongo yundu ningendo: “Ungu Mane Silimu, olio pilimolo, ‘nuni ungu sikema mindi ningu, nu yembo teluringe kepe konopu kimbu naa siku, yemboma pipili naa kolko enondo pali ungu telu siku kapola kapola ningu siku, Pulu Yemone “Teaa.” nilimo ulume paa sike ungume mane siku, aku siku teleno.’ konopu lemolo. ⸤Aku siku teko molenomonga nu nambolka konopu lekenoye?⸥ Olione Romo Gapomano Ye Paa Awili Kumbine ‘Sisa’ nilimu kou takisi tomulu liemo kapola molo moloye? Yu ⸤kou takisi⸥ simolone naa simolone? Pulu Yemone akumundu ungu mane sirimu ungu mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nalo Yesusini, eno topele mapele toli yema vmolemele mele pilipelie enondo nimbendo: “‘Yuni nimbe kenjepili.’ ningu nambemune na manda manjiku kolo toko walsikimiliye? ⸤Takisi tolemele⸥ kou mongo te kanambo, mengo ongo siee.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","enone yu molorumune te mengo ongo yu siringi. Kanu kinie Yesusini enondo nimbendo: “I koune nainge kumbikeremo kinie imbimu kinie molemoye?” nirimu. Enone yundu ningendo: “Romo Gapomano Ye Paa Awili Kumbine Sisamonga kumbikeremo kinie imbimu kinie molemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kanu kinie yuni enondo nimbendo: “⸤Kou monemo Sisamonga⸥ kene Sisamonga melema Sisamo yuyu siku, Pulu Yemonga melema Pulu Yemo yuyu siee.” nirimu. Yuni aku sipe ⸤paa sumbi sipe⸥ nirimu mele pilkulie ⸤‘Yu paa pilipe konginjeli pelemo yemo lepamo.’ ningu pilkulie⸥ konopu awisili liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","⸤Kanu yema Yesusi kinie kou takisi toli ungumu ningu pora siringi kinie⸥ pe Sadusi ye mare Yesusi molorumune oringi. Sadusi yema eno ‘Pulu Yemone pe kolemele yemboma topa naa makinjindimbe, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Aku Sadusi yema ongo Yesusi walsiku pilkulie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ungu Mane Silimu, ⸤Pulu Yemonga ungu manema olio sirimu ye⸥ Mosisini ungu mane sipelie nimbendo: “Ambo limbe ye te ambolango naa membalie ambomo we molopili kolomba kinie kanu yemo yunge angenu molombamone yunge ambo wayemo lipe angenu lipe tapondopa ambolango mendepili.” nirimu aku sipe nimbe bokune torumu molemo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","⸤Aku ungu manemonga ulu te olionga ye mare-kinie wendo orumu mele nu walsipu piliemili.⸥ “Angenupili yepoko pakera moloringi. Komomo ambo lipe ambolango te naa membalie kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","⸤Ambolango te naa molopili kolorumu kulu⸥ yunge bulkundu angenumuni ⸤yunge angenu kolorumumunge ambolango ‘Mendambo.’ nimbe⸥ ambo wayemo kelepa lsimu. Yu ambolango te naa mendepalie yu we kolorumula. Yunge angenu bulkundumuni kanu ambomo lsimula nalo yu kepe we kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aku teliku pukulie ye yepoko pakera pali ambolango telu kepe naa mengolie kolko pora siringi kinie akiliomo we kolorumula. Pe ambomo yu kolorumula. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Akumunge, kolemele yemboma pe lomboroko ola molonge kinie kanu ambomo ye yepoko pakera pali ya mana lsingi kulu ambomo yu ye paa nainge menu molombaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesusini enondo topondopa nimbendo: “Eno Pulu Yemonga bokune ungu molemoma kinie, Pulu Yemo kinie tondolo pelemo mele kinie, naa pilku lou lemelemonga ⸤yemboma pe tengemondo nikimili mele pilku sunduku kolo tokomele⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lomboroko ola molonge yembomanga yema ambo naa liku, amboma ye naa puku, aku paa naa tenge. Mulu koleana molemele angelloma molemele mele aku siku molonge. ⸤Angellomane mana yemboma telemele mele naa telemele kanumu.⸥ Aku tengemonga ⸤‘Eno Pulu Yemonga ungumu pilku sunduku lawa telemele.’ nikiru⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Nalo ⸤eno Sadusimene⸥ ‘Kolemele yemboma lomboroko ola naa molonge.’ konopu lemelemonga ungu te niembola. Mosisi unjo kanga tenga ⸤tepe nomba perimu tepemone unjomo naa norumu kanopalie nirimumuni⸥ akune Pulu Yemonga ungu te wendo omba Mosisindu ungu te nirimu temanemo enone naa kanoko pilimeleye? Pulu Yemone Mosisindu nimbendo: “Na Eporayamo kinie Aisake kinie Jekopo kinie enonga Pulu Yemo molio.” nirimu. Pulu Yemonga bokune Mosisini torumu aku ungu molemomo naa kanoko pilimeleye? ⸤‘Enonga Pulu Yemo molorundu.’ naa nirimu. ‘Enonga Pulu Yemo molio.’ nirimu kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pulu Yemo yu kololi yembomanga Pulu Yemo molo; yu yembo kondemanga Pulu Yemo. Akusiku pilku sundukulie eno lou lemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","⸤Sadusi yema kinie Yesusi kinie⸥ aku siku kerepale ningu molangi Pulu Yemonga ungu manemanga pulume pilipe mane sirimu ye te omba eno anjo yando ungu mele teko kerepale ningu moloringi omba pilierimu. Enone ungu mare Yesusindu walsiku pilieringi kinie yuni anjo topondopa nimbe kondorumu mele pilipelie ungu mane sirimu yemone Yesusindu walsipe pilipelie nimbendo: “Pulu Yemone ungu mane sirimu pelemomanga pali nambolka ungu manemo yu olandopamoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesusini topondopa nimbendo: “Ungu mane olandopamo isipe: ‘Isirele yemboma, pilieme! Awili Yawe olionga Pulu Yemo yu mindi Awili telumu molemo, te lupe molo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Enone enonga kamelema kinie, enonga minime kinie, enonga pilipe konginjelime kinie, enonga tondolomo kinie, akumene Awili Yawe enonga Pulu Yemo manjiku tondolo munduku konopu mondangi.’ nimbe, ungu mane paa olandopamo aku sipe ⸤nimbe⸥ molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ungu mane talo sipemo isipe: ‘Enone enono yu-mele-mele konopu mondoko enonga kangimu enono kondo kolko nokolemele mele aku sikula pulu lemo yemboma konopu mondoko nokoko molangi.’ nimbe molemo. Aku ungu maneselonga olandopa te paa naa pelemo, molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","⸤Yesusini aku nirimu pilipelie⸥ yemone yundu nimbendo: “Ungu Mane Silimu, papu nikinumu. Nuni ninindu: “Pulu Yemo telumu mindi molemo. We te lupe naa molemo. Yu yuyu molemo.” nikinumu paa sike nikinu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‘Yu konopu mondongendo enone enonga kamelema kinie, enonga pilipe konginjelime kinie, enonga tondolomo kinie, akumene ⸤Awilimu enonga Pulu Yemo⸥ manjiku tondolo munduku konopu mondangi.’ nimbe pelemo ungu manemo kinie ‘Eno enonga kangime enono kondo kolemele mele yembo pulu lemoma aku siku kondo kolangi.’ nimbe pelemo ungu manemo kinie, aku ungu maneselo temolo kinie olandopa; Pulu Yemo kongime kinie melema popo topo kalopo “I mu nu sikiru.” nilimolo akumu maniendopa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yuni topondopa nimbe kondorumu pilipelie Yesusini yundu nimbendo: “Nu konopu leko molenomonga Pulu Yemone ye nomi kingi molopa nokolemo yembo talapena sukundu nondoko puni tekeno lemo.” nirimu. Kanu kinie ⸤Yesusindu walsiku pilieringi ungume pali yuni topondopa anjo nimbe kondorumu pilkulie⸥ altoko yu ungu te walsiku pilingendo pipili kolko naa walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena suku yemboma ungu mane sipe molorumu. Mane sipe molopalie ungu te nimbendo: “Pulu Yemonga ungu manemanga pulume pilku mane sili yemane ningendo: “Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu ⸤ye nomi kingi⸥ Depisini kalopa limbe yemo molomba.” nilimele akumu nambemune “Yu Depisini kalopa limbe yemo molomba.” nilimeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","⸤Aku nilimele yemane⸥ Depisi yuni yuyu ⸤kanu yemondo nirimu mele naa pilimelenje.⸥ Mini Kake Telimu Depisinge konopune molorumu kinie Depisi yuni ⸤ye Kirasimu molomba mele⸥ nimbendo: “Awili ⸤Pulu Ye Yawene⸥ nanga Awilimundu nimbendo: “‘Nunge opa puluema nuni nokani.’ nimbu, pe eno topo manie mundundumbo kene isili-ou nu ⸤na kinie pea tapu topolo ye nomiselo molopolo melema nokambili⸥ nanga ki umbukundu ongo molani.” nirimu.” nimbe Depisini nirimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depisini ⸤ye nomi Kirasimu⸥ yundu “Nu nanga Awilimu.” nirimu. Pe enone “Yu Depisini kalopa limbe yemo ⸤mindi⸥ molomba.” nambeko pilkulie nilimeleye?” nirimu. We yembo awisili maku toko moloringime Yesusini nirimu ungume pilkulie konopu awili teko siku pilku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesusini ungu mane sipe molopalie nirimumuni ⸤liepi-liepi topa⸥ ungu te nimbendo: “Enone Pulu Yemonga ungu manemanga pulume pilku mane sili yema mimi siku kanoko kondoko ⸤enone telemele mele manda manjiku naa teko⸥ molayo. ⸤‘Yembomane olio kanoko “Ye peangama” niengi.’ ningu⸥ kanu yemane wale pakoli paa sulu peangama, ⸤ye nomime pakolemele mele,⸥ pakoko andolemele. Yemboma maku toko molemele koleamanga mongo-kenge teko andonge kinie ‘We yembomane olio kapi niengi.’ ningu pilkulie konopu siku pilku andoko molemelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yemboma maku toko Pulu Yemonga ungumu pilimele ulkemanga sukundu pukulie manie molongendo ye awilime molemele polo peanga akune mendo puku polo akune konopu siku molemelela. Yembomane langi nongo yembomando “Namili waa.” nilimele kinie kanu yema ongolie ye awilimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Yema kolemele kinie enone kanu yemanga ambo wayema toko makoroko mundukulie ulkema ‘Olionga’ ningu we limele. Pulu Yemo kinie ungu ningendo ningu sulu munduku we kolo toko nilimele. Pulu Yemone weyemboma ulu pulu keri telemelemonga eno sike mongo lipe simbe nalo ya ye nikirumene aku ulume telemelemonga Pulu Yemone aku yema mongo awili tepa lipe simbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesusi ⸤Pulu Yemo popo toko kaloringi ulke tembele⸥ kerepulune ulke tembelena sukundu kongono tenge kou-monema mundoringi unjo-ketena nondopa manie molopalie yembo awisilini aku unjo-ketena kou mone ongo mundoringi mele kanopa molorumu. Kanopa molorumu kinie yembo kamakomane kou mone awisili ongo mundoringi kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","⸤Aku sipe kanopa molorumu kinie⸥ ambo waye paa koropa te omba yu kou kololi talo mindi mundorumu. Kanu kou kololiselo lipe tere lepa wane toya mele mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","⸤Ambo wayemone aku terimu kanopalie⸥ Yesusini yu lombili andolime walsipe “Waa.” nimbelie enondo nimbendo: “Nane enondo paa sike nimbu sikirumu: Andi ambo waye koropamo yuni kou mone mundukumumu paa olandopa mele mundukumu, we mundukumilime maniendopa mele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Eno kou mone awisili nosilimelemanga koltalo mindi ongo mundukumili. Nalo ambo wayemo kou mone te paa naa nosilimo. Yunge kou koltalo nosemuselo pali memba omba mundomu. Langi nombá kepe te naa nosilimo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kanu kinie Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena ulsu pumbe purumu kinie yu lombili andolimenga tene yundu nimbendo: “Ungu Mane Silimu, tembelemonga ulke lupe lupema kinie, ulkema takoringi kou peanga lupe lupema kanou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","⸤Aku nirimu kinie⸥ Yesusini yundu nimbendo: “Ya ⸤tembelemonga⸥ ulke lupe lupe peanga angilimo kanokomelema, pe ⸤walse ya kolea awili Jerusalleme yemboma mindili nonge walemo wendo ombá kinie⸥ itembelemonga ulkema pali tekisikulie koume pali toko manie mundunge.” nirimu. molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kanu kinie yu ma pangi Unjo Ollipi Poniena ola pupe ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena welkendo manie molorumune we yemboma naa molangi ⸤yu lombili andoli ye mare⸥ Pita keme, Jemisi keme, Jono keme, Enderu keme eno ongo, eno enono molkolie yundu walsiku pilkulie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nuni nikinu mele tewale wendo ombáye? Pe nuni inikinu ulume nondopa wendo ombándo ou nambolka uluri temba kinie olio kanopolie ‘Ulume iwendo ombá tepamo.’ nimbu pilimoloye? Olio ningu si.” ningu walseringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","yuni enondo nimbendo: “⸤Kanu ulume wendo ombámonga ungu mare⸥ yembomane eno kolo toko singe kene kanoko kondoko molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ye awisili ongo na molio mele yu mele mele kolo toko ningendo: “⸤Pulu Yemone ‘Nanga yemboma nokopa kondomba lipu mundumbo.’ nimbe mako torumu ye nomi Kirasi⸥ akumu na.” ningulie aku siku kolo toko singe kene kanoko kondoko molangi. Yembo awisilini kanu yemanga ungume pilku liku “Sike nikimili.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kolea marenga opa awili teko tenge mele pilku, ‘Opali talou opa awili isipe isipe wendo ombá.’ ningu we ninge kinie pilkulie mini-wale naa mundengi. Opa tengema kinie aku ulume Pulu Yemone ‘Ou wendo opili. Laye pe mele ya ma koleamo pora nimbé.’ nimbe, nimbe panjerimumunge aku ulume sike wendo ombá nalo aku kinie mulu maselo ou naa pora nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","⸤Mulu ma pora nimbé walemo ou wendo naa opili umbune awili mare wendo ombá.⸥ Yembo talape awili te kinie talape awili te kinie opa tekolo, ye nomi kingi marenga talapema kinie marenga talapema kinie opa tenge. Ya ma kolea tenga tenga ma jimi-jimi tepa, engele lepa, aku sipe temba. Ambo tene ambolango kokele kanopa limbendo ou mini topa mindili nolemo mele, mulu ma pora nimbé walemo kokele wendo ombándo umbune lupe lupe aku sipema ou wendo ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“⸤Kanu ulume wendo ombá walemanga⸥ yemboma mimi siku kanangi. Enone ⸤‘Na lombili andoli yemboma mindili nongo, kolangi.’ ningu,⸥ eno ⸤mare liku ambolkolie⸥ kanjollomanga makumenga mengo puku kote tendeko, eno ⸤mare⸥ Juda yemboma maku toko Pulu Yemonga ungumu pilimele ulkemanga liku mengo puku kopene tongela. Eno nanga yemboma molongemonga eno ⸤mare ka siku⸥ gapomano ye awilime kinie ye nomi kingime kinie molongena ⸤kote tendengendo⸥ mengo pungela. Aku siku tenge kene eno enono kanoko kondoko molayo. ⸤Nalo kote tendenge kinie kotena angilkulie kanu yema kinie kanu yema nokonge ye nomime kinie⸥ enone ‘Nanga ungumu piliengi!’ ningu eno ningu singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Temane peangamo ‘Yemboma pali piliengi!’ ningu koleamanga pali andoko ou ningu singe ⸤kinie, pe mulu ma pora nimbé walemo kamu wendo ombá⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eno ka siku kote tendenge kinie ou ‘Kotena nambolka unguri nimolonje? Olio ungu te walsiku pilinge kinie nambolka unguri topondopo nimolonje?’ ningu mini-wale naa mundengi. Eno ungu ningema enono pilkulie naa ninge. Mini Kake Telimuni enonga kerena molopalie nimbe simbe ungume enone anjo ninge kene aku tenge enamonga eno ungu ninge mele pilkulie aku siku ninge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“⸤Aku walemanga⸥ angenuni yunge kandi angenu ⸤nanga yembo molombamonga⸥ ‘Kolopili toko kondangi.’ nimbe kote tendemba. Lapane yunge kandi ambolangoma akula temba. Ambolangomane kepe enonga kandi anupili lapali-kinie mumindili kolko kotena mengo puku “Toko kondangi.” ningela. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nanga yemboma molongemonga yembomane pali eno-kinie konopu keri panjinge, nalo na munduku siye naa kolko walema pora naa nipili tondolo munduku molonge yemboma Pulu Yemone lipe tapondopa ‘Mindili nonge koleana naa puku pea molopo kondopo mindi pamili.’ nimbé.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(⸤Na ibokumu tokoro yemone⸥ eno bokumu kanokomele yembomando ungu te niembo: ‘⸤Yesusini nirimu⸥ ungumu inie maniekondo molemo akumu eno imbi kanokomele yembomane ungu pulumu paa pilku kondangi.’ ⸤nikiru: Yesusini nimbendo:⸥) “⸤Yembo⸥ tepa pipili kondoli mele paa kerimu ⸤ulke tembelena suku Pulu Yemonga Ulke Suluminia Kake Teline Pulu Yemone⸥ “We yemboma naa pangi!” nimbe mitolemo-na yu manda naa pupe angilimbe, nalo walse akune angilipelie kolea akumu paa tepa kalaro mondomba. Aku melemo akune ⸤wendo omba⸥ angilimbe kanokolie ⸤‘Umbune awilime wendo ombá tekemo.’ ningu pilku⸥ kolea Judia poropinji koleamanga molonge yemboma ⸤enonga koleama munduku siye kolko⸥ ma pangi lembamanga kowa pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yembo te ulke imune ola molopili ⸤aku sipe ulu te wendo ombá kinie kanopalie kowa pumbendo⸥ manie omba ‘Melema lipu membo pambo.’ nimbe ulkena sukundu manda naa pupili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yembo te poniena molopalie ⸤‘Kowa pambo.’ nimbe⸥ kelepa ulkendo pupe yunge ali-wale sulumu naa lipili. ⸤Sumbi siku kowa mindi pangi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aku sipe wendo ombá walemonga ambo ambolango mondongema kinie, ambo ambolango ame singema kinie, ⸤eno manda lkisiku kowa naa pungemonga⸥ eno-kinie paa umbune wendo ombamonga eno kondo tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Pulu Yemondo mawa tekolie, ‘Ali telemo olimenga kanu umbunema wendo naa opili.’ nieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kanu walemanga umbune paa awilime wendo ombá, Pulu Yemone ou mulu ma pulu polopa terimu kinie kepe, yandopa kinié kepe umbune aku sipe te wendo naa orumu. Pe kepe aku sipe umbune awilime naa wendo ombála. Akumunge aku siku Pulu Yemo kinie mawa teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","⸤Kanu umbunema wendo ombá kinie⸥ Awili ⸤Pulu Yemo⸥ ne ‘Nondopa pora nipili.’ nimbe ou naa nimbe panjilkenje yemboma pali kolemela. Nalo Pulu Yemone mako topa ‘Nanga yemboma molangi.’ nirimu yemboma ‘Naa kolangi.’ nimbe ‘Umbune wale akume nondopa pora nipili.’ nimbe, nimbe panjerimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kanu umbune omba pemba walemanga yembo marene ningendo: “Kanaa! Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ ou nimbe mako torumu ye nomi Kirasimu ya omba molemo.” ninge molo “Nena omba molemo.” ninge kinie enonga ungume naa pilku, ‘Sike nikimili.’ ningu naa piliengi! ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ye mare ongolie kolo toko ningendo: “Pulu Yemone mako torumu ye nomi Kirasimu na.” ninge, molo kolo tokolie “Pulu Yemone ungu umbu tondomume pilipulie ombo nimbu sikimulu.” ninge. ‘Yemboma pali, Pulu Yemone ‘Nanga yemboma molangi.’ nimbe mako torumu yembomane kepe lipu lou sipu, nikimulu mele ‘Sike.’ ningu tondolo munduku piliengi!’ ningu Pulu Yemone mindi ulu tondolo kapola telemoma mele manda manjiku ulu tondolo lupe lupema tenge. Nalo Pulu Yemonga yemboma aku siku kondi tongekinie enonga ungume naa pilku, liku su singe. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akumunge, pe ulu akume wendo ombá mele ‘Eno oupiliengi!’ nimbu ya nimbu sikiru mele pilkulie kanoko kondoko molaa!” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kanu walemanga aku mindili nonge nikiru ulume wendo ombá kinie pe ⸤ulu lupe lupe mare wendo ombála. Aku ulume isipe:⸥ ‘Kolea tangombando ena patelemo mele naa tepa, sumbulu topa, oli ipulueli patelemo mele naa tepa, ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kombukandipime mulune manie omba, mulune angilimo mele tondoloma lope lope tepa anjo yando pupe, aku sipe ulu lupe lupema wendo ombá.’ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aku temba walemonga Manie Omba Mana Ye A Lierimu Yemo tondolo pulimu kinie, pa awili-tepa telimu kinie kupe tenga suku molopa kamu manie ombá yembomane kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ombalie yuni yunge angelloma lipe mundumbe kinie eno winjo mendo anjo yando mulu ma koleamanga pali puku Pulu Yemone ‘Nanga yemboma molangi.’ nimbe ou mako torumu yemboma sukundu sukundu linge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Unjo pikimuni telemo aku sipe ungu iko mele pelemo kene pilkulie ungu pulumu piliee. Unjo piki kuku topa gomo tolemo kinie kanokolie ‘Kinié ena temba walemo wendo ombá tekemo lemo.’ ningu pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aku sipela, iulu “Wendo ombá.” nikirume sike wendo ombá kinie kanokolie ningemone ‘Yu paa sike nondopa ombá tekemo. Yu paa kamu okomo.’ ningu pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Nane enondo paa sike nimbu sikirumu: Kinié molemele yemboma ou naa kolangi i “Wendo ombá.” nikiru ulume pali wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mulumu kinie mamo kinie pora nimbé nalo nanga ungu nilioma paa pora naa nimbé. ⸤Nilio mele pali paa sike wendo ombá.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“⸤Manie Omba Mana Ye A Lierimu Yemo paa sike ombá⸥ nalo yu ombá walemo naa pilimolo. Ipulueli ombáne, tangoli ombáne naa pilimolo. Mulu koleana angelloma kepe naa pilimelela. Pulu Yemonga Malo kepe naa lapilimo. Tata yuyu mindi ⸤aku walemo⸥ pilipe molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yu kelepa ombá walemo eno naa pilimele kene yu ombá kanoko kondoko, uru naa peko (Pulu Yemo kinie unguningu) molayo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yu ombá walemo isipe: Ye te koleamarenga wale mare molomba pumbe telemo kinie yunge koleamo mundupe siye kolombando yunge kendemandemando “Nanga koleamo nokondaa.” nimbelie yunge kongonomo tendenge mele eno yu mele mele moke tepa sipe ulke kerepulu nokolemo yemondo “Na walse ombó kene kanoko molou.” nimbelie pulimo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ulke pulu yemo sike ombá nalo yu ombá walemo naa pilimele kene ‘Yu ombá.’ ningu kanoko molayo. Ipupene ombá, molo awi-burumi ombá, molo kolea tangombando kera gulta ko tolemo kinie ombá, molo ipulueli ou ombánje, eno naa pilimele kene ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“Na urupeambo walsikele yu lipe sinjipe omba na kanomba.’ ningu, kanoko molangi.’ nimbu nikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Enondo inikiru mele yembomando pali nikirula, ‘⸤‘Ombá.’ ningu⸥ kanoko molangi.’ nimbu nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","⸤Juda yembomane ponie tenga tenga kolea awili Jerusalleme ongo akune suku⸥ Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilku, Pillawa Akoli Mele Isi Naa Munduku Pillawa We Kalko Noringi Walemo talou mele wendo ombándo, kinié mele Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, enone Yesusi kiyengo ningu ka siku tongeaulke te koroko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akumundu ungu mele tekolie ningendo: “⸤Nondopo tamili,⸥ nalo Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu Mele ⸤Pilimolo⸥ Walemanga ⸤‘ulume tepo molamili.’ ningu⸥ yembo awisili ya Jerusalleme ongo maku toko molongemonga yu isili-ou tomolo kinie enone olio kinie mumindili kolko opa tenge kene isili-ou naa topo, keleamili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kolea kanga Betani ye te ou kuru laká nombalie kelierimu ye te, imbi leko “Ye Kuru Laká Noli Saimono” niringi kanumunge ulkena Yesusi pupe langi nomba molopili ambo te kopongo wele ma-mingi paa peanga te yu molorumune meli orumu. Kanu wele paa mune tolimunge kou mone paa awili tepa purumu. Akumu memba ombalie Yesusi langi noli polo molorumune meli omba ⸤‘Yu tepo kondambo.’ nimbe⸥ mingimu kako topa welemo pengena ondo lenderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yuni aku terimu kinie kanokolie kanune moloringimenga marene konopu keri panjikulie anjo yando enono ningendo: “Aku kopongo welemo nambemune we tepa kenjikimuye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aku welemo kou mone limelanje kou awisili, kou mongo wane tausini mele, lipulie yembo koropama moke tepo silimela.” ningu ambomo tondolo munduku iri toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","⸤Enone ambomondo aku siku niringi pilipelie⸥ Yesusini enondo nimbendo: “I ambomo-kinie nambemune ungu awisili nikimiliye? Yuni na-kinie ulu peanga te temu kene yu-kinie ungu awisili naa ningu munduku siye kolangi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yembo koropama eno-kinie alieli molonge kene ‘Eno lipu tapondamili.’ ninge walemanga pali eno manda liku tapondonge nalo na eno-kinie alieli naa molombo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ambomone ‘Manda tembo.’ konopu liemu mele temu. Na ono tengemonga yuni isili-ou iwele mune tolimu nanga kangine omba ondo lendemu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nane enondo paa sike nimbu sikirumu: Ma koleamanga pali ⸤nanga⸥ temane peangamo andoko toko singe kinie i ambomone kinié temu temanemo kepe ‘Yembomane pilkulie ‘Yuni tepa kondorumu.’ ningu piliengi!’ ningulie aku temanemo toko singela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kanu kinie ⸤Yesusi yu lombili andoli⸥ ye rurepo akumenga ye te, Judasi Isikeriote, ‘Pulu Yemo popo tondoringi ye awilimene ka singe aulkemo yuni aki sindembo.’ nimbe eno moloringine pupe, temba mele nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yuni temba mele nirimu kinie pilkulie eno konopu awili teko siku “Nu kou mone te simolo.” ningu, ningu panjeringi. Kanu kinie yu Yesusi eno lipe simbe mele aulkemo koropa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Koromonga pulu pulu walemo wendo orumu kinie Juda yembomane Pulu Yemone ou enonga anda kolepalime Naa Topa We Omba Purumu mele pilingendo kongi sipisipi walo te toko nonge mele pilkulie niringimuni, Yesusi lombili andoli yema yu molorumune ongo walsiku pilkulie ningendo: “Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu mele pilimolondo kongi sipisipi walo te kinié nonimu kolea tena pupu tepo mimi te-pamili konopu lekenoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aku siku ningu walseringi kinie yuni yu lombili andoli talo lipe mundupelie nimbendo: “Ne kolea awili ⸤Jerusalleme⸥ suku pukululie, ye te mingine no kolopa meli ombá aulkena puku kane-kane tokololie yu lombili pangili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yu suku pumbe ulkena ⸤suku pukululie⸥., ulke pulu yemondo ningelendo: “Ungu Mane Silimuni isipe walsipelie nimbendo: “Na kinie na lombili andolime kinie olione Pulu Yemone olionga anda-kolepalime naa topa we omba purumu mele pilimolondo kongi sipisipi walomo tena nomoloye? Nomolo suluminiamo tena lemoye?” nimu.” niengili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aku ningele kinie yuni elo ulkemonga olakondo suluminia awili te, akune langi noli polo te kinie, manie molomolo poloma kinie, melema pali ou teko mimi tengi lembamo, lipe ora simbe. Aku suluminiamonga ⸤nomolo sipisipi walomo⸥ teko mimi teangili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kanu kinie yu lombili andoli ye akuselo kolea awili akumunge suku pukulu, Yesusini nirimu kanu mele ulu akume teli lierimu kanoko lendekololie, akune Pulu Yemone enonga anda-kolepalime naa topa we omba purumu mele pilinge kongi sipisipi walo nongemo teko mimi teko noseringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ipupene ena pupe kolea kala torumu kinie Yesusi kinie yu lombili andoli rurepo kinie oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Langi nongo moloringi kinie Yesusini nimbendo: “Nane enondo paa sike nimbu sikirumu: Eno pea molopo langi nokomolomanga ye tene na lipe nanga opa puluema simbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","⸤Aku nirimu kinie pilkulie⸥ enonga konopune umbune terimu pilkulie yu mele mele walsikulie ningendo: “Awilimu, nando nikinuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesusini topondopa nimbendo: “Eno nanga ye rureponga ye te na kinie langime polo awi-suku-singine ola lemo te walsikele lipu nombolo yemone na lipe, opa puluema anjo simbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Kinié Manie Omba Mana Ye A Lierimu Yemo kinie tenge mele koronga ou ningu panjeringi temanemo ⸤Pulu Yemonga⸥ bokune sukundu molemo mele sike opa puluemane tenge, nalo yu lipe opa puluema simbe yemo mindili nomba paa molopa kenjimbe. Yu molopa kenjimbemonga yu anumuni naa melkanje papu. ⸤Yu mindili naa nolka.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eno langi nongo moloringi kinie Yesusini berete te lipe Pulu Yemo kinie “Ange.” nimbelie ambolopa pike lepa ⸤yu lombili andolime⸥ sipelie nimbendo: “I mu nanga kalumu eno liku ⸤nangi⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pe no waene kapo te lipelie Pulu Yemo kinie “Ange.” nimbe eno sirimu kinie enone pali ⸤kanu no waenemo⸥ noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yuni nimbendo: “I ⸤no-waene⸥ sikirumu nanga mememo. Pulu Yemone ⸤yu kinie yunge yemboma kinie molonge mele⸥ ungu te nimbe panjipe mi lierimu kanu ungumu ‘Kamu wendo omba pepili.’ nimbu yembo awisilinge nimbu nanga mememo ondo lendepolie ⸤kolombo⸥ aku mememo imu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nane enondo paa sike nimbu sikirumu: Isili-ou na no-waene altopo paa naa nombó. Pemindi, Pulu Yemo ye nomi kingimu molopa nokolemo koleana no waene kondemo kelepo nombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","⸤Langi nongo pora sikulie⸥ eno Pulu Yemonga konana te ningulie, pena puku ma pangi Unjo Ollipi Poniena ola puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kanu kinie Yesusini lombili andolimendo nimbendo: “Pe ⸤opa puluemane na-kinie tengemonga kanokolie⸥ enone pali na munduku siye kolonge. Aku siku tenge mele Pulu Yemone ou nirimu yunge bokune molemo kanumu. Pulu Yemone ⸤ungu iko te topalie⸥ nimbendo: “‘‘Kongi sipisipi tapu yemo tangi.” nimbo, yu tonge kinie sipisipime bulu-balu ninge.” nirimu, ⸤aku mele kinié wendo ombá⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","⸤Isili-ou na toko kondonge kinie eno sike bulu-balu ninge⸥ nalo na lomboropo ola molopolie nimbomone, na kumbi lepo kolea Gallillindu pumbo, eno pe akilku akune onge kinie ⸤altopo pea molomolo⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","⸤Yesusini aku sipe nirimu kinie pilipelie⸥ Pitane nimbendo: “Enone pali ‘Nu sike’ ningu tondolo munduku pilimele mele manie pumbe kinie nu munduku siye kolongi liemo nane nu aku sipu paa mundupu siye naa kolombo, paa molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesusini topondopa nimbendo: “Nane nu paa sike nimbu sikirumu: Paa kinié ipulueli, kera gulta wale talo sipemo ou ko naa topili nuni pipili kolkolie wale yepoko nando kolo toko “Yu naweye? Na naa kanolio.” nini.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nalo Pitane tondolo mundupe nimbendo: “Na nu-kinie tapu tolembolomonga olto pea “Tomolo.” ningi liemo kepe nu “Naa kanolio.” paa naa nimbo.” nirimu. Lombili andoli ye wemane pali “ “Nu naa kanolemolo.” paa naa nimolo.” niringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","⸤Kanu kinie⸥ Yesusi kinie yu lombili andoli yema kinie kolea ‘Gesemani’ niline puringi. Akune puringi kinie yuni enondo nimbendo: “Na Pulu Yemo kinie ungu ni-pukuru kene eno ya molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aku nimbelie Pita keme Jemisi keme Jono keme lipe memba pupelie ⸤‘Na teko kenjinge ulumu paa nondopa wendo ombá tekemo.’ nimbe pilipelie⸥ yu yuyu kondo kolopa konopu keri panjipe kamelena mindili tepili molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yuni enondo nimbendo: “Nanga konopune umbune paa awili te tepamo kene na kolkoro none tekemo. Eno uru naa peko, ya kanoko kondoko molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aku nimbelie yu yuyu laye kolte anjo pupe koporongo langopa tamalu pepalie yu-kinie nondopa wendo ombá mele ‘Wendo naa omu liemo paa papu.’ nimbe Pulu Yemo kinie ungu nimbe mawa tepalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Nanga Tata, nuni ulume pali manda teleno kene na mindili noli no mingine no nombómo ‘Naa nambo.’ nieni. Nalo ‘Nane tepolie nanu konopu simbo.’ konopu lekero mele naa teambo. Nuni kanoko peanga kanoni ulumu mindi teambo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aku nimbelie kelepa yunge lombili andoli ye yepoko moloringine yando omba eno uru peringi kanopalie Pitando nimbendo: “Saimono, nu uru penu lemo. Nu uru naa peko ena laye-kolte manda we kanoko kondoko naa molenaye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‘⸤Kurumenga nomi Setenene⸥ olio kondi tomba kinie tepo kenjimolo kene.’ ningulie ⸤uru naa peko⸥ Pulu Yemo kinie ungu ningu kanoko kondoko molayo. Sike ‘tepo kondamili.’ nimbu konopumene pilimolo nalo temolondo kangimu siye tepa tondolo naa pulimo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aku sipe nimbelie yu altopa anjo pupe ou Pulu Yemo kinie ungu nimbe mawa terimu mele altopa nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Altopa yando orumu kinie eno uru paa orumu kulu altoko uru peringi kanorumu. Enone uru peringimunge pipili kolkolie yundu ninge mele naa pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","⸤Altopa⸥ wale yepoko sipemonga ⸤anjo pupe Pulu Yemo kinie ungu nimbé pupe⸥ kelepa yando ombalie yuni enondo nimbendo: “Nambemune we uru peko múlu pilku molemeleye? Manda peame! Manie Omba Mana Ye A Lierimu Yemo ⸤tonge⸥ ulu pulu keri telemele yema liku singe enamo wendo ombá tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ola angilku pamili wame! Na lipe anjo simbe yemo okomo kanaa!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesusini ⸤kolea Gesemani yu lombili andolimendo⸥ aku nimbe molopili yu lombili andoli rurepo akumenga ye Judasi orumu. Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Juda yembomanga tapu yema kinie, kanu yemane liku mundoringi ye awisili, yembo toli lou-pulsema kinie kopema kinie mengo Judasi kinie oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ou Yesusi molorumune naa wangi Yesusi Juda ye awilime lipe simbe nimbe panjerimu ye ⸤Judasini⸥ eno Yesusi yu ipulueli manda kanonge mele nimbe sipelie nimbendo: “Nane ye te kanopolie kangulumbo akumu Yesusi. Yu ambolko ka siku mengo pangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","⸤Aku yema⸥ oringi kinie ⸤Judasi⸥ yu Yesusi molorumune sumbi sipe ombalie “Rapai, nu akune angilienu lemo.” nimbe omba yu kangulorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aku terimu kinie kanokolie Yesusi liku ka siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aku teringi kinie kanopalie ⸤Yesusi-kinie⸥ nondoko angilieringi ye tenga lou pokete-napimu kulu topa wendo lipe Pulu Yemo popo tondoringi ye awili olandopamonga kendemande ye te yunge komu te topa laka lenderimu, aku komumu wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kanu kinie Yesusini ⸤yu ka singe oringi⸥ yemando nimbendo: “Na ‘yembo topa wa noli yere molemo.’ konopu lekolie na ka singendo yembo toli lou pulsema kinie kopema kinie mengo okomeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ulke tembele ⸤kerepulune we yemboma maku toko molemele⸥ koleana alieli eno pea molemolo kinie ungu mane sipu molio kinie na liku ka naa silimele kanumu. Nalo ⸤Pulu Yemonga⸥ bokune toringi molemo mele kamu wendo ombámonga enone tenge tekemele ulume wendo okomo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kanu kinie yu lombili andolime pali ⸤‘Olio pea ka singenje.’ ningu pilkulie⸥ yu munduku siye kolko eno talopa leko puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kango ye te múlu telu mindi pakopa Yesusi lombili andorumu. Kanu kangomo ⸤Yesusi ka siringi yemane⸥ amboloringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yunge múlumu ⸤mindi⸥ ambolko molangi, melte naa panjipe we-we talopa lepa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kanu kinie Yesusi ⸤ka sikulie⸥ Pulu Yemo popo tondoringi ye awili olandopamo molorumune mengo puringi. Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga tapu yema kinie, ⸤Pulu Yemonga⸥ ungu manemanga pulume pilku mane siringi yema kinie, enone pali ⸤‘Yesusi kote tendepo piliemili.’ ningu⸥ akune ongo maku toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesusi ⸤mengo puringi⸥ kinie Pita lombili akilipe taka lipe pupe, Pulu Yemo popo tondoringi ye awili olandopamonga ulkena, ulke angilipe makapu terimu, awi suku singine yembo maku toringi kolea we lierimune paa sukundu pupe, ⸤Yesusi nokoko moloringi⸥ ele yema kinie tepe pilipe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga kanjollo yema pali kinie, akumene Yesusi yu toko kondongendo ulu te tepa kenjerimu ulu te ‘Yembo tene ‘yu isipe isipe tepa kenjerimu.’ nipili.’ ningu yembo te kororingi nalo yembo te naa kanoko lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yembo awisilini ongo ungu mare kolo toko “I sipe isipe tepa kenjerimu.” niringi nalo enonga ungume kapola naa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kanu kinie ye marene yu tepa kenjerimu mele ola angilku kolo toko ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“I yemo isipe nirimu pilierimulu: “I ⸤Pulu Yemo popo toko kalemolo⸥ ulke tembelemo, mana yemane takoringimu nane topo tekisipulie mana yemane manda naa takonge ulke te wale yepoko omba pupili kolo wangopo takombo.” nirimu. ⸤Yuni aku nirimumunge ‘Yu Pulu Yemo mele molio.’ konopu lepalie aku nirimumu nimbe kenjerimunje⸥.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eno kepe laye lupe lupe niringi, enonga ungume kapola naa laterimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aku niringi pilipelie Pulu Yemo popo tondoringi ye awili olandopamo eno maku toringine ola angilipe Yesusi walsipelie nimbendo: “Ungu te topondoko naa nikinuye? Nu teko kenjerinu mele nikimilimu nambolka ulumu teko kenjerinumundu nikimiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nalo Yesusi ungu te topondopa naa nimbe we angilierimu. Pulu Yemo popo tondoringi ye awili olandopamone yu altopa walsipe pilipelie nimbendo: “Pulu Yemone olio ‘Nokopa kondomba ye te lipu mundumbo.’ ou nimbe mako torumu ye nomi Kirasimu sike nu molo moloye? Kapi Nimbu Imbi Lipu Ola Mundundulimolomonga Malo nu molo moloye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesusini nimbendo: “Akumu na.” nirimu. “Pe walse Manie Omba Mana Ye A Lierimu Yemo, Ye Tondolo Olandopa Pulimu ⸤kinie melema nokombando⸥ yunge ki-umbukundu molopa, kupemanga ola molopa manie ombá eno kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aku sipe nirimumunge ⸤yu ‘Pulu Yemo mele molio.’ nimbe nirimu kulu⸥ pilipelie Pulu Yemo popo tondoringi ye awili olandopamone ⸤paa pilipe keri pilipe⸥ yunge wale pakolimu yuyu ambolopa sungu sipelie nimbendo: “Kinié yuni mongo lsimu mele nimbe simbe yembo te pea nambemune koromoloye? ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yu yuyu paa sike Pulu Yemo ungu taka tondokomo pilkimulu. Nambolka konopu lekemeleye? ⸤Yu-kinie nambe-eamiliye?⸥” nirimu kinie enone ningendo: “Yu Pulu Yemo ungu taka tondomumunge topo kondomulu liemo papu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kanu kinie enonga ye marene yunge kumbikerena olkambe toko munduku, yunge kumbikeremo múlu tene pipi sindikulie ki-lumuni toko ⸤“Nu ‘Pulu Yemonga yere molio.’ konopu leno kene⸥ nawene nu tokomonje ningu si!” niringi. Ele yemane yu liku larauwene toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kanu kinie Pita ulke maniekondo, yemboma liku maku toko moloringi koleana molorumu kinie Pulu Yemo popo tondoringi ye awili olandopamonga kendemande ambo te Pita molorumune ombalie ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","yu tepe pilipe molorumu kanopalie neme-neme nimbe kanopalie nimbendo: “Nu kepe Nasarete ye Yesusi kinie pea tapu toko moloringi kanumenga ye te lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pitane kolo topalie “Molo!” nimbe “Nu nikinu mele na naa pilkiru!” nirimu. Aku sipe nimbelie ulke kerepulune purumu kinie kera gulta ko torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita yu ulke kerepulune pupe molopili kanu kendemande ambomone yu kanopalie akune angilieringi yembomando altopa nimbendo: “I yemo Yesusinge talape ye te lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitane altopa “Molo!” nirimu. Laye-kolte pe mele Pita angilierimune nondoko angilieringi yemane ⸤yu ungu laye lupe mele nirimu pilkulie⸥ yundu ningendo: “Kolea Gallilli disiriki yembomane ungu nilimele mele nu aku siku ungu nikinu pilkimulu. ⸤Yesusi kinie yu lombili andoli yema kinie kolea Gallilli disiriki yemala,⸥ nu kepe Gallilli ye te, aku kene ‘Nu paa sike yu lombili andoli ye te.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aku niringi kinie Pitane Pulu Yemonga imbi lepa tondolo mundupe mi lepalie nimbendo: “Paa sike nikiru. Eno nikimili yemo paa naa kanolio! Kolo tokoro liemo Pulu Yemone na topa kondopili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aku nirimu kinie tamburumbu kera gulta wale talo sipe ko torumu. Aku terimu kinie pilipelie Yesusini yundu “Kera gulta wale talo sipe ko naa topili nuni wale yepoko kolo tokolie “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilierimu. Pilipelie ⸤‘Ama, paa tepo kenjendu lepamo. ‘Paa naa tembo.’ konopu lierindu mele sike tendu.’ nimbe pilipelie⸥ kola paa awili tepa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ipulueli-ou kolea kokele tangorumu kinie Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga tapu yema kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, kanjollo yema pali, ⸤Yesusinge kotemo pilku pora sikulie⸥ enone pali ⸤yu tenge mele⸥ ungu te ningu panjeringi. Aku ningu panjikulie yu liku, ka toko, mengo puku, ⸤Romo gapomano ye nomi⸥ Paillate molorumune mengo puku kote tenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paillatene ⸤Yesusinge kotemo pilipelie⸥ yu walsipe pilipelie nimbendo: “Nu Juda yembomanga ye nomi kingimu molo moloye?” nirimu. Yesusini topondopa nimbendo: “Sike nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pulu Yemo popo tondoringi ye awilimene Yesusi kote tendeko Paillatendo ⸤kolo toko⸥ ungu awisili ningulie ningendo “Yesusi yu tepa kenjilimo.” ningu yu kote tenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aku niringimunge Paillatene Yesusindu nimbendo: “Nu ulu keri awisili terinu nikimili mele pilkulie ungu te topondoko naa nikinuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nalo Yesusi ⸤yu tepa kenjerimu niringi mele⸥ pundu topa ungu telu kepe naa nimbe ⸤karaye naa tepa we angilierimu kinie kanopalie⸥ Paillate mini-wale mundupe konopu awisili lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","⸤Yesusi kote tendeko molangi,⸥ ye te, yunge imbi Barapasi, yu kinie ye mare kinie ‘Romo gapomanomone olio Juda yemboma naa nokopili.’ ningu ou Romo gapomanomo kinie opa tekolie yembo mare toko kondoringimunge ka ulkena peringi. ⸤Ponie tenga tenga Juda yembomane kolea awili Jerusalleme ongo akune suku⸥ Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilingendo langi noringi walema wendo orumu kinie enone ka ulkena perimu ye te imbi leko ‘Wendo liku mundou.’ ningu mawa teringi kinie ⸤Romo gapomano ye nomimuni⸥ kanu yemo wendo lipe yemboma sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","⸤Romo ye nomimuni kanu walemo wendo orumu kinie aku terimu mele pilkulie⸥ yemboma ongo yundu mawa tekolie ningendo: “Ou ponie telu telu ningu iwalemo kinie teleno mele kinié kepe aku siku teani.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aku niringi pilipelie Paillatene enondo walsipelie nimbendo: “‘Juda yembomanga ye nomi kingimu wendo lipu eno siembo.’ konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","⸤We yembomane Juda yembomanga ye awilime munduku siye kolko enonga ungume liku su siku Yesusinge ungumu pilku yu lombili andoringimunge⸥ Pulu Yemo popo tondoringi ye awilimene Yesusi-kinie konopu keri panjikulie kote tenderingi-ne pilipelie Paillatene aku sipe nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nalo Pulu Yemo popo tondoringi ye awilime we yemboma kondi toko ungu umbu tondokolie “ “Yesusi molo. Barapasi wendo lipe sipili.” niee!” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aku niringi kinie pilipelie Paillatene enondo nimbendo: “Aku liemo ‘Judamanga ye nomi kingi’ nilimelemo nambe-eambonje.” nimbe walserimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","enone tondolo munduku ningendo: “Yu unjo perana kolopili uku toko panjei!” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aku niringi pilipelie yuni enondo nimbendo: “Aku nambemuneye? Yu mongo nambolka mongore limuye?” nirimu. Nalo enone ⸤altoko⸥ paa tondolo munduku ningendo: “Molo! Yu kolopili, unjo perana uku toko panjei!” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kanu kinie Paillatene ‘Na-kinie konopu peanga leangi.’ nimbelie ye Barapasi ka ulkena wendo lipe eno sirimu. ⸤Aku tepalie⸥ Yesusi lipe ⸤yunge ami yema⸥ sipelie nimbendo: “Yu ka-pulsene tokolie pe ‘Unjo perana kolopili.’ ningu mengo puku unjo perana uku toko panji-pee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kanu kinie ⸤Romo⸥ ami yemane Yesusi liku gapomano ye nomimu perimu ulke awili akune suku yemboma liku maku toringi koleana pukulie, enonga ami talape yema pali “⸤Yesusi ya molemona⸥ sukundu sukundu waa.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Akune ongolie niringimuni ‘Yu ye nomi kingi te none tepili.’ ningu mulumbale kondoli peanga te pakondoko unjo ka koko molorumu te mulkupiye teko ‘Yenomi kingimunge waniemo.’ ningu pengena mere mundunduku, ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","pe yu ⸤ungu taka tondoko⸥ imbi we kólo toko liku ola mundundungendo “Juda yembomanga ye nomi kingimu, nu angilinoye?” ningu ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","⸤koló kope liku⸥ yu pengena kope to-pou-pou tekolie kumbikerena olkambe toko kandoko, yu angilierimune ongo koporongo langoko tamalu peko yu we kólo toko kapi ningu imbi liku ola mundundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yu aku siku ungu taka tondoko pora sikulie mulumbale kondolimu kulunduku yunge ou panjerimu mulumbalema altoko panjindikulie “Yu unjo perana kolopili uku topo panji-pemolo.” ningu yu liku ulsukundu meli puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","⸤Romo ami yemane Yesusi Jerusalleme pala ulsukundu mengo punge pukulie niringimuni,⸥ kolea Sairini ye te, yu Allekesanda kinie Rupasiselonga lapa Saimono, yu Jerusalleme pumbe orumu kinie kanokolie yu ambolko liku ka mele siku Yesusi kolomba unjo peramo “Kolo wangoko mendei!” ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pukulie kolea Golkota Yesusi mengo puku akune moloringi. (Golkotanga ungu pulumu ‘penge ombele lieli koleamo’.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","⸤Yesusi akune mengo pukulie niringimuni, ‘Yemboma mindili naa nangi.’ ningu⸥ no-waenena suku marasini ‘mo’ nili te munduku noseringi aku no-waenemo ‘Yu nopili.’ ningu, siringi nalo naa lipe norumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kanu kinie ⸤ami yemane⸥ yu unjo perana ola uku toko panjikulie unjomo liku ola anjeringi. ⸤Aku tekolie, ouunjona ola uku toko naa panjikulie⸥ yunge mulumbale ⸤kulunduku noseringime⸥ ‘Moke teamili.’ ningu eno yu mele mele linge mele pilingendo kou-kate teko pe mulumbalema lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ena topa nane killoko terimu kinie yu unjo perana panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","‘Yu mongo lsimu mele yemboma kanangi.’ ningu IYEMO JUDA YEMBOMANGA YE NOMI KINGIMU ningu imbi toko unjona ola mondoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Opa tekolo melema wa lsingili ye talo pea unjo talonga uku toko panjeringila. Te Yesusi yunge ki-umbukundu uku toko, te ki-tarokondo uku toko panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Aku teringimunge ungu te ou Aisayane nimbe boku torumu mele wendo orumu. Aku ungumu isipe: “Yu kinie yembo mongo liku ulu pulu kerime teli yemboma kinie liku tere leko mako toringi.” nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Akune ongo puringi yembomane Yesusi ⸤kanoko keri kanokolie yu⸥ ungu taka tondoko iri mele tokolie ningendo: “Aa! “Ulke tembelemo tekisipulie altopo wale yepoko omba pupili takopo limbo.” nirinu yemo, ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","‘Naa kolambo.’ ningu nu nunu liku tapondoko unjo perana manie ou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aku sikula Pulu Yemo popo tondoringi ye awilime kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie enone kepe yu ungu taka tondokolie ningendo: “Yu yembo wema ‘Naa kolangi.’ nimbe lipe tapondorumu nalo yu yuyu ‘Naa kolambo.’ nimbe manda naa lipe tapondokomo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yu sike Pulu Yemone olio ‘Nokopa kondomba ye te lipu mundumbo.’ ou nimbe mako torumu ye nomi Kirasimu omba molopa, yu sike olio Isirele yembomanga ye nomi kingimu molemo liemo yu yuyu unjona manie opili. Yu yuyu manie ombá kinie kanopolie ‘Yu sike Pulu Yemone mako topa lipe mundorumu ye nomi Kirasimu. Yu sike olionga ye nomi kingimu.’ nimbu tondolo mundupu pilimolo.” niringi. Ye talo yu-kinie unjoselonga uku toko panjeringi yeselone yu aku siku ungu taka tondoringilila. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","⸤Yesusi unjona ola we angiliepili⸥ awi-tangoli ena tuwellepo killoko terimu kinie kolea pali sumbulu topalie, pe ipupene ena tere killoko terimu kinie kelepa tangorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ipupene ena tere killoko terimu kinie Yesusini ru nimbelie nimbendo: “Elloi, Elloi, llama sapakatani.” nirimu. Akumu Juda yembomanga ungu te. Akumunge ungu pulumu isipe: “Nanga Pulu Yemo, nanga Pulu Yemo, na nambemune munduku siye kolonuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akune nondoko angilieringimenga marene yuni akunirimu kinie pilku ⸤sundukulie⸥ ningendo: “Pilieme! Yu Illainja walsikimu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aku nirimu kinie pilieringimenga ye te lkisipe pupe ulú-pinje mele te lipe no-waene kombili teli mare akune panjipelie, ‘Yesusi no-waene kombili teli pinjena pelemomo nopili.’ nimbe memba omba unjo pepena tenga ka topa olando sirimu. Sipelie yuni nimbendo: “Kinié unjona we angiliepili. Illainjane sike yu ⸤unjona⸥ manie limbendo okomonje, kanopo kanamili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesusi ungu te tondolo mundupe nimbelie kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","⸤Romo⸥ ami ye wane anderete nokorumu ye te Yesusi toringi ami yema nokopa molorumu kanu yemone Yesusi ungu te nimbe kolorumu mele pilipe kanopalie nimbendo: “I yemo yu paa sike Pulu Yemonga malo lepamo.” nirimu. ⸤Yesusi aku sipe kolorumu kinie ulu awili te walsikele wendo orumu.⸥ Pulu Yemo popo toko kaloringi ulke tembele ⸤Jerusalleme suku angilierimu akune sukundu Pulu Yemo molorumu⸥ Suluminia Paa Kake Telimunge kerepulune ⸤‘Yemboma sukundu naa pangi.’ ningu ou alieli⸥ mulumbale awili tene pipi siku panjeringi angilierimu. ⸤Yesusi kolopa pora sirimu kinie⸥ kanu mulumbalemo awi-suku-singine olakondo maniendo sipe olá torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ambo mare ⸤Yesusi toringi mele⸥ sulu teko kanoko angilieringi. Enonga ambo te Makatalla taono ambo Maria, te Josese kinie angenu Jemisi kinie elonga anumu Maria, te ambo Sallomi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesusi kolea Gallilli disiriki, ⸤kanu ambomanga pulu kolea,⸥ akune ou we andorumu kinie kanu amboma yu lombili andoko liku tapondoko nokoringi. Yu kinie, Jerusalleme olando oringi ambo awisili wema kepe, ambo pokore kanoko angilieringi akune eno kepe ⸤Yesusi toringi mele⸥ kanoko angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Opalikundu ⸤Juda yembomanga koro moloringi⸥ wale Sambatemo nondopa wendo ombá terimu. Sambate walemo wendo ombá kinie koro molongendo kinié mele melema liku undu-undu siringi walemo wendo orumu, aku walemonga ⸤Yesusi ou kolopili⸥ kolea kala tomba terimu kinie, ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatia taono ye Josepo, yu Juda yembomanga kanjollo ye awili te molopa, yu kepe ‘Pulu Yemo ye nomi kingimu molopa olio nokomba walemo wendo opili.’ nimbe nokopa molorumu yemo. Yu omba pipili naa kolopa ⸤Romo gapomano ye nomi⸥ Paillate molorumune sumbi sipe pupe “Yesusinge onomo na si.” nimbe mawa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesusi walsikele kolorumu pilipelie Paillate yuni ⸤‘Yemboma unjo perana uku topo panjilimolo kinie ena awisili omba pupili we pelemele. Pe kinié yu sike walsikele kolomunje molo nambe-emunje?’ nimbe pilipe⸥ konopu lipe mundupe ami ye wane anderete nokorumu yemo “Opili.” nimbelie yundu walsipelie “Yesusi koronga kolomuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ami yema nokoli yemone “E.” nirimu kinie pilipelie yuni ami yema nokolimundu nimbendo: “Kapola, ya yemone ⸤Yesusinge⸥ onomo lipili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","⸤Paillatene “Kapola.” nirimu kinie⸥ Josepo pupe mulumbale te topo topa lipe onomo manie lipe, múlumuni kulupi topalie kou kande te akuku noseringi kou kandemonga suku memba pupe noserimu. Nosipelie kou kande kerepulune kou awili te perele-marele memba omba pipi sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makatalla taono ambo Maria kinie Josese anumu Mariaselone yunge onomo ⸤kou kandena⸥ noserimu mele kanoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena pupe ipu lierimu kinie ⸤Juda yembomanga koro moloringi⸥ wale Sambatemo omba purumu kinie Makatalla taono ambo Maria keme Jemisi anumu Maria keme ambo Sallomi keme enone ‘Yesusinge onona kopongo wele mune toli pokore ape kandondamili.’ ningu mare topo toko liku ⸤nosiku peringi⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pekolie paa ipulueli-ou, enonga pulu-pulu kongono walemo wendo ombando ena mundi orumu kinie kanu amboma puku ⸤Yesusinge⸥ onomo noseringi kou kandena punge pukulie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","anjo yando walsikulie ningendo: “Kou-kande kerepulumu pipi siringi koumu nawene wendo lipe perele marele memba pupe nosindimbenje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nalo ongo olando siku kanoringi kinie kou kanumu, paa kou kapo awilimu, ou wendo liku perele marele mengo puku noseringi, ⸤kerepulumu we lierimu⸥ kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kou kandena suku pukulie kou kandemonga ki umbukundu ye kango te mulu-maminia sulu paa kake te pakopa molorumumu kanokolie mini-wale munduku konopu liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kanu kinie yuni enondo nimbendo: “Konopu liku naa mundeyo. Kolea Nasarete ye Yesusi ‘Kolopili.’ ningu talko unjo perana uku toko panjeringi kanu yemo kanonge okomelemo na pilkiru. Yu lomboropa ola molopa omba pumu. Ya naa lemo. Onomo ou noseringi koleamo ongo kaname. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kanokolie anjo puku Pita keme yu lombili andolime kinie pali i siku ningu siengi: “Yesusi kolea Gallilli disiriki kumbi lepa pulimo kene akune “Eno na kanonge.” ou nirimu mele sike eno akune yu kanonge.” ningu si-pee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","⸤Angellomone aku sipe omba mona molopalie nirimu mele⸥ kanoko pilkulie amboma pungu-pungu ningu konopu awisili liku mundukulie kou-kandena ulsu puku munduku siye kolko paa lkisiku puringi. Pipili kolkolie yembo telu kepe kanoko pilieringi mele ningu naa siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Juda yembomanga pulu pulu kongono walemo kinie, paa ipulueli-ou, Yesusi lomboropa ola molopalie nirimumuni, ulke kolea Makatalla ambo Maria, ou walse kuru yepoko pakera konopune moloringime Yesusini topa makororumu ambo kanumu molorumune pupe ⸤‘Na lomboropo ola molondu we molio mele kanopili.’ nimbe⸥ lipe ora sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kanu kinie Yesusi ⸤mona angilierimu⸥ kanopalie ambomo yu pupe, ou Yesusi kinie moloringi yemboma kamele mindili nongo kola teko moloringine pupelie kanorumu mele eno nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yuni eno Yesusi konde molorumu mele kanopalie nimbe sirimu kinie pilkulie ‘Yu kolo tokomo.’ ningu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","⸤Makatalla ambo Maria Yesusi yu lipe ora sipelie nirimumuni,⸥ pe ⸤yu lombili andoringimenga⸥ yembo talo ⸤ulke kolea awili Jerusalleme munduku siye kolko⸥ aulke tenga puringiline Yesusi yu kumbikere kangi alowa tepa ‘Na kanangili.’ nimbe omba mona angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe yu kanoko imbi sikululie kanu yemboselo kelko yando ongolo ⸤lombili andoli⸥ wemando elone kanoringili mele ningu siringili nalo elone ningu siringili mele kepe ‘Kolo tokombele.’ ningu pilieringila. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pe walse lombili andoli rureponga yepoko langi nongo moloringine Yesusi omba mona molopalie nirimumuni, eno iri topalie nimbendo: “Enone na ‘Lomboropa ola molomu.’ ningu tondolo munduku naa pilku, na konde molondu mele yembo marene kanokolie eno ningu singi kinie ‘Kolo tokomele. Aku paa naa temu, manda naa temba.’ ningu piliengi, akumu nambemune aku siku karaye teko ningu piliengiye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","⸤Aku nimbelie⸥ yuni enondo nimbendo: “Eno ma koleamanga pali puku yemboma pali temane peangamo toko siliku ando-payo. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ninge mele pilkulie ‘Akumu sike nikimili.’ ningu tondolo munduku pilkulie no linge yemboma ⸤kote walemo wendo ombá kinie⸥ Pulu Yemone eno lipe tapondopa ‘Eno mindili nolemela koleana naa puku, molko kondoko mindi pangi.’ nimbé. Nalo ⸤enolombili andolimene⸥ ninge mele pilkulie ‘Akumu kolo tokomele.’ ningu pilkulie liku su singe yemboma ⸤kote walemo wendo ombá kinie⸥ Pulu Yemone ‘Eno mindili nongo mindi punge koleana pangi.’ nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“‘Aku temanemo sike.’ ningu tondolo munduku pilinge yemboma ‘Na eno kinie sike molio we yembomane ningu kanangi.’ nimbo kinie ulu tondoloma tenge kinie yemboma kanonge mele isipe: Eno nanga tondolomone kuru mare yembomanga konopune molongema toko makoroko; umbu-ungu lupe lupe naa pilingema ningu; ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yembo nongo kondoli kongi ka wambiyema naa kanoko kimuni ambolonge kinie akumene eno naa nongo kondonge; tomo pelemo no te naa pilku nonge kinie uluri paa naa temba; kuru tomba yemboma kimuni ambolonge kinie konde punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Awili Yesusini ⸤yu lombili andolime⸥ ndo aku sipe nimbe pora sirimu kinie ⸤Pulu Yemone⸥ yu mulu koleana olando lsimu. Akune ⸤imbi ola molopili Pulu Yemo-kinie melema nokombando⸥ Pulu Yemonga ki-umbukundu pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesusi yu mulu koleana olando purumu kinie yu lombili andolime koleamanga pali puku Yesusinge temane peangamo yemboma toko siliku andoringi kinie ‘Enone nanga ungume yemboma ningu singe kinie kanu yembomane ‘Ungu sikemo.’ ningu pilku liengi.’ nimbe Awilimu eno kinie pupe lipe tapondorumu kinie yuni lipe mundorumu yemboma enone ‘Pulu Yemone mindi ulu tondoloma manda telka teangi.’ nimbe lipe tapondorumu. ⸤Aku pea.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ye paa awili Tiopillasi, olio molemolo koleana Yesusi kinie ulu wendo orumume pulu-pulu wendo orumu kinie kanoko, yandopa wendo orumume kanoko andoko moloringi yembomane pe olio temane toko siringi mele, aku temanemo ‘Sike.’ nimbu tondolo mundupu pilimolo kanumu yembo awisilini ‘Aku temanemo bokune kamu molopili tamili.’ ningu boku toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Akumunge pe kelepo nane kepe “Temanemonga pulumu paa pilipu kondambo.’ nimbu ou pulu pulu wendo orumu mele kepe yandopa ulu lupe lupema wendo orumu mele kepe akume pali walsipu pilipu kondopo molorundu-ne nane ‘Aku ulumendo yembo marene Tiopillasi nundu temane toko ungu mane silimele mele aku sipe wendo orumu ulume nu piliéni.’ nimbu, ‘Nane nundu ulumenga pali paa sike wendo orumu mele temane topo nimbu siembo.’ nimbu, boku topo nu simbo kinie papu.’ nimbu pilipulie aku temanemo topo ibokumu tokoro. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ye Nomi Kingi Erote kolea Judia nokopa molorumu kinie Pulu Yemo popo tondorumu ye te molorumu, yunge imbi Sekaraya. Pulu Yemo popo tondoringi yembomanga talape tenga imbi Apaya, Sekaraya yu kanu talapemonga ye te. Sekaraya menu ambo Illisapete Pulu Yemo popo tondoringi yemanga talape tenga ambo te. Elonga pea pulu-pulu anda kolepamo Pulu Yemo popo tondoringi yemanga pulu-pulu ye nomi awili Erono. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aku ambo yeselo moloringili mele Pulu Yemone kanopa ‘Yembo sumbi niliselo.’ nimbe kanorumu. Elone yunge ungu manema kinie “Yemboma teaa.” nirimu ungume pali pilku liku teko kondoko moloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nalo Illisapete we waengono perimu, ambolango te naa meringili. Elo we ambou anda leko moloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Walse Sekarayanga talapemone Pulu Yemo popo toko kaloringi kongono tenderingi kinie yu kepe pea Pulu Yemonga kumbikerena kanu kongonomo tenderingi. Aku tendeko molkolie niringimuni, Pulu Yemo popo tondoringi yemane teringi mele tengendo enonga talapena ye te Pulu Yemo popo toko kaloringi ulke tembele akumunge suluminiana suku ‘Nawe pupe mune tolemo paura kekumu yembomanga nimbe kalondombanje piliemili.’ ningu kou-kate teringi. Aku tekolie ‘Sekaraya yu kanu kongonomo tendemba.’ ningu kanoringi kulu yu ulke tembele suluminiana suku pupe mune toli paura kekumu kalondo-porumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aku tepa angilierimu kinie ulke tembelena we yemboma maku toko Pulu Yemo popo toringi koleana yembo awisili Pulu Yemo kinie ungu ningu angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","⸤Sekaraya mune toli paura kekumu kalondopa angilierimu kinie⸥ kanu paura kekumu kalondo-pou-pou teringi polomonga ki-umbukundu Awilimunge angello te omba mona angilierimu kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Akumu kanopalie pungu pungu nimbe pipili awili tepa kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kanu kinie angellomone yundu nimbendo: “Sekaraya, pipili naa kolou.” nirimu. “Nu Pulu Yemo kinie mawa teleno mele Pulu Yemo yuni pilierimu. Nunge ambomo kango te kanopa limbe. Yunge imbi “Jono” ningu leani. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yu molombamonga nu konopu awili teko siku kamele akoko moloni. Yu mengele kinie yembo awisili konopu singe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Awilimuni yu kanopa ye awili peangamo nimbe kanomba. No waene kinie no tondoloma kinie walsikele kepe paa naa nopili. Anumunge olona we sukundu molomba kinie Pulu Yemonga Mini Kake Telimu omba yunge konopune molopa kapola temba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“I sirele yembomane enonga Awili Pulu Yemo liku bulu siringi yembomanga awisili Jonone tembamonga altoko konopu alowa teko Awili Pulu Yemo pea altoko pilku kapola kapola molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","⸤Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye⸥ Illainja tondolo pepili ulume tepa molorumu mele Jono yu aku sipe tondolo pepili ulume tepa molomba. Aku sipe tondolo pepili ulume tepa molombamonga lapalini konopu alowa teko ambolangoma kelko konopu mondongela; Pulu Yemonga ungu manema liku su silimele yembomane konopu alowa teko, konopu sumbi nili yembomane telemele mele ‘Aku sipu teamili.’ ningu molongela; Jono yuni tembamonga Awilimu ombá kinie Awilimu yunge ungumu sumbi siku pilku linge yembo talape te molongela.” nimbe angellomone Sekarayando nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aku nirimu kinie pilipelie Sekarayane angellomondo walsipelie nimbendo: “Aku nikinumu nambepo nane ‘Sike nikinu.’ nimbu pilimboye?” nirimu. “Na anda lepo nanga ambomo ambou lierimu kanumu. Pe inikinumu nambepa wendo ombamondo nikinuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angellomone topondopa nimbendo: “Nanga imbi Geperiele. Na Pulu Yemonga kumbikerena angilio. Ikinié nundu nikiru mele Pulu Yemone “Aku siku ni-pou.” nimbe lipe mundomu-ne nundu ombo itemane peangamo topo sikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nalo nane “Kango mengele.” nikirumu ‘Kolo tokomonje?’ ningu pilkinu kene iulumu ou wendo naa opili nu ungu naa nili moloni. Pe “Wendo ombá.” nikiru mele amboma ambolango olona mondokolie melemelemanga walema omba pulimo mele aku sipe walema omba pumbe kinie inikiru ungumu paa sike wendo ombá.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aku siku ungu ningu angiliengili Sekaraya ulke tembelemonga suluminiana sukundu koronga-ou pupe molopa, welea wendo naa orumu kulu yemboma ulsukundu yu nokoko angilieringime konopu awisili liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kanu kinie yu wendo ombalie nirimumuni, ungu te kerena manda naa nimbe kimuni mindi manda manjipe angilierimu kinie kanokolie, ‘Sekaraya yu suluminiana suku molopalie melte omba angilieli none tepa kumbikere lipe pinjemu-ne kanomu.’ konopu lieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pe ulke tembelena yunge kongono walema pora nirimu kinie yunge ulkendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ulkendo pupe ⸤ambo Illisapete kinie pekolo moloringili kinie⸥ pe Illisapete ambolango olona mondorumu. Mondopalie oli kise pakera ‘Yembomane yu naa kanangi.’ nimbe lopi tepa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yuni nimbendo: “Kinié na-kinie ulu tekemomo Awilimuni nanga nimbe tendekemo. Na ambolango te naa merindumunge yemboma na kanoko keri kanoringi kinie pipili kolorundumunge Awilimu yuni na kondo kolomu lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","⸤Illisapete ambolango olona mondopili oli kise pakera kolopa⸥ talo pakera sipemo ke topa angilierimu kinie Pulu Yemone mulu koleana angello Geperiele kolea Gallilli disiriki Nasarete taonona lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kanune ambo wenepo te, ye te kinie ou naa peli we molorumu ambo wenepo te molorumune mundorumu. Kanu ambo wenepomo yunge pulu lierimu yembomane ‘Yu ye te pupili.’ ningu mako toringi yemonga imbi Josepo. Kanu yemo yunge anda kolepa te ⸤ye nomi kingi⸥ Depisi. Ambo wenepomonga imbi Maria. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maria molorumune angello Geperiele ombalie yundu nimbendo: “Ambomo, nu molonune na okoro. Nu malo. Awilimu nu pea tapu toko molembele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nalo kanu ungumu pilipelie yu konopu awisili lipe mundupelie, ‘A! Inikimumu nambolka unguri nimbe nikimunje?’ nimbe pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angellomone yundu nimbendo: “Maria, Pulu Yemone nu kanopa peanga kanokomo kene pipili naa koloyo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pílie. Nu pe olona kango te mondokolie menimu. Mengolie yunge imbi “Yesusi” ningu leani. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yu ye nomi molomba, yu imbi leko ‘Paa Olandopa Molemomonga Malo.’ ningela; Awili Pulu Yemone ‘Yunge anda kolepa Depisi Isirele yembomanga ye nomi kingi tondolomo molorumu mele yu aku sipe molopili.’ nimbéla; ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Enonga anda kolepa Jekopone kalopa lsimu yemboma yuni kamu-kumu nokombala; Yu ye nomi kingi awilimu molopa mindi pumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariane angellomondo nimbendo: “I nikinu ulumu nambepa tembamondo nikinuye? Na ye te naa purundu kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angellomone yundu nimbendo: “Nu molonine Paa Olandopa Yemonga Mini Kake Telimu omba nunge olona kango te mondondomba. Aku tembamonga kango nuni menimu yu kango kake telimu molomba; yu imbi lekolie ‘Pulu Yemonga Malo’. ningela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","⸤Pulu Yemone nu “Tembo.” nikimu mele sike temba. Ulu tondolo te “Tembo.” nimbelie terimu mele niembo.⸥ Nunge pulu lemo ambo Illisapetendo “Ambo waengono pelemo.” nilimele nalo kinié yu ambo ambou liepili oli kise pakera kolopa talo pakera sipemo ke topa angiliepili yu kango te olona mondokomo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pulu Yemone ulu manda naa temba ulu te paa naa pelemo. Yuni ulume pali kapola telemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","⸤Angellomone yundu aku sipe nirimu kinie pilipelie⸥ Mariane nimbendo: “Na Awilimunge kongono kendemande ambomo molio. Nuni nikinu mele Pulu Yemo yuni na-kinie aku sipe tepili.” nirimu. Kanu kinie angellomone Maria mundupe siye kolopa yupurumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","⸤Mulu koleana angellomone Mariando ungu nimbe pora sipelie kelepa purumu kinie⸥ pe Maria kolea Judia disiriki pupe ma pangi tenga ola taono te lierimune purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pupe akune ye Sekarayanga ulkena suku pupelie ambo Illisapete kanopa “Na okoro.” nirimu kinie kanguloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Illisapetene Marianga ungumu pilierimu kinie Illisapete yunge olona ambolangomo pukue topa ola manie terimu pilierimu. Kanu kinie Pulu Yemonga Mini Kake Telimu Illisapetenga konopune pupe molopa kapola terimu kinie “I siku i siku ni.” nirimu mele ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Illisapetene ungu tondolo tepa nimbelie nimbendo: “Ambo molemelemanga pali nu malo. Ambomanga pali Pulu Yemone nu olandopa tepa kondorumu. Ambolango nu olona mondolenomo kepe yuni tepa kondombala. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na ambo keri te molondune nanga Awilimunge anumu nu onumunge na konopu awisili lipu mundukuru. Aku tenumunge na-kinie teko peanga sikinu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu ongolie “Na okoro.” ninu-ne komuni piliendu kinie nanga olona molomu ambolangomo paa konopu sipe pukue topa ola manie temu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Awilimuni nundu nirimu ungumu pilkulie ‘Sike nikimu. Yuni “Tembo.” nikimu mele sike aku temba.’ ningu tondolo munduku pilierinumunge yuni nu tepa kondokomo mele tepa kondomba kene nu konopu siku molani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Illisapetene nimbe pora sirimu kinie Mariane nimbendo: “Pulu Yemo nanga Lipe Tapondopa, Mindili Nombo Molopo Kenjilio Aulkena Wendo Lipe, Kapola Molopo Kondombo Aulkena Lipe Mondomba Yemo kinie na konopu paa awili tepo sikirumunge nanga konopumuni Awilimu kapi nimbe imbi lipe ola mundundukumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pulu Yemo yuni yunge we ambo kendemande kerimu siye naa kolopa konopu lipe mundorumumunge nanga konopumuni aku sipe yu kapi nikimu. Yembomane pe pe kepe kalko linge yembomane nando “Pulu Yemone nu tepa kondokomo. Nu malo.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tondolo Pulimuni na ulu tondoloma tenderimumunge nando aku siku ninge. Tondolo Pulimu yu ye kake telimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yu-kinie pipili kolko pilku limele yemboma yu kondo kolopa molemo. Enone pe pe kepe kalko lingema kepe kondo kolopa molopa mindi pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yuni yuyu ulu tondoloma terimu. Yembo kara puku enonga konopune enono kapi ningu molemele yemboma yuni anjo anjo topa makoropa mundulimo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yemboma nomi molko koleama nokoko molemelema yuni topa manie mundupe, yemboma enonga imbime eno enono topa manie mundumbema yuni enonga imbime lipe ola mundundulimo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Engelene kolemele yemboma yuni ‘Olo tepili.’ nimbe langi peangama sipe, yembo kamakoma mele teluri kepe naa sipe “We paa.” nimbe makorolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yuni olionga pulu-pulu anda kolepalimendo “Tembo.” nimbe, nimbe panjerimu ungumu komu naa sipe pilipe molopalie, ⸤anda kolepa⸥ Eporayamo kinie, Eporayamo yuni yandopa yandopa kalopa lsimu yemboma kinie, enondo “Tembo.” nimbe, nimbe panjerimu mele tembando olio Pulu Yemo yunge kendemande Isirele yembo molemolo akume yuni kondo kolopa lipe tapondomba tepa molemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Illisapete kinie pea molangili oli yepoko omba purumu kinie pe Maria yu yunge ulke koleando kelepa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Illisapete ambolango memba walemo wendo orumu kinie yuni kango te kanopa lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yunge ulke kere pongolo yemboma kinie yunge pulu lierimu yemboma kinie Awilimuni yu kondo awili tepa kolorumu mele pilkulie eno yu pea konopu siku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wale yepoko pakera kangomo kanopa lipe nosipe molorumu kinie wale engaki sipemonga yemboma sukundu sukundu ongo maku tokolie yunge kangi te kopisiku makaye teko wendo liku ltekolie niringimuni, yunge imbimu yunge lapanga imbi manda manjiku “‘Sekaraya’ niemili.” niringi ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","nalo kangomonga anumuni “Molo.” nimbelie “Yunge imbi ‘Jono’ nimolo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Enone yundu ningendo: “Elonga pulu lemo yembo tenga imbi aku sipe naa molemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kanu kinie enone “Lapane nambolka konopu lekemone, yunge imbi lepa nawe nimbéne, walsipu piliemili.” ningu lapando kimuni manda manjeringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","yuni topondopa kimuni manda manjipelie “Boku siee.” nimbelie, yuni bokune topalie nimbendo: “Yunge imbi Jono.” nirimu. Akumu kanokolie yembomane paa konopu awisili lieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kanu kinie walsikele Sekaraya yunge kerena kelepa ungu nimbelie Pulu Yemo kapi nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aku terimu-ne kanokolie yunge ulke kere pongolo yembomane pipili paa koloringi. Kolea Judia disiriki ma pangime polorumu koleamanga pali aku temanemo mindi toliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aku ulumu pilieringi kinie yembomane pali konopu liku mundukulie ningendo: “Ulu akumu we naa telemo. Awilimu ikangomo-kinie molombamonga aku tekemo lemo.” ningu pilkulie “I kangomo pe nambepa molombanje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mini Kake Telimu Jono lapa Sekarayanga konopune omba molopa kapola terimu kinie Sekaraya yuni Pulu Yemone ungu umbu tondorumu ungu te pilipe, pe wendo ombá mele yemboma nimbe sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Awilimu, Isirele yembomanga Pulu Yemo, yu kapi nimbu imbi lipu ola mundundemili. Yu omba yunge yemboma lipe tapondopa umbune tene eno ambolorumu-ne mindili nongo moloringi kanu umbunemonga wendo limu-ne pilipulie aku teamili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pulu Yemo yuni yunge kendemande ⸤olionga ye nomi kingi⸥ Depisini kalopa lsimu yembomanga ye tondolo peli te olio ‘Lipe tapondopa mindili nombo molopo kenjilimolo aulkena wendo lipe, kapola molopo kondomolo aulkena lipe mondopili.’ nimbe simu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Yuni ungu umbu tondorumume pilku yando ningu siringi yemane pe tembamondo koronga ou ningendo:) ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Yuni olio lipe tapondopa olionga opa puluema topa mundundupe, olio kanoko keri kanoko mindili silimele yemboma ‘Aku siku naa teangi. Wendo ongo kapola molangi.’ nimbe aku siku telemele aulkena wendo limbe.” niringi mele kinié aku temba tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Olionga anda kolepalime kondo kolopa, olionga pulu-pulu anda kolepa Eporayamo kinie “Tembo.” nimbe, nimbe panjipe mi lierimu mele “komu naa sipu, nirindu mele teambo.” nimbelie aku temba tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Pipili naa kolko, nanga kongonomo tondolo munduku tendeko, konopu kake tepili molko nane kanopo peanga kanolio ulume mindi mana teko mololiku pangi.’ nimbelie olionga opa puluemane olio toko mindili silimelema ‘Naa teangi. Olio we molamili. Lipu tapondopo tokomele aulkena wendo limbo.’ nimbe, nimbe panjipe mi lierimu mele ‘Teambo.’ nimbelie aku tekemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nanga kango ⸤Jono⸥, nu kumbi leko puku Awilimu ombá aulkemo akisindenímunge pilkulie ningemone, yembomane pe nundu ‘Olandopa Molemomonga ungu umbu tondolime pilipe yando nimbe sili yemo.’ ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","‘Awilimu yunge aulkemo akisindembo.’ ningulie nuni yunge yembomando i siku ningu sini: “Awilimu yuni enonga ulu pulu keri telemelema ‘Manie pupili.’ nimbe siye kolopalie eno lipe tapondopa mindili nolemela aulkena wendo lipe, yu-kinie pea molko kondonge aulkena lipe mondomba.” ningu, aku ungumu enondo ningu sini. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Pulu Yemone olio kondo awili tepa kolopalie olio sumbulu toline molopo kololi aulkena molomoloma konopu pe nipili molomolo aulkena ‘Manda kanoko pangi.’ nimbe ‘Patendepili.’ nimbe olio molemolona patendelimu lipe mundukumu.” nimbe Sekarayane nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kango Jono yu awi lepa konopu tondolo pupe kapola molorumu. Yu pe Isirele yembomanga kumbikerena kongono tepa molombando ou kolea ku lieline pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","⸤Jono pamemo molopili⸥ Romo Gapomano Ye Paa Awili Kumbine ‘Sisa Okasitasi’ nilimuni ungu mane te nimbe panjipelie “Romo gapomanomone nokolemo koleamanga molemele yemboma pali imbi tamili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kiriniasi kolea Siria poropinji nokorumu yemo molopili Romo gapomanomone yembomanga imbime pulu-pulu torumu.) ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","⸤Ungu mane akumu Okasitasini nimbe panjerimu kinie⸥ yemboma pali enonga anda-kolepalimene kalko lsingi koleamanga yu mele mele eno puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ye Josepo kolea Gallilli disiriki Nasarete taonona molopa, ⸤Romo ye nomimuni ‘Yemboma imbi tamili.’ nirimu⸥ pilipelie nirimumuni, Nasarete mundupe siye kolopa, yu kalopa lsimu anda-kolepa Depisi ou perimu kolea Judia disiriki pupe Betellieme taonona purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akune “Oltonga imbiselo tangi pambili.” ningulu yu nondopa limbe ambo Maria kinie elo akune puringili. Maria ulke pelimu pea puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Betellieme suku pukululie, yembo ponenge ongo pe-pou-pou teringi ulkemo si nirimu kulu ⸤elo kongi dongi kinie kaoma panjeringi ulkena puku peringili. Akune peringili kinie⸥ Maria ambolango mini torumu. Pe kango te kanopa lsimu. Aku kangomo yunge komolayemo. Kanopa lipelie mulu wambale marene lipe kangomo okopa, kongime langi noli kete tenga suku noserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","⸤Betellieme⸥ ulsukundu kongi sipisipi tapu ye mare era poniemanga ipulueli enonga sipisipime tapu teko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kanu kinie eno moloringine Awilimunge angello te omba mona angilierimu kanoko, Awilimunge patondolo tepa telimu omba eno moloringi kolea paterimu kanokolie, eno mini-wale awili teko mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nalo angellomone nimbendo: “Nane eno temane peanga te topo simbo okoro kene pipili naa kolayo. Itemanemo yemboma pali konopu singe temanemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kinié ⸤ou molorumu ye nomi kingi⸥ Depisinge taonona ambo tene kango te memu. Yu Yemboma Lipe Tapondopa Mindili Nongo Molko Kenjilimele Aulkena Wendo Lipe, Kapola Molko Kondonge Aulkena Lipe Mondomba Kangomo; yu Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu; yu Awilimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sike nikiru molo kolo tokoronje eno puku kanangi mele nimbu siembo. Ambolango kiki te mulu wambalene okoko, kongime langi noli kete tenga nosengi puku kanoko lendenge. Aku siku kanoko lendekolie nane ‘Sike nimu lemo.’ ningu pilinge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aku nirimu kinie tamburumbu mulu koleana angello paa awisili ou orumu angellomo angilierimune ongo mona angilkulie niringimuni, Pulu Yemonga imbi liku ola mundunduku yu kapi ningulie ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mulu Koleana Paa Olandopa Pulu Yemonga imbi paa ola molopili. Mana yembo yuni kanopa peanga kanolemo yemboma, konopu waengo siku molangi.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aku ningulie eno kongi sipisipi tapu yema munduku siye kolko mulu koleana kelko olando puringi. Angelloma kelko mulu koleana olando puringi kinie sipisipi tapu yemane anjo yando ningendo: “Olio Betellieme pupu iulu kinié wendo okomo mele Awilimuni nimbe simumu kano-pamolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aku ningulie popenge teko pukulie niringimuni, Maria Joseposelo moloringili kanoko, ambolango kikimu kongimenga langi noli ketena suku lierimu kanoko lenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yu kanokolie, ou angellomone eno aku ambolangomondo nimbe sirimu mele yemboma ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kanu kinie sipisipi tapu yemane ningu siringi mele pilkulie yembomane konopu awisili liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nalo Maria iungume kinie ulu wendo orumume pali konopune panjipelie, pe kepe konopu kimbu sipe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisipi tapu yema kelko yando ongolie niringimuni, angellomone nimbe sirimu mele pali pilku kanoringimunge Pulu Yemo kapi niliku yunge imbi liku ola mundunduliku yando oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kangomo kanoko liku nosiku molangi wale yepoko pakera omba purumu kinie wale engaki sipemonga yunge kangi te kopisiku makaye tekolie, anumuni yu olona naa mondopili angellomone nirimu mele pilkulie yunge imbi “Yesusi” ningu lieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Josepo kinie Mariaselo, elo kamu kake tepili molongele walemo wendo orumu kinie, Mosisini ungu mane sirimu te pilku liku tengelendo kolea awili Jerusalleme pukululie niringilimuni, kake tepili molongelendo Pulu Yemo popo toko kalo-poringili. Awilimunge ungu mane te ou sirimu perimu akumu isipe: ⸤‘Ambo tene ambolango kanopa lipelie yu pena pemba mele molomba. Pena pemba walema pora nimbé kinie kake tepili molombando⸥ kera waembono mele talo molo kera imili mele talo Pulu Yemo popo topa kalopa sipili.’ nimbe ungu mane aku sipe nimbe perimu kanumu pilkulie tengelendo puringili. Awilimunge ungu mane nimbe perimu te pea pilku liku tengelendo puringilila. Aku ungu manemo isipe: ‘Kango komo kanoko lingema pali “Awilimunge” ningu yu siengi.’ nimbe perimu kanumu. Aku ungu manemo nimbe perimu kulu pilkululie ‘Oltonga kango komomo Pulu Ye Awilimu siembili.’ ningululie Jerusalleme pungelendo Yesusi mengo puringilila. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ye anda te Jerusalleme molopili elo puringili, yunge imbi Simiono. Yu sumbi nirimu yemo; yu Pulu Yemonga ungu pilipe alieli Pulu Yemo kinie ungu nirimu yemo; yu Isirele yemboma kapola kapola molangi omba tendemba yemo kanombando nokopa molorumu; Mini Kake Telimu yunge konopune sukundu molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mini Kake Telimuni yundu ungu te ou nimbendo: “Nu ou we naa koloni. Nu ou Awilimuni “Eno nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu ye nomi Kirasimu kanokolie pe koloni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mini Kake Telimuni Simiono yu lipe mundorumu kulu yu Pulu Yemo popo toko kaloringi ulke tembelena purumu. Kanu kinie Yesusi anumu lapaselo ungu manemone kangomando “Teaa.” nimbe sirimu mele tengelendo kango Yesusi mengolo ulke tembelena sukundu puringili kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simionone omba kangomo kangulupe lipe Pulu Yemonga imbi lipe ola mundundupelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ye Awili Tondolo Olandopamo, yemboma lipe tapondopa mindili nolemela aulkena wendo lipe nu-kinie pea molko kondonge aulkena lipe mondomba ye sikinumu na kinié nanga mongone kanokoro kinie ou nando ningu panjerinu mele wendo okomo kene kinié na nunge kendemande yemo konopu pe nipili kolombo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","“‘Kanu lipe tapondopa wendo lili ulumu koleamanga pali yembomane kanangi.’ ningu tekeno. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yu Isirele yembomanga ulsu molemele yembomanga patendepa, nunge Isirele yembomanga imbi lipe ola mundundumbendo patendeli mélemo molemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Anumu lapaselo Simionone kango Yesusindu nirimumele pilkululie konopu awisili liku mundoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionone “Pulu Yemone eno tepa kondopili.” nimbelie Yesusi anumu Mariando nimbendo: “Pílie. Ikangomo molombamonga Isirele yembo awisili imbi oumolorumume pe manie pungela; awisili imbi ou naa molorumume pe kinié imbi molombala. Yu molomba kinie yembomane kanokolie bulu siku ungu taka tondonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ambomo, nu kepe ulu te wendo ombá. Nunge kamelena mindili awili tepa temba kinie yembo awisili konopu lenge mele mona lemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ambo te, yunge imbi Ana, yu Juda yembomanga talape kanga Asa, ye Panuelenga lemenu; yu paa ambou lierimu; yunge menu yemo pea molangili ponie yepoko pakera omba purumu, pe yunge menu kolorumu kinie yu wayemo molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yu mana molopili yunge ponie paono kise kelepa yepoko omba pupe paono kise kelepa kise sipemonga yu we molorumu. Yu ulke tembelemo mundupe siye naa kolopalie alieli kanune mindi molopa ipulueli kepe tangoli kepe Pulu Yemonga popo topa imbi lipe ola mundundumbendo taki-teki langi naa nomba Pulu Yemo kinie ungu nimbe mawa tepa mindi molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simionone Yesusindu ungu nimbe molopili eno moloringine kanu ambomo yu ombalie ⸤Pulu Yemone kanu kangomo Juda yemboma sirimumunge⸥ Pulu Yemo kinie “Ange, papu tekeno.” nirimu. Kanu kinie pe Jerusalleme yemboma lipe tapondopa, umbune tene eno ambolorumu-ne mindili nongo moloringi kanu umbunemonga wendo limbendo ombá yemo ‘Ombá.’ ningu nokoko moloringi yembomando Ana yuni kango akumu orumu mele kinie temba mele kinie nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josepo Mariaselo elone Awilimunge ungu maneselo nimbe perimu mele pali pilku liku tekololie niringilimuni, elo Yesusi kinie kelko kolea Gallilli disiriki pukulu elonga kolea kanga Nasarete yando oringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kangomo awi lepa enge nimbe molopa yunge konopune pilipe konginjeli awisili omba pepili molorumu, Pulu Yemone yu kanopa peanga kanopa yu tepa kondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Juda yembomane ponie tenga tenga kolea awili Jerusalleme ongo akune suku Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilku ulu mare teringi kanu walema Yesusi anumu lapaselo kepe ‘Kanu walemo piliembili.’ ningulu ponie tenga tenga Jerusalleme olando puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kango Yesusi molopili yu ponie engaki rurepo omba purumu kinie kanu wale ‘Pulu Yemonga wale.’ ningu koro moloringi walemo altopa wendo orumu kinie alieli Juda yemboma Jerusalleme puringi mele Yesusi anumu lapaselo kinie yu kinie pea olando puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","⸤Jerusalleme puku⸥ kanu ulumu pilieringi walema pali pora nirimu kinie anumu lapaselo ulkendo pungele puringili kinie kango Yesusi anjo molorumu elo naa kanoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","‘Olionga yembo mare kinie okomo.’ konopu lekolo wale telumunge we pukululie niringilimuni, pe ipupene kolea kalá torumu kinie puku aulkena pengendo elonga pulu lierimu yemboma kinie we yemboma kinie pea puku moloringimendo walsiku piliku andoko kororingili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yu naa kanoko lendekolie Jerusalleme altoko puku koro-poringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wale talo koroko kelkololie niringilimuni, pe wale yepoko sipemonga ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena puku kanoringili kinie yu akune suku molorumu kanoko lenderingili. Yu ungu manemanga pulume pilku mane siringi yema kinie pea moloringi, yuni enonga unguniringime pilipelie, anjo enondo walsipe pilierimula. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yuenone niringime mimi sipe pilierimu mele kepe, topondopa nimbe kondorumu mele kepe, yembo moloringimene pilkulie enone ‘Yunge pilipe konginjeli paapepamo.’ ningu pilku konopu liku munduku mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Elone yu kanu ulkena molorumu puku kanokololie suru ningulu anumuni yundu nimbendo: “Kangomo, olto kinie pea pamili ou naa oli, nambemune tenuye? Lanie olto mini-wale mundulipulu nu andopo koropo keliembulu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aku nirimu kinie yuni anumu lapaselondo nimbendo: “Elo ⸤koleamanga pali⸥ nambemune na andoko korongiliye? ‘Na ya Tatanga ulkena molemo.’ konopu naa liengiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nalo yuni nirimu ungu pulumu elone naa pilieringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yu elo kinie Nasarete taono maniendo pupelie nirimumuni, elonga ungume pilipe tenge panjipe molorumu. Yunge anumuni kanu ulume konopune panjipe pilipe mindi molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesusi yu awi lemba lierimu kinie yu pilipe konginjeli olandopa olandopa pemba perimu; Pulu Yemo kinie yemboma kinie yu kanoko paa peanga kanoko moloringila. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ye Tapiriasi-Sisa, Romo gapomanomone nokorumu koleamanga pali, Isirele yembomanga kolea akumenga pali kepe, yu ye paa awili kumbinemo molorumu. Yu kanu koleamanga pali Romo ye paa awili kumbinemo molopili ponie tene-po omba pupe ponie tene-pape sipemo wendo orumu kinie yu aku sipe we molorumu. Kanu poniemonga Pondiasi Paillate kolea Judia disiriki yembomanga ye nomimu molorumu; Erote kolea Gallilli disiriki yembomanga ye nomimu molorumu; Erote angenu Pillipu kolea Ituria disiriki kinie Terekonaitisi disirikiselo yembomanga ye nomimu molorumu; LLaiseniasi kolea Apillini disiriki yembomanga ye nomimu molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Eno aku koleama nokoko molangi Anasi kinie Kayapasiselo Pulu Yemo popo tondoringi ye awili olandopaselo molangili Sekaraya malo Jono kolea ku lieline molorumu kinie Pulu Yemone Jono yu ungu umbu tondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pulu Yemone ungu umbu tondorumu kinie pilipelie Jono yu pupe no Jodane nekendo yakondo andopa yemboma ungu mane sipelie nimbendo: “Eno ulu pulu keri telemelema kanoko keri kanoko konopu alowa tekolie ‘Pulu Yemone olionga ulu pulu kerime ‘We manie pupili.’ nimbe siye kolopili.’ ningu ‘No liemili.’ ningu waa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","⸤Aku kongonomo Jonone terimu mele yu naa molopili koronga ou yuni yemboma Yesusinge ungume sumbi siku pilku linge aulkemo lipe nosindimbe mele⸥ Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane nimbe boku torumu akune molemo mele isipe: “Kolea ku lieline ⸤kumbi lepa pumbe⸥ ye tenga kerena ungu te nimbendo: “Awilimu ombá aulkemo teko mimi teame. Yu ombá aulke kangama toko sumbi siee.” nikimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Ma pangime akuku kalalu siku, kolo lemomanga akuku pe toko, aulke anekale-manekale telemoma toko sumbi siku, aulke ola manie pulimoma kolta lenge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aku tenge kinie Pulu Yemone olio lipe tapondopa ‘Mindili nolemela aulkena wendo ongo yu-kinie pea molko kondonge aulkena pangi.’ nimbe lipe mundumbe yemo yembomane pali kanonge.” nikimu.” nimbe ⸤Jonone pe temba mele Aisayane ou aku sipe nimbe sipe bokune torumu molemo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yembo awisili Jono molorumune ‘Yuni olio no lindepili.’ ningu onge oringi kinie yu kanopalie nirimumuni, eno iri topalie nimbendo: “Kolo topa yemboma tepa kenjeli wambiyemonga waloma, Pulu Yemo mumindili kolomba walemonga nawene “Eno talopa leko paa.” nimu kinie eno ‘Pulu Yemone naa tepa kenjepili.’ ningu ‘No liemili.’ ningu okomeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Eno sumbi siku molko, ulu peangama mindi teko molonge kinie eno ulu pulu keri teringime paa sike munduku siye kolko konopu alowa tenge mele mona lemba. “Olio anda kolepa Eporayamone kalopa lsimume molemolomonga yembo peangama molemolo.” ningu aku siku ningu naa pilieme. Nane eno nimbu sikiru: ‘Pulu Yemone ikoumendo “Eporayamone kalopa lsimu yemboma a leangi.” nilkenje koume Eporayamone kalopa lsimu yemboma molemela.’ nikiru. Eno Eporayamone kalopa lsimu yemboma molemelemonga uluri naa telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Unjo peke tomba loumu Pulu Yemone koronga unjo pulune ambolopa ola lipe molemo. Unjo mongo peanga naa tomba unjoma yuni peke topalie tepena kalomba.” nimbe Jonone aku nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","⸤Yembo Pulu Yemo kanopa peanga kanolemo ulu pulume naa telemelema Pulu Yemo yuni mongo simbe mele Jonone nimbe sirimu kinie pilkulie⸥ ongo maku toringi yembomane ningendo: “⸤‘Yuni olio mongo naa sipili.’ nimbu⸥ nambe-emoloye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yuni enondo topondopa nimbendo: “Wale pakoli talo nosilimele yemboma enone yembo wale pakoli te naa nosingema moke teko siengi. Langime kepe aku siku teangila.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kou takisi lili yema kepe ‘No liemili.’ ningu oringi. Yuni ungu nirimumu pilkulie yundu walsiku pilkulie ningendo: “Ungu Mane Silimu, olio nambe-emolo kinie Pulu Yemo yuni olio kanopa peanga kanombaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yuni enondo nimbendo: “Eno kou takisi likulie gapomano yuni “Kou i siku liee.” nimbe mako topa simbe mele liengi. Enone kolo toko mare ola panjiku limele aku mele naa liengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kanu kinie ami ye mare yu walsiku pilkulie, “Olio kepe nambe-eamiliye?” niringi. Yuni topondopa nimbendo: “Enone yembomanga kou mone wa lingendo kolo toko kopene we naa tangi. Gapomanomone mele kalomba koumu mindi liku nosiku, taka liku molangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jonone terimu mele kanokolie yembomane yu-kinie konopu awisili liku munduku, ‘Pulu Yemone olionga anda kolepalimendo “Eno nokopa kondomba ye te lipu mundumbo.” nirimu ye nomi Kirasimu ? ningu pilku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ningu pilieringi mele pilipelie Jonone topondopa enondo nimbendo: “Nane yemboma no mindi lindilio. Nalo ye te ombámo yuni ⸤Pulu Yemonga⸥ Mini Kake Telimu kinie tepemo kinie eno lindimbe ⸤linge⸥. Iombá yemo yunge tondolomo paa olandopa, nanga tondolomo paa maniendopa. Na yu-kinie manda molo. ⸤Yembo awilimenga kongono keri teli kendemande yembomane sike enonga awilimenga kongono keri tendengendo kimbu su wendo lindilimele nalo⸥ ombá yemonga kimbu su wendo lindimbo kanu kongonomo paa olandopa mele nane tendembo kapola naa telka, na ye paa keri. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yuni yunge rasi-witi apuroli apulu pokomo ambolopalie yunge rasi witi mongo kinie rasi witi kilu kinie apurumbendo molemo. Yunge rasi witi apuroli polomo tepa mimi tembando rasi witi pali ‘wendo liembo.’ nimbe apurupelie mongoma lipe rasi witi nosilimo mingine ‘Liepili.’ nimbe nosimbendo mingi topa, pe kilume lipe maku topa tepe naa kumbulupe nomba pepa mindi pulimona kalomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","‘Yembomane “Olio yembo molopo kenjilimolo yemboma. Olio ulu pulu kerime mundupu siye kolopo konopu alowa teamili.” niengi.’ nimbe Jonone yemboma ungu mane awisili aku sipe sipe, temane peangamo topa sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Walse, pe mele, Jonone kolea Gallilli disiriki yembomanga ye nomi kingi Erote iri torumula. Yu angenunge ambo menu Erodiasi ⸤mangopa lsimu⸥ ulumu kinie ulu pulu keri lupe awisili terimume kinie nimbe para sipe yu iri torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jonone yu iri torumumunge Erotene mumindili kolopalie yu ka sipe ka ulkena panjerimu. Yuni aku terimumu tepa kenjerimula. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","⸤Erotene Jono ou ka naa sipili⸥ yembo awisili Jono no lindipe molorumune ongo no lsingi kinie Yesusi kepe omba no lsimula. No lipelie Pulu Yemo kinie ungu nimbe angilierimu kinie mulumu kengeya lepa anjo yando purumu, ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pulu Yemonga Minimu, kera waembono mele, manie omba Yesusi molorumune pupe kangine ola molorumu. Mulune ungu te wendo ombalie nimbendo: “Nu nanga konopu mondolio kangomo. Nu-kinie konopu sipu molio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesusi yu mana molopili ponie wane paono tene mele omba purumu kinie yunge kongonomo pulu polopa terimu. Yembomane Yesusindu ‘Josepo malo.’ ningu pilieringi. Josepo yunge lapa Illai. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Illai lapa Matate. Matate lapa LLipai. LLipai lapa Melkai. Melkai lapa Janai. Janai lapa Josepo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josepo lapa Matatayasi. Matatayasi lapa Emosi. Emosi lapa Neame. Neame lapa Esillai. Esillai lapa Nakai. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai lapa Meate. Meate lapa Matatayasi. Matatayasi lapa Semene. Semene lapa Joseke. Joseke lapa Joda. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda lapa Joanane. Joanane lapa Resa. Resa lapa Serapapele. Serapapele lapa Sialtele. Sialtele lapa Nerai. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai lapa Melkai. Melkai lapa Edai. Edai lapa Kosame. Kosame lapa Ellemadame. Ellemadame lapa Ere. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere lapa Josua. Josua lapa Elliesa. Elliesa lapa Jorimu. Jorimu lapa Matate. Matate lapa LLipai. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","LLipai lapa Simiono. Simiono lapa Juda. Juda lapa Josepo. Josepo lapa Jonamo. Jonamo lapa Ellayakimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ellayakimu lapa Mellia. Mellia lapa Mena. Mena lapa Matata. Matata lapa Netane. Netane lapa ⸤Ye Nomi Kingi⸥ Depisi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depisi lapa Jesi. Jesi lapa Opete. Opete lapa Boasi. Boasi lapa Sallimono. Sallimono lapa Nasono. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasono lapa Aminadape. Aminadape lapa Ramo. Ramo lapa Esirono. Esirono lapa Peresi. Peresi lapa Juda. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda lapa Jekopo. Jekopo lapa Aisake. Aisake lapa Eporayamo. Eporayamo lapa Tira. Tira lapa Neyo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyo lapa Serake. Serake lapa Reu. Reu lapa Pelleke. Pelleke lapa Epe. Epe lapa Silla. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silla lapa Kenane. Kenane lapa Apakisate. Apakisate lapa Seme. Seme lapa Noa. Noa lapa LLameke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","LLameke lapa Metusalla. Metusalla lapa Inoke. Inoke lapa Jarete. Jarete lapa Mallallele. Mallallele lapa Kenane. ");
INSERT INTO ubu_kala_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane lapa Inosi. Inosi lapa Sete. Sete lapa Adame. Adame lapa Pulu Yemo. Adame Pulu Yemonga malo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesusi ⸤no lsimu kinie⸥ Mini Kake Telimu yu-kinie omba molopa yunge konopune molopa paa tengepea tepili no Jodane mundupe siye kolopalie nirimumuni, Mini Kake Telimuni yu kolea ku lieline memba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Akune Yesusi ⸤Mini Kake Telimu kinie molopili⸥ ⸤kurumenga nomi⸥ depelemo omba yu kondi topa molopili oli te koro talo omba purumu. Kanu walemanga langi naa noli wemolopa perimu kinie yu engelene kolopa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kanu kinie ⸤kurumenga nomi⸥ depelemone yu ⸤kondi topalie⸥ nimbendo: “Nu Pulu Yemonga Malo liemo ikoume ‘Pillawa kaloli a liepili.’ ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nalo yuni topondopa nimbendo: “Pulu Yemonga bokumuni nimbendo: “Langimene mindi yemboma konde mololi ulu pulumu naa silimo.” nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kanu kinie depelemone Yesusi yu lipe memba pupe ⸤ma pangi⸥ paa olana tenga anjipelie, yu ma koleama pali walsikele lipe ora sipelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","yundu nimbendo: “I koleamanga pali tondolomo kinie mele peangama kinie Pulu Yemone nando “Nokou.” nimbe koronga sirimu. Ime nane ‘Yembo te simbo.’ nindu liemo manda simbo. Nu na popo toko nanga imbi liku ola mundundonu liemo itondolomo kinie mele peangama kinie pali nu lieni simbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kanu kinie Yesusini depelemondo nimbendo: “Pulu Yemonga bokumuni nimbendo: “Pulu Yemo enonga Awilimu manjiku popo toko imbi liku ola mundunduku, yunge kongonomo manjiku tendeko molangi.” nimbe molemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Kanu kinie depelemo yuni Yesusi lipe kolea awili Jerusalleme memba pupe, ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelemonga memba, paa ola imune memba pupe anjipelie nirimumuni, yundu nimbendo: “Nu Pulu Yemonga Malo liemo nu lipe tapondomba kene pou ningu manie pu.” ⸤nirimu.⸥ “Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemone yunge mulu koleana angellomane ‘Nu ongo nokangi.’ nimbé. Enone nu ‘Kou tene kepe naa topili.’ ningu nu enonga kimene oko polko linge.’ nimbe molemo kanumu. Aku sipe nirimu kene pilkulie aku siku tei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesusini yundu topondopalie nimbendo: “Pulu Yemonga yembomando ungu te pea nimbe molemola. Akumu isipe: ‘Pulu Yemo enonga Awilimuni “Tembo.” nilimo mele ‘Sike nilimonje molo kolo tolemonje kanamili.’ ningu enone yu manda manjiku naa teangi.’ nimbe molemola kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Depelemone Yesusi kondi pali topa pora sipelie nirimumuni, ‘Pe yu manda altopo kondi tombo wale te nondopo pilipulie kelepo ombo.’ nimbe yu mundupe siye kolopa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kanu kinie Minimunge tondolomone Yesusi kelepa kolea Gallilli disirikindu yando memba orumu kinie akune andopa terimu mele temanemo koleamanga pali anjo anjo purumu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yuni Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkemanga pupe ungu mane sirimu kinie yembomane pali yu kapi niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesusi kolea Gallilli disiriki yemboma ungu mane silipe andopalie nirimumuni, yu Gallilli lierimu kolea Nasarete taono ou molopa awi lierimune kelepa orumu. Ombalie ⸤Juda yembomanga koro moloringi⸥ wale Sambatemonga koleamanga pali eno maku toko Pulu Yemonga ungumu pilieringi ulkemanga yu alieli purumu mele Nasarete ungu pilieringi ulke akune aku sipe purumu. ⸤Maku toko moloringi kinie⸥ yuni “Na bokumu kanopo niembo.” nimbe ola angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","⸤Pulu Yemonga bokume nokorumu yemone⸥ Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane koronga ou torumu bokumu lipe sirimu kinie, Yesusini lipe sukundu ungu molorumu te kanopalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“⸤Aisayane isipe nimbendo:⸥ “Awilimunge Minimu na-kinie molemomo yuni nando nimbendo: “Yembo koropama temane peangamo toko siku, ka ulkena pelemele yembomando ‘Wendo ongo we molangi.’ ningu mongo keri lieli yembomando ‘Mongo peanga liepili kanangi.’ ningu, mindili nongo molemele yemboma ‘Mindili naa nongo, molko kondangi’ ningu, ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Kinié poniena Awilimuni yemboma kanopa kondo kolomba poniemo wendo okomo.’ ningu siliku andou.” nimbe Minimuni aku sipe ye te mako topalie nirimu.” nimbe Aisayane nirimu.” nimbe Yesusini aku sipe boku kambu topa nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ungu akumu kanopa nimbe pora sipelie bokumu altopa pipi sipe bokume nokorumu yemo sipe, ⸤“Ungu te niembo.” nimbe⸥ Yesusi yu manie molorumu. Yemboma pali yu mindi neme-neme ningu kanoko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kanu kinie yuni enondo nimbendo: “Kinié Pulu Yemonga bokune ungumu kanopo nindu piliengi akune Aisayane “Wendo ombá.” nimbe, ou nirimu mele kinié wendo okomo. ⸤Kinié na tembo okoro ulu akumenga ou nirimu.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Moloringi yembomane “Yu ye peangamo. Yu paa telemo.” ningu yu nirimu mele pilkulie “Paa nimbe kondokomo.” ningulie mini-wale mundoringi. ⸤Nalo⸥ enone ningendo: “I yemo ⸤yu nawe konopu lekemoye?⸥ Yu Josepo malo mindi, ⸤olionga we ye te mindi lemo⸥.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","⸤Nalo⸥ Yesusini ⸤yuyu molorumu mele nirimu kinie pilkulie yu konopu keri panjeringi mele pilipelie⸥ enondo nimbendo: “Ungu iko tolemelemanga te nando toko ninge teko molemelenje konopu lekero. Enone nando i siku ninge tekemelenje: “Nu sike doketa moleno liemo nu kuru tomba kinie nunge maratenemo nunu liku nani. Pe nu konde puni ⸤kinie kanopolie ‘Nu sike doketa moleno lemo.’ nimbu pilimolo.” ningu aku ungu ikomo na toko singe tekemelenje?⸥ Nando ningendo: “Nuni Kapeniame taono ulu tondoloma terinu pilierimulu mele ya nunge pulu kolea ⸤Nasarete⸥ akune aku siku teani. ⸤Kanopolie nu “molio.” nikinu mele ‘Sike nikinu lemo.’ nimbu pilimolo.⸥” ninge tekemelenje? ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Nane enondo sike nimbu sikirumu: Yembomane ulu pulu te telemele mele isipe: Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye tene yunge pulu koleamonga yemboma ungu nimbe silimo kinie pilkulie nilimelemone, enone ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo ungume naa pilku liku su silimele. ⸤Kolea lupe yembo marene ongo ungu ningu silimele kinie aku ungume mindi pilku limele. Yembomane aku siku telemele mele enone aku sikula telemele.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","‘Nane paa sike nimbu sikiru mele eno piliengi!’ nimbu ⸤temane talo tambo.⸥ “I llainja Pulu Yemone ungu umbu tondorumume pilipe ⸤yunge pulu lierimu⸥ Isirele yemboma nimbe sipe molopili ulu te wendo orumumu niembo. Pulu Yemone “Lo naa opili.” nirimu kinie ponie yepoko kelepa oli kise talo pakera lo naa omba paa engele lierimu kinie Isirele koleana sukundu ambo waye awisili ⸤engelene kolko⸥ moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nalo Pulu Yemone “I sirele ambo waye te liku tapondoko langi sieni.” nimbe Illainja akune naa lipe mundorumu. ⸤Isirele ulsukundu lierimu⸥ kolea awili Saidono nondopa lierimu kolea kanga Sarepate ambo waye te ⸤‘Langi pora naa nipili.’ nimbe Pulu Yemone kanu ulsukundu ambomo⸥ molorumune Illainja lipe mundorumu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“I llaisia kepe ou Pulu Yemone ungu umbu tondorumume pilipe ⸤yunge pulu lierimu Isirele yemboma⸥ nimbe sipe molopili Isirele koleana sukundu yembo awisili kuru kendi norumu, nalo eno pali telu kepe konde naa puringi, kuru kendi nomba we perimu. ⸤Kolea Isirele ulsukundu lierimu⸥ kolea Siria ye Nemana mindi kuru kendi norumu kinie Illaisiane yu ⸤lipe tapondopa⸥ tepa konde lsimu. ⸤Pulu Yemone Illainja kinie Illaisiaselo lipe mundorumu kulu ulsukundu yembo talo aku siku liku tapondoringili nikiru mele paa sike nikiru piliee.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aku sipe mele nirimu kinie pilku keri pilkulie Pulu Yemonga ungumu pilieringi ulkena sukundu moloringi yemboma pali paa lakoko mumindili koloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mumindili kolkolie ola angilku yu kanu koleana ulsu toko pulu siku munduku, kanu koleana nondopa kopó te lierimune toko manie mundunge teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nalo yu eno maku toko angilieringine sumbi sipe pupe tenga lupe pumbe purumu, yu manda naa amboloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kanu kinie Yesusi yu kolea Gallilli disiriki lierimu taono te Kapeniame akune maniendo purumu. Akune ⸤Juda yembomanga koro moloringi⸥ wale Sambatemo wendo orumu kinie Yesusi ⸤Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke kanune suku pupe⸥ eno ungu mane sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mane sirimu kinie yu namba lierimu yemane pipili naa kolko tondolo munduku mane siringi mele yuni aku sipe mane sirimu kulu pilkulie yembomane mini-wale mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kanu kinie ulke kanune suku ye kuru te konopune molopa lipe ambolorumu ye te molorumu, ⸤yemonga konopune suku molorumu kanu kurumuni yu “Ungu ni.” nimbe tópe sirimu-ne⸥ opa ungu tondolo mundupe nimbelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kolea Nasarete ye Yesusi, nu pea olio ⸤kurume⸥-kinie telune tapu topo manda naa molomolo. Nuolio kinie nambemune onuye? Nu olio toko kondoni onuye? Nane nunge imbi pilio. Nu Pulu Yemonga Ye Kake Telimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","⸤Aku sipe nirimu kulu pilipelie⸥ Yesusini kanu kurumu iri topalie yundu nimbendo: “Nu ungu naa ningu yemonga konopune ongo wendo pu!” nirimu kinie kurumuni yemo topa manie mundupelie omba wendo purumu. Yemo yu uluri naa terimu, we manda molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","⸤Yesusini aku terimu kanokolie⸥ yemboma suru ningu, mini-wale munduku, enone enono anjo yando ningendo: “I ulumu nambolka uluri tekemonje? Ungu mane konde te wendo ombámo. Ye namba lieli tene we yembomando “Teaa.” nilimo mele iyemone kurumendo kepe aku sipe nilimo kinie kanu kurume yunge ungumu pilku liku wendo olemele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kanu kinie yuni aku sipe terimu mele temanemo kanu koleamonga sukundu lierimu koleamanga pali anjo anjo purumu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kanu kinie kanu maku toko Pulu Yemonga ungumu pilieringi ulkemo Yesusi mundupe siye kolopa pupelie nirimumuni, Yesusi Saimononga ulkena suku purumu. Akune Saimononga kolepa ambomo kuru topa kangi nomba kondopili lierimu-ne Yesusindu “Liku tapondou.” ningu mawa teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aku siku yu mawa teringi kinie ambomo lierimune pupe angilipelie nimbendo: “Kangi manda nou.” nirimu kinie kangi nomba kelierimu. Ambomone sumbi sipe ola angilipe wendo ombalie, oringi yema langi sipe nokopa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kanu walemonga ipupene, ena pumbe purumu kinie, kuru lupe-lupe torumu yemboma Yesusi molorumune mengo oringi kinie kanu yemboma eno yu mele mele kini ambolopalie eno pali tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","⸤Konopune kuru molorumu⸥ yembo awisili ⸤oringi.⸥ Kanu kurume⸤ndo “Ongo wendo paa.” nirimu kinie⸥ ongo wendo puku ru ningulie ningendo: “Nu Pulu Yemonga Malo moleno.” niringi. Kurumene yu aku siku imbi sikulie yu ⸤Pulu Yemone mako topa lipe mundorumu ye nomi⸥ Kirasimu molorumu mele pilieringi kulu yuni eno iri topa “Molio mele anjo ningu naa siee.” nimbe enonga kerema pipi sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ipulueli-ou Yesusi ola molopa penando pupe kolea ku lieli tenga purumu kinie yembo awisili yu koroko yu molorumune ongo yundu ningendo: “Olio-kinie pea kamu molamili. Tenga naa pu.” ningu mawa teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yuni enondo topondopa nimbendo: “⸤Pea molamili mangali⸥ kolea wemanga pea pupu, Pulu Yemo omba ye nomi kingi molomba temane peangamo topo silipu andombo. Akumunge na yando lipe mundorumu kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aku nimbelie yu pupe kolea Gallilli ⸤disiriki⸥ sukundu andopa, kolea lupe lupemanga pupe Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkemanga pupe kanu temane peangamo topa silipe andorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Walse, Yesusi nomu Geneserete, ⸤akumundu ‘Nomu Gallilli’ niringila kanumu,⸥ aku nomu kélona angilipe yemboma Pulu Yemonga ungumu nimbe sirimu kinie pilingendo eno yu angilierimune puku maku toko nondoko nondoko puku ekelepa teko molko pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kanu kinie yuni nona andoli sipi talo nomu kélona lierimuselo kanopalie, oma lili yema koronga nomu kélona wendo puku enonga oma lili walema kulumiye toko moloringi kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sipi te Saimono Pitanga, akune sukundu pupelie yuni yundu mawa tepalie nimbendo: “Sipimu laye kolte paka toko nona sukundu mundou.” nirimu. Paka topa nona sukundu mundorumu kinie aku sipimunge suku yu manie molopalie nirimumuni, no kélona liku maku toko moloringi yemboma ungu mane sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eno ungu mane sipe pora sipelie yuni Saimonondo nimbendo: “Sipimu nomu awi-suku-singine kunduku mengo pukulie oma lili walema nona manie mundou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimonone topondopa nimbendo: “Ye Nomimu, sumbulu telu oma lili kongono tondolo mundupu tepo molopo tangondopolie oma te paa naa limulu. Nalo aku nikinu kene walemo nona manie mundembo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kanu kinie walema nona manie mundoringi kinie oma awisili walemanga sukundu puringi kulu walema nomu sipine sukundu linge teringi kinie sungu nimbé terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Walema sungu nimbé terimu kanokolie enone enonga oma lili kongono pea tapu toko teringi yema, sipi tenga moloringime walsikulie “Ongo liku tapondangi waa.” niringi. Oringi kinie sipi talo pea peko siringi umbune tepa nona manie pumbe terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aku ulumu kanopalie Saimono Pita Yesusinge kumbikerena omba manie molopa tamalu pepalie nimbendo: “Ye Awilimu, na ulu pulu keri ambololi yemo ⸤nu kake teli yemo⸥. ⸤Telune molkombolo kapola naa tekemo⸥ kene anjo puku nu lupe molou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yu kinie, yu kinie pea moloringime kinie, enone oma awisili walsikele tangoli lsingi kanokolie eno suru ningu mini-wale mundoringi kulu ⸤Saimonone aku sipe nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Seperinge malo Jemisi kinie Jonoselo elo Saimono Pita kinie kongono telune tapu toko teringili yeselo, elo pea mini-wale mundoringilila. Kanu kinie Saimonone nirimumu pilipelie Yesusini yundu nimbendo: “Nu pipili naa koloyo. Kinié oma linindu oma lili wale liku nona manie mundulino kinie omama walena omba pelemo mele, pe nanga kongono tendenindu nanga ungumu pilku ningu siliku andoni kinie yemboma nanga talapena sukundu ongo molonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kanu kinie enonga sipiselo nomu kélona mengo ulsu ongolie, sipiselo melema pali liepili munduku siye kolko Yesusi lombili puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","⸤Kolea Gallilli disiriki sukundu lierimu⸥ koleamanga tenga Yesusi molorumu kinie ye te kuru kendi awili tepa nomba perimumu omba Yesusi kanopalie manie molopa tamalu pepa yu mawa tepalie nimbendo: “Awilimu, nunge konopumuni na ‘Konde pambo.’ konopu lienu liemo nuni na manda teko konde lini.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusini yemo kini ambolopalie yundu nimbendo: “‘Nu konde pani.’ konopu lekero kene konde pu.” nirimu kinie tamburumbu kuru kendimu nomba kelierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kanu kinie Yesusini yu ungu te tondolo mundupe nimbendo: “Nuni ya ulu tekeromo yembo telurindu kepe paa naa ni! Sumbi siku puku Pulu Yemo popo tondoli yemo nunge kangimu liku ora siku, ‘Na altopo kangi peanga liepili molkoro kene.’ ningu Mosisini “Tei.” nimbe ungu mane sirimumu lku liku tenindu “Pulu Yemo popo toko kalko sie.” nirimu melemo liku Pulu Yemo popo tondoli yemondo “Kalondou.” ningu yu sieni. Pe yembomane nu kanokolie ‘Yu sike kangi peanga liepili molemo.’ ningu piliengi kene nikiru mele isili-ou te-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nalo yuni terimu mele anjo anjo yembo awisilini pilkulie niringimuni, yu molorumune sukundu-sukundu ongo yu temane peanga topa nirimumu pilingendo ongo, yuni ‘Eno tepa konde lipili.’ ningu oringi kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","yu eno oringine mundupe siye kolopa kolea ku lieli tenga pupe Pulu Yemo kinie ungu nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Walse Yesusi yuni yemboma ungu mane sipe molorumu. Kuru toli yemboma tepa konde lili tondolomo yu-kinie pepili molorumu. Pulu Yemone kanu tondolomo yu sirimu. Parisi yema kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, yu ungu mane sirimume pilku moloringila. Kanu yema, kolea Gallilli disiriki sukundu lierimu koleamanga moloringime kinie, kolea Judia disiriki sukundu lierimu koleamanga moloringime kinie, kolea awili Jerusalleme moloringime kinie, Yesusi molorumune ongo maku toko yu ungu mane sirimume pilku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Yu molorumune ye marene kimbu-ki kolopa pora sirimu ye te taropola teko mengo onge oringi nalo yembo awisili ulke kerepulune ekelepa teko angilieringi kulu ulkena suku Yesusi molorumune nondoko mengo punge aulke te naa kanokolie niringimuni, ulke imune mengo ola pukulie Yesusi molorumune ⸤kana-kana ulkemo tekisikulie⸥ yemo taropola pali moko toko manie mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","‘Yesusini iyemo manda tepa konde limbe.’ ningu tondolo munduku pilkulie yu mengo oringi kanopa pilipelie Yesusini kanu yemondo nimbendo: “Kangomo, nunge konopune ulu pulu keri terinu pelemoma manie pupili, we siye kolkoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisi yema kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Yesusini aku nirimu pilkulie ⸤pilku keri pilku⸥ konopu kimbú sikulie, “I ye Pulu Yemo marake tekemo yemo naweye? Yembomane ulu pulu keri telemelema nawene ‘Manie pupili, we siye kolkoro.’ manda nimbeye? Pulu Yemone mindi manda telemo.” ningu enono ningu pilku molko konopu kimbu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kanu kinie Yesusini eno aku siku konopu kimbú siku moloringi mele pilipelie enondo nimbendo: “Enone ⸤nane nikirumunge⸥ aku siku nambemune konopu kimbú sikimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Iyemondo “Nunge ulu pulu kerime manie pupili, we siye kolkoro.” nimbo kinie eno ulu te naa kanokolie ‘We-we tepa nikimu.’ konopu lengeye? Molo “Ola angilku nunge kunungumu liku mengo kimbu kongono teko andou.” nimbo kinie yu ola angilimbene naa angilimbenje mona lemba manda kanokolie ‘Aku sipe mindili sipe nikimunje?’ konopu lengeye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nalo “Manie Omba Mana Ye A Lierimu Yemo tondolo pelemomone ya ma koleana yembomanga ulu pulu kerime “Manie pupili, siye kolkoro.” manda nimbé.’ ningu piliengi!’ nimbu ⸤aku sipu nindu⸥.” nirimu. Aku nimbelie kimbu ki kolopa pora sili yemondo nimbendo: “Nane ‘Nu ola angilku nunge kunungumu liku mengo ulkendo pu.’ nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aku nirimu kinie eno kanoko molangi yemo sumbi sipe ola angilipe yunge kunungumu lipe memba omba pena pupelie Pulu Yemo kapi nilipe ulkendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","⸤Yu aku terimu kanokolie⸥ eno suru ningu mini-wale munduku Pulu Yemo paa pipili kolko yunge imbi liku ola mundunduku yu kapi ningulie ningendo: “Olio iulu wendo okomo kanokomolomo ulu paa te lupe lepamo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kanu kinie Yesusi ⸤ulkemo mundupe siye kolopa⸥ pena pupelie nirimumuni, kou takisi lsimu ye te, yunge imbi LLipai, kou takisi lipe molorumu kanopalie yundu “Na-kinie pea pambili lombili ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kanu kinie LLipai yu ola angilipe kou takisi melema we liepili mundupe siye kolopa yu lombili purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pe LLipaini yunge ulkena Yesusinge langi awisili kalondorumu. Akune kou takisi lili ye awisili kinie, we ye mare kinie, eno Yesusi LLipaiselo kinie pea manie molko kanu langime noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aku teringi kanokolie Parisi yema kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, enone Yesusi yu lombili andolimendo ningendo: “Eno kou takisi lili yema kinie ulu pulu kerime teli wema kinie eno pea nambemune langi nokomeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aku siku niringi pilipelie Yesusini enondo nimbendo: “Kuru naa tolemo yemboma doketana naa pulimele. Kuru tolemo yemboma mindi doketana pulimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nane ‘Yembo sumbi nilime na molombona wangi.’ nimbondo ma koleana naa orundu. Ulu pulu keri teli yemboma ⸤lipu tapondopo⸥ enondo ‘Eno ulu pulu keri telemelema kanoko keri kanoko konopu alowa teko ⸤na molombona wangi⸥.’ nimbondo orundu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","⸤Kanu kinie⸥ enone Yesusindu walsiku pilkulie ningendo: “⸤No Lindeli⸥ Jono lombili andolime kinie, Parisi yema lombili andolime kinie, enone walse-walse langi mi toko naa nongo Pulu Yemo kinie mawa telemele nalo nu lombili andolimene aku siku naa telemele, langi kinie nokinie we nolemele. ⸤Pe nu lombili andolimene telemele mele papuye⸥?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aku siku niringi pilipelie Yesusini topondopa enondo ⸤ungu iko te topa yu-kinie ulu te wendo ombá mele nimbelie⸥ nimbendo: “Ambo limbe ye te yunge pulu lemo yema kinie molemo kinie eno konopu sikulie “Langi mi topo naa namili.” manda ningeye? Manda naa ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe mindi, ambo limbe yemo eno molongena ongo wendo linge kinie kanu walemanga sike ⸤konopu keri panjiku⸥ langi naa nongendo mi tonge. ⸤Isili-ou molo.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesusini aku nimbelie nirimumuni, ⸤‘Ou Juda yembomane ulu teringi ulume kinie pe ulu konde wendo okomomo kinie telune manda naa pengele mele paa piliengi!’ nimbe⸥ ungu iko talo topalie nimbendo: “Mulumbale ou te sungu nilimo kinie olione mulumbale paakonde tenga te kopisipu lipu, sungu nilimomonga naa topo tambululimolo kanumu. Yembo tene aku sipe topa tambulkenje kanu mulumbalemo nona panjilke kinie mulumbale konde kopiselimu kanga lepa lli nimbelie mulumbale oumu kelepa kamu awili tepa sungu nilke. Ulu te isipela: Mulumbale oumu kinie mulu kopiseli kondemo telu sipe molo akumunge kapola kapola molo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kongi meme kalumuni teli mingi ou tenga no-waene konde naa kolemolo kanumu. Yembo tene mingi ou tenga no waene konde te kolkanje kanu no-waenemo mingine sukundu pepalie pe akolka kinie kanu mingi oumu naa akopa sungu nilke. Kanu kinie nomo kepe mingimu kepe kamu keri lelka. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Akumunge no-waene konde kongi meme kalumuni teli mingi kondena mindi kolemolo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ye tene no-waene ou te nombalie kanu waene oumu nomba peanga pilipelie no-waene konde waka naa kolemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Walse, ⸤Juda yembomanga koro moloringi⸥ wale Sambate tenga, Yesusi kinie yu lombili andolime kinie rasi-witi poniemanga ongo puringi kinie yu lombili andoli yemane rasi-witi mongo mare nongendo inie toko liku kilu toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aku teringi kanokolie Parisi yemane Yesusi yundu ningendo: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa teangi.’ nimbe pelemo ungu manemo nambemune nunge lombili andoli yemane ungu manemo pulue tokolie aku siku tekemeleye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesusini topondopa nimbendo: “Eno Pulu Yemonga bokune sukundu ⸤anda kolepa ye nomi kingi⸥ Depisini terimu mele nimbe molemo temanemo kanokolie temanemonga pulumu naa pilimeleye? Depisi kinie yu pea puringi yema kinie eno engelene kolkolie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Depisi Pulu Yemo molorumu sele-ulkena sukundu pupe, Pulu Yemonga kumbikerena lierimu pillawa kalolime lipe nomba, yu pea puringi yema sirimu noringila kanumu. Kanu pillawa kalolimendo Pulu Yemone ungu mane sipelie nimbendo: “We yembomane paa naa nangi. Pulu Yemo popo tondoli yema manjiku nangi.” nirimu ⸤kanu ungu manemo pulue torumu⸥ kanumu. ⸤Eno konopu talo nambemune lemeleye? Depisi yuni ou aku terimu mele eno pilku keri naa pilimelemonga pe kinié nalombili andoli yemane tekemele mele kanoko keri naa lakanaa.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Manie Omba Mana Ye A Lierimu Yemone Sambate walema nokolemo-na ⸤Sambate wale kinie yemboma molko kondongendo tenge mele manda nimbé kanumu⸥.” nirimu. Te: 6:6-11 Sambate Wale Kinie Yesusini Ki Keri Lierimu Ye Te Tepa Konde Lsimu Temanemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pe walse, koro mololi wale Sambate tenga, Yesusi omba Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulkena suku pupelie ungu mane sirimu. Kanu ulkena ye te molorumu, yunge ki-umbukundu kamu kolopa kukorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kanu kinie akune moloringi Parisi yema kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, enone ‘Yesusini ulu te tepa kenjimbe kinie yu kote tendemolo.’ ningu ulu te tepa kenjimbe te ⸤alieli koroko molkolie⸥ ‘⸤Koro molemolo⸥ wale Sambate kinie yuni yemo tepa konde limbenje.’ ningu yu mimi siku kanoko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Eno konopuni pilieringi mele pilipelie Yesusini kanu ki kolopa kukorumu yemondo nimbendo: “Yemboma molemelena ongo ola angilieni.” nirimu kinie yemo yu akune omba ola angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kanu kinie yemando nimbendo: “Eno isipu walsipu pilkiru. ‘Sambate wale kinie ulu nambolka ulu te manda temoloye? ‘Sambate walemonga ungu manemone “Teangi.” nilimo mele teamili.’ nimbu yemboma lipu tapondomolo kinie manda molo tepo kenjimolo kinie mandaye? ‘Naa kolangi. Konde pangi.’ nimbu temolomo manda molo topo kondomolomo mandaye?’ nimbu walsikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aku sipe eno nimbe walsipelie yuni eno pali neme-neme nimbe kanopalie ki kukoli yemondo nimbendo: “Nunge kimu sinio si.” nirimu kinie yemone yunge ki sinio sirimu kinie ki kolopa kukorumumu altopa kamu peanga lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aku terimu kanokolie mumindili awili teko kolko enone enono anjo yando ungu mele teko ningendo: “Tepa kenjikimumunge yu nambe-eamiliye?” ningu moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pe walse ipulueli Yesusi yu Pulu Yemo kinie ungu nimbendo ma pangi tenga ola pupe Pulu Yemo kinie ungu nimbe molopili kolea tangorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ipulueli-ou yu lombili andolimendo “Waa.” nimbelie ‘Enonga ye engaki rurepo nanga kongonomo teangi lipu mundembo.’ nimbelie aku yema mako topalie enondo nimbendo: “Eno ‘Nanga kongonomo tende-pangi.’ nimbu lipu mundukuru yema.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","⸤Kanu ye engaki rurepo mako torumumenga imbime isipe:⸥ Saimono (yunge imbi te Pita) yu keme, Pita angenu Enderu keme, Jemisi keme, Jono keme, Pillipu keme, Batollomiu keme, ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateyu keme, Tomasi keme, Allapiasinge malo Jemisi keme, “Olio Juda yemboma oliolio gapomano molamili.” niringi talape ye Saimono keme, ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemisi malo Judasi keme, Judasi Isikeriote, Yesusi pe lipe opa puluema sirimu yemo keme, ⸤aku yema ‘nanga kongono tende-pangi lipu mundukuru.’ nimbe mako torumu yema⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kanu kinie yu kinie, yuni “Nanga kongonomo tende-pangi.” nimbe lipe mundorumu yema kinie, ma pangine manie oringi kinie yu lombili andoringi yembo awisili kinie, kolea Judia disiriki moloringi yembo awisili kinie, kolea awili Jerusalleme peringi yembo awisili kinie, nomu kusa kélona lierimu kolea awili Taya kinie Saidonoselonga peringi yembo awisili kinie, yu molorumune sukundu-sukundu ongo liku maku toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yu temane peanga topa, ungu mane sipe terimu pilingendo ongo, yuni eno kuru torumume ‘Tepa konde lipili.’ ningu oringi. Enonga yembo mare konopune kuru keri molorumume tepa konde lsimula. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yemboma tepa konde lili tondolomo yu pepili molorumu kulu eno oringime pali ‘Yuambolamili.’ ningu yu molorumune nondoko nondoko oringi. Kanu kinie ongo yu amboloringi kinie kanu tondolomone eno pea pali tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kanu kinie Yesusi manie molopa yu lombili andoringime olando sipe kanopalie enondo nimbendo: “Eno koropa pulimoma Pulu Yemo enonga ye nomi kingimu molopa eno nokolemomonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Eno kinié engele telemoma eno pe walse olo tembamonga eno malo. “Eno kinié kola telemelema eno pe walse tawe tengemonga eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Manie Omba Mana Ye A Lierimu Yemo pilku molemele yemboma, eno nanga yemboma molemelemonga we yembomane eno-kinie konopu keri panjiku, “Olio molemolona anjo paa.” ningu, enondo “Eno yembo kerime.” ningu, ningu kenjiku, enonga imbime pilku keri pilku tenge kinie eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“⸤Yembomane eno aku siku mele telemelemonga⸥ eno mulu koleana punge kinie kanune ⸤Pulu Yemone⸥ eno mele kalopa kondomba kene ⸤kanu yembomane eno aku siku teko kenjinge⸥ kinie konopu awili teko siku, konopu paa peanga pepili molangi. Yembomane kinié eno mindili silimele mele, aku siku eno naa molangi koro-ou Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siliku andoringi yemboma we yembomane eno kepe mindili siringila kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nalo eno kamako lemelema, ou kinié eno molko kondoko konopu peanga pepili molemele melema koronga nosilimele, pe aku siku naa molongemonga mindili nongo molko kenjinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Eno kinié olo telemo yemboma pe walse engelene kolongemonga mindili nongo molko kenjinge. Eno kinié tawe telemele yemboma pe walse eno kola tengemonga mindili nongo molko kenjinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","We yembomane pali eno kapi ningu taki teki enondo “Yembo peangama.” ninge kinie eno mindili nongo molko kenjinge. Kanu yembomane enondo ungu peangama ningu kapi ninge mele ou eno naa molangi koro ou Pulu Yemone ungu umbu tondorumume naa pilku we kolo toko yembo ningu siringi yembomando iyembomanga anda kolepalimene ungu peangama aku siku niringila. ⸤Pulu Yemonga ungume sumbi siku niringi yembomando kapi naa ningu mindili siringi kanumu.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","⸤Aku nimbelie Yesusini we moloringi yembomando nimbendo:⸥ “⸤Akumu na lombili andolimendo nikiru⸥ nalo nane ungu nikirume pilku molemele yemboma, enondo ungu te pea niembo piliengila! Enone enonga opa puluema konopu mondoko, eno-kinie konopu keri panjilimele yemboma teko kondoko teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Enondo ‘Yembo kerime kene molko kenjengi!’ nilimele yembomando ‘Eno yembo peangama kene molko kondangi.’ niengi. Eno teko kenjilimele yemboma ‘Pulu Yemone lipe tapondopili.’ ningu enone enonga mawa tendangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Yembo tene nunge kumbikere ekendonga larauwe tomba kinie topele toko ‘Ekendonga kamu larauwe topili.’ nieni. ‘Nunge wale sulu peangamo liembo.’ nimbé yembomo nunge wale-pakolimu kepe ‘pea we lipili.’ nieni. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Melema si.” ningu mawa tenge yemboma pali melema we sieni. Nunge melema we limbe yembomondo “Altoko nanu si.” ni naa nieni. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“‘Yembomane nu-kinie teangi.’ konopu leno mele, nuni anjo yemboma aku siku teani. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ulu pulu keri telemele yemboma kepe enono anjo yando kondo kolemele pilkulie eno yando kondo kolemele yemboma mindi kondo kolonge manda molo. Eno kanoko keri kanolemele yemboma pea kondo kolangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ulu pulu keri telemele yemboma kepe enono anjo yando kondo kolko teko kondolemele pilkulie eno yando kondo kolko teko kondolemele yemboma mindi teko kondonge manda molo. Eno teko kenjilimele yemboma pea teko kondangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ulu pulu keri telemele yemboma kepe enono anjo yando pundu anjiku, ‘Walse altopo sukundu limbo’ ningu pundu anjilimele pilkulie, eno yando pundu tolemele yemboma mindi pundu anjinge manda molo. Eno pundu naa tolemele yemboma pea pundu anjengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“⸤Ulu pulu keri telemele yemboma enono anjo yando telemele mele eno ulu te olandopa teangila.⸥ Enone enonga opa puluema kepe kondo kolko, teko kondoko, pundu anjiku, teangi. ‘Enone pe walse altoko aku siku yando teangi.’ ni naa ningu, we teangi. Aku siku tenge kinie Pulu Yemonga ambolangoma molkolie, yuni eno mele awisili kalomba linge. Pulu Yemo yuni mana yemboma-kinie aku sipe tepa molemola. Yu teko kenjilimele yemboma kinie, yundu ‘Ange.’ naa ningu we molemele yemboma kinie kanume tepa kondolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Enonga Lapa Pulu Yemo teko kenjilimele yemboma kepe yu aku sipe kondo kolopa we tepa kondolemo mele eno teko kenjinge yemboma aku siku kondo kolko teko kondangi.” ⸤nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Enone yemboma telemele ulume naa apurunge kinie ⸤Pulu Yemone⸥ eno ulu telemelema naa apurumbela. Enone anjo yembomane telemele mele apuruku kanokolie “Teko kenjikimili. Tekemele mele ⸤Pulu Yemone⸥ kanopa keri kanopili.” naa ninge kinie ⸤Pulu Yemone⸥ enone telemele mele apurupe kanopalie “Teko kenjikinu. Tekeno mele kanopo keri kanokoro.” naa nimbéla. Yembomane eno-kinie teko kenjinge ulume ‘Manie pupili.’ ningu siye kolonge kinie ⸤Pulu Yemone⸥ enonga ulu pulu kerime ‘Manie pupili.’ nimbe siye kolombala. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Enone yemboma pe-pe kepe ‘Pundu naa tangi.’ ningu melema we singe kinie yuni eno aku sipe we simbela. Melema simbendo koltalo naa simbe; olandopa olandopa simbe. Enone anjo singe kanopalie eno yando aku sipe simbela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesusini enondo ungu iko wallo te topa sirimula. Akumu isipe: “Mongo keri lieli ye tene mongo keri lieli ye te aulke manda lipe ora simbeye? Peaselo kombune manda naa tolkaye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ungu mane pilku mololi yemboma enonga ungu mane silimu toko manie naa mundulimele. Ou ungu mane pilku puku pora silimele kinie pe mindi enonga ungu mane silimu pea kapola-kapola mele molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nuni angenanga mongona nurupulu te lemo kanoleno nalo nunge mongona unjo awili te lemomo naa kanoleno akumu nambemune telenoye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nunge mongona unjo awili lemomo naa kanokolie angenando “Ano, nunge mongona nurupulu te lemomo wendo lindembo.” nambeko nilinoye? Topele mapele toli yembomo, nuni nunge mongona lemo unjo awilimu ou wendo likulie pe kanoko kondoko angenanga mongona lemo nurupulumu manda wendo lindení.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","⸤Kanu kinie Yesusini ungu te pea nimbelie ungu iko pokore topalie nimbendo:⸥ “Unjo peangamone mongo keri te manda naa tomba; unjo kerimuni mongo peanga te manda naa tombala. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Unjo mongo te kanokolie kanu mongo torumu unjomo imbi manda silimele. ‘Amu nambo.’ ningu, takeme manda olko toko naa nolemela. Molo ‘Me te nambo.’ ningu, silipu manda mengo naa nolemela. Amu lupela takeme lupela kanoko, me lupela silipu lupela kanolemele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aku sipe mele, yembo peanga tene yunge konopune ulu peanga pelemoma telemo, nalo yembo keri tene yunge konopune ulu keri pelemoma telemo. Yembo te yunge konopune pelemo ungume mindi kerena nilimo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nane nilio ungume pilku liku naa tekolie enone nando “Awilimu” we nambemune nilimeleye?” ⸤nimbelie pe yuni ungu iko te pea enondo topa nimbéndo:⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“I nanga ungume pilku liku tenge yemboma eno ye te molemo mele niembo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ye te yuni yunge ulkemo ‘Ingi nimbe angiliepili.’ nimbe we ma kinie ukia kinie akupe ltepalie, akune manie kou polona ola takorumu. Ulkemo aku sipe takopa kondorumu kulu pe no topa ulkemo paa topa kalalu simbe terimu kinie topa tekise naa tekisipe ingi nimbe we angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Nalo inanga ungume pilku liku naa tenge yemboma eno ye te molemo mele niembo: Ye te yunge ulke we ma pange teline ola walu takorumu. Pe no topa ulke kanumu topalie ulkemo walsikele kamu topa kalalu sirimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yemboma piliengi kanu ungume nimbe pora sipelie Yesusi Kapeniame taonona sukundu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akune Romo yembomanga ami ye wane anderete nokorumu ye tenga kendemande te yu paa konopu mondorumumu kuru awili tepa topalie yu kolomba tepa lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kanu ami ye nomimuni Yesusi orumu pilipelie yuni Juda tapu ye mare lipe Yesusi molorumune mundupelie nimbendo: “Nanga kendemandemo ⸤kuru awili tepa tomu kene⸥ ongo teko konde li.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Kanu Juda tapu yemane Yesusi molorumune ongo aku siku ningu, yunge ningu tondolo munduku mawa tendekolie ningendo: “I kendemande kolkomomonga ami ye nomimu yu paapeanga. ⸤Yu Juda ye te molo⸥ nalo olio Juda yemboma konopu mondopa, olio maku topo Pulu Yemonga ungumu pilimolo ulkemo yuni takondorumu kene nuni yu liku tapondonu liemo papu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aku niringi pilipelie Yesusi eno kinie kanu yemonga ulkena pumbe purumu. Kanu ulkemonga nondopa orumu kinie kanu ami ye nomimuni yunge pulu lemo yembo mare Yesusi orumune lipe mundorumu ongolie yundu ningendo: “Ami ye nomimuni isipe nikimu: “Awilimu, na ye kerimu mele molio, nu nanga ulkena oni kinie kapola naa temba kene nu mindili siku ya naa wani. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Nu molenona na ye kerimu manda naa ombóla konopu liendu. Na ye tene kepe nokopa molemo, yunge ungumu pilipu lipu telio. Nane kepe ami ye mare nokopo molio. Kanu yemanga tendo “Pu.” nilio kinie yu pulimo. Molo tendo “Ou.” nilio kinie yu olemo. Molo nanga kongono tendeli kendemande yembo tendo “I siku tei.” nilio kinie yu aku sipe telemo kanumu. Aku sipela, nuni ungu te we nini kinie nanga kendemande ⸤yemo⸥ we konde pumbe kene nu we ni.” nikimu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusini Romo ami ye nomimuni nimbe mundorumu mele pilipelie yu konopu awisili lipe mundupelie yu lombili oringi yembomando nimbendo: “Nane enondo paa sike nimbu sikirumu: I Isirele yembomanga talapena ulsu mololi yemone na ungumuni mindi manda temba mele nimbe tondolo mundupe pilimo mele koleamanga pali, Isirele koleana sukundu kepe, yembo telurini kepe aku siku pilieringi mele paa naa kanorundu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aku nirimu pilkulie ami ye nomimuni Yesusi molorumune mundorumu yema kanu ami yemonga ulkena yando ongolie kendemandemo konde purumu kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesusi Nene taonondo purumu, yu lombili andolime kinie yembo mare awisili kinie pea puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yu taono pala kerepulune nondopa purumu kinie Nene ye te kolorumumu ono tengendo taropola teko mengo ulsu punge oringi. Kanu kolorumu yemo yunge anumu lapaselone yu komolayemo meringili kinie pe te lupe naa meangili lapa kolorumu. Pe yunge anumu ambo wayemo molopili yu kolorumula. Kango kanumu ono tengendo yembo awisili anumu kinie tapu toko puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Awilimuni ambomo kanopalie paa kondo kolopa yundu “Kola naa tei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kanu kinie yu yembo taropolamonga nondopa omba taropolamo omba ambolopalie, meringi yema we mengo angiliengi yuni nimbendo: “Kango yemo, ola molou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kanu kinie kolorumu yemo ola molopa yu ungu nirimu. Kanu kinie Yesusini ye kolorumumu lipe yemo yunge anumu yuyu sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yesusini aku terimu-ne yembomane pipili kolkolie ningendo: “Pulu Yemonga ungu umbu tondolime pilipe yemboma nimbe sili ye awili te olio molemolona wendo omu lepamo.” ningu Pulu Yemo yunge imbi liku ola mundundukulie ningendo: “Pulu Yemo yunge yemboma molemelena omba lipe tapondomu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","I Yesusini terimumunge temanemo kolea Judia disiriki pali kinie Judia ulsu kolea lupe lupema pali kinie anjo anjo purumu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesusini terimu mele Jono yu lombili andolimene yundu ningu siringi kinie yuni yu lombili andolimenga talo “Yando wale.” nimbelie Yesusi molorumune elo lipe mundupelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“⸤Pulu Yemone olio nokopa kondomba yere⸥ “Lipu mundumbo.” nimbe, nimbe panjerimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo te lupe ombámo nokopo molamiliye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kanu yeselone Yesusi molorumune ongolo yundu ningelendo: “No Lindeli Jonone olto lipe mundupelie nimbendo: “⸤Pulu Yemone olio nokopa kondomba yere⸥ “Lipu mundumbo.” nimbe, nimbe panjerimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo te lupe ombá nokopo molamiliye?” nimu.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aku siku walsiku pilkululie niringilimuni, ena tenga ⸤we kanoko angiliengili⸥ Yesusini kuru lupe-lupe torumu yemboma kinie, konopune kuru molorumu yemboma kinie, mongo keri lierimu yembo awisili kinie, tepa konde lipe molorumu kanoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe Yesusini elondo topondopa nimbendo: “Elone yakanokombele mele kepe pilkimbili mele kepe Jono ningu si-pele. Mongo keri lieli yemboma mongone kanoko, kimbu keri lieli yemboma kapola andoko, kuru laká nolime umbu kangi angilipe, komu silime komuni pilku, kolopa lielime ola molemele kepe, koropa pulime temane peangamo topo silio pilimelela kanumu. Aku siku Jonondo ningu siele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na kanokolie ‘Yu sike kanu yemo molemo.’ ningu tondolo munduku pilkulie, altoko konopu talo naa panjiku molonge yemboma eno malo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonone mundorumu yeselo kelko nendo puringili kinie Yesusini kelepa yembo awisili maku toko moloringimendo Jonondo nimbendo: “⸤Kolea ku lieline Jono no lindipe molorumu kinie⸥ eno kanu kolea ku lieline nambolka kanonge puringiye? ⸤Molo⸥ lkepanie mele poporomene lope-lope tendepa molorumu te kanonge puringiye? ⸤Jono yu aku sipe mele molo kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","⸤Alieli kanolemele mele kanonge naa puringi liemo⸥ ulu nambolkare kanongendo puringiye? Ye te mulumbale paa peangama pakopa molorumu kanonge puringiye? Akumu molola. Yembo kamako molko, mele awisili nosiku, mulumbale paa peangama pakolemelema ye nomi kingimenga ulkena manjiku molemele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“⸤Aku sili te kanonge naa puringi liemo⸥ Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe sili ye te kanonge puringiye? Akumu sike nalo nane enondo nimbu sikiru. Jono yu sike Pulu Yemonga ungu umbu tondorumume pilipe nimbe sili ye te nalo yu Pulu Yemone ungu umbu tondorumume pilipe nimbe sili ye we te molo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yuni Pulu Yemone ou “Lipu mundumbo.” nirimu yemonga aulkemo tepa mimi temu kanumu. Kanu yemondo Pulu Yemonga bokune sukundu molemo ungu te isipe: ‘⸤Pulu Yemone yunge Malondo nimbendo:⸥ “Pilieyo! Nanga ungu nindimbe yemo nane nu puni aulkena yu kumbi lepo lipu mundukuru. Yuni nunge aulkemo akisindimbe.” nirimu.’ kanu ungumu bokune molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nane enondo paa sike nimbu sikirumu: Ou mana moloringi yembomanga te ⸤No Lindeli⸥ Jono kinie manda molo. Jono olandopa mele. Nalo kinié wale kondemo wendo okomo. Kanu walemo Pulu Yemo ye nomi kingi molopa nokolemo yembomanga te paa imbi naa molopa paa koropa puli yembomo olandopa; Jono yu maniendopa. ⸤Ou moloringi yemboma manie mele; kinié na ‘Sike.’ ningu tondolo munduku pilingemonga konopu peanga pemba yemboma olandopa.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesusini aku sipe nirimu pilkulie we yemboma kinie kou takisi lsingi yema kinie Yesusini Jonondo nirimu ungumu pilku peanga pilku Pulu Yemo kapi niringi. Kanu yembomane ou ⸤No Lindeli⸥ Jonone nirimu ungumu pilku peanga pilkulie eno ulu pulu keri teringime bulu siku, konopu alowa teko ‘Olio Jonone no lindepili.’ ningu no lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nalo Parisi yema kinie, Pulu Yemonga ungu manemanga pulume pilku kondoringi yema kinie, enone ‘Pulu Yemone Jono naa mundorumu.’ ningu pilkulie, Pulu Yemone “Yembomanga lipu tapondopo tendembo.” nirimu ungumu pilku keri pilku bulu sikulie pe ‘Jonone olio no naa lindepili.’ ningu no naa lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kanu kinie Yesusini ungu te pea nimbendo: “Kinié mana molemele yemboma nambolka melte eno manda manjipu manda nimbonje? ⸤Eno molemele mele isipu nimbu siembo:⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eno yemboma maku tolemele koleana ambolangoma pepe pereko molemele mele. Kanu ambolangomanga marene ne anjo molemele ambolango mare ⸤pea pepe pereko molonge aulke te koroko kelkolie⸥ enondo walsikulie ningendo: “Konana nimulu kinie eno ‘Pea konana niemili.’ naa ningu “Molo.” ningi. Pe kelepo kola temulu kinie eno ‘Pea kola teamili.’ ni naa ningi. ⸤Pea pepe perepo molomolo aulke te molo lepamo.⸥” nilimele. ⸤Kinié molemele yemboma eno kanu ambolangoma mele molemele.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","⸤Na kinie No Lindeli Jono kinie oltone nilimbolo ungume enone pilku keri pilimele; telembolo mele kanoko keri kanolemelela⸥. Jono ombalie ga kinie no waene kinie naa nomba molorumu kinie ⸤kanoko keri kanokolie⸥ ningendo: “Yunge konopune kuru te molemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pe Manie Omba Mana Ye A Lierimu Yemo omba ga kinie no waene kinie norumu kinie ⸤kanoko kerila kanokolie⸥ ningendo: “Yu ga awisili nomba keri pilipe, no waene awisili nomba kekelepa topa telemo yemo. Yu kou takisi lili yema kinie, ulu pulu keri telemele yembo wema kinie ‘Yu kinie pulu liepili pea tapu topo molamili.’ nimbe telemo.” nilimelela. ⸤Enone aku siku Jono kanoko kerila kanolemele. Na kanoko kerila kanolemele.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nalo pilipe konginjeli ulu pulumu Pulu Yemo kinie pelemo-na yunge ambolangomane pali yuni telemo melemando ‘Papu telemo.’ ninge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Walse, Parisi ye tene Yesusindu “Langi pea nambili ou.” nirimu kinie yunge ulkena suku pupe akune langi polona nondopa polo tenga manie molorumu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","kanu koleana molorumu ambo ulu pulu keri teli tene Yesusi yu kanu Parisi yemonga ulkena suku langi nomba molorumu pilipelie, yu kopongo wele paa komindi te mingi pali lipe akune memba pupelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesusi molorumune bulkundu kimbune nondopa kola tepa angilipelie, pe Yesusi yunge kimbuselo kola mongone kulumiye tondopa, pe ambomo yunge penge lapisemo lipe kanu kimbuselo kulu tondopa, kimbuselo kangulupe, kopongo wele memba orumu kanumuni kimbune ape kandondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kanu ulke pulu ye Parisi ⸤Saimono⸥ yuni ambomone aku terimu kanopalie yuyu konopuni pilipelie ‘Iyemo paa sike Pulu Yemone ungu umbu tondolemo pilimo ye te molkanje i ambo yu ambolkomomo molemo mele kinie ulu keri telemo mele kinie manda pilipelie “Na naa ambolko, ongo wendo pu.” nilke.’ konopu lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesusini ⸤Saimono⸥ konopuni pilierimu mele pilipelie yundu nimbendo: “Saimono, nu ungu te niembo.” nirimu kinie Saimonone topondopa nimbendo: “Ungu Mane Silimu, kapola, ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","⸤Aku nirimu kinie Yesusini yundu temane te topa nimbendo:⸥ “Ye tene ye talo kou mone pundu anjipe sirimu. Ye te wane-anderete kina mele sipe, ye te tene kina mele sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pe elo pea pundu manda naa tondoringili kinie ye pundu anjerimu kanu yemone punduselo we siye kolopa “Uluri molo, yu tepili.” nirimu. Aku nirimumunge yeselonga nawene yu konopu olandopa mondorumu konopu lekenoye?” nimbe Yesusini Parisi yemondo aku nimbe walserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","⸤Kanu Parisi ye⸥ Saimonone yundu topondopa nimbendo: “Pundu awili anjerimu yemo, konopu lekero.” nirimu kinie Yesusini “Paa nikinu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanu kinie Yesusini topele topa kanu ambomo angilierimune kanopalie Saimonondo nimbendo: “I ambomo kána! Na nunge ulkena sukundu ondu kinie ⸤olio Isirele yembomane ye ponenge kokele olemo kinie telemolo mele⸥ nuni nando aku naa tenu. Nuni “Kimbu kulumiye tou.” ningu no naa sinu nalo i ambomone nanga kimbumu yunge kola mongone kulumiye tondopa, yunge penge lapisemo lipe nanga kimbumu kulu tondomu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na ondu kinie nuni na naa kangulonu nalo i ambomone na ondu kinie kepe yandopa kinié kepe nanga kimbumu kangulupe molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na ondu kinie nuni nanga pengena kopongo wele liku ape naa kandonu nalo i ambomone nanga kimbuselo kopongo wele komindi tene ape kandondomu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yuni ulu pulu keri awisili terimume manie pumumunge na konopu awili tepa mondopalie aku sipe temu. Nalo ulu pulu keri koltalo mindi telemo yembomo yunge terimu mele ‘Manie pupili, siye kolkoro.’ nimbé yemo konopu laye tepa mondombala.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ye Saimonondo aku sipe nimbe pora sipelie nirimumuni, ambomondo nimbendo: “Nunge konopune ulu pulu keri terinu pelemoma manie pupili, siye kolkoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aku nirimu pilkulie yu-kinie langi nongo moloringime yuni nirimu mele pilku keri pilkulie enone anjo yando ungu mele teko ningendo: “Yembomane ulu pulu keri telemelema iyemone “Manie pupili, siye kolkoro.” nikimu yemo yu naweye? ⸤‘Na Pulu Yemo.’ konopu lepalie nikimunje?⸥” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kanu kinie Yesusini ambomondo kamu nimbendo: “Nane nu ulu pulu keri terinu mele “Omba wendo pupili.’ manda nimbo.’ ningu pilku onumunge na sike aku sipu manda lipu tapondokoro kene nu konopu pe nipili mololiku pani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kanu kinie pe Yesusi pupe, kolea awilime kinie kangama kinie akumenga andopalie nirimumuni, Pulu Yemo ye nomi kingimu molopa yemboma nokomba temane peangamo topa silipe, yemboma ungu mane silipe andorumu. Yu lombili andoli ye engaki rurepo kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ambo mare kinie yu pea andoringi. Kanu ambomanga mare ou kuru topa, mare ou kuru enonga konopune perimu kinie Yesusini eno pali tepa konde lsimu. Te, kolea Makatalla ambo Maria, ou yunge konopune kuru yepoko pakera moloringimendo Yesusini “Ongo wendo paa.” nirimu kinie ongo wendo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te, ambo Joana, Susa menu. Susa yu kolea Gallilli disiriki ye nomi kingi Erotenga ulke tapu yemo. Te, ambo Susana. Eno kinie weambo awisili kinie Yesusi nokoringi. Kanu ambomane enonga kou mone noseringime likulie Yesusi kinie yu lombili andolime kinie enonga langi kinie melema topo toko liku siku nokoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kanu kinie Yesusi molorumune kolea lupe lupemanga moloringi yemboma sukundu sukundu ongo, liku maku toringi kinie yuni enondo ungu iko te topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ye tene rasi-witi umbu poniena andopa tanda sirimu. Tanda silipe andorumu kinie umbu mare aulkena manie purumu, kanume yembomane kimbuni kambilieringi; keramane ongo liku noringila. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Umbu mare kou perimune manie pupelie akune no naa molorumu kulu muli topa wendo omba walsikele kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Umbu mare kombulu-siri ka mele molorumune manie purumu, siri ka melemo wendo omba witi umbume topa norumu kulu omba peanga naa lepa ⸤mongo te naa torumu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Umbu mare ma peangana manie purumume wendo omba mongo peangama topa, mongo tokapu kise mele torumu.” ⸤nirimu.⸥ ⸤Aku nimbelie⸥ “Yembo komu-peo lemomane iungumu piliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","⸤Yesusini aku nirimu kinie⸥ yu lombili andolimene yundu ningendo: “Aku ungu ikomonga pulumu ningu si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kanu kinie yuni enondo nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma kinie melema kinie nokolemomonga ulu pulu ou yuyu pilierimu kanu ulu pulume ‘Eno kinié ⸤na lombili olemele yemboma⸥ piliengi!’ nimbelie eno ‘Ungu ikomanga pulume piliengi!’ nimbelie eno nimbe sikimu. Nalo we yemboma ‘Ungume nimbu siembo.’ nimbulie ungu ikoma mindi topo silio. ⸤Pulu Yemone Aisayanga kerena nimbendo:⸥ ‘Eno mongone kanokolie naa kanoko, komuni pilkulie naa pilimele.’ nirimu akumunge we yembomando ungu ikoma mindi tolio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aku nimbelie yuni nimbendo: “Aku ungu ikomonga pulumu isipe: “Langi umbu tanda sirimu kanu umbume Pulu Yemonga ungumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Umbu mare aulkena manie purumume yembo mare aku silime molemele. Enone ungumu pilimele kinie pe ⸤kurumenga nomi⸥ depelemo omba ‘Aku ungumu kamu tondolo munduku piliengi liemo Pulu Yemone eno lipe tapondopa aulke kerine wendo limbe kinie manda molo.’ nimbe ungu tanda sili konopune pupe pelemoma wendo limo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Umbu mare tanda sirimu kou perimune manie purumume yembo mare aku silime molemele. Enone ungumu pilkulie konopu siku pilku limele. Nalo eno pulkinio naa mundukulie ungumu laye kolte mindi pilku molemele. Pe eno konopune umbune temba kinie molo ⸤Setene omba⸥ manda manjipe kondi ka temba kinie, eno pilimele ungumu siye kolemele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Umbu mare tanda sirimu kombulu-siri ka mele molorumune manie purumume yembo mare aku silime molemele. Enone ungumu pilkulie pe aulkena punge punge kinie konopune umbune telemo umbunema kinie, mele awisili nosilimele melema kinie ya ma koleana ulume teko konopu singe ulume kinie, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinie ungumuni uluri naa tepa langi mongo kamu naa tolemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Umbu mare tanda sirimu ma peangana manie purumume yembo mare aku silime molemele. Enone enonga konopu peanga pepili molko ungumu pilkulie kanu ungumu kamu liku tondolo munduku pilkulie, tondolo pupili molemele kinie kanu umbume langi mongo ⸤awisili⸥ tolemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","⸤Yesusini enondo ungu iko te pea topa nimbendo:⸥ “Yembomane tepe-llame kandokolie mingine suku naa panjiku polo maniekondo naa nosikulie nilimelemone, ‘Yembo ongema kolea kanangi ulkena suku patepili.’ ningu polo tenga ola nosilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aku sipe mele, kinié lopi telemo melema pe walse mona lemba yemboma kanonge; kinié aki topa lemo melema pe walse patemba kinie yembomane kanu melema kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Aku temba kene enone ungu pilimele akumu mimi siku piliengi! Pulu Yemonga ungumu pilku molemele yemboma paa olandopa nimbe simbe pilinge. Pe paa awisili pilinge. Nalo naa pilku molemele yemboma eno laye-kolte pilimele ungumu kepe wendo limbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Walse Yesusi ulke tenga suku molorumu kinie yunge anumu kinie angenupili kinie yu kanongendo oringi. Akune yembo awisili ekelepa teko moloringi kulu yu molorumune nondoko manda naa ongolie ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","⸤ungu te ningu mundoringi kinie⸥ yembomane yundu ningendo: “Aminie kinie angenali kinie nu kanongendo ongo pena angilimele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesusini enondo topondopa nimbendo: “Pulu Yemonga ungumu pilku liku telemele yemboma nanga anumu kinie nanga angenupili kinie molemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Walse, Yesusi kinie yu lombili andolime kinie eno nona andoli sipi tenga sukundu puringi kinie pukulie, yuni enondo nimbendo: “Nomu nekendo pamolo.” nirimu kinie akune punge puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sipine punge puringi kinie Yesusi yu uru perimu. Yu uru pepili poporome awili te nomune torumu. Aku terimu-ne ⸤nomumu apisipe ola ombalie⸥ no sipine sukundu sukundu omba peke lepalie sipimu memba nona manie pumbe terimu kinie eno no wangonge teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanu kinie yu uru perimune puku toko makinjindikulie ningendo: “Ye Nomimu, Ye Nomimu, olio no wangokomolo.” niringi kinie yu makilipelie poporomemo kinie no apisipe ola orumu nomumu kinie iri torumu. Kanu kinie poporomemo topa kelepa, nomumu lope naa tepa we lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kanu kinie yuni lombili andolimendo nimbendo: “‘⸤Pulu Yemone olio nokomba.’ ningu⸥ tondolo munduku naa pilkimiliye?” nirimu. ⸤Yuni terimu mele kanokolie⸥ yemane pipili kolko mini-wale mundukulie anjo yando enono walsikulie ningendo: “Apa! Iyemo nawenje? Poporomemone kepe nomumuni kepe yuni elondo “Teale.” nilimo ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kanu kinie nomune nekendo puku kolea Gerasa puringi. Nomu yakondo kolea Gallilli, nomu nekendo kolea Gerasa kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Akune oringi kinie Yesusi sipine wendo omba kélona angilierimu kinie kanu kolea ye te yu molorumune orumu. Kanu yemo kuru awisili yunge konopune molorumumunge mulumbale telu kepe naa panjipe, we-we andopa, ulke tenga naa pepa, yembo ono koleana pelipe andopa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kurumuni kanu yemo taki teki lsimu kulu yembomane ka-senene yu kimbu kime ka toko yu nokoko moloringi nalo ka-senema sungu sirimu kinie pe kurumuni kolea ku lieline yu memba purumu. Kanu yemone Yesusi kanopalie kalle nimbe yu angilierimune manie molopa tamalu pepa tondolo mundupelie nimbendo: “Yesusi, Pulu Ye Paa Olandopa Awilimunge Malo, na-kinie ulu nambolka uluri tenindu onuye? ‘ “Na mindili paa naa lipu simbo.” ni.’ nimbu mawa tekero.” nirimu. ⸤Yu kokele ombá orumu kinie⸥ Yesusini ou nimbendo: “Kurumu, iyemonga konopune ongo wendo pu.” nirimu mele pilipelie yemone aku sipe “Naa tei.” nimbe mawa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aku nirimu kinie Yesusini yemondo walsipelie nimbendo: “Nunge imbi naweye?” nirimu kinie yemo yunge konopune kuru awisili molorumu kulu pilipelie yuni “Nanga imbi Paa Awisili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kanu kuru awisilimene wale awisili Yesusi mawa tekolie ningendo: “Olio ‘ongo wendo pangi.’ ningu toko makorokolie “⸤Ima koleamo munduku siye kolko⸥ Pulu Yemone kowa muru paa lepa mindi pupe pora naa nilimo murumunge ⸤olionga ye nomi Setene walse lipe mundumbe⸥ kanu murumunge paa.” ni naa ni.” ningu mawa teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akune ma pangi tenga umbu kongi awisili ímu nongo moloringi kanokolie Yesusi mawa tekolie ningendo: “Olio ⸤toko makorokolie⸥ ‘Ne kongimenga konopune molo-pangi.’ ni.” niringi kinie yuni “Kapola, akune pangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aku sipe nirimu kinie kurume kanu yemonga konopune wendo ongolie kongi akune moloringimenga konopune puku moloringi kinie kanu kongime kekelepa toko lkisiku puku kopona pukue toko nomune suku puku no wangoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ulu akume wendo orumu-ne kanokolie kongi tapu teko moloringi yema talopa leko pukulie niringimuni, kolea awiline moloringi yemboma kinie, kolea kangamanga moloringi yemboma kinie, ulu akume wendo orumu mele temanemo toko siliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kanu temanemo pilieringi yemboma ‘Ulume wendo orumu mele kanamili.’ ningu wendo puku Yesusi molorumune ongolie ou kuru awisili konopune molko ongo wendo puringi yemo mulumbale pakopa, umbu konopu pepili Yesusi molorumune nondopa manie molorumu kanokolie eno pipili koloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yesusini terimu mele mongone kanoringi yembomane pe oringi yemboma ningu siringi. Kuru awisili konopune moloringi yemonga konopune kurume ongo wendo puringi kinie yemo yu umbu konopu pepili molorumu mele ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kanu kinie kolea Gerasa yemboma pali paa mini-wale mundukulie Yesusi mawa tekolie ningendo: “Olionga koleana naa mololi kelko pu.” niringi kinie yu kelepa pumbendo nona andoli sipine suku purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","⸤Yu pumbe terimu kanopalie⸥ kuru awisili konopune ou molko wendo oringi yemone yundu nimbendo: “Pea pambili.” nimbe mawa terimu. Nalo Yesusini “Molo.” nimbe yundu nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nulkondo puku Pulu Yemone nu lakopa tepa kondomu mele nunge yemboma ningu si-pou.” nirimu. Yesusini aku nirimu-ne pilipelie ye kanumu pupe kolea awiline suku moloringi yemboma pali Yesusini yu-kinie lakopa tepa kondorumu mele nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kanu kinie Yesusi yu nomu yakondo orumu kinie yu ‘Ombá.’ ningu maku toko nokoko moloringi yembomane “Nu papu okono.” ningu konopu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke te nokorumu ye te, yunge imbi Jairasi, Yesusi molorumune orumu. Kanu kinie yu Yesusinge kimbune nondopa omba manie molopa tamalu pepa yundu mawa tepalie nimbendo: “Nanga ulkendo pea pambili ou.” nirimu. Yemo yunge ambolamo, yunge lemenu telu mindi, yu ponie engaki rurepo mele omba purumu kanu ambolamo, kuru paa awili tepa torumumunge yu nondopa kolomba tepa lierimumunge ⸤yemone Yesusi aku sipe mawa terimu.⸥ Pe Yesusi kanu ulkena pumbe purumu kinie yembo awisili liku maku toko yu kakapu teko ekelepa teko pea puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kanu yembo pea puringimenga ambo te yunge pena perimu walema pora naa nirimu. Yu pena mindi pepili ponie engaki rurepo omba purumu. Yu doketamanga yunge kurumu ‘Pora nipili.’ nimbe andopa, yunge kou mone pali eno sirimu nalo kuru kanumu pora naa nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kanu ambomo Yesusi pumbe purumu kinie bulkundu omba, yunge wale pakolimunge pundumu ambolorumu kinie walsikele yunge kuru torumu kanumu pora nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aku terimu kinie Yesusini nimbendo: “Na nawene ambolomuye?” nirimu. Enone pali “Na molo.” niringi kinie ⸤yu lombili andoli ye⸥ Pitane yundu nimbendo: “Ye Nomimu, yembo awisili nu angilinona nondoko nondoko ongo kakapu teko ekelepa teko angilkimili kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nalo Yesusini altopa nimbendo: “Na yembo lipu tapondolio tondolo mare nanga kangine omba ulsu pumu kulu pilipulie yembo tene na ambolomumundu nikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aku sipe nirimu pilipelie ambomo yu lopi manda naa tepa, yu terimu mele Yesusi pilipe molorumu kanopalie yu kimbu ki puru-puru nipili Yesusi molorumune omba manie molopa tamalu pepalie, yemboma pilku angiliengi yuni ‘Kuru pora nipili.’ nimbe omba yu ambolorumu kinie walsikele konde purumu mele nimbe para sirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesusini yundu nimbendo: “Ambomo, ‘Nu manda tepa konde limbe.’ ningu tondolo munduku pilienu kanu ulumuni nu konde pukunu. Konopu pe nipili mololiku pani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusini ambomondo aku sipe nimbe molorumu kinie, ye te, yemboma maku toko Pulu Yemonga ungu pilieringi ulke nokoli ye ⸤Jairasi⸥ nge ulkena molopalie omba ⸤Jairasindu⸥ nimbendo: “Nunge ambolamo kolopa pora simu. Ungu Mane Silimu ‘Mindili nopili.’ ningu we naa mengo wani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yuni nirimu mele Yesusini pilipelie ⸤ulke nokoli yemondo⸥ nimbendo: “Mini wale naa mundoyo. Nunge ambolamo nane ‘Manda lipe tapondomba.’ ningu tondolo munduku pilku moloni kinie yu konde pumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Kanu kinie Yesusi yemonga ulkena ombalie ulkena sukundu yembo awisili ambola kolorumumu kondo kolko kola teko moloringi kanopalie enondo nimbendo: “Ambolamo kolou naa kolomu. We uru mindi pelemo kene kola naa teaa.” nirimu. Nalo yu sike kolopa pora sirimu pilkulie yuni “We uru pelemo.” nirimumunge enone yu ungu taka tondoko tawe tenderingi. Pe yu ⸤ambolamonga suluminiana⸥ pumbe purumu kinie ‘We yemboma pali naa ongo anjo paa.’ nimbelie Pita keme, Jono keme, Jemisi keme, kanu ambolamonga anumu lapaselo kinie “Eno mindi pea pamili.” nimbe ⸤ambola onomo lierimu⸥ suluminiana eno memba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pupelie ambolamonga kimu ambolopa yundu walsipelie nimbendo: “Ambolamo, nu ola molou.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","yunge mini purumu kanu minimu altopa sukundu orumu kinie ambolamo walsikele ola molorumu. Kanu kinie Yesusini ⸤anumundu⸥ nimbendo: “Ambolamo langi mare liku si.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yuni terimu mele kanokololie ambolamonga anumu lapaselo elo paa mini-wale mundoringili nalo yuni elondo tondolo mundupe nimbendo: “Ulu itekeromo yembo telurindu kepe anjo puku paa naa ningu siele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Walse Yesusini yu lombili andoli ye engaki rurepondo “Yando waa.” nimbelie, enone yembomanga konopune kuru molemoma “Ongo wendo paa.” ningu toko makoronge tondolomo sipelie, yembo kuru tolime ‘Konde pangi.’ ninge nambamo sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aku sipe tepalie enondo nimbendo: “Eno puku, Pulu Yemo omba ye nomi kingimu molomba temane peangamo yemboma toko siliku andoko, kuru tolime teko konde liliku pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Pungendo, eno melema naa mengo we pangi. Apulu mingi kepe, mele wale kepe, langi kepe, kou mone kepe, wale pakoli talo kepe naa mengo we pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Pe kolea tenga suku pukulie akune molongendo ulke teluringe suku pukulie akune mindi peko molkolie pe aku koleamo munduku siye kolko pangi. ⸤Ulke pinie-pinie naa andoko ulke teluringe mindi langi nongo peangi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kolea marenga suku punge kinie kolea pulu yembomane “Papu ongi. Pea peamili waa.” ni naa ningu enone ungu ningema pilku naa lingi liemo kanu koleana yembo kerime munduku siye kolko pungendo eno liku su singemonga kanu koleana yemboma ‘Kamu molko kenjengi! Pulu Yemone eno lipe naa tapondomba mele piliengi!’ ningu enonga kimbune kanu koleamanga ma angilimbema kulu tokolie pangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aku nirimu kinie kanu yema puku, koleamanga andoko, Pulu Yemonga temane peangamo toko siliku, kuru torumu yemboma teko konde liliku, teliku andoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kolea Gallilli disiriki nokorumu ye nomi kingi Erotene Yesusini terimu mele temane toringi pilipelie, ‘Iyemo nawenje?’ nimbe pilipe sundorumu. Yembo marene ningendo: “I yemo ⸤No Lindeli⸥ Jono ⸤talko kolorumu kanumu⸥ lomboropa wendo omunje.” ningu moloringi. Marene ningendo: “⸤Pulu Yemone ou konde molopili olando lsimu ye⸥ Illainja kelepa omba molemo.” ningu moloringi. Marene ningendo: “Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi ye koro ou moloringimenga ye te kolopalie lomboropa wendo orumu.” ningu moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","⸤Ye nomi kingi⸥ Erotene ⸤Yesusini terimu mele temane toringi⸥ pilipelie nimbendo: “⸤No Lindeli⸥ Jono ‘yunge pengemo wendo pupili.’ nimbu nomimu karu lierindu yu kolorumu nalo iulu tondolo lupe lupe telemopilio yemo yu nawenje?” nirimu. Aku sipe nimbelie “I ye Yesusi kanamboa!” nimbe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusini “Nanga kongonomo tende-paa.” nimbe lipe mundorumu yema yu molorumune kelko yando ongolie niringimuni ulu teringime yu temane toko siringi. Kanukinie kanu yema lipe memba pupe ‘Tenga oliolio molamili.’ nimbe eno Besaida taonona memba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nalo yembo paa awisili eno akune puringi mele pilkulie yu purumune akiliku lombili puringi. We yemboma oringi kanopalie Yesusini enondo “Papu ongi.” nimbelie eno Pulu Yemo omba ye nomi kingi molomba temane peangamo topa sipe, enonga yembo kuru torumume ‘Konde pangi.’ nimbe eno tepa konde lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pe ipupene ena pumbe terimu kinie yu lombili andoli ye engaki rurepo yu molorumune ongo yundu ningendo: “I koleana yembo te naa pelemo kene ya maku toko molemele yemboma ‘Puku kolea marenga langi topo toko liku nongo pe-pangi.’ ni.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aku niringi kinie Yesusini lombili andolimendo nimbendo: “Enone enono yemboma langi mare liku siengi.” nirimu. Enone yundu ningendo: “Ya langi awisili molo. Pillawa kaloli kanga kise pakera kinie oma kaloli talo kinie, aku langi pokore mindi lemo. Molo nuni ‘Olio kolea tenga puku iyembomanga langi topo toko lindi-pengi.’ ningu nikinuye?” ningu walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Kanu yemboma koltalo molo, ye pape tausini mele akune moloringi.) Kanu kinie Yesusini enondo nimbendo: “Yembomando ‘eno tokapu talo talo ningu manie molangi.’ niengi.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","enone aku siku yembomando niringi kinie yemboma pilku liku aku siku manie moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kanu kinie Yesusini pillawa kaloli kise pakera kinie oma talo kinie kanume lipelie mulu koleana olando sipe kanopa ⸤Pulu Yemo kinie⸥ “Ange.” nimbe langi akume ambolopa pike lepa lombili andolime moke tepa sipelie “Anjo yemboma siee.” nirimu, ⸤enone yemboma moke teko siringi⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eno pali kanu langime noringi kinie olo terimu. Pe lombili andolimene langi goli lierimume liku maku toko wale basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Walse, Yesusi yuyu Pulu Yemo-kinie ungu nimbe molorumu kinie yu lombili andoli ye pea moloringimendo walsipelie nimbendo: “Yembomane na imbi leko nawe nilimeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Enone yundu topondoko ningendo: “Marene “Nu No Lindeli Jono ⸤kolorumumu kinié kelepa lomboropa ola molemomo⸥.” ningu pilku, marene “Nu, ⸤Pulu Yemone ou konde molopili olando lsimu ye⸥ Illainja kelepa omba molemo.” ningu pilku, marene “Nu Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye te ou kolorumumu kinié lomboropa ola molemo.” ningu pilimele.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","⸤Aku niringi kinie⸥ yuni enondo walsipe pilipelie nimbendo: “⸤We yembomane aku siku nilimele⸥ nalo enone enono na nawe nilimeleye?” nimbe walserimu. Pitane topondopa nimbendo: “Nu ⸤Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ ou nimbe mako torumu ye nomi⸥ Kirasimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitane aku nirimu pilipelie Yesusini enondo tondolo mundupe nimbendo: “Na molio mele ⸤Pitane kinié nikimumu⸥ enone anjo yembo telurindu kepe ⸤isili ou⸥ paanaa ningu siee!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","⸤Nimbelie⸥ yuni ⸤yu-kinie wendo ombá mele⸥ eno nimbe sipelie nimbendo: “Manie Omba Mana Ye A Lierimu Yemo sike mindili awisili nombá. Juda yemboma nokolemele tapu yema kinie, Pulu Yemo popo tondoli ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane sili yema kinie, enone ⸤ningendo: “Yu Pulu Yemone naa mundorumu. Yu Pulu Yemonga Malo naa molemo.” ningu⸥ yu liku bulu siku yu toko kondonge. Yu toko kondonge kolomba kinie wale talo omba pumbe kinie yepoko sipemonga Pulu Yemone yundu ‘Lomboroko ola molou.’ nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kanu kinie Yesusini akune maku toko moloringimendo pali nimbendo: “Yembo tene ‘Yu lombili pambo.’ nimbelie yuni alieli yunge konopumuni pilimo melemanga ‘Topo manie mundembo.’ nimbe, yemboma unjo perana angilku mindili nongo kolemele mele yuni unjo pera mele gomo lembando ‘Na yu lombili pumbondo mindili nondu liemo papula; kolondu liemo papula.’ nimbelie na lombili opili. We naa opili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yembo tene yunge mana molopa naa kololi ulu pulumu ambolomba temba kinie yu kolopalie sike molopa kenjipe mindi pumbe. Nalo yembo tene na konopu mondopalie nanga kongono “Tendambo.” nimbe temba kinie yu kolopalie yu konde molopa kondopa mindi puli ulu pulumu sike kanopa limbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","⸤Akumu nambemune nikiruye?⸥ Yembo tene mana melema pali yuyu lipe nosipelie yu mini pali Pulu Yemo naa molomba koleana pupe mindili nomba molopa kenjilkenje kanu melemane kanu yembomo nambepa lipe tapondolkanje? Lipe naa tapondolkamo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Nanga yembo mare we yemboma kinie molkolie ningendo: “Olio Yesusinge ungume pilipu lipu, yu lombili andopo molemolo mele we yembomane naa piliengi!” ningulie, na kiyengo ningu lombili andolemele yemboma eno-kinie ulu te pe wendo ombá mele nimbu siembo: Manie Omba Mana Ye A Lierimu Yemo pe Lapanga tondolo patelimu kinie ⸤mulu koleana⸥ angello kake telime kinie ⸤manie⸥ ombá temba kinie, kanu we yemboma molongena yunge yemboma mona molongendo we yemboma molongena kanokolie yu ou naa opili ‘Olio yunge yemboma molemolo mele we yembomane naa piliengi!’ ningu pipili kolko lopi teko molonge yemboma yuni lipe wekendo kanopa, “Na moliona naa waa.” nimbéla.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Nane enondo paa sike nimbu sikirumu: Eno ya angilkimilimenga mare ou kolou naa kolangi Pulu Yemo ye nomi kingimu omba molopa kolea nokombando ombá kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusini ⸤yu lombili andolimendo aku sipe nimbe sirimu kinie⸥ pe koro te omba purumu kinie Pita keme, Jemisi keme, Jono keme, eno lipe meli pupe ‘Pulu Yemo kinie ungu niembo.’ nimbelie ma pangine ola eno lipe memba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yuni akune Pulu Yemo kinie ungu nimbe molopili yunge kumbikeremo alowa tepa, yu pakorumu mulumbalema ena tondolo topa yembomanga mongo takele telemo mele aku sipe kake terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yu aku sipe molopili, ⸤Juda yembomanga koronga-ou moloringili ye awili talo,⸥ Mosisi kinie Illainjaselo, ongolo paterimune ongo angilkululie elo kinie Yesusi kinie enone Yesusi yu kolea awili Jerusalleme akune Pulu Yemone yundu ‘Tei.’ nirimu mele tepa kolomba mele ningu moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita kinie, yu pea akune moloringi yeselo kinie, eno siye tepa uru ombá terimu nalo pe eno makiliku umbu konopu pepili molkolie Yesusi yunge kangi alowa tepa molorumu mele kinie, yunge tondolo paterimu mele kinie, yu kinie angilieringili yeselo pea kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kanu kinie aku yeselo pungele puringili kinie Pitane Yesusindu nimbendo: “Ye Nomimu, olio ya molopamolo peanga lepamo. Olione ulke takaye yepoko takondamili. Te nunge, te Mosisinge, te Illainjanga takondamili.” nirimu. (Nalo aku nirimumu ⸤pipili paa kolopalie⸥ yuni nimbé mele naa pilipe ungu te walu nirimu.) ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitane aku sipe nimbe molopili kupe te omba eno aki torumu. Kupena sukundu puringi kinie eno pipili terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kupe torumune sukundu ungu te wendo ombalie nimbéndo: “I yemo nangaa Nane ⸤‘Enonga’ nimbu⸥ yu mako topo lipu mundorundu. Yuni ungu nimbéma pilku liengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aku ungumu nimbe kelierimu kinie Yesusi yu mindi molorumu kanoringi. Enone aku siku kanoringi mele anjo naa ningu para siku, yembo teluri kepe ou naa ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Opali, ipulueli-ou ⸤Yesusi kinie yu lombili andoli ye yepoko kinie⸥ eno ma pangine maniendo onge oringi kinie yembo awisili yu linge oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oringi yembomanga ye tene Yesusindu nimbendo: “Ungu Mane Silimu, ‘Nanga kango nanamo, yu nanga kango telumu mindi, kondo kolko liku tapondani.’ nimbu mawa tekero. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yunge konopune kuru te pelemomone yu lipe mindili sipe tolemo kinie kangomone kalle nimbe, yu kuru kopari topalie apoupu memba molemo. Yu aku sipe taki teki telemo-na kangomo yu kangime pange-mange telemola. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nu lombili andolimendo aku temanemo topo sipu enone kanu kurumu ‘Makorangi.’ nimbu mawa tendu nalo eno manda naa tengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","⸤Aku nirimu kinie⸥ pilipelie Yesusini ⸤yemboma iri topalie⸥ nimbendo: “Kinié molemele yemboma eno ⸤‘Pulu Yemone ulume sike manda temba.’ ningu⸥ tondolo munduku naa pilimele. Eno konopu karaye tepa pepili molemele yemboma, na eno-kinie molopo, wale nambepo molopo mane sipu ulu mare lipu ora simbo kinie mimi siku pilingeye? ⸤Na eno-kinie siye tekemo.⸥” nimbelie pe kanu yemondo nimbendo: “Nunge kangomo na moliona mengo ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Memba ombá orumu kinie kanu kurumuni kango kanumu topa lipe manie mundupelie yu torumu kinie Yesusini kurumu iri topa kangomo tepa konde lipelie, yu konde molorumu kinie lapa sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aku sipe terimu kanokolie yemboma Pulu Yemonga tondolomo konopuni pilkulie mini-wale mundoringi. Yuni terimu mele eno suru ningu mini-wale munduku molangi Yesusini yu lombili andolimendo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“I nikiru mele pilku kondayo. Manie Omba Mana Ye A Lierimu Yemo ⸤ka sikulie yu tonge⸥ yema anjo singe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nalo yuni nirimu ungumu pilku sundukulie ‘Iungumunge pulumu nambolkarenje, naa pilkimulu.’ niringi nalo “Nambolka ningu nikinuye?” ningu walsiku pilingendo pipili kolko naa walseringi. Pulu Yemone ‘Eno kanu ungumunge pulumu isili ou naa piliengi!’ nimbe terimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","⸤Walse Yesusi lombili andolimene⸥ eno enono anjo yando ungu mele tekolie ningendo: “Olionga ye nawe paaolandopa molemoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Enone konopu lieringi mele pilipelie, Yesusi ambolango kanga te lipe yu molorumune nondopa mondopalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","enondo nimbendo: “Yembo tene ‘Na Awilimunge yembomo molio.’ nimbe i ambolangomo lipe tapondomba kinie kanu yembomone aku tembamonga na lipe tapondombala. Kanu kinie na lipe tapondomba yembomone na lipe mundorumu yemo lipe tapondombala. Enonga ye tene ‘Nanga imbi ola naa molopili.’ nimbe, ‘Ye tenga lupe imbi ola molopili.’ nilimo yemo yu enonga paa olandopa molombamonga ⸤aku sipe ulumu pemba⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yesusi lombili andoli ye Jonone Yesusindu nimbendo: “Ye Nomimu, olio kanomulu, ye tene nunge imbi lepa kuru mare yembomanga konopune molongime “Ongo wendo paa.” nimbe topa makoropa molomu kanomulu. Kanopolie yu olio pea tapu topo naa molemolo kene yundu “Nu aku siku naa tei.” nimulu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aku nirimu kinie pilipelie Yesusini yundu ⸤kanu yemone terimu ulumundu⸥ nimbendo: “Yembo te olio-kinie opa pulue naa molemo yembomo olionga opa lkerayemo molemo kene enone yundu “Molo.” naa niengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kanu kinie Yesusi kolea awili Jerusalleme yu kolopalie pe mulu koleana olando pumbe walemo nondopa wendo orumu pilipelie konopu tondolo mundupe ‘Jerusallemendo pambo.’ nimbelie pumbe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yu lombili andoli ye mare lipe mundupelie nimbendo: “Kinié ipulueli kolea Sameria lierimu taono te nondopa lembana peamili kene eno akune puku olio manda pemolo ulke te koroko liengi.” nirimu kinie puku kororingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nalo kanu Sameria yemboma ⸤eno kinie Isirele yemboma kinie opa pulue molkolie⸥ yu Jerusallemendo pumbe purumu kanokolie enone “Molo, yamanda naa penge.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aku siku niringi kanokolie yu lombili andoli ye Jemisi kinie Jonoselone yundu ningelendo: “Awilimu, ‘oltone ‘Mulu koleana tepe wendo omba i Sameria yemboma nomba kondopili.’ niembili.’ konopu lekenoye?” ningu walseringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nalo yu topele topa elo kanopa iri topa “Aku ningu kenjikimbili.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yu kinie eno kinie kolea tenga puku pe-poringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eno aulkena punge puringi kinie ye te omba Yesusindu nimbendo: “Nu puni koleamanga pali nu lombili ombó.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusini yundu nimbendo: “Pílie! Owa takerama ulke pelemelemanga pelemele; kerama enonga mi takolemelemanga pelemele; nalo Manie Omba Mana Ye A Lierimu Yemonga pelemo kolea te naa lemo ⸤kene, nu ‘Yu lombili pupulie kapola naa molombo.’ ningu pilkulie na lombili wani. We naa wani.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kanu kinie yuni ye tendo nimbendo: “Na pea pambili lombili ou.” nirimu kinie kanu yemone yundu topondopa nimbendo: “Awilimu, ⸤nu kamu lombili wambo mangali⸥ ou pupu nanga lapamo-kinie pea molambo. Pe yu kolomba kinie ono tepolie nu lombili ombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nalo Yesusini yundu altopa nimbendo: “⸤Nanga ungumu naa pilku⸥ yembo kololi ⸤none teli⸥ yembomane yembo kolongema ono teangi. Nu ‘Pulu Yemo omba ye nomi kingimu molopa yemboma nokomba temane peangamo yemboma piliengi!’ ningu toko siliku andani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kanu kinie ye tene yundu nimbendo: “Awilimu, nu lombili ombó nalo ou pupu nanga yemboma kondo kolopo ‘Molaa.’ nimbulie pe nu lombili ombó.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesusini yundu nimbendo: “Na ‘Lombili ombómo.’ nimbe ombalie nondopa siye kolomba yembo te yu Pulu Yemo ye nomi kingi molopa nokomba koleamonga kongonomo manda naa temba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kanu kinie Yesusi kolea awili Jerusallemendo pumbe pupelie nirimumuni, yu pumbe purumu kolea marenga ye pokore kumbi lepa lipe mundorumu. Yuni ye tokapu yepoko mako topa ye talo talo nimbe lipe mundupelie ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","eno ungu iko mele topa nimbendo: “Poniena langi awisili nou lepa pelemo nalo kanu langime puku liku nosinge yemboma koltalo kene Ponie Pulu Yemone ‘Kanu langime liku nosieli kongonomo puku tenge yemboma poniena lipe mundopili.’ ningu mawa teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eno lipu mundukuru yema eno sipisipi melema, yembo owa takera awili kerimene sipisipi topa nolemo mele yemboma molemelena lipu mundukuru. ⸤Nanga ungumu andoko ningu singe kinie pilku keri pilkulie yembomane eno mindili liku singe.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pukulie, wale-tapi kepe, kou mone kepe, mele-wale kepe, kimbu-su alowa teko mondongema kepe naa meli we pangi. Aulkena pukulie yemboma kanoko enondo ungu te naa ningu we pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kolea tenga sukundu pukulie akune molongendo ulke teluringe puku pe-pukulie ou kanu ulke pulu yembomando ningendo: “Eno konopu peanga pepili molangi.” niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aku ninge kinie kanu ulkena ‘Konopu peanga pepili molambo.’ nimbé yembo te molomu liemo yu konopu peanga pepili molomba. Molo aku ninge kinie kanu ulkena ‘Konopu peanga pepili molambo.’ nimbé yembo te naa molomu liemo eno akune ‘Pangi.’ nimbu mundukuru yema enono konopu peanga pepa umbune te naa tepili molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kongono telemo yemo yu mele papu kalemele kene punge ulkena peko, ulke pulu yemone langi simbema nangi. Ulke pinie-pinie naa andoko, ulke telune mindi langi nongo peangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kolea tenga suku pukulie ningemone, kanu kolea pulu yembomane enondo “Papu ongi. Olio pea molamili waa.” ningi liemo eno langi singema nongo, ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","akune kuru tomba yemboma teko konde liku, enondo ningendo: “Pulu Yemo omba ye nomi kingi molopa olio nokomba walemo eno molemelena nondopa ombá.” niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Molo kolea tenga suku pukulie kanu kolea pulu yembomane enondo “Eno nambemune ongiye?” ningu, “Pea peamili waa.” naa ningi liemo ⸤kanu koleamo munduku siye kolko pungendo⸥ aulkena puku angilkulie yembomando ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Enone olio liku su singimunge ‘Eno kamu molko kenjengi! Pulu Yemone eno lipe naa tapondomba mele paa piliengi!’ nimbu, olionga kimbune ya koleamonga ma angilkimume kepe kulu topolie pukumulu.” niengi. ‘Akumu piliengi!’ ningu aku siku ningulie pe ungu te pea enondo kamu ningendo: “⸤Eno liepi-liepi tamili piliengi!⸥ Pulu Yemo omba ye nomi kingi molopa yemboma nokomba walemo nondopa ombá.” niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Nane enondo paa sike nimbu sikirumu: Kote walemo wendo ombá kinie kolea awili Sodomo ⸤yemboma ou ulu pulu keri awisili sike teringi nalo⸥ enonga kote kanga mele pemba. Nalo iyembo ⸤enondo “Pea molamili waa.” ni naa ningu, enonga ungu pilku naa linge yemboma,⸥ kote walemo wendo ombá kinie enonga kote awili mele pemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kolea Korasini kinie Besaida taonoselo ⸤akune molemele yemboma⸥ mindili nongo paa molko kenjinge. Kanu koleaselonga sukundu ulu tondolo awisili terindu ⸤nalo akune molemele yemboma konopu alowa naa telemele⸥. Kolea awili Taya kinie Saidonoselonga sukundu ulu tondolo naa terindu nalo kanu koleaselonga sukundu nane ulu tondolo aku sipu telka kanolemelanje kanu koleaselonga ⸤yembomane⸥ eno ulu pulu keri telemelema koronga munduku siye kolko, bulu siku, konopu alowa telemela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","⸤Akumunge⸥ kote walemo wendo ombá kinie kanu kolea awili Taya kinie Saidonoselonga ⸤yemboma ulupulu keri sike telemelemonga⸥ enonga kote kanga mele pemba. Nalo eno kolea Korasini kinie Besaidaselonga ⸤yemboma⸥ ⸤na ulu tondoloma terindu kinie kanokolie konopu alowa naa teringimunge⸥ kote walemo wendo ombá kinie enonga kote awili mele pemba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Kapeniame taono ⸤yemboma enone⸥ ‘Mulu koleana pupu molamili.’ konopu lekemeleye? Aku manda molo. ⸤Enone nanga ungume alieli pilimele nalo konopu alowa naa telemelemonga⸥ eno kolea kerine puku molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","⸤Aku nimbelie yuni lipe mundumbe terimu yemando ungu te pea nimbendo:⸥ “Enone ungu ningema pilipe limbe yembomone nane ungu nilio ungumu pilipe limbela. Enone ungu ningema naa pilipe ‘Olio pea molamili.’ naa nimbe temba yembomone na-kinie ‘Pea naa molambili.’ nimbéla. Nando ‘Pea naa molambili.’ nimbé yembomone na ma koleana lipe mundorumu ye kanumundu ‘Pea naa molambili.’ nimbéla.” nirimu. Yesusini aku nimbe pora sipelie ‘Yunge kongono tende-pangi.’ nimbe eno lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","⸤Walse⸥ Yesusini lipe mundorumu ye tokapu yepoko yu molorumune paa konopu siku yando ongolie enone yundu ningendo: “Awilimu, olione nunge imbi lepolie kuru kerime kepe olione ungu nirimulume pilku liku teringi.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesusini enondo nimbendo: “Aku siku teliku andoringi kinie ⸤kurumenga nomi⸥ Setene kariapá mele tepa, topa manie mundorumu nane kanorundu, ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pilieme! Eno tondolo te sirindu. Yembo nomba kondoli kongi-ka-wambiye molo kiriwara aku melema eno naa kanoko kambilinge kinie aku melemane eno nanga yemboma ‘Uluri naa tepili.’ nimbu eno kanu tondolomo sirindu. Olio-kinie opa pulue ⸤Setene⸥ yu sike tondolo pulimo nalo eno kanu tondolo sirindumunge yuni eno uluri manda naa temba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nalo aku sipu nikirumunge konopu naa siku, kurume enonga ungumu pilku liku telemelemonga konopu naa siku; ⸤Pulu Yemone⸥ mulu koleana ⸤molopa⸥ enonga imbime topa mondorumumunge konopu siku molangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yesusini Pulu Yemonga Mini Kake Telimu kinie konopu awili tepa sipelie Pulu Yemondo nimbendo: “Tata, Mulu Maselo Kinie Nokoko Moleno Ye Nomimu, nane nu-kinie “Ange.” nikiru. ‘Olio pilipe konginjeli pelemo. Olio oliolio ungumenga pulume pali pilipu kondolemolo.’ ningu pilimele yemboma eno nane telio ulumenga pulumu ‘Naa piliengi!’ ningu naa ningu sirinu. Yembo ambolango pame ⸤mele⸥ molko, nane nilio ungume komu tendeko molemele yemboma mindi nane telio ulumenga pulumu ‘Piliengi!’ ningu, eno ningu sirinu kanumunge nu kapi nimbu “Papu terinu.” nikiru. Sike Tata, nuni ‘aku sipe wendo ombá kinie konopu simbo.’ ningu aku siku terinumunge ⸤aku sipe wendo okomo.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","⸤Pulu Yemondo aku sipe nimbelie kelepa yembo moloringimendo nimbendo:⸥ “Melema pali Tatane na sirimu. Yembo tene Malo paa sike molemo mele pilipe kanopa imbi silimo yembo te molo; Lapane mindi yu kanopa imbi silimo. Yembo tene Lapa paa sike molemo mele pilipe kanopa imbi silimo yembo te molo. Malone mindi kanopa imbi silimo; Malone ‘Lapa lipu ora siembo.’ nimbé yemboma eno Lapa kanoko imbi singela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kanu kinie yu lombili andoli yema eno enono moloringine pupe ‘Eno mindi piliengi.’ nimbe enondo nimbendo: “Eno mongone kanolemele melema kinie ulume kinie kanolemele yemboma eno malo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nane enondo paasike nimbu sikirumu: Ou moloringi yemboma, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema kinie, ye nomi kingime kinie, kanu yembo awisili kinié eno mongone kanoko molemele melema kinie ulume kinie kanongendo “Kanamola!” ningu moloringi nalo naa kanoringi. Eno kinié komuni pilku molemele melema pilingendo “Piliemola!” ningu moloringi nalo naa pilieringi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pulu Yemonga ungu manemanga pulume pilipe kondorumu ye tene ‘Yuni nimbe kenjimbenje manda manjipu piliembo.’ nimbe Yesusindu walsipe pilipelie nimbendo: “Ungu Mane Silimu, na nambe-embo kinie konde molopo kondopo mindi puli ulu pulumu limboye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesusini yundu nimbendo: “Pulu Yemonga ungu manema Mosisini bokune torumu bokune kanokolie nambolka nimbe molemo kanolenoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yuni topondopa nimbendo: “Pulu Yemonga ungu manemane nimbendo: ‘Enone enonga kamelema kinie, enonga minime kinie, enonga tondolomo kinie, enonga pilipe konginjelime kinie, akumene Awili Yawe enonga Pulu Yemo manjiku tondolo munduku konopu mondangi.’ nimbe pepa, ‘Enone enono yu mele mele konopu mondoko enonga kangimu enono kondo kolko nokolemele mele aku sikula pulu lemo yemboma konopu mondoko nokoko molangi.’ nimbe pelemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusini yundu nimbéndo: “Nu paa sike nikinumu. Nu aku siku tenu liemo molopa mindi puli aulkena puni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nalo Pulu Yemonga ungumenga pulume pilipe yemboma mane sili yemone ‘Yembomane ‘Na paa pilimo yemo’ ningu piliengi!’ nimbelie kelepa nimbendo: “Nanga pulu lemo yemboma nameleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesusini ungu te topondopa nimbendo: “Juda ye te kolea awili Jerusalleme mundupe siye kolopa kolea awili Jeriko pumbe purumu kinie wa noli yema ongo yunge mulumbale toroko kulku liku yu toko nosiku eno puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kanu kinie Pulu Yemo popo tondoli ye te kanu aulkemonga maniendo pumbe pupelie nirimumuni, yemo aulkena lierimumu omba kanopalie yu lierimune siye kolopa aulke kiririme ekendonga omba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pe aku sipela Pulu Yemonga kongono tendeli talape LLipai ye te yemo toko noseringine omba kanopalie yu liepili siye kolopa aulke kiririme ekendonga omba yu purumula. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nalo Sameria ye te kanu aulkena pumbe ombalie yemo lierimune omba kanopalie yu kondo kolopa, ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","lierimune nondopa pupe kangi toringimenga kopongo kinie no-waene kinie ondopa kandondopalie banisini ka tondopalie nirimumuni, pe yuni yu kangulupe ola lipe yunge kongi-dongi bulu mingine ola nosipe memba pupelie yembo ponenge ongo pe-pou-pou teringi ulke tenga memba pupe nosipe nokopa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Peringili kinie ipulueli ou yu pumbe tepalie nirimumuni, kou pape kina mele wendo lipe ulke pulu yemo sipelie nimbendo: “Yu nokoko kondoyo. Pe i sikiru koumu manda naa tepa nunge kou mare olandopa pumu liemo pe kelepo yando ombolie nunge kou pundu tombo.” nimbe Sameria yemone nirimu.” ⸤nimbe Yesusini aku nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","⸤Aku nimbelie kelepa nimbendo⸥ “I ye yepoko ongo puringimenga ye wa nolimene toko noseringi yemonga pulu lierimu yemo naweye? Juda ye ou pulu pulu ongo kanokolo we ongo puringili yeselonga te molo yunge opa pulue ye akilipe orumu yemoye?” nimbe walsipe pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pulu Yemonga ungumenga pulume pilipe yemboma mane sili yemo yuni nimbendo: “Yemone yu we kondo kolorumu yemo lemo.” nirimu. Kanu kinie Yesusini yundu nimbendo: “Nu puku aku siku te-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kanu kinie Yesusi kinie yu lombili andolime kinie eno ongo pukulie kolea tenga pupe ambo Mata yunge ulkena “Pea molamili ou.” nirimu kinie yu akune purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata yunge angenu Maria molopalie yu Yesusini ungu peanga nilimo nimbémo ‘Piliembo.’ nimbe Yesusi molorumune omba nondopa manie molopalie nirimumuni, Yesusi ungu nimbe molorumu mele yu pilipe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nalo Mata yuyu langi kalondopa, kongono tepa molopalie yu kongono takaraki lierimu kulu kanu kongonomo mindi pilipelie Yesusi molorumune pupe nimbendo: “Awilimu, nanga angenu na lipe naa tapondokomo-na na nanu mindi langi simbondo kongono tepo molkoro kanokolie kondo naa tekemoye? Yuni na ‘Omba lipe tapondopili.’ ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aku nirimu kinie pilipelie Yesusini yundu topondopa nimbendo: “Ambo Mata, ulu awisili mele nu konopu awisili liku munduku konopu umbune tepili moleno ");
INSERT INTO ubu_kala_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nalo ulu telu mindi nu naa pilku teleno. Kanu ulu peangamo Mariane ‘Teambo.’ nimbelie ⸤nanga ungumu pilipe⸥ molemo. Kanu ulu peangamo yuni naa temba aulke te molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Walse, kolea tenga, Yesusi yu Pulu Yemo kinie ungu nimbe molopalie pe nimbe pora sirimu kinie yu lombili andoringi ye tene yundu nimbendo: “Awilimu, olio Pulu Yemo kinie ungu nimolo mele mane sieni. ⸤No Lindeli⸥ Jono yu lombili andoringi yema mane sirimu mele olio aku siku mane sieni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","⸤Aku sipe nirimu kinie pilipelie⸥ Yesusini enondo nimbendo: “Eno Pulu Yemo kinie ungu ningendo i siku mele niengi: “Tata, yembomane ‘Nu imbi ola molopa, ye kake teli peangamo moleno.’ ningu molangi. Nu ye nomi kingimu molko yemboma nokoni walemo wendo opili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kinié kepe pe alieli kepe olio nomolo langime siyo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yembomane olio teko kenjilimele kinie siye kolopo ulu te naa telemolo kene olione nu tepo kenjilimolo kinie nuni aku sikula siye kolko olio ulu te naa teyo. Olio ‘Ulu tene kondi topili.’ naa nieni.” ningu aku siku niengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aku nimbelie pe enondo ungu te pea nimbendo: “Nununge pulu lemo yembo te paa ipulueli awi-burumi molombana pukulie yundu ninindu: “Ano, ga mare siyo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ye ponenge te kolea tenga pumbendo nanga ulkena pemba okomo nalo na ga te naa lemo kene nuni na gamare si.” nilina kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yuni nundu nimbendo: “Nuni na umbune te aku siku naa si.” nilke. “Ambolangoma kinie ou nambune sipu uru pemulu kene na ola molopo wendo ombo melte nu manda naa simbo, molo.” nilke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Nane enondo nimbu sikiru: Yu angena molemomonga ola molopa ga naa silke nalo nuni yu kimbu-kimbu siku mawa telinamonga yu siye kolopa wendo omba ga silke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Aku telkamonga eno ⸤nanga lombili andolime⸥ ndo ungu te pea nikirula: ⸤Lapa, Mulu Koleana Molemo Yemo,⸥ melema mawa teko “Si.” niengi. Aku tenge kinie melema sike simbe linge. ⸤Lapa molemona⸥ melema korangi. Aku tenge kinie melema sike kanoko linge. Ulke kerepulune angilku “Sukundu wamili.” niengi. Aku ninge kinie “Sukundu waa.” nimbe nambune tondomba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mawa tenge melema sike simbe linge, koronge melema sike kanoko linge, “Sukundu wamili.” ninge kinie sike nambune tondomba. Aku temba kene aku teaa. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Enonga ye te yunge malo ombalie “Tata, oma te nambo si.” nimbé kinie yunge lapane wambiye te simbeye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Molo kangomone “Tata, kera mulu te nambo si.” nimbé kinie yunge lapane kiriwara molo makena te lipe simbeye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe eno konopu keri pepili molemele yembomane aku siku enonga ambolangoma mele peangama silimele liemo, enonga mulu koleana molemo Lapamone ⸤mele paa olandopa naa simbeye? Olandopa simbemo.⸥ Yembomane yundu “Mini Kake Telimu olionga konopune omba pepili si.” ningu mawa tenge yemboma yuni eno simbe linge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Walse ye te yunge konopune kuru te molorumu-ne ungu manda naa nirimu kinie Yesusini kanu kurumu makoromba makororumu. Kurumu wendo omba ulsu purumu kinie kanu yemo ungu nirimu. Aku terimu kanokolie yembomane mini-wale munduku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nalo yembo mare ⸤Yesusi-kinie konopu keri panjeringi⸥ kanumene ningendo: “Kurumenga nomi Belsipuli Yesusinge konopune molopalie yu tondolo silimo-na yuni kurume topa makorolemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yembo marene Yesusi manda manjiku “Nambolka nimbenje.” ningu yundu ningendo: “Nu sike Pulu Yemone ‘Kongono tendani.’ nimbe lipe mundorumunje kanamili, mulu koleana ⸤Pulu Yemone mindi manda temba⸥ ulu tondolo te tei.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Enone aku siku konopuni pilieringi mele Yesusini pilipelie ‘⸤Yesusi Setene-kinie opa pulue moloringilimunge Setenene yu naa lipe tapondolka mele paa piliengi!’ nimbe⸥ enondo nimbendo: “Yembo talape te konopu telune naa pupili molko suku singine owe panjiku eno enono opa teko lupe lupe molemele kinie kanu talapemo pora nilimo. ⸤Molo⸥ ulke telune pelemele yemboma konopu telune pupili naa molko eno enono opa telemele kinie kanu yembo talapemo sungu siku lupe lupe molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aku sipela, Setenene yunge kuru te makorolkanje aku telkamonga yunge talapemo kinie opa mele telka. Pe yunge talapemo nambepa kapola molemelaye? ⸤Pora nilke.⸥ Enone nando “Belsipulini yu lipe tapondolemo-na yuni kurume makorolemo.” nikimili kanumu. Sike aku telkanje Belsipuli yunge talapemo pora nilke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Ungu te piliengila! Nane Belsipulinge tondolomone kurume makorolio liemo enonga yemane nainge tondolomone kurume makorolemeleye? Akumunge, ⸤enonga ye kurume makorolemele yemane ‘Pulu Yemone olio tondolo silimo-na olione kurume makorolemolo.’ ningu pilimele-na⸥ enone nando inikimili ungume kanu yemane pilku apurukulie “Eno kolo tokomele.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nalo sike Pulu Yemone na tondolo silimo-na nane kurume makorondu liemo Pulu Yemo ye nomi kingimu molomba walemo eno molemelena koronga wendo omu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ye enge nili tene opa melema ambolopa yunge ulkemo nokopa kondolemo kinie ye tene we manda sukundu omba melema wa naa limo. Yunge ulke lemo melema kapola lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kanu ulke nokolemo pulu yemone ‘Nanga opa melema ambolopolie nanga melema manda nokopo kondombo.’ nilimo nalo yunge opa pulue ye te tondolo olandopa pulimomo omba yu tomba tepalie opa puluemone ulke nokolemo yemo topa manie mundupe yu ambolemo opa melema anjo lipe, yunge ulkena lemo melema lipe memba pupe yunge pulu lemo yemboma moke tepa silimo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na naa lipe tapondolemo yembomone na-kinie opa pulue molemo. Yembo tene na lipe tapondopa ⸤kongi sipisipime⸥ sukundu naa limo yembomone ⸤kongi sipisipime⸥ topa bulu-balu silimo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","⸤Yesusini ungu te pea nimbendo:⸥ “Kuru te ye tenga konopune wendo ombalie, no naa mololi koleamanga pupe manda koro molomba tenga korolemo. Te naa kanopa lendepalie yuni nimbendo: ‘Na ou molopolie wendo ondu ulkena kelepo pambo.’ nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aku nimbelie yu omba yu ou molopa purumu ulkemo kanolemo kinie, ulke puri memba tepa peanga tepa we lemo kinie kanopalie nilimomone, ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yu kelepa anjo pupelie, kuru kara puli paaolandopa yepoko pakera lipe memba omba eno pea kanu ulkena sukundu puku molemele. Kanu kinie kanu yemo ou molopa kenjilimo nalo pe paa kamu olandopa mele molopa kenjilimo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusini aku sipe nimbe molopili maku toko moloringine ambo tene ungu tondolo tepa nimbendo: “Nu paa teko kondolenomonga ambo nu memba ame sirimumu yu malo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesusini nimbendo: “Sike nalo yembo Pulu Yemonga ungumu pilku liku teko molemele yemboma eno malo paaolandopa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesusi molorumune yembo awisili sukundu sukundu ongo liku maku toringi kinie yuni enondo nimbendo: “Kinié mana molemele yemboma kerime mindi molemele. Eno teko kenjiku Pulu Yemo liku su silimele yembomane “Na molopo nilio mele sikenje, kanamili kene Pulu Yemone mindi ulu tondoloma manda telemo mele tei.” ningu na mawa telemele. Nalo ⸤na Pulu Yemo kinie tapu topo kongono telembolo mele lipe ora simbe ulu⸥ te wendo naa ombá. ⸤Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye⸥ Jona-kinie wendo orumu ulu akumuni mindi lipe ora silimo manda kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona-kinie ⸤oma awili te-kinie⸥ ulu tondolo te wendo orumu ulumuni Ninipa yemboma-⸤kinie ulu umbune te wendo ombá mele⸥ lipe ora sirimu aku sipe mele Manie Omba Mana Ye A Lierimu Yemo-kinie ulu tondolo te wendo ombá ulumuni kinié molemele yemboma-kinie ulu te pe wendo ombá mele lipe ora simbe. ⸤Lipe ora simbe ulu te lupe wendo naa ombá, naa kanonge.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“Ou kolea awili Ninipa yemboma ⸤sike molko kenjeringi nalo Pulu Yemone ungu umbu tondorumu mele⸥ Jonane ⸤pilipe⸥ pupe Ninipa yemboma nimbe sirimu kinie pilkulie teko kenjeringi mele kanoko keri kanoko konopu alowa teko molko kondoringi. Aku teringimunge kinié molemele yembomane Jonanga olandopa ye te ya molemo yemonga ungumu liku su siku naa pilimelemonga kote walemo pe wendo ombá kinie Ninipa yembomane kotena angilku, kinié molemele yembomando “Teko kenjeringi. Mindili nonge kinie papu.” ninge. “Ou ⸤olio Isirele yembomanga ye nomi kingi⸥ Sollomono yu ye paa tondolo te molopa, yu ungu lupe lupema pilipe konginjelimu pepili molorumu mele kolea Sipa nokorumu ambo nomi kuinimu pilipelie, Sollomonone ungu peangama mindi nirimu mele pilimbendo yu kolea sulune molopalie ⸤Sollomono molorumune⸥ wale awisili aulkena pelipe orumu. Aku sipe terimumunge, ye nomi Sollomononga olandopa ya molemo yemone nilimo ungumu kinié mana molemele yembomane naa pilku, liku su silimelemonga kote walemo wendo ombá kinie kolea Sipa ambo nomi kuinimuni nimbendo: “Nane Sollomonone ungu peanga nirimu mele pilimbondo aulke sulune orundu nalo Sollomononga olandopa molorumu yemone nirimu ungumu eno naa pilku, liku su siringi yemboma aku teringimunge eno papu mindili nonge.” nimbé.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","⸤Aku nimbelie Yesusini ungu te pea nimbendo:⸥ “Yembomane tepe llame kandokolie loyekolona naa nosiku, mingine suku naa nosikulie nilimelemone, ‘Ulkena suku patepili. Yembo ongema kolea kanangi.’ ningu polona ola nosilimele.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Nunge mongomo nunge kangimunge tepe-llame mélemo. Aku kene nunge mongo peanga angilimo kinie nu kangi pali patepili moleno kinie nu molko kondoleno. Nalo nunge mongomo keri lemba kinie nunge kangi pali sumbulu topili andoni. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akumunge, nunge kangine pateli pembamo ‘alowa tepa sumbulu naa topili.’ ningu ⸤kangi patepili molemo mele molko kondoyo⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nunge kangine patepa tengepea tepili molko sumbulu telu kepe naa topili moloni kinie nunge kangi konopume pali patepili moloni. Tepe-llame patelemo kanolemolo mele nunge kangi konopuselo patepili moloni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusini ungumu nimbe pora sirimu kinie kanu Parisi yemanga tene Yesusindu nimbendo: “Langi pea nambili ou.” nimbelie yu-kinie pupe langi nombando manie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nalo yu ou ki kulumiye naa topalie ga we norumu kanopalie kanu Parisi yemone konopu awisili lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesusini ⸤yu konopu lipe mundorumu mele⸥ pilipelie ⸤ungu iko mele topa⸥ yundu nimbendo: “Eno Parisi yema pellete kinie kapo kinie ulsukundu kulumiye tolemele nalo akumunge sukundu, enonga konopune sukundu mele, kalaro awisili molemo. Ulu pulu kerime kinie, melema wa limele ulu pulumu kinie akune pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eno paa aroma tolemele. Kangi terimu yemone konopumu pea naa terimuye? ⸤Peaselo terimu kene⸥ eno kangi no leko kake tepili molemele mele aku siku enonga konopu kake tepili molongi liemo papu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eno konopu alowa tekolie yembo koropama kondo kolko enonga nosilimele melema singe kinie enonga konopu kalaro molemomo kolo wangopa kake tepili molonge mele yembomane kanonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Parisi yema, eno mindili nongo paa molko kenjinge! Enone poniena olemo mele kangama lkepa kulue kemu aku sipe melema mengo kambu toko tene tene ningu liku nosikulie telu telu ningu wendo liku ‘Pulu Yemonga kongono tendeli yema siemili.’ ningu silimele. Pulu Yemone aku siku ‘Teaa.’ nirimu mele eno papu telemele nalo ulu olandopa ulume naa telemele. We yemboma kondo naa kolko, Pulu Yemone yemboma konopu mondolemo mele eno manda manjiku yemboma konopu naa mondolemele. Aku siku ulu olandopa mele telemelanje papu. Kinié ulu maniendopama telemele mele munduku siye naa kolkolie aku ulume kinie ulu olandopama kinie peaselo telemelanje papu. Nalo aku siku naa telemelemonga eno mindili nongo paa molko kenjinge! ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Parisi yema, eno Juda yemboma maku toko Pulu Yemonga ungumu pilimele ulkena sukundu pukulie manie molongendo ye awilime molemele polo peanga akune ‘molamili.’ ningu mendo puku polo akune konopu siku molemele. Yemboma maku toko molemele koleamanga mongo kenge teko andonge kinie ‘We yembomane olio kanoko kapi niengi.’ ningu pilkulie konopu siku pilku molemelela. Aku telemelemonga eno mindili nongo paa molko kenjinge! ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“⸤Parisi yema,⸥ eno yembo ono kolea tenga ‘Yembo inie ono telemele.’ ningu naa pilku walu siku kimbu kambilimele mele eno aku siku molemelemonga mindili nongo paa molko kenjinge!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesusini aku sipe nirimu pilkulie Pulu Yemonga ungu manemanga pulume pilipe kondorumu ye tene yundu nimbendo: “Ungu Mane Silimu, ‘Nuni Parisi yema aku siku iri tokonomonga olio kepe iri tokono.’ konopu lekemolo.” nirimu kinie pilipelie ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesusini kelepa eno ⸤iri topalie⸥ nimbendo: “Sike nikinu. Eno Pulu Yemonga ungu manemanga pulume pilku kondoli yema mindili nongo paa molko kenjingela! Enone ungu mane siku ‘Teaa.’ nilimele mele we yemboma eno pilkulie tengendo umbune kolemele. Aku siku umbune awisili mindili siku menge mele ‘Meangi.’ ningu sikulie enone enono laye kolte kepe ‘Lipu tapondopo meamili.’ naa ningu molemelemonga eno ⸤kepe⸥ mindili nongo paamolko kenjingela! ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“⸤Eno Pulu Yemonga ungu manemanga pulume pilku kondoli yema,⸥ enonga anda kolepalimene Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema toko kondoringi. Kinié, yandopa, eno kanu yema ono teringi koleama a silimele. Anda-kolepalime enone kanu yema toko kondoringi pilku peanga pilkulie pekinié eno kanu yema ‘Papu toringi.’ ningu enone ono teringi koleama a silimelemonga eno mindili nongo paa molko kenjinge! ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“⸤Ou enonga anda kolepalimene aku siku teringi, kinié enone aku siku telemele⸥ monga Pulu Yemo yuyu ungu pali pilipe konginjeli yemone ou nimbendo: “Nane ye mare ungu umbu tondopo ‘Enone yemboma ningu siengi.’ nimbu lipu mundupu, ye mare ‘Nanga kongonomo tende-paa.’ nimbu lipu mundumbo kinie yembomane mundumbo yemanga mare mindili siku, mare toko kondonge.” Pulu Yemone nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","“Koro-ou Pulu Yemone ma kokele tepa wamorumu kinie enone Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi ye kanume toko, pe yandopa yandopa kanu sili yema pali toko kondoringi. Koro-ou Adame malo Epele toko kondoko, pe yandopa yandopa kanu sili ye lupe lupema toliku puku, pe kamu Pulu Yemone ungu umbu tondorumu ungume pilipe yemboma nimbe sirimu ye Sekaraya Pulu Yemo ⸤popo toko kaloli⸥ ulke tembelena sukundu toko kondoringi. Kanune sukundu suluminia kake telimu anjokondo lepa, Pulu Yemo popo toko melema kaloringi polomo yakondo lierimu, kanu suku singine yu toko kondoringi. Ou moloringi yembomane kanu yema toko kondoringimunge Pulu Yemone eno sike mongo sirimu nalo kinié molemele yemboma eno Pulu Yemone kote pilipelie anda-kolepalimene aku siku teringimunge eno mongo simbela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Pulu Yemonga ungu manemanga pulume pilku kondoli yema, enone ungu manemanga pulume pilku kondolemele nalo “We yembomane naa piliengi!” ningu eno pilinge aulkemo pipi silimele. Eno Pulu Yemonga bokune molemo ungumu alieli kanolemele nalo apurukulie Pulu Yemone “‘Ye te eno lipe tapondopili.’ nimbu lipu mundumbo.” nirimu yemondo nimbe bokune molemo ungume kanokolie pilku sundulimele. Sumbi siku pilinge aulkemo eno naa pulimele; bokune kanu yemondo nilimo ungume ‘Piliemili pamili.’ ningu molemele yembo lupema pilinge aulkemo “Molo.” ningu pipi silimelela. Aku telemelemonga eno mindili nongo paa molko kenjinge!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesusini ⸤aku ungumu nimbe pora sipelie⸥ aku ulkemo mundupe siye kolopa pumbe purumu kinie yuni iri torumu ye Parisime kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie enone ‘Yu ungu nambolka ungu mare pea nimbelie, yu ungu nimbe kenjimbe kinie yu kote tendemolo.’ ningulie enone ungu lupe lupe awisili popenge teko walsiku pilkulie “Topondoko ni.” ningu tondolo munduku niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kanu kinie Yesusi molorumune yembo tausini awisili liku maku toko angilieringine ekelepa tepili angilieringi kinie yu lombili andoringimendo ou kumbi lepa nimbendo: “Eno liepi-liepi topo, ‘Parisi yema pillawa akoli mele isi nosilimelemo kanoko kondaa.’ nikiru. Enonga isi nosilimele akumu enone ⸤“Pulu Yemonga ulu peangama telemolo.” ningu⸥ kolo toko topele-mapele tolemele ulumu. ⸤‘Akumu manda manjiku naa teangi.’⸥ nimbu liepi-liepi tokoro. ⸤Parisi yemane sike teko kenjiku molemele mele kamu lopi manda naa tenge.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aki tolemo ulumenga telu kepe pe aki naa topa pali mona lemba. Lopi telemo ulumenga telu kepe pe lopi naa temba. Kanu ulume kinie ungume pali yembomane pali pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sumbulu toline ungu niringime yembomane pateline pilinge. Ulke suluminiana ungu ólo toko niringi ungume ulke imune ola angilku ru ningu ninge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nanga pulu lemo yemboma, enondo ungu te nimbu siembo: Kangimu mindi toko kondokolie pe kelko minimu pea ulu te manda naa tenge yemboma pipili naa kolangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nalo eno paa pipili kolonge yemo nimbu siembo: Kangi topa kondopalie pe mini pali tepe koleana manda topa mundumbe ⸤Pulu Yemo⸥ yu pipili kolangi. Paa sike nimbu sikiru. Yu pipili kolangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kera kalsindipele paa kangamo molemo, topo toko lingendo kera kise pakera kou kololi talo mindi pulimo kanumu. Nalo Pulu Yemone kanu kerama nokombando komu naa silimo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pilieme! Eno ⸤na lombili andolime⸥, enonga penge indime kepe yuni koronga telu telu nimbe pali kambu torumu. Kera kalsindipele yu kou paa koltalo mele pulimo nalo kanu keramo Pulu Yemone kanopa molemo. Eno yemboma paa olandopa awilime kanopalie eno paa nokopa kondopa molomba ⸤kene pipili naa kolaa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nane enondo ungu te nimbu siembo: Yembo tene yembomanga kumbikerena ola angilipe ‘Na Yesusinge yembomo molio.’ nimbé kinie pe Pulu Yemonga angellomanga kumbikerena Manie Omba Mana Ye A Lierimu Yemone ola angilipe “Kanu yembomo nanga yembomo.” nimbéla. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nalo yembomanga kumbikerena “Yesusi yu naweye? Yu na naa pilkiru.” aku mele nimbé yembomo pe Pulu Yemonga angellomanga kumbikerena Manie Omba Mana Ye A Lierimu Yemone “Aku yembomo yu naweye? Yu na naa pilkiru.” nimbéla. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Manie Omba Mana Ye A Lierimu Yemo ungu taka tondopa ungu nimbe kenjilimo yembomo aku sipe ulu keri telemoma ⸤Pulu Yemone⸥ ‘Manie pupili.’ nimbe siye kolomba. Nalo Mini Kake Telimu ungu taka tondopa, ungu nimbe kenjipe, marake telemo yembomo aku sipe ulu keri telemomo ‘Manie pupili.’ naa nimbe, paa siye naa kolomba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kanu kinie pe eno ⸤nanga yemboma molonge kanokolie⸥ eno ongo ka siku, eno maku toko Pulu Yemonga ungumu pilimele ulkemanga ye awilime kinie, ye nomime kinie, gapomano ye awilime kinie eno molongena eno mengo puku kote tendenge kinie ‘Kotena nambolka unguri nimolonje? Olio ungu te walsiku pilinge kinie nambolka unguri topondopo nimolonje?’ ningu mini-wale naa mundengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akune Mini Kake Telimuni enone anjo ninge mele mane simbe kene mini-wale naa mundengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesusi molorumune liku maku toringi yembomanga tene yundu nimbendo: “Ungu Mane Silimu, nanga angenumu kinie oltonga lapane sirimu monge melema yuni ‘Na mare moke tepa sipili.’ ni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nalo Yesusini yundu topondopa nimbéndo: “Yemo, ‘Nane enonga kote pilindiku enonga melema moke tendei.’ nimbe nawene na mako torumuye? Yembo tene nando aku sipe naa nirimu kanumu. Nanga kongono te molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aku nimbelie yuni enondo kelepa nimbendo: “‘Mele awisili lipu nosipu kamako molambo.’ ni naa ningu, ‘Melema lili ulu pulumu yu ulu pulu kerimu kene aku naa teambo.’ konopu leko molangi. Yembo tene mele awisili lipe nosilimomonga mini pali konde molopa kondomba aulkemo naa lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","⸤Aku nimbelie Yesusini ‘Enondo nikiru ungumenga pulumu kamu piliengi!’ nimbe⸥ yuni ungu iko te topalie nimbendo: “Walse ye kamako te molopalie yunge poniena langi paa awisili orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akumunge yuni yuyu nimbendo: “Langi nosilio ulkema pali si nimu, langi awisili goli lepa we lemo kene na nambe-eamboye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pe kelepa yuni yuyu nimbendo: “Kinié na pilipero. Na isipu teambo. Na langi nosilio ulkema tekisipulie langi nosimbo ulke paa awilime kelepo takopolie akumenga nanga rasi witi kinie langi kinie nanga poniena olemo langime pali nosiembo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Akune nosipulie na nanu pilipulie nimbondo: Na papu. Na langi awisili, ponie awisili omba pumbe kinie nombo molombo mele lemo kene koro molopo, kongi nombo, no-waene nombo, konopu sipu molambo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nalo Pulu Yemone kanu yemondo nimbendo: “Ye aromamo. Kinié ipulueli nane nunge minimu ombo limbo kinie nunge nosilino melema nawene limbeye?” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","⸤Ungu ikomo topa pora sipelie ungu te pea nimbendo:⸥ “Aku sipe mele, ‘Na mele kande-kandema nosilio.’ nilimele yemboma Pulu Yemone eno kanopalie eno yembo koropa pulime nimbe kanolemo. Pulu Yemo kanopa peanga kanolemo ulu pulume naa teko molemele yemboma enonga minime koropa pupili mele molemele. Kanu yemboma eno aku ungu iko tokoro yemo mele molemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","⸤We yembomando⸥ aku sipe nimbelie Yesusini yulombili andolimendo kelepa nimbendo: “⸤Kolonge kinie mana melemane eno naa lipe tapondomba⸥ kene nane enondo ungu te nimbu siembo: ‘Kangikundu molopo kondamili.’ ningu konopu awisili liku naa mundengi. Langinongemonga kepe no nongemonga kepe mulumbale pakongemonga kepe akumenga konopu awisili liku munduku naa molangi. Eno kapola molonge mele olandopa, langi nonge mele maniendopa; enonga kangi yu olandopa mele, mulumbale pakonge maniendopa mele kene langi nonge mele kinie, mulumbale pakonge mele kinie, konopu awisili liku naa mundengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kerama kaname. Langi te panjikulie nou lemo kinie liku mengo ulkendo puku nosiku naa nolemele nalo Pulu Yemone kerama langi silimo. Kerama we mele, eno yemboma olandopamonga yuni eno paa nokomba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Enonga yembo tene konopu awisili lipe mundumbemone yu kolomba ena te manda ‘We liepili.’ nimbéye? Manda naa nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Enone ulu wallo-kolte aku sipe mele te manda naa telemelemonga ulu wema eno nambemune konopu awisili liku munduku molemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pillawa sindime kaname. Pillawa sindimene kongono mindili siku naa teko, mulumbale te teko mimi naa telemele nalo pillawa sindime molemele mele olandopa, ⸤ye nomi kingi⸥ Sollomono kongono awisili tepalie wale paa peangama pakopa a nirimu mele maniendopa. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Era sindi tolemoma kinié mele molemo, opali mele poroko tepena kalemelema Pulu Yemone aku sipe nokopa kondolemo liemo eno ‘Pulu Yemone olio manda nokombanje?’ ningu laye-kolte mindi pilimele yemboma pakonge melemanga yuni manda lipe naa tapondombaye? Eno lipe tapondomba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“⸤Pulu Yemone kerama kinie era sindime kinie aku we melema aku sipe nokolemo⸥ kene eno konopu awisili liku mundukulie ‘Esi, langi te tena lipu nomolonje?’; molo ‘No tena kolopo nomolonje?’ ningu pilku naa molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pulu Yemonga yemboma naa molko ulsukundu molemele yembomane aku siku telemele nalo enonga Lapa ⸤Pulu Yemone⸥ eno yunge yembomanga mele molotolemoma kanopa molemo ⸤kene eno langi nongemanga kinie mele pakongemanga kinie konopu naa liku mundengi⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","⸤Pulu Yemo⸥ ye nomi kingi molopa yemboma nokolemo ulume ‘Kumbi lepo teambo.’ konopu leko molangi. Aku tenge kinie yuni we melema kepe eno simbe.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nanga kongi sipisipi koltalo, enonga Lapa walse ye nomi kingi molopa yemboma nokomba kinie ‘Eno pea ye nomime molko yemboma nokangi.’ nimbé. Yu aku sipe tembando konopu sipe molemomonga pipili kolko naa molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akumunge eno nosilimele melema kou mone liku aku kou mone lingema yembo koropama moke teko siengi. Aku siku tekolie pe kou kamu manie naa puli koumu liku nosiku, mele kande-kandema liku mulu koleana ⸤pe pungemonga⸥ nosiku teangi. Akune wa lili yema ongo wa naa liku, koka molo lkurinia melemane ongo teko kenjiku naa tenge. Eno akune nosinge melema kamu kapola lemba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Enonga nosilimele melema lemo kolea akune eno konopuni pilku konopu mondoko molemele kene ⸤‘mulu koleana mindi melema liepili.’ ningu molangi.” nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“⸤Na lombili andolime,⸥ enone ‘Awilimu kinié ombánje.’ ningu mulumbale pakoko, kako toko, kiye kandoko, molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ye awili te tenga pupe ye te ambo limbe langi koyolemele yemboma kinie anjo langi nomba molemo kinie yu kelepa ulkendo ombámonga yunge kendemande yembomane ‘Yu ombá.’ ningu ulke kune lindingendo nokoko molemele mele eno aku siku molangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kanu kendemandemanga nokolimu omba yunge kendemandema kanopalie, uru naa peko we molonge kanomba kendemandema eno konopu siku molonge. “Nane enondo paa sike nimbu sikirumu: ⸤Alieli kendemandemane enonga awilimu nokoko langi kalondoko silimele mele yu aku siku nokolemela nalo kendemandemanga⸥ ye awilimuni ⸤kanu kendemande peangama konopu sipe⸥ yuni kongono-mulumbale pakopa enondo “Langi noli polona molaa.” nimbe ‘Langi nangi.’ nimbe enonga kongono tendepa eno nokomba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ipulueli awi-burumi ombáne, kera gulta ko tomba kinie ombánje, eno uru naa peko nokoko molongi kanomu liemo eno konopu siku molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“I ungumu konopu liku munduku pilieyo. Ulke pulu ye tene wa noli ye te yunge ulkemo omba bulsupe melema wa limbe enamo pilkenje ‘Wa noli yemo ombá.’ nimbe nokopa molka kinie wa noli yemo yu manda suku naa olka. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aku siku eno nokoko molaa. Manie Omba Mana Ye A Lierimu Yemo ombá enamo naa pilimele kene ‘Yu sike ombá.’ ningu aku siku nokoko molangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitane yundu nimbendo: “Awilimu, aku ungu iko toko ningu sikinumu olio ⸤nunge lombili andolimendo manjiku⸥ ningu sikinu molo yembo wemando pea ningu sikinuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Awili ⸤Yesusini⸥ topondopa nimbendo: “Kongono tendeli kendemande ye nawene kongono tepa kondondolemo kinie kanopalie yunge ye awilimuni ‘Yuni kongono silioma sumbi sipe telemomonga yu kongono simbo kinie tepa kondombamonga na altopo konopu kimbu sipu naa molombo.’ nilimoye? Kendemande ye te aku sipe mele tepa kondopa molemomo kanopalie yunge ye awilimuni yu mako topalie yundu nimbendo: “Nuni kongono tendeli kendemandema pali nokondoko enonga langi nongema ena mako toliomonga eno nangi moke teko sieni, nokondoko molou.” nimbe ⸤yu tenga pulimo⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pe ye awilimuni kongono simumu kanu kongono tendeli kendemandemone mimi sipe tendepa molopili awilimu kelepa omu liemo kendemandemo yu konopu sipili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nane enondo paa sike nimbu sikirumu: Kanu ye awilimuni kanu kendemandemondo “Nanga mele nosilioma pali nuni nokondou.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Nalo ⸤ye awilimuni kanu kendemande yemondo nimbendo: “Nanga kendemande yemboma pali nokondou.” nimbe tenga pulimo kinie⸥ kanu kendemande yemone “Nanga awilimu welea naa ombá.” konopu lepalie yuni nokondolemo kendemande yemboma kopene topa, langi nomba no tondoloma nomba kekelepa topalie, aku sipe tepa kenjipe molomu liemo ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","walse kanu kendemande yemo ‘Yunge ye awilimu ombá.’ nimbe naa pilipe ⸤kongono sirimu mele naa tepa⸥ walu tepa kenjipe molomba kinie ombá. Omba ⸤kanu yemo tepa molomba mele kanopalie⸥ yu paa kopene topa kondopalie, yunge ungumu pilku su siku kongono ambolko naa kondoli yemboma ⸤kolea keri⸥ molemelena ‘Pupili.’ nimbe lipe mundumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kongono teli yembo te yunge awilimuni “I siku i siku tei.” nimbé ungumu sumbi sipe pilipelie ungumu ta nimbé, molo ‘Nikimu mele naa tembo.’ nimbe pilipe aku sipe pilipe lipe naa temba yembo kanumu yunge awilimuni pe yu mongo paa awisili simbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nalo “Tei.” nimbé mele mimi sipe naa pilipelie we walu tepa kenjimbe yembomo yunge awilimuni mongo laye-kolte mele simbe. Yembo mele awisili siringi lipe noserimu yembomo “Pundu toko mele awisili si.” ninge. Yembo “Mele awisili nokoko molou.” niringi yembomo “Kelko mele awisili si.” ninge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“⸤Na lombili andolime,⸥ na ya ma koleana tepe mundumbo orundu. Kanu tepemo isili ou welea nolkanje papu. Na konopu silke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Na no limbo ulu akumu na-kinie wendo ombá. Ulu akumu isili ou wendo naa okomomonga na konopu umbune tepili molio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“‘Ya mana yemboma opa naa teko telune kapola kapola molangi.’ nimbu orundu konopu lekemeleye? Aku molo. ‘Yemboma konopu lupe lupe pepili anjo yando opa pulue mele molangi.’ nimbu orundu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kinié kepe pe anjopa kepe ulke telune pelemele yembomanga ⸤marene nanga ungumu pilku molko marene nanga ungumu liku su siku molkolie,⸥ eno enono opanale teko yembo kise pakera ulke telune peko, yepoko enono molonge, talo elolo molongele, yu-mele-mele molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lapane malo-kinie opa tepa, malone lapa-kinie opa tepa, telune kapola naa molongele. Anumuni lemenu-kinie opa tepa, lemenuni anumu-kinie opa tepa, telune kapola naa molongele. Bamuni yunge malonga menu-kinie opa tepa, malonga menuni bamu-kinie opa tepa, telune kapola naa molongele. ⸤Kanu yemboma kapola naa molonge.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aku nimbelie Yesusini liku maku toringimendo nimbendo: “Enone kolea kolopalie kupe tolemo kinie kanokolie “Lo ombá lemo.” nilimele kinie lo sike olemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe kelepa ipulueli poporome topa, kombukandipi angilimo kinie kanokolie “Ena tondolo temba lemo.” ningu pilimele kinie ena sike telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“⸤Naa pilkimulu.” nilimele nalo sike pilimele⸥ yembo kolo toko topele-mapele tolime! Eno mulumu kinie ya mamo kinie kanokolie ‘kolea isipe isipe temba.’ ningu kanolemele nalo kinié ⸤na mana orundu kinie⸥ wendo olemo ulume kanoko molkolie kanu ulumenga ulu pulumu naa pilimele. Aku nambemune ⸤lipe ora silimo mele⸥ naa kanoko naa pilimeleye?” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Enone nambemune ulume pilku apuruku ulu peangama pilku naa telemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu kote tendemba temba yembomo ‘Kapola kapola molambili ulu te teambo.’ ningulie welea teani. Aku naa tenu liemo nu kote tendemba yembomone nunge kote pilieli yemo molombana memba pupe simbenje? Pe kote pilieli yemone nu ka ulke nokoli yemo lipe simbe, yuni nu ka ulkena lipe mundumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nane nundu paa sike nimbu sikirumu: Nu ka ulkena wendo onindu pundu paa pali tokolie mindi wendo onimu. We manda wendo naa oni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanu kinie Yesusini ungu mane sirimune moloringi yembo marene yundu temane toko sikulie ningendo: “Kolea Gallilli disiriki yembo marene Pulu Yemo popo toko melema kalko molangi ⸤Romo gapomano ye awili⸥ Paillatene eno topa kondorumu.” ningu temane toringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aku temanemo toringi kinie pilipelie Yesusini enondo nimbendo: “Kanu kolea Gallilli yemboma aku siku mindili noringi kulu pilkulie ‘Gallilli yembo moloringi lupe wemane ulu pulu keri teringi mele maniendopa, kanu mindili noringi yemboma ulu pulu keri teringi mele paa olandopa.’ konopu lekemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Paa sike nane enondo “Aku sipe molo.” nikiru. Ya molkomele yemboma, eno ulu pulu keri telemelema bulu siku munduku siye kolko konopu alowa naa tengi liemo eno aku siku toko kondongela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pe kelepa Yesusini temane te topalie nimbendo: “Kolea awili Jerusalleme sukundu kolea kanga Silloamo kouni takoli ulke awili olana te topa kalalu sipe topa manie mundupelie yembo tene-eti topa kondorumu koloringi. Kanu yemboma ‘Kolea awili Jerusalleme yembo lupe moloringimene pali ulu pulu keri teringi mele maniendopa, koloringi yembomane ulu pulu keri teringi mele paa olandopa.’ konopu lekemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Paa sike nane enondo ‘Aku sipe molo.’ nikiru. Ya molkomele yemboma, eno ulu pulu keri telemelema bulu siku munduku siye kolko konopu alowa naa tengi liemo eno aku siku kolongela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aku nimbelie kelepa ungu iko te topalie enondo nimbendo: “Ye tene unjo piki te yunge unjo waene poniena umbu lierimu. Pe ‘Piki mongo tomba.’ nimbe omba kanorumu kinie te naa torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Piki mongo te naa torumu kulu yunge unjo waene ponie tapu yemondo nimbendo: “Pílie. Ponie talo yepoko pea iunjo piki angilimomonga ombo kanorundu nalo piki mongo telu kepe naa torumu kene yuni ma kopongo we nolemo kene peke toko ltei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ponie pulu yemo aku sipe nirimu kinie ponie tapu yemone yundu topondopa nimbendo: “Awilimu, iponie telumu mindi aku unjomo we angiliepili. ‘Unjomo akopa mongo topili.’ nimbu unjo pulune era tepo, ma mundupu, kongi le lipu mundupu, teambo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pe nekendo poniemonga mongo tomu liemo papu. Naa tomu liemo kamu peke tani.” nirimu.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Walse, ⸤Juda yembomanga koro moloringi⸥ wale Sambate tenga Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke tenga suku Yesusi pupelie yemboma ungu mane sipe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Akune ambo te molorumu, yu kuru topa bulu langorumu-ne ola angilipe sinio simbendo perepa molorumu. Yu aku sipe molopili ponie tene-eti omba purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesusini kanu ambomo kanopalie yundu “Ou.” nimbelie nimbéndo: “Ambomo, nu kuru torumumu topa keliepili.” nimbelie ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ambomo kini ambolorumu kinie yu tamburumbu sumbi sipe ola angilipelie Pulu Yemo kapi nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nalo kanu ulkemo nokorumu yemo yuni Yesusi ⸤koro mololi⸥ wale Sambatemonga yembo tepa konde lsimu kulu kanopa keri kanopalie akune maku toringi yembomando nimbendo: “Kongono wale talo pakera lemomanga ‘Konde pamili.’ ningu onge manda. ⸤Koro mololi⸥ Sambate walemonga manda molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yemone aku sipe nirimu kinie Yesusini nimbendo: “Eno topele mapele toli yema, alieli ⸤koro mololi⸥ wale Sambate wendo olemo kinie eno pali yu-mele-mele enonga kongi kao molo kongi dongi langi nomba molorumune moki leko no olemo kolea tenga ‘No nopili.’ ningu mengo pulimele kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eno enonga kongime Sambate walemonga papu moki leko nokolemele kene i ambomo Sambate walemonga papu lipu tapondokorola. Kongimu maniendopa mele, ambomo olandopa mele kanumu. Akumunge i ambomo, yu Eporayamone kalopa lsimu ambo te, ⸤kurumenga nomi⸥ Setenene yu ponie tene-eti ka mele sirimu ambomo Sambate walemonga moki lepo nokokoromo tepo kenjikiruye?” nimbe walserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yuni aku sipe nirimu kinie kanu ungumuni yu terimu mele kanoko keri kanoringime olie poloringi nalo we yembomane yu ulu tondolo peangama terimu kanokolie konopu awili teko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kanu kinie Yesusini ⸤yembomando⸥ kelepa nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokomba, mele nambolka mele kanu silimu lembaye? ‘Pulu Yemo ye nomi kingimu molopa yemboma nokolemo mele piliengi!’ nimbu akumu nambepo nimbu simboye? ⸤Nimbu siembo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Akumu isipe mele: Ye tene yu unjo masetete umbu te lipe yunge poniena umbumu mundorumu kinie kanu unjo umbumu wendo omba awi lepa unjomo angilierimu kinie aku unjomonga kolamanga kerama ongo peringi. Pulu Yemo ye nomi kingi molomba mele aku sipe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aku nimbelie kelepa walsipe pilipelie nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokomba mele pilinge nambepo nimbu siemboye? ⸤Nimbu siembo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Akumu isipe mele: Ambo tene yu langi pillawa akoli mele isi wallo kolte lipelie pillawa awisilinge mundorumu kinie pillawa pali akorumu. Pulu Yemo ye nomi kingi molomba mele aku sipe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aku sipe nimbelie pe Yesusi kolea awili Jerusalleme pulimo aulkena pumbe pupelie kolea awilime kinie kangama kinie pupe, akumenga moloringi yemboma ungu mane sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kanu yembomanga tene yu walsipe pilipelie nimbendo: “Awilimu, mindili nomolo aulke molemolona Pulu Yemone yemboma lipe tapondopa wendo lipe yu-kinie molko kondonge aulkena lipe mondomba yemboma koltalo mindiye?” nimbe walserimu. Pilipelie yuni enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ulke kerepulu paakanga si niline yembo awisili ongo suku pungendo perenge. Akumunge ‘Kanu kerepulune eno ongo sukundu puku molongendo mindili siku pangi.’ nimbu nikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ulke pulu yemone ola angilipe kune anjimbe kinie eno pena molkolie ningemone, kune toko walsikulie ningendo: “Awilimu, olio nu kinie pea molamili wamili kene olionga kune lindi.” ninge kinie yuni enondo nimbendo: “Enonga imbime na naa pilipu eno kepe enonga koleama kepe na naa kanolio.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Yuni aku nimbé kinie enone yundu ningendo: “Nupea ga norumulu. Olionga koleamanga nu ongolie olio ungu mane sirinu.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Nalo yuni enondo nimbendo: “Eno niembo piliee. Enonga imbime na naa pilipu enonga koleama na naa kanolio. Eno ulu pulu keri teko molemele yemboma pali na moliona anjo paa.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akune ulsu molkolie eno ⸤anda-kolepali⸥ Eporayamo kinie, Aisake kinie, Jekopo kinie, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema pali kinie, eno Pulu Yemo yenomi kingimu molopa nokomba koleana sukundu molonge kanokolie eno enono akune ulsu molonge kanokolie eno enono mumindili kolko kola teko mini-wale mundunge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Isirele yemboma eno Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu eno manjiku naa punge ‘Piliengi!’ nimbelie yuni kelepa nimbendo: “Ma koleana pali yembo mare Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu puku Pulu Yemo pea langi nonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pilieme. Akiliku olemele yembo mare Pulu Yemo ye nomi kingimu molopa nokomba koleana sukundu kumbi leko punge. Kumbi leko oringi yembo mare akiliku punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Walse, Yesusi ou Jerusalleme naa pupelie kolea tenga ungu nimbe molorumu kinie Parisi ye marene ongo yundu ningendo: “⸤Ye nomi kingi⸥ Erotene ‘Nu topo kondambo.’ nimbe molemo kene nu ya naa molkolie tenga kowa pu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesusini enondo nimbendo: “Na tomba tekemo yemo, yu kolo topa konopu keri peli owa takera pokisi mele akumu molemona iungumu puku ningu si-pee.” nimbelie nimbendo: “Kinié mele kepe opali talou mele kepe kurume yembomanga konopune pelemoma makoropo, kuru toli yemboma tepo konde lipu, molopolie laye pe mele na kongono tepo moliomo pora simbo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nalo Jerusalleme pumbondo kinié kepe opali talou kepe na we kongono telipu pumbo. Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye te kolea awili Jerusalleme ulsukundu manda naa kolomba kene ⸤na Pulu Yemone ungu umbu tondolemoma pilipulie yemboma nimbe silimo yemo molio kene⸥ na Jerusalleme ulsukundu manda naa kolombo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","⸤Aku nimbelie Yesusini Jerusalleme moloringi yemboma yu kondo kolopa akumundu ungu te nimbelie nimbendo:⸥ “O Jerusalleme ⸤yemboma⸥, Jerusalleme ⸤yemboma⸥, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema toko kondoko, yuni eno molemelena lipe mundulimo yema kouni toko kondoko telemele yemboma, kera gulta anumumuni yunge waloma lipe yunge kongona lopi tepa nokolemo mele nane wale awisili eno aku sipu nokolka nalo enono “Molo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akumunge pilieme. ⸤Opa puluema eno tonge onge kinie Pulu Yemone altopa enonaa nokopa naa lipe tapondombamonga⸥ opa puluemane ongo sike toko munduku enonga koleamo kinie enonga ulke tembelemo kinie kamu toko kalongemonga eno ku penge. Nane eno ungu te pea nimbu sikiru: Eno Jerusalleme yemboma, enone nando “Pulu Ye Yawene lipe mundorumu-ne okomo yemo imbi ola molopa, molopa kondopili.” ninge walemonga na altoko kanonge. Ou molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","⸤Juda yembomanga koro moloringi⸥ wale Sambate tenga Parisi ye awili tenga ulkena Yesusi langi pea nongendo purumu. Omba molorumu kinie pea langi nongo moloringi yemane yu neme-neme ningu kanoko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yunge kumbikerena ye kangi akorumu te molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pulu Yemonga ungu manemanga pulume pilku kondoringi yema kinie, Parisi yema kinie, eno Yesusini walsipelie nimbendo: “⸤Koro mololi⸥ wale Sambate kinie kuru toli yembo te tepo konde limelanje kapola molo moloye?” nirimu. “Pulu Yemonga ungu manemanga sukundu nambolka nimbe molemoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nalo yundu ungu te topondoko naa ningu we moloringi. Kanukinie yuni kanu yemo lipe tepa konde lipelie yundu “Pu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aku tepalie Yesusi yuni pea moloringi yembomando nimbendo: “Eno molkomele yembomanga ye tenga kango te molo kongi-kao te Sambate wale tenga no muru tenga manie tomu liemo kanu yemone yunge kangomo molo kongi kaomo tamburumbu wendo naa limbeye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aku nirimu pilkulie ‘Olione “Sambate wale tenga kango molo kongi-kao wendo limbe akumu papu.” nimulu liemo yuni “Yemo papu Sambate walemo kinie lipu tapondokoro.” nimbe.’ ningu pilkulie ungu te topondoko ninge aulke te naa lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Parisi ye awilimunge ulkena langi nongendo oringi yemboma ye awilimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku moloringi kanopalie Yesusini eno ungu mane sipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Ye tene nu kinie yembo mare pea “Langi namili waa.” nimbé kinie nu ongolie ye awilimenga polo kumbikundu tenga puku naa molani. Nu kanu polomonga moloni kinie pe ye awili te yu imbi olandopa molomba ye te yu kepe ‘Langi pea namili ou.’ nimbé ye te ombá kinie ulke pulu yemone nundu nimbendo: “I ye awilimu nu moleno polo akune molopili polomo si.” nimbé kinie nu pipili kolkolie polo te lupe, namba naa lieli yembomanga polo tenga puku moloni. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Akumunge, ye tene nundu “Langi pea namili ou.” nimbé kinie yunge ulkena puku namba naa lieli yembomanga polo tenga puku molani. Akune moloni kinie ulke pulu yemone nu molonine ombalie nundu nimbendo: “Ano, ipolona naa molko ye awilimenga polona ongo molou.” nimbé kinie langi pea nongo molonge yembomane nu kinie temba mele kanokolie nu ‘Ye awilimu.’ ningu kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Yembomane enono imbi liku ola mundulimele yemboma ⸤Pulu Yemone⸥ topa manie mundumbe, nalo yembo enono toko manie mundulimele yemboma yuni enonga imbime lipe ola mundumbe kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kanu kinie Yesusini ulke pulu yemondo nimbendo: “Nu yembomanga langi kalondokolie nunge pulu lemoma kinie, nunge angenali kinie, ye kamakoma kinie enondo ‘Langi pea namili waa.’ ni naa nieni. ‘Enone walse altoko pundu mele toko, nando ‘Langi pea namili ou.’ niengi.’ ninaa nieni, molo! ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nu yembomanga langi kalondokolie yembo koropama kinie, kimbu ki lkinuwa tambulorumu yemboma kinie, kimbu keri lierimu-ne mimi siku aulke naa andoringi yemboma kinie, mongo keri lierimu yemboma kinie enondo ‘Langi pea namili waa.’ nieni. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Enone kanu langime pundu paa manda naa tongemonga nu konopu siku molko kondoni. Walse konopu sumbi nimbe pepili molemele yemboma kolko lomboroko ola molonge aku walemonga ya nikiru mele nuaku siku tenimunge mele kalomba lini.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Parisi yemonga ulkena Yesusi pea langi nongo moloringi ye tene Yesusindu nimbendo: “Pulu Yemo ye nomi kingimu molopa nokomba koleana langi nomolo yemboma ⸤olio⸥ malo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nalo Pulu Yemonga Isirele yemboma Yesusi yunge ungumu naa pilku liku su siringimunge mulu koleana puku naa molonge pilipelie yemone nirimu ungumu pilipelie Yesusini ungu te topondopa ungu iko te topalie nimbendo: “Ye tene ‘Yembo awisili pea langi namili kalambo.’ nimbelie yembo awisilindu “‘Langi kalopolie namili waa.’ nimbo kinie wangi.” nimbe, nimbe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Langi nonge enamo wendo orumu kinie yunge kendemandemondo nimbe mundupelie nimbendo: “Ou “Langi pea namili waa.” nirindu yembomando “Kinié enamonga langi kalondondu kene namili wangi.” ni-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nalo eno pali naa ongendo yu mele mele “Takaraki lekemo kene naa omolo.” niringi. Tene nimbendo: “Na ma konde te topo tondumu kano-pumbondo na naa ombó kene nindei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tene nimbendo: “Nane kongono teli kongi-kao rureponga talo topo tondume pupu kano-pumbondo manda naa ombó kene nindei.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tene nimbendo: “Kinié mindi ambo lindumunge na manda naa ombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","⸤Aku siku niringi kinie pilipelie⸥ kendemandemo kelepa yando ombalie niringi mele yunge ye awilimu nimbe sirimu. Kanu kinie ulke pulu yemone mumindili kolopalie kendemandemondo nimbendo: “Nu welea lkisiku puku, ikolea awilimunge aulke awilimenga kinie aulke kangamanga kinie puku, yembo koropama kinie kimbu ki lkinuwa tambulorumu yemboma kinie, mongo keri lierimu yemboma kinie kimbu keri lierimu-ne mimi siku aulke naa andoringi yemboma kinie, eno liku mengo ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kendemandemone aku tepalie kelepa omba nimbendo: “Awilimu, ninu mele tendu nalo langi noli polona kolea mare we lemola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanu kinie Awilimuni yunge kendemandemondo nimbendo: “Aku tekemo kene nu altoko puku, kolea awiline ulsu puku aulke awilimenga kinie aulke paka-makamanga puku, yembo kanoko lendenime pali mengo wani. “Molo.” ninge yemboma kepe karaye teko mengo wani. Nanga ulkemo si nipili kene awisili wangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Paa tambu ya kana. Na paa sike eno nimbu sikirumu: Nane pulu pulu “Langi pea namili waa.” nimbu, nimbu mundorundu yembomanga telu kepe paa naa ongo langi nonge. Paa molo.” nirimu.” nimbe ⸤Yesusini aku sipe ungu iko te torumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesusi aulkena omba purumune yembo awisili liku maku toko yu lombili andoringi kinie yu we angilipe topele topa kanopalie enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yembo tene na lombili ombando na olandopa konopu naa mondopalie na lombili manda naa ombá. Yunge lapa kinie, anumu kinie, menu kinie, ambolangoma kinie, angenupili kinie, kemulupili kinie, yu yuyu kepe, eno pea olandopa konopu mondopa, na manjipe konopu naa mondopalie na lombili manda naa ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yembo tene ‘Yu lombili pambo.’ nimbelie yemboma unjo perana angilku mindili nongo kolemele mele yuni unjo pera mele gomo lembando ‘Na yu lombili pumbondo mindili nondu liemo papula; kolondu liemo papula.’ naa nimu liemo na lombili manda naa ombála. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Enonga ye tene ulke awili tondolo te takombando yu ou naa takopalie kanu ulkemonga konopu lipe mundupelie yuyu nimbendo: ‘Ulke takopo pora simbomonga kou mone manda nosilionje molo molo tombanje?’ nimbe pilipelie ‘Nanga kou mone manda nosendu liemo manda takombo.’ konopu kimbu sipe naa molombaye? ⸤Aku sipe temba kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yu aku sipe ou naa telkanje pe yu kanu ulkemo takombando unjo pote mindi topo topa lipe polopalie pe kou mone molo tomba kinie kamu manda naa takopa pelka. Akumunge yembomane yu ungu taka tondoko tawe tendelemela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Enone tawe tendeko ungu ururume toko ningendo: “I yemo ulke awili tondolo te takomba takorumu nalo yunge kou mone molo torumu kulu yu manda naa takopa pora sirimu.” ningu tawe tendelemela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“⸤Te walsikirula.⸥ Enonga ye nomi tenga talapemo kinie ye nomi kingi tenga lupe talapemo kinie opa tengele kinie te yu tomba temba, te yunge koleana we molomba. Eno omba tomba ye nomi kingimu yu opa teli ye tuwendi-tausini memba ombá. Nalo we molomba ye nomimu yunge opa teli ye tene-tausini mindi molonge. Kokele tonge onge kinie we molomba ye nomimu yunge yema walsipe pilipelie nimbendo: “Olio opa teli ye tene-tausini mindi molopolie olio ongo tonge yemboma anjo manda tamili molo moloye?” ni naa nimbéye? ⸤Aku sipe manda manjipe pilipe molomba kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kanu kinie kanu ye nomi kingimu yuni ‘Olione eno anjo manda naa tamili.’ nimbe piliemu liemo yunge ye mare lipelie, yetuwendi-tausini memba ombá ye nomimu aulke sulune ombámonga “Paa.” nimbe lipe mundupelie nimbendo: “‘Opa naa tepo we taka lipu molamili kene nane nambolka ulu te teamboye?’ ningu walsiku pili-pee.” nimbé.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","⸤Ungu ikoselo topa kelepalie nirimumuni, pe ungu ikoselonga ye talone telembela melemonga ungu pulumu eno nimbe sipelie nimbendo:⸥ “⸤Kanu yeselone telembela⸥ aku sipe mele enonga yembo te yuni ‘Na lombili wambo.’ nimbelie yunge melema pali kinie, yunge yemboma kinie, yunge kou mone kinie, yunge kangi kinie, aku melema mindi konopu mondopa na olandopa konopu naa mondolemo yembomo na lombili manda naa ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","⸤Aku nimbelie kelepa nimbendo:⸥ “Api-kusa akumu mele peangamo nalo yu songo naa temba kinie ‘Yu kelepa songo tepili.’ ningu ulu te manda temoloye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kanu api-kusa songo naa telimu nambe-emoloye? ‘Poniena lipu mundumolo kinie langi manda naa ombá; yu ma kopongo te molo.’ nimbu kanopolie we ltemolo.” ⸤nimbelie⸥ “Yembo komu-peo lemba yembomane inikiru mele piliee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kou takisi lili yema kinie ulu pulu kerime teli ye wema kinie eno pali Yesusinge ungu pilingendo yu molorumune nondoko oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi yema kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie enone aku teringi mele kanokolie konokono ningu ningendo: “I yemo yu tepa kenjikimu. Ulu pulu kerime ambololi yemboma “Pea molamili waa.” nimbelie, langi alieli eno pea nongo molemelela.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesusini eno aku siku niringi pilipelie ⸤iungu ikoma eno topa sirimu.⸥ Ungu iko imu topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Enonga ye tene kongi sipisipi pape paono mondolka kinie te talopa lelkanje yuni sipisipi po paono tene kelepa nani wema kolea ku lieline molangi siye kolopa pupe, talopa lelka sipisipimu kanopa limbendo korolipe naa pulkeye? ⸤Korolipe pulke.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pe kanopa lipelie yuni konopu sipe apu topa lkondo memba pulke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kanu kinie lkondo ombalie yemone yunge pulu lemo yembomando kinie yunge ulke kere pongolo yembomando kinie walsipelie nimbendo: “Nanga kongi sipisipi talopa liemumu kanopo lindu kene pea konopu sipu molamili waa.” nilke.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","⸤Nimbelie ungu ikomonga pulumu nimbe para sipelie nimbendo:⸥ “Nane eno ungu te nimbu sikirumu: Yembo konopu sumbi nimbe pepili molemele yemboma aku siku molemele-na eno ulu pulu kerime munduku siye kolko konopu alowa tenge aulke te naa lemo kanumu, kanu yemboma mulu koleana angellomane konopu we silimele. Nalo sipisipi nokoli yemone yunge sipisipi talopa lielimu kanopa lipelie paa olandopa konopu silke mele aku sipe ulu pulu keri ambololi yembo te yunge ulu pulu keri telemoma pilipe keri pilipe mundupe siye kolopa konopu alowa tembamonga angellomane paa olandopa konopu singe.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","⸤Nimbelie kelepa ungu iko te pea topalie nimbendo:⸥ “Te iwalsikirula: Ambo te kou mone suroli mele engaki rureponga talo nosipelie nilkemone, pe kanu kou suroli mele te manie pulkenje yu tepe llame kandopa ulke puri memba kanopa limbendo naa korolkaye? ⸤Paa korolkamo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kanu kinie kanu koumu kanopa lipelie yunge pulu lemo yemboma kinie yunge ulke kere pongolo yemboma kinie walsipelie nimbendo: “Nanga kou mone suroli manie pumumu kanopo lindu kene pea konopu sipu molamili waa.” nilke. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Nane eno nimbu sikirumu: Kanu ambomo konopu silke mele aku sipe ulu pulu keri ambololi yembo te yunge ulu pulu keri telemoma pilipe keri pilipe mundupe siye kolopa konopu alowa tembamonga Pulu Yemonga angellomane konopu singe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","⸤Aku nimbelie⸥ Yesusini kelepa ⸤ungu iko yepoko sipemo pea topa ye awilime mane sipelie⸥ nimbendo: “Ye te, yunge kango talo moloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Walse akiliomone lapando nimbendo: “Tata, nu kolonimunge moya melema isili ou moke teko na sini mele sieni.” nirimu kinie kanu yemone yunge noserimu melema moke tepalie yunge kangoselo sirimu lsingili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kanu melema elo sirimu kinie akiliomo wale pokore mindi molopalie, pe mele sirimume pali lipe memba aulke sulu tenga purumu. Aulke sulu pupelie nirimumuni, kolea tenga pupe molopalie yu ‘Langi peangama nambo.’ nimbe, ‘Mulumbale peangama pakambo.’ nimbe kou mone awili tepa pulimo melema topo topa lipe panjipelie, ‘No nambo.’ nimbe topo topa lipe, ‘Amboma pea peamili.’ nimbe kou-mone sipe, aku telipe purumu kinie yunge kou mone melema pali pora nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yunge melema kinie kou mone kinie pora nirimu kinie yu paa koropa purumu. Kanu kinie yu molorumu koleana engele awili tepa lierimu kinie yu melema pali molo torumu kinie yu paa engelene kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yu engele terimu kulu yu kanu kolea pulu ye te molorumune pupe “Kou kongono te teambo si.” nimbe mawa terimu kinie yuni nimbendo: “Kapola, nanga kongi tapu tendeko langi nurupulume ‘Nangi.’ ningu liku si.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ga kilume kinie konapa bulume kinie kongi sirimume ‘Nambo.’ nimbe pilipe molorumu nalo yu te naa siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kanu kinie pe yu konopu lipe mundupe pilipelie yu yuyu nimbendo: ‘Tatanga kongono tendelemele yemboma ga awisili nongo olo telemo nalo na ya engelene kolopolie kamu kolombo tekero. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akumunge na pupu Tata molemona pupulie yundu nimbondo: “Tata, nu kinie Mulu Koleana Molemo Yemo kinie nane tepo kenjerindu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na kango kerimu kene nunge marena molombo kapola naa temba kene nunge kongono ye te molambo.” nimbo.’ nimbe pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aku nimbe pilipelie yu molorumu koleamo mundupe siye kolopa, lapa molorumune pumbe purumu. Yu lkondo pumbe purumu kinie yunge lapane yu sulu tepa orumu kanopalie yu kondo kolopa lkisipe pupe yu kangulorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kanu kinie kangomone lapando nimbendo: “Tata, nu kinie Mulu Koleana Molemo Yemo kinie nane tepo kenjerindu. Na kango kerimu kene nunge marena molombo kapola naa temba kene nunge kongono ye te molambo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aku sipe nimbe molorumu kinie lapane yunge kongono tenderingi kendemande yemando nimbendo: “Welea puku nanga mulumbale peangamo liku mengo ongo yu pakondoko, ki ongi te liku yunge kíne mondondoko, kimbu su liku yunge kimbune mondondayo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Aku tekolie kongi kao walo awilimu toko kalondoko molombolona mengo waa.” nirimu. “Nanga kangomo yu koronga ou purumu, ‘Yu kolorumunje.’ nimbu pilierindu nalo kinié yukelepa okomo. Yu ou pupe tepa nema lsimu nalo kinié altopa okomo kanopo likimulu kene konopu sipu kongi kao nombo molamili.” nirimu kinie eno aku siku konopu siku kongi nongo moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nalo yunge kango komomo poniena kongono tepa molopalie pe ipupene ulkendo ombá orumu kinie eno konopu siku musiki toko denisi teko moloringi ungumu pilipelie ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","yuni kongono kendemande ye tendo “Ungu te niembo ou.” nimbelie nirimumuni, yundu walsipelie nimbendo: “Ulu tekemelemo nambemune tekemeleye?” nimbe walserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kanu kongono kendemande yemone yundu topondopa nimbendo: “Angena omu-ne laniene kanopa yu manda mele molopa ulu te naa tepa omu-ne kanopalie konopu sipe “Kongi kao walo awilimu namili.” nimbe topa kalomu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aku sipe nirimu pilipelie komomo yu mumindili kolopalie “Na ulkena suku paa naa pumbo!” nirimu. Aku nirimu pilipelie lapane wendo omba yundu nimbendo: “Olio pea konopu sipu molamili ou.” nimbe mawa terimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","lapando topondopa nimbendo: “Pílie! Na alieli, ponie awisili, nunge kongono tendepo molopolie nu nilino ungume alieli pilipu lipu tenge panjipu, walse kepe nunge ungu te karaye naa tepo molio nalo nuni nando walse kepe kongi-meme walo te ‘Kangoma kinie pea konopu siku nongo molangi.’ ningu naa silino. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nalo kinié nunge kango te omba, yuni ambomando “Na pea peambili kou mone siembo.” nimbe nunge kou mone eno sipe pora sirimu, kanu kangomo omu kinie nu konopu siku ‘Kongi kao walo awilimu namili.’ ningu tonu lepamo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Lapane yundu topondopa nimbendo: “Kangomo, nu kinie na pea alieli molembolo kinie nanga melema pali oltonga. ");
INSERT INTO ubu_kala_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nalo kinié angena kolorumu kanumu altopa omu. Yu ou pupe tepa nema lsimu, kinié kelepa omu kanopo likimulu kene olio papu konopu sipu musiki topo langi nombo molkomolo.” nirimu.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","⸤Aku nimbelie⸥ Yesusini yu lombili andolimendo nimbendo: “Walse ye kamako te molorumu kinie yunge mele noserimumenga nokondoli ye te molorumula. Walse yembo marene kamakomo molorumune ongo, yunge melema nokondoli yemone terimu mele ongolie yundu ningendo: “Nunge mele nosilinomanga nokondoli yemone nu tepa kenjipe, nunge melema ‘We manie pupili.’ nimbe yu akume nokopa naa kondolemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aku niringi pilipelie kamakomone kanu yemondo ‘Ou.’ nimbelie yundu iri topa nimbendo: “I ungu nambolka ungumu nikimiliye? Nuni nanga melema teko kenjilino mele ningi kinie pilipulie nuni nanga melema terinu teleno mele bokune toko, yando sikulie pe pani. Nu nanga melema altoko manda naa nokani. Nu makorombo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kanu melema nokondoli yemo yuyu nimbendo: “Apa! Kinié nambe-eamboye? Nanga awilimuni nanga kongono teliomo wendo lipe na makoromba tekemo kene na nambe-eamboye? Na ma akumbondo tondolo naa pulimo-na aku kongonomo manda naa tembo. Yemboma langi mawa tembondo pipili kolombo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akumunge na tembo mele kinié pilipero. ⸤Nanga awilimuni pundu anjerimu yemboma lipu tapondopolie enondo ‘Pundu ekendo mindi tangi, ekendo manie pupili.’ nimbo kinie⸥ pe na makoromba kinie kanu yembomane na konopu siku liku tapondokolie nando “Pea peamili ou.” ninge.” nimbelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","yunge awilimuni pundu anjerimu yemboma ‘Yu mele mele wangi.’ nimbe kumbi lepa orumu yemondo nimbendo: “Nanga awilimuni nu kinie nambolka mele pundu anjerimuye?” nimbe walserimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","yuni topondopa nimbendo: “Wele mingi pape paono pundu anjerimu.” nirimu kinie kamakomonga melema nokondoli yemone yundu altopa nimbendo: “Pundu anjeli bokumu i sikiru; ya manie molko, pape paono toko mondoringi gomomo ora toko ltekolie kolo wangoko gomo kondena wele mingi tu paono tene welea toko mondou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yunge bulkundu orumu yemondo nimbendo: “Nanga awilimuni nu kinie nambolka mele pundu anjerimuye?” nimbe walserimu kinie yuni topondopa nimbendo: “Rasi witi wale pape paono pundu anjerimu.” nirimu kinie melema nokondoli yemone yundu altopa nimbendo: “Pundu anjeli bokumu i sikiru; ya manie molko, rasi witi wale pape paono toko mondoringi gomomo ora toko ltekolie kolo wangoko gomo kondena rasi witi wale popaono welea toko mondaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yu aku terimu pilipelie ye kamako awilimuni kanu tepa kenjeli yemo yu kapi nirimu. Yunge melema sike wamele lipe tepa kenjerimu nalo yunge pilipe konginjelimu paa olandopa perimu pilipelie yu kapi nirimu. “Ya mana molko, Pulu Yemo konopu naa mondolemele yemboma, enonga pilipe konginjelimu paa olandopa; pateline molko Pulu Yemo konopu mondolemele yemboma enonga pilipe konginjelimu maniendopa. We yembomane yembo te kinie kou kongono tengendo, molo ulu te tengendo aulkemo sumbi siku kanoko akisiku kondolemele; pateline melemele yemboma aku sipe tondolomo maniendopa pelemo. We yemboma aku siku molemelemonga ⸤ye awilimuni tepa kenjeli yemo aku sipe kapi nirimu.⸥” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nane enondo nimbu siembo: Kinié ya mana molkolie mana melema liku ‘Yemboma nunge angenali mele molangi.’ ningu nunge mele nosilinomanga eno liku tapondani. Pemelema pora nimbé kinie nu kolea peanga kamu-kumu lembana puni kinie akune molongemane nundu “Ya kamu pea molamili.” ninge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yembo tene yembo tenga mele koltalo nokopa kondondolemo kinie kanopalie ‘Mele awisili simbo kinie nokopa kondondomba lemo.’ nilimo. Yembo tene yembo tenga mele koltalo nokopa kenjindilimo kinie kanopalie “Mele awisili simbo kinie nokopa kenjindimbe lemo.” nilimo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nuni ya mana nosilimele melema nokoko naa kondonu liemo nu paa sike mele kande-kande lupema, Pulu Yemone silimo mele kande-kandema, ‘Nokondani.’ manda naa nimbé. ⸤Ya mana nosilimele melema maniendopa, Pulu Yemone silimo mele kande-kande lupema olandopa kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nuni ya mana nosilino melema paa sike nunge molo, kanu melema Pulu Yemonga. Akumunge nuni yunge melema nokoko naa kondondonu liemo pe yuni ‘nunge nosieni.’ nimbe simbe tepa molemo melema manda simbeye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kendemande yembo teluni ye awili talonga kongono lipe tere lepa manda naa tendemba. Ye awili te konopu keri panjipe, te konopu mondomba. Molo aku naa temu liemo ye awili tenga ungu nimbéma paa konopu sipe pilipe lipe kongono nimbéma tondolo mundupe tendepa, te konopu keri panjipe yunge ungu nimbéma ta nimbé. Yembomane Pulu Yemonga kongonomo kinie Kou Monemonga kongonomo kinie liku tere leko manda naa tendenge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesusini aku sipe nirimu pilkulie Parisi yema eno kou mone kepe melema kepe konopu paa awisili mondoringimunge yuni ungu nirimumu liku su siku tawe teringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesusini enondo nimbendo: “Eno enono i siku ningendo: ‘We yembomane olio Parisi yema konopu sumbi sipe pepa, peangama molemolo kanoko niengi.’ ningu molemele nalo enonga konopune paa sike pelemo mele Pulu Yemone kanopa molemo. Mana yembomane kanokolie ‘Mele paa komindi, mele paa olandopamo.’ nilimele melema Pulu Yemone kanopa keri kanolemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“⸤No Lindeli⸥ Jono ou mana naa omba molopili Pulu Yemone yemboma ‘Teaa.’ nirimu mele ⸤Pulu Yemonga ungu manema yando nimbe sirimu ye⸥ Mosisinitorumu bokume kinie, Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane boku toringime kinie, kanu bokumenga molorumu, yandopa yandopa mane siku yemboma ningu siringi. Nalo kinié, Pulu Yemone omba ye nomi kingimu molopa yemboma nokopa kondomba temane peangamo topo silipu andolemolo. Pulu Yemo ye nomi kingimu molopa yemboma nokomba yembo talapena sukundu puku molongendo yemboma ekelepa teko pulimele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mulu kinie ma kinie walse manda pora nimbé nalo Pulu Yemone ungu manema Mosisini yando nimbe sipe boku torumu bokumenga molemo ungumenga imbi torumumenga imbi telu paawallo-kolte kepe manie manda naa pumbe. Pulu Yemonga ungu manema pali lepa mindi pumbe.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ye tene yunge ou limo ambomo makoropa “Kamu pu.” nimbelie kelepa ambo te limo kinie aku yemone wa ulu kerinele telemo. “Pu.” nimbe makorolemo ambomo pe ye tene yu limo kinie kanu yemo kepe wa ulu kerinele telemola.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","⸤Nimbelie Yesusini kelepa temane te topalie nimbendo:⸥ “Ye kamako te molorumu. Yunge wale pakoli paa peanga kou paa olandopa pulime pakopa, alieli yunge ulkena langi peangama mindi nomba perimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ye koropa te molorumula, kanumunge imbi LLasirasi. Yu enamanga taki teki ‘Kamakomone yu kondo kolopa kou mone te molo langi te simbenje.’ ningu yunge ulke kerepulune ‘Molopili.’ ningu mengo ongo mondoringi. Yunge kangime pali ereli terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aku erelime owamane ongo pene-mane lieringi. Yu ‘Kamakomonga langi pundu manie pumbema lipu nombó.’ nimbe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pe walse koropamo kolorumu. Kolorumu kinie angellomane yunge minimu liku, ⸤Juda yembomanga pulu pulu anda-kolepa⸥ Eporayamo molorumune mengo puringi. Kamakomo kolorumula. Yembomane yu ono teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kanu kinie yu tepe koleana mindili nomba molopalie, yuni mongone olando sipe kanopa aulke sulune Eporayamo kanopa LLasirasi pea moloringili kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanopalie ungu te tondolo mundupe nimbendo: “Toto Eporayamo, nakondo kolkolie ‘LLasirasini nona ki-sundumu manie mundupelie ‘Nanga alumbelune koma liepili.’ nimbe tendepili.’ ningu yu yando mundoyo. Na itepemonga paa mindili nombo molio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nalo Eporayamone yundu nimbendo: “Toto, ou moloringili mele pílie! Elo mana moloringili kinie nu mele kande-kandema nosiku kapola molorunu; LLasirasi yunge mele kerime nosipe, molopa kenjerimu kanumu. Pe kinié yu konopu peanga pepili molemo, nu mindili nongo moleno. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Molo nane “E.” nilkenje yu andine manda naa laolka. Olio kinie eno kinie awi-suku-singine ⸤Pulu Yemone⸥ kombu awilimu lsimu lemo kanumu. Pe kinié ya molemolo yemboma ‘Eno molemelena anjo pamili.’ ninge kinie manda naa pungela; enonga yemboma ‘Yando wamili.’ ninge kinie yando manda naa ongela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kanu kinie kamakomone nimbendo: “Aku lepamo kene, Toto, yu nanga pulu koleana pupili mundeni nimbu mawa tekero. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nanga angenupili kise pakera molemele kanumu. Ikolea mindili noli koleana eno kepe naa wangi kene yuni eno liepi liepi topa ungu nimbe sipe kondopili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nalo Eporayamone yundu nimbendo: “Mosisini boku torumu bokume kinie Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane boku toringi bokume kinie nosilimele kanumu. Enone kanu bokume molemo ungume kanoko piliengi!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kanu kinie kamakomone nimbendo: “Toto Eporayamo, aku manda molo. Kolorumu yembo te lomboropa ola molopa eno molemelena pupe nimbe simu liemo ulu pulu keri telemelema pilku keri pilkulie siye kolko konopu alowa tenge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eporayamone yundu nimbendo: “Mosisinge ungume kinie Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemanga ungume kinie ⸤bokumenga toringi molemo akume⸥ pilie naa piliengi liemo kolorumu yembo te lomboropa ola molopa pupe nimu liemo yunge ungumu naa lapilinge.” nirimu.” nimbe Yesusini temane teaku sipe torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusini yu lombili andolimendo nimbendo: “⸤Na⸥ ‘Sike’ ningu tondolo munduku pilimele yemboma kelko bulu siku munduku siye kolonge ulume sike wendo ombá nalo yembo tene nanga yembo te kondi tombamonga kanuyembomo na bulu sipe anjo pumu liemo kanu kondi tomba yembomo mindili nomba paa molopa kenjimbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nanga yemboma aku sipe kondi tomba yembomo yu koupaa awili te moko toko nomine lendeko ‘Yu kamu kolo-popili.’ ningu paka toko nomune paa maniekondo mundulimelanje paa papu. Aku siku toko mundulimela kinie yu kolopalie pe yu Pulu Yemonga ambolango tendo ‘Ulu kerime tepili.’ nimbe kondi manda naa tolka. Nalo yu aku siku nomune naa mundulimela kinie yu yemboma kondi tombamonga Pulu Yemone yu mongo awili tepa silke kene enone yu nomune papu paka toko mundulimela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Nanga yemboma, eno enono telemele mele kanoko kondame. “Angena tene nu-kinie ulu te tepa kenjimbe kinie yu molombana puku ninindu: “Ano, nuni na teko kenjenu.” nieni. Aku nini kinie yu pilipelie nimbéndo: “Ano, sike tepo kenjendu kene kondo kolambo.” nimbé kinie nu-kinie kanu ulu keri temba ulumu ‘Manie pupili.’ ningu siye kolani. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kanu kinie ena telumunge yu wale yepoko pakera aku sipe nu-kinie tepa kenjipe, pe kelepa wale yepoko pakera konopu alowa tepa nundu “Ano, kondo kolambo.” nimbé kinie kapola, nu wale yepoko pakera kanu ulu keri tembama ‘Manie pupili.’ ningu siye kolani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kanu kinie Yesusini ou “Nanga kongonomo tende-paa.” nimbe lipe mundorumu yemane yundu ningendo: “Awilimu, nu ungu nilino mele olio ‘Sike ungumu.’ nimbu laye tepo mindi pilipu lipu ambolemolo kene nuni ‘awili teko pilku liku tondolo munduku ambolangi.’ ningu liku tapondani.” ningu mawa teringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","⸤Awilimuni⸥ enondo topondopa nimbendo: “Unjo tenga mongo akumu mele paa kangamo nalo kanu mongomo mana mundulimolo kinie unjo akopa awi lepa angilimo kanumu. Aku sipe mele, eno nane ungu nilio mele unjo mongo kanga mele paa wallo-kolte mindi pilku liku ambolemelanje, enone ‘Pulu Yemone nanga ungumu mandapilimbe.’ ningu ya angilkimu unjo awili akumundu “Nu pulkinio pali lkuruku puku, nomune kelko angiliei.” nilimela kinie kanu unjomo enonga ungumu pilipe lipelie aku sipe manda telka.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","⸤Nimbelie ungu te pea nimbéndo:⸥ “Enonga ye te yunge kendemande ye tene ponie tendemba molo kongi sipisipi tapu tendemba kinie pe ipupene lkondo ombá kinie yunge awilimuni yundu “Ya ongo manie molko ga nou.” nimbéye? ⸤Aku manda naa nimbé.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kanu kongono tendeli yemo yu kongono tepa kelepa ulkendo ombá kinie yunge awilimuni yundu isipe nimbé: “Nanga ga kalondoko boroko sikulie pe na nanu ga nombo pora simbo kinie nu puku nunge ga kalko nani.” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ye awilimuni ‘Tei.’ nimbé mele yunge kendemande yemone pilipe lipe tembamonga “Ange, papu tenu.” nimbéye? Aku naa nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Aku sipela, enone Pulu Yemone enondo “Kongono tendaa.” nilimo mele pali teko likulie eno enono ningendo: ‘Olio kendemande kerime.’ niengi. ‘Yuni olio “Teaa.” nilimo mele manjipu tepo, kongono olandopa te naa tepolie olio kendemande kerime molemolo.’ niengi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesusi kolea awili Jerusalleme pumbe pupelie nirimumuni, kolea Gallilli kolea Sameria disirikiselo aulke awi-suku-singine pupelie, ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kolea kanga tenga sukundu purumu. Sukundu purumu kinie kuru kendi noli ye rureponga talo yu aulke omba purumune ongo anjo siku angilku ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","enone ru ningulie ningendo: “Yesusi, Ye Nomimu, olio kondo kolou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yuni eno kanopalie nimbendo: “Pulu Yemo popo tondoli yema molemelena puku, enonga kangime liku ora si-pee.” nirimu. Kanu kinie eno punge puringi kinie eno kuru pora nimbe umbu kangi angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Enone konde pukulie kanoringi kinie ye akumenga te yando omba ungu tondolo nimbe Pulu Yemonga imbi lipe ola mundundulipe omba ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesusi angilierimune manie pupe tamalu pepa yundu “Paa ange.” nirimu. Kanu yemo yu Sameria yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kanu kinie Yesusini nimbendo: “Nane ye rureponga talo tepo konde naa linduye? Pe kinié ye rureponga telu akume tena molemeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Te pea yando ongo Pulu Yemonga imbi liku ola naa mundundukumiliye? Iye lupemo mindi okomoye? Isirele ye kuru kendi nomu tepo konde lindume tena molemeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kanu kinie yuni Sameria yemondo nimbendo: “Olaangilku puyo. Nane nu manda tembomonga tondolo munduku pilienumuni nu konde punu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi yemane Yesusi walsiku pilkulie ningendo: “Pulu Yemo ye nomi kingimu molopa nokomba walemo tewale wendo ombáye?” niringi. Yesusini enondo topondopa nimbendo: “Pulu Yemo ye nomi kingimu molopa yemboma nokomba walemo wendo ombándo yemboma mongone kanonge ulu te naa wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eno kinié ya molemelena Pulu Yemo koronga yenomi kingimu molopa yembo mare nokolemo-na yu ye nomi kingimu molopa yemboma kinie melema pali nokomba ulumundu yembo tene “Kaname. Iwendo okomo.” ningu, “Andi wendo okomo.” ningu, aku mele manda naa ninge. Kanu walemo koronga wendo okomo lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aku nimbelie Yesusini yunge lombili andolimendo nimbendo: “Enone “Manie Omba Mana Ye A Lierimu Yemo wallo-kolte kanamili.” ninge walema wendo ombá nalo naa kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yembomane “Wine molemo.”, “Ya molemo.”, ninge. Nalo aku sipe ninge kinie kolo tonge kene eno lombili naa pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kariapá lipe sinjipe telemo kinie koleama pali patelemo yembomane pali kanolemele. Manie Omba Mana Ye A Lierimu Yemo aku sipe mele kelepa ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nalo ou yu mindili awili tepa nombá, kinié molemele yembomane yu liku su siku bulu singe. ⸤Kanu kinie kolopa lomboropa ola molopalie nimbemone,⸥ pe “Ombá.” nikiru mele ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ou ye Noa molopili yembomane teringi mele Manie Omba Mana Ye A Lierimu Yemo ombá temba kinie yembomane aku siku tengela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","⸤Ma koleamanga pali⸥ no ou naa topili yemboma langi nongo, yema ambo liku, amboma ye puku, aku ulume mindi teko mololiku puringi. Noa nona andoli sipi ulkemonga suku purumu kinie kepe eno aku siku ulume mindi teko molangi no topa ⸤koleama pali none aki topa⸥ yemboma pali topa kondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“LLote pea moloringi yembomane aku siku teringila. Eno langi nongo bisinete teko ponie panjiku ulke takoko, we ulu akume teko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nalo LLote kolea awili Sodomo mundupe siye kolopa kowa purumu kanu walemonga tepe kinie kou tepene nolime kinie lo mele mulune manie omba Sodomo moloringi yemboma pali topa kondorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Manie Omba Mana Ye A Lierimu Yemo kelepa ombá walemonga ou teringi nikiru mele pe aku siku teko molongela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Yu ombá kanu walemo wendo ombá kinie ulke imune ola molonge yemboma altoko lkondo puku enonga ulke sukundu nosinge melema puku naa li-pengi. Aku sikula poniena molonge yemboma melema liepili nosiku poniena punge kinie kanu walemo wendo ombá kinie nosinge melema altoko puku naa li-pengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","LLote menu terimu mele pilieme. ⸤LLote pea Sodomo munduku siye kolkolo kowa puringili nalo Sodomo tepe manie orumu kulu pilipelie Pulu Yemonga angello tene ou “I ki teko naa kanokolo we sumbi siku kowa pale.” nirimu mele LLote menu naa pilipe lipe, iki tepa kanorumu kinie api kusa a lepa kou mele we angilierimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","‘Na naa kolopo konopu simbo ulume mindi tepo molambo.’ ningu Pulu Yemonga ungu naa pilku linge yemboma sike kolonge. Nalo ‘Na kolondu liemo papula.’ ningu Pulu Yemonga ungu pilku liku teko molonge yemboma naa kolko molko mindi punge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nane enondo paa sike nimbu sikirumu: Manie Omba Mana Ye A Lierimu Yemo kelepa ombá walemonga ipulueli yembo talo suluminia telune pengele kinie ⸤Pulu Yemonga angello tene⸥ omba yembo te we pepili mundupe siye kolopa te lipe memba pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ambo talo langi kalongele teko molongele kinie ⸤angello te omba⸥ ambo te we molopili mundupe siye kolopa te lipe memba pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ye talo lamana unjo toko angilingele kinie ⸤Pulu Yemonga angello tene omba⸥ ye te we molopili mundupe siye kolopa te lipe memba pumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","⸤Yuni nirimu mele pilkulie⸥ enone ningendo: “Awilimu, aku ulumu tena tembaye?” niringi. Yesusini topondopa ungu iko te topalie nimbendo: “Melema kolopa lemo koleamanga mele kololime nolemele kera ilsepema mele kolopa lemoma kanokolie nongendo manie ongo liku maku tolemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Walse, Yesusini ‘Eno alieli Pulu Yemo kinie ungu ningu siye naa kolangi.’ nimbe yu lombili andolimendo ungu iko te topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Walse, kolea tenga kote pilierimu ye te molorumu. Kanu kote pilierimu yemo yu Pulu Yemo kepe mana yemboma kepe, pipili naa kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kanu koleana ambo waye te molorumula. Kanu ambomo yuni kote pilieli yemo molorumune alieli omba yundu nimbendo: “Na tepa kenjerimu yemo kote tendambo. Nuni na liku tapondoko kote pilindei.” nimbe mawa te-pou-pou terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ambomo ou kokele orumu kinie kote pilieli yemone yundu “Molo, nunge kote naa pilindimbo.” nirimu nalo ambomo yu alieli omba mawa terimumunge kote pilieli yemo pilipe keri pilipelie yu yuyu nimbendo: ‘Na Pulu Yemo pipili naa kolopo, yemboma kondo naa kolopo molio ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nalo i ambo wayemo alieli omba walsilimomonga pe altopa omba mawa temba kinie na kamu pilipu keri pilimbo kene yunge kote pilindembo.’ nirimu.” ⸤nimbe Yesusini⸥ nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Awili ⸤Yesusini aku ungu ikomo topa pora sipelie⸥ ungu te pea nimbendo: “Kote pilierimu ye kerimuni ambo wayemondo terimu mele pilieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aku sipe mele Pulu Yemone yunge yemboma umbune silimele yemboma aku telemelemonga kote pilieli yemo molopalie kote naa tendembaye? Yunge ou mako torumu yembomane ipulueli kepe tangoli kepe alieli “Olionga kote pilindei.” ningu mawa telemele kinie yuni enonga kote naa pilindimbeye? Yuou we molopa pe mele “Eno lipu tapondambo.” nimbe taka lipe ombáye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yu temba mele nimbu siembo: Pulu Yemo yu welea omba yunge yemboma lipe tapondombando, eno umbune silimele yemboma kote tendepalie mindili simbe. Nalo Manie Omba Mana Ye A Lierimu Yemo kelepa wale talo sipe manie ombá kinie “Yembo marene ‘Yuni eno lipe tapondomba.’ ningu yu mawa teko molonge molo molonje?” nimbe omba kanomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yembo mare eno enone pilkulie ‘Na peanga. Na sumbi sipu molio, yembo lupema molko kenjilimele. Eno yembo kerime. Eno kinie tapu topo naa molambo.’ ningu pilku andoko moloringi yembomando Yesusini iungu ikomo topalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ye talo yu mele mele ‘Pulu Yemo kinie ungu niembili.’ ningulu Pulu Yemo popo toko kaloringi ulke tembelena puringili. Te Parisi ye te, te kou takisi lili ye te. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi yemo pende tepa ola angilipelie yu yuyu konopuni pilierimu ungume nimbendo: “Pulu Yemo, yembolupe molemele mele na aku sipu naa moliomonga nu “Ange.” nikiru. Eno wa nongo, ulu pulu kerime teko, ambo yema wa ulu kerinele teko, telemele. Ikou takisi lili yemo tepa molemo mele kepe na naa telio. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na koro tenga tenga wale talo langi mi topo naa nombo, kou mone kinie melema kinie mele tene tene nimbu liomanga telu telu nimbu nu silio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nalo kou takisi lili yemo nondopa naa omba anjo tenga lupe ma kanopa angilipe, ‘Na ye paa keri te.’ nimbe pilipelie pipili kolopa ki-lumuni yunge luwine topa angilipelie nimbendo: “Pulu Yemo, na konopune ulu pulu keri peli yemo kondo kolou.” nirimu.” ⸤nimbe Yesusini nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nane enondo paa sike nimbu sikirumu: Iyeselonga Pulu Yemone kou takisi lili yemonga ulu pulu kerime siye kolopa, yu ‘ye sumbi nilimu.’ nimbe kanopa molopili lkondo purumu, nalo Parisi yemo yunge ulu pulu kerime konopune we pepili lkondo purumu. Yembo enono imbi liku ola mundulimele yemboma Pulu Yemone topa manie mundumbe, nalo yembo enono toko manie mundulimele yemboma yuni enonga imbime lipe ola mundundumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kanu kinie yembomane enonga ambolango kangama ‘Yesusi yunge kimuni ambolopili.’ ningu yu molorumune mengo oringi. Mengo onge oringi kanokolie Yesusi lombili andolimene iri toko ⸤“Naa mengo waa.”⸥ niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nalo Yesusini ambolangomando “Waa.” nimbelie ⸤yu lombili andolimendo⸥ nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo yembo talape akumu i ambolangoma mele molemele yemboma enonga yembo talapemo kene enone i ambolangoma na moliona wangi pipi siku “Molo.” naa niee.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Nane enondo paa sike nimbu sikirumu: Ambolangomane ‘Pulu Yemo olionga ye nomi kingimu molopili.’ ningu molemele mele aku siku naa nilimele yemboma yunge koleana suku paa naa punge, molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","⸤Walse Juda yembomanga⸥ ye nomi te Yesusi molorumune omba yundu walsipe pilipelie nimbendo: “Ungu Mane Sili Peangamo, na nambolka uluri tembo kinie na konde molopa kondopa mindi puli ulu pulumu limboye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesusini yundu nimbendo: “Nuni na nambemune “Peangamo.” nikinuye? Yembo peanga te molo. Pulu Yemo mindi peangamo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","⸤Aku nimbelie yemone walserimumunge topondopa nimbendo:⸥ “Nu ⸤Pulu Yemonga⸥ ungu manema ⸤Mosisini yando nimbe sirimume⸥ pilino. Yuni nimbendo: “Ambo ye pulime molo ye ambo lilime yembo lupema-kinie wa ulu kerinele naa teangi.” nimbe, “Yembo toko naa kondangi.” nimbe, “Melema wa naa liengi.” nimbe, “Yembomanga kote kolo toko naa tendangi.” nimbe, “Aminieli lanieli kinie teko kondoko, ungu ninge mele pilku liku teko molangi.” nimbe, ungu mane akume sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aku nirimu kinie pilipelie kanu yemone nimbendo: “Na kangomo molopolie aku ungu manema pali pilipu lipu tepo molorundu mele yandopa kinié kepe tepo molioko.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yu aku nirimu pilipelie Yesusini yundu nimbendo: “Papu teleno nalo ulu telu mindi naa teleno. Nu puku nunge mele nosilinoma pali kou mone li-pukulie, kou mone linime yembo koropama moke teko sikulie na lombili ou.” nirimu. “Nunge ⸤mana⸥ melema aku teni kinie mulu koleana nunge mele kande kandema lemba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kanu ye nomimu mele paa kande kandema noserimu kulu Yesusini aku nirimu kinie pilipelie yu konopu keri panjipe konopu umbune paa tepili anjo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yu aku sipe purumu kanopalie Yesusini yu lombili andolimendo nimbendo: “Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungendo yembo kamakoma paamindili siku suku punge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kongi kemele ⸤kongi paaawili te nalo⸥ kale suru toline suku pumbendo mindili kanga mele sipelie pumbe. Nalo yembo kamakoma Pulu Yemo ye nomi kingimu molopa nokolemo koleana suku pungendo mindili paa awili mele siku punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yuni aku nirimu pilieringi yembomane ningendo: “Aku liemo mindili nolemela aulkena nawe manda wendo pupe, molopo kondomolo aulkena pumbeye? Te molonje?” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","yuni enondo nimbendo: “Yembomane paamanda naa telemele ulume Pulu Yemone manda temba. Pulu Yemo yuni ulume pali kapola telemo. Ulu te yuni manda naa temba te molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","⸤Yuni aku nirimu kinie pilipelie⸥ Pitane yundu nimbendo: “⸤Pe olio-kinie nambolka uluri wendo ombáye?⸥ Olio olionga melema pali mundupu siye kolopo nu lombili purumulu mele pulimolo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesusini nimbendo: “Nane enondo paa sike nimbu sikirumu: Pulu Yemo omba ye nomi kingimu molopa nokomba walemo wendo ombá mele ‘Yemboma piliengi!’ ningu siliku andongendo enonga ulkema kinie, menupili kinie, angenupili kinie, anupili lapali kinie, ambolangoma kinie, akume munduku siye kolonge yemboma pali ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ya mana paa olandopa mele awisili likulie pe punge koleana konde molko kondoko mindi puli ulu pulumu lingela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kanu kinie Yesusini ⸤yu lombili andoli⸥ ye engaki rurepo ‘na kinie eno kinie oliolio molamili.’ nimbe eno lipe anjo memba pupelie enondo nimbendo: “Pilieme. Olio kolea awili Jerusalleme pumolo pukumulu. Akune pumolo kinie ou Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane wendo ombá mele ningu bokune toringi ulume pali Manie Omba Mana Ye A Lierimu Yemo-kinie kamu wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Juda yembomanga ye awilimene Manie Omba Mana Ye A Lierimu Yemo liku Juda ye naa molemele yema singe. Enone yu ungu taka tondoko yu teko kenjiku yunge kumbikerena olkambe toko, ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","yu ka pulsene toko yu toko kondonge. Yu toko kondonge kinie wale yepoko sipemonga lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nalo yuni ungu nirimumu pilku sundoringi. Ungu pulumu naa pilkulie ungu nirimumu pilku sundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kanu kinie Yesusi Jeriko taono nondopa ombá orumu kinie mongo keri lierimu ye te aulke alselsena molopa yemboma “Kou mone siee.” nimbe mawa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kanu yemone yembo awisili ongo punge puringi pilipelie yuni “Nambe-ekemeleye?” nimbe walserimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","enone yundu ningendo: “Nasarete ye Yesusi omba pukumu.” ningu, ningu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aku niringi pilipelie yuni tondolo ru nimbe walsipelie nimbendo: “Yesusi, ⸤ye nomi kingi⸥ Depisini kalopa lsimu yemo, na kondo kolou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kumbi leko puringi yembomane yu iri toko “Nuungu naa nili taka liku molou.” niringi. Nalo yuni paa tondolo ru nimbe walsipelie nimbendo: “Depisini kalopa lsimu yemo, na kondo kolou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesusi we angilipelie “Yu yando mengo waa.” nirimu. Yu Yesusi angilierimune nondopa orumu kinie Yesusini yundu walsipe pilipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nane nu nambe-eambo konopu lekenoye?” nirimu. Yuni topondopa nimbendo: “Awilimu, na mongone melema kanambo nanga mongoselo teko peanga tendani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesusini yundu nimbendo: “‘Nane nunge mongoselo kapola tendembo.’ konopu lienumunge nu umbu mongo kapola angiliepili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesusini aku nirimu kinie yu tamburumbu mongoselo peanga lierimu, melema kanopalie Pulu Yemo kapi nimbe yunge imbi lipe ola mundundulipe Yesusi lombili purumu. Yembomane pali kanu ulu ⸤tondolo wendo orumumu⸥ kanokolie enone kepe Pulu Yemo kapi niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesusi yu Jeriko taono omba pumbe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","⸤Jeriko akune⸥ kou takisi lipe takisi lsingi yema nokorumu ye te, yunge imbi Sakiasi, yu akune molorumu. Yu mele awisili nosipe yu kamakomo molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kanu yemone Yesusi orumu kanomba terimu. Yesusi orumune yembo awisili liku maku toringi kulu Sakiasi yu ye ponjili kulu molopalie Yesusi manda naa kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Akumunge Yesusi orumune yu lkisipe kumbi lepa pupelie unjo sikamo-piki te Yesusi ombá orumu aulkena nondopa angilierimu unjo tenga omba ola purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusi akune ombalie we angilipe olando sipe kanopalie yundu nimbendo: “Sakiasi, nunge ulkena kinié na pea molambili pambili welea manie ou.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","yu popenge tepa manie omba yundu “Kapola.” nimbe konopu sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yesusi Sakiasinge ulkena pea puringili kanokolie ou akune liku maku toringi yembomane ningendo: “Yu ulu pulu keri teli ye te kinie ‘Molambili.’ nimbe pukumu.” ningulie yu terimu mele kanoko keri kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanu kinie Yesusi kinie Sakiasi kinie elo ulkena suku molkololie Sakiasi ola angilipe Awilimundu nimbendo: “Awilimu, nane nundu ungu te niembo pílie. Nanga mele nosilioma ekendo lipu yembo koropama sipulie, pe kou te molo melte kolo topo wa mele lsindu melte altopo wa lsindu mele pundu topo yepoko ola panjipu anjo simbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yuni aku sipe nirimu kinie Yesusini yundu nimbendo: “Kinié iulke pulu yemboma Pulu Yemone lipe tapondopa ‘mindili nolemela aulkena wendo ongo, yu-kinie pea molko kondonge aulkena pangi.’ nilimo ulu pulumu likimili. Kinié iulke pulu yemo yu kepe anda kolepa Eporayamone kalopa lsimu ye te kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Manie Omba Mana Ye A Lierimu Yemone ‘Yemboaulke lou leko molko kenjilimele yemboma koropo, eno lipu tapondopo mindili nolemela aulkena wendo lipu na-kinie molko kondonge aulkena lipu mondombo.’ nimbe orumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aku sipe nirimu pilkulie Yesusi yu kolea awili Jerusalleme nondopa ombá terimu kulu kanokolie weyemboma enone ‘Pulu Yemo omba ye nomi kingimu molomba walemo paa nondopa ombá.’ konopu leko moloringi. Enone aku siku pilku moloringi pilipelie ⸤Yesusi⸥ yuni enondo ungu iko te topalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nimbendo: “Ye nomi tenga malo kolea tenga aulke sulu pupe yukingi molomba namba tondolo te li-pupelie ‘Pe yando ombó.’ nimbelie yu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ou naa pupili yunge kendemande rureponga talondo “Waa.” nimbelie kou kulupi rureponga talo moke tepa eno yu mele mele kou kulupi telu telu nimbe sipelie enondo nimbendo: “Na wele anjo molambo ikou mone sikiru likimilimunge ‘Kou te olandopa pea liemili.’ ningu konopu tondolo munduku teko molangi. Pe ombó.” nimbe yu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kanu yemo purumu kinie yunge talapena yemboma yu kinie konopu keri pilieringi kulu enonga ye te ‘Yuakilipe pupili.’ ningu liku mundukulie ningendo: “‘ “I ye nomimu olionga ye nomi kingi naa molopili.” nimbu molemolo.’ nindei.” ningu yu liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pe kanu yemo kingi nambamo sike lipe meli yando orumu kinie ou kou mone sipe purumu kendemandemando “Waa.” nimbelie “Eno kou mone sirindumunge olandopa kou nambeko lsingiye?” nimbe walserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ou kumbi lepa sirimu yemone omba yundu nimbendo: “Awilimu, nunge kou kulupi te sirinu kanumunge ola panjipu kulupi rureponga talo lsindu.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ye nomi kingimuni yundu nimbendo: “Kendemande peangamo. Papu terinu. Mele kanga sirindumunge nu teko kondorunu kene nu kolea awili rureponga talo nokani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ye talo sipemone omba yundu nimbendo: “Awilimu, nunge kou kulupi te sirinu kanumunge ola panjipu kulupi kise pakera lsindu.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ye nomi kingimuni yundu nimbendo: “Aku siku terinumunge nu kolea awili kise pakera nokani.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pe kendemande te omba yundu nimbendo: “Awilimu, nane pilipulie ‘Nu bisinete tondolo munduku teko, ‘Kou mone lipu nosimbomonga yemboma mindili nongi liemo mandala.’ ningu ⸤kendemande yemboma ‘Kongono mindili siku teangi.’ ningu siku, eno mele koltalo siku melema pali nunu mindi lino yemo;⸥ ponie yembomane panjindilimele kinie nu nunu langi melema we akuku liku; ponie naa teleno poniena langi liku nosiku, nu aku siku teko moleno yemo.’ pilipulie pipili kolopo nuni na sirinu koumu kulupi topo noserindumu i sikiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aku nirimu kinie pilipelie ye nomimuni iri topalie yundu nimbendo: “Nu kendemande kerimu. ⸤Nane nunge kote pilimbo kinie⸥ nunge nikinu ungumuni nunu kote tendemba. Nuni pilkulie ‘Ponie yembomane panjindilimele kinie na nanu langi melema we akupu lipu; ponie naa telio poniena langi lipu nosipu, na aku sipu tepo molio.’ ningu pilku molenoye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aku ningu pilkulie nanga kou monemo kou-benge ulkena nambemune naa noserinuye? Aku telenanje na ombo nanga koumu wendo lipulie kou wallo-kolte ola panjiku silimela lilkela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","⸤Kanu kendemande yemondo aku sipe nimbe pora sipelie⸥ yuni nondoko angilieringi yembomando nimbendo: “I yemo tepa kenjerimu kene yunge koumu wendo likulie kou kulupi rureponga talo ambolkomo yemo siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Enone yundu ningendo: “Awilimu, yu kou kulupi rureponga talo ambolkomo kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Enone aku niringi kinie ye nomi kingimuni kelepa nimbendo: “Enondo nimbu siembo: Melema nosilimo yembomo nane mare pea simbo, yu paa awisili nosimbe. Nalo melema naa nosilimo yembomo yu nosilimoma kepe wendo limbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aku sipe nimbelie kanu ye nomi kingimu yuni ungu te pea nimbendo: “Kinié na teko kenjeringi yemboma mengo wame. Enone nando ningendo: ‘Iyemo olionga ye nomi kingimu naa molopili.’ niringi kanu yemboma mengo ongo na kanopo molambo eno toko kondaa.” nirimu.” nimbe ⸤Yesusini aku sipe kanu ungu ikomo topa pora sirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Topa pora sipelie kolea awili Jerusallemendo kelepa pumbe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kanu kinie Yesusi ⸤kinie yu lombili andolime kinie⸥ eno kolea awili Jerusalleme nondoko ongo, ma pangi te ‘Ma Pangi Unjo Ollipi Ponie’ nili akune lemo kolea kanga talo, Betepasi kinie Betaniselonga oringi. Kanu kinie Yesusini yu lombili andoli ye talo lipe mundupelie, elondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ne kolea kanga kanokombelena pukululie kongi dongi walo te, yembo te yunge bulu mingine walsikele kepe naa molopa andorumumu ka teko panjingemo ne sukundu molomba kanongele kanumu puku posiku mengo wangili pale. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Posingele teko molongele kinie yembo tene elondo “Dongimu nambemune posikimbiliye?” nimbe walsemu liemo elone i siku niengili: “Awilimu yu ‘Dongimuni mepili.’ nimu-ne ombo likimbulu.” niengili.” nimbe elo lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kanu lipe mundorumu yeselo pukulu yuni nirimu mele kanoko lendekololie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","pe kanu kongi dongi walomo posikulu moloringili kinie dongi pulu yemane elondo ningendo: “Olionga dongimu nambemune posikimbiliye?” ningu walseringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","elone “Awilimu yu ‘Dongimuni mepili.’ nimu-ne ombo likimbulu.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kanu kinie dongi kanumu likulu Yesusi molorumune mengo ongololie enone enonga mulumbalema kulku, dongimunge bulu mingine ola pauwe tondoko Yesusi kanune ola mondoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Marene enonga mulumbalema kulku yu ombá aulkena pauwe toliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kanu kinie yu Jerusalleme paa nondopa omba, ‘Ma Pangi Unjo Ollipi Ponie’ nili akune manie ombá orumu kinie yu lombili puringi yembo awisili konopu awili teko siku ⸤Yesusini⸥ ulu tondolo awisili terimu kanoringimenga Pulu Yemo kapi ningu ungu tondolo munduku ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pulu Ye Yawene lipe mundorumu-ne yunge kongonomo tendemba okomo ye nomi kingimu molopa kondopili. Mulu koleana konopu pe nipili molomolo walemo welea opili. Mulu koleana paa olandopa ⸤Pulu Yemonga⸥ imbi paa ola molopili lakopo kapi niemili.” niliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aku siku niringi pilkulie pea oringi Parisi ye marene ⸤we yembomane aku siku niringi mele pilku keri pilkulie⸥ yundu ningendo: “Ungu Mane Silimu, nu lombili andolimene nikimili mele ‘Naa niengi.’ ningu eno iri tou.” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesusini enondo nimbendo: “Nane enondo isipu nikiru: Iyembomane i siku naa ningu we molongi liemo ya kou lemomane ru ninge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kolea awili Jerusalleme paa nondopa omba kanumu kanopalie nirimumuni, Yesusini kola tepalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nimbendo: “⸤Jerusalleme yemboma,⸥ kinié eno kepe mindili naa nongo kapola kapola molonge aulkemo pilimelanje papu. Nalo kinié naa pilimele, naa pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Eno molongena wale mare wendo ombá, kanu walemanga enonga opa puluema ongo ‘Enonga koleamonga aulke naa liepili.’ ningu ma liku maku toko, pala mele teko opa puluema eno molko makapu teko ‘Eno sukundu molangi.’ ningu aku tenge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aku tekolie ningemone, pe Jerusalleme ulkema pali toko tekisiku bulu-balu sikulie suku molonge yemboma tonge, aku siku tenge walema wendo ombá lemo. Pulu Yemone ⸤eno lipe tapondombando⸥ omu walemo enone naa piliengimunge kanu walema wendo ombá.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesusi Jerusalleme suku pupelie nirimumuni, Pulu Yemo popo toko kaloringi ulke tembelena ⸤“Juda yembo naa molemele yemboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akune⸥ suku pupe kanopalie akune melema makete teko moloringi yemboma topa makoromba makoropalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","enondo nimbendo: “Pulu Yemonga bokune ungu te isipe nilimo: ‘Yembomane nanga ulkemondo “Pulu Yemo kinie ungu nilimolo ulkemo.” ninge.’ kanumu. Ungu aku sipe molemo nalo enone iulkemo ‘wa nolemele yemboma lopi teko molemele ulkemo’ mele ningu pilkulie aku siku telemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yuni enamanga taki teki ulke tembelena suku ⸤“Juda yembo naa molemele yemboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akune⸥ yemboma ungu mane sirimu. Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Juda yemboma nokoringi ye awilime kinie, enone yu toko kondonge aulke te kororingi ");
INSERT INTO ubu_kala_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nalo we yembomane yunge ungu komu tendeko pilku moloringi kulu enone yu toko kondonge aulke te naa kanoko lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Walse ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena Yesusi akune maku toringi yemboma ungu mane sipe, temane peangamo topa sipe molorumu kinie yemare, Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Juda yembomanga tapu yema kinie, eno ongo ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","yu walsiku pilkulie ningendo: “Nu namba nambolka nambamo likulie ikongonomo telenoye? Nawene ikongonomo “Te-pou.” nimbe nu nambamo sipe lipe mundorumuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesusini enondo topondopa nimbendo: “Nane eno ungu te walsipu piliembola. Eno walsimbo mele enone na topondoko niengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ou ⸤No Lindeli⸥ Jono omba yemboma no linderimu kinie yu mulu koleana ⸤molemo yemonga⸥ kongonomo tendembando yemboma no linderimu molo ya mana yembomanga kongonomo tendembando yemboma no linderimuye? ⸤Nawene “Tei.” nirimu-ne terimuye? Ningu siee.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","⸤Yuni aku sipe walserimu mele pilkulie⸥ enone enono kerepale ningulie ningendo: “Yuni walsikimu mele olione topondopo, “⸤Jono⸥ yu mulu koleana ⸤molemo yemonga kongono tendembando yemboma no linderimu⸥.” nimulu liemo yuni oliondo nimbendo: “Aku liemo eno Jonone nirimu ungumu nambemune ‘Iungumu sike.’ ningu naa pilku lsingiye?” nimbé. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Molo olione nimolondo: “Yu mana yembomanga ⸤kongono tendembando yemboma no linderimu⸥.” nimulu liemo we yembomane olio kouni tonge. We yembomane ‘Jono yu paa sike Pulu Yemone ungu umbu tondorumumu pilipe yemboma nimbe sirimu ye te molorumu.’ ningu pilimele kene enone olio kouni tonge.” ningu enono aku siku kerepale niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","⸤Enono aku siku anjo yando kerepale ningulie⸥, Yesusindu topondoko ningendo: “Yuni Pulu Yemonga kongono tendepalie yemboma no linderimu, molo mana yembomanga kongono tendepalie yuni yemboma no linderimunje. Olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aku siku niringi kinie pilipelie Yesusini enondo nimbendo: “Kapola. ⸤Nane eno walsikiru ungumunge ungute topondoko naa nikimilimunge⸥ enone na walsikimili ungumunge ungu te topondopo nando ikongonomo ‘Te-pou.’ nimbe na lipe mundupe namba sirimu yemonga imbimu eno naa nimbu simbola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kanu kinie maku toko moloringi yembomando Yesusini ungu iko imu topalie nimbendo: “Ye tene unjo waene ponie terimu. Ye mare kanopa lipelie enondo nimbendo: “Nanga poniemo tapu tendeko unjo mongoma inie toko nokondangi. Pe waene-mongo polo tomba kinie unjo mongoma moke tepo, kongono tendenge mele mare eno liengi, mare na liembo.” nimbe kanu poniemo eno sipelie yu kolea paa suluringe pupe akune wale awisili molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kanu kinie pe waene-mongo polo tomba terimu kinie ponie pulu yemone yunge kendemande ye te “Nanga waene mongo siengi puku liku mendeko wani pu.” nimbe ponie nokoringi yema moloringine lipe mundorumu. Nalo kendemande yemo ⸤orumu kinie⸥ ponie nokoli yemane yu wale awisili kopene toko, waene mongo mare naa siku, ⸤“Yemo molemona kelko pu.” ningu⸥ yando we liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Altopa ponie pulu yemone kendemande ye te lipe ⸤“Nanga waene mongo lindi-pou.” nimbe lipe⸥ mundorumu. Nalo kendemande yemo ⸤orumu kinie⸥ ponie nokoli yemane yu ambolko likulie kopene toko, teko kenjiku, waene mongo mare naa siku yando we liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Altopa ponie pulu yemone kendemande ye te lipe mundorumu kinie enone yu tokolie poniena ulsu mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aku siku teringimunge ponie pulu yemone ⸤konopuni pilipelie⸥ ‘Kinié na tembo mele pilipero. Nanga malo, na konopu mondolio kangomo, eno yu pipili kolko liku awi siku yu waene mongo mare singenje.’ konopu lepalie ⸤yunge malo lipe mundorumu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nalo ponie nokoli yemane ponie pulu yemonga malo ombá orumu kanokolie enone enono ningendo: “Andi okomo yemo pe lapanga monge melema limbe yemo okomo. Yu topo kondopo, iponiemo olio kamu liemili.” ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","enone yu ambolko liku poniena ulsu mundukulie yu toko kondoringi.” ⸤nimbe Yesusini nirimu.⸥ ⸤Nimbelie ungu iko akumu topa pora simbendo akune maku toko moloringi yembomando nimbendo:⸥ “Ponie nokoli yemane aku siku teringimunge pe ponie pulu yemone eno-kinie nambolka uluri tembaye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yu omba kanu ye kerime topa kondopalie ‘Ye marene lupe poniemo nokondangi.’ nimbe lipe simbe.” nirimu. Kanu kinie Yesusini aku sipe nirimu kinie pilkulie enone ningendo: “Pulu Yemone ‘Aku sipe wendo naa opili, paa molo!’ nipili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusini ⸤Pulu Yemonga Juda yemboma nokoringi yemane yu toko kondonge mele pilipelie⸥ enondo nimbendo: “Pulu Yemonga ungu te bokune molemomonga ungu pulumu nambolkanje konopu lemeleye? Aku ungumu isipe mele: ‘Ulke takoringi yemane kanoko keri kanoko toko lteringi kou kanumu kinié kelepa ulke simu mele ulke enge sindeli kou awili peangamo.’ nimbe molemo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ikou ⸤nikiru⸥ munge ola yembo te a topa topalie ombele melema elke tomba. Nalo yembo te molombana ola koumu omba yu topalie kanu yembomo topa nurupulu tomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kanu kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, Pulu Yemo popo tondoringi ye awilime kinie, eno Yesusini ungu iko torumu kanumu pilkulie enone teko kenjiku yu tonge teko moloringi mele yuni nirimu pilkulie enone kanu enamonga yu ka singe teringi nalo kanu ye awilimene we yemboma pipili kolkolie yu naa liku ka siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanu kinie ⸤Juda yembomanga ye awilimene⸥ ‘Yesusi ka sipu ⸤kote tendemolondo⸥ gapomano yemo molombana membo pumolo.’ ningu molkolie yu kanoko moloringi. ‘Yuni ungu te nimbe kenjimbe kinie ka simolo.’ ningulie ye mare, ‘Konopu sumbi nimbe pepili molemolo. Yunge ungumu konopu sipu pilipu molemolo.’ ningu kolo toko molonge ye mare, liku yu molorumune liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kanu yemane ongo yundu ⸤kondi tokolie⸥ ningendo: “Ungu Mane Silimu, olio pilipulie, ‘Nu alieli ungu sikema mindi sumbi siku ningu, ungu mane sikema manjiku sumbi siku mane siku tekolie, nu yembo teluringe kepe konopu kimbú naa siku, yemboma pipili naa kolko, enondo pali ungu telu siku kapola kapola ningu siku, Pulu Yemone “Teaa.” nilimo ulume paa sike ungume mane siku, aku siku teleno.’ konopu lemolo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","⸤Aku siku teko molenomonga nu nambolka konopu lekenoye?⸥ Olione Romo Gapomano Ye Paa Awili Kumbine Sisamo kou takisi tomulu liemo kapola molo moloye? Pulu Yemone akumundu ungu mane sirimu ungu mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nalo Yesusini enone yu teko kenjingendo aku sikuliku lou siku walseringi pilipelie enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“⸤Takisi tolemele⸥ kou-mongo te na liku ora siee.” ⸤nimbelie enondo kelepa walsipe pilipelie nimbendo:⸥ “I koune nainge kumbikeremo kinie imbimu kinie molemoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Enone yundu ningendo: “Romo Gapomano Ye Paa Awili Kumbine Sisamonga ⸤kumbikeremo kinie imbimu kinie molemo⸥.” niringi. Kanu kinie yuni enondo nimbendo: “⸤Kou monemo Sisamonga⸥ kene Sisamonga melema Sisamo yuyu siku, Pulu Yemonga melema Pulu Yemo yuyu siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yuni aku sipe ⸤paa sumbi sipe⸥ nirimu mele pilkulie ‘Olionga ungumu paa topondopa nimbe kondokomo.’ ningu pilku konopu awisili liku mundukulie ungu te altoko naa niringi. Yemboma kanoko molangi yu liku lou siku walseringi kinie yuni ungu te nimbe naa kenjerimumunge “Yu ka siemili.” ninge aulke te naa lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","⸤Kanu yema Yesusi kinie kou takisi toli ungumu ningu pora siringi kinie⸥ pe Sadusi ye mare Yesusi molorumune oringi. Sadusi yema eno ‘Pulu Yemone pe kolemele yemboma topa naa makinjindimbe, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Kanu Sadusi yema ongo ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yesusi walsiku pilkulie ningendo: “Ungu Mane Silimu, ⸤Pulu Yemonga ungu manema olio sirimu ye⸥ Mosisini ungu mane sipelie nimbendo: “Ambo limbe ye te ambolango naa membalie ambomo we molopili kolomba kinie kanu yemo yunge angenu molombamone yunge ambo wayemo lipe angenu lipe tapondopa ambolango mendepili.” nirimu aku sipe nimbe bokune torumu molemo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","⸤Aku ungu manemonga ulu te olionga ye mare-kinie wendo orumu mele nu walsipu piliemili.⸥ “Angenupili yepoko pakera moloringi. Komomo ambo lipe ambolango te naa membalie kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","⸤Ambolango te naa molopili kolorumu kulu⸥ yunge bulkundu angenumuni ⸤yunge angenu kolorumumunge ambolango ‘Mendambo.’ nimbe⸥ ambo-wayemo kelepa lsimu. Yu ambolango te naa mendepalie yu we kolorumula. Yunge angenu bulkundumuni kanu ambomo lsimula nalo yu kepe we kolorumula. Aku teliku pukulie ye yepoko pakera pali ambolango telu kepe naa mengolie kolko pora siringi kinie akiliomo we kolorumula. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pe ambomo yu kolorumula. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akumunge, kolemele yemboma pe lomboroko ola molonge kinie kanu ambomo ye yepoko pakera pali yamana lsingi kulu ambomo yu ye paa nainge menu molombaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesusini enondo topondopa nimbendo: “Ya mana molemele yembomanga yema ambo liku, amboma ye puku telemele ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nalo Pulu Yemone ‘Yembo kolkolie manda lomboroko ola molko mulu koleana puku molangi.’ nilimo yembomanga yema ambo naa liku, amboma ye naa puku, aku paa naa tenge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kanu yemboma lomboroko ola molonge-na eno mulu koleana molemele angelloma molemele mele aku siku molkolie, kelko kolou naa kolkolie Pulu Yemonga ambolangoma molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nalo ⸤eno Sadusimene⸥ ‘Kolemele yemboma lomboroko ola naa molonge.’ konopu lemelemonga ungu te niembola. Mosisini olio lipe ora sirimu mele niembo: Walse Mosisi unjo kanga tenga ⸤tepe nomba perimu tepemone unjomo naa norumu kanopalie nirimumuni,⸥ akune yuni ⸤Pulu Ye⸥ Yawendo imbi lepalie nimbendo: “Eporayamo kinie, Aisake kinie, Jekopo kinie enonga Pulu Yemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pulu Yemo yu kololi yembomanga Pulu Yemo molo. Yuyemboma pali konde molemele kanopalie yu konde mololi yembomanga Pulu Yemo.” nimbe Yesusini nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Aku nirimu pilkulie Pulu Yemonga ungu manemanga pulume pilku mane siringi ye marene altoko yu ungu te walsiku pilingendo pipili kolkolie yundu ningendo: “Ungu Mane Silimu, nuni papu nikinu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kanu kinie ⸤Juda yembomanga ye awili mare aku siku we moloringi kinie⸥ Yesusini enondo altopa ungu te nimbendo: “‘Pulu Yemone “Eno nokopa kondomba ye telipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu yu ⸤ye nomi kingi⸥ Depisinge kalopa limbe ye te molomba.’ ningu pilimele, ⸤nalo yu aku sipe manjipe molo⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","⸤Aku nilimele yemane⸥ Depisi yuni yuyu ⸤kanu yemondo nirimu mele naa pilimelenje.⸥ Depisini ⸤ye nomi Kirasimu molomba mele⸥ konana te konopuni pilipelie bokune torumu mele isipe: “Awili ⸤Pulu Ye Yawene⸥ nanga Awilimundu nimbendo: “‘Nunge opa puluema nuni nokani.’ nimbu, pe eno topo manie mundundumbo kene isili-ou nu ⸤na kinie pea tapu topolo ye nomiselo molopolo melema nokambili⸥ nanga ki umbukundu ongo molani.” nirimu.” nimbe Depisini nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Depisini ⸤ye nomi Kirasimu⸥ yundu “Nu nanga Awilimu.” nirimu. Pe enone “Yu Depisini kalopa limbe yemo ⸤mindi⸥ molomba.” nambeko pilkulie nilimeleye?” nimbe Yesusini nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesusi molorumune yembo awisili liku maku toko moloringime pilku molangi Yesusini yu lombili andolimendo ⸤liepi-liepi topa⸥ ungu te nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Enone Pulu Yemonga ungu manemanga pulume pilku mane sili yema mimi siku kanoko kondoko ⸤enone telemele mele manda manjiku naa teko⸥ molayo. ⸤‘Yembomane olio kanoko “Ye peangama” niengi.’ ningu⸥ wale pakoli paa sulu peangama, ⸤ye nomime pakolemele mele,⸥ pakoko andolemele. Yemboma maku toko molemele koleamanga andongendo mongo-kenge teko ‘We yembomane olio kapi niengi.’ ningu pilkulie konopu siku pilku andoko molemelela. Yemboma maku toko Pulu Yemonga ungumu pilimele ulkena sukundu pukulie manie molongendo ye awilime molemele polo peanga akune ‘molamili.’ ningu mendo puku polo akune konopu siku molemelela. Yembomane langi nongo yembomando “Namili waa.” nilimele kinie kanu yema ongolie ye awilimenga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Yema kolemele kinie enone kanu yemanga ambo wayema toko makoroko mundukulie ulkema ‘Olionga’ ningu we limele. Pulu Yemo kinie ungu ningendo ningu sulu munduku kolo toko nilimele. Pulu Yemone we yemboma ulu pulu keri telemelemonga eno sike mongo lipe simbe nalo ya ye nikirumene aku ulume telemelemonga Pulu Yemone aku yema mongo awili tepa lipe simbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesusi ⸤Pulu Yemo popo toko kaloringi ulke tembele kerepulune molopa⸥ ulke tembelena sukundu kongono tenge kou mone mundoringi unjo ketena nondopa molorumu. Akune molopalie yu olando sipe kanopalie ye kamakomane kanu ketena kou mone ongo mundoringi kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","⸤Aku sipe kanopa molorumu kinie⸥ ambo waye paa koropa te omba yu kou kololi talo mindi mundorumu kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","nimbendo: “Nane enondo paasike nimbu sikirumu: Andi ambo-waye koropamo yuni kou mone mundukumumu paaolandopa mele mundukumu, we mundukumilime maniendopa mele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Eno kou mone awisili nosilimelemanga koltalo mindi ongo mundukumili. Nalo ambo-wayemo kou mone te paa naa nosilimo. Yunge koltalo nosemuselo pali memba omba mundomu. Langi nombá te kepe naa nosilimo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kanu kinie Yesusi kinie yu lombili andoli yema kinie eno ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelemo kolea akune molkolie ulke tembele paa peanga angilierimu mele kinie ulke tembelemo takoringi kou paapeanga lupe lupema kinie aku koune a siringi mele kinie kanoko, marene ungu anjo yando ningu moloringi kinie Yesusini enondo nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ya ⸤ulke tembele peanga angilimo⸥ kanokomele melema ⸤pe walse ya kolea awili Jerusalleme yemboma mindili nonge walemo wendo ombá kinie⸥ iulke tembelemo tekisikulie koume pali toko manie mundunge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesusini aku nirimu pilkulie enone yundu walsiku pilkulie ningendo: “Ungu Mane Silimu, nuni nikinu mele tewale wendo ombáye? Pe nuni inikinu ulume nondopa wendo ombándo ou nambolka uluri temba kinie olione kanopolie ‘Sike iwendo ombá tepamo.’ nimbu pilimoloye?” ningu walseringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","yuni enondo nimbendo: “⸤Kanu ulume wendo ombámonga ungu mare⸥ yembomane eno kolo toko singe kene kanoko kondoko molangi. Ye awisili nanga imbi leko ongolie yu-mele-mele kolo toko ningendo: “⸤Pulu Yemone ‘Nanga yemboma nokopili lipu mundumbo.’ ou nimbe mako torumu ye nomi Kirasi⸥ akumu na.” ningulie, “⸤Ma pora nimbé⸥ wale nirimumu wendo ombá tekemo.” ningela. Eno lombili naa pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kolea marenga opa awili teko tenge mele pilku, yembomane enonga ye nomime tonge pilkulie mini-wale naa mundengi. Opa tengema kinie aku ulume Pulu Yemone ‘Ou wendo opili. Laye pe mele ya ma koleamo pora nimbé.’ nimbe, nimbe panjerimumunge aku ulume sike wendo ombá nalo akukinie mulu maselo ou naa pora nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kanu kinie Yesusini yu lombili andolimendo kelepa nimbendo: “⸤Mulu ma pora nimbé walemo ou wendo naa opili⸥ yembo talape awili te kinie talape awili te kinie opa tekolo, ye nomi kingi marenga talapema kinie marenga talapema kinie opa tenge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ya mana kolea tenga tenga ma jimi-jimi awili-tepa tepa, engele lepa, kuru awili-tepa topa, aku sipe temba. Yemboma pipili awili-tepa tepa kondoli ulu tondoloma mulune wendo ombá kanongela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Aku sipe mele ⸤pe wendo ombá nalo⸥ ou naa wendo opili eno nanga yemboma molongemonga eno ⸤mare⸥ liku ambolko, teko kenjinge. Eno ⸤mare⸥ Juda yemboma maku toko Pulu Yemonga ungumu pilimele ulkemanga liku mengo puku ⸤akune kote tendeko⸥, eno ⸤mare⸥ ka ulkena mengo puku panjiku, eno ⸤mare ka siku⸥ ye nomi kingime kinie gapomano ye awilime kinie molongena ⸤kote tendengendo⸥ mengo pungela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","⸤Ka siku kote tendenge kinie kotena angilkulie kanu yema kinie kanu yema nokonge ye nomime kinie⸥ enone ‘Nanga ungumu piliengi!’ ningu, eno ningu singe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Eno ka siku kote tendenge kinie ‘Enonga kere kinie konopu kinie tondolo pupili.’ nimbo kinie enone ninge ungume eno teko kenjinge tenge yembomane enone ungu ninge mele ungu ningu pundu tongendo perenge. Akumunge eno ou ongo ka naa siengi ‘Kotena nambolka unguri nimolonje? Olio ungu te walsiku pilinge kinie nambolka unguri topondopo nimolonje?’ ningu mini-wale naa mundengi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Enonga kandi aminieli lanieli kinie angenali kinie, pulu lemba yemboma kinie, enone kepe liku ka siku kote tendekolie eno mare toko kondongela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nanga yemboma molongemonga yembomane pali eno-kinie konopu keri panjinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nalo enonga kangine uluri naa tepa penge indi kepe telu omba manie naa pumbe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","⸤Nanga yemboma molongemonga enone eno aku siku teko kenjinge kinie⸥ na munduku siye naa kolko tondolo munduku molonge yemboma mini pali konde molko kondoko mindi puli ulu pulumu linge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pe walse, ami yema ikolea awili Jerusalleme yemboma tongendo ongo liku makaye teko molonge kanokolie ikolea Jerusalleme yemboma toko mundunge walemo nondopa wendo ombá mele pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","⸤Aku siku mele wendo ombá kanokolie ‘Umbune awilime wendo ombá tekemo.’ ningu pilku⸥ kolea Judia disiriki lierimu koleamanga molonge yemboma ⸤enonga koleama munduku siye kolko⸥ ma pangi lembamanga kowa puku, Jerusalleme suku molonge yemboma wendo ongo kowa puku, Jerusalleme ulsu molonge yemboma altoko suku naa pangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aku walemanga Jerusalleme yembomane ou taki teki Pulu Yemo teko kenjeringimunge yuni eno mongo simbe. Koronga ou yuni ‘Walse aku sipu tembo.’ nimbe, nimbe panjerimu kanu ungumu yunge ye marene yunge bokune toringi molemo kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“⸤Pulu Yemone⸥ Jerusalleme yemboma mumindili kolopalie ‘Ami yema eno-kinie mumindili kolko ongo tangi.’ nimbé kinie ulu umbune teli awisili eno molongena wendo ombá. “Aku sipe wendo ombá kinie ambo ambolango mondongema kinie, ambo ambolango ame singema kinie, ⸤eno manda lkisiku kowa naa pungemonga⸥ eno-kinie paaumbune wendo ombámonga eno kondo tekemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jerusalleme yemboma tonge walemanga yembo toli lou-pulsemane yembo mare toko kondonge, mare ka siku kolea sulu lupe lupemanga mengo punge. Juda yembomanga talapena ulsu mololi yemboma ya Juda yembomanga kolea awili Jerusalleme suku ongo toko munduku kolea liku kolo wangoko molonge. Kanu kinie pe Pulu Yemone ‘Enonga walema pora nipili.’ nimbé kinie Juda yemboma Jerusalleme kelko ongo molonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“⸤Aku mindili nonge nikiru ulume wendo ombá kinie⸥ ena kinie óli kinie kombukandipime kinie ⸤pali⸥ ulume temba yembomane kanokolie pilinge. Ma koleana nomu kusane ungu paa awili tepa nimbe, paa awili tepa topa piki-maka lepa no tomba kanongela. Ulume aku sipe wendo ombá kinie yembo talapema mini-wale mundunge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mulune angilimo mele tondoloma lope-lope tepa anjo yando pumbe kinie yemboma pipili paa awili teko kolko ‘Ma koleana nambolka uluri wendo ombá tekemonje?’ ningu pilku konopu paa awisili liku mundunge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Akuulume wendo ombá kinie Manie Omba Mana Ye A Lierimu Yemo tondolo pulimu kinie, tondolo pa awili-tepa telimu kinie, kupe tenga suku molopa, kamu manie ombá yembomane kanonge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Aku ulume pulu polopa temba kinie Pulu Yemone eno ulu pulu kerimene ka sipe nokolemomonga mindili siku molemele koleana wendo lipe, yu-kinie kamu tapu toko kapola molonge kolea peangana sukundu limbe walemo nondopa wendo ombá kene aku ulume wendo ombá kinie eno ola angilku olando siku kanangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","⸤Yesusini aku sipe nimbelie nirimumuni, yu ombá walemo ‘Piliengi!’ nimbe⸥ ungu iko te topalie nimbendo: “Unjo piki kinie we unjoma pali kinie kuku topa gomo tolemo kinie kanokolie ‘Kinié ena temba walemo wendo ombá tekemo lemo.’ ningu pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aku sipela iulume “Wendo ombá.” nikirume sike wendo ombá kinie kanokolie ningemone, “Pulu Yemo ye nomi kingimu molomba walemo nondopa wendo ombá tekemo.” ningu pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nane enondo paa sike nimbu sikirumu: Kinié molemele yemboma ou naa kolangi ⸤i “Wendo ombá.” nikiru⸥ ulume pali wendo ombá. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mulumu kinie mamo kinie pora nimbé nalo nanga ungu nilioma paa pora naa nimbé. ⸤Nilio mele pali paa sike wendo ombá.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Akumunge naa kanoko molangi kanu walemo ombá paapiliee! Lopa te yunge tapu andolemona ‘Pumbo.’ nimbe olemo kinie melu leko panjilimelemo naa kanopa ‘Yu tomba.’ konopu naa lepa walu olemo kinie pe melune walsikele tolemo, aku siku eno no tondolo nongo kekelepa toko we umbune tepili molko konopu naa makiliepili molongi liemo ⸤Manie Omba Mana Ye A Lierimu Yemo⸥ yu ombá kanu walemo eno naa kanangi lipe sinjipe wendo ombá kene kanoko kondoko pilku molayo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aku walemo ma koleana pali yemboma molongena wendo ombá kene ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","enone Pulu Yemo kinie mawa tekolie ningendo: “‘Na pe Manie Omba Mana Ye A Lierimu Yemonga kumbikerena pupu ola angiliembo kene na enge nipili, iulu wendo ombámane natopa manie naa mundopili.’ ni.” ningu alieli kanoko kondoko pilku molaa!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesusini enamanga taki-teki ulke tembelena yemboma ungu mane si-pou-pou tepa, ipulueli taki-teki Jerusalleme ulsukundunge pupe ma pangi Unjo Ollipi Poniena ola pupe pe-pou-pou terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yemboma pali paaipulueli-ou ‘Yu ungu mane simbema piliemili.’ ningu ulke tembelena ongo maku to-pou-pou teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","⸤Juda yembomane ponie tenga tenga kolea awili Jerusalleme ongo akune suku⸥ Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilieringi walema, akumu imbi leko ‘Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Walemo’ niringila, aku walemo nondopa wendo orumu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, enone Yesusi toko kondonge aulke te koroko moloringi nalo enone ⸤“Olio yembomane kanangi yu ka simolo kinie yembomane olio kinie mumindili kolko iri tonge.” ningu⸥ pipili kolko we moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanu kinie Yesusi yu lombili andoli ye rurepo akumenga ye Judasi, yunge imbi te ‘Isikeriote’ nili, kanumunge konopune ⸤kurumenga nomi⸥ Setene omba sukundu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","⸤Setene yunge konopune suku purumu⸥ kinie yu Pulu Yemo popo tondoringi ye awilime kinie, ulke tembele nokoli ele yemanga ele ye awilime kinie, enomoloringine pupelie, eno Yesusi ka singe aulkemo yuni akisindimbe mele eno-kinie kerepale niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yuni temba mele nirimu kinie pilkulie eno konopu awili teko siku “Nu kou mone te simolo.” ningu, ningu panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuni enonga ungume pilipelie “Kapola.” nimbe, we yemboma Yesusi pea naa molonge kinie yu eno lipe simbe mele aulkemo koropa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pillawa Akoli Mele Isimu Naa Munduku Pillawa We Kalko Noringi Walemo wendo orumu kinie Juda yembomane Pulu Yemone ou enonga anda kolepalime Naa Topa We Omba Purumu mele pilingendo kongi sipisipi walo te toko nonge mele pilipelie nirimumuni, ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesusini Pita kinie Jonoselo lipe mundupelie nimbendo: “Elo pukulu, Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu mele pilimolondo kongi sipisipi walo te kinié nomolomo teko mimi te-pale.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Elone walsikululie ningelendo: “Tena tepo mimi te-pambili konopu leko nikinuye?” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yuni elondo topondopa nimbendo: “Piliele. Ne ulke kolea awili ⸤Jerusallemendo⸥ pukululie, ye te mingine no kolopa meli ombá aulkena puku kane-kane tokololie, yu pumbe mele lombili pukulu yu suku pumbe ulkena suku pukululie ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ulke pulu yemondo ningelendo: “Ungu Mane Silimuni isipe walsipelie nimbendo: “Na kinie na lombili andoli yema kinie olione Pulu Yemone olionga anda-kolepalime Naa Topa We Omba Purumu mele pilimolondo kongi sipisipi walomo tena nomoloye? Nomolo suluminiamo tena lemoye?” nimu.” niengili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aku ningele kinie yuni elo ulkemonga olakondo suluminia awili te, akune langi noli polo te kinie, manie molomolo poloma kinie, melema kinie akune ou lemoma, lipe ora simbe. Aku suluminiamonga ⸤nomolo sipisipi walomo⸥ teko mimi teangili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kanu kinie elo pukululie, Yesusini nirimu kanu mele aku ulume teli lierimu kanoko lendekololie, akune Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilinge kongi sipisipi walo nongemo kinie langi nongema teko mimi teko noseringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Juda yembomane ipupene kolea kalá torumu kinie Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu Walemo pilingendo kongi sipisipi walomo nonge enamo kamu wendo orumu kinie, Yesusi kinie yunge kongonomo ‘tende-paa.’ nimbe lipe mundorumu yema kinie eno langi noli polona moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Langi nongo moloringi kinie yuni enondo nimbendo: “‘Na mindili ou naanombolie iwale wendo okomomonga langime eno kinie pea namili.’ paa tondolo mundupu konopu lepo andopo molorundu mele yandopa paa konopu lepo pilipu molio. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nane enondo isipu nimbu sikirumu: Isili ou ilangime na altopo naa nombó. Pulu Yemo ye nomi kingimu kamu molomba walemo wendo ombalie ilangimenga sike ulu pulumu wendo ombá kinie altopo nombó.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Yu no waene kapomo lipe ambolopalie Pulu Yemondo “Ange.” nimbelie nimbendo: “I mu eno enono moke teko nayo. Nane enondo isipu nimbu sikirumu: Isili ou na no-waene altopo paanaa nombó. Pe mindi, Pulu Yemo ye nomi kingimu molopa nokolemo walemo wendo ombá kinie na no waene kondemo kelepo nombó kene ⸤eno enono isili ou nangi⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Berete te lipe Pulu Yemo kinie “Ange.” nimbelie ambolopa pike lepa ⸤yu lombili andolime⸥ sipelie nimbendo: “I mu nanga kalumu ⸤eno liku nangi⸥. ‘Nanga kalumu ‘enonga’ nimbu ⸤lipu tapondambo.’ nimbu tangi⸥ simbo tekero imu. Pe pe kepe, ‘Eno lipu tapondambo.’ nimbu nanga kalumu enonga nimbu ‘Na tangi.’ nimbu simbo tekero mele ‘Altopo piliemili.’ ningu iberetemo “Nanga kalumu.” nimbu sikiru mele eno aku siku berete te nongolie piliengi!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pe eno langime nongo pora siringi kinie yuni ⸤berete te kinie terimu mele⸥ aku sipela no waene kapomo lipe ⸤eno sipelie⸥ nimbendo: “I ⸤no-waene⸥ kapo ⸤eno sikirumu⸥ nanga mememo. ⸤Pulu Yemone ‘Eno-kinie tembo.’ nimbe,⸥ ungu te nimbe panjipe mi lierimu kanu ungumu ‘Kamu wendo omba pepili.’ nimbu nane enonga nimbu nanga mememo ondo lendepolie ⸤kolombo⸥ aku mememo ino waenemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nalo na lipe nanga opa puluema simbe yemo nakinie pea ilangi nokomolo polona molemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","“Kinié Manie Omba Mana Ye A Lierimu Yemo kinie tenge mele Pulu Yemone koronga ou nimbe panjerimu mele sike opa puluemane tenge, nalo yu lipe opa puluema simbe yemo mindili nomba molopa kenjimbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aku nirimu kinie pilkulie ⸤yu lombili andolimene⸥ anjo yando walsikulie ningendo: “Olionga ye nawene ulu akumu tembanje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aku walemo kinie ungu te pea wendo orumula. ⸤Yesusi lombili andolimene⸥ eno enono anjo yando ungu mele tekolie ningendo: “Olionga ye nawe paa olandopa molemoye?” ningu kere-kuru liku moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesusini enondo nimbendo: “Olio Juda yembomanga ulsu molemele yembo talapemanga ye nomime enonga yemboma tondolo munduku nokoko kongono enge nilime alieli silimele. Ye imbi ola molemo yema enonga yemboma ‘Mindili nangi.’ ningu nokolemele yemane eno enono imbi liku ola munduku, “Olio yemboma nokopo kondopo lipu tapondoli yema.” nilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nalo ⸤we yembomanga ye nomimene enonga yemboma tondolo munduku nokolemele mele na lombili andoli yema⸥ eno enono aku siku anjo yando naa teangi. Enonga ye te imbi ola molomba kinie aku yemo ye koropa mele molopili. Ye nomi molopa we yema nokomba yemo ye kendemandemo mele molopa we yemanga kongono tendepili.” ⸤nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ye nawe paa ye olandopamoye? Langi nolemo yemo ye olandopamo molo langi peke topa kalopa pellete kulumiye topa aku kongonoma tendelemo yemo ye olandopamoye? Langi nolemo ye akumu ye nomimu lemo. Aku sipe, nalo na aku sipe molo. Na ⸤sike enonga ye awilimu⸥ nalo enonga kongono tendeli kendemande mele molopo eno lipu tapondoli yemo molio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","⸤Yesusini yu lombili andoli engaki rurepondo kelepa nimbendo:⸥ “Na mindili sipu molorundu molio mele eno na-kinie pea tapu topo mindili sipu molorumulu molemolola. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nanga Lapa ye nomi kingimu omba molopa yemboma nokomba kinie nando ‘Akune yemboma nokondopilila.’ nilimo nimbé mele nane enondo ‘Akune yemboma nokondangi.’ nilio nimbola. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Akune na ye nomi kingi molopo yemboma nokombo kinie eno na kinie pea langi polona molopo ga nombo molomolo. Eno ye nomi kingi polomanga molkolie ningemone, Isirele yembo talape rurepo nokonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","⸤Nimbelie, Yesusini lombili andoli ye Pitando nimbendo:⸥ “Saimono, pílie! ⸤Kurumenga nomi⸥ Setenene Pulu Yemondo mawa tepalie nimbendo: “Eno teko kenjingenje manda manjipu kondi topo kanambo.” nirimu kinie Pulu Yemone “Manda.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nalo Saimono, nane Pulu Yemo kinie ungu nimbu nunge mawa tendepolie nimbondo: “Setene yuni nu aku temba kinie Pita yuni na naa mundupe siye kolopa na pilipe molopili.” nindu. Saimono, Setene laye-kolte pilku na munduku siye kolkolie, pe konopu alowa teko na kelko tondolo munduku pilku molkolie ninimuni, angenalime tondolo mundundou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nalo Pitane nimbendo: “Awilimu, nane nu pe siye kolopo talopa lepo pumbo ningu nikinuye? Manda molo. Olto pea “Ka siemili.” ningi liemo papula. Molo olto pea “Topo kondamili.” ningi liemo uluri molo. Pea kolambili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusini Pitando nimbendo: “Pita, nane nundu isipu nimbu sikirumu: Kinié kera gulta ou ko naa topili nuni pipili kolkolie wale yepoko nando kolo toko “Yu naweye? Na naa kanolio.” nini.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nimbelie Yesusini yu ye ⸤rurepondo⸥ pali kelepa nimbendo: “Nane eno ou ⸤‘Kongono te-pangi.’ nimbu⸥ lipu mundorundu kinie ‘Kou naa mengo, mele wale naa mengo, kimbu-su naa mengo, we pangi.’ nimbu lipu mundorundu kinie eno melte molo torumu molo moloye?” nimbe walsipe pilierimu kinie enone “Mele telu kepe molo naa torumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yuni enondo kelepa nimbendo: “Nalo kinié na-kinie uluri wendo ombámonga, kou mone nosilimo yemo kanu kou monemo lipe ambolopa, mele wale nosilimo yemo kanu walemo lipe ambolopa, aku siku teko molangi. Opa teli lou-pulse naa nosilimo yemo yunge wale-pakoli te anjo sipe lou-pulse te yando lipili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","⸤Nane aku sipu nambemune nikiru, niembo.⸥ Ou yembomane nando ningu Pulu Yemonga bokune toringi molemo mele kinié wendo ombá tekemo mele isipe: “Yu kinie, yembo mongo liku ulu pulu kerime teli yemboma kinie, liku tere leko mako toringi.” niringi bokune molemo kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yuni aku nirimu mele pilku sundukulie enone yundu ningendo: “Awilimu, ya opa teli lou-pulse talo nosilimolo kanou.” niringi kinie yuni enondo nimbendo: “Ungu manda nimbu, ⸤pamolo.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kanu kinie Yesusi ⸤ulke mundupe siye kolopa koleaawili Jerusalleme⸥ ulsukundu pupelie nirimumuni, yutaki-teki ma pangi Unjo Ollipi Poniena ola pu-pou-pou terimu mele akune purumu. Yu lombili andolime yu lombili akiliku pea puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akune purumu kinie yuni yu lombili andolimendo nimbendo: “⸤Kurumenga nomi⸥ Setenene ‘Olio kondi tomba kinie tepo kenjimolo kene’ ningulie Pulu Yemo kinie ungu ningu mawa teko molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nimbelie yu yuyu laye kolte anjo pupe koporongo langopa, Pulu Yemo kinie ungu nimbe mawa tepalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, na mindili noli no mingine no nombómo ‘Naa nambo.’ konopu lienu liemo aku siku teani nalo ‘Nane tepolie nanu konopu simbo.’ konopu lekero mele naa teambo. Nuni kanoko peanga kanoni ulumu mindi teambo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aku nirimu kinie angello tene mulu koleana mundupe siye kolopa Yesusi yu molorumune omba ‘Yu tondolo pupili.’ nimbe terimu mele Yesusini yu kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kanu kinie yu konopune umbune awili-tepa tepa, kamelena mindili tepili molopalie yu Pulu Yemo kinie tondolo mundupe ungu nimbe mawa terimu-ne yunge kangine kúru omba kanu kúrumu meme none tepa mana manie purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yu Pulu Yemo kinie aku sipe ungu nimbelie ola angilipe yu lombili andoli yema moloringine yando omba enone yu kondo kolko molkolie uru peringi kanopalie ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","enondo nimbendo: “Eno uru nambemune pekemeleye? ‘⸤Kurumenga nomi Setenene⸥ olio kondi tomba kinie tepo kenjimolo kene’ ningulie ola molko Pulu Yemo kinie ungu ningu mawa teko molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesusini aku nimbe molopili eno moloringine ye awisili oringi. Oringi yemanga te kumbi lepa orumu yemo yu ye Judasi, Yesusi lombili andoli rureponga ye te. Judasi yu Yesusi molorumune nondopa omba yu kangulorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aku terimu kinie Yesusini yundu nimbendo: “Judasi, opa pulue yemane Manie Omba Mana Ye A Lierimu Yemo ‘kanoko imbi siku ka siengi.’ ningu nuni na kangulkunuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kanu kinie Yesusi pea tapu toko angilieringi yemane yu ulu temba terimu mele kanokolie enone yundu ningendo: “Awilimu, opa teli lou-pulsemane iyema tamiliye?” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","enonga ye tene ⸤yunge lou pokete-napimu lipe ambolopalie⸥ Pulu Yemo popo tondoringi ye awili olandopamonga kendemande ye tenga komumu topa lakálierimu kinie komumu omba manie purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aku terimu kanopalie Yesusini yundu nimbendo: “Kinié manda, keliee!” nimbelie torumu yemonga komumu lipe ambolopa tambu sinderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesusi ka singe oringi yema isipe: Pulu Yemo popo tondoringi ye awili mare kinie, tembele ulkemo nokoko moloringi ami yema nokoringi ye mare kinie, Juda yembomanga tapu ye mare kinie, enone Yesusi ka singe oringi kinie kanopalie enondo nimbendo: “Na ‘yembo topo wa noli yere molemo.’ konopu lekolie lou-pulsema kinie kopema kinie mengo okomeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ulke tembele kerepulune alieli eno pea molemolo kinie na ambolko likuka naa silimele kanumu. Nalo kinié iena wendo okomomo Pulu Yemone ou ‘Enonga.’ nirimu enamo wendo okomo. Sumbulu tolimunge tondolomo kinie olandopa pelemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kanu kinie enone Yesusi ka sikulie Pulu Yemo popo tondoringi ye awili olandopamonga ulkena sukundu mengo puringi. Yesusi mengo puringi kinie Pita lombili akilipe taka lipe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yesusi mengo oringi ulke kanumunge ulke angilipe makapu terimu, suku we lierimune tepe kalko pilku moloringine Pita pupe eno kinie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yu akunemolopili ⸤Pulu Yemo popo tondoringi ye awili olandopamonga⸥ kendemande ambo te omba tepe nomba paterimune Pita molorumu kanopalie yu neme-neme nimbe kanopalie nimbendo: “I yemo Yesusi pea moloringili kanorundu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nalo Pitane kolo topalie nimbendo: “Ambomo, aku nikinu yemo na naa kanolio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Laye pe mele ye te Pita kanopalie yundu nimbendo: “Nu Yesusinge talape ye te lepamo.” nirimu kinie Pitane yundu nimbendo: “Yemo, na akumu molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pe ena mongo telu mele omba purumu kinie yembo te ⸤Pita yu ungu laye lupe mele nirimu mele pilkulie⸥ yuni tondolo mundupelie nimbendo: “Kolea Gallilli disiriki yembomane ungu nilimele mele yu aku sipe ungu nikimu pilkiru. ⸤Yesusi kinie yu lombili andoli yema kinie kolea Gallilli disiriki yemala,⸥ yu kepe Gallilli ye te, aku kene ‘Yu paa sike Yesusi lombili andoli ye te.’ konopu lekero.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aku nirimu kinie Pitane yundu nimbendo: “Yemo, nu nikinu mele na paa naa pilkiru.” nirimu. Aku sipe nimbe molopili kera gulta ko torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kanu kinie Yesusini topele topa Pita kanorumu kinie Yesusini yundu “Kera gulta ou ko naa topili nuni wale yepoko kolo tokolie “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pilipelie ⸤‘Ama, paatepo kenjendu lepamo. ‘Paa naa tembo.’ konopu lierindu mele sike tendu.’ nimbe pilipelie⸥ pena pupe kolapaa awili tepa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kanu kinie Yesusi akune nokoko moloringi ele yemane yu ungu taka tondoko, yu larauwe toko, teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yunge kumbikeremo múlu tene pipi sindikulie ki lumuni toko ⸤“Nu ‘Pulu Yemonga yere molio.’ konopu leno kene⸥ nawene nu tokomonje ningu si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ungu taka tondongendo enone yu aku mele ulu awisili teko ungu awisili ningu yu aku siku teko kenjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kolea tangorumu kinie Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, kanu Juda yembomanga tapu ye kanjolloma pali ‘Yesusinge kote piliemili.’ niringi. ⸤Enonga ele yemane⸥ yu eno liku maku toko moloringine mengo puringi kinie enone yundu ningendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Pulu Yemone olio “Nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu sike nu molo moloye? Ningu si.” niringi. Yuni enondo nimbendo: “ “Na akumu molio.” nilkenje enone naa pilku “Kolo tokono.” nilimela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nane enondo ungu te walsipu pilkenje yando ungu te naa lanilimela. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nalo Manie Omba Mana Ye A Lierimu Yemo kinié kepe pe-pe kepe tondolo pali pelemo Pulu Yemo ⸤kinie melema nokombando⸥ yunge ki-umbukundu molomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Enone pali yundu ningendo: “Nu “Pulu Yemonga Malo molio.” ningu nikinuye?” niringi kinie yuni nimbendo: “Akumu na.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Enone ningendo: “Yuni mongo lsimu mele nimbe simbe yembo te pea nambemune koromoloye? Yuni yuyu nimbe kenjikimu pilkimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aku ningulie Juda yembomanga ye awilime pali eno ola angilku Yesusi liku mengo puku ⸤Romo gapomano ye nomi⸥ Paillate molorumune mengo puku kote tenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yu kote tendekolie Paillatendo ningendo: “I yemone nimbendo: “Romo gapomanomone olio Juda yemboma naa nokopili.” nimbe, “Romo Gapomano Ye Paa Awili Kumbine Sisamo kou takisi naa tangi.” nimbe, “Yu yuyu “Pulu Yemone olio nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye Kirasimu, ye nomi kingimu molio.” nimbe molemomo olio pilipu kanolemolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eno aku siku niringi kinie pilipelie Paillatene ⸤Yesusinge kotemo⸥ yu walsipe pilipelie nimbendo: “Nu Juda yembomanga ye nomi kingimu molo moloye?” nirimu. Yesusini topondopa nimbendo: “Sike nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yuni aku nirimu kinie pilipelie Paillatene Pulu Yemo popo tondoringi ye awilime kinie, we yemboma akune liku maku toringime kinie, enondo nimbendo: “I yemo ulu te naa tepa kenjemu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nalo enone karaye teko tondolo munduku ningendo: “Yuni ungu mane sipelie “We yemboma ulu teko kenjiku, mongo liku teangi.” nimbe mane sirimu. Yuni ou-pulu-pulu kolea Gallilli disiriki ungu akumu mane sipe, pe yandopa kolea Judia disiriki koleama pali silipe andopalie, pe kamu ya kolea awili Jerusalleme omba ungu akumu mane sipe molemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Kolea Gallilli” niringi kinie pilipelie Paillatene enondo walsipe pilipelie nimbendo: “I yemo yu Gallilli ye teye?” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","enone “E.” niringi pilipelie yuni nimbendo: “⸤Ye nomi kingi⸥ Erote, Gallilli disiriki nokoli yemo, Yesusinge kotemo yuni piliepili yu molemona mengo paa.” nirimu. Aku walemonga kanu ⸤ye nomi kingi⸥ Erote yu Jerusalleme omba molorumu kulu pilipelie, “Yu molemona mengo paa.” nirimu. ⸤Paillate yu Jerusalleme lierimu kolea Judia disiriki nokorumu yemo.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erote ⸤molorumune mengo puringi kinie⸥ yu Yesusi kanopalie konopu sirimu. Yu Yesusini ulu terimu mele ungu awisili pilipelie, ‘Kanu yemo kanamboa!’ nimbe molopa, ‘Yuni ulu tondolo te tepili kanamboa!’ konopu lepa molorumu kulu yu orumu kinie kanopa konopu sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Akumunge Erote Yesusi ungu awisili walsipe pilierimu nalo Yesusini ungu te topondopa naa nimbe we molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pulu Yemo popo tondoringi ye awilime kinie, Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie, akune angilkulie enone Erotendo ningendo: “Yesusini isipe ungu nimbe kenjipe, isipe ulu awisili tepa kenjipe molemo.” ningu tondolo munduku niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kanu kinie Erote kinie yunge ami yema kinie enone ‘Yesusi yu ye nomi molo, yu we yere.’ ningu ye nomimene pakolemele mulumbale komindi te liku pakondoko, yu ungu taka tondoko tawe teringi. Kanu kinie Paillate molorumune Erotene Yesusi lipe yando mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Paillatene Erote molorumune Yesusi ou naa lipe mundopili Paillate kinie Erote elo opa pulue moloringili. Nalo Yesusi aku teringili walemonga pe elo angenungulu mele moloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesusi Paillate molorumune yando mengo oringi kinie Paillatene Pulu Yemo popo tondoringi ye awilime kinie, Juda yembomanga tapu yema kinie, we yemboma kinie, enondo “Waa.” nimbelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Enone “I yemone yembomando ‘Romo gapomanomo olio naa nokopili.’ nimbe ‘Eno mongo liku teangi.’ nimbe molemo.” ningu na moliona mengo ongi. Kanu kinie enokanoko molangi nane kote pilipulie enone ‘Yu tepa kenjerimu.’ ningi mele na ulu te naa pilkiru. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","⸤Gallilli disiriki ye nomi kingi⸥ Erote, yu pea iyemo ulu te tepa kenjerimu te naa lapilipelie yu altopa yando mundomu. Pilkimiliye? Yu ulu te tepa naa kenjemu. Yu we nambemune topo kondomoloye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ulu te tepa naa kenjemumunge nane yu we kopene topolie “Kelko pu.” niembo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","(Kolea awili Jerusalleme sukundu ye te, yunge imbi Barapasi, ⸤yu kinie ye mare kinie⸥ ‘Romo gapomanomone olio Juda yemboma naa nokopili.’ ningu ou Romo gapomanomo kinie opa tekolie yembo mare toko kondoringimunge yu ka siringi. ⸤Romo gapomano ka ulkena kanu ye Barapasi we pepili Juda ye awilimene Yesusi kote tenderingi⸥. Juda yembomane ponie tenga tenga kolea awili Jerusalleme ongo akune suku Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilieringi walemo wendo orumu kinie Romo gapomano ye awilimuni ka ye te ka ulkena wendo lipe mundupe “Pu.” nirimu.) ⸤Aku sipe terimu mele pilieringimunge Paillatene “Yesusindu “Pu.” niembo.” nirimu kinie pilkulie⸥ enone pali yundu tondolo mundukulie ningendo: “I yemo molo. Yu ⸤kolopili⸥ mengo pukulie, Barapasi, ⸤ka ulkena⸥ wendo liku si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paillatene ‘Yesusi we pupili.’ nimbelie enondo ungu te pea nirimu ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","nalo enone yundu wale awisili tondolo munduku ningendo: “Yu kolopili unjo perana uku toko panjei!” ningu moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aku niringi kinie yuni enondo altopa wale yepoko sipe walsipelie nimbendo: “Aku nambemuneye? Yu mongo nambolka mongore limuye? Yu ulu te tepa naa kenjemu. Yu we nambemune topo kondomoloye? Nane yu we kopene topolie “Kelko pu.” niembo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nalo enone karaye teko ungu tondolo mundukulie ningendo: “Yu kolopili unjo perana uku toko panjei!” niringi kinie enone tondolo munduku niringi mele pilipelie Paillatene eno niringi mele temba terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanu kinie Paillatene kote pilipelie enone yu-kinie “Paa tei.” ningu karaye teko mawa teringi mele ‘Aku sipe tepili.’ nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","⸤ye Barapasi,⸥ ‘Romo gapomanomone olio Juda yemboma naa nokopili.’ nimbe ou Romo gapomanomo kinie opa tepalie yembo mare topa kondorumumunge ka ulkena perimu kanu yemo, wendo lipe eno sipelie nirimumuni, pe enone ‘Yesusi kolopili.’ niringi mele pilipelie “Yu toko kondangi.” nimbe ami yema sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","⸤Romo ami yemane⸥ Yesusi mengo punge pukulie niringimuni, kolea Sairini ye te, yunge imbi Saimono, yu Jerusalleme pumbe orumu kinie kanoko yu ambolko liku ka mele siku Yesusi kolomba unjo peramo liku pendekona ola nosindikulie “I mu mendeko yu lombili akiliku pu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yembo awisili yu lombili puringi. Ambo mare yu tongemonga kola teliku puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kanu kinie Yesusini topele topa kanu ambomando nimbendo: “Jerusalleme amboma, eno na kolombomonga pilkulie kola naa teangi. Eno enono kinie enonga ambolangoma kinie ulu pe wendo ombámonga pilkulie kola teangi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aku sipu nikirumu, nambemune nikiruye? Niembo: Walse eno Jerusalleme yemboma mongo simbe walemo wendo ombá kinie eno kinie enonga ambolangoma kinie mindili nonge kinie yembomane ningendo: “Ambo ambolango te naa mengo, ambolango ame naa siku, waengono molemele amboma, enonga ambolango te mindili nomba eno naa kanongemonga eno malo.” ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pe ‘yembomane kelko mulu awili polemomando “Ma ange topa olio topili.” ningu, ma pangimendo “Ma ange topa olio aki topili.” ninge.’” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","⸤Nimbelie pe kamu ungu iko te topa enondo nimbendo:⸥ “Unjo konde angilimomo peke tokomele. Pe unjo kololimu nambe-engeye? Akumunge ⸤enone eno akusiku umbune singe, mindili nonge⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye talo pea ‘Yesusi kinie kolangi.’ ningu unjona ola uku toko panjingendo mengo puringi. Aku yeselo mongo lsingili yeselo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kolea ‘Penge Ombele’ niline oringi kinie yu kinie mongo lsingili yeselo kinie unjo pera yepokonga ola uku toko panjeringi. Mongo lsingili yeselonga te Yesusi yunge ki-umbukundu uku toko, te Yesusi yunge ki-tarokondo uku toko panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aku teringi kinie Yesusini nimbendo: “Tata, na-kinie tekemele mele tekemele yembomane naa pilkimili kene nuni tekemelemonga mongo naa siku siye kolou.” nirimu. ⸤Aku tekolie, ou unjona ola uku toko naa panjikulie⸥ yunge mulumbale ⸤kulunduku noseringime⸥ ‘Moke teamili.’ ningu eno yu mele mele linge mele pilingendo kou-kate teko pe mulumbalema lsingi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","We yemboma enone yu teringi mele kanoko we angilieringi nalo enonga ye awilimene yundu ungu taka tondoko ningendo: “Yu yembo wema ‘Naa kolko konde pangi.’ nimbe lipe tapondorumu mele kinié yuni ‘Naa kolopo unjo perana wendo pambo.’ nimbe yu yuyu lipe tapondopa unjo perana wendo opili. Yu sike Pulu Yemone mako topa olio ‘Nokopa kondopili.’ nimbe lipe mundorumu ye nomi Kirasimu omba molomu liemo kinié yu yuyu aku sipe lipe tapondopili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ami yema pea yu ungu taka tondoko molkolie no waene kombili teli te ‘Nopili siemili.’ ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yundu ningendo: “Nu Juda yembomanga ye nomi kingi molonu liemo ‘Naa kolambo.’ ningu nu nunu liku tapondou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","‘Yu mongo lsimu mele yemboma kanangi.’ ningu IYEMO JUDA YEMBOMANGA YE NOMI KINGIMU ningu imbi toko unjona ola mondoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mongo lsingili yeselo unjo perana ola uku toko panjeringi yeselonga tene Yesusindu ungu-taka tondopalie nimbendo: “Nuni “Pulu Yemone mako topa olio ‘Nokopa kondopili.’ nimbe lipe mundorumu ye nomi Kirasimu ⸤molio.” nilino mele sike molo moloye? Sike aku siku⸥ moleno liemo nu kinie olto kinie pea ‘Naa kolamili.’ ningu liku tapondoko unjo perana wendo li.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nalo mongo lsingili yeselonga tene yuni nirimu mele pilipelie yu iri topalie nimbendo: “Nu kinie yu kinie mongo telu siku mele singimunge Pulu Yemo pipili naa kolkonoye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu kinie olto tepo kenjerimbulumunge mongo papu singi. Nalo iyemo yu mongo te naa lsimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aku nimbelie yuni ⸤Yesusindu⸥ nimbendo: “Yesusi, nuye nomi kingimu molko melema nokokolie ninimuni, na konopu liku mundou.” nirimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesusini topondopa yundu nimbendo: “Nane nundu paa sike nimbu sikirumu: Kinié nu na-kinie pea Yemboma Molko Kondolemele Kolea Peangana pupu molombolo lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yesusi unjo perana ola we pepili awi-tangoli ena tuwellepo killoko terimu kinie kolea pali sumbulu topalie pe ipupene ena tere killoko kinie ena kelepa topa kolea tangorumu. ⸤Ulu awili te walsikele wendo orumula. Pulu Yemo popo toko kaloringi⸥ ulke tembele ⸤Jerusalleme suku angilierimu akune sukundu Pulu Yemo molorumu⸥ suluminia paa kake telimunge kerepulune ⸤‘Yemboma sukundu naa pangi.’ ningu ou alieli⸥ mulumbale awili tene pipi siku panjeringi angilierimu. Kanu mulumbalemo awi-suku-singine olá torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesusini ungu te tondolo mundupe nimbendo: “Tata, nanga minimu ‘Nu molenona opili.’ nimbu nu sikiru.” nirimu. Aku nimbelie yu kolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","⸤Romo⸥ ami ye wane anderete nokorumu ye te Yesusi toringi ami yema nokopa molorumu kanu yemone Yesusi ungu te nimbe kolorumu mele pilipe kanopalie yuni Pulu Yemo kapi nimbelie nimbendo: “I yemo yu paasike ye konopu sumbi nili te lepamo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kanu kinie ‘Yu unjo perana uku toko panjinge kanomolo.’ ningu ou liku maku toringi yemboma yu terimu mele kanoko bulu-balu ningu ungu awisili konopu liku munduku kondo kololiku ulkendo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yu-kinie ou tapu toko andoringi yema kinie, kolea Gallilli disiriki munduku siye kolko yu lombili andoko ⸤Jerusalleme⸥ pea oringi amboma kinie enone ⸤yu toringi kolorumu mele⸥ sulu teko kanoko angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yesusi kolorumu kinie ye te, yunge imbi Josepo, yu Juda yembomanga kanjollo ye awili te molopa, ulu peangama manjipe tepa molorumu. Yu konopu sumbi nili ye te, kolea Judia disiriki Arimatia taono yemo. Yu ‘Pulu Yemo ye nomi kingimu molopa olio nokomba walemo wendo opili.’ nimbe nokopa molorumu yemo. Yu Juda yembomanga kanjollomo sike molorumu, nalo kanjollo yemane ⸤ou eno enono kote pilkulie⸥ “Yesusi kolopili.” niringi kinie yuni “E.” naa nimbe we molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kanu yemone ⸤Romo gapomano ye nomi⸥ Paillate molorumune pupelie “Yesusinge onomo na si.” nimbe mawa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paillatene “Kapola.” nirimu kinie Josepo pupe onomo manie lipe, mulu konde tene lipe kulupi topalie, kou kande tenga memba pupe suku noserimu. Kanu kou kandena yembo ono te ou naa noseringi, yu mindi pulu-pulu noserimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yesusi ono terimu walemo yu kinié mele, opali mele ⸤Juda yembomanga koro moloringi⸥ wale Sambatemo nondopa wendo ombá terimu. Sambate walemo wendo ombá kinie koro molongendo kinié mele, melema liku undu-undu siringi walemo wendo orumu, akuwalemonga Yesusi ono teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ou Yesusi kinie kolea Gallilli disiriki munduku siye kolko yu pea ⸤Jerusalleme⸥ oringi amboma Josepone Yesusi ono terimu kou-kandemo kanoko akune suku onomo noserimu mele neme-neme ningu kanokolie niringimuni, ");
INSERT INTO ubu_kala_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","pe kanoko pora sikulie yando ongo, ‘Yunge onona kopongo-welema kinie mele lupe mune tolime kinie kandondamili.’ ningu teko mimi teringi. Nalo Sambate walemo wendo orumu kinie Pulu Yemonga ungu manemone ‘Sambate wale kinie koro molangi.’ nirimu mele pilku likulie mele teko mimi teringi melema sumbi siku ono koleana naa mengo pukulie we nosiku koro moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","⸤Juda yembomanga koro moloringi⸥ wale Sambatemo pora nimbe, enonga pulu-pulu kongono walemo wendo ombando kolea tangomba muni lierimu kinie amboma kopongo mune toli ou teko noseringime liku mengo puku, ⸤Yesusinge⸥ onomo noseringi kou kandena meli puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Akune pukulie kou-kande kerepulumu pipi siringi koumu perele-marele pupe welkendo lierimu kanokolie, ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","suku puringi kinie akune Ye Awili Yesusinge onomo ou lierimune naa lierimu kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanu kinie ‘Onomo nambe-emunje?’ ningu konopu liku munduku moloringi kinie ye talo kariapá tepalie patelemo mele teli wale-pakoli pakoringili yeselo eno moloringine angilieringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kanokolie amboma mini-wale munduku tamalu peringi kinie yeselone enondo ningelendo: “Konde molemomo, ya ono koleana nambemune korokomeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yu ya naa lemo. Lomboropa ola molopa wendo pumu.” ⸤niringili.⸥ “Yu ⸤eno kinie⸥ kolea Gallilli molopa enondo nirimu mele pilieyo. Yuni nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“⸤Juda yembomanga ye awilimene⸥ Manie Omba Mana Ye A Lierimu Yemo liku talape lupe yembo ulu pulu keri telime yu liku singe, enone yu unjo perana kolopili uku toko panjinge kinie kolopalie wale yepoko sipemonga lomboropa ola molomba.” nirimu kanumu.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kanu kinie Yesusini ou aku nirimu mele ambomane altoko pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kou-kandemo munduku siye kolko kelko yando ongolie niringimuni, lombili andoli rureponga yepoko kinie akume pea moloringi yemboma kinie enondo pilku kanoringi mele temane toko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kolea Makatalla ambo Maria keme, ambo Joana keme, Jemisi anumu Maria keme, eno pea puringi amboma keme, kanu ambomane Yesusini ou “Nanga kongonomo tende-paa.” nimbe lipe mundorumu yerureponga yepoko aku temanemo toko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nalo ambomane niringi ungumu pilkulie ‘Eno kolo tokomele.’ ningu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aku ningu pilieringi nalo Pita ola angilipe ono noseringi kou-kandena lkisipe pupelie, wake tepa kanopa Yesusinge onomo kulupi toringi múlume yuyu akune we lierimu kanopalie konopu awisili lipe mundupe ‘Inambolka uluri temunje?’ nimbe pilipe yando orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yesusi lomboropa ola molorumu aku walemonga ⸤yu lombili andoringimenga⸥ yembo talo kolea kanga Emeasi pungele puringili. Aku kolea kangamo kinie kolea awili Jerusalleme kinie aulkemo laye sulu mele, illepene killomita mele. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Elone Yesusi kolorumumundu anjo yando ungu mele teliku puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aulkena aku ulumendo ungu mele teliku pangili Yesusi yuyu elo puringiline omba elo kinie tapu topa purumu, ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","nalo Yesusi yu ‘We ye lupere okomo konopu leangili.’ nimbelie terimu, elone yu naa kanoko imbi siringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yuni elo walsipelie nimbendo: “Elo nambolkamondo ungu mele teliku pukumbiliye?” nirimu. Elo Yesusi toringi kolorumumunge nono ningu we angilieringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tenga imbi Killopasi, akumuni yundu walsipelie nimbendo: “Jerusalleme sukundu talko ulu wendo orumume nu naa kanorunuye? Yembo awisili akune ongo maku tokolie kanoringi nalo nu pea naa molko kanoringi. Tenga lupe molkolie okono lepamo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Orumu yemone “Nambolka ulumeye?” nirimu. Elone ningelendo: “Kolea Nasarete ye Yesusinge ulu kanume.” niringili. “Yesusi yu Pulu Yemone ungu umbu tondolime pilipe yando nimbe sili ye te molopalie Pulu Yemo kinie olio mana yemboma kinie kanopo molamili ungu tondoloma nimbe ulu tondoloma terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanu kinie olionga ningu Pulu Yemo popo tondoli ye awilime kinie olio nokolemele ye awilime kinie ‘Yu kote pilku “Kolopili.” ningu tangi.’ ningu ⸤Romo gapomano yema⸥ anjo siringi enone ‘Yu kolopili.’ ningu unjo perana uku toko panjeringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nalo olio pilierimulu, ‘Yu Pulu Yemone lipe mundorumu, ⸤Romo gapomano yembomane olio⸥ Isirele yemboma ⸤tondolo munduku nokolemelemonga⸥ mindili nombo umbune tepili molemolomonga olio lipe tapondopa ⸤enonga kíne⸥ wendo lipe ‘Molko kondangi.’ nimbe ⸤kolo wangopa⸥ olionga ye nomi kingimu molopa olio nokopa kondomba.’ nimbu pilipu konopu sipu molorumulu nalo yu toringi. Akumunge ungu te pea i-sipe: Talko toringi, kinié wale yepoko sipe mele omba pukumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Pe kinié ulu te lupe wendo omula. Yu lombili andorumulumenga ambo pokore kinié ongo ningi mele pilipulie mini-wale mundomulu. Kinié paa ipulueli-ou kanu amboma yu ono teringi kou-kandena puku kanongi nalo yunge onomo naa liemu. Eno ongo oliondo ningendo: “Mulu koleana angello talo kanomulu, elone “Yu wemolemo.” ningili.” ningi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanu kinie olio pea molomulu ye talo ono kou-kandena pukululie ambomane ningi mele kanongili, nalo yu naa kanongili.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aku niringili kinie elo lombili akilipe orumu yemoneelondo nimbendo: “Elo aroma topambele. Elo konopu naa pelemomonga ou Pulu Yemone ungu umbu tondoringime pilku yemboma ningu siringi yemane yundu niringi bokune molemo mele mongone kanoko komuni pilkululie konopune liku mengo andolembelanje ⸤Yesusi kinie talko teringi mele kinie yuni terimu tekemo mele kinie⸥ kamu-kumu pilimbelá lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu manie ombalie, ya ye nikimbilimu talko mindili norumu mele mindili nomba mulu koleana ye nomi awili pupe molomba mele ou ningu naa siringiye? Ningu siringi kanumu. Pe kinié ou ningu siringi mele yu aku temu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aku nimbelie Mosisini Yesusi yu yuyu temba mele ou boku marenga topa nirimu mele pulu polopa nimbe sipe, yandopa yandopa Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemane yu temba mele ou boku marenga toko niringi mele nimbe sipe, aku Pulu Yemonga bokumuni nilimo mele pali nimbe silipe yemboselo kinie aulkena purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yemboselo puringili koleamo nondoko wendo oringi kinie Yesusi we sumbi sipe tenga lupe pumbe terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nalo elone karaye tekolie ningelendo: “Molo. Ena pupe ipu nondopa lemba kene pea peamili.” niringili kulu yu elo-kinie pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kanu kinie elo pea kere nongo moloringi kinie yuni pillawa kaloli te lipe Pulu Yemo “Ange.” nimbe, ambolopa pike lepa elo sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aku terimu kinie elo yu kanokolo elonga Awili Yesusi ningu kanoringili kinie tepa nema lsimu altoko naa kanoringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kanu kinie elo elolo anjo yando kerepale ningulu ningelendo: “Aulkena olto kinie omba ungu nimbe Pulu Yemonga bokumuni nilimo mele ungu pulumu nimbe silipe omu kinie olto kamele kongulu topili ombulu kanumu. Awili Yesusi kinie ombulumunge aku temu lepamo.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kanu kinie elo ola angilku kelko sumbi siku Jerusalleme yando ongolo, lombili andoli ye rureponga yepoko kinie eno pea maku toko moloringi yembo lupema kinie moloringine puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Suku puringili kinie enone elondo ningendo: “Awilimu paa sike lomboropa ola molomu lemo. Yu yuyu Saimono molomune pupe mona angiliemu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kanu kinie yemboselone aulkena puringili kinie ye te omba nirimu mele kepe kanu yemone pillawa kaloli te ambolopa pike lierimu kinie kanokolo ‘Yu Yesusi.’ ningu kanoringili mele kepe enondo temane toko siringili. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","⸤Yesusi lombili andoli⸥ yembomane ⸤Yesusi yu lomboropa ola molorumu kanoringimundu⸥ ungu mele teko molangi Yesusi yu omba eno moloringine sumbi sipe angilipelie “Eno konopu pe nipili molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Eno ‘Yembo kololi tenga minimu kanokomolo.’ konopu lekolie pungu-pungu ningu pipili koloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yunienondo nimbendo: “Mini wale munduku konopu talo panjiku nambemune molemeleye?” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Nanga kiselo kinie kimbume kanoko ‘Imu na nanu.’ ningu kanayo. Ambolko pilieme. Nanga kangi kinie ombele kinie angilkimu mele minimenga aku sipe angilimoye? ⸤Aku sipe naa angilimo kanumu.⸥” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aku nimbelie yunge kimbu-ki pirimu toringime eno lipe ora sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kanu kinie eno yu kanokolie pondeanga konopu siku paakonopu liku mundoringi nalo ‘Sikenje molo nambolkare kanokomolonje?’ ningu konopu talo panjiku we moloringi kulu yuni eno mawa tepalie nimbendo: “Langi nombó te ya lemoye? Siee.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Enone yu oma kaloli te liku siringi, ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akumu lipe eno kanoko molangi norumu. ⸤‘Minimu naa molopo yembomo molkoro kanangi.’ nimbe aku terimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yuni enondo nimbendo: “Na ou naa kolopo eno kinie molopolie eno ulu wendo ombá mele nimbu sirindu kanu ulumu iwendo okomo. “Mosisi kinie Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema kinie enone nando ningu boku marenga toringi ulume kinie, Pulu Yemonga konana niringi bokune molemo konanamane nando nilimo ulume kinie, kanu ulume sike wendo ombá.” nirindu kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Aku nimbelie ‘Pulu Yemonga bokumuni nilimo mele pilku kondangi.’ nimbe yuni ungu pulumu eno nimbe sipelie nimbendo: “Bokune toringi molemo mele isipe: ‘Pulu Yemone “Eno nokopa kondomba ye te lipu mundumbo.” ou nimbe mako torumu ye nomi Kirasimu mindili nomba kolopalie wale yepoko sipemonga ono koleana lomboropa ola molomba. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aku temba kinie kanu ye Kirasimu yunge talape yembomane yunge tondolomone yemboma ulu pulu keri tengema pilku keri pilku konopu alowa tenge mele kinie, ulu pulu keri tengema Pulu Yemone siye kolopa altopa naa pilipe mongo naa simbe mele kinie, ningu singendo Isirele yembomanga kolea awili Jerusalleme pulu polko ningu siku koleamanga pali pukulie ningu siliku andonge.’, ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","aku mele nando ou ningu boku toringi. “Pe kinié nane terindu ulume kinie na kinie teringi ulume kinie kanoringi teringi kanokomelemonga yemboma manda ningu singe. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nalo we naa teangi. Pulu Yemone “Simbo.” nimbe nimbe panjerimu Minimu nane olando pupulie lipu mundumbo kene aku Mini Tondolomo yu mulu koleana manie omba ‘Eno tondolo pupili molangi.’ nimbe eno kinie molomba kene ou tenga lupe naa puku Jerusalleme suku we nokoko molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesusi yu lombili andoringi yemboma kolea kanga Betani lierimune nondopana memba pupelie nirimumuni, ‘Pulu Yemone eno sewe anjepili.’ nimbe yunge kiselo ola mundupe, “Pulu Yemone eno nokopa kondopa ‘Eno konopu enge nipili molangi.’ nipili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Enondo aku sipe nimbe molopili ⸤Pulu Yemone⸥ yu mulu koleana olando lsimu kinie eno mundupe siye kolopa mulu koleana olando purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kanu kinie enone ⸤Yesusi⸥ yu kapi ningu imbi liku ola mundundukulie kamele paa akoliku, Jerusallemendo kelko yando oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akune pukulie ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena taki-teki molko, Pulu Yemone terimumunge “Ange.” ningu yu kapi ningu yunge imbi liku ola mundundoringi. ⸤Yesusinge temane peanga ekendo topo pora sikiru.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Paa koronga-ou, ⸤mulu maselo kepe melte naa liepili,⸥ Ungumu molorumu. Aku Ungumu Pulu Yemo kinie moloringili. Aku Ungumu yu Pulu Yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paa koronga-ou, melte mana naa liepili, yu Pulu Yemo kinie moloringili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ungumu yuni yuyu melema pali terimu. Melte we pora naa purumu. Mele wendo orumume pali yuni terimu-ne wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mololi ulu pulumu yu-kinie mindi perimu. Kanu mololi ulu pulumu yembomanga patendelimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aku patelimuni sumbulu tolemomo patendelemo. Sumbulu tolemomone altopa patelimu manda pipi sipe sumbulu altopa naa tomba. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ye te orumumu Pulu Yemone lipe mundorumu-ne orumu, yunge imbi Jono. ⸤Yu No Lindeli Jono kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jonone patendelimunge pulumu nimbe simbe orumu. ‘Yembomane “Nondopa ombá yemo yu sike aku patendelimu.” ningu tondolo munduku piliengi!’ nimbe omba nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jono yu aku patendelimu molo. Yu aku patendelimu ombá mele nimbe simbe orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jonone yemboma ungu nimbe sipe molopili paa sike patendelimuni yemboma pali patendelemo kanumu mana ombá orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yu ma koleana omba molorumu. Yuni yuyu ma koleamo terimu nalo ma koleana yembomane yu kanokolie ‘Yu ma kolea terimu Pulu Yemo.’ ningu naa kanoko ‘Yuwe mana ye te.’ ningu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yu yunge koleana omba molorumu nalo yunge yembomane “Nu olionga Awilimu okono kene olio ongo nokoko molou.” ninaa niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nalo yundu “Nu sike ⸤Pulu Yemone lipe mundorumu-ne orunu yemo kene⸥ olio nokani pea molamili ou.” ningu yunge ungume tondolo munduku pilku lsingi yemboma yuni “Pulu Yemonga ambolangoma molangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nalo kanu yemboma Pulu Yemonga ambolangoma a lieringi, aku ulumu kangimunge kongonomo molo. Anupili lapalini “Pulu Yemonga ambolangoma meamili.” ni naa niringila. Pulu Yemone yuyu mindi enondo “Nanga ambolangoma.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ungumu ⸤Pulu Yemo pea moloringilimu⸥ manie omba mana ye a lepa olio kinie pea wale wallo-kolte molorumu. Yu mana omba molorumu kinie neme-neme nimbu kanopolie, yu ye paa peanga, imbi molemo ye tondolomo, kanopo pilierimulu. Kanu ye paa peanga tondolomo Malo telu molorumumu Lapa molorumune yu pea molkololie mana manie orumumunge yu ye paa peanga lepa imbi paa ola mololi ye tondolomo mindi kanopo pilierimulu. Yu kondo kololi ulu pulumu kinie sike nili ulu pulumu kinie yunge konopune pepa tengepea terimu yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","⸤Jono yemboma no lindipe molopili Yesusi Pulu Yemonga Ungumu orumu kinie⸥ Jono yuni yemboma kanu yemo lipe ora sipe yu molorumu mele nimbe sirimu. Yuni ru nimbelie nimbendo: “I yemo nane enondo ou “Nondopa ombá.” nimbu sirindu kanu yemo imu. Na naa molambo iyemo yu koronga-ou Pulu Yemo kinie molorumu kulu “Yu ye nomi awilimu na paa we koropamo.” nirindu kanu yemo imu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yuni olio we kondo kolemo ulu pulumu yu-kinie pelemomonga yuni olio alieli kondo kolopa mindi molopa olio ‘Konopu waengo siengi.’ nimbe taki-teki sewe anjilimo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosisini olio Pulu Yemonga ungu mane sirimume mindili sipu tepo molorumulu. Nalo olio we kondo kololi ulu pulumu kinie sike ungume kinie aku ulume Yesusi Kirasi yu-kinie mindi pepili orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana yembo tene ou kepe, kinié kepe, Pulu Yemo naa kanolemele. Pulu Yemonga Malo telu mindi molemo, akumu Lapa kinie pea tapu toko molembele, akumuni mindi ‘Pulu Yemo molemo mele kanangi.’ nimbe yu lipe ora sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda yemboma⸤nga ye awili⸥ kolea awili Jerusalleme moloringi ⸤kanu yemane⸥ Pulu Yemo popo tondoringi ye pokore kinie, LLipai ye pokore kinie Jono no lindipe molorumune liku mundukulie, “Jonondo “Nu naweye?” ningu walsiku piliengi paa.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Eno ongo yu walsiku pilieringi kinie yuni kolo naa topa sumbi sipe nimbelie nimbendo: “Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ nimbe mako torumu ye nomi Kirasimu na molo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Enone “Nu aku yemo molo liemo nu naweye? Nu Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Illainja, ⸤Pulu Yemone ou olando lsimu akumu⸥ nu kelko onuye?” ningu walsiku pilieringi. Yuni “Na akumu molo.” nirimu. Enone ningendo: “Aku liemo ‘Pulu Yemone ungu umbutondorumume pilipe yemboma nimbe simbe ye te peombá.’ ⸤ou niringi yemo⸥ nuye?” niringi. Yuni “Molo!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kanu kinie enone yundu ningendo: “Nu naweye? Olio liku mundongi yemane ‘Ongo ningu singe.’ ningu nokoko molemele kene nunge imbi leko si. Nunu nawe konopu lekenoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jonone nimbendo: “Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe sirimu ye Aisayane koronga-ou nimbendo: “Kolea ku lieline ye tene “Awilimunge ombá aulkemo sumbi sindei.” nikimu pilkiru.” nirimu. Aisayane kanu ou pilierimu ungumu nane kinié nikiru.” nimbe Jonone nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","⸤Kanjollomane⸥ mundoringi ongo moloringi yemanga Parisi ye mare moloringila. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aku Parisi yemane yundu walsiku pilkulie ningendo: “Nu ye nomi Kirasimu molola, Illainja molola, ‘Pulu Yemone ungu umbu tondorumume pilipe yemboma nimbe simbe ye te pe ombá.’ ou niringi yemo molola. Pe kinié nu nambemune yembo no lindilinoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonone enondo topondopa nimbendo: “Na sike nolindilio nalo nanga kongonomo manie. Ye te olionga koleana sukundu molemo akumu eno kanokolie ‘we yere’ konopu leko, kanoko imbi naa silimele, ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","akumu na lombili akili lepa okomo yemo. ⸤Yembo awilimenga kongono keri teli yembomane sike enonga awilimenga kongono keri tendengendo enonga kimbu-su ka pilke tokosu wendo lindilimele nalo⸥ iye na lombili akili lepa okomomonga kimbu-su ka pilke topo su wendo lindimbo kongonomo kepe paa olandopa mele, nane manda naa tendembo. Na ye paa keri mele; yu ye paa nomi awilimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iulu wendo orumume Betani taono, no Jodane nekendo lemo koleana, wendo orumu. Jonone akune yembo no linderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Opalikundu ⸤No Lindeli⸥ Jono molorumune Yesusi ombá orumu kanopalie nirimumuni, yembomando nimbendo: “Kaname! Pulu Yemonga Kongi Sipisipi Walomo okomo. Yu yembomanga pali ulu pulu keri teringi telemelema kulu tondolemo tondomba yemo okomo.” ⸤nirimu⸥. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Ou nane ye te nirindu kanumu andikomo ye akumundu nirindu. Ou nane nimbondo: “Yenalombili ombá ye te na naa molambo yu koronga-ou molorumu kulu yu olandopa na maniendopa.” nirindu kanumu iyemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na kepe yu naa kanorundu nalo ‘Isirele yemboma yu kanokolie piliengi lipu ora siembo.’ nimbu na ombo yemboma no lindilio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonone yundu ungu te pea nimbendo: “Yu no lindipu molopo kanondu kinie Mini ⸤Kake Telimu⸥ kera waembono mele mulu koleana maniendo omba yu molomune omba molomu kanondu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nane yu kanopolie yu imbi naa pilipu ‘Yu we yere.’ konopu lelka nalo nando “Yemboma no lindi-pou.” nimbe lipe mundorumu yemone na nimbe sipelie nimbendo: “Mini ⸤Kake Telimu⸥ manie omba ye tenga kangi tenga ola omba molomba kanoni kinie aku yemone yemboma Mini ⸤Kake Telimu⸥ lindimbe yemo.” nirimu kulu pilipulie yu kanopo imbi sipulie ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","enondo “Yu Pulu Yemonga Malo.” nilio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Opalikundu ⸤No Lindeli⸥ Jono no Jodane kelo akune altopa angilipelie nirimumuni, yu lombili andolimenga ye talo pea angilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kanu kinie Yesusi omba purumu kinie yuni kanopalie nimbendo: “Kanale! Pulu Yemonga Kongi Sipisipi Walomo omba pukumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yu lombili andoliselo yuni nirimumu pilkululie Yesusi lombili puringili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesusi topele topa elo yu lombili oringili kanopalie elondo nimbendo: “Nambolka korokombeleye?” nirimu. Elone yundu “Rapai, nu tena pelenoye?” niringili. (Rapainge ungu pulumu ‘Ungu Mane Silimu’.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yuni elondo “Kanangili wale.” nirimu. Elo yu perimune puku kanokololie ipupene po killoko mele terimu kulu kanu enamonga yu pea peringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ye talo Jonone nirimumu pilkululie Yesusi lombili puringili yeselonga te Enderu, Saimono Pitanga angenu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yu sumbi sipe pupe angenu Saimono koropa kanopa lendepalie yundu nimbendo: “Pulu Yemone “olio nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu ye nomi Mesayamo kanopo lendemulu.” nirimu. (‘Mesaya’ akumu Juda yembomanga ungu te. Mesayamondo Giriki ungune ‘Kirasimu’ nilimele.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aku nimbelie Enderuni angenu Saimono Yesusi molorumune meli purumu. Yesusini yu kanopalie nimbendo: “Nu Saimono, ‘Jono’ nili ye tenga malo. Nunge imbi te ‘Sipasi’ ningu lenge.” nirimu. (Sipasindu ‘Pita’ niringila. Juda yembomanga ungune ‘Sipasi’ ningu, Giriki ungune ‘Pita’ nilimele, aku unguselonga pulumu ‘kou mulu’.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Opalikundu Yesusi ‘Kolea Gallilli disiriki pambo.’ konopu lepa pumbe purumu. Pupelie Pillipu aulkena angilierimu kanopalie, “Na lombili ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pillipu kepe Besaida taono yemo, Enderu kinie Pitaselonga koleamo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pillipu Nataniele kanopa lendepalie yuni yundu nimbendo: “Mosisini boku torumu bokumenga ‘Ye te ombá.’ nimbe temane torumu kanu yemo kepe, Pulu Yemone ungu umbu tondorumume pilku yando ningu siringi yemane enonga bokumenga ‘Ye te ombá.’ ningu temane toringi kanu yemo kepe, kinié olio kanopo lendemulu. Yu Nasarete taono ye Yesusi, Josepo malo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nalo ‘Aku kolea kelóna ye awili te manda wendo naa ombá.’ nimbe pilipelie Natanielene Pillipundu nimbendo: “Nasarete taonona ulu peanga te manda wendo ombáye?” nirimu. Pillipuni Natanielendo nimbendo: “Ongo kanou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kanu kinie Nataniele ombá orumu kinie Yesusini kanopalie, yundu nimbendo: “I ye okomomo paa sike Isirele yemo, yu kolo toli ungu te paa naa pelemo yemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanielene Yesusindu nimbendo: “Nuni na nambeko kanoko imbi sikulie aku nikinuye?” nirimu. Yesusini topondopa nimbendo: “Molo. Pillipuni nu ou naa walsepili nu unjo piki pulune molonu kinie nu kanopo imbi sindu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aku nirimu kinie Natanielene tondolo mundupe nimbendo: “Rapai, nu Pulu Yemonga Malo, olio Isirele yembomanga ye nomi kingimu lepamo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesusini nimbendo: “Nane ‘Nu unjo piki pulune molonu kinie kanondu.’ nindu kanumunge nuni na ‘Pulu Yemonga Malo molemo.’ ningu pilkinuye? Kinié nane nundu nindu mele maniendopa. Pe ulu tondolo paa olandopama wendo ombá kanoni.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aku nimbelie Yesusini ungu te pea nimbendo: “Nane enondo paa sike nimbu sikirumu: Pe mulu koleana anjo yando pupe, Pulu Yemonga angelloma Manie Omba Mana Ye A Lierimu Yemo molombana olando puku maniendo ongo tenge kanonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wale yepoko sipemonga Kena taono, kolea Gallilli disiriki sukundu lierimu, akune ye te ambo limbendo langi koyopa yemboma simbe terimu, akune Yesusi anumu pea maku toko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesusi kinie yu lombili andolime kinie ference kanu ambo limbe yemone “Eno kepe langi pea namili waa.” nirimu kulu eno ongo langi pea noringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Langi nongo molangi no-waene pora nirimu kinie Yesusi anumuni Yesusi yundu nimbendo: “Enonga no-waene pora nimu-ne mini-wale mundukumili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusini yundu nimbendo: “Ambomo, nane ulu temboma nunge kongono te molo. Nane ungu tembo walemo ou wendo naa oli.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yunge anumuni ⸤ulke pulu yemonga⸥ kendemande yembomando nimbendo: “Yuni enondo “Teaa.” nimbé mele aku siku teaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juda yembomane no lengendo no kolko mondoringi ma-mingi awili talo pakera akune angilierimu. Mingimenga tenga tenga nimbe no wane anderete llita molo wane anderete teti llita mele manda molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusini ⸤ulke pulu yemonga⸥ kendemande yembomando nimbendo: “Mingi kanga marenga no puku kolkolie, andi mingi awili lemomanga munduku peko siee.” nirimu. Kanu kinie eno no kolko paa peko siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yuni enondo kelepa nimbendo: “Olama liku mundukulie langi nokoli yemo mengo puku siee.” nirimu. Kanu kinie mengo puku yu siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kanu langi nokoli yemone umbu nomo no waene alierimu naa kanopalie nomo we nomba pilierimu. Nalo kendemande no koloringimene nomo kanoko imbi siringi. Langi nokoli yemone nomba pilipelie ambo limbe yemondo “Ou.” nimbelie ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yundu nimbendo: “Yemane pali alieli nowaene peangamo ou sikulie, pe yembomane no awisili nongo pora siku altoko ko naa pilimele kinie no keri mele silimele. Nalo nuni no waene peangamo ou we nosikulie pe kinié sikinumu, ⸤paa papu sikinu⸥.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kolea Gallilli disiriki sukundu lierimu kolea Kena taonona Yesusini terimu ulu akumu pe yu molopa kongono terimu mele lipe ora sirimu ulu tondoloma tembando iulumu pulu pulu terimu. Aku sipe yu we yete molo, yu Pulu Yemonga tondolo peli yemo ‘eno kanangi.’ nimbe lipe ora sirimu. Kanu kinie yu lombili andolimene ‘Yu paa sike ⸤Pulu Yemone lipe mundorumu⸥.’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ye ambo limbemonga langi nongo pora sikulie Yesusi kinie anumu kinie angenupili keme lombili andolime keme Kapeniame taonondo pukulie, akune walepokore moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda yembomane ponie tenga tenga kolea awili Jerusalleme ongo akune suku Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilieringi walema nondopa wendo ombá terimu kinie Yesusi Kapeniame taono mundupe siye kolopa kolea awili Jerusalleme olando purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","⸤Pulu Yemo popo toko kaloringi⸥ ulke tembele akune sukundu pupe kanorumu kinie kongi pirimu kao kondema kinie kongi sipisipi kondema kinie kera waembono kondema kinie kou mone liku bisinete teringi yemboma kepe, kou mone alowa teringi yemboma kepe akune sukundu aku teko moloringi kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanopa keri kanopalie nirimumuni, ka mare lipe lakopalie kanu ka-pulsemone kongime pali ulke tembelena topa makoropa pena pena tepa, kou alowa teringi yembomanga kou mone walena perimume lipe ondolepa enonga kou noseringi poloma lipe topele topalie, ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","kera mondoko bisinete teringi yembomando nimbendo: “I Tatanga ulkena bisinete naa teko imelema wendo liku mengo pame! I Tatanga ulkemo sitoamoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yuni aku terimumu yu lombili andolimene kanokolie enone ungu te Pulu Yemonga bokune sukundu nimbe molemomo konopuni pilieringi. Aku ungumuni nimbendo: “Na paa mindili sipulie nunge ulkemo ‘Angilipe peanga tepili.’ nimbu nokopo molio.” nimbe molemo kanu ungumu konopuni pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kanu kinie yuni terimumu Juda ⸤ye awili⸥ mene kanokolie yundu ningendo: “Nu namba nambolka nambare likulie aku siku tekenoye? ‘Lipu ora siembo.’ ningu Pulu Yemone “Tei.” nimu liemo Pulu Yemone telemo mele ulu tondolo te olio kanamili tei.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesusini enondo topondopa nimbendo: “Enone iulke tembelemo tekisinge kinie nane wale talo takopo yepoko sipemonga takopo limbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nirimu mele Juda ⸤ye awili⸥ mene pilkulie ningendo: “I ulke tembelemo ponie paono talo omba pupe kelepa ponie talo pakera omba purumu kinie takoko lsingi kanumu. Pe nuni “Wale talo takopo yepoko sipemonga takopo limbo.” nikinuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nalo yuni “ulke tembelemo” nirimu akumu yunge kangimundu nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanu kinie pe Yesusi kolopa wale talo ono koleana pepa yepoko sipemonga lomboropa ola molorumu kinie yulombili andolimene yuni ou ulke tembelemondo nirimu mele kelko pilieringi. Pilkulie Pulu Yemonga bokune ⸤Yesusindu⸥ nimbe molorumu ungumu kinie Yesusini nirimu ungumu kinie ‘Sike.’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pulu Yemone Juda yembomanga anda-kolepalime Naa Topa We Omba Purumu mele pilieringi walemanga Yesusi Jerusalleme molopalie yembomane yuni yu molopa kongono terimu mele lipe ora sirimu ulu tondolo terimume kanokolie ‘Yu sike Pulu Yemone ‘Eno nokopa kondomba ye te lipu mundumbo.’ nimbe mako torumu yemo omba molemo.’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Nalo Yesusini yemboma pali teko moloringi mele pilipe kelepalie ulume pali yembo tene yu lipe ora sipe naa nipili yu yuyu pilipe molorumu. Enone ningu pilieringi mele yuni konopuni pilipelie, ⸤‘We ningu pilimele. Sike kinié aku siku ningu pilimele nalo opali kepe talou kepe konopu alowa tekolie na ‘Tamili.’ ningu pilinge.’ nimbe pilipelie,⸥ ‘Eno kinie we walu sipu molambo.’ ni naa nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","⸤Juda yembomanga ye mare Parisi moloringi. Aku⸥ ye Parisimenga ye te, imbi ‘Nikodimasi’, yu Juda yemboma nokorumu kanjollo ye te, ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yu Yesusi molorumune ipulueli ombalie nirimumuni, yundu nimbendo: “Rapai, ‘Nu Pulu Yemo pea molkololie ungu mane sinindu orunu.’ nimbu pilimolo. Ye te ‘Pulu Yemo kinie naa molkanje Pulu Yemone ulu tondoloma telemo mele nuni teleno aku sipe yuni manda naa telka. Ulu telenomane Pulu Yemo pea molembele mele lipe ora silimo.’ nimbu pilimolo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesusini topondopa yundu nimbendo: “Nane nundu paa sike nimbu sikirumu: Yembore kelko naa mengi liemo kanu yembomone Pulu Yemone ye nomi kingimu molopa yemboma nokolemo koleamo manda naa kanopa yunge talapena manda naa molomba.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimasini yundu nimbendo: “Yembo te anda lepa molemo kinie yu nambeko mengeye? Yu anumunge olona altopa manda suku pumbe, yuni yu manda membaye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesusini topondopa nimbendo: “Nane nu paa sike nimbu sikirumu: Yembo te nomone kepe Minimuni kepe mei naa mengili liemo kanu yembomo Pulu Yemonga ambolango naa molopa Pulu Yemo ye nomi kingi molopa nokolemo koleana suku manda naa pumbe, molo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Méle kangimuni melemó méle akumu kangimu, yu mana molomba mélemo mindi; méle Pulu Yemonga Minimuni melemó méle akumu minimu, aku mélemo mindi Pulu Yemo molemona manda pupe molomba. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Akumunge nane nundu nimbondo: “‘Pulu Yemo yenomi kingimu molopa nokolemo koleana pamili.’ ninge yemboma pali ou altoko meangi.” nikirumundu konopu awisili naa lieyo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poporomemo yuyu pilipe kolea lupe lupemanga tolemo kinie enone yunge ungumu pilku, melema lope lape telemo kanolemele, nalo yu naa kanoko yu wendo olemona kepe pulimona kepe naa kanolemele. Pulu Yemonga Minimu aku sipela. Minimuni melemó yemboma mini konde pepili eno paa yembo lupe méle molemele yembomane kanolemele, nalo ⸤Pulu Yemonga⸥ Minimuni kanu yemboma mini kondema silimo kanu Minimu naa kanolemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimasini yundu nimbendo: “I ulume nambepa wendo okomoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesusini yundu nimbendo: “Nu Isirele yembomanga ungu mane sili ye te nalo inikiru mele naa pilkinu lepamo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nane nundu paa sike nimbu sikirumu: Olio pilimolomando nilimolo; kanolemolomando nimbu silimolo. Nalo iungu nilimolo ungume enone pali pilku limele yembo te molo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya ma koleana ulume eno nimbu silio kinie enone ‘Kolo tokomonje.’ ningu pilimelemonga pe kinié mulu koleana ulume nimbu sindu liemo ‘Sike nikimu.’ ningu nambeko manda tondolo munduku pilingeye? Manda naa pilinge lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yembo telu kepe olando siku mulu koleana suku naa puringi. Ye telumu mindi, mulu koleana maniendo sipe orumu yemo mindi oumulu koleana molorumu. Yu Manie Omba Mana Ye A Lierimu Yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ou Mosisini yembo naa peli kolea kune kongi ka wambiye kapane telimu lipe ola uku topa mondorumumu mele aku siku yembomane Manie Omba Mana Ye A Lierimu Yemo liku ola uku toko panjinge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kanu kinie, ⸤ou yembo wambiyemane nongo kondoringi kolonge teringi yembomane Mosisini lipe ola uku topa mondorumu wambiye kapane telimu kanokolie konde puringi kanu mele⸥ pe kinié aku siku ‘Yembomane yu-mele-mele ‘Manie Omba Mana Ye A Lierimu Yemo yu ulume tepa molemo mele sike.’ ningu tondolo munduku pilinge yemboma pali molko kondoko mindi pangi.’ nimbe Pulu Yemone ‘Yu unjona ola uku toko panjengi.’ nimbé nirimu.” nimbe Yesusini nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Pulu Yemone mana yemboma konopu paa awili tepa mondopalie ‘Eno mindili nongo molko kenjinge koleana naa puku, alieli molko kondoko mindi pangi.’ nimbe yunge Malo telumu mindi molorumu nalo kanumu mana yemboma sirimu. Pe kinié yembomane yu mele mele ‘Yu sike ⸤Pulu Yemonga Malo, olio mindili nolemela aulkena wendo lili yemo⸥.’ ningu tondolo munduku pilku molonge yemboma mindili nongo molko kenjinge koleana naa puku, alieli molko kondoko mindi punge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Pulu Yemone Malondo “Nuni mana yemboma kote pilku eno ka ulkena liku mundeni pu.” ni naa nirimu. ‘Nanga kangomo eno lipe tapondopa mindili nolemela aulkena wendo lipe na-kinie molko kondonge aulkena lipe mondopili.’ nimbe yuni Malondo “Ma koleana manie pu.” nimbe yu lipe mundorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yembo “Yu sike ⸤Pulu Yemonga Malo, olionga nimbe tenderimu yemo⸥.” nimbe tondolo mundupe pilipe molomba yembomonga kote naa pemba. Nalo yembo tene ‘Yu aku sipe naa molemo. Nanga nimbe ulu te naa tenderimu.’ nimbe pilimbe yembomo, yunge kotemo koronga wendo okomo. Kanu yembomone Pulu Yemonga Malo telumu mindi molemo kanumundu ‘Yu sike Pulu Yemonga Malo.’ ningu naa piliemu-ne kanu yembomo kote pilimo yemone lipe kote tendepa “Yu kolopili.” nimbe koronga ou tenderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Kotemonga ungu pulumu isipe: Patelimu mana wendo orumu nalo mana yembomane ulu pulu kerime mindi tekolie patelimu konopu naa mondoko sumbulu tolimu mindi konopu mondolemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yembo ulu pulu kerime telemelemane patelimu kanoko keri kanokolie, ‘Patelimuni nanga ulume mona lendemba.’ ningu patelimunge wendo naa olemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nalo yembo ulu sikema telemo yembomone ‘Pulu Yemone na lipe tapondolemo-na iulu pulu sikema telio kene telio ulume yembomane kanangi.’ nimbe patelimunge yu wendo olemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pe Yesusi kinie yunge lombili andoli yema kinie kolea Judia disiriki lierimu kolea tenga pukulie niringimuni, akune wale mare yu eno kinie molkolie, yuni yemboma no linderimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jono yu yemboma no lindipe molorumula. Kolea Sellimi nondopa kolea Inono no awisili omba purumu kulu Jono yuni akune yemboma no linderimu, yembo awisili yu molorumune no linge oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jono yuye nomi kingi Erotene ka ou naa sipili aku tepa molorumu.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Walse ⸤No Lindeli⸥ Jononga lombili andoli yema kinie Juda ye te kinie anjo yando tondolo kerepale ningulie, “Olio no nambepo lemolo kinie Pulu Yemone olio kake temba kanombaye?” ningu kerepale niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe Jononga lombili andolime Jono yu molorumune ongolie ningendo: “Rapai, ye te no Jodane nekendo nu pea moloringili kinie nuni yu molemo mele ningu sirinu kanu yemone no lindipe molemona yembo awisili pukumili.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aku niringi pilipelie Jonone topondopa nimbendo: “Mulu koleana Pulu Yemone ‘Ye te ulu te tepili.’ ni naa nilkenje kanu yemone manda naa telka. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nane eno ou nimbu sirindu pilieringi mele isipe: Nane nimbondo: “Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ nimbe mako torumu ye nomi Kirasimu namolo. Pulu Yemone ‘Kirasi yu ombá.’ nimbe na ou kumbi lepa lipe mundorumu.” nirindu pilieringi kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ye ambo limbemo yemo yunge mindi. Ye ambo limbe yemonga pulu lemba yemone ambo limbe yemone ungu nimbé mele pilimbendo pulu lemba yemo komu tendepa molomba. Yunge ungumu pilipelie paa konopu simbe. Akumunge yemo kinie pulu lemba yemo konopu simbe mele na aku sipu kamu konopu silio. Ambo limbe yemo olandopa. Yunge pulu lemo yemo yu kinie we tapu topa molemo, aku yemo maniendopa. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aku sipe mele ne no lindipe molemo yemo yunge imbimu sike paa olandopa pumbe. Nanga imbimu sike manie pumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ye wi ola molopalie maniendo orumu yemo yembomanga pali yu olandopamo. Olio mana yembo molemoloma mana melemanga mindi molopo, mana melemanga mindi imbime nimbu sipu temane tolemolo. Olio maniendopa, mulu koleana molopalie manie orumu yemo yu yembomanga pali olandopa. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yuni mulu koleana kanopa pilierimu mele nimbe silimo nalo yembomane “Kolo tokomo.” ningu liku su siku naa pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yembo tene yunge ungumu pilipe lipe “Sike nikimu.” nimbe yembomone aku sipe “Pulu Yemone sike nilimo.” nimbéla. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","I Pulu Yemone lipe mundorumu yemo Pulu Yemo yunge Minimu paa awili tepa silimo konopune pepa kapola telemo kolo yuni Pulu Yemonga ungumu sumbi sipe nilimo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lapane Malo konopu mondopalie ‘Melema pali Malo nokopili.’ nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yembo te ‘⸤Yu sike nikimu.⸥ Yu sike Pulu Yemonga Malo.’ nimbe tondolo mundupe pilimbe yembomo alieli konde molopa mindi pumbe, nalo yembo te Malo bulu sipe yunge ungumu lipe su sipe naa pilimbe yembomo konde mololi ulu pulumu naa limbe. Aku yembomo kinié kepe pe kamu-kumu kepe Pulu Yemone mindili lipe simbe ulu pulumu yu kinie pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi yemane ungu te pilieringi mele i sipe: “Yesusi molemona yembo awisili ‘No lindepili.’ ningu pulimele Jono molemona yembo koltalo mele ‘No lindepili.’ ningu pulimele.” niringi ungumu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Nalo Yesusi yulombili puringi yemboma yuni no naa linderimu, yulombili andoli yemane yemboma no linderingi.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","⸤Yesusiniyembo no linderimu⸥ temane akumu Parisi yemane pilieringi mele pilipelie Awilimuni kanu walemonga kolea Judia disiriki mundupe siye kolopa kolea Gallilli disirikindu kelepa pumbe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yu Gallilli purumu aulke akumu kolea Sameria awi-suku-singine lepa purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aulkemo aku sipe lierimu-ne yu kolea Sameria taono tenga orumu, akutaonomonga imbimu Saika. Aku koleamo Juda yembomanga anda-kolepa Jekopone yunge malo Josepo sirimu mamonga nondopa lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekopone ‘No molopili.’ nimbe muru akuorumu aku no-mongolomo kanu kolea Saika lierimu. Yesusi aulke sulune orumumunge siye terimu kulu aku no kélona omba manie molopa mulu pilierimu. Kolea awi-tangoli mele akune omba molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","(Yesusi yu lombili andoli ye pea oringime yu mulu pilipe molopili eno langi topo toko lingendo Saika taonona puringi.) Pe yu mulu pilipe molorumu kinie Sameria ambo te no kolombando orumu kinie Yesusini yundu nimbendo: “No te nambo si.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sameria ambomone yundu nimbendo: “Nu Juda yemo. Na Sameria ambomo. Pe nambemune nando “No si.” nikinuye?” nirimu. (Aku nirimumunge ungu pulumu isipe: Juda yembomane Sameria yemboma konopu keri panjiku langi telumu moke teko naa nongo, eno kinie telune tapu toko naa andoringimunge aku nirimu kanumu.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesusini topondopalie ambomondo nimbendo: “Pulu Yemone melemo we silimo mele pilku, iye “No si.” nikimu yemo kanoko imbi silinanje yundu “No si.” nilina kinie yuni konde molopa mindi puli nomo nu silke.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ambomone topondopa nimbendo: “Awilimu, nu no koloni mingi te naa menu, no-mongomo paa maniendopa lemo. Pe ino konde molopa mindi puli nikinu nomo nu tena kolkolie siniye? ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Olionga anda-kolepa ino mongolo sirimu ye Jekopo, yu kinie yunge ambolangoma kinie kongime kinie inomo noringi, ‘kanu yemo maniendopa nu olandopa.’ ningu nikinuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusini topondopa nimbendo: “I no mongolona no nonge yemboma altopa no waka lemba, ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nalo nane nosimbo nonge yemboma pe eno no paa waka naa lemba. Nane paa sike nikiru: Nane no simbo akumu nonge yembomanga konopune no pikipe mindi molopa, konde molko mindi punge ulu pulumu simbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","⸤Yesusini ungu iko torumu mele naa pilipelie nirimumuni,⸥ ambomone yundu nimbendo: “Awilimu, nanoaltopa waka naa liepili, ya altopo taki-teki ombo no naa kolambo kene nuni no nikinumu nambo si.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yuni yundu nimbendo: “Nunge yemo pea kelko wangili, puku walsi-pou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ambomone topondopa nimbendo: “Nanga ye te naa molemo.” nirimu. Yesusini yundu nimbendo: “ “Nunge ye te naa molemo.” nikinumu sike nikinu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ou nu ye kise pakera purunu. Pe kinié nu ye te pea pelembelemo nunge emena molo. Nuni kinié ungu nikinumu sike nikinu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ambomone yundu nimbendo: “Awilimu, na pilkiru nu Pulu Yemone ungu umbu tondolemoma pilku yemboma ningu silino ye te lepamo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Olionga anda-kolepalimene ima pangine Pulu Yemo popo toko kapi niringi nalo eno Juda yembomane ningendo: “Pulu Yemo popo toko kapi ninge koleamo paa Jerusalleme mindi.” nilimele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesusini tondolo mundupe nimbendo: “Ambomo, nane ya nikirumu nu pilku lieni. Wale te wendo ombá kanu walemonga ima pangine kepe Jerusalleme kepe yembomane Lapa popo toko kapi naa ninge.” nirimu. ⸤Akuungumunge pulumu: “Koleamanga pali Pulu Yemo popo toko kapi ninge.” nirimu kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Eno Sameria yembomane popo toko kapi nilimele yemo pilku sunduku we nilimele. Olio Juda yembomane popo topo kapi nilimolo yemo molemo mele pilipu kondolemolo. Nambemune, mana yemboma Pulu Yemone lipe tapondopa, mindili nolemela aulkena wendo lipe, yu-kinie pea molko kondonge aulkena lipe mondolemo ulu pulumu Juda yemboma kinie wendo ombá, enone koleamanga pali yemboma liku ora singemonga aku sipe. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nalo Pulu Yemo sike popo toko kapi ninge yembomane Tatanga ungumu ‘Sike ungumu.’ ningu pilku yunge Minimuni tondolo silimomonga Pulu Yemo popo toko kapi ninge wale wendo ombámo koronga wendo omu. Pulu Yemo akusiku popo toko kapi ninge yemboma Tatane korolemomonga kanu walemo wendo omu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pulu Yemo yu minimu, akumunge yu popo toko kapi ninge yembomane yunge Minimuni tondolo silimomonga ‘Yunge ungumu sike ungumu.’ ningu sumbi siku aku tenge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ambomone nimbendo: “Ye nomi Mesayamo ombá. Yu ombalie ungumenga pulume pali olio mimi sipe nimbe simbe mele na pilipu molio.” nirimu. (Ipuru ungune ‘Mesaya’ niringi akumu, Giriki ungune ‘Kirasi’. niringi aku unguselonga pulumu telumu. Unguselonga pulumu isipe: Pulu Yemone “Olio nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu ye nomi kanumu.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kanu kinie Yesusini tondolo mundupe nimbendo: “Nu “Ye nomi Mesayamo ombá.” nikinu akumu na. Nanu-kinie ungu nimbu molkombolo yemo kinie, nuni “Ye nomi Mesaya” nikinu kanu yemo kinie, ye telumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yu aku nimbe molopili yu lombili andoli yema kelko yando ongolie niringimuni, yu ambo te kinie ungu ningu moloringili kanokolie konopu awisili liku mundoringi. Naloenonga ye tene “Nu nambolka melte lini tekenoye?”, molo “Yu kinie nambemune ungu ningu molembeleye?” ningu tene kepe naa walseringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kanu kinie ambo kanumu yunge no mingimu mundupe siye kolopa yu kelepa kanu taonona yando pupeyembomando nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Na ulu terindume pali ye tene na nimbe simu yemo eno ongo kaname! Pulu Yemone “Olio nokopa kondomba ye te lipu mundumbo.” nirimu ye nomi Kirasimu yunje.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aku nirimu kulu pilkulie yemboma taono munduku siye kolko Yesusi molorumune onge oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aku teko molangi yu lombili andolimene yu paa karaye tekolie ningendo: “Rapai, langi te nou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nalo yuni enondo nimbendo: “Na langi nombómo lemo, nalo akumu eno naa pilku naa kanolemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aku nirimu pilkulie yu lombili andolimene anjo yando kerepale ningulie ningendo: “Yembo tene langi ou memba omba simunje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesusini nimbendo: “Nanga langi isipe: Na ‘kongono teani pu.’ nimbe lipe mundorumu yemone konopu silimo ulume tepo, yunge kongonomo tepo pora simbo. Akumu nanga langimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Enone “Oli kise omba pumbe kinie rasi-witi nou lemba, inie topo lipu nosimolo.” nilimele kanumu. Nalo nane enondo nimbondo: Poniema kaname! Langi pali koronga nou liemu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Langi inie tondolemo yemo langi inie tondolemomonga mele kaloli koronga lipe, ‘Lepa mindi pupili.’ nimbe langime inie tondopa molemo. Aku tendelemomonga ponie tepa langi panjerimu yemo kinie langi inie tondolemo yemo kinie peaselo konopu singele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Akumunge ungu te pelemomo sike. ‘Ye tene langi umbu tondolemo. Tene langi inie tolemo.’ nilimele ungumu sike. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Langi enone umbu naa toringime nane “Eno inie to-paa.” nimbu lipu mundorundu. Yembo lupemane ponie mindili siku teringi, nalo yembo lupemane teringi langime eno inie tolemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ambomone “Na ulu terindume pali yuni na nimbe simu.” nirimu kulu pilkulie kanu taonona moloringi Sameria yembo awisili ‘Yu sike ⸤Pulu Yemone ‘Eno nokopa kondomba ye te lipu mundumbo.’ nimbe ou mako torumu⸥ ye nomi Kirasimu.’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Akumunge Sameria yemboma yu molorumune ongo, “Nu paa ya pea molamili.” niringi, kanu kinie wale talo yu eno kinie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kanu kinie yembo awisili pea yu yuyu ungu nirimumu pilkulie ‘Yu sike ⸤ye nomi Kirasimu omba molemo. Yuni sike nikimu.⸥’ ningu tondolo munduku pilieringila. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Enone ambomondo ningendo: “Nuni ou ungu ninumu pilipu ‘Yu sike ye Kirasimu.’ nimbu tondolo mundupu piliemulu nalo kinié olio oliolio yunge ungumu pilipulie ‘Sike iyemo olio mana yemboma Lipe Tapondopa Mindili Nolemela Aulkena Wendo Limo Yemo molemo.’ nimbu tondolo mundupu pilimolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sameria yemboma kinie wale talo molopalie Yesusi eno mundupe siye kolopa kolea Gallilli disiriki pumbe purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Gallilli Yesusi yunge pulu koleamo. Ou walse Yesusi yuni nimbendo: “Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo ye tene yunge pulu koleamonga yemboma ungu nimbe silimo kinie pilkulie nilimelemone, enone ‘Yu olionga we yere. Yu imbi mololi ye te molo.’ ningu yu nilimo ungume naa pilku liku su silimele.” nirimu kanumu.) ⸤‘We koleamanga yembomane kanu yemonga ungumu limele nalo yunge pulu lemo yembomane naa pilku limele.’ nimbe nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yu Gallilli suku purumu kinie Gallilli yemboma yu orumu kanokolie “Papu okono.” ningukonopu siringi. Ou Pulu Yemone Juda yembomanga anda-kolepalime Naa Topa We Omba Purumu mele pilieringi walema wendo orumu kinie eno Jerusalleme puku molangi yuni akune ulu mare terimu kanoringimunge enone aku siku teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesusi kolea Gallilli disiriki pupelie altopa Kena taonona sukundu orumu. Kanu taonomonga ou yuni umbu no koloringime no-waene a lenderimu. Kapeniame taono ye nomi kingimunge kongono tendeli ye awili te kanu kolea Kena molorumu, kanumunge malo kuru awili te torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","‘Yesusi kolea Judia disiriki mundupe siye kolopa kolea Gallilli disiriki sukundu orumu.’ pilipelie nirimumuni, kanu yemo Yesusi molorumune pupelie nirimumuni, yundu mawa tepalie nimbendo: “Nanga kangomo nondopa kolomba tekemo kene maniendo ongo yu teko konde li.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aku nirimu kinie pilipelie Yesusini yundu nimbendo: “‘Na sike ⸤Pulu Yemo kinie molopalie mana maniendo orumu⸥.’ we ningu naa pilinge lemo. Pulu Yemone ulu tondoloma telemo mele ‘Yuni aku sipe mele temba kinie kanopolie ‘Yu sike ⸤Pulu Yemo kinie molopalie mana maniendo orumu⸥.’ nimbu tondolo mundupu pilimolo.’ ningu nando alieli “Ulu tondoloma ongo tei.” ningu mawa telemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kingimunge kongono tendeli ye awilimuni yundu nimbendo: “Awilimu, nanga kangomo mini ou naa pupili nu welea maniendo ou.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesusini yundu nimbendo: “Marena konde pumu kene pu.” nirimu. Yemone Yesusini nirimu mele pilipelie ‘Sike nikimu.’ nimbe tondolo mundupe pilipe yu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Maniendo pumbe purumu kinie yunge kendemandema aulkena ongo yu maniendo orumu kanoko likulie enone yundu ningendo: “Marena konde pumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kanu kinie yuni enondo nimbendo: “Ena nambolkana kuru topa keliemuye?” nimbe walsipe pilierimu. Enone yundu ningendo: “Oleanga awi-tangoli wane killoko mele kangi nomba keliemu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lapane pilipelie Yesusini “Marena konde pumu.” nirimu kanu enamonga ‘Kangi nomba keliemu lepamo.’ nimbe pilipelie, yu kinie yunge ulke peringi yemboma kinie enone ‘Yesusi yu sike ⸤Pulu Yemo kinie molopalie mana manie orumu lepamo⸥’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kolea Judia disiriki mundupe siye kolopa kolea Gallilli disiriki omba molopalie Yesusini kangomo tepa konde lsimu kanu ulumu aku koleana yu molorumu mele lipe ora sirimu ulu tondolo talo sipe mele terimu. Te ou walse aku koleana umbu no koloringime no-waene a lenderimu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pe walse, Juda yembomane ponie tenga tenga ningu Jerusalleme puku Pulu Yemo-kinie ulu te teringi wale te wendo orumu kinie Yesusi Jerusalleme olando purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalleme sukundu, kongi sipisipimenga pala kerepulune nondopa, no-mongo te molorumu, kanu no-mongomondo Ipuru ungune ‘Beteseda’ niringi, akune ulke takaye kise pakera angilipe makaye terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Akunekuru torumu yembo awisili aniembo lieringi. Mongo keri lierimu yemboma kinie, kimbu pange tepa karaye tepa perimu yemboma kinie, kimbu kolopa kukurumu yemboma kinie enone (‘Nomo lope-lape temba.’ ningu nokoko moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Walse walse nimbe Awilimunge angello te manie omba nomo lope-lape tenderimu kinie yembo te kumbi lepa nona suku purumu yembomo konde purumu.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ye te akune molorumu ponie wane paono tene eti kuru torumu yu aniembo lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesusi omba, yemo aniembo lierimu kanopa, yu koro-ou lipe aniembo lierimu pilipelie, yemo walsipelie nimbendo: “Nu ‘kuru waengo nipili.’ konopu lekenoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aniembo lierimu yemone topondopa nimbendo: “Awilimu, no lope-lape telemo kinie yembo te na lipe tapondopa nona meli pumbe te naa molemo. Na nanu pumbo telio kinie yembo mare ou kumbi leko nona pulimele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aku nirimu kinie Yesusini yundu nimbendo: “Nu olaangilku nunge uru peleno kunungumu liku mengo ongo pu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aku nirimu kinie walsikele yemonga kurumu pora nirimu kinie yu ola angilipe yunge kunungumu lipe meli purumu. Iulu wendo orumu wale akumu ⸤Juda yembomanga koro moloringi⸥ wale Sambate te, ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","akumunge Juda ye ⸤awili⸥ marene kuru pora nirimu yemondo ningendo: “Kinié ⸤koro mololi⸥ wale Sambatemonga nambemune nunge kunungumu meli ongo pukunuye? ‘Sambate wale kinie melema naa meli anda.’ nimbe ungu mane pelemo kanumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nalo yemone topondopa nimbendo: “Na tepa konde limu yemone nimbendo: ‘Nunge kunungumu liku ambolko pu.’ nimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aku nirimumunge enone yu altoko walsikulie ningendo: “Ye nawene ‘Nunge kunungumu liku ambolko pu.’ nimuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nalo ye kuru pora nirimu yemo ou aniembo lierimu koleana yembo awisili moloringi kulu Yesusi kiyengo nimbe purumumunge yuni manda yunge imbimu walsipe naa pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pe Yesusi kanu yemo ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena kanopalie yundu nimbendo: “Pilie. Kinié nunge kuru pora nimu nu altoko konde moleno kene nu ulu pulu kerime manda teko, altoko naa tei! Altoko tenu liemo nu ulu umbune awili te wendo ombánje.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ye kanumuni anjo pupe Juda ye awilimendo nimbendo: “Na tepa konde limu kanumu Yesusi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesusini eno koro moloringi wale Sambatemonga aku sipe ulume terimu kulu Juda ye awilimene Yesusi yu pulu polko teko kenjiku umbune siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesusini enondo nimbendo: “Tatane ou yemboma walemanga pali lipe tapondorumu mele kinié kepe aku sipe tepa molemo. Naaku sipe Sambate walemanga kongono teliola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yuni aku nirimu kulu pilku Juda ye awilimene ‘Yesusi yu paa kamu topo kondomolo.’ konopu leko aulke te koroko moloringi. Ou Sambate walemonga ungu manemo pulue torumumunge pilku yu mumindili kolkolie; pe “Pulu Yemo yunge lapa.” nirimumunge yu ‘Pulu Yemo kinie kapola kapola molembolo.’ nimbe nirimumunge yukamu mumindili kolko yu tonge teringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesusini enondo topondopa nimbendo: “Nane eno paa sike nimbu sikirumu: Malone yuyu ulume manda naa telemo temba. Yunge Lapane telemo mele kanopalie manda manjipe telemo. Lapane telemo ulume mindi Malone telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nambemune, Lapane Malo konopu mondopalie yuni telemo mele pali Malo lipe ora silimo. Yetepa konde limu akumu maniendopa. Paa sike pe eno paa kanoko konopu awisili liku mundunge ulu tondolo olandopama Lapane Malo lipe ora simbe. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Akumu nambepa wendo ombáye? Lapane yembo kololime topa makinjindipelie ‘Konde molangi.’ nilimo mele aku sipe Malone yembo kololime ‘Konde pangi.’ konopu lemo yemboma tepa konde limo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ungu te pea isipe: ‘Yembomane Lapanga imbimu liku ola mundundulimele mele Malonga imbimu aku siku liku ola mundundengi.’ nimbe Lapane kote pilipe yemboma naa apurupe kote pilieli kongono akumu Malo sirimu. Akumunge yembomane Malonga imbimu liku ola naa mundundulimele yembomane aku siku Malo yando lipe mundorumu Lapanga imbimu kepe liku ola naa mundundulimelela. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nane enondo paa sike nimbu sikirumu: Nanga ungumu pilku, na lipe mundorumu-ne orundu yemo ‘Yusike Pulu Yemo.’ ningu tondolo munduku pilimele yemboma konde molopa mindi puli ulu pulumu eno-kinie pelemo. Pe kote walemo wendo ombá kinie eno kotena naa angilingela. Kanu yemboma kololi ulu pulumu pelemo aulkemo munduku siye kolko konde molopa mindi puli aulkena pulimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nane enondo paa sike nimbu sikirumu: Wale wendo ombámo kinié koronga wendo omu. Kanu walemonga Pulu Yemo Malonga ungumu kololi yemboma pilinge. Kanu kinie yunge ungumu ‘Sike’ ningu pilku liku molonge yemboma konde molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Melema konde mololi ulu pulumu Lapa kinie pelemo mele aku sipe Lapane ‘Melema konde mololi ulu pulumu Malo-kinie pepili.’ nirimula. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Malo yu Manie Omba Mana Ye A Lierimu Yemo molemomonga Lapane ‘Malo yembomanga kote piliepili.’ nimbe nambamo sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Nalo akumunge mindi eno konopu awisili liku naa mundengi. Nambemune, wale te wendo ombá, kanu walemonga yembo ono koleana pelemelemane Malonga ungumu pilkulie ningemone, ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ono koleamo munduku siye kolko wendo onge. Kanu kinie lomboroko ola molonge yembomanga ou mana konde molkolie teko kondoko moloringi yemboma konde molonge; ou mana teko kenjiku moloringi yemboma pe kotena angilkulie pe mindili nonge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na nanu ulu te manda naa tembo. Tatane nilimo mele pilipulie yembomanga kotema apurupu pilio. ‘Na nanu konopu siembo.’ nimbu ulume naa tepo, ‘Na lipe mundorumu yemo konopu sipili.’ nimbu ulume teliomonga kote sumbi sipu pilipu apurupu kondolio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sike na molio mele na nanu nimbu sindu liemo ‘Kolo tokomonje.’ ningu piliengi liemo papu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ye tene lupe na molio mele nimbe silimo, akumu na pilkiru nando nilimo mele paa sike nilimo, ‘Kolo tokomonje.’ manda naa ninge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Enone ye mare ⸤No Lindeli⸥ Jono molorumune “Paa.” ningu liku mundoringi kinie yuni na molio mele ‘sike’ nimbe sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mana yembo tene na molio mele yemboma nimbe sipe “Sike nikimu. Sike aku sipe molemo.” nimu liemo na konopu awisili lipu naa mundupu, ‘Uluri molo.’ konopu lelio, nalo ‘Pulu Yemone eno lipe tapondopa mindili nolemela aulkena wendo lipili.’ nimbu Jonone nando nirimu mele eno nimbu sikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonone kongono terimumunge yu kiye mele nomba yemboma pa tenderimu. Kanu kinie laye-kolo eno konopu siku kanu patenderimune moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nalo Jonone na lipe tapondopa na molio mele eno nimbe sirimu mele maniendopa. Ulu te na molio mele lipe tapondopa lipe ora silimo mele olandopa. Tatane “Ulu tondolo teko pora sieni.” nimbe na sirimu ulu tondolo telio kanumene na lipe tapondopa, Tatane na “Pu.” nimbe lipe mundorumu mele eno lipe ora silimo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tatane na “Pu.” nimbe lipe mundorumu-ne orundumuni kepe nanga nimbe para sindelimu molopa na molio mele nimbe sirimu. Enone yunge kerena ungu nirimume walsikele kepekomumuni naa pilku, yunge kumbi-keremo mongone naa kanoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ungu te pea kepe. Tatane lipe mundorumu yemonga ungumu “Kolo tokomo.” ningu pilimelemonga yu lipe mundorumu Lapanga ungumu enonga konopumenga naa pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","‘Pulu Yemonga bokune ungu molemomane olio alieli konde molopo mindi pumolo ulu pulumu simbe.’ ningu mimi siku kanolemele. Aku mimi siku kanolemele bokumuni na molio mele nimbe silimo ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nalo ‘Konde molopo mindi pumolo ulu pulumu liemili.’ naa ningu, na moliona ‘naa omolo.’ ningu karaye telemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“‘Yembomane na kapi ningu nanga imbi liku ola mundundunge kinie na awilimu molambo.’ nimbu aku naa telio. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eno molemele mele nane pilio. Pulu Yemo konopu mondoli ulu pulumu eno kinie naa pelemo pilio. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nanga Tatane na namba sipe yunge kongonomo ‘tende-pou.’ nimbe na lipe mundorumu-ne orundu nalo nanga ungumu eno naa pilku limele. Nalo yembo tene yuyu namba lipe omba kongono telkanje aku yembomonga ungumu pilku limela. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Eno enono anjo yando ‘imbi molopili.’ ningu, Pulu Ye telumu mindi molemo akumuni enonga imbi ‘lipe ola mundundopili.’ naa nilimele liemo namolio mele nimbu silio ungumu ‘Sike nikimu.’ ningu nambeko pilingeye? ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nalo ⸤na-kinie⸥ teko kenjilimelemonga ‘Pulu Yemonga kote walemo wendo ombá kinie Tatane kote pilipe molopili nane nanu kote tendemba.’ ningu naa piliengi! ‘Mosisini eno lipe tapondomba.’ konopu lemele yemone enonga kote tendemba. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosisini na ombo molombo mele boku torumu-ne enone ‘Mosisini nirimu ungume sike nirimu.’ ningu pilimelanje nanga ungumu kepe ‘Sike nikimu.’ ningu pilimela. ");
INSERT INTO ubu_kala_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nalo yuni nanga temane bokune torumumu ‘Sike nikimu.’ ningu naa pilimelemonga nanga ungu nikirumu ‘Sike nikimu.’ ningu nambeko pilingeye?” nimbe Yesusini nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pe walse Yesusi Nomu Gallilli nona andoli sipine molopa nekendo purumu. (Aku nomumunge imbi te ‘Nomu Tapiriasi’ niringi.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aku nomune nekendo purumu kinie kuru torumu yemboma tepa konde lsimu kanokolie ‘Pulu Yemone mindi ulu tondoloma telemo mele yuni akusipe tekemo.’ ningu kanokolie yembo paa awisili yupurumune akiliku lombili puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesusi ma pangine ola pupe lombili andolime pea puku manie moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juda yembomane ⸤ponie tenga tenga kolea awili Jerusalleme ongo akune suku⸥ Pulu Yemone enonga anda-kolepalime Naa Topa We Omba Purumu mele pilingendo Pulu Yemo kinie ulu te teringi walema nondopa wendo ombá terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesusi ma pangine ola molopa maniendo sipe kanopalie yembo paa awisili yu orumu aulkena lombili oringi kanorumu. Kanopalie yuni yu lombili andoli ye Pillipundu nimbendo: “I yemboma nonge langime tena topo topo lindemili konopu lekenoye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yuni aku sipe Pillipundu we walsipe pilierimu. Yesusi yuni temba mele yuyu pilipe molorumu nalo ‘Pillipu yuni nambolka nimbenje? ‘Nane ulu tondolo te tepolie manda langi simbo.’ konopu lemba, molo we mini-wale mundumbenje piliembo.’ nimbelie yuni aku sipe Pillipundu walsipe pilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pillipuni yundu nimbendo: “Kakopoi ye tene oli engaki kongono tepalie mele kalolimu limo kou monemane langi topo topo limelanje yembo mare mindi laye-kolte liku nolemela. Mare molo tolka naa nolemela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lombili andoli te, Saimono Pitanga angenu Enderu, yuni nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ya kango te rasi-balli pillawa kaloli kanga kise pakera kinie oma kaloli talo kinie nosipe molemo. Nalo akumu koltalo, yembo paa awisili. Kapola naa temba lemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesusini “Yemboma “Manie molangi.” niengi.” nirimu. Aku koleana era awisili orumu-ne manie moloringi. Ye pape tausini mele akune manie moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kanu kinie Yesusini balli pillawa kalolime lipe ambolopalie Pulu Yemondo “Ange.” nimbe yembo moloringime moke tepa eno manda nonge mele sirimu. Omaselo aku sipela moke terimu. Nongo olo tenderingi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kanu langi noringi olo terimu kinie yuni yu lombili andolimendo nimbendo: “Langi kakena lemoma we manie pupe lemba kapola naa temba kene liku maku taa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kanu kinie nongo pora siringi kinie kakena lierimume lombili andolimene liku maku toko wale basikete engaki rurepo lakilku toko peke siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesusini Pulu Yemone mindi ulu tondolo manda telka mele akumu terimu kinie kanokolie yembomane pulu polko ningendo: “ “Pulu Yemone ungu umbu tondolime pilipe yando nimbe simbe ye te ma koleana omba olio nokomba.” ningu panjeringimu paa sike iyemo yu lepamo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aku ningu pilkulie enone ‘Yu olionga ye nomi kingimu molopili.’ ningu yu tondolo munduku ambolko liku ‘enonga kingimu molopili.’ ninge teringi. Akutenge teringi pilipelie yu yuyu molombando ma pangine ola altopa pupe molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena pupe kolea kala torumu kinie yu lombili andolime ma pangine maniendo puku nomu kélona maniendo puku ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","akune nona andoli sipi tenga ola pukunomune yakondo ongo Kapeniame taono ongo punge puringi. Aku kinie sumbulu torumu nalo Yesusi naa orumu kulu lombili andolime enono puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","⸤Sipine ola molko punge puringi kinie⸥ poporome tondolo torumu kinie nomo olapupe manie omba terimu, sipimu topa ola-munde manie-munde tepa topele-mapele torumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sipimu kundoringi nomu awi suku singi melena purumu kinie Yesusi nomune ola kimbu kongono tepa sipimu purumune orumu kanokolie ‘Kuru te okomo.’ konopu lekolie paa mini-wale awili teko mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nalo yuni enondo nimbendo: “Na mindi okoro, pipili naa kolaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aku nirimu kulu pilkulie “⸤Awilimu okomo lepamo.⸥ Sipine pea molamili.” ningu enone konopu siku yu sipimunge sukundu lsingi. Sukundu orumu kinie eno punge puringi nomu kélona sipimu walsikele purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ipulueli-ou yemboma nomu kélo nekendo ipulueli moloringime konopu kimbu sikulie niringimuni, ‘Oleanga ipulueli nomune andoli sipi telu mindi ya liemu, Yesusi akune suku naa pumu, yu lombili andolime enono akune suku puku nomu kélo nekendo pungi.’ ningu pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kanu kinie oleanga Awilimuni langi wallo kolte lipe ambolopa Pulu Yemondo “Ange.” nimbe yemboma sirimu noringi koleana nondopa kolea awili Tapiriasi yembomanga sipi mare nomu kélona oringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yesusini langi sirimu noringi koleana yembomane Yesusi yu korokolie niringimuni, yu kinie yu lombili andolime kinie akune naa moloringi kanokolie sipi eno moloringine nomu kélona nondoko ongo lieringimenga suku puku Kapeniame taonondo Yesusi koronge puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nomu nekendo ongo Yesusi kanoko lendekolie enone yu walsiku pilkulie ningendo: “Rapai, nu tewale yando onuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nalo yu orumu mele nimbe para naa sipelie topondopa enondo nimbendo: “Nane enondo paa sike nimbu sikirumu: Nane ⸤Pulu Yemone na lipe tapondolemo mele⸥ lipe ora silimo ulu tondoloma teliomonga enone na naa korokomele. Nane eno langi sindu nongo olo tendengi kanumunge mindi na korokomele lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Eno langi nondopa purulimoma ‘Lipu nomolo.’ ningu kongono naa teayo. Kanu langime nongolie nilimelemone, kolonge walema wendo olemo kinie kolemelela. Langi, Manie Omba Mana Ye A Lierimu Yemone silimo langi, kanumu naa purulimo, kanumu nolemele kinie konde molko kondoko mindi pulimele kanu langimu ‘Lipu namili.’ ningu mindi kongono teayo. “Ye akumuni sike kanu langimu yemboma simbe.’ ningu piliengi!’ nimbe Pulu Yemone ulu tondoloma telemo mele ‘Aku yemone ulu tondoloma aku sipe tepili.’ nimbe Pulu Yemo yuni yusirimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","⸤‘Sike langimundu nikimu.’ ningu pilku yuni nirimu ungumu pilku sundukulie niringimuni,⸥ enone yundu walsiku pilkulie ningendo: “Konde molopo mindi pumolo langi lipu namili kene olio nambepolie Pulu Yemone kanopa peanga kanomba kongonoma temoloye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yuni topondopa nimbendo: “Pulu Yemonga kongonomo isipe: ‘Pulu Yemone ma koleana lipe mundorumu yemo yu sike Pulu Yemonga malo, ⸤yu sike olio molopo kondopo mindi pumolo ulu pulumu simbe yemo⸥’ ningu tondolo munduku pilku molaa.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aku nirimu pilkulie enone yundu walsikulie ningendo: “Nuni ‘ “Na sike Pulu Yemone lipe mundorumu. Nane nikiru ungume sike ungume.” nilio akumu ‘Sike.’ ningu tondolo munduku piliengi.’ ningu Pulu Yemone mindi ulu tondolo manda telemo ulume mele nuni aku siku nambolka ulu tondolo te liku ora siniye? Nambe-eni kinie kanopolie ‘Nuni sike nikinu.’ nimbu pilimolonje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“Olionga anda-kolepali ou moloringime kolea ku lieline langi mena noringi. Langi mena orumu mele Pulu Yemonga bokune temanemo molemo: ‘Yuni ‘Eno mulu koleana yando langi nangi.’ nimbelie sirimu.’ ungu akumu molemo. ⸤Nuni olionga aku siku tendeni molo nambe-eniye?⸥” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesusini enondo nimbendo: “Nane enondo paa sike nimbu sikirumu: Moloringi yemboma mulu koleana yando langi sirimu yemo Mosisi molo. Tatane sirimu. Molko kondoko mindi puli ulu pulu pelemo langi nikiru kanu sike langimu mulu koleana yando silimo yemo Tata mindila. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mulu koleana manie omba mana yemboma molko kondoko mindi punge ulu pulumu silimomo yu Pulu Yemone silimo langimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesusini nirimu mele pilku sundukulie, “Awilimu, aku langimu kinié kepe pe pe kepe si.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kanu kinie Yesusini enondo nimbendo: “Molko kondoko mindi punge langimu na. Umbu langi nongolie engele naa kolko kangi tondolo pupili molemele mele aku sipe na molombona onge yemboma enonga minimu engele naa kolomba, konopu tondolo pupili molonge. Umbu no nongolie no waka naa kolko kapola molemele aku mele nanilio ungume kepe molio mele kepe manda tembo melekepe ‘Sike.’ ningu tondolo munduku pilinge yemboma altoko alieli minimu no waka naa liepili molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aku tenge yemboma aku siku molonge nalo “Enone na ⸤Pulu Yemonga ulu tondoloma telio mele⸥ kanokolie kanoko sunduku ‘We telemo. Yu Pulu Yemone naa lipe mundorumu.’ ningu pilimele.” ou nimbu sirindu kanu mele kinié kepe aku siku we teko molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tatane ‘Nanga yemboma molangi.’ nimbe mako tondolemo yemboma pali na molombona ongo na tondolo munduku pilinge. Kanu kinie na lombili andongendo na molombona onge yemboma telurindu kepe “Lombili naa ongo anjo pu.” paa naa nimbomo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“‘Na nanu konopune pilkiru mele teambo.’ nimbu na mulu koleana mundupu siye kolopo mana maniendo naa orundu, molo. Na lipe mundorumumuni konopuni pilimo mele tembo orundu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na lipe mundorumu yemone konopuni pilierimu mele isipe: ‘Nane ⸤Malo⸥ simbo yemboma pali ⸤Malone⸥ nokopa kondopa, telu kepe mundupe siye kolopalie mindili nonge koleana paa naa pumbe, ma kolea pora nimbé walemonga eno pali topa makinjindipe olando lipili.’ konopu lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na lipe mundorumu Tatane konopuni pilierimu mele isipe: ‘Nanga malo ‘olio lipe tapondopa, mindili nolemela aulkemo wendo limbe.’ ningu tondolo munduku pilinge yemboma molko kondoko mindi pangi.’ nimbe konopuni pilimo. Kanu kinie aku tenge yemboma ma kolea pora nimbé walemonga kinie nane topo makinjindipu olando limbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesusini “Na mulu koleana maniendo orundu langimu.” nirimu pilku keri pilkulie Juda ye awilimene yumumindili kolko enono pulu polko kono-kono ningulie ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ningendo: “Aku ungu nikimu yemo Joseponga malo Yesusi mindi. Yunge anumu lapaselo kanolemolo kanumu. Pe yu “Mulu koleana molopo mana maniendo orundu.” nikimumu nambepa nikimuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesusini nimbendo: “Eno anjo yando kono-kono manda nieme! ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yembo teluri kepe na we manda naa lombili onge. Na lipe mundorumu Tatane konopune kundulimo yemboma mindi na lombili olemele. Na moliona ongo na tondolo munduku pilimele yemboma kolea pora nimbé walemonga nane topo makinjindipu olando limbo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemanga bokune molemo ungu te isipe: “Pulu Yemone yemboma pali ungu mane simbe.” ningu toringi bokune aku sipe molemo. Tatane nilimo mele pilkulie kanu ungumenga pulume pilku limele yemboma pali na moliona olemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tatanga ungumu pilimele nikiru akumu paa sike yunge ungumu pilimelemondo nikiru nalo yu mongone naa kanolemele. Ma koleana yembo telurini kepe Tata naa kanoringi naa kanolemele. Yembo telumuni mindi yu kanorumu. Tata kinie molopalie manie orumumuni mindi yu kanorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nane enondo paa sike nimbu sikirumu: Nilio ungume ‘Sike nilimo.’ ningu tondolo munduku pilimele yemboma molko kondoko mindi punge ulu pulumu eno kinie pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mini pali molko kondoko mindi punge gamo na. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Enonga koro-ou moloringi yembomane kolea ku lieline langi mena noringi nalo molko mindi naa puringi. Enonga kolonge walema wendo orumu kinie koloringila. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Nalo ikinié nikiru langimu mulu koleana maniendo okomo langimu. Akumu nonge yemboma mini pali naa kolonge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pora naa nimbe we lepa mindi puli langimu, akune suku molko kondoko mindi puli ulu pulumu pelemo langimu, akumu mulu koleana maniendo orumu langimu na. Aku langimu nanga kalumu. ‘Ma koleana yemboma, mini pali molko kondoko mindi pangi.’ nimbu nane nanga kalumu enonga langi simbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","⸤Yesusini aku nirimu pilku sundukulie,⸥ yembomane kerepale ningulie, “I yemo olio yunge kalumu “Nangi.” nimbe nambepa manda simbendo nikimuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesusini enondo nimbendo: “Nane enondo paa sike nimbu sikirumu: Enone Manie Omba Mana Ye A Lierimu Yemonga kalumu naa nongo yunge mememo naa nongi liemo molko kondoko mindi puli ulu pulumu eno kinie manda naa pemba. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nanga kalumu kinie mememo-selo nonge yemboma alieli molko kondoko mindi punge ulu pulumu eno kinie pelemo. Kanu yemboma ma kolea pora nimbé walemonga nane topo makinjindipu olando limbo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Nanga kalumu sike langimu; nanga mememo sike nomo. Umbu ga kinie no kinie nongolie, kolonge wale wendo olemo kinie kolemele. Nalo nanga kangimu kinie mememo-selo nolemele yemboma molko kondoko mindi punge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nanga kalumu kinie mememo-selo nolemele yemboma eno na kinie tapu toko molemele, na eno kinie tapu topo molio. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Molopa mindi pulimo Tatane na lipe mundorumu, yuni na ‘Molko mindi pani.’ nirimu-ne molopo mindi pulio, aku siku melela na nonge yemboma ‘Molko mindi pangi.’ nimbo, kanu kinie eno mini pali molko mindi punge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aku langimu mulu koleana maniendo orumu langimu. Olionga ou anda-kolepali moloringimene langi mena nongolie ⸤kolonge walema wendo orumu kinie⸥ koloringi, nalo pe kinié orumu langimu kinie ou orumu langi menamo kinie telu sipe molo. Pekinié orumu langi imu nonge kinie alieli molko kondoko mindi punge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Juda yemboma maku toko Pulu Yemonga ungumu pilieringi ulke te, Kapeniame taonona angilierimu, akune suku Yesusini yemboma ungu mane sipe aku ungume nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesusini ⸤yunge kalumu kinie mememo-selo langi kinie no kinie nongemonga⸥ nirimu mele pilkulie Yesusi lombili andoringi yembo awisilini ningendo: “I ungumu aroma topa nikimu. Nawene manda pilipe limbeye? Olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yu lombili andoringi yemboma yu nirimumunge pilku keri pilku anjo yando kono-kono ningu kerepale niringi Yesusini pilipelie nirimumuni, yuni enondo nimbendo: “I ungumu eno pilku keri pilkimiliye? ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pekinié Manie Omba Mana Ye A Lierimu Yemo oumolorumune kelepa olando pumu kanongi liemo nambe-engeye? Kamu mumindili kolongenje? ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Minimuni konde molko puli ulu pulumu silimo; kangimuni konde molko punge uluri naa telemo. Nane enondo ungu nindu akume konde molko mindi puli ulu pulumu. Akume enonga konopune suku pemba kinie eno mini pali konde molko mindi punge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nalo eno molemele yembo marene ‘yu kolo tokomo.’ ningu pilkimili.” nirimu. Yuni pilipe ‘Yu kolo toli yemo.’ ningu pilinge yemboma kinie ‘Yu sike ungu nili yemo.’ ningu pilinge yemboma kinie koronga apurupe pilipe, Yesusi yu yunge opa puluema lipe simbe yemo koronga pilipe molorumu kulu “Eno mare na ‘Kolo tokomo.’ ningu pilkimili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yuni ungu te pea nimbendo: “Eno marene na ‘Kolo tolemo.’ ningu pilimelemonga ‘Tatane “Na moliona paa.” ni naa nilimo yemboma na moliona manda naa ongo, natondolo munduku manda naa pilku andonge.’ ounimbu sindu kanumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aku ungu nirimu enamonga kepe pe enamanga kepe yu lombili andoringi yembo awisili yuni nirimu mele pilku keri pilkulie yu munduku siye kolko bulu siku altoko yu lombili naa puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yu munduku siye koloringi kinie yu lombili andoli rurupendo yuni walsipe pilipelie nimbendo: “Eno kepe na ‘Mundupu siye kolopo anjo pumolo.’ konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimono Pitane topondopa nimbendo: “Awilimu, nawe molemona pumoloye? Molopo kondopo mindi pumolo ungume nu-kinie pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Olio pilipu nu ‘Pulu Yemonga Kake Teli Yemo’ nimbu tondolo mundupu pilimolo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusini topondopa nimbendo: “Nane nanu eno rurepondo pali ‘Nanga yema molangi.’ nimbu mako torundu nalo enonga ye te depele mele molemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Aku nirimumu Saimono Isikeriote malo Judasini tembamondo pilipelie nirimu. Judasi Isikeriote yu eno ye rurepo akumenga ye te nalo yuni pe Yesusi lipe yunge opa puluema sirimu-ne toringi.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kanu kinie pe Yesusi kolea Gallilli disiriki andopa molorumu. Juda ye awili kolea Judia disiriki moloringimene yu tonge nokoko moloringimunge pilipelie yu kelepa ‘Judia naapumbo.’ nimbe anjo molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nalo Juda yembomane ou kolea ku lieline sele-ulke takoko peringi walema pilieringi wale kake telime nondopa wendo ombá terimu kinie ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesusi yunge angenupilini yundu ningendo: ‘ “Nuni ‘ulu tondoloma teleno mele nu lombili andolemele yemboma kanangi.’ ningu nu ya munduku siye kolko Judiando pani.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“Yembo tene ‘yu kongono tepa molemo mele pilku yu kanoko imbi siengi.’ nimbe ulume lopi tepa naa telemo. Akumunge nuaku ulume sike teleno liemo yembomane pali kanangi puku te-pou.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesusi angenupilini kepe ‘Yesusi yu Pulu Yemone lipe mundorumu-ne orumu yemo.’ ningunaa pilkulie aku siku niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aku niringimunge Yesusini enondo nimbendo: “Nanga walemo ou wendo naa oli. Kinié alieli ulu tenge walema enonga walema. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma kolea yembomane eno kinie konopu keri naa panjilimele nalo nane yembomando “Ulu telemelema teko kenjilimele.” niliomonga na kinie konopu keri panjilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Eno wale kake telimu wendo ombá pili-punge liemo pangi. Nalo nanga walemo ou naa wendo okomo-na na ⸤isili-ou⸥ naa pumbo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aku nimbelie yu Gallilli we molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nalo Yesusi yunge angenupili ‘Wale kake telime pea piliemili.’ ningu ou puringi kinie Yesusi kepe purumu. Nalo Yesusi yu ‘naa kanoko imbi siengi.’ nimbe kiyengo nimbe kolea Judia disiriki pupe kolea awili Jerusalleme purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akune Juda yembomanga wale kake telime pilieringi Juda ye awilimene ‘Yesusi omunje.’ ningu koroko molkolie enono ningendo: “Kanu yemo tena molemonje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","We yembomanga awisilini yundu olo toko ningu andoko moloringi. Marene ningendo: “Yu ye peangamo.” niringi. Nalo marene ningendo: “Yu yandopa yemboma kolo topa silimo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nalo eno Juda ye awilime pipili kolkolie ‘Olio nikimulu mele eno pilinge kinie mongo limolo.’ ningu ungu tondolo teko naa niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kake teli walema ou wendo orumu suku-singine Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena pupe yemboma mane sirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda ye awilimene konopu awisili liku mundukulie ningendo: “Nambepa iyemo pilipe konginjeli pelemoye? Yu sukuli awili tenga naa purumu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesusini topondopa nimbendo: “I ungu nimbu siliomo nanga ungu te molo. Na lipe mundorumu-ne orundu yemonga ungumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","‘Pulu Yemone “Teaa.” nilimo ulume pilipu lipu teambo.’ konopu lepa molemo yembomone nane ungu nilio ungumunge pulumu pilipelie, ‘Nane Pulu Yemonga ungumu nilimo.’ molo ‘Yuni yuyu konopuni pilipe nilimo.’ nimbe pilimbe. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yembo tene yuyu konopuni pilipelie ungu nimbe silimomone ‘Nanga imbi ola molopili.’ nimbe telemo, nalo yembo tene ‘Lipe mundorumu yemonga imbimu lipu ola mundundembo.’ nimbe kongono telemo yembomo yu sumbi nili yembo te molopa, tepa kenjipe kolo toli yembo te naa molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ou Mosisini eno Pulu Yemonga ungu manema naa sinderimuye? Sirimu nalo eno molemelemanga telurini kepe kanu ungu manema pilku tenge panjiku naa telemele. Aku liemo ‘Na kanu ungu manema pulue tolemo.’ ningu nambemune toko kondonge tekemeleye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yuni aku sipe nirimu pilkulie yembomane topondoko ningendo: “Nawene nu topa kondomba tekemoye? Nunge konopune kuru te molemomonga pilkulie aku siku nikinu lepamo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesusini enondo topondopa nimbendo: “Nane ulu tondolo te terindu kinie eno konopu awisili liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosisini ‘Kangomanga kangi te makaye teko kopisiengi.’ nimbe ungu mane sipe panjerimumunge eno koro molemele wale Sambatemo kinie kangomanga kangi te makaye teko kopisilimele. (Sike Mosisini ou pulu pulu ‘aku ulumu teamili.’ ni naa nirimu. Ou enonga anda-kolepalimene aku ulumu teringi, nalo pe Mosisini kanu ungu manemo sipe panjerimumunge pilkulie telemele.) ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Enone Mosisini ungumane sirimumu pilku likulie kango tenga kangi te kopisinge walemo eno koro molemele wale Sambatemo wendo olemo kinie kopisilimele liemo kapola na Sambate walemo kinie ye te tepo konde lsindumunge na-kinie nambemune mumindili kolemeleye? ⸤Sambate walemo kinie kango tenga kangi te kopisiku wendo likulie ‘Papu tekemolo.’ ningi liemo Sambate walemo kinie nane ye tenga kangi pali tepo konde lio akumu papula telio.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Enone mongone kanolemele ulume kanokolie sumbi siku ‘Imu sike. Imu kolo.’ ningu naa piliengi! Ulume mimi siku kanoko konopuni pilkulie sumbi siku apuruku kondangi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yu aku sipe nimbe molopili Jerusalleme moloringi yembo marene eno enono walsiku pilkulie ningendo: “I yemo ‘Topo kondamili.’ ningu molemele yemo naa molemoye? ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nalo kaname. Yembo awisili molemelena yu mona omba angilipe ungu mane sikimu nalo ye awilimene yu ulu te naa tekemele. Enone ‘Yu sike Pulu Yemone ‘Olio nokopa kondomba ye te lipu mundumbo.’ nirimu ye nomi Kirasimu.’ ningu pilkimilinje? ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nalo olione iyemonga pulu koleamo kanolemolo. Pulu Yemone lipe mundumbe ye nomi Kirasimu ombá kinie yembo tene yu molopa ombá koleamo naa kanopa imbi simbe.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kanu kinie Yesusi, ou ulke tembelena ungu mane sipe molorumu mele we sipe molopalie, ru nimbelie nimbendo: “Sike enone na kanoko imbi siku, na molopo ondu koleamo kanolemeleye? Na nanu konopuni pilipulie naa orundu. Na lipe mundorumu-ne orundu yemo yu-kinie sike ulu pulumu pelemo yemo. Kanu yemo eno naa pilimele ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nalo na yu pea molopolie, yuni na lipe mundorumu-ne orundu akumunge nane yu kanopo imbi silio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aku nirimu kulu pilkulie yu ambolko liku ka singe teringi nalo yu tonge walemo ou wendo naa orumu kulu yembo tene yu naa ambolorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yembo awisilini aku tenge teringi nalo yembo awisilini ningendo: “Pulu Yemone ‘Lipu mundumbo.’ nimbe mako torumu ye nomi Kirasimu ombalie nimbemone, iyemone yu molemo mele lipe ora silimo ulu tondoloma telemo mele kanu yemone ulu tondolo olandopama manda tembaye? ‘Ye nomi Kirasimuni temba.’ nimbu pilimolo ulume i yemone telemo.” ningulie ‘Yu sike kanu yemo.’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yembomane aku sipe Yesusi molorumu mele aku siku anjo yando olo toko kerepale niringi mele Juda ye awili Parisimene pilkulie niringimuni, eno kinie Pulu Yemo popo tondoringi ye awilime kinie enone ulke tembele ele ye mare “Yesusi puku ka si-pe!” ningu liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kanu kinie Yesusini nimbendo: “Laye-kolo mindi eno kinie molopolie, pe na lipe mundorumu yemo molemona kelepo pumbo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pe enone na koronge nalo naa kanoko, molombona manda naa onge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda ye awilimene enono anjo yando kerepale ningulie ningendo: “Yu tena pumbe-na olio manda yu naa pupu kanomoloye? Aku liemo olionga Juda yembo mare ou kolea lupemanga puringi molemele koleamanga pupe yembo talape lupema ungu mane sipe molomba-na naa kanomolonje? ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yuni ou nimbendo: “Na koronge nalo enone na naa kanonge. Na molombona eno manda naa onge.” nimu kanumu ungu pulumu nambolkanje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pe, yemboma Jerusalleme ongo maku toko kake teli walemanga ulume teringi walema pora nimbéndo wale awilimu wendo orumu kinie Yesusi ola angilipelie tondolo mundupelie nimbendo: “Yembo te no waka kolomu liemo na moliona omba no nopili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na molio nilio mele “Sike.” ningu tondolo munduku pilinge yemboma enonga konopumenga konde molopa mindi puli noma pikipe wendo ombá. Pulu Yemonga bokune ungu te aku sipe nimbe molemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yuni ungu nirimumunge pulumu isipe: “Yu Pulu Yemone sike lipe mundorumu, olio lipe tapondomba yemo molemo.” ningu tondolo munduku pilinge yemboma pe walse Pulu Yemonga Minimu enonga konopumenga omba molomba lingemondo nirimu. Yesusi ou kolopa lomboropa ola molopa mulu koleana kelepa olando naa purumu kulu Minimu ou naa oli. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yembomane Yesusini ungu nirimume pilkulie, marene ningendo: “I yemo Mosisini ‘Pulu Yemonga ungu umbu tondombama pilipe yemboma nimbe simbe ye te ombá.’ nirimumu i yemo lemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Marene ningendo: “Yu Pulu Yemone ‘olio nokopa kondomba lipu mundumbo.’ nimbe mako torumu ye nomi Kirasimu.” niringi. Marene ningendo: “Pulu Yemone lipe mundumbe ye nomi Kirasimu kolea Gallilli disiriki molopalie ombáye? Yu Gallilli naa menge. Pulu Yemonga bokumuni nimbendo: ‘Pulu Yemone lipe mundumbe ye nomi Kirasimu ye nomi kingi Depisini kalopa limbe. Depisi yu meringi Betellieme taono akune ye nomi Kirasimu menge.’ nilimo kanumunge yu Gallilli disiriki manda naa menge lemo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aku siku yemboma Yesusi molorumu mele kerepale ningu konopu lupe lupe lieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yembo marene ‘Yesusi ka siemili.’ konopu leko moloringi nalo tene yu pupe ambolopa naa lsimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ulke tembele ele-yema Yesusi kinie yemboma kinie ningu moloringi mele pilku molkolie, pe we kelko yando ongo Pulu Yemo popo tondoringi ye awilime kinie Parisi yema kinie moloringine puringi. Yesusi ka siku naa mengo oringi kulu kanokolie enone ele yemando ningendo: “Yemo nambemune naa mengo ongiye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ele yemane ningendo: “Molo. Ye tene ou ungu mane silimele mele yuni aku sipe naa simu. Yuni ungu mane paa olandopa simu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisimene pilku keri pilkulie ningendo: “Yuni kolo topa ungu nimume ‘Sike nimu.’ konopu leko eno we kelko yando ongiye? ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Olionga ye awilime kinie Parisi yema kinie olionga ye tene “Yu molemo nilimo mele sike akumu molemo.” nimbe piliemuye? ⸤Molo, tene aku sipe naa nimbe piliemu kanumu.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nalo we yembo maku toko molongime Mosisini ungu mane sirimu pelemoma paa naa pilimele. Pulu Yemone enonga kotemo koronga pilipe, kolonge kinie ‘Mindili nangi.’ nimbe panjerimu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimasi, yu ou walse Yesusi molorumune purumu ye kanumu, Parisi ye kanumenga te yu, yuni eno walsipelie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Olionga ungu manemane ‘Yembo te kote naa pilkulie we mongo liku sie.’ nilimoye? Yu ou kotena ombalie nilimo mele pilipulie pe ungu nilimomanga pulume apurupu pilimolo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Parisi yemane yundu topondoko ningendo: “Aku nu kepe kolea Gallilli ye teye? Pulu Yemonga bokune sukundu mimi siku kanani. Mimi siku kanokolie, ‘Pulu Yemone ungu umbu tondolime pilipe yando nimbe simbe ye te Gallilli wendo ombá.’ nimbe pelemo kanoníye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yemboma pali ulkendo bulu-balu ningu puringi ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","nalo Yesusi ma pangi te ‘Ma Pangi Unjo Ollipi Ponie’ nili akune olando purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kanu kinie kolea tangorumu kinie ipulueli-ou yu kelepa ⸤Pulu Yemo popo toko kaloringi⸥ ulke tembelena purumu kinie yemboma yu molorumune ongo maku toko moloringi kinie eno ungu mane simbendo yu manie molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kanu kinie Pulu Yemonga ungu manemanga pulume pilku mane siringi yema kinie Parisi yema kinie enone ambo ye puli te ye te kinie wa ulu kerinele teringilimu liku mengo ongo yemboma moloringi kumbi-kerena ongo anjikulie, ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesusindu ningendo: “Ungu Mane Silimu, i ambo ye pulimu ye te kinie wa ulu kerinele teko molongili yembomane kanongi-ne membo okomolo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosisini ungu mane te sipe panjipelie nimbendo: “Amboaku tembamo kouni toko kondaa.” nirimu kene nuni nambolka niniye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nalo enone sike pilingendo naa niringi. ‘Yuni nambolka nimbenje? Nimbe kenjimbe kinie kote tendemolo.’ ningu aku siku walseringi. Nalo Yesusi ma kanopa kimuni mana ⸤we⸥ imbi topa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kanu kinie yu alieli walsi-pou-pou teringi kulu olando sipe kanopalie enondo nimbendo: “Enonga ye te ulu pulu keri te naa pelemo ye tene i ambomo kumbi lepa kouni topili.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aku nimbelie yu kelepa ma kanopa mana we imbi topa molorumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aku nirimu kulu pilkulie ye awilime eno te talo ningu pena pena puku Yesusi munduku siye kolko eno puringi. Ye awilimenga ye nomime ou kumbi leko puringi kanu kinie we ye awilime akilku puringi kinie ye awili te Yesusi kinie naa molopa yuyu molopa, ambomo yu molorumune we angilierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kanu kinie Yesusi olando sipe kanopalie ambomo walsipelie nimbendo: “Ambomo, yema tena molemeleye? Ye tene nu ‘Teko kenjenumunge kote tendambo.’ naa nimuye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ambomone nimbendo: “Awilimu, tene na kote naa tendemba tekemo.” nirimu. Yesusini nimbendo: “Nane kepe ‘Nuni teko kenjenumunge mongo lieni!’ naa nikiru kene nu pukulie ulu pulu keri teleno mele munduku siye kolko kelko naa tei!” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yembo moloringimendo Yesusini kelepa nimbendo: “Na ma koleamanga pali yembomanga patendelimu. Naandopo molombona lombili andoko molonge yemboma sumbulu toline naa andoko molonge. Konde mololi ulu pulumu silimo patelimu kinie molonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aku nirimu kulu ye awili Parisimene pilkulie yu karaye tekolie ningendo: “Nu moleno mele nunu ningu silino kene nuni ungu nikinume pilipulie ‘Sike nikimu.’ nimbu pilimelanje manda naa telka.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusini topondopa nimbendo: “Na ou molopo orundu koleamo kinie kelepo pumbo tekero koleamo kinie pilipu moliomonga na molio mele sike nanu nilio nalo nane iungu nikirumu sike ungumu. Nalo na molopo orundu koleamo kepe pe pumbo tekero koleamo kepe eno naa pilkimili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mana yembomane pilku apuruku telemele mele eno Parisi yemane aku siku pilkulie apurulimele, nalo nane yembo te naa apurulio. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nalo nane sike pilipu apurulkenje na nanu manjipu naa apurulkemonga sumbi sipu apurulke. Na lipe mundorumu ye Tata kinie pea tapu topo molembolomonga sumbi sipu pilipu apurulke. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enonga ungu mane te bokune molemo kanumu isipe: ‘Yembo talone ungu te ningu singili liemo ‘Aku ungumu sike.’ niengi.’ aku sipe nimbe pelemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Akumunge na molio mele nanu nimbu silio kepe; na lipe mundorumu ye Tatane na molio mele nimbe silimola.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kanu kinie enone walsikulie ningendo: “Lanie tena molemoye?” niringi. Yesusini topondopa nimbendo: “Enone na kepe nanga Lapamo kepe naa kanoko imbi silimele. Enone na kanoko imbi silimelanje Tata kepe kanoko imbi silimela.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesusi ulke tembelena sukundu, Pulu Yemonga ningu yembomane kou mone siringi unjo ketema lierimu koleana molopa yemboma ungu mane sipe molopalie iungume nirimu. Nalo yunge walemo wendo naa orumu kulu yembo tene yu ambolko liku ka naa siringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesusini altopa Juda ye awilimendo nimbendo: “Nakinie pumbo tekero, kanu kinie enone na koroko kelkolie enonga ulu pulu kerime konopune pepili kolonge. Na pumbo koleana eno manda naa onge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aku nirimu kulu pilkulie Juda ye awilimene enono kerepale ningu walsikulie ningendo: “Aku nambemune ‘Napumbo koleana eno manda naa onge.’ nikimuye? Akuliemo yu yuyu topa kondombanje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesusini kelepa nimbendo: “Eno manie yemboma, naola yemo. Eno ma kolea pulu yemboma, na ma kolea pulu ye te molo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nane enondo ou nimbondo: “Ulu pulu kerime konopune we pepili kolonge.” nindu kanumu. Akumu “Na kinié molio ou-pulu-pulu molorundu pe molopo mindi pumbo yemo.” nimbu silio mele enone ‘Sike akumu molemo.’ ningu tondolo munduku naa piliengi liemo pe eno kolonge kinie sike enonga ulu pulu kerime konopune we pepili kolonge.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Parisi yemane yu walsikulie ningendo: “Nunaweye?” niringi. Yesusini topondopa nimbendo: “Na molio mele eno alieli nimbu silio kanumu na mindi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nane eno molko ulu telemele mele pilipu apurupulie enone teko kenjilimele mele ungu awisili nimbu silke nalo nanu konopuni pilipulie ungume naa nilio. Na lipe mundorumu yemo, yuulu sikema mindi tepa ungu sikema mindi nilimo ye, kanumuni nilimo mele mindi pilipulie mana yemboma nimbu silio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yuni Lapando nirimu nalo eno yuni nirimu mele pulumu naa pilieringi kulu ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesusini enondo nimbendo: “Pe enone Manie Omba Mana Ye A Lierimu Yemo ola uku toko panjinge kinie enone pilkulie “Na kinie molio ou-pulu-pulu molorundu pe molopo mindi pumbo yemo.” nimbu silio mele enone ‘Sike akumu molemo.’ ningu pilkulie kepe, “Na nanu konopuni pilipulie naa telio. Tatane na mane silimo mele mindi pilipulie nilio.” alieli nimbu silio ‘Akumu sike lemo.’ ningu pilinge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na lipe mundorumu-ne orundu yemo na kinie pea tapu topo molembolo; alieli yu kanopa peanga kanolemo ulume mindi teliomonga yuni walsikele kepe na mundupe siye naa kolemo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yuni aku sipe nimbe molopili kepe yembo awisili ‘Yesusi yu Pulu Yemone sike lipe mundorumu.’ ningu tondolo munduku pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","‘Yu sike.’ ningu pilieringi Juda yembomando Yesusini nimbendo: “Nane ungu mane silioma sike pilku liku tenge panjiku molongi liemo eno sike nanga lombili andolime molonge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aku tekolie, enone sike ungumu pilinge kanu kinie eno ka silimo melema sike ungumuni wendo lindipe ‘eno we molko kondangi.’ nimbé.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Enone topondoko yundu ningendo: “Olio Eporayamone kalopa lsimu yemboma molopo, yembo tenga ka kongono te naa tendepo molorumulu. Aku liemo nuni ‘Ka silimo melema wendo pumbe olio molko kondonge.’ ninu kanumu nambeko pilkulie ninuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesusini topondopalie nimbendo: “Nane eno paa sike nimbu sikirumu: Yembo ulu pulu keri telemelema ulu pulu kerimene ka silimo kinie aku ulu pulu kerimenga ka kongono telemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ka kongono telemo kendemandemo ulke pulu yemboma kinie pea kamu naa molemo, nalo ambolango te yunge ulke pulu yemboma kinie alieli telune tapu toko molemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Akumunge ⸤Ulke Pulu Yemonga⸥ Malone ‘Eno ka silimo melema mundupe siye kolopili, eno we molko kondangi.’ nimu liemo meltene sike ka naa simbe, we paa sike molko kondonge. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","‘Eno Eporayamone kalopa lsimu yemboma molemele.’ na pilipu molio nalo enonga konopune nanga ungumu naa pelemomonga na toko kondonge tekemele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nane Tata kinie molopolie kanorundu mele eno nimbu silio. Enone enonga laniene nilimo mele pilkulie telemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesusini yembomando “Eno lanienga ungumu pilkulie telemele.” nirimu kinie pilkulie Juda yembomane topondoko ningendo: “Olionga lapa kalopa lsimumu Eporayamo.” niringi. Yesusini nimbendo: “Molo. Eno sike Eporayamone kalopa lsimu yemboma molemelanje Eporayamone terimu mele eno aku siku telemela. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nalo aku naa telemele. Pulu Yemone na nimbe sirimu ungume na pilierindu ungu sikema eno nimbu silio yemo toko kondonge tekemele. Eporayamone aku sipe naa terimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eno enonga laniene telemo mele manda manjiku telemele.” nirimu. Enone tondolo karaye tekolie ningendo: “Olionga anumu ye te lupe kinie wapora topalie olio naa merimu. Olionga lapa kanumu Pulu Yemo telu mindi.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesusini enondo nimbendo: “Na Pulu Yemo kinie molopolie orundu ya moliomonga Pulu Yemo yu sike enonga Lapa lelkanje enone na konopu mondolemela. Nananu konopuni pilipulie naa orundu. Yuni na lipe mundorumu-ne orundu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nane ungu niliomanga pulumu nambemune sumbi siku naa pilimeleye? ‘Ungu pulumu naa pilimolo.’ ningu liku su silimele akumunge nanga ungumu eno naa pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eno Depelemonga ambolangoma, Setene enonga lapamo. Laniene kanopa peanga kanolemo mele ‘teamili.’ ningulie yuni “Eno teaa.” nilimo mele ‘Paa teamili.’ nilimele. Ou-pulu-pulu mulu maselo kokele wendo orumu kinie yu yembo topa kondoli yemo molorumu mele aku silimu yandopa kinié we molemo. Yu sike ungu pulu te naa perimu-ne sike ungu te walsikele kepe paa naa nirimu. Yu kolo tolemo yemo; yu sike kolo toli ungumunge pulu yemo molemomonga ou yu kolo torumu mele yandopa kinié kepe pe kepe kolo mindi tolemo tomba. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nalo nane ungu sikema nimbu siliomonga eno naa pilku ‘Kolo tolemo.’ ningu pilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Nawene nanga konopune ulu pulu keri telu kepe pelemo manda lipe ora simbeye? Te naa pelemo nalo nane ungu sikemo nindu liemo ‘Sike nikimu.’ ningu eno nambemune naa pilimeleye? ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pulu Yemonga ambolangomane Pulu Yemone nilimo ungumu pilku limele. Eno Pulu Yemonga ambolangoma naa molkolie yunge ungumu nane nimbu silioma “Naa pilimolo.” ningu naa pilku limele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda ye awilimene yundu topondoko ningendo: “ “Nu Sameria ye te moleno, nunge konopune kuru te molemo.” nilimolo kanumu sike nilimolo.” niringi. ⸤Juda yembomane Sameria yemboma kinie konopu keri panjeringi kanumunge yu iri toko ungu taka tondoko “Yu ye keri te.” ningendo “Nu Sameria ye te.” niringi.⸥ ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Niringi mele pilipelie Yesusini topondopa enondo nimbendo: “Nanga konopune kuru te naa molemo. Nane Tatanga imbi lipu ola mundundulio, nalo enone nanga imbi teko kenjindilimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nanu ‘Imbi ola molopili.’ naa nilio, nalo ye te molemo akumuni ‘Na imbi ola molopili.’ nimbe nanga imbi lipe ola mundundulimo. Kanuyemone nane nilio mele kepe enone nilimele mele kepe mimi sipe pilipe apurupe tene ‘Sike nikimu.’ nimbe pilipe molemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nane enondo paa sike nimbu sikirumu: Yembo te nanga ungumu pilipe lipe tepa molomba yembomo paa kamu naa kolopa molopa mindi pumbe.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda ye awilimene yundu ningendo: “Kinié olio pilkimulu, kuru te paa sike nunge konopune molemo lemo. Anda kolepa Eporayamo kolorumu; Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yema koloringila. Nalo nuni ninindu: “Nanga ungumu pilipe lipe molomba yembomo kamu naa kolomba.” nikinu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eporayamonga imbi manie mele molopa nunge imbi ola molemoye? Yunge imbi paa ola, nalo yu kepe kolorumula. Pulu Yemone ungu umbu tondorumume pilku yemboma ningu siringi yemboma kepe imbi ola molorumu nalo koloringila. Nunge imbimu ola enonga imbime manieye? Paa molo! Nu koropamo.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesusini topondopa nimbendo: “Nane nanga imbi nanu lipu ola mundulkenje na imbi paa sike ola naa molka, na we mindi nilke. Nalo akumu molo. Tata, yundu enone “Olionga Pulu Yemo.” nilimele kanumuni nanga imbi lipe ola mundundulimo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Enone yu naa kanoko naa pilimele nalo nane yu kanopo pilio. Nane “Yu naa kanopo naa pilio.” nilkenje eno kolo tolime molemele mele na aku sipu molka. Nalo nane yu paa sike kanopo pilipu, yunge ungumu pilipu lipu tepo molio. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Enonga anda kolepa Eporayamone na mana manie ombó walemo kanomba pilipelie konopu sipe molorumu. Kanu walemo kamu kanopalie konopu sirimu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kanu kinie Juda ye awilimene yundu ningendo: “Nunge ponie tokapu talo ou naa pora nili. Nu kango yemo mindi. Pe nu “Eporayamo kanorundu.” nikinuye? Nuni yu manda naa kanorunu. Kolo tokono.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesusini enondo nimbendo: “Nane enondo paa sike nimbu sikirumu: Eporayamo sike paa koronga ou molopa kolorumu nalo yu ou naa molopili na molorundu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aku nirimu kulu pilkulie enone “Yu topo kondamili.” ningu kou liku yu tonge teringi. Nalo Yesusi lopi tepalie, ulke tembelena kiyengo nimbe omba ulsu purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesusi aulkena pumbe purumu kinie mongo keri lierimu ye te molorumu kanorumu. Anumuni olona sukundu mongo keri lielimu merimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pe yu lombili andoli yemane yu walsikulie ningendo: “Rapai, nawene ulu pulu keri terimumunge iyemonga anumuni yu olona sukundu mongo keri lielimu merimuye? Yemo yuyu terimu molo anumu lapaselone teringiliye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesusini nimbendo: “Yemo yuni kepe anumu lapaselone kepe ulu pulu keri te teringi ne yu mongo keri naa lierimu. ‘Pulu Yemonga ulu tondolo te iyemo kinie mona wendo opili yemboma pali kanangi.’ nimbe iyemo mongo keri lierimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iwalemo pora naa nimbe ena ou naa pupili na lipe mundorumu yemonga kongono paa temolo. Ipu lemba kinie yembo tene manda kongono naa temba. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na ima koleana molopolie, na ma koleana yembomanga patendelimu molio.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aku nimbelie yu mana lkambe topalie mamo kinie ambolopa topele-mapele topalie yemonga mongoselonga kandopalie nimbendo: ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Nu no-mongo Silloamo puku kumbi-kerena no le-pou.” nirimu. (Silloamonga ungu pulumu ‘lipe mundoli’.) Yu akune pupe kumbikerena no lierimu kinie mongoselo peanga lierimu, melema kanolipe ulkendo purumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kanu kinie yunge kolea yemboma kinie “Yu koumone siee.” nimbe ou aulkena mawa tepa molorumu kanoringi yemboma kinie yu aku sipe orumu kanokolie enone enono anjo yando kerepale ningu walsikulie ningendo: “I yemo ou “Kou mone sie.” nimbe mawa tepa molorumu kanu yemonje?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Marene ningendo: “Sike, yu aku yemo mindi.” niringi. Marene ningendo: “Molo. Elo kumbi-kere telu sipe nalo iyemo lupe.” niringi. Nalo yemo yuyu tondolo mundupelie nimbendo: “Yekanumu na mindi.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Enone topondokolie ningendo: “Nunge mongoselo nambe-enu kinie peanga liemuye?” niringi kinie ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","yuni topondopa nimbendo: “Ye te ‘Yesusi’ nilimele kanumuni olí lipe mongoselonga ape kandopalie nimbendo: “No-mongo Silloamo puku kumbi-kerena no le-pou.” nimukinie pupu kumbi-kerena no le-pondu kinie nanga mongoselo peanga liemu-ne kolea kanondu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Aku yemo tena molemoye?” niringi kinie “Na naa kanondu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ye ou mongo keri lierimumu yembomane Parisi yema moloringine mengo puringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kanu kinie, Yesusini le-olí lipe yemonga mongoselonga ape kandopalie yemonga mongoselo ‘altopa peanga liepili.’ nirimu kanu walemo ⸤Juda yemboma koro moloringi⸥ wale Sambate kinie terimu, ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","akumunge Parisi yemane kepe yu walsikulie ningendo: “Nunge mongoselo nambepa peanga liemuye?” niringi. Yemone topondopa nimbendo: “Nanga mongoselonga oli ape kandomu kinie na kumbi-kerena no lepolie kinie na mongone kanokoro.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi ye marene ningendo: “I yemo Sambate walemo naapilipe we andolemo, aku sipe ulu pulu keri telemomonga Pulu Yemone yu naa lipe mundorumu lemo.” niringi. Nalo marene ningendo: “Pulu Yemone lipe tapondomba kinie mindi yembo tene iulu tondoloma mele manda temba aku sipe mele ye ulu pulu keri telemo tene manda telkaye?” niringi. Akumunge eno anjo yando kerepale ningu konopu telune pupili naa moloringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Akumunge mongo ou keri lierimu yemo altoko walsikulie ningendo: “Kanu yemone nunge mongomo tepa peanga tendemu akumunge yundu nu nambolka konopu lekenoye?” niringi. Yemone topondopalie nimbendo: “Yu Pulu Yemone ungu umbu tondolemoma pilipe yemboma nimbe silimo yete.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nalo Juda ye awilimene “‘Iyemo ou yunge mongomo paa sike keri lierimu, pe kinié peanga liemu.’ nimbu ‘sike lemo.’ we naa nimolo. Yu olio kanopo imbi naa silimolo kene anumu lapaselo walsipu piliemili wale.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kanu kinie anumu lapaselo oringili kinie walsikulie ningendo: “I yemo elonga marenaye? “Anumuni merimu kinie mongomo keri lierimu.” nilimbele kanu yemo imuye? Aku liemo kinié nambepa mongone kanolemoye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Anumu lapaselone topondokolo ningelendo: “Yu sike oltonga malo, anumuni merimu kinie yunge mongomo keri lielimu merimu yemo olto kanokombolo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nalo kinie yunge mongoselo peanga liemumu nambepa temunje olto naa kanombulu. Yu nawene mongoselo tepa peanga tendemunje akumu olto naa la kanombulu. Yu yemo molemo kene yu temu mele yuyu nimbe sipili yu walsiku piliee.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anumu lapaselo Juda ye awilime pipili kolkololie aku siku niringili. Juda ye awilimene ou ningu panjikulie ningendo: “Yembo tene ‘Yesusi yu sike Pulu Yemone lipe mundorumu ye nomi Kirasimu.’ nimu liemo aku yembomo ulke maku topo Pulu Yemonga ungumu pilimolo ulkemanga naa opili kamu makoromolo.” niringimunge aku siku niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ou ye awilimene akusiku ningu panjeringimu anumu lapaselo pilkululie “Yu yemo kene yuyu nipili walsiku pilie.” niringili. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Juda ye awilimene kelko talo siku ou mongo keri lierimu yemo “Ou.” ningulie yundu ningendo: “Nuni ‘Pulu Yemo pilipe molemo.’ ningu kolo naa toko, nu temu mele sumbi siku olio piliemili ningu si! ⸤Olio Pulu Yemonga ungumu mimi sipu pilimolo yemane pilkimulu,⸥ “Nunge mongo tepa peanga tendemu.’ nikinu yemo yu ulu pulu keri teli yemo.’ nimbu pilkimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yuni enondo topondopa nimbendo: “Na mongo tepa peanga tendemu yemo ulu pulu keri teli yemo molo molonje, na naa pilkiru. Nalo ulu te na paa sike pilkiru. Ou nanga mongoselo paa sike keri lierimu nalo kinie nanga mongoselo peanga liemu-ne kolea kanokoro, akumu na paa pilkiru.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kanu kinie enone yu walsiku pilkulie ningendo: “Yuni nu nambe-emuye? Nambolka uluri temu kinie nunge mongoselo peanga liemuye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yuni topondopa nimbendo: “Nane eno ou nimbu sindu nalo naa pilingendo ungu nindumu liku su singi kanumu. Pe kinié nambolkare pilingendo altoko ‘ni!’ nikimiliye? Eno kepe yu lombili pungendo walsikimilinje?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kanu kinie enone yu kinie mumindili kolkolie iri toko ningendo: “Nu aku ye kerimunge lombili andolimu nalo olio Mosisinge lombili andolime. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","‘Pulu Yemone sike Mosisi kinie ungu nirimu.’ nimbu pilipulie ⸤‘Mosisi Pulu Yemonga ye awilimu.’ nimbu pilipu molemolo⸥ nalo iye kerimu yu terenga molopa orumunje, olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yemone topondopa nimbendo: “I yemone nanga mongoselo tepa peanga tendemu nalo yu tena molopa orumunje eno Pulu Yemonga ungumu mimi siku pilimele yemane naa pilimele akumu paa ulu te lupe. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Olio pilimolo, ‘Ulu pulu keri telemele yemboma Pulu Yemo mawa teko “Liku tapondou.” nilimele ungume naa pilimo. Yembo te ‘Pulu Yemonga imbimu olandopa molopili.’ nimbe ulume tepa molopa, yuni “Tei.” nilimo mele pilipe telemo yembomo Pulu Yemo mawa tepa “Liku tapondou.” nilimo ungume pilimo.’ akumu olio pilimolo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ou Pulu Yemone mulu maselo terimu kinie kepe yandopa kepe yembo te anumuni merimu kinie olona sukundu mongo keri lierimu yembomonga mongomo yembo tene tepa peanga tenderimu ningu temane telu kepe ou tene naa toringi pilierimulu kanumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pulu Yemone iyemo lipe naa mundulkenje yuni aku sipe ulu tondolo te manda naa telka.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yuni aku nirimu kulu pilkulie enone topondoko ningendo: “Nu aminiene merimu kinie ulu pulu keri awisili pepili merimu. Pe kinié nuni ‘olio mane siembo.’ konopu lekolie nikinuye?” niringi. Aku ningulie yu ⸤Pulu Yemonga ungumu pilieringi ulkena kamu⸥ makororingi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Juda ye awilimene Yesusini mongo tepa peanga tenderimu yemo ⸤Pulu Yemonga ungumu pilieringi ulkena⸥ kamu makororingi kinie pilipelie Yesusi yu pupe kanopalie nimbendo: “Nu Manie Omba Mana Ye A Lierimu Yemo ⸤‘Yu sike Pulu Yemone lipe mundorumu⸥’ ningu tondolo munduku pilkinu molo moloye?” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yemone walsipelie nimbendo: “Ye Awilimu, iye nikinumu yu naweye? Nane ‘yu sike aku yemo molemo.’ nimbu tondolo mundupu piliembo kene ningu si.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesusini nimbendo: “Kanu yemo nu kinie kanoko moleno. Kinié nu-kinie ungu ningu molkombele akumu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kanu kinie ye kanumuni nimbendo: “Awilimu, kinié ‘Nu aku yemo sike lepamo.’ nimbu tondolo mundupu pilkiru.” nimbelie Yesusinge imbi lipe ola mundundupe yu kapi nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesusini nimbendo: “Na ‘yemboma ulu pulu keri teko molemele mele mona liepili piliengi!’ nimbu ma koleana orundu. ‘Yembo mongo keri lemoma mongone melema kanoko, mongo peanga lemoma mongone melema naa kanangi.’ nimbu ma koleana orundu.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi ye yu pea moloringi marene yuni aku nirimu pilkulie ‘Yu ungu iko te topa oliondo nikimunje?’ ningu yu walsikulie ningendo: “Nu nambolka ningu nikinuye? Olionga mongoma keri lemolaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesusini nimbendo: “Enonga mongoma keri lelkanje enonga ‘konopune ulu pulu kerime pelemo.’ ningu pilkulie, ⸤Pulu Yemondo⸥ “‘Ulu pulu kerime manie pupe konopu peanga liepili.’ ni.” nilimela. Nalo “Mongone melema kanolemolo.” nilimelemonga enonga ulu pulu kerime konopune we pepili molemele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Walse Yesusini yembo moloringimendo nimbendo: “Nane enondo paa sike nimbu sikirumu: Ye te kongi sipisipi pala kerepulune suku naa pupe, we tenga topa tangondopa pulimo yemo yu wa noli yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nalo ye tekerepulune suku pulimo yemo yu sipisipi nokoli yemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kerepulu nokoli yemone yunge kune lindilimo. Sipisipimene nokoli yemonga ungumu pilimele, yunge sipisipimenga imbime lepa pala kerepulune ulsu memba pulimo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yunge sipisipime wendo lipelie, yu kumbi lepa pulimo kinie yunge ungumu pilkulie eno lombili pulimele. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ye lupe tenga ungu nilimomo naa pilkulie yu lombili naa puku talopa leko pulimele.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesusini aku ungu ikomo topa sirimu nalo ungu pulumu naa pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesusini ⸤kongi sipisipimenga ungu ikomo topalie nirimumuni, ungu pulumu naa pilieringi kulu⸥ kelepa ungu te pea nimbendo: “Nane enondo paa sike nimbu sikirumu: Na sipisipimenga pala kerepulumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yembo lupe ou na naa wambo oringi yemboma wa noli yema mindi, nalo enonga ungume sipisipimene naa pilieringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na kerepulumu. Yemboma ‘Sukundu pamili.’ ningulie na molombona ongema mindili nolemela aulkena wendo ongo na-kinie kapola molko sukundu puku pena ongo era nongo tengemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wa lili yemo wa nomba topa kondopa tepa kenjimbendo mindi olemo. Nalo nane ‘Eno konde molko paa molko kondangi.’ nimbu orundu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na nanu kongi sipisipi tapu tepo kondolio yemo. Sipisipi tapu tepa kondoli yemone yunge sipisipime ‘Mindili naa nongo, kolou naa kolangi.’ nimbelie eno lipe tapondopa enonga nimbe kolo wangopa kolondomba telemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ye te yu sipisipi pulu yemo molo, yu we kou kongono mindi tepa sipisipime we nokondolemo, kanu we tapu tendeli yemo owa takera te ‘Sipisipi te topo nambo.’ nimbe olemo kinie kanopalie, yu sipisipime mundupe siye kolopa talopa lepa pulimo. Kanu kinie owa takeramone sipisipime topa bulu-balu silimo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yemo yu kou kongono teli yemo mindi molopalie, sipisipime kondo naa kolopa yu talopa mindi lemo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Na nanu sipisipi pulu yemo molopolie eno tapu tepo kondolio. Tatane na kanopa pilimo nane yu kanopo pilio mele aku sipe melela, nane nanga sipisipime kanopo pilio enone na kanoko pilimelela. Nane sipisipime eno ‘Naa kolangi.’ nimbu enonga kolo wangopo kolondombo. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nanga sipisipi mare lupe molemelela, i⸤Juda⸥ koleana sipisipime molo. Na kanu sipisipi wema kepe paa membo ombóla. Membo ombó kinie kanume nanga ungume pilku linge kinie pe sipisipime pali talape telumu mindi molonge, sipisipi pulu ye telu mindi molopa eno tapu tepa kondomba. Akumu na. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“‘Na kolambo.’ nikirumunge Tatane na konopu mondolemo. Nalo ‘ ‘Kolopolie onomo ono koleana kamu leambo.’ ni naa nimbu, ‘Lomboropo ola molambo.’ nimbo.’ nimbu pilipulie ‘Na kolambo.’ nikiru. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yembo tene na ‘Kolopili tambo.’ ni naa nikimu; nanu konopuni pilipulie ‘Kolambo.’ nikiru. ‘Na kolambo tangi.’ nikirumu nanu ‘Kolambo.’ manda nimbo. Kolopolie nimbomone, ‘Na altopo konde molambo.’ nimbomo nanu manda nimbo. Itembomo Tatane “Aku siku tei.” nirimu mele tembo.” nirimu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesusini aku nirimu kulu Juda yembomane pilkulie eno altoko konopu telune naa pupili yu-mele-mele konopu liku mundoringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yembo awisilini ningendo: “Yunge konopune kuru keri te molemomonga yu kekelepa topa aku sipe ungumu nimbe kenjilimo. Nambemune yunge ungumu pilkimiliye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nalo marene ningendo: “I ungu nikimume kuru te konopune molomba ye tene aku sipe mele manda naa nilke. Kuru tene nambepa yembo tenga mongo keri lielimu manda tepa peanga tendelkaye?” niringi. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kanu kinie Juda yembomanga ulu te wendo orumu wale te wendo orumu. Koronga ou yembo marene Pulu Yemo popo toko kaloringi ulke tembelena teko kake tenderingi walemo ponie tenga tenga pilingendo Jerusalleme maku toringi aku walemo wendo orumu. Aku walemo kolea ali tepa kalopera torumu walemanga wendo orumu. ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kanu walemo wendo orumu kinie Yesusi ulke tembele kerepulune ‘Sollomononga’ ningu takoko anjo lsingine andopa molorumu ");
INSERT INTO ubu_kala_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","kanu kinie yu molorumune Juda ye awilime ongo maku toko angilkulie yundu ningendo: “Olio konopu talo tepo naa lipu mundupu molamili kene Pulu Yemone “Olio nokopa kondomba ye te lipu mundumbo.” nimbe mako torumu y