﻿USE sofia;
DROP TABLE IF EXISTS sofia.ubu_andelale_vpl;
CREATE TABLE ubu_andelale_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ubu_andelale_vpl WRITE;
INSERT INTO ubu_andelale_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","⸤Isirele yombomanga u-pulu-pulu anda-kolepa⸥ Eporayamo kinia pe yandopa ⸤ononga ye nokoli kingi awili⸥ Depiti kinia olone Yesusi Karasi kalko liltingili mele i-sipa: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eporayamone Aisake merimu; Aisakene Jekopo merimu; Jekopone Juda kinia Judanga genupilima merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judane Péresi kinia Sera kinia merimu, kanu yetolonga anumu Tema; Péresini Esirono merimu; Esironone Ramo merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramone Aminadape merimu; Aminadapene Nasono merimu; Nasonone Sallimono merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sallimonone Boasi merimu, Boasi yunga anumu Reyapo; Boasini Opete merimu, Opete yunga anumu Rute; Opetene Jesi merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesini ye nokoli kingi Depiti merimu. Depitini Sollomono merimu. Sollomononga anumu u Yurayanga ambo menumu molorumu. Pe Depitini kanu ambomo yakala kolopa Yuraya topa kondopa ambomo yu liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sollomonone Riapoamo merimu; Riapoamone Apaya merimu; Apayane Eta merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Etane Josipate merimu; Josipatene Joramo merimu; Joramone Asaya merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asayane Jotamo merimu; Jotamone Eyasi merimu; Eyasini Esikaya merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esikayane Manasa merimu; Manasane Emosi merimu; Emosini Josaya merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josayane Jekonaya kinia yunga genupilima merimu. Josaya kolopili yunga malopili molangi opa-tou yomboma Isirele yomboma kinia ongo opa sekole toko munduku Isirele yombo awisili ka siku ononga kolea-awili Bepillono mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka siku mengo puringi kinia pe Jekonayane Sialtele merimu; Sialtelene Serapapele merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serapapelene Apayate merimu; Apayatene Ellayakimu merimu; Ellayakimuni Eso merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esone Sedoke merimu; Sedokene Ekimu merimu; Ekimuni Ellayate merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ellayatene Elliesa merimu; Elliesane Matano merimu; Matanone Jekopo merimu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopone Josepo merimu. Josepo Marianga menu. Josepone Maria u naa lipili Maria yu bolango olo mondopa molorumu. Pe ambo yetolo moloringili kinia Mariane Yesusi merimu. ⸤Pulu Yemone “Ono nokopa kondomba ye nokoli se lipu mundumbu.” u nimba taltorumu yemo pe Yesusi aku yemo omba molorumu-kulu⸥ yunga imbi se pea sikuli ‘Karasimu’ niringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eporayamo kinia Eporayamone yandopa-yandopa kalopa lipa Depiti kalopa lipa serimu yema ⸤Yesusinga⸥ anda-kolepa tene-po moloringi. Depiti kalopa lipale pe yandopa-yandopa u Bepillono yombomane Juda yombo mare ka siku kolea Bepillono anju naa mengo pangi kalopa liltimu anda-kolepa tene-pola moloringi. Juda yombo mare ka siku kolea Bepillono mengo puringi kinia pe yandopa-yandopa ye nokoli Karasimu kalko liltingi kinia ye tene-pola moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesusi, Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” nimba u nimba taltorumu ye nokoli Karasimu, yu meringi semanemo i-sipa: Yunga anumu Marianga pulu lierimu yombomane “Maria Josepone lipili.” ningu koronga niringi-na-kolo u Josepo pea seluna naa peangili Mini Kake Sélimuni Maria yunga olona bolango se mondondorumumu Maria yuyu pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kanu-kinia yunga ye Josepo yu ye sumbi nílimu molorumu-kulu Maria olo mondorumu kinia pilipale ‘Maria olie naa polopili.’ nimba ‘Yombo awisili molangi yu semu mele nimbu para naa sipu yu yuyu molomba kinia kiyongo nimbu we “Kamu pu.” niembo.’ konopu lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josepo aku sipa konopu kimbu sipa molopili Ye-Awilimunga angello sene Josepo uru kaima se sipa nimbale: “Josepo, ye nokoli kingi Depitini kalopa liltimu yemo, Mini Kake Sélimuni Maria ungu se serimu-kulu yu olo mondolemo kene nuni yu linindu pipili naa kolko, li.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","“Yu kango kanopa limba. Kanu kangomone yunga yomboma ‘Ononga konopuna ulu-pulu-kiri selemelema pepili molkole mindili nonge.’ nimba ono lipa tapondopa, mindili nolemolá aulkana wendo lipa, yu-kinia pea molko kondonge aulkana lipa mondomba kene yunga imbi siku “Yesusi” nieni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aku sipa wendo orumu uluma pali koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye sene ulu mare pe wendo ombá u nirimu mele kamu wendo orumu. Akumu i-sipa: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Piliayo. Ambo wenepo sene bolango olo mondopale kango se memba. Kanu-kinia yunga imbi siku “Imenuele” ningí.” nirimu. I imbimunga ungu-pulumu ‘Pulu Yemo olio-kinia molemo’ . ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josepo uru pepa makilipale Ye-Awilimunga angellomone nirimu mele pilipa lipa sepale ambomo liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aku-na-kolo yu bolangomo u naa mepili “Seluna naa peambili.” nirimu. Pe Mariane kango se merimu kinia Josepo yuni yunga imbi sipa “Yesusi” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erote kolea Judia disiriki yombomanga ye nokoli kingimu molopili Mariane kolea Judia, Betellieme taonona Yesusi merimu. Kanu walemanga ena wendo oli koleana pilipa kondoli peli ye pokore alieli ‘ulu mare wendo okomonje piliamili.’ ningu kombokandima mimi siku kanoko moloringi yema kolea-awili Jerusalleme ongo ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda yombomanga ye nokoli kingimu molomba kango meringimu sena molemoye? Olio ena wendo olemo koleana molopole ye se ye nokoli kingimu molomba meringimu lipa ora sili kombokandi se pulu-pulu wendo omba gilierimu kanopole nirimulumuni, yu popo topo imbi ambolopo paka tondomolondo okomolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ye nokoli kingi Erote i ungumu pilipale ‘Ye se yu kolali sepa kingimu molomba lepomo.’ nimba pilipale yu mini-wale mundupa, Jerusalleme yomboma pali mini-walela mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanu-kinia yuni Juda yombomanga Pulu Yemo popo tondoringi ye awilima pali kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema pali kinia, “Sukundu waa.” nimbale ono mangilipa pilipa nimbale: “Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” nimba, nimba taltorumu ye nokoli Karasimu sena mengemondo niringiye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Onone yundu ninguli: “Kolea Judia disiriki sukundu Betellieme taonona yu menge. Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye ⸤Maikane⸥ pe aku sipa wendo ombámondo u nimba boku torumu akuna molemo kanumu. Yuni nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betellieme, Juda koleana sukundu lemó kolea se, yu kolea Juda sukundu kolea-awilimanga yu kolea mania se mólo. Yunga sukundu ye nokoli awili se wendo ombá, aku yemone nanga Isirele yombomanga sipisipi tapu-yemo molopa ono nokomba.” nirimu kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kanu-kinia we-yomboma naa kanoko naa pilku molangi Erotene pilipa kondoli peli yema “Waa.” nimba kombokandimu pulu-pulu wendo omba gilierimu walemo mangilipa pilipale nirimumuni, yundu ningu siringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","pilipa onondo nimbale: “Ono Betellieme pungu kangomo wamoko koro-payo! Kanoko lendekole na ongo ningu sieyo. Na kepe yu ombo popo topo imbi ambolopo paka tondambo wambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kingimuni aku sipa nirimu pilkuli ono kelko pungu kano-puringi. Kanu-kinia ena wendo oli koleana molkole kombokandi kanoringimu ono puringina kumbi lepa pumbá pumbale kangomo molorumu ulka imuna pumba ola gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Onone kombokandimu kanokole konopu paa awili seko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ulkana sukundu punguli kangomo kinia anumu Maria kinia moloringilina pungu kanoko lenderingi. Kanokole kangomonga kumbikerena komorongo toko pondoko ma kanokole yu popo toko imbi ambolko paka tondoringi. Paka tondokole ono wale peanga mengo oringima apisiku méle peangama wendo liku yu siringi. Kou-gollo kinia, paura kalolemele kinia muna paa toli paura se kinia, wambola muna paa toli se kinia, aku mélema yu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kanu-kinia Pulu Yemone ono uru-kaima sipa onondo nimbale: “Ono Erote molemona kelko pu naa pangi, mólo.” nirimu kinia pilkuli ono aulka senga lupa ongole ulkando puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kanu-kinia pilipa kondoli peli yema kelko puringi kinia Ye-Awilimunga angello sene Josepo uru-kaima sipa nimbale: “Ye nokoli kingi Erotene nondopa yunga ami-yemando “Kangomo koroko toko kondo-paa!” nimbá kene nu ola molkole kangomo kinia anumu kinia liku mengo kolea Isipindu kowa pungu molo-payo. Ne anju molkole ningímuni, pe nane “Kelko yando waa.” nimbú kinia wangi. U mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aku nirimu kinia pilipale Josepo ola molopale ipulieli anungulutolo lipa memba Isipindu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","‘Erote kolomba kinia kelepo ulkando pumulú.’ ningu u Isipi anju moloringi. Aku seringimunga Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye ⸤Osia⸥ne ulu se pe wendo ombá u nirimu mele kamu wendo orumu. Akumu i-sipa: “Pulu Yemone nimbale: “Nanga kangomondo “Kolea Isipi munduku kelko wendo ou.” nirindu.” nirimu.” nimba kanu ye ⸤Osia⸥ne nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kanu-kinia anumu lapatolo Yesusi pea Isipi pungu molangi, pilipa kondoli peli yemane Erote yu liku peke tondoringi kinia pilipale Erote yuni mumindili paa awili sepa kolorumu. Mumindili kolopale ami-ye marendo nimbale: “Betellieme taono kinia Betellieme nondopa lemó koleama kinia kanumanga pungu kango kalia-ingi talo omba puli kangoma kinia kalia-ingi talo naa pora nili kangoma kinia koroko toko kondo-paa!” nirimu. Kombokandi kanoko pilipa kondoli peli yemane kombokandimu pulu polopa wendo omba gilierimu walemo yundu ningu siringi mele pilipale kalia-ingi aku sipa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aku sipa serimumunga koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Jeremayane ulu se pe wendo ombá u nirimu mele wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yuni nimbale: “Ono kolea Rama sukundu ungu se pilieringi; kola seringi pilku, yombo kololemele kinia kola selemele mele kola aku siku seringi pilieringi. Ambo Reselene yunga bolangomanga kola serimu. Yu ‘Konopu pe nipili.’ ninguli seringi-na-kolo yunga bolangoma naa moloringi-kulu yu kondo kolopa mindi molorumu.” nimba Jeremayane u aku nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pe Erote kolorumu kinia Ye-Awilimunga angello sene Josepo Isipi molopili uru-kaima sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ “Kangomo toko kondangi koro-paa.” nirimu yemo kolorumu kene ola molko anumu malotolo liku mengo kolea Isirelendo kelko pu.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","pilipale yu ola molopa anumu malotolo lipa memba Isirelendo purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aku-na-kolo Akellesi yunga lapa Erote kolali sepa ye nokoli kingimu molopa kolea Judia disiriki nokorumu pilipale Josepo yu kanuna kelepa pumbándo pipili kolorumu. Kanu-kinia Pulu Yemone uru-kaima sipa nimbale: “Marena tongenje kene akuna naa pu.” nimba yundu liepi-liepi torumu kinia yu kelepa kolea Gallilli disiriki pumba ");
INSERT INTO ubu_andelale_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akuna lierimu Nasarete taonona pumba molorumu-kulu Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane ⸤Yesusi-kinia⸥ ulu se pe wendo ombá u niringi mele kamu wendo orumu. Onone ninguli: “Yombomane yu imbi leko “Yu Nasarete taono ye se.” ningí.” niringi kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","⸤Yesusi Nasarete taonona we molopili⸥ No Lindeli Jono omba kolea Judia disiriki sukundu kolea ku lielina opa-ungu nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pulu Yemo ye nokoli kingimu molomba walemo nondopa wendo ombá sekemo kene ononga ulu-pulu-kiri seringi konopuna pelemoma munduku kelko konopu topele taa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kanu yemo ⸤u naa molopili paa koronga-u⸥ Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane Pulu Yemonga ungu se nimba sipa boku torumu. Kanu ungumu i-sipa: “Kolea ku lielina yombo senga kerena ungu se nimbale: “Awilimu ombá aulkamo seko wamondaa. Yu ombá aulka kangama toko sumbi siee.” nikimu.” nirimu. ⸤Jonone paa pe sembá mele Aisayane u aku sipa nimba panjipa bokuna torumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jono yu kongi kemelenga indimuni seli wale se pakopa, kongi kangimuni seli kako se topale, kuli-kulkumba kinia pilimu-no kinia aku langitolo mindi nomba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kanu-kinia kolea-awili Jerusalleme yomboma kinia Jerusalleme lierimu kolea Judia disiriki pali yomboma kinia kolea Jodane pali yomboma kinia kanu yemo molorumuna punguli niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","no Jodane sukundu punguli onone ulu-pulu-kiri seringima ningu para siringi kinia yuni ono no linderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yuni ⸤Juda yombomanga ye awili⸥ Parisima kinia Sadusima kinia awisili no lingíndu oringi kanopale nirimumuni, ono iri topa nimbale: “Kolo topa yomboma sepa kinjeli wambiyemonga waloma, Pulu Yemo mumindili kolomba walemonga nawene “Ono talopa leko paa.” nimu kinia ono ‘Pulu Yemone naa sepa kinjepili.’ ningu ‘No liemili.’ ningu okomeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ono sumbi siku molko, ulu peangama mindi seko molonge kinia ono ulu-pulu-kiri seringima paa sika munduku kelko konopu topele tonge mele mona lemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Olio anda-kolepa Eporayamone kalopa liltimu yomboma molemolomonga yombo peangama molemolo.” ningu aku siku ningu naa piliaa. Nane ono nimbu sikiru: ‘Pulu Yemone i koumando “Eporayamone kalopa liltimu yomboma au leangi.” nilkanje kouma Eporayamone kalopa liltimu yomboma molemolá.’ nikiru. Ono Eporayamone kalopa liltimu yomboma molemelemonga unguri naa selemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Unju peke tomba lumu Pulu Yemone koronga unju puluna ambolopa ola lipa molemo. Unju mongo peanga naa tomba unjuma yuni peke topale sepena kalomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nane ulu-pulu-kirima siye kolko konopu topele tolemele yomboma sika no lindiliu. Aku-na-kolo ye se akilepa ombámo yuni ⸤Pulu Yemonga⸥ Mini Kake Sélimu kinia sepemo kinia ono lindimba ⸤lingí⸥. I nanga bulkundu akilepa ombá yemo yunga tondolomo paa olandopa, nanga tondolomo paa maniandopa. Na yu-kinia manda mólo. Yombo awilimanga kongono kiri seli kendemande-yombomane sika ononga yombo awilimanga kongono kiri sendengendo kimbu-su wendo lindilimili-na-kolo nanga akilepa ombá yemonga kimbu-su wendo lindimbu kanu kongonomo paa olandopa mele nane sendembo manda naa selka, ⸤na ye paa kiri⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Yuni yunga rasi-witi apuroli apulu-pokomo ambolopale yunga rasi-witi mongoma kinia rasi-witi kiluma kinia apurumbando molemo. Yunga rasi-witi apuroli polomo sepa wamombando rasi-witi pali ‘wendo liembo.’ nimba apurupale mongoma lipa rasi-witi taltolemo mingina ‘Liepili.’ nimba taltombando mingi topa, pe kiluma lipa maku topa sepe naa kumbulupa nomba pepa mindi pulimúna kalomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jonone yomboma no lindipa molopili Yesusi kolea Gallilli disiriki mundupa kelepale nirimumuni, ‘Jonone na no lindepili.’ nimba Jono no Jodane molorumuna yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Orumu kinia Jonone nimbale: “Aku paa mólo. Nane nu no nambi sepo lindambo ningu nikinuye? Nuni na no lindilinanje peanga.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aku-na-kolo Yesusini pundu topa nimbale: “Mólo. Ulu kake seli uluma pali manda sepili kene nikiru mele sei.” nirimu. Kanu-kinia Jonone “Manda.” nimbale yu no linderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesusi no lipa pora sipale nona sumbi sipa wendo orumu. Wendo ombá orumu kinia mulúmu kengeya lepa anju yando purumu, Pulu Yemonga Minimu, kera waembono mele, mania omba Yesusi molorumuna pumba kangina ola molorumu kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kanu-kinia muluna ola ungu se wendo ombale, “I nanga konopu mondolio kangomo. Yu-kinia konopu sipu molio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesusi ⸤no liltimu kinia Pulu Yemonga Minimu yu-kinia omba molopale nirimumuni,⸥ Minimu yuni ‘⸤Kurumanga nokoli⸥ depelemone yu kondi topili.’ nimba Yesusi kolea ku lielina memba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akuna Yesusi oli se koro talo mele kere-langi naa noli we molopa perimu kinia yu gelene kolopa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kanu-kinia kondi toli ⸤kuru Setene⸥ omba yundu nimbale: “Nu Pulu Yemonga Malo liemu i kouma ‘Pellawa kaloli au liepili.’ ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aku-na-kolo yuni pundu topa nimbale: “Pulu Yemonga bokumuni nimbale: ‘Kere-langimane mindi yomboma konde mololi ulu-pulumu naa silimú. Pulu Yemone ungu nilimúma pali pilku liku seko molonge kinia konde mololi ulu-pulumu lingí.’ nimba molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kanu-kinia depelemone Yesusi lipa kolea-awili Jerusalleme, akumundu ‘kolea-awili kake seli’ nílimu, akuna memba pumba Pulu Yemo popo toko kaloringi ulka-tembelena memba, paa ola imuna pumba anjipale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yundu nimbale: “Nu Pulu Yemonga Malo liemu nu lipa tapondomba kene po ningu mania pu.” ⸤nirimu.⸥ “Pulu Yemonga bokumuni nimbale: ‘Pulu Yemone yunga angellomane ‘Nu ongo nokangi.’ nimbá. Onone nu ‘Kou sene kepe naa topili.’ ningu nu ononga kimane okoko lingí.’ nimba molemo kanumu. Aku sipa nirimu kene pilkuli aku siku sei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesusini yundu nimbale: “Pulu Yemonga yombomando ungu se pea nimba molemóla. Akumu i-sipa: ‘Pulu Yemo ononga Ye-Awilimuni “Sembó.” nilimú mele ‘Sika nilimúnje molo kolo tolemonje kanamili.’ ningu onone yu manda manjiku naa sangi.’ nimba molemóla kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kelepa depelemone yu lipa mulu se paa olandopa lierimuna ola memba pumba anjipale, yu ma-koleama pali kinia koleamanga méle peangama pea lipa ora sipa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yundu nimbale: “Nu nanga kumbikerena komorongo toko pondoko mania molko na popo toko nanga imbi ambolko paka tondonu liemu i nu kanokono ma-koleana lemó mélema pali nu simbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kanu-kinia Yesusini yundu nimbale: “Setene, nu anju pa! Pulu Yemonga bokumuni nimbale: ‘Pulu Yemo ononga Ye-Awilimu manjiku popo toko imbi ambolko paka tondoko, yunga kongonoma manjiku sendeko molangi.’ nimba molemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kanu-kinia depelemo Yesusi yu mundupa kelepa yu purumu. Purumu kinia mulu-koleana angelloma ongo Yesusi nokoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kanu-kinia ⸤No Lindeli⸥ Jono ka siku ka-ulkana panjeringi kinia pilipale Yesusi kelepa kolea Gallilli disirikindu yando omba ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasarete taonona ombale nirimumuni, pe aku taonomo mundupa kelepa Kapeniame taono, nomu Gallilli kelona lierimu, akuna pumba ‘Kiniá i koleamo nanga kamu molombo koleamo liepili.’ nimba akuna molorumu. Kapeniame ye Sepullano kinia Napatallaitolone kalko liltingili yomboma u moloringi koleana lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","⸤Kapeniame taonona pumba molorumumunga⸥ koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane ulu se pe wendo ombá u nirimu mele kamu wendo orumu. Aisayane nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepullanone kalopa liltimu yomboma pelemele koleamo kinia, Napatallaini kalopa liltimu yomboma pelemele koleamo kinia, nomuna pulimú aulkamo no Jodane nekendo lemó koleamo kinia, kolea Gallilli wikindu yombo-lupa awisili molemele koleamo kinia, aku koleamanga molemele yomboma ⸤paa simbulu tolina molemele⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kanu yombo paa simbulu tolina molemelema pa tondolo paa awili-sepa seli se kanoringi. Kololi ulu-pulumu aki topa simbulu tondolemo koleana pelemele yombomanga koleana pa sendekemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","⸤Kapeniame omba molorumu⸥ kanu walemonga Yesusini yomboma pulu polopa unguma nimba sipa nimbale: “Pulu Yemo ye nokoli kingimu molopa nokomba walemo nondopa wendo ombá sekemo kene ⸤ ‘Pulu Yemo yuni nokomba yombomanga talapena sukundu molamili.’ ningu⸥ ulu-pulu-kiri selemelema munduku kelko konopu topele taa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesusi nomu Gallilli kelona andopale genungulu talo kanorumu, akutolo Saimono kinia genu Enderutolo oma lili wale se nomuna toko munduku moloringili kanorumu. Pe Saimononga imbi se Pita niringila. Oma liltingili akumu olonga kou-kongono seringili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aku siku seko moloringili kanopa nimbale: “Na lombili wangili. Oma lingilindu oma lili wale se liku nona mania mundulimbili kinia omama walena omba pelemo mele, pe ‘nanga kongonomo sengelendo nanga ungumu pilku ningu siliku andongele kinia yomboma nanga talapena sukundu ongo molangi.’ nimbu ‘Olo na lombili wale.’ nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aku nirimu kinia pilkuli popenge seko olonga oma lili walema munduku kelko Yesusi lombili puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kanu-kinia yu kanga-kolte wiltu pumbale genungulu talo lupa kanorumu, akutolo Seperi malo Jemisi kinia Jemisi genu Jonotolo, lapa Seperi kinia ononga nona andoli sipina sukundu oma lili walema toko tandoko moloringi kanopale olo mangilipale “Na lombili wale.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aku nirimu kinia pilkuli olonga lapa Seperi kinia nona andoli sipimu popenge seko munduku kelko Yesusi yu lombili puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kanu-kinia Yesusi kolea Gallilli disiriki sukundu koleamanga pali andopa, yomboma maku toko Pulu Yemonga ungumu pilieringi ulkamanga yomboma ungu-mane sipa, Pulu Yemo nondopa ye nokoli kingimu molopa nokomba mele semane peangamo topa sipa, yombo kuru lupa-lupa torumuma kinia kangina ulu awisili serimuma sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yuni serimu mele semanemo kolea Siria poropinji koleamanga pali anju anju purumu pilkuli ononga yombo kuru lupa-lupa torumu yomboma kinia, mindili lupa-lupa nongo moloringi yomboma kinia, yombomanga konopumanga kuru molko amboloringi yomboma kinia, amu toringi yomboma kinia, kimbu ki kukorumu yomboma ⸤pali⸥, yu molorumuna mengo oringi kinia yuni ono sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yombo paa awisili yu lombili puringi. Kolea Gallilli disiriki yomboma kinia, ‘Kolea-Awili Rureponga Talo’ niringi kolea yomboma kinia, kolea Judia disiriki lierimu kolea-awili Jerusalleme yomboma kinia, kolea Judia sukundu lierimu we-koleamanga moloringi yomboma kinia, no Jodane nekendo koleamanga yomboma kinia, paa awisili yu lombili puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesusini yombo awisili maku toko yu lombili puringima kanopale ma-pangina ola pumba molorumu kinia yu lombili andolima yu molorumuna oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kanu-kinia yuni ono ungu-mane sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yombo konopuna koropa pulimú pilielemele yomboma Pulu Yemo ononga ye nokoli kingimu molopa ono nokolemomonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Yombo kola seko konopu kiri pepili molemele yomboma Pulu Yemone “Ono konopu peanga pepa toyombo topili.” nimbámonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Yombo taka leko molko yombo lupama pilku molemele yomboma ma-koleama pali Pulu Yemone ono simba lingímunga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pulu Yemone “Saa.” nilimú ulu sumbi nilima sengendo yakala kolko molemele yomboma manda molongemonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Yombo lupama kondo kololemele yomboma Pulu Yemone kondo kolombamonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Yombo konopu kake sepili molemele yombomane Pulu Yemo kanongemonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“‘Yomboma konopu seluna pupili molangi.’ nilimili yomboma Pulu Yemone ‘Ono nanga bolangoma.’ nimbámonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pulu Yemone “Saa.” nilimú ulu sumbi nilima seko molemelemonga yombo lupamane ono mindili silimili ⸤akumunga⸥ Pulu Yemo ononga ye nokoli kingimu molombamonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Na pilku molemele yomboma, ono nanga yomboma molemelemonga we-yombomane ono ungu-taka tondoko mindili siku, ungu kiri lupa lupama ononga bulkundu kolo toko nindingí kinia ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","⸤Yombomane ono aku siku mele selemelemonga⸥ ono mulu-koleana pungí kinia kanuna Pulu Yemone ono méle kalopa kondomba kene konopu paa awili seko siku konopu peanga pepili molayo. Yombomane kiniá ono mindili silimili mele aku siku ono naa molangi koro-u Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siliku andoringi yomboma we-yombomane ono kepe mindili siringila kanumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ono ma-koleana yombomanga api-kusa mele molemele. ⸤Akumu méle peanga⸥-na-kolo yu songo naa sembá kinia ‘Yu kelepa songo sepili.’ nimbu ungu se manda semoloye? Yu kongono sembá tondolo se kelepa naa pembamonga we topo eltomolo kinia yomboma kimbumane kulku sembambu singí kinia papu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ono ma-koleana yombomanga pa sendelima molemele. Kolea-awili ma-pangina ola lembamo manda lopi naa senge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yombomane sepe-llame kandokole mingina sukundu naa panjilimili. ‘Mélema kanangi, ulka sukundu pa sepili.’ ningu polo senga ola taltolemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aku sipa mele ‘Olione ulu peangama selemolo mele yombomane kanokole olionga Lapa, mulu-koleana molemomo, kape niengi.’ ningu ononga pa selemomone yomboma kanangi, pa sendangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nane ‘Pulu Yemonga ungu-manema ⸤Mosisini⸥ bokuna torumu unguma kinia Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane bokuna toringi unguma kinia ‘mania pupili.’ nimbá okomo.’ ningu naa piliangi. Nane ‘Kanu unguma kamu mania pupili.’ nimbú naa okoro. ‘Aku ungumanga ungu-pulu pelemoma kamu wendo opili.’ nimbú okoro. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nane onondo paa sika nikiru: “Mulu matolo u pora naa nipili Pulu Yemonga ungu-manemanga ungu kanga-kolte kepe paa we mania naa pumbá. Ungu-manemanga pali ungu awili kangamanga pali kongonoma u wendo ombá.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Akumunga, yombo sene kanu ungu-manemanga ungu-mane kanga se kepe pulua topa, yombo lupama mane sipale “Pulua tangi.” nimbá yombomo Pulu Yemo ye nokoli kingimu molopa nokolemo koleana yunga imbi paa mania molomba. Aku-na-kolo yombo sene kanu ungu-manema pilipa lipa sengena panjipa molopa, yombo lupama mane simba yombomo Pulu Yemo ye nokoli kingimu molopa nokolemo koleana yunga imbi paa olandopa molomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nane ono nimbu sikiru: “Parisima kinia Pulu Yemonga ungu-manemanga puluma pilku mane silimili yema kinia onone ulu sumbi nilima selemele ungumanga olandopa ono we-yombomane naa sengi liemu, Pulu Yemo ye nokoli kingimu molopa yombo nokolemo talapena sukundu ono paa naa pungu molonge.” nikiru. ⸤Kanu yemane ungu-manema pilkuli selemele mele lupa. Pulu Yemone kanopa ulu sumbi nilima nimba kanolemo mele lupa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Koro-u ⸤Mosisini⸥ anda-kolepalimando ungu-mane se sirimumu ono pilielemele. Kanu ungu-manemo i-sipa: “Ono yomboma toko naa kondangi. Yombo topa kondomba yombomo kotena liku anjiku “Yu pundu topili.” ningu umbuna singí.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aku-na-kolo kiniá nane ono kanu ungu-manemonga ungu-pulumu i nimbu simbú sekero: “Yombo sene yunga genu kinia mumindili kolomba yombomo ⸤willisi-⸥kotena liku anjiku “Yu pundu topili.” ningu umbuna singí.” nikiru. Yombo sene yunga genundu ungu-taka tondopa “Nu kamakoye?” nimbá yombomo poropinjili-kotena mengo pungu kote sendenge. Yombo sene yombo sendo “Nu paa kongi mele aroma tolimu!” nimbá yombomo sepe-koleana pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aku siku senge yomboma umbuna menge kene nuni ‘Pulu Yemone na kanopa peanga piliepili.’ ningu yunga mélema sepena kaloli polona Pulu Yemo kongi molo kera popo toko kalko sinindu mengo ongole nu genane nu-kinia we mumindili se kolomba pilkuli ninimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nu Pulu Yemo kalko sini mélema Pulu Yemo popo toko kaloli polo pundukundu we liepili taltokole kelko anju pungu genando “Konopu seluna pupili sere lepo manda molambili.” ningu pungu ni-punguli, pe kelko ongo nu Pulu Yemo kaloni mélema ongo yu kalko sieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu kote sendemba sembá yombomo ‘Konopu seluna pupili manda molambili ungu se sambo.’ ninguli welea sani. Aku naa senu liemu nu kote sendemba yombomone nunga kote pilieli yemo molombana memba pumba simbanje. Pe kote pilieli yemone nu ka-ulka nokoli yemo lipa simba, yuni nu ka-ulkana lipa mundumba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nane nundu paa sika nimbu sikirumu: “Nu ka-ulkana wendo onindu pundu paa pali tokole mindi wendo onimu. We manda wendo naa oni.” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“⸤U Mosisini⸥ ungu-mane se sirimumu ono pilielemele. Kanu ungu-manemo i-sipa: ‘Ambo ye pulima ye lupama kinia wa ulu-kirinale naa seko, ye ambo lilima ambo lupama kinia wa ulu-kirinale naa sangi.’ nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aku-na-kolo kiniá nane ono ⸤kanu ungu-manemonga ungu-pulumu⸥ i nimbu sikiru: “Ye sene ambo se kanopale ‘Yu pea kopu sepo pelembolánje papu.’ konopu lemó akumu konopuna sukundu ambomo kinia kamu wa ulu-kirinale selemo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Nunga mongotolone mélse kanokole konopuni ‘Liemboa.’ ningu pilku ulu-pulu-kiri se senu liemu mongotolo akuku eltani. Nunga mongotolo giliepili nu sepe-koleana liku mundungí kinia manda naa sembá kene kangimunga mélse wendo liku eltokole molko kondoni kinia papu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nunga kitolone ulu-pulu-kiri se senu liemu aku kitolo kari leko eltani. Nunga kitolo giliepili nu sepe koleana liku mundungí kinia manda naa sembá kene kangimunga mélse wendo liku eltokole molko kondoni kinia papu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“⸤U Mosisini⸥ ungu-mane se sipa nimbale: “Ye sene yunga ambomondo ‘Kamu pupili.’ nimba makorombando ambomo “Kamu pu.” nimbá mele pepá se topa ambomo sipale yundu “Kamu pu.” nimba aku sepili.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aku-na-kolo nane kiniá ono nimbu sikiru: “Ye puli ambo se ye se kinia wa ulu-kirinale naa sepili yunga yemone yu makoropa “Kamu pu.” nimu liemu ‘Wa ulu-kirinale seli ambomo molopili.’ nimba aku selemo. “Pu.” nimba makorolemo ambomo pe ye sene yu limú kinia kanu yemo kepe wa ulu-kirinale selemóla.” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Koro-u ⸤Mosisini⸥ anda-kolepalimando ungu-mane se pea sirimumu ono pilielemele. Kanu ungu-manemo i-sipa: ’ “Paa sika sembó.” ningu, ningu panjiku mi lenge ungumu pulua naa tangi. Awilimundu “Paa sika sembó.” ningu, ningu panjiku mi lenge mele paa sika aku siku sangi.’ nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aku-na-kolo kiniá nane ono nimbu sikiru: “‘Paa sika nikimu.’ ningu piliangi.’ ningu méle awili senga imbi leko paa mi naa leangi. Mulu-koleamo kepe imbi leko mi naa leangi. Aku koleamo Pulu Yemo molopa mélema nokolemo koleamo kene aku naa sangi.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma-koleamo kepe imbi leko mi naa leangila. Akumu Pulu Yemo yunga kimbu mundulimú polomo kanumu. Jerusalleme kepe imbi naala leangi. Akumu Ye Nokoli Kingi Paa Awilimunga kolea-awilimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nunga pengemo kepe. Akumu nuni penge-indi se ‘Kake sepili.’ molo ‘Pombora topili.’ ningu ulu se manda naa sení kene pengemo mangilku imbi leko mi naa leaa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ulu se sika sení liemu sumbi siku “Sembó.” nieni. Naa sení liemu “Naa sembó.” nieni. Ulu-kirimanga pali ulu-pulumu pelemo ⸤kuru⸥muni ambololemo yombomane mindi ungu sulu seko niliku pungu mi lemele.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“⸤U Mosisini⸥ ungu-mane se sirimumu ono pilielemele. Kanu ungu-manemo i-sipa: “Yombo sene yombo senga mongomo topa akundumba kinia yunga mongomo toko akundangila. Yombo sene yombo senga ungúmu topa langondomba kinia yunga ungúmu toko langondangila.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aku-na-kolo kiniá nane ono nimbu sikiru: “Ono sepa kinjimba yombomo anju unguri naa seko, ‘We sepa kinjepili.’ niengi. Yombo sene nunga kumbikere ekendonga laruwa tomba kinia topele toko ‘Ekendonga kamu laruwa topili.’ nieni.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yombo sene ‘Nunga wale-pakolimu liembo.’ nimba kote sendemba sembá yombomo nunga wale sulu peangamo kepe ‘pea we lipili.’ nieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","⸤Romo ami⸥ ye sene nu ambolopale “Nuni na liku tapondoko mako senga ⸤nanga mélema mendani⸥ pambili.” nimbá kinia mako senga pea yu we liku tapondoko mélema mendeko pani. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Mélse si.” nimba mawa sembá yombomo mawa sembá mélemo we sieni. “Kou se pundu anjiku si.” nimbá yombomo “Mólo.” naa nieni.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“⸤U Mosisini⸥ ungu-mane se sirimumu ono pilielemele. Kanu ungu-manemo i-sipa: “Opa-geramemo konopu mondoko, opa-toumu kanoko kiri piliani.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aku-na-kolo kiniá nane ono nimbu sikiru: “Onone ononga opa-touma konopu mondoko, ono seko kinjilimili yomboma ‘Pulu Yemone sepa kondopili.’ ningu Pulu Yemo ononga ningu mawa sendangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ononga ‘Lapa mulu-koleana molemomonga bolangoma molamili.’ ningu aku siku sangi.” nikiru. Yuni yombo kiri peangama molemelena ‘Ena topili.’ nilimú. Yombo ulu sumbi nilima selemele yomboma kepe yombo ulu sumbi nilima naa selemele yomboma kepe ononga pea pali ‘Lo topili.’ nilimúla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Ono konopu mondolemele yomboma mindi konopu mondolemele kinia Pulu Yemone kanopa peanga pilimbaye? ⸤Romo gapomano⸥ kou-takisi limili yombo ⸤kirima⸥ kepe anju yando akula selemele kene ⸤ono kanoko kiri pilielemele yomboma pea konopu mondonge kinia peanga⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Onone ononga pulu lemó yombomando mindi “Ono manda molemeleye?” nilimili kinia we-yombomane selemele mele maniandopa, onone selemele mele olandopaye? Ultukundu yombomane aku sikula naa selemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Akumunga ⸤Mosisini sirimu ungu-manema we pilku naa seko,⸥ ononga Lapa mulu-koleana molemo ye paa sumbi nílimu molemo mele ono aku siku yombo sumbi nilima molangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","⸤Yesusini ungu mare nimba molopale nirimumuni, ungu mare pea nimbale:⸥ “‘Yombomane ‘Olio yombo paa peangama. Uluma paa sepo kondolemolo.’ ningu kanangi.’ ningu yomboma kanoko molangi ononga ulu peangama paa naa sangi. Aku siku senge kinia yombomane ono kape ningí. Kanu kape ningí unguma ononga méle kalólimu lingímunga ononga mulu-koleana molemo Lapamone ono méle naa kalomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“⸤Ononga mulu-koleana molemo Lapamone aku siku senge yomboma méle naa kalomba⸥ kene onone yombo koropa pulima kondo kolko ‘Lipu tapondamili.’ ningu kou-mone se singíndu ‘Semolo mele yombomane kanangi.’ ningu, ru ningu mélse naa siengi. Topele-mapele toli yemane ‘Na yombomane kape niengi.’ ningu yomboma maku toko Pulu Yemonga ungumu pilieli ulkamanga kinia aulkamanga kinia we-yombo awisilini mongone kanangi yombo koropama liku tapondolemele. Aku yemane selemele mele onone aku siku naa sangi. Nane onondo paa sika nimbu sikiru: “Aku selemelemonga ono yombomane kape nilimili unguma ononga méle kalólimu koronga limili.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Aku-sipa na-kolo onone yombo koropama kondo kolko mélse singíndu ‘Yombomane paa naa kanangi. Yombo se pea kopu sepo andolembolomone kepe naa kanopili, lopi sepo kiyongo nimbu lipu tapondambo.’ niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kanu-kinia yombomane naa kanangi, senge mele yombo se naa ningu sikuli koropa puli yombo se liku tapondonge kinia ononga ⸤mulu-koleana molemo⸥ Lapamone lopi seko selemele uluma kanolemomone ono méle kalomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ono Pulu Yemo kinia ungu ninguli topele-mapele toli yemane Pulu Yemo kinia ungu nilimili mele aku siku naa saa. Kanu topele-mapele toli yemane ‘Na ye paa peangamo molio mele yombo awisilini mongone kanoko na kape niengi.’ ningu yomboma maku toko Pulu Yemonga ungu pilieli ulkamanga kinia aulkamanga kinia yomboma kanoko molangi konopu siku gilku Pulu Yemo kinia ungu nilimili. Nane onondo paa sika nimbu sikiru: “Aku siku selemelemonga ono ononga méle kalólimu koronga limili kanumu.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aku-sipa na-kolo ono Pulu Yemo kinia ungu ningíndu ononga suluminiana sukundu pungu ulka-kuna pipi sikuli kanu lopi seli koleana ononga ⸤mulu-koleana molemo⸥ Lapa naa kanolemele yemo-kinia ungu niee. ⸤Yu akuna molemo.⸥ Aku senge kinia ononga ⸤mulu-koleana molemo⸥ Lapa lopi seko selemele uluma kanolemomone ono pe méle kalomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“‘Na Pulu Yemo kinia ungu niembo.’ ninguli Isirele talapemonga ultu molemele yombomane ononga kuruma molo pulu ye kolo tolima kinia ungu ningíndu we ungu awisili nilimili mele aku siku naa sangi. Kanu yombomane ‘Na ungu awisili nimbú kinia pilimba.’ ningu aku siku nilimili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ononga ⸤mulu-koleana molemo⸥ Lapamo u mawa naa sangi ono méle mólo tolemo mélema yuni pilipa kanolemo kene kanu yombomane selemele mele aku siku naa sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ono Pulu Yemo kinia ungu ningíndu i-siku niengi: “Olionga mulu-koleana moleno Tata, yombomane ‘Nu imbi ola molopa ye kake seli peangamo moleno.’ ningu molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu ye nokoli kingimu molko yomboma nokoni walemo wendo opili. Nunga ungumu mulu-koleana pilku liku selemele mele aku siku ya ma-koleana pilku liku sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Olio kiniá kere-langi nomolo mele kiniá siyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yombomane olio seko kinjengi kinia siye kolopo ulu se naa semulu mele aku sikula olione nu sepo kinjemulu uluma siye kolko olio ulu se naa seyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Olio ‘Ulu sene kondi topili.’ naa ningu ulu-kirimanga pali ulu-pulumu pelemo ⸤kuru⸥muni ‘olio naa ambolopili.’ ningu yunga kína wendo liyo. ⸤Nu koleama kinia mélemanga pali ye nokoli kingimu molko, tondolo olandopamo nu-kinia pepa, nu imbi paa olandopa molopa nu-kinia pa tondolo sepa pepili alieli molko mindi pulinu kene aku sipa sepili.⸥” ningu aku siku Pulu Yemo kinia ungu niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yombomane ono seko kinjingí uluma ‘We mania pupili.’ ningu siye kolongi liemu ononga mulu-koleana molemo Lapamone ononga ulu-pulu-kirima ‘Mania pupili.’ nimba siye kolombala. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aku-na-kolo yombomane ono seko kinjingí uluma ‘We mania naa pupili.’ ningu siye naa kolongi liemu ononga ⸤mulu-koleana molemo⸥ Lapamone ononga ulu-pulu-kirima ‘Mania naa pupili.’ nimba siye naa kolombala.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ono kere-langi naa nongo mi toko we molonge ungu-pulumu sengendo topele-mapele toli yemane ‘Na nono nimbu molambo.’ nilimili mele aku siku naa niengi. Kanu yemane ‘Na kere-langi naa nombondo mi topo molio mele yombomane kanangi.’ ningu ono kumbikere seko ononga kumbikerema seko kinjiku molemele. Nane onondo paa sika nimbu sikiru: “Kanu yemane aku selemelemonga yombomane ono kape nilimili unguma ononga méle kalólimu koronga limili.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","“Aku-na-kolo ono kere-langi naa nongo mi toko we molongendo ‘We-yombomane na aku sekero mele naa kanangi. Tatane manjipa kanopili.’ ningu we-yombomane kanonge unguma naa sangi. Aku senge kinia ononga ⸤mulu-koleana molemo⸥ Lapa lopi seko selemele unguma kanolemomone ono méle kalomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ya ma-koleana méle taltolemelema urolo topa koka molo lurinia melemane ongo seko kinjiku, wa lili yema ongo mélema wa limili kene ‘⸤ya mana⸥ kamako molopo méle kande-kandema lipu taltamili.’ ni naa niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aku naa sekole mulu-koleana mélema urolo naa topa koka molo lurinia mélsene omba sepa naa kinjipa, wa lili yema ongo wa naa limili kene ono mulu-koleana ⸤pe pungímunga⸥ ‘méle kande-kande pe limulúma u liepili.’ ningu ya ma-koleana ulu peangama seko molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ononga taltolemele mélema lemó kolea akuna ono konopuni pilku yakala kolko molemele kene ⸤‘mulu-koleana mindi mélema liepili.’ ningu molangi.” nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nunga mongomo nunga kangimunga sepe-llame melemo. Aku kene nunga mongo peanga gilimú kinia nu kangi pali pa sepili moleno kinia nu molko kondoleno. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aku-sipa na-kolo nunga mongomo kiri lemba kinia nunga kangi pali simbulu topili andoni. Kanu-kinia nunga kangina pa seli pembamo topele topa simbulu tomba kinia akumu paa kamu simbulu tomba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yombo sene ye awili talonga kongono lipa sere lepa manda naa sendemba. Ye awili se konopu kiri panjipa, se yakala kolomba. Molo aku naa semu liemu ye awili senga ungu nimbáma paa konopu sipa pilipa lipa kongono nimbáma tondolo mundupa sendepa, se konopu kiri panjipa yunga ungu nimbáma naa pilipa semba. Yombomane Pulu Yemonga kongonomo kinia Kou-Monemonga kongonomo-tolo liku sere leko manda naa sendenge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Akumunga nane ono ⸤senge mele⸥ nimbu siembo: ‘Kangikundu molopo kondamili.’ ningu konopu awisili kimbu naa siengi. Kere-langi nongemonga kepe no nongemonga kepe mulu-maminia pakongemonga kepe akumanga konopu awisili kimbu siku naa molangi. Ono manda molonge mele ungu-pulumu kere-langi kinia mulu-maminia kinia mindiye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kerama kaname. Kere-langi se panjikuli nou lemó kinia liku mengo ulkando pungu taltoko naa nolemele-na-kolo ono yombomanga mulu-koleana molemo Lapamone kerama kere-langi silimú. Kerama we mele ono yomboma olandopamonga yuni ono naa nokombaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ononga yombo sene konopu awisili kimbu simbamone yu kolomba ena se manda ‘We liepili.’ nimbáye? Manda naa nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","“Ono pakonge mélemanga konopu awisili nambi semu-na kimbu silimiliye? Pellawa-sindima mana olemo mele ono naa kanolemeleye? Pellawa-sindimane kongono kála seko naa seko, mulu-maminia se seko naa wamolemele-na-kolo pellawa-sindima molemele mele olandopa, ⸤ye nokoli kingi⸥ Sollomono kongono awisili sepale wale paa peangama pakopa au nirimu mele maniandopa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Era sindi tolemoma kiniá-mele molemo, opali-mele poroko sepena kalolemelema Pulu Yemone aku sipa nokopa kondolemo liemu ono ‘Pulu Yemone olio manda nokombanje.’ ningu kanga-kolte mindi pilku kuru mondolemele yomboma pakonge mélemanga yuni manda lipa naa tapondombaye? Ono paa sika lipa tapondomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“⸤Pulu Yemone kerama kinia era sindima kinia aku we-mélema aku sipa nokolemo⸥ kene ono konopu awisili kimbu sikuli ‘Es, kere-langi se sena lipu nomolonje?’ ; molo ‘No sena kolopo nomolonje?’ ; molo ‘Wale-pakoli sena lipu pakomolonje?’ ningu pilku naa molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pulu Yemonga yomboma naa molko ultukundu molemele yombomane aku siku selemele-na-kolo ononga mulu-koleana molemo Lapamone ono yunga yombomanga méle molo tolemoma kanopa molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","⸤Ono kere-langi nongemanga kinia mulu-maminia pakongemanga kinia konopu naa kimbu siku,⸥ Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo uluma kinia yu kanopa kake selemo kanolemo uluma kinia mélema kinia ‘Kumbi lepo sambo.’ konopu leko molangi. Aku senge kinia yuni we-mélema kepe ono simba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yuni aku sembá kene ‘Opali nambi sembonje?’ ningu kiniá konopu awisili kimbu naa siengi. Opalimunga kere-langi molo mélema aku opali, kiniámonga kere-langi molo mélema kinia, opalimunga kinia, liku sere leko naa piliangi. Enamanga yu-mele-mele umbunama pelemo pembama kanu enamanga, mindi. Kiniá umbuna wendo ombáma kinia opali talu umbuna wendo ombámanga kinia sere leko konopu kimbu naa siengi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","⸤Yesusini ungu mare nimba molopale ungu mare pea nimbale:⸥ “Onone anju yomboma ⸤selemele uluma⸥ apurungí kinia aku sipa ⸤Pulu Yemone⸥ ono selemele mele yando apurumbala. Onone anju yombomane selemele mele apuruku kanokole “Seko kinjikimili. Sekemele mele Pulu Yemone kanopa kiri piliepili.” ningí mele ⸤Pulu Yemone⸥ aku sipa ono apurumba. Aku sembá kene ‘⸤Pulu Yemone⸥ olio ungu selemoloma naa apuropili.’ ningu onone yomboma selemele unguma naa apurangila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nuni genanga mongona norupulu se lemómo kanoleno-na-kolo nunga mongona unju-kaliu awili se lemómo naa kanoleno akumu nambi semu-na selenoye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nunga mongona unju-kaliu awili lemómo naa kanokole genando “Ano, nunga mongona norupulu se lemómo wendo lindambo.” nambi seko nilinuye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Topele-mapele toli yombomo, nuni nunga mongona lemó unju-kaliu awilimu u wendo likuli pe kanoko kondoko genanga mongona lemó norupulumu manda wendo lindení.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“‘Pulu Yemonga’ nilimili mélema liku owáma naa sieme. Nombale pe topele topa ono nombanje kene aku naa sangi. Ononga méle peangama kongima gilingína toko naa mundangi. Kimbuni kulungínje kene aku naa sangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“⸤Lapa, mulu-koleana molemo yemo,⸥ mélema mawa seko “Si.” niengi. Aku senge kinia mélema sika simba lingí. ⸤Lapa molemona⸥ mélema korangi. Aku senge kinia mélema sika kanoko lingí. Ulka kerepuluna gilku “Sukundu wamili.” niengi. Aku ningí kinia “Sukundu waa.” nimba ulka-kuna tondomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mawa senge mélema sika simba lingí; koronge mélema sika kanoko lingí; “Sukundu wamili.” ningí kinia sika ulka-kuna tondomba. Aku sembá kene aku saa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ononga ye se yunga malo ombale “Tata, pellawa kaloli se nambo si.” nimbá kinia yunga lapane yu kou-mulu se simbaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Molo kangomone “Tata, oma se nambo si.” nimbá kinia yunga lapane wambiye se simbaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pe ono konopu kiri pepili molemele yombomane aku siku ononga bolangoma méle peangama silimili liemu ononga Lapa mulu-koleana molemomone “Mélema si.” ningu mawa senge yomboma méle peangama paa olandopa naa simbaye? ⸤Paa simbamo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Akumunga, ‘Yombomane nu-kinia sangi.’ konopu leno mele nuni anju yomboma aku siku sani. ‘Aku sangi.’ nikinu ulumuni Mosisini Pulu Yemonga ungu-mane sirimu bokuna torumumanga pulumu kinia, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane bokuna toringi ungumanga pulumu kinia, lipa sere lepa nilimú kene aku siku anju yando yomboma-kinia seko kondangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ono pala kere-pingiya kangamonga paa pangi. Kolea kirina pulimú kere-pingiyamo paa awilimu, akuna pulimú aulkamo paa anju yando pumba paa pará lemó akuna yombo awisili kala naa seko we pulimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aku-na-kolo alieli konde molopa kondopa mindi puli koleana pulimú kere-pingiyamo paa kanga, yunga aulkamo paa sengepea seli kangamo lemó-kolo yomboma akuna pungíndu kala selemelemonga yombo selu selu ningu mindi aku aulkamo kanokole pulimili. Aku selemele kene ono kanu kere-pingiya kangamonga pangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pulu Yemone ungu-umbu tondombama naa pilku we kolo toko yando ningu singí yema onge kene kanoko kondoko molaa. Kongi sipisipi paa taka leko molemele mele aku siku kanu yomboma ongo molonge-na-kolo owá-palakoma paa gelene kolkole ‘Mélse topo namili.’ ningu andoko molemele mele aku siku kanu yombomane ‘Ono mindili nangi. Ono sepo kinjamili.’ ningu molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kanu kolo toli yomboma ongo ulu sengema kanokole, ‘Ono sika kolo tolima.’ ningu kanonge. ‘Amu namili.’ ningu takeme manda olko toko nolemoláye? Molo ‘Ipono se namili.’ ningu silipu manda akuku nolemoláye? Paa mólo. ‘Amu lupa, takeme lupala; ipono lupa, silipu lupala.’ ningu kanolemele. ⸤Aku siku mele Pulu Yemone sika ungu-umbu tondolima pilku yomboma sika ningu silimili mele lupa, Pulu Yemone ungu-umbu naa tondolima yomboma kolo toko ningu silimili mele lupala ningu kanonge.⸥ Unjuma mongo tolemo kinia kanokole ‘Ima nomolo lémo. Ima naa nomolo lémo.’ ningu kanoko imbi silimili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Unju peangamone mongo peangamo tolemo; unju kirimuni mongo kirimu tolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Unju peangamone mongo kiri se manda naa tomba; unju kirimuni mongo peanga se manda naala tomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Unju mongo peangama naa tomba unjuma pali peke tokole sepena kalolemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unjuma mongo tolemo kinia kanokole, “Imu peanga, imu kiri.” ningu apurulimili mele, onge yombo kanumane senge uluma onone kanokole yomboma molemele mele sika aku siku kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘Yombomane nando ‘Ye-Awilimu.’ nilimili yomboma pali Pulu Yemone nokolemo mulu-koleana sukundu pungí.’ ningu naa piliayo. Tata mulu-koleana molemomonga unguma pilku liku senge yomboma mindi akuna pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yomboma apurumba wale kanumu wendo ombá kinia yombo awisilini nando ninguli: “Ye-Awilimu, nane nunga imbi lepo nunga unguma nimbu sirindu kanumu; nunga imbi lepo yombomanga konopumanga kuru moloringima “Ongo ultu paa.” nirindu kanumu; nunga imbi lepo ulu-tondolo awisili serindu kanumu.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aku-na-kolo aku siku ningí kinia nane onondo nimbuli: “Na ononga imbima paa naa pilipu ono kanopo imbi naa siliu. Ono Pulu Yemonga ungumu naa pilku liku seringi kene nanga kumbikerena naa ongo anju paa.” nimbú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Akumunga, i nanga unguma pilku liku senge yomboma ono ye se molemo mele niembo: Ye pilipa kondoli perimu ye se yuni yunga ulkamo ‘Ingi nimba giliepili.’ nimba kou-polona ola takorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe lo topa no topa poporome topale ulkamo paa topa kalambili simba serimu-na-kolo ulka-simumu kou-polona gilierimu-kulu topa sikise naa sikisipa ingi nimba we gilierimu. Nanga unguma pilku liku selemele yomboma ono kanu yemo mele molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“I nanga unguma pilku liku naa senge yomboma ono ye se molemo mele niembo: Ye pilipa kondoli naa perimu ye sene yunga ulkamo okiyana ola takorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe lo topa no topa poporome topale ulka kanumu topa kalambili sipa paa bulu-balu sirimu. Nanga unguma naa pilku liku senge yomboma ono kanu yemo mele molemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesusini aku unguma nimba pora sirimu kinia yuni mane sirimu pilku moloringi yombomane yuni ungu-mane sirimu mele pilkuli mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pulu Yemonga ungu-manemanga puluma pilku ono mane siringi yemane we mane siringi mele Yesusini aku sipa mane naa sirimu. Namba lierimu yemane pipili naa kolko tondolo munduku mane siringi mele aku sipa mane sirimu-kulu pilkuli ono mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusi ma-pangina maniando ombá orumu kinia yombo awisili liku maku toko yu lombili oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kanu-kinia ye se kuru laká nomba perimumu Yesusi orumuna omba yunga kumbikerena komorongo langopa yundu nimbale: “Ye-Awilimu, nunga konopumuni na ‘peanga liepili.’ konopu lienu liemu nuni na manda seko peanga sini.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesusini yemo kini ambolopa yundu nimbale: “‘Nu peanga liepili.’ konopu lekero kene peanga liepili.” nirimu kinia popenge sepa kuru lakámo nomba kelierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kanu-kinia Yesusini yundu kelepa nimbale: “Nuni ya ulu sekeromo yombo selurindu kepe paa naa ni. Sumbi siku pungu Pulu Yemo popo tondoli yemo nunga kangimu liku ora siku, ‘Na kelepo kangi peanga liepili molkoro kene.’ ningu Mosisini “Sei.” nimba panjerimu mele pilku liku senindu “Pulu Yemo popo toko kalko sie.” nirimu mélemo liku Pulu Yemo popo tondoli yemondo “Kalondou.” ningu yu sieni. Pe yombomane nu kanokole ‘Yu sika kangi peanga liepili molemo.’ ningu piliangi kene nikiru mele iseli-u se-pu.” nirimu. ⸤“Aku siku sení kinia yombomane nu kanoko kiri naa pilingí, nu kelko we-yomboma molemelena manda seluna pungu moloni.” nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesusi Kapeniame taonona sukundu purumu kinia Romo yombomanga ami-ye wane anderete nokorumu ye se yu orumuna omba yundu mawa sepa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ye-Awilimu, nanga kendemande-yemo kimbu ki kolopa pora sipa mindili nomba perepa ulkana liepili okoro.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusini yundu “Ombo sepo peanga simbu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","⸤Aku nirimu kinia pilipale⸥ ami-ye wane anderete nokorumu yemone yundu pundu topa nimbale: “Ye-Awilimu, na ye kirimu mele molio, nu nanga ulkana oni kinia manda naa sembá. Na ye sene kepe nokopa molemo, yunga ungumu pilipu lipu selio. Nane kepe ami-ye mare nokopo molio. Kanu yemanga sendo “Pu.” niliu kinia yu pulimú. Molo sendo “Ou.” niliu kinia yu olemo. Molo nanga kongono sendeli kendemande-yombo sendo “I-siku sei.” niliu kinia yu aku sipa selemo kanumu. Aku sipala, nuni ungu se we nini kinia nanga kendemande-yemo konde pumbá kene nuni we ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusini yu nirimu mele pilipale yu konopu awisili kimbu sipa yu lombili oringi yombomando nimbale: “Nane onondo paa sika nimbu sikirumu: “I Isirele yombomanga talapena ultu mololi yemone na ungumuni mindi manda sembó mele nimba olandopa tondolo mundupa kuru mondolemo mele koleamanga pali, Isirele koleana sukundu kepe, yombo selurini kepe aku siku ningu pilieringi mele paa naa kanorundu.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nane onondo paa sika nimbu sikirumu: “Ena mundi olemo koleamanga kinia ena pulimú koleamanga kinia yombo awisili wendo ongo Pulu Yemo ye nokoli kingimu molopa nokolemo mulu-koleana sukundu Eporayamo kinia Aisake kinia Jekopo kinia pea ongo kere-langi nongo molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aku-na-kolo Pulu Yemone ‘yunga yomboma’ nimba taltorumu ⸤Isirele⸥ yomboma yu nokopa molemo koleana pungu molemolá yomboma yuni topa makoropa simbulu tolina mundumba. Kanuna paa mindili nongole kola seko pereko molonge.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aku nimbale yuni ami-ye wane anderete nokorumu yemondo nimbale: “Nane nu ‘manda sendemba’ ningu kuru mondonu mele sendendu kene pu.” nirimu. Kanu-kinia yuni aku sipa nirimu enamonga kendemande-yemo yu kuru topa kelepa peanga liepili molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","⸤Kanu-kinia⸥ Yesusi Pitanga ulkana sukundu pumbale Pitanga kolepa-ambomo kuru topa kangi norumu-kulu aniembo lierimu kanopale, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","yunga kimu ambolorumu kinia kangi nomba kelierimu kinia ambomo ola gilipa wendo omba Yesusi kere-langi sipa yu nokorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pe kolea ipu lemba serimu kinia konopuna kuru molorumu yombo awisili Yesusi molorumuna mengo oringi kinia yuni kurumando “Ongo wendo paa.” nirimu kinia ongo wendo puringi. Kuru torumu yomboma pali sepa peanga sirimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aku sipa serimumunga koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane ulu se pe wendo ombá u nirimu mele kamu wendo orumu. Aisayane nimbale: “Yuni yuyu olio kuru torumuma makoropa, olio aniembo lierimulu kuruma lipa ultu mundorumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","⸤Walte⸥ Yesusi ⸤Gallilli nomu kelona molopili⸥ yombo awisili liku maku toko yu liku makapu seko moloringi kanopale nirimumuni, ⸤lombili andolimando⸥ “Nomuna nekendo pamili waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","⸤Aku-na-kolo u naa pumba we giliepili⸥ Pulu Yemonga ungu-manemanga puluma pilipa mane sirimu ye se yu gilierimuna omba yundu nimbale: “Ungu Mane Sílimu, nu puni koleamanga pali nu lombili ombó.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","⸤Aku nirimu kinia⸥ Yesusini yundu nimbale: “Pílie! Owá-palakoma ulka pelemelemanga pelemele; kerama ononga ulka takolemelemanga pelemele, aku-na-kolo Mania Omba Mana-Ye Au Lierimu Yemonga pelemo kolea se naa lemó ⸤kene, nu ‘Yu lombili pumbuli manda naa molombo.’ ningu pilkuli na lombili wani. We naa wani.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kanu-kinia yu lombili andorumu ye sene yundu nimbale: “Ye-Awilimu, nu kamu lombili wambo mangali u pumbu nanga lapamo ⸤kinia pea molambo. Pe yu kolomba kinia⸥ óno sepole nu lombili ombó.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aku-na-kolo Yesusini yundu ⸤ungu-iku topa⸥ nimbale: “Yombo kololi yombomane yombo kolongema óno sangi. Aku-na-kolo nu na lombili ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aku nimbale ⸤nomu Gallilli nekendo pumbándo⸥ nona andoli sipi senga sukundu purumu kinia yu lombili andolima yu lombili sukundu puringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kanu-kinia ⸤nomuna pungí puringi kinia⸥ poporome awili se nomuna torumu. Aku serimu-na nomumu apisipa ola ombale sipimu lipa aki tomba serimu-na-kolo Yesusi we uru perimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanu-kinia onone yu uru perimuna pungu toko makisindiku ninguli: “Ye-Awilimu, olio liku tapondoyo. Olio nona wangokomolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yu ⸤makilipa⸥ onondo nimbale: “‘Pulu Yemone olio nokomba.’ ningu paa kanga seko mindi kuru mondoli yema, ono nambi semu-na mini-wale mundukumiliye?” nirimu. Aku nimbale ola molopa poporomemo kinia nomumu-tolo iri torumu. Kanu-kinia poporomemo topa kelepa nomumu lope naa sepa paa we lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","⸤Yuni serimu mele kanokole⸥ yemane mini-wale munduku ninguli: “Apa! I yemo nambolka yerenje? Poporomemone kepe nomumuni kepe yunga ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kanu-kinia yu ⸤lombili andolima kinia pea⸥ nomu nekendo pumba kolea Gadara puringi kinia kanu kolea Gadara ye talo, konopuna kuru molorumu yetolo, yombo-óno-koleana wendo ongo yu molorumuna oringili. Olo paa enge ningu yomboma tongele seringilimunga we-yomboma olo peringili koleana ‘Olone ono tongele.’ ningu aulkana ongo naa puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesusi kanokole tondolo munduku mangilku ninguli: “Pulu Yemonga Malo, olio-kinia ungu nambolka unguri senindu onuye? Olio mindili lipa simba walemo u wendo naa opili nuni iseli-u olio mindili liku sini okonoye?” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akuna anjupa kolea senga umbu-kongi awisili ímu nongo moloringi ⸤kanokole⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kurumane Yesusi mawa seko ninguli: “Olio toko makorokole ‘ne kongimanga konopumanga molo-pangi.’ ni.” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","yuni onondo nimbale: “Manda, akuna pangi.” nirimu kanu-kinia ⸤kuruma⸥ kanu yetolonga konopuna wendo ongole kongi akuna moloringimanga konopumanga pungu moloringi kinia kanu kongima pali amu toko lisiku pungu kopona pukua toko nomuna sukundu pungu nona wangoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","⸤Ungu akuma wendo orumu kinia kanokole⸥ kongi tapu seko moloringi yema kowa punguli niringimuni, taonona pungu akuna moloringi yomboma ononga kongima serimu mele kepe kuruma konopuna moloringi yetolo serimu mele kepe semane toko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Niringi mele pilkuli taonona moloringi yomboma pali Yesusi molorumuna ongo kanokole yu mawa seko ninguli: “Olionga koleana naa mololi kelko pu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanu-kinia Yesusi kelepa nona andoli sipi senga sukundu pumbale nirimumuni, nomu ⸤Gallilli⸥ yakondo omba yunga kolea ⸤Kapeniame taono⸥ orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yu ⸤Kapeniame kelepa⸥ omba molorumuna ye marene kimbu ki kolopa pora sirimu ye se taropola seko mengo oringi. Onone ‘Yesusini i yemo manda sepa peanga simba.’ ningu kuru mondokole yu mengo oringi Yesusini kanopa pilipale kimbu ki kolopa pora sirimu yemondo nimbale: “Nanga kangomo, nunga konopu peanga liepili. Nunga konopuna ulu-pulu-kiri serinu pelemoma mania pupili, mundupu kelkero.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aku nirimu kinia pilkuli Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye marene onono konopumane pilkuli, ‘I yemone Pulu Yemo marake sekemo.’ ningu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ono konopu lieringi mele Yesusini pilipa nimbale: “Ono nambi semu-na konopu leko kinjikimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","I yemondo “Nunga ulu-pulu-kirima mania pupili, siye kolkoro.” nimbú kinia ono ulu se naa kanokole ‘Pe nilse nikimu.’ konopu lengeye? Molo “Ola gilku nunga kunungumu liku mengo kimbu-kongono seko andou.” nimbú kinia yu ola gilimbane naa gilimbanje mona lemba manda kanokole ‘Aku sipa kála sepa nikimunje?’ konopu lengeye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aku-na-kolo ‘ ‘Mania Omba Mana-Ye Au Lierimu Yemo tondolo pelemomone ya ma-koleana yombomanga ulu-pulu-kirima “Mania pupili, siye kolkoro.” manda nimbá.’ ningu piliangi.’ nimbu aku sipu nindu.” nirimu. Aku nimbale kimbu ki kolopa pora sili yemondo nimbale: “Nu ola gilku nunga kunungumu liku mengo ulkando pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aku nirimu kinia yemo ola gilipa ulkando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yombo awisili akuna maku toko moloringimane yuni aku serimu kanoko mini-wale mundukuli, mana-yomboma ulu-tondolo aku mele senge tondolomo sirimu Pulu Yemonga imbi ambolko paka tondoko kape niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kanu-kinia Yesusi pumbá pumbale nirimumuni, kou-takisi lipa molorumu ye se, yunga imbi Mateyu, kanopale yundu “Na-kinia pea pambili lombili ou.” nirimu. Kanu-kinia Mateyu yu ola gilipa yu lombili purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe Yesusi Mateyunga ulkana kere-langi nomba molorumu kinia kou-takisi lili yema kinia, ⸤Juda ye awilimane⸥ “ulu-pulu-kirima seli ye” ⸤niringi⸥ wema kinia awisili ongo Yesusi kinia yu lombili andoli yema kinia ono pea mania molko kere-langi noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","⸤Ono aku siku seluna kere-langi nongo moloringi-kulu⸥ Parisi yemane kanokole yu lombili andolimando mangilku pilku ninguli: “Ononga ungu-mane sili yemo kou-takisi lili yema kinia ulu-pulu-kirima seli ye wema kinia ono-kinia yu nambi semu-na kere-langi pea nokomeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aku siku niringi mele pilipale Yesusini onondo nimbale: “Kuru naa tolemo yomboma doketana naa pulimili. Kuru tolemo yomboma mindi doketana pulimili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nane “Yombo sumbi nilima na molombona wangi.” nimbúndu ma-koleana naa orundu. ‘Ulu-pulu-kiri seli yomboma na molombona wangi.’ nimbúndu orundu. Ulu-pulu-kiri seli yomboma lipu tapondombondo orundu kene ono pungu Pulu Yemonga bokuna molemo ungu senga pulumu pungu pili-payo. Pulu Yemone nimbale: “‘Na mélema popo toko kalko siengi.’ nimbu pilipu naa molio. ‘Ono yombo lupama konopu mondoko kondo kolangi.’ nimbu pilipu mindi molio.” nirimu kanumu.” nimba Yesusini nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pe ⸤No Lindeli⸥ Jono lombili andoringi yema Yesusi molorumuna ongole yundu mangilku pilku ninguli: “Olio kinia Parisi yema kinia olio alieli kere-langi mi lepo naa nolemolo na-kolo nu lombili andolima aku siku naa selemele akumu nambi semu-na naa selemeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","⸤Aku siku niringi kinia pilipale⸥ Yesusini pundu topa onondo ⸤ungu-iku se topa yu toko kondonge kolombamonga ungu se nimba⸥ nimbale: “Ambo limba ye se yunga pulu lemó yema kinia molemo kinia ono konopu sikuli “Kola sepo kere-langi naa namili.” manda ningíye? Manda naa ningí. Pe mindi, ambo limba yemo ono molongena ongo wendo lingí kinia kanu walemanga sika ⸤konopu kiri panjiku⸥ kere-langi naa nongendo mi lenge. ⸤Iseli-u mólo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mulu-maminia u se sungu nilimú kinia olione mulu-maminia paa konde senga se kopisipu lipu, sungu nilimúmunga naa topo tandolemolo kanumu. Yombo sene aku sipa topa tandolkanje kanu mulu-maminiamo nona panjilka kinia mulu-maminia konde kopiselimu kanga lepa lli nimbale mulu-maminia umu kelepa kamu awili sepa sungu nilka. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Kongi-meme kangimuni seli mingi-u senga no-waene konde naala kololemolo kanumu. Yombo sene mingi-u senga no-waene konde se kolkanje kanu no-waenemo mingina sukundu pepale pe akolka kinia kanu mingi-umu naa akopa sungu nilka. Kanu-kinia nomo kepe mingimu kepe kamu kiri lelka. Akumunga no-waene konde kongi-meme kangimuni seli mingi kondena mindi kololemolo kanumu. ⸤Pe nomo akolemo kinia kangimuni seli mingi kondemo anju yando pumba sungu naa nilimúmunga⸥ nomo kinia mingi kondemo pea manda lemó.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusini Jononga lombili andoli yemando ungu nimba molopili ⸤Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka se⸥ nokorumu ye se Yesusi molorumuna omba yunga kumbikerena komorongo langopa yundu nimbale: “Nanga bolamo kiniá iseli kolopa pora sikimu. Aku-na-kolo nu ongo yu kimuni amboloni kinia yu konde pumbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aku nirimu kinia Yesusi ola gilipa yu lombili purumu. Yesusi lombili andolima pea puringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kanu-kinia ambo se molorumu kanumunga pena perimu walema pora naa nirimu. Yu pena mindi pepili kalia-ingi engaki-rurepo omba purumu. Kanu ambomone ‘Yunga wale-pakolimu mindi ambolondu liemu na peanga lemba.’ nimba pilipale Yesusi pumbá purumu kinia bulkundu omba, yunga wale-pakolimunga pundumu ambolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ambolorumu kinia Yesusi topele topa yu kanopa nimbale: “Bolamo, nu konopu peanga pepili moloyo. ‘Nu manda sepa peanga simba.’ konopu lienu kanu ulumuni nu peanga lekemo.” nirimu. Kanu enamonga ambomo peanga lepa we molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kanu-kinia Yesusi ⸤Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkamo⸥ nokoli yemonga ulkana sukundu ombale yombo awisili molko kondo kolko, kolape-mingi toko pondoko, kola awili-seko seko moloringi kanopale yuni nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Ono anju pame! Bolamo kolou naa kolomu. We uru mindi pelemo.” nirimu. Aku nirimu kinia ⸤bola kanumu sika kolopa pora sirimu pilkuli yuni “We uru pelemo.” nirimumunga⸥ yu ungu-taka tondoko tawe senderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kanu-kinia yombo maku toko moloringima pulu sipa pena-pena sepale ⸤bola ónomo lierimu⸥ kisipina pumba yunga kimu ambolorumu kinia bolamo ola molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","I ulu-tondolo serimumunga semanemo kanu koleamonga sukundu lierimu koleamanga pali anju anju purumu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesusi kanu koleamo mundupa kelepa pumbá purumu kinia mongo kiri lierimu ye talo yu lombili ongo mangilku ninguli: “⸤Ye Nokoli Kingi⸥ Depitini Kalopa Liltimu Yemo, nu olto kondo kolou.” ningu wale awisili niliku oringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yu ulka senga sukundu purumu kinia mongo kiri lieli yetolo yu molorumuna lombili oringili kinia yuni olo mangilipale: “Olo na mawa sekembele mele ‘Manda sembá.’ konopu lekembele molo móloye?” nirimu kinia olone ninguli: “Ye-Awilimu, ‘Manda sení.’ konopu lekembolo.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","30","Kanu-kinia yuni olonga mongotolonga ambolopa nimbale: “Nane ‘manda sembá.’ konopu lekembele mele aku sipa wendo opili.” nirimu kinia olonga mongotolo peanga lierimu, mélema kelko kanoringili. Yesusini olo tondolo mundupa mane sipa nimbale: “Olone i ulu wendo okomomo yombo seluri kepe paa naa piliangi, naa ningu siele!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aku-na-kolo olo pena pungu Yesusini serimu mele aku koleamonga sukundu lierimu koleamanga pali semane toko siliku andoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kanu yetolo Yesusi munduku kelko pungilí puringili kinia ye se konopuna kuru molorumumunga ungu se naa nirimu ye se Yesusi molorumuna mengo oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesusini yemonga konopuna molorumu kuru kanumu topa makororumu kinia ungu naa nirimu ye kanumuni ungu nirimu-kulu yombo maku toko moloringimane kanokole konopu awisili kimbu siku ninguli: “U Isirele koleana sukundu i-sipa ulu se wendo naa orumu kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aku-na-kolo Parisi yemane ninguli: “Kurumanga nokolimuni yu lipa tapondolemo-na yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesusi kolea-awilimanga kinia kolea-kangamanga pelepa andopale nirimumuni, Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkamanga pumba ungu-mane sipa; Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo nokomba ungu-pulumunga semane peangama topa sipa; kuru lupa-lupama torumu yomboma sepa peanga sirimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yombo paa awisili yu molorumuna ongo liku maku toko moloringima kanopale ono umbu-konopu naa pepili andoko, kangima enge naa perimu-kulu ono onono manda liku naa tapondoko molkole ono kongi sipisipima ononga tapu-ye se naa molorumumunga we moloringi mele ono aku siku moloringi-kulu kanopale ono paa kondo kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanu-kinia ⸤yombo awisili ‘Yuni lipa tapondopili.’ ningu moloringi-kulu kanopale⸥ lombili andolimando nimbale: “Kere-langi awisili kaliana nou lemó-na-kolo kongono-ye awisili mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","⸤Na ye selumu mindi i kongonomo sekero kene⸥ Kere-Langimanga Pulu Yemo mawa sekole yuni “Kere-langi nou lielima lingí kongono senge yomboma yunga kaliana lipa mundopili.” niee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesusini yu lombili andoli ye engaki rurepondo “Yando waa.” nimbale onone yombomanga konopuna kuru molemoma “Ongo wendo paa.” ningu toko makoronge tondolomo sipale, yombo kuru tolima kinia kangi pange-mange selima kinia “Peanga liepili.” ningí engemo sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yuni “Nanga kongonomo sende-paa.” nimba lipa mundorumu ye engaki rureponga imbima i-sipa: U Saimono, yunga imbi se ‘Pita’ niringila, yu keme yunga genu Enderu keme, Jeperinga malo Jemisi keme Jemisi yunga genu Jono keme, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pillipu, Batollomiu keme, Tomasi keme kou-takisi liltimu ye Mateyu keme, Allapiasinga malo Jemisi keme Tadiasi keme, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Olio Juda yomboma oliolio gapomano molamili.” niringi talape ye Saimono keme, Yesusi pe lipa opa-touma sirimu ye Judasi Isikeriote keme, akuma. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesusini aku ye engaki rurepo lipa mundupa onondo nimbale: “Yombo-lupama molemelena naa pangi. Sameria yombomanga taono senga kepe naala pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isirele yomboma mindi ononga kongi sipisipi pena lo liku pelemele mele aku siku molemele yomboma molemelena mindi pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ono molemelena pungí punguli, onondo “Pulu Yemo ye nokoli kingimu molopa yomboma nokomba walemo nondopa wendo ombá sekemo.” niliku pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Kuru tomba yomboma seko peanga siku, kolko lenge yomboma ‘Lomboroko ola molaa.’ ningu, kuru laká nombá yomboma ‘Umbu-kangi giliepili.’ ningu, kuru konopuna molopili molonge yomboma ‘Konopuna naa molangi, ongo wendo pangi.’ ningu selko pangi. I kongonomo sengemonga tondolomo kou se molo mélsene topo toko naa likimili kene anju yomboma aku siku liku tapondokole ningímuni, ‘Kou se liemili.’ ningu naala sangi. We sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Pungíndu kou-gollo mare molo kou-sillipa mare molo kou-kopa mare kakona panjiku mengo pu naa pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Méle-wale kepe wale-pakoli talo kepe kimbu-su kepe apulu-mingi kepe naa mengo we pangi. Yombo kongono sendelemomo kongono sendelemo yombomone kere-langi simba kinia papu kene mélse mei naa meangi. We pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pe kolea-awili senga molo kolea-kanga senga sukundu punguli ningímuni, yomboma mangilku pilkuli “Ye nawe ye peanga se molemomonga oliondo “Pea peamili waa.” nimbáye?” niengi. Kanu-kinia se ningu singí kinia pilku yu kanoko lendekole kanu yemonga ulkana pungu yu-kinia mindi pea peko molkole pe aku koleamo munduku kelko pangi. ⸤Ulka pinia-pinia naa andoko ulka seluringa mindi kere-langi nongo peangi.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","⸤Kolea senga pungu ye peanga se liku ora singí kinia kanoko lendeko⸥ yunga ulkana sukundu punguli ningímuni, ulka pulu yombomando “Ono konopu peanga pepili molaa.” nieyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kanu-kinia kanu yombomane “Pea peamili sukundu waa.” níngi liemu, ononga ungu peanga ningí kanumu kanu yomboma-kinia pepili. Aku-na-kolo kanu yombomane konopu peanga naa panjiku, “Pea peamili waa.” naa níngi liemu ungu peanga u sukundu punguli ningí kanumu “Ono-kinia naa pepili.” ningu, kelko mengo ⸤ono munduku kelko yando wangi⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Yombo sene onondo “Pea peamili waa.” ni naa ningu onone ungu ningíma pilku naa língi liemu kanu ulkamo molo kanu taonona yombo kirima munduku kelko pungíndu ⸤kanu koleana yomboma ‘Kamu molko kinjangi. Pulu Yemone ono lipa naa tapondomba mele piliangi.’ ningu⸥ ononga kimbuna kanu koleamanga ma gilimba mamo kulu toko pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nane ono paa sika nimbu sikirumu: “Kote walemo wendo ombá kinia kolea-awili Sodomo kinia Gomoratolo olonga yomboma ⸤u ulu-pulu-kiri awisili sika seringi-na-kolo⸥ olonga kote kanga mele pemba. Aku-sipa na-kolo i yombo onondo “Sukundu waa.” ni naa ningu ononga ungu pilku naa lingí yomboma kote walemo wendo ombá kinia ononga kote awilimu pemba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ono lipu mundukuru yema ono sipisipi melema, yombo owá-palako awili kirimane sipisipi topa nolemo mele yomboma molemelena ono lipu mundukuru. ⸤Nanga ungumu andoko ningu singí kinia pilku kiri pilkuli yombomane ono mindili liku singí.⸥ Yomboma owá-palako mele aku siku molemele kene kongi-ka wambiyema pilipa kondolimu paa pelemo-na uluma sembando mimi sipa pilipa selemo mele ono aku wambiyema mele molko, kera waembono molemo mele molangi. ⸤Aku keramone mélema mindili sipa sepa kinjimba ulu-pulu se naa pelemo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Yomboma mimi siku kanangi. Onone ⸤ ‘Na lombili andoli yomboma mindili nongo, kolangi.’ ningu,⸥ ono ⸤mare liku ambolkole⸥ kanjollomanga makumanga mengo pungu kote sendeko, ono ⸤mare⸥ Juda yomboma maku toko Pulu Yemonga ungumu pilielemele ulkamanga liku mengo pungu kopene tongela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ono nanga yomboma molongemonga ono ⸤mare ka siku⸥ yombo-lupamanga gapomano ye awilima kinia ye nokoli kingima kinia molongena ⸤kote sendengendo⸥ mengo pungíla. Aku siku senge kene ono onono kanoko kondoko molaa. Aku-na-kolo kote sendenge kinia kotena gilkuli kanu yema kinia kanu yema nokonge ye nokolima kinia onone ‘Nanga ungumu piliangi.’ ningu ono ningu singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aku-sipa na-kolo ono ka siku kote sendenge kinia ‘Kotena nambolka unguri nimulúnje? Olio ungu se mangilku pilingí kinia nambolka unguri pundu topo nimulúnje?’ ningu mini-wale naa mundangi. Aku senge enamonga ono ungu ningí mele pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ono ungu ningíma onono pilkuli naa ningí. Ononga ⸤mulu-koleana molemo⸥ Lapanga Minimu ononga kerena molopale nimba simba unguma onone anju ningí kene konopu kimbu naa siku, pilingí mele niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“⸤Aku walemanga⸥ genuni yunga genu ⸤nanga yombo molombamonga⸥ ‘Kolopili toko kondangi.’ nimba kote sendemba. Lapane yunga bolangoma akula sembá. Bolangomane kepe ononga anupili lapali-kinia mumindili kolko kotena mengo pungu “Toko kondangi.” ningíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nanga yomboma molongemonga yombomane pali ono-kinia konopu kiri panjingí, na-kolo na munduku naa kelko walema pora naa nipili tondolo munduku molonge yomboma ⸤Pulu Yemone⸥ lipa tapondopa ‘Mindili nonge koleana naa pungu, pea molopo kondopo mindi pamili.’ nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kolea senga yombomane ‘Ono mindili nangi.’ ningu seko kinjingí kinia kolea senga kowa pangi. Nane onondo paa sika nikirumu: “Ono kolea Isirele sukundu koleamanga pali andoko nanga kongonomo seko pora naa sindangi Mania Omba Mana-Ye Au Lierimu Yemo ⸤kelepa yando⸥ ombá.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mane sili ye se lombili pungu unguma pilielemele yomboma ‘Ononga mane sílimu maniandopa, ono olandopa.’ manda naa ningí. Kendemande-yombo sene ‘yunga nokoli yemo maniandopa, yu olandopa.’ manda naala nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lombili pumba unguma pilielemo yombomo kinia yunga ungu-mane silimú yemo kinia selu-siku molembele akumu manda. Kendemande yombomo kinia yunga nokoli yemo kinia selu-siku molembele akumu mandala. Ulka pulu yemonga ungu naa pilielemele yombomane yu-kinia mumindili kolko iri tongendo ⸤kurumanga nokoli Setenenga imbi manda manjiku⸥ “Yu Belsipuli” ningu imbi lemele kanumu. Pe kiniá ulka pulu yemondo aku siku níngi liemu yunga ulkana pelemele yombomando pali paa awili seko olandopa ungu kirima ningíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“⸤Nanga opa-toumane na seko kinjilimili mele ono na lombili andoli yema sika seko kinjingíla⸥ akumunga ono kanu yomboma pipili naa kolayo. Aki tolemo ungumanga selu kepe pe aki naa topa pali penambelena lemba. Lopi selemo ungumanga selu kepe pe lopi naa sembá. Kanu uluma kinia unguma pali yombomane pali pilingí kene pipili naa kolangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nane onondo simbulu tolina niliu unguma pa selina nieyo. Ungu ólo toko ningí onono komuna pilingí unguma ulka imuna ola gilku ru ningu niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kangimu mindi toko kondokole minimu manda toko naa kondonge yomboma pipili naa kolayo. ⸤Pulu Yemo mindi pipili kolayo⸥. Yuni kangimu kinia minimu kinia peatolo sepe-koleana manda topa kondomba kene yu-mindi pipili kolaa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Kera kaltendepele paa kangamo molemo, topo toko lingíndu kera talo pea kou mongo selu mele mindi pulimú kanumu. Aku-na-kolo se kolopa we mania naa pulimú. Kanu kerama na lombili andoli yombomanga ⸤mulu-koleana molemo⸥ Lapamone kanolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ono ⸤na lombili andolima⸥, ononga penge-indima kepe yuni koronga selu selu nimba pali kambu torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ononga ⸤mulu-koleana molemo⸥ Lapamone aku sipa ono molemele mele kanopa mololepa pulimú kene ⸤ ‘Yombomane olio seko kinjingí.’ ningu⸥ pipili naa kolayo. Kera kaltendepele yu kou paa koltalo mele pulimú-na-kolo kanu keramo Pulu Yemone kanopa molemo. Ono yomboma paa olandopa awilima kanopale ono paa nokopa kondopa molomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yombo sene yombomanga kumbikerena ola gilipale “Na Yesusinga yombomo molio.” nimbá kinia nane Tata mulu-koleana molemomonga kumbikerena ola gilipuli “Aku yombomo nanga yombomo.” nimbúla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aku-na-kolo yombomanga kumbikerena “Yesusi yu nawe? Yu na naa pilkiru.” aku sipa nimbá yombomo yu nane Tata mulu-koleana molemomonga kumbikerena “Aku yombomo yu nawe? Yu na naa pilkirula.” nimbú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“‘Ya mana-yomboma opa naa seko seluna konopu seluna pupili molangi.’ nimbu orundu.’ konopu naa leangi. Ono yomboma ‘Taka leko molko konopu seluna pupili molangi.’ nimbúndu naa orundu. ‘Mumindili kolko opa sangi.’ nimbúndu orundu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","‘Yombomane sangi.’ nimbúndu orundu mele i-sipa: “Ye sene yunga lapa kinia opa sepili, lemenu sene yunga anumu kinia opa sepili, malo senga menuni yunga bamu kinia opa sepili. Ulka seluna pelemele yomboma opa-tou molonge.” ‘Aku sangi.’ nimbúndu orundu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yombo sene na olandopa konopu naa mondopa, yunga lapa molo anumu olandopa konopu mondomba yombomo ‘Nanga yombo molopili.’ nimbúmu manda naa sembá. Yombo sene na olandopa konopu naa mondopa, yunga malo molo lemenu olandopa konopu mondomba yombomo ‘Nanga yombo molopili.’ nimbúmu manda naa sembá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yombo sene ‘Yu lombili pambo.’ nimbale yomboma unju-perana gilku mindili nongo kololemele mele yuni unju-pera mele gomo lembando ‘Na yu lombili pumbúndu mindili nondu liemu peangala; kolondu liemu peangala.’ naa nimu liemu ‘Nanga yombo molopili.’ nimbúmu manda naa sembá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yombo se ya ma-koleana ‘Na molopo kondopo, nondopo naa kolambo.’ nimba pilielemo yombo se kolopale kolea kirina mindili nomba molopa mindi pumbá. Aku-na-kolo yombo se na lombili andopa nanga kongonomo sendembando ‘Ya mana mindili nombo molombo kinia mandala, kolombo kinia mandala.’ nimbá yombo se konde molopa kondopa mindi pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ono kolea senga pungí kinia yombo sene ‘Pea molamili waa.’ nimba lipa tapondolemo yombomone na pea aku sipa lipa tapondolemóla. Na ‘Pea molambili ou.’ nilimú yombomone na “Ma-koleana pu.” nimba lipa mundorumu yemo ‘Pea molambili ou.’ nilimúla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yombo sene Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú yombo se olemo kinia ‘Yu Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú yombo se kene’ nimba pilipale “Pea molambili ou.” nimba lipa tapondolemo yombomo Pulu Yemone yunga ungumu nimba silimú yombomo méle kalomba mele kanu lipa tapondolemo yombomo kepe selu-sipa-mele kalombala. Yombo sene Pulu Yemonga ungumu pilipa lipa konopu sumbi nipili molemo yombo se olemo kinia ‘Yu Pulu Yemonga ungumu pilipa lipa konopu sumbi nipili molemo yombo se kene.’ nimba pilipale ‘Pea molambili ou.’ nimba lipa tapondolemo yombomo ⸤Pulu Yemone⸥ kanu yombo sumbi nili se méle kalomba kinia yu lipa tapondolemo yombomo kepe selu-sipa-mele kalombala. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yombo sene ono nanga lombili andoli yombo imbi naa mololi yombo se kanopa ‘yu nanga lombili andoli yombo se kene’ nimba kanopale yu lipa tapondopa we no kepe kolopa simu liemu nane ono paa sika nimbu sikirumu, “kanu yombomo paa sika méle kalólimu limba.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusini yu lombili andoli ye rurepondo yunga kongono sendenge mele mane sipa pora sipale nirimumuni, yu kanu koleamo mundupa kelepa kolea Gallilli disiriki taonomanga andopa mane sipa ⸤Pulu Yemonga⸥ ungumu nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","⸤Pulu Yemone “Nanga yomboma nokopa kondomba ye se lipu mundumbu.” nimba u nimba taltorumu ye nokoli⸥ Karasimuni ulu-tondoloma serimumunga Jono ka-ulkana pepa pilipale nirimumuni, “Yesusindu i-siku i-siku mangilku pilindangi!” nimba yu lombili andoli mare Yesusi molorumuna lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kanu yema Yesusi molorumuna ongo yu mangilku pilindiku ninguli: “Pulu Yemone olio nokopa kondomba yere “Lipu mundumbu.” nimba, nimba panjerimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo se lupa ombámo nokopo molamiliye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusini onondo pundu topa nimbale: “Onone ya kanokomele mele kepe pilkimili mele kepe pungu Jono ningu si-payo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mongo kiri lieli yomboma mongone kanoko, kimbu kiri lieli yomboma manda andoko, kuru laká nolima umbu-kangi gilipa, komu sílima komuni pilku, kolopa lielima ola molemele kepe, koropa pulima semane peangamo topo siliu pilielemelela kanumu. Aku siku Jono ningu sieyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na kanokole ‘Yu sika kanu yemo molemo.’ ningu kuru mondokole, kelko konopu talo naa panjiku molonge yomboma ono Pulu Yemone “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jono lombili andolima pungí puringi kinia Yesusini kelepa yombo awisili maku toko moloringimando Jonondo nimbale: “⸤Kolea ku lielina Jono no lindipa molorumu kinia⸥ ono kanu kolea ku lielina nambolka kanonge puringiye? Lkepania mele poporomene lope-lope sendepa molorumu se kanonge puringiye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","⸤Mólo kanumu. Alieli kanolemele mele kanonge naa puringi liemu⸥ ungu nambolkare kanongendo puringiye? Ye se mulu-maminia paa peangama pakopa molorumu-na kanonge puringiye? Akumu mólola. Yombo mulu-maminia paa peangama pakolemelema ye nokoli kingimanga ulkana manjiku molemele kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“⸤Aku sili se kanonge naa puringi liemu⸥ Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba sili ye se kanonge puringiye? Akumu sika na-kolo nane onondo nimbu sikiru: “Jono yu sika Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba sili ye se na-kolo yu Pulu Yemone ungu-umbu tondorumuma pilipa nimba sili ye we se mólo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yuni Pulu Yemone u “Lipu mundumbu.” nirimu yemonga aulkamo sepa wamomu kanumu. Kanu yemondo Pulu Yemonga bokuna sukundu molemo ungu se i-sipa: ‘⸤Pulu Yemone yunga Malondo nimbale:⸥ “Pilieyo. Nanga ungu se nindimba yemo nane nu puni aulkana yu kumbi lepo lipu mundukuru. Yuni nunga aulkamo akisindimba.” nirimu.’ kanu ungumu bokuna molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nane onondo paa sika nimbu sikirumu: “U mana moloringi yombomanga se No Lindeli Jono-kinia manda mólo. Jono olandopa mele. Aku-na-kolo kiniá wale kondemo wendo okomo. Kanu walemo Pulu Yemo ye nokoli kingimu molopa nokolemo yombomanga se paa imbi naa molopa paa koropa puli yombomo olandopa; Jono yu maniandopa.” nikiru. ⸤U moloringi yomboma mania mele; kiniá na ‘Sika.’ ningu kuru mondongemonga konopu peanga pemba yomboma olandopa.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Jono u mana naa omba molopili ungu-manema pelemo boku Mosisini torumuma kinia, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siku bokuna toringi bokuma kinia, aku bokumane Pulu Yemonga unguma ningu siku, Jono kinia Pulu Yemone “Ono nokomba ye nokoli se lipu mundumbu.” nimba, nimba panjerimu yemo kinia ongele mele unguma niringi. Aku-na-kolo Jono orumu kinia yandopa Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo ulumu paa tondolo mundupa wendo omba yunga opa-touma topa mania mundulimúla; ye enge nilimane aku ulumu ambolongendo tondolo munduku ta ningu lingí sekemelela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ungu se nimbú sekeromo pilielemolo konopu lingí liemu piliangi. Pulu Yemonga bokuna “⸤Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba simba ye⸥ Illainja ombá.” nirimu ye kanumu Jonondo nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","I nikiru mele komu gilimú yombomane paa mimi siku piliaa!” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kiniá mana molemele yomboma nambolka mélse ono manda manjipu manda nimbúnje? ⸤Ono molemele mele i-sipu nimbu siembo:⸥ Ono yomboma maku tolemele koleana bolangoma pepe pereko molemele mele. Kanu bolangomanga marene ne anju molemele bolango mare ⸤pea pepe pereko molonge aulka se koroko kelkole⸥ onondo mangilku ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Konane nímulu kinia ono ‘Pea konane niemili.’ naa ningu “Mólo.” níngi. Pe kelepo kola semulu kinia ono ‘Pea kola samili.’ ni naa níngi. ⸤Pea pepe perepo molomolo aulka se mólo lepomo.⸥” nilimili. ⸤Kiniá molemele yomboma ono kanu bolangoma mele molemele.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","⸤Na kinia No Lindeli Jono kinia oltone nilimbulu unguma onone pilku kiri pilielemele; selembolo mele kanoko kiri pilielemelela⸥. Jono ombale ga kinia no-waene kinia naa nomba molorumu kinia ⸤kanoko kiri pilku⸥ ninguli: “Yunga konopuna kuru se molemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pe Mania Omba Mana-Ye Au Lierimu Yemo omba ga kinia no-waene kinia norumu kinia ⸤kanoko kirila pilku⸥ ninguli: “Yu ga awisili nomba kiri pilipa, no-waene awisili nomba amu topa selemo yemo. Yu kou-takisi lili yema kinia, ulu-pulu-kiri selemele yombo wema kinia ‘Yu-kinia pulu liepili pea kopu sepo molamili.’ nimba selemo.” nilimilila. ⸤Onone aku siku Jono kanoko kirila pilielemele. Na kanoko kirila pilielemele.⸥ Aku-na-kolo pilipa kondoli ulu-pulumu Pulu Yemo-kinia pelemo-na yuni selemo sembá mele kanokole ‘Papu selemo.’ ningí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aku nimbale Yesusi kolea u andopa ulu-tondolo awisili serimu koleamanga ⸤moloringi yomboma⸥ yuni serimu mele kanokole ononga ulu-pulu-kirima kanoko kiri pilku munduku kelko konopu topele naa toringi kanopale yuni ono iri topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolea Korasini kinia Besaida taonotolonga ⸤molemele yomboma⸥ mindili nongo paa molko kinjingí! Kanu koleatolonga sukundu ungu tondolo awisili serindu⸤-na-kolo akuna molemele yomboma konopu topele naa tolemele⸥. Kolea awili Taya kinia Saidonotolonga sukundu ⸤ungu tondolo se naa serindu-na-kolo kanu koleatolonga sukundu⸥ nane ungu tondolo aku sipu selka kanolemolánje kanu koleatolonga ⸤yombomane⸥ ono ulu-pulu-kiri selemelema koronga munduku kelko, bulu siku, konopu topele tolemolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akumunga nane onondo nimbu sikiru: “Pe kote walemo wendo ombá kinia kanu kolea Taya kinia Saidonotolonga ⸤yomboma ulu-pulu-kiri selemelemonga⸥ ononga kote kanga mele pemba. Aku-na-kolo ono kolea Korasini kinia Besaidatolonga ⸤yomboma nane ulu-tondoloma serindu kinia kanokole konopu topele naa toringimunga⸥ kote walemo wendo ombá kinia ononga kote awili mele pemba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapeniame taono ⸤yomboma onone⸥ ‘Mulu-koleana pumbu molamili.’ konopu lekemeleye? Aku manda mólo. ⸤Onone nanga unguma alieli pilielemele-na-kolo konopu topele naa tolemelemonga⸥ ono kolea kirina pungu molonge. Ononga koleana sukundu ulu-tondolo awisili serindu⸤-na-kolo ono konopu topele naa toringi⸥. Kolea-awili Sodomo sukundu ⸤ulu-tondolo se naa serindu-na-kolo kanu koleana sukundu⸥ nane ungu tondolo aku sipu selka kanolemolánje yomboma konopu topele tolemolá, pe kiniá kepe kanu koleamo we lelka. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akumunga nane ono ⸤Kapeniame yombomando⸥ nimbu sikirumu: “Kote walemo wendo ombá kinia kolea Sodomo ⸤yomboma u ulu-pulu-kiri awisili sika seringi-na-kolo⸥ ononga kote kanga mele pemba. Aku-na-kolo ono kolea Kapeniame ⸤yomboma nane ulu-tondolo serinduma kanokole konopu topele naa toringi yomboma,⸥ kote walemo wendo ombá kinia ononga kote awili mele pemba.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aku walemanga Yesusini nimbale: “Tata, Mulu Matolo Nokoko Moleno Ye Nokolimu, nane nu-kinia ‘Ange.’ nikiru. “Olio pilipa kondoli pelemo. Olio oliolio ungumanga puluma pali pilipu kondolemolo.” ningu pilielemele yomboma ono nane kiniá selio ungumanga pulumu nuni ‘Naa piliangi.’ ningu naa ningu sirinu. Yombo bolango pame mele molko nane niliu unguma komu sendeko molemele yomboma mindi nane selio ungumanga pulumu ‘Piliangi.’ ningu, ono ningu sirinu kanumunga nu kape nimbu ‘Papu serinu.’ nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sika, Tata, nuni ‘aku sipa wendo ombá kinia konopu simbú.’ ningu aku siku serinumunga ⸤aku sipa wendo okomo⸥.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","⸤Pulu Yemondo aku sipa nimbale kelepa yombo moloringimando nimbale:⸥ “Mélema pali Tatane na sirimu. Yombo sene Malo paa sika molemo mele pilipa kanopa imbi silimú yombo se mólo; Lapane mindi yu kanopa imbi silimú. Yombo sene Lapa paa sika molemo mele pilipa kanopa imbi silimú yombo se mólo. Malone mindi kanopa imbi silimú; Malone ‘Lapa lipu ora siembo.’ nimbá yomboma ono Lapa kanoko imbi singíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ono kongono mindili siku selemele yomboma kinia, konopuna umbuna selemo yomboma kinia, na moliona wayo. Onge kinia na pea konopu seluna pumbámonga nane ‘Konopu pe nipili koro molaa.’ nimbú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nando “Nunga kongono seleno mele pea ambolambili. Nu nanga ungu-mane sílimu molani. Nunga ungu ninima pilipu lipu molambo.” ningu sayo. Na taka lepo molopo, yombomane na seko kinjilimili kinia pilipu siye kolopo molio-na i nikiru mele ono na molombona ongo senge kinia ononga konopuma pe nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nanga kongono seliomo pea ambolombolo kinia taka leko sení. Méle pe nilima mindi siliu kene moliona waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Walte, ⸤koro moloringi⸥ wale Sambate senga, Yesusi kinia yu lombili andolima kinia rasi-witi kaliamanga ongo puringi kinia yu lombili andoli yema gelene kolkole rasi-witi mongo mare inia toko noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aku seringi kinia kanokole Parisi yemane Yesusi yundu ninguli: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa sangi.’ nimba pelemo ungu-manemo nu lombili andoli yemane ungu-manemo pulua tokole aku siku sekemele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesusini pundu topa nimbale: “Ono Pulu Yemonga bokuna sukundu ⸤anda-kolepa ye nokoli kingi⸥ Depitini serimu mele nimba molemo semanemo kanokole semanemonga pulumu naa pilielemeleye? Depiti kinia yu pea puringi yema kinia ono gelene kolkole niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Depiti Pulu Yemo molorumu serele-ulkana sukundu pumba, Pulu Yemonga kumbi-kerena lierimu pellawa kalolima lipa nomba, yu pea puringi yema sirimu noringila kanumu. Kanu pellawa kalolimando Pulu Yemone ungu-mane se sipa nimbale: “We-yombomane paa naa nangi! Pulu Yemo popo tondoli yema manjiku nangi!” aku sipa mele nirimu ⸤kanu ungu-manemo pulua torumu⸥ kanumu. ⸤Ono konopu talo nambi semu-na lemeleye? Depiti yuni u aku serimu mele ono pilku kiri naa pilielemelemonga pe kiniá na lombili andoli yemane sekemele mele naa kanoko kiri piliaa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ungu-mane se pelemóla. “Pulu Yemo popo tondoli yemane ⸤koro mololi⸥ wale Sambatemanga Pulu Yemonga ulkana kongono selemele kinia Sambate walemanga ungu-manemo pulua tolemele-na-kolo aku kongono selemelemonga mongo naa pemba.” nimba molemo akumu naala pilielemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nane onondo nimbu sikiru: “Méle konde se kiniá pelemo akumu Pulu Yemo popo toko kalolemele ulka-tembelemonga olandopamo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","⸤Pulu Yemone nirimu ungu se yunga bokuna molemo mele i-sipa:⸥ “Onone yomboma kondo kololemele kinia kanopo peanga pilielio. Na popo toko kongima kalolemele akumu unguri mólo.” nilimú, akumunga ungu-pulumu ono Parisi yemane pilielemolánje i ye ulu seko naa kinjikimili yema “Seko kinjikimili.” naa nilimolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mania Omba Mana-Ye Au Lierimu Yemone Sambate walema nokolemo yemo molemo-na ⸤Sambate wale-kinia yomboma molko kondongendo senge mele manda nimbá kanumu⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kanu-kinia Yesusi aku koleamo mundupa kelepa pumba Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka senga purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kanu ulkana ye se molorumu, yunga ki se kamu kolopa kukorumu. Kanu-kinia akuna moloringi ye marene ‘Yesusini sepa kinjimba kinia kote sendamili.’ ningu yu mangilku pilku ninguli: “Koro molemolo wale Sambate-kinia yombo kuru tolemoma sepo peanga simulú kinia manda molo aku semulu liemu Pulu Yemonga ungu-manemo pulua tomoloye?” ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesusini yemando pundu topa nimbale: “Sambate wale kinia ye senga kongi sipisipi se muruna topa mania mundumba kinia sipisipi ari selemo yemone kundupa ola lipa memba naa ombáye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aku liemu sipisipi maniandopa mele, yomboma paa olandopa, akumunga, Sambate wale kinia ulu peangama manda naa semoloye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aku nimbale ki kolopa kukorumu yemondo nimbale: “Nunga kimu siniu si.” nirimu kinia yemone yunga kimu siniu sirimu kinia yunga ki ekendo peanga lierimu mele ki kiri lierimumu kelepa kamu peanga lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aku-sipa na-kolo ⸤Yesusini aku serimu kinia kanokole⸥ Parisi yemane pena pungu maku toko “Yu nambi sepo topo kondomoloye?” ningu aulka se kororingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","⸤Parisi yemane⸥ yu tonge seringi pilipale Yesusi aku koleamo mundupa kelepa purumu. Kanu-kinia yombo awisili Yesusi purumu mele yu lombili puringi kinia yuni yombo kuru torumuma pali sepa peanga sipa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nimbale: “Na sika yemo molopole i ulu-tondoloma sekero mele onone yombo lupa marendo naa ningu siee!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aku sipa wendo orumumunga koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane ulu se pe wendo ombá u nirimu mele kamu wendo orumu. Aisayane nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“I yemo nanga nimbu taltorundu kongonomo sendeli yemo; nane i yemo konopu mondopo, yu kanopo paa peanga pilielio yemo. Nanga Minimu yunga konopuna panjindimbu. Yuni ma-koleana yomboma pali nane ono sumbi sipu nokombo mele nimba simba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yombomane yu iri tonge kinia yuni pundu topa ungu se naa nimba, ungu se tondolo mundupa naa nimba, yomboma andoko molemele koleamanga yuni opa-ungu naa nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kamaye enge naa nilimú se elke naa topa, sepe-llame mimi sipa naa nolemo kinia kamu topa naa kumundumba. ‘Pulu Yemone yomboma kamu sumbi sipa nokomba walemo kamu wendo opili.’ nimba yu aku sipa naa sepa taka lepa molomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanu-kinia mana-yomboma pali ‘Yuni ‘olio mindili naa namili.’ nimba lipa tapondomba.’ ningu molonge.” nirimu ungu akumu wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kanu-kinia ye se yunga konopuna kuru se molorumu-na mongo kiri lepa mélema naa kanopa ungu naa nirimu ye se Yesusi molorumuna mengo oringi kinia Yesusini yemo sepa peanga sirimu kinia kanu yemo ungu nimba mélema kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aku serimu kanokole yombomane pali mini-wale munduku ninguli: “I yemo ⸤ye nokoli kingi⸥ Depitinga Malonje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aku-sipa na-kolo aku niringi ungumu pilkuli Parisi yemane ninguli: “Mólo. Kurumanga nokoli Belsipuli mindi i ye Yesusinga konopuna molopale yu tondolo silimú-na yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Onone aku siku konopuni pilieringi mele Yesusini pilipale ⸤ ‘Yesusi ‘Setene-kinia opa-tou moloringimunga Setenene yu naa lipa tapondolka.’ ningu paa piliangi.’ nimba⸥ onondo nimbale: “Yombo talape se konopu seluna naa pupili molko suku-singina ówa panjiku ono onono opa seko lupa lupa molemele kinia kanu talapemo pora nilimú. ⸤Molo⸥ kolea senga yomboma molo ulka seluna pelemele yomboma konopu seluna pupili naa molko ono onono opa selemele kinia kanu yombo talapemo sungu siku yu-mele-mele molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aku sipala, Setenene yunga kuru se makorolkanje aku selkamonga yunga talapemo kinia opa mele selka. Pe yunga talapemo nambi sepa manda molemoláye? ⸤Pora nilka.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Ungu se piliangila. Nane Belsipulinga tondolomone kuruma makorolio liemu ononga yemane nawenga tondolomone kuruma makorolemeleye? Akumunga, ⸤ononga ye kuruma makorolemele yemane ‘Pulu Yemone olio tondolo silimú-na olione kuruma makorolemolo.’ ningu pilielemele-na⸥ onone nando i nikimili unguma kanu yemane pilku apurukuli “Ono kolo tokomele.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aku-sipa na-kolo sika Pulu Yemonga Minimuni na tondolo silimú-na nane kuruma makorolio liemu Pulu Yemo ye nokoli kingimu molopa yomboma nokomba walemo ono molemelena koronga wendo omu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ungu se pea i-sipa: Ye enge nili sene yunga ulkamo nokopa kondolemo kinia ye sene we manda sukundu omba mélema wa lipa memba pulimúye? Akumu manda mólo. U wa noli yemone ye enge nílimunga kimbu kima ka topale yunga ulkana manda omba mélema wa limú kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na naa lipa tapondolemo yombomone na-kinia opa-tou molemo. Yombo sene na lipa tapondopa ⸤kongi sipisipima⸥ sukundu naa limú yombomone ⸤kongi sipisipima⸥ topa bulu-balu silimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Akumunga, nane onondo nikiru: “Yombo sene ulu-pulu-kirima sepa, ungu-taka tondopa nimba kinjilimú uluma Pulu Yemone manda ‘Mania pupili.’ nimba siye kolomba. Aku-sipa na-kolo yombo sene Pulu Yemonga Minimu nimba kinjipa ungu-taka tondopa yunga imbimu marake mele semba uluma Pulu Yemone ‘Mania naa pupili.’ nimba siye naa kolomba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mania Omba Mana-Ye Au Lierimu Yemo ungu-taka tondopa ungu nimba kinjilimú yombomo aku sipa ulu-kiri selemoma Pulu Yemone ‘Mania pupili.’ nimba siye kolomba. Aku-sipa na-kolo Mini Kake Sélimu⸤ni ulu se selemo kinia⸥ yombo sene ungu-taka tondopa, opa sepa sipa ⸤ “Yuni naa sekemo. Kurumanga nokoli Setenene yu lipa tapondolemo-na aku selemo.” ⸥ nilimú yombomo aku sipa ulu-kiri selemomo kiniá kepe mulu ma pora nimbá wale kinia kepe ‘Mania naa pupili.’ nimba paa siye naa kolomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Unju peanga se kanokole ‘Mongo peangama tomba nomolo.’ ningu kanolemele. Unju kiri se kanokole ‘Mongo kirima tomba manda naa nomolo.’ ningu kanolemele. Unju se mongo tolemo kinia kanokole ‘I unjumu peanga, i unjumu kiri.’ ningu apuruku kanolemelemonga aku siku ningu kanolemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ono Parisi yema, kolo topa yomboma sepa kinjeli wambiyemonga waloma, ono ye kiri molemelemane nambi seko ungu peangama manda ningíye? Yombo se yunga konopuna pelemo unguma mindi kerena nilimú akumunga ono ye kirimane nambi seko ungu peangama manda ningíye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aku sipa mele, yombo peanga sene yunga konopuna ulu peanga pelemoma selemo, aku-na-kolo yombo kiri sene yunga konopuna ulu-kiri pelemoma selemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","“Akumunga nane onondo nimbu sikirumu: “Pulu Yemone yomboma kote sendemba walemonga onono ungu nilimilima apurupa pilipale “Nu yombo peangamo, nu yombo kirimu.” nimbá akumunga yombomane mana we ungu nilimilima pali kepe apurupa pilipale “Aku unguma nambi semu-na niringiye?” nimbá.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kanu-kinia Parisi ye mare kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye mare kinia onone Yesusindu ninguli: “Ungu Mane Sili Yemo, ‘Nu sika Pulu Yemone ‘Kongono sendani.’ nimba mana lipa mundorumunje olio kanamili.’ ningu Pulu Yemone mindi manda ulu-tondolo selemo mele se sei.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesusini pundu topa nimbale: “Kiniá mana molemele yomboma kiri mindi molemele. Ono seko kinjiku Pulu Yemo pilku mokoli selemele yombomane “Pulu Yemone mindi ulu-tondoloma manda selemo mele kanamili sei.” ningu na mawa selemele. Aku-na-kolo ⸤Pulu Yemone na lipa mundorumu-na ombo molkoro. Yu-kinia kopu sepo kongono selembolo mele lipa ora simba ulu-⸥tondolo se wendo naa ombá. Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Jona-kinia wendo orumu ulu akumuni mindi lipa ora silimú manda kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oma awili sene Jona topa penge mundorumu kinia yu omamonga olona ipulieli tangoli wale yopoko molopa perimu ⸤kinia omamone yu nomu kelona meku topa wendo mundorumu kinia yu kelepa we molorumu⸥ mele Mania Omba Mana-Ye Au Lierimu Yemo ⸤kolomba óno seko panjingí kinia⸥ aku sipa ipulieli tangoli wale yopoko mana sukundu pepale ⸤lomboropa ola molomba⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“U kolea-awili Ninipa yomboma ⸤sika molko kinjeringi-na-kolo Pulu Yemone ungu-umbu tondorumu mele⸥ Jonane ⸤pilipa⸥ Ninipa yomboma pumba nimba sirimu kinia pilkuli seko kinjeringi mele kanoko kiri pilku konopu topele toko molko kondoringi. Aku seringimunga kiniá molemele yombomane Jonanga olandopa ye se ya molemo yemonga ungumu pilku mokoli seko naa pilielemelemonga kote walemo pe wendo ombá kinia Ninipa yombomane kotena gilku, kiniá molemele yombomando “Seko kinjeringi. Mindili nonge kinia peanga.” ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“U olio Isirele yombomanga ye nokoli kingi Sollomono yu ye paa tondolo se molopa, yu ungu lupa lupama pilipa kondolimu pepili molorumu mele kolea Sipa nokorumu ambo nokoli kuwinimu pilipale, Sollomonone ungu peangama mindi nirimu mele pilimbando yu kolea suluna molopale ⸤Sollomono molorumuna⸥ wale awisili aulkana pelepa orumu. Aku sipa serimumunga, ye nokoli Sollomononga olandopa ya molemo yemone nilimú ungumu kiniá mana molemele yombomane naa pilku, mokoli selemelemonga kote walemo wendo ombá kinia kolea Sipa ambo nokoli kuwinimuni nimbale: “Nane Sollomonone ungu peanga nirimu mele pilimbundu aulka suluna orundu-na-kolo Sollomononga olandopa molorumu yemone nirimu ungumu ono naa pilku, mokoli seringi yomboma aku seringimunga ono papu mindili nonge.” nimbá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kuru se ye senga konopuna wendo ombale, no naa mololi koleamanga pumba manda koro molomba kolea se korolemo. Se naa kanopa lendepale ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yuni nimbale: “Na u molopole wendo ondu ulkana kelepo pambo.” nimba yu omba yu u molopa purumu ulkamo kanolemo kinia ulka pole lepa sepa peanga sepa we lepa yombo se naa molemo kinia kanopale nilimúmuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yu kelepa anju pumbale kuru kara puli paa olandopa yopoko-pakara lipa memba omba ono pea kanu ulkana sukundu pungu molemele. Kanu-kinia kanu yemo u molopa kinjilimú-na-kolo pe paa kamu olandopa mele molopa kinjilimú. Aku sipa, kiniá ya seko kinjiku molemele yomboma pe kamu molko kinjingí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesusi yombo maku toko moloringima ungu-mane sipa molopili yunga anumu kinia genupili kinia yu-kinia ungu ningíndu ongo pena gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yombo sene yundu nimbale: “Aminia kinia genali kinia onone nu-kinia ungu ningíndu ongo pena gilimili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesusini yundu pundu topa ⸤ungu-iku topa⸥ nimbale: “Nanga anumu nawe? Nanga genupili namele?” nimbale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","yu lombili andoli yomboma lipa ora sipa nimbale: “I yomboma nanga anumu kinia nanga genupilima molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nanga Lapa mulu-koleana molemomone “Sangi.” nilimú mele pilku liku selemele yomboma nanga anumu kinia nanga genupili kinia nanga kemulupili molemelemonga aku sipu nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yombo maku toko moloringimando aku sipa nimba pora sipale nirimumuni, Yesusi ulkana molopa pena pumba nomu kelona pumba mania molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yombo paa awisili yu molorumuna ongo maku toko moloringimunga nona andoli sipi se nona ola lierimumunga suku pumba mania molorumu, yomboma nomu kelona gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yuni onondo ungu awisili nimba simbando ungu-iku pokore torumu. Ungu-iku se i-sipa topa nimbale: “Piliame! “Ye sene rasi-witi umbu kaliana andopa tanda sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tanda silipa andorumu kinia umbu mare aulkana mania purumu, kanuma keramane ongo liku noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Umbu mare kou perimuna mania pumbale ma kanga-kolte mindi lierimu-kulu nondopa tóko nimba wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aku-na-kolo pulkonio naa mundorumu-kulu ena serimu kinia kanuma kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Umbu mare siri-ka mélemo molorumuna mania purumu, siri-ka mélemo wendo omba witi umbuma topa norumu-kulu omba peanga naa lepa ⸤mongo se naa torumu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Umbu mare ma peangana mania purumuma wendo omba mongo peangama torumu. Mare mongo towapu kise mele topa, mare mongo towapu yopoko mele topa, mare towapu selu mele torumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","⸤Aku nimbale⸥ “Yombo komu-pea lemomane i ungumu piliaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesusi lombili andolima yu molorumuna ongo yundu ninguli: “Nu yombomando ungu se ninindu ungu-ikuma alieli nambi semu-na tolenoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yuni onondo pundu topa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma kinia mélema kinia nokolemomonga ulu-pulu yu yuyu pilierimu kanu ulu-puluma ‘Kiniá ono ⸤na lombili olemele yomboma⸥ piliangi.’ nimbale ono nimba sikimu. Aku-na-kolo we-yomboma nimba naa sikimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pulu Yemonga ungumu pilku molemele yomboma paa olandopa nimba simba pilingí. Pe paa awisili pilingí. Aku-na-kolo naa pilku molemele yomboma ono kanga-kolte pilielemele ungumu kepe wendo limba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","‘Ono mongone kanokole naa kanoko, komuni pilkuli naa pilielemele.’ akumunga nane we-yomboma onondo ‘Unguma nimbu siembo.’ nimbuli ungu-ikuma mindi topo siliu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Aku siku seko molemelemonga koronga-u Pulu Yemone ungu-umbu tondorumuma yomboma nimba sirimu ye Aisayane “Aku siku senge.” u nirimu mele wendo olemo. Aisayane nimbale: “Onone alieli komuni pilingí-na-kolo konopuni pilkuli paa naa pilingí; mongone kanonge-na-kolo mélse paa sika naa kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","I yombomanga konopuma paa pipi silimú; onone ungu pilingindu komu naa sendeko molemele; ononga mongoma kumbulku molemele. Aku siku seko molemelemonga naa kanoko naa pilku molemele. I uluma aku sipa naa selkanje onone ononga mongone kanoko komuni pilku konopuni pilkuli topele tolemolá, kanu-kinia nane ‘Ono peanga liepili molangi.’ nilka.” nirimu. ⸤Aisayane aku sipa nirimu mele⸥ aku siku kiniá we-yomboma seko molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Aku-sipa na-kolo ⸤na lombili andolima⸥ onone mongone paa sika kanoko komuni paa sika pilku molemelemonga ono Pulu Yemone “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nane onondo paa sika nimbu sikirumu: “U moloringi yomboma, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema kinia, Pulu Yemonga unguma pilku liku sumbi siku moloringi yomboma kinia, kanu yombo awisili kiniá ono mongone kanoko molemele mélema kinia uluma kinia kanongendo “Kanamola!” ningu moloringi-na-kolo naa kanoringi. Ono kiniá komuni pilku molemele unguma pilingindu “Piliámola!” ningu moloringi-na-kolo naa pilieringi akumunga ⸤nane “Kiniá sika kanoko sika pilielemelemonga ono Pulu Yemone sewi anjilimú aulkana molemele.” nikiru⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Akumunga, yombo sene rasi-witi umbu tanda sirimu ungu-ikumunga pulumu kiniá niembo piliayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","⸤Umbu mare tanda sirimu aulkana mania purumu kanumanga ungu-pulumu i-sipa:⸥ Yombo sene Pulu Yemo ye nokoli kingimu molopa mélema nokolemomonga ungumu pilipale naa pilielemo kinia ulu-kirimanga pali ulu-pulumu pelemo ⸤kuru⸥muni omba umbu tanda sili konopuna pumba pelemoma waltikele toropa wendo limú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Umbu mare tanda sirimu kou perimuna mania purumuma yombo mare aku sílima molemele. Onone ungumu pilkuli waltikele sumbi siku konopu siku pilku limili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aku-sipa na-kolo ono pulkonio naa mundukuli ungumu kanga-kolte mindi pilku molemele. Pe ono konopuna umbuna selemo kinia molo ono Pulu Yemonga ungumu pilku liku molemele mele yombo lupamane kanoko kiri pilkuli ungu-taka tondoko seko kinjiku mindili silimili kinia ononga pilielemele unguma siye kololemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Umbu mare tanda sirimu siri-ka mele molorumuna mania purumuma yombo mare kepe aku sílima molemele. Onone ungumu pilielemele kinia konopuna umbuna selemo umbunama kinia, méle awisili taltokole ‘Aku mélemane olio lipa tapondolemo tapondomba.’ ningu pilku molemele uluma kinia, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinia ungumuni uluri naa sepa kere-langi mongo naa tolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Umbu mare tanda sirimu ma peangana mania purumuma yombo mare aku sílima molemele. Onone ungumu pilkuli ungu-pulumu pilku kondolemele. Pe ono kere-langi mongo tolemele. Kanu yombo marenga kere-langi mongo towapu kise mele topa, yombo marenga mongo towapu yopoko mele topa, marenga mongo towapu selu mele topa, aku sipa tolemo. Ungu-ikumunga ungu-pulumu aku sipa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesusini ungu-iku se pea yomboma topa sipa nimbale: “Pulu Yemo ye nokoli kingimu molopa mélema nokolemo akumu i-sipa mele: Ye sene yunga kaliana rasi-witi umbu peangama tanda sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aku-na-kolo yomboma uru peringi kinia yunga opa-tou ye se omba era ⸤rasi-witi none seli era⸥ umbu se witi kaliana tanda sipale kelepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kanu-kinia umbu peangama wendo omba witi mongo torumu kinia era kinia pea wendo orumu mele mona molorumu kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kanu-kinia kalia pulu yemonga kongono sendeli yema ongo yundu ninguli: “Ye-Awilimu, nunga kaliana kere-langi umbu peangare tanda naa sirinuye? Pe kiniá era nambi sepa wendo okomoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yuni onondo nimbale: “Sena. Opa-tou ye sene aku era umbuma omba tanda sirimu lepomo.” nirimu. Kongono sendeli yemane ninguli: “‘Era pea waka-maka wendo okombele kene pumbu erama akupu lipu maku tamili.’ konopu lekenoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aku-na-kolo yuni nimbale: “Mólo. Era sengi liemu witi pea pulu akungínje. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Witi pe kamu lipu maku tomolondo u pea ongo molangili. Pe witi kamu limulú walemo wendo ombá kinia nane witi kari leko lindingí yombomando nimbuli: “U era kalongendo liku piye seko maku tokole ningímuni, pe witi liku nanga witi taltolio ulkana maku toko taltangi.” nimbú.” nirimu.” nimba, Yesusini “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu aku sipa mele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ungu-iku se pea yomboma topa sipa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa mele: Ye sene unju masetete umbu se lipa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","yunga kaliana umbumu mundorumu. Masetete umbu akumu kere-langi umbumanga pali yu paa kangamo na-kolo wendo omba awi lemo kinia kaliana molemo mélemanga pali yu paa awilimu. Kamu awi lepa unju mele gilimú kinia kerama kanu unjuna ongo kolamanga pelemele. ⸤Pulu Yemo ye nokoli kingimu molomba mele aku sipa.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ungu-iku se pea yomboma topa sipa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa mele: Ambo sene yu kere-langi pellawa akondoli méle isi kanga-kolte pellawa awisilinga mundorumu kinia pellawa pali akorumu. ⸤Pulu Yemo ye nokoli kingimu molomba mele aku sipa.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kanu unguma pali Yesusini yombomando nimbando yu ungu-iku mindi topa nirimu. We ungu se onondo sumbi sipa naa nimba ungu-iku manjipa topa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aku sipa serimumunga koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye sene u nirimu ungu se kamu wendo orumu. Akumu i-sipa: “Nane i ⸤ungu nimbúndu⸥ ungu-iku ⸤manjipu⸥ topo nimbú. Pulu Yemone u mulu matolo serimu kinia kepe yandopa yandopa kepe ⸤ningu wendo munduku naa niringi⸥ lopi sepa perimu unguma ⸤nimbúndu ungu-iku mindi topo⸥ nimbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","⸤Yesusini ungu-iku akuma topa pora sipale,⸥ yu maku toko moloringi yomboma mundupa kelepa ulkando purumu kinia yu lombili andolimane yu molorumuna ongo ninguli: “Kaliana era orumu ungu-ikumunga ungu-pulumu olio ningu para si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yuni pundu topa nimbale: “Kere-langi umbu peangama tanda sirimu yemo Mania Omba Mana-Ye Au Lierimu Yemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kaliamo ma-kolea pali. Kere-langi umbu peangama yombo ‘Pulu Yemo nanga ye nokoli kingimu molopili.’ nilimilimunga ononga konopumanga Pulu Yemone tapu sepa molopa nokolemo yomboma. Era-umbu akuma ulu-kirimanga pali ulu-pulumu pelemo ⸤kuru⸥munga yomboma. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Era-umbu tanda sirimu opa-tou akumu ⸤kurumanga nokoli⸥ depelemo. Witi sukundu liku maku tonge wale akumu ma-kolea pora nimbá walemo. Witi mongoma sukundu lingí yomboma mulu-koleana angelloma. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Erama liku maku tokole sepena kalolemele mele ma-kolea pora nimbá walemonga aku sipa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mania Omba Mana-Ye Au Lierimu Yemone yunga angelloma lipa mundumba, onone ‘Yomboma Pulu Yemonga unguma naa pilku, seko kinjiku molangi.’ nilimili yomboma pali kinia, ulu-pulu-kiri selemele yomboma pali kinia, Pulu Yemone tapu sepa molopa nokolemo yomboma molongena wendo liku maku tokole ningímuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","sepe awili nomba pelemo koleana sukundu toko mundungí, kanuna yomboma kola seko paa mindili nongo pereko molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kanu walemanga konopu sumbi nili yomboma ononga Lapa ye nokoli kingimu molopa nokolemo koleana ena pa selemo mele ono aku siku kanuna pa sepili molonge. “Yombo komu-pea lemomane i ungumu piliaa.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","⸤Yesusini aku nimbale kelepa nimbale:⸥ “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa mele: Kou-mone mokopu se kalia senga u lopi seringi we perimu kanumu ye sene pe walte kanopa lipale kelepa aki torumu. Aki topale konopu sipa pumba yunga mélema pali lipa makete sepa kou pokore yando lipale kanu kaliamo pumba topo topa yando liltimu. ⸤Pulu Yemo ye nokoli kingimu molomba mele aku sipa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipala: Kou-bisinisi seli ye sene kulumbu se ‘pélle’ nili peangama koropa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kanu-kinia kulumbu pélle kou paa awisili puli se kanopale nirimumuni, yu pumba yunga mélema pali makete sepa kou yando lipale kanu kulumbu péllemo topo topa yando liltimu. ⸤Pulu Yemo ye nokoli kingimu molomba mele aku sipa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa melela: Oma lili wale se nomuna toko mundoringi kanumuni oma lupa lupama liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Walemo paa peke lierimu kinia kunduku liku nomu kelona taltokole, mania molko apurukuli peangama liku wale-basikete pokorenga mundoringi-na-kolo kirima toko eltoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Ma-koleamo pora nimbá walemonga aku sipala: Mulu-koleana angelloma ongole ningímuni, yombo seko kinjiku molongema kinia yombo sumbi siku molko kondongema kinia liku apuruku ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yombo seko kinjiku molongema liku sepe awili we nomba pelemo koleana toko sukundu mundungí, kanuna kola seko paa mindili nongo pereko molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","⸤Ungu-ikuma topa pora sipale Yesusini lombili andolima mangilipa pilipa nimbale:⸥ “Aku unguma pali ungu-puluma ono piliengiye?” nirimu. Onone yundu ninguli: “Piliemulu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yuni onondo nimbale: “Aku liemu Pulu Yemonga ungu-manemanga puluma pilku mane silimili yemane Pulu Yemo ye nokoli kingimu molopa yomboma nokolemomonga unguma mane silimulu kinia pilku liku molemele kanu yema ono i-sipa: Ulka pulu ye sene yunga méle peanga kande-kande taltolemomanga méle kondema kinia méle uma kinia pea wendo limú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusini aku ungu-ikuma topa pora sipale kanu koleamo mundupa kelepa yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mundupa kelepa pumbale yunga pulu-kolea ⸤Nasarete⸥ taonona ombale Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkana sukundu pumba yomboma mane sirimu kinia pilkuli ono pungu-pungu ningu mini-wale munduku ninguli: “I yemo yunga pilipa kondolimu kinia yunga ulu-tondolo selemomanga tondolomo kinia yu sena liltimuye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yu ulkama takorumu yemonga malo móloye? Maria yunga anumu naa molemoye? Jemisi, Josepo, Saimono, Judasi keme, yunga genupili móloye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yunga kemulupili kinia pali olio kinia pea naa molemoloye? ⸤Yu paa sika aku yemo molemomo.⸥ Aku liemu yunga pilipa kondolimu kinia yunga ulu-tondolo selemomanga tondolomo kinia yu sena liltimuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","⸤Aku siku unguma ningu⸥ yu ungu nimba uluma sepa molorumu mele kanoko kiri pilku yu-kinia paa konopu kiri panjeringi. Kanu-kinia ⸤ono yu-kinia mumindili koloringimunga ulu-pulumu pilipale⸥ Yesusini onondo nimbale: “Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye se koleamanga pali imbi ola molemo, yombomane pali yunga unguma pilku limili. Aku-sipa na-kolo yunga pulu-koleana yu-kinia pea kopu seko molemele yomboma mindi yuni nilimú ungumu pilkuli ‘Yu olionga we-yere. Yu imbi mololi ye se mólo.’ ningu yu nilimú unguma naa pilku, liku bulu silimili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kanu-kinia yu ⸤ungu nimba uluma sepa yu yuyu molorumu mele ‘Sika.’ ningu⸥ kuru naa mondoringimunga yu kanu koleana ulu-tondolo awisili naa serimu, koltalo mindi serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kanu walemanga kolea Gallilli disiriki nokorumu ye nokoli kingi Erotene Yesusini serimu mele semane toringi pilipale ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yu-kinia kopu seko molko yu liku tapondoringi tapu-yemando nimbale: “I unguma selemo yemo No Lindeli Jono lepomo! Yu kolopale lomboropa wendo omumunga ulu-tondoloma sembá tondolomo yu-kinia pelemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","⸤Kingi Erotene aku sipa nirimu ungumunga pulumu i-sipa:⸥ U walte Erotene yunga genu Pillipunga ambo menu Erodiasi mangopa liltimu. ⸤No Lindeli⸥ Jonone Erote aku sipa serimu kanopale yundu alieli nimbale: “Nuni ⸤Pulu Yemonga⸥ ungu-mane se pulua toko genanga ambomo mangoko liltinu. Akumu seko kinjerinu.” nirimu kinia Erotene yu lipa ka sipa ka-ulkana panjerimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka-ulkana panjipale ‘Yu topo kondambo.’ konopu lierimu-na-kolo we-yombomane ‘Jono yu Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye se molemo.’ ningu kanoringimunga yu pipili kolopale Jono topa naa kondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe walte kingi Erotenga meringi walemo wendo orumu kinia Erodiasi lemenu ulkana sukundu omba, yema maku toko kanoko molangi yu denisi serimu. Erotene ambo-wenepomo aku serimu kanopa paa peanga pilipa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yundu nimbale: “Nando “Si.” nini mélemo paa sika simbú.” nimba, nimba panjipa Pulu Yemonga imbi lepa mi lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yuni aku sipa nirimu-na anumuni pilipale lemenu ungu se nimba sirimu kinia pilipale ambo-wenepomone Erotendo nimbale: “No Lindeli Jononga ⸤nomimu kari leko yunga⸥ pengemo pellete senga taltoko yando si.” nirimu. ⸤Jonone u alieli “Erote kinia Erodiasitolone seko kinjeringili.” nirimumunga mumindili kolopale Erodiasini ‘Yu kolopili. Sika kolomunje na kanambo.’ nimba “Pengemo ongo si.” nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Yuni aku sipa mele mawa serimu-na pilipale Erote konopu umbuna serimu-na-kolo yuni “Paa sika simbú.” nimba, nimba panjipa Pulu Yemonga imbi lepa mi lierimu mele kepe, yu konopu topele tomba kinia yu-kinia pea kere-langi nongo moloringi yema yu kanoko kiri pilingí mele kepe, aku ungutolo pilipale, ka-ulkana nokoringi yemando ungu se nimba mundupale “Yuni mawa sepa “Si.” nikimu mele siengi kene ⸤No Lindeli⸥ Jononga ⸤nomimu kari leko yunga⸥ pengemo yando mengo waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aku nirimu kinia pilkuli Jono toko kondoko, yunga pengemo pellete senga taltoko, yando mengo ongo ambo-wenepomo siringi kinia yuni lipa anumu molorumuna memba pumba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aku seringi pilkuli Jono lombili andoringi yema ongo yunga ónomo liku mengo pungu óno sekole Yesusi molorumuna pungu semane toko siringi. ⸤Kingi Erotene No Lindeli Jono u aku sipa topa kondorumu kolorumumunga pe Yesusini ulu-tondoloma serimu mele pilipale “Jono nomi kari lierindu yemo lomboropa ola molemo lémo.” nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","⸤Ye nokoli kingi⸥ Erotene No Lindeli Jono topa kondorumu pilipale nirimumuni, Yesusi yu molorumu koleamo mundupa kelepa ‘Senga nanu molambo.’ nimba nona andoli sipi senga sukundu pumba nomu ⸤Gallilli⸥ nekendo pumba kolea ku lieli senga yuyu pumbá purumu. Aku-na-kolo yombo awisili yu aku serimumu pilkuli ononga koleama munduku kelko kimbu anjiku nomu kelona makaye seko pungu yu purumuna akileko lombili puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesusi no-kelona ombale yombo paa awisili akuna maku toko moloringi kanopale ono kondo kolopa ononga kuru torumuma ‘Peanga liepili.’ nimba ono sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pe ipupini ena pumbá serimu kinia yu lombili andolima yu molorumuna ongo yundu ninguli: “I koleana yombo se naa pelemele, ena kamu pukumu kene ya maku toko molemele yomboma ‘Pungu kolea marenga kere-langi topo toko li-pangi.’ ni.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aku-na-kolo yuni yu lombili andolimando pundu topa nimbale: “Nambi semu-na ‘yombo akuma ‘We pangi.’ niembo.’ ningu nikimiliye? Onone onono yomboma kere-langi mare liku siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Onone yundu ninguli: “Ya kere-langi awisili naa taltolemele. Pellawa kaloli kanga se-pakara kinia oma kaloli talo kinia aku kere-langi pokore mindi lemó.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yuni “Na moliona yando mengo waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kanu-kinia yombomando “Erana mania molaa.” nimbale yuni kanu pellawa kaloli se-pakara kinia oma talo kinia lipale mulu-koleana olando sipa kanopa ⸤Pulu Yemo kinia⸥ “Ange.” nimba pellawa kalolima ambolopa pike lepa ⸤oma kinia⸥ lombili andolima moke sepa sipale “Anju yomboma siee.” nirimu, onone yomboma moke seko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ono pali kanu kere-langima noringi kinia olo serimu. Pe lombili andolimane kere-langi kakena lierimuma liku maku toko wale-basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kere-langi noringi yema manjipa paip tausini mele. Ambo bolango ⸤mare pea kere-langi noringi⸥ akuma olandopa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","⸤Yomboma kere-langi sirimu noringi⸥ kinia Yesusini yu lombili andoli yemando sumbi sipa nimbale: “Maku toko molemele yomboma nane “Pangi.” niembo. Ono nona andoli sipina ola pungu no nekendo kumbi leko paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yombomando “Paa.” nimbale yu yuyu Pulu Yemo kinia ungu nimbando ma-pangina ola purumu. Kanu-kinia ena pumba kolea kala torumu kinia akuna yuyu molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sipimu no nekendo pumbándo nomu awi-suku-singina kokele pumbá purumu kinia sipi kumbikundu mendo sipa poporomene topa, nomu torumula kinia nomo ola pumba mania omba serimu, sipimu topa ola-munda mania-munda sepa topele-mapele torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kanu-kinia ipulieli kolea muni naa liepili ⸤yu lombili andolima sipina ola molko⸥ puringina Yesusi nona ola kimbu anjipa ombá orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Onone yu nona ola kimbu anjipa orumu kanokole niringimuni, pipili awili seko kolkole “Kuru se okomaa!” ningu mini-wale mundoringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesusini popenge sepa onondo nimbale: “Ono konopu tondolo pupili molayo. Na mindi okoro. Pipili naa kolaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","⸤Yuni aku nirimu pilieringi kinia⸥ Pitane pundu topa nimbale: “Ye-Awilimu, akumu sika nu nunu onu liemu nu okonona na nona ola gilipu wambo mangiliei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yuni “Ou.” nirimu kinia Pita sipina ultu pumba pukua topa nona mania pumbale nona ola kimbu kulupa Yesusi molorumuna pumbá purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aku-sipa na-kolo poporome tondolo torumu kinia kanopale pipili kolopa yu nona wangomba sepale, “Ye-Awilimu, na liku tapondou!” nimba ru nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kanu-kinia Yesusini ki siniu sipa mundupa Pita kundupa ola lipa yundu nimbale: “Nane molio mele kepe uluma manda sembó mele kepe “Sika.” ningu kanga-kolte mindi kuru mondoleno yemo. U ‘Yuni na lipa tapondomba, sika nona ola manda pumbú.’ konopu lekole kelko konopu topele nambi semu-na toko ‘Na no wangombonje?’ ningu pilienuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sipina suku puringili kinia poporome topa kelierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aku serimu-na kanokole sipina suku moloringi yemane Yesusinga imbi ambolko paka tondoko kape ningu “Nu paa sika Pulu Yemonga Malo lepomo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kanu-kinia ⸤Yesusi kinia yu lombili andolima kinia Gallilli⸥ nomu nekendo punguli nomu kelona kolea Geneserete lierimuna wendo oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","⸤Kanu koleana sipina mania oringi kinia⸥ akuna moloringi yemane Yesusi kanoko imbi sikuli akundu lierimu koleamanga moloringi yomboma pali ningu mundoringi kinia yombomane kuru torumu yomboma pali yu omba molorumuna mengo ongole niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“‘Nunga wale-pakoli pundumu kepe ambolangi.’ ni.” ningu mawa seringi. Kanu-kinia kuru torumu yombomane yunga wale-pakolimu amboloringi yomboma pali kamu peanga lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kanu-kinia Parisi ye mare kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye mare kinia ono Jerusalleme munduku kelko Yesusi molorumuna ongo yu mangilku pilku ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Olionga anda-kolepalimane “Saa.” niringi ungu-manemo nu lombili andolimane nambi semu-na pulua tolemeleye? ⸤Anda-kolepalimane “Saa.” niringi mele mimi sipu pilipuli olione kima kulumiye tolemolo mele⸥ ononga kima aku siku kulumiye naa toko kere-langi we nolemele kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesusini pundu topa nimbale: “Onone kepe ononga anda-kolepalimane “Saa.” niringi mele mindi pilku liku sengendo Pulu Yemonga ungu-manema nambi semu-na pulua tolemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akumunga Pulu Yemone nimbale: “Aminieli lanielinga unguma pilku liku, liku awi siku saa.” nimba “Yombo sene yunga anumundu molo lapando ungu se nimba kinjipa iri tomu liemu kanu yombomo toko kondangi.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aku-sipa na-kolo ono yemane ninguli: “Yombo sene yunga anumu lapatolondo nimbale: “Nane olo méle mare lipu tapondopo silkama koronga ‘Pulu Yemo simbú.’ nimbu panjerindu kanumunga olo manda naa lipu tapondopo simbú.” nimbá kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","⸤aku sipa nimbámonga⸥ yunga lapa imbi ambolopa paka tondomba ungu se naa pemba.” nilimili. Aku siku nilimili ungumuni ‘Anda-kolepalimane mane siringi unguma olandopa.’ ningu ‘Pulu Yemone nirimu ungumu uluri mólo. Mania pupili.’ nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Ono ⸤ungu-manema pilku mane silimili yema kinia Parisi yema kinia⸥ ono topele-mapele toli yema molemele! Pulu Yemone ungu-umbu tondorumuma pilku yomboma nimba sirimu ye Aisayane onondo nirimu mele papu nirimu. ⸤Onone kiniá selemele mele yuni u nimba Pulu Yemonga bokuna torumu molemo mele i-sipa:⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","⸤Pulu Yemone nimbale:⸥ “Kanu yomboma ononga keremane na kape ningu ‘Ye awili olandopamo. Nu lipu awi silimulu.’ ningu na imbi ambolko paka tondolemele-na-kolo ononga konopuma kinia nanga konopumu kinia seluna naa pulimú. Lupa lupa pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Onone ‘Nanga imbi ambolopo paka tondamili.’ ningu na we popo toko kape nilimili. Mana-yombomane mane silimili unguma mindi mane sikuli ‘I ungu-manema Pulu Yemone “Saa.” nilimú ungu-manema.’ ningu pilku liku selemele, akumunga na sika popo tonge kinia unguri naa sembá.” nirimu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aku nimbale Yesusini maku toko moloringi yombomando “Na moliona waa.” nimba onondo nimbale: “Nane ⸤aku nikirumunga ungu se⸥ nimbú sekero ungumu komu sendeko ungumunga pulumu pilku kondayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yombomanga kangina ultukundu lepale kerena pumba olona sukundu pulimú mélsene ⸤Pulu Yemo manda popo tonge aulkamo pipi silimú⸥ kalaro se manda naa mondolemo. Yombomanga konopumanga sukundu pepale wendo olemo ulumane mindi yomboma kalaro mondolemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aku nirimu pilkuli niringimuni, yu lombili andolima yu molorumuna ongo ninguli: “Nu aku siku nikinu mele pilkuli Parisi yemane paa pilku kiri piliengi mele nu pilkinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aku-na-kolo Yesusini pundu topa ⸤ungu-iku topa Parisima moloringi mele nimba⸥ nimbale: “Nanga mulu-koleana molemo Lapamone umbu naa panjerimuma pali pulu akumba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I yemane nilimili mele konopu kimbu siku naa pilku molangi. Ono mongo kiri lielimane ⸤mongo kiri lielima⸥ aulka liku ora silimili yema molemele. Mongo kiri lieli ye sene mongo kiri lieli ye se aulka se lipa ora sipa ki ambolopa memba pumbá kinia olo peatolo kombuna topa mania mundumba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","⸤Kalaro molemomonga ungu-ikumu aku sipa torumu kinia pilipale⸥ Pitane yundu nimbale: “Aku ungu-ikumunga pulumu nambolkanje? Ningu para si.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesusini onondo nimbale: “Kiniá kepe naa pilkimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yombo senga kangina ultu lepale kerena pulimú mélse olona sukundu pumba ultu omba le-muruna kamu pulimú mele naa pilkimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","19","Kerena sukundu pulimú mélemane unguri naa selemo kanumu. Ulu-kirima u konopumuni pilkuli pe kamu wendo olemomonga konopuna pepale kerena wendo olemo kanu mélemane mindi ⸤Pulu Yemo popo tomba aulkamo pipi silimú⸥ kalaro se mondolemo. Kanu mélema i-sipa: Konopumuni ulu-kirima pilielemele, yomboma toko kondolemele, ambo ye pulima molo ye ambo lilima yombo lupama kinia ulu-kirinale selemele, wa ulu-kirinale lupa-lupama andoko selemele, wa nolemele, kolo toko yomboma kote sendelemele, ‘Yomboma pipili kolko molko kinjangi!’ ningu ungu-bulkundu nindilimili, ulu-pulu akuma pilku selemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aku selemele ungu akumane yomboma ⸤Pulu Yemonga kumbikerena pungí aulkamo pipi silimú⸥ kalaro se mondolemo. Aku-sipa na-kolo ki u naa kulumiye toko kere-langi we sumbi siku nolemele ulu-pulumuni ⸤yombo senga konopuna sukundu⸥ kalaro se naa mondolemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kanu-kinia Yesusi molorumu kolea ⸤Geneserete⸥ mundupa kelepa ⸤Juda yomboma moloringi kolea Gallilli disiriki ultukundu⸥ kolea-awili Taya kinia Saidonotolo lierimu koleana sukundu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Akuna purumu kinia kolea Kenane ambo se molorumu, yu wendo omba tondolo ru nimba nimbale: “Ye-Awilimu, Ye Nokoli Kingi Depitini Kalopa Liltimu Yemo, nanga bolamo kuru se konopuna sukundu molopa yu tondolo ambololemo kene nuni na kondo kolou!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aku-na-kolo Yesusini yundu ungu se pundu topa naa nirimu. Kanu-kinia yu lombili andolimane ongo yundu ninguli: “Ambomone nu mangilipa olio lombili okomomo ⸤siye sekemo⸥ kene ‘Anju pupili.’ ni.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","⸤Ambomo yu ambo-lupa, Juda ambo se mólo, nimba kanopale⸥ Yesusini ⸤yundu⸥ nimbale: “Pulu Yemone na Isirele yombo talapemonga kongi sipisipi talopa lemele mele molemele yomboma molemelena mindi lipa mundorumu kanumu. Yombo talape lupama molemelena lipa naa mundorumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aku sipa nirimu kinia pilipale ambomo omba yunga kumbikerena komorongo langopa ma kanopa nimbale: “Ye-Awilimu, na liku tapondou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aku nirimu kinia Yesusini pundu topa ⸤ungu-iku se topa⸥ nimbale: “Bolangomanga kere-langima lipu owáma simulú kinia manda naa sembá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ambomone nimbale: “Ye-Awilimu, sika nikinu-na-kolo owámane kepe ononga pulu yombomanga kere-langi pundu mania pulimúma liku nolemele kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanu-kinia Yesusini yundu nimbale: “Ambomo, nu manda sembó mele paa awili seko kuru mondoleno kene mawa sekeno mele aku sipa wendo opili.” nirimu kinia yuni aku sipa nirimu mele aku enamonga ambomonga lemenu peanga lepa manda molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kanu-kinia Yesusi kanu koleamo mundupa kelepa Gallilli nomu kelona ⸤aulka se lierimuna⸥ omba pumba ma-pangi senga ola pumba mania molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kanu-kinia yu molorumuna yombo paa awisili oringi. Kimbu kiri lierimu-na aulka mimi siku naa andoringi yomboma kinia, mongo kiri lierimu yomboma kinia, kimbu ki karaye serimu yomboma kinia, ungu manda naa niringi yomboma kinia, aku sipa kuru lupa-lupa torumu yombo awisili mengo ongo yu molorumuna nondoko taltoringi kinia yuni ono sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ungu naa niringi yomboma ungu niringi; kimbu ki karaye serimu yombomanga kimbu kima kelepa sumbi sipa gilierimu; kimbu kiri lierimu-na aulka mimi siku naa andoringi yomboma manda andoringi; mongo kiri lierimu yomboma mongone mélema kanoringi; aku sipa ulu-tondoloma wendo orumu kinia kanokole we maku toko moloringi yombomane paa konopu awisili kimbu siku, Pulu Yemo ono Isirele yomboma nokorumu popo toringi Pulu Yemo kape ningu imbi ambolko paka tondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kanu-kinia Yesusini yu lombili andolimando “Na moliona waa.” nimba onondo nimbale: “I yombo maku toko molemelema na kondo sekemo. Wale yopoko na-kinia molongi, pe kiniá ga nonge se naa lemó. Ono kere-langi naa nongo we pungí kinia aulkana kimbu ki pange-mange sepa, topa ne-munda ya-munda sembá kene ‘Ono gele sepa pepili ulkando paa.’ naa nimbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aku nirimu kinia pilkuli yu lombili andolimane ninguli: “⸤Sika nikinu-na-kolo⸥ i kolea ku lielina molemolo. I yombo paa awisili manda nonge mele pellawa kaloli sena lembana lipu simulúye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesusini onondo “Pellawa kaloli nambi seko taltokomeleye?” nimba mangilierimu kinia onone “Pellawa kaloli yopoko-pakara kinia oma koltalo kinia taltokomolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kanu-kinia yuni maku toko moloringi yombomando “Mania molaa.” nimbale, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","pellawa kaloli yopoko-pakara kinia omama kinia lipa Pulu Yemo kinia “Ange.” nimba, kere-langi akuma pike lepa yu lombili andolima sirimu kinia onone yomboma moke seko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yomboma pali nongo kiri pilieringi. Pe kere-langi kakena lierimuma lombili andolimane liku wale-basiketemanga lakilieringi, wale awili yopoko-pakara peke lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ye po tausinini aku kere-langima noringi. Ambo bolangoma kinia pea kere-langi noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kanu-kinia Yesusini maku toko moloringi yombomando “Ulkando paa.” nimbale nirimumuni, nona andoli sipi senga sukundu pumba, ⸤nomuna nekendo⸥ kolea Makatane purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","⸤Kolea Makatane purumu⸥ kinia Yesusi molorumuna Parisi yema kinia Sadusi yema kinia ono ongo, ‘Yuni nambi sembanje? Kanamili.’ ningu yu manda manjiku mawa seko ninguli: “Ungu Mane Sili Yemo, ‘Nu sika Pulu Yemone ‘Kongono sendani.’ nimba ya mana lipa mundorumunje kanamili.’ ningu mulu-koleana molemo Pulu Yemone mindi manda ulu-tondolo selemo mele se sei.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesusini pundu topa nimbale: “Ipupini ena pumbándo mulúmu kondoli selemo kinia kanokole ‘wale peangamo wendo ombá lémo.’ nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Orili-u kolea tangombando kolea kupa topa mulúmu simbulu tolemo kinia kanokole ‘Lo ombá lémo.’ ningu pilielemele kanumu. Mulúmu kanokole ‘koleamo i-sipa i-sipa sembá.’ ningu kanolemele-na-kolo i walemanga uluma wendo olemoma kanokole ungumanga pulumu manda naa pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kiniá mana molemele yomboma yombo kirima mindi molemele. Ono seko kinjiku, Pulu Yemo siye kolko, méle lupama konopu mondolemele kanu yombomane “Pulu Yemone mindi ulu-tondoloma manda selemo mele kanamili sei.” ningu na mawa selemele. Aku-na-kolo ⸤Pulu Yemone na lipa mundorumu-na ya ombo molkoro. Yu-kinia kopu sepo kongono selembolo mele⸥ lipa ora simba ulu-tondolo se wendo naa ombá. ⸤Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye⸥ Jonane serimu ulumuni mindi lipa ora silimú mele manda kanonge. Se pea wendo naa ombá.” nimbale ono mundupa kelepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ono ⸤Gallilli nomu⸥ nekendo pungíndu ⸤Yesusi⸥ lombili andoli yema pellawa kaloli komu sindiku naa mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","⸤Kanu-kinia⸥ Yesusini onondo ⸤liepi-liepi topa ungu-iku topa⸥ nimbale: “Paa mimi siku kanaa! Parisi yema kinia Sadusi yema kinia onone pellawa akoli méle isi taltolemelemo kanoko kondaa!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aku sipa nirimu kinia pilkuli yu lombili andoli yemane onono angelema ningu ninguli: “Olio pellawa kaloli ⸤nomolo⸥ mare naa lipu membo omulumunga aku sipa nikimunje.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aku siku niringi mele pilipa Yesusini onondo nimbale: “Ono ‘nane manda lipa tapondomba.’ ningu kanga-kolte mindi kuru mondolemele yema, “Pellawa kaloli naa memulu.” ningu nambi semu-na angelema nikimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ono kiniá kepe naa pilku kondolemeleye? Pellawa kaloli se-pakara ye paip tausini moke seko siringi mele komu sindilimiliye? ⸤Nongo pora siringi kinia⸥ kere-langi kakena lierimuma liku wale-basikete awisili toko peke siringi mele komu sindiku naa pilkimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Molo pellawa kaloli yopoko-pakara moke seko ye po tausini siringi mele naa pilku, ⸤nongo pora siringi kinia⸥ wale-basikete awili mare kere-langi kakena lierimuma toko peke siringi mele naa pilku molemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‘Yuni sika pellawa kalolimundu naa nikimu.’ ningu nambi semu-na naa piliengiye? ‘Parisi yema kinia Sadusi yema kinia pellawa akoli méle isi taltolemelemo mimi siku kanangi.’ nimbu nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yuni aku nirimu kinia pilkuli onone ‘pellawa kalongendo isi mundulimili akumundu naa nikimu. Parisi yema kinia Sadusi yema kinia onone ungu-mane siringi ungumando nikimu.’ ningu pilieringi. ⸤ ‘Parisi yema kinia Sadusi yema kinia onone ungu-mane mare kolo toko siringima yunga lombili andolimane paa naa piliangi.’ nimba nirimu mele ningu pilieringi.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesusi kolea-awili Sisaria-Pillipai lierimu koleana pumbale nirimumuni, yu lombili andolimando mangilipa nimbale: “Mania Omba Mana-Ye Au Lierimu Yemondo yombomane yu imbi leko nawe nilimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Onone yundu ninguli: “Marene “Nu No Lindeli Jono ⸤kolorumu, kiniá kelepa lomboropa ola molemo⸥.” ningu pilku, marene “Nu ⸤Pulu Yemone u konde molopili olando liltimu ye⸥ Illainja kelepa omba molemo.” ningu pilku, marene nu “Jeremaya molo Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye ⸤u kolorumu kiniá lomboropa ola molemo⸥ se lupa.” nilimili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aku niringi pilipa Yesusini onondo nimbale: “⸤We-yombomane aku siku nilimili⸥-na-kolo ono onono na nawe nilimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimono Pitane pundu topa nimbale: “Nu Konde Molopa Mindi Puli Pulu Yemonga Malo, ⸤Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ nimba u nimba taltorumu ye nokoli⸥ Karasimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yuni aku nirimu pilipale Yesusini yundu nimbale: “Jona Malo Saimono, nu Pulu Yemone “Konopu peanga pepili molko kondangi.” nilimú aulkana moleno. I nikinumu mana-yombo sene nu naa nimba simu. Tata mulu-koleana molemomone nimba simu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ungu se pea nundu nikirula: Nunga imbi Pita, ⸤kanu imbimunga ungu-pulumu ‘kou-mulu’ kanumu⸥. Kanu kou-mulumunga ola nanga yombo talapemo lipu maku topo mondombo. Kanu-kinia kololi ulu-pulumunga tondolomone i nanga talapemo topa mania manda naa mundumba, mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pulu Yemo ye nokoli kingi molopa yomboma nokomba ulka-kimu nu simbú. Kanu-kinia nuni mana mélsendo “Mólo.” nini mélemo mulu-koleana sukundu “Mólo.” nimbála. Nu mana mélsendo “Manda.” nini mélemo mulu-koleana sukundu “Manda.” nimbála.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kanu-kinia yu lombili andolimane Yesusindu “Pulu Yemone “Ono nokopa kondomba yere lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu nu ongo moleno.” niringi kanu ungumundu yuni onondo tondolo mundupa nimbale: “Onone anju yombo selurindu kepe na kanu yemo molio mele ⸤iseli-u⸥ paa naa ningu siee!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kanu-kinia Yesusi yu lombili andolimane yundu ⸤ “Pulu Yemone olio “Nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu nu.” ningu, ningu para siringi kinia pilipale⸥ yuni yu-kinia wendo ombá mele pulu polopa ono sumbi sipa nimba sipa nimbale: “‘Na mindili awisili nombondo kolea-awili Jerusalleme paa pumbú.’ nimbu pilipu molio. Juda yomboma nokolemele tapu-yema kinia, Pulu Yemo popo tondoli ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane silimili yema kinia, onone na paa toko mindili kondonge. Na toko kondonge kolombo kinia wale talo omba pumbá kinia yopoko-sipamonga Pulu Yemone nando ‘Lomboroko ola molou.’ nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","⸤Aku nirimu kinia pilipale⸥ Pitane yu anju lipa memba pumbale yu pulu polopa iri topa nimbale: “Ye-Awilimu, aku siku paa naa ni! Nu nikinu mele aku sipa paa wendo naa ombá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aku-sipa na-kolo ⸤yuni kurumanga nokoli Setenene ungu-umbu tondorumu mele pilipale nirimu-kulu pilipale⸥ Yesusini topele topa Pitando nimbale: “Setene, nu anju pa! Pulu Yemone nando “Sei.” nirimu kongono sembó sekeromo pipi sini sekeno kene nu anju pa! Nuni na seko sembambu sini sekeno. Nu Pulu Yemone konopu lemó mele naa leno. Yombomane konopu lemele mele mindi leno.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kanu-kinia Yesusini yu lombili andolimando nimbale: “Yombo sene ‘Yu lombili pambo.’ nimbale yuni yunga konopumuni pilielemo mélemanga ‘Topo mania mundambo.’ nimba yomboma unju-perana peko mindili nongo kololemele mele yuni unju-pera mele gomo lembando ‘Na yu lombili pumbúndu mindili nondu liemu peangala; kolondu liemu peangala.’ nimbale na lombili opili. We naa opili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yombo sene yunga mana konde molopa naa kololi ulu-pulumu ambolomba sembá kinia yu kolopale sika molopa kinjipa mindi pumbá. Aku-na-kolo yombo sene na konopu mondopale nanga kongonomo “Sendambo.” nimba sembá kinia yu kolopale yu konde molopa kondopa mindi puli ulu-pulumu sika kanopa limba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","⸤Akumu nambi semu-na nikiruye?⸥ Yombo sene mana-mélema pali yu yuyu lipa taltopale yu mini pali Pulu Yemo naa molomba koleana pumba mindili nomba molopa kinjilkanje kanu mélemane kanu yombomo nambi sepa lipa tapondolkanje? Lipa naa tapondolkamo. Molo yombo sene ‘Na mini pali konde molopo kondopo mindi pambo.’ nimbale yu nambolka mélsene mini pali konde molopa kondopa mindi puli ulu-pulumu topo topa lilkaye? Mélsene manda topo topa naa limba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Mania Omba Mana-Ye Au Lierimu Yemo pe Lapanga tondolo pa sélimu kinia yunga ⸤mulu-koleana⸥ angelloma kinia pea ombá. Ombale yuni olio ya mana-yomboma yu-mele-mele selemolo ungumanga olio yu-mele-mele pundu tombamonga nane aku nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nane onondo paa sika nimbu sikirumu: “Ono ya gilkimilimanga mare u kolou naa kolangi Mania Omba Mana-Ye Au Lierimu Yemo ye nokoli kingimu omba molopa mélema kinia yomboma kinia pali nokomba ombá kanonge.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesusini ⸤yu lombili andolimando aku sipa nimba sirimu kinia⸥ pe koro se omba purumu kinia Pita keme Jemisi keme Jemisi genu Jono keme ono lipa memba pumba mulú paa olandopa polorumu senga ola purumu. ‘Olio oliolio mindi molamili.’ nimba ono akuna lipa memba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Akuna puringi kinia ono kanoko molangi yunga kangimu topele topa, yunga kumbikeremo ena tondolo topa yombomanga mongo takele selemo mele pa awili-sepa sepa, yu pakorumu mulu-maminiama pa selemo mele aku sipa kake serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yu aku sipa molopili, ⸤Juda yombomanga koronga-u moloringili ye awili talo,⸥ Mosisi kinia Illainjatolo ongo Yesusi kinia ungu ningu mona gilieringili kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kanu-kinia Pitane Yesusindu nimbale: “Ye-Awilimu, olio ya molopomolo peanga lepomo. Nuni “E.” ninu liemu, ulka-takaya yopoko takondombo. Se nunga, se Mosisinga, se Illainjanga takondombo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yuni aku sipa nimba molopili kupa tondolo pa seli se omba ono aki torumu kinia kupana sukundu ungu se wendo omba nimbale: “I yemo nanga konopu mondolio Malomo. Yu kanopo paa peanga pilielio. Yuni ungu nimbáma pilku liengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aku nirimu pilkuli yu lombili andoli ye ⸤yopoko⸥ paa mini-wale mundukuli mana-mania molko tamalu peringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ono tamalu peringina Yesusi omba ono ambolopa nimbale: “Mini-wale naa munduku ola giliaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe olando siku kanoringi kinia Yesusi yuyu molorumu kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mulú polorumumunga mania onge oringi kinia Yesusini ono mane sipa nimbale: “Onone kiniá kanongi mele iseli-u yombo seluri kepe ningu naa siengi. Pe mindi, Mania Omba Mana-Ye Au Lierimu Yemo kolopale lomboropa ola molomba kinia semanemo toko anju siengi. U mólo!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aku nirimu kinia pilkuli yu lombili andolimane ⸤yu sika molorumu mele ningu kanokole⸥ yundu mangilku pilku ninguli: “⸤Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ nimba taltorumu ye nokoli Karasimu nu liemu⸥ Pulu Yemonga ungu-manemanga puluma pilku mane silimili yemane “Illainja ⸤kelepa⸥ kumbi lepa ombá. ⸤Ye nokoli Karasimu pe akilepa ombá.⸥” nilimili mele nambi semu-na nilimiliye? ⸤Illainja kelepa naa opili nu koronga orunu moleno kanumu.⸥” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesusini pundu topa nimbale: “ “Illainja ⸤kelepa⸥ kumbi lepa ombale mélema pali sepa sumbi simbá.” nilimili kanumu sika nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aku-sipa na-kolo ⸤akumunga ungu se pea nimbu sikirula.⸥ Piliame. Illainja koronga orumu. Yu orumu kinia ⸤kanu yemane⸥ yu kanoko imbi naa siku ‘Yu we-yere.’ konopu lekole ‘Yu-kinia semolo.’ ningu pilieringi uluma pali seringi. Aku siku mele Mania Omba Mana-Ye Au Lierimu Yemo mindili liku singíla.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aku sipa nirimu kinia pilkuli lombili andolimane ‘No Lindeli Jonondo nikimu.’ ningu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","⸤Yesusi kinia yu lombili andoli ye yopoko kinia⸥ ono ⸤mulúna mania⸥ ongole yomboma maku toko moloringina oringi kinia ye se Yesusi orumuna omba komorongo langopa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mawa sepa nimbale: “Ye-Awilimu, nanga kangomo kondo koloyo. Yu ámu tolemo-na mindili awili sepa nolemo. Alieli-alieli yu sepena pumba nomanga pulimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nu lombili andoli yema molongina kangomo membo ondu kinia onone yu manda seko peanga naa síngi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aku nirimu kinia pilipale Yesusini ⸤yomboma iri topa⸥ nimbale: “Kiniá molemele yomboma ono ⸤ ‘Pulu Yemone uluma sika manda sembá.’ ningu⸥ kuru naa mondolemele. Ono konopu karaye sepa pepili molemele yomboma, na ono wale nambi sepo mane sipu ulu mare lipu ora simbú kinia mimi siku pilingíye? ⸤Na ono-kinia siye sekemo.⸥” nimbale “Na moliona kangomo mengo waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mengo oringi kinia Yesusini kanu kurumu iri torumu kinia yu kangomonga ⸤konopuna⸥ omba wendo purumu kinia kanu enamonga kangomo manda molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aku serimu kinia kanokole Yesusi lombili andoli yema Yesusi yuyu molorumuna ongo mangilku pilku ninguli: “Kuru akumu olione nambi semu-na manda naa makoromuluye?” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesusini pundu topa nimbale: “⸤ ‘Pulu Yemone sika olio lipa tapondomba.’ ningu⸥ paa kanga-kolte mindi kuru mondolemelemonga ulu-tondolo i-silima manda naa selemele. Nane ono paa sika nimbu sikirumu: “Unju senga mongo akumu méle paa kanga-na-kolo kanu mongomo mana mundulimili kinia unju akopa gilimú mele, aku sipa onone ‘Pulu Yemone olionga unguma pilimba. Olio lipa tapondomba.’ ningu kanga-kolte mindi kuru mondokole i pololemo mulúmundu “Anju pungu ne koleana giliei.” ningí kinia sika aku sipa pumba gilimba. ‘Samili.’ ningí ungumanga ulu manda naa senge ulu se naa pemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","⸤Pulu Yemo mawa seko kere-langi mi leko naa nongole kuru i-silima yombomanga konopumanga manda makoronge. Ulu-tondolo i-silima we manda naa senge.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","⸤Pe walte,⸥ kolea Gallilli disiriki pungu moloringi kinia Yesusini yu lombili andolimando nimbale: “Mania Omba Mana-Ye Au Lierimu Yemo ⸤ka sikuli yu toko kondonge⸥ yema anju singí kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","onone yu toko kondonge. Kolopale wale yopoko-sipamonga Pulu Yemone yundu ‘Lomboroko ola molou.’ nimbá.” nirimu. Aku nirimu pilkuli ononga konopuna sukundu meme kuluepe perimu-kulu pilkuli paa kondo koloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pe Yesusi kinia yu lombili andolima kinia Kapeniame taonona oringi kinia Pulu Yemo popo toringi ulka-tembelemonga kou-takisi liltingi yema ongo Pita mangilku ninguli: “‘Nunga ungu mane sili yemone ulka-tembelemonga kou-takisi tolemo.’ konopu lekemolomo. Sikaye?” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitane “Tolemo.” nirimu. Kanu-kinia Pita ulkana sukundu pumbale ungu se nimbá serimu kinia Yesusini yu u mangilipa nimbale: “Saimono, nu nambolka konopu lekenoye? Ye nokoli kingimane kou-takisi lupa lupama lingíndu namele “Taa.” nilimiliye? Ononga yomboma kinia kou-takisi limili molo yombo lupama “Taa.” nilimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitane pundu topa nimbale: “Yombo lupamando “Takisi taa.” nilimili.” nirimu. Aku nirimu kinia pilipale Yesusini yundu nimbale: “Aku liemu kingimunga yombomane takisi naa tonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aku-sipa na-kolo takisi naa tombolo kinia ulka-tembele-takisi limili yemane olto kanoko kiri pilingí manda naa sembá kene nomuna pungu uku mundu-pani. Uku mundukuli oma se toni aku omamonga keremo angara sendeni kinia kou se pemba, aku koumu likuli mengo pungu oltonga pea liku sere leko takisi tou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aku walemonga Yesusi lombili andolimane yu molorumuna ongo yu mangilku pilku ninguli: “Pulu Yemo ye nokoli kingimu molopa nokolemo yombomanga nawe paa olandopa molemoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Onone mangilieringi mele Yesusini pilipale yu bolango kanga se “Na moliona ou.” nimba ono moloringina mondopa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","onondo nimbale: “Nane ono paa sika nimbu sikirumu: “Ono konopu topele toko bolango kangama mele naa molongi liemu Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo koleana sukundu paa manda naa pungí.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akumunga, yombo sene ‘Na we-yombomo molambo. Nanga imbi se olandopa naa molopili.’ nimba i bolango kangamo mele molemo yombomo yu Pulu Yemo ye nokoli kingimu molopa nokolemo koleana yombo imbi paa mololimu molemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“⸤I bolangomondo ungu se pea niembo:⸥ Yombo sene ‘Na Ye-Awilimunga yombomo molio.’ nimba i bolangomo mele lipa tapondomba kinia kanu yombomone aku sembamonga na lipa tapondombala. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Aku-na-kolo yombo sene i ⸤bolango⸥ kangamonga ⸤mele yombo⸥ se ⸤na ‘Sika’ nimba⸥ kuru mondolemo ⸤bolango⸥ kanga se ‘Ulu-kirima sepili.’ nimba kondi tombamonga kanu ⸤bolango⸥ kangamo kuru mondolemo mele mundupa kelepa bulu simu liemu ⸤bolango⸥ kangamo u kondi naa topili kanu yombomo kou paa awili se moko toko nomina lendeko ‘Yu kamu kolo-popili.’ ningu paka toko nomuna paa maniakondo mundulimolánje paa papu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“⸤Na⸥ ‘Sika’ ningu kuru mondolemele yomboma kelko bulu siku munduku kelenge unguma ya mana lemómonga na ono kondo sekemo. Sika aku sipa uluma wendo ombá-na-kolo yombo sene nanga yombo se kondi tombamonga kanu yombomo na bulu sipa anju pumu liemu kanu kondi tomba yombomo mindili nomba paa molopa kinjimba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nunga kitolone molo kimbutolone ulu-pulu-kiri se semu liemu aku kitolo molo kimbutolo kari leko eltani. Nu konde mololko mindi puni koleana kitolo molo kimbutolo naa giliepili puni kinia peanga. Nunga kimbu ki pali we giliepili sepe naa kumbulupa nomba pepa mindi pumbá koleana liku toko mundungí kinia kiri. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Molo nunga mongotolone mélse kanokole konopumuni ‘liemboa.’ ningu pilku ulu-pulu-kiri se senu liemu aku mongotolo akuku eltani. Nu konde mololko mindi puni koleana mongotolo naa giliepili puni kinia peanga. Mongo talo we giliepili nu sepe-koleana sukundu liku toko mundungí kinia kiri.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“I ⸤bolango⸥ kangama ⸤mele yomboma⸥nga se kanoko kiri pilku ‘Yu koropamo.’ ningu paa naa sangi. Ononga nokolemele mulu-koleana angelloma alieli Tata mulu-koleana molemona pea molemele kene ⸤aku naa saa⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","⸤Mania Omba Mana-Ye Au Lierimu Yemone ‘Yombo aulka lo liku molko kinjilimili yomboma koropo lipu tapondambo.’ nimba orumu kanumu.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ono nambolka ningu pilkimiliye? ‘Ye sene kongi sipisipi paip paono mondolka kinia, se talopa lelkanje, yuni sipisipi po paono tene kelepa nani wema ma-pangina molangi mundupa kelepa pumba, talopa lelka sipisipimu kanopa limbando korolepa naa pulka.’ konopu lekemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nane onondo paa sika nimbu sikirumu: “Sipisipi talopa lelka kanumu kanopa lipale kanu sipisipimu-kinia paa olandopa konopu silka. Talopa naa lemoláma we konopu silka.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aku sipala ononga Lapa mulu-koleana molemomone i bolango kangama ⸤mele molemele yomboma⸥ ‘aulka lo liku molko kinjingí kinia paa kiri.’ nimba molemóla.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“⸤Na lombili andolimanga⸥ genu sene nu sepa kinjemu liemu nu pungu sepa kinjimba yombomo pea ololo molangili kanu ulu-pulu-kirimu yuni nu sembá mele ningu sieni. Nuni nini ungumu sepa kinjimba gena piliemu liemu gena kinia olo kelko manda selu-siku molongele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aku-sipa na-kolo nuni nini ungumu yu naa piliemu liemu pe nuni ‘I ungumu pora nipili kene sembó mele yombo mare kanoko molangi kelepo niembo.’ ninguli, kanonge yombo talo molo yopoko liku gena molombana mengo ongo ono kanoko molangi genando ‘Seluna molambili.’ kelko nieni. Kanu-kinia nuni sení kinia genane sembá mele kanu yombomane kanokole yombo lupamando manda semane toko singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kanu-kinia yuni ononga ungumu kepe naa piliemu liemu Karasinga yombo talapemondo pungu ningu sieni. Pe Karasinga yombo talapemo kepe genane naa piliemu liemu ‘Yu olionga genu mólo. Yu ultukundu molko konopu topele naa toli yomboma mele molemo lémo.’ ningu kanayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nane onondo paa sika nimbu sikirumu: “Ya mana onone ⸤uluma kinia yomboma kinia⸥ “Mólo.” ningí kinia Pulu Yemone mulu-koleana sukundu “Mólo.” nimbála; onone mana “Manda.” ningíma Pulu Yemone mulu-koleana sukundu “Manda.” nimbála.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“⸤Akumunga⸥ nane onondo ungu se pea nimbu sikirumu: “Ononga yombo talone ya mana “I sipu mawa sambili.” ningu panjengili liemu olone mawa sengele mele mulu-koleana molemo Tatane olonga mawa sengele mele aku sipa sendemba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yombo ⸤koltalo,⸥ talo molo yopoko, na ononga Ye-Awilimu imbi leko mangilku, ‘Pea kopu sepo molemolo.’ konopu leko maku toko molemelemanga na ono-kinia molemolo-na ⸤mawa senge mele Tata yuni aku sipa sendemba⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","⸤Yesusini yombo seko kinjilimilimando ungu-mane aku sipa sirimu⸥ kinia yu molorumuna Pita nondopa omba yu mangilipa pilipa nimbale: “Ye-Awilimu, nanga genu sene na wale nambi-sepa sepa kinjimba kinia na we ‘Mania pupili.’ nimbu siye kolomboye? Wale sepen yuni sembá mele siye kolopo we molopole engaki-sipamonga ‘Pundu topili.’ nimbú kinia peangaye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesusini pundu topa nimbale: “Nane “Wale sepen mindi yuni nu sepa kinjimba kinia yuni sembama siye kolko kelko pilku naa molou.” ni naa nikiru. “Wale sepen anderete sependi sepen yuni nu sepa kinjimba walema pali yu sepili, siye kolko we molou.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Akumunga Pulu Yemo ye nokoli kingimu molopa mélema nokolemo akumu i-sipa mele: “Walte ye nokoli kingi sene yunga kongono nokondoringi kendemande-yomboma kinia pundu gilierimuma ‘Kiniá mimi sipu kanopole “Pundu tangi.” niembo.’ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aku sipa nirimu kinia kingimuni kou tene milliono kina mele u pundu gilierimu ye se kumbi leko yu molorumuna mengo oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aku-na-kolo yu manda aku kou pundumu tomba aulka se paa naa lierimu-kulu ye-awilimuni nimbale: “Manda, i yemo kinia yunga ambo bolangoma kinia yunga mélema pali kinia makete seko kou-mone likuli koumu ongo pundu tondangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aku nirimu-kulu pilipale kendemande-yemo ye nokolimunga kumbikerena komorongo langopa tamalu pepa mawa sepa nimbale: “Nuni na kondo kolko we nokoko moloyo. Nane pundu pali tombo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","⸤Kanu-kinia⸥ ye nokolimuni yunga kendemande-yemo paa kondo kolopa yu kendemande-yemo kinia pundu gilierimuma pali “Yu sepili. Kelko pundu naa tani.” nimba kamu siye kolopa yemo ka naa sipa “We pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aku-na-kolo ⸤ka singí seringi⸥ kendemande-ye kanumu yu pena pumba kendemande-ye se yunga kou wane anderete kina mele sirimumu kanopale, yu pumba yunga nomina ambolopa ‘Yu kolopili.’ nimba ambolopa elkele lakurupale “Nanga kou sirindumu pundu tou!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aku serimu kinia yuni tomba serimu yemo yunga kumbi-kerena komorongo langopa tamalu pepa mawa sepa nimbale: “Nuni na kondo kolko we nokoko moloyo. Nane pundu pali tombo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aku-na-kolo kendemande-ye lupamone “Mólo, paa iseli pundu tani.” nimbale “Nu ka-ulkana pekole pundu toko pora siku wendo wani.” nimba yu ka sipa ka-ulkana panjerimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yuni aku serimu mele kendemande-ye wemane kanokole ono konopu kiri panjiku pungu ononga ye nokolimundu kendemande-yetolo seringili kanoringi mele kondi toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kanu-kinia ye nokolimuni aku niringi pilipale kendemande-ye yunga pundu “Naa toko we pu.” nirimu kendemande-ye kanumu “Yando ou.” nimba yundu nimbale: “Kendemande-ye kirimu, nuni na tondolo munduku mawa senu-na nu na-kinia pundu paa awili sepa gilierimumu “Yu sepili, naa tou.” nimbuli we siye kolondu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pe nane nu we kondo kolondu mele nuni aku siku kendemande-ye se nambi semu-na kondo naa kolonuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ye nokolimuni yu mumindili kolopale ka-ulka nokoko ka-ulkana peringi yomboma seko mindili kondoringi yema yu lipa sirimu. Yuni nimbale: “Nu mindili nongole pundu tani. U pundu pali toko pora sikuli pe mindi wendo wani. U mólo.” nirimu.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","⸤Yesusi yuni aku nimbale ungu-ikumunga pulumu kamu nimbale:⸥ “Aku sipala, genalini ono aku siku seko kinjingí kinia ono kerena mindi “Mania pupili. Siye kolkoro.” we ningu, sika munduku naa kelko, we konopuni pilku molongi liemu, ⸤kendemande-yemonga ye nokolimuni kendemande-yemo sepa kinjerimu mele⸥ mulu-koleana molemo Tatane siye naa kolko we konopuni pilku molonge yombo kanuma ononga ulu-pulu-kirima ‘Mania naa pupili.’ nimba, we siye naa kolopa kanu ulu-pulu-kirimanga “Mindili nangi.” nimba aku sembala.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesusini aku sipa unguma nimba pora sipale nirimumuni, kolea Gallilli disiriki mundupa kelepa kolea Judia disiriki pumba no Jodane kimbilipa nekendo purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kanu-kinia yombo awisili yu lombili oringi kinia yuni kuru torumu yomboma sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi ye mare yu molorumuna ongo ‘Yu nambolka nimbánje? Nimba kinjimbanje manda manjipu piliamili.’ ningu yu mangilku pilku ninguli: “Ye sene yu yuyu pilipale yunga ambomo “Kamu pu.” nimbá kinia manda sembá molo aku sembá kinia ungu-mane se pulua tombaye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yuni anju pundu topa nimbale: “Pulu Yemone ungu nirimu yunga bokuna molemo mele kanoko kambu naa tongiye? U-pulu-pulu, Pulu Yemone mélema sepale, yuni yombo sembando yemo kinia ambomo kinia sepa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nimbale: “Aku sipu sendumunga ye sene ambo se lipale yunga anumu lapatolo mundupa kelepa yunga ambomo kinia ololo seluna kopu seko peko kangi selumu mele ⸤molko olonga konopu seluna pupili⸥ molongele.” nirimu kanumu naa piliengiye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pulu Yemone aku sipa nirimu-kulu ye se ambo se limú kinia kangi selumu mele molembele-na olo kelko talo mele naa molembele, olo yombo selumu mele molembele. Yombo selumu molembele kene Pulu Yemone ambo ye talo ‘Selumu molangili.’ nilimú ambo yetolo yombo sene liku lupa lupa naa mundangi. Aku sengi liemu manda naa sembá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aku sipa nirimu kinia onone ninguli: “Aku liemu Mosisini ungu-mane se sirimu mele nambi semu-na sirimuye? Mosisini nimbale: “Ye sene yunga ambomondo ‘Kamu pupili.’ nimba makorombando ambomo “Kamu pu.” nimbá mele pepá se topa ambomo sipale yundu “Kamu pu.” nimba aku sepili.” nirimu kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesusini nimbale: “Mosisini sika aku sipa nirimu-na-kolo ono kála seko Pulu Yemone ambo yetolo konopu sere leko molongele mele ungu-mane sirimumu pilku mokoli seko naa pilieringi-kulu yuni “Aku sangi.” nirimu. Aku-na-kolo u-pulu-pulu, ⸤Pulu Yemone mélema kokele sepa wamorumu kinia,⸥ ungu-mane aku sipa se naa perimu kene ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","nane ono i-sipu nimbu sikiru: “Ye sene yunga u limú ambomo makoropa “Kamu pu.” nimbale kelepa ambo se limú kinia aku yemone wa ulu-kirinale selemo. Yemonga ambomone ye se kinia wa ulu-kirinale semu liemu manda topa makoromba. We mólo. ⸤ “Pu.” nimba makorolemo ambomo pe ye sene yu limú kinia kanu yemo kepe wa ulu-kirinale selemóla.⸥” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","⸤Yuni aku nirimu kinia pilkuli⸥ yu lombili andoli yemane yundu ninguli: “Ye sene ambo limú kinia nuni nikinu mele aku siku molongele mele ungu-mane se pelemo liemu ye se ambo naa lilkanje papu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aku-na-kolo Yesusini pundu topa nimbale: “I ungu⸤-mane sikiru⸥mu yombomane pali manda naa pilku lingí. ⸤Pulu Yemone⸥ nimba taltopa tondoloma simba yomboma mindi manda ⸤amboma ye naa pungu yema ambo naa liku⸥ senge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye mare anupilini melemele kinia amboma kinia seluna kopu seko peko ulu-kirima senge enge se naa pelemo. Ye mare ‘Amboma kinia seluna naa peangi.’ ningu ononga láka lindilimili. Marene onono ‘Ye nokoli kingi Pulu Yemonga yema molopo yunga kongonoma manjipu sendamili.’ ningu ono onono mi leko ambo naa limili. I ungumu yombo pilku lingí yomboma piliangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kanu-kinia yombomane ononga bolangoma ‘Yesusi yunga kimuni ambolopa Pulu Yemo kinia ononga mawa sendepili.’ ningu yu molorumuna mengo oringi. Aku-na-kolo yu lombili andolimane iri toko ⸤ “Naa mengo waa.” ⸥ niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","⸤ “Mólo.” niringi kinia⸥ kanopale Yesusini nimbale: “Pulu Yemo ye nokoli kingimu molopa nokolemo yombo talape akumu i bolangoma mele molemele yomboma ononga yombo talapemo kene onone i bolangoma na moliona wangi pipi siku “Mólo.” naa niee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aku nimbale yuni bolangoma ⸤kondo kolopa⸥ yunga kimuni ono selu selu nimba ambolopale kanu koleana mundupa kelepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Walte ye se Yesusi molorumuna omba yundu mangilipa pilipa nimbale: “Ungu Mane Sili Yemo, na nambolka ungu peangamo sembó kinia konde molopa kondopa mindi puli ulu-pulumu limbuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesusini yundu nimbale: “Nuni na nambi semu-na ulu peangamondo mangilku pilkinuye? Yombo selu mindi peanga molemo. Nuni ‘konde molopo kondopo mindi puli ulu-pulumu limbu.’ konopu lienu liemu ⸤Pulu Yemonga⸥ ungu-mane ⸤Mosisini yando nimba sirimuma⸥ sengena panjiku seko molani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yemone mangilipa nimbale: “Aku ungu-manemanga semando nikinuye?” nimba mangilierimu kinia Yesusini pundu topa nimbale: “ “Yombo toko naa kondangi.” nimba, “Ambo ye pulima molo ye ambo lilima yombo lupama kinia wa ulu-kirinale naa sangi.” nimba, “Mélema wa naa liengi!” nimba, “Yombomanga kote kolo toko naa sendangi.” nimba, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Aminieli lanieli kinia seko kondoko, ungu ningí mele pilku liku seko molangi.” nimba, “Ono onono yu-mele-mele konopu mondoko ononga kangimu onono kondo kolko nokolemele mele aku sikula pulu lemó yomboma konopu mondoko nokoko molangi.” nimba, ungu-mane akuma sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aku nirimu kinia pilipale kanu kango-yemone nimbale: “Na kanu ungu-manema pali pilipu lipu sepo molio. Pe kiniá nambolka uluri olandopa samboye?” nimba mangilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesusini yundu pundu topa nimbale: “Nu ‘kamu ye sumbi nílimu molambo.’ konopu lienu liemu nu pungu nunga méle taltolenoma pali kou-mone li-punguli, kou-mone linima yombo koropama moke seko sikuli na lombili ou.” nirimu. “Nunga ⸤mana-⸥mélema aku sení kinia mulu-koleana nunga méle kande-kandema lemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kanu kango-yemo méle paa awisili taltorumumunga Yesusini yundu aku nirimu kinia pilipale yu konopu kiri panjilipa anju purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","⸤Aku serimu-kulu kanopale⸥ Yesusini yu lombili andolimando nimbale: “Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu yombo kamakoma paa kála seko sukundu pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Onondo kelepo nikiru: “Kongi kamele ⸤kongi paa awili se-na-kolo⸥ kale suru tolina sukundu pumbándo kála kanga mele sepale pumbá. Aku-sipa na-kolo yombo kamakoma Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu kála paa awili mele seko pungí.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aku nirimu kinia pilkuli yu lombili andolima paa mini-wale munduku pungu-pungu ninguli anju yando kerepale ningu ninguli: “Aku liemu mindili nolemolá aulkana nawe manda wendo pumba, molopo kondomolo aulkana pumbaye? Se mólonje.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesusini ono neme-neme nimba kanopa nimbale: “Sika yomboma onono manda mólo na-kolo Pulu Yemone manda sendemba. Pulu Yemo yuni unguma pali manda selemo. Ungu se yuni manda naa sembá se mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yuni aku nirimu kinia pilipa Pitane yundu nimbale: “⸤Pe olio-kinia nambolka uluri wendo ombáye?⸥ Olio olionga mélema pali mundupu kelepo nu lombili purumulu kene méle nambolka mélema limulúye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesusini nimbale: “Nane onondo paa sika nimbu sikirumu: “Pe ⸤Pulu Yemone⸥ mélema pali ‘konde pupili.’ nimbá kinia Mania Omba Mana-Ye Au Lierimu Yemo yunga ye nokoli kingi polo pa tondolo selina molopa yomboma nokomba kinia, ono na lombili andolemele yema pea ye nokoli kingi polo rureponga molkole ningímuni, Isirele yombo talape rurepo nokonge.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yombo na konopu mondoko nanga kongonomo sendengendo ononga ulkama, genupilima, kemulupilima, anupilima, lapalima, bolangoma, koleama, akuma munduku kelieringi ⸤mele kelenge⸥ yomboma pali, ya mana paa olandopa méle awisili likuli, konde molko kondoko mindi puli ulu-pulumu lingíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aku-sipa na-kolo kiniá awili molemele yombomanga awisili pe ⸤Pulu Yemo ye nokoli kingimu molopa nokomba koleana⸥ yombo koropama molonge; kiniá koropa pupili molemele yomboma pe yombo awilima molonge.” ⸤nimba Yesusini nirimu.⸥ ⸤Yesusini yu lombili andolimando ungu se pea nimbale:⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aku nikiru ungumunga ⸤ungu se niembo:⸥ Pulu Yemone ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa mele: “Walte kalia pulu ye sene ‘Kongono sendeli ye mare yunga unju waene kaliana kongono sendangi.’ nimba paa orili-u pumba li-purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Kongono sangi.” nimba liltimu yemando nimbale: “Kiniá senge walemonga ono kou-mone paip kina paip kina nimbu méle kalombo.” nirimu kinia onone “Manda.” niringi kinia yuni ono yunga unju waene kaliana “Kongono sangi paa.” nimba ono lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pe, orili-u nani killoko mele serimu kinia, yu kelepa yomboma maku toringi koleana pumba ye mare akuna we gilieringi kanopa ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","onondo nimbale: “Ono kepe ⸤nanga⸥ unju-waene kaliana kongono sendangi payo. Pe nane ono kou seluna méle kalombo.” nirimu ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","kinia ono puringi. Pe awi-tangoli serimu kinia kepe, ipupini tere killoko mele serimu kinia kepe, kelepa aku sipa pumba ye mare pea liltimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ipupini paip killoko mele serimu kinia ⸤kelepa⸥ pumba ye mare we gilieringi kanopale onondo nimbale: “Enamanga pali kongono naa seko ya inia nambi semu-na we gilimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Onone yundu ninguli: “Ye sene olio kongonona naa limu-na we gilimulu.” niringi. Yuni onondo nimbale: “Ono kepe ⸤nanga⸥ unju-waene kaliana kongono sende-paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ena pora nirimu kinia unju-waene kalia pulu yemone yunga kongono nokoli yemondo nimbale: “Kongono sekemele yema ‘sukundu waa.’ ningu ono kongono sengimunga méle kalonindu paa akileko ongi yema pulu polko méle kalko pungu kumbi leko ongi yema paa akileko méle kalou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","⸤Aku nirimu kinia⸥ ipupini paip killoko mele serimu kinia “Kongono sendangi.” nimba liltimu yema ⸤kumbi leko⸥ ongo paip kina paip kina nimba sirimu liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Akileko ongo kongono senderingi yema kou aku siku liltingi kanokole kumbi leko ongo kongono senderingi yema ongole ‘Olio kou olandopa mele limulú.’ konopu lieringi-na-kolo ono paip kina paip kina nimba sirimu liltingila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Likuli onone kalia pulu yemondo iri toko ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Akileko ongi yema ena selu manjiku kongono sengi, olio orili-u ombo kongono awili-sepo semulu, ena awili tomumuni olio paa nomu kanumu, na-kolo ono kinia olio kinia kou selu-siku sikinumu, manda naa sekemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yuni ononga ye sendo pundu topa nimbale: “Kangomo, nane nu sepo naa kinjikiru. “Paip kina simbú.” nindu kinia “Manda.” ninu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kou sikirumu liku mengo puyo. Nanga konopuni mindi pilipuli akilepa omu yemo nu sikiru mele yu aku sipu sindu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nanga taltolio mélemanga konopuni pilipuli manda naa semboye? Molo pe ongi yema kou awili-sepo sindumunga nu konopu kiri panjikinuye?” nirimu.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","⸤Ungu-iku akumu topa pora sipale ungu-ikumunga pulumu kamu nimbale:⸥ “Aku sipala, akileko onge yomboma ⸤Pulu Yemone nokolemo talapena sukundu⸥ kumbi leko pungí; kumbi leko onge yomboma akileko pungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kanu-kinia Yesusi kolea-awili Jerusalleme pumbá purumu kinia yu lombili andoli engaki rurepo ‘na kinia ono kinia oliolio molamili.’ nimba ono lipa anju memba pumba onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Piliame. Olio Jerusalleme pumulú pukumulu. Akuna pumulú kinia Mania Omba Mana-Ye Au Lierimu Yemo ye sene ‘Tangi.’ nimba Pulu Yemo popo tondoli ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane silimili yema kinia, lipa simba, onone yu kote sendeko ‘Yu kolopili tangi.’ ninguli ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Juda ye naa molemele yema liku singí. Kanu-kinia kanu yemane yu ungu-taka tondoko, ka-pultane toko, ‘Yu kolopili.’ ningu unju-perana uku toko panjingí. Kolopale wale yopoko-sipamonga Pulu Yemone yundu ‘Lomboroko ola molou.’ nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pe-mele Seperi malo Jemisi kinia Jonotolonga anumu Yesusi molorumuna omba komorongo langopa yundu “‘Nu ungu se sani.’ nimbu mawa sembó okoro.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","yuni yundu nimbale: “Nambolka unguri ‘nane sendambo.’ ningu nikinuye?” nirimu. Ambomone nimbale: “Nu pe ye nokoli kingimu moloni kinia i nanga kango talo ⸤ ‘olo nu kinia pea ye nokolima molamili.’ ningu⸥ ‘olonga se nunga ki-lomekondo mondoko se nunga ki-tarokondo mondani.’ nimbu mawa sekero.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesusini onondo nimbale: “Mawa sekemele mele ono pilku naa kondokomele. Na no-mingina no nondopo nombómo olo manda nongeleye? nirimu kinia olone “Manda nombolo.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yuni olondo nimbale: “Na no-mingina no nombómo pe olo paa sika nongele-na-kolo nane olo “Nanga wangutolonga ongo molangili.” nimbúmu manda naa sembá. Tatane yuyu akuna molongeletolo koronga nimba taltorumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Genungulu ⸤Jemisi kinia Jonotolone ‘Yesusinga wangutolonga molambili.’ ⸥ ningu mawa seringili mele pilkuli lombili andoli ye rureponga talo ⸤wemane⸥ olo-kinia konopu kiri panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanu-kinia Yesusini ono “Waa.” nimbale nirimumuni, onondo nimbale: “Olio Juda yombomanga ultu molemele yombo talapemanga ye nokolima ononga yomboma tondolo munduku nokoko kongono enge nilima alieli silimili. Ye imbi ola molemo yema ononga yomboma ‘Mindili nangi.’ ningu nokolemele. Yombomane ononga ye nokolimanga unguma pilkuli mokoli senge aulka se naa lemó. Aku siku selemele mele onone pilielemele kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aku-sipa na-kolo ⸤we-yombomanga ye nokolimane ononga yomboma tondolo munduku nokolemele mele na lombili andoli yema⸥ ono onono aku siku anju yando naa sangi. Ononga ye se ‘Na imbi olandopa molopili. Na ye-awilimu molambo.’ nimbá yemo ononga kongono sendeli yemo molopili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘Na ononga ye nokolimu molopo ono nokambo.’ nimbá yemo ononga kongono kendemande sendeli yemo molopili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aku sipala, Mania Omba Mana-Ye Au Lierimu Yemo kepe ‘Yombomanga ye-awilimu molopo ono nokambo. Onone nanga kongono sendeli kendemande-yomboma molangi.’ nimba naa orumu. ‘Yombomanga kongono sendeli kendemande-yemo molopo ono lipu tapondopo, ulu-pulu-kirimane ono ka sipa nokolemo mele naa sepili manda molangi kene na yombo awisilinga nimbu pundu tondopo nanga kangimu sipu, ononga kolali sepo kolondambo.’ nimba orumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesusi kinia yu lombili andolima kinia ono kolea-awili Jeriko munduku kelko pungí puringi kinia we-yombo awisili yu lombili puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kanu-kinia mongo kiri lierimu ye talo aulka lomolomena molko Yesusi omba purumu mele pilkuli yundu tondolo ru ningu mangilku ninguli: “Ye-Awilimu, ⸤ye nokoli kingi⸥ Depitini kalopa liltimu yemo, olto kondo kolou.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yombomane olo iri toko “Ungu naa nili taka leko molale.” niringi. Aku-na-kolo olone paa tondolo ru ningu mangilku ninguli: “Ye-Awilimu, Depitini kalopa liltimu yemo, olto kondo kolou.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesusi we gilipale “Olo wale.” nimba olondo nimbale: “Nane olo nambi sambo konopu lekembeleye?” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","mongo kiri lierimu yetolone ninguli: “Ye-Awilimu, ‘oltonga mongotolo ‘Kelepa umbu-mongo giliepili.’ nieni.’ konopu lekembolo.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kanu-kinia Yesusini olo kondo kolopa mongona ambolorumu kinia olo popenge sepa mongoma peanga lierimu, mélema kanokole, Yesusi lombili puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","⸤Yesusi kinia yu lombili andolima kinia⸥ ono kolea-awili Jerusalleme nondoko ongo, ma-pangi se ‘Ma-Pangi Unju Ollipi Kalia’ nili akuna lemó kolea-kanga Betepasi oringi. Kanu-kinia Yesusini yu lombili andoli ye talo lipa mundupale, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","olondo nimbale: “Ne kolea-kanga kanokombelena punguli kongi dongi se ka seko panjingímu kinia yunga walomo pea ne sukundu molongele kanongele, kanutolo pungu posiku yando mengo wangili pale. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Posingilí seko molongele kinia yombo sene olondo ungu se nimu liemu olone i-siku niengili: “Ye-Awilimu yu ‘Dongimuni mepili.’ nimu-na ombo likimbulu.” niengili. Aku ningilí kinia yuni sumbi sipa “Manda, mengo pale.” nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aku sipa wendo orumumunga koronga-u Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye sene ulu se pe wendo ombá u nirimu mele kamu wendo orumu. Akumu i-sipa: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Onone kolea-awili Sayono yombomando i-siku niengi: “Kanayo! Ono molemelena ononga ye nokoli kingimu okomo. Yu ye imbi naa mololi yemo mele taka lepa molemomo kongi dongi bulu-mingina molopa okomo. Kongi dongi senga walomonga bulu-mingina molopa okomo.” ningu, ningu siee.” nirimu kanumu. ⸤Aku nirimu mele Yesusini serimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kanu-kinia lombili andolitolo pungu Yesusini “Se-pale.” nirimu mele se-puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Olone kongi dongimu kinia yunga walomo kinia mengo ongole, onone ononga mulu-maminiama kulku dongitolonga bulu-mingina ola pauwa toringi kinia Yesusi kanuna ola molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yombo maku toringimanga awisilini ononga mulu-maminiama kulku yu ombá aulkana pauwa tolko pungu, marene kipi gomo langoko liku yu ombá aulkana pauwa tolko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kumbi leko puringi yombomane kepe akileko puringi yombomane kepe kalkarukumba leko unju ambololeko pungu ninguli: “⸤Ye Nokoli Kingi⸥ Depitini Kalopa Liltimu Yemo ‘Imbi ola molopili.’ niemili. Pulu Ye Yawene lipa mundorumu-na yunga kongonomo sendemba okomo yemo molopa kondopili. Mulu-koleana ola yu imbi ola molopili.” niliku puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesusi Jerusalleme sukundu purumu kinia kanu kolea-awilimunga sukundu moloringi yomboma pali konopu awisili kimbu sikuli “Imu nawe?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Maku toko moloringi yombomane ninguli: “Imu Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye Yesusi, kolea Gallilli disiriki Nasarete taono ye se.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesusi ⸤Jerusalleme sukundu pumbale nirimumuni,⸥ Pulu Yemo popo toko kaloringi ulka-tembelena ⸤“Juda yombo naa molemele yomboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ sukundu pumba kanopale akuna mélema makete seko moloringi yomboma kinia, mélema topo toko liku moloringi yomboma kinia akuma kanopale ono pali topa makoropa, kou-mone lupa lupama topele toko anju siringi yombomanga poloma kinia, kera waembono makete seringi yombomanga mania moloringi poloma kinia, topele topa, topa bulu-balu sipale, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","onondo nimbale: “Pulu Yemonga bokuna ungu se i-sipa nilimú: ‘Yombomane nanga ulkamondo “Pulu Yemo kinia ungu nilimulu ulkamo.” ningí.’ kanumu. Ungu aku sipa molemo-na-kolo onone i ulkamo ‘wa nolemele yomboma lopi seko molemele ulkamo’ mele ningu pilkuli aku siku selemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kanu-kinia Yesusi ulka-tembelena molopili yombo mongo kiri lepa, kimbu ki kiri lierimu yombo awisili yu molorumuna oringi kinia yuni ono sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aku-sipa na-kolo yuni we-yombo sene manda naa selka ulu-tondolo peangama serimu mele kinia, ulka-tembelena bolangomane tondolo ru ninguli: “Ye Nokoli Kingi Depitini Kalopa Liltimu Yemo ‘Imbi ola molopili.’ niemili.” niringi mele kinia, kanu ulutolo wendo orumu mele kanokole Pulu Yemo popo tondoringi ye awilima kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia onone konopu kiri panjiku ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yesusi mangilkuli: “Andi bolangomane ungu nikimili mele nu ⸤naa⸥ pilkinuye?” niringi. ⸤Aku-sipa na-kolo⸥ Yesusini onondo nimbale: “Na pilkiru. ⸤Andi bolangomane sekemele mele⸥ ungu se bokuna molemo mele ono naa kanolemeleye? Kanumu i-sipa molemo: ‘Bolango kangama kinia bolango pamema kinia ⸤Pulu Yemo⸥ nu paa kape ningí mele mane sirinu.’ aku ungumu bokuna molemo mele ono naa kanolemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aku nimbale yu kanu yema mundupa kelepa kolea-awili ⸤Jerusalleme⸥ ultukundu pumba kolea-kanga Betani pumba akuna perimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Orili-u ⸤Jerusalleme nondopa lierimu kolea Betani mundupa kelepa Yesusi⸥ kelepa kolea-awili ⸤Jerusalleme⸥ pumbá purumu kinia yu gele serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kanu-kinia yu orumu aulka kelona unju piki se gilierimu kanopale nondopa pumba kanorumu kinia unju mongo se topa naa perimu, gomo mindi serimu kanorumu. ⸤Gomo mindi serimu-na⸥ kanopale “Nu kelko mongo se naa tani.” nirimu kinia unju piki kanumu waltikele kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aku ulumu wendo orumu kinia kanokole yu lombili andolimane paa mini-wale munduku ninguli: “I unju pikimu nambi sepale waltikele kolomuye?” ningu mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesusini pundu topa nimbale: “Nane onondo paa sika nimbu sikirumu: “Ono konopu talo sepa naa pepili ⸤Pulu Yemone nanga ungumu sika pilimbamonga nimbú mele ‘paa sika wendo ombá.’ ningu⸥ kuru mondongi liemu nane i unju pikimu sendu mele manda senge. Unjuma mindi mólola. Ne ma-pangimundu “Ungú toko nomu-kusana sukundu pu.” ningí kinia pumbála. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","‘Olio ⸤Pulu Yemone paa sika lipa tapondombamonga ‘Samili.’ nimulú mele sika manda aku sipu semolo.’ molo ‘Nimulú kinia sika aku sipa wendo ombá.’ ningu⸥ kuru mondokole ⸤Pulu Yemo kinia⸥ ungu ningu mawa senge mele pali Pulu Yemone sika sendembamonga kanu uluma sika wendo ombá.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kanu-kinia Yesusi ⸤kamu Jerusalleme omba⸥ ulka-tembele kerepuluna omba, yomboma ungu-mane sipa molorumu kinia ye mare, Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga tapu-yema kinia ono ongo yu mangilku pilku ninguli: “Nu namba nambolka nambamo likuli i kongonomo selenoye? Nawene i kongonomo ‘Se-pu.’ nimba nu nambamo sipa lipa mundorumuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesusini onondo pundu topa nimbale: “Nane ono ungu se mangilipu piliambola. Pe nane ono mangilimbu mele onone na sumbi siku pundu toko níngi liemu ‘Na i kongonomo sambo.’ nimba namba sirimumunga pulumu ono nimbu simbula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","⸤Nane i-sipu ono mangilipu pilkiru:⸥ U ⸤No Lindeli⸥ Jono omba yomboma no linderimu kinia yu mulu-koleana molemo yemonga kongonomo sendembando yomboma no linderimu molo ya mana-yombomanga kongonomo sendembando yomboma no linderimuye? ⸤Nawene “Sei.” nirimu-na serimuye? Ningu siee.⸥” nirimu. ⸤Yuni aku sipa mangilierimu mele pilkuli⸥ onone onono angelema ningu ninguli: “Yuni mangilkimu mele olione pundu topo, ‘⸤Jono⸥ yu mulu-koleana ⸤molemo yemonga kongono sendembando yomboma no linderimu⸥.’ nímulu liemu yuni oliondo nimbale: ‘Aku liemu ono Jonone nirimu ungumu nambi semu-na ‘I ungumu sika.’ ningu naa pilku liltingiye?’ nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Molo olione nimbuli: ‘Yu mana-yombomanga ⸤kongono sendembando yomboma no linderimu⸥.’ nímulu liemu we-yombomane ‘olio tongenje’ nimbu pipili kolkomolo. We-yombomane ‘⸤No Lindeli Jono⸥ yu paa sika Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye se molorumu.’ ningu pilielemele kene olio nambi semolonje?” ningu onono aku siku angelema niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","⸤Onono aku siku anju yando angelema ninguli,⸥ Yesusindu pundu toko ninguli: “⸤Nuni mangilkinu mele⸥ olio naa pilkimulu.” niringi. Aku siku niringi kinia pilipale Yesusini onondo nimbale: “Manda. ⸤Nane ono mangilkiru ungumunga ungu se pundu toko naa nikimilimunga⸥ onone na mangilkimili ungumunga ungu se pundu topo nando i kongonomo ‘Se-pu.’ nimba na lipa mundupa namba sirimu yemonga imbimu ono naa nimbu simbula.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","⸤Yesusini kelepa kanu Juda yombomanga ye awilimando nimbale:⸥ “Ono nambolka konopu lekemeleye? Ye se yunga kango talo moloringili. Yu pumba kango komomondo nimbale: “Kangomo, kiniá nu unju-waene kaliana pungu kongono se-pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yuni pundu topa lapando “Mólo, na naa pumbú.” nirimu, aku-na-kolo pe yu konopu topele topale purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lapa pumba komomondo nirimu mele aku sipa akiliumundu nirimu ⸤kinia⸥ yuni pundu topa “Se-pumbú.” nirimu, aku-na-kolo naa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kanu kangotolonga nawene lapanga ungumu pilipa lipa serimuye?” nirimu. Onone pundu toko “Komomo.” niringi. Yesusini onondo nimbale: “Nane onondo paa sika nimbu sikirumu: “Ono ⸤Juda yombomanga ye-awilima⸥ Pulu Yemo ye nokoli kingimu molopa nokolemo talapena sukundu ⸤kumbi leko naa pungí⸥. Kou-takisi lili yema kinia wapora toli amboma kinia ⸤kanu yomboma, ono Juda yombomanga ye-awilimane kanoko kiri pilielemelema⸥ kumbi leko pungí.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","⸤No Lindeli⸥ Jono omba ono sumbi siku molonge aulkamo lipa ora sirimu kinia onone yu nirimumu ‘Kolo tokomo.’ konopu leko yunga ungumu kuru naa mondoringi-na-kolo kou-takisi lili yema kinia wapora toli amboma kinia yuni nirimu ungumu ‘Sika.’ ningu kuru mondoringi. Aku-sipa na-kolo kanu ambo ye kirimane aku seringi kinia kepe kanokole ‘Konopu topele topo ‘Yuni sika nikimu.’ nimbu kuru mondamili.’ naa niringila. Akumunga ⸤kanu ambo ye “Sepo kinjilimulu.” ningu konopu topele tolemele yomboma Pulu Yemo molemona kumbi leko pungí⸥.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","⸤Aku nimbale Yesusini kanu ye awilimando kelepa nimbale:⸥ “Ungu-iku se pea tambo piliayo: “Kolea pulu ye sene unju-waene kalia sepale pala serimu. Kaliana sukundu loyakolo akupa waene-no ingi sepa mondombando sepa wamopale nirimumuni, pe kalia nokonge ulka takaya se polo kulupa ola takorumu. Ye mare kanopa lipa onondo nimbale: “Nanga kaliamo tapu sendeko unju mongoma inia toko nokondangi. Pe waene mongo polo tomba kinia unju mongoma moke sepo, kongono sendenge mele mare ono liengi mare na liembo.” nimba kanu kaliamo ono sipale yu kolea paa suluringa pumba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kanu-kinia pe waene-mongo polo tomba serimu kinia kalia pulu yemone yunga kendemande-ye mare “Nanga waene-mongo siengi pungu liku mendeko wangi paa.” nimba kalia nokoringi yema moloringina lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aku-sipa na-kolo kendemande-yema ⸤oringi kinia⸥ kalia nokoli yemane ono ambolko likuli se kopene toko, se toko kondoko, se kouni toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kelepa kalia pulu yemone kendemande-ye mare awisili mele lipa “Nanga waene-mongo lindi-paa.” nimba lipa mundorumu, u kendemande-ye koltalo mele lipa mundorumu. Aku-na-kolo kalia nokoli yemane u-pulu-pulu oringi kendemande-yema-kinia seringi mele pe kendemande oringi yema-kinia akula seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kanu-kinia kalia pulu yemo yuni ⸤konopuni pilipale⸥ ‘Nanga kangomo pipili kolko yunga unguma pilku liku, yu waene-mongoma singí.’ konopu lepale yunga malo lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aku-sipa na-kolo kalia nokoli yemane kalia pulu yemonga malo ombá orumu kanokole onone onono ninguli: “Andi okomo yemo pe lapanga monge-mélema limba yemo okomo. Yu topo kondopo i kaliamo olio kamu liemili.” ninguli ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","onone yu ambolko liku kaliana ultu mundukuli yu toko kondoringi.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","⸤Yesusini ungu-iku akumu topa pora simbando kanu Juda yombomanga ye-awilimando mangilipa nimbale:⸥ “Kalia nokoli yemane aku seringimunga kalia pulu yemo ombale kanu kalia nokoli yema-kinia yuni nambolka unguri sembá konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Onone yundu pundu toko ninguli: “Yuni kanu ye kirima ‘kamu molko kinjangi.’ nimba sepa kinjipale kalia nokonge ye lupa mare lipa waene-mongo polo tomba kinia waene-mongoma moke seko, mare kalia pulu yemo singí yema kaliamo simba.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesusini ⸤Pulu Yemonga Juda yomboma nokoringi yemane yu toko kondonge mele pilipale⸥ onondo nimbale: “Pulu Yemonga bokuna sukundu molemo ungu se kanoko naa pilielemeleye? ⸤Aku ungumu i-sipa mele:⸥ “Ulka takoringi yemane kanoko kiri pilku toko eltoringi kou kanumu kiniá kelepa ulka-simu mele ulka enge sindeli kou awili peangamo. Ye-Awilimuni aku ungumu serimu olione kanopo paa peanga pilielemolo.” nimba molemo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aku ⸤nirimu⸥munga nane ono ⸤Pulu Yemonga Juda yomboma⸥ nimbu sikirumu: “Pulu Yemo ononga ye nokoli kingi molopa ono nokolemo mele mundupa kelepale nimbámone, yombo talape lupa sene yunga ungumu pilku liku seko molongema lipa nokomba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","⸤I kou ⸤nikiru⸥munga ola yombo se a topa topale bele mélema elke tomba. Aku-na-kolo yombo se molombana ola koumu omba yu topale kanu yombomo topa norupulu tomba.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kanu-kinia Pulu Yemo popo tondoringi ye awilima kinia Parisi yema kinia Yesusini ungu-iku torumuma pilkuli onone yu toko kondonge seko moloringi mele yuni nirimu pilkuli ");
INSERT INTO ubu_andelale_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","onone yu ka singí seringi-na-kolo yombomane ‘Yu Pulu Yemone ungu-umbu tondolemoma pilipa yando nimba silimú ye se.’ konopu lieringi-kulu yomboma pipili kolkole yu iseli-u ambolko ka naa siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesusini kelepa ungu mare ⸤Juda ye awilimando nimbando⸥ ungu-iku se pea topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa mele: “Ye nokoli kingi sene yunga malo ambo limbamonga kere-langi awisili kalondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koronga “Ye ambo limba kere-langi pea namili sukundu wangi.” nirimu yomboma yunga kendemande-yombomando “ “Kiniá kere-langi namili waa.” ni-paa.” nimba mundorumu, na-kolo pungu aku siku niringi kinia ono “Naa omolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kelepa kendemande-ye mare lupa lipa mundupa nimbale: “ “Kere-langi pea namili wangi.” nirindu yombomando pungu ninguli: “Kere-langi sepa mimi sepa pora simu. Yunga kongi kao peleama kinia kongi kao walo wami selima kinia tomu. Kere-langi pali sepa mimi sepa taltolemo kene ye ambo limbamonga kere-langi pea namili waa.” ni-paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aku-sipa na-kolo pungu niringi kinia naa pilku siye kolko, se yunga kaliana pumba, se yunga bisinisina pumba, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","marene kingimunga kendemande-yema ambolko liku seko kinjikuli toko kondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","⸤Aku seringimunga⸥ kingimu mumindili kolopa yunga ami-yemando nimbale: “Ono molemelena pungu toko kondoko ononga koleamo sepe leko to-paa.” nimba ono lipa mundorumu kinia punguli, nirimu mele seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kanu-kinia kingimuni yunga kendemande-yemando nimbale: “Ye ambo limbamonga kere-langi taltolemolo-na-kolo “Pea namili wangi.” nirindu yomboma nonge manda naa sembá kene ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ono pungu aulka lupa lupa lemomanga pali pungu yombo kanongema “Ye ambo limbamonga kere-langi pea namili waa.” ni-paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pilkuli kanu kendemande-yema aulkamanga pali pungu yombo kanoringima pali liku maku toringi. Yombo peangama kinia yombo kirima kinia pea liku maku toringi. Kanu-kinia ye ambo limbamonga koleana yomboma paa ongo sengepea seko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ongo moloringi kinia kingimu “Yombo maku toko molemelema kano-pambo.” nimba ono moloringina ombale, yomboma ye ambo limba ⸤makuna ongemonga wale-pakoli kamuma ‘pakoko sukundu wangi.’ ningu siringi⸥ wale-pakolimanga ye se wale-pakoli akumanga se naa pakopa molorumu kanopale ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","yundu nimbale: “Kangomo, nu ye ambo limba wale-pakoli se naa pakokono kanokoro kene nu aulka semonga sukundu onuye?” nirimu kinia kanu yemone unguri naa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanu-kinia kingimuni kere-langi nokoringi kendemande-yemando nimbale: “I yemo kimbu kima ka toko pena kolea simbulu tokomona toko pena mundaa!” nirimu. Akuna yomboma paa mindili nongo kola seko pereko molonge.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","⸤Aku nimbale Yesusini ungu-ikumunga pulumu kamu nimbale:⸥ “Sika ⸤Pulu Yemone⸥ yombo awisilindu “Waa.” nilimú-na-kolo yombo koltalo mindi nimba taltopa “Sukundu waa.” nilimú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","⸤Yesusini aku sipa nirimu⸥ kinia ⸤pilkuli⸥ Parisi yema ultu pungu ono onono liku maku toko ninguli: “‘Yesusini ungu se nimba kinjepili.’ nimbu nambi samiliye?” ningu angelema ninguli niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ono lombili andolima kinia ye nokoli kingi Erotenga talape ye mare kinia liku Yesusi molorumuna liku mundoringi, ono pungu Yesusindu ninguli: “Ungu Mane Sili Yemo, olio pilielemolo, ‘nuni ungu sikama mindi ningu, Pulu Yemone “Saa.” nilimú uluma paa sika unguma mane siku, nu yombo seluringa kepe konopu kimbu naa siku, yomboma pipili naa kolko onondo pali ungu selu-siku ningu silinu.’ konopu lemolo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aku siku ningu molenomonga nu nambolka konopu lekenoye? Olione Romo Gapomano Ye Paa Awili Kumbina ‘Sisa’ nili se kou-takisi tomulu liemu manda molo móloye? Pulu Yemone akumundu ungu-mane sirimu ungu-mane nambolka nimba pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aku-sipa na-kolo Yesusini yu-kinia konopu kiri panjiku yu seko kinjingí seringi pilipa onondo nimbale: “Ono kolo toko topele-mapele toli yema, ‘Yuni nimba kinjepili.’ ningu nambi semu-na na manda manjiku kolo toko mangilkimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi tolemele kou-mongo se na liku ora siee.” nirimu. Onone yu molorumuna kou-mongo se mengo ongo yu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kanu-kinia Yesusini onondo nimbale: “I kouna nawenga kumbikeremo kinia imbimu molemoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Onone yundu ninguli: “Romo Gapomano Ye Paa Awili Kumbina Sisamonga kumbikeremo kinia imbimu molemo.” niringi. Kanu-kinia yuni onondo nimbale: “⸤Kou-monemo Sisamonga⸥ kene Sisamonga mélema Sisamo yuyu siku, Pulu Yemonga mélema Pulu Yemo yuyu siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yuni aku sipa ⸤paa sumbi sipa⸥ nirimu mele pilkuli ⸤ ‘Yu paa pilipa kondoli pelemo yemo lepomo.’ ningu pilku⸥ konopu awisili kimbu sikuli yu munduku kelko ono puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","⸤Kanu yema Yesusi kinia kou-takisi toli ungumu ningu pora siringi kinia⸥ pe aku enamonga Sadusi ye mare Yesusi molorumuna oringi. Sadusi yema ono ‘Pulu Yemone pe kololemele yomboma topa naa makisindimba, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Aku Sadusi yema ongo Yesusi mangilku pilku ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ungu Mane Sili Yemo, ⸤Pulu Yemonga ungu-manema olio sirimu ye⸥ Mosisini ungu-mane sipa nimbale: “Ambo limba ye se bolango naa membale kolomba kinia kanu yemo yunga genu molombamone yunga ambo-wayamo lipa genu lipa tapondopa bolango mendepili.” nirimu aku sipa bokuna molemo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","⸤Aku ungu-manemonga ulu se olionga ye mare-kinia wendo orumu mele nu mangilipu piliamili.⸥ “Genupili yopoko-pakara moloringi. Komomo ambo lipale kolorumu. Bolango se naa molopili kolorumu-kulu yunga bulkundu genumuni ⸤yunga genu kolorumumunga⸥ bolango ‘Mendambo.’ nimba ambo-wayamo kelepa liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aku-sipa na-kolo bolango se naa mendepale yu we kolorumula. Yunga bulkundumuni kanu ambomo liltimula-na-kolo yu kepe we kolorumula. Aku selko punguli ye yopoko-pakara pali bolango selu kepe naa mengole kolko pora siringi kinia akiliumu we kolorumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pe ambomo yu kolorumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akumunga, kololemele yomboma pe lomboroko ola molonge kinia kanu ambomo ye yopoko-pakara pali ya mana liltingi-kulu ambomo yu ye paa nawenga menu molombaye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusini onondo pundu topa nimbale: “Ono Pulu Yemonga bokuna ungu molemoma kinia, Pulu Yemo kinia tondolo pelemo mele kinia, naa pilku lo limilimunga ⸤yomboma pe sengemondo nikimili mele pilku sunduku kolo tokomele⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lomboroko ola molonge yombomanga yema ambo naa liku, amboma ye naa pungu, aku paa naa senge. Mulu-koleana molemele angelloma molemele mele aku siku molonge. ⸤Angellomane mana-yomboma selemele mele naa selemele kanumu.⸥ Aku sengemonga ⸤ ‘Ono Pulu Yemonga ungumu pilku sunduku lawa selemele.’ nikiru.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","“Aku-sipa na-kolo ⸤ono Sadusimane⸥ ‘Kololemele yomboma lomboroko ola naa molonge.’ konopu lemelemonga ungu se Pulu Yemone onondo nirimumu onone naa kanoko pilielemeleye? Yuni i-sipa nimbale: “Na Eporayamo kinia Aisake kinia Jekopo kinia ononga Pulu Yemo molio.” nirimu. Pulu Yemonga bokuna aku ungu molemomo naa kanoko pilielemeleye? ⸤‘Ononga Pulu Yemo molorundu.’ naa nirimu. ‘Ononga Pulu Yemo molio.’ nirimu kanumu.⸥ Pulu Yemo yu kololi yombomanga Pulu Yemo molo; yu konde mololi yombomanga Pulu Yemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yuni aku nirimu mele yombo maku toko moloringimane pilkuli yunga ungu-mane sirimu unguma pilkuli pungu-pungu ningu paa konopu awisili kimbu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aku-sipa na-kolo Yesusini aku ungu nirimumuni Sadusi yemanga ungumu pipi sinderimu, ono ungu se naa perimu-na Parisi yemane pilkuli ono liku maku toko ⸤Yesusi molorumuna⸥ oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","⸤Oringi kinia⸥ ononga ye se, yu Pulu Yemonga ungu-manemanga puluma pilipa kondorumu yemone ‘Yuni nimba kinjimbanje manda manjipu piliambo.’ nimba Yesusindu mangilipa pilipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ungu Mane Sili Yemo, Pulu Yemone ungu mane sirimu pelemomanga nambolka ungu-manemo yu olandopaye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesusini yundu nimbale: “Ungu-mane olandopamo i-sipa: ‘Onone ononga kamelema kinia, ononga minima kinia, ononga pilipa kondolima kinia, akumane Ye-Awilimu ononga Pulu Yemo manjiku tondolo munduku konopu mondangi.’ aku nimba pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aku ungu-manemo yu paa tondolo, olandopamo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Talo-sipa ungu-manemo yu-kinia selu sipa mele. Akumu i-sipa: ‘Onone onono yu-mele-mele konopu mondoko ononga kangimu onono kondo kolko nokolemele mele aku sikula pulu lemó yomboma konopu mondoko nokoko molangi.’ nimba pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pulu Yemonga ungu-mane Mosisini sirimuma pali kinia, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane bokuna toringi unguma pali kinia, kanu ungumanga pulumu aku ungu-manetolo mindi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kanu-kinia Parisi yema aku siku we maku toko molangi Yesusini onondo i-sipa mangilipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimundu onone nambolka konopu lekemeleye? Yu nawe? Yu nawene kalopa limba konopu lemeleye?” nirimu kinia onone ninguli: “⸤Ye nokoli Karasimu yu ye nokoli kingi⸥ Depitini kalopa limba ye se.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yuni kelepa ono mangilipa nimbale: “Aku liemu ⸤Pulu Yemonga⸥ Minimu Depitinga konopuna molopale ungu se nirimu kinia Depitini pilipale ye nokoli Karasimundu “Ye-Awilimu” nirimu akumu nambi semu-na nirimu konopu lekemeleye? Depiti yuni ⸤ye Karasimu molomba mele⸥ i-sipa nirimu: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ye-Awili ⸤Pulu Ye Yawene⸥ nanga Ye-Awilimundu nimbale: “‘Nunga opa-touma nuni nokani.’ nimbu, pe ono topo mania mundundumbu kene iseli-u nu ⸤na kinia pea kopu sepo ye nokolitolo molopo mélema nokambili⸥ Karasimundu nanga ki-lomekondo ongo molani.” nirimu.” nimba Depitini nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depitini ⸤ye nokoli Karasimu⸥ yundu “Nu nanga Ye-Awilimu.” nirimu liemu yu pe nambi sepa Depitini kalopa limba ye se ⸤mindi⸥ molombaye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","⸤Yesusini aku sipa mangilierimu mele pilkuli⸥ ye akuna moloringimanga sene ungu selu kepe pundu toko manda naa niringi. ⸤Onone yu mangilku pilieringi unguma pali yuni pundu topa anju nimba kondorumu pilkuli⸥ pe kelko yu ungu se mangilku pilingindu pipili kolko naa mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kanu-kinia Yesusini yombo maku toringima kinia, yunga lombili andoli yema kinia, ungu nimba sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pulu Yemonga ungu-manemanga puluma pilku mane silimili yema kinia Parisi yema kinia onone Mosisini ungu-manemanga puluma mane sirimu mele yandopa mane silimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Akumunga, kanu yemane ono mane silimilima pali mimi siku pilku sangi, na-kolo kanu yemane mane silimili mele kanu yema onono pilku liku naa selemelemonga kanu yema onone ungu selemelema manda manjiku naa sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yombo sene wale umbuna seli se sepa mimi sepale yombo se ‘mepili.’ nimba ola lipa buluna mendelemo mele ⸤aku siku kanu yemane yombomando ungu-mane siku “I-siku i-siku saa.” ningu⸥ umbuna silimili-na-kolo kanga-kolte kepe ‘Lipu tapondopo meamili.’ naa nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kanu yemane ungu selemelema ‘we samili.’ ningu naa selemele. ‘Yombomane olio kanokole ‘molko kondolemele.’ ningu kanangi.’ ningu unguma selemele. Pulu Yemonga ungu-manema molemo pepá se kuluepe toko mambelena molo kína ka tongendo ‘Yomboma paa kanangi.’ ningu kuluepe paa awili seko toko, ononga wale-pakolimanga ka moko toko mondongendo ka sulu peanga mare awili seko moko toko mondolemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yombomane kere-langi nongo yombomando “Namili waa.” nilimili kinia kanu yema ongole ye awilimanga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. Yomboma maku toko Pulu Yemonga ungumu pilielemele ulkana sukundu punguli mania molongendo ye awilima molemele polo peanga akuna ‘molamili.’ ningu mendo pungu polo akuna konopu siku molemelela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yomboma maku toko molemele koleana andongendo mongo-kenge seko ‘We-yombomane olio kanoko kape niengi.’ ningu pilkuli konopu siku pilku andoko molemelela. Yombomane onondo ‘Rapai’ nilimili kinia paa konopu silimilila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“⸤Kanu yemane aku selemele⸥-na-kolo ononga nokoli ye awili selumu mindi molemo, ono pali genupili molemele kene yombomane “ono olionga Rapaima.” naa niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ononga Lapa selumu mindi molemo, akumu mulu-koleana molemo, akumunga mana-yombo sendo ⸤ ‘olionga ye awilimu’ ningu⸥ “Tata” naa niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu mindi ononga nokoli ye awilimu molemo kene yombomane onondo ⸤ ‘olio nokolemo yemo’ ⸥ ningu “Ye-Awilimu” naala niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Yombo sene yunga imbimu yuyu ambolopa paka tomba kinia ⸤Pulu Yemone⸥ yunga imbimu topa mania mundumba; yombo sene yunga imbimu yuyu topa mania mundumba kinia ⸤Pulu Yemone⸥ yunga imbimu ambolopa paka tondomba kene ononga ye se ono nokomba ye awili se molopa ononga kongono kendemande yemo molopili.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","⸤Yu lombili andolimando ungu nimba kelepale Yesusini Juda yombomanga ye awili moloringimando nimbale:⸥ “Ono Pulu Yemonga ungu-manemanga puluma pilku mane silimili yema kinia, Parisi yema kinia, ono mindili nongo paa molko kinjingí! Ono topele-mapele toli yema! Onone yomboma Pulu Yemo ye nokoli kingimu molopa nokolemo mulu-koleana pungí pulimili kerepulumu pipi silimili. Ono onono sukundu naa pulimili; yombo lupama pungí selemele kinia aulkamo pipi siku “Mólo.” nilimilila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“⸤Ono ungu-manemanga puluma pilku mane silimili yema kinia Parisi yema kinia ono mindili nongo paa molko kinjingí! Ono topele-mapele toli yema! Onone ambo-wayama liku amu tondoko ononga ulkama wa liku, onone ‘Yomboma kanangi.’ ningu Pulu Yemo kinia unguma sulu seko we ningu gilimili, akumunga kote walemo wendo ombá kinia ono-kinia umbuna awili sepa pemba.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ono ungu-manemanga puluma pilku mane silimili yema kinia Parisi yema kinia ono mindili nongo paa molko kinjingí! Ono topele-mapele toli yema! ‘Yombo selu mindi kepe konopu topele topa olio lombili andomba kinia papu.’ ningu ma-koleamanga kimbu-kongono seko kolea sulumanga pungu, nomu-kusa sipimanga andolemele-na-kolo pe yombo se sika onone nilimili unguma pilipa lipa konopu topele topa lombili andolemo kinia kanu yombomo sepa kinjilimú mele paa olandopa, onone seko kinjilimili mele maniandopa, akumunga yu sepe-koleana paa sika pumbá aulkamo akisindilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ono mongo kiri lielimane “⸤Mongo kiri lieli⸥ yomboma aulkamo lipu ora siemili.” nilimili yema ono mindili nongo paa molko kinjingí! Onone yomboma mane siku ninguli: “Yombo sene mi lembando ‘ulka-tembelemo’ imbi lepa “Paa sika sembó.” nimbale pe “Sembó.” nimba panjimba mele naa sembá kinia unguri mólo. Aku-sipa na-kolo yombo sene mi lembando “ulka-tembelena ape kandoringi kou-gollomo” imbi lepa “Paa sika sembó.” nimbale pe “Sembó.” nimba panjimba mele naa sembá kinia manda naa sembá. Yu sika kamu sepili.” nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ono aroma toko mongo kiri lieli yema! Méle nambolka mélemo olandopaye? Kou-gollo akumu méle-olandopamo molo Pulu Yemo molemo ulka-tembelemone kou-gollo nimba taltopa ‘Pulu Yemonga’ nimba kake sendelemo ulkamo olandopaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Onone ungu se pea yomboma mane siku ninguli: “Yombo sene mi lembando ‘Pulu Yemo popo toko mélema kalolemele polomo’ imbi lepa “Paa sika sembó.” nimbale pe “Sembó.” nimba panjimba mele naa sembá kinia unguri mólo. Aku-sipa na-kolo yombo sene mi lembando “aku polona ola mélse singímu” imbi lepa “Paa sika sembó.” nimbale pe “Sembó.” nimba panjimba mele naa sembá kinia manda naa sembá. Yu sika kamu sepili.” nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ono mongo kiri lieli yema! Méle nambolka mélemo olandopaye? Polona ola ‘Pulu Yemo popo toko kalondangi.’ ningu silimili mélemo olandopamo molo polomone kanu mélema nimba taltopa ‘Pulu Yemonga’ nimba kake sendelemo polomo olandopaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Akumunga, yombo sene mi lembando ‘Pulu Yemo popo toko mélema kalolemele polomo’ imbi lemba kinia méle polona ola lemba mélemo kepe imbi lepa mi lemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aku sipala yombo sene mi lembando ‘ulka-tembelemo’ imbi lemba kinia ulka-tembelemo kinia akuna sukundu molemo yemo kinia imbi lepa mi lemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yombo sene mi lembando ‘mulu-koleamo’ imbi lemba kinia Pulu Yemo ye nokoli kingimu molopa kolea nokombando molemo polomo kepe aku polona ola molemo yemo kepe imbi lepa mi lembala. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ono ungu-manemanga puluma pilku mane silimili yema kinia, Parisi yema kinia, ono mindili nongo paa molko kinjingí! Ono ‘sika-unguma nikimulu.’ ningu kolo toko topele-mapele toli yema! Kere-langi kalongendo ‘songo sepili.’ ningu ononga kaliana méle-kanga lupa lupa olemomanga inia toko kere-langina mundulimili akumanga ungu-mane se pelemomo pilku rureponga talo rureponga talo ningu taltolemelemanga selu selu Pulu Yemonga ningu yu silimili. Aku selemele-na-kolo ungu-mane tondolo olandopa mare munduku kelko naa pilku selemele. ‘Yomboma apuruku yombo awilima liku tapondoko yombo kirima seko kinjiku naa seko, yomboma naa apuruku pali kondo kolko, Pulu Yemo ‘Sika.’ ningu kuru mondoko “Semolo.” nilimili mele sumbi siku seko molko, aku sangi.’ nimba pelemo ungu-manemando nikiru. Ungu-mane wema pilku selemelema munduku naa kelko ‘mare naa selemele’ nikiru akuma pali selemolánje peanga. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ono mongo kiri lieli yemane “⸤Mongo kiri lieli⸥ yomboma aulkamo lipu ora siemili.” nilimili yema, ono ⸤ungu-mane wema tondolo munduku pilku seko, ungu-mane tondoloma naa pilku selemele, aku selemele mele ungu-iku topo niembo:⸥ Kere-langi nongendo méle kanga lopalo molo lomu kere-langina pelemo kanokole ‘Naa namili.’ ningu wendo liku eltolemele, na-kolo kongi kao se kere-langina pelemo kinia naa kanoko we liku toko penge mundulimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ono ungu-manemanga puluma pilku mane silimili yema kinia Parisi yema kinia, ono mindili nongo paa molko kinjingí! Ono topele-mapele toli yema! Pellete kapomanga ultukundu kulumiye toko kondolemele-na-kolo akumanga sukundu kere-langi pelemoma onone tondolo munduku wa liku, onone onono nonowalene kolko onono konopu kimbu siku limili uluma. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ono mongo kiri lieli Parisi yema! Pellete kapomanga sukundu kulumiye tonge kinia ultukundu kepe kake sembá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ono ungu-manemanga puluma pilku mane silimili yema kinia Parisi yema kinia, ono mindili nongo paa molko kinjingí! Ono topele-mapele toli yema! ‘Yombo-óno-koleamo kanoko peanga piliangi.’ ningu pene kake sélimu ape kandolemele mele ono aku sílima mele molemele. Yombo-óno-koleama sika ultukundu peanga lemó kanolemele-na-kolo sukundu yombo kololimanga belema kinia méle puroli norupuluma kinia peke lepa pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ono aku siku mele molemele. Yombomane ononga kangikundu kanokole ‘Ono ye sumbi nilima’ konopu lemele-na-kolo ononga konopumanga sukundu kolo toli uluma kinia ulu-pulu kirima kinia mindi sengepea sepa pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ono ungu-manemanga puluma pilku mane silimili yema kinia Parisi yema kinia ono mindili nongo paa molko kinjingí! Ono topele-mapele toli yema! Pulu Yemone ungu-umbu tondolemoma pilku yando ningu sili yema kololemele kinia ononga óno selemele koleama seko wamoko, sumbi nili yombomanga óno-koleama au silimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aku sekole onone ninguli: “Olio olionga anda-kolepalima-kinia molemolánje onone Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema toko kondoringi kinia olionga anda-kolepali naa lipu tapondopo ono naa tolemolá.” nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aku nilimilimunga ‘Kanu yema toko kondoringi yombomane kalko liltingi yema molemolo.’ ningu onono liku ora silimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aku liemu manda ononga anda-kolepalimane pulu polko seko kinjeringi mele onone kamu sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“⸤Yomboma nongo kondoli⸥ kongi-ka-wambiyema! Ono kolo topa yomboma sepa kinjeli wambiyemonga waloma! Pulu Yemone onondo “Seko kinjeringimunga sepe-koleana paa.” nimbá kinia ono manda kowa pungí aulka se lembaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Akumunga, nane Pulu Yemone ungu-umbu tondombama pilku yomboma ningu singí yema kinia, pilipa kondoli pemba yema kinia, mane singí yema kinia, ono molemelena lipu mundukuru. Aku yemanga mare toko kondoko, mare ‘Kolangi.’ ningu unju-perana uku toko panjiku, mare ono maku toko Pulu Yemonga ungumu pilieli ulkamanga mengo pungu ka-pultane toko, koleamanga ‘tamili.’ ningu pulú siku akileko lombili pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aku sengemonga u-pulu-pulu ⸤Pulu Yemone mulu matolo serimu kinia⸥ kepe yandopa kiniá kepe yombo sumbi nilima toko kondoringimunga ulu-umbunama ono ⸤Juda yombomanga ye-awilima⸥-kinia pemba. ⸤Pulu Yemonga bokuna⸥ u-pulu-pulu sumbi nili ye Epele kinia, yandopa moloringi yombo sumbi nilima kinia, yandopa ⸤Pulu Yemonga bokumu pora nilimú akuna⸥ Berekia malo Sekaraya kinia toko kondoringi akumanga pali ulu-umbunama ono-kinia pemba. Sekaraya akumu Pulu Yemonga ulka suluminia lierimu ulkamo kinia Pulu Yemo popo toko mélema kaloringi polomo kinia awi-suku-singina toringi kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nane paa sika onondo nikiru: “U seko kinjeringi ulumanga pali ulu-umbunama i yombo kiniá molkomelema-kinia pemba.” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","⸤Aku nimbale Yesusini Jerusalleme moloringi yomboma yu kondo kolopa akumundu ungu se nimba nimbale:⸥ “O Jerusalleme ⸤yomboma⸥, Jerusalleme ⸤yomboma⸥, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema toko kondoko, yuni yomboma ‘liku tapondangi.’ nimba ono moloringina lipa mundorumu yema kouni toko kondoko selemele yomboma, kera-gulta anumumuni yunga waloma lipa yunga poumuni aki topa nokolemo mele nane wale awisili ono aku sipu nokolka-na-kolo onono “Mólo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akumunga piliame! ⸤Opa-touma ono tonge onge kinia Pulu Yemone kelepa ono naa nokopa naa lipa tapondombamonga⸥ opa-toumane ongo sika toko munduku ononga koleamo kinia ononga ulka-tembelemo kinia kamu toko kalongemonga ono ku penge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Akumunga nane ono ungu se pea nimbu sikiru: “Ono ⸤Jerusalleme yomboma⸥, onone nando “Pulu Ye Yawene lipa mundorumu-na okomo yemo imbi ola molopa, molopa kondopili.” ningí walemonga na kelko kanonge. U mólo.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kanu-kinia Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena ultu pumba aulkana pumbá purumu kinia yu lombili andolima ongo ulka-tembelemonga ulka lupa-lupa ⸤paa peanga gilieringima⸥ yu “Kanou.” ningu liku ora siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","⸤Aku seringi kinia⸥ yuni onondo nimbale: “Ya ⸤ulka-tembele peanga gilimú⸥ kanokomele mélema pali paa sika nimbu sikirumu: “⸤Pe walte ya kolea-awili Jerusalleme yomboma mindili nonge walemo wendo ombá kinia⸥ i ulka-tembelemo sikisikuli kouma pali toko mania mundungí.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kanu-kinia yu ma-pangi Unju Ollipi Kaliana ola pumba mania molorumuna we-yomboma naa molangi yunga lombili andoli yema ongo ono onono molkole yundu mangilku pilku ninguli: “Nuni nikinu mele sewale wendo ombáye? Pe nu nondoko oni sení walemo kinia kepe ma pora nimbá walemo kinia kepe wendo ombándo u nambolka uluri sembá kinia olio kanopole “Kiniá ombá sekemo.” nimbu pilimulúye? Ningu si.” ningu mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yuni onondo nimbale: “⸤Kanu uluma wendo ombámonga ungu mare⸥ yombomane ono kolo toko singí kene kanoko kondoko molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ye awisili ongo na molio mele yu-mele-mele kolo toko ninguli: “⸤Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasi⸥ akumu na.” ninguli aku siku kolo toko singí kene kanoko kondoko molangi. Yombo awisilini kanu yemanga unguma pilku liku “Sika nikimili.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Kolea marenga opa awili-seko senge mele pilku, ‘Opali talu opa awili i-sipa i-sipa wendo ombá.’ ningu we ningí kinia pilkuli mini-wale naa mundangi. Opa sengema kinia aku uluma Pulu Yemone ‘U wendo opili. Laye-kolte pe mele ya ma-koleamo pora nimbá.’ nimba, nimba panjerimumunga aku uluma sika wendo ombá-na-kolo aku-kinia mulu matolo u naa pora nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","⸤Mulu ma pora nimbá walemo u wendo naa opili⸥ yombo talape awili se kinia talape awili se kinia opa seko, ye nokoli kingi marenga talapema kinia marenga talapema kinia opa senge. Ya ma-kolea senga senga gele lepa, ma jimi-jimi sepa, aku sipa sembá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ambo sene bolango kokele kanopa limbando u bulu mini topa mindili nolemo mele, mulu ma pora nimbá walemo kokele wendo ombándo umbuna lupa-lupa aku sipama u wendo ombá.” ⸤nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kanu uluma wendo ombá walemanga ‘⸤Na lombili andoli yomboma⸥ mindili nongo, kolangi.’ ningu ⸤ono mare⸥ kote seko ka singí. Nanga yomboma molko nanga unguma andoko ningu singímunga koleamanga pali yombomane ono-kinia mumindili kolko konopu kiri panjingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","⸤Kanu umbunama wendo ombá⸥ walemanga na ‘Sika.’ ningu kuru mondonge yombo awisili kuru mondonge mele munduku kelko anju yando onono konopu kiri panjiku, ‘Karasinga yomboma molemelemonga mindili nangi.’ ningu ononga opa-touma liku singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","⸤Kanu walemanga⸥ Pulu Yemone ungu-umbu tondolemoma naa pilku we kolo toko yando ningu singí yombo awisili wendo ongela. Aku senge kinia we-yombo awisilini ‘Sika nikimili.’ ningu ononga unguma pilku lingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ulu paa kiri awisili olandopa olandopa wendo ombámonga nanga yombomane ⸤anju yando⸥ konopu mondonge mele ⸤kinia, na konopu mondonge mele kinia,⸥ munduku kelengela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aku-sipa na-kolo nanga ungumu munduku naa kelko mulu ma pora naa nipili tondolo munduku molonge yomboma ⸤Pulu Yemone⸥ lipa tapondopa ‘Mindili nonge koleana naa pungu pea molopo kondopo mindi pamili.’ nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pulu Yemone ye nokoli kingimu molopa yomboma nokombamonga semane peangamo ‘Yomboma pali piliangi.’ ningu koleamanga pali andoko ningu singí kinia pe mulu ma pora nimbá walemo kamu wendo ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","⸤⸤Na i bokumu tokoro yemone ono boku kanokomele yombomando ungu se niembo:⸥ ‘⸤Yesusini nirimu⸥ ungumu inia anjukundu molemo akumu ono imbi kanokomele yombomane ungu-pulumu paa pilku kondangi.’ nimbu nikiru: ⸤Yesusini nimbale:⸥⸥ “Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Denielene bokuna imbi topa nimba sirimu mele yombo sepa pipili kondoli mele paa kirimu ⸤ulka-tembelena sukundu⸥ Pulu Yemonga ulka-suluminia kake selina gilimbamonga kolea akumu paa kalaro molomba mele nirimu, bokuna molemo. Aku mélemo akuna wendo omba gilimba kanokole ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","⸤ ‘Umbuna awilima wendo ombá sekemo.’ ningu pilku⸥ kolea Judia poropinji koleamanga molonge yomboma ⸤ononga koleama munduku kelko⸥ ma-pangi lembamanga kowa pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yombo se ulka imuna ola molopili ⸤aku sipa wendo ombá kinia kanopale⸥ kowa pumbándo mania omba ‘Mélema lipu membo pambo.’ nimba ulkana sukundu naa pupili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yombo se kaliana molopale ⸤ ‘Kowa pambo.’ nimba⸥ kelepa ulkando pumba yunga ali-wale sulumu naa lipili. ⸤Sumbi siku kowa mindi pangi.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aku sipa wendo ombá walemonga ambo bolango mondongema kinia, ambo bolango ame singíma kinia, ⸤ono manda lisiku kowa naa pungímunga⸥ ono-kinia paa umbuna wendo ombámonga ono kondo sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Pulu Yemo mawa sekole, ‘Ali selemo olimanga kinia ⸤koro molopo manda naa andomolo⸥ wale Sambatemanga kinia manda kowa naa pumulú kene kanu walemanga kanu umbunama wendo naa opili.’ nieyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kanu walemanga umbuna paa awilima wendo ombá, u mulu matolo pulu polopa serimu kinia kepe, yandopa kiniá kepe umbuna aku sipa se wendo naa orumu. Pe kepe aku sipa umbuna awilima naa wendo ombála. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","⸤Kanu umbunama wendo ombá kinia Pulu Yemone⸥ ‘Nondopa pora nipili.’ nimba u naa nimba panjilkanje yomboma pali kololemolá. Aku-sipa na-kolo Pulu Yemone ‘Nanga yomboma molangi.’ nimba taltorumu yomboma ‘Pali naa kolangi.’ nimba ‘Umbuna wale akuma nondopa pora nipili.’ nimba, nimba panjerimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kanu umbunama omba pemba walemanga yombo marene ninguli: “Kanaa! Pulu Yemone “Olio nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu ya omba molemo.” ningí molo “Nena omba molemo.” ningí kinia ononga unguma naa pilku, ‘Sika nikimili.’ ningu kuru naa mondangi! ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ye mare ongo kolo toko ninguli: “Pulu Yemone nimba taltorumu ye nokoli Karasimu na.” ningí, molo kolo tokole “Pulu Yemone ungu-umbu tondomuma pilipuli ombo nimbu sikimulu.” ningí. ‘Yomboma pali, Pulu Yemone ‘Nanga yomboma molangi.’ nimba taltorumu yombomane kepe peke tondopo, nikimulu mele ‘Sika.’ ningu kuru mondangi!’ ningu Pulu Yemone mindi ulu-tondolo manda selemoma mele manda manjiku ulu paa tondolo awisili senge. Aku-sipa na-kolo Pulu Yemonga yomboma aku siku kondi tonge kinia ononga unguma naa pilku, siye kolonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pe ulu akuma wendo ombá mele ‘Ono u piliangi.’ nimbu ya nimbu sikiru mele piliaa. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“⸤Wendo ombá mele nimbu sikiru, pilkimili⸥ kene pe yombo sene nimbale: “⸤Ye nokoli Karasimu⸥ ne yombo naa peli kolea ku lielina molemo.” nimbá kinia ‘Kanamili.’ ningu akuna naa payo. Molo “I ulkamonga suluminiana molemo.” níngi liemu onone ‘Sika nikimili.’ ningu kuru naa mondangi! Muluna kariapá selemo kinia ena mundi wendo olemo koleana kepe ena pulimú koleana kepe kariapá selemo waltikele kanolemele, aku sipa Mania Omba Mana-Ye Au Lierimu Yemo ⸤kelepa⸥ mania ombá kinia koleamanga pali yombomane yu waltikele kanonge aku kene “Ya molemo ongo kanaa.” ningí kinia, molo “Ne molemo pungu kano-paa.” ningí kinia, ononga unguma naa piliangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Méle kololi se lemó koleana kerama ongo maku tolemele kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kanu walemanga aku mindili nonge nikiru uluma wendo ombá kinia pe sumbi sipa ⸤ulu lupa lupa mare wendo ombála. Akuma i-sipa:⸥ ‘Kolea tangombando ena pa selemo mele naa sepa, simbulu topa, oli ipulieli pa selemo mele naa sepa, kombokandima muluna mania omba, muluna gilimú méle tondoloma lope-lope sepa anju yando pumba, aku sipa ulu lupa lupama wendo ombá.’ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kanu uluma wendo ombá kinia Mania Omba Mana-Ye Au Lierimu Yemo kamu ombá sembá mele lipa ora simba mélse muluna gilimba kinia ⸤kanokole⸥ koleamanga pali yombomane paa kola awili-seko senge. Pe kanoko molangi Mania Omba Mana-Ye Au Lierimu Yemo tondolo púlimu kinia, pa awili-sepa sélimu kinia, kupa senga sukundu molopa kamu mania ombá yombomane kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kanu-kinia bikollo ungu paa tondolo sepa nipili yuni yunga angelloma lipa mundumba kinia ono winju mendo anju yando mulu ⸤ma koleamanga⸥ pali pungu Pulu Yemone ‘Nanga yomboma molangi.’ nimba u nimba taltorumu yomboma sukundu sukundu lingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Unju pikimuni selemo aku sipa ungu-iku mele pelemo kene pilkuli ungu-pulumu piliaa. Unju piki kolamanga kirikiri sepa gomo tolemo kinia kanokole ‘Kiniá ena sembá walemo wendo ombá sekemo lémo.’ ningu pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aku sipala, i ulu “Wendo ombá.” nikiruma sika wendo ombá kinia kanokole ningímuni ‘Yu paa sika nondopa ombá sekemo. Yu paa kamu okomo.’ ningu pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nane onondo paa sika nimbu sikirumu: “Kiniá molemele yomboma u naa kolangi i “Wendo ombá.” nikiru uluma pali wendo ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mulú matolo kinia pora nimbá-na-kolo nanga ungu niliuma paa pora naa nimbá. ⸤Niliu mele pali paa sika wendo ombá.⸥” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“⸤Mania Omba Mana-Ye Au Lierimu Yemo paa sika ombá⸥-na-kolo yu ombá walemo naa pilielemolo. Ipulieli ombáne, tangoli ombáne naa pilielemolo. Mulu-koleana angelloma kepe naa pilielemelela. Pulu Yemonga Malo kepe naala pilielemo. Tata yuyu mindi ⸤aku walemo⸥ pilipa molemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“U ye Noa molopili yombomane seringi mele Mania Omba Mana-Ye Au Lierimu Yemo ombá sembá kinia yombomane aku siku sengela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","⸤Ma-koleamanga pali⸥ no u naa topili yomboma kere-langi nongo, yema ambo liku, amboma ye pungu, aku uluma mindi seko mololko puringi. Noa nona andoli sipi ulkamonga sukundu purumu kinia kepe ono aku uluma mindi we seko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ono ⸤Noanga ungumu⸥ naa pilku aku siku uluma mindi seko molangi no topa ⸤koleama pali none aki topa⸥ yomboma pali topa kondorumu. Pe Mania Omba Mana-Ye Au Lierimu Yemo kelepa ombá walemonga u Noa molopili seko moloringi nikiru mele aku siku seko molongela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yu ombá walemonga ye talo kondena unju toko gilingili kinia ⸤Pulu Yemonga angello sene omba⸥ ye se we molopili mundupa kelepa se lipa memba pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ambo talo kere-langi kalongele seko molongele kinia ⸤angello se omba⸥ ambo se we molopili mundupa kelepa se lipa memba pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Akumunga ononga Ye-Awilimu ombá walemo paa naa pilielemele kene ‘Yu ombá.’ ningu kanoko molaa.” ⸤nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Ono i ungumu konopu kimbu siku piliayo: Ulka pulu ye sene ipulieli wa noli ye sene yunga ulkamo omba bultupa mélema wa limba mele pilkanje ‘Wa noli yemo ombá.’ nimba nokopa molka kinia wa noli yemo yu manda sukundu naa olka. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aku siku ono nokoko molaa. Mania Omba Mana-Ye Au Lierimu Yemo ombá enamo naa pilielemele kene ‘Yu sika ombá.’ ningu aku siku nokoko molangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“⸤Akumunga ungu se niembo:⸥ Kongono sendeli kendemande-ye nawene kongono sepa kondondolemo kinia kanopale yunga ye awilimuni ‘Yuni kongono siliuma sumbi sipa selemomonga yu kongono simbú kinia sepa kondombamonga na kelepo konopu kimbu sipu naa molombo.’ nilimúye? Kendemande-ye se aku sipa mele sepa kondopa molemomo kanopale yunga ye awilimuni yu nimba taltopa yundu nimbale: “Kongono sendeli kendemande-yomboma pali nokondoko ononga kere-langi nongema ena wa siliumunga ono nangi moke seko sieni, nokondoko molou.” nimba ⸤yu senga pulimú⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pe ye awilimuni kongono simumu kanu kongono sendeli kendemande-yemone mimi sipa sendepa molopili ye awilimu kelepa omu liemu kendemande-yemo yu konopu sipili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nane onondo paa sika nimbu sikirumu: “Kanu ye awilimuni kanu kendemande-yemondo “Nanga méle taltolioma pali nuni nokondou.” nimbá.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Aku-sipa na-kolo ⸤ye awilimuni kanu kendemande-yemondo nimbale: “Nanga kendemande-yomboma pali nokondou.” nimba senga pulimú kinia⸥ kanu kendemande-yemone sepa kinjipa “Nanga ye-awilimu welea naa ombá.” konopu lepale yuni nokondolemo kendemande-yomboma kopene topa, no nongo amu toli yema kinia kere-langi nomba no tondoloma nombale, aku sipa sepa kinjipa molomu liemu ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","walte kanu kendemande-yemo ‘Yunga ye awilimu ombá.’ nimba naa pilipa ⸤kongono sirimu mele naa sepa⸥ walu sepa kinjipa molomba kinia ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Omba ⸤kanu yemo sepa molomba mele kanopale⸥ yu paa kopene topa kondopale, kolo tolemele yombo topele-mapele toli yomboma ⸤kolea-kiri⸥ molemelena ‘Pupili.’ nimba lipa mundumba. Kanu koleana yomboma paa mindili nongo kola seko pereko molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","⸤Aku nimbale nirimumuni, Yesusini yuyu kelepa ombá mele ungu mare pea nimba nimbale:⸥ “⸤Mania Omba Mana-Ye Au Lierimu Yemo kelepa wale talo sipa mana mania ombá kinia⸥ Pulu Yemo ye nokoli kingimu molopa yomboma nokomba akumu i-sipa mele: “Ye se ambo limba uluma yomboma pea sengendo kanu yomboma maku toko moloringina yemo ombá serimu kinia pilkuli ‘Ipulieli ombá.’ ningu ambo-wenepo rureponga talo ononga sepe-llamema liku “Yu aulkana limulú.” ningu puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kanu ambo-wenepomanga se-pakara konopu naa pepili aroma toko moloringi; se-pakara pilipa kondoli pepili moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Konopu naa pepili aroma toko moloringi ambo-wenepomane ononga sepe-llamema mengo puringi-na-kolo llame karasene pea naa mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aku-na-kolo pilipa kondoli pepili moloringimane karasene kinia ononga sepe-llamema kinia mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ambo limba yemo welea naa orumu-kulu ambo-wenepoma pali uru orumu-na uru peringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kanu-kinia awi-amburumi ungu se wendo omba nimbale: “Ambo limba yemo okomo kanayo! Aulkana liengi waa!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kanu-kinia ambo-wenepoma ola gilku sepe-llame ‘Awili-sepa nopili.’ ningu seko mimi seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Konopu naa pepili moloringi ambo-wenepomane pilipa kondoli pepili moloringi ambo-wenepomando ninguli: “Olionga sepe-llamema kumbulkumu kene ononga karasene mare olio liku munduku siee.” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","pilipa kondoli pepili moloringi ambo-wenepomane pundu toko ninguli: “Karasene ono kinia olio kinia manda naa sembanje. Ono sitoana pungu ononga topo toko li-paa.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanu-kinia sitoana topo toko lingíndu puringi kinia ambo limba yemo orumu. Kanu-kinia ye ambo limbamonga kere-langi akuna nongendo maku toringi yomboma, pilipa kondoli pepili moloringi wenepoma pea ulkana suku puringi. Kanu-kinia ulka kuna toko ingi siku kere-langi nongo moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pe kere-langi nongo molangi ambo-wenepo sitoana puringima ongo ninguli: “Ye-Awilimu, Ye-Awilimu, olionga kuna ongo lindei.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aku-sipa na-kolo yuni onondo pundu topa nimbale: “Nane onondo paa sika nimbu sikirumu: Na ononga imbima naa pilkiru. ⸤Ultukundu molemelema manda sukundu naa onge.⸥” nirimu.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","⸤Aku nimbale yuni kelepa nimbale:⸥ “Aku sipa sembá kene Mania Omba Mana-Ye Au Lierimu Yemo kelepa ombá walemo kepe ono naa pilku, orili-u ombáne tangoli ombáne, ipulieli ombáne, naa pilielemele kene yu ombá nokoko kondoko molaa.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","⸤Nimbale Yesusini ungu-iku se pea topa nimbale:⸥ “⸤Pulu Yemone ye nokoli kingimu molopa yomboma nokolemo akumu⸥ i-sipa melela: “Ye se kolea senga pumba molombando yunga kendemande-yema “Waa.” nimba yunga mélema “Nokondaa.” nimbale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","onone kongono selemele mele pilipa apurupa yunga mélema ono moke sepale ye se kou paip tausini kina mele sipa, se kou tu tausini kina mele sipa, se wane tausini kina mele sirimu. Aku sepale yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ye paip tausini kina liltimumu sumbi sipa pumba kanu koumuni bisinisi sepale nirimumuni, kou paip tausini kina olandopa pumba liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aku sipala ye tu tausini kina liltimumu olandopa tu tausini kina pumba liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aku-sipa na-kolo wane tausini kina liltimumu pumba ‘Lopi sambo.’ nimba yuni mana muru akupa yunga nokoli yemonga koumu lowaya serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kanu-kinia wale awisili omba purumu kinia kanu kendemande-yemanga nokoli yemo omba onondo nimbale: “Kouma ono seringi mele kanambo liku ora siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kanu-kinia paip tausini kina liltimu yemone paip tausini kina olandopa pumba liltimumu memba omba nimbale: “Ye-Awilimu, nuni na paip tausini kina sirinu kanumu. Nane paip tausini kina olandopa pumbu liltindumu i ambolkoro kanou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nokoli yemone yundu nimbale: “Kendemande-ye peangamo, paa papu serinu. Kongono kanga-kolte mele sirindumu nuni seko kondorunumunga “Nuni nanga méle awisili nokondou.” nimbú kene nu ongo na kinia pea kopu sepo konopu sipu molambili ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ye tu tausini kina liltimu yemo yu kepe omba nimbale: “Ye-Awilimu, nuni na tu tausini kina sirinu kanumu. Nane tu tausini kina olandopa pumbu liltindumu i ambolkoro kanou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yunga nokólimuni yundu nimbale: “Kendemande-ye peangamo, paa papu serinu. Kongono kanga-kolte mele sirindumu nuni seko kondorunumunga nanga méle awisili “Nu nokondou.” nimbú kene nu ongo na kinia pea kopu sepo konopu sipu molambili ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kanu-kinia wane tausini kina liltimu yemo kepe omba nimbale: “Ye-Awilimu, nane pilipuli, ‘Nu bisinisi tondolo munduku seko ‘Kou-mone lipu taltombomonga yomboma mindili nongi liemu mandala.’ ningu ⸤kendemande-yomboma ‘Kongono kála seko sangi.’ ningu siku, ono méle koltalo siku mélema pali nunu mindi lilinu yemo;⸥ kalia yombomane panjindilimili kinia nu nunu kere-langi mélema we akuku liku; rasi-witimunga kilu kinia mongotolo yombo wemane kilu toko apurundulimili kinia nu nunu rasi-witi mongo we lilinu mele.’ na pilierindu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","⸤Aku siku selenomonga⸥ nane nu pipili kolopole na pumbu nunga kou na sirinumu mana lowaya serindu. Kanu koumu i ambolkoro kanuyo. I nunga koumu nunu sikiru li.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aku nirimu kinia pilipale nokoli yemone yundu pundu topa nimbale: “Seko kinjeli kendemande-ye kirimu, nuni pilkuli, ‘Kalia yombomane panjindilimili akuna na nanu kere-langi mélema we akupu lipu; rasi-witimunga kilu kinia mongotolo yombo lupamane apurundulimili kinia na nanu rasi-witi we liu.’ ningu pilierinu lémo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aku siku pilkuli nanga kou-monemo kou-benge ulkana taltolenanje papu. Aku selenanje na ombo nanga koumu wendo lipuli kou kanga-kolte ola panjiku silimolá lilkala.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","⸤Kanu kendemande-yemondo aku sipa nimba pora sipale yuni we-kendemande-yemando nimbale:⸥ “I yemo sepa kinjerimu kene yunga koumu wendo likuli tene tausini kina ambolkomo yemo siee.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Mélema taltolemo yombomo nane mare pea simbú, yu paa awisili taltomba. Aku-sipa na-kolo mélema naa taltolemo yombomo yu taltolemoma kepe wendo limbu kene aku siku sekole, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","kendemande-ye kirimu simbulu tolina liku paka toko pena mundayo. Akuna yomboma paa mindili nongole kola seko pereko molonge.” nirimu.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","⸤Aku nimbale yu pe kelepa omba sembá mele nimba nimbale:⸥ “Mania Omba Mana-Ye Au Lierimu Yemo yunga tondolo pa sélimu kinia ombale nimbámone, yunga mulu-koleana angelloma kinia pali onge kinia tondolo pa selina suku ye nokoli kingi polomo lembana yu molomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yunga kumbikerena ma-koleana yomboma pali liku maku tondonge. Kanu-kinia kongi tapu seli ye sene yunga kongima apurupale kongi sipisipima lupa lipa mundupa, kongi memema lupa lipa mundulimú mele aku sipa Ye Nokoli Kingimuni yombo maku toko molongema apurupale nimbámone, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","yombo kongi sipisipi mele molongema yunga ki-lomekondo lipa mundupa, kongi memema mele molongema yunga ki-tarokondo lipa mundumba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Aku sepale, yuni yunga ki-lomekondo molonge yombomando nimbale: “Na gelene kolorundu kinia onone na kere-langi siringi. Na no nonowalene kolorundu kinia onone no kolko siringi. Na aulka ponenge orundu kinia onone na “Pea molamili ou.” niringi. Na pulua wambale naa panjipu we-we andorundu kinia mulu-maminia se siringi. Na kuru torumu kinia nokoringi. Na ka-ulkana perindu kinia ongo kanoringi. Tatane ‘Ono molko kondangi.’ nirimu-na konopu peanga pepili molemele yomboma, onone ulu akuma na-kinia seringi kene, ya ongo, u mulu matolo naa liepili Tatane yu nokomba koleana ono pea ‘Kopu sepo molomolo.’ nimba, nimba panjerimu koleana sukundu waa.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aku sipa nimbá kinia pilkuli sumbi nili yombomane pundu toko yundu ninguli: “Ye-Awilimu, sewale nu gelene kolorunu kinia kanopole nu kere-langi sirimuluye? Sewale nu no nonowalene kolorunu kinia kanopole nu no kolopo sirimuluye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nu ye-ponengemo sena molorunu kinia kanopole “Ulka sukundu molamili ou.” nirimuluye? Mulu-maminia naa pakoko we-we andorunu kinia kepe nu sena kanopole mulu-maminia sirimuluye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nu kuru torumu kinia kepe, ka-ulkana perinu kinia kepe, sewale ombo kanorumuluye?” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","⸤Aku siku ningí kinia⸥ Ye Nokoli Kingimuni onondo pundu topa nimbale: “Nane onondo paa sika nimbu sikirumu: “I nikiru mele i nanga genupili imbi naa mololi se kepe liku tapondoringi akumu na liku tapondoringi.” nikiru.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Kanu-kinia yunga ki-tarokondo molonge yombomando nimbale: “Pulu Yemone ‘Ono molko kinjangi!’ nilimú yomboma, na gelene kolorundu kinia onone na kere-langi se naa siringi. Na no nonowalene kolorundu kinia onone na ‘no nambo.’ ningu kolko naa siringi. Na aulka ponengemo orundu kinia na “Pea molamili ou.” naa niringi. Na mulu-maminia se naa pakopo we-we andorundu kinia na mulu-maminia se naa siringi. Na kuru torumu kinia na naa nokoringi. Na ka-ulkana perindu kinia na naa ongo kanoringi. ⸤Onone na aku siku naa liku tapondoringi⸥ kene ono nanga kumbikerena naa ongo anju pungu, ⸤kurumanga nokoli⸥ depelemo kinia yunga angelloma kinia ononga sepe we nomba pepa mindi pulimú pumbá sepe kalondorundu akuna anju paa.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aku sipa nimbá kinia pilkuli kanu yombomane kepe pundu toko ninguli: “Ye-Awilimu, nu gelene kolorunu kinia kepe, no nonowalene kolorunu kinia kepe, nu ponenge leko orunu kinia kepe, we-we andorunu kinia kepe, kuru torumu kinia kepe, ka-ulkana perinu kinia kepe, olione nu aku siku molorunu kinia sewale kanopole nu naa lipu tapondorumuluye?” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","⸤Aku siku ningí kinia⸥ yuni onondo pundu topa nimbale: “Nane onondo paa sika nimbu sikirumu: “Onone i nanga genupili yombomanga imbi naa mololi se naa liku tapondoringi aku kinia na naala liku tapondoringi.” nikiru.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kanu-kinia kanu ⸤seko kinjilimili⸥ yomboma pungu kamu alieli-alieli molko kinjiku mindi puli koleana pungí, aku-na-kolo sumbi nili yomboma pungu kamu alieli-alieli molko kondoko mindi puli koleana pungí.” ⸤nimba Yesusini⸥ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesusini ⸤yu pe yando ombá mele⸥ ungu akuma nimba pora sipale yunga lombili andolimando nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ono pilkimili, wale talo we omba pumbá kinia Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu Mele Pilielemolo Walemo wendo ombá. Aku walemo wendo ombá kinia Mania Omba Mana-Ye Au Lierimu Yemo “Kolopili unju-perana ola uku toko panjangi.” ningu liku anju singí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesusini aku sipa nirimu walemonga Pulu Yemo popo tondoringi ye awilima kinia, Juda yomboma nokoringi tapu-yema kinia, ono Pulu Yemo popo tondoringi ye awili olandopa ‘Kayapasi’ nili ye akumunga ulkana pungu liku maku tokole niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesusi kiyongo ningu ka siku tongendo langi ningu moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ningu molko ninguli: “⸤Nondopo tamili,⸥ aku-na-kolo Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu Mele Pilielemolo Walemanga ⸤ ‘uluma sepo molamili.’ ningu⸥ yombo awisili ya Jerusalleme ongo maku toko molongemonga yu iseli-u topo kondomolo kinia onone olio-kinia mumindili kolko opa senge kene iseli-u naa topo, keleamili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kolea-kanga Betani ye se u kuru laká nombale kelierimu ye se, imbi leko “Ye Kuru Laká Noli Saimono” niringi kanumunga ulkana Yesusi molopili ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ambo se wambola mingi paa peanga se yu molorumuna memba orumu. Kanu wambola paa muna tolimunga kou-mone paa awili sepa purumu. Akumu memba ombale Yesusi kere-langi noli polo molorumuna memba omba ⸤ ‘Yu sepo kondambo.’ nimba⸥ pengena ondondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yuni aku serimu kinia kanokole Yesusi lombili andolima konopu kiri panjiku ninguli: “Aku wambolamo nambi semu-na we seko kinjikinuye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aku wambolamo kou-mone limolánje kou awisili lipuli yombo koropama moke sepo silimolá.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","⸤Onone ambomondo⸥ aku siku ⸤niringi⸥ pilipa Yesusini onondo nimbale: “I ambomo-kinia nambi semu-na ungu awisili nikimiliye? Yuni na-kinia ungu peanga se semu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yombo koropama ono-kinia alieli molonge-na-kolo na ono-kinia alieli naa molombo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na kolombo kinia óno sengemonga yuni i wambola muna tolimu nanga kangina ondondomu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nane onondo paa sika nimbu sikirumu: “Ma-koleamanga pali i ⸤nanga⸥ semane peangamo andoko toko singí kinia i ambomone kiniá semu semanemo kepe ‘Yombomane pilkuli ‘Yuni sepa kondorumu.’ ningu piliangi.’ ninguli aku semanemo toko singíla.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kanu walemonga Yesusi yu lombili andoli ye rurepo akumanga ye se, yunga imbimu Judasi Isikeriote, Pulu Yemo popo tondoringi ye awilima moloringina pumba, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ono mangilipa pilipa nimbale: “Nane ono Yesusi ambolko ka singí aulka se lipu ora sindu liemu onone na ⸤kou⸥ nambi seko singíye?” nirimu. ⸤Aku nirimu kinia pilkuli⸥ onone kou-sillipa mongo wane-paono-tene kambu toko yu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kanu-kinia yu kelepa yando ombale Yesusi lipa ono simba aulka se koropa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pellawa Akoli Mele Isimu Naa Munduku Pellawa We Kalko Noringi Koromonga pulu-pulu walemo wendo orumu kinia ⸤Juda yombomane Pulu Yemone u ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingindu kongi sipisipi walo se toko nonge mele pilkuli niringimuni,⸥ Yesusi lombili andoli yema yu molorumuna ongo mangilku pilku ninguli: “Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walo se kiniá nonimu kolea sena pumbu sepo wamo-pamili konopu lekenoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","⸤Aku siku ningu mangilieringi kinia⸥ Yesusini ⸤ye se molomba mele ono lipa ora sipa⸥ nimbale: “Ne kolea-awili ⸤Jerusalleme⸥ sukundu punguli, ne ye akumu molombana pungu yundu i-siku niengi: “Ungu Mane Síli Yemone i-sipa nimu: “Na-kinia ulu se wendo ombá walemo nondopa wendo ombá sekemo. Nunga ulkana sukundu na kinia na lombili andolima kinia olio Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu mele pilimulú kongi sipisipi walomo nomolo.” nimu.” niengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kanu-kinia lombili andolima pungu Yesusini nirimu mele se-punguli niringimuni, Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingí kongi sipisipi walo nongemo seko wamoko taltoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kanu-kinia, ipupini ena pumba kala torumu kinia Yesusi kinia lombili andoli ye rurepo kinia ⸤ongo⸥ kere-langi noli polona moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kere-langi nongo moloringi kinia Yesusini nimbale: “Nane onondo paa sika nimbu sikiru: “Ononga ye sene na lipa nanga opa-touma simba.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","⸤Aku nirimu kinia pilkuli⸥ ononga konopumanga umbuna awili-sepa serimu pilkuli yu-mele-mele mangilku ninguli: “Ye-Awilimu, nando nikinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesusini pundu topa nimbale: “⸤Ono nanga ye rureponga⸥ ye se na-kinia kere-langima polo awi-suku-singina ola lemó se waltikele lipu nombolo yemone na lipa, opa-touma anju simba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kiniá Mania Omba Mana-Ye Au Lierimu Yemo-kinia senge mele koronga-u ningu panjeringi semanemo ⸤Pulu Yemonga⸥ bokuna molemo mele sika opa-toumane senge, aku-na-kolo yu lipa opa-touma simba yemo mindili nomba paa molopa kinjimba. Yu molopa kinjimbamonga ye akumu anumuni naa melkanje papu. Yu mindili naa nolka.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yesusini aku sipa nirimu pilipale Judasi, yu lipa anju simba serimu yemo, yuni yundu nimbale: “Rapai, nikinu yemo na mólonje?” nimba mangilierimu kinia Yesusini yundu “Sika, nu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ono kere-langi nongo molangi Yesusini berete se lipa Pulu Yemo-kinia “Ange.” nimba ambolopa peke lepa yu lombili andolima sipa nimbale: “Imu nanga kangimu ono liku nangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pe no-waene-kapo se lipale Pulu Yemo-kinia “Ange.” nimba ono sipa nimbale: “⸤I no-waenemo⸥ ono pali liku nangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","I ⸤no-waene⸥ sikirumu nanga mememo. Pulu Yemone ⸤yu kinia yunga yomboma kinia molonge mele⸥ ungu se nimba panjipa mi lierimu kanu ungumu ‘Kamu wendo omba pepili.’ nimbu ‘Yombo awisilinga ulu-pulu-kirima kamu mania pupili. Pulu Yemone kelepa naa kanopa, siye kolopili.’ nimbu nanga mememo ondondopole ⸤kolombo⸥ aku mememo imu. Akumu ono pali liku nangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nane onondo i-sipu nimbu sikirumu: “Iseli-u na no-waene kelepo paa naa nombó. Pe mindi, Pulu Yemo ye nokoli kingimu molopa nokolemo koleana ono-kinia no-waene kondemo kelepo nombó.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","⸤Kere-langi nongo pora sikuli⸥ ono Pulu Yemonga konane se ninguli, pena pungu Ma-Pangi Unju Ollipi Kaliana ola puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kanu-kinia Yesusini yu lombili andolimando nimbale: “Paa kiniá ipulieli ⸤opa-toumane⸥ na-kinia senge ulumu kanokole onone pali na munduku kelenge. ⸤Aku siku senge mele⸥ Pulu Yemone u nirimu yunga bokuna molemo kanumu. Pulu Yemone ⸤ungu-iku se topa⸥ nimbale: “ “Kongi sipisipi tapu-yemo tangi.” nimbú, yu tonge kinia sipisipima bulu-balu ningí.” nirimu, ⸤aku mele kiniá wendo ombá⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","⸤Iseli-u na toko kondonge kinia ono sika bulu-balu ningí⸥-na-kolo na lomboropo ola molopole nimbúmuni, na kumbi lepo kolea Gallillindu pumbú, ⸤ono pe akileko akuna onge kinia kelepo pea molomolo⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","⸤Yesusini aku sipa nirimu kinia pilipa⸥ Pitane nimbale: “Nu-kinia ulu se wendo ombámonga kanokole onone pali ‘Nu sika.’ ningu kuru mondolemele mele mania pumbá kinia nu aku siku munduku keliengi liemu nane nu paa mundupu naa kelembo, paa mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesusini pundu topa nimbale: “Nane nu paa sika nimbu sikirumu: “Paa kiniá ipulieli, kera gulta u ko naa topili nuni ⸤pipili kolkole⸥ wale yopoko nando kolo toko “Yu nawe? Na naa kanolio.” nini.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aku-na-kolo Pitane yundu nimbale: “Na nu-kinia kopu selembolomonga olto pea “Topo kondomolo.” níngi liemu kepe nu “Naa kanolio.” paa naa nimbú.” nirimu. Lombili andoli ye wemane pali “ “Nu naa kanolemolo.” paa naa nimulú.” niringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kanu-kinia Yesusi kinia yu lombili andoli yema kinia kolea ‘Gesemani’ nilina puringi. ⸤Akuna puringi⸥ kinia yuni onondo nimbale: “Na anju pumbu Pulu Yemo kinia ungu ni-pukuru kene ono ya molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aku nimbale Pita kinia Seperi malo ⸤Jemisi kinia Jonotolo⸥ pea lipa memba pumbale ⸤ ‘Na seko kinjingí ulumu paa nondopa wendo ombá sekemo.’ nimba pilipale⸥ yu yuyu kondo kolopa konopu kiri panjipa kameléna mindili sepili molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yuni onondo nimbale: “Nanga konopuna umbuna paa awili se sepomo kene na kolombo none sekemo. Ono uru naa peko na-kinia pea kopu sepo nokopo kondopo molamili, ono ya we mimi siku kanoko molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","⸤Aku nimbale⸥ yu yuyu kanga-kolte anju pumba komorongo langopa tamalu pepa Pulu Yemo-kinia ungu nimba mawa sepa nimbale: “Nanga Tata, na nondopo ⸤mindili noli⸥ no-mingina no nombómo ‘Naa nambo.’ nini aulka se lemó liemu paa papu na-kolo ‘Nane sepole nanu konopu simbú.’ konopu lekero mele naa sambo. Nuni kanoko peanga piliení ulumu mindi sambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aku nimbale kelepa yunga lombili andoli ye yopoko moloringina yando omba ono uru peringi kanopa Pitando nimbale: “Ono uru naa peko na-kinia ena kanga-kolte manda we kanoko kondoko naa molemoláye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","‘⸤Kurumanga nokoli Setenene⸥ olio kondi tomba kinia sepo kinjimulú kene.’ ninguli ⸤uru naa peko⸥ Pulu Yemo-kinia ungu ningu kanoko kondoko molaa. Sika ‘sepo kondamili.’ nimbu konopumane pilielemolo-na-kolo semolondo kangimu siye sepa tondolo naa pulimú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aku sipa nimbale yu kelepa anju pumba u Pulu Yemo-kinia ungu nimba mawa serimu mele kelepa nimbale: “Nanga Tata, na ‘⸤Mindili noli⸥ no-mingina nomo nani.’ nirinu nomo naa nombó kinia we pemba liemu nuni ‘Wendo opili.’ konopu leno mele na-kinia wendo opili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kelepa yando orumu kinia ono uru orumu-kulu kelko uru peringi kanopale ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","yu kelepa wale yopoko-sipa anju pumba Pulu Yemo-kinia ungu u nimba mawa serimu mele kelepala nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kelepa yando omba lombili andolimando nimbale: “Nambi semu-na we uru peko mulu pilku molemeleye? Kaname! Yemone Mania Omba Mana-Ye Au Lierimu Yemo ⸤toko kondonge⸥ ulu-pulu-kiri selemele yema lipa simba enamo wendo ombá sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ola gilku pamili wame! Na lipa anju simba yemo okomo kanaa!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesusini ⸤kolea Gesemani yu lombili andolimando⸥ aku nimba molopili yu lombili andoli rurepo akumanga ye Judasi orumu. Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga tapu-yema kinia, kanu yemane liku mundoringi ye awisili, yombo toli lu-pultama kinia kopema kinia mengo, Judasi kinia oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","U Yesusi molorumuna naa wangi Yesusi Juda ye awilima lipa simba nimba panjerimu ye ⸤Judasini⸥ ono Yesusi yu ipulieli manda kanonge mele nimba sipa nimbale: “Nane ye se kanopole kangulumbu akumu Yesusi. Yu ambolko ka siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","⸤Aku yema⸥ oringi kinia ⸤Judasi⸥ yu Yesusi molorumuna sumbi sipa ombale “Rapai, nu akuna gilienu lémo.” nimba omba yu kangulorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aku serimu kinia Yesusini yundu nimbale: “Ano, nuni sení okono mele sumbi siku sei.” nirimu. ⸤Judasini Yesusi kinia serimu mele⸥ kanokole oringi yemane yu liku ka siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aku seringi kinia kanopale Yesusi pea kopu seko gilieringi ye sene yunga lu-koyamo kulu topa wendo lipa Pulu Yemo popo tondoringi ye awili olandopamonga kendemande-ye se topa yunga komu se topa laká lenderimu, aku komumu wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","⸤Yuni aku serimu kinia kanopale⸥ Yesusini yundu nimbale: “Nunga lu-koyamo kelko lakilí! Lu-koya liku yombo tonge yomboma lu-koyane toko kondongela, aku kene ⸤ ‘Mólo.’ nimbu lu-koyamane ulu se naa samili⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nane nanga Tata mangilipuli “Liku tapondou.” nilkanje yuni angello ami talape rurepo, molo olandopa malapunga selu molo talo, popenge sepa na “Liku tapondangi paa.” nimba lipa mundulka akumu nu naa pilkinuye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aku-sipa na-kolo ⸤angellomane ongo opa-toumane na ‘naa tangi.’ ningu liku tapondolemolánje⸥ Pulu Yemonga bokuna na-kinia wendo ombá nimba molemo mele nambi sepa wendo olkaye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","⸤Aku nimbale⸥ Yesusini ⸤yu ka singí oringi⸥ ye awisili ongo moloringimando nimbale: “Na ‘yombo topo wa noli yere molio.’ konopu lekole na ka singíndu yombo toli lu-pultama kinia kopema kinia mengo okomeleye? Ulka-tembele ⸤kerepuluna we-yomboma maku toko molemele⸥ koleana alieli ono pea molemolo kinia ungu-mane sipu molio kinia na liku ka naa silimili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aku-sipa na-kolo i-sipa wendo okomo ulumanga pali Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi ye marene ulu mare ⸤na-kinia⸥ pe wendo ombá mele u ningu bokuna toringi molemo mele kamu wendo okomo.” nirimu. Kanu-kinia yu lombili andolima pali ⸤ ‘Olio pea ka singínje.’ ningu pilkuli⸥ yu munduku kelko ono talopa leko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kanu-kinia Yesusi ka sikuli Pulu Yemo popo tondoringi ye awili olandopa Kayapasi molorumuna mengo puringi. Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Juda yombomanga tapu-yema kinia, onone ⸤ ‘Yesusi kote sendepo piliamili.’ ningu⸥ akuna u ongo maku toko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aku-sipa na-kolo ⸤Yesusi mengo puringi kinia⸥ Pita lombili akilepa taka lepa pumba, Pulu Yemo popo tondoringi ye awili olandopamonga ulkana, ulka gilipa pala mele lipa makapu serimu, awi-suku-singina yombo maku toringi kolea we lierimuna paa sukundu pumba, ‘Yesusi nambi sengenje piliambo.’ nimba ⸤Yesusi nokoko moloringi⸥ ele-yema kinia molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga kanjollo yema pali kinia, akumane Yesusi yu toko kondongendo ulu se sepa kinjerimu ulu se ‘Yombo sene ‘yu i-sipa i-sipa sepa kinjerimu.’ nimba kolo topa nipili.’ ningu yombo se koroko moloringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","yombo awisili ongo ungu mare kolo toko niringi-na-kolo onone yu manda toko kondonge ungu se naa niringi. Laye-kolte pe mele yombo talo ongo ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","⸤kolo toko⸥ ninguli: “I yemo i-sipa nirimu ⸤pilierimbulu⸥: “I Pulu Yemo ⸤popo toko kaloli⸥ ulka-tembelemo nane topo sikisipuli wale yopoko omba pupili ulka-tembele ⸤konde⸥ se manda kolali sepo takombo.” nirimu. ⸤Yuni aku nirimumunga ‘Yu Pulu Yemo mele molio.’ konopu lepale aku nirimumu nimba kinjerimunje⸥.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aku niringili pilipale Pulu Yemo popo tondoringi ye awili olandopamo ola gilipa Yesusi mangilipa nimbale: “Ungu se pundu toko naa nikinuye? Nu ⸤ningu kinjerinu mele⸥ nikimbilimu nambolka ulumu ningu kinjerinumundu nikimbiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aku-na-kolo Yesusi ungu se pundu topa naa nimba we gilierimu. Pulu Yemo popo tondoringi ye awili olandopamone yundu kelepa nimbale: “⸤Nu moleno mele paa sika ningu sieni.⸥ Konde Molopa Mindi Puli Pulu Yemo pilipa molopili “Paa sika nikiru.” ningu mi lekole, Pulu Yemo yunga Malo, yuni olio “Nokopa kondomba ye se lipu mundumbu.” nimba, nimba taltorumu ye nokoli Karasimu sika nu molo móloye? Olio paa ningu si!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesusini nimbale: “Akumu na.” ⸤nirimu⸥. “Ungu se pea onondo pali nikirula. Pe walte Mania Omba Mana-Ye Au Lierimu Yemo, Ye Tondolo Olandopa Púlimu ⸤kinia mélema nokombando⸥ yunga ki-lomekondo molopa, kupamanga ola molopa mania ombá ono kanonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aku sipa nirimumunga ⸤ ‘Yu Pulu Yemo mele molio.’ nimba nirimu-kulu⸥ pilipale Pulu Yemo popo tondoringi ye awili olandopamone ⸤paa pilipa kiri pilipa⸥ yunga wale-pakolimu yuyu ambolopa sungu sipa nimbale: “Kiniá yu yuyu paa sika Pulu Yemo ungu-taka tondokomo kene pilipuli mongo liltimu mele nimba simba yombo se pea nambi semu-na koromoloye? Yu yuyu paa sika Pulu Yemo ungu-taka tondokomo pilkimulu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nambolka konopu lekemeleye? ⸤Yu-kinia nambi samiliye?⸥” nirimu kinia onone ninguli: “Yu Pulu Yemo ungu-taka tondopa marake semumunga topo kondomulu liemu papu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kanu-kinia onone yunga kumbikerena elkambe toko munduku, ki-lumuni toringi. Marene yu laruwa toko ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nu ‘Pulu Yemone olio nokopa kondomba ye se “Lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu molio.’ nilinu kene nawene nu tokomonje ningu para si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kanu-kinia Pita yu pena mele, yomboma liku maku toringi koleana molorumu kinia kongono sendeli kendemande-ambo se Pita molorumuna omba yundu nimbale: “Nu kepe Gallilli disiriki ye Yesusi kinia pea kopu seko moloringi kanumanga ye se lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aku-sipa na-kolo akuna moloringi yomboma pali kanoko molangi Pitane kolo topale “Mólo.” nimba “Nu nikinu mele na naa pilkiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aku nimbale Pita yu ulka kerepuluna pumba molopili kongono sendeli kendemande-ambo sene yu kanopale akuna moloringi yombomando nimbale: “I yemo yu Nasarete ye Yesusi kinia pea kopu seko molongi ye se lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitane kelepa “Mólo. Nuni nikinu yemo na naa kanolio.” nimbale Pulu Yemonga imbi lepa mi lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kanga-kolte pe mele, Pita gilierimuna nondoko gilieringi yemane ⸤yu ungu wallo-kolte lupa mele nirimu mele pilkuli⸥ yu gilierimuna ongo yundu ninguli: “Kolea Gallilli disiriki yombomane ungu nilimili mele nu aku siku ungu nikinu pilkimulu. ⸤Yesusi kinia yu lombili andoli yema kinia kolea Gallilli disiriki yemala,⸥ nu kepe Gallilli ye se, aku kene ‘Nu paa sika yu lombili andoli ye se lémo.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aku niringi kinia Pitane Pulu Yemonga imbi lepa tondolo mundupa mi lepa nimbale: “Paa sika nikiru. Ono nikimili yemo paa naa kanolio. Kolo tokoro liemu Pulu Yemone na topa kondopili.” nirimu. Aku nirimu kinia popenge sepa kera gulta ko torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aku serimu kinia pilipale Yesusini yundu “Kera gulta u ko naa topili nuni wale yopoko kolo tokole “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilierimu. Pilipale ⸤ ‘Ama, paa sepo kinjendu lepomo. ‘Paa naa sembó.’ konopu lierindu mele sika sendu.’ nimba pilipale⸥ pena pumba kola paa awili-sepa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Orili-u kolea kokele tangorumu kinia Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga tapu-yema kinia onone pali ⸤Yesusinga kotemo pilku pora sikuli⸥ ‘Yu topo kondamili.’ ningu, ningu panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aku ningu panjikuli yu liku, ka toko, mengo pungu, ⸤Romo⸥ gapomano ye nokoli Paillate molorumuna mengo pungu kote senderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kanu-kinia Judasi, yu Yesusi lipa yunga opa-touma sirimu ye kanumu, Yesusinga kotemo pilkuli “Kolopili, toko kondangi.” niringi kinia pilipale yuni Yesusi ono lipa sirimu mele pilipa kiri pilipale kelepa konopu topele topa ononga kou-sillipa wane paono tene u yu siringima kelepa memba pumba Pulu Yemo popo tondoringi ye awilima kinia Juda yombomanga tapu-yema kinia sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nane ye ono lipu sindu kanu yemo yu ungu se sepa naa kinjeli yemo ‘Toko kondangi.’ nimbu lipu sindumu paa ulu-pulu-kiri se sendu.” nirimu. Aku-sipa na-kolo onone pundu toko ninguli: “Akumu olionga ungu se mólo. ⸤Nu nunu mindi olio liku sinu.⸥ Akumu nunga kongonomo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kanu-kinia Judasi yuni kou-sillipa kanuma memba pumba ⸤Pulu Yemo popo toringi⸥ ulka-tembele palana topa anjukundu mundupale yu ono mundupa kelepa anju purumu. Anju pumbale ‘Ka nombo kolambo.’ nimbale ka se lipa memba pumbale ka nomba kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pulu Yemo popo tondoringi ye awilimane kou kanuma ⸤mania-polona⸥ lierimu kanoko liku ninguli: “I kouma yombo topo kondomolondo símuluma kene ulka-tembele kouma kinia sere lepo taltomolo kinia manda naa sembá. Akumunga ungu-mane se pelemo kene naa taltamili.” ninguli ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ungu se ningu panjiku ninguli: “I kou-monemane mingi-sosipene mane sepa wamolemo yemonga mamo topo topo liemili. Yombo ma se naa lepa ononga kolea suluna yombo ya ongo molemelemanga yombo kolongema akuna óno sangi.” ninguli aku siku topo toko liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","⸤Kanu kou-monemane ye se toko kondonge aulkamo akisinderingi koumane⸥ aku seringimunga kanu mamo imbi leko ‘Yombo Toko Meme Ondoringi Mamo’ niringi mele kiniá kepe aku sipu nilimulu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","⸤Juda ye awilimane⸥ aku siku seringimunga Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Jeremayane ulu se pe wendo ombá u nirimu mele kamu wendo orumu. Yuni nimbale: “Ye-Awilimuni nando “Sei.” nirimu mele ono aku siku sengendo Isirele yombomane “Ye akumu kou-sillipa wane paono tenene topo toko liengi.” niringi kouma likuli, kanu koumane mingi-sosipene mane sepa wamorumu yemonga mamo topo toko liltingi.” nirimu kanumu mele kamu wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Judasi aku sipa sepa molopili Yesusi Romo gapomano ye nokoli ⸤Paillate⸥ molorumumunga kumbikerena gilierimu kinia kanu ye nokolimuni ⸤yunga kotemo pilipale⸥ yu mangilipa pilipa nimbale: “Nu Juda yombomanga ye nokoli kingimu molo móloye?” nirimu. Yesusini pundu topa nimbale: “Sika nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pulu Yemo popo tondoringi ye awilima kinia, ⸤Juda yombomanga⸥ tapu-yema kinia, onone Yesusi kote sendeko Paillatendo ⸤kolo toko⸥ ungu awisili ninguli ningíndu “Yesusi yu sepa kinjilimú.” ningu yu kote senderingi kinia Yesusi yu ungu se naa nimba we gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","⸤Yesusini ungu se naa nirimu kanopale⸥ Paillatene yundu nimbale: “Nu ulu kiri awisili serinu nikimili mele nu naa pilkinuye?” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesusi ⸤yu sepa kinjerimu niringi mele⸥ pundu topa ungu seluri kepe naa nimba ⸤we gilierimu kinia kanopale Romo⸥ gapomano ye nokoli kanumuni paa mini-wale mundupa konopu awisili kimbu sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","⸤Yesusi kote sendeko molangi,⸥ ye se, yunga imbi Barapasi, yu mongo liltimu mele yomboma pali pilku moloringi kanu yemo yu ka-ulkana perimu. ⸤Kalia-ingi senga senga, Juda yombomane kolea-awili Jerusalleme ongo akuna sukundu⸥ Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingindu kere-langi noringi walema wendo orumu kinia onone ka-ulkana perimu ye se imbi leko “Wendo liku mundou.” ningu mawa seringi kinia ⸤Romo⸥ gapomano ye nokolimuni kanu yemo wendo lipa yomboma sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","⸤Aku siku se-pu-pu seringi walema kamu wendo omba pepili Yesusi kote senderingi pilipale nirimumuni,⸥ Juda yomboma liku maku toko moloringi kinia Paillatene ono mangilipa nimbale: “Ye nawe ka-ulkana wendo lipu ono siembo konopu lekemeleye? Ye Barapasi wendo lipu siembo, molo onone “Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu.” nilimili ye Yesusi wendo lipu siemboye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","⸤We-yomboma Juda yombomanga ye awilima munduku kelko ononga unguma liku mokoli seko Yesusinga ungumu pilku yu lombili andoringimunga Juda yombomanga ye awilima⸥ Yesusi-kinia konopu kiri panjikuli kote senderingi-na pilipale Paillatene aku sipa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paillate kote pilieli polona ⸤molopa ‘Juda ye awilimane pundu toko ungu se ningínje.’ nimba nokopa⸥ molorumu kinia yunga menuni ungu se yu molorumuna nimba mundupa nimbale: “Nuni andi ye sumbi nílimu ungu se naa sei. Kiniá yu kaima sepo kanondumunga nanga konopuna umbuna awisili wendo omu kene yu ungu se paa naa sei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","⸤Paillatene “Ka-ye nawe wendo lipu siemboye?” nirimu kinia pilkuli⸥ Pulu Yemo popo tondoringi ye awilima kinia, ⸤Juda yombomanga⸥ tapu-yema kinia, onone we-yomboma kondi toko ungu-umbu tondokole “ “Yesusi topa kondopili. Barapasi wendo lipa sipili.” niee.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","⸤Aku niringi kinia pilipale Romo⸥ gapomano ye nokolimuni onondo “Yetolonga ‘nawe wendo lipu siembo.’ konopu lekemeleye?” nimba mangilierimu kinia onone pundu toko ninguli: “Ye Barapasi ⸤wendo liku yando si⸥.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aku niringi kinia pilipale Paillatene onondo nimbale: “Aku liemu, onone “Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu.” nilimili ye Yesusi, nambi samboye?” nimba mangilierimu kinia onone pali “Yu unju-perana kolopili uku toko panjei!” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aku niringi pilipale yuni onondo nimbale: “Aku nambi semuye? Yu mongo nambolka mongore limuye?” nirimu. Aku-sipa na-kolo onone ⸤kelko⸥ paa tondolo munduku ninguli: “Mólo! Yu kolopili, unju-perana uku toko panjei!” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yunga ungumu naa pilku, opa senge seringi kanopale Paillatene no mare kolopa lipa, yombo liku maku toko gilieringima kanoko molangi ki kulumiye topa nimbale: “I yemo toko kondonge kolomba kinia ono-kinia ungu pemba; nanga ungu se naa pemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","⸤Aku sipa nirimu kinia pilkuli⸥ yombomane pundu toko ninguli: “Yu tonge kolombamonga umbuna pembamo olio kinia olionga bolangoma kinia pepili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kanu-kinia ye Barapasi ka-ulkana wendo lipa ono sirimu. ⸤Aku sepale⸥ Yesusi lipa ⸤yunga ami-yema⸥ sipa nimbale: “Yu ka-pultane tokole pe ‘Unju-perana kolopili.’ ningu mengo pungu unju-perana uku toko panji-paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kanu-kinia ⸤Romo⸥ gapomano ye nokolimunga ami-yemane Yesusi liku kanu ye nokolimu perimu ulka awili akuna sukundu ⸤yomboma liku maku toko moloringi koleana⸥ punguli, ononga ami talape yema pali “⸤Yesusi ya molemona⸥ sukundu-sukundu waa.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kanu-kinia yunga mulu-maminiama kulku wendo lindiku, ‘Yu ye nokoli kingi se none sepili.’ ningu mulu-maminia kondoli peanga se pakondoko, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","unju-ka koko molorumu se mulkowe seko ‘Ye nokoli kingimunga waniemo.’ ningu pengena mere mundunduku, kingimane unju kope se we ambololemele mele koló se liku yunga ki-lomekondo amondokole niringimuni, yu gilierimuna komorongo toko pondoko ungu-taka tondoko imbi we kólo toko ambolko paka tondongendo “Juda yombomanga ye nokoli kingimu, nu gilinuye?” ningu ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","yunga kumbikerena elkambe toko kandoko, koló kope ambolorumumu liku yunga pengena kope to-pu-pu seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yu aku siku ungu-taka tondoko pora sikuli mulu-maminia kondolimu kulunduku, yunga u panjerimu mulu-maminiama kelko panjindikuli “Yu unju-perana kolopili, panji-pamolo.” ningu yu liku mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","⸤Romo ami-yemane Yesusi Jerusalleme palana⸥ ultu mengo pungí punguli niringimuni, kolea Sairini ye se, yunga imbi Saimono, ambolko liku ka mele siku Yesusi kolomba unju-peramo “Kolali seko mendei.” ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","⸤Punguli⸥ kolea Golkota pungu akuna moloringi. ⸤Golkotanga ungu-pulumu ‘penge-bele lieli koleamo’ .⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","⸤Yesusi akuna mengo punguli niringimuni, ‘Yomboma mindili naa nangi.’ ningu⸥ no-waenena sukundu marasene kombili seli se munduku taltoringi aku no-waenemo ‘Yu nopili.’ ningu, siringi-na-kolo aku no-waenemo nomba pilipale “Mólo.” nimba naa norumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kanu-kinia ⸤ami-yemane⸥ yu unju-perana ola panjikuli unjumu liku ola anjeringi. ⸤Aku sekole, u unjuna ola uku toko naa panjikuli⸥ yunga mulu-maminia ⸤kulunduku taltoringima⸥ ‘Moke samili.’ ningu ono yu-mele-mele lingí mele pilingindu kou-kate seko pe mulu-maminiama liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe yu unju-perana ola giliepili tapu seko kanoko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","‘Yu mongo liltimu mele yomboma kanangi.’ ningu I YE YESUSI JUDA YOMBOMANGA YE NOKOLI KINGIMU ningu imbi toko yunga pengena olakondo unjuna mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Opa seko mélema wa liltingili ye talo pea unju-pera talonga uku toko panjeringila. Se Yesusi yunga ki-lomekondo uku toko, se ki-tarokondo uku toko panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Akuna ongo puringi yombomane Yesusi ⸤kanoko kiri pilkuli yu⸥ ungu-taka tondoko iri-mele toko ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ninguli: “Aa! “Ulka-tembelemo sikisipuli kelepo wale yopoko omba pupili takopo limbu.” nirinu yemo, ‘Naa kolambo.’ ningu nu nunu liku tapondou. Nu sika Pulu Yemonga Malo liemu unju-perana mania ou.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aku sikula Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, ⸤Juda yombomanga⸥ tapu-yema kinia, onone kepe yu ungu-taka tondoko ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yu yombo wema ‘Naa kolangi.’ nimba lipa tapondorumu-na-kolo yu yuyu ‘Naa kolambo.’ nimba manda naa lipa tapondokomo. Yu ‘Isirele yombomanga ye nokoli kingimu ⸤molio.’ nilimú mele sika aku sipa⸥ molemo liemu yu yuyu unjuna mania opili. Yu yuyu unjuna mania ombá kinia kanopole ‘Yu sika olionga ye nokoli kingimu.’ nimbu tondolo mundupu pilimulú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yuni ‘Pulu Yemone na lipa tapondomba.’ nimba kuru mondopa molemo kanumu; yu “Pulu Yemonga Malo molio.” nilimú kene Pulu Yemone yu kanopa peanga pilipa, ‘Yu mania we olkanje papu.’ konopu liemu liemu manda, yu omba yu lipa tapondopa ⸤unjuna wendo lipili⸥. ⸤Aku sipa semu liemu ‘Yu sika Pulu Yemonga Malo.’ nimbu kuru mondomolo⸥.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wa noli ye talo yu-kinia unjutolonga uku toko panjeringi yetolone yu aku siku ungu-taka tondoringilila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","⸤Yesusi unjuna ola we pepili⸥ awi-tangoli ena tuwellepo killoko serimu kinia kolea pali simbulu topale, pe ipupini ena tere killoko serimu kinia kelierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ipupini ena tere killoko mele serimu kinia Yesusini ru nimba nimbale: “Elloi, Elloi, llama sapakatani.” nirimu. Akumu Juda yombomanga ungu se. Akumunga pulumu i-sipa: “Nanga Pulu Yemo, nanga Pulu Yemo, na nambi semu-na munduku kelienuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Akuna nondoko gilieringimanga marene yuni aku nirimu kinia pilku ⸤sunduku⸥ ninguli: “Piliame. Yu Illainja mangilkimu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aku nirimu kinia pilieringimanga ye se popenge sepa lisipa pumba ulú-pinja mele se lipa no-waene kombili seli mare akuna panjipale, ‘Yesusi no-waene kombili seli pinjana pelemomo nopili.’ nimba memba omba unju-pepena senga ka topa olando sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","⸤Aku-na-kolo yu no-waenemo sirimu mele kanokole⸥ we-yombomane ninguli: “Mólo. Kiniá unjuna we pepili. Illainjane sika yu ‘Naa kolopili.’ nimba lipa tapondopa mania limbando okomonje, kanopo kanamili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesusini ungu se tondolo ru nimbale, pe yunga minimundu ‘Pu.’ nimba yu kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yu aku sipa kolorumu kinia ⸤ulu awili mare⸥ waltikele ⸤wendo orumu.⸥ Pulu Yemo popo toko kaloringi ulka-tembele ⸤Jerusalleme sukundu gilierimu akuna sukundu Pulu Yemo molorumu⸥ suluminia paa kake sélimunga kerepuluna ⸤‘Yomboma sukundu naa pangi.’ ningu u alieli⸥ mulu-maminia awili sene pipi siku panjeringi gilierimu. ⸤Yesusi kolopa pora sirimu kinia⸥ kanu mulu-maminiamo awi-suku-singina olakondo maniando sipa olá torumu. ⸤Aku sepa,⸥ ma jimi-jimi se sepa, kou awilima topa ungu-mangu topa, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","yombo u óno seringi koleama anju yando pumba, Pulu Yemonga yombo kake seli u koloringima ⸤Pulu Yemone⸥ topa makisinderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lomboroko ola molko óno-kolea peringina wendo ongole, Yesusi pe lomboropa ola molorumu kinia Pulu Yemonga kolea-awili kake selina sukundu punguli yombo awisili ‘Kanangi.’ ningu puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","⸤Romo⸥ ami-ye wane anderete nokorumu yemo kinia, yu pea Yesusi serimu mele tapu seko kanoko moloringi ami-yema kinia, onone ma jimi-jimi sepa ulu lupa lupama wendo orumu kinia kanokole ono paa mini-wale munduku ninguli: “I yemo yu paa sika Pulu Yemonga Malo lepomo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ambo awisili mele, ⸤Yesusi unju-perana kolorumu⸥ akuna sulu seko kanoko gilieringi. U kanu amboma ⸤ononga pulu-⸥kolea Gallilli disiriki munduku kelko Yesusi lombili andoko liku tapondoko nokoko ⸤Jerusalleme pea⸥ oringi amboma. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ononga ambo se Makatalla taono ambo Maria, se Jemisi kinia Josese kinia olonga anumu Maria, se ye Seperinga malotolonga anumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ipupini, kolea kala tomba serimu kinia Arimatia taono ye kamako se, yunga imbi Josepo, yu kepe Yesusi lombili andorumu ye se, yu omba ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","⸤Romo gapomano ye nokoli⸥ Paillate molorumuna pumba, “Yesusinga ónomo na si.” nimba mawa serimu kinia Paillatene yu “Ónomo lipili.” nimba ⸤ami-yemando nimba mundorumu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","⸤Paillatene “Manda.” nirimu kinia⸥ Josepo pumba ónomo mania lipa, mulu-maminia konde sene lipa okorumu. Okopale ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kou-kande konde se, Josepo yu ‘Kolombo kinia akuna na óno sangi.’ nimba kou-kande se akupa taltorumu kou-kandemonga sukundu memba pumba taltorumu. Taltopale kou-kande kerepuluna kou awili se perele-marele memba omba pipi sipale yu kelepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makatalla taono ambo Maria kinia Maria se kinia olo kou-kandemo lierimu kerepuluna nondoko ⸤yu ónomo kou-kandena taltorumu mele kanoko⸥ moloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","⸤Kanu-kinia,⸥ ‘Opali ⸤koro molomolo⸥ wale Sambatemo.’ ningu pilkuli, kiniá-mele, mélema undu-undu siringi kanu walemo pora nirimu kinia opalikundu Pulu Yemo popo tondoringi ye awilima kinia, Parisi yema kinia, ono ⸤Romo gapomano ye nokoli⸥ Paillate molorumuna pungu liku maku toko gilku ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ninguli: “Ye-Awilimu, ye kanumu u naa kolopa we molopale yombomane ‘Sika.’ ningu kuru mondonge unguma kolo topa nirimu kanu yemo yu “Kolopole wale yopoko omba pumbá kinia lomboropo ola molombo.” nirimu olio pilierimulu kene ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","⸤nuni ami-yemando⸥ “Kanu yemo ⸤oleanga⸥ óno sengi kou-kandemo wale yopoko paa mimi siku nokaa!” nieni. Naa nokonge kinia yunga lombili andoli yemane ónomo ongo wa liku mengo punguli “Yu lomboropa ola molopa omba pumu.” ningí. Aku siku kolo toko ningí kinia yu u ‘ ‘Sika nikimu.’ niengi.’ nimba kolo torumu ungumu maniandopa, onone ‘Yombomane ‘Yuni sika aku sipa semu.’ niengi.’ ningu kolo tonge ungumu paa olandopa pemba.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paillatene ⸤Juda ye awilimando⸥ pundu topa nimbale: “⸤Aku liemu,⸥ ami-ye mare liku mengo pungu, “Yemo óno sengi koleamo nokoko kondangi.” ningu mondoko, ‘Yombomane óno-koleamo ungu se naa sangi.’ ningu ‘Aulkamo tondolo pipi siemili.’ konopu lenge mele sangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","⸤Aku nirimu kinia⸥ pilkuli ami-ye mare liku mengo pungu, yombo óno-kou-kandemo pipi siringi koumu pala seko pele leko ononga imbimu akuna toko mondokole, “Ami-yema akuna nokoko molangi.” ningu mondokole ⸤ono puringi⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","⸤Koro moloringi⸥ wale Sambatemo pora nimba, ononga pulu-pulu kongono walemo wendo ombándo kolea tangombando muni lierimu kinia Makatalla taono ambo Maria kinia, Maria se kinia, pungu ⸤Yesusinga⸥ ónomo taltoringi kou-kandena ⸤ónomo⸥ kanongele puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ye-Awilimunga mulu-koleana angello se mania orumu kinia ma jimi-jimi paa tondolo sepa serimu. Angellomone omba kou-kandena pumba kou-kande kerepulumu pipi siringi koumu wendo lipa perele-marele memba pumba taltopa akuna ola molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kanu angellomonga kumbikeremo kariapá sepa pa selemo mele pa sepa, mulu-maminia pakorumuma kalopora topa paa kake selemo mele kake serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yesusi óno-kolea nokoringi ami-yema angellomo kanoko paa mini-wale munduku pungu-pungu ninguli yombo kololimane ungu naa ningu ungu se naa selemele mele ono aku siku unguri naa seko we moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angellomone ambotolondo nimbale: “Pipili naa kolale. Yesusi ‘Kolopili.’ ningu talko unju-perana uku toko panjeringi kanu yemo kanongele okombele na pilkiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yu ya naa lemó. ⸤ “Kolopole wale yopoko-sipamonga⸥ lomboropo ola molombo.” u nirimu aku mele semu. Ónomo u lierimu koleamo ongo kanale. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kanokole popenge seko pungu yunga lombili andolima i-siku ningu siengili: “Yesusi óno-koleana lepale lomboropa ola molopa kolea Gallilli disirikindu kumbi lepa pulimú kene ono akuna yu kanonge.” ningu siengili. ⸤Ungu nimbu sindimbundu ondu⸥ kanu ungumu nimbu pora sikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","⸤Angellomo aku sipa omba mona molopale nirimu mele⸥ kanoko pilkuli ambotolo pipili kolko kamelé paa akoko, aku sipa konopu talo pepili lisiku pungu yunga lombili andolima ningu singilí puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","⸤Lisiku pungilí puringili kinia⸥ Yesusi lipa sinjipa olo aulkana kanopa lipale “Okombeleye?” nirimu. Kanu-kinia olone yunga kimbukundu pungu kangulku yu kape ningu imbi ambolko paka tondoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kanu-kinia Yesusini olondo nimbale: “Pipili naa kolkole, olo pungu nanga genupilindu i-siku niengili: “Kolea Gallillindu pangi. Yu akuna kanonge.” ni-pale.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ambotolo kelko yando ongele oringili kinia Yesusinga óno-kou-kandemo nokoringi ami-ye mare kolea-awili ⸤Jerusalleme⸥ sukundu pungu Pulu Yemo popo tondoringi ye awilimando uluma wendo orumu mele pali ningu si-poringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","⸤Pilieringi kinia⸥ popo tondoringi ye awilima, Juda yombomanga ye awilima kinia pea maku tokole ono kinia ⸤ungu ningu ninguli: “We-yomboma i uluma wendo omu mele pilkuli “Yesusi lomboropa ola molomunje.” ningí kene ‘Naa piliangi.’ nimbu nambi samolonje?” ningu⸥ angelema ninguli senge mele ningu panjikuli niringimuni, ami-yema kou-mone awisili siku ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","onondo ninguli: “Yombomane “Yesusi nambi semuye?” ningu mangilingí kinia onone i-siku niengi: “Ipulieli uru pemulu kinia yunga lombili andolimane kiyongo ningu ongo yu liku mengo púngi.” niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","⸤Olio Juda yomboma nokolemo Romo⸥ gapomano ye nokolimuni ⸤aku sengi mele⸥ ungu se piliemu liemu ’ “Ono seko kinjikimili kene mindili nangi.” naa niengi!’ nimbu olione ononga lipu tapondopo yu-kinia ungu nimulú, kanu-kinia ‘Onone óno-koleamo mimi siku naa nokoko we uru pengi.’ konopu lepale mindili lipa naa simba.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aku niringimunga pilkuli ami-yemane kou-mone liku onone “Niee.” niringi mele yombomando niringi. Akumunga yandopa kiniá i ⸤boku tokoro⸥ walemo kepe Juda yombomanga koleamanga pali i ungumu anju anju pulimú pilkuli yombo awisilini kanu semanemo toko molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","⸤Ambotolo punguli kanoko pilieringili mele semane toko siringili⸥ kinia pilkuli Yesusi lombili andoli ye rureponga yopoko kolea Gallilli disiriki pungu, Yesusini ma-pangi se imbi lepa u “Akuna wangi.” nirimu ma-pangina puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akuna pungu Yesusi kanokole niringimuni, yu kape ningu yunga imbi ambolko paka tondoringi-na-kolo marene ‘Yesusi kolorumu. Imu Yesusi molo nawenje?’ ningu konopu talo seko lieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kanu-kinia Yesusi yu nondopa omba onondo nimbale: “Tatane nando “Nu nunu mulu-koleana mélema kinia yomboma kinia, ma-koleana mélema kinia yomboma kinia nokani.” nimba tondolomo na sirimu, na-kinia pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aku ⸤tondolo na sirimumu ono simbú ono-kinia pemba⸥ kene ono ma-koleamanga pali pungu ‘Yomboma pali nanga ungumu pilku liku, nanga lombili andolima molangi.’ ningu, pungu ningu si-punguli ningímuni, ⸤pilku liku molonge⸥ yomboma no lindingindu Lapa kinia Malo kinia Mini Kake Sélimu kinia ononga imbi mangilku ono no lindiku, ");
INSERT INTO ubu_andelale_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","onondo “Na lombili andolimane sangi.” nirindu mele pali ‘Aku yomboma sangi.’ ningu ono mane siengi. Aku siku niliku andoko molonge kinia na ono-kinia alieli molambo mulu matolo pora nimbá.” nirimu. ⸤Aku pea.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesusi, Pulu Yemone “Olio nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu, Pulu Yemonga Malo, yunga semane peangamo pulu polorumu mele ⸤ya inia tombo tokoro⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","⸤Yesusi, Pulu Yemone nimba taltorumu ye nokoli Karasimunga semane peanga imu wendo ombándo ye se u omba sembá mele⸥ Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane Pulu Yemonga ungu se nimba bokuna torumu akuna molemo mele i-sipa: ‘⸤Pulu Yemone nimbale:⸥ “⸤Pílie!⸥ Nane ‘ ‘Nanga ungu-umbu tondolima pilipa nimba sipili.’ nimbu lipu mundumbu yemone nunga aulkamo akisindepili.’ nimbu yu “Kumbi leko pu.” nikiru.’ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Kolea ku lielina ⸤kumbi lepa pumbá⸥ ye senga kerena ungu se nimbale: “Ye-Awilimu ombá aulkamo seko wamame. Yu ombá aulka kangama toko sumbi siee.” nimbá.” nikimu.’ nimba ⸤Aisayane No Lindeli Jonone paa pe sembá mele u aku sipa nimba sipa bokuna torumu molemo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Akumunga, ⸤semane peangamo pulu polombando No Lindeli⸥ Jono kolea ku lieli senga wendo omba ⸤aku sipa⸥ ungu mare yomboma nimba sipa molorumu. Kolea Judia disiriki yomboma pali kinia kolea Judianga kolea-awili Jerusalleme yomboma pali kinia ono yu molorumuna pungu yunga ungumu pilingíndu puringi. Yuni ungu se onondo nimba sipa nimbale: “Ono ulu-pulu-kiri selemelema kanoko kiri pilku konopu topele tokole ‘Pulu Yemone olionga ulu-pulu-kirima ‘We mania pupili.’ nimba siye kolopili.’ ningu ‘No liemili.’ ningu waa.” nirimu. Aku sipa nirimu kinia ononga ulu-pulu-kiri seringima ningu para siringi kinia yuni ono no Jodane nona no linderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jono kongi kamelenga indimuni seli wale-pakoli se pakopa, kongi kangimuni seli kakomo topale, kulkumba kinia pilimu-no kinia aku langitolo mindi nomba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Yuni yomboma ungu nimba sirimu mele i-sipa: “Nane sika ono no lindiliu-na-kolo ye se akilepa ⸤nondopa⸥ ombá ⸤sekemo⸥mo yuni ono ⸤Pulu Yemonga⸥ Mini Kake Sélimu lindimba ⸤lingí⸥. I na akilepa ombá yemo yunga tondolomo paa olandopa, nanga tondolomo paa maniandopa, na yu-kinia manda mólo. Yombo awilimanga kongono kiri sendeli kendemande-yombomane sika ononga yombo awilimanga kongono kiri sendengendo mania molko ononga yombo awilimanga kimbu-suma ka pilka tondolemele-na-kolo na ye paa kirimu moliomonga kanu ombá yemo yunga kimbu-su ka pilka tondoli kanu kongonomo paa olandopa mele, nane sendelkanje manda naa selka. ⸤Na ye paa kirimu, yu ye paa awilimu.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","⸤Jono yomboma no lindipa molorumu⸥ kanu walemo kinia Yesusi kolea Gallilli disiriki Nasarete taono mundupa kelepa ⸤Jono molorumuna⸥ orumu kinia Jonone yu no Jodane nona no linderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","⸤Yesusi no lipa pora sipale⸥ nona wendo omba gilierimu kinia sumbi sipa mulúmu kengeya lepa anju yando purumu kanopale, Pulu Yemonga Minimu, kera waembono mele, mania omba Yesusi molorumuna pumba kangina ola molorumu kanorumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kanu-kinia muluna ola ungu se wendo omba nimbale: “Nu nanga konopu mondolio kangomo. Nu-kinia konopu sipu molio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","⸤Yesusi no liltimu kinia Pulu Yemonga Minimu yu-kinia omba molopale nirimumuni,⸥ sumbi sipa Minimuni Yesusi kolea ku lielina lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","⸤Akuna purumu kinia,⸥ oli se koro talo Yesusi aku kolea ku lielina takara mélema kinia molopili ⸤kurumanga nokoli⸥ Setene omba yu kondi torumu. Kanu-kinia ⸤mulu-koleana⸥ angelloma ongo yu nokoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kanu-kinia ⸤No Lindeli⸥ Jono ka siku ka-ulkana panjeringi kinia pilipale Yesusi kelepa kolea Gallilli disiriki omba Pulu Yemonga semane peangamo topa silipa andorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","⸤Topa silipa andopa⸥ nimbale: “Kiniá enamo kamu wendo okomo, Pulu Yemo ye nokoli kingimu molomba enamo nondopa wendo okomo kene ulu-pulu-kirima munduku kelko konopu topele toko, ‘Semane peangamo yu sika ungumu.’ ningu kuru mondaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","⸤Aku sipa nilipa andopa⸥ Gallilli nomu kelona andopale Yesusini Saimono kinia Saimono genu Enderutolo oma lili wale se nomuna toko munduku moloringili kanorumu. Oma liltingili akumu olonga kou-kongono seringili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","⸤Aku siku seko moloringili kanopale⸥ Yesusini olondo nimbale: “Na lombili wale. Oma lingilindu oma lili wale se liku nona mania mundulimbili kinia omama walena omba pelemo mele, pe ‘nanga kongonomo sengelendo nanga ungumu pilku ningu siliku andongele kinia yomboma nanga talapena sukundu ongo molangi.’ nimbu ‘Olo na lombili wale.’ nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","⸤Aku nirimu kinia pilkuli⸥ popenge seko olonga oma lili walema munduku kelkole Yesusi lombili puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","⸤Kanu-kinia⸥ yu kanga-kolte wiltu pumbale, Seperinga malo Jemisi kinia Jemisi genu Jono kinia olonga nona andoli sipina sukundu molko oma lili walema toko tandoringili kanopale ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","waltikele olondo “Wale.” nirimu. Kanu-kinia lapa Seperi kinia kongono yema kinia sipina sukundu molangi munduku kelkole Yesusi lombili puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","⸤Kanu ye pokore Yesusi lombili puringi kinia⸥ yu kinia ono Kapeniame taono puringi. Kanu-kinia ⸤koro moloringi⸥ wale Sambatemo wendo orumu kinia Yesusi Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkana sukundu pumba yomboma mane sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mane sirimu kinia Pulu Yemonga ungu-manemanga puluma pilku ono mane siringi yemane we mane siringi mele Yesusini aku sipa mane naa sirimu. Namba lierimu yemane pipili naa kolko tondolo munduku mane siringi mele yuni aku sipa mane sirimu-kulu pilkuli yombomane mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kanu-kinia ulka kanuna sukundu kuru se ye senga konopuna molopa yu ambolorumu ye se molorumu, ⸤yemonga konopuna sukundu molorumu kanu kurumuni yu “Ungu ni.” nimba ulku torumu-na⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yuni opa-ungu nimba nimbale: “Nasarete taono ye Yesusi, nu pea olio ⸤kuruma⸥-kinia seluna kopu sepo manda naa molomolo. Nu olio-kinia nambi semu-na onuye? Nu olio toko kondoni onuye? Nane nunga imbi pilielio. Nu Pulu Yemonga Ye Kake Sélimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","⸤Aku sipa nirimu kulu pilipale⸥ Yesusini kanu kurumu iri topa yundu nimbale: “Nu ungu naa ningu yemonga konopuna ongo wendo pu.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kurumuni yemo ambolopa tondolo mundupa puru-puru sipale kalli nilipa omba wendo purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","⸤Yesusini aku serimu kanokole⸥ yomboma pungu-pungu ningu, mini-wale munduku ono onono anju yando ninguli: “I ungumu nambolka unguri sekemonje? Ungu-mane konde se wendo ombámo. Ye namba lieli sene we-yombomando “Saa.” nilimú mele i yemone kurumando kepe aku sipa nilimú kinia kanu kuruma yunga ungumu pilku liku selemele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanu-kinia kolea Gallilli disiriki koleamanga pali yuni aku sipa serimu mele semanemo popenge sepa para-nanga lepa purumu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kanu-kinia ⸤Yesusi-kinia, yu lombili andoli yema kinia⸥ ono kanu maku toko Pulu Yemonga ungumu pilieringi ulkamo munduku kelko wendo ongole niringimuni, ono kinia, Jemisi Jonotolo kinia ono pungu Saimono kinia Enderutolonga ulkana puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ulkana sukundu puringi kinia Saimononga kolepa-ambomo kuru topa kangi nopili lierimumu Yesusi ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aku siku niringi pilipale ambomo lierimuna pumba yunga kimu ambolopale yu ola liltimu kinia kangi nomba kelierimu kinia ambomone ⸤ola gilipa wendo ombale⸥ oringi-yema kere-langi sipa nokorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pe kolea kalá topa ena purumu kinia, kuru torumu yomboma kinia, konopuna kuru molorumu yomboma kinia, Yesusi molorumuna mengo oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kanu koleana moloringi yomboma pali Saimononga ulka-kerepuluna ongo maku toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kanu-kinia Yesusini yombo kuru lupa lupa torumu awisili sepa peanga sipa, yombomanga konopuna moloringi kuru awisili topa makororumula. Kurumane Yesusi ⸤Pulu Yemonga Malo, yu Pulu Yemone nimba taltopa lipa mundorumu ye nokoli Karasimu⸥ molorumu mele pilieringi-kulu yuni onondo “Molio mele anju ningu naa siee.” nimba ononga kerema pipi sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Orili-u, kolea muni u naa lepa simbulu topa pepili Yesusi ola molopa penando pumbale nirimumuni, kolea ku lieli senga pumba, akuna Pulu Yemo-kinia ungu nimba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimono kinia pea moloringi yema kinia ono yu koroleko lombili punguli niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","yu kanoko lendeko yundu ninguli: “Yombomane pali nu korokomele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","⸤Aku niringi pilipale⸥ yuni onondo nimbale: “Na kolea marenga kepe ungu nimbu siembo kene i koleamo mundupu kelepo kolea senga pamili. Ne nondopa lemó koleamanga pamili. Na koleamanga pali ungu nimbu simbundu mana-mania orundu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aku nimbale yu kolea Gallilli disiriki sukundu koleamanga pali andopa Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkamanga sukundu pumba ungu nimba sipa, yombomanga konopuna kuru moloringima topa makororumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Walte kuru laká nomba perimu ye se Yesusi molorumuna omba yunga kumbikerena komorongo langopa yu mawa sepa nimbale: “Nunga konopumuni na ‘Peanga liepili.’ konopu lienu liemu nuni na manda seko peanga sini.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kanu-kinia Yesusini yu paa kondo kolopale yunga kimuni yemo ambolopa yundu nimbale: “‘Nu peanga liepili molani.’ konopu lekero kene peanga liepili molou.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","kuru lakámo popenge sepa nomba kelierimu, yemo peanga lepa umbu-kangi liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kanu-kinia Yesusini yu ungu se tondolo mundupa nimbale: “Nuni ya ungu sekeromo yombo selurindu kepe paa naa ni! Sumbi siku pungu Pulu Yemo popo tondoli yemo nunga kangimu liku ora siku, ‘Na kelepo kangi peanga liepili molkoro kene.’ ningu Mosisini “Sei.” nimba ungu-mane sirimumu pilku liku senindu “Pulu Yemo popo toko kalko siee.” nirimu mélemo liku Pulu Yemo popo tondoli yemondo “Kalondou.” ningu yu sieni. Pe yombomane nu kanokole ‘Yu sika kangi peanga liepili molemo.’ ningu piliangi kene nikiru mele iseli-u se-pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aku-na-kolo yemo yu anju pumbale ungu awisili yombo awisilindu anju anju nimba para silipa andopa, Yesusini yu-kinia serimu semanemo topa sirimu. Yemone aku serimu-kulu Yesusi ⸤ ‘Yombo awisili na molombona nondoko nondoko ongo maku naa tangi.’ nimba⸥ kelepa taonomanga sukundu mona manda naa andopale kolea ku lielina molorumu, aku-na-kolo kanuna yombo awisili kolea lupa lupamanga molko sukundu sukundu ongo yu molorumuna maku toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wale mare omba purumu kinia Yesusi Kapeniame taono kelepa sukundu purumu. Yu u perimu ulkana kelepa omba molorumu yombomane pilkuli ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ono awisili ongo ulkana sukundu sukundu ongo liku maku toko moloringi kinia ulka kanuna ekelepa serimu-kulu yombo mare molonge kolea se naa lierimu-kulu pena moloringila. Yuni ono ⸤Pulu Yemonga⸥ ungumu nimba sipa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","⸤Yuni nirimu mele aku siku maku toko pilku molangi⸥ yombo mare kimbu ki kolopa pora sirimu ye se mengo oringi. Kanu yombomanga ye kisene kanu yemo taropola seko mengo Yesusi molorumuna onge oringi-na-kolo ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","yombo awisili ulkana ekelepa seko gilieringi-kulu yu molorumuna nondoko mengo pungí aulka se naa lierimu-kulu ulka imuna mengo ola punguli Yesusi molorumuna kana-kana ulkamo sikisikuli yemo taropola pali moko toko mania mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","⸤ ‘Yesusini i yemo manda sepa peanga simba.’ ningu⸥ kuru mondokole yu mengo oringi kanopa pilipale Yesusini kimbu-ki kolopa pora sirimu yemondo nimbale: “Nanga kangomo, nunga konopuna ulu-pulu-kiri serinu pelemoma mania pupili, we siye kolkoro.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","⸤Kanu-kinia,⸥ Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye mare onono akuna molko ⸤Yesusini aku nirimu kinia pilkuli pilku kiri pilku⸥ konopu kimbu sikuli, “Nendi yemone ungu aku sipa nambi semu-na nikimuye? Yu Pulu Yemo marake sekemo. Yombomane ulu-pulu-kiri selemelema nawene ‘Mania pupili, siye kolkoro.’ manda nimbáye? Pulu Yemone mindi manda selemo.” ningu onono ningu pilku molko konopu kimbú siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kanu-kinia Yesusini ono aku siku konopu kimbú siku moloringi mele yunga konopumuni sumbi sipa pilipa onondo nimbale: “Onone ⸤nane nikirumunga⸥ aku siku nambi semu-na konopu kimbú sikimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","I yemondo “Nunga ulu-pulu-kirima mania pupili, we siye kolkoro.” nimbú kinia ono ulu se naa kanokole ‘Pe nilse nikimu.’ konopu lengeye? Molo “Ola gilku nunga kunungumu liku mengo kimbu-kongono seko andou.” nimbú kinia yu ola gilimbane naa gilimbanje mona lemba manda kanokole ‘Aku sipa kála sepa nikimunje.’ konopu lengeye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aku-sipa na-kolo ‘ ‘Mania Omba Mana-Ye Au Lierimu Yemo tondolo pelemomone ya ma-koleana yombomanga ulu-pulu-kirima “Mania pupili, we siye kolkoro.” manda nimbá.’ ningu piliangi.’ nimbu aku sipu nindu.” nirimu. Aku nimbale kimbu-ki kolopa pora sili yemondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nane ‘Nu ola gilku nunga kunungumu liku mengo ulkando pu.’ nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aku nirimu kinia yemo ola gilipa popenge sepa kunungumu lipa memba, ono pali kanoko molangi omba pena purumu. Yu aku serimu kanokole ono pungu-pungu ningu mini-wale mundukuli Pulu Yemonga imbi ambolko paka tondoko yu kape ningu ninguli: “Olio i ulu wendo okomo kanokomolo mele u walte kepe ulu se aku sipu paa naa kanorumulu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesusi ⸤ulkamo mundupa kelepa⸥ pena pumbale kelepa Gallilli nomu kelona pumba andopa molorumu. Kanu-kinia yu molorumuna yombo awisili ongo liku maku toko moloringi kinia yuni ono mane sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kanu-kinia yu pumbá pumbale nirimumuni, Allapiasi malo LLipai kou-takisi liltingi ulkana ⸤kou-takisi lipa⸥ molorumu kanopale yundu “Nu na-kinia pea pambili lombili ou.” nirimu. Kanu-kinia LLipai yu ola gilipa yu lombili purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pe Yesusi LLipainga ulkana kere-langi nomba molorumu kinia kou-takisi lili yema kinia, ⸤Juda ye awilimane⸥ “ulu-pulu-kiri seli ye” ⸤niringi⸥ ye wema kinia awisili ongo Yesusi kinia yu lombili andoli yema kinia ono pea mania molko kere-langi noringi. Aku sili yombo awisili alieli yu lombili andoringimunga ono awisili ⸤akuna lombili pungu⸥ pea kere-langi nongo moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yesusi yu “ulu-pulu-kiri selima” niringi yombo wema kinia kou-takisi lili yema kinia pea kere-langi nongo moloringi kanokole Parisi ye marene, Pulu Yemonga ungu-manemanga puluma pilku mane siringi kanu yemane, Yesusi lombili andolimando ninguli: “Kou-takisi lili yema kinia, ulu-pulu-kirima seli wema kinia, ono-kinia yu nambi semu-na kere-langi pea nokomeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aku siku niringi pilipale Yesusini onondo nimbale: “Kuru naa tolemo yomboma doketana naa pulimili. Kuru tolemo yomboma mindi doketana pulimili kanumu. Nane “Yombo sumbi nilima na molombona wangi.” nimbúndu ma-koleana naa orundu. ‘Ulu-pulu-kiri seli yomboma na molombona wangi.’ nimbúndu orundu. Ulu-pulu-kiri seli yomboma lipu tapondombondo orundu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","⸤No Lindeli⸥ Jono lombili andoringi yema kinia, Parisi yema lombili andoringima kinia, ono wale marenga kere-langi mi leko naa noringi mele walte aku siku seko moloringila. ⸤Aku seringi-kulu⸥ yombo mare Yesusi molorumuna ongo yu mangilku pilku ninguli: “Jono lombili andolima kinia, Parisi yema lombili andolima kinia, alieli kere-langi mi leko naa nolemele-na-kolo nu lombili andolima aku siku naa selemele akumu nambi semu-na naa selemeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","⸤Aku siku niringi kinia pilipale⸥ Yesusini pundu topa onondo ⸤ungu-iku se topa yu toko kondonge kolombamonga ungu se nimba⸥ nimbale: “Ambo limba ye se yunga pulu lemó yema kinia molemo kinia ono konopu sikuli “Kere-langi mi lepo naa namili.” manda ningíye? ⸤Manda naa ningí.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aku-sipa na-kolo pe, ambo limba yemo ono molongena ongo wendo lingí kinia kanu walemanga sika ⸤konopu kiri panjiku⸥ kere-langi naa nongendo mi lenge. ⸤Iseli-u mólo.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mulu-maminia u se sungu nilimú kinia olione mulu-maminia paa konde senga se kopisipu lipu, sungu nilimúmunga naa topo tandolemolo kanumu. Yombo sene aku sipa topa tandolkanje kanu mulu-maminiamo nona panjilka kinia mulu-maminia konde kopiselimu kanga lepa lli nimbale mulu-maminia umu kelepa kamu awili sepa sungu nilka. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kongi-meme kangimuni seli mingi-u senga no-waene konde naala kololemolo kanumu. Yombo sene mingi-u senga no-waene konde se kolkanje kanu no-waenemo mingina sukundu pepale pe akolka kinia kanu mingi-umu naa akopa sungu nilka. Kanu-kinia nomo kepe mingimu kepe kamu kiri lelka. Akumunga no-waene konde kongi-meme kangimuni seli mingi kondena mindi kololemolo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Walte, ⸤koro moloringi⸥ wale Sambate senga, Yesusi kinia yu lombili andolima kinia rasi-witi kaliamanga ongo puringi kinia yu lombili andoli yemane rasi-witi mongo mare ⸤nongendo⸥ inia toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aku seringi kanokole Parisi yemane Yesusindu ninguli: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa sangi.’ nimba pelemo ungu-manemo nambi semu-na nu lombili andoli yemane manemo pulua tokole aku siku sekemeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesusini pundu topa nimbale: “Ono Pulu Yemonga bokuna sukundu ⸤anda-kolepa ye nokoli kingi⸥ Depitini serimu mele nimba molemo semanemo kanokole ⸤semanemonga pulumu⸥ naa pilielemeleye? Depiti kinia yu pea puringi yema kinia ono ⸤kere-langi⸥ mólo torumu⸤munga⸥ gelene kolkole niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pulu Yemo popo tondoringi ye awili olandopa Apayata molopili Depiti Pulu Yemo molorumu serele-ulkana sukundu pumba, Pulu Yemonga kumbikerena lierimu pellawa kalolima lipa nomba, yu pea puringi yema sirimu noringila kanumu. Kanu pellawa kalolimando Pulu Yemone ungu-mane sipa nimbale: “We-yombomane paa naa nangi! Pulu Yemo popo tondoli yema manjiku nangi!” nirimu ⸤kanu ungu-manemo pulua torumu⸥ kanumu. ⸤Ono konopu talo nambi semu-na lemeleye? Depiti yuni u aku serimu mele ono pilku kiri naa pilielemelemonga pe kiniá na lombili andoli yemane sekemele mele kanoko kiri naala piliaa!⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aku nimba ungu se pea nimbale: “Pulu Yemone ‘Yomboma molko kondangi.’ nimba ⸤koro molonge⸥ wale Sambatemo lipa ono sirimu kanumu. ‘Sambate walemo pepa kondopili.’ nimba yomboma lipa Sambate walemo naa sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akumunga Sambate walemo kepe Mania Omba Mana-Ye Au Lierimu Yemo nokolemo yemo molemo-na ⸤Sambate wale kinia yomboma molko kondongendo senge mele manda nimbá kanumu⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pe walte Yesusi pumba Juda yomboma maku toko Pulu Yemonga ungu pilieringi ulka senga purumu. Kanu ulkana ye se molorumu, yunga ki se kamu kolopa kukorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kanu-kinia akuna moloringi ye marene ‘Yesusini ulu se sepa kinjimba kinia yu kote sendemolo.’ ningu ulu se sepa kinjimba se ⸤alieli koroko molkole⸥ ‘⸤Koro molemolo⸥ wale Sambate kinia yuni yemo sepa peanga simbanje.’ ningu yu mimi siku kanoko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesusini kanu ki kolopa kukorumu yemondo nimbale: “Yomboma molemelena ongo ola giliei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kanu-kinia yemando nimbale: “Sambate wale kinia ulu nambolka ulu se manda semoloye? ‘Sambate walemonga ungu-manemone “Sangi.” nilimú mele samili.’ nimbu yomboma lipu tapondomolo kinia manda molo sepo kinjimulú kinia mandaye? ‘Naa kolangi konde pangi.’ nimbu semolomo manda molo topo kondomolomo mandaye?” nimba mangilierimu kinia pilkuli onone ungu se pundu toko naa ningu we moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yuni ono neme-neme nimba kanopale mumindili kolopa ono yemo kondo naa koloringi kanopale lakopa konopu kiri panjipale ki kolopa kukorumu yemondo nimbale: “Nunga kimu siniu si.” nirimu kinia yemone yunga kimu siniu sirimu kinia ki kolopa kukorumumu kelepa kamu peanga lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","⸤Yesusini aku serimu kinia kanokole⸥ Parisi yema pena pungu, ono kinia ye nokoli kingi Erotenga talapena yema kinia maku toko “Yu nambi sepo topo kondomoloye?” ningu aulka se kororingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesusi kinia yu lombili andolima kinia ono Gallilli nomu puringi kinia yombo awisili lombili puringila. Kolea Gallilli disiriki yomboma kinia, Judia disiriki yomboma kinia, kolea-awili Jerusalleme yomboma kinia, Idumia disiriki yomboma kinia, no Jodane nekendo lemó koleamanga yomboma kinia, kolea-awili Taya kinia Saidonotolo lierimu koleamanga yomboma kinia, aku koleamanga moloringi yomboma pali Yesusi uluma sepa molorumu mele pilkuli yu molorumuna oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesusini yombo awisili sepa peanga sirimu-kulu yombo kuru lupa lupa torumumane ‘Yu ambolamili.’ ningu yu gilierimuna nondoko pungíndu ekelepa seringi-kulu Yesusini yu lombili andolimando nimbale: “Yombo paa awisili ongo molemele. Yomboma na molombona nondoko ongo ekelepa naa sangi kene sipi se nondoko mengo ongo taltangi. Na molombona yomboma nondoko ongo ekelepa senge kinia sipina sukundu pumbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","⸤Yombomanga konopumanga⸥ kuru moloringimane yu kanokole alieli komorongo toko pondoko tondolo ru ningu ninguli: “Nu Pulu Yemonga Malo.” niringi, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","aku-na-kolo Yesusini onondo nimbale: “Yu ⸤sika⸥ molemo mele ⸤yombomane naa piliangi kene⸥ paa naa ningu para siee!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","⸤Pe walte⸥ Yesusi yu ma-pangi senga ola pumbale yuyu pilipale ‘yu kinia pea kopu sepo molamili.’ nimba pilierimu yemando “Waa.” nirimu kinia yu molorumuna oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Oringi yemanga ye engaki rurepo lipa, yu kinia pea kopu seko molko, “Ono nanga kongonomo sende-pangi lipu mundumbu yema molangi.” nimba ono nimba taltorumu. ‘Ono koleamanga andoko Pulu Yemonga semane peangamo toko si-pungu, yombomanga konopumanga kuru molombama toko makoronge tondolomo ono-kinia pepili andoko toko makorangi lipu mundumbu.’ nimba kanu ye engaki rurepo aku sipa nimba taltorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kanu ye rurepo nimba taltorumumanga imbima i-sipa: Saimono (yunga imbi se Pita) yu keme, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Seperi malo Jemisi keme, Jemisi genu Jono keme, (olo imbi se Boanekesi sirimula. Boanekesi yunga ungu-pulumu mulú tolimunga malotolo.) olo kinia, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","⸤Pita genu⸥ Enderu keme, Pillipu, Batollomiu, Mateyu, Tomasi akupoko keme, Allapiasinga malo Jemisi keme, Tadiasi keme, “Olio Juda yomboma oliolio gapomano molamili.” niringi talape ye Saimono keme, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judasi Isikeriote, Yesusi pe lipa opa-touma sirimu yemo keme, ⸤aku yema ‘yunga kongonomo sende-pangi lipu mundumbu.’ nimba taltorumu yema⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kanu-kinia Yesusi kinia yu lombili andolima kinia ono ulka senga sukundu puringi kinia yombo awisili akuna ongo liku maku toko moloringi-kulu ono kere-langi nonge ena se kepe paa naa lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kanu-kinia Yesusi pulu lierimu yomboma ⸤Yesusini aku serimu mele⸥ pilkuli “Kangomo paa amu tomu.” ningu yu lingí oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye mare Jerusalleme molko oringi kanu yemane ninguli: “Kurumanga nokoli Belsipuli Yesusinga konopuna molopale yu tondolo silimú-na yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aku siku niringi pilipale ⸤Yesusi Setene-kinia opa-tou moloringilimunga ‘Setenene yu naa lipa tapondolka paa piliangi.’ nimba⸥ Yesusini onondo “Waa.” nimbale onondo ungu-iku topa nimbale: “Setenene Setene yuyu nambi sepa topa makorombaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yombo talape se konopu seluna naa pupili molko suku-singina ówa panjiku ono onono opa seko lupa lupa molemele kinia kanu talapemo pora nilimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","⸤Molo⸥ ulka seluna pelemele yomboma konopu seluna pupili naa molko ono onono opa selemele kinia kanu yombo talapemo sungu siku yu-mele-mele molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aku sipala, Setenene yunga kuru se makorolkanje aku selkamonga yunga talapemo kinia opa mele selka. Pe yunga talapemo manda naa molemolá. Pora nilka. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ye enge nili sene yunga ulkamo nokopa kondolemo kinia ye sene we manda sukundu omba mélema wa lipa memba pulimúye? Akumu manda mólo. U wa noli yemone ye enge nílimunga kimbu kima ka topale yunga ulkana manda omba mélema wa limú kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“⸤Akumunga⸥ nane onondo paa sika nimbu sikiru: “Yombomane ulu-pulu-kirima seko ⸤Pulu Yemo⸥ ungu-taka tondoko ningu kinjilimili uluma kinia, ononga ulu-pulu-kiri wema kinia pali ⸤Pulu Yemone⸥ ‘Mania pupili.’ nimba siye kolomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aku-sipa na-kolo yombo sene Mini Kake Sélimu ungu-taka tondopa, nimba kinjipa, marake selemo yombomo yu Pulu Yemone aku sipa ulu-pulu-kiri selemoma ‘Mania naa pupili.’ nimba paa siye naa kolomba. ‘Alieli pepa mindi pupili.’ nimbá.” nikiru.” ⸤nimba Yesusini⸥ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Onone “Yu kuru se yunga konopuna molemo.” niringimunga ⸤aku siku Mini Kake Sélimu ningu kinjeringimunga⸥ Yesusini onondo aku sipa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kanu-kinia yombo awisili mania ⸤molko⸥ Yesusini ⸤mane sirimu unguma pilku⸥ molangi yunga anumu kinia genupili keme yu-kinia ungu ningíndu ongo pena gilku “Yu-kinia ungu niemili opili.” ningu ungu se ningu mundoringi kinia yombomane yundu ninguli: “Aminia kinia genali keme nu-kinia ungu ningíndu ongo pena gilimili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesusini onondo pundu topa nimbale: “Nanga anumu nawe? Nanga genupili namele?” nimbale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","yunga ungumu mania molko pilku moloringi yomboma neme-neme nimba kanopa nimbale: “I yomboma nanga anumu kinia nanga genupilima molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pulu Yemone “Sangi” nilimú mele pilku liku selemele yomboma nanga anumu kinia nanga genupili kemulupilima keme molemelemonga aku sipu nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Walte Yesusi kelepa ⸤Gallilli⸥ nomu kelona pumba yomboma mane sipa molorumu kinia yombo paa awisili yu molorumuna ongo maku toko moloringimunga nona andoli sipi se lierimumunga suku pumba mania molorumu, yomboma nomu kelona gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yuni onondo ungu awisili nimba simbando ungu-iku pokore torumu. ‘Ono mane siembo.’ nimbale ungu-iku se i-sipa topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Piliame. Ye sene rasi-witi umbu kaliana andopa tanda sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tanda silipa andorumu kinia umbu mare aulkana mania purumu, kanuma keramane ongo liku noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Umbu mare kou perimuna mania pumbale ma kanga-kolte mindi lierimu-kulu nondopa tóko nimba wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aku-na-kolo pulkonio naa mundorumu-kulu ena serimu kinia kanuma kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Umbu mare siri-ka mele molorumuna mania purumu, siri-ka mélemo wendo omba witi-umbuma topa norumu-kulu omba peanga naa lepa mongo se naa torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Umbu mare ma peangana mania purumuma wendo wendo omba akopale mongo peangama torumu. Mare mongo towapu-selu mele topa, mare mongo towapu-talo mele topa, mare towapu-kise mele torumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aku nimbale “Yombo komu-pea lemomane i ungumu piliaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pe we-yomboma pali puringi kinia yu lombili andoli ye engaki rurepo kinia yombo mare pea yu kinia moloringima kinia, onone yu mangilku ninguli: “Nu yombomando ungu se ninindu nambi semu-na ungu-iku tolenoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Yuni onondo pundu topa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma kinia mélema kinia nokolemomonga ulu-pulu u yuyu pilierimu kanu ulu-puluma ‘Kiniá ono ⸤na lombili olemele yomboma⸥ piliangi.’ nimbale ono nimba sikimu. Aku-sipa na-kolo ultu molemele yomboma ‘Unguma nimbu siembo.’ nimbuli ungu-ikuma mindi topo siliu. ⸤Pulu Yemone Aisayanga kerena nimbale:⸥ ‘Ono mongone kanokole naa kanoko, komuni pilkuli naa pilielemele. Konopumuni pilkuli topele tolemolá kinia, ⸤Pulu Yemone⸥ ononga ulu-pulu-kirima ‘Mania pupili.’ nimba siye kolka.’ nirimu akumunga we-yombomando ungu-ikuma mindi tolio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aku nimbale Yesusini onondo kelepa nimbale: “Ungu-iku topo nindu akumunga ungu-pulumu naa pilielemeleye? Akumu naa pilkuli we-ungu-ikumanga pali ungu-puluma nambi seko pilingíye? ⸤Ungu-ikumunga pulumu i-sipa:⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kere-langi umbu tanda sirimu yemone tanda sirimu umbuma ⸤Pulu Yemonga⸥ ungumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Umbu mare tanda sirimu aulkana mania purumuma yombo mare aku siku mele molemele. Onone ungumu pilielemele kinia pe ⸤kurumanga nokoli⸥ Setenene sumbi sipa omba ungu tanda sili konopuna pumba pelemoma wendo limú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aku sipala, umbu mare tanda sirimu kou perimuna mania purumuma yombo mare aku siku mele molemele. Onone ungumu pilkuli waltikele sumbi siku konopu siku pilku limili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aku-na-kolo ono pulkonio naa mundukuli ungumu kanga-kolte mindi pilku molemele. Pe ono konopuna umbuna selemo kinia molo ono ⸤Pulu Yemonga⸥ ungumu pilku liku molemele mele yombo lupamane kanoko kiri pilkuli ungu-taka tondoko seko kinjiku mindili silimili kinia ononga pilielemele unguma siye kololemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Umbu mare tanda sirimu siri-ka mele molorumuna mania purumuma yombo mare kepe aku siku mele molemele. Onone ungumu pilielemele-na-kolo konopuna umbuna selemo umbunama kinia, méle awisili taltokole ‘Aku mélemane olio lipa tapondolemo tapondomba.’ ningu pilku molemele uluma kinia, méle naa taltolemelema yakala kolko ‘liemili.’ konopu lemele ulu mare kinia, kanu sili ulu mare wendo omba ungu kanumu topa nolemo kinia ungumuni uluri naa sepa kere-langi mongo naa tolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Umbu mare tanda sirimu ma peangana mania purumuma yombo mare aku siku mele molemele. Onone ungumu pilkuli ungu-pulumu pilku kondoko ungumu kamu pilku limili. Pe ono kere-langi mongo mele tolemele. Kanu yombo marenga kere-langi mongo towapu-selu mele topa, yombo marenga mongo towapu-talo mele topa, marenga mongo towapu-kise mele topa, aku sipa tolemo. ⸤Ungu-ikumunga ungu-pulumu aku sipa.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","⸤Aku nimbale ungu-iku se pea topa nimbale:⸥ “Yombomane sepe-llame kandokole mingina sukundu panjilimiliye? Molo polo maniakondo taltolemeleye? Polo senga ola taltolemele kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aku sipa mele, kiniá lopi selemo mélema pe walte mona lemba yomboma kanonge; kiniá aki topa lemó mélema pe walte pa sembá kinia yombomane kanu mélema kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yombo komu-pea lemomane ⸤ungu nikirumu⸥ piliaa.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Onone ungu pilielemele akumu mimi siku piliangi. Onone mélema yomboma silimili mele ⸤Pulu Yemone⸥ ono aku sipa méle kalomba. Mare olandopa simbala. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mélema taltolemo yombomo nane mare pea simbú, yu paa awisili taltomba. Aku-sipa na-kolo mélema naa taltolemo yombomo yu taltolemoma kepe wendo limbu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesusini ungu se pea nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu i-sipa mele: “Ye sene kere-langi umbu mana tanda silimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aku yemo ipulieli uru pepa, tangoli ola molopa ⸤andopa kongono sepa⸥, selemo kinia kere-langi umbu tanda silimúma tóko nimba omba akolemo-na-kolo aku sipa selemomonga pulumu yemone nimba naa kanopa naa pilielemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kere-langi umbu tolemoma mamone yu yuyu ‘wendo opili.’ nilimú. U kumbi lepa tóko nilimú. Pe gomo tolemo. Pe kere-langi mongo tolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pe kere-langi nou lemó kinia ‘Kere-langi inia topo sukundu sukundu limbu walemo wendo okomo.’ nimbale kere-langi umbu tolemo yemone kere-langi inia tolemo. ⸤Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo aku sipa molemo.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pe Yesusini onondo kelepa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu nambolka mélse mele niemboye? ‘Yu kingimu molopa yomboma nokolemo mele piliangi nimbu siembo.’ nimbuli nambolka ungu-ikumu topo niemboye?” ⸤nimbale nirimumuni, kelepa ungu-iku se pea topa nimbale:⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo akumu unju masetete umbu mele. Yomboma kere-langi umbu kaliana mundulimilimanga pali unju masetete umbumu yu paa kangamo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Aku-na-kolo kaliana mundulimili kinia wendo omba akolemo kinia kaliana molemo mélemanga pali yu paa awilimu. Kamu akopa unju-mele gilimú kinia kerama kanu unju kolamanga ongo pelemele. Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo mele aku sipa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusini unguma yomboma nimba simbando ungu-iku awisili aku sipama topa sirimu. Ono manda pilingí mele topa sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ono ungu se nimba simbando ungu-iku se mindi torumu. ⸤Ungu se sumbi sipa naa nimba sirimu.⸥ Aku-na-kolo yu kinia yu lombili andolima kinia ono onono moloringi kinia yuni yunga ungumanga puluma pali ono sumbi sipa nimba para sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kanu walemonga kolea kala torumu kinia Yesusini yu lombili andoli yemando nimbale: “Nomu nekendo pamolo.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","nona andoli sipi senga Yesusi u suku molopale unguma nirimu akuna suku yu we molopili nomu kelona maku toko moloringi yomboma munduku kelko yu mengo puringi. Sipina puringi kinia sipi mare pea puringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kanu-kinia, nomuna pungí puringi kinia poporome paa awili se nomuna torumu. Aku serimu-na nomumu apisipa ola ombale no sipina sukundu sukundu omba peke lepale sipimu memba nona mania pumbá serimu, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","aku-na-kolo Yesusi sipimunga bulkundu penge-kanda wale senga we uru perimu. Yu lombili andoli yemane yu toko makisindiku ninguli: “Ungu Mane Sili Yemo, olio nona wangopo kolomolomonga nu mini-wale naa pukumuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yu makilipale poporomemo iri topa nomumundu nimbale: “Taka leko molou!” nirimu kinia poporomemo topa kelepa nomumu lope naa sepa paa we lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kanu-kinia yuni lombili andolimando nimbale: “Ono nambi semu-na mini-wale mundukumiliye? ⸤Selio mele wale awisili kanolemele-na-kolo⸥ yandopa kiniá kepe ‘Olio naa nokombanje.’ ningu pilku kuru naa mondolemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","⸤Yuni serimu mele kanokole⸥ yemane mini-wale munduku pipili awili seko kolkole anju yando onono mangilku ninguli: “Apa! I yemo nawenje? Poporomemone kepe nomumuni kepe yunga ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kanu-kinia, ⸤Yesusi kinia yu lombili andoli yema kinia⸥ ono ⸤nona andoli sipina⸥ nomu nekendo pungu kolea Gerasa puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Akuna oringi kinia Yesusi sipina wendo orumu kinia konopuna kuru molorumu ye se, yombo-óno-koleana pelepa andorumumu popenge sepa wendo omba yu molorumuna orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Kanu yemo, yombo-óno-koleana yunga perimu koleamo lierimu. ⸤Kurumu yunga konopuna molorumumunga yu paa enge nirimu-kulu⸥ yombomane yu alieli-alieli ka wemane kinia, ka-sénene kinia kepe yu kimbu kima ka toringi ka-sénema yu sungu sipa, kimbutolo anakapa toko panjeringimu elke-malke tondorumu. Ye seluri kepe enge se perimu-na ‘Yu taka lepa molopili.’ nimba manda ambolopa nokomba ye se paa naa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Alieli, ipulieli kepe tangoli kepe, yombo-óno-koleana kinia ma-pangimanga kinia kalli nilipa andopa, yunga kangimu yu yuyu kou ⸤nee gilieli⸥ marene kopisilipa andopa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Kanu yemone sulu sepa molopa Yesusi kanopale yu molorumuna lisipa orumu. ⸤Orumu kinia⸥ Yesusini nimbale: “Kurumu, i yemonga konopuna ongo wendo pu!” nirimu mele pilipale yemone yunga kumbikerena komorongo langopa tamalu pepa yundu tondolo ru nimba nimbale: “Yesusi, Pulu Ye Paa Olandopa Awilimunga Malo, na-kinia ungu nambolka unguri senindu onuye? ‘Pulu Yemonga imbimu leko mi leko “Paa sika nikiru. Na mindili paa naa lipu simbú.” ni!’ nimbu mawa sekero.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aku nirimu kinia Yesusini yemondo mangilipa nimbale: “Nunga imbi nawe?” nirimu kinia yuni nimbale: “⸤Olio paa awisili kene⸥ nanga imbi Paa Awisili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aku nimbale wale awisili Yesusi mawa sepa nimbale: “Olio ‘ongo wendo pangi.’ ningu toko makorokole “I koleamo munduku kelko kolea luparenga paa.” ni naa ni.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akuna ma-pangi senga umbu-kongi awisili ímu nongo moloringi kanokole ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kurumane Yesusi mawa seko ninguli: “Olio ⸤toko makorokole⸥ “Ne kongima molemelena pungu, ononga konopuna molo-pangi.” ni.” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yuni “Manda, akuna pangi.” nirimu kinia kuruma kanu yemonga konopuna wendo ongole kongi akuna moloringimanga konopumanga pungu moloringi kinia kanu kongima amu toko lisiku pungu kopona pukua toko nomuna sukundu pungu nona wangoringi. Kongi kanuma ⸤paa awisili,⸥ tausini talo mele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","⸤Ulu akuma wendo orumu-na kanokole⸥ kongi tapu seko moloringi yema talopa leko punguli niringimuni, kolea awilina moloringi yomboma kinia, kolea kangamanga moloringi yomboma kinia, ulu akuma wendo orumu mele semane toko siliku puringi. Kanu semanemo pilieringi yomboma ‘Uluma wendo orumu mele kanamili.’ ningu wendo pungu ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusi molorumuna ongole u kuru paa awisili konopuna molko ongo wendo puringi yemo mulu-maminia pakopa, umbu-konopu pepili molorumu kanokole ono pipili koloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yesusini serimu mele mongone kanoringi yombomane pe oringi yomboma ningu siringi. Kuru awisili konopuna moloringi yemo kinia, kongima-kinia uluma wendo orumu mele semanemo toko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kanu-kinia yomboma ⸤paa mini-wale mundukuli⸥ Yesusi mawa seko ninguli: “Olionga koleana naa mololi kelko pu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aku siku niringi pilipale Yesusi pumbándo nona andoli sipina suku pumbá purumu kinia kuru awisili konopuna u molko wendo oringi yemone yundu nimbale: “Pea pambili.” nimba mawa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aku-na-kolo Yesusini “Mólo.” nimba yundu nimbale: “Nu ulkondo pungu Ye-Awilimuni nu kondo kolopa ‘Molko kinjenu mele pora nipili.’ nimba, lakopa sepa kondomu mele nunga pulu lemó yomboma ningu si-pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yesusini aku nirimu-na pilipale ye kanumu pumba yunga kolea, ‘Kolea-Awili Rureponga Talo’ niringi koleana andopa Yesusini lakopa sepa kondorumu mele nimba sirimu. Nimba sirimu kinia pilkuli yomboma pali paa pungu-pungu ningu mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesusi ⸤yu lombili andolima kinia⸥ nona andoli sipina sukundu pumba nomu yakondo kelepa ombale nomu kelona wendo orumu kinia yombo awisili yu molorumuna ongo liku maku toko kakapu seko moloringi. Yu nomu kelo akuna molopili ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka se nokorumu ye se, yunga imbi Jairasi, Yesusi molorumuna orumu. Kanu-kinia yu Yesusi kanopale Yesusi yunga kimbuna nondopa omba mania molopa tamalu pepa ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yundu tondolo mundupa mawa sepa nimbale: “Nanga bola-nanamo nondopa kolomba sekemo kene ‘Yu konde pumba manda molopili.’ ningu ongo yu kimuni ambolou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aku nirimu-na pilipale Yesusi yu pea puringili. Pungilí puringili kinia yombo awisili liku maku toko lombili pungu yu kakapu seko ekelepa seko pea puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kanu-kinia ambo se molorumu kanumunga pena perimu walema pora naa nirimu. Yu pena mindi pepili kalia-ingi engaki rurepo omba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yu doketa awisilimanga yunga kurumu ‘Pora nipili.’ nimba andorumu-na-kolo mindili mindi siringi. Yunga kou-mone pali ono sirimu-na-kolo yunga kuru pora naa nirimu. We topa olandopa mindi purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kanu ambomo Yesusi ulu-tondoloma serimu mele semanema pilipale yomboma maku toko gilieringina sukundu omba Yesusinga bulkundu omba yunga wale-pakolimu ambolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‘Yunga wale-pakolimu mindi ambolondu liemu na peanga lemba.’ nimba pilipale aku serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","⸤Ambolorumu kinia⸥ waltikele yunga kuru torumu kanumu pora nirimu, yunga kangimu u umbuna perimu mele peanga lierimu pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aku-sipa na-kolo ⸤yu Yesusinga wale-pakolimu ambolorumu kinia⸥ Yesusi yuni yomboma lipa tapondoli tondolo mare yunga kangina omba ultu purumu sumbi sipa pilipale topele topa kanopa yombomando mangilipa pilipale, “Nanga wale-pakolimu nawene ambolomuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aku-na-kolo ⸤yuni mangilierimu mele pilkuli⸥ yu lombili andoli yemane pundu toko ninguli: “Yombo awisili nu gilinuna nondoko nondoko ongo kakapu seko ekelepa seko gilkimili kanumu. Pe nambi semu-na “Nawene na ambolomuye?” nikinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Aku-sipa na-kolo Yesusi mongo male-male sepa koropale “Akumu nawene semuye?” nimba we gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kanu-kinia tondolo sene yunga kangina kurumu pora nirimu pilipale ambomo paa pipili kolopa kangima puru-puru nipili Yesusi molorumuna omba mania molopa tamalu pepale yu ulu serimuma pali nimba para sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesusini yundu nimbale: “Bolamo, ‘Nu manda sepa peanga simba.’ ningu kuru mondonu kanu ulumuni nu peanga lekemo. Nu kuru pora nimba konopu pe nipili molo-pani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesusini ambomondo aku sipa nimba molorumu kinia, ye mare, yomboma maku toko Pulu Yemonga ungu pilieringi ulka nokoli ye Jairasinga ulkana molkole ongo ⸤Jairasindu⸥ ninguli: “Nunga bolamo kolopa pora simu. Nambi semu-na Ungu Mane Sili Yemo ‘Mindili nopili.’ ningu we mengo oniye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aku-na-kolo Yesusini ono niringi ungumu pilipa naa lipale ulka nokoli yemondo nimbale: “Mini-wale naa mundoyo. ⸤Nunga bolamo nane ‘Manda lipa tapondomba.’ ningu⸥ kuru mondou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kanu-kinia yuni maku toringi yombomando “Naa ongo anju paa.” nimbale Pita keme Jemisi keme genu Jono keme akuma mindi lipale “Pea pamolo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ulka nokoli yemonga ulkana oringi kinia yombo awisili molko kondo kolko kola awili-seko seko moloringi kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yu ulka sukundu pumbale yombo moloringimando nimbale: “Ono nambi semu-na kola seko kalli ningu molemeleye? Bolamo kolou naa kolomu. We uru mindi pelemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aku-na-kolo aku nirimu kinia onone yu ungu-taka tondoko tawe senderingi. Yomboma pali makoropa pena-pena sepale, bolamonga anumu lapatolo kinia, kanu lombili andoli ye pokore kinia lipa memba bola ónomo lierimu suluminiana purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pumbale bolamonga kimu ambolopa Juda yombomanga ungu lepa yundu “Tallita kumi!” nirimu. (Ungu akumunga pulumu i-sipa: “ “Bolamo, nu ola molou.” nikiru.” nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aku nirimu kinia bolamo popenge sepa ola molopale andorumu. (Bola kanumu kalia-ingi engaki rurepo mele omba pupili yu molopale kolorumu kinia Yesusini omba sepa konde liltimu.) ⸤Akumu kanokole⸥ yu kinia moloringi yomboma pungu-pungu ningu mini-wale awili seko mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kanu-kinia Yesusi yuni onondo tondolo mundupa nimbale: “Ungu i sekeromo yombo selurindu kepe anju pungu paa naa ningu siee!” nimbale ⸤anumundu⸥ nimbale: “Bolamo kere-langi mare liku si.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesusi molorumu koleamo mundupa kelepa yunga pulu-kolea ⸤Nasarete⸥ purumu, yu lombili andoli yema pea puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","⸤Koro moloringi⸥ wale Sambatemo wendo orumu kinia ono maku toko Pulu Yemonga ungumu pilieringi ulkana sukundu pumbale yomboma mane sipa molorumu. Yunga ungumu pilku moloringi yombo awisilini pungu-pungu ningu mini-wale munduku ninguli: “Ne yemo aku unguma sena liltimunje? Yunga pilipa kondolimu kinia yunga ulu-tondolo selemomanga tondolomo kinia yu sena liltimuye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yu ulkama takondorumu yemo móloye? Yu Maria malo móloye? Jemisi, Josepo, Judasi, Saimono keme, akuma yu ononga genu móloye? Yunga kemulupili olio kinia pea naa molemoloye? ⸤Yu paa sika aku yemo molemomo⸥.” niringi. ‘Yu paa we-yemo nambi sepa i tondoloma yu-kinia pelemoye?’ ningu pilkuli ono yu kanoko kiri pilku yu-kinia paa konopu kiri panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kanu-kinia ⸤ono yu-kinia mumindili koloringimunga ulu-pulumu pilipale⸥ Yesusini onondo nimbale: “Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye se koleamanga pali imbi ola molemo, yombomane pali yunga unguma pilku limili. Aku-sipa na-kolo yunga koleana yu-kinia pea kopu seko molemele yomboma kinia, yunga pulu lemó yomboma kinia, ono mindi yuni nilimú ungumu pilkuli ‘Yu olionga we-yere. Yu imbi mololi ye se mólo.’ ningu yu nilimú unguma naa pilku, mokoli selemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","⸤Yunga ungumu pilku mokoli seringi-kulu⸥ kolea akuna yuni ulu-tondoloma manda naa serimu. Kuru torumu yombo selu selu nimba mindi kimuni ambolopale sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yu ⸤ungu nimba uluma sepa molorumu mele⸥ ‘Sika.’ ningu kuru naa mondoringimunga yu paa konopu awisili kimbu sirimu. 6:6—8:21 Kanu-kinia Yesusi kolea-kanga lupa lupamanga andopale ⸤Pulu Yemonga ungumu⸥ mane silipa andorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesusini yu lombili andoli engaki-rurepondo “Waa.” nimbale onone yombomanga konopumanga kuru molemoma “Ongo wendo paa.” ningu toko makoronge tondolomo sipale ono talo talo nimba “Koleamanga ando-paa.” nimba lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","⸤Lipa mundupale⸥ ono senge mele ungu-mane sipa nimbale: “Pungíndu ono mélema naa meangi. Apulu-mingima mindi liku ambolko pangi. Kimbu-su mondonge manda-na-kolo wale-pakoli talo kepe kere-langi kepe méle-wale kepe naa mengo, kou-mone kakona kepe naa panjiku we pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Pe kolea senga sukundu punguli akuna molongendo ulka seluringa sukundu punguli akuna mindi peko molkole pe aku koleamo munduku kelko pangi. ⸤Ulka pinia-pinia naa andoko ulka seluringa mindi kere-langi nongo peangi.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kolea marenga sukundu pungí kinia kolea pulu-yombomane “Pea peamili waa.” ni naa ningu onone ungu ningíma pilku naa língi liemu kanu koleana yombo kirima munduku kelko pungíndu kanu koleana yombomane ono “pea peamili.” naa ningu ononga unguma naa pilku liltingimunga ‘Ono kamu molko kinjangi! Pulu Yemone ono lipa naa tapondomba mele piliangi.’ ningu ononga kimbuna kanu koleamanga ma gilimbama kulu toko pangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","⸤Yu lombili andolima yuni aku sipa lipa mundorumu-na pilku⸥ punguli yombomando ninguli: “Ulu-pulu-kiri selemelema kanoko kiri pilku konopu topele taa.” ningu ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","yombomanga konopuna kuru awisili moloringima ⸤ ‘Ongo wendo paa.’ ningu⸥ toko makoroko, kuru torumu yombo awisili ‘Peanga liepili.’ ningu ononga kangina unju ollipi-mongo no ondoko kandondoko seko peanga siku, selko andoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kanu-kinia Yesusi yunga imbimu yomboma pilku lieringimunga ye nokoli kingi Erote Yesusini serimu mele semane toringi pilierimula. ⸤Yesusini sepa nirimu mele pilkuli⸥ yombo marene ninguli: “I uluma selemo yemo No Lindeli Jono lepomo! Yu kolopale lomboropa wendo omumunga ulu-tondoloma sembá tondolomo yu-kinia pelemo.” ningu moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yombo marene ninguli: “Yu ⸤u konde molopili Pulu Yemone olando liltimu ye⸥ Illainja kelepa omba molemo.” niringi. Yombo marene ninguli: “Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi ye koro-u moloringi yema mele yu aku sipa Pulu Yemonga ungu-umbu tondolemoma pilipa yando nimba silimú yemo molemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","⸤Yombomane aku siku ningu pilieringi⸥-na-kolo ye nokoli kingi Erotene ⸤Yesusi yuni serimu mele semane toringi⸥ pilipa nimbale: “I uluma selemo yemo ⸤No Lindeli⸥ Jono, ‘Yunga pengemo wendo pupili.’ nimbu nomi kari lierindu kanu yemo. Yu kolopale lomboropa wendo omu lepomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","⸤Kingi Erotene aku sipa nirimu ungumunga pulumu i-sipa:⸥ U walte Erotene yunga genu Pillipunga ambo-menu Erodiasi mangopa liltimu. ⸤No Lindeli⸥ Jonone Erote aku sipa serimu kanopale yundu alieli nimbale: “Nuni ⸤Pulu Yemonga⸥ ungu-mane se pulua toko genanga ambomo mangoko liltinu. Akumu seko kinjerinu.” nirimu kinia Erotene yu lipa ka sipa ka-ulkana panjerimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Jonone aku nirimumunga ambo Erodiasini yu mumindili kolopa “Yu topo kondambo.” nimba molorumu-na-kolo Erotene ‘Jono yu konopu sumbi sipa pepa Pulu Yemonga ye kake sélimu molemo.’ nimba kanopa yu pipili kolopale nokopa kondorumumunga ambo Erodiasini Jono-kinia ungu se manda naa serimu. Jonone ungu nirimuma pilipale ye nokoli kingi Erote yu paa konopu awisili lipa mundupa mini-wale mundorumu-na-kolo aku unguma yu paa konopu sipa pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pe walte, ⸤ambo Erodiasi⸥ konopuni pilipa molorumu ungumu manda sembá walemo wendo orumu. Wendo orumu mele i-sipa: Kingi Erote meringi walemo wendo orumu kinia yunga kendemande-ye awilima kinia, yunga ami-yemanga ye nokolima kinia, kolea Gallilli disiriki yombomanga ye nokoli awilima kinia, onondo “Kere-langi pea namili waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","⸤Ono ongo yu-kinia pea kere-langi nongo molangi⸥ Erodiasi lemenu ulkana sukundu omba ono moloringina denisi serimu. Erote kinia, yu-kinia pea kere-langi nongo moloringi yema kinia onone ambo-wenepomo aku serimu kanoko paa peanga pilieringi. Kingimuni paa kanopa peanga pilipale ambo-wenepomondo nimbale: “Nuni yakala kolkono mélse na mawa séa. Mawa sení mélemo nu simbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pulu Yemonga imbi lepa mi lepale yundu kelepa nimbale: “Paa sika nikiru. Nuni na mawa sení mele se paa sika simbú. Nane ye nokoli kingimu molopo nokolio koleamonga ekendo kepe “Si.” ninu liemu paa sika simbu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Erotene yundu nirimu mele pilipale ambo-wenepomo pena pumba, anumu molorumuna pumba mangilipa nimbale: “Méle nambolka mélemo ‘Si.’ niemboye?” nirimu kinia anumuni nimbale: “ “No Lindeli Jononga ⸤nomimu kari leko yunga⸥ pengemo si.” ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anumuni aku nirimu pilipale yu kingimu molorumuna popenge sepa lisipa omba mawa sepa nimbale: “Paa iseli-u No Lindeli Jono ⸤nomi kari leko⸥ yunga pengemo pellete senga taltoko yando si.” nirimu. ⸤Jonone u alieli “Erote kinia Erodiasitolone seko kinjeringili.” nirimumunga mumindili kolopale Erodiasini ‘Yu kolopili. Sika kolomunje na kanambo.’ nimba “Pengemo ongo si.” nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yuni aku sipa mele mawa serimu kinia pilipale Erote paa konopu umbuna serimu-na-kolo yuni “Paa sika simbú.” nimba, nimba panjipa Pulu Yemonga imbi lepa mi lierimu mele kepe, yu konopu topele tomba kinia yu-kinia pea kere-langi nongo moloringi yema yu kanoko kiri pilingí mele kepe, aku ungutolo pilipale, “Yuni mawa sepa “Si.” nikimu mele “Mólo.” manda naa nimbú.” nimba pilipale ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","yu nokoringi ami-yemanga se lipa mundupale “⸤No Lindeli⸥ Jono ⸤nomi kari leko⸥ yunga pengemo yando mengo ou.” nirimu kinia kanu ami-yemone ka-ulkana pumba Jononga nomimu kari lepale ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","yunga pengemo pellete senga taltopa yando memba omba ambo-wenepomo sirimu kinia yuni anumu sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aku seringi pilkuli Jono lombili andoringi yema ongo yunga ónomo liku mengo pungu óno seringi. ⸤Kingi Erotene No Lindeli Jono u aku sipa topa kondorumu kolorumumunga pe Yesusini ulu-tondoloma serimu mele pilipale “Jono nomi kari lierindu yemo lomboropa ola molemo lémo.” nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesusini “Nanga kongonomo sende-paa.” nimba lipa mundorumu yema yu molorumuna kelko yando ongole niringimuni, ulu seringima kinia yomboma ungu-mane siringima kinia yu semane toko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aku-sipa na-kolo yombo awisili ongo pungu ongo pungu ⸤seko ungu ningu panjiku⸥ seringimunga Yesusi kinia ⸤yuni lipa mundorumu ye yando oringima⸥ kinia kere-langi nonge ena kanga-kolte kepe naa lierimumunga kanopale Yesusini yemando nimbale: “Ono onono yombo naa mololi kolea ku senga kanga-kolte koro molangi kene na-kinia pea pamili waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanu-kinia ono onono mindi nomuna andoli sipi senga suku pungu yombo naa mololi kolea ku lieli senga puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Aku-sipa na-kolo pungí puringi kinia kanokole yombo awisili Yesusi kinia yu lombili andolima kinia kanoko imbi siringimunga koleamanga yomboma pali kimbu-kongono seko lisiku nomu kelona makaye seko pungu ono nomuna wendo pungí koleana kumbi leko pungu nokoko gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesusi nomu kelona ultu omba kanopa yombo paa awisili akuna ongo maku toko moloringi kanopale ono kongi sipisipi tapu seli ye se naa mololi sipisipima mele ku peko moloringi-kulu nimba kanopale ono kondo kolopa ungu awisili mane simba serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kanu-kinia ⸤mane sipa molopili⸥ ena pumbá serimumunga yu lombili andolima yu molorumuna ongo yundu ninguli: “I koleana yombo se naa pelemele, ena kamu pukumu kene ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ya maku toko molemele yomboma “Pungu kolea marenga kere-langi topo toko li-pangi.” ni.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aku-na-kolo yuni ⸤yu lombili andolimando⸥ pundu topa nimbale: “Onone onono yomboma kere-langi mare liku siee.” nirimu. Onone yu mangilku ninguli: “‘Kakopoi-ye sene oli engaki kongono sepale méle kalólimu limú kou-monemane olio kere-langima topo topo lipuli yomboma siemili.’ ningu nikinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","⸤Aku siku niringi pilipale⸥ yuni ono mangilipa pilipa nimbale: “Pellawa kaloli nambi sepa taltokomeleye? Pungu kano-paa.” nirimu. Pungu koroko kanoko lendeko yu molorumuna kelko ongo ninguli: “Ya kere-langi awisili naa taltolemele. Pellawa kaloli kanga se-pakara kinia oma kaloli talo kinia ⸤aku kere-langi pokore mindi lemó⸥.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kanu-kinia Yesusini nimbale: “Yombomando “Era kondili nilina maku toko mania molangi.” niee.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","yomboma towapu talo molo towapu kise ningu maku toko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kanu-kinia Yesusini pellawa kaloli se-pakara kinia oma talo kinia kanuma lipale mulu-koleana olando-sipa kanopa ⸤Pulu Yemo kinia⸥ “Ange.” nimba pellawa kalolima ambolopa peke lepa lombili andolima moke sepa sipale “Anju yomboma siee.” nirimu, ⸤onone⸥ yomboma ⸤moke seko siringi⸥. Oma talo kepe lipa moke sepa yomboma pali sirimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ono pali kanu kere-langima noringi kinia olo serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kanu-kinia lombili andolimane pellawa kaloli kinia oma kinia kanumanga kakena lierimuma liku maku toko wale-basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kere-langi noringi yema-manjipa paip tausini mele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","⸤Yomboma kere-langi sirimu noringi⸥ kinia Yesusini yu lombili andoli yemando sumbi sipa nimbale: “Maku toko molemele yomboma nane “Pangi.” niembo. Ono nona andoli sipina ola pungu no nekendo, Besaida taono lemóna, kumbi leko paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kanu-kinia yomboma mundupa kelepale yu yuyu Pulu Yemo kinia ungu nimbando ma-pangina ola purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kanu-kinia ena pumba kolea kala torumu kinia sipimu nomu awi-suku-singina purumu, Yesusi yuyu ma-⸤pangi⸥na molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sipi kumbikundu mendo sipa poporomene torumumunga ⸤yu lombili andoli yema sipina suku molkole⸥ sipimu nomu kelona mengo pungíndu pereringi kanopale ipulieli kolea muni naa liepili ono puringina yu nona ola kimbu anjipa ombá ombale ono sipina pungu molangi yuni ono topa akilendepa yu kumbi lepa pumbá orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Aku-na-kolo yu lombili andolimane pali yu nona ola kimbu anjipa orumu kanokole niringimuni, paa pipili awili seko kolkole “Kuru se okomaa!” ningu mini-wale mundoringi kinia Yesusini popenge sepa onondo nimbale: “Ono konopu tondolo pupili molayo. Na mindi okoro. Pipili naa kolaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Kanu-kinia yu sipina suku purumu kinia poporome topa kelierimu. Aku serimu-na kanokole paa mini-wale mundoringi. Yuni ⸤u tangoli⸥ pellawa kalolima ⸤moke⸥ serimumunga pulumu naa pilku we konopu lo liku moloringi. Yu-kinia tondolo se perimu-na pellawa kalolima-kinia ulu-tondolo se serimu mele mimi siku naa pilkuli ono konopu naa perimu-na kanu tondolomone poporomemo topa kelierimu mele kepe naa pilkuli poporomemo topa kelierimu kinia kanokole ono paa mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","⸤Yesusi kinia yu lombili andolima kinia⸥ nomu ⸤Gallilli⸥ nekendo punguli nomu kelona kolea Geneserete lierimuna wendo ongole sipimu ka seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sipina mania oringi kinia akuna moloringi yombomane Yesusi popenge seko kanoko imbi sikuli ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","akundu lierimu koleamanga pali lisiku pungu yu andorumu koleama pilkuli ononga kuru torumu yomboma liku taropola seko yu andorumuna mengo oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yu andorumu koleamanga pali, kolea kangamanga kinia, kolea awilimanga kinia, kolea wemanga kinia, aku koleamanga yomboma maku toko moloringi koleamanga kuru torumu yomboma mengo ongo taltokole, “‘Nunga wale-pakoli pundumu kepe ambolangi.’ ni.” ningu mawa seringi. Kanu-kinia kuru torumu yombomane yunga wale-pakolimu amboloringi yomboma pali kamu peanga lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","⸤Walte⸥ Parisi ye mare kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye mare kinia ono Jerusalleme munduku kelko Yesusi molorumuna ongo maku toko moloringimane ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","yu lombili andolimane ki kalaro molopili u kulumiye naa toko kere-langi we ambolko noringi kinia kanokole kanoko kiri pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(⸤Sika kalaro naa molorumu-na-kolo⸥ Parisi yema kinia we-Juda-yomboma kinia ononga anda-kolepalimane “Saa.” niringi mele pilku liku sengendo u ki pali nona munduku kulumiye toko kondokole kere-langi pe noringi. We naa noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Makete-koleana pungu ulkando ongole ki u kulumiye naa tokole ⸤maketena topo toko liltingi⸥ kere-langima naa noringi. Anda-kolepalimanga seringi ulu-pulu lupa lupa awisili pilku liku seko moloringila. Kapoma kinia, mingima kinia, kere-langi noringi poloma kinia, aku sipa mélema alieli-alieli we kulumiye toringi.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","⸤Juda yombomane aku siku seringi⸥-kulu Parisi yema kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, onone ⸤Yesusi lombili andolimane aku siku ki kulumiye naa toko kere-langi we noringi kanokole⸥ Yesusindu mangilku pilku ninguli: “Anda-kolepalimane “Saa.” niringi mele nunga lombili andolimane nambi semu-na naa pilku liku selemeleye? Ononga kima kalaro molopili kere-langi nolemele kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesusini onondo pundu topa nimbale: “Ono ⸤ungu-manema pilku mane silimili yema kinia Parisi yema kinia⸥ ono topele-mapele toli yema molemele! Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane onondo nirimu mele papu nirimu. ⸤Onone kiniá selemele mele yuni u nimba Pulu Yemonga⸥ bokuna torumu molemo mele i-sipa: ⸤Pulu Yemone nimbale:⸥ “Kanu yomboma ononga keremane na kape ningu ‘Ye awili olandopamo. Nu lipu awi silimulu.’ ningu na imbi ambolko paka tondolemele-na-kolo ononga konopuma kinia nanga konopumu kinia seluna naa pulimú. Lupa lupa pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Onone ‘Nanga imbi ambolopo paka tondamili.’ ningu na we popo toko kape nilimili. Mana-yombomane mane silimili unguma mindi mane sikuli ‘I ungu-manema Pulu Yemone “Saa.” nilimú ungu-manema.’ ningu pilku liku selemele, akumunga na popo tonge kinia unguri naa sembá.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pulu Yemone “Saa.” nirimu ungu-manema munduku kelkole anda-kolepalimane “Saa.” niringi mele mindi ambolko molemele.” ⸤nimba Yesusini⸥ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","⸤Yesusini⸥ ungu mare pea onondo nimbale: “Ononga anda-kolepalimane “Saa.” niringi mele pilku liku sengendo Pulu Yemone “Saa.” nirimu ungu-manema bulu silimili mele papu selemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Akumunga Mosisini nimbale: “Aminieli lanielinga unguma pilku liku, liku awi siku saa.” nimba “Yombo sene yunga anumundu molo lapando ungu se nimba kinjipa iri tomu liemu kanu yombomo toko kondangi.” nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aku-sipa na-kolo ono ⸤Juda yombomanga tapu-yema⸥ne ninguli: “Ye sene yunga anumu lapatolondo nimbale: “Nane olo méle mare lipu tapondopo silkama koronga ‘Pulu Yemo simbú.’ nimbu panjerindu kanumunga olo manda naa lipu tapondopo simbú.” nimbale ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yunga anumu lapatolo naa lipa tapondomba kinia papu.” ningu mane silimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aku siku mane silimili ungumuni ‘Anda-kolepalimane mane siringi ulu-puluma olandopa.’ ningu ‘Pulu Yemone nirimu ungumu uluri molo. Mania pupili.’ nilimili. Onone ulu lupa lupa awisili aku siku seko molemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aku nimbale Yesusini maku toko moloringi yombomando “Na moliona waa.” nimba onondo nimbale: “Nane ⸤aku nikirumunga ungu se⸥ nimbú sekero ungumu onone pali komu sendeko ungumunga pulumu pilku kondayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yombomanga kangina ultukundu lepale kerena pumba olona sukundu pulimú mélsene ⸤Pulu Yemo manda popo tonge aulkamo pipi silimú⸥ kalaro se manda naa mondolemo. Yombomanga konopuna sukundu pepale wendo olemo ulumane mindi yomboma kalaro mondolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Yombo komu-pea lemba yomboma i ungumu mimi siku piliangi.” nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kanuna maku toko moloringi yomboma Yesusini mundupa kelepa ulkana sukundu purumu kinia yu lombili andolimane yu mangilku pilku ninguli: “Aku ungu-ikumunga pulumu nambolkanje? ningu para sieni.” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesusini onondo nimbale: “Kiniá kepe naa pilkimiliye? Yombo senga kangina ultu lepale sukundu pulimú mélse yunga konopuna naa pumba, olona sukundu pumba ultu omba le-muruna kamu pulimúmunga yu kalaro manda naa mondolemo mele naa pilkimiliye?” nirimu. (Yesusini aku sipa nirimumunga “Kere-langimane pali yomboma kalaro se naa mondolemo.” nimbando nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","⸤ “Kerena sukundu pulimú mélemane aku sipa unguri naa selemo.” nimbale⸥ yuni kelepa nimbale: “Yombo senga konopuna sukundu pepale wendo olemo kanu mélemane yombo se ⸤Pulu Yemo popo tomba aulkamo pipi silimú⸥ kalaro se mondolemo. Ulu-pulu-kirima u konopumuni pilkuli ⸤pe kamu selemelemonga⸥ “Konopuna pepale wendo olemo mélemane kalaro mondolemo. ⸤We naa selemele.⸥” ⸤nikiru.⸥ Kanu mélema i-sipa: Konopumuni ulu-kirima pilielemele; wa ulu-kirinale lupa lupama andoko selemele; wa nolemele; yomboma toko kondolemele; ambo ye pulima molo ye ambo lilima yombo lupama kinia ulu-kirinale selemele; ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yombomanga méle taltolemelema ‘Na liembo.’ nilimili; ulu-pulu-kiri lupa lupama selemele; kolo tolemele; yombomane kanokole pipili kololemele uluma pipili naa kolko sumbi siku selemele; yombo lupama molemele mele kepe ononga mélema yama mengo ‘Yu malo.’ konopu lemele; ‘Yomboma pipili kolko molko kinjangi!’ ningu ungu-bulkundu nindilimili; ‘Na imbi ola molemo. Na pilipa kondoli olandopa pelemo. Yombo lupama tondolo se naa pelemo.’ ningu kara pulimili; amu toli uluma selemele; ulu-pulu akuma pilku selemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aku ulu-pulu-kirima pali yombomanga konopuna sukundu pepa wendo olemomane yomboma kalaro mondolemo, yomboma ⸤Pulu Yemonga kumbikerena pungí aulkamo pipi silimú⸥ kalaro mondolemo. ⸤Ultu lepa olona pulimú mélemane unguri naa selemo⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kanu-kinia Yesusi molorumu kolea ⸤Geneserete⸥ mundupa kelepa ⸤Juda yomboma moloringi kolea Gallilli disiriki ultukundu⸥ kolea-awili Taya kinia Saidonotolo lierimu koleana sukundu purumu. Akuna purumu kinia yombomane yu ‘naa kanangi.’ nimba ulka senga sukundu pumba molorumu-na-kolo yu omba molorumu mele yomboma pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yesusi yu omba molorumu akumu pilipale ambo se yu molorumuna sumbi sipa omba yunga kumbikerena mania molopa tamalu perimu. Kanu ambomo yu ⸤Pulu Yemonga⸥ Juda yombomanga talapena ultukundu ambo se, kolea Siria poropinji sukundu kolea Ponisia disiriki yunga pulu koleamo. Ambomonga lemenunga konopuna kuru se molopa ambolorumu-kulu Yesusi molorumuna omba mania molopa tamalu pepa yundu mawa sepa nimbale: “Nanga bolamo kuru se konopuna sukundu molemo kene yu ⸤kondo kolko⸥ kurumu toko makorou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","⸤Ambomo yu ambo-lupa, Juda ambo se mólo, nimba kanopale⸥ Yesusini ambomondo ⸤ungu-iku se topa⸥ nimbale: “Bolangoma kere-langi u nangi olo sepili. Ononga kere-langima lipu owáma simulú kinia manda naa sembá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ambomone yundu nimbale: “Ye-Awilimu, sika nikinu-na-kolo owámane kepe bolangomanga kere-langi pundu mania pulimúma liku nolemele kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kanu-kinia Yesusini yundu nimbale: “Ambomo, nu aku siku nikinumu papu nikinu. Aku siku nikinumunga kuru kanumu nunga bolamonga konopuna sukundu molopa omba wendo pumu kene nu ⸤konopu peanga lelko⸥ pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","⸤Yesusini aku sipa nirimu pilipale⸥ ambomo kelepa ulkando pumba kanorumu kinia lemenu konopuna kuru se naa molopili uru peli polona ola we molorumu kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesusi kolea-awili Taya mundupa kelepa kolea-awili Saidono sukundu omba pumba, ‘Kolea-Awili Rureponga Talo’ niringi koleana sukundu omba pumba, Gallilli nomu kelona ⸤sukundu⸥ orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akuna moloringi yombomane yu molorumuna ye komu sipa ungu sumbi sipa naa nirimu ye se mengo ongo “⸤Yu peanga liepili⸥ nunga kimuni ambolou.” ningu tondolo munduku mawa seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kanu-kinia yombo kakapu seko moloringima mundupa kelepa “Oltolo molambili.” nimba kanu yemo senga memba pumbale nirimumuni, komutolonga ki-sundu sukundu mundupa, elkambe topa yemonga alimbolomo kimuni ambolopale, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mulúna olando sipa kanopa, tondolo mundupa múlu lipa, Juda yombomanga ungu lepa yemondo nimbale: “Epata!” nirimu. (Kanu ungumunga pulumu “Komumuni piliei!” nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aku nirimu kinia popenge sepa yemo komu-pea lepa yu ungu manda pilipa, alimbolomo takele serimu kanumu peanga lepa umbu-alimbolomo gilierimu kinia yu ungu sumbi sipa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kanu-kinia Yesusini onondo tondolo mundupa nimbale: “Nane i ulu sekero mele anju yombo selurindu kepe paa naa ningu siee!” nirimu. Aku-na-kolo yuni “Mólo.” nimba wale awisili nirimu mele pilku mokoli seko yomboma anju-anju yuni serimu mele semane toko siliku mindi andoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","⸤Yu serimu mele kanoringi yomboma kinia, anju semane toko siringi pilieringi yomboma kinia⸥ ono paa mini-wale munduku ninguli: “Apa! Yuni selemo uluma peangama mindi selemo. “Komu silimúma ungu pilku, ungu naa nilimilima ungu ningu, saa.” nilimú kinia kepe unguma pilku unguma ningu selemele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Walte Yesusi molorumuna yombo awisili kelko ongo liku maku toko moloringi. Moloringi koleana nonge kere-langi se naa lierimu-kulu Yesusini yu lombili andolimando “Na moliona waa.” nimba onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“I yombo maku toko molemelema na kondo sekemo. Wale yopoko na-kinia molongi, pe kiniá ga nonge se naa lemó. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mare aulka suluna oringimunga nane “Ono gele sepa pepili ulkando paa.” nilkanje ono aulkana kimbu ki pange-mange sepa, topa ne-munda ya-munda selka.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aku nirimu kinia pilkuli yu lombili andolimane yundu pundu toko ninguli: “⸤Sika nikinu-na-kolo⸥ i kolea ku lielina molemolo. I yomboma manda nonge mele pellawa kaloli sena lembana lipu simulúye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesusini onondo “Pellawa kaloli nambi seko taltokomeleye?” nimba mangilierimu kinia onone “Yopoko-pakara taltokomolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kanu-kinia yuni maku toko moloringi yombomando “Mania molaa.” nimbale, pellawa kaloli yopoko-pakara lipa ⸤Pulu Yemo-kinia⸥ “Ange.” nimba, akuma peke lepa yu lombili andolimando “Yomboma moke seko siee.” nimba ono sirimu. Nirimu kanu mele seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ono oma kaloli kanga pokore kepe taltoringila, akuma lipa ⸤Pulu Yemo-kinia⸥ “Angela.” nimbale yu lombili andolimando “Ima yomboma moke seko siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yomboma ⸤kere-langima⸥ noringi kinia olo serimu. Pe kere-langi kakena lierimuma lombili andolimane liku wale-basiketemanga lakilieringi, wale awili yopoko-pakara peke lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ye po tausinini aku kere-langima noringi. Kanu-kinia Yesusini maku toko moloringi yombomando “Ulkando paa.” nimbale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yu lombili andolima kinia yu kinia ono nona andoli sipina sukundu pungu, ⸤nomuna nekendo⸥ kolea Dallamanuta puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Akuna puringi kinia Parisi yema Yesusi molorumuna ongo, ‘Yuni nambi sembanje? Kanamili.’ ningu yu manda manjiku mawa seko ninguli: “⸤Ungu Mane Sílimu,⸥ ‘Nu sika Pulu Yemone ‘Kongono sendani.’ nimba ya mana lipa mundorumunje kanamili.’ ningu mulu-koleana molemo ⸤Pulu⸥ Yemone mindi manda ulu-⸤tondolo⸥ selemo mele se sei.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","⸤Aku siku mangilieringi kinia pilipa kiri pilipale Yesusi⸥ yunga konopuna paa umbuna serimu-na múlu awili sepa lipa nimbale: “Kiniá mana molemele yombomane “Pulu Yemone mindi ulu-tondoloma manda selemo mele kanamili sei.” ningu na nambi semu-na mawa selemeleye? ⸤Na molio mele nambi semu-na “Sika.” we naa ningu kuru mondolemeleye?⸥ Nane ono sika nimbu sikiru: “⸤Na Pulu Yemo kinia kopu sepo kongono selembolo mele⸥ lipa ora simba kanonge ulu-tondolo se, kiniá mana molemele yomboma-kinia wendo naa ombá.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aku sipa nimbale nirimumuni, ono mundupa kelepa sipina sukundu kelepa pumbale nomuna nekendo purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","⸤Kanu-kinia ono nomuna nekendo pungíndu Yesusi lombili andoli yema⸥ pellawa kaloli komu sindiku naa mengo puringi. Pellawa kaloli selu mindi sipina suku lierimu, se pea mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kanu-kinia Yesusini onondo liepi-liepi topa ⸤ungu-iku topa⸥ nimbale: “Paa mimi siku kanaa! Parisi yema kinia ⸤ye nokoli kingi⸥ Erote yunga yema kinia onone pellawa akoli méle isi taltolemelemo kanoko kondaa!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aku sipa nirimu kinia pilkuli yu lombili andoli yemane onono angelema ningu ninguli: “Olio pellawa kaloli ⸤nomolo⸥ mare naa lipu membo omulumunga aku sipa nikimunje.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aku siku niringi mele pilipale Yesusini onondo nimbale: “Onone “Pellawa kaloli naa memulu.” ningu nambi semu-na angelema nikimiliye? Kiniá kepe ono naa kanoko, mimi siku wamoko naa pilkimiliye? Na tondolo se perimu-na pellawa kalolima-kinia ulu-tondolo se serindu mele ono naa pilieringiye? Ono konopu naa pepili molemelemonga nane nikiru mele ungu-pulumu naa pilkimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ono mongo gilimú-na-kolo mélema naa kanokomeleye? Komu gilimú-na-kolo unguma naa pilkimiliye? Pellawa kaloli se-pakara lipu peke lepo ye paip tausini moke sepo sirindu kanumu ono komu sindikimiliye? ⸤Nongo pora siringi kinia⸥ kere-langi kakena lierimuma liku wale-basikete nambi seko toko peke siringiye?” nirimu kinia ⸤yu lombili andolimane⸥ yundu pundu toko “Engaki-rurepo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","⸤Yuni onondo kelepa nimbale:⸥ “Pe pellawa kaloli yopoko-pakara lipu peke lepo ⸤ye⸥ po tausini moke sepo sirindu kinia ⸤nongo pora siringi kinia⸥ wale-basikete awili nambi seko kere-langi kakena lierimuma toko peke siringiye?” nimba mangilierimu kinia onone yundu pundu toko “Yopoko-pakara.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yuni onondo ⸤kelepa⸥ nimbale: “Onone kiniá kepe mimi siku wamoko naa pilkimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesusi kinia, yu lombili andolima kinia, ono Besaida taonona puringi kinia mongo kiri lierimu ye se Yesusi molorumuna mengo ongo mawa seko ninguli: “Nuni i yemo kimuni ambolou.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aku niringi kinia Yesusini mongo kiri lierimu yemo ki ambolopa taono ultukundu memba pumbale yunga mongo-tolonga elkambe topa kandopa kimuni ambolopa nimbale: “Nu kiniá mélse kanokono molo móloye?” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","yemone olando sipa kanopa nimbale: “Na kiniá yombo mare, ono unju melema ongo pukumili kanokoro.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesusini yunga mongotolonga kelepa ambolorumu kinia yemo yu mongo makilipa mélema pali mongotolone sumbi sipa kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesusini yemondo “Ulkando pu.” nimba nimbale: “Nu kelko ulkando punindu ne kolea ⸤molopo wendo ombulu⸥ akuna ⸤kelko anju⸥ naa pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesusi kinia yu lombili andolima kinia pungu kolea-awili Sisaria-Pillipai nondopa lierimu kolea kangamanga pungí puringi. Akuna pungí puringi kinia Yesusini yu lombili andolimando mangilipa nimbale: “Yombomane na imbi leko nawe nilimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Onone yundu ninguli: “Marene “Nu No Lindeli Jono ⸤kolorumu kanumu kelepa lomboropa ola molemo⸥.” ningu pilielemele; marene “Nu ⸤Pulu Yemone u konde molopili olando liltimu ye⸥ Illainja kelepa omba molemo.” ningu pilielemele; marene “Nu Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye se ⸤u kolorumu kiniá lomboropa ola molemo.⸥” ningu pilielemele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aku niringi pilipale Yesusini onondo mangilipa pilipa nimbale: “⸤We-yombomane aku siku nilimili⸥-na-kolo ono onono na nawe nilimiliye?” nirimu. Pitane pundu topa nimbale: “Nu Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ u nimba taltorumu ye nokoli Karasimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","⸤Pitane aku nirimu pilipale⸥ Yesusini onondo tondolo mundupa nimbale: “Na molio mele ⸤Pitane kiniá nikimumu⸥ onone anju yombo selurindu kepe ⸤iseli-u⸥ paa naa ningu siee!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kanu-kinia Yesusi yu lombili andolimane yundu ⸤ “Pulu Yemone olio “Nokopa kondomba ye se lipu mundumbu.” nimba, nimba taltorumu ye nokoli Karasimu nu.” ningu, ningu para siringi kinia pilipale⸥ yuni yu-kinia wendo ombá mele pulu polopa ono mane sipa nimbale: “Mania Omba Mana-Ye Au Lierimu Yemo mindili awisili nombá. Juda yomboma nokolemele tapu-yema kinia, Pulu Yemo popo tondoli ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane sili yema kinia, onone ⸤ninguli: “Yu Pulu Yemone naa lipa mundorumu. Yu Pulu Yemonga Malo naa molemo.” ningu⸥ yu liku bulu siku yu toko kondonge. Yu toko kondonge kolomba kinia wale talo omba pumbá kinia yopoko-sipamonga yu lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesusi yu-kinia wendo ombá mele aku sipa sumbi sipa nimba para sirimu kinia pilipale Pitane yu anju lipa memba pumbale ⸤Yesusi yuni “Na toko kondonge.” nirimumunga⸥ yu pulu polopa iri torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aku-sipa na-kolo ⸤yuni kurumanga nokoli Setenene ungu-umbu tondorumu mele pilipale nirimu-kulu pilipale⸥ Yesusini topele topa yu lombili andolima kanopa Pita iri topa yundu nimbale: “Setene, nu anju pa! Nu Pulu Yemone konopu lemó mele naa leno. Yombomane konopu lemele mele mindi leno kene anju pu!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kanu-kinia yombo akuna liku maku toko moloringima pali kinia yu lombili andolima pea “Na moliona waa.” nimba onondo nimbale: “Yombo sene ‘Yu lombili pambo.’ nimbale yuni yunga konopumuni pilielemo mélemanga ‘Topo mania mundambo.’ nimba yomboma unju-perana peko mindili nongo kololemele mele yuni unju-pera mele gomo lembando ‘Na yu lombili pumbúndu mindili nondu liemu peangala; kolondu liemu peangala.’ nimba na lombili opili. We naa opili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yombo sene yunga mana konde molopa naa kololi ulu-pulumu ambolomba sembá kinia yu kolopale sika molopa kinjipa mindi pumbá. Aku-na-kolo yombo se na konopu mondopa nanga yombomo molopa, ‘Yomboma semane peangamo piliangi.’ nimba ono nimba sipa molomba kinia yu kolopale yu konde molopa kondopa mindi puli ulu-pulumu sika kanopa limba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","⸤Akumu nambi semu-na nikiruye?⸥ Yombo sene mana-mélema pali yuyu lipa taltopale yu mini-pali Pulu Yemo naa molomba koleana pumba mindili nomba molopa kinjilkanje kanu mélemane kanu yombomo nambi sepa lipa tapondolkanje? Lipa naa tapondolkamo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yombo sene ‘Na mini-pali konde molopo kondopo mindi pambo.’ nimbale yu nambolka mélsene mini-pali konde molopa kondopa mindi puli ulu-pulumu topo topa lilkaye? Mélsene manda topo topa naa limba. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Nanga yombo mare ulu-pulu-kiri seko Pulu Yemo munduku kelko méle lupama imbi ambolko paka tondoko molemele yomboma-kinia molkole pipili kolko ninguli: “Olio Yesusinga unguma pilipu lipu, yu lombili andopo molemolo mele we-yombomane naa piliangi.” ninguli na kiyongo ningu lombili andolemele yomboma, ono-kinia ungu se pe wendo ombá mele nimbu siembo: Mania Omba Mana-Ye Au Lierimu Yemo pe Lapanga tondolo pa sélimu kinia ⸤mulu-koleana⸥ angello kake selima kinia ⸤mania⸥ ombá sembá kinia, kanu we-yomboma molongena yunga yomboma mona molongendo we-yomboma molongena kanokole, yu u naa opili ‘Olio yunga yomboma molemolo mele we-yombomane naa piliangi.’ ningu pipili kolko lopi seko molonge yomboma yuni lipa wekendo kanopa, “Na moliona naa waa.” nimbála.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesusi yuni onondo ungu se pea nimbale: “Nane onondo paa sika nimbu sikirumu: “Ono ya gilkimilimanga mare u kolou naa kolangi Pulu Yemo ye nokoli kingimu omba, enge nimba molopa, mélema kinia yomboma kinia pali nokomba ombá kanonge.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesusini ⸤yu lombili andolimando aku sipa nimba sirimu kinia⸥ pe koro se omba purumu kinia Pita keme Jemisi keme Jono keme ono lipa memba pumba mulú paa olandopa polorumu senga ola purumu. ‘Olio oliolio mindi molamili.’ nimba ono akuna lipa memba purumu. Akuna puringi kinia ono kanoko molangi yunga kangimu topele topa, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","yu pakorumu mulu-maminiama ena tondolo topa mongo paa takele selemo mele aku sipa paa kake serimu. Ya mana-yombo sene wale-pakoli se sopone kulumiye topa kake sendemba mele manda mólo. ⸤Yunga mulu-maminiama kake serimu mele paa olandopa.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yu aku sipa molopili, ⸤Juda yombomanga koronga-u moloringili ye awili talo,⸥ Illainja kinia Mosisitolo ongo Yesusi kinia ungu ningu mona gilieringili kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kanu-kinia Pitane Yesusindu nimbale: “Rapai, olio ya molopomolo peanga lepomo. Olione ulka-takaya yopoko takondamili. Se nunga, se Mosisinga, se Illainjanga takondamili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Aku-na-kolo aku nirimumu ono pipilini paa koloringi-kulu yuni nimbá mele naa pilipa ungu se walu nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kanu-kinia kupa se omba ono aki torumu kinia kupana sukundu ungu se wendo omba nimbale: “I yemo nanga konopu mondolio Malomo. Yuni ungu nimbáma pilku liengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe waltikele, ono mongo male-male seko kanokole yetolo kelko naa kanoringi. Yesusi yu-mindi ono-kinia molorumu kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mulu polorumumunga mania onge oringi kinia Yesusini ono mane sipa nimbale: “Onone kiniá kanongi mele iseli-u yombo seluri kepe ningu naa siengi. Pe mindi, Mania Omba Mana-Ye Au Lierimu Yemo kolopale kelepa lomboropa ola molomba kinia semanemo toko anju siengi. U mólo!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aku nirimu kinia ono yunga ungumu pilku liku u anju naa niringi-na-kolo “yu “kolopole kelepo lomboropo ola molombo.” nikimu ungu kanumunga pulumu nambolka ulurindu nikimunje?” ningu ono onono angelema niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kanu-kinia yu lombili andolimane ⸤yu sika molorumu mele ningu kanokole⸥ yundu mangilku pilku ninguli: “⸤Pulu Yemone ‘olio nokopa kondopa lipa tapondomba.’ nimba, nimba taltorumu ye nokoli Karasimu nu liemu⸥ Pulu Yemonga ungu-manemanga puluma pilku mane silimili yemane “Illainja ⸤kelepa⸥ kumbi lepa ombá. ⸤Ye nokoli Karasimu pe akilepa ombá.⸥” nilimili akumu nambi semu-na nilimiliye? ⸤Illainja kelepa naa opili nu koronga orunu moleno kanumu.⸥” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesusini pundu topa nimbale: “ “Illainja ⸤kelepa⸥ kumbi lepa ombale mélema pali sepa wamomba.” nilimili kanumu sika nilimili. Aku liemu Mania Omba Mana-Ye Au Lierimu Yemo kanoko kiri pilku mindili liku singí mele ⸤Pulu Yemonga⸥ bokuna nambi semu-na imbi toringi molemoye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Aku-sipa na-kolo ⸤akumunga ungu se pea nimbu sikiru.⸥ Piliame! Illainja koronga orumu. Yu orumu kinia ⸤kanu yemane yu kanoko imbi naa siku⸥ ‘Yu we-yere.’ konopu lekole ‘yu-kinia semolo.’ ningu pilieringi uluma pali seringi. Yu-kinia aku siku senge mele u bokuna imbi toringi molemóla.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","⸤Yesusi kinia yu lombili andoli ye yopoko kinia⸥ ono yu lombili andoli ye wema moloringina yando ongo, yombo paa awisili akuna kakapu seko maku toko moloringi kanoringi. Pulu Yemonga ungu-manemanga puluma pilku mane siringi yemane Yesusi lombili andoli ye wema kinia ungu ningu, ungu mare mangilku pilku moloringi kanoringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yesusi orumu kinia kanokole kanu maku toko moloringi yomboma pungu-pungu awili seko ningu yu orumuna lisiku ongo yundu “⸤Ye-Awilimu,⸥ nu okonoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kanu-kinia yuni onondo “Onone ungu nambolka ungumu angelema nikimiliye?” nimba mangilierimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","kanu maku toko moloringi yombomanga ye sene pundu topa yundu nimbale: “Ungu Mane Sili Yemo, nanga kangomo kuru se yunga konopuna molemomonga ungu manda naa nilimú-na nu molonu ⸤konopu lepole⸥ membo ondu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kurumuni kangomo wale marenga ambolopale yu topa mania mundulimú kinia yu ámu topa, kere apoupu memba, ungú kikili sendepa selemo. Nu lombili andolimando aku semanemo topo sipu onone kanu kurumu ‘Makorangi.’ nimbu mawa sendu-na-kolo ono manda naa sengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aku nirimu kinia pilipale Yesusini yomboma ⸤iri topa⸥ nimbale: “Kiniá molemele yomboma ono ⸤ ‘Pulu Yemone uluma sika manda sembá.’ ningu⸥ kuru naa mondoko molemele yomboma, na ono-kinia molopo, wale nambi sepo mane sipu ulu mare lipu ora simbú kinia mimi siku pilingíye? ⸤Na ono-kinia siye sekemo.⸥” nimbale “Na moliona kangomo mengo waa.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","kangomo yu molorumuna mengo oringi. Mengo oringi kinia ⸤kangomonga konopuna molorumu⸥ kurumuni Yesusi kanopale kangomo topa mania mundorumu kinia kangomo kimbu kima peua mundupa kere apoupu merimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aku serimu kinia kanopale Yesusini kangomonga lapa mangilipa nimbale: “Kangomo i kurumu sewale pulu polorumuye?” nirimu. Lapane nimbale: “Yu kokele anumuni merimu kinia aku sipa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wale awisili yu ámu topa sepena topa mundupa, nona topa mundupa selemo kene nuni manda liku tapondonu liemu olio kondo kolko liku tapondou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesusini nimbale: “Nuni nambi semu-na “Manda liku tapondoni molo móloye?” nikinuye? ‘Nane nu manda lipa tapondomba.’ ningu kuru mondonu liemu uluma pali sika wendo ombá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesusini aku nirimu kinia pilipale kangomonga lapane tondolo ru nimba nimbale: “Nane ‘sika nuni liku tapondoni.’ nimbu kuru mondokoro-na-kolo ‘Sika.’ nimbu kuru mondokoro ungumu tondolo mundupu ambolombo mele manda naa sekemo kene ‘Sika.’ nimbu kuru mondokoro mele ‘tondolo pupili.’ ningu liku tapondani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","⸤Kanu-kinia⸥ yomboma lisiku sukundu sukundu kanonge onge oringi kanopale Yesusini kurumu iri topa nimbale: “Kere pipi siku, komu pipi siku seleno kurumu, kangomonga konopuna ongo wendo pungu, kelko paa naa ongo molani. Kamu pu!” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","kurumuni kangomo tondolo topa mania mundorumu kinia yu kimbu kima peua mundorumu kinia kurumu kalli nimba yunga konopuna wendo orumu. Kanu-kinia kangomo yu kolopa lierimu none serimu kanokole yombo awisilini “Yu kolomu lémo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aku-sipa na-kolo Yesusini yunga kimu ambolopale yu ola liltimu kinia ola gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","⸤Kanu-kinia Yesusini kurumu topa makoropa pora sipale⸥ ulkana sukundu ⸤yu lombili andolima kinia⸥ purumu kinia lombili andolima onone Yesusi pea onono molkole yu mangilku pilku ninguli: “Kuru akumu olione nambi semu-na manda naa makoromuluye?” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesusini pundu topa nimbale: “I ulumu mele semolondo (kere-langi mi lepo naa nombo) Pulu Yemo kinia ungu nimbu mawa semolomone mindi manda semolo. We manda naa semolomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","⸤Yesusi kinia yu lombili andolima kinia⸥ ono aku koleamo munduku kelko ⸤yomboma moloringi koleama naa pungu⸥ kolea Gallilli disiriki sumbi siku ongo pungí puringi. Akuna pungí puringi kinia yu lombili andolima ungu-mane silipa purumu-kulu ‘Na lombili andolima ungu-mane sikiru mele we-yombomane naa piliangi kene olio we-yombomane naa kanangi, pea naa pamili.’ nimba yu kinia yu lombili andolima kinia onono kiyongo ningu puringi. ⸤Yu-kinia pe wendo ombá mele⸥ yuni ono ungu-mane silipa purumu mele i-sipa: “Mania Omba Mana-Ye Au Lierimu Yemo ka sikuli ⸤yu toko kondonge⸥ yema anju singí kinia onone yu toko kondonge. Kolopale wale yopoko sipamonga yu lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aku-na-kolo yuni nirimu ungumu pilku sundukuli ‘I ungumunga pulumu nambolkarenje, naa pilkimulu.’ niringi-na-kolo “Nambolka ningu nikinuye?” ningu mangilku pilingindu pipili kolko naa mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","⸤Ongole⸥ kamu Kapeniame taonona sukundu oringi. Molonge ulkana sukundu pungu moloringi kinia Yesusini yu lombili andolima mangilipa pilipa nimbale: “Ono aulkana ungu nambolkarenga angelema niliku ongiye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aku-na-kolo onone ‘Olionga ye nawe paa olandopa molemoye?’ ningu angelema ningu keru-kuru liltingi-kulu Yesusindu ono niringi mele ningu para singímunga pipili kolkole molko mokoli seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanu-kinia Yesusi yu mania molopale yu lombili andoli rurepondo “Na moliona waa.” nimba nimbale: “Yombo sene ‘Yombomanga awilimu molambo.’ nimbale yu we-yombomo molopa yombomanga kendemande-yombomo molopili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aku nimbale bolango kanga se lipa ⸤yu lombili andolima⸥ gilieringina mondopale nirimumuni, aku bolangomo yuni kangulupa onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yombo sene ‘Na Ye-Awilimunga yombomo molio.’ nimba i bolangomo mele lipa tapondomba kinia kanu yombomone aku sembamonga na lipa tapondombala. Na lipa tapondomba yombomone na manjipa naa lipa tapondomba. Bolangomo lipa tapondombamonga kanu yombomo yuni na lipa mundorumu yemo lipa tapondombala.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","⸤Yesusi lombili andoli ye⸥ Jonone Yesusindu nimbale: “Ungu Mane Sili Yemo, olio kanomulu, ye sene nunga imbimu lepa mangilipa kuru mare yombomanga konopuna molongima “Ongo wendo paa!” nimba topa makoropa molomu kanomulu. Kanopole yu olio pea kopu sepo naa molemolo kene yundu “Nu aku siku naa sei!” nímulu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aku nirimu kinia pilipale Yesusini yundu ⸤kanu yemone serimu ungumundu⸥ nimbale: “Yombo sene nanga imbi lepa mangilipa ulu-tondolo se sepale yuni kelepa nondopa nando ungu se manda nimba naa kinjimba kene onone yundu “Mólo!” ni naa niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yombo se olio-kinia opa-toumu naa molemomo olionga opa-geramemo molemo kanumu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Nane onondo paa sika nimbu sikirumu: “Ono no nonowale semba kinia yombo sene ‘Ono ye nokoli Karasimunga yomboma molemele kene no se nangi kolopo siembo.’ nimba ono se kolopa simu liemu, ye nokoli Karasimunga kongono sendenge yomboma yuni méle kalomba kinia kanu yombomo kepe komu naa sindipa yu konopu lipa mundupa méle kalombala.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yombo sene i bolangomonga ⸤mele yombo⸥ se na ‘Sika’ nimba kuru mondolemo bolangomo ‘Ulu-kirima sepili.’ nimba kondi tombamonga kanu bolangomo kuru mondolemo mele mundupa kelepa bulu simu liemu ⸤bolangomo u kondi naa topili⸥ kanu yemo kou paa awili se moko toko nomina lendeko ‘Yu kamu kolo-popili.’ ningu paka toko nomuna paa maniakondo mundulimolánje paa papu. Aku siku toko mundulimolá kinia yu kolopale pe yu Pulu Yemonga bolango sendo ‘Ulu-kirima sepili.’ nimba kondi manda naa tolka. Aku-sipa na-kolo yu aku siku nomuna naa mundulimolá kinia yu yomboma kondi tombamonga yu Pulu Yemo-kinia mongo awili pelka kene onone yu nomuna papu paka toko mundulimolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Nunga kitolone ulu-pulu-kiri se semu liemu aku kitolo kari leko eltani. Nu konde mololko mindi puni koleana kitolo naa giliepili puni kinia peangamo. Nunga ki talo we giliepili nu sepe-kolea, ⸤ ‘akuna Pulu Yemo seko kinjilimili yombomanga korowama kolou naa kolopa nolepa mindi pulimú, sepe toko kumundou naa kumundulimili kolea’ ⸥ akuna sukundu toko mundungí kinia kirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Molo nunga kimbutolone ulu-pulu-kiri se semu liemu aku kimbutolo kari leko eltani. Nu konde mololko mindi puni koleana kimbutolo naa giliepili puni kinia peangamo. Nunga kimbu talo we giliepili nu sepe-kolea, ( ‘akuna Pulu Yemo seko kinjilimili yombomanga korowama kolou naa kolopa nolepa mindi pulimú, sepe toko kumundou naa kumundulimili kolea’ ) akuna sukundu toko mundungí kinia kirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","“Molo nunga mongotolone mélse kanokole konopuni ‘liembo.’ ningu pilku ulu-pulu-kiri se senu liemu aku mongotolo akuku eltani. Nu Pulu Yemo ye nokoli kingimu molopa nokolemo koleana mongotolo naa giliepili puni kinia peangamo. Mongo talo we giliepili nu sepe-kolea, ‘akuna Pulu Yemo seko kinjilimili yombomanga korowama kolou naa kolopa nolepa mindi pulimú, sepe toko kumundou naa kumundulimili kolea’ akuna sukundu toko mundungí kinia kirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Yombomane Pulu Yemo popo toko kalolemele mélema singíndu ‘Pulu Yemone kanopale ‘Kere-langi kake selima.’ nimba kanopili.’ ningu api-kusa mundukuli silimili aku siku mele yomboma molongena sepemo, api-kusa mele, yomboma kinia pali wendo ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Api-kusa yu méle peangamo na-kolo yu songo naa sembá kinia ‘Yu kelepa songo sepili.’ ningu ungu se manda selemeleye? ⸤Api-kusa kere-langimanga mundulimili kinia songo selemo aku siku⸥ ono api-kusa mele molko yomboma kinia anju yando konopu seluna pupili taka leko molangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kanu-kinia Yesusi molorumu koleamo mundupa kelepa kolea Judia disiriki pumba no Jodane kimbilipa nekendo purumu. Kanu-kinia kelko yombo awisili yu molorumuna ongo maku toringi kinia alieli aku seringi kinia yuni yomboma ungu-mane sirimu mele maku toringima kelepa mane sirimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi ye mare yu molorumuna ongo ‘Yu nambolka nimbánje? Nimba kinjimbanje manda manjipu piliamili.’ ningu yu mangilku pilku ninguli: “Ye sene yu yuyu pilipale yunga ambomo “Kamu pu.” nimbá kinia manda sembá molo aku sembá kinia ungu-mane se pulua tombaye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yuni anju pundu topa nimbale: “Mosisini aku ulumundu ungu-mane sipa nambolka nirimuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Onone ninguli: “Mosisini nimbale: “Ye sene yunga ambomondo ‘Kamu pupili.’ nimba makorombando ambomo “Kamu pu.” nimbá mele pepá senga topa ambomo sipale yundu “Kamu pu.” nimba aku sepili.” nirimu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesusini nimbale: “Mosisini sika aku sipa bokuna torumu-na-kolo ono kara pungu Pulu Yemone ambo yetolo seluna seluna molongele mele ungu-mane sirimumu pilku mokoli seringi naa pilieringi-kulu yuni “Aku sangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aku-sipa na-kolo u-pulu-pulu Pulu Yemone mélema sepale yuni yombo sembando yemo kinia ambomo kinia serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Aku sipa serimumunga ye sene ambo se lipale yunga anumu lapatolo mundupa kelepa yunga ambomo kinia ololo seluna kopu seko peko, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kangi selumu mele ⸤molko olonga konopu seluna pupili⸥ molongele.’ Ye se ambo se limú kinia kangi selumu mele molembele-na olo kelko talo mele naa molembele, olo yombo selumu mele molembele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yombo selumu molembele kene Pulu Yemone ambo ye talo ‘Selumu molangili.’ nilimú ambo yetolo yombo sene liku lupa lupa naa mundangi. Aku sengi liemu manda naa sembá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kelko ulkana sukundu pungu moloringi kinia yu lombili andolimane Yesusi yundu aku ungumunga pulumu mangilku pilieringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","yuni onondo pundu topa nimbale: “Ye sene yunga u limú ambomo makoropa “Kamu pu.” nimbale kelepa ambo se limú kinia aku yemone wa ulu-kirinale sepa, u limú ambomo sepa kinjilimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Molo ambo se yunga u pulimú yemo mundupa kelepa wendo pumba ye se pulimú kinia aku ambomone wa ulu-kirinale selemóla.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kanu-kinia yombomane ononga bolangoma ‘Yesusi yunga kimuni ambolopili.’ ningu yu molorumuna mengo oringi. Aku-sipa na-kolo yu lombili andolimane iri toko ⸤ “Naa mengo waa!” ⸥ niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","⸤ “Mólo.” niringi kinia⸥ kanopale Yesusini konopu kiri panjipa ⸤yu lombili andolima⸥ onondo nimbale: “Pulu Yemo ye nokoli kingimu molopa nokolemo yombo talape akumu i bolangoma mele molemele yomboma ononga yombo talapemo kene onone i bolangoma na moliona wangi pipi siku “Mólo.” naa niee!” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Nane onondo paa sika nimbu sikirumu: “Bolangomane ‘Pulu Yemo olionga ye nokoli kingimu molopili.’ ningu molemele mele aku siku naa nilimili yomboma yunga koleana sukundu paa naa pungí, mólo.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aku nimbale yuni bolangoma kangulupa yunga kimuni ono selu selu nimba pengena ambolopa ono sepa kondombando “Pulu Yemone “Ono molko kondangi.” nipili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kanu-kinia Yesusi ola gilipa kolea marenga pumbá purumu kinia ye se yu pumbá purumuna lisipa omba yunga kumbikerena komorongo langopa yundu mangilipa pilipa nimbale: “Ungu Mane Sili Ye Peangamo, na nambolka unguri sembó kinia na konde molopa kondopa mindi puli ulu-pulumu limbuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesusini yundu nimbale: “Nuni na nambi semu-na “Ye Peangamo” nikinuye? Yombo peanga se mólo. Pulu Yemo mindi peangamo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","⸤Aku nimbale yemone mangilierimumunga pundu topa nimbale:⸥ “Nu ⸤Pulu Yemonga⸥ ungu-manema ⸤Mosisini yando nimba sirimuma⸥ pilieleno. Yuni nimbale: “Yombo toko naa kondangi.” nimba, “Ambo ye pulima molo ye ambo lilima yombo lupama kinia wa ulu-kirinale naa sangi.” nimba, “Mélema wa naa liengi.” nimba, “Yombomanga kote kolo toko naa sendangi.” nimba, “Yombomanga mélema kolo toko we naa liengi.” nimba, “Aminieli lanieli kinia molko kondoko, ungu ningí mele pilku liku molangi.” nimba, ungu-mane akuma sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aku nirimu kinia pilipale kanu yemone nimbale: “Ungu Mane Sili Yemo, na kangomo molopole aku ungu-manema pali pilipu lipu sepo molorundu mele yandopa kiniá kepe sepo moliomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesusini yu neme-neme nimba kanopa konopu mondopale yundu nimbale: “Papu seleno-na-kolo ulu selu mindi naa seleno. Nu pungu nunga méle taltolenoma pali kou-mone li-punguli, kou-mone linima yombo koropama moke seko sikuli na lombili ou.” nirimu. “Nunga ⸤mana-⸥mélema aku sení kinia mulu-koleana nunga méle kande-kandema lemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kanu yemo méle paa kande-kandema taltorumu-kulu Yesusini yundu aku nirimu kinia pilipale yu kumbikere sepa konopu kiri panjilipa anju purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","⸤Aku serimu-kulu kanopale⸥ Yesusi topele topa yunga lombili andolimando nimbale: “Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu yombo kamakoma paa kála seko sukundu pungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aku ungumu nirimu ⸤kinia pilkuli⸥ yu lombili andolimane mini-wale mundoringi. Aku-na-kolo Yesusini kelepa onondo nimbale: “Kangoma, Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu yomboma paa kála seko pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kongi kamele ⸤kongi paa awili se na-kolo⸥ kale suru tolina sukundu pumbándo kála kanga mele sepale pumbá. Aku-na-kolo yombo kamakoma Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu kála paa awili mele seko pungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","⸤Aku nirimu kinia pilkuli⸥ yu lombili andolima paa mini-wale munduku pungu-pungu ningu anju yando kerepale ningu ninguli: “Aku liemu pe kamu mindili nolemolá aulkana nawe manda wendo pumba, molopo kondopo mindi pumulú aulkana pumbaye? Se mólonje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesusini ono neme-neme nimba kanopa nimbale: “Sika yomboma onono manda mólo, aku-na-kolo Pulu Yemone manda sendemba. Pulu Yemo yuni uluma pali manda selemo. Ulu se yuni manda naa sembá se mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yuni aku nirimu kinia pilipale Pitane yundu nimbale: “⸤Pe olio-kinia nambolka uluri wendo ombáye?⸥ Olio olionga mélema pali mundupu kelepo nu lombili purumulu mele pulimulu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesusini nimbale: “Nane onondo paa sika nimbu sikirumu: “Yombo na konopu mondoko nanga kongono sendeko semane peangamo toko siliku andongendo ononga ulkama, genupili, kemulupili, anupili, lapali, bolangoma, koleama, akuma munduku kelieringi yomboma pali ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya mana paa olandopa méle awisili likuli, pe pungí koleana konde molko kondoko mindi puli ulu-pulumu lingíla. Ya mana ulkama, genupili, kemulupili, anupili, bolangoma, koleama kinia, akuma pali awisili olandopa lingíla; ⸤na konopu naa mondonge yombomane⸥ ono mindili singíla.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aku-sipa na-kolo kiniá yombo awili molemele yombomanga awisili pe ⸤Pulu Yemo ye nokoli kingimu molopa nokomba koleana⸥ yombo koropama molonge; kiniá koropa pupili molemele yomboma pe yombo awilima molonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kanu-kinia ⸤Yesusi kinia yu lombili andolima kinia⸥ ono kolea-awili Jerusalleme pungí puringi. Yesusi kumbi lierimuna lombili andolima paa konopu awisili liku munduliku yu lombili puringi. We-yombo akileko lombili oringima kepe mini-wale munduku pipili kololko puringi. Yesusini ⸤yu lombili andoli⸥ ye engaki rurepo ‘na kinia ono kinia oliolio molamili.’ nimba ono lipa anju memba pumbale yu-kinia wendo ombá mele kelepa pulu polopa nimba sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Piliame. Olio Jerusalleme pumulú pukumulu. Akuna pumulú kinia Mania Omba Mana-Ye Au Lierimu Yemo ye sene ‘Tangi.’ nimba Pulu Yemo popo tondoli ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane sili yema kinia, lipa simba. Kanu-kinia onone yu kote sendeko pilkuli ‘Yu kolopili toko kondangi.’ ningu Juda ye naa molemele ye-lupama liku singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kanu-kinia kanu ye-lupamane yu ungu-taka tondoko yunga kumbikerena elkambe toko yu ka-pultane toko yu toko kondonge. Yu toko kondonge kinia wale yopoko-sipamonga lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kanu-kinia Seperi malo Jemisi kinia Jonotolo olo Yesusi molorumuna ongo ninguli: “Ungu Mane Sili Yemo, nuni ‘Olto ulu se sani.’ nimbu mawa semboló okombolo.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yuni olondo nimbale: “Nambolka unguri ‘nane olo-kinia sendambo.’ ningu nikimbiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Olone pundu toko ninguli: “Nu pe nunga kolea tondolo pa selina ⸤ye nokoli kingimu molkole ninimuni, ‘olto nu-kinia pea ye nokolima molamili.’ ningu⸥ ‘olto se nunga ki-lomekondo mondoko se nunga ki-tarokondo mondani.’ nimbu mawa sekembolo.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesusini olondo nimbale: “Mawa sekembele mele olo pilku naa kondokombele. Na no-mingina no nombómo olo manda nongeleye? Molo na no limbumu olo manda lingilíye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Olone yundu pundu toko ninguli: “Manda semboló.” niringili. Yuni olondo nimbale: “Na no-mingina no nombómo pe olo sika nongelela. No limbumu pe sika lingilíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aku-na-kolo nane olo “Nanga wangutolonga ongo molangili.” nimbúmu manda naa sembá. ⸤Pulu Yemone yuyu⸥ akuna molongeletolo koronga nimba taltorumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jemisi Jonotolone ⸤ ‘Yesusinga wangutolonga molambili.’ ⸥ ningu mawa seringili mele pilkuli lombili andoli rureponga talo wemane olo-kinia konopu kiri panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanu-kinia Yesusini ono “Waa.” nimbale nirimumuni, onondo nimbale: “Olio Juda yombomanga ultu molemele yombo talapemanga ye nokolima ononga yomboma tondolo munduku nokoko kongono enge nilima alieli silimili. Ye imbi ola molemo yema ononga yomboma ‘Mindili nangi.’ ningu nokolemele. ⸤Yombomane ononga ye nokolimanga unguma pilku mokoli senge aulka se naa lemó mele⸥ ono pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aku-sipa na-kolo ⸤we-yombomanga ye nokolimane ononga yomboma tondolo munduku nokolemele mele na lombili andoli yema⸥ ono onono aku siku anju yando naa sangi. Ononga ye se ‘Na imbi olandopa molopili. Na ye awilimu molambo.’ nimbá yemo ononga kongono sendeli yemo molopili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","‘Na ononga ye nokolimu molopo ono nokambo.’ nimbá yemo ononga pali kongono kendemande sendeli yemo molopili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aku sipala, Mania Omba Mana-Ye Au Lierimu Yemo kepe ‘Yombomanga ye awilimu molopo ono nokambo. Onone nanga kongono sendeli kendemande-yomboma molangi.’ nimba naa orumu. ‘Yombomanga kongono sendeli kendemande-yemo molopo ono lipu tapondopo, ulu-pulu-kirimane ono ka sipa nokolemo mele naa sepili manda molangi kene na yombo awisilinga nimbu pundu tondopo nanga kangimu sipu, kolali sepo kolondambo.’ nimba orumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kanu-kinia Yesusi kinia yu lombili andolima kinia ono kolea-awili Jeriko oringi. Ongole ono kinia we-yombo awisili kinia Jeriko munduku kelko pungí puringi kinia mongo kiri lierimu ye se, imbi Ba-Timiasi, (akumunga pulumu Timiasi malo,) aulka lomolomena molopa yomboma “Kou-mone siee.” nimba mawa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kolea Nasarete ye Yesusi omba purumu mele pilipale mongo kiri lierimu yemo yuni pulu polopa tondolo ru nimba mangilipa nimbale: “Yesusi, ⸤ye nokoli kingi⸥ Depitini kalopa liltimu yemo, na kondo kolou!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yombo awisilini yu iri toko “Nu ungu naa nili taka leko molou!” niringi. Aku-na-kolo yuni paa tondolo ru nimba mangilipa nimbale: “Depitini kalopa liltimu yemo, na kondo kolou!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesusi we gilipale “Yu opili niee.” nirimu. Aku nirimu-kulu ono mongo kiri lierimu yemo mangilku ninguli: “Yuni “Nu ou.” nikimu kene konopu peanga leko ola gilku ongo pu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yu popenge sepa ola pakorumu wale-pakolimu kulupa ola gilipa Yesusi molorumuna orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesusini yundu nimbale: “Nane nu nambi sambo konopu lekenoye?” nirimu kinia mongo kiri lierimu yemone nimbale: “Raponai, na mongotolone mélema kanambo nanga mongotolo seko peanga sindani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesusini nimbale: “‘Nane nunga mongotolo manda sendembo.’ ningu kuru mondonumunga nu umbu-mongotolo manda gilkimu kene pu.” nirimu. Yesusini aku nirimu kinia yu popenge sepa mongotolo peanga lierimu, mélema kanopale, Yesusi purumu aulkana lombili purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","⸤Yesusi kinia yu lombili andolima kinia⸥ ono kolea-awili Jerusalleme nondoko ongo, ma-pangi se ‘Ma-Pangi Unju Ollipi Kalia’ nili akuna lemó kolea-kanga talo, Betepasi kinia Betani-tolonga oringi. Kanu-kinia Yesusini yu lombili andoli ye talo lipa mundupa, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","olondo nimbale: “Ne kolea-kanga kanokombelena punguli kongi dongi walo se, yombo se yunga bulu-mingina waltikele kepe naa molopa andorumumu ka seko panjingímu ne sukundu molomba kanongele, kanumu pungu posiku yando mengo wangili pale. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Posingilí seko molongele kinia yombo sene olondo “Aku nambi semu-na sekembeleye?” nimu liemu olone i-siku niengili: “Ye-Awilimu yu ‘Dongimuni mepili.’ nimu-na ombo likimbulu. Yu dongi walomo kelepa nondopa yando lipa mundumba.” niengili.” nimba olo lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lipa mundorumu yetolo pungu, kongi dongi walo se, ulka kerepuluna ka seko panjeringimu kanokole kongi kanumu pungu poseringili. Aku siku sengele seringili kanokole ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","akuna gilieringi yombo marene olondo “Kongi dongi walomo nambi semu-na posikimbiliye?” ningu mangilku pilieringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","olone, Yesusini ‘i-siku i-siku nieli.’ nirimu mele niringili kinia “Manda, ⸤dongi walomo⸥ mengo pangili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kanu-kinia olone kongi dongi walomo Yesusi molorumuna mengo ongole, onone ononga mulu-maminiama kulku dongimunga bulu-mingina ola pauwa toringi kinia Yesusi kanuna ola molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yombo awisilini ononga mulu-maminiama kulku yu ombá aulkana pauwa tolko pungu, marene unju kipi kaliana pungu kipi gomo langoko liku yu ombá aulkana pauwa tolko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kumbi leko puringi yombomane kepe akileko puringi yombomane kepe kalkarukumba leko unju ambololeko pungu ninguli: “‘Yunga imbi ola molopili.’ niemili! ‘Pulu Ye Yawene lipa mundorumu-na yunga kongonomo sendemba okomo yemo molopa kondopili!’ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Olionga anda-kolepa ye nokoli kingi Depit⸤ni kalopa liltimu yemo⸥ ye nokoli kingi molomba sekemo yemo Pulu Yemone sepa kondopa ‘Yu tondolo pupili.’ nipili. Mulu-koleana ola yu imbi ola molopili!” niliku puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kanu-kinia Yesusi Jerusalleme sukundu pumbale Pulu Yemo popo toko kaloringi ulka-tembelena pumba akuna sukundu ⸤seko moloringi uluma⸥ pali kanorumu, aku-na-kolo kolea ipu lierimu-na kanopale ⸤ ‘Iseli-u ulu se naa sambo.’ nimba⸥ yu lombili andoli ye engaki rurepo kinia ⸤Jerusalleme⸥ ultukundu pungu, kolea-kanga Betani ⸤pengé⸥ puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Orili-u ⸤Jerusalleme nondopa lierimu⸥ kolea-kanga Betani munduku kelkole ⸤kelko Jerusalleme pungí puringi kinia⸥ Yesusi yu gele serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kanu-kinia yu unju piki se gomo sepa gilierimumu sulu sepa kanopale ‘Mongo se tomunje.’ nimba nondopa pumba kanorumu-na-kolo, piki mongo torumu walemo u wendo naa orumumunga unju mongo topa se naa perimu, gomoma mindi serimu kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","⸤Gomo mindi serimu-kulu⸥ kanopale “Nu kelko yombomane nonge mongo se naa tani!” nirimu. Aku nirimumu yu lombili andolimane pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalleme kamu oringi kinia Yesusi yu Pulu Yemo popo toko kaloringi ulka-tembelena ⸤ “Juda yombo naa molemele yomboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ sukundu pumba kanopale akuna mélema makete seko moloringi yomboma kinia, mélema topo toko liku moloringi yomboma kinia, akuma kanopale ono pali topa makoropa, kou-mone lupa lupama topele toko anju siringi yombomanga poloma kinia, kera waembonoma makete seko mania moloringi poloma kinia, lipa topele topa, topa bulu-balu sipa, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","yombomando nimbale: “Yomboma kou-mone lingí makete senge mélema kolea senga lupa makete senge pungíndu ulka-tembele palana naa pangi. ⸤Akanale seko pangi.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ono mane sipa nimbale: “Pulu Yemonga bokuna ungu se i-sipa nilimú: ‘Yombomane nanga ulkamondo “Koleamanga pali yombo talapemane Pulu Yemo kinia ungu nilimulu ulkamo.” ningí.’ kanumu ono naa pilielemeleye? Ungu aku sipa molemo-na-kolo onone i ulkamo ‘wa nolemele yomboma lopi seko molemele ulkamo’ mele ningu pilkuli aku siku selemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesusini aku nirimu-kulu pilkuli Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, ono yu toko kondonge aulka se kororingi. We-yomboma yuni mane sirimu mele pilkuli mini-wale mundoringi-kulu kanokole kanu Juda yombomanga ye awilimane yu pipili kolko yu toko kondonge aulka se kororingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pe ipupini, kolea kala tomba serimu kinia ⸤Jerusalleme⸥ ultu pumba ⸤senga pe-porumu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Orili-u, ⸤unju piki gilierimu koleana⸥ ongo punguli kanu unju pikimu kamu pulu pali kolorumu kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aku sipa serimu mele Pitane kanopale ⸤Yesusini unjumundu oleangakondo nirimu mele⸥ kelepa pilipale yundu nimbale: “Rapai, kána! I unju piki nuni ⸤oleanga⸥ iri tonumu ⸤waltikele⸥ kolomu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesusini pundu topa nimbale: “Pulu Yemone nanga ungumu sika pilimba⸤monga nimbú mele ‘Paa sika wendo ombá.’ ningu⸥ kuru mondangi! ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nane ono paa sika nimbu sikirumu: “Yombo sene ‘nane nimbú mele paa sika wendo ombá.’ nimba konopu talo sepa naa pepili ne ma-pangimundu “Ungú toko nomu-kusana sukundu pu!” nimbá kinia yu nimbá mele paa sika wendo ombá.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Akumunga ono i-sipu nimbu siembo: “‘Olio ⸤Pulu Yemone paa sika lipa tapondombamonga ‘Samili.’ nimulú mele sika manda aku sipu semolo.’ molo ‘Nimulú kinia sika aku sipa wendo ombá.’ ningu⸥ kuru mondokole Pulu Yemo kinia ungu ningu mawa senge mele pali Pulu Yemone sika sendembamonga kanu uluma sika wendo ombá.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“‘Ulu-pulu-kiri semuluma olionga Lapa, mulu-koleana molemomone ‘We mania pupili, siye kolambo.’ nipili.’ ningu, Pulu Yemo kinia ungu ningu gilkuli yombomane ono seko kinjingimunga konopu kiri panjiku molonge uluma ‘We mania pupili. Siye kolamili.’ niengila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Aku-sipa na-kolo yombomane ono seko kinjingí uluma ‘We mania pupili.’ ningu siye naa kolongi liemu ononga Lapa, mulu-koleana molemomone kepe onone ulu-pulu-kiri sengema ‘Mania pupili.’ naala nimba siye naala kolomba.)” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalleme kelko oringi kinia Yesusi yu ulka-tembelena sukundu andorumu kinia ye mare, Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Juda yombomanga tapu-yema kinia, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ono ongo yu mangilku pilku ninguli: “Nu namba nambolka nambamo likuli i kongonomo selenoye? Nawene i kongonomo ‘Se-pu.’ nimba nu nambamo sipa lipa mundorumuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesusini onondo pundu topa nimbale: “Nane ono ungu se mangilipu piliambola. Pe nane ono mangilimbu mele na sumbi siku pundu toko níngi liemu ‘Na i kongonomo sambo.’ nimba namba sirimumunga pulumu ono nimbu simbula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","⸤Nane i-sipu ono mangilipu pilkiru:⸥ U ⸤No Lindeli⸥ Jono omba yomboma no linderimu kinia yu mulu-koleana molemo yemonga kongonomo sendembando yomboma no linderimu molo ya mana-yombomanga kongonomo sendembando yomboma no linderimuye? ⸤Nawene “Sei.” nirimu-na serimuye?⸥ Ningu siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","⸤Yuni aku sipa mangilierimu mele pilkuli⸥ onone onono angelema ningu ninguli: “Yuni mangilkimu mele olione pundu topo, ‘⸤Jono⸥ yu mulu-koleana ⸤molemo yemonga kongono sendembando yomboma no linderimu⸥.’ nímulu liemu yuni oliondo nimbale: ‘Aku liemu ono Jonone nirimu ungumu nambi semu-na ‘I ungumu sika.’ ningu kuru naa mondoringiye?’ nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Molo olione nimbuli: ‘Yu mana-yombomanga ⸤kongonomo sendembando yomboma no linderimu⸥.’ nímulu liemu “We-yombomane olio tongenje.” ningu aku siku ningíndu pipili koloringi. We-yombomane ‘⸤No Lindeli⸥ Jono yu paa sika Pulu Yemone ungu-umbu tondorumumu pilipa yomboma nimba sirimu ye se molorumu.’ ningu pilielemele kene olio nambi semolonje?” ningu onono aku siku angelema niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","⸤Onono aku siku anju yando angelema ninguli⸥, Yesusindu pundu toko ninguli: “⸤Nuni mangilkinu mele⸥ olio naa pilkimulu.” niringi. Aku siku niringi kinia pilipale Yesusini onondo nimbale: “Manda. ⸤Nane ono mangilkiru ungumunga ungu se pundu toko naa nikimilimunga⸥ onone na mangilkimili ungumunga ungu se pundu topo, nando i kongonomo ‘Se-pu.’ nimba na lipa mundupa namba sirimu yemonga imbimu ono naa nimbu simbula.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Walte Yesusini ⸤Juda yombomanga ye awilimando⸥ ungu-ikuma ono topa simbando ungu-iku se i-sipa torumu: “Ye sene unju-waene kalia sepale pala serimu. Kaliana sukundu loyakolo akupa waene-no ingi sepa mondombando sepa wamopale nirimumuni, pe kalia nokonge ulka-takaya se polo kulupa ola takorumu. Ye mare kanopa lipa onondo nimbale: “Nanga kaliamo tapu sendeko unju mongoma inia toko nokondangi. Pe waene mongo polo tomba kinia unju mongoma moke sepo, kongono sendenge mele mare ono liengi, mare na liembo.” nimba kanu kaliamo ono sipale yu kolea paa suluringa pumba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kanu-kinia pe waene mongo polo tomba serimu kinia kalia pulu yemone yunga kendemande-ye se “Nanga waene-mongo siengi pungu liku mendeko wani pu.” nimba kalia nokoringi yema moloringina lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aku-na-kolo kendemande-yemo ⸤orumu kinia⸥ kalia nokoli yemane yu ambolko likuli yu wale awisili kopene toko waene mongo mare naa siku yando we liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kelepa kalia pulu yemone kendemande-ye se lipa ⸤ “Nanga waene mongo lindi-pou.” nimba lipa⸥ mundorumu. Aku-na-kolo yu ⸤orumu kinia⸥ kalia nokoli yemane yu ambolko likuli toko pengemo toko siku yu seko kinjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kelepa kalia pulu yemone kendemande-ye se lipa mundorumu kinia onone yu toko kondoringi. Kendemande-ye mare awisili mele lipa mundorumumanga mare wale awisili kopene toko, mare toko kondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kanu-kinia kalia pulu yemo yunga ye selu mindi molorumu, yunga malo, yu konopu mondorumu kangomo. Yuni ⸤konopumuni pilipale⸥ ‘Nanga kangomo pipili kolko liku awi siku, yu waene mongo mare singí.’ konopu lepale yunga malomo kamu lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Aku-sipa na-kolo kalia nokoli yemane kalia pulu yemonga malo ombá orumu kanokole onone onono ninguli: “Andi okomo yemo pe lapanga monge-mélema limba yemo okomo. Yu topo kondopo i kaliamo olio kamu liemili.” ninguli ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","onone yu ambolko liku toko kondoko ⸤yunga ónomo⸥ kaliana toko ultu mundoringi.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","⸤Yesusini ungu-iku akumu topa pora simbando kanu Juda yombomanga ye awilimando mangilipa nimbale:⸥ “Kalia nokoringi yemane aku seringimunga pe kalia pulu yemone ono-kinia nambolka unguri sembaye? Yu omba kanu ye kirima topa kondopa, ‘Ye marene lupa kaliamo nokondangi.’ nimba lipa simba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","⸤Yesusini Pulu Yemonga Juda yomboma nokoringi yemane yu toko kondonge mele pilipa onondo nimbale:⸥ “Pulu Yemonga bokuna sukundu ungu se kanoko naa pilielemeleye? ⸤Aku ungumu i-sipa mele:⸥ ‘Ulka takoringi yemane kanoko kiri pilku toko eltoringi kou kanumu kiniá kelepa ulka simu mele ulka enge sindeli kou awili peangamo.’ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","‘Ye-Awilimuni aku ungumu serimu olione kanopo paa peanga pilielemolo.’ nimba molemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","⸤Kanu Juda yombomanga ye awilima⸥ onone Yesusini ungu-iku torumu kanumu pilkuli onone yu toko kondonge seko moloringi mele yuni nirimu pilkuli onone yu ka singí seringi-na-kolo kanu ye awilimane we-yomboma pipili kolkole yu liku ka naa siringi. Yu munduku kelkole anju puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pe walte ⸤Juda yombomanga ye awilimane⸥ Parisi ye mare kinia ye nokoli kingi Erotenga talape ye mare kinia liku, “‘Yesusini ungu se nimba kinjepili.’ ningu i-siku i-siku yundu niengi.” ningu Yesusi molorumuna liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Liku mundoringi yemane Yesusi molorumuna ongo yundu ninguli: “Ungu Mane Sili Yemo, olio pilielemolo, ‘nuni ungu-sikama mindi ningu, nu yombo seluringa kepe konopu kimbu naa siku, yomboma pipili naa kolko onondo pali ungu selu-siku ningu siku, Pulu Yemone “Saa.” nilimú uluma paa sika unguma mane siku, aku siku seleno.’ konopu lemolo. ⸤Aku siku seko molenomonga nu nambolka konopu lekenoye?⸥ Olione Romo Gapomano Ye Paa Awili Kumbina ‘Sisa’ nílimu kou-takisi tomulu liemu manda molo móloye? Yu ⸤kou-takisi⸥ simulúne naa simulúne? Pulu Yemone akumundu ungu-mane sirimu ungu-mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aku-sipa na-kolo Yesusini ono topele-mapele toli yema molemele mele pilipale onondo nimbale: “‘Yuni nimba kinjepili.’ ningu nambi semu-na na manda manjiku kolo toko mangilkimiliye? ⸤Takisi tolemele⸥ kou-mongo se kanambo, mengo ongo siee.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","onone yu molorumuna se mengo ongo yu siringi. Kanu-kinia Yesusini onondo nimbale: “I kouna nawenga kumbikeremo kinia imbimu molemoye?” nirimu. Onone yundu ninguli: “Romo Gapomano Ye Paa Awili Kumbina Sisamonga kumbikeremo kinia imbimu molemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kanu-kinia yuni onondo nimbale: “⸤Kou-monemo Sisamonga⸥ kene Sisamonga mélema Sisamo yuyu siku, Pulu Yemonga mélema Pulu Yemo yuyu siee.” nirimu. Yuni aku sipa ⸤paa sumbi sipa⸥ nirimu mele pilkuli ⸤ ‘Yu paa pilipa kondoli pelemo yemo lepomo.’ ningu pilkuli⸥ konopu awisili liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","⸤Kanu yema Yesusi kinia kou-takisi toli ungumu ningu pora siringi kinia⸥ pe Sadusi ye mare Yesusi molorumuna oringi. Sadusi yema ono ‘Pulu Yemone pe kololemele yomboma topa naa makisindimba, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Aku Sadusi yema ongo Yesusi mangilku pilku ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ungu Mane Sili Yemo, ⸤Pulu Yemonga ungu-manema olio sirimu ye⸥ Mosisini ungu-mane sipa nimbale: “Ambo limba ye se bolango naa membale ambomo we molopili kolomba kinia kanu yemo yunga genu molombamone yunga ambo-wayamo lipa genu lipa tapondopa bolango mendepili.” nirimu aku sipa nimba bokuna torumu molemo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","⸤Aku ungu-manemonga ulu se olionga ye mare-kinia wendo orumu mele nu mangilipu piliamili.⸥ “Genupili yopoko-pakara moloringi. Komomo ambo lipa bolango se naa membale kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","⸤Bolango se naa molopili kolorumu-kulu⸥ yunga bulkundu genumuni ⸤yunga genu kolorumumunga bolango ‘Mendambo.’ nimba⸥ ambo-wayamo kelepa liltimu. Yu bolango se naa mendepale yu we kolorumula. Yunga genu bulkundumuni kanu ambomo liltimula-na-kolo yu kepe we kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aku selko punguli ye yopoko-pakara pali bolango selu kepe naa mengole kolko pora siringi kinia akiliumu we kolorumula. Pe ambomo yu kolorumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Akumunga, kololemele yomboma pe lomboroko ola molonge kinia kanu ambomo ye yopoko-pakara pali ya mana liltingi-kulu ambomo yu ye paa nawenga menu molombaye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesusini onondo pundu topa nimbale: “Ono Pulu Yemonga bokuna ungu molemoma kinia, Pulu Yemo-kinia tondolo pelemo mele kinia, naa pilku lo limilimunga ⸤yomboma pe sengemondo nikimili mele pilku sunduku kolo tokomele⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lomboroko ola molonge yombomanga yema ambo naa liku, amboma ye naa pungu, aku paa naa senge. Mulu-koleana molemele angelloma molemele mele aku siku molonge. ⸤Angellomane mana-yomboma selemele mele naa selemele kanumu.⸥ Aku sengemonga ⸤ ‘Ono Pulu Yemonga ungumu pilku sunduku lawa selemele.’ nikiru⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Aku-sipa na-kolo ⸤ono Sadusimane⸥ ‘Kololemele yomboma lomboroko ola naa molonge.’ konopu lemelemonga ungu se niembola. Mosisi unju kanga senga ⸤sepe nomba perimu sepemone unjumu naa norumu kanopale nirimumuni⸥ akuna Pulu Yemonga ungu se wendo omba Mosisindu ungu se nirimu semanemo onone naa kanoko pilielemeleye? Pulu Yemone Mosisindu nimbale: “Na Eporayamo kinia Aisake kinia Jekopo kinia ononga Pulu Yemo molio.” nirimu. Pulu Yemonga bokuna Mosisini torumu aku ungu molemomo naa kanoko pilielemeleye? ⸤ ‘Ononga Pulu Yemo molorundu.’ naa nirimu. ‘Ononga Pulu Yemo molio.’ nirimu kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pulu Yemo yu kololi yombomanga Pulu Yemo mólo; yu yombo konde mololimanga Pulu Yemo. Aku siku pilku sundukuli ono lo limili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","⸤Sadusi yema kinia Yesusi kinia⸥ aku siku angelema ningu molangi Pulu Yemonga ungu-manemanga puluma pilipa mane sirimu ye se omba ono anju yando angelema ningu moloringi omba pilierimu. Onone ungu mare Yesusindu mangilku pilieringi kinia yuni anju pundu topa nimba kondorumu mele pilipale ungu-mane sirimu yemone Yesusindu mangilipa pilipa nimbale: “Pulu Yemone ungu-mane sirimu pelemomanga pali nambolka ungu-manemo yu olandopamoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesusini pundu topa nimbale: “Ungu-mane olandopamo i-sipa: ‘Isirele yomboma, piliame! Ye-Awili Yawe olionga Pulu Yemo yu mindi Ye-Awili selumu molemo, se lupa mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Onone ononga kamelema kinia, ononga minima kinia, ononga pilipa kondolima kinia, ononga tondolomo kinia, akumane Ye-Awili Yawe ononga Pulu Yemo manjiku tondolo munduku konopu mondangi.’ nimba, ungu-mane paa olandopamo aku sipa ⸤nimba⸥ molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ungu-mane talo-sipamo i-sipa: ‘Onone onono yu-mele-mele konopu mondoko ononga kangimu onono kondo kolko nokolemele mele aku sikula pulu lemó yomboma konopu mondoko nokoko molangi.’ nimba molemo. Aku ungu-manetolonga olandopa se paa naa pelemo, mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","⸤Yesusini aku nirimu pilipale⸥ yemone yundu nimbale: “Ungu Mane Sili Yemo, papu nikinumu. Nuni ninguli: “Pulu Yemo selumu mindi molemo. We-se-lupa naa molemo. Yu yuyu molemo.” nikinumu paa sika nikinu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‘Yu konopu mondongendo onone ononga kamelema kinia, ononga pilipa kondolima kinia, ononga tondolomo kinia, akumane ⸤Ye-Awilimu ononga Pulu Yemo⸥ manjiku tondolo munduku konopu mondangi.’ nimba pelemo ungu-manemo kinia ‘Ono ononga kangima onono kondo kololemele mele yombo pulu lemóma aku siku kondo kolangi.’ nimba pelemo ungu-manemo kinia, aku ungu-manetolo semolo kinia olandopa; Pulu Yemo kongima kinia mélema popo topo kalopo “Imu nu sikiru.” nilimulu akumu maniandopa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yuni pundu topa nimba kondorumu pilipale Yesusini yundu nimbale: “Nu konopu leko molenomonga Pulu Yemone ye nokoli kingimu molopa nokolemo yombo talapena sukundu nondoko puni sekeno lémo.” nirimu. Kanu-kinia ⸤Yesusindu mangilku pilieringi unguma pali yuni pundu topa anju nimba kondorumu pilkuli⸥ kelko yu ungu se mangilku pilingindu pipili kolko naa mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena sukundu yomboma ungu-mane sipa molorumu. Mane sipa molopa ungu se nimbale: “Pulu Yemonga ungu-manemanga puluma pilku mane sili yemane ninguli: “Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu ⸤ye nokoli kingi⸥ Depitini kalopa limba yemo molomba.” nilimili akumu nambi semu-na “Yu Depitini kalopa limba yemo molomba.” nilimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","⸤Aku nilimili yemane⸥ Depiti yuni yuyu ⸤kanu yemondo nirimu mele naa pilielemelenje.⸥ Mini Kake Sélimu Depitinga konopuna molorumu kinia Depiti yuni ⸤ye nokoli Karasimu molomba mele⸥ nimbale: “Ye-Awili ⸤Pulu Ye Yawene⸥ nanga Ye-Awilimundu nimbale: “‘Nunga opa-touma nuni nokani.’ nimbu, pe ono topo mania mundundumbu kene iseli-u nu ⸤na kinia pea kopu sepo ye nokolitolo molopo mélema nokambili⸥ nanga ki-lomekondo ongo molani.” nirimu.” nimba Depitini nirimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depitini ⸤ye nokoli Karasimu⸥ yundu “Nu nanga Ye-Awilimu.” nirimu. Pe onone “Yu Depitini kalopa limba yemo ⸤mindi⸥ molomba.” nambi seko pilkuli nilimiliye?” nirimu. We-yombo awisili maku toko moloringima Yesusini nirimu unguma pilkuli konopu awili-seko siku pilku moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesusini ungu-mane sipa molopale nirimumuni ⸤liepi-liepi topa⸥ ungu se nimbale: “Onone Pulu Yemonga ungu-manemanga puluma pilku mane sili yema mimi siku kanoko kondoko ⸤onone selemele mele manda manjiku naa seko⸥ molayo. ⸤ ‘Yombomane olio kanoko “Ye peangama” niengi.’ ningu⸥ kanu yemane wale-pakoli paa sulu peangama, ⸤ye nokolima pakolemele mele,⸥ pakoko andolemele. Yomboma maku toko molemele koleamanga mongo-kenge seko andonge kinia ‘We-yombomane olio kape niengi.’ ningu pilkuli konopu siku pilku andoko molemelela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yomboma maku toko Pulu Yemonga ungumu pilielemele ulkamanga sukundu punguli mania molongendo ye awilima molemele polo peanga akuna mendo pungu polo akuna konopu siku molemelela. Yombomane kere-langi nongo yombomando “Namili waa.” nilimili kinia kanu yema ongole ye awilimanga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Yema kololemele kinia onone kanu yemanga ambo-wayama toko makoroko mundukuli ulkama ‘Olionga’ ningu we limili. Pulu Yemo kinia ungu ningíndu ningu sulu munduku we kolo toko nilimili. Pulu Yemone we-yomboma ulu-pulu-kiri selemelemonga ono sika “Mindili nangi.” nimbá-na-kolo ya ye nikirumane aku uluma selemelemonga Pulu Yemone aku yema “Mindili paa awili seko nangi.” nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesusi ⸤Pulu Yemo popo toko kaloringi ulka-tembele⸥ kerepuluna ulka-tembelena sukundu kongono senge kou-monema mundoringi unju-okolona nondopa mania molopale yombo awisilini aku unju-okolona kou-mone ongo mundoringi mele kanopa molorumu. Kanopa molorumu kinia yombo kamakomane kou-mone awisili ongo mundoringi kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","⸤Aku sipa kanopa molorumu kinia⸥ ambo-waya paa koropa se omba yu kou-kololi talo mindi mundorumu. Kanu kou-kololitolo lipa sere lepa kou paa koltalo mele mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","⸤Ambo-wayamone aku serimu kanopale⸥ Yesusini yu lombili andolima mangilipa “Waa.” nimba onondo nimbale: “Nane onondo paa sika nimbu sikirumu: “Andi ambo-waya koropamo yuni kou-mone mundukumumu paa olandopa mele mundukumu, we mundukumilima maniandopa mele.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ono kou-mone awisili taltolemelemanga koltalo mindi ongo mundukumili. Aku-sipa na-kolo ambo-wayamo kou-mone se paa naa taltolemo. Yunga kou koltalo taltomutolo pali memba omba mundomu. Kere-langi nombá kepe se naa taltolemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kanu-kinia Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena ultu pumbá purumu kinia yu lombili andolimanga ye sene yundu nimbale: “Ungu Mane Sili Yemo, tembelemonga ulka lupa lupama kinia, ulkama takoringi kou peanga lupa lupama kanou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","⸤Aku nirimu kinia⸥ Yesusini yundu nimbale: “Ya ⸤tembelemonga⸥ ulka lupa lupa peanga gilimú kanokomelema, pe ⸤walte ya kolea-awili Jerusalleme yomboma mindili nonge walemo wendo ombá kinia⸥ i tembelemonga ulkama pali sikisikuli kouma pali toko mania mundungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kanu-kinia yu ma-pangi Unju Ollipi Kaliana ola pumba ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena welkendo mania molorumuna we-yomboma naa molangi ⸤yu lombili andoli ye mare⸥ Pita keme, Jemisi keme, Jono keme, Enderu keme ono ongo, ono onono molkole yundu mangilku pilku ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nuni nikinu mele sewale wendo ombáye? Pe nuni i nikinu uluma nondopa wendo ombándo u nambolka unguri sembá kinia olio kanopole ‘Uluma i wendo ombá sepomo.’ nimbu pilimulúye? Olio ningu si.” ningu mangilieringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","yuni onondo nimbale: “⸤Kanu uluma wendo ombámonga ungu mare⸥ yombomane ono kolo toko singí kene kanoko kondoko molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ye awisili ongo na molio mele yu-mele-mele kolo toko ninguli: “⸤Pulu Yemone ‘Nanga yomboma nokopa kondomba ye se lipu mundumbu.’ nimba taltorumu ye nokoli Karasi⸥ akumu na.” ninguli aku siku kolo toko singí kene kanoko kondoko molangi. Yombo awisilini kanu yemanga unguma pilku liku “Sika nikimili.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kolea marenga opa awili seko senge mele pilku, ‘Opali talu opa awili i-sipa i-sipa wendo ombá.’ ningu we ningí kinia pilkuli mini-wale naa mundangi. Opa sengema kinia aku uluma Pulu Yemone ‘U wendo opili. Laye-kolte pe mele ya ma-koleamo pora nimbá.’ nimba, nimba panjerimumunga aku uluma sika wendo ombá-na-kolo aku-kinia mulu matolo u naa pora nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","⸤Mulu ma pora nimbá walemo u wendo naa opili umbuna awili mare wendo ombá.⸥ Yombo talape awili se kinia talape awili se kinia opa seko, ye nokoli kingi marenga talapema kinia marenga talapema kinia opa senge. Ya ma-kolea senga senga ma jimi-jimi sepa, gele lepa, aku sipa sembá. Ambo sene bolango kokele kanopa limbando u bulu-mini topa mindili nolemo mele, mulu ma pora nimbá walemo kokele wendo ombándo umbuna lupa lupa aku sipama u wendo ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“⸤Kanu uluma wendo ombá walemanga⸥ yomboma mimi siku kanangi. Onone ⸤ ‘Na lombili andoli yomboma mindili nongo, kolangi.’ ningu,⸥ ono ⸤mare liku ambolkole⸥ kanjollomanga makumanga mengo pungu kote sendeko, ono ⸤mare⸥ Juda yomboma maku toko Pulu Yemonga ungumu pilielemele ulkamanga liku mengo pungu kopene tongela. Ono nanga yomboma molongemonga ono ⸤mare ka siku⸥ gapomano ye awilima kinia ye nokoli kingima kinia molongena ⸤kote sendengendo⸥ mengo pungíla. Aku siku senge kene ono onono kanoko kondoko molayo. ⸤Aku-sipa na-kolo kote sendenge kinia kotena gilkuli kanu yema kinia kanu yema nokonge ye nokolima kinia⸥ onone ‘Nanga ungumu piliangi.’ ningu ono ningu singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Semane peangamo ‘Yomboma pali piliangi.’ ningu koleamanga pali andoko u ningu singí ⸤kinia, pe mulu ma pora nimbá walemo kamu wendo ombá⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ono ka siku kote sendenge kinia u ‘Kotena nambolka unguri nimulúnje? Olio ungu se mangilku pilingí kinia nambolka unguri pundu topo nimulúnje?’ ningu mini-wale naa mundangi. Ono ungu ningíma onono pilkuli naa ningí. Mini Kake Sélimuni ononga kerena molopale nimba simba unguma onone anju ningí kene aku senge enamonga ono ungu ningí mele pilkuli aku siku ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“⸤Aku walemanga⸥ genuni yunga kandi genu ⸤nanga yombo molombamonga⸥ ‘Kolopili toko kondangi.’ nimba kote sendemba. Lapane yunga kandi bolangoma akula sembá. Bolangomane kepe ononga kandi anupili lapali-kinia mumindili kolko kotena mengo pungu “Toko kondangi.” ningíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nanga yomboma molongemonga yombomane pali ono-kinia konopu kiri panjingí, aku-na-kolo na munduku naa kelko walema pora naa nipili tondolo munduku molonge yomboma Pulu Yemone lipa tapondopa ‘Mindili nonge koleana naa pungu pea molopo kondopo mindi pamili.’ nimbá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(⸤Na i bokumu tokoro yemone⸥ ono bokumu kanokomele yombomando ungu se niembo: ‘⸤Yesusini nirimu⸥ ungumu inia maniakondo molemo akumu ono imbi kanokomele yombomane ungu-pulumu paa pilku kondangi.’ ⸤nikiru. Yesusini nimbale:⸥) “⸤Yombo⸥ sepa pipili kondoli méle paa kirimu ⸤ulka-tembelena sukundu Pulu Yemonga Ulka Suluminia Kake Sélina Pulu Yemone⸥ “We-yomboma naa pangi!” nimba mi tolemo-na yu manda naa pumba gilimba, na-kolo walte akuna gilipale kolea akumu paa sepa kalaro mondomba. Aku mélemo akuna ⸤wendo omba⸥ gilimba kanokole ⸤ ‘Umbuna awilima wendo ombá sekemo.’ ningu pilku⸥ kolea Judia poropinji koleamanga molonge yomboma ⸤ononga koleama munduku kelko⸥ ma-pangi lembamanga kowa pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yombo se ulka imuna ola molopili ⸤aku sipa ulu se wendo ombá kinia kanopale kowa pumbándo⸥ mania omba ‘Mélema lipu membo pambo.’ nimba ulkana sukundu naa pupili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yombo se kaliana molopale ⸤ ‘Kowa pambo.’ nimba⸥ kelepa ulkando pumba yunga ali-wale sulumu naa lipili. ⸤Sumbi siku kowa mindi pangi.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aku sipa wendo ombá walemonga ambo bolango mondongema kinia, ambo bolango ame singíma kinia, ⸤ono manda lisiku kowa naa pungímunga⸥ ono-kinia paa umbuna wendo ombámonga ono kondo sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Pulu Yemondo mawa sekole, ‘Ali selemo olimanga kanu umbunama wendo naa opili.’ nieyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kanu walemanga umbuna paa awilima wendo ombá, Pulu Yemone u mulu ma pulu polopa serimu kinia kepe, yandopa kiniá kepe umbuna aku sipa se wendo naa orumu. Pe kepe aku sipa umbuna awilima naa wendo ombála. Akumunga aku siku Pulu Yemo kinia mawa sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","⸤Kanu umbunama wendo ombá kinia⸥ Ye-Awili ⸤Pulu Yemo⸥ne ‘Nondopa pora nipili.’ nimba u naa nimba panjilkanje yomboma pali kololemolá. Aku-na-kolo Pulu Yemone nimba taltopa ‘Nanga yomboma molangi.’ nirimu yomboma ‘Naa kolangi.’ nimba ‘Umbuna wale akuma nondopa pora nipili.’ nimba, nimba panjerimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kanu umbuna omba pemba walemanga yombo marene ninguli: “Kanaa! Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ u nimba taltorumu ye nokoli Karasimu ya omba molemo.” ningí molo “Nena omba molemo.” ningí kinia ononga unguma naa pilku, ‘Sika nikimili.’ ningu kuru naa mondangi! ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ye mare ongo kolo toko ninguli: “Pulu Yemone nimba taltorumu ye nokoli Karasimu na.” ningí, molo kolo tokole “Pulu Yemone ungu-umbu tondomuma pilipuli ombo nimbu sikimulu.” ningí. ‘Yomboma pali, Pulu Yemone ‘Nanga yomboma molangi.’ nimba, nimba taltorumu yombomane kepe lipu peke tondopo, nikimulu mele ‘Sika.’ ningu kuru mondangi!’ ningu Pulu Yemone mindi ulu-tondolo manda selemoma mele manda manjiku ulu-tondolo lupa lupama senge. Aku-sipa na-kolo Pulu Yemonga yomboma aku siku kondi tonge kinia ononga unguma naa pilku, mokoli senge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akumunga, pe ulu akuma wendo ombá mele ‘Ono u piliangi.’ nimbu ya nimbu sikiru mele pilkuli kanoko kondoko molaa!” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kanu walemanga aku mindili nonge nikiru uluma wendo ombá kinia pe ⸤ulu lupa lupa mare wendo ombála. Aku uluma i-sipa:⸥ ‘Kolea tangombando ena pa selemo mele naa sepa, simbulu topa, oli ipulieli pa selemo mele naa sepa, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kombokandima muluna mania omba, muluna gilimú mele tondoloma lope-lope sepa anju yando pumba, aku sipa ulu lupa lupama wendo ombá.’ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aku sembá walemonga Mania Omba Mana-Ye Au Lierimu Yemo tondolo púlimu kinia, pa awili-sepa sélimu kinia kupa senga sukundu molopa kamu mania ombá yombomane kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ombale yuni yunga angelloma lipa mundumba kinia ono winju mendo anju yando mulu ma koleamanga pali pungu Pulu Yemone ‘Nanga yomboma molangi.’ nimba u nimba taltorumu yomboma sukundu sukundu lingí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Unju pikimuni selemo aku sipa ungu-iku mele pelemo kene pilkuli ungu-pulumu piliaa. Unju piki kolamanga kirikiri sepa gomo tolemo kinia kanokole ‘Kiniá ena sembá walemo wendo ombá sekemo lémo.’ ningu pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aku sipala, i ulu “Wendo ombá.” nikiruma sika wendo ombá kinia kanokole ningímuni ‘Yu paa sika nondopa ombá sekemo. Yu paa kamu okomo.’ ningu pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Nane onondo paa sika nimbu sikirumu: “Kiniá molemele yomboma u naa kolangi i “Wendo ombá.” nikiru uluma pali wendo ombá.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mulu matolo pora nimbá-na-kolo nanga ungu niliuma paa pora naa nimbá. ⸤Niliu mele pali paa sika wendo ombá.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“⸤Mania Omba Mana-Ye Au Lierimu Yemo paa sika ombá⸥-na-kolo yu ombá walemo naa pilielemolo. Ipulieli ombáne, tangoli ombáne naa pilielemolo. Mulu-koleana angelloma kepe naa pilielemelela. Pulu Yemonga Malo kepe naala pilielemo. Tata yuyu mindi ⸤aku walemo⸥ pilipa molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yu kelepa ombá walemo ono naa pilielemele kene ‘Yu ombá.’ ningu kanoko kondoko, uru naa peko (Pulu Yemo kinia ungu ningu) molayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yu ombá walemo i-sipa: Ye se kolea marenga wale mare molomba pumbá selemo kinia yunga koleamo mundupa kelembando yunga kendemande-yombomando “Nanga koleamo nokondaa.” nimbale yunga kongonomo sendenge mele ono yu-mele-mele moke sepa sipa ulka-kerepulu nokolemo yemondo “Na walte ombó kene kanoko molou.” nimbale pulimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ulka pulu yemo sika ombá-na-kolo yu ombá walemo naa pilielemele kene ‘Yu ombá.’ ningu kanoko molayo. Ipupini ombá, molo awi-amburumi ombá, molo kolea tangombando kera gulta ko tolemo kinia ombá, molo ipulieli-u ombánje, ono naa pilielemele kene ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","‘ ‘Na uru peambo waltikele yu lipa sinjipa omba na kanomba.’ ningu, kanoko molangi.’ nimbu nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Onondo i nikiru mele yombomando pali nikirula, ‘⸤ ‘Ombá.’ ningu⸥ kanoko molangi.’ nimbu nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","⸤Juda yombomane kalia-ingi senga senga kolea-awili Jerusalleme ongo akuna sukundu⸥ Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilku, Pellawa Akoli Méle Isi Naa Munduku Pellawa We Kalko Noringi Walemo talu mele wendo ombándo, kiniá mele Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, onone Yesusi kiyongo ningu ka siku toko kondonge aulka se koroko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akumundu angelema ningu ninguli: “⸤Nondopo tamili,⸥ mangali Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu Mele ⸤Pilielemolo⸥ Walemanga ⸤ ‘unguma sepo molamili.’ ningu⸥ yombo awisili ya Jerusalleme ongo maku toko molongemonga yu iseli-u tomolo kinia onone olio-kinia mumindili kolko opa senge kene iseli-u naa topo, keleamili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kolea-kanga Betani ye se u kuru laká nomba kelierimu ye se, imbi leko “Ye Kuru Laká Noli Saimono” niringi kanumunga ulkana Yesusi pumba kere-langi nomba molopili ambo se wambola-mingi paa peanga se yu molorumuna memba orumu. Kanu wambola paa muna toli, natene seko wamoringi, akumunga kou-mone paa awili sepa purumu. Akumu memba ombale Yesusi kere-langi noli polo molorumuna memba omba ⸤ ‘Yu sepo kondambo.’ nimba⸥ mingimu kako topa wambolamo pengena ondondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yuni aku serimu kinia kanokole kanuna moloringimanga ye marene konopu kiri panjikuli anju yando onono ninguli: “Aku wambolamo nambi semu-na we sepa kinjikimuye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aku wambolamo kou-mone limolánje kou awisili, kou mongo wane tausini mele, lipuli yombo koropama moke sepo silimolá.” ningu ambomo tondolo munduku iri toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","⸤Onone ambomondo aku siku niringi pilipale⸥ Yesusini onondo nimbale: “I ambomo-kinia nambi semu-na ungu awisili nikimiliye? Yuni na-kinia ulu peanga se semu kene yu-kinia ungu awisili naa ningu munduku keleangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yombo koropama ono-kinia alieli molonge kene ‘Ono lipu tapondamili.’ ningí walemanga pali ono manda liku tapondonge-na-kolo na ono-kinia alieli naa molombo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ambomone ‘Manda sembó.’ konopu liemu mele semu. Na kolombo kinia óno sengemonga yuni iseli-u i wambola muna tolimu nanga kangina omba ondondomu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nane onondo paa sika nimbu sikirumu: “Ma-koleamanga pali ⸤nanga⸥ semane peangamo andoko toko singí kinia i ambomone kiniá semu semanemo kepe ‘Yombomane pilkuli ‘Yuni sepa kondorumu.’ ningu piliangi.’ ninguli aku semanemo toko singíla.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kanu-kinia ⸤Yesusi yu lombili andoli⸥ ye rurepo akumanga ye se, Judasi Isikeriote, ‘Pulu Yemo popo tondoringi ye awilimane Yesusi ka singí aulkamo yuni akisindambo.’ nimba ono moloringina pumba, sembá mele nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yuni sembá mele nirimu kinia pilkuli ono konopu awili-seko siku “Nu kou-mone se simulú.” ningu, ningu panjeringi. Kanu-kinia yu Yesusi ono lipa simba mele aulkamo koropa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pellawa Akoli Méle Isimu Naa Munduku Pellawa We Kalko Noringi Koromonga pulu-pulu walemo wendo orumu kinia Juda yombomane Pulu Yemone u ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingindu kongi sipisipi walo se toko nonge mele pilkuli niringimuni, Yesusi lombili andoli yema yu molorumuna ongo mangilku pilku ninguli: “Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walo se kiniá nonimu kolea sena pumbu sepo mimi se-pamili konopu lekenoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aku siku ningu mangilieringi kinia yuni yu lombili andoli talo lipa mundupa nimbale: “Ne kolea-awili ⸤Jerusalleme⸥ sukundu punguli, ye se mingina no kolopa memba ombá aulkana pungu kane-kane tokole yu lombili pangili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yu sukundu pumbá ulkana ⸤sukundu punguli⸥, ulka pulu yemondo ninguli: “Ungu Mane Síli Yemone i-sipa mangilipa nimbale: “Na kinia na lombili andolima kinia olione Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walomo sena nomoloye? Nomolo suluminiamo sena lemoye?” nimu.” niengili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aku ningilí kinia yuni olo ulkamonga olakondo suluminia awili se, akuna kere-langi noli polo se kinia, mania molomolo poloma kinia, mélema pali u seko mimi sengi lembamo, lipa ora simba. Aku suluminiamonga ⸤nomolo sipisipi walomo⸥ seko mimi sangili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kanu-kinia yu lombili andoli ye akutolo kolea-awili akumunga sukundu pungu, Yesusini nirimu kanu mele ulu akuma seli lierimu kanoko lendekole, akuna Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingí kongi sipisipi walo nongemo seko mimi seko taltoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ipupini ena pumba kolea kala torumu kinia Yesusi kinia yu lombili andoli rurepo kinia oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kere-langi nongo moloringi kinia Yesusini nimbale: “Nane onondo paa sika nimbu sikirumu: “Ono pea molopo kere-langi nokomolomanga ye sene na lipa nanga opa-touma simba.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","⸤Aku nirimu kinia pilkuli⸥ ononga konopuna umbuna serimu pilkuli yu-mele-mele mangilku ninguli: “Ye-Awilimu, nando nikinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesusini pundu topa nimbale: “Ono nanga ye rureponga ye se na kinia kere-langima polo awi-suku-singina ola lemó se waltikele lipu nombolo yemone na lipa, opa-touma anju simba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Kiniá Mania Omba Mana-Ye Au Lierimu Yemo kinia senge mele koronga-u ningu panjeringi semanemo ⸤Pulu Yemonga⸥ bokuna sukundu molemo mele sika opa-toumane senge, aku-na-kolo yu lipa opa-touma simba yemo mindili nomba paa molopa kinjimba. Yu molopa kinjimbamonga yu anumuni naa melkanje peanga. ⸤Yu mindili naa nolka.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ono kere-langi nongo moloringi kinia Yesusini berete se lipa Pulu Yemo kinia “Ange.” nimbale ambolopa peke lepa ⸤yu lombili andolima⸥ sipa nimbale: “Imu nanga kangimu ono liku ⸤nangi⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pe no-waene kapo se lipale Pulu Yemo kinia “Ange.” nimba ono sirimu kinia onone pali ⸤kanu no-waenemo⸥ noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yuni nimbale: “I ⸤no-waene⸥ sikirumu nanga mememo. Pulu Yemone ⸤yu kinia yunga yomboma kinia molonge mele⸥ ungu se nimba panjipa mi lierimu kanu ungumu ‘Kamu wendo omba pepili.’ nimbu yombo awisilinga nimbu nanga mememo ondondopole ⸤kolombo⸥ aku mememo imu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nane onondo paa sika nimbu sikirumu: “Iseli-u na no-waene kelepo paa naa nombó. Pe mindi, Pulu Yemo ye nokoli kingimu molopa nokolemo koleana no-waene kondemo kelepo nombó.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","⸤Kere-langi nongo pora sikuli⸥ ono Pulu Yemonga konane se ninguli, pena pungu ma-pangi Unju Ollipi Kaliana ola puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kanu-kinia Yesusini lombili andolimando nimbale: “Pe ⸤opa-toumane na-kinia sengemonga kanokole⸥ onone pali na munduku kelenge. Aku siku senge mele Pulu Yemone u nirimu yunga bokuna molemo kanumu. Pulu Yemone ⸤ungu-iku se topa⸥ nimbale: “ “Kongi sipisipi tapu-yemo tangi.” nimbú, yu tonge kinia sipisipima bulu-balu ningí.” nirimu, ⸤aku mele kiniá wendo ombá⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","⸤Iseli-u na toko kondonge kinia ono sika bulu-balu ningí⸥-na-kolo na lomboropo ola molopole nimbúmuni, na kumbi lepo kolea Gallillindu pumbú, ono pe akileko akuna onge kinia ⸤kelepa pea molomolo⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","⸤Yesusini aku sipa nirimu kinia pilipale⸥ Pitane nimbale: “Onone pali ‘Nu sika’ ningu kuru mondolemele mele mania pumbá kinia nu munduku keliengi liemu nane nu aku sipu paa mundupu naa kelembo, paa mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesusini pundu topa nimbale: “Nane nu paa sika nimbu sikirumu: “Paa kiniá ipulieli, kera gulta wale talo-sipamo u ko naa topili nuni pipili kolkole wale yopoko nando kolo toko “Yu nawe? Na naa kanolio.” nini.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aku-na-kolo Pitane tondolo mundupa nimbale: “Na nu-kinia kopu selembolomonga olto pea “Topo kondomolo.” níngi liemu kepe nu “Naa kanolio.” paa naa nimbú.” nirimu. Lombili andoli ye wemane pali “ “Nu naa kanolemolo.” paa naa nimulú.” niringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","⸤Kanu-kinia⸥ Yesusi kinia yu lombili andoli yema kinia kolea ‘Gesemani’ nilina puringi. Akuna puringi kinia yuni onondo nimbale: “Na Pulu Yemo kinia ungu ni-pukuru kene ono ya molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aku nimbale Pita keme Jemisi keme Jono keme lipa memba pumbale ⸤ ‘Na seko kinjingí ulumu paa nondopa wendo ombá sekemo.’ nimba pilipale⸥ yu yuyu kondo kolopa konopu kiri panjipa kamelena mindili sepili molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yuni onondo nimbale: “Nanga konopuna umbuna paa awili se sepomomonga na kolombo none sekemo. Ono uru naa peko, ya kanoko kondoko molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aku nimbale yu yuyu kanga-kolte anju pumba komorongo langopa tamalu pepale yu-kinia nondopa wendo ombá mele ‘Wendo naa omu liemu paa peanga.’ nimba Pulu Yemo-kinia ⸤ungu-iku topa⸥ mawa sepa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Nanga Tata, nuni uluma pali manda seleno kene na mindili noli no-mingina no nombómo ‘Naa nambo.’ nieni. Aku-sipa na-kolo ‘Nane sepole nanu konopu simbú.’ konopu lekero mele naa sambo. Nuni kanoko peanga piliení ulumu mindi sambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aku nimbale kelepa yunga lombili andoli ye yopoko moloringina yando omba ono uru peringi kanopale Pitando nimbale: “Saimono, nu uru penu lémo. Nu uru naa peko ena kanga-kolte manda we kanoko kondoko naa molenaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‘⸤Kurumanga nokoli Setenene⸥ olio kondi tomba kinia sepo kinjimulú kene.’ ninguli ⸤uru naa peko⸥ Pulu Yemo kinia ungu ningu kanoko kondoko molayo. Sika ‘sepo kondamili.’ nimbu konopumane pilielemolo-na-kolo semolondo kangimu siye sepa tondolo naa pulimú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aku sipa nimbale yu kelepa anju pumba u Pulu Yemo kinia ungu nimba mawa serimu mele kelepa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kelepa yando orumu kinia ono uru paa orumu-kulu kelko uru peringi kanorumu. Onone uru peringimunga pipili kolkole yundu ningí mele naa pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","⸤Kelepa⸥ wale yopoko-sipamonga ⸤anju pumba Pulu Yemo kinia ungu nimbá pumba⸥ kelepa yando omba yuni onondo nimbale: “Nambi semu-na we uru peko múlu pilku molemeleye? Manda peame! Mania Omba Mana-Ye Au Lierimu Yemo ⸤tonge⸥ ulu-pulu-kiri selemele yema liku singí enamo wendo ombá sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ola gilku pamili wame! Na lipa anju simba yemo okomo kanaa!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesusini ⸤kolea Gesemani yu lombili andolimando⸥ aku nimba molopili yu lombili andoli rurepo akumanga ye Judasi orumu. Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Juda yombomanga tapu-yema kinia, kanu yemane liku mundoringi ye awisili, yombo toli lu-pultama kinia kopema kinia mengo Judasi kinia oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","U Yesusi molorumuna naa wangi Yesusi Juda ye awilima lipa simba nimba panjerimu ye ⸤Judasini⸥ ono Yesusi yu ipulieli manda kanonge mele nimba sipa nimbale: “Nane ye se kanopo kangulumbu akumu Yesusi. Yu ambolko ka siku mengo pangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","⸤Aku yema⸥ oringi kinia ⸤Judasi⸥ yu Yesusi molorumuna sumbi sipa ombale “Rapai, nu akuna gilienu lémo.” nimba omba yu kangulorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aku serimu kinia kanokole Yesusi liku ka siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aku seringi kinia kanopale ⸤Yesusi-kinia⸥ nondoko gilieringi ye senga lu koyamo kulu topa wendo lipa Pulu Yemo popo tondoringi ye awili olandopamonga kendemande-ye se yunga komu se topa laka lenderimu, aku komumu wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kanu-kinia Yesusini ⸤yu ka singí oringi⸥ yemando nimbale: “Na ‘yombo topo wa noli yere molio.’ konopu lekole na ka singíndu yombo toli lu-pultama kinia kopema mengo okomeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ulka-tembele ⸤kerepuluna we-yomboma maku toko molemele⸥ koleana alieli ono pea molemolo kinia ungu-mane sipu molio kinia na liku ka naa silimili kanumu. Aku-sipa na-kolo ⸤Pulu Yemonga⸥ bokuna toringi molemo mele kamu wendo ombámonga onone senge sekemele uluma wendo okomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kanu-kinia yu lombili andolima pali ⸤ ‘Olio pea ka singínje.’ ningu pilkuli⸥ yu munduku kelko ono talopa leko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kango ye se mulu-maminia selu mindi pakopa Yesusi lombili andorumu. Kanu kangomo ⸤Yesusi ka siringi yemane⸥ amboloringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yunga mulu-maminiamo ⸤mindi⸥ ambolko molangi, mélse naa panjipa we-we talopa lepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kanu-kinia Yesusi ⸤ka sikuli⸥ Pulu Yemo popo tondoringi ye awili olandopamo molorumuna mengo puringi. Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga tapu-yema kinia, ⸤Pulu Yemonga⸥ ungu-manemanga puluma pilku mane siringi yema kinia, onone pali ⸤ ‘Yesusi kote sendepo piliamili.’ ningu⸥ akuna ongo maku toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesusi ⸤mengo puringi⸥ kinia Pita lombili akilepa taka lepa pumba, Pulu Yemo popo tondoringi ye awili olandopamonga ulkana, ulka gilipa makapu serimu, awi-suku-singina yombo maku toringi kolea we lierimuna paa sukundu pumba, ⸤Yesusi nokoko moloringi⸥ ele-yema kinia sepe pilipa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga kanjollo yema pali kinia, akumane Yesusi yu toko kondongendo ungu se sepa kinjerimu ungu se ‘Yombo sene ‘yu i-sipa i-sipa sepa kinjerimu.’ nipili.’ ningu yombo se kororingi-na-kolo yombo se naa kanoko liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yombo awisilini ongo ungu mare kolo toko “I-sipa i-sipa sepa kinjerimu.” niringi-na-kolo ononga unguma seluna naa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kanu-kinia ye marene yu sepa kinjerimu mele ola gilku kolo toko ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“I yemo i-sipa nirimu pilierimulu: “I ⸤Pulu Yemo popo toko kalolemolo⸥ ulka-tembelemo, mana-yemane takoringimu nane topo sikisipuli mana-yemane manda naa takonge ulka se wale yopoko omba pupili kolali sepo takombo.” nirimu. ⸤Yuni aku nirimumunga ‘Yu Pulu Yemo mele molio.’ konopu lepale aku nirimumu nimba kinjerimunje⸥.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ono kepe laye-kolte lupa lupa niringi, ononga unguma seluna naala purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aku niringi pilipale Pulu Yemo popo tondoringi ye awili olandopamo ono maku toringina ola gilipa Yesusi mangilipa nimbale: “Ungu se pundu toko naa nikinuye? Nu seko kinjerinu mele nikimilimu nambolka ulumu seko kinjerinumundu nikimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aku-sipa na-kolo Yesusi ungu se pundu topa naa nimba we gilierimu. Pulu Yemo popo tondoringi ye awili olandopamone yu kelepa mangilipa pilipa nimbale: “Pulu Yemone olio ‘Nokopa kondomba ye se lipu mundumbu.’ u nimba taltorumu ye nokoli Karasimu sika nu molo móloye? Kape Nimbu Imbi Ambolopo Paka Tondolemolomonga Malo nu molo móloye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesusini nimbale: “Akumu na.” nirimu. “Pe walte Mania Omba Mana-Ye Au Lierimu Yemo, Ye Tondolo Olandopa Púlimu ⸤kinia mélema nokombando⸥ yunga ki-lomekondo molopa, kupamanga ola molopa mania ombá ono kanonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aku sipa nirimumunga ⸤yu ‘Pulu Yemo mele molio.’ nimba nirimu-kulu⸥ pilipale Pulu Yemo popo tondoringi ye awili olandopamone ⸤paa pilipa kiri pilipa⸥ yunga wale-pakolimu yuyu ambolopa sungu sipa nimbale: “Kiniá yuni mongo liltimu mele nimba simba yombo se pea nambi semu-na koromoloye? ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yu yuyu paa sika Pulu Yemo ungu-taka tondokomo pilkimulu. Nambolka konopu lekemeleye? ⸤Yu-kinia nambi samiliye?⸥” nirimu kinia onone ninguli: “Yu Pulu Yemo ungu-taka tondopa marake semumunga topo kondomulu liemu papu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kanu-kinia ononga ye marene yunga kumbikerena elkambe toko munduku, yunga kumbikeremo mulu-maminia sene pipi sindikuli ki-lumuni toko ⸤ “Nu ‘Pulu Yemonga yere molio.’ konopu leno kene⸥ nawene nu tokomonje ningu si!” niringi. Ele-yemane yu liku laruwane toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kanu-kinia Pita ulka maniakondo, yomboma liku maku toko moloringi koleana molorumu kinia Pulu Yemo popo tondoringi ye awili olandopamonga kendemande-ambo se Pita molorumuna ombale ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","yu sepe pilipa molorumu kanopale neme-neme nimba kanopa nimbale: “Nu kepe Nasarete ye Yesusi kinia pea kopu seko moloringi kanumanga ye se lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pitane kolo topale “Mólo!” nimba “Nu nikinu mele na naa pilkiru!” nirimu. Aku sipa nimbale ulka kerepuluna purumu kinia kera gulta ko torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita yu ulka kerepuluna pumba molopili kanu kendemande-ambomone yu kanopale akuna gilieringi yombomando kelepa nimbale: “I yemo Yesusinga talape ye se lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitane kelepa “Mólo!” nirimu. Laye-kolte pe mele Pita gilierimuna nondoko gilieringi yemane ⸤yu ungu laye-kolte lupa mele nirimu pilkuli⸥ yundu ninguli: “Kolea Gallilli disiriki yombomane ungu nilimili mele nu aku siku ungu nikinu pilkimulu. ⸤Yesusi kinia yu lombili andoli yema kinia kolea Gallilli disiriki yemala,⸥ nu kepe Gallilli ye se, aku kene ‘Nu paa sika yu lombili andoli ye se.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aku niringi kinia Pitane Pulu Yemonga imbi lepa tondolo mundupa mi lepa nimbale: “Paa sika nikiru. “Ono nikimili yemo paa naa kanolio! Kolo tokoro liemu Pulu Yemone na topa kondopili.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aku nirimu kinia popenge sepa kera gulta wale talo-sipa ko torumu. Aku serimu kinia pilipale Yesusini yundu “Kera gulta wale talo-sipa ko naa topili nuni wale yopoko kolo tokole “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilierimu. Pilipale ⸤ ‘Ama, paa sepo kinjendu lepomo. ‘Paa naa sembó.’ konopu lierindu mele sika sendu.’ nimba pilipale⸥ kola paa awili sepa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Orili-u kolea kokele tangorumu kinia Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga tapu-yema kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, kanjollo yema pali, ⸤Yesusinga kotemo pilku pora sikuli⸥ onone pali ⸤yu senge mele⸥ ungu se ningu panjeringi. Aku ningu panjikuli yu liku, ka toko, mengo pungu, ⸤Romo-gapomano ye nokoli⸥ Paillate molorumuna mengo pungu kote senderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paillatene ⸤Yesusinga kotemo pilipale⸥ yu mangilipa pilipa nimbale: “Nu Juda yombomanga ye nokoli kingimu molo móloye?” nirimu. Yesusini pundu topa nimbale: “Sika nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pulu Yemo popo tondoringi ye awilimane Yesusi kote sendeko Paillatendo ⸤kolo toko⸥ ungu awisili ninguli ningíndu “Yesusi yu sepa kinjilimú.” ningu yu kote senderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aku niringimunga Paillatene Yesusindu nimbale: “Nu ulu kiri awisili serinu nikimili mele pilkuli ungu se pundu toko naa nikinuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aku-na-kolo Yesusi ⸤yu sepa kinjerimu niringi mele⸥ pundu topa ungu selu kepe naa nimba ⸤we gilierimu kinia kanopale⸥ Paillate mini-wale mundupa konopu awisili lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","⸤Yesusi kote sendeko molangi,⸥ ye se, yunga imbi Barapasi, yu kinia ye mare kinia ‘Romo-gapomanomone olio Juda yomboma naa nokopili.’ ningu u Romo-gapomanomo kinia opa sekole yombo mare toko kondoringimunga ka-ulkana peringi. ⸤Kalia-ingi senga senga Juda yombomane kolea-awili Jerusalleme ongo akuna sukundu⸥ Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingindu kere-langi noringi walema wendo orumu kinia onone ka-ulkana perimu ye se imbi leko ‘Wendo liku mundou.’ ningu mawa seringi kinia ⸤Romo-gapomano ye nokolimuni⸥ kanu yemo wendo lipa yomboma sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","⸤Romo ye nokolimuni kanu walemo wendo orumu kinia aku serimu mele pilkuli⸥ yomboma ongo yundu mawa seko ninguli: “U kalia-ingi selu selu ningu i walemo kinia seleno mele kiniá kepe aku siku sani.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aku niringi pilipale Paillatene onondo mangilipa nimbale: “‘Juda yombomanga ye nokoli kingimu wendo lipu ono siembo.’ konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","⸤We-yombomane Juda yombomanga ye awilima munduku kelko ononga unguma pilku mokoli seko Yesusinga ungumu pilku yu lombili andoringimunga⸥ Pulu Yemo popo tondoringi ye awilimane Yesusi-kinia konopu kiri panjikuli kote senderingi-na pilipale Paillatene aku sipa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aku-sipa na-kolo Pulu Yemo popo tondoringi ye awilima we-yomboma kondi toko ungu-umbu tondokole “ “Yesusi mólo. Barapasi wendo lipa sipili.” niee!” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aku niringi kinia pilipale Paillatene onondo nimbale: “Aku liemu ‘Juda yombomanga ye nokoli kingi’ nilimilimu nambi sambonje.” nimba mangilierimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","onone tondolo munduku ninguli: “Yu unju-perana kolopili uku toko panjei!” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aku niringi pilipale yuni onondo nimbale: “Aku nambi semuye? Yu mongo nambolka mongore limuye?” nirimu. Aku-na-kolo onone ⸤kelko⸥ paa tondolo munduku ninguli: “Mólo! Yu kolopili, unju-perana uku toko panjei!” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kanu-kinia Paillatene ‘Na-kinia konopu peanga leangi.’ nimbale ye Barapasi ka-ulkana wendo lipa ono sirimu. ⸤Aku sepale⸥ Yesusi lipa ⸤yunga ami-yema⸥ sipa nimbale: “Yu ka-pultane tokole pe ‘Unju-perana kolopili.’ ningu mengo pungu unju-perana uku toko panji-paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kanu-kinia ⸤Romo⸥ ami-yemane Yesusi liku gapomano ye nokolimu perimu ulka awili akuna sukundu yomboma liku maku toringi koleana punguli, ononga ami talape yema pali “⸤Yesusi ya molemona⸥ sukundu sukundu waa.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Akuna ongole niringimuni ‘Yu ye nokoli kingi se none sepili.’ ningu mulu-maminia kondoli peanga se pakondoko unju ka koko molorumu se mulkowe seko ‘Ye nokoli kingimunga waniemo.’ ningu pengena mere mundunduku, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","pe yu ⸤ungu-taka tondoko⸥ imbi we kólo toko ambolko paka tondongendo “Juda yombomanga ye nokoli kingimu, nu gilinuye?” ningu ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","⸤koló kope liku⸥ yu pengena kope to-pu-pu sekole kumbikerena elkambe toko kandoko, yu gilierimuna ongo komorongo toko pondoko tamalu peko yu we kólo toko kape ningu imbi ambolko paka tondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yu aku siku ungu-taka tondoko pora sikuli mulu-maminia kondolimu kulunduku yunga u panjerimu mulu-maminiama kelko panjindikuli “Yu unju-perana kolopili uku topo panji-pamolo.” ningu yu liku ultukundu mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","⸤Romo ami-yemane Yesusi Jerusalleme pala ultukundu mengo pungí punguli niringimuni,⸥ kolea Sairini ye se, yu Allekesanda kinia Rupasitolonga lapa Saimono, yu Jerusalleme pumbá orumu kinia kanokole yu ambolko liku ka mele siku Yesusi kolomba unju-peramo “Kolali seko mendei!” ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Punguli kolea Golkota Yesusi mengo pungu akuna moloringi. (Golkotanga ungu-pulumu ‘penge bele lieli koleamo’ .) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","⸤Yesusi akuna mengo punguli niringimuni, ‘Yomboma mindili naa nangi.’ ningu⸥ no-waenena sukundu marasene ‘mo’ nili se munduku taltoringi aku no-waenemo ‘Yu nopili.’ ningu, siringi-na-kolo naa lipa norumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kanu-kinia ⸤ami-yemane⸥ yu unju-perana ola uku toko panjikuli unjumu liku ola anjeringi. ⸤Aku sekole, u unjuna ola uku toko naa panjikuli⸥ yunga mulu-maminia ⸤kulunduku taltoringima⸥ ‘Moke samili.’ ningu ono yu-mele-mele lingí mele pilingindu kou-kate seko pe mulu-maminiama liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ena topa nane killoko serimu kinia yu unju-perana panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","‘Yu mongo liltimu mele yomboma kanangi.’ ningu I YEMO JUDA YOMBOMANGA YE NOKOLI KINGIMU ningu imbi toko unjuna ola mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Opa seko mélema wa liltingili ye talo pea unju talonga uku toko panjeringila. Se Yesusi yunga ki-lomekondo uku toko, se ki-tarokondo uku toko panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Yesusi kinia aku sili seringili ye talo pea unju-pera yopokonga uku toko panjeringimunga ungu se u Aisayane nimba boku torumu mele wendo orumu. Aku ungumu i-sipa: “Yu kepe gapomano ungu-manema pulua toko seko kinjiku mongo lili yomboma kinia liku sere lenderingi.” nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Akuna ongo puringi yombomane Yesusi ⸤kanoko kiri pilkuli yu⸥ ungu-taka tondoko iri mele toko ninguli: “Aa! “Ulka-tembelemo sikisipuli kelepo wale yopoko omba pupili takopo limbu.” nirinu yemo, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","‘Naa kolambo.’ ningu nu nunu liku tapondoko unju-perana mania ou.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aku sikula Pulu Yemo popo tondoringi ye awilima kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia onone kepe yu ungu-taka tondoko ninguli: “Yu yombo wema ‘Naa kolangi.’ nimba lipa tapondorumu-na-kolo yu yuyu ‘Naa kolambo.’ nimba manda naa lipa tapondokomo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yu sika Pulu Yemone olio ‘Nokopa kondomba ye se lipu mundumbu.’ u nimba taltorumu ye nokoli Karasimu omba molopa, yu sika olio Isirele yombomanga ye nokoli kingimu molemo liemu yu yuyu unjuna mania opili. Yu yuyu mania ombá kinia kanopole ‘Yu sika Pulu Yemone nimba taltopa lipa mundorumu ye nokoli Karasimu. Yu sika olionga ye nokoli kingimu.’ nimbu kuru mondomolo.” niringi. Ye talo yu-kinia unjutolonga uku toko panjeringi yetolone yu aku siku ungu-taka tondoringilila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","⸤Yesusi unjuna ola we pepili⸥ awi-tangoli ena tuwellepo killoko serimu kinia kolea pali simbulu topale, pe ipupini ena tere killoko serimu kinia kelepa tangorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ipupini ena tere killoko serimu kinia Yesusini ru nimba nimbale: “Elloi, Elloi, llama sapakatani.” nirimu. Akumu Juda yombomanga ungu se. Akumunga ungu-pulumu i-sipa: “Nanga Pulu Yemo, nanga Pulu Yemo, na nambi semu-na munduku kelienuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akuna nondoko gilieringimanga marene yuni aku nirimu kinia pilku ⸤sunduku⸥ ninguli: “Piliame! Yu Illainja mangilkimu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aku nirimu kinia pilieringimanga ye se lisipa pumba ulú-pinja mele se lipa no-waene kombili seli mare akuna panjipale, ‘Yesusi no-waene kombili seli pinjana pelemomo nopili.’ nimba memba omba unju-pepena senga ka topa olando sirimu. Sipa yuni nimbale: “Kiniá unjuna we pepili. Illainjane sika yu ⸤unjuna⸥ mania limbando okomonje, kanopo kanamili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesusi ungu se tondolo mundupa nimbale kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","⸤Romo⸥ ami-ye wane anderete nokorumu ye se Yesusi toringi ami-yema nokopa molorumu kanu yemone Yesusi ungu se nimba kolorumu mele pilipa kanopa nimbale: “I yemo yu paa sika Pulu Yemonga malo lepomo.” nirimu. ⸤Yesusi aku sipa kolorumu kinia ulu awili se waltikele wendo orumu.⸥ Pulu Yemo popo toko kaloringi ulka-tembele ⸤Jerusalleme sukundu gilierimu akuna sukundu Pulu Yemo molorumu⸥ Suluminia Paa Kake Sélimunga kerepuluna ⸤ ‘Yomboma sukundu naa pangi.’ ningu u alieli⸥ mulu-maminia awili sene pipi siku panjeringi gilierimu. ⸤Yesusi kolopa pora sirimu kinia⸥ kanu mulu-maminiamo awi-suku-singina olakondo maniando sipa olá torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ambo mare ⸤Yesusi toringi mele⸥ sulu seko kanoko gilieringi. Akumanga ambo se Makatalla taono ambo Maria, se Josese kinia genu Jemisi kinia olonga anumu Maria, se ambo Sallomi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesusi kolea Gallilli disiriki, ⸤kanu ambomanga pulu kolea,⸥ akuna u we andorumu kinia kanu amboma yu lombili andoko liku tapondoko nokoringi. Yu kinia, Jerusalleme olando oringi ambo awisili wema kepe, ambo pokore kanoko gilieringi akuna ono kepe ⸤Yesusi toringi mele⸥ kanoko gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Opalikundu ⸤koro moloringi⸥ wale Sambatemo nondopa wendo ombá serimu. Sambate walemo wendo ombá kinia koro molongendo kiniá mele mélema liku undu-undu siringi walemo wendo orumu, aku walemonga ⸤Yesusi u kolopili⸥ kolea kala tomba serimu kinia, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatia taono ye Josepo, yu Juda yombomanga kanjollo ye awili se molopa, yu kepe ‘Pulu Yemo ye nokoli kingimu molopa olio nokomba walemo wendo opili.’ nimba nokopa molorumu yemo. Yu omba pipili naa kolopa ⸤Romo-gapomano ye nokoli⸥ Paillate molorumuna sumbi sipa pumba “Yesusinga ónomo na si.” nimba mawa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesusi waltikele kolorumu pilipale Paillate yuni ⸤ ‘Yomboma unju-perana uku topo panjilimulu kinia ena awisili omba pupili we pelemele. Pe kiniá yu sika waltikele kolomunje molo nambi semunje?’ nimba pilipa⸥ konopu lipa mundupa ami-ye wane anderete nokorumu yemo “Opili.” nimba yundu mangilipale “Yesusi koronga kolomuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ami-yema nokoli yemone “E.” nirimu kinia pilipale yuni ami-yema nokolimundu nimbale: “Manda, ya yemone ⸤Yesusinga⸥ ónomo lipili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","⸤Paillatene “Manda.” nirimu kinia⸥ Josepo pumba mulu-maminia se topo topa lipa ónomo mania lipa, múlumuni okopale kou-kande se u akuku taltoringi kou-kandemonga sukundu memba pumba taltorumu. Taltopale kou-kande kere-puluna kou awili se perele-marele memba omba pipi sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makatalla taono ambo Maria kinia Josese anumu Maria-tolone yunga ónomo ⸤kou-kandena⸥ taltorumu mele kanoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena pumba ipu lierimu kinia ⸤koro moloringi⸥ wale Sambatemo omba purumu kinia Makatalla taono ambo Maria keme Jemisi anumu Maria keme ambo Sallomi keme onone ‘Yesusinga ónona wambola muna toli pokore ape kandondamili.’ ningu mare topo toko liku ⸤taltoko peringi⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pekole paa orili-u, ononga pulu-pulu kongono walemo wendo ombándo ena mundi orumu kinia kanu amboma pungu ⸤Yesusinga⸥ ónomo taltoringi kou-kandena pungí punguli niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","anju yando mangilku ninguli: “Kou-kande kerepulumu pipi siringi koumu nawene wendo lipa perele-marele memba pumba taltondombanje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aku-sipa na-kolo ongo olando siku kanoringi kinia kou kanumu, paa kou kapo awilimu, u wendo liku perele-marele mengo pungu taltoringi, ⸤kerepulumu we lierimu⸥ kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kou-kandena sukundu punguli kou-kandemonga ki-lomekondo ye-kango se mulu-maminia sulu paa kake seli se pakopa molorumumu kanokole mini-wale munduku konopu liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kanu-kinia yuni onondo nimbale: “Konopu liku naa mundayo. Kolea Nasarete ye Yesusi ‘Kolopili.’ ningu talko unju-perana uku toko panjeringi kanu yemo kanonge okomelemo na pilkiru. Yu lomboropa ola molopa omba pumu. Ya naa lemó. Ónomo u taltoringi koleamo ongo kaname. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kanokole anju pungu Pita keme yu lombili andolima kinia pali i-siku ningu siengi: “Yesusi kolea Gallilli disiriki kumbi lepa pulimú kene akuna “Onone na kanonge.” u nirimu mele sika onone akuna yu kanonge.” ningu si-paa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","⸤Angellomone aku sipa omba mona molopale nirimu mele⸥ kanoko pilkuli amboma pungu-pungu ningu konopu awisili liku mundukuli kou-kandena ultu pungu munduku kelko paa lisiku puringi. Pipili kolkole yombo selu kepe kanoko pilieringi mele ningu naa siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Juda yombomanga pulu-pulu kongono walemo kinia, paa orili-u, Yesusi lomboropa ola molopale nirimumuni, Makatalla taono ambo Maria, u walte kuru yopoko-pakara konopuna moloringima Yesusini topa makororumu ambo kanumu molorumuna pumba ⸤ ‘Na lomboropo ola molondu we molio mele kanopili.’ nimba⸥ lipa ora sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kanu-kinia Yesusi ⸤mona gilierimu⸥ kanopale ambomo yu pumba, u Yesusi kinia moloringi yomboma kamelé mindili nongo kola seko moloringina pumbale kanorumu mele ono nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yuni ono Yesusi konde molorumu mele kanopale nimba sirimu kinia pilkuli ‘Yu kolo tokomo.’ ningu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","⸤Makatalla ambo Maria Yesusi yu lipa ora sipale nirimumuni,⸥ pe ⸤yu lombili andoringimanga⸥ yombo talo ⸤kolea-awili Jerusalleme munduku kelko⸥ aulka senga puringilina Yesusi yu kumbikere kangi topele topa yu ‘kanangili.’ nimba omba mona gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe yu kanoko imbi sikuli kanu yombotolo kelko yando ongo ⸤lombili andoli⸥ wemando olone kanoringili mele ningu siringili-na-kolo olone ningu siringili mele kepe ‘Kolo tokombele.’ ningu pilieringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pe walte lombili andoli rureponga yopoko kere-langi nongo moloringina Yesusi omba mona molopale nirimumuni, ono iri topa nimbale: “Onone na ‘Lomboropa ola molomu.’ ningu kuru naa mondoko, na konde molondu mele yombo marene kanokole ono ningu síngi kinia ‘Kolo tokomele. Aku paa naa semu, manda naa sembá.’ ningu pilku kuru naa mondongi, akumu nambi semu-na aku siku karaye seko ningu pilku kuru naa mondongiye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","⸤Aku nimba⸥ yuni onondo nimbale: “Ono ma-koleamanga pali pungu yomboma pali semane peangamo toko siliku ando-payo. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ningí mele pilkuli ‘Akumu sika nikimili.’ ningu kuru mondokole no lingí yomboma ⸤kote-walemo wendo ombá kinia⸥ Pulu Yemone ono lipa tapondopa ‘Ono mindili nolemolá koleana naa pungu, molko kondoko mindi pangi.’ nimbá. Aku-na-kolo ⸤ono lombili andolimane⸥ ningí mele pilkuli ‘Akumu kolo tokomele.’ ningu pilkuli mokoli senge yomboma ⸤kote-walemo wendo ombá kinia⸥ Pulu Yemone ‘Ono mindili nongo mindi pungí koleana pangi.’ nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“‘Aku semanemo sika.’ ningu kuru mondonge yomboma ‘Na ono-kinia sika molio mele we-yombomane ningu kanangi.’ nimbú kinia ulu-tondoloma senge kinia yomboma kanonge mele i-sipa: Ono nanga tondolomone kuru mare yombomanga konopumanga molongema toko makoroko; umbu-ungu lupa lupa naa pilingíma ningu; ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yombo nongo kondoli kongi-ka-wambiyema naa kanoko kimuni ambolonge kinia akumane ono naa nongo kondonge; tomo pelemo no se naa pilku nonge kinia unguri paa naa sembá; kuru tomba yomboma kimuni ambolonge kinia peanga lemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ye-Awili Yesusini ⸤yu lombili andolima⸥ndo aku sipa nimba pora sirimu kinia ⸤Pulu Yemone⸥ yu mulu-koleana olando liltimu. Akuna ⸤imbi ola molopili Pulu Yemo-kinia mélema nokombando⸥ Pulu Yemonga ki-lomekondo pumba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesusi yu mulu-koleana olando purumu kinia yu lombili andolima koleamanga pali pungu Yesusinga semane peangamo yomboma toko siliku andoringi kinia ‘Onone nanga unguma yomboma ningu singí kinia kanu yombomane ‘Ungu sikamo.’ ningu pilku liengi.’ nimba Ye-Awilimu ono-kinia pumba lipa tapondorumu kinia yuni lipa mundorumu yomboma onone ‘Pulu Yemone mindi ulu-tondoloma manda selka mele sangi.’ nimba lipa tapondorumu. ⸤Aku pea.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ye paa awili Tiopillas, olio molemolo koleana Yesusi kinia ungu wendo orumuma pulu-pulu wendo orumu kinia kanoko, yandopa wendo orumuma kanoko andoko moloringi yombomane pe olio semane toko siringi mele, aku semanemo ‘Sika.’ nimbu kuru mondolemolo kanumu yombo awisilini ‘Aku semanemo bokuna kamu molopili tamili.’ ningu boku toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Akumunga pe kelepo nane kepe ‘ ‘Semanemonga pulumu paa pilipu kondambo.’ nimbu u-pulu-pulu wendo orumu mele kepe yandopa ungu lupa-lupama wendo orumu mele kepe akuma pali mangilipu pilipu kondopo molorundu-na nane ‘Aku ungumando yombo marene Tiopillas nundu semane toko ungu-mane silimili mele aku sipa wendo orumu uluma nu piliani.’ nimbu, ‘Nane nundu ungumanga pali paa sika wendo orumu mele semane topo nimbu siembo.’ nimbu, boku topo nu simbú kinia peanga.’ nimbu pilipuli aku semanemo topo i bokumu tokoro. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ye Nokoli Kingi Erote kolea Judia nokopa molorumu kinia Pulu Yemo popo tondorumu ye se molorumu, yunga imbi Sekaraya. Pulu Yemo popo tondoringi yombomanga talape senga imbi Apaya, Sekaraya yu kanu talapemonga ye se. Sekaraya menu ambo Ellisapete Pulu Yemo popo tondoringi yemanga talape senga ambo se. Olonga pea pulu-pulu anda-kolepamo Pulu Yemo popo tondoringi yemanga pulu-pulu ye nokoli awili Erono. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aku ambo yetolo moloringili mele Pulu Yemone kanopa ‘Yombo sumbi nilitolo.’ nimba kanorumu. Olone yunga ungu-manema kinia “Yomboma saa.” nirimu unguma pali pilku liku seko kondoko moloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Aku-sipa na-kolo Ellisapete we simbu perimu, bolango se naa meringili. Olo we ambu-anda leko moloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Walte Sekarayanga talapemone Pulu Yemo popo toko kaloringi kongono senderingi kinia yu kepe pea Pulu Yemonga kumbikerena kanu kongonomo senderingi. Aku sendeko molkole niringimuni, Pulu Yemo popo tondoringi yemane seringi mele sengendo ononga talapena ye se Pulu Yemo popo toko kaloringi ulka-tembele akumunga kisipina sukundu ‘Nawe pumba muna tolemo paura-kekumu yombomanga nimba kalondombanje piliamili.’ ningu kou-kate seringi. Aku sekole ‘Sekaraya yu kanu kongonomo sendemba.’ ningu kanoringi-kulu yu ulka-tembele kisipina sukundu pumba muna toli paura-kekumu kalondo-purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aku sepa gilierimu kinia ulka-tembelena we-yomboma maku toko Pulu Yemo popo toringi koleana yombo awisili Pulu Yemo kinia ungu ningu gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","⸤Sekaraya muna toli paura-kekumu kalondopa gilierimu kinia⸥ kanu paura-kekumu kalondo-pu-pu seringi polomonga ki-lomekondo Ye-Awilimunga angello se omba mona gilierimu kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Akumu kanopale pungu-pungu nimba pipili awili sepa kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kanu-kinia angellomone yundu nimbale: “Sekaraya, pipili naa kolou.” nirimu. “Nu Pulu Yemo kinia mawa seleno mele Pulu Yemo yuni pilierimu. Nunga ambomo kango se kanopa limba. Yunga imbi “Jono” ningu sieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yu molombamonga nu konopu awili seko siku kamelé akoko moloni. Yu mengele kinia yombo awisili konopu singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ye-Awilimuni yu kanopa ye awili peangamo nimba kanomba. No-waene kinia no-tondoloma kinia waltikele kepe paa naa nopili. Anumunga olona we sukundu molomba kinia Pulu Yemonga Mini Kake Sélimu omba yunga konopuna molopa manda sembá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isirele yombomane ononga Ye-Awili Pulu Yemo liku bulu siringi yombomanga awisili Jonone sembamonga kelko konopu topele toko Ye-Awili Pulu Yemo pea kelko pilku seluna sere leko konopu seluna pupili molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","⸤Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye⸥ Illainja tondolo pepili uluma sepa molorumu mele Jono yu aku sipa tondolo pepili uluma sepa molomba. Aku sipa tondolo pepili uluma sepa molombamonga lapalini konopu topele toko bolangoma kelko konopu mondongela; Pulu Yemonga ungu-manema pilku mokoli selemele yombomane konopu topele toko, konopu sumbi nili yombomane selemele mele ‘aku sipu samili.’ ningu molongela; Jono yuni sembamonga Ye-Awilimu ombá kinia Ye-Awilimu yunga ungumu sumbi siku pilku lingí yombo talape se molongela.” nimba angellomone Sekarayando nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aku nirimu kinia pilipale Sekarayane angellomondo mangilipa nimbale: “Aku nikinumu nambi sepo nane ‘Sika nikinu.’ nimbu pilimbuye?” nirimu. “Na anda lepo nanga ambomo ambu lierimu kanumu. Pe i nikinumu nambi sepa wendo ombámondo nikinuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angellomone pundu topa nimbale: “Nanga imbi Geperiele. Na Pulu Yemonga kumbikerena giliu. I kiniá nundu nikiru mele Pulu Yemone “Aku siku ni-pou.” nimba lipa mundomu-na nundu ombo i semane peangamo topo sikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aku-sipa na-kolo nane “Kango mengele.” nikirumu ‘Kolo tokomonje?’ ningu kuru naa mondokono kene i ungumu u wendo naa opili nu ungu naa nili moloni. Pe “Wendo ombá.” nikiru mele amboma bolango olona mondokole melemelemanga walema omba pulimú mele aku sipa walema omba pumbá kinia i nikiru ungumu paa sika wendo ombá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aku siku ungu ningu giliangili Sekaraya ulka-tembelemonga kisipina sukundu koronga-u pumba molopa, welea wendo naa orumu-kulu yomboma ulka-tembelemonga ultukundu yu nokoko gilieringima konopu awisili kimbu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kanu-kinia yu wendo ombale nirimumuni, ungu se kerena manda naa nimba kimuni mindi manda manjipa gilierimu kinia kanokole, ‘Sekaraya yu kisipina sukundu molopale melse omba gilieli none sepa kumbikere lipa pinjemu-na kanomu.’ konopu lieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pe ulka-tembelena yunga kongono walema pora nirimu kinia yunga ulkando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ulkando pumba ⸤ambo Ellisapete kinia peko moloringili kinia⸥ pe Ellisapete bolango olona mondorumu. Mondopale oli se-pakara ‘Yombomane yu naa kanangi.’ nimba lopi sepa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yuni nimbale: “Kiniá na-kinia ungu sekemomo Ye-Awilimuni nanga nimba sendekemo. Na bolango se naa merindumunga yomboma na kanoko kiri pilieringi kinia pipili kolorundumunga Ye-Awilimu yuni na kondo kolomu lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","⸤Ellisapete bolango olona mondopili oli se-pakara kolopa⸥ talo-pakara sipamo ke topa gilierimu kinia Pulu Yemone mulu-koleana angello Geperiele kolea Gallilli disiriki Nasarete taonona lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kanuna ambo-wenepo se, ye se kinia u naa peli we molorumu ambo-wenepomo molorumuna lipa mundorumu. Kanu ambo-wenepomo yunga pulu lierimu yombomane ‘Yu ye se pupili.’ ningu ala sinderingi yemonga imbi Josepo. Kanu yemo yunga anda-kolepa se ⸤ye nokoli kingi⸥ Depiti. Ambo-wenepomonga imbi Maria. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maria molorumuna angello Geperiele omba yundu nimbale: “Ambomo, nu molonuna na okoro. Pulu Yemone nu paa sepa peanga sikimumunga nu maloya. Ye-Awilimu nu-kinia pea kopu seko molembele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aku-sipa na-kolo kanu ungumu pilipale yu konopu awisili kimbu sipale, ‘A! I nikimumu nambolka unguri nimba nikimunje?’ nimba pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angellomone yundu nimbale: “Maria, Pulu Yemone nu kanopa peanga pilkimu kene pipili naa koloyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pílie. Nu pe olona kango se mondokole menimu. Mengole yunga imbimu “Yesusi” ningu sieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yu ye nokoli molomba, yu imbi leko ‘Paa Olandopa-Ye Molemomonga Malo.’ ningíla; Ye-Awili Pulu Yemone ‘Yunga anda-kolepa Depiti Isirele yombomanga ye nokoli kingi tondolomo molorumu mele yu aku sipa molopili.’ nimbála; ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ononga anda-kolepa Jekopone kalopa liltimu yomboma yuni supulka nokombala; Yu ye nokoli kingi awilimu molopa mindi pumbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariane angellomondo nimbale: “I nikinu ulumu nambi sepa sembamondo nikinuye? Na ye se naa purundu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angellomone yundu nimbale: “Nu molonina Paa Olandopa Yemonga Mini Kake Sélimu omba nunga olona kango se mondondomba. Aku sembamonga kango nuni menimu yu kango kake sélimu molomba; yu imbi lekole ‘Pulu Yemonga Malo’ ningíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","⸤Pulu Yemone nu “Sembó.” nikimu mele sika sembá. Ulu tondolo se “Sembó.” nimbale serimu mele niembo.⸥ Nunga pulu lemó ambo Ellisapetendo “Ambo simbu pelemo.” nilimili-na-kolo kiniá yu ambo-ambu liepili oli se-pakara kolopa talo-pakara sipamo ke topa giliepili yu kango se olona mondokomo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pulu Yemone ulu manda naa sembá ulu se paa naa pelemo. Yuni uluma pali manda selemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","⸤Angellomone yundu aku sipa nirimu kinia pilipale⸥ Mariane nimbale: “Na Ye-Awilimunga kongono kendemande ambomo molio. Nuni nikinu mele Pulu Yemo yuni na-kinia aku sipa sepili.” nirimu. Kanu-kinia angellomone Maria mundupa kelepa yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mulu-koleana angellomone Mariando ungu nimba pora sipale kelepa purumu kinia pe Maria kolea Judia disiriki pumba ma-pangi senga ola taono se lierimuna purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pumba akuna ye Sekarayanga ulkana sukundu pumbale ambo Ellisapete kanopa “Na okoro.” nirimu kinia kanguloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ellisapetene Marianga ungumu pilierimu kinia Ellisapete yunga olona bolangomo pukua topa ola mania serimu pilierimu. Kanu-kinia Pulu Yemonga Mini Kake Sélimu Ellisapetenga konopuna pumba molopa manda serimu kinia “I-siku i-siku ni.” nirimu mele ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ellisapetene ungu tondolo sepa nimba nimbale: “Ambo molemelemanga pali nu maloya. Ambomanga pali Pulu Yemone nu olandopa sepa peanga sirimu. Bolango nu olona mondolenomo kepe yuni sepa peanga simbala. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na ambo kiri se molonduna nanga Ye-Awilimunga anumu nu onumunga na konopu awisili kimbu sikiru. Aku senumunga na-kinia seko peanga sikinu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu ongole “Na okoro.” ninu-na komumuni piliendu kinia nanga olona molomu bolangomo paa konopu sipa pukua topa ola mania semu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ye-Awilimuni nundu nirimu ungumu pilkuli ‘Sika nikimu. Yuni “Sembó.” nikimu mele sika aku sembá.’ ningu kuru mondorunumunga yuni nu sepa peanga sikimu mele sepa peanga simba kene nu konopu siku molani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Ellisapetene nimba pora sirimu kinia Mariane nimbale: “Pulu Yemo nanga Lipa Tapondopa, Mindili Nombo Molopo Kinjiliu Aulkana Wendo Lipa, Manda Molopo Kondombo Aulkana Lipa Mondomba Yemo kinia na konopu paa awili sepo sikirumunga nanga konopumuni Ye-Awilimu kape nimba imbi ambolopa paka tondokomo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pulu Yemo yuni yunga we-ambo-kendemande kirimu siye naa kolopa konopu kimbu sirimumunga nanga konopumuni aku sipa yu kape nikimu. Yombomane pe pe kepe kalko lingí yombomane nando “Pulu Yemone nu sepa peanga sikimu. Nu maloya.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","⸤Ye⸥ Tondolo Pulimuni na ulu tondoloma senderimumunga nando aku siku ningí. ⸤Ye⸥ Tondolo Pulimu yu ye kake sélimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yu-kinia pipili kolko pilku limili yomboma yuni kondo kolopa molemo. Onone pe pe kepe kalko lingíma kepe kondo kolopa molopa mindi pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yuni yuyu ulu tondoloma serimu. Yombo kara pungu ononga konopuna onono kape ningu molemele yomboma yuni anju anju topa makoropa mundulimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yomboma yombo-kamako molko koleama nokoko molemelema yuni topa mania mundupa, yomboma ononga imbima ono onono topa mania mundumbama yuni ononga imbima ambolopa paka tondolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gelene kololemele yomboma yuni ‘Olo sepili.’ nimba kere-langi peangama sipa, yombo kamakoma méle seluri kepe naa sipa “We paa.” nimba makorolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yuni olionga pulu-pulu anda-kolepalimando “Sembó.” nimba, nimba panjerimu ungumu komu naa sipa pilipa molopale anda-kolepa Eporayamo kinia, Eporayamo yuni yandopa yandopa kalopa liltimu yomboma kinia, onondo “Sembó.” nimba, nimba panjerimu mele sembando olio Pulu Yemo yunga kendemande Isirele yombo molemolo akuma yuni kondo kolopa lipa tapondomba sepa molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Ellisapete kinia pea molangili oli yopoko omba purumu kinia pe Maria yu yunga ulka-koleando kelepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ellisapete bolango membá walemo wendo orumu kinia yuni kango se kanopa liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yunga ulka kere pongolo yomboma kinia yunga pulu lierimu yomboma kinia Ye-Awilimuni yu kondo awili sepa kolorumu mele pilkuli ono yu pea konopu siku moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wale yopoko-pakara kangomo kanopa lipa taltopa molorumu kinia wale engaki-sipamonga yomboma sukundu sukundu ongo maku tokole yunga kangi se kopisiku makaye seko wendo liku eltokole niringimuni, yunga imbimu yunga lapanga imbi manda manjiku “‘Sekaraya’ niemili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aku-na-kolo kangomonga anumuni “Mólo.” nimbale “Yunga imbi ‘Jono’ nimulú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Onone yundu ninguli: “Olonga pulu lemó yombo senga imbi aku sipa naa molemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kanu-kinia onone “Lapane nambolka konopu lekemone, yunga imbi lepa nawe nimbáne, mangilipu piliamili.” ningu lapando kimuni manda manjeringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","yuni pundu topa kimuni manda manjipa “Boku se siee.” nimbale, yuni bokuna topa nimbale: “Yunga imbi Jono.” nirimu. Akumu kanokole yombomane paa konopu awisili lieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kanu-kinia waltikele Sekaraya yunga kerena kelepa ungu nimbale Pulu Yemo kape nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aku serimu-na kanokole yunga ulka kere pongolo yombomane pipili paa koloringi. Kolea Judia disiriki ma-pangima polorumu koleamanga pali aku semanemo mindi tolko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aku ungumu pilieringi kinia yombomane pali konopu kimbu siku ninguli: “Ungu akumu we naa selemo. Ye-Awilimu i kangomo-kinia molombamonga aku sekemo lémo.” ningu pilkuli “I kangomo pe nambi sepa molombanje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mini Kake Sélimu Jono lapa Sekarayanga konopuna omba molopa manda serimu kinia Sekaraya yuni Pulu Yemone ungu-umbu tondorumu ungu se pilipa, pe wendo ombá mele yomboma nimba sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ye-Awilimu, Isirele yombomanga Pulu Yemo, yu kape nimbu imbi ambolopo paka tondamili. Yu omba yunga yomboma lipa tapondopa umbuna sene ono ambolorumu-na mindili nongo moloringi kanu umbunamonga wendo límu-na pilipuli yu kape nimbu imbi ambolopo paka tondamili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pulu Yemo yuni yunga kendemande-ye ⸤olionga ye nokoli kingi⸥ Depitini kalopa liltimu yombomanga ye tondolo peli se olio ‘Lipa tapondopa mindili nombo molopo kinjilimulu aulkana wendo lipa, manda molopo kondomolo aulkana lipa mondopili.’ nimba simu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Yuni ungu-umbu tondorumuma pilku yando ningu siringi yemane pe sembamondo koronga-u ninguli:) ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Yuni olio lipa tapondopa olionga opa-touma topa mundundupa, olio kanoko kiri pilku mindili silimili yomboma ‘Aku siku naa sangi. Wendo ongo manda molangi.’ nimba aku siku selemele aulkana wendo limba.” niringi mele kiniá aku sembá sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Olionga anda-kolepalima kondo kolopa, olionga pulu-pulu anda-kolepa Eporayamo-kinia “Sembó.” nimba, nimba panjipa mi lierimu mele “komu naa sipu, nirindu mele sambo.” nimbale aku sembá sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Pipili naa kolko, nanga kongonomo tondolo munduku sendeko, konopu kake sepili molko nane kanopo peanga pilkiru unguma mindi mana seko mololko pangi.’ nimbale olionga opa-toumane olio toko mindili silimilima ‘Naa sangi. Olio we molamili. Lipu tapondopo tokomele aulkana wendo limbu.’ nimba, nimba panjipa mi lierimu mele ‘Sambo.’ nimbale aku sekemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nanga kango ⸤Jono⸥, nu kumbi leko pungu Ye-Awilimu ombá aulkamo akisindenímunga pilkuli ningímuni, yombomane pe nundu ‘Olandopa Molemo ⸤Ye⸥monga ungu-umbu tondolima pilipa yando nimba sili yemo.’ ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","‘Ye-Awilimu yunga aulkamo akisindambo.’ ninguli nuni yunga yombomando i-siku ningu sini: “Ye-Awilimu yuni ononga ulu-pulu-kiri selemelema ‘Mania pupili.’ nimba siye kolopale ono lipa tapondopa mindili nolemolá aulkana wendo lipa, yu-kinia pea molko kondonge aulkana lipa mondomba.” ningu, aku ungumu onondo ningu sini. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Pulu Yemone olio kondo awili sepa kolopale olio simbulu tolina molopo kololi aulkana molomoloma konopu pe nipili molomolo aulkana ‘Manda kanoko pangi.’ nimba ‘Pa sendepili.’ nimba olio molemolona pa sendélimu lipa mundukumu.” nimba Sekarayane nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kango Jono yu akopa konopu tondolo pumba manda molorumu. Yu pe Isirele yombomanga kumbikerena kongono sepa molombando u kolea ku lielina pumba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","⸤Jono pamemo molopili⸥ Romo Gapomano Ye Paa Awili Kumbina ‘Sisa Okasitasi’ nílimuni ungu-mane se nimba panjipale “Romo gapomanomone nokolemo koleamanga molemele yomboma pali imbi liemili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kiriniasi kolea Siria poropinji nokorumu yemo molopili Romo gapomanomone yombomanga imbima pulu-pulu liltimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","⸤Ungu-mane akumu Okasitasini nimba panjerimu kinia⸥ yomboma pali ononga anda-kolepalimane kalko liltingi koleamanga yu-mele-mele ono puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ye Josepo kolea Gallilli disiriki Nasarete taonona molopa, ⸤Romo ye nokolimuni ‘Yomboma imbi liemili.’ nirimu⸥ pilipale nirimumuni, Nasarete mundupa kelepa, yu kalopa liltimu anda-kolepa Depiti u perimu kolea Judia disiriki pumba Betellieme taonona purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akuna “Oltonga imbitolo liengi pambili.” ningu yu nondopa limba ambo Maria kinia olo akuna puringili. Maria ulka pélimu pea puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Betellieme sukundu punguli, yombo ponenge ongo pe-pu-pu seringi ulkamo sengepea serimu-kulu ⸤olo kongi dongi kinia kaoma panjeringi ulkana pungu peringili. Akuna peringili kinia⸥ Maria bolango mini torumu. Pe kango se kanopa liltimu. Aku kangomo yunga komolayemo. Kanopa lipale mulu-wambale marene lipa kangomo okopa, kongimanga langi noringi okolo senga suku taltorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","⸤Betellieme⸥ ultukundu kongi sipisipi tapu-ye mare era kaliamanga ipulieli ononga sipisipima tapu seko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kanu-kinia ono moloringina Ye-Awilimunga angello se omba mona gilierimu kanoko, Ye-Awilimunga pa tondolo-sepa sélimu omba ono moloringi koleana pa serimu kanokole, ono mini-wale awili seko mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aku-na-kolo angellomone nimbale: “Nane ono semane peanga se topo simbú okoro kene pipili naa kolayo. I semanemo yomboma pali konopu singí semanemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kiniá ⸤u molorumu ye nokoli kingi⸥ Depitinga taonona ambo sene kango se memu. Yu Yomboma Lipa Tapondopa Mindili Nongo Molko Kinjilimili Aulkana Wendo Lipa, Manda Molko Kondonge Aulkana Lipa Mondomba Kangomo; yu Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu; yu Ye-Awilimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sika nikiru molo kolo tokoronje ono pungu kanangi mele nimbu siembo. Bolango kiki se mulu-maminiane okoko, kongimanga langi noringi okolo senga taltongemo pungu kanoko lendenge. Aku siku kanoko lendekole nane ‘Sika nimu lémo.’ ningu pilingí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aku nirimu kinia popenge seko mulu-koleana angello paa awisili u orumu angellomo gilierimuna ongo mona gilkuli niringimuni, Pulu Yemonga imbi ambolko paka tondoko yu kape ningu ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mulu-Koleana Paa Olandopa Pulu Yemonga imbi paa ola molopili. Mana-yombo yuni kanopa peanga pilielemo yomboma, konopu peanga pepili molangi.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aku ninguli ono kongi sipisipi tapu-yema munduku kelko mulu-koleana kelko olando puringi. Angelloma kelko mulu-koleana olando puringi kinia sipisipi tapu-yemane anju yando ninguli: “Olio Betellieme pumbu i ungu kiniá wendo okomo mele Ye-Awilimuni nimba simu ungu kanumu kano-pamolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aku ninguli popenge seko punguli niringimuni, Maria Josepotolo moloringili kanoko, bolango kikimu kongimanga langi noringi okolona suku lierimu kanoko lenderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yu kanokole, u angellomone ono aku bolangomondo nimba sirimu mele yomboma ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kanu-kinia sipisipi tapu-yemane ningu siringi mele pilkuli yombomane konopu awisili kimbu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aku-sipa na-kolo Maria i unguma kinia ulu wendo orumuma pali konopuna panjipale, pe kepe konopu kimbu sipa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisipi tapu-yema kelko yando ongole niringimuni, angellomone nimba sirimu mele pali pilku kanoringimunga Pulu Yemo kape niliku yunga imbi ambolko paka tondoleko yando oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kangomo kanoko liku taltoko molangi wale yopoko-pakara omba purumu kinia wale engaki-sipamonga yunga kangi se kopisiku makaye seko wendo likuli, anumuni yu olona naa mondopili angellomone nirimu mele pilkuli yunga imbi “Yesusi” ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Maria ⸤bolango merimumunga⸥ “Yu kalaro molemo.” niringimunga walema pora nimba, yu kamu kake sepili molomba walemo wendo orumu kinia, Mosisini ungu-mane sirimu se pilku liku sengelendo Josepo kinia olo kolea-awili Jerusalleme punguli niringilimuni, kake sepili molongelendo Pulu Yemo popo toko kalo-puringili. Ye-Awilimunga ungu-mane se u sirimu perimu akumu i-sipa: ⸤ ‘Ambo sene bolango kanopa lipale ambomo yu pena pemba mele molomba. Pena pemba walema pora nimbá kinia kake sepili molombando⸥ kera waembono mele talo molo kera imili mele talo Pulu Yemo popo topa kalopa sipili.’ nimba ungu-mane aku sipa nimba perimu kanumu pilkuli sengelendo puringili. Ye-Awilimunga ungu-mane nimba perimu se pea pilku liku sengelendo puringilila. Aku ungu-manemo i-sipa: ‘Kango komo kanoko lingíma pali “Ye-Awilimunga” ningu yu siengi.’ nimba perimu kanumu. Aku ungu-manemo nimba perimu-kulu pilkuli ‘Oltonga kango komomo Pulu Ye Awilimu siembili.’ ninguli Jerusalleme pungilíndu Yesusi mengo puringilila. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ye-anda se Jerusalleme molopili olo puringili, yunga imbi Simiono. Yu sumbi nirimu yemo; yu Pulu Yemonga ungumu pilipa alieli Pulu Yemo kinia ungu nirimu yemo; yu Isirele yomboma konopu seluna pupili molangi omba sendemba yemo kanombando nokopa molorumu; Mini Kake Sélimu yunga konopuna sukundu molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mini Kake Sélimuni yundu ungu se u nimbale: “Nu u we naa koloni. Nu u Ye-Awilimuni “Ono nokopa kondomba ye se lipu mundumbu.” nimba taltorumu ye nokoli Karasimu kanokole pe koloni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mini Kake Sélimuni Simiono yu lipa mundorumu-kulu yu Pulu Yemo popo toko kaloringi ulka-tembelena purumu. Kanu-kinia Yesusi anumu lapatolo ungu-manemone kangomando “Saa.” nimba sirimu mele sengelendo kango Yesusi mengo ulka-tembelena sukundu puringili kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simionone omba kangomo kangulupa lipa Pulu Yemonga imbi ambolopa paka tondopa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Ye Awili Tondolo Olandopamo, yomboma lipa tapondopa mindili nolemolá aulkana wendo lipa nu-kinia pea molko kondonge aulkana lipa mondomba ye sikinumu na kiniá nanga mongone kanokoro kinia u nando ningu panjerinu mele wendo okomo kene kiniá na nunga kendemande-yemo konopu pe nipili kolombo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","“‘Kanu lipa tapondopa wendo lili ulumu koleamanga pali yombomane kanangi.’ ningu sekeno. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yu Isirele yombomanga ultu molemele yombomanga pa sendepa, nunga Isirele yombomanga imbi ambolopa paka tondombando pa sendeli mélemo molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Anumu lapatolo Simionone kango Yesusindu nirimu mele pilkuli konopu awisili kimbu siringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simionone “Pulu Yemone ono sepa kondopili.” nimba Yesusi anumu Mariando nimbale: “Pílie. I kangomo molombamonga Isirele yombo awisili imbi u molorumuma pe mania pungíla; awisili imbi u naa molorumuma pe kiniá imbi molombala. Yu molomba kinia yombomane kanokole bulu siku ungu-taka tondonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ambomo, nu kepe ulu se wendo ombá. Nunga kameléna mindili awili-sepa sembá kinia yombo awisili konopu lenge mele mona lemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ambo se, yunga imbi Ana, yu Juda yombomanga talape kanga Asa, ye Panuelenga lemenu; yu paa ambo-ambu lierimu; yunga menu yemo pea molangili kalia-ingi yopoko-pakara omba purumu, pe yunga menu kolorumu kinia yu ambo-wayamo molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yu mana molopili yunga kalia-ingi paono kise kelepa yopoko omba pumba paono kise kelepa kise sipamonga yu we molorumu. Yu ulka-tembelemo mundupa naa kelepale alieli kanuna mindi molopa ipulieli kepe tangoli kepe Pulu Yemo popo topa imbi ambolopa paka tondombando alieli kere-langi naa nomba Pulu Yemo kinia ungu nimba mawa sepa mindi molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simionone Yesusindu ungu nimba molopili ono moloringina kanu ambomo yu ombale ⸤Pulu Yemone kanu kangomo Juda yomboma sirimumunga⸥ Pulu Yemo kinia “Ange, papu sekeno.” nirimu. Kanu-kinia pe Jerusalleme yomboma lipa tapondopa, umbuna sene ono ambolorumu-na mindili nongo moloringi kanu umbunamonga wendo limbando ombá yemo ‘Ombá.’ ningu nokoko moloringi yombomando Ana yuni kango akumu orumu mele kinia sembá mele kinia nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josepo Mariatolo olone Ye-Awilimunga ungu-manetolo nimba perimu mele pali pilku liku sekole niringilimuni, olo Yesusi kinia kelko kolea Gallilli disiriki pungu olonga kolea kanga Nasarete yando oringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kangomo akopa enge nimba molopa yunga konopuna pilipa kondoli awisili omba pepili molorumu, Pulu Yemone yu kanopa peanga pilipa yu sepa kondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Juda yombomane kalia-ingi senga senga kolea-awili Jerusalleme ongo akuna sukundu Pulu Yemone ononga anda-kolepalima Naa Topa Ola We Omba Purumu mele pilku ulu mare seringi kanu walema Yesusi anumu lapatolo kepe ‘Kanu walemo piliambili.’ ningu kalia-ingi senga senga Jerusalleme olando puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kango Yesusi molopili yu kalia-ingi engaki rurepo omba purumu kinia kanu walemo ‘Pulu Yemonga wale.’ ningu koro moloringi walemo kelepa wendo orumu kinia alieli Juda yomboma Jerusalleme puringi mele Yesusi anumu lapatolo kinia yu kinia pea olando puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","⸤Jerusalleme pungu⸥ kanu ulumu pilieringi walema pali pora nirimu kinia anumu lapatolo ulka-koleando pungilí puringili kinia kango Yesusi anju molorumu olo naa kanoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","‘Olionga yombo mare kinia okomo.’ konopu leko wale selumunga we punguli niringilimuni, pe ipupini kolea kalá torumu kinia pungu aulkana pengendo olonga pulu lierimu yomboma kinia we-yomboma kinia pea pungu moloringimando mangilku piliku andoko kororingili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yu naa kanoko lendekole Jerusalleme kelko pungu koro-puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wale talo koroko kelkole niringilimuni, pe wale yopoko-sipamonga ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena pungu kanoringili kinia yu akuna sukundu molorumu kanoko lenderingili. Yu ungu-manemanga puluma pilku mane siringi yema kinia pea moloringi, yuni ononga ungu niringima pilipale, anju onondo ungu mare mangilipa pilierimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yu onone niringima mimi sipa pilierimu mele kepe, pundu topa nimba kondorumu mele kepe, yombo moloringimane pilkuli onone ‘Yunga pilipa kondoli paa pepamo.’ ningu pilku konopu kimbu siku mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Olone yu kanu ulkana molorumu pungu kanokole pungu-pungu ningu anumuni yundu nimbale: “Kangomo, olto kinia pea pamili ou naa oli, nambi semu-na senuye? Lanie olto mini-wale mundulipu nu andopo koropo keliembulu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aku nirimu kinia yuni anumu lapatolondo nimbale: “Olo ⸤koleamanga pali⸥ nambi semu-na na andoko korongiliye? ‘Na ya Tatanga ulkana molemo.’ konopu naa liengiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aku-na-kolo yuni nirimu ungu-pulumu olone naa pilieringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yu olo kinia Nasarete taono maniando pumbale nirimumuni, olonga unguma pilipa sengena panjipa molorumu. Yunga anumuni kanu uluma konopuna panjipa pilipa mindi molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesusi yu akomba akorumu kinia yu pilipa kondoli olandopa olandopa pemba perimu; Pulu Yemo kinia yomboma kinia yu kanoko paa peanga pilku moloringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ye Tapiriasi-Sisa, Romo-gapomanomone nokorumu koleamanga pali, Isirele yombomanga kolea akumanga pali kepe, yu ye paa awili kumbinamo molorumu. Yu kanu koleamanga pali Romo ye paa awili kumbinamo molopili kalia-ingi tene-po omba pumba kalia-ingi tene-paip sipamo wendo orumu kinia yu aku sipa we molorumu. Kanu kalia-ingimunga Pondiasi Paillate kolea Judia disiriki yombomanga ye nokolimu molorumu; Erote kolea Gallilli disiriki yombomanga ye nokolimu molorumu; Erote genu Pillipu kolea Ituria disiriki kinia Terekonaitisi disirikitolo yombomanga ye nokolimu molorumu; LLaiseniasi kolea Apillini disiriki yombomanga ye nokolimu molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ono aku koleama nokoko molangi Anasi kinia Kayapasitolo Pulu Yemo popo tondoringi ye awili olandopatolo molangili Sekaraya malo Jono kolea ku lielina molorumu kinia Pulu Yemone Jono yu ungu-umbu tondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pulu Yemone ungu-umbu tondorumu kinia pilipale Jono yu pumba no Jodane nekendo yakondo andopa yomboma ungu-mane sipa nimbale: “Ono ulu-pulu-kiri selemelema kanoko kiri pilku konopu topele tokole ‘Pulu Yemone olionga ulu-pulu-kirima ‘We mania pupili.’ nimba siye kolopili.’ ningu ‘No liemili.’ ningu waa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","⸤Aku kongonomo Jonone serimu mele yu naa molopili koronga-u yuni yomboma Yesusinga unguma sumbi siku pilku lingí aulkamo lipa taltondomba mele⸥ Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane nimba boku torumu akuna molemo mele i-sipa: “Kolea ku lielina ⸤kumbi lepa pumbá⸥ ye senga kerena ungu se nimbale: “Ye-Awilimu ombá aulkamo seko wamame. Yu ombá aulka kangama toko sumbi siee.” nikimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Ma-pangima akuku kalambili siku, kolo lemomanga akuku pe toko, aulka akanale-makanale selemoma toko sumbi siku, aulka ola mania pulimúma kolta lenge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aku senge kinia Pulu Yemone olio lipa tapondopa ‘Mindili nolemolá aulkana wendo ongo yu-kinia pea molko kondonge aulkana pangi.’ nimba lipa mundumba yemo yombomane pali kanonge.” nikimu.” nimba ⸤Jonone pe sembá mele Aisayane u aku sipa nimba sipa bokuna torumu molemo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yombo awisili Jono molorumuna ‘Yuni olio no lindepili.’ ningu onge oringi kinia yuni kanopale nirimumuni, ono iri topa nimbale: “Kolo topa yomboma sepa kinjeli wambiyemonga waloma, Pulu Yemo mumindili kolomba walemonga nawene “Ono kowa paa.” nimu kinia ono ‘Pulu Yemone naa sepa kinjepili.’ ningu ‘No liemili.’ ningu okomeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ono sumbi siku molko, ulu peangama mindi seko molonge kinia ono ulu-pulu-kiri seringima paa sika munduku kelko konopu topele tonge mele mona lemba. “Olio anda-kolepa Eporayamone kalopa liltimu yomboma molemolomonga yombo peangama molemolo.” ningu aku siku ningu naa piliame. Nane ono nimbu sikiru: ‘Pulu Yemone i kou-mulumando “Eporayamone kalopa liltimu yomboma au leangi.” nilkanje kou-muluma Eporayamone kalopa liltimu yomboma molemolá.’ nikiru. Ono Eporayamone kalopa liltimu yomboma molemelemonga unguri naa selemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Unju peke tomba lumu Pulu Yemone koronga unju puluna ambolopa ola lipa molemo. Unju mongo peanga naa tomba unjuma yuni peke topale sepena kalomba.” nimba Jonone aku nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","⸤Yombo Pulu Yemo kanopa peanga pilielemo ulu-puluma naa selemelema Pulu Yemo yuni “Mindili nangi.” nimbá mele Jonone nimba sirimu kinia pilkuli⸥ ongo maku toringi yombomane ninguli: “Aku liemu ⸤ ‘Yuni olio “Mindili nangi.” naa nipili.’ nimbu⸥ nambi semoloye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yuni onondo pundu topa nimbale: “Wale-pakoli talo taltolemele yomboma onone yombo wale-pakoli se naa taltongema moke seko siengi. Kere-langima kepe aku siku sangila.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kou-takisi lili yema kepe ‘No liemili.’ ningu oringi. Yuni ungu nirimumu pilkuli yundu mangilku pilku ninguli: “Ungu Mane Sili Yemo, olio nambi semolo kinia Pulu Yemo yuni olio kanopa peanga pilimbaye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yuni onondo nimbale: “Ono kou-takisi likuli gapomano yuni “Kou i-siku liee.” nimba, nimba taltopa simba mele liengi. Onone kolo toko mare ola panjiku limili aku mele naa liengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kanu-kinia ami-ye mare yu mangilku pilkuli, “Olio kepe nambi samiliye?” niringi. Yuni pundu topa nimbale: “Onone yombomanga kou-mone wa lingíndu kolo toko kopene we naa tangi. Gapomanomone méle kalomba koumu mindi liku taltoko, taka leko molangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jonone serimu mele kanokole yombomane yu-kinia konopu awisili kimbu siku, ‘Pulu Yemone olionga anda-kolepalimando “Ono nokopa kondomba ye se lipu mundumbu.” nirimu ye nokoli Karasimu i yemonje?’ ningu pilku moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ningu pilieringi mele pilipale Jonone pundu topa onondo nimbale: “Nane yomboma no mindi lindiliu. Aku-na-kolo ye se ombámo yuni ⸤Pulu Yemonga⸥ Mini Kake Sélimu kinia sepemo kinia ono lindimba ⸤lingí⸥. I ombá yemo yunga tondolomo paa olandopa, nanga tondolomo paa maniandopa. Na yu-kinia manda mólo. ⸤Yombo awilimanga kongono kiri seli kendemande-yombomane sika ononga awilimanga kongono kiri sendengendo kimbu su wendo lindilimili-na-kolo⸥ ombá yemonga kimbu su wendo lindimbu kanu kongonomo paa olandopa mele nane sendembo manda naa selka, na ye paa kiri. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yuni yunga rasi-witi apuroli apulu-pokomo ambolopale yunga rasi-witi mongo kinia rasi-witi kilu kinia apurumbando molemo. Yunga rasi-witi apuroli polomo sepa wamombando rasi-witi pali ‘wendo liembo.’ nimba apurupale mongoma lipa rasi-witi taltolemo mingina ‘Liepili.’ nimba taltombando mingi topa, pe kiluma lipa maku topa sepe naa kumbulupa nomba pepa mindi pulimúna kalomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","‘Yombomane “Olio yombo molopo kinjilimulu yomboma. Olio ulu-pulu-kirima mundupu kelepo konopu topele tamili.” niengi.’ nimba Jonone yomboma ungu-mane awisili aku-sipa sipa, semane peangamo topa sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Walte, pe mele, Jonone kolea Gallilli disiriki yombomanga ye nokoli kingi Erote iri torumula. Yu genunga ambo menu Erodiasi ⸤mangopa liltimu⸥ ulumu kinia ulu-pulu-kiri lupa awisili serimuma kinia nimba para sipa yu iri torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jonone yu iri torumumunga Erotene mumindili kolopale yu ka sipa ka-ulkana panjerimu. Yuni aku serimumu sepa kinjerimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","⸤Erotene Jono u ka naa sipili⸥ yombo awisili Jono no lindipa molorumuna ongo no liltingi kinia Yesusi kepe omba no liltimula. No lipale Pulu Yemo kinia ungu nimba gilierimu kinia mulúmu kengeya lepa anju yando purumu, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pulu Yemonga Minimu, kera waembono mele, mania omba Yesusi molorumuna pumba kangina ola molorumu. Mulúna ungu se wendo omba nimbale: “Nu nanga konopu mondolio kangomo. Nu-kinia konopu sipu molio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesusi yu mana molopili kalia wane paono tene mele omba purumu kinia yunga kongonomo pulu polopa serimu. Yombomane Yesusindu ‘Josepo malo.’ ningu pilieringi. Josepo yunga lapa Illai. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Illai lapa Matate. Matate lapa LLipai. LLipai lapa Melkai. Melkai lapa Janai. Janai lapa Josepo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josepo lapa Matatayasi. Matatayasi lapa Emosi. Emosi lapa Neame. Neame lapa Esillai. Esillai lapa Nakai. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai lapa Meate. Meate lapa Matatayasi. Matatayasi lapa Semene. Semene lapa Joseke. Joseke lapa Joda. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda lapa Joanane. Joanane lapa Resa. Resa lapa Serapapele. Serapapele lapa Sialtele. Sialteple lapa Nerai. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai lapa Melkai. Melkai lapa Edai. Edai lapa Kosame. Kosame lapa Ellemadame. Ellemadame lapa Ere. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere lapa Josua. Josua lapa Elliesa. Elliesa lapa Jorimu. Jorimu lapa Matate. Matate lapa LLipai. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","LLipai lapa Simiono. Simiono lapa Juda. Juda lapa Josepo. Josepo lapa Jonamo. Jonamo lapa Ellayakimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ellayakimu lapa Mellia. Mellia lapa Mana. Mana lapa Matata. Matata lapa Netane. Netane lapa ⸤Ye Nokoli Kingi⸥ Depiti. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depiti lapa Jesi. Jesi lapa Opete. Opete lapa Boasi. Boasi lapa Sallimono. Sallimono lapa Nasono. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasono lapa Aminadape. Aminadape lapa Ramo. Ramo lapa Esirono. Esirono lapa Péresi. Péresi lapa Juda. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda lapa Jekopo. Jekopo lapa Aisake. Aisake lapa Eporayamo. Eporayamo lapa Tira. Tira lapa Neyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyo lapa Serake. Serake lapa Reu. Reu lapa Pelleke. Pelleke lapa Epe. Epe lapa Silla. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silla lapa Kenane. Kenane lapa Apakisate. Apakisate lapa Seme. Seme lapa Noa. Noa lapa LLameke. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","LLameke lapa Metusalla. Metusalla lapa Inoko. Inoko lapa Jarete. Jarete lapa Mallallele. Mallallele lapa Kenane. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane lapa Inosi. Inosi lapa Sete. Sete lapa Atame. Atame lapa Pulu Yemo. Atame Pulu Yemonga malo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesusi ⸤no liltimu kinia⸥ Mini Kake Sélimu yu-kinia omba molopa yunga konopuna molopa paa sengepea sepili no Jodane mundupa kelepale nirimumuni, Mini Kake Sélimuni yu kolea ku lielina memba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Akuna Yesusi ⸤Mini Kake Sélimu kinia molopili⸥ ⸤kurumanga nokoli⸥ depelemo omba yu kondi topa molopili oli se koro talo omba purumu. Kanu walemanga kere-langi naa noli we molopa perimu kinia yu gelene kolopa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kanu-kinia ⸤kurumanga nokoli⸥ depelemone yu ⸤kondi topa⸥ nimbale: “Nu Pulu Yemonga Malo liemu i kouma ‘Pellawa kaloli au liepili.’ ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aku-sipa na-kolo yuni pundu topa nimbale: “Pulu Yemonga bokumuni nimbale: “Kere-langimane mindi yomboma konde mololi ulu-pulumu naa silimú.” nimba molemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kanu-kinia depelemone Yesusi yu lipa memba pumba ⸤ma-pangi⸥ paa olana senga anjipale nirimumuni, yu ma-koleama pali waltikele lipa ora sipa, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","yundu nimbale: “I koleamanga pali tondolomo kinia méle peangama kinia Pulu Yemone nando “Nokou.” nimba koronga sirimu. Ima nane ‘Yombo se simbú.’ nindu liemu manda simbú. Nu na popo toko nanga imbi ambolko paka tondonu liemu i tondolomo kinia méle peangama pali nu lieni simbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kanu-kinia Yesusini depelemondo nimbale: “Pulu Yemonga bokumuni nimbale: “Pulu Yemo ononga Ye-Awilimu manjiku popo toko imbi ambolko paka tondoko, yunga kongonomo manjiku sendeko molangi.” nimba molemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Kanu-kinia depelemo yuni Yesusi lipa kolea-awili Jerusalleme memba pumba, ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelemonga memba, paa ola imuna memba pumba anjipale nirimumuni, yundu nimbale: “Nu Pulu Yemonga Malo liemu nu lipa tapondomba kene po ningu mania pu.” ⸤nirimu.⸥ “Pulu Yemonga bokumuni nimbale: ‘Pulu Yemone yunga mulu-koleana angellomane ‘Nu ongo nokangi.’ nimbá. Onone nu ‘Kou sene kepe naa topili.’ ningu nu ononga kimane okoko lingí.’ nimba molemo kanumu. Aku sipa nirimu kene pilkuli aku siku sei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesusini yundu pundu topa nimbale: “Pulu Yemonga yombomando ungu se pea nimba molemóla. Akumu i-sipa: ‘Pulu Yemo ononga Ye-Awilimuni “Sembó.” nilimú mele ‘Sika nilimúnje molo kolo tolemonje kanamili.’ ningu onone yu manda manjiku naa sangi.’ nimba molemóla kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Depelemone Yesusi kondi topa pora sipale nirimumuni, ‘Pe yu manda kelepo kondi tombo wale se nondopo pilipuli kelepo ombó.’ nimba yu mundupa kelepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kanu-kinia Minimunga tondolomone Yesusi kelepa kolea Gallilli disirikindu yando memba orumu kinia akuna andopa serimu mele semanemo koleamanga pali anju anju purumu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yuni Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkamanga pumba ungu-mane sirimu kinia yombomane pali yu kape niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesusi kolea Gallilli disiriki yomboma ungu-mane silipa andopale nirimumuni, yu Gallilli lierimu kolea Nasarete taono u molopa akorumuna kelepa orumu. Ombale ⸤Juda yombomanga koro moloringi⸥ wale Sambatemonga koleamanga pali ono maku toko Pulu Yemonga ungumu pilieringi ulkamanga yu alieli purumu mele Nasarete ungu pilieringi ulka akuna aku sipa purumu. ⸤Maku toko moloringi kinia⸥ yuni “Na bokumu kanopo niembo.” nimba ola gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","⸤Pulu Yemonga bokuma nokorumu yemone⸥ Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane koronga-u torumu bokumu lipa sirimu kinia, Yesusini lipa sukundu ungu molorumu se kanopa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“⸤Aisayane i-sipa nimbale:⸥ “Ye-Awilimunga Minimu na-kinia molemomo yuni nando nimbale: “Yombo koropama semane peangamo toko siku, ka-ulkana pelemele yombomando ‘Wendo ongo we molangi.’ ningu, mongo kiri lieli yombomando ‘Mongo peanga liepili kanangi.’ ningu, mindili nongo molemele yomboma ‘Mindili naa nongo, molko kondangi.’ ningu, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Kiniá kalia-ingina Ye-Awilimuni yomboma kanopa kondo kolomba kalia-ingimu wendo okomo.’ ningu siliku andou.” nimba Minimuni aku sipa ye se nimba taltopale nirimu.” nimba Aisayane nirimu.” nimba Yesusini aku sipa boku kambu topa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ungu akumu kanopa nimba pora sipale bokumu kelepa pipi sipa bokuma nokorumu yemo sipa, ⸤ “Ungu se niembo.” nimba⸥ Yesusi yu mania molorumu. Yomboma pali yu mindi neme-neme ningu kanoko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kanu-kinia yuni onondo nimbale: “Kiniá Pulu Yemonga bokuna ungumu kanopo nindu piliengi akuna Aisayane “Wendo ombá.” nimba, u nirimu mele kiniá wendo okomo. ⸤Kiniá na sembó okoro ulu akumanga u nirimu.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Moloringi yombomane “Yu ye peangamo. Yu paa selemo.” ningu yu nirimu mele pilkuli “Paa nimba peanga sikimu.” ninguli mini-wale mundoringi. ⸤Aku-sipa na-kolo⸥ onone ninguli: “I yemo ⸤yu nawe konopu lekemoye?⸥ Yu Josepo malo mindi, ⸤olionga we-ye se mindi lémo⸥.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","⸤Aku-na-kolo⸥ Yesusini ⸤yuyu molorumu mele nirimu kinia pilkuli yu konopu kiri panjeringi mele pilipale⸥ onondo nimbale: “Ungu-iku tolemelemanga se nando toko ningí seko molemelenje konopu lekero. Onone nando i-siku ningí sekemelenje: “Nu sika doketa moleno liemu nu kuru tomba kinia nunga marasenemo nunu liku nani. Pe nu peanga lemba ⸤kinia kanopole ‘Nu sika doketa moleno lémo.’ nimbu pilimulú.” ningu aku ungu-ikumu na toko singí sekemelenje?⸥ Nando ninguli: “Nuni Kapeniame taono ulu-tondoloma serinu pilierimulu mele ya nunga pulu-kolea ⸤Nasarete⸥ akuna aku siku sani. ⸤Kanopole nu “molio.” nikinu mele ‘Sika nikinu lémo.’ nimbu pilimulú.⸥” ningí sekemelenje? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nane onondo sika nimbu sikirumu: “Yombomane ulu-pulu se selemele mele i-sipa: Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye sene yunga pulu koleamonga yomboma ungu nimba silimú kinia pilkuli nilimilimuni, onone ‘Yu olionga we-yere. Yu imbi mololi ye se mólo.’ ningu yuni nilimú unguma naa pilku mokoli selemele. ⸤Kolea lupa yombo marene ongo ungu ningu silimili kinia aku unguma mindi pilku limili. Yombomane aku siku selemele mele onone aku sikula selemele.⸥” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","‘Nane paa sika nimbu sikiru mele ono piliangi.’ nimbu ⸤semane talo tambo.⸥ “Illainja Pulu Yemone ungu-umbu tondorumuma pilipa ⸤yunga pulu lierimu⸥ Isirele yomboma nimba sipa molopili ulu se wendo orumumu niembo. Pulu Yemone “Lo naa opili.” nirimu kinia kalia-ingi yopoko kelepa oli kise se-pakara lo naa omba paa gele lierimu kinia Isirele koleana sukundu ambo-waya awisili ⸤gelene kolko⸥ moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Aku-sipa na-kolo Pulu Yemone “Isirele ambo-waya se liku tapondoko kere-langi sieni.” nimba Illainja akuna naa lipa mundorumu. ⸤Isirele ultukundu lierimu⸥ kolea-awili Saidono nondopa lierimu kolea-kanga Sarepate ambo-waya se ⸤ ‘Kere-langi pora naa nipili.’ nimba Pulu Yemone kanu ultukundu ambomo⸥ molorumuna Illainja lipa mundorumu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Illaisa kepe u Pulu Yemone ungu-umbu tondorumuma pilipa ⸤yunga pulu lierimu Isirele yomboma⸥ nimba sipa molopili Isirele koleana sukundu yombo awisili kuru laká norumu, aku-na-kolo ono pali selu kepe peanga naa lierimu, kuru laká nomba we perimu. ⸤Kolea Isirele ultukundu lierimu⸥ kolea Siria ye Neman mindi kuru laká norumu kinia Illaisane yu ⸤lipa tapondopa⸥ sepa peanga sirimu. ⸤Pulu Yemone Illainja kinia Illaisatolo lipa mundorumu-kulu ultukundu yombo talo aku siku liku tapondoringili nikiru mele paa sika nikiru piliaa.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aku sipa mele nirimu kinia pilku kiri pilkuli Pulu Yemonga ungumu pilieringi ulkana sukundu moloringi yomboma pali paa lakoko mumindili koloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mumindili kolkole ola gilku yu kanu koleana ultu toko pulu siku munduku, kanu koleana nondopa kopó se lierimuna toko mania mundungí seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aku-sipa na-kolo yu ono maku toko gilieringina sumbi sipa pumba senga lupa pumbá purumu, yu manda naa amboloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kanu-kinia Yesusi yu kolea Gallilli disiriki lierimu taono se Kapeniame akuna maniando purumu. Akuna ⸤koro moloringi⸥ wale Sambatemo wendo orumu kinia Yesusi ⸤Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka kanuna sukundu pumba⸥ ono ungu-mane sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mane sirimu kinia yu namba lierimu yemane pipili naa kolko tondolo munduku mane siringi mele yuni aku sipa mane sirimu-kulu pilkuli yombomane mini-wale mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kanu-kinia ulka kanuna sukundu ye se molorumu kanumu kuru se yunga konopuna sukundu molopa yu ambolorumu ⸤kanu kurumuni yu “Ungu ni.” nimba ulku torumu-na⸥ yemone ungu tondolo mundupa nimba nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Kolea Nasarete ye Yesusi, nu pea olio ⸤kuruma⸥-kinia seluna kopu sepo manda naa molomolo. Nu olio-kinia nambi semu-na onuye? Nu olio toko kondoni onuye? Nane nunga imbi pilielio. Nu Pulu Yemonga Ye Kake Sélimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","⸤Aku sipa nirimu-kulu pilipale⸥ Yesusini kanu kurumu iri topa yundu nimbale: “Nu ungu naa ningu yemonga konopuna ongo wendo pu!” nirimu kinia kurumuni yemo topa mania mundupale omba wendo purumu. Yemo yu unguri naa serimu, we manda molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","⸤Yesusini aku serimu kanokole⸥ yomboma pungu-pungu ningu, mini-wale munduku, onone onono anju yando ninguli: “I ulumu nambolka uluri sekemonje? Ungu-mane konde se wendo ombámo. Ye namba lieli sene we-yombomando “Saa.” nilimú mele i yemone kurumando kepe aku sipa nilimú kinia kanu kuruma yunga ungumu pilku liku wendo pulimili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kanu-kinia yuni aku sipa serimu mele semanemo kanu koleamonga sukundu lierimu koleamanga pali anju anju purumu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kanu-kinia kanu maku toko Pulu Yemonga ungumu pilieringi ulkamo Yesusi mundupa kelepa pumbale nirimumuni, Yesusi Saimono ⸤Pita⸥nga ulkana sukundu purumu. Akuna Saimononga kolepa-ambomo kuru topa kangi nomba kondopili lierimu-na Yesusindu “Liku tapondou.” ningu mawa seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aku siku yu mawa seringi kinia ambomo lierimuna pumba gilipa nimbale: “Kangi manda nou.” nirimu kinia kangi nomba kelierimu. Ambomone sumbi sipa ola gilipa wendo ombale, oringi yema kere-langi sipa nokopa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kanu walemonga ipupini, ena pumbá purumu kinia, kuru lupa-lupa torumu yomboma Yesusi molorumuna mengo oringi kinia kanu yomboma ono yu-mele-mele kini ambolopale ono pali sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","⸤Konopumanga kuru molorumu⸥ yombo awisili ⸤oringi.⸥ Kanu kuruma⸤ndo “Ongo wendo paa.” nirimu kinia⸥ ongo wendo pungu ru ningu ninguli: “Nu Pulu Yemonga Malo moleno.” niringi. Kurumane yu aku siku imbi sikuli yu ⸤Pulu Yemone nimba taltopa lipa mundorumu ye nokoli⸥ Karasimu!’ molorumu mele pilieringi-kulu yuni ono iri topa “Molio mele anju ningu naa siee.” nimba ononga kerema pipi sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Orili-u Yesusi ola molopa penando pumba kolea ku lieli senga purumu kinia yombo awisili yu koroko yu molorumuna ongo yundu ninguli: “Olio-kinia pea kamu molamili. Senga naa pu.” ningu mawa seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yuni onondo pundu topa nimbale: “⸤Pea molamili mangali⸥ kolea wemanga pea pumbu, Pulu Yemo omba ye nokoli kingimu molomba semane peangamo topo silipu andombo. Akumunga na yando lipa mundorumu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aku nimbale yu pumba kolea Gallilli ⸤disiriki⸥ sukundu andopa, kolea lupa lupamanga pumba Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkamanga pumba kanu semane peangamo topa silipa andorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Walte, Yesusi Geneserete Nomu, ⸤akumundu ‘Gallilli Nomu’ niringila kanumu,⸥ aku nomu kelona gilipa yomboma Pulu Yemonga ungumu nimba sirimu kinia pilingindu ono yu gilierimuna pungu maku toko nondoko nondoko pungu ekelepa seko molko pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kanu-kinia yuni nona andoli sipi talo nomu kelona lierimutolo kanopale, oma lili yema koronga nomu kelona wendo pungu ononga oma lili walema kulumiye toko moloringi kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sipi se Saimono Pitanga, akuna sukundu pumbale yuni yundu mawa sepa nimbale: “Sipimu kanga-kolte paka toko nona sukundu mundou.” nirimu. Paka topa nona sukundu mundorumu kinia aku sipimunga suku yu mania molopale nirimumuni, no kelona liku maku toko moloringi yomboma ungu-mane sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ono ungu-mane sipa pora sipale yuni Saimonondo nimbale: “Sipimu nomu awi-suku-singina kunduku mengo pungu oma lili walema nona mania mundou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimonone pundu topa nimbale: “Ye Nokolimu, kiniá ipulieli pali oma lili kongono tondolo mundupu sepo molopo tangondopole oma se paa naa límulu. Aku-na-kolo aku nikinu kene walemo nona mania mundambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kanu-kinia walema nona mania mundoringi kinia oma awisili walemanga sukundu puringi-kulu walema sipina sukundu lingí seringi kinia sungu nimbá serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Walema sungu nimbá serimu kanokole onone ononga oma lili kongono pea kopu seko seringi yema, sipi senga moloringima mangilkuli “Ongo liku tapondangi waa.” niringi. Oringi kinia sipi talo pea peke siringi umbuna sepa nona mania pumbá serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aku ulumu kanopale Saimono Pita Yesusinga kumbikerena omba mania molopa tamalu pepa nimbale: “Ye-Awilimu, na ulu-pulu-kiri ambololi yemo ⸤nu kake seli yemo⸥. ⸤Seluna molkombolo manda naa sekemo⸥ kene anju pungu nu lupa molou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimono kinia, yu-kinia pea moloringima kinia, onone oma awisili waltikele tangoli liltingi kanokole ono pungu-pungu ningu mini-wale mundoringi-kulu ⸤Saimono yuni aku sipa nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Seperinga malo Jemisi kinia Jonotolo olo Saimono Pita kinia kongono seluna kopu seko seringili yetolo, olo pea mini-wale mundoringilila. Kanu-kinia Saimonone nirimumu pilipale Yesusini yundu nimbale: “Nu pipili naa koloyo. Kiniá oma linindu oma lili wale liku nona mania mundulinu kinia omama walena omba pelemo mele, pe nanga kongonomo sendenindu nanga ungumu pilku ningu siliku andoni kinia yomboma nanga talapena sukundu ongo molonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kanu-kinia ononga sipitolo nomu kelona mengo ultu ongole, sipitolo mélema pali liepili munduku kelko Yesusi lombili puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","⸤Kolea Gallilli disiriki sukundu lierimu⸥ koleamanga senga Yesusi molorumu kinia ye se kuru-laká awili sepa nomba perimumu omba Yesusi kanopale mania molopa tamalu pepa yu mawa sepa nimbale: “Ye-Awilimu, nunga konopumuni na ‘Peanga liepili.’ konopu lienu liemu nuni na manda seko peanga sini.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusini yemo kimuni ambolopa yundu nimbale: “‘Nu peanga liepili molani.’ konopu lekero kene peanga liepili.” nirimu kinia popenge sepa kuru-lakámo nomba kelepa kangimu peanga lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kanu-kinia Yesusini yu ungu se tondolo mundupa nimbale: “Nuni ya ulu sekeromo yombo selurindu kepe paa naa ni! Sumbi siku pungu Pulu Yemo popo tondoli yemo nunga kangimu liku ora siku, ‘Na kelepo kangi peanga liepili molkoro kene.’ ningu Mosisini “Sei.” nimba ungu-mane sirimumu pilku liku senindu “Pulu Yemo popo toko kalko si.” nirimu mélemo liku Pulu Yemo popo tondoli yemondo “Kalondou.” ningu yu sieni. Pe yombomane nu kanokole ‘Yu sika kangi peanga liepili molemo.’ ningu piliangi kene nikiru mele iseli-u se-pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aku-na-kolo yuni serimu mele anju anju yombo awisilini pilkuli niringimuni, yu molorumuna sukundu-sukundu ongo yu semane peanga topa nirimumu pilingindu ongo, kuru torumu yomboma yuni ‘Ono sepa peanga sipili.’ ningu oringi kanopale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","yu ono oringina mundupa kelepa kolea ku lieli senga pumba Pulu Yemo kinia ungu nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Walte Yesusi yuni yomboma ungu-mane sipa molorumu. Kuru toli yomboma sepa peanga sili tondolomo yu-kinia pepili molorumu. Pulu Yemone kanu tondolomo yu sirimu. Parisi yema kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, yu ungu-mane sirimuma pilku moloringila. Kanu yema, kolea Gallilli disiriki sukundu lierimu koleamanga moloringima kinia, kolea Judia disiriki sukundu lierimu koleamanga moloringima kinia, kolea-awili Jerusalleme moloringima kinia, Yesusi molorumuna ongo maku toko yu ungu-mane sirimuma pilku moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Yu molorumuna ye marene kimbu-ki kolopa pora sirimu ye se taropola seko mengo onge oringi-na-kolo yombo awisili ulka kerepuluna ekelepa seko gilieringi-kulu ulkana sukundu Yesusi molorumuna nondoko mengo pungí aulka se naa kanokole niringimuni, ulka imuna mengo ola punguli Yesusi molorumuna ⸤kana-kana ulkamo sikisikuli⸥ yemo taropola pali moko toko mania mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","‘Yesusini i yemo manda sepa peanga simba.’ ningu kuru mondokole yu mengo oringi kanopa pilipale Yesusini kanu yemondo nimbale: “Kangomo, nunga konopuna ulu-pulu-kiri serinu pelemoma mania pupili, we siye kolkoro.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisi yema kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Yesusini aku nirimu pilkuli ⸤pilku kiri pilku⸥ konopu kimbú sikuli, “I ye Pulu Yemo marake sekemo yemo nawe? Yombomane ulu-pulu-kiri selemelema nawene ‘Mania pupili, we siye kolkoro.’ manda nimbáye? Pulu Yemone mindi manda selemo.” ningu onono ningu pilku molko konopu kimbu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kanu-kinia Yesusini ono aku siku konopu kimbú siku moloringi mele pilipale onondo nimbale: “Onone ⸤nane nikirumunga⸥ aku siku nambi semu-na konopu kimbú sikimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","I yemondo “Nunga ulu-pulu-kirima mania pupili, we siye kolkoro.” nimbú kinia ono ulu se naa kanokole ‘Pe nilse nikimu.’ konopu lengeye? Molo “Ola gilku nunga kunungumu liku mengo kimbu-kongono seko andou.” nimbú kinia yu ola gilimbane naa gilimbanje mona lemba manda kanokole ‘Aku sipa kála sepa nikimunje?’ konopu lengeye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aku-sipa na-kolo ‘ ‘Mania Omba Mana-Ye Au Lierimu Yemo tondolo pelemomone ya ma-koleana yombomanga ulu-pulu-kirima “Mania pupili, siye kolkoro.” manda nimbá.’ ningu piliangi.’ nimbu ⸤aku sipu nindu⸥.” nirimu. Aku nimbale kimbu ki kolopa pora sili yemondo nimbale: “Nane ‘Nu ola gilku nunga kunungumu liku mengo ulkando pu.’ nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aku nirimu kinia ono kanoko molangi yemo sumbi sipa ola gilipa yunga kunungumu lipa memba omba pena pumbale Pulu Yemo kape nilipa ulkando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","⸤Yu aku serimu kanokole⸥ ono pungu-pungu ningu mini-wale munduku Pulu Yemo paa pipili kolko yunga imbi ambolko paka tondoko yu kape ningu ninguli: “Olio i ulu wendo okomo kanokomolomo ulu paa se lupa lepomo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kanu-kinia Yesusi ⸤ulkamo mundupa kelepa⸥ pena pumbale nirimumuni, kou-takisi liltimu ye se, yunga imbi LLipai, kou-takisi lipa molorumu kanopale yundu “Na-kinia pea pambili lombili ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kanu-kinia LLipai yu ola gilipa kou-takisi mélema we liepili mundupa kelepa yu lombili purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pe LLipaini yunga ulkana Yesusinga kere-langi awisili kalondorumu. Akuna kou-takisi lili ye awisili kinia, we-ye mare kinia, ono Yesusi LLipaitolo kinia pea mania molko kanu kere-langima noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aku seringi kanokole Parisi yema kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, onone Yesusi yu lombili andolimando ninguli: “Ono kou-takisi lili yema kinia ulu-pulu-kirima seli wema kinia ono pea nambi semu-na kere-langi nokomeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aku siku niringi pilipale Yesusini onondo nimbale: “Kuru naa tolemo yomboma doketana naa pulimili. Kuru tolemo yomboma mindi doketana pulimili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nane ‘Yombo sumbi nilima na molombona wangi.’ nimbúndu ma-koleana naa orundu. Ulu-pulu-kiri seli yomboma ⸤lipu tapondopo⸥ onondo ‘Ono ulu-pulu-kiri selemelema kanoko kiri pilku konopu topele toko ⸤na molombona wangi⸥.’ nimbúndu orundu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","⸤Kanu-kinia⸥ onone Yesusindu mangilku pilku ninguli: “⸤No Lindeli⸥ Jono lombili andolima kinia, Parisi yema lombili andolima kinia, onone wale marenga kere-langi mi leko naa nongo Pulu Yemo kinia mawa selemele-na-kolo nu lombili andolimane aku siku naa selemele, kere-langi kinia no kinia we nolemele. ⸤Pe nu lombili andolimane selemele mele peangaye⸥?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aku siku niringi pilipale Yesusini pundu topa onondo ⸤ungu-iku se topa yu toko kondonge kolombamonga ungu se nimba⸥ nimbale: “Ambo limba ye se yunga pulu lemó yema kinia molemo kinia ono konopu sikuli “Kere-langi mi lepo naa namili.” manda ningíye? Manda naa ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe mindi, ambo limba yemo ono molongena ongo wendo lingí kinia kanu walemanga sika ⸤konopu kiri panjiku⸥ kere-langi naa nongendo mi lenge. ⸤Iseli-u mólo.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesusini aku nimbale nirimumuni, ⸤ ‘U Juda yombomane ulu seringi uluma kinia pe ulu konde wendo okomomo kinia seluna manda naa pengele mele paa piliangi.’ nimba⸥ ungu-iku talo topa nimbale: “Mulu-maminia u se sungu nilimú kinia olione mulu-maminia paa konde senga se kopisipu lipu, sungu nilimúmunga naa topo tandolemolo kanumu. Yombo sene aku sipa topa tandolkanje kanu mulu-maminiamo nona panjilka kinia mulu-maminia konde kopiselimu kanga lepa lli nimbale mulu-maminia umu kelepa kamu awili sepa sungu nilka. Ulu se i-sipala: Mulu-maminia umu kinia mulú kopiseli kondemo selu-sili mólo, akumunga akutolo selu-sipa mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kongi meme kangimuni seli mingi u senga no-waene konde naa kololemolo kanumu. Yombo sene mingi u senga no-waene konde se kolkanje kanu no-waenemo mingina sukundu pepale pe akolka kinia kanu mingi umu naa akopa sungu nilka. Kanu-kinia nomo kepe mingimu kepe kamu kiri lelka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Akumunga no-waene konde kongi meme kangimuni seli mingi kondena mindi kololemolo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ye sene no-waene u se nombale kanu waene umu nomba peanga pilipale no-waene konde nonowalene naa kololemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Walte, ⸤koro moloringi⸥ wale Sambate senga, Yesusi kinia yu lombili andolima kinia rasi-witi kaliamanga ongo puringi kinia yu lombili andoli yemane rasi-witi mongo mare nongendo inia toko liku kilu toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aku seringi kanokole Parisi yemane Yesusi yundu ninguli: “Kána! ⸤Koro molemolo⸥ wale Sambatemonga ‘Kongono naa sangi.’ nimba pelemo ungu-manemo nambi semu-na nunga lombili andoli yemane ungu-manemo pulua tokole aku siku sekemeleye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesusini pundu topa nimbale: “Ono Pulu Yemonga bokuna sukundu ⸤anda-kolepa ye nokoli kingi⸥ Depitini serimu mele nimba molemo semanemo kanokole semanemonga pulumu naa pilielemeleye? Depiti kinia yu pea puringi yema kinia ono gelene kolkole niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Depiti Pulu Yemo molorumu serele-ulkana sukundu pumba, Pulu Yemonga kumbikerena lierimu pellawa kalolima lipa nomba, yu pea puringi yema sirimu noringila kanumu. Kanu pellawa kalolimando Pulu Yemone ungu-mane sipa nimbale: “We-yombomane paa naa nangi. Pulu Yemo popo tondoli yema manjiku nangi.” nirimu ⸤kanu ungu-manemo pulua torumu⸥ kanumu. ⸤Ono konopu talo nambi semu-na lemeleye? Depiti yuni u aku serimu mele ono pilku kiri naa pilielemelemonga pe kiniá na lombili andoli yemane sekemele mele kanoko kiri naala piliaa.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mania Omba Mana-Ye Au Lierimu Yemone Sambate walema nokolemo-na ⸤Sambate wale kinia yomboma molko kondongendo senge mele manda nimbá kanumu⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pe walte, koro mololi wale Sambate senga, Yesusi omba Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulkana sukundu pumbale ungu-mane sirimu. Kanu ulkana ye se molorumu, yunga ki-lomekondo kamu kolopa kukorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kanu-kinia akuna moloringi Parisi yema kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, onone ‘Yesusini ulu se sepa kinjimba kinia yu kote sendemolo.’ ningu ulu se sepa kinjimba se ⸤alieli koroko molkole⸥ ‘⸤Koro molemolo⸥ wale Sambate kinia yuni yemo sepa peanga simbanje.’ ningu yu mimi siku kanoko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ono konopuni pilieringi mele pilipale Yesusini kanu ki kolopa kukorumu yemondo nimbale: “Yomboma molemelena ongo ola giliani.” nirimu kinia yemo yu akuna omba ola gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kanu-kinia yemando nimbale: “Ono i-sipu mangilipu pilkiru. ‘Sambate wale kinia ulu nambolka ulu se manda semoloye? ‘Sambate walemonga ungu-manemone “Sangi.” nilimú mele samili.’ nimbu yomboma lipu tapondomolo kinia peanga molo yomboma sepo kinjimulú kinia mandaye? ‘Naa kolangi. Konde pangi.’ nimbu semolomo manda molo topo kondomolomo mandaye?’ nimbu mangilkiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aku sipa ono nimba mangilipale yuni ono pali neme-neme nimba kanopale ki kukoli yemondo nimbale: “Nunga kimu siniu si.” nirimu kinia yemone yunga kimu siniu sirimu kinia ki kolopa kukorumumu kelepa kamu peanga lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aku serimu kanokole mumindili awili seko kolko onone onono anju yando angelema ningu ninguli: “Sepa kinjikimumunga yu nambi samiliye?” ningu moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pe walte ipulieli Yesusi yu Pulu Yemo kinia ungu nimbando ma-pangi senga ola pumba Pulu Yemo kinia ungu nimba molopili kolea tangorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Orili-u yu lombili andolimando “Waa.” nimbale ‘Ononga ye engaki rurepo nanga kongonomo sangi lipu mundambo.’ nimbale aku yema nimba taltopa onondo nimbale: “Ono ‘Nanga kongonomo sende-pangi.’ nimbu lipu mundukuru yema.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","⸤Kanu ye engaki rurepo nimba taltorumumanga imbima i-sipa:⸥ Saimono (yunga imbi se Pita) yu keme, Pita genu Enderu keme, Jemisi, Jono, Pillipu, Batollomiu keme, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateyu, Tomasi keme, Allapiasinga malo Jemisi keme, “Olio Juda yomboma oliolio gapomano molamili.” niringi talape ye Saimono keme, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemisi malo Judasi keme, Judasi Isikeriote, Yesusi pe lipa opa-touma sirimu yemo keme, ⸤aku yema ‘nanga kongonomo sende-pangi lipu mundukuru.’ nimba, nimba taltorumu yema⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kanu-kinia yu kinia, yuni “Nanga kongonomo sende-pangi.” nimba lipa mundorumu yema kinia, ma-pangina mania oringi kinia yu lombili andoringi yombo awisili kinia, kolea Judia disiriki moloringi yombo awisili kinia, kolea-awili Jerusalleme peringi yombo awisili kinia, nomu-kusa kelona lierimu kolea-awili Taya kinia Saidonotolonga peringi yombo awisili kinia, yu molorumuna sukundu-sukundu ongo liku maku toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yu semane peanga topa, ungu-mane sipa serimu pilingindu ongo, yuni ono kuru torumuma ‘Sepa peanga sipili.’ ningu oringi. Ononga yombo mare konopumanga kuru kiri molorumuma sepa peanga sirimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kuru toli yomboma sepa peanga sili tondolomo yu-kinia pepili molorumu-kulu ono oringima pali ‘Yu ambolamili.’ ningu yu molorumuna nondoko nondoko oringi. Kanu-kinia ongo yu amboloringi kinia kanu tondolomone ono pea pali sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kanu-kinia Yesusi mania molopa yu lombili andoringima olando sipa kanopa onondo nimbale: “Ono koropa pulimúma Pulu Yemo ononga ye nokoli kingimu molopa ono nokolemomonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ono kiniá gele selemoma ono pe walte olo sembamonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. “Ono kiniá kola selemelema ono pe walte tawe sengemonga ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mania Omba Mana-Ye Au Lierimu Yemo pilku molemele yomboma, ono nanga yomboma molemelemonga we-yombomane ono-kinia konopu kiri panjiku, “Olio molemolona anju paa.” ningu, onondo “Ono yombo kirima.” ningu, ningu kinjiku, ononga imbima pilku kiri pilku senge kinia ono “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Yombomane ono aku siku mele selemelemonga⸥ ono mulu-koleana pungí kinia kanuna ⸤Pulu Yemone⸥ ono méle kalopa kondomba kene ⸤kanu yombomane ono aku siku seko kinjingí⸥ kinia konopu awili seko siku, konopu paa peanga pepili molangi. Yombomane kiniá ono mindili silimili mele, aku siku ono naa molangi koro-u Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siliku andoringi yomboma we-yombomane ono kepe mindili siringila kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aku-sipa na-kolo ono méle awisili taltolemele yomboma, iseli-u kiniá ono molko kondoko konopu peanga pepili molemele mélema koronga taltolemele, pe aku siku naa molongemonga mindili nongo molko kinjingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ono kiniá olo selemo yomboma pe walte gelene kolongemonga mindili nongo molko kinjingí. Ono kiniá tawe selemele yomboma pe walte ono kola sengemonga mindili nongo molko kinjingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","We-yombomane pali ono kape ningu alieli onondo “Yombo peangama.” ningí kinia ono mindili nongo molko kinjingí. Kanu yombomane onondo ungu peangama ningu kape ningí mele u ono naa molangi koro-u Pulu Yemone ungu-umbu tondorumuma naa pilku we kolo toko yombo ningu siringi yombomando i yombomanga anda-kolepalimane ungu peangama aku siku niringila. ⸤Pulu Yemonga unguma sumbi siku niringi yombomando kape naa ningu mindili siringi kanumu.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","⸤Aku nimbale Yesusini we moloringi yombomando nimbale:⸥ “⸤Akumu na lombili andolimando nikiru⸥-na-kolo nane ungu nikiruma pilku molemele yomboma, onondo ungu se pea niembo piliangila. Onone ononga opa-touma konopu mondoko, ono-kinia konopu kiri panjilimili yomboma seko kondoko sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Onondo ‘Yombo kirima kene molko kinjangi!’ nilimili yombomando ‘Ono yombo peangama kene molko kondangi.’ niengi. Ono seko kinjilimili yomboma ‘Pulu Yemone lipa tapondopili.’ ningu onone ononga mawa sendangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Yombo sene nunga kumbikere ekendonga laruwa tomba kinia topele toko ‘Ekendonga kamu laruwa topili.’ nieni. ‘Nunga wale-pakoli sulu peangamo liembo.’ nimbá yombomo nunga wale-pakolimu kepe ‘pea we lipili.’ nieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mélema si.” ningu mawa senge yomboma pali mélema we sieni. Nunga mélema we limba yombomondo “Kelko nanu si.” ni naa nieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“‘Yombomane nu-kinia sangi.’ konopu leno mele, nuni anju yomboma aku siku sani. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ulu-pulu-kiri selemele yomboma kepe onono anju yando kondo kololemele pilkuli ono yando kondo kololemele yomboma mindi kondo kolonge manda mólo. Ono kanoko kiri pilielemele yomboma pea kondo kolangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ulu-pulu-kiri selemele yomboma kepe onono anju yando kondo kolko seko kondolemele pilkuli ono yando kondo kolko seko kondolemele yomboma mindi seko kondonge manda mólo. Ono seko kinjilimili yomboma pea seko kondangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ulu-pulu-kiri selemele yomboma kepe onono anju yando pundu anjiku, ‘Walte kelepo sukundu limbu’ ningu pundu anjilimili pilkuli, ono yando pundu tolemele yomboma mindi pundu anjingí manda mólo. Ono pundu naa tolemele yomboma pea pundu anjangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“⸤Ulu-pulu-kiri selemele yomboma onono anju yando selemele mele ono ulu se olandopa sangila.⸥ Onone ononga opa-touma kepe kondo kolko, seko kondoko, pundu anjiku, sangi. ‘Onone pe walte kelko aku siku yando sangi.’ ni naa ningu, we sangi. Aku siku senge kinia Pulu Yemonga bolangoma molkole, yuni ono méle awisili kalomba lingí. Pulu Yemo yuni mana-yomboma-kinia aku sipa sepa molemóla. Yu seko kinjilimili yomboma kinia, yundu ‘Ange.’ naa ningu we molemele yomboma kinia kanuma sepa kondolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ononga Lapa Pulu Yemo seko kinjilimili yomboma kepe yu aku sipa kondo kolopa we sepa kondolemo mele ono seko kinjingí yomboma aku siku kondo kolko seko kondangi.” ⸤nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Onone yomboma selemele uluma naa apurungí kinia ⸤Pulu Yemone⸥ ono ulu selemelema naa apurumbala. Onone anju yombomane selemele mele apuruku kanokole “Seko kinjikimili. Sekemele mele ⸤Pulu Yemone⸥ kanopa kiri piliepili.” naa ningí kinia ⸤Pulu Yemone⸥ onone selemele mele apurupa kanopale “Seko kinjikinu. Sekeno mele kanopo kiri pilkiru.” naa nimbála. Yombomane ono-kinia seko kinjingí uluma ‘Mania pupili.’ ningu siye kolonge kinia ⸤Pulu Yemone⸥ ononga ulu-pulu-kirima ‘Mania pupili.’ nimba siye kolombala. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Onone yomboma pe-pe kepe ‘Pundu naa tangi.’ ningu mélema we singí kinia yuni ono aku sipa we simbala. Mélema simbando koltalo naa simba; olandopa olandopa simba. Onone anju singí kanopale ono yando aku sipa simbala.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesusini onondo ungu-iku se topa sirimula. Akumu i-sipa: “Mongo kiri lieli ye sene mongo kiri lieli ye se aulka manda lipa ora simbaye? Peatolo kombuna manda naa tolkaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ungu-mane pilku mololi yomboma ononga ungu-mane sili yombomo toko mania naa mundulimili. U ungu-mane pilku pungu pora silimili kinia pe mindi ononga ungu-mane sili yombomo pea selu-siku mele molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nuni genanga mongona norupulu se lemó kanoleno-na-kolo nunga mongona unju-kaliu awili se lemómo naa kanoleno akumu nambi semu-na selenoye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nunga mongona unju-kaliu awili lemómo naa kanokole genando “Ano, nunga mongona norupulu se lemómo wendo lindambo.” nambi seko nilinuye? Topele-mapele toli yombomo, nuni nunga mongona lemó unju-kaliu awilimu u wendo likuli pe kanoko kondoko genanga mongona lemó norupulumu manda wendo lindení.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","⸤Kanu-kinia Yesusini ungu se pea nimbale ungu-iku pokore topa nimbale:⸥ “Unju peangamone mongo kiri se manda naa tomba; unju kirimuni mongo peanga se manda naa tombala. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Unju mongo se kanokole kanu mongo torumu unjumu imbi manda silimili. ‘Amu nambo.’ ningu, takeme manda olko toko naa nolemolá. Molo ‘Ipono se nambo.’ ningu, silipu manda mengo naa nolemolá. Amu lupala takeme lupala kanoko, ipono lupala silipu lupala kanolemele kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aku sipa mele, yombo peanga sene yunga konopuna ulu peanga pelemoma selemo, aku-na-kolo yombo kiri sene yunga konopuna ulu kiri pelemoma selemo. Yombo se yunga konopuna pelemo unguma mindi kerena nilimú.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nane niliu unguma pilku liku naa sekole onone nando “Ye-Awilimu” we nambi semu-na nilimiliye?” ⸤nimbale pe yuni ungu-iku se pea onondo topa nimbale:⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","I nanga unguma pilku liku senge yomboma ono ye se molemo mele niembo: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ye se yuni yunga ulkamo ‘Ingi nimba giliepili.’ nimba we ma kinia okiya kinia akupa eltopale, akuna mania kou-polona ola takorumu. Ulkamo aku sipa takopa kondorumu-kulu pe no topa ulkamo paa topa kalambili simba serimu kinia topa sikise naa sikisipa ingi nimba we gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aku-sipa na-kolo i nanga unguma pilku liku naa senge yomboma ono ye se molemo mele niembo: Ye se yunga ulka we ma pange selina ola walu takorumu. Pe no topa ulka kanumu waltikele topa kalambili sirimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yomboma piliangi kanu unguma nimba pora sipale Yesusi Kapeniame taonona sukundu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akuna Romo-yombomanga ami-ye wane anderete nokorumu ye senga kendemande-⸤ye⸥ se yu paa konopu mondorumumu kuru awili sepa topale yu kolomba sepa lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kanu ami ye nokolimuni Yesusi orumu pilipale yuni Juda tapu-ye mare lipa Yesusi molorumuna mundupa nimbale: “Nanga kendemande-⸤ye⸥mo ⸤kuru awili sepa tomu kene⸥ ongo seko konde li.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Kanu Juda tapu-yemane Yesusi molorumuna ongo aku siku ningu, yunga ningu tondolo munduku mawa sendeko ninguli: “I kendemande-⸤ye⸥ kolkomomonga ami ye nokolimu yu ye paa peanga. ⸤Yu Juda ye se mólo⸥ na-kolo olio Juda yomboma konopu mondopa, olio maku topo Pulu Yemonga ungumu pilielemolo ulkamo yuni takondorumu kene nuni yu liku tapondonu liemu papu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aku niringi pilipale Yesusi ono kinia kanu yemonga ulkana pumbá purumu. Kanu ulkamonga nondopa orumu kinia kanu ami-ye nokolimuni yunga pulu lierimu yombo mare Yesusi orumuna lipa mundorumu, ongo yundu ninguli: “Ami ye nokolimuni i-sipa nikimu: “Ye-Awilimu, na ye kirimu mele molio, nu nanga ulkana oni kinia manda naa sembá kene nu kála seko ya naa wani. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Nu molenona na ye kirimu manda naa ombóla konopu liendu. Na ye sene kepe nokopa molemo, yunga ungumu pilipu lipu selio. Nane kepe ami-ye mare nokopo molio. Kanu yemanga sendo “Pu.” niliu kinia yu pulimú. Molo sendo “Ou.” niliu kinia yu olemo. Molo nanga kongono sendeli kendemande-yombo sendo “I-siku sei.” niliu kinia yu aku sipa selemo kanumu. Aku sipala, nuni ungu se we nini kinia nanga kendemande-⸤ye⸥mo we konde pumbá kene nuni we ungumuni mindi ni.” nikimu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusini Romo ami ye nokolimuni nimba mundorumu mele pilipale yu konopu awisili kimbu sipa yu lombili oringi yombomando nimbale: “Nane onondo paa sika nimbu sikiru: “I Isirele yombomanga talapena ultu mololi yemone na ungumuni mindi manda sembá mele kuru mondolemo mele koleamanga pali, Isirele koleana sukundu kepe, yombo selurini kepe aku siku kuru mondoringi mele paa naa kanorundu. Yu ‘Sika.’ nimba kuru mondolemo mele paa olandopa.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aku nirimu pilkuli ami ye nokolimuni Yesusi molorumuna mundorumu yema kanu ami-yemonga ulkana yando ongole kendemande-⸤ye⸥mo konde purumu kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesusi kolea Néne taonondo purumu, yu lombili andolima kinia yombo mare awisili kinia pea puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yu Néne taono pala kerepuluna nondopa purumu kinia ye se kolorumumu óno sengendo taropola seko mengo ultu pungí oringi. Kanu kolorumu yemo yunga anumu lapatolone yu komolayemo meringili kinia pe se lupa naa meangili lapa kolorumu. Pe yunga anumu ambo-wayamo molopili yu kolorumula. Kango kanumu óno sengendo yombo awisili anumu kinia kopu seko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ye-Awilimuni ambomo kanopale paa kondo kolopa yundu “Kola naa sei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kanu-kinia yu yombo taropolamonga nondopa omba taropolamo omba ambolopale, meringi yema we mengo giliangi yuni nimbale: “Kango-yemo, ola molou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kanu-kinia kolorumu yemo ola molopa yu ungu nirimu. Kanu-kinia Yesusini ye kolorumumu lipa yemo yunga anumu yuyu sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yesusini aku serimu-na yombomane pipili kolko ninguli: “Pulu Yemonga ungu-umbu tondolima pilipa yomboma nimba sili ye awili se olio molemolona wendo omu lepomo.” ningu Pulu Yemo yunga imbimu ambolko paka tondoko ninguli: “Pulu Yemo yunga yomboma molemelena omba lipa tapondomu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","I Yesusini serimumunga semanemo kolea Judia disiriki pali kinia Judia ultu kolea lupa lupama pali anju anju purumu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesusini serimu mele Jono yu lombili andolimane yundu ningu siringi kinia yuni yu lombili andolimanga talo “Yando wale.” nimbale Yesusi molorumuna olo lipa mundupa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“⸤Pulu Yemone olio nokopa kondomba yere⸥ “Lipu mundumbu.” nimba, nimba panjerimu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo se lupa ombámo nokopo molamiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kanu yetolone Yesusi molorumuna ongo yundu ninguli: “No Lindeli Jonone olto lipa mundupa nimbale: “⸤Pulu Yemone olio nokopa kondomba yere⸥ “Lipu mundumbu.” nimba, nimba taltorumu yemo ‘Ombá.’ nimbu nokopo molemolo kanumu nu molo se lupa ombá nokopo molamiliye?” nimu.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aku siku mangilku pilkuli niringilimuni, ena senga ⸤we kanoko giliangili⸥ Yesusini kuru lupa-lupa torumu yomboma kinia, konopumanga kuru molorumu yomboma kinia, mongo kiri lierimu yombo awisili kinia, sepa peanga sipa molorumu kanoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe Yesusini olondo pundu topa nimbale: “Olone ya kanokombele mele kepe pilkimbili mele kepe Jono ningu si-pale. Mongo kiri lieli yomboma mongone kanoko, kimbu kiri lieli yomboma manda andoko, kuru-laká noli yomboma umbu-kangi gilipa, komu sili yomboma komuni pilku, kolopa lieli yomboma ola molemele kepe, koropa puli yomboma semane peangamo topo siliu pilielemelela kanumu. Aku siku Jonondo ningu siele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na kanokole ‘Yu sika kanu yemo molemo.’ ningu kuru mondokole, kelko konopu talo naa panjiku molonge yomboma ono maloya.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonone mundorumu yetolo kelko nendo puringili kinia Yesusini kelepa yombo awisili maku toko moloringimando Jonondo nimbale: “⸤Kolea ku lielina Jono no lindipa molorumu kinia⸥ ono kanu kolea ku lielina nambolka kanonge puringiye? ⸤Molo⸥ lkepania mele poporomene lope-lope sendepa molorumu se kanonge puringiye? ⸤Jono yu aku sipa mele mólo kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","⸤Alieli kanolemele mele kanonge naa puringi liemu⸥ ulu nambolkare kanongendo puringiye? Ye se mulu-maminia paa peangama pakopa molorumu kanonge puringiye? Akumu mólola. Yombo kamako molko, méle awisili taltoko, mulu-maminia paa peangama pakolemelema ye nokoli kingimanga ulkana manjiku molemele kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“⸤Aku sili ye se kanonge naa puringi liemu⸥ Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba sili ye se kanonge puringiye? Akumu sika na-kolo nane onondo nimbu sikiru: “Jono yu sika Pulu Yemonga ungu-umbu tondorumuma pilipa nimba sili ye se na-kolo yu Pulu Yemone ungu-umbu tondorumuma pilipa nimba sili ye we se mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nikiru ye kanumundu Pulu Yemonga bokuna sukundu molemo ungu se i-sipa: ‘⸤Pulu Yemone yunga Malondo nimbale:⸥ “Pilieyo! Nanga ungu nindimba yemo nane nu puni aulkana yu kumbi lepo lipu mundukuru. Yuni nunga aulkamo akisindimba.” nirimu.’ kanu ungumu bokuna molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nane onondo paa sika nimbu sikirumu: “U mana moloringi yombomanga se ⸤No Lindeli⸥ Jono kinia manda mólo. Jono olandopa mele. Aku-sipa na-kolo kiniá wale kondemo wendo okomo. Kanu walemo Pulu Yemo ye nokoli kingimu molopa nokolemo yombomanga se paa imbi naa molopa paa koropa puli yombomo olandopa; Jono yu maniandopa. ⸤U moloringi yomboma mania mele; kiniá na ‘Sika.’ ningu kuru mondongemonga konopu peanga pemba yomboma olandopa.⸥” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesusini aku sipa nirimu pilkuli we-yomboma kinia kou-takisi liltingi yema kinia Yesusini Jonondo nirimu ungumu pilku peanga pilku Pulu Yemo kape niringi. Kanu yombomane u ⸤No Lindeli⸥ Jonone nirimu ungumu pilku peanga pilkuli ono ulu-pulu-kiri seringima bulu siku, konopu topele toko ‘Olio Jonone no lindepili.’ ningu no liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aku-sipa na-kolo Parisi yema kinia, Pulu Yemonga ungu-manemanga puluma pilku kondoringi yema kinia, onone ‘Pulu Yemone Jono naa mundorumu.’ ningu pilkuli, Pulu Yemone “Yombomanga lipu tapondopo sendembo.” nirimu ungumu pilku kiri pilku bulu sikuli pe ‘Jonone olio no naa lindepili.’ ningu no naa liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kanu-kinia Yesusini ungu se pea nimbale: “Kiniá mana molemele yomboma nambolka mélse ono manda manjipu manda nimbúnje? ⸤Ono molemele mele i-sipu nimbu siembo:⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ono yomboma maku tolemele koleana bolangoma pepe pereko molemele mele. Kanu bolangomanga marene ne-anju molemele bolango mare ⸤pea pepe pereko molonge aulka se koroko kelkole⸥ onondo mangilku ninguli: “Konane nímulu kinia ono ‘Pea konane niemili.’ naa ningu “Mólo.” níngi. Pe kelepo kola semulu kinia ono ‘Pea kola samili.’ ni naa níngi. ⸤Pea pepe perepo molomolo aulka se mólo lepomo.⸥” nilimili. ⸤Kiniá molemele yomboma ono kanu bolangoma mele molemele.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","⸤Na kinia No Lindeli Jono kinia oltone nilimbulu unguma onone pilku kiri pilielemele; selembolo mele kanoko kiri pilielemelela⸥. Jono ombale ga kinia no-waene kinia naa nomba molorumu kinia ⸤kanoko kiri pilku⸥ ninguli: “Yunga konopuna kuru se molemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pe Mania Omba Mana-Ye Au Lierimu Yemo omba ga kinia no-waene kinia norumu kinia ⸤kanoko kirila pilku⸥ ninguli: “Yu ga awisili nomba siye naa kolopa, no-waene awisili nomba amu topa selemo yemo. Yu kou-takisi lili yema kinia, ulu-pulu-kiri selemele yombo wema kinia ‘Yu kinia pulu liepili pea kopu sepo molamili.’ nimba selemo.” nilimilila. ⸤Onone aku siku Jono kanoko kirila pilielemele. Na kanoko kirila pilielemele.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aku-sipa na-kolo pilipa kondoli ulu-pulumu Pulu Yemo kinia pelemo-na yunga bolangomane pali yuni selemo mélemando ‘Papu selemo.’ ningí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Walte, Parisi ye sene Yesusindu “Kere-langi pea nambili ou.” nirimu kinia yunga ulkana sukundu pumba akuna kere-langi polona nondopa polo senga mania molorumu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","kanu koleana molorumu ambo ulu-pulu-kiri seli sene Yesusi yu kanu Parisi yemonga ulkana sukundu kere-langi nomba molorumu pilipale, yu wambola paa komindi se mingi pali lipa akuna memba pumbale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesusi molorumuna bulkundu kimbuna nondopa kola sepa gilipale, pe Yesusi yunga kimbutolo kola-mongomane kulumiye tondopa, pe ambomo yunga penge-lapisamo lipa kanu kimbutolo kulu tondopa, kimbutolo kangulupa, wambola memba orumu kanumuni kimbuna ape kandondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kanu ulka pulu ye Parisi ⸤Saimono⸥ yuni ambomone aku serimu kanopale yuyu konopumuni pilipale ‘I yemo paa sika Pulu Yemone ungu-umbu tondolemo pilielemo ye se molkanje i ambo yu ambolkomomo molemo mele kinia ulu-kiri selemo mele kinia manda pilipale “Na naa ambolko, ongo wendo pu.” nilka.’ konopu lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesusini ⸤Saimono⸥ konopumuni pilierimu mele pilipa yundu nimbale: “Saimono, nu ungu se niembo.” nirimu kinia Saimonone pundu topa nimbale: “Ungu Mane Sili Yemo, manda, ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","⸤Aku nirimu kinia Yesusini yundu semane se topa nimbale:⸥ “Ye sene ye talo kou-mone pundu anjipa sirimu. Ye se wan anderete kina mele sipa, ye se tene kina mele sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pe olo pea pundu manda naa tondoringili kinia ye pundu anjerimu kanu yemone pundutolo we siye kolopa “Unguri mólo, yu sepili.” nirimu. Aku nirimumunga yetolonga nawene yu konopu olandopa mondorumu konopu lekenoye?” nimba Yesusini Parisi yemondo aku nimba mangilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","⸤Kanu Parisi ye⸥ Saimonone yundu pundu topa nimbale: “Pundu awili anjerimu yemo, konopu lekero.” nirimu kinia Yesusini “Paa nikinu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanu-kinia Yesusini topele topa kanu ambomo gilierimuna kanopa Saimonondo nimbale: “I ambomo kána! Na nunga ulkana sukundu ondu kinia ⸤olio Isirele yombomane ye ponenge kokele olemo kinia selemolo mele⸥ nuni nando aku naa senu. Nuni “Kimbu kulumiye tou.” ningu no naa sinu-na-kolo i ambomone nanga kimbutolo yunga kola-mongomane kulumiye tondopa, yunga penge-lapisamo lipa nanga kimbutolo kulu tondomu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na ondu kinia nuni na naa kangulonu-na-kolo i ambomone na ondu kinia kepe yandopa kiniá kepe nanga kimbutolo kangulupa molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na ondu kinia nuni nanga pengena wambola liku ape naa kandondonu-na-kolo i ambomone nanga kimbutolo wambola komindi sene ape kandondomu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yuni ulu-pulu-kiri awisili serimuma mania pumumunga na konopu awili-sepa mondopale aku sipa semu. Aku-sipa na-kolo ulu-pulu-kiri koltalo mindi selemo yombomo yunga serimu mele ‘Mania pupili, siye kolkoro.’ nimbá yemo konopu kanga-kolte mondombala.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ye Saimonondo aku sipa nimba pora sipale nirimumuni, ambomondo nimbale: “Nunga konopuna ulu-pulu-kiri serinu pelemoma mania pupili, siye kolkoro.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aku nirimu pilkuli yu-kinia kere-langi nongo moloringima yuni nirimu mele pilku kiri pilkuli onone anju yando angelema ningu ninguli: “Yombomane ulu-pulu-kiri selemelema i yemone “Mania pupili, siye kolkoro.” nikimu yemo yu nawe? ⸤ ‘Na Pulu Yemo.’ konopu lepale nikimunje?⸥” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kanu-kinia Yesusini ambomondo kamu nimbale: “Nane nu ulu-pulu-kiri serinu mele ‘ ‘Omba wendo pupili.’ manda nimbú.’ ningu kuru mondoko onumunga na sika aku sipu manda lipu tapondokoro kene nu konopu pe nipili mololko pani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kanu-kinia pe Yesusi pumba, kolea awili kanga akumanga andopale nirimumuni, Pulu Yemo ye nokoli kingimu molopa yomboma nokomba semane peangamo topa silipa, yomboma ungu-mane silipa andorumu. Yu lombili andoli ye engaki rurepo kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ambo mare kinia yu pea andoringi. Kanu ambomanga mare u kuru topa, mare u kuru ononga konopumanga peringi kinia Yesusini ono pali sepa peanga sirimu. Se, kolea Makatalla ambo Maria, u yunga konopuna kuru yopoko-pakara moloringimando Yesusini “Ongo wendo paa.” nirimu kinia ongo wendo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Se, ambo Joana, Susa menu. Susa yu kolea Gallilli disiriki ye nokoli kingi Erotenga ulka tapu-yemo. Se, ambo Susana. Ono kinia we-ambo awisilini Yesusi nokoringi. Kanu ambomane ononga kou-mone taltoringima likuli Yesusi kinia yu lombili andolima ononga kere-langi mélema topo toko liku siku nokoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kanu-kinia Yesusi molorumuna kolea lupa lupamanga moloringi yomboma sukundu sukundu ongo, liku maku toringi kinia yuni onondo ungu-iku se topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ye sene rasi-witi umbu kaliana andopa tanda sirimu. Tanda silipa andorumu kinia umbu mare aulkana mania purumu, kanuma yombomane kimbuni kuloringi; mare keramane ongo liku noringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Umbu mare kou perimuna mania pumbale akuna no naa molorumu-kulu toko nimba wendo omba waltikele kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Umbu mare siri-ka mele molorumuna mania purumu, siri-ka mélemo wendo omba witi-umbuma topa norumu-kulu omba peanga naa lepa ⸤mongo se naa torumu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Umbu mare ma peangana mania purumuma wendo omba mongo peangama topa, mongo towapu kise mele torumu.” ⸤nirimu.⸥ ⸤Aku nimbale⸥ “Yombo komu-pea lemomane i ungumu piliaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","⸤Yesusini aku nirimu kinia⸥ yu lombili andolimane yundu ninguli: “Aku ungu-ikumunga pulumu ningu si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kanu-kinia yuni onondo nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma kinia mélema nokolemomonga ulu-pulu u yuyu pilierimu kanu ulu-puluma ‘Ono kiniá ⸤na lombili olemele yomboma⸥ piliangi.’ nimbale ono ‘Ungu-ikumanga puluma piliangi.’ nimbale ono nimba sikimu. Aku-sipa na-kolo we-yomboma ‘Unguma nimbu siembo.’ nimbuli ungu-ikuma mindi topo siliu. ⸤Pulu Yemone Aisayanga kerena nimbale:⸥ ‘Ono mongone kanokole naa kanoko, komuni pilkuli naa pilielemele.’ nirimu akumunga we-yombomando ungu-ikuma mindi tolio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aku nimba yuni nimbale: “Aku ungu-ikumunga pulumu i-sipa: “Kere-langi umbu tanda sirimu kanu umbuma Pulu Yemonga ungumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Umbu mare aulkana mania purumuma yombo mare aku sílima molemele. Onone ungumu pilielemele kinia pe ⸤kurumanga nokoli⸥ depelemo omba ‘Aku ungumu kamu kuru mondongi liemu Pulu Yemone ono lipa tapondopa aulka kirina wendo limba kinia manda mólo.’ nimba ungu tanda sili konopuna pumba pelemoma wendo limú. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Umbu mare tanda sirimu kou perimuna mania purumuma yombo mare aku sílima molemele. Onone ungumu pilkuli konopu siku pilku limili. Aku-na-kolo ono pulkonio naa mundukuli ungumu kanga-kolte mindi pilku molemele. Pe ono konopuna umbuna sembá kinia molo ⸤Setene omba⸥ manda manjipa kondi-ka sembá kinia, ono pilielemele ungumu siye kololemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Umbu mare tanda sirimu siri-ka mele molorumuna mania purumuma yombo mare aku sílima molemele. Onone ungumu pilkuli pe aulkana pungí pungí kinia konopuna umbuna selemo umbunama kinia, méle awisili taltolemele mélema kinia ya ma-koleana uluma seko konopu singí uluma kinia, aku sili ulu mare wendo omba ungu kanumu topa nolemo kinia ungumuni uluri naa sepa kere-langi mongo kamu naa tolemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Umbu mare tanda sirimu ma peangana mania purumuma yombo mare aku sílima molemele. Onone ononga konopu peanga pepili molko ungumu pilkuli kanu ungumu kamu liku kuru mondokole, tondolo pupili molemele kinia kanu umbuma kere-langi mongo ⸤awisili⸥ tolemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","⸤Yesusini onondo ungu-iku se pea topa nimbale:⸥ “Yombomane sepe-llame kandokole mingina sukundu naa panjiku polo maniakondo naa taltokole nilimilimuni, ‘Yombo ongema kolea pa kanangi ulkana sukundu pa sepili.’ ningu polo senga ola taltolemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aku sipa mele, kiniá lopi selemo mélema pe walte mona lemba yomboma kanonge; kiniá aki topa lemó mélema pe walte pa sembá kinia yombomane kanu mélema kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aku sembá kene onone ungu pilielemele akumu mimi siku piliangi. Pulu Yemonga ungumu pilku molemele yomboma paa olandopa nimba simba pilingí. Pe paa awisili pilingí. Aku-sipa na-kolo naa pilku molemele yomboma ono kanga-kolte pilielemele ungumu kepe wendo limba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Walte Yesusi ulka senga sukundu molorumu kinia yunga anumu keme genupilima yu kanongendo oringi. Akuna yombo awisili ekelepa seko moloringi-kulu yu molorumuna nondoko manda naa ongole ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","⸤ungu se ningu mundoringi kinia⸥ yombomane yundu ninguli: “Aminia kinia genali nu kanongendo ongo pena gilimili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesusini onondo pundu topa nimbale: “Pulu Yemonga ungumu pilku liku selemele yomboma nanga anumu kinia nanga genupilima molemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Walte, Yesusi kinia yu lombili andolima kinia ono nona andoli sipi senga sukundu puringi kinia punguli, yuni onondo nimbale: “Nomu nekendo pamolo.” nirimu kinia akuna pungí puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sipina pungí puringi kinia Yesusi yu uru perimu. Yu uru pepili poporome awili se nomuna torumu. Aku serimu-na ⸤nomumu apisipa ola ombale⸥ no sipimunga sukundu sukundu omba peke lepale sipimu memba nona mania pumbá serimu kinia ono nona wangonge seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanu-kinia yu uru perimuna pungu toko makisindiku ninguli: “Ye Nokolimu, Ye Nokolimu, olio nona wangokomolo.” niringi kinia yu makilipale poporomemo kinia no apisipa ola orumu nomumu-tolo iri torumu. Kanu-kinia poporomemo topa kelepa, nomumu lope naa sepa we lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kanu-kinia yuni lombili andolimando nimbale: “‘⸤Pulu Yemone olio nokomba.’ ningu⸥ kuru naa mondokomeleye?” nirimu. ⸤Yuni serimu mele kanokole⸥ yemane pipili kolko mini-wale mundukuli anju yando onono mangilku ninguli: “Apa! I yemo nawenje? Poporomemone kepe nomumuni kepe yuni olondo “Sale.” nilimú ungumu pilku liku kelkembele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kanu-kinia nomuna nekendo pungu kolea Gerasa puringi. Nomu yakondo kolea Gallilli, nomu nekendo kolea Gerasa kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Akuna oringi kinia Yesusi sipimunga wendo omba kelona gilierimu kinia kanu koleana ye se yu molorumuna orumu. Kanu yemo kuru awisili yunga konopuna moloringimunga mulu-maminia selu kepe naa panjipa, we-we andopa, ulka senga naa pepa, yombo-óno-koleana pelepa andopa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kurumuni kanu yemo alieli liltimu-kulu yombomane ka-sénene yu kimbu kima ka toko yu nokoko moloringi-na-kolo ka-sénema sungu sirimu kinia pe kurumuni kolea ku lielina yu memba purumu. Kanu yemone Yesusi kanopale kalli nimba yu gilierimuna mania molopa tamalu pepa tondolo mundupa nimbale: “Yesusi, Pulu Ye Paa Olandopa Awilimunga Malo, na-kinia ungu nambolka unguri senindu onuye? ‘ “Na mindili paa naa lipu simbú.” ni.’ nimbu mawa sekero.” nirimu. ⸤Yu kokele ombá orumu kinia⸥ Yesusini u nimbale: “Kurumu, i yemonga konopuna ongo wendo pu.” nirimu mele pilipale yemone aku sipa “Naa sei.” nimba mawa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aku nirimu kinia Yesusini yemondo mangilipa nimbale: “Nunga imbi nawe?” nirimu kinia yemo yunga konopuna kuru awisili moloringi-kulu pilipale yuni “Nanga imbi Paa Awisili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kanu kuru awisilimane wale awisili Yesusi mawa seko ninguli: “Olio ‘ongo wendo pangi.’ ningu toko makorokole “⸤I ma-koleamo munduku kelko⸥ Pulu Yemone komuru paa lepa mindi pumba pora naa nilimú murumunga ⸤olionga ye nokoli Setene walte lipa mundumba⸥ kanu murumunga paa.” ni naa ni.” ningu mawa seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akuna ma-pangi senga umbu-kongi awisili ímu nongo moloringi kanokole Yesusi mawa seko ninguli: “Olio ⸤toko makorokole⸥ ‘Ne kongimanga konopumanga molo-pangi.’ ni.” niringi kinia yuni “Manda, akuna pangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aku sipa nirimu kinia kuruma kanu yemonga konopuna wendo ongole kongi akuna moloringimanga konopumanga pungu moloringi kinia kanu kongima amu toko lisiku pungu kopona pukua toko nomuna sukundu pungu nona wangoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ulu akuma wendo orumu-na kanokole kongi tapu seko moloringi yema kowa punguli niringimuni, kolea-awilina moloringi yomboma kinia, kolea-kangamanga moloringi yomboma kinia, ulu akuma wendo orumu mele semanemo toko siliku puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kanu semanemo pilieringi yomboma ‘Uluma wendo omu mele kanamili.’ ningu wendo pungu Yesusi molorumuna ongole u kuru awisili konopuna molko ongo wendo puringi yemo mulu-maminia pakopa, umbu-konopu pepili Yesusi molorumuna nondopa mania molorumu kanokole ono pipili koloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yesusini serimu mele mongone kanoringi yombomane pe oringi yomboma ningu siringi. Kuru awisili konopuna moloringi yemonga konopuna kuruma ongo wendo puringi kinia yemo yu umbu-konopu pepili molorumu mele ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kanu-kinia kolea Gerasa yomboma pali paa mini-wale mundukuli Yesusi mawa seko ninguli: “Olionga koleana naa mololi kelko pu.” niringi kinia yu kelepa pumbándo nona andoli sipimunga sukundu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","⸤Yu pumbá serimu kanopale⸥ kuru awisili konopuna u molko wendo oringi yemone yundu nimbale: “Pea pambili.” nimba mawa serimu. Aku-na-kolo Yesusini “Mólo.” nimba yundu nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nu ulkondo pungu Pulu Yemone nu lakopa sepa kondomu mele nunga yomboma ningu si-pu.” nirimu. Yesusini aku nirimu-na pilipale ye kanumu pumba kolea-awilina sukundu moloringi yomboma pali Yesusini yu-kinia lakopa sepa kondorumu mele nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kanu-kinia Yesusi yu nomu yakondo orumu kinia yu ‘Ombá.’ ningu maku toko nokoko moloringi yombomane “Nu papu okono.” ningu konopu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka se nokorumu ye se, yunga imbi Jairasi, Yesusi molorumuna orumu. Kanu-kinia yu Yesusinga kimbuna nondopa omba mania molopa tamalu pepa yundu mawa sepa nimbale: “Nanga ulkando pea pambili ou.” nirimu. Yemo yunga bolamo, yunga lemenu selu mindi, yu kalia-ingi engaki rurepo mele omba purumu kanu bolamo, kuru paa awili sepa torumumunga yu nondopa kolomba sepa lierimumunga ⸤yemone Yesusi aku sipa mawa serimu⸥. Pe Yesusi kanu ulkana pumbá purumu kinia yombo awisili liku maku toko yu kakapu seko ekelepa seko pea puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kanu yombo pea puringimanga ambo se yunga pena perimu walema pora naa nirimu. Yu pena mindi pepili kalia-ingi engaki rurepo omba purumu. Yu doketamanga yunga kurumu ‘Pora nipili.’ nimba andopa, yunga kou-mone pali ono sirimu-na-kolo kuru kanumu pora naa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kanu ambomo Yesusi pumbá purumu kinia bulkundu omba, yunga wale-pakolimunga pundumu ambolorumu kinia waltikele yunga kuru torumu kanumu pora nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aku serimu kinia Yesusini nimbale: “Na nawene ambolomuye?” nirimu. Onone pali “Na mólo.” niringi kinia ⸤yu lombili andoli ye⸥ Pitane yundu nimbale: “Ye Nokolimu, yombo awisili nu gilinuna nondoko nondoko ongo kakapu seko ekelepa seko gilkimili kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aku-sipa na-kolo Yesusini kelepa nimbale: “Na yombo lipu tapondolio tondolo mare nanga kangina omba ultu pumu-kulu pilipuli yombo sene na ambolomumundu nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aku sipa nirimu pilipale ambomo yu lopi manda naa sepa, yu serimu mele Yesusi pilipa molorumu kanopale yu kimbu ki puru-puru nipili Yesusi molorumuna omba mania molopa tamalu pepale, yomboma pilku giliangi yuni ‘Kuru pora nipili.’ nimba omba yu ambolorumu kinia waltikele peanga lierimu mele nimba para sirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesusini yundu nimbale: “Ambomo, ‘Nu manda sepa peanga simba.’ ningu kuru mondonu kanu ulumuni nu peanga lekemo. Konopu pe nipili mololko pani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusini ambomondo aku sipa nimba molorumu kinia, ye se, yomboma maku toko Pulu Yemonga ungumu pilieringi ulka nokoli ye ⸤Jairasi⸥nga ulkana molopale omba ⸤Jairasindu⸥ nimbale: “Nunga bolamo kolopa pora simu. Ungu Mane Sili Yemo ‘Mindili nopili.’ ningu we naa mengo wani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yuni nirimu mele Yesusini pilipale ⸤ulka nokoli yemondo⸥ nimbale: “Mini-wale naa mundoyo. Nunga bolamo nane ‘Manda lipa tapondomba.’ ningu kuru mondoko moloni kinia yu konde pumba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Kanu-kinia Yesusi yemonga ulkana ombale ulkana sukundu yombo awisili bola kolorumumu kondo kolko kola seko moloringi kanopa onondo nimbale: “Bolamo kolou naa kolomu. We uru mindi pelemo kene kola naa saa.” nirimu. Aku-na-kolo yu sika kolopa pora sirimu pilkuli yuni “We uru pelemo.” nirimumunga onone yu ungu-taka tondoko tawe senderingi. Pe yu ⸤bolamonga suluminiana⸥ pumbá purumu kinia ‘We-yomboma pali naa ongo anju paa.’ nimbale Pita keme, Jono keme, Jemisi keme, kanu bolamonga anumu lapatolo kinia “Ono mindi pea pamili.” nimba ⸤bola ónomo lierimu⸥ suluminiana ono memba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pumbale bolamonga kimu ambolopa yundu mangilipa nimbale: “Bolamo, nu ola molou.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","yunga mini purumu kanu minimu kelepa sukundu orumu kinia bolamo waltikele ola molorumu. Kanu-kinia Yesusini ⸤anumundu⸥ nimbale: “Bolamo kere-langi mare liku si.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yuni serimu mele kanokole bolamonga anumu lapatolo olo paa mini-wale mundoringili-na-kolo yuni olondo tondolo mundupa nimbale: “Ungu i sekeromo yombo selurindu kepe anju pungu paa naa ningu siele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Walte Yesusini yu lombili andoli ye engaki rurepondo “Yando waa.” nimbale, onone yombomanga konopumanga kuru molemelema “Ongo wendo paa.” ningu toko makoronge tondolomo sipale, yombo kuru tolima ‘Peanga liepili.’ ningí nambamo sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aku sipa sepa onondo nimbale: “Ono pungu, Pulu Yemo omba ye nokoli kingimu molomba semane peangamo yomboma toko siliku andoko, kuru toli yomboma seko peanga siliku pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pungíndu, ono mélema naa mengo we pangi. Apulu-mingi kepe, méle-wale kepe, kere-langi kepe, kou-mone kepe, wale-pakoli talo kepe naa mengo we pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pe kolea senga sukundu punguli akuna molongendo ulka seluringa sukundu punguli akuna mindi peko molkole pe aku koleamo munduku kelko pangi. ⸤Ulka pinia-pinia naa andoko ulka seluringa mindi kere-langi nongo peangi.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kolea marenga sukundu pungí kinia kolea pulu yombomane “Papu ongi. Pea peamili waa.” ni naa ningu onone ungu ningíma pilku naa língi liemu kanu koleana yombo kirima munduku kelko pungíndu ono bulu siku ungu naa pilku lingimunga kanu koleana yomboma ‘Kamu molko kinjangi! Pulu Yemone ono lipa naa tapondomba mele piliangi.’ ningu ononga kimbuna kanu koleamanga ma gilimbama kulu tokole pangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aku nirimu kinia kanu yema pungu, koleamanga andoko, Pulu Yemonga semane peangamo toko siliku, kuru torumu yomboma seko peanga siliku, selko andoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kolea Gallilli disiriki nokorumu ye nokoli kingi Erotene Yesusini serimu mele semane toringi pilipale, ‘I yemo nawenje?’ nimba pilipa sundorumu. Yombo marene ninguli: “I yemo ⸤No Lindeli⸥ Jono ⸤talko kolorumu kanumu⸥ lomboropa wendo omunje.” ningu moloringi. Marene ninguli: “⸤Pulu Yemone u konde molopili olando liltimu ye⸥ Illainja kelepa omba molemo.” ningu moloringi. Marene ninguli: “Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi ye koro-u molko koloringimanga ye se lomboropa wendo orumu.” ningu moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","⸤Ye nokoli kingi⸥ Erotene ⸤Yesusini serimu mele semane toringi⸥ pilipa nimbale: “⸤No Lindeli⸥ Jono ‘yunga pengemo wendo pupili.’ nimbu nomimu kari lierindu yu kolorumu-na-kolo i ulu-tondolo lupa lupa selemo pilielio yemo yu nawenje?” nirimu. Aku sipa nimbale “I ye Yesusi kanamboa!” nimba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusini “Nanga kongonomo sende-paa.” nimba lipa mundorumu yema yu molorumuna kelko yando ongole niringimuni ulu seringima yu semane toko siringi. Kanu-kinia kanu yema lipa memba pumba ‘Senga oliolio molamili.’ nimba ono Besaida taonona memba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aku-na-kolo yombo paa awisili ono akuna puringi mele pilkuli yu purumuna akileko lombili puringi. We-yomboma oringi kanopale Yesusini onondo “Papu ongi.” nimbale ono Pulu Yemo omba ye nokoli kingimu molomba semane peangamo topa sipa, ononga yombo kuru torumuma ‘Peanga liepili.’ nimba ono sepa peanga sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pe ipupini ena pumbá serimu kinia yu lombili andoli ye engaki rurepo yu molorumuna ongo yundu ninguli: “I koleana yombo se naa pelemele kene ya maku toko molemele yomboma ‘Pungu kolea marenga kere-langi topo toko liku nongo pe-pangi.’ ni.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aku niringi kinia Yesusini lombili andolimando nimbale: “Onone onono yomboma kere-langi mare liku siengi.” nirimu. Onone yundu ninguli: “Ya kere-langi awisili naa taltolemele. Pellawa kaloli kanga se-pakara kinia oma kaloli talo kinia, aku kere-langi pokore mindi lemó. Molo nuni ‘Olio kolea senga pungu i yombomanga kere-langi topo toko lindi-pangi.’ ningu nikinuye?” ningu mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Kanu yomboma koltalo mólo, ye paip tausini mele akuna moloringi.) Kanu-kinia Yesusini onondo nimbale: “Yombomando ‘ono towapu talo talo ningu mania molangi.’ niengi.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","onone aku siku yombomando niringi kinia yomboma pilku liku aku siku mania moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kanu-kinia Yesusini pellawa kaloli se-pakara kinia oma talo kinia kanuma lipale mulu-koleana olando sipa kanopa ⸤Pulu Yemo kinia⸥ “Ange.” nimba kere-langi akuma ambolopa pike lepa lombili andolima moke sepa sipale “Anju yomboma siee.” nirimu, ⸤onone yomboma moke seko siringi⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ono pali kanu kere-langima noringi kinia olo serimu. Pe lombili andolimane kere-langi kakena lierimuma liku maku toko wale-basikete engaki rurepo toko peke siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Walte, Yesusi yuyu Pulu Yemo kinia ungu nimba molorumu kinia yu lombili andoli ye pea moloringimando mangilipa nimbale: “Yombomane na imbi leko nawe nilimiliye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Onone yundu pundu toko ninguli: “Marene “Nu No Lindeli Jono ⸤kolorumu kanumu kelepa lomboropa ola molemomo⸥.” ningu pilielemele; marene “Nu, ⸤Pulu Yemone u konde molopili olando liltimu ye⸥ Illainja kelepa omba molemo.” ningu pilielemele; marene “Nu Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye se u kolorumu kanumu kelepa lomboropa ola molemo.” ningu pilielemele.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","⸤Aku niringi kinia⸥ yuni onondo mangilipa pilipa nimbale: “⸤We-yombomane aku siku nilimili⸥-na-kolo onone onono na nawe nilimiliye?” nimba mangilierimu. Pitane pundu topa nimbale: “Nu ⸤Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ u nimba taltorumu ye nokoli⸥ Karasimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitane aku nirimu pilipale Yesusini onondo tondolo mundupa nimbale: “Na molio mele ⸤Pitane kiniá nikimumu⸥ onone anju yombo selurindu kepe ⸤iseli-u⸥ paa naa ningu siee!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","⸤Nimbale⸥ yuni ⸤yu-kinia wendo ombá mele⸥ ono nimba sipa nimbale: “Mania Omba Mana-Ye Au Lierimu Yemo sika mindili awisili nombá. Juda yomboma nokolemele tapu-yema kinia, Pulu Yemo popo tondoli ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane sili yema kinia, onone ⸤ninguli: “Yu Pulu Yemone naa mundorumu. Yu Pulu Yemonga Malo naa molemo.” ningu⸥ yu liku bulu siku yu toko kondonge. Yu toko kondonge kolomba kinia wale talo omba pumbá kinia yopoko-sipamonga Pulu Yemone yundu ‘Lomboroko ola molou.’ nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kanu-kinia Yesusini akuna maku toko moloringimando pali nimbale: “Yombo sene ‘Yu lombili pambo.’ nimbale yuni alieli yunga konopumuni pilielemo mélemanga ‘Topo mania mundambo.’ nimba, yomboma unju-perana peko mindili nongo kololemele mele yuni unju-pera mele gomo lembando ‘Na yu lombili pumbúndu mindili nondu liemu peangala; kolondu liemu peangala.’ nimba na lombili opili. We naa opili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yombo sene yunga mana konde molopa naa kololi ulu-pulumu ambolomba sembá kinia yu kolopale sika molopa kinjipa mindi pumbá. Aku-sipa na-kolo yombo sene na konopu mondopale nanga kongonomo “Sendambo.” nimba sembá kinia yu kolopale yu konde molopa kondopa mindi puli ulu-pulumu sika kanopa limba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","⸤Akumu nambi semu-na nikiruye?⸥ Yombo sene mana-mélema pali yuyu lipa taltopale yu mini pali Pulu Yemo naa molomba koleana pumba mindili nomba molopa kinjilkanje kanu mélemane kanu yombomo nambi sepa lipa tapondolkanje? Lipa naa tapondolkamo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nanga yombo mare we-yomboma kinia molko ninguli: “Olio Yesusinga unguma pilipu lipu, yu lombili andopo molemolo mele we-yombomane naa piliangi.” ninguli, na kiyongo ningu lombili andolemele yomboma ono-kinia ulu se pe wendo ombá mele nimbu siembo: Mania Omba Mana-Ye Au Lierimu Yemo pe Lapanga tondolo pa sélimu kinia ⸤mulu-koleana⸥ angello kake selima kinia ⸤mania⸥ ombá sembá kinia, kanu we-yomboma molongena yunga yomboma mona molongendo we-yomboma molongena kanokole yu u naa opili ‘Olio yunga yomboma molemolo mele we-yombomane naa piliangi.’ ningu pipili kolko lopi seko molonge yomboma yuni lipa wekendo kanopa, “Na moliona naa waa.” nimbála.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nane onondo paa sika nimbu sikirumu: “Ono ya gilkimilimanga mare u kolou naa kolangi Pulu Yemo ye nokoli kingimu omba molopa kolea nokombando ombá kanonge.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusini ⸤yu lombili andolimando aku sipa nimba sirimu kinia⸥ pe koro se omba purumu kinia Pita keme, Jemisi keme, Jono keme, ono lipa memba pumba ‘Pulu Yemo kinia ungu niembo.’ nimba ma-pangina ola ono lipa memba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yuni akuna Pulu Yemo kinia ungu nimba molopili yunga kumbikeremo topele topa, yu pakorumu mulu-maminiama ena tondolo topa yombomanga mongo takele selemo mele aku sipa kake serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yu aku sipa molopili, ⸤Juda yombomanga koronga-u moloringili ye awili talo,⸥ Mosisi kinia Illainjatolo, ongo pa serimuna ongo gilkuli olo kinia Yesusi kinia onone Yesusi yu kolea-awili Jerusalleme akuna Pulu Yemone yundu ‘Sei.’ nirimu mele sepa kolomba mele ningu moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita kinia, yu pea akuna moloringi yetolo kinia, ono siye sepa uru ombá serimu-na-kolo pe ono makiliku umbu-konopu pepili molkole Yesusi yunga kangi topele topa molorumu mele kinia, yunga tondolo pa serimu mele kinia, yu-kinia gilieringili yetolo pea kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kanu-kinia aku yetolo pungilí puringili kinia Pitane Yesusindu nimbale: “Ye Nokolimu, olio ya molopomolo peanga lepomo. Olione ulka-takaya yopoko takondamili. Se nunga, se Mosisinga, se Illainjanga takondamili.” nirimu. (Aku-na-kolo aku nirimumu ⸤pipili paa kolopale⸥ yuni nimbá mele naa pilipa ungu se walu nirimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitane aku sipa nimba molopili kupa se omba ono aki torumu. Kupana sukundu puringi kinia ono pipili serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kupa torumuna sukundu ungu se wendo omba nimbándo: “I yemo nanga Malomo. Nane ⸤ ‘Ononga’ nimbu⸥ yu nimbu taltopo lipu mundorundu. Yuni ungu nimbáma pilku liengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aku ungumu nimba kelierimu kinia Yesusi yu mindi molorumu kanoringi. Onone aku siku kanoringi mele anju naa ningu para siku, yombo seluri kepe u naa ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Opali, orili-u ⸤Yesusi kinia yu lombili andoli ye yopoko kinia⸥ ono ma-pangina maniando onge oringi kinia yombo awisili yu lingí oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oringi yombomanga ye sene Yesusindu nimbale: “Ungu Mane Sili Yemo, ‘Nanga kango nanamo, yu nanga kango selumu mindi, kondo kolko liku tapondani.’ nimbu mawa sekero. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yunga konopuna kuru se pelemomone yu lipa mindili sipa tolemo kinia kangomone kalli nimba, yu ámu topa apoupu memba molemo. Yu aku sipa alieli selemo-na kangomo yu kangima pange-mange selemóla. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nu lombili andolimando aku semanemo topo sipu onone kanu kurumu ‘Makorangi.’ nimbu mawa sendu-na-kolo ono manda naa sengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","⸤Aku nirimu kinia⸥ pilipale Yesusini ⸤yomboma iri topa⸥ nimbale: “Kiniá molemele yomboma ono ⸤ ‘Pulu Yemone uluma sika manda sembá.’ ningu⸥ kuru naa mondolemele. Ono konopu karaye sepa pepili molemele yomboma, na ono-kinia molopo, wale nambi sepo molopo mane sipu ulu mare lipu ora simbú kinia mimi siku pilingíye? ⸤Na ono-kinia siye sekemo.⸥” nimbale pe kanu yemondo nimbale: “Nunga kangomo na moliona mengo u.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Memba ombá orumu kinia kanu kurumuni kango kanumu topa lipa mania mundupale yu torumu kinia Yesusini kurumu iri topa kangomo sepa peanga sipale, yu peanga lierimu kinia lapa sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aku sipa serimu kanokole yomboma Pulu Yemonga tondolomo konopumane pilkuli mini-wale mundoringi. Yuni serimu mele ono pungu-pungu ningu mini-wale munduku molangi Yesusini yu lombili andolimando nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","I nikiru mele pilku kondayo. Mania Omba Mana-Ye Au Lierimu Yemo ⸤ka sikuli yu toko kondonge⸥ yema anju singí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aku-sipa na-kolo yuni nirimu ungumu pilku sundukuli ‘I ungumunga pulumu nambolkarenje, naa pilkimulu.’ niringi-na-kolo “Nambolka ningu nikinuye?” ningu mangilku pilingindu pipili kolko naa mangilieringi. Pulu Yemone ‘Ono kanu ungumunga pulumu iseli-u naa piliangi.’ nimba serimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","⸤Walte Yesusi lombili andolimane⸥ ono onono anju yando angelema ningu ninguli: “Olionga ye nawe paa olandopa molemoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Onone konopu lieringi mele pilipale, Yesusi bolango kanga se lipa yu molorumuna nondopa mondopa ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","onondo nimbale: “Yombo sene ‘Na Ye-Awilimunga yombomo molio.’ nimba i bolangomo lipa tapondomba kinia kanu yombomone aku sembamonga na lipa tapondombala. Kanu-kinia na lipa tapondomba yombomone na lipa mundorumu yemo lipa tapondombala. Ononga ye sene ‘Nanga imbimu ola naa molopili.’ nimba, ‘Ye senga lupa imbimu ola molopili.’ nilimú yemo yu ononga paa olandopa molombamonga ⸤aku sipa ulumu pemba⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yesusi lombili andoli ye Jonone Yesusindu nimbale: “Ye Nokolimu, olio kanomulu, ye sene nunga imbimu lepa kuru mare yombomanga konopumanga molongima “Ongo wendo paa.” nimba topa makoropa molomu kanomulu. Kanopole yu olio pea kopu sepo naa molemolo kene yundu “Nu aku siku naa sei.” nímulu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aku nirimu kinia pilipale Yesusini yundu ⸤kanu yemone serimu ungumundu⸥ nimbale: “Yombo se olio-kinia opa-tou naa molemo yombomo olionga opa-geramemo molemo kene onone yundu “Mólo.” naa niengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kanu-kinia Yesusi kolea-awili Jerusalleme yu kolopale pe mulu-koleana olando pumbá walemo nondopa wendo orumu pilipale konopu tondolo mundupa ‘Jerusallemendo pambo.’ nimbale pumbá purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yu lombili andoli ye mare lipa mundupa nimbale: “Kiniá ipulieli kolea Sameria lierimu taono se nondopa lembana peamili kene ono akuna pungu olio manda pemolo ulka se koroko liengi.” nirimu kinia pungu kororingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aku-sipa na-kolo kanu Sameria yomboma ⸤ono kinia Isirele yomboma kinia anju yando konopu kiri panjiku moloringimunga⸥ yu Jerusallemendo pumbá purumu kanokole onone “Mólo, ya manda naa penge.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aku siku niringi kanokole yu lombili andoli ye Jemisi kinia Jonotolone yundu ninguli: “Ye-Awilimu, ‘oltone ‘Mulu-koleana sepe wendo omba i Sameria yomboma nomba kondopili.’ niembili.’ konopu lekenoye?” ningu mangilieringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aku-na-kolo yu topele topa olo kanopa iri topa “Aku ningu kinjikimbili.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yu kinia ono kinia kolea senga pungu pe-poringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ono aulkana pungí puringi kinia ye se omba Yesusindu nimbale: “Nu puni koleamanga pali nu lombili ombó.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusini yundu nimbale: “Pílie! Owá-palakoma ulka pelemelemanga pelemele; kerama ononga ulka takolemelemanga pelemele; aku-na-kolo Mania Omba Mana-Ye Au Lierimu Yemonga pelemo kolea se naa lemó ⸤kene, nu ‘Yu lombili pumbuli manda naa molombo.’ ningu pilkuli na lombili wani. We naa wani.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kanu-kinia yuni ye sendo nimbale: “Na pea pambili lombili ou.” nirimu kinia kanu yemone yundu pundu topa nimbale: “Ye-Awilimu, ⸤nu kamu lombili wambo mangali⸥ u pumbu nanga lapamo-kinia pea molambo. Pe yu kolomba kinia óno sepole nu lombili ombó.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aku-sipa na-kolo Yesusini yundu ungu-iku topa kelepa nimbale: “⸤Nanga ungumu naa pilku⸥ yombo kololi yombomane yombo kolongema óno sangi. Nu ‘Pulu Yemo omba ye nokoli kingimu molopa yomboma nokomba semane peangamo yomboma piliangi.’ ningu toko siliku andani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kanu-kinia ye sene yundu nimbale: “Ye-Awilimu, nu lombili ombó-na-kolo u pumbu nanga yomboma kondo kolopo ‘Molaa.’ nimbuli pe nu lombili ombó.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesusini yundu nimbale: “Na ‘Lombili ombó.’ nimba ombale nondopa siye kolomba yombo se yu Pulu Yemo ye nokoli kingimu molopa nokomba koleamonga kongonomo manda naa sembá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kanu-kinia Yesusi kolea-awili Jerusallemendo pumbá pumbale nirimumuni, yu pumbá purumu kolea marenga ye pokore kumbi lepa lipa mundorumu. Yuni ye towapu yopoko nimba taltopa ye talo talo nimba lipa mundupale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ono ungu-iku mele topa nimbale: “Kaliana kere-langi awisili nou lepa pelemo-na-kolo kanu kere-langima pungu liku taltonge yomboma koltalo kene Kalia Pulu Yemone ‘Kanu kere-langima liku taltoli kongonomo pungu senge yomboma kaliana lipa mundopili.’ ningu mawa sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ono lipu mundukuru yema ono sipisipi melema, yombo owá-palako awili kirimane sipisipi topa nolemo mele yomboma molemelena lipu mundukuru. ⸤Nanga ungumu andoko ningu singí kinia pilku kiri pilkuli yombomane ono mindili liku singí.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Punguli, wale-tapi kepe, kou-mone kepe, méle-wale kepe, kimbu-su topele toko mondongema kepe naa mengo we pangi. Aulkana punguli yomboma kanoko onondo ungu se naa ningu we pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kolea senga sukundu punguli akuna molongendo ulka seluringa pungu pe-punguli u kanu ulka pulu yombomando ninguli: “Ono konopu peanga pepili molangi.” niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aku ningí kinia kanu ulkana ‘Konopu peanga pepili molambo.’ ’ nimbá yombo se molomu liemu yu konopu peanga pepili molomba. Molo aku ningí kinia kanu ulkana ‘Konopu peanga pepili molambo.’ nimbá yombo se naa molomu liemu ono akuna ‘Pangi.’ nimbu mundukuru yema onono konopu peanga pepa umbuna se naa sepili molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kongono selemo yemo yu méle papu kalolemele kene pungí ulkana peke, ulka pulu yemone kere-langi simbama nangi. Ulka pinia-pinia naa andoko, ulka seluna mindi kere-langi nongo peangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kolea senga sukundu punguli ningímuni, kanu kolea pulu yombomane onondo “Papu ongi. Olio pea molamili waa.” níngi liemu ono kere-langi singíma nongo, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","akuna kuru tomba yomboma seko peanga siku, onondo ninguli: “Pulu Yemo omba ye nokoli kingimu molopa olio nokomba walemo ono molemelena nondopa ombá.” niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Molo kolea senga sukundu punguli kanu kolea pulu yombomane onondo “Ono nambi semu-na ongiye?” ningu, “Pea peamili waa.” naa níngi liemu ⸤kanu koleamo munduku kelko pungíndu⸥ aulkana pungu gilkuli yombomando ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Onone olio liku bulu síngimunga ‘Ono kamu molko kinjangi! Pulu Yemone ono lipa naa tapondomba mele paa piliangi.’ nimbu, olionga kimbuna ya koleamonga ma gilkimuma kepe kulu topole pukumulu.” niengi. ‘Akumu piliangi.’ ningu aku siku ninguli pe ungu se pea onondo kamu ninguli: “⸤Ono liepi-liepi tamili piliangi.⸥ Pulu Yemo omba ye nokoli kingimu molopa yomboma nokomba walemo nondopa ombá.” niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nane onondo paa sika nimbu sikirumu: “Kote walemo wendo ombá kinia kolea-awili Sodomo ⸤yomboma u ulu-pulu-kiri awisili sika seringi-na-kolo⸥ ononga kote kanga mele pemba. Aku-sipa na-kolo i yombo ⸤onondo “Pea molamili waa.” ni naa ningu, ononga ungu pilku naa lingí yomboma,⸥ kote walemo wendo ombá kinia ononga kote awili mele pemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kolea Korasini kinia Besaida taonotolo ⸤akuna molemele yomboma⸥ mindili nongo paa molko kinjingí. Kanu koleatolonga sukundu ulu-tondolo awisili serindu ⸤-na-kolo akuna molemele yomboma konopu topele naa tolemele⸥. Kolea-awili Taya kinia Saidonotolonga sukundu ulu-tondolo naa serindu-na-kolo kanu koleatolonga sukundu nane ulu-tondolo aku sipu selka kanolemolánje kanu koleatolonga ⸤yombomane⸥ ono ulu-pulu-kiri selemelema koronga munduku kelko, bulu siku, konopu topele tolemolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","⸤Akumunga⸥ kote walemo wendo ombá kinia kanu kolea-awili Taya kinia Saidonotolonga ⸤yomboma ulu-pulu-kiri sika selemelemonga⸥ ononga kote kanga mele pemba. Aku-na-kolo ono kolea Korasini kinia Besaidatolonga ⸤yomboma⸥ ⸤na ulu-tondoloma serindu kinia kanokole konopu topele naa toringimunga⸥ kote walemo wendo ombá kinia ononga kote awili mele pemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapeniame taono ⸤yomboma onone⸥ ‘Mulu-koleana pumbu molamili.’ konopu lekemeleye? Aku manda mólo. ⸤Onone nanga unguma alieli pilielemele-na-kolo konopu topele naa tolemelemonga⸥ ono kolea kirina pungu molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","⸤Aku nimbale yuni lipa mundumba serimu yemando ungu se pea nimbale:⸥ “Onone ungu ningíma pilipa limba yombomone nane ungu niliu ungumu pilipa limbala. Onone ungu ningíma naa pilipa ‘Olio pea molamili.’ naa nimba sembá yombomone na-kinia ‘Pea naa molambili.’ nimbála. Nando ‘Pea naa molambili.’ nimbá yombomone na ma-koleana lipa mundorumu ye kanumundu ‘Pea naa molambili.’ nimbála.” nirimu. Yesusini aku nimba pora sipale ‘Yunga kongonomo sende-pangi.’ nimba ono lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","⸤Walte⸥ Yesusini lipa mundorumu ye towapu yopoko yu molorumuna paa konopu siku yando ongole onone yundu ninguli: “Ye-Awilimu, olione nunga imbi lepole kuruma kepe olione ungu nirimuluma pilku liku seringi.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesusini onondo nimbale: “Aku siku selko andoringi kinia ⸤kurumanga nokoli⸥ Setene kariapá mele sepa, topa mania mundorumu nane kanorundu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Piliame! Ono tondolo se sirindu. Yombo nomba kondoli kongi-ka-wambiye molo kiriworo aku mélema ono naa kanoko kulungí kinia aku mélemane ono nanga yomboma ‘Unguri naa sepili.’ nimbu ono kanu tondolomo sirindu. Olio-kinia opa-tou ⸤Setene⸥ yu sika tondolo pulimú-na-kolo ono kanu tondolo sirindumunga yuni ono unguri manda naa sembá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aku-na-kolo aku sipu nikirumunga konopu naa siku, kuruma ononga ungumu pilku liku selemelemonga konopu naa siku; ⸤Pulu Yemone⸥ mulu-koleana ⸤molopa⸥ ononga imbima topa mondorumumunga konopu siku molangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yesusini Pulu Yemonga Mini Kake Sélimu kinia konopu awili-sepa sipale Pulu Yemondo nimbale: “Tata, Mulu Matolo Kinia Nokoko Moleno Ye Nokolimu, nane nu-kinia “Ange.” nikiru. ‘Olio pilipa kondoli pelemo. Olio oliolio ungumanga puluma pali pilipu kondolemolo.’ ningu pilielemele yomboma ono nane selio ulumanga pulumu ‘Naa piliangi.’ ningu naa ningu sirinu. Yombo bolango pame ⸤mele⸥ molko, nane niliu unguma komu sendeko molemele yomboma mindi nane selio ulumanga pulumu ‘Piliangi.’ ningu, ono ningu sirinu kanumunga nu kape nimbu “Peanga serinu.” nikiru. Sika Tata, nuni ‘aku sipa wendo ombá kinia konopu simbú.’ ningu aku siku serinumunga ⸤aku sipa wendo okomo.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","⸤Pulu Yemondo aku sipa nimbale kelepa yombo moloringimando nimbale:⸥ “Mélema pali Tatane na sirimu. Yombo sene Malo paa sika molemo mele pilipa kanopa imbi silimú yombo se mólo; Lapane mindi yu kanopa imbi silimú. Yombo sene Lapa paa sika molemo mele pilipa kanopa imbi silimú yombo se mólo. Malone mindi kanopa imbi silimú; Malone ‘Lapa lipu ora siembo.’ nimbá yomboma ono Lapa kanoko imbi singíla.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kanu-kinia yu lombili andoli yema ono onono moloringina pumba ‘Ono mindi piliangi.’ nimba onondo nimbale: “Ono mongone kanolemele mélema kinia uluma kinia kanolemele yomboma ono Pulu Yemone “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nane onondo paa sika nimbu sikirumu: “U moloringi yomboma, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema kinia, ye nokoli kingima kinia, kanu yombo awisili kiniá ono mongone kanoko molemele mélema kinia uluma kinia kanongendo “Kanamola!” ningu moloringi-na-kolo naa kanoringi. Ono kiniá komuni pilku molemele mélema pilingindu “Piliámola!” ningu moloringi-na-kolo naa pilieringi.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pulu Yemonga ungu-manemanga puluma pilipa kondorumu ye sene ‘Yuni nimba kinjimbanje manda manjipu piliambo.’ nimba Yesusindu mangilipa pilipa nimbale: “Ungu Mane Sili Yemo, na nambi sembó kinia konde molopo kondopo mindi puli ulu-pulumu limbuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesusini yundu nimbale: “Pulu Yemonga ungu-manema Mosisini bokuna torumu bokuna kanokole nambolka nimba molemo kanolenoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yemone pundu topa nimbale: “Pulu Yemonga ungu-manemane nimbale: ‘Onone ononga kamelema kinia, ononga minima kinia, ononga tondoloma kinia, ononga pilipa kondolima kinia, akumane Ye-Awili Yawe ononga Pulu Yemo manjiku tondolo munduku konopu mondangi.’ nimba pepa, ‘Onone onono yu-mele-mele konopu mondoko ononga kangimu onono kondo kolko nokolemele mele aku sikula pulu lemó yomboma konopu mondoko nokoko molangi.’ nimba pelemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusini yundu nimbale: “Nu paa sika nikinumu. Nu aku siku senu liemu molopa mindi puli aulkana puni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aku-na-kolo Pulu Yemonga ungumanga puluma pilipa yomboma mane sili yemone ‘Yombomane ‘Na paa pilielemo yemo’ ningu piliangi.’ nimba kelepa nimbale: “Nanga pulu lemó yomboma namele?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesusini ungu se pundu topa nimbale: “Juda ye se kolea-awili Jerusalleme mundupa kelepa kolea-awili Jeriko pumbá purumu kinia wa noli yema ongo yunga mulu-maminia toroko kulku liku yu toko taltoko ono puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kanu-kinia Pulu Yemo popo tondoli ye se kanu aulkamonga maniando pumbá pumbale nirimumuni, yemo aulkana lierimumu omba kanopale yu lierimuna siye kolopa aulka kiririma ekendonga omba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pe aku sipala Pulu Yemonga kongono sendeli talape LLipai ye se yemo toko taltoringina omba kanopale yu liepili siye kolopa aulka kiririma ekendonga omba yu purumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aku-sipa na-kolo Sameria ye se kanu aulkana pumbá ombale yemo lierimuna omba kanopale yu kondo kolopa, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","lierimuna nondopa pumba kangi toringimanga wambola kinia no-waene kinia ondopa kandondopale banisini ka tondopale nirimumuni, pe yuni yu kangulupa ola lipa yunga kongi-dongi bulu-mingina ola taltopa memba pumbale yombo ponenge ongo pe-pu-pu seringi ulka senga memba pumba taltopa nokopa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Peringili kinia ipulieli-u yu pumbá sepale nirimumuni, kou paip kina mele wendo lipa ulka pulu yemo sipa nimbale: “Yu nokoko kondoyo. Pe i sikiru koumu manda naa sepa nunga kou mare olandopa pumu liemu pe kelepo yando ombole nunga kou pundu tombo.” nimba Sameria yemone nirimu.” ⸤nimba Yesusini aku nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","⸤Aku nimba Yesusini kelepa nimbale⸥ “I ye yopoko ongo puringimanga ye wa nolimane toko taltoringi yemonga pulu lierimu yemo nawe? ⸤Juda ye u-pulu-pulu ongo kanoko we ongo puringili yetolonga se molo Juda yomboma-kinia anju yando konopu kiri panjilimili yombomanga ye akilepa orumu yemoye⸥?” nimba mangilipa pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pulu Yemonga ungumanga puluma pilipa yomboma mane sili yemo yuni nimbale: “Yemone yu we kondo kolorumu yemo lémo.” nirimu. Kanu-kinia Yesusini yundu nimbale: “Nu pungu aku siku se-pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kanu-kinia Yesusi kinia yu lombili andolima kinia ono ongo punguli kolea senga pumba ambo Mata yunga ulkana “Pea molamili ou.” nirimu kinia yu akuna purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata yunga genu Maria molopale yu Yesusini ungu peanga nilimú nimbámo ‘Piliambo.’ nimba Yesusi molorumuna omba nondopa mania molopale nirimumuni, Yesusi ungu nimba molorumu mele yu pilipa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Aku-sipa na-kolo Mata yuyu kere-langi kalondopa, kongono sepa molopale yu kongono takaraki lierimu-kulu kanu kongonomo mindi pilipale Yesusi molorumuna pumba nimbale: “Ye-Awilimu, nanga genu na lipa naa tapondokomo-na na nanu mindi kere-langi simbundu kongono sepo molkoro kanokole kondo naa sekemoye? Yuni na ‘Omba lipa tapondopili.’ ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Aku nirimu kinia pilipale Yesusini yundu pundu topa nimbale: “Ambo Mata, ulu awisili mele nu konopu awisili kimbu siku konopu umbuna sepili moleno-na-kolo ulu selu mindi nu naa pilku seleno. Kanu ulu peangamo Mariane ‘Sambo.’ nimbale ⸤nanga ungumu pilipa⸥ molemo. Kanu ulu peangamo yuni naa sembá aulka se mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Walte, kolea senga, Yesusi yu Pulu Yemo kinia ungu nimba molopale pe nimba pora sirimu kinia yu lombili andoringi ye sene yundu nimbale: “Ye-Awilimu, olio Pulu Yemo kinia ungu nimulú mele mane sieni. ⸤No Lindeli⸥ Jono yu lombili andoringi yema mane sirimu mele olio aku siku mane sieni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","⸤Aku sipa nirimu kinia pilipale⸥ Yesusini onondo nimbale: “Ono Pulu Yemo kinia ungu ningíndu i-siku mele niengi: “Tata, yombomane ‘Nu imbi ola molopa, ye kake seli peangamo moleno.’ ningu molangi. Nu ye nokoli kingimu molko yomboma nokoni walemo wendo opili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kiniá kepe pe alieli kepe olio nomolo kere-langima siyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yombomane olio seko kinjilimili kinia siye kolopo ungu se naa selemolo kene olione nu sepo kinjilimulu kinia nuni aku sikula siye kolko olio ungu se naa seyo. Olio ‘Ulu sene kondi topili.’ naa nieni.” ningu aku siku niengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aku nimba pe onondo ungu se pea nimbale: “Nu nunga pulu lemó yombo se paa ipulieli awi-amburumi molombana pungu yundu ninguli: “Ano, ga mare siyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ye ponenge se kolea senga pumbándo nanga ulkana pemba okomo-na-kolo na ga se naa lemó kene nuni na ga mare si.” nilina kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yuni nundu nimbale: “Nuni na umbuna se aku siku naa si.” nilka. “Bolangoma kinia u ulka-kuna sipu uru pemulu kene na ola molopo wendo ombo mélse nu manda naa simbú, mólo.” nilka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nane onondo nimbu sikiru: “Yu gena molemomonga ola molopa ga naa silka-na-kolo nuni yu kimbu-kimbu siku mawa selinamonga yu siye kolopa wendo omba ga silka.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aku selkamonga ono ⸤nanga lombili andolima⸥ndo ungu se pea nikirula: “⸤Lapa, Mulu-Koleana Molemo Yemo,⸥ mélema mawa seko “Si.” niengi. Aku senge kinia mélema sika simba lingí. ⸤Lapa molemona⸥ mélema korangi. Aku senge kinia mélema sika kanoko lingí. Ulka-kerepuluna gilku “Sukundu wamili.” niengi. Aku ningí kinia “Sukundu waa.” nimba ulka-kuna lindimba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mawa senge mélema sika simba lingí, koronge mélema sika kanoko lingí, “Sukundu wamili.” ningí kinia sika ulka-kuna lindimba. Aku sembá kene aku saa.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ononga ye se yunga malo ombale “Tata, oma se nambo si.” nimbá kinia yunga lapane wambiye se simbaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Molo kangomone “Tata, kera-mulu se nambo si.” nimbá kinia yunga lapane kiriworo molo makena se lipa simbaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe ono kiri-kiri molemele yombomane aku siku ononga bolangoma méle peangama silimili liemu, ononga mulu-koleana molemo Lapamone ⸤méle paa olandopa simbamo.⸥ Yombomane yundu “Mini Kake Sélimu olionga konopuna omba pepili si.” ningu mawa senge yomboma yuni ono simba lingí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Walte ye se yunga konopuna kuru se molorumu-na ungu manda naa nirimu kinia Yesusini kanu kurumu makoromba makororumu. Kurumu wendo omba ultu purumu kinia kanu yemo ungu nirimu. Aku serimu kanokole yombomane mini-wale munduku moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aku-sipa na-kolo yombo mare ⸤Yesusi-kinia konopu kiri panjeringi⸥ kanumane ninguli: “Kurumanga nokoli Belsipuli Yesusinga konopuna molopale yu tondolo silimú-na yuni kuruma topa makorolemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yombo marene Yesusi manda manjiku “Nambolka nimbánje.” ningu yundu ninguli: “Nu sika Pulu Yemone ‘Kongono sendani.’ nimba lipa mundorumunje kanamili, mulu-koleana ⸤Pulu Yemone mindi manda sembá⸥ ulu-tondolo se sei.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Onone aku siku konopumane pilieringi mele Yesusini pilipale ‘⸤Yesusi Setene-kinia opa-tou moloringilimunga Setenene yu naa lipa tapondolka mele paa piliangi.’ nimba⸥ onondo nimbale: “Yombo talape se konopu seluna naa pupili molko suku-singina ówa panjiku ono onono opa seko lupa lupa molemele kinia kanu talapemo pora nilimú. ⸤Molo⸥ ulka seluna pelemele yomboma konopu seluna pupili naa molko ono onono opa selemele kinia kanu yombo talapemo sungu siku lupa lupa molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aku sipala, Setenene yunga kuru se makorolkanje aku selkamonga yunga talapemo kinia opa mele selka. Pe yunga talapemo nambi sepa manda molemoláye? ⸤Pora nilka.⸥ Onone nando “Belsipulini yu lipa tapondolemo-na yuni kuruma makorolemo.” nikimili kanumu. Sika aku selkanje Belsipuli yunga talapemo pora nilka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ungu se piliangila. Nane Belsipulinga tondolomone kuruma makorolio liemu ononga yemane nawenga tondolomone kuruma makorolemeleye? Akumunga, ⸤ononga ye kuruma makorolemele yemane ‘Pulu Yemone olio tondolo silimú-na olione kuruma makorolemolo.’ ningu pilielemele-na⸥ onone nando i nikimili unguma kanu yemane pilku apurukuli “Ono kolo tokomele.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aku-sipa na-kolo sika Pulu Yemone na tondolo silimú-na nane kuruma makorondu liemu Pulu Yemo ye nokoli kingimu molomba walemo ono molemelena koronga wendo omu.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ye enge nili sene opa mélema ambolopa yunga ulkamo nokopa kondolemo kinia ye sene we manda sukundu omba mélema wa naa limú. Yunga ulka lemó mélema manda lemó. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kanu ulka nokolemo pulu yemone ‘Nanga opa mélema ambolopole nanga mélema manda nokopo kondombo.’ nilimú-na-kolo yunga opa-tou ye se tondolo olandopa pulimúmu omba yu tomba sepale opa-toumuni ulka nokolemo yemo topa mania mundupa yu ambololemo opa mélema anju lipa, yunga ulkana lemó mélema lipa memba pumba yunga pulu lemó yomboma moke sepa silimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Na naa lipa tapondolemo yombomone na-kinia opa-tou molemo. Yombo sene na lipa tapondopa ⸤kongi sipisipima⸥ sukundu naa limú yombomone ⸤kongi sipisipima⸥ topa bulu-balu silimú.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","⸤Yesusini ungu se pea nimbale:⸥ “Kuru se ye senga konopuna wendo ombale, no naa mololi koleamanga pumba manda koro molomba kolea-kolo se korolemo. Se naa kanopa lendepa yuni nimbale: ‘Na u molopole wendo ondu ulkana kelepo pambo.’ nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aku nimbale yu omba yu u molopa purumu ulkamo kanolemo kinia, ulka pole lepa sepa peanga sepa we lemó kinia kanopale nilimúmuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yu kelepa anju pumbale, kuru kara puli paa olandopa yopoko-pakara lipa memba omba ono pea kanu ulkana sukundu pungu molemele. Kanu-kinia kanu yemo u molopa kinjilimú-na-kolo pe paa kamu olandopa mele molopa kinjilimú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusini aku sipa nimba molopili maku toko moloringina ambo sene ungu tondolo sepa nimbale: “Nu paa seko kondolenomonga ambo nu memba ame sirimumu yu Pulu Yemone “Konopu peanga pepili molko kondangi.” nilimú aulkana molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesusini nimbale: “Sika na-kolo yombo Pulu Yemonga ungumu pilku liku seko molemele yomboma ono Pulu Yemone paa olandopa “Konopu peanga pepili molko kondangi.” nilimú aulkana molemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesusi molorumuna yombo awisili sukundu sukundu ongo liku maku toringi kinia yuni onondo nimbale: “Kiniá mana molemele yomboma yombo-kirima mindi molemele. Ono seko kinjiku Pulu Yemo liku bulu silimili yombomane “Na molopo niliu mele sikanje, kanamili kene Pulu Yemone mindi ulu-tondoloma manda selemo mele sei.” ningu na mawa selemele. Aku-sipa na-kolo ⸤na Pulu Yemo kinia kopu sepo kongono selembolo mele lipa ora simba ulu⸥ se wendo naa ombá. ⸤Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye⸥ Jona-kinia wendo orumu ulu akumuni mindi lipa ora silimú manda kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona-kinia ⸤oma awili se-kinia⸥ ulu-tondolo se wendo orumu ulumuni Ninipa yomboma-⸤kinia ulu umbuna se wendo ombá mele⸥ lipa ora sirimu aku sipa mele Mania Omba Mana-Ye Au Lierimu Yemo-kinia ulu-tondolo se wendo ombá ulumuni kiniá molemele yomboma-kinia ulu se pe wendo ombá mele lipa ora simba. ⸤Lipa ora simba ulu se lupa wendo naa ombá, naa kanonge.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“U kolea-awili Ninipa yomboma ⸤sika molko kinjeringi-na-kolo Pulu Yemone ungu-umbu tondorumu mele⸥ Jonane ⸤pilipa⸥ pumba Ninipa yomboma nimba sirimu kinia pilkuli seko kinjeringi mele kanoko kiri pilku konopu topele toko molko kondoringi. Aku seringimunga kiniá molemele yombomane Jonanga olandopa ye se ya molemo yemonga ungumu pilku mokoli seko naa pilielemelemonga kote walemo pe wendo ombá kinia Ninipa yombomane kotena gilku, kiniá molemele yombomando “Seko kinjeringi. Mindili nonge kinia papu.” ningí. “U ⸤olio Isirele yombomanga ye nokoli kingi⸥ Sollomono yu ye paa tondolo se molopa, yu ungu lupa lupama pilipa kondolimu pepili molorumu mele kolea Sipa nokorumu ambo nokoli kuwinimu pilipale, Sollomonone ungu peangama mindi nirimu mele pilimbando yu kolea suluna molopale ⸤Sollomono molorumuna⸥ wale awisili aulkana pelepa orumu. Aku sipa serimumunga, ye nokoli Sollomononga olandopa ya molemo yemone nilimú ungumu kiniá mana molemele yombomane naa pilku, mokoli selemelemonga kote walemo wendo ombá kinia kolea Sipa ambo nokoli kuwinimuni nimbale: “Nane Sollomonone ungu peanga nirimu mele pilimbundu aulka suluna orundu-na-kolo Sollomononga olandopa molorumu yemone nirimu ungumu ono naa pilku, mokoli seringi yomboma aku seringimunga ono papu mindili nonge.” nimbá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","⸤Aku nimbale Yesusini ungu se pea nimbale:⸥ “Yombomane sepe-llame kandokole loyakolona naa taltoko, mingina sukundu naa taltokole nilimilimuni, ‘Ulkana sukundu pa sepili. Yombo ongema kolea kanangi.’ ningu polona ola taltolemele.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nunga mongomo nunga kangimunga sepe-llame mélemo. Aku kene nunga mongo peanga gilimú kinia nu kangi pali pa sepili moleno kinia nu molko kondoleno. Aku-sipa na-kolo nunga mongomo kiri lemba kinia nunga kangi pali simbulu topili andoni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akumunga, nunga kangina pa seli pembamo ‘topele topa simbulu naa topili.’ ningu ⸤kangi pa sepili molemo mele molko kondoyo⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nunga kangina pa sepa sengepea sepili molko simbulu selu kepe naa topili moloni kinia nunga kangi konopuma pali pa sepili moloni. Sepe-llame pa selemo kanolemolo mele nunga kangi konoputolo pa sepili moloni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusini ungumu nimba pora sirimu kinia kanu Parisi yemanga sene Yesusindu nimbale: “Kere-langi pea nambili ou.” nimbale yu-kinia pumba kere-langi nombando mania molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aku-sipa na-kolo yu u ki kulumiye naa topale ga we norumu kanopale kanu Parisi yemone konopu awisili kimbu sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesusini ⸤yu konopu kimbu sirimu mele⸥ pilipale ⸤ungu-iku mele topa⸥ yundu nimbale: “Ono Parisi yema pellete kinia kapo kinia ultukundu kulumiye tolemele-na-kolo akumunga sukundu, ononga konopumanga sukundu mele, kalaro awisili molemo. Ulu-pulu-kirima kinia, mélema wa limili ulu-pulumu kinia akuna pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ono paa aroma tolemele. Kangi serimu yemone konopumu pea naa serimuye? ⸤Peatolo serimu kene⸥ ono kangi no leko kake sepili molemele mele aku siku ononga konopu kake sepili molongi liemu peanga. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ono konopu topele tokole yombo koropama kondo kolko ononga taltolemele mélema singí kinia ononga konopu kalaro molemomo kolali sepa kake sepili molonge mele yombomane kanonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Parisi yema, ono mindili nongo paa molko kinjingí! Onone kaliana olemo mele kangama elkepa kulua kemu aku sipa mélema mengo kambu toko rureponga talo rureponga talo ningu liku taltokole selu selu ningu wendo liku ‘Pulu Yemonga kongono sendeli yema siemili.’ ningu silimili. Pulu Yemone aku siku ‘Saa.’ nirimu mele ono papu selemele-na-kolo ulu olandopa uluma naa selemele. We-yomboma kondo naa kolko, Pulu Yemone yomboma konopu mondolemo mele ono manda manjiku yomboma konopu naa mondolemele. Aku siku ulu olandopa mele selemolánje peanga. Kiniá ulu maniandopama selemele mele munduku naa kelkole aku uluma kinia ulu olandopama kinia peatolo selemolánje peanga. Aku-sipa na-kolo aku siku naa selemelemonga ono mindili nongo paa molko kinjingí! ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Parisi yema, ono Juda yomboma maku toko Pulu Yemonga ungumu pilielemele ulkana sukundu punguli mania molongendo ye awilima molemele polo peanga akuna ‘molamili.’ ningu mendo pungu polo akuna konopu siku molemele. Yomboma maku toko molemele koleamanga mongo-kenge seko andonge kinia ‘We-yombomane olio kanoko kape niengi.’ ningu pilkuli konopu siku pilku molemelela. Aku selemelemonga ono mindili nongo paa molko kinjingí! ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“⸤Parisi yema,⸥ ono yombo óno-kolea senga ‘Yombo inia óno selemele.’ ningu naa pilku walu siku kimbu kululimili mele ono aku siku molemelemonga mindili nongo paa molko kinjingí!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesusini aku sipa nirimu pilkuli Pulu Yemonga ungu-manemanga puluma pilipa kondorumu ye sene yundu nimbale: “Ungu Mane Sili Yemo, ‘Nuni Parisi yema aku siku iri tokonomonga olio kepe iri tokono.’ konopu lekemolo.” nirimu kinia pilipale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesusini kelepa ono ⸤iri topa⸥ nimbale: “Sika nikinu. Ono Pulu Yemonga ungu-manemanga puluma pilku kondoli yema mindili nongo paa molko kinjingíla! Onone ungu-mane siku ‘Saa.’ nilimili mele we-yomboma ono pilkuli sengendo umbuna kololemele. Aku siku umbuna awisili mindili siku menge mele ‘Meangi.’ ningu sikuli onone onono kanga-kolte kepe ‘Lipu tapondopo meamili.’ naa ningu molemelemonga ono ⸤kepe⸥ mindili nongo paa molko kinjingíla! ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“⸤Ono Pulu Yemonga ungu-manemanga puluma pilku kondoli yema,⸥ ononga anda-kolepalimane Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema toko kondoringi. Kiniá, yandopa, ono kanu yema óno seringi koleama au silimili. Anda-kolepalima onone kanu yema toko kondoringi pilku peanga pilkuli pe kiniá ono kanu yema ‘Papu toko kondoringi.’ ningu onone óno seringi koleama au silimilimunga ono mindili nongo paa molko kinjingí! ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“⸤U ononga anda-kolepalimane aku siku seringi, kiniá onone aku siku selemele⸥monga Pulu Yemo yuyu ungu pali pilipa kondoli yemone u nimbale: “Nane ye mare ungu-umbu tondopo ‘Onone yomboma ningu siengi.’ nimbu lipu mundupu, ye mare ‘Nanga kongonomo sende-paa.’ nimbu lipu mundumbu kinia yombomane mundumbu yemanga mare mindili siku, mare toko kondonge.” nimba Pulu Yemone nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","“Koro-u Pulu Yemone ma kokele sepa wamorumu kinia onone Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi ye kanuma toko kondoko, pe yandopa yandopa kanu sili yema pali toko kondoringi. Koro-u Atame malo Epele toko kondoko, pe yandopa yandopa kanu sili ye lupa lupama toko kondoleko pungu, pe kamu Pulu Yemone ungu-umbu tondorumu unguma pilipa yomboma nimba sirimu ye Sekaraya Pulu Yemo ⸤popo toko kaloli⸥ ulka-tembelena sukundu toko kondoringi. Kanuna sukundu suluminia kake sélimu anjukundu lepa, Pulu Yemo popo toko mélema kaloringi polomo yakondo lierimu, kanu suku-singina yu toko kondoringi. U moloringi yombomane kanu yema toko kondoringimunga Pulu Yemone ono sika “Mongo liltingi kene mindili nangi.” nirimu-na-kolo kiniá molemele yomboma ono Pulu Yemone kote pilipale anda-kolepalimane aku siku seringimunga ono “Mongo liltingi kene mindili nangi.” nimbála. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pulu Yemonga ungu-manemanga puluma pilku kondoli yema, onone ungu-manemanga puluma pilku kondolemele-na-kolo “We-yombomane naa piliangi.” ningu ono pilingí aulkamo pipi silimili. Ono Pulu Yemonga bokuna molemo ungumu alieli kanolemele-na-kolo apurukuli Pulu Yemone “‘Ye se ono nokopa kondopa lipa tapondopili.’ nimbu, nimbu taltopo lipu mundumbu.” nirimu yemondo nimba bokuna molemo unguma kanokole pilku sundulimili. Sumbi siku pilingí aulkamo ono naa pulimili; bokuna kanu yemondo nilimú unguma ‘Piliamili pamili.’ ningu molemele yombo lupama pilingí aulkamo “Mólo.” ningu pipi silimilila. Aku selemelemonga ono mindili nongo paa molko kinjingí!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesusini ⸤aku ungumu nimba pora sipale⸥ aku ulkamo mundupa kelepa pumbá purumu kinia yuni iri torumu ye Parisima kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia onone ‘Yu ungu nambolka ungu mare pea nimbale, yu ungu nimba kinjimba kinia yu kote sendemolo.’ ninguli onone ungu lupa lupa awisili popenge seko mangilku pilkuli “Pundu toko ni.” ningu tondolo munduku niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kanu-kinia Yesusi molorumuna yombo tausini awisili liku maku toko gilieringina ekelepa sepili gilieringi kinia yu lombili andoringimando u kumbi lepa nimbale: “Ono liepi-liepi topo, ‘Parisi yema pellawa akoli méle isi taltolemelemo kanoko kondaa.’ nikiru. Ononga isi taltolemele akumu onone ⸤ “Pulu Yemonga ulu peangama selemolo.” ningu⸥ kolo toko topele-mapele tolemele ulumu. ⸤ ‘Akumu manda manjiku naa sangi.’ ⸥ nimbu liepi-liepi tokoro. ⸤Parisi yemane sika seko kinjiku molemele mele kamu lopi manda naa senge.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aki tolemo ulumanga selu kepe pe aki naa topa pali mona lemba. Lopi selemo ulumanga selu kepe pe lopi naa sembá. Kanu uluma kinia unguma pali yombomane pali pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Simbulu tolina ungu niringima yombomane pa selina pilingí. Ulka suluminiana ungu ólo toko niringi unguma ulka imuna ola gilku ru ningu ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nanga pulu lemó yomboma, onondo ungu se nimbu siembo: “Kangimu mindi toko kondokole pe kelko minimu pea ulu se manda naa senge yomboma pipili naa kolangi.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aku-na-kolo ono paa pipili kolonge yemo nimbu siembo: “Kangi topa kondopale pe mini pali sepe-koleana manda topa mundumba ⸤Pulu Yemo⸥ yu pipili kolangi. Paa sika nimbu sikiru. Yu pipili kolangi.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kera kaltendepele paa kangamo molemo, topo toko lingíndu kera se-pakara kou kololi talo mindi pulimú kanumu. Aku-na-kolo Pulu Yemone kanu kerama nokombando komu naa silimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Piliame! Ono ⸤na lombili andolima⸥, ononga penge-indima kepe yuni koronga selu selu nimba pali kambu torumu. Kera kaltendepele yu kou paa koltalo mele pulimú-na-kolo kanu keramo Pulu Yemone kanopa molemo. Ono yomboma paa olandopa awilima kanopale ono paa nokopa kondopa molomba ⸤kene pipili naa kolaa.⸥” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nane onondo ungu se nimbu siembo: “Yombo sene yombomanga kumbikerena ola gilipa ‘Na Yesusinga yombomo molio.’ nimbá kinia pe Pulu Yemonga angellomanga kumbikerena Mania Omba Mana-Ye Au Lierimu Yemone ola gilipa “Kanu yombomo nanga yombo se.” nimbála. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aku-sipa na-kolo yombomanga kumbikerena “Yesusi yu nawe? Yu na naa pilkiru.” aku sipa nimbá yombomo pe Pulu Yemonga angellomanga kumbikerena Mania Omba Mana-Ye Au Lierimu Yemone “Aku yombomo yu nawe? Yu na naa pilkiru.” nimbála. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mania Omba Mana-Ye Au Lierimu Yemo ungu-taka tondopa ungu nimba kinjilimú yombomo aku sipa ulu-kiri selemoma ⸤Pulu Yemone⸥ ‘Mania pupili.’ nimba siye kolomba. Aku-sipa na-kolo Mini Kake Sélimu ungu-taka tondopa, ungu nimba kinjipa, yunga imbimu marake selemo yombomo aku sipa ulu-kiri selemomo ‘Mania pupili.’ naa nimba, paa siye naa kolomba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kanu-kinia pe ono ⸤nanga yomboma molonge kanokole⸥ ono ongo ka siku, ono maku toko Pulu Yemonga ungumu pilielemele ulkamanga ye awilima kinia, ye nokolima kinia, gapomano ye awilima kinia ono molongena ono mengo pungu kote sendenge kinia ‘Kotena nambolka unguri nimulúnje? Olio ungu se mangilku pilingí kinia nambolka unguri pundu topo nimulúnje?’ ningu mini-wale naa mundangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akuna Mini Kake Sélimuni onone anju ningí mele mane simba kene mini-wale naa mundangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesusi molorumuna liku maku toringi yombomanga ye sene yundu nimbale: “Ungu Mane Sili Yemo, nanga genumu kinia oltonga lapane sirimu monge-mélema yuni ‘Na mare moke sepa sipili.’ ni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aku-na-kolo Yesusini yundu pundu topa nimbale: “Yemo, ‘Nane ononga kote pilindiku ononga mélema moke sendei.’ nimba nawene na nimba taltorumuye? Yombo sene nando aku sipa naa nirimu kanumu. Nanga kongono se mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aku nimbale yuni onondo kelepa nimbale: “‘Méle awisili lipu taltopo kamako molambo.’ ni naa ningu, ‘Mélema lili ulu-pulumu yu ulu-pulu-kirimu kene aku naa sambo.’ konopu leko molangi. Yombo sene méle awisili lipa taltolemomonga mini pali konde molopa kondomba aulkamo naa lemó.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","⸤Aku nimbale Yesusini ‘Onondo nikiru ungumanga pulumu kamu piliangi.’ nimba⸥ yuni ungu-iku se topa nimbale: “Walte ye kamako se molopale yunga kaliana kere-langi paa awisili orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akumunga yuni yuyu nimbale: “Kere-langi taltolio ulkama pali sengepea semu, kere-langi awisili kakena lepa we lemó kene nane nambi samboye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pe kelepa yuni yuyu nimbale: “Kiniá na piliporo. Na i-sipu sambo. Na kere-langi taltolio ulkama sikisipuli kere-langi taltombo ulka paa awilima kelepo takopole akumanga nanga rasi-witi kinia kere-langi kinia nanga kaliana olemo kere-langima pali taltambo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Akuna taltopole na nanu pilipu nimbúndu: Na papu. Na kere-langi awisili, kalia awisili omba pumbá kinia nombo molombo mele lemó kene koro molopo, kongi nombo, no-waene nombo, konopu sipu molambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aku-sipa na-kolo Pulu Yemone kanu yemondo nimbale: “Ye aromamo. Kiniá ipulieli nane nunga minimu ombo limbu kinia nunga taltoleno mélema nawene limbaye?” nirimu.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","⸤Ungu-ikumu topa pora sipale ungu se pea nimbale:⸥ “Aku sipa mele, ‘Na méle kande-kandema taltolio.’ nilimili yomboma Pulu Yemone ono kanopale ono yombo koropa pulima nimba pilielemo. Pulu Yemo kanopa peanga pilielemo ulu-puluma naa seko molemele yomboma ononga minima koropa pupili mele molemele. Kanu yomboma ono aku ungu-iku tokoro yemo mele molemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","⸤We-yombomando⸥ aku sipa nimbale Yesusini yu lombili andolimando kelepa nimbale: “⸤Kolonge kinia mana-mélemane ono naa lipa tapondomba⸥ kene nane onondo ungu se nimbu siembo: ‘Kangikundu molopo kondamili.’ ningu konopu awisili kimbu naa siengi. Kere-langi nongemonga kepe no nongemonga kepe mulu-maminia pakongemonga kepe akumanga konopu awisili kimbu siku naa molangi. Ono manda molonge mele olandopa, kere-langi nonge mele maniandopa; ononga kangi yu olandopa mele, mulu-maminia pakonge maniandopa mele kene kere-langi nonge mele kinia, mulu-maminia pakonge mele kinia, konopu awisili kimbu naa siengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kerama kaname. Kere-langi se panjikuli nou lemó kinia liku mengo ulkando pungu taltoko naa nolemele-na-kolo Pulu Yemone kerama kere-langi silimú. Kerama we-méle, ono yomboma olandopamonga yuni ono paa nokomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ononga yombo sene konopu awisili kimbu simbamone yu kolomba ena se manda ‘We liepili.’ nimbáye? Manda naa nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Onone ulu kanga-kolte aku sipa mele se manda naa selemelemonga ulu wema ono nambi semu-na konopu awisili kimbu siku molemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pellawa sindima kaname. Pellawa sindimane kongono kála seko naa seko, mulu-maminia se seko naa wamolemele-na-kolo pellawa sindima molemele mele olandopa, ⸤ye nokoli kingi⸥ Sollomono kongono awisili sepale wale paa peangama pakopa au nirimu mele maniandopa. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Era sindi tolemoma kiniá-mele molemo, opali-mele poroko sepena kalolemelema Pulu Yemone aku sipa nokopa kondolemo liemu ono ‘Pulu Yemone olio manda nokombanje?’ ningu kanga-kolte mindi pilielemele yomboma pakonge mélemanga yuni manda lipa naa tapondombaye? Ono lipa tapondomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“⸤Pulu Yemone kerama kinia era sindima kinia aku we-mélema aku sipa nokolemo⸥ kene ono konopu awisili kimbu sikuli ‘Es, kere-langi se sena lipu nomolonje?’ ; molo ‘No sena kolopo nomolonje?’ ningu pilku naa molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pulu Yemonga yomboma naa molko ultukundu molemele yombomane aku siku selemele-na-kolo ononga Lapa ⸤Pulu Yemone⸥ ono yunga yombomanga méle mólo tolemoma kanopa molemo ⸤kene ono kere-langi nongemanga kinia méle pakongemanga kinia konopu awisili kimbu naa siengi⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","⸤Pulu Yemo⸥ ye nokoli kingimu molopa yomboma nokolemo uluma ‘Kumbi lepo sambo.’ konopu leko molangi. Aku senge kinia yuni we-mélema kepe ono simba.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nanga kongi sipisipi koltalo, ononga Lapa walte ye nokoli kingimu molopa yomboma nokomba kinia ‘Ono pea ye nokolima molko yomboma nokangi.’ nimbá. Yu aku sipa sembando konopu sipa molemomonga pipili kolko naa molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akumunga ono taltolemele mélema kou-mone liku aku kou-mone lingíma yombo koropama moke seko siengi. Aku siku sekole pe kou kamu mania naa puli koumu liku taltoko, méle kande-kandema liku mulu-koleana ⸤pe pungímunga⸥ taltoko sangi. Akuna wa lili yema ongo wa naa liku, koka molo lurinia melemane ongo seko kinjiku naa senge. Ono akuna taltonge mélema kamu manda lemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ononga taltolemele mélema lemó kolea akuna ono konopumane pilku konopu mondoko molemele kene ⸤ ‘mulu-koleana mindi mélema liepili.’ ningu molangi.” nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“⸤Na lombili andolima,⸥ onone ‘Ye-Awilimu kiniá ombánje.’ ningu mulu-maminia pakoko, kako toko, kiya kandoko, molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ye awili se kolea senga pumba, ye se ambo limba kere-langi koyolemele yomboma kinia anju kere-langi nomba molemo kinia yu kelepa ulkando ombámonga yunga kendemande-yombomane ‘Yu ombá.’ ningu ulka-kuna lindingindu nokoko molemele mele ono aku siku molangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kanu kendemande-yombomanga ye nokolimu omba yunga kendemande-yomboma kanopale, uru naa peko we molonge kanomba kendemande-yomboma ono konopu siku molonge. “Nane onondo paa sika nimbu sikirumu: “⸤Alieli kendemande-yombomane ononga ye-awilimu nokoko kere-langi kalondoko silimili mele yu aku siku nokolemolá-na-kolo kendemande-yombomanga⸥ ye-awilimuni ⸤kanu kendemande-yombo peangama konopu sipa⸥ yuni kongono-mulumbale pakopa onondo “Kere-langi noli polona molaa.” nimba ‘Kere-langi nangi.’ nimba ononga kongonomo sendepa ono nokomba.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ipulieli awi-amburumi ombáne, kera gulta ko tomba kinia ombánje, ono uru naa peko nokoko molongi kanomu liemu ono konopu siku molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","I ungumu konopu kimbu siku piliayo. Ulka pulu ye sene wa noli ye se yunga ulkamo omba bultupa mélema wa limba enamo pilkanje ‘Wa noli yemo ombá.’ nimba nokopa molka kinia wa noli yemo yu manda sukundu naa olka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aku siku ono nokoko molaa. Mania Omba Mana-Ye Au Lierimu Yemo ombá enamo naa pilielemele kene ‘Yu sika ombá.’ ningu aku siku nokoko molangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitane yundu nimbale: “Ye-Awilimu, aku ungu-iku toko ningu sikinumu olio ⸤nunga lombili andolimando manjiku⸥ ningu sikinu molo yombo wemando pea ningu sikinuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ye-Awili ⸤Yesusini⸥ pundu topa nimbale: “Kongono sendeli kendemande-yombo nawene kongono sepa kondondolemo kinia kanopale yunga ye awilimuni ‘Yuni kongono siliuma sumbi sipa selemomonga yu kongono simbú kinia sepa kondombamonga na kelepo konopu kimbu sipu naa molombo.’ nilimúye? Kendemande-yombo se aku sipa mele sepa kondopa molemomo kanopale yunga ye awilimuni yu nimba taltopa yundu nimbale: “Nuni kongono sendeli kendemande-yomboma pali nokondoko ononga kere-langi nongema ena wa siliumunga ono nangi moke seko sieni, nokondoko molou.” nimba ⸤yu senga pulimú⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pe ye awilimuni kongono simumu kanu kongono sendeli kendemande-yombomone mimi sipa sendepa molopili ye awilimu kelepa omu liemu kendemande-yombomo yu konopu sipili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nane onondo paa sika nimbu sikirumu: “Kanu ye awilimuni kanu kendemande-yombomondo “Nanga méle taltolioma pali nuni nokondou.” nimbá.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Aku-sipa na-kolo ⸤ye awilimuni kanu kendemande-yombomondo nimbale: “Nanga kendemande-yomboma pali nokondou.” nimba senga pulimú kinia⸥ kanu kendemande-yombomone “Nanga ye awilimu welea naa ombá.” konopu lepale yuni nokondolemo kendemande-yomboma kopene topa, kere-langi nomba no-tondoloma nomba amu topa, aku sipa sepa kinjipa molomu liemu ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","walte kanu kendemande-yombomo ‘Yunga ye awilimu ombá.’ nimba naa pilipa ⸤kongono sirimu mele naa sepa⸥ walu sepa kinjipa molomba kinia ombá. Omba ⸤kanu yombomo sepa molomba mele kanopale⸥ yu paa kopene topa kondopa, yunga ungumu pilku mokoli seko kongono ambolko naa kondoli yomboma ⸤kolea kiri⸥ molemelena ‘Pupili.’ nimba lipa mundumba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kongono seli yombo se yunga ye awilimuni “I-siku i-siku sei.” nimbá ungumu sumbi sipa pilipale ungumu ta nimbá, molo ‘Nikimu mele naa sembó.’ nimba pilipa aku sipa pilipa lipa naa sembá yombo kanumu yunga ye awilimuni pe yu ‘Mindili paa awili sepa nopili.’ nimba wale paa awisili tomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Aku-sipa na-kolo “Sei.” nimbá mele mimi sipa naa pilipale we walu sepa kinjimba yombomo yunga ye awilimuni ‘Mindili kanga-kolte mele nopili.’ nimba wale kanga-kolte mele tomba. Yombo méle awisili siringi lipa taltorumu yombomo “Pundu toko méle awisili si.” ningí. Yombo “Méle awisili nokoko molou.” niringi yombomo “Kelko méle awisili si.” ningí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“⸤Na lombili andolima,⸥ na ya ma-koleana sepe mundumbu orundu. Kanu sepemo iseli-u welea nolkanje papu. Na konopu silka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na no limbu ulu akumu na-kinia wendo ombá. Ulu akumu iseli-u wendo naa okomomonga na konopu umbuna sepili molio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“‘Ya mana-yomboma opa naa seko seluna konopu seluna pupili molangi.’ nimbu orundu konopu lekemeleye? Aku mólo. ‘Yomboma konopu lupa lupa pepili anju yando opa-tou mele molangi.’ nimbu orundu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kiniá kepe pe anjupa kepe ulka seluna pelemele yombomanga ⸤marene nanga ungumu pilku molko marene nanga ungumu pilku mokoli seko molkole,⸥ ono onono opanale seko yombo se-pakara ulka seluna peko, yopoko onono molonge, talo ololo molongele, yu-mele-mele molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lapane malo-kinia opa sepa, malone lapa-kinia opa sepa, seluna manda naa molongele. Anumuni lemenu-kinia opa sepa, lemenuni anumu-kinia opa sepa, seluna manda naa molongele. Bamuni yunga malonga menu-kinia opa sepa, malonga menuni bamu-kinia opa sepa, seluna manda naa molongele. ⸤Kanu yomboma manda naa molonge.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aku nimbale Yesusini liku maku toringi yombomando nimbale: “Onone kolea kolopale kupa tolemo kinia kanokole “Lo ombá lémo.” nilimili kinia lo sika olemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe kelepa ipulieli poporome topa, kombokandi gilimú kinia kanokole “Ena tondolo sembá lémo.” ningu pilielemele kinia ena sika selemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“⸤Naa pilkimulu.” nilimili-na-kolo sika pilielemele⸥ yombo kolo toko topele-mapele tolima! Ono mulumu kinia ya mamo kinia kanokole ‘kolea i-sipa i-sipa sembá.’ ningu kanolemele-na-kolo kiniá ⸤na mana orundu kinia⸥ wendo olemo uluma kanoko molkole kanu ulumanga ulu-pulumu naa pilielemele. Aku nambi semu-na ⸤lipa ora silimú mele⸥ naa kanoko naa pilielemeleye?” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Onone nambi semu-na uluma pilku apuruku ulu peangama pilku naa selemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu kote sendemba sembá yombomo ‘Konopu seluna pupili molambili ulu se sambo.’ ninguli welea sani. Aku naa senu liemu nu kote sendemba yombomone nunga kote pilieli yemo molombana memba pumba simbanje? Pe kote pilieli yemone nu ka-ulka nokoli yemo lipa simba, yuni nu ka-ulkana lipa mundumba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nane nundu paa sika nimbu sikirumu: “Nu ka-ulkana wendo onindu pundu paa pali tokole mindi wendo onimu. We manda wendo naa oni.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanu-kinia Yesusini ungu-mane sirimuna moloringi yombo marene yundu semane toko siku ninguli: “Kolea Gallilli disiriki yombo marene Pulu Yemo popo toko mélema kalko molangi ⸤Romo gapomano ye awili⸥ Paillatene ono topa kondorumu.” ningu semane toringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aku semanemo toringi kinia pilipale Yesusini onondo nimbale: “Kanu kolea Gallilli yomboma aku siku mindili noringi-kulu pilkuli ‘Gallilli yombo moloringi lupa wemane ulu-pulu-kiri seringi mele maniandopa, kanu mindili noringi yomboma ulu-pulu-kiri seringi mele paa olandopa.’ konopu lekemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Paa sika nane onondo “Aku sipa mólo.” nikiru. Ya molkomele yomboma, ono ulu-pulu-kiri selemelema bulu siku munduku kelko konopu topele naa tongi liemu ono aku siku toko kondongela.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pe kelepa Yesusini semane se topa nimbale: “Kolea-awili Jerusalleme sukundu kolea-kanga Silloamo kouni takoli ulka awili olana se topa kalambili sipa topa mania mundupale yombo tene-et topa kondorumu koloringi. Kanu yomboma ‘Kolea-awili Jerusalleme yombo lupa moloringimane pali ulu-pulu-kiri seringi mele maniandopa, koloringi yombomane ulu-pulu-kiri seringi mele paa olandopa.’ konopu lekemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Paa sika nane onondo ‘Aku sipa mólo.’ nikiru. “Ya molkomele yomboma, ono ulu-pulu-kiri selemelema bulu siku munduku kelko konopu topele naa tongi liemu ono aku siku kolongela.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aku nimbale kelepa ungu-iku se topa onondo nimbale: “Ye sene unju piki se yunga unju waene kaliana umbu lierimu. Pe ‘Piki mongo tomba.’ nimba omba kanorumu kinia se naa torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Piki mongo se naa torumu-kulu yunga unju waene kalia tapu-yemondo nimbale: “Pílie. Kalia-ingi talo yopoko pea i unju piki gilimúmunga ombo kanorundu-na-kolo piki mongo selu kepe naa torumu kene yuni ma-nale we nolemo kene peke toko eltou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kalia pulu yemone aku sipa nirimu kinia kalia tapu serimu yemone yundu pundu topa nimbale: “Ye-Awilimu, i kalia-ingi selumu mindi aku unjumu we giliepili. ‘Unjumu akopa mongo topili.’ nimbu unju puluna era sepo, ma mundupu, kongi-le lipu mundupu, sambo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pe nekendo kalia-ingimunga mongo tomu liemu peanga. Naa tomu liemu kamu peke tani.” nirimu.” ⸤nimba Yesusini⸥ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Walte, ⸤koro moloringi⸥ wale Sambate senga Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka senga sukundu Yesusi pumbale yomboma ungu-mane sipa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Akuna ambo se molorumu, yu kuru topa bulu elke torumu-na ola gilipa siniu simbando perepa molorumu. Yu aku sipa molopili kalia-ingi tene-et omba purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesusini kanu ambomo kanopale yundu “Ou.” nimba nimbándo: “Ambomo, nu kuru torumumu topa keliepili.” nimbale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ambomo kimuni ambolorumu kinia yu popenge sepa sumbi sipa ola gilipa Pulu Yemo kape nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aku-sipa na-kolo kanu ulkamo nokorumu yemo yuni Yesusi ⸤koro mololi⸥ wale Sambatemonga yombo sepa peanga sirimu-kulu kanopa kiri pilipale akuna maku toringi yombomando nimbale: “Kongono-wale talo-pakara lemomanga ‘Kuru tomba yomboma peanga liepili.’ ningu onge manda. ⸤Koro mololi⸥ Sambate walemonga manda mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yemone aku sipa nirimu kinia Yesusini nimbale: “Ono topele-mapele toli yema, alieli ⸤koro mololi⸥ wale Sambate wendo olemo kinia ono pali yu-mele-mele ononga kongi kao molo kongi dongi kere-langi nomba molemona moki leko no olemo kolea senga ‘No nopili.’ ningu mengo pulimili kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ono ononga kongima Sambate walemonga papu moki leko nokolemele kene i ambomo Sambate walemonga papu lipu tapondokorola. Kongima maniandopa mele, yomboma olandopa mele kanumu. Akumunga i ambomo, yu Eporayamone kalopa liltimu ambo se, ⸤kurumanga nokoli⸥ Setenene yu kalia-ingi tene-et ka mele sirimu ambomo Sambate walemonga moki lepo nokokoromo sepo kinjikiruye?” nimba mangilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yuni aku sipa nirimu kinia kanu ungumuni yu serimu mele kanoko kiri pilieringima olie poloringi-na-kolo we-yombomane yu ulu-tondolo peangama serimu kanokole konopu awili-seko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kanu-kinia Yesusini ⸤yombomando⸥ kelepa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo, méle nambolka mele kanu sílimu lemoye? ‘Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo mele piliangi.’ nimbu akumu nambi sepo nimbu siemboye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Akumu i-sipa mele: Ye sene yu unju masetete umbu se lipa yunga kaliana umbumu mundorumu kinia kanu unju umbumu wendo omba awili lepa unjumu gilierimu kinia aku unjumunga kolamanga kerama ongo peringi. Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo mele aku sipa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aku nimbale kelepa mangilipa pilipa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo mele pilingí nambi sepo nimbu siemboye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Akumu i-sipa mele: Ambo sene yu kere-langi pellawa akoli mele isi kanga-kolte lipale pellawa awisilinga mundorumu kinia pellawa pali akorumu. Pulu Yemo ye nokoli kingimu molopa yomboma nokolemo mele aku sipa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aku sipa nimbale pe Yesusi kolea-awili Jerusalleme pulimú aulkana pumbá pumbale kolea awilima kinia kangama kinia pumba, akumanga moloringi yomboma ungu-mane sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kanu yombomanga sene yu mangilipa pilipa nimbale: “Ye-Awilimu, mindili nomolo aulka molemolona Pulu Yemone yomboma lipa tapondopa wendo lipa yu-kinia molko kondonge aulkana lipa mondomba yomboma koltalo mindiye?” nimba mangilierimu. Pilipale yuni onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ulka kerepulu paa kanga si nilina yombo awisili ongo sukundu pungíndu perenge. Akumunga ‘Kanu kerepuluna ono ongo sukundu pungu molongendo kála seko pangi.’ nimbu nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ulka pulu yemone ola gilipa kuna anjimba kinia ono pena molkole ningímuni, kuna toko mangilku ninguli: “Ye-Awilimu, olio nu kinia pea molamili wamili kene olionga kuna lindei.” ningí kinia yuni onondo nimbale: “Ononga imbima na naa pilipu ono kepe ononga koleama kepe na naa kanolio.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Yuni aku nimbá kinia onone yundu ninguli: “Nu pea ga norumulu. Olionga koleamanga nu ongole olio ungu-mane sirinu.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aku-sipa na-kolo yuni onondo nimbale: “Ono niembo piliaa. Ononga imbima na naa pilipu ononga koleama na naa kanolio. Ono ulu-pulu-kiri seko molemele yomboma pali na moliona anju paa.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akuna ultu molkole ono ⸤anda-kolepali⸥ Eporayamo kinia, Aisake kinia, Jekopo kinia, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema pali kinia, ono Pulu Yemo ye nokoli kingimu molopa nokomba koleana sukundu molonge kanokole ono onono akuna ultu molonge kanokole ono onono mumindili kolko kola seko mini-wale mundungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Isirele yomboma ono Pulu Yemo ye nokoli kingimu molopa nokomba koleana sukundu ono manjiku naa pungí ‘Piliangi.’ nimba yuni kelepa nimbale: “Ma-koleana pali yombo mare Pulu Yemo ye nokoli kingimu molopa nokomba koleana sukundu pungu Pulu Yemo pea kere-langi nonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Piliame. Akileko olemele yombo mare Pulu Yemo ye nokoli kingimu molopa nokomba koleana sukundu kumbi leko pungí. Kumbi leko oringi yombo mare akileko pungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Walte, Yesusi u Jerusalleme naa pumbale kolea senga ungu nimba molorumu kinia Parisi ye marene ongo yundu ninguli: “⸤Ye nokoli kingi⸥ Erotene ‘Nu topo kondambo.’ nimba molemo kene nu ya naa molkole senga kowa pu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesusini onondo nimbale: “Na tomba sekemo yemo, yu kolo topa konopu kiri peli owá-palako pokisi mele akumu molemona i ungumu pungu ningu si-paa.” nimba nimbale: “Kiniá mele kepe opali talu mele kepe kuruma yombomanga konopuna pelemoma makoropo, kuru toli yomboma sepo peanga sipu, molopole kanga-kolte pe mele na kongono sepo moliomo pora simbú. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aku-sipa na-kolo Jerusalleme pumbúndu kiniá kepe opali talu kepe na we kongono selepo pumbú. Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye se kolea-awili Jerusalleme ultukundu manda naa kolomba kene ⸤na Pulu Yemone ungu-umbu tondolemoma pilipuli yomboma nimba silimú yemo molio kene⸥ na Jerusalleme ultukundu manda naa kolombo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","⸤Aku nimbale Yesusini Jerusalleme moloringi yomboma yu kondo kolopa akumundu ungu se nimba nimbale:⸥ “O Jerusalleme ⸤yomboma⸥, Jerusalleme ⸤yomboma⸥, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema toko kondoko, yuni ono molemelena lipa mundulimú yema kouni toko kondoko selemele yomboma, kera gulta anumumuni yunga waloma lipa yunga poutolone okopa lopi sepa nokolemo mele nane wale awisili ono aku sipu nokolka-na-kolo onono “Mólo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akumunga piliame. ⸤Opa-touma ono tonge onge kinia Pulu Yemone kelepa ono naa nokopa naa lipa tapondombamonga⸥ opa-toumane ongo sika toko munduku ononga koleamo kinia ononga Pulu Yemo popo toko kalolemele ulka-tembelemo kinia kamu toko kalongemonga ono ku penge. Nane ono ungu se pea nimbu sikiru: “Ono Jerusalleme yomboma, onone nando “Pulu Ye Yawene lipa mundorumu-na okomo yemo imbi ola molopa, molopa kondopili.” ningí walemonga na kelko kanonge. U mólo.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","⸤Koro moloringi⸥ wale Sambate senga Parisi ye awili senga ulkana Yesusi kere-langi pea nongendo purumu. Omba molorumu kinia pea kere-langi nongo moloringi yemane yu neme-neme ningu kanoko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yunga kumbikerena ye kangi akorumu se molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pulu Yemonga ungu-manemanga puluma pilku kondoringi yema kinia, Parisi yema kinia, ono Yesusini mangilipa nimbale: “⸤Koro mololi⸥ wale Sambate kinia kuru toli yombo se sepo peanga silimolánje manda molo móloye?” nirimu. “Pulu Yemonga ungu-manemanga sukundu nambolka nimba molemoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aku-sipa na-kolo yundu ungu se pundu toko naa ningu we moloringi. Kanu-kinia yuni kanu yemo lipa sepa peanga sipale yundu “Pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aku sepale Yesusi yuni pea moloringi yombomando nimbale: “Ono molkomele yombomanga ye senga kango se molo kongi kao se Sambate wale senga no-muru senga mania tomu liemu kanu yemone yunga kangomo molo kongi kaomo popenge sepa wendo naa limbaye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aku nirimu pilkuli ⸤ ‘Olione “Sambate wale senga kango molo kongi-kao no-muru senga wendo limba akumu peanga.” nímulu liemu yuni “Sambate walemo kinia yemo lipu tapondokoro peangala.” nimbá.’ ningu pilkuli⸥ ungu se pundu toko ningí aulka se naa lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Parisi ye awilimunga ulkana kere-langi nongendo oringi yomboma ye awilimanga polo kumbikundu ‘olio molamili.’ ningu konopu siku moloringi kanopale Yesusini ono ungu-mane sipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Ye sene nu kinia yombo mare pea “Kere-langi namili waa.” nimbá kinia nu ongole ye awilimanga polo kumbikundu senga pungu naa molani. Nu kanu polomonga moloni kinia pe ye awili se yu imbi olandopa molomba ye se yu kepe ‘Kere-langi pea namili ou.’ nimbá ye se ombá kinia ulka pulu yemone nundu nimbale: “I ye awilimu nu moleno polo akuna molopili polomo si.” nimbá kinia nu pipili kolkole polo se lupa, namba naa lieli yombomanga polo senga pungu moloni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Akumunga, ye sene nundu “Kere-langi pea namili ou.” nimbá kinia yunga ulkana pungu namba naa lieli yombomanga polo senga pungu molani. Akuna moloni kinia ulka pulu yemone nu molonina omba nundu nimbale: “Ano, i polona naa molko ye awilimanga polona ongo molou.” nimbá kinia kere-langi pea nongo molonge yombomane nu-kinia sembá mele kanokole nu ‘Ye awilimu.’ ningu kanonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Yombomane onono imbi ambolko paka tolemele yomboma ⸤Pulu Yemone⸥ imbi topa mania mundumba, aku-na-kolo yombo onono imbi toko mania mundulimili yomboma yuni ononga imbima ambolopa paka tondomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kanu-kinia Yesusini ulka pulu yemondo nimbale: “Nu yombomanga kere-langi kalondokole nunga pulu lemó yomboma kinia, nunga genali kinia, ye kamakoma kinia onondo ‘Kere-langi pea namili waa.’ ni naa nieni. ‘Onone walte kelko pundu mele toko, nando ‘Kere-langi pea namili ou.’ niengi.’ ni naa nieni, mólo! ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nu yombomanga kere-langi kalondokole yombo koropama kinia, kimbu ki kinginewe tambulorumu yomboma kinia, kimbu kiri lierimu-na mimi siku aulka naa andoringi yomboma kinia, mongo kiri lierimu yomboma kinia onondo ‘Kere-langi pea namili waa.’ nieni. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Onone kanu kere-langima pundu paa manda naa tongemonga nu konopu siku molko kondoni. Walte konopu sumbi nimba pepili molemele yomboma kolko lomboroko ola molonge aku walemonga ya nikiru mele nu aku siku senimunga méle kalomba lini.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Parisi yemonga ulkana Yesusi pea kere-langi nongo moloringi ye sene Yesusindu nimbale: “Pulu Yemo ye nokoli kingimu molopa nokomba koleana kere-langi nomolo yomboma ⸤olio⸥ “Konopu peanga pepili molko kondangi.” nilimú aulkana molemolo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aku-sipa na-kolo Pulu Yemonga Isirele yomboma Yesusi yunga ungumu naa pilku, mokoli seringimunga mulu-koleana pungu naa molonge pilipale yemone nirimu ungumu pilipale Yesusini ungu se pundu topa ungu-iku se topa nimbale: “Ye sene ‘Yombo awisili pea kere-langi namili kalambo.’ nimbale yombo awisilindu “‘Kere-langi kalopole namili waa.’ nimbú kinia wangi.” nimba, nimba mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kere-langi nonge enamo wendo orumu kinia yunga kendemande-yemondo nimba mundupa nimbale: “U “Kere-langi pea namili waa.” nirindu yombomando “Kiniá enamonga kere-langi kalondondu kene namili wangi.” ni-pou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Aku-na-kolo ono pali naa ongendo yu-mele-mele “Takaraki lekemo kene naa omolo.” niringi. Sene nimbale: “Na ma konde se topo tondumu kano-pumbundu na naa ombó kene nindei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sene nimbale: “Nane kongono seli kongi-kao rureponga talo topo tonduma pumbu kano-pumbundu manda naa ombó kene nindei.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sene nimbale: “Kiniá mindi ambo lindumunga na manda naa ombó.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","⸤Aku siku niringi kinia pilipale⸥ kendemande-yemo kelepa yando ombale niringi mele yunga ye awilimu nimba sirimu. Kanu-kinia ulka pulu yemone mumindili kolopale kendemande-yemondo nimbale: “Nu welea lisiku pungu, i kolea-awilimunga aulka awilimanga kinia aulka kangamanga kinia pungu, yombo koropama kinia kimbu ki kinginewe tambuloli yomboma kinia, mongo kiri lieli yomboma kinia kimbu kiri lierimu-na mimi siku aulka naa andolemele yomboma kinia, ono liku mengo ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kendemande-yemone aku sepale kelepa omba nimbale: “Ye-Awilimu, ninu mele sendu-na-kolo kere-langi noli polona kolea mare we lemóla.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanu-kinia ye-awilimuni yunga kendemande-yemondo nimbale: “Aku sekemo kene nu kelko pungu, kolea-awilimunga ultu pungu aulka awilimanga kinia aulka paka-makamanga pungu, yombo kanoko lendenima pali mengo wani. “Mólo.” ningí yomboma kepe ta ningu liku mengo wani. Nanga ulkamo si nipili kene awisili wangi.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Paa mi ya kana. Na paa sika ono nimbu sikirumu: “Nane pulu-pulu “Kere-langi pea namili waa.” nimbu, nimbu mundorundu yombomanga selu kepe paa naa ongo kere-langi nonge. Paa mólo.” nikiru.” nirimu.” nimba ⸤Yesusini aku sipa ungu-iku se torumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesusi aulkana omba purumuna yombo awisili liku maku toko yu lombili andoringi kinia yu we gilipa topele topa kanopa onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yombo sene na lombili ombándo na olandopa konopu naa mondopale na lombili manda naa ombá. Yunga lapa kinia, anumu kinia, menu kinia, bolangoma kinia, genupili kinia, kemulupili kinia, yu yuyu kepe, ono pea olandopa konopu mondopa, na manjipa konopu naa mondopale na lombili manda naa ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yombo sene ‘Yu lombili pambo.’ nimbale yomboma unju-perana peko mindili nongo kololemele mele yuni unju-pera mele gomo lembando ‘Na yu lombili pumbúndu mindili nondu liemu peangala; kolondu liemu peangala.’ naa nimu liemu na lombili manda naa ombála. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ononga ye sene ulka awili tondolo se takombando yu u naa takopale kanu ulkamonga konopu kimbu sipa yuyu nimbale: ‘Ulka takopo pora simbumunga kou-mone manda taltolionje molo mólo tombanje?’ nimba pilipale ‘Nanga kou-mone manda taltondu liemu manda takombo.’ konopu kimbu sipa naa molombaye? ⸤Aku sipa sembá kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yu aku sipa u naa selkanje pe yu kanu ulkamo takombando ulka ponga mindi topo topa lipa polopale pe kou-mone mólo tomba kinia kamu manda naa takopa pelka. Akumunga yombomane yu ungu-taka tondoko tawe sendelemolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Onone tawe sendeko ungu-taka toko ninguli: “I yemo ulka awili tondolo se takomba takorumu-na-kolo yunga kou-mone mólo torumu-kulu yu manda naa takopa pora sirimu.” ningu tawe sendelemolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“⸤Se mangilikirula.⸥ Ononga ye nokoli senga talapemo kinia ye nokoli kingi senga lupa talapemo kinia opa sengele kinia se yu tomba sembá, se yunga koleana we molomba. Ono omba tomba ye nokoli kingimu yu opa seli ye tuwendi-tausini memba ombá. Aku-sipa na-kolo we molomba ye nokolimu yunga opa seli ye tene-tausini mindi molonge. Kokele tonge onge kinia we molomba ye nokolimu yunga yema mangilipa pilipa nimbale: “Olio opa seli ye tene-tausini mindi molopole olio ongo tonge yomboma anju manda tomolo molo móloye?” ni naa nimbáye? ⸤Aku sipa manda manjipa pilipa molomba kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kanu-kinia kanu ye nokoli kingimu yuni ‘Olione ono anju manda naa tomolo.’ nimba piliemu liemu yunga ye mare lipale, ye tuwendi-tausini memba ombá ye nokolimu aulka suluna ombámonga “Paa.” nimba lipa mundupa nimbale: “‘Opa naa sepo we taka lepo molamili kene nane nambolka ungu se samboye?’ ningu mangilku pili-paa.” nimbá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","⸤Ungu-ikutolo topa kelepale nirimumuni, pe ungu-ikutolonga ye talone selembolá mélemonga ungu-pulumu ono nimba sipa nimbale:⸥ “⸤Kanu yetolone selembolá⸥ aku sipa mele ononga yombo se yuni ‘Na lombili wambo.’ nimbale yunga mélema pali kinia, yunga yomboma kinia, yunga kou-mone kinia, yunga kangimu kinia, aku mélema mindi konopu mondopa na olandopa konopu naa mondolemo yombomo na lombili manda naa ombá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","⸤Aku nimbale kelepa nimbale:⸥ “Api-kusa akumu méle peangamo na-kolo yu songo naa sembá kinia ‘Yu kelepa songo sepili.’ ningu ungu se manda semoloye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kanu api-kusa songo naa sélimu nambi semoloye? ‘Kaliana lipu mundumulú kinia kere-langi manda naa ombá; yu ma-nale se mólo.’ nimbu kanopole we eltomolo.” ⸤nimbale⸥ “Yombo komu-pea lemba yombomane i nikiru mele piliaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kou-takisi lili yema kinia ulu-pulu-kirima seli ye wema kinia ono pali Yesusinga ungumu pilingindu yu molorumuna nondoko oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisi yema kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia onone aku seringi mele kanokole konokono ningu ninguli: “I yemo yu sepa kinjikimu. Ulu-pulu-kirima seli yomboma “Pea molamili waa.” nimbale, kere-langi alieli ono pea nongo molemelela.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesusini ono aku siku niringi pilipale ⸤i ungu-ikuma ono topa sirimu.⸥ Ungu-iku imu topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ononga ye sene kongi sipisipi paip paono mondolka kinia se talopa lelkanje yuni sipisipi po paono tene kelepa nani wema kolea ku lielina molangi siye kolopa pumba, talopa lelka sipisipimu kanopa limbando korolepa naa pulkaye? ⸤Korolepa pulka.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pe kanopa lipale yuni konopu sipa apu topa ulkondo memba pulka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kanu-kinia ulkondo ombale yemone yunga pulu lemó yombomando kinia yunga ulka kere-pongolo selu yombomando mangilipa nimbale: “Nanga kongi sipisipi talopa liemu kanumu kanopo lindu kene pea konopu sipu molamili waa.” nilka.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","⸤Nimbale ungu-ikumunga pulumu nimba para sipa nimbale:⸥ “Nane ono ungu se nimbu sikirumu: “Yombo konopu sumbi nimba pepili molemele yomboma aku siku molemele-na ono ulu-pulu-kirima munduku kelko konopu topele tonge aulka se naa lemó kanumu, kanu yomboma mulu-koleana angellomane konopu we silimili. Aku-sipa na-kolo sipisipi nokoli yemone yunga sipisipi talopa lielimu kanopa lipale paa olandopa konopu silka mele aku sipa ulu-pulu-kiri seli yombo se yunga ulu-pulu-kiri selemoma pilipa kiri pilipa mundupa kelepa konopu topele tombamonga angellomane paa olandopa konopu singí.” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","⸤Nimbale kelepa ungu-iku se pea topa nimbale:⸥ “Se i mangilikirula: Ambo se kou-mone suroli mele engaki rureponga talo taltopale nilkamone, pe kanu kou suroli mele se mania pulkanje yu sepe-llame kandopa ulka pole lepa kanopa limbando kultupana topa naa korolkaye? ⸤Paa korolkamo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kanu-kinia kanu koumu kanopa lipale yunga pulu lemó yomboma kinia yunga ulka kere-pongolo selu yomboma mangilipa nimbale: “Nanga kou-mone suroli mania pumu kanumu kanopo lindu kene pea konopu sipu molamili waa.” nilka. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nane ono nimbu sikirumu: “Kanu ambomo konopu silka mele aku sipa ulu-pulu-kiri seli yombo se yunga ulu-pulu-kiri selemoma pilipa kiri pilipa mundupa kelepa konopu topele tombamonga Pulu Yemonga angellomane konopu singí.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","⸤Aku nimbale⸥ Yesusini kelepa ⸤ungu-iku yopoko-sipamo pea topa ye awilima mane sipa⸥ nimbale: “Ye se, yunga kango talo moloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Walte kango akiliumuni lapando nimbale: “Tata, nu kolonimunga monge-mélema iseli-u moke seko na sini mele sieni.” nirimu kinia kanu yemone yunga taltorumu mélema moke sepale yunga kangotolo sirimu liltingili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kanu mélema olo moke sepa sirimu kinia kango akiliumu wale pokore mindi molopale, pe méle sirimuma pali lipa memba aulka sulu senga purumu. Aulka sulu senga pumbale nirimumuni, kolea senga pumba molopale yu ‘Kere-langi peangama nambo.’ nimba, ‘Mulu-maminia peangama pakambo.’ nimba kou-mone awili sepa pulimú mélema topo topa lipa panjipale, ‘No nambo.’ nimba topo topa lipa, ‘Amboma pea peamili.’ nimba kou-mone sipa, aku selepa purumu kinia yunga kou-mone mélema pali pora nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yunga mélema kinia kou-mone kinia pora nirimu kinia yu paa koropa purumu. Kanu-kinia yu molorumu koleana gele awili sepa lierimu kinia yu mélema pali mólo torumu kinia yu paa gelene kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yu gele serimu-kulu yu kanu kolea pulu ye se molorumuna pumba “Kou-kongono se sambo si.” nimba mawa serimu kinia yuni nimbale: “Manda, nanga kongi tapu sendeko ‘Kere-langima nangi.’ ningu liku si.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","⸤Gelene paa kolopale⸥ ga iniama kinia konape buluma kinia kongi sirimuma ‘Nambo.’ nimba pilipa molorumu-na-kolo yu se naa siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kanu-kinia pe yu konopu kimbu sipa pilipale yu yuyu nimbale: ‘Tatanga kongono sendelemele yomboma ga awisili nongo olo selemo-na-kolo na ya gelene kolopole kamu kolombo sekero. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akumunga na kelepo yando pumbu Tata molemona pumbuli yundu nimbuli: “Tata, nu kinia Mulu-Koleana Molemo Yemo kinia nane sepo kinjerindu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na kango kiri kene nunga marena molombo manda naa sembá kene nunga kongono ye se molambo.” nimbú.’ nimba pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aku nimba pilipale yu molorumu koleamo mundupa kelepa, lapa molorumuna pumbá purumu. Yu ulkondo pumbá purumu kinia yunga lapane yu sulu sepa orumu kanopale yu kondo kolopa lisipa pumba yu kangulorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kanu-kinia kangomone lapando nimbale: “Tata, nu kinia Mulu-Koleana Molemo Yemo kinia nane sepo kinjerindu. Na kango kiri kene nunga marena molombo manda naa sembá kene nunga kongono ye se molambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aku sipa nimba molorumu kinia lapane yunga kongono senderingi kendemande-yemando nimbale: “Welea pungu nanga mulu-maminia peangamo liku mengo ongo yu pakondoko, ki-ongi se liku yunga kína mondondoko, kimbu-su liku yunga kimbuna mondondayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Aku sekole kongi kao walo awilimu toko kalondoko molombolona mengo waa.” nirimu. “Nanga kangomo yu koronga-u purumu, ‘Yu kolorumunje.’ nimbu pilierindu-na-kolo kiniá yu kelepa okomo. Yu u pumba sepa nema liltimu-na-kolo kiniá kelepa okomo kanopo likimulu kene konopu sipu kongi kao nombo molamili.” nirimu kinia ono aku siku konopu siku kongi nongo moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Aku-sipa na-kolo yunga kango komomo kaliana kongono sepa molopale pe ipupini ulkando ombá orumu kinia ono konopu siku musiki toko denisi seko moloringi ungumu pilipale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","yuni kongono kendemande ye sendo “Ungu se niembo ou.” nimbale nirimumuni, yundu mangilipa nimbale: “Ungu sekemelemo nambi semu-na sekemeleye?” nimba mangilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kanu kongono kendemande yemone yundu pundu topa nimbale: “Gena omu-na laniene kanopa yu manda-mele molopa ungu se naa sepa omu-na kanopale konopu sipa “Kongi kao walo awilimu namili.” nimba topa kalomu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aku sipa nirimu pilipale kango komomo yu mumindili kolopale “Na ulkana sukundu paa naa pumbú!” nirimu. Aku nirimu pilipale lapane wendo omba yundu nimbale: “Olio pea konopu sipu molamili ou.” nimba mawa serimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","lapando pundu topa nimbale: “Pílie! Na alieli, kalia-ingi awisili, nunga kongono sendepo molopole nuni nilinu unguma alieli pilipu lipu sengena panjipu, walte kepe nunga ungu se mokoli naa sepo molio-na-kolo nuni nando walte kepe kongi-meme walo se ‘Kangoma kinia pea konopu siku nongo molangi.’ ningu naa silinu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aku-sipa na-kolo kiniá nunga kango se omba, yuni ambomando “Na pea peambili kou-mone siembo.” nimba nunga kou-mone ono sipa pora sirimu, kanu kangomo omu kinia nu konopu siku ‘Kongi kao walo awilimu namili.’ ningu tonu lepomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Lapane yundu pundu topa nimbale: “Kangomo, nu kinia na pea alieli molembolo kinia nanga mélema pali oltonga. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aku-na-kolo kiniá gena kolorumu kanumu kelepa omu. Yu u pumba sepa nema liltimu, kiniá kelepa omu kanopo likimulu kene olio konopu sipu musiki topo kere-langi nombo molkomolo akumu peanga sekemolo.” nirimu.” ⸤nimba Yesusini⸥ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","⸤Aku nimbale⸥ Yesusini yu lombili andolimando nimbale: “Walte ye kamako se molorumu kinia yunga méle taltorumumanga nokondoli ye se molorumula. Walte yombo marene kamakomo molorumuna ongo, yunga mélema nokondoli yemone serimu mele ongo yundu ninguli: “Nunga méle taltolenomanga nokondoli yemone nu sepa kinjipa, nunga mélema ‘We mania pupili.’ nimba yu akuma nokopa naa kondolemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aku niringi pilipale ye-kamakomone kanu yemondo ‘Ou.’ nimba yundu iri topa nimbale: “I ungu nambolka ungumu nikimiliye? Nuni nanga mélema seko kinjilinu mele níngi kinia pilipuli nuni nanga mélema serinu seleno mele bokuna toko, yando sikuli pe pani. Nu nanga mélema kelko manda naa nokani. Nu makorombo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kanu mélema nokondoli yemo yuyu nimbale: “Apa! Kiniá nambi samboye? Nanga ye-awilimuni nanga kongono seliomo wendo lipa na makoromba sekemo kene na nambi samboye? Na ma akumbundu tondolo naa pulimú-na aku kongonomo manda naa sembó. Yomboma kere-langi mawa sembondo pipili kolombo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akumunga na sembó mele kiniá piliporo. ⸤Nanga ye-awilimuni pundu anjerimu yomboma lipu tapondopole onondo ‘Pundu ekendo mindi tangi, ekendo mania pupili.’ nimbú kinia⸥ pe na makoromba kinia kanu yombomane na konopu siku liku tapondokole nando “Pea peamili ou.” ningí.” nimbale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","yunga ye-awilimuni pundu anjerimu yomboma ‘Yu-mele-mele wangi.’ nimba kumbi lepa orumu yemondo nimbale: “Nanga ye-awilimuni nu-kinia méle nambi sepa pundu anjerimuye?” nimba mangilierimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","yuni pundu topa nimbale: “Unju-ollipi mongo wele mingi paip paono pundu anjerimu.” nirimu kinia ye-kamakomonga mélema nokondoli yemone yundu kelepa nimbale: “Pundu anjeli bokumu i sikiru; ya mania molko, paip paono toko mondoringi gomomo ora toko eltokole kolali seko gomo kondena wele mingi tu paono tene welea toko mondou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yunga bulkundu orumu yemondo nimbale: “Nanga ye-awilimuni nu-kinia méle nambi sepa pundu anjerimuye?” nimba mangilierimu kinia yuni pundu topa nimbale: “Rasi-witi wale paip paono pundu anjerimu.” nirimu kinia mélema nokondoli yemone yundu kelepa nimbale: “Pundu anjeli bokumu i sikiru; ya mania molko, rasi-witi wale paip paono toko mondoringi gomomo ora toko eltokole kolali seko gomo kondena rasi-witi wale po paono welea toko mondaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yu aku serimu pilipale ye kamako awilimuni kanu sepa kinjeli yemo yu kape nirimu. Yunga mélema sika wa-mele lipa sepa kinjerimu-na-kolo yunga pilipa kondolimu paa olandopa perimu pilipale yu kape nirimu. “Ya mana molko, Pulu Yemo konopu naa mondolemele yomboma, ononga pilipa kondolimu paa olandopa; pa selina molko Pulu Yemo konopu mondolemele yomboma ononga pilipa kondolimu maniandopa. We-yombomane yombo se kinia kou-kongono sengendo, molo ulu se sengendo aulkamo sumbi siku kanoko akisiku kondolemele; pa selina melemele yomboma aku sipa tondolomo maniandopa pelemo. We-yomboma aku siku molemelemonga ⸤ye awilimuni sepa kinjeli yemo aku sipa kape nirimu.⸥” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nane onondo nimbu siembo: “Kiniá ya mana molkole mana-mélema liku ‘Yomboma nunga genali mele molangi.’ ningu nunga méle taltolenomanga ono liku tapondani. Pe mélema pora nimbá kinia nu kolea peanga kamu alieli-alieli lembana puni kinia akuna molongemane nundu “Ya kamu pea molamili.” ningí.” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yombo sene yombo senga méle koltalo nokopa kondondolemo kinia kanopale ‘Méle awisili simbú kinia nokopa kondondomba lémo.’ nilimú. Yombo sene yombo senga méle koltalo nokopa kinjindilimú kinia kanopale “Méle awisili simbú kinia nokopa kinjindimba lémo.” nilimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nuni ya mana taltolemele mélema nokoko naa kondonu liemu nu paa sika méle kande-kande lupama, Pulu Yemone silimú méle kande-kandema, ‘Nokondani.’ manda naa nimbá. ⸤Ya mana taltolemele mélema maniandopa, Pulu Yemone silimú méle kande-kande lupama olandopa kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nuni ya mana taltoleno mélema paa sika nunga mólo, kanu mélema Pulu Yemonga. Akumunga nuni yunga mélema nokoko naa kondondonu liemu pe yuni ‘nunga taltani.’ nimba simba sepa molemo mélema manda simbaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kendemande-yombo seluni ye awili talonga kongonotolo lipa sere lepa manda naa sendemba. Ye awili se konopu kiri panjipa, se konopu mondomba. Molo aku naa semu liemu ye awili senga ungu nimbáma paa konopu sipa pilipa lipa kongono nimbáma tondolo mundupa sendepa, se konopu kiri panjipa yunga ungu nimbáma naa pilipa semba. Yombomane Pulu Yemonga kongonomo kinia Kou-Monemonga kongonomo kinia liku sere leko manda naa sendenge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesusini aku sipa nirimu pilkuli Parisi yema ono kou-mone kepe mélema kepe konopu paa awisili mondoringimunga yuni ungu nirimumu pilku mokoli seko tawe seringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesusini onondo nimbale: “Ono onono i-siku ninguli: ‘We-yombomane olio Parisi yema konopu sumbi sipa pepa, peangama molemolo kanoko niengi.’ ningu molemele-na-kolo ononga konopuna paa sika pelemo mele Pulu Yemone kanopa molemo. Mana-yombomane kanokole ‘Méle paa komindi, méle paa olandopamo.’ nilimili mélema Pulu Yemone kanopa kiri pilielemo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“⸤No Lindeli⸥ Jono u mana naa omba molopili Pulu Yemone yomboma ‘Saa.’ nirimu mele ⸤Pulu Yemonga ungu-manema yando nimba sirimu ye⸥ Mosisini torumu bokuma kinia, Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane boku toringima kinia, kanu bokumanga molorumu, yandopa yandopa mane siku yomboma ningu siringi. Aku-sipa na-kolo kiniá, Pulu Yemone omba ye nokoli kingimu molopa yomboma nokopa kondomba semane peangamo topo silipu andolemolo. Pulu Yemo ye nokoli kingimu molopa yomboma nokomba yombo talapena sukundu pungu molongendo yomboma ekelepa seko pulimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mulumu kinia mamo-tolo walte manda pora nimbá-na-kolo Pulu Yemone ungu-manema Mosisini yando nimba sipa boku torumu bokumanga molemo ungumanga imbi torumumanga imbi selu paa kanga-kolte kepe mania manda naa pumbá. Pulu Yemonga ungu-manema pali lepa mindi pumbá.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ye sene yunga u limú ambomo makoropa “Kamu pu.” nimbale kelepa ambo se limú kinia aku yemone wa ulu-kirinale selemo. “Pu.” nimba makorolemo ambomo pe ye sene yu limú kinia kanu yemo kepe wa ulu-kirinale selemóla.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","⸤Nimbale Yesusini kelepa semane se topa nimbale:⸥ “Ye kamako se molorumu. Yunga wale-pakoli paa peanga kou paa olandopa pulima pakopa, alieli yunga ulkana kere-langi peangama mindi nomba perimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ye koropa se molorumula, kanumunga imbi LLasirasi. Yu enamanga alieli ‘Ye kamakomone yu kondo kolopa kou-mone se molo kere-langi se simbanje.’ ningu yunga ulka kerepuluna ‘Molopili.’ ningu mengo ongo mondoringi. Yunga kangima pali erili serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kanu erilima owámane ongo pene-mane lieringi. Yu ‘Ye kamakomonga kere-langi pundu mania pumbáma lipu nombó.’ nimba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pe walte ye-koropamo kolorumu. Kolorumu kinia angellomane yunga minimu liku, ⸤Juda yombomanga pulu-pulu anda-kolepa⸥ Eporayamo molorumuna mengo puringi. Ye-koropamo kolorumula. Yombomane yu óno seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kanu-kinia yu sepe-koleana mindili nomba molopale, yuni mongomone olando-sipa kanopa aulka suluna Eporayamo kanopa LLasirasi pea moloringili kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanopale ungu se tondolo mundupa nimbale: “Toto Eporayamo, na kondo kolkole ‘LLasirasini nona ki-sundumu mania mundupale ‘Nanga alimbolona monda topili.’ nimba sendepili.’ ningu yu yando mundoyo. Na i sepemonga paa mindili nombo molio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aku-sipa na-kolo Eporayamone yundu nimbale: “Toto, u moloringili mele pílie! Olo mana moloringili kinia nu méle kande-kandema taltoko manda molorunu; LLasirasi yunga méle kirima taltopa, molopa kinjerimu kanumu. Pe kiniá yu konopu peanga pepili molemo, nu mindili nongo moleno. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Molo nane “E.” nilkanje yu andina manda naala olka. Olio kinia ono kinia awi-suku-singina ⸤Pulu Yemone⸥ kombu awilimu liltimu lemó kanumu. Pe kiniá ya molemolo yomboma ‘Ono molemelena anju pamili.’ ningí kinia manda naa pungíla; ononga yomboma ‘Yando wamili.’ ningí kinia yando manda naa ongela.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kanu-kinia ye kamakomone nimbale: “Aku lepomo kene, Toto, yu nanga pulu koleana pupili mundani nimbu mawa sekero. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nanga genupili se-pakara molemele kanumu. I kolea mindili noli koleana ono kepe naa wangi kene yuni ono liepi-liepi topa ungu nimba sipa kondopili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aku-na-kolo Eporayamone yundu nimbale: “Mosisini boku torumu bokuma kinia Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane boku toringi bokuma kinia taltolemele kanumu. Onone kanu bokuma molemo unguma kanoko piliangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kanu-kinia ye kamakomone nimbale: “Toto Eporayamo, aku manda mólo. Kolorumu yombo se lomboropa ola molopa ono molemelena pumba nimba simu liemu ulu-pulu-kiri selemelema pilku kiri pilkuli siye kolko konopu topele tonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eporayamone yundu nimbale: “Mosisinga unguma kinia Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemanga unguma kinia ⸤bokumanga toringi molemo akuma⸥ piliei naa piliengi liemu kolorumu yombo se lomboropa ola molopa pumba nimu liemu yunga ungumu naala pilingí.” nirimu.” nimba Yesusini semane se aku sipa torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusini yu lombili andolimando nimbale: “⸤Na⸥ ‘Sika.’ ningu kuru mondolemele yomboma kelko bulu siku munduku kelenge uluma sika wendo ombá-na-kolo yombo sene nanga yombo se kondi tombamonga kanu yombomo na bulu sipa anju pumu liemu kanu kondi tomba yombomo mindili nomba paa molopa kinjimba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nanga yomboma aku sipa kondi tomba yombomo yu kou paa awili se moko toko nomina lendeko ‘Yu kamu kolo-popili.’ ningu paka toko nomuna paa maniakondo mundulimolánje paa papu. Aku siku toko mundulimolá kinia yu kolopale pe yu Pulu Yemonga bolango sendo ‘Ulu-kirima sepili.’ nimba kondi manda naa tolka. Aku-na-kolo yu aku siku nomuna naa mundulimolá kinia yu yomboma kondi tombamonga Pulu Yemone yu ‘Mongo awili sepa likimu.’ nimba “Mindili paa nopili.” nilka kene onone yu nomuna papu paka toko mundulimolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nanga yomboma, ono onono selemele mele kanoko kondame. “Gena sene nu-kinia ungu se sepa kinjimba kinia yu molombana pungu ninguli: “Ano, nuni na seko kinjenu.” nieni. Aku nini kinia yu pilipa nimbale: “Ano, sika sepo kinjendu kene kondo kolambo.” nimbá kinia nu-kinia kanu ulu-kiri sembá ulumu ‘Mania pupili.’ ningu siye kolani. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kanu-kinia ena selumunga yu wale yopoko-pakara aku sipa nu-kinia sepa kinjipa, pe kelepa wale yopoko-pakara konopu topele topa nundu “Ano, kondo kolambo.” nimbá kinia manda, nu wale yopoko-pakara kanu ulu-kiri sembama ‘Mania pupili.’ ningu siye kolani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kanu-kinia Yesusini u “Nanga kongonomo sende-paa.” nimba lipa mundorumu yemane yundu ninguli: “Ye-Awilimu, nu ungu nilinu mele olio ‘Sika ungumu.’ nimbu kanga sepo mindi kuru mondopo ambololemolo kene nuni ‘awili seko kuru mondoko tondolo munduku ambolangi.’ ningu liku tapondani.” ningu mawa seringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","⸤Ye-Awilimuni⸥ onondo pundu topa nimbale: “Unju senga mongo akumu méle paa kangamo-na-kolo kanu mongomo mana mundulimulu kinia unju akopa awili lepa gilimú kanumu. Aku sipa mele, ono nane ungu niliu mele unju mongo kanga mele paa kanga-kolte mindi pilku liku ambololemolánje, onone ‘Pulu Yemone nanga ungumu manda pilimba.’ ningu ya gilkimu unju awili akumundu “Nu pulkonio pali luruku pungu, nomuna kelko giliei.” nilimolá kinia kanu unjumu ononga ungumu pilipa lipale aku sipa manda selka.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","⸤Nimba ungu se pea nimbale:⸥ “Ononga ye se yunga kendemande-ye sene kalia sendemba molo kongi sipisipi tapu sendemba kinia pe ipupini ulkondo ombá kinia yunga ye awilimuni yundu “Ya ongo mania molko ga nou.” nimbáye? ⸤Aku manda naa nimbá.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kanu kongono sendeli yemo yu kongono sepa kelepa ulkando ombá kinia yunga ye awilimuni yundu i-sipa nimbá: “Nanga ga kalondoko boroko sikuli pe na nanu ga nombo pora simbú kinia nu pungu nunga ga kalko nani.” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ye-awilimuni ‘Sei.’ nimbá mele yunga kendemande-yemone pilipa lipa sembamonga “Ange, peanga senu.” nimbáye? Aku naa nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aku sipala, onone Pulu Yemone onondo “Kongono sendaa.” nilimú mele pali seko liku ono onono ninguli: ‘Olio kendemande-yombo kirima.’ niengi. ‘Yuni olio “Saa.” nilimú mele manjipu sepo, kongono olandopa se naa sepole olio kendemande-yombo kirima molemolo.’ niengi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesusi kolea-awili Jerusalleme pumbá pumbale nirimumuni, kolea Gallilli kolea Sameria disirikitolo aulka awi-suku-singina pumbale, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kolea kanga senga sukundu purumu. Sukundu purumu kinia kuru-laká noli ye rureponga talo yu aulka omba purumuna ongo anju-siku gilku ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","onone ru ningu ninguli: “Yesusi, Ye Nokolimu, olio kondo kolou.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yuni ono kanopa nimbale: “Pulu Yemo popo tondoli yema molemelena pungu, ononga kangima liku ora si-paa.” nirimu. Kanu-kinia ono pungí puringi kinia ono kuru pora nimba umbu-kangi gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Onone peanga lierimu kanoringi kinia ye akumanga se yando omba ungu tondolo nimba Pulu Yemonga imbi ambolopa paka tondolepa omba ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesusi gilierimuna mania pumba tamalu pepa yundu “Paa ange.” nirimu. Kanu yemo yu Sameria yemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kanu-kinia Yesusini nimbale: “Nane ye rureponga talo sepo peanga naa sinduye? Pe kiniá ye rureponga selu akuma sena molemeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Se pea yando ongo Pulu Yemonga imbi ambolko paka naa tondokomeleye? I ye-lupamo mindi okomoye? Isirele ye kuru-laká nomu sepo peanga sinduma sena molemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kanu-kinia yuni Sameria yemondo nimbale: “Ola gilku puyo. Nane nu manda sembomonga kuru mondonumuni nu peanga liemu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi yemane Yesusi mangilku pilku ninguli: “Pulu Yemo ye nokoli kingimu molopa nokomba walemo sewale wendo ombáye?” niringi. Yesusini onondo pundu topa nimbale: “Pulu Yemo ye nokoli kingimu molopa yomboma nokomba walemo wendo ombándo yomboma mongomane kanonge ulu se naa wendo ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ono kiniá ya molemelena Pulu Yemo koronga ye nokoli kingimu molopa yombo mare nokolemo-na yu ye nokoli kingimu molopa yomboma kinia mélema pali nokomba ulumundu yombo sene “Kaname. I wendo okomo.” ningu, “Andi wendo okomo.” ningu, aku mele manda naa ningí. Kanu walemo koronga wendo okomo lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aku nimbale Yesusini yunga lombili andolimando nimbale: “Onone “Mania Omba Mana-Ye Au Lierimu Yemo kanga-kolte kanamili.” ningí walema wendo ombá-na-kolo naa kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yombomane “Winia molemo.”, “Ya molemo.”, ningí. Aku-na-kolo aku siku ningí kinia kolo tonge kene ono lombili naa pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kolea kariapá lipa sinjipa selemo kinia koleama pali pa selemo yombomane pali kanolemele. Mania Omba Mana-Ye Au Lierimu Yemo aku sipa mele kelepa ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aku-sipa na-kolo u yu mindili awili sepa nombá, kiniá molemele yombomane yu pilku naa liku bulu singí. ⸤Kanu-kinia kolopa lomboropa ola molopale nimbámone,⸥ pe “Ombá.” nikiru mele ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","U ye Noa molopili yombomane seringi mele Mania Omba Mana-Ye Au Lierimu Yemo ombá sembá kinia yombomane aku siku sengela. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","⸤Ma-koleamanga pali⸥ no u naa topili yomboma kere-langi nongo, yema ambo liku, amboma ye pungu, aku uluma mindi seko mololko puringi. Noa nona andoli sipi ulkamonga sukundu purumu kinia kepe ono aku siku uluma mindi seko molangi no topa ⸤koleama pali none aki topa⸥ yomboma pali topa kondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","LLote pea moloringi yombomane aku siku seringila. Ono kere-langi nongo bisinisi seko kalia panjiku ulka takoko, we-ulu akuma seko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aku-sipa na-kolo LLote kolea-awili Sodomo mundupa kelepa kowa purumu kanu walemonga sepe kinia kou sepene nolima kinia lo mele muluna mania omba Sodomo moloringi yomboma pali topa kondorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mania Omba Mana-Ye Au Lierimu Yemo kelepa ombá walemonga u seringi nikiru mele pe aku siku seko molongela. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Yu ombá kanu walemo wendo ombá kinia ulka imuna ola molonge yomboma kelko ulkondo pungu ononga ulka sukundu taltonge mélema pungu naa li-pangi. Aku sikula kaliana molonge yomboma mélema liepili taltoko kaliana pungí kinia kanu walemo wendo ombá kinia taltonge mélema kelko pungu naa li-pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","LLote menu serimu mele piliame. ⸤LLote pea Sodomo munduku kelko kowa puringili-na-kolo Sodomo sepe mania orumu-kulu pilipale Pulu Yemonga angello sene u “Iku siku naa kanoko we sumbi siku kowa pale.” nirimu mele LLote menu naa pilipa lipa, iku sipa kanorumu kinia api-kusa au lepa kou mele we gilierimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","‘Na naa kolopo konopu simbú uluma mindi sepo molambo.’ ningu Pulu Yemonga ungumu naa pilku lingí yomboma sika kolonge. Aku-sipa na-kolo ‘Na kolondu liemu peangala.’ ningu Pulu Yemonga ungumu pilku liku seko molonge yomboma naa kolko molko mindi pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nane onondo paa sika nimbu sikirumu: “Mania Omba Mana-Ye Au Lierimu Yemo kelepa ombá walemonga ipulieli yombo talo suluminia seluna pengele kinia ⸤Pulu Yemonga angello sene⸥ omba yombo se we pepili mundupa kelepa se lipa memba pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ambo talo kere-langi kalongele seko molongele kinia ⸤angello se omba⸥ ambo se we molopili mundupa kelepa se lipa memba pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Ye talo kondena unju toko gilingili kinia ⸤Pulu Yemonga angello sene omba⸥ ye se we molopili mundupa kelepa se lipa memba pumbá.)” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","⸤Yuni nirimu mele pilku⸥ onone ninguli: “Ye-Awilimu, aku ulumu sena sembaye?” niringi. Yesusini pundu topa ungu-iku se topa nimbale: “Mélema kolopa lemó koleamanga méle kololima nolemele keramane mélema kolopa lemóma kanokole nongendo mania ongo liku maku tolemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Walte, Yesusini ‘Ono alieli Pulu Yemo kinia ungu ningu siye naa kolangi.’ nimba yu lombili andolimando ungu-iku se topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Walte, kolea senga kote pilierimu ye se molorumu. Kanu kote pilierimu yemo yu Pulu Yemo kepe mana-yomboma kepe, pipili naa kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kanu koleana ambo-waya se molorumula. Kanu ambomo yuni kote pilieli yemo molorumuna alieli omba yundu nimbale: “Na sepa kinjerimu yemo kote sendambo. Nuni na liku tapondoko kote pilindei.” nimba mawa se-pu-pu serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ambomo u kokele orumu kinia kote pilieli yemone yundu “Mólo, nunga kote naa pilindimbu.” nirimu-na-kolo ambomo yu alieli omba mawa serimumunga kote pilieli yemo pilipa kiri pilipa yu yuyu nimbale: ‘Na Pulu Yemo pipili naa kolopo, yomboma kondo naa kolopo molio-na-kolo i ambo-wayamo alieli omba mangilielemomonga pe kelepa omba mawa sembá kinia na kamu pilipu kiri pilimbu kene yunga kote pilindambo.’ nirimu.” ⸤nimba Yesusini⸥ nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ye-Awili ⸤Yesusini aku ungu-ikumu topa pora sipale⸥ ungu se pea nimbale: “Kote pilierimu ye kirimuni ambo-wayamondo serimu mele piliayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aku sipa mele Pulu Yemone yunga yomboma umbuna silimili yomboma aku selemelemonga kote pilieli yemo molopale kote naa sendembaye? Yunga u nimba taltorumu yombomane ipulieli kepe tangoli kepe alieli “Olionga kote pilindei.” ningu mawa selemele kinia yuni ononga kote naa pilindimbaye? Yu u we molopa pe mele “Ono lipu tapondambo.” nimba taka lepa ombáye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yu sembá mele nimbu siembo: “Pulu Yemo yu welea omba yunga yomboma lipa tapondombando, ono umbuna silimili yomboma kote sendepale mindili simba.” nikiru. Aku-sipa na-kolo Mania Omba Mana-Ye Au Lierimu Yemo kelepa wale talo-sipa mania ombá kinia “Yombo marene ‘Yuni ono lipa tapondomba.’ ningu yu mawa seko molonge molo mólonje?” nimba omba kanomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yombo mare ono onone pilkuli ‘Na peanga. Na sumbi sipu molio, yombo lupama molko kinjilimili. Ono yombo kirima. Ono kinia kopu sepo naa molambo.’ ningu pilku andoko moloringi yombomando Yesusini i ungu-ikumu topa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ye talo yu-mele-mele ‘Pulu Yemo kinia ungu niembili.’ ningu Pulu Yemo popo toko kaloringi ulka-tembelena puringili. Se Parisi ye se, se kou-takisi lili ye se. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi yemo pendo sepa ola gilipale yu yuyu konopumuni pilierimu unguma nimbale: “Pulu Yemo, yombo lupama molemele mele na aku sipu naa moliomonga nu “Ange.” nikiru. Ono wa nongo, ulu-pulu-kirima seko, ambo yema wa ulu-kirinale seko, selemele. I kou-takisi lili yemo sepa molemo mele kepe na naa selio. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na koro senga senga wale talo kere-langi mi topo naa nombo, kou-mone kinia mélema kinia méle rureponga talo rureponga talo nimbu liumanga selu selu nimbu nu siliu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aku-sipa na-kolo kou-takisi lili yemo nondopa naa omba anju senga lupa ma kanopa gilipa, ‘Na ye paa kiri se.’ nimba pilipale pipili kolopa ki-lumuni yunga uluwina topa gilipa nimbale: “Pulu Yemo, na konopuna ulu-pulu-kiri peli yemo kondo kolou.” nirimu.” ⸤nimba Yesusini nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nane onondo paa sika nimbu sikirumu: “I yetolonga Pulu Yemone kou-takisi lili yemonga ulu-pulu-kirima siye kolopa, yu ‘ye sumbi nílimu.’ nimba kanopa molopili ulkondo purumu, aku-na-kolo Parisi yemo yunga ulu-pulu-kirima konopuna we pepili ulkondo purumu.” nikiru. Yombo onono imbima ambolko paka tolemele yomboma Pulu Yemone topa mania mundumba, aku-na-kolo yombo onono toko mania mundulimili yomboma yuni ononga imbima ambolopa paka tondomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kanu-kinia yombomane ononga bolango kangama ‘Yesusi yunga kimuni ambolopili.’ ningu yu molorumuna mengo oringi. Mengo onge oringi kanokole Yesusi lombili andolimane iri toko ⸤ “Naa mengo waa.” ⸥ niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aku-sipa na-kolo Yesusini bolangomando “Waa.” nimbale ⸤yu lombili andolimando⸥ nimbale: “Pulu Yemo ye nokoli kingimu molopa nokolemo yombo talape akumu i bolangoma mele molemele yomboma ononga yombo talapemo kene onone i bolangoma na moliona wangi pipi siku “Mólo.” naa niee.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nane onondo paa sika nimbu sikirumu: “Bolangomane ‘Pulu Yemo olionga ye nokoli kingimu molopili.’ ningu molemele mele aku siku naa nilimili yomboma yunga koleana sukundu paa naa pungí, mólo.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","⸤Walte Juda yombomanga⸥ ye nokoli se Yesusi molorumuna omba yundu mangilipa pilipa nimbale: “Ungu Mane Sili Peangamo, na nambolka unguri sembó kinia na konde molopa kondopa mindi puli ulu-pulumu limbuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesusini yundu nimbale: “Nuni na nambi semu-na “Peangamo.” nikinuye? Yombo peanga se mólo. Pulu Yemo mindi peangamo.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","⸤Aku nimbale yemone mangilierimumunga pundu topa nimbale:⸥ “Nu ⸤Pulu Yemonga⸥ ungu-manema ⸤Mosisini yando nimba sirimuma⸥ pilieleno. ⸤Aku ungu-manema i-sipa⸥: “Ambo ye pulima molo ye ambo lilima yombo lupama-kinia wa ulu-kirinale naa sangi.” nimba, “Yombo toko naa kondangi.” nimba, “Mélema wa naa liengi.” nimba, “Yombomanga kote kolo toko naa sendangi.” nimba, “Aminieli lanieli kinia molko kondoko, ungu ningí mele pilku liku seko molangi.” nimba, ungu-mane akuma sirimu pelemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aku nirimu kinia pilipale kanu yemone nimbale: “Na kangomo molopole aku ungu-manema pali pilipu lipu sepo molorundu mele yandopa kiniá kepe sepo molioko.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yu aku nirimu pilipale Yesusini yundu nimbale: “Papu seleno-na-kolo ungu selu mindi naa seleno. Nu pungu nunga méle taltolenoma pali kou-mone li-punguli, kou-mone linima yombo koropama moke seko sikuli na lombili ou.” nirimu. “Nunga ⸤mana-⸥mélema aku sení kinia mulu-koleana nunga méle peangama lemba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kanu ye nokolimu méle paa peanga-peanga awisili taltorumu-kulu Yesusini aku nirimu kinia pilipale yu konopu kiri panjipa konopu umbuna paa awili-sepa sepili anju purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yu aku sipa purumu kanopale Yesusini yu lombili andolimando nimbale: “Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu yombo kamakoma paa kála seko sukundu pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kongi kamele ⸤kongi paa awili se na-kolo⸥ kale suru tolina suku pumbándo kála kanga mele sepale pumbá. Aku-na-kolo yombo kamakoma Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu pungíndu kála paa awili mele seko pungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yuni aku nirimu pilieringi yombomane ninguli: “Aku liemu mindili nolemolá aulkana nawe manda wendo pumba, molopo kondomolo aulkana pumbaye? Se mólonje?” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","yuni onondo nimbale: “Yombomane paa manda naa selemele uluma Pulu Yemone manda sembá. Pulu Yemo yuni uluma pali manda selemo. Ulu se yuni manda naa sembá se mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","⸤Yuni aku nirimu kinia pilipale⸥ Pitane yundu nimbale: “⸤Pe olio-kinia nambolka uluri wendo ombáye?⸥ Olio olionga mélema pali mundupu kelepo nu lombili purumulu mele pulimulu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesusini nimbale: “Nane onondo paa sika nimbu sikirumu: “Pulu Yemo omba ye nokoli kingimu molopa nokomba walemo wendo ombá mele ‘Yomboma piliangi.’ ningu siliku andongendo ononga ulkama kinia, menupili, genupili, anupili lapali, bolangoma, akuma munduku kelenge yomboma pali ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ya mana paa olandopa mele awisili likuli pe pungí koleana konde molko kondoko mindi puli ulu-pulumu lingíla.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kanu-kinia Yesusini ⸤yu lombili andoli⸥ ye engaki rurepo ‘na kinia ono kinia oliolio molamili.’ nimba ono lipa anju memba pumba onondo nimbale: “Piliame. Olio kolea-awili Jerusalleme pumulú pukumulu. Akuna pumulú kinia u Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane wendo ombá mele ningu bokuna toringi uluma pali Mania Omba Mana-Ye Au Lierimu Yemo-kinia kamu wendo ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Juda yombomanga ye awilimane Mania Omba Mana-Ye Au Lierimu Yemo liku Juda ye naa molemele yema singí. Onone yu ungu-taka tondoko yu seko kinjiku yunga kumbikerena elkambe toko, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","yu ka-pultane toko yu toko kondonge. Yu toko kondonge kinia wale yopoko-sipamonga lomboropa ola molomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aku-na-kolo yuni ungu nirimumu pilku sundoringi. Ungu-pulumu naa pilkuli ungu nirimumu pilku sundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kanu-kinia Yesusi Jeriko taono nondopa ombá orumu kinia mongo kiri lierimu ye se aulka lomolomena molopa yomboma “Kou-mone siee.” nimba mawa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kanu yemone yombo awisili ongo pungí puringi pilipale yuni “Nambi sekemeleye?” nimba mangilierimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","onone yundu ninguli: “Nasarete ye Yesusi omba pukumu.” ningu, ningu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aku niringi pilipale yuni tondolo ru nimba mangilipa nimbale: “Yesusi, ⸤ye nokoli kingi⸥ Depitini kalopa liltimu yemo, na kondo kolou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kumbi leko puringi yombomane yu iri toko “Nu ungu naa nili taka leko molou.” niringi. Aku-na-kolo yuni paa tondolo ru nimba mangilipa nimbale: “Depitini kalopa liltimu yemo, na kondo kolou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesusi we gilipale “Yu yando mengo waa.” nirimu. Yu Yesusi gilierimuna nondopa orumu kinia Yesusini yundu mangilipa pilipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nane nu nambi sambo konopu lekenoye?” nirimu. Yuni pundu topa nimbale: “Ye-Awilimu, na mongone mélema kanambo nanga mongotolo seko peanga sendani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesusini yundu nimbale: “‘Nane nunga mongotolo manda sendembo.’ konopu lienumunga nu umbu-mongo manda giliepili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesusini aku nirimu kinia yu popenge sepa mongotolo peanga lierimu, mélema kanopale Pulu Yemo kape nimba yunga imbimu ambolopa paka tondolepa Yesusi lombili purumu. Yombomane pali kanu ulu-⸤tondolo wendo orumu⸥mu kanokole onone kepe Pulu Yemo kape niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesusi yu Jeriko taono omba pumbá purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","⸤Jeriko akuna⸥ kou-takisi lipa takisi liltingi yema nokorumu ye se, yunga imbi Sakiasi, yu akuna molorumu. Yu méle awisili taltopa yu kamakomo molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kanu yemone Yesusi orumu kanomba serimu. Yesusi orumuna yombo awisili liku maku toringi-kulu Sakiasi yu ye ponjili-kulu molopale Yesusi manda naa kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Akumunga Yesusi orumuna kanombando yu lisipa kumbi lepa pumbale unju sikamo-piki nili se Yesusi ombá orumu aulkana nondopa gilierimu aku unjumunga omba ola purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusi akuna ombale we gilipa olando-sipa kanopa yundu nimbale: “Sakiasi, nunga ulkana kiniá na pea molambili pambili welea mania ou.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","yu popenge sepa mania omba yundu “Manda.” nimba konopu sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yesusi Sakiasinga ulkana pea puringili kanokole u akuna liku maku toringi yombomane ninguli: “Yu ulu-pulu-kiri seli ye se kinia ‘Molo-pambili.’ nimba pukumu.” ninguli yu serimu mele kanoko kiri pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanu-kinia Yesusi kinia Sakiasi kinia olo ulkana sukundu molkole Sakiasi ola gilipa Ye-Awilimundu nimbale: “Ye-Awilimu, nane nundu ungu se niembo pílie. Nanga méle taltolioma ekendo lipu yombo koropama sipuli, pe kou se molo mélse kolo topo wa mele liltindu mélse kelepo wa liltindu mele pundu topo yopoko ola panjipu anju simbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yuni aku sipa nirimu kinia Yesusini yundu nimbale: “Kiniá i ulka pulu yomboma Pulu Yemone lipa tapondopa ‘mindili nolemolá aulkana wendo ongo, yu-kinia pea molko kondonge aulkana pangi.’ nilimú ulu-pulumu likimili. Kiniá i ulka pulu yemo yu kepe anda-kolepa Eporayamone kalopa liltimu ye se kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mania Omba Mana-Ye Au Lierimu Yemone ‘Yombo aulka lo liku molko kinjilimili yomboma koropo, ono lipu tapondopo mindili nolemolá aulkana wendo lipu na-kinia molko kondonge aulkana lipu mondombo.’ nimba orumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aku sipa nirimu pilkuli Yesusi yu kolea-awili Jerusalleme nondopa ombá serimu-kulu kanokole we-yomboma onone ‘Pulu Yemo omba ye nokoli kingimu molomba walemo paa nondopa ombá.’ konopu leko moloringi. Onone aku siku pilku moloringi pilipale ⸤Yesusi⸥ yuni onondo ungu-iku se topa ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nimbale: “Ye nokoli senga malo kolea senga aulka sulu pumba yu kingimu molomba namba tondolo se li-pumbale ‘Pe yando ombó.’ nimbale yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","U naa pupili yunga kendemande-ye rureponga talondo “Waa.” nimbale kou kuluepe rureponga talo moke sepa ono yu-mele-mele kou kuluepe selu selu nimba sipa onondo nimbale: “Na wili anju molambo i kou-mone sikiru likimilimunga ‘Kou se olandopa pea liemili.’ ningu konopu tondolo munduku seko molangi. Pe ombó.” nimba yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kanu yemo purumu kinia yunga talapena yomboma yu-kinia konopu kiri pilieringi-kulu ononga ye se ‘Yu akilepa pupili.’ ningu liku munduku ninguli: “‘ “I ye nokolimu olionga ye nokoli kingimu naa molopili.” nimbu molemolo.’ nindei.” ningu yu liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pe kanu yemo kingi nambamo sika lipa memba yando orumu kinia u kou-mone sipa purumu kendemande-yemando “Waa.” nimbale “Ono kou-mone sirindumunga olandopa kou nambi seko liltingiye?” nimba mangilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","U kumbi lepa sirimu yemone omba yundu nimbale: “Ye-Awilimu, nunga kou kuluepe se sirinu kanumunga ola panjipu kuluepe rureponga talo liltindu.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ye nokoli kingimuni yundu nimbale: “Kendemande-ye peangamo. Papu serinu. Méle kanga sirindumunga nu seko kondorunu kene nu kolea-awili rureponga talo nokani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ye talo-sipamone omba yundu nimbale: “Ye-Awilimu, nunga kou kuluepe se sirinu kanumunga ola panjipu kuluepe se-pakara liltindu.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ye nokoli kingimuni yundu nimbale: “Aku siku serinumunga nu kolea-awili se-pakara nokani.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Pe kendemande-ye se omba yundu nimbale: “Ye-Awilimu, nane pilipuli ‘Nu bisinisi tondolo munduku seko, ‘Kou-mone lipu taltombomonga yomboma mindili nongi liemu mandala.’ ningu ⸤kendemande-yomboma ‘Kongono kála seko sangi.’ ningu siku, ono méle koltalo siku mélema pali nunu mindi lilinu yemo;⸥ kalia yombomane panjindilimili kinia nu nunu kere-langi mélema we akuku liku; kalia naa seleno kaliana kere-langi liku taltoko, nu aku siku seko moleno yemo.’ pilipuli pipili kolopo nuni na sirinu koumu kuluepe topo taltorundumu i sikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aku nirimu kinia pilipale ye nokolimuni iri topa yundu nimbale: “Nu kendemande-ye kirimu. ⸤Nane nunga kote pilimbu kinia⸥ nunga nikinu ungumuni nunu kote sendemba. Nuni pilkuli ‘Kalia yombomane panjindilimili kinia na nanu kere-langi mélema we akupu lipu; kalia naa selio kaliana kere-langi lipu taltopo, na aku sipu sepo molio.’ ningu pilku molenoye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aku ningu pilkuli nanga kou-monemo kou-benge ulkana nambi semu-na naa taltorunuye? Aku selenanje na ombo nanga koumu wendo lipuli kou kanga-kolte ola panjiku silimolá lilkala.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","⸤Kanu kendemande-yemondo aku sipa nimba pora sipale⸥ yuni nondoko gilieringi yombomando nimbale: “I yemo sepa kinjerimu kene yunga koumu wendo likuli kou kuluepe rureponga talo ambolkomo yemo siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Onone yundu ninguli: “Ye-Awilimu, yu koronga kou kuluepe rureponga talo ambolkomo kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Onone aku niringi kinia ye nokoli kingimuni kelepa nimbale: “Onondo nimbu siembo: “Mélema taltolemo yombomo nane mare pea simbú, yu paa awisili taltomba. Aku-na-kolo mélema naa taltolemo yombomo yu taltolemoma kepe wendo limbu.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aku sipa nimbale kanu ye nokoli kingimu yuni ungu se pea nimbale: “Kiniá na seko kinjeringi yomboma mengo wame. Onone nando ninguli: ‘I yemo olionga ye nokoli kingimu naa molopili.’ niringi kanu yomboma mengo ongo na kanopo molambo ono toko kondaa.” nirimu.” nimba ⸤Yesusini aku sipa kanu ungu-ikumu topa pora sirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ungu-iku akumu topa pora sipale kolea-awili Jerusallemendo kelepa pumbá purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kanu-kinia Yesusi ⸤kinia yu lombili andolima kinia⸥ ono kolea-awili Jerusalleme nondoko ongo, ma-pangi se ‘Ma-Pangi Unju Ollipi Kalia’ nili akuna lemó kolea kanga talo, Betepasi kinia Betanitolonga oringi. Kanu-kinia Yesusini yu lombili andoli ye talo lipa mundupa, olondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ne kolea-kanga kanokombelena punguli kongi dongi walo se, yombo se yunga bulu-mingina waltikele kepe naa molopa andorumumu ka seko panjingímu ne akuna sukundu molomba kanongele kanumu pungu posiku mengo wangili pale. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Posingilí seko molongele kinia yombo sene olondo “Dongimu nambi semu-na posikimbiliye?” nimba mangiliemu liemu olone i-siku niengili: “Ye-Awilimu yu ‘Dongimuni mepili.’ nimu-na ombo likimbulu.” niengili.” nimba olo lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kanu lipa mundorumu yetolo pungu yuni nirimu mele kanoko lendekole ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","pe kanu kongi dongi walomo posiku moloringili kinia dongi pulu yemane olondo ninguli: “Olionga dongimu nambi semu-na posikimbiliye?” ningu mangilieringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","olone “Ye-Awilimu yu ‘Dongimuni mepili.’ nimu-na ombo likimbulu.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kanu-kinia dongi kanumu liku Yesusi molorumuna mengo oringili kinia onone ononga mulu-maminiama kulku, dongimunga bulu-mingina ola pauwa tondoko Yesusi kanuna ola mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Marene ononga mulu-maminiama kulku yu ombá aulkana pauwa tolko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kanu-kinia yu Jerusalleme paa nondopa omba, ‘Ma-Pangi Unju Ollipi Kalia’ nili akuna mania ombá orumu kinia yu lombili puringi yombo awisili konopu awili-seko siku ⸤Yesusini⸥ ulu-tondolo awisili serimu kanoringimanga Pulu Yemo kape ningu ungu tondolo munduku ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pulu Ye Yawene lipa mundorumu-na yunga kongonomo sendemba okomo ye nokoli- kingimu molopa kondopili. Mulu-koleana konopu pe nipili molomolo walemo welea opili. Mulu-koleana paa olandopa ⸤Pulu Yemonga⸥ imbimu paa ola molopili lakopo kape niemili.” niliku puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aku siku niringi pilkuli pea oringi Parisi ye marene ⸤we-yombomane aku siku niringi mele pilku kiri pilku⸥ yundu ninguli: “Ungu Mane Sílimu, nu lombili andolimane nikimili mele ‘Naa niengi.’ ningu ono iri tou.” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesusini onondo nimbale: “Nane onondo i-sipu nikiru: “I yombomane i-siku naa ningu we molongi liemu ya kou-mulu lemomane ru ningí.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kolea-awili Jerusalleme paa nondopa omba kanumu kanopale nirimumuni, Yesusini kola sepa ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nimbale: “⸤Jerusalleme yomboma,⸥ kiniá ono kepe mindili naa nongo konopu pe nipili manda molonge aulkamo pilielemolánje peanga. Aku-sipa na-kolo kiniá naa pilielemele, naa pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ono molongena wale mare wendo ombá, kanu walemanga ononga opa-touma ongo ‘Ononga koleamonga aulka naa liepili.’ ningu ma liku maku toko, pala mele seko opa-touma ono molko makapu seko ‘Ono sukundu molangi.’ ningu aku senge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aku sekole ningímuni, pe Jerusalleme ulkama pali toko sikisiku bulu-balu sikuli sukundu molonge yomboma tonge, aku siku senge walema wendo ombá lémo. Pulu Yemone ⸤ono lipa tapondombando⸥ omu walemo onone naa piliengimunga kanu walema wendo ombá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesusi Jerusalleme sukundu pumbale nirimumuni, Pulu Yemo popo toko kaloringi ulka-tembelena ⸤ “Juda yombo naa molemele yomboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ sukundu pumba kanopale akuna mélema makete seko moloringi yomboma topa makoromba makoropale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","onondo nimbale: “Pulu Yemonga bokuna ungu se i-sipa nilimú: ‘Yombomane nanga ulkamondo “Pulu Yemo kinia ungu nilimulu ulkamo.” ningí.’ kanumu. Ungu aku sipa molemo-na-kolo onone i ulkamo ‘wa nolemele yomboma lopi seko molemele ulkamo’ mele ningu pilkuli aku siku selemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yuni enamanga alieli ulka-tembelena sukundu ⸤ “Juda yombo naa molemele yomboma ‘Pulu Yemo popo tamili.’ ningu maku tolemele kolea” niringi akuna⸥ yomboma ungu-mane sirimu. Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Juda yomboma nokoringi ye awilima kinia, onone yu toko kondonge aulka se kororingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aku-na-kolo we-yombomane yunga unguma komu sendeko pilku moloringi-kulu onone yu toko kondonge aulka se naa kanoko liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Walte ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena Yesusi akuna maku toringi yomboma ungu-mane sipa, semane peangamo topa sipa molorumu kinia ye mare, Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Juda yombomanga tapu-yema kinia, ono ongo ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","yu mangilku pilku ninguli: “Nu namba nambolka nambamo likuli i kongonomo selenoye? Nawene i kongonomo “Se-pu.” nimba nu nambamo sipa lipa mundorumuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesusini onondo pundu topa nimbale: “Nane ono ungu se mangilipu piliambola. Ono mangilimbu mele onone na pundu toko niengi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","U ⸤No Lindeli⸥ Jono omba yomboma no linderimu kinia yu mulu-koleana ⸤molemo yemonga⸥ kongonomo sendembando yomboma no linderimu molo ya mana-yombomanga kongonomo sendembando yomboma no linderimuye? ⸤Nawene “Sei.” nirimu-na serimuye? Ningu siee.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","⸤Yuni aku sipa mangilierimu mele pilkuli⸥ onone onono angelema ningu ninguli: “Yuni mangilkimu mele olione pundu topo, “⸤Jono⸥ yu mulu-koleana ⸤molemo yemonga kongonomo sendembando yomboma no linderimu⸥.” nímulu liemu yuni oliondo nimbale: “Aku liemu ono Jonone nirimu ungumu nambi semu-na ‘I ungumu sika.’ ningu kuru naa mondoringiye?” nimbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Molo olione nimbuli: “Yu mana-yombomanga ⸤kongonomo sendembando yomboma no linderimu⸥.” nímulu liemu we-yombomane olio kouni toko kondonge. We-yombomane ‘Jono yu paa sika Pulu Yemone ungu-umbu tondorumumu pilipa yomboma nimba sirimu ye se molorumu.’ ningu pilielemele kene onone olio kouni toko kondonge.” ningu onono aku siku angelema niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","⸤Onono aku siku anju yando angelema ninguli⸥, Yesusindu pundu toko ninguli: “Yuni Pulu Yemonga kongonomo sendepale yomboma no linderimu, molo mana-yombomanga kongonomo sendepale yuni yomboma no linderimunje. Olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aku siku niringi kinia pilipale Yesusini onondo nimbale: “Manda. ⸤Nane ono mangilkiru ungumunga ungu se pundu toko naa nikimilimunga⸥ onone na mangilkimili ungumunga ungu se pundu topo nando i kongonomo ‘Se-pu.’ nimba na lipa mundupa namba sirimu yemonga imbimu ono naa nimbu simbula.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kanu-kinia maku toko moloringi yombomando Yesusini ungu-iku imu topa nimbale: “Ye sene unju waene kalia serimu. Ye mare kanopa lipa onondo nimbale: “Nanga kaliamo tapu sendeko unju mongoma inia toko nokondangi. Pe waene-mongo polo tomba kinia unju mongoma moke sepo, kongonomo sendenge mele mare ono liengi, mare na liembo.” nimba kanu kaliamo ono sipale yu kolea paa suluringa pumba akuna wale awisili molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kanu-kinia pe waene-mongo polo tomba serimu kinia kalia pulu yemone yunga kendemande-ye se “Nanga waene-mongo siengi pungu liku mendeko wani pu.” nimba kalia nokoringi yema moloringina lipa mundorumu. Aku-na-kolo kendemande-yemo ⸤orumu kinia⸥ kalia nokoli yemane yu wale awisili kopene toko, waene-mongo mare naa siku, ⸤ “Yemo molemona kelko pu.” ningu⸥ yando we liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kelepa kalia pulu yemone kendemande-ye se lipa ⸤ “Nanga waene-mongo lindi-pou.” nimba lipa⸥ mundorumu. Aku-na-kolo kendemande-yemo ⸤orumu kinia⸥ kalia nokoli yemane yu ambolko likuli kopene toko, seko kinjiku, waene-mongo mare naa siku yando we liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kelepa kalia pulu yemone kendemande-ye se lipa mundorumu kinia onone yu tokole kaliana ultu mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aku siku seringimunga kalia pulu yemone ⸤konopumuni pilipale⸥ ‘Kiniá na sembó mele piliporo. Nanga malo, na konopu mondolio kangomo, ono yu pipili kolko liku awi siku yu waene-mongo mare singínje.’ konopu lepale ⸤yunga malo lipa mundorumu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aku-sipa na-kolo kalia nokoli yemane kalia pulu yemonga malo ombá orumu kanokole onone onono ninguli: “Andi okomo yemo pe lapanga monge-mélema limba yemo okomo. Yu topo kondopo, i kaliamo olio kamu liemili.” ninguli ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","onone yu ambolko liku kaliana ultu mundukuli yu toko kondoringi.” ⸤nimba Yesusini nirimu.⸥ ⸤Nimbale ungu-iku akumu topa pora simbando akuna maku toko moloringi yombomando nimbale:⸥ “Kalia nokoli yemane aku siku seringimunga pe kalia pulu yemone ono-kinia nambolka unguri sembaye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yu omba kanu ye kirima topa kondopale ‘Ye marene lupa kaliamo nokondangi.’ nimba lipa simba.” nirimu. Kanu-kinia Yesusini aku sipa nirimu kinia pilkuli onone ninguli: “Pulu Yemone ‘Aku sipa wendo naa opili, paa mólo!’ nipili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusini ⸤Pulu Yemonga Juda yomboma nokoringi yemane yu toko kondonge mele pilipale⸥ onondo nimbale: “Pulu Yemonga ungu se bokuna molemomonga ungu-pulumu nambolkanje konopu lemeleye? Aku ungumu i-sipa mele: ‘Ulka takoringi yemane kanoko kiri pilku toko eltoringi kou kanumu kiniá kelepa ulka simu mele ulka enge sindeli kou awili peangamo.’ nimba molemo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","I kou ⸤nikiru⸥munga ola yombo se a topa topale bele mélema elke tomba. Aku-sipa na-kolo yombo se molombana ola koumu omba yu topale kanu yombomo topa norupulu tomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kanu-kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, Pulu Yemo popo tondoringi ye awilima kinia, ono Yesusini ungu-iku torumu kanumu pilkuli onone seko kinjiku yu toko kondonge seko moloringi mele yuni nirimu pilkuli onone kanu enamonga yu ka singí seringi-na-kolo kanu ye awilimane we-yomboma pipili kolkole yu naa liku ka siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanu-kinia ⸤Juda yombomanga ye awilimane⸥ ‘Yesusi ka sipu ⸤kote sendemolondo⸥ gapomano yemo molombana membo pumulú.’ ningu molkole yu kanoko moloringi. ‘Yuni ungu se nimba kinjimba kinia ka simulú.’ ninguli ye mare, ‘Konopu sumbi nimba pepili molemolo. Yunga ungumu konopu sipu pilipu molemolo.’ ningu kolo toko molonge ye mare, liku yu molorumuna liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kanu yemane ongo yundu ⸤kondi toko⸥ ninguli: “Ungu Mane Sílimu, olio pilipuli, ‘Nu alieli ungu sikama mindi sumbi siku ningu, ungu-mane sikama manjiku sumbi siku mane siku sekole, nu yombo seluringa kepe konopu kimbú naa siku, yomboma pipili naa kolko, onondo pali ungu selu-siku selu selu ningu siku, Pulu Yemone “Saa.” nilimú uluma paa sika unguma mane siku, aku siku seleno.’ konopu lemolo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","⸤Aku siku seko molenomonga nu nambolka konopu lekenoye?⸥ Olione Romo Gapomano Ye Paa Awili Kumbina Sisamo kou-takisi tomulu liemu manda molo móloye? Pulu Yemone akumundu ungu-mane sirimu ungu-mane nambolkamo pelemoye? Ningu si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Aku-sipa na-kolo Yesusini onone yu seko kinjingindu aku siku peké tondoko mangilieringi pilipale onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“⸤Takisi tolemele⸥ kou-mongo se na liku ora siee.” ⸤nimbale onondo kelepa mangilipa pilipa nimbale:⸥ “I kouna nawenga kumbikeremo kinia imbimu molemoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Onone yundu ninguli: “Romo Gapomano Ye Paa Awili Kumbina Sisamonga ⸤kumbikeremo kinia imbimu molemo⸥.” niringi. Kanu-kinia yuni onondo nimbale: “⸤Kou-monemo Sisamonga⸥ kene Sisamonga mélema Sisamo yuyu siku, Pulu Yemonga mélema Pulu Yemo yuyu siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yuni aku sipa ⸤paa sumbi sipa⸥ nirimu mele pilkuli ‘Olionga ungumu paa pundu topa nimba kondokomo.’ ningu pilku konopu awisili kimbu sikuli ungu se kelko naa niringi. Yomboma kanoko molangi yu peké tondoko mangilieringi kinia yuni ungu se nimba naa kinjerimumunga “Yu ka siemili.” ningí aulka se naa lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","⸤Kanu yema Yesusi kinia kou-takisi toli ungumu ningu pora siringi kinia⸥ pe Sadusi ye mare Yesusi molorumuna oringi. Sadusi yema ono ‘Pulu Yemone pe kololemele yomboma topa naa makisindimba, lomboroko ola naa molonge.’ ningu pilku moloringi talapemo. Kanu Sadusi yema ongo ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yesusi mangilku pilku ninguli: “Ungu Mane Sílimu, ⸤Pulu Yemonga ungu-manema olio sirimu ye⸥ Mosisini ungu-mane sipa nimbale: “Ambo limba ye se bolango naa membale ambomo we molopili kolomba kinia kanu yemo yunga genu molombamone yunga ambo-wayamo lipa genu lipa tapondopa bolango mendepili.” nirimu aku sipa nimba bokuna torumu molemo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","⸤Aku ungu-manemonga ulu se olionga ye mare-kinia wendo orumu mele nu mangilipu piliamili.⸥ “Genupili yopoko-pakara moloringi. Komomo ambo lipa bolango se naa membale kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","⸤Bolango se naa molopili kolorumu-kulu⸥ yunga bulkundu genumuni ⸤yunga genu kolorumumunga bolango ‘Mendambo.’ nimba⸥ ambo-wayamo kelepa liltimu. Yu bolango se naa mendepale yu we kolorumula. Yunga genu bulkundumuni kanu ambomo liltimula-na-kolo yu kepe we kolorumula. Aku selko punguli ye yopoko-pakara pali bolango selu kepe naa mengole kolko pora siringi kinia akiliumu we kolorumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pe ambomo yu kolorumula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akumunga, kololemele yomboma pe lomboroko ola molonge kinia kanu ambomo ye yopoko-pakara pali ya mana liltingi-kulu ambomo yu ye paa nawenga menu molombaye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Yesusini onondo pundu topa nimbale: “Ya mana molemele yombomanga yema ambo liku, amboma ye pungu selemele-na-kolo Pulu Yemone ‘Yombo kolkole manda lomboroko ola molko mulu-koleana pungu molangi.’ nilimú yombomanga yema ambo naa liku, amboma ye naa pungu, aku paa naa senge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kanu yomboma lomboroko ola molonge-na ono mulu-koleana molemele angelloma molemele mele aku siku molkole, kelko kolou naa kolkole Pulu Yemonga bolangoma molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aku-sipa na-kolo ⸤ono Sadusimane⸥ ‘Kololemele yomboma lomboroko ola naa molonge.’ konopu lemelemonga ungu se niembola. Mosisini olio lipa ora sirimu mele niembo: Walte Mosisi unju kanga senga ⸤sepe nomba perimu sepemone unjumu naa norumu kanopale nirimumuni,⸥ akuna yuni ⸤Pulu Ye⸥ Yawendo imbi lepa nimbale: “Eporayamo kinia, Aisake kinia, Jekopo kinia ononga Pulu Yemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pulu Yemo yu kololi yombomanga Pulu Yemo mólo. Yu yomboma pali konde molemele kanopale yu konde mololi yombomanga Pulu Yemo.” nimba Yesusini nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Aku nirimu pilkuli Pulu Yemonga ungu-manemanga puluma pilku mane siringi ye marene kelko yu ungu se mangilku pilingindu pipili kolko yundu ninguli: “Ungu Mane Sílimu, nuni papu nikinu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kanu-kinia ⸤Juda yombomanga ye awili mare aku siku we moloringi kinia⸥ Yesusini onondo kelepa ungu se nimbale: “‘Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu yu ⸤ye nokoli kingi⸥ Depitinga kalopa limba ye se molomba.’ ningu pilielemele, ⸤aku-na-kolo yu aku sipa manjipa mólo⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","⸤Aku nilimili yemane⸥ Depiti yuni yuyu ⸤kanu yemondo nirimu mele naa pilielemelenje.⸥ Depitini ⸤ye nokoli Karasimu molomba mele⸥ konane se konopumuni pilipale bokuna torumu mele i-sipa: “Ye-Awili ⸤Pulu Ye Yawene⸥ nanga Ye-Awilimundu nimbale: “‘Nunga opa-touma nuni nokani.’ nimbu, pe ono topo mania mundundumbu kene iseli-u nu ⸤na kinia pea kopu sepo ye nokolitolo molopo mélema nokambili⸥ nanga ki-lomekondo ongo molani.” nirimu.” nimba Depitini nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Depitini ⸤ye nokoli Karasimu⸥ yundu “Nanga Ye-Awilimu.” nirimu. Pe onone “Yu Depitini kalopa limba yemo ⸤mindi⸥ molomba.” nambi seko pilkuli nilimiliye?” nimba Yesusini nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesusi molorumuna yombo awisili liku maku toko moloringima pilku molangi Yesusini yu lombili andolimando ⸤liepi-liepi topa⸥ ungu se nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Onone Pulu Yemonga ungu-manemanga puluma pilku mane sili yema mimi siku kanoko kondoko ⸤onone selemele mele manda manjiku naa seko⸥ molayo. ⸤ ‘Yombomane olio kanoko “Ye peangama” niengi.’ ningu⸥ wale-pakoli paa sulu peangama, ⸤ye nokolima pakolemele mele,⸥ pakoko andolemele. Yomboma maku toko molemele koleamanga andongendo mongo-kenge seko ‘We-yombomane olio kape niengi.’ ningu pilkuli konopu siku pilku andoko molemelela. Yomboma maku toko Pulu Yemonga ungumu pilielemele ulkana sukundu punguli mania molongendo ye awilima molemele polo peanga akuna ‘molamili.’ ningu mendo pungu polo akuna konopu siku molemelela. Yombomane kere-langi nongo yombomando “Namili waa.” nilimili kinia kanu yema ongole ye awilimanga polo kumbikundu ‘olio molamili.’ ningu konopu siku molemelela. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Yema kololemele kinia onone kanu yemanga ambo-wayama toko makoroko mundukuli ulkama ‘Olionga’ ningu we limili. Pulu Yemo kinia ungu ningíndu ningu sulu munduku kolo toko nilimili. Pulu Yemone we-yomboma ulu-pulu-kiri selemelemonga ono sika “Mindili nangi.” nimbá-na-kolo ya ye nikirumane aku uluma selemelemonga Pulu Yemone aku yema “Mindili awili seko nangi.” nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesusi ⸤Pulu Yemo popo toko kaloringi ulka-tembele kerepuluna molopa⸥ ulka-tembelena sukundu kongono senge kou-mone mundoringi unju okolona nondopa molorumu. Akuna molopale yu olando-sipa kanopale ye kamakomane kanu okolona kou-mone ongo mundoringi kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","⸤Aku sipa kanopa molorumu kinia⸥ ambo-waya paa koropa se omba yu kou-kololi talo mindi mundorumu kanopa ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","nimbale: “Nane onondo paa sika nimbu sikirumu: “Andi ambo-waya koropamo yuni kou-mone mundukumumu paa olandopa mele mundukumu, we mundukumilima maniandopa mele.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ono kou-mone awisili taltolemelemanga koltalo mindi ongo mundukumili. Aku-sipa na-kolo ambo-wayamo kou-mone se paa naa taltolemo. Yunga koltalo taltomutolo pali memba omba mundomu. Kere-langi nombá se kepe naa taltolemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kanu-kinia Yesusi kinia yu lombili andoli yema kinia ono ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelemo kolea akuna molkole ulka-tembele paa peanga gilierimu mele kinia ulka-tembelemo takoringi kou paa peanga lupa lupama kinia aku koumanga au siringi mele kinia kanoko, marene ungu anju yando ningu moloringi kinia Yesusini onondo nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ya ⸤ulka-tembele peanga gilimú⸥ kanokomele mélema ⸤pe walte ya kolea-awili Jerusalleme yomboma mindili nonge walemo wendo ombá kinia⸥ i ulka-tembelemo sikisikuli kouma pali toko mania mundungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesusini aku nirimu pilkuli onone yundu mangilku pilku ninguli: “Ungu Mane Sili Yemo, nuni nikinu mele sewale wendo ombáye? Pe nuni i nikinu uluma nondopa wendo ombándo u nambolka unguri sembá kinia olione kanopole ‘Sika i wendo ombá sepomo.’ nimbu pilimulúye?” ningu mangilieringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","yuni onondo nimbale: “⸤Kanu uluma wendo ombámonga ungu mare⸥ yombomane ono kolo toko singí kene kanoko kondoko molangi. Ye awisili nanga imbi leko ongole yu-mele-mele kolo toko ninguli: “⸤Pulu Yemone ‘Nanga yomboma nokopa kondopili lipu mundumbu.’ u nimba taltorumu ye nokoli Karasi⸥ akumu na.” ninguli, “⸤Ma pora nimbá⸥ wale nirimumu wendo ombá sekemo.” ningíla. Ono lombili naa pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kolea marenga opa awili-seko senge mele pilku, yombomane ononga ye nokolima tonge pilkuli mini-wale naa mundangi. Opa sengema kinia aku uluma Pulu Yemone ‘U wendo opili. Laye-kolte pe mele ya ma-koleamo pora nimbá.’ nimba, nimba panjerimumunga aku uluma sika wendo ombá-na-kolo aku-kinia mulu matolo u naa pora nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kanu-kinia Yesusini yu lombili andolimando kelepa nimbale: “⸤Mulu ma pora nimbá walemo u wendo naa opili⸥ yombo talape awili se kinia talape awili se kinia opa seko, ye nokoli kingi marenga talapema kinia marenga talapema kinia opa sengela. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ya mana-kolea senga-senga ma jimi-jimi awili-sepa sepa, gele lepa, kuru awili-sepa topa, aku sipa sembá. Yomboma pipili awili-sepa sepa kondoli ulu-tondoloma muluna wendo ombá kanongela. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aku sipa mele ⸤pe wendo ombá-na-kolo⸥ u naa wendo opili ono nanga yomboma molongemonga ono ⸤mare⸥ liku ambolko, seko kinjingí. Ono ⸤mare⸥ Juda yomboma maku toko Pulu Yemonga ungumu pilielemele ulkamanga liku mengo pungu ⸤akuna kote sendeko⸥, ono ⸤mare⸥ ka-ulkana mengo pungu panjiku, ono ⸤mare ka siku⸥ ye nokoli kingima kinia gapomano ye awilima kinia molongena ⸤kote sendengendo⸥ mengo pungíla. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","⸤Ka siku kote sendenge kinia kotena gilkuli kanu yema kinia kanu yema nokonge ye nokolima kinia⸥ onone ‘Nanga ungumu piliangi.’ ningu, ono ningu singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Ono ka siku kote sendenge kinia ‘Ononga kerema kinia konopuma kinia tondolo pupili.’ nimbú kinia onone ningí unguma ono seko kinjingí senge yombomane onone ungu ningí mele ungu ningu pundu tongendo sundungí. Akumunga ono u ongo ka naa siengi ‘Kotena nambolka unguri nimulúnje? Olio ungu se mangilku pilingí kinia nambolka unguri pundu topo nimulúnje?’ ningu mini-wale naa mundangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ononga kandi aminieli lanieli kinia genali kinia, pulu lemba yomboma kinia, onone kepe liku ka siku kote sendekole ono mare toko kondongela. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nanga yomboma molongemonga yombomane pali ono-kinia konopu kiri panjingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aku-sipa na-kolo ononga kangina unguri naa sepa penge-indi kepe selu omba mania naa pumbá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","⸤Nanga yomboma molongemonga onone ono aku siku seko kinjingí kinia⸥ na munduku naa kelko tondolo munduku molonge yomboma mini pali konde molko kondoko mindi puli ulu-pulumu lingí.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pe walte, ami-yema i kolea-awili Jerusalleme yomboma tongendo ongo liku makaye seko molonge kanokole i kolea Jerusalleme yomboma toko mundungí walemo nondopa wendo ombá mele pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","⸤Aku siku mele wendo ombá kanokole ‘Umbuna awilima wendo ombá sekemo.’ ningu pilku⸥ kolea Judia disiriki lierimu koleamanga molonge yomboma ⸤ononga koleama munduku kelko⸥ ma-pangi lembamanga kowa pungu, Jerusalleme sukundu molonge yomboma wendo ongo kowa pungu, Jerusalleme ultu molonge yomboma kelko sukundu naa pangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aku walemanga Jerusalleme yombomane u alieli Pulu Yemo seko kinjeringimunga yuni “Ono mindili nangi.” nimbá. Koronga-u yuni ‘Walte aku sipu sembó.’ nimba, nimba panjerimu kanu ungumu yunga ye marene yunga bokuna toringi molemo kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“⸤Pulu Yemone⸥ Jerusalleme yomboma mumindili kolopale ‘Ami-yema ono-kinia mumindili kolko ongo tangi.’ nimbá kinia ulu umbuna seli awisili ono molongena wendo ombá. “Aku sipa wendo ombá kinia ambo bolango mondongema kinia, ambo bolango ame singíma kinia, ⸤ono manda lisiku kowa naa pungímunga⸥ ono-kinia paa umbuna wendo ombámonga ono kondo sekemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jerusalleme yomboma tonge walemanga yombo toli lu-pultamane yombo mare toko kondonge, mare ka siku kolea sulu lupa lupamanga mengo pungí. Juda yombomanga talapena ultu mololi yomboma ya Juda yombomanga kolea-awili Jerusalleme sukundu ongo toko munduku kolea liku kolali seko molonge. Kanu-kinia pe Pulu Yemone ‘Ononga walema pora nipili.’ nimbá kinia Juda yomboma Jerusalleme kelko ongo molonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“⸤Aku mindili nonge nikiru uluma wendo ombá kinia⸥ ena kinia óli kinia kombokandima kinia ⸤pali⸥ uluma sembá yombomane kanokole pilingí. Ma-koleana nomu-kusane ungu paa awili sepa nimba, paa awili sepa topa piki-maka lepa no tomba kanongela. Uluma aku sipa wendo ombá kinia yombo talapema mini-wale mundungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Muluna gilimú méle tondoloma lope-lope sepa anju yando pumbá kinia yomboma pipili paa awili seko kolko ‘Ma-koleana nambolka uluri wendo ombá sekemonje?’ ningu pilku konopu paa awisili kimbu singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aku uluma wendo ombá kinia Mania Omba Mana-Ye Au Lierimu Yemo tondolo púlimu kinia, tondolo pa awili-sepa sélimu kinia, kupa senga sukundu molopa, kamu mania ombá yombomane kanonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aku uluma pulu polopa sembá kinia Pulu Yemone ono ulu-pulu-kirimane ka sipa nokolemomonga mindili siku molemele koleana wendo lipa, yu-kinia kamu kopu seko manda molonge kolea peangana sukundu limba walemo nondopa wendo ombá kene aku uluma wendo ombá kinia ono ola gilku olando-siku kanangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","⸤Yesusini aku sipa nimbale nirimumuni, yu ombá walemo ‘Piliangi.’ nimba⸥ ungu-iku se topa nimbale: “Unju piki kinia we-unjuma pali kinia sindi topa gomo tolemo kinia kanokole ‘Kiniá ena sembá walemo wendo ombá sekemo lémo.’ ningu pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aku sipala i uluma “Wendo ombá.” nikiruma sika wendo ombá kinia kanokole ningímuni, “Pulu Yemo ye nokoli kingimu molomba walemo nondopa wendo ombá sekemo.” ningu pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nane onondo paa sika nimbu sikirumu: “Kiniá molemele yomboma u naa kolangi ⸤i “Wendo ombá.” nikiru⸥ uluma pali wendo ombá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mulu matolo pora nimbá-na-kolo nanga ungu niliuma paa pora naa nimbá. ⸤Niliu mele pali paa sika wendo ombá.⸥” nikiru.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Akumunga, naa kanoko molangi kanu walemo ombá paa piliaa! Lopa se yunga tapu andolemona ‘Pumbú.’ nimba olemo kinia melu leko panjilimilimu naa kanopa ‘Yu tomba.’ konopu naa lepa walu olemo kinia pe meluna waltikele tolemo, aku siku ono no-tondolo nongo amu toko we umbuna sepili molko konopu naa makiliepili molongi liemu ⸤Mania Omba Mana-Ye Au Lierimu Yemo⸥ yu ombá kanu walemo ono naa kanangi lipa sinjipa wendo ombá kene kanoko kondoko pilku molayo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aku walemo ma-koleana pali yomboma molongena wendo ombá kene ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","onone Pulu Yemo kinia mawa seko ninguli: “‘Na pe Mania Omba Mana-Ye Au Lierimu Yemonga kumbikerena pumbu ola giliambo kene na enge nipili, i ulu wendo ombámane na topa mania naa mundopili.’ ni.” ningu alieli kanoko kondoko pilku molaa!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesusini enamanga alieli-alieli ulka-tembelena yomboma ungu-mane si-pu-pu sepa, ipulieli alieli-alieli Jerusalleme ultukundunga pumba ma-pangi Unju-Ollipi Kaliana ola pumba pe-pu-pu serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yomboma pali paa orili-u ‘Yu ungu-mane simbama piliamili.’ ningu ulka-tembelena ongo maku to-pu-pu seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","⸤Juda yombomane kalia-ingi senga senga kolea-awili Jerusalleme ongo akuna sukundu⸥ Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilieringi walema, akumu imbi leko ‘Pellawa Akoli Méle Isimu Naa Munduku Pellawa We Kalko Noringi Walemo’ niringila, aku walemo nondopa wendo orumu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, onone Yesusi toko kondonge aulka se koroko moloringi-na-kolo onone ⸤ “Olio yombomane kanangi yu ka simulú kinia yombomane olio-kinia mumindili kolko iri tonge.” ningu⸥ pipili kolko we moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanu-kinia Yesusi yu lombili andoli ye rurepo akumanga ye Judasi, yunga imbi se ‘Isikeriote’ nili, kanumunga konopuna ⸤kurumanga nokoli⸥ Setene omba sukundu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","⸤Setene yunga konopuna sukundu purumu⸥ kinia yu Pulu Yemo popo tondoringi ye awilima kinia, ulka-tembelemo nokoli ele-yemanga ele-ye awilima kinia, ono moloringina pumbale, ono Yesusi ka singí aulkamo yuni akisindimba mele ono-kinia angelema niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yuni sembá mele nirimu kinia pilkuli ono konopu awili seko siku “Nu kou-mone se simulú.” ningu, ningu panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuni ononga unguma pilipale “Manda.” nimba, we-yomboma Yesusi pea naa molonge kinia yu ono lipa simba mele aulkamo koropa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pellawa Akoli Méle Isimu Naa Munduku Pellawa We Kalko Noringi Walemo wendo orumu kinia Juda yombomane Pulu Yemone u ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingindu kongi sipisipi walo se toko nonge mele pilipale nirimumuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesusini Pita kinia Jonotolo lipa mundupa nimbale: “Olo pungu, Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walo se kiniá nomolomo seko mimi se-pale.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Olone mangilku ninguli: “Sena sepo mimi se-pambili konopu leko nikinuye?” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yuni olondo pundu topa nimbale: “Piliale. Ne kolea-awili ⸤Jerusallemendo⸥ punguli, ye se mingina no kolopa memba ombá aulkana pungu kane-kane tokole, yu pumbá mele lombili pungu yu sukundu pumbá ulkana sukundu punguli ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ulka pulu yemondo ninguli: “Ungu Mane Síli Yemone i-sipa mangilipa nimbale: “Na kinia na lombili andoli yema kinia olione Pulu Yemone olionga anda-kolepalima Naa Topa We Omba Purumu mele pilimulúndu kongi sipisipi walomo sena nomoloye? Nomolo suluminiamo sena lemoye?” nimu.” niengili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aku ningilí kinia yuni olo ulkamonga olakondo suluminia awili se, akuna kere-langi noli polo se kinia, mania molomolo poloma kinia, mélema kinia akuna u lemóma, lipa ora simba. Aku suluminiamonga ⸤nomolo sipisipi walomo⸥ seko mimi sangili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kanu-kinia olo punguli, Yesusini nirimu kanu mele aku uluma seli lierimu kanoko lendekole, akuna Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingí kongi sipisipi walo nongemo kinia kere-langi nongema seko mimi seko taltoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Juda yombomane ipupini kolea kalá torumu kinia Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu Walemo pilingindu kongi sipisipi walomo nonge enamo kamu wendo orumu kinia, Yesusi kinia yunga kongonomo ‘sende-paa.’ nimba lipa mundorumu yema kinia ono kere-langi noli polona moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kere-langi nongo moloringi kinia yuni onondo nimbale: “‘Na mindili u naa nombole i wale wendo okomomonga kere-langima ono kinia pea namili.’ paa tondolo mundupu konopu lepo andopo molorundu mele yandopa paa konopu lepo pilipu molio. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nane onondo i-sipu nimbu sikirumu: “Iseli-u i kere-langima na kelepo naa nombó. Pulu Yemo ye nokoli kingimu kamu molomba walemo wendo ombale i kere-langimanga sika ulu-pulumu wendo ombá kinia kelepo nombó.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Yu no-waene kapomo lipa ambolopale Pulu Yemondo “Ange.” nimba onondo nimbale: “Imu ono onono moke seko nayo. Nane onondo i-sipu nimbu sikirumu: “Iseli-u na no-waene kelepo paa naa nombó. Pe mindi, Pulu Yemo ye nokoli kingimu molopa nokolemo walemo wendo ombá kinia na no-waene kondemo kelepo nombó kene ⸤ono onono iseli-u nangi⸥.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Berete se lipa Pulu Yemo kinia “Ange.” nimbale ambolopa pike lepa ⸤yu lombili andolima⸥ sipa nimbale: “Imu nanga kangimu ⸤ono liku nangi⸥. Nanga kangimu ‘ononga’ nimbu simbú sekeromo imu. Pe-pe kepe, kiniá ‘ononga’ nimbu sendembo sekero mele ‘Kelepo piliamili.’ ningu i beretemo “Nanga kangimu.” nimbu sikiru mele ono aku siku berete se nongole liku manjangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pe ono kere-langima nongo pora siringi kinia yuni ⸤berete se kinia serimu mele⸥ aku sipala no-waene kapomo lipa ⸤ono sipa⸥ nimbale: “I ⸤no-waene⸥ kapo ⸤ono sikirumu⸥ nanga mememo. ⸤Pulu Yemone ‘Ono-kinia sembó.’ nimba,⸥ ungu se nimba panjipa mi lierimu kanu ungumu ‘Kamu wendo omba pepili.’ nimbu nane ononga nimbu nanga mememo ondondopole ⸤kolombo⸥ aku mememo i no-waenemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aku-sipa na-kolo na lipa nanga opa-touma simba yemo na kinia pea i kere-langi nokomolo polona molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kiniá Mania Omba Mana-Ye Au Lierimu Yemo-kinia senge mele Pulu Yemone koronga-u nimba panjerimu mele sika opa-toumane senge, aku-na-kolo yu lipa opa-touma simba yemo mindili nomba molopa kinjimba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aku nirimu kinia pilkuli ⸤yu lombili andolimane⸥ anju yando mangilku ninguli: “Olionga ye nawene ulu akumu sembanje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aku walemo kinia ungu se pea wendo orumula. ⸤Yesusi lombili andolimane⸥ ono onono anju yando angelema ningu ninguli: “Olionga ye nawe paa olandopa molemoye?” ningu keru-kuru liku moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesusini onondo nimbale: “Olio Juda yombomanga ultu molemele yombo talapemanga ye nokolima ononga yomboma tondolo munduku nokoko kongono enge nilima alieli silimili. Ye imbi ola molemo yema ononga yomboma ‘Mindili nangi.’ ningu nokolemele yemane ono onono imbi ambolko paka toko, “Olio yomboma nokopo kondopo lipu tapondoli yema.” nilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aku-sipa na-kolo ⸤we-yombomanga ye nokolimane ononga yomboma tondolo munduku nokolemele mele na lombili andoli yema⸥ ono onono aku siku anju yando naa sangi. Ononga ye se imbi ola molomba kinia aku yemo ye koropa mele molopili. Ye nokoli molopa we-yema nokomba yemo kendemande-yemo mele molopa we-yemanga kongono sendepili.” ⸤nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ye nawe paa ye olandopamoye? Kere-langi nolemo yemo ye olandopamo molo kere-langi peke topa kalopa pellete kulumiye topa aku kongonoma sendelemo yemo ye olandopamoye? Kere-langi nolemo ye akumu ye nokolimu lémo. Aku-sipa na-kolo na aku sipa mólo. Na ⸤sika ononga ye awilimu⸥ na-kolo ononga kongono sendeli kendemande-yemo mele molopo ono lipu tapondoli yemo molio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","⸤Yesusini yu lombili andoli engaki rurepondo kelepa nimbale:⸥ “Na umbuna membo mindili nombo molorundu kinia ono na-kinia pea kopu sepo mindili sipu molorumulula. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nanga Lapa ye nokoli kingimu omba molopa yomboma nokomba kinia nando ‘Akuna yomboma nokondopilila.’ nilimú nimbá mele nane onondo ‘Akuna yomboma nokondangi.’ niliu nimbúla. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Akuna na ye nokoli kingimu molopo yomboma nokombo kinia ono na kinia pea kere-langi polona molopo ga nombo molomolo. Ono ye nokoli kingi polomanga molkole ningímuni, Isirele yombo talape rurepo nokonge.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","⸤Nimbale, Yesusini lombili andoli ye Pitando nimbale:⸥ “Saimono, pílie! ⸤Kurumanga nokoli⸥ Setenene Pulu Yemondo mawa sepa nimbale: “Ono seko kinjingínje manda manjipu kondi topo kanambo.” nirimu kinia Pulu Yemone “Manda.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Aku-sipa na-kolo Saimono, nane Pulu Yemo kinia ungu nimbu nunga mawa sendepo nimbuli: “Setene yuni nu aku sembá kinia Pita yuni na naa mundupa kelepa na pilipa molopili.” nindu. Saimono, Setene kanga-kolte pilku na munduku kelkole, pe konopu topele toko na kelko kuru mondoko molkole ninimuni, genalima konopu tondolo mundundou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aku-sipa na-kolo Pitane nimbale: “Ye-Awilimu, nane nu pe siye kolopo kowa lepo pumbú ningu nikinuye? Manda mólo. Olto pea “Ka siemili.” níngi liemu peangala. Molo olto pea “Topo kondamili.” níngi liemu unguri mólo. Pea kolambili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusini Pitando nimbale: “Pita, nane nundu i-sipu nimbu sikirumu: “Kiniá kera gulta u ko naa topili nuni pipili kolkole wale yopoko nando kolo toko “Yu nawe? Na naa kanolio.” nini.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nimbale Yesusini yu ye ⸤rurepondo⸥ pali kelepa nimbale: “Nane ono u ⸤ ‘Kongono se-pangi.’ nimbu⸥ lipu mundorundu kinia ‘Kou naa mengo, méle-wale naa mengo, topele toko mondonge kimbu-su naa mengo, we pangi.’ nimbu lipu mundorundu kinia ono mélse mólo torumu molo móloye?” nimba mangilipa pilierimu kinia onone “Méle selu kepe mólo naa torumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yuni onondo kelepa nimbale: “Aku-sipa na-kolo kiniá na-kinia uluri wendo ombámonga, kou-mone taltolemo yemo kanu kou-monemo lipa ambolopa, méle-wale taltolemo yemo kanu walemo lipa ambolopa, aku siku seko molangi. Opa seli lu-pulta naa taltolemo yemo yunga wale-pakoli se anju sipa lu-pulta se yando lipili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","⸤Nane aku sipu nambi semu-na nikiru, niembo.⸥ U yombomane nando ningu Pulu Yemonga bokuna toringi molemo mele kiniá wendo ombá sekemo mele i-sipa: “Yu kinia, yombo mongo liku ulu-pulu-kirima seli yomboma kinia, liku sere leko kopu senderingi.” niringi bokuna molemo kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yuni aku nirimu mele pilku sundukuli onone yundu ninguli: “Ye-Awilimu, ya opa seli lu-pulta talo taltolemolo kanou.” niringi kinia yuni onondo nimbale: “Ungu manda nimbu, ⸤pamolo.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kanu-kinia Yesusi ⸤ulkamo mundupa kelepa kolea-awili Jerusalleme⸥ ultukundu pumbale nirimumuni, yu alieli ma-pangi Unju-Ollipi Kaliana ola pu-pu-pu serimu mele akuna purumu. Yu lombili andolima yu lombili akileko pea puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akuna purumu kinia yuni yu lombili andolimando nimbale: “⸤Kurumanga nokoli⸥ Setenene ‘Olio kondi tomba kinia sepo kinjimulú kene’ ninguli Pulu Yemo kinia ungu ningu mawa seko molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nimbale yu yuyu kanga-kolte anju pumba komorongo langopa, Pulu Yemo kinia ungu nimba mawa sepa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, na mindili noli no-mingina no nombómo ‘Naa nambo.’ konopu lienu liemu aku siku sani-na-kolo ‘Nane sepole nanu konopu simbú.’ konopu lekero mele naa sambo. Nuni kanoko peanga piliení ulumu mindi sambo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aku nirimu kinia angello sene mulu-koleana mundupa kelepa Yesusi yu molorumuna omba ‘Yu konopu tondolo pupili.’ nimba serimu mele Yesusini yu kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kanu-kinia yu konopuna umbuna awili-sepa sepa, kameléna mindili sepili molopale yu Pulu Yemo kinia tondolo mundupa ungu nimba mawa serimu-na yunga kangina kúru omba kanu kúrumu meme none sepa mana mania purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yu Pulu Yemo kinia aku sipa ungu nimbale ola gilipa yu lombili andoli yema moloringina yando omba onone yu kondo kolko molkole uru peringi kanopale ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","onondo nimbale: “Ono uru nambi semu-na pekemeleye? ‘⸤Kurumanga nokoli Setenene⸥ olio kondi tomba kinia sepo kinjimulú kene’ ninguli ola molko Pulu Yemo kinia ungu ningu mawa seko molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesusini aku nimba molopili ono moloringina ye awisili oringi. Oringi yemanga se kumbi lepa orumu yemo yu ye Judasi, Yesusi lombili andoli rureponga ye se. Judasi yu Yesusi molorumuna nondopa omba yu kangulorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aku serimu kinia Yesusini yundu nimbale: “Judasi, opa-tou yemane Mania Omba Mana-Ye Au Lierimu Yemo ‘kanoko imbi siku ka siengi.’ ningu nuni na kangulkunuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kanu-kinia Yesusi pea kopu seko gilieringi yemane yu-kinia ulu se wendo ombá serimu mele kanokole onone yundu ninguli: “Ye-Awilimu, opa seli lu-pultamane i yema tamiliye?” niringi kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ononga ye sene ⸤yunga lu koyamo lipa ambolopale⸥ Pulu Yemo popo tondoringi ye awili olandopamonga kendemande-ye senga komumu topa laká lierimu kinia komumu omba mania purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aku serimu kanopale Yesusini yundu nimbale: “Kiniá manda, keliee!” nimbale torumu yemonga komumu lipa ambolopa tambu sinderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesusi ka singí oringi yema i-sipa: Pulu Yemo popo tondoringi ye awili mare kinia, ulka-tembelemo nokoko moloringi ami-yema nokoringi ye mare kinia, Juda yombomanga tapu-ye mare kinia, onone Yesusi ka singí oringi kinia kanopale onondo nimbale: “Na ‘yombo topo wa noli yere molemo.’ konopu lekole lu-pultama kinia kopema kinia mengo okomeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ulka-tembele kerepuluna alieli ono pea molemolo kinia na ambolko liku ka naa silimili kanumu. Aku-sipa na-kolo kiniá i ena wendo okomomo Pulu Yemone u ‘Ononga.’ nirimu enamo wendo okomo. Simbulu tolimunga tondolomo kiniá olandopa pelemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kanu-kinia onone Yesusi ka sikuli Pulu Yemo popo tondoringi ye awili olandopamonga ulkana sukundu mengo puringi. Yesusi mengo puringi kinia Pita lombili akilepa taka lepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yesusi mengo oringi ulka kanumunga ulka gilipa makapu serimu, sukundu we lierimuna sepe kalko pilku moloringina Pita pumba ono kinia molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yu akuna molopili ⸤Pulu Yemo popo tondoringi ye awili olandopamonga⸥ kendemande-ambo se omba sepe nomba pa serimuna Pita molorumu kanopale yu neme-neme nimba kanopa nimbale: “I yemo Yesusi kinia pea moloringili kanorundu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aku-sipa na-kolo Pitane kolo topa nimbale: “Ambomo, aku nikinu yemo na naa kanolio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Laye-kolte pe mele ye se Pita kanopa yundu nimbale: “Nu Yesusinga talape ye se lepomo.” nirimu kinia Pitane yundu nimbale: “Yemo, na akumu mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pe ena-mongo selu mele omba purumu kinia yombo se ⸤Pita yu ungu laye-kolte lupa mele nirimu mele pilkuli⸥ yuni tondolo mundupa nimbale: “Kolea Gallilli disiriki yombomane ungu nilimili mele yu aku sipa ungu nikimu pilkiru. ⸤Yesusi kinia yu lombili andoli yema kinia kolea Gallilli disiriki yemala,⸥ yu kepe Gallilli ye se, aku kene ‘Yu paa sika Yesusi lombili andoli ye se.’ konopu lekero.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aku nirimu kinia Pitane yundu nimbale: “Yemo, nu nikinu mele na paa naa pilkiru.” nirimu. Aku sipa nimba molopili kera gulta ko torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kanu-kinia Yesusini topele topa Pita kanorumu kinia Yesusini yundu “Kera gulta u ko naa topili nuni wale yopoko kolo tokole “Yu naa kanolio.” nini.” nirimu ungu kanumu Pita kelepa pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pilipale ⸤ ‘Ama, paa sepo kinjendu lepomo. ‘Paa naa sembó.’ konopu lierindu mele sika sendu.’ nimba pilipale⸥ pena pumba kola paa awili-sepa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kanu-kinia Yesusi akuna nokoko moloringi ele-yemane yu ungu-taka tondoko, yu laruwa toko, seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yunga kumbikeremo mulu-maminia sene pipi sindikuli ki-lumuni toko ⸤ “Nu ‘Pulu Yemonga yere molio.’ konopu leno kene⸥ nawene nu tokomonje ningu si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ungu-taka tondongendo onone yu aku mele ulu awisili seko ungu awisili ningu yu aku siku seko kinjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kolea tangorumu kinia Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, kanu Juda yombomanga tapu-ye kanjolloma pali ‘Yesusinga kote piliamili.’ niringi. ⸤Ononga ele-yemane⸥ yu ono liku maku toko moloringina mengo puringi kinia onone yundu ninguli: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pulu Yemone olio “Nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu sika nu molo móloye? Ningu si.” niringi. Yuni onondo nimbale: “ “Na akumu molio.” nilkanje onone naa pilku “Kolo tokono.” nilimolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nane onondo ungu se mangilipu pilkanje yando ungu se naala nilimolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aku-sipa na-kolo Mania Omba Mana-Ye Au Lierimu Yemo kiniá kepe pe-pe kepe tondolo pali pelemo Pulu Yemo ⸤kinia mélema nokombando⸥ yunga ki-lomekondo molomba.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Onone pali yundu ninguli: “Nu “Pulu Yemonga Malo molio.” ningu nikinuye?” niringi kinia yuni nimbale: “Akumu na molio.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Onone ninguli: “Yuni mongo liltimu mele nimba simba yombo se pea nambi semu-na koromoloye? Yuni yuyu nimba kinjikimu pilkimulu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aku ninguli Juda yombomanga ye awilima pali ono ola gilku Yesusi liku mengo pungu ⸤Romo gapomano ye nokoli⸥ Paillate molorumuna mengo pungu kote senderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yu kote sendeko Paillatendo ninguli: “I yemone nimbale: “Romo gapomanomone olio Juda yomboma naa nokopili.” nimba, “Romo Gapomano Ye Paa Awili Kumbina Sisamo kou-takisi naa tangi.” nimba, “Yu yuyu “Pulu Yemone olio nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu, ye nokoli kingimu molio.” nimba molemomo olio pilipu kanolemolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ono aku siku niringi kinia pilipale Paillatene ⸤Yesusinga kotemo⸥ yu mangilipa pilipa nimbale: “Nu Juda yombomanga ye nokoli kingimu molenone molo móloye?” nirimu. Yesusini pundu topa nimbale: “Sika nikinu. Akumu na.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yuni aku nirimu kinia pilipale Paillatene Pulu Yemo popo tondoringi ye awilima kinia, we-yomboma akuna liku maku toringima kinia, onondo nimbale: “I yemo ulu se naa sepa kinjemu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aku-sipa na-kolo onone ta ningu tondolo munduku ninguli: “Yuni ungu-mane sipale “We-yomboma ulu seko kinjiku, mongo liku sangi.” nimba mane sirimu. Yuni u-pulu-pulu kolea Gallilli disiriki ungu akumu mane sipa, pe yandopa kolea Judia disiriki koleama pali silipa andopale, pe kamu ya kolea-awili Jerusalleme omba ungu akumu mane sipa molemo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kolea Gallilli” niringi kinia pilipale Paillatene onondo mangilipa pilipa nimbale: “I yemo yu Gallilli ye seye?” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","onone “E.” niringi pilipa yuni nimbale: “⸤Ye nokoli kingi⸥ Erote, Gallilli disiriki nokolemo yemo, Yesusinga kotemo yuni piliepili yu molemona mengo paa.” nirimu. Aku walemonga kanu ⸤ye nokoli kingi⸥ Erote yu Jerusalleme omba molorumu-kulu pilipale, “Yu molemona mengo paa.” nirimu. ⸤Paillate yu Jerusalleme lierimu kolea Judia disiriki nokorumu yemo.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erote ⸤molorumuna mengo puringi kinia⸥ yu Yesusi kanopale konopu sirimu. Yu Yesusini ulu serimu mele ungu awisili pilipale, ‘Kanu yemo kanamboa!’ nimba molopa, ‘Yuni ulu-tondolo se sepili kanamboa!’ konopu lepa molorumu-kulu yu orumu kinia kanopa konopu sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Akumunga, Erotene Yesusi ungu awisili mangilipa pilierimu-na-kolo Yesusini ungu se pundu topa naa nimba we molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pulu Yemo popo tondoringi ye awilima kinia, Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia, akuna gilku onone Erotendo ninguli: “Yesusini i-sipa ungu nimba kinjipa, i-sipa ulu awisili sepa kinjipa molemo.” ningu tondolo munduku niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kanu-kinia Erote kinia yunga ami-yema kinia onone ‘Yesusi yu ye nokoli mólo, yu we-yere.’ ningu ye nokolimane pakolemele mulu-maminia komindi se liku pakondoko, yu ungu-taka tondoko tawe senderingi. Kanu-kinia Paillate molorumuna Erotene Yesusi lipa yando mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Paillatene Erote molorumuna Yesusi u naa lipa mundopili Paillate kinia Erote olo opa-tou moloringili. Aku-sipa na-kolo Yesusi-kinia aku seringili walemonga pe olo genungulu mele moloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesusi Paillate molorumuna yando mengo oringi kinia Paillatene Pulu Yemo popo tondoringi ye awilima kinia, Juda yombomanga tapu-yema kinia, we-yomboma kinia, onondo “Waa.” nimba nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Onone “Ye sene yombomando ‘Romo gapomanomone olio naa nokopili. Ono-kinia opa sepo topo makoramili.’ nimba peke tondopa yombomanga konopuna ulku tondopa molemo.” ningu ye se ka siku nanga kotena mengo ongo kote sendelemolá mele i yemo aku siku mele mengo ongo kote sendekemele. Kanu-kinia ono kanoko molangi nane kote pilipuli onone ‘Yu sepa kinjerimu.’ níngi mele na ulu se naa pilkiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","⸤Gallilli disiriki ye nokoli kingi⸥ Erote, yu pea i yemo ulu se sepa kinjerimu se naala pilipale yu kelepa yando mundomu. Pilkimiliye? Yu ulu se sepa naa kinjemu. Yu we nambi semu-na topo kondomoloye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ulu se sepa naa kinjemumunga nane yu we kopene topole “Kelko pu.” niembo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","(Kolea-awili Jerusalleme sukundu ye se, yunga imbi Barapasi, ⸤yu kinia ye mare kinia⸥ ‘Romo-gapomanomone olio Juda yomboma naa nokopili.’ ningu u Romo-gapomanomo kinia opa sekole yombo mare toko kondoringimunga yu ka siringi. ⸤Romo-gapomanomonga ka-ulkana kanu ye Barapasi we pepili Juda ye awilimane Yesusi kote senderingi⸥. Juda yombomane kalia-ingi senga senga kolea-awili Jerusalleme ongo akuna sukundu Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilieringi walemo wendo orumu kinia Romo gapomano ye awilimuni ka-ye se ka-ulkana wendo lipa mundupa “Pu.” nirimu.) ⸤Aku sipa serimu mele pilieringimunga Paillatene “Yesusindu “Pu.” niembo.” nirimu kinia pilkuli⸥ onone pali yundu tondolo munduku ninguli: “I yemo mólo. Yu ⸤kolopili⸥ mengo punguli, Barapasi, ⸤ka-ulkana⸥ wendo liku si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Paillatene ‘Yesusi we pupili.’ nimbale onondo ungu se pea nirimu-na-kolo onone yundu wale awisili tondolo munduku ninguli: “Yu kolopili unju-perana uku toko panjei!” ningu moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aku niringi kinia yuni onondo kelepa wale yopoko-sipa mangilipa nimbale: “Aku nambi semuye? Yu mongo nambolka mongore limuye? Yu ulu se sepa naa kinjemu. Yu we nambi semu-na topo kondomoloye? Nane yu we kopene topole “Kelko pu.” niembo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aku-sipa na-kolo onone ta ningu ungu tondolo munduku ninguli: “Yu kolopili unju-perana uku toko panjei!” niringi kinia onone tondolo munduku niringi mele pilipale Paillatene ono niringi mele sembá serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanu-kinia Paillatene kote pilipale onone yu-kinia “Paa sei.” ningu ta ningu mawa seringi mele ‘Aku sipa sepili.’ nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","⸤ye Barapasi,⸥ ‘Romo-gapomanomone olio Juda yomboma naa nokopili.’ nimba u Romo-gapomanomo kinia opa sepale yombo mare topa kondorumumunga ka-ulkana perimu kanu yemo, wendo lipa ono sipale nirimumuni, pe onone ‘Yesusi unju-perana kolopili.’ niringi mele pilipale “Yu-kinia aku sipa wendo opili.” nimba ami-yema sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","⸤Romo ami-yemane⸥ Yesusi mengo pungí punguli niringimuni, kolea Sairini ye se, yunga imbi Saimono, yu Jerusalleme pumbá orumu kinia kanoko yu ambolko liku ka mele siku Yesusi kolomba unju-peramo liku pendokona ola taltondokole “Imu mendeko yu lombili akileko pu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yombo awisili yu lombili puringi. Ambo mare yu toko kondongemonga kola selko puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kanu-kinia Yesusini topele topa kanu ambomando nimbale: “Jerusalleme amboma, ono na kolombomonga pilkuli kola naa sangi. Ono onono kinia ononga bolangoma kinia ulu pe wendo ombámonga pilkuli kola sangi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aku sipu nikirumu, nambi semu-na nikiruye? Niembo: Walte ono Jerusalleme yomboma ⸤seko kinjiku mongo limilimunga umbuna singí⸥ walemo wendo ombá kinia ono kinia ononga bolangoma kinia mindili nonge kinia yombomane ninguli: “Ambo bolango se naa mengo, bolango ame naa siku, simbu molemele amboma, ononga bolango se mindili nombá ono naa kanongemonga ono maloya.” ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pe ‘yomboma kelko mulu awili pololemomando “Ma ange topa olio topili.” ningu, ma-pangimando “Ma ange topa olio aki topili.” ningí.’” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","⸤Nimbale pe kamu ungu-iku se topa onondo nimbale:⸥ “Unju konde gilimúmu peke tokomele. Aku liemu pe unju kololimu nambi sengeye? Akumunga ⸤onone ono aku siku umbuna singí, mindili nonge⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye talo pea ‘Yesusi-kinia kolangi.’ ningu unjuna ola uku toko panjingindu mengo puringi. Aku yetolo mongo liltingili yetolo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kolea ‘Penge Bele’ nilina oringi kinia yu kinia mongo liltingili yetolo kinia unju-pera yopokonga ola uku toko panjeringi. Mongo liltingili yetolonga se Yesusi yunga ki-lomekondo uku toko, se Yesusi yunga ki-tarokondo uku toko panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aku seringi kinia Yesusini nimbale: “Tata, na-kinia sekemele mele yombomane naa pilkimili kene nuni sekemelemonga “Mindili nangi.” naa ningu siye kolou.” nirimu. ⸤Aku sekole, u unjuna ola uku toko naa panjikuli⸥ yunga mulu-maminia ⸤kulunduku taltoringima⸥ ‘Moke samili.’ ningu ono yu-mele-mele lingí mele pilingindu kou-kate seko pe mulu-maminiama liltingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","We-yomboma onone yu seringi mele kanoko we gilieringi-na-kolo ononga ye awilimane yundu ungu-taka tondoko ninguli: “Yu yombo wema ‘Naa kolko konde pangi.’ nimba lipa tapondorumu mele kiniá yuni ‘Naa kolopo unju-perana wendo pambo.’ nimba yu yuyu lipa tapondopa unju-perana wendo opili. Yu sika Pulu Yemone nimba taltopa olio ‘Nokopa kondopili.’ nimba lipa mundorumu ye nokoli Karasimu omba molomu liemu kiniá yu yuyu aku sipa lipa tapondopili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ami-yema pea yu ungu-taka tondoko molkole no-waene kombili seli se ‘Nopili siemili.’ ningu singi sekole ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yundu ninguli: “Nu Juda yombomanga ye nokoli kingimu molonu liemu ‘Naa kolopo unju-perana wendo wambo.’ ningu nu nunu liku tapondou.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","‘Yu mongo liltimu mele yomboma kanangi.’ ningu I YEMO JUDA YOMBOMANGA YE NOKOLI KINGIMU ningu imbi toko unjuna ola mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mongo liltingili yetolo unju-perana ola uku toko panjeringi yetolonga sene Yesusindu ungu-taka tondopa nimbale: “Nuni “Pulu Yemone nimba taltopa olio ‘Nokopa kondopili.’ nimba lipa mundorumu ye nokoli Karasimu ⸤molio.” nilinu mele sika molo móloye? Sika aku siku⸥ moleno liemu nu kinia olto kinia pea ‘Naa kolamili.’ ningu liku tapondoko unju-perana wendo li.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aku-sipa na-kolo mongo liltingili yetolonga sene yuni nirimu mele pilipale yu iri topa nimbale: “Nu kinia yu kinia selu-siku mele mindili nongo kolongele mele siengimunga Pulu Yemo pipili naa kolkonoye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu-kinia olto sepo kinjerimbulumunga mindili papu síngi. Aku-sipa na-kolo i yemo yu mongo se naa liltimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aku nimba yuni ⸤Yesusindu⸥ nimbale: “Yesusi, nu ye nokoli kingimu molko mélema nokokole ninimuni, na piliei.” nirimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesusini pundu topa yundu nimbale: “Nane nundu paa sika nimbu sikirumu: “Kiniá nu na-kinia pea Yomboma Molko Kondolemele Kolea Peangana pumbu molombolo lémo.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yesusi unju-perana ola we pepili awi-tangoli ena tuwellepo killoko serimu kinia kolea pali simbulu topale pe ipupini ena tere killoko kinia ena kelepa topa kolea tangorumu. ⸤Ulu-awili se waltikele wendo orumula. Pulu Yemo popo toko kaloringi⸥ ulka-tembele ⸤Jerusalleme sukundu gilierimu akuna sukundu Pulu Yemo molorumu⸥ suluminia paa kake sélimunga kerepuluna ⸤ ‘Yomboma sukundu naa pangi.’ ningu u alieli⸥ mulu-maminia awili sene pipi siku panjeringi gilierimu. Kanu mulu-maminiamo awi-suku-singina olá torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesusini ungu se tondolo mundupa nimbale: “Tata, nanga minimu ‘Nu molenona opili.’ nimbu nu sikiru.” nirimu. Aku nimbale yu kolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","⸤Romo⸥ ami-ye wane anderete nokorumu ye se Yesusi toringi ami-yema nokopa molorumu kanu yemone Yesusi ungu se nimba kolorumu mele pilipa kanopale yuni Pulu Yemo kape nimba nimbale: “I yemo yu paa sika ye konopu sumbi nili se lepomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kanu-kinia ‘Yu unju-perana uku toko panjingí kanomolo.’ ningu u liku maku toringi yomboma yu serimu mele kanoko bulu-balu ningu ungu awisili konopu kimbu siku kondo kololko ulkando puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yu-kinia u kopu seko andoringi yema kinia, kolea Gallilli disiriki munduku kelko yu lombili andoko ⸤Jerusalleme⸥ pea oringi amboma kinia onone ⸤yu-kinia seringi kolorumu mele⸥ sulu seko kanoko gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yesusi kolorumu kinia ye se, yunga imbi Josepo, yu Juda yombomanga kanjollo ye awili se molopa, ungu peangama manjipa sepa molorumu. Yu konopu sumbi nili ye se, kolea Judia disiriki Arimatia taono yemo. Yu ‘Pulu Yemo ye nokoli kingimu molopa olio nokomba walemo wendo opili.’ nimba nokopa molorumu yemo. Yu Juda yombomanga kanjollomo sika molorumu, aku-na-kolo kanjollo yemane ⸤u ono onono kote pilkuli⸥ “Yesusi kolopili.” niringi kinia yuni “E.” naa nimba we molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kanu yemone ⸤Romo gapomano ye nokoli⸥ Paillate molorumuna pumbale “Yesusinga ónomo na si.” nimba mawa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paillatene “Manda.” nirimu kinia Josepo pumba ónomo mania lipa, mulu-maminia konde sene lipa okopale, kou-kande senga memba pumba sukundu taltorumu. Kanu kou-kandena yombo-óno se u naa taltoringi, yu mindi pulu-pulu taltorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yesusi óno serimu wale akumu kiniá mele, opali mele ⸤koro moloringi⸥ wale Sambatemo nondopa wendo ombá serimu. Sambate walemo wendo ombá kinia koro molongendo kiniá mele, mélema liku undu-undu siringi walemo wendo orumu, aku walemonga Yesusi óno seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","U Yesusi kinia kolea Gallilli disiriki munduku kelko yu pea ⸤Jerusalleme⸥ oringi amboma Josepone Yesusi óno serimu kou-kandemo kanoko akuna sukundu ónomo taltorumu mele neme-neme ningu kanokole niringimuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","pe kanoko pora sikuli yando ongo, ‘Yunga ónona wambolama kinia méle lupa muna tolima kandondamili.’ ningu seko mimi seringi. Aku-sipa na-kolo Sambate walemo wendo orumu kinia Pulu Yemonga ungu-manemone ‘Sambate wale kinia koro molangi.’ nirimu mele pilku likuli méle seko mimi seringi mélema sumbi siku óno-koleana naa mengo pungu we taltoko koro moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","⸤Ononga koro moloringi⸥ wale Sambatemo pora nimba, pulu-pulu kongono walemo wendo ombándo kolea tangomba muni lierimu kinia amboma wambola muna toli u seko taltoringima liku mengo pungu, ⸤Yesusinga⸥ ónomo taltoringi kou-kandena mengo puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Akuna punguli kou-kande kerepulumu pipi siringi koumu perele-marele pumba welkendo lierimu kanokole, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","sukundu puringi kinia akuna Ye-Awili Yesusinga ónomo u lierimuna naa lierimu kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanu-kinia ‘Ónomo nambi semunje?’ ningu konopu kimbu siku moloringi kinia ye talo kariapá sepale pa selemo mele seli wale-pakoli pakoringili yetolo ono moloringina gilieringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kanokole amboma mini-wale munduku tamalu peringi kinia yetolone onondo ninguli: “Konde molemomo, ya óno-koleana nambi semu-na korokomeleye? ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yu ya naa lemó. Lomboropa ola molopa wendo pumu.” ⸤niringili.⸥ “Yu ⸤ono-kinia⸥ kolea Gallilli molopa onondo nirimu mele piliayo. Yuni nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“⸤Juda yombomanga ye awilimane⸥ Mania Omba Mana-Ye Au Lierimu Yemo liku talape lupa yombo ulu-pulu-kiri selima yu liku singí, onone yu unju-perana kolopili uku toko panjingí kinia kolopale wale yopoko-sipamonga lomboropa ola molomba.” nirimu kanumu.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kanu-kinia Yesusini u aku nirimu mele ambomane kelko pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kou-kandemo munduku kelko, kelko yando ongole niringimuni, lombili andoli rureponga yopoko kinia akuma pea moloringi yomboma kinia onondo pilku kanoringi mele semane toko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kolea Makatalla ambo Maria keme, ambo Joana keme, Jemisi anumu Maria keme, ono pea puringi amboma keme, kanu ambomane Yesusini u “Nanga kongonomo sende-paa.” nimba lipa mundorumu ye rureponga yopoko aku semanemo toko siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aku-sipa na-kolo ambomane niringi ungumu pilkuli ‘Ono kolo tokomele.’ ningu pilku kuru naa mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","⸤Ambomane niringi unguma kuru naa mondoringi⸥-na-kolo Pita ola gilipa ónomo taltoringi kou-kandena kanombando lisipa pumba, wake sepa kanopa Yesusinga ónomo okoringi mulu-maminiama manjipa akuna we lierimu kanopale konopu awisili kimbu sipa ‘I nambolka unguri semunje?’ nimba pilipa yando orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yesusi lomboropa ola molorumu aku walemonga ⸤yu lombili andoringi yombomanga⸥ yombo talo kolea-kanga Emeasi pungilí puringili. Aku kolea-kangamo kinia kolea-awili Jerusalleme kinia aulkamo laye-kolte sulu mele, illepene killomita mele. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Olone Yesusi kolorumumundu anju yando angelema niliku puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aulkana aku ulumando angelema niliku pangili Yesusi yuyu olo puringilina omba olo kinia kopu sepa purumu, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","aku-na-kolo Yesusi yu ‘We-ye lupare okomo konopu leangili.’ nimbale serimu, olone yu naa kanoko imbi siringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yuni olo mangilipa nimbale: “Olo nambolkamondo angelema niliku pukumbiliye?” nirimu. Olo Yesusi toringi kolorumumunga nono ningu we gilieringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Senga imbi Killopasi, akumuni yundu mangilipa nimbale: “Jerusalleme sukundu talko ulu wendo orumuma nu naa kanorunuye? Yombo awisili akuna ongo maku tokole kanoringi-na-kolo nu pea naa molko kanoringi. Senga lupa molkole okono lepomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Orumu yemone “Nambolka ulumaye?” nirimu. Olone ninguli: “Kolea Nasarete ye Yesusinga ulu kanuma.” niringili. “Yesusi yu Pulu Yemone ungu-umbu tondolima pilipa yando nimba sili ye se molopale Pulu Yemo kinia olio mana-yomboma kinia kanopo molamili ungu tondoloma nimba ulu tondoloma serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanu-kinia olionga ningu Pulu Yemo popo tondoli ye awilima kinia olio nokolemele ye awilima kinia ‘Yu kote pilku “Kolopili.” ningu tangi.’ ningu ⸤Romo gapomano yema⸥ anju siringi onone ‘Yu kolopili.’ ningu unju-perana uku toko panjeringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aku-sipa na-kolo olio pilierimulu, ‘Yu Pulu Yemone lipa mundorumu, ⸤Romo gapomano yombomane olio⸥ Isirele yomboma ⸤tondolo munduku nokolemelemonga⸥ mindili nombo umbuna sepili molemolomonga olio lipa tapondopa ⸤ononga kína⸥ wendo lipa ‘Molko kondangi.’ nimba ⸤kolali sepa⸥ olionga ye nokoli kingimu molopa olio nokopa kondomba.’ nimbu pilipu konopu sipu molorumulu-na-kolo yu toko kondoringi. Akumunga ungu se pea i-sipa: Talko toringi, kiniá wale yopoko-sipa mele omba pukumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Pe kiniá ulu se lupa wendo omula. Yu lombili andorumulumanga ambo pokore kiniá ongo níngi mele pilipuli mini-wale mundomulu. Kiniá paa orili-u kanu amboma yu óno seringi kou-kandena pungu kanongi-na-kolo yunga ónomo naa liemu. Ono ongo oliondo ninguli: “Mulu-koleana angello talo kanomulu, olone “Yu we molemo.” níngili.” níngi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanu-kinia olio pea molomulu ye talo óno kou-kandena punguli ambomane níngi mele kanongili, aku-na-kolo yu naa kanongili.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aku niringili kinia olo lombili akilepa orumu yemone olondo nimbale: “Olo aroma topombele. Olo konopu naa pelemomonga u Pulu Yemone ungu-umbu tondoringima pilku yomboma ningu siringi yemane yundu niringi bokuna molemo mele mongotolone kanoko komutolone pilkuli konoputolonga liku mengo andolembolánje ⸤Yesusi-kinia talko seringi mele kinia yuni serimu sekemo mele kinia⸥ kamu alieli pilielembolá lémo. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba, nimba taltorumu ye nokoli Karasimu mania ombale, ya ye nikimbilimu talko mindili norumu mele mindili nomba mulu-koleana ye nokoli awili se pumba molomba mele u ningu naa siringiye? Ningu siringi kanumu. Pe kiniá u ningu siringi mele yu aku semu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aku nimbale Mosisini Yesusi yu yuyu sembá mele u boku marenga topa nirimu mele pulu polopa nimba sipa, yandopa yandopa Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yemane yu sembá mele u boku marenga toko niringi mele nimba sipa, aku Pulu Yemonga bokumuni nilimú mele pali nimba silipa yombotolo kinia aulkana purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yombotolo puringili koleamo nondoko wendo oringi kinia Yesusi we sumbi sipa senga lupa pumbá serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aku-na-kolo olone ta ningu ninguli: “Mólo. Ena pumba ipu nondopa lemba kene pea peamili.” niringili-kulu yu olo-kinia pumba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kanu-kinia olo pea kere-langi nongo moloringi kinia yuni pellawa kaloli se lipa Pulu Yemo “Ange.” nimba, ambolopa pike lepa olo sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aku serimu kinia olo yu kanoko olonga Ye-Awili Yesusi ningu kanoringili kinia sepa nema liltimu kelko naa kanoringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kanu-kinia olo ololo anju yando angelema ningu ninguli: “Aulkana olto-kinia omba ungu nimba Pulu Yemonga bokumuni nilimú mele ungu-pulumu nimba silipa omu kinia olto kamelé kongulu topili ombulu kanumu. Ye-Awili Yesusi-kinia ombulumunga aku semu lepomo.” niringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kanu-kinia olo ola gilku kelko sumbi siku Jerusalleme yando ongo, lombili andoli ye rureponga yopoko kinia ono pea maku toko moloringi yombo lupama kinia moloringina puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sukundu puringili kinia onone olondo ninguli: “Ye-Awilimu paa sika lomboropa ola molomu lémo. Yu yuyu Saimono molomuna pumba mona giliemu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kanu-kinia yombotolone aulkana puringili kinia ye se omba nirimu mele kepe kanu yemone pellawa kaloli se ambolopa pike lierimu kinia kanoko ‘Yu Yesusi.’ ningu kanoringili mele kepe onondo semane toko siringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","⸤Yesusi lombili andoli⸥ yombomane ⸤Yesusi yu lomboropa ola molorumu kanoringimundu⸥ angelema ningu molangi Yesusi yu omba ono moloringina sumbi sipa gilipale “Ono konopu pe nipili molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ono ‘Yombo kololi senga minimu kanokomolo.’ konopu lekole pungu-pungu ningu pipili koloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yuni onondo nimbale: “Mini-wale munduku konopu talo panjiku nambi semu-na molemeleye?” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nanga kitolo kinia kimbuma kanoko ‘Imu na nanu.’ ningu kanayo. Ambolko piliame. Nanga kangi kinia bele kinia gilkimu mele minimanga aku sipa gilimúye? ⸤Aku sipa naa gilimú kanumu.⸥” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aku nimbale yunga kimbu-ki pirimu toringima ono lipa ora sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kanu-kinia ono yu kanokole pondeanga konopu siku paa konopu kimbu siringi-na-kolo ‘Sikanje molo nambolkare kanokomolonje?’ ningu konopu talo panjiku we moloringi-kulu yuni ono mawa sepa nimbale: “Kere-langi nombó se ya lemoye? Siee.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Onone yu oma kaloli se liku siringi, ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akumu lipa ono kanoko molangi norumu. ⸤ ‘Minimu naa molopo yombomo molkoro kanangi.’ nimba aku serimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yuni onondo nimbale: “Na u naa kolopo ono-kinia molopole ono ulu wendo ombá mele nimbu sirindu kanu ulumu i wendo okomo. “Mosisi kinia Pulu Yemone ungu-umbu tondorumuma pilku yomboma ningu siringi yema kinia onone nando ningu boku marenga toringi uluma kinia, Pulu Yemonga konane niringi bokuna molemo konanemane nando nilimú uluma kinia, kanu uluma sika wendo ombá.” nirindu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Aku nimbale ‘Pulu Yemonga bokumuni nilimú mele pilku kondangi.’ nimba yuni ungu-pulumu ono nimba sipa nimbale: “Bokuna toringi molemo mele i-sipa: ‘Pulu Yemone “Ono nokopa kondomba ye se lipu mundumbu.” u nimba taltorumu ye nokoli Karasimu mindili nomba kolopale wale yopoko-sipamonga óno-koleana lomboropa ola molomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aku sembá kinia kanu ye Karasimu yunga talape yombomane yunga tondolomone yomboma ulu-pulu-kiri sengema pilku kiri pilku konopu topele tonge mele kinia, ulu-pulu-kiri sengema Pulu Yemone siye kolopa kelepa naa pilipa “Aku siku seko kinjeringimunga mindili nangi.” naa nimbá mele kinia, ningu singíndu Isirele yombomanga kolea-awili Jerusalleme pulu polko ningu siku koleamanga pali punguli ningu siliku andonge.’ , ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","aku mele nando u ningu boku toringi. “Pe kiniá nane serindu uluma kinia na-kinia seringi uluma kinia kanoringi seringi kanokomelemonga yomboma manda ningu singí. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aku-sipa na-kolo we naa sangi. Pulu Yemone “Simbu.” nimba, nimba panjerimu Minimu nane olando pumbuli lipu mundumbu kene aku Mini Tondolomo yu mulu-koleana mania omba ‘Ono tondolo pupili molangi.’ nimba ono-kinia molomba kene u senga lupa naa pungu Jerusalleme sukundu we nokoko molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesusi yu lombili andoringi yomboma kolea-kanga Betani lierimuna nondopana memba pumbale nirimumuni, ‘Pulu Yemone ono sewi anjepili.’ nimba yunga kitolo ola mundupa, “Pulu Yemone ono nokopa kondopa ‘Ono konopu enge nipili molangi.’ nipili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Onondo aku sipa nimba molopili ⸤Pulu Yemone⸥ yu mulu-koleana olando liltimu kinia ono mundupa kelepa mulu-koleana olando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kanu-kinia onone ⸤Yesusi⸥ yu kape ningu imbi ambolko paka tondokole kamelé paa koke sepili, Jerusallemendo kelko yando oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akuna punguli ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena alieli-alieli molko, Pulu Yemone serimumunga “Ange.” ningu yu kape ningu yunga imbi ambolko paka tondoringi. ⸤Yesusinga semane peanga ekendo topo pora sikiru.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Paa koronga-u, ⸤mulu matolo kepe mélse naa liepili,⸥ Ungumu molorumu. Aku Ungumu Pulu Yemo kinia moloringili. Aku Ungumu yu Pulu Yemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paa koronga-u, mélse mana naa liepili, yu Pulu Yemo kinia moloringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ungumu yuni yuyu mélema pali serimu. Mélse we pora naa purumu. Méle wendo orumuma pali yuni serimu-na wendo orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mololi ulu-pulumu yu-kinia mindi perimu. Kanu mololi ulu-pulumu yombomanga pa sendélimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Aku pa sélimuni simbulu tolemomo pa sendelemo. Simbulu tolemomone kelepa pa sélimu manda pipi sipa simbulu kelepa naa tomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ye se orumumu Pulu Yemone lipa mundorumu-na orumu, yunga imbimu Jono. ⸤Yu No Lindeli Jono kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jonone pa sendélimunga pulumu nimba simba orumu. ‘Yombomane “Nondopa ombá yemo yu sika aku pa sendélimu.” ningu kuru mondangi.’ nimba, omba nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jono yu aku pa sendélimu mólo. Yu aku pa sendélimu ombá mele nimba simba orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jonone yomboma ungu nimba sipa molopili paa sika pa sendélimuni yomboma pali pa sendelemo kanumu mana ombá orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yu ma-koleana omba molorumu. Yuni yuyu ma-koleamo serimu-na-kolo ma-koleana yombomane yu kanokole ‘Yu ma-kolea serimu Pulu Yemo.’ ningu naa kanoko ‘Yu we-mana-ye se.’ ningu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yu yunga koleana omba molorumu-na-kolo yunga yombomane “Nu olionga Ye-Awilimu okono kene olio ongo nokoko molou.” ni naa niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aku-sipa na-kolo yundu “Nu sika ⸤Pulu Yemone lipa mundorumu-na orunu yemo kene⸥ olio nokani pea molamili ou.” ningu yunga ungumu kuru mondoko liltingi yomboma yuni “Pulu Yemonga bolangoma molangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aku-na-kolo kanu yomboma Pulu Yemonga bolangoma au lieringi, aku ulumu kangimunga kongonomo mólo. Anupili lapalini “Pulu Yemonga bolangoma meamili.” ni naa niringila. Pulu Yemone yuyu mindi onondo “Nanga bolangoma.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ungumu ⸤Pulu Yemo pea moloringilimu⸥ mania omba mana-ye au lepa olio-kinia pea wale kanga-kolte molorumu. Yu mana omba molorumu kinia neme-neme nimbu kanopole, yu ye paa peanga, imbi molemo ye tondolomo, kanopo pilierimulu. Kanu ye paa peanga tondolomo Malo selu molorumumu Lapa molorumuna yu pea molkole mana mania orumumunga yu ye paa peanga lepa imbi paa ola mololi ye tondolomo mindi kanopo pilierimulu. Yu we kondo kololi ulu-pulumu kinia sika nili ulu-pulumu kinia yunga konopuna pepa peke lierimu yemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","⸤Jono yomboma no lindipa molopili Yesusi Pulu Yemonga Ungumu orumu kinia⸥ Jono yuni yomboma kanu yemo lipa ora sipa yu molorumu mele nimba sirimu. Yuni ru nimba nimbale: “I yemo nane onondo u “Nondopa ombá.” nimbu sirindu kanu yemo imu. Na naa molambo i yemo yu koronga-u Pulu Yemo kinia molorumu-kulu “Yu ye nokoli awilimu, na paa we koropa yemo.” nirindu kanu yemo imu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yuni olio we kondo kololemo ulu-pulumu yu-kinia pelemomonga yuni olio alieli kondo kolopa mindi molopa olio ‘Konopu peanga leangi.’ nimba alieli-alieli sewi anjilimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosisini olio Pulu Yemonga ungu-mane sirimuma kála-sepo sepo molorumulu. Aku-na-kolo olio we kondo kololi ulu-pulumu kinia sika unguma kinia aku uluma Yesusi Karasi yu-kinia mindi pepili orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana-yombo sene u kepe, kiniá kepe, Pulu Yemo naa kanolemele. Pulu Yemonga Malo selu mindi molemo, akumu Lapa kinia pea kopu seko molembele, akumuni mindi ‘Pulu Yemo molemo mele kanangi.’ nimba yu lipa ora sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda yomboma⸤nga ye awili⸥ kolea-awili Jerusalleme moloringi ⸤kanu yemane⸥ Pulu Yemo popo tondoringi ye pokore kinia, LLipai ye pokore kinia Jono no lindipa molorumuna liku mundukuli, “Jonondo “Nu nawe?” ningu mangilku piliangi paa.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ono ongo yu mangilku pilieringi kinia yuni kolo naa topa sumbi sipa nimba nimbale: “Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ nimba, nimba taltorumu ye nokoli Karasimu na mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Onone “Nu aku yemo mólo liemu nu nawe? Nu Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Illainja, ⸤yu konde molopili Pulu Yemone u olando liltimu akumu⸥ nu kelko onuye?” ningu mangilku pilieringi. Yuni “Na akumu mólo.” nirimu. Onone ninguli: “Aku liemu ‘Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba simba ye se pe ombá.’ ⸤u niringi kanu yemo⸥ nuye?” niringi. Yuni “Mólo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kanu-kinia onone yundu ninguli: “Nu nawe? Olio liku mundongi yemane ‘Ongo ningu singí.’ ningu nokoko molemele kene nunga imbi leko si. Nunu nawe konopu lekenoye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jonone nimbale: “Pulu Yemone ungu-umbu tondorumuma pilipa yomboma nimba sirimu ye Aisayane koronga-u nimbale: “Kolea ku lielina ye sene “Ye-Awilimu ombá aulkamo sumbi sindei.” nikimu pilkiru.” nirimu. Aisayane kanu u pilierimu ungumu nane kiniá nikiru.” nimba Jonone nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","⸤Kanjollomane⸥ mundoringi ongo moloringi yemanga Parisi ye mare moloringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Aku Parisi yemane yundu mangilku pilku ninguli: “Nu ye nokoli Karasimu mólola, Illainja mólola, ‘Pulu Yemone ungu-umbu tondombama pilipa yomboma nimba simba ye se pe ombá.’ u niringi yemo mólola. Pe kiniá nu nambi semu-na yomboma no lindilinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonone onondo pundu topa nimbale: “Na sika no lindiliu-na-kolo nanga kongonomo maniandopa. Ye se olionga koleana sukundu molemo akumu ono kanokole ‘we-yere’ konopu leko, kanoko imbi naa silimili, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","aku yemo na lombili akilepa okomo yemo. ⸤Yombo awilimanga kongono kiri seli yombomane sika ononga yombo awilimanga kongono kiri sendengendo ononga kimbu-su ka pilka toko su wendo lindilimili-na-kolo⸥ i ye na lombili akilepa okomomonga kimbu-su ka pilka topo su wendo lindimbu kongonomo kepe paa olandopa mele, nane manda naa sendembo. Na ye paa kiri mele; yu ye paa nokoli awilimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","I ulu wendo orumuma Betani taono, no Jodane nekendo lemó koleana, wendo orumu. Jonone akuna yomboma no linderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Opalikundu ⸤No Lindeli⸥ Jono molorumuna Yesusi ombá orumu kanopale nirimumuni, yombomando nimbale: “Kaname! Pulu Yemonga Kongi Sipisipi Walomo okomo. Yu yombomanga pali ulu-pulu-kirima kulu tondolemo tondomba yemo okomo.” ⸤nirimu⸥. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“U nane ye se nirindu kanumu andi okomo ye akumundu nirindu. U nane nimbuli: “Ye na lombili ombá ye se na naa molambo yu koronga-u molorumu-kulu yu olandopa na maniandopa.” nirindu kanumu i yemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na kepe yu naa kanorundu-na-kolo ‘Isirele yomboma yu kanokole piliangi lipu ora siembo.’ nimbu na ombo yomboma no lindiliu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jonone yundu ungu se pea nimbale: “Yu no lindipu molopo kanondu kinia Mini ⸤Kake Sélimu⸥ kera waembono mele mulu-koleana maniando omba yu molomuna omba molomu kanondu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nane yu kanopole yu imbi naa pilipu ‘Yu we-yere.’ konopu lelka-na-kolo nando “Yomboma no lindi-pou.” nimba lipa mundorumu yemone na nimba sipa nimbale: “Mini ⸤Kake Sélimu⸥ mania omba ye senga kangi senga ola omba molomba kanoni kinia aku yemone yomboma Mini ⸤Kake Sélimu⸥ lindimba yemo.” nirimu-kulu pilipuli yu kanopo imbi sipuli ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","onondo “Yu Pulu Yemonga Malo.” niliu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Opalikundu ⸤No Lindeli⸥ Jono no Jodane kelo akuna kelepa gilipale nirimumuni, yu lombili andolimanga ye talo pea gilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kanu-kinia Yesusi omba purumu kinia yuni kanopa nimbale: “Kanale! Pulu Yemonga Kongi Sipisipi Walomo omba pukumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yu lombili andolitolo yuni nirimu ungumu pilkuli Yesusi lombili puringili. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesusi topele topa olo yu lombili oringili kanopale olondo nimbale: “Nambolka korokombeleye?” nirimu. Olone yundu “Rapai, nu sena pelenoye?” niringili. (Rapainga ungu-pulumu ‘Ungu Mane Sílimu’ .) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yuni olondo “Kanangili wale.” nirimu. Olo yu perimuna pungu kanokole ipupini po killoko mele serimu-kulu kanu enamonga yu pea peringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ye talo Jonone nirimu ungumu pilkuli Yesusi lombili puringili yetolonga se Enderu, Saimono Pitanga genu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yu sumbi sipa pumba genu Saimono koropa kanopa lendepale yundu nimbale: “Pulu Yemone “olio nokopa kondomba ye se lipu mundumbu.” nimba, nimba taltorumu ye nokoli Mesayamo kanopo lendemulu.” nirimu. ( ‘Mesaya’ akumu Juda yombomanga ungu se. Mesayamondo Giriki unguna ‘Karasimu’ nilimili.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aku nimbale Enderuni genu Saimono Yesusi molorumuna memba purumu. Yesusini yu kanopa nimbale: “Nu Saimono, ‘Jono’ nili ye senga malo. Nunga imbi se ‘Sipasi’ ningu lenge.” nirimu. (Sipasindu ‘Pita’ niringila. Juda yombomanga unguna ‘Sipasi’ ningu, Giriki unguna ‘Pita’ nilimili, aku ungutolonga pulumu ‘kou-mulu’ .) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Opalikundu Yesusi ‘Kolea Gallilli disiriki pambo.’ konopu lepa pumbá purumu. Pumbale Pillipu aulkana gilierimu kanopale, “Na lombili ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pillipu kepe Besaida taono yemo, Enderu kinia Pitatolonga koleamo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pillipuni Nataniele kanopa lendepale yuni yundu nimbale: “Mosisini boku torumu bokumanga ‘Ye se ombá.’ nimba semane torumu kanu yemo kepe, Pulu Yemone ungu-umbu tondorumuma pilku yando ningu siringi yemane ononga bokumanga ‘Ye se ombá.’ ningu semane toringi kanu yemo kepe, kiniá olio kanopo lendemulu. Yu Nasarete taono ye Yesusi, Josepo malo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aku-na-kolo ‘Aku kolea kangana ye-awili se manda wendo naa ombá.’ nimba pilipale Natanielene Pillipundu nimbale: “Nasarete taonona ungu peanga se manda wendo ombáye?” nirimu. Pillipuni Natanielendo nimbale: “Ongo kanou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kanu-kinia Nataniele ombá orumu kinia Yesusini kanopa, yundu nimbale: “I ye okomomo paa sika Isirele yemo, yu kolo toli ungu se paa naa pelemo yemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanielene Yesusindu nimbale: “Nuni na nambi seko kanoko imbi sikuli aku nikinuye?” nirimu. Yesusini pundu topa nimbale: “Mólo. Pillipuni nu u naa mangiliepili nu unju piki puluna molonu kinia nu kanopo imbi sindu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aku nirimu kinia Natanielene tondolo mundupa nimbale: “Rapai, nu Pulu Yemonga Malo, olio Isirele yombomanga ye nokoli kingimu lepomo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesusini nimbale: “Nane ‘Nu unju piki puluna molonu kinia kanondu.’ nindu kanumunga nuni na ‘Pulu Yemonga Malo molemo.’ ningu kuru mondokonoye? Kiniá nane nundu nindu mele maniandopa. Pe ulu-tondolo paa olandopama wendo ombá kanoni.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aku nimbale Yesusini ungu se pea nimbale: “Nane onondo paa sika nimbu sikirumu: “Pe mulu-koleana anju yando pumba, Pulu Yemonga angelloma Mania Omba Mana-Ye Au Lierimu Yemo molombana olando pungu maniando ongo senge kanonge.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wale yopoko sipamonga Kena taono, kolea Gallilli disiriki sukundu lierimu, akuna ye se ambo limbando kere-langi koyopa yomboma simba serimu, akuna Yesusi anumu pea maku toko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesusi kinia yu lombili andolima kinia kanu ambo limba yemone “Ono kepe kere-langi pea namili waa.” nirimu-kulu ono ongo kere-langi pea noringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kere-langi nongo molangi no-waene pora nirimu kinia Yesusi anumuni Yesusi yundu nimbale: “Ononga no-waene pora nimu-na mini-wale mundukumili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusini yundu nimbale: “Ambomo, nane ungu sembóma nunga kongono se mólo. Nane ungu sembó walemo u wendo naa oli.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yunga anumuni ⸤ulka pulu yemonga⸥ kendemande-yombomando nimbale: “Yuni onondo “Saa.” nimbá mele aku siku saa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juda yombomane no lengendo no kolko mondoringi mingi awili talo-pakara akuna gilierimu. Mingimanga senga senga nimba no manda manjeli wane anderete llita molo wane anderete teti llita mele mandana molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusini ⸤ulka pulu yemonga⸥ kendemande-yombomando nimbale: “Mingi kanga marenga no pungu kolkole, andi mingi awili lemomanga munduku peke siee.” nirimu. Kanu-kinia ono no kolko paa peke siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yuni onondo kelepa nimbale: “Olama liku mundukuli kere-langi nokoli yemo mengo pungu siee.” nirimu. Kanu-kinia mengo pungu yu siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kanu kere-langi nokoli yemone umbu-nomo no-waene au lierimu naa kanopale nomo we nomba pilierimu. Aku-sipa na-kolo kendemande-ye no koloringimane nomo kanoko imbi siringi. Kere-langi nokoli yemone nomba pilipale ambo limba yemondo “Ou.” nimba ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yundu nimbale: “Yemane pali alieli no-waene peangamo u sikuli, pe yombomane no awisili nongo pora siku kelko we walu nongo ‘songo sekemone naa sekemone’ ningu apuruku naa pilielemele kinia no kiri mele silimili. Aku-na-kolo nuni no-waene peangamo u we taltokole pe kiniá sikinumu, ⸤paa papu sikinu⸥.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kolea Gallilli disiriki sukundu lierimu kolea Kena taonona Yesusini serimu ulu akumu pe yu molopa kongono serimu mele lipa ora sirimu ulu-tondoloma sembando i ulumu pulu-pulu serimu. Aku sipa yu we-ye se mólo, yu Pulu Yemonga tondolo peli yemo ‘ono kanangi.’ nimba lipa ora sirimu. Kanu-kinia yu lombili andolimane ‘Yu paa sika ⸤Pulu Yemone lipa mundorumu yemo⸥.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ye ambo limbamonga kere-langi nongo pora sikuli Yesusi kinia anumu kinia genupili keme lombili andolima keme Kapeniame taonondo punguli, akuna wale pokore moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda yombomane kalia-ingi senga senga kolea-awili Jerusalleme ongo akuna sukundu Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilieringi walema nondopa wendo ombá serimu kinia Yesusi Kapeniame taono mundupa kelepa kolea-awili Jerusalleme olando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembele akuna sukundu pumba kanorumu kinia kongi pirimu-kao kondema kinia kongi sipisipi kondema kinia kera waembono kondema kinia kou-mone liku bisinisi seringi yomboma kepe, kou-mone topele toringi yomboma kepe akuna sukundu aku seko moloringi kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanopa kiri pilipale nirimumuni, ka mare lipa lakopale kanu ka-pultamone kongima pali ulka-tembelena topa makoropa pena-pena sepa, kou topele toringi yombomanga kou-mone walena perimuma lipa ondopa ononga kou taltoringi poloma lipa topele topale, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","kera mondoko bisinisi seringi yombomando nimbale: “I Tatanga ulkana bisinisi naa seko i mélema wendo liku mengo pame! I Tatanga ulkamo sitoamoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yuni aku serimumu yu lombili andolimane kanokole onone ungu se Pulu Yemonga bokuna sukundu nimba molemomo konopumane pilieringi. Aku ungumuni nimbale: “Na paa kála sepole nunga ulkamo ‘Gilipa peanga liepili.’ nimbu nokopo molio.” nimba molemo kanu ungumu konopumane pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kanu-kinia yuni serimumu Juda ⸤ye awili⸥mane kanokole yundu ninguli: “Nu namba nambolka nambare likuli aku siku sekenoye? ‘Lipu ora siembo.’ ningu Pulu Yemone “Sei.” nimu liemu Pulu Yemone selemo mele ulu-tondolo se olio kanamili sei.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesusini onondo pundu topa nimbale: “Onone i ulka-tembelemo sikisingí kinia nane wale talo takopo, yopoko sipamonga takopo limbu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nirimu mele Juda ⸤ye awili⸥mane pilku ninguli: “I ulka-tembelemo kalia-ingi paono talo omba pumba kelepa kalia-ingi talo-pakara omba purumu kinia takoko liltingi kanumu. Pe nuni “Wale talo takopo yopoko sipamonga takopo limbu.” nikinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aku-sipa na-kolo yuni “ulka-tembelemo” nirimu akumu yunga kangimundu nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanu-kinia pe Yesusi kolopa wale talo óno-koleana pepa yopoko sipamonga lomboropa ola molorumu kinia yu lombili andolimane yuni u ulka-tembelemondo nirimu mele kelko pilieringi. Pilkuli Pulu Yemonga bokuna ⸤Yesusindu⸥ nimba molorumu ungumu kinia Yesusini nirimu ungumu ‘Sika.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pulu Yemone Juda yombomanga anda-kolepalima Naa Topa We Omba Purumu mele pilieringi walemanga Yesusi Jerusalleme molopale yombomane yuni yu molopa kongono serimu mele lipa ora sirimu ulu-tondolo serimuma kanokole ‘Yu sika Pulu Yemone ‘Ono nokopa kondomba ye se lipu mundumbu.’ nimba, nimba taltorumu yemo omba molemo.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Aku-na-kolo Yesusini yomboma pali seko moloringi mele pilipa kelepale uluma pali yombo sene yu lipa ora sipa naa nipili yu yuyu pilipa molorumu. Onone ningu pilieringi mele yuni konopumuni pilipale, ⸤ ‘We ningu pilielemele. Sika kiniá aku siku ningu pilielemele-na-kolo opali kepe talu kepe konopu topele tokole na ‘Topo kondamili.’ ningu pilingí.’ nimba pilipale,⸥ ‘Ono-kinia we walu sipu molambo.’ ni naa nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","⸤Juda yombomanga ye mare Parisi moloringi. Aku⸥ ye Parisimanga ye se, imbi ‘Nikodimasi’ , yu Juda yomboma nokorumu kanjollo ye se, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yu Yesusi molorumuna ipulieli ombale nirimumuni, yundu nimbale: “Rapai, ‘Nu Pulu Yemo kinia pea molkole ungu-mane sinindu orunu.’ nimbu pilielemolo. Ye se ‘Pulu Yemo kinia naa molkanje Pulu Yemone ulu-tondoloma selemo mele nuni seleno aku sipa yuni manda naa selka. Ulu selenomane Pulu Yemo kinia pea molembele mele lipa ora silimú.’ nimbu pilielemolo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesusini pundu topa yundu nimbale: “Nane nundu paa sika nimbu sikiru: “Yombore kelko naa mengi liemu kanu yombomone Pulu Yemone ye nokoli kingimu molopa yomboma nokolemo koleamo manda naa kanopa yunga talapena manda naa molomba.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimasini yundu nimbale: “Yombo se anda lepa molemo kinia yu nambi seko mengeye? Yu anumunga olona kelepa manda sukundu pumbá, anumuni yu manda membaye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesusini pundu topa nimbale: “Nane nu paa sika nimbu sikiru: “Yombo se nomone kepe Minimuni kepe mei naa mengili liemu kanu yombomo Pulu Yemonga bolango naa molopa Pulu Yemo ye nokoli kingimu molopa nokolemo koleana sukundu manda naa pumbá, mólo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Méle kangimuni melemó méle akumu kangimu, yu mana molomba mélemo mindi; méle Pulu Yemonga Minimuni melemó méle akumu minimu, aku mélemo mindi Pulu Yemo molemona manda pumba molomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Akumunga nane nundu nimbuli: “‘Pulu Yemo ye nokoli kingimu molopa nokolemo koleana pamili.’ ningí yomboma pali u kelko meangi.” nikirumundu konopu awisili naa lieyo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poporomemo yuyu pilipa kolea lupa lupamanga tolemo kinia onone yunga ungumu pilku, mélema lope-lope selemo kanolemele, aku-na-kolo yu naa kanoko yu wendo olemona kepe pulimúna kepe naa kanolemele. Pulu Yemonga Minimu aku sipala. Minimuni melemó yomboma mini konde pepili ono paa yombo lupa mele molemele yombomane kanolemele, aku-na-kolo ⸤Pulu Yemonga⸥ Minimuni kanu yomboma mini kondema silimú kanu Minimu naa kanolemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimasini yundu nimbale: “I uluma nambi sepa wendo okomoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesusini yundu nimbale: “Nu Isirele yombomanga ungu-mane sili ye se na-kolo i nikiru mele naa pilkinu lepomo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nane nundu paa sika nimbu sikiru: “Olio pilielemolomando nilimulu; kanolemolomando nimbu silimulu. Aku-sipa na-kolo i ungu nilimulu unguma onone pali pilku limili yombo se mólo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya ma-koleana uluma ono nimbu siliu kinia onone ‘Kólo tokomonje.’ ningu pilku kuru naa mondolemelemonga pe kiniá mulu-koleana uluma nimbu sindu liemu ‘Sika nikimu.’ ningu nambi seko manda kuru mondongeye? Manda kuru naa mondonge lémo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yombo selu kepe olando siku mulu-koleana sukundu naa puringi. Ye selumu mindi, mulu-koleana maniando sipa orumu yemo mindi u mulu-koleana molorumu. Yu Mania Omba Mana-Ye Au Lierimu Yemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“U Mosisini yombo naa peli kolea kuna kongi-ka-wambiye kou-kapane sélimu lipa ola uku topa panjerimumu mele aku siku yombomane Mania Omba Mana-Ye Au Lierimu Yemo liku ola uku toko panjingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kanu-kinia, ⸤u yombo wambiyemane nongo kondoringi kolonge seringi yombomane Mosisini lipa ola uku topa panjerimu wambiye kapane sélimu kanokole konde puringi kanu mele⸥ pe kiniá aku siku ‘Yombomane yu-mele-mele ‘Mania Omba Mana-Ye Au Lierimu Yemo yu uluma sepa molemo mele sika.’ ningu kuru mondonge yomboma pali molko kondoko mindi pangi.’ nimba Pulu Yemone ‘Yu ⸤unjuna⸥ ola uku toko panjangi.’ nimbá nirimu.” nimba Yesusini nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Pulu Yemone mana-yomboma konopu paa awili sepa mondopale yunga Malo selumu mindi molorumu-na-kolo yu ⸤mana-yomboma⸥ sirimu. ‘Yombomane yu-mele-mele ‘Yu sika ⸤Pulu Yemone sipa mundorumu, olio lipa tapondopa nokopa kondoli yemo⸥.’ ningu yu kuru mondoko molonge yomboma mindili nongo molko kinjingí koleana naa pungu, alieli molko kondoko mindi pangi.’ nimba yunga Malo sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Pulu Yemone Malondo “Nuni mana-yomboma kote pilku ono ka-ulkana liku mundani pu.” ni naa nirimu. ‘Nanga kangomo ono lipa tapondopa mindili nolemolá aulkana wendo lipa na-kinia molko kondonge aulkana lipa mondopili.’ nimba yuni Malondo “Ma-koleana mania pu.” nimba yu lipa mundorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yombo “Yu sika ⸤Pulu Yemonga Malo, olionga nimba senderimu yemo⸥.” nimba kuru mondopa molomba yombomanga kote naa pemba. Aku-na-kolo yombo sene ‘Yu aku sipa naa molemo. Nanga nimba ungu se naa senderimu.’ nimba kuru naa mondomba yombomo, yunga kotemo koronga we-yombomone Pulu Yemonga Malo selumu mindi molemo kanumundu ‘Yu sika Pulu Yemonga Malo mólo.’ ningu kuru naa mondorumu kanu yombomo kote pilielemo yemone lipa kote sendepa “Yu kolopili.” nimba koronga-u senderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Kotemonga ungu-pulumu i-sipa: Pa sélimu mana wendo orumu-na-kolo mana-yombomane ulu-pulu-kirima mindi sekole pa sélimu konopu naa mondoko simbulu tólimu mindi konopu mondolemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yombo ulu-pulu-kirima selemelemane pa sélimu kanoko kiri pilkuli, ‘Pa sélimuni nanga uluma mona lendemba.’ ningu pa sélimunga wendo naa olemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aku-sipa na-kolo yombo ulu sikama selemo yombomone ‘Pulu Yemone na lipa tapondolemo-na i ulu-pulu sikama selio kene selio uluma yombomane kanangi.’ nimba pa sélimunga yu wendo olemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pe Yesusi kinia yunga lombili andoli yema kinia kolea Judia disiriki lierimu kolea senga punguli niringimuni, akuna wale mare yu ono-kinia molkole, yuni yomboma no linderimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jono yu yomboma no lindipa molorumula. Kolea Sellimi nondopa kolea Inono no awisili omba purumu-kulu Jono yuni akuna yomboma no linderimu, yombo awisili yu molorumuna no lingí oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jono yu ⸤ye nokoli kingi Erotene⸥ ka u naa sipili aku sepa molorumu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Walte ⸤No Lindeli⸥ Jononga lombili andoli yema kinia Juda ye se kinia anju yando tondolo angelema ninguli, “Olio nambi sepo kimbu ki kangima kulumiye tomolo kinia Pulu Yemone olio kake sembá kanombaye?” ningu angelema niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe Jononga lombili andolima Jono yu molorumuna ongo ninguli: “Rapai, ye se no Jodane nekendo nu pea moloringili kinia nuni yu molemo mele ningu sirinu kanu yemone no lindipa molemona yombo awisili pukumili.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aku niringi pilipale Jonone pundu topa nimbale: “Mulu-koleana Pulu Yemone ‘Ye se ungu se sepili.’ ni naa nilkanje kanu yemone manda naa selka. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nane ono u nimbu sirindu pilieringi mele i-sipa: Nane nimbuli: “Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ nimba, nimba taltorumu ye nokoli Karasimu na mólo. Pulu Yemone ‘Ye nokoli Karasimu molomba yemo yu ombá.’ nimba na u kumbi lepa lipa mundorumu.” nirindu pilieringi kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ye ambo limba ambomo yemo yunga mindi. Ye ambo limba yemone ungu nimbá mele yemo yunga pulu lemba yemone pilimbando komu sendepa molomba. Yunga ungumu pilipale paa konopu simba. Akumunga, yemo kinia pulu lemba yemo konopu simba mele na aku sipu kamu konopu siliu. Ambo limba yemo olandopa. Yunga pulu lemó yemo yu-kinia we kopu sepa molemo, aku yemo maniandopa. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aku sipa mele ne no lindipa molemo yemo yunga imbimu sika paa olandopa pumbá. Nanga imbimu sika mania pumbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ye wi ola molopale maniando orumu yemo yombomanga pali yu olandopamo. Olio mana-yombo molemoloma mana-mélemanga mindi molopo, mana-mélemanga mindi imbima nimbu sipu semane tolemolo. Olio maniandopa, mulu-koleana molopale mania orumu yemo yu yombomanga pali olandopa. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yuni mulu-koleana kanopa pilierimu mele nimba silimú-na-kolo yombomane “Kolo tokomo.” ningu, mokoli seko naa pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yombo sene yunga ungumu pilipa lipa “Sika nikimu.” nimbá yombomone aku sipa “Pulu Yemone sika nilimú.” nimbála. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","I Pulu Yemone lipa mundorumu yemo Pulu Yemo yunga Minimu paa awili sepa silimú konopuna pepa manda selemo-kolo yuni Pulu Yemonga ungumu sumbi sipa nilimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lapane Malo konopu mondopale ‘Mélema pali Malo nokopili.’ nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yombo se ‘⸤Yu sika nikimu.⸥ Yu sika Pulu Yemonga Malo.’ nimba kuru mondomba yombomo alieli konde molopa mindi pumbá, aku-na-kolo yombo se Malo bulu sipa yunga ungumu lipa mokoli sepa naa pilimba yombomo konde mololi ulu-pulumu naa limba. Aku yombomo kiniá kepe pe kamu alieli-alieli kepe Pulu Yemone mindili lipa simba ulu-pulumu yu-kinia pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi yemane ungu se pilieringi mele i-sipa: “Yesusi molemona yombo awisili ‘No lindepili.’ ningu pulimili, ⸤No Lindeli⸥ Jono molemona yombo koltalo mele ‘No lindepili.’ ningu pulimili.” niringi ungumu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Aku-sipa na-kolo Yesusi yu lombili puringi yomboma yuni no naa linderimu, yu lombili andoli yemane yomboma no linderingi.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","⸤Yesusini yombo no linderimu⸥ semane akumu Parisi yemane pilieringi mele pilipale Ye-Awilimuni kanu walemonga kolea Judia disiriki mundupa kelepa kolea Gallilli disirikindu kelepa pumbá purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yu Gallilli purumu aulka akumu kolea Sameria awi-suku-singina lepa purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aulkamo aku sipa lierimu-na yu kolea Sameria lierimu taono senga orumu, aku taonomonga imbimu Saika. Aku taonomo Juda yombomanga anda-kolepa Jekopone yunga malo Josepo sirimu mamonga nondopa lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekopone ‘No molopili.’ nimba muru akuorumu aku no-murumu kanu mamonga lierimu. Yesusi aulka suluna orumumunga siye serimu-kulu aku no kelona omba mania molopa mulu pilierimu. Kolea awi-tangoli mele akuna omba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","(Yesusi yu lombili andoli ye pea oringima yu mulu pilipa molopili ono kere-langi topo toko lingíndu Saika taonona puringi.) Pe yu mulu pilipa molorumu kinia Sameria ambo se no kolombando orumu kinia Yesusini yundu nimbale: “No se nambo si.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sameria ambomone yundu nimbale: “Nu Juda yemo. Na Sameria ambomo. Pe nambi semu-na nando “No si.” nikinuye?” nirimu. (Aku nirimumunga ungu-pulumu i-sipa: Juda yombomane Sameria yomboma konopu kiri panjiku kere-langi selumu moke seko naa nongo, ono kinia seluna kopu seko naa andoringimunga aku nirimu kanumu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesusini pundu topa ambomondo nimbale: “Pulu Yemone mélemo we silimú mele pilku, i ye “No si.” nikimu yemo kanoko imbi silinanje yundu “No si.” nilina kinia yuni konde molopa mindi puli nomo nu silka.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ambomone pundu topa nimbale: “Ye-Awilimu, nu no koloni mingi se naa menu, no-murumu paa maniandopa lemó. Pe i no konde molopa mindi puli no nikinumu nu sena kolkole siniye? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Olionga anda-kolepa ye Jekopone i no-murumu sirimu kanu yemo yu kinia yunga bolangoma kinia kongima kinia i nomo noringi, ‘kanu yemo maniandopa nu olandopa.’ ningu nikinuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusini pundu topa nimbale: “I no-muruna no nonge yomboma kelepa no nonowale semba, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","aku-na-kolo nane no simbú nonge yomboma pe ono no paa nonowale naa semba. Nane paa sika nikiru: “Nane no simbú akumu nonge yombomanga konopumanga no pilkipa mindi molopa, konde molko mindi pungí ulu-pulumu simba.” nikiru.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","⸤Yesusini ungu-iku torumu mele naa pilipale nirimumuni,⸥ ambomone yundu nimbale: “Ye-Awilimu, na no kelepa nonowale naa sepili, ya kelepo alieli-alieli ombo no naa kolambo kene nuni no nikinumu nambo si.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yuni yundu nimbale: “Nunga yemo pea kelko wangili, pungu mangili-pou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ambomone pundu topa nimbale: “Nanga ye se naa molemo.” nirimu. Yesusini yundu nimbale: “ “Nunga ye se naa molemo.” nikinumu sika nikinu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","U nu ye se-pakara purunu. Pe kiniá nu ye se pea pelembelemo nunga mena mólo. Nuni kiniá ungu nikinumu sika nikinu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ambomone yundu nimbale: “Ye-Awilimu, na pilkiru nu Pulu Yemone ungu-umbu tondolemoma pilku yomboma ningu silinu ye se lepomo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Olionga anda-kolepalimane i ma-pangina Pulu Yemo popo toko kape niringi-na-kolo ono Juda yombomane ninguli: “Pulu Yemo popo toko kape ningí koleamo paa Jerusalleme mindi.” nilimili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesusini tondolo mundupa nimbale: “Ambomo, nane ya nikirumu nu pilku lieni. Wale se wendo ombá kanu walemonga i ma-pangina kepe Jerusalleme kepe yombomane Lapa popo toko kape naa ningí.” nirimu. ⸤Aku ungumunga pulumu: “Koleamanga pali Pulu Yemo popo toko kape ningí.” nimbándo nirimu kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Ono Sameria yombomane popo toko kape nilimili yemo pilku sunduku we nilimili. Olio Juda yombomane popo topo kape nilimulu yemo molemo mele pilipu kondolemolo. Nambi semu-na, mana-yomboma Pulu Yemone lipa tapondopa, mindili nolemolá aulkana wendo lipa, yu kinia pea molko kondonge aulkana lipa mondolemo ulu-pulumu Juda yomboma kinia wendo ombá, onone koleamanga pali yomboma liku ora singímunga aku sipa. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aku-sipa na-kolo Pulu Yemo sika popo toko kape ningí yombomane Tatanga ungumu ‘Sika ungumu.’ ningu pilku yunga Minimuni tondolo silimúmunga Pulu Yemo popo toko kape ningí wale wendo ombámo koronga wendo omu. Pulu Yemo aku siku popo toko kape ningí yomboma Tatane korolemomonga kanu walemo wendo omu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pulu Yemo yu minimu, akumunga yu popo toko kape ningí yombomane yunga Minimuni tondolo silimúmunga ‘Yunga ungumu sika ungumu.’ ningu sumbi siku aku senge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ambomone nimbale: “Ye nokoli Mesayamo ombá. Yu ombale ungumanga puluma pali olio mimi sipa nimba simba mele na pilipu molio.” nirimu. (Ipuru unguna ‘Mesaya’ niringi akumu, Giriki unguna ‘Karasi’ niringi aku ungutolonga pulumu selumu. Ungutolonga pulumu i-sipa: Pulu Yemone “Olio nokopa kondomba ye se lipu mundumbu.” nimba, nimba taltorumu ye nokoli kanumu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kanu-kinia Yesusini tondolo mundupa nimbale: “Nu “Ye nokoli Mesayamo ombá.” nikinu akumu na. Na nu-kinia ungu nimbu molkombolo yemo kinia, nuni “Ye nokoli Mesaya” nikinu kanu yemo kinia, ye selumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yu aku nimba molopili yu lombili andoli yema kelko yando ongole niringimuni, yu ambo se kinia ungu ningu moloringili kanokole mini-wale munduku konopu awisili kimbu siringi. Aku-sipa na-kolo ononga ye sene “Nu nambolka mélse lini sekenoye?”, molo “Yu-kinia nambi semu-na ungu ningu molembeleye?” ningu sene kepe naa mangilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kanu-kinia ambo kanumu yunga no-mingimu mundupa kelepa yu kelepa kanu taonona yando pumba yombomando nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Na ungu serinduma pali ye sene na nimba simu yemo ono ongo kaname! Pulu Yemone “Olio nokopa kondomba ye se lipu mundumbu.” nirimu ye nokoli Karasimu yunje.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aku nirimu-kulu pilkuli yomboma taono munduku kelko Yesusi molorumuna onge oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aku seko molangi yu lombili andolimane yu paa ta ningu ninguli: “Rapai, kere-langi se nou.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aku-na-kolo yuni onondo nimbale: “Na kere-langi nombómo lemó, na-kolo akumu ono naa pilku naa kanolemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aku nirimu pilkuli yu lombili andolimane anju yando angelema ningu ninguli: “Yombo sene kere-langi u memba omba simunje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesusini nimbale: “Nanga kere-langi i-sipa: Na ‘kongono sani pu.’ nimba lipa mundorumu yemone konopu silimú uluma sepo, yunga kongonomo sepo pora simbú. Akumu nanga kere-langimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Onone “Oli kise omba pumbá kinia rasi-witi nou lemba, inia topo lipu taltomolo.” nilimili kanumu. Aku-sipa na-kolo nane onondo nimbuli: “Kaliama kaname! Kere-langi pali koronga nou liemu.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kere-langi inia tondolemo yemo kere-langi inia tondolemomonga méle kaloli koronga lipa, ‘Lepa mindi pupili.’ nimba kere-langima inia tondopa molemo. Aku sendelemomonga kalia sepa kere-langi panjerimu yemo kinia kere-langi inia tondolemo yemo peatolo konopu singilí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Akumunga ungu se pelemomo sika. ‘Ye sene kere-langi umbu tondolemo. Sene kere-langi inia tondolemo.’ nilimili ungumu sika. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kere-langi onone umbu naa toringima nane “Ono inia to-paa.” nimbu lipu mundorundu. Yombo lupamane kalia kála seko seringi, aku-na-kolo yombo lupamane seringi kere-langima ono inia tolemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ambomone “Na ungu serinduma pali yuni na nimba simu.” nirimu-kulu pilkuli kanu taonona moloringi Sameria yombo awisili ‘Yu sika Pulu Yemone ‘Ono nokopa kondomba ye se lipu mundumbu.’ nimba u nimba taltorumu ye nokoli Karasimu.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Akumunga Sameria yomboma yu molorumuna ongo, “Nu paa ya pea molamili.” niringi, kanu-kinia wale talo yu ono-kinia molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kanu-kinia yombo awisili pea yu yuyu ungu nirimumu pilkuli ‘Yu sika ⸤ye nokoli Karasimu omba molemo. Yuni sika nikimu.⸥’ ningu kuru mondoringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Onone ambomondo ninguli: “Nuni u ungu ninumu pilipu ‘Yu sika ye nokoli Karasimu.’ nimbu kuru mondomulu-na-kolo kiniá olio oliolio yunga ungumu pilipuli ‘Sika i yemo olio mana-yomboma Lipa Tapondopa Mindili Nolemolá Aulkana Wendo Limú Yemo molemo.’ nimbu kuru mondokomolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sameria yomboma kinia wale talo molopale Yesusi ono mundupa kelepa kolea Gallilli disiriki pumbá purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Gallilli Yesusi yunga pulu koleamo. U walte Yesusi yuni nimbale: “Pulu Yemone ungu-umbu tondolemoma pilipa yomboma nimba silimú ye sene yunga pulu koleamonga yomboma ungu nimba silimú kinia pilkuli nilimilimuni, onone ‘Yu olionga we-yere. Yu imbi mololi ye se mólo.’ ningu yu nilimú unguma naa pilku limilí.” nirimu kanumu.) ⸤ ‘We-koleamanga yombomane kanu yemonga ungumu limili-na-kolo yunga pulu lemó yombomane naa pilku limili.’ nimba nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yu Gallilli sukundu purumu kinia Gallilli yomboma yu orumu kanokole “Papu okono.” ningu konopu siringi. U Pulu Yemone Juda yombomanga anda-kolepalima Naa Topa We Omba Purumu mele pilieringi walema wendo orumu kinia ono Jerusalleme pungu molangi yuni akuna ungu mare serimu kanoringimunga onone aku siku seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesusi kolea Gallilli disiriki pumbale kelepa Kena taonona sukundu orumu. Kanu taonomonga u yuni umbu-no koloringima no-waene au lenderimu. Kapeniame taono ye nokoli kingimunga kongono sendeli ye awili se kanu kolea Kena molorumu, kanumunga malo kuru awili se torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","‘Yesusi kolea Judia disiriki mundupa kelepa kolea Gallilli disiriki sukundu orumu.’ pilipale nirimumuni, kanu yemo Yesusi molorumuna pumbale nirimumuni, yundu mawa sepa nimbale: “Nanga kangomo nondopa kolomba sekemo kene maniando ongo yu seko peanga si.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aku nirimu kinia pilipale Yesusini yundu nimbale: “‘Na sika ⸤Pulu Yemo kinia molopale mana maniando orumu⸥.’ we ningu kuru naa mondonge lémo. Pulu Yemone ulu-tondoloma selemo mele ‘Yuni aku sipa mele sembá kinia kanopole ‘Yu sika ⸤Pulu Yemo kinia molopale mana maniando orumu⸥.’ nimbu kuru mondomolo.’ ningu nando alieli “Ulu-tondoloma ongo sei.” ningu mawa selemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kingimunga kongono sendeli ye awilimuni yundu nimbale: “Ye-Awilimu, nanga kangomo mini u naa pupili nu welea maniando ou.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesusini yundu nimbale: “Marena konde pumu kene pu.” nirimu. Yemone Yesusini nirimu mele pilipale ‘Sika nikimu.’ nimba kuru mondopa yu purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Maniando pumbá purumu kinia yunga kendemande-yema aulkana ongo yu maniando orumu kanoko likuli onone yundu ninguli: “Marena konde pumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kanu-kinia yuni onondo nimbale: “Ena nambolkana kuru topa keliemuye?” nimba mangilipa pilierimu. Onone yundu ninguli: “Oleanga awi-tangoli wane killoko mele kangi nomba keliemu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lapane pilipale Yesusini “Marena konde pumu.” nirimu kanu enamonga ‘Kangi nomba keliemu lepomo.’ nimba pilipale, yu kinia yunga ulka peringi yomboma kinia onone ‘Yesusi yu sika ⸤Pulu Yemo kinia molopale mana mania orumu lepomo⸥.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kolea Judia disiriki mundupa kelepa kolea Gallilli disiriki omba molopale Yesusini kangomo sepa konde liltimu kanu ulumu aku koleana yu molorumu mele lipa ora sirimu ulu-tondolo talo sipa mele serimu. Se u walte aku koleana umbu-no koloringima no-waene au lenderimu kanumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pe walte, Juda yombomane kalia-ingi senga senga ningu Jerusalleme pungu Pulu Yemo-kinia ungu se seringi wale se wendo orumu kinia Yesusi Jerusalleme olando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalleme sukundu, kongi sipisipimanga pala kerepuluna nondopa, nomu se molorumu, kanu nomumundu Ipuru unguna ‘Beteseda’ niringi, akuna ulka takaya se-pakara gilipa makapu serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Akuna kuru torumu yombo awisili aniembo lieringi. Mongo kiri lierimu yomboma kinia, kimbu pange sepa karaye sepa perimu yomboma kinia, kimbu kolopa kukorumu yomboma kinia, onone ( ‘Nomo lope-lope sembá.’ ningu nokoko moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Walte walte nimba Ye-Awilimunga angello se mania omba nomo lope-lope senderimu kinia yombo se kumbi lepa nona suku purumu yombomo peanga lierimu.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ye se akuna molorumu kalia-ingi wane paono tene et kuru torumu yu aniembo lierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesusi omba, yemo aniembo lierimu kanopa, yu koro-u lipa aniembo lierimu pilipale, yemo mangilipa nimbale: “Nu ‘kuru peanga liepili.’ konopu lekenoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aniembo lierimu yemone pundu topa nimbale: “Ye-Awilimu, no lope-lope selemo kinia yombo se na lipa tapondopa nona memba pumbá se naa molemo. Na nanu pumbú selio kinia yombo mare u kumbi leko nona pulimili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aku nirimu kinia Yesusini yundu nimbale: “Nu ola gilku nunga uru peleno kunungumu liku mengo ongo pu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aku nirimu kinia waltikele yemonga kurumu pora nirimu kinia yu ola gilipa yunga kunungumu lipa memba purumu. I ulu wendo orumu wale akumu ⸤koro moloringi⸥ wale Sambate se, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","akumunga Juda ye ⸤awili⸥ marene kuru pora nirimu yemondo ninguli: “Kiniá ⸤koro mololi⸥ wale Sambatemonga nambi semu-na nunga kunungumu mengo ongo pukunuye? ‘Sambate wale kinia mélema naa memba andaa.’ nimba ungu-mane pelemo kanumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aku-na-kolo yemone pundu topa nimbale: “Na sepa peanga simu yemone nimbale: ‘Nunga kunungumu liku ambolko pu.’ nimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aku nirimumunga onone yu kelko mangilku ninguli: “Ye nawene ‘Nunga kunungumu liku ambolko pu.’ nimuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aku-na-kolo ye kuru pora nirimu yemo u aniembo lierimu koleana yombo awisili moloringi-kulu Yesusi kiyongo nimba purumumunga yuni manda yunga imbimu mangilipa naa pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pe Yesusi kanu yemo ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena kanopa yundu nimbale: “Pilie. Kiniá nunga kuru pora nimu nu kelko peanga liepili moleno kene nu ulu-pulu-kirima manda seko, kelko naa sei! Kelko senu liemu nu ulu umbuna awili se wendo ombánje.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ye kanumuni anju pumba Juda ye awilimando nimbale: “Na sepa peanga simu ye kanumu Yesusi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesusini ono koro moloringi wale Sambatemonga aku sipa uluma serimu-kulu Juda ye awilimane Yesusi yu pulu polko seko kinjiku umbuna siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesusini onondo nimbale: “Tatane u yomboma walemanga pali lipa tapondorumu mele kiniá kepe aku sipa sepa molemo. Na aku sipa Sambate walemanga kongono seliola.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yuni aku nirimu-kulu pilku Juda ye awilimane ‘Yesusi yu paa kamu topo kondomolo.’ konopu leko aulka se koroko moloringi. U Sambate walemonga ungu-manemo pulua torumumunga pilku yu mumindili kolkole; pe “Pulu Yemo yunga lapa.” nirimumunga yu ‘Pulu Yemo kinia manda selu sipu molembolo.’ nimba nirimumunga yu kamu mumindili kolko yu toko kondonge seringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesusini onondo pundu topa nimbale: “Nane ono paa sika nimbu sikirumu: “Malone yuyu uluma manda naa selemo sembá. Yunga Lapane selemo mele kanopale manda manjipa selemo. Lapane selemo uluma mindi Malone selemo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nambi semu-na, Lapane Malo konopu mondopale yuni selemo mele pali Malo lipa ora silimú. Ye sepa peanga simu akumu maniandopa. Paa sika pe ono paa kanoko konopu awisili liku mundungí ulu-tondolo olandopama Lapane Malo lipa ora simba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Akumu nambi sepa wendo ombáye? Lapane yombo kololima topa makisindipale ‘Konde molangi.’ nilimú mele aku sipa Malone yombo kololima ‘Konde pangi.’ konopu lemó yomboma sepa konde limú. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ungu se pea i-sipa: ‘Yombomane Lapanga imbimu ambolko paka tondolemele mele Malonga imbimu aku siku ambolko paka tondangi.’ nimba Lapane kote pilipa yomboma naa apurupa kote pilieli kongono akumu Malo sirimu. Akumunga, yombomane Malonga imbimu ambolko paka naa tondolemele yombomane aku siku Malo yando lipa mundorumu Lapanga imbimu kepe ambolko paka naa tondolemelela. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nane onondo paa sika nimbu sikirumu: “Nanga ungumu pilku, na lipa mundorumu-na orundu yemo ‘Yu sika Pulu Yemo.’ ningu kuru mondolemele yomboma konde molopa mindi puli ulu-pulumu ono-kinia pelemo. Pe kote walemo wendo ombá kinia ono kotena naa gilingíla. Kanu yomboma kololi ulu-pulumu pelemo aulkamo munduku kelko konde molopa mindi puli aulkana pulimili.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nane onondo paa sika nimbu sikirumu: “Wale wendo ombámo kiniá koronga wendo omu. Kanu walemonga Pulu Yemonga Malonga ungumu kololi yomboma pilingí. Kanu-kinia yunga ungumu ‘Sika’ ningu pilku liku molonge yomboma konde molonge.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mélema konde mololi ulu-pulumu Lapa-kinia pelemo mele aku sipa Lapane ‘Mélema konde mololi ulu-pulumu Malo-kinia pepili.’ nirimula. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Malo yu Mania Omba Mana-Ye Au Lierimu Yemo molemomonga Lapane ‘Malo yombomanga kote piliepili.’ nimba nambamo sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Aku-sipa na-kolo akumunga mindi ono konopu awisili liku naa mundangi. Nambi semu-na, wale se wendo ombá, kanu walemonga yombo óno selemele koleana pelemelemane Malonga ungumu pilkuli ningímuni, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","óno-koleamo munduku kelko wendo onge. Kanu-kinia lomboroko ola molonge yombomanga u mana konde molkole seko kondoko moloringi yomboma konde molonge; u mana seko kinjiku moloringi yomboma pe kotena gilkuli pe mindili nonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na nanu ulu se manda naa sembó. Tatane nilimú mele pilipuli yombomanga kotema apurupu pilielio. ‘Na nanu konopu siembo.’ nimbu uluma naa sepo, ‘Na lipa mundorumu yemo konopu sipili.’ nimbu uluma seliomonga kote sumbi sipu pilipu apurupu kondolio.” ⸤nirimu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sika na molio mele na nanu nimbu sindu liemu ‘Kolo tokomonje.’ ningu piliengi liemu peanga. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ye sene lupa na molio mele nimba silimú, akumu na pilkiru nando nilimú mele paa sika nilimú, ‘Kolo tokomonje.’ manda naa ningí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Onone ye mare ⸤No Lindeli⸥ Jono molorumuna “Paa.” ningu liku mundoringi kinia yuni na sika molio mele nimba sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mana-yombo sene na molio mele yomboma nimba sipa “Sika nikimu. Sika aku sipa molemo.” nimu liemu na konopu awisili lipu naa mundupu, ‘Unguri mólo.’ konopu lelio, na-kolo ‘Pulu Yemone ono lipa tapondopa mindili nolemolá aulkana wendo lipili.’ nimbu Jonone nando nirimu mele ono nimbu sikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonone kongono serimumunga yu kiya mele nomba yomboma pa senderimu. Kanu-kinia wallo-kolte ono konopu siku kanu pa senderimuna moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Aku-sipa na-kolo Jonone na lipa tapondopa na molio mele ono nimba sirimu mele maniandopa. Ulu se na molio mele lipa tapondopa lipa ora silimú mele olandopa. Tatane “Ulu-tondolo seko pora sieni.” nimba na sirimu ulu-tondolo selio kanumane na lipa tapondopa, Tatane na “Pu.” nimba lipa mundorumu mele ono lipa ora silimú. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tatane na “Pu.” nimba lipa mundorumu-na orundumuni kepe nanga nimba para sindélimu molopa na molio mele nimba sirimu. Onone yunga kerena ungu nirimuma waltikele kepe komumuni naa pilku, yunga kumbi-keremo mongomane naa kanoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ungu se pea kepe. Tatane lipa mundorumu yemonga ungumu “Kolo tokomo.” ningu pilku kuru naa mondolemelemonga yu lipa mundorumu Lapanga ungumu ononga konopumanga naa pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","‘Pulu Yemonga bokuna ungu molemomane olio alieli konde molopo mindi pumulú ulu-pulumu simba.’ ningu mimi siku kanolemele. Aku mimi siku kanolemele bokumuni na molio mele nimba silimú-na-kolo ‘Konde molopo mindi pumulú ulu-pulumu liemili.’ naa ningu, na moliona ‘naa omolo.’ ningu karaye selemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“‘Yombomane na kape ningu nanga imbi ambolko paka tondonge kinia na ye awilimu molambo.’ nimbu aku naa selio. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ono molemele mele nane pilielio. Pulu Yemo konopu mondoli ulu-pulumu ono-kinia naa pelemo pilielio. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nanga Tatane na namba sipa yunga kongonomo ‘sende-pou.’ nimba na lipa mundorumu-na orundu-na-kolo nanga ungumu ono naa pilku limili. Aku-sipa na-kolo yombo sene yuyu namba lipa omba kongono selkanje aku yombomonga ungumu pilku limola. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ono onono anju yando ‘imbi molopili.’ ningu, Pulu Ye selumu mindi molemo akumuni ononga imbi ‘ambolopa paka tondopili.’ naa nilimili liemu na molio mele nimbu siliu ungumu ‘Sika nikimu.’ ningu nambi seko kuru mondongeye? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Aku-sipa na-kolo ⸤na-kinia⸥ seko kinjilimilimunga ‘Pulu Yemonga kote walemo wendo ombá kinia Tatane kote pilipa molopili nane nanu kote sendemba.’ ningu naa piliangi. ‘Mosisini ono lipa tapondomba.’ konopu lemele yemone ononga kote sendemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosisini na ombo molombo mele boku torumu-na onone ‘Mosisini nirimu unguma sika nirimu.’ ningu kuru mondolemolánje nanga ungumu kepe ‘Sika nikimu.’ ningu kuru mondolemolá-la. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aku-sipa na-kolo yuni nanga semane bokuna torumumu ‘Sika nikimu.’ ningu kuru naa mondolemelemonga nanga ungu nikirumu ‘Sika nikimu.’ ningu nambi seko kuru mondongeye?” nimba Yesusini nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pe walte Yesusi Gallilli Nomu nona andoli sipina molopa nekendo purumu. (Aku nomumunga imbi se ‘Tapirias Nomu’ niringi.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aku nomuna nekendo purumu kinia kuru torumu yomboma sepa peanga sirimu kanokole ‘Pulu Yemone mindi ulu-tondoloma selemo mele yuni aku sipa sekemo.’ ningu kanokole yombo paa awisili yu purumuna akileko lombili puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesusi ma-pangina ola pumba lombili andolima pea pungu mania moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juda yombomane ⸤kalia-ingi senga senga kolea-awili Jerusalleme ongo akuna sukundu⸥ Pulu Yemone ononga anda-kolepalima Naa Topa We Omba Purumu mele pilingindu Pulu Yemo kinia ulu se seringi walema nondopa wendo ombá serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesusi ma-pangina ola molopa maniando sipa kanopale yombo paa awisili yu orumu aulkana lombili oringi kanorumu. Kanopale yuni yu lombili andoli ye Pillipundu nimbale: “I yomboma nonge kere-langima sena topo topo lindamili konopu lekenoye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yuni aku sipa Pillipundu we mangilipa pilierimu. Yesusi yuni sembá mele yuyu pilipa molorumu-na-kolo ‘Pillipu yuni nambolka nimbánje? ‘Nane ulu-tondolo se sepole manda kere-langi simbú.’ konopu lemba, molo we mini-wale mundumbanje piliambo.’ nimbale yuni aku sipa Pillipundu mangilipa pilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pillipuni yundu nimbale: “Kakopoi-ye sene oli engaki kongono sepale méle kalólimu limú kou-monemane kere-langi topo topo limolanje yombo mare mindi kanga-kolte liku nolemolá. Mare mólo tolka naa nolemolá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lombili andoli se, Saimono Pitanga genu Enderu, yuni nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ya kango se rasi-balli pellawa kaloli kanga se-pakara kinia oma kaloli talo kinia taltopa molemo. Aku-na-kolo akumu koltalo, yombo paa awisili. Manda naa sembá lémo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesusini “Yomboma “Mania molangi.” niengi.” nirimu. Aku koleana era awisili orumu-na mania moloringi. Ye paip tausini mele akuna mania moloringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kanu-kinia Yesusini balli-pellawa kalolima lipa ambolopale Pulu Yemondo “Ange.” nimba yombo moloringima moke sepa ono manda nonge mele sirimu. Omatolo aku sipala moke serimu. Nongo olo senderingi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kanu kere-langi noringi olo serimu kinia yuni yu lombili andolimando nimbale: “Kere-langi kakena lemóma we mania pumba lemba manda naa sembá kene liku maku taa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kanu-kinia nongo pora siringi kinia kakena lierimuma lombili andolimane liku maku toko wale-basikete engaki rurepo lakilku toko peke siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesusini Pulu Yemone mindi ulu-tondolo manda selka mele akumu serimu kinia kanokole yombomane pulu polko ninguli: “ “Pulu Yemone ungu-umbu tondolima pilipa yando nimba simba ye se ma-koleana omba olio nokomba.” ningu panjeringimu paa sika i yemo yu lepomo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aku ningu pilkuli onone ‘Yu olionga ye nokoli kingimu molopili.’ ningu yu tondolo munduku ambolko liku ‘ononga kingimu molopili.’ ningí seringi. Aku senge seringi pilipale yu yuyu molombando ma-pangina ola kelepa pumba molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena pumba kolea kala torumu kinia yu lombili andolima ma-pangina maniando pungu nomu kelona maniando pungu ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","akuna nona andoli sipi senga ola pungu nomuna yakondo ongo Kapeniame taono ongo pungí puringi. Aku-kinia simbulu torumu-na-kolo Yesusi naa orumu-kulu lombili andolima onono puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","⸤Sipimunga ola molko pungí puringi kinia⸥ poporome tondolo torumu kinia nomo ola pumba mania omba serimu, sipimu topa ola-munda mania-munda sepa topele-mapele torumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sipimu kundoringi nomu awi-suku-singi melena purumu kinia Yesusi nomuna ola kimbu kulupa sipimu purumuna orumu kanokole ‘Kuru se okomo.’ konopu lekole paa mini-wale awili seko mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aku-sipa na-kolo yuni onondo nimbale: “Na mindi okoro, pipili naa kolaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aku nirimu-kulu pilkuli “⸤Ye-Awilimu okomo lepomo.⸥ Sipina pea molamili.” ningu onone konopu siku yu sipimunga sukundu liltingi. Sukundu orumu kinia ono pungí puringi nomu kelona sipimu waltikele purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Orili-u yomboma nomu kelo nekendo ipulieli moloringima konopu kimbu sikuli niringimuni, ‘Oleanga ipulieli nomuna andoli sipi selu mindi ya liemu, Yesusi akuna sukundu naa pumu, yu lombili andolima onono akuna sukundu pungu nomu kelo nekendo púngi.’ ningu pilieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kanu-kinia oleanga Ye-Awilimuni kere-langi kanga-kolte lipa ambolopa Pulu Yemondo “Ange.” nimba yomboma sirimu noringi koleana nondopa kolea-awili Tapirias yombomanga sipi mare nomu kelona oringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yesusini kere-langi sirimu noringi koleana yombomane Yesusi yu korokole niringimuni, yu kinia yu lombili andolima kinia akuna naa moloringi kanokole sipi ono moloringina nomu kelona nondoko ongo lieringimanga sukundu pungu Kapeniame taonondo Yesusi koronge puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nomu nekendo ongo Yesusi kanoko lendekole onone yu mangilku pilku ninguli: “Rapai, nu sewale yando onuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aku-na-kolo yu orumu mele nimba para naa sipale pundu topa onondo nimbale: “Nane onondo paa sika nimbu sikirumu: “Nane ⸤Pulu Yemone na lipa tapondolemo mele⸥ lipa ora silimú ulu-tondoloma seliomonga onone na naa korokomele. Nane ono kere-langi sindu nongo olo sendengi kanumunga mindi na korokomele lémo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ono kere-langi nondopa purulimuma ‘Lipu nomolo.’ ningu kongono naa sayo. Kanu kere-langima nongole nilimilimuni, kolonge walema wendo olemo kinia kololemelela. Kere-langi, Mania Omba Mana-Ye Au Lierimu Yemone silimú kere-langi, kanumu naa purulimú, kanumu nolemele kinia konde molko kondoko mindi pulimili kanu kere-langimu ‘Lipu namili.’ ningu mindi kongono sayo. ‘Ye akumuni sika kanu kere-langimu yomboma simba.’ ningu piliangi.’ nimba Pulu Yemone ulu-tondoloma selemo mele ‘Aku yemone ulu-tondoloma aku sipa sepili.’ nimba Pulu Yemo yuni yu sirimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","( ‘Sika kere-langimundu nikimu.’ ningu pilku yuni nirimu ungumu pilku sundukuli niringimuni,) onone yundu mangilku pilku ninguli: “Konde molopo mindi pumulú kere-langi lipu namili kene olio nambi sepole Pulu Yemone kanopa peanga pilimba kongonoma semoloye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yuni pundu topa nimbale: “Pulu Yemonga kongonomo i-sipa: ‘Pulu Yemone ma-koleana lipa mundorumu yemo yu sika Pulu Yemonga malo, ⸤yu sika olio molopo kondopo mindi pumulú ulu-pulumu simba yemo⸥.’ ningu kuru mondoko molaa.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aku nirimu pilkuli onone yundu mangilku ninguli: “Nuni ‘ “Na sika Pulu Yemone lipa mundorumu. Nane nikiru unguma sika unguma.” niliu akumu ‘Sika.’ ningu kuru mondangi.’ ningu Pulu Yemone mindi ulu-tondolo manda selemo uluma mele nuni aku siku nambolka ulu-tondolo se liku ora siniye? Nambi seni kinia kanopole ‘Nuni sika nikinu.’ nimbu kuru mondomolonje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“Olionga anda-kolepali u moloringima kolea ku lielina kere-langi mana noringi. Kere-langi mana orumu mele Pulu Yemonga bokuna semanemo molemo: ‘Yuni ‘Ono mulu-koleana yando kere-langi nangi.’ nimbale sirimu.’ ungu akumu molemo. ⸤Nuni olionga aku siku sendeni molo nambi seniye?⸥ niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesusini onondo nimbale: “Nane onondo paa sika nimbu sikirumu: “Moloringi yomboma mulu-koleana yando kere-langi sirimu yemo Mosisi mólo. Tatane sirimu. Molko kondoko mindi puli ulu-pulu pelemo kere-langi nikiru kanu sika kere-langimu mulu-koleana yando silimú yemo Tata mindila.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mulu-koleana mania omba mana-yomboma molko kondoko mindi pungí ulu-pulumu silimúmu yu Pulu Yemone silimú kere-langimu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesusini nirimu mele pilku sundukuli, “Ye-Awilimu, aku kere-langimu kiniá kepe pe-pe kepe si.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kanu-kinia Yesusini onondo nimbale: “Molko kondoko mindi pungí kere-langimu na. Umbu kere-langi nongole gele naa kolko kangi tondolo pupili molemele mele aku sipa na molombona onge yomboma ononga minimu gele naa kolomba, konopu tondolo pupili molonge. Umbu-no nongole no nonowalene naa kolko manda molemele aku mele na niliu unguma kepe molio mele kepe manda sembó mele kepe ‘Sika.’ ningu kuru mondonge yomboma kelko alieli minimu no nonowale naa sepili molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aku senge yomboma aku siku molonge-na-kolo “Onone na ⸤Pulu Yemonga ulu-tondoloma selio mele⸥ kanokole kanoko sunduku ‘We selemo. Yu Pulu Yemone naa lipa mundorumu.’ ningu kuru naa mondolemele.” u nimbu sirindu kanu mele kiniá kepe aku siku we seko molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tatane ‘Nanga yomboma molangi.’ nimba, nimba taltondolemo yomboma pali na molombona onge. Kanu-kinia na lombili andongendo na molombona onge yomboma selurindu kepe “Lombili naa ongo anju pu.” paa naa nimbúmu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“‘Na nanu konopuna pilkiru mele sambo.’ nimbu na mulu-koleana mundupu kelepo mana maniando naa orundu, mólo. Na lipa mundorumu ⸤ye⸥mone konopuni pilielemo mele sembó orundu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na lipa mundorumu yemone konopuni pilierimu mele i-sipa: ‘Nane ⸤Malo⸥ simbú yomboma pali ⸤Malone⸥ nokopa kondopa, selu kepe mundupa kelepale mindili nonge koleana paa naa pumbá, ma-kolea pora nimbá walemonga ono pali topa makisindipa olando lipili.’ konopu lemó. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na lipa mundorumu Tatane konopuni pilierimu mele i-sipa: ‘Nanga malo ‘olio lipa tapondopa, mindili nolemolá aulkamo wendo limba.’ ningu kuru mondonge yomboma molko kondoko mindi pangi.’ nimba konopuni pilielemo. Kanu-kinia aku senge yomboma ma-kolea pora nimbá walemonga kinia nane topo makisindipu olando limbu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesusini “Na mulu-koleana maniando orundu kere-langimu.” nirimu pilku kiri pilkuli Juda ye awilimane yu mumindili kolko onono pulu polko kono-kono ningu ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ninguli: “Aku ungu nikimu yemo Joseponga malo Yesusi mindi. Yunga anumu lapatolo kanolemolo kanumu. Pe yu “Mulu-koleana molopo mana maniando orundu.” nikimumu nambi sepa nikimuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesusini nimbale: “Ono anju yando kono-kono manda nieme! ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yombo seluri kepe na we manda naa lombili onge. Na lipa mundorumu Tatane konopuna kundulimú yomboma mindi na lombili olemele. Na moliona ongo na kuru mondolemele yomboma kolea pora nimbá walemonga nane topo makisindipu olando limbu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pulu Yemone ungu-umbu tondorumu-yema pilku yomboma ningu siringi yemanga bokuna molemo ungu se i-sipa: “Pulu Yemone yomboma pali ungu-mane simba.” ningu toringi bokuna aku sipa molemo. Tatane nilimú mele pilkuli kanu ungumanga puluma pilku limili yomboma pali na moliona olemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tatanga ungumu pilielemele nikiru akumu paa sika yunga ungumu pilielemelemondo nikiru-na-kolo yu mongomane naa kanolemele. Ma-koleana yombo selurini kepe Tata naa kanoringi naa kanolemele. Yombo selumuni mindi yu kanorumu. Tata kinia molopale mania orumu ⸤ye⸥mone mindi yu kanorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nane onondo paa sika nimbu sikirumu: “Niliu unguma ‘Sika nilimú.’ ningu kuru mondolemele yomboma molko kondoko mindi pungí ulu-pulumu ono-kinia pelemo.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mini pali molko kondoko mindi pungí gamo na. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ononga koro-u moloringi yombomane kolea ku lielina kere-langi mana noringi-na-kolo molko mindi naa puringi. Ononga kolonge walema wendo orumu kinia koloringila. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Aku-sipa na-kolo i kiniá nikiru kere-langimu mulu-koleana maniando okomo kere-langimu. Akumu nonge yomboma mini pali naa kolonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pora naa nimba we lepa mindi puli kere-langimu, akuna sukundu molko kondoko mindi puli ulu-pulumu pelemo kere-langimu, akumu mulu-koleana maniando orumu kere-langimu na. Aku kere-langimu nanga kangimu. ‘Ma-koleana yomboma, mini pali molko kondoko mindi pangi.’ nimbu nane nanga kangimu ononga kere-langi simbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","⸤Yesusini aku nirimu pilku sundukuli,⸥ yombomane angelema ninguli, “I-yemo olio yunga kangimu “Nangi.” nimba nambi sepa manda simbando nikimuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesusini onondo nimbale: “Nane onondo paa sika nimbu sikirumu: Onone Mania Omba Mana-Ye Au Lierimu Yemonga kangimu naa nongo yunga mememo naa nongi liemu molko kondoko mindi puli ulu-pulumu ono-kinia manda naa pemba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nanga kangimu kinia mememo-tolo nonge yomboma alieli molko kondoko mindi pungí ulu-pulumu ono-kinia pelemo. Kanu yomboma ma-kolea pora nimbá walemonga nane topo makisindipu olando limbu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Nanga kangimu kere-langi sikamo; nanga mememo no sikamo. Umbu ga kinia notolo nongole, kolonge wale wendo olemo kinia kololemele. Aku-sipa na-kolo nanga kangimu kinia mememo-tolo nolemele yomboma molko kondoko mindi pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nanga kangimu kinia mememo-tolo nolemele yomboma ono na-kinia kopu seko molemele, na ono-kinia kopu sepo molio. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Molopa mindi pulimú Tatane na lipa mundorumu, yuni na ‘Molko mindi pani.’ nirimu-na molopo mindi puliu, aku siku melela na nonge yomboma ‘Molko mindi pangi.’ nimbú, kanu-kinia ono mini pali molko mindi pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aku kere-langimu mulu-koleana maniando orumu kere-langimu. Olionga u anda-kolepali moloringimane kere-langi mana nongole ⸤kolonge walema wendo orumu kinia⸥ koloringi, na-kolo pe kiniá orumu kere-langimu kinia u orumu kere-langi manamo kinia selu-sipa mólo. Pe kiniá orumu kere-langi imu nonge kinia alieli molko kondoko mindi pungí.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Juda yomboma maku toko Pulu Yemonga ungumu pilieringi ulka se, Kapeniame taonona gilierimu, akuna sukundu Yesusini yomboma ungu-mane sipa aku unguma nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesusini ⸤yunga kangimu kinia mememo-tolo kere-langi kinia no kinia nongemonga⸥ nirimu mele pilkuli Yesusi lombili andoringi yombo awisilini ninguli: “I ungumu aroma topa nikimu. Nawene manda pilipa limbaye? Olio naa pilkimulu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yu lombili andoringi yomboma yuni nirimu ungu akumu pilku kiri pilku anju yando kono-kono ningu angelema niringi Yesusini pilipale nirimumuni, yuni onondo nimbale: “I ungumu ono pilku kiri pilkimiliye? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pe kiniá Mania Omba Mana-Ye Au Lierimu Yemo u molorumuna kelepa olando pumu kanongi liemu nambi sengeye? Kamu mumindili kolongenje? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Minimuni konde molko puli ulu-pulumu silimú; kangimuni konde molko pungí unguri naa selemo. Nane onondo ungu nindu akuma konde molko mindi puli ulu-pulumu. Akuma ononga konopumanga sukundu pemba kinia ono mini pali konde molko mindi pungí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aku-sipa na-kolo ono molemele yombo marene ‘yu kolo tokomo.’ ningu kuru naa mondokomele.” nirimu. Yuni pilipa ‘Yu kolo toli yemo.’ ningu kuru naa mondonge yomboma kinia ‘Yu sika ungu nili yemo.’ ningu kuru mondonge yomboma kinia koronga apurupa pilipa, Yesusi yu yunga opa-touma lipa simba yemo koronga pilipa molorumu-kulu “Ono marene na ‘Kolo tokomo.’ ningu kuru naa mondokomele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yuni ungu se pea nimbale: “Ono marene na ‘Kolo tolemo.’ ningu pilku kuru naa mondolemelemonga ‘Tatane “Na moliona paa.” ni naa nilimú yomboma na moliona manda naa ongo, na manda kuru naa mondoko andonge.’ u nimbu sindu kanumu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aku ungu nirimu enamonga kepe pe enamanga kepe yu lombili andoringi yombo awisili yuni nirimu mele pilku kiri pilkuli yu munduku kelko bulu siku kelko yu lombili naa puringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yu munduku kelieringi kinia yu lombili andoli rurepondo yuni mangilipa pilipa nimbale: “Ono kepe na ‘Mundupu kelepo anju pumulú.’ konopu lekemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimono Pitane pundu topa nimbale: “Ye-Awilimu, nawe molemona pumulúye? Molopo kondopo mindi pumulú unguma nu-kinia pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nu Pulu Yemone nimba taltopa ‘Nanga Ye Kake Sélimu’ nirimu yemo moleno olione pilipu pora sipu kuru mondolemolo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusini pundu topa nimbale: “Nane nanu ono rurepondo pali ‘Nanga yema molangi.’ nimbu, nimbu taltorundu-na-kolo ononga ye se ⸤kuru⸥ depelemo mele molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Aku nirimumu Saimono Isikeriote malo Judasini sembamondo pilipale nirimu. Judasi Isikeriote yu ono ye rurepo akupokonga ye se na-kolo yuni pe Yesusi lipa yunga opa-touma sirimu-na toringi.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kanu-kinia pe Yesusi kolea Gallilli disiriki andopa molorumu. Juda ye awili kolea Judia disiriki moloringimane yu toko kondongendo nokoko moloringimunga pilipale yu kelepa ‘Judia naa pumbú.’ nimba anju molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aku-sipa na-kolo Juda yombomane u kolea ku lielina serele-ulka takoko peringi walema pilieringi wale kake selima nondopa wendo ombá serimu kinia ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesusi yunga genupilini yundu ninguli: “‘Nuni ‘ulu-tondoloma seleno mele nu lombili andolemele yomboma kanangi.’ ningu nu ya munduku kelko Judiando pani.’ konopu lekemolo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“Yombo sene ‘yu kongono sepa molemo mele pilku yu kanoko imbi siengi.’ nimba uluma lopi sepa naa selemo. Akumunga nu aku uluma sika seleno liemu yombomane pali kanangi pungu se-pu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesusinga genupilini kepe ‘Yesusi yu Pulu Yemone lipa mundorumu-na orumu yemo.’ ningu kuru naa mondokole aku siku niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aku niringimunga Yesusini onondo nimbale: “Nanga walemo u wendo naa oli. Kiniá alieli ulu senge walema ononga walema. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma-kolea yombomane ono-kinia konopu kiri naa panjilimili-na-kolo nane yombomando “Ulu selemelema seko kinjilimili.” niliumunga na-kinia konopu kiri panjilimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ono wale kake sélimu wendo ombá pili-pungí liemu pangi. Aku-na-kolo nanga walemo u naa wendo okomo-na na ⸤iseli-u⸥ naa pumbú.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aku nimbale yu Gallilli we molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aku-sipa na-kolo Yesusi yunga genupili ‘Wale kake selima pea piliamili.’ ningu u puringi kinia Yesusi kepe purumu. Aku-sipa na-kolo Yesusi yu ‘naa kanoko imbi siengi.’ nimba kiyongo nimba kolea Judia disiriki pumba kolea-awili Jerusalleme purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akuna Juda yombomanga wale kake selima pilieringi Juda ye awilimane ‘Yesusi omunje.’ ningu koroko molko onono ninguli: “Kanu yemo sena molemonje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","We-yombomanga awisilini yundu olo toko ningu andoko moloringi. Marene ninguli: “Yu ye peangamo.” niringi. Aku-na-kolo marene ninguli: “Yu yandopa yomboma kolo topa silimú.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Aku-sipa na-kolo ono Juda ye awilima pipili kolkole ‘Olio nikimulu mele ono pilkuli olio seko kinjingí.’ ningu ungu tondolo seko naa niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kake seli walema u wendo orumu suku-singina Yesusi ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena pumba yomboma mane sirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mane sirimu mele pilkuli Juda ye awilimane mini-wale munduku ninguli: “Nambi sepa i yemo pilipa kondoli pelemoye? Yu sukuli awili senga naa purumu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesusini pundu topa nimbale: “I ungu nimbu siliumu nanga ungu se mólo. Na lipa mundorumu-na orundu yemonga ungumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","‘Pulu Yemone “Saa.” nilimú uluma pilipu lipu sambo.’ konopu lepa molemo yombomone nane ungu niliu ungumunga pulumu pilipale, ‘Nane Pulu Yemonga ungumu nilimú.’ molo ‘Yuni yuyu konopumuni pilipa nilimú.’ nimba pilimba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yombo sene yuyu konopumuni pilipale ungu nimba silimúmuni ‘Nanga imbi ola molopili.’ nimba selemo, aku-na-kolo yombo sene ‘Lipa mundorumu yemonga imbimu ambolopo paka tondambo.’ nimba kongono selemo yombomo yu sumbi nili yombo se molopa, sepa kinjipa kolo toli yombo se naa molemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","U Mosisini ono Pulu Yemonga ungu-manema naa sinderimuye? Sirimu-na-kolo ono molemelemanga selurini kepe kanu ungu-manema pilku sengena panjiku naa selemele. Aku liemu ‘Na kanu ungu-manema pulua tolemo.’ ningu nambi semu-na toko kondonge sekemeleye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yuni aku sipa nirimu pilkuli yombomane pundu toko ninguli: “Nawene nu topa kondomba sekemoye? Nunga konopuna kuru se molemomonga pilkuli aku siku nikinu lepomo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesusini onondo pundu topa nimbale: “Nane ulu-tondolo se serindu kinia ono konopu awisili liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosisini ‘Kangomanga kangi se makaye seko kopisangi.’ nimba ungu-mane sipa panjerimumunga ono ⸤koro molemele⸥ wale Sambatemo kinia kangomanga kangi se makaye seko kopisilimili. (Sika Mosisini u-pulu-pulu ‘aku ulumu samili.’ ni naa nirimu. U ononga anda-kolepalimane aku ulumu seringi, na-kolo pe Mosisini kanu ungu-manemo sipa panjerimumunga pilkuli selemele.) ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Onone Mosisini ungu-mane sirimumu pilku likuli kango senga kangi se kopisingí walemo ono ⸤koro molemele⸥ wale Sambatemo wendo olemo kinia kopisilimili liemu manda, na Sambate walemo kinia kuru torumu ye se sepo peanga sirindumunga na-kinia nambi semu-na mumindili kololemeleye? ⸤Sambate walemo-kinia kango senga kangi se kopisiku wendo likuli ‘Papu sekemolo.’ níngi liemu Sambate walemo-kinia nane ye senga kangi pali sepo peanga sirindu akumu papula serindu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Onone mongone kanolemele uluma kanokole sumbi siku ‘Imu sika. Imu kolo.’ ningu naa piliangi. Uluma mimi siku kanoko konopuni pilkuli sumbi siku apuruku kondangi.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yu aku sipa nimba molopili Jerusalleme moloringi yombo marene ono onono mangilku pilku ninguli: “I yemo ‘Topo kondamili.’ ningu molemele yemo naa molemoye? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aku-na-kolo kaname. Yombo awisili molemelena yu mona omba gilipa ungu-mane sikimu-na-kolo ye awilimane yu ungu se naa sekemele. Onone ‘Yu sika Pulu Yemone ‘Olio nokopa kondomba ye se lipu mundumbu.’ nimba, nimba taltorumu ye nokoli Karasimu.’ ningu pilkimilinje? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aku-na-kolo olione i yemonga pulu koleamo kanolemolo. Pulu Yemone lipa mundumba ye nokoli Karasimu ombá kinia yombo sene yu molopa ombá koleamo naa kanopa imbi simba.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Kanu-kinia Yesusi, u ulka-tembelena ungu-mane sipa molorumu mele we sipa molopale, ru nimba nimbale: “Sika onone na kanoko imbi siku, na molopo ondu koleamo kanolemeleye? Na nanu konopumuni pilipuli naa orundu. Na lipa mundorumu-na orundu yemo yu-kinia sika ulu-pulumu pelemo yemo. Kanu yemo ono naa pilielemele-na-kolo na yu pea molopole, yuni na lipa mundorumu-na orundu akumunga nane yu kanopo imbi siliu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aku nirimu-kulu pilkuli yu ambolko liku ka singí seringi-na-kolo yu toko kondonge walemo u wendo naa orumu-kulu yombo sene yu naa ambolorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yombo awisilini aku senge seringi-na-kolo yombo awisilini ninguli: “Pulu Yemone ‘Lipu mundumbu.’ nimba, nimba taltorumu ye nokoli Karasimu ombale nimbámone, i yemone yu molemo mele lipa ora silimú ulu-tondoloma selemo mele kanu yemone ulu-tondolo olandopama manda sembaye? ‘Ye nokoli Karasimuni sembá.’ nimbu pilielemolo uluma i yemone selemo.” ninguli ‘Yu sika kanu yemo.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yombomane aku sipa Yesusi molorumu mele aku siku anju yando olo toko angelema niringi mele Juda ye awili Parisimane pilkuli niringimuni, ono kinia Pulu Yemo popo tondoringi ye awilima kinia onone ulka-tembele ele-ye mare “Yesusi pungu ka si-paa!” ningu liku mundoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kanu-kinia Yesusini nimbale: “Laye-kolo mindi ono-kinia molopole, pe na lipa mundorumu yemo molemona kelepo pumbú. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pe onone na koronge-na-kolo naa kanoko, molombona manda naa onge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda ye awilimane onono anju yando angelema ningu ninguli: “Yu sena pumbá-na olio manda yu naa pumbu kanomoloye? Aku liemu olionga Juda yombo mare u kolea lupamanga puringi molemele koleamanga pumba yombo talape lupama ungu-mane sipa molomba-na naa kanomolonje? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yuni u nimbale: “Na koronge-na-kolo onone na naa kanonge. Na molombona ono manda naa onge.” nimu kanumu ungu-pulumu nambolkanje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pe, yomboma Jerusalleme ongo maku toko kake seli walemanga uluma seringi walema pora nimbándo wale awilimu wendo orumu kinia Yesusi ola gilipa tondolo mundupa nimbale: “Yombo se no nonowalene kolomu liemu na moliona omba no nopili. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na molio niliu mele “Sika.” ningu kuru mondonge yomboma ononga konopumanga konde molopa mindi puli noma pilkipa wendo ombá. Pulu Yemonga bokuna ungu se aku sipa nimba molemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yuni ungu nirimumunga pulumu i-sipa: “Yu Pulu Yemone sika lipa mundorumu, olio lipa tapondomba yemo molemo.” ningu kuru mondonge yomboma pe walte Pulu Yemonga Minimu ononga konopumanga omba molomba lingimundu nirimu. Yesusi u kolopa lomboropa ola molopa mulu-koleana kelepa olando naa purumu-kulu Mini ⸤Kake Séli⸥mu u naa orumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yombomane Yesusini ungu nirimuma pilkuli, marene ninguli: “I yemo Mosisini ‘Pulu Yemonga ungu-umbu tondombama pilipa yomboma nimba simba ye se ombá.’ nirimu yemo i yemo lémo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Marene ninguli: “Yu Pulu Yemone ‘olio nokopa kondomba ye se lipu mundumbu.’ nimba, nimba taltorumu ye nokoli Karasimu.” niringi. Marene ninguli: “Pulu Yemone lipa mundumba ye nokoli Karasimu kolea Gallilli disiriki molopale ombáye? Yu Gallilli naa menge. Pulu Yemonga bokumuni nimbale: ‘Pulu Yemone lipa mundumba ye nokoli Karasimu ye nokoli kingi Depitini kalopa limba. Depiti yu meringi Betellieme taono akuna ye nokoli Karasimu menge.’ nilimú kanumunga yu Gallilli disiriki manda naa menge lémo.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aku siku yomboma Yesusi molorumu mele angelema ningu konopu lupa lupa lieringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yombo marene ‘Yesusi ka siemili.’ konopu leko moloringi-na-kolo sene yu pumba ambolopa naa liltimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ulka-tembele ele-yema Yesusi kinia yomboma kinia ningu moloringi mele pilku molkole, pe we kelko yando ongo Pulu Yemo popo tondoringi ye awilima kinia Parisi yema kinia moloringina puringi. Yesusi ka siku naa mengo oringi-kulu kanokole onone ele-yemando ninguli: “Yemo nambi semu-na ⸤ka siku⸥ naa mengo ongiye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ele-yemane ninguli: “Mólo. Ye sene u ungu-mane silimili mele yuni aku sipa naa simu. Yuni ungu-mane paa olandopa simu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisimane pilku kiri pilku ninguli: “Yuni kolo topa ungu nimuma ‘Sika nimu.’ konopu leko ono we kelko yando ongiye? ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Olionga ye awilima kinia Parisi yema kinia olionga ye sene “Yu molemo nilimú mele sika akumu molemo.” nimba kuru mondomuye? ⸤Mólo, sene aku sipa naa nimba kuru mondomu kanumu.⸥ ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aku-sipa na-kolo we-yombo maku toko molongima Mosisini ungu-mane sirimu pelemoma paa naa pilielemele. Pulu Yemone ononga kotemo koronga pilipa, kolonge kinia ‘Mindili nangi.’ nimba panjerimu.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimasi, yu u walte Yesusi molorumuna purumu ye kanumu, Parisi ye kanumanga se yu, yuni ono mangilipa nimbale: ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Olionga ungu-manemane ‘Yombo se kote naa pilkuli we “Mongo likimu kene umbuna mepili.” niee.’ nilimúye? Yu u kotena ombale nilimú mele pilipuli pe ungu nilimúmanga puluma apurupu pilielemolo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Parisi yemane yundu pundu toko ninguli: “Aku nu kepe kolea Gallilli ye seye? Pulu Yemonga bokuna sukundu mimi siku kanani. Mimi siku kanokole, ‘Pulu Yemone ungu-umbu tondolima pilipa yando nimba simba ye se Gallilli wendo ombá.’ nimba pelemo kanoniye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yomboma pali ulkando bulu-balu ningu puringi, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","aku-na-kolo Yesusi ma-pangi se ‘Ma-Pangi Unju-Ollipi Kalia’ nili akuna olando purumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kanu-kinia kolea tangorumu kinia orili-u yu kelepa ⸤Pulu Yemo popo toko kaloringi⸥ ulka-tembelena purumu kinia yomboma yu molorumuna ongo maku toko moloringi kinia ono ungu-mane simbando yu mania molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kanu-kinia Pulu Yemonga ungu-manemanga puluma pilku mane siringi yema kinia Parisi yema kinia onone ambo ye puli se ye se kinia wa ulu-kirinale seringilimu liku mengo ongo yomboma moloringi kumbi-kerena ongo anjikuli, ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesusindu ninguli: “Ungu Mane Sili Yemo, i ambo ye púlimu ye se kinia wa ulu-kirinale seko molongili yombomane kanongi-na membo okomolo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosisini ungu-mane se sipa panjipa nimbale: “Ambo aku sembamo kouni toko kondaa.” nirimu kene nuni nambolka niniye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aku-sipa na-kolo onone sika pilingindu naa niringi. ‘Yuni nambolka nimbánje? Nimba kinjimba kinia kote sendemolo.’ ningu aku siku mangilieringi. Aku-sipa na-kolo Yesusi ma kanopa kimuni mana ⸤we⸥ imbi topa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kanu-kinia yu alieli mangili-pu-pu seringi-kulu olando sipa kanopa onondo nimbale: “Ononga ye se ulu-pulu-kiri se naa pelemo ye sene i ambomo kumbi lepa kouni topili.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aku nimbale yu kelepa ma kanopa mana we imbi topa molorumu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aku nirimu-kulu pilkuli ye awilima ono se talo ningu pena-pena pungu Yesusi munduku kelko ono puringi. Ye awilimanga ye nokolima u kumbi leko puringi kanu-kinia we ye awilima akileko puringi kinia ye awili se Yesusi-kinia naa molopa Yesusi yuyu molopa, ambomo Yesusi yu molorumuna we gilierimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kanu-kinia Yesusi olando sipa kanopale ambomo mangilipa nimbale: “Ambomo, yema sena molemeleye? Ye sene nu ‘Seko kinjenumunga kote sendambo.’ naa nimuye?” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ambomone nimbale: “Ye-Awilimu, ye sene na kote naa sendemba sekemo.” nirimu. Yesusini nimbale: “Nane kepe ‘Nuni seko kinjenumunga mindili nani.’ naa nikiru kene nu punguli ulu-pulu-kiri seleno mele munduku kelko, kelko naa sei!” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yombo moloringimando Yesusini kelepa nimbale: “Na ma-koleamanga pali yombomanga pa sendélimu. Na andopo molombona lombili andoko molonge yomboma simbulu tolina naa andoko molonge. Konde mololi ulu-pulumu silimú pa sélimu kinia molonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aku nirimu-kulu ye awili Parisimane pilkuli yu ta ningu ninguli: “Nu moleno mele nunu ningu silinu kene nuni ungu nikinuma pilipuli ‘Sika nikimu.’ nimbu pilielemolánje manda naa selka.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusini pundu topa nimbale: “Na u molopo orundu koleamo kinia kelepo pumbú sekero koleamo kinia pilipu moliomonga na molio mele sika nanu niliu-na-kolo nane i ungu nikirumu sika ungumu. Aku-sipa na-kolo na molopo orundu koleamo kepe pe pumbú sekero koleamo kepe ono naa pilkimili. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mana-yombomane pilku apuruku selemele mele ono Parisi yemane aku siku pilkuli apurulimili, aku-na-kolo nane yombo se naa apuruliu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aku-sipa na-kolo nane sika pilipu apurulka-nje na nanu manjipu naa apurulkamonga sumbi sipu apurulka. Na lipa mundorumu ye Tata kinia pea kopu sepo molembolo-monga sumbi sipu pilipu apurulka. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ononga ungu-mane se bokuna molemo kanumu i-sipa: ‘Yombo talone ungu se ningu síngili liemu ‘Aku ungumu sika.’ niengi.’ aku sipa nimba pelemo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Akumunga na molio mele nanu nimbu siliu kepe; na lipa mundorumu ye Tatane na molio mele nimba silimúla.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kanu-kinia onone mangilku ninguli: “Lanie sena molemoye?” niringi. Yesusini pundu topa nimbale: “Onone na kepe nanga Lapamo kepe naa kanoko imbi silimili. Onone na kanoko imbi silimolánje Tata kepe kanoko imbi silimolá-la.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesusi ulka-tembelena sukundu, Pulu Yemonga ningu yombomane kou-mone siringi unju-okoloma lierimu koleana molopa yomboma ungu-mane sipa molopale i unguma nirimu. Aku-sipa na-kolo yunga walemo wendo naa orumu-kulu yombo sene yu ambolko liku ka naa siringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesusini kelepa Juda ye awilimando nimbale: “Na kiniá pumbú sekero, kanu-kinia onone na koroko kelkole ononga ulu-pulu-kirima konopumanga pepili kolonge. Na pumbú koleana ono manda naa onge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aku nirimu-kulu pilkuli Juda ye awilimane onono angelema ningu mangilku ninguli: “Aku nambi semu-na ‘Na pumbú koleana ono manda naa onge.’ nikimuye? Aku liemu yu yuyu topa kondombanje?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesusini kelepa nimbale: “Ono mania yomboma, na ola yemo. Ono ma-kolea pulu yomboma, na ma-kolea pulu ye se mólo. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nane onondo u nimbuli: “Ulu-pulu-kirima konopumanga we pepili kolonge.” nindu kanumu. Akumu “Na kiniá molio, u-pulu-pulu molorundu, pe molopo mindi pumbú yemo.” nimbu siliu mele onone ‘Sika akumu molemo.’ ningu kuru naa mondongi liemu pe ono kolonge kinia sika ononga ulu-pulu-kirima konopumanga we pepili kolonge.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Parisi yemane yu mangilku ninguli: “Nu nawe?” niringi. Yesusini pundu topa nimbale: “Na molio mele ono alieli nimbu siliu kanumu na mindi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nane ono molko ulu selemele mele pilipu apurupuli onone seko kinjilimili mele ungu awisili nimbu silka-na-kolo nanu konopumuni pilipuli unguma naa niliu. Na lipa mundorumu yemo, yu ulu sikama mindi sepa ungu sikama mindi nilimú ye, kanumuni nilimú mele mindi pilipuli mana-yomboma nimbu siliu.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yuni Lapando nirimu-na-kolo ono yuni nirimu mele pulumu naa pilieringi-kulu ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesusini onondo nimbale: “Pe onone Mania Omba Mana-Ye Au Lierimu Yemo ola uku toko panjikuli ningímuni onone pilkuli “Na kiniá molio, u-pulu-pulu molorundu, pe molopo mindi pumbú yemo.” nimbu siliu mele onone ‘Sika akumu molemo.’ ningu pilkuli kepe, “Na nanu konopumuni pilipuli naa selio. Tatane na mane silimú mele mindi pilipuli niliu.” alieli nimbu siliu ‘Akumu sika lémo.’ ningu pilingí. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na lipa mundorumu-na orundu yemo na kinia pea kopu sepo molembolo; alieli yu kanopa peanga pilielemo uluma mindi seliomonga yuni waltikele kepe na mundupa naa kelielemo.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yuni aku sipa nimba molopili kepe yombo awisili ‘Yesusi yu Pulu Yemone sika lipa mundorumu.’ ningu kuru mondoringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","‘Yu sika.’ ningu kuru mondoringi Juda yombomando Yesusini nimbale: “Nane ungu-mane siliuma sika pilku liku sengena panjiku molongi liemu ono sika nanga lombili andolima molonge. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aku sekole, onone sika ungumu pilingí kanu-kinia ono ka silimú mélema sika ungumuni wendo lindipa ‘ono we molko kondangi.’ nimbá.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Onone pundu toko yundu ninguli: “Olio Eporayamone kalopa liltimu yomboma molopo, yombo senga ka-kongono se naa sendepo molorumulu. Aku liemu nuni ‘Ka silimú mélema wendo pumbá olio molko kondonge.’ nikinu kanumu nambi seko pilkuli nikinuye?” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesusini pundu topa nimbale: “Nane ono paa sika nimbu sikirumu: “Yombo ulu-pulu-kiri selemelema ulu-pulu-kirimane ka silimú kinia aku ulu-pulu-kirimanga ka-kongono selemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ka-kongono selemo kendemande-yombomo ulka pulu yomboma kinia pea kamu naa molemo, aku-na-kolo bolango se yunga ulka pulu yomboma kinia alieli seluna kopu seko molemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Akumunga ⸤Ulka Pulu Yemonga⸥ Malone ‘Ono ka silimú mélema mundupa keliepili, ono we molko kondangi.’ nimu liemu mélsene sika ka naa simba, we paa sika molko kondonge.” nikiru. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“‘Ono Eporayamone kalopa liltimu yomboma molemele.’ na pilipu molio-na-kolo ononga konopumanga nanga ungumu naa pelemomonga na toko kondonge sekemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nane Tata-kinia molopole kanorundu mele ono nimbu siliu. Onone ononga laniene nilimú mele pilkuli selemele.” nirimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesusini yombomando “Ono lanienga ungumu pilkuli selemele.” nirimu kinia pilkuli Juda yombomane pundu toko ninguli: “Olionga lapa kalopa liltimu yemo Eporayamo.” niringi. Yesusini nimbale: “Mólo. Ono sika Eporayamone kalopa liltimu yomboma molemolánje Eporayamone serimu mele ono aku siku selemolá. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aku-sipa na-kolo aku naa selemele. Pulu Yemone na nimba sirimu unguma na pilierindu ungu sikama ono nimbu siliu yemo toko kondonge sekemele. Eporayamone aku sipa naa serimu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ono ononga laniene selemo mele manda manjiku selemele.” nirimu. Onone tondolo ta ningu ninguli: “Olionga anumu ye se lupa kinia wapora topale olio naa merimu. Olionga lapa kanumu Pulu Yemo selu mindi.” niringi. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesusini onondo nimbale: “Na Pulu Yemo kinia molopole orundu ya moliomonga Pulu Yemo yu sika ononga Lapa lelkanje onone na konopu mondolemolá. Na nanu konopumuni pilipuli naa orundu. Yuni na lipa mundorumu-na orundu. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nane ungu niliumanga pulumu nambi semu-na sumbi siku naa pilielemeleye? ‘Ungu-pulumu naa pilimulú.’ ningu, pilku naa limili akumunga nanga ungumu ono naa pilielemele. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ono ⸤kurumanga nokoli⸥ depelemonga bolangoma, Setene ononga lapamo. Laniene kanopa peanga pilielemo mele ‘samili.’ ninguli yuni “Ono saa.” nilimú mele ‘Paa samili.’ nilimili. U-pulu-pulu mulu matolo kokele wendo orumu kinia yu yombo topa kondoli yemo molorumu mele aku sílimu yandopa kiniá we molemo. Yu sika ungu-pulu se naa perimu-na sika ungu se waltikele kepe paa naa nirimu. Yu kolo tolemo yemo; yu sika kolo toli ungumunga pulu yemo molemomonga u yu kolo torumu mele yandopa kiniá kepe pe kepe kolo mindi tolemo tomba. ");
INSERT INTO ubu_andelale_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aku-sipa na-kolo nane ungu sikama nimb