﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzotze_vpl;
CREATE TABLE tzotze_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzotze_vpl WRITE;
INSERT INTO tzotze_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Li'i ja' svunal sbiic smoltotac ta vo'one li Jesucristoe. Li Jesucristoe ja' smoltot ta vo'one li Davide. Ja' smoltot ta más vo'one noxtoc li Abraáme. ");
INSERT INTO tzotze_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Li Abraáme inich'naj, Isaac sbi. Inich'naj li Isaaque, Jacov sbi. Inich'naj li Jacove, Judá sbi. Li Judae oy ep xchi'iltac ta voq'uel. ");
INSERT INTO tzotze_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Inich'naj li Judae, loin. Ja' Fares xchi'uc Zara sbiic. Ja' sme'ic li Tamare. Inich'naj li Farese, Esrom sbi. Inich'naj li Esrome, Arám sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Inich'naj li Arame, Aminadab sbi. Inich'naj li Aminadabe, Nasón sbi. Inich'naj li Nasone, Salmón sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Inich'naj li Salmone, Booz sbi. Li Booze ja' sme' li Raabe. Inich'naj li Booze, Obed sbi. Li Obede ja' sme' li Rute. Inich'naj li Obede, Isaí sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Inich'naj li Isaíe, David sbi. Ja' ti i'och ta muc'ta ajvalilale. Inich'naj li Davide, Salomón sbi. Li Salomone ja' sme' li yajnil to'ox Uríase. ");
INSERT INTO tzotze_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Inich'naj li Salomone, Robóam sbi. Inich'naj li Roboame, Abías sbi. Inich'naj li Abíase, Asa sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Inich'naj li Asae, Josafat sbi. Inich'naj li Josafate, Joram sbi. Inich'naj li Jorame, Uzías sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Inich'naj li Uzíase, Jotam sbi. Inich'naj li Jotame, Acaz sbi. Inich'naj li Acaze, Ezequías sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Inich'naj li Ezequíase, Manasés sbi. Inich'naj li Manasese, Amón sbi. Inich'naj li Amone, Josías sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Inich'naj li Josíase, Jeconías sbi. Li Jeconíase oy ep xchi'iltac ta voq'uel. Ja' o yorail ital chucaticuc batel ta Babilonia banamil li jchi'iltactic ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ts'acal to inich'naj li Jeconíase, Salatiel sbi. Inich'naj li Salatiele, Zorobabel sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Inich'naj li Zorobabele, Abiud sbi. Inich'naj li Abiude, Eliaquim sbi. Inich'naj li Eliaquime, Azor sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Inich'naj li Azore, Sadoc sbi. Inich'naj li Sadoque, Aquim sbi. Inich'naj li Aquime, Eliud sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Inich'naj li Eliude, Eleazar sbi. Inich'naj li Eleazare, Matán sbi. Inich'naj li Matane, Jacov sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Inich'naj li Jacove, José sbi. Li Josée la sa' yajnil, María sbi. Li Maríae ivoc' sba yol, ja' li Jesuse, ja' li Cristo ti t'ujbil ono'ox yu'un Dios chtal sventainutique. ");
INSERT INTO tzotze_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ja' xlajcha'c'olal xa'ox smomnich'nab Abraám ijelovic li' ta banamil ti c'alal ivoc' li Davide. Jech tey ic'otic ta chanlajunc'ol c'alal ta Abraám xchi'uc c'alal ta David. Li smomnich'nabtac Davide chanlajunc'ol xa'ox ijelovic noxtoc ti c'alal chucbil ibatic ta Babilonia banamile. C'alal ivoc' li Cristoe, tey its'aqui yan chanlajunc'ol noxtoc. Ja' xa smomnich'nabtac li boch'otic chucbil ibatic ta Babiloniae. Ja' xa xchanlajunebal ic'ot li Cristoe. ");
INSERT INTO tzotze_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","C'alal ivoc' li Jesucristoe, jech chac c'u cha'al li'i. Li sme'e, ja' li Maríae, macbil xa'ox yu'un li Josée. C'alal mu'yuc to'ox yic'oj sbaique, oy xa'ox xch'ut li Maríae. Ja' ac'bil yu'un Ch'ul Espíritu. ");
INSERT INTO tzotze_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ja' lequil vinic li Josée. Mu sc'an xac' ta q'uexlal li Maríae. Tsc'an ta scomtsan ta mucul, ja' no'ox me oy jun chibuc testigo ta xa'yique yu'un jech lec ta xcom. ");
INSERT INTO tzotze_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","C'alal jech snopoj li Josée, ivaychin. Ta xvayech laj yil jun yaj'almantal Dios. Jech i'albat yu'un li j'almantale: ―José, vo'ot smomnich'onot David, mu xaxi'. Ic'o li Maríae. Yu'un li yol xchi'inoje muc xnich'onuc vinic; ja' ac'bil yu'un Ch'ul Espíritu. ");
INSERT INTO tzotze_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jun querem ta svoq'ues. Jesús chavac'be sbi yu'un ja' ta scolta yu'un smulic scotol li boch'otic t'ujbil yu'une ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Scotol li c'usi ic'ot ta pasele yu'un ja' ic'ot o c'usi laj yal Dios ti c'alal la xch'amanbe ye yaj'alc'op ta vo'onee. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta xchi'in yol jun tojol tseb. Querem ta xvoc' yu'un. Emanuel ta xac'be sbi. Ja' Dios jchi'uctic, xi smelol li sbie, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","C'alal ijulov li Josée, la spas li c'usi i'albat yu'un j'almantale. Laj yic' li Maríae. ");
INSERT INTO tzotze_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero mu'yuc to la xchi'in sbaic ja' to c'alal ivoc' li sba yole. Li Josée Jesús laj yac'be sbi li quereme. ");
INSERT INTO tzotze_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","C'alal ivoc' Jesús tey ta lum Belén li' ta Judea banamile, ja' o ochem ta ajvalilal jun vinic, Erodes sbi. Li' ivulic ta Jerusalén jayibuc bijil viniquetic liquemic tal ta nom ta sloq'ueb c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Li' ivul sjaq'uic: ―¿Bu voq'uem xana' li boch'o sc'oplal ta x'och ta ajvalilal avu'unic, vo'oxuc ti israeloxuque? Yu'un c'alal tey oyuncutic ta jnacutic ta sloq'ueb c'ac'ale, laj quilcutic jun c'anal. Ja' sq'uelubil ti voq'uem xa li boch'o ta x'och ta ajvalilal avu'unique. Jech litalcutic, tal quich'cutic ta muc' ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","C'alal laj ya'i li Erodese, lic lo'ilajuc yo'ntonic xchi'uc li jchi'iltactic li' nacajtic ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Li Erodese lic yic'an tal scotol li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, ja' li jchi'iltic ta israelale. La sjac'be bu sc'oplal ta xvoc' li Cristo ti sc'oplal ta x'och ta ajvalilal cu'untique. ");
INSERT INTO tzotze_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jech laj yalic: ―Tey ta xvoc' ta lum Belén li' ta Judea banamile. Yu'un jech ono'ox ts'ibabil comel yu'un yaj'alc'op Dios ta vo'one: ");
INSERT INTO tzotze_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ac'o me biq'uit no'ox li lum Belén tey ta Judá banamile, pero ja' ich'bil ta muc' ta xc'ot. Yu'un ja' tey ta xloc' tal jun ajvalil avu'unic, ja' ta spasoxuc ta mantal, vo'oxuc li israeloxuque, ti t'ujbiloxuc ono'ox cu'une, xi li Diose, xi ono'ox laj yal li j'alc'ope ―xiic li paleetique. ");
INSERT INTO tzotze_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Li Erodese ta mucul laj yic' tal li bijil viniquetique. La sjac'be bu ora laj yilbeic li sc'analile. ");
INSERT INTO tzotze_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jech tey itacatic batel ta Belén. Jech laj yal li Erodese: ―Batanic tey ta Belén. Lec xajaq'uic bu oy li olole. C'alal me laj ataique, li' x'ech' avalbicun ca'i yu'un ta xbat quich' ta muc' ec ―xi ilo'lavan li Erodese. ");
INSERT INTO tzotze_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","C'alal laj ya'yic c'usi laj yal ajvalil li bijil viniquetique, ibatic. Tey to ba'yucbe ibat yu'unic li c'anal laj yilic tal ta sloq'ueb c'ac'ale. C'alal laj yilic ti tey to ta xanov batel li c'anale, xcuxet no'ox yo'ntonic ja' tey nabalic batel. Tey ic'ot t'ixuc ta na yo' bu oy li olole. ");
INSERT INTO tzotze_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tey i'ochic li bijil viniquetique. Tey laj yilic li olole xchi'uc li sme'e, ja' li Maríae. La squejan sbaic ta stojol li olole, laj yich'ic ta muc'. Laj yac'beic smoton, ja' c'anal taq'uin xchi'uc pom xchi'uc muil poxil. ");
INSERT INTO tzotze_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Li bijil viniquetique i'albatic yu'un Dios ta xvayechic ti mu me xjelovic yo' bu oy li Erodese. Jech ta yan be ibatic o ti c'alal isutic ta yosilalique. ");
INSERT INTO tzotze_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","C'alal sutemic xa'ox li bijil viniquetique, ivaychin li Josée. Ta xvayech laj yil jun yaj'almantal Dios. Jech i'albat: ―Lican, ic'o batel li olole xchi'uc li sme'e. Batanic ta ora ta Egipto banamil. Tey oyanic o. Ja' to me laj calboxuc ti chasutic batele, ja' to xu' chasutic. Yu'un li Erodese tsc'an ta st'un li olole yu'un tsc'an ta smil ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Toj julovel ic'ot li Josée, ta ora ilic. Laj yic' batel li olole xchi'uc li sme'e. Ta ac'ubaltic iloq'uic batel, ibatic ta Egipto. ");
INSERT INTO tzotze_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tey oyic o c'alal to icham li Erodese. Jech ic'ot ta pasel yu'un ja' ic'ot o c'usi laj yal Dios ti c'alal la xch'amanbe ye yaj'alc'op ta vo'onee: “Ta Egipto banamil ta xquic' batel li Jnich'one, xi li Diose”, xi ono'ox li j'alc'ope. ");
INSERT INTO tzotze_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","C'alal la sna' Erodes ti ilo'laat xa yu'un li bijil viniquetique, solel tsots i'ilin. Laj yal mantal ti ac'o milaticuc scotol li bic'tal queremetic ti bu chib to jabil yich'ojique, xchi'uc ti bu bats'i ololic to, ti tey oyic ta lum Belene xchi'uc c'u smuc'ul yosilal li Belene. Yu'un sna'oj Erodes c'usi ora laj yilic tal c'anal li bijil viniquetique, ja' yu'un tey capal laj yac' ta milel ti bu yich'ojic xa chib jabile. ");
INSERT INTO tzotze_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jech ic'ot ta pasel jech chac c'u cha'al ic'ot ta pasel ta yosilal Ramá ta vo'one ti laj yalbe sc'oplal li j'alc'op Jeremíase: ");
INSERT INTO tzotze_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ti c'u smuc'ul yosilal Ramae ta to xlic oq'uicuc li antsetic teye. Ta to xlic yat yo'ntonic, ta xoc'ta li yolique. Mu xmuq'uib yo'ntonic yu'un imilbat xa li yolique, xi li Diose, xi li j'alc'op Jeremíase. ");
INSERT INTO tzotze_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","C'alal icham li Erodese, tey to oy ta Egipto li Josée. Tey ivaychin. Ta xvayech ic'opanat yu'un yaj'almantal Dios. ");
INSERT INTO tzotze_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Jech laj yal li j'almantale: ―Lican, ic'o batel li olole xchi'uc li sme'e. Sutan batel ta avosilal yo' bu oy li achi'iltac ta israelale. Li boch'o tsc'an ox ta smil li olole icham xa ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jech ilic li Josée. Laj yic' sutel tal li olole xchi'uc li sme'e. Jech ivulic li' ta cosilaltic. ");
INSERT INTO tzotze_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yan xa ajvalil ochem li' ta Judea banamil ti c'alal ivulique. Ja' xa ochem xnich'on li Erodese, Arquelao sbi. C'alal laj ya'i li Josée, ixi'. Muc sc'an xtal li' ta Judea. I'albat ta xvayech yu'un Dios ti tey ac'o bat nacluc ta Galilea banamile. ");
INSERT INTO tzotze_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jech tey ibat nacluc ta jun lum, Nazaret sbi. Jech ic'ot o ti jech ono'ox albil sc'oplal yu'un yaj'alc'optac Dios ta vo'one li Jesuse: “Ja' tey liquem tal ta Nazaret, xi sc'oplal yu'un li cristianoetique”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","C'alal tey to oy ta Nazaret li Jesuse, ja' o lic xchol sc'op Dios li' ta xocol banamil li Juan j'ac'vanej ta vo'e, ja' li' ta Judea banamil. ");
INSERT INTO tzotze_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jech lic yal li Juane: ―Comtsanic scotol li c'usi chopol chapasique yu'un yorail xa xu' chasventainbot avo'ntonic li Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yu'un jech ono'ox ts'ibabil sc'oplal yu'un j'alc'op Isaías ta vo'one li Juane. Jech laj yal: Ta to xlic jun jchi'iltic ta israelal, ja' tsots ta x'avan ta xocol banamil. Jech ta xal: “Ta xa xtal li Cajvaltique. Ja' lec comtsanic scotol li c'usitic chopol chapasique, ja' ich'beic ta muc' li sc'ope”, xi ta xlic yalbe li jchi'iltactique, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Li sc'u' Juane ja' jalbil tsotsil camello. La xchuc xch'ut ta nucul. Li sve'ele ja' c'ulub xchi'uc spom muc'ta pom. ");
INSERT INTO tzotze_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Scotol li jchi'iltactic ta israelal li' nacajtic ta Jerusalene bat ya'ibeic sc'op li Juane, xchi'uc li boch'tic tey nacajtic ta jujun lum li' ta Judea banamile, xchi'uc li boch'otic tey nacajtic ta nopol ti' uc'um Jordane. ");
INSERT INTO tzotze_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Scotol li boch'otic jamal laj yalic ta stojol Juan c'usi smulique, i'ac'bat yich'ic vo' yu'un Juan tey ta uc'um Jordán. ");
INSERT INTO tzotze_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Li Juane laj yil ti ep ta xtalic ec li boch'otic xch'unojic fariseoe xchi'uc li boch'otic xch'unojic saduceoe. Tey tal sc'anic ich' vo' ec. Li Juane jech laj yalbe: ―Vo'oxuque ja' jechoxuc jech chac c'u cha'al orachon. Li orachone ta xjatov loq'uel ta anil c'alal me cha'i ti ta xa xtal c'oq'ue. Ja' jech c'otemoxuc li vo'oxuque. ¿Me yu'un laj ava'yic ti ta ono'ox xavich'ic castigo yu'un Dios ti latalic ta anil, tal ac'anic chacac'boxuc avich'ic vo'e? ");
INSERT INTO tzotze_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pero tsc'an chvinaj me melel ti acomtsanojic xa li c'usitic chopol chapasique. ");
INSERT INTO tzotze_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mu me jechuc xanop ta avo'ntonic: “Ja' jmoltotic ta vo'one li Abraáme, jech ta ono'ox xijcolutic”, mu me xachiic. Chacalboxuc, li Diose xu' yu'un ta sc'atajesbe ta smomnich'nab Abraám li tonetic li'i. ");
INSERT INTO tzotze_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Li vo'oxuque ja' jechoxuc jech chac c'u cha'al te'etic ti mu lecuc sat chaq'ue. Tey xa metsel eq'uel ta yibel yu'un ta xa xich' ts'etel. Ta xich' chiq'uel ta c'oc'. ");
INSERT INTO tzotze_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Li vu'une ja' no'ox cabtel ta xcac'be yich'ic vo' li boch'otic ta scomtsan c'usitic chopol ta spasique. Pero oy to boch'o ts'acal ta xtal, ja' tsots yabtel yich'oj. Li vu'une mu'yuc tsots cabtel quich'oj. Mu'yuc c'usi xu' cu'un ta jcolta. Ac'o me yich'bel xonob, mu xu' cu'un. Yan li boch'o ts'acal ta xtale ja' chayac'boxuc avich'ic Ch'ul Espíritu. Xco'laj xchi'uc c'oc' yu'un tsloq'ues scotol li sbolil avo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Li boch'otic tsc'an loq'uesbel sbolil yo'ntonique ja' ch‑ic'atic sbatel osil. Yan li boch'otic mu sc'an loq'uesbele ja' chbatic ta c'oc' yo' bu mu ono'ox xtube. Jech chac c'u cha'al li boch'o ta xic'a strigoe. Me ilaj yo'nton ta yic'aele, tstsob scotol li strigoe, ta xich' ochel ta snail. Scotol li ste'ele xchi'uc li solile ta xchic' ta c'oc' ―xi li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ja' o iloc' tal ta Galilea banamil li Jesuse, tey ic'ot ta uc'um Jordán yu'un tsc'an ta x'ac'bat yich' vo' yu'un li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Li Juane vocol la xch'un ti chac'be yich' vo' li Jesuse. Jech laj yalbe li Jesuse: ―Vo'ot chavac'bun quich' vo' ti jechuque. Mu smeloluc ti vo'ot chac'an chcac'bot avich' vo'e ―xi li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Itac'ov li Jesuse: ―Ja' lec ac'bun quich' vo' yu'un ac'o jpastic scotol c'usi tsc'an li Diose ―xi li Jesuse. Jech tey la xch'un li Juane, laj yac'be yich' vo' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","C'alal laj xa yich' vo' li Jesuse, iloc' ta uc'um. Ta ora laj yil ijam li vinajele. Laj yil iyal tal ta sba li Ch'ul Espíritu ti junic xchi'uc Diose. Xco'laj xchi'uc tsumut yilel. ");
INSERT INTO tzotze_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Li Diose ic'opoj tal ta vinajel, jech laj yal: ―Li'i ja' Jnich'on, lec c'ux ta co'nton. Xcuxet no'ox co'nton yu'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Li Jesuse i'ac'bat sna' yu'un Ch'ul Espíritu ti chbat ta xocol banamile yu'un ac'o q'uelbatuc yo'nton yu'un li banquilal pucuje. ");
INSERT INTO tzotze_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Li Jesuse cha'vinic c'ac'al xchi'uc cha'vinic ac'ubal mu'yuc xve', jech ivi'naj. ");
INSERT INTO tzotze_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tey ital li Satanase, ja' li banquilal pucuje. Tal slo'la yaloj li Jesuse. Jech laj yalbe: ―Me vo'ot Xnich'onot Diose, albo li tonetic li'i ac'o c'atajuc ta vaj jech chata o vaj ave' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Itac'ov li Jesuse: ―Jech ts'ibabil ta sc'op Dios: “Muc ta vajuc no'ox chijcuxiutic o. Ja' tsc'an ta jch'untic noxtoc c'usitic chijyalbutic li Diose”, xi ts'ibabil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Li banquilal pucuje laj yic' tal ta Jerusalén li Jesuse. Laj yic' muyel ta jol templo, tey c'ot sva'an. ");
INSERT INTO tzotze_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jech lic yal li banquilal pucuje: ―Me vo'ot Xnich'onot Diose, jipo aba yalel li'i. Yu'un jech ts'ibabil ta sc'op Dios: Dios ta stacbot yalel tal yaj'almantaltac ja' ta xchabiot. Ja' chastsacot ta sc'ob li j'almantaletique, chayic'ot batel yu'un jech mu xabosi avacan ta ton, xi ts'ibabil ―x'utat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Itac'ov li Jesuse: ―Pero jech ts'ibabil ta sc'op Dios noxtoc: “Mu me xaq'uelbeic yo'nton li Cajvaltic Diose”, xi ts'ibabil. Ja' yu'un me ta jip jba yalele, yu'un ta jq'uelbe yo'nton Dios me ta melel chiscoltaune ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Li banquilal pucuje laj yic' batel ta jun toyol vits noxtoc li Jesuse. Ta svu'el no'ox tey laj yac'be yil scotol li ajvaliletic li' ta banamile xchi'uc ti c'u x'elan tspasic mantale. ");
INSERT INTO tzotze_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jech laj yal li banquilal pucuje: ―Scotol li c'usi chaq'uel batel le'e, ja' avu'un scotol me chavich'un ta muq'ue, me chaquejan aba ta jtojole ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Itac'ov li Jesuse: ―Batan, Satanás, mu jch'un c'usi chavalbun. Yu'un jech ts'ibabil ta sc'op Dios: “Ja' no'ox xavich'ic ta muc' stuc li Cajvaltic Diose. Ja' no'ox xapasic li c'usi tsc'ane”, xi ts'ibabil ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","C'alal laj yil banquilal pucuj ti mu xch'un li Jesuse, jech ibat. Ta ora ital j'almantaletic, tal yich' coltael li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","C'alal laj ya'i Jesús ti ochem xa ta chuquel li Juane, isut batel ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ja' la scomtsan o li lum Nazaret ti bu ich'ie. Tey bat nacluc ta lum Capernaum. Ja' tey oy ta ti' nab tey ta yosilic li jmoltotic ta vo'onee, ja' li Zabulone xchi'uc li Neftalíe. ");
INSERT INTO tzotze_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jech ic'ot o c'usi laj yal li j'alc'op Isaías ta vo'onee. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Li yosilic jchop yu'un ánima Zabulone xchi'uc li yosilic jchop yu'un ánima Neftalí ti tey oy ta noch' ti' muc'ta nabe xchi'uc c'alal to ta ti' uc'um Jordane, ja' Galilea ta xc'ot sbi yu'unic li yanlum cristianoetic tey ta xnaquiique. ");
INSERT INTO tzotze_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Scotol li jchi'iltactic ta israelal ti ts'acal to tey ta xnaquiique, oy vocol ta xa'yic. Pero ja' xcuxet no'ox yo'ntonic ta ts'acal yu'un ja' tey ta xc'ot ta stojolic li boch'o ac'bil yabtel yu'un Diose, xi ono'ox li j'alc'op Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Li Jesuse ja' o jech lic yalbe li jchi'iltactique: ―Comtsanic scotol li c'usi chopol chapasique yu'un yorail xa xu' chasventainbot avo'ntonic li Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Li Jesuse tey ixanov batel ta ti'ti' nab tey ta Galilea banamil. Tey laj yil chib jchi'iltic ta israelal, ja' xchi'il no'ox sbaic ta voq'uel. Li june Simón sbi, ja' Pedro xchibal sbi. Ja' Andrés sbi li its'inale. Tey ta stic' snuti'ic ta nab yu'un ta stsaquic choy. Yu'un ja' yabtelic o. ");
INSERT INTO tzotze_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Li Jesuse jech lic yalbe: ―La' chi'inicun batel, ta jelboxuc avabtelic. Yu'un ta jchanubtasoxuc c'u x'elan chbat asa'bicun cristianoetic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta ora la scomtsan li yabtelique, la xchi'inic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","C'alal ijelov batel li Jesuse xchi'uc li chib jchi'iltique, tey laj yil yan chib jchi'iltic. Ja' xchi'il sbaic ta voq'uel noxtoc. Ja' xnich'nab Zebedeo. Jacobo sbi li banquilale. Ja' Juan sbi li its'inale. Tey tic'ajtic ta yut tenalte' canova xchi'uc stotic, tey ta slut'ilan snuti'ic yu'un tuch'emic. I'ic'atic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ta ora la scomtsan li stotique xchi'uc li scanovaique, ja' la xchi'inic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Li Jesuse ixanov batel ta scotol Galilea banamil xchi'uc li yajchanc'optaque. Tey ichanubtasvan ta jujun nail tsobobbailetic yu'un li jchi'iltactic ta israelale. Tey la xcholbe ya'yic li lequil a'yeje, ja' ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. La scolta noxtoc ep jchameletic, c'usiuc no'ox chamelal ip cha'yic. ");
INSERT INTO tzotze_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta scotol Siria banamil ivinaj sc'oplal ti la scolta ep jchameletic li Jesuse. Buticuc no'ox ijelov li Jesuse tey laj yiq'uic tal ta stojol ep jchameletic. Ep ta chop jchameletic italic. Tey italic noxtoc li boch'otic oy c'usitic chti'van cha'yique, xchi'uc li boch'otic ochem pucuj ta yo'ntonique, xchi'uc li boch'otic yich'ojic tu'p iq'ue, xchi'uc li boch'otic aluben yoc sc'obique. Scotol icol yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bats'i ep cristianoetic la xchi'inic batel li Jesuse. Ja' li boch'otic tey nacajtic ta Galilea banamile, xchi'uc ta Decapolis banamil yo' bu oy lajuneb lume, xchi'uc ta lum Jerusalén, xchi'uc ta yantic lum li' ta Judea banamil. Xchi'uc li boch'otic tey nacajtic ta jot uc'um Jordane. ");
INSERT INTO tzotze_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","C'alal laj yil Jesús ti toj ep stsoboj sbaic li jchi'iltactic ta israelale imuy jutuc ta vits. Tey c'ot chotluc. Tey libatcutic ec, vu'uncutic li yajchanc'opuncutique xchi'uc li boch'otic scotol yo'nton tsc'an cha'ibeic sc'ope. ");
INSERT INTO tzotze_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tey lic chanubtasvanuc li Jesuse. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Li boch'otic tsc'anic coltael yu'un tsna'ic ti mu'yuc ono'ox slequil yo'nton stuquique, ta sta xcuxetel yo'ntonic yu'un ja' ta xventainatic yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Li boch'otic ta x'oq'uic ta scoj ti oy smulique, ta sta xcuxetel yo'ntonic yu'un ja' ta x'ac'batic smuc'ul yo'ntonic yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Li boch'otic mu sna' stoy sbaique, ta sta xcuxetel yo'ntonic yu'un ja' ta xchi'inic ta pasmantal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Li boch'otic scotol yo'ntonic tsc'anic ti ac'o tuc'uc yo'ntonique, ta sta xcuxetel yo'ntonic yu'un ja' ta x'ac'batic tuc' yo'ntonic yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Li boch'otic ta xc'uxubinvanique, ta sta xcuxetel yo'ntonic yu'un ja' ta xich'ic c'uxubinel ec yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Li boch'otic scotol yo'nton tsc'an tspasic c'usi tsc'an Diose, ta sta xcuxetel yo'ntonic yu'un ja' ta xbat yotquinic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Li boch'otic ta spajesic li boch'o ta scontrain sbaique, ta sta xcuxetel yo'ntonic. Le'e ja' jnich'nabtac, xi sc'oplalic yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Li boch'otic ta xich'ic uts'intael ta sventa ti lec c'usi ta spasique, ta sta xcuxetel yo'ntonic yu'un ja' ta xventainatic yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Li vo'oxuque cuxetuc no'ox avo'ntonic me vu'un ta jventa ti chopol chayiloxuc li cristianoetique, me chayuts'intaoxuc, me chasnopboxuc amulique. ");
INSERT INTO tzotze_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cuxetuc no'ox avo'ntonic yu'un. Yu'un chc'ot ata ep amotonic tey ta vinajel. Yu'un jech ono'ox laj yich'ic uts'intael ec li yaj'alc'optac Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Li vo'oxuque xco'laj xchi'uc ats'am c'otemoxuc yu'un vo'oxuc ta aventaic ta xlecub li cristianoetique. Me lec c'usitic chapasique, jech lec chatunic li' ta banamil. Yan me chopol c'usitic chapasique, mu'yuc atuic. Jech chac c'u cha'al ats'am ti me ch'ayem xa xchi'ile, mu'yuc xa stu, ta xich' jipel batel. Tey chlaj ta pech'el ta teq'uel yu'un cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Li vo'oxuque xco'laj xchi'uc luz c'otemoxuc yu'un li cristianoetique. Yu'un vo'oxuc chavaq'uic ta ilel ti oy slequil avo'ntonic jech chac c'u cha'al me oy jun muc'ta lum ta jolvitse, lec xvinaj. Mu stac' naq'uel, scotol c'ac'al lec xvinaj o. Ja' jech c'otemoxuc li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jech noxtoc me oy chatsanic candile, mu'yuc chanujmaquiic ta anmul. Ja' chavaq'uic ta xvuchanubil jech ta xac' xojobal ta sbejel li yut anaique. ");
INSERT INTO tzotze_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Li vo'oxuque ja' jech tsc'an chavaq'uic ta ilel ti lecuben xa avo'ntonique. Jech chilic li cristianoetique, jech chlic yich'ic ta muc' li Jtotic Dios tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Mu me xanopic ti yu'un tal jlajesbe sc'oplal li smantaltac Diose xchi'uc li c'usitic laj yal li j'alc'opetic ta vo'onee. Mu yu'unuc ja' tal jlajesbe sc'oplal; ja' tal jpas scotol. ");
INSERT INTO tzotze_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ja' melel li c'usi ta xcalboxuque, c'alal mu'yuc to ta sta yorail chlaj li vinajel banamile, me jbeluc mu'yuc ta xlaj sc'oplal li c'usitic yaloj Diose. Persa chc'ot ta pasel scotol. ");
INSERT INTO tzotze_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Li boch'o mu tsotsuc sc'oplal cha'i jbeluc li smantal Diose, me jech ta xalbe ya'yic ec li cristianoetique, ja' its'inal chc'ot yo' bu tspas mantal Diose. Yan li boch'o tsots sc'oplal cha'i scotol smantaltac Diose, me jech ta xalbe ya'yic ec li cristianoetique, ja' banquilal chc'ot yo' bu tspas mantal Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Jech chacalboxuc, li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li fariseoetique tsnopic ti ja' oy slequil yo'ntonique. Pero li vo'oxuque tsc'an ti melel oy slequil avo'ntonique. Yu'un me naca no'ox chavalic jech chac c'u cha'al li fariseoetique, mu xu' cha'ochic ec yo' bu tspas mantal Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ava'yojic ono'ox ti jech i'albatic comel jmoltotactic ta vo'onee: “Mu me xamilvanic. Li boch'o ta xmilvane ja' ta xich' milel ec”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero vu'un ta xcalboxuc, li boch'o ta xilinta xchi'ile, xchi'uc li boch'o chopol chil xchi'ile, xchi'uc li boch'o ta xchopolc'opoj ta stojol xchi'ile, xco'laj xchi'uc jmilvanej ta xc'ot. Co'ol chbatic ta muc'ta c'oc' xchi'uc li jmilvaneje. ");
INSERT INTO tzotze_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Ja' tsots sc'oplal ti lec chavil aba achi'uc achi'ilique. Me oy chbat avac' smoton Dios tey ti bu scajlebe, me tey it'ab ta avo'nton ti oy amul ta stojol achi'ile, ja' lec tey no'ox xacomtsan ta sts'el scajleb smoton Dios li c'usi avich'oj batele. Bat chapano ba'yuc ac'op achi'uc li boch'o oy amul ta stojole. Me ichapaj avu'unique, ja' to xu' chtal avac'be smoton li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Me oy laj ata amulic ta stojol achi'ilique, ja' tsc'an chachapanic ta ora no'ox. Yu'un me mu jechuc chapasique, oy amulic ta stojol li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ja' melel li c'usi chacalboxuque, me mu xapasic jech chac c'u cha'al laj calboxuque, chayac'boxuc castigo li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ava'yojic ono'ox ti jech i'albatic comel ta vo'onee: “Mu me xamulivajic”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero vu'un ta xcalboxuc, li boch'otic ja' no'ox ta xpich'o'nta antse, xchi'uc li boch'otic ja' no'ox ta xpich'o'nta vinique, imulivajic xa o. Yu'un jech yo'nton chac sc'upin ya'yic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Me ta scoj no'ox asatic chata o amulique, mu lecuc. Ja' tsc'an ti mu xavilic osil ya'yel jech chac c'u cha'al li boch'o mu xil osile, jech xu' cha'ochic ta lequilal. Ja' abul abaic me ta scoj no'ox asatic chabatic ta muc'ta c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jech noxtoc me ta scoj no'ox ac'obic chata o amulique, mu lecuc. Ja' tsc'an ti mu'yucuc ac'obic ya'yel jech chac c'u cha'al li boch'o mu'yuc sc'obe, jech xu' cha'ochic ta lequilal. Ja' abul abaic me ta scoj no'ox ac'obic chabatic ta muc'ta c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ava'yojic noxtoc ti jech i'albatic comel ta vo'onee: “Li boch'o ta xicta yajnile ac'o spasbe svunal ti muc xa yajniluque, ac'o yac'be li yajnile”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero vu'un ta xcalboxuc, li boch'o ta xicta yajnile, me mu'yuc mulivajem xchi'uc yan vinic ti jech ta xictae, xco'laj xchi'uc mulivajem chc'ot yu'un li yajnile. Boch'o ta xic' yajnilin jun ants ti ictabil yu'un smalale, ja' no'ox ta xmulivaj xchi'uc. ");
INSERT INTO tzotze_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ava'yojic noxtoc ti jech i'albatic comel ta vo'onee: “Me chavalic ti ja' testigo avu'unic li Diose, persa chc'ot ta pasel avu'unic li c'usi chavalique”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero vu'un ta xcalboxuc, mu me xavalic ti ja' testigo avu'unic li vinajele yu'un ja' spasub mantal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu me xavalic ti ja' testigo avu'unic li banamile yu'un ja' sventainoj li Diose. Mu me xavalic ti ja' testigo avu'unic li Jerusalene yu'un ja' slumal li banquilal ajvalile, ja' li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu me xavalic ti ja' testigo avu'unic li ajolique yu'un ja' spasben Dios. Yu'un li stsotsil ajolique mu stac' chac'atajesic ta sac, mu stac' chac'atajesic ta ic'. ");
INSERT INTO tzotze_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Meleluc me li c'usitic chavalique. Me mu meleluque, mu me xavalic. Yu'un me chavalique, ja' mulil. ");
INSERT INTO tzotze_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ava'yojic ono'ox ti jech i'albatic comel ta vo'onee: “Me chatu'pbeic jbejuc sat achi'ilique, jech chavich'ic tu'pbel jbejuc asatic ec. Me chacolesbeic jbejuc stanal ye achi'ilique, ja' no'ox jech chavich'ic colesbel jbejuc stanal aveic ec”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero vu'un chacalboxuc, mu me xapacbeic sutel li boch'o chopol c'usi chaspasboxuque. Me oy boch'o chasmajboxuc jot xocon asatique, yu'un tsnop ti oy amulic ta stojole, ac'o smajboxuc xcha'jotal. ");
INSERT INTO tzotze_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Me oy boch'o jeche' no'ox ta stic'boxuc amulic ta stojol jchapanvaneje, me tsc'an tspojboxuc batel ac'u'ique, ac'o yich'. Ac'o yich' batel alapbolal xaquitaic noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Me oy boch'o chasujoxuc ta icatsil jun revae, cuchbeic batel chibuc reva. ");
INSERT INTO tzotze_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Me oy boch'o chasc'anboxuc batel c'usi oy avu'unique, ac'beic batel li c'usi chasc'anboxuque. Me oy c'usi tsc'an chaxch'amanboxuque, mu me xaval ti mu'yuc avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ava'yojic noxtoc ti jech i'albatic comel ta vo'onee: “C'uxubino achi'iltaquic, pero li avajcontraique contrainic”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero vu'un chacalboxuc, c'uxubino avajcontraic. C'anbeic bendición ta stojol li boch'otic chopol ta xc'opojic ta atojolique. Lec xac'opanic li boch'otic chayilintaoxuque, jech chvinaj ti lecuben xa avo'ntonique. C'opanbeic Dios ta stojol li boch'otic chayuts'intaoxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Me jech chapasique, jech ta xvinaj o ti vo'oxuc xnich'naboxuc li Jtotic Dios ta vinajele. Yu'un li Diose co'ol ta xac'be tal vo' ta stojolic li boch'otic tuc' yo'ntonique xchi'uc li boch'otic muc tuc'uc yo'ntonique. Co'ol ta xac' q'uepuc ta stojol li boch'otic chopolique xchi'uc li boch'otic lequique. Co'ol chac'be bendición li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yan me ja' no'ox chac'uxubinic ec li boch'o chaxc'uxubinoxuque, mu xayac'boxuc amotonic li Diose. Yu'un co'oloxuc jech chac c'u cha'al li jtsobpatanetique, yu'un ja' jech ta spasic li stuquique. ");
INSERT INTO tzotze_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Me ja' no'ox lec chac'opanic li boch'otic lec xavotquin aba achi'uquique, mu xvinaj o me lecuben xa li avo'ntonique. Yu'un co'ol chapas achi'uquic li yan cristianoetic ti mu xich'ic ta muc' Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Li vo'oxuque tsc'an oy slequil avo'ntonic jech chac c'u cha'al slequil yo'nton stuc li Jtotic Dios tey oy ta vinajele ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jech laj yalbuncutic noxtoc li Jesuse: ―Q'uelo me abaic ti c'alal chapasic c'usi tsc'an Diose. Mu me xapasic ta sventa yu'un chac'anic ich'el ta muc'. Yu'un me jech chapasique, altic. Mu'yuc chayac'boxuc amotonic li Jtotic Dios ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","C'alal me oy boch'o chacoltaique, mu me boch'o xavalbeic jech chac c'u cha'al ta spasic li jlo'lavanejetic tey ta nail tsobobbailetique xchi'uc tey ta ch'ivite. Yu'un ja' no'ox tsc'anic ich'el ta muc' yu'un cristianoetic ti jech tspasique. Melel li c'usi chacalboxuque, altic ti jech tspasique, mu'yuc stu chil li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Li vo'oxuque mu me jechuc avo'ntonic chavac' abaic ta ilel ti c'alal chacoltavanique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ac'o me ta mucul chapasic pero li Jtotic Diose ta xil scotol. Jech chayac'boxuc ep bendición. Li bendición chavich'ique scotol cristianoetic chlic yilic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’C'alal chac'opanic Diose, mu me jechuc xapasic jech chac c'u cha'al tspasic li jlo'lavanejetique. Ja' lec cha'yic ti tey va'ajtic ta nail tsobobbail xchi'uc ta chiquin calletic ti c'alal ta sc'opanic Diose yu'un jech ac'o ilaticuc yu'un li cristianoetique. Melel li c'usi chacalboxuque, altic ti jech tspasique, mu'yuc stu chil li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Li vo'oxuque mu me jechuc avo'ntonic chavac' abaic ta ilel ti c'alal chac'opanic Diose. Voc'o aba atuquic ti c'alal chac'opanic Diose. Ac'o me ta mucul chapasic pero li Jtotic Diose ta xil scotol. Jech chayac'boxuc ep bendición. Li bendición chavich'ique, scotol cristianoetic chlic yilic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’C'alal chac'opanic Diose, mu me jechuc xac'opanic jech chac c'u cha'al tsc'opan yajsantoic li yan cristianoetic ti mu xotquinic Diose. Yu'un ep ta velta chalic li c'usi chalic c'alal tsc'opan yajsantoique, yu'un tsnopic ti ja' to jech ta x'a'ibat o sc'opique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Li vo'oxuque mu me jechuc xapasic. Yu'un li Jtotique sna'oj ono'ox c'usitic chtun avu'unic ti c'alal mu'yuc to chac'anbeique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ti c'alal chac'opanic Dios li vo'oxuque, jech chac c'u cha'al li'i: Jtotic Dios, tey oyot ta vinajel, ac'o ich'atan ta muc' cu'uncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ac'o sta yorail chtal apas mantal atuc li' ta banamile. Ac'o jpascutic c'usi chac'an jech chac c'u cha'al tspasic tey ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ac'bun tal jve'elcutic li jun c'ac'al li'i. ");
INSERT INTO tzotze_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasbuncutic perdón yu'un jmulcutic jech chac c'u cha'al jpasojbecutic perdón li boch'otic oy smul cu'uncutique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mu me xavac' xistsaluncutic li mulile. Coltauncutic ta stsalel. Yu'un vo'ot atuc chapas mantal sbatel osil. Ech'em atsatsal. Vo'ot chaquich'otcutic ta muc' sbatel osil. Jech ac'o c'otuc ta pasel ta jtojolcutic, xachiic ti c'alal chac'opanic Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Me chapasbeic perdón li boch'o oy smul avu'unique, jech chaspasboxuc perdón yu'un amulic ec li Jtotic tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yan me mu xapasbeic perdón li boch'o oy smul avu'unique, ja' no'ox jech mu xaspasboxuc perdón ec li Jtotic tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Me oy chavictaic ixim c'alal chac'opanic Diose, mu me jechuc xapasic jech chac c'u cha'al ta spasic li jlo'lavanejetique. Ta sbon satic ta tan yu'un chaq'uic ta ilel ta stojol cristianoetic ti yictaojic ixime. Melel li c'usi chacalboxuque, altic ti jech tspasique, mu'yuc stu chil li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Li vo'oxuque mu me jechuc avo'ntonic chavac' abaic ta ilel ti c'alal chavictaic ixime. Tuso ajolic, poco asatic jech chac c'u cha'al chapasic ono'oxe. ");
INSERT INTO tzotze_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jech mu'yuc boch'o ta xil ti avictaojic ixime. Ja' no'ox ta xil stuc li Jtotic Diose. Me jech chapasique, jech chayac'boxuc ep bendición. Li bendición chavich'ique scotol cristianoetic chlic yilic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mu me xatsob ac'ulejalic li' ta banamile yu'un xu' chich' c'uxel ta chil, xchi'uc xu' chcuxin, xchi'uc xu' chbat ta elec'. ");
INSERT INTO tzotze_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ja' lec ac'o tunuc yu'un Dios li c'usitic oy avu'unique jech chatsob ac'ulejalic tey ta vinajel yu'un ja' mu xlaj ta chil, xchi'uc mu xcuxin, xchi'uc mu xbat ta elec'. ");
INSERT INTO tzotze_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yu'un me ja' tey tsobol ac'ulejalique ja' tey batem avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Me chac'uxubinvanique, lec oyoxuc, mu'yuc c'usi yan sc'an avu'unic jech chac c'u cha'al lámpara me lec stsane, lec ta xquiltic o osil. ");
INSERT INTO tzotze_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Me mu xac'uxubinvanique, ja' jechoxuc jech chac c'u cha'al lámpara ti mu stsan leque yu'un oy bu chopol. Me ja' jech avo'ntonique, mu xu' chatunic yu'un Dios yu'un ja' no'ox chac'an ti lec oyoxuc atuquique. Jech tey ta xch'ay o li sc'op Dios ti c'u yepal tey oy ta avo'ntonique. Jech más to ech'em chopol ta xcom o li avo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Mu xu' me chib avajvalic. Jech chac c'u cha'al jun mozo ti mu xu' chib yajvale. Ti chibuc yajvale, li june chopol chil; li yane ja' lec chil. Ja' jun yo'nton ta stojol li june, ja' chopol chil li yane. Ja' no'ox jech mu xu' chatunic yu'un Dios me ja' tey batem avo'ntonic yu'un taq'uine. ");
INSERT INTO tzotze_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ja' yu'un chacalboxuc ava'yic. Mu me xlo'ilaj avo'ntonic ta sventa c'u x'elan chacuxiic li' ta banamile, ja' ti bu chata ave'elique xchi'uc li c'usi chavuch'ique. Mu me xlo'ilaj avo'ntonic yu'un ti bu chata ac'u'ique. Yu'un ja' laj yac'boxuc abec'talic li Diose xchi'uc ja' laj yac' ti cuxuloxuque. Jech noxtoc ja' chayac'boxuc ac'u'ic xchi'uc ave'elic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Q'uelavilic li mutetique. Mu sna' x'ovolajic, mu sna' xc'aojic, mu sna' stsob c'usitic ta sve'ic, mu'yuc snail noxtoc li sve'elique. Ja' mac'linbilic yu'un li Jtotic Dios ta vinajele, ja' stuc xchabioj. Pero li vo'oxuque más to ech'em chaxc'uxubinoxuc li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Altic ti chlo'ilaj avo'ntonic yu'une, mu yu'unuc jech ta xnatub jutuc avorailic li' ta banamil ti jech chapasique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿C'u yu'un ta xlo'ilaj avo'ntonic ta sventa ti bu chata ac'u'ique? Q'uelavilic li nichimetic ti ch'iemic ta yaxaltique. Mu sna' x'abtejic, mu sna' sjal sc'u'ic, pero lec c'upil sbaic ta q'uelel. ");
INSERT INTO tzotze_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta xcalboxuc ava'yic, li Salomón ta vo'onee toj jc'ulej, lec c'upilic sba li sc'u' spoq'ue, pero mu xco'laj xchi'uc jech chac c'u cha'al slequil li nichimetique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Li ts'i'laletique lec c'upilic sba xyaxal, pero ta yoc'omal xcha'ejale taquinic xa'ox. Jech ja' xa ta xtun ta sventa ta xc'ac'ub orno yo' bu ta xta'aj pan. Ac'o me mu'yuc jal ta xch'i pero lec c'upilic sba xyaxal pasbilic yu'un li Diose. Li vo'oxuque más to ech'em lec chayac'boxuc ac'u'ic li Diose. Pero mu to jechuc ach'unojic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ja' lec mu me xlo'ilaj avo'ntonic. Mu me jechuc xavalic: “¿C'usi ta jve'tic? ¿C'usi ta xcuch'tic? ¿Bu ta jta jc'u'tic?” mu me xachiic. ");
INSERT INTO tzotze_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Li boch'otic mu to xotquinic Diose ja' jech tsnop ta yo'ntonic. Pero li Jtotic Dios ta vinajele sna'oj scotol li c'usitic ta xtun avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jech tsc'an ti ba'yuc chavac' abaic ta ventainel yu'un Diose, xchi'uc ti chapasic c'usi tsc'ane, jech chayac'boxuc scotol li c'usitic ta xtun avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jech mu me xlo'ilaj avo'ntonic ta sventa yoc'omal yu'un mu xana'ic li c'usi ta xc'ot ta pasele. Li c'u yepal vocol chavich'ic jujun c'ac'ale, xu' no'ox o. Mu me xavepajes atuquic li avocolique ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jech laj yalbuncutic noxtoc li Jesuse: ―Mu me chopoluc xavil achi'ilic yu'un jech mu xc'ot avich'ic chapanel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yu'un me chopol chavil achi'ilique, ja' no'ox jech chopol chayiloxuc ec li Diose. Me lec chavil achi'ilique, ja' no'ox jech lec chayiloxuc ec li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jech chac c'u cha'al me chavilic ti oy juteb sc'a'epal sat achi'ilique, pero mu xavil aba atuquic ti vo'oxuc más muc' ochem sc'a'epal asatique. ");
INSERT INTO tzotze_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jech chavalbe li achi'ilique: “La' jloq'uestic li sc'a'epal asate”, xavutic, pero ¿c'uxi xu' avu'un chaloq'uesbeic li juteb c'a'ep ochem ta sat achi'ilique yu'un vo'oxuc más muc' ochem sc'a'epal asatic? ");
INSERT INTO tzotze_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jech jlo'lavanejoxuc chac'otic. Ja' tsc'an vo'oxuc ba'yuc chaloq'ues li sc'a'epal asatique, ts'acal to xu' chaloq'uesbeic ec li juteb c'a'ep ochem ta sat achi'ilique. ");
INSERT INTO tzotze_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Li boch'otic toj tsots yo'ntonique ti mu sc'an xich'ic o ta muc' li sc'op Diose, ja' lec mu xa me xavalbeic yan velta li sc'op Dios ti ja' sventa chijcuxiutic sbatel osile. Yu'un ja' jechic jech chac c'u cha'al jcot ts'i' ti bu mu j'ech'el xa'i pajesel c'alal chti'vane. Ja' jechic noxtoc jech chac c'u cha'al chitom ti mu sventauc me ch‑ech' xpech' ta teq'uel li nats'il ti toyol stojol ti lec c'upil sbae. ");
INSERT INTO tzotze_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’C'anilanbeic li Diose jech chayac'boxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yu'un scotol li boch'otic ta sc'anilanbee ja' ta x'ac'batic. ");
INSERT INTO tzotze_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Li vo'oxuque, me ta sc'anboxuc vaj sve' anich'onique, mu tonuc chavac'beic. ");
INSERT INTO tzotze_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Me chasc'anboxuc choy sti'e, mu chonuc chavac'beic. ");
INSERT INTO tzotze_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Li vo'oxuque chopoloxuc ono'ox pero xana'ic c'usi lec chavac'beic li anich'nabique. Li Jtotic Dios ta vinajele ja' más to ech'em sna' c'usi lec ta xac'be li boch'otic ta sc'ane. ");
INSERT INTO tzotze_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Me chac'an lec c'usi chaspasboxuc li cristianoetique, ja' tsc'an ec ti lec c'usi chapasbeique. Yu'un ja' jech chal li smantaltac Dios la sts'iba Moisés ta vo'onee xchi'uc ti la sts'ibaic yantic yaj'alc'optac Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Ochanic batel ta biq'uit be, ja' li sbelal cuxlejale. Yu'un ja' muc' li sbelal ch'ayele, jamal ti bu ta x'oche. Ja' ep li boch'otic tey ta x'ochic batele, yu'un ja' mu vocoluc tey ta x'ochic batel yu'un lec muc' li bee. Ja' biq'uit li sbelal cuxlejale. Biq'uit ti bu ta x'och batele. Atbil no'ox li boch'o ta x'och batele. Ja' no'ox xu' ta x'och batel li boch'otic ta sbic'tajes sbaic ta stojol Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Bijanic me, mu me xaslo'laoxuc li jlo'lavanej j'alc'opetique. Yu'un tey ta xtalic yo' bu oyoxuque lec mansoic yilel jech chac c'u cha'al chij. Pero li yut yo'ntonique ja' jech chac c'u cha'al jti'vanej bolom. ");
INSERT INTO tzotze_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ta sventa no'ox c'usi tspasic ti jech chavotquinic oe. Jech chac c'u cha'al mu'yuc bu chataic ts'usub ta ch'ixte' xchi'uc mu'yuc bu chataic sat igo ta ch'ix, ja' jech mu'yuc c'usi lec chataic yu'un li jlo'lavanej j'alc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Scotol te' ti lec ono'oxe lec sat ta xac'. Yan ti bu mu'yuc ono'ox lec li te'etique mu'yuc lec sat ta xac'. ");
INSERT INTO tzotze_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ti bu lequil te'etique puro lec sat ta xac'. Ti bu mu'yuc lec li te'etique mu lecuc sat ta xac'. Jech mu stac' ta scap sbaic ti bu leque xchi'uc ti bu chopole. ");
INSERT INTO tzotze_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Scotol li te' ti bu mu'yuc lec sate ja' ta xich' ts'etel, ta xjipat ochel ta c'oc'. Ja' no'ox jechic ec li jlo'lavanej j'alc'opetique ta xjipatic ochel ta c'oc'. ");
INSERT INTO tzotze_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ta sventa no'ox c'usi tspasic ti jech chavotquinic oe. Me chopol c'usitic ta spasique, jech chana'ic o ti ja' jlo'lavanej j'alc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Oy ep boch'otic jech ta xalic: “Cajval, Cajval”, xiyuticun, pero mu scotoluc ch‑ochic yo' bu ta jpas mantale. Ja' no'ox ch‑ochic li boch'otic tspasic c'usi ta sc'an yo'nton li Jtot tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Oy ep boch'o jech ta xalbicun ta slajebal c'ac'al: “Cajval, vo'ot ta aventa la jcholcutic ac'op. Vo'ot ta avu'el la jloq'uescutic pucujetic. Vo'ot ta aventa la jpascutic ep sq'uelubil atsatsal”, xiyuticun. ");
INSERT INTO tzotze_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero vu'une jech ta jtac'beic: “Mu'yuc bu laj cotquinoxuc. Batanic, mu xajc'anoxuc yu'un ja' la ach'unbeic smantal li pucuje”, xichi ta jtac'beic. ");
INSERT INTO tzotze_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Li boch'o ta xa'ibun c'usi ta xcale, me ta xch'une, ja' jech chac c'u cha'al jun bijil vinic la spas sna ta ba ton. ");
INSERT INTO tzotze_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ital tsots vo'. Inoj ta vo' scotol li spat xocon snae. Ital tsots ic'. Tsots ic'ot ic' yo' bu oy sna li vinique. Pero muc xlom li snae yu'un ta ba ton spasoj. ");
INSERT INTO tzotze_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Li boch'o ta xa'ibun c'usi ta xcale, me mu xch'une, ja' jech chac c'u cha'al jun vinic ti mu bijuque ti ta ba yi'tic no'ox la spas snae. ");
INSERT INTO tzotze_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ital tsots vo'. Inoj ta vo' scotol li spat xocon snae. Ital tsots ic'. Tsots ic'ot ic' yo' bu oy sna li vinique. Toj lomel no'ox ic'ot o ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","C'alal ilaj yo'nton ta lo'il li Jesuse, li jchi'iltactique labal laj ya'yic c'u x'elan ichanubtasvan li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yu'un jech ichanubtasvan jech chac c'u cha'al li boch'o lec sna' c'usi tsc'an Diose. Mu jechuc ichanubtasvan jech chac c'u cha'al jchi'iltactic ti jchanubtasvanejetic ta smantal Dios yalojique. ");
INSERT INTO tzotze_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","C'alal iyalic tal ta yoc vits xchi'uc yajchanc'optac li Jesuse, toj ep jchi'iltactic la xchi'inic batel. ");
INSERT INTO tzotze_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tey la snupic ta be jun jc'a'el chamel, ja' jchi'iltic ta israelal. Tal squejan sba ta stojol li Jesuse. Jech laj yalbe: ―Cajval, me chac'an chacoltaune, xu' avu'un chacoltaun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Li Jesuse laj yac' sc'ob ta sbec'tal li jchamele, jech laj yalbe: ―Lec oy, colan cha'e ―xut. Jech ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Li Jesuse jech laj yalbe noxtoc: ―Mu me boch'o xavalbe ya'i. Ja' no'ox bat ac' aba ta ilel ta stojol pale. Ac'bo smoton Dios jech chac c'u cha'al yaloj ono'ox Moisés ta vo'onee jech ta sna'ic o jchi'iltactic ti colemot xae ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","C'alal i'ochic ta lum Capernaum xchi'uc yajchanc'optac li Jesuse, tey ital ta stojol jun yanlum vinic ja' capitán soldado. Yu'un tal sc'anbe vocol li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jech laj yalbe: ―Cajval, ip cha'i jmozo. Tey mochol ta jna yu'un aluben yacan. Toj c'ux cha'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Itac'ov li Jesuse: ―Ta xbat jcolta comel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Itac'ov li capitane: ―Cajval, mu'yuc tsots cabtel yu'un ti vo'ot chabat ta jnae. Ja' no'ox alo amantal jech ta xcol o li jmozoe. ");
INSERT INTO tzotze_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yu'un li vu'une pasbilun no'ox ta mantal ec ti ta jpas ta mantal soldadoetique. “Batan”, me xcut li june, ta xbat cu'un. “La' li'i”, me xcut li yane, ta xtal cu'un. “Paso jech”, me xcut li jmozoe, ta spas cu'un ―xi li capitán soldadoe. ");
INSERT INTO tzotze_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","C'alal jech laj ya'i li Jesuse, toj ch'ayel ic'ot yo'nton. Jech laj yalbe li boch'otic tey xchi'inoje: ―Melel li c'usi chacalboxuque, mu'yuc to bu jech jtaoj junuc jchi'iltic ta israelal ti jech ta xch'un jech chac c'u cha'al li vinic li'i. ");
INSERT INTO tzotze_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chacalboxuc noxtoc. Ta yan c'ac'al ep ta xtalic cristianoetic ta scotol banamil ti mu ja'uc jchi'iltic ta israelale. Tey chc'ot xchi'inic yo' bu tspas mantal Dios li jmoltotactic ta vo'onee, ja' li Abraáme, xchi'uc li Isaaque, xchi'uc li Jacove. ");
INSERT INTO tzotze_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yan li boch'otic jech ta xalique: “Ja' jmoltotic ta vo'one li Abraáme jech ta ono'ox xij'ochutic yo' bu ta spas mantal Diose”, me xiique, ja' mu x'ochic. Ta xjipatic ochel ta ic' osil. Tey chc'ot yoc'ta sbaic o, tey xc'uxet o yeic ta scoj ti tsots castigo chich'ique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Li Jesuse jech laj yalbe li capitán soldadoe: ―Batan. Li c'usi ach'unoje ta xc'ot ta pasel ―xut. Jech ta ora icol o li smozoe. ");
INSERT INTO tzotze_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Li Jesuse tey i'och ta sna li Pedroe xchi'uc li yan yajchanc'optaque. Laj yil tey mochol ta svayab li smeni' Pedroe yu'un ip cha'i c'ac'ubel. ");
INSERT INTO tzotze_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Li Jesuse la spicbe sc'ob. Ta ora i'ech' li sc'ac'ubele. Ilic ta svayab, lic mac'linvanuc. ");
INSERT INTO tzotze_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","C'alal ch'ayem xa'ox c'ac'ale, laj yiq'uic tal ta stojol Jesús ep boch'otic ochem pucuj ta yo'ntonic. Li Jesuse ta jujubel no'ox sc'op la stacan loq'uel li pucujetic ti ochem ta yo'nton cristianoetique. La scolta noxtoc scotol li jchameletic tey yic'ojic tale. ");
INSERT INTO tzotze_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jech ic'ot o c'usi laj yal li j'alc'op Isaías ta vo'onee. Jech laj yal: “Ja' chtal scoltautic c'usiuc no'ox ip chca'itic”, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","C'alal laj yil Jesús ti joyibtabil yu'un ep jchi'iltactique, jech lic yalbe li yajchanc'optaque: ―Batic ta jot nab ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Li Jesuse tey ital c'opanatuc yu'un jun jchanubtasvanej ta smantal Dios yaloj. Jech vul albatuc: ―Cajval, ta jchi'inot batel ti buyuc no'ox chabate ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Itac'ov li Jesuse: ―Oy xch'en li vetetique, oy stas li mutetique. Vu'un ti co'ol cristianoutique mu'yuc jna. Jech nopo lec me xu' avu'un chachi'inune ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tey ital jun jch'unolajel, ja' ti tey ono'ox xchi'uc scotol c'ac'al ec li Cajvaltique. Jech laj yalbe: ―Cajval, coltaun to batel yu'un chbat jchi'in li jtote. Ja' to me ichame, ta jmuc comel, ts'acal to chtal jchi'inot ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Itac'ov li Jesuse: ―Chi'inun o batel. Li boch'otic xco'laj xchi'uc chamenic ya'yel ta sventa ti mu xiyich'icun ta muq'ue, tey ac'o smuc sba stuquic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","I'och ta canova li Jesuse, tey i'ochic ec li yajchanc'optaque yu'un tsc'an ta xjelovic batel ta jot nab. ");
INSERT INTO tzotze_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","C'alal chanovic batel ta ba nabe, ta ora ital tsots ic', tsots la syuq'uilan li nabe. I'och ep vo' ta yut canova, c'an xa ochuc yalel ta yut nab. Li Jesuse tey vayem ta yut canova. ");
INSERT INTO tzotze_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Li Jesuse itijat yu'un li yajchanc'optaque. Jech laj yalbeic: ―Cajval, coltauncutic yu'un li' xa chijcham ta nab ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Itac'ov li Jesuse: ―¿C'u yu'un chaxi'ic? Yu'un mu'yuc to lec ach'unojic ―xi. Ilic li Jesuse, la spajes li iq'ue xchi'uc li nabe. Jech ich'abi o scotol. ");
INSERT INTO tzotze_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Toj labal laj ya'yic li yajchanc'optaque, jech laj yalbe sbaic: ―¿Boch'o vinical li'i? Yu'un c'alal ta ic', c'alal ta nab ta xch'unbat smantal ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tey ic'otic ta jot nab ta yosilal gadáraetic. Tey iloq'uic ta canova xchi'uc yajchanc'optac li Jesuse, ixanovic batel. Tey la snupic ta be chib viniquetic ochem pucuj ta yo'ntonic. Tey iloq'uic tal ta muquinaltic. Yu'un ja' snainojic li vombil tonetic yo' bu chbat mucatuc li boch'o ta xchame. Li chibique pasemic ta cimarrón ta jyalel. Mu'yuc xa boch'o ta xjelov tey ta be yu'un xi'emic yu'un li chibique. ");
INSERT INTO tzotze_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Li chibique tsots laj yaptaic li Jesuse: ―Jesús, vo'ot Xnich'onot Dios, ¿c'u yu'un tal atic' aba ta jtojolcutic? Mu'yuc to tsta yorail chavac'buncutic castigo ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Oy ep chitometic tey nopol ta sa' sve'elic. ");
INSERT INTO tzotze_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Li pucujetique la sc'anbeic vocol li Jesuse, jech laj yalbeic: ―Me yu'un chatacuncutic loq'uel li'i, ac'o bat ochcuncutic ta yo'nton li chitometique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Loc'anic batel ―x'utatic yu'un li Jesuse. Jech iloq'uic batel ta yo'nton li chib vinique, tey bat ochicuc ta yo'nton li chitometique. Li chitometique i'anilajic yalel ta yalubaltic. Tey ibalch'ujic yalel ta nab, tey ijic'ov scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Li jchabichitometique ixi'ic batel. Bat yalbeic scotol cristianoetic ta lum. Bat yalic ti icham scotol li chitometique xchi'uc ti icolic xa li chib xchi'ilic ti ochem to'ox pucuj ta yo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Scotol li cristianoetic tey nacajtic ta lume iloq'uic tal. Tal staic li Jesuse. C'alal ivulique, laj yalbeic ti svocoluc ac'o loc'uc batel ta yosilalique. ");
INSERT INTO tzotze_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jech i'och ta canova xchi'uc yajchanc'optac li Jesuse. Isut batel ta slumal, ja' li Capernaume. ");
INSERT INTO tzotze_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tey laj yiq'uic tal ta stojol Jesús jun jchi'iltic ta israelal aluben yacan, xq'uechubte'ojic tal. C'alal laj yil Jesús ti xch'unojic ti ja' Jcoltavaneje, jech lic yalbe li jchamele: ―Tata, mu xavat avo'nton. Pasbilot xa perdón yu'un scotol amul ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tey oy jayibuc jchanubtasvanejetic ta smantal Dios yalojic. Jech la snop ta yo'ntonic: “Li vinic li'i ta scuy sba ta Dios”, xi ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Li Jesuse la sna' li c'usi la snop ta yo'ntonique, jech laj yalbe: ―¿C'u yu'un ti mu'yuc lec c'usi chanop ta avo'ntonique? ");
INSERT INTO tzotze_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta melel boch'ouc no'ox xu' ta xal ti “pasbilot xa perdón yu'un amul” xie yu'un mu vocoluc ta alel. Jech noxtoc mu vocoluc ta alel ti “lican, xanovan” xie. Pero ja' tsc'an chaq'uelic lec me ta melel ta xc'ot ta pasel yu'un li boch'o jech ta xale. ");
INSERT INTO tzotze_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vu'une laj cal ti pasbil xa perdón yu'un smul li vinique. Jech q'uelic me c'usi ta jpas li' ta orae yu'un jech chana'ic o ti vu'un no'ox ta jpasbe perdón yu'un smulic cristianoetic li' ta banamil, vu'un ti co'ol cristianoutique ―xut. Li Jesuse jech laj yalbe li jchamele: ―Lican, ich'o batel avayab, batan ta ana ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ta ora ilic li jchamele, ibat ta sna. ");
INSERT INTO tzotze_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","C'alal laj yilic li epal cristianoetique, ixi'ic. Laj yalbeic slequilal Dios ta sventa ti jech yac'ojbe svu'el jun vinique. ");
INSERT INTO tzotze_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","C'alal ijelov batel jutuc li Jesuse, laj yil tey chotolun ta jchotleb yo' bu ta xac' spatan li cristianoetique. Mateo jbi. Jech laj yalbun li Jesuse: ―La' chi'inun batel ―xiyutun. Ta ora la jchi'in batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ts'acal bat ve'uc li Jesuse. Tey la stsob sbaic tal ep jtsobpatanetic xchi'uc li yantic jpasmuliletique. Tey tal xchi'inuncutic ta chotlej ta ti' mesa. Tey oyuncutic jcotolcutic, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","C'alal laj yilic li fariseoetic tey oyique, jech la sjac'buncutic: ―¿C'u yu'un ta xve' xchi'uc jtsobpatanetic xchi'uc yantic jpasmuliletic li jchanubtasvanej avu'unique? ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Li Jesuse laj ya'i li c'usi laj yalique, jech laj yalbe: ―Li boch'otic tsotsique mu sc'anic poxtael. Ja' no'ox ta sc'anic poxtael li boch'otic ipique. ");
INSERT INTO tzotze_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bat nopo ava'yic c'usi smelol ti jech yaloj Diose: “Ja' ta jc'an ti chac'uxubinvanique, ma'uc no'ox ta jc'an ti chavac'bicun milbil matanale”, xi li Diose. Li vu'une mu ja'uc tal quic' li boch'otic mu'yuc smul yalojique. Ja' tal quic' li jpasmuliletique yu'un jech ac'o scomtsan li smulique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Li yajchanc'optac Juan j'ac'vanej ta vo'e tey italic ta stojol Jesús. Jech tal sjac'beic li Jesuse: ―Li fariseoetique ep ta velta chictaic ixim. Ja' no'ox jechuncutic ec li vu'uncutique. ¿C'u yu'un mu xictaic ixim avajchanc'optac li vo'ote? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Itac'ov li Jesuse: ―C'alal yorail nupinele, tey oy li malalile jech mu xu' ta xat yo'ntonic li yajtestigoe yu'un tey to xchi'uquic li malalile. Ja' no'ox jech ec li cajchanc'optaque mu jechuc smelol ti ta xictaic ixime, ti ta xat yo'ntonique, yu'un li' to jchi'inojic. Ja' to me la sta sc'ac'alil ta smilicun li cajcontrae, ja' to xu' chlic yat yo'ntonic, ja' to xu' ta xictaic ixim li cajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Li boch'o ta xch'un c'usi chcale persa ta scomtsan li c'usi xch'unoj ti snopoj jech chcol oe. Persa scotol yo'nton ta xch'un li c'usi chcale yu'un jech chcol o. Jech chac c'u cha'al mu'yuc boch'o ta spac'an poco' c'u'il ta ach' manta yu'un mu'yuc to mutsem. Me oy boch'o jech ta spase, más to ech'em ta xli' batel li poco' c'u'ile. ");
INSERT INTO tzotze_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jech noxtoc li ach' ya'lel ts'usub ti ta xa xpajube, mu'yuc boch'o ta xch'ol ta poco' yav pasbil ta nucul. Me oy boch'o jech ta spase, c'alal ta xvocan stuc li ya'lel ts'usube, ta xjat li yavile. Altic chmal o scotol li ya'lel ts'usube. Li yavile mu xa xtun o. Li ach' ya'lel ts'usub ti ta xa xpajube ja' tsc'an ta ach' yav ta xich' ch'olel. Jech lec ta xcom o xchi'uc yav li ya'lel ts'usub ti pajuben xae ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","C'alal ta to xlo'ilaj li Jesuse, tey ital jun jchi'iltic ta israelal, ja' jchapanvanej ta jun nail tsobobbail. Tey ital squejan sba ta stojol li Jesuse, jech vul yalbe: ―Jliquel to icham jtseb. ¿Me mu xa'abulaj xbat avac' ac'ob ta sbec'tal yu'un jech ta xcha'cuxi? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Li Jesuse la xchi'in batel li jchi'iltique. Vu'uncutic li yajchanc'opuncutique la jchi'incutic batel ec. ");
INSERT INTO tzotze_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Oy jun ants lajchab xa jabil ip cha'i tuch' patijel. Tey inoch'aj tal ta spat li Jesuse, la spicbe stsitsumal yoc xaquita. ");
INSERT INTO tzotze_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jech la snop ta yo'nton: “Ac'o me ja' no'ox ta jpicbe xaquitae, chicol o”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ijoyij li Jesuse, la sq'uel li antse, jech laj yalbe: ―Tseb, junuc avo'nton. Yu'un laj ach'un ti xu' cu'une, jech chacol ―xut. Ta ora tey icol o li antse. ");
INSERT INTO tzotze_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Li Jesuse tey ic'ot ta sna li jchapanvanej ta nail tsobobbaile, tey i'och. Laj yil tey oy jupanej amaetic. Tey x'avetic ta oq'uel li jchi'iltactique. ");
INSERT INTO tzotze_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jech i'albatic yu'un li Jesuse: ―Loc'anic batel. Mu'yuc chamen li tsebe, ja' no'ox ta xvay ―xi. C'alal jech laj ya'yic li jchi'iltactique, la stse'intaic li Jesuse yu'un sna'ic ti chamen o li tsebe. ");
INSERT INTO tzotze_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Li Jesuse la stacan loq'uel scotol li jchi'iltactique. Stuc i'och batel yo' bu telel li ánimae. La stsacbe sc'ob li tsebe, ta ora ilic. Jech icha'cuxi o. ");
INSERT INTO tzotze_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ta ora ivinaj ta scotol cosilaltic ti la xcha'cuxes tseb li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ixanov batel yan velta li Jesuse. Tey jchi'inojcutic batel, vu'uncutic li yajchanc'opuncutique. Tey nabalic batel chib jchi'iltic ta israelal ja' ma'satetic. Tsots laj yaptaic li Jesuse: ―Vo'ot smomnich'onot David ti sc'oplal ono'ox cha'och ta ajvalilal cu'uncutique, ¡c'uxubinuncutic! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","C'alal i'och ta na li Jesuse, tey ital ta stojol li chib ma'satetique. Li Jesuse jech la sjac'be: ―¿Me ach'unojic ti xu' cu'un ta jamboxuc asatique? ―xut. ―Jch'unojcutic, Cajval ―xi itac'ovic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Li Jesuse la spicbe sat li chib ma'satetique. Jech laj yalbe: ―Yu'un ach'unojic ti xu' cu'un ta jamboxuc asatique, jech ac'o jamuc ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ta ora ijam li satique. Li Jesuse tsots laj yalbe mantal: ―Mu me boch'o xavalbeic ti vu'un la jcoltaoxuque ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero c'alal isutic batele, ic'ot yalic ta scotol cosilaltic ti c'u x'elan icoltaatic yu'un Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","C'alal mu'yuc to ta xloq'uic batel li chib ma'satetique, tey ic'bil ital ta stojol Jesús jun uma' vinic, ja' jchi'iltic ta israelal. Ochem pucuj ta yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Li Jesuse la sloq'uesbe li pucuj tey ochem ta yo'ntone. Jech tey lic c'opojuc li vinique. Toj ch'ayel ic'ot yo'ntonic li epal cristianoetique. Jech laj yalic: ―Mu'yuc baq'uin xquiltic jech tspas junuc jchi'iltic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","C'alal laj yilic li fariseoetic tey oyique, jech lic yalbe sbaic: ―Li vinic li'i ta svu'el banquilal pucuj ta sloq'ues pucujetic ta yo'nton cristianoetic ―xi la slabanic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Li Jesuse ixanov batel ta scotol lumetic xchi'uc ta jujun tsobtsobnaetic. Tey ichanubtasvan ta jujun nail tsobobbail yu'un li jchi'iltactique. Tey la xcholbe ya'yic li lequil a'yeje, ja' ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. La scolta noxtoc ep jchameletic c'usiuc no'ox chamelal ip cha'yic. ");
INSERT INTO tzotze_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","C'alal laj yil Jesús ti ep cristianoetic tey stsoboj sbaique toj abul sbaic laj yil. Yu'un ja' jechic jech chac c'u cha'al chij ti mu'yuc xchabiele. ");
INSERT INTO tzotze_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jech lic yalbuncutic, vu'uncutic li yajchanc'opuncutique: ―Ta melel oy ep boch'otic tsc'an cha'yic li sc'op Diose. Ja' mu'yuc ep li boch'o tsc'an ta xcholique. Jech chac c'u cha'al me ep li c'aoje pero ja' mu'yuc ep li jc'aojetique. ");
INSERT INTO tzotze_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ja' lec c'anbeic Dios ti ac'o stac batel li boch'otic chbat cholbatuc sc'ope yu'un ja' yajval abtel ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Li lajchab yic'ojuncutic ta yajchanc'op li Jesuse, laj yac'bun jtsatsalcutic yu'un ta jloq'uescutic pucujetic ta yo'nton cristianoetic xchi'uc ta jcoltacutic jchameletic, c'usiuc no'ox chamelal ip cha'yic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Li jbicutique ja' li'i: li boch'o ba'yuc it'ujate ja' Simón ti Pedro xchibal sbie. Xchi'uc Andrés, ja' yits'in li Pedroe. Xchi'uc Jacobo xchi'uc yits'in, Juan sbi. Ja' xnich'nab li Zebedeoe. ");
INSERT INTO tzotze_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Xchi'uc Felipe xchi'uc Bartolomé. Xchi'uc Tomás xchi'uc vu'un li Mateoun ti jtsobpatanun to'oxe. Xchi'uc yan Jacobo sbi, ja' xnich'on Alfeo. Xchi'uc Lebeo, ja' Tadeo xchibal sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xchi'uc Simón ti laj to'ox xchi'in li cananeoetique. Xchi'uc Judas Iscariote, ja' ti ts'acal to lic yac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Li lajchabuncutique lic stacuncutic batel li Jesuse. Lec laj yalbuncutic batel mantal, jech laj yal: ―Mu me xabatic ta yosilal li boch'otic mu ja'uc jchi'iltic ta israelale xchi'uc ta yosilal li samáriaetique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ja' no'ox tey xabatic yo' bu oyic li jchi'iltactic ta israelale, yu'un ch'ayemic jech chac c'u cha'al chijetic. Yantic be stamojic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Bat albeic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Coltaic jchameletic. Cha'cuxesic ánimaetic. Coltaic boch'otic yich'ojic c'a'el chamel. Loq'uesic pucujetic ta yo'nton cristianoetic. Li atsatsalic laj cac'boxuque ja' amotonic. Jech ta matanal me xacoltavanic ec. ");
INSERT INTO tzotze_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mu me xavich' batel ataq'uinic, ac'o me c'anal taq'uin, ac'o me saquil taq'uin, ac'o me cobre. ");
INSERT INTO tzotze_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mu me xavich' batel ave'elic. Mu me xavich' batel cha'lic ac'u'ic, xchi'uc axonobic, xchi'uc anamte'ic. Yu'un li boch'otic ta x'abtejique tey ta x'ac'bat sve'elic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Buticuc no'ox cha'ochic, me ta lumetic, me ta tsobtsobnaetic, jaq'uic me ti boch'o lec sc'oplale. Xu' ja' tey cha'ochic ta sna, tey xachi'inic ja' to me laj anopic ti chaloq'uic batele. ");
INSERT INTO tzotze_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","C'alal cha'ochic ta snae, jech xavalbeic: “Ac'o spasboxuc ta jun avo'ntonic li Diose”, utic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Me ta xich'oxuc ta muc' ti vo'oxuc cajchanc'opoxuque, tstaic li jun yo'ntonique. Me mu xayich'oxuc ta muq'ue, mu staic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Me oy boch'o mu xac' ochanic ta snae, me mu sc'an xa'i ac'opique, loc'anic batel ta sna, o me ta slumal. Lilino comel spucucal avacanic. Ja' senyail ti ja' xa icom ta sventa stuquic ti muc xich'ic ta muc' li jc'op laj avalbeique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Melel li c'usi chacalboxuque, c'alal tsta yorail ta xac' castigo li Diose, ja' más tsots castigo ta xich'ic li cristianoetic tey ta lum bu mu xayotesique. Ja' jutuc no'ox castigo ta xich'ic li cristianoetic tey ta lum Sodoma xchi'uc ta lum Gomorra ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’A'yo ava'yic, ta jtacoxuc batel jech chac c'u cha'al chijetic ti chc'ot staic oq'uiletique, yu'un tey chc'ot ataic li boch'otic tsc'an ta smiloxuque. Jech bijanic me. Jech chac c'u cha'al orachon ti lec bije ja' no'ox jech tsc'an li vo'oxuque. Pero lecuc me avo'ntonic jech chac c'u cha'al stsumut. ");
INSERT INTO tzotze_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bijanic me, yu'un oy boch'o mu xasc'anoxuc. Chayac'oxuc ta sc'ob li boch'otic oy yabtelic tey ta nail tsobobbail yu'unique. Tey chayac'boxuc nucul ta nail tsobobbailetic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chayic'oxuc batel ta stojol gobernadoretic xchi'uc ta stojol muc'tic ajvaliletic pero vu'un ta jcoj, jech xu' tey chacholic batel jc'op ta stojolic, xchi'uc ta stojol li boch'otic mu ja'uc jchi'iltic ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","C'alal cha'ac'atic ta c'abale, mu me xlo'ilaj avo'ntonic ta sventa li c'usi chc'ot avalique xchi'uc ti c'uxi chatac'ovique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yu'un mu vo'ocoxuc xa chac'opojic. Ja' chayac'boxuc ana'ic li Ch'ul Espíritu ti junic xchi'uc Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Oy boch'o chac' ta milel yits'in. Oy boch'o chac' ta milel sbanquil. Oy xnich'onic no'ox chaq'uic ta milel. Oy boch'o tscontrain stot sme', chac' ta milel noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ep boch'otic chopol chayiloxuc ta sventa ti ach'unojbicun jc'ope. Li boch'o ta xcuch yu'un c'alal to ta slajebe, ja' ta xcol. ");
INSERT INTO tzotze_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Me tey chataic uts'intael ti bu lumal chac'otique, batanic ta yan lum. Melel li c'usi chacalboxuque, c'alal chital yan velta, vu'un ti co'ol cristianoutique, mu'yuc to cuchem avu'unic sq'uelel scotol li lumetic li' ta cosilaltique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Vo'oxuc li cajchanc'opoxuque, vo'oxuc ti chatunic cu'une, mu me xanopic ti lec cha'ilatique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta ono'ox xavich'ic contrainel jech chac c'u cha'al chquich' contrainel, vu'un li jchanubtasvanejun avu'unique, vu'un li avajvalicune. Vu'un li banquilalun avu'unique, “pucujot”, xi jc'oplal. Buuc xa vo'oxuc li jnich'naboxuque, más to ech'em chopol c'usi chayalboxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Pero mu me xaxi'ic yu'un li cristianoetique. Yu'un persa ono'ox ta xvinaj li c'usitic calojboxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jech ja' avabtelic ti jamal chavalic batele. ");
INSERT INTO tzotze_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mu me ja'uc xaxi'ic yu'un li boch'o ta smil abec'talique yu'un mu xu' yu'un ta smil li ach'ulelique. Ja' me xaxi'ic li Diose yu'un ja' xu' yu'un chayac'oxuc batel ta muc'ta c'oc' c'alal ta ach'ulelic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Xana'ic ti cinco centavo no'ox stojol ta cha'cot li bic'tal mutetique. Pero me jcotuc mu xbaj yalel ta banamil me mu jechuc tsc'an li Jtotique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Li vo'oxuque atbil jaybej li stsotsil ajolique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ja' yu'un mu me xaxi'ic. Yu'un más to ech'em tsots ac'oplalic li vo'oxuque, ja' jutuc no'ox sc'oplalic li bic'tal mutetique. ");
INSERT INTO tzotze_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Li boch'otic jamal chalic ta stojol cristianoetic ti xch'unojbicun jc'ope, ja' no'ox jech ec li vu'une jamal chcal ta stojol Jtot tey ta vinajel ti melel xch'unojbicun jc'ope. ");
INSERT INTO tzotze_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yan li boch'otic mu jamaluc ta xalic ta stojol cristianoetic ti xch'unojbicun jc'ope, ja' no'ox jechun ec li vu'une “le'e mu'yuc xch'unojbun jc'op”, xcut li Jtot tey ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mu me xanopic ti lital yu'un jech chco'laj yo'ntonic li cristianoetic li' ta banamile. Mu yu'unuc tal jco'lajesbe yo'ntonic. Vu'un ta jventa chlic scontrain sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Vu'un ta jventa chlic scontrain sbaic jun vinic xchi'uc stot. Jech noxtoc li tsebe ta scontrain li sme'e. Ja' no'ox jech ec li alibale ta scontrain li sme'el'alibe. ");
INSERT INTO tzotze_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta jun no'ox snailalic ta scontrain sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Boch'o mu sc'an xtal ta jtojol yu'un ta xi' me ta x'ilintaat yu'un stot sme'e, mu xu' chixchi'inun. Boch'o mu sc'an xtal ta jtojol yu'un ta xi' me ta x'ilin li xnich'nabe, mu xu' chixchi'inun noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Boch'o junucal mu sc'an xich' vocol jech chac c'u cha'al chquich' vocol vu'une, mu xu' chixchi'inun. ");
INSERT INTO tzotze_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Li boch'o mu sc'an xcham ta jcoje ja' ch'ayel chbat. Yan li boch'o mu sventauc me ta xchame, vu'un ta jventa, ja' ta xcuxi o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Boch'o chayich'oxuc ta muq'ue ja' vu'un chiyich'un o ta muc'. Li boch'o chiyich'un ta muq'ue, ja' ta xich' o ta muc' li Jtot ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Boch'o ta xich' ta muc' jun j'alc'op yu'un Diose, yu'un sna' ti ja' ac'bil yabtel yu'un Diose, co'ol chich' smotonic xchi'uc li j'alc'ope. Boch'o ta xich' ta muc' jun vinic yu'un sna' ti tuc' yo'ntone, co'ol chich' smotonic xchi'uc. ");
INSERT INTO tzotze_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Boch'o ja' no'ox ta xac'boxuc yoxo' avuch'ic yu'un chilic ti chatunic cu'une, ac'o me jun no'ox vaso siquil yoxo', melel chacalboxuc ta xich' smotonic ec ta sventa ti jech la spasique ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","C'alal laj yalbuncutic mantal Jesús, vu'uncutic li lajchab yajchanc'opuncutique, iloc' batel. La jchi'incutic batel. Li Jesuse bat chanubtasvanuc, bat yal sc'op Dios ta lumetic ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Li Juan tey tiq'uil ta chuquele, laj ya'i c'usitic ta spas li Cristoe jech la stac tal jayibuc yajchanc'optac. ");
INSERT INTO tzotze_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jech vul sjac'beic li Jesuse: ―“¿Me vo'ot Cristoot ti sc'oplal ono'ox chtal aventainuncutique, o me ta to jmalacutic yan? utic c'otel”, xiyutuncutic tal li Juane ―xutic c'otel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Itac'ov li Jesuse: ―Bat albo ya'i Juan scotol li c'usitic laj ava'yic laj cale xchi'uc li c'usitic laj avilic la jpase. ");
INSERT INTO tzotze_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Li ma'satetic to'oxe ta xilic xa osil. Li coxoetic to'oxe ta xanovic xa. Icolic xa li boch'otic tsacbil to'ox ta c'a'el chamele. Ijam xa xchiquinic li boch'otic macal to'ox xchiquinique. Li boch'otic chamenique icha'cuxiic xa. Li me'onetique icholbat xa ya'yic ti chc'uxubinatic yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Me mu xchibaj yo'nton ta jtojol li Juane, xcuxet no'ox yo'nton, xiyutuncutic tal li Jesuse”, utic c'otel li Juane ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","C'alal ta xa xbatic li viniquetique, li Jesuse lic yalbe epal cristianoetic c'u x'elan sc'oplal li Juane. Jech laj yal: ―Li boch'o ay aq'uelic tey ta xocol banamile, laj ana'ic ti mu ja'uc li boch'o chib c'usi ta spas jech chac c'u cha'al jtec' aj ti xne'et no'ox ta iq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Laj avilic ti mu'yuc lec sc'u' slapoje. Yu'un li boch'otic toj lec sc'u' slapojique ja' li boch'otic tey oyic ta sna ajvaliletique. ");
INSERT INTO tzotze_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","C'alal ay aq'uelique, laj ana'ic ti ja' yaj'alc'op Diose. Chacalboxuc ava'yic, li Juane ja' más banquilal yu'un li yantic yaj'alc'optac Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ja' Juan ti ts'ibabil ono'ox sc'oplal ti ba'yuc ta xtal cu'une. Jech ts'ibabil: Ba'yuc ta xjelov avu'un li j'alc'op ta jtac batele. Ja' ta xalbe cristianoetic ti chabate yu'un jech xu' chayich'icot ta muc', xiyutun li Jtote, xi ono'ox ts'ibabil sc'oplal li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Melel li c'usi chacalboxuque, scotol li cristianoetique mu'yuc boch'o jech tsots yabtel yich'oj jech chac c'u cha'al tsots yabtel laj yich' li Juan j'ac'vanej ta vo'e. Pero li boch'o chac' sba ta ventainel yu'un Diose, ac'o me mu'yuc yabtel, ja' más chil c'u x'elan stsatsal Dios. Li Juane ja' jutuc no'ox laj yil. ");
INSERT INTO tzotze_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’C'alal la stsac yabtel li Juan j'ac'vanej ta vo'e c'alal to tana, oy boch'o scotol yo'ntonic chac' sbaic ta ventainel yu'un li Diose. Boch'o scotol yo'ntonic ta sc'anic ventainele ta ono'ox xventainatic yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","C'alal mu'yuc to'ox talem li Juane, jech ono'ox ts'ibabil ta sc'op Dios yu'un scotol j'alc'opetic ta vo'one ti jech to ta xc'ot ta pasele. ");
INSERT INTO tzotze_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Me chach'unic ti yorail xa chventainvan li Diose, jech chana'ic o ti ja' xq'uexol Elías li Juan ti li' xa oye. ");
INSERT INTO tzotze_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Boch'o laj ya'i ac'o snopbe lec smelol. ");
INSERT INTO tzotze_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Chacalboxuc ava'yic c'u x'elan atalelic ti li' oyoxuc ta banamile. Ja' jechoxuc jech chac c'u cha'al ololetic ti tey chotol chtajinic ta ch'ivite, jech chalbe li xchi'ilique: ");
INSERT INTO tzotze_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“La jupancutic ama sventa nupinel pero muc xa'ac'otajic. C'alal li'oc'cutic ta scoj ti oy boch'o icham cu'uncutique, muc xavat avo'ntonic noxtoc. Mu c'usi xac'anic o”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yu'un c'alal ital li Juane, muc xaxchi'inoxuc ta ve'el. Jech laj avalic: “Ochem pucuj ta yo'nton”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","C'alal lital, vu'un ti co'ol cristianoutique, la jchi'inoxuc ta ve'el. Pero jech laj avalic noxtoc: “Q'uelavil toj ech'em xve', toj ech'em xuch' ya'lel ts'usub. Lec ta xil sbaic noxtoc xchi'uc jtsobpatanetic xchi'uc yan jpasmuliletic”, xachiic. Ti ja'uc laj yac'boxuc abijilic li Diose, laj avich'uncutic ta muc' xchi'uc Juan ti jechuque. Jech laj ana'ic ti ja' ta sbijil Dios la jpascutic li c'usitic la jpascutique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Li Jesuse laj yal c'u x'elan sc'oplalic li jchi'iltactic ta israelal tey ta lumetic ti bu la spas ep sq'uelubiltac stsatsale, ja' ti muc scomtsanic li c'usitic chopol ta spasique. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Li jchi'iltactic tey nacajtic ta lum Corazine xchi'uc li jchi'iltactic tey nacajtic ta lum Betsáidae, ta ono'ox xich'ic tsots castigo yu'un laj yilic ep sq'uelubil jtsatsal pero muc xch'unic. Li yanlum cristianoetic tey nacajtic ta lum Tiro xchi'uc ta lum Sidón ta vo'onee, muc xilic sq'uelubil jtsatsal. Ti lajuc yilique, la slapic jalbil tsotsil tentsun ti c'ux ta lapele, xchi'uc la sbon sbaic ta tanil c'oc' ti jechuque. Ja' senyail ti chat yo'ntonic yu'un li c'usitic chopol spasojique, jech tscomtsanic. ");
INSERT INTO tzotze_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jech chacalboxuc. C'alal tsta sc'ac'alil ta xchapanatic yu'un Dios li cristianoetique, ja' jutuc castigo ta xich'ic li yan lum cristianoetic tey nacajtic ta Tiro xchi'uc ta Sidón ta vo'onee. Ja' tsots castigo ta xich'ic li jchi'iltactic tey nacajtic ta Corazín xchi'uc ta Betsáida ta ora le'e. ");
INSERT INTO tzotze_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Li jchi'iltactic tey nacajtic ta lum Capernaume tsnopic ti ja' ep ta xich'ic bendicione, pero altic. Ja' tsots castigo ta xich'ic yu'un laj yilic ep sq'uelubil jtsatsal pero muc xch'unic. Li cristianoetic tey nacajtic ta lum Sodoma ta vo'onee muc xilic sq'uelubil jtsatsal. Ti lajuc yilique, tey to oy o tana li lum Sodoma ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jech chacalboxuc ava'yic. C'alal tsta sc'ac'alil ta xchapanatic yu'un Dios li cristianoetique, ja' jutuc castigo ta xich'ic li cristianoetic tey ta Sodoma ta vo'onee. Ja' tsots castigo ta xich'ic li jchi'iltactic tey nacajtic ta Capernaum ta ora le'e ―xut cristianoetic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jech lic sc'opan Dios li Jesuse: ―Tati, vo'ot yajvalot li vinajel banamile. Colaval ti muc xavac'be ya'yic smelol c'usi laj cal xchi'uc c'usi la jpas li boch'otic bijique xchi'uc li boch'otic lec sna' yalojique. Ja' no'ox laj avac'be ya'yic smelol li boch'otic tsc'anic coltael jech chac c'u cha'al ololetique. ");
INSERT INTO tzotze_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tati, lec oy ti jech la sc'an avo'ntone ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Li Jesuse lic sc'opan yan velta li jchi'iltactic ta israelale, jech laj yalbe: ―Scotol yac'ojbun ta jc'ob li Jtote. Vu'un li Xnich'onune mu'yuc boch'o sna'bun c'u x'elan co'nton. Ja' no'ox stuc Jtot sna' c'u x'elan co'nton. Ja' no'ox jech ec li Jtote, mu'yuc boch'o sna'be c'u x'elan yo'nton. Vu'un no'ox jna'be c'u x'elan yo'nton li Jtote, xchi'uc ta sna'ic ec li boch'otic ta xcac'be sna'ique. ");
INSERT INTO tzotze_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La'ic ta jtojol acotolic, vo'oxuc ti oy lubel chava'yic ta sventa ti chasa'ilanic c'u x'elan lec cha'ilatic yu'un Diose. Vu'un ta xcac' acux avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ac' abaic ta ventainel cu'un. Ja' chanic c'u x'elan co'nton yu'un toj lec co'nton, mu jna' jtoy jba. Me jech chapasique, jech cux xi avo'ntonic yu'un chana'ic ti lec chayiloxuc Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ti laj calboxuc ti chavac' abaic ta ventainel cu'une, mu'yuc tsots ta ch'unel. Xchi'uc mu vocoluc ta pasel chava'yic li c'usitic ta jc'ane ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tey lijelovcutic ta be ta trigoaltic xchi'uc li Jesuse. Ja' o sc'ac'alil ta jcux co'ntontic. Tey livi'najcutic, vu'uncutic li yajchanc'opuncutique. Jech tey la jc'ascutic jaylicuc trigo, la ju' jc'uxcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tey laj yiluncutic jayibuc fariseoetic, jech lic yalbeic li Jesuse: ―Q'uelavil, li avajchanc'optaque ta spasic c'usi mu stac' jpastic ta sc'ac'alil ta jcux co'ntontic ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Itac'ov li Jesuse: ―Aq'uelojic ta sc'op Dios c'usi la spas David ti c'alal ivi'najic xchi'uc xchi'iltac ta xanubale. ");
INSERT INTO tzotze_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tey ic'otic ta templo. Li Davide ja' la sve' li pan tey oy ta ba mesa ta stojol Diose. Ac'o me yaloj Dios ti ja' no'ox xu' ta sve'ic li paleetique, pero la sve'ic xchi'uc xchi'iltac li Davide. Pero mu'yuc la sta smul ti jech la spase. ");
INSERT INTO tzotze_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Vo'oxuque aq'uelojic li sc'op Dios ti la sts'iba Moisés ta vo'onee. Chal ti tey ono'ox ta x'abtejic ta templo ta sc'ac'alil ta jcux co'ntontic li paleetique. Pero mu'yuc ta sta smulic ti jech ta spasique. ");
INSERT INTO tzotze_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Li paleetique xu' ta x'abtejic ta templo ti c'alal ja' o sc'ac'alil ta jcux co'ntontique. Ja' no'ox jech xu' ta sc'asic jutuc trigo xc'uxic li cajchanc'optaque. Yu'un li vu'une tsots cabtel quich'oj; ja' mu tsotsuc yabtel laj yich' li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mu xava'ibeic smelol c'usi laj yal li Diose. Jech laj yal: “Ja' ta jc'an ti chac'uxubinvanique. Ma'uc no'ox ta jc'an ti chamilbicun jmotone”, xi. Ti ava'ibicuc smelole, muc xatic'beic smul li boch'otic mu'yuc smul ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Vu'un ti co'ol cristianoutique, vu'un yajvalun li sc'ac'alil ta jcux co'ntontique. Vu'un chcal li c'usitic stac' pasele ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ijelov batel li Jesuse. Tey li'ochcutic ta nail tsobobbail yu'un li jchi'iltactic ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tey oy jun jchi'iltic xmoch'oj sba sbic'tal jun sc'ob. Tey lic sjac'beic Jesús jayibuc fariseoetic: ―¿Me xu' chijcoltavan ta sc'ac'alil ta jcux co'ntontique? ―xiic yu'un tsc'an ta sa'beic smul li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Itac'ov li Jesuse: ―Li vo'oxuque, me oy achijic ibalch'uj yalel ta yut vomlum ta sc'ac'alil ta jcux co'ntontique, ¿me mu chbat aloq'uesic tal? ");
INSERT INTO tzotze_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero li jcot chije mu tsotsuc sc'oplal. Ja' tsots sc'oplal jun cristiano. Jech xu' ta jpastic c'usi lec ta sc'ac'alil ta jcux co'ntontic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Li Jesuse jech laj yalbe li vinique: ―Va'ano lec li sbic'tal ac'obe ―xut. Jech la sva'an lec li sbic'tal sc'obe, ta ora icol o. Lec xa icom jech chac c'u cha'al li jun sc'obe. ");
INSERT INTO tzotze_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iloq'uic batel li fariseoetique, bat xchapanic c'u x'elan xu' ta smilic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Li Jesuse la sna' li c'usi tsnopique, jech iloc' batel. Tey ichi'inat batel yu'un ep jchameletic, scotol icol yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Li Jesuse tsots laj yalbe batel mantal: ―Mu me xapucbicun batel jc'oplal ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jech ic'ot o ti jech ono'ox laj yal j'alc'op Isaías ta vo'one ti ja' chcoltavan li Jesuse. Yu'un ich'amanbat ye yu'un Dios. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Q'uelavil li boch'o cac'ojbe yabtele, ja' ti t'ujbil ono'ox cu'une. Lec c'ux ta co'nton. Xcuxet no'ox co'nton yu'un. Ta xcac'be yich' li Ch'ul Espíritu cu'une. Cac'ojbe yabtel ti xu' ta xcolic ta sventa ec li boch'otic muc ja'uc israeletique. ");
INSERT INTO tzotze_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mu xut sbaic xchi'uc yantic, mu xac' sba ta ich'el ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mu yu'unuc ja' ta xchibajesbe yo'nton li boch'otic mu'yuc stu cha'yic ti jechic jech chac c'u cha'al jbej aj ti oy bu voch'eme, o me jech chac c'u cha'al candil ti mu stsan leque. Ja' no'ox yabtel ta scolta jech ta xcuxiic o sbatel osil. Jech mu xbat yich'ic o castigo. ");
INSERT INTO tzotze_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Li boch'otic muc ja'uc israeletique ja' ta xilic ti xu' ta xcolic ec ta sventa li boch'o cac'ojbe yabtele, xi li Diose, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tey ic'bil ital ta stojol Jesús jun jchi'iltic ochem pucuj ta yo'nton. Ja' ma'sat xchi'uc uma' noxtoc. Icol yu'un li Jesuse. Ic'opoj xchi'uc ijam sat. ");
INSERT INTO tzotze_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Toj ch'ayel ic'ot yo'ntonic li epal cristianoetique. Jech laj yalbe sbaic: ―¿Me mu ja'uc xana' li smomnich'on David ti sc'oplal ono'ox ch‑och ta ajvalilal cu'untique? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","C'alal laj ya'yic li fariseoetique, jech laj yalic: ―Li vinic li'i ta svu'el banquilal pucuj ta sloq'ues pucujetic ta yo'nton cristianoetic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Li Jesuse la sna' li c'usi la snop ta yo'ntonique. Jech laj yalbe: ―Me ta scontrain sbaic jun ajvalil xchi'uc xchi'iltac ta abtele, tey ta soquic o. Me ta scontrain sbaic yajvaltac jun nae, xchi'uc me ta scontrain sbaic yajvaltac jun lume, ta soquic o noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ja' no'ox jech ec li Satanase, me ta sloq'ues xchi'ile, mu xu' yu'un ta spas mantal me jech ta spase. ");
INSERT INTO tzotze_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ti ja'uc ta svu'el banquilal pucuj ta jloq'ues pucujetic jech chac c'u cha'al chavalique, ¿boch'o ta scoj ta sloq'uesic pucujetic ec li avajchanc'optaquique? Li avajchanc'optaquique xu' chalic ti mu meleluc c'usi chavalique. ");
INSERT INTO tzotze_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Li vu'une ta sventa Ch'ul Espíritu ta jloq'ues li pucujetique, jech ta xvinaj o ti li' tspas mantal ta atojolic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Li boch'o tsc'an ta x'och ta sna jun tsatsal vinic yu'un tsc'an ta xelc'anbe c'usitic oy yu'une, ta persa ba'yuc ta xchuc li tsatsal vinique, ja' to jech xu' yu'un ta xelc'anbe batel li c'usitic oy yu'une. Li Satanase ja' jech chac c'u cha'al li tsatsal vinique. Pero laj xa jtsal. Yu'un laj xa jpojbe li vinic ti tey to'ox oy ta sc'obe. ");
INSERT INTO tzotze_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Boch'o mu'yuc lec chil c'usi ta jpase, yu'un xa chiscontrainun o. ");
INSERT INTO tzotze_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Jech chacalboxuc, li boch'otic chopol c'usitic ta spasique, xchi'uc me chopol chc'opojic ta stojol Diose, ta to spasbatic perdón yu'un Dios me tsc'anique. Yan li boch'o chopol chc'opoj ta stojol Ch'ul Espíritue mu'yuc ono'ox ta spasbat perdón. ");
INSERT INTO tzotze_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Boch'o chopol chc'opoj ta jtojol, vu'un ti co'ol cristianoutique, ta to spasbatic perdón ti me tsc'anique. Ja' no'ox li boch'o chopol chc'opoj ta stojol Ch'ul Espíritue mu'yuc ta spasbatic o perdón sbatel osil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jech laj yalbe noxtoc li Jesuse: ―Ta sventa c'u x'elan sat li te'e, jech ta jna'tic o me lec o me chopol. Me lec sts'unubal li te'e, lec sat chac'. Me chopol sts'unubal li te'e, chopol sat chac'. Jech nopo ava'yic c'u x'elan ats'unubalic ta sventa ti mu'yuc lec chavilicune yu'un puro lec li c'usitic ta jpase. ");
INSERT INTO tzotze_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Li vo'oxuque ja' achi'ilic orachon yu'un chopol avo'ntonic. Jech mu xu' lec chac'opojic. Yu'un li c'usi oy ta avo'ntonique ja' jech chloc' ta aveic. ");
INSERT INTO tzotze_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Boch'o lec yo'ntone ja' no'ox jech lec c'usi chloc' ta ye yu'un lec li c'usi snopoj ta yo'ntone. Yan li boch'o chopol c'usi snopoj ta yo'ntone, ja' jech chloc' tal ta ye li c'usi snopoje. ");
INSERT INTO tzotze_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jech chacalboxuc, ti c'u yepal laj anopbe smul achi'ilique ta ono'ox xc'ot avich'ic jac'bel ti c'alal tsta yorail ta xchapan scotol cristianoetic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta sventa c'u x'elan lalo'ilajic li' ta banamil ti jech lec chayiloxuc Diose. Jech noxtoc ta sventa c'u x'elan lalo'ilajic ti jech chavich'ic o castigoe ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tey oyic jayibuc fariseoetic xchi'uc jchanubtasvanejetic ta smantal Dios yalojic. Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, ac'bun quilcutic senyail ti scotol xu' avu'une yu'un jech ta jna'cutic o ti vo'ot tsots avabtele ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Itac'ov li Jesuse: ―Li boch'otic chopol yo'ntonic ti mu junuc yo'ntonic ta stojol Diose, tsc'an ta sq'uelic senyail ti scotol xu' cu'une. Pero mu'yuc ta x'ac'bat yilic. Ja' no'ox ta x'ac'bat yilic jech chac c'u cha'al ic'ot ta pasel ta stojol li Jonase, ja' li yaj'alc'op Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jech chac c'u cha'al tey tiq'uil ta yut xch'ut muc'ta choy oxib c'ac'al xchi'uc oxib ac'ubal li Jonase, ja' no'ox jech ec li vu'une, oxib c'ac'al xchi'uc oxib ac'ubal ta ximucat, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","C'alal tsta yorail ta xchapanatic scotol cristianoetique, ja' mu'yuc smul ta x'ilatic yu'un Dios li cristianoetic tey nacajtic ta lum Nínive ta vo'onee. Yan vo'oxuc ti li' to oyoxuc ta banamile, ep amul cha'ilatic. Yu'un c'alal ay yich'ic cholbel sc'op Dios yu'un Jonás li cristianoetic tey ta Nínivee, ta ora la scomtsan li c'usitic chopol ta spasique. Li Jonase mu tsotsuc yabtel laj yich'. Vu'un tsots cabtel quich'oj ti li'oyun ta atojolique. Pero mu xavich'ic ta muc' li c'usi ta xcale. ");
INSERT INTO tzotze_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Oy to'ox jun ants ta vo'one yan o slumal. Tey ochem ta ajvalilal ta jun lum ta xocon vinajel ta Sur. Mu'yuc smul ta x'ilat yu'un Dios c'alal tsta yorail ta xchapanatic scotol li cristianoetique. Yan vo'oxuc ti li' to oyoxuc ta banamile, ep amul cha'ilatic. Yu'un li antse nom ital, tal ya'ibe sc'op li Salomone yu'un laj ya'i ti lec bije. Pero li Salomone mu tsotsuc yabtel laj yich'. Vu'un ti li' oyun ta atojolique, más to ech'em jbijil, pero mu xavich'icun ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Vo'oxuc ti li' to oyoxuc ta banamile, más to chopol chabatic ta scoj ti mu xavich'icun ta muq'ue. Ja' jech chac c'u cha'al jun vinic ti iloc' pucuj ta yo'ntone. Li pucuje ibat ta xocol banamil, bat sa' bu ta xcux yo'nton, pero muc sta. ");
INSERT INTO tzotze_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jech lic yal ta yo'nton: “Ja' lec ta xisut batel yan velta ta yo'nton li vinique”, xi. C'alal ic'ote, xocol c'ot sta ti bu ono'ox iloc' tale yu'un mu'yuc yac'oj sba ta ventainel yu'un Dios li vinique. Ja' no'ox slecubtasoj jutuc sba stuc. ");
INSERT INTO tzotze_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jech bat sa' tal yan vucub xchi'iltac li pucuje, ja' ti bu toj chopolique. Scotol tal ochicuc ta yo'nton li vinique. Tey inaquiic o. Li vinique más to isoc o ta jyalel. Ja' lec to'ox jutuc ti c'alal mu'yuc to'ox loq'uem batel li jun pucuje. Ja' no'ox jech chapasbatic ec, vo'oxuc ti li' to oyoxuc ta banamile, yu'un mu xac'an xavich'icun ta muc' ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","C'alal ja' o chlo'ilaj xchi'uc jchi'iltactic li Jesuse, tey ivulic ta amac' sme' xchi'uc yits'inabtac. Yu'un tsc'an ta sc'opanic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oy jun boch'o tal yalbe li Jesuse: ―Tey oyic ta amac' ame' xchi'uc avits'inabtac yu'un tsc'an ta sc'opanicot ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Itac'ov li Jesuse: ―Ta melel ja' jme', ja' quits'inabtac ti tey oyique. Pero ja' más tsots sc'oplal chca'i li boch'o ta spasic c'usi ta sc'an yo'nton li Jtot tey oy ta vinajele. Ja' jchi'iltac ta voq'uel xchi'uc ja' jme' chc'otic o ―xut. Li Jesuse la xbechc'obtauncutic, vu'uncutic li yajchanc'opuncutique. Jech laj yal: ―Q'uelavil ti jayibic li'oyique, ja' jme', ja' jchi'iltac ta voq'uel c'otemic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Li Jesuse iloc' ta na. Ts'acal tey bat chotluc ta ti'nab. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Toj ep jchi'iltactic la stsob sbaic tal jech i'och ta canova tey ta ba vo' li Jesuse. Tey ichoti. Yan li jchi'iltactique tey oyic ta ti'nab scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Li Jesuse lic sc'opan. Oy ep c'usi la sloc'tabe ta lo'il. Jech laj yal: ―Oy iloc' batel jts'untrigo. ");
INSERT INTO tzotze_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","C'alal la svij li strigoe, oy jaybej ic'ot ta be. Tey ital mutetic la sbiq'uic batel. ");
INSERT INTO tzotze_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oy jaybej ic'ot ta tontic ti bu mu'yuc pim slumale. Ta ora ijulij yu'un mu'yuc pim slumal. ");
INSERT INTO tzotze_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","C'alal iq'uepe, ic'anub, tey itaquij o yu'un mu'yuc nat yalem yisim. ");
INSERT INTO tzotze_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oy jaybej ic'ot ta ch'ixtic. C'alal ich'i li ch'ixe, inet'at jech tey ic'oxib o. ");
INSERT INTO tzotze_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oy jaybej ic'ot ta lequil banamil. Ja' lec laj yac' sat. Oy laj yac' vo'vinic ta bej, oy laj yac' oxvinic ta bej, oy laj yac' lajuneb xcha'vinic ta bej. ");
INSERT INTO tzotze_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Boch'o laj ya'i ac'o snopbe lec smelol ―x'utatic yu'un Jesús. ");
INSERT INTO tzotze_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vu'uncutic li yajchanc'opuncutique jtuccutic xa jech la jac'becutic li Jesuse: ―¿C'u yu'un ti ta lo'il no'ox chac'opan li jchi'iltactique? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Itac'ov li Jesuse: ―Li vo'oxuque ac'biloxuc ana'ic c'u x'elan tsventainanbe yo'nton cristianoetic li Diose, pero li yantique mu x'ac'bat sna'ic jech chac c'u cha'al li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yu'un li boch'otic jutuc to xch'unojique, li Diose más to ech'em chac'be xch'un yu'un tsc'an ta xch'unic. Jech más to ech'em chlic sna'ic. Yan li boch'otic mu sc'an xch'unique, ti c'u yepal sna'ic jutuque ta xpojbatic sutel. ");
INSERT INTO tzotze_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jech ja' no'ox ta jloc'tabe ta lo'il. Yu'un altic ti ep ta velta laj yilic ti scotol xu' cu'une, mu sc'an xch'unic. Altic ti ep ta velta laj ya'yic c'usi laj cale, mu xa'ibeic smelol yu'un mu ono'ox sc'an xa'yic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jech ic'ot o c'usi la sts'iba li j'alc'op Isaías ta vo'onee: Chava'yilanic pero mu xava'ibeic smelol. Chavililanic pero mu xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yu'un atsatsubtasoj avo'ntonic jech mu xu' chach'unic o. Yu'un mu ono'ox xac'an xach'unic li c'usi chava'yique xchi'uc li c'usi chavilique, jech mu xava'ibeic o smelol. Yu'un mu ono'ox xac'an xacomtsanic li c'usitic chopol chapasique jech mu xacolic cu'un, xi li Diose, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Vo'oxuc li cajchanc'optacoxuque laj xa xc'uxubinoxuc li Diose jech chac'an chava'ibeic smelol li c'usi chcale xchi'uc li c'usi ta jpase. ");
INSERT INTO tzotze_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Melel li c'usi chacalboxuque, ep yaj'alc'optac Dios ta vo'one xchi'uc li boch'otic tuc' yo'ntonique tsc'an chilic ec li c'usi chavilique pero muc xilic. Tsc'an cha'yic ec li c'usi chava'yique pero muc xa'yic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’A'ibeic me smelol li lo'il laj calboxuc ta sventa jts'untrigoe. ");
INSERT INTO tzotze_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","C'alal cha'yic cristianoetic ti tsc'an chventainatic yu'un Diose, oy boch'o mu xa'ibeic lec smelol. Jech ta ora ta xtal li pucuje, chtal xch'aybe ta yo'ntonic. Ja' jech smelol li bec' trigo ic'ot ta bee. ");
INSERT INTO tzotze_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Li bec' trigo ic'ot ta tontique, ja' senyail li boch'otic ja' to no'ox laj ya'yic sc'op Diose, ta ora no'ox la xch'unic jech xcuxet no'ox yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero muc xac' yisim ta yo'ntonic ya'yel yu'un mu'yuc stsatsal yo'ntonic. C'alal ta xich'ic vocol ta sventa ti cha'yic sc'op Diose, toj chibajel chc'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Li bec' trigo ic'ot ta ch'ixtique, ja' senyail li boch'tic ya'yojic sc'op Dios ti ja' no'ox batem yo'ntonic yu'un li c'usitic oy li' ta banamile. Ja' tey lo'labilic o yu'un li c'usi tsc'an yo'ntonique. Jech tey net'bil ic'ot o li sc'op Dios ya'yojique. Jech mu xch'unic o. ");
INSERT INTO tzotze_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Li bec' trigo ic'ot ta lequil banamile, ja' senyail li boch'otic chc'ot lec ta yo'ntonic li sc'op Diose, ti lec cha'ibeic smelole. Tey tsatin lec ta yo'ntonic. Oy ta xac' vo'vinic sat, oy ta xac' oxvinic sat, oy ta xac' lajuneb xcha'vinic sat ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Li Jesuse laj yal yan lo'il noxtoc. Jech laj yal: ―Chacalboxuc ava'yic c'u x'elan tspas mantal Dios ta stojol li boch'otic ta xch'unique. Ja' jech chac c'u cha'al jun vinic bat sts'un strigo ta yosil. ");
INSERT INTO tzotze_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","C'alal vayemic xa'ox scotolique, ta ac'ubaltic ital yajcontra. Tal sts'un trigo jobel tey yo' bu la sts'un li strigoe. C'alal la sts'un comel bec' trigo jobel li yajcontrae, isut batel. ");
INSERT INTO tzotze_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","C'alal ich'i li trigoe, laj yac' sat. Ja' to tey ivinaj li trigo jobele. ");
INSERT INTO tzotze_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Li smozotac yajval osile jech la sjac'beic: “Cajval, ¿me muc puro bats'i trigouc ti laj ats'un ta avosile? Le' ta orae laj xa quilcutic ti capal xchi'uc trigo jobele”, xi li smozotaque. ");
INSERT INTO tzotze_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Itac'ov li yajval osile: “Le'e ja' cajcontra la sts'un”, xi. Li smozotaque jech laj yalic: “¿Me chac'an chbat jbulcutic loq'uel li trigo jobele?” xut li yajvalique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Itac'ov li yajval osile: “Mo'oj, mu xbat abulic naca me tey capal ta xbul loq'uel li lequil trigoe. ");
INSERT INTO tzotze_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tey jmoj ac'o ch'iuc xcha'chopal c'alal to tsta yorail ta xich' tuch'ele. C'alal ta xa xich' tuch'ele, jech ta xcalbe li jtuch'trigoetic cu'une: Tsobic ba'yuc li trigo jobele. Chuquic lec ta jujuchuc yu'un ta xich' chiq'uel. Ja' ts'acal xatsobic li jtrigoe, xatiq'uic ochel ta snail cu'un, xcut”, xi li yajval osile ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Laj yal yan lo'il li Jesuse. Jech laj yalbe li jchi'iltactique: ―Chacalboxuc ava'yic yan velta c'u x'elan tsventainan cristianoetic li Diose. Ac'o me mu'yuc ep boch'o tsventain ta ora pero ts'acal chlic epajuc. Ja' jech chac c'u cha'al bec' mostaza la sts'un ta yosil jun vinic pero nat ibat. ");
INSERT INTO tzotze_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Li bec' mostazae toj biq'uit; li c'usitic yan sbeq'ue ja' muc'tic. Pero c'alal me ich'i li bec' mostazae, ja' nat chbat; ja' biq'uitic chc'ot li yan ts'unubiletique. Li mostazae nat chbat, ep chac' sc'ob noxtoc. Jech chtal mutetic, chtal spas stasic ta sc'obc'ob ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Laj yal yan lo'il li Jesuse. Jech laj yal: ―Ta xcalboxuc ava'yic c'u x'elan tsventainan cristianoetic li Diose. Oy lec stsatsal jech chac c'u cha'al svolesubil xch'ut pan. Ac'o me jutuc no'ox chac' ta vucub cuartiya arina li antse, pero lec chvol o xch'ut scotol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Li Jesuse ta lo'iletic no'ox la sc'opan li jchi'iltactique. Pero oy smelol li c'usitic laj yale. ");
INSERT INTO tzotze_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yu'un ja' ic'ot o c'usi laj yal li yaj'alc'op Dios ta vo'onee. Jech laj yal: Puro ta lo'il no'ox ta sc'opan li cristianoetique. Ja' ta xal li c'usitic mu'yuc ya'yojic c'alal imeltsaj li banamile xchi'uc c'alal to tanae, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Li Jesuse la sc'opan comel li jchi'iltactique, i'och ta yut na. La jchi'incutic ochel, vu'uncutic li yajchanc'opuncutique. Jech lic jac'becutic: ―Albun ca'icutic c'usi smelol li lo'il sventa trigo jobel laj avale ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jech lic yalbuncutic li Jesuse: ―Li bats'i trigoe vu'un ta jts'un, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Li cosile ja' scotol li banamile. Li bats'i trigoe ja' li boch'otic chac' sbaic ta ventainel yu'un Diose. Yan li trigo jobele ja' li boch'otic chopol c'usitic tspasique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Li cajcontra ti la sts'un trigo jobele, ja' li banquilal pucuje. Li yorail ta xich' tuch'ele ja' li slajebal c'ac'ale. Li jtuch'trigoetique ja' li j'almantaletique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jech chac c'u cha'al la stsobic li trigo jobele ti la xchiq'uique, ja' jech ta xc'ot ta pasel ta slajebal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Vu'un ti co'ol cristianoutique ta jtac tal caj'almantaltac. Ja' ta xtal stsobic scotol li boch'otic ta socbe yo'nton xchi'ilique xchi'uc li boch'otic chopol c'usitic ta spasique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ja' ta sjipic ochel ta c'oc'. Tey chc'ot yoc'ta sbaic, tey xc'uxet o yeic ta scoj ti tsots castigo chich'ique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yan li boch'otic tuc' yo'ntonique ta xac' xojobalic ti c'alal tey xa oyic yo' bu tspas mantal li Jtotique yu'un ja' xnich'nab. Li xojobalique ja' jech chac c'u cha'al xojobal c'ac'al. Boch'o laj ya'i ac'o snopbe lec smelol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jech laj yal noxtoc li Jesuse: ―Ti c'u x'elan chventainvan li Diose, ja' jech chac c'u cha'al epal taq'uin mucul ta juteb banamil. Oy jun vinic la sta, tey la smuc comel yan velta. Xcuxet no'ox yo'nton jech bat xchon scotol li c'usitic oy yu'une, yu'un ja' tsots sc'oplal laj ya'i tsman li juteb banamil yo' bu mucul taq'uine. Ja' no'ox jech li vo'oxuque, tsc'an ti ja' tsots sc'oplal chava'yic chac'anic ventainel yu'un li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jech laj yal noxtoc li Jesuse: ―Ti c'u x'elan chventainvan li Diose ja' jech chac c'u cha'al nats'il ti lec c'upil sbae ti ja' tsa' li boch'o chmanulaje. ");
INSERT INTO tzotze_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","C'alal laj xa sta li nats'il ti bu toyol stojole, bat xchon scotol li c'usitic oy yu'une, yu'un ja' tsots sc'oplal laj ya'i tsman li nats'ile ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jech laj yal yan velta noxtoc li Jesuse: ―Ti c'u x'elan ta spas mantal Dios ta stojol li boch'otic xch'unojique, ja' jech chac c'u cha'al jtsacchoyetic ti ta stic' ochel snuti'ic ta yut nabe. Tey ta x'och tal ep ta chop choyetic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","C'alal inoj li snuti'ique, ta sloq'uesic tal ta ti'nab. Tey ta xchotiic, ta st'ujic ti bu lequique, ta stiq'uic ochel ta moch. Yan ti bu chopolique ja' ta sjipic batel. ");
INSERT INTO tzotze_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ja' jech ta xc'ot ta pasel ta slajebal c'ac'al. Ta xtal li j'almantaletique, ja' chtal svoq'uic li boch'otic chopol yo'ntonique xchi'uc li boch'otic lec yo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta xjipatic ochel ta c'oc' li boch'otic chopol yo'ntonique. Tey ta xc'ot yoc'ta sbaic, tey xc'uxet o yeic ta scoj ti tsots castigo chich'ique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Li Jesuse jech la sjac'buncutic: ―¿Me laj ava'ibeic smelol scotol li c'usi laj cale? ―xi. Jech la jtac'becutic: ―Laj ca'icutic, Cajval ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jech laj yalbuncutic noxtoc: ―Lec ti laj ava'ibeic smelole. Yu'un li vo'oxuque ava'yojic ono'ox c'usitic i'albatic yu'un Dios li jmoltotactic ta vo'onee. Li' ta orae laj xa ava'yic noxtoc ti c'u x'elan chasventainoxuc li Diose. Ja' jechoxuc jech chac c'u cha'al jun yajval na ti oy yu'un scotol li c'usitic chtun yu'une. Yu'un ja' yich'ojbe comel li c'usitic oy yu'un ánima stote pero laj xa sa' yan stuc ec. Tey xa oy ta sna scotol li c'usitic chtun yu'une ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","C'alal ilaj yo'nton ta lo'il li Jesuse, iloc' batel. ");
INSERT INTO tzotze_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Isut batel ta slumal, ja' li Nazarete. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Tey ichanubtasvan ta nail tsobobbail yu'un li jchi'iltactic ta israelale. Li boch'otic laj ya'yique toj ch'ayel ic'ot yo'ntonic. Jech laj yalbe sbaic: ―¿Bu la sta sbijil li jchi'iltic li'i? ¿C'uxi xu' yu'un ta spas sq'uelubiltac ti scotol xu' yu'une? ");
INSERT INTO tzotze_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ja' xnich'on li carpinteroe. Ja' yol li Maríae. Ja' yits'in li Jacoboe, xchi'uc li Josée, xchi'uc li Simone, xchi'uc li Judase. ");
INSERT INTO tzotze_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ja' yixlaltac noxtoc ti li' jchi'uctic ta nacleje. ¿Bu la xchan scotol ti jech ta spase? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jech mu'yuc la xch'unic o ti ja' ac'bil yabtel yu'un Diose. Li Jesuse jech laj yalbe li cristianoetique: ―Buyuc no'ox ta xbatic li yaj'alc'optac Diose ta x'ich'atic ta muc'. Pero ta yosilal stuque xchi'uc ta sna stuque mu x'ich'at ta muc' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jech mu'yuc ep la spas sq'uelubil stsatsal tey ta slumal li Jesuse yu'un mu xch'unic ti ja' ac'bil yabtel yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Li muc'ta ajvalil Erodes sbie ja' o yorail laj ya'i scotol c'usitic la spas li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jech laj yalbe li xchi'iltac ta abtele: ―Le'e ja' li Juan j'ac'vanej ta vo'e. Yu'un icha'cuxesat jech oy stsatsal ta spas li c'usitic ta spase ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yu'un li Erodese ja' ono'ox la stac ta tsaquel li Juane, laj yal mantal ti ac'o chucatuc ta cadena ta yut chuquinab ta scoj li Erodíase, ja' li yajnil to'ox Felipee, ja' yits'in li Erodese. ");
INSERT INTO tzotze_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yu'un jech i'albat yu'un li Juane: “Mu jechuc yaloj Dios ti laj apojbe yajnil avits'ine”, x'utat. ");
INSERT INTO tzotze_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ja' yu'un li Erodese tsc'an ox ta smil ta ora li Juane pero ixi' yu'un li jchi'iltactic ta israelale, yu'un xch'unojic ti ja' yaj'alc'op Dios li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ts'acal to la spasic q'uin sventa bu ora ivoc' li Erodese. Li stseb Erodíase tey lic ac'otajuc ta stojol scotol li boch'otic tey oyique. Li Erodese toj lec laj yil. ");
INSERT INTO tzotze_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jech laj yalbe li tsebe: ―C'anbun c'usiuc no'ox chac'an. Yiloj Dios ti chacac'bote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Li tsebe la sjac'be li sme'e jech i'albat yu'un sme' li c'usi tsc'anbee. Li tsebe jech laj yalbe li Erodese: ―Ac'bun tal ta plato sjol li Juan j'ac'vanej ta vo'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","C'alal laj ya'i li Erodese, chopol laj ya'i. Pero ta scoj ti ep ta velta laj yalbe li tsebe xchi'uc tey laj ya'yic li boch'otic tey co'ol ive'ic xchi'uc ta mesae, jech laj yal ti xu' chich'be batel sjol li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jech la stac batel yajsoldadotac yu'un ac'o bat sc'ocbe tal sjol li Juan tey tiq'uil ta chuquele. ");
INSERT INTO tzotze_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","La xlechanic tal ta jun plato, laj yac'beic li tsebe. Li tsebe bat yac'be li sme'e. ");
INSERT INTO tzotze_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Italic yajchanc'optac li Juane, laj yich'beic batel li sbec'tale, bat smuquic. Tey ital yalbeic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","C'alal laj ya'i Jesús c'usi laj yalbe xchi'iltac ta abtel li Erodese, i'och ta canova, ibat ta xocol banamil. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. C'alal laj ya'yic li jchi'iltactic ta israelale, ep ta lum bu iliquic batel yu'un tal staic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","C'alal liloc'cutic ta canovae, laj quilcutic ti bats'i ep jchi'iltactic tey stsoboj sbaique. Li Jesuse la xc'uxubinan, la scoltaan scotol li jchameletic tey xchi'uquic tale. ");
INSERT INTO tzotze_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","C'alal bat xa c'ac'ale, la jc'opancutic Jesús vu'uncutic li yajchanc'opuncutique. Jech laj calbecutic: ―Xocol banamil li'i. Bat xa li c'ac'ale. Ja' lec taco batel li cristianoetique ac'o bat sman sve'elic ta tsobtsobnaetic ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Itac'ov li Jesuse: ―Mu persauc ta xbatic. Ac'beic sve'el vo'oxuc ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jech la jtac'becutic: ―Mu'yuc c'usi oy cu'uncutic. Ja' no'ox vo'ob pan xchi'uc cha'cot choy li' quich'ojcutic ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Itac'ov li Jesuse: ―Ich'ic tal ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Li Jesuse laj yalbe mantal cristianoetic ti ac'o chotiicuc ta c'unil jobeltique. Li Jesuse la stsac li vo'ob pane xchi'uc li cha'cot choye. La sq'uel muyel vinajel, la stojbe ta vocol Dios. La svoc' li pane xchi'uc li choye. Laj yac'buncutic, vu'uncutic li yajchanc'opuncutique. La jpucbecutic scotol li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Scotolic ive'ic, inojic o. La jtsobcutic scomelal li pane xchi'uc scomelal li choye. Inoj lajcha'moch. ");
INSERT INTO tzotze_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ti c'u yepal ive'ique, oy van vo'miluc viniquetic. Ja' slecoj li antsetique xchi'uc li ololetique, mu'yuc atbil. ");
INSERT INTO tzotze_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Li Jesuse ta ora laj yalbuncutic ti ta xi'ochcutic ta tenalte' canovae yu'un ba'yuc chijelovcutic ta jot nab. Li Jesuse tey to icom. Jech stuc xa la sc'opan comel li jchi'iltactique. ");
INSERT INTO tzotze_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","C'alal la sc'opan comel li jchi'iltactique, imuy batel ta vits, bat sc'opan Dios. C'alal i'ic'ub osile, stuc tey oy o ta vits li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Li vu'uncutique ta o'lol nab xa'ox xi'ech'cutic. Toj tsots li iq'ue xyuc'lajet no'ox li nabe. Toj vocol ta xanov batel li canovae yu'un ta snup sbaic xchi'uc li iq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Po'ot xa ta sacub osil ital tey yo' bu oyuncutic li Jesuse. Laj quilcutic ta xanov tal ta yacan ta ba nab. ");
INSERT INTO tzotze_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","C'alal laj quilcutic ti ta ba nab ta xanov tale, toj xi'el lic'otcutic. La jnopcutic ti ja' ch'ulelale. Xi'avetcutic xa yu'un toj ech'em lixi'cutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ta ora ic'opoj li Jesuse, jech laj yalbuncutic: ―Mu me xaxi'ic, vu'un Jesusun. Tsatsubtaso avo'ntonic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Itac'ov li Pedroe: ―Cajval, me melel ti vo'ote, alo mantal ti xu' chixanov tal ta ba nab eq'ue yu'un chital tey yo' bu oyote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Itac'ov li Jesuse: ―La' me ―xi. Jech iloc' ta canova li Pedroe, ixanov batel ta ba nab yu'un chbat sta li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero c'alal laj ya'i ti toj tsots li iq'ue, ixi'. C'an xa ochuc yalel ta yut nab. Jech laj yapta li Jesuse: ―Cajval, coltaun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Li Jesuse ta ora la stsacbe sc'ob li Pedroe. Jech laj yalbe: ―¿C'u yu'un chaxi'? Yu'un mu'yuc to ach'unoj ti vu'un ta jcoltaote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","C'alal i'ochic xa ta yut canovae, ich'abi li iq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Vu'uncutic ti tey oyuncutic ta yut canovae laj quich'cutic ta muc' li Jesuse. Jech laj calbecutic: ―Ta melel vo'ot Xnich'onot li Diose ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","C'alal lic'otcutic ta jot nabe, tey liloc'cutic ta canova ta jun banamil Genesaret sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Li jchi'iltactic ta israelal tey nacajtique laj yotquinic ti ja' Jesús tey ic'ote. Ta ora bat yalic ta scotol Genesaret ti ital xa li Jesuse. Tey laj yiq'uic tal ta stojol Jesús ep jchameletic. ");
INSERT INTO tzotze_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Oy la sc'anbeic Jesús ti ac'o me yoc sc'u' no'ox ta spicbeique. Li boch'otic la spicbeic yoc sc'u'e icolic ec. ");
INSERT INTO tzotze_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iloq'uic tal ta Jerusalén jayibuc fariseoetic xchi'uc jayibuc jchanubtasvanejetic ta smantal Dios yalojic. Tal sc'opanic li Jesuse, jech laj yalbeic: ");
INSERT INTO tzotze_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿C'u yu'un mu jechuc ta spasic avajchanc'optac jech chac c'u cha'al la spasic li moletic ta vo'onee? Yu'un mu jaluc ta spoc sc'obic c'alal ta xve'ique. Yan li moletic ta vo'onee jal la spoc sc'obic c'alal ive'ic yu'un jech lec ch‑ilatic yu'un Dios ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Itac'ov li Jesuse: ―Li vo'oxuque ja' avich'ojbeic stalel li moletic ta vo'onee, jech mu xach'unic o li smantal Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yu'un jech yaloj mantal li Diose: “Ich'o ta muc' atot ame'”, xi. “Li boch'o yan xich' xalbe stot sme'e ja' ta xmilat”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Pero li vo'oxuque lec chava'yic me jech chalbeic li stot sme'ique: “Ti c'u yepal ta jtailane laj xa cal ti chcac' ta sventa smoton Diose”, me xutique, li vo'oxuque lec chava'yic ti jech chalique. Chavalbeic ti xu' xa mu xc'uxubin o stot sme'ique. Ja' jech chacomtsanbeic o smantal Dios ta scoj ti ja' avich'ojbeic stalel li moletic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jlo'lavanejoxuc. Ja' ac'oplalic ti jech i'albat yu'un Dios li j'alc'op Isaías ta vo'onee: ");
INSERT INTO tzotze_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Li achi'iltaque chiyich'icun ta muc' ta yeic no'ox; solel mu'yucun ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Altic ta xalic ti chiyich'icun ta muq'ue. Ja' smantal no'ox cristiano ta xchanubtasvanic; muc ja'uc jc'op ti chaq'uic ta chanele, xi li Diose, xi ono'ox li Isaíase ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Li Jesuse lic sc'opan scotol li jchi'iltactique. Jech laj yalbe: ―A'yo ava'yic li c'usi chacalboxuque. A'ibeic lec smelol. ");
INSERT INTO tzotze_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Li c'usitic chave'ique mu ja'uc jech chopol chayiloxuc o li Diose. Ja' no'ox c'usitic chopol chloc' ta aveic ti jech chopol chayiloxuque ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Vu'uncutic li yajchanc'opuncutique linoch'ajcutic batel ta stojol li Jesuse, jtuccutic jech laj calbecutic: ―¿Me xana' ti mu lecuc laj ya'i fariseoetic ti jech laj avalbee? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Itac'ov li Jesuse: ―Li fariseoetique ja' jechic jech chac c'u cha'al ts'i'laletic. Li Jtot tey oy ta vinajele puro lequic scotol li c'usitic la sts'une. Yan li c'usitic muc ja'uc sts'unben li Jtote ja' ta xich' bulel. ");
INSERT INTO tzotze_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mu me xlo'ilaj avo'ntonic yu'un. Yu'un ja' jechic jech chac c'u cha'al ma'satetic ti tsc'an chac'beic yil be li xchi'ilic ta ma'satile. Pero me co'ol ma'satetic ta xic' sbaic batele, jech co'ol ta xbalch'ujic ochel ta yut vomlum ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jech laj yal li Pedroe: ―Albun ca'icutic c'usi smelol li lo'il laj avale ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Itac'ov li Jesuse: ―¿Me muc xava'ibeic smelol ec li vo'oxuque? ");
INSERT INTO tzotze_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Me mu xana'ic li c'usitic ta x'och ta aveique ta xbat ta ach'utic, ja' o ta xloc'? ");
INSERT INTO tzotze_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yan li c'usi ta xloc' ta aveique ja' ta yut avo'ntonic ta xlic tal. Jech chopol chayiloxuc o li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yu'un ta yut yo'nton cristiano ta xlic tal li c'usi chopol tsnope, me ta xmilvan, me ta xmulivaj, me ta x'elc'aj, me ta x'epalc'opoj, me ta slo'ilta xchi'il. ");
INSERT INTO tzotze_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Scotol li c'usitic chopol li'i, ja' chopol chayiloxuc o li Diose. Yan me ja' no'ox mu jaluc chapoc ac'obic c'alal chave'ique, mu ja'uc jech chopol chayiloxuc li Diose ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iloc' batel li Jesuse, la jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Tey libatcutic ta nopol chib lum Tiro xchi'uc Sidón. ");
INSERT INTO tzotze_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tey iloc' tal jun ants, ja' smoltot syame'tac ti tey to'ox nacalic ta Canán banamil ta vo'onee. Ac'o me mu ono'ox lecuc chquiltic li boch'otic muc ja'uc jchi'iltic ta israelale, pero li antse laj yapta li Jesuse: ―Cajval, vo'ot smomnich'onot David ti sc'oplal ono'ox cha'och ta ajvalilale, c'uxubinun yu'un ochem pucuj ta yo'nton jtseb. Toj ech'em ta xich' vocol ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Li Jesuse muc xtac'ov jbeluc. Vu'uncutic li yajchanc'opuncutique jech laj calbecutic li Jesuse: ―Avocoluc taco sutel li antse yu'un toj tsots ta xaptautic tal ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Li Jesuse jech la stac'be li antse: ―Vu'une ja' tacbilun tal ta sventa li jchi'iltac ta israelale yu'un ch'ayemic jech chac c'u cha'al chijetic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Li antse tal squejan sba ta stojol li Jesuse, jech laj yalbe: ―Tata, c'uxubinun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Itac'ov li Jesuse: ―Mu lecuc me ta jpojbetic yot li nich'naletique yu'un ta xcac'betic sve' unin ts'i'etic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Itac'ov li antse: ―Jech chaval, tata. Li vu'une ja' jechun jech chac c'u cha'al li unin ts'i'etique. Yan li achi'iltaque ja' jechic jech chac c'u cha'al li nich'naletique. Pero c'alal ta xve'ic li nich'naletique, oy ono'ox ta xbaj yalel xch'uch'ulil yotic ta yolon mesa. Ja' ta stam sve' li unin ts'i'etique. Jech li vu'une, c'uxubinun ―xi li antse. ");
INSERT INTO tzotze_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Li Jesuse jech la stac'be: ―Yaa, scotol avo'nton ach'unoj ti vu'un Jcoltavanejune. Ac'o c'otuc ta pasel li c'usi chac'ane ―xut. Jech ta ora iloc' pucuj ta yo'nton li stsebe. ");
INSERT INTO tzotze_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ijelov batel li Jesuse. Tey lixanovcutic batel ta ti'ti' nab ta Galilea banamil. Tey limuycutic batel ta vits, tey c'ot chotlicuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tey la stsob sbaic tal ta stojol Jesús bats'i ep jchi'iltactic. Laj yiq'uic tal coxoetic, xchi'uc ma'satetic, xchi'uc uma'etic, xchi'uc boch'otic motajtic sc'obic, xchi'uc yan ep jchameletic. Tey vul xpuch'anic ta stojol li Jesuse. Scotol icol yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Li jchi'iltactique toj ch'ayel ic'ot yo'ntonic ti c'alal laj yilic ijam ye li uma'etique, xchi'uc ti ilecub sc'obic li boch'otic mu'yuc ono'ox lec sc'obique, xchi'uc ti chanovic xa li coxoetique, xchi'uc ti ijam xa satic li ma'satetic to'oxe. Jech lec ibat sc'oplal yu'unic li Dios cu'untic, vu'utic li israelutique. ");
INSERT INTO tzotze_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Li Jesuse laj yic'uncutic ta stojol, vu'uncutic li yajchanc'opuncutique, jech laj yalbuncutic: ―Toj abul sbaic li jchi'iltactic li'i yu'un yoxibal xa c'ac'al li' xchi'inojutic, ch'abal xa c'usi ta sve'ic. Mu jc'an ta jtac batel ti c'alal mu'yuc ve'emique yu'un naca me alubicuc ta be ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jech la jtac'becutic: ―¿Bu ta jtacutic epal pan li' ta xocol banamil sventa ta jmac'lincutic li vu'uncutique, yu'un toj ep li jchi'iltactique? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jech la sjac'buncutic li Jesuse: ―¿Jayib pan avich'ojic? ―xiyutuncutic. ―Vucub xchi'uc cha'oxcot bic'tal choy ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Li Jesuse laj yalbe jchi'iltactic ti ac'o chotiicuc ta lumtique. ");
INSERT INTO tzotze_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","La stsac li vucub pane xchi'uc li bic'tal choye, la stojbe ta vocol Dios. La svoc' li pane xchi'uc li bic'tal choye, laj yac'buncutic, vu'uncutic li yajchanc'opuncutique. Vu'uncutic la jpucbecutic ec li jchi'iltactique. ");
INSERT INTO tzotze_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Scotolic ive'ic, lec inojic o. La jtsobbecutic scomelal li pane xchi'uc scomelal li choye, inoj vucub moch. ");
INSERT INTO tzotze_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Li c'u yepal ive'ique ja' chanmil li viniquetique. Ja' slecoj o li antsetique xchi'uc li ololetique, mu'yuc atbil. ");
INSERT INTO tzotze_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Li Jesuse la sc'opan comel li jchi'iltactique, jech laj yalbe: ―Lec oy, tey xabatic ―xut. Jech li'ochcutic ta tenalte' canova xchi'uc li Jesuse. Tey libatcutic ta nopol lum Magdala. ");
INSERT INTO tzotze_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Italic jayibuc fariseoetic xchi'uc saduceoetic yu'un tsc'an ta sq'uelic c'uxi ta xtac'ov li Jesuse. Jech vul yalbeic: ―Ac'bun quilcutic senyail atsatsal ta vinajel yu'un jech ta jna'cutic o ti vo'ot tsots avabtele ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Itac'ov li Jesuse: ―C'alal bat xa c'ac'ale, jech chavalic: “Oc'ome lec q'uepel yu'un lec tsoj li vinajele”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta sobe jech chavalic noxtoc: “Ta xtal vo' tana yu'un toj tsoj vinajel xchi'uc oy ep toc”, xachiic. Jlo'lavanejoxuc. Xana'ic sq'uelel senyail ta vinajel pero mu xana'ic sq'uelel avalojic li c'usi c'otem xa ta pasel ta atojolic li' ta orae. ");
INSERT INTO tzotze_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Li boch'otic chopol yo'ntonic ti mu junuc yo'ntonic ta stojol Diose, ta sc'an ta sq'uelbeic yan más tsots senyail ti scotol xu' cu'une. Pero mu x'ac'bat yilic. Ja' no'ox ta x'ac'bat yilic jech chac c'u cha'al ic'ot ta pasel ta stojol li Jonase, ja' li yaj'alc'op Dios ta vo'onee ―xut. Li Jesuse la scomtsan li cristianoetique, jech liloc'cutic batel. ");
INSERT INTO tzotze_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lic'otcutic ta jot nab xchi'uc li Jesuse. Vu'uncutic li yajchanc'opuncutique muc xt'ab ta co'nton laj quich'cutic batel jpancutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jech laj yalbuncutic li Jesuse: ―Q'uelo me abaic ta sventa svolesubil xch'ut pan yu'unic fariseoetic xchi'uc saduceoetic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Li vu'uncutique jech lic calbe jbacutic: ―Ja' van ta xalbutic ti muc xquich'tic tal jpantique ―xcut jbacutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Li Jesuse la sna' li c'usi laj calcutique, jech laj yalbuncutic: ―¿C'u yu'un ja' chanopic ta sventa ti muc xavich'ic tal jpantique? Yu'un mu'yuc to ach'unojic lec ti scotol xu' cu'une. ");
INSERT INTO tzotze_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mu to xc'ot ta avo'ntonic. ¿Me yu'un mu xa xana'ic ti ta vo'ob no'ox pan ive'ic o li vo'mil viniquetique xchi'uc ti jayib moch scomelal laj atsobique? ");
INSERT INTO tzotze_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Me ich'ay xa ta avo'ntonic noxtoc ti ta vucub no'ox pan ive'ic chanmil viniquetique xchi'uc ti jayib moch scomelal laj atsobique? ");
INSERT INTO tzotze_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Me yu'un muc xava'ibeic smelol ti mu ja'uc ta sventa pan ti jech laj calboxuque: “Q'uelo me abaic ta sventa svolesubil xch'ut pan yu'unic fariseoetic xchi'uc saduceoetic”, xacutoxuc? ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jech laj ca'ibecutic o smelol ti mu ja'uc ta sventa li bats'i svolesubil xch'ut pane. Ja' no'ox laj yalbuncutic ti ac'o jq'uel jbacutic ta sventa ta xchanubtasvanic fariseoetic xchi'uc saduceoetic ti mu persauc ta jch'untic scotol c'usi yaloj Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","C'alal lic'otcutic xchi'uc Jesús ta nopol lum Cesarea yu'un Felipee, jtuccutic tey lic sjac'buncutic li Jesuse: ―¿Boch'oun ta xalic jchi'iltactic, vu'un ti co'ol cristianoutique? ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jech la jtac'becutic: ―Oy ta xalic ti vo'ot Juan j'ac'vanejot ta vo'e. Oy yan ta xalic ti vo'ot Elíasote. Oy yan ta xalic ti vo'ot Jeremíasote. Oy yan ta xalic ti vo'ot yan yaj'alc'opot Diose yu'un la lacha'cuxi ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jech la sjac'buncutic noxtoc: ―Li vo'oxuque, ¿boch'oun chavalic ec? ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Itac'ov li Simón Pedroe: ―Vo'ot Cristoot ti t'ujbilot yu'un Dios chaventainuncutique. Vo'ot Xnich'onot li cuxul Diose ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Itac'ov li Jesuse: ―Toj lec latac'ov, Simón, vo'ot xnich'onot Jonás. Muc ja'uc laj yac'bot ana' li boch'o co'ol oy abec'tal co'ol oy ach'ich'al achi'uque. Ja' laj yac'bot ana' li Jtotic tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jech chacalbot ec. Vo'ot Pedroot, vo'ot ta aventa ep boch'otic chlic xch'unic ti vu'un Jcoltavanejun yu'unique. Ta persa chc'ot ta pasel. Ac'o me tsc'an ta xules li pucuje pero mu xu' yu'un. ");
INSERT INTO tzotze_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Vo'ot ta xcom ta aventa chavalbe cristianoetic ti c'u x'elan xu' chc'otic ta stojol Diose. Li boch'otic mu sc'an scomtsanic c'usitic chopol tspasique, xu' chavalbe ti oy smul ch‑ilatic yu'un Diose. Yan li boch'otic laj xa scomtsanic c'usitic chopol tspasique, xu' chavalbe ti mu'yuc xa smul ch‑ilatic yu'un Diose ―x'utat yu'un Jesús li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Li Jesuse jech laj yalbuncutic: ―Mu to me boch'o xavalbeic ti vu'un t'ujbilun yu'un Dios chajventainoxuque ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Li Jesuse jech laj yalbuncutic: ―Ta persa chibat ta Jerusalén yu'un ja' tey ta xc'ot quich' vocol. Chi'ac'at ta sc'obic li jchapanvanejetique, xchi'uc li banquilal paleetique, xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Tey chiyaq'uicun ta milel. Chimucat, pero chicha'cuxi ta yoxibal c'ac'al ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Li Pedroe laj yic' loq'uel jutuc li Jesuse. Jech laj yalbe: ―Cajval, ac'o xc'uxubinot li Diose, mu me xac' c'otuc ta pasel ti chamilate ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Li Jesuse la sq'uelbe sat li Pedroe: ―Satanás, loc'an me ta jtojol. Yu'un chac'an chamacbun jbe. Ma'uc chanop c'usi ta sc'an Dios. Ja' no'ox chanop c'usi ta sc'an cristiano ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Li Jesuse jech laj yalbuncutic: ―Li boch'o tsc'an ta xchi'inune mu me xc'uxubin sba. Ac'o ts'icuc yu'un vocol jech chac c'u cha'al sts'ic cu'un li vu'une jech xu' chixchi'inun. ");
INSERT INTO tzotze_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Li boch'o mu sc'an xcham ta jcoje ja' ch'ayel chbat. Yan li boch'o mu sventauc me ta xchame, vu'un ta jventa, ja' ta xcuxi o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ac'o me oy boch'o xu' yu'un ta xu'uninic xcotol li c'usitic oy li' ta banamile, pero mu'yuc c'usi ta xtun o yu'un mu xcuxiic o sbatel osil. Yu'un ja' tsots sc'oplal ti chacuxiic sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yu'un ta to sta sc'ac'alil chital jchi'uc jxojobal jech chac c'u cha'al xojobal Jtot, vu'un ti co'ol cristianoutique. Ta jchi'in yalel tal li j'almantaletic cu'une. Ja' ta xtal cac'be stojol jujun cristianoetic ti c'u x'elan la spasique. ");
INSERT INTO tzotze_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Melel li c'usi chacalboxuque, oy boch'o avu'unic li'i ti mu'yuc to ta xchamique ja' to me laj yilic ti chlic jventainbe yo'nton cristianoetic, vu'un ti co'ol cristianoutique ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","C'alal ech'em xa'ox vaquib c'ac'ale, li Jesuse laj yic' batel Pedro, xchi'uc Jacobo, xchi'uc Juan, ja' li yits'in Jacoboe. Stuquic no'ox laj yic' muyel ta jun toyol vits. ");
INSERT INTO tzotze_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Li Jesuse tey la sc'atajes sba ta stojol li oxibique. Laj yac' xojobal sat jech chac c'u cha'al xojobal c'ac'al. Isacub noxtoc li sc'u'e jech chac c'u cha'al luz. ");
INSERT INTO tzotze_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tey ivinaj Moisés xchi'uc Elías ta stojolic. Tey ilo'ilajic xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Li Pedroe jech laj yalbe li Jesuse: ―Cajval, lec ti li' oyutique. Me chac'ane, ta jpascutic oxbej vacaxna li'i; jun avu'un, jun yu'un Moisés, jun yu'un Elías ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","C'alal ja' o chlo'ilaj li Pedroe, ital jun toc. Macbil ic'ot ta toc scotolic. Laj yac' xojobal li toque. Tey laj ya'yic ic'opoj ta yut toc li Diose, jech laj yal: ―Li'i ja' jnich'on, lec c'ux ta co'nton. Xcuxet no'ox co'nton yu'un. A'ibeic sc'op ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","C'alal laj ya'yic li oxib jchi'iltac ta abtele la spatan sbaic ta lumtic. Toj xi'el no'ox ic'otic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Li Jesuse la stij liquel, jech laj yalbe: ―Licanic, mu xaxi'ic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","C'alal la sq'uelique, mu'yuc xa boch'o laj yilic, ja' xa no'ox stuc tey oy li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","C'alal ja' o ta xyalic tal ta vitse, jech i'albatic yu'un li Jesuse: ―Mu to me boch'o xavalbeic li c'usi laj avilique ja' to me licha'cuxi loq'uel ta jmuquinal, vu'un ti co'ol cristianoutique ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Vu'uncutic li yajchanc'opuncutique jech la jac'becutic: ―¿C'u yu'un ta xalic jchanubtasvanejetic ta smantal Dios ti ta persa ba'yuc ta xtal li Elíase, ti ts'acal chatal vo'ote? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Itac'ov li Jesuse: ―Ta melel jech ts'ibabil ta sc'op Dios ti ja' ba'yuc ta xtal li Elíase. Yu'un chtal yalbe ti ac'o scomtsan c'usitic chopol tspasic li jchi'iltactique. ");
INSERT INTO tzotze_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Vu'un ta xcalboxuc ti jeloven xa li Elíase. Pero mu'yuc laj yotquinic. Li cristianoetique la spasbeic c'usi ta sc'an yo'nton stuquic, jech la smilic. Ja' no'ox jech chismilicun ec, vu'un ti co'ol cristianoutique ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jech la jna'cutic ti ja' sc'oplal Juan j'ac'vanej ta vo' laj yal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","C'alal lic'otcutic yo' bu stsoboj sbaic li cristianoetique, tey ital jun vinic. La squejan sba ta stojol li Jesuse, jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tata, c'uxubinbun jnich'on yu'un yich'oj tu'p ic'. Toj ep ta xich' vocol. Ep ta velta chbalch'uj ta c'oc' xchi'uc chbalch'uj ta vo'. ");
INSERT INTO tzotze_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Laj quic' tal ta stojol avajchanc'optac pero muc xu' yu'unic la scoltabicun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Li Jesuse jech laj yalbuncutic jchi'uc li jchi'iltactique: ―Tsots avo'ntonic, mu xac'an xach'unic. Ep xa c'ac'al li' jchi'ucoxuque pero mu'yuc to chach'unic. Ep xa c'ac'al la jts'icboxuc ti c'u xa'elanique. Iq'uic tal li quereme ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Li Jesuse la stac loq'uel li pucuje. Jech iloc' ta yo'nton li quereme, jech ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Li vu'uncutique ts'acal to la jac'becutic Jesús ti c'alal jtuccutic xae: ―¿C'u yu'un muc xu' cu'uncutic la jloq'uescutic li pucuje? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Itac'ov li Jesuse: ―Yu'un mu'yuc to ach'unojic lec ti scotol xu' avu'unic ta jventae. Melel li c'usi chacalboxuque, manchuc me jutuc no'ox ach'unojic ti vu'un ta jcoltaoxuque, me ja' no'ox jech yepal jech chac c'u cha'al jbej biq'uit bec' mostazae, pero xu' xa avu'un chapasic li c'usitic tsots ta pasele. Jech chac c'u cha'al me chavalbeic ti ac'o loc'uc li vits li'i, ja' ta xc'ot ta pasel avu'unic. Ac'o me jech to no'ox yepal ach'unojic jech chac c'u cha'al biq'uit bec' mostazae, scotol xa xu' avu'unic o. ");
INSERT INTO tzotze_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero li jchop o ta pucujetic la jloq'uese, ja' to ta xloc' me chac'opanic Diose xchi'uc me chavictaic ixime ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","C'alal tey to'ox chixanovcutic ta Galilea banamil xchi'uc li Jesuse, jech laj yalbuncutic li Jesuse: ―Vu'un ti co'ol cristianoutique ta xi'ac'at ta c'abal ta sc'ob cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta xismilicun, chimucat, pero chicha'cuxi ta yoxibal c'ac'al ―xiyutuncutic. C'alal jech laj ca'icutique, ep laj cat co'ntoncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","C'alal lic'otcutic ta lum Capernaume, tey italic jayibuc jtsobtaq'uinetic sventa chtun yu'unic ta templo. Jech ijac'bat li Pedroe: ―¿Me ta xac' ec chib dracma taq'uin jchanubtasvanej avu'unique? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Itac'ov li Pedroe: ―Ta xac' ―xi. C'alal i'och ta yut na li Pedroe, ja' ba'yuc ic'opanat yu'un li Jesuse. Jech ijac'bat: ―¿C'usi chanop, Simón? ¿Boch'o ta sc'anbe taq'uin li muc'tic ajvaliletic li' ta banamile? ¿Me ja' ta sc'anbe li xnich'nabe o me yan cristianoetic ta sc'anbe? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Itac'ov li Pedroe: ―Ja' ta sc'anbe yan cristianoetic ―xi. Jech i'albat noxtoc: ―Jech colem ta xcomic li xnich'nabtaque. Ja' no'ox jechun ec li vu'une mu persauc ta jtoj ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero ti c'u cha'al mu soc yo'ntonic cu'une, ja' lec batan ta nab, tic'o ochel ta yut nab li snitubil choy avu'une. Li sbacotal choy chanit loq'uele jach'bo ye. Tey chata jsep estatero taq'uin. Ich'o tal, ac'bo li boch'otic ta stsobe. Ja' jtaq'uin jchibaltic ti chavac'bee ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ja' o tey lic jac'becutic Jesús, vu'uncutic li yajchanc'opuncutique: ―¿Boch'o más banquilal chc'ot c'alal cha'och ta ajvalilal cu'uncutique? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Li Jesuse laj yic' jun olol. Tey la sva'an ta o'lol yo' bu oyuncutique. ");
INSERT INTO tzotze_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jech laj yalbuncutic: ―Melel li c'usi chacalboxuque, me mu xajel c'usi chanopique, me mu xaco'lajes abaic jech chac c'u cha'al ololetique, mu xu' cha'ochic yo' bu ta jpas mantale. ");
INSERT INTO tzotze_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Li boch'otic biq'uit chac' sbaic jech chac c'u cha'al li olol li'i, ja' banquilal chc'ot tey yo' bu ta jpas mantale. ");
INSERT INTO tzotze_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Boch'otic ta xich' ta muc' li boch'o jech yo'nton jech chac c'u cha'al li olol li'i, vu'un ta jventa, jech vu'un chiyich'un o ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yan li boch'o ta socbe yo'nton junuc li boch'o jech yo'ntonic jech chac c'u cha'al ololetic ti xch'unojic vu'un Jcoltavanejun yu'unique, ja' lec ac'o chucuc jun muc'ta cho' ta snuc', ac'o jipatuc ochel ta nab, tey ac'o chamuc o. ");
INSERT INTO tzotze_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","’Vo'oxuc ti li' to oyoxuc ta banamile, abul abaic yu'un ep li boch'o tsc'an ta socboxuc avo'ntonique. Ta melel ta ono'ox xava'yic ti xu' ta soc avo'ntonic yu'une. Pero toj abul sbaic li boch'otic jech ta spasique. ");
INSERT INTO tzotze_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Me ta scoj no'ox ac'obic, o me avacanic chata o amulique, ja' lec ti mu'yucuc ac'obic ti mu'yucuc avacanic ya'yel jech chac c'u cha'al li boch'o mu'yuc sc'ob xchi'uc boch'o mu'yuc yacane, jech xu' cha'ochic ta lequilal. Ja' abul abaic me ta scoj no'ox oy c'usi jutuc mu xacomtsanic spasel ti chabatic ta muc'ta c'oc' sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jech noxtoc me ta scoj no'ox asatic chata o amulique, ja' tsc'an ti ma'satoxuc ya'yel jech chac c'u cha'al li boch'o ma'sate, jech xu' cha'ochic ta lequilal. Ja' abul abaic me ta scoj no'ox oy c'usi jutuc mu xacomtsanic sq'uelel ti chabatic ta muc'ta c'oc' sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Q'uelo me abaic, mu me xanopic ti mu'yuc stu chavilic junuc li ololetic laj cale yu'un chabibilic yu'un j'almantaletic. Melel li c'usi chacalboxuque, li j'almantaletic ta xchabivanique scotol ora chc'ot sc'opanic li Jtot tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yu'un ti lital, vu'un ti co'ol cristianoutique, ja' tal jcoltaoxuc acotolic, vo'oxuc ti ch'ayemoxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿C'usi chanopic? Me oy jun vinic oy vo'vinic (100) ta cot xchije, pero me ich'ay comel jcotuque, ¿me mu teyuc ta scomtsan yo' bu oy lec sve'elic li balunlajuneb yo'vinic (99) ta cote yu'un ja' chbat st'un tal li jcot ti ich'ay comele? ");
INSERT INTO tzotze_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Melel li c'usi chacalboxuque, c'alal me la sta li jcote, xcuxet xa yo'nton yu'un chapal xa li xchije. ");
INSERT INTO tzotze_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ja' no'ox jech ec li Jtot ti tey oy ta vinajele, mu sc'an me oy ta xch'ay junuc li ololetic laj cale. ");
INSERT INTO tzotze_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Me oy la sta smul ta atojol avermanoe, batan, bat chapano achibalic no'ox. Me laj ya'ibot ac'ope, jech lec ta xbat avu'un li avermanoe. ");
INSERT INTO tzotze_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Me mu sc'an xa'ibot li ac'ope, ic'o batel jun chibuc achi'il, yu'un ja' testigo ta xc'ot ta sventa li c'usi chavalique. ");
INSERT INTO tzotze_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Me mu sc'an xa'ibe sc'opic, albo scotol jch'unolajeletic. Me mu sc'an xch'un c'usi chal li jch'unolajeletique, ac'o comuc jech chac c'u cha'al yan cristiano, jech chac c'u cha'al jtsobpatan ti mu'yuc xch'unoj sc'op Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Melel li c'usi chacalboxuque, li boch'otic mu sc'an scomtsanic c'usitic chopol tspasique, xu' chavalbeic ti oy smul ch‑ilatic yu'un Diose. Yan li boch'otic laj xa scomtsanic c'usitic chopol tspasique, xu' chavalbeic ti mu'yuc xa smul ch‑ilatic yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Chacalboxuc yan velta, me oy chiboxuc ti jmoj avo'nton chac'opanic li Jtot tey oy ta vinajele, scotol li c'usitic chac'anique chayac'boxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yu'un me oy atsoboj abaic chib oxib ta jventae, tey oyun ta o'lol avu'unic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Li Pedroe jech la sjac'be li Jesuse: ―Cajval, ¿jayib velta xu' ta jpasbe perdón me oy la sta smul ta jtojol jun jchi'ile? ¿Me xu' ta vucub velta? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Itac'ov li Jesuse: ―Mu'yuc chacalbot me xu' ta vucub no'ox velta. Mu atbiluc jayib velta xu' chapasbe perdón. Ja' tsc'an ti scotol c'ac'al chapasbe perdone. ");
INSERT INTO tzotze_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Chacalboxuc ava'yic c'u x'elan ta spas mantal li Diose. Ja' jech chac c'u cha'al jun ajvalil ti oy q'uexbil staq'uin yu'un xchi'iltac ta abtele. Pero tsc'an ti ac'o sutesbatuque, jech la stacan ta iq'uel li boch'otic oy xq'uex yu'une. ");
INSERT INTO tzotze_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","C'alal lic sc'opanan li boch'otic oy xq'uex yu'une, ital li boch'o oy lajunmil xq'uexe. ");
INSERT INTO tzotze_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Li vinique mu sut yu'un li xq'uexe. Jech li ajvalile laj yal mantal ti ac'o yich' chonel ta mozoil xchi'uc yajnil xnich'nabe, xchi'uc scotol li c'usitic oy yu'une, yu'un jech xu' ta sut o li xq'uexe. ");
INSERT INTO tzotze_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","C'alal laj ya'i li vinique, la squejan sba ta stojol li ajvalile, jech laj yalbe: “Ajvalil, avocoluc malun to, chajsutesbot scotol li jq'uexe”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jech ic'uxubinat yu'un li ajvalile, la scolta, la xch'aybe scotol li xq'uexe. Mu'yuc xa la sutes o. ");
INSERT INTO tzotze_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jech iloc' batel li vinique. Tey la snup ta be jun xchi'il ta abtel oy q'uexbil vo'vinic staq'uin ec. La stsac li xchi'ile, la xmich'be ta snuc', jech laj yalbe: “Sutesbun ta ora li aq'uexe”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Li xchi'il ta abtele la squejan sba ta stojol, jech laj yalbe: “Avocoluc malun to, chajsutesbot scotol li jq'uexe”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero mu sc'an smala. Bat stic' ta chuquel. Jech laj yalbe comel li yajval chuquinabe: “Ja' to chaloq'uesbun c'alal me la sutesbun scotol li xq'uexe”, xut comel. ");
INSERT INTO tzotze_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","C'alal laj yilic li yan xchi'iltac ta abtele, chopol laj yilic. Bat yalbeic ta ora ajvalil li c'usi la spase. ");
INSERT INTO tzotze_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Li ajvalile la stac ta iq'uel li boch'o jech la spase, jech laj yalbe: “Toj chopolot chca'i. Li vo'ote laj ac'anbun vocol jech la jch'aybot scotol li aq'uexe. ");
INSERT INTO tzotze_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿C'u yu'un muc xac'uxubin ec li achi'ile jech chac c'u cha'al la jc'uxubinote?” xut. ");
INSERT INTO tzotze_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jech i'ilin li ajvalile. Laj yac' ta sc'ob li boch'otic ta xchucvanique. Jech laj yalbe: “Ja' to chaloq'uesbicun batel c'alal me la sutesbun scotol li xq'uexe”, xut comel. ");
INSERT INTO tzotze_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Li vo'oxuque ja' no'ox jech ta spasboxuc ec li Jtot tey oy ta vinajele me mu j'ech'eluc chach'ay ta avo'ntonic smul li avermanoique ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","C'alal laj yo'nton la sc'opanuncutic li Jesuse, iloc' ta Galilea banamil. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Tey lic'otcutic ta Judea banamil ta jot uc'um Jordán. ");
INSERT INTO tzotze_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ep jchi'iltactic tey nabal ibatic xchi'uc ep jchameletic. Scotol la scoltaan li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tey italic ta stojol Jesús jayibuc fariseoetic yu'un tal sq'uelic c'uxi ta xtac'ov li Jesuse. Jech la sjac'beic: ―¿Me xu' ta xquicta cajnilcutic ti c'usiuc no'ox smul ta stae? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Itac'ov li Jesuse: ―Aq'uelojic xa ta sc'op Dios bu ta xal ti c'alal ipasat li sba vinique, jun vinic xchi'uc jun ants ipasat. ");
INSERT INTO tzotze_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Xchi'uc aq'uelojic ti jech yaloj Diose: “Jech li viniquetique ta scomtsan stot sme'ic yu'un ta xic' yajnilic. Li chibique jun no'ox ta xc'otic”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jech muc xa chibicuc, jun xa no'ox ic'otic. Li boch'otic pasbilic xa ta jun yu'un Diose, mu xu' ta xicta sbaic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","La sjac'beic yan velta li Jesuse: ―¿C'u yu'un jech laj yal mantal li Moisés ta vo'onee: “Li boch'o ta xicta yajnile ac'o spasbe svunal ti muc xa yajniluque, ac'o yac'be li yajnile”, xi li Moisese? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Itac'ov li Jesuse: ―Ja' ta scoj toj tsots yo'nton li jmoltotactic ta vo'one ti jech laj yal mantal Moisese. Ta sliquebal banamile mu jechuc. ");
INSERT INTO tzotze_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero vu'un chacalboxuc, li boch'o ta xicta yajnile, me muc ta scojuc yu'un imulivaj ti ta xictae, me ta xic' yajnilin yan ants, ja' no'ox ta xmulivaj xchi'uc, yu'un mu ja'uc yajnil. Xchi'uc noxtoc li boch'o ta xic' yajnilin li ictabil antse ja' no'ox ta xmulivaj noxtoc ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vu'uncutic li yajchanc'opuncutique jech laj calbecutic li Jesuse: ―Me jech oy ep sc'oplal li boch'o oy yajnile, ja' lec ti mu jsa' cajnilcutique ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Itac'ov li Jesuse: ―Mu acotolicuc xu' avu'un ti mu xasa' avajnilique. Ja' no'ox xu' yu'unic li boch'o jech ch‑ac'bat sna'ic yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oy viniquetic ti stalelic o jech yo'ntonic mu sa' yajnilique. Oy viniquetic ti ja' to tspasatic ta capón yu'un yan viniquetique. Oy viniquetic ta snopic ti mu sa' yajnilique yu'un jech más xu' yu'un tspasic c'usitic tsc'an Dios. Li boch'otic jech tsnopique, me jech tsc'an Dios cha'yique, ac'o me spas ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tey i'ic'bat tal ololetic ta stojol li Jesuse yu'un ac'o yac' sc'ob ta sjolic xchi'uc ac'o sc'opanbe Dios ta stojolic. Vu'uncutic li yajchanc'opuncutique chopol laj ca'icutic. La jpajescutic li boch'otic laj yiq'uic tale. ");
INSERT INTO tzotze_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero li Jesuse jech laj yalbuncutic: ―Ac'o talicuc ta jtojol li ololetique, mu me xapajesic. Yu'un li boch'otic ja' jechic jech chac c'u cha'al ololetique lec ta xa'yic pasel ta mantal yu'un Dios ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","C'alal laj yac' sc'ob ta sjol ololetic li Jesuse, liloc'cutic batel xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oy jun querem vinic ital sc'opan li Jesuse, ja' jchi'iltic ta israelal. Jech la sjac'be li Jesuse: ―Lequil jchanubtasvanej, ¿c'usi lec xu' ta jpas yu'un ti jech chicuxi o sbatel osile? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Itac'ov li Jesuse: ―Mu'yuc ono'ox boch'o lec, ja' no'ox lec stuc li Diose. Jech ¿c'u yu'un chavalbun ti lequil jchanubtasvanejune? Me chac'an chacuxi sbatel osile, tsc'an chach'un li smantaltac Diose ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jech la sjac' li vinique: ―¿C'usitic mantalil ti tsc'an ta jch'une? ―xi. Itac'ov li Jesuse: ―“Mu me xamilvan. Mu me xamulivaj. Mu me xa'elc'aj. Mu me xanopbe smul achi'il. ");
INSERT INTO tzotze_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ich'o ta muc' atot ame'. C'ano achi'iltac jech chac c'u cha'al c'ux ta avo'nton abec'tal atuque”, xi li mantale ―xut li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Itac'ov li querem vinique: ―Scotol le'e biq'uitun lic jch'un tal. ¿C'usi to yan sc'an ta jch'un? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Itac'ov li Jesuse: ―Me chac'an ti lec chayilot Diose, bat chono scotol li c'usitic oy avu'une, q'uelanbo me'onetic li stojole. Jech chata ac'ulejal sventa sbatel osil. Ts'acal to xtal achi'inun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","C'alal jech laj ya'i li quereme, ep laj yat yo'nton ti c'alal isut batele yu'un toj ep sc'ulejal. ");
INSERT INTO tzotze_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Li Jesuse jech lic yalbuncutic: ―Melel li c'usi chacalboxuque, li jc'ulejetique toj vocol ta xac' sbaic ta ventainel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chacalboxuc noxtoc, jech chac c'u cha'al mu xjelov jcot camello‑ca' ta chac acuxae, ja' no'ox jech mu xu' ta x'och yo' bu tspas mantal Dios li boch'otic batem yo'nton yu'un sc'ulejalique ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","C'alal jech laj ca'icutic, vu'uncutic li yajchanc'opuncutique, toj ch'ayel ic'ot co'ntoncutic. Jech laj calcutic: ―Me mu xcol li boch'o jc'ulejetique, ¿boch'o ono'ox xu' ta xcol cha'e? ―xichicutic. ");
INSERT INTO tzotze_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Li Jesuse la sq'uelbun jsatcutic. Jech laj yalbuncutic: ―Li cristianoetique mu xu' yu'un ta scolta sba stuquic. Ja' no'ox scotol xu' yu'un li Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Li Pedroe la stac'be li Jesuse: ―Li vu'uncutique laj xa jcomtsancutic scotol li c'usitic oy to'ox cu'uncutique. Li' xa jchi'inojotcutic. ¿C'u x'elan chic'otcutic ec li vu'uncutique? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Li Jesuse jech laj yalbuncutic: ―Melel li c'usi chacalboxuque, c'alal tsta yorail ta jcha'lecubtas yan velta li banamile, tey chvul chotlicun ta jmuc'ta chotleb yu'un vu'un ta jpas ta mantal scotolic, vu'un ti co'ol cristianoutique. Scotol cristianoetic chiyich'icun ta muc'. Vo'oxuc ti laj achi'inicune tey chachotiic ec ta lajchab muc'tic chotlebal yu'un vo'oxuc chapasic ta mantal li lajcha'chop jchi'iltactic, vu'utic ti co'ol israelutique. ");
INSERT INTO tzotze_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Li boch'otic laj xa scomtsan snaic, me sbanquiltac, me yits'inabtac, me xvixubtac, me yixlaltac, me xi'meltac, me smucubtac, me stot, me sme', me xnich'nab, me yosil, vu'un ta jcoj, jech ta stabe ep xq'uexol. Xchi'uc ta xcuxiic sbatel osil noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero li boch'otic banquilal ta scuy sbaic li' ta orae ja' its'inal ta xc'otic yu'un la stoy sbaic. Yan li boch'otic its'inal ta x'ilatic li' ta orae ja' banquilal ta xc'otic yu'un biq'uit laj yac' sbaic. Ep li boch'otic its'inal ta xc'otique; ep noxtoc li boch'otic banquilal chc'otique ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Li Jesuse jech laj yalbuncutic noxtoc: ―Chacalboxuc ava'yic c'u x'elan ta spas mantal li Diose. Ja' jech chac c'u cha'al jun vinic ti oy ep sts'unoj sts'usube. Sob iloc' batel, bat sa' tal svinictac ta abtel. ");
INSERT INTO tzotze_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","C'alal la sta li svinictaque, la spasic trato ti jun denario taq'uin ta stoj jun c'ac'ale. Jech tey la stac batel yo' bu ts'usubtic yu'une. ");
INSERT INTO tzotze_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","C'alal ista baluneb orae, iloc' batel yan velta li yajval ts'usube. Laj yil oy viniquetic tey va'ajtic ta ch'ivit, mu'yuc yabtelic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jech laj yalbe: “Batanic ta abtel cu'un tey ta ts'usubtic. Ta jtojoxuc ti c'u yepal cha'abtejique”, xut. La xch'unic, jech ibatic ta abtel. ");
INSERT INTO tzotze_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Iloc' batel yan velta noxtoc ta o'lol c'ac'al yu'un bat sa' tal yan svinictac ta abtel. Iloc' yan velta ta o'lol syalel c'ac'al. Co'ol no'ox la spasilan jujun velta. ");
INSERT INTO tzotze_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Iloc' batel yan velta ta vo'ob ora mal c'ac'al. Tey la sta xocol viniquetic mu'yuc yabtelic. Jech laj yalbe: “¿C'u yu'un ti li' no'ox va'aloxuc sjunul c'ac'ale?” xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Itac'ovic: “Yu'un mu'yuc boch'o chiyic'uncutic ta abtel”, xiic. Jech laj yalbe: “Batanic ta abtel cu'un tey ta ts'usubtic. Ta jtojoxuc ti c'u yepal cha'abtejique”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","C'alal bat xa'ox c'ac'ale, jech laj yalbe scapural li yajval abtelale: “Ic'o tal scotol li jvinictac ta abtele, ac'bo stojolic. Ja' ba'yuc xavac'be stojol li boch'otic ts'acal ivule, ja' ts'acal xavac'be stojol li boch'otic ba'yuc ivule”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jech ba'yuc ital li boch'otic ta vo'ob xa ora la stsac yabtelique. Jujun denario taq'uin i'ac'bat stojolic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","C'alal ital li boch'otic ba'yuc la stsac yabtelique, la snopic ti ja' más ep ta xich' stojolique. Pero co'ol yepal itojat scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","C'alal laj yich' stojolique, i'ilinic ta stojol li yajvalic ta abtele. ");
INSERT INTO tzotze_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jech lic yalbeic li yajvalic ta abtele: “Jun xa no'ox ora i'abtejic li boch'otic ts'acal ivulique. Pero co'ol yepal laj atojuncutic. Li vu'uncutique sjunul c'ac'al li'abtejcutic. Toj c'ux laj ca'icutic li c'ac'ale. Ep lubel laj ca'icutic”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Itac'ov li yajval abtelale: “Muc chopoluc li c'usi la jpasboxuque. Yu'un ba'yuc la jchaptic ti jun denario taq'uin ta jtojoxuc jun c'ac'ale. ");
INSERT INTO tzotze_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ich'o batel li atojolique, batanic. Yu'un jech la sc'an co'nton ti co'ol ta jtojoxuc acotolique. ");
INSERT INTO tzotze_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Xu' ta jpas c'usi tsc'an co'nton xchi'uc li c'usi oy cu'une. Mu me xti'etuc avo'ntonic ta sventa ti c'usi lec la jpase”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ti c'u x'elan la spasbe li svinictac ta abtele, ja' no'ox jech ta spasbatic ec li boch'otic ta x'abtejic cu'un li' ta banamile. Li boch'otic its'inal ta x'ilatic li' ta orae, ja' banquilal ta xc'otic yu'un biq'uit laj yac' sbaic. Yan li boch'otic banquilal ta scuy sbaic li' ta orae, ja' its'inal ta xc'otic yu'un ja' no'ox la sc'anic ich'el ta muc' ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","C'alal ja' o chixanovcutic batel ta Jerusalén xchi'uc Jesús, vu'uncutic li yajchanc'opuncutique, laj yic'uncutic jutuc ochel ta ti' be, jech laj yalbuncutic: ");
INSERT INTO tzotze_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Chana'ic ti chijbat ta Jerusalene. Vu'un ti co'ol cristianoutique tey ta xi'ac'at ta sc'ob banquilal paleetic xchi'uc ta sc'ob li jchanubtasvanejetic ta smantal Dios yalojique. Tey ta xchapanic ti chiyaq'uicun ta milele. ");
INSERT INTO tzotze_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ta xaq'uicun ta sc'ob boch'otic muc ja'uc jchi'iltic ta israelal. Ja' ta slabanicun, ta xac'bicun nucul. Ts'acal ta sjoc'anicun ta cruz. Tey chismilicun. Chimucat pero chicha'cuxi ta yoxibal c'ac'al ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ital ta stojol Jesús li sme'ic chib jchi'iltac ta abtele, ja' li xnich'nab Zebedeoe, ja' li Jacobo xchi'uc Juane. Li sme'ique vul squejan sba ta stojol li Jesuse yu'un oy c'usi ta sc'anbe. ");
INSERT INTO tzotze_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jech ijac'bat yu'un li Jesuse: ―¿C'usi chac'an? ―xut. Itac'ov li me'ile: ―Alo amantal ti co'ol chachotiic achi'uc li chib cole. Jun ta abats'icob, jun ta ats'et ac'o chotiicuc ti c'alal tsta yorail chtal apas mantale ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Itac'ov li Jesuse: ―Mu xana'ic c'usi chac'anbicun. ¿Me xu' avu'un chavich'ic vocol jech chac c'u cha'al chquich' vu'une? ―xi. Itac'ovic: ―Xu' cu'uncutic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jech laj yal noxtoc li Jesuse: ―Ta melel ta ono'ox xavich'ic vocol jech chac c'u cha'al chquich' vu'une. Pero ti chac'an chachotiic jun ta jbats'ic'ob, jun ta jts'ete, mu xu' chacalboxuc vu'un. Ja' chal stuc Jtot ti boch'otic tey ta xchotiique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","C'alal laj ca'icutic c'usi laj yalic li chib jchi'ilcutique, chopol laj ca'icutic li lajunebuncutique. ");
INSERT INTO tzotze_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Li Jesuse laj yic'uncutic jcotolcutic, jech laj yalbuncutic: ―Xana'ic c'u x'elan ta spasic li ajvaliletic yu'un yan lum cristianoetique. Ja' no'ox ta spasic mantal. Jech noxtoc li boch'otic ac'bil yabtelic yu'un ajvalile ja' no'ox ta sujvanic ta abtel. ");
INSERT INTO tzotze_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Pero li vo'oxuque mu me xapasic jech. Li boch'o tsc'an banquilal ta xc'ot avu'unique, ti tsc'an ich'bil ta muq'ue, biq'uit ac'o yac' sba ta atojolic, ac'o scoltaoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jech chac c'u cha'al vu'un ti co'ol cristianoutique, mu yu'unuc tal pasvancun ta mantal. Talemun yu'un tal tuncun yu'un scotol cristianoetic. Tal cac' jba ta milel ta acojic yu'un jech xu' chacolic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","C'alal liloc'cutic batel ta lum Jericó xchi'uc li Jesuse, tey nabal ibatic epal cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tey chotolic ta ti'be chib jchi'iltic ta israelal, ja' ma'satetic. C'alal laj ya'yic tey ta xjelov li Jesuse, laj yaptaic: ―Cajval, vo'ot smomnich'onot David ti sc'oplal ono'ox cha'och ta ajvalil cu'uncutique, c'uxubinuncutic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pero li yantic jchi'iltactique laj yutic yu'un mu me x'avanic. ―Ch'anchanic ―xutic. Pero más to i'avanic: ―Cajval, vo'ot smomnich'onot David, c'uxubinuncutic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iva'i li Jesuse. Laj yic' tal ta stojol li ma'satetique, jech la sjac'be: ―¿C'usi chac'an ta jpasboxuc? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Itac'ovic: ―Cajval, avocoluc jambun jsatcutic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Li Jesuse la xc'uxubinan, la spicbe satic. Jech ta ora ijam li satique, la xchi'inic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","C'alal nopol xa xi'ech'cutic batel ta Jerusalene, tey lic'otcutic ta nopol Betfajé sbi, tey ta yoc vits Olivatic sbi. Li Jesuse la stac batel chib jchi'ilcutic ta abtel. ");
INSERT INTO tzotze_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jech laj yalbe: ―Batanic ta tsobtsobnaetic le'e. Tey chucbil chataic jcot me'burro xchi'uc yol. Titunic, iq'uic tal. ");
INSERT INTO tzotze_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Me oy boch'o chayalboxuc ti c'u yu'un chatitunic li burroe, jech xavalbeic: “Yu'un ta xtun yu'un li Cajvaltique”, utic. Jech chayac'boxuc tal ―x'utatic batel yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Scotol jech ic'ot ta pasel yu'un ja' ic'ot o c'usi laj yal li yaj'alc'op Dios ta vo'onee. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Albo li boch'otic ja' slumalic Jerusalene: “Chtal li ajvalil avu'unique. Ja' toj manso. Cajal ta burro chtal, ja' yol j'icatsnom me'burro”, uto, xiyutun li Diose, xi ono'ox laj yal li j'alc'ope. ");
INSERT INTO tzotze_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jech ibatic li chibique, la xch'unic li c'usi i'albatic yu'un Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Laj yiq'uic tal xchi'uc yol li me'burroe. Laj yac'beic slapbolal xaquitaic staspatin, jech tey icaji li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ep boch'o la sq'uiic slapbolal xaquitaic ta be. Oy yantic la sc'asic c'obte' xchi'uc yanal, la sq'uiic ta be yu'un chich'ic ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Li boch'otic ba'yucbe italique xchi'uc li boch'otic ta ts'acalpat italique tsots i'avan scotolic. Jech laj yalic: ―¡Ac'o ich'atuc ta muc' li smomnich'on David ti tal ochuc ta ajvalilal cu'untique! ¡Toj lec li boch'o tacbil tal yu'un Cajvaltic Diose! ¡Ac'o ac'batuc ep bendición! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","C'alal i'och batel ta Jerusalén li Jesuse, xvochetic no'ox liquel scotol li jchi'iltactique. Jech la sjaq'uic: ―¿Boch'o le'e? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Itac'ovic li epal cristianoetic ti xchi'inojic tal li Jesuse: ―Ja' Jesús. Ja' li yaj'alc'op Dios tey liquem tal ta Nazaret ta Galilea banamile ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Li Jesuse i'och ta yamaq'uil templo ta Jerusalén. Jech tey li'ochcutic ec, vu'uncutic li yajchanc'opuncutique. Lic sloq'ues scotol li boch'otic ta xchonolajic xchi'uc boch'otic ta xmanulajic tey ta yamaq'uil temploe. La sbutq'uinbe smesaic li jeltaq'uinetique. La sbutq'uinbe sillaic li jchonpalomaetique. ");
INSERT INTO tzotze_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jech laj yalbe: ―Jech ts'ibabil ta sc'op Dios: “Li jnae ja' snail bu chac'opanicun”, xi yaloj li Diose. Pero li vo'oxuque apasojic xa ta snailch'en j'eleq'uetic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tey ta yamaq'uil templo italic ta stojol Jesús ma'satetic xchi'uc coxoetic. Scotol icol yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tey oyic jayibuc banquilal paleetic xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Tey laj yilic scotol c'usitic lec la spas li Jesuse. Xchi'uc laj ya'yic tsots i'avanic bic'tal queremetic. Jech laj yalic: “Ac'o ich'atuc ta muc' li smomnich'on David ti tal ochuc ta ajvalilal cu'untique”, xiic. Jech tey i'ilinic o. ");
INSERT INTO tzotze_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jech tal sjac'beic li Jesuse: ―¿Me chava'i c'usi chalic li bic'tal queremetique? ―xutic. Itac'ov li Jesuse: ―Laj ca'i. Aq'uelojic ti jech ts'ibabil ta sc'op Diose: Li ololetique ja' más lec ta xalic ac'oplal, xi ono'ox ts'ibabil. Ja' yu'un jech ic'ot ta pasel ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iloc' batel li Jesuse. Libatcutic ta biq'uit lum Betánia. Ja' tey c'ot vaycuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sob ta yoc'omal libatcutic yan velta ta Jerusalén xchi'uc li Jesuse. C'alal ja' o chixanovcutic batel ta bee, ivi'naj li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Laj yil oy jtec' igo ta nopol ti'be. Bat sq'uel me oy sat. Pero mu'yuc sat la sta, ja' no'ox yanal. Li Jesuse jech laj yalbe li te'el igoe: ―Mu'yuc xa chasatin o ―xut. Jech ta ora itaquij li te'el igoe. ");
INSERT INTO tzotze_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","C'alal laj quilcutic, vu'uncutic li yajchanc'opuncutique, toj ch'ayel ic'ot co'ntoncutic. ―¿C'usi spas li te'el igo ta ora itaquije? ―xichicutic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Li Jesuse jech laj yalbuncutic: ―Melel li c'usi chacalboxuque, me chach'unic ti vu'un ta jcoltaoxuque, mu ja'uc no'ox xu' avu'un chapasic jech chac c'u cha'al la jpasbe li jtec' igoe, ja' ta spas avu'unic li c'usitic tsots ta pasel ti mu j'ech'el xu' avu'unique. Jech chac c'u cha'al me chavalbeic li vits li'i ti ac'o loc'uque, ti ac'o sjip sba ochel ta nabe, ta xc'ot ta pasel avu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Scotol li c'usi chac'anbeic Diose, ch'unic ti cha'ac'batique, jech chataic scotol ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","C'alal lic'otcutic ta templo tey ta Jerusalene, tey lic chanubtasvanuc ta yamaq'uil templo li Jesuse. Tey italic ec li banquilal paleetique xchi'uc li jchapanvanejetic cu'untique. Jech la sjaq'uic: ―¿Boch'o laj yac'bot avu'el chapas li c'usitic chapase? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Itac'ov li Jesuse: ―Oy c'usi chajac'boxuc jbeluc ec. Me chavalbicun li c'usi ta jac'boxuque, ja' o chacalboxuc ec li boch'o laj yac'bun jvu'el ti jech ta jpase. ");
INSERT INTO tzotze_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Li ich'vo' laj yac' Juane, ¿boch'o i'ac'bat yabtel ti jech la spase? ¿Me ac'bil yu'un Dios, o me ac'bil yu'un cristiano? ―xut. Jech tey lic yalilanbe sbaic: ―Me ta xcaltic ti ja' i'ac'bat yabtel yu'un Diose, jech ta xalbutic: “¿C'u yu'un muc xach'unic cha'e?” xijyututic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me ta xcaltic ti i'ac'bat yu'un cristianoe, pero chijxi' yu'un li cristianoetique yu'un scotol xch'unojic ti ja' yaj'alc'op Dios li Juane ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jech la stac'beic li Jesuse: ―Mu jna'cutic ―xiic. Jech i'albatic yu'un li Jesuse: ―Ja' jech mu'yuc ta xcalboxuc ec li boch'o laj yac'bun jvu'el ti jech ta jpase ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Li Jesuse lic yalbe jun lo'il: ―¿C'usi chanopic? Oy jun vinic oy chib xnich'nab. Li june jech laj yalbe: “Mol, batan ta abtel tey yo' bu jts'usubtique”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Itac'ov li xnich'one: “Mu xchi chca'i”, xi. Pero ts'acal to la snop ta yo'nton ti chbate, jech ibat. ");
INSERT INTO tzotze_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","La sc'opan li yan xnich'one. Ja' jech laj yalbe jech chac c'u cha'al laj yalbe li june. Itac'ov li xnich'one: “Lec oy, tati, xu' chibat”, xi. Pero muc xbat. ");
INSERT INTO tzotze_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Li vo'oxuque ¿c'usi chanopic? Li chib queremetique ¿boch'o junucal la xch'unbe smantal li stote? ―xut. Itac'ovic: ―Ja' li boch'o ba'yuc i'albate ―xiic. Li Jesuse jech laj yal: ―Melel li c'usi chacalboxuque, li boch'otic mu xch'unbeic smantal Dios chavilique, ja' li jtsobpatanetique xchi'uc li jmulvavil antsetique, pero ja' ta xac' xa sbaic ta ventainel yu'un Dios. Li vo'oxuque mu xac'anic ventainel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yu'un ti ital ta atojolic li Juan j'ac'vanej ta vo'e, ja' tal yalboxuc li c'usi lec chapasique, pero muc xach'unic. Yan li jtsobpatanetique xchi'uc li jmulavil antsetique ja' la xch'unic, jech la scomtsanic li c'usitic chopol ta spasique. C'alal laj avilic ti la scomtsanique, muc xacomtsanic ec li vo'oxuque. Muc xach'unic o. ");
INSERT INTO tzotze_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’A'yo ava'yic yan lo'il ta xcalboxuc. Oy jun vinic la sts'un ep ts'usub ta yosil. La set ta corral li sts'usube. La svom ton ja' yav sventa spits'ubil ya'lel li sts'usube. La spas jun toyol sq'uelubil osil. La sa'be yajval boch'otic ta xchabiic li ts'usubtic yu'une. Jech ibat ta nom li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’C'alal sta yorail i'ic'ub li sat sts'usube, la stac tal smozotac yu'un ta xich'beic batel li sat sts'usube. Ja' c'ot sc'anbeic li boch'otic ta xchabiique. ");
INSERT INTO tzotze_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero li jchabiejts'usubtique la stsaquic li mozoetique. Li june la smajic, li yane la smilic, li yane laj yac'beic ton. ");
INSERT INTO tzotze_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Li yajval osile lic stac tal yan smozotac noxtoc, ja' to más ep la stac tal. Pero ja' no'ox jech la spasbeic jech chac c'u cha'al la spasbeic li boch'o ba'yuc itacatic tale. ");
INSERT INTO tzotze_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ts'acal to xnich'on xa la stac tal. Jech laj yal ta yo'nton: “Ja' ta xich'ic ta muc' li jnich'one”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero c'alal laj yilic jchabiejts'usubtic ti ja' xa xnich'on li yajval osile, jech laj yalbe sbaic: “Le'e ja' xa ta xich'be comel yosil li stote. Ja' lec jmiltic jech vu'utic ta xquich'betic o comel li yosile”, xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jech la stsaquic, la sloq'uesic ta pat corral, tey la smilic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","C'alal ta sut tal li yajval ts'usubtique, ¿c'usi ta xc'ot spasbe xana'ic li jchabiejts'usubtique? ―xut jchapanvanejetic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Itac'ovic: ―Le'e ta xmilatic yu'un toj chopol li c'usi la spasique. Yan xa boch'o ta xac'be xchabi li sts'usube. Ja' ta sa' li boch'o lec xac' ta c'abal sat ts'usube ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Li Jesuse jech laj yalbe yan velta: ―Aq'uelojic c'usi chal ta svun Dios: Jech chac c'u cha'al yajval na la st'uj jbej ton sventa chac' ta chiquin na, pero li svinictac ta pasnae muc sc'anic. Li ton ti muc sc'anique ja' ono'ox i'och ta chiquin na. Ja' no'ox jech ec, ac'o me mu xc'anat li boch'o t'ujbil yu'un Diose, pero ta ono'ox xac'be tsots yabtel. Toj lec ti jech ta to spas li Diose, xi ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jech chacalboxuc, li vo'oxuque laj xa sc'oplal ti xu' chasventainoxuc Diose. Ja' xa ic'ot ta stojol li boch'otic ta spasic c'usitic tsc'an Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Li boch'otic chopol chiyilicune chopol chbatic o. Ta ono'ox jchapanbe smulic. Me laj cal ti ch'ayel chbatique, j'ech'el ibatic o ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","C'alal laj ya'yic c'usi la sloc'ta ta lo'il Jesús li banquilal paleetic xchi'uc fariseoetique, la sna'ic ti ja' ta sventa stuquique. ");
INSERT INTO tzotze_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jech la sa'ic c'uxi xu' ta stsaquic o li Jesuse. Pero ixi'ic yu'un li epal cristianoetique yu'un xch'unojic ti ja' yaj'alc'op Dios li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Li Jesuse jech lic yalbe lo'il yan velta li jchi'iltactique: ");
INSERT INTO tzotze_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Chacalboxuc ava'yic c'u x'elan ta spas mantal li Diose. Ja' jech chac c'u cha'al jun ajvalil la spas q'uin sventa ta xnupin xnich'on. ");
INSERT INTO tzotze_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","La stac batel smozotac yu'un chbat yiq'uic tal li boch'otic yalojbe xa ono'ox ti chtal sq'uelic q'uin nupinele. Pero muc sc'an xtalic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","La stac batel yan smozotac noxtoc. Jech laj yalbe batel: “Jech xavalbeic li boch'otic calojbe xa'ox ya'yique: Batic la, meltsanbil xa scotol li ve'lile, milbil xa li vacaxetique xchi'uc li c'usitic yan lec jubenique. Bat la jq'ueltic li nupinele, utic c'otel”, xut batel li smozotaque. ");
INSERT INTO tzotze_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero muc xch'unic yu'un mu tsotsuc sc'oplal laj ya'yic. Ja' bat spasic li c'usi tsc'an yo'nton stuquique. Li june bat sq'uel c'usitic sts'unoj. Li yane bat bolomajuc. ");
INSERT INTO tzotze_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Li yantique la stsaquic li mozoetique, laj yuts'intaic, la smilic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","C'alal laj ya'i li ajvalile, i'ilin. La stac batel yajsoldadotac yu'un ac'o bat smilic li boch'otic imilvanique. La xchic'beic ta c'oc' noxtoc li slumalique. ");
INSERT INTO tzotze_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Li ajvalile jech laj yalbe noxtoc li yan smozotaque: “Chapal xa scotol li q'uin sventa nupinele pero li boch'o ic'bilic cu'une muc xich'ic ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ja' lec batanic ta bebetic. Iq'uic tal li boch'otic chataique, ac'o tal sq'uelic li q'uin nupinele”, xut batel. ");
INSERT INTO tzotze_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jech iloq'uic batel li smozotaque, ibatic ta bebetic. Laj yiq'uic tal scotol li boch'otic la staique. Tey capal italic li boch'otic chopolique xchi'uc li boch'otic lequique. Inoj scotol li na bu ta spasic q'uine yu'un toj ep italic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Li ajvalile i'och sc'opan li boch'otic la stac ta iq'uele. Tey laj yil jun vinic ti mu ja'uc slapoj li c'u'il yac'oj sventa nupinele. ");
INSERT INTO tzotze_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jech laj yalbe: “Vo'ote, ¿c'uxi la'och tal li'i yu'un mu ja'uc alapoj li c'u'il sventa nupinel ti cac'oj ja' chalapique?” xut. Muc xtac'ov ic'ot li vinique. ");
INSERT INTO tzotze_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Li ajvalile jech laj yalbe li smozotaque: “Chucbeic yoc sc'ob li vinique. Jipic ochel yo' bu toj ic' li osile. Tey chc'ot yoc'ta sba o, tey xc'uxet o ye ta scoj ti tsots castigo chich'e”, xi li ajvalile. ");
INSERT INTO tzotze_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ja' svinajeb ti scotol ic'bilic yu'un Diose pero jutuc no'ox li boch'o t'ujbilique, yu'un jutuc no'ox li boch'o tsc'anique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Li fariseoetique bat snopic c'usi ta sjac'beic li Jesuse yu'un jech cha'yic c'uxi ta xtac'ov, yu'un jech xu' ta stabeic o smul yalojic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jech la staquic batel yajchanc'optaquic xchi'uc svinictac Erodes. Jech vul sjac'beic li Jesuse: ―Jchanubtasvanej, ta jna'cutic ti melel scotol c'usi chavale, ti co'ol jamal chavalbe ya'yic c'usi tsc'an Diose. Muc ta sbauc no'ox chaq'uel c'u x'elan li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Alo ca'icutic c'usi chanop. ¿Me lec chil Dios ti ta xcac'be jpatantic li Césare, o me mu lecuc chil? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Li Jesuse la sna' ti ja' no'ox ta xlo'lavanique, jech laj yalbe: ―¿C'u yu'un tal aq'uelic c'u x'elan co'nton? Jlo'lavanejoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tsaquic tal junuc li taq'uin sventa ta jtoj o jpatantique ―xut. Jech bat yich'beic tal jun denario taq'uin. ");
INSERT INTO tzotze_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jech ijac'batic yu'un li Jesuse: ―¿Boch'o sloc'obbal li'i? ¿Boch'o sbi li'i? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Itac'ovic: ―Ja' César ―xiic. Jech i'albatic yu'un li Jesuse: ―Tsc'an ta jch'unbetic c'usi ja' yabtel ta xal li Césare yu'un ja' muc'ta ajvalil. Jech noxtoc tsc'an ta jch'unbetic c'usi ta xal li Diose ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","C'alal laj ya'yic c'u x'elan itac'ov li Jesuse, toj ch'ayel ic'ot yo'ntonic, jech ibatic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta jliquel tey italic jayibuc saduceoetic noxtoc, ja' ti chalic mu'yuc cha'cuxesele. Jech vul sjac'beic li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Jchanubtasvanej, jech la sts'iba comel li Moisés ta vo'onee: “Me oy ta xcham jun vinic, me mu'yuc xnich'on chcome, li its'inal ti mu'yuc to yajnile, ac'o yic'be yajnil li ánima sbanquile. C'alal ta xvoc' xnich'one, ja' chac'be sbiinbe sbi li sbanquile, jech tey oy o sbi li sbanquile”, xi li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oy vucub jchi'iltic xchi'il no'ox sbaic ta voq'uel. Li banquilale la sa' yajnil. Pero icham li banquilale, mu'yuc xnich'on icom. Li its'inale laj yic'be yajnil li ánima sbanquile. ");
INSERT INTO tzotze_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","27","Ja' jech la spasic scotolic. Xquechet laj yic'beic li yajnil sba sbanquilique yu'un ichamic. Ts'acal to icham ec li antse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","C'alal ta xcha'cuxiique, ¿boch'o junucal yajnil chc'ot li antse yu'un scotol laj yic' yajnilinic? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Itac'ov li Jesuse: ―Mu to xana'ic c'usi chal li sc'op Diose. Mu xana'ic c'u x'elan stsatsal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","C'alal ta xcha'cuxiique, mu'yuc xa yajnil viniquetic, mu'yuc xa smalal antsetic. Ja' xa jechic jech chac c'u cha'al yaj'almantaltac Dios ta vinajel. ");
INSERT INTO tzotze_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ti jech mu'yuc ach'unojic ti ta xcha'cuxiic ánimaetique, ¿me yu'un mu'yuc aq'uelojic c'usi laj yal Dios ta sventa li Abraáme, xchi'uc li Isaaque, xchi'uc li Jacove? Ac'o me ep xa jabil chamenic, pero jech to ta x'albat sc'oplalic: ");
INSERT INTO tzotze_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Vu'un Diosun yu'un Abraám, xchi'uc Isaac, xchi'uc Jacov”, xi li Diose yu'un cuxulic. Ti chamenicuc o c'alal ta xch'ulelic jech chac c'u cha'al chavalique, mu'yuc xa Dios yu'unic ti jechuque. Yu'un li Diose mu ja'uc Dios yu'un li boch'otic chamenic oe; ja' Dios yu'un li boch'otic cuxajtique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","C'alal laj ya'yic scotol jchi'iltactic ti jech laj yal li Jesuse, toj ch'ayel ic'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","C'alal laj ya'yic a'yej fariseoetic ti muc sna'ic staq'uel ic'ot li saduceoetique, jech la stsob sbaic tal ta stojol li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tey oy jun fariseo, ja' jchanubtasvanej ta smantal Dios yaloj. Jech la sjac'be li Jesuse yu'un ta sq'uel c'u x'elan ta xtac'ov: ");
INSERT INTO tzotze_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Jchanubtasvanej, scotol smantal Dios ti laj yal comel Moisés ta vo'onee, ¿c'usi mantalil ti más tsots sc'oplale? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Itac'ov li Jesuse: ―“C'anic me ta scotol avo'ntonic li Dios cu'untique. Ac'bo sventain avo'ntonic xchi'uc abijilic, ac'o tunuc yu'un”, xi li mantale. ");
INSERT INTO tzotze_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja' sba mantal ti más tsots sc'oplale. ");
INSERT INTO tzotze_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Li xchibale co'ol tsots sc'oplal xchi'uc li sba mantale. Jech ta xal: “C'anic me achi'ilic jech chac c'u cha'al c'ux ta avo'nton abec'tal atuquique”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Li chib mantal li'i stsacoj xa sba scotol xchi'uc li yan mantaletique xchi'uc li c'usitic laj yalic yaj'alc'optac Dios ta vo'onee ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","C'alal tey jmoj tsobolic li fariseoetique, tey lic sjac' sc'oplal stuc li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿C'usi chanopic? ¿Boch'o smoltot ta vo'one li Cristo ti t'ujbil yu'un Dios chventainvane? ―xut. Itac'ovic: ―Ja' smoltot li Davide ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Li Jesuse jech la sjac'be yan velta: ―Me ja' smomnich'on Davide, ¿c'u yu'un “Cajval” xi li Davide? Yu'un ta sventa Ch'ul Espíritu jech la sts'iba li Davide: ");
INSERT INTO tzotze_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Li Cajvale jech i'albat yu'un li Diose: “Ta to xlic chotlan ta jbats'ic'ob. Vo'ot chapas mantal c'alal to ta jtsalbot scotol li avajcontrae”, x'utat, xi li Davide. ");
INSERT INTO tzotze_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Li Davide “Cajval”, xut li boch'o t'ujbil yu'un Dios chventainvane. ¿C'u yu'un “Cajval”, xut me ja' smomnich'one? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Me junuc mu'yuc boch'o itac'ov yu'unic. Jech mu'yuc xa c'usi yan la sjaq'uic o. ");
INSERT INTO tzotze_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Li Jesuse lic sc'opanuncutic, vu'uncutic li yajchanc'opuncutique, xchi'uc li epal cristianoetic tey stsoboj sbaique. Jech laj yalbuncutic: ");
INSERT INTO tzotze_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Li boch'otic ta xchanubtasvanic ta smantal Dios yalojique xchi'uc li fariseoetique, ja' comenic ta xq'uexol li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jech ch'unic me li sc'op Dios ta xalboxuque. Ja' no'ox mu me jechuc xapasic jech chac c'u cha'al ta spasique. Yu'un li sc'op Dios chalique mu spas stuquic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xco'laj xchi'uc ta smeltsanic icatsil ti toj ole ti vocol chlic ta cuchele. Ja' no'ox ta xac'beic xcuch yan cristianoetic, pero li stuquique mu j'ech'el xlic yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Scotol li c'usi ta spasique ja' no'ox ta sc'anic ti lec ac'o ilaticuc yu'un cristianoetique. Smuq'uibtasojbeic li xcaxail smantal Dios ta snaban ta sc'obic o me ta stibaic c'alal ta sc'opanic Diose. Xchi'uc li sc'u' ta slapique nat stsitsumal spasojic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lec ta xa'yic ta xchotiic ta sliqueb chotlebal ta jujun q'uin. Jech noxtoc lec ta xa'yic ta xchotiic ta sliqueb chotlebal ta nail tsobobbailetic cu'untic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lec ta xa'yic me ta xich'ic c'opanel yu'un jchi'iltactic tey ta ch'ivit. Lec ta xa'yic ti “Jchanubtasvanej”, xi sc'oplalic yu'un li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero li vo'oxuque mu me xac'anic ti “Jchanubtasvanej” xa'utatique. Yu'un jun no'ox li Jchanubtasvanej avu'unique, ja' vu'un ti t'ujbilun yu'un Dios chajventainoxuque. Li vo'oxuque achi'il no'ox aba acotolic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mu me boch'o xacuy ta atotic li' ta banamile. Yu'un jun no'ox li Jtotique, ja' ti tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mu me xac'anic ti “Cajval” xa'utatique. Yu'un jun no'ox li avajvalique, ja' vu'un ti t'ujbilun yu'un Dios chajventainoxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Li boch'o banquilal avu'unique biq'uit ac'o yac' sba ta atojolic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Boch'o junucal ta stoy sba ta atojolique ja' ta x'ac'at ta q'uexlal yu'un li Diose. Yan li boch'o junucal biq'uit ta xac' sba ta atojolique, ja' ta x'ac'at ta ich'el ta muc' yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Yu'un chapajesic li boch'otic tsc'anic ventainel yu'un Diose. Yu'un li vo'oxuque mu xac'anic ventainel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Altic ti jal chac'opanic Diose, yu'un ta to xalo'labeic c'usitic oy yu'un li me'on antsetique. Jech más tsots cha'ac'batic castigo. ");
INSERT INTO tzotze_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Chavac' avocol chasa'ilanic me oy bu chata junuc avajchanc'opic. Me laj ataique, más to chopol chbat avu'unic. Jech vo'oxuc ta acojic ti chbat yich' castigo ta muc'ta c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Vo'oxuque ja' jechoxuc jech chac c'u cha'al ma'sat. Chavich'ic tsots castigo yu'un chavaq'uic ta ilel be avalojic. Jech chavalic: “Boch'o ta xal ti ja' testigo yu'un li temploe, mu persauc ta spas li c'usi ta xale. Yan li boch'o ta xal ti ja' testigo yu'un li c'anal taq'uin tey ta temploe, ja' persa ta spas li c'usi ta xale”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mu xana'ic. Ja' jechoxuc jech chac c'u cha'al ma'sat. Yu'un mu ja'uc tsots sc'oplal li c'anal taq'uine; ja' tsots sc'oplal li templo yo' bu oy c'anal taq'uine yu'un ja' tey ch‑ac'bat smoton li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jech chavalic noxtoc: “Boch'o ta xal ti ja' testigo yu'un li scajleb smoton Diose, mu persauc ta spas li c'usi chale. Yan li boch'o ta xal ti ja' testigo yu'un li milbil smoton Dios tey cajanbile, ja' persa ta spas li c'usi ta xale”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mu xana'ic. Ja' jechoxuc jech chac c'u cha'al ma'sat. Yu'un mu ja'uc tsots sc'oplal li smoton Diose; ja' tsots sc'oplal li scajleb yo' bu ta xchic'bat smoton Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Boch'o ta xal ti ja' testigo yu'un li scajleb smoton Diose, testigo xa ic'ot o yu'un c'alal ta smoton Diose ti tey cajanbile. ");
INSERT INTO tzotze_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jech noxtoc boch'o ta xal ti ja' testigo yu'un li temploe, testigo xa ic'ot o yu'un noxtoc li Diose yu'un ja' tey nacal. ");
INSERT INTO tzotze_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Boch'o ta xal ti ja' testigo yu'un li vinajele, testigo xa ic'ot o yu'un c'alal ta smuc'ta chotleb li Diose, xchi'uc li Dios ti tey chotole. ");
INSERT INTO tzotze_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Yu'un ja' no'ox tsots sc'oplal chava'i chavatic ta lajlajuneb li c'usitic ats'unojique, ja' li yaravenoe, xchi'uc li anise, xchi'uc li cominoe. Jujun chaloq'uesic ta sventa smoton Dios. Pero ja' mu xapasic ti bu tsots sc'oplal smantal Dios ti laj yal comel Moisese. Mu tsotsuc sc'oplal chava'yic ti tuc' chachapanvanique, ti chac'uxubinvanique, ti melel c'usitic chavalique. Ja' lec ti lajuc apasic noxtoc ti bu tsots sc'oplale. ");
INSERT INTO tzotze_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Altic ti chavaq'uic ta ilel be avalojique yu'un ja' no'ox chach'unic ti bu mu tsotsuc sc'oplale. Yan ti bu tsots sc'oplale ja' mu xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Jech chac c'u cha'al li boch'o ja' no'ox ta spocbe spat li vasoe xchi'uc li platoe, yan li yute mu'yuc ta suq'uic, ja' nojem ta ic'ubal, ja' no'ox jechoxuc li vo'oxuque. Lecoxuc yilel pero li avo'ntonique nojem ta sc'upinel c'usitic oy yu'un achi'ilic. Chavalbeic ti oy c'usi ac'o yaq'uic ta sventa Diose pero vo'oxuc chavich' atuquic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Vo'oxuc ti fariseooxuque ja' jechoxuc jech chac c'u cha'al ma'sat. Ja' lec ac'o ta poquel ba'yuc li avo'ntonique, jech ta xlecub, jech lec noxtoc scotol li c'usi chapasique. ");
INSERT INTO tzotze_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Ja' jechoxuc jech chac c'u cha'al muquinaltic ti lec bonbil ta tane jech lec c'upil sba ta q'uelel. Pero ta yute nojem ta baquil ánimaetic xchi'uc scotol li c'usitic tey c'a'emique. ");
INSERT INTO tzotze_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ja' jechoxuc li vo'oxuque. Tuc' avo'ntonic yilel ta stojol li cristianoetique pero li yut avo'ntonique nojem ta lo'lavanej xchi'uc scotol c'usitic yan chopol. ");
INSERT INTO tzotze_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique xchi'uc vo'oxuc ti fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Yu'un vo'oxuc chacha'meltsanic xchi'uc chabonbeic lec smuquinal li j'alc'opetic ta vo'one ti tuc' yo'ntonique. Pero mu xach'unic li c'usitic laj yalic ta jventae. ");
INSERT INTO tzotze_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Altic ti jech chavalbeic li cristianoetique: “Ti oyuncuticuc xa'ox c'alal ijelovic li jmoltotactic ta vo'onee, mu'yuc la jch'uncutic ti ta jmilcutic li j'alc'opetic ti jechuque”, xavutic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ja' svinajeb ti co'ol avo'nton achi'uquic li boch'otic la smilic li j'alc'opetic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Vo'oxuc to chats'acubtasbeic c'usi la spasic li amoltotaquic ta vo'onee yu'un po'ot xa chapasbicun jech ec. ");
INSERT INTO tzotze_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Li amoltotique ja' jechic jech chac c'u cha'al orachon. Ja' no'ox jechoxuc ec li vo'oxuque, orachonoxuc ya'yel ec yu'un co'ol avo'nton achi'uc li amoltotique. Mu xu' avu'un chapoj abaic, persa ono'ox ta xbat avich'ic castigo tey ta muc'ta c'oc'. ");
INSERT INTO tzotze_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jech ta to jtacboxuc tal j'alc'opetic ti lec bijique, ti lec sna' xchanubtasvanic ta sventa c'usi tsc'an Diose. Oy ta xlic amilic, oy chlic ajoc'anic ta cruz, oy chlic avac'beic nucul ta yut nail tsobobbailetic avu'unic, oy chlic ataquic loq'uel ta jujun lum tey ta avosilalic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jech vo'oxuc chcom ta aventaic ti imilatic scotol li boch'otic tuc' yo'ntonique. C'alal imilat li Abele, ja' li tuq'uil vinique, xchi'uc c'alal to imilat ta yamaq'uil templo ta nopol scajleb smoton Dios li Zacaríase, ja' li xnich'on Berequíase, vo'oxuc chacuchinic scotol. ");
INSERT INTO tzotze_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Melel li c'usi chacalboxuque, scotol chacuchinic, vo'oxuc ti li' to oyoxuc ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Vo'oxuc ti li' nacaloxuc ta Jerusalene, atalelic o ti chamilic li yaj'alc'optac Diose. Chavac'beic ton li boch'otic tacbilic tal yu'un Dios li' ta atojolique. Pero ep xa velta la jc'an ta jtsoboxuc jech chac c'u cha'al ta stsob yol ta yolon xic' jcot me'caxan, pero muc xac'anic. ");
INSERT INTO tzotze_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A'yo ava'yic, ta me xacom atuquic. Muc xa li'uc ta xchi'inoxuc li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jech chacalboxuc, mu'yuc xa bu chavilicun o. Ja' to me la sta yorail ti jech chavalique: “Toj lec li boch'o tacbil tal yu'un Cajvaltic Diose”, me xachiique, ja' to xu' chavilicun yan velta ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","C'alal chitotscutic xa tal ta yamaq'uil templo tey ta Jerusalén xchi'uc li Jesuse, tey laj cac'becutic yil ti toj c'upil sba pasbil li temploe xchi'uc li naetic teye. ");
INSERT INTO tzotze_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Li Jesuse jech laj yalbuncutic: ―Laj xa avilic scotol li'i. Melel li c'usi chacalboxuque, me jbejuc ton mu'yuc bu cajal ta xcom ta sba yac'ol yan ton, yu'un ta to sta yorail chtal vuq'uesatuc yu'un yan cristianoetic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Li Jesuse tey bat chotluc ta vits Olivatic. Tey libatcutic ec, vu'uncutic li yajchanc'opuncutique. Jech la jac'becutic li Jesuse: ―Alo ca'icutic c'usi ora ta xc'ot ta pasel ti ta xvuq'uesat li templo laj avale. ¿C'usi sq'uelubil chavac' quilcutic ti c'alal chacha'tale? ¿C'usi sq'uelubil ta jq'uelcutic noxtoc ti c'alal po'ot xa slajebal c'ac'ale? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Itac'ov li Jesuse: ―Q'uelo me abaic, mu me boch'o xaslo'laoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yu'un oy ep boch'o ta xalic sbiic jech chac c'u cha'al jbi vu'un. Jech ta xalic: “Vu'un Cristoun ti t'ujbilun yu'un Dios chajventainoxuque”, xiic. Jech ep boch'tic ta xlajic ta lo'lael. ");
INSERT INTO tzotze_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","C'alal chava'yic ti oy pleito li'i xchi'uc c'alal chava'yic ti oy pleito ta nome, mu me xaxi'ic. Ta persa jech ta xc'ot ta pasel pero muc to ja'uc slajebal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta to xlic scontrain sbaic cristianoetic ta yantic banamil. Ta to xlic scontrain sbaic ajvaliletic noxtoc. Ta to xtal tsots vi'nal xchi'uc chamel. Ta x'ech' niqueletic ta buticuc no'ox banamil. ");
INSERT INTO tzotze_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero le'e ja' sliquebal to vocol. ");
INSERT INTO tzotze_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ta to xa'ac'atic ta c'abal yu'un jech chavich'ic vocol, oy tey ta smiloxuc o. Ep cristianoetic chopol chayiloxuc pero vu'un ta jcoj. ");
INSERT INTO tzotze_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta sc'ac'alil le'e oy ep boch'otic ta xchibaj yo'ntonic. Li boch'o ta xchibaj yo'ntonique chopol chilic li boch'otic mu xchibaj yo'ntonique. Chalic ti bu oyique yu'un ac'o tsacaticuc. ");
INSERT INTO tzotze_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta xlic ep jlo'lavanej j'alc'opetic. Ep boch'otic ta xlajic ta lo'lael. ");
INSERT INTO tzotze_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Toj ech'em ta x'epaj li c'usi chopole jech ep boch'otic chopol chlic yil xchi'ilic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero li boch'o ta xcuch yu'un c'alal to ta slajebe ja' ta xcolic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero ta persa ba'yuc ta xich' cholel ta scotol banamil li lequil a'yeje, ja' ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. Ja' to ta xtal li slajebal c'ac'ale ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Li c'usi ta jts'ibaboxuc tal li'i, a'ibeic me lec smelol yu'un jech laj yalbuncutic li Jesuse: ―C'alal chavilic tey xa va'anbil ta yut templo c'usi chopol chil Dios jech chac c'u cha'al laj yal li j'alc'op Daniel ta vo'onee, jatovanic batel ta anil ta vitsetic, vo'oxuc ti li' nacaloxuc ta Judeae. ");
INSERT INTO tzotze_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Li boch'otic tey oyic ta sjol snaique, c'alal ta xyalic tale, mu xa me x'och yich' c'usitic oy yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Li boch'otic tey oyic ta yabtelique, mu xa me sutic tal yu'un chtal yich' xaquitaic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Toj abul sbaic li boch'otic ja' to xchi'inoj yolique xchi'uc li boch'otic ta to xchu'un yolique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","C'opanic Dios ti mu me ja'uc ta yorail sictic xchi'uc mu me ja'uc ta sc'ac'alil chacux avo'ntonic ti c'alal chajatovique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yu'un toj tsots li vocol ta xtale. Mu'yuc ono'ox jech c'alal ilic li banamile xchi'uc c'alal to tana. Mu'yuc xa yan jech vocol ta xtal c'alal me la sta sc'ac'alil le'e. ");
INSERT INTO tzotze_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti manchuc ta spajes vocol li Diose, mu'yuc boch'o ta xcol ti jechuque. Pero ta sventa li boch'o t'ujbilique jech ta spajes li vocole. ");
INSERT INTO tzotze_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Me oy boch'o jech ta xalboxuque: “Li' xa oy li Cristoe”, me xayutoxuque, o me oy boch'o yan jech chayalboxuc: “Le' xa oy li Cristoe”, me xayutoxuque, mu me xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yu'un ta to xtal li boch'otic ta xalic ti ja' t'ujbilic yu'un Dios chasventainoxuc yalojique, xchi'uc ta xalic ti ja' yaj'alc'optac Diose, pero altic chalic. Ta spasic sq'uelubiltac ti xu' yu'unique yu'un jech ta slo'laic o li cristianoetique. Tsc'an ta slo'laic ec li boch'o t'ujbilic yu'un Diose pero mu xu' yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Q'uelo me abaic li vo'oxuque yu'un ba'yuc xa laj calboxuc scotol. ");
INSERT INTO tzotze_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Me oy boch'o jech chayalboxuque: “Tey xa oy ta xocol banamil li Cristoe”, me xayutoxuque, mu me xaloq'uic batel yu'un chbat aq'uelic. “Tey xa oy ta yut na”, me xiique, mu xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yu'un ja' no'ox jech chac c'u cha'al sacsevul ti xleblej no'ox ta xquiltic buyuc no'ox oyutique, ja' jech scotol cristianoetic chilic c'alal chital, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jech chac c'u cha'al me oy c'usi chamene ta ono'ox stsob sbaic tal li xulemetique, ja' jech ta ono'ox xtal castigo ta stojol li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’C'alal me i'ech' scotol li vocol laj calboxuque, ja' o ta x'ic'ub li c'ac'ale. Mu'yuc chac' xojobal li ue. Li c'analetique ta xbaj yalel tal. Ta xnic scotol li c'usitic oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Scotol cristianoetic ta xilic c'u x'elan chital, vu'un ti co'ol cristianoutique. Scotol cristianoetic ta sbejel banamil ta x'oq'uic ta scoj xi'el. Yu'un ta xilic ti ep jtsatsal xchi'uc tsots jxojobal c'alal chiyal tal ta toc ta vinajel, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsots ta xich' jupanel oq'ues noxtoc. Jech ta xyal tal li j'almantaletic cu'une. Ja' ta xtal stsobic scotol li boch'otic t'ujbilic cu'un ta sbejel banamile. ");
INSERT INTO tzotze_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Chanbeic o smelol ta sventa c'u x'elan li igo te'e. C'alal ta x'uninaj sc'obe, ta xloc' yan yanal, jech chana'ic o ti po'ot xa yorail vo'olaltique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ja' no'ox jech ec li vo'oxuque, c'alal chavilic ta x'ech' scotol c'usi calojboxuque, jech chana'ic o ti po'ot xa yorail chicha'sut tal, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Melel chacalboxuc oy mu'yuc to chachamic ja' to me i'ech' scotol li c'usitic laj calboxuque. ");
INSERT INTO tzotze_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ta to xlaj li vinajel banamile, pero li c'usitic caloje mu'yuc ono'ox ta xlaj sc'oplal, ta xc'ot ta pasel scotol. ");
INSERT INTO tzotze_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Li c'usi ora chitale mu'yuc ono'ox boch'o ta sna', me ja'uc li j'almantaletic ta vinajele, me ja'uc vu'un li Nich'onilune. Ja' no'ox sna' stuc li Jtotique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Jech chac c'u cha'al la spasic cristianoetic ta vo'one ti c'alal li' to'ox oy li Noée, ja' no'ox jech ta spasic ec ti c'alal tsta yorail chital, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","C'alal mu'yuc to'ox ta xtal li pulel ta vo'e, ja' no'ox batem yo'ntonic ta sa'el sve'elic, ta xnupinic, xchi'uc ta xac' ta malijel stsebic. Ja' to iquechaj yu'unic ti c'alal ital pulel ta vo'e. ");
INSERT INTO tzotze_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mu'yuc ono'ox la xch'unic ti chtal pulel ta vo'e. Ja' to la xch'unic ti c'alal itale pero muc xa xcolic, ilaj scotolic. Ja' jech ta xc'ot ta pasel c'alal ta xital, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Me oy chib viniquetic ta x'abtejic ta yabtelique, jun ta xquic', jun ta xcom. ");
INSERT INTO tzotze_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Me oy chib antsetic ta xjuch'najique, jun ta xquic', jun ta xcom. ");
INSERT INTO tzotze_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Viq'uiluc me asatic cha'e, yu'un mu xana'ic c'usi ora chital, vu'un li Avajvalicune. ");
INSERT INTO tzotze_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Na'ic me, jech chac c'u cha'al yajval na ti mu sna' me oy ta xtal j'elec' ta ac'ubaltique. Ti sna'ojuque, muc xvay ti jechuque. Mu'yuc c'usi xbat ta elec' yu'un ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ja' no'ox jechoxuc ec li vo'oxuque, tsc'an ti lec chapaloxuque. Yu'un mu xana'ic c'usi ora chital, vu'un ti co'ol cristianoutique. Mu me ch'ayemuc avo'ntonic chvul jtaoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Li boch'o lequil mozoe jun yo'nton tey ta x'abtej ta stojol li yajvale. Ta x'ilat yu'un yajval ti lec bije, jech ta x'ac'bat yabtel yu'un ta smac'lin xchi'iltac ta abtel ti c'alal yorail ta xve'ique. ");
INSERT INTO tzotze_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xcuxet no'ox yo'nton li mozo ti jech jun yo'nton sbats'il spasel c'alal chvul taatuc yu'un yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Melel li c'usi chacalboxuque, li boch'o jun yo'nton ta x'abteje ta x'ac'bat sventain scotol li c'usitic oy yu'un yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero me chopol li mozoe, jech chlic yal ta yo'nton: “Mu to van xtal ta ora li cajvale”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jech chlic yuts'intaan li xchi'iltac ta abtel ac'bil sventaine. Ja' chbat xchi'in ta ve'el li boch'o lec sc'opan sba xchi'uque, co'ol ta xchi'in sbaic ta yacubel. ");
INSERT INTO tzotze_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Li yajvale ja' o ta xtal ti c'alal mu'yuc ta yo'nton ta smalae yu'un mu xch'un ti po'ot xa chtale. ");
INSERT INTO tzotze_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tsots chvul ac'batuc castigo yu'un li yajvale. Ja' chbat xchi'in li jlo'lavanejetique. Tey chc'ot yoc'ta sba, tey xc'uxet o ye ta scoj ti tsots castigo chich'e ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jech laj yalbuncutic yan lo'il li Jesuse: ―Chacalboxuc c'u x'elan chc'ot ta pasel c'alal chtal jpas mantale. Ja' jech chac c'u cha'al lajuneb tojol tsebetic ti laj yich'ic batel scandilic yu'un bat snupic ta be li boch'o ta xnupine. ");
INSERT INTO tzotze_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Li vo'obique lec bijic. Li yan vo'obe mu'yuc bijic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Li tsebetic ti muc bijicuque ja' no'ox laj yich'ic batel scandilic, mu'yuc laj yich'beic batel yan yaceiteil. ");
INSERT INTO tzotze_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yan li tsebetic ti lec bijique laj yich'ic batel yaceiteic ta yan yavil xchi'uc li scandilique. ");
INSERT INTO tzotze_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Li boch'o ta xnupine ijoc'tsaj. Li tsebetique ital svayelic jech ivayic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ta o'lol ac'ubal laj ya'yic oy boch'o tsots i'avan: “Ta xa xtal li boch'o ta xnupine. Loc'anic batel, bat nupic tal ta be”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ta ora ijulov scotolic. La smeltsan lec scandilic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Li tsebetic ti mu'yuc bijique jech laj yalbeic li boch'o bijique: “Ac'buncutic jutebuc avaceiteic yu'un ta xtu'p xa li jcandilcutique”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Itac'ovic li boch'otic bijique: “Mu xu'. Oy yic'al mu xloc' o cu'uncutic ec. Ja' lec bat manbeic tal li boch'o ta xchone”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","C'alal ja' o batemic ta smanele, ja' o ital li boch'o ta xnupine. Li yan tsebetic ti lec chapalique i'ochic yo' bu ta spasic q'uin nupinele. Li yajval nae la smac lec li ti'nae. ");
INSERT INTO tzotze_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ts'acal to italic li yan tsebetique. Jech laj yalic: “Cajval, Cajval, jambuncutic li ti'nae”, xiic vulel. ");
INSERT INTO tzotze_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jech itac'batic: “Melel li c'usi chacalboxuque, mu xacotquinoxuc”, x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Ja' jech li vo'oxuque, tsc'an ti viq'uiluc asatique yu'un mu xana'ic c'usi ora chital, vu'un ti co'ol cristianoutique. Me ta sob, me ta mal c'ac'al, me ta ac'ubaltic, mu xana'ic ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Laj yalbuncutic yan lo'il noxtoc li Jesuse: ―Chacalboxuc c'u x'elan chc'ot ta pasel c'alal chtal jpas mantale. Ja' jech chac c'u cha'al jun vinic ta xloc' batel ta nom. C'alal mu'yuc to'ox ta xbate, laj yic' tal li smozotaque. Laj yac'be sventain comel li staq'uine. ");
INSERT INTO tzotze_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Li june laj yac'be comel vo'mil, li yane laj yac'be comel cha'mil, li yoxibale laj yac'be comel jmil. Li boch'o lec bije ja' ep i'ac'bat. Yan li boch'o jutuc no'ox bije mu'yuc ep i'ac'bat. C'alal laj yac' comel ta c'abal li staq'uine, iloc' batel ta nom. ");
INSERT INTO tzotze_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Li boch'o i'ac'bat vo'mile bat sman sbolomal yu'un ta sjolintas li taq'uine. Jech ijolin yu'un vo'mil. ");
INSERT INTO tzotze_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ja' no'ox jech la spas ec li boch'o cha'mil no'ox i'ac'bate. Ijolin yu'un cha'mil ec. ");
INSERT INTO tzotze_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yan li boch'o jmil no'ox i'ac'bate bat smuc ta banamil. La snac'be staq'uin li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’C'alal ep xa'ox c'ac'al sbatel li yajvalique, isut tal. Laj yic'an tal li smozotaque, la sjac'be c'u yepal ijolin yu'unic li taq'uine. ");
INSERT INTO tzotze_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ja' ba'yuc ital li boch'o vo'mil yich'oj comele, tey yich'oj tal li vo'mil ijolin yu'une. Jech vul yalbe li yajvale: “Cajval, li' oy li vo'mil ataq'uin laj avac'bun comele xchi'uc li yan vo'mil ijolin cu'une”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jech i'albat yu'un li yajvale: “Lec oy, tsaco tal. Vo'ot lequil jmozoot yu'un jun avo'nton la'abtej ta jventa. Jutuc no'ox laj cac'bot, pero li' ta ora chacac'bot yan más ep. La' ta jtojol jech xcuxet no'ox avo'nton sbatel osil”, x'utat yu'un li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ital ec li boch'o yich'oj cha'mile, jech vul yalbe li yajvale: “Cajval, li' oy li cha'mil ataq'uin laj avac'bun comele xchi'uc li yan cha'mil ijolin cu'une”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jech i'albat yu'un li yajvale: “Lec oy, tsaco tal. Vo'ot lequil jmozoot yu'un jun avo'nton la'abtej ta jventa. Jutuc no'ox laj cac'bot pero li' ta ora chacac'bot yan más ep. La' ta jtojol jech xcuxet no'ox avo'nton sbatel osil”, x'utat yu'un li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ital ec li boch'o jmil no'ox yich'oje, jech vul yalbe li yajvale: “Cajval, la jna' ti tsots avo'ntone. Ja' jechot jech chac c'u cha'al li boch'o ta sc'aj ti muc ja'uc la sts'une, xchi'uc ta stsob ti bu muc ja'uc laj yic'ae. ");
INSERT INTO tzotze_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jech lixi' me ta xch'ay cu'un li ataq'uine, jech bat jmuc ta banamil. Ich'o sutel yu'un ja' ono'ox avu'un”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jech i'albat yu'un li yajvale: “Toj chopolot, ch'ajil mozoot. Chanop ti vu'un ta xquich' ti bu mu vu'cun la jts'une xchi'uc ti bu mu vu'cun laj quic'ae. ");
INSERT INTO tzotze_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ja' lec ti lajuc avac'be li boch'o sna' sjolintasel li jtaq'uine. C'alal litale, laj xa quich' sutel xchi'uc sjol ti jechuque”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Li yajvale jech laj yalbe li yan smozoe: “Pojbo li jmil cac'ojbee, ja' ac'bo li boch'o laj yich' tal lajunmile”, xut. ");
INSERT INTO tzotze_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ja' no'ox jech ec li boch'o ch‑abtej xchi'uc li c'u yepal i'ac'bate ta to x'ac'bat ep yu'un li Diose, ma'uc no'ox ta x'ac'bat ti c'u yepal chtun yu'une. Yan li boch'o mu x'abtej xchi'uc li c'u yepal i'ac'bate ta xpojbat sutel. ");
INSERT INTO tzotze_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Li ch'ajil mozo li'i jipo ochel yo' bu toj ic' li osile. Tey chc'ot yoc'ta sba, tey xc'uxet o ye ta scoj ti tsots castigo chich'e ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jech laj yalbuncutic li Jesuse: ―C'alal chtal ochcun ta ajvalilal, vu'un ti co'ol cristianoutique, ta jchi'in tal scotol li j'almantaletique. Ja' o chlic jchapan scotol li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta jtsob tal ta jtojol scotol li cristianoetique. C'alal tey xa stsoboj sbaic ta jtojole, ta xlic jvoc'an jech chac c'u cha'al jchabichij ti slecoj ta xac' li xchije xchi'uc li stentsune. ");
INSERT INTO tzotze_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Scotol li jchijtaque ja' chcac' ta jbats'ic'ob. Yan li tentsunetique ja' chcac' ta jts'et. ");
INSERT INTO tzotze_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Vu'un li muc'ta ajvalilune jech chcalbe li boch'otic tey oyic ta jbats'ic'obe: “La'ic yu'un lecubtasbiloxuc xa yu'un li Jtote. Ochanic ta pasmantal yu'un jech ono'ox xchapanoj ta vo'one ti c'alal la spas banamile. ");
INSERT INTO tzotze_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yu'un c'alal livi'naje, laj avac'bicun jve'el. C'alal itaquij co'ntone, laj avac'bicun yoxo' cuch'. Ac'o me muc xavotquinicun, laj aviq'uicun ochel ta anaic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","C'alal t'analune, laj avac'bicun jc'u'. C'alal ipune, ay avu'lanicun. C'alal ochemun ta chuquele, ay aq'uelicun”, chcut. ");
INSERT INTO tzotze_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jech ta xtac'ovic li boch'otic tuc' yo'ntonique: “Cajval, ¿baq'uin laj quilcutic ti lavi'naje ti laj cac'cutic ave'ele? ¿Baq'uin laj quilcutic ti taquin avo'ntone ti laj cac'cutic yoxo' avuch'e? ");
INSERT INTO tzotze_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Baq'uin ti muc xacotquinotcutic ti laj quic'ot ochel ta jnacutique? ¿Baq'uin laj quilcutic ti t'analote ti laj cac'cutic ac'u'e? ");
INSERT INTO tzotze_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Baq'uin laj quilcutic ti ipote ti ay jq'uelotcutique? ¿Baq'uin laj quilcutic ti ochemot ta chuquele ti ay jq'uelotcutique?”, xi chtac'ovic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Vu'un li muc'ta ajvalilune jech ta jtac'be: “Melel li c'usi chacalboxuque, yu'un ja' jech laj apasbeic jun quermano ti mu'yuc ich'bil ta muq'ue, pero vu'un laj ac'uxubinicun o ic'ot”, chcut. ");
INSERT INTO tzotze_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Vu'un li muc'ta ajvalilune jech chcalbe li boch'otic tey oyic ta jts'ete: “Voc'o abaic ta jtojol yu'un toj chopoloxuc. Batanic ta c'oc' sbatel osil. Ja' li c'oc' ti meltsanbil xa cu'un sventa tey ta x'och batel li banquilal pucuje xchi'uc li its'inal pucujetique. ");
INSERT INTO tzotze_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yu'un c'alal livi'naje, muc xavac'bicun jve'el. C'alal itaquij co'ntone, muc xavac'bicun yoxo' cuch'. ");
INSERT INTO tzotze_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","C'alal muc xavotquinicune, muc xaviq'uicun ochel ta anaic. C'alal t'analune, muc xavac'bicun jc'u'. C'alal ipune xchi'uc c'alal ochemun ta chuquele, muc x'ay aq'uelicun”, chcut. ");
INSERT INTO tzotze_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jech ta xtac'ovic ec: “Cajval, ¿baq'uin laj quilcutic ti lavi'naje, ti itaquij avo'ntone, ti muc xacotquinotcutique, ti t'analote, ti ipote, ti ochemot ta chuquele, ti muc xajc'uxubinotcutic chavale?” xi chtac'ovic. ");
INSERT INTO tzotze_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jech ta jtac'beic: “Melel li c'usi chacalboxuque, yu'un muc xac'uxubinic junuc li boch'o mu'yuc ich'bil ta muq'ue, jech muc xac'uxubinicun o ic'ot ec”, chcut. ");
INSERT INTO tzotze_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jech chbat yich'ic castigo sbatel osil. Yan li boch'otic tuc' yo'ntonique ja' ta xcuxiic sbatel osil ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","C'alal laj yo'nton ta lo'il li Jesuse, jech lic yalbuncutic noxtoc, vu'uncutic li yajchanc'opuncutique: ");
INSERT INTO tzotze_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Xana'ic ti chib xa c'ac'al sc'an li q'uin coltaele. Ja' xa yorail ta xi'ac'at ta c'abal, vu'un ti co'ol cristianoutique. Ta sjoc'anicun ta cruz ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li jchapanvanejetic cu'untique, la stsob sbaic tal ta yamac' li más banquilal palee, ja' li Caifase. ");
INSERT INTO tzotze_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","La xchapanic c'uxi xu' ta stsaquic ta mucul li Jesuse yu'un ta smilic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jech laj yalbe sbaic: ―Ja' lec mu jpastic ta sc'ac'alil li q'uine yu'un naca me sliquesic pleito li cristianoetique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Libatcutic ta Betania xchi'uc li Jesuse. Tey lic'otcutic ta sna Simón, ja' li boch'o tsacbil to'ox ta c'a'el chamele. ");
INSERT INTO tzotze_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tey ital jun ants yich'oj tal slimita pasbil ta alabástro ton. Nojem ta muil poxil. Bats'i toyol stojol. La smalbe ta sjol Jesús ti c'alal tey chotol ta ti' mesae. ");
INSERT INTO tzotze_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","C'alal laj quilcutic, vu'uncutic li yajchanc'opuncutique, li'ilincutic. Jech laj calcutic: ―¿C'u yu'un jeche' no'ox ta xlaj li muil poxile? ");
INSERT INTO tzotze_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ja' lec ti lajuc xchone yu'un toyol stojol. Li stojole xu' ta x'ac'bat me'onetic ―xichicutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Li Jesuse la sna' li c'usi la jnopcutique, jech lic yalbuncutic: ―¿C'u yu'un chavaq'uic lo'ilajuc yo'nton li antse yu'un lec li c'usi la spasbune? ");
INSERT INTO tzotze_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Li me'onetique scotol c'ac'al li' achi'uquic. Yan li vu'une mu scotoluc c'ac'al li' jchi'inojoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ti jech la smalbun muil poxil li antse ja' senyail ti ta xquich' muquele. ");
INSERT INTO tzotze_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Melel li c'usi chacalboxuque, buyuc no'ox ta xich' cholel ta sbejel banamil ti ja' no'ox chcolic ta jventae, tey ta xalic noxtoc c'usi la spasbun li antse. Jech ta sna'ic o scotol cristianoetic ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Vu'uncutic li lajchabuncutique oy jun jchi'ilcutic ja' Judas Iscariote sbi. Ja' bat sc'opan li banquilal paleetique. ");
INSERT INTO tzotze_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jech laj yalbe: ―¿C'u yepal taq'uin chavac'bicun me chacac'bot ta ac'obic li Jesuse? ―xut. Tey i'ac'bat lajuneb xcha'vinic ta sep saquil taq'uin. ");
INSERT INTO tzotze_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Li Judase ja' xa no'ox la smala c'usi ora xu' chac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta sliquebal q'uin c'alal ta jve'tic pan ti mu'yuc yich'oj svolesubil xch'ute, jech bat jac'becutic Jesús, vu'uncutic li yajchanc'opuncutique: ―¿Bu chac'an ta xbat jmeltsancutic li ch'ium chij chati' ta sventa q'uin coltaele? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Itac'ov li Jesuse: ―Batanic ta Jerusalén. Tey chc'ot ac'opanic li quermanotique. Jech xavalbeic: “Jutuc xa la sc'an sta yorail ta xcham li Jchanubtasvanej cu'untique. Li' la chtal jti'cutic ta ana li chij sventa q'uin coltaele”, utic c'otel ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vu'uncutic li yajchanc'opuncutique la jch'uncutic c'usi laj yalbuncutic li Jesuse, la jmeltsancutic li ve'lil ta sventa q'uine. ");
INSERT INTO tzotze_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jliquel to yic'ubel osil tey chotoluncutic jcotolcutic ta ti' mesa xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","C'alal ja' o chive'cutique, jech lic yalbuncutic li Jesuse: ―Melel chacalboxuc, oy jun li' jchi'inojtic ti ja' chiyac'un ta c'abale ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","C'alal laj ca'icutique, laj cat co'nton jcotolcutic. Ta jujuntal lic jac'becutic li Jesuse: ―¿Me vu'un van? Cajval ―xcutcutic liquel jujununcutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Itac'ov li Jesuse: ―Ja' li boch'o jun jsets' chive' jchi'uque ja' chiyac'un ta c'abal. ");
INSERT INTO tzotze_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta melel vu'un ti co'ol cristianoutique ta to xipasbat jech chac c'u cha'al ts'ibabil ono'ox ta sc'op Diose. Toj abul sba li boch'o chiyac'un ta c'abale. Ja' lec ti manchuc voc'uque ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Li Judase, ja' li boch'o snopoj xa ono'ox ta xac' ta c'abal li Jesuse, jech la sjac'be ec: ―¿Me vu'un van? Jchanubtasvanej ―xi. Itac'ov li Jesuse: ―Vo'ot ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","C'alal chive'cutique, la stam pan li Jesuse, la stojbe ta vocol Dios, la svoc' li pane, laj yac'buncutic jcotolcutic: ―Ilo, ve'anic. Li'i ja' jbec'tal ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","La stam noxtoc jun vaso ya'lel ts'usub, la stojbe ta vocol Dios, laj yac'buncutic. Jech laj yal: ―Uch'an acotolic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Li'i ja' jch'ich'al, ja' senyail ti mu xlaj sc'oplal li c'usi ach' la xchapan Jtot sventa chacolic oe. Yu'un jtuc chcac' jba ta milel, ta xloc' jch'ich'al, jech ta xtoj o smulic scotol cristianoetic. Jech ep boch'o tsta perdón yu'un smulic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta xcalboxuc ti mu'yuc xa ta xcuch' yan velta li ya'lel ts'usube. Ja' to ta xcuch' yan velta ti c'alal tey xa jtsoboj jba jcotoltic yo' bu chiyac'bun jpas mantal li Jtote ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","C'alal la jq'uejintacutic jun sq'ueoj Diose, liloc'cutic batel, libatcutic ta vits Olivatic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Li Jesuse jech laj yalbuncutic: ―Tanae acotolic chacomtsanicun. Yu'un jech ono'ox ts'ibabil ta sc'op Dios: “Ta xcac' ta milel li boch'o cac'ojbe yabtel chasventainoxuque. C'alal me imilate, tspuc sbaic batel li xchi'iltaque jech chac c'u cha'al tspuc sbaic batel chij me imilat li yajvalique”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","C'alal cha'cuxemun xa'oxe, vu'un ba'yuc chic'ot avu'unic ta Galilea banamil ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Itac'ov li Pedroe: ―Ac'o me ta scomtsanot scotolic, li vu'une mu'yuc chajcomtsanot ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Li Jesuse jech laj yalbe: ―Melel li c'usi chacalbote, tana c'alal mu'yuc to'ox ta x'oc' cotse, oxib xa'ox velta avaloj ti mu xavotquinune ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Itac'ov li Pedroe: ―Ac'o me co'ol chijcham, mu'yuc ta xcal ti mu xacotquinote ―xi. Ja' no'ox jech laj calcutic ec li vu'uncutique. ");
INSERT INTO tzotze_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tey lic'otcutic xchi'uc Jesús yo' bu Getsemaní sbie. Jech laj yalbuncutic li Jesuse: ―Chotlanic li'i yu'un ta xbat jc'opan Dios le'e ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Laj yic' ech'el Pedro xchi'uc li chib xnich'nab Zebedeoe. Lic yat yo'nton li Jesuse, toj yan sba yo'nton laj ya'i. ");
INSERT INTO tzotze_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jech laj yalbe: ―Toj loq'uel ta xcat co'nton ta xca'i, ta xicham o ya'yeluc. Comanic li'i. Mu me x'och avayelic, c'opanic Dios jech chac c'u cha'al ta jpas vu'une ―x'utatic li oxibique. ");
INSERT INTO tzotze_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ijelov batel jutuc li Jesuse. La spatan sba ta lumtic, la sc'opan Dios: ―Tati, ti xu'uc mu xichame, xu' chaloq'uesbun li jvocol li'i. Pero mu me xc'ot ta pasel li c'usi ta sc'an co'nton jtuque. Ja' ac'o jpas li c'usi tsc'an avo'ntone ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","C'alal laj yo'nton li Jesuse, isut tal yo' bu oyic li oxib jchi'iltaque. Vayemic vul taaticuc. Li Jesuse jech laj yalbe li Pedroe: ―¿Me muc xu' avu'unic laj acoltaicun ta sc'opanel Dios junuc ora? ");
INSERT INTO tzotze_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ja' lec julovanic, c'opanic Dios jech mu xach'unic sujel ta mulil. Ta melel chac'an chac'opanic Dios pero chastsaloxuc li abec'talique ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bat sc'opan Dios xchibal velta li Jesuse: ―Tati, me mu xu' chaloq'uesbun li jvocol li'i, xu' chicham jech chac c'u cha'al chac'ane ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Isut tal xchibal velta li Jesuse. Vayemic vul sta noxtoc yu'un solel chtal svayelic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tey la scomtsan yan velta yu'un ibat sc'opan Dios yoxibal velta. Ja' no'ox jech laj yal ti c'alal la sc'opan Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ital yoxibal velta li Jesuse, jech vul yalbe li jchi'iltaque: ―¿Me yoquel to chavayic? ¿Me yoq'uel to chacux avo'ntonic? Ista xa yorail chi'ac'at ta c'abal ta sc'ob jpasmuliletic, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Licanic, batic. Q'uelavilic, le' xa xtal li boch'o chiyac'un ta c'abale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","C'alal ja' o ta xlo'ilaj li Jesuse, ital li Judase, ja' jchi'ilcutic ti co'ol lajchabuncutique. Xchi'inoj tal ep cristianoetic, yich'anoj tal xmachitaic xchi'uc ste'ic. Ja' tacbilic tal yu'un li banquilal paleetique xchi'uc li jchapanvanejetic cu'untic, vu'utic li israelutique. ");
INSERT INTO tzotze_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Li Judase, ja' li j'ac'vanej ta c'abale, yaloj xa'ox c'u x'elan ta xac' ta ilel li Jesuse. ―Boch'o ta jts'uts'e ja' svinajeb ti ja' xae. Tsaquic ta ora ―xut ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Li Judase ta ora inoch'aj batel ta stojol li Jesuse, jech laj yalbe: ―Jchanubtasvanej ―xut. La sts'uts'. ");
INSERT INTO tzotze_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Li Jesuse lec la stac'be: ―¿Me yu'un ja' xa tal apas li c'usi anopoje? ―xut. La stsaquic li Jesuse, la xchuquic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Vu'uncutic ti tey jchi'inojcutic li Jesuse, la sloq'ues xmachita jun jchi'ilcutic, la sbojbe loq'uel jun xchiquin smozo li más banquilal palee. ");
INSERT INTO tzotze_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Li Jesuse jech laj yalbe: ―Tic'o ochel ta sna li amachitae. Li boch'o ta xac' machitae ja' no'ox jech ta machita ta xmilat ec. ");
INSERT INTO tzotze_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Me yu'un chanop ti mu xu' cu'un ta jc'opan ta ora li Jtote jech chistacbun tal ech'em ta oxvinic ta mil j'almantaletic yu'un chiscoltaun? ");
INSERT INTO tzotze_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero mu jechuc ta jpas. Yu'un ta persa chc'ot ta pasel c'usi ts'ibabil ta sc'op Dios ta vo'onee ti yaloj ono'ox jech ta to xc'ot ta pasele ―x'utat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Li Jesuse la sc'opan scotol li cristianoetique, jech laj yalbe: ―¿C'u yu'un tal atsaquicun ta machita, ta te', jech chac c'u cha'al j'elec'? Scotol c'ac'al tey chotolun ta yamaq'uil templo, tey lichanubtasvan. ¿C'u yu'un muc teyuc xatsaquicun? ");
INSERT INTO tzotze_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ti jech laj atsaquicune, yu'un ja' ic'ot o ti jech ono'ox ts'ibabil comel yu'un yaj'alc'optac Dios ta vo'onee ―xi li Jesuse. Vu'uncutic li yajchanc'opuncutique lijatovcutic batel jcotolcutic, stuc xa tey la jcomtsancutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","C'alal la stsaquic li Jesuse, laj yiq'uic batel ta stojol Caifás, ja' li más banquilal palee. Tey stsoboj sbaic li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li jchapanvanejetic cu'untique. ");
INSERT INTO tzotze_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Li Pedroe ta nomnomtic ibat ta spat Jesús c'alal to ic'ot ta yamac' li más banquilal palee. Tey i'och batel, la xchi'in ta chotlej yajmayoltac li banquilal palee yu'un tsc'an ta sq'uel c'u x'elan ta xich' chapanel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Li banquilal paleetique xchi'uc li jchapanvanejetic cu'untique lic sa' sbaic boch'o co'ol c'usi chalic yu'un ta snopbeic smul li Jesuse, yu'un tsc'anic ti ac'o chamuc oe. ");
INSERT INTO tzotze_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero mu'yuc boch'o co'ol c'usi laj yalic. Altic ep i'epalc'opojic ta stojol li Jesuse. Ts'acal iva'iic yan chib j'epalc'opetic noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jech laj yalic: ―Li vinic li'i yaloj ti xu' yu'un tsvuq'ues li templo yu'un Diose, xchi'uc xu' la yu'un ta xcha'va'an ta ach' ta oxib c'ac'al ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Li más banquilal palee iva'i, jech laj yalbe li Jesuse: ―¿C'u yu'un mu xatac'ov? ¿Me melel li c'usi chalic ta aventae? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Me jbeluc muc xtac'ov li Jesuse. Li más banquilal palee la sjac'be noxtoc li Jesuse: ―Alo ca'i ta stojol cuxul Dios me vo'ot Cristoot ti t'ujbilot yu'un Dios chaventainuncutique. ¿Me vo'ot Xnich'onot li Diose? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Itac'ov li Jesuse: ―Vu'un. Jech chacalboxuc, vu'un ti co'ol cristianoutique ta to xavilic ta xlic jventain cristianoetic ta stsatsal Dios. Ts'acal to chilic scotol cristianoetic chital ta toc ta vinajel ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Li más banquilal palee la sli' sc'u' yu'un la snop ti laj xa stabe tsots smul li Jesuse. Jech laj yal: ―Ava'yic xa ti ta scuy sba ta Dios stuque. ¿C'u yu'un ta jc'antic yan testigo? Laj xa ava'yic ti ta stoy sba ta stojol Diose. ");
INSERT INTO tzotze_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿C'uxi xu' ta stoj o smul chava'yic? ―xut li xchi'iltac ta abtele. Itac'ovic: ―Ja' lec ac'o chamuc o ta j'ech'el ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lic stubtabeic sat, la smajic. Oy yantic la slec'beic ta majel xocon sat. ");
INSERT INTO tzotze_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Jech laj yalbeic: ―Vo'ot ti Cristoot avaloje, alo tal ca'tic ti boch'o la smajote ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Li Pedroe tey chotol ta amac'. Tey vul c'opanatuc yu'un jun quiara: ―Vo'ote ja' achi'il ec li Jesús liquem tal ta Galilea banamile ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Li Pedroe laj yal ta stojol scotolic ti mu xotquine. ―Mu jna' c'usi chaval ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Iloc' batel ta ti'na li Pedroe. Tey i'ilat yu'un yan quiara. Li quiarae laj yalbe li boch'otic tey oyique: ―Le'e ja' la xchi'in li Jesús tey liquem tal ta Nazarete ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Li Pedroe la st'abbe sbi Dios ti c'alal laj yale: ―Ta melel yiloj Dios mu xcotquin li vinic chavale ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta jliquel ital c'opanatuc yu'un yantic li Pedroe. Jech laj yalbeic: ―Ta melel ja' ono'ox achi'il li Jesuse yu'un ja' jech ac'op ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lic chopolc'opojuc li Pedroe, la st'abbe sbi Dios yan velta: ―Yiloj Dios mu xcotquin li vinic chavale ―xi. Ja' o i'oc' cots. ");
INSERT INTO tzotze_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tey ivul ta sjol Pedro ti jech ono'ox albil yu'un Jesuse: “C'alal mu'yuc to'ox ta x'oc' cotse, oxib xa'ox velta avaloj ti mu xavotquinune”, x'utat ono'ox. Iloc' batel li Pedroe, ep laj yoc'ta sba. ");
INSERT INTO tzotze_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","C'alal isacube, scotol li banquilal paleetique xchi'uc li jchapanvanejetic cu'untic, vu'utic li israelutique, la xchapanic c'u x'elan xu' ta smilic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lec chucul laj yiq'uic batel, c'ot yac'beic ta sc'ob li gobernadore, ja' li Poncio Pilatoe. ");
INSERT INTO tzotze_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Li Judase, ja' li boch'o laj yac' ta c'abal Jesuse, c'alal laj yil ichapaj ti chmilat o li Jesuse, lic snop ta yo'nton ti tsutes li lajuneb xcha'vinic ta sep saquil taq'uin i'ac'bat yu'un banquilal paleetic xchi'uc jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jech c'ot yalbe: ―Laj xa jta jmul yu'un laj cac' ta c'abal li boch'o mu'yuc smule ―xut c'otel. Itac'ovic: ―Mu xa jventacuticuc li vu'uncutique. Ja' xa aventa atuc ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Li Judase la sjip ochel ta yut templo li taq'uine, iloc' batel, bat xchuc snuc' ta lazo, jech la smil sba stuc. ");
INSERT INTO tzotze_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Li banquilal paleetique la stamic li taq'uine. Jech la snopic: ―Mu lecuc me ta jcaptic ta smoton Dios li taq'uin li'i yu'un ja' stojol sbec'tal xch'ich'al jun vinic ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La snopic ti ta smanic o juteb osil sventa smuquinal li boch'otic nom talemic ti yan o slumalique. Ja' jpatbin li yajval osile. ");
INSERT INTO tzotze_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja' yosil ch'ich' la sbiin li banamile. Ja' jech sbi o c'alal to tana. ");
INSERT INTO tzotze_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jech ic'ot o c'usi laj yal li j'alc'op Jeremías ta vo'onee: “Ta stamic li lajuneb xcha'vinic ta sep saquil taq'uine, ja' stojol li jchi'iltic ti mu xc'anat yu'un jchi'iltactic ti ja' chventainvane. ");
INSERT INTO tzotze_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ja' ta smanbeic o yosil li jpatbine jech chac c'u cha'al laj yalbun Diose”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Li Jesuse tey oy ta stojol Pilato. Jech ijac'bat: ―¿Me vo'ot muc'ta ajvalilot yu'un li achi'iltac ta israelale? ―x'utat. Itac'ov li Jesuse: ―Vu'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","C'alal la snopbeic smul Jesús li banquilal paleetique xchi'uc li jchapanvanejetic cu'untique, me jbeluc mu'yuc c'usi laj yal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Li Pilatoe jech laj yalbe li Jesuse: ―¿Me muc xava'i ti c'u yepal ay stiq'uic amule? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Me jbeluc muc xtac'ov li Jesuse. Li Pilatoe toj ch'ayel ic'ot yo'nton c'alal laj ya'i ti muc spoj sba li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Li Pilatoe jech stalel o ti ta jujun q'uin coltael ta scolta jun jchuquel ti bu junucal ta sc'anic li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tey tiq'uil ta chuquel jun jchi'iltic ta israelal ti vinajem sc'oplale, Barrabás sbi. ");
INSERT INTO tzotze_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","C'alal tey tsobol scotol li jchi'iltactique, jech lic sjac' li Pilatoe: ―¿Boch'o chac'anic ta jcolta? ¿Me ja' chac'anic ta jcolta li Barrabase o me ja' chac'anic ta jcolta li Jesús ti yaloj ja' t'ujbil yu'un Dios chasventainoxuque? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yu'un sna'oj ono'ox Pilato ti ta scoj xti'et yo'ntonic yu'un li Jesús ti laj yaq'uic ta c'abale. ");
INSERT INTO tzotze_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","C'alal tey chotol Pilato yo' bu ta xal c'u x'elan ta xcom li boch'o ta xchapanate, la stac tal mantal li yajnile, jech laj yal tal: “Bijan me, mu me c'usi chopol xapasbe li lequil vinic le'e. Yu'un la jvaychin nax. Ep laj cat co'nton ta scoj li vinic le'e”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Li banquilal paleetique xchi'uc li jchapanvanejetic cu'untique la xchanubtasic cristianoetic ti ja' ac'o sc'anic coltabel li Barrabase. Yan li Jesuse laj yalic ti ja' ac'o chamuque. ");
INSERT INTO tzotze_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Li Pilatoe la sjac'be noxtoc li cristianoetique: ―¿Boch'o junucal chac'anic ta jcoltaboxuc? ―xut. Itac'ovic: ―Ja' coltao li Barrabase ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jech laj yal noxtoc li Pilatoe: ―¿C'usi chac'anic ta jpasbe li Jesús ti yaloj ja' t'ujbil yu'un Dios chasventainoxuque? ―xi. Itac'ov scotolic: ―¡Joc'ano ta cruz! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Li Pilatoe jech laj yal: ―¿Pero c'usi smul avu'unic? ―xi. Tsots i'avan scotolic: ―¡Joc'ano ta cruz! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","C'alal laj yil Pilato ti mu sc'an xch'unique, ti toj ech'em ta xliquic ta vochlajetel li jchi'iltactique, jech la stsac vo', la spoc sc'ob ta stojol scotol li jchi'iltactique. Jech laj yalbe: ―Mu vu'cun ta jmul me ta xmilat li lequil vinic li'i; vo'oxuc ta amulic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Itac'ov scotolic: ―Vu'uncutic ta xcom ta cac'olcutic jchi'uc calab jnich'nabcutic ti ta xmilate ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Li Pilatoe la scolta batel li Barrabase. Yan li Jesuse laj yac'be ta sc'ob yajsoldadotac yu'un ac'o bat sjoc'anic ta cruz c'alal me laj yac'beic nucule. ");
INSERT INTO tzotze_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Li yajsoldadotac gobernadore laj yiq'uic ochel ta yut cabildo li Jesuse. Tey la stsob sbaic scotol li soldadoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","La sloc'beic sc'u' li Jesuse, la slapbeic tsajal c'u'il. ");
INSERT INTO tzotze_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","La sts'otic ch'ix, la xojbeic ta sjol sventa scorona. Laj yac'beic jch'ix aj ta sbats'ic'ob sventa svara. La squejan sbaic ta stojol, la slabanic. Jech laj yalbeic: ―¡Toj lec muc'ta ajvalilot yu'un li achi'iltac ta israelale! ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","La stubtabeic sat. La spojbeic li aje, la xch'ijbeic ta sjol. ");
INSERT INTO tzotze_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","C'alal laj yo'ntonic ta slabanele, la sloc'beic li tsajal c'u'ile, la slapbeic sc'u' stuc li Jesuse. Laj yiq'uic batel yu'un ta sjoc'anic ta cruz. ");
INSERT INTO tzotze_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","C'alal iloq'uic batele, tey la snupic ta be jun jchi'iltic ta israelal, Simón sbi, tey liquem tal ta lum Cirene. Ja' laj yac'beic xq'uechbe batel scruzal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tey ic'otic yo' bu Gólgota sbie, ja' Baquil Jolal, xi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tey laj yac'beic yuch' pajal ya'lel ts'usub capal ta ch'ail poxil. La spas ya'i li Jesuse pero muc sc'an xuch' yu'un ja' smacubil xc'uxul. ");
INSERT INTO tzotze_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","C'alal la sjoc'anic ta cruz Jesús li soldadoetique, la spasic canal tajimol yu'un tsvoc'beic li sc'u'e yu'un jech chilic bu jlicucal chc'ot ta stojol jujunic. Ja' ic'ot o ti jech ono'ox laj yal li yaj'alc'op Dios ta vo'onee: “Ta svoc'be sbaic li jc'u'e, ta spasic canal tajimol yu'un ta sq'uelic bu jlicucal chc'ot ta stojol jujunic”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tey la xchotan sbaic li soldadoetique, la xchabiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tey la sbajbeic ta sjol scruzal c'usi smul yu'unic li Jesuse. “Li'i ja' Jesús, ja' muc'ta ajvalil yu'un israeletic”, xi ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oy chib j'eleq'uetic co'ol la sjoc'anic ta cruz xchi'uc li Jesuse, jun scruzal ta sbats'ic'ob, jun ta sts'et. ");
INSERT INTO tzotze_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Li boch'otic tey ijelovique ilabanvanic ec, la sjimulan sjolic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Jech laj yalic: ―Vo'ot ti sc'oplal chavuq'ues temploe, ti ta oxib no'ox c'ac'al chacha'va'an chavale, colta aba atuc. Me melel ti vo'ot Xnich'onot Diose, yalan tal ta cruz ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ja' no'ox jech ilabanvanic ec li banquilal paleetique, xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li jchapanvanejetic cu'untique. Jech laj yalic: ");
INSERT INTO tzotze_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―La scoltaan yan cristianoetic pero mu xu' yu'un ta scolta sba stuc. Me melel ti ja' muc'ta ajvalil cu'untic, vu'utic li israelutique, ac'o yaluc tal ta ora ta cruz. Ja' to ta jch'untic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Laj yal ti xch'unoj ti chcoltaat yu'un Diose, jech ac'o coltaatuc ta ora me melel ti lec ilbil yu'un Diose. Yu'un yaloj ono'ox ti ja' Xnich'on Diose ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ja' no'ox jech ilabanvanic ec li chib j'eleq'uetic tey joc'ajtic ta cruz xchi'uc Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","C'alal o'lol xa'ox c'ac'ale, i'ic'ub osil. Ic' icom c'alal to ta o'lol syalel c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta o'lol syalel c'ac'al tsots i'avan li Jesuse: ―Elí, Elí ¿lama sabactani? ―xi. Dios cu'un, Dios cu'un, laj xa acomtsanun, xi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oy jayibuc boch'otic tey laj ya'yic. Jech laj yalic: ―Ja' ta xic' tal Elías ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta anil ibat jun vinic, bat sts'aj tal ta pajal ya'lel ts'usub jun esponja. La xoj muyel ta aj, laj yac'be sts'uts' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jech i'albat yu'un li yantique: ―Malo to, jq'ueltiquic me ta xtal coltaatuc yu'un li Elíase ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Li Jesuse tsots i'avan yan velta, jech iloc' o xch'ulel. ");
INSERT INTO tzotze_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Li muc'ta poc' tey joc'ol ta yut temploe ili' ta o'lol. Ili' yalel tal ta cajal c'alal to ta olon. Tsots inic li banamile. Li muc'tic ch'entique ivoc'an ta o'lol. ");
INSERT INTO tzotze_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ep muquinaltic ijam. Icha'cuxiic li boch'otic xch'unojbeic sc'op Dios c'alal ichamique. ");
INSERT INTO tzotze_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pero muc xloq'uic ta smuquinalic ta ora. Ja' to iloq'uic ec ti c'alal icha'cuxi loq'uel ta smuquinal li Jesuse. I'ochic batel ta Jerusalén, tey i'ilatic yu'un ep cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Li capitán soldado xchi'uc yajsoldadotac ti tey ta xchabiic li Jesuse, toj xi'el ic'otic c'alal laj ya'yic inic li banamile xchi'uc laj yilic scotol li c'usitic yan i'ech'e. Jech laj yalbe sbaic: ―Ta melel ja' xnich'on Dios li vinic li'i ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","C'alal joc'ol xa'ox ta cruz li Jesuse, tey oy ep antsetic ta sq'uelic tal ta nom. Ja' li antsetic ti la xchi'inic ta xanubal Jesús tey ta Galilea banamil ti la smac'linique. Jech tey nabal italic c'alal ta Judea. ");
INSERT INTO tzotze_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tey oy li María ti liquem tal ta Magdalae, xchi'uc li yan Maríae, ja' li sme'ic Jacobo xchi'uc Josée. Tey oy noxtoc li sme'ic yan Jacobo xchi'uc Juane, ja' li xnich'nab Zebedeoe. ");
INSERT INTO tzotze_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Tey oy jun jchi'iltic, jc'ulej li vinique. Ja' tey liquem tal ta lum Arimatea. José sbi. Xch'unoj ec ti ja' Jcoltavanej cu'untic li Jesuse. C'alal mal xa'ox c'ac'ale, bat sc'opan li Pilatoe yu'un tsc'anbe sbec'tal li Jesuse. Li Pilatoe laj yal mantal ti ac'o yac'beic batel li sbec'tal Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Li Josée laj yich'be batel sbec'tal li Jesuse, la xpix lec ta saquil manta. ");
INSERT INTO tzotze_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bat smuc ta smuquinal stuc ta vombil ton. La xbalch'un tal jbej ton ta sti' li ch'ene, la smac lec comel, jech ibat. ");
INSERT INTO tzotze_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Li María liquem tal ta Magdalae xchi'uc li yan Maríae tey to chotol icomic ta stuq'uil ti' ch'en. ");
INSERT INTO tzotze_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","C'alal ech'em xa'ox yorail ta jchapan jbatic sventa ta jcux co'ntontic ta sábadoe, la stsob sbaic tal scotol li banquilal paleetique xchi'uc li fariseoetique. Tey italic ta stojol li Pilatoe. ");
INSERT INTO tzotze_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jech c'ot yalbeic: ―Tata, jna'ojcutic ti jech yaloj li jlo'lavanej c'alal cuxul to'oxe. “Ta yoxibal c'ac'al ta xicha'cuxi loq'uel ta jmuquinal”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ja' lec alo mantal ti ac'o bat yich' chabiel oxibuc c'ac'al li smuquinale yu'un naca me tal loq'uesbatuc sbec'tal ta ac'ubaltic yu'un li yajchanc'optaque. Naca me jech ta xalbeic li cristianoetique: “Icha'cuxi xa loq'uel ta smuquinal”, naca me xiic, jech más to ech'em ta xlo'laatic o li cristianoetique ―xutic li Pilatoe. ");
INSERT INTO tzotze_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Itac'ov li Pilatoe: ―Tey oy soldadoetic, iq'uic batel. Bat pasic c'u x'elan xana'ic xchabiel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jech ibatic, bat smeltsanbeic lec li smuquinale. La spaq'uic lec comel li spat xocon muc'ta ton ti macbil o sti' ch'ene. Laj yac'beic comel selloal ti bu la spaq'uique. Tey laj yac'beic comel xchabiic li soldadoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","C'alal ech'em xa'ox li sc'ac'alil ta jcux co'ntontique, po'ot xa tsacub ta sliquebal semana, ja' li domingoe, bat sq'uelbeic smuquinal Jesús li María liquem tal ta Magdalae xchi'uc li yan Maríae. ");
INSERT INTO tzotze_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","C'alal mu'yuc to'ox batemique, tsots inic li banamile. Yu'un iyal tal ta vinajel jun yaj'almantal Cajvaltic Dios. Vul xbalch'un loq'uel li muc'ta ton ti macbil o sti' ch'ene, tey ichoti ta sba li smaque. ");
INSERT INTO tzotze_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Li j'almantale oy xojobal ja' jech saquil jech chac c'u cha'al sacsevul. Bats'i sac ta jyalel li sc'u'e. ");
INSERT INTO tzotze_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","C'alal laj yilic li jchabich'enetique, iniquic ta xi'el, xco'laj xchi'uc chamen icomic yilel. ");
INSERT INTO tzotze_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Li j'almantale jech laj yalbe li antsetique: ―Mu me xaxi'ic. Ta jna' ti ja' chasa'ic li Jesús ti imilat ta cruze. ");
INSERT INTO tzotze_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mu'yuc xa li'i; icha'cuxi xa jech chac c'u cha'al yalojboxuc ono'oxe. La' q'uelavilic ti bu laj to'ox yaq'uique. ");
INSERT INTO tzotze_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Batanic ta ora, bat albeic yajchanc'optac ti cha'cuxem xae. Albeic ti ja' ba'yuc ta xc'ot yu'unic ta Galileae. Ja' to tey ta xc'ot yilic. Ja' no'ox jech chacalboxuc ―x'utatic yu'un li j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Li antsetique ixi'ic. Iloq'uic ta vombil ton, italic ta anil. Xcuxet no'ox yo'ntonic tal yalbuncutic, vu'uncutic li yajchanc'opuncutic Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","C'alal ja' o chanovic tal ta bee, tey la snupic ta be li Jesuse. ―¿Bu chabatic? ―x'utatic. Li antsetique la squejan sbaic ta stojol li Jesuse, la smeybeic yacan yu'un laj yich'ic ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jech i'albatic yu'un li Jesuse: ―Mu me xaxi'ic. Bat albeic quermanotactic ti ac'o baticuc ta Galileae. Tey ta xc'ot staicun ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","C'alal ja' to no'ox isutic tal li antsetique, ic'otic xa'ox ta lum jayibuc li jchabich'enetique. Bat yalbeic banquilal paleetic scotol li c'usitic ic'ot ta pasel ta stojolique. ");
INSERT INTO tzotze_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Li banquilal paleetique ta ora la stsob sba scotolic xchi'uc li jchapanvanejetique. Jmoj la xchapanic c'usi ta spasic. Laj yac'beic ep taq'uin li soldadoetique. ");
INSERT INTO tzotze_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jech laj yalbeic: ―Jech xavalic: “Ta ac'ubaltic c'alal ja' o ochem jvayelcutique ay loq'uesbatuc sbec'tal yu'un yajchanc'optac”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Me laj ya'i li gobernadore, vu'uncutic xa ta xbat jlecubtasbecutic yo'nton ti c'u cha'al mu xasmiloxuque ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Li soldadoetique laj yich'ic li taq'uine, ja' jech laj yalic ti c'u cha'al i'albatique. Ja' jech ivinaj o sc'oplal ta stojol scotol jchi'iltactic ta israelal ti mu'yuc cha'cuxeme. Ja' jech xch'unojic o c'alal to tana. ");
INSERT INTO tzotze_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vu'uncutic li buluchib yajchanc'opuncutic Jesuse tey libatcutic ta Galilea. Tey lic'otcutic ta vits ti bu yalojbuncutic ono'ox li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","C'alal laj quilcutic li Jesuse, la jquejan jbacutic ta stojol. Pero oy chib oxibuncutic ti mu'yuc la jch'uncutic lec me ja' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Li Jesuse jech laj yalbuncutic: ―Vu'une li'ac'bat xa jventain scotol, xchi'uc vinajel xchi'uc banamil. ");
INSERT INTO tzotze_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jech batanic ta scotol banamil, bat cholbeic jc'op scotol li cristianoetique. Ac'beic yil ti ventainbiloxuc xa cu'une, jech chlic yac' sbaic ta ventainel cu'un ec. Ac'bo yich'ic vo' ta sventa li Jtote, xchi'uc ta jventa, vu'un li Nich'onilune, xchi'uc ta sventa li Ch'ul Espíritue. Ja' senyail ti ja' cu'untaque. ");
INSERT INTO tzotze_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chanubtasic lec jech ta xch'unic ec scotol li c'usitic laj calboxuc ava'yique. Na'ic me ti jchi'inojoxuc o scotol c'ac'al xchi'uc c'alal to ta slajebal c'ac'ale ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja' jech x'elan ilic li lequil a'yeje, ja' ti chijcolutic ta sventa Cajvaltic Jesucristo Xnich'on Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ja' la sts'iba comel j'alc'op Isaías ta vo'one ti ba'yuc ta xjelov tal jun j'alc'op yu'un Cajvaltique. Jech ts'ibabil: Ba'yuc ta xjelov avu'un li j'alc'op ta jtac batele. Ja' ta xalbe cristianoetic ti chabate yu'un jech xu' chayich'icot ta muc', xut Xnich'on li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jech ta to xlic jun jchi'iltic ta israelal ja' tsots ta x'avan ta xocol banamil, jech ta xal: “Ta xa xtal li Cajvaltique. Ja' lec comtsanic scotol li c'usitic chopol chapasique, ja' ich'beic ta muc' li sc'ope”, xi ta xlic yalbe li jchi'iltactique, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jech ivinaj li Juan tey ta xocol banamil c'alal lic xchol ti chac'be yich'ic vo' li boch'otic ta scomtsan c'usitic chopol ta spasique yu'un jech ta spasbatic perdón yu'un smulic. ");
INSERT INTO tzotze_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bat ya'ibeic sc'op Juan scotol li jchi'iltaccutic ta israelal tey nacajtic ta Judea banamile, xchi'uc li boch'otic tey nacajtic ta lum Jerusalene. Li boch'otic jamal c'ot yalic ta stojol Juan c'usi smulique i'ac'bat yich'ic vo' yu'un Juan tey ta uc'um Jordán. ");
INSERT INTO tzotze_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Li sc'u' Juane ja' jalbil tsotsil camello. La xchuc xch'ut ta nucul. Li sve'ele ja' c'ulub xchi'uc spom muc'ta pom. ");
INSERT INTO tzotze_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Li Juane jech lic yalbe li jchi'iltaccutic ta israelale: ―Oy to boch'o ts'acal ta xtal, ja' tsots yabtel yich'oj. Li vu'une mu'yuc tsots cabtel quich'oj. Mu'yuc c'usi xu' cu'un ta jcolta. Ac'o me stitunbeluc yaq'uil xonob mu xu' cu'un. ");
INSERT INTO tzotze_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Vu'une ja' no'ox laj cac'boxuc avich'ic vo'. Yan li boch'o ts'acal ta xtale ja' chayac'boxuc avich'ic Ch'ul Espíritu ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja' o iloc' tal ta lum Nazaret tey ta Galilea banamil li Jesuse. Tey ic'ot ta uc'um Jordán, tey i'ac'bat yich' vo' yu'un Juan ta uc'um Jordán. ");
INSERT INTO tzotze_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","C'alal iloc' ta uc'um li Jesuse, ta ora laj yil ijam li vinajele. Laj yil iyal tal ta sba li Ch'ul Espíritue, xco'laj xchi'uc tsumut yilel. ");
INSERT INTO tzotze_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Li Diose ic'opoj tal ta vinajel, jech laj yal: ―Vo'ot Jnich'onot, lec c'uxot ta co'nton. Xcuxet no'ox co'nton avu'un ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Li Jesuse ta ora no'ox i'ac'bat sna' yu'un Ch'ul Espíritu ti chbat ta xocol banamile. ");
INSERT INTO tzotze_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cha'vinic c'ac'al tey oy ta xocol banamil. Ja' no'ox tey oy te'tical chonetic. Li Satanase, ja' li banquilal pucuje, la suj ta mulil li Jesuse pero li Jesuse tey coltabil yu'un yaj'almantaltac Dios ti c'u sjalil tey oye. ");
INSERT INTO tzotze_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","C'alal ochem xa'ox ta chuquel li Juane, li Jesuse ibat ta Galilea banamil. Bat xcholbe ya'yic jchi'iltaccutic ta israelal li lequil a'yeje. ");
INSERT INTO tzotze_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jech laj yal: ―Yorail xa xu' chasventainboxuc avo'ntonic li Diose. Comtsanic scotol li c'usitic chopol chapasique, ch'unic li lequil a'yej li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Li Jesuse ixanov batel ta ti'ti'nab tey ta Galilea banamil. Tey laj yil chib jchi'ilcutic, Simón xchi'uc yits'in Andrés sbi. Tey ta stic' ochel snuti'ic ta nab yu'un ta stsaquic choy, yu'un ja' yabtelic o. ");
INSERT INTO tzotze_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Li Jesuse jech lic yalbe: ―La' chi'inicun batel, ta jelboxuc avabtelic. Yu'un ta jchanubtasoxuc c'u x'elan chbat asa'bicun cristianoetic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta ora la scomtsan o li yabtelique, la xchi'inic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","C'alal ijelov batel jutuc Jesús xchi'uc li chibique tey laj yil yan chib jchi'ilcutic, Jacobo xchi'uc yits'in Juan sbi. Ja' xnich'nab Zebedeo. Tey tic'ajtic ta yut tenalte' canova xchi'uc stotic yu'un ta slut'ilan snuti'ic yu'un tuch'emic. ");
INSERT INTO tzotze_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I'ic'atic yu'un li Jesuse. Ta ora la scomtsan li stotique, la xchi'inic batel li Jesuse. Li totile tey icom ta tenalte' canova xchi'uc svinictac. ");
INSERT INTO tzotze_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tey ic'otic ta lum Capernaum. C'alal ista sc'ac'alil ta jcux co'ntoncutique, i'och Jesús ta nail tsobobbail yu'un li jchi'iltaccutic ta israelale, tey ichanubtasvan. ");
INSERT INTO tzotze_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Li jchi'iltaccutique toj labal laj ya'yic c'u x'elan ichanubtasvan li Jesuse. Yu'un jech ichanubtasvan jech chac c'u cha'al li boch'o lec sna' c'usi tsc'an Diose. Mu jechuc ichanubtasvan jech chac c'u cha'al li jchanubtasvanejetic ono'ox ta smantal Dios yalojique. ");
INSERT INTO tzotze_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oy jun jchi'ilcutic tey ta nail tsobobbail ochem pucujetic ta yo'nton. Tsots i'avan, jech laj yalbe li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús, vo'ot ti liquemot tal ta Nazarete, ¿c'u yu'un chtal atic' aba ta jtojolcutic? ¿Me yu'un tal xa avac'uncutic batel yo' bu chquich'cutic castigoe? Xacotquinot boch'oot. Vo'ot Xnich'onot Dios, vo'ot ti mu'yuc amule ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Li Jesuse la spajes li pucujetic ti tey xch'amanojbeic ye li vinique, jech laj yalbe: ―Ch'anchanic, loc'anic batel ta yo'nton li vinique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Li pucujetique la stu'pbeic yic' li vinique. Solel tsots i'avanic, jech iloq'uic ta yo'nton li vinique. ");
INSERT INTO tzotze_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Li jchi'iltaccutique toj ch'ayel ic'ot yo'nton scotolic. Jech la sjac'be sbaic: ―¿Boch'o ti li' taleme? Ja' ach' c'usi tspas. Oy ep stsatsal, xu' yu'un ta stac loq'uel li pucujetique. Ch'unbil smantal ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Li c'usi la spas Jesuse ta ora laj ya'yic cristianoetic ta scotol tsobtsobnaetic xchi'uc ta lumetic tey ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","C'alal iloq'uic ta nail tsobobbail li Jesuse, tey ibatic xchi'uc Jacobo xchi'uc Juan ta snaic Simón xchi'uc Andrés. ");
INSERT INTO tzotze_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Li smeni' Simone tey mochol ta svayab yu'un ip cha'i c'ac'ubel. Laj yalbeic Jesús c'usi ip cha'i li jchamele. ");
INSERT INTO tzotze_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Li Jesuse inoch'aj batel ta svayab, la stsacbe sc'ob, la snit liquel. Ta ora ich'abi li sc'ac'ubele. Tey lic mac'linvanuc. ");
INSERT INTO tzotze_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","C'alal ta xa xch'ay c'ac'ale, tey laj yic'beic tal ta stojol Jesús scotol jchameletic xchi'uc boch'otic ochem pucuj ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tey tsobol ic'ot scotolic ta ti'na. ");
INSERT INTO tzotze_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Li Jesuse la scoltaan li epal jchameletique. C'usiuc no'ox chamelal ip cha'yic icol yu'un scotol. Xchi'uc ep li boch'otic ochem pucuj ta yo'ntonique la sloq'ues scotol. Muc x'aq'ue c'opojicuc yu'un Jesús li pucujetique yu'un laj yotquinic ti ja' Xnich'on Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta yoc'omal ic' to ilic li Jesuse, iloc' batel, ibat yo' bu mu'yuc cristianoetique. Tey bat sc'opan Dios. ");
INSERT INTO tzotze_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Li Simón xchi'uc xchi'iltaque bat st'unic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","C'alal la staique, jech laj yalbeic: ―Scotol cristianoetic ta st'unicot ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Itac'ov li Jesuse: ―Batic ta lumetic li' no'oxe. Yu'un chbat calbe ya'yic jchi'iltactic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. Yu'un ja' talemun ta xcholel ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jech tey ibat xchi'uc yajchanc'optac ta scotol nail tsobobbailetic ta Galilea banamil. Bat yal ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. La sloq'ues noxtoc pucujetic ti ochemic ta yo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tey ital ta stojol Jesús jun jchi'ilcutic ta israelal tsacbil ta c'a'el chamel. La squejan sba ta stojol li Jesuse. Scotol yo'nton jech laj yalbe: ―Me chac'an chacoltaune, xu' avu'un chacoltaun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Li Jesuse la xc'uxubin li jc'a'el chamele. Laj yac' sc'ob ta sbec'tal, jech laj yalbe: ―Lec oy, colan cha'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jech ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Li Jesuse tsots laj yalbe batel mantal li vinique. Jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Mu me boch'o xavalbe ya'i. Ja' no'ox bat ac' aba ta ilel ta stojol pale. Ac'bo smoton Dios jech chac c'u cha'al yaloj ono'ox Moisés ta vo'onee. Jech ta sna'ic o jchi'iltactic ti colemot xae ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iloc' batel li vinique pero lic spuc batel c'u x'elan icoltaat yu'un li Jesuse. Jech ta mucul xa ta x'och ta lumetic li Jesuse. Tey no'ox oy ti bu mu'yuc cristianoetique. Pero ep cristianoetic bat staic li Jesuse, buyuc no'ox iliquic tal. ");
INSERT INTO tzotze_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","C'alal ech'em xa'ox jayibuc c'ac'ale, isut yan velta ta Capernaum xchi'uc yajchanc'optac li Jesuse. Li jchi'iltaccutique laj ya'yic ti tey xa oy yo'bu ono'ox nacal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jech ta ora la stsob sbaic tal yo' bu oy li Jesuse. Mu xa x'ochic ta yut na, tsinilic c'alal ta ti'na. Li Jesuse lic xcholbe ya'yic sc'op Dios. ");
INSERT INTO tzotze_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tey laj yiq'uic tal ta stojol Jesús jun vinic aluben yacan. Chanib yajval la xq'uechubte'ic tal. ");
INSERT INTO tzotze_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mu xu' ta x'ochic batel yo' bu oy li Jesuse yu'un toj tsinil li cristianoetique. Jech tey imuyic ta jolna yu'un lamal no'ox li jolnae. La svomic juteb li jolnae yu'un ja' tey la xchechic yalel xchi'uc svayab li jchamele. Jech tey ic'ot yu'unic yo' bu oy li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","C'alal laj yil Jesús ti xch'unojic ti ja' chcoltavane, jech laj yalbe li jchamele: ―Tata, pasbilot xa perdón yu'un scotol amul ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tey chotajtic jayibuc jchanubtasvanejetic ta smantal Dios yalojic. Jech la snop ta yo'ntonic: ");
INSERT INTO tzotze_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿C'u yu'un jech ta xal li vinique? Ta scuy sba ta Dios. Mu'yuc boch'o yan xu' ta xac' perdón yu'un jmultic, ja' no'ox Dios”, xi ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Li Jesuse ta ora la sna' li c'usi la snop ta yo'ntonique, jech laj yalbe: ―¿C'u yu'un ti mu'yuc lec c'usi chanop ta avo'ntonique? ");
INSERT INTO tzotze_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta melel boch'ouc no'ox xu' ta xal ti “pasbilot xa perdón yu'un amul” xie, yu'un mu vocoluc ta alel. Jech noxtoc mu vocoluc ta alel ti “lican, xanovan” xie. Pero ja' tsc'an chaq'uelic lec me ta melel ta xc'ot ta pasel yu'un li boch'o jech ta xale. ");
INSERT INTO tzotze_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vu'une laj cal ti pasbil xa perdón yu'un smul li vinique. Jech q'uelic me c'usi ta jpas li' ta orae yu'un jech chana'ic o ti vu'un no'ox ta jpasbe perdón yu'un smulic cristianoetic li' ta banamil, vu'un ti co'ol cristianoutique ―xut. Li Jesuse jech laj yalbe li jchamele: ");
INSERT INTO tzotze_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Vu'un chacalbot, lican, ich'o batel avayab, batan ta ana ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ta ora ilic li jchamele, laj yich' batel li svayabe, iloc' batel ta stojol scotolic. C'alal laj yilic li jchi'iltaccutique, toj labal laj ya'yic. Laj yalbeic slequilal Dios. Jech laj yalbe sbaic: ―Mu'yuc ono'ox boch'o jech xquiltic oy svu'el ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ibat yan velta ta ti' nab xchi'uc yajchanc'optac li Jesuse. Bats'i ep jchi'ilcutic ta israelal la stsob sbaic batel ta stojol li Jesuse. Tey lic chanubtasvanuc. ");
INSERT INTO tzotze_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","C'alal ibate, tey laj yil Leví, ja' xnich'on Alfeo. Tey chotol ta xchotleb yo' bu ta xac' spatan li cristianoetique. Li Jesuse jech laj yalbe: ―La' chi'inun batel ―xut. Jech ta ora la xchi'in batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ts'acal to c'alal tey chve' ta mesa ta sna Leví li Jesuse, tey oy noxtoc yan ep jtsobpatanetic xchi'uc yan jpasmuliletic. Tey la xchi'inic ta chotlej Jesús xchi'uc li yajchanc'optaque yu'un tey xchi'inojic tal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tey oyic li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc jayibuc fariseoetic. Laj yilic ti co'ol ta xve' Jesús xchi'uc li jtsobpatanetique xchi'uc li yantic jpasmuliletique. Jech laj yalbeic li yajchanc'optac Jesuse: ―¿C'u yu'un ta xve' xchi'uc jtsobpatanetic xchi'uc yantic jpasmuliletic li jchanubtasvanej avu'unique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Li Jesuse laj ya'i li c'usi laj yalique, jech laj yalbe: ―Li boch'otic tsotsique mu sc'anic poxtael. Ja' no'ox ta sc'anic poxtael li boch'otic ipique. Li vu'une mu ja'uc tal quic' li boch'otic mu'yuc smul yalojique. Ja' tal quic' li jpasmuliletique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","C'alal ja' o yictaojic ixim li yajchanc'optac Juane xchi'uc li yajchanc'optac fariseoetique (yu'un ja' yich'ojbeic stalel li jmoltotcutic ta vo'onee), jech oy boch'o tal sjac'beic li Jesuse: ―Yictaojic ixim li yajchanc'optac Juane xchi'uc li yajchanc'optac fariseoetique. ¿C'u yu'un mu'yuc ta xictaic ixim ec li avajchanc'optaque? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Itac'ov li Jesuse: ―C'alal yorail nupinele, tey oy li malalile jech mu xu' ta xictaic ixim li yajtestigoe yu'un tey xchi'uquic li malalile. ");
INSERT INTO tzotze_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ja' no'ox jech ec li cajchanc'optaque, mu jechuc smelol ti ta xictaic ixime yu'un li' to jchi'inojic. Ja' to me la sta sc'ac'alil ta smilicun li cajcontrae, ja' to xu' ta xictaic ixim li cajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Li boch'o ta xch'un c'usi chcale persa ta scomtsan li c'usi xch'unoj ti snopoj jech chcol oe. Persa scotol yo'nton ta xch'un li c'usi chcale yu'un jech chcol o. Jech chac c'u cha'al mu'yuc boch'o ta spac'an poco' c'u'il ta ach' manta yu'un mu'yuc to mutsem. Me oy boch'o jech ta spase, más to ech'em ta xli' batel li poco' c'u'ile. ");
INSERT INTO tzotze_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jech noxtoc li ach' ya'lel ts'usub ti ta xa xpajube, mu'yuc boch'o ta xch'ol ta poco' yav pasbil ta nucul. Me oy boch'o jech ta spase, c'alal ta xvocan stuc li ya'lel ts'usube, ta xjat li yavile. Altic chmal o scotol li ya'lel ts'usube. Li yavile mu xa xtun o. Li ach' ya'lel ts'usub ti ta xa xpajube, ja' tsc'an ta ach' yav ta xich' ch'olel ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","C'alal ja' o sc'ac'alil ta jcux co'ntoncutique, tey ijelovic ta be ta trigoaltic xchi'uc yajchanc'optac li Jesuse. Tey la sc'asic jaylicuc trigo li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tey laj yilic jayibuc fariseoetic, jech lic yalbeic li Jesuse: ―Q'uelavil, ¿c'u yu'un ta spasic c'usi mu stac' jpastic ta sc'ac'alil ta jcux co'ntontic li avajchanc'optaque? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Itac'ov li Jesuse: ―Aq'uelojic ta sc'op Dios c'usi la spas David ti c'alal ivi'najic xchi'uc xchi'iltac ta xanubale. ");
INSERT INTO tzotze_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tey ic'otic ta templo ti c'alal ja' o ochem ta banquilal pale li Abiatare. Li Davide ja' la sve' li pan tey oy ta ba mesa ta stojol Diose. Ac'o me yaloj Dios ti ja' no'ox xu' ta sve'ic li paleetique, pero la sve'ic xchi'uc xchi'iltac li Davide. Pero mu'yuc la sta smul ti jech la spase ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jech laj yal noxtoc li Jesuse: ―Li Diose laj yac' jun c'ac'al sventa ta jcux co'ntontic. Ma'uc laj yac' yu'un chispajesutic. ");
INSERT INTO tzotze_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Vu'un ti co'ol cristianoutique, vu'un yajvalun li sc'ac'alil ta jcux co'ntontique. Vu'un chcal li c'usitic stac' pasele ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ts'acal to i'och yan velta Jesús xchi'uc yajchanc'optac ta jun nail tsobobbail yu'un jchi'iltaccutic ta israelal. Tey oy jun jchi'ilcutic xmoch'oj sba sbic'tal jun sc'ob. ");
INSERT INTO tzotze_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tey oy jayibuc fariseoetic. Tey tsq'uelic me ta xcoltavan ta sc'ac'alil ta jcux co'ntoncutic li Jesuse yu'un tsc'an ta sa'beic smul. ");
INSERT INTO tzotze_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Li Jesuse jech laj yalbe li vinique: ―La' va'an aba li' ta o'lole ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Li Jesuse jech la sjac'be li fariseoetic tey oyique: ―Ta sc'ac'alil ta jcux co'ntontique, ¿c'usi yaloj Dios tsc'an ta jpastic? ¿Me xu' ta jpastic c'usi lec o me xu' ta jpastic c'usi chopol? ¿Me xu' chijcoltavan o me xu' chijmilvan? ―xut. Muc xtac'ov ic'otic. ");
INSERT INTO tzotze_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Li Jesuse i'ilin ti c'alal la sq'uelbe sat li fariseoetic tey oyic ta jujujot xocone, yu'un chopol laj ya'i ti toj tsots yo'ntonique. Jech laj yalbe li vinic ti xmoch'oj sba sbic'tal sc'obe: ―Va'ano lec li sbic'tal ac'obe ―xut. Jech la sva'an lec li sbic'tal sc'obe, ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iloq'uic batel li fariseoetique. Bat sc'opanbeic svinictac Erodes yu'un tsnopic c'u x'elan xu' ta smilic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Li Jesuse iloc' batel, ibat ta ti' nab xchi'uc yajchanc'optac. Pero tey nabal ibatic epal cristianoetic liquemic tal ta Galilea banamil xchi'uc ta Judea banamil. ");
INSERT INTO tzotze_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Oy liquemic tal ta lum Jerusalén xchi'uc ta Idumea banamil. Xchi'uc oy liquemic tal ta jot uc'um Jordán, xchi'uc oy liquemic tal ta yosilal chib lum, Tiro xchi'uc Sidón. Yu'un laj ya'yic ti ep c'usitic la spas li Jesuse jech bats'i ep la stsob sbaic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Noch'ajesic tal junuc canova yu'un ja' tey chi'och c'alal me ta snet'icun li epal cristianoetique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yu'un ep xa cristianoetic icolic yu'un li Jesuse, jech scotol jchameletic chnet'vanic batel yu'un tsc'an ta spiquic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","C'alal laj yilic Jesús li pucujetic tey ochemic ta yo'nton cristianoetique, la squejan sbaic ta stojol Jesús li cristianoetic ti ochem pucujetic ta yo'ntonique. Tsots i'avanic: ―Vo'ot Xnich'onot Dios ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Li Jesuse tsots la spajes li pucujetique yu'un mu me xalic batel ti ja' Xnich'on Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ts'acal to imuy batel ta vits li Jesuse. Laj yic' batel li boch'otic tsc'an ta xchi'in batele. ");
INSERT INTO tzotze_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tey lic st'uj lajchab jchi'ilcutic yu'un ja' ta xchi'in o. Yu'un tstac batel ta xcholel sc'op. ");
INSERT INTO tzotze_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xchi'uc laj yac'anbe svu'elic yu'un ta scoltaic jchameletic xchi'uc ta sloq'uesic pucujetic ta yo'nton cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ja' la st'uj Simón, ja' Pedro laj yac'be yan sbi. ");
INSERT INTO tzotze_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Xchi'uc Jacobo xnich'on Zebedeo. Xchi'uc yits'in li Jacoboe, ja' Juan sbi. Ja' Boanérges i'ac'bat sbiic yu'un li Jesuse. Ja' smelol ti ta anil no'ox ic'opojic jech chac c'u cha'al xbac' chauc. Yu'un ta ora tsc'an chaq'uic castigo stuquic. ");
INSERT INTO tzotze_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xchi'uc la st'uj noxtoc Andrés, xchi'uc Felipe, xchi'uc Bartolomé, xchi'uc Mateo, xchi'uc Tomás, xchi'uc yan Jacobo, ja' xnich'on Alfeo, xchi'uc Tadeo. Xchi'uc yan Simón, ja' ti laj to'ox xchi'in li cananeoetique. ");
INSERT INTO tzotze_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Xchi'uc Judas Iscariote, ja' ti ts'acal to lic yac' ta c'abal li Jesuse. C'alal la st'uj lajchab yajchanc'op li Jesuse, ibatic ta na ti bu ono'ox nacale. ");
INSERT INTO tzotze_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","La stsob sbaic batel yan velta li cristianoetique. Solel la stsin sbaic. Mu xa spas bu xve' xchi'uc yajchanc'optac li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","C'alal laj ya'yic yuts' yalaltac Jesús ti tey tsinil ep cristianoetic ta snae, tsc'an ox chiq'uic loq'uel li Jesuse yu'un la snopic ti soquem sjole. ");
INSERT INTO tzotze_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tey oy jayibuc jchi'ilcutic ta israelal ja' jchanubtasvanejetic ta smantal Dios yalojic. Tey liquemic tal ta Jerusalén. Jech laj yalic: ―Li vinic li'i ochem banquilal pucuj ta yo'nton. Jech ta svu'el banquilal pucuj ta sloq'ues pucujetic ta yo'nton li cristianoetique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Li Jesuse laj yic' li jchanubtasvanejetic ta smantal Dios yalojique. Jech la sloc'tabe ta lo'il: ―¿C'uxi xu' ta sloq'ues xchi'il ta pucujil li Satanase? ");
INSERT INTO tzotze_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jech chac c'u cha'al me ta scontrain sbaic jun ajvalil xchi'uc xchi'iltac ta abtele, tey ta soquic o, mu xu' yu'un tspasic mantal. ");
INSERT INTO tzotze_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Me ta scontrain sbaic yajvaltac jun nae, tey ta soquic o noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ja' no'ox jech ec li Satanase, me ta sloq'ues xchi'ile, mu xu' yu'un ta spas mantal me jech ta spase. ");
INSERT INTO tzotze_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Li boch'o tsc'an ta x'och ta sna jun tsatsal vinic yu'un tsc'an ta xelc'anbe c'usitic oy yu'une, ta persa ba'yuc ta xchuc li tsatsal vinique, ja' to jech xu' yu'un ta xelc'anbe batel li c'usitic oy yu'une. Li Satanase ja' jech chac c'u cha'al li tsatsal vinique. Pero laj xa jtsal yu'un laj xa jpojbe li vinic ti tey to'ox oy ta sc'obe. ");
INSERT INTO tzotze_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Melel chacalboxuc, li boch'otic chopol c'usitic ta spasique xchi'uc me chopol chc'opojic ta stojol Diose, ta to spasbatic perdón yu'un Dios me tsc'anique. ");
INSERT INTO tzotze_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yan li boch'o chopol chc'opoj ta stojol Ch'ul Espíritue, mu'yuc ono'ox ta spasbat o perdón sbatel osil ―xut jchanubtasvanejetic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ti jech i'albatique yu'un laj yalic ti ochem pucuj ta yo'nton li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tey ic'otic yits'inabtac Jesús xchi'uc sme'ic yu'un ja' bat sq'uelic li Jesuse. Tey va'ajtic ta amac'. La staquic ta iq'uel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ep boch'otic tey chotajtic ta jujujot xocon li Jesuse. Jech laj yalbeic: ―Tey oy ta amac' ame' xchi'uc avits'inabtac yu'un tsc'an ta sc'opanicot ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","35","Itac'ov li Jesuse: ―Ta melel ja' jme', ja' quits'inabtac ti tey oyique. Pero ja' más tsots sc'oplal chca'i li boch'o li' oyic ti tspasic c'usi tsc'an yo'nton Diose. Ja' jchi'iltac ta voq'uel chc'otic xchi'uc ja' jme' chc'otic o ―xut. La sq'uel li boch'otic tey nopol chotajtic ta sts'ele. Jech laj yal: ―Q'uelavil ti jayibic li' oyique, ja' jme', ja' jchi'iltac ta voq'uel c'otemic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Li Jesuse ibat ta ti' nab xchi'uc yajchanc'optac, tey lic chanubtasvanuc yan velta. Bats'i ep jchi'iltaccutic la stsob sbaic tal yo' bu oy li Jesuse, jech i'och ta canova tey ta ba vo' li Jesuse, tey ichoti. Li cristianoetique tey oyic ta ti' nab. ");
INSERT INTO tzotze_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","C'alal ichanubtasvan li Jesuse, oy ep c'usi la sloc'ta ta lo'il. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―A'yo ava'yic. Oy iloc' batel jts'untrigo. ");
INSERT INTO tzotze_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","C'alal la svij li strigoe, oy jaybej ic'ot ta be. Tey ital mutetic la sbiq'uic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oy jaybej ic'ot ta tontic ti bu mu'yuc pim slumale. Ta ora ijulij yu'un mu'yuc pim slumal. ");
INSERT INTO tzotze_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","C'alal iq'uepe, ic'anub, tey itaquij o yu'un mu'yuc nat yalem yisim. ");
INSERT INTO tzotze_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oy jaybej ic'ot ta ch'ixtic. C'alal ich'i li ch'ixe, inet'at jech tey ic'oxib o, jech muc satin o. ");
INSERT INTO tzotze_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oy jaybej ic'ot ta lequil banamil. Ja' lec laj yac' sat. Oy laj yac' lajuneb xcha'vinic ta bej, oy laj yac' oxvinic ta bej, oy laj yac' vo'vinic ta bej. ");
INSERT INTO tzotze_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Boch'o laj ya'i ac'o snopbe lec smelol ―x'utatic yu'un Jesús. ");
INSERT INTO tzotze_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","C'alal stuc xa tey oyic xchi'uc yajchanc'optac li Jesuse, xchi'uc li boch'otic scotol c'ac'al ta xchi'invanique, lic sjac'beic Jesús c'usi smelol li lo'il laj yale. ");
INSERT INTO tzotze_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Li Jesuse jech laj yalbe: ―Li vo'oxuque ac'biloxuc ana'ic c'u x'elan tsventainanbe yo'nton cristianoetic li Diose, pero li yantique mu x'ac'bat sna'ic jech chac c'u cha'al li vo'oxuque. Ja' no'ox ta jloc'tabe ta lo'il. ");
INSERT INTO tzotze_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yu'un altic chililanic ti scotol xu' cu'une mu xch'unic. Altic cha'yilanic li c'usi chcale, mu xac' ta yo'ntonic. Yu'un mu ono'ox sc'an scomtsanic li c'usitic chopol tspasique, jech mu spasbatic perdón yu'un smulic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jech laj yal noxtoc li Jesuse: ―Me muc xava'ibeic smelol ec li lo'il laj cale, ¿c'uxi xu' chava'ibeic smelol li yan lo'il ta to xcale? ");
INSERT INTO tzotze_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Li jts'untrigoe ja' li boch'o ta xchol sc'op Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Li bec' trigo ic'ot ta bee ja' senyail li boch'otic ya'yojic xa sc'op Dios ti mu'yuc tsots sc'oplal ta yo'ntonique. Ta ora ta xtal li Satanase ta sloq'uesbe ta yo'ntonic li sc'op Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Li bec' trigo ic'ot ta tontique ja' senyail li boch'o ta ora no'ox ta xch'unic ti c'alal cha'yic sc'op Diose. Xcuxet no'ox yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero mu'yuc chac' yisim ta yo'ntonic ya'yel yu'un mu'yuc stsatsal yo'ntonic. C'alal ta xich'ic uts'intaele, ta xich'ic vocol ta sventa ti cha'yic sc'op Diose, toj chibajel chc'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Li bec' trigo ic'ot ta ch'ixtique ja' senyail li boch'otic ya'yojic sc'op Dios ti ja' no'ox batem yo'ntonic yu'un li c'usitic oy li' ta banamile. Ja' tey lo'labilic o yu'un li c'usi tsc'an yo'ntonique. Scotol c'usiuc no'ox ta sc'upinic. Jech tey net'bil chc'ot o li sc'op Dios ya'yojique, jech mu xch'unic o. ");
INSERT INTO tzotze_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Li bec' trigo ic'ot ta lequil banamile ja' senyail li boch'otic chc'ot lec ta yo'ntonic li sc'op Diose. Tey tsatin lec ta yo'ntonic. Oy ta xac' lajuneb xcha'vinic ta bej, oy ta xac' oxvinic ta bej, oy ta xac' vo'vinic ta bej ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jech laj yal noxtoc li Jesuse: ―Me ta jtsantic candile, mu'yuc ta jnujmaquitic ta anmul. Mu'yuc ta jnac'tic ta yolon vaybal noxtoc. Ja' ta xcac'tic ta xvuchanubil. ");
INSERT INTO tzotze_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ja' no'ox jech ec li vo'oxuque, li c'usitic la jchanubtasoxuc atuquic li'i, mu me xanaq'uic. Vo'oxuc chcom ta aventaic ti jamal chavalic batel c'usi orae. ");
INSERT INTO tzotze_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Boch'o laj ya'i ac'o snop lec ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jech laj yal noxtoc li Jesuse: ―A'ibeic lec smelol li c'usi ta xcalboxuque. Ti c'u yepal chach'unic c'usi laj calboxuque, más to jech yepal chayac'boxuc ana'ic yan li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yu'un li boch'otic jutuc to xch'unojique, li Diose más to ech'em chac'be xch'un yu'un tsc'an xch'unic. Yan li boch'otic mu sc'an xch'unique, ti c'u yepal sna'ic jutuque ta xpojbatic sutel ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jech laj yal noxtoc li Jesuse: ―Chacalboxuc ava'yic c'u x'elan ta sventainan cristianoetic li Diose. Tey venta yu'un stuc c'u x'elan tspas. Ja' jech chac c'u cha'al trigo la svij ta yosil jun vinic. ");
INSERT INTO tzotze_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Li vinique jun yo'nton ta xvay ta ac'ubaltic ta xlic ta c'ac'altic. Ja' no'ox chil ti chjulij xa tal li strigoe pero mu sna' c'u x'elan ich'i. ");
INSERT INTO tzotze_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yu'un tey ta xch'i tal stuc. Ba'yuc ta xloc' yanal, ja' o ta xac' sat, ts'acal to ta xyijub. ");
INSERT INTO tzotze_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","C'alal me yij xae, ja' o chbat xtuch'ic yu'un yorail xa ta tuch'el ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jech laj yal noxtoc li Jesuse: ―¿C'usi xu' chcal ti xu' chco'laj smelol c'u x'elan tsventainan cristianoetic li Diose? ¿C'usi lo'ilal ta jloc'ta o ti chco'laj smelole? ");
INSERT INTO tzotze_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jech chac c'u cha'al bec' mostaza ta jts'untic ti toj biq'uite. Li c'usitic yan sbeq'ue ja' muc'tic. ");
INSERT INTO tzotze_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero c'alal me ich'i li bec' mostazae, ja' nat chbat. Ja' biq'uitic chc'ot li yan ts'unubiletique. Li mostazae nat chbat, ep chac' sc'ob noxtoc. Jech chtal mutetic, chtal spas stasic yu'un oy lec xyaxinal ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Li Jesuse puro ta lo'il no'ox la sloc'tabe ya'yic sc'op Dios li jchi'iltaccutique. Ja' no'ox laj yal ti c'u yepal xu' yu'un tsnopbeic smelole. ");
INSERT INTO tzotze_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Puro ta lo'il no'ox la sloc'tabe. C'alal stuquic xa xchi'uc yajchanc'optac li Jesuse, lic yalbe ya'yic c'usi smelol li lo'il laj yale. ");
INSERT INTO tzotze_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","C'alal ch'ayem xa'ox c'ac'ale, jech laj yalbe yajchanc'optac li Jesuse: ―Jelovcutic batel ta jot nab ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Li yajchanc'optaque la sc'opanic comel li cristianoetic tey xchi'inojique jech la xchi'inic batel Jesús ta yut canova. Oy yan canovaetic tey xchi'uquic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ta ora ilic tsots ic', la syuq'uilan li nabe, jech i'och ep vo' ta yut canova. C'an xa ochuc yalel ta yut nab li canovae. ");
INSERT INTO tzotze_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Li Jesuse tey vayem ta chac canova yac'oj xon sjol. La stijic li Jesuse, jech laj yalbeic: ―Jchanubtasvanej, ¿me mu'yuc ta avo'nton ti chij'och xa yalel ta yut nabe? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ilic li Jesuse. La spajes li iq'ue xchi'uc li nabe. ―Ch'abian ―xut. Jech ich'abi li iq'ue xchi'uc li nabe. ");
INSERT INTO tzotze_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Li Jesuse jech laj yalbe li yajchanc'optaque: ―¿C'u yu'un chaxi'ic? ¿C'u yu'un mu xach'unic lec ti xu' cu'une? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero más to ixi'ic. Jech laj yalbe sbaic: ―¿Boch'o vinical li'i? Yu'un c'alal ta ic', c'alal ta nab ta xch'unbat smantal ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Li Jesuse ibatic ta jot nab xchi'uc yajchanc'optac tey ta yosilal gadáraetic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","C'alal iloq'uic ta canova xchi'uc yajchanc'optac li Jesuse, ta ora tey la snupic ta be jun vinic ochem pucuj ta yo'nton. Tey ilic tal ta muquinaltic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yu'un ja' snainoj li vombil tonetic yo' bu chbat mucatuc boch'o ta xchame. Mu'yuc boch'o xu' yu'un ta xchuc ac'o me ta cadena. ");
INSERT INTO tzotze_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ep ta velta ichucbat yoc sc'ob ta cadena pero la xtuch' li cadenae. Mu'yuc boch'o xu' yu'un ta spas ta manso. ");
INSERT INTO tzotze_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ta c'ac'al ac'ubal tey x'avet batel ta vitsetic xchi'uc ta muquinaltic. Tey ta stsac ton ta sjayijes sba o. ");
INSERT INTO tzotze_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Li vinique laj yil ta nom li Jesuse, anil ital, la squejan sba ta stojol. ");
INSERT INTO tzotze_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Li Jesuse jech laj yalbe li pucuje: ―Pucuj, loc'an ta yo'nton li vinic li'i ―xut. C'alal jech laj yal li Jesuse, tsots lic avanuc li vinique: ―Jesús, vo'ot Xnich'onot Dios ta vinajel, ¿c'u yu'un chtal atic' aba ta jtojol? Li Diose cha'i ti jech chacalbote. Avocoluc mu xavac'bun castigo ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Li Jesuse jech la sjac'be li vinique: ―¿C'usi abi? ―xut. ―Legionun, yu'un ep ta mil li' ochemuncutic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Scotol yo'nton la sc'anbe Jesús ti mu me xtacatic batel ta yan banamile. ");
INSERT INTO tzotze_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tey ta ch'ut vits oy ep chitometic tey ta sa' sve'elic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Li pucujetique jech laj yalbeic li Jesuse: ―Me yu'un chaloq'uesuncutic batele, tacuncutic batel yo' bu oy chitometique, tey ac'o bat ochcuncutic ta yo'ntonic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Li Jesuse laj yac' tey baticuc. Jech iloq'uic ta yo'nton vinic li pucujetique, bat ochicuc ta yo'nton chitometic. Li chitometique oy van cha'miluc. Scotolic i'anilajic yalel ta yalubaltic, jech tey ibalch'ujic ochel ta nab, tey ijic'ovic o scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Li jchabichitometique ixi'ic batel. Bat yalbeic scotol cristianoetic ta lum xchi'uc boch'otic nacajtic ta vitsetic. Jech scotol cristiano iloq'uic tal, tal sq'uelic li c'usi ic'ot ta pasele. ");
INSERT INTO tzotze_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tey ic'otic yo' bu oy li Jesuse. Laj yilic tey chotol li vinic ti ochem to'ox pucuj ta yo'ntone. Slapoj xa sc'u', lecuben xa. Li cristianoetique ixi'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Li boch'otic laj yilic c'u x'elan icol li vinic ti ochem to'ox pucujetic ta yo'ntone, xchi'uc c'u x'elan icham li chitometique, laj yalbeic li boch'otic tey ic'otique. ");
INSERT INTO tzotze_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Scotolic laj yalbeic Jesús ti svocoluc ac'o loc'uc batel ta yosilalique. ");
INSERT INTO tzotze_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","C'alal i'och ta canova li Jesuse, li vinic ti ochem to'ox pucujetic ta yo'ntone la sc'anbe Jesús ti ac'o xchi'in batele. ");
INSERT INTO tzotze_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Li Jesuse jech laj yalbe: ―Mu xbat achi'inun. Batan ta ana, bat albo achi'iltac li c'usi la spasbot Diose, ti ep la xc'uxubinote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jech ibat li vinique, lic yal batel ta yosilal ti c'u x'elan icoltaat yu'un Jesuse. Decápolis sbi li yosilale yu'un lajuneb lum tey oy. C'alal laj ya'yic li cristianoetique, toj ch'ayel ic'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","C'alal isut tal li' ta jot nab li Jesuse, bats'i ep jchi'ilcutic la stsob sbaic batel ta stojol. Tey no'ox oy ta ti'nab li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tey ibat ta stojol jun jchi'ilcutic, Jairo sbi. Ja' jchapanvanej ta jun nail tsobobbail. C'alal laj yil Jesús li Jairoe, tal squejan spatan sba ta stojol. ");
INSERT INTO tzotze_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jech laj yalbe: ―Ta xa xcham cunin tseb. Avocoluc bat ac'o ac'ob ta sbec'tal, ac'o coluc jech ac'o cuxiuc ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jech la xchi'in batel li Jesuse. Net'el ibat li Jesuse yu'un ichi'inat batel yu'un epal cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Oy jun ants lajchab xa jabil yich'oj tuch' patijel. ");
INSERT INTO tzotze_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ep la sa' jpoxtavanejetic pero ja' no'ox ep i'ac'bat svocol xchi'uc ilaj scotol li c'usitic oy yu'une. Pero mu'yuc bal laj ya'i li xpoxilique, yo' to más i'ipaj o. ");
INSERT INTO tzotze_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Laj ya'i ti xu' yu'un chcoltavan li Jesuse, jech tey nabal ibat ta spat li epal cristianoetique. La spits' sba jelovel jech la sta ta picbel xaquita li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yu'un jech snopoj ta yo'nton: “Ac'o me ja' no'ox ta jpicbe xaquitae, chicol o”, xi ta yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jech ta ora imac li xchamele, laj ya'i ti lec xa oye. ");
INSERT INTO tzotze_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Li Jesuse ta ora laj ya'i ti oy boch'o icol ta stsatsale. Ijoyij, jech la sjac'be li cristianoetique: ―¿Boch'o la spicbun jxaquita? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Itac'ov li yajchanc'optaque: ―Toj net'el cristianoetic chavil. ¿C'u yu'un “boch'o lispicun” xachi? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Li Jesuse la sq'uel ta jujujot xocon li boch'o jech la spase. ");
INSERT INTO tzotze_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Li antse ta xnic xa ta xi'el yu'un sna' ti ja' icole. Jech tey la squejan sba ta stojol li Jesuse, jamal laj yalbe scotol. ");
INSERT INTO tzotze_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Li Jesuse jech laj yalbe: ―Tseb, yu'un laj ach'un ti scotol xu' cu'une jech lacol. Junuc avo'nton batan yu'un colemot xa ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","C'alal ta to xlo'ilaj li Jesuse, tey ic'ot jayibuc li boch'otic tey iliquic ta sna li jchapanvanej ta nail tsobobbaile. Jech vul albatuc li jchapanvaneje: ―Icham xa li atsebe. Altic xa chavac'be svocol li Jchanubtasvaneje ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tey yabinoj li Jesuse, jech lic yalbe li jchapanvanej ta nail tsobobbaile: ―Mu xavat avo'nton. Ja' no'ox ch'uno ti scotol xu' cu'une ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Li Jesuse mu sc'an ep boch'o ta xchi'in batel. Ja' no'ox laj yic' batel Pedro xchi'uc Jacovo xchi'uc yits'in, ja' li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","C'alal ic'otic ta sna li jchapanvanej ta nail tsobobbaile, laj yil Jesús ti xvochetic, ti x'avetic no'ox ta oq'uele. ");
INSERT INTO tzotze_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Li Jesuse i'och ta yut na. Jech la sjac'be: ―¿C'u yu'un ti xa'avetic no'ox ta oq'uele? Mu'yuc chamen li tsebe, ja' no'ox ta xvay ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","C'alal jech laj ya'yic li jchi'iltaccutique, la stse'intaic li Jesuse yu'un sna'ic ti chamen o li tsebe. Li Jesuse lic stacan loq'uel scotol li boch'otic tey oye. Ja' xa no'ox la scomtsan li stot sme' tsebe xchi'uc li oxibique. Tey i'ochic yo' bu telel li tsebe. ");
INSERT INTO tzotze_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Li Jesuse la stsacbe sc'ob li tsebe, jech laj yalbe: ―Talita cumi ―xut. “Tseb, chacalbot lican”, xi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta ora ilic li tsebe, ixanov batel yu'un lajchab xa jabil yich'oj. Scotol li boch'otic tey oyique toj labal sba laj yilic. ");
INSERT INTO tzotze_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Li Jesuse tsots la staq'ui li stot sme' tsebe yu'un mu me boch'o xalbe ya'yic. Laj yalbe noxtoc ti ac'o yac'beic sve'el li tsebe. ");
INSERT INTO tzotze_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Li Jesuse isut batel ta slumal, ja' li Nazarete. Tey xchi'uc batel li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","C'alal ja' xa sc'ac'alil ta jcux co'ntoncutique, li Jesuse ibat ta nail tsobobbail. Tey c'ot chanubtasvanuc. Ep boch'otic laj ya'ibeic sc'op li Jesuse. Toj ch'ayel ic'ot yo'ntonic. Jech lic yalbe sbaic: ―¿Bu la sta sbijil li jchi'iltic li'i? Toj lec li c'usi chale. Xchi'uc oy stsatsal, scotol xu' yu'un. ");
INSERT INTO tzotze_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yu'un ja' li carpinteroe, ja' yol li Maríae. Ja' yits'inab li Jacovoe, xchi'uc li Josée, xchi'uc li Judase, xchi'uc li Simone. Ja' yixlaltac noxtoc ti li' jchi'uctic ta nacleje ―xut sbaic. Jech muc xich'ic ta muc' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jech i'albatic yu'un li Jesuse: ―Buyuc no'ox ta xbatic li yaj'alc'optac Diose ta x'ich'atic ta muc'. Pero ta yosilal stuquique xchi'uc ta sna stuquique, xchi'uc ta stojol yuts' yalaltaquique mu x'ich'atic ta muc' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jech mu'yuc ep la spas sq'uelubil stsatsal tey ta slumal li Jesuse. Ja' no'ox oy jayibuc jchameletic icol yu'un ti c'alal laj yac' sc'ob ta sbec'talique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Li Jesuse ich'ay yo'nton ta sventa ti mu xch'unique. Jech ibat ta tsobtsobnaetic ti tey no'ox nopajtic ta lum Nazarete. Tey ichanubtasvan. ");
INSERT INTO tzotze_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Li Jesuse laj yic' li lajchab yajchanc'optaque. Lic stacan batel ta chabchab. Laj yac'anbe svu'elic yu'un ac'o sloq'uesic pucujetic ti ochem ta yo'nton jchi'iltaccutic ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Laj yalbe ti mu me c'usi xich'ic batele. Ja' no'ox ac'o yich' batel snamte'ic. Mu xich' batel sve'elic, me snuti'ic, me staq'uinic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ja' no'ox i'albatic ti ac'o slap batel xonobique. Mu slap batel cha'lic sc'u'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jech laj yalbe noxtoc: ―Ti bu chc'ot ach'aman anaique, tey me naclanic o. Ja' to me yu'un chabatic ta yan lume, ja' to xu' chaloq'uic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Me oy boch'o mu xac' ochanic ta snae, me mu sc'an xa'i ac'opique, loc'anic batel ta slumalic. C'alal chaloq'uic batele, lilino comel spucucal avacanic. Ja' senyail ti ja' xa icom ta sventa stuquic ti muc xich'ic ta muc' li c'usi laj avalbeique. Melel li c'usi chacalboxuque, li jchi'iltactic tey ta lum ti bu mu xayotesique, ja' más tsots castigo ta xich'ic c'alal tsta yorail ta xac' castigo li Diose. Ja' jutuc no'ox castigo ta xich'ic li cristianoetic tey ta lum Sodoma xchi'uc ta lum Gomorra ta vo'onee ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jech ibatic. Laj yalbeic jchi'iltaccutic ta israelal ti ac'o scomtsan li c'usitic chopol ta spasique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","La sloq'uesic ep pucuj ta yo'ntonic. Laj yac'beic aceite ta sjol ep jchameletic jech icol yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Li muc'ta ajvalil Erodese laj ya'i ti ep c'usitic ta spas li Jesuse yu'un scotol cristianoetic ya'yojic. Li Erodese jech laj yal: ―Le'e, ja' li Juan j'ac'vanej ta vo'e. Yu'un icha'cuxesat jech oy stsatsal ta spas li c'usitic ta spase ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oy yantic jech laj yalic: ―Ja' j'alc'op Elías ta vo'one ―xiic. Oy yantic jech laj yalic: ―Ja' yaj'alc'op Dios jech chac c'u cha'al yaj'alc'optac Dios ta vo'one ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","C'alal laj ya'i Erodes c'usi ta xal cristianoetique, jech laj yal: ―Ja' Juan ti laj cac' ta c'ocbel sjole. Yu'un icha'cuxi loq'uel ta smuquinal ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yu'un li Erodese ja' ono'ox la stac ta tsaquel li Juane. Laj yal mantal ti ac'o chucatuc ta cadena ta yut chuquinab ta scoj li Erodíase, ja' li yajnil to'ox yits'ine, ja' li Felipee. Yu'un la spojbe yajnil li yits'ine, laj yic'. ");
INSERT INTO tzotze_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ti la stic' ta chuquel Juane, yu'un chopol laj ya'i ti jech i'albate: ―Mu jechuc yaloj Dios ti laj apojbe yajnil avits'ine ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Li Erodíase chopol laj ya'i ec ti jech laj yal Juane jech tsc'an ta smil. Pero muc to xu' yu'un, yu'un chabibil yu'un soldadoetic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Li Erodese yich'oj ono'ox ta muc' li Juane yu'un sna' ti ja' tuq'uil vinique, ti mu'yuc c'usi chopol tspase. Jech laj yac' ta chabiel yu'un jech mu me xmilat. Ac'o me muc xa'ibe smelol c'usi la xchol li Juane, pero xcuxet no'ox yo'nton tsc'an cha'i. ");
INSERT INTO tzotze_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","22","Ts'acal to c'alal its'aqui sjabilal bu ora ivoc' li Erodese, la spas q'uin. Jech laj yic'an scotol li boch'otic yac'anojbe yabtele, ja' li presidenteetique, xchi'uc li capitán soldadoetique, xchi'uc li boch'otic ich'bilic ta muc' tey ta Galilea banamile. Yu'un tsc'an co'ol ta xchi'in ta ve'el ta q'uin. Li Erodíase la sna' ti ja' xa yorail xu' tsc'an ac'o milatuc li Juane. Jech tey i'och ac'otajuc stseb li Erodíase. Li Erodese xchi'uc li boch'otic tey co'ol chve'ic ta mesa xchi'uque toj lec laj yilic. C'alal ilaj yo'nton ta ac'ot li tsebe, jech lic albatuc yu'un li Erodese: ―C'anbun c'usiuc no'ox chac'an, chacac'bot. ");
INSERT INTO tzotze_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yiloj Dios ti chacac'bote. Ac'o me chac'anbun ta o'lol ti c'u smuc'ul jventainoje, chacac'bot ―xut li tsebe. ");
INSERT INTO tzotze_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jech iloc' sjac'be sme' li tsebe: ―¿C'usi ta jc'an xana'? ―xut. Itac'ov li sme'e: ―Ja' xac'anbe sjol li Juan j'ac'vanej ta vo'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jech ital ta anil li tsebe, i'och yo' bu oy li Erodese. Jech laj yalbe: ―Ja' ta jc'an chavac'bun ta ora ta plato sjol li Juan j'ac'vanej ta vo'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Li Erodese ep laj yat yo'nton. Pero ta scoj ti la st'abbe sbi Diose, xchi'uc tey laj ya'yic noxtoc li boch'otic tey co'ol oyic ta mesa xchi'uque, jech la snop ti mu xa xu' tsutes sc'ope. ");
INSERT INTO tzotze_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jech ta ora la stac batel jun yajsoldado yu'un ac'o bat sc'ocbe tal sjol li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ibat li soldadoe, bat sc'ocbe tal sjol li Juane. La xlechan tal ta jun plato. Laj yac'be li tsebe. Li tsebe bat yac'be li sme'e. ");
INSERT INTO tzotze_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","C'alal laj ya'yic li yajchanc'optac Juane, i'ay yich'beic li sbec'tale, la smuquic ta vombil ton. ");
INSERT INTO tzotze_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Li lajchab itacatic batel yu'un Jesuse isutic tal ta stojol li Jesuse. Vul yalbeic Jesús scotol li c'usitic la spasique xchi'uc ti c'u x'elan ichanubtasvanique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ep boch'otic italic jech mu spas xve'ic. Jech lic yalbe yajchanc'optac li Jesuse: ―Ja' lec batic ta xocol banamil jech xu' tey chacuxic jutuc ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jech i'ochic ta tenalte' canova. Stuquic no'ox ibatic ta xocol banamil. ");
INSERT INTO tzotze_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ep boch'o i'ilvanic ti c'alal ibatique. Laj yotquinic ti tey oy li Jesuse jech ta yacan ibatic ta anil ta ti'ti'nab. Ep ta lum ti bu iliquic batele. Ja' ba'yuc ic'otic ta xocol banamil li stuquique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","C'alal iloc' ta canova li Jesuse, laj yil ti tey xa tsobol epal cristianoetique. La xc'uxubin yu'un ja' jechic jech chac c'u cha'al chij ti mu'yuc jchabivanej yu'unique. Jech tey lic xchanubtas. Ep c'usitic laj yalbe. ");
INSERT INTO tzotze_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","C'alal mal xa'ox c'ac'ale, jech i'albat yu'un yajchanc'optac li Jesuse: ―Bat xa c'ac'al, xocol banamil li'i. ");
INSERT INTO tzotze_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ja' lec taco batel li cristianoetique ac'o bat sman sve'elic ta tsobtsobnaetic xchi'uc ta yantic naetic ti li' no'ox nopolique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Itac'ov li Jesuse: ―Ac'beic sve'el vo'oxuc ―x'utatic. Itac'ovic: ―¿Bu ta jtacutic chib ciento denario taq'uin sventa ta jmancutic o pan ti chcac'becutic sve'ique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Itac'ov li Jesuse: ―¿Jayib pan avich'ojic tal? Bat q'uelic ―x'utatic. C'alal laj yilic c'u yepale, laj yalbeic li Jesuse: ―Vo'ob xchi'uc cha'cot choy ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Li Jesuse laj yalbe cristianoetic ti c'u yepal chic' sbaic ta jujutsobe, xchi'uc ti ac'o chotiicuc ta c'unil jobeltique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jech lic chotiicuc ta jujutsob. Oy laj yic' sbaic ta vo'vinic (100), oy laj yic' sbaic ta lajuneb yoxvinic (50). ");
INSERT INTO tzotze_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Li Jesuse la stsac li vo'ob pane xchi'uc li cha'cot choye. La sq'uel muyel vinajel, la stojbe ta vocol Dios. La svoc' li pane, laj yac'be li yajchanc'optaque. Ja' xa la spucbeic li cristianoetique. La svoc' noxtoc li cha'cot choye, la spucbeic scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lec ive'ic, inoj xch'ut scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Li yajchanc'optaque lic stsobic li scomelal pane xchi'uc li scomelal choye. Inoj yu'unic lajcha'moch. ");
INSERT INTO tzotze_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Li c'u yepal ive'ique ja' vo'mil viniquetic. Ja' no'ox atbil li viniquetique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Li Jesuse laj yalbe yajchanc'optac ti ac'o ochicuc ta ora ta tenalte' canovae, yu'un ac'o jelovicuc batel ta jot nab tey ta lum Betsáida. Tey to icom li Jesuse. Stuc xa la sc'opan comel li jchi'iltaccutique. ");
INSERT INTO tzotze_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","C'alal la sc'opan comele, ibat ta vits li Jesuse. Bat sc'opan Dios. ");
INSERT INTO tzotze_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","C'alal ch'ayem xa'ox c'ac'ale, tey xa oyic ta o'lol nab ta canova li yajchanc'optaque. Li Jesuse tey to oy stuc ta vits. ");
INSERT INTO tzotze_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Li Jesuse laj yil ti lubenic xa ta xlechuel li canovae yu'un tsots chnet'van li iq'ue. C'alal po'ot xa tsacub osile, ibat yo' bu oyic yajchanc'optaque. Ixanov batel ta yacan ta ba vo'. Snopoj ti tuc' chjelov batele. ");
INSERT INTO tzotze_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","C'alal laj yilic ti ta yacan chanov batel ta ba vo'e, la snopic ti ja' ch'ulelale. X'avetic xa ta scoj xi'el. ");
INSERT INTO tzotze_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jech i'albatic ta ora yu'un li Jesuse: ―Mu me xaxi'ic, vu'un Jesusun. Tsatsubtaso avo'ntonic ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","C'alal i'och xchi'in ta canova li yajchanc'optaque, ta ora ich'abi li iq'ue. Jech toj ch'ayel ic'ot yo'ntonic li yajchanc'optaque yu'un muc sna'ic c'uxi ich'abi li iq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mu sna'ic noxtoc ti ja' ta svu'el Jesús i'epaj li pane yu'un muc to chc'ot ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","C'alal ic'otic ta jot nabe, tey iloq'uic ta canova ta jun banamil Genesaret sbi. Tey la xchuquic li canovae. ");
INSERT INTO tzotze_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","C'alal iloq'uic ta canova li Jesuse, ta ora i'otquinat yu'un li jchi'iltaccutic ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jech ta ora bat yalic ta scotol Genesaret ti tey xa oy ta yosilalic li Jesuse. C'alal laj ya'yic bu oy li Jesuse, ta ora la sq'uechubte'ic tal xchi'uc svayab li jchameletic yu'unique, tey tal yaq'uic ta stojol li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Buyuc ono'ox i'och li Jesuse, me ta bic'tal lum, me ta muc'ta lum, me ta tsobtsobnaetic, tey tal xpuch'anic ta bebetic li jchameletique. Oy jchameletic la sc'anbeic Jesús ti ac'o me yoc sc'u' no'ox ta spicbeique. Li boch'otic la spicbeic yoc sc'u'e icolic ec. ");
INSERT INTO tzotze_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tey italic ta stojol Jesús jayibuc fariseoetic xchi'uc jayibuc jchanubtasvanejetic ta smantal Dios yalojic. Tey iliquic tal ta Jerusalén. ");
INSERT INTO tzotze_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tey laj yilic ti oy jayibuc yajchanc'optac Jesús mu'yuc jal la spoc sc'ob c'alal ive'ique. Yu'un chalic ti oy mulil ta sc'obic li boch'otic jech tspasique. Chalic ti mu'yuc lec ch‑ilatic o yu'un Diose. Jech tey lic sa'beic smul. ");
INSERT INTO tzotze_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Yu'un li fariseoetique xchi'uc scotol li jchi'iltaccutic ta israelale ja' yich'ojbeic stalel li moletic ta vo'onee. Me mu'yuc jal ta spoc sc'obique mu'yuc ta xve'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","C'alal me isutic tal ta ch'ivite, mu'yuc ta xve'ic ti me mu'yuc jal ta spoc sc'obique. Oy to ep yan c'usi xch'unojic, ja' ti c'u x'elan ta suc' xbochique, xchi'uc sjarroic, xchi'uc sbinic, xchi'uc c'u x'elan ta spoc svayabic.) ");
INSERT INTO tzotze_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Li fariseoetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique jech la sjac'beic li Jesuse: ―¿C'u yu'un mu'yuc yich'ojbeic stalel moletic ta vo'one li avajchanc'optaque? Yu'un mu'yuc jal ta spoc sc'obic ti c'alal ta xve'ique ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Itac'ov li Jesuse: ―Jlo'lavanejoxuc. Ja' ac'oplalic ti jech i'albat yu'un Dios li j'alc'op Isaías ta vo'onee: Li achi'iltaque chiyich'icun ta muc' ta yeic no'ox, solel mu'yucun ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Altic ta xalic ti chiyich'icun ta muq'ue. Ja' smantal no'ox cristiano ta xchanubtasvanic; muc ja'uc jc'op ti chaq'uic ta chanele, xi li Diose, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yu'un li vo'oxuque ja' acomtsanojbeic li smantal Diose. Ja' avich'ojbeic stalel li cristianoetique, ja' ti c'u x'elan chasuq'uic ajarroique, xchi'uc li abochique, xchi'uc li c'usitic yan chapasique ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jech laj yalbe noxtoc: ―Bijoxuc ta snopel c'usi chavalic c'u x'elan xu' chacomtsanbeic o smantal Dios ta sventa ti ja' avich'ojbeic stalel moletic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yu'un jech yaloj li Moisese: “Ich'o ta muc' atot ame'”, xi. Jech yaloj noxtoc: “Boch'o yan xich' xalbe stot sme'e ja' ta xmilat”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero li vo'oxuque lec chava'yic me jech chalbeic li stot sme'ique: “Ti c'u yepal ta jtailane laj xa cal ti chcac' ta sventa smoton Diose”, me xutique, li vo'oxuque lec chava'yic ti jech chalique. ");
INSERT INTO tzotze_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chavalbeic ti xu' xa mu xc'uxubin o stot sme'ique. ");
INSERT INTO tzotze_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ja' jech chacomtsanbeic o smantal Dios ta scoj ti ja' avich'ojbeic stalel li moletic ta vo'onee. Oy to ep c'usi yan jech co'ol chapasic ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Li Jesuse laj yic' yan velta ta stojol scotol li jchi'iltaccutique, jech laj yalbe: ―A'yo me ava'yic li c'usi ta xcalboxuque. A'ibeic lec smelol. ");
INSERT INTO tzotze_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Li c'usitic chave'ique mu ja'uc jech chopol chayiloxuc o li Diose. Ja' no'ox li c'usitic chopol chanop ta avo'ntonique jech chopol chayiloxuc li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Boch'o laj ya'i ac'o snopbe lec smelol ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Li Jesuse la scomtsan li cristianoetique, i'och ta na ti bu ono'ox nacale. Tey lic jac'batuc yu'un yajchanc'optac c'usi smelol li c'usi laj yale. ");
INSERT INTO tzotze_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jech laj yal li Jesuse: ―¿Me mu xava'ibeic smelol ec li vo'oxuque? ¿Me mu xana'ic ti mu chopoluc chayiloxuc Dios yu'un li c'usitic chave'ique? ");
INSERT INTO tzotze_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yu'un mu x'och ta avo'ntonic. Ta ach'utic ta xbat, ja' o ta xloc' ―x'utatic. Ja' laj yalbe smelol Jesús ti lec scotol li ve'lile. ");
INSERT INTO tzotze_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jech laj yalbe noxtoc li yajchanc'optaque: ―Li c'usi chopol ta snop ta yo'nton cristianoetique ja' chopol ch‑ilat o yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Yu'un ta yut yo'nton cristiano ta xlic tal li c'usi chopol ta snope, me ta xmulivaj, me ta xmilvan, me ta x'elc'aj, me ta sc'upinbe c'usitic oy yu'un yan cristiano, me ta xcontrainvan, me ta xlo'lavan, me mu xq'uexov ta spasel li c'usi chopole, me xti'et no'ox yo'nton, me ta slo'ilta xchi'il, me ta stoy sba, me toj bol. ");
INSERT INTO tzotze_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Scotol li c'usitic chopol li'i ja' ta avo'ntonic ta xlic tal, jech chopol chayiloxuc o li Diose ―xut yajchanc'optac li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iloc' batel xchi'uc yajchanc'optac li Jesuse. Ibat ta yosilal chib lum, Tiro xchi'uc Sidón. Tey i'och ta jun na. Mu sc'an xvinaj ti bu oye pero ivinaj ta ora. ");
INSERT INTO tzotze_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yu'un tey oy jun ants ochem pucuj ta yo'nton stseb. Laj ya'i ti tey xa oy li Jesuse. Jech ta ora ital, la squejan spatan sba ta stojol li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Li antse ma'uc jchi'ilcutic ta israelal, ja' tey liquem tal ta Sirofenícia banamil. Ac'o me mu ono'ox lecuc chquilcutic li boch'otic muc ja'uc jchi'ilcutic ta israelale, pero li antse scotol yo'nton la sc'anbe Jesús ti ac'o loq'uesbatuc li pucuj ochem ta yo'nton stsebe. ");
INSERT INTO tzotze_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jech i'albat yu'un li Jesuse: ―Ac'o nojicuc ba'yuc li nich'naletique. Mu lecuc me ta jpojbetic yot yu'un ta xcac'betic sve' unin ts'i'etic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Itac'ov li antse: ―Jech chaval, tata. Li vu'une ja' jechun jech chac c'u cha'al li unin ts'i'etique. Yan li achi'iltac ta israelale ja' jechic jech chac c'u cha'al li nich'naletique. Pero c'alal ta xve'ic li nich'naletique, oy ono'ox ta xbaj yalel xch'uch'ulil yotic ta yolon mesa. Ja' ta stam sve'ic li unin ts'i'etique. Jech li vu'une c'uxubinun ―xi li antse. ");
INSERT INTO tzotze_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Li Jesuse jech laj yalbe: ―Ta sventa ti jech laj avale, loq'uem xa pucuj ta yo'nton li atsebe jech xu' chabat ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jech ibat li antse. C'alal ic'ot ta snae, mochol xa ta svayab c'ot sta li stsebe yu'un loq'uem xa c'ot sta li pucuj ti ochem ta yo'ntone. ");
INSERT INTO tzotze_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Li Jesuse iloc' batel ta yosilal tiroetic, ijelov batel ta yosilal sidonetic xchi'uc ta yosilal lajuneb lumetic. Tey ic'ot ta ti'nab ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tey laj yic'beic tal ta stojol Jesús jun jchi'ilcutic ta israelal uma' xchi'uc macal xchiquin. La sc'anbeic Jesús ti ac'o yac' sc'ob ta sbec'tal li vinique yu'un ac'o coluc. ");
INSERT INTO tzotze_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Li Jesuse slecoj laj yic' loq'uel stuc li vinique, la stic' ochel sni' sc'ob ta jujun xchiquin. Xchi'uc la stubta sc'ob, la spicbe yoc' li vinique. ");
INSERT INTO tzotze_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","La sq'uel muyel vinajel, la sjic' yo'nton, jech laj yalbe li vinique: ―Efata ―xut. “Ac'o jamuc”, xi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ta ora ijam li xchiquine xchi'uc li yee, lec lic c'opojuc. ");
INSERT INTO tzotze_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Li Jesuse laj yalbe cristianoetic ti mu me boch'o xalbeic batele pero muc xch'unic. Ac'o me ep ta velta i'albatic ti mu me xalique, más to lic yalic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yu'un toj labal sba laj yilic, jech laj yalic: ―Toj lec c'usitic ta spas li Jesuse. Ac'o me uma' xchi'uc macal xchiquin, xu' yu'un tscolta ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Bats'i ep jchi'iltaccutic la stsob sbaic yan velta ta stojol li Jesuse, mu'yuc c'usi ta sve'ic noxtoc. Jech lic yic' yajchanc'optac li Jesuse, jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Toj abul sbaic li jchi'iltactic li'i yu'un yoxibal xa c'ac'al li' xchi'inojutic, mu'yuc xa c'usi ta sve'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Me jech mu'yuc ve'emic ta jtac batele, oy yic'al ta x'alubic ta be. Yu'un oy nom liquemic tal ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Itac'ovic li yajchanc'optaque: ―¿Bu ta jtacutic epal pan li' ta xocol banamil sventa ta jmac'lincutic li vu'uncutique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ijac'batic yu'un li Jesuse: ―¿Jayib pan avich'ojic? ―x'utatic. ―Vucub ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Li Jesuse laj yalbe cristianoetic ti ac'o chotiicuc ta lumtique. La stsac li vucub pane, la stojbe ta vocol Dios. La svoc' li pane, laj yac'be yajchanc'optac. Jech la spucbeic li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oy jaycotuc unin bic'tal choy noxtoc. La stojbe ta vocol Dios noxtoc li Jesuse. Laj yal ti ac'o spucbeic cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lec ive' scotolic, inoj xch'utic o. Li yajchanc'optaque lic stsobbeic li scomelale, inoj yu'unic vucub moch. ");
INSERT INTO tzotze_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Li c'u yepal ive'ique oy van chanmiluc. C'alal ive'ique, itacatic batel ta snaic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Li Jesuse ta ora i'och ta canova xchi'uc yajchanc'optac. Ibatic ta Dalmanuta banamil. ");
INSERT INTO tzotze_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Italic jayibuc fariseoetic, tal sc'opanic li Jesuse yu'un tsq'uelic me xu' tey ta stabeic o smul. La sc'anbeic ti ac'o spas senyail stsatsal ta vinajele yu'un jech tsna'ic o ti ja' ac'bil yabtel yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tsots la sjic' yo'nton li Jesuse, jech laj yalbe: ―¿C'u yu'un ti chac'anic ta jpas senyail jtsatsal ta vinajel, vo'oxuc ti li' oyoxuc ta orae? Yu'un ja' to laj cac' avilic ti scotol xu' cu'une. Melel chacalboxuc, mu'yuc xa yan senyail cha'ac'bat avilic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Li Jesuse la scomtsan li fariseoetique. I'ochic yan velta ta canova xchi'uc yajchanc'optac. Ibatic ta jot nab. ");
INSERT INTO tzotze_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Li yajchanc'optac Jesuse muc xt'ab ta yo'nton laj yich' batel spanic. Jun no'ox pan tey yich'ojic batel ta canova. ");
INSERT INTO tzotze_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Q'uelo me abaic ta sventa svolesubil xch'ut pan yu'un fariseoetic xchi'uc svolesubil xch'ut pan yu'un Erodes ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Li yajchanc'optaque jech laj yalbe sbaic: ―Ja' van ta xalbutic ti muc xquich'tic tal jpantique ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Li Jesuse la sna' li c'usi laj yalique, jech laj yalbe: ―¿C'u yu'un ja' chanopic ta sventa ti muc xavich'ic tal jpantique? Yu'un mu'yuc to ach'unojic lec ti scotol xu' cu'une. Yu'un tsots avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oy asatic pero muc xavilic. Oy achiquinic pero muc xava'yic. ¿Me yu'un mu xa xana'ic li c'usi la jpase? ");
INSERT INTO tzotze_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","C'alal la jvoc' vo'ob pan sventa la jmac'lintic vo'mil viniquetique, ¿jayib moch laj ataic li scomelal laj atsobique? ―x'utatic. ―Lajcha'moch ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Ta yan velta c'alal la jvoc' vucub pan sventa chanmile, ¿jayib moch laj ataic li scomelal laj atsobique? ―x'utatic. ―Vucub ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jech i'albatic yu'un li Jesuse: ―¿Me muc to chava'ibeic smelol ti ja' ta sventa c'u x'elan ta xchanubtasvanic fariseoetic li c'usi laj calboxuque? ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tey ic'otic ta lum Betsáida xchi'uc yajchanc'optac li Jesuse. Tey la snitic tal ta stojol Jesús jun jchi'ilcutic ta israelal yu'un ma'sat. La sc'anbeic Jesús ti ac'o sjambe sate. ");
INSERT INTO tzotze_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Li Jesuse la stsacbe sc'ob li ma'sate, laj yic' loq'uel ta pat lum. La stubtabe li sate, la spicbe ta xchibal sc'ob. La sjac'be me ta xil xa jutuc osil. ");
INSERT INTO tzotze_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Li vinique la sq'uel osil, jech laj yal: ―Ta xquil ta xanovic li cristianoetique. Pero xco'laj xchi'uc te'etic ta xquil ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Li Jesuse la spicbe yan velta li sate, laj yac'be o lec sq'uel osil. Jech ijam o li sate, lec xa xil osil. ");
INSERT INTO tzotze_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Li Jesuse la stac batel ta sna li vinique, jech laj yalbe: ―Mu me xa'och ta yut lum. Mu me boch'o xavalbe tey ta yut lum ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Li Jesuse ibatic xchi'uc yajchanc'optac ta tsobtsobnaetic tey ta nopol muc'ta lum Cesarea yu'un Felipe. C'alal chanovic batel ta bee, jech lic sjac'be yajchanc'optac li Jesuse: ―¿Boch'oun ta xalic li jchi'iltactique? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Itac'ovic: ―Oy ta xalic ti vo'ot Juan j'ac'vanejot ta vo'e. Oy yan ta xalic ti vo'ot Elíasote. Oy yan ta xalic ti vo'ot yan yaj'alc'opot Dios ta vo'onee ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jech ijac'batic yu'un li Jesuse: ―Li vo'oxuque ¿boch'oun chavalic ec? ―x'utatic. Itac'ov li Pedroe: ―Vo'ot Cristoot ti t'ujbilot yu'un Dios chaventainuncutique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Li Jesuse laj yalbe yajchanc'optac ti mu to me boch'o xalbeic ti ja' t'ujbil yu'un Dios chventainvane. ");
INSERT INTO tzotze_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Li Jesuse jech lic yalbe li yajchanc'optaque: ―Vu'un ti co'ol cristianoutique, ta persa ta xca'i ep jvocol yu'un mu xiyich'icun ta muc' li jchapanvanejetique, xchi'uc li banquilal paleetique, xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Chiyaq'uicun ta milel. Chimucat, pero chicha'cuxi ta yoxibal c'ac'al ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Li Jesuse jamal laj yal ti chmilate. Li Pedroe laj yic' loq'uel jutuc li Jesuse, jech laj yalbe: ―Q'uelo me aba, mu me xc'ot ta pasel ti chamilate ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ijoyij li Jesuse, la sq'uel li yajchanc'optaque. Jech laj yalbe li Pedroe: ―Satanás, loc'an me ta jtojol. Ma'uc chanop c'usi tsc'an Dios. Ja' no'ox chanop c'usi ta sc'an cristiano ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Li Jesuse laj yic' ta stojol li epal cristianoetique xchi'uc li yajchanc'optaque. Jech laj yalbe: ―Li boch'o tsc'an ta xchi'inune mu me xc'uxubin sba. Ac'o ts'icuc yu'un vocol jech chac c'u cha'al ta sts'ic cu'une ac'o me tey ta xcham o, jech xu' chixchi'inun. ");
INSERT INTO tzotze_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Li boch'o mu sc'an xcham ta jcoje ja' ch'ayel ta xbat. Yan li boch'o mu sventauc me ta xchame, vu'un ta jventa yu'un jech tspuc batel li jc'ope, ja' ta xcuxi o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ac'o me oy boch'o xu' yu'un ta xu'uninic scotol li c'usitic oy li' ta banamile, pero mu'yuc c'usi ta xtun o, yu'un mu xcuxiic o sbatel osil. Yu'un ja' tsots sc'oplal ti chacuxiic sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Boch'otic ta xq'uexov ta xch'unel jc'op ta stojol cristianoetic li' ta ora ti mu junuc yo'ntonic ta stojol Diose, xchi'uc ti chopol c'usitic tspasique, “ma'uc jnich'on”, xichi ti c'alal ta xicha'tal, vu'un ti co'ol cristianoutique. C'alal ta xitale, quich'ojbe tal xojobal Jtot, xchi'uc ta jchi'inbe yalel tal li yaj'almantaltaque ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jech laj yal noxtoc li Jesuse: ―Melel li c'usi chacalboxuque, oy boch'o avu'unic li'i ti mu'yuc to ta xchamique ja' to me laj yilic ti chlic sventainanbe yo'nton cristianoetic li Diose, ja' ti chjelbat yo'ntonic ta stsatsal Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","C'alal ech'em xa'ox vaquib c'ac'ale, li Jesuse laj yic' batel Pedro, xchi'uc Jacobo, xchi'uc Juan. Stuquic no'ox laj yic' muyel ta jun toyol vits. Tey la sc'atajes sba ta stojol li oxibique. ");
INSERT INTO tzotze_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Li sc'u' Jesuse isacub ta jyalel. Mu'yuc boch'o jech sna' xchuc'umaj ta sbejel banamil ti toj saque. ");
INSERT INTO tzotze_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tey ivinaj Elías xchi'uc Moisés ta stojolic, tey la xchi'in sbaic ta lo'il xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Li Pedroe jech laj yalbe li Jesuse: ―Jchanubtasvanej, lec ti li' oyutique. Ja' lec ta jpascutic oxbej vacaxna li'i; jun avu'un, jun yu'un Moisés, jun yu'un Elías ―xut, ");
INSERT INTO tzotze_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","yu'un muc snop lec li c'usi laj yale yu'un ep ixi'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ital jun toc, jech macbil ta toc ic'ot scotolic. Tey laj ya'yic ic'opoj ta yut toc li Diose: ―Li'i ja' Jnich'on, lec c'ux ta co'nton. A'ibeic sc'op ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","C'alal ijame, la sq'uelic ta jujujot, pero mu'yuc xa boch'o laj yilic, ja' xa no'ox stuc tey oy li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","C'alal ja' o ta xyalic tal ta vitse, jech i'albatic yu'un li Jesuse: ―Mu to me boch'o xavalbeic li c'usi laj avilique ja' to me licha'cuxi loq'uel ta jmuquinal, vu'un ti co'ol cristianoutique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jech mu'yuc boch'o laj yalbeic, tey no'ox la xchabi ta yo'ntonic. Ja' no'ox ilo'ilaj stuquic ta sventa c'usi smelol ti ta xcha'cuxi loq'uel ta smuquinale. ");
INSERT INTO tzotze_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jech la sjac'beic li Jesuse: ―¿C'u yu'un ta xalic jchanubtasvanejetic ta smantal Dios ti ta persa ba'yuc ta xtal li Elíase, ti ts'acal chatal vo'ote? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Itac'ov li Jesuse: ―Ta melel jech ono'ox ts'ibabil ta sc'op Dios ti ja' ba'yuc ta xtal li Elíase, yu'un chtal yalbe ti ac'o scomtsan c'usitic chopol tspasic li jchi'iltactique. Xchi'uc ts'ibabil ono'ox jc'oplal ec ti ta persa ta xca'i jvocol, vu'un ti co'ol cristianoutique, yu'un mu xic'anat. ");
INSERT INTO tzotze_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Vu'un ta xcalboxuc ti jeloven xa li Elíase, ja' li Juan j'ac'vanej ta vo'e. Pero li cristianoetique la spas c'usi la sc'an yo'nton stuquic, jech la smilic. Yu'un jech ono'ox ts'ibabil sc'oplal li Juane ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","C'alal ic'otic yo' bu oyic li yan yajchanc'optaque, laj yil tey setelic epal cristianoetic. Tey oyic li jchanubtasvanejetic ta smantal Dios yalojique, tey ta xutilan sbaic xchi'uc li yajchanc'optac Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","C'alal laj yilic Jesús li cristianoetique ch'ayem yo'nton itaatic. Anil bat sc'opanic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jech ijac'batic yu'un li Jesuse: ―¿C'usi chajac'be abaic achi'uc li cajchanc'optaque? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Itac'ov jun li boch'o tey tsobolique: ―Jchanubtasvanej, li' quic'oj tal ta atojol jquerem yu'un ochem pucuj ta yo'nton. Jech pasem o ta uma'. ");
INSERT INTO tzotze_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Buyuc no'ox ta xlic uts'intaatuc yu'un li pucuje. Ta xjipat ta lum, ta xvocan ye, ta xc'ux ye, ta ste' sba. Laj calbe avajchanc'optac ti ac'o sloq'uesique pero muc xloc' yu'unic ―xi li vinique. ");
INSERT INTO tzotze_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Itac'ov li Jesuse: ―Tsots avo'ntonic, mu xac'an xach'unic. Ep xa c'ac'al li' jchi'ucoxuque pero mu'yuc to chach'unic. Ep xa c'ac'al la jts'icboxuc ti c'u xa'elanique. Iq'uic tal li quereme ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Laj yiq'uic tal li quereme. Li pucuj ti ochem ta yo'nton quereme, c'alal laj yil li Jesuse, ta ora la sjip ta lum li quereme. Tey xbalet ta lumtic, iloc' svoc ye. ");
INSERT INTO tzotze_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Li Jesuse jech la sjac'be stot li quereme: ―¿C'u xa sjalil sliquel ti jech tspase? ―xut. ―Vo'one xa. Biq'uit to'ox ti c'alal ilic yu'une. ");
INSERT INTO tzotze_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ep ta velta ijipat ta c'oc', ijipat ta vo' yu'un chmilat. Pero me xu' avu'une, c'uxubinbun, coltabun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Li Jesuse jech laj yalbe: ―Me chach'une, xu'. Yu'un scotol li boch'o ta xch'une ta spasbat scotol ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ta ora tsots i'avan stot li quereme: ―Ta jch'un. Coltaun me oy to c'usi mu jch'un chavile ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","C'alal laj yil Jesús ti ta stsin xa sbaic tal ep cristianoetique, laj yut loq'uel ta ora li pucuje. Jech laj yalbe: ―Pucuj, vo'ot ta acoj ti jech pasem ta uma' li quereme xchi'uc ti macal xchiquine, vu'un chajtacot loq'uel. Loc'an ta yo'nton li quereme. Mu xa me xa'och yan velta ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsots i'avan li pucuje, la stu'pbe comel yic' li quereme, ja' o iloc' batel. Li quereme chamen icom yilel. Ep boch'otic laj yalic ti icham oe. ");
INSERT INTO tzotze_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Li Jesuse la stsacbe sc'ob li quereme, la snit liquel. Jech ilic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ts'acal to c'alal tey xa'ox oyic ta na yo' bu ono'ox nacal li Jesuse, jech ijac'bat yu'un li yajchanc'optaque: ―¿C'u yu'un muc xu' cu'uncutic la jloq'uescutic li pucuje? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Itac'ov li Jesuse: ―Li jchop o ta pucujetic la jloq'uese, ja' to ta xloc' me chac'opanic Diose, xchi'uc me chavictaic ixime ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","C'alal iloq'uic batel ta Capernaum xchi'uc yajchanc'optac li Jesuse, tey ibatic ta yantic lum ta Galilea banamil. Pero mu sc'an ta xich' a'yel me tey chanov li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yu'un tsc'an ta xchanubtas li yajchanc'optaque. Jech laj yalbe: ―Vu'un ti co'ol cristianoutique ta xi'ac'at ta sc'ob cristianoetic. Ta xismilicun. Chimucat pero chicha'cuxi ta yoxibal c'ac'al ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Li yajchanc'optaque muc xa'ibeic smelol. Pero muc xa sjac'beic smelol yu'un ta xi'ic ta sjac'bel. ");
INSERT INTO tzotze_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Li Jesuse isutic batel ta Capernaum xchi'uc li yajchanc'optaque. C'alal ochem xa'ox ta na yo' bu nacal li Jesuse, jech la sjac'be li yajchanc'optaque: ―¿C'usi laj avalbe abaic tal ta bee? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Muc xtac'ov ic'otic yu'un ta be laj yutilan sbaic ta sventa boch'o junucal más banquilal ta xc'ot yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ichoti li Jesuse. Laj yalbe ti ac'o noch'ajicuc tal xlajchabalique, jech laj yalbe: ―Boch'o tsc'an ich'bil ta muc' avu'unique biq'uit ac'o yac' sba ta atojolic, ac'o scoltaoxuc ―xut li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Laj yic' ta stojol jun olol li Jesuse. Tey la sva'an ta o'lol yo' bu oyique. Ts'acal la spet. Jech laj yalbe li yajchanc'optaque: ");
INSERT INTO tzotze_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Boch'otic ta xich' ta muc' li boch'o jech yo'nton jech chac c'u cha'al li olol li'i, vu'un ta jventa, jech vu'un chiyich'un o ta muc'. Pero ma'uc no'ox vu'un chiyich'un ta muc', ja' ta xich' o ta muc' li Diose, ja' ti la stacun tale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Li Juane jech laj yalbe li Jesuse: ―Jchanubtasvanej, oy boch'o laj quilcutic ta sloq'ues pucujetic ta yo'nton cristianoetic. Ta xal abi ti c'alal ta sloq'uese, pero la jpajescutic yu'un muc li'uc jchi'uctic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Itac'ov li Jesuse: ―Mu me xapajesic. Yu'un li boch'o tspas sq'uelubil jtsatsal ta jventae mu chopoluc chiyalbun jc'oplal ta ts'acal. ");
INSERT INTO tzotze_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yu'un li boch'o chloc' yu'un pucuj jech chac c'u cha'al chloc' cu'untique, ja' co'ol co'ntontic jchi'uctic. ");
INSERT INTO tzotze_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Boch'o ja' no'ox ta xac'boxuc junuc vaso yoxo' avuch'ic yu'un chilic ti chatunic cu'un, vu'un li Cristoune, melel chacalboxuc ta xich' smotonic ta sventa ti jech la spasique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jech laj yal noxtoc li Jesuse: ―Boch'o ta socbe yo'nton li boch'o jech yo'nton jech chac c'u cha'al ololetic ti xch'unoj ti vu'un Jcoltavanejune, ja' lec ac'o chucuc jun muc'ta cho' ta snuc', ac'o jipatuc ochel ta nab, tey ac'o chamuc o. ");
INSERT INTO tzotze_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Me ta scoj no'ox ac'obic chata o amulique, ja' lec ti mu'yucuc ac'obic ya'yel jech chac c'u cha'al li boch'o mu'yuc sc'obe, jech xu' cha'ochic ta lequilal. Ja' abul abaic me ta scoj no'ox oy c'usi jutuc mu xacomtsanic spasel ti chabatic ta muc'ta c'oc' ti mu ono'ox xtu'p oe. ");
INSERT INTO tzotze_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yu'un tey ta muc'ta c'oq'ue mu'yuc ono'ox ta x'ech' o li vocole, mu'yuc ono'ox ta xtu'p o li c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jech noxtoc me ta scoj no'ox avacanic chata o amulique, ja' lec ti mu'yucuc avacanic ya'yel jech chac c'u cha'al li boch'o mu'yuc yacane, jech xu' cha'ochic ta lequilal. Ja' abul abaic me ta scoj no'ox oy c'usi jutuc mu xacomtsanic spasel ti chabatic ta muc'ta c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yu'un tey ta muc'ta c'oq'ue mu'yuc ono'ox ta x'ech' o li vocole, mu'yuc ono'ox ta xtu'p o li c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jech noxtoc me ta scoj no'ox asatic chata o amulique, ja' tsc'an ti ma'satoxuc ya'yel jech chac c'u cha'al li boch'o ma'sate, jech xu' cha'ochic yo' bu tspas mantal Dios. Ja' abul abaic me ta scoj no'ox oy c'usi jutuc mu xacomtsanic sq'uelel ti chabatic ta muc'ta c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yu'un tey ta muc'ta c'oq'ue mu'yuc ono'ox ta x'ech' o li vocole, mu'yuc ono'ox ta xtu'p o li c'oq'ue. ");
INSERT INTO tzotze_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Li boch'o tsc'an chtun yu'un Diose persa ta sts'ic vocol yu'un jech lec ch‑ilat yu'un Dios. Jech chac c'u cha'al ti persa i'ac'bat yats'amil smoton Dios ta vo'onee yu'un jech lec laj yil li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Li ats'ame oy stu. Pero me ch'ayem xa xchi'il li ats'ame, mu'yuc xa stu o yu'un mu xa x'ayin xchi'il yan velta. Ja' no'ox jech ec li vo'oxuque, tsc'an ti chats'iquic vocole, xchi'uc tsc'an ti jun avo'nton acotolique jech oy atuic ―xut yajchanc'optac li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iloc' batel ta Capernaum xchi'uc yajchanc'optac li Jesuse, ibat ta Judea banamil, xchi'uc ibat ta jot uc'um Jordán. Bats'i ep jchi'iltaccutic la stsob sbaic yan velta ta stojol li Jesuse. Li Jesuse lic xchanubtas jech chac c'u cha'al ta spas ono'oxe. ");
INSERT INTO tzotze_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tey italic ta stojol Jesús jayibuc fariseoetic yu'un oy c'usi tsc'an ta sjac'beic, yu'un ta sq'uelic me xu' tey ta stabeic o smul. Ja' la sjac'beic me xu' ta xicta yajnil li viniquetique. ");
INSERT INTO tzotze_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Itac'ov li Jesuse: ―¿C'usi mantal yaloj comel li Moisese? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Itac'ovic: ―Li Moisese laj yal mantal ti xu' ac'o spasbe svunal ta sventa ti muc xa yajniluque, ac'o yac'be li yajnile jech xu' ta xicta ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Itac'ov li Jesuse: ―Ja' ta scoj toj tsots yo'nton jmoltotactic ta vo'one ti jech laj yal mantal li Moisese. Ja' yu'un jech la sts'iba comel. ");
INSERT INTO tzotze_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ta sliqueb c'alal lic spas scotol c'usitic oy li Diose, jun vinic xchi'uc jun ants no'ox la spas. ");
INSERT INTO tzotze_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja' yu'un jech ts'ibabil ta sc'op Dios: “Jech li viniquetique ta scomtsan stot sme'ic yu'un ta xic' yajnilic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Li chibique jun no'ox ta xc'otic”, xi. Jech muc xa chibicuc, jun xa no'ox ic'otic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Li boch'otic pasbilic xa ta jun yu'un Diose, mu xu' ta xicta sbaic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ts'acal to c'alal tey xa'ox oyic ta na yo' bu ono'ox nacal li Jesuse, tey más ijac'bat yu'un yajchanc'optac c'usi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Li Jesuse jech laj yalbe: ―Li boch'o ta xicta yajnile, me ta xic' yajnilin yan ants, ja' no'ox ta xmulivaj xchi'uc yu'un mu ja'uc yajnil. ");
INSERT INTO tzotze_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ja' no'ox jech ec li antse, me ta xicta li smalale, me tsmalin yan vinic, ja' no'ox ta xmulivaj xchi'uc noxtoc ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Li jchi'iltaccutique laj yic'beic tal ololetic li Jesuse yu'un ac'o yac' sc'ob ta sjolic. Li yajchanc'optaque la spajesic li boch'otic laj yiq'uic tale. ");
INSERT INTO tzotze_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","C'alal laj yil Jesús ti ta spajesvanic yajchanc'optaque, chopol laj ya'i. Jech laj yalbe: ―Ac'o talicuc ta jtojol li ololetique, mu me xapajesic. Yu'un li boch'otic ja' jechic jech chac c'u cha'al ololetique lec ta xa'yic pasel ta mantal yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Melel li c'usi chacalboxuque, li boch'o mu sco'lajes sbaic jech chac c'u cha'al ololetique, mu xu' ta x'ochic yo' bu ta spas mantal Dios ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","La spet ololetic li Jesuse, laj yac' sc'ob ta sjolic jech laj yich'ic o bendición. ");
INSERT INTO tzotze_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","C'alal loq'uel xa'ox batel li Jesuse, ta anil ital jun jchi'ilcutic ta israelal. La squejan sba ta stojol li Jesuse, jech la sjac'be: ―Lequil jchanubtasvanej, ¿c'usi ta jpas ti xu' chicuxi o sbatel osile? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Itac'ov li Jesuse: ―Mu'yuc ono'ox boch'o lec, ja' no'ox lec stuc li Diose. Jech ¿c'u yu'un chavalbun ti lecune? ");
INSERT INTO tzotze_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xana' ti jech chal li mantaletique: “Mu me xamulivaj, mu me xamilvan, mu me xa'elc'aj, mu me xanopbe smul achi'il, mu me xalo'lavan, ich'o ta muc' atot ame'”, xi ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Itac'ov li vinique: ―Jchanubtasvanej, scotol le'e biq'uitun lic jch'un tal ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Li Jesuse la sq'uel li vinique, lec laj yil. Jech laj yalbe: ―Pero oy to c'usi sc'an avu'un. Batan, bat chono scotol li c'usitic oy avu'une, q'uelanbo me'onetic li stojole. Jech chata ac'ulejal sventa sbatel osil. Ts'acal to xu' chtal achi'inun ta ich' vocol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","C'alal jech laj ya'i li vinique, toj chibajel ic'ot yo'nton. Jech ep ta xat yo'nton batel yu'un toj ep sc'ulejal. ");
INSERT INTO tzotze_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Li Jesuse la sq'uel li cristianoetic tey oy ta jujujot xocone. Jech laj yalbe li yajchanc'optaque: ―Li jc'ulejetique toj vocol ta xac' sbaic ta ventainel yu'un Dios ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Li yajchanc'optaque ch'ayel ic'ot yo'ntonic ta sventa ti jech laj yale. Li Jesuse jech laj yalbe yan velta: ―Jnich'nabtac, li boch'otic batem yo'nton yu'un sc'ulejalique toj vocol ta xac' sbaic ta ventainel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jech chac c'u cha'al mu xjelov jcot camello‑ca' ta chac acuxae, ja' no'ox jech mu xu' ta x'och yo'bu tspas mantal Dios li boch'otic batem yo'nton yu'un sc'ulejalique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","C'alal jech laj ya'yic li yajchanc'optaque, más to toj ch'ayel ic'ot yo'ntonic. Jech laj yalbe sbaic: ―Me mu xcol li boch'o jc'ulejetique, ¿boch'o ono'ox xu' ta xcol cha'e? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Li Jesuse la sq'uelbe sat li yajchanc'optaque, jech laj yalbe noxtoc: ―Li cristianoetique mu xu' yu'un ta scolta sba stuquic. Ja' no'ox xu' chcolic ta sventa li Diose, yu'un ja' scotol xu' yu'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Li Pedroe jech laj yalbe li Jesuse: ―Li vu'uncutique laj xa jcomtsancutic scotol li c'usitic oy to'ox cu'uncutique. Li' xa jchi'inojotcutic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Itac'ov li Jesuse: ―Melel li c'usi chacalboxuque, li boch'otic laj xa scomtsan snaic, me sbanquiltac, me yits'inabtac, me xvixubtac, me yixlaltac, me xi'meltac, me smucubtac, me stot o me sme', me xnich'nabtac, me yalabtac, me yosil, vu'un ta jcoj yu'un jech chpuc batel li jc'ope, ");
INSERT INTO tzotze_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jech ta stabe ep xq'uexol li c'usi ta scomtsane. Me sna, me sbanquiltac, me yits'inabtac, me xvixubtac, me smucubtac, me yixlaltac, me xi'meltac, me sme', me xnich'nab, me yalabtac, me yosil, scotol ta x'ac'bat. Ta xich' contrainel noxtoc. Ts'acal to ta xcuxiic sbatel osil tey ta ach' banamil. ");
INSERT INTO tzotze_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero li boch'otic banquilal ta scuy sbaic li' ta orae ja' its'inal ta xc'otic yu'un la stoy sbaic. Yan li boch'otic its'inal ta x'ilatic li' ta orae ja' banquilal ta xc'otic yu'un biq'uit laj yac' sbaic. Ep li boch'otic its'inal chc'otique; ep noxtoc li boch'otic banquilal chc'otique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","C'alal chanovic batel ta be yu'un chbatic ta Jerusalén xchi'uc yajchanc'optac li Jesuse, ba'yucbe batel li Jesuse. Li yajchanc'optaque ich'ay yo'ntonic ti chjelov batele. Yu'un xco'laj xchi'uc mu sna' yilel me oy c'usi chc'ot ta pasel tey ta Jerusalene. Yan li stuquique oy xi'el cha'yic ti tey xchi'inojic batele. Li Jesuse laj yic' ochel jutuc ta ti' be li lajchabique, laj yalbe c'usi chc'ot yich' pasbel: ");
INSERT INTO tzotze_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Chana'ic ti chijbat ta Jerusalene. Vu'un ti co'ol cristianoutique, tey ta xi'ac'at ta sc'ob banquilal paleetic xchi'uc ta sc'ob li jchanubtasvanejetic ta smantal Dios yalojique. Tey ta xchapanic ti chiyaq'uicun ta milele. Chiyaq'uicun ta sc'ob boch'otic muc ja'uc jchi'iltactic ta israelal. ");
INSERT INTO tzotze_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ja' ta slabanicun, ta xac'bicun nucul, ta stubtabicun jsat. Chismilicun. Chimucat, pero chicha'cuxi ta yoxibal c'ac'al ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Li Jacovo xchi'uc Juane, ja' li xnich'nab Zebedeoe, inoch'ajic tal ta stojol li Jesuse. Jech laj yalbeic: ―Jchanubtasvanej, ta jc'an chavac'buncutic li c'usi ta jc'ancutique ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Itac'ov li Jesuse: ―¿C'usi chac'an ta jpasboxuc? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Itac'ovic: ―C'alal chtal apas mantale, ac'o chotlicuncutic jun ta abats'ic'ob, jun ta ats'et ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Itac'ov li Jesuse: ―Mu xana'ic c'usi chac'anbicun. ¿Me xu' avu'un chavich'ic vocol jech chac c'u cha'al ta xquich'e? ¿Me xu' avu'un cha'ac'atic ta milel jech chac c'u cha'al chi'ac'at ta milele? ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Itac'ovic: ―Xu' cu'uncutic ―xiic. Jech i'albatic yu'un li Jesuse: ―Ta melel ta ono'ox xavich'ic vocol jech chac c'u cha'al chquich'e, ta xavich'ic milel noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ti chac'an chachotiic jun ta jbats'ic'ob, jun ta jts'ete, mu xu' chacalboxuc vu'un. Ja' chal stuc Jtot li boch'otic tey ta xchotiique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Li yan lajunebique chopol laj ya'yic c'usi laj yal li chibique. Jech i'ilinic ta stojol li Jacovo xchi'uc Juane. ");
INSERT INTO tzotze_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Li Jesuse laj yic' xlajchabalic, jech laj yalbe: ―Xana'ic c'u x'elan ta spasic li ajvaliletic yu'un yan lum cristianoetique. Ja' no'ox ta spasic mantal. Jech noxtoc li boch'otic ac'bil yabtelic yu'un ajvalile ja' no'ox ta sujvanic ta abtel. ");
INSERT INTO tzotze_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Pero li vo'oxuque mu me xapasic jech. Li boch'o tsc'an ta xc'ot ta banquilal avu'unique, ti tsc'an ich'bil ta muq'ue, biq'uit ac'o yac' sba ta atojolic, ac'o scoltaoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jech chac c'u cha'al vu'un ti co'ol cristianoutique, mu yu'unuc tal pasvancun ta mantal. Talemun yu'un tal tuncun yu'un scotol cristianoetic. Tal cac' jba ta milel ta acojic yu'un jech xu' chacolic ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jech tey ic'otic ta lum Jericó. Ts'acal to c'alal iloq'uic batel xchi'uc yajchanc'optac li Jesuse, bats'i ep jchi'ilcutic tey nabal ibatic. Tey chotol ta ti'be la staic jun ma'sat, Bartimeo sbi. Ja' xnich'on Timeo. Tey chotol ta sc'an limosna. ");
INSERT INTO tzotze_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","C'alal laj ya'i ti tey xa chjelov li Jesús liquem tal ta Nazarete, lic avanuc: ―Jesús, vo'ot smomnich'onot David ti sc'oplal ono'ox cha'och ta ajvalilal cu'uncutique, la' c'uxubinun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Li yepal jchi'iltac tey xchi'inojic batel Jesuse, laj yutic yu'un ta spajesic: ―Ch'anchan ―xutic. Pero más to tsots i'avan li ma'sate: ―¡Vo'ot smomnich'onot David, c'uxubinun! ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iva'i li Jesuse, laj yalbe cristianoetic ti ac'o staquic tale. Jech la staquic tal, jech laj yalbeic: ―Mu xavat avo'nton. Lican, chayic'ot li Jesuse ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ta ora la sjip comel xaquita li ma'sate, itots ta anil, ital ta stojol li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jech i'albat yu'un li Jesuse: ―¿C'usi chac'an ta jpasbot? ―x'utat. Itac'ov li ma'sate: ―Jchanubtasvanej, avocoluc jambun jsat ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Itac'ov li Jesuse: ―Batan, colemot xa yu'un laj ach'un ti xu' cu'une ―xut. Jech ta ora ijam li sate, la xchi'in batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","C'alal nopol xa'ox x'ech'ic ta Jerusalén xchi'uc yajchanc'optac li Jesuse, tey ic'otic ta tsobtsobnaetic Betfajé xchi'uc ta lum Betánia, tey ta yoc vits Olivatic. Li Jesuse la stac batel chib yajchanc'optac. ");
INSERT INTO tzotze_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jech laj yalbe: ―Batanic ta tsobtsobnaetic le'e. C'alal cha'ochic batele, tey chucbil chataic jcot unin burro, mu'yuc to cajlibinbil. Titunic, iq'uic tal. ");
INSERT INTO tzotze_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Me oy boch'o chasjac'boxuc c'u yu'un chatitunic li burroe, jech xavalbeic: “Yu'un ta xtun yu'un li Cajvaltique. Ta stac sutel tal ta ora”, utic ―x'utatic batel yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jech ibatic. Tey chucbil ta nopol ti'na la staic jcot unin burro. La stitunic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Oy jayibuc cristianoetic tey va'ajtic, jech laj yalic: ―¿C'u stu avu'un chatitunic li burroe? ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Laj yalbeic jech chac c'u cha'al i'albatic batel yu'un Jesuse. Jech i'ac'bat yiq'uic tal. ");
INSERT INTO tzotze_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jech laj yic'beic tal unin burro li Jesuse. Laj yac'beic staspatin slapbolal xaquitaic, jech tey icaji li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ep boch'o la sq'uiic slapbolal xaquitaic ta be. Oy yantic la sc'asic c'obte' xchi'uc yanal, la sq'uiic ta be yu'un chich'ic ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Li boch'otic ba'yucbe italique xchi'uc li boch'otic ta ts'acalpat italique, tsots i'avan scotolic. Jech laj yalic: ―¡Coliyal Dios toj lec li boch'o la stacbutic tale! ");
INSERT INTO tzotze_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ac'o ich'atuc ta muc' li boch'o tal spasutic ta mantal jech chac c'u cha'al la spas mantal li jmoltotic David ta vo'onee! ¡Ac'o ac'batuc ep bendición! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","I'och batel ta Jerusalén li Jesuse. Tey i'och ta yamaq'uil templo. Tey la sq'uel li boch'otic tey oyic ta yamaq'uil temploe. Jech iloc' batel, ibat ta Betánia xchi'uc li lajchab yajchanc'optaque yu'un bat xa'ox c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta yoc'omal iloq'uic tal ta Betánia yan velta li Jesuse yu'un chbatic ta Jerusalén. Li Jesuse ivi'naj. ");
INSERT INTO tzotze_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Laj yil ta nom jtec' igo. Oy yanal. Jech bat sq'uel me oy sat. Pero mu'yuc sat la sta, ja' no'ox yanal. Yu'un ma'uc yorail ta satin. ");
INSERT INTO tzotze_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Li Jesuse jech laj yalbe li te'el igoe: ―Mu'yuc xa chasatin o ―xut. Tey laj ya'yic li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ic'otic ta Jerusalén. Li Jesuse i'och ta yamaq'uil templo. Lic sloq'ues scotol li boch'otic ta xchonolajic xchi'uc boch'otic ta xmanulajic tey ta yamaq'uil temploe. La sbutq'uinbe smesaic li jeltaq'uinetique. La sbutq'uinbe sillaic li jchonpalomaetique. ");
INSERT INTO tzotze_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Xchi'uc muc xac' boch'o chjelov xchi'uc yicats tey ta yamaq'uil templo. ");
INSERT INTO tzotze_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tey lic chanubtasvanuc li Jesuse, jech laj yal: ―Avilojic ti jech ts'ibabil comel ta sc'op Diose: “Li jnae ja' snail bu chisc'opanicun cristianoetic ta sbejel banamil”, xi yaloj li Diose. Pero li vo'oxuque apasojic xa ta snailch'en j'eleq'uetic ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tey laj ya'yic li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li banquilal paleetique. Chopol laj ya'yic. Jech lic snopic c'u x'elan xu' ta smilic li Jesuse yu'un ixi'ic me tey chbat scotol li jchi'iltaccutique. Yu'un scotol jchi'iltaccutic labal laj ya'yic c'u x'elan ichanubtasvan li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","C'alal ch'ayem xa'ox c'ac'ale, iloc' batel ta Jerusalén li Jesuse, isut batel ta Betánia xchi'uc li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta sob yoc'omal c'alal italic yan veltae, laj yilic ti taquijem xa'ox c'alal ta yibel li te'el igoe. ");
INSERT INTO tzotze_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ivul ta sjol Pedro c'usi laj yalbe te'el igo li Jesuse. Jech laj yalbe li Jesuse: ―Jchanubtasvanej, q'uelavil li te'el igo ti mu'yuc stu laj avile, itaquij o ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Itac'ov li Jesuse: ―Ch'unic ti scotol xu' yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Melel li c'usi chacalboxuque, me chach'unic ti vu'un ta jcoltaoxuque, me mu xanop ta avo'ntonic ti mu xu'e, me ach'unojic ti ta ono'ox xapasbatic li c'usi chavalique, jech ta ono'ox xc'ot ta pasel li c'usi chavalique. Jech chac c'u cha'al me chavalbeic li vits li'i ti ac'o loc'uque, ti ac'o sjip sba ochel ta nabe, ta ono'ox xaspasboxuc li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jech ta xcalboxuc, scotol c'usi chac'anic c'alal chac'opanic Diose, ch'unic ti cha'ac'batique jech ta ono'ox xavich'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","C'alal chac'opanic Diose, me cht'ab ta avo'ntonic ti oy boch'o oy smul avu'unique, pasbeic perdón. Jech chaspasboxuc perdón yu'un amulic ec li Jtotic tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yan me mu xapasbeic perdón achi'ilique, jech mu'yuc ono'ox chaspasboxuc perdón yu'un amulic ec li Jtotic tey oy ta vinajele ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ic'otic yan velta ta Jerusalén xchi'uc yajchanc'optac li Jesuse. C'alal tey chanov Jesús ta yamaq'uil temploe. tey ital c'opanatuc yu'un banquilal paleetic xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc jayibuc jchapanvanejetic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jech la sjac'beic li Jesuse: ―¿Boch'o laj yac'bot avu'el chapas li c'usitic chapase? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Itac'ov li Jesuse: ―Oy c'usi chajac'boxuc jbeluc ec. Me chavalbicun li c'usi ta jac'boxuque, ja' o ta xcalboxuc ec li boch'o laj yac'bun jvu'el ti jech ta jpase. ");
INSERT INTO tzotze_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Li ich'vo' laj yac' Juane, ¿boch'o i'ac'bat yabtel ti jech la spase? ¿Me ac'bil yu'un Dios o me ac'bil yu'un cristiano? Albicun ca'i ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jech tey lic yalilanbe sbaic: ―Me ta xcaltic ti ja' i'ac'bat yabtel yu'un Diose, jech ta xalbutic: “¿C'u yu'un muc xach'unic cha'e?” xijyututic. ");
INSERT INTO tzotze_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Me xu' van ta xcaltic ti ja' i'ac'bat yu'un cristianoe? ―xut sbaic. Mu sc'an xalic jech, yu'un chi'ic yu'un li cristianoetique. Yu'un scotolic xch'unojic ti ta melel ja' yaj'alc'op Dios li Juane. ");
INSERT INTO tzotze_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja' yu'un jech itac'ovic: ―Mu jna'cutic ―xutic. Jech i'albatic yu'un li Jesuse: ―Jech mu'yuc ta xcalboxuc ec li boch'o laj yac'bun jvu'el ta jpas o li c'usitic ta jpase ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Li Jesuse oy c'usi la sloc'tabe ta lo'il li jchi'iltaccutic ta israelale. Jech laj yalbe: ―Oy jun vinic la sts'un ep ts'usub ta yosil. La set ta corral li sts'usube. La svom ton ja' yav sventa spits'ubil ya'lel li sts'usube. La spas jun toyol sq'uelubil osil. La sa'be yajval boch'otic ta xchabiic li ts'usubtic yu'une. Jech ibat ta nom li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’C'alal ista yorail i'ic'ub li sat sts'usube, la stac tal jun smozo yu'un ta xich'be batel li sat ts'usube. Ja' c'ot sc'anbe li boch'otic ta xchabiique. ");
INSERT INTO tzotze_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero li jchabiejts'usubtique la stsaquic li mozoe, la smajic, la staquic sutel. Mu'yuc c'usi laj yac'beic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Li yajval osile la stac tal yan smozo noxtoc. Pero laj yac'beic ton, ituch' sjol yu'unic. Solel ep laj yuts'intaic batel. ");
INSERT INTO tzotze_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","La stac tal yan smozo noxtoc li yajval osile pero la smilic. Oy to ep yan la stac tal pero ja' no'ox jech la spasbeic. Oy j'o'lol la smajic, j'o'lol la smilic o. ");
INSERT INTO tzotze_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Oy jun xnich'on li yajval osile, lec c'ux ta yo'nton. Ja' slajeb xa la stac tal. Jech la snop: “Ja' ta xich'ic ta muc' li jnich'one”, xi. ");
INSERT INTO tzotze_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero c'alal laj yilic li jchabiejts'usubtic ti ja' xnich'on li yajval osile, jech laj yalbe sbaic: “Le'e ja' xa ta xich'be comel yosil li stote. Ja' lec jmiltic jech vu'utic ta xquich'betic o comel li yosile”, xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jech la stsaquic, la smilic, la sloq'uesic batel ta ts'usubtic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’C'alal ta sut tal li yajval osile, ¿c'usi ta xc'ot spasbe xana'ic li jchabiejts'usubtique? Ta smilan. Yan xa boch'o ta xac'be xchabi li ts'usubtic yu'une. ");
INSERT INTO tzotze_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Aq'uelojic c'usi chal ta sc'op Dios: Jech chac c'u cha'al yajval na la st'uj jbej ton sventa chac' ta chiquin na, pero li svinictac ta pasnae muc sc'anic. Li ton ti muc sc'anique ja' ono'ox i'och ta chiquin na. Ja' no'ox jech ec, ac'o me mu xc'anat li boch'o t'ujbil yu'un Diose, pero ta ono'ox xac'be tsots yabtel. ");
INSERT INTO tzotze_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Toj lec ti jech ta to spas li Diose, xi ts'ibabil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li jchapanvanejetique, tsc'an ta stsaquic ox li Jesuse yu'un la sna'ic ti ja' sc'oplal stuquic la sloc'ta ta lo'ile. Pero ixi'ic yu'un li cristianoetique jech muc stsaquic. Tey la scomtsanic, ibatic o. ");
INSERT INTO tzotze_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ts'acal la staquic tal ta stojol Jesús jayibuc fariseoetic xchi'uc svinictac Erodes yu'un oy c'usi ta sjac'beic, yu'un jech xu' ta stabeic o smul yalojic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'alal ivulic ta stojol li Jesuse, jech vul yalbeic: ―Jchanubtasvanej, ta jna'cutic ti melel scotol c'usi chavale, ti co'ol jamal chavalbe ya'yic c'usi tsc'an Diose. Muc ta sbauc no'ox chaq'uel c'u x'elan li cristianoetique. Alo ca'icutic c'usi chanop. ¿Me lec chil Dios ti ta xcac'be jpatantic li Césare, o me mu lecuc chil? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Li Jesuse la sna' ti ja' no'ox ta xlo'lavanique, jech laj yalbe: ―¿C'u yu'un tal aq'uelic c'u x'elan co'nton? Tsaquic tal junuc li taq'uin sventa ta jtoj o jpatantique, ta jq'uel ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Laj yich'beic tal. Jech ijac'batic yu'un li Jesuse: ―¿Boch'o sloc'obbal li'i? ¿Boch'o sbi li'i? ―xut. Itac'ovic: ―Ja' César ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jech i'albatic yu'un li Jesuse: ―Tsc'an ta jch'unbetic c'usi ja' yabtel ta xal li Césare yu'un ja' muc'ta ajvalil. Jech noxtoc tsc'an ta jch'unbetic c'usi ta xal li Diose ―x'utatic. C'alal laj ya'yic c'u x'elan itac'ov li Jesuse, toj ch'ayel ic'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Italic ta stojol Jesús jayibuc boch'otic xch'unoj saduceo, ja' ti chalic mu'yuc cha'cuxesele. Jech vul sjac'beic li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Jchanubtasvanej, jech la sts'iba comel li Moisés ta vo'onee: “Me oy ta xcham jun vinic, me mu'yuc xnich'on chcome, li its'inal ti mu'yuc to yajnile, ac'o yic'be yajnil li ánima sbanquile. C'alal ta xvoc' xnich'one, ja' chac'be sbiinbe sbi li sbanquile, jech tey oy o sbi li sbanquile”, xi li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oy vucub jchi'iltic xchi'il no'ox sbaic ta voq'uel. Li banquilale la sa' yajnil. Pero icham li banquilale, mu'yuc xnich'on icom. ");
INSERT INTO tzotze_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Li its'inale laj yic'be yajnil li ánima sbanquile. Ts'acal to icham ec. Mu'yuc xnich'on icom noxtoc. Ja' jech la spasic o svucubalic. Xquechet laj yic'be yajnil li sba sbanquilique. ");
INSERT INTO tzotze_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mu'yuc icom xnich'on svucubalic c'alal ichamic. Ts'acal to icham ec li antse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","C'alal ta xcha'cuxiique, ¿boch'o junucal yajnil chc'ot li antse? Yu'un scotol laj yic' yajnilinic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Itac'ov li Jesuse: ―Mu to xana'ic c'usi chal li sc'op Diose. Mu xana'ic c'u x'elan stsatsal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","C'alal ta xcha'cuxiique, mu'yuc xa yajnil viniquetic, mu'yuc xa smalal antsetic. Ja' xa jechic jech chac c'u cha'al yaj'almantaltac Dios ta vinajel. ");
INSERT INTO tzotze_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ti jech mu'yuc ach'unojic ti ta xcha'cuxiic ánimaetique, ¿me yu'un mu'yuc aq'uelojic ta svun Moisés yo' bu chal ti c'alal ic'opanat yu'un Dios tey ta jtec' biq'uit ch'ixe? Jech i'albat yu'un li Diose: “Vu'un Diosun yu'un Abraám, xchi'uc Isaac, xchi'uc Jacov”, x'utat. Ac'o me ep xa jabil chamenic, pero jech to i'albat sc'oplalic yu'un li Diose yu'un cuxulic. Ti chamenicuc o c'alal ta xch'ulelic jech chac c'u cha'al chavalique, mu'yuc xa Dios yu'unic ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yu'un li Diose mu ja'uc Dios yu'un li boch'otic chamenic oe; ja' Dios yu'un li boch'otic cuxajtique. Ep to mu xana'ic ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tey inoch'aj tal jun jchi'ilcutic ta israelal, ja' jchanubtasvanej ta smantal Dios yaloj. Laj ya'i ti tey ta xlo'ilajic xchi'uc Jesús li saduceoetique. C'alal laj ya'i ti lec itac'batic yu'un li Jesuse, jech la sjac'be ec li Jesuse: ―Scotol smantal Dios ti laj yal comel Moisés ta vo'onee, ¿c'usi mantalil ti más tsots sc'oplale? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Itac'ov li Jesuse: ―Li smantal Dios ti más tsots sc'oplal ta scotole jech chal: “A'yo me ava'yic, jchi'iltac, vu'utic ti israelutique. Jun no'ox li Cajvaltic jcotoltique, ja' li Dios cu'untique. ");
INSERT INTO tzotze_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","C'anic me ta scotol avo'ntonic li Dios cu'untique. Ac'bo sventain avo'ntonic, xchi'uc abijilic, xchi'uc atsatsalic, ac'o tunuc yu'un”, xi li mantale. Le'e ja' más tsots sc'oplal. ");
INSERT INTO tzotze_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ali xchibale co'ol tsots sc'oplal. “C'anic me achi'ilic jech chac c'u cha'al c'ux ta avo'nton abec'tal atuquic”, xi. Le'e ja' más tsots sc'oplal xchibal. Mu'yuc xa yan mantal ti más tsots sc'oplale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Itac'ov li jchanubtasvaneje: ―Jchanubtasvanej, melel li c'usi laj avale. Ta melel jun no'ox Dios oy, mu'yuc yan. ");
INSERT INTO tzotze_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ta melel ja' tsc'an ti ac'o jc'an ta scotol co'ntontic li Dios cu'untique, ti ac'o cac'be sventain co'ntontic, xchi'uc jbijiltic, xchi'uc jtsatsaltique, ti ac'o tunuc yu'une. Xchi'uc tsc'an noxtoc ti ac'o jc'an jchi'iltic jech chac c'u cha'al c'ux ta co'nton jbec'tal jtuctique. Ja' más tsots sc'oplal. Ja' mu tsotsuc sc'oplal li smoton Dios ta jchic'tique xchi'uc li smoton Dios ta jmiltique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","C'alal laj ya'i Jesús ti lec itac'ov li jchanubtasvaneje, jech laj yalbe: ―Jutuc xa sc'an xavac' aba ta ventainel yu'un Dios ―xut. Me junuc mu'yuc xa c'usi yan la sjaq'uic o. ");
INSERT INTO tzotze_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","C'alal ichanubtasvan Jesús ta yamaq'uil temploe, jech laj yalbe li jchi'iltaccutic ta israelale: ―¿C'u yu'un ta xalic jchanubtasvanejetic ta smantal Dios ti ja' no'ox smomnich'on David li boch'o t'ujbil yu'un Dios chventainvane? ");
INSERT INTO tzotze_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yu'un li Davide ta sventa Ch'ul Espíritu jech laj yal: Li Cajvale jech i'albat yu'un li Diose: “Ta to xlic chotlan ta jbats'ic'ob. Vo'ot chapas mantal c'alal to ta jtsalbot scotol li avajcontrae”, x'utat, xi li Davide. ");
INSERT INTO tzotze_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Li Davide “Cajval”, xut li boch'o t'ujbil yu'un Dios chventainvane. ¿C'u yu'un “Cajval”, xut me ja' smomnich'one? ―xi li Jesuse. Li epal cristianoetic tey tsobolique scotol yo'nton laj ya'ibeic sc'op li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jech laj yal c'alal ichanubtasvan li Jesuse: ―Q'uelo me abaic, mu me xaslo'laoxuc li jchanubtasvanejetic ta smantal Dios yalojique. Yu'un lec cha'yic nat sc'u' tslapic c'alal chanovic, xchi'uc lec cha'yic me ta xich'ic c'opanel yu'un jchi'iltactic tey ta ch'ivit. ");
INSERT INTO tzotze_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lec ta xa'yic noxtoc ta xchotiic ta sliqueb chotlebal ta nail tsobobbailetic. Jech tspasic noxtoc ta jujun q'uin. ");
INSERT INTO tzotze_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xchi'uc ta slo'labeic c'usitic oy yu'un me'on antsetic. Jech altic ti jal ta sc'opanic Diose. Le'e ja' tsots ta x'ac'batic castigo ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Li Jesuse tey ichoti ta yamaq'uil templo ta stuq'uil yavil taq'uin yo' bu ta xaq'uic smoton Dios li jchi'iltaccutic ta israelale. Laj yil tey ta xaq'uic smoton Dios li jchi'iltaque. Ep jc'ulejetic laj yaq'uic ep taq'uin. ");
INSERT INTO tzotze_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tey ital jun me'on ants solel mu'yuc c'usi oy yu'un. Ja' no'ox chib cinco laj yac'. ");
INSERT INTO tzotze_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Li Jesuse laj yic' li yajchanc'optaque, jech laj yalbe: ―Melel chacalboxuc, ta stojol Diose ja' más ep laj yac' li me'on ants le'e. Ti c'u yepal laj yac' ta scotolic li yantique ja' mu'yuc ep ic'ot. ");
INSERT INTO tzotze_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yu'un puro scomelal xa staq'uin laj yaq'uic. Yan li me'on antse laj yac' scotol ti c'u yepal oy yu'un sventa ta sman o c'usitic ta xtun yu'une ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","C'alal chloq'uic xa ta yamaq'uil templo xchi'uc yajchanc'optac li Jesuse, jech i'albat yu'un jun yajchanc'op: ―Jchanubtasvanej, q'uelavil, toj c'upilic sba li tonetic yu'un temploe xchi'uc li naetic li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Itac'ov li Jesuse: ―Toj c'upilic to sba chavilic li' ta orae. Pero me jbejuc ton mu'yuc bu cajal ta xcom ta sba yac'ol yan ton, yu'un ta to sta yorail chtal vuq'uesatuc yu'un yan cristianoetic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Li Jesuse tey bat chotluc ta vits Olivatic xchi'uc yajchanc'optac ta stuq'uil templo. Li Pedro, xchi'uc Jacovo, xchi'uc Juan, xchi'uc Andrese, stuquic jech la sjac'beic li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Alo ca'icutic c'usi ora ta xc'ot ta pasel ta svuq'uesat li templo laj avale. ¿C'usi sq'uelubil ta jq'uelcutic ti c'alal po'ot xa chc'ot ta pasele? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jech lic yal li Jesuse: ―Q'uelo me abaic, mu me boch'o xaslo'laoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yu'un oy ep boch'o ta xalic sbiic jech chac c'u cha'al jbi vu'un. Jech ta xalic: “Vu'un Cristoun ti t'ujbilun yu'un Dios chajventainoxuque”, xiic. Jech ep boch'otic ta xlajic ta lo'lael. ");
INSERT INTO tzotze_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’C'alal chava'yic oy pleito li'i xchi'uc c'alal chava'yic oy pleito ta nome, mu me xaxi'ic. Ta persa jech ta xc'ot ta pasel pero muc to ja'uc slajebal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta to xlic scontrain sbaic cristianoetic ta yantic banamil. Ta to xlic scontrain sbaic ajvaliletic noxtoc. Ta x'ech' niqueletic ta buticuc no'ox banamil. Ta to xtal tsots vi'nal. Pero le'e ja' sliquebal to vocol. ");
INSERT INTO tzotze_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pero li vo'oxuque q'uelo me abaic. Yu'un li jchi'iltactic ta israelale oy chlic yac'oxuc ta c'abal ta stojol jchapanvanejetic tey ta templo. Oy chayac'boxuc nucul tey ta nail tsobobbailetic. Oy chayic'oxuc batel ta stojol gobernadoretic, xchi'uc ta stojol muc'tic ajvaliletic, pero vu'un ta jcoj, jech tey chacholbeic o jc'op. ");
INSERT INTO tzotze_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yu'un persa ba'yuc ta xcholbatic scotol cristianoetic ta sbejel banamil ti ja' no'ox chcolic ta jventae. ");
INSERT INTO tzotze_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","C'alal chayic'oxuc batel yu'un chayac'oxuc ta c'abale, mu me xlo'ilaj avo'ntonic ta sventa li c'usi chc'ot avalique xchi'uc ti c'uxi chatac'ovique. Yu'un mu vo'ocoxuc xa chac'opojic. Ja' Ch'ul Espíritu chac' ana'ic li c'usi chavalique. ");
INSERT INTO tzotze_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oy boch'o chac' ta milel yits'in o me sbanquil. Oy xnich'onic no'ox chaq'uic ta milel. Oy boch'o chlic scontrain stot sme' chac' ta milel noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ep boch'otic chopol chayiloxuc ta sventa ti ach'unojbicun jc'ope. Li boch'o ta xcuch yu'un c'alal to ta slajebe ja' ta xcol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Li c'usi ta jts'ibaboxuc tal li'i a'ibeic me lec smelol yu'un jech ono'ox laj yalbe yajchanc'optac li Jesuse: ―C'alal chavilic tey xa va'anbil ta yut templo c'usi chopol chil Dios jech chac c'u cha'al laj yal li j'alc'op Daniel ta vo'onee, jatovanic batel ta anil ta vitsetic, vo'oxuc ti li' nacaloxuc ta Judeae. ");
INSERT INTO tzotze_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Li boch'otic tey oy ta sjol snaique, c'alal ta xyalic tale, mu xa me x'och yich' c'usitic oy yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Li boch'otic tey oyic ta yabtelique, mu xa me sutic tal yu'un chtal yich' xaquitaic. ");
INSERT INTO tzotze_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Toj abul sbaic li boch'otic ja' to xchi'inoj yolique xchi'uc li boch'otic ta to xchu'un yolique. ");
INSERT INTO tzotze_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","C'opanic Dios ti mu me ja'uc ta yorail sictic ti c'alal chajatovique. ");
INSERT INTO tzotze_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yu'un toj tsots li vocol ta xtale. Mu'yuc ono'ox jech c'alal ilic li banamile xchi'uc c'alal to tana. Mu'yuc xa yan jech vocol ta xtal c'alal me la sta sc'ac'alil le'e. ");
INSERT INTO tzotze_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti manchuc ta spajes vocol li Diose, mu'yuc boch'o ta xcol ti jechuque. Pero ta sventa li boch'o t'ujbilique jech ta spajes li vocole. ");
INSERT INTO tzotze_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Me oy boch'o jech ta xalboxuque: “Q'uelavilic, li' xa oy li Cristoe”, me xayutoxuque, o me oy boch'o yan jech chayalboxuc: “Q'uelavilic, le' xa oy li Cristoe”, me xayutoxuque, mu me xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yu'un ta to xtal li boch'otic ta xalic ti ja' t'ujbilic yu'un Dios chasventainoxuc yalojique, xchi'uc ta xalic ti ja' yaj'alc'optac Diose pero altic chalic. Ta spasic sq'uelubiltac ti xu' yu'unique yu'un jech ta slo'laic o li cristianoetique. Tsc'an ta slo'laic ec li boch'o t'ujbilic yu'un Diose pero mu xu' yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Q'uelo me abaic li vo'oxuque yu'un ba'yuc xa laj calboxuc scotol. ");
INSERT INTO tzotze_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’C'alal me i'ech' scotol li vocol laj calboxuque, ja' o ta x'ic'ub li c'ac'ale. Mu'yuc chac' xojobal li ue. ");
INSERT INTO tzotze_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Li c'analetique ta xbaj yalel tal. Ta xnic scotol li c'usitic oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja' o ta xilic scotol cristianoetic ta xiyal tal ta toc, vu'un ti co'ol cristianoutique. Ep jtsatsal xchi'uc tsots jxojobal. ");
INSERT INTO tzotze_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta jtac yalel tal caj'almantaltac yu'un ac'o stsobic scotol li boch'otic t'ujbilic cu'un ti buyuc no'ox oyic ta sbejel banamile. ");
INSERT INTO tzotze_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Chanbeic o smelol ta sventa c'u x'elan li igo te'e. C'alal ta x'uninaj sc'obe, ta xloc' yan yanal, jech chana'ic o ti po'ot xa yorail vo'olaltique. ");
INSERT INTO tzotze_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ja' no'ox jech ec li vo'oxuque, c'alal chavilic ta x'ech' scotol c'usi calojboxuque, jech chana'ic o ti po'ot xa yorail chicha'sut tal, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Melel chacalboxuc, oy mu'yuc to chachamic ja' to me i'ech' scotol li c'usitic laj calboxuque. ");
INSERT INTO tzotze_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ta to xlaj li vinajel banamile. Pero li c'usitic caloje mu'yuc ono'ox ta xlaj sc'oplal, ta xc'ot ta pasel scotol. ");
INSERT INTO tzotze_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Li c'usi ora chitale mu'yuc ono'ox boch'o ta sna'. Me ja'uc li j'almantaletic ta vinajele, me ja'uc vu'un li Nich'onilune. Ja' no'ox sna' stuc li Jtotique. ");
INSERT INTO tzotze_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Q'uelo me abaic, viq'uiluc me asatic, c'opanic Dios yu'un mu xana'ic bu ora ta xc'ot sc'ac'alil. ");
INSERT INTO tzotze_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ja' jech chac c'u cha'al jun vinic c'alal ta xbat ta nome. Ta xac'be comel ta sc'ob smozotac li snae. Ta xac'be comel yabtel jujun. Li boch'o ja' yabtel ta xchabi ti'nae, ta xalbe comel ti viq'uiluc me sate. ");
INSERT INTO tzotze_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jech li vo'oxuque viq'uiluc me asatic yu'un mu xana'ic c'usi ora chital, vu'un li Avajvalicune. Me ta xch'ay c'ac'al chital, me ta o'lol ac'ubal, me ja' o ta x'oc' cots, me ta sob. ");
INSERT INTO tzotze_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mu me vayemucoxuc chvul jtaoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Vo'oxuque laj xa calboxuc ti tsc'an viq'uiluc asatique. Tsc'an ac'o jechuc scotol cristianoetic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sc'an to'ox chib c'ac'al q'uin coltael cu'uncutic, vu'uncutic li israeluncutique. Xchi'uc ja' sq'uinal ta jve'cutic pan ti mu'yuc yich'oj svolesubil xch'ute. Li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique la snopilanic c'u x'elan xu' ta stsaquic ta mucul li Jesuse yu'un ta smilic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jech laj yalic: ―Ja' lec mu jtsactic ta yorail q'uin yu'un naca me sliquesic pleito cristianoetic ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","C'alal tey oy ta Betánia li Jesuse, tey oy ta sna li Simón ti tsacbil to'ox ta c'a'el chamele. C'alal tey chve' ta mesa li Jesuse, tey ital jun ants yich'oj tal slimita pasbil ta alabastro ton. Nojem ta muil poxil, nardo sbi. Bats'i toyol stojol. La svoc' li yavile, la smalbe ta sjol Jesús li sbele. ");
INSERT INTO tzotze_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oy jayibuc i'ilinic, jech laj yalbe sbaic: ―¿C'u yu'un jeche' no'ox ta xlaj li muil poxile? ");
INSERT INTO tzotze_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ja' lec ti lajuc xchone. Más ta oxib ciento denario taq'uin iloc' stojol ti jechuque. Li stojole xu' ta x'ac'bat me'onetic ―xiic. Jech laj yutic li antse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Li Jesuse jech laj yalbe: ―Mu xavutic li antse. ¿C'u yu'un chavaq'uic lo'ilajuc yo'nton? Lec li c'usi la spasbune. ");
INSERT INTO tzotze_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Li me'onetique scotol c'ac'al li' achi'uquic jech c'usiuc no'ox ora xu' chac'uxubinic. Yan li vu'une mu scotoluc c'ac'al li' jchi'inojoxuc. ");
INSERT INTO tzotze_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Li antse laj xa spas li c'usi xu' yu'une. Ti jech la smalbun muil poxile, ja' senyail ti ta xquich' muquele. ");
INSERT INTO tzotze_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Melel li c'usi chacalboxuque, buyuc no'ox ta xich' cholel ta sbejel banamil ti ja' no'ox chcolic ta jventae, tey ta xalic noxtoc c'usi la spasbun li antse. Jech ta sna'ic o scotol cristianoetic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Li Judas Iscariotee, ja' jun li lajchab yajchanc'op Jesuse, bat sc'opan li banquilal paleetique yu'un ta spas trato ti ta xac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","C'alal laj ya'yic li banquilal paleetique, toj lec laj ya'yic. Laj yalbeic Judas ti ta xac'beic taq'uine. Li Judase ja' xa no'ox la smala c'usi ora xu' chac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ta sliquebal q'uin c'alal ta jve'cutic pan ti mu'yuc yich'oj svolesubil xch'ute, xchi'uc c'alal ta jmilcutic li ch'ium chij ta sventa q'uin coltaele, jech ijac'bat yu'un yajchanc'optac li Jesuse: ―¿Bu chac'an ta xbat jmeltsancutic li ch'ium chij chati' ta sventa q'uin coltaele? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Li Jesuse la stac batel chib yajchanc'op. Jech laj yalbe batel: ―Batanic ta Jerusalén. Tey chataic ta be jun vinic xcuchoj jbej q'uib ya'al. Ja' tey xanaban abaic batel ta spat. ");
INSERT INTO tzotze_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Xc'ot ac'opanic li yajval na bu ta x'oche. Jech xavalbeic: “Jech laj yal tal li jchanubtasvaneje: ¿Bu jc'olucal scuartoal ana yo' bu ta jti'cutic chij jchi'uc li cajchanc'optaque? xi laj yal tal”, utic c'otel. ");
INSERT INTO tzotze_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tey ta xac'boxuc avilic jun muc'ta cuarto ta xcha'cojal jolna. Chapanbil xa lec. Ja' tey xameltsanic li chij ta jti'tique ―xut batel li chib yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jech ibatic li chibique, i'ochic ta yut lum. Ti c'u x'elan i'albatic batel yu'un Jesuse ja' jech la staic scotol. Jech tey la smeltsanic li ve'lil sventa q'uin coltaele. ");
INSERT INTO tzotze_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","C'alal ta xa x'ic'ub osile, ibat xchi'uc xlajchabal yajchanc'optac li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","C'alal tey xa ta xve'ic ta mesae, li Jesuse jech laj yalbe li yajchanc'optaque: ―Melel chacalboxuc, oy jun li' jchi'uctic ta ve'el ti ja' chiyac'un ta c'abale ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","C'alal laj ya'yique, laj yat yo'nton scotolic. Ta jujuntal lic sjac'beic li Jesuse: ―¿Me vu'un van? ―xiic liquel jujunic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Itac'ov li Jesuse: ―Ja' jun li lajchaboxuc li'i. Ja' li boch'o jun jsets' chive' jchi'uque ja' chiyac'un ta c'abal. ");
INSERT INTO tzotze_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Vu'un ti co'ol cristianoutique, ta xipasbat jech chac c'u cha'al ts'ibabil ono'ox ta sc'op Diose. Toj abul sba li boch'o chiyac'un ta c'abale. Ja' lec ti manchuc voc'uque ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","C'alal ta xve'ique, la stam pan li Jesuse, la stojbe ta vocol Dios, la svoc' li pane, laj yac'be li yajchanc'optaque. Jech laj yalbe: ―Ilo, ve'anic. Li'i ja' jbec'tal ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","La stam noxtoc jun vaso ya'lel ts'usub, la stojbe ta vocol Dios, laj yac'be noxtoc li yajchanc'optaque. Laj yuch'ic scotolic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jech laj yal li Jesuse: ―Li'i ja' jch'ich'al, ja' senyail ti mu xlaj sc'oplal li c'usi ach' la xchapan Jtot sventa chacolic oe. Yu'un jtuc chcac' jba ta milel, ta xloc' jch'ich'al, jech ta xtoj o smulic scotol cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Melel chacalboxuc ti mu'yuc xa ta xcuch' yan velta li ya'lel ts'usube. Ja' to ta xcuch' yan velta ti c'alal tey xa jtsoboj jba jcotoltic yo'bu chiyac'bun jpas mantal li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","C'alal la sq'uejintaic jun sq'ueoj Diose, iloc' batel xchi'uc yajchanc'optac li Jesuse, ibatic ta vits Olivatic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Tanae acotolic chacomtsanicun. Yu'un jech ono'ox ts'ibabil ta sc'op Dios: “Ta xcac' ta milel li boch'o cac'ojbe yabtel chasventainoxuque. C'alal me imilate, tspuc sbaic batel li xchi'iltaque jech chac c'u cha'al tspuc sbaic batel chij me imilat li yajvalique”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","C'alal cha'cuxemun xa'oxe, vu'un ba'yuc chic'ot avu'unic ta Galilea banamil ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Itac'ov li Pedroe: ―Ac'o me ta scomtsanot scotolic, li vu'une mu'yuc chajcomtsanot ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Li Jesuse jech laj yalbe: ―Melel li c'usi chacalbote, tana c'alal mu'yuc to'ox oq'uem chib velta cotse, oxib xa'ox velta avaloj ti mu xavotquinune ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Itac'ov li Pedroe: ―Ac'o me co'ol chijcham, mu'yuc ta xcal ti mu xacotquinote ―xi ta jmec. Ja' no'ox jech laj yalic ec li yantique. ");
INSERT INTO tzotze_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tey ic'otic Jesús xchi'uc yajchanc'optac yo' bu Getsemaní sbie. Jech laj yalbe li yajchanc'optaque: ―Chotlanic li'i yu'un ta xbat jc'opan Dios le'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Laj yic' ech'el Pedro, xchi'uc Jacovo, xchi'uc Juan. Lic yat yo'nton li Jesuse. Toj yan sba yo'nton laj ya'i. ");
INSERT INTO tzotze_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jech laj yalbe li oxibique: ―Toj loq'uel ta xcat co'nton ta xca'i, ta xicham o ya'yeluc. Comanic li'i, mu me x'och avayelic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ijelov batel jutuc li Jesuse. La spatan sba ta lumtic. La sc'opan Dios, la sc'anbe ti xu'uc mu xchame. ");
INSERT INTO tzotze_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jech laj yal: ―Tati, scotol xu' avu'un. Xu' chaloq'uesbun li jvocol li'i. Pero mu me xc'ot ta pasel li c'usi ta sc'an co'nton jtuque. Ja' ac'o jpas li c'usi tsc'an avo'ntone ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ital li Jesuse. Vayemic vul sta li oxibique. Jech laj yalbe li Pedroe: ―Simón, ¿me vayemot? ¿Me mu xu' avu'un julovenot junuc ora? ");
INSERT INTO tzotze_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu me xavayic, c'opanic Dios jech mu xach'unic sujel ta mulil. Ta melel chac'an chac'opanic Dios pero chastsaloxuc li abec'talique ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bat sc'opan Dios yan velta li Jesuse. Ja' no'ox jech laj yal jech chac c'u cha'al laj yal ta ba'yuque. ");
INSERT INTO tzotze_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","C'alal isut tal yan veltae, vayemic vul sta noxtoc li oxibique yu'un solel chtal svayelic. Jech mu sna'ic c'uxi ta stac'beic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ibat sc'opan Dios yoxibal velta noxtoc. C'alal isut tale, vayemic vul sta noxtoc. Jech laj yalbe: ―¿Me yoquel to chavayic? ¿Me yoq'uel to chacux avo'ntonic? Ta'lo li vayele, ista xa yorail chi'ac'at ta c'abal ta sc'ob jpasmuliletic, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Licanic, batic. Q'uelavilic, le' xa xtal li boch'o chiyac'un ta c'abale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","C'alal ja' o ta xlo'ilaj li Jesuse, ital li Judase, ja' jun li lajchab yajchanc'optaque. Xchi'inoj tal ep cristianoetic, yich'anoj tal xmachitaic xchi'uc ste'ic. Ja' tacbilic tal yu'un li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Li Judase, ja' li j'ac'vanej ta c'abale, yaloj xa'ox c'u x'elan ta xac' ta ilel li Jesuse. ―Boch'o ta jts'uts'e ja' svinajeb ti ja' xae. Tsaquic ta ora, lec xachabiic batel ―xut ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","C'alal ic'otique, ta ora inoch'aj batel ta stojol Jesús li Judase. Jech laj yalbe: ―Jchanubtasvanej ―xut. La sts'uts'. ");
INSERT INTO tzotze_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jech la stsaquic ta ora li Jesuse, la xchuquic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Oy jun yajchanc'op la sloq'ues xmachita, la sbojbe loq'uel jun xchiquin smozo li más banquilal palee. ");
INSERT INTO tzotze_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Li Jesuse jech laj yalbe li cristianoetic tey oyique: ―¿C'u yu'un tal atsaquicun ta machita, ta te', jech chac c'u cha'al j'elec'? ");
INSERT INTO tzotze_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Scotol c'ac'al tey lichanubtasvan ta atojolic ta yamaq'uil templo. ¿C'u yu'un muc teyuc xatsaquicun? Ti jech laj atsaquicune, yu'un ja' ic'ot o ti jech ono'ox ts'ibabil comel ta sc'op Diose ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Li yajchanc'optaque ijatovic batel scotolic, stuc xa tey la scomtsanic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oy jun sva'lej querem tey nabal ibat ta spat li Jesuse. Mu'yuc sc'u' li quereme. Ja' no'ox smacoj sba o ta jlic sábana manta. Pero itsacbat yu'un li jtsacvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Li quereme la scomtsan li sábana mantae, t'anal ijatov batel. ");
INSERT INTO tzotze_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Laj yiq'uic batel Jesús ta stojol li más banquilal palee. Tey la stsob sbaic li banquilal paleetique, xchi'uc li jchapanvanejetique, xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. ");
INSERT INTO tzotze_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Li Pedroe ta nomnomtic ibat ta spat Jesús c'alal to ic'ot ta yamac' li más banquilal palee. Tey la xchi'in ta chotlej yajmayoltac li más banquilal palee, tey ic'atinic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Li banquilal paleetique xchi'uc li jchapanvanejetic cu'uncutique lic sa' sbaic boch'o co'ol c'usi chalic yu'un ta snopbeic smul li Jesuse, yu'un tsc'anic ti ac'o chamuc oe. Pero mu'yuc boch'o co'ol c'usi laj yalic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Altic ep i'epalc'opojic ta stojol li Jesuse, muc co'oluc c'usi laj yalic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iva'iic yan j'epalc'opetic noxtoc, jech laj yalic: ");
INSERT INTO tzotze_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Li vinic li'i laj ca'icutic jech laj yal: “Ta jvuq'ues li templo li'i ti pasbil ta c'abale. Ta oxib no'ox c'ac'al ta jcha'va'an ta ach', muc xa pasbiluc o ta c'abal”, xi ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero muc co'oluc sc'opic noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jech iva'i ta o'lol li más banquilal palee. Jech la sjac'be li Jesuse: ―¿C'u yu'un mu xatac'ov? ¿Me melel li c'usi chalic ta aventae? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Me jbeluc muc xtac'ov li Jesuse. Li más banquilal palee la sjac'be noxtoc li Jesuse: ―¿Me vo'ot Cristoot ti t'ujbilot yu'un Dios chaventainuncutique? ¿Me vo'ot Xnich'onot li Diose? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Itac'ov li Jesuse: ―Vu'un. Ta to xavilic ta xlic jventain cristianoetic ta stsatsal Dios. Ts'acal to chilic scotol cristianoetic chital ta toc ta vinajel, vu'un ti co'ol cristianoutique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Li más banquilal palee la sli' sc'u' yu'un la snop ti laj xa stabe tsots smul li Jesuse. Jech laj yal: ―¿C'u yu'un ta jc'antic yan testigo? ");
INSERT INTO tzotze_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Laj xa ava'yic ti tscuy sba ta Dios stuque. ¿C'uxi xu' ta stoj o smul chava'yic? ―xi. Scotolic laj yalic ti ja' lec ac'o chamuque. ");
INSERT INTO tzotze_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lic stubtabeic sat. La smacbeic sat, la smajic, jech laj yalbeic: ―Alo tal ca'tic ti boch'o la smajote ―xutic. Li yajmayoltac paleetique imajvanic ec. ");
INSERT INTO tzotze_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Li Jesuse tey ic'bil muyel ta xcha'cojal jolna. Yan li Pedroe tey chotol ta olon ta yamac' li más banquilal palee. Tey ital jun squiara li banquilal palee. ");
INSERT INTO tzotze_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Laj yil tey ta xc'atin li Pedroe. La sq'uel lec, jech laj yalbe: ―Vo'ote ja' achi'il ec li Jesús liquem tal ta lum Nazarete ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Li Pedroe laj yal ti mu xotquine: ―Mu xcotquin. Mu jna' c'usi chaval ―xi. Itots, ibat ta nopol muc'ta ti'na tey ta ti' calle. Ja' o i'oc' cots. ");
INSERT INTO tzotze_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Li quiarae laj yil yan velta li Pedroe. Jech laj yalbe li boch'otic tey oyique: ―Li vinic le'e ja' xchi'il li Jesuse ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Li Pedroe laj yal yan velta ti mu xotquine. Ta jliquel noxtoc ic'opanat yu'un li boch'otic tey oyique: ―Ta melel ono'ox ti ja' achi'ile. Yu'un xvinaj ti vo'ot galilea vinicote yu'un ja' jech ac'op ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lic chopolc'opojuc li Pedroe, la st'abbe sbi Dios: ―Yiloj Dios mu xcotquin li vinic chavalique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ja' o i'oc' xcha'oq'uelal cots. Tey ivul ta sjol Pedro ti jech ono'ox albil yu'un Jesuse: “C'alal mu'yuc to'ox oq'uem chib velta cotse, oxib xa'ox velta avaloj ti mu xavotquinune”, x'utat ono'ox. C'alal la snop c'usi albil li Pedroe, lic yoc'ta sba. ");
INSERT INTO tzotze_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","C'alal isacube, la stsob sbaic scotol li boch'otic oy yabtelique, ja' li banquilal paleetique, xchi'uc li jchapanvanejetique, xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. La snopic c'usi tspasic ta sventa li Jesuse. Lec chucul laj yiq'uic batel, c'ot yaq'uic ta sc'ob Pilato, ja' li gobernadore. ");
INSERT INTO tzotze_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Li Pilatoe jech la sjac'be li Jesuse: ―¿Me vo'ot muc'ta ajvalilot yu'un li achi'iltac ta israelale? ―xut. ―Vu'un ―xi itac'ov li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Li banquilal paleetique ep la stic'beic smul li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Li Pilatoe jech la sjac'be yan velta li Jesuse: ―¿C'u yu'un muc xatac'ov? Q'uelavil, ep ta stiq'uic amul ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Me jbeluc muc xtac'ov li Jesuse. Li Pilatoe toj ch'ayel ic'ot yo'nton c'alal laj ya'i ti muc spoj sba li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Li Pilatoe jech stalel o ti ta jujun q'uin coltael ta scolta jun jchuquel ti bu junucal ta sc'anic li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tey tiq'uil ta chuquel jun jchi'ilcutic, Barrabás sbi. Tey tic'ajtic ta chuquel xchi'uc xchi'iltac yu'un imilvanic. Yu'un la stsob sbaic la scontrainic li gobernadore. ");
INSERT INTO tzotze_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","C'alal tey stsoboj sbaic scotol li jchi'iltaccutic ta israelale, lic sc'anbeic Pilato ti ac'o scolta jun jchuquel jech chac c'u cha'al ta spas ono'ox ta jujun q'uin coltaele. ");
INSERT INTO tzotze_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jech la sjac' li Pilatoe: ―¿Me ja' chac'anic ta jcolta li muc'ta ajvalil avu'unique? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yu'un sna'oj ono'ox Pilato ti ta scoj xti'et yo'ntonic yu'un li Jesús ti laj yaq'uic ta c'abale. ");
INSERT INTO tzotze_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Li banquilal paleetique la xchanubtasic cristianoetic ti co'ol ja' ac'o sc'anic coltabel li Barrabase. ");
INSERT INTO tzotze_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Li Pilatoe la sjac' yan velta: ―¿C'usi chac'anic ta jpasbe li boch'o tscuy sba ta ajvalil avu'unic chavalique? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsots i'avan scotolic: ―¡Joc'ano ta cruz! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―¿Pero c'usi smul avu'unic? ―xi li Pilatoe. Más to tsots i'avanic: ―¡Joc'ano ta cruz! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Li Pilatoe la sc'an ti lec ch‑ilat yu'un li cristianoetique jech la spas li c'usi la sc'anique. La scolta li Barrabase. Laj yal mantal ti ac'o yac'beic nucul li Jesuse. C'alal laj yac'beic nucule, laj yac' ta c'abal yu'un ac'o bat joc'anatuc ta cruz. ");
INSERT INTO tzotze_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Li yajsoldadotac gobernadore laj yiq'uic ochel ta yut cabildo li Jesuse, pretorio sbi. Tey la stsob sbaic scotol li yan xchi'iltac ta soldadoile. ");
INSERT INTO tzotze_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","La slapbeic yax'elan c'u'il li Jesuse. La sts'otic ch'ix, la xojbeic ta sjol sventa scorona. ");
INSERT INTO tzotze_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lic slabanic, jech laj yalbeic: ―¡Toj lec muc'ta ajvalilot yu'un li achi'iltac ta israelale! ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La smajbeic sjol ta aj. La stubtaic. La squejan sbaic la snijan sbaic ta stojol yu'un tslabanic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","C'alal la slabanique, la sloc'beic li yax'elan c'u'ile, la slapbeic sc'u' stuc. Laj yiq'uic batel yu'un bat sjoc'anic ta cruz. ");
INSERT INTO tzotze_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","C'alal ibatique, tey la snupic ta be jun jchi'ilcutic ta israelal, Simón sbi, yu'un ital ta lum. Ja' stotic li Alejandro xchi'uc Rufoe. Cirene sbi slumal. Li soldadoetique laj yac'beic xq'uechbe batel scruzal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tey laj yiq'uic batel yo' bu Gólgota sbie. Ja' Baquil Jolal, xi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tey laj yac'beic yuch' pajal ya'lel ts'usub capal ta ch'ail poxil, mirra sbi. Ja' smacubil xc'uxul li mirrae, pero muc xuch'. ");
INSERT INTO tzotze_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","C'alal la sjoc'anic ta cruz Jesús li soldadoetique, la spasic canal tajimol yu'un tsvoc'beic li sc'u'e yu'un jech chilic bu jlicucal chc'ot ta stojol jujunic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta baluneb ora ta sob la sjoc'anic ta cruz li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tey ts'ibabil ta te' ta sjol scruzal li c'usi smul yu'unique. “Li'i ja' muc'ta ajvalil yu'un israeletic”, xi ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oy chib j'eleq'uetic co'ol la sjoc'anic ta cruz xchi'uc li Jesuse. Jun scruzal ta sbats'ic'ob, jun scruzal ta sts'et. ");
INSERT INTO tzotze_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ja' ic'ot o ti jech ono'ox ts'ibabil sc'oplal ta sc'op Diose: “Ta xcuyat jech chac c'u cha'al jpasmulil”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Li boch'otic tey ijelovique la slabanic. La sjimulan sjolic, jech laj yalic: ―¡Ay ava'i un! Sc'oplal vo'ot chavuq'ues li temploe, sc'oplal chacha'va'an ta oxib c'ac'al chaval. ");
INSERT INTO tzotze_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Colta aba atuc. Yalan tal ta cruz ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ja' no'ox jech ilabanvanic ec li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Jech laj yalbe sbaic: ―La scoltaan yan cristianoetic pero mu xu' yu'un tscolta sba stuc. ");
INSERT INTO tzotze_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Me melel ti ja' Cristoe, ti ja' muc'ta ajvalil cu'untique, ac'o yaluc tal ta ora ta cruz. Ja' to tey ta xquiltic, ja' to ta jch'untic ―xiic. Ja' no'ox jech ilabanvanic ec li chib j'eleq'uetic tey joc'ajtic ta cruz xchi'uc Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","C'alal o'lol xa'ox c'ac'ale, i'ic'ub osil. Ic' icom c'alal to ta o'lol syalel c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta o'lol syalel c'ac'al tsots i'avan li Jesuse: ―Eloi, Eloi, ¿lama sabactani? ―xi. “Dios cu'un, Dios cu'un, laj xa acomtsanun”, xi smelol. ");
INSERT INTO tzotze_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oy jayibuc boch'otic tey laj ya'yic, jech laj yalic: ―¡Ay ava'i! Ja' ta xic' tal Elías ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ta anil ibat jun vinic, bat sts'aj tal ta pajal ya'lel ts'usub jun esponja. La xoj muyel ta aj, laj yac'be sts'uts' li Jesuse. ―Jmalatic, jq'ueltiquic me ta xtal coltaatuc yu'un li Elíase ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tsots i'avan li Jesuse jech iloc' o xch'ulel. ");
INSERT INTO tzotze_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Li muc'ta poc' tey joc'ol ta yut temploe, ili' ta o'lol. Ili' yalel tal ta cajal c'alal to ta olon. ");
INSERT INTO tzotze_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tey va'al ta stuq'uil Jesús li capitán soldadoe. C'alal laj yil icham li Jesuse, jech laj yal: ―Ta melel ja' xnich'on Dios li vinic li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","C'alal joc'ol xa'ox ta cruz li Jesuse, oy jayibuc antsetic ta sq'uelic tal ta nom. Ja' tey oy li María liquem tal ta Magdalae, xchi'uc Salomé, xchi'uc yan María, ja' sme' li Josée xchi'uc li its'inal Jacoboe. ");
INSERT INTO tzotze_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ja' li antsetic ti la xchi'inic ta xanubal Jesús tey ta Galilea banamil ti la smac'linique. Tey oyic noxtoc ep yan antsetic ti la xchi'inic batel ta Jerusalén li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","C'alal jech ic'ot ta pasele, ja' o yorail ta jchapan jbacutic sventa ta jcux co'ntoncutic ta yoc'omal. Tey oy jun jchi'ilcutic, José sbi. Ja' tey liquem tal ta lum Arimatea. Ja' jchapanvanej tey ta templo. Lec ich'bil ta muc'. Smalaoj ec ti tsta sc'ac'alil chtal sventainuncutic li boch'o t'ujbil yu'un Diose. C'alal mal xa'ox c'ac'ale, li Josée tsots yo'nton i'och sc'anbe sbec'tal Jesús ta stojol Pilato. ");
INSERT INTO tzotze_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Li Pilatoe ch'ayel ic'ot yo'nton c'alal laj ya'i ti chamen xa li Jesuse. Yu'un mu'yuc yiloj me ta xchamic ta ora li boch'o chjoc'anat ta cruze. Jech la stac ta iq'uel li capitán soldadoe, la sjac'be me melel ti chamen xa li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","C'alal i'albat yu'un capitán ti melel chamen xa li Jesuse, laj yal mantal ti ac'o yich'be batel sbec'tal Jesús li Josée. ");
INSERT INTO tzotze_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Li Josée la sman jun lequil manta. La syales ta cruz li Jesuse, la xpix ta lequil manta, bat smuc ta vombil ton. La xbalch'un tal jbej muc'ta ton, ja' la smacbe o sti' li ch'ene. ");
INSERT INTO tzotze_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Li María liquem tal ta Magdalae xchi'uc li yan María sme' Josée, laj yilic bu imucat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","C'alal ech'em xa'ox li sc'ac'alil ta jcux co'ntoncutique, la smanic muil poxil li María ti liquem tal ta Magdalae, xchi'uc Salomé, xchi'uc li yan María sme' Jacovoe, yu'un chbat yac'beic ta sbec'tal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta sob ta sliquebal semana, ja' li domingoe, ibatic yo' bu vombil tone. Loq'uem xa'ox c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jech laj yalbe sbaic: ―¿Boch'o chixbalch'unbutic loq'uel tana li ton tey ta ti' ch'ene? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yu'un toj muc' li ton smacojic o ti' ch'ene. C'alal ic'otique, ja' to laj yilic ti balch'unbil xa loq'uel li tone. ");
INSERT INTO tzotze_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","C'alal i'ochic ta yut vombil tone, laj yilic oy boch'o tey oy xco'laj xchi'uc jun sva'lej querem laj yilic. Tey chotol ta stuq'uil sbats'ic'obic. Natil saquil c'u'il slapoj. Toj xi'el ic'otic li antsetique. ");
INSERT INTO tzotze_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Li quereme jech laj yalbe li antsetique: ―Mu me xaxi'ic. Ta jna' ti ja' chasa'ic li Jesús liquem tal ta Nazarete, ja' ti imilat ta cruze. Pero icha'cuxi xa. Mu'yuc xa li'i. Q'uelavilic li yav bu laj to'ox yaq'uique. ");
INSERT INTO tzotze_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bat me albeic Pedro xchi'uc yan yajchanc'optac ti ja' ba'yuc ta xc'ot yu'unic ta Galileae. Ja' to tey ta xc'ot yilic jech chac c'u cha'al albilic ono'oxe ―x'utatic batel li antsetique. ");
INSERT INTO tzotze_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Li antsetique ixi'ic loq'uel ta yut li vombil tone, ibatic ta anil. Xt'elajetic xa batel ta xi'el. Mu'yuc boch'o laj yalbeic batel ta be yu'un ixi'ic. ");
INSERT INTO tzotze_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","C'alal icha'cuxi Jesús ta sob ta sliquebal semanae, ba'yuc laj yac' sba ta ilel ta stojol li María liquem tal ta Magdalae. Ja' ti iloq'uesbat vucub pucuj ta yo'ntone. ");
INSERT INTO tzotze_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ibat li Maríae, bat yalbe ya'yic yajchanc'optac ti icha'cuxi xa li Jesuse. Li yajchanc'optac Jesuse tey chat yo'ntonic ch‑oq'uic c'ot taaticuc yu'un li Maríae. ");
INSERT INTO tzotze_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","C'alal laj ya'yic ti cha'cuxem xa li Jesuse xchi'uc ti laj xa yil li Maríae, muc xch'unic. ");
INSERT INTO tzotze_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ts'acal to laj yac' sba ta ilel Jesús ta stojol chib jch'unolajel tey chanovic ta be. Sc'atajesoj sat li Jesuse jech muc xotquinic ta ora. ");
INSERT INTO tzotze_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Li chibique isutic ta Jerusalén, bat yalbe ya'yic li yantique pero muc xch'unbatic ec. ");
INSERT INTO tzotze_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ts'acal to laj yac' sba ta ilel Jesús ta stojol buluchib yajchanc'optac ti c'alal ja' o ta xve'ique. Itaq'uiatic ta sventa ti muc xch'unique xchi'uc ta scoj ti tsots yo'ntonique. Yu'un muc xch'unic c'usi laj yalic li boch'otic laj yilic ti cha'cuxem xa li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jech i'albatic yu'un li Jesuse: ―Batanic ta scotol banamil. Cholbeic scotol cristianoetic ti ja' no'ox chcolic ta jventae. ");
INSERT INTO tzotze_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Scotol boch'o ta xch'unic ti chcolic ta jventae xchi'uc ti chich'ic vo'e ja' chcolic. Yan li boch'otic mu xch'unique ja' ta x'ac'batic castigo yu'un smulic. ");
INSERT INTO tzotze_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Li boch'otic ta xch'unique ta spasic sq'uelubiltac jtsatsal. Ta sloq'uesic pucujetic ta yo'nton cristianoetic ta jvu'el. Ta xc'opojic ta ora no'ox ta yantic c'opetic. ");
INSERT INTO tzotze_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ac'o me ta xti'atic ta orachon, o me ta ts'inte', ac'o me oy ta x'ac'bat yuch'ic veneno, mu'yuc c'usi ta spasbatic. Ta xac' sc'obic ta sbec'tal jchameletic, ta xcol yu'unic ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","C'alal ilaj yo'nton ta sc'opanel yajchanc'optac li Cajvaltique, i'ic'at muyel ta vinajel. Tey c'ot chotluc ta sbats'ic'ob Dios. ");
INSERT INTO tzotze_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Li yajchanc'optaque iloc' xcholic ta scotol banamil ti ja' no'ox chijcol ta sventa Cajvaltique. Tey xchi'inojic ta abtel li Cajvaltique. Jech i'ac'bat spasic sq'uelubiltac yu'un ac'o vinajuc ti ta melel ja' sc'op ta xcholique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ajvalil Teófilo, ep xa boch'o la sts'ibaic ta vun li c'usitic lec ic'ot ta jtojolcutique. Ti c'u cha'al laj yalbun ca'icutic li boch'otic laj yilic c'alal lic stsac yabtel li Jesuse, ja' li boch'otic ja' yabtelic o xcholel li sc'ope, ja' jech la sts'ibaic ta vun scotol. Vu'un ec li Lucasune, laj xa jnop ti ja' lec chacalbot scotol li c'usitic laj ca'i ta sliquebe xchi'uc c'alal to li' ta orae, yu'un laj xa ca'i scotol li c'usitic laj yich' pasele. Jech xquechet ta jts'ibabot scotol yu'un jech chana' o ti ja' melel c'u x'elan chanubtasbilote. ");
INSERT INTO tzotze_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","C'alal ochem ta ajvalilal tey ta Judea banamil li Erodese, ja' o ochem ta paleal yu'un israeletic jun vinic, Zacarías sbi. Li paleetic yu'unique ep ta voc' spasoj sbaic yu'un tsjelilan sbaic. Li Zacaríase ja' xchi'iltac ta paleal li jvoc' yu'un Abías sbie. Li yajnil Zacaríase Elisabet sbi. Li Elisabete ja' smoltot ta vo'one li Arone, ja' ti ba'yuc itic'at ta paleal yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Li Diose yiloj ti tuc' yo'nton xchi'uc yajnil li Zacaríase. Yu'un xch'unojic c'usi yaloj li Cajvaltic Diose. Jech mu'yuc smul i'ilatic o yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero mu'yuc yol xnich'onic yu'un mu sna' x'alaj li Elisabete. Mol me'el xa xchibalic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Li Zacaríase la sta sc'ac'alil ja' ta x'abtej ta stojol Dios ta templo xchi'uc li xchi'iltac ta paleale. Yu'un li paleetique ta sjelilan sbaic ti jayvoc' spasoj sbaique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ti jayibic ja' yorail ta x'abtejique stalelic ti ta spasic canal tajimol jujun c'ac'ale, yu'un ta sq'uelic boch'o junucal chc'ot ta stojol ta xbat xchic' pom tey ta yut templo yu'un Diose. C'alal la spasique, ja' ic'ot ta stojol li Zacaríase. ");
INSERT INTO tzotze_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","C'alal ta xchiq'uic pom ta yut templo li paleetique, li cristianoetique tey va'ajtic ta amac' ta sc'opanic Dios. Yu'un jech ono'ox ta spasilanic o. ");
INSERT INTO tzotze_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","C'alal ja' o tey ta xchic' pom li Zacaríase, ital yaj'almantal Dios. Tey va'al ivul ta sts'el scajleb xchic'ubil pom tey ta stuq'uil sbats'ic'ob li Zacaríase. ");
INSERT INTO tzotze_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","C'alal laj yil j'almantal li Zacaríase, toj xi'el no'ox ic'ot. Ep ilo'ilaj yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jech i'albat yu'un li j'almantale: ―Mu me xaxi', Zacarías. Laj xa ya'ibot ac'op li Diose. Ta x'alaj li Elisabete, ja' li avajnile. Querem ta xvoc' yu'un. Juan chavac'be sbi. ");
INSERT INTO tzotze_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","C'alal me ivoq'ue, xcuxet no'ox avo'nton yu'un. Jech ep boch'otic xcuxet no'ox yo'ntonic ec. ");
INSERT INTO tzotze_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yu'un ja' ta xich' tsots yabtel ta stojol Dios. Mu xuch' ya'lel ts'usub ti pajuben xae, mu xuch' pox. Ventainbil yo'nton yu'un Ch'ul Espíritu ti c'alal ta xvoq'ue. ");
INSERT INTO tzotze_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Oy ep achi'iltac ta israelal ta scomtsan smulic ta sventa li Juane, ja' ta xac' sbaic ta ventainel yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Li Juane ja' ba'yuc ta xtal, ja' ts'acal ta xtal li Jcoltavanej avu'unique. Li Juane co'ol yo'ntonic co'ol svu'elic xchi'uc li Elíase. Jech ba'yuc ta xtal yalbe achi'iltac ti ac'o scomtsanic li c'usitic chopol tspasique jech chco'laj yo'nton xchi'uc xnich'nabic ta jujubej snaic. Ta stuq'uibtasbe yo'ntonic li boch'otic mu xch'unic mantale yu'un ja' ac'o yich'ic ta muc' c'alal me ital li Cajvaltique ―xi li j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Li Zacaríase la sjac'be li j'almantale: ―¿C'uxi ta jna' me melel li c'usi laj avalbune? Yu'un molun xa, me'el xa ec li cajnile ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Itac'ov li j'almantale: ―Vu'un Gabrielun, vu'un tey chi'abtej ta stojol Dios. Tacbilun tal yu'un Dios ti tal jc'opanote. Ja' tal calbot ava'i ti ta to xvoc' jun anich'one. ");
INSERT INTO tzotze_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero ta sventa ti mu xach'un c'usi laj calbote jech chapas ta uma'. Ja' to me la sta sc'ac'alil ta xvoc' anich'on jech chac c'u cha'al laj calbote, ja' to ta xjam ave. Yu'un ta ono'ox xc'ot ta pasel ta xvoc' anich'on me la sta yorail yu'un Diose ―x'utat li Zacaríase. ");
INSERT INTO tzotze_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Li cristianoetic tey oyic ta amaq'ue, tey tsmalaic ta xloc' tal li Zacaríase. Tey chlo'ilaj yo'ntonic yu'un tey ijalij ta yut templo. ");
INSERT INTO tzotze_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","C'alal iloc' tal li Zacaríase, mu xa xu' tsc'opan li cristianoetique. Jech la sna'ic o ti yu'un oy c'usi i'ac'bat yil yu'un Dios tey ta yut temploe. Yu'un ta sc'ob xa no'ox laj yac' ta ilel li c'usi ipasbate, yu'un ipas ta uma'. ");
INSERT INTO tzotze_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","C'alal its'aqui jayib c'ac'al tey ta x'abtej ta templo li Zacaríase, isut batel ta sna. ");
INSERT INTO tzotze_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jech lic xchi'in yol li yajnile, ja' li Elisabete. C'alal oy xa'ox xch'ute, vo'ob u ti muc xloc' ta snae. Jech la snopilan: ");
INSERT INTO tzotze_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Laj yil Cajvaltic Dios ti chisna'leicun li cristianoetique, jech la xc'uxubinun. Laj xa yac'bun tal col”, xi ta yo'nton li Elisabete. ");
INSERT INTO tzotze_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","C'alal svaquibal xa'ox u xchi'in yol li Elisabete, li Diose la stac tal yaj'almantal, ja' li Gabriele. Ja' tey la stac tal ta lum Nazaret ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Li Gabriele tey ic'ot sc'opan jun tojol tseb. Mu'yuc to yiloj vinic li tsebe. Pero macbil xa'ox yu'un jun vinic, José sbi. Li Josée ja' smoltot ta vo'one li Davide. Li tsebe María sbi. ");
INSERT INTO tzotze_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Li j'almantale tey i'och yo' bu oy li tsebe, jech laj yalbe: ―Vo'ot t'ujbilot yu'un Dios. Li' xchi'inojot. Mu'yuc boch'o yan tseb ta xac'be yabtel jech chac c'u cha'al li vo'ote ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","C'alal laj ya'i c'usi i'albat yu'un j'almantal li Maríae, ilo'ilaj yo'nton. Tey lic snop ta yo'nton c'usi smelol ti jech i'albate. ");
INSERT INTO tzotze_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Laj yal noxtoc li j'almantale: ―Mu xaxi', María. Lec chayilot li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A'yo ava'i li c'usi chacalbote. Ta xlic achi'in avol. Chavoq'ues jun querem. Jesús chavac'be sbi. ");
INSERT INTO tzotze_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta to x'ich'at ta muc' yu'un ja' Xnich'on Dios ta vinajel. Li Diose ta xac' ochuc ta ajvalilal. Ja' chlic spasoxuc ta mantal jech chac c'u cha'al la spas ta mantal achi'iltac ta vo'one li amoltotic Davide. ");
INSERT INTO tzotze_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sbatel osil ta spasoxuc ta mantal, vo'oxuc li israeloxuque. Mu'yuc slajeb ta spasoxuc ta mantal ―xi li j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Itac'ov li Maríae: ―¿C'uxi ta x'ayin col yu'un mu'yuc to quiloj vinic? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Itac'ov li j'almantale: ―Ja' ta xtal ta atojol li Ch'ul Espíritue. Ta sventa stsatsal Dios ta xlic achi'in li olole. Li olol ta xvoc' avu'une mu'yuc smul yu'un ja' Xnich'on Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A'yo ava'i, oy xa xch'ut jun avuts' avalal, ja' li Elisabete. Ac'o me me'el xa pero svaquibal xa u xchi'in li yole, ja' ti mu ono'ox sna' x'alaje. ");
INSERT INTO tzotze_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Li Diose xu' yu'un ta spas scotol ―xi li j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Itac'ov li Maríae: ―Lec oy, ac'o tuncun yu'un li Diose. Ac'o spasbun li c'usi laj avalbune ―xut. Jech ibat li j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ts'acal to iloc' batel li Maríae. Ta anil ibat ta jun lum tey ta Judea banamil. Li lume ta siquil osil oy yu'un puro vitsetic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ja' to tey oy sna li Zacaríase. Ja' tey ic'ot li Maríae. Tey i'och ta sna. ―Vixin ―xut c'otel li Elisabete. ");
INSERT INTO tzotze_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","C'alal laj ya'i li Elisabete, tsots la xijilan sba li yol xchi'inoje. Li Elisabete iventainbat yo'nton yu'un Ch'ul Espíritu. ");
INSERT INTO tzotze_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jech tsots lic c'opojuc: ―Mu'yuc boch'o yan tseb ta x'ac'bat yabtel jech chac c'u cha'al vo'ot. Toj lec li olol ta xvoc' avu'une. ");
INSERT INTO tzotze_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Li vu'une mu'yuc ich'bilun ta muc' jech mu smeloluc ti vo'ot tal aq'uelune, yu'un vo'ot sme'ot li Cajvale. ");
INSERT INTO tzotze_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yu'un c'alal laj ac'opanune, xcuxet no'ox yo'nton la xijilan sba li col jchi'inoje. ");
INSERT INTO tzotze_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Toj lec ti laj ach'un ti chc'ot ta pasel c'usi la'albat yu'un Cajvaltic Diose ―xi li Elisabete. ");
INSERT INTO tzotze_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Li Maríae jech laj yal: Toj ech'em slequilal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Xcuxet no'ox co'nton ta stojol yu'un ja' Jcoltavanej cu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ac'o me mu bijucun, pero laj yil ti ta jc'an chitun yu'une. Scotol cristianoetic jech ta xalic ti c'alal chjelovic li' ta banamile: “Xcuxet no'ox yo'nton ti i'ac'bat svoq'ues li Cajvaltique”, xi jc'oplal yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Li Diose ech'em stsatsal. Toj lec li c'usi la spasbune jech ac'o ich'atuc ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Li jujuc'ol cristianoetic ta xjelovic li' ta banamile, li boch'otic ta xich'ic ta muc' Diose ta xich'ic c'uxubinel. ");
INSERT INTO tzotze_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Li Diose yac'oj ta ilel ti scotol xu' yu'une. Xu' yu'un ta spajesbe yabtel li boch'otic ta stoy sbaique, ja' li boch'otic bij yalojique, jech mu xu' yu'unic li c'usitic snopojique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Xu' yu'un ta sloq'ues ta yabtel li boch'otic banquilaletic ta pasmantale. Xu' yu'un ta xac'be tsots yabtel li boch'otic mu'yuc stu ch‑ilatique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Puro lec c'usitic chac'be ta yo'ntonic li boch'otic sna'ic ti mu'yuc lec yo'nton stuquique. Yan li boch'otic lec yo'nton yalojique mu'yuc c'usi ta x'ac'batic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Vu'utic li israelutique ta scoltautic li jayib cajvalinojtic oe. Yu'un mu xch'ay ta yo'nton ti jech ono'ox laj yalbe li jmoltotactic ta vo'onee. Yu'un laj ono'ox yalbe Abraám ti ta xc'uxubin sbatel osil xchi'uc smomnich'nabe, xi li Maríae. ");
INSERT INTO tzotze_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Li Maríae tey la xchi'in sbaic oxib u xchi'uc li Elisabete. Ts'acal to isut batel ta sna. ");
INSERT INTO tzotze_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","C'alal sta yorail la xcux li Elisabete, querem ivoc' yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Li yuts' yalaltac Elisabete xchi'uc li boch'otic tey noch' nacajtic xchi'uque, laj ya'yic ti ivoc' xa yole yu'un ic'uxubinat yu'un Dios. Jech co'ol xcuxet yo'nton scotolic xchi'uc li Elisabete. ");
INSERT INTO tzotze_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","C'alal iloc' vaxaquib c'ac'al svoq'uel li unin quereme, tal yac'beic yich' circuncisión. Li yuts' yalaltaque la snopic ti ja' ta xich'be sbi stot li unin quereme. ");
INSERT INTO tzotze_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero li sme'e jech laj yal: ―Mu jechuc ta xcac'becutic sbi. Juan ta xcac'becutic sbi ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jech i'albat: ―¿C'u yu'un jech chavac'beic sbi? Yu'un mu'yuc boch'o jech sbi cu'untic li'i ―x'utat yu'un li yuts' yalaltaque. ");
INSERT INTO tzotze_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jech tey lic sjac'beic stot li olole. La spasbeic senyail ta sc'obic yu'un ac'o yal c'usi sbi ta xac'be li xnich'one. ");
INSERT INTO tzotze_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Li Zacaríase tey lic sc'an jun pech'pech' te', jech la sts'iba: “Juan ta xcac'be sbi”, xi. Jech toj ch'ayel ic'ot yo'nton scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta ora tey ijambat ye yu'un Dios li Zacaríase, lic lo'ilajuc. Laj yalbe slequilal Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jech toj xi'el ic'otic li boch'otic tey noch' nacalic xchi'uque. Li boch'otic tey nacajtic ta vitsetic ta Judea banamile, laj ya'i scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Scotol li boch'otic laj ya'yique jech la snopilan ta yo'ntonic: “¿C'usi yabtel ta xbat li querem va'i x'elane?” xi ta yo'ntonic. Yu'un li quereme chi'inbil yu'un Cajvaltic Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Li Zacaríase, ja' li stot unin quereme, iventainbat yo'nton yu'un Ch'ul Espíritu. Ja' laj yal li c'usi ta to xc'ot ta pasele. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Coliyal li Cajvaltic Diose, ja' li Dios cu'untic vu'utic li israelutique, chtal xa sq'uelutic, vu'utic ti t'ujbilutic ono'ox yu'une. Chtal xa scoltautic. ");
INSERT INTO tzotze_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chtal xa li Jcoltavanej cu'untique, ja' ti toj ech'em stsatsale. Ja' smomnich'on David, ja' ti lec itun yu'un Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Li Diose vo'one ono'ox la xch'amanbe ye li yaj'alc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ja' laj yalic ti ta to xijcolutic loq'uel ta sc'ob li cajcontratique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta xixc'uxubinutic jech chac c'u cha'al laj ono'ox yalbe li jmoltotactic ta vo'onee. Jech ta xquiltic o ti mu xch'ay ta yo'nton c'usi la xchapan xchi'uc li jmoltotactic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ja' vu'utic jc'oplaltic ti laj yalbe jmoltotic Abraám ti j'ech'el chiscoltautic loq'uel ta sc'ob cajcontratique, jech mu'yuc xa xi'el chca'itic, jech xu' xa chijtunutic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Jech jun no'ox co'ntontic ta xquich'tic ta muc' ti jayib c'ac'al li' cuxulutique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Li jnich'one ja' yaj'alc'op Dios chc'ot. Ja' ba'yuc chlic abtejuc, ja' ts'acal chlic abtejuc li Cajvaltique. Ja' chlic yalbe jchi'iltactic ti ac'o scomtsanic li c'usitic chopol ta spasique jech xu' yu'unic ta xich'beic ta muc' li sc'ope. ");
INSERT INTO tzotze_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ja' chalbe ya'yic ti tspasbatic perdón yu'un smulique yu'un jech xu' chcolic o me ta xch'unic ti ja' Jcoltavanej yu'unique. Yu'un t'ujbilutic ono'ox yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jech slequil no'ox yo'nton chixc'uxubinutic li Dios cu'untique, ta xa stacbutic tal li Jcoltavanej cu'untique. Toj lec ti li' ta xtal ta jtojoltique. ");
INSERT INTO tzotze_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ja' chiscoltautic yu'un jech lec chijyilutic li Diose jech chlaj sc'oplal ti ch'ayel chijbate, xi li Zacaríase. ");
INSERT INTO tzotze_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","C'alal ich'i li quereme, i'ayin stsatsal yo'nton. Jech stuc tey bat nacluc ta xocol banamil. C'alal la sta yorail lic yal sc'op Diose, tey tal ya'yic li xchi'iltac ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Li muc'ta ajvalil Augusto Cesare ja' o ochem ta muc'ta ajvalil ta sventa scotol banamil c'alal ivoc' li Juane. Ja' o yorail laj yal mantal ti ac'o yac' ta tsaquel ta vun sbiic scotol cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ja' sba to velta jech la spasic ti c'alal ja' o tiq'uil ta gobernador tey ta Siria banamil li Cirenioe. ");
INSERT INTO tzotze_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jech scotol cristianoetic bat yac' ta tsaquel sbiic ta slumal stuquic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Li Josée iloc' batel ta lum Nazaret tey ta Galilea banamil. Tey ibat ta Judea banamil. Tey ic'ot ta lum Belén yu'un ja' tey ivoc' li smoltot ta vo'onee, ja' li Davide. ");
INSERT INTO tzotze_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yu'un ja' slumal ic'ot ec li Josée, jech tey ibat yac' ta tsaquel sbiic ta Belén xchi'uc li Maríae, ja' li yajnile. Pero mu'yuc to'ox xcuxoj li Maríae. ");
INSERT INTO tzotze_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","C'alal tey oyic ta Belene, tey la sta yorail ta xcux li Maríae. ");
INSERT INTO tzotze_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ivoc' li sba yole. Ja' querem. La xpix ta c'a'poc', tey la xpuch'an ta yavil sve'ub vacax yu'un ta snail sve'ub vacax ochemic. Yu'un mu'yuc xa xocol la staic li snail vaybal ti loc'bile yu'un jbej no'ox. ");
INSERT INTO tzotze_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tey ta nopol ti' Belén tey oy jayibuc jchabichijetic. Tey ta xchabi xchijic ta ac'ubaltic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta ora tey ivinaj jun yaj'almantal Dios. Tey ivul xojobal Dios ta stojolic. C'alal laj yilic li jchabichijetique, toj xi'el no'ox ic'otic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jech i'albatic yu'un li j'almantale: ―Mu xaxi'ic. Oy c'usi lec chacalboxuc yu'un jech xcuxet no'ox avo'nton acotolic. Ac'o ya'yic scotol li achi'iltaquic ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nax ivoc' ta Belén jun Jcoltavanej avu'unic. Ja' t'ujbil yu'un Dios ti ta x'och ta ajvalilal avu'unique. Ja' Cajvaltic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chacalboxuc c'u x'elan chataic li olole. Pixbil ta c'a'poc' chataic, tey puch'ul ta yavil sve'ub vacax ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta ora no'ox tey ivinaj ep ta jyalel yan j'almantaletic. Laj yalic slequilal Dios. Jech laj yalic: ");
INSERT INTO tzotze_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Toj ech'em slequilal Dios ta vinajel! Ac'o pasuc ta jun yo'nton cristianoetic ta sventa ti oy slequil yo'nton ta stojolic li Diose, xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","C'alal isutic ta vinajel li j'almantaletique, jech laj yalbe sbaic li jchabichijetique: ―Batic ta Belén cha'e. Bat jq'ueltic c'usi ic'ot ta pasel ti laj yalbutic Diose ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jech ibatic ta anil. Tey la staic li María xchi'uc Josée, xchi'uc li olol tey puch'ul ta yavil sve'ub vacaxe. ");
INSERT INTO tzotze_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","C'alal laj yilic li olole, bat spucbeic sc'oplal. Bat yalic li c'usi i'albatic yu'un j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Scotol boch'o laj ya'yic c'usi laj yalic li jchabichijetique toj ch'ayel ic'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Li Maríae muc xch'ay ta yo'nton scotol c'usi laj yalic li jchabichijetique, la snopilan c'usi smelol. ");
INSERT INTO tzotze_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Isutic li jchabichijetique. Laj yich'ic batel ta muc' li Diose, laj yalbeic slequilal. Yu'un laj xa ya'yic, laj xa yilic scotol jech chac c'u cha'al i'albatic yu'un li j'almantale. ");
INSERT INTO tzotze_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","C'alal iloc' vaxaquib c'ac'al svoq'uel li unin quereme, laj yich' circuncisión. Jesús laj yac'beic sbi yu'un jech ono'ox i'albatic yu'un j'almantal ti c'alal mu'yuc to'ox xch'ut li Maríae. ");
INSERT INTO tzotze_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chal ta smantaltac Dios ti la sts'iba Moisés ta vo'onee, me querem yol li antse, ja' to xu' ta xbat ta templo me its'aqui oxlajuneb xcha'vinic (33) c'ac'al svoq'uele. Li Maríae its'aqui xa yu'un li oxlajuneb xcha'vinic c'ac'ale jech ibat ta templo tey ta Jerusalén xchi'uc li Josée, yu'un bat yalbeic Dios ti ja' yu'un li squeremique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yu'un jech chal li smantal Dios ti ts'ibabil comele: “Scotol li sba avolique, me quereme, ja' cu'un”, xi ono'ox li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Laj yac'beic smoton Dios noxtoc yu'un jech yaloj mantal li Diose: “Me mu'yuc xchije, ac'o yic' tal cha'cot puruvoc stsu, o me cha'cot stsumut, yu'un ja' ta jmotonin”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oy jun israel vinic tey ta Jerusalén, Simeón sbi. Tuc' yo'nton ta stojol Dios, lec yich'oj ta muc'. Smalaoj ti ta xtal jun ajvalil yu'unique yu'un ja' ta xcoltaatic loq'uel ta sc'ob li yan ajvalile. Li Simeone ventainbil yo'nton yu'un Ch'ul Espíritu. ");
INSERT INTO tzotze_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ac'bil xa sna' yu'un Ch'ul Espíritu ti ja' to ta xcham c'alal me laj yil li Cristo ti t'ujbil yu'un Dios ta x'och ta ajvalilal yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Li Simeone i'albat yu'un Ch'ul Espíritu ti ac'o batuc ta templo tey ta Jerusalene. Jech c'alal ibatic ta templo li José xchi'uc Maríae, xchi'uc li olole, yu'un bat spasic jech chac c'u cha'al ta xal li mantaletique, tey xa'ox oy ta yamaq'uil templo c'ot staic li Simeone. ");
INSERT INTO tzotze_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Li Simeone la spet li olole, la stojbe ta vocol Dios. Jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Cajval, jun xa co'nton, ic'un me ta atojol jech chac c'u cha'al avalojbun ono'ox, vu'un li avajtunelune. ");
INSERT INTO tzotze_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Yu'un laj xa quil li Jcoltavanej cu'uncutic ti laj atac tal ta sventa scotol cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Li yan lum cristianoetique ja' luz ta xc'ot yu'unic yu'un ta xilic ec ti xu' ta xcolique. Vu'uncutic li israeluncutic ti t'ujbiluncutic ono'ox avu'une, avich'ojuncutic ta muc' yu'un vu'uncutic li' ivul ta jtojolcutic li Jcoltavaneje, xi li Simeone. ");
INSERT INTO tzotze_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Li José xchi'uc sme' unin olole toj ch'ayel ic'ot yo'ntonic yu'un ti oy sc'oplal laj ya'yic li unin olole. ");
INSERT INTO tzotze_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Li Simeone la sc'anbe bendición ta stojolic. Jech laj yalbe noxtoc li sme' unin olole, ja' li Maríae: ―A'yo me ava'i, ta sventa li avol li'i ta xvinaj o c'u x'elan yo'ntonic li jchi'iltactic ta israelale. Ep to ta xlic yich' contrainel li avole yu'un mu xc'anat yu'un ep jchi'iltactic. Jech ep to chavat avo'nton ta sventa ti mu xc'anate. Pero oy yantic jchi'iltactic ta xlecub yo'ntonic ta sventa ―xi li Simeone. ");
INSERT INTO tzotze_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tey oy ta yamaq'uil templo jun israel ants, Ana sbi. Ja' yaj'alc'op Dios ec. Ja' stseb li Fanuele, ja' smoltot ta vo'one li Asere. Me'el xa li Anae. Vucub no'ox jabil laj yic' sbaic xchi'uc smalal yu'un icham li smalale. ");
INSERT INTO tzotze_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Li Anae chanib xa yo'vinic (84) jabil yich'oj. Ep xa jabil ti mu'yuc smalale. Scotol c'ac'al tey ta xbatilan ta yamaq'uil templo. Ta c'ac'al ta ac'ubal tey ta xtun yu'un Dios yu'un ta xicta ixim, ta sc'opan Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Li Simeone ja' o chal c'usi ta to spas olol ti c'alal ic'ot li Anae. Li Anae la stojbe ta vocol ec li Diose yu'un ital xa li Jcoltavaneje. Ts'acal to lic spucbe sc'oplal li olole, laj yalbe scotol xchi'iltac tey ta Jerusalén, ja' li boch'otic smalaoj ti chcolique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","C'alal la xa spasic scotol c'usi yaloj Dios li José xchi'uc Maríae, isutic batel ta slumalic ta Nazaret ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lec ich'i li quereme, ja' li Jesuse. Lec tsatsal querem xchi'uc lec bij yu'un coltabil yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Li stot sme' Jesuse scotol jabil tey ta xc'otilanic ta Jerusalén ti c'alal yorail q'uin coltael yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","C'alal yich'oj xa'ox lajchab jabil li Jesuse, ibatic ta q'uin ta Jerusalén, yu'un jech smantal Dios ti ta persa tey ta xbat scotol li viniquetique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","C'alal ilaj c'op q'uine, tsut xa batel ta snaic li José xchi'uc Maríae, pero muc sna'ic me tey icom ta Jerusalén li squeremique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","La snopic ti tey nabal ibat ta yuts' yalalique. C'alal ixanovic xa batel jun c'ac'ale, tey lic sjaq'uilanbeic li yuts' yalalique xchi'uc li boch'otic xotquinic li quereme. ");
INSERT INTO tzotze_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero muc staic. Jech isutic batel c'alal ta Jerusalén. Tey ic'ot sa'ilanic noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta yoxibal to c'ac'al tey la staic ta yut jun na tey ta templo ta Jerusalén. Li Jesuse tey chotol ta o'lol yu'un li jchanubtasvanejetic ta smantal Dios yalojique. Tey ta xa'i c'usi ta xalic li jchanubtasvanejetique xchi'uc oy c'usi tey yochel sjaq'uilanel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Scotol li jchanubtasvanejetique ich'ay yo'ntonic ta sventa ti toj lec ta xtac'ov li Jesuse, xchi'uc ti oy c'usi lec ta sjaq'uilane. ");
INSERT INTO tzotze_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Li José xchi'uc Maríae, c'alal laj yilic ti tey xchi'inoj jchanubtasvanejetic li squeremique, ich'ay yo'ntonic ec. Li Jesuse jech i'albat yu'un li sme'e: ―Mol, ¿c'u yu'un jech laj apasbuncutic? La jsa'cuticot ta jyalel. Laj cat co'ntoncutic avu'un yu'un muc xajtacutic ta sa'el ―x'utat yu'un li sme'e. ");
INSERT INTO tzotze_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Itac'ov li Jesuse: ―¿C'u yu'un laj asa'ilanicun? ¿Me mu xana'ic ti li' oyun yo' bu tspasbat yabtel li Jtote? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Li José xchi'uc Maríae muc xa'ibeic smelol c'usi laj yal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Li Jesuse la xchi'in sutel ta Nazaret li stot sme'e. Ti jayib jabil tey xchi'uc li stot sme'e la xch'unbe scotol smantalic. Li Maríae muc xch'ay ta yo'nton ti c'u x'elan itac'ov tey ta templo li yole xchi'uc ti lec ich'unbat smantalique. ");
INSERT INTO tzotze_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","C'alal ich'i tal li Jesuse, lec bij. Lec i'ilat yu'un Dios, lec i'ilat noxtoc yu'un li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Li Tiberio César sbie svo'lajunebal xa jabil (15) yochel ta muc'ta ajvalil tey ta lum Roma ti c'alal lic stsac yabtel li Juane. Ta Judea banamile ja' tey ochem ta gobernador li Póncio Pilatoe. Ta Galilea banamile ja' tey ochem ta gobernador li Erodese. Ta Iturea banamile xchi'uc ta Traconite banamile ja' tey ochem ta gobernador li yits'in Erodese, ja' li Felipe sbie. Ta Abilinia banamile ja' tey ochem ta gobernador li Lisániase. Li banquilal paleetic yu'un israeletique ja' ochemic li Anás xchi'uc Caifase. C'alal ja' o jech yich'anoj yabtelique, ja' o tey oy ta xocol banamil li Juane, ja' li xnich'on Zacaríase. Ja' o yorail i'albat ta yo'nton yu'un Dios ti ac'o xcholbe sc'ope. ");
INSERT INTO tzotze_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Li Juane tey ixanov batel ta ti'ti' uc'um Jordán. Jech laj yal: ―Comtsanic scotol li c'usitic chopol chapasique, ich'ic vo' jech ta spasboxuc perdón yu'un amulic li Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Li Juane jech ono'ox ts'ibabil comel sc'oplal yu'un j'alc'op Isaías ta vo'one. Jech la sts'iba: Ta to xlic jun jchi'iltic ta israelal, ja' tsots ta x'avan ta xocol banamil. Jech ta xal: “Ta xa xtal li Cajvaltique. Ja' lec comtsanic scotol li c'usitic chopol chapasique. ");
INSERT INTO tzotze_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ja' ich'beic ta muc' li sc'ope jech lec chabatic yu'un ja' ta slecubtasutic. ");
INSERT INTO tzotze_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yu'un ja' Jcoltavanej cu'untic ti tacbil tal yu'un Diose. Ja' ta xtal scolta scotol cristianoetic”, xi ta xlic yalbe li jchi'iltactique, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bats'i ep boch'otic tal sc'anic ich' vo' yu'un li Juane. Li Juane jech laj yalbe: ―Vo'oxuque ja' jechoxuc jech chac c'u cha'al orachon. Li orachone ta xjatov loq'uel ta anil c'alal me cha'i ti ta xa xtal c'oq'ue. Ja' jech c'otemoxuc li vo'oxuque. ¿Me yu'un laj ava'yic ti ta ono'ox xavich'ic castigo yu'un Dios ti latalic ta anil, tal ac'anic chacac'boxuc avich'ic vo'e? ");
INSERT INTO tzotze_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pero tsc'an chvinaj me melel ti acomtsanojic xa li c'usitic chopol chapasique. Mu me jechuc xanop ta avo'ntonic: “Ja' jmoltotic ta vo'one li Abraáme jech ta ono'ox xijcolutic”, mu me xachiic. Chacalboxuc, li Diose xu' yu'un ta sc'atajesbe ta smomnich'nab Abraám li tonetic li'i. ");
INSERT INTO tzotze_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Li vo'oxuque ja' jechoxuc jech chac c'u cha'al te'etic ti mu lecuc sat chaq'ue. Tey xa metsel eq'uel ta yibel yu'un ta xa xich' ts'etel. Ta xich' chiq'uel ta c'oc' ―xi li Juane. ");
INSERT INTO tzotze_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Li cristianoetique jech la sjac'beic li Juane: ―¿C'usi tsc'an ta jpascutic cha'e? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Itac'ov li Juane: ―Li boch'o oy cha'lic sc'u'e ac'o yac'be jlicuc li boch'o mu'yuc sc'u'e. Li boch'o oy ep sve'ele ac'o yac'be li boch'o mu'yuc sve'ele ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Oy italic jayibuc jtsobpatanetic yu'un tsc'an ta xich'ic vo' ec. Jech vul sjac'beic li Juane: ―Jchanubtasvanej, vu'uncutique ¿c'uxi ta xcut jbacutic ec? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Li Juane jech laj yalbe: ―Mu me xac'anbeic sjelovenal li patan chatsobique. Ja' no'ox jech yepal xatsobic jech chac c'u cha'al avich'ojic mantale ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tey oy noxtoc jayibuc soldadoetic. Jech la sjac'beic ec li Juane: ―Vu'uncutique ¿c'uxi ta xcut jbacutic ec? ―xiic. Itac'ov li Juane: ―Cuxetuc no'ox avo'ntonic ti c'u yepal chavich' atojolique. Mu me boch'o xasibtasic, mu me boch'o xanopbeic smul ti jech xu' chac'anbeic staq'uinique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Scotol li cristianoetique tey ta xlo'ilaj yo'ntonic yu'un tsc'an ta xa'yic me ja' t'ujbil yu'un Dios ta x'och ta ajvalilal li Juane. ");
INSERT INTO tzotze_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Li Juane jech laj yalbe scotol li cristianoetique: ―Li vu'une ja' no'ox cabtel ta xcac'be yich'ic vo' li boch'otic ta scomtsan c'usitic chopol ta spasique. Pero oy to boch'o ts'acal ta xtal, ja' tsots yabtel yich'oj. Li vu'une mu'yuc tsots cabtel quich'oj. Mu'yuc c'usi xu' cu'un ta jcolta. Ac'o me stitunbeluc yaq'uil xonob mu xu' cu'un. Yan li boch'o ts'acal ta xtale ja' chayac'boxuc avich'ic li Ch'ul Espíritue. Xco'laj xchi'uc c'oc' yu'un xu' tsloq'ues scotol li sbolil avo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Li boch'otic tsc'an loq'uesbel sbolil yo'ntonique ja' ch‑ic'atic sbatel osil. Yan li boch'otic mu sc'an loq'uesbele ja' chbatic ta c'oc' yo' bu mu ono'ox xtube. Jech chac c'u cha'al li boch'o ta xic'a strigoe, me ilaj yo'nton ta yic'aele, tstsob scotol li strigoe, ta xich' ochel ta snail. Scotol li ste'ele xchi'uc li solile ta xchic' ta c'oc' ―xi li Juane. ");
INSERT INTO tzotze_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Li Juane oy ep c'usi lec laj yalbe ya'i li xchi'iltac ta israelale. Ja' laj yalbe ya'i ti li' xa oy li boch'o sc'oplal ono'ox chtal ventainvanuque. ");
INSERT INTO tzotze_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Laj yalbe noxtoc ajvalil Erodes ti ep c'usitic chopol ta spase. Laj yalbe noxtoc ti chopol ti laj yic'be yajnil yits'ine. Erodías sbi li antse. Ja' Felipe sbi li yits'ine. ");
INSERT INTO tzotze_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero muc xch'un. Más to chopol c'usi la spas yu'un la stic' ta chuquel li Juane. ");
INSERT INTO tzotze_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","C'alal ja' o tey ta xac'be yich'ic vo' ep cristianoetic li Juane, tey ic'ot li Jesuse, i'ac'bat yich' vo' ec. Tey la sc'opan Dios li Jesuse. C'alal ja' o ta sc'opan Diose, ijam li vinajele. ");
INSERT INTO tzotze_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iyal tal ta sba yac'ol li Ch'ul Espíritue. Oy sbec'tal xco'laj xchi'uc stsumut yilel. Li Diose ic'opoj tal ta vinajel, jech laj yal: ―Vo'ot Jnich'onot, lec c'uxot ta co'nton. Xcuxet no'ox co'nton avu'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","C'alal ilic abtejuc li Jesuse, yich'oj van lajuneb xcha'vinic (30) jabil. Chalic ti ja' xnich'on Josée pero ma'uc. Ja' smomnich'on li Elie. Yu'un li Maríae ja' stot li Elie. ");
INSERT INTO tzotze_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Li Elie ja' stot li Matate. Li Matate ja' stot li Levie. Li Levie ja' stot li Melquie. Li Melquie ja' stot li Janae. Li Janae ja' stot li Josée. ");
INSERT INTO tzotze_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Li Josée ja' stot li Matatíase. Li Matatíase ja' stot li Amose. Li Amose ja' stot li Naume. Li Naume ja' stot li Eslie. Li Eslie ja' stot li Nagaye. ");
INSERT INTO tzotze_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Li Nagaye ja' stot li Maate. Li Maate ja' stot li Matatíase. Li Matatíase ja' stot li Semeye. Li Semeye ja' stot li Josée. Li Josée ja' stot li Judae. ");
INSERT INTO tzotze_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Li Judae ja' stot li Joanae. Li Joanae ja' stot li Resae. Li Resae ja' stot li Zorobabele. Li Zorobabele ja' stot li Salatiele. Li Salatiele ja' stot li Nerie. ");
INSERT INTO tzotze_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Li Nerie ja' stot li Melquie. Li Melquie ja' stot li Adie. Li Adie ja' stot li Cosame. Li Cosame ja' stot li Elmodame. Li Elmodame ja' stot li Ere. ");
INSERT INTO tzotze_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Li Ere ja' stot li Josuée. Li Josuée ja' stot li Eliezere. Li Eliezere ja' stot li Jorime. Li Jorime ja' stot li Matate. ");
INSERT INTO tzotze_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Li Matate ja' stot li Levie. Li Levie ja' stot li Simeone. Li Simeone ja' stot li Judae. Li Judae ja' stot li Josée. Li Josée ja' stot li Jonane. Li Jonane ja' stot li Eliaquime. ");
INSERT INTO tzotze_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Li Eliaquime ja' stot li Meleae. Li Meleae ja' stot li Mainane. Li Mainane ja' stot li Matatae. Li Matatae ja' stot li Natane. ");
INSERT INTO tzotze_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Li Natane ja' stot li Davide. Li Davide ja' stot li Isaie. Li Isaie ja' stot li Obede. Li Obede ja' stot li Booze. Li Booze ja' stot li Salmone. Li Salmone ja' stot li Nasone. ");
INSERT INTO tzotze_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Li Nasone ja' stot li Aminadabe. Li Aminadabe ja' stot li Arame. Li Arame ja' stot li Esrome. Li Esrome ja' stot li Farese. Li Farese ja' stot li Judae. ");
INSERT INTO tzotze_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Li Judae ja' stot li Jacove. Li Jacove ja' stot li Isaaque. Li Isaaque ja' stot li Abraáme. Li Abraáme ja' stot li Taree. Li Tareeja' stot li Nacore. ");
INSERT INTO tzotze_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Li Nacore ja' stot li Serugue. Li Serugue ja' stot li Ragave. Li Ragave ja' stot li Pelegue. Li Peleque ja' stot li Ebere. Li Ebere ja' stot li Salae. ");
INSERT INTO tzotze_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Li Salae ja' stot li Cainane. Li Cainane ja' stot li Arfajade. Li Arfajade ja' stot li Seme. Li Seme ja' stot li Noée. Li Noée ja' stot li Lameque. ");
INSERT INTO tzotze_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Li Lameque ja' stot li Matusalene. Li Matusalene ja' stot li Enoque. Li Enoque ja' stot li Jarede. Li Jarede ja' stot li Malalele. Li Malalele ja' stot li Cainane. ");
INSERT INTO tzotze_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Li Cainane ja' stot li Enose. Li Enose ja' stot li Sete. Li Sete ja' stot li Adane. Li Adane ja' stot li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","C'alal la scomtsan uc'um Jordán li Jesuse, ventainbil xa yo'nton yu'un Ch'ul Espíritu. I'ic'at batel ta xocol banamil yu'un li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cha'vinic c'ac'al tey oy ta xocol banamil. Mu'yuc xve' o pero muc xvi'naj. Ts'acal to ivi'naj jech tey ital li banquilal pucuje yu'un tsc'an ta suj ta mulil li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jech i'albat yu'un li banquilal pucuje: ―Me vo'ot Xnich'onot Diose, albo li ton li'i ac'o c'atajuc ta vaj jech chata o vaj ave' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Itac'ov li Jesuse: ―Jech ts'ibabil ta sc'op Dios: “Muc ta vajuc no'ox chijcuxiutic o. Ja' tsc'an ta jch'untic noxtoc c'usitic chijyalbutic li Diose”, xi ts'ibabil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Li banquilal pucuje laj yic' batel ta jun toyol vits li Jesuse. Ta ora no'ox ta svu'el laj yac'be yil scotol li ajvaliletic li' ta banamile xchi'uc ti c'u x'elan tspasic mantale. ");
INSERT INTO tzotze_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jech laj yal li banquilal pucuje: ―Vo'ot chcac'bot aventain scotol li c'usitic chaq'uel batele jech cha'ich'at o ta muc' yu'un scotol cristianoetic. Yu'un vu'un ac'bil jventain scotol, jech xu' chcac'be ec li boch'o ta jc'an chcac'bee. ");
INSERT INTO tzotze_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Me chaquejan aba ta jtojole, chacac'bot scotol li c'usitic li' chaq'uele ―x'utat yu'un banquilal pucuj li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Itac'ov li Jesuse: ―Batan, Satanás, mu jch'un c'usi chavalbun. Yu'un jech ts'ibabil ta sc'op Dios: “Ja' no'ox xavich'ic ta muc' stuc li Cajvaltic Diose. Ja' no'ox xapasic li c'usi tsc'ane”, xi ts'ibabil ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Li banquilal pucuje laj yic' batel ta Jerusalén li Jesuse. Laj yic' batel ta jol templo, tey c'ot sva'an. Jech lic yal li banquilal pucuje: ―Me vo'ot Xnich'onot Diose, jipo aba yalel li'i. ");
INSERT INTO tzotze_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yu'un jech ts'ibabil ta sc'op Dios: Dios ta stacbot yalel tal yaj'almantaltac ja' ta xchabiot. ");
INSERT INTO tzotze_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ja' chastsacot ta sc'ob li j'almantaletique, chayic'ot batel yu'un jech mu xabosi avacan ta ton, xi ts'ibabil ―x'utat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Itac'ov li Jesuse: ―Pero jech ts'ibabil ta sc'op Dios noxtoc: “Mu me xaq'uelbeic yo'nton li Cajvaltic Diose”, xi ts'ibabil. Ja' yu'un me ta jip jba yalele, yu'un ta jq'uelbe yo'nton Dios me ta melel chiscoltaune ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","C'alal laj yil banquilal pucuj ti mu xch'un li Jesuse, jech ibat. Li banquilal pucuje ta smala me oy c'usi ora xu' ta suj ta mulil yan velta li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Li Jesuse isut batel ta Galilea. Scotol xu' yu'un ta spas ta sventa stsatsal li Ch'ul Espíritue. Ipuc sc'oplal ta scotol Galilea banamil ti puro lec c'usitic la spase xchi'uc c'usitic laj yale. ");
INSERT INTO tzotze_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tey ichanubtasvan ta nail tsobobbailetic yu'un li xchi'iltac ta israelale. Lec sc'oplal yu'un scotol li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Li Jesuse isut ta Nazaret, ja' ti bu ich'ie. C'alal ja' o sc'ac'alil ta xcux yo'ntonic li israeletique, tey ibat ta nail tsobobbail ec li Jesuse. Yu'un nopen xa'i ti tey ta xbatilan ta nail tsobobbail ti c'alal ja' o sc'ac'alil ta xcux yo'ntonique. Li Jesuse tey bat va'luc ta yut nail tsobobbail yu'un tsc'an ta xapta sc'op Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jech tey i'ac'bat li balbil vun ti ts'ibabil comel yu'un j'alc'op Isaías ta vo'onee. C'alal la xlich' li balbil vune, ja' la sta ti bu jech ts'ibabile: ");
INSERT INTO tzotze_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ja' sventainojun li Ch'ul Espíritu ti junic xchi'uc Diose. T'ujbilun yu'un Dios yu'un ta jcholbe ya'yic ti chc'uxubinatic yu'un Dios li me'onetique. Li boch'otic ta xat yo'ntonique tal calbe ya'yic ti vu'un ta jventa chmuq'uib yo'ntonique. Li boch'otic mozoinbilic yu'un mulile tal calbe ya'yic ti vu'un ta jventa chloq'uic ta mozoile. Li boch'otic ma'satetic ya'yel ta scoj smulique tal calbe ya'yic ti vu'un ta jventa chjam satique. Li boch'otic chopol ch‑ilatique tal calbe ya'yic ti vu'un ta jcoltae. ");
INSERT INTO tzotze_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","La stacun tal yu'un ja' ta jcholbe ya'yic ti ista xa yorail chcoltaatic yu'un Diose, xi ta xal ti bu laj yapta Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","C'alal la sq'uel sc'op Dios li Jesuse, la sbal li sc'op Diose, laj yac'be li boch'o ja' yabtel ta xchabie. Jech tey ichoti ta stojol scotolic. Scotol li boch'otic tey oyic ta yut nail tsobobbail ta Nazarete tey sq'uelojbeic sat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Li Jesuse jech laj yalbe ya'i scotolic: ―Li' ta orae ic'ot xa ta pasel li c'usi ts'ibabil ta sc'op Dios li' laj ava'yique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jech scotolic lec laj yalbeic sc'oplal li Jesuse. Tey ich'ay yo'ntonic ta sventa ti toj lec c'usi laj yale. Jech laj yalbe sbaic: ―Li'i xcotquintic. Ja' xnich'on li Josée ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Li Jesuse jech laj yal: ―Oy boch'o jech chalic: “Me melel ti vo'ot jpoxtavanejote, poxta aba atuc jech ta jch'uncutic ti ta melel vo'ot jpoxtavanejote”, xiic. Jech chac'an chavalbicun ya'yel yu'un chac'anic ta jpas li' ta jlumaltic li c'usi laj ava'yic la jpas tey ta lum Capernaume. Yu'un chanopic ti ja' to chach'unic ti vu'un ac'bilun cabtel me laj avilique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jech laj yalbe noxtoc: ―Melel li c'usi chacalboxuque, buyuc no'ox ta xbat li yaj'alc'op Diose ta x'ich'at ta muc'. Yan li xchi'iltac ta yosilale ja' mu x'ich'vanic ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Melel li c'usi chacalboxuque, c'alal li' to'ox oy ta banamil li j'alc'op Elíase, o'lol xchanibal jabil muc xac' vo' li' ta cosilaltic. Jech itsacatic ta vi'nal scotol cristianoetic. Li jchi'iltactic ta israelale oy ep me'on antsetic yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero li Elíase muc ja'uc tey ibat ta stojol li me'on antsetic yu'un jchi'iltactique. Ja' tey itacat batel ta sna jun me'on ants ti muc ja'uc jchi'iltic ta israelale. Ja' tey nacal ta lum Sarepta, ja' nopol xil sba xchi'uc li lum Sidone. ");
INSERT INTO tzotze_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jech noxtoc c'alal li' to'ox oy ta banamil li j'alc'op Eliséoe, ep jchi'iltactic tsacbilic ta c'a'el chamel. Pero me junuc muc xcoltaatic. Ja' no'ox icoltaat li Namane, pero ta Siria banamil to liquem tal ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","C'alal laj ya'ibeic sc'op Jesús li israeletic tey stsoboj sbaic ta nail tsobobbaile, chopol laj ya'yic, i'ilinic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Laj yiq'uic loq'uel ta ti'lum li Jesuse. Li lume tey meltsanbil ta xocon jol vits. Laj yiq'uic batel ta mero jol vits li Jesuse yu'un tsc'an tey ta sjipic yalel ta ch'entic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Li Jesuse tey ijelov batel ta o'lol cristianoetic, jech ibat o. ");
INSERT INTO tzotze_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Li Jesuse tey ibat ta lum Capernaum tey ta Galilea banamil. C'alal la sta sc'ac'alil ta xcux yo'ntonic li israeletique, li Jesuse tey i'ochic ta nail tsobobbail xchi'uc yajchanc'optac. Tey ichanubtasvan li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Li cristianoetique toj ch'ayel ic'ot yo'ntonic ta sventa c'usi laj yac' ta chanel li Jesuse. Yu'un jech ichanubtasvan jech chac c'u cha'al li boch'o lec sna' c'usi tsc'an Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tey oy ta yut nail tsobobbail jun israel vinic ochem pucujetic ta yo'nton. Tsots i'avan li vinique. ");
INSERT INTO tzotze_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Jech laj yal: ―¿C'u yu'un tal atic' aba ta jtojolcutic yu'un mu aventauncuticuc, vo'ot Jesusot ti liquemot tal ta Nazarete? ¿Me yu'un tal xa avac'uncutic batel yo' bu chquich'cutic castigoe? Xacotquinot boch'oot. Vo'ot Xnich'onot Dios, vo'ot ti mu'yuc amule ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Li Jesuse la spajes li pucujetic ti tey xch'amanojbeic ye li vinique, jech laj yalbe: ―Ch'anchanic, loc'anic batel ta yo'nton li vinique ―xut. Li pucujetique la sjipic ta lum li vinique jech iloq'uic ta yo'nton. Pero me jutuc muc xtuch' li vinique. ");
INSERT INTO tzotze_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Li cristianoetique toj ch'ayel ic'ot yo'nton scotolic, jech la sjac'be sbaic: ―¿Boch'o ti li' taleme? Oy ep stsatsal, xu' yu'un ta stac loq'uel li pucujetique. Ch'unbil smantal ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","C'alal jech la spas li Jesuse, ipuc batel sc'oplal ta scotol bic'tal lumetic ta nopol Capernaum. ");
INSERT INTO tzotze_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","C'alal iloc' ta nail tsobobbail li Jesuse, tey ibat ta sna Simón Pedro. Tey oy smeni' li Pedroe ip cha'i c'ac'ubel. Li Pedroe jech laj yalbe li Jesuse: ―Avocoluc coltabun li jmeni'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Li Jesuse inoch'aj batel yo' bu mochol li antse, laj yal ti ac'o ech'uc li sc'ac'ubele. Jech ta ora i'ech' li sc'ac'ubele. Ta ora ilic, tey lic mac'linvanuc. ");
INSERT INTO tzotze_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","C'alal ta xa xch'ay c'ac'ale, laj yiq'uic tal ta stojol Jesús scotol jchameletic, c'usiuc no'ox chamelal ip cha'yic. Li Jesuse laj yac' sc'ob ta sjolic jujun jech icol o scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Oy ep boch'otic iloc' pucuj ta yo'ntonic. Li pucujetique tsots i'avanic ti c'alal iloq'uique. Jech laj yalic: ―Vo'ot Xnich'onot Dios ―xiic. Li Jesuse laj yalbe pucujetic ti ac'o ch'aniicuque. Yu'un li pucujetique sna'ojic ti ja' t'ujbil yu'un Dios ta x'och ta ajvalilal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta yoc'omal c'alal isacub osile, iloc' batel li Jesuse, ibat yo' bu mu'yuc cristianoetique. C'alal iloc' batele, it'unat yu'un li cristianoetique. C'alal la staique, tsc'an ta spajesic yu'un ac'o pajuc tey ta slumalic. ");
INSERT INTO tzotze_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Li Jesuse jech laj yalbe: ―Ta persa ta xbat calbe ya'yic jchi'iltactic ta yantic lumetic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. Yu'un ja' sventa ti tacbilun tal li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Li Jesuse ibat ta nail tsobobbailetic yu'un xchi'iltac tey ta Galilea banamil. Bat yal ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Li Jesuse tey ic'ot ta ti' nab ta Galilea banamil. Genesaret sbi li nabe. Li cristianoetique la stsin sbaic tal yo' bu oy li Jesuse yu'un tsc'an ta xa'yic sc'op Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Li Jesuse laj yil tey oy chib tenalte' canova ta noch' ti' nab. Li yajvaltac chib canovae ja' jtsacchoyetic. Loq'uemic batel ta xchuq'uel snuti'ic. ");
INSERT INTO tzotze_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Li Jesuse i'och ta jun tenalte' canova, ja' scanova li Simón Pedroe. Laj yalbe Pedro ti ac'o xlechu jutuc ochel ta nab li scanovae. Li Jesuse tey ichoti ta yut canova ta ba nab, la xchanubtas scotol li cristianoetic tey stsoboj sbaic ta ti' nabe. ");
INSERT INTO tzotze_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","C'alal laj yo'nton ta xchanubtasel cristianoetic li Jesuse, jech laj yalbe li Pedroe: ―Lechuic batel li acanovae, batic yo' bu lec nat li nabe. Ja' tey xc'ot atiq'uic ochel anuti'ic yu'un ja' tey chataic ep choy ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Itac'ov li Pedroe: ―Jchanubtasvanej, sjunul ac'ubal la jsa'cutic li choye pero mu'yuc la jtacutic jcotuc. Pero ta sventa ti vo'ot chaval mantale, jech ta jtic'cutic ochel yan velta li jnuti'cutique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","C'alal la stic' ochel ta yut nab snuti'ique, bats'i ep i'och li choye. Jech lic tuch'anuc li snuti'ique yu'un toj ol. ");
INSERT INTO tzotze_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jech la svelc'obtaic tal li yan xchi'iltaquic tey tic'ajtic ta yan canovae yu'un ac'o tal coltaaticuc. Jech italic. Li chib canovae inoj ta choy. C'an ochuc yalel ta yut nab li canovaetique yu'un toj ol li choye. ");
INSERT INTO tzotze_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","C'alal laj yil Simón Pedro ti inoj ta choy xchibal li canovae, la squejan sba ta stojol li Jesuse. Jech laj yalbe: ―Cajval, mu xachi'inun yu'un li vu'une jpasmulilun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yu'un ti jech laj yale, yu'un toj xi'el no'ox ic'ot xchi'uc xchi'iltac ta sventa ti toj ep la staic li choye. ");
INSERT INTO tzotze_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ixi'ic ec li Jacobo xchi'uc Juane, ja' li xnich'nab Zebedeoe, ja' xchi'il sbaic ta abtel xchi'uc li Simone. Li Jesuse jech laj yalbe li Pedroe: ―Mu me xaxi'. Ta jelbot avabtel. Yu'un ta jchanubtasot c'u x'elan chbat asa'bun cristianoetic ―x'utat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","C'alal iloq'uic ta ti' nabe, iloq'uic ta canova. Jech la scomtsanic o li yabtelique. Ja' xa la xchi'inic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ta yan to c'ac'al c'alal tey oy ta yan lum li Jesuse, tey ital jun israel vinic tsacbil ta c'a'el chamel. C'alal laj yil tey oy li Jesuse, tal spatan sba ta stojol. Jech laj yalbe: ―Cajval, me chac'an chacoltaune, xu' avu'un chacoltaun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Li Jesuse laj yac' sc'ob ta sbec'tal li jchamele, jech laj yalbe: ―Lec oy, colan cha'e ―xut. Jech ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Li Jesuse laj yalbe mantal: ―Mu me boch'o xavalbe ya'i. Ja' no'ox bat ac' aba ta ilel ta stojol pale. Ac'bo smoton Dios jech chac c'u cha'al yaloj ono'ox Moisés ta vo'onee. Jech ta sna'ic o jchi'iltactic ti colemot xae ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jech ipuc o sc'oplal li Jesuse. Bats'i ep cristianoetic ta xtalilanic ta stojol li Jesuse yu'un tsc'an ta xa'ibeic sc'op, xchi'uc tsc'anic ti ac'o colicuque. ");
INSERT INTO tzotze_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Li Jesuse oy ibat ta xocol banamil yu'un bat sc'opan Dios stuc. ");
INSERT INTO tzotze_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ta yan to c'ac'al c'alal ja' o ta xchanubtasvan li Jesuse, tey chotajtic ec jayibuc israeletic xch'unojic fariseo, xchi'uc jayibuc jchanubtasvanejetic ta smantal Dios yalojic. Ja' tey liquemic tal ta jujun lum ta Galilea banamil xchi'uc ta Judea banamil. Oy tey liquemic tal ta lum Jerusalén. Li Jesuse i'ac'bat ep stsatsal yu'un Dios jech icol yu'un li jchameletique. ");
INSERT INTO tzotze_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tey italic ta stojol Jesús jayibuc israeletic xq'uechubte'ojic tal jun vinic aluben yacan. Tsc'an ch‑ochic ta yut na yo' bu oy li Jesuse yu'un chbat xpuch'anbeic ta stojol Jesús li jchamele. ");
INSERT INTO tzotze_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero muc x'ochic yu'un toj ep cristianoetic tey ochemic. Jech tey imuyic ta jolna yu'un lamal no'ox li jolnae. La svomic juteb li jolnae yu'un ja' tey la xchechic yalel xchi'uc svayab li jchamele. Jech tey ic'ot yu'unic yo' bu oy li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Li Jesuse laj yil ti xch'unojic ti xu' chcol li jchamele. Jech laj yalbe li jchamele: ―Tata, pasbilot xa perdón yu'un scotol amul ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li fariseoetique, jech la snop ta yo'ntonic: “Li vinic li'i ta scuy sba ta Dios. Pero mu'yuc boch'o yan xu' chispasbutic perdón yu'un jmultic, ja' no'ox Dios”, xi ta yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Li Jesuse la sna' li c'usi la snop ta yo'ntonique, jech laj yalbe: ―¿C'u yu'un ti mu'yuc lec c'usi chanop ta avo'ntonique? ");
INSERT INTO tzotze_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ta melel boch'ouc no'ox xu' ta xal ti “pasbilot xa perdón yu'un amul” xie yu'un mu vocoluc ta alel. Jech noxtoc mu vocoluc ta alel ti “lican, xanovan” xie. Pero ja' tsc'an chaq'uelic lec me ta melel ta xc'ot ta pasel yu'un li boch'o jech ta xale. ");
INSERT INTO tzotze_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vu'une laj xa cal ti pasbil xa perdón yu'un smul li vinique. Jech q'uelic me c'usi ta jpas li' ta orae yu'un jech chana'ic o ti vu'un no'ox ta jpasbe perdón yu'un smulic cristianoetic li' ta banamil, vu'un ti co'ol cristianoutique ―xut. Li Jesuse jech laj yalbe li jchamele: ―Vu'un chacalbot, lican, ich'o loq'uel avayab, batan ta ana ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta ora ilic li jchamele. Tey sq'ueloj scotolic ti laj yich' loq'uel svayabe, ibat ta sna. Laj yal batel slequilal Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","C'alal laj yilic jech la spas li Jesuse, toj labal sba laj yilic li israeletique. Tey laj yalic slequilal Dios. Ta sventa ti toj labal sba laj yilique, jech ep ixi'ic. Jech laj yalbe sbaic: ―Mu'yuc ono'ox bu jech xquiltic jech chac c'u cha'al laj quiltic li'i ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","C'alal la spas jech li Jesuse, iloc' batel. Tey laj yil jun jtsobpatan, Leví sbi. Tey chotol ta xchotleb yo' bu ta xac' spatan li cristianoetique. Li Jesuse jech laj yalbe: ―La' chi'inun batel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Li Levíe la scomtsan o li yabtele, ja' xa la xchi'in o batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ts'acal to laj yic' ta ve'el Jesús li Levíe yu'un chich' ta muc'. Xchi'uc laj yic' ep xchi'iltac noxtoc ti co'ol jtsobpatanetic xchi'uque. Xchi'uc oy yan boch'otic laj yic' noxtoc. Tey co'ol la xchi'inic ta chotlej ta ti' mesa li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li fariseoetique chopol laj yilic c'usi tspas xchi'uc yajchanc'optac li Jesuse. Jech laj yalbeic li yajchanc'optaque: ―¿C'u yu'un chachi'inic ta ve'el jtsobpatanetic xchi'uc yantic jpasmuliletic? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Itac'ov li Jesuse: ―Li boch'otic tsotsique mu sc'anic poxtael. Ja' no'ox ta sc'anic poxtael li boch'otic ipique. ");
INSERT INTO tzotze_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Li vu'une mu ja'uc tal quic' li boch'otic mu'yuc smul yalojique. Ja' tal quic' li jpasmuliletique yu'un jech ac'o scomtsan li smulique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oy boch'o jech la sjac'beic li Jesuse: ―Li yajchanc'optac Juane ep ta velta chictaic ixim yu'un ta sc'opanic Dios. Jech ta spasic ec li yajchanc'optac fariseoetique. ¿C'u yu'un mu jechuc ta spasic ec li avajchanc'optaque yu'un jujun c'ac'al ta xve'ic? ―xutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Li Jesuse jech laj yalbe: ―C'alal yorail nupinele, tey oy li malalile jech mu xu' ta xictaic ixim li yajtestigoe yu'un tey to xchi'uquic li malalile. ");
INSERT INTO tzotze_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ja' no'ox jech ec li cajchanc'optaque, mu jechuc smelol ti ta xictaic ixime, ti ta xat yo'ntonique, yu'un li' to jchi'inojic. Ja' to me la sta sc'ac'alil ta smilicun li cajcontrae, ja' to xu' chlic yat yo'ntonic, ja' to xu' ta xictaic ixim li cajchanc'optaque ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Li Jesuse jech laj yalbe jun lo'il: ―Li boch'o ta xch'un c'usi chcale persa ta scomtsan li c'usi xch'unoj ti snopoj jech chcol oe. Persa scotol yo'nton ta xch'un li c'usi ta xcale yu'un jech chcol o. Jech chac c'u cha'al mu'yuc boch'o ta xtuch' loq'uel jutebuc yach'el sc'u' yu'un ja' ta spac'an o li sc'a'c'u'e. Me oy boch'o jech ta spase, altic laj yixtan li yach'el sc'u'e. Yu'un li ach' poq'ue ta sli' li poco' c'u'ile yu'un mu co'oluc mutsem. ");
INSERT INTO tzotze_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jech noxtoc li ach' ya'lel ts'usub ti ta xa xpajube, mu'yuc boch'o ta xch'ol ta poco' yav pasbil ta nucul. Me oy boch'o jech ta spase, c'alal ta xvocan stuc li ya'lel ts'usube, ta xjat li yavile. Altic chmal o scotol li ya'lel ts'usube. Li yavile mu xa xtun o. ");
INSERT INTO tzotze_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Li ach' ya'lel ts'usub ti ta xa xpajube ja' tsc'an ta ach' yav ta xich' ch'olel. Jech lec ta xcom o xchi'uc yav li ya'lel ts'usub ti pajuben xae. ");
INSERT INTO tzotze_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Li boch'o yuch'oj xa li poco' ya'lel ts'usub ti pajuben xae mu sc'an xuch' li ach' ya'lel ts'usube. Jech chal: “Ja' toj lec li poco' ya'lel ts'usube”, xi ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ta sc'ac'alil ta xcux yo'ntonic li israeletique, tey ijelovic ta be ta trigoaltic xchi'uc yajchanc'optac li Jesuse. Li yajchanc'optaque la sc'asic jaylicuc trigo, la sju' xc'uxic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tey i'ilatic yu'un jayibuc fariseoetic. Jech laj yalic: ―¿C'u yu'un chapasic c'usi mu stac' jpastic ta sc'ac'alil ta jcux co'ntontique? ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Itac'ov li Jesuse: ―Aq'uelojic ta sc'op Dios c'usi la spas David ti c'alal ivi'najic xchi'uc xchi'iltac ta xanubale. ");
INSERT INTO tzotze_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tey ic'otic ta templo. Li Davide ja' la stam sve' li pan tey oy ta ba mesa ta stojol Diose. Ac'o me yaloj Dios ti ja' no'ox xu' ta sve'ic li paleetique, pero la sve'ic xchi'uc xchi'iltac li Davide. Pero mu'yuc la sta smul ti jech la spase ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jech laj yal noxtoc li Jesuse: ―Vu'un ti co'ol cristianoutique, vu'un yajvalun li sc'ac'alil ta jcux co'ntontique. Vu'un chcal li c'usitic stac' pasele ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta yan to c'ac'al c'alal ja' o sc'ac'alil ta xcux yo'ntonic li israeletique, li Jesuse tey i'och ta nail tsobobbail yu'unic. Tey ichanubtasvan. Tey oy jun vinic xmoch'oj sba sbic'tal sbats'ic'ob. ");
INSERT INTO tzotze_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tey oyic ec jayibuc jchanubtasvanejetic ta smantal Dios yalojic xchi'uc jayibuc fariseoetic. Tey tsq'uelic me ta xcoltavan Jesús ta sc'ac'alil ta xcux yo'ntonic yu'un tsc'an ta sa'beic smul. ");
INSERT INTO tzotze_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Li Jesuse la sna' li c'usi ta snop ta yo'ntonique, jech laj yalbe li vinic ti xmoch'oj sba sbic'tal sbats'ic'obe: ―La' va'lan li' ta o'lole ―xut. Li vinique tey bat va'luc ta o'lol. ");
INSERT INTO tzotze_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Li Jesuse jech laj yalbe li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li fariseoetique: ―Oy c'usi chajac'boxuc. Ta sc'ac'alil ta jcux co'ntontique, ¿c'usi yaloj Dios tsc'an ta jpastic? ¿Me xu' ta jpastic c'usi lec, o me xu' ta jpastic c'usi chopol? ¿Me xu' chijcoltavan, o me xu' chijmilvan? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Li Jesuse la sq'uelbe sat li boch'otic tey chotajtique. Jech laj yalbe li jchamele: ―Va'ano lec li sbic'tal ac'obe ―xut. La sva'an lec li sbic'tal sbats'ic'obe, jech ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Li jchanubtasvanejetic xchi'uc fariseoetique ta ora isoc sjolic, i'ilinic. La snopic c'usi ta spasbeic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","C'alal jech ic'ot ta pasele, ja' o yorail bat sc'opan Dios ta vits li Jesuse. Sbejel ac'ubal tey la sc'opan Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","C'alal isacub osile, laj yic' scotol li boch'otic la xchi'in scotol c'ac'ale. Tey lic st'uj lajchab yajchanc'op yu'un ja' ta sventainic comel xcholel li sc'ope. Ja' jcholc'opetic ic'ot sbiic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja' la st'uj Simón, ja' Pedro laj yac'be xchibal sbi. Xchi'uc Andrés, ja' yits'in li Pedroe. Xchi'uc Jacobo, xchi'uc Juan, xchi'uc Felipe, xchi'uc Bartolomé. ");
INSERT INTO tzotze_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xchi'uc Mateo, xchi'uc Tomás, xchi'uc yan Jacobo, ja' xnich'on Alfeo. Xchi'uc yan Simón, ja' ti xchi'inoj to'ox zeloteetique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xchi'uc Judas, ja' xchi'il sbaic ta voq'uel xchi'uc li Jacoboe. Xchi'uc Judas Iscariote, ja' ti ts'acal to lic yac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","C'alal iyal tal ta yoc vits xchi'uc yajchanc'optac li Jesuse, xchi'uc ti jayib la xchi'inic c'alal i'ay ta vitse, tey c'ot sva'an sbaic ta stenlejaltic xchi'uc li yajchanc'optaque. Tey oy ep cristianoetic c'ot staic. Ja' liquemic tal ta Judea banamil xchi'uc ta lum Jerusalén, xchi'uc ta chib lum Tiro xchi'uc Sidón, ja' tey oy ta nopol ti' nab. Yu'un tal ya'ibeic sc'op li Jesuse xchi'uc tsc'anic ti ac'o coltaaticuc ta xchamelique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Italic ec li boch'otic ochem pucujetic ta yo'ntonique. Scotol icol yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Scotol cristianoetic tsc'an ta spiquic li Jesuse yu'un laj yilic ti ta stsatsal no'ox icol yu'un scotol li jchameletique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Li Jesuse la sq'uelbe sat li yajchanc'optaque xchi'uc li cristianoetic tey tsobolique, jech laj yalbe: ―Vo'oxuc ti mu'yuc c'usi oy avu'unique chata xcuxetel avo'ntonic yu'un ja' chasventainoxuc li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Vo'oxuc ti chavi'najic li' ta orae chata xcuxetel avo'ntonic yu'un cha'ac'bat ave'elic yu'un li Diose. ’Vo'oxuc ti cha'oq'uic li' ta orae chata xcuxetel avo'ntonic yu'un ja' chaspatboxuc avo'ntonic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Vo'oxuc ti chopol chayiloxuc li cristianoetique, ti mu sc'anic chi'inel avu'unique, ti chayutoxuque, ti chaslabanoxuque, ja' vu'un ta jventa, vu'un ti co'ol cristianoutique, pero chata xcuxetel avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","C'alal jech ta xc'ot ta pasele, mu me xavat avo'ntonic. Cuxetuc no'ox avo'ntonic yu'un cha'ac'bat ep amotonic tey ta vinajel. Yu'un jech ono'ox la spasic ec li smoltotic ta vo'onee, ep laj yuts'intaic li j'alc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Yan vo'oxuc ti jc'ulejoxuque ta to xavich'ic vocol ta yan c'ac'al. Yu'un oy avu'unic li c'usitic tsc'an avo'ntonic li' ta orae, jech mu'yuc xa c'usi yan chac'anic o. ");
INSERT INTO tzotze_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Vo'oxuc ti noj ach'utic li' ta orae ta to xavich'ic vocol yu'un mu'yuc c'usi cha'ac'batic yu'un li Diose. ’Vo'oxuc ti xcuxet ac'al no'ox avo'ntonic li' ta orae ta to xavich'ic vocol yu'un ta to xavat avo'ntonic ta yan c'ac'al, ta to xa'oq'uic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Vo'oxuc ti lec chayiloxuc scotol cristianoetic li' ta orae ta to xavich'ic vocol. Yu'un ja' jechoxuc jech chac c'u cha'al jlo'lavanej j'alc'opetic ta vo'one ti lec i'ilatic yu'un scotol cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Vo'oxuc ti chava'ibicun jc'op li' ta orae, jech chacalboxuc. C'uxubino avajcontraic. Me chayilintaoxuque, ac'bo yil slequil avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Me chopol chasc'opanoxuque, lec me xac'opanic. Me chayuts'intaoxuque, c'opanbeic Dios ta stojol. ");
INSERT INTO tzotze_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Me ta smajboxuc jot xocon asatic yu'un tsnop ti oy amulic ta stojole, ac'o smaj xcha'jotal. Me ta spojboxuc alapbolal xaquitaic yu'un tsnop ti oy amulic ta stojole, ac'o yich'. Ac'o yich' batel ac'u'ic noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Me oy c'usi chasc'anboxuc yu'un tsnop ti oy amulic ta stojole, ac'beic batel. Me ta spojboxuc c'usitic oy avu'unic yu'un tsnop ti oy amulic ta stojole, mu me xbat ac'anbeic sutel tal. ");
INSERT INTO tzotze_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Me chac'an ti lec c'usi chaspasboxuc li cristianoetique, ja' tsc'an ec ti lec c'usi chapasbeique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Me ja' no'ox chac'uxubinic li boch'o chaxc'uxubinoxuque, mu lecuc li c'usi chapasique. Co'ol chapas achi'uquic li boch'otic chopol c'usitic tspasique. Yu'un li stuquique ja' no'ox ta xc'uxubinic li boch'otic ta xc'uxubinatique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Me ja' no'ox lec c'usi chapasbeic li boch'otic lec c'usi chaspasboxuque, mu lecuc. Yu'un co'ol chapas achi'uquic li boch'otic chopol c'usitic ta spasique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Me ja' no'ox chavac'be xq'uex ataq'uinic li boch'o sna' sutesele, mu lecuc li c'usi chapasique. Co'ol chapasic jech chac c'u cha'al li boch'otic chopol c'usitic ta spasique. Yu'un ja' no'ox ta xac'be xq'uex staq'uinic li boch'o sna' sutesele. ");
INSERT INTO tzotze_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Li vo'oxuque tsc'an chac'uxubin li avajcontraique. Tsc'an lec chapasbeic scotol cristianoetic. Ac'o ta q'uexel ataq'uinic ac'o me mu sut yu'un. Jech cha'ac'bat ep amotonic tey ta vinajel. Jech chavaq'uic o ta ilel ti vo'oxuc xnich'naboxuc Diose. Yu'un li Diose chc'uxubin ec li boch'otic chopol yo'ntonique ti mu sna' stojic ta vocol ti chc'uxubinatique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ja' lec c'uxubinvananic jech chac c'u cha'al ta xc'uxubinvan li Jtotic tey oy ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Mu me chopoluc xavil achi'ilic yu'un jech mu xc'ot avich'ic chapanel yu'un Dios. Mu me xatic'beic smul achi'ilic, jech mu xa'albat amulic ec yu'un li Diose. Pasbeic perdón jech chaspasboxuc perdón ec li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ac'beic smoton achi'ilic jech chayac'boxuc amotonic ec li Diose. Más to ep cha'ac'batic li vo'oxuque. Ja' jech chac c'u cha'al li boch'o lec ts'acal ta xac' c'usi ta xaq'ue, lec ta snojes, ta xa xtanij loq'uel ta sti', ja' to jech x'elan chavich'ic ec li vo'oxuque. Me ep chavaq'uique, jech ep cha'ac'batic ec. Me jutuc no'ox chavaq'uique, jech jutuc no'ox chayac'boxuc ec li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Li Jesuse oy c'usi la sloc'ta ta lo'il, jech laj yal: ―Li boch'o ma'sate ¿me xu' ta xac'be yil be ec li yan ma'sate? ¿Me mu co'oluc ta x'ochic yalel ta vomlum xchibalic? ");
INSERT INTO tzotze_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Li boch'o ta xich' chanubtasele mu ja'uc tsots yabtel yich'oj. Ja' tsots yabtel yich'oj li boch'o ta xchanubtasvane. Me la xchan lec scotol li boch'o ta xich' chanubtasele, co'ol xa ta xc'ot xchi'uc li jchanubtasvanej yu'une. Jech li vo'oxuque tsc'an chat'ujic lec li boch'o chaxchanubtasoxuque. ");
INSERT INTO tzotze_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Li vo'oxuque chavilic ti oy juteb sc'a'epal sat achi'ilique, pero mu xavil aba atuquic ti vo'oxuc más muc' ochem sc'a'epal asatique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jech chavalbe li achi'ilique: “La' jloq'uestic li sc'a'epal asate”, xavutic. Pero ¿c'uxi xu' avu'un chaloq'uesbeic li juteb c'a'ep ochem ta sat achi'ilique yu'un vo'oxuc más muc' ochem sc'a'epal asatic? Jech jlo'lavanejoxuc chac'otic. Ja' tsc'an vo'oxuc ba'yuc chaloq'ues li sc'a'epal asatique, ts'acal to xu' chaloq'uesbeic ec li juteb c'a'ep ochem ta sat achi'ilique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Me lec sts'unubal li te'e, lec sat chac'. Me chopol sts'unubal li te'e, chopol sat chac'. Mu stac' tscap sba ti bu leque xchi'uc ti bu chopole. ");
INSERT INTO tzotze_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta sventa c'u x'elan sat li te'e jech ta jna'tic o me lec, me chopol. Jech chac c'u cha'al mu'yuc bu chataic sat igo ta te'el ch'ix, mu'yuc bu chataic ts'usub ta ch'ixte', ja' jech mu'yuc c'usi lec chataic yu'un li jlo'lavanej j'alc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Li boch'o lec yo'ntone lec c'usi chloc' ta ye yu'un jech snopoj ta yo'nton. Yan li boch'o chopol yo'ntone chopol c'usi chloc' ta ye yu'un jech snopoj ta yo'nton. Yu'un li c'usitic ta jnop ta co'ntontique ja' jech chloc' ta quetic. ");
INSERT INTO tzotze_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Li vo'oxuque altic ti “Cajval, Cajval” xavuticune, mu xac'an xapasic li c'usitic chacalboxuque. ");
INSERT INTO tzotze_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Li boch'o chiya'ibun c'usi ta xcale, me ta xch'une, chacalboxuc c'u x'elan. ");
INSERT INTO tzotze_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ja' jech chac c'u cha'al jun vinic la spas sna ta ba ton. Ba'yuc nat la sjem yalel li banamile, ja' to laj yo'nton c'alal la sta li tone. Ja' tey la sliquesbe tal li snaclebe. C'alal tsots laj yac' vo'e, inoj ta jyalel li uc'ume, tsots ic'ot ta spat xocon sna li vo'e. Pero muc xlom li snae yu'un ta ba ton spasoj. ");
INSERT INTO tzotze_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Li boch'o chiya'ibun c'usi ta xcale, me mu xch'une, ja' jech chac c'u cha'al jun vinic la spas sna ta bats'i banamil, mu'yuc laj yac'be snacleb. C'alal tsots laj yac' vo'e, inoj ta jyalel li uc'ume, tsots ic'ot ta spat xocon sna li vo'e. Pero toj lomel no'ox ic'ot o ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","C'alal ilaj yo'nton ta sc'opanel cristianoetic tey ta yoc vits li Jesuse, ibat ta lum Capernaum. ");
INSERT INTO tzotze_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oy jun yan lum vinic ja' capitán soldado tey nacal ta Capernaum. Ja' liquem tal ta lum Roma. Oy jun smozo lec c'ux ta yo'nton. Itsacat ta chamel li smozoe, ta xa xcham. ");
INSERT INTO tzotze_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","C'alal laj ya'ibe sc'oplal Jesús li capitán soldadoe, la stac batel jayibuc banquilaletic yu'un israeletic tey ta Capernaum yu'un ac'o bat sjac'beic Jesús me ch‑abulaj chbat coltabatuc li smozoe. ");
INSERT INTO tzotze_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Li banquilaletique ibatic yo' bu oy li Jesuse, jech c'ot yalbeic: ―Ja' lec me chac'uxubin li capitán soldadoe. ");
INSERT INTO tzotze_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yu'un lec c'uxutic ta yo'nton jcotoltic, vu'utic li israelutique. Laj yac' staq'uin ti c'alal la jpascutic nail tsobobbail cu'uncutic li' ta lume ―xutic c'otel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Li Jesuse la xchi'in batel li banquilaletique. C'alal jutuc xa sc'an xc'otic ta sna li capitán soldadoe, li capitán soldadoe la stac tal ta ora jayibuc li boch'otic lec sc'opan sba xchi'uque yu'un tal spajesic li Jesuse. Jech laj yalbeic: ―Tata, mu la xbat avac' avocol yu'un jech laj yalbun tal li capitán soldadoe: “Vu'une mu'yuc tsots cabtel ti ja' la xch'unbun tal jmantal chtal ta jnae. ");
INSERT INTO tzotze_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ja' yu'un muc x'ay jc'opan jtuc. Xu' ja' no'ox ac'o yal tal ti ac'o coluc li jmozoe. ");
INSERT INTO tzotze_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Li vu'une pasbilun no'ox ta mantal ti ta jpas ta mantal soldadoetique. Batan, me xcut li june, ta xbat cu'un. La', me xcut li yane, ta xtal cu'un. Paso jech, me xcut li jmozoe, ta spas cu'un”, xiyutuncutic tal ―xutic c'otel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","C'alal laj ya'i li Jesuse, xcuxet ic'ot yo'nton. Ijoyij, jech laj yalbe li cristianoetic tey nabalic tal ta spate: ―Ta melel mu'yuc to bu jtaoj junuc jchi'iltic ta israelal jech xch'unoj jech chac c'u cha'al xch'unoj li capitán soldadoe ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Li boch'otic itacatic tal yu'un capitán soldadoe isutic batel. C'alal ic'otique, colem xa c'ot staic li smozo capitán soldadoe. ");
INSERT INTO tzotze_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Li Jesuse ts'acal to ibat xchi'uc yajchanc'optac ta lum Naín. Xchi'uc oy ep israeletic ibatic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","C'alal ic'otic ta ti' corral ton yu'un lume, laj yil Jesús ti oy boch'otic xq'uechojic tal jun ánima yu'un xa chbat smuquic. Ja' squerem jun me'on ants. C'ajumal jun li yole. Ep boch'otic xchi'inoj batel li antse, ja' li boch'otic tey nacajtic ta lume. ");
INSERT INTO tzotze_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","C'alal laj yil ants li Cajvaltique, abul sba laj yil. Jech laj yalbe: ―Mu xa'oc' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inoch'aj batel li Jesuse. La spicbe stenalte'il li ánimae. Li boch'otic xq'uechojic batele iva'iic. Li Jesuse jech laj yalbe li ánimae: ―Querem, vu'un chacalbot, lican ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jech ta ora ichoti li quereme, lic lo'ilajuc. Li Jesuse jech laj yalbe li antse: ―Ic'o batel li avole ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Scotol li boch'otic tey laj yilique toj xi'el ic'ot scotolic. Laj yalbeic slequilal Dios. Oy jech laj yalic: ―Toj tsots yabtel yich'oj li jchi'iltique. Ja' banquilal yaj'alc'op Dios talem ta jtojoltic ―xiic. Oy yantic jech laj yalic: ―Ja' tacbil tal yu'un Dios chiscoltautic, vu'utic ti t'ujbilutic ono'ox yu'une ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Li Jesuse ipuc batel sc'oplal ta scotol Judea banamil xchi'uc ta yantic banamil ti sts'aquinoj sbaic xchi'uc Judeae. ");
INSERT INTO tzotze_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Li Juan j'ac'vanej ta vo'e i'albat yu'un yajchanc'optac c'usitic tspas li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","C'alal laj ya'i li Juane, laj yic' tal chib yajchanc'op. Jech laj yalbe: ―Bat jac'beic Jesús me ta melel ja' t'ujbil yu'un Dios chisventainutic ti sc'oplal ono'ox chtale, o me ta to jmalatic yan ―xut batel. ");
INSERT INTO tzotze_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","C'alal ic'otic bu oy li Jesuse, jech laj yalbeic: ―La stacuncutic tal li Juan j'ac'vanej ta vo'e yu'un ta jac'botcutic me vo'ot t'ujbilot yu'un Dios chaventainuncutic ti sc'oplal ono'ox chatale, o me ta to jmalacutic yan ―xutic c'otel. ");
INSERT INTO tzotze_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Li Jesuse ja' o tscolta ep jchameletic ti c'alal ic'otique. Tscolta li boch'otic ch'iem chin ta sbec'talique, tsloq'uesbe pucujetic ta yo'ntonic li boch'otic ochem pucuj ta yo'ntonique, tsjambe sat li boch'otic ma'satetique. ");
INSERT INTO tzotze_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Itac'ov li Jesuse: ―Bat albeic Juan scotol li c'usitic laj avilic la jpase xchi'uc li c'usitic laj ava'yic laj cale. “Li ma'satetic ono'oxe ta xilic xa osil. Li coxoetic ono'oxe ta xanovic xa. Icolic xa li boch'otic tsacbil to'ox ta c'a'el chamele. Ijam xa xchiquinic li boch'otic macal ono'ox xchiquinique. Li boch'otic chamenique icha'cuxiic xa. Li me'onetique icholbat xa ya'yic ti chc'uxubinatic yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Me mu xchibaj yo'nton ta jtojol li Juane, xcuxet no'ox yo'nton, xiyutuncutic tal li Jesuse”, utic c'otel li Juane ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","C'alal isutic batel li viniquetic ti itacatic tal yu'un Juan j'ac'vanej ta vo'e, li Jesuse lic yalbe epal cristianoetic c'u x'elan sc'oplal li Juane: ―Li boch'o ay aq'uelic tey ta xocol banamile, laj ana'ic ti mu ja'uc li boch'o chib c'usi ta spas jech chac c'u cha'al jtec' aj ti xne'et no'o x ta iq'ue. ");
INSERT INTO tzotze_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Laj avilic ti mu'yuc lec sc'u' slapoje. Yu'un li boch'otic toj lec sc'u' slapojique ja' li boch'otic tey oyic ta sna ajvaliletique. ");
INSERT INTO tzotze_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","C'alal ay aq'uelique, laj ana'ic ti ja' yaj'alc'op Diose. Chacalboxuc ava'yic, li Juane ja' más banquilal yu'un li yantic yaj'alc'optac Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ja' Juan ti ts'ibabil ono'ox sc'oplal ti ba'yuc ta xtal cu'une. Jech ts'ibabil: Ba'yuc ta xjelov avu'un li j'alc'op ta jtac batele. Ja' ta xalbe cristianoetic ti chabate yu'un jech xu' chayich'icot ta muc', xiyutun li Jtote, xi ono'ox ts'ibabil sc'oplal li Juane. ");
INSERT INTO tzotze_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chacalboxuc ava'yic, scotol li cristianoetique mu'yuc boch'o jech tsots yabtel yich'oj jech chac c'u cha'al tsots yabtel laj yich' li Juan j'ac'vanej ta vo'e. Pero li boch'o chac' sba ta ventainel yu'un Diose, ac'o me mu'yuc yabtel, ja' más chil c'u x'elan ch‑abtej stsatsal Dios. Li Juane ja' jutuc no'ox laj yil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","C'alal laj ya'yic c'usi laj yal Jesús li cristianoetique xchi'uc li jtsobpatanetic ti yich'ojic xa vo' yu'un Juane, jech laj yalic: ―Ta melel lec c'usi chal li Diose ti tsc'an ac'o jcomtsantic c'usitic chopol ta jpastique, ti ac'o quich'tic vo'e yu'un jech chispasbutic perdón ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yan li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li fariseoetic ti mu'yuc yich'ojic vo' yu'un Juane, mu'yuc tsots sc'oplal laj ya'yic ti jech tsc'an Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jech laj yal noxtoc li Jesuse: ―Chacalboxuc ava'yic c'u x'elan atalelic ti li' oyoxuc ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ja' jechoxuc jech chac c'u cha'al ololetic ti tey chotol chtajinic ta ch'ivite, jech chalbe li xchi'ilique: “La jupancutic ama sventa nupinel pero muc xa'ac'otajic. C'alal li'oc'cutic ta scoj ti oy boch'o icham cu'uncutique, muc xavat avo'ntonic noxtoc. Mu c'usi xac'anic o”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yu'un c'alal ital li Juan j'ac'vanej ta vo'e, muc xaxchi'inoxuc ta ve'el. Jech laj avalic: “Ochem pucuj ta yo'nton”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","C'alal lital, vu'un ti co'ol cristianoutique, la jchi'inoxuc ta ve'el. Pero jech laj avalic noxtoc: “Q'uelavil toj ech'em xve', toj ech'em xuch' ya'lel ts'usub. Lec ta xil sbaic noxtoc xchi'uc jtsobpatanetic xchi'uc yan jpasmuliletic”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ti ja'uc laj yac'boxuc abijilic li Diose, laj avich'uncutic ta muc' xchi'uc Juan ti jechuque. Jech laj ana'ic ti ja' ta sbijil Dios la jpascutic li c'usitic la jpascutique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Li Jesuse i'ic'at ta ve'el yu'un jun vinic xch'unoj fariseo. Li xchotlebique xco'laj xchi'uc vaybal yilel. Ja' tey ta sts'e'an sbaic ti c'alal ta xve'ic ta mesae. Li Jesuse tey bat sts'e'an sba. ");
INSERT INTO tzotze_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Oy jun jmulavil ants tey ta lum laj ya'i ti tey ta xve' ta sna fariseo li Jesuse, jech tey ibat. Laj yich' batel jun limita ton nojem ta muil poxil. ");
INSERT INTO tzotze_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Li antse tey c'ot va'luc ta nopol yacan Jesús. Tey lic oc'uc. Lic spocbe yacan ta ya'lel sat. C'alal la spoque, la scusbe ta stsotsil sjol. Lic sts'uts'be. La smalbe ta yacan li sbel limita tone yu'un chich' ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","C'alal laj yil li fariseoe, ja' li boch'o laj yic' ta ve'el Jesuse, jech laj yal ta yo'nton: “Ti ja'uc yaj'alc'op Dios ta melel li vinic li'i, ta sna' ti ja' jmulavil li antse”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Li Jesuse jech laj yalbe li fariseoe: ―Simón, oy c'usi ta jc'an chacalbot ―xut. Itac'ov li Simone: ―Lec oy, albun, Jchanubtasvanej ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Li Jesuse jech laj yal: ―Oy jun vinic iq'uexbat staq'uin yu'un chib viniquetic. Li june vo'ob ciento la xq'uex. Li yane lajuneb yoxvinic la xq'uex. ");
INSERT INTO tzotze_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero mu sut yu'un li xq'uexique jech li yajval taq'uine la xch'aybe yil xchibalic. Li vo'ote ¿c'usi chanop? Li chib vinic ich'aybat yilique ¿me co'ol lec chilic li yajval taq'uine, o me oy boch'o más lec chil? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Itac'ov li Simone: ―Ja' van más lec chil li boch'o ep yil ich'aybate ―xi. Jech i'albat yu'un li Jesuse: ―Ja' melel li c'usi chavale ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ijoyij li Jesuse, la sq'uel li antse, jech laj yalbe li Simone: ―Q'uelavil li ants li'i. C'alal li'och ta anae, mu'yuc boch'o la spocbun cacan. Li ants li'i la spocbun cacan ta ya'lel sat. La scusbun ta stsotsil sjol noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Li vo'ote muc xats'uts'un ti c'alal livule. Li ants li'i vul sts'uts'ilanbun cacan ti c'alal ivule. Chavil ti yoquel to jech ta spase. ");
INSERT INTO tzotze_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Li vo'ote muc xamalbun aceite ta jol. Li ants li'i la smalbun muil poxil ta cacan. ");
INSERT INTO tzotze_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chacalbot, ac'o me ep smul li antse, li' ta orae pasbil xa perdón yu'un smul yu'un lec sc'anojun. Li boch'o tsnop ti mu'yuc ep smul la jpasbe perdone, ja' jutuc no'ox chisc'anun ―x'utat yu'un Jesús li Simone. ");
INSERT INTO tzotze_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Li Jesuse jech laj yalbe li antse: ―Pasbilot xa perdón yu'un scotol amul ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Li boch'otic tey co'ol oyic ta mesa xchi'uc li Jesuse jech laj yalbe sbaic: ―¿Bu xa loc' tal li vinic ti c'alal ta smul cristianoetic xu' yu'un tspasbe perdón scuyoj sbae? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Li Jesuse jech laj yalbe li antse: ―Lapasbat xa perdón yu'un amul yu'un scotol avo'nton laj ach'un ti vu'un Jcoltavanejune. Jech junuc xa avo'nton batan ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ts'acal to ixanov batel ta scotol lumetic xchi'uc ta tsobtsobnaetic li Jesuse. La xchol batel li lequil a'yeje, ja' ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. Tey xchi'inoj batel xlajchabal li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Oy jayibuc antsetic noxtoc la xchi'inic li Jesuse yu'un oy iloq'uesbat pucuj ta yo'ntonic yu'un li Jesuse, xchi'uc oy icoltaatic ta chamel. Tey xchi'uquic jun ants, María sbi, ja' tey liquem tal ta lum Magdala. Ja' ti iloq'uesbat vucub pucuj ta yo'nton yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tey oy ec li Juanae, ja' yajnil jun vinic Chuza sbi. Li Chuzae ja' yich'oj yabtel tey ta sna li ajvalil Erodese. Tey oy ec li Susanae xchi'uc oy ep yan antsetic la smac'linic Jesús xchi'uc yajchanc'optac. Pero stuquic la sloq'uesic ve'lil li antsetique. ");
INSERT INTO tzotze_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","C'alal la stsob sbaic ta stojol Jesús ep israeletic liquemic tal ta ep lumetique, li Jesuse oy c'usi la sloc'tabe ta lo'il. Jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Oy iloc' batel jts'untrigo. C'alal la svij li strigoe, oy jaybej ic'ot ta be. Tey la spech'ilanic ta teq'uel li cristianoetique. Ts'acal to ital mutetic, la sbiq'uic batel. ");
INSERT INTO tzotze_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oy jaybej ic'ot ta tontic. C'alal ich'i jutuque, ta ora itaquij yu'un taquin li banamil ta ba tontique. ");
INSERT INTO tzotze_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oy jaybej ic'ot ta ch'ixtic. C'alal ich'i li ch'ixe, inet'at jech tey ic'oxib o. ");
INSERT INTO tzotze_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oy jaybej ic'ot ta lequil banamil. Lec ich'i. Lec laj yac' sat. Laj yac' vo'vinic (100) ta bej li jujubej bec' trigoe ―xi. C'alal laj yal jech li Jesuse, tsots lic c'opojuc. Jech laj yal: ―Boch'o laj ya'i ac'o snopbe lec smelol ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Li Jesuse jech ijac'bat yu'un yajchanc'optac: ―¿C'usi smelol li lo'il laj avalbuncutique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Li Jesuse jech laj yalbe: ―Li vo'oxuque ac'biloxuc ana'ic c'u x'elan tsventainanbe yo'nton cristianoetic li Diose, pero li yantique ja' no'ox ta jloc'tabe ta lo'il. Yu'un altic ti ep ta velta laj yilic ti scotol xu' cu'une, mu sc'an xch'unic. Altic ti ep ta velta laj ya'yic c'usi laj cale, mu xa'ibeic smelol yu'un mu ono'ox sc'an xa'yic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’A'ibeic me smelol li lo'il laj calboxuque. Li sat trigoe ja' senyail li sc'op Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Li bec' trigo ic'ot ta bee, ja' senyail li boch'otic ta xa'yic sc'op Diose. C'alal cha'yique, mu'yuc tsots sc'oplal ta yo'ntonic. Ta ora chtal li pucuje, chtal xch'aybe ta yo'ntonic li sc'op Dios laj ya'yique yu'un jech mu me xch'unic, jech mu xcolic o. ");
INSERT INTO tzotze_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Li bec' trigo ic'ot ta tontique, ja' senyail li boch'otic ja' to no'ox laj ya'yic sc'op Diose. Ta ora no'ox la xch'unic jech xcuxet no'ox yo'ntonic. Pero muc xac' yisim ta yo'ntonic ya'yel yu'un mu'yuc stsatsal yo'ntonic. C'alal ta xich'ic vocol ta sventa ti cha'yic sc'op Diose, toj chibajel chc'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Li bec' trigo ic'ot ta ch'ixtique, ja' senyail li boch'otic ja' no'ox batem yo'ntonic yu'un li c'usitic oy li' ta banamile. Ja' tey lo'labilic yu'un li c'usi tsc'an yo'ntonique. Jech tey net'bil ic'ot o li sc'op Dios ya'yojique. Jech mu xch'unic o. ");
INSERT INTO tzotze_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Li bec' trigo ic'ot ta lequil banamile, ja' senyail li boch'otic chc'ot lec ta yo'ntonic li sc'op Diose, ti scotol yo'ntonic ta xch'unique. Jech ta xac' satinuc ta yo'ntonic li sc'op Diose manchuc me chich'ic vocol. ");
INSERT INTO tzotze_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Me ta jtsantic candile, mu'yuc ta jmactic, mu'yuc ta jnac'tic ta yolon vaybal noxtoc. Ja' ta xcac'tic ta xvuchanubil jech lec sacjaman chilic scotol li boch'otic ta x'ochic tal ta yut jnatique. ");
INSERT INTO tzotze_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ja' no'ox jech persa ono'ox ta xvinaj li c'usitic calojboxuque. Jech ja' avabtelic ti jamal chavalic batele. ");
INSERT INTO tzotze_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Jech a'ibeic lec smelol li c'usitic chacalboxuque. Li boch'otic jutuc to xch'unojique, li Diose más to ech'em chac'be xch'un yu'un tsc'an ta xch'unic. Yan li boch'otic mu sc'an xch'unique, li c'u yepal sna'ic jutuque ta xpojbatic sutel ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Li Jesuse tey ital sme' xchi'uc yits'inabtac. Pero muc staic ta c'opanel li Jesuse yu'un tey tsinil ep cristiano ta yut na, jech mu xu' ta x'ochic batel yo' bu oy li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oy boch'o jech tal yalbe li Jesuse: ―Tey oyic ta amac' ame' xchi'uc avits'inabtac yu'un tsc'an ta sc'opanicot ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Itac'ov li Jesuse: ―Ta melel ja' jme', ja' quits'inabtac ti tey oyique. Pero ja' más tsots sc'oplal chca'i li boch'o cha'yic sc'op Dios ti tspasic c'usi cha'yique. Ja' jchi'iltac ta voq'uel xchi'uc ja' jme' chc'otic o ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ta yan to c'ac'al i'ochic ta canova xchi'uc yajchanc'optac li Jesuse. Jech laj yalbe: ―Batic ta jot nab ―xut. Jech ibatic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","C'alal ja' o chanov batel ta ba nab li canovae, ivay li Jesuse. Ja' o ital tsots ic'. Tsots la syuq'uilan li nabe. I'och ep vo' ta yut canova, c'an xa ochuc yalel ta yut nab. ");
INSERT INTO tzotze_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Li Jesuse itijat yu'un li yajchanc'optaque. Jech laj yalbeic: ―Jchanubtasvanej, ta xa xij'och yalel ta yut nab ―xutic. Ilic li Jesuse, la spajes li iq'ue xchi'uc li nabe. Jech ich'abi o scotol. ");
INSERT INTO tzotze_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Mu'yuc to ach'unojic lec ―xut. Toj ch'ayel ic'ot yo'ntonic, ixi'ic. Jech laj yalbe sbaic: ―¿Boch'o vinical li'i? Yu'un c'alal ta ic', c'alal ta nab xu' yu'un tspas ta mantal, pero ta xch'unbat ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tey ic'otic ta jot nab ta yosilal gadáraetic, tey iloq'uic ta canova xchi'uc yajchanc'optac li Jesuse. Li Galileae ta jot nab icom yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","C'alal lic xanovuc batel li Jesuse, ta ora ital nupatuc ta be yu'un jun gadára vinic. Ep xa c'ac'al ochem pucujetic ta yo'nton. Mu'yuc sc'u', mu'yuc sna. Yu'un ja' snainoj li vombil tonetic yo' bu chbat mucatuc li boch'o ta xchame. ");
INSERT INTO tzotze_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Li vinique c'alal laj yil li Jesuse, tey tal spatan sba ta banamil ta stojol. Tsots i'avan li pucujetic ochem ta yo'ntone, jech laj yalic: ―Jesús, vo'ot Xnich'onot Dios ta vinajel, ¿c'u yu'un tal atic' aba ta jtojolcutic? Avocoluc mu me xavac'buncutic castigo ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ti jech laj yal li pucujetique yu'un albilic xa yu'un Jesús ti ac'o loq'uicuc ta yo'nton vinique. Yu'un ep xa ta velta jech chich' uts'intael li vinique. Li cristianoetique ta xchucbeic ta cadena taq'uin li yoc sc'obe yu'un jech mu xmajvan o, pero ta xtuch' yu'un. Jech ta x'ic'at batel ta xocol banamil yu'un li pucujetique. ");
INSERT INTO tzotze_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Li Jesuse jech la sjac'be li vinique: ―¿C'usi abi? ―xut. Itac'ov: ―Legionun, yu'un ep ta mil li' ochemuncutic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Li pucujetique la sc'anbeic Jesús ti mu me xtacatic sutel ta xab ti bu ono'ox oyique. ");
INSERT INTO tzotze_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oy ep chitometic tey ta sa' sve'elic ta ch'ut vits. Li pucujetique la sc'anbeic Jesús ti ja' tey ac'o bat ochicuc ta yo'nton li chitometique. Li Jesuse laj yal ti tey ac'o baticuque. ");
INSERT INTO tzotze_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Li pucujetique iloq'uic batel ta yo'nton li vinique, tey bat ochicuc ta yo'nton li chitometique. Li chitometique i'anilajic yalel ta yalubaltic, tey ibalch'ujic yalel ta nab, tey ijic'ov scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Li jchabichitometique, c'alal laj yilic c'usi la spas li chitometique, ixi'ic batel ta anil. Oy ibatic ta lum, oy ibatic ta tsotsobnaetic, bat yalic ti icham scotol li chitometique xchi'uc ti icol li vinic ti ochem to'ox pucuj ta yo'ntone. ");
INSERT INTO tzotze_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ep gadára cristianoetic ital sq'uelic li c'usi ic'ot ta pasele. C'alal ic'otic bu oy li Jesuse, tey la staic li xchi'ilique, ja' li boch'o iloq'uesbat ep pucuj ta yo'ntone. Tey xa chotol ta sts'el yacan li Jesuse, slapoj xa sc'u', lecuben xa. Pero ixi'ic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Li boch'otic laj yilic c'u x'elan icol li vinic ti ochem to'ox pucujetic ta yo'ntone, laj yalbeic li boch'otic tey ic'otique. ");
INSERT INTO tzotze_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Scotol li gadára cristianoetique laj yalbeic Jesús ti svocoluc ac'o loc'uc batel ta yosilalique, yu'un ep ixi'ic. Jech i'och ta canova xchi'uc yajchanc'optac li Jesuse, isutic batel ta jot nab. ");
INSERT INTO tzotze_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Li vinic ti iloq'uesbat ep pucuj ta yo'ntone jech laj yalbe li Jesuse: ―Ta jchi'inot batel ―xut. Li Jesuse laj yalbe ti ac'o comuque. Jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Batan ta ana, bat alo ti c'u x'elan la scoltaot Diose ―x'utat yu'un li Jesuse. Jech isut batel li vinique, bat yal ta scotol slumal c'u x'elan icoltaat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","C'alal isut batel ta jot nab xchi'uc yajchanc'optac li Jesuse, oy ep israeletic tey ta xmalavanic ta ti' nab. Xcuxet no'ox yo'nton scotolic ti c'alal ic'ot li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tey ital ta stojol Jesús jun vinic, Jairo sbi. Ja' jchapanvanej ta nail tsobobbail yu'unic. La spatan sba ta banamil ta stojol li Jesuse. La sc'anbe ti ac'o batuc ta snae. ");
INSERT INTO tzotze_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yu'un ta xa xcham stseb. C'ajumal jun li xnich'one, lajchab to jabil yich'oj. Li Jesuse ibat xchi'uc yajchanc'optac. C'alal ibate, ep cristianoetic ibatic ec. La stsin sbaic batel, la snet'ilanic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tey xchi'uquic batel jun ants xlajchabal xa jabil ip cha'i tuch' patijel. Ech'em xa yo'nton ta poxtael yu'un jpoxtavanejetic. Ilaj scotol li c'usitic oy yu'une pero muc xcol o. ");
INSERT INTO tzotze_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Li antse inoch'aj batel ta spat li Jesuse, la spicbe stsitsumal yoc xaquita. Jech ta ora icol o. ");
INSERT INTO tzotze_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Li Jesuse jech laj yal: ―¿Boch'o la spicbun jxaquita? ―xi. ―Mu jna', mu'yuc la jpic axaquita ―xi scotolic. Li Pedroe jech laj yalic xchi'uc li xchi'iltaque: ―Jchanubtasvanej, toj tsinil cristianoetic chavil, ja' ta xnet'vanic tal ta jujujot. ¿C'u yu'un “boch'o la spicbun jxaquita” xachi? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Li Jesuse jech laj yal: ―Oy boch'o la spicbun jxaquita yu'un laj ca'i ti oy boch'o icol ta jtsatsale ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Li antse c'alal laj yil ti la sna' Jesús c'usi la spase, xt'elt'un xa ta xi'el ital spatan sba ta banamil ta stojol li Jesuse. Jamal laj yalbe smelol c'u yu'un ti la spicbe xaquitae. Laj ya'yic scotol cristianoetic ti jech laj yale: ―C'alal jech la jpase, ta ora licol o ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Li Jesuse jech laj yalbe: ―Tseb, yu'un laj ach'un ti xu' cu'une, jech lacol. Junuc avo'nton batan ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","C'alal ja' o chlo'ilaj li Jesuse, tey ivul jun vinic. Ja' tey ilic tal ta sna li Jairoe. Jech vul albatuc li Jairoe: ―Icham xa li atsebe. Mu xa xavac'be svocol li Jchanubtasvaneje ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","C'alal laj ya'i li Jesuse, jech laj yalbe li Jairoe: ―Mu xavat avo'nton. Ja' no'ox ch'uno ti xu' cu'un ta jcolta li atsebe ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","C'alal ic'ot ta sna Jairo li Jesuse, muc sc'an ti ep boch'o yan ta xchi'in ochele. Laj yal ti ja' no'ox chic' ochel Pedro, xchi'uc Jacobo, xchi'uc Juan, xchi'uc stot sme' li tsebe. ");
INSERT INTO tzotze_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Oy ep boch'o tey x'avetic ta oq'uel ta amac'. Li Jesuse jech laj yalbe: ―Mu xa'oq'uic. Mu'yuc chamen li tsebe, ja' no'ox ta xvay ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","C'alal jech laj ya'yic li boch'otic tey oyique, la stse'intaic li Jesuse yu'un sna'ic ti chamen o li tsebe. ");
INSERT INTO tzotze_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Li Jesuse i'och batel, la stsacbe sc'ob li tsebe, tsots la sc'opan, jech laj yalbe: ―Tseb, lican ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jech icha'cuxi, ta ora ilic. Li Jesuse laj yal mantal ti ac'o yac'beic sve'ele. ");
INSERT INTO tzotze_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Li stot sme' tsebe toj labal sba laj yilic. Li Jesuse laj yalbe ti mu me boch'o xalbeic batel li c'usi la spase. ");
INSERT INTO tzotze_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Li Jesuse la stsob li lajchab yajchanc'optaque. Laj yac'anbe svu'elic yu'un jech xu' yu'un ta sloq'uesic pucujetic ta yo'nton xchi'iltaquic xchi'uc ta scoltaic jchameletic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","La stac batel yu'un ja' bat yalbe xchi'iltaquic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose, xchi'uc ac'o scoltaic jchameletic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jech laj yalbe: ―Mu me xavich'ic batel c'usitic ta xtun avu'unic ta sventa abeic. Mu me xavich' anamte'ic, xchi'uc anuti'ic, xchi'uc ave'elic, xchi'uc ataq'uinic. Mu me xavich' batel cha'lic ac'u'ic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ti bu junucal na cha'ic'atic ochele tey me oyanic o ja' to me laj anopic ti chaloq'uic batele. ");
INSERT INTO tzotze_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ti bu junucal lum mu xasc'anoxuque loc'anic batel. C'alal chaloq'uic batele, lilino comel spucucal avacanic. Ja' senyail ti ja' xa icom ta sventa stuquic ti muc xich'ic ta muc' li jc'op laj avalbeique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jech iloq'uic batel li yajchanc'optac Jesuse. Xquechet ixanovic batel ta scotol tsobtsobnaetic. La xcholbe ya'yic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. Xchi'uc la scoltaic batel jchameletic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Li ajvalil Erodes tey ta Galilea banamile laj ya'i c'usi tspas li Jesuse. Ep ilo'ilaj yo'nton, mu sna' c'usi ta snop yu'un oy boch'o laj yalic ti ja' icha'cuxi li Juan j'ac'vanej ta vo'e. ");
INSERT INTO tzotze_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oy yantic laj yalic ti ja' j'alc'op Elías ti sc'oplal ono'ox chtal yan veltae. Oy yantic laj yalic ti ja' icha'cuxi junuc li yaj'alc'optac Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Li Erodese jech laj yal: ―Vu'un laj cac' ta c'ocbel sjol li Juane. ¿Boch'o noxtoc ti chca'ibe sc'oplal ep c'usitic lec tspase? ―xi. Jech chac sq'uel ya'i li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","C'alal isutic batel ta stojol li yajchanc'optac Jesuse, c'ot yalbeic scotol li c'usitic la spasique. Li Jesuse ibatic ta xocol banamil xchi'uc li yajchanc'optaque. Tey ibatic ta nopol lum Betsáida. ");
INSERT INTO tzotze_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","C'alal laj ya'yic cristianoetic bu ibatic li Jesuse, bat sa'ic. Li Jesuse lec laj ya'i c'alal ic'ot li cristianoetique. Laj yalbe ya'yic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. La scoltaan noxtoc li jchameletique. ");
INSERT INTO tzotze_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","C'alal bat xa'ox c'ac'ale, li lajchabique jech laj yalbeic li Jesuse: ―Taco me batel li jchi'iltactique, ac'o baticuc ta tsobtsobnaetic xchi'uc ta yantic naetic ti li' no'ox nopolique. Ac'o bat xch'aman snaic, ac'o bat sman sve'elic yu'un xocol banamil li'i, mu'yuc c'usi oy ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Itac'ov li Jesuse: ―Ac'beic sve'el vo'oxuc ―xut. Itac'ovic: ―Mu'yuc c'usi oy cu'uncutic. Ja' no'ox vo'ob pan xchi'uc cha'cot choy li' quich'ojcutic. ¿Me yu'un chac'an chbat jmanbecutic tal li sve'elique? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ti c'u yepal viniquetic tey stsoboj sbaique oy van vo'miluc. Ja' slecoj o li antsetique xchi'uc li ololetique, mu'yuc atbil. Li Jesuse jech laj yalbe li yajchanc'optaque: ―Albeic cristianoetic ti ac'o stsob sbaic ta lajlajuneb yoxvinic jujutsobe, ac'o chotiicuc ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jech laj yalic mantal li yajchanc'optaque. Jech lic stsoban sbaic ta lajlajuneb yoxvinic li cristianoetique, ichotiic scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Li Jesuse la stsac li vo'ob pane xchi'uc li cha'cot choye. La sq'uel muyel vinajel, la stojbe ta vocol Dios. La svoc' li pane xchi'uc li choye, laj yac'be li yajchanc'optaque. Li yajchanc'optaque la spucbeic li epal cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Scotolic ive'ic, inojic o. La stsobic scomelal li pane xchi'uc scomelal li choye, inoj lajcha'moch. ");
INSERT INTO tzotze_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ta yan to c'ac'al c'alal slecoj ta sc'opan Dios stuc li Jesuse, jech la sjac'be li yajchanc'optaque: ―¿Boch'oun ta xalic li jchi'iltactique? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Itac'ovic: ―Oy ta xalic ti vo'ot Juan j'ac'vanejot ta vo'e. Oy yan ta xalic ti vo'ot Elíasote. Oy yan ta xalic ti vo'ot jun yaj'alc'opot Dios ta vo'onee yu'un la lacha'cuxi ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Li Jesuse jech laj yal: ―Li vo'oxuque ¿boch'oun chavalic ec? ―xut. Itac'ov li Pedroe: ―Vo'ot t'ujbilot yu'un Dios chaventainuncutic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Mu to me boch'o xavalbeic ti vu'un t'ujbilun yu'un Dios chajventainoxuque ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jech laj yalbe noxtoc li yajchanc'optaque: ―Vu'un ti co'ol cristianoutique ta ono'ox xquich' ep vocol. Mu xisc'anicun li jchapanvanejetique, xchi'uc li banquilal paleetique, xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Chiyaq'uicun ta milel. Chimucat, pero chicha'cuxi ta yoxibal c'ac'al ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Li Jesuse jech laj yalbe scotol li cristianoetique: ―Li boch'o tsc'an ta xchi'inune mu me xc'uxubin sba. Scotol c'ac'al ac'o sts'ic vocol jech chac c'u cha'al tsts'ic cu'une jech xu' chixchi'inun. ");
INSERT INTO tzotze_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Li boch'o mu sc'an xcham ta jcoje ja' ch'ayel chbat. Yan li boch'o mu sventauc me ta xchame, vu'un ta jventa, ja' ta xcuxi o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ac'o me oy boch'o xu' yu'un ta xu'uninic scotol li c'usitic oy li' ta banamile, pero mu'yuc c'usi ta xtun o yu'un mu xcuxiic o sbatel osil. Yu'un ja' tsots sc'oplal ti chacuxiic sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Li boch'otic ta xq'uexov ta yalel ti xch'unojbicun jc'ope, ja' no'ox jechun ec, vu'un ti co'ol cristianoutique, “Le'e mu'yuc xch'unojbun jc'op”, xichi ti c'alal chtal ochcun ta ajvalilale. Ta xital xchi'uc svu'el li Jtote, xchi'uc ta jchi'inbe tal li yaj'almantaltaque. ");
INSERT INTO tzotze_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Melel li c'usi chacalboxuque, oy boch'o avu'unic li'i ti mu'yuc to ta xchamique ja' to me laj yilic ti chlic sventainbe yo'nton cristianoetic li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","C'alal jech laj yal li Jesuse, i'ech' van vaxquibuc c'ac'al, ja' o bat sc'opan Dios ta jun vits li Jesuse. Laj yic' batel Pedro xchi'uc Jacobo xchi'uc Juan. ");
INSERT INTO tzotze_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","C'alal ja' o tsc'opan Dios li Jesuse, ic'ataj sat. I'ayin xojobal noxtoc li sc'u'e, chtu'p jsatic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tey ivinaj chib viniquetic ilo'ilajic xchi'uc li Jesuse. Ja' Moisés xchi'uc Elías. ");
INSERT INTO tzotze_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oy xojobalic ec. Li c'usi la slo'iltaic xchi'uc Jesuse, ja' laj yalic ti c'u x'elan ta xcham tey ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Li Pedro xchi'uc xchi'iltaque chnicubajic, pero la stsatsalvic' li satique jech muc xtal svayelic. Tey laj yilbeic xojobal li Jesuse xchi'uc li chib viniquetic tey xchi'inoje. ");
INSERT INTO tzotze_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","C'alal laj yilic ti ta xa xbat li chib viniquetique, li Pedroe jech laj yalbe li Jesuse: ―Jchanubtasvanej, lec ti li' oyutique. Ja' lec jpastic oxbej vacaxna li'i, jun avu'un, jun yu'un Moisés, jun yu'un Elías ―xut, yu'un muc snop lec c'usi laj yal. ");
INSERT INTO tzotze_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","C'alal ja' o chlo'ilaj li Pedroe, ital jun toc. Macbil ic'ot ta toc scotolic. Toj xi'el ic'otic ti c'alal macbil ic'otic ta toque. ");
INSERT INTO tzotze_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tey laj ya'yic ic'opoj ta yut toc li Diose, jech laj yal: ―Li'i ja' Jnich'on, lec c'ux ta co'nton. A'ibeic sc'op ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","C'alal laj yo'nton ta lo'ile, stuc xa no'ox tey oy laj yilic li Jesuse. Li yajchanc'optaque ep c'ac'al mu'yuc boch'o laj yalbeic li c'usi laj yilique. ");
INSERT INTO tzotze_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta yoc'omal c'alal iyalic tal ta yoc vitse, tey stsoboj sbaic ep cristianoetic la staic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tey xchi'uquic jun vinic, tsots i'avan: ―Jchanubtasvanej, avocoluc coltabun jnich'on yu'un c'ajumal yu jun li jnich'one. ");
INSERT INTO tzotze_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yu'un ep ta x'uts'intaat yu'un jun pucuj. Ta x'avan, ta xtu'p yic', ta xvocan ye. Jujuliquel no'ox ta xlecub, ta xlic yan velta. ");
INSERT INTO tzotze_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Laj calbe avajchanc'optac ti ac'o sloq'uesbicun li pucuj ochem ta yo'ntone pero muc xloc' yu'unic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Li Jesuse jech laj yal: ―Tsots avo'ntonic, mu xac'an xach'unic. Ep xa c'ac'al li' jchi'ucoxuque pero mu'yuc to chach'unic. Ep xa c'ac'al la jts'icboxuc ti c'u xa'elanique ―xut. Jech laj yalbe li vinique: ―Ic'o tal li anich'one ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","C'alal inoch'aj tal li quereme, ijipat ta lum yu'un li pucuje, itu'pbat yic'. Li Jesuse la stac loq'uel li pucuje, jech icol o li quereme. Li Jesuse jech laj yalbe stot li quereme: ―Ic'o li anich'one ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Scotolic toj labal sba laj yilic ti toj ech'em svu'el li Diose. C'alal tey to ch'ayem yo'nton scotolic ta sventa c'usi la spas li Jesuse, li Jesuse jech laj yalbe li yajchanc'optaque: ");
INSERT INTO tzotze_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―A'yo ava'yic li c'usi chacalboxuque, mu me xch'ay ta avo'ntonic. Vu'un ti co'ol cristianoutique ta xi'ac'at ta c'abal ta sc'ob cristianoetic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Li yajchanc'optaque muc xa'ibeic smelol li c'usi laj yale yu'un muc x'ac'bat ya'yic yu'un Dios. Ixi'ic ta sjac'bel smelol li c'usi i'albatique. ");
INSERT INTO tzotze_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Li yajchanc'optac Jesuse lic yutilan sbaic ta sventa boch'o junucal más banquilal ta xc'ot yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Li Jesuse la sna' ti jech sbats'ilic snopele jech laj yic' tal jun olol. Tey la sva'an ta sts'el. ");
INSERT INTO tzotze_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jech laj yalbe li yajchanc'optaque: ―Boch'otic ta xich' ta muc' li boch'o jech yo'nton jech chac c'u cha'al li olol li'i, vu'un ta jventa, jech vu'un chiyich'un o ta muc'. Li boch'o chiyich'un ta muq'ue ja' ta xich' o ta muc' li Jtote, ja' ti la stacun tale. Ja' no'ox jechoxuc ec li vo'oxuque, li boch'o biq'uit ta xac' sbae ja' banquilal ta xc'ot avu'unic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Li Juane jech laj yalbe li Jesuse: ―Jchanubtasvanej, oy boch'o laj quilcutic ta sloq'ues pucujetic ta yo'nton cristianoetic. Ta xal abi ti c'alal ta sloq'uese. Pero la jpajescutic yu'un muc li'uc jchi'uctic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Itac'ov li Jesuse: ―Mu me xapajesic. Yu'un li boch'o chloc' yu'un pucuj jech chac c'u cha'al chloc' cu'untique, ja' co'ol co'ntontic jchi'uctic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","C'alal jutuc xa sc'an sta yorail ch‑ic'at muyel ta vinajel li Jesuse, muc xi' ti chbat ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jech oy boch'o ba'yuc la stac jelovel yu'un ac'o bat xch'amanic na yo' bu ta xc'otique xchi'uc ac'o sman sve'elic. Jech ibatic. Tey ic'otic ta tsobtsobnaetic ta Samaria banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Li samariaetic tey nacajtique muc xac' ta ch'amanel snaic yu'un laj ya'yic ti tey ta xbatic ta Jerusalén xchi'uc yajchanc'optac li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Li chib yajchanc'ope, ja' li Jacobo xchi'uc Juane, c'alal laj yilic ti muc xac' ta ch'amanel snaique, jech laj yalbeic li Jesuse: ―Cajval, ¿me chac'an ta jpascutic mantal ti ac'o yaluc tal c'oc' ta vinajel yu'un jech ac'o chamicuc jech chac c'u cha'al la spas li Elíase? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Li Jesuse la sq'uel li chib yajchanc'ope, jech laj yalbe: ―Mu me xavalic jech. Yu'un yan o boch'o sventainoj avo'ntonic ti jech chavalique. ");
INSERT INTO tzotze_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Vu'un ti co'ol cristianoutique mu yu'unuc tal jmil yu'un ac'o baticuc ta ch'ayel li cristianoetique. Ja' tal jcoltaic ―xut. C'alal laj yalbe jeche, ibatic ta yan tsobtsobnaetic. ");
INSERT INTO tzotze_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","C'alal ixanovic batel ta bee, li Jesuse jech i'albat yu'un jun vinic: ―Cajval, ta jchi'inot batel ti buyuc no'ox chabate ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Itac'ov li Jesuse: ―Oy xch'en li vetetique, oy stas li mutetique. Vu'un ti co'ol cristianoutique mu'yuc jna. Jech nopo lec me xu' avu'un chachi'inune ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Li Jesuse oy boch'o yan jech laj yalbe: ―Chi'inun batel ―xut. Itac'ov li vinique: ―Cajval, coltaun to batel yu'un chbat jchi'in li Jtote. Ja' to me ichame, ta jmuc comel, ts'acal to chtal jchi'inot ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Itac'ov li Jesuse: ―Li boch'otic xco'laj xchi'uc chamenic ya'yel ta sventa ti mu xiyich'icun ta muq'ue, tey ac'o smuc sba stuquic. Li vo'ote bat albo ya'yic cristianoetic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oy boch'o yan jech laj yal: ―Cajval, ta jc'an ta jchi'inot, ja' no'ox coltaun to batel yu'un ta to xbat jc'opan comel scotol li boch'otic tey oyic ta jnae ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Li Jesuse jech laj yalbe: ―Me mu junuc avo'nton chach'un c'usi chacalbote, ja' jechot jech chac c'u cha'al li boch'o mu junuc yo'nton tsloc yosile. Mu xlaj o li yabtele. Ja' jech mu xu' chatun yu'un Dios me mu junuc avo'nton ta stojole ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ts'acal la st'uj yan lajuneb xchanvinic (70) viniquetic li Cajvaltique. Ta chabchab la stacan batel ta jujun lum xchi'uc ta jujun tsobtsobnaetic yu'un snopoj ti ts'acal to tey chjelov ec li Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jech laj yalbe scotolic: ―Ta melel oy ep boch'otic tsc'an cha'yic li sc'op Diose, ja' mu'yuc ep li boch'o tsc'an ta xcholique. Jech chac c'u cha'al me ep li c'aoje, pero ja' mu'yuc ep li jc'aojetique. Ja' lec c'anbeic Dios ti ac'o stac batel li boch'otic chbat cholbatuc sc'ope yu'un ja' Yajval abtel. ");
INSERT INTO tzotze_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Batanic. Ta jtacoxuc batel jech chac c'u cha'al chijetic ti chc'ot staic oq'uiletique yu'un tey chc'ot ataic li boch'otic tsc'an ta smiloxuque. Jech bijanic me. ");
INSERT INTO tzotze_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mu me xavich' batel ataq'uinic, mu me xavich' batel ave'elic. Mu me xavich' batel yan axonobic. Li boch'o chanupic ta bee mu me jaluc xalo'ilaj achi'uquic. ");
INSERT INTO tzotze_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ti bu junucal na cha'ochique ba'yuc jech xavalbeic: “Ac'o yac'boxuc jun avo'ntonic li Diose”, utic. ");
INSERT INTO tzotze_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Me tsc'an ti jun yo'ntonique, tstaic. Me mu sc'anique mu staic. ");
INSERT INTO tzotze_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Li na bu cha'ic'atic ochele tey me oyanic o. Mu me xajelilan li anaique. Scotol li c'usi cha'ac'batique ve'anic. Yu'un li boch'o ta xtacat batel ta abtele tey ta x'ac'bat sve'el. ");
INSERT INTO tzotze_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","C'alal chac'otic ta jujun lume, me oy boch'o chayic'oxuc ochel ta snae, ve'anic scotol li c'usitic chayac'boxuque. ");
INSERT INTO tzotze_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Me oy jchameletic tey oyique, coltaic. Jech xavalbeic: “Laj xa ana'ic ti yorail xa xu' chasventainboxuc avo'ntonic li Diose, yu'un laj xa avilic ti la scoltaoxuque”, utic. ");
INSERT INTO tzotze_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Me oy bu junucal lum chac'otic ti mu xayic'oxuc ochel ta snaique, xanovanic batel ta calletic, jech xavalic: ");
INSERT INTO tzotze_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ta jlilincutic comel spucucal cacancutic li' ta atojolique. Ja' senyail ti icom xa ta aventa atuquic me muc xacolique, yu'un mu xavich'uncutic ta muc'. Na'ic me ti laj xa ana'ic ti yorail xa xu' chasventainboxuc avo'ntonic li Diose”, utic comel. ");
INSERT INTO tzotze_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jech chacalboxuc ava'yic. C'alal tsta sc'ac'alil ta xchapanatic yu'un Dios li cristianoetique, ja' jutuc castigo ta xich'ic li cristianoetic tey ta Sodoma ta vo'onee. Ja' tsots castigo ta xich'ic li jchi'iltactic tey nacajtic ta lum ti bu chalilin comel spucucal avacanique. ");
INSERT INTO tzotze_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Li jchi'iltactic tey nacajtic ta lum Corazine xchi'uc li jchi'iltactic tey nacajtic ta lum Betsáidae, ta ono'ox xich'ic tsots castigo yu'un laj yilic ep sq'uelubil jtsatsal pero muc xch'unic. Li yan lum cristianoetic tey nacajtic ta lum Tiro xchi'uc ta lum Sidón ta vo'onee muc xilic sq'uelubil jtsatsal. Ti lajuc yilique, la slapic jalbil tsotsil tentsun ti c'ux ta lapele, xchi'uc la sbon sbaic ta tanil c'oc' ti jechuque. Ja' senyail ti chat yo'ntonic yu'un li c'usitic chopol spasojique, jech tscomtsanic. ");
INSERT INTO tzotze_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","C'alal tsta sc'ac'alil ta xchapanatic yu'un Dios li cristianoetique, ja' jutuc castigo ta xich'ic li yan lum cristianoetic tey nacajtic ta Tiro xchi'uc ta Sidón ta vo'onee. Ja' tsots castigo ta xich'ic li jchi'iltactic tey nacajtic ta Corazín xchi'uc ta Betsáida ta ora le'e. ");
INSERT INTO tzotze_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Li jchi'iltactic tey nacajtic ta lum Capernaume tsnopic ti ja' ep ta xich'ic bendicione, pero altic. Ja' tsots castigo ta xich'ic yu'un laj yilic ep sq'uelubil jtsatsal pero muc xch'unic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Boch'o chayich'oxuc ta muq'ue ja' vu'un chiyich'un o ta muc'. Yan li boch'o mu xayich'oxuc ta muq'ue ja' vu'un ti mu xiyich'un ta muq'ue. Li boch'o mu xiyich'un ta muq'ue ja' mu xich' o ta muc' ec li Jtot ti la stacun tale ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Li lajuneb xchanvinic itacatic batele xcuxet no'ox yo'nton isutic tal. Jech c'ot yalbeic li Jesuse: ―Cajval, vo'ot ta aventa ti c'alal ta pucujetic ivu' cu'uncutic la jloq'uescutique ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Li Jesuse jech laj yal: ―Laj ca'i ta co'nton ilaj stsatsal li Satanase ja' jech chac c'u cha'al sacsevul ti ta ora no'ox ta xtube. ");
INSERT INTO tzotze_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A'yo ava'yic, laj xa cac'boxuc avu'elic yu'un jech xu' avu'un chatsalic li cajcontratique, ja' ti toj chopolique ti tsc'an co'ol ch'ayel chabat achi'uquique. Ja' jech chac c'u cha'al chaju'ic ta teq'uel tsec xchi'uc yan chonetic, ja' jech x'elan ta stsal avu'unic scotol li cajcontratique. Mu'yuc c'usi xu' yu'un ta spasboxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mu me xcuxetuc avo'ntonic ti ch'unbil amantalic yu'un li pucujetique. Ja' me ac'o cuxetuc avo'ntonic ta sventa ti tey xa ts'ibabil abiic ta vinajele ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Li Jesuse ta ora ital xcuxetel yo'nton ta sventa li Ch'ul Espíritue, jech laj yalbe li Diose: ―Tati, vo'ot yajvalot li vinajel banamile. Colaval ti muc xavac'be ya'yic smelol c'usi laj cal xchi'uc c'usi la jpas li boch'otic bijique xchi'uc li boch'otic lec sna' yalojique. Ja' no'ox laj avac'be ya'yic smelol li boch'otic tsc'anic coltael jech chac c'u cha'al ololetique. Tati, lec oy ti jech la sc'an avo'ntone ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Li Jesuse lic sc'opan yan velta li cristianoetique, jech laj yalbe: ―Scotol yac'ojbun ta jc'ob li Jtote. Vu'un li Xnich'onune mu'yuc boch'o sna'bun c'u x'elan co'nton. Ja' no'ox stuc Jtot sna' c'u x'elan co'nton. Ja' no'ox jech ec li Jtote mu'yuc boch'o sna'be c'u x'elan yo'nton. Vu'un no'ox jna'be c'u x'elan yo'nton li Jtote xchi'uc ta sna'ic ec li boch'otic ta xcac'be sna'ique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Li yajchanc'optaque slecoj lic sc'opan scotol, jech laj yalbe: ―Vo'oxuc ti cajchanc'optacoxuque laj xa xc'uxubinoxuc li Diose jech chac'an chava'ibeic smelol li c'usi ta jpase. ");
INSERT INTO tzotze_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chacalboxuc, ep yaj'alc'optac Dios ta vo'one xchi'uc ep ajvaliletic ta vo'one tsc'an chilic ec li c'usi chavilique, pero muc xilic. Tsc'an cha'yic ec li c'usi chava'yique, pero muc xa'yic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tey oy jun jchanubtasvanej ta smantal Dios yaloj. La sva'an sba yu'un oy c'usi tsc'an tsjac'be li Jesuse. Pero ja' no'ox ta sq'uel c'u x'elan ta xtac'ov. Jech laj yalbe: ―Jchanubtasvanej, ¿c'usi lec ta jpas ti xu' chicuxi o sbatel osile? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Li Jesuse jech la sjac'be li vinique: ―¿C'usi ts'ibabil ta smantal li Diose yu'un aq'ueloj xa? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Itac'ov li vinique: ―“C'anic me ta scotol avo'ntonic li Dios cu'untique. Ac'bo sventain avo'ntonic, xchi'uc atsatsalic, xchi'uc abijilic, ac'o tunuc yu'un. C'anic me achi'ilic jech chac c'u cha'al c'ux ta avo'nton abec'tal atuquique”, xi li smantal Diose ―xi li vinique. ");
INSERT INTO tzotze_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Itac'ov li Jesuse: ―Lec latac'ov. Me jech chapase, chacuxi o sbatel osil ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Li vinique tsc'an tspoj sba, jech laj yalbe li Jesuse: ―¿Boch'o li jchi'ile? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Li Jesuse oy c'usi la sloc'tabe ta lo'il, jech laj yal: ―Oy jun jchi'iltic ta israelal iloc' batel ta Jerusalén, ibat ta Jericó. C'alal chanov batel ta bee, la snup ta be j'eleq'uetic. Ipojbat scotol li c'usitic oy yu'une, xchi'uc iloc'bat batel sc'u', xchi'uc imajat comel. Jech ep ituch' comel yu'unic. Jech ibatic, yu'un chamen xa icom yu'unic yilel. ");
INSERT INTO tzotze_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ts'acal tey iloc' tal jun pale cu'untic. C'alal laj yil tey mochol li jchi'iltique, la sjoy sbe li palee, jech ijelov o batel. ");
INSERT INTO tzotze_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ts'acal tey iloc' tal jun yajcoltaubbail paleetic tey ta templo. C'alal ivul bu mochol li jchi'iltique, la sjoy sbe ec, jech ijelov o batel. ");
INSERT INTO tzotze_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ts'acal tey iloc' tal jun yan lum vinic liquem tal ta Samaria banamil. C'alal laj yil tey mochol li jchi'iltique, ic'uxubinvan li samaria vinique. ");
INSERT INTO tzotze_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inoch'aj batel ti bu mochole. La xpoxtabe scotol ti bu tuch'emique, laj yac'be aceite xchi'uc vino, la xpixbe lec ta poc'. La scajan batel ta sburro, laj yic' batel yo' bu ta xaq'uic ta loq'uel nae. Tey la xchabi. ");
INSERT INTO tzotze_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta yoc'omal c'alal iloc' batel li samaria vinique, laj yac'be comel chib denario taq'uin li yajval nae. Jech laj yalbe comel: “Chabibun me lec li vinique. Me oy c'usi más ta xlaj avu'une, ta jtojbot scotol c'alal me lisut tale”, xut comel. ");
INSERT INTO tzotze_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Li vo'ote ¿c'usi chanop? Li oxibique ¿boch'o junucal la scuy ta xchi'il li jchi'iltic ti imajat comel yu'un j'eleq'uetique? ―xut li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Itac'ov li jchanubtasvanej ta smantal Dios yaloje: ―Ja' li boch'o ic'uxubinvane ―xi. Li Jesuse jech laj yalbe: ―Batan, bat c'uxubinvanan jech ec li vo'ote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Li Jesuse tey ic'ot ta jun tsobtsobnaetic xchi'uc yajchanc'optac. Tey nacal jun ants, Marta sbi. Tey i'ic'atic ochel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oy smuc li Martae, María sbi. Li Maríae tey tal chotluc ta sts'el li Jesuse yu'un tsc'an cha'ibe sc'op. ");
INSERT INTO tzotze_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yan li Martae ibat yo'nton yu'un c'usi tspas ta sna yu'un tsc'an chmac'linvan. Jech inoch'aj tal ta stojol li Jesuse, jech laj yalbe: ―Cajval, ¿me mu'yuc chlo'ilaj avo'nton ti jtuc no'ox chiyac'bun jmeltsan ve'lil li jmuque? Ja' lec albo ac'o tal scoltaun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Itac'ov li Jesuse: ―Marta, ta sventa ti toj ep c'usitic chapase jech chlo'ilaj avo'nton. Jech mu xcuxetuc avo'nton. ");
INSERT INTO tzotze_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero ja' no'ox jun ti tsots sc'oplale. Li Maríae laj xa st'uj ti bu tsots sc'oplale, jech mu'yuc boch'o xu' chpojbat ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ta yan c'ac'al c'alal ilaj yo'nton ta sc'opanel Dios li Jesuse, jech i'albat yu'un jun yajchanc'op: ―Cajval, chanubtasuncutic ta sc'opanel Dios ec jech chac c'u cha'al la xchanubtas ta sc'opanel Dios yajchanc'optac Juan j'ac'vanej ta vo'e ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Itac'ov li Jesuse: ―C'alal chac'opanic Diose, jech me xavalic: “Jtotic Dios, tey oyot ta vinajel, ac'o ich'atan ta muc' cu'uncutic. Ac'o sta yorail chtal apas mantal atuc li' ta banamile. Ac'o jpascutic c'usi chac'an jech chac c'u cha'al tspasic tey ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ac'bun tal jve'elcutic li jun c'ac'al li'i. ");
INSERT INTO tzotze_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasbuncutic perdón yu'un jmulcutic jech chac c'u cha'al jpasojbecutic perdón li boch'otic oy smul cu'uncutique. Mu me xavac' xistsaluncutic li mulile. Coltauncutic ta stsalel”, xachiic ti c'alal chac'opanic Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jech la sloc'ta ta lo'il noxtoc li Jesuse: ―Caltic ti oy boch'o lec xac'opan aba achi'uc tey c'ot xch'aman ana yu'un chvaye. Pero mu'yuc sve'el avu'un yu'un chamac'lin. Pero oy jun achi'il chbat ac'opan ta o'lol ac'ubal yu'un chaq'uexbe oxibuc span sventa chamac'lin o li avulo' ivul ta anae. Jech chc'ot avalbe: “Jq'uextic oxibuc apan yu'un oy ja' to ivul xch'amanbun jna jun jchi'il yu'un chvay. Pero mu'yuc sve'el cu'un”, xavut. ");
INSERT INTO tzotze_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jech chayalbot: “Mu xu', yu'un lec xa jmacoj li jnae. Chivaycutic xa jchi'uc jnich'nab jech mu xu' chlic cac'bot”, xayutot. ");
INSERT INTO tzotze_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pero me mu xlaj avo'nton ta sc'anbele, jech chlic yac'bot scotol li c'usitic chtun avu'une. ");
INSERT INTO tzotze_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Me jech mu xlaj avo'ntonic ta sc'anilanbel li Diose, jech chayac'boxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yu'un li boch'otic tsc'anilanique ta x'ac'batic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Li vo'oxuque, me ta sc'anboxuc vaj sve' anich'onique, mu tonuc chavac'beic. Me chasc'anboxuc choy sti'e, mu chonuc chavac'beic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Me ta sc'anboxuc ton caxlan slo'e, mu tsecuc chavac'beic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Li vo'oxuque chopoloxuc ono'ox pero xana'ic c'usi lec chavac'beic li anich'nabique. Li Jtotic tey oy ta vinajele ja' más to ech'em lec li c'usi chayac'boxuque. Ch'ul Espíritu chac'be li boch'otic chc'anbat ta stojole ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Li Jesuse la sloq'uesbe pucuj ta yo'nton jun uma' vinic. Ti jech uma' li vinique, ja' ta scoj li pucuj ochem ta yo'ntone. C'alal iloc' pucuj ta yo'ntone, ijam li yee. Li cristianoetique toj ch'ayel ic'ot yo'ntonic ti c'alal laj yilic ijam ye li vinique. ");
INSERT INTO tzotze_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero oy jayibuc boch'o jech laj yalic: ―Li vinic li'i ta svu'el banquilal pucuj ta sloq'ues pucujetic ta yo'nton cristianoetic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oy yantic ja' no'ox tsc'an tsq'uelbeic c'u x'elan yo'nton li Jesuse, jech laj yalbeic: ―Jchanubtasvanej, ac'bun quilcutic senyail atsatsal ta vinajel yu'un jech ta jna'cutic o ti vo'ot tsots avabtele ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Li Jesuse la sna' li c'usi tsnop ta yo'ntonique, jech laj yalbe: ―Me ta scontrain sbaic jun ajvalil xchi'uc xchi'iltac ta abtele, tey ta soquic o. Me ta scontrain sbaic yajvaltac jun nae, ta soquic o noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ja' no'ox jech ec li Satanase, me ta sloq'ues xchi'ile, mu xu' yu'un ta spas mantal me jech ta spase. Ti jech ta xcalboxuque, yu'un chavalic ti ja' ta svu'el Satanás ta jloq'ues li pucujetique. ");
INSERT INTO tzotze_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti ja'uc ta svu'el Satanás ta jloq'ues pucujetic jech chac c'u cha'al chavalique, ¿boch'o ta scoj ta sloq'uesic pucujetic ec li avajchanc'optaquique? Li avajchanc'optaquique xu' chalic ti mu meleluc c'usi chavalique. ");
INSERT INTO tzotze_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Li vu'une ta sventa stsatsal Dios ta jloq'ues li pucujetique, jech ta xvinaj o ti li' tspas mantal ta atojolic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Li boch'o tsatsal vinic xchi'uc ti oy lec stuq'ue, mu'yuc boch'o xu' chtal pojbatuc li c'usitic oy yu'une. ");
INSERT INTO tzotze_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero me ta xtal tsalatuc yu'un li boch'o más to tsots slomoe, ta xpojbat li stuc' ti ja' spatoj o yo'nton xchi'uque, jech ta xpojbat o li c'usitic oy yu'une. Li Satanase ja' jech chac c'u cha'al li tsatsal vinique yu'un ja' sventainoj li cristianoetique. Pero li vu'une ja' jechun jech chac c'u cha'al li boch'o más to tsots slomoe yu'un laj xa jtsal. Yu'un laj xa jpojbe li vinic ti tey to'ox oy ta sc'obe. ");
INSERT INTO tzotze_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Boch'o mu'yuc lec chil c'usi ta jpase yu'un xa chiscontrainun o. ");
INSERT INTO tzotze_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Vo'oxuc ti li' to oyoxuc ta banamile, más to chopol chabatic ta scoj ti mu xavich'icun ta muq'ue. Ja' jech chac c'u cha'al jun vinic ti iloc' pucuj ta yo'ntone. Li pucuje ibat ta xocol banamil, bat sa' bu ta xcux yo'nton, pero mu sta. Jech lic yal ta yo'nton: “Ja' lec ta xisut batel yan velta ta yo'nton li vinique”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","C'alal ic'ote, xocol c'ot sta ti bu ono'ox iloc' tale yu'un mu'yuc yac'oj sba ta ventainel yu'un Dios li vinique. Ja' no'ox slecubtasoj jutuc sba stuc. ");
INSERT INTO tzotze_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jech bat sa' tal yan vucub xchi'iltac li pucuje, ja' ti bu toj chopolique. Scotol tal ochicuc ta yo'nton li vinique. Tey inaquiic o. Li vinique más to isoc o ta jyalel. Ja' lec to'ox jutuc ti c'alal mu'yuc to'ox loq'uem batel li jun pucuje ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","C'alal ja' o jech chal li Jesuse, oy jun ants tey xchi'uquic li cristianoetique tsots i'avan, jech laj yalbe li Jesuse: ―Ja' más xcuxet yo'nton li ame'e yu'un ja' la xchi'inot ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Itac'ov li Jesuse: ―Scotol li boch'o ta xa'yic ta xch'unic c'usitic ta x'albatic yu'un Diose, más xcuxet yo'ntonic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","C'alal tstsob xa sbaic tal epal cristianoetic ta stojol li Jesuse, jech laj yalbe: ―Vo'oxuc ti li' oyoxuc ta banamil ta orae chopol avo'ntonic. Chac'an chaq'uelic senyail ti scotol xu' cu'une. Pero mu'yuc cha'ac'bat avilic. Ja' no'ox cha'ac'bat avilic jech chac c'u cha'al ic'ot ta pasel ta stojol li Jonase, ja' li yaj'alc'op Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jech chac c'u cha'al li yan lum cristianoetic tey nacajtic ta lum Nínivee la sna'ic ti tacbil ibat yu'un Dios li Jonase, jech ta to xana'ic ec ti tacbilun tal yu'un Dios, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","C'alal tsta yorail ta xchapanatic scotol cristianoetique, ja' mu'yuc smul ta x'ilat yu'un Dios li yan lum ants i'och ta ajvalilal tey ta xocon vinajel ta sure. Yan vo'oxuc ti li' to oyoxuc ta banamile, ep amul cha'ilatic. Yu'un li antse nom ital, tal ya'ibe sc'op li Salomone, yu'un laj ya'i ti lec bije. Pero li Salomone mu tsotsuc yabtel laj yich'. Vu'un ti li'oyun ta atojolique más to ech'em jbijil, pero mu xavich'icun ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Li boch'otic tey nacajtic ta lum Nínive ta vo'onee mu'yuc smul ta x'ilatic yu'un Dios ti c'alal ta sta yorail ta xchapanatic scotol cristianoetique. Yan vo'oxuc ti li' to oyoxuc ta banamile ep amul cha'ilatic. Yu'un c'alal ay yich'ic cholbel sc'op Dios yu'un Jonás li cristianoetic tey ta Nínivee, ta ora la scomtsan li c'usitic chopol ta spasique. Li Jonase mu tsotsuc yabtel laj yich'. Vu'un tsots cabtel quich'oj ti li' oyun ta atojolique, pero mu xavich'ic ta muc' li c'usi ta xcale. ");
INSERT INTO tzotze_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Jech chac c'u cha'al me oy chatsanic lámparae, mu'yuc chavaq'uic ta nac'alaltic, mu'yuc chanujmaquiic ta anmul. Ja' chavaq'uic ta sjoc'leb jech lec chilic osil scotol li boch'o ta x'ochic tal ta anaique. Ja' no'ox jech jamal laj cac'boxuc avilic ti tacbilun tal yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Li asatique ja' jech chac c'u cha'al lámpara. Me lec stsan li lámparae, oyutic ta sac osil. Yan me mu stsane, oyutic ta ic' osil. Ja' no'ox jechoxuc ec, me ach'unojic c'usitic yaloj Diose, jech chana'ic ti tacbilun tal yu'une. Yan me mu'yuc ach'unojique, mu xana'ic jech chac'anic senyail. ");
INSERT INTO tzotze_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jech q'uelo me abaic, mu me ja'uc ta scoj tsots avo'ntonic ti mu xana'ic ti vu'un tacbilun tal yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yu'un me scotol avo'nton ach'unojic c'usitic yaloj Diose, chana'ic lec ti tacbilun tal yu'une jech chac c'u cha'al lec xavilic osil me lec stsan lámparae ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","C'alal laj yo'nton ta lo'il li Jesuse, i'ic'at batel ta ve'el yu'un jun vinic xch'unoj fariseo. Li Jesuse ibat, tey c'ot chotluc ta ti' mesa. ");
INSERT INTO tzotze_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Li fariseoe toj ch'ayel ic'ot yo'nton c'alal laj yil ti mu'yuc jal la spoc sc'ob Jesús c'alal bat chotluc ta mesae. ");
INSERT INTO tzotze_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Li Cajvaltique jech laj yalbe: ―Vo'oxuc li fariseooxuque, ja' jechoxuc jech chac c'u cha'al li boch'o ja' no'ox ta spocbe spat li vaso xchi'uc platoe. Yan li yute mu'yuc ta suq'uic, ja' nojem ta ic'ubal. Lecoxuc yilel pero li avo'ntonique nojem ta sc'upinel c'usitic oy yu'un achi'ilic. Chavalbeic ti oy c'usi ac'o yaq'uic ta sventa Diose pero vo'oxuc chavich' atuquic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Muc bijucoxuc. ¿Me chanopic ti mu xil avo'ntonic li Dios ti ja' la spasoxuque? ");
INSERT INTO tzotze_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ja' lec c'uxubinvananic, q'uelanic c'usitic oy avu'unic, jech lec chayiloxuc li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Vo'oxuc li fariseooxuque, ta ono'ox xavich'ic tsots castigo yu'un ja' no'ox tsots sc'oplal chava'i chavatic ta lajlajuneb li c'usitic ats'unojique, ja' li yaravenoe, xchi'uc li rudae, xchi'uc scotol li c'usitic yan ats'unojique. Jujun chaloq'uesic ta sventa smoton Dios. Ja' no'ox tsots sc'oplal chava'yic ti tsc'an Dios chavac'beic li c'usitic oy avu'unique. Ja' mu tsotsuc sc'oplal chava'yic ti tuc' chachapanvanique xchi'uc ti ac'o ac'anic ta scotol avo'ntonic li Diose. Ja' lec ti lajuc apasic noxtoc ti bu tsots sc'oplale. ");
INSERT INTO tzotze_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Vo'oxuc li fariseooxuque, ta ono'ox xavich'ic tsots castigo yu'un lec chava'yic chachotiic ta sliqueb chotlebal tey ta nail tsobobbailetic. Xchi'uc lec chava'yic me chavich'ic c'opanel yu'un jchi'iltactic tey ta ch'ivit. ");
INSERT INTO tzotze_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Vo'oxuc li fariseooxuque, jlo'lavanejoxuc jech ta ono'ox xavich'ic tsots castigo. Yu'un ja' jechoxuc jech chac c'u cha'al smuquinal ánima ti bu mu'yuc yich'oj sq'uelubile jech mu xvinaj. Li boch'otic tey chjelovic ta sba yac'ole mu sna'ic ti oy ánima tey ta yute. Ja' no'ox jechoxuc li vo'oxuque, li boch'otic ta xch'un c'usi chavalique mu sna'ic ti chamen chayiloxuc Diose yu'un puro chopol c'usi oy ta avo'ntonic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jech itac'ov jun jchanubtasvanej ta smantal Dios yaloj: ―Jchanubtasvanej, ti jech chavale yu'un chopol chaviluncutic ec ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Li Jesuse jech laj yalbe: ―Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique, ta ono'ox xavich'ic tsots castigo. Yu'un xco'laj xchi'uc vo'oxuc chameltsanic icatsil ti toj ole, ti vocol chlic ta cuchele. Ja' no'ox chavac'beic xcuch yan cristianoetic. Pero li vo'oxuque mu j'ech'el xlic avu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Jech ta ono'ox xavich'ic tsots castigo yu'un co'ol avo'nton achi'uquic li amoltotic ta vo'onee. Lecoxuc xa yilel yu'un chameltsanbeic lec smuquinal li yaj'alc'optac Dios ta vo'onee, ja' ti imilatic yu'un amoltotique. ");
INSERT INTO tzotze_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ja' svinajeb ti co'ol avo'nton achi'uquic li amoltotic ta vo'onee ti chopol c'usitic la spasique. Li amoltotique la smilic li j'alc'opetique, pero vo'oxuc to chats'acubtasbeic c'usi la spasic li amoltotaquic ta vo'onee yu'un po'ot xa chapasbicun jech ec. ");
INSERT INTO tzotze_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Li Diose sna'oj ono'ox ti jech ta xc'ot ta pasele, ja' yu'un jech ono'ox laj yal: “Ta to jtac batel j'alc'opetic xchi'uc jchanubtasvanejetic ta stojolic. Oy ta xlic smilic, oy ja' no'ox chlic yuts'intaic”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Jech vo'oxuc ti li' to oyoxuc ta banamile chcom ta aventa ti c'u yepal j'alc'opetic imilatic c'alal imeltsaj li banamile xchi'uc c'alal to tanae. C'alal imilat li Abele xchi'uc c'alal to imilat ta yamaq'uil templo ta nopol scajleb smoton Dios li Zacaríase, vo'oxuc chcom ta aventaic scotol. ");
INSERT INTO tzotze_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Vo'oxuc ti chachanubtasvanic ta smantal Dios avalojique, ta ono'ox xavich'ic tsots castigo yu'un laj xa ayanijesbeic smelol li smantaltac Diose. Yu'un mu xach'un atuquic, jech mu'yuc lec chacholic. Jech vo'oxuc chamaquic li boch'otic tsc'an ta xch'unique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","C'alal laj yal jech li Jesuse, li boch'otic ta xchanubtasvanic ta smantal Dios yalojique xchi'uc li fariseoetique, tsots i'ilinic. Jech ep c'usi la sjac'beic li Jesuse yu'un tsc'anic ti ac'o lo'ilajuc epe. ");
INSERT INTO tzotze_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yu'un me mu jechuc smelol c'usi ta xal li Jesuse, xu' tey ta stabeic o smul yalojic. ");
INSERT INTO tzotze_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","C'alal ja' o chlo'ilaj xchi'uc fariseoetic li Jesuse, la stsob sbaic tal ta stojol Jesús ep ta mil israeletic. Tey ta snet'ilan sbaic scotolic. Li Jesuse ba'yuc jech laj yalbe li yajchanc'optaque: ―Q'uelo me abaic ta sventa svolesubil xch'ut pan yu'un fariseoetic. Yu'un tuc' yo'ntonic yilel pero ja' no'ox chlo'lavanic. Li vo'oxuque mu me xapasic jech. ");
INSERT INTO tzotze_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yu'un me oy c'usi chopol chanop ta avo'ntonic li' ta orae ta ono'ox xvinaj bu ora. ");
INSERT INTO tzotze_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Scotol li c'usitic chavalic ta mucule ta ono'ox xvinaj ta yan c'ac'al tey ta stojol Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Vo'oxuc ti lec chaquiloxuque, chacalboxuc ti mu me ja'uc xaxi'ic yu'un li boch'o ta smil abec'talique, yu'un mu xu' yu'un ta smil li ach'ulelique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Li boch'o tsc'an chaxi'ic yu'une, ja' li Diose. Yu'un ja' xu' yu'un chayac'oxuc batel ta muc'ta c'oc' c'alal ta ach'ulelic. Jech tsc'an ja' chaxi'ic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Xana'ic ti lajuneb no'ox cobre stojol ta vo'cot li bic'tal mutetique. Pero me jcotuc mu xch'ay ta yo'nton li Diose, scotol xchabioj. ");
INSERT INTO tzotze_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Li vo'oxuque atbil jaybej li stsotsil ajolique. Ja' yu'un mu me xaxi'ic. Yu'un más to ech'em tsots ac'oplalic li vo'oxuque; ja' jutuc no'ox sc'oplal li bic'tal mutetique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Chacalboxuc, li boch'otic jamal ta xalic ta stojol cristianoetic ti xch'unojbicun jc'ope, ja' no'ox jech ec vu'un ti co'ol cristianoutique, jamal ta xcal ta stojol Jtot ti melel xch'unojbicun jc'ope, xchi'uc ta stojol li yaj'almantaltaque. ");
INSERT INTO tzotze_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yan li boch'otic mu jamaluc chalic ta stojol cristianoetic ti xch'unojbicun jc'ope, ja' no'ox jech ec li vu'une “le'e mu'yuc xch'unojbun jc'op”, xcut li Jtote xchi'uc li yaj'almantaltaque. ");
INSERT INTO tzotze_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Boch'o chopol chc'opoj ta jtojol, vu'un ti co'ol cristianoutique, ta to spasbatic perdón me tsc'anique. Yan li boch'o chopol chc'opoj ta stojol Ch'ul Espíritue mu'yuc ta spasbatic o perdón. ");
INSERT INTO tzotze_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’C'alal cha'ac'atic ta sc'ob jchapanvanejetic ta nail tsobobbailetique, mu me xlo'ilaj avo'ntonic ta sventa li c'usi chc'ot avalique xchi'uc ti c'uxi chatac'ovique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ch'ul Espíritu ta xac'boxuc ana'ic c'usi chavalic ti c'alal tey xa oyoxuque ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oy jun vinic tey cacal ta o'lol cristianoetic, jech laj yalbe li Jesuse: ―Jchanubtasvanej, albo jbanquil ti ac'o svoc'bun li yosil ánima jtotcutique, xchi'uc noxtoc li c'usitic oy yu'une ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Li Jesuse jech laj yalbe: ―Tata, muc ochemucun ta jchapanvanej avu'unic. Ma'uc cabtel ta jchapanoxuc ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Li Jesuse jech laj yalbe ya'i scotolic: ―Q'uelo me abaic, mu me xpich'aj avo'ntonic yu'un li c'usitic oy li' ta banamile. Yu'un manchuc me ep chataic pero mu xataic o xcuxetel avo'ntonic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Li Jesuse jech la sloc'ta ta lo'il: ―Oy jun vinic lec jc'ulej. Lec laj yac' scotol li c'usitic la sts'une. ");
INSERT INTO tzotze_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jech la snop: “¿C'uxi ta xcut? Mu xa jna' bu chcac' li c'usitic iloc' cu'une”, xi ta yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ts'acal to jech la snop: “Ta jna' xa c'usi ta jpas. Ja' ta jvuq'uesbe snail ti bu cac'oj c'usitic oy cu'une, ta jpas yan más muc'. Ja' tey ta xcac' scotol li c'usitic oy cu'une. ");
INSERT INTO tzotze_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Me la stsob sba cu'un scotole, ts'acal xu' jech chcal ta co'nton: Oy xa ep jve'el ta sventa ep jabil jech xu' ta jcux co'nton. Yu'un laj xa jta scotol li c'usitic ta sc'an co'ntone. Xu' ta jve', xu' ta xcuch' jech xcuxet no'ox co'nton, xu' xichi”, xi la snop li vinique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","C'alal jech snopoj tspase, jech i'albat yu'un li Diose: “¡Vo'ote muc bijucot! Ta ac'ubaltic tanae chacham. Li c'usitic oy avu'une ¿boch'o chavac'be comel?” x'utat. ");
INSERT INTO tzotze_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ja' jech sc'oplal li boch'o ja' no'ox tsc'an ta stsob ep sc'ulejal stuque. Ta stojol Diose me'on ch‑ilat ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Chacalboxuc ava'yic, mu me xlo'ilaj avo'ntonic ta sventa c'u x'elan chacuxiic li' ta banamile, ja' ti bu chata ave'elique xchi'uc ti bu chata ac'u'ique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yu'un ja' laj yac'boxuc abec'talic li Diose xchi'uc ja' laj yac' ti cuxuloxuque. Jech noxtoc ja' chayac'boxuc ac'u'ic xchi'uc ave'elic. ");
INSERT INTO tzotze_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Q'uelavilic li jojetique. Mu sna' x'ovolajic, mu sna' xc'aojic, mu'yuc snail li sve'elique. Ja' mac'linbilic yu'un li Diose. Pero li vo'oxuque más to ech'em chaxc'uxubinoxuc li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Altic ti chlo'ilaj avo'ntonic yu'une. Mu yu'unuc jech ta xnatub jutuc avorailic li' ta banamil ti jech chapasique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Me jutuc mu'yuc c'usi xu' avu'unic. Jech altic chlo'ilaj avo'ntonic ta sventa li c'usitic chtun avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Q'uelavilic li nichimetic ti ch'iemic ta yaxaltique. Mu sna' x'abtejic, mu sna' sjal sc'u'ic, pero lec c'upil sbaic ta q'uelel. Chacalboxuc ava'yic, li Salomón ta vo'onee toj jc'ulej. Lec c'upilic sba li sc'u' spoq'ue, pero muc xco'laj xchi'uc jech chac c'u cha'al slequil li nichimetique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Li ts'i'laletique lec c'upilic sba xyaxal, pero ta yoc'omal xcha'ejale taquinic xa'ox. Jech ja' xa ta xtun ta sventa ta xc'ac'ub orno yo' bu ta xta'aj pan. Ac'o me mu'yuc jal ta xch'i pero lec c'upilic sba xyaxal pasbilic yu'un li Diose. Li vo'oxuque más to ech'em lec chayac'boxuc ac'u'ic li Diose. Pero mu to jechuc ach'unojic. ");
INSERT INTO tzotze_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jech mu me xlo'ilaj avo'ntonic ta sventa li c'usi chave'ique xchi'uc li c'usi chavuch'ique. Mu me c'usi xlo'ilaj avo'ntonic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Li boch'otic mu to xotquinic Diose ja' jech tsnop ta yo'ntonic. Pero li Jtotic Dios ta vinajele sna'oj scotol li c'usitic ta xtun avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jech tsc'an ti chavac' abaic ta ventainel yu'un Diose, jech chayac'boxuc scotol li c'usitic ta xtun avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ac'o me mu'yuc epoxuc, ac'o me mu'yuc c'usi xu' avu'unic pero mu me xaxi'ic. Yu'un li Diose slequil yo'nton snopoj ti co'ol chapas mantal achi'uquique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chono li c'usitic oy avu'unique. Li stojole ac'beic me'onetic jech ch‑epaj ac'ulejalic tey ta vinajel. Mu sna' xlaj sbatel osil, yu'un teye mu'yuc j'elec' xchi'uc mu'yuc chon ti xu' chc'uxate. ");
INSERT INTO tzotze_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yu'un me ja' tey tsobol ac'ulejalique, ja' tey batem avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Chapalucoxuc me, aq'uic me ta ilel scotol c'ac'al ti amalaojic chtal li Avajvalique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ja'uc me jechoxuc jech chac c'u cha'al mozoetic ti smalaojic c'uxi ora ta sut tal li yajvalic ti batem ta q'uin nupinele. C'alal ta xc'ot c'opojuque, ta ora ta sjambeic sna yu'un ac'o ochuc li yajvalique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Li mozoetic ti viq'uil sat ta xc'ot taaticuc yu'un yajvalique, xcuxet no'ox yo'ntonic. Melel li c'usi chacalboxuque, li mozoetic ti viq'uil sat ta xc'ot taaticuque, ta x'albat yu'un yajvalic ti ac'o bat chotiicuc ta mesae, yu'un ta x'ac'bat sve'elic yu'un li yajvalique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Manchuc me ta o'lol ac'ubal, me ta po'ot sac ta xc'ot, me jech tey viq'uil o sat ta xc'ot taaticuc yu'un li yajvalique, lec ta x'ilatic yu'un li yajvalique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na'ic me, jech chac c'u cha'al yajval na ti mu sna' me oy ta xtal j'elec' ta ac'ubaltique. Ti sna'ojuque, muc xvay ti jechuque. Mu'yuc c'usi xbat ta elec' yu'un ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ja' no'ox jechoxuc ec li vo'oxuque, tsc'an ti lec chapaloxuque. Yu'un mu xana'ic c'usi ora chital, vu'un ti co'ol cristianoutique. Mu me ch'ayemuc avo'ntonic chvul jtaoxuc ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Li Pedroe jech la sjac'be li Jesuse: ―Cajval, li lo'il laj avale, ¿me jtuc no'ox jc'oplalcutic o me ja' sc'oplalic ec li yantic li' oyique? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Li Cajvaltique jech laj yal: ―Ja' sc'oplal scotol li boch'otic tsc'an chtunic cu'une. Li boch'o lequil mozoe jun yo'nton tey ta x'abtej ta stojol li yajvale. Ta x'ilat yu'un yajval ti lec bije, jech ta x'ac'bat yabtel yu'un ta smac'lin xchi'iltac ta abtel ti c'alal yorail ta xve'ique. ");
INSERT INTO tzotze_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xcuxet no'ox yo'nton li mozo ti jech jun yo'nton sbats'il spasel c'alal chvul taatuc yu'un yajvale. ");
INSERT INTO tzotze_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Melel li c'usi chacalboxuque, li boch'o jun yo'nton ta x'abteje ta x'ac'bat sventain scotol li c'usitic oy yu'un yajvale. ");
INSERT INTO tzotze_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero me jech chlic yal ta yo'nton li mozoe: “Mu to van xtal ta ora li cajvale”, me xie, jech ta xlic yuts'intaan li xchi'iltac ta abtel ac'bil sventaine. Ja' chbat xchi'in ta ve'el li boch'o lec sc'opan sba xchi'uque, co'ol ta xchi'in sbaic ta yacubel. ");
INSERT INTO tzotze_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Li yajvale ja' o ta xtal ti c'alal mu'yuc ta yo'nton ta smalae yu'un mu xch'un ti po'ot xa chtale. Tsots chvul ac'batuc castigo yu'un li yajvale. Ja' chbat xchi'in li boch'otic co'ol mu xch'unic mantal xchi'uque. ");
INSERT INTO tzotze_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Li mozo ti sna' c'usitic tsc'an yajvale pero mu spasbe, jech ta xich' tsots castigo. ");
INSERT INTO tzotze_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yan li boch'o mu sna' c'usitic tsc'an yajvale xchi'uc mu sna' me ta xich' castigo ta sventa li c'usitic ta spasilane, ja' jutuc no'ox ta xich' castigo. Li boch'o ch‑ac'bat ep sbijil yu'un yajvale yu'un tsc'an ti ep ac'o abtejuc yu'une. ");
INSERT INTO tzotze_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Li vu'une xco'laj xchi'uc tal cac' c'oc' ya'yel li' ta banamile. Yu'un vu'un ta jventa chlecubic li boch'otic ta xch'un ti vu'un Jcoltavanejun yu'unique. Li boch'otic mu sc'an xch'unique ta soquic o. Jech soquem sjolic ta jtojol li' ta orae. ");
INSERT INTO tzotze_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero más to ep ta xquich' vocol. Ti c'otemuc xa ta pasel scotol li c'u yepal sc'oplal chquich'e, mu xa jnopilan ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Me chanopic ti lital yu'un jech chco'laj yo'nton li cristianoetic li' ta banamile? Jamal chacalboxuc, mu yu'unuc tal jco'lajesbe yo'ntonic. Vu'un ta jventa chlic scontrain sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yu'un ta to xc'ot ta pasel cha'voc' ta xc'otic li boch'otic vo'ob oyic ta jbej snaique. Chib lec chiyilun, oxib chopol chiyilun, o me oxib lec chiyilun, chib chopol chiyilun. ");
INSERT INTO tzotze_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vu'un ta jventa chlic scontrain xnich'on li totile. Oy chlic scontrain stot li nich'onile. Oy chlic scontrain stseb li me'ile. Oy chlic scontrain sme' li tsebe. Oy chlic scontrain yalib li me'el alibale. Oy chlic scontrain sme'el'alib li alibale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Li Jesuse jech laj yalbe noxtoc li epal cristianoetique: ―C'alal chavilic ta xloc' tal toc ta smaleb c'ac'ale, jech chavalic: “Ta xa xtal vo'”, xachiic. Ta melel ta xtal li vo'e. ");
INSERT INTO tzotze_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","C'alal chava'yic ta xtal ic' ta xocon vinajel ta sure, jech chavalic: “Toj c'ux c'ac'al tana”, xachiic. Ta melel c'ux li c'ac'ale. ");
INSERT INTO tzotze_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jlo'lavanejoxuc. Xana'ic sq'uelel senyail ta vinajel xchi'uc senyail ta banamil, pero mu xana'ic sq'uelel avalojic li c'usi c'otem xa ta pasel ta atojolic li' ta orae. ");
INSERT INTO tzotze_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿C'u yu'un mu xana'ic li c'usi tuc' ta pasele? ");
INSERT INTO tzotze_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Me oy laj ata amul ta stojol achi'ilique, tsc'an chachapanic ta ora no'ox. Yu'un me mu jechuc chapasique, oy amulic ta stojol li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chacalboxuc, me mu xapasic jech chac c'u cha'al laj calboxuque, chayac'boxuc castigo li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ta sc'ac'alil no'ox ti c'alal tey to stsoboj sbaique, oy boch'otic laj yalbeic Jesús c'u x'elan imilat jayibuc israeletic liquemic tal ta Galilea. Ja' ti i'ac'atic ta milel yu'un Pilato tey ta yamaq'uil templo ta Jerusalén ti c'alal ja' o tey tsmilbeic smoton Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Li Jesuse jech laj yalbe: ―¿Me chanopic ti mu'yuc yan jchi'iltic ta Galilea ta vo'one xchi'uc c'alal to tana ti más ep smulic jech chac c'u cha'al más ep smul acuyojic li jchi'iltactic imilatic chavalique? ");
INSERT INTO tzotze_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chacalboxuc, mu jechuc li c'usi chanopique. Co'ol ono'ox ch'ayel chabat achi'uquic me mu xacomtsanic ec li c'usitic chopol chapasique. ");
INSERT INTO tzotze_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Li vaxaclajuneb (18) ichamic ti c'alal ilom yalel li na sventa q'uelub osil tey ta nopol stanqueal vo' Siloée, ¿me chanopic ti mu'yuc yan jchi'iltic ta Jerusalén ta vo'one xchi'uc c'alal to tana ti más ep smulic jech chac c'u cha'al más ep smul acuyojic li jchi'iltactic ti ichamique? ");
INSERT INTO tzotze_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chacalboxuc, mu jechuc li c'usi chanopique. Co'ol ono'ox ch'ayel chabat achi'uquic me mu xacomtsanic ec li c'usitic chopol chapasique ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Li Jesuse la sloc'ta jech chac c'u cha'al jpets igo li israeletique. Jech laj yal: ―Oy jun vinic sts'unoj jpets igo ta ts'usubaltic yu'un. Ts'acal bat sq'uel me oy sat li igo sts'unoje, pero mu'yuc sat la sta. ");
INSERT INTO tzotze_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jech laj yalbe li jchabiejts'usub yu'une: “Li igo li'i yoxibal xa jabil li' chvul jq'uelilan me oy ta satin. Pero mu'yuc ta satin. Ja' lec ts'eto, yu'un altic li' smacoj banamil”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Itac'ov li jchabiejts'usub yu'une: “Cajval, li' to oyuc junuc jabil. Ta jlocbe lec ta joyob li yibele. Ta xcac'be lec xyaxal. ");
INSERT INTO tzotze_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Me jech ta jpase, ta van xlic satinuc. Me mu satine, ja' to xu' chats'et”, xi li jchabiejts'usub yu'une ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ta yan c'ac'al ichanubtasvan Jesús ta yut nail tsobobbail. Ja' sc'ac'alil ta xcux yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tey oy jun ants vaxaclajuneb (18) xa jabil stsaquel ta chamel yu'un isoquesbat sbaquil yu'un pucuj. Jech xcujcun ta xanov. Me jutuc mu xu' tuc' tsva'an sba. ");
INSERT INTO tzotze_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Li Jesuse laj yil li antse, laj yic' tal ta stojol. Jech laj yalbe: ―Yaa, chacol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Li Jesuse laj yac' sc'ob ta sbec'tal li antse jech ta ora ituq'uib li sbaquile, lic yal slequilal Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Li banquilal tey ta nail tsobobbaile i'ilin ti c'alal icoltavan Jesús ta sc'ac'alil ta xcux yo'ntonique. Jech lic yalbe li xchi'iltaque: ―Oy vaquib c'ac'al xu' chij'abtejutic. Ta sc'ac'alil ti xu' chij'abtejutique ja' o xatalic me chac'anic coltaele. Mu me xatalic ta sc'ac'alil ta jcux co'ntontic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Li Cajvaltique jech laj yal: ―Jlo'lavanejoxuc. Li jujunoxuque ¿me mu xatitun batel avacax, o me aca', ta sc'ac'alil ta jcux co'ntontic yu'un ac'o bat yuch'ic yoxo'? ");
INSERT INTO tzotze_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Li ants li'i ti xvaxaclajunebal xa jabil stsaquel ta chamel yu'un li Satanase, ja' jchi'iltic, pero chopol laj ava'yic ti la jcolta ta sc'ac'alil ta jcux co'ntontique ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","C'alal jech laj yal li Jesuse, iq'uexov scotol li boch'otic chopol chilic li Jesuse. Pero ep cristianoetic xcuxet no'ox yo'ntonic yu'un laj yilic ti toj lec scotol c'usitic la spas li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Li Jesuse jech laj yal jun lo'il: ―Chacalboxuc ava'yic c'u x'elan tsventainan cristianoetic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ac'o me mu'yuc ep boch'o tsventain ta ora pero ts'acal chlic epajuc. Ja' jech chac c'u cha'al biq'uit bec' mostaza la sts'un ta yosil jun vinic pero nat ibat. Ep laj yac' sc'ob noxtoc. Jech ital mutetic, la spas stasic ta sc'obc'ob ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jech laj yal yan lo'il noxtoc li Jesuse: ―Chacalboxuc ava'yic c'u x'elan tsventainan cristianoetic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oy lec stsatsal jech chac c'u cha'al svolesubil xch'ut pan. Ac'o me jutuc no'ox chac' ta vaquib cuartiya arina li antse pero lec chvol o xch'ut scotol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Li Jesuse ixanov batel ta be yu'un chbat ta Jerusalén. I'ech' chanubtasvanuc ta scotol lumetic xchi'uc ta scotol tsobtsobnaetic ti bu ijelove. ");
INSERT INTO tzotze_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oy boch'o jech la sjac': ―Cajval, ¿me atbil no'ox li boch'otic ta xcolique? ―xi. Itac'ov li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Biq'uit li sbelal vinajele. Ep li boch'otic tsc'an ta x'ochique pero chacalboxuc mu xu' yu'unic. Yu'un ja' no'ox xu' ta x'och li boch'otic tsbic'tajes sbaic ta stojol Diose. Jech biq'uit me xavac' abaic. ");
INSERT INTO tzotze_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jech chac c'u cha'al me laj xa smac ti'na li yajval nae, me ts'acal to ta xtal atijic ti'nae, jech chavalbeic: “Cajval, Cajval, jambuncutic li ti'nae”, xavutic. Pero jech chayalboxuc li yajval nae: “Mu cu'unucoxuc”, xayutoxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jech chavalbeic: “La jchi'inotcutic ta ve'el, laj achanubtasuncutic ta calletic cu'uncutic”, xavutic. ");
INSERT INTO tzotze_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jech ta xalboxuc: “Laj xa calboxuc ti mu cu'unucoxuque. Batanic, mu xajc'anoxuc yu'un puro chopol li c'usitic laj apasic”, xayutoxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","Ta to xavilic ti tey xa ochemic yo' bu ta spas mantal Dios li jmoltotic ta vo'onee, ja' li Abraáme, xchi'uc li Isaaque, xchi'uc li Jacove, xchi'uc scotol li yaj'alc'optac Diose. Xchi'uc ep yan lum cristianoetic tey oyic ti liquemic ta sbejel banamile. Xcuxet no'ox yo'ntonic. Li vo'oxuque tey cha'oq'uic, tey chavat avo'ntonic ta sventa ti mu xa xu' cha'ochique. ");
INSERT INTO tzotze_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A'yo ava'yic, oy boch'otic its'inal ta x'ilatic li' ta orae ja' banquilal ta xc'otic yu'un biq'uit laj yac' sbaic. Pero oy boch'otic banquilal ta scuy sbaic li' ta orae ja' its'inal ta xc'otic yu'un la stoy sbaic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta ora ital jayibuc fariseoetic. Jech laj yalbeic li Jesuse: ―Loc'an batel yu'un tsc'an ta smilot li Erodese ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Li Jesuse jech laj yalbe: ―Li Erodese ja' jech chac c'u cha'al jcot vet yu'un tsc'an chmilvan. Batanic, jech xc'ot avalbeic: “Li' ta orae xchi'uc oc'ome ta to la sloq'ues pucujetic, ta to la scolta jchameletic. Cha'ej la ta xlaj yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tsots la sc'oplal ta xanov batel li' ta orae xchi'uc oc'om cha'ej. Yu'un tey ono'ox la chmilat ta Jerusalén jech chac c'u cha'al tey imilatic li yan yaj'alc'optac Diose, xi laj yal tal”, utic c'otel. ");
INSERT INTO tzotze_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Vo'oxuc xchi'uc scotol li achi'iltac tey ta Jerusalene, atalelic o ti chamilic li yaj'alc'optac Diose. Chavac'beic ton li boch'otic tacbilic tal yu'un Dios ta atojolique. Pero ep xa velta la jc'an ta jtsoboxuc jech chac c'u cha'al ta stsob yol ta yolon xic' jcot me'caxan, pero muc xac'anic. ");
INSERT INTO tzotze_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A'yo ava'yic, ta me xacom atuquic. Mu'yuc xa ta xchi'inoxuc li Diose. Jech chacalboxuc, mu'yuc xa bu chavilicun o. Ja' to me la sta sc'ac'alil jech chavalique: “Toj lec li boch'o tacbil tal yu'un Cajvaltic Diose”, me xachiique, ja' to xu' chavilicun yan velta ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","C'alal ja' o sc'ac'alil ta xcux yo'ntonic li israeletique, li Jesuse i'ic'at batel ta ve'el yu'un jun banquilal fariseo. Li yan xchi'iltac ta fariseoale tey talemic ec yu'un ta sq'uelic c'usitic ta spas li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","C'alal i'och ta na li Jesuse, tey la sta jun vinic situben scotol sbec'tal. ");
INSERT INTO tzotze_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Li Jesuse jech la sjac'be li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li fariseoetique: ―¿Me xu' chijcoltavan ta sc'ac'alil ta jcux co'ntontique? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Muc xtac'ovic. Li Jesuse la scolta li vinique, laj yalbe noxtoc ti ac'o batuque. ");
INSERT INTO tzotze_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Li Jesuse jech la sjac'be li fariseoetique: ―Li vo'oxuque, me ta x'och ta vomlum jcot aburroic o me jcot avacaxic ta sc'ac'alil ta jcux co'ntontique, ¿me mu'yuc ta xbat aloq'uesic ta ora? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Muc xtac'ov ic'otic ti c'alal jech laj yal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","C'alal laj yil Jesús ti scotolic tsc'an co'ol ta xchotiic ta sliqueb chotlebal ti c'u yepal ic'bilic ta ve'ele, jech la sloc'ta ta lo'il: ");
INSERT INTO tzotze_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Me oy boch'o chayic'oxuc ta sq'uelel q'uin nupinele, mu me xbat achotan abaic ta ora ta sliqueb chotlebal naca me oy boch'o lec ich'bil ta muc' ti ic'bil tal ta q'uelq'uine. ");
INSERT INTO tzotze_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jech ta xlic yalboxuc li boch'o i'ic'vane: “Loc'an yu'un ja' li' ta xchoti li jchi'iltic li'i”, xayutoxuc. Jech chaq'uexovic xa ti c'alal chaloq'uic batel, chbat chotlanic ta slajeb chotlebale. ");
INSERT INTO tzotze_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","C'alal cha'ic'atic ta ve'ele, ja' lec bat chotlanic ta slajeb chotlebal. C'alal ta xtal li boch'o laj yic'oxuque, jech ta xlic yalboxuc: “Tata, li' xatal ta sliqueb chotlebale”, xayutoxuc. Jech scotol li boch'otic tey co'ol chachotiic ta ti' mesa achi'uque chilic ti ich'biloxuc ta muq'ue. ");
INSERT INTO tzotze_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yu'un li boch'otic tsc'an ich'bilic ta muq'ue ta x'ac'atic ta q'uexlal yu'un li Diose. Yan li boch'otic biq'uit ta xac' sbaique ja' ta x'ac'atic ta ich'el ta muc' yu'un li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Li Jesuse jech laj yalbe ec li boch'o i'ic'van ta ve'ele: ―C'alal cha'ic'van ta ve'ele, mu me ja'uc no'ox xavic' li boch'otic lec xac'opan aba achi'uque, xchi'uc li achi'iltac ta voq'uele, xchi'uc li avuts' avalaltaque, xchi'uc li boch'otic noch' nacaloxuc achi'uc ti jc'ulejique. Yu'un naca me ta xlic yic'ot ta ve'el ec jech xu' ta spacbot ti laj avic' ta ve'ele. ");
INSERT INTO tzotze_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","C'alal cha'ic'van ta ve'ele, ja' xavic' li boch'otic me'onetique, xchi'uc li boch'otic motmot sc'obic o me motmot yacanique, xchi'uc li boch'otic coxoetique, xchi'uc li boch'otic ma'satetique. ");
INSERT INTO tzotze_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jech chayac'bot bendición li Diose yu'un mu xu' yu'unic spaquel. Xchi'uc chavich' atojol ti c'alal co'ol chacha'cuxiic achi'uc li boch'otic tuc' yo'ntonique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","C'alal jech laj ya'yic li boch'otic tey co'ol ta xve'ic ta mesa xchi'uc li Jesuse, oy jun boch'o jech laj yalbe li Jesuse: ―Xcuxet no'ox yo'ntonic li boch'otic jech ta xchi'inic ta ve'el c'alal chtal spas mantal li boch'o t'ujbil yu'un Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Li Jesuse jech laj yalbe: ―Oy jun vinic laj yac' ve'lil. La stac ta iq'uel ep cristianoetic yu'un ac'o tal ve'icuc. ");
INSERT INTO tzotze_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","C'alal sta yorail ta xve'ique, la stac batel smozo yu'un ac'o bat yic' tal li boch'otic yalanojbe xa ono'oxe. Jech laj yalbe batel: “Bat albo li boch'otic calanojbee ac'o talicuc scotolic yu'un imeltsaj xa li ve'lile”, xut batel li smozoe. Ja' jech c'ot yal li smozoe. ");
INSERT INTO tzotze_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero scotolic laj yalic ti oy bu chbat scuyojique. Li june jech laj yal: “Mu xu' cu'un chibat yu'un ja' to la jman cosil jech tsots sc'oplal chbat jq'uel. Avocoluc albo ac'o spasbun perdón”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Li yane jech laj yal: “Mu xu' cu'un chibat yu'un ja' to la jman lajuncot jvacax, ja' ta cha'cha'cot chi'abtej jchi'uc. Ja' chbat jq'uel me lec x'abtejique. Avocoluc albo ac'o spasbun perdón”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Li yane jech laj yal: “Mu xu' cu'un chibat yu'un ja' to linupin”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","C'alal isut tal li mozoe, vul yalbe yajval li c'usitic laj yalic jujunique. Li yajval ve'lile i'ilin. Jech laj yalbe li smozoe: “Batan ta anil tey ta ch'ivit xchi'uc ta calletic li' ta lume. Ja' ic'ano tal li me'onetique, xchi'uc li boch'otic motmot yacanic o me motmot sc'obique, xchi'uc li boch'otic coxoetique, xchi'uc li boch'otic ma'satetique”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Li mozoe la xch'un c'usi i'albat yu'un li yajvale, ts'acal to jech tal yalbe: “Cajval, laj xa jch'un scotol li c'usi laj avalbune, ital xa cu'un. Pero oy to mu'yuc yajval li ve'lile”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Li vinique jech laj yalbe li smozoe: “Batan xa ta bebetic xchi'uc ta sbelal trigoaltic, ic'ano tal ta persa li boch'otic chatae yu'un ac'o nojuc li jnae. ");
INSERT INTO tzotze_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chacalbot, scotol li boch'otic ba'yuc laj calbe ti ac'o tal ve'icuque, me junuc mu'yuc xa ta xcac'be spas ya'yic c'u x'elan li ve'lile”, xi li yajval ve'lile ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","C'alal ixanov batel li Jesuse, ichi'inat batel yu'un epal cristianoetic. Li Jesuse ijoyij, jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Boch'o tsc'an chixchi'inune ja' tsc'an ti vu'un más tsots sc'oplal cha'i chisc'anune. Ja' tsc'an ti ja' mu'yuc tsots sc'oplal cha'i li stot sme'e, xchi'uc yajnil, xchi'uc xnich'nab, xchi'uc sbanquiltac, xchi'uc yits'inabtac, xchi'uc xvixubtac, xchi'uc yixlaltac. Tsc'an noxtoc ti mu'yuc tsots sc'oplal cha'i ti c'u x'elan chcuxi li' ta banamile. Ja' no'ox jech xu' chixchi'inun o. ");
INSERT INTO tzotze_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Boch'o junucal mu sc'an xich' vocol jech chac c'u cha'al chquich' vocole mu xu' chixchi'inun. ");
INSERT INTO tzotze_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jech chac c'u cha'al me oy boch'o tspas jbej muc' sna ep ta coj sjole, ba'yuc ta snop c'u yepal taq'uin ta xlaj yu'un ta scotol. Ta snop noxtoc jaycoj ta spas, yu'un ta snop me xvu' yu'un ti c'u smuc'ul ta spase. ");
INSERT INTO tzotze_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yu'un me mu snop lec ba'yuque, c'alal me laj xa sliquesbe snaclebe, ts'acal cha'i ti mu xvu' yu'une jech ta xquechan. Jech ta xlic labanatuc yu'un scotol li boch'otic ta xilique. Jech ta xalic: ");
INSERT INTO tzotze_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Q'uelavil li vinique, la sliques spasel li snae pero muc xvu' yu'un”, xi sc'oplal. ");
INSERT INTO tzotze_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jech noxtoc, me oy jun ajvalil ta xbat spasic pleito xchi'uc yan ajvalile, ba'yuc ta snop me stsal yu'un yajcontra ti ta lajunmil no'ox yajsoldado ti ja' jtob ta mil yajsoldado li yajcontrae. ");
INSERT INTO tzotze_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Me cha'i ti mu xu' yu'une, c'alal nom to xtal li yajcontrae, ta stac batel xchi'il ta abtel yu'un ac'o bat slequilc'opan li yan ajvalile yu'un ac'o co'lajuc yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ja' no'ox jech ec li vo'oxuque, me oy boch'o mu xu' yu'un ta scomtsan scotol li c'usitic oy yu'une, mu xu' chixchi'inun o. ");
INSERT INTO tzotze_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Jech chac c'u cha'al ats'am ti lec xtun cu'untique, pero me ch'ayem xa xchi'ile, mu'yuc xa c'usi stu o, yu'un mu xa xchi'ub yan velta. ");
INSERT INTO tzotze_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pero me chi' toe, ta xtun ta sventa ve'lil. Ta xtun noxtoc ta sventa xyaxal banamil, xu' ta jcaptic ta tso' vacax. Pero me ch'ayem xa xchi'ile, mu'yuc xa c'usi stu o. Ac'o me ta xyaxal banamil mu xa xtun. Jipel xa chbat o. Ja' no'ox jech ec li boch'otic ta sc'an chixchi'inicune, me mu j'ech'eluc jun yo'ntonic ta jtojole, mu'yuc stuic o cu'un. Boch'o laj ya'i ac'o snopbe lec smelol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","La stsob sbaic tal ta stojol Jesús jpasmuliletic xchi'uc jtsobpatanetic yu'un tsc'an ta xa'ibeic sc'op li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc li fariseoetique chopol laj yilic. Jech laj yalic: ―Li vinic li'i ja' ta xic'an ta stojol li boch'otic chopol c'usitic tspasique. Ta xchi'in ta ve'el noxtoc ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Li Jesuse jech laj yalbe jun lo'il: ");
INSERT INTO tzotze_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿C'usi chanopic? Me oy jun vinic oy vo'vinic (100) ta cot xchije, pero me ich'ay comel jcotuque, ¿me mu teyuc ta scomtsan yo' bu oy lec sve'elic li balunlajuneb yo'vinic (99) ta cote yu'un ja' chbat st'un tal li jcot ich'ay comele? ");
INSERT INTO tzotze_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","C'alal me la sta li jcote, xcuxet xa yo'nton ta scajan tal ta snecub. ");
INSERT INTO tzotze_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","C'alal chvul ta snae, ta xic' tal scotol li yuts' yalaltaque xchi'uc li boch'otic noch' nacalic xchi'uque, jech ta xalbe: “Cuxetuc me avo'ntonic yu'un laj xa jta li jcot jchij ich'ay comele”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chacalboxuc, ja' no'ox jech ec li Diose, xcuxet no'ox yo'nton yu'un ti c'u yepal oy ta stojole. Pero más to xcuxet yo'nton xchi'uc yaj'almantaltac me oy to jun cristiano ta scomtsan c'usitic chopol tspase. ");
INSERT INTO tzotze_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Me oy jun ants oy lajuneb dracma staq'uine, me ta xch'ay junuc yu'une, ¿me mu tstsan stoj xchi'uc me mu tsmes lec sna yu'un ta st'un lec li jun dracma ich'ay yu'une? ");
INSERT INTO tzotze_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Me la stae, ta xic' tal scotol li yuts' yalaltaque xchi'uc li boch'otic noch' nacajtic xchi'uque, jech ta xalbe: “Cuxetuc me avo'ntonic yu'un laj xa jta li jun dracma jtaq'uin ich'ay cu'une”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jech chacalboxuc, ja' no'ox jech ec li Diose, xcuxet yo'nton xchi'uc yaj'almantaltac me oy to jun cristiano ta scomtsan c'usitic chopol tspase ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Li Jesuse jech laj yal noxtoc: ―Oy jun vinic chib xnich'on. ");
INSERT INTO tzotze_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Li its'inale jech laj yalbe li stote: “Tati, ac'bun ti c'u yepal anopoj chavac'bune”, xut. Li totile lic svoc'be ti c'u yepal tsc'an ta xac'be jujun xnich'one. ");
INSERT INTO tzotze_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","C'alal i'ech' chib oxib c'ac'ale, li its'inale la stsob scotol li c'usitic oy yu'une, iloc' batel, ibat ta yan banamil. Tey c'ot slajes scotol li c'usitic oy yu'une yu'un ja' ibat yo'nton yu'un li c'usitic tsc'an sbec'tale. ");
INSERT INTO tzotze_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","C'alal ilaj scotol li staq'uine, ital tsots vi'nal ti bu nacale. Jech laj ya'i vi'nal. ");
INSERT INTO tzotze_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jech ibat ta mozoil ta sna jun vinic ti tey no'ox noch' nacale. Li vinique lic spas ta mantal li quereme, la stac batel ta chabichitom. ");
INSERT INTO tzotze_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Li quereme chvi'naj ta jyalel jech chac sve' ya'i li pat cheneq'ue, ja' li sve'el chitometique. Pero muc x'ac'bat sve' yu'un li yajvale. Mu'yuc c'usi i'ac'bat o. ");
INSERT INTO tzotze_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","C'alal jech oy svocol ta vi'nale, jech lic snopilan: “Oy ep smozo li jtote pero lec noj xch'ut scotolic. Oy to chcom yu'unic. Li vu'une ta xa xilaj ta vi'nal. ");
INSERT INTO tzotze_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ja' más lec chbat jchi'in yan velta li jtote. Jech ta xc'ot calbe: “Tati, laj xa jta jmul ta stojol li Diose xchi'uc la jta jmul ta atojol ec. ");
INSERT INTO tzotze_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ja' lec mu xa xacuyun ta anich'on. Amozoun xa no'ox chic'ot, xcut c'otel”, xi la snop ta yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jech isut batel ta sna li stote. ’C'alal nom to'ox x'ech' batele, i'ilat yu'un li stote. Li totile laj yil ti isut tal li xnich'one. Xcuxet xa yo'nton bat snup ta be ta ora, la smey, la sts'uts'. ");
INSERT INTO tzotze_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jech i'albat yu'un li xnich'one: “Tati, laj xa jta jmul ta stojol li Diose xchi'uc la jta jmul ta atojol ec. Ja' lec mu xa xacuyun ta anich'on”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","C'alal jech i'albat yu'un li xnich'one, mu jechuc la snop li totile. Jech laj yalbe li smozotaque: “Ich'ic tal ta ora li c'u'il bu toj leque, ac'beic slap. Ac'beic yixtolal sc'ob xchi'uc xonob. ");
INSERT INTO tzotze_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iq'uic tal li ch'ium vacax ti bu lec xa juben cu'untique. Milic jti'tic. Yu'un ta jpastic q'uin. ");
INSERT INTO tzotze_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","La jnop ti chamen xa li jnich'one. Li' ta orae icha'cuxi xa tal ya'yel. Yu'un vo'one xa xch'ayel. Li' ta orae laj xa jta”, xi. Jech lic spasic lec q'uin. ");
INSERT INTO tzotze_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’C'alal ic'ot li its'inale, mu'yuc tey oy li banquilale yu'un batem ta abtel. C'alal isut tale, tey xa nopol x'ech' tal ta sts'el sna, laj ya'i ti ta spasic q'uin li stote. Laj ya'i ti ch‑ac'otajique. ");
INSERT INTO tzotze_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Laj yic' loq'uel jun smozoic, la sjac'be c'usi sventa li q'uin ta spasique. ");
INSERT INTO tzotze_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jech i'albat: “Yu'un isut tal li avits'ine. Li atote la smil li ch'ium vacax ti bu lec xa juben cu'untique, ja' sventa ti lec isut tal li avits'ine”, x'utat. ");
INSERT INTO tzotze_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","C'alal jech laj ya'i li banquilale, i'ilin. Muc sc'an x'och ta sna. C'alal laj ya'i li stote, iloc' yalbe ti ac'o ochuque. ");
INSERT INTO tzotze_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Li banquilale jech laj yalbe li stote: “Ep xa jabil li'abtej avu'un. Mu'yuc la jbaj amantal. Pero mu'yuc c'usi avac'ojbun. Me jcotuc tentsun, mu'yuc avac'ojbun ti jech xu' ta jpas o q'uin jchi'uc li boch'otic lec jc'opan jba jchi'uque. ");
INSERT INTO tzotze_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero c'alal isut tal li yan anich'one, ta ora laj amil li ch'ium vacax ti bu lec xa juben cu'untique yu'un laj apasbe sq'uinal ti isut tale. Pero ep jmulavil antsetic imulivaj xchi'uc, jech tey ilaj o scotol li c'usi laj avac'bee. Pero ja' c'ux ta avo'nton”, xut li stote. ");
INSERT INTO tzotze_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Itac'ov li stote: “Mol, li vo'ote scotol c'ac'al li' jchi'uc jbatic. Scotol li c'usitic oy cu'une ja' avu'un ec. ");
INSERT INTO tzotze_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ja' tsc'an ti jech ta jpastic q'uine xchi'uc ti xcuxet co'ntontique yu'un icha'cuxi xa tal ya'yel li avits'in ti chamen calojtique. Yu'un vo'one xa xch'ayel pero isut xa tal”, xut ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Li Jesuse jech laj yalbe yan lo'il li yajchanc'optaque: ―Oy jun vinic, lec jc'ulej. Oy jchabina yu'un. Ja' yac'ojbe sventain scotol c'usitic oy yu'un xchi'uc staq'uin. Li jchabinae bat albatuc smul ta stojol li yajvale. Li smul i'albate yu'un la slajesbe c'usitic oy yu'un li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Li vinique laj yic' tal li jchabina yu'une, jech laj yalbe: “Laj ca'i ti chopol c'usi chapase. Jech albun c'u yepal laj achon xchi'uc c'u to yepal tey oy avu'un li c'usitic laj cac'bot aventaine, yu'un mu xa xu' chachabibun jna”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Li jchabinae jech la snop: “¿C'uxi chive' yu'un chisloq'uesun ta chabina li cajvale? Mu xu' cu'un abtel. Chiq'uexov noxtoc me ta jc'an limosnae. ");
INSERT INTO tzotze_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ta jna' xa c'usi ta jpas c'alal me liloc' ta chabinae yu'un jech oy boch'o chixc'uxubinicun chiyotesicun ta snaic”, xi la snop. ");
INSERT INTO tzotze_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jech ta jujuntal laj yic'an tal li boch'otic oy yilic yu'un yajvale. Jech la sjac'be li boch'o ba'yuc itale: “¿C'u yepal avil yu'un li cajvale?” xut. ");
INSERT INTO tzotze_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Itac'ov: “Vo'vinic (100) tampo aceite quich'oj”, xi. Li jchabinae jech laj yalbe: “Li'o li svunal avile. Chotlan, ts'ibao yan. Lajuneb no'ox yoxvinic (50) tampo xats'iba”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ts'acal jech la sjac'be li yane: “Vo'ote ¿c'u yepal li avile?” xut. Itac'ov: “Vo'vinic coxtal trigo quich'oj”, xi. Li jchabinae jech laj yalbe: “Li'o li svunal avile, ts'ibao yan. Chanvinic (80) no'ox coxtal xats'iba”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Li yajvale jech laj yal: “Li chopol vinique bij. La sna' snopel c'u x'elan xu' ta xich' c'uxubinel c'alal me iloc' li' ta jnae”, xi li yajvale. Ja' no'ox jech li boch'otic ja' no'ox batem ta yo'ntonic c'u x'elan lec ch‑ech'ic li' ta banamile, ja' más sna'ic snopel c'u x'elan chc'uxubin xchi'ilic yu'un jech chc'uxubinatic ec. Yan li boch'otic xch'unojic Dios yalojique, ja' mu sna'ic snopel c'u x'elan chc'uxubin xchi'ilic yu'un jech chc'uxubinatic yu'un Dios ec. ");
INSERT INTO tzotze_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Li vo'oxuque jech chacalboxuc. Li c'usitic oy avu'unique ja' no'ox ac'biloxuc aventainic, jech tsc'an chacoltavanic o. Mu me ja'uc no'ox batem avo'nton ti lec cha'ech'ic o achi'uquic li' ta banamile yu'un ta ono'ox xlaj. Me chacoltavanic oe, jech chayic'oxuc ochel ta vinajel sbatel osil li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Li boch'o lec ta xchabi c'usi ac'bil sventain ti mu'yuc tsots sc'oplale, ja' no'ox jech lec ta xchabi me ch‑ac'bat sventain li c'usi tsots sc'oplale. Yan li boch'o mu xchabi c'usi ac'bil sventain ti mu'yuc tsots sc'oplale, ja' no'ox jech mu xchabi me ch‑ac'bat sventain li c'usi tsots sc'oplale. ");
INSERT INTO tzotze_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Me jech mu xachabiic c'usitic oy avu'unic ti ja' no'ox ac'biloxuc aventainic yu'un Dios sventa chapasic o c'usi tsc'ane, jech mu xayac'boxuc li c'usi sventa sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yu'un li c'usitic oy avu'unic li' ta banamile ja' no'ox yac'ojboxuc ach'amanic li Diose. Pero me mu xavaq'uic tunuc yu'une, jech mu xayac'boxuc li c'usi ja' avu'un atuquic ti ja' sventa sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jech chac c'u cha'al jun mozo ti mu xu' chib yajvale. Ti chibuc yajvale, li june ja' chopol chil; li yane ja' lec chil. Ja' jun yo'nton ta stojol li june; ja' chopol chil li yane. Ja' no'ox jech mu xu' chatunic yu'un Dios me ja' tey batem avo'ntonic yu'un taq'uine ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","C'alal jech laj ya'yic li fariseoetique, la slabanic li Jesuse yu'un stalelic ti xpich'et no'ox yo'ntonic yu'un taq'uine. ");
INSERT INTO tzotze_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Li Jesuse jech laj yalbe: ―Ta stojol cristianoetic chavaq'uic ta ilel ti tuc' avo'nton avalojique. Li Diose sna' ti mu'yuc lec avo'ntonique. Yu'un li boch'o ta xac' sba ta ich'el ta muc' ta stojol cristianoetique ja' mu'yuc lec ta x'ilat yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’C'alal mu'yuc to'ox chtal li Juan j'ac'vanej ta vo'e, ja' no'ox laj ava'yic c'usi yaloj Dios ti la sts'iba Moisés xchi'uc li yantic yaj'alc'optac Diose. Ts'acal to laj yalboxuc Juan ti yorail xa xu' chasventainboxuc avo'ntonic li Diose. Li' ta orae oy xa ep li boch'otic scotol yo'nton tsc'anic ventainel yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ac'o me la sjel c'u x'elan laj yal li Diose pero mu yu'unuc ja' mu'yuc xa stu ic'ot li c'usi ba'yuc yaloje. Li vinajel banamile ta ono'ox xlaj, pero li c'usi yaloj Diose mu xlaj sc'oplal. Persa chc'ot ta pasel scotol. ");
INSERT INTO tzotze_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Li boch'o ta xicta yajnile, me ta xic' yajnilin yan ants, ja' no'ox ta xmulivaj xchi'uc yu'un mu ja'uc yajnil. Xchi'uc noxtoc li boch'o ta xic' yajnilin li ictabil antse ja' no'ox ta xmulivaj noxtoc ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Li Jesuse jech laj yal noxtoc: ―Oy jun vinic lec jc'ulej. Toj lequic scotol li sc'u' spoq'ue. Puro toyolic stojol. Scotol c'ac'al puro lequil ve'lil ta sve'. ");
INSERT INTO tzotze_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oy yan vinic noxtoc, Lázaro sbi. Ja' jc'anlimosna. Tey ta xc'ot mochanatuc ta sti' sna li jc'ulej vinique yu'un ep c'a'al chinetic ta sbec'tal. ");
INSERT INTO tzotze_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Li Lázaroe chac ac'batuc ya'i sve' li c'usitic chbaj yalel ta yolon smesa li jc'ulej vinique, pero muc x'ac'bat. Ti bu c'a'em sbec'tale tey chlec'bat yu'un ts'i'etic. ");
INSERT INTO tzotze_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ta yan c'ac'al icham li jc'anlimosnae. Li xch'ulele i'ic'bat batel yu'un li yaj'almantaltac Diose. Tey bat ac'atuc yo' bu oy li Abraáme xchi'uc li boch'otic co'ol tuc' yo'ntonic xchi'uque. Icham ec li jc'ulej vinique, imucat. ");
INSERT INTO tzotze_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Li xch'ulele tey ibat yo' bu oy xch'ulelic li boch'otic mu'yuc xch'unojique. C'alal tey ta xich' ep vocole, la sq'uel batel ta nom bu oy li Abraáme. Laj yil tey xchi'uc sbaic xchi'uc li Lázaroe. ");
INSERT INTO tzotze_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Li jc'ulej vinique tsots i'avan, jech laj yalbe li Abraáme: “Tati, c'uxubinun. Taco tal li Lázaroe. Ac'o sts'aj tal sc'ob ta vo', ac'o tal sicubtasbun li coq'ue yu'un toj ep ta xquich' vocol li' ta c'oq'ue”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Li Abraáme jech laj yalbe: “Totil, vuleso ta ajol c'u xa'elan ti c'alal cuxulot to'ox ta banamile. Oy ep ac'ulejal. Li Lázaroe ja' me'on ta jyalel, pero li' xa oy ta lequilal, xcuxet no'ox yo'nton. Li vo'ote tey chavich' o vocol. ");
INSERT INTO tzotze_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mu xu' ta xtal li Lázaroe yu'un oy muc'ta xab ta o'lol. Mu'yuc boch'o xu' ta xjelov tal tey yo' bu oyote, jech mu'yuc boch'o xu' ta xjelov tal li' ec”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Itac'ov li jc'ulej vinique: “Me mu xu' chtal scoltaune, avocoluc tacbun batel ta sna li jtote. ");
INSERT INTO tzotze_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yu'un oy to vo'ob quits'in tey comenic ta jna. Ac'o bat yalbe ti mu me xtalic li'i yu'un toj tsots li vocole”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Li Abraáme jech laj yalbe: “Tey yich'ojbeic svun li Moisese xchi'uc svunic li yan yaj'alc'optac Diose. Xu' ja' ac'o xch'unic li c'usitic yalojique”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Itac'ov li vinique: “Tati, mu sc'an xch'unic. Pero ti oyuc jun boch'o xotquinic ta xcha'cuxi ti tey chbat c'opanaticuque, ja' to ta scomtsanic li c'usitic chopol ta spasique”, xi. ");
INSERT INTO tzotze_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Li Abraáme jech laj yalbe: “Me mu sc'an xch'unic c'usi yalojic li Moisese xchi'uc li yan yaj'alc'optac Diose, ac'o me ta xc'ot c'opanaticuc yu'un li boch'o cha'cuxeme, mu xch'unic noxtoc”, xut ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Scotol c'ac'al oy boch'o tsc'an chasocboxuc avo'ntonic. Pero toj abul sbaic li boch'o ta soquesvanique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ja' lec ac'o chucuc jun cho' ta snuc' ac'o jipatuc ochel ta nab, tey ac'o chamuc o. Yu'un jech mu xa socbe o yo'nton junuc li boch'otic jech yo'ntonic jech chac c'u cha'al ololetic ti xch'unojic vu'un Jcoltavanejun yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Bijanic me. Me oy la sta smul ta atojol avermanoe, ja' tsc'an chavalbe ti mu me spas jeche. Me la scomtsan li c'usi chopol tspase, pasbo perdón. ");
INSERT INTO tzotze_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Me oy ta sta smul ta atojol ep ta velta ta jun no'ox c'ac'ale, me jech ta xtal yalilanbot jujun velta ti c'alal ta sta smule: “Mu xa jpas jech”, me xayutote, pasbo perdón ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Li jcholc'opetique jech laj yalbeic li Cajvaltique: ―Ac'bun más jch'uncutic ti vo'ot chacoltauncutique ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Li Cajvaltique jech laj yalbe: ―Manchuc me jutuc no'ox ach'unojic ti vu'un ta jcoltaoxuque, me ja' no'ox jech yepal jech chac c'u cha'al jbej biq'uit bec' mostazae, pero xu' xa avu'un chapasic li c'usitic tsots ta pasele. Jech chac c'u cha'al me chavalbeic ti ac'o buluc loq'uel li jpets igo li'i, ti ac'o bat ch'iuc ta nabe, ja' ta xc'ot ta pasel avu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Me oy amozo batem ta sloquel avosil o me batem ta xchabiel achije, c'alal ta sut tal ta anae, mu jechuc chavalbe: “La' me, la' chotlan li' ta mesae”, mu xavutuc. ");
INSERT INTO tzotze_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jech chavalbe: “Ac'o smac ach'ut, meltsanbun tal jve'el. Ja' to chave' ec me laj co'nton ta ve'ele”, xavut. ");
INSERT INTO tzotze_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","C'alal me la xch'unbot amantale, mu'yuc chatojbe ta vocol ti la xch'un amantale yu'un ja' yabtel o ta spas. ");
INSERT INTO tzotze_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ja' no'ox jech ec li vo'oxuque, me laj ach'unic scotol c'usitic ta xalboxuc Diose, mu me xatoy abaic yu'un mu'yuc c'usi xu' avu'un laj apas atuquic. Yu'un ja' no'ox laj apasic li c'usi avabtel yac'ojboxuc Diose. Yu'un ti la spasoxuc Diose, yu'un tsc'an chatunic yu'un ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","C'alal chbat ta Jerusalén li Jesuse, tey ijelov ta sts'aquil Galilea banamil xchi'uc Samaria banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tey i'och ta jun tsobtsobnaetic. Tey chtalic ta be lajuneb viniquetic tsacbilic ta c'a'el chamel. Nom la sva'an sbaic ta stojol li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tsots lic avanicuc, jech laj yalbeic: ―Jesús, jchanubtasvanej, avocoluc c'uxubinuncutic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","C'alal laj yil viniquetic li Jesuse, jech laj yalbe: ―Batanic, bat ac' abaic ta ilel ta stojol li paleetique ―xut. La xch'unic, ibatic, jech icol o scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pero oy jun ti tsots sc'oplal laj ya'i ti icole, jech ta ora isut tal ta stojol li Jesuse. Tsots i'avan tal, laj yalbe slequilal Dios ta sventa ti colem xae. ");
INSERT INTO tzotze_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","La spatan sba ta stojol li Jesuse, jech laj yalbe: ―Colaval ti laj acoltaune ―xut. Li vinic ti jech laj yale ja' liquem tal ta Samaria banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Li Jesuse jech laj yalbe li boch'otic tey xchi'uque: ―Lajunebic ti la jcoltae. Q'uelavil, muc xa sutic tal li baluneb jchi'iltic ta israelale, muc xtal stojbeic ta vocol li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ja' no'ox isut tal li jun yan lum vinic li'i, ja' tal stojbe ta vocol li Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Li Jesuse jech laj yalbe li vinique: ―Lican, batan. Yu'un laj ach'un ti vu'un Jcoltavanejun avu'une jech chacol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Li fariseoetique la sjac'beic Jesús c'usi ora ta xtal ventainvanuc li Diose. Itac'ov li Jesuse: ―C'alal chlic ventainvanuc li Diose, mu'yuc sq'uelubil. ");
INSERT INTO tzotze_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mu'yuc boch'o xu' jech ta xal: “Li' xa tspas mantal li Diose”, mu'yuc boch'o xi. “Le' xa tspas mantal li Diose”, mu'yuc boch'o xi. Yu'un li Diose ta yo'nton cristianoetic ta x'abtej ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Ta to sta sc'ac'alil jech chavalic: “Taluc ta ora li Cajvaltique”, xachiic, pero mu to xu' chital, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jech ta xlic ava'ibicun jc'oplal: “Li' xa oy li Cajvaltique”, xayutoxuc. Oy yan jech ta xal: “Le' xa oy li Cajvaltique”, xayutoxuc. Mu me xach'unic, mu me xabatic ti bu ta xalique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yu'un ja' no'ox jech chac c'u cha'al sacsevul ti xleblej no'ox ta xquiltic buyuc no'ox oyutique, ja' jech scotol cristianoetic chilic c'alal chital, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero persa ba'yuc ta xquich' ep vocol yu'un mu xisc'anicun li jchi'iltactique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jech chac c'u cha'al la spasic cristianoetic ta vo'one ti c'alal li' to'ox oy li Noée, ja' no'ox jech ta spasic ec ti c'alal tsta yorail chital, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yu'un c'alal mu'yuc to'ox ta xtal li pulel ta vo'e, ja' no'ox batem yo'ntonic ta sa'el sve'elic, xchi'uc c'usi chuch'ic, xchi'uc ta xnupinic, xchi'uc ta xac' ta malijel stsebic. Ja' to iquechaj yu'unic ti c'alal i'och ta barco li Noée. Yu'un ital li pulel ta vo'e jech icham o scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ja' jech la spasic ec li cristianoetic ta vo'one ti c'alal li' to'ox oy li Lote. Ja' no'ox batem yo'ntonic ta sa' sve'elic, ta xmanulajic, ta xbolomajic, ta x'ovolajic, ta smeltsan snaic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ja' to iquechaj yu'unic ti c'alal iloc' batel ta Sodoma li Lote. Yu'un iyal tal c'oc' ta vinajel xchi'uc azufre jech icham o scotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","C'alal chicha'tal, vu'un ti co'ol cristianoutique, ja' jech tspasic ec li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’C'alal chicha'tal, vu'un ti co'ol cristianoutique, mu me ja'uc tey batem avo'ntonic yu'un li c'usitic oy avu'unic li' ta banamile. Li boch'otic tey oy ta sjol snaique, c'alal ta xyalic tale, mu xa me x'och yich' c'usitic oy yu'unic. Li boch'otic tey oyic ta yabtelique, mu xa me sutic tal ta snaic. ");
INSERT INTO tzotze_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Na'ic me c'u x'elan icom li yajnil Lot ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Me ja' tsots sc'oplal chava'yic c'u x'elan chacuxiic li' ta banamile, ch'ayel chabatic. Yan me mu'yuc tsots sc'oplal chava'yic c'u x'elan chacuxiic li' ta banamile, ja' chacuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Chacalboxuc, me ta ac'ubaltic chitale, me oy chib chvayic ta jun vaybale, jun ta xquic', jun ta xcom. ");
INSERT INTO tzotze_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Me oy chib antsetic ta xjuch'najique, jun ta xquic', jun ta xcom. ");
INSERT INTO tzotze_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Me oy chib viniquetic ta x'abtejic ta yabtelique, jun ta xquic', jun ta xcom ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jech ijac'bat yu'un li yajchanc'optaque: ―Cajval, ¿bu ta xc'ot ta pasel le'e? ―xutic. Itac'ov li Jesuse: ―Jech chac c'u cha'al me oy c'usi chamene ta ono'ox xlaj ta ti'el ta xulemetic, ja' jech ta ono'ox xtal castigo ta stojol li cristianoetique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Li Jesuse laj yalbe lo'il li yajchanc'optaque. Li lo'ile ja' smelol ti tsc'an mu x'ech' yo'ntonic ta sc'opanel Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jech laj yalbe: ―Oy jun jchapanvanej ta jun lum. Muc xich' ta muc' li Diose, muc xich' ta muc' noxtoc li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oy jun me'on ants tey nacal ec. Li antse ep ta velta ay sc'opan li jchapanvaneje, jech laj yalilanbe: “Avocoluc coltaun yu'un oy boch'o chiscontrainun”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Li jchapanvaneje ep c'ac'al mu sc'an xchapan li me'on antse. Ts'acal to jech la snop: “Mu xixi' yu'un li Diose, mu xixi' yu'un ec li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ja' no'ox yu'un li' xva'vun li me'on antse jech ta jchapan. Yu'un mu jc'an ti li' no'ox xva'vune”, xi ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jech laj yal noxtoc li Cajvaltique: ―Laj ava'yic c'u x'elan laj yal li jchapanvanej ti chopol yo'ntone. ");
INSERT INTO tzotze_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yan li Dios ti tuc' yo'ntone, me jech chac'anilanbeic ta c'ac'al ta ac'ubal ti ac'o xchapan li c'usi vocolal chava'yic, vo'oxuc ti t'ujbiloxuc yu'une, ta persa ta spas yu'un mu x'ech' yo'nton ta ya'yel li ac'opique. ");
INSERT INTO tzotze_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","C'alal me la sta sc'ac'alile, ta ora ta xchapan. Pero c'alal chicha'tal, vu'un ti co'ol cristianoutique, ¿me yoquel ach'unojbicun jc'op li' chvul jtaoxuc? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Li Jesuse laj yal jun lo'il yu'un jech ac'o ya'ibeic smelol li boch'otic tuc' yo'ntonic yalojic ti mu'yuc stu chilic li cristianoetique. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Oy chib viniquetic co'ol bat sc'opanic Dios ta yamaq'uil templo. Li june ja' fariseo; li yane ja' jtsobpatan. ");
INSERT INTO tzotze_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Li fariseoe tey va'al tstoy sba ti c'alal la sc'opan Diose. Jech laj yal: “Dios, colavalbun ti mu jechuc co'nton jech chac c'u cha'al li yan cristianoetique. Yu'un li stuquique ta x'elc'ajic, chopol yo'ntonic, ta xmulivajic. Mu jechuc co'nton noxtoc jech chac c'u cha'al li jtsobpatan li' ta sc'opanote. ");
INSERT INTO tzotze_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Li vu'une chib velta ta xquicta ixim ta jujun semana. Scotol li c'usitic ta jtae ta xcat ta lajlajuneb. Jujun ta jloq'ues ta lajlajuneb sventa amoton”, xut li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero li jtsobpatane nom no'ox va'al icom yu'un ta xi' yu'un li Diose. Mu sc'an stoy sat ta vinajel noxtoc. Yu'un la sna' ti chopol yo'ntone, ja' no'ox la smajilan sna yo'nton, jech la sc'opan Dios: “Dios, c'uxubinun yu'un jpasmulilun”, xut li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chacalboxuc, li jtsobpatane pasbil xa perdón yu'un smul ti c'alal isut batel ta snae. Yan li fariseoe muc spasbat perdón yu'un smul. Yu'un li boch'otic ta stoy sbaique ta x'ac'atic ta q'uexlal yu'un li Diose. Yan li boch'otic biq'uit ta xac' sbaique ja' ta x'ac'atic ta ich'el ta muc' yu'un li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Li israeletique laj yiq'uic tal ololetic noxtoc yu'un ac'o yac' sc'ob li Jesuse yu'un jech ta xich'ic o bendición. C'alal laj yilic li yajchanc'optaque, la spajesic li boch'otic laj yiq'uic tale. ");
INSERT INTO tzotze_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Li Jesuse laj yic' ta stojol li ololetique xchi'uc li stot sme'ique. Jech laj yalbe li yajchanc'optaque: ―Ac'o talicuc ta jtojol li ololetique, mu me xapajesic. Yu'un li boch'otic ja' jechic jech chac c'u cha'al ololetique lec ta xa'yic pasel ta mantal yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Melel chacalboxuc, li boch'otic mu sco'lajes sbaic jech chac c'u cha'al olole mu xu' ta x'ochic yo' bu ta spas mantal Dios ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oy jun jchapanvanej yu'un israeletic jech la sjac'be li Jesuse: ―Lequil jchanubtasvanej, ¿c'usi ta jpas ti xu' chicuxi o sbatel osile? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Li Jesuse jech laj yalbe: ―Mu'yuc ono'ox boch'o lec, ja' no'ox lec stuc li Diose. Jech ¿c'u yu'un chavalbun ti lecune? ");
INSERT INTO tzotze_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xana' ti jech chal li mantaletique: “Mu me xamulivaj, mu me xamilvan, mu me xa'elc'aj, mu me xanopbe smul achi'iltac, ich'o ta muc' atot ame'”, xi ―x'utat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Itac'ov li vinique: ―Scotol le'e biq'uitun lic jch'un tal ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","C'alal laj ya'i Jesús jech itac'ove, jech laj yalbe: ―Pero oy to c'usi sc'an avu'un. Bat chono scotol li c'usitic oy avu'une, q'uelanbo me'onetic li stojole jech chata ac'ulejal sventa sbatel osil. Ts'acal to xtal achi'inun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","C'alal jech laj ya'i li vinique, laj yat yo'nton yu'un toj jc'ulej. ");
INSERT INTO tzotze_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","C'alal laj yil Jesús ti chat yo'ntone, jech laj yal: ―Li jc'ulejetique toj vocol ta xac' sbaic ta ventainel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jech chac c'u cha'al mu xjelov jcot camello‑ca' ta chac acuxae, ja' no'ox jech mu xu' ta x'och yo' bu tspas mantal Dios li boch'otic batem yo'nton yu'un sc'ulejalique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Li boch'otic laj ya'i jech laj yal li Jesuse, jech lic sjac'beic: ―Me mu xcol li boch'o jc'ulejetique, ¿boch'o ono'ox xu' ta xcol cha'e? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Li Jesuse jech laj yal: ―Li cristianoetique mu xu' yu'un ta scolta sba stuquic. Ja' no'ox scotol xu' yu'un li Diose ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Li Pedroe jech laj yal ec: ―Li vu'uncutique laj xa jcomtsancutic scotol li c'usitic oy to'ox cu'uncutique. Li' xa jchi'inojotcutic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Itac'ov li Jesuse: ―Melel li c'usi chacalboxuque, li boch'otic tscomtsan snaic, me stot, me sme', me sbanquiltac, me yits'inabtac, me xvixubtac, me yixlaltac, me xi'meltac, me smucubtac, me yajnil, me xnich'nab yu'un ja' tsots sc'oplal cha'i ti tspasic c'usitic tsc'an Diose, ");
INSERT INTO tzotze_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jech ta stabe ep xq'uexol li' ta banamil xchi'uc ta xcuxiic sbatel osil noxtoc ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Li Jesuse slecoj laj yic' loq'uel jutuc li lajchab yajchanc'optaque. Jech laj yalbe: ―Chana'ic ti chijbat ta Jerusalene. Vu'un ti co'ol cristianoutique tey ta xc'ot ta pasel scotol li jc'oplal la sts'ibaic comel li yaj'alc'optac Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chi'ac'at ta sc'ob boch'otic muc ja'uc jchi'iltic ta israelal. Ta slabanicun, ta xuts'intaicun, ta stubtaicun. ");
INSERT INTO tzotze_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta xac'bicun nucul. Ts'acal ta xbat smilicun. Chimucat pero chicha'cuxi ta yoxibal c'ac'al ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Li yajchanc'optaque muc xa'ibeic smelol ti jech laj yale, muc sna'ic me jech ta xc'ot ta pasel. ");
INSERT INTO tzotze_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","C'alal nopol xa x'ech'ic batel ta lum Jericó li Jesuse, tey chotol ta ti'be la staic jun ma'sat. Ja' israel vinic. Tey ta sc'an limosna. ");
INSERT INTO tzotze_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","C'alal laj ya'i ma'sat ti ep ta xjelov xchi'iltaque, la sjac'be ti bu ta xbatique. ");
INSERT INTO tzotze_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","I'albat yu'un xchi'iltac ti ja' tey ta xjelov xchi'uquic li Jesús liquem tal ta Nazarete. ");
INSERT INTO tzotze_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","C'alal laj ya'i li ma'sate, tsots laj yapta li Jesuse: ―Jesús, vo'ot smomnich'onot David ti sc'oplal ono'ox cha'och ta ajvalil cu'uncutique, avocoluc c'uxubinun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Li boch'otic ba'yucbeique la spajesic: ―Ch'anchan ―xutic. Pero li vinique más to i'avan: ―Vo'ot smomnich'onot David, avocoluc c'uxubinun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iva'i li Jesuse, la stac ta iq'uel. C'alal ivul yo' bu oye, jech la sjac'be: ");
INSERT INTO tzotze_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿C'usi chac'an ta jpasbot? ―xut. Itac'ov li vinique: ―Cajval, avocoluc jambun jsat ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Li Jesuse jech laj yalbe: ―Lec oy, ac'o jamuc li asate. Yu'un laj ach'un ti scotol xu' cu'une, jech chacol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jech ta ora ijam li sate. La xchi'in batel li Jesuse, ep laj yal slequilal Dios. C'alal laj yilic li cristianoetique, laj yalic slequilal Dios ec. ");
INSERT INTO tzotze_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Li sbelal Jerusalene tey xjelov batel ta yut lum Jericó, jech tey xa ijelov batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oy jun vinic tey ta lum Jericó, Zaqueo sbi. Tsots yabtel yich'oj. Ja' banquilal yu'un jtsobpatanetic, ja' ta xich' li taq'uine ja' chbat yac'be li boch'o sventainoje. Jech jc'ulej o. ");
INSERT INTO tzotze_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Li Zaqueoe tsc'an ta sq'uel c'u x'elan li Jesuse. Tsc'an ta xotquin. Pero muc xil yu'un toj ep li cristianoetique. Yu'un comcom li Zaqueoe. ");
INSERT INTO tzotze_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jech ijelov ta anil. Imuy ta jpets igo ta nopol ti' be yo' bu ta xjelov li Jesuse yu'un jech xu' ta xil ti c'alal ta xjelove. ");
INSERT INTO tzotze_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","C'alal ic'ot ta igo li Jesuse, la sq'uel muyel. Laj yil tey luchul li vinique, jech laj yalbe: ―Zaqueo, yalan tal ta ora yu'un tsots sc'oplal tey chibat ta ana ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jech ta ora iyal li Zaqueoe. Xcuxet no'ox yo'nton laj yic' batel ta sna li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","C'alal laj yil cristianoetic ti ibat ta sna Zaqueo li Jesuse, chopol laj ya'yic. Jech tey iliquic ta vochlajetel scotolic yu'un sna'ojic ti ja' jlo'lavanej li Zaqueoe. Laj yalic ti bat xchi'in jpasmulil li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Li Zaqueoe iva'i, jech laj yalbe li Cajvaltique: ―Cajval, ta xcac'be j'o'loluc c'usitic oy cu'un li me'onetique. Me oy boch'o la jlo'labe staq'uine, más ech'em ta jsutes. Me la jlo'la ciene, chanib ciento chcac'be ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Li Jesuse jech laj yal: ―Li' ta orae lacol xa acotolic ta sjunul ana. Co'ol xa avo'nton achi'uc li jmoltotic Abraám ta vo'onee yu'un laj ach'un ti vu'un Jcoltavanejun avu'une. ");
INSERT INTO tzotze_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vu'un ti co'ol cristianoutique tal jsa' li boch'otic ch'ayemique yu'un tal jcolta ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","C'alal tey ta xa'yic c'usi ta xal Jesús li cristianoetique, li Jesuse laj yal jun lo'il yu'un po'ot xa chc'otic ta Jerusalén. Ja' la sloc'tabe ta lo'il ti muc to ja'uc yorail ta x'och ta ajvalilale. Yu'un la snop israeletic ti ja' xa ta x'och ta ajvalilal yu'unic tey ta Jerusalene, ja' li boch'o t'ujbil yu'un Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Li Jesuse jech laj yal: ―Oy jun xnich'on muc'ta ajvalil. Lec jc'ulej li xnich'one. Ibat ta nom ta yan banamil. Yu'un bat yich' tal yabtel yu'un ta x'och ta ajvalilal, yu'un ja' chlic sventain scotol li xchi'iltaque. Ts'acal to ta sut tal. ");
INSERT INTO tzotze_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","C'alal mu'yuc to'ox chbate, laj yic' tal lajuneb smozo. Ta jujuntal laj yac'anbe jujusep saquil taq'uin ep ta cien snitoj sba jujusep. Jech laj yalbe: “Bat jolintasic. C'alal me lisut tal ta yan c'ac'ale, ja' to ta xvul quich'”, xut comel. ");
INSERT INTO tzotze_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Li cristianoetique chopol laj ya'yic ti ja' ta x'och ta ajvalilal jun xchi'ilique. Jech lic staquic batel boch'o chbat yal ti bu batem yich' tal yabtele. Jech c'ot yalic: “Mu jc'ancutic ti ja' ta x'och ta ajvalilal cu'uncutic li jchi'ilcutic le'e”, xiic c'otel. ");
INSERT INTO tzotze_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","C'alal laj yich' yabtel sventa ajvalil li vinique, isut tal. C'alal ic'ote, la stacan ta iq'uel li smozotac ti yac'ojbe sjolintas staq'uine, yu'un tsc'an ta xa'i c'u yepal ijolin yu'un jujunic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Li boch'o ba'yuc itale jech laj yal: “Cajval, lajuneb ijolin cu'un li ataq'uin laj avac'bun comele”, xut vulel li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Itac'ov li yajvale: “Lec oy, vo'ote lequil mozoot. Yu'un jun avo'nton laj ajolintas li jtaq'uine, jech chacac'bot aventain lajuneb lum”, x'utat. ");
INSERT INTO tzotze_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ital noxtoc li yane, jech laj yal: “Cajval, vo'ob ijolin cu'un li ataq'uin laj avac'bun comele”, xut vulel li yajvale. ");
INSERT INTO tzotze_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Itac'ov li yajvale: “Vo'ote vo'ob lum chacac'bot aventain”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ital noxtoc li yane, jech laj yal: “Cajval, ilo li jsep ataq'uin laj avac'bune. Lec la jpix ta panyo, lec la jnac'. ");
INSERT INTO tzotze_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yu'un lixi' avu'un. Jna'oj ti toj cimarronote. La jna' ti chavich' sutel xchi'uc sjol li ataq'uine, chavich' ti bu mu ja'uc avabtele”, xi la spoj sba. ");
INSERT INTO tzotze_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Jech i'albat yu'un li yajvale: “Vo'ote ch'ajil mozoot. Mu junuc avo'nton ta jtojol jech mu xac'an xa'abtej. Ta jchapan li c'usi laj avale. Me laj ana' ti toj cimarronun ta sventa ti ta xquich' ti bu mu ja'uc cabtel chavale, ¿c'u yu'un muc xbat atic' ta banco yu'un ac'o sjolintas li yajval bancoe? C'alal lisut tale, laj quich' sutel xchi'uc sjol ti jechuque”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jech laj yalbe li yantic tey oyique: “Pojbeic li jsep jtaq'uin yich'oje, ja' ac'beic li boch'o laj yich' tal lajunebe”, xut. ");
INSERT INTO tzotze_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jech laj yalic: “¡Cajval, pero yich'oj xa lajunsep!” xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Itac'ov li ajvalile: “Chacalboxuc, scotol li boch'o ta x'abtejic cu'une ta sta c'usi oy yu'unic. Jech más to ta xcac'be yan noxtoc. Yan li boch'otic mu sc'an x'abtejic cu'une mu'yuc c'usi ta staic o. Ta jpojbe noxtoc li c'usitic cac'ojbeique. ");
INSERT INTO tzotze_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jech noxtoc li boch'otic ta scontrainicune, ti mu sc'anic vu'un ta jventaine, iq'uic tal scotol li'i. Li' ta jsat xamilic”, xi li ajvalile ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","C'alal laj yal jech lo'il li Jesuse, ijelov batel ta ba'yucbe yu'un chbat ta Jerusalén xchi'uc yajchanc'optac. ");
INSERT INTO tzotze_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tey ic'otic ta nopol tsobtsobnaetic Betfagé xchi'uc ta lum Betánia tey ta yoc vits Olivatic. Li Jesuse la stac batel chib yajchanc'op. ");
INSERT INTO tzotze_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jech laj yalbe: ―Batanic ta tsobtsobnaetic le'e. C'alal cha'ochique, tey chucbil chataic jcot burro mu'yuc to cajlebinbil. Titunic, iq'uic tal. ");
INSERT INTO tzotze_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Me oy boch'o ta sjac'boxuc ti c'u yu'un chatitunic li burroe, jech xavalbeic: “Yu'un ta xtun yu'un li Cajvaltique”, utic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ibatic li chibique. Ti c'u x'elan i'albatic batel yu'un Cajvaltique ja' jech la staic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","C'alal ja' o tey tstitunic li burroe, jech i'albatic yu'un li yajvale: ―¿C'u yu'un chatitunic li jburroe? ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Itac'ovic: ―Yu'un ta xtun yu'un li Cajvaltique ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jech laj yiq'uic batel bu oy li Jesuse. Laj yac'beic staspatin slapbolal xaquitaic, jech tey icaji li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","C'alal cajal xa batel ta burro li Jesuse, li israeletique la sq'uiic slapbolal xaquitaic ta be. ");
INSERT INTO tzotze_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","C'alal nopol xa x'ech'ic batel ta yeloval Jerusalén yo' bu vits Olivatique, tsots lic avanicuc scotol li boch'otic scotol c'ac'al la xchi'inic Jesuse. Xcuxet no'ox yo'ntonic laj yalbeic slequilal Dios ta sventa ti laj yilic ep sq'uelubil stsatsal la spas li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jech laj yalic: ―¡Toj lec li ajvalil la stacbutic tal Cajvaltic Diose! ¡Lec xa chijyilutic li Diose! ¡Ac'o ich'atuc ta muc'! ―xi ch‑avanic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oy jayibuc fariseoetic tey xchi'uquic. Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, pajeso li jch'unolajeletic avu'une yu'un loq'uel ch‑avanic ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Li Jesuse jech laj yalbe: ―Chacalboxuc, me ta xch'abiic li jch'unolajeletic cu'une, ja' ta xlic avanicuc li tonetique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","C'alal ta xa xc'ot ta Jerusalén li Jesuse, la sq'uel li lume, laj yoc'ta li xchi'iltac tey nacajtique. ");
INSERT INTO tzotze_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jech laj yal: ―Ana'icuc ti yorail xa chacolique, lec, pero mu xana'ic. ");
INSERT INTO tzotze_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yu'un ta to sta sc'ac'alil ta xtal set sbaic li' ta lum li avajcontraique, ta smacoxuc ta jujujot. ");
INSERT INTO tzotze_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ta svuq'uesic li lum avu'unique. Me jbejuc ton mu'yuc bu cajal ta xcom ta sba yac'ol yan ton, scotol ta svuq'uesic. Ta smiloxuc acotolic noxtoc. Ja' ta scoj ti mu xach'unic ti vu'un tacbilun tal yu'un Dios chajcoltaoxuque ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Li Jesuse i'och ta yamaq'uil templo tey ta Jerusalén. La sloq'ues scotol li jbolomaletic tey oyique. ");
INSERT INTO tzotze_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jech laj yalbe: ―Jech ts'ibabil ta sc'op Dios: “Li jnae ja' snail bu chac'opanicun”, xi yaloj li Diose. Li vo'oxuque apasojic xa ta snailch'en j'eleq'uetic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Li Jesuse scotol c'ac'al tey ichanubtasvan ta yamaq'uil templo ta Jerusalén. Li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li jchapanvanejetique, la snopilanic c'u x'elan xu' ta smilic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero muc staic, yu'un scotol cristianoetic jun yo'nton laj ya'ibeic sc'op li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ta yan c'ac'al tey ichanubtasvan ta yamaq'uil templo ta Jerusalén li Jesuse. La xcholbe ya'yic ti yorail xa xu' chventainbat yo'ntonic yu'un Diose. Jech tey italic jayibuc banquilal paleetic xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique, xchi'uc li jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jech la sjac'beic li Jesuse: ―Albun ca'icutic boch'o laj yac'bot avu'el chapas li c'usitic chapase ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Itac'ov li Jesuse: ―Oy c'usi ta jac'boxuc jbeluc ec. Albicun ca'i. ");
INSERT INTO tzotze_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Li ich'vo' laj yac' Juane ¿boch'o i'ac'bat yabtel ti jech la spase? ¿Me ac'bil yu'un Dios o me ac'bil yu'un cristiano? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jech tey lic yalilanbe sbaic: ―Me ta xcaltic ti ja' i'ac'bat yabtel yu'un Diose, jech ta xalbutic: “¿C'u yu'un muc xach'unic cha'e?” xijyututic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Me ta xcaltic ti i'ac'bat yu'un cristianoe, chijyac'butic ton li jchi'iltactique. Yu'un scotol xch'unojic ti ja' yaj'alc'op Dios li Juane ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jech lic yalbeic Jesús ti mu sna'ic boch'o i'ac'bat yabtel li Juan laj yac' ich' vo'e. ");
INSERT INTO tzotze_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Li Jesuse jech laj yalbe: ―Ja' jech mu'yuc ta xcalboxuc ec li boch'o laj yac'bun jvu'el ti jech ta jpase ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Li Jesuse lic sc'opan li israeletique, laj yalbe lo'il. Jech laj yal: ―Oy jun vinic ja' yajval osil. Tey la sts'un ep ts'usub ta yosil. La sa'be yajval boch'otic ta xchabiic li ts'usubtic yu'une. Jech ibat ta nom li yajvale. Tey ijoc'tsaj ep c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","C'alal ista yorail i'ic'ub li sat sts'usube, la stac tal jun smozo yu'un ta xich'be batel li sat sts'usube. Ja' c'ot sc'anbe li boch'otic ta xchabiique. Pero li jchabiejts'usubtique la stsaquic li mozoe, la smajic. Mu'yuc c'usi laj yac'beic sutel. ");
INSERT INTO tzotze_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Li yajval osile lic stac tal yan smozo noxtoc. Pero la smajic, laj yuts'intaic noxtoc. Me jutuc mu'yuc c'usi laj yac'beic sutel. ");
INSERT INTO tzotze_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Li yajval osile la stac tal yan smozo noxtoc. Ja' yoxibal xa velta. Pero li jchabiejts'usubtique la smajic noxtoc. Tuch'emic xa ti c'alal iloc' batel yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Li yajval osile jech la snop: “¿C'uxi ta xcut? Ja' lec ta jtac batel li jnich'on ti lec jc'anoje. C'alal me laj yilic ti ja' jnich'one, ja' ta xich'ic ta muc'”, xi ta yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero c'alal laj yilic jchabiejts'usubtic ti ja' xnich'on yajval osile, jech laj yalbe sbaic: “Le'e ja' ta xich'be comel yosil li stote. Ja' lec jmiltic jech vu'utic ta xquich'betic o comel li yosile”, xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jech la sloq'uesic ta pat corral, tey la smilic. C'alal ta sut tal li yajval osile, ¿c'usi ta xc'ot yich'ic pasbel xana'ic li jchabiejts'usubtique? ");
INSERT INTO tzotze_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chacalboxuc, li jchabiejts'usubtique ta smil. Yan xa boch'otic ta xac'be xchabi li sts'usube ―xi li Jesuse. C'alal laj ya'yic jeche, jech laj yalic: ―¡Mu me jechuc tspas li Diose! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Li Jesuse la sq'uelbe sat li cristianoetique, jech laj yalbe: ―Nopo ava'yic me mu jechuc xloc' smelol ti jech ts'ibabil ta sc'op Diose: Jech chac c'u cha'al yajval na la st'uj jbej ton sventa chac' ta chiquin na, pero li svinictac ta pasnae muc sc'anic. Li ton ti muc sc'anique ja' ono'ox i'och ta chiquin na. Ja' no'ox jech ec, ac'o me mu xc'anat li boch'o t'ujbil yu'un Diose, pero ta ono'ox xac'be tsots yabtel, xi ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Li boch'otic chopol chiyilicune chopol chbatic o. Ta ono'ox jchapanbe smulic. Me laj cal ti ch'ayel chbatique, j'ech'el ibatic o ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique tsc'an ta stsaquic ta ora li Jesuse yu'un laj ya'ibeic smelol ti ja' sc'oplal stuquic i'albatique. Pero mu'yuc boch'o itsacvan yu'un ixi'ic yu'un li xchi'iltaquique. ");
INSERT INTO tzotze_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ja' no'ox la smalaic me oy bu ora xocol li Jesuse. C'alal laj yilic ti xocol xae, ta ora la staquic batel jayibuc li boch'otic jun yo'ntonic ta stojol Jesús yilele yu'un oy c'usi chbat sjac'beic. Me mu'yuc lec ta xtac'ov li Jesuse, xu' tey ta stabeic o smul yalojic. Jech xu' ta stsaquic, ta xiq'uic batel ta stojol gobernador. Tey ta xc'ot stic'beic smul yalojic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jech la sjac'beic li Jesuse: ―Jchanubtasvanej, ta jna'cutic ti melel scotol c'usi chavale, ti jamal chavalbe ya'yic c'usi tsc'an Diose. Muc ta sbauc no'ox chaq'uel c'u x'elan li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Albun ca'icutic me lec chil Dios ti ta xcac'be jpatantic Césare, o me mu lecuc chil ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Li Jesuse la sna' ti ja' no'ox ta xlo'lavanique, jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ac'bicun quil junuc li taq'uin sventa ta jtoj o jpatantique ―xut. Jech laj yac'beic. C'alal laj yil li Jesuse, jech la sjac'be: ―¿Boch'o sloc'obbal li'i? ¿Boch'o sbi li'i? ―xut. Itac'ovic: ―Ja' César ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Li Jesuse jech laj yalbe: ―Tsc'an ta jch'unbetic c'usi ja' yabtel ta xal li Césare yu'un ja' muc'ta ajvalil. Jech noxtoc tsc'an ta jch'unbetic c'usi ta xal li Diose ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ac'o me tsc'an ta sa'beic smul Jesús tey ta stojol li xchi'iltaquique pero muc xu' yu'unic. Tey toj ch'ayel ic'ot yo'ntonic ta sventa c'u x'elan itac'ov li Jesuse. Jech mu'yuc xa c'usi yan la sjaq'uic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ts'acal to italic ta stojol Jesús jayibuc boch'otic xch'unoj saduceo, ja' ti chalic mu'yuc cha'cuxesele. Jech la sjac'beic li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Jchanubtasvanej, jech la sts'iba comel li Moisese: “Me oy ta xcham jun vinic, me mu'yuc xnich'on chcome, li its'inal ti mu'yuc to yajnile, ac'o yic'be yajnil li ánima sbanquile. C'alal ta xvoc' xnich'one, ja' chac'be sbiinbe sbi li sbanquile jech tey oy o sbi li sbanquile”, xi li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oy vucub jchi'iltic xchi'il no'ox sbaic ta voq'uel. Li banquilale la sa' yajnil. Pero icham li banquilale, mu'yuc xnich'on icom. ");
INSERT INTO tzotze_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Li its'inale laj yic'be yajnil li ánima sbanquile pero icham noxtoc. Mu'yuc xnich'on icom ec. ");
INSERT INTO tzotze_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ja' jech la spasic scotolic. Xquechet laj yic'beic li yajnil sba sbanquilique yu'un ichamic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ts'acal to icham ec li antse. ");
INSERT INTO tzotze_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","C'alal ta xcha'cuxiique, ¿boch'o junucal yajnil chc'ot li antse yu'un scotol laj yic' yajnilinic? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Itac'ov li Jesuse: ―Ti c'alal li' to oyic ta banamile xu' chnupinic li vinic antsetique. ");
INSERT INTO tzotze_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Li boch'otic t'ujbilic ta sventa ta xcha'cuxiic loq'uel ta muquinal yu'un tey chbat naquiicuc ta vinajele mu'yuc xa boch'o ta xnupin. ");
INSERT INTO tzotze_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yu'un mu xa xchamic jech chac c'u cha'al li j'almantaletique. Xnich'nab xa Dios c'otemic o yu'un icha'cuxesatic xa yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yu'un c'alal ta Moisés laj yal ti cuxulic li boch'otic vo'one xa xchamelique. Yu'un ja' la sts'ibabe comel sc'oplal ti c'alal i'albat yu'un Dios tey yo' bu itsan jtec' biq'uit ch'ixe. Ac'o me ep xa jabil chamenic li Abraáme, xchi'uc li Isaaque, xchi'uc li Jacove, pero jech to ta x'albat sc'oplalic: “Vu'un Diosun yu'un Abraám, xchi'uc Isaac, xchi'uc Jacov, xi li Diose”, xi li Moisese yu'un cuxulic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti chamenicuc o c'alal ta xch'ulelic jech chac c'u cha'al chavalique, mu'yuc xa Dios yu'unic ti jechuque. Yu'un li Diose muc ja'uc Dios yu'un li boch'otic chamenic oe; ja' Dios yu'un li boch'otic cuxajtique. Jech ich'bil o ta muc' sbatel osil li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yan xa o li boch'otic itac'ovique. Ja' xa itac'ovic jayibuc li jchanubtasvanejetic ta smantal Dios yalojique. Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, toj lec li c'usi laj avale ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yan li saduceoetique mu'yuc xa c'usi yan la sjac'beic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Li Jesuse jech la sjac'be: ―¿C'u yu'un ta xalic ti ja' smomnich'on David li Cristo ti t'ujbil yu'un Dios chventainvane? ");
INSERT INTO tzotze_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yu'un li Davide jech la sts'ibabe sc'oplal ta svunal q'ueojetic: Li Cajvale jech i'albat yu'un li Diose: “Ta to xlic chotlan ta jbats'ic'ob. ");
INSERT INTO tzotze_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Vo'ot chapas mantal c'alal to ta jtsalbot scotol li avajcontrae”, x'utat, xi li Davide. ");
INSERT INTO tzotze_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Li Davide “Cajval”, xut li boch'o t'ujbil yu'un Dios chventainvane. ¿C'u yu'un “Cajval”, xut me ja' smomnich'one? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Li israeletique laj ya'i scotolic ti c'alal jech laj yalbe yajchanc'optac li Jesuse: ");
INSERT INTO tzotze_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Q'uelo me abaic yu'un chopol c'usi ta spasic li jchanubtasvanejetic ta smantal Dios yalojique. Lec ta xa'yic ti nat sc'u' ta slapique. Lec ta xa'yic me ta xich'ic c'opanel yu'un jchi'iltactic tey ta ch'ivit. Lec ta xa'yic ti ta xchotiic ta sliqueb chotlebal ta nail tsobobbailetic xchi'uc ta jujun q'uin. ");
INSERT INTO tzotze_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jech noxtoc ta slo'labeic c'usitic oy yu'un me'on antsetic. Jech altic ti jal ta sc'opanic Diose. Le'e ja' tsots ta x'ac'batic castigo ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Li Jesuse la sq'uel batel xcaxail smoton Dios tey ta templo. Laj yil tey oy jc'ulejetic ta xaq'uic smoton Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Laj yil noxtoc tey ital jun me'on ants ti mu'yuc c'usi oy yu'une. Ja' no'ox chib cinco laj yac'. ");
INSERT INTO tzotze_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Li Jesuse jech laj yalbe li yajchanc'optaque: ―Melel chacalboxuc, ta stojol Diose ja' más ep laj yac' li me'on ants le'e. Ti c'u yepal laj yac' ta scotolic li yantique ja' mu'yuc ep ic'ot. ");
INSERT INTO tzotze_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yu'un puro scomelal xa staq'uin laj yaq'uic. Yan li me'on antse laj yac' scotol ti c'u yepal oy yu'un sventa ta sman o c'usitic ta xtun yu'une ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Oy jayibuc laj yalbeic Jesús ti toj c'upilic sba li tonetic yac'ojic ta temploe, xchi'uc li c'usitic sloc'taojic ti tey spac'ojic ta c'alc'al templo ti ja' la stojic li boch'otic scotol yo'nton tsc'an chac'beic smoton Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Li Jesuse jech laj yal: ―Li na ti toj c'upil sba ta xquiltic li' ta orae ta to sta sc'ac'alil ta xich' vuq'uesel scotol. Me jbejuc ton mu'yuc bu cajal ta xcom ta sba yac'ol yan ton, scotol ta xich' vuq'uesel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jech la sjac'beic li Jesuse: ―Jchanubtasvanej, ¿c'usi ora ta xc'ot ta pasel ti ta xvuq'uesat li templo laj avale? ¿C'usi sq'uelubil chavac' quilcutic ba'yuc yu'un jech ta jna'cutic o ti po'ot xa chc'ot ta pasele? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Li Jesuse jech laj yalbe: ―Q'uelo me abaic, mu me boch'o xaslo'laoxuc. Yu'un oy ep boch'o ta xalic sbiic jech chac c'u cha'al vu'un. Jech ta xalic: “Vu'un Cristoun ti t'ujbilun yu'un Dios chajventainoxuque”, xiic. Oy yan jech ta xalic: “Ja' xa sc'ac'alil ta xtal li Cristoe”, xiic. Pero mu me xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","C'alal chava'yic ti oy xa pleito li'i, xchi'uc c'alal chava'yic ti oy pleito ta nome, mu me xaxi'ic. Ta persa jech ta xc'ot ta pasel pero muc to ja'uc slajebal c'ac'al ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jech laj yal noxtoc: ―Ta to xlic scontrain sbaic cristianoetic ta yantic banamil. Ta to xlic scontrain sbaic ajvaliletic noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xchi'uc oy bu tsots ta xjelov niquel ta banamil. Ta to xtal tsots vi'nal xchi'uc chamel. Ta to xavilic ep sq'uelubil stsatsal Dios ta vinajel. Ja' toj xi'bal sba. ");
INSERT INTO tzotze_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’C'alal muc to chc'ot ta pasele, ba'yuc ta stsacoxuc, ta xuts'intaoxuc, ta xac'oxuc ta sc'ob li boch'otic oy yabtelic ta nail tsobobbailetique, ta stic'oxuc ta chuquel. Chayic'oxuc batel ta stojol muc'tic ajvaliletic xchi'uc ta stojol gobernadoretic pero vu'un ta jcoj. ");
INSERT INTO tzotze_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jech xu' tey chacholic batel jc'op ta stojolic. ");
INSERT INTO tzotze_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na'ic me ti tsc'an mu xanopilanic ba'yuc li c'usi chc'ot avalique. ");
INSERT INTO tzotze_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yu'un vu'un chajcoltaoxuc ta lo'il. Ta xcac'boxuc abijilic jech mu xastsaloxuc ta lo'il scotol li boch'otic ta scontrainoxuque. ");
INSERT INTO tzotze_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oy atot ame'ic no'ox ta xac'oxuc ta c'abal. Oy achi'iltaquic no'ox ta voq'uel ta xac'oxuc ta c'abal. Oy avuts' avalalic no'ox ta xac'oxuc ta c'abal. Oy ja' no'ox ta xac'oxuc ta c'abal li boch'otic lec xac'opan aba achi'uquique. C'alal tey xa oyoxuc ta sc'obique, oy ta smiloxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Scotol cristianoetic chopol chayiloxuc ta jventa. ");
INSERT INTO tzotze_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ja' no'ox me jech tsc'an Dios ti ta smiloxuque, ta xc'ot ta pasel. Me mu jechuc tsc'an Diose, me jutuc mu'yuc c'usi xu' ta spasboxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Me chcuch avu'unic scotole, más tstsatsub avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’C'alal chavilic li' setoj sbaic ta spat corral ton yu'un Jerusalén li yajsoldadotac yan ajvalile, na'ic me ti yu'un laj xa sta yorail ta xich' vuq'uesele. ");
INSERT INTO tzotze_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Acotolic ti li' nacaloxuc ta Judea banamile, jatovanic batel ta anil ta vitsetic. Li boch'otic li' oy ta yut lume ac'o loc'uc batel. Li boch'otic loq'uemic batele mu xa me x'ochic tal. ");
INSERT INTO tzotze_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yu'un laj xa sta sc'ac'alil chavich'ic castigo jech chac c'u cha'al ts'ibabil ono'ox comel yu'un li yaj'alc'optac Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Toj abul sba li boch'otic ja' to xchi'inoj yolique xchi'uc li boch'otic ta to xchu'un yolique yu'un toj tsots li vocol ta xtale. Yu'un más tsots castigo cha'ac'batic yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oy chamilatic ta machita. Oy chachucatic, cha'ic'atic batel ta yosilal yan lum cristianoetic. J'ech'el ta xlaj o atsatsalic, vo'oxuc ti li' nacaloxuc ta lume. Yan lum cristianoetic ta sventainic li lume, ta xixtanic scotol. Ja' to me its'aqui ti c'u yepal c'ac'al ch‑ac'bat sventainic yu'un Diose, ja' to chjel yajval. ");
INSERT INTO tzotze_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ta xvinaj sq'uelubil ta vinajel ti c'alal po'ot xa chitale. Yu'un ta xc'ataj li c'ac'ale, xchi'uc li ue, xchi'uc li c'analetique. Jech noxtoc ta xjel c'u x'elan ta xbac' li nabe. Toj tsots xvo'et ta spas, más to tsots ta syuq'uilan sba jech ta xi'ic o scotol cristianoetic ta banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Li cristianoetique mu'yuc xa stsatsal yo'ntonic ta scoj li xi'ele yu'un ta xi'ic me oy c'usi ta xc'ot ta pasel li' ta banamile. Yu'un scotol li c'usitic tey oy ta vinajele ta xnic scotol. ");
INSERT INTO tzotze_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja' o ta xil scotol cristianoetic ta xiyal tal ta toc, vu'un ti co'ol cristianoutique. Ep jtsatsal xchi'uc tsots jxojobal. ");
INSERT INTO tzotze_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","C'alal chavilic ta xlic c'otuc ta pasel scotol li c'usitic laj calboxuque, cuxetuc me avo'ntonic yu'un chana'ic ti po'ot xa chacolique ―xut yajchanc'optac li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Laj yalbe yan lo'il noxtoc: ―Na'ic me c'u x'elan ta xch'i li igoe xchi'uc scotol li yan te'etique. ");
INSERT INTO tzotze_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","C'alal ta xq'uexin yanale, jech chana'ic o ti po'ot xa yorail vo'olaltique. ");
INSERT INTO tzotze_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ja' no'ox jech ec li vo'oxuque, c'alal chavilic ta x'ech' scotol li c'usi calojboxuque, jech chana'ic o ti po'ot xa yorail chistacun tal li Diose yu'un ta xtal jpas mantal li' ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Melel chacalboxuc, oy mu'yuc to chachamic ja' to me i'ech' scotol li c'usitic laj calboxuque. ");
INSERT INTO tzotze_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ta to xlaj li vinajel banamile, pero li c'usitic caloje mu'yuc ono'ox ta xlaj sc'oplal, ta xc'ot ta pasel scotol. ");
INSERT INTO tzotze_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","’Q'uelo me abaic, mu me xbat avo'ntonic yu'un li c'usitic oy li' ta banamile xchi'uc li c'usitic tsc'an abec'talique, xchi'uc ti c'u x'elan chacuxiic li' ta banamile. Yu'un me ja' tey batem avo'ntonique, ch'ayem avo'ntonic ta xvul jtaoxuc ti c'alal chitale. Jech chac c'u cha'al jcot ts'i' ti mu sna' bu ora ch‑och ta yoquile, ja' no'ox jech ec li cristianoetique, mu sna'ic bu ora ta xtal vocol ta sbejel banamil. ");
INSERT INTO tzotze_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pero li vo'oxuque viq'uiluc me asatic, c'opanic Dios scotol c'ac'al ti ac'o cuchuc avu'unic li vocol ta xtale. Jech mu'yuc amulic c'alal chac'otic ta jtojol, vu'un ti co'ol cristianoutique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Li Jesuse ta c'ac'altic tey ichanubtasvan ta yamaq'uil templo ta Jerusalén. Yan ta jujun ac'ubale iloc' batel, tey bat vayuc ta vits Olivatic. ");
INSERT INTO tzotze_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta jujun sob ital scotol cristianoetic tey ta yamaq'uil templo yu'un cha'ibeic sc'op li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jutuc xa'ox sc'an sta sc'ac'alil sq'uinal ta sve'ilanic batel pan ti mu'yuc yich'oj svolesubil xch'ute. Ja' q'uin coltael sbi. ");
INSERT INTO tzotze_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique la snopic c'u x'elan xu' ta smilic li Jesuse yu'un ta xi'ic yu'un li xchi'iltaquique. ");
INSERT INTO tzotze_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Li Satanase, ja' li banquilal pucuje, i'och ta yo'nton li Judase, ja' li Iscariote i'ac'bat yan sbie. Ja' jun li lajchab yajchanc'op Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Li Judase bat sc'opan li banquilal paleetique xchi'uc li banquilaletic ti xchabiojic templo yu'unic tey ta Jerusalene. Ja' bat yalbe ya'yic ti tsc'an ta spas trato yu'un ta xac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","C'alal laj ya'yique, xcuxet xa yo'ntonic. La xchapanic c'u yepal taq'uin ta xac'beic li Judase. ");
INSERT INTO tzotze_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","C'alal laj ya'i Judas c'u x'elan ichapaj yu'unique, toj lec laj ya'i. Tey lic snop c'usi ora xu' ta xac' ta c'abal li Jesuse yu'un jech mu xlic c'op yu'un li xchi'iltac ta israelale. ");
INSERT INTO tzotze_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","La sta sc'ac'alil ta sve'ic pan ti mu'yuc yich'oj svolesubil xch'ute, xchi'uc ta sti'ic ch'ium chij ta sventa q'uin coltael jech chac c'u cha'al yaloj ono'ox Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Li Jesuse la stac batel Pedro xchi'uc Juan. Jech laj yalbe batel: ―Batanic, bat meltsanic li ch'ium chij ta jti'tic ta sventa q'uin coltaele ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jech la sjaq'uic: ―¿Bu chac'an ta xbat jmeltsancutic? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Itac'ov li Jesuse: ―Chacalboxuc, c'alal cha'ochic ta Jerusalene, tey chanupic ta be jun vinic xcuchoj jbej q'uib ya'al. Ja' tey xanaban abaic batel, tey xa'ochic ec ta na ti bu ta x'oche. ");
INSERT INTO tzotze_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jech xc'ot avalbeic li yajval nae: “Jech laj yal tal li Jchanubtasvaneje: ¿Bu jc'olucal scuartoal ana yo' bu ta jti'cutic chij ta sventa q'uin coltael jchi'uc cajchanc'optaque? xi laj yal tal”, utic c'otel. ");
INSERT INTO tzotze_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tey chayac'boxuc avilic jun muc'ta cuarto ta xcha'cojal sjol sna. Tey xa xchapanoj li c'usitic ta xtun cu'untique. Ja' tey xameltsanic li chije ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jech ibatic li chibique. Ja' jech la staic jech chac c'u cha'al i'albatic batel yu'un Jesuse. Tey la smeltsanic li chij sventa q'uin coltaele. ");
INSERT INTO tzotze_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","C'alal ta xa xve'ique, ital li Jesuse. Tey ichotiic ta ti' mesa xchi'uc yajchanc'optac. ");
INSERT INTO tzotze_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Li Jesuse jech lic yalbe li yajchanc'optaque: ―Scotol co'nton li' ta jchi'inoxuc ta sti'el chij ta sventa q'uin coltael ti c'alal mu'yuc to chichame. ");
INSERT INTO tzotze_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta xcalboxuc ti mu'yuc xa ta jti' yan velta li chije. Ja' to ta jti' yan velta ti c'alal tey xa jtsoboj jba jcotoltic yo' bu chiyac'bun jpas mantal li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Li Jesuse la stsac jun vaso ya'lel ts'usub, la stojbe ta vocol Dios. Jech laj yalbe li yajchanc'optaque: ―Ilo, uch'an acotolic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta xcalboxuc ti mu'yuc xa ta xcuch' yan velta li ya'lel ts'usube. Ja' to ta xcuch' yan velta ti c'alal tey xa jtsoboj jba jcotoltic yo' bu chiyac'bun jpas mantal Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","La stam noxtoc jun pan, la stojbe ta vocol Dios, la svoc' li pane, laj yac'be li yajchanc'optaque. Jech laj yalbe: ―Li'i ja' jbec'tal yu'un ta xcac' jba ta milel ta acojic. Jech me xapasilanic yu'un jech chana'ilanic ti vo'oxuc ta acojic lichame ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","C'alal ilaj yo'ntonic ta ve'ele, la stsac yan velta li vasoe, jech laj yalbe li yajchanc'optaque: ―Li ya'lel ts'usub li' chavuch'ique ja' senyail ti mu xlaj sc'oplal li c'usi ach' la xchapan Jtot sventa chacolic oe. Yu'un jtuc chcac' jba ta milel, ta xloc' jch'ich'al, jech ta xtoj o amulic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Chacalboxuc, li boch'o chiyac'un ta c'abale ja' li' co'ol oyutic ta mesa jchi'uctic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yu'un jech ono'ox yaloj Dios ti chismilicun, vu'un ti co'ol cristianoutique. Pero toj abul sba li boch'o chiyac'un ta c'abale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Li yajchanc'optaque lic sjac'be sbaic boch'o junucal yu'unic ti ta xac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Li yajchanc'optac Jesuse laj yutilan sbaic ta sventa boch'o más banquilal ta xc'ot yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Li Jesuse jech lic yalbe: ―Li ajvaliletic yu'un yan lum cristianoetique ja' no'ox ta spasic mantal. Tstoy sbaic ta stojol li svinictaquique. Ac'o me jech tspasic pero tsc'anic ti “lec chc'uxubinvan”, xi sc'oplalique. ");
INSERT INTO tzotze_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero li vo'oxuque mu me xapasic jech. Li boch'o tsc'an ta xc'ot ta banquilal avu'unique, ti tsc'an ich'bil ta muq'ue, biq'uit ac'o yac' sba ta atojolic, ac'o scoltaoxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nopo ava'yic c'u x'elan li boch'o banquilaletic li' ta banamile. Ja' no'ox ta xalic mantal, mu'yuc ta x'abtejic. Yan li vu'une mu jechuc ta jpas. Yu'un vu'un avajtunelicun c'otemun yu'un chajcoltaoxuc. ");
INSERT INTO tzotze_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Li vo'oxuque jun avo'nton laj achi'inicun ti c'alal laj quich'ilan contrainele. ");
INSERT INTO tzotze_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jech ta xcac'boxuc avabtelic. Yu'un laj xa yac'bun cabtel li Jtotique jech ta to jpas mantal. Jech ta to xapasic mantal ec li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jech co'olutic xa ti c'alal tsta sc'ac'alil ta jpas mantale yu'un co'ol ta jpastic ta mantal scotol ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Li Cajvaltique jech laj yalbe li Simone: ―Simón, a'yo ava'i, li Satanase ay xa sc'an ta stojol Dios ti ta sq'uelboxuc c'u x'elan avo'ntonic li' ta orae. Yu'un tsc'an ti ac'o chibajuc avo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero li vo'ote laj xa jc'opanbot Dios ta atojol yu'un jech mu xchibaj o avo'nton. C'alal ta xlic asutes avo'nton yan veltae, vo'ot chatsatsubtasbe yo'nton li avermanotaque ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Li Pedroe jech laj yal: ―Cajval, ac'o me chistiq'uicun ta chuquel, ac'o me chismilicun, mu'yuc chajcomtsanot ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Itac'ov li Jesuse: ―Pedro, chacalbot ava'i, tana c'alal mu'yuc to'ox ta x'oc' cotse, oxib xa'ox velta avaloj ti mu xavotquinune ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Li Jesuse jech lic yalbe scotolic: ―C'alal la jtacoxuc batele, mu'yuc ataq'uinic, mu'yuc ave'elic, mu'yuc axonobic. ¿Me oy c'usi muc xataic? ―xut. Itac'ovic: ―Mu'yuc c'usi ti muc jtacutique, la jtacutic scotol ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Li Jesuse jech laj yalbe: ―Jech chac c'u cha'al soldadoetic ti ta xchapan sbaic lec yu'un tsc'an tstsalvanic ta paspleitoe, ta xich' batel staq'uinic xchi'uc sve'elic. Me mu'yuc xmachitae, ta xchon slapbolal xaquita yu'un ja' ta sman o li xmachitae. Ja' no'ox jech ec li vo'oxuc li' ta orae, ja' tsc'an ti chach'unic ti chascoltaoxuc li Diose, jech chcuch avu'unic ti c'alal chavich'ic contrainele. ");
INSERT INTO tzotze_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yu'un persa ta xc'ot ta pasel scotol ti jech ono'ox ts'ibabil jc'oplale: “Ta xcuyat jech chac c'u cha'al jpasmulil”, xi ono'ox ts'ibabil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Li yajchanc'optaque jech lic yalic: ―Cajval, li' oy chib machita―xutic. Itac'ov li Cajvaltique: ―Xu' no'ox o ―xi. (Ti jech itac'ov li Cajvaltique, yu'un laj ya'i ti muc xa'ibeic smelol li c'usi laj yale.) ");
INSERT INTO tzotze_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iloc' batel li Jesuse, ibat ta vits Olivatic yu'un tey ono'ox ta xc'otilan. Ichi'inat batel yu'un li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","C'alal ic'otique, li Jesuse jech laj yalbe li yajchanc'optaque: ―C'opanic Dios yu'un jech mu xach'unic sujel ta mulil ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Li Jesuse ijelov batel jutuc. Ja' jech snatil ijelov batel jech chac c'u cha'al snatil xijtenubaj ta tone. Tey la squejan sba, la sc'opan Dios. ");
INSERT INTO tzotze_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jech laj yal: ―Tati, ti jechuc tsc'an avo'nton mu xichame, xu' chaloq'uesbun li jvocol li'i. Pero mu me xc'ot ta pasel li c'usi ta sc'an co'nton jtuque. Ja' ac'o jpas li c'usi tsc'an avo'ntone ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Li Jesuse laj yil jun j'almantal. Itacat tal yu'un ja' tal ac'batuc stsatsal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yu'un mu xa xcuch yu'un laj ya'i li vocole jech ep la sc'opan Dios. Ep ichiq'uinaj. Li xchiq'ue ja' jech chac c'u cha'al ch'ich' ti sts'ujts'un no'ox c'alal ta xloq'ue. ");
INSERT INTO tzotze_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","C'alal laj yo'nton ta sc'opanel Diose, isut tal yo' bu oyic li yajchanc'optaque. Vayemic vul sta yu'un ep ta xat yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jech vul yalbe: ―¿C'u yu'un chavayic? Ja' lec licanic, c'opanic Dios yu'un jech mu xach'unic sujel ta mulil ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","C'alal ja' o chlo'ilaj li Jesuse, ital ep cristianoetic. Ja' ba'yucbe tal li Judase, ja' li yajchanc'op Jesuse. Li Judase tey ic'ot yo' bu oy li Jesuse, ic'ot sts'uts'. ");
INSERT INTO tzotze_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Li Jesuse jech laj yalbe: ―Judas, mu yu'unuc jun avo'nton ta jtojol ti tal ats'uts'une. Ja' no'ox ta sventa c'u x'elan chavac'un o ta c'abal, vu'un ti co'ol cristianoutique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","C'alal la sna'ic yajchanc'optac Jesús ti ja' tal stsaquic li Jesuse, jech lic yalbeic li Jesuse: ―Cajval, me chac'ane, ta xcac'becutic machita―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oy jun boch'o la sloq'ues xmachita. La sbojbe loq'uel jun xchiquin smozo li más banquilal palee. Li xchiquin iloq'ue ja' sbats'ichiquin. ");
INSERT INTO tzotze_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Li Jesuse jech laj yal: ―Mu me xapajesic. Ac'o spasic li c'usi tsc'an yo'ntonique ―xut. Li Jesuse la spicbe yav xchiquin li mozoe, jech lec icom li xchiquine. ");
INSERT INTO tzotze_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Li Jesuse jech laj yalbe li jtsacvanejetique, ja' li banquilal paleetique, xchi'uc li banquilaletic ti xchabiojic templo yu'unique, xchi'uc li jchapanvanejetique: ―¿C'u yu'un tal atsaquicun ta machita, ta te', jech chac c'u cha'al j'elec'? ");
INSERT INTO tzotze_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Scotol c'ac'al tey oyun ta atojolic ta yamaq'uil templo. ¿C'u yu'un muc teyuc xatsaquicun? Ti jech ivu' avu'unic laj atsaquicune, yu'un iloq'uesbat xa mantal yu'un Dios li avajvalique, ja' li Satanás ti sventainoj mulile ―xut li jtsacvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jech la stsaquic li Jesuse, laj yiq'uic batel ta sna li más banquilal palee. Li Pedroe ta nomnomtic ibat ta spat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tey la sno'p sc'oq'uic ta yamaq'uil sna li más banquilal palee yu'un tey ta xc'atinic. Tey ichotiic ta ti' c'oc'. Li Pedroe tey la xchi'in ta chotlej li yantique. ");
INSERT INTO tzotze_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oy jun quiara laj yil tey chotol ta xc'atin li Pedroe. Yu'un lec tsanem li c'oq'ue ja' yu'un laj yil. La sq'uelbe lec sat, jech lic yal: ―Li vinic li'i ja' xchi'il sbaic xchi'uc li boch'o le' tsacbile ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Li Pedroe laj yal ti mu xotquine. Jech laj yal: ―Li boch'o chavale, yaa, mu xcotquin ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta jliquel tey i'otquinat yu'un yan noxtoc. Jech i'albat: ―Vo'ote ja' achi'il ec li vinic le'e ―x'utat. Itac'ov li Pedroe: ―Mu vu'cun, tata ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I'ech' van junuc ora, oy boch'o yan jech laj yalbe sc'oplal li Pedroe: ―Ta melel ja' xchi'il sbaic xchi'uc li vinic li'i yu'un tey liquem tal ta Galilea ec ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Itac'ov li Pedroe: ―Tata, mu jna' li c'usi chavale ―xi. C'alal ja' o jech chal li Pedroe, ja' o i'oc' cots. ");
INSERT INTO tzotze_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Li Jesuse la sq'uel li Pedroe. Li Pedroe tey it'ab ta yo'nton ti jech ono'ox i'albat yu'un Cajvaltique: “Tana c'alal mu'yuc to'ox ta x'oc' cotse, oxib xa'ox velta avaloj ti mu xavotquinune”, x'utat ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Li Pedroe iloc' batel. Ep laj yoc'ta sba. ");
INSERT INTO tzotze_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ti jayib boch'o i'ac'bat xchabiic li Jesuse tey lic slabanic, la smajic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","La smacbeic sat ta poc'. Lic smajbeic sat, jech laj yalbeic: ―Alo tal ca'tic ti boch'o la smajote ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ep la slabanic. Ep c'usi chopol laj yalbeic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","C'alal isacub osile, la stsob sba scotolic li jchapanvanejetic yu'un israeletique, ja' li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Laj yiq'uic batel ta stsoblebic li Jesuse. Jech laj yalbeic: ");
INSERT INTO tzotze_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Albun ca'icutic me vo'ot li Cristoot ti t'ujbilot yu'un Dios chaventainuncutique ―xutic. Itac'ov li Jesuse: ―Me ta xcalboxuc ti vu'un Cristoune, mu xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Me ta jac'boxuc noxtoc c'usi chanopique, mu xatac'ovic. ");
INSERT INTO tzotze_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vu'un ti co'ol cristianoutique laj xa sta sc'ac'alil ti chbat chotlucun ta sbats'ic'ob Diose. Ja' tey ta xlic jpas ta mantal scotol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Scotolic jech laj yalic: ―¿Me yu'un vo'ot Xnich'onot Dios acuyoj aba? ―xutic. ―Vu'un ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jech laj yalbe sbaic: ―¿C'u yu'un ta jc'antic yan testigo? Laj xa ca'i jtuctic ti tstoy sba ta stojol Diose ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jech ilic scotolic, laj yiq'uic batel ta stojol Pilato li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tey lic stic'beic smul. Jech laj yalic: ―Li vinic li'i ta xal ti mu xu' ta xcac'be jpatancutic li muc'ta ajvalil Césare, yu'un chal ti ja' ajvalil stuque. Chal ti ja' t'ujbil yu'un Dios chisventainuncutique. Jech ta stsob svinictac yu'un tsc'an ta sliques c'op li' ta cosilalcutique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Li Pilatoe la sjac'be li Jesuse: ―¿Me vo'ot ajvalilot yu'un li achi'iltac ta israelale? ―xut. Itac'ov li Jesuse: ―Vu'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Li Pilatoe jech lic yalbe li banquilal paleetique xchi'uc scotol li cristianoetique: ―Mu'yuc la jtabe smul li vinic li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jech tsots lic c'opojicuc yan velta: ―Mu me xacolta batel yu'un ja' ta soques li jchi'iltaccutique. Ta xchanubtasvan ta scotol cosilalcutic li' ta Judeae. Ta sliquebe tey ichanubtasvan ta Galilea. Li' ta orae li' xa talem noxtoc ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","C'alal laj ya'i Pilato ti ja' ba'yuc tey lic chanubtasvanuc ta Galileae, jech lic sjac'be cristianoetic me yu'un ja' tey liquem tal ta Galilea li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","C'alal laj ya'i ti tey liquem tal ta Galilea li Jesuse, jech la sna' o Pilato ti ja' ventainbil yu'un Erodese. Jech la stac batel yo' bu oy li Erodese yu'un tey talem ta paxal ta Jerusalén. ");
INSERT INTO tzotze_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","C'alal laj yil Jesús li Erodese, xcuxet xa yo'nton. Yu'un ep xa c'ac'al chac sq'uel ya'i yu'un ya'yojbe sc'oplal ti ep c'usi ta spas li Jesuse. “Oyuc baq'uin bu ta xquil c'u x'elan ta spas junuc sq'uelubil stsatsal li Jesuse”, xi ono'ox ta yo'nton li Erodese. ");
INSERT INTO tzotze_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Li Erodese tey lic sjaq'uilanbe ti c'u x'elan xu' yu'un ta spas sq'uelubiltac stsatsale. Li Jesuse me jbeluc muc xtac'ov. ");
INSERT INTO tzotze_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tey oyic li banquilal paleetique xchi'uc li jchanubtasvanejetic ta smantal Dios yalojique. Soquem sjolic ta stojol li Jesuse. Scotol yo'ntonic la stic'beic smul ta stojol li Erodese. ");
INSERT INTO tzotze_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Li Erodes xchi'uc yajsoldadotaque muc xich'ic ta muc' li Jesuse. Ja' no'ox la slabanic, la slapbeic natil c'u'il sventa ajvaliletic. Ts'acal lic staquic sutel ta stojol Pilato, tey slapoj batel li c'u'ile. ");
INSERT INTO tzotze_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Li Pilatoe scontrainoj ono'ox sbaic xchi'uc li Erodese, pero c'alal la stac batel ta stojol Erodes li Jesuse, jech lec lic sc'opan sbaic o. ");
INSERT INTO tzotze_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Li Pilatoe laj yic'an tal scotol li banquilal paleetique, xchi'uc li jchapanvanejetic yu'un israeletique, xchi'uc scotol israeletic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jech laj yalbe: ―Li achi'ilic li'i laj avalic ti ja' ta soques scotol achi'iltaquique, jech laj aviq'uic tal li' ta jtojole. Pero laj xa quich'be sc'op li' ta atojolic. Me jutuc mu'yuc la jtabe smul. Mu meleluc li c'usi laj avalique. ");
INSERT INTO tzotze_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jech noxtoc li Erodese muc stabe smul ec. Ti lajuc stabe smule, muc stac sutel tal li' ta jtojol ti jechuque. Jech mu'yuc smul ti xu' ta xmilate. ");
INSERT INTO tzotze_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ja' no'ox ta xcac'be castigo, ta jcolta batel ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Li Pilatoe ta persa ta scolta batel jun jchuquel ta jujun q'uin coltael ti bu junucal ta sc'anique. ");
INSERT INTO tzotze_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jech scotol cristianoetic tsots lic avanicuc: ―Le'e ac'o bat yich' joc'anel ta cruz. Ja' ac'o coluc li Barrabase ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Li Barrabase itic'at ta chuquel ta scoj la stsob svinictac yu'un la scontrain li ajvalil tey ta Jerusalene, xchi'uc imilvan noxtoc. Ja' israel vinic.) ");
INSERT INTO tzotze_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Li Pilatoe lic sc'opan yan velta li israeletique yu'un tsc'an ta scolta batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tsots lic avanicuc yan velta: ―¡Joc'ano ta cruz! ¡Joc'ano ta cruz! ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Li Pilatoe jech la sjac'be: ―Pero ¿c'usi smul avu'unic? Vu'une mu'yuc la jtabe smul ti xu' ta xmilat oe. Ja' no'ox ta xcac'be castigo, ta jcolta batel ―xut. Ja' yoxibal xa velta jech laj yal li Pilatoe. ");
INSERT INTO tzotze_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero más to tsots i'avanic: ―¡Joc'ano ta cruz! ―xiic. C'alal jech isujvanic li cristianoetique xchi'uc li banquilal paleetic yu'unique, ich'unbatic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Li Pilatoe laj yal mantal ti ac'o bat joc'anatuc ta cruz li Jesuse yu'un jech tsc'anic li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ja' la scolta batel li boch'o la sc'anique, ja' ti itic'at ta chuquel ta scoj la stsob svinictac yu'un la scontrain ajvalile, xchi'uc imilvan noxtoc. Li Pilatoe laj yac' ta c'abal li Jesuse yu'un ac'o spasbeic li c'usi ta sc'an yo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Li soldadoetique laj yiq'uic batel li Jesuse. C'alal xq'uechoj xa batel scruzal li Jesuse, tey la snupic ta be jun israel vinic tey liquem tal ta lum Cirene, Simón sbi. Tey ta x'och batel ta Jerusalén. La stsaquic, laj yac'beic xq'uechbe batel scruzal li Jesuse. Ja' ba'yucbe batel li Jesuse. Ja' ts'acalpat li Simone. ");
INSERT INTO tzotze_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oy ep viniquetic xchi'uc ep antsetic la xchi'inic batel li Jesuse. Li antsetique ep laj yoc'taic li Jesuse. Ep laj yat yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Li Jesuse la sc'opan: ―Antsetic, vo'oxuc ti li' nacaloxuc ta Jerusalene, mu me xavoc'taicun. Oc'tao aba atuquic xchi'uc oc'taic li avol anich'onique. ");
INSERT INTO tzotze_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yu'un ta to me sta sc'ac'alil chtal vocol. Jech chlic avalic: “Ja' lec li boch'otic mu ono'ox sna' x'alajique yu'un mu sta jech chich'ic vocol jech chac c'u cha'al chquich'tic, vu'utic ti oy coltique”, xachiic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vo'oxuc ti li' oyoxuc ta Jerusalene jech chlic avalic: “Oyuc c'uxi jemuc tal li vitse yu'un ac'o snet'uutic”, xachiic yu'un toj tsots li vocol chtale. ");
INSERT INTO tzotze_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Li vu'une ta jch'un scotol c'usitic yaloj li Diose, pero ep ta xiyac'bicun quich' vocol. Buuc xa li vo'oxuc ti mu xac'an xach'unic c'usitic yaloj Diose, ¡c'uxi ta xcuch avu'unic li vocol ta to xavich'ique! ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oy chib israel vinic i'ic'atic batel ec ti tsots smulique, co'ol bat yich'ic joc'anel ta cruz xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","C'alal ic'otic yo' bu Baquil Jolal sbi li banamile, tey c'ot sjoc'anic ta cruz li Jesuse xchi'uc li chib viniquetic ti tsots smulique. Jun scruzal ta sbats'ic'ob, jun scruzal ta sts'et. ");
INSERT INTO tzotze_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Li Jesuse lic sc'opanbe Dios li cristianoetique: ―Tati, pasbeic perdón yu'un mu sna'ic li c'usi ta spasique ―xi. Li soldadoetique la spasic canal tajimol yu'un tsvoc'beic sc'u' li Jesuse yu'un jech chilic bu jlicucal chc'ot ta stojol jujunic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Li cristianoetic tey va'ajtic ta xq'uelvanic tale la slabanic li Jesuse. Tey va'ajtic ec li jchapanvanejetique, la slabanic ec li Jesuse. Jech laj yalic: ―La scolta yantic. Me ta melel ti t'ujbil yu'un Dios chisventainutique, ac'o scolta sba stuc ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Li soldadoetique ilabanvanic ec. Inoch'ajic tal, laj yac'beic yuch' pajal ya'lel ts'usub. ");
INSERT INTO tzotze_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jech laj yalbeic: ―Me ta melel vo'ot muc'ta ajvalilot yu'un achi'iltac ta israelale, colta aba atuc ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oy te' tey bajbil ta sjol scruzal li Jesuse ts'ibabil ta griego c'op, xchi'uc ta latin c'op, xchi'uc ta ebreo c'op. Jech chal: “Li'i ja' muc'ta ajvalil yu'un israeletic”, xi ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Li viniquetic ti tsots smulic tey co'ol joc'ajtic ta cruz xchi'uc Jesuse, jun la stoy sba ta stojol li Jesuse, jech laj yalbe: ―Me ta melel vo'ot Cristoot ti t'ujbilot yu'un Dios chaventainuncutique, colta aba atuc. Jech coltauncutic ec ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Li yane la spajes li xchi'ile, jech laj yalbe: ―¿Me yu'un mu xaxi' yu'un Dios ti chatoy aba ta stojol li vinic li' co'ol chijmilat jchi'uctique? ");
INSERT INTO tzotze_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Li vu'utique oy jmultic jech ep chquich'tic vocol. Yu'un ja' chij'ac'bat jtojtic li c'usitic chopol la jpastique. Li vinic li'i mu'yuc c'usi chopol spasoj ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Li vinic ti la spajes xchi'ile jech laj yalbe li Jesuse: ―Cajval, na'un me ti c'alal ta xtal apas mantal li' ta banamile ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Li Jesuse jech laj yalbe: ―Melel chacalbot, li' ta orae chachi'inun batel ta lequilal ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","C'alal jech laj yale, o'lol xa van c'ac'al. Ja' o i'ic'ub osil ta scotol banamil. Ic' icom c'alal to ta o'lol syalel c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ic'uben o li c'ac'ale. Li muc'ta poc' tey joc'ol ta yut templo ta Jerusalene ili' ta o'lol. ");
INSERT INTO tzotze_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Li Jesuse tsots i'avan, jech laj yal: ―Tati, ta xcac' ta ac'ob li jch'ulele ―xi. C'alal laj yal jeche, iloc' xch'ulel. ");
INSERT INTO tzotze_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","C'alal laj yil capitán soldado c'usitic ic'ot ta pasele, laj yich' ta muc' li Diose, jech laj yal: ―Ta melel mu'yuc smul li vinic li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Scotol li cristianoetic tey stsoboj sbaique, c'alal laj yilic scotol li c'usitic ic'ot ta pasele, isutic batel ta snaic. La smajilan batel sna yo'ntonic yu'un ixi'ic me ch‑ac'batic castigo yu'un Dios ta scoj ti la smilic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Scotol li boch'otic lec la sc'opan sbaic xchi'uc Cajvaltique, xchi'uc li yajchanc'optac Cajvaltique, xchi'uc li antsetic liquemic tal ta Galilea ti la xchi'inic tal li Jesuse, nom no'ox va'ajtic ta sq'uelic tal scotol li c'usitic ic'ot ta pasele. ");
INSERT INTO tzotze_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tey oy jun vinic, José sbi. Ja' tey liquem tal ta lum Arimatea ta Judea banamil. Ja' jun jchapanvanej tey ta templo ta Jerusalén. Ja' lequil vinic. Smalaoj ti chtal ventainaticuc yu'un Diose. Tuc' yo'nton, mu'yuc la stic' sba c'alal la sa'beic smul Jesús li yan jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja' bat sc'opan li Pilatoe. La sc'anbe sbec'tal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Li Pilatoe la sloq'ues mantal jech bat syalesbe ta cruz sbec'tal Jesús li Josée. La xpix lec ta saquil manta, tey bat smuc ta ach' ch'en ta vombil ton. ");
INSERT INTO tzotze_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja' ta bat c'ac'al viernes ti imucate. Ja' xa sc'ac'alil ta xchapan sbaic yu'un xa tey ta xlic xcux yo'ntonic me ich'ay li c'ac'ale. ");
INSERT INTO tzotze_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Li antsetic ti liquemic tal ta Galilea ti la xchi'inic tal li Jesuse, ibatic ta muquinal ec. Laj yilic bu la smucbeic comel sbec'tal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","C'alal laj yilique, isutic batel ta snaic. C'alal ic'ot ta snaique, ta ora la xchapanic muil vomoletic xchi'uc muil poxil yu'un ja' chbat yac'beic ta sbec'tal li Cajvaltique yu'un jech mu xtuib ta ora. Yu'un ja' jech stalelic o li israeletique. Pero muc xbat yaq'uic ta ora yu'un ja' xa sc'ac'alil ta xcux yo'ntonic jech chac c'u cha'al chal li mantaletic yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jech ta sliquebal to semana ibatic ta muquinal li antsetique, ja' li domingoe. Sc'an to tsacub ti c'alal ibatique. Yich'ojic batel li muil vomoletique xchi'uc li muil poxil ti la xchapanique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","C'alal ic'otique, balch'unbil xa'ox loq'uel c'ot staic li ton ti macbil o sti' ch'ene. ");
INSERT INTO tzotze_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I'ochic ta yut pero mu'yuc xa tey oy la staic li sbec'tal Cajvaltic Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","C'alal tey chlo'ilaj yo'ntonique, laj yilic tey va'al ta sts'elic chib xco'laj xchi'uc viniquetic yilel. Toj sac li sc'u'ique chtu'p jsatic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jech toj xi'el ic'otic li antsetique, la snijan sbaic. Jech i'albatic: ―¿C'u yu'un tal aq'uelic li' ta muquinal li Boch'o cuxul o sbatel osile? ");
INSERT INTO tzotze_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mu'yuc xa li' oye, icha'cuxi xa. Na'ic me ti jech ono'ox laj yalboxuc c'alal tey to'ox oyoxuc ta Galileae. ");
INSERT INTO tzotze_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jech laj yal: “Ta persa ta xi'ac'at ta sc'ob jpasmuliletic, vu'un ti co'ol cristianoutique. Ta sjoc'anicun ta cruz, tey chismilicun. Chimucat, pero chicha'cuxi ta yoxibal c'ac'al”, xayutoxuc ono'ox ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Li antsetique tey ivul ta sjolic ti jech ono'ox albilique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jech iloq'uic tal ta yut li ch'ene, isutic tal. Li c'usitic i'albatique tal yalbe ya'yic li buluchib yajchanc'optac Jesuse xchi'uc li yantique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Li antsetic ti tal yalbeic li jcholc'opetic yu'un Jesuse, ja' li María ti liquem tal ta Magdalae, xchi'uc Juana, xchi'uc yan María, ja' sme' li Jacoboe, xchi'uc yan antsetic tey xchi'inojic. ");
INSERT INTO tzotze_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Li jcholc'opetique la snopic ti altic chalic li antsetique jech muc xch'unbeic li c'usi laj yalique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yan li Pedroe ta ora ibat ta anil ta smuquinal Jesús. La scujan sba, la sq'uel ochel li yut ch'ene. Laj yil ti ja' xa no'ox tey oy li saquil manta ti la xpixbeic o sbec'tal Cajvaltique. Mu'yuc xa tey oy li sbec'tale. Jech ep ilo'ilaj batel yo'nton ti c'alal isut batele. ");
INSERT INTO tzotze_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta sc'ac'alil c'alal icha'cuxi loq'uel ta ch'en li Cajvaltique, ta bat c'ac'al oy chib boch'o xch'unojbeic sc'op li Jesuse, iloq'uic batel ta Jerusalén, ibatic ta sbelal jun tsobtsobnaetic Emáus sbi. Oy no'ox van chibuc reva xil sba xchi'uc li Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tey ta slo'iltaic batel c'u x'elan imilat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","C'alal ja' o chlo'ilajique, tey ital ta spatic li Jesuse. Jech tey la xchi'inic batel ta xanubal. ");
INSERT INTO tzotze_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero imacbat satic yu'un li Diose jech muc xotquinic me ja' Jesús ti tey xchi'uquic batel ta bee. ");
INSERT INTO tzotze_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jech ijac'batic yu'un li Jesuse: ―¿C'usi chalo'iltaic? ―x'utatic. Tey iva'iic. Li Jesuse laj yil ti ep ta xat yo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Itac'ov li june, ja' Cléofas sbi: ―Li jchi'iltactic tey talemic ta q'uelq'uin ta Jerusalene laj ya'yic scotolic li c'usi ja' to no'ox ic'ot ta pasel tey ta Jerusalene. ¿C'u yu'un muc xava'i vo'ote? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Itac'ov li Jesuse: ―¿C'usi ic'ot ta pasel? ―xi. Itac'ovic: ―Yu'un la smilic li Jesús liquem tal ta Nazarete. Ja' yaj'alc'op Dios. Lec icoltaat yu'un Dios jech ivu' yu'un la spas ep sq'uelubil stsatsal. Xchi'uc lec ichanubtasvan, ic'ot ta co'ntoncutic li sc'ope. Lec i'ilat yu'un jchi'iltactic ta israelal. ");
INSERT INTO tzotze_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ja' no'ox banquilal paleetic xchi'uc jchapanvanejetic cu'untic i'ac'vanic ta c'abal. Ta stojol ajvalil ichapaj yu'unic ti ta persa ta xchame. Jech tey la sjoc'anic o ta cruz. ");
INSERT INTO tzotze_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Li vu'uncutique la jch'uncutic ti ja' ch‑och ta ajvalilal cu'untic, vu'utic li israelutique. Yoxibal xa c'ac'al ti imilate. ");
INSERT INTO tzotze_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero oy c'usi yan laj ca'icutic sob nax. Toj ch'ayel ic'ot co'ntoncutic ta sventa c'usi laj yalbuncutic li antsetic ti co'ol la jchi'incutic li Jesuse. Yu'un sob nax i'ayic ta smuquinal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pero mu'yuc xa la tey oy c'ot staic li sbec'tale. C'alal laj yilic ti mu'yuc xa tey oye, isutic batel, bat yalbuncutic. Tey la oy j'almantaletic laj yilic. Tey la i'albatic ti cha'cuxem xa li Cristoe. ");
INSERT INTO tzotze_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jech ibatic jayibuc jchi'iltac ec, ay sq'uelbeic li smuquinale. Ti c'u x'elan laj yalic li antsetique ja' la jech laj yilic ec. Pero mu'yuc xilic ec li Jesuse ―xutic Jesús li chibique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jech i'albatic yu'un li Jesuse: ―Mu bijucoxuc. Vocol chach'unic scotol c'usitic yalojic li yaj'alc'optac Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Me mu jechuc ts'ibabil yu'un j'alc'opetic ti ta persa ba'yuc ta xich' vocol li Cristoe, ti ts'acal to ta x'och ta ajvalilale? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Li Jesuse laj yac'be sna'ic scotol ti bu ts'ibabil sc'oplal stuc ta sc'op Diose. Ja' ba'yuc laj yal ti bu la sts'iba comel Moisese, xquechet laj yal ti bu la sts'ibaic li yantic yaj'alc'optac Dios ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","C'alal ic'otic ta Emáuse, li Jesuse tsc'an ta xjelov batel stuc. ");
INSERT INTO tzotze_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Li chib viniquetique la spajesic. Jech laj yalbeic: ―Pajan li'i, chi'inuncutic yu'un bat xa c'ac'al. Jutuc xa sc'an x'ic'ub osil ―xutic. Jech la xch'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","C'alal tey xchi'uquic ta chotlej ta ti' mesae, la stsac pan li Jesuse, la stojbe ta vocol Dios, la svoc' li pane, laj yac'be. ");
INSERT INTO tzotze_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","C'alal jech la spas li Jesuse, tey lic ac'batuc yotquinic yu'un Dios. Pero ta ora no'ox tey isacch'ay li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jech laj yalbe sbaic: ―¿C'u cha'al mu la jna'tic me ja' Cajvaltique yu'un toj lec laj ca'itic ti c'alal laj yalbutic tal smelol sc'op Dios ta bee? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jech ta ora isutic batel ta Jerusalén, bat yalbe ya'yic li xchi'iltaquic ti co'ol xch'unojique. Tey stsoboj sbaic c'ot staic li buluchib yajchanc'optac Jesuse xchi'uc oy yan xchi'iltaquic tey oyic. ");
INSERT INTO tzotze_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jech i'albatic yu'un li xchi'iltaquic tey oyic ta Jerusalene: ―Ta melel cha'cuxem xa li Cajvaltique. Laj xa yac' sba ta ilel ta stojol li Simón Pedroe ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Li chibique lic yalbe ya'yic ec ti c'u x'elan ilo'ilajic batel ta be xchi'uc li Jesuse, xchi'uc ti muc xotquinique, ti ja' to laj yotquinic c'alal la svoc' pane. ");
INSERT INTO tzotze_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","C'alal ja' o chlo'ilajic scotolique, ta ora tey va'al ivul ta stojolic li Jesuse. Jech laj yal: ―Junuc avo'ntonic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Toj xi'el no'ox ic'otic. La snopic ti ch'ulelal no'ox ti laj yilique. ");
INSERT INTO tzotze_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Li Jesuse jech laj yalbe: ―¿C'u yu'un chaxi'ic? ¿C'u yu'un chanopic ti mu vu'cune? ");
INSERT INTO tzotze_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Q'uelavilic li jc'ob xchi'uc cacane. Ja' vu'un. La' piquicun ava'yic. Ti ch'ulelalucune, mu'yuc jbec'tal, mu'yuc jbaquil ti jechuque ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","C'alal laj yal jech li Jesuse, laj yac' ta ilel li sc'obe xchi'uc li yacane. ");
INSERT INTO tzotze_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","C'alal laj yilique, toj xcuxet ic'ot yo'ntonic. Pero muc sna'ic lec me ta melel ti cha'cuxem xae yu'un ich'ay yo'ntonic. Jech ijac'batic yu'un li Jesuse: ―¿Me oy jutuc ve'lil avich'ojic tal? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jech tey laj yac'beic juteb vobil choy sti' xchi'uc laj yac'beic juteb spom muc'ta pom slo'. ");
INSERT INTO tzotze_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Li Jesuse tey sq'ueloj scotolic la stsac li ve'lile, tey lic ve'uc. ");
INSERT INTO tzotze_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jech lic albaticuc: ―C'alal jchi'inojoxuc to'oxe, laj ono'ox calboxuc ti persa ta xc'ot ta pasel scotol ti c'u x'elan ts'ibabil comel jc'oplal ta svun j'alc'op Moisés ta vo'onee, xchi'uc ta svun li yan yaj'alc'optac Dios ta vo'onee, xchi'uc ta svunal q'ueojetic ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jech tey i'ac'bat sbijilic yu'un li Cajvaltique, la xch'unic o ti jech ono'ox ts'ibabil comel sc'oplal ta sc'op Diose. ");
INSERT INTO tzotze_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jech laj yal noxtoc li Cajvaltique: ―Ts'ibabil ta sc'op Dios noxtoc ti ta ono'ox xquich' vocol xchi'uc milel, vu'un ti sc'oplal ono'ox chtal ventainvancune. Xchi'uc ti ta ono'ox xicha'cuxi ta yoxibal c'ac'ale. ");
INSERT INTO tzotze_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xchi'uc ti ta ono'ox xcholbatic scotol cristianoetic ti ac'o scomtsanic c'usitic chopol tspasique, ti ac'o xch'unic ti vu'un Jcoltavanejun yu'unique, jech ta spasbat perdón yu'un smulic. Ja' ba'yuc ta xcholbatic li boch'otic li' nacajtic ta Jerusalene. Ts'acal to xquechet ta xlic cholbaticuc scotol cristianoetic ta scotol banamil, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Vo'oxuc testigooxuc yu'un vo'oxuc laj avilic ti laj quich' vocole xchi'uc ti cha'cuxemun xae. ");
INSERT INTO tzotze_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A'yo ava'yic, ta jtacboxuc yalel tal li Ch'ul Espíritu ti yaloj ono'ox Jtotic ta xac'boxuque. Jech li' to me oyanic ta Jerusalén ja' to me ital li Ch'ul Espíritue. Ja' ta x'och ta avo'ntonic jech ta x'ayin o stsatsal avo'ntonic, jech xu' avu'un chacholic batel jc'op ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ta yan to c'ac'al laj yic' loq'uel ta Jerusalén yajchanc'optac li Jesuse. Ja' tey ibatic ta sbelal lum Betánia. C'alal ic'otic ta nopol Betániae, tey lic stoy xchibal sc'ob li Jesuse yu'un chac'be bendición li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","C'alal chac'be bendición li yajchanc'optaque, i'ic'at muyel ta vinajel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","C'alal laj yilic itoy batel ta vinajele, ech'em laj yich'ic ta muc'. Bats'i xcuxet no'ox yo'nton isutic ta Jerusalén. ");
INSERT INTO tzotze_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Scotol c'ac'al ibatic ta yamaq'uil templo tey ta Jerusalén. Xcuxet no'ox yo'nton laj yalbeic slequilal Dios ta sventa ti icoltaatic xae. ");
INSERT INTO tzotze_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","C'alal mu'yuc to'ox vinajel banamile, tey ono'ox oy o li boch'o i'ay yalbutic c'u x'elan yo'nton Jtotic Diose. Tey ono'ox xchi'inoj sbaic xchi'uc li Jtotic Diose. Li boch'o i'aye ja' ono'ox Dios. ");
INSERT INTO tzotze_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","C'alal mu'yuc to'ox vinajel banamile, tey ono'ox xchi'inoj sbaic xchi'uc li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Li boch'o i'aye ja' la spas scotol li c'usitic oye. Mu jechuc no'ox i'ayin stuc. ");
INSERT INTO tzotze_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Li boch'o i'aye ja' sventainoj cuxlejal sventa sbatel osil. Jech ta jna'tic o ti xu' chijcuxiutic sbatel osil ta sventa jech chac c'u cha'al cuxul o li stuque. Ja' luz c'otem cu'untic jcotoltic ti oyutic ta ic' osil ta scoj li mulile. ");
INSERT INTO tzotze_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ja' jech chac c'u cha'al luz ti tey tsanal ta ic' osile pero mu xtu'p. Ja' no'ox jech ec ac'o me mu sc'an xch'unic li cristianoetique, pero li boch'o i'aye tey ono'ox ta xalilan o ti chijcuxiutic sbatel osil ta sventa, vu'utic ti jch'unojtic ti ja' Jcoltavanej cu'untique. ");
INSERT INTO tzotze_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oy to'ox jun jchi'ilcutic ta israelal, Juan sbi ec. Ja' i'ac'bat yabtel yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ja' tal yal ti chtal xa li Jcoltavaneje yu'un jech ac'o xch'unic cristianoetic ti ja' chijcuxiutic sbatel osil ta sventae. ");
INSERT INTO tzotze_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma'uc Jcoltavanej li Juane. Ja' no'ox yich'oj tsots yabtel ta sventa chalbe sc'oplal li Jcoltavaneje. ");
INSERT INTO tzotze_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","C'alal ja' o chalbe sc'oplal li Juane, ja' o tey lic yac' sba ta ilel li Jcoltavaneje, ja' ti chac' jna'tic ti ja' no'ox ta sventa stuc xu' chijcuxiutic o sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Li boch'o i'aye ja' spasben scotol li c'usitic oye xchi'uc li cristianoetique. Pero muc x'otquinat ti c'alal i'ay li' ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ay xchi'inuncutic, vu'uncutic li israeluncutique, yu'un vo'one ono'ox t'ujbiluncutic yu'un. Pero ep jchi'iltac ti muc xich'ic ta muq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jcotolcutic ti jayib la jch'uncutic ti ja' ac'bil yabtel yu'un Dios ti ja' Jcoltavanej cu'untic ic'ote, xnich'naboxuc xa Dios lac'otic o, xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti jech xnich'naboxuc Dios xiyutuncutique, yu'un licha'voc'cutic xa ta ach'. Pero mu xco'laj xchi'uc jech chac c'u cha'al chvoc' xnich'on jun vinic yu'un jech tsc'an yo'nton stuc. Ja' ta sventa Dios ti chijcha'voc'utic ta ach'e. ");
INSERT INTO tzotze_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Li boch'o i'aye jech cristiano ic'ot jech chac c'u cha'al vu'utic. La xchi'inuncutic ta naclej, vu'uncutic li israeluncutique. Laj quilcutic ti toj lec yo'ntone yu'un lec la sc'anuncutic, xchi'uc melel scotol li c'usitic laj yalbuncutique. Yu'un ja' Xnich'on Jtotic Dios. C'ajumal jun Xnich'on oy li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Li Juan j'ac'vanej ta vo'e jech laj yalbe sc'oplal li Xnich'on Diose: ―Li'i ja' li boch'o laj calboxuc ava'yic ti ts'acal to ta xtale. Jech laj cal: “Ja' tsots yabtel yich'oj. Vu'une mu'yuc tsots cabtel quich'oj. C'alal mu'yuc to'ox voq'uemune, tey ono'ox oy o li stuque”, xacutoxuc ono'ox ―xi li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Li Xnich'on Diose toj ep slequil yo'nton. Jcotoltic xa laj quiltic ti oy slequil yo'nton cu'untique. Yu'un scotol c'ac'al chquiltic ti chiscoltautique, ti chijyac'butic slequil co'ntontique. ");
INSERT INTO tzotze_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ta sventa j'alc'op Moisés laj ca'itic scotol smantal li Diose pero muc xch'un cu'untic. Ta scoj Jesucristo lec xa chijyilutic li Diose yu'un j'ech'el la xch'aybutic o jmultic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Me junuc mu'yuc boch'o yiloj li Diose. Li Diose c'ajumal jun Xnich'on oy, pero co'ol yo'nton xchi'uc. Li Dios Nich'onile ja' laj yac'butic cotquintic c'u x'elan li Stote. ");
INSERT INTO tzotze_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Li jchapanvanejetic cu'uncutic tey ta Jerusalén, vu'uncutic li israeluncutique, la staquic tal jayibuc paleetic xchi'uc yajcoltaubbailic, ja' levitaetic sbiic. Jech vul sjac'beic li Juan j'ac'vanej ta vo'e: ―¿Boch'oot li vo'ote? ¿Me vo'ot ti sc'oplal ono'ox chatale? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Li Juane jamal laj yal ti mu ja'uc li Cristo ti sc'oplal chtal ventainvanuque. ");
INSERT INTO tzotze_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","La sjac'beic noxtoc: ―¿Boch'oot cha'e? ¿Me vo'ot Elíasot? ―xutic. Itac'ov li Juane: ―Mu vu'cun ―xi. La sjaq'uic yan velta: ―¿Me mu vo'ocot li yaj'alc'opot Dios ti ta jmalacutic ta xtale? ―xutic. ―Mu vu'cun ―xi itac'ov li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","La sjac'beic noxtoc: ―¿Pero boch'oot cha'e? Albun ca'icutic yu'un jech ta xc'ot calbecutic ec li boch'otic la stacuncutic tale. ¿C'usi avabtel? Albun ca'icutic ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Itac'ov li Juane: ―Vu'un jc'oplal laj yal li j'alc'op Isaías ta vo'onee. Jech laj yal: “Ta to xlic jun jchi'iltic ta israelal. Ja' tsots ta x'avan ta xocol banamil. Jech ta xal: Ta xa xtal li Cajvaltique. Ja' lec comtsanic scotol li c'usitic chopol chapasique, xi ta xlic yalbe li jchi'iltactique”, xi ono'ox li Isaíase ―xi itac'ov li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Li boch'otic itacatic tale ja' xch'unojic fariseo. ");
INSERT INTO tzotze_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jech la sjac'beic noxtoc li Juane: ―¿C'u yu'un chavac' ich' vo' me mu vo'ocot Cristoote, me mu vo'ocot Elíasote, me mu vo'ocot yaj'alc'opot Dios ti ta jmalacutic ta xtale? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Itac'ov li Juane: ―Li vu'une ja' no'ox cabtel ta xcac'be yich'ic vo' li boch'otic ta scomtsan c'usitic chopol ta spasique. Yan li boch'o tsots yabtel yich'oje ja' tey achi'uquic pero mu to xavotquinic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ja' li boch'o ts'acal ta xtal cu'une. Li vu'une mu'yuc tsots cabtel quich'oj. Me jutuc mu'yuc c'usi xu' cu'un ta jcolta. Ac'o me stitunbel yaq'uil xonob mu xu' cu'un ―xi li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ja' jech ic'ot ta pasel tey ta lum Betábara tey ta jot uc'um Jordán, ja' tey yo' bu laj yac' ich' vo' li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta yoc'omal laj yil Juan tey ta xtal Jesús yo' bu oye. Li Juane jech laj yalbuncutic, vu'uncutic ti tey jchi'inojcutique: ―Q'uelavilic, le' xa xtal li boch'o ac'bil tsots yabtel yu'un Diose. Ja' xchij Dios ta xc'ot yu'un ta xmilat, jech ta xtoj o jmultic ta scotol banamil. ");
INSERT INTO tzotze_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Le'e ja' li boch'o laj calboxuc ava'yic sc'oplale. Jech laj cal: “Ja' ts'acal ta xtal cu'un li boch'o tsots yabtel yich'oje. Li vu'une mu'yuc tsots cabtel quich'oj. C'alal mu'yuc to'ox voq'uemune, tey ono'ox oy o li stuque”, xacutoxuc ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Li vu'une muc xcotquin jtuc ti ja' Jcoltavanej cu'untic jcotoltique. Ja' to laj cotquin ti c'alal laj yac'bun quil li Diose. Yu'un ti ba'yuc tal cac' ich' vo'e, yu'un jech ac'o avotquinic ec, vu'utic ti co'ol israelutique ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jech laj yal noxtoc li Juan j'ac'vanej ta vo'e: ―Laj quil iyal tal ta vinajel li Ch'ul Espíritue xco'laj xchi'uc stsumut yilel. Tey ivul ta stojol jech laj yich' o li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Li vu'une mu to'ox xcotquin. Li Dios ti laj yac'bun cabtel tal cac' ich' vo'e, jech ono'ox yalojbun: “Boch'o ta xvul ta stojol li Ch'ul Espíritue, ja' li boch'o ta xac'boxuc avich'ic Ch'ul Espíritue”, xiyutun. ");
INSERT INTO tzotze_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Li vu'une laj xa cotquin. Laj xa calboxuc ava'yic ti ja' Xnich'on Diose ―xiyutuncutic li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta yoc'omal chibuncutic tey jchi'inojcutic li Juane yu'un vu'uncutic to'ox yajchanc'opuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Li Juane laj yil tey ta xanov batel li Jesuse, jech laj yalbuncutic: ―Q'uelavilic, le'e ja' xchij Dios ta xc'ot yu'un ta xmilat ta scoj jmultic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","C'alal laj ca'icutic jech laj yal li Juane, ja' bat jchi'incutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Li Jesuse la sq'uel sva'lupat. Laj yil ti tey nabaluncutic batel ta spate. Jech la sjac'buncutic: ―¿C'usi chasa'ic? ―xiyutuncutic. La jtac'becutic: ―Jchanubtasvanej, ¿bu nacalot? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Li Jesuse jech laj yalbuncutic: ―Batic, bat q'uelavilic ti bu nacalune ―xiyutuncutic. Tey la jchi'incutic batel, bat jq'uelcutic ti bu nacale. Tey la jchi'incutic ta vayel yu'un chib xa'ox ora sc'an x'ic'ub osil. ");
INSERT INTO tzotze_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Li jchi'il ti co'ol laj ca'ibecutic sc'op Juane xchi'uc ti co'ol la jchi'incutic batel li Jesuse, ja' Andrés sbi. Li Andrese oy sbanquil, ja' Simón Pedro sbi. ");
INSERT INTO tzotze_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ta ora bat sc'opan li sbanquile, ja' li Simone. Jech c'ot yalbe: ―Laj xa jtacutic li boch'o t'ujbil yu'un Dios chisventainutique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Li Andrese laj yic' tal ta stojol Jesús li sbanquile. Li Jesuse la sq'uelbe sat li Simone, jech laj yalbe: ―Vo'ot Simonot, xnich'onot Jonás. Cefas ta xcac'bot yan abi ―xut. (Ja' Cefas sbi ta jc'opcutic, ja' Pedro sbi ta griego c'op.) ");
INSERT INTO tzotze_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta yoc'omal la snop Jesús ti ta xibatcutic ta Galilea banamile. C'alal mu'yuc to batemuncutique, tey la sta jun jchi'ilcutic ta israelal, Felipe sbi. Jech laj yalbe: ―La' chi'inun batel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Li Felipee ja' liquem tal ta lum Betsáida. Ja' co'ol slumalic xchi'uc li Andrese xchi'uc li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Li Felipee ta ora bat sa' li Natanaele. Jech c'ot yalbe: ―Laj xa jtacutic li boch'o ts'ibabil comel sc'oplal ta svun jmoltotic Moisés ta vo'onee xchi'uc ta svunic li yan yaj'alc'optac Diose. Ja' Jesús tey liquem tal ta lum Nazaret, ja' xnich'on José ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Itac'ov li Natanaele: ―Mu'yuc bu ca'yojtic me oy boch'o lec tey ta xlic tal ta Nazaret ―xi. ―Pero bat jq'ueltic avil ―xi li Felipee. ");
INSERT INTO tzotze_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Li Jesuse laj yil ti noch' xa xtal li Natanaele, jech laj yal: ―Q'uelavilic, li jchi'iltic le' xtale ja' tuc' yo'nton, mu sna' xlo'lavan ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Li Natanaele laj ya'i, jech laj yalbe li Jesuse: ―¿C'uxi laj avotquinun? ―xut. Itac'ov li Jesuse: ―Laj quilot ti c'alal tey oyot ta yolon te'el igo ti c'alal mu'yuc to'ox chbat yic'ot tal li Felipee ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Itac'ov li Natanaele: ―Jchanubtasvanej, vo'ot Xnich'onot Dios. Vo'ot cha'och ta ajvalilal cu'uncutic, vu'uncutic li israeluncutique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Li Jesuse jech laj yalbe: ―Ta sventa laj calbot ti laj quilot c'alal tey oyot ta yolon te'el igoe jech chach'un o ti oy cabtele. Lec ti chach'une. Ta to xavil ti scotol xu' cu'une ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Li Jesuse jech laj yalbuncutic jcotolcutic: ―Melel li c'usi chacalboxuque. Vu'un ti co'ol cristianoutique ta to xavilic ti vu'un ta jventa xu' chac'otic ta stojol Diose ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","C'alal yoxibal xa c'ac'al jc'otelcutic ta Galilea banamil xchi'uc li Jesuse, oy boch'o inupin tey ta lum Caná tey ta Galilea banamil. Tey ital sq'uel nupinel ec li sme' Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Li Jesuse xchi'uc vu'uncutic li yajchanc'opuncutique li'ic'atcutic ta sq'uelel nupinel ec. ");
INSERT INTO tzotze_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","C'alal tey oyuncutic ta q'uel nupinele, ilaj li ya'lel ts'usub yu'unique. Li Jesuse jech ital albatuc yu'un li sme'e: ―Ilaj xa scotol li ya'lel ts'usub yu'unique ―xi vulel. ");
INSERT INTO tzotze_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Li Jesuse jech laj yalbe: ―Yaa, ¿c'u yu'un jech chtal avalbun yu'un mu'yuc to ta sta sc'ac'alil ta xlic jpas li cabtele? ―xut li sme'e. ");
INSERT INTO tzotze_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Li sme'e jech bat yalbe li j'ac've'liletique: ―Li c'usitic ta xalboxuque pasic me scotol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tey vuchajtic vaquib yav ya'alic pasbil ta ton, ja' sventa ta spoc o sc'obic. Yu'un jech jtalelcutic ti persa jal ta jpoc jc'obcutic, vu'uncutic li israeluncutique, yu'un ja' to jech lec chiyiluncutic o Dios calojcutic. Li jujun yav ya'alique x'och vo'ob vaquib q'uib vo'. ");
INSERT INTO tzotze_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Li Jesuse jech laj yalbe li j'ac've'liletique: ―Nojesic ta vo' scotol li yav vo'e ―xut. Jech lic snojesic, inoj yu'unic c'alal ta sti'. ");
INSERT INTO tzotze_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Li Jesuse jech laj yalbe: ―Lupic batel jutebuc, bat ac'beic spas ya'i li boch'o yich'oj ta venta sq'uelel ve'lile ―xut. Jech lic slupic batel, bat yac'beic. ");
INSERT INTO tzotze_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Li boch'o yich'oj ta venta sq'uelel scotol ve'lile, c'alal laj ya'i ti más to leque, mu sna' bu ital yu'un vo' no'ox ti ic'ataj ta ya'lel ts'usube. Stuc no'ox sna'ojic j'ac've'liletic ti bats'i vo' c'alal la slupic batele. Li boch'o yich'oj ta venta sq'uelel scotol ve'lile laj yic' tal li boch'o ta xnupine. ");
INSERT INTO tzotze_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Jech laj yalbe: ―Li vu'utique jech jtaleltic o ti ja' ba'yuc ta xcac'tic ta uch'el ti bu más lec li ya'lel ts'usube. C'alal me ep xa laj yuch'ique, ja' o ta xcac'tic ta uch'el ti bu mu'yuc xa leque. Li vo'ote ja' laj anac' ti bu más leque, ja' to chavac' ta uch'el li' ta orae ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ja' jech ic'ot ta pasel tey ta lum Caná tey ta Galilea banamil. Ja' sba to velta laj yac' ta ilel sq'uelubil ti scotol xu' yu'un li Jesuse. Vu'uncutic li yajchanc'opuncutique la jch'uncutic ti ja' Xnich'on Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ts'acal to tey iyal batel ta lum Capernaum li Jesuse. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique, xchi'uc li sme'e xchi'uc li yits'inabe. Tey lijoc'tsajcutic chib oxib c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jutuc xa'ox sc'an sta sc'ac'alil q'uin coltael cu'uncutic, vu'uncutic li israeluncutique. Li Jesuse ibat ta Jerusalén. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tey oyic ta yamaq'uil templo c'ot jtacutic jchonvacaxetic, xchi'uc jchonchijetic, xchi'uc jchonpalomaetic. Tey chotajtic noxtoc jeltaq'uinetic yu'un jech tspasic o canal. ");
INSERT INTO tzotze_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Li Jesuse ta laso la smeltsan storcío. Ja' la sibtas o loq'uel scotol li jchonchijetique xchi'uc li jchonvacaxetic tey oyic ta yamaq'uil temploe. Sibtasbil iloq'uic batel xchi'uc xchijic xchi'uc xvacaxic. Li Jesuse la sbutq'uinbe smesaic noxtoc li jeltaq'uinetique, tey itanij comel li staq'uinique. ");
INSERT INTO tzotze_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jech laj yalbe li jchonpalomaetique: ―Iq'uic loq'uel li apalomaique. Li sna Jtote mu me xapasic ta snail ch'ivit ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","C'alal jech la spas li Jesuse, vu'uncutic li yajchanc'opuncutique tey ivul ta jolcutic ti jech ono'ox ts'ibabil comel ta sc'op Diose: “Tati, yu'un ti scotol co'nton ta jc'an cha'ich'at ta muc' tey ta templo avu'une, jech ta xlic quich' contrainel”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Li jchapanvanejetic cu'uncutic tey ta temploe jech tal yalbeic li Jesuse: ―¿Boch'o laj yac'bot avabtel ti xu' chatac loq'uel li jbolomaletique? Ac'bun quilcutic sq'uelubil atsatsal yu'un jech ta jna'cutic o ti oy avabtele ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Itac'ov li Jesuse: ―Vuq'uesic li templo li'i, vu'un ta jcha'va'an ta oxib c'ac'al ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Li jchapanvanejetique jech laj yalbeic li Jesuse: ―Ta vaquib yoxvinic (46) jabil imeltsaj li templo li'i. ¿C'uxi chavut ti ta oxib no'ox c'ac'al chacha'va'an chavale? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Li templo laj yal Jesuse ja' laj yal ta sventa sbec'tal stuc. Yu'un c'alal ta xchame ta xcha'cuxi ta yoxibal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jech c'alal icha'cuxi ta yoxibal c'ac'al li Jesuse, vu'uncutic li yajchanc'opuncutique ja' to tey ivul ta jolcutic ti jech ono'ox laj yalbe jchapanvanejetique. Ja' to tey la jch'uncutic ti jech ono'ox ts'ibabil comel sc'oplal ta sc'op Dios ti ta persa ta xchame, xchi'uc ti ta xcha'cuxi loq'uel ta ch'ene. La jna'cutic noxtoc ti ja' melel c'usi laj yalbe li jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Li Jesuse tey xa'ox oy ta Jerusalén ti c'alal sta yorail q'uin coltaele. Tey jchi'inojcutic, vu'uncutic li yajchanc'opuncutique. Ep jchi'iltaccutic ta israelal la xch'unic ti ja' t'ujbil yu'un Dios chventainvan li Jesuse ti c'alal laj yilic ep sq'uelubil stsatsal la spase. ");
INSERT INTO tzotze_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Li Jesuse la sna' ti mu scotoluc j'ech'el chac' sbaic ta ventainel li jchi'iltaque. ");
INSERT INTO tzotze_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yu'un mu persauc oy boch'o ta x'albat ya'i c'u x'elan yo'nton li cristianoetique. Li stuque sna'ojbe ono'ox c'u x'elan yo'nton li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oy to'ox jun jchi'ilcutic ta israelal, Nicodemo sbi. Ja' xch'unoj fariseo. Ja' jchapanvanej cu'uncutic ta templo tey ta Jerusalén. ");
INSERT INTO tzotze_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Li Nicodemoe ta ac'ubaltic ay sc'opan li Jesuse. Jech laj yalbe: ―Jchanubtasvanej, ta jna'cutic ti ja' stacojot tal li Diose yu'un tal achanubtasuncutic. Ti manchuc chi'inbilot yu'un Diose, mu xu' avu'un chapas sq'uelubiltac atsatsal jech chac c'u cha'al chapase ―xi li Nicodemoe. ");
INSERT INTO tzotze_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Itac'ov li Jesuse: ―Melel li c'usi chacalbote, li boch'o mu'yuc cha'voq'uem ta ach'e, mu xu' ta xventainat yu'un Dios ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Li Nicodemoe jech la sjac'be li Jesuse: ―¿C'u x'elan xu' ta xcha'voc' ta ach' li boch'o mol xae? Yu'un mu xa xu' ta x'och ta yut xch'ut sme' yan velta ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Itac'ov li Jesuse: ―Melel li c'usi chacalbote, me ja' no'ox chavich'ic vo'e, me mu jelbiluc avo'ntonic yu'un Ch'ul Espíritue, mu xu' cha'ochic yo' bu tspas mantal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yu'un c'alal lavoq'uic li' ta banamile, jpasmuliloxuc jech chac c'u cha'al li atot ame'ique. Pero me chacha'voq'uic ta sventa li Ch'ul Espíritue, ach' xa avo'ntonic, mu xa xac'anic c'usi chopol. ");
INSERT INTO tzotze_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mu me toj ch'ayeluc ta xc'ot avo'nton yu'un ti laj calbot ta persa chacha'voc' ta ach'e. ");
INSERT INTO tzotze_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Buyuc no'ox ta xbat li iq'ue. Chava'i ti xvo'et no'oxe pero mu xana' bu ta xtal, mu xana' bu ta xbat. Ja' no'ox jech ta x'abtej ta yo'nton cristianoetic li Ch'ul Espíritue. Mu xana'ic bu ch‑abtej ja' to me chavilic ti jelbil xa yo'nton jun cristianoe ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Li Nicodemoe jech la sjac'be li Jesuse: ―¿C'uxi xu' chc'ot ta pasel jech? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Itac'ov li Jesuse: ―¿C'uxi xu' chachanubtas li jchi'iltactic me mu xava'ibe smelol ec li c'usi chacalbote? ");
INSERT INTO tzotze_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Melel li c'usi chacalbote, li vu'une ja' ta xcal li c'usi jna'e xchi'uc li c'usi quiloje. Li vo'oxuque mu xavich'ic ta muc' li c'usi chcale. ");
INSERT INTO tzotze_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Me mu xach'un c'usi ta spas Dios li' ta banamil jech chac c'u cha'al laj calbote, ¿c'uxi xu' chach'un me chacalbot c'usi ta spas Dios tey ta vinajele? ");
INSERT INTO tzotze_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Me junuc mu'yuc boch'o ayem sq'uel tal ta vinajel c'u x'elan ti jech xu' ta xalboxuque. Jtuc no'ox xu' ta xcalboxuc yu'un tey liquemun tal, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jech chac c'u cha'al la sjoc'anbe ta te' sloc'obbal chon tey ta xocol banamil li jmoltotic Moisés ta vo'onee, ja' jech ta to xijoc'anat ta cruz, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Scotol boch'o ta xch'unic ti ja' sventa ta xcolic o ti ta xijoc'anat ta cruze, ja' ta xcuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Li Jtotic Diose toj c'ux ta yo'nton scotol cristianoetic ta banamil jech la stacun tal, vu'un li Xnich'onune. Pero c'ajumal jtuc. Scotol boch'o ta xch'un ti vu'un ta jcoltae ja' mu ch'ayeluc ta xbat. Ja' ta xcuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Li Jtotic Diose la stacun tal li' ta banamil pero mu yu'unuc tal cac'be castigo yu'un smulic li cristianoetique. Ja' tal jcolta. ");
INSERT INTO tzotze_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Boch'otic ta xch'un ti vu'un ta jcoltae ja' mu'yuc ta xich'ic castigo yu'un smulic. Li boch'otic mu sc'anic coltael cu'une chapanbil xa ti persa ta xich'ic castigoe, yu'un mu xch'unic ti vu'un Jcoltavanejun, vu'un li Xnich'onun Diose. C'ajumal jtuc, mu'yuc yan Xnich'on li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ta xich'ic castigo yu'un li' xa oyun ta banamil, vu'un li Xnich'onun Diose. Jech chac c'u cha'al c'alal ta sacub osile, ta xvinaj scotol me oy c'usi chopol ic'ot ta pasele, ja' no'ox jech ti c'alal lital li' ta banamil, vu'un li Xnich'onun Diose, ivinaj ti oy smulic scotol cristianoetique. Li cristianoetique mu sc'an xtalic ta jtojol yu'un chopol scotol li c'usitic ta spasique. Ja' lec cha'yic spasel scotol li c'usi chopole. ");
INSERT INTO tzotze_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Scotol li boch'otic chopol c'usi ta spasique mu sc'an xtalic ta jtojol, vu'un li Xnich'onun Diose, yu'un mu sc'anic albel ti oy smulique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yan li boch'otic ja' tspasilanic c'usi yaloj Diose, ja' ta xtalic ta jtojol, jech chvinaj o ti yich'ojic ta muc' Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ts'acal to iloc' batel ta lum Jerusalén li Jesuse. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Tey lixanovcutic ta Judea banamil. Tey lijoc'tsajcutic jayibuc c'ac'al. Tey laj yich'ic vo' scotol li boch'otic co'ol tey jchi'inojcutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jech ec li Juane tey ta xac' ich' vo' ta lum Enón yu'un ja' oy ep vo' tey. Li Enone ja' noch' xil sbaic xchi'uc lum Salim. Li boch'otic ibatic jujun c'ac'al yo' bu oy Juane tey i'ac'batic yich'ic vo' yu'un Juan. ");
INSERT INTO tzotze_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yu'un mu'yuc to'ox ochem ta chuquel li Juane. ");
INSERT INTO tzotze_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Li yajchanc'optac Juane oy jayibuc la stsac sbaic ta lo'il xchi'uc jayibuc jchi'ilcutic ti tey co'ol jchi'inojcutic li Jesuse. Li yajchanc'optac Juane chopol laj ya'yic ti tey ta xtal yich'ic vo' ta stojol Jesús li jchi'iltaccutique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jech laj yalbeic li Juane: ―Jchanubtasvanej, li boch'o tey ital ta atojol le' ta jot uc'um Jordán ti laj avalbe sc'oplale, ja' ta xac' ich' vo' ec. Scotol cristianoetic tey ta xbat xchi'inic ―x'utat yu'un li yajchanc'optaque. ");
INSERT INTO tzotze_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Itac'ov li Juane: ―Ja' smantal stuc Dios ti c'usitic abtelal ta xac'be jujune. ");
INSERT INTO tzotze_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Li vo'oxuque laj ava'yic ti c'alal jech laj cale: “Mu vu'cun t'ujbilun yu'un Dios chajventainoxuc. Li vu'une ja' no'ox cabtel laj yac'bun Dios ti ba'yuc tal cal ti chtal xa li boch'o chisventainutique”, xcut li jchi'iltactique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chana'ic ti c'alal ta xic' yajnil jun vinique, li antse mu ja'uc ta xic' sbaic xchi'uc li yajtestigo vinique. Ja' ta xic' sbaic xchi'uc li smalale. Li boch'o ochem ta testigo yu'un vinique ja' no'ox tey va'al ta sq'uel ta xnupinic li vinique xchi'uc li antse. C'alal ta xa'i ti lec ta sc'an sbaique, xcuxet no'ox yo'nton. Ja' no'ox jechun ec li vu'une, xcuxet no'ox co'nton ti ja' chbat xchi'inic Jesús li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ta persa ja' ta xpuc batel sc'oplal li Jesuse. Li vu'une ta persa ta xlaj jc'oplal ―xi li Juan j'ac'vanej ta vo'e. ");
INSERT INTO tzotze_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Li Jesuse ja' tacbil yalel tal yu'un Dios, ja' sventainoj scotol. Li boch'o li' no'ox oy ta banamile, ja' no'ox oy yabtel li' ta banamil. Ja' no'ox ta xal li c'usitic chil li' ta banamile. Li Jesuse ja' tey liquem tal ta vinajel, ja' scotol xu' yu'un. ");
INSERT INTO tzotze_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja' ta xal li c'usitic yiloj tey yo' bu oy Diose xchi'uc li c'usitic tey ya'yoje. Pero mu'yuc ep boch'o ta xich'beic ta muc' li sc'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yan li boch'otic ta xch'unic c'usi chal li Jesuse, ja' svinajeb ti ta xch'unic ti ic'ot xa ta pasel ti yaloj ono'ox Dios tstac tal li Xnich'one. ");
INSERT INTO tzotze_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Li Jesús ti tacbil tal yu'un Diose ja' sc'op Dios ta xal, yu'un j'ech'el i'ac'bat o yu'un Dios li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Li Jtotic Diose lec sc'anoj li Xnich'one. Scotol yac'ojbe sventain. ");
INSERT INTO tzotze_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Scotol boch'o ta xch'unic ti ja' chcolic ta sventa li Xnich'on Diose, ja' chcuxiic sbatel osil. Scotol li boch'otic mu xch'unique mu xu' ta xcuxiic sbatel osil. Ja' ta x'ac'batic tsots castigo yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Li Jesuse laj ya'i jech i'albatic li fariseoetique: ―Ja' xa ta x'epaj boch'o ta xchi'inic li Jesuse yu'un ja' ep ta xac' ich' vo'. Ja' xa ta x'ul boch'otic ta xchi'inic li Juane ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Pero jeche' no'ox la snopic ti ja' laj yac' ich' vo' li Jesuse yu'un vu'uncutic laj cac'cutic li yajchanc'opuncutique.) ");
INSERT INTO tzotze_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","C'alal jech laj ya'i li Jesuse, jech laj yalbuncutic: ―Ja' lec loc'cutic batel li' ta Judea banamile ―xiyutuncutic. Jech liloc'cutic batel ta Judea, tey chisutcutic batel ta cosilalcutic ta Galilea banamil. ");
INSERT INTO tzotze_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","C'alal chibatcutique, tsc'an tey ta xjelov batel ta Samaria banamil li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jech tey lic'otcutic ta lum Sicar tey ta Samaria banamil. Ja' xa tey noch' xil sbaic xchi'uc li yosil ánima jmoltotcutic José ta vo'onee, ja' ti i'ac'bat comel yu'un ánima stote, ja' li Jacove. ");
INSERT INTO tzotze_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tey oy jun pozo, ja' pasbil yu'un li jmoltotcutic Jacov ta vo'onee. Li Jesuse tey ichoti ta sts'el pozo yu'un luben xa ta xanubal. Jutuc xa'ox sc'an sta o'lol c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ja' o tey ital slup ya'al jun samaria ants. Li Jesuse jech laj yalbe: ―Ac'bun jutebuc ava'al cuch' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Vu'uncutic li yajchanc'opuncutique batemuncutic ta yut lum yu'un bat jmancutic tal jve'elcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Li samaria antse jech la sjac'be li Jesuse: ―¿C'u yu'un chac'anbun vo' avuch' yu'un israel vinicot? Li vu'une samaria antsun ―xut. (Ti jech laj yal li antse, yu'un chopol ono'ox chil sbaic xchi'uc samariaetic li jchi'iltac ta israelale.) ");
INSERT INTO tzotze_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Itac'ov li Jesuse: ―Ana'uc ti tsc'an ta xac'bot amoton li Diose xchi'uc ti lajuc avotquinun ti c'alal la jc'anbot ava'al cuch'e, vo'ot ba'yuc laj ac'anbun vo' ti jechuque. Ja' laj cac'bot li vo' sventa chacuxi o sbatel osile ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Li antse jech laj yal: ―Tata, mu'yuc slupubil avu'un. Yu'un toj nat li pozoe. ¿Bu chata li vo' chavac'bun ti xu' chicuxi o yu'un sbatel osil chavale? ");
INSERT INTO tzotze_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Li jmoltotic Jacov ta vo'onee ja' laj yac'buncutic li pozo li'i. Ja' laj yuch'ic xchi'uc xnich'nab, xchi'uc xvacax, xchi'uc xchij. ¿Me yu'un vo'ot to más tsots avabtel avich'oj? ―xi li antse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Itac'ov li Jesuse: ―Scotol boch'o ta xuch'ic li vo' li'i ta to xtaquij yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yan li boch'otic ta xuch'ic li vo' ta xcaq'ue ja' mu'yuc xa ta xtaquij o yo'ntonic. Li vo' ta xcaq'ue ja' jech chc'ot jech chac c'u cha'al nio' yu'un tey ta xloq'uilan tal ta yo'ntonic jech ta xcuxiic o sbatel osil ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Li antse jech laj yal: ―Tata, ac'bun cuch' li vo' chavale yu'un jech mu'yuc xa ta xtaquij o co'nton. Jech mu'yuc xa ta xtal jlup o ca'al li'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Itac'ov li Jesuse: ―Bat ic'o tal amalal ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Itac'ov li antse: ―Mu'yuc jmalal ―xi. Itac'ov li Jesuse: ―Melel ti mu'yuc amalale. ");
INSERT INTO tzotze_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yu'un yo'bal xa amalal laj avicta. Yan li boch'o tey avic'oj aba achi'uc ta orae muc xa nupinemucot achi'uc. Ja' melel li c'usi laj avalbune yu'un mu ja'uc amalal ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Li antse jech laj yal: ―Tata, vo'ot yaj'alc'opot Dios ta xca'i. ");
INSERT INTO tzotze_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Li jmoltotactic ta vo'onee li' laj yich'ic ta muc' Dios ta jol vits. Vo'oxuc li israeloxuque chavalic xa ti ja' tsots sc'oplal tey ta xbat quich'cutic ta muc' Dios ta lum Jerusalene ―xi li antse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Li Jesuse jech laj yalbe li antse: ―Ch'uno li c'usi ta xcalbote. Ta to me sta sc'ac'alil ta xlaj sc'oplal ti li' chavich'ic ta muc' Jtotic Dios ta vitse xchi'uc ti tey chabatic ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Vo'oxuc ti li' oyoxuc ta Samariae mu xtun avu'unic li c'usitic la sts'ibaic comel yaj'alc'optac Dios ta vo'onee. Jech mu xana'ic ti jech ono'ox yaloj Dios ti ja' jchi'ilcutic ta israelal li boch'o ta scolta scotol cristianoetic yu'un smulique. ");
INSERT INTO tzotze_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Po'ot xa tsta sc'ac'alil ti buyuc xa no'ox ta xich'ic ta muc' Jtotic Dios ta yo'ntonic li boch'otic ta melel xch'unojique. Li Jtotic Diose ta sa' li boch'otic jech ta x'ich'at ta muq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mu'yuc sbec'tal li Jtotic Diose jech mu xavilic. Ja' no'ox jech ec li boch'otic scotol yo'nton yich'ojic ta muc' Diose mu xavilic yu'un ta yo'ntonic no'ox yich'ojic ta muc'. Ja' jech tsc'an chquich'tic ta muc' li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Li antse jech laj yal: ―Ca'yoj ono'ox ti ta xtal li boch'o t'ujbil yu'un Dios chisventainutique. C'alal ta xtale, jamal ta xalbutic scotol c'usi tsc'an Dios ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Itac'ov li Jesuse: ―Vu'un ti li' ta jc'opanote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","C'alal ja' o jech chlo'ilaj xchi'uc ants li Jesuse, ja' o livulcutic, vu'uncutic li yajchanc'opuncutique. Tey toj ch'ayel ic'ot co'ntoncutic, yu'un li boch'otic ochemic ta jchanubtasvaneje mu xu' ta xlo'ilajic xchi'uc ants ta be xchi'uc ta calle. Pero mu'yuc boch'o junucal la sjac'be cu'uncutic ti c'usi tsjac'bee xchi'uc ti c'u yu'un chlo'ilaj xchi'uque. ");
INSERT INTO tzotze_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Li antse tey la scomtsan ta pozo li sq'uibe. Isut batel ta yut lum. Jech c'ot yalbe scotol li cristianoetique: ");
INSERT INTO tzotze_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―La'ic. La' q'uelavilic, oy jun vinic tey oy ta pozo, ja' laj yalbun scotol li c'usitic jpasoje. Ja' xa van li boch'o t'ujbil yu'un Dios ti sc'oplal ono'ox chtal sventainutique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ta ora iloq'uic tal li cristianoetic tey ta lume, tal sq'uelic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","C'alal ja' o batem li antse, vu'uncutic li yajchanc'opuncutique jech laj calbecutic li Jesuse: ―Jchanubtasvanej, ve'an ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Itac'ov li Jesuse: ―Oy jve'el, pero mu xana'ic c'u x'elan ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Li vu'uncutique jech la jac'be jbacutic: ―¿Me yu'un van oy boch'o ay ac'batuc sve'el? ―xcut jbacutic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Li Jesuse jech laj yalbuncutic: ―Ja' jve'el c'otem ti ta jpasbe c'usi tsc'an Diose, ja' ti la stacun tale. Ja' ta jvu'es li cabtel yac'ojbune. ");
INSERT INTO tzotze_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jech chavalic: “Chanib to u sc'an sta yorail ta xich' tuch'el li trigoe”, xachiic. A'yo me ava'yic li c'usi ta xcalboxuque. Q'uelavilic, li cristianoetic ti le' xa xtalique ja' jech x'elanic jech chac c'u cha'al trigo ti c'alal taquin xae. Ja' xa yorail ta xich' tuch'el, ja' xa yorail ta xich' tsobel. ");
INSERT INTO tzotze_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Li boch'o ta sts'un trigoe ta xich' stojol. Ja' no'ox jech ec li boch'o ta xtuch'e ta xich' stojol. Ja' no'ox jech ec li boch'o ta xcholbicun jc'ope ta xich' stojolic. Li boch'o ba'yuc ta xchol ti mu xch'un li cristianoetique ta xich' stojol. Li boch'o ts'acal ta xchol ti ja' to ta xch'un li cristianoetique co'ol xcuxet yo'nton xchi'uc li boch'o ba'yuc la xchole. Yu'un li c'u yepal ta xch'unique ta xcuxiic sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jech ta xc'ot ta pasel jech chac c'u cha'al chalique: “Yan o boch'o ta sts'un, yan o boch'o ta xtuch'”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Vu'un laj calbe li antse. Li cristianoetique ja' xa i'albatic yu'un li antse. Li vo'oxuque ja' xa avabtel chachanubtasic lec yu'un jech ac'o xch'unic ti vu'un ta jcoltaique ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","C'alal laj yal ants ti i'albat yu'un Jesús scotol c'usi spasoje, jech ep samaria cristianoetic tey nacajtic ta lum la xch'unic ti ja' t'ujbil yu'un Dios chventainvan li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jech tal sq'uelic li Jesuse, yu'un tal yalbeic ti ac'o pajuque yu'un tsc'an ta xchi'inic. Jech tey lipajcutic chib c'ac'al jchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","C'alal laj ya'i stuquic c'u x'elan ilo'ilaj li Jesuse, oy ep boch'otic la xch'unic ti ta melel ja' Cristo ti t'ujbil yu'un Dios chventainvane. ");
INSERT INTO tzotze_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jech laj yalbeic li antse: ―Mu ja'uc no'ox ta sventa laj avalbuncutic ti la jch'uncutique. Laj ca'i jtuccutic c'u x'elan ilo'ilaj. Jech ta jna'cutic o ti ja' t'ujbil yu'un Dios chiscoltautic yu'un jmultic jcotoltic ta sbejel banamile ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","C'alal la sta chib c'ac'ale, iloc' batel ta Samaria banamil li Jesuse, tey ibat ta cosilalcutic ta Galilea banamil. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yu'un ti isut batel ta cosilalcutic li Jesuse, yu'un ja' mu'yuc boch'o ta xcontrainat tey. Yu'un mu'yuc boch'o ta x'ich'bat ta muc' li sc'ope. Jech chac c'u cha'al yaloj ono'ox li Jesuse: “Li boch'o ta xal sc'op Diose ja' mu x'ich'at ta muc' yo' bu ich'ie”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","C'alal ic'ot ta Galilea banamil li Jesuse, xcuxet no'ox yo'ntonic li jchi'iltaccutic teye, yu'un laj yilic c'usi la spas Jesús ti c'alal i'ayic ta q'uin tey ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Li Jesuse tey ibat yan velta ta lum Caná ta Galilea banamil, ja' tey yo' bu la sc'atajes ta ya'lel ts'usub li vo'e. Tey oy ta lum Capernaum jun xchi'il ta abtel ajvalil. Ja' jchi'ilcutic ta israelal. Ip cha'i xnich'on. ");
INSERT INTO tzotze_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Li xchi'il ta abtel ajvalile laj ya'i ti tey xa ic'ot Jesús ta Galilea banamile. Tey tal yalbe Jesús ti ac'o bat coltabatuc comel li xnich'on tey oy ta snae yu'un ta xa xcham. ");
INSERT INTO tzotze_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Li Jesuse jech laj yalbe: ―Li vo'oxuque ja' to chach'unic vu'un Jcoltavanejun c'alal me laj avilic ta jpas ep sq'uelubil jtsatsale ―xut li jayib tey va'ajtique. ");
INSERT INTO tzotze_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Li xchi'il ta abtel ajvalile jech laj yalbe li Jesuse: ―Tata, batic ta ora yo' to cuxul li jnich'one ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Li Jesuse jech laj yalbe: ―Batan, colem xa li anich'one ―xut. Li vinique la xch'un c'usi i'albat yu'un li Jesuse jech isut o batel ta sna. ");
INSERT INTO tzotze_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","C'alal c'otubal xa'ox ta snae, ital nupatuc ta be yu'un smozotac. Jech i'albat: ―Icol xa li anich'one ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","―¿C'usi ora icol? ―xi. Itac'ov li smozotaque: ―Volje ta jun ora sts'ebujel c'ac'al ich'abi li sc'ac'ale ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Li vinique la sna' ti ja' jech ora i'albat yu'un Jesús ti colem xa li xnich'one. Jech la xch'unic o sjunulic ta na ti ja' Jcoltavanej yu'unic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja' xchibal velta tey laj yac' ta ilel ta Galilea banamil sq'uelubil ti scotol xu' yu'un li Jesuse. Ja' o la spas ti c'alal ayem xa'ox tal ta Judea banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ts'acal to la sta sc'ac'alil yan q'uin cu'uncutic, vu'uncutic li israeluncutique. Jech ibat ta Jerusalén li Jesuse. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tey ta Jerusalene oy pasbil stanqueal vo' ta noch' sti' li corral ton yu'un lume. Ja' tey yo' bu ta x'och chijetic sventa chtun yu'unic tey ta temploe. Li stanqueal vo'e Betesda sbi ta jc'opcutic. Tey oy noxtoc vo'bej cotcot na ta sti'ti' li stanqueal vo'e. ");
INSERT INTO tzotze_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ja' tey mochajtic ep jchameletic. Tey oy ma'satetic, xchi'uc coxoetic, xchi'uc boch'otic aluben yacanic. Ja' tey ta smalaic me ta xich' yuq'uilanel li vo'e. ");
INSERT INTO tzotze_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yu'un oy baq'uintic tey ta xtal ta stanqueal vo' jun yaj'almantal Dios. Ja' ta xtal syuq'uilan li vo'e. C'alal chich' yuq'uilanel li vo'e, ja' tey ta xbat stic' sbaic ta ora li jchameletique. Li boch'o ba'yuc ta x'och ta vo'e c'usiuc no'ox chamelal yich'oj ta xcol o. ");
INSERT INTO tzotze_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tey oy jun jchi'ilcutic ta israelal. Vaxaclajuneb xa xcha'vinic (38) jabil stsaquel ta chamel li vinique. ");
INSERT INTO tzotze_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","C'alal laj yil Jesús ti tey mochole, la sna' ti ep xa jabil jech ip cha'i li vinique. Jech la sjac'be: ―¿Me chac'an chacol? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Itac'ov li jchamele: ―Tata, mu'yuc boch'o oy cu'un ti xu' ta stic'un ochel c'alal ta xich' yuq'uilanel li vo'e. C'alal ta xcac' persa chibate, oy xa boch'o ba'yuc tey ochem ta jta ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Li Jesuse jech laj yalbe: ―Lican, balo apop, xanovan ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ta ora icol li vinique. La sbal li spope, ixanov batel. Ja' o sc'ac'alil ta jcux co'ntoncutic, vu'uncutic li israeluncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Li jchapanvanejetic cu'uncutique jech laj yalbeic li vinic ti colem xae: ―¿C'u yu'un ti chavich' batel apope yu'un ja' sc'ac'alil to ta jcux co'ntontic? Chabajbe smantal Dios ti jech chapase ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Itac'ov li vinique: ―Li boch'o la scoltaune jech laj yalbun: “Balo apop, xanovan”, xiyutun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jech la sjac'beic li vinique: ―¿Boch'o ti jech laj yalbote: “Balo apop, xanovan” xayutote? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Li vinic ti colem xae muc sna' li boch'o icoltaate yu'un ta ora no'ox iloc' batel li Jesuse jech muc xil. Yu'un toj ep cristianoetic tey setoj sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ts'acal to tey itaat yu'un Jesús ta yamaq'uil templo li vinique. Jech i'albat yu'un li Jesuse: ―Q'uelavil, colemot xa. Pero comtsano me scotol li c'usi chopol chapase naca me más to ep chavich' vocol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Li vinique bat yalbe jchapanvanejetic cu'uncutic ti ja' icoltaat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta scoj la scolta jun vinic ta sc'ac'alil ta jcux co'ntoncutic li Jesuse, jech lic contrainatuc yu'un li jchapanvanejetic cu'uncutique. Ta sc'an ta smilic. ");
INSERT INTO tzotze_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Li Jesuse jech laj yalbe li jchapanvanejetique: ―Scotol c'ac'al ch‑abtej li Jtote. Ja' no'ox jech xu' chi'abtej ec ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","C'alal laj yal jech li Jesuse, li jchapanvanejetique más to isoc sjolic, tsc'an ta smilic o li Jesuse. Pero mu ja'uc no'ox ta sventa ti muc xchabi li sc'ac'alil ta jcux co'ntoncutique. Ja' ta sventa noxtoc ti laj yal ti ja' Stot li Diose. Yu'un la sco'lajes sba jech chac c'u cha'al Dios. ");
INSERT INTO tzotze_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Li Jesuse jech laj yalbe: ―Melel li c'usi chacalboxuque, vu'un li Xnich'onun Diose mu'yuc c'usi xu' cu'un ta jpas jtuc. Ti c'u x'elan tspas chquil li Jtote ja' no'ox jech ta jpas ec. ");
INSERT INTO tzotze_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Li Jtote lec sc'anojun. Scotol chiyac'bun quil li c'usi tspase. Li vo'oxuque jutuc no'ox chavilic li' ta orae. Pero ep to chiyac'bun jpas. C'alal me la jpase, más to ta xch'ay avo'ntonic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jech chac c'u cha'al ta xcha'cuxes ánimaetic li Jtote, ja' no'ox jechun ec, xu' ta jcha'cuxes li boch'o ta jc'an ta jcha'cuxese. ");
INSERT INTO tzotze_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Li Jtote mu'yuc ta xchapan li cristianoetique. Vu'un yac'ojbun ta jchapan, vu'un li Xnich'onune. ");
INSERT INTO tzotze_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yu'un jech ac'o yich'icun ta muc' scotol cristianoetic jech chac c'u cha'al ch‑ich'at ta muc' li Jtote. Li boch'otic mu xiyich'icun ta muq'ue ja' mu xich'ic ta muc' ec li Jtote, ja' ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Melel li c'usi chacalboxuque, li boch'otic ta xa'ibicun jc'ope, me ta xch'unic ti ja' ta xcoltaatic yu'un li boch'o la stacun tale, ja' ta xcuxiic sbatel osil. Mu'yuc xa ta xich'ic castigo yu'un icom xa yu'unic ti bu sventa ch'ayel ta xbatic oe. ");
INSERT INTO tzotze_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Melel li c'usi chacalboxuque, laj xa sta sc'ac'alil chava'ibicun jc'op, vu'un li Xnich'onun Diose, vo'oxuc ti chamenoxuc chaquiloxuque. Boch'o ta xch'un ti vu'un Jcoltavanejun yu'unique ja' ta xcuxiic sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jech chac c'u cha'al sventainoj cuxlejal sventa sbatel osil li Jtote, ja' no'ox jechun ec li vu'une, yac'ojbun jventain cuxlejal sventa sbatel osil li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yac'ojbun cabtel ta jchapan scotol li cristianoetique yu'un co'ol cristianoutic lic'ot. ");
INSERT INTO tzotze_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mu me toj ch'ayeluc ta xc'ot avo'ntonic ta sventa ti jech laj calboxuque. Yu'un ta to me sta sc'ac'alil ta jtij liquel scotol li boch'otic chamenique. ");
INSERT INTO tzotze_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jech ta xcha'cuxiic loq'uel ta ch'en. Li boch'otic lec c'usi la spasique ja' ta xcuxiic sbatel osil. Yan li boch'otic mu'yuc lec c'usi la spasique ja' ta x'ac'batic castigo sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Li vu'une mu'yuc c'usi xu' cu'un ta jpas jtuc. C'u x'elan laj yalbun li Jtote, ja' no'ox jech ta jchapan scotol li cristianoetique. Tuc' ta jchapan yu'un mu ja'uc ta jpas c'usi tsc'an co'nton jtuc. Ja' ta jpasbe c'usi tsc'an yo'nton li Jtote, ja' ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Chanopic ti jtuc no'ox ta xcal jc'oplale jech mu xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Li vu'une oy testigo cu'un, ja' li boch'o ta xalbun jc'oplale. Ja' melel li jc'oplal ta xalbune. ");
INSERT INTO tzotze_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Li vo'oxuque laj ataquic ta jaq'uel ta stojol li Juan j'ac'vanej ta vo'e. C'u x'elan laj yalbun jc'oplal li Juane ja' melel. ");
INSERT INTO tzotze_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero mu ja'uc tsots sc'oplal ti jech laj yalbun jc'oplale. Ja' no'ox ta jvulesboxuc ta ajolic yu'un jech ac'o ach'unic o, jech chacolic. ");
INSERT INTO tzotze_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Li Juane xco'laj xchi'uc toj ic'ot yu'un ja' laj yac'boxuc avilic li lequil bee. Li c'usitic laj yalboxuque jliquel no'ox xcuxetavo'ntonic yu'un. ");
INSERT INTO tzotze_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ta sventa li Juane ja' no'ox laj ava'ibicun jc'oplal. Ta sventa c'u x'elan cabtel ta xac'bun jpas li Jtote jech chana'ic o ti tacbilun tal yu'un Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Li Jtot ti la stacun tale, ja' testigo cu'un noxtoc yu'un laj xa yalbun jc'oplal ec. Mu'yuc bu ava'yojic jutuc c'u x'elan chc'opoj, mu'yuc avilojic c'u x'elan. ");
INSERT INTO tzotze_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Xchi'uc mu'yuc ta avo'ntonic li sc'ope yu'un mu xach'unic ti vu'un Jcoltavanejun avu'unic ti tacbilun tal yu'une. ");
INSERT INTO tzotze_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Chaq'uelilanic li sc'op Diose, chanopic ti ja' jech chacuxiic o sbatel osile. Pero mu jechuc ta xal li sc'op Diose. Ja' tey ts'ibabil ti vu'un ta jventa chacuxiic sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero mu xac'an xatalic ta jtojol ti jech xu' chacuxiic o sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mu yu'unuc ja' chopol chca'i ti mu xavich'icun ta muq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yu'un jna'oj c'u x'elan avo'ntonic. Jna' ti mu'yuc ono'ox ac'anojic li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Li vu'une ja' la stacun tal li Jtote pero mu xavich'icun ta muc'. Yan li boch'o jech no'ox ta xtal stuque ja' chavich'ic ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mu xu' avu'un chach'unic yu'un ja' no'ox chac'anic ti lec ac'o yiloxuc li achi'iltaquique. Mu ja'uc chac'anic ti lec ac'o yiloxuc Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mu me xanopic ti vu'un ta jtic'boxuc amulic ta stojol li Jtote. Ta sventa ti ja' scotol avo'ntonic chach'un avalojic li mantaletique, ja' amulic ic'ot o. Yu'un mu xu' avu'unic xch'unel jech chac c'u cha'al laj yal li j'alc'op Moisés ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ti ach'unojicuc c'usi la sts'iba Moisese, chach'unic ti vu'un Jcoltavanejun ti jechuque. Yu'un vu'un jc'oplal la sts'iba comel li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Me mu xach'unic c'usi ts'ibabil comel yu'un Moisese, ¿c'uxi xu' chach'unic noxtoc li c'usi chacalboxuque? ―x'utatic yu'un Jesús li jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ts'acal to ibat Jesús ta jot nab Galilea sbi. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Chib sbi li nabe, nab yu'un Tibérias noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ep cristianoetic la xchi'inuncutic batel xchi'uc li Jesuse yu'un laj yilic ep sq'uelubil stsatsal la spas li Jesuse, ja' ti la scoltaan jchameletique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Li Jesuse laj yic'uncutic muyel ta jun biq'uit vits. Tey ic'ot chotluc jech tey lichoticutic ec, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jutuc xa sc'an sta yorail q'uin coltael cu'uncutic, vu'uncutic li israeluncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","C'alal laj yil Jesús ti ta xtal ta stojol epal cristianoetique, jech la sjac'be li Felipee: ―¿Bu ta xbat jmantic tal pan yu'un ta xcac'betic sve'ic li epal cristianoetic li'oyique? ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ti jech la sjac'be li Felipee, ja' no'ox ta sq'uelbe c'u x'elan yo'nton. Li Jesuse sna'oj ono'ox c'usi ta spas. ");
INSERT INTO tzotze_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Itac'ov li Felipee: ―Ti oyuc lajunvinic (200) denario taq'uin sventa ta jmantic o pane, ac'o me jutuc no'ox ta xcac'betic, pero mu xloc' o ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Li Jesuse jech i'albat yu'un yan jchi'ilcutic ta abtel, ja' li Andrese, ja' yits'in li Simón Pedroe: ");
INSERT INTO tzotze_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Oy jun querem li'i yich'oj tal vo'ob pan ja' pasbil ta cebada trigo. Yich'oj cha'cot choy noxtoc. Pero mu xloc' o, yu'un toj ep li cristianoetique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Li Jesuse jech laj yalbuncutic: ―Albeic li cristianoetique ac'o chotiicuc ―xiyutuncutic. Tey ti bu oyuncutique puro c'unil jobeltic no'ox jech tey ichotiic. Oy van vo'miluc li viniquetique. Yan li antsetique xchi'uc li ololetique mu'yuc atbil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Li Jesuse la stsac li pane, la stojbe ta vocol Dios, la svoq'uilan, laj yac'buncutic, vu'uncutic li yajchanc'opuncutique. Vu'uncutic laj cac'becutic li boch'otic tey chotajtique. Jech noxtoc li choye laj cac'becutic ti c'u yepal la sc'anique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","C'alal inoj xch'utic scotol cristianoetique, li Jesuse jech laj yalbuncutic, vu'uncutic li yajchanc'opuncutique: ―Tsobic scotol li scomelal pane xchi'uc li scomelal choye. Mu me jcomtsantic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jech tey la jtsobcutic scotol. Inoj cu'uncutic lajcha'moch li scomelal vo'ob pan ti pasbil ta cebada trigoe. ");
INSERT INTO tzotze_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Li cristianoetique, c'alal laj yilic sq'uelubil ti scotol xu' yu'un li Jesuse, jech laj yalbe sbaic: ―Ta melel ja' yaj'alc'op Dios li vinic li'i, ja' li boch'o sc'oplal ono'ox chtal li' ta banamile ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Li Jesuse la sna' ti tsc'an ta stsacate yu'un ta sujat ti ja' ac'o ochuc ta ajvalilal cu'uncutic, vu'uncutic li israeluncutique. Jech stuc iloc' batel, ibat ta vits. ");
INSERT INTO tzotze_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Vu'uncutic li yajchanc'opuncutique ta xa x'ic'ub ti c'alal liyalcutic batel ta ti' nabe. ");
INSERT INTO tzotze_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tey li'ochcutic batel ta tenalte' canova yu'un tey chibatcutic ta lum Capernaum tey ta jot nab. C'alal ic' xa'ox osile, tey jbats'ilcutic xanubal ta canova ta ba nab. Mu'yuc to'ox laj quilcutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tey ital tsots ic'. Tsots lic syuq'uilan sba li nabe. ");
INSERT INTO tzotze_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","C'alal oy xa van o'loluc xchibal reva lixanovcutic batel ta ba nabe, ja' o laj quilcutic ta xanov tal ta yacan ta ba nab li Jesuse. Tey inoch'aj tal ta sts'el li canovae. Toj xi'el lic'otcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Li Jesuse jech laj yalbuncutic: ―Mu me xaxi'ic, ja' vu'un ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jech xcuxet xa co'ntoncutic laj quic'cutic ochel ta canova li Jesuse. Ta ora no'ox liloc'cutic ta jot nab ti bu jnopoj chibatcutique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Li cristianoetic tey icomic ta jot nabe laj yilic ti mu'yuc yan canovae, ja' no'ox jun ti bu li'ochcutic batele. Laj yilic noxtoc ti mu'yuc x'och ta canova li Jesuse, ja' no'ox jtuccutic li'ochcutic, vu'uncutic li yajchanc'opuncutique. Ta yoc'omal to ital yan canovaetic tey liquemic tal ta lum Tibérias. Ja' tey noch' i'ech' yo' bu la sve'ic pan li cristianoetique ti c'alal la stojbe ta vocol Dios li Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Li cristianoetique laj yilic ti mu'yuc xa tey oy li Jesuse xchi'uc mu'yuc xa tey oyuncutic ec. Jech tey i'ochic tal ta canova ec. Tey italic ta Capernaum, ja' tal sa'ic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","C'alal tey la staic ta jot nab li Jesuse, jech la sjac'beic: ―Jchanubtasvanej, ¿c'uxi ora lavul tal li'i? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Itac'ov li Jesuse: ―Melel li c'usi chacalboxuque. Yu'un ti tal asa'icune, mu yu'unuc ja' ta sventa laj avilic ti scotol xu' cu'une. Ja' no'ox ta sventa ti lec inoj ach'utic yu'un pane. ");
INSERT INTO tzotze_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mu me ja'uc no'ox xbat avo'ntonic ta sa'el li ave'elic ti sna' xlaje. Ja' tsc'an chasa'beic sve'el ec li avo'ntonique, ja' ti mu sna' xlaj sbatel osile. Vu'un ta xcac'boxuc, vu'un ti co'ol cristianoutique, yu'un jech ac'bilun cabtel yu'un li Diose, ja' li Jtote ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jech la sjac'beic li Jesuse: ―¿C'uxi chcut ta jpasbecutic yabtel Dios ec li vu'uncutique? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Itac'ov li Jesuse: ―Ja' yabtel Dios ta xc'ot me chach'unic ti vu'un Jcoltavanejun avu'unic ti tacbilun tal yu'une ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jech la sjaq'uic yan velta: ―¿C'usi sq'uelubil chavac'bun quilcutic ti ta melel tacbilot tal yu'un Diose yu'un jech xu' ta jch'uncutic o li c'usi chavale? ¿C'usi abtelal chavac'bun quilcutic? ");
INSERT INTO tzotze_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Li jmoltot jyame'cutic ta vo'onee i'ac'bat manavaj sve'ic yu'un Moisés tey ta xocol banamil. Jech ts'ibabil sc'oplal ta sc'op Dios: “Li Moisese laj yac'be sve'ic vaj ti liquem tal ta vinajele”, xi ts'ibabil. Ac'buncutic jech ec li vo'ote ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Li Jesuse jech laj yalbe: ―Melel li c'usi chacalboxuque, mu ja'uc Moisés laj yac' li vaj ti la sve'ic amoltot ayame'ic ta vo'onee. Ja' no'ox i'ac'bat sventain li Moisese. Ja' Dios laj yac' tal li vaje. Li vaj la sve'ic amoltot ayame'ique ja' no'ox sventa icuxiic li' ta banamil. Yan li vaj ta xac'boxuc Jtot li' ta orae, ja' sventa chacuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Li vaj ta xac'boxuque ja' tey liquem tal ta vinajel. Ja' sventa chacuxiic o sbatel osil, vo'oxuc ti li' oyoxuc ta banamile ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jech laj yalic: ―Cajval, aq'uilanbuncutic scotol c'ac'al li vaj chavale ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Itac'ov li Jesuse: ―Jech chac c'u cha'al ta sventa vaj cuxuloxuc li' ta banamile, ja' no'ox jech vu'un ta jventa chacuxiic o sbatel osil. Li boch'otic ta xtal ta jtojole, me ta xch'unic ti vu'un ta jcoltaique, mu'yuc xa c'usi yan tsc'anic o yu'un xcuxet no'ox yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Laj xa calboxuc ti altic chavilicune, mu xac'an xach'unic ti vu'un chajcoltaoxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Scotol ti c'u yepal t'ujbilic ono'ox yu'un Jtot ti chiyich'icun ta muq'ue ja' ta xtalic ta jtojol. Li boch'otic ta xtalic ta jtojole xcuxet no'ox co'nton ta xquic'an o. Mu xcac' baticuc ta ch'ayel. ");
INSERT INTO tzotze_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yu'un ti liyal tal li' ta banamile, mu ja'uc tal jpas li c'usi ta jc'ane. Ja' tal jpasbe c'usi ta sc'an li Jtot ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Li Jtote tsc'an mu xch'ay junuc cu'un ti c'u yepal t'ujbilic ono'ox yu'un ti chiyich'icun ta muq'ue. Me ichamique, ta jcha'cuxesan scotol ta slajebal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yu'un jech tsc'an Jtot ti ac'o cuxiicuc sbatel osil scotol li boch'otic ta xal ti vu'un Xnich'onune xchi'uc ta xch'unic ti vu'un ta jcoltae. Me ichamique, ta jcha'cuxes scotol ta slajebal c'ac'al ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Li jchi'iltaccutic ta israelale muc xch'unic c'alal laj yal Jesús ti ja' stuc li vaj liquem tal ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jech laj yalbe sbaic: ―Ja' xnich'on José li Jesús li'i. Xcotquinbetic stot sme'. Ta xal ti tey liquem tal ta vinajele pero altic chal ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Itac'ov li Jesuse: ―¿C'u yu'un mu xach'unic li c'usi laj cale? ");
INSERT INTO tzotze_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mu'yuc boch'o xu' yu'un ta xtal ta jtojol me muc tijbiluc tal yo'nton yu'un li Jtot ti la stacun tale. Li boch'otic ta xtal ta jtojole, me ichamique, ta jcha'cuxesan ta slajebal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jech ts'ibabil comel ta svunic li yaj'alc'optac Dios ta vo'onee: “Scotolic ta x'ac'bat sna'ic yu'un Dios li boch'o chcoltavane”, xi ono'ox. Jech scotol li boch'otic tsc'an tsna'ique ja' ta x'ac'bat sbijilic yu'un li Jtote, jech ta xtalic ta jtojol. ");
INSERT INTO tzotze_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Mu'yuc boch'o yiloj li Diose. Jtuc no'ox quiloj yu'un tey liquemun tal ta stojol. ");
INSERT INTO tzotze_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Melel li c'usi chacalboxuque, boch'o ta xch'un ti tacbilun tal yu'un Diose ja' ta xcuxiic sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Vu'un vaj c'otemun yu'un vu'un ta jventa chacuxiic sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","C'alal la sve'ic manavaj tey ta xocol banamil li amoltot ayame'ic ta vo'onee, muc xcuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Li vaj ta xcale ja' tey liquem tal ta vinajel. Li boch'otic ta sve'e ja' chcuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Vu'un li vajune yu'un vu'un liquemun tal ta vinajel. Vu'un ta jventa chacuxiic sbatel osil. Scotol boch'o ta sve' li vaj ta xcale, ja' chcuxiic sbatel osil. Li vaj ta xcaq'ue ja' li jbec'tale. Ta xcac' ta sventa ti xu' ta xcuxiic sbatel osil cristianoetic ta sbejel banamil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Li jchi'iltaccutic ta israelele jech laj yalbe sbaic: ―¿C'uxi xu' ta xac'butic jve'tic li sbec'tale? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Li Jesuse jech laj yalbe: ―Melel li c'usi chacalboxuque, me mu'yuc ave'ojbicun jbec'tal, vu'un ti co'ol cristianoutique, me mu'yuc avuch'ojbicun li jch'ich'ale, mu xacuxiic sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Boch'o ta sve'bun jbec'tale xchi'uc ta xuch'bun jch'ich'ale ta xcuxi sbatel osil. Me ichame, ta jcha'cuxes ta slajebal c'ac'al. ");
INSERT INTO tzotze_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Li jbec'tale ja' lequil ve'lil ta xc'ot. Li jch'ich'ale ja' lequil vo' ta xc'ot jech chacuxiic o yu'un sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Boch'o ta sve'bun jbec'tale xchi'uc ta xuch'bun jch'ich'ale, ja' tey oy o ta jtojol, jech tey oyun ta yo'nton ec. ");
INSERT INTO tzotze_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Li Jtot ti la stacun tale cuxul o sbatel osil. Ja' no'ox jechun ec li vu'une, cuxulun o sbatel osil ta sventa li Jtote. Ja' no'ox jech ec li boch'otic ta sve'une, vu'un ta jventa ta xcuxiic o sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Li vaj ta xcale ja' tey liquem tal ta vinajel. Mu co'oluc jech chac c'u cha'al li manavaj la sve'ic amoltot ayame'ic ta vo'onee. C'alal la sve'ic manavaj li amoltot ayame'ic ta vo'onee, muc xcuxiic o sbatel osil. Yan li boch'otic ta sve'ic li vaj ta xcale ja' ta xcuxiic sbatel osil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ja' jech laj yal Jesús ta nail tsobobbail yu'un jchi'iltac ta israelal tey ta Capernaum ti c'alal ichanubtasvane. ");
INSERT INTO tzotze_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oy ep jchi'iltac ta israelal ep c'ac'al la xchi'inic li Jesuse. Ac'o me ep c'ac'al la xchi'inic pero muc xch'unic c'alal laj yal ti tey liquem tal ta vinajele. ");
INSERT INTO tzotze_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Li Jesuse la sna' ta yo'nton ti oy chopol laj ya'yic li c'usi laj yale. Jech la sjac'be: ―¿Me ta xchibaj avo'ntonic yu'un li c'usi laj cale? ");
INSERT INTO tzotze_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿C'usi chavalic me laj avilic chitoy batel yo' bu liquemun tal, vu'un ti co'ol cristianoutique? ");
INSERT INTO tzotze_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja' tsots sc'oplal ac'o ach'unic yu'un jech chacuxiic sbatel osil. Ja' jech smelol li c'usi laj calboxuque. Ma'uc yu'un laj cal oy c'usi ac'o apasic ti jech chacuxiic sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero muc acotolicuc chach'unic ―x'utatic yu'un li Jesuse. C'alal lic stsac yabtel li Jesuse, sna'oj ono'ox li boch'otic mu xch'unic ti ja' Jcoltavaneje xchi'uc li boch'o ta x'ac'at ta c'abale. ");
INSERT INTO tzotze_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Li Jesuse jech laj yalbuncutic jcotolcutic: ―Laj calboxuc ava'yic ti mu'yuc boch'o xu' ta xtal ta jtojol me muc tijbiluc yo'nton yu'un Jtote ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jech ep isutic batel, ja' li boch'otic co'ol to'ox la jchi'incutic li Jesuse. Muc xa sc'an xchi'inic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Li Jesuse jech la sjac'buncutic, vu'uncutic li lajchabuncutique: ―Li vo'oxuque ¿c'u x'elan avo'ntonic? ¿Me chasutic batel ec? ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Itac'ov li Simón Pedroe: ―Cajval, mu'yuc boch'o yan ta xbat jc'opancutic yu'un vo'ot no'ox chavalbuncutic ti c'u x'elan chicuxicutic sbatel osile. ");
INSERT INTO tzotze_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Li vu'uncutique jch'unojotcutic. Ta jna'cutic ti vo'ot Cristoot, ti t'ujbilot yu'un Dios chaventainuncutique. Vo'ot Xnich'onot li cuxul Diose ―xi li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Itac'ov li Jesuse: ―Vu'un la jt'ujoxuc li lajchaboxuque pero oy jun ti ja' ventainbil yu'un pucuje ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ja' Judas ti laj yalbe sc'oplale, ja' li xnich'on Simón Iscariotee, yu'un ja' ta x'ac'van ta c'abal. Li Judase ja' co'ol lajchab yajchanc'opuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","C'alal jech laj yal li Jesuse, ibat. Ixanov batel ta scotol Galilea banamil. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Li Jesuse muc sc'an xbat ta Judea banamil yu'un tey tsnopic c'u x'elan xu' ta smilic Jesús li jchapanvanejetic cu'uncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jutuc xa sc'an sta sc'ac'alil q'uin cu'uncutic, vu'uncutic li israeluncutique. Ja' li q'uin ti yorail chi'ochcutic ta vacaxna tey ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Li Jesuse jech i'albat yu'un li yits'inabtaque: ―Mu me xacom li'i, batic ta Judea. Yu'un c'alal chilic ti ep sq'uelubil atsatsal chc'ot apas tey ta q'uine, más ta stsatsub yo'ntonic li boch'otic laj xa yich'ic ta muc' ac'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Li boch'o tsc'an ta xpuc sc'oplale muc ta muculuc ta spas li c'usi yabtele. Me ja' avabtel o jech chapase, ac' aba ta ilel ta stojol scotol cristianoetic ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Li yits'inabtaque muc xch'unic ec ti ja' t'ujbil yu'un Dios chventainvan li sbanquilique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Li Jesuse jech laj yalbe: ―Mu'yuc to ta sta sc'ac'alil cu'un ti chibat ta q'uine. Li vo'oxuque c'usiuc no'ox ora xu' chabatic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Li cristianoetique mu xu' chopol chayiloxuc. Yan li vu'une chopol chiyilicun yu'un vu'un ta xcalbeic ti chopol c'usitic tspasique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Li vo'oxuque batanic ta q'uin. Yan li vu'une mu'yuc to chibat ta q'uin yu'un mu'yuc to tsta sc'ac'alil chibat ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","C'alal jech laj yalbe yits'inabtac li Jesuse, tey to lijoc'tsajcutic ta Galilea xchi'uc Jesús, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Batemic xa'ox ta q'uin tey ta Jerusalén yits'inabtac Jesús ti c'alal libatcutic ec xchi'uc li Jesuse. Mu'yuc la jchi'incutic batel li cristianoetique. Jtuccutic no'ox libatcutic yu'un mu sc'an xac' sba ta ilel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Li jchapanvanejetic cu'uncutic, vu'uncutic li israeluncutique, tey oyic ta q'uin ta sa'ic li Jesuse. Jech ta sjaq'uilanbeic li cristianoetique: ―¿Bu oy xana' li Jesuse? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Li cristianoetique puro ja' ta slo'iltaic li Jesuse. Oy boch'otic jech laj yalic: ―Toj lec yo'nton ―xiic. Oy yantic jech laj yalic: ―¡Mu'yuc lec! Ja' jlo'lavanej ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero me junuc mu'yuc boch'o tsots laj yal yu'un ja' ixi'ic yu'un li jchapanvanejetic cu'uncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","C'alal o'lol xa'ox x'ech' li q'uine, ibat ta templo li Jesuse. Tey ic'ot chanubtasvanuc ta yamaq'uil templo. Jech tey oyuncutic ec. ");
INSERT INTO tzotze_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Li jchapanvanejetic cu'uncutique toj labal laj ya'yic ti c'u x'elan ichanubtasvane. Jech laj yalic: ―¿Bu la xchan li jchi'iltic li'i yu'un mu'yuc jchanubtasojtic? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Li Jesuse jech laj yalbe: ―Mu vu'cun jc'op ti li' ta xcac' ta a'yele. Ja' sc'op stuc li Diose, ja' ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Boch'o tsc'an ta spas c'usi ta sc'an li Diose, ta x'ac'bat sna' me ja' sc'op Dios ti ta xcale, o me jc'op no'ox jtuc ta xcal. ");
INSERT INTO tzotze_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Li boch'o sc'op no'ox stuc ta xale yu'un tsc'an chac' sba ta ich'el ta muc'. Li vu'une ja' chcac' ta ich'el ta muc' li Diose, ja' ti la stacun tale. Mu'yuc chilo'lavan, melel li c'usi chcale. ");
INSERT INTO tzotze_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Li j'alc'op Moisés ta vo'onee la sts'ibaboxuc comel li mantaletique, pero me junuc mu'yuc boch'o xch'unoj avu'unic jech chac c'u cha'al ta xal li mantaletique. Ti ach'unojicuc li mantaletique, mu'yuc chanop chamilicun ti jechuque ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jech itac'ov scotolic: ―Ochem pucuj ta avo'nton. ¿Boch'o laj yal ti chasmilote? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Itac'ov li Jesuse: ―Jun no'ox vinic la jcolta ta sc'ac'alil ta jcux co'ntontic pero acotolic toj ch'ayel ic'ot avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Li Moisese laj yalboxuc ti chavaq'uic circuncisione, pero mu ja'uc ba'yuc i'albat li Moisese. Ja' ba'yuc i'albat li jmoltotactic ta más vo'onee. Li vo'oxuque ac'o me ta sc'ac'alil ta jcux co'ntontic chavaq'uic li circuncisione, yu'un yaloj Dios ti persa chich' circuncisión c'alal me iloc' vaxquib c'ac'al svoq'uel li queremetique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yu'un ti xu' chavaq'uic circuncisión ta sc'ac'alil ta jcux co'ntontique yu'un jech mu xabajbeic smantal li Moisese, ¿c'u yu'un chopol chavilicun ti la jcolta jun vinic ta sc'ac'alil ta jcux co'ntontique? ");
INSERT INTO tzotze_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Chopol me ta ora no'ox chatic'beic smul jun vinic. Ja' tsc'an chanopic lec me melel ti chopol c'usi la spase ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Li jchi'iltaccutic tey nacajtic ta Jerusalene oy jayibuc jech laj yalic: ―Li vinic li'i ja' ti ta xich' sa'ele yu'un sc'oplal ta xich' milel. ");
INSERT INTO tzotze_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Q'uelavilic, li' to ta xchanubtasvan ta jtojoltic. Pero mu'yuc c'usi ta x'albat yu'un li jchapanvanejetic cu'untique. ¿Me yu'un laj xa sna'ic me ja' li boch'o t'ujbil yu'un Dios ti sc'oplal ono'ox chtal sventainutique? ");
INSERT INTO tzotze_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Li vu'utique jna'ojtic bu liquem tal li vinic li'i. C'alal ta xtal li boch'o t'ujbil yu'un Dios chisventainutique, mu'yuc boch'o ta sna' bu ta xlic tal ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Li Jesuse tsots ic'opoj tey ta yamaq'uil templo ta Jerusalén ti c'alal ichanubtasvane. Jech laj yalbe li cristianoetique: ―Xavotquinicun avalojic. Ana'oj avalojic ti bu liquemun tale. Pero muc ta co'ntonuc jtuc ti litale. Ja' la stacun tal li Diose, ja' melel li sc'ope. Pero mu xavotquinic li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Li vu'une xcotquin yu'un ja' tey liquemun tal ta stojol. Ja' la stacun tal li'i ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jech tey chac stic' ya'yic ta chuquel li Jesuse. Pero mu'yuc boch'o itsacvan yu'un mu'yuc to staoj sc'ac'alil ta stsacat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero oy ep boch'otic la xch'unic ti ja' xa li boch'o t'ujbil yu'un Dios ti sc'oplal ono'ox chtal ventainvanuque. Jech laj yalic: ―Li jchi'iltic li'i xu' yu'un ta spas ep sq'uelubil stsatsal jech chac c'u cha'al sc'oplal ta spas li boch'o sc'oplal chtal sventainutique. Ja' xa ti li'oye ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Li fariseoetique laj ya'yic ti ja' jech ta xlo'ilajic li boch'otic laj xa xch'unic ti ja' xa li boch'o t'ujbil yu'un Dios ti sc'oplal chtal ventainvanuque. Li banquilal paleetique xchi'uc li fariseoetique laj yalbeic jayibuc jchabitemplo yu'unic yu'un ac'o stsaquic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Li Jesuse jech laj yalbe li cristianoetique: ―Mu xa epuc c'ac'al li' chajchi'inoxuc. Ta xa xibat yo' bu oy li boch'o la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Li vo'oxuque chasa'icun pero mu'yuc chataicun. Yo' bu chibate mu xu' chabatic tey ec li vo'oxuque ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Li jchi'iltaccutic ta israelale jech lic sjac'be sbaic: ―¿Bu ta xbat ti mu xa jtatic chale? ¿Me yu'un ja' tey ta xbat yo' bu oy li jchi'iltactic ti spucoj sbaic batel ta yosilal greciaetique? ¿Me yu'un ja' tey ta xbat xchanubtas li greciaetique? ");
INSERT INTO tzotze_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿C'usi smelol ti jech laj yale: “Chasa'icun pero mu'yuc chataicun. Yo' bu chibate mu xu' chabatic tey ec li vo'oxuque”, ti xijyututique? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta mero sc'ac'alil q'uin tey la sva'an sba li Jesuse. Tsots i'avan jech laj yal: ―Li boch'o ta sa'ilan c'u x'elan xu' ta xlecub jech chac c'u cha'al ta sa'ilan vo' yuch' me taquin yo'ntone, ac'o taluc ta jtojol. Vu'un ta jlecubtasbe yo'nton. ");
INSERT INTO tzotze_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Boch'o ta xch'un ti vu'un ta jcoltae jech ta xc'ot ta pasel ta yo'nton jech chac c'u cha'al ts'ibabil ta sc'op Diose: “Li slequil yo'ntone ja' jech x'elan ta xvinaj jech chac c'u cha'al nio' ti tey xcholchun o scotol c'ac'ale”, xi ts'ibabil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Li Jesuse ja' laj yalbe sc'oplal yabtel Ch'ul Espíritu ti sc'oplal ono'ox ta x'ac'bat ta yo'ntonic li boch'otic ta xch'unic ti ja' Jcoltavanej yu'unic li Jesuse. Pero mu'yuc to'ox talem li Ch'ul Espíritue yu'un mu'yuc to sutem batel ta vinajel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","C'alal laj ya'yic jchi'iltaccutic ti jech laj yal li Jesuse, oy boch'otic jech laj yalic: ―Ta melel ja' xa li yaj'alc'op Dios ti sc'oplal ono'ox ta xtale ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Oy yantic jech laj yalic: ―Li'i ja' xa li boch'o t'ujbil yu'un Dios ti sc'oplal ono'ox chtal sventainutique ―xiic. Oy yantic jech laj yalic: ―Muc teyuc ta xlic tal ta Galilea li boch'o sc'oplal chtal sventainutique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ta xal ta sc'op Dios ti tey ta xvoc' ta Belene yu'un ja' smoltot li Davide. Ja' tey ta xvoc' yo' bu ivoc' li smoltote ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jech tey cha'oxvoc' ic'otic li jchi'iltaccutique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Oy boch'otic tsc'an ta stsaquic li Jesuse pero mu'yuc boch'o itsacvan. ");
INSERT INTO tzotze_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Li jchabitemploe ibatic yo' bu oyic li banquilal paleetique xchi'uc li fariseoetique. Jech ijac'batic: ―¿C'u yu'un muc xatsaquic tal? ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Itac'ovic li jchabitemploe: ―Yu'un me junuc mu'yuc boch'o jech ta xlo'ilaj jech chac c'u cha'al ta xlo'ilaj li vinique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jech i'albatic yu'un li fariseoetique: ―Lalajic ta lo'lael ec li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Me junuc jchapanvanej cu'untic, mu'yuc boch'o xch'unoj me ja' xa li boch'o sc'oplal chisventainutique. Me junuc mu'yuc bu jch'unojcutic ec li vu'uncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Li cristianoetic ti tey stsoboj sbaic ta stojole mu sna'ic c'usi chal li mantaletique. Ich'ayic xa o ―xiic li fariseoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tey oy ec li Nicodemoe, ja' li boch'o ay sc'opan ta ac'ubaltic li Jesuse, yu'un xch'unoj fariseo ec. Li Nicodemoe jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Mu xu' ta xcac'betic castigo jun jchi'iltic me mu'yuc to ca'yojtic c'usi chale, xchi'uc me mu to jna'tic c'usi smule. ¿Me mu jechuc ta xal li mantaletic cu'untique? ―xi li Nicodemoe. ");
INSERT INTO tzotze_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jech laj yalbeic li Nicodemoe: ―¿Me yu'un tey liquemot tal ta Galilea ec? Q'uelo me li sc'op Diose jech chana' o ti mu'yuc ta xlic tal junuc yaj'alc'op Dios tey ta Galileae ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jech isutic o batel ta snaic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Li Jesuse ibat ta vits Olivatic. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta sob yoc'omal libatcutic ta Jerusalén xchi'uc li Jesuse. Tey libatcutic yan velta ta yamaq'uil templo. Ep cristianoetic italic ta stojol li Jesuse, jech lic chotluc, tey lic chanubtasvanuc. ");
INSERT INTO tzotze_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tey italic ec jayibuc li jchanubtasvanejetic ta smantal Dios yalojique xchi'uc jayibuc fariseoetic. Tey yic'ojic tal jun ants. Li antse sbats'il mulivajel la staic. Tey ic'ot yaq'uic ta stojol Jesús ta o'lol li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, li ants li'i sbats'il mulivajel la jtacutic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Li j'alc'op Moisés ta vo'onee yalojbutic mantal ti ac'o ac'batuc ton li boch'o jech ta spase. ¿C'usi chaval ec li vo'ote? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ti jech laj yalbeic li Jesuse yu'un tsc'an cha'yic c'uxi ta xtac'ov yu'un tsc'an ta sa'beic smul. Li Jesuse la scujan sba la sts'iba banamil ta sbic'tal sc'ob. ");
INSERT INTO tzotze_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ta sventa ti mu xlaj yo'ntonic ta sjaq'uele, jech ichoti lec li Jesuse. Jech laj yal: ―Me oy boch'o mu'yuc smul avu'unique, ja' ba'yuc ac'o yac'be ton li antse ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","La scujan sba yan velta li Jesuse, la sts'iba noxtoc li banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","C'alal laj ya'yic jech laj yal Jesús li jchapanvanejetique, ep ilo'ilaj yo'nton yu'un smulic. Ta jujuntal xa iloq'uic batel. Ja' ba'yuc iloq'uic batel li boch'otic molic xae. Ja' ts'acal iloq'uic batel li boch'otic queremetic toe. Stuc xa no'ox tey icom li Jesuse xchi'uc li ants ti tey oy ta o'lol cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Li Jesuse ichoti lec yan velta, laj yil ti mu'yuc xa tey oyic li boch'otic laj yiq'uic tal li antse, ja' xa no'ox stuc tey oy li antse. Li Jesuse jech laj yalbe: ―Yaa, li boch'otic laj yalic amule ibatic xa. Mu'yuc boch'o laj yac'bot ton ta scoj ti oy amule ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Itac'ov li antse: ―Mu'yuc, tata ―xi. Li Jesuse jech laj yalbe: ―Ja' jechun ec, mu'yuc ta xcac'bot castigo yu'un li amule. Batan, mu xa me xasa' amul ―x'utat batel. ");
INSERT INTO tzotze_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Li Jesuse ichanubtasvan yan velta, jech laj yal: ―Vu'un luz c'otemun avu'unic, vo'oxuc ti oyoxuc ta ic' osil ta scoj li mulile. Li boch'o ta xtal ta jtojole ta xcom yu'un li mulile. Ja' ta spas li c'usi leque yu'un vu'un ta jtuq'uibtas batel, jech ta xcuxi sbatel osil ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Li Jesuse jech i'albat yu'un li fariseoetique: ―Li vo'ote atuc no'ox chaval ac'oplal. Mu'yuc testigo avu'un jech mu jch'uncutic li c'usi chavale ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Itac'ov li Jesuse: ―Ac'o me chavalic ti jtuc no'ox ta xcal jc'oplale pero melel li c'usi chcale. Yu'un jna'oj ti bu liquemun tale, jna'oj noxtoc ti bu chibate. Li vo'oxuque mu xana'ic bu liquemun tal, jech mu xana'ic bu chibat noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Li vo'oxuque chanopic ti cristianoun no'oxe jech chanopbicun jmul. Li vu'une mu'yuc boch'o ta jnopbe smul. ");
INSERT INTO tzotze_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Me oy boch'o chcalbe ti oy smule, yu'un oy smul o. Yu'un mu jtucuc no'ox chcal ti oy smule. Ja' co'ol chcal jchi'uc li Jtote, ja' ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Li mantaletic tey avich'ojique chal ti ja' to xu' chach'unic me co'ol sc'opic li chib testigoe. ");
INSERT INTO tzotze_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Li vu'une ta xcal jc'oplal jtuc. Pero ja' jech ta xalbun jc'oplal ec li Jtot ti la stacun tale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Li fariseoetique jech la sjac'beic li Jesuse: ―¿Bu oy li atot chavale? ―xutic. Itac'ov li Jesuse: ―Mu xavotquinicun, jech mu xavotquinic ec li Jtote. Ti avotquinojicucune, jech avotquinojic ec li Jtote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ja' jech laj yal Jesús ti c'alal ichanubtasvan ta templo tey ta yut jun cuarto bu ta xaq'uic smoton Dios li cristianoetique. Pero mu'yuc boch'o ital tsacvanuc yu'un mu'yuc to staoj sc'ac'alil ta stsacat li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Li Jesuse jech laj yalbe ya'yic yan velta: ―Li vu'une oy bu chibat. Chasa'icun pero mu xataicun. Jech tey acuchoj o amul chachamic. Ti bu chibate mu xu' chabatic tey ec li vo'oxuque ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jech laj yalbe sbaic li jchi'iltaccutic ta israelale: ―¿Me yu'un ta smil sba stuc ti jech ta xale: “Ti bu chibate mu xu' chabatic tey ec li vo'oxuque”, ti xijyututique? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Li Jesuse jech laj yalbe: ―Li vu'une mu co'oluc oyutic jech mu co'oluc ta jnoptic. Li vu'une liquemun tal ta vinajel; vo'oxuque li'oyoxuc ta banamil. ");
INSERT INTO tzotze_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yu'un ti laj calboxuc tey acuchoj amul chachamique, yu'un mu xach'unic ti vu'un ta jcoltaoxuque, jech tey acuchoj o amul chachamic ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jech tey lic sjaq'uic yan velta li jchi'iltaque: ―¿Boch'oot cha'e? ―xutic. Itac'ov li Jesuse: ―Ja' no'ox jech chac c'u cha'al laj calboxuc ta ba'yuque. ");
INSERT INTO tzotze_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ac'o me oy ep c'usi xu' ta xcalboxuc, ac'o me oy amulic xu' ta xcalboxuc, pero mu xcal. Yu'un ja' no'ox ta xcalboxuc c'usi albilun yu'un li Jtot ti la stacun tale. Li Jtote melel c'usi ta xal ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta sventa ti muc sc'an xch'unic ti liquem tal ta vinajele, jech muc xa'ibeic o smelol ti ja' laj yalbe sc'oplal li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Li Jesuse jech laj yalbe yan velta: ―C'alal chajoc'anicun ta cruz, vu'un ti co'ol cristianoutique, ja' to tey chana'ic o ti melel li jc'oplal laj calboxuque. Xchi'uc chana'ic ti ja' no'ox laj calboxuc jech chac c'u cha'al albilun yu'un li Jtot ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Li Jtote li' xchi'inojun, mu xiscomtsanun yu'un scotol c'ac'al ta jpasbe li c'usi ta sc'an yo'ntone ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","C'alal jech laj yal li Jesuse, ep boch'o la xch'unic ti ja' xa li boch'o sc'oplal ono'ox chtal ventainvanuque. ");
INSERT INTO tzotze_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Li Jesuse jech laj yalbe li jchi'iltaccutic ta israelale, ja' li boch'otic laj xa xch'unic ti ja' t'ujbil yu'un Dios chventainvan li Jesuse: ―Me j'ech'el chach'unic li c'usi laj calboxuque, jech chvinaj ti ta melel cu'unoxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jech chana'ic ti melel c'usi laj cale. Ta sventa li jc'op ti ja' melele jech chaloq'uic o ta mozoil ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Itac'ovic: ―Li vu'uncutique ja' jmoltotcutic li Abraáme. Me junuc mu'yuc boch'o ochem ta mozoil cu'uncutic. ¿C'u yu'un jech chaval: “Jech chaloq'uic o ta mozoil”, xachi? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Itac'ov li Jesuse: ―Melel li c'usi chacalboxuque, scotol boch'otic ta sa'ilan smulique ja' ochemic o ta mozoil yu'un li smulique. ");
INSERT INTO tzotze_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Li boch'otic ochemic ta mero mozoile chana'ic ti mu'yuc c'usi ta x'ac'bat yu'un li yajvalique, ja' no'ox jayib c'ac'al ch‑ac'bat sventainic. Yan li nich'naletique j'ech'el ta x'ac'bat sventainic o scotol yu'un li stotique. ");
INSERT INTO tzotze_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Vu'un li Xnich'onun Diose, me vu'un ta jloq'uesoxuc ta mozoil yu'un li mulile, ta melel j'ech'el laloq'uic o. ");
INSERT INTO tzotze_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ta melel ja' amoltotic li Abraáme pero mu co'oluc avo'nton achi'uquic yu'un chac'an chamilicun. Puro milvanej no'ox oy ta avo'ntonic ta scoj ti mu xc'ot ta avo'ntonic li jc'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Li vu'une ja' no'ox ta xcal jech chac c'u cha'al laj yac'bun quil li Jtote. Li vo'oxuque ja' chapasic c'usi ta xalboxuc li atotique ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Itac'ovic: ―Ja' co'ol jch'unojcutic jech chac c'u cha'al li jmoltotcutic Abraám ta vo'onee ―xiic. Li Jesuse jech laj yalbe: ―Ti ja'uc jech ach'unojic jech chac c'u cha'al li Abraáme, jech chapasic jech chac c'u cha'al la spas ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Li' ta orae chac'an chamilicun yu'un ja' laj calboxuc ava'yic li c'usi melel ca'yoj tal ta stojol Diose. Li Abraáme mu jechuc la spas. ");
INSERT INTO tzotze_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Vo'oxuque ja' chapasbeic yabtel li atotique ―xut. Itac'ovic: ―Li vu'uncutique muc xnich'onuncuticuc jmulavil. Jun no'ox li jtotcutique, ja' li Diose ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Li Jesuse jech laj yalbe: ―Ti ja'uc atotic li Diose, chac'anicun ti jechuque. Yu'un tey liquemun tal ta stojol li Diose. Muc ta co'ntonuc jtuc ti litale. Ja' la stacun tal li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yu'un ti mu xava'ibeic smelol c'usi chcale, yu'un mu ono'ox xac'an xava'ibeic smelol. ");
INSERT INTO tzotze_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Li vo'oxuque ja' atotic li pucuje yu'un ja' tey oy ta avo'ntonic chac'an chapasic li c'usitic tsc'ane. Yu'un li stuque jmilvanej ono'ox ti c'alal ilic tal li banamile, ja' jech o li' ta orae. Mu sc'an li c'usi melele yu'un mu'yuc c'usi lec ta yo'nton. Me ta x'epalc'opoje, yu'un ja' jech stalel o. Ja' bats'i j'epalc'op o ta jyalel. Ja' ta xac' ta chanel li epalc'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Li vu'une melel li c'usi chacalboxuque jech mu xac'an xach'unic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Li vo'oxuque mu xu' chatabicun jmul. Yu'un ja' melel li jc'op calojboxuque, ¿c'u yu'un mu xach'unbicun? ");
INSERT INTO tzotze_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Li boch'otic yu'untac Diose ta xich'beic ta muc' sc'op li Diose. Yu'un ti mu xavich'ic ta muc' sc'op Dios li vo'oxuque, yu'un muc yu'unucoxuc Dios ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Itac'ovic li jchi'iltaccutic ta israelale, jech laj yalbeic li Jesuse: ―Melel o li c'usi la jnopcutique. Li vo'ote samaria vinicot. Ochem pucuj ta avo'nton ―xi la slabanic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Itac'ov li Jesuse: ―Mu'yuc ochem pucuj ta co'nton. Ja' ta xcac' ta ich'el ta muc' li Jtote. Li vo'oxuque mu xavich'icun ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pero mu jtucuc no'ox chcac' jba ta ich'el ta muc'. Ja' chiyac'un ta ich'el ta muc' ec li Jtote. Li boch'otic mu xiyich'icun ta muq'ue ja' ta xchapan stuc li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Melel li c'usi chacalboxuque, li boch'otic ta xch'un c'usi chcale ja' mu'yuc ta xcham ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Li jchi'iltaque jech laj yalbeic li Jesuse: ―Laj xa jna'cutic ti ta melel ochem pucuj ta avo'ntone. Li jmoltotcutic Abraám ta vo'onee icham. Ichamic ec li yaj'alc'optac Diose. Li vo'ote chaval ti mu'yuc ta xcham li boch'otic ta xch'unic ac'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Me yu'un vo'ot más tsots avabtel avich'oj? Li jmoltotcutic Abraáme más tsots yabtel laj yich' pero icham. Ichamic ec li yaj'alc'optac Diose. Li vo'ote ¿boch'oot acuyoj aba? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Itac'ov li Jesuse: ―Ti jtucuc no'ox ta xcac' jba ta ich'el ta muq'ue, xu' mu xach'unic. Pero mo'oj. Ja' chiyac'un ta ich'el ta muc' li Jtote, ja' li Dios avu'un avalojique. ");
INSERT INTO tzotze_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero mu xavotquinic. Li vu'une xcotquin. Me ta xcal ti mu xcotquine, ta xi'epalc'opoj jech chac c'u cha'al cha'epalc'opojique. Li vu'une xcotquin li Diose, ta jch'unbe li c'usitic chiyalbune. ");
INSERT INTO tzotze_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Li amoltotic Abraám chavalique, xcuxet no'ox yo'nton yu'un ya'yojbun jc'oplal ti ta to xitale. La xch'un ti chitale jech xcuxet no'ox yo'nton ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Li jchi'iltaccutique jech laj yalbeic li Jesuse: ―Mu'yuc to staoj lajuneb yoxvinic (50) ajabilal, ¿c'uxi laj avil li Abraáme yu'un queremot to? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Li Jesuse jech laj yalbe: ―Melel li c'usi chacalboxuque, c'alal mu'yuc to'ox voq'uem li Abraáme, tey ono'ox oyun li vu'une ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jech lic stamic tal ton li jchi'iltaque yu'un tsc'an ox tsmilic ta ton li Jesuse. Li Jesuse ijelov batel ta o'lol cristianoetic jech muc xilic iloc' batel ta yamaq'uil templo. Jech ibat o. ");
INSERT INTO tzotze_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yo' bu lijelovcutic batel xchi'uc li Jesuse, tey laj quilcutic jun jchi'ilcutic ta israelal, ma'sat ono'ox c'alal ivoc' li vinique. ");
INSERT INTO tzotze_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vu'uncutic li yajchanc'opuncutique jech la jac'becutic li Jesuse: ―Jchanubtasvanej, ¿boch'o ta smul ti jech ma'sat ivoc' li vinic li'i? ¿Me ta scoj smul stuc, o me ta scoj smul stot sme'? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Itac'ov li Jesuse: ―Muc ta scojuc smul li jchi'iltic li'i, muc ta scojuc smul stot sme'. Ti jech ma'sat ivoc' li jchi'iltique, yu'un jech ac'o vinajuc o stsatsal Dios ta sventa. ");
INSERT INTO tzotze_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","C'alal cuxulun to li' ta banamile, persa ta jpasbe yabtel li Jtot ti la stacun tale. Me lichame, mu xa xi'abtej li'i. ");
INSERT INTO tzotze_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ti jayib to c'ac'al li'oyun ta banamile, ja' jech chac c'u cha'al luz c'otemun avu'unic, vo'oxuc ti li' oyoxuc ta banamile. Yu'un vu'un ta xcac'boxuc avilic ti xu' chacolic ta jventae ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","C'alal laj yal jech li Jesuse, la stubta banamil, la spas ta ach'el. Ja' la sbonbe ta jujubej sat li ma'sate. ");
INSERT INTO tzotze_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jech laj yalbe: ―Batan, bat poco tal asat ta stanqueal vo' Siloé sbi ―x'utat. (Ti Siloée ja' “tacbil”, xi smelol.) Ibat li ma'sate, bat spoc tal li sate. C'alal isut tale, lec xa xil osil. ");
INSERT INTO tzotze_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jech la sjac'be sbaic li boch'otic tey nopol nacajtic xchi'uque, xchi'uc li boch'otic yilojic ti jech ono'ox ma'sat c'alal ivoq'ue: ―Li vinic li'i ¿me mu ja'uc li boch'o tey chotol ta sc'an limosnae? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oy jayibuc jech laj yalic: ―Ja' le'e ―xiic. Oy yantic jech laj yalic: ―Mu ja'uc, ja' no'ox yu'un co'ol satic ―xiic. Li vinique jech laj yal: ―Vu'un chavilique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jech la sjac'beic: ―¿C'uxi ijam li asate? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Itac'ov li vinique: ―Oy jun jchi'iltic, Jesús sbi, la spas juteb ach'el, ja' la sbonbun ta jsat. C'alal la sbonbune, jech laj yalbun: “Batan ta stanqueal vo' Siloé, bat poco tal asat”, xiyutun. Jech tey bat jpoc tal li jsate, jech ijam o. Li' ta orae chquil xa osil ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jech la sjac'beic: ―¿Bu oy li vinic chavale? ―xutic. Itac'ov: ―Mu jna' bu ibat ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Laj yiq'uic batel li vinic ti ma'sat to'oxe, tey bat yaq'uic ta stojol li fariseoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yu'un ja' sc'ac'alil ta jcux co'ntoncutic ti c'alal la spas juteb ach'el li Jesuse yu'un ja' la sjambe o sat li ma'sate. ");
INSERT INTO tzotze_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Li fariseoetique la sjac'beic yan velta li vinique: ―¿C'uxi ijam li asate? ―xutic. Itac'ov li vinique: ―La sbonbun ach'el ta jsat, ts'acal bat jpoc li jsate jech ta xquil xa osil ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oy jayibuc fariseoetic jech laj yalic: ―Mu yich'ojuc ta muc' Dios li vinic chavale yu'un mu xchabi li sc'ac'alil ta jcux co'ntontique ―x'utat. Oy yantic jech laj yalic: ―Li boch'o oy smule mu xu' yu'un ta spas sq'uelubil stsatsal ―xiic. Jech cha'oxvoc' ic'otic li fariseoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jech la sjac'beic yan velta li vinique: ―Li vo'ote ¿boch'o avaloj ti la sjambot asate? ―xutic. Itac'ov li vinique: ―Li vu'une ta xcal ti ja' yaj'alc'op Diose ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Li fariseoetique muc xch'unic ti ja' li ma'sat to'oxe. Ja' to c'alal bat yic'beic tal stot sme'e, ja' to la xch'unic ti ja' li ma'sat to'oxe. ");
INSERT INTO tzotze_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","C'alal ivul li stot sme'e, jech la sjac'beic: ―¿Me ja' avol anich'onic li'i ti chavalic ma'sat ono'ox c'alal ivoq'ue? ¿C'uxi ijam sat ti ta xil xa osile? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Itac'ov li stot sme'e: ―Ja' col jnich'oncutic, ja' ti ma'sat ono'ox c'alal ivoq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero mu jna'cutic c'uxi ijam li sate. Mu jna'cutic noxtoc li boch'o ijambat sate. Jac'bo ava'yic stuc yu'un muc' xa, sna' xa yalel ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ti jech laj yalic li stot sme'e, yu'un ta xi'ic yu'un li jchapanvanejetic cu'uncutique. Yu'un li jchapanvanejetic cu'uncutique xchapojic xa ti j'ech'el mu xu' ch‑ochic ta nail tsobobbail li boch'o jamal ta xalbeic sc'oplal Jesús ti ja' xa li boch'o sc'oplal ono'ox chtal ventainvanuque. ");
INSERT INTO tzotze_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja' ta sventa ti jech laj yalic li stot sme'e: “Muc' xa, jac'bo ava'yic stuc”, ti xiic no'oxe. ");
INSERT INTO tzotze_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Laj yiq'uic tal yan velta li vinic ti ma'sat to'oxe. Jech laj yalbeic: ―Ja' xavalbe slequilal li Diose yu'un ja' la scoltaot. Li vinic chavale ta jna'cutic ti mu xich' ta muc' Diose ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Itac'ov li vinique: ―Mu jna' me mu xich' ta muc' Dios li vinique. Ja' no'ox ta jna' ti ma'satun to'oxe, li' ta orae chquil xa osil yu'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jech lic sjac'beic yan velta: ―¿C'uxi laj yut la sjambot li asate? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Itac'ov li vinique: ―Laj xa calboxuc ava'yic. Mu xac'an xach'unic. ¿C'u yu'un ti chac'an chava'yic yan veltae? ¿Me yu'un chac'an chanaban abaic ta stojol ec? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tey lic slabanic, jech laj yalbeic: ―Li vo'ote ja' nabalot ta stojol li boch'o mu xch'unbe smantal Diose. Li vu'uncutique ja' ta jch'uncutic c'usi yaloj li j'alc'op Moisese. ");
INSERT INTO tzotze_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jna'ojcutic ti la sc'opan sbaic xchi'uc Dios li Moisese. Li boch'o chavale mu jna'cutic bu liquem tal ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Itac'ov li vinique: ―Ta xch'ay co'nton avu'unic ta xca'i ti mu xana'ic bu liquem tale. Yu'un chavilic ti ja' la sjambun jsate. ");
INSERT INTO tzotze_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Li Diose ta jna'tic ti mu stuc'ulanbe sc'op li boch'otic mu xch'unbat smantale. Li boch'o ta xich' ta muc' Diose, ti tspasbe c'usi tsc'ane, ja' ta x'a'ibat sc'op yu'un li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","C'alal ilic tal li banamile xchi'uc c'alal to tanae, mu'yuc boch'o jech ca'yojbetic sc'oplal ti xu' yu'un ta sjambe sat li boch'o ma'sat ono'ox c'alal ivoq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti manchuc tey liquem tal ta stojol Dios li boch'o ta xcale, mu'yuc c'usi xu' yu'un ta spas ti jechuque ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","C'alal jech laj ya'yique, la slabanic. Jech laj yalbeic: ―Vo'ote yu'un pucujot ja' yu'un ma'sat lavoc'. Pero li' ta orae vo'ot chac'an chachanubtasuncutic ―xutic. Jech laj yalbeic ti j'ech'el mu xu' ta x'och o ta nail tsobobbaile. ");
INSERT INTO tzotze_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Li Jesuse laj ya'ibe sc'oplal ti j'ech'el mu xu' ta x'och ta nail tsobobbail li vinique. Jech ital li Jesuse, tal sc'opan li vinique. Jech la sjac'be: ―Li vo'ote ¿me ach'unoj ti talem xa li Xnich'on Dios ti ja' xu' ta scoltaot yu'un amule? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Itac'ov li vinique: ―¿Bu oy? tata. Ta jch'un ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Li Jesuse jech laj yalbe: ―Li' xa aq'uelojbe sate yu'un vu'un ti li' ta jc'opanote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","C'alal laj ya'i li vinique, la squejan sba ta stojol. Jech laj yalbe: ―Cajval, ta jch'un ti vo'ot chacoltaun yu'un jmule ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Li Jesuse jech laj yalbe li vinique: ―Ti lital li' ta banamile yu'un jech chvinaj c'u x'elan yo'ntonic li cristianoetique. Yu'un li boch'otic tsc'an ono'ox chotquinic Diose ja' ta xjambat satic ya'yel yu'un ta xotquinic. Yan li boch'otic xotquinic ono'ox Dios yalojique ja' tspasic ta ma'sat ya'yel yu'un mu xu' chotquinic o ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oy jayibuc fariseoetic tey xchi'inojic li Jesuse. C'alal laj ya'yic jech laj yal li Jesuse, jech la sjac'beic: ―¿Me yu'un ma'satuncutic avaloj ec li vu'uncutique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Itac'ov li Jesuse: ―Ti ma'satucoxuque, mu'yuc amulic ti jechuque. Yu'un chavalic ti xavotquinic Diose, ja' amulic c'otem ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Li Jesuse jech laj yal noxtoc: ―Melel li c'usi chacalboxuque, li boch'otic muc ta ti' corraluc ta x'ochique, me ta xbitic no'ox ochel ta pat corrale, ja' j'elec' chijetic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yan li boch'otic ta ti' corral ta x'ochique ja' jchabichijetic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Li jchabi ti' corrale ta sjambe sti' li corrale yu'un ac'o ochuc batel li jchabichijetique. Li chijetique cha'ibeic c'u x'elan snuc' li jchabivanej yu'unique. Li jchabichijetique ta xalanbeic sbi li jaycot xchijique yu'un ta sloq'uesanic batel. ");
INSERT INTO tzotze_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","C'alal me la sloq'uesanic scotol ti jaycot xchijique, ja' ba'yucbe ta xbatic. Tey nabal ta xbatan ta spatic li xchijique yu'un x'a'ibat c'u x'elan snuq'uic yu'un li xchijique. ");
INSERT INTO tzotze_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yan me cha'yic ti mu ja'uc yajvalique mu xchi'inic batel. Ta xjatovic batel yu'un cha'yic ti mu ja'uc snuc' yajvalique ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ja' jech x'elan lo'il laj yac' ta a'yel li Jesuse. Li jchi'iltaccutique muc xa'ibeic smelol c'usi i'albatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Li Jesuse jech laj yalbe noxtoc li jchi'iltaccutique: ―Melel chacalboxuc, vu'un ta jventa xu' cha'ochic ta stojol Dios. Jech chac c'u cha'al chijetic ti c'alal ch‑ochic ta corrale, ta ti' corral ch‑ochic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Scotol li boch'otic jchabichijetic yalojic ti ba'yuc ono'ox li' oyique, ja' jlo'lavanejetic. Ja' jechic jech chac c'u cha'al j'elec' chijetic yu'un tsc'an ta spojbicun li boch'otic tsc'an ta xtalic ta jtojole. Li boch'otic ta xtalic ta jtojole yu'un muc xich'beic ta muc' sc'op li jlo'lavanejetique. ");
INSERT INTO tzotze_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Vu'une xco'laj xchi'uc ti'corralun ya'yel yu'un scotol li boch'otic ta xch'unic ti chcolic ta jventae, ja' xchij Dios ta xc'otic o. Jech chac c'u cha'al chijetic ti lec chabibilic c'alal ta xloq'uic tale xchi'uc ti c'alal ta x'ochic batele, yu'un jech ta sta lec sve'elic. Ja' no'ox jechic ec li boch'otic c'otemic xa ta xchij Diose, lec ta jchabiic. Jech xcuxet no'ox yo'ntonic, mu'yuc xa c'usi yan ta sc'anic o. ");
INSERT INTO tzotze_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Li j'elec' chije ja' no'ox yabtel ta x'elc'aj o, ta xmilvan, ta soquesvan. Yan li vu'une ja' tal cac'be xcuxlejalic sventa sbatel osil. Jech lec ta xc'otic o. ");
INSERT INTO tzotze_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Li boch'o yu'un stuc li chije lec ta xchabi. Mu'yuc tsots sc'oplal cha'i me ta xbat ta bolom li stuque yu'un ja' tsots sc'oplal cha'i li xchije. Ja' no'ox jechun ec li vu'une, lec ta jchabi li boch'otic ta xch'unic ti vu'un Jcoltavanejun yu'unique. Ta xcac' jba ta milel yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Li boch'o ja' no'ox ta sa' abtel ta xchabi chijetique, mu ja'uc yu'un li chijetique, c'alal me laj yil ta xtal jti'vanej bolome, ta scomtsan li chijetique. Ta xjatov batel. Jech oy ta xbat ta bolom li chijetique. Li yantique ta spuc sbaic batel. ");
INSERT INTO tzotze_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ti jech ta xjatovic batel li jsa'abteletique, yu'un ja' no'ox ta sa'ic tojel, jech mu sventauc cha'yic li chijetique. ");
INSERT INTO tzotze_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Li boch'o yu'un stuc li chije lec ta xchabi xchi'uc lec xotquinan. Ja' no'ox jechun ec li vu'une, lec ta jchabi li boch'otic ta xch'unic ti ta xcolic ta jventae. Xcotquinan, jech xiyotquinicun ec. ");
INSERT INTO tzotze_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Xcotquin jbacutic jchi'uc jech chac c'u cha'al xcotquin jbacutic jchi'uc li Jtote. Xiyotquinun li Jtote, jech xcotquin ec. Ta xcac' jba ta milel yu'unic scotol li boch'otic ta xtalic ta jtojole. ");
INSERT INTO tzotze_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oy boch'otic mu ja'uc jchi'iltic ta israelal ta xlic xch'unic ti vu'un Jcoltavanejun yu'unique. Ta persa ta xquic'an ec. Ta xch'unic ec li c'usi chcale, jech co'ol chac'ot achi'uquic ti jayib chach'unic ti vu'un Jcoltavanejun avu'unique. Jun no'ox jchabivanej avu'un acotolic. Ja' vu'un ti ta jchabioxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Lec chisc'anun li Jtote yu'un ta xcac' jba ta milel yu'unic li boch'otic ta xtalic ta jtojole. Ts'acal to chicha'cuxi. ");
INSERT INTO tzotze_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mu'yuc boch'o xu' yu'un ta smilun. Slequil co'nton jtuc ti ta xcac' jba ta milele. Xu' cu'un ta xcac' jba ta milel. Xu' cu'un chicha'cuxi noxtoc yu'un jech yalojbun li Jtote ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Li jchi'iltaccutique cha'voc' ic'otic ta sventa ti jech laj yal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oy ep jech laj yalic: ―Ochem pucuj ta yo'nton. Vovijem sjol. ¿C'u yu'un chava'ibeic li c'usi chale? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oy yantic jech laj yalic: ―Li boch'o ochem pucuj ta yo'ntone mu jechuc lec ta xc'opoj. Me junuc pucuj mu xu' yu'un ta sjambe sat ma'satetic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tey ta lum Jerusalene ja' o yorail q'uin cu'uncutic, vu'uncutic li israeluncutique. Li q'uine ja' sventa ta jna'cutic c'usi ora lic tunuc yu'un Dios yan velta li templo cu'uncutique. Ja' ta yorail sictic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Li Jesuse tey ta xanov ta stentennail templo yo' bu Salomón sbie. ");
INSERT INTO tzotze_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Li jchi'iltaccutique tey ital set sbaic yo' bu oy li Jesuse. Jech la sjac'beic: ―¿Jayib to c'ac'al li' chavac' lo'ilajuc co'ntoncutic? Me vo'ot t'ujbilot yu'un Dios chaventainuncutique, jamal me xavalbun ca'icutic ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Itac'ov li Jesuse: ―Laj xa calboxuc, mu xach'unic. Laj avilic noxtoc ti ep sq'uelubil jtsatsal la jpas ta sventa li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yu'un ti mu xach'unique, yu'un mu cu'unucoxuc jech chac c'u cha'al calojboxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Li boch'otic cu'une cha'yic li c'usi ta xcalbeique. Ta xcotquin. Jech chiyich'icun ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta xcac' cuxiicuc sbatel osil jech mu xbatic ta ch'ayel sbatel osil. Mu'yuc boch'o xu' yu'un ta xispojbun loq'uel ta jc'ob. ");
INSERT INTO tzotze_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yu'un ja' laj yac'bun ta jc'ob li Jtot ti scotol xu' yu'un tspase. Mu'yuc boch'o xu' yu'un ta spojbe ta sc'ob li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Li vu'une jununcutic jchi'uc li Jtote ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Li jchi'iltaccutique bat stamic tal ton yu'un tsc'an ta smilic ox ta ton yan velta li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jech i'albatic yu'un li Jesuse: ―Puro lec c'usitic laj cac'boxuc avilic ta sventa li Jtote. ¿Bu junucal chopol la jpas ti chac'an chamilicun ta tone? ―x'utatic yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Itac'ovic li jchi'iltaccutique: ―Ma'uc ta sventa lec c'usi laj apas ti chacac'becutic tone. Ja' ta sventa ti chatoy aba ta stojol Diose. Yu'un vinicot no'ox pero chacuy aba ta Dios ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Itac'ov li Jesuse: ―Jech ts'ibabil ta svun Dios ti tey avich'ojique: “Li vo'oxuque jq'uexoloxuc”, x'utatic yu'un Dios li jchapanvanejetic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Jq'uexoloxuc”, xi sc'oplalic li boch'otic i'ac'bat yabtelic yu'un Dios ta vo'onee. (Mu xu' ta xch'ay ti jech ono'ox yaloj ta svun Diose.) ");
INSERT INTO tzotze_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Toj lec ti jech i'albatique”, xachiic. Lec ti jech chavalique. Pero ¿c'u yu'un chavalbicun ti ta jtoy jba ta stojol Dios ti laj cal ti vu'un Xnich'onun Diose? Yu'un jech ac'bilun cabtel yu'un Jtot ti lital li' ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Me mu ja'uc yabtel Jtot ta jpas chavilique, mu me xach'unic ti vu'un Xnich'onune. ");
INSERT INTO tzotze_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ac'o me mu xach'unic ti vu'un Xnich'onune, pero ch'unic me ta sventa li c'usi ta jpase yu'un ja' yabtel Jtot ta jpas. Jech chana'ic o ti jununcutic jchi'uc li Jtote ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Li jchi'iltaccutique tsc'an ta stsaquic yan velta li Jesuse. Pero muc stsaquic, yu'un ta ora iloc' batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Li Jesuse ibat yan velta ta jot uc'um Jordán yo' bu laj yac' ich' vo' li Juane. Jech tey libatcutic ec. Tey lijoc'tsajcutic jayibuc c'ac'al xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","C'alal tey oyuncutique, ep jchi'iltaccutic ta israelal italic ta stojol li Jesuse. Jech laj yalic: ―Ac'o me muc spas sq'uelubil stsatsal Dios li Juan j'ac'vanej ta vo'e, pero melel c'usi laj yal ta sventa li jchi'iltic li'i ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Li boch'otic italique oy ep la xch'unic ti ja' Jcoltavanej li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oy jun jchi'ilcutic ta israelal, Lázaro sbi, itsacat ta chamel. Tey nacal ta lum Betánia tey ta Judea banamil. Ja' li lum yo' bu nacalic li chib antsetique, ja' María xchi'uc Marta sbiic. Ja' xchi'il sbaic ta voq'uel. ");
INSERT INTO tzotze_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Li Maríae ja' ti ts'acal to la smalbe muil poxil ta yacan Cajvaltique xchi'uc ti la scusbe ta stsotsil sjole. Ja' yixlal li Lázaroe. ");
INSERT INTO tzotze_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Li yixlaltac Lázaroe la staquic ta iq'uel li Jesuse: ―Cajval, ip cha'i li Lázaroe, ja' ti lec ac'anoj aba achi'uque ―xi c'otel li boch'o la staquic batele. ");
INSERT INTO tzotze_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","C'alal laj ya'i li Jesuse, jech laj yal: ―Li chamel ip cha'ye mu ja'uc sventa ta xcham o. Ja' no'ox sventa ac'o ich'atuc ta muc' li Diose xchi'uc ac'o ich'atcun ta muc' ec, vu'un li Xnich'onune ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Li Jesuse, ac'o me lec sc'anoj li Martae, xchi'uc li smuque, xchi'uc li Lázaroe, c'alal laj ya'i ti ip cha'i li Lázaroe, chib to c'ac'al tey lijoc'tsajcutic yo' bu ono'ox oyuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ts'acal to jech laj yalbuncutic Jesús, vu'uncutic li yajchanc'opuncutique: ―Sutcutic batel yan velta ta Judea ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jech laj calbecutic: ―Jchanubtasvanej, ach' to tey c'an smilot ta ton li jchi'iltactique. ¿Me tey chac'an chabat yan velta? ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Itac'ov li Jesuse: ―Li Diose lajchab ora yac'oj li jujun c'ac'ale yu'un jech xu' chij'abtej. Ja' no'ox jechun ec li vu'une, yorail to chi'abtej. Jech chac c'u cha'al li boch'o ta xanov ta c'ac'altique mu'yuc ta sbosi yacan yu'un sac to li osile. ");
INSERT INTO tzotze_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yan me ic' xae, ja' xa yorail ta sbosi yacan yu'un mu xa xil sbe. Jech li vu'une, ja' to me la sta sc'ac'alil yu'un Dios ti chimilate, ja' to xu' yu'unic li jchi'iltactique ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jech laj yal noxtoc li Jesuse: ―Li Lázaro ti lec chquil jbatic jchi'uctique vayem xa. Pero ta xbat jtij liquel ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jech laj calbecutic, vu'uncutic li yajchanc'opuncutique: ―Cajval, me i'och xa svayele, yu'un xa ta x'utsib ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ti jech laj yal li Jesuse yu'un chamen o li Lázaroe. Vu'uncutic li yajchanc'opuncutique la jnopcutic ti naca no'ox ta xvaye. ");
INSERT INTO tzotze_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Li Jesuse jamal laj yalbuncutic, jech laj yal: ―Chamen o li Lázaroe. ");
INSERT INTO tzotze_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pero xcuxet no'ox co'nton ti mu'yuc tey oyun c'alal ichame yu'un jech ac'o ach'unic o ti vu'un Jcoltavanejun avu'unique. Batic, bat jq'ueltic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Li jun jchi'ilcutic ta abtele, ja' li Tomás sbie, ja' ti loin xcutcutique, jech laj yalbuncutic: ―Batic, co'ol ac'o chamcutic jchi'uctic li jchanubtasvanej cu'untique ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jech bat jchi'incutic li Jesuse. C'alal lic'otcutique, xchanibal xa'ox c'ac'al smuquel li Lázaroe. ");
INSERT INTO tzotze_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Li Betániae nopol xil sbaic xchi'uc li Jerusalene. Oy no'ox van o'loluc reva xil sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Oy ep jchi'iltac tey talemic yu'un ja' tspatbeic yo'nton li Martae xchi'uc li Maríae yu'un chamen xa li xi'melique. ");
INSERT INTO tzotze_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","C'alal laj ya'i Marta ti ta xtal li Jesuse, ta ora bat snup ta be. Li Maríae tey icom ta snaic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Li Martae jech laj yalbe li Jesuse: ―Cajval, ti li'uc oyot c'alal itsacat ta chamel li jxi'mele, muc xcham ti jechuque. ");
INSERT INTO tzotze_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero manchuc me ep xa c'ac'al xchamel, ta jna' ti ta xac'bot scotol c'usi chac'anbe li Diose ―xi li Martae. ");
INSERT INTO tzotze_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Li Jesuse jech laj yalbe: ―Ta xcha'cuxi loq'uel ta smuquinal li axi'mele ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Itac'ov li Martae: ―Ta jna' ti ta xcha'cuxi loq'uel ta smuquinal ta slajebal c'ac'al c'alal ta xcha'cuxiic scotol li boch'otic chamenique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Li Jesuse jech laj yalbe: ―Oy cha'cuxesel xchi'uc oy cuxlejal sbatel osil ta jventa jtuc. Li boch'otic ta xch'unic ti vu'un ta jcoltae, ac'o me ta xchamic, pero ta xcuxiic sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Scotol li boch'otic ta xcuxiic sbatel osile, ja' li boch'otic xch'unojic ti vu'un ta jcoltae, mu'yuc xa sc'oplal ta xbatic ta ch'ayel. ¿Me jech ach'unoj? ―x'utat yu'un Jesús li Martae. ");
INSERT INTO tzotze_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Itac'ov li Martae: ―Jech, Cajval. Jch'unoj ti vo'ot t'ujbilot yu'un Dios chacoltauncutic yu'un jmulcutic li' ta banamile yu'un vo'ot Xnich'onot Dios ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","C'alal laj yal jech li Martae, bat yic' tal li smuque, ja' li Maríae. Ta mucul laj yalbe: ―Ital xa li Jchanubtasvaneje, ta stacot ta iq'uel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","C'alal laj ya'i li Maríae, ta ora iloc' batel yu'un bat sc'opan li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pero mu'yuc to chic'otcutic ta Betánia xchi'uc li Jesuse. Tey to oyuncutic yo' bu licomcutic yu'un li Martae. ");
INSERT INTO tzotze_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Li jchi'iltaccutic tey oyic ta sna Maríae, ja' ti talemic ta spatbel yo'ntonique, c'alal laj yilic iloc' batel ta anil li Maríae, la xchi'inic batel ec. Jech laj yalic: ―Yu'un ta xbat oc'uc ta smuquinal li xi'mele ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","C'alal ic'ot bu oyuncutic li Maríae, laj yil bu va'al li Jesuse, la spatan sba ta banamil ta stojol. Jech laj yalbe: ―Cajval, ti li'uc oyot c'alal itsacat ta chamel li jxi'mele, muc xcham ti jechuque ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","C'alal laj yil Jesús ti ta x'oc' li Maríae xchi'uc ta x'oq'uic ec li jchi'iltaccutic tey xchi'inoj tale, chopol laj yil ti jech oy at‑o'nton li' ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jech la sjac'be: ―¿Bu laj amuquic? ―xut. ―Le'e. Bat jq'ueltic avil ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tey lic oc'uc ec li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Li jchi'iltaque jech laj yalbe sbaic: ―Q'uelavilic, lec sc'anoj li Lázaroe ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Oy boch'otic jech laj yalic: ―Li vinic li'i xu' yu'un ta sjambe sat li ma'satetique. ¿C'u yu'un muc xu' yu'un la scolta li Lázaroe? Ti lajuc scoltae, muc xcham ti jechuque ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","C'alal lic'otcutic ta smuquinal Lázaroe, li Jesuse chopol laj ya'i yan velta ti jech oy at‑o'nton li' ta banamile. Li smuquinal Lázaroe ja' vombil ton. Ton noxtoc li smac sti'e. ");
INSERT INTO tzotze_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Li Jesuse jech laj yal: ―Balch'unic loq'uel li tone ―xi. Itac'ov li yixlal Lázaroe, ja' li Martae: ―Cajval, tu xa yu'un xchanibal xa c'ac'al smuquel ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Li Jesuse jech laj yalbe: ―Laj xa calbot ti me chach'un ti vu'un Jcoltavanejune jech chavil o c'u x'elan stsatsal li Diose ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jech lic sbalch'unic loq'uel li ton ti smacojbeic o sti' smuquinal Lázaroe. Li Jesuse la sq'uel muyel vinajel, la sc'opan Dios. Jech laj yal: ―Tati, colaval ti chava'ibun jc'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ta jna' ti scotol c'ac'al chava'ibun jc'ope. Jech ta xcalbot yu'un ac'o ya'yic ec li boch'otic li' nopol va'ajtique yu'un jech ta xch'unic o ti vo'ot laj atacun tale ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","C'alal laj yal jeche, tsots i'avan li Jesuse: ―¡Lázaro, loc'an tal! ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Li ánimae iloc' tal. Lec ts'otbil ta poc'. Li sjole pixbil ta panyo. Li Jesuse jech laj yalbe li cristianoetique: ―Titunic, ac'o batuc ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Li jchi'iltaccutic ti xchi'inojic tal Maríae, c'alal laj yilic la xcha'cuxes ánima li Jesuse, ep boch'otic la xch'unic ti ja' Jcoltavaneje. ");
INSERT INTO tzotze_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero oy jayibuc bat yalbeic fariseoetic ti la xcha'cuxes Lázaro li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Li banquilal paleetique xchi'uc li fariseoetique la stsobic tal scotol li xchi'iltaquic ta chapanvaneje. Jech laj yalbeic: ―¿C'usi ta jpasbetic li vinic chcaltique? Yu'un ep sq'uelubil ta xac' ta ilel ti scotol xu' yu'une. ");
INSERT INTO tzotze_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Tey ac'o spas jech”, me xijchie, ta xlic xch'unic scotol jchi'iltactic ti ja' t'ujbil yu'un Dios chisventainutique. Jech ta xlic stiq'uic ta ajvalilal. Jech ta xlic socuc sjol li muc'ta ajvalil tey ta Romae. Ta xlic stac tal yajsoldadotac. Ta xtal svuq'uesic li jlumaltique jech chijpuc batel jcotoltic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tey oy jun xchi'ilic ta abtel, Caifás sbi. Ja' o ochem ta más banquilal pale li Caifase. Jech laj yal: ―Li vo'oxuque mu xana'ic snopel. ");
INSERT INTO tzotze_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mu xana'ic ti ja' lec me jun no'ox vinic ta xcham cu'untique, ja' chopol me ta xijchamutic jcotoltique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero muc stucuc no'ox jech laj yal. Yu'un ja' o ochem ta más banquilal pale, jech ich'amanbat ye yu'un Dios ta sventa ac'o yal ti ja' ac'o chamuc li Jesuse yu'un ja' jq'uexolcutic ta xc'ot, vu'uncutic li israeluncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero li Jesuse mu ja'uc no'ox snopoj ta xcham ta jcojcutic, vu'uncutic li israeluncutique. Ja' ta xcham ta sventa scotol boch'otic ta xich'ic ta muc' Dios ti buyuc no'ox oyic ta sbejel banamile, yu'un jech jun no'ox chijc'ot jcotoltic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","C'alal laj ya'yic jech laj yal Caifás li jchapanvanejetic cu'uncutique, ta ora no'ox lic snopic c'u x'elan xu' ta smilic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Li Jesuse muc xa xac' sba ta ilel ta stojol scotol li jchi'iltaccutic ta israelale. Iloc' batel ta yan banamil. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. Ti bu libatcutique ja' nopol xil sba xchi'uc xocol banamil. Tey lic'otcutic ta lum Efraín. Tey lijoc'tsajcutic xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","C'alal jutuc xa'ox sc'an sta yorail q'uin coltael cu'uncutique, oy ep jchi'iltaccutic ba'yuc ibatic ta Jerusalén. Yu'un bat yac' sbaic ta lecubtasel yu'un pale yu'un jech xu' tsti'ic li chij sventa q'uin coltaele. ");
INSERT INTO tzotze_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","C'alal ic'otic ta Jerusalén li cristianoetique, tey lic sa'ic li Jesuse yu'un tsc'an chotquinic. Scotol li boch'otic tey xa oyic ta yamaq'uil templo ta Jerusalene, jech lic sjac'be sbaic: ―¿C'usi chanop? ¿Me chtal ta q'uin xana' li Jesuse yu'un ya'yoj ti chich' tsaquele? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yu'un li banquilal paleetique xchi'uc li fariseoetique yalojic xa'ox mantal ti jamal ac'o yalic me oy boch'o laj yil bu oy li Jesuse yu'un ac'o yich' tsaquel. ");
INSERT INTO tzotze_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vaquib xa c'ac'al sc'an sta sc'ac'alil q'uin coltael ibat yan velta Jesús ta Betánia. Ja' tey yo' bu nacal li Lázaro ti icha'cuxesat loq'uel ta smuquinal yu'un Jesuse. La jchi'incutic batel, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Li Lázaro xchi'uc yixlaltaque laj yic'uncutic ta ve'el xchi'uc li Jesuse yu'un ja' chich'ic ta muc' li Jesuse. Ja' imac'linvan li Martae. Li Lázaroe tey la xchi'inuncutic ta chotlej ta ti' mesa. ");
INSERT INTO tzotze_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Li Maríae laj yich' tal o'lol kilo muil poxil, nardo sbi. Toj toyol stojol li nardoe. La xjaxbe ta yacan li Jesuse. C'alal la xjaxbee, la scusbe ta stsotsil sjol. Li yic' muil poxile ipuc ta sbejel sna. ");
INSERT INTO tzotze_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tey oy ec li jun jchi'ilcutic ta abtele, ja' li Judas Iscariotee. Ja' ti ts'acal to lic yac' ta c'abal li Jesuse. Jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿C'u yu'un muc xchon ta oxib ciento (300) denario taq'uin li muil poxil li'i? Ja' laj yac'be me'onetic ti jechuque ―xi li Judase. ");
INSERT INTO tzotze_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ti jech laj yal li Judase, mu yu'unuc ja' ta xc'uxubin li me'onetique. Yu'un ja' tsc'an ta xelc'an stuc. Yu'un ja' xchabioj li yavil jtaq'uincutic xchi'uc Jesuse. Jech tey ono'ox ta xelc'an jutuc li jtaq'uincutique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Li Jesuse jech laj yalbe li Judase: ―Mu me xaval jech. Ja' sventa c'alal ta ximucat li muil poxil li' snac'ojbune. ");
INSERT INTO tzotze_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Scotol c'ac'al li' achi'uquic li me'onetique. Li vu'une mu scotoluc c'ac'al li' ta jchi'inoxuc ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Li jchi'iltaccutic ti tey xa stsoboj sbaic ta Jerusalene laj ya'yic ti tey xa lic'otcutic ta Betánia xchi'uc li Jesuse. Ta ora italic. Pero mu ja'uc no'ox tal sq'uelic li Jesuse, ja' tal sq'uelic ec li Lázaro ti icha'cuxesat loq'uel ta smuquinal yu'un Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jech li banquilal paleetique la snopic ta smilic ec li Lázaroe. ");
INSERT INTO tzotze_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yu'un ja' ta scoj ti ep jchi'iltaccutic tscomtsanic li paleetique yu'un ja' xa ta xch'unic ti ja' Jcoltavanej li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ta yoc'omal tey stsoboj sbaic ta Jerusalén scotol li jchi'iltaccutic ta israelale yu'un ja' xa yorail li q'uine. Laj ya'yic ti tey ta xbat ta Jerusalén li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jech scotolic la sa'ic tal yanal xan, iloq'uic tal ta lum. Xtuchanojic tal li yanal xane tal snupic ta be li Jesuse. Tsots i'avanic tal. Jech laj yalic: ―¡Coliyal Dios, toj lec li boch'o la stacbutic tale! Ja' ta x'och ta ajvalilal cu'untic, vu'utic li israelutique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Li Jesuse la sta jcot burro. Ja' la scajlebin jech chac c'u cha'al ts'ibabil ono'ox comel sc'oplal ta sc'op Diose: ");
INSERT INTO tzotze_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Vo'oxuc li israeloxuque, mu xavat avo'ntonic. Ta xtal li ajvalil avu'unique. Cajal ta jcot burro ta xtal, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vu'uncutic li yajchanc'opuncutique muc jna'becutic smelol ti c'alal jech cajal ta burro i'och ta Jerusalene. Ja' to c'alal itoy batel ta vinajele, ja' to la jna'cutic ti jech ono'ox ts'ibabil comel sc'oplal ti jech ch‑ich'at ta muc' yu'un jchi'iltaccutique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Yu'un ti ital nupvanicuc ta be li jchi'iltaccutique, yu'un laj ya'yic ti la xcha'cuxes Lázaro li Jesuse. Ja' i'albatic yu'un li boch'otic tey xchi'uquic Jesús ti c'alal la xcha'cuxes loq'uel ta smuquinal li Lázaroe. ");
INSERT INTO tzotze_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Li fariseoetique jech laj yalbe sbaic: ―Q'uelavilic, mu xu' cu'untic ta jpajestic li jchi'iltactique yu'un ep boch'otic lec chilic li Jesuse ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oy grecia viniquetic tey ta xc'otilanic ta q'uin ec. Yu'un ja' jech xch'unojic jech chac c'u cha'al xch'unojic li jchi'iltaccutic ta israelale. Jech tey ital yac'beic smoton Dios ta q'uin ec. ");
INSERT INTO tzotze_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tey la sc'opanic li Felipee, ja' li jchi'ilcutic ta abtele. Ja' tey liquem tal ta Galilea banamil tey ta lum Betsáida. Jech laj yalbeic: ―Tata, chac jc'opan ca'icutic li Jesuse ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Li Felipee bat yalbe li Andrese. Jech xchibalic bat yalbeic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jech i'albatic yu'un li Jesuse: ―Laj xa sta sc'ac'alil ta xvinaj ti ac'bilun cabtel ta sventa scotol cristianoetic, vu'un ti co'ol cristianoutique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Melel li c'usi chacalboxuque, ta persa ta ximilat yu'un jech ep boch'o ta x'ac'bat xcuxlejalic sventa sbatel osil. Jech chac c'u cha'al me mu'yuc ta xich' muquel jbej bec' trigoe, stuc no'ox oy o. Yan me ta xich' muquele, ep ta xlic satinuc. ");
INSERT INTO tzotze_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ja' no'ox jech li boch'o mu sc'an xcham ta jcoje ja' ch'ayel chbat. Yan li boch'o mu sventauc me ta xchame ja' chcuxi sbatel osil. ");
INSERT INTO tzotze_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Scotol li boch'otic tsc'an ta xtunic cu'une ac'o ts'icuc yu'un vocol jech chac c'u cha'al sts'ic cu'une. Jech tey ta xc'ot xchi'inun o ta naclej ta vinajel. Li boch'otic ta xtunic cu'une ta x'ac'atic ta ich'el ta muc' yu'un li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ac'o me mu jc'an xicham, pero mu yu'unuc jech ta xcalbe li Diose: “Tati, coltaun, mu me xicham”, mu xichiuc ta stojol. Yu'un ja' ta sventa tal chamcun li' ta banamil ti litale ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jech lic sc'opan Dios li Jesuse: ―Tati, ac'o ich'atan ta muc' ta jventa ―xi. I'a'ibat sc'op yu'un li Diose. Jech ic'opoj tal ta vinajel: ―Ich'bilun xa ta muc' ta aventa. Pero más to ta xquich' ich'el ta muc' ta aventa ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Li cristianoetic tey oyique laj ya'yic ti oy c'usi tsots ibac' ta vinajele. Oy boch'otic jech laj yalic: ―Ta xbac' chauc ―xiic. Oy yantic jech laj yalic: ―Yu'un ic'opanat yu'un jun yaj'almantal Dios ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Li Jesuse jech laj yal: ―Ti jech tsots la sc'opanun li Jtote, mu ja'uc ta sventa ac'o jna' ti laj ya'ibun jc'ope. Ja' ta sventa ac'o ana'ic vo'oxuc. ");
INSERT INTO tzotze_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Li' ta orae ja' xa yorail ta xvinaj ti oy smulic li boch'otic mu sc'an xiyich'icun ta muq'ue. Laj xa sta sc'ac'alil ta jpojbe yabtel li pucuj ti ja' sventainoj scotol cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yu'un ti chicham ta cruze, yu'un jech chquic'an tal ta jtojol scotol li boch'otic tsc'an chiyich'icun ta muc' ta sbejel banamile ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jech tey laj yac'bun o jna'cutic ti ta cruz ta xmilate. ");
INSERT INTO tzotze_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Itac'ovic li jchi'iltaccutique: ―Ca'yojbecutic ono'ox sc'oplal li boch'o t'ujbil yu'un Dios chtal sventainutique. Ts'ibabil comel ta sc'op Dios ti cuxul o sbatel osile. Me vo'ot chaventainuncutique, ¿c'u yu'un jech chaval: “Ta persa chimilat ta cruz, vu'un ti co'ol cristianoutique”, xachi? ¿Boch'oot cha'e? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Itac'ov li Jesuse: ―Mu xa epuc c'ac'al li' ta jchanubtasoxuc. Ja' lec ich'ic ta muc' li c'usi ta xcale yu'un yorail to chavich'ic ta muc', jech chacolic sbatel osil. Jech chac c'u cha'al li boch'o ta xanov ta bee, me jliquel xa no'ox sac li osile, ta xac'be yipal yu'un jech mu x'ic'ub ta be. Yu'un me i'ic'ube, mu xa xil osil, mu xa sna' bu ta xbat. ");
INSERT INTO tzotze_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ja' no'ox jechoxuc ec li vo'oxuque, ch'unic ti vu'un t'ujbilun yu'un Dios chajcoltaoxuque yu'un yo' to li' jchi'inojoxuc, jech xnich'naboxuc Dios chac'otic o ―xi li Jesuse. C'alal laj yal jech li Jesuse, iloc' batel, muc xa xac' sba ta ilel. ");
INSERT INTO tzotze_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Altic laj yilic ep sq'uelubil stsatsal li Jesuse, muc xch'unic ti ja' t'ujbil yu'un Dios chiscoltautique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yu'un ja' ic'ot o c'usi la sts'iba li j'alc'op Isaías ta vo'onee. Jech la sts'iba: Ac'o me ep sq'uelubil stsatsal ch‑ac'bat yilic li jchi'iltactique, pero mu xch'unic ti ja' ac'bil yabtel yu'un Dios ti ja' Jcoltavanej cu'untic chc'ote, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Muc xu' yu'un la xch'unic li jchi'iltaccutique yu'un ja' ic'ot o jech chac c'u cha'al la sts'iba noxtoc li Isaíase: ");
INSERT INTO tzotze_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ta jmacbe satic, ta jtsatsubtasbe yo'ntonic yu'un jech mu xilic, jech mu xc'ot ta yo'ntonic. Yu'un mu ono'ox sc'an scomtsan smulic jech mu xcolic o cu'un, xi li Diose, xi ono'ox li Isaíase. ");
INSERT INTO tzotze_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yu'un ti laj yal Isaías ti ep sq'uelubil tspase, yu'un i'ac'bat xa yil ti scotol xu' yu'un li boch'o t'ujbil yu'un Dios chventainvane. Ja' yu'un jech laj yalbe sc'oplal. ");
INSERT INTO tzotze_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ac'o me oy muc xch'unic li jchi'iltaccutique, pero oy ono'ox la xch'unic. C'alal ta jchapanvanejetic cu'uncutic ep la xch'unic ti ja' t'ujbil yu'un Dios li Jesuse. Pero muc jamaluc laj yalic ti xch'unojique yu'un naca me mu x'aq'ue ochicuc ta nail tsobobbail yu'un li xchi'iltac ta abtele. ");
INSERT INTO tzotze_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mu ja'uc tsots sc'oplal laj ya'yic ti lec ac'o ilaticuc yu'un Diose. Ja' no'ox tsots sc'oplal laj ya'yic ti lec ac'o ilaticuc yu'un cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Li Jesuse la sc'opan yan velta li jchi'iltaccutique. Tsots i'avan, jech laj yalbe: ―Scotol boch'o ta xch'unic ti vu'un ta jcoltae ja' xch'unojic o ti chcoltaat yu'un li Jtote yu'un ja' la stacun tal. ");
INSERT INTO tzotze_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Scotol li boch'otic tsq'uelilan c'u xi'elane laj xa yilic o c'u x'elan li Jtot ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Li vu'une luz c'otemun avu'unic, vo'oxuc ti li' to oyoxuc ta banamile. Scotol boch'otic ta xch'un ti vu'un Jcoltavanejun yu'unique, ta xbijubic, jech ta xotquinic o li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Li boch'otic laj xa ya'ibicun jc'ope, me mu xch'unic ti vu'un Jcoltavanejun yu'unique, mu'yuc ta jchapan ta ora. Yu'un mu ja'uc tal jchapan li cristianoetique. Ja' no'ox tal jcolta. ");
INSERT INTO tzotze_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Li boch'otic mu xch'un ti vu'un Jcoltavanejun yu'unique, ta to sta sc'ac'alil ta xchapanat ta slajebal c'ac'al. Ja' ta xchapanatic ta sventa ti muc xch'unic li c'usi laj cale, jech ta xich'ic o castigo. ");
INSERT INTO tzotze_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mu jtucuc no'ox ta jnop li c'usi ta xcale. Ja' laj yalbun li Jtot ti la stacun tale. Ja' laj yalbun li c'usi ta xcale xchi'uc ti c'u x'elan chitac'ove. ");
INSERT INTO tzotze_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ja' smantal Jtot ti chacuxiic sbatel osile. Li c'usi ta xcale ja' sc'op li Jtote. Ja' no'ox ta xcal li c'usi yalojbune ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","C'alal ta xa xlic li q'uin coltaele, sna'oj ono'ox Jesús ti ja' xa sc'ac'alil ta scomtsan li banamile yu'un ta xa sut batel ta stojol li Jtotic Diose. Li Jesuse lec ono'ox sc'anojuncutic, vu'uncutic li yajchanc'opuncutique. Pero más to laj yac'bun quilcutic ti ep chisc'anuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tey jtsoboj jbacutic yu'un ta xive' jcotolcutic xchi'uc li Jesuse. Li Judase, ja' li xnich'on Simón Iscariotee, albil xa ono'ox ta yo'nton yu'un banquilal pucuj ti ja' ta xac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Li Jesuse sna'oj ti ja' ac'bil sventain scotol yu'un li Jtotic Diose. Sna'oj ti ja' itacat tal yu'un li Jtotic Diose, sna'oj noxtoc ti ta x'ic'at sutel ta stojole. ");
INSERT INTO tzotze_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ac'o me ta stojol Dios liquem tal li Jesuse, pero la sbic'tajes sba, co'ol xchi'uc mozo ic'ot. Iva'i, la sloc' xaquita xchi'uc sc'u', la smac xch'ut ta poc'. ");
INSERT INTO tzotze_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","La sq'ueb vo' ta pocobc'obal, lic spocbun cacancutic, vu'uncutic li yajchanc'opuncutique. C'alal la spocbuncutique, la scusbuncutic ta poc' ti smacoj o xch'ute. ");
INSERT INTO tzotze_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","C'alal ta xa spocbe yacan li Simón Pedroe, li Pedroe jech laj yalbe li Jesuse: ―Cajval, mu smeloluc chca'i ti vo'ot chapocbun cacane ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Itac'ov li Jesuse: ―Li c'usi ta jpase muc ta orauc chava'ibe smelol. Ts'acal to chava'ibe smelol ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Li Pedroe jech laj yal: ―Li vu'une mu xcac' apocbun o li cacane ―xut. Itac'ov li Jesuse: ―Me mu'yuc ta jpocote, mu xu' chbat achi'inun ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Itac'ov li Simón Pedroe: ―Cajval, mu me ja'uc no'ox xapocbun li cacane. Pocbun c'alal ta jc'ob, tsebiltasun noxtoc ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Li Jesuse jech laj yalbe: ―Li boch'o atinem xa ono'oxe mu xa persauc chich' poquel scotlijil. Xu' ja' xa no'ox ta xpocbat li yacane yu'un atinem xa ono'ox. Li vo'oxuque pocbil xa li avo'ntonique pero mu acotolicuc ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sna'oj ono'ox Jesús ti ja' ta x'ac'van ta c'abal li Judase. Ja' ta sventa ti laj yalbuncutic ti mu jcotolcuticuc pocbil co'ntoncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","C'alal la spocbun cacan jcotolcutique, la slap yan velta li sc'u'e xchi'uc li xaquitae. Ichoti yan velta ta mesa. Jech la sjac'buncutic: ―¿Me xana'ic c'u yu'un ti la jpocboxuc avacanique? ");
INSERT INTO tzotze_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Li vo'oxuque jech chavalbicun: “Jchanubtasvanej, Cajval”, xavuticun. Lec ti jech chavalbicune yu'un melel ti vu'un Avajvalicune. ");
INSERT INTO tzotze_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ac'o me vu'un Avajvalicun, ac'o me vu'un Jchanubtasvanejun avu'unic, pero la jpocboxuc avacanic. Ja'uc me jechoxuc ec li vo'oxuque, biq'uit me xavac' abaic, tunanic yu'un li avermanoique. ");
INSERT INTO tzotze_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yu'un ti jech laj cac'boxuc avilique, yu'un ta jc'an jech chapasic ec. ");
INSERT INTO tzotze_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Melel li c'usi chacalboxuque, li boch'o mozo no'oxe mu'yuc tsots yabtel yich'oj. Ja' tsots yabtel yich'oj li yajvale. Li boch'o ja' no'ox ta spasat ta mantale mu'yuc tsots yabtel yich'oj. Ja' tsots yabtel yich'oj li boch'o ta spasvan ta mantale. ");
INSERT INTO tzotze_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Laj xa ava'yic. Me jech chapasilanique, xcuxet no'ox avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Muc acotolicuc ti jech ta xcalboxuque. Xacotquinoxuc, vo'oxuc ti t'ujbiloxuc cu'un ta sventa chacholbicun jc'ope. Oy jun li' achi'uquic ja' no'ox la jt'uj ta sventa ac'o c'otuc ta pasel li jc'oplal ts'ibabil ono'ox comel ta sc'op Diose: “Li boch'o co'ol ta xive' jchi'uque ja' ta xiscontrainun”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yu'un ti jech ba'yuc chacalboxuque, yu'un ac'o ana'ic ti c'alal ta xc'ot ta pasel jech chac c'u cha'al laj calboxuque, jech chach'unic o ti vu'un Jcoltavanejun avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Melel li c'usi chacalboxuque, li boch'otic ta xich'oxuc ta muc', vo'oxuc ti ta jtacoxuc batele, ja' vu'un chiyich'un o ta muc'. Me chiyich'icun ta muq'ue, ja' ta xich'ic o ta muc' li Jtot ti la stacun tale ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","C'alal laj yalbuncutic jech li Jesuse, vocol ivu' yu'un ti jamal laj yalbuncutic li boch'o ta x'ac'van ta c'abale yu'un ep ta xat yo'nton. Jech laj yalbuncutic: ―Melel li c'usi chacalboxuque, oy jun li' jchi'uctic ja' chiyac'un ta c'abal ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Vu'uncutic li yajchanc'opuncutique la jq'uelbe jba jsatcutic. Muc jna'cutic boch'o junucal cu'uncutic ti jech sc'oplale. ");
INSERT INTO tzotze_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Vu'un ti lec c'anbilun yu'un Jesuse tey ts'e'elun ta sts'el tey ta mesa. ");
INSERT INTO tzotze_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Li Simón Pedroe laj yac'bun quil ta sc'ob ti ac'o jac'be Jesús boch'o junucal ti jech sc'oplale. ");
INSERT INTO tzotze_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yu'un tey nopol oyun ta sts'el li Jesuse, jech la jac'be: ―Cajval, ¿boch'o junucal cu'uncutic? ―xcut. ");
INSERT INTO tzotze_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Itac'ov li Jesuse: ―Ja' li boch'o ta xcac'be ts'ajbil pan sve'e ―xiyutun. Jech lic sts'aj juteb li pane, ja' laj yac'be li Judase, ja' xnich'on li Simón Iscariotee. ");
INSERT INTO tzotze_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","C'alal la stsac pan li Judase, ta ora iventainbat o yo'nton yu'un li banquilal pucuje, ja' li Satanase. Li Jesuse jech laj yalbe li Judase: ―Li c'usi anopoj chapase bat me paso ta ora ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ti jayib tey oyuncutic ta mesae, me junuc mu'yuc boch'o la sna' cu'uncutic c'u yu'un ti jech laj yalbee. ");
INSERT INTO tzotze_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yu'un ja' xchabioj yavil jtaq'uincutic li Judase, la jnopcutic me yu'un albil xa ono'ox yu'un Jesús ti chbat sman tal c'usi ta xtun cu'uncutic ta sventa q'uine. Oy la jnopcutic me yu'un albil xa yu'un Jesús ti oy c'usi ac'o bat yac'be li me'onetique. ");
INSERT INTO tzotze_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","C'alal la sve' pan li Judase, ta ora iloc' batel. Ic' xa'ox osil. ");
INSERT INTO tzotze_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","C'alal loq'uem xa'ox batel li Judase, jech lic yalbuncutic li Jesuse: ―Li' ta orae sta xa yorail chi'ich'at ta muc', vu'un ti co'ol cristianoutique. Jech ta x'ich'at ta muc' ta jventa ec li Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Me i'ich'at ta muc' ta jventa li Diose, ja' no'ox jech ta ora chlic ich'atcun ta muc' ta sventa ec. ");
INSERT INTO tzotze_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jnich'nabtac, mu xa epuc c'ac'al li' ta jchi'inoxuc. Ta xasa'icun. Jech chac c'u cha'al laj calbe li jchi'iltactique, ja' no'ox jech ta xcalboxuc ec li vo'oxuque. yo' bu chibate mu to xu' chachi'inicun batel ta ora. ");
INSERT INTO tzotze_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ta xcalboxuc ach' mantal, c'anano me abaic. Ja' jech chac c'u cha'al la jc'anoxuc li vu'une, ja'uc me jechoxuc ec li vo'oxuque, c'anano me abaic acotolic. ");
INSERT INTO tzotze_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yu'un me chac'anan abaique, jech ta sna'ic o scotol cristianoetic ti vo'oxuc cajchanc'opoxuque ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Li Simón Pedroe jech la sjac'be li Jesuse: ―Cajval, ¿bu chabat? ―xut. Itac'ov li Jesuse: ―Ti bu chibate mu to xu' chachi'inun batel ta ora. Ts'acal to xu' chabat ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Li Pedroe jech la sjac'be: ―Cajval, ¿c'u yu'un ti mu to xu' ta jchi'inot batel ta orae? Xu' chimilat ta aventa ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Itac'ov li Jesuse: ―Mu to xu' avu'un ti chavac' aba ta milel ta jventae. Melel li c'usi chacalbote, tana c'alal mu'yuc to'ox ta x'oc' cotse, oxib xa'ox velta avaloj ti mu xavotquinune ―x'utat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Li Jesuse jech laj yalbuncutic, vu'uncutic li yajchanc'opuncutique: ―Mu me xlo'ilaj avo'ntonic. Ch'unic me ti chascoltaoxuc li Jtote. Jech ch'unic me ti chajcoltaoxuc eq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lec muc' sna li Jtote, ep ta c'ol. Ja' tey chac'otic. Ti manchuc lec muq'ue, mu jechuc ta xcalboxuc ti jechuque. Jech ba'yuc chbat jchapan ti bu chac'otique. ");
INSERT INTO tzotze_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ts'acal to ta xital yan velta, ta xtal quic'oxuc muyel. Tey chachi'inicun o. ");
INSERT INTO tzotze_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Xana'ic xa ti bu chibate, xana'ic xa ti xu' chabatic tey ec li vo'oxuque ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Li Tomase jech laj yal: ―Cajval, mu jna'cutic bu chabat. Jech mu jna'cutic c'uxi chibatcutic ec ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Li Jesuse jech laj yal: ―Vu'un ta jventa xu' chac'otic ta stojol li Jtote. Li vu'une xcotquin li Jtote, melel ti c'u x'elan laj calboxuc sc'oplale. Boch'otic ta xch'un ti vu'un Jcoltavanejun yu'unique ja' ta xcuxiic sbatel osil ta jventa. Yan li boch'otic mu xch'unique mu xu' ta xotquinic li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Li vo'oxuque muc xavotquinicun ta melel, jech mu xavotquinic ec li Jtote. Pero chlic xa avotquinic li Jtote, chlic xa avilic batel ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Li Felipee jech laj yal ec: ―Cajval, ac'bun quilcutic li Jtotic Diose jech xcuxet no'ox co'ntoncutic chicomcutic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Li Jesuse jech laj yalbe: ―Ep xa c'ac'al li' la jchi'inoxuc. ¿Me mu to xavotquinun? Felipe. Li boch'otic laj xa yilicune laj xa yilic o li Jtotic Diose. ¿C'u yu'un jech chavalbun: “Ac'bun quilcutic li Jtotic Diose”, xavutun? ");
INSERT INTO tzotze_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Me mu'yuc to ach'unoj ti jununcutic no'ox jchi'uc li Jtote? Li c'usi ta xcalboxuc ava'yique mu jc'opuc jtuc. Ja' sc'op li Jtote yu'un ta sventa c'usitic ta jpas chvinaj ti jununcutic jchi'uc li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ch'unic ti jununcutic no'ox jchi'uc li Jtote. Me mu xc'ot ta avo'ntonic li c'usi laj cal li'i, ch'unic me ta sventa li c'usitic la jpase. ");
INSERT INTO tzotze_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Melel li c'usi chacalboxuque, me chach'unic ti vu'un ta jcoltaoxuque, xu' chapasic sq'uelubil stsatsal Dios jech chac c'u cha'al ta jpase. Xchi'uc más to ep chlic yich'icun o ta muc' cristianoetic ta aventaic ti c'alal tey xa oyun yo' bu oy li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","C'usiuc no'ox chac'anbeic li Diose vu'un ta xcac'boxuc scotol me ja' chac'anic jech chac c'u cha'al ta jc'ane. Jech lec ta xbat sc'oplal Jtot ta sventa ti chajcoltaoxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yu'un me ja' chac'anic jech chac c'u cha'al ta jc'ane, jech ta xcac'boxuc li c'usitic chac'anbicune. ");
INSERT INTO tzotze_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Me scotol avo'ntonic chac'anicune, chach'unbicun scotol li jmantale. ");
INSERT INTO tzotze_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ta jc'anbe Jtot ti ac'o yac'boxuc tal li Ch'ul Espíritue yu'un ja' ta xtal scoltaoxuc. Ja' ta xchi'inoxuc sbatel osil. Ja' sventainoj ec li c'op ti ja' melele. Li cristianoetique mu xu' ta xich'ic li Ch'ul Espíritue yu'un mu xch'unic ti oy li Ch'ul Espíritue. Mu'yuc ta sna'ic c'u x'elan ta x'abtej. Yan li vo'oxuque chlic ana'ic c'u x'elan ch‑abtej yu'un chtal xchi'inoxuc. J'ech'el ch‑och ta avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mu j'ech'eluc ta jcomtsanoxuc. Ta to xtal jchi'inoxuc. ");
INSERT INTO tzotze_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Li cristianoetique mu xa epuc c'ac'al li' ta xilicun. Me la sta sc'ac'alil chichame, mu'yuc xa ta xilicun yan velta. Yan li vo'oxuque ta to xavililanicun. Ta sventa ti cuxulun sbatel osile, jech chacuxiic sbatel osil ta jventa ec. ");
INSERT INTO tzotze_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","C'alal me i'och ta avo'ntonic li Ch'ul Espíritue, jech chach'unic o ti jununcutic no'ox jchi'uc li Jtote, xchi'uc ti oyoxuc ta jtojole, xchi'uc ti jun c'otemutique. ");
INSERT INTO tzotze_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Li boch'otic ta xch'unic li jmantaltac laj ya'yique, le'e ja' scotol yo'nton sc'anojicun. Li boch'o scotol yo'nton sc'anojicune lec ta xc'anatic yu'un li Jtote. Jech scotol co'nton jc'anoj ec, xchi'uc más chcac'be sna'ic c'u x'elan co'nton ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jech ijac'bat yu'un Judas, pero mu ja'uc li Judas Iscariotee, ja' li yan Judase: ―Cajval, ¿c'u yu'un ti vu'uncutic no'ox chavac'bun jna'cutic c'u x'elan avo'ntone? ¿C'u yu'un mu xavac'be sna'ic ec li cristianoetique? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Itac'ov li Jesuse: ―Li boch'o scotol yo'nton sc'anojune ta xch'un li c'usi ta xcalbee. Jech lec ta xc'anat o yu'un li Jtote. Ta xtal jchi'incutic o. ");
INSERT INTO tzotze_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yan li boch'o mu xisc'anune mu xch'un noxtoc li c'usi ta xcalbee. Pero muc vu'cun jc'op ti li' ta xcalboxuque. Ja' sc'op li Jtot ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ja' jech ta xcalboxuc yu'un yo' to li' jchi'inojoxuc. ");
INSERT INTO tzotze_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","C'alal me libate, ta stacboxuc yalel tal Ch'ul Espíritu li Jtote, ja' ta xtal scoltaoxuc. Scotol ta xchanubtasoxuc. Ta svulesboxuc ta ajolic scotol li c'usi laj calboxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ta jpasboxuc comel ta jun avo'ntonic. Li c'usitic oy li' ta banamile mu spas o ta jun avo'ntonic yu'un. Li vu'une ta jpasboxuc o ta jun avo'ntonic jech chac c'u cha'al jun co'nton o li vu'une. Mu me xavat avo'ntonic ti chibate. Mu me xaxi'ic. ");
INSERT INTO tzotze_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Laj xa calboxuc ava'yic ti ta xibate. Laj xa calboxuc noxtoc ti ta to xtal jchi'inoxuque. Ti scotoluc avo'nton ac'anojicune, xcuxet no'ox avo'ntonic ti chisut batel ta stojol Jtot ti jechuque. Yu'un ja' más tsots yabtel li Jtote. Vu'un ti li' oyun ta banamile mu'yuc tsots cabtel quich'oj. ");
INSERT INTO tzotze_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jech ta xcalboxuc yu'un yo' to mu'yuc chibat yu'un jech mu xchibaj avo'ntonic ta jtojol c'alal me libate. ");
INSERT INTO tzotze_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mu xa xu' ti jal ta jc'opanoxuque. Yu'un jliquel xa sc'an xtal staun li pucuje, ja' ti sventainoj scotol li' ta banamile. Pero mu'yuc c'usi xu' yu'un chispasbun. ");
INSERT INTO tzotze_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yu'un ja' no'ox ta jch'un c'usi yalojbun li Jtote. Jech ta sna'ic o scotol cristianoetic ti lec jc'anoj li Jtote. Licanic, batic ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Li Jesuse jech to laj yalbuncutic, vu'uncutic li yajchanc'opuncutique: ―Ti c'u x'elan xu' avu'un chatunic cu'une, ja' tsc'an ja' jechoxuc jech chac c'u cha'al sc'obc'obtac ts'usub ti stsacoj sbaic xchi'uc smuc'ta aq'uile. Yu'un li vu'une ja' jechun jech chac c'u cha'al smuc'ta aq'uil ts'usub. Li Jtote ja' jech chac c'u cha'al jchabits'usub. ");
INSERT INTO tzotze_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Li boch'otic ta xtalic ta jtojole ja' jechic jech chac c'u cha'al sc'obc'obtac ts'usub. Li boch'o ta xtal ta jtojole, me mu ja'uc ta spas c'usi ta sc'an li Jtote, ja' jech chac c'u cha'al sc'ob ts'usub ti mu xac' sate. Ti bu mu xac' sat li sc'ob ts'usube ta se'p loq'uel li jchabits'usube. Ja' no'ox jech ec li boch'otic mu sc'an spasic c'usi tsc'an Jtote mu xc'anatic yu'un li Jtote. Yan li boch'o ta xtal ta jtojole, me ja' ta spas c'usi ta sc'an li Jtote, ta xlecubtasat yu'un Jtot jech chac c'u cha'al ta slecubtasbe sc'ob ts'usub li jchabits'usube. Li jchabits'usube ta sjos loq'uel ti bu chopol ta xile yu'un ta sc'an ac'o satinuc lec. ");
INSERT INTO tzotze_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Li vo'oxuque lecubtasbiloxuc xa yu'un laj xa avich'ic ta muc' li jc'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Li' me oyanic o ta jtojol jech chajcoltaoxuc. Na'ic me, ti manchuc stsacoj sbaic xchi'uc smuc'ta aq'uil li sc'ob ts'usube, mu satin ti jechuque. Ja' jechoxuc ec li vo'oxuque, mu xu' avu'unic chapasic c'usi lec me mu li'uc oyoxuc ta jtojole. ");
INSERT INTO tzotze_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Li vu'une ja' jechun jech chac c'u cha'al smuc'ta aq'uil ts'usub. Li vo'oxuque ja' jechoxuc jech chac c'u cha'al sc'obc'obtac ts'usub. Me li' oyoxuc o ta jtojole, jech chajcoltaoxuc, jech xu' avu'un chapasic c'usi tsc'an li Jtote. Me mu'yuc ta jcoltaoxuque, mu'yuc c'usi xu' avu'un chapas atuquic. ");
INSERT INTO tzotze_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Li boch'o mu sc'an li' oy o ta jtojole, ja' jech chac c'u cha'al sc'ob ts'usub ti mu xac' sate, ta xich' sebel loq'uel. Li sc'ob ts'usub ti isebat loq'uele ta xtaquij o. Ts'acal ta xlic yich' tsobel, ta xich' chiq'uel ta c'oc'. ");
INSERT INTO tzotze_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Me li' oyoxuc o ta jtojole, me tey oy o ta avo'ntonic li c'usitic laj calboxuque, xu' chac'anbeic Dios scotol li c'usi chac'anique jech chayac'boxuc. ");
INSERT INTO tzotze_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Me ja' chapasilanic li c'usi leque, jech ta x'ich'at ta muc' avu'unic li Jtote. Jech chvinaj ti laj ach'unic jech chac c'u cha'al la jchanubtasoxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Lec jc'anojoxuc jech chac c'u cha'al lec sc'anojun li Jtote. Li' oyanic o ta jtojol yu'un lec jc'anojoxuc. ");
INSERT INTO tzotze_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Me chach'unbicun scotol li c'usi ta xcalboxuque, j'ech'el chana'ic o ti lec jc'anojoxuque, jech chac c'u cha'al ta jna' ti lec sc'anojun li Jtote yu'un ta jch'unbe scotol li c'usi chiyalbune. ");
INSERT INTO tzotze_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ti laj calboxuc tsc'an li' oyoxuc ta jtojole xchi'uc ti chapasic c'usi laj calboxuque, yu'un jech xcuxet no'ox avo'ntonic jech chac c'u cha'al xcuxet co'ntone. Jech xcuxet no'ox avo'ntonic scotol c'ac'al, mu'yuc xa c'usi yan chac'anic o. ");
INSERT INTO tzotze_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jech jmantal ta xcalboxuc. C'anano me abaic jech chac c'u cha'al lec jc'anojoxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Boch'o ta xcham ta scoj ti tspoj li boch'o lec sc'opan sbaic xchi'uque, ja' ep ta xc'anvan o. Ja' jech lec jc'anojoxuc li vu'une. Ja' tsc'an ti ac'o jechuc avo'ntonic ec li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Li vo'oxuque co'ol co'ntontic me ja' chapasic scotol li c'usitic chacalboxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Li vo'oxuque muc xa jmozoucoxuc chca'i. Co'ol xa co'ntontic yu'un laj xa cac'boxuc ana'ic scotol li c'usitic ca'yoj tal ta stojol Jtote. Li boch'o mozoil no'oxe mu'yuc ta x'albat c'usitic ta snop li yajvale. Yan li vu'une laj xa calboxuc ava'yic scotol. ");
INSERT INTO tzotze_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Li vo'oxuque muc xat'ujicun. Vu'un la jt'ujoxuc. Laj cac'boxuc avabtelic yu'un chbat apasic c'usi tsc'an li Diose. Mu alticuc ti jech chapasique yu'un ja' sventa sbatel osil. Jech scotol c'usiuc chac'anbeic li Jtote ta xac'boxuc me ja' chac'anic jech chac c'u cha'al ta jc'ane. ");
INSERT INTO tzotze_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jech jmantal chacalboxuc: C'anano me abaic acotolic. ");
INSERT INTO tzotze_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Me chopol chayiloxuc li cristianoetique, mu me xchibaj avo'ntonic. Na'ic me ti jech ono'ox chopol laj yilicune. ");
INSERT INTO tzotze_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ti co'oluc to chapasic achi'uquic li cristianoetique, lec ta sc'anoxuc ti jechuque. Li vo'oxuque mu xa co'oluc chapasic achi'uquic yu'un laj xa quic'oxuc ta jtojol. Jech chopol chayiloxuc li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na'ic me ti jech ono'ox calojboxuque: “Li boch'o mozo no'oxe mu'yuc tsots yabtel yich'oj. Ja' tsots yabtel yich'oj li yajvale”, xacutoxuc ono'ox. Laj yuts'intaicun li vu'une, ja' no'ox jech ta xuts'intaoxuc ec. Muc xiyich'bicun ta muc' li jc'ope, ja' no'ox jech mu xayich'boxuc ta muc' ec li ac'opique. ");
INSERT INTO tzotze_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Scotol li c'usi ta spasboxuque vu'un ta jcoj, yu'un mu xotquinic li Jtot ti la stacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ti manchuc tal jc'opanique, muc xvinaj me chopol yo'ntonic ti jechuque. Li' ta orae mu xa xu' ta xalic ti lec yo'ntonique yu'un chopol chiyilicun. ");
INSERT INTO tzotze_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Li boch'o chopol chiyilune chopol ta xilic ec li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ti manchuc laj cac'be yilic sq'uelubil jtsatsal ti mu'yuc boch'o yan xu' yu'un jech tspase, muc xvinaj me chopol yo'ntonic ti jechuque. Li' ta orae mu xa xu' ta xalic ti lec yo'ntonique yu'un chopol laj yilic li c'usitic la jpascutic jchi'uc Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ti jech chopol chiyilicune, yu'un ja' ta xc'ot o ti jech ono'ox ts'ibabil comel jc'oplal ta sc'op Dios tey yich'ojique: “Altic ti chopol chiyilicune, mu'yuc jmul”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’C'alal me ital li Ch'ul Espíritu ti ta jtacboxuc yalel tal sventa ta scoltaoxuque, ja' jc'oplal chac' ta na'el. Melel li c'usi ta xalboxuque yu'un ja' tey ta xlic tal ta stojol li Jtote. ");
INSERT INTO tzotze_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Li vo'oxuque chacholbicun jc'oplal ec yu'un laj achi'inicun ti c'alal lic jtsac cabtele, xchi'uc c'alal to tana. ");
INSERT INTO tzotze_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Laj xa calboxuc ava'yic ti chopol chayiloxuc li cristianoetique yu'un jech mu xchibaj avo'ntonic ti c'alal mu'yuc xa li' oyune. ");
INSERT INTO tzotze_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yu'un ta to sloq'uesoxuc ta nail tsobobbail li jchi'iltactic ta israelale. Ta to sta sc'ac'alil ti oy ta smiloxuque yu'un tsnopic ti ja' yabtel Dios tspasique. ");
INSERT INTO tzotze_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ti jech ta spasboxuque, yu'un mu xotquinic li Jtotic Diose. Jech mu xiyotquinicun ec. ");
INSERT INTO tzotze_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Laj xa calboxuc ava'yic ti chopol chayiloxuque. C'alal ta xc'ot ta pasel jeche, tey ta xvul ta ajolic ti jech ono'ox laj calboxuc comele. C'alal laj quic'oxuc ta jtojole, mu'yuc jech laj calboxuc yu'un li' to jchi'inojoxuc. ");
INSERT INTO tzotze_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Li' ta orae ta xa xisut batel ta stojol li Jtot ti la stacun tale. Li vo'oxuque me junuc mu'yuc boch'o la sjac'bun lec avu'unic ti bu chibate. ");
INSERT INTO tzotze_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ja' no'ox puro at‑o'nton batem ta avo'ntonic ti c'alal jech laj calboxuc ava'yique. ");
INSERT INTO tzotze_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Melel li c'usi chacalboxuque, ja' sventa alequilalic ti ta xisut batel ta vinajele. Yu'un me mu'yuc ta xisut batele, mu'yuc ta xtal scoltaoxuc li Ch'ul Espíritue. Yu'un ti chisut batele, yu'un ja' ta jtacboxuc tal li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","C'alal me itale, ja' yabtel ta xac'be sna'ic cristianoetic ti oy smulique, xchi'uc ti mu'yuc jmul li vu'une, xchi'uc ti ch‑ac'batic castigo yu'un smulique. ");
INSERT INTO tzotze_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Li smul ch‑ac'bat sna'ique ja' ti mu xch'unic ti vu'un Jcoltavanejun yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta xac'be sna'ic ti tuc' co'ntone yu'un laj xa yic'un muyel ta stojol li Jtote. Yu'un mu'yuc xa bu chavilicun o li' ta banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta xac'be sna'ic ti ch‑ac'batic castigo yu'un smulique yu'un chapal xa sc'oplal ti ta xich' castigo sbatel osil li boch'o banquilal yu'unique, ja' li banquilal pucuje, ja' ti tey mozoinbilic o yu'une. ");
INSERT INTO tzotze_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ac'o me oy to ep c'usi ta jc'an ta xcalboxuc pero ta yan to velta cha'ac'bat ava'yic yu'un mu xava'ibeic smelol scotol ta ora. ");
INSERT INTO tzotze_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","C'alal ta xtal li Ch'ul Espíritue, melel scotol ec li c'usi ta xale, ja' ta xac'boxuc ana'ic scotol li c'usi melele. Mu ja'uc sc'op stuc ta xal. Ja' ta xal scotol li c'usitic ta x'albat yu'un Jtote. Ja' ta xac'boxuc ana'ic scotol li c'usitic ta to xc'ot ta pasele. ");
INSERT INTO tzotze_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta xac'un ta ich'el ta muc' yu'un ja' yabtel o ta svulesboxuc ta ajolic scotol li c'usi la jpase xchi'uc li c'usi laj cale. ");
INSERT INTO tzotze_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ti jech laj cale mu jtucuc chiyac'un ta ich'el ta muc'. Yu'un jununcutic jchi'uc li Jtote jech co'ol chiyac'uncutic ta ich'el ta muc'. ");
INSERT INTO tzotze_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mu xa epuc c'ac'al li' chavilicun. Oy jun chib c'ac'al ti mu'yuc chavilicune. Ts'acal to chavilicun yan velta. Ts'acal to ta xisut batel yo' bu oy li Jtote ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oy chib oxibuncutic, vu'uncutic li yajchanc'opuncutique, jech la jac'be jbacutic: ―¿C'usi smelol ti jech laj yalbutique: “Mu xa epuc c'ac'al li' chavilicun. Oy jun chib c'ac'al ti mu'yuc chavilicune. Ts'acal to chavilicun yan velta. Ts'acal to ta xisut batel yo' bu oy li Jtote”, ti xijyututique? ");
INSERT INTO tzotze_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿C'usi smelol ti “mu xa epuc c'ac'al” xie? Mu xca'ibetic smelol li c'usi ta xale ―xcut jbacutic. ");
INSERT INTO tzotze_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Li Jesuse la sna' ti ta jc'an ta jac'becutic c'usi smelole, jech laj yalbuncutic: ―Ta jna' ti chajac'be abaic ta sventa ti jech laj cale: “Mu xa epuc c'ac'al li' chavilicun. Oy jun chib c'ac'al ti mu'yuc chavilicune. Ts'acal to chavilicun yan velta”, ti xacutoxuque. ");
INSERT INTO tzotze_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Melel li c'usi chacalboxuque, li vo'oxuque ta to xa'oq'uic, ta to xavat avo'ntonic. Yan li boch'otic mu xiyich'icun ta muq'ue xcuxet no'ox yo'ntonic. Pero li vo'oxuque jun chib no'ox c'ac'al ti chavat avo'ntonique. Ta ts'acal xcuxet no'ox avo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ana'ojic c'u x'elan ti c'alal ta xcux jun antse, oy svocol. Pero c'alal me ivoc' li yole, ta xch'ay ta yo'nton ti ep c'ux laj ya'ye. Xcuxet no'ox yo'nton ta ts'acal yu'un oy xa yol. ");
INSERT INTO tzotze_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ja' no'ox jechoxuc ec li vo'oxuque, li' ta orae chavat avo'ntonic, pero c'alal chavilicun yan veltae, xcuxet no'ox avo'ntonic. Mu'yuc boch'o xu' ta xch'ayboxuc li xcuxetel avo'ntonique. ");
INSERT INTO tzotze_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’C'alal chavilicun yan velta jech chac c'u cha'al laj calboxuque, mu'yuc xa c'usi chajac'bicun yu'un ic'ot xa ta pasel li c'usitic laj calboxuque. Melel li c'usi chacalboxuque, scotol li c'usi chac'anbeic Jtotic Diose chayac'boxuc me ja' chac'anic jech chac c'u cha'al ta jc'ane. ");
INSERT INTO tzotze_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tana mu'yuc to ac'anojbeic Jtotic Dios jech chac c'u cha'al ta jc'ane. C'anbeic, jech ta xac'boxuc. Jech xcuxet no'ox avo'ntonic scotol c'ac'al, mu'yuc xa c'usi yan chac'anic o. ");
INSERT INTO tzotze_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Scotol li c'usitic laj calboxuque oy ja' no'ox la jloc'ta ta lo'il. Pero ta to sta yorail ti jamal ta xcalboxuc ava'yic sc'oplal li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","C'alal me la sta yorail ti jamal chava'ibeic sc'oplal li Jtotic Diose, xu' atuquic xa no'ox chac'anbeic li c'usi chac'anique yu'un chana'ic ti jech ta jc'ane. Mu xa persauc vu'un ta jc'anboxuc ta stojol li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yu'un lec sc'anojoxuc li Jtotic Diose. Yu'un ti lec sc'anojoxuque, yu'un lec ac'anojicun ec, xchi'uc laj xa ach'unic ti tey liquemun tal ta stojol li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Melel ti tey lilic tal ta stojol Jtotic Dios ti c'alal lital li' ta banamile. Li' ta orae ta xa jcomtsan li banamile, ta xa xisut batel yo' bu oy li Jtotic Diose ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Vu'uncutic li yajchanc'opuncutique jech laj calbecutic: ―Li' ta orae jamal xa laj avalbuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Laj xa jna'cutic ti xana' scotole. Yu'un laj ana' ti oy c'usi ta jc'an ta jac'cutic ti c'alal mu'yuc to'ox chajac'becutique. Jech laj xa jch'uncutic o ti tey liquemot tal yo' bu oy li Diose ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Itac'ov li Jesuse: ―Lec ti laj ach'unique pero oy to c'usi yan sc'an avu'unic. ");
INSERT INTO tzotze_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yu'un ta jliquel xa chacomtsanicun. Ta xavoq'uilan abaic batel. Pero mu'yuc comtsanbilun, li' xchi'inojun li Jtotic Diose. ");
INSERT INTO tzotze_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ti c'u yepal laj calboxuque, ja' sventa ac'o cuxetuc o avo'ntonic ta jventa ti c'alal chavich'ic vocol li' ta banamile. Yu'un tsalbil xa cu'un scotol li c'usitic oy li' ta banamile, jech vu'un ta jventa ta stsal avu'unic ec ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","C'alal laj yal jech li Jesuse, la sq'uel muyel vinajel, la sc'opan Dios. Jech laj yal: ―Tat, laj xa sta sc'ac'alil chicham jech chac c'u cha'al avaloj ono'oxe. Jech ac'un ta ich'el ta muc', vu'un li Anich'onune, jech cha'ich'at ta muc' ta jventa ec. ");
INSERT INTO tzotze_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yu'un laj xa avac'bun jventain scotol cristianoetic ta sbejel banamil yu'un jech xu' ta xcac' cuxiicuc sbatel osil ti c'u yepal t'ujbil avu'un chiyich'icun ta muq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ti jech ta xcuxiic sbatel osile, yu'un xayotquinicot, vo'ot ti cuxul Diosote, xchi'uc xiyotquinicun ec, vu'un ti Jcoltavanejun yu'unic laj atacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Laj xa cac'ot ta ich'el ta muc' ta stojol li cristianoetique. Vu'ubal xa cu'un li cabtel laj avac'bun jpase. ");
INSERT INTO tzotze_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tati, li' ta orae ac'un xa ta ich'el ta muc' tey ta atojol jech chac c'u cha'al ich'bilun ono'ox ta muc' tey ta atojol ti c'alal mu'yuc to'ox pasbil li banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Laj xa cac'ot ta otquinel ta stojol li viniquetic li'i, ja' ti laj avac' yich'icun ta muq'ue. Ba'yuc ono'ox t'ujbilic avu'un ti chiyich'icun ta muq'ue, jech laj xa xch'unic li ac'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Laj xa sna'ic ti vo'ot ta aventa la jpas scotol li c'usitic la jpase xchi'uc li c'usitic laj cale. ");
INSERT INTO tzotze_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Laj xa calbe ya'yic li ac'ope. Laj xa sna'ic ti ta melel tey liquemun tal ta atojole. Laj xa xch'unic ti vo'ot laj atacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ta jc'opanot ta stojolic. Mu ja'uc ta jc'opanot ta stojol scotol cristianoetic. Ja' ta jc'opanot ta stojol li boch'otic laj avac' yich'icun ta muq'ue yu'un jech chcolic sbatel osil ta jventa. Yu'un ja' avu'un. ");
INSERT INTO tzotze_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Scotol li boch'otic chcolic ta jventae ja' cu'un, jech ja' avu'un ec. Ja' co'ol cu'untic. Ja' ta sventaic ti chi'ich'at ta muq'ue. ");
INSERT INTO tzotze_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Stuquic xa ta xcomic li' ta banamile yu'un ta xa xisut tal tey ta atojol. Tati, mu'yuc c'usi chopol tey ta atojol, jech xu' avu'un chachabibun scotol li boch'otic laj xa avac' yich'icun ta muq'ue yu'un jech mu stsalatic yu'un li c'usitic oy li' ta banamile. Jech co'ol yo'nton scotolic jech chac c'u cha'al co'ol co'ntontique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","C'alal la jchi'inic li' ta banamil ti jayib laj avac' yich'icun ta muq'ue, vo'ot ta aventa ti muc xch'ay junuc cu'une. Lec la jchabi, li' xchi'inojicun scotolic. Ja' no'ox jun li boch'o sc'oplal ono'ox ch'ayel ta xbate, ja' mu'yuc xa li' xchi'inojun. Yu'un ja' ic'ot o li c'usi ts'ibabil ono'ox comel ta ac'ope. ");
INSERT INTO tzotze_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Tati, ta xa xital ta atojol. C'alal li' to jchi'inojic ta banamile, ta jc'opanot ta stojolic yu'un ac'o cuxetuc yo'ntonic jech chac c'u cha'al xcuxet no'ox co'ntone. ");
INSERT INTO tzotze_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Laj xa calbe ya'yic li ac'ope pero chopol ta x'ilatic yu'un li cristianoetique. Yu'un mu xa jechuc yo'ntonic jech chac c'u cha'al yo'nton li cristianoetique, jech chac c'u cha'al mu jechuc co'nton jech chac c'u cha'al yo'nton li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mu ja'uc ta jc'anbot ti ac'o avic' ta atojol ta orae. Ja' ta jc'anbot ti ac'o achabibune yu'un jech mu stsalatic yu'un li pucuje. ");
INSERT INTO tzotze_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yu'un mu xa jechuc yo'ntonic jech chac c'u cha'al yo'nton li cristianoetique, jech chac c'u cha'al mu jechuc co'nton jech chac c'u cha'al yo'nton li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ac'o yac' ta yo'ntonic li ac'ope yu'un ja' melel, yu'un jech mu co'oluc tspasic, mu co'oluc tsnopic xchi'uc li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jech chac c'u cha'al laj atacun yalel tal li' ta banamile yu'un ja' tal jcholbe ya'yic li ac'ope, ja' no'ox jech ta jtaquic batel ec yu'un ac'o bat xcholbe ya'yic ac'op li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yutsil co'nton ta jpas li c'usi ta sc'an avo'ntone, jech vu'un ta jventa yutsil yo'nton xu' tspasic ec. ");
INSERT INTO tzotze_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Mu ja'uc no'ox ta jc'opanot ta stojolic. Ta jc'opanot ta stojolic ec li boch'otic chlic yich'icun ta muc' ta sventaique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta jc'anbot ti ac'o co'oluc yo'nton scotol ti c'u yepal ta xch'unique jech chac c'u cha'al co'ol co'ntontique. Jech chac c'u cha'al junutic no'oxe, ja' no'ox jech jun ac'o oyicuc ta jtojoltic ec. Jech ta xch'unic o scotol cristianoetic ti vo'ot laj atacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Chcac'be slequil yo'ntonic jech chac c'u cha'al slequil co'nton laj avac'bune yu'un jech co'ol yo'nton chc'otic jech chac c'u cha'al co'ol co'ntontique. ");
INSERT INTO tzotze_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Li vu'une jun chic'ot jchi'uc. Li vo'ote junutic no'ox. Jech jun ta xc'ot o scotolic ta jtojoltic jech chac c'u cha'al junutic no'oxe. Jech ta sna'ic o scotol cristianoetic ti vo'ot laj atacun tale. Ta sna'ic noxtoc ti lec ac'anoj scotol li boch'otic jun c'otemun jchi'uque jech chac c'u cha'al lec ac'anojune. ");
INSERT INTO tzotze_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tati, ti c'u yepal laj avac' yich'icun ta muq'ue ta jc'an ti ac'o xchi'inicun sbatel osil tey yo' bu oyote, jech tey ta xilic o ti c'u x'elan ich'bilun ta muc' avu'une. Yu'un lec ono'ox ac'anojun ti c'alal mu'yuc to'ox banamile. ");
INSERT INTO tzotze_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tati, tuc' c'usi chapas, mu xavac' batuc ta ch'ayel li boch'o xayotquinote. Li cristianoetique mu xayotquinicot. Li vu'une xacotquinot. Ti jayib li' oyique laj xa xch'unic ti vo'ot laj atacun tale. ");
INSERT INTO tzotze_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Laj xa yotquinicot cu'un. Pero más to ta xayotquinicot cu'un, jech chlic sna'ic ti lec c'anbilic avu'un jech chac c'u cha'al lec ac'anojune. Xchi'uc chlic sna'ic ti jun c'otemun jchi'uque ―xi laj yal c'alal la sc'opan Dios li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","C'alal laj yo'nton ta sc'opanel Dios li Jesuse, iloc' batel. Tey nabal liloc'cutic batel, vu'uncutic li yajchanc'opuncutique. Tey lijelovcutic batel ta jot uc'um, Cedrón sbi. Tey lic'otcutic yo' bu ts'unbil ep oliva te'etique. Ja' tey li'ochcutic ta yolon jcotolcutic xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Li Judase, ja' li boch'o spasoj xa trato chac' ta c'abal li Jesuse, yiloj ti bu ts'unbil ep oliva te'etique yu'un tey ono'ox ta xic'otilancutic jcotolcutic xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jech li Judase laj yic' batel soldadoetic, xchi'uc laj yic' batel jayibuc jchi'ilcutic ta israelal ti ja' ta xchabiic temploe. Ja' itacatic batel yu'un li banquilal paleetique xchi'uc li fariseoetique. Li soldadoetique ja' puro roma viniquetic. C'alal ibatique, yich'anojic batel stojic, xchi'uc slamparaic, xchi'uc xmachitaic. ");
INSERT INTO tzotze_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Li Jesuse sna'oj scotol li c'usi ta spasbate. Inopaj batel, jech la sjac'be li jtsacvanejetique: ―¿Boch'o chasa'ic? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Itac'ovic: ―Ja' ta jsa'cutic li Jesús tey liquem tal ta Nazarete ―xiic. Itac'ov li Jesuse: ―Vu'un li' oyune ―xi. Tey va'al ec li Judase, ja' li boch'o spasoj xa trato chac' ta c'abal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","C'alal laj yal jech Jesús ti “vu'un li' oyun” xie, ta nacalchac xa iloq'uic li jtsacvanejetique jech tey iyalic o ta lum. ");
INSERT INTO tzotze_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Li Jesuse la sjac'be yan velta: ―¿Boch'o chasa'ic? ―xut. ―Ja' ta jsa'cutic li Jesús tey liquem tal ta Nazarete ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Itac'ov li Jesuse: ―Laj xa calboxuc ava'yic ti vu'un li' oyune. Me jtuc no'ox ti chasa'icune, mu me xatsaquic li jchi'iltac li'i, ac'o baticuc ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ti jech laj yale, yu'un ac'o c'otuc ta pasel ti jech ono'ox laj yalbe li Stote: “Ti jayib laj avac' yich'un ta muq'ue me junuc muc xch'ay cu'un”, xi ono'ox laj yal. ");
INSERT INTO tzotze_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tey yich'oj xmachita li Simón Pedroe. Jech la sloq'ues, la sbojbe jun xchiquin smozo li más banquilal palee. Ja' ta sbats'ichiquin ti iloq'ue. Malco sbi li mozoe. ");
INSERT INTO tzotze_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Li Jesuse jech laj yalbe li Pedroe: ―Tic'o ochel ta sna li amachitae. Yu'un me chapojune, mu xquich' vocol jech chac c'u cha'al ta sc'an li Jtote ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Li capitán soldado xchi'uc yajsoldadotaque, xchi'uc li jchabitemplo yu'un paleetique la stsaquic li Jesuse. La xchuquic. ");
INSERT INTO tzotze_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ja' tey ba'yuc laj yiq'uic batel ta stojol li banquilal pale to'oxe, Anás sbi. Li Anase ja' sni'anoj li Caifase. Li Caifase ja' o ochem ta más banquilal pale ti c'alal icham li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Li Caifase ja' ono'ox ti jech laj yalbe xchi'iltac ta abtele: “Ja' lec me jun no'ox vinic ta xcham cu'untique, ja' chopol me ta xijcham jcotoltique”, xut ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Li vu'un jchi'uc Simón Pedroe tey libatcutic ec ti bu i'ic'at batel li Jesuse. Li vu'une xiyotquinun li banquilal pale to'oxe, jech c'alal i'och ta yamaq'uil sna banquilal pale li Jesuse, tey li'och ec. ");
INSERT INTO tzotze_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Li Pedroe tey va'al icom ta calle ta ti'na. Li vu'une yotquinojun li banquilal palee jech tey la jc'opan li jchabiti'nae yu'un ac'o ochuc ec li Pedroe. Jech i'otesat. ");
INSERT INTO tzotze_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Li jchabiti'nae ja' tseb. Jech lic jac'batuc li Pedroe: ―¿Me mu vo'ocot yajchanc'opot li vinique? ―x'utat. Itac'ov li Pedroe: ―Mu vu'cun ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Li mozoetic tey oyique xchi'uc li boch'otic ta xchabiic temploe tey snoboj lec sc'oq'uic yu'un oy sic. Ac'al no'ox li sc'oq'uique. Jech tey va'ajtic ta xc'atinic. Tey va'al ta xc'atin ec li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Li Jesuse jech ijac'bat yu'un li banquilal pale ti loq'uem xae: ―¿Boch'otic li avajchanc'optaque? ¿C'usi c'opal ti chavac' ta chanele? ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Itac'ov li Jesuse: ―Lec ta satilal la jc'opan scotol li cristianoetique. Scotol c'ac'al lichanubtasvan ta nail tsobobbailetic xchi'uc ta yamaq'uil templo yo' bu ta stsobilan sbaic scotol li jchi'iltactique. Mu'yuc bu ta mucul lichanubtasvan. ");
INSERT INTO tzotze_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿C'u yu'un vu'un chajac'bun? Ja' jac'bo li boch'otic laj ya'yic c'usi laj calbeique. Sna'ojic li c'usi laj calbeique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","C'alal laj yal jech li Jesuse, ta ora imajat yu'un jun jchabitemplo ti tey va'ale. Jech laj yal li jchabitemploe: ―¿C'u yu'un jech chatac'be li banquilal palee? ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Itac'ov li Jesuse: ―Me yu'un chopol li c'usi laj cale, albun ca'i ti bu chopole. Me lec li c'usi laj cale, ¿c'u yu'un laj amajun? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Li Anase, ja' li banquilal pale ti loq'uem xae, chucul xa lec li Jesuse ti c'alal la stac batel ta stojol sni'e, ja' li Caifás ti ja' to no'ox i'och ta más banquilal palee. ");
INSERT INTO tzotze_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","C'alal jech ijac'bat li Jesuse, li Pedroe tey va'al ta xc'atin. Jech ijac'bat yu'un li boch'otic tey co'ol ta xc'atinic xchi'uque: ―¿Me mu vo'ocot yajchanc'opot li vinique? ―x'utat. ―Mu vu'cun ―xi itac'ov li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tey oy jun smozo li banquilal palee. Ja' yuts' yalal li boch'o ibojbat xchiquin yu'un Pedroe. Li Pedroe jech ijac'bat yu'un li mozoe: ―¿Me mu vo'ocot ti laj quilot tey achi'uc li vinic yo' bu ts'unbil ep oliva te'etique? ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Li Pedroe laj yal yan velta ti mu xotquin li Jesuse. Ja' o i'oc' cots. ");
INSERT INTO tzotze_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Laj yiq'uic loq'uel ta stojol Caifás li Jesuse, bat yaq'uic ta stojol gobernador tey ta sna. Pretorio sbi li snae. Ja' tey ta xich' chapanel li cristianoetique. Sob to ti c'alal ic'otique. Li paleetic xchi'uc xchi'iltaque muc x'ochic ta pretorio. Yu'un me tscap sbaic xchi'uc li yan lum cristianoetique, xch'unojic ti tsta smulic ta stojol Diose, jech mu xu' ta sti'ic o li ch'ium chij ta sventa q'uin coltaele. ");
INSERT INTO tzotze_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jech iloc' tal li Pilatoe, ja' li gobernadore. Jech la sjac'be li jchapanvanejetic cu'uncutique: ―¿C'usi smul li vinic li' laj aviq'uic tale? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Itac'ovic: ―Ti mu'yucuc tsots smul li vinique, muc xtal cac'cutic ta ac'ob ti jechuque ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Li Pilatoe jech laj yal: ―Iq'uic batel, bat chapano atuquic ta sventa li mantaletic avu'unique ―xut. Li jchapanvanejetique jech laj yalbeic li Pilatoe: ―Li vu'uncutique mu'yuc quich'ojcutic mantal avu'unic ti chimilvancutique. Ja' vo'ot avabtel ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yu'un ti ja' i'och ta sc'ob Pilato li Jesuse, yu'un ja' ic'ot o ti laj yal Jesús ti ta persa ta cruz ta xmilate. ");
INSERT INTO tzotze_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Li Pilatoe i'och batel yo' bu ta xchapanvane. Laj yic' li Jesuse, jech la sjac'be: ―¿Me vo'ot ajvalilot yu'un li achi'iltac ta israelale? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Itac'ov li Jesuse: ―¿Me atuc no'ox chaval ti vu'un ajvalilune, o me yu'un oy boch'o laj yalbot? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Itac'ov li Pilatoe: ―Li vu'une mu c'usi stu cu'un ta jac' jtuc yu'un muc israelucun. Ja' laj yaq'uicot ta jc'ob li achi'iltaque xchi'uc li banquilal paleetic avu'unique. ¿C'usi chopol apasoj? ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Itac'ov li Jesuse: ―Li boch'o laj yac'bun cabtel ta jpas mantale mu cristianouc. Ti cristianouc laj yac'bun cabtele, la scoltaicun li jvinictaque jech muc xi'och ta sc'ob li jchi'iltaccutique, jech muc xital li' ta atojol ec ti jechuque. Li cabtel quich'oje mu cristianouc laj yac'bun ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Li Pilatoe jech laj yalbe: ―Yu'un vo'ot ajvalilot cha'e ―xut. Itac'ov li Jesuse: ―Vu'un ajvalilun. Ti tal voc'cun li' ta banamile, yu'un tal jchol li c'op ti ja' melele. Scotol boch'otic tsc'an ta xa'yic li c'usi melele ja' ta xa'ibicun li jc'ope ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Li Pilatoe jech laj yalbe li Jesuse: ―¿C'usi ti melel acuyoje? ―xi. C'alal laj yal jech li Pilatoe, iloc' tal yan velta. Tal sc'opan yan velta li jchapanvanejetique. Jech laj yalbe: ―Mu'yuc la jtabe smul li vinique. ");
INSERT INTO tzotze_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero ta sventa atalelic o ti chac'anic loq'uesbel ta chuquel jun achi'ilic ta yorail jujun q'uin coltaele, ¿me ja' chac'anic ta jcoltaboxuc li ajvalil avu'unic, vo'oxuc li israeloxuque? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tsots i'avan scotolic: ―¡Mu me xacolta le'e! ¡Ja' coltao li Barrabase! ―xiic. Li Barrabase ja' j'elec'. ");
INSERT INTO tzotze_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","2","Li Pilatoe laj yalbe yajsoldadotac ti ac'o yac'beic nucul li Jesuse. Jech lic yac'beic. Ts'acal to la sts'otic ch'ix, la xojbeic ta sjol sventa scorona. La slapbeic natil c'u'il sventa ajvalil. Yax'elan li c'u'ile. ");
INSERT INTO tzotze_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jech lic slabanic: ―¡Toj lec muc'ta ajvalilot yu'un li achi'iltac ta israelale! ―xutic. La smajbeic sat. ");
INSERT INTO tzotze_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Iloc' tal yan velta li Pilatoe. Jech laj yalbe li jchi'iltaccutic ta israelale: ―Q'uelavilic, ta xquic' loq'uel tal li' ta atojolic yu'un jech chana'ic o ti mu'yuc la jtabe smule ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","C'alal iloc' tal li Jesuse, oy xa scoronail sjol ts'otbil ta ch'ix. Slapoj xa loq'uel tal li yax'elan c'u'ile. Li Pilatoe jech laj yalbe li jchi'iltaccutique: ―¡Q'uelavilic li vinique! ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","C'alal laj yilic Jesús li banquilal paleetique xchi'uc li boch'otic ta xchabiic temploe, tsots laj yaptaic li Pilatoe: ―¡Joc'ano ta cruz! ¡Joc'ano ta cruz! ―xutic. Itac'ov li Pilatoe: ―Iq'uic batel li vo'oxuque, bat joc'anic ta cruz. Yu'un mu'yuc la jtabe smul li vu'une ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Itac'ovic li jchi'iltaccutique: ―Li vu'uncutique ta xal ta mantal cu'uncutic ti ta persa ta xcham li boch'o Xnich'on Dios yaloje ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Li Pilatoe ta ono'ox xi' ta sventa c'usi ta spasbat li Jesuse. C'alal laj ya'i ti “Xnich'on Dios yaloj” xiique, más to tey ixi' o. ");
INSERT INTO tzotze_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","I'och batel yan velta ta yut pretorio li Pilatoe xchi'uc li Jesuse. Jech la sjac'be li Jesuse: ―¿Bu liquemot tal? ―xut. Li Jesuse muc xtac'ov yu'un sna'oj ti altic no'ox ta sjaq'uilane. ");
INSERT INTO tzotze_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Li Pilatoe jech laj yalbe li Jesuse: ―¿C'u yu'un mu xatac'bun? ¿Me yu'un mu xana' ti vu'un oy cabtele? Xu' cu'un ta xcac'ot ta joc'anel ta cruz, xu' cu'un ta jcoltaot batel ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Itac'ov li Jesuse: ―Ti manchuc jech chac' apas li Dios tey oy ta vinajele, mu'yuc c'usi xu' avu'un chapasbun ti jechuque. Li vo'ote mu'yuc tsots amul. Ja' más tsots smul li más banquilal pale ti laj yac'un ta ac'obe ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","C'alal jech laj ya'i li Pilatoe, tsc'an ta scolta li Jesuse pero li jchi'iltaccutique tsots laj yaptaic: ―Me chacolta batel li vinic li'i, yu'un mu co'oluc avo'nton achi'uc li muc'ta ajvalil Césare. Yu'un li boch'o ta scuy sba ta ajvalil stuque ja' ta scontrain li Césare ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","C'alal laj ya'i Pilato c'usi laj yalic li jchi'iltaccutique, laj yal mantal ti ac'o yiq'uic loq'uel ta amac' li Jesuse. Li amaq'ue pasbil lec ta ton. Oy pasbil lec xchotleb tey ta o'lol amac' li gobernadore. Ja' tey chbat chotluc c'alal ta xal c'u x'elan ta xcom li boch'o ta xchapanate. Ja' Gabáta sbi ta jc'opcutic. Li Pilatoe tey bat chotluc. ");
INSERT INTO tzotze_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ja' xa sc'ac'alil tsmilic li ch'ium chij sventa q'uin coltaele. Po'ot xa van o'lol c'ac'al ti c'alal tey bat chotluc li Pilatoe. Jech laj yalbe li jchi'iltaccutique: ―¡Q'uelavilic li ajvalil avu'unique! ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Li jchi'iltaccutique tsots laj yaptaic li Pilatoe: ―¡Ac'o chamuc, ac'o joc'anatuc ta cruz! ―xiic. Li Pilatoe jech la sjac'be: ―¿Me lec ti ta xcac' ta joc'anel ta cruz li ajvalil avu'unique? ―xut. Itac'ovic li banquilal paleetique: ―Mu ja'uc ajvalil cu'uncutic le'e. Jun no'ox li muc'ta ajvalil cu'uncutique, ja' li Césare ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Li Pilatoe la xch'un c'usi la sc'anic li jchi'iltaccutique. Jech laj yal mantal ti ac'o bat joc'anatuc ta cruz li Jesuse. Li soldadoetique laj yiq'uic batel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Li soldadoetique laj yac'beic xq'uech batel scruzal li Jesuse. Tey ibatic yo' bu Baquil Jolal sbie. Ja' Gólgota sbi ta jc'opcutic, vu'uncutic li israeluncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tey la sjoc'anic ta cruz li Jesuse. Xchi'uc oy yan chib vinic tey la sjoc'anic ta cruz ec. Jujun ta jujujot xocon scruzal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Li Pilatoe laj yac' ta ts'ibael jun te'. Tey la sbajic ta sjol scruzal li Jesuse. “Li'i ja' Jesús tey liquem tal ta Nazaret. Ja' muc'ta ajvalil yu'un israeletic”, xi ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Oy ep jchi'iltaccutic laj yilic ti c'u x'elan ts'ibabile yu'un tey no'ox ta ti' lum Jerusalén ijoc'anat ta cruz li Jesuse. Ts'ibabil ta jc'opcutic xchi'uc ta griego c'op xchi'uc ta latin c'op. ");
INSERT INTO tzotze_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","C'alal laj yilic banquilal paleetic c'u x'elan ts'ibabile, bat yalbeic li Pilatoe: ―¿C'u yu'un ti jech laj avac' ta ts'ibaele: “Ja' muc'ta ajvalil yu'un israeletic”, xi ts'ibabil laj quilcutic? “Li'i ja' la scuy sba ta muc'ta ajvalil yu'un israeletic”, xi laj avac' ta ts'ibael ti jechuque ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Itac'ov li Pilatoe: ―Ti c'u x'elan laj cac' ta ts'ibaele, jech ac'o comuc o ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","C'alal laj xa'ox sjoc'anic ta cruz Jesús li soldadoetique, la svoc'be sbaic li c'usitic slapoj to'oxe. Jujuchop laj yich'ic li chanibique. Ja' xa no'ox icom li sc'u'e yu'un mu'yuc sts'isbenal. Yu'un jis no'ox jalbil. ");
INSERT INTO tzotze_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Li soldadoetique jech laj yalbe sbaic: ―Mu jch'i'ilantic li jlic li'i. Ja' lec jpastic canal tajimol jq'ueltiquic boch'o junucal ta xich' cu'untic ―xiic. Ti jech la spasic li soldadoetique, yu'un ja' ic'ot o li c'usi ts'ibabil ono'ox comel ta sc'op Diose. Jech ts'ibabil: “Ta svoc'be sbaic li jc'u'e. Ta spasic canal tajimol yu'un ta sq'uelic bu jlicucal chc'ot ta stojol jujunic”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Li sme' Jesuse tey nopol va'alic ta yolon scruzal Jesús xchi'uc li smuque, ja' María sbi ec li smuque. Ja' Cléofas sbi li smalale. Tey oy noxtoc yan María liquem tal ta lum Magdala. ");
INSERT INTO tzotze_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Vu'un yajchanc'opun li Jesuse lec c'anbilun yu'un, tey va'alun ec, ja' tey jchi'uc li sme' Jesuse. C'alal laj yiluncutic li Jesuse, jech laj yalbe li sme'e: ―Yaa, ja' avol ta xc'ot le'e ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jech laj yalbun ec li Jesuse: ―Ja' ame' ta xc'ot le'e ―xiyutun. Jech tey laj quic' batel ta jna li sme' Jesuse. Tey la jchi'in o. ");
INSERT INTO tzotze_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Li Jesuse la sna' ti chc'ot xa ta pasel scotol ti c'u x'elan ts'ibabil comel sc'oplale. Ja' xa sts'aquieb jech laj yal: ―Taquin co'nton chca'i ―xi. ");
INSERT INTO tzotze_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tey lechel jun taza pajal ya'lel ts'usub. Lic sts'ajic ta ya'lel ts'usub jun esponja. La xojic muyel ta isópo te' li esponjae. Laj yac'beic ta ye li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","C'alal la sts'uts' pajal ya'lel ts'usub li Jesuse, jech laj yal: ―Ivu' xa cu'un li cabtele ―xi. La snijan sba. Jech iloc' o xch'ulel. ");
INSERT INTO tzotze_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vu'uncutic li israeluncutique ja' xa sc'ac'alil ta jcux co'ntoncutic ta yoc'omal. Li jchapanvanejetic cu'uncutique mu sc'anic ti tey joc'ol ta xcom ta cruz sbec'talic li oxibique. Yu'un jech ono'ox tsots sc'oplal ta xc'ot cu'uncutic li jun sábado ta yech'el muc'ta q'uin coltaele. Jech la sc'anbeic Pilato ti ac'o yich'ic c'asbel yacanique, yu'un jech ac'o chamicuc ta ora, jech xu' ta syalesbeic o ta cruz li sbec'talique. ");
INSERT INTO tzotze_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jech li soldadoetique lic sc'asbeic yacan li june. Ts'acal bat sc'asbeic yacan noxtoc li yane, ja' ti co'ol ijoc'anatic ta cruz xchi'uc li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","C'alal ic'otic yo' bu joc'ol li Jesuse, chamen xa laj yilic jech muc sc'asbeic o yacan. ");
INSERT INTO tzotze_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ac'o me chamen xa laj yilic li Jesuse, pero oy jun soldado la xenbe ta lanza xocon. Ta ora iloc' xch'ich'al xchi'uc ya'lel sbec'tal. ");
INSERT INTO tzotze_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Li vu'une laj quil c'u x'elan icham li Cajvaltique. Melel li c'usi ta xcale yu'un laj quil scotol. Yu'un ti chcale, ja' sventa ac'o ach'unic ec ti ja' Jcoltavanej avu'unique. ");
INSERT INTO tzotze_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yu'un ti jech ic'ot ta pasele, yu'un ja' ic'ot o ti jech ono'ox ts'ibabil ta sc'op Diose: “Me junuc sbaquil mu sc'asbat”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jech ts'ibabil noxtoc ta sc'op Dios: “Chavilic to xenbil xocon avu'unic”, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oy jun jchi'ilcutic ta israelal, José sbi. Tey liquem tal ta lum Arimatea. Ta mucul no'ox xch'unoj ti ja' Jcoltavanej cu'untic li Jesuse yu'un ta xi' yu'un li xchi'iltac ta jchapanvaneje. C'alal laj yil ti chamen xa li Jesuse, jech bat sc'opan li Pilatoe, la sc'anbe sbec'tal li Jesuse. Li Pilatoe laj yal mantal ti ac'o syalesbe ta cruz sbec'tal li Jesuse yu'un ac'o bat smuc. Jech bat syales. ");
INSERT INTO tzotze_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tey ital ec li Nicodemoe, ja' li boch'o ay sc'opan ta ac'ubaltic li Jesuse. Yich'oj tal muil poxil capal ta yan vomol, aloé sbi. Oy van lajunebuc xcha'vinic kilo yalal. ");
INSERT INTO tzotze_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Li Jesuse la xpixic lec ta saquil manta. Tey capal la xpixic batel li muil poxile xchi'uc li aloéetique yu'un jech mu xvinaj stuil. Yu'un ja' jech jtalel ta jpascutic c'alal ta jmuc jbacutic, vu'uncutic li israeluncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","yo' bu ijoc'anat ta cruz li Jesuse tey nopol ts'unbil ep oliva te'etic. Ja' tey oy jun ach' ch'en. Ja' vombil ton li ch'ene yu'un ja' sventa tey chmucat jun ánima. Ach' to li ch'ene, mu'yuc to boch'o tey mucbil. ");
INSERT INTO tzotze_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ja' tey bat smucbeic sbec'tal li Jesuse yu'un noch' no'ox. Yu'un ja' xa sc'ac'alil ta xlic jcux co'ntoncutic c'alal me ich'ay c'ac'ale. Jech ta ora no'ox ivu' yu'unic la smuquic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ta sob domingo, ja' li sliquebal semanae, ic' to ic'ot ta smuquinal Jesús li María liquem tal ta Magdalae. Laj yil ti balch'unbil xa loq'uel li ton ti macbil o sti' ch'ene. ");
INSERT INTO tzotze_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jech isut tal ta anil, tal yalbe li Simón Pedroe xchi'uc vu'un ti lec ono'ox c'anbilun yu'un li Jesuse. Jech vul yalbuncutic: ―Li sbec'tal Cajvaltique laj xa sloq'uesic batel. Mu jna'cutic bu laj yaq'uic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jech ta ora libatcutic ta smuquinal Jesús jchi'uc li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Co'ol libatcutic ta anil. Li vu'une lijelov batel. Ba'yuc lic'ot ta smuquinal li Jesuse. Li Pedroe ja' ts'acal ic'ot. ");
INSERT INTO tzotze_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Li vu'une ja' no'ox la jcujan jba, la jnach'ta ochel li yut smuquinale. Laj quil tey votsol li saquil mantae pero muc xi'och ta yut li ch'ene. ");
INSERT INTO tzotze_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","C'alal ic'ot li Simón Pedroe, ta ora i'och ta yut ch'en. Laj yil ec ti tey votsol li saquil manta ti la xpixbeic o sbec'tal Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Laj yil tey votsol noxtoc li xpix sjole. Pero muc jmojuc oy xchi'uc li saquil mantae, slecoj bu oy, pero lec balbil comel. ");
INSERT INTO tzotze_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vu'un ti ba'yuc lic'ote ts'acal li'och ta yut li ch'ene. C'alal laj quil c'u x'elan comen li mantae, la jch'un ti cha'cuxem xa li Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero muc jna'cutic me jech ono'ox ts'ibabil comel ta sc'op Dios ti ta persa ta xcha'cuxi loq'uel ta smuquinale. ");
INSERT INTO tzotze_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jech lisutcutic o batel ta jnacutic, vu'uncutic li yajchanc'opuncutique. ");
INSERT INTO tzotze_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Li Maríae tey va'al icom ta ti' ch'en. Tey ta x'oc'. C'alal ja' o ta x'oq'ue, la scujan sba, la xnach'ta ochel li yut ch'ene. ");
INSERT INTO tzotze_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Laj yil tey chotol chib yaj'almantal Dios. Toj sac li sc'u'ique. Ja' tey chotolic yo' bu laj yaq'uic comel sbec'tal li Jesuse, jun ta sjolinab, jun ta yoquinab. ");
INSERT INTO tzotze_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jech i'albat li Maríae: ―Yaa, ¿c'u yu'un cha'oc'? ―x'utat. Itac'ov li Maríae: ―Yu'un laj xa sloq'uesic batel sbec'tal li Cajvale. Mu jna' bu laj yaq'uic ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","C'alal laj yal jech li Maríae, la sq'uel sva'lupat. Laj yil tey va'al jun vinic, pero muc xotquin me ja' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Li Jesuse jech laj yalbe: ―Yaa, ¿c'u yu'un cha'oc'? ¿Boch'o chasa'? ―xut. Li Maríae la snop ti ja' li jchabi olivate'e, jech laj yalbe: ―Tata, me vo'ot laj avich'be batel sbec'tal li Cajvale, albun ca'i ti bu ay avaq'ue yu'un ta jcuch batel ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Li Jesuse jech laj yalbe: ―¡María! ―xut. Li Maríae ijoyij, la sc'opan ta jc'opcutic, ja' li ebreo c'ope: ―¡Raboni! ―xut. (Jchanubtasvanej, xi smelol.) ");
INSERT INTO tzotze_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Li Jesuse jech laj yalbe: ―Mu me xapajesun yu'un ta ono'ox xibat yo' bu oy li Jtote. Batan, bat albo ya'yic li quermanotactique: “Ta xibat ta stojol li Jtote, ja' Atotic ec. Ja' li Dios cu'une, ja' Dios avu'unic ec, xiyutun”, uto me c'otel li yantique ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Li María ti liquem tal ta Magdalae jech vul yalbuncutic, vu'uncutic li yajchanc'opuncutic Jesuse: ―Laj xa quil li Cajvaltique ―xiyutuncutic. Li c'usitic i'albat yu'un Jesuse ivul yalbuncutic scotol. ");
INSERT INTO tzotze_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","C'alal bat xa'ox c'ac'al ta sliquebal semanae, tey jmacoj jbacutic ta na, vu'uncutic li yajchanc'opuncutic Jesuse. Lec macal cu'uncutic li ti'nae yu'un chixi'cutic yu'un li jchapanvanejetic cu'uncutique. Li Jesuse ta ora no'ox ivinaj tey ta o'lol yut na ti bu jtsoboj jbacutique. Jech laj yalbuncutic: ―Junuc avo'ntonic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","C'alal laj yalbuncutic jech li Jesuse, laj yac'bun quilcutic li sc'obe xchi'uc li xocone. Jech la jna'cutic o ti ja' li Cajvaltique, jech xcuxet no'ox co'nton jcotolcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Li Jesuse jech laj yalbuncutic yan velta: ―Junuc avo'ntonic. Jech chac c'u cha'al la stacun tal li Jtote, ja' jech ta jtacoxuc batel ec, yu'un ja' chbat apasbicun li cabtele ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","C'alal laj yalbuncutic jech li Jesuse, la xjuch'tauncutic jcotolcutic, jech laj yalbuncutic: ―Ich'ic li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Li boch'otic laj xa scomtsanic c'usitic chopol tspasique, xu' chavalbeic ti ch'abal xa smul ch‑ilatic yu'un Diose. Yan li boch'otic mu sc'an scomtsanic c'usitic chopol tspasique, xu' chavalbeic ti oy smul ch‑ilatic yu'un Diose ―xiyutuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Li Tomás ti loin xcutcutique mu'yuc tey oy ti c'alal ic'ot li Jesuse. Li Tomase ja' jchi'ilcutic ti co'ol lajchab yajchanc'opuncutic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jech laj calbecutic: ―Laj xa quilcutic li Cajvaltique ―xcutcutic. Itac'ov li Tomase: ―Ja' to me laj quil jtuc li yav laux ta sc'obe, me la jtic' ochel sbic'tal jc'ob ta yav li lauxe, xchi'uc me la jtic' ochel jc'ob ta xocone, ja' to ta jch'un ti ta melel cha'cuxem xae ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","C'alal iloc' xvaxquibal c'ac'al laj yac' sba ta ilel ta jtojolcutic li Jesuse, tey la jtsob jbacutic yan velta ta yut na, vu'uncutic li yajchanc'opuncutique. Tey xa jchi'uccutic li Tomase. Lec macal cu'uncutic li ti'nae. Pero ta ora no'ox tey ivinaj ta o'lol yut na li Jesuse. Jech laj yalbuncutic: ―Junuc avo'ntonic ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Li Jesuse jech laj yalbe li Tomase: ―La' tic'o ochel sbic'tal ac'ob li' ta jc'obe. Q'uelavil li jc'obe. Tic'o ochel ac'ob li' ta jxocone. Mu me xapas ta tsots avo'nton. Ch'uno me ti cha'cuxemun xae ―x'utat yu'un li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Itac'ov li Tomase: ―¡Cajval cu'un, Dios cu'un! ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Li Jesuse jech laj yalbe: ―Tomás, ja' to laj ach'un ti c'alal laj avil ti cha'cuxemun xae. Pero ja' más to lec li boch'otic ta xch'un ti c'alal mu'yuc chiyilicune ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Li Jesuse oy ep sq'uelubil stsatsal la spas ta jtojolcutic, vu'uncutic li yajchanc'opuncutique, pero muc xlaj yich' ts'ibael scotol li' ta vune. ");
INSERT INTO tzotze_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ti c'u yepal laj yich' ts'ibael li'i, ja' sventa ac'o ach'unic ti ja' Jcoltavanej cu'untic, xchi'uc ti ja' Ajvalil cu'untic li Jesuse, xchi'uc ti ja' Xnich'on Diose. Me chach'unique, jech chacuxiic o sbatel osil ta sventa. ");
INSERT INTO tzotze_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Li Jesuse laj yac' sba ta ilel yan velta ta jtojolcutic, vu'uncutic li yajchanc'opuncutique. Tey laj yac' sba ta ilel ta ti' nab Tibérias. Ja' jech ic'ot ta pasel. ");
INSERT INTO tzotze_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tey jtsoboj jbacutic xchi'uc li Simón Pedroe, xchi'uc li Tomás ti loin xcutcutique. Tey oy ec li Natanael ti liquem tal ta lum Caná tey ta cosilalcutic ta Galilea banamile. Tey oyuncutic jchibalcutic ec ti Zebedeo sbi jtotcutique, xchi'uc tey oyic yan chib jchi'iltac ta abtel. ");
INSERT INTO tzotze_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Li Simón Pedroe jech laj yalbuncutic: ―Ta xibat ta tsac choy ―xiyutuncutic. ―Batic, ta xbat jchi'inotcutic ―xcutcutic. Jech libatcutic, li'ochcutic ta tenalte' canova. Sjunul ac'ubal la jsa'cutic li choye pero mu'yuc la jtacutic jcotuc. ");
INSERT INTO tzotze_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","C'alal isacub osile, laj quilcutic tey va'al ta ti' nab li Jesuse. Vu'uncutic li yajchanc'opuncutique muc xcotquincutic me ja' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Li Jesuse jech laj yalbuncutic: ―Queremetic, ¿me oy laj ataic li choye? ―xiyutuncutic. ―Mu'yuc ―xcutcutic. ");
INSERT INTO tzotze_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Li Jesuse jech laj yalbuncutic yan velta: ―Tic'o ochel anuti'ic tey ta jot xocon canova ta abats'ic'obique. Ja' tey chataic ―xiyutuncutic. C'alal la jtic'cutic ochel ta yut nab li jnuti'cutique, muc xnit ochel ta yut canova cu'uncutic yu'un noj ta choy ta jyalel. ");
INSERT INTO tzotze_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Vu'un ti lec c'anbilun yu'un Jesuse, jech laj calbe li Pedroe: ―¡Ja' Cajvaltic ti le' oye! ―xcut. C'alal laj ya'i Simón Pedro ti “ja' Cajvaltic” xcute, ta ora la slap sc'u' yu'un t'anal, la sjip sba ochel ta nab, bat sta li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yan li vu'uncutique ta canova libatcutic, tey jochojcutic batel li jnuti'cutic ti nojem ta choye. Mu'yuc nom li ti' nabe, noch' no'ox. Oy no'ox van vo'vinicuc metro snatil. ");
INSERT INTO tzotze_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","C'alal liloc'cutic ta canova ta ti'nabe, laj quilcutic tey tsanem lec ac'al. Laj quilcutic tey chich' voel choy. Tey oy pan noxtoc. ");
INSERT INTO tzotze_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Li Jesuse jech laj yalbuncutic: ―Ich'ic tal cha'oxcotuc li choy laj atsaquique ―xiyutuncutic. ");
INSERT INTO tzotze_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jech i'och ta canova li Simón Pedroe, bat snit loq'uel tal ta yut nab li jnuti'cutique. Nojem ta puro muc'tiquil choy. O'lol xchibal ciento xchi'uc oxcot (153) li choye. Ac'o me toj ep li choye pero muc xtuch' li jnuti'cutique. ");
INSERT INTO tzotze_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Li Jesuse jech laj yalbuncutic: ―La' ve'anic ―xiyutuncutic. Vu'uncutic li yajchanc'opuncutique mu'yuc boch'o junucal la sjac' cu'uncutic ti boch'oe yu'un laj xa cotquincutic ti ja' Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Li Jesuse la stsac li pane laj yac'buncutic, vu'uncutic li yajchanc'opuncutique. Laj yac'buncutic noxtoc li choye jech lec live'cutic. ");
INSERT INTO tzotze_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ja' yoxibal xa velta tey laj yac' sba ta ilel ta jtojolcutic ti c'alal cha'cuxem xa'ox loq'uel ta ch'en li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","C'alal ilaj co'ntoncutic ta ve'ele, li Jesuse jech laj yalbe li Simón Pedroe: ―Simón, xnich'onot Jonás, lec ta sc'anicun li achi'iltac ta abtel li'i. Li vo'ote ¿me más to ech'em jech chac'anun? ―xut. Itac'ov li Pedroe: ―Cajval, xana' ono'ox ti lec jc'anojote ―xut. Li Jesuse jech laj yalbe: ―Albo me ya'yic jc'op scotol li boch'otic ja' to ta xch'unic ti vu'un Jcoltavanejun yu'unique yu'un jech ac'o ayinuc stsatsal yo'ntonic, jech mu xch'ayic ta be ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Li Jesuse jech la sjac'be xchibal velta: ―Simón, xnich'onot Jonás, ¿me lec chac'anun? ―xut. Itac'ov li Pedroe: ―Cajval, xana' ono'ox ti lec jc'anojote ―xut. Li Jesuse jech laj yalbe: ―Chabibun me scotol li boch'otic xch'unojic xa ti vu'un Jcoltavanejun yu'unique ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Li Jesuse jech la sjac'be yoxibal velta: ―Simón, xnich'onot Jonás, ¿me lec chac'anun? ―xut. Li Pedroe laj yat yo'nton yu'un yoxibal xa velta ijac'bat ti “¿me lec chac'anun?” x'utate. Itac'ov: ―Cajval, scotol xana'. Xana' ti lec jc'anojote ―xut. Li Jesuse jech laj yalbe: ―Albo me ya'yic jc'op scotol li boch'otic xch'unojic xa ti vu'un Jcoltavanejun yu'unique, yu'un jech ac'o ayinuc más stsatsal yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Melel li c'usi chacalbote. Ti c'alal biq'uitot toe, mu'yuc c'usi vocol laj ava'i. Atuc laj alap ac'u', laj achuc ach'ut, buyuc no'ox labat. Pero ta to sta sc'ac'alil ti c'alal molot xae, chavich' chuquel, lich'il ac'ob ta te' chacham ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Li Jesuse ja' laj yac'be sna' c'u x'elan ta xcham li Pedroe yu'un jech ta xac' ta ich'el ta muc' li Diose. Li Jesuse jech laj yalbe noxtoc li Pedroe: ―J'ech'el me ich'un ta muc' ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Li Pedroe laj yil tey nabalun tal ta spatic, vu'un ti lec c'anbilun yu'un li Jesuse, vu'un ti tey ts'e'elun ta sts'el Jesús ti c'alal live'cutic ta sventa q'uine. Ja' o ti c'alal la jac'be Jesús ti boch'o junucal ta x'ac'at ta c'abale. ");
INSERT INTO tzotze_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","C'alal laj yilun li Pedroe, jech la sjac'be li Jesuse: ―Cajval, ¿c'u x'elan ta xcham ec li jchi'il li'i? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Itac'ov li Jesuse: ―Me ta jc'an ti cuxul to ta xvul jta c'alal ta xicha'tal yan veltae, mu aventauc. Li vo'ote j'ech'el me ich'un ta muc' ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","C'alal jech laj ya'yique, la snopic ti mu'yuc chichame jech ipuc batel ta stojol quermanotic. Pero li Jesuse mu'yuc laj yal ti mu'yuc chichame. Ja' no'ox jech laj yal: “Me ta jc'an ti cuxul to ta xvul jta c'alal ta xicha'tal yan veltae, mu aventauc”, xi no'ox. ");
INSERT INTO tzotze_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Scotol li c'usitic la jts'iba li'i laj quil, laj ca'i jtuc, vu'un li Juanune, vu'un yajchanc'opun li Jesuse. Melel ti jech la spas, ti jech laj yal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Toj ep c'usitic la spas li Jesuse. Ti yich'uc ts'ibael ta vun scotole, toj ep libroetic oy ti jechuque. Yan li c'u yepal laj yich' ts'ibael li'i lec xu' chijcolutic o. ");
INSERT INTO tzotze_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, li vun la jts'ibabot tal, vu'un li Lucasune, laj xa calbot ava'i scotol c'usitic la spas li Jesuse xchi'uc li c'usitic ichanubtasvane. ");
INSERT INTO tzotze_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","C'alal to ista sc'ac'alil ibat ta vinajele, laj xa calbot o scotol. Li' ta orae yan xa o c'usi chacalbot tal. C'alal mu'yuc to'ox ta xbat ta vinajel li Jesuse, ta sventa Ch'ul Espíritu laj yalbe ya'yic comel mantal li jcholc'opetic yu'une, ja' li yajchanc'optac ti t'ujbilic ono'ox yu'une. ");
INSERT INTO tzotze_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","C'alal cha'cuxem xae, laj yac' sba ta ilel ta stojolic. Cha'vinic c'ac'al laj yaq'uilan sba ta ilel ta stojolic jech la sna'ic ti ta melel cha'cuxeme. Laj yalbe ya'yic c'u x'elan ta sventainic li yabtel Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","C'alal tey to'ox xchi'uc yajchanc'optac li Jesuse, jech laj yalbe: ―Mu to me xaloq'uic batel li' ta Jerusalene. Malaic ti chavich'ic li Ch'ul Espíritu ti yaloj ono'ox Jtotic chacac'boxuc jech chac c'u cha'al calojboxuc ono'oxe. ");
INSERT INTO tzotze_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Li Juane ja' laj yac'boxuc avich'ic vo'. Pero jutuc xa sc'an sta yorail chacac'boxuc avich'ic Ch'ul Espíritu li vu'une ―xi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","C'alal tey stsoboj sbaic xchi'uc jcholc'opetic yu'un li Jesuse, jech ijac'bat: ―Cajval, ¿me ista xa yorail ti jchi'ilcutic xa chispasuncutic ta mantal yan velta, vu'uncutic li israeluncutique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Itac'ov li Jesuse: ―Li vo'oxuque mu'yuc c'usi aventaic. Ja' sna' stuc li Jtotique yu'un ja' sventainoj scotol. ");
INSERT INTO tzotze_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero c'alal me laj avich'ic li Ch'ul Espíritue, jech chata o stsatsal avo'ntonic ta stojol Dios. Jech chacholbicun jc'oplal li' ta Jerusalén, xchi'uc li' ta Judea banamil, xchi'uc ta Samaria banamil, xchi'uc ta sbejel banamil. Ja' no'ox aventaic le'e ―xi comel li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","C'alal laj yal jech li Jesuse, li jcholc'opetic yu'une laj yilic itoy batel li Jesuse. Laj yilic ich'amat muyel ta toc, jech muc xa xilic yu'un imac ta toc. ");
INSERT INTO tzotze_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","C'alal sq'uelojic muyel vinajel ti bu itoy batel li Jesuse, ta ora laj yilic tey xchi'uquic chib xco'laj xchi'uc viniquetic. Saquil c'u'il slapojic. ");
INSERT INTO tzotze_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Li chibique jech laj yalic: ―Galilea viniquetic, ¿c'u yu'un chaq'uelic vinajel? Li Jesús laj avilic ibat ta vinajele ja' no'ox jech ta xcha'sut tal noxtoc jech chac c'u cha'al laj avilic ibate ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","C'alal ibat ta vinajel li Jesuse, tey oyic ta vits Olivatic xchi'uc li jcholc'opetic yu'une. Li vits Olivatique noch' no'ox xil sbaic xchi'uc li Jerusalene. Ja' no'ox jech snamal jech chac c'u cha'al snamal xu' chanovic ta sc'ac'alil ta xcux yo'ntonic li israeletique. Jech tey isutic batel ta Jerusalén li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","C'alal ic'otic ta Jerusalene, tey i'ochic ta na yo' bu xch'amanojique, imuyic batel ta xcha'cojal jolna. Ja' li Pedro, xchi'uc Jacobo, xchi'uc Juan, xchi'uc Andrés, xchi'uc Felipe, xchi'uc Tomás, xchi'uc Bartolomé, xchi'uc Mateo, xchi'uc li yan Jacoboe, ja' li xnich'on Alfeoe. Xchi'uc Simón, ja' ti xchi'inoj to'ox zeloteetique. Xchi'uc Judas, ja' yits'in Jacobo. ");
INSERT INTO tzotze_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jmoj la stsob sbaic, co'ol yo'nton la sc'opanic Dios jujun c'ac'al. Tey xchi'uquic noxtoc jayibuc antsetic, xchi'uc li María sme' Jesuse, xchi'uc yits'inab li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","C'alal ja' o tey la stsob sbaique, tey lic sva'an sba ta o'lol quermanotactic li Pedroe. Oy van vacvinicuc (120) ta scotolic ti tey stsoboj sbaique. Tey lic c'opojuc li Pedroe: ");
INSERT INTO tzotze_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Quermanotac, ic'ot ono'ox ta pasel c'usi ts'ibabil comel ta sc'op Dios ta vo'one ti c'alal la xch'amanbe ye David li Ch'ul Espíritue. Ja' laj yal li c'usi ic'ot xa ta pasel ta stojol li Judase. Ja' li Judas ti laj yic' batel li boch'otic bat stsaquic li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ja' jlajchabalcutic to'ox li Judase. Co'ol to'ox quich'oj cabtelcutic yu'un li Jesuse ―xi li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","C'alal laj yac' ta c'abal Jesús li Judase, i'ac'bat taq'uin. Pero ts'acal to ibat sutes li taq'uine, ja' la smanic o osil. Li Judase ja' tey bat smil sba. Pero muc teyuc joc'ol ic'ot jech chac c'u cha'al snopoje. Ibaj ta banamil, pajal ic'ot sjol, it'om xch'ut, iloc' scotol sbiquil. ");
INSERT INTO tzotze_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Laj ya'yic scotolic li boch'otic tey nacajtic ta Jerusalene, jech Acéldama ic'ot sbi yu'unic li osile. Ja' yosil ch'ich' sbi ta alel. ");
INSERT INTO tzotze_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jech laj yal noxtoc li Pedroe: ―Jech ono'ox ts'ibabil sc'oplal ta svunal jq'ueojtic: Ac'o yavnaicuc sna, ac'o mu'yucuc boch'o tey ta xnaqui o, xi ts'ibabil. Jech ts'ibabil noxtoc ti ac'o ich'batuc ta yan li yabtele. ");
INSERT INTO tzotze_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Jech ta persa ta jt'ujbetic xq'uexol. Ja' ta jt'ujtic junuc li boch'o li' ono'ox jchi'uctique, ti scotol c'ac'al la jchi'incutic li Cajvaltic Jesuse, ti co'ol lixanovcutic jchi'uccutique. Yu'un jech co'ol ta jcholbecutic batel sc'oplal ti cha'cuxem xa li Jesuse. Ja' ta jt'ujtic junuc li boch'o co'ol laj quilcutic ti i'ac'bat yich' vo' yu'un Juan li Jesuse xchi'uc ti c'alal to laj quilcutic ibat ta vinajele ―xi li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jech tey la st'ujic chib. Ja' José Barsabás, Justo yan sbi. Li yane Matías sbi. ");
INSERT INTO tzotze_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jech tey lic sc'opanic Dios: ―Cajval, vo'ot avilojbe yo'nton scotol cristianoetic. Li chibic li'i ac'bun jna'cutic boch'o junucal ti t'ujbil avu'une. ");
INSERT INTO tzotze_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yu'un ta x'och ta avabtel, ta x'och ta jcholc'op avu'un. Yu'un ja' ta stsacbe yabtel li Judase. Yu'un li Judase la scomtsan avabtel jech ibat o ta ch'ayel sbatel osil ―xi la sc'opanic Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tey lic spasic canal tajimol, ja' ic'ot ta stojol li Matíase. Ja' xchi'ilic ic'ot li buluchibique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","C'alal ista yorail q'uin Pentecostese, tey jmoj stsoboj sbaic ta jun na li lajchabique xchi'uc scotol li jch'unolajeletique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ta ora no'ox laj ya'yic oy c'usi tsots ibac' ta vinajel. Toj xvo'et laj ya'yic jech chac c'u cha'al tsots ic'. Scotolic laj ya'yic ti bu chotolique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Xco'laj xchi'uc yat c'oc' laj yilic. Tey ivul spuc sba ta sjolic jujunic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Scotolic i'och ta yo'ntonic li Ch'ul Espíritue. Lic c'opojicuc ta yantic c'opetic ti i'ac'bat sna'ic yu'un Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tey batemic ta Jerusalén noxtoc li israeletic ti boch'otic spucoj sbaic ta yantic banamile. Ja' li boch'otic lec yich'ojic ta muc' Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","C'alal laj ya'yic c'usi ibaq'ue, la stsob sbaic scotolic. Mu xa sna' c'usi chalic yu'un ta jujuchop laj yich'ic c'opanel ta sc'op stuquic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Toj ch'ayel ic'ot yo'ntonic. Jech laj yalbe sbaic: ―Scotol li boch'otic li' ta xc'opojique, ¿me muc ja'uc jchi'iltic tey liquemic tal ta Galilea? ");
INSERT INTO tzotze_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿C'u yu'un ta xca'itic ta jc'op jtuctic jujuchoputic ti bu voq'uemutique? ¿C'uxi la xchanbutic jc'optic? ");
INSERT INTO tzotze_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yu'un ep ta chop li' jtaoj jbatique. Oy liquemutic tal ta Partia banamil, oy liquemutic tal ta Media banamil, xchi'uc ta Elam banamil, xchi'uc oy tey liquemutic tal ta Mesopotámia banamil, xchi'uc li' ta Judea banamil, xchi'uc ta Capadócia banamil, xchi'uc ta Ponto banamil, xchi'uc ta Asia banamil. ");
INSERT INTO tzotze_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Xchi'uc oy liquemutic tal ta Frígia banamil, xchi'uc ta Panfilia banamil, xchi'uc ta Egipto banamil, xchi'uc ta Africa banamil tey ta jelovel lum Ciréne. Oy tey liquemic tal ta lum Roma ti jech xch'unojic jech chac c'u cha'al jch'unojtic vu'utique. Oy talemic ec li jchi'iltactic ti tey xa nacajtic ta Romae. ");
INSERT INTO tzotze_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oy boch'o liquemic tal ta Creta banamil xchi'uc ta Arábia banamil. Pero jcotoltic ta xca'itic ta jc'optic li c'usitic lec ti ja' to no'ox la spas Diose ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Toj ch'ayel ic'ot yo'ntonic scotolic, mu sna'ic c'u yu'un jech ic'ot ta pasel. Jech laj yalbe sbaic: ―¿C'usi smelol xana'? ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Oy yantic ja' no'ox ilabanvanic, jech laj yalic: ―Ja' jyacubeletic ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Li Pedroe tey la sva'an sbaic xchi'uc li buluchib xchi'iltaque, jech tey tsots lic c'opojuc li Pedroe: ―Jchi'iltac, vo'oxuc ti li' nacaloxuc ta Judea banamile xchi'uc vo'oxuc ti li' talemoxuc ta Jerusalene, a'yic c'usi ta xcal. ");
INSERT INTO tzotze_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mu'yuc chiyacubcutic jech chac c'u cha'al chavalique yu'un ja' to ista baluneb ora li c'ac'ale. ");
INSERT INTO tzotze_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Li c'usi chavilique yu'un ja' ic'ot xa ta pasel li c'usi laj yal li j'alc'op Joel ta vo'onee. Jech laj yal: Jech laj yalbun li Diose, xi li Joele. ");
INSERT INTO tzotze_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","C'alal po'ot xa slajebal c'ac'ale, ta xcac'be yich'ic Ch'ul Espíritu cu'un ep cristianoetic ta sbejel banamil. Ta to xlic xcholbicun jc'op amomnich'nabic, ac'o me querem me tseb. Li sva'lej squeremique ta to xcac'be yilic ta xch'ulelic li c'usi lec ta spasique. Li moletic yu'unique oy c'usi ta xcac'be yil ta xvayechic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ta to xcac'be yich'ic Ch'ul Espíritu cu'un li boch'otic chiyich'icun ta muq'ue, ac'o me vinic me ants. Ta to xcholbicun jc'op. ");
INSERT INTO tzotze_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ta to xcac' xch'ayubil o'ntonil ta vinajel xchi'uc ta banamil. Oy ep ch'ich', xchi'uc c'oc', xchi'uc ep xch'ayilal. Ep ta xi'ic yu'un li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta to x'ic'ub li c'ac'ale. Li ue ta to stsajub jech chac c'u cha'al ch'ich'. Ja' jech ta x'ech' c'alal po'ot xa ta sta sc'ac'alil chtal chapanvancune. Ta melel ta ono'ox sta yorail ti chtal chapanvancune. Ja' tsots sc'oplal sc'ac'alil le'e. ");
INSERT INTO tzotze_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Scotol li boch'o ta sc'anic coltael cu'une ja' chcolic, xi laj yal li Diose, xi li Joele. ");
INSERT INTO tzotze_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jchi'iltac, a'yo ava'yic c'usi ta xcal. Vu'utic li israelutique, ac'o jna'tic ti ep sq'uelubil stsatsal la spas li Jesús ti tey liquem tal ta Nazarete. Laj quiltic la spas ta jotojoltic. Toj ch'ayel ic'ot co'ntontic yu'un. Tey laj quiltic ti ta melel ja' ac'bil yabtel yu'un Diose, yu'un scotol ivu' yu'un ta sventa stsatsal Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Li Jesuse i'ac'at ta c'abal yu'un jech ono'ox snopoj Dios ta vo'one. Vo'oxuc laj atsaquic, laj ajoc'anic ta cruz. Laj avaq'uic ta milel ta stojol li boch'otic mu'yuc yich'ojic ta muc' Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Dios la xcha'cuxes loq'uel ta smuquinal yu'un mu xu' ti j'ech'el ta xcham oe. ");
INSERT INTO tzotze_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yu'un li jmoltotic David ta vo'onee jech ono'ox laj yalbe li Diose: Achi'inojun scotol c'ac'al. Li' oyot ta jts'el jech mu'yuc chixi'. ");
INSERT INTO tzotze_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jech xcuxet no'ox co'nton chcal alequilal. Ac'o me chicham pero ta jna' ti chacha'cuxesune. ");
INSERT INTO tzotze_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mu'yuc chacomtsan jch'ulel yo' bu oy xch'ulelic li boch'otic mu'yuc xch'unojique. Mu'yuc chavac' c'a'uc jbec'tal, vu'un li anich'onune, yu'un lec ac'anojun. ");
INSERT INTO tzotze_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Laj xa avac'bun jna' ti chicuxi sbatel osil ta aventae, jech xcuxet no'ox co'nton ta atojol sbatel osil, xi la sc'opan Dios li Davide. ");
INSERT INTO tzotze_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Jchi'iltac, ta jna'tic ti mu ja'uc sc'oplal stuc laj yal li Davide yu'un li stuque icham, imucat. Ta jna'tic ti li' oy li smuquinale. Ja' sc'oplal Cajvaltic laj yal yu'un jech la sc'opan Stot li Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ja' no'ox ich'amanbat ye li Davide yu'un ja' j'alc'op yu'un Dios. Xchi'uc albil ono'ox yu'un Dios ti jun smomnich'on ta xcom ta xq'uexole yu'un ja' ta x'och ta ajvalilal cu'untic, vu'utic li israelutique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ja' yu'un laj yalbe sc'oplal ti ta persa ta xcha'cuxi li Cristoe, ti mu'yuc ta xcom xch'ulel yo' bu oy xch'ulelic li boch'otic mu'yuc xch'unojique, ti mu'yuc ta xc'a' sbec'tale. Jech ono'ox ic'ot ta pasel. ");
INSERT INTO tzotze_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios la xcha'cuxes li Jesuse. Vu'uncutic laj quilcutic jcotolcutic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta stsatsal Dios i'ic'at muyel ta vinajel li Jesuse. Jech tey xa chotol ta sbats'ic'ob Dios. Albil xa ono'ox yu'un Jtotic Dios ti ta to stac tal li Ch'ul Espíritue. Ja' ti laj xa quich'cutic li' ta orae. Jech laj xa avilic, laj xa ava'yic ec li vo'oxuque. ");
INSERT INTO tzotze_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ac'o me muc xtoy batel ta vinajel xchi'uc sbec'tal li Davide, pero jech laj yal: Li Jtotic Diose jech laj yalbe li Cajvale: “Ta to xlic chotlan ta jbats'ic'ob. ");
INSERT INTO tzotze_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Vo'ot chapas mantal c'alal to ta jtsalbot scotol li avajcontrae”, xut, xi li Davide. ");
INSERT INTO tzotze_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Ac'o jna'tic jcotoltic, vu'utic li israelutique, li Jesús ti laj amilic ta cruze ja' t'ujbil ono'ox yu'un Dios ti ch‑och ta muc'ta Ajvalile xchi'uc ta x'och ta Jcoltavanej yu'un scotol cristianoetic ―xi li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","C'alal laj ya'yic c'usi laj yal li Pedroe, tsots laj yat yo'nton yu'un smulic. Jech la sjac'beic li Pedroe xchi'uc li xchi'iltac ta jcholc'ope: ―Jchi'iltac, viniquetic, ¿c'usi tsc'an ta jpascutic? ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Li Pedroe jech laj yalbe: ―Comtsanic scotol li c'usitic chopol chapasique. Ich'ic vo' ta jujunoxuc ta sventa Jesucristo, jech chaspasboxuc perdón yu'un amulic. Jech chavich'ic li amotonique, ja' li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yu'un li Dios cu'untique yaloj ono'ox ti ja' ta xich'ic Ch'ul Espíritu li boch'otic ta xch'unic iq'uel yu'un Diose. Jech xu' chavich'ic ec. Xu' ta xich'ic jnich'nabtic. Xu' ta xich'ic ec c'alal me la xch'unic iq'uel yu'un Dios li boch'otic mu ja'uc jchi'iltic ta israelale ―xi li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oy to ep c'usi yan laj yal li Pedroe. Jech laj yalbe mantal scotolic: ―Ac' abaic ta ventainel yu'un Dios jech mu co'oluc chabatic ta ch'ayel achi'uquic li boch'otic mu sc'an xch'unique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Li boch'otic la xch'unic c'usi laj yal Pedroe laj yich'ic vo'. Ja' oxmil la xch'unic ta jun no'ox c'ac'al. Jech i'epajic o li jch'unolajeletique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Scotol yo'ntonic la xchanic ti c'u x'elan ichanubtasatic yu'un jcholc'opetique. Co'ol yo'nton scotolic jech xcuxet no'ox yo'ntonic. Tey la xchi'in sbaic ta sc'opanel Dios. Scotol yo'ntonic la spasic jech chac c'u cha'al la spas Cajvaltic ti c'alal la svoc' li pane xchi'uc c'alal laj yuch' li ya'lel ts'usube. ");
INSERT INTO tzotze_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Scotolic la sna'ic ti tey oy Dios ta stojolique yu'un ep sq'uelubil stsatsal Dios i'ac'bat spasic li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Li boch'otic la xch'unic ti ja' Jcoltavanej yu'unic li Cajvaltique, co'ol yo'ntonic la scolta sbaic. Boch'otic mu'yuc c'usi oy yu'unique laj yac'beic. Xchi'uc la scoltaic li me'onetique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","C'alal chilic ti mu'yuc xa c'usi oy yu'unic li yantique, me oy yosilique bat xchonic. Xchi'uc me oy c'usitic oy yu'unic jujunique la xchonic. Li stojole ja' laj yac'beic li boch'otic mu'yuc c'usi oy yu'unique. ");
INSERT INTO tzotze_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Scotol c'ac'al la stsob sbaic ta yamaq'uil templo tey ta Jerusalén. Tey ta snaic la svoq'uic pan xchi'uc laj yuch'ic ya'lel ts'usub. Yu'un ja' tsna'ic ti ja' ta scojic icham li Cajvaltique. Xcuxet no'ox yo'nton scotolic co'ol ive'ic. Jun yo'nton scotolic. ");
INSERT INTO tzotze_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Laj yalilanic slequilal Dios. Lec i'ilatic yu'un scotol cristianoetic. Ta jujun c'ac'al i'epajic yu'un i'ic'atic yu'un Cajvaltic li boch'otic tsc'an ta xcolique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Li Pedro xchi'uc Juane bat sc'opanic Dios ta yamaq'uil templo ta Jerusalén. Oxib ora sts'ebujel c'ac'al ibatic yu'un ja' yorail ta sc'opanic Dios scotol li xchi'iltaquique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tey cuchbil ital jun xchi'ilic coxo ono'ox voq'uem. Scotol c'ac'al tey ta xcuchic batel ta yamaq'uil templo, tey chc'ot xchotanicta sti' ti bu Alac' sba sbie. Yu'un ja' ta sc'anbe limosna li boch'otic tey ta x'ochique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Li coxoe c'alal laj yil tey ta x'ochic ta yamaq'uil templo li Pedro xchi'uc Juane, la sc'anbe limosna. ");
INSERT INTO tzotze_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Li Pedro xchi'uc Juane la sq'uelbeic sat li vinique, jech laj yal li Pedroe: ―Q'ueluncutic ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Li vinique la sq'uel, la smala me yu'un oy c'usi ta xich' ac'bel. ");
INSERT INTO tzotze_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jech laj yal li Pedroe: ―Mu'yuc taq'uin cu'un pero oy c'usi cu'un chacac'bot. Ja' ta scoj Jesucristo ti liquem tal ta Nazarete va'lan, xanovan ―xut. ");
INSERT INTO tzotze_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Li Pedroe la stsacbe sbats'ic'ob, la snit liquel. Ta ora itsatsub xchibal li yacane. ");
INSERT INTO tzotze_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ibit, va'al ic'ot, lic xanovuc. Tey la xchi'inic ochel ta yamaq'uil templo. Tey xbitbun batel yu'un toj xcuxet yo'nton. Tey laj yalilan slequilal Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Scotol cristiano laj yilic ti ta xanov xa li vinique, xchi'uc ti chalilan xa slequilal Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Laj yotquinic ti ja' li jc'anlimosna ti tey ono'ox chotol ta sti' yamaq'uil templo ti bu Alac' sba sbie. Toj ch'ayel ic'ot yo'ntonic ti c'alal laj yilic colem xae. ");
INSERT INTO tzotze_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tey ta stentennail templo, Salomón sbi, ja' tey va'ajtic li Pedro xchi'uc Juane. Tey xchi'uquic li coxo ti colem xae yu'un mu scomtsanvan o. Li cristianoetique toj ch'ayel ic'ot yo'ntonic ti colem xae. Anil la stsob sbaic scotolic. ");
INSERT INTO tzotze_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","C'alal laj yil Pedro ti tey xa stsoboj sbaic scotolique, jech laj yalbe: ―Jchi'iltac, ¿c'u yu'un ch'ayel ic'ot avo'ntonic? ¿C'u yu'un chaq'ueluncutic? Mu me xanopic ti vu'un ta jtsatsalcutic, ti vu'un ta jlequilalcutic icol li vinique, ti ta xanov xae. ");
INSERT INTO tzotze_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Li Dios yu'unic jmoltotactic ta vo'onee, ja' li Abraáme, xchi'uc li Isaaque, xchi'uc li Jacove, laj yac' ta ilel ti tsots yabtel yich'oj li Xnich'one, ja' li Jesuse. Ja' ti laj avaq'uic ta c'abal ta stojol Pilatoe. C'alal laj yal Pilato ti tsc'an tscolta batele, li vo'oxuque muc xac'anic. ");
INSERT INTO tzotze_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Muc xac'anic li boch'o mu'yuc smule, ti tuc' yo'ntone. Ja' laj ac'anic coltabel li jmilvaneje. ");
INSERT INTO tzotze_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ja' laj amilic li boch'o ta xac' cuxicutic sbatel osile. Pero icha'cuxesat yu'un Dios. Melel xcalcutic yu'un vu'uncutic laj quilcutic. ");
INSERT INTO tzotze_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jch'unojcutic ti scotol xu' yu'un li Jesuse. Ja' ta sventa stsatsal Jesús icol li coxo li' chavilic ti avotquinojic ono'oxe. Yu'un la jch'uncutic ti chcol yu'un li Jesuse, jech icol o li vinic li' va'al chavilique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Jchi'iltac, ta jna' ti yu'un muc xana'beic smelol ti jech laj apasbeic li Jesuse. Jech noxtoc muc sna'beic smelol ec li jchapanvanejetic cu'untique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yu'un ja' ic'ot ta pasel c'usi yaloj ono'ox Dios c'alal la xch'amanbe ye li yaj'alc'optac ta vo'onee. Laj ono'ox yalic ti ta persa ta xcham li Cristo ti t'ujbil yu'un Dios chisventainutique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ja' lec comtsanic scotol li c'usi chopol chapasique. Ac' abaic ta ventainel yu'un li Diose. Jech ta spasboxuc perdón yu'un amulic. Jech ta xac' xcuxetel avo'ntonic li Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Li Diose ta to stac tal yan velta li Jesuse, ja' ti t'ujbil yu'un Dios chisventainutique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Li Jesucristoe tey xa oy ta vinajel. Ja' to ta xtal c'alal me la sta sc'ac'alil chlecub scotol yan velta yu'un li Diose jech chac c'u cha'al laj yalic yaj'alc'optac ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Li Moisese jech laj yalbe li jmoltotactic ta vo'onee: “Li Dios cu'untique ta to st'ujboxuc jun j'alc'op avu'unic. Ta st'uj jun jchi'iltic jech chac c'u cha'al la st'ujun. Xavich'beic me ta muc' li c'usi chayalboxuque. ");
INSERT INTO tzotze_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Boch'o mu xich' ta muc' c'usi chale ac'o loc'uc batel ti bu nacaloxuque”, xi li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Jech ono'ox laj yal ec li j'alc'op Samuel ta vo'onee ti jech ta xc'ot ta pasel jech chac c'u cha'al ic'ot xa ta pasel ta jtojoltique. Jech laj yalic noxtoc li yantic yaj'alc'optac Dios ti ts'acal to italique. ");
INSERT INTO tzotze_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vu'utic smomnich'onutic li yaj'alc'optac Dios ta vo'onee ja' yu'un ja' cu'untic ec li c'usi laj yalbe jmoltotactic ta vo'one li Diose. Yu'un li Diose jech laj yalbe li Abraáme: “Ta sventa amomnich'on ta xich'ic bendición cristianoetic ta sbejel banamil”, x'utat. ");
INSERT INTO tzotze_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jech ba'yuc li' la stac tal ta jtojoltic Xnich'on li Diose yu'un tal scoltautic, jech xu' ta jcomtsantic li c'usitic chopol ta jpastic jujunutique ―xut xchi'iltac li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","C'alal tey to ta xchi'inic ta lo'il cristianoetic li Pedro xchi'uc Juane, tey italic jayibuc paleetic xchi'uc banquilal yu'unic li boch'otic ta xchabiic temploe. Xchi'uc italic jayibuc boch'otic xch'unojic saduceo, ja' ti chalic mu'yuc cha'cuxesele. ");
INSERT INTO tzotze_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Soquem sjolic ta sventa c'usi ta xchanubtasvanic li Pedro xchi'uc Juane. Yu'un chalic ti ta xcha'cuxi ánimaetic jech chac c'u cha'al icha'cuxi li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jech tey la stsaquic li Pedro xchi'uc Juane, la stiq'uic ta chuquel. La snopic ti ta yoc'omal to ta xchapanique yu'un mal xa'ox c'ac'al. Li chuquinab yu'unique tey stsacoj sba xchi'uc templo. ");
INSERT INTO tzotze_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero ep boch'otic laj ya'yic li sc'op Dios laj yalic Pedro xchi'uc Juane, la xch'unic. Jech ic'otic xa ta vo'mil ta scotol li viniquetique xchi'uc li boch'otic xch'unojic ono'oxe. ");
INSERT INTO tzotze_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta yoc'omal la stsob sbaic ta Jerusalén li jchapanvanejetic yu'un israeletique. Li j'o'lole ja' jchanubtasvanejetic ta smantal Dios yalojic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tey ital ec li Anase, ja' li más banquilal pale to'oxe, xchi'uc li Caifase. Xchi'uc yan chib paleetic, Juan sbi xchi'uc Alejandro. Xchi'uc scotol xchi'iltac li banquilal palee. ");
INSERT INTO tzotze_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Laj yiq'uic loq'uel tal ta chuquinab li Pedro xchi'uc Juane. Tey la scacanic ta o'lol, jech la sjac'beic: ―¿Boch'o ta svu'el, boch'o ta scoj ti jech chapasique? ―xutic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Li Pedroe ventainbil yo'nton yu'un li Ch'ul Espíritue jech laj yal: ―A'yo me ava'yic, j'abteletic, moletic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yu'un ti chachapanuncutic ta sventa ti icol cu'uncutic li coxo vinique, ");
INSERT INTO tzotze_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","jech chacalboxuc ava'yic acotolic. Vu'utic li israelutique, ac'o jna'tic ti ja' ta scoj Jesucristo liquem tal ta Nazaret icol li vinic li' oy ta atojolique. Ja' li boch'o laj amilic ta cruze. Pero icha'cuxesat yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Li vo'oxuque ja' jechoxuc jech chac c'u cha'al jpasnaetic ti muc sc'anic li ton ti la st'uj yajval na sventa chac' ta chiquin nae. Ja' jechoxuc ec li vo'oxuque. Muc xac'anic li boch'o t'ujbil yu'un Diose, ja' li Jesuse, pero li Diose laj xa yac'be tsots yabtel. ");
INSERT INTO tzotze_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mu'yuc boch'o yan xu' chiscoltautic, ja' no'ox Jesucristo. Yu'un mu'yuc boch'o yan albil sc'oplal yu'un Dios ti xu' chijcolutic yu'une ―xut jchapanvanejetic li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","C'alal laj yilic jchapanvanejetic ti oy lec stsatsal yo'ntonic li Pedro xchi'uc Juane, labal laj ya'yic yu'un sna'ojic ti mu'yuc xchanubtasojic ta smantaltac Diose, xchi'uc ti mu'yuc yabtelique. Jech la sna'ic ti ja' la xchi'inic to'ox li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yu'un tey xchi'uquic li vinic ti colem xae, jech mu'yuc c'usi xu' chalbeic li Pedro xchi'uc Juane. ");
INSERT INTO tzotze_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jech laj yalbeic yoxibalic ti ac'o loq'uicuc batel jliqueluque. Jech iloq'uic batel ti bu tsobolique. Li jchapanvanejetique lic snopic c'usi ta spasbeic li Pedro xchi'uc Juane. ");
INSERT INTO tzotze_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jech laj yalbe sbaic: ―¿C'usi ta jpasbetic li viniquetique? Yu'un laj xa spasic sq'uelubil stsatsal Dios yu'un icol yu'unic li vinique. Laj xa ya'yic scotol li boch'otic li' nacalic ta Jerusalene. Mu xu' ta xcaltic ti mu jechuque. ");
INSERT INTO tzotze_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero ti c'u cha'al mu xpuc batel ta scotol cosilaltique, ja' lec tsots ta xcalbetic ti mu xa me spucbeic batel sc'oplal li Jesuse ―xut sbaic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jech laj yiq'uic ochel yan velta li Pedro xchi'uc Juane. Tsots laj yalbeic ti mu xa me boch'o xalbeic sc'oplal li Jesuse, xchi'uc mu xa me xchanubtasvanic ta sventa li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Itac'ovic li Pedro xchi'uc Juane: ―Nopo ava'yic bu junucal tsots sc'oplal ta ch'unel. ¿Me ja' más tsots sc'oplal ta jch'uncutic li amantalique, o me ja' más tsots sc'oplal ta jch'unbecutic smantal Dios? ");
INSERT INTO tzotze_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yu'un mu xu' ta jcomtsancutic xcholel li c'usitic quilojcutique xchi'uc li c'usitic ca'yojcutique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Li jchapanvanejetique laj yalic yan velta ti mu xa me xcholic batele, jech la scoltaic batel. Muc spas xac'beic castigo li Pedro xchi'uc Juane yu'un ixi'ic yu'un li xchi'iltaquic ta israelale. Yu'un scotol xchi'iltac laj yalbeic slequilal Dios ta sventa ti laj yilic colem xa li coxo vinique. ");
INSERT INTO tzotze_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yu'un ech'em xa ta cha'vinic jabil yich'oj li vinic ti icol ta sventa sq'uelubil stsatsal Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","C'alal icoltaatic batel li Pedro xchi'uc Juane, ibat sc'opanic li xchi'iltaquic ta abtele. C'ot yalbeic scotol li c'usitic i'albatic yu'un paleetic xchi'uc jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","C'alal laj ya'yique, jmoj yo'ntonic la sc'opanic Dios: ―Cajval, vo'ot Diosot ti laj apas vinajel banamile, xchi'uc li nabe, xchi'uc scotol li c'usitic oye. ");
INSERT INTO tzotze_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Vo'ot laj ach'amanbe ye li avajtunel David ta vo'onee. Ta sventa Ch'ul Espíritu jech la sts'iba: Altic ti chlic stoy sbaic li cristianoetique. Altic ti mu lecuc c'usi ta snopique. ");
INSERT INTO tzotze_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Li ajvaliletic xchi'uc jchapanvanejetique co'ol chc'ot sc'opic. Jmoj yo'ntonic chlic scontrainic li Diose xchi'uc li boch'o t'ujbil yu'un chisventainutique, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ta melel jech ic'ot ta pasel yu'un li' la stsob sbaic ta lum Jerusalén li Erodese, xchi'uc li Poncio Pilatoe, xchi'uc li yantic cristianoetic ti muc ja'uc jchi'ilcutic ta israelale, xchi'uc li jchi'iltaccutic ta israelale. Jmoj la snopic ti ta smilic li Ach'ulnich'on Jesús ti avac'ojbe yabtel yu'un chiscoltauncutique. ");
INSERT INTO tzotze_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ja' la spasbeic li c'usi anopoj ono'ox ta vo'onee yu'un jech la sc'an avo'nton. ");
INSERT INTO tzotze_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cajval, tana li'i tsc'an chispajesuncutic, vu'uncutic li avajtuneluncutique. Ac'bun stsatsal co'ntoncutic ti c'u cha'al mu xixi'cutic c'alal ta jcholcutic ac'ope. ");
INSERT INTO tzotze_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ac'o ta ilel atsatsal ti scotol xu' avu'une, ac'o coluc cu'uncutic jchameletic. Ac'bun jpascutic sq'uelubil atsatsal ta sventa li Ach'ulnich'on Jesuse ―xi la sc'opanic Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","C'alal ilaj yo'ntonic ta sc'opanel Diose, laj ya'yic inic li na yo' bu tsobolique. Scotolic iventainbat yo'ntonic yu'un li Ch'ul Espíritue. Jech itsatsub o yo'ntonic, jamal la xcholic batel li sc'op Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ti c'u yepal xch'unojique co'ol yo'nton scotolic. Boch'o oy c'usi oy yu'un muc xal ti ja' yu'un stuque, ja' co'ol yu'unic scotolic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Li jcholc'opetic yu'un Jesuse la xcholbeic jch'unolajeletic ti ta melel icha'cuxi li Cajvaltique. Oy lec stsatsal li sc'opique jech ic'ot ta yo'ntonic li jch'unolajeletique. Jech i'ac'bat ep slequil yo'ntonic scotolic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jech mu'yuc xa boch'o abul sba, yu'un scotol li boch'o oy yosilique, xchi'uc boch'o oy snaique, bat xchonic ti c'alal laj yilic mu'yuc xa c'usi chtun yu'unique. Laj yich'beic tal stojol li c'usi la xchonique. ");
INSERT INTO tzotze_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tey c'ot yac'beic ta sc'ob li jcholc'opetic yu'un Jesuse. Li boch'otic mu'yuc xa c'usi oy yu'unique, tey i'ac'batic. ");
INSERT INTO tzotze_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tey oy jun vinic, José sbi. Ja' Bernabé i'ac'bat sbi yu'un li jcholc'opetic yu'un Jesuse. Ja' jpat‑o'ntonil, xi smelol. Tey voq'uem ta Chipre banamil. Ja' smoltot ta vo'one li Levíe. ");
INSERT INTO tzotze_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Oy to'ox yosil pero la xchon. Laj yich'be tal stojol li yosile, laj yac'be ta sc'ob li jcholc'opetic yu'un Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oy yan vinic noxtoc, Ananías sbi. Safíra sbi li yajnile. La xchon juteb yosil. ");
INSERT INTO tzotze_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Co'ol la snopic xchi'uc yajnil ti mu ts'acaluc chaq'uic li stojol yosilique. Jech mu scotoluc laj yich' batel ti c'alal bat yac'beic ta sc'ob li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Li Pedroe jech laj yalbe li Ananíase: ―Ananías, ¿c'u yu'un laj ach'unbe smantal li Satanase yu'un muc ts'acaluc laj avac' li stojol avosile? La'epalc'opoj ta stojol li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Li osile ja' avu'un atuc, jech mu persauc laj achon ti jechuque. Yu'un ti laj achone, vo'ot laj anop atuc ti chavac'be stojole. ¿C'u yu'un laj anop ti chavoc'be stojole? Mu ja'uc la'epalc'opoj ta stojol cristiano, ja' la'epalc'opoj ta stojol Dios ―xut. ");
INSERT INTO tzotze_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","C'alal laj ya'i li Ananíase, iyal ta lum, ta ora iloc' xch'ulel. Toj xi'el ic'ot scotol li boch'otic laj ya'yic ichame. ");
INSERT INTO tzotze_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iliquic jayibuc queremetic. La xpixbeic sbec'tal, la xcuchic loq'uel, bat smuquic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ijelov xa'ox van oxibuc ora, ja' o i'och tal ec li yajnile, ja' li Safírae. Mu sna' me chamen xa li smalale. ");
INSERT INTO tzotze_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Li Pedroe jech la sjac'be: ―Albun ca'i me ja' no'ox jech yepal li stojol avosil laj achonique ―xut. ―Ja' no'ox jech yepal ―xi itac'ov li antse. ");
INSERT INTO tzotze_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Li Pedroe jech laj yalbe: ―¿C'u yu'un co'ol laj anopic achi'uc li amalale yu'un ja' no'ox laj asa'beic sc'ac'al yo'nton li Ch'ul Espíritu ti junic xchi'uc Cajvaltique? A'yo ava'i, li' xa xtalic ta patna li boch'otic ay smuquic amalale. Ja' no'ox jech chaxcuchicot loq'uel ec ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","C'alal laj ya'i li antse, ta ora iyal ta lum, iloc' xch'ulel. C'alal i'ochic li queremetique, chamen xa c'ot staic li antse. Jech la xcuchic loq'uel, bat smuquic ta sts'el yo' bu la smuquic li smalale. ");
INSERT INTO tzotze_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ixi'ic scotol li jch'unolajeletique xchi'uc li boch'otic yan laj ya'yique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Li jcholc'opetic yu'un Jesuse la spasic ep sq'uelubil stsatsal Dios ta stojol li cristianoetique. Scotol c'ac'al tey la stsobilan sbaic ta stentennail templo yo' bu Salomón sbie. ");
INSERT INTO tzotze_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Me junuc mu'yuc boch'o icontrainvan yu'unic, scotolic lec laj yilic c'usi la spasic li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta jujun c'ac'al i'epajic li boch'otic la xch'unic ti ja' Jcoltavanej yu'unic li Cajvaltique. Ep viniquetic xchi'uc antsetic la xch'unic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Scotol jchameletic la sloq'uesic tal xchi'uc svayabic xchi'uc spopic, tal xmochanic ta calle. Yu'un ta sc'anic ti tey ta x'ech' coltabaticuc yu'un li Pedroe. Yu'un la snopic me mu xpaj tey li Pedroe, ja' no'ox la smalaic me ta xc'ot snac'ubal ta sbec'tal li jchameletique yu'un jech chcolic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ep italic tey ta Jerusalén li boch'otic tey no'ox nacajtic ta yantic lumetic ta noch' Jerusalene. Laj yiq'uic tal jchameletic xchi'uc boch'otic ta x'uts'intaatic yu'un pucujetic ti ochem ta yo'ntonique. Pero scotolic icolic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Li más banquilal palee xchi'uc li boch'otic tey xchi'inoj ti co'ol xch'unojic saduceo xchi'uque, xti'et ic'ot yo'ntonic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","La stsaquic li jcholc'opetique, la stiq'uic ta chuquel ta cabildo. ");
INSERT INTO tzotze_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ta ac'ubaltic ital jun yaj'almantal Cajvaltic, la sjam li ti' chuquinabe. La sloq'ues batel li jcholc'opetique, jech laj yalbe: ");
INSERT INTO tzotze_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Bat va'ano abaic ta yamaq'uil templo. Cholbo ya'yic achi'iltaquic ti xu' chcolic sbatel osil ta sventa li Jesuse ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","C'alal laj ya'yic c'usi i'albatique, ta sacubel osil i'ochic ta yamaq'uil templo, tey ichanubtasvanic. Li más banquilal palee xchi'uc li saduceoetique la stsobic scotol li jchapanvanejetic yu'unic tey ta temploe. La staquic batel jayibuc jchabitemplo yu'un chbat sloq'uesic tal ta chuquel li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","C'alal ic'otic li boch'otic ta xchabiic temploe, mu'yuc xa tey oy la staic li jchuqueletique, jech isutic batel. ");
INSERT INTO tzotze_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Jech c'ot yalic: ―Lec macal la jtacutic li ti' chuquinabe. Tey va'ajtic ta ti' chuquinab li soldadoetique. C'alal la jamcutique, mu'yuc boch'o tey oy la jtacutic ―xiic c'otel. ");
INSERT INTO tzotze_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","C'alal laj ya'yic li banquilal paleetique xchi'uc li banquilal jchabitemploe, ilo'ilaj yo'ntonic yu'un ti jech ic'ot ta pasele. Ixi'ic me mu xu' yu'unic ta spajesic li Pedro xchi'uc xchi'iltaque. ");
INSERT INTO tzotze_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oy boch'o bat yalbe li banquilal palee: ―Li viniquetic laj atiq'uic ta chuquele tey xa oyic ta yamaq'uil templo. Tey xa ta xchanubtasvanic ―xi c'otel. ");
INSERT INTO tzotze_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","C'alal laj ya'i banquilal jchabitemplo xchi'uc svinictaque, ta ora ibatic. Bat yiq'uic tal li jcholc'opetique, pero mu'yuc laj yuts'intaic tal yu'un ixi'ic me ta x'ac'batic ton yu'un li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","C'alal ivul yu'unic ta stojol jchapanvanejetique, li más banquilal palee jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tsots laj calboxuc mantal ti mu xa me xachanubtasvanic ta sventa li Jesuse. Pero q'uelavilic, vinajem xa avu'unic ta sjunul lum li' ta Jerusalene. Chavaq'uic jcuchincutic noxtoc ti vu'uncutic la jmilcutic li vinic chavalique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Itac'ov li Pedro xchi'uc xchi'iltaque: ―Ta persa ta jch'unbecutic smantal Dios, mu ja'uc ta jch'unbecutic smantal cristianoetic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Li Dios yu'un jmoltotactic ta vo'onee ja' la xcha'cuxes loq'uel ta smuquinal li Jesuse. Ja' ti laj amilique, ti laj ajoc'anic ta cruze. ");
INSERT INTO tzotze_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Li Diose laj xa yac' ta ich'el ta muc' li Jesuse, laj xa xchotan ta sbats'ic'ob. Ja' muc'ta Ajvalil ic'ot yu'un scotol cristianoetic. Ja' Jcoltavanej cu'untic ic'ot. Ja' chiscoltautic yu'un jech xu' cu'untic ta jcomtsantic c'usitic chopol ta jpastic, vu'utic li israelutique, jech chispasbutic perdón yu'un jmultic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Vu'uncutic ta jcholcutic ti ta melel ac'bil xa yabtel yu'un Dios li Jesuse. Ja' jech chal ec li Ch'ul Espíritu ti ac'bilic xa ta yo'ntonic yu'un Dios scotol li boch'otic laj xa xch'unic c'usi tsc'an li Cajvaltique ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","C'alal laj ya'yic jech itac'batique, tsots i'ilinic, tsc'an ox ta smilic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jech tey lic sva'an sba jun vinic xch'unoj fariseo, ja' jchapanvanej ec, Gamaliel sbi. Ja' jchanubtasvanej ta smantal Dios yaloj. Lec ich'bil ta muc' yu'un scotol xchi'iltac ta israelal. Ja' laj yal mantal ti ac'o sloq'uesic jliqueluc li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jech lic yalbe ya'yic scotol li jchapanvanejetic tey xchi'uque: ―Jchi'iltac, vu'utic li israelutique, ac'o me jnoptic lec c'usi ta jpasbetic li viniquetique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Na'ic me ti oy ilic jun vinic ta vo'one, Téudas sbi. Banquilal la scuy sba. Oy chanib ciento svinictac. Pero imilat li Téudase. Jech la svoq'uilan sbaic batel scotol li svinictaque, tey ilaj c'op o yu'unic. ");
INSERT INTO tzotze_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ts'acal to ilic yan vinic noxtoc, Judas sbi. Tey liquem tal ta Galilea banamil. Ja' o yorail yaloj mantal ajvalil ti ac'o yac' ta tsaquel sbiic scotol li cristianoetique. Ep boch'o la xch'unic c'usi laj yal li Judase. Pero imilat noxtoc li Judase. Jech la svoq'uilan sbaic batel scotol li boch'otic la xch'unic c'usi laj yale. ");
INSERT INTO tzotze_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jech chacalboxuc. Mu me c'usi xapasbeic li viniquetic li'i. Ac'o spasic li c'usi tsc'anique. Me ja' no'ox ta sventa cristiano li sc'opique xchi'uc li c'usitic tspasique, ta ono'ox xlaj. ");
INSERT INTO tzotze_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yan me ja' ta sventa Dios li sc'opique, mu xlaj. Ja' lec q'uelo me abaic naca me ja' ta jcontraintic li Diose ―xi li Gamaliele. ");
INSERT INTO tzotze_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Scotolic la xch'unic c'usi laj yal li Gamaliele. Jech c'alal laj yiq'uic ochel li jcholc'opetique ja' no'ox laj yac'beic nucul xchi'uc laj yalbeic tsots mantal ti mu xa me xcholic batel li c'op ta sventa Jesuse. Jech la scoltaic batel. ");
INSERT INTO tzotze_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","C'alal iloq'uic batel ta stojol jchapanvanejetic li jcholc'opetique, xcuxet no'ox yo'ntonic yu'un la sna'ic ti jech la sc'an Dios chich'ic uts'intael ta sventa Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pero muc scomtsanic yalel. Scotol c'ac'al ichanubtasvanic ta sventa Jesucristo tey ta yamaq'uil templo xchi'uc ta naetic. ");
INSERT INTO tzotze_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","C'alal i'epajic xa li jch'unolajeletique, tey oyic israeletic ti xchanojic griego c'ope. Tey oyic ec ti ebreo sc'opique, ja' li sc'op ono'ox israeletique. Li boch'otic xchanojic griego c'ope chopol ic'opojic ta stojol li boch'o ebreo sc'opique. Laj yalic ti muc xich'ic c'uxubinel me'on antsetic yu'unic ti c'alal i'ac'bat sve'elic ta jujun c'ac'ale. ");
INSERT INTO tzotze_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Li lajchab jcholc'opetic yu'un Jesuse la stsobic tal scotol li jch'unolajeletique, jech laj yalbeic: ―Li vu'uncutique mu lecuc me ja' ta jcomtsancutic xcholel sc'op Dios ta scoj ti vu'uncutic ta jventaincutic ve'lile. ");
INSERT INTO tzotze_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ja' lec, quermanotac, t'ujic vucub viniquetic ti bu lec sc'oplal ava'yojique, ti bijique, ja' li boch'otic ventainbil yo'ntonic yu'un Ch'ul Espíritue, yu'un ja' ta xich' yabtelic. ");
INSERT INTO tzotze_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Li vu'uncutique ja' cabtelcutic ta jc'opancutic Dios, ta jcholcutic sc'op Dios ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Scotolic lec laj ya'yic li c'usi i'albatique. Jech la st'ujic Esteban. Ja' jun vinic ti lec xch'unoj Cajvaltique. Ventainbil yo'nton yu'un Ch'ul Espíritu. La st'ujic yan vaquib. Ja' Felipe, xchi'uc Prócoro, xchi'uc Nicanór, xchi'uc Timón, xchi'uc Parménas, xchi'uc Nicolás. Li Nicolase mu ja'uc israel vinic, ja' tey liquem tal ta lum Antioquía. Ja' co'ol to'ox xch'unoj xchi'uc li israeletique. ");
INSERT INTO tzotze_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","C'alal la st'ujique, laj yiq'uic tal ta stojol li jcholc'opetique. Li jcholc'opetique la sc'opanbeic Dios ta stojol. Laj yac' sc'obic ta sjol li vucub it'ujatique. Ja' senyail ti laj yich' yabtelique. ");
INSERT INTO tzotze_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Li jch'unolajeletic ta Jerusalene más i'epajic. Oy ep paleetic la xch'unic ec. ");
INSERT INTO tzotze_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Li Estebane i'ac'bat ep slequil yo'nton xchi'uc stsatsal jech la spas ep sq'uelubil stsatsal Dios ta stojol li cristianoetique. ");
INSERT INTO tzotze_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tey oyic jayibuc israeletic liquemic tal ta nail tsobobbail ti bu Coltabilic ta Mozoil sbie. Ja' tey liquemic tal ta lum Ciréne, xchi'uc ta lum Alejandría, xchi'uc ta Cilícia banamil, xchi'uc ta Asia banamil. Tey lic yutic li Estebane. ");
INSERT INTO tzotze_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero muc xu' yu'unic yu'un ic'opoj ta sbijil Ch'ul Espíritu li Estebane. ");
INSERT INTO tzotze_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jech la stojic tal boch'otic ta x'epalc'opojic ta sventa Esteban. Lec la xchanubtasic tal c'usi ta xalic: ―Jech me xc'ot avalic. “Ca'yojcutic ti chopol chc'opoj ta stojol li Moisese xchi'uc ta stojol li Diose”, xachiic me ―x'utatic. ");
INSERT INTO tzotze_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ta sventa ti jech laj yalique tey iliquic ta vochlajetel scotol li israeletique, xchi'uc jayibuc jchapanvanejetic yu'unic, xchi'uc jayibuc jchanubtasvanejetic ta smantal Dios yalojic. Tal stsaquic ta mucul li Estebane. Laj yiq'uic batel ta stojol scotol li jchapanvanejetique. ");
INSERT INTO tzotze_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Laj yiq'uic tal li j'epalc'op testigoetique, jech la snopbeic smul li Estebane: ―Li vinic li'i chopol chc'opoj ta sventa li templo li'i xchi'uc ta sventa li ch'ul mantale. Mu scomtsan o yalel. ");
INSERT INTO tzotze_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yu'un ca'yojcutic jech chal: “Li Jesús tey liquem tal ta Nazarete ta svuq'ues li templo li'i xchi'uc ta sjel ti c'u x'elan jtaleltic yaloj Moisés ta vo'onee”, xi chal ―xi la snopbeic ye li Estebane. ");
INSERT INTO tzotze_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Scotol li jchapanvanejetic tey chotolique la sq'uelbeic sat li Estebane. Xco'laj xchi'uc sat yaj'almantal Dios laj yilic. ");
INSERT INTO tzotze_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Li más banquilal palee jech la sjac'be li Estebane: ―¿Me melel li c'usi laj yalique? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Itac'ov li Estebane: ―Jchi'iltac, a'yo me ava'yic li c'usi chacalboxuque. Li Diose, ja' ti oy xojobale, laj yac' sba ta ilel ta stojol li jmoltotic Abraám c'alal tey to'ox nacal ta Mesopotámia banamile, ti mu'yuc to'ox chbat nacluc ta lum Arane. ");
INSERT INTO tzotze_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jech laj yalbe: “Loc'an batel ta avosilal, comtsano atot ame' xchi'uc scotol avuts' avalal, batan ta yan banamil ti bu chacac'bot avile”, x'utat yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jech iloc' batel ta yosilal caldea cristianoetic li Abraáme. Tey c'ot nacluc ta Arán. C'alal icham stot li Abraáme, i'albat yu'un Dios ti ta persa ta xloc' tale. Ja' li' itacat tal ta cosilaltic yo' bu oyutic li' ta orae. ");
INSERT INTO tzotze_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Li Diose muc xac'be yich' li osil li'i. Me jutebuc mu'yuc x'ac'bat yich' li Abraáme. Ti bu inaquie ja' no'ox la xch'aman. Ja' no'ox ba'yuc i'albat yu'un Dios ti ja' ta xich' comel li smomnich'nabe. Pero mu'yuc to'ox xnich'on ti c'alal jech i'albate. ");
INSERT INTO tzotze_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","I'albat noxtoc yu'un Dios ti ta to xbat naclicuc ta yan banamil li smomnich'nabe. Tey chbat ochicuc ta mozoil chanib ciento jabil, tey ta xich'ic uts'intael. Tey tsots ta x'abtejic pero mu'yuc chich'ic tojel. ");
INSERT INTO tzotze_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Li Abraáme jech i'albat noxtoc yu'un li Diose: “Vu'un ta xcac'be castigo li boch'otic ta smozoinvane. Ts'acal to ta xloq'uic tal scotol li amomnich'nabe. Li' ta xvul tunicuc cu'un”, x'utat yu'un Dios li Abraáme. ");
INSERT INTO tzotze_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Li Diose la xchapan xchi'uc Abraám ti tsots sc'oplal chcom li circuncisione. Jech c'alal ivoc' xnich'on li Abraáme, ja' li Isaaque, ta xvaxquibal c'ac'al svoq'uel laj yac'be yich' circuncisión. Ja' jech la spasilanic o. C'alal inich'naj ec li Isaaque, laj yac'be yich' circuncisión li xnich'one, ja' li Jacove. C'alal inich'naj li Jacove, ja' no'ox jech la spasbe ec li xnich'nabe, ja' li lajchab jmoltotactic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Li xnich'nab Jacove, ja' li jmoltotactic ta vo'onee, xti'et yo'ntonic yu'un li yits'inic Josée. Jech la xchonic batel ta Egipto banamil. Pero li Josée chi'inbil yu'un Dios. ");
INSERT INTO tzotze_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","C'alal i'uts'intaat li Josée, icoltaat yu'un Dios. I'ac'bat sbijil jech lec i'ilat yu'un li faraón tey ta Egiptoe. Jech tey i'och ta gobernador li Josée, ja' its'inal ajvalil ic'ot. I'ac'bat yich' ta venta scotol li egipto cristianoetique. I'ac'bat sventain noxtoc c'usitic oy yu'un ta sna li faraone. ");
INSERT INTO tzotze_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ts'acal to ital tsots vi'nal ta scotol Egipto banamil xchi'uc ta Canán banamil. Ep vocol laj ya'yic li cristianoetique. Li jmoltotactic ta vo'onee mu'yuc xa bu tsta sve'elic. ");
INSERT INTO tzotze_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Laj ya'i Jacov ti oy trigo tey ta Egiptoe. Jech tey la stac batel li jmoltotactic ta vo'onee. Ja' sba to velta la stac batel. ");
INSERT INTO tzotze_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","C'alal ibatic xchibal veltae, li Josée tey laj yac' sba ta otquinel ta stojol sbanquiltac xchi'uc yits'in. Jech li faraone tey laj yotquinbe o sbanquiltac xchi'uc yits'in li Josée. ");
INSERT INTO tzotze_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Li Josée la stac ta iq'uel li stote, ja' li Jacove, xchi'uc scotol li xchi'iltac ta voq'uele. Ja' vo'lajuneb xchanvinic (75) ic'ot ta scotolic c'alal ta xnich'nabic. ");
INSERT INTO tzotze_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jech tey inaqui ta Egipto li Jacove, tey icham. Tey ichamic ec li jmoltotactic ta vo'onee, ja' li xnich'nabe. ");
INSERT INTO tzotze_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","La xcuchbeic tal li sbec'talique. Me junuc mu'yuc boch'o tey xmuc ta Egipto. Li' la smuquic ta nail ch'en ta lum Siquem ti bu smanoj ono'ox li Abraáme. Ja' ti la smanbe smomnich'nab Amor tey ta Siqueme. ");
INSERT INTO tzotze_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’C'alal po'ot xa tsta yorail ta xich'ic li osil ti albil ono'ox yu'un Dios li Abraáme, ep xa'ox bolemic tey ta Egipto li jmoltotactic ta vo'onee. Bats'i epic xa. ");
INSERT INTO tzotze_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","I'och yan faraón tey ta Egipto pero muc xa xotquin li Josée. ");
INSERT INTO tzotze_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Li ach' faraone ilo'lavan. Jech tey lic yuts'inta scotol li jmoltotactic ta vo'onee. Laj yal mantal ti ac'o sloq'ues ta snaic scotol li yunin queremique yu'un jech ac'o chamicuc. Yu'un ja' mu sc'an faraón ti ta xbolic li jmoltotactic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","C'alal jech yaloj mantal li faraone, ja' o yorail ivoc' li Moisese. Lec i'ilat yu'un Dios. Jech oxib u icom ta sna stot li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","C'alal iloq'uesat yu'un ac'o chamuque, tey itaat yu'un stseb li faraone. La sts'ites, la scuy ta yol stuc. ");
INSERT INTO tzotze_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lec laj yich' chanubtasel li Moisese, la xchanbe scotol c'u x'elan sbijilic li egipto cristianoetique. Lec xu' yu'un c'usi chal xchi'uc c'usi tspas. ");
INSERT INTO tzotze_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’C'alal yich'oj xa cha'vinic jabil li Moisese, tsc'an ta sc'opan li xchi'iltaque, ja' li jmoltotactic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tey laj yil ta xmajat jun xchi'il, ja' ta xmajvan jun egipto vinic. Li Moisese bat smil li egipto vinique, ja' la spoj li xchi'ile. ");
INSERT INTO tzotze_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Snopoj Moisés ti tsna'ic xchi'iltac ti ja' t'ujbil yu'un Dios ta scolta li xchi'iltaque, pero mu sna'ic. ");
INSERT INTO tzotze_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta yoc'omal noxtoc laj yil Moisés ta xut sbaic chib xchi'iltac. Li Moisese tsc'an ta spajes. Jech laj yalbe: “¿C'u yu'un chavut abaic yu'un achi'il no'ox abaic?” xut. ");
INSERT INTO tzotze_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Li Moisese inet'at loq'uel yu'un li boch'o la sliques c'ope. Jech i'albat: “¿Boch'o laj yac'bot avabtel? Mu vo'ocot ajvalilot cu'uncutic. Mu vo'ocot jchapanvanejot cu'uncutic. ");
INSERT INTO tzotze_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Me chac'an chamilun ec jech chac c'u cha'al laj amil jun egipto vinic voljee?” x'utat. ");
INSERT INTO tzotze_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","C'alal laj ya'i Moisés ti vinajem xa ti imilvane, ijatov batel. Tey c'ot nacluc ta Madián banamil. Tey la sa' yajnil, tey ivoc' chib xnich'on. ");
INSERT INTO tzotze_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’C'alal ech'em xa'ox cha'vinic jabil sc'otel li Moisese, tey laj yil tsanem jtec' biq'uit ch'ix ta vits Sinaí tey ta xocol banamil. Tey ta yat c'oc' laj yil li Diose, xco'laj xchi'uc j'almantal laj yil. ");
INSERT INTO tzotze_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","C'alal laj yil ti mu xc'ac' li biq'uit ch'ixe, ch'ayel ic'ot yo'nton. Tey inoch'aj batel bat sq'uel. Tey laj ya'i ic'opoj li Diose, jech laj yal: ");
INSERT INTO tzotze_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Vu'un Diosun yu'un li amoltotac ta vo'onee, ja' li Abraáme, xchi'uc li Isaaque, xchi'uc li Jacove”, xi. Li Moisese inic ta xi'el jech muc xbat sq'uel o. ");
INSERT INTO tzotze_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pero jech to i'albat yu'un li Diose: “Loq'ueso axonob yu'un li' xa va'alot ta jtojol, vu'un li Diosune. ");
INSERT INTO tzotze_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Quiloj ti ep svocolic li achi'iltac tey ta Egiptoe, vo'oxuc ti co'ol t'ujbiloxuc cu'une. Laj xa ca'i ti ep x'ayetique. Jech liyal tal yu'un tal jcolta loq'uel ta svocolic. Batic ta Egipto”, x'utat yu'un Dios li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ja' li Moisés ti muc to'ox xich'ic ta muq'ue, ti jech laj yalbeique: “¿Boch'o laj yac'bot avabtel? Mu vo'ocot ajvalilot cu'uncutic, mu vo'ocot jchapanvanejot cu'uncutic”, xutic. Pero Dios la stac batel yu'un ja' chc'ot ta banquilal xchi'uc ta jcoltavanej yu'unic. Ja' o itacat batel yu'un Dios ti c'alal tey ivinaj ta jtec' biq'uit ch'ixe. ");
INSERT INTO tzotze_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja' la sloq'ues tal ta Egipto li jmoltotactic ta vo'onee. La spas ep sq'uelubil stsatsal Dios tey ta Egipto banamil. Ts'acal to la spas noxtoc sq'uelubil stsatsal Dios tey ta Tsajal Nab. Xchi'uc noxtoc cha'vinic jabil la spas ep sq'uelubil stsatsal Dios tey ta xocol banamil. ");
INSERT INTO tzotze_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja' ono'ox Moisés ti jech laj yalbe li jmoltotactic ta vo'onee: “Li Diose ta to st'ujboxuc jun j'alc'op avu'unic. Ta st'uj jun jchi'iltic jech chac c'u cha'al la st'ujun. Xavich'beic me ta muc' li c'usi chayalboxuque”, xi ono'ox. ");
INSERT INTO tzotze_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ja' ono'ox Moisés ti tey xchi'uc ta xocol banamil scotol li jmoltotactic ta vo'onee. Li jmoltotactique tey la stsob sbaic ta yoc vits Sinaí. Li Moisese tey ic'opanat yu'un Dios. C'alal laj ya'i c'usi i'albat yu'un Diose, laj yalbe scotol li jmoltotactique. Ja' laj yalbe c'usi tsc'an Dios chaq'uic yu'un jech chcuxiic sbatel osile. Ja' ta sventa Moisés laj ca'itic ec li vu'utique. ");
INSERT INTO tzotze_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Li jmoltotactic ta vo'onee muc xich'ic ta muc' c'usi laj yal li Moisese, muc xch'unic. Tsc'an ta sutic batel yan velta ta Egipto banamil. ");
INSERT INTO tzotze_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jech laj yalbeic li Arone: “Pasbun cajsantocutic yu'un ja' ba'yucbe ta xbat cu'uncutic. Yu'un mu jna'cutic c'usi la spas li Moisés ti yoquel mu sut tale, ja' ti la sloq'uesuncutic tal ta Egiptoe”, xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jech lic spasic sloc'obbal jcot ch'ium tot vacax. La smilbeic smoton. Xcuxet no'ox yo'ntonic yu'un li c'usi pasbil ta sc'obique. ");
INSERT INTO tzotze_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jech icomtsanatic yu'un li Diose. Ja' i'ac'bat yich'ic ta muc' li c'usitic xojoban ta vinajele jech chac c'u cha'al ts'ibabil ono'ox ta svun li yaj'alc'op Dios ta vo'onee: Israeletic, c'alal laxanovic tal cha'vinic jabil ta xocol banamile, laj avac'bicun jmotonin li vacaxe xchi'uc li chije. Pero altic, yu'un mu junuc avo'ntonic ta jtojol. ");
INSERT INTO tzotze_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yu'un laj acuchic batel avajsantoic, Moloc sbi, tiq'uil batel ta sna pasbil ta nucul. Xchi'uc laj avich'ic batel li sloc'obbal c'anal apasojic ta avajsantoique, ja' li Renfán sbie. Ja' apasojic yu'un ja' chavich'ic ta muc'. Ta scoj ti jech chapasique jech chajtacoxuc loq'uel li' ta avosilalique. Tey chabatic ta jelovel Babilonia banamil, xi ono'ox ts'ibabil. ");
INSERT INTO tzotze_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’C'alal tey oyic ta xocol banamil li jmoltot jyame'tic ta vo'onee, ja' itun yu'unic li templo nucule yu'un ja' tey ic'opanatic yu'un li Diose. Li templo nucule ja' jech la spasic jech chac c'u cha'al i'ac'bat yil senyail yu'un Dios li Moisese. ");
INSERT INTO tzotze_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","C'alal i'ic'atic ochel tal yu'un Josué li' ta cosilaltique, laj yich'ic tal li templo nucule. Ja' o yorail laj yich' yosilic ti c'alal i'ac'bat smilic yu'un Dios li yajval to'ox cosilaltique. C'alal i'och ta ajvalilal li Davide, yoquel to ja' itun yu'unic li templo nucule. ");
INSERT INTO tzotze_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Li Davide lec i'ilat yu'un Dios. La sc'anbe Dios ti ac'o ac'batuc spasbe stemploe, ja' li Dios yu'un jmoltotic Jacove. ");
INSERT INTO tzotze_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero muc ja'uc la spas li Davide. Ja' la spas li xnich'one, ja' li Salomone. ");
INSERT INTO tzotze_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Li Diose mu xnaqui ta temploetic ti pasbil ta sc'ob cristianoetique. Li stuque nacal ta vinajel. Jech laj yal c'alal la xch'amanbe ye jun yaj'alc'op ta vo'one: ");
INSERT INTO tzotze_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Vu'un ta jpas mantal li' ta vinajel xchi'uc ta sbejel banamil. Jech ¿c'u yu'un chavalic ti chapasbicun jtemploe yu'un mu jna' jcux co'nton? ");
INSERT INTO tzotze_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Vu'un la jpas scotol li c'usitic oye, xi li Diose, xi li j'alc'ope. ");
INSERT INTO tzotze_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Li vo'oxuque toj tsots avo'ntonic. Co'ol avo'nton achi'uquic li boch'otic mu xotquinic Diose. Mu xac'an xava'yic li sc'op Diose. Scotol c'ac'al chacontrainic li Ch'ul Espíritue. Ja' jech chapasic ec jech chac c'u cha'al la spasic li amoltot ayame'ic ta vo'onee. ");
INSERT INTO tzotze_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Li amoltot ayame'ic ta vo'onee la scontrainic scotol li yaj'alc'optac Diose. La smilic li boch'otic laj yalic ti ta to xtal li boch'o tuc' yo'ntone. C'alal ital li boch'o tuc' yo'ntone, laj avaq'uic ta c'abal, laj amilic, ");
INSERT INTO tzotze_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","vo'oxuc ti ava'yojic li mantaletic ti laj yal yaj'almantaltac Dios ta vo'onee, pero mu xach'unic ―xut jchapanvanejetic li Estebane. ");
INSERT INTO tzotze_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","C'alal jech laj yal li Estebane, isoc o sjolic, tsots i'ilinic. Xc'uxet yeic ta sc'ac'al yo'ntonic yu'un chilintaic li Estebane. ");
INSERT INTO tzotze_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Li Estebane ventainbil yo'nton yu'un Ch'ul Espíritu jech la sq'uel muyel vinajel. Laj yilbe xojobal Dios. Laj yil noxtoc tey va'al ta sbats'ic'ob Dios li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Li Estebane jech laj yal: ―Jamal xa vinajel ta xquil. Tey oy ta sbats'ic'ob Dios ta xquil li Jesuse, ja' ti co'ol cristianoutic jchi'uctique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Li jchapanvanejetique chopol laj ya'yic jech tsots lic avanicuc. La smac xchiquinic yu'un mu sc'an xa'yic c'usi laj yal li Estebane, yu'un la snopic ti chopol cha'i Dios c'usi laj yal li Estebane. Jech scotolic la stsaquic ta ora li Estebane. ");
INSERT INTO tzotze_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Laj yiq'uic loq'uel ta pat lum. Tey laj yac'beic ton. Li boch'otic ta xaq'uic tone la sloc' xaquitaic. Laj yac'beic xchabi jun querem, Saulo sbi. ");
INSERT INTO tzotze_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","C'alal ja' o chac'beic tone, la sc'opan Dios li Estebane, jech laj yal: ―Cajval Jesús, ic'bun jch'ulel ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","La squejan sba, tsots i'avan, jech laj yalbe li Diose: ―Cajval, mu me xavac'be xcuch smulic li jchi'iltac li'i ―xi. C'alal laj yal jeche, icham. ");
INSERT INTO tzotze_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","C'alal laj yil Saulo ti icham Estebane, xcuxet xa yo'nton. Jech ta ora no'ox lic uts'intaaticuc li jch'unolajeletic tey tsobolic ta Jerusalene. Scotolic la spuc sbaic batel ta Judea banamil xchi'uc ta Samaria banamil. Ja' xa no'ox tey icomic ta Jerusalén li lajchab jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oy jayibuc viniquetic ti lec yich'ojic ta muc' Diose, ja' bat smuquic li Estebane. Ep laj yoc'taic. ");
INSERT INTO tzotze_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yan li Sauloe tsc'an ac'o lajuc sc'oplal li sc'op Jesús xch'unojique. I'ochan ta naetic, la stsacan loq'uel viniquetic xchi'uc antsetic, la stic'an ta chuquel. ");
INSERT INTO tzotze_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Li boch'otic la spuc sbaic batele buyuc no'ox la xcholic batel ti ja' no'ox chijcol ta sventa Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Li Felipee tey ic'ot ta jun lum tey ta Samaria banamil. Tey c'ot xcholbe ya'yic cristianoetic ti i'ay xa li boch'o t'ujbil yu'un Dios chiscoltautique, ja' li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Li cristianoetic tey ta lume la stsob sbaic scotolic yu'un tal ya'yic c'usitic chal li Felipee. C'alal laj yilic la spas ep sq'uelubil stsatsal Dios li Felipee, scotol yo'ntonic laj ya'yic li c'usitic laj yale. ");
INSERT INTO tzotze_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yu'un ep icolic li boch'otic ochem pucuj ta yo'ntonique. C'alal iloc' li pucujetique, tsots i'avanic. Icolic noxtoc li boch'otic aluben yacanique xchi'uc li coxoetique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jech xcuxet no'ox yo'ntonic scotol li cristianoetic tey ta lume. ");
INSERT INTO tzotze_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tey oy jun vinic, Simón sbi. Ja' j'ilol li Simone. Ep la slo'laan cristianoetic tey ta Samaria banamil yu'un laj yal ti stuc no'ox xu' yu'une. ");
INSERT INTO tzotze_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Scotol cristianoetic c'alal ta biq'uit ta muc' lec laj ya'yic c'usi laj yal li j'ilole. Jech laj yalic: ―Li vinic li'i ja' yich'ojbe stsatsal Dios ―xiic. ");
INSERT INTO tzotze_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ja' xa tey yac'oj o yo'ntonic ta ya'yel c'usi ta xal li j'ilole yu'un vo'one xa ilo'laatic. ");
INSERT INTO tzotze_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero c'alal icholbatic yu'un Felipe ti yorail xa xu' chventainbat yo'ntonic yu'un Diose, xchi'uc icholbatic noxtoc ti ja' Jcoltavanej cu'untic xchi'uc ti ja' Ajvalil cu'untic li Jesucristoe, oy ep viniquetic xchi'uc antsetic la xch'unic. Tey i'ac'bat yich'ic vo' yu'un li Felipee. ");
INSERT INTO tzotze_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Li Simone la xch'un ec. Tey laj yich' vo' ec, jech lic xchi'in batel li Felipee. C'alal laj yil Simón ti ep sq'uelubil stsatsal Dios la spas li Felipee, toj labal sba laj yil. ");
INSERT INTO tzotze_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","C'alal laj ya'yic jcholc'opetic tey ta Jerusalén ti laj xa xch'unic sc'op Dios li samáriaetique, jech la staquic batel ta Samaria banamil li Pedro xchi'uc Juane. ");
INSERT INTO tzotze_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","C'alal ic'otique, la sc'opanbeic Dios ta stojol li jch'unolajeletique ti ac'o yich'ic ec li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yu'un mu'yuc to yich'ojic li Ch'ul Espíritue, ja' no'ox yich'ojic vo' ta scoj li Cajvaltic Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Li Pedro xchi'uc Juane lic yac' sc'obic ta sjol li jujun jch'unolajeletique jech ivul ochuc ta yo'ntonic li Ch'ul Espíritue. ");
INSERT INTO tzotze_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","C'alal laj yil Simón ti laj yich'ic Ch'ul Espíritu jch'unolajeletic c'alal laj yac' sc'obic li jcholc'opetique, tey xa chac yac'be ya'i taq'uin li jcholc'opetique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Jech laj yal: ―Ac'bicun jech jvu'el ec yu'un jech xu' ta xich'ic Ch'ul Espíritu cu'un li boch'otic ta xcac' jc'ob ta sjolique ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Li Pedroe jech laj yalbe: ―Batan ta ch'ayel achi'uc ataq'uin yu'un chanop ti oy ta manel li Ch'ul Espíritu chijyac'butic Diose. ");
INSERT INTO tzotze_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Li vo'ote mu xu' cha'abtej yu'un Dios. Mu aventauc yu'un muc tuc'uc avo'nton ta stojol. ");
INSERT INTO tzotze_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Comtsano li c'usi chopol laj anope. C'opano Dios, jq'ueltiquic me cha'ac'bat perdón yu'un li c'usi chopol laj anope. ");
INSERT INTO tzotze_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yu'un ta to xac'upin c'usi chopol ta xquil. Chucbilot to yu'un mulil ta xquil ―xut li Pedroe. ");
INSERT INTO tzotze_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Itac'ov li Simone: ―C'opanbicun Dios ta jtojol yu'un naca me ch'ayel chibat jech chac c'u cha'al laj avalbune ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","C'alal ilaj yo'ntonic ta yalbel jch'unolajeletic scotol ti c'u x'elan yilojbeic stsatsal Diose, xchi'uc c'alal laj yo'ntonic ta yalel li sc'op Diose, isutic batel ta Jerusalén li Pedro xchi'uc Juane. Tey i'ech' xcholic noxtoc sc'op Jesús ta tsobtsobnaetic ta yosilal samáriaetic. ");
INSERT INTO tzotze_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","C'alal ta xa x'epaj li jch'unolajeletic tey ta Samariae, li Felipee ital c'opanatuc yu'un jun yaj'almantal Cajvaltic. Jech i'albat: ―Batan ta stuq'uil sur. Tey ta xc'ot anup li sbelal lum Gaza tey xlic tal ta Jerusalene ―x'utat. Li sbelal Gazae ja' tey x'ech' ta xocol banamil. ");
INSERT INTO tzotze_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jech ibat li Felipee. C'alal ixanov batele, tey la sta ta be jun etiopía vinic. Li vinique pasbil ta capón yu'un ja' yich'oj yabtel yu'un ajvalil ants tey ta Etiopía banamil. Candáce sbi li antse. Li capón vinique ja' yabtel ta xchabibe staq'uin xchi'uc scotol c'usitic oy yu'un li ajvalil antse. Li vinique i'ay yac' ta chic'bel smoton Dios ta Jerusalén. ");
INSERT INTO tzotze_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Sutel xa batel ta yosilal. Tey chotol batel ta scarreta nitbil ta ca'. Tey chapta c'usi ts'ibabil ta sc'op Dios yu'un j'alc'op Isaías. ");
INSERT INTO tzotze_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Li Felipee jech i'albat yu'un li Ch'ul Espíritue: ―Noch'ajan batel, bat chi'ino li vinic le' tiq'uil ta scarretae ―x'utat. ");
INSERT INTO tzotze_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Li Felipee la snuts batel ta anil li vinique. Laj ya'i ti tey chapta li sc'op Dios ts'ibabil yu'un j'alc'op Isaías ta vo'onee. Li Felipee jech la sjac'be li vinique: ―¿Me chava'ibe smelol li c'usi chaq'uele? ―xut. ");
INSERT INTO tzotze_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Itac'ov li vinique: ―Mu xca'ibe smelol yu'un mu'yuc boch'o chiyalbun ca'i ―xi. Jech tey i'ic'at ochel li Felipee. La xchi'in ta chotlej li vinique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Li sc'op Dios ta sq'uele jech chal: Ta x'ac'at ta milel jech chac c'u cha'al jcot ch'ium chij pero mu'yuc c'usi ta xal. Jech chac c'u cha'al ch'ium chij ti ch'an xi c'alal ta xich' loc'bel stsotsile. Ja' no'ox jech ec li boch'o ta to xtal stojbutic jmultique, mu'yuc c'usi ta xal. ");
INSERT INTO tzotze_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ep ta x'ac'bat yich' vocol yu'un mu tuc'uc ta xich' chapanel. Tsnopic ti mu'yuc xnich'on ta xcom c'alal ta smilique. J'ech'el ta x'ul o yalojic, xi ta xal li sc'op Dios ta xapta li vinique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Li vinique jech la sjac'be li Felipee: ―Albun ca'i boch'o sc'oplal ti li' ts'ibabil comele. ¿Me ja' sc'oplal stuc laj yal li Isaíase o me yan boch'o sc'oplal laj yalbe? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Li Felipee laj yalbe ya'i ti ja' sc'oplal li Jesuse. Jech lic xcholbe ya'i scotol c'u x'elan sc'oplal li Jesuse. ");
INSERT INTO tzotze_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ixanovic batel ta be, tey ijelovic ta ts'el vo'. Jech laj yal li vinique: ―Q'uelavil, oy vo' li'i. ¿Me mu xu' chavac'bun quich' vo'? ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Itac'ov li Felipee: ―Me ach'unoj ta scotol avo'ntone, xu' chavich' vo' ―xi. Itac'ov li vinique: ―Jch'unoj ti ja' Xnich'on Dios li Jesucristoe ―xi. ");
INSERT INTO tzotze_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Li vinique la spas mantal ti ac'o cotiuc li scarretae. Jech iloq'uic, ibatic ta vo' xchibalic. Li Felipee laj yac'be yich' vo' li vinique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","C'alal iloq'uic tal ta vo'e, li Felipee i'ic'at batel yu'un Ch'ul Espíritu ti junic xchi'uc Cajvaltique. Li vinique muc xil ibat li Felipee. Pero xcuxet no'ox yo'nton isut batel ta slumal yu'un laj xa xch'un li Cajvaltique. ");
INSERT INTO tzotze_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Li Felipee tey to ic'ot vinajuc ta lum Azoto. Tey lic xanovuc batel ta yacan. Tey ech' xchol sc'op Jesús ta jujun lum c'alal to ic'ot ta lum Cesarea. ");
INSERT INTO tzotze_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pero li Sauloe mu xlaj yo'nton ta scontrainel li boch'otic xch'unojic Cajvaltique. Yu'un tsc'an tsmil ti me mu scomtsanic xch'unel li Cajvaltique. Jech bat sc'opan li más banquilal pale tey ta Jerusalene. ");
INSERT INTO tzotze_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","La sc'anbe svunal ta sventa ti oy lec stsatsal c'alal chc'ot yac'be sq'uel li boch'otic sventainojic li nail tsobobbailetic yu'un israeletic tey ta lum Damascoe. Yu'un chbat sq'uel me oy boch'otic xch'unojic Cajvaltic ti tey oy ta nail tsobobbail yu'unique. Me viniquetic, me antsetic, sc'oplal ta xchucan, ta xic' tal ta Jerusalén. C'alal laj xa yich'be lec svunale, ibat ta Damasco. ");
INSERT INTO tzotze_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","C'alal jutuc xa'ox sc'an xc'ot ta Damascoe, ta ora oy c'usi xleblej tal ta vinajel, joyibtabil ic'ot li Sauloe. ");
INSERT INTO tzotze_vpl VALUES ("AC