﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzotzc_vpl;
CREATE TABLE tzotzc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzotzc_vpl WRITE;
INSERT INTO tzotzc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ti biiletic liꞌe, jaꞌ sbitac ti smolmucꞌtotac ti Jesucristoe, snitilul ti Davide, snitilul ti Abrahame. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ti snichꞌon ti Abrahame Isaac. Ti Snichꞌon ti Isaaque Jacob. Ti snichꞌnab ti Jacobe Judá schiꞌuc schiꞌiltac ta voqꞌuel. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ti snichꞌnab ti Judae Fares schiꞌuc Zara. Ti Farese schiꞌuc ti Zarae, jaꞌ Tamar sbi ti smeꞌe. Ti snichꞌon ti Farese Esrom. Ti snichꞌon ti Esrome Aram. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ti snichꞌon ti Arame Aminadab. Ti snichꞌon ti Aminadabe Naasón. Ti snichꞌon ti Naasone Salmón. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ti snichꞌon ti Salmone Booz. Ti Booze, jaꞌ Rahab sbi ti smeꞌe. Ti snichꞌon ti Booze Obed. Ti Obede, jaꞌ Rut sbi ti smeꞌe. Ti snichꞌon ti Obede Isaí. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ti snichꞌon ti Isaie David. Ti ajvalil Davide schiꞌuc ti jun ants ti yajnil to ox ti Uríase, jaꞌ tey iꞌayan tal ti Salomone. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ti snichꞌon ti Salomone Roboam. Ti snichꞌon ti Roboame Abías. Ti snichꞌon ti Abíase Asa. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ti snichꞌon ti Asae Josafat. Ti snichꞌon ti Josafate Joram. Ti snichꞌon ti Jorame Uzías. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ti snichꞌon ti Uzíase Jotam. Ti snichꞌon ti Jotame Acaz. Ti snichꞌon ti Acaze Ezequías. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ti snichꞌon ti Ezequíase Manasés. Ti snichꞌon ti Manasese Amón. Ti snichꞌon ti Amone Josías. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ti snichnab ti Josíase Jeconías schiꞌuc schiꞌiltac ta voqꞌuel. Jaꞌ o yorail ti chucbil ibatic ta Babilonia banomil ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tsꞌacal to un, inichꞌnaj ti Jeconíase, Salatiel sbi. Ti snichꞌon ti Salatiele Zorobabel. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ti snichꞌon ti Zorobabele Abiud. Ti snichꞌon ti Abiude Eliaquim. Ti snichꞌon ti Eliaquime Azor. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ti snichꞌon ti Azore Sadoc. Ti snichꞌon ti Sadoque Aquim. Ti snichꞌon ti Aquime Eliud. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ti snichꞌon ti Eliude Eleazar. Ti snichꞌon ti Eleazare Matán. Ti snichꞌon ti Matane Jacob. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ti snichꞌon ti Jacobe José, smalal ti Maríae, smeꞌ ti Jesuse, ti jaꞌ Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Laj echꞌuc chanlajunchop (14) totil meꞌiletic ti lic tal ta stojol ti Abrahame, icꞌot ta stojol ti Davide. Jaꞌ jech xtoc laj echꞌuc chanlajunchop (14) totil meꞌiletic ti lic tal ta stojol ti Davide, icꞌot cꞌalal to ti jꞌisraeletic chucbil ibatic ta mucꞌ ta jteclum Babiloniae. Jaꞌ jech xtoc ti cꞌalal chucajtic ta Babiloniae, laj to echꞌuc chanlajunchop (14) totil meꞌiletic cꞌalal ivocꞌ ti Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jaꞌ jech sꞌelan ivocꞌ ti Jesucristoe. Jacꞌbil xa yuꞌun José ti Maríae, smeꞌ ti Jesuse. Cꞌalal muꞌyuc to ta xicꞌ sbaique, schiꞌuc xa yol ti Maríae ta sventa smucꞌul stsatsal ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ti Josee lequil vinic. Mu scꞌan ta xacꞌ ta qꞌuexlal ti Maríae. Ta scꞌan ta scomtsan yaꞌi ta mucul. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cꞌalal jech ta snope, tal jun yajꞌángel ti Dios ti laj yil ta svayiche ti jech iꞌalbate: ―José, snitilulot ti ajvalil Davide, mu xloꞌilaj avoꞌnton. Icꞌo ti Maríae. Yuꞌun ti yol schiꞌuque, jaꞌ ta sventa smucꞌul stsatsal ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ti Maríae ta svoqꞌues jun querem. Jesús ta xavacꞌbe sbi. Jech ta xavacꞌbe sbi, yuꞌun jaꞌ ta scolta ti schiꞌiltac yuꞌun ti smulique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ti jech icꞌot ta pasel taje, yoꞌ ta xcꞌot ta pasel ti cꞌusi laj yal ti Dios ti laj stsꞌiba comel ti jun yajꞌalcꞌope: ");
INSERT INTO tzotzc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ti tojol tsebe ta xchiꞌin yol. Ta xꞌayan jun squerem. Emanuel ta sbiin. Ti smelole, Dios ta xchiꞌinotic, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cꞌalal ijulav ti Josee, laj xchꞌun jech chac cꞌu chaꞌal iꞌalbat yuꞌun ti yajꞌángel Diose. Laj yicꞌ ti Maríae. ");
INSERT INTO tzotzc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Acꞌo mi mu to laj xchiꞌin sbaic, laj svoqꞌues ti yole. Ti Josee laj yacꞌbe sbi Jesús. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ti Jesuse ivocꞌ ta jteclum Belén ti ta Judea banomile. Jaꞌ o tiqꞌuil ta ajvalil ti Herodese ti ta jteclum taje. Talic ta Jerusalén bijil viniquetic ti liquemic talel ta sloqꞌueb cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tey lic sjacꞌbeic ti ajvalile: ―¿Bu oy ti ajvalil yuꞌun ti jꞌisraeletic ti ivocꞌ xae? Yuꞌun laj xa quilcutic scꞌanalil ti ta jlumalcutique. Jaꞌ yuꞌun un, tal quichꞌcutic ta mucꞌ ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cꞌalal jech laj yaꞌi ti ajvalil Herodese, lic ta vul oꞌnton. Pero maꞌuc noꞌox. Jaꞌ jech xtoc oyic ta vul oꞌnton scotol ti jnaclejetic ta Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jech o xal ti ajvalil Herodese laj stac ta iqꞌuel scotol ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. Jech lic sjacꞌ: ―Albun caꞌi, ¿bu ta xvocꞌ ti Cristoe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jech laj staqꞌuic: ―Ta xvocꞌ ta jteclum Belén liꞌ ta Judea banomile. Yuꞌun jech laj stsꞌiba comel ti yajꞌalcꞌop Diose: ");
INSERT INTO tzotzc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ti voꞌote jteclum Belén ti liꞌ oyot ta Judea banomile, maꞌuc pequel acꞌoplal ta xacꞌot jech chac cꞌu chaꞌal ti ajvaliletic ta jteclum liꞌe. Yuꞌun ta xvul ta loqꞌuel ta atojol jun ajvalil ti ta xchabi li jnichꞌnab Israele, xi ti scꞌop Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jech o xal ti Herodese ta mucul laj sta ta iqꞌuel ti bijil viniquetique. Tey lic sjacꞌbe ti cꞌusi lec ora ivinaj ti cꞌanale. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jaꞌ yuꞌun un, laj stac batel ta Belén ti bijil viniquetique. Jech laj yalbe: ―Batanic tey un chaꞌe. Tꞌunic lec ti olol taje. Cꞌalal mi laj ataique, xtal avalbeicun yoꞌ jech chba quichꞌ ta mucꞌ ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cꞌalal jech laj yal ti ajvalile, jech ti bijil viniquetique ibatic. Jaꞌ o laj yacꞌ sba iluc yan velta ti cꞌanal ti laj yilic to ox ta slumalique. Jbaꞌbe batel ti cꞌanale. Tey paj ti bu oy stuqꞌuil ti olole. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cꞌalal jech laj yilic ti bijil viniquetic ti paj ti cꞌanale, xmuyubajic xa. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cꞌalal jech iꞌochic bal ta nae, tey laj yilic ti olole schiꞌuc ti smeꞌe, jaꞌ ti Maríae. Jech ti stuquique laj squejan sbaic. Laj yichꞌic ta mucꞌ ti olole. Tsꞌacal to laj sjamic ti scaxaique. Laj yacꞌbeic smoton, jaꞌ ti cꞌanal taqꞌuine, ti pome, schiꞌuc ti momol ti mirra sbie. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsꞌacal to un, bijubtasatic ta svayichic ti bijil viniquetique ti mu xa xꞌechꞌic ta stojol ti ajvalil Herodese. Jaꞌ yuꞌun un, isutic batel ta yan o be ti cꞌalal ibatic ta slumalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cꞌalal ibatic ti bijil viniquetique, jaꞌ o ital yajꞌángel ti Diose ti jech iꞌalbat ta svayich ti Josee: ―Lican, batan, icꞌo batel ti olole schiꞌuc ti smeꞌe. Jatavanic batel cꞌalal ta mucꞌ ta jteclum Egipto. Comanic tey jaꞌ to ti mi vuꞌun ta xcalbot avaꞌi ti ta xalocꞌ batele. Yuꞌun ti ajvalil Herodese ta saꞌ ti olole yuꞌun ta smil yaꞌi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jech ti Josee tey lic. Laj yicꞌ batel ti olole schiꞌuc ti smeꞌe. Tey iloqꞌuic bal ta acꞌobaltic cꞌalal to Egipto. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tey oyic cꞌalal icham ti ajvalil Herodese. Ti jech icꞌot ta pasele, yoꞌ ta xcꞌot ta pasel ti cꞌusi yaloj onoꞌox ti Dios ti laj stsꞌiba comel ti yajꞌalcꞌope: “Vuꞌun ta xquicꞌ talel ti Jnichꞌon ti oy ta Egiptoe”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cꞌalal laj yil ti ajvalil Herodese ti ilaj ta loꞌlael yuꞌun ti bijil viniquetique, icap ti sjole. Jech o xal laj yal mantal ti acꞌo yichꞌ milel scotol ti ololetic ti yichꞌojic chib jabile schiꞌuc cꞌalal to jvoqꞌuel ololetic ti oyic ta jteclum Belene, schiꞌuc ti cꞌu yepal joyol ta spat xocone. Jaꞌ ba scoꞌoltas talel ti ajvalil Herodese ti cꞌusi ora laj yalic ti bijil viniquetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ti jech laj spas ti ajvalil Herodese, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal laj stsꞌiba comel ti yajꞌalcꞌop Dios Jeremíase: ");
INSERT INTO tzotzc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Oy buchꞌu xꞌavet ta Ramá banomil. Ta xꞌocꞌ. Mu xꞌech ti vocol ta xaꞌie. Jaꞌ ti Raquele ta xoqꞌuita ti yalabe. Mi jaꞌuc scꞌan patbel yoꞌnton, jaꞌ ti cham xae, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cꞌalal icham ti ajvalil Herodese, jaꞌ o tal jun yajꞌángel ti Diose, ti jech iꞌalbat ta svayich ti José ti ta Egiptoe: ");
INSERT INTO tzotzc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Lican, icꞌo batel ti olole schiꞌuc ti smeꞌe. Sutanic batel ta slumal Israel. Yuꞌun ti buchꞌu ta smil yaꞌi ti olole chamic xa ―xi ti ángele. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jech ti Josee ilic, laj yicꞌ batel ti olole schiꞌuc ti smeꞌe. Ibatic cꞌalal to slumal Israel. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cꞌalal laj yaꞌi ti Josee ti jaꞌ ochem ta ajvalil ta Judea banomil ti Arquelaoe, ti jaꞌ laj sqꞌuexolin ti stote, ixiꞌ ti jech ta xbate. Pero iꞌacꞌbat yil ta svayich yan velta ti tey ta xbat ti ta Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cꞌalal jech icꞌotic ta Galileae, tey bat naclicuc ta Nazaret. Ti jech taje, yoꞌ ta xcꞌot ta pasel jech chac cꞌu chaꞌal laj yalic ti jꞌalcꞌopetique, yoꞌ jech ta sbiin Nazareno ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti jech yorail taje, jaꞌ o ivul ta loqꞌuel ta yalel scꞌop Dios ti Juan jꞌacꞌ-ichꞌ-voꞌ ta xocol banomil ti ta Judea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jech laj yal: ―Ictaic ti toj chopol avoꞌntonique. Yuꞌun nopol xa yorail ti ta xventainvan ti Dios ti oy ta vinajele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti Juan taje, jaꞌ ti buchꞌu jech tsꞌibabat scꞌoplal yuꞌun ti jꞌalcꞌop Isaíase: Oy buchꞌu tsots ta xcꞌopoj ta xocol banomil ti jech ta xale: “Jambeic tuqꞌuil be ti Cajvaltique. Meltsanbeic lec sbe”, ti xie, xi ti Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Meltsanbil ta stsotsil camello scꞌuꞌ ti Juane. Nucul ti schuque. Jaꞌ jech xtoc ti sveꞌele, cꞌulub schiꞌuc ti teꞌtical ajapome. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ti jnaclejetic ta Jerusalene, ti ta sjoylej Judea banomile, ti nopol ta ucꞌum Jordane, ta xtalic yaꞌibeic scꞌop li Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cꞌalal jamal ta xalic ti smulique, jech ti Juane ta xacꞌbe yichꞌ voꞌ tey ta ucꞌum Jordán. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jech laj yal ti Juane ti cꞌalal laj yil ti ep ta xtalic ti jfariseoetique schiꞌuc ti jsaduceoetique ta yichꞌel ti voꞌe: ―Snichꞌnab jtiꞌval chon, ¿buchꞌu laj yalboxuc avaꞌiic ti ta xapoj abaic yuꞌun ti tsots castigo ti ta xa xtale? ");
INSERT INTO tzotzc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lecuc ti cꞌusi ta xapasique yoꞌ jech ta xvinaj ti jeltajem ti avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Maꞌuc noꞌox ta xavalolanbe abaic ti snitiluloxuc ti Abrahame. Yuꞌun ta xcalboxuc avaꞌiic, ti Diose xuꞌ ta sjoybin ta snitilultac Abraham ti tonetic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yuꞌun chapal xa ti eqꞌuele ti ta sboj ti teꞌe schiꞌuc ti yibele. Scotol ti teꞌetic ti muꞌyuc lec ta xacꞌ ti sate, ta xichꞌ bojel. Ta xichꞌ chiqꞌuel ta cꞌocꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ta melel, ta xcacꞌboxuc avichꞌic voꞌ. Pero batsꞌi voꞌ noꞌox ti jaꞌ señail ti jeltajem ti avoꞌntonique. Pero ti Buchꞌu tsꞌacal pat xtal cuꞌune, jaꞌ ta xacꞌboxuc avichꞌic ti Chꞌul Espíritu ti cꞌocꞌ sꞌelane. Ti Buchꞌu ta patil xtal cuꞌune, jaꞌ jelavem smucꞌul ti stuque. Yan ti vuꞌune chꞌabal cꞌusi xuꞌ cuꞌun, mi jaꞌuc ta yichꞌbel batel ti xonobe, jaꞌ ti muꞌyuc jlequilal ta stojole. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ti Buchꞌu ta patil xtal cuꞌune stsacoj xa ti yicꞌaobil trigoe. Ta stꞌujbe loqꞌuel ti scꞌaꞌepale yoꞌ stuc xa ti trigo ta xcome. Ti trigo ti tꞌujbil xae ta sqꞌuej ta yavil. Yan ti scꞌaꞌepale ta xichꞌ chiqꞌuel ti bu mu xtub ti cꞌoqꞌue ―xi ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ti Jesuse ilocꞌ batel ti ta Galilea banomile. Icꞌot ta ucꞌum Jordán yoꞌ ta xꞌacꞌbat yichꞌ voꞌ yuꞌun ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ta sliquebale mu scꞌan ti Juane ti ta xacꞌbe yichꞌ voꞌ ti Jesuse. Jech o xal jech laj yal: ―Voꞌot ta xavacꞌbun quichꞌ voꞌ ti jechuque. Leꞌ une, voꞌot latal ta jtojol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ti Jesuse jech laj stacꞌ: ―Maꞌuc ta xcaltic leꞌe. Jaꞌ lec, laꞌ jpastic scotol ti cꞌusi ta scꞌan ti Diose ―xi. Jech ti Juane laj xchꞌun. Laj yacꞌbe yichꞌ voꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cꞌalal jech laj yichꞌ voꞌ ti Jesuse, ta ora noꞌox ijam ti vinajel ti cꞌalal ilocꞌ tal ta voꞌe. Jech ti Jesuse laj yil ti Chꞌul Espíritu yuꞌun ti Diose, ti coꞌol sꞌelan jcot ta paloma ta xyal talel ta stojole. ");
INSERT INTO tzotzc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jaꞌ o ivinaj ti oy Buchꞌu icꞌopoj talel ta vinajel ti jech ta xale: ―Leꞌe, jaꞌ Jnichꞌon ti cꞌux ta xcaꞌie, ti ximuyubaj yuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tsꞌacal to un, ti Jesuse iꞌicꞌat batel yuꞌun ti Chꞌul Espíritu ta xocol banomile, yoꞌ jech ta xlajeltsabat yoꞌnton yuꞌun ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chaꞌvinic (40) cꞌacꞌal, chaꞌvinic (40) acꞌobal muꞌyuc xveꞌ ti Jesuse. Tsꞌacal to un, lic yaꞌi viꞌnal. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jech ti pucuje inopaj batel ta stojol ti Jesuse yoꞌ ta slajeltsabe yoꞌnton ti jech laj yale: ―Mi ta melel Snichꞌonot ti Diose, paso ta mantal ti tonetic liꞌe ti acꞌo joybijuc ta pane ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ti Jesuse jech laj stacꞌ: ―Ti scꞌop Diose jech ta xal: “Maꞌuc noꞌox ta pan ta xcuxi ti vinique. Jaꞌ ta xcuxi o ta sventa jujubel ti cꞌusi ta xal ti scꞌop Diose”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jech ti pucuje laj yicꞌ batel ti Jesús ti ta chꞌul jteclum Jerusalene. Laj yicꞌ muyel ta sjol ti temploe. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jech lic yal: ―Mi ta melel Snichꞌonot ti Diose, jipo aba yalel liꞌe. Yuꞌun ti scꞌop Diose jech ta xal: “Ti Diose ta xalbe mantal ti yajꞌángeltaque yoꞌ ta xchabiot. Ta xicꞌot yalel ta scꞌob yoꞌ jech mu xyayij avacan ta ton”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ti Jesuse jech laj stacꞌ: ―Jech ta xal xtoc ti scꞌop Diose: “Mu xalajeltsabe yoꞌnton ti Cajvaltic Dios avuꞌune”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yan to velta ti pucuje laj yicꞌ batel ta jun toyol vits. Tey laj yacꞌbe yil yutsilal slequilal scotol li mucꞌtiquil lume. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jech laj yal: ―Ti mi ta xaquejan aba ta yichꞌelun ta muqꞌue, ta xcacꞌbot avuꞌunin scotol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ti Jesuse jech laj yal: ―Batan, Pucuj. Yuꞌun ti scꞌop Diose jech ta xal: “Ichꞌo ta mucꞌ ti Dios avuꞌune. Jaꞌ noꞌox acꞌo aba ta tunel yuꞌun”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jech o xal un, ti pucuje laj xchꞌac sba batel ta stojol ti Jesuse. Tey talic ángeletic. Tal scoltaic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cꞌalal laj yaꞌi ti Jesús ti tiquil ta chuquel ti Juane, ibat ta Galilea. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero mu teyuc icom ta Nazaret jteclum. Bat nacluc ta jteclum Capernaum ti oy ta tiꞌ nabe, ti oy ta yosilal ti Zabulone, ti Neftalie. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ti jech ibat teye, yoꞌ ta xcꞌot ta pasel ti cꞌu sꞌelan laj stsꞌiba comel ti jꞌalcꞌop Isaías ti jech laj yale: ");
INSERT INTO tzotzc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ti yosilal ti Zabulone, ti Neftalie jaꞌ tey ta xꞌechꞌ ti be ti ta xcꞌot ta nabe, ti oy ta jot ucꞌum Jordán ti oy ta sloqꞌueb cꞌacꞌale, ti jaꞌ Galilea sbi xtoque, ti bu nacalic ti jyanlum cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Scotol ti jnaclejetic teye, ti oyic ta icꞌal osile, jaꞌ to tey laj yilic ti saquilal osile. Ti buchꞌutic ti oyic ta squeoval ti lajebale tey icꞌot ta stojolic ti saquilal osile, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jaꞌ o yorail lic sliques yabtel ti Jesuse ti jech laj yale: ―Ictaic ti jech chopol avoꞌntonique. Yuꞌun nopol xa yorail ti ta xventainvan ti Dios ti oy ta vinajele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cꞌalal ta xanav batel ta stiꞌil nab Galilea ti Jesuse, jaꞌ o laj yil chaꞌvoꞌ viniquetic ti yitsꞌin sbanquil sbaique. Ti june, Simón sbi. Jaꞌ Pedro ti yan sbi xtoque. Ti june, Andrés. Jaꞌ yabtelic ti tsac choye. Jaꞌ o tey ta sjipic ochel ta nab ti stsacobil schoyique. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jech ti Jesuse jech laj yalbe: ―Laꞌ chiꞌinicun. Yuꞌun ta xcacꞌ yan avabtelic ta yiqꞌuel talel cristianoetic ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jech ti stuquique ta ora noꞌox laj yictaic comel ti stsacobil schoyique. Ibatic schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cꞌalal jech snatil ixanav batel ti Jesuse, jaꞌ o tey laj yil yan chaꞌvoꞌ viniquetic ti yitsꞌin sbanquil sbaique. Ti june, Jacobo. Ti june, Juan, ti jaꞌ snichꞌnabtac ti Zededeoe. Oyic ta yut barco schiꞌuc ti stotique. Yacalic ta stsꞌisel ti stsacobil schoyique. Ti Jesuse tey laj yicꞌ talel. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ti cꞌalal jech laj yaꞌiique, ta ora noꞌox laj yictaic comel ti sbarcoique, ti stotique. Laj xchiꞌinic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ti Jesuse, ti cꞌalal ta xanav batel ta scotol Galilea banomile, ta xꞌechꞌ chanubtasvanuc ta jujun chꞌul naetic ti buyuc noꞌoxe. Jaꞌ ta xalbe scꞌoplal ti ventainel yuꞌun ti Diose. Jech xtoc ta scoles ti cꞌusiuc noꞌox chamelal ta xaꞌiic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Cꞌalal laj yaꞌibeic scꞌoplal Jesús ti jnaclejetic ta Siria banomile, laj yiqꞌuic talel ti cꞌusiuc noꞌox chamelal ta xaꞌiique, ti ch-avan ti sjol sbaquilique, ti ch-ilbajinatic yuꞌun ti pucuje, ti jtub-iqꞌuetique, ti pasemic ta mochꞌe. Scotol ti jchameletique colic ta sventa ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ep ti cristianoetic laj stsꞌacliic batel ti Jesuse, ti liquemic tal ta Galilea banomile, ti liquemic tal ta Decápolise, ti liquemic tal ta Jerusalene, ti liquemic tal ta Judeae, ti liquemic tal ta sloqꞌueb cꞌacꞌal ti oy ta jot ucꞌum Jordane. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cꞌalal laj yil ti epal cristianoetic ti Jesuse, tey imuy batel ta vits. Tey ichoti. Jech ti yajchancꞌoptaque tey inopajic tal ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jech ti Jesuse jech lic chanubtasvanuc: ");
INSERT INTO tzotzc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Yan yutsilic ti buchꞌutic ta xaꞌiic ti chꞌabal yutsilal yoꞌntonique. Jaꞌ ta xꞌacꞌbat yichꞌic ti ventainel yuꞌun ti Dios ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Yan yutsilic ti buchꞌutic oyic ta at oꞌntone. Jaꞌ ta xpatbat yoꞌntonic yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Yan yutsilic ti buchꞌutic ta sbicꞌtajes sbaique. Jaꞌ ta xꞌacꞌbat sventainic ti banomil ti yaloj onoꞌox ti Dios ti ta xaqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Yan yutsilic ti buchꞌutic ti coꞌol sꞌelan viꞌnal taqui tiꞌil ta xaꞌiic ta spasel ti cꞌusi ta scꞌan ti Diose. Jaꞌ ta xcoltaatic ta spasel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Yan yutsilic ti buchꞌutic oy scꞌuxul yoꞌntonic ta stojol ti yane. Jaꞌ ta xcꞌuxubinatic yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Yan yutsilic ti buchꞌutic lecubtasbil ti yoꞌntonique. Jaꞌ ta xilic ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Yan yutsilic ti buchꞌutic ta xaqꞌuic persa ta spajesel ti cꞌope. Jaꞌ ta sbisatic ta snichꞌnab ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Yan yutsil ti buchꞌutic ta xichꞌic ilbajinel ta spasel ti cꞌusi ta scꞌan ti Diose. Jaꞌ ta xꞌacꞌbat yichꞌic ti ventainel yuꞌun ti Dios ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yan avutsilic ti voꞌoxuque ti cꞌalal ta xayilbajinoxuc, ta xaschopol-cꞌoptaoxuc ti cristianoetique, ti cꞌusiuc noꞌox ta xasaꞌboxuc amulic ti ta jventae. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muyubajanic. Junuc avoꞌntonic. Yuꞌun ta xavichꞌic ti mucꞌ ta matanal ti tey ta vinajele. Yuꞌun jech onoꞌox laj yichꞌic ilbajinel ti yajꞌalcꞌoptac ti Diose ti cꞌalal muꞌyucoxuc to oxe. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Atsꞌamoxuc aꞌelanic ta stojol ti cristianoetique. Pero mi ta xchꞌay schiꞌil ti atsꞌame, ¿mi xuꞌ to ta xtun yan velta? Muꞌyuc xa cꞌusi xtun o. Jaꞌ noꞌox ta xichꞌ jipel loqꞌuel. Acꞌo lajuc ta teqꞌuel. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Luzoxuc aꞌelanic ta stojol ti cristianoetique. Yuꞌun ti jun jteclum ti oy ta jol vitse, mu stacꞌ snacꞌ sba. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mu yuꞌunuc ta jtsantic jun lampara ti chba jnacꞌtic ta yolon caxae. Ti lampara ti ta jtsantique, ta jcajantic ta toyol yoꞌ ta xilic saquilal ti buchꞌutic oyic ta nae. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jaꞌ jech ti voꞌoxuc eque, acꞌo vinajuc ti xojobal aluzic ta stojol ti cristianoetique. Cꞌalal ta xilic ti lec ti cꞌusitic ta xapasique, jech ti stuquique ta xlequil-cꞌopojic ta stojol ti Dios avuꞌunic ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Mu xanopic ti lital jchꞌayesbe scꞌoplal smantal ti Moisese schiꞌuc ti cꞌu sꞌelan ichanubtasvanic ti yajꞌalcꞌoptac ti Diose. Ti jech litale, jaꞌ tal jvinajesbe ti batsꞌi smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta melel ta xcalboxuc avaꞌiic, ti cꞌu sjalil oy ti banomile, ti vinajele, muꞌyuc ta xichꞌ chꞌayesel jbeluc ti mantale, jaꞌ to ti mi cꞌot ta pasel scotol ti cꞌusi ta onoꞌox xcꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jech o xal un, buchꞌuuc noꞌox ti mu xacꞌ ta venta ti cꞌusiuc noꞌox mantale, acꞌo mi mu tsotsuc ti scꞌoplale, jech xtoc ti mi jech ta xchanubtasvan taje, peqꞌuel scꞌoplal ta xcꞌot ti bu ta xventainvan ti Dios ti oy ta vinajele. Pero buchꞌuuc noꞌox ti ta xacꞌ ta venta ti mantale, ti jech ta xchanubtas ti yan xtoque, cajal scꞌoplal ta xcꞌot ti bu ta xventainvan ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta xcalboxuc avaꞌiic, mi mu xapasic ti cꞌusi ta scꞌan ti Diose, ti mi jaꞌ noꞌox ta xapasic jech chac cꞌu chaꞌal ta spasic ti jfariseoetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, mu chaꞌbeluc xuꞌ ta xaꞌochic bu ta xventainvan ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ti voꞌoxuque avaꞌbinojic ti jech iꞌalbatic ti amolmucꞌtotique: “Mu xamilvan. Yuꞌun ti buchꞌu ta xmilvane ta xichꞌ chapanel”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ti vuꞌune ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti xtiꞌet sjol yuꞌun ti schiꞌile, ta xichꞌ chapanel. Buchꞌuuc noꞌox ti ta xalbe ti mu xatun xut ti schiꞌile, ta xichꞌ chapanel ta stojol ti banquilal jchapanvanejetique. Buchꞌuuc noꞌox ti ta xalbe bolat ti schiꞌile, xibal sba. Yuꞌun xuꞌ ta xbat ta lajebal ti bu oy ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ti mi ta xavichꞌ batel ti matanal ti ta altare, ti mi jaꞌ o ivul ta avoꞌnton ti oy bu mu lecuc ta xayil ti achiꞌile, ");
INSERT INTO tzotzc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jaꞌ lec, ictao to comel ta stiꞌil altar ti matanal ti ta xavacꞌ oxe. Batan baꞌyel, ba lajesbo yoꞌnton ti achiꞌile. Tsꞌacal to xuꞌ xtal avacꞌbe smoton ti Dios ti ta xavacꞌbe onoꞌoxe. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Mi oy buchꞌu ta xacꞌot ta chapanele, ti cꞌalal ta xaxanavic batel ta bee, lajesbo yoꞌnton, yoꞌ jech mu xba yacꞌot ta scꞌob ti jueze. Yuꞌun ti jueze ta xacꞌot batel ta scꞌob ti mayole. Jech ti mayole ta sticꞌot ta chuquel. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cꞌalal jech tiqꞌuilot ta chuquele, ta melel ta xcalboxuc avaꞌiic, mu xalocꞌ talel ta jecheꞌ noꞌox, jaꞌ to ti mi laj atoj comel scotol ti amultae. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ti voꞌoxuque avaꞌbinojic ti jech iꞌalbat ti amolmucꞌtotique: “Mu xasaꞌ avantsic. Antsetic, mu xaloꞌlabe sjol viniquetic”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ti vuꞌune ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti ta sqꞌuel jun ants ti oy ta yoꞌnton ti ta scꞌan ta scꞌupin yaꞌie, coꞌol sꞌelan ti laj xa scꞌupin ta xꞌilat yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Jech o xal un, mi ta scoj asat ta xata amul yuꞌune, pitso loqꞌuel. Jipo batel ta nom. Yuꞌun jaꞌ lec ti mi ta xachꞌay jbej noꞌox asate. Jaꞌ toj chopol ti mi sjunul abecꞌtal ta xavichꞌ jipel ochel ta cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jaꞌ jech xtoc mi ta scoj abatsꞌi cꞌob ta xata amul yuꞌune, seto loqꞌuel. Jipo batel ta nom. Yuꞌun jaꞌ lec ti mi jun noꞌox acꞌob ta xchꞌaye. Jaꞌ toj chopol ti mi sjunul abecꞌtal ta xavichꞌ jipel ochel ta cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Jaꞌ jech xtoc avaꞌbinojic ti jech iꞌalbatic ti amolmucꞌtotique: “Buchꞌuuc noꞌox ti ta sbaj ti yajnile, acꞌo smeltsanbe svunal ti bajobbaile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ti vuꞌune ta xcalboxuc avaꞌiic, jaꞌ noꞌox xuꞌ ta xabaj ti avajnile ti mi ta xacꞌ sba ta cꞌupinele. Pero ti mi ta xabaj ti avajnil ta jecheꞌ noꞌoxe, jech o xal ta acoj voꞌot vinic ti ta sta smul ti antse. Jaꞌ jech xtoc buchꞌuuc noꞌox ti ta xicꞌ ti bajbil antse, ta sta smul ec. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Avaꞌbinojic ti jech iꞌalbatic ti amolmucꞌtotique: “Ti laj xavaꞌan ta rextigo ti Dios ti cꞌusi ta xavaqꞌue, cꞌotuc me ta pasel avuꞌun”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ti vuꞌune ta xcalboxuc avaꞌiic, mu me cꞌusi xavaꞌanic ta rextigo. Mu xavaꞌanic ta rextigo ti vinajele, yuꞌun jaꞌ tey chotol ta spas mantal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu xavaꞌanic ta rextigo ti banomile, yuꞌun jaꞌ stecꞌleb yoc ti Diose. Mu xavaꞌanic ta rextigo ti jteclum Jerusalene, yuꞌun jaꞌ steclumal ti Ajvalil Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu xavaꞌanic ta rextigo ti ajolique, yuꞌun mu xuꞌ ta xasacubtas ta xavicꞌubtas ti stsatsal ajolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jaꞌ noꞌox alic, jech, mi moꞌoj. Yuꞌun ti mi ta xajutic ti cꞌope, ta xlic talel ta stojol ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Avaꞌbinojic ti jech iꞌalbatic ti amolmucꞌtotique: “Buchꞌuuc noꞌox ti ta stubbe sat ti schiꞌile, jech ta xichꞌ tubbel sat ec. Buchꞌuc noꞌox ti ta scꞌasbe stanal ye ti schiꞌile, jech ta xichꞌ cꞌasbel stanal ye ec”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ti vuꞌune jech ta xcalboxuc avaꞌiic, mu me xapacbe sutel ti chopol vinique. Mi ta smajbot ti jot xocon asate, acꞌo smaj ti jot xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi oy buchꞌu ta xicꞌot batel ta stojol ti jchapanvanejetique yoꞌ ta spoj ti acꞌuꞌe, acꞌo yichꞌ batel ti yan acꞌuꞌ xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mi oy buchꞌu ta xasujic ta xcuchel batel icatsil oꞌlol revae, jaꞌ lec cuchbo batel jun reva. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Buchꞌuuc noꞌox mi oy cꞌusi ta scꞌanbote, acꞌbo. Buchꞌuuc noꞌox mi oy cꞌusi ta xchꞌamunbote, acꞌbo. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Jaꞌ jech xtoc avaꞌbinojic ti jech iꞌalbatic ti amolmucꞌtotique: “Cꞌuxubino ti buchꞌu lec xavil abaic achiꞌuque. Crontaino ti avajcrontae”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ti vuꞌune ta xcalboxuc avaꞌiic, cꞌuxubino ti avajcrontae. Cꞌanbeic slequilal Dios ti buchꞌu ta xaschopol-cꞌoptaoxuque. Pasic lec ta stojol ti buchꞌu xtiꞌet sjol ta atojolique. Cꞌoponbeic Dios ta stojol ti buchꞌutic ta xayutilanique, ti ta xayilbajinoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ti mi jech ta xapasique, jaꞌ snichꞌnaboxuc ti Dios ti oy ta vinajele. Yuꞌun ti Diose ta xacꞌbe xojobal cꞌacꞌal ti buchꞌutic leque, ti buchꞌutic chopole. Ta xacꞌbe tal voꞌ ti buchꞌutic leque, ti buchꞌutic chopole. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yan ti mi jaꞌ noꞌox ta xacꞌuxubinic ti buchꞌutic cꞌux ta xayaꞌiique, ¿cꞌusi ti matanal ta xavichꞌic ti jech ta xapasique? Yuꞌun ti jcꞌanpatantaqꞌuinetique cꞌux ta xaꞌiic ti buchꞌu cꞌux ta xꞌaꞌiate. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi jaꞌ noꞌox lec ta xacꞌopon ti buchꞌu lec xavil aba achiꞌuque, ¿cꞌusi ti lec ta xapasique? Yuꞌun ti buchꞌutic mu xojtiquinic ti Diose, jaꞌ jech ta spasic. ");
INSERT INTO tzotzc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ti voꞌoxuque lecuc avoꞌntonic jech chac cꞌu chaꞌal oy slequilal yoꞌnton ti Jtotic Dios ti oy ta vinajele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ti Jesuse jech laj yal xtoc: ―Scotol ti cꞌusi ta xapasic ta sventa ti Diose, bijanic me. Mu me jaꞌuc xꞌoch ta avoꞌntonic ti jaꞌ noꞌox ta xacꞌanic ti lec xaꞌilatic yuꞌun ti yane. Ti mi jech ta xapasique, muꞌyuc ta xaꞌacꞌbatic ti amotonic yuꞌun ti Jtotic ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ti cꞌalal ta xacoltaic ti buchꞌu abol sbaique, mu me xavinajes ta stojol yan jech chac cꞌu chaꞌal ta spasic ti jpacꞌtaejbailetique ti ta chꞌul nae, ti ta callee. Jech ta spasic yoꞌ jech ta xlequil-cꞌoplaltaatic yuꞌun ti yane. Ta melel ta xcalboxuc avaꞌiic, jaꞌ noꞌox jech yepal laj xa staic ti smotonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cꞌalal ta xacoltaic ti buchꞌu abol sbaique, avoꞌntonuc noꞌox snaꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ta mucul coltavananic. Yuꞌun ti Jtotic Diose yiloj ti jech ta xacoltavanic ta mucule. Ta xayacꞌboxuc ti amotonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Cꞌalal ta xataic ta cꞌoponel ti Diose, mu jechuc xapasic jech chac cꞌu chaꞌal ti buchꞌu ta spacꞌta sbaique. Lec ta xaꞌiic ti vaꞌajtic xa ta staic ta cꞌoponel ti Dios ti ta chꞌul nae, ti ta calletique, yoꞌ jech ta xꞌilatic yuꞌun ti yane. Ta melel ta xcalboxuc avaꞌiic, jaꞌ noꞌox jech yepal laj staic ti smotonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cꞌalal ta xataic ta cꞌoponel ti Diose, ochanic ta yut anaic. Maquic ti stiꞌ anaique. Cꞌoponic ti Jtotic Dios teye. Jech ti Jtotic Diose yiloj ti jech ta xapas ta mucule. Ta xacꞌboxuc ti amotonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cꞌalal ta xataic ta cꞌoponel ti Diose, maꞌuc noꞌox ta xachaꞌalolanic ti cꞌusi laj xa avalique jech chac cꞌu chaꞌal ta spasic ti buchꞌutic mu xojtiquinic ti Diose. Yuꞌun ti stuquique ta snopic ti jaꞌ to jech ta xꞌaꞌibat scꞌopic yuꞌun ti Dios. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mu me jechuc xapasic jech chac cꞌu chaꞌal ti stuquique. Yuꞌun ti Jtotique snaꞌoj xa ti cꞌusi xtun avuꞌunic cꞌalal mu to ta xlic acꞌanbeique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaꞌ yuꞌun un, jech xavalic cꞌalal ta xacꞌopojique: Dios Totil, ti oyot ta vinajele, ichꞌbiluc ta mucꞌ achꞌul bi cuꞌuncutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Laꞌ ventainuncutic. Cꞌotuc ta pasel ti cꞌusi ta scꞌan avoꞌnton liꞌ ta banomile jech chac cꞌu chaꞌal ta xichꞌ pasel tey ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Acꞌbuncutic ti jveꞌelcutic ti xtun cuꞌuncutic avi cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Acꞌbuncutic perdón yuꞌun ti jmulcutique jech chac cꞌu chaꞌal ta xcacꞌbecutic perdón ti buchꞌu laj xa saꞌ smul ta jtojolcutique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pojuncutic, mu me xavacꞌuncutic ta lajeltsael yuꞌun ti pucuje. Yuꞌun jelavem amucꞌul, oy alequilal, ta xapas mantal sbatel osil. Jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ti mi ta xavacꞌbeic perdón ti buchꞌu laj xa saꞌ smul ta atojolique, jech ti Jtotic Dios ti oy ta vinajele ta xacꞌboxuc perdón ec. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ti mi mu xavacꞌbeic perdón ti yane, jech ti Jtotic Diose mu xayacꞌboxuc perdón yuꞌun ti amulique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Cꞌalal ta xacomtsan avotique, mu me xavaqꞌuic ta ilel ti oyoxuc ta at oꞌntone jech chac cꞌu chaꞌal ta spasic ti buchꞌu ta spacꞌta sbaique. Jech ta spasic yoꞌ jech acꞌo ilatuc yuꞌun ti yan ti yictaoj ti yotique. Ta melel ta xcalboxuc avaꞌiic, jaꞌ noꞌox jech yepal laj staic ti smotonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cꞌalal ta xacomtsan avotique, poquic asatic, tusic ajolic. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jech xapasic yoꞌ jech mu snaꞌic ti yan ti avictaoj ti avotique. Cꞌajomal noꞌox yiloj ti Jtotic ti tey xchiꞌinojoxuque. Jech ti stuque ta xacꞌboxuc ti amotonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mu me xatsob acꞌulejalic liꞌ ta banomile, ti snaꞌ xlilij ta xjochꞌe, ti snaꞌ xchꞌaye, ti xuꞌ ta xelcꞌan ti jꞌeleqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tsobic acꞌulejalic ta vinajel ti bu mu snaꞌ xlilij ta xjochꞌe, ti bu mu snaꞌ xchꞌaye, ti mu xelcꞌan ti jꞌeleqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yuꞌun ti bu oy ti acꞌulejalique, tey oy batem ti avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ti asatique coꞌol sꞌelan lampara cꞌotem yuꞌun ti abecꞌtalique. Ti mi lec ti asatique, jech oy ta saquil osil sjunul ti abecꞌtalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero ti mi chopol ti asatique, tey oy ta icꞌal osil sjunul ti abecꞌtalique. Jech xtoc mi mu xavichꞌic ta mucꞌ ti cꞌusi ta xacꞌ anaꞌic ti Diose, oyoxuc ta icꞌal osil. Muꞌyuc xa yan icꞌal osil jech chac cꞌu chaꞌal ti icꞌal osil taje. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Muꞌyuc buchꞌu xuꞌ ta xꞌabtej ta chaꞌvoꞌ ajvalil. Yuꞌun ti june, lec ta xcꞌanat. Yan ti june, mu lecuc ta xcꞌanat. Ti june, lec ta xꞌabtej ta stojol. Yan ti june, ta stoy sba ta stojol. Jaꞌ jech ti voꞌoxuc eque, mu xuꞌ ta xavacꞌ abaic ta tunel yuꞌun ti Diose ti mi jaꞌ batem avoꞌntonic yuꞌun ti taqꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Jech o xal ta xcalboxuc avaꞌiic, mu me xavul avoꞌntonic cꞌu sꞌelan ta xata aveꞌel avuchꞌomic yoꞌ ta xacuxiic, mi jaꞌuc ti acꞌuꞌic ta xalapique. ¿Mi yuꞌun jaꞌ tsots scꞌoplal ti aveꞌelique? ¿Mi jaꞌ mu sta ti acuxlejalique? ¿Mi yuꞌun jaꞌ tsots scꞌoplal ti acꞌuꞌique? ¿Mi jaꞌ mu sta ti abecꞌtalique? ");
INSERT INTO tzotzc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Qꞌuel avil ti mutetic ti xvilajet ta vinajele. Mu snaꞌ stsꞌunobajic. Mu snaꞌ xcꞌajavic. Mu snaꞌ spoco-tsob sveꞌelic. Pero malqꞌuinbilic yuꞌun ti Jtotic ti oy ta vinajele. ¿Mi yuꞌun jaꞌ tsots scꞌoplal ti mutetique? ¿Mi jaꞌ mu sta ti voꞌoxuque? ");
INSERT INTO tzotzc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Mi yuꞌun ta to xnatij acuxlejalic ti jech xvulvun avoꞌntonique? ");
INSERT INTO tzotzc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Cꞌu chaꞌal xvulvun avoꞌntonic yuꞌun ti acꞌuꞌique? Qꞌuelic lec cꞌu sꞌelan ta xchꞌi ti nichimetic ta yaxaltique. Mu snaꞌ xꞌabtejic. Mu snaꞌ xnaujic. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Vuꞌun ta xcalboxuc avaꞌiic ti jaꞌ jelavem yutsil ti nichime. Jaꞌ mu sta yutsil laj slap scꞌuꞌ ti ajvalil Salomone manchuc mi cꞌupil sba. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ti nichime mu jaluc tey ta xchꞌi ta yaxaltic. Ti mi jech ta spas ti Diose, ti jun yutsil ta scꞌuꞌiltas ti nichim ti cꞌalal ocom chaꞌej ta xbat ta cꞌoqꞌue, ¡bu xata ti mu ta scꞌuꞌiltasoxuque! Pero mu xachꞌunic lec. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jech o xal un, mu xavulilan avoꞌntonic ta yalel: “¿Cꞌusi ta jveꞌtic? ¿Cꞌusi ta xcuchꞌtic? ¿Bu ta jtatic ti jcꞌuꞌtique?” ti xachiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Qꞌuel avilic, ti buchꞌutic mu xojtiquinic ti Diose jaꞌ noꞌox batem ta yoꞌntonic ti sveꞌelique, ti scꞌuꞌique. Pero ti voꞌoxuque xanaic ti oy jun Dios ti snaꞌ scotol ti cꞌusitic xtun avuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jech o xal ti voꞌoxuque jaꞌ batuc avoꞌntonic ti ventainel yuꞌun ti Diose schiꞌuc xtoc ti ta xapasic ti cꞌusi lec ta xil ti Diose. Jech umbi, ta xaꞌacꞌbatic scotol ti cꞌusi ta xtun avuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mu xavulilan avoꞌntonic yuꞌun ti cꞌacꞌal ocꞌome. Yuꞌun ti jujun cꞌacꞌale oy cꞌusi ta xcꞌot ta pasel. Yuꞌun ti ocꞌome yan o xa cꞌacꞌal ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ti Jesuse jech laj yal xtoc: ―Mu xasaꞌbe smul ti yane yoꞌ jech mu xata chapanel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ti cꞌu yepal ta xaqꞌuelbe smul ti yane, jech yepal ta xchapanot ti Diose. Ti cꞌu sꞌelan ta xapasic ta stojol ti yane, jaꞌ noꞌox jech ta spas ti Dios ta atojolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Cꞌusi xavut ti ta xavil ti uni juteb cꞌaꞌep ti oy ta sat ti achiꞌile cꞌalal mu xavil ti tey oy ti schumanil cꞌaꞌep ta asate? ");
INSERT INTO tzotzc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ti mi oy ti schumanil cꞌaꞌep ta asate, ¿cꞌu yuꞌun ta xavalbe ti achiꞌile: “Acꞌbun jloqꞌues ti uni juteb cꞌaꞌep ta asate”, ti xavute? ");
INSERT INTO tzotzc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jecheꞌ ta xapacꞌta aba. Jaꞌ lec, loqꞌueso baꞌyel ti schumanil cꞌaꞌep ta asate. Jaꞌ yuꞌun umbi, jaꞌ to xuꞌ ta xaloqꞌuesbe ti uni juteb cꞌaꞌep ti oy ta sat ti achiꞌile. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Mu xavacꞌbe tsꞌiꞌetic li cꞌusi jaꞌ yuꞌun ti Diose. Yuꞌun xuꞌ me ta slilinoxuc ta tiꞌel. Mu xavacꞌbe chitometic ti natsꞌil ti toyol stojole. Yuꞌun xuꞌ ti jaꞌ noꞌox ta xpechꞌolan ta teqꞌuele. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Cꞌanbeic ti Diose, ta xacꞌboxuc. Saꞌic, ta xataic. Tijic ti tiꞌ nae, ta xajambatic. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ti buchꞌu ta scꞌane, ta xꞌacꞌbat. Ti buchꞌu ta saꞌe, ta sta. Ti buchꞌu ta stij ti tiꞌ nae, ta xjambat. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Ti voꞌoxuc totiloxuque, ¿mi ta xavacꞌbeic anichꞌonic jbej ton ti cꞌalal ta scꞌanboxuc pan sveꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jaꞌ jech xtoc, ¿mi ta xavacꞌbeic jcot chon ti cꞌalal ta scꞌanboxuc choy stiꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Manchuc mi jech chopoloxuc, pero xanaꞌic lec stꞌujel ti cꞌusi ta xavacꞌbeic ti anichꞌonique. ¡Bu xata ti mu xayacꞌboxuc ti cꞌusi lec ta xacꞌanbeic ti Jtotic ti oy ta vinajele! ");
INSERT INTO tzotzc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Jech o xal un, mi ta xacꞌan ti lec ta xaspasboxuc ti achiꞌilique, jaꞌ jech ti voꞌoxuque, lec me xapas abaic ta stojolic. Yuꞌun jech ta xchanubtasotic smantal ti Moisese schiꞌuc ti yajꞌalcꞌoptac ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ochanic batel ta biqꞌuit tiꞌ nae. Ti stiꞌ ti sbelal chꞌayele, toj jamal, toj mucꞌ. Toj ep ti buchꞌutic tey ta xꞌochic batele. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yan ti stiꞌ ti sbelal cuxlejale, mu jamaluc, toj biqꞌuit. Jutuc ti buchꞌu ta staique. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Bijanic me yuꞌun ti jloꞌlavanejetique ti buchꞌutic ta xalic ti ta xcꞌopojic ta sventa ti Diose. Coꞌol sꞌelan chij ti lec yoꞌntonic yilele. Pero ti ta yut yoꞌntone, jtiꞌval-oqꞌuil ta jꞌechꞌel. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti voꞌoxuque xuꞌ ta xavojtiquinic ti cꞌu sꞌelan stalel ta spasique. Yuꞌun ti chꞌixe mu xuꞌ ta xacꞌ uva ti sate. Jech xtoc ti tsucum chꞌixe mu xuꞌ ta xacꞌ icux ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Scotol ti lequil teꞌetique lec ta xacꞌ ti sate. Jech xtoc scotol ti chopol teꞌetique chopol ta xacꞌ ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ti lequil teꞌetique mu xuꞌ ta xacꞌ chopol ti sate. Jech xtoc ti chopol teꞌetique mu xuꞌ ta xacꞌ lec ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Scotol ti teꞌetic ti bu chopol ta xacꞌ ti sate, ta xichꞌ bojel loqꞌuel. Ta xichꞌ chiqꞌuel ta cꞌocꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jech o xal un, muꞌyuc ta chꞌayal yabtelic ti jloꞌlavanejetique. Lec xvinaj ti cꞌu sꞌelan stalel ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Oy ep ti buchꞌu jech ta xalique: “Cajval, Cajval”, ti xiique. Pero mu scotoluc ta xꞌochic batel ti bu ta xventainvan ti Diose. Jaꞌ noꞌox ta xꞌochic batel ti buchꞌutic ta spasic ti cꞌusi ta scꞌan yoꞌnton ti Jtot ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cꞌalal ta sta scꞌacꞌalile, ep ti buchꞌu jech ta xalique: “Cajval, Cajval, licꞌopojcutic ta aventa. Laj jloqꞌuescutic pucuj ta aventa. Voꞌot ta aventa laj cacꞌcutic ta ilel ti alequilale”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero jech ta jtacꞌbe ti vuꞌune: “Muꞌyuc laj cojtiquinoxuc. Chꞌaco abaic ta jtojol ti laj xa apasic chopole”, xichi. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ti buchꞌu ta xaꞌie, ti ta spas ti cꞌusi ta xcale, coꞌol sꞌelan jun bijil vinic ti ta smeltsan ti sna ti ta ba tone. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Cꞌalal tal tsots voꞌe, laj nojuc talel ti ucumetique. Echꞌ tsots icꞌ ta stojol ti nae. Pero muꞌyuc ilom, jaꞌ ti tsacal lec ta ba tone. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yan ti buchꞌu ta xaꞌie, pero muꞌyuc ta spas ti cꞌusi ta xcale, coꞌol sꞌelan jun bolat vinic ti lic smeltsan sna ta ba yiꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Cꞌalal tal ti tsots voꞌe, laj nojuc talel ti ucꞌumetique. Echꞌ tsots icꞌ ta stojol ti nae. Ibutqꞌuij yalel. Ililij scotol ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cꞌalal laj yoꞌnton ta chanubtasvanej ti Jesuse, chꞌayal icꞌot yoꞌntonic ti cristianoetic ti jech ichanubtasvane. ");
INSERT INTO tzotzc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yuꞌun ivinaj ti tsots yabtel yichꞌoj ti Jesuse. Mu xcoꞌolaj ichanubtasvan jech chac cꞌu chaꞌal ti jchanubtasvanejetic yuꞌun ti mantale. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cꞌalal iyal talel ta vits ti Jesuse, ep ti cristianoetic laj stsꞌacliic batele. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tey ital jun vinic ti tsacbil ta cꞌaꞌemal chamele. Ivul squejan sba ta stojol ti Jesuse. Jech laj yal: ―Cajval, mi ta xacꞌane, xuꞌ avuꞌun ta xacolesbun ti jchamele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jech ti Jesuse laj scajan scꞌob. Jech laj yal: ―Ta jcꞌan. Colem ta xacom ―xi. Cꞌalal jech laj yal taje, colem icom ti jcꞌaꞌemal-chamele. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jech laj yal ti Jesuse: ―Mu me buchꞌu xavalbe yaꞌi. Jaꞌ noꞌox batan, ba acꞌo aba ta ilel ta stojol ti palee. Ba acꞌbo smoton ti Diose jech chac cꞌu chaꞌal yaloj ti Moisese, yoꞌ jech ta snaꞌic scotolic ti lacol xa yuꞌun ti achamele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cꞌalal iꞌoch batel ta jteclum Capernaum ti Jesuse, jaꞌ o tey ital jun banquilal soldado romano. Inopaj tal scꞌanbe vocol. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jech lic yal: ―Cajval, oy cajꞌabtel ta jna ti puchꞌul ta steme. Mu albajuc ta xichꞌ svocol yuꞌun scꞌuxul ti schamele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ti Jesuse jech laj yal: ―Chba jcolta ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ti banquilal soldadoe jech itacꞌav: ―Cajval, muꞌyuc jlequilal ti ta xaꞌoch ta jnae. Jaꞌ noꞌox alo acꞌop. Jech ti cajꞌabtele ta xcol. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yuꞌun ti vuꞌun eque pasbilun ta mantal yuꞌun yan. Jaꞌ jechun ec ta jpas ta mantal ti cajsoldadotaque. Ti cꞌusi ta xcalbee, ta spasic. “Batan leꞌe”, mi xcut, ta xbat. “Laꞌ liꞌe”, mi xcut, ta xtal ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chꞌayal icꞌot yoꞌnton ti Jesús ti jech laj yale. Jech o xal jech lic yalbe yaꞌi ti buchꞌu tsꞌacajtic batele: ―Ta melel ta xcalboxuc avaꞌiic, muꞌyuc jtaoj jech junuc jꞌisrael ti jech yoꞌnton jech chac cꞌu chaꞌal ti vinic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta xcalboxuc avaꞌiic, ep ta jmec ti jyanlum cristianoetic ti oyic ta sjoylej banomile ta xꞌoch chotlicuc ta veꞌel schiꞌuc ti Abrahame, ti Isaaque, ti Jacobe ti bu ta xventainvan ti Dios ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yan ti buchꞌu albil scꞌoplalic ti xuꞌ ta xꞌochic batel ti bu ta xventainvan ti Diose, ta xtenatic batel ta icꞌal osil. Tey ta xꞌoqꞌuic. Tey xcꞌuxuxet ti stanal yeique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ti Jesuse jech laj yalbe ti banquilal soldadoe: ―Batan ta ana. Acꞌo cꞌotuc ta pasel jech chac cꞌu chaꞌal ti achꞌunoje ―xi. Ta ora noꞌox icol ti yajꞌabtel ti banquilal soldadoe cꞌalal jech laj yal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ti Jesuse ibat ta sna ti Pedroe. Jaꞌ o tey laj yil ti Jesuse ti puchꞌul ta stem, ip ta xaꞌi cꞌocꞌ, smeꞌniꞌ ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Laj yacꞌ scꞌob ta stojol ti jchamele. Ta ora noꞌox iyam ti scꞌacꞌale. Jech ti antse ilic, lic malqꞌuinvanuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cꞌalal och xa ti acꞌobale, jech ti cristianoetique laj yiqꞌuic tal ta stojol Jesús ep ti buchꞌu ta xꞌilbajinatic yuꞌun ti pucuje. Ta jbel noꞌox scꞌop laj sloqꞌues ti pucujetique. Jech xtoc laj scoles scotol ti epal jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ti jech taje, yoꞌ ta xcꞌot ta pasel jech chac cꞌu chaꞌal laj yal ti jꞌalcꞌop Isaíase: “Laj sbain ti cꞌusitic mu xuꞌ cuꞌuntique. Jech xtoc laj sbain ti jchameltique”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cꞌalal laj yil ti Jesús ti ep joyobtabil ta cristianoe, laj yal ti acꞌo jelavuc ta jot nabe. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jaꞌ o inopaj tal jun jchanubtasvanej yuꞌun ti mantale. Jech laj yal: ―Jchanubtasvanej, ta jcꞌan ta jchiꞌinot ti buyuc noꞌox ta xabate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ti Jesuse jech laj stacꞌbe: ―Ti vete oy snail chꞌen. Ti mutetique oy stasic. Pero ti vuꞌun ti coꞌol jꞌelantique mi jaꞌuc oy bu juteb ti xuꞌ ta jcux ti coꞌntone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Oy jun vinic ti yajtsꞌaclivanej xtoque ti jech laj yale: ―Cajval, acꞌo ave ti ta jmuc comel baꞌyeluc ti jtote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ti Jesuse jech laj stacꞌ: ―Batic. Acꞌo smuc yanimaic ti buchꞌu chamemic onoꞌoxe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ti Jesuse tey iꞌoch batel ta barco schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cꞌalal ta xanavic batel ta nabe, jaꞌ o tal tsots icꞌ ta jmec. Ti syucꞌbenal ti yaꞌlel nabe ta xꞌoch ta barco. Ti Jesuse vayem. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ti yajchancꞌoptaque bat stijic ti Jesuse. Jech laj yalic: ―Cajval, coltauncutic, ta xa xijmutꞌijotic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ti Jesuse jech laj stacꞌ: ―Ta scoj ti mu xachꞌunicune, jaꞌ yuꞌun ta xaxiꞌic ―xi. Jech ti Jesuse ilic, lic spajes ti iqꞌue, ti nabe. Tsꞌijil icom scotol. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chꞌayal icꞌot yoꞌntonic ti yajchancꞌoptaque. Jech lic yalbe sbaic: ―¿Cꞌusi vinical liꞌe ti ta xchꞌunbat smantal yuꞌun ti iqꞌue, yuꞌun ti nabe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cꞌalal icꞌot ti Jesús ta jot stiꞌil nab ti ta yosilal Gadarae, iloqꞌuic talel chib viniquetic ta muquinal. Inopajic talel ta stojol ti Jesuse. Ti chaꞌvoꞌique uninbilic yuꞌun ti pucujetique. Toj xibal sbaic. Muꞌyuc buchꞌu xuꞌ ta xꞌechꞌ ti ta be ti bu oyique. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jech tey lic avanicuc schibalic: ―Snichꞌon Dios, Jesús, ¿cꞌu chaꞌal xtal aticꞌ aba ta jtojolcutic? ¿Mi yuꞌun tal xa avacꞌbun jvocolcutic cꞌalal maꞌuc to yoraile? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jaꞌ o tey nopol xlamet ta xveꞌic epal chitometic. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ti pucujetique jech laj scꞌanbeic vocol ti Jesuse: ―Ti mi ta xaloqꞌuesuncutique, acꞌo ave ti acꞌo ochcuncutic batel ta chitometic leꞌe ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jech laj stacꞌ ti Jesuse: ―Ochanic ―xut. Jech ti pucujetique iloqꞌuic batel ta stojol ti chaꞌvoꞌ viniquetique. Bat sticꞌ sbaic ti ta chitometique. Jech ti chitometique bat sjipan sbaic ta barranco. Tsꞌajajtic icꞌot ta nab. Tey ijicꞌavic. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ti jqꞌuel-chitometique xbitetic ta anil ta xiꞌel. Cꞌalal icꞌotic ta jteclume, tey lic yalic ti cꞌusi icꞌot ta pasele schiꞌuc ti cꞌusi icꞌot ta stojol ti chaꞌvoꞌ viniquetic ti uninbilic yuꞌun ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Scotol ti cristianoetic ti oyic ta jteclume ibatic ti bu oy ti Jesuse. Cꞌalal laj yilique, laj scꞌanbeic vocol ti acꞌo locꞌuc batel ta slumalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ti Jesuse iꞌoch batel ta barco. Ijelav batel ta jot stiꞌil nab. Icꞌot ta slumal stuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jaꞌ o tey poybil tal schiꞌuc stem jun vinic ti pasem ta mochꞌe. Cꞌalal laj yil ti Jesuse ti xchꞌunojic ti buchꞌutic yicꞌojic talel ti jchamele, jech iꞌalbat ti jchamele: ―Muqꞌuibtaso avoꞌnton, Nichꞌon. Acꞌbilot xa perdón yuꞌun amul ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Oy jlom jchanubtasvanejetic yuꞌun ti mantale ti jech laj snop ta yoꞌntonique: “Ti vinic leꞌe ta soquesbe yoꞌnton ti Dios yuꞌun ti scꞌope”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ti Jesuse yilojbe yoꞌntonic ti jech ta snopique. Jech laj yalbe: ―¿Cꞌu chaꞌal ti jech toj chopol snopobil avuꞌunique? ");
INSERT INTO tzotzc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Cꞌusi ti más lec ta alele? ¿Mi jaꞌ acꞌbilot xa perdón ti xie, mi jaꞌ ti lican, vaꞌlan batel ti xie? ");
INSERT INTO tzotzc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lec chaꞌe, ti vuꞌun ti coꞌol jꞌelantique ta xcacꞌboxuc avilic ti quichꞌoj cabtel liꞌ ta sba banomile yoꞌ ta xcacꞌbe perdón yuꞌun smulic ti cristianoetique ―xi ti Jesuse. Jech laj yalbe ti mochꞌe: ―Vaꞌlan, ichꞌo batel ti ateme. Batan ta ana ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jech ti mochꞌe ivaꞌi, ibat ta sna. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cꞌalal jech laj yilic ti cristianoetique, ixiꞌic. Jaꞌ jech xtoc ilequil-cꞌopojic ta stojol ti Diose ti jech acꞌbil smucꞌul stsatsal ta stojol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ti Jesuse ilocꞌ batel ti bu oy to oxe. Jaꞌ o tey laj yil jun vinic, Mateo sbi, chotol ti bu ta stojic ti patane. Jech xtoc jech laj yal: ―Batic ―xut. Jech o xal ti Mateoe ivaꞌi, laj xchiꞌin batel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ti Jesuse tey bat veꞌuc ta sna ti Mateoe. Ti teye, ep jcꞌanpatantaqꞌuinetic, ep jsaꞌmuliletic jmoj ta xveꞌic ta mexa schiꞌuc ti Jesuse schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Cꞌalal jech laj yilic ti jfariseoetique, tey ba sjacꞌbeic ti yajchancꞌoptaque: ―¿Cꞌu yuꞌun ti avajchanubtasvanejique jmoj ta xveꞌic schiꞌuc ti jcꞌanpatantaqꞌuinetique schiꞌuc ti jsaꞌmuliletique? ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ti Jesuse laj yaꞌi taje. Jech o xal jech laj yalbe: ―Mu xtun yuꞌunic jpoxtavanej ti buchꞌutic muꞌyuc schamelique. Jaꞌ noꞌox ta xtun yuꞌunic jpoxtavanej ti buchꞌutic oy schamelique. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Batanic, ba nopbeic tal smelol ti jech ta xal ti scꞌop Diose: “Ta jcꞌan ti ta xacꞌuxubinvanique. Maꞌuc ta jcꞌan ti ta xamilbeicun ti ta xachicꞌbeicun ti animaletique”, ti xie. Ti vuꞌune maꞌuc tal quicꞌ ti buchꞌu lequique. Jaꞌ tal quicꞌ ti jsaꞌmuliletique yoꞌ jech ta sjelta ti chopol yoꞌntonique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ti yajchancꞌoptac ti Juan jꞌacꞌ-ichꞌ-voꞌe inopajic batel ta stojol Jesús ti jech laj sjaqꞌuique: ―Ti vuꞌuncutique schiꞌuc ti jfariseoetique ep ta velta ta xquicta ti cotcutique. ¿Cꞌu yuꞌun mu xicta yotic ti avajchancꞌoptaque? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ti Jesuse jech laj stacꞌbe: ―¿Mi yuꞌun oyic ta at oꞌnton xanaꞌ ti buchꞌu icꞌbilic ta qꞌuel-nupunele? Pero ta sta scꞌacꞌalil ti oy bu ta xꞌicꞌat batel ti jnupunel vinique. Jaꞌ to tey ta xicta yotic umbi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Muꞌyuc buchꞌu ti ta spacꞌan ta achꞌ manta ti pocoꞌ cꞌuꞌile. Yan ti mi jech ta spasique, cꞌalal ta smuts ti achꞌ mantae, yantic xjatolaj batel ti pocoꞌ cꞌuꞌile. Jech o xal un, xmuqꞌuib más ti sjatemale. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jaꞌ jech xtoc muꞌyuc buchꞌu ti ta sticꞌ ochel ta spocoꞌ-avil ti achꞌ yaꞌlel uvae. Yan ti mi jech ta spase, cꞌalal ta xpajub ti yaꞌlel uvae, ta xtꞌom ti spocoꞌ-avile. Jecheꞌ ta xchꞌay ti yaꞌlel uvae. Ta xchꞌay ti yavil xtoque. Jech o xal un, ta scꞌan achꞌ ti yavile, achꞌ ti yaꞌlel uvae, yoꞌ lec ta xcom schiꞌbal ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cꞌalal yacal to jech ta xal ti Jesuse, jaꞌ o tey tal ta stojol jun banquilal yuꞌun ti jꞌisraeletique. Laj squejan sba ta stojol ti Jesuse. Jech laj yal: ―Naca to cham ti cantsil nichꞌone. Ti mi ta xabat acajan acꞌob ta sbae, ta xcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ti Jesuse tey ivaꞌi, bat schiꞌuc ti vinique schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Cꞌalal jech ta xanavic batele, jaꞌ o ital jun ants ta spat ti laj spicbe scꞌuꞌ ti Jesuse. Yuꞌun oy xa slajchebal jabil ti mu xmac ti yaꞌlele. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jech laj spas ti antse, jaꞌ ti yaloj onoꞌox ta yoꞌntone: “Manchuc mi naca noꞌox ta jpicbe stiꞌil scꞌuꞌ, jnaꞌ ti ta xicole”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ti Jesuse ijoybij. Jaꞌ o tey laj yil ti antse. Jech laj yal: ―Nichꞌon, muqꞌuibtaso avoꞌnton. Lacol xa, jaꞌ ti laj achꞌune ―xi. Cꞌalal jech iꞌalbate, ta ora noꞌox icol. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cꞌalal jech icꞌot ti Jesuse ta sna ti banquilal yuꞌun ti jꞌisraeletique, laj yil ti xchapanoj xa sbaic ti jtijvobetic yoꞌ chba smuquic ti anima tsebe. Jech ti jmuclumaletique xꞌavlajetic ta oqꞌuel. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jech laj yal ti Jesuse: ―Locꞌanic batel liꞌe. Yuꞌun ti tsebe muꞌyuc chamem. Jaꞌ noꞌox ta xvay ―xi. Pero scotol ti jmuclumaletique tseꞌej noꞌox laj yaꞌiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cꞌalal laj stac loqꞌuel jmuclumaletic ti Jesuse, iꞌoch batel ti bu oy ti animae. Ti Jesuse laj snitbe liquel scꞌob ti tsebe. Jech ti tsebe ilic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Itanij scꞌoplal ta sjoylej banomil ti jech icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cꞌalal jech ilocꞌ batel ti Jesuse, tey xꞌavetic xa batel chaꞌvoꞌ maꞌsat: ―Snichꞌon David, cꞌuxubinuncutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cꞌalal iꞌoch ta na ti Jesuse, inopajic batel ti chaꞌvoꞌ maꞌsatetique. Ti Jesuse jech laj sjacꞌbe: ―¿Mi achꞌunojic ti xuꞌ ta jam ti asatique? ―xi. Jech itacꞌavic: ―Jchꞌunoj, Cajval ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jech ti Jesuse laj spicbe ti sate. Jech laj yal: ―Cꞌotuc ta pasel jech, jech chac cꞌu chaꞌal ti achꞌunojique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ijam ti satique. Ti Jesuse jech laj scꞌubanbe: ―Mu me buchꞌu xaꞌi avuꞌunic ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cꞌalal naca to iloqꞌuic batele, sjunul banomil ti ta slumalique, laj svinajesic ti cꞌusi laj spas ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cꞌalal ta xa xloqꞌuic batel ti chaꞌvoꞌique, jaꞌ o iꞌicꞌbat tal ta stojol Jesús jun umaꞌ vinic ti ta xꞌilbajinat yuꞌun ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ti Jesuse laj sloqꞌues ti pucuje. Jech ti umaꞌe lic cꞌopojuc. Chꞌayal icꞌot yoꞌntonic scotol ti cristianoetique. Jech ta xalic: ―Muꞌyuc bu xquiltic o jech liꞌ ta jlumaltic jech chac cꞌu chaꞌal leꞌe ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yan ti jfariseoetique jech ta xalic: ―Ti vinic leꞌe ta sloqꞌues pucuj ta stsatsal ti banquilal yuꞌunique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ti Jesuse echꞌ chanubtasvanuc ta jujun chꞌul naetic ti oy ta jujun jteclume, ti oy ta jujun bicꞌtal lumetique. Ta xalbe scꞌoplal ti lequil ventainel yuꞌun ti Diose. Jech xtoc ta scolta scotol ti cꞌusiuc noꞌox chamelal ip ta xaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ti Jesuse icꞌuxubaj yoꞌnton yuꞌun ti cristianoetic ti cꞌalal laj yil ti abol sbaique, ti xvulvun ti yoꞌntonique. Yuꞌun coꞌol sꞌelan chij ti chꞌabal sqꞌuelele. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jech o xal ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Ta melel ta xcalboxuc avaꞌiic, ep ta jmec ti tsꞌunobal ti ta scꞌan tsobele. ¡Cꞌu stu un! jutuc ti jꞌabteletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jech o xal un, cꞌanbeic ti yajval tsꞌunobale ti acꞌo saꞌ talel jꞌabteletic yoꞌ ta xichꞌ tsobel ti tsꞌunobale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ti Jesuse laj yicꞌ talel ti lajchaꞌvoꞌ yajchancꞌoptaque. Laj yacꞌbe tsots yabtelic yoꞌ jech ta sloqꞌuesic ti pucujetique, yoꞌ jech ta scoltaic ti cristianoetic ti cꞌusiuc noꞌox chamelal ta xaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ti sbitac ti lajchaꞌvoꞌ yajchancꞌoptaque jaꞌ liꞌe: Ti Simone, jaꞌ sbi xtoc ti Pedroe. Ti Andrese, jaꞌ schiꞌil ta voqꞌuel ti Pedroe. Ti Jacoboe, ti Juane, jaꞌ snichꞌnab ti Zebedeoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ti Felipe Ti Bartolomee Ti Tomase Ti Mateoe, jaꞌ ti jcꞌanpatantaqꞌuin to oxe. Ti Jacoboe, jaꞌ snichꞌon ti Alfeoe. Ti Lebeoe, jaꞌ sbi xtoc ti Tadeoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ti Simone, ti jaꞌ ochem to ox ta partido canananistae. Ti Judas Iscariotee, jaꞌ ti buchꞌu laj yacꞌ ta cꞌabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ti Jesuse jech laj yalbe ti lajchaꞌvoꞌ yajchancꞌoptac ti cꞌalal laj stac batele: ―Mu xabatic ta stojol ti jyanlumetique. Mi jaꞌuc xaꞌochic batel ta jteclumetic ti oy ta Samaria banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jaꞌ lec, batanic ta stojol ti jꞌisraeletique ti coꞌol sꞌelanic jchꞌayel chijetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba albo yaꞌiic ti sta xa yorail ti ta xventainvan ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Colesic ti jchameletique. Chaꞌcuxesic ti animaetique. Colesic ti jcꞌaꞌemal-chameletique. Taquic loqꞌuel ti pucujetic ti oy ta yoꞌntonique. Moton laj cacꞌboxuc ti jech xuꞌ avuꞌunique. Jech o xal mu xacꞌanbeic stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mu xavichꞌ batel ataqꞌuinic. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mu xavichꞌ batel anutiꞌic. Jlic noꞌox acoton xavichꞌ batel. Mu xavichꞌ batel anabteꞌ. Mu xavichꞌ batel chaꞌchop axonobic. Yuꞌun ti jꞌabteletique tey ta sta sveꞌelic ti bu ta xꞌabtejique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cꞌalal ta xacꞌotic mi ta mucꞌ ta lum, mi ta biqꞌuit lum, jaꞌ me saꞌic batel ti buchꞌutic ta sjunul yoꞌnton ta xicꞌot ta snae. Tey comanic jaꞌ to ti mi lic anopic ti ta xaloqꞌuic batele. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cꞌalal ta xaꞌochic batel ta snae, tal cacꞌboxuc spatobil avoꞌntonic, chianic. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi ta xacꞌ ta venta ti jech ta xavalique, acꞌbeic comel ti spatobil yoꞌntonique. Mi mu lecuc ta xaꞌiique, mu me xavacꞌbeic comel. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi mu xayichꞌic ta muqꞌue, mi mu xichꞌic ta mucꞌ ti spatobil yoꞌntonique, locꞌanic batel ti ta snae, ti ta steclumalique. Lilinic comel ti spucuquil axonobique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta melel ta xcalboxuc avaꞌiic, ti cꞌalal ta sta yorail ti chapanele, jaꞌ más tsots castigo ta xichꞌic. Jaꞌ mu sta ti buchꞌutic nacajtic to ox ta Sodomae schiꞌuc ti ta Gomorra jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Qꞌuel avilic, coꞌol aꞌelanic jech chac cꞌu chaꞌal chij ta jtacoxuc batel ta stojol ti jtiꞌvanej-oqꞌuiletique. Bijanic me ec un, jechuc me abijilic jech chac cꞌu chaꞌal ti jtiꞌvanej-chone. Pero ti atalelique, jechuc me jech chac cꞌu chaꞌal ti palomae. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bijanic me, yuꞌun ti cristianoetique chba yacꞌoxuc ta yoc ta scꞌob ti jchapanvanejetique. Ta xavichꞌic majel ta jujun chꞌul na. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta jventa vuꞌun ta xaꞌicꞌatic batel ta stojol ti ajvaliletique, ti mucꞌ ta ajvaliletique. Cꞌalal tey oyoxuc ta stojole, jaꞌ to xuꞌ ta xavalic ti jcꞌoplale. Jech xtoc jaꞌ to xuꞌ ta xavalic ti jcꞌoplal ta stojol ti jyanlumetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cꞌalal ta xavichꞌic aqꞌuel bal ta stojol ti jchapanvanejetique, mu me xavul avoꞌntonic ti cꞌu sꞌelan ta xavalique. Yuꞌun ti cꞌalal ta sta yorail ta xacꞌopojique, Dios ta xacꞌboxuc anaꞌic ti cꞌu sꞌelan ta xavalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yuꞌun jaꞌ coltabiloxuc yuꞌun ti Schꞌul Espíritu ti Jtotique. Maꞌuc voꞌoxuc ta xacꞌopojic. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Oy bu ta xacꞌ sbaic ta milel yitsꞌin sbanquil sbaic noꞌox. Ti totil meꞌile ta xaqꞌuic ta milel ti yalab snichꞌnabique. Ti alab nichꞌnabiletique ta scrontainic ti stot smeꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta jventa vuꞌun scotol ti cristianoetique ta xayichꞌoxuc ta cronta. Ti buchꞌu muꞌyuc xchibaj yoꞌnton yuꞌun ti crontainele, ti staoj o yav yoꞌnton xcham xlaje, jaꞌ ta xcol. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cꞌalal ta xavichꞌic ilbajinel ta jun jteclume, jatavanic batel ta yan jteclum. Ta melel ta xcalboxuc avaꞌiic, mu to xlaj avuꞌunic ta yalel ti lequil achꞌ cꞌop ta jujun jteclum ti liꞌ ta slumal Israele ti cꞌalal ta xichaꞌsut talel ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mu xanopic ti jun jchancꞌope ti más to lec scꞌoplal ti stuque, ti jaꞌ mu sta ti yajchanubtasvaneje. Mi jaꞌuc jun mosovil ti jaꞌ más lec ti scꞌoplal ti stuque, ti jaꞌ mu sta ti yajvale. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ti jchancꞌope, acꞌo spat yoꞌnton ti jech scꞌoplal jech chac cꞌu chaꞌal scꞌoplal ti jchanubtasvanej yuꞌune. Ti mosovile, acꞌo spat yoꞌnton ti jech scꞌoplal jech chac cꞌu chaꞌal ti yajvale. Ti mi ta xꞌalbat banquilal pucuj ti yajval nae, ¿mi jaꞌ xa mu jechuc ta xꞌalbat ti snichꞌnabe? ");
INSERT INTO tzotzc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Jech o xal un, mu xaxiꞌic yuꞌun ti cristianoetique. Muꞌyuc cꞌusi jtosucal ti mucul ta xcome. Ta onoꞌox xvinaj. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Scotol ti cꞌusi ta xcalboxuc ti mu xvinaj lec ti smelol avie, alic ti cꞌalal xlic avaꞌiic ti smelole. Ti cꞌusi laj avaꞌiique, avananic ta sjol anaic yoꞌ ta xaꞌiic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mu xaxiꞌic yuꞌun ti buchꞌutic ta xasmiloxuque. Yuꞌun ti achꞌulelique mu xuꞌ ta sta ta milel. Jaꞌ lec xiꞌtaic ti Diose ti xuꞌ ta smilote, ti xuꞌ ta xacꞌ batel ta lajebal ti achꞌulelique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Mi mu ta jsepuc noꞌox uni taqꞌuin ta xichꞌ chonel chaꞌcot uni mut? Pero mi mu to ta xlocꞌ ta ye ti Jtotic Diose mi jaꞌuc jcot ta xbaj ta lum. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ti voꞌoxuque ti jujubej ti stsatsal ajolique yichꞌoj ta sventa, atbil yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jech o xal mu xaxiꞌic. Yuꞌun ti voꞌoxuque ep atojolic. Jaꞌ mu sta ti mutetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Buchꞌuuc noꞌox ti jamal ta xalic ti jaꞌ yuꞌunun ti Cristo ti xiic ta stojol ti cristianoetique, jaꞌ jechun ec jamal ta xcal, jaꞌ cuꞌun leꞌe, xichi ta stojol ti Jtot ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yan ti buchꞌutic ti ta xalic ti maꞌuc yuꞌunun ti Cristo ti xiic ta stojol ti cristianoetique, jaꞌ jechun ec, maꞌuc cuꞌun leꞌe, xichi ta stojol ti Jtot ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mu xanopic ti tal jcoꞌoltasbe yoꞌntonic ti cristianoetic liꞌ ta banomile. Ta jventa vuꞌun ti jech ta xlic scrontain sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta sventa ti vuꞌun litale, mu jmojuc yoꞌntonic ti totiletique, ti alab nichꞌnabiletique, ti meꞌiletique, ti meꞌalibaletique, ti alibaletique. Cronta ta xil sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yuꞌun yutsꞌ yalal noꞌox sbaic ta xlic scrontain sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ti buchꞌu mu tsotsuc jcꞌoplal ta xiyaꞌie, ti jaꞌ tsots scꞌoplal ta xaꞌi ti stote, ti smeꞌe, mu xuꞌ ta xꞌoch ta cajchancꞌop. Jaꞌ jech xtoc ti buchꞌu jaꞌ noꞌox tsots scꞌoplal ta xaꞌi ti snichꞌnabe, mu xuꞌ ta xꞌoch ta cajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ti buchꞌu mu scꞌan xichꞌ svocol stuc ti jech ta stsꞌacliune, mu xuꞌ ta xꞌoch ta cajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ti buchꞌu ta spoj yaꞌi ti scuxlejale, jaꞌ ta xchꞌay ti scuxlejale. Yan ti buchꞌu ta xchꞌay ti scuxlejal ta jventae, jaꞌ ta sta ti scuxlejale. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Buchꞌuuc noꞌox ti ta xayichꞌic ta muqꞌue, ta xiyichꞌun ta mucꞌ ec. Ti buchꞌutic ti ta xiyichꞌic ta muqꞌue, ta xichꞌic ta mucꞌ ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Buchꞌuuc noꞌox ti ta xichꞌ ta mucꞌ jun jꞌalcꞌop ti tacbil talel yuꞌun ti Diose, ta xichꞌ smotonic jech chac cꞌu chaꞌal ta xichꞌ smoton ti jun jꞌalcꞌope. Buchꞌuuc noꞌox ti ta xichꞌ ta mucꞌ ti jun lequil vinique, ta xichꞌ smoton jech chac cꞌu chaꞌal ta xichꞌ smoton ti lequil vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Buchꞌuuc noꞌox ti ta xacꞌbe jun vasu siquil voꞌ ti buchꞌu peqꞌuel scꞌoplale yuꞌun ti ta xistsꞌacliune, ta melel umbi, ta xichꞌ ti smotone ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cꞌalal laj yoꞌnton ti Jesús ta sbijubtasel ti lajcheb yajchancꞌoptaque, ilocꞌ batel. Ibat chanubtasvanuc ta jujun jteclum ti tey onoꞌox oye. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti Juane, ti cꞌalal tiqꞌuil ta chuquele, laj yaꞌibe scꞌoplal ti oy cꞌusi ta spas ti Jesuse. Jech o xal laj stac batel jun chib yajchancꞌoptac ta stojol Jesús. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jech cꞌot sjaqꞌuic: ―¿Mi voꞌot la ti Cristoot ti ta onoꞌox xatale? ¿Mi ta to jmalacutic yan? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ti Jesuse jech itacꞌav: ―Batanic, ba albeic yaꞌi ti Juane ti cꞌusi ta xavilique, ti cꞌusi ta xavaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Albeic yaꞌi: “Ti maꞌsatetique jam xa ti satique. Ti coxovetique ta xanavic xa. Ti jcꞌaꞌemal-chamele colic xa. Ti buchꞌu macal schiquinique ta xaꞌiic xa cꞌoponel. Ti animaetique ichaꞌcuxiic xa. Ti buchꞌu abol sbaique laj xa yichꞌic albel ti lequil achꞌ cꞌop ti jaꞌ colebale. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ti buchꞌu mu xchibetuc yoꞌnton ta jtojole, yan yutsil”, xavutic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cꞌalal jech iloqꞌuic batele, jech ti Jesuse jech lic yalbe scꞌoplal ti Juane: ―¿Cꞌusi ay aqꞌuelic ti ta xocol banomile? ¿Mi jaꞌ jun aj ti xlaꞌet ta iqꞌue? ");
INSERT INTO tzotzc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ti mi maꞌuque, ¿cꞌusi ay aqꞌuelic? ¿Mi ay aqꞌuelic jun vinic ti jun yutsil ti scꞌuꞌe? Pero xanaꞌic lec ti voꞌoxuque, ti vinic ti buchꞌu jun yutsil ti scꞌuꞌe, jaꞌ noꞌox oy ta sna ti ajvaliletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jaꞌ yuꞌun un, ¿cꞌusi ay aqꞌuelic ta melel? ¿Mi jaꞌ jun jꞌalcꞌop? Jech melel, jaꞌ ay aqꞌuelic jun jꞌalcꞌop ti más cajale. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ti Juane, jaꞌ jun ti ta xꞌalbat scꞌoplal ta scꞌop Diose: Ta jtacbot jelavel cajꞌabtel ta atojol, yoꞌ jech ta smeltsanbot abe, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta melel ta xcalboxuc avaꞌiic, jaꞌ noꞌox stuc ti Juan jꞌacꞌ-ichꞌ-voꞌe ti más cajale. Jaꞌ mu sta ti cristianoetic ti laj echꞌuque. Manchuc mi jech scꞌoplal ti Juane, pero ti buchꞌu ta xacꞌ sba ta ventainel yuꞌun ti Diose, acꞌo mi peqꞌuel, jaꞌ más ta xꞌacꞌbat yil smucꞌul stsatsal ti Diose. Jaꞌ mu sta ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cꞌalal lic stsac yabtel ti Juan jꞌacꞌ-ichꞌ-voꞌe, jech o avi liꞌe oy buchꞌu yacalic ta vocol ta saꞌel ti ventainel yuꞌun ti Dios ti oy ta vinajele. Ti buchꞌu jeche ta sta. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cꞌalal muꞌyuc to ox talem ti Juan jꞌacꞌ-ichꞌ-voꞌe, scotolic ti jꞌalcꞌopetique schiꞌuc ti Moisese laj onoꞌox yalic comel ti ta onoꞌox xtal ti ventainele. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mi ta xacꞌan xachꞌunic, ti Juan jꞌacꞌ-ichꞌ-voꞌe, jaꞌ sqꞌuexol Elías ti ta onoꞌox xtale. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ti buchꞌu oy schiquine, acꞌo yaꞌi lec. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Jech ta jcoꞌoltas stalelic ti cristianoetic avie. Coꞌol sꞌelan ololetic ti ta xtajinic ta chꞌivit ti ta xavta ti jchop schiꞌilique: ");
INSERT INTO tzotzc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Laj coqꞌuisancutic ti amae, pero ti voꞌoxuque muꞌyuc bu xaꞌacꞌotajic. Xmeꞌinaj xa liqꞌuejincutic, pero muꞌyuc bu xaꞌoqꞌuic”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ti Juane mu jmojuc stsobetic ta veꞌel ta uchꞌvoꞌ schiꞌuc ti yantique. Pero ti voꞌoxuque, ventainbil yuꞌun pucuj leꞌe, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tsꞌacal to un, lital ti vuꞌun coꞌol jꞌelantique. Laj avilic ti oy buchꞌutic laj jchiꞌin ta veꞌele, ta uchꞌ voꞌe. Pero ti voꞌoxuque jech lic avalic ta jtojol: “Qꞌuel avil toj echꞌem jveꞌel jꞌuchꞌ-voꞌ. Lec xil sbaic schiꞌuc ti jsaꞌmuliletique schiꞌuc ti jcꞌanpatantaqꞌuinetique”, xachiic. Pero ati jaꞌuc sbijil Dios ti oy ta avoꞌntonique, ta xavichꞌicun ta mucꞌ schiꞌuc ti Juan ti jechuque ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ti Jesuse lic sjajanta ti cristianoetic ti oyic ta jujun jteclum ti bu laj yacꞌ ta ilel ti smucꞌul stsatsale. Yuꞌun ti cristianoetic teye muꞌyuc bu laj yictaic ti chopol yoꞌntonique. Jech o xal ti Jesuse jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Abol aba, jteclum Corazín. Abol aba, jteclum Betsaida. Ati lajuc yilic ti cristianoetic ti nacajtic to ox ta Tiro schiꞌuc ti ta Sidón jteclume jech chac cꞌu chaꞌal ta xavilic avi liꞌe, voꞌne xa laj sjelta yoꞌntonic, laj slapic cꞌuꞌil sventa at oꞌnton, laj svijbe sbaic tan ti jechuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ta xcalboxuc avaꞌiic, ti cꞌalal ta sta yorail ti chapanele, toj echꞌem ta xavichꞌic castigo. Jaꞌ mu sta ta xichꞌic castigo ti buchꞌutic nacajtic to ox ta Tiro schiꞌuc ti ta Sidón jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jaꞌ jech xtoc ti voꞌot eque, jteclum Capernaum, ta xanop ti ta xavichꞌ toyesel muyel cꞌalal to vinajel. Pero ¡bu xata ti jeche! Jaꞌ noꞌox ta xavichꞌ yalesel batel ti bu ticꞌajtic ti animaetique. Ati lajuc yilic ti cristianoetic ti nacajtic to ox ta Sodoma jteclum ti vi sꞌelan ta xcacꞌ avilic ti jmucꞌul jtsatsale, laj xa sjelta yoꞌntonic ti jechuque. Jech ti slumalique muꞌyuc bu ililij, tey vaꞌal avi ti jechuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ta melel ta xcalboxuc avaꞌiic, ti cꞌalal ta sta scꞌacꞌalil ti chapanele, más to echꞌem ta xavichꞌic castigo. Jaꞌ mu sta ta xichꞌic castigo ti buchꞌutic nacajtic to ox ta Sodoma jteclume ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti jech ora taje, jech laj yal ti Jesuse: ―Tot, Cajval, ta jlequil-cꞌoponot, Yajvalot vinajel, banomil. Yuꞌun muꞌyuc laj avacꞌbe snaꞌ scoltael ti buchꞌutic bij ta xaꞌibe schiquinal ti yalojique. Yuꞌun jaꞌ noꞌox laj avacꞌbe snaꞌ scoltael ti buchꞌutic laj spas sbaic ta olole. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jechuc, Tot, yuꞌun jech laj acꞌan atuc ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ti Jesuse jech laj scꞌopon ti cristianoetique: ―Scotol ti cꞌusitic oye laj yacꞌbun ta coc jcꞌob ti Jtote. Muꞌyuc buchꞌu xiyojtiquin ti vuꞌun Nichꞌonilune, jaꞌ noꞌox ti Jtote. Jech xtoc muꞌyuc buchꞌu ta xojtiquin ti Jtote, jaꞌ noꞌox vuꞌun ti Nichꞌonilune. Jech xtoc ta xojtiquinic ti Jtote ti buchꞌutic ta xcacꞌbe yojtiquinique. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Laꞌ cuxo avoꞌntonic ta jtojol ti voꞌoxuc ti toj lubemoxuc yuꞌun ti avabtelique, yuꞌun ti avicatsique. Vuꞌun ta xcacꞌ scuxobil avoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Acꞌo abaic ta ventainel ta jtojol. Chanbeicun coꞌnton. Yuꞌun ti vuꞌune mu jnaꞌ jtoy jba. Manxuun. Ti mi jech ta xapasique, ta xataic ti scuxobil avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ti laj calboxuc ti ta xavacꞌ abaic ta ventainel ta jtojole, mu tsotsuc ta chꞌunel. Ti cꞌusi ta jcꞌan ti ta xapasique, mu vocoluc ta pasel ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Oy jun cꞌacꞌal ti Jesuse ta xanavic batel schiꞌuc ti yajchancꞌoptac ta yut trigotic ti jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale. Ti yajchancꞌoptaque laj yaꞌiic viꞌnal. Jech o xal tey laj stuchꞌic ti trigoe, laj sjuꞌ xcꞌuxic ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cꞌalal jech laj yilic ti jfariseoetic ti jech ta spasic taje, jech laj yalbeic ti Jesuse: ―Qꞌuel avil, ti avajchancꞌoptaque ta xꞌabtejic ta scꞌacꞌalil cuxob oꞌntonal ti cꞌalal albil ti mu xuꞌe ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ti Jesuse jech laj stacꞌbe: ―¿Mi muꞌyuc avilojic ti cꞌusi laj spas ti Davide schiꞌuc ti schiꞌiltaque ti cꞌalal ta xviꞌnajique? ");
INSERT INTO tzotzc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ti Davide iꞌoch batel ta mucꞌ ta templo. Laj stsac ti chꞌul pane. Laj sveꞌic schiꞌuc ti schiꞌiltaque ti cꞌalal jaꞌ noꞌox xuꞌ ta slajesic ti paleetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Mi muꞌyuc avilojic xtoc ti cꞌusi stsꞌibaoj comel ti Moisese? Ta xꞌabtejic ti paleetic ta mucꞌ ta templo ti ta scꞌacꞌalil cuxob oꞌntonale. Yuꞌun ti jech laj spasic taje, maꞌuc mulil. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta melel ta xcalboxuc avaꞌiic, liꞌ oy ta atojolic ti más tsots scꞌoplale, ti jaꞌ mu sta ti temploe. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ti voꞌoxuque muꞌyuc laj avaꞌibeic smelol ti scꞌop Dios ti jech ta xale: “Ta jcꞌan ti ta xacꞌuxubinvanique. Maꞌuc ta jcꞌan ti ta xamilbeicun ti ta xachicꞌbeicun ti animaletique”, ti xie. Ati lajuc avaꞌibeic smelole, mu ta jecheꞌuc noꞌox ta xasaꞌbeic smul ti cristianoetic ti cꞌalal chꞌabale. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jech ti vuꞌun eque, ti coꞌol jꞌelantique, quichꞌoj cabtel ti ta xcacꞌbe snaꞌ ti cristianoetic ti cꞌusi ta scꞌan pasel ti ta scꞌacꞌalil ti cuxob oꞌntonale ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ti Jesuse tey ilocꞌ batel, iꞌoch ta chꞌul na. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tey oy jun vinic ti pasem ta mochꞌ ti jun scꞌobe. Ti jfariseoetique ta scꞌanic ti ta saꞌbeic smul ti Jesuse. Jech o xal jech laj sjaqꞌuic: ―¿Mi xuꞌ ta xichꞌ coltael jun jchamel ta scꞌacꞌalil ti cuxob oꞌntonale? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ti Jesuse jech laj stacꞌbe: ―Cꞌalal mi oy bu ta xbaj ta jocꞌ jcot achij ti cꞌalal jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale, ¿mi muꞌyuc chba aloqꞌuesic talel? ");
INSERT INTO tzotzc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Bu ti más tsots scꞌoplale? ¿Mi jaꞌ ti vinique? ¿Mi jaꞌ ti chije? Jech o xal xuꞌ ta jcolta ta scꞌacꞌalil cuxob oꞌntonal ti vinic liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ti Jesuse jech lic yalbe ti vinique: ―Xachꞌo talel ti acꞌobe ―xut. Cꞌalal jech laj xachꞌ ti scꞌobe, lec icom jech chac cꞌu chaꞌal ti jun scꞌobe. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jech xtoc tey iloqꞌuic batel ti jfariseoetique. Lic scomonop scꞌopic cꞌusi ta xutic yoꞌ ta smilic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cꞌalal laj yaꞌi ti Jesús ti jech ta snopic ti jfariseoetique, ilocꞌ batel. Ep ti cristianoetic ti stsꞌacliojic batele. Jech ti Jesuse laj scolta scotol ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ti Jesuse laj yalbe yaꞌi ti jchameletique ti mu xalic ti Buchꞌu icoltaatique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jech laj spas ti Jesuse yoꞌ ta xcꞌot ta pasel ti cꞌusi laj stsꞌiba comel ti jꞌalcꞌop Isaíase ti jech laj yale: ");
INSERT INTO tzotzc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ti cajꞌabtel liꞌe, tꞌujbil cuꞌun. Lec ta jcꞌan. Ximuyubaj xa yuꞌun. Ta xcacꞌbe ti Chꞌul Espíritu cuꞌune, yoꞌ ta xalbe yaꞌi ti cristianoetic ta sbejel banomil ti cꞌu sꞌelan ta xichapanvane. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mu snaꞌ tsalvan ta cꞌop. Mu snaꞌ sujvan. Muꞌyuc ta xvinaj ti xꞌavet ta calletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ti cajꞌabtele maꞌuc ta scꞌas mi jun aj ti muꞌyuc tucꞌ chꞌieme. Maꞌuc tal stub ti cantil ti jutuc to ta xtile. Jech ta spas, jaꞌ to ti mi ta sta yorail ta xꞌoch ta lequil ajvalilale. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jaꞌ spatobil yoꞌntonic ti cristianoetic ti oy ta sbejel banomile, xi ti Diose, xi ti Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yicꞌojic batel ta stojol Jesús jun maꞌ sat vinic ti jaꞌ umaꞌ xtoque, ti uninbil yuꞌun ti pucuje. Ti Jesuse laj scolta. Jech ti vinique jam sat, lec icꞌopoj. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chꞌayal icꞌot yoꞌntonic scotol ti cristianoetique. Jech lic yalbe sbaic: ―¿Mi jaꞌ van snichꞌon David leꞌe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cꞌalal laj yaꞌiic ti jfariseoetic jech taje, jech laj yalic: ―Ti vinic leꞌe, ti jech ta sloqꞌues ti pucujetique, jaꞌ ta stsatsal ti banquilal yuꞌunique, jaꞌ ti totil pucuje ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ti Jesuse snaꞌojbe yoꞌnton ti jech ta snopique. Jech o xal jech laj yal: ―Buchꞌuuc noꞌox ajvalilal ti ta xlic xchꞌacolan ta jujuchop ti svinique, ti mi ta xlic stsac sbaic ta leto ti jujuchope, jech ta soquic o. Jaꞌ jech xtoc mi jun jteclum o mi jchop ta naclej, ti mi ta xlic scrontain sbaique, mu xjalij. Tey ta soquic o. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaꞌ jech xtoc ti pucujetique, ti mi ta scrontain sba stuquique, ¿cꞌusi xut ta xjalij ti yipique? ");
INSERT INTO tzotzc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ta xavalbeicun ti ta yip ti totil pucuj Beelzebue ta jloqꞌues ti pucujetique. Ti mi jech ta xachꞌunique, albun caꞌi, ¿buchꞌu van ta xcoltaat ti avinictac ti jech ta sloqꞌues ti pucujetique? Jaꞌ yuꞌun un, avinictac chayacꞌboxuc avilic ti chꞌayemoxuc ta snopele. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ti jech ta jloqꞌues ti pucujetique, jaꞌ ta sventa Chꞌul Espíritu yuꞌun ti Diose. Ti jech liꞌe, jaꞌ ta xacꞌ ta naꞌel ti liꞌ xa oy ta atojolic ti ventainel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Cꞌusi ta xut jun vinic ta xꞌoch ta sna jun tsatsal vinic yoꞌ ta xelcꞌanbe loqꞌuel ti cꞌusi oy yuꞌune, ti mi mu baꞌyeluc ta xichꞌ chuquele? Ti mi chucbil xa leque, jaꞌ to xuꞌ ta xꞌelcꞌanbat loqꞌuel ti cꞌusi oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Buchꞌuuc noꞌox ti mu lecuc ta xil ti cꞌusi ta jpase, jaꞌ ta xiscrontain. Jaꞌ jech xtoc ti buchꞌu mu xiscolta ta stsobele, jaꞌ noꞌox ta stani batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Jech o xal ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti cristianoetic ti chopol ti cꞌusi ta spasique, ti chopol ta xcꞌopojic ta stojol ti Diose, pero xuꞌ ta xꞌacꞌbatic perdón. Pero ti buchꞌutic chopol ta xcꞌopojic ta stojol ti Chꞌul Espíritue, mu xa sta perdón. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Buchꞌuuc noꞌox ti cristianoetic ti chopol ta xcꞌopojic ta jtojol ti coꞌol jꞌelantique, ta xꞌacꞌbatic perdón. Pero ti buchꞌutic chopol ta xcꞌopojic ta stojol ti Chꞌul Espíritue, mu staic perdón, mi jaꞌuc liꞌ ta banomile, mi jaꞌuc ti ta yane. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Mi lec ti teꞌe, lec ta xacꞌ ti sate. Yan ti mi chopol ti teꞌe, chopol ta xacꞌ ti sate. Scotol ti teꞌetique, stacꞌ ojtiquinel ta sat noꞌox. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Snichꞌnab jtiꞌval chon, ¿cꞌusi xavut ta xavalic ti leque ti cꞌalal chopol onoꞌox avoꞌntonique? Yuꞌun ti cꞌusi ta xlocꞌ ta aveique, jaꞌ ti cꞌusi ayanem ta yut avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ti lequil vinique, lec onoꞌox ta xlocꞌ ta ye. Yuꞌun jaꞌ ti lec onoꞌox ti yut yoꞌntone. Yan ti chopol vinique, chopol onoꞌox ta xlocꞌ ta ye. Yuꞌun jaꞌ ti chopol onoꞌox ti yut yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jech o xal ta xcalboxuc avaꞌiic, cꞌalal ta sta yorail ti chapanele, jaꞌ to tey ta xavaqꞌuic cuenta ti cꞌusitic muyuc xavaꞌiic ti locꞌ ta aveique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yuꞌun ti cꞌusi laj avalique, jech ta xavichꞌic chapanel. Mi lec ti cꞌusi laj avalique, chꞌabal amul. Mi chopol ti cꞌusi laj avalique, oy amulic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oy jlom jfariseoetic schiꞌuc jchanubtasvanejetic yuꞌun ti mantale jech laj yalic: ―Jchanubtasvanej, ta jcꞌan ta jqꞌuel caꞌicutic ti oy cꞌusi tsots xuꞌ avuꞌune ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ti Jesuse jech itacꞌav: ―Ti chopol cristianoe, ti mu junuc yoꞌntonique, ta scꞌanic ti oy cꞌusi ta xꞌacꞌbat yilique. Pero jaꞌ noꞌox jech ta xꞌacꞌbat yilic señail jech chac cꞌu chaꞌal icꞌot ta stojol ti jꞌalcꞌop Jonase. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yuꞌun ti Jonase, oxib cꞌacꞌal, oxib acꞌobal, tiqꞌuil ta schꞌut ti mucꞌ ta choye. Jaꞌ jechun ec ti vuꞌun coꞌol jꞌelantique, oxib cꞌacꞌal, oxib acꞌobal, tiqꞌuil ta xicom ta chꞌen. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cꞌalal ta sta scꞌacꞌalil ti chapanele, jaꞌ muꞌyuc smulic ta xꞌilatic yuꞌun Dios ti jninive cristianoetic ta voꞌnee. Yan ti voꞌoxuc ti liꞌ oyoxuc ta banomile, ep amulic ta xaꞌilatic yuꞌun ti Diose. Yuꞌun ti cꞌalal ay yichꞌic albel scꞌop Dios yuꞌun Jonás ti jninive cristianoetique, ta ora noꞌox laj scomtsan ti cꞌusitic chopol ta spasique. Ti Jonase mu tsotsuc yabtel yichꞌoj. Yan ti vuꞌune más tsots cabtel quichꞌoj ti liꞌ oyun ta atojolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jaꞌ jech xtoc oy jun meꞌ ajvalil ti liquem tal ta xocon sloqꞌueb cꞌacꞌale. Muꞌyuc smul ta xꞌilat yuꞌun Dios ti cꞌalal ta sta scꞌacꞌalil ti chapanele. Yuꞌun ti antse nom ital, tal yaꞌibe sbijil ti ajvalil Salomone. Pero ti voꞌoxuc ti liꞌ oyoxuc ta banomile, ep amulic ta xaꞌilatic yuꞌun ti Diose. Jaꞌ ti mu xavichꞌicun ta mucꞌ ti vuꞌun tsots cabtel quichꞌoje. Jaꞌ mu sta ti ajvalil Salomone. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Cꞌalal ta xlocꞌ batel ti pucuj ta yoꞌnton jun vinique, ta xba xanavuc ta xocol banomil. Ta saꞌ ti bu ta xcux ti yoꞌntone. Pero cꞌalal ta xil ti muꞌyuc ta stae, jech xlic snop ta yoꞌnton: ");
INSERT INTO tzotzc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Ta xichaꞌsut batel ta jna ti bu lilocꞌ talele”, xi. Cꞌalal ta sut talele, xocol ta stabe yoꞌnton ti vinique, coꞌol sꞌelan jbej na ti lec mesbile, ti lec chꞌubabile. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jech o xal ti pucuje ta xbat yicꞌ talel yan vucub schiꞌil ti más toj echꞌem chopole. Jaꞌ mu sta ti stuque. Scotolic ti pucujetique ta xꞌoch naclicuc ta yoꞌnton ti vinique. Jech ti vinique jaꞌ to toj echꞌem chopol ta xcom. Jaꞌ mu sta ti ta baꞌyele. Jaꞌ jech sꞌelan ta xcꞌot ta pasel ta stojol ti chopol cristianoetic avi liꞌe ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yacal to ox ta xcꞌopoj ti Jesuse, cꞌalal jaꞌ o tey icꞌot ti smeꞌe, ti yitsꞌinabtaque. Cꞌalal icꞌotique, tey icomic noꞌox ta pana. Ta scꞌan ta scꞌopon yaꞌiic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jech o xal oy buchꞌu ba yal ta stojol ti Jesuse: ―Liꞌ oy ta pana ti ameꞌe schiꞌuc ti avitsꞌinabtaque. Ta scꞌan ta scꞌoponot yaꞌi ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ti Jesuse jech lic stacꞌbe ti buchꞌu tal yale: ―¿Buchꞌu ti jmeꞌe? ¿Buchꞌu ti quitsꞌinabtaque? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ti Jesuse tey laj xbich scꞌob ta stojol ti yajchancꞌoptaque. Jech lic yal: ―Ti jmeꞌe, ti quitsꞌinabtaque jaꞌic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yuꞌun buchꞌuuc noꞌox ti ta spasic ti cꞌusi ta scꞌan yoꞌnton ti Jtot ti oy ta vinajele, jaꞌ jmeꞌ, jaꞌ jchiꞌiltac ta voqꞌuel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti jech cꞌacꞌal taje ilocꞌ batel ta na ti Jesuse. Bat chotluc ta tiꞌ nab. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pero laj stsob sbaic ep cristianoetic ti bu oy ti Jesuse. Jech o xal iꞌoch chotluc ta barco. Yan ti cristianoetique icomic ta tiꞌ nab. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jech ti Jesuse ep ta tos babacꞌop lic chanubtas ti cristianoetique. Jech lic yal: ―Oy jun vinic ti bat svij ti stsꞌunobale. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cꞌalal yacal ta svij batele, oy jlom icꞌot ta be. Tal ti mutetique. Laj stam slajesic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oy jlom icꞌot ta ba tontic ti bu joy noꞌox ti slumale. Ti stsꞌunobale ta ora noꞌox ivocꞌ, jaꞌ ti joy noꞌox ti slumale. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero cꞌalal qꞌuixnaj talel ti cꞌacꞌale, tey itaquij, jaꞌ ti muꞌyuc lec nat mucul ti yibele. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oy jlom xtoc ti tsꞌunobale icꞌot ta chꞌixtic. Cꞌalal ichꞌi tal ti chꞌixe, laj snetꞌ comel. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero ti jlom tsꞌunobale icꞌot ta lequil banomil. Toj lec laj yacꞌ ti sate. Jech ti sate oy jlom laj yacꞌ voꞌvinic (100) ta bej sat ti jujupetse. Oy jlom laj yacꞌ oxvinic (60). Oy jlom laj yacꞌ lajuneb schaꞌvinic (30). ");
INSERT INTO tzotzc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ti mi oy achiquinique, chiquintaic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jech ti yajchancꞌoptaque inopajic batel ta stojol ti Jesuse. Jech laj sjacꞌbeic: ―¿Cꞌu chaꞌal ta babacꞌop noꞌox ta xachanubtas ti cristianoetique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ti Jesuse jech laj stacꞌ: ―Dios ta xacꞌboxuc anaꞌic smelol ti ventainel yuꞌun ti Dios ti macal to oxe. Pero ti yane mu xuꞌ ta xaꞌibeic smelol. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yuꞌun ti buchꞌu ta scꞌan ta xaꞌibe ti smelole, ta to xꞌacꞌbat snaꞌ más ep. Pero ti buchꞌu mu scꞌan xaꞌibe smelol ti ventainele, ta xpojbat ti juteb snaꞌoje. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jech o xal ta babacꞌop ta jchanubtas ti cristianoetique. Yuꞌun ti stuquique ta xilic ti cꞌusi ta jpase, pero coꞌol sꞌelan ti mu xilique. Ta xaꞌiic ti cꞌusi ta xcale, pero coꞌol sꞌelan ti muꞌyuc cꞌusi ta xaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jech o xal jaꞌ icꞌot ta pasel ta stojol ti cristianoetique jech chac cꞌu chaꞌal laj yal ti jꞌalcꞌop Isaíase: Ti voꞌoxuque oy cꞌusi ta xavaꞌiic, pero mu xavaꞌibeic smelol. Oy cꞌusi ta xavilic, pero mu xavichꞌic ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yuꞌun yoꞌnton ti cristianoetic avi liꞌe iyijub xa, chopol ta xaꞌiic. Mutsul ti satique, macal ti schiquinique yoꞌ jech mu xil ta satic, yoꞌ mu xaꞌi ta schiquinic ti cꞌusi ta xꞌalbatique, yoꞌ jech mu xꞌoch ta yoꞌntonic ti ta sutic tal ta jtojole, yoꞌ jech ta jcolta, xi ti Diose, xi ti Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Yan yutsil ti voꞌoxuque. Yuꞌun ta xavil ta asatic. Yuꞌun ta xavaꞌi ta achiquinic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta melel ta xcalboxuc avaꞌiic, ep ti jꞌalcꞌopetique, ep ti lequil cristianoetic ta voꞌnee ti ta scꞌan ta sqꞌuelic ox yaꞌiic jech chac cꞌu chaꞌal ta xavilic avi liꞌe. Pero muꞌyuc laj yilic. Ta scꞌan ta xaꞌiic ox jech chac cꞌu chaꞌal ta xavaꞌiic liꞌe. Pero muꞌyuc bu laj yaꞌiic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ti Jesuse jech laj yal xtoc: ―Aꞌyic lec smelol ti jtsꞌunobajel vinic ti laj jbabaꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ti tsꞌunobal ti icꞌot ta bee, jaꞌ smelol ti oy jlom ti ta xaꞌiic ti ventainel yuꞌun ti Dios ti oy ta vinajele. Pero ital ti pucuj ta stojolique. Ta spojbe loqꞌuel ta yoꞌnton ti cꞌusi laj yaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ti tsꞌunobal ti icꞌot ta ba tontique, jaꞌ smelol ti oy jlom ti xmuyubajic xa laj yaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ta scoj ti muꞌyuc to lec yip ti yoꞌntonique, ti cꞌalal ital ti lajeltsaele, ti vocole ta sventa ti lequil achꞌ cꞌope, lic chibajuc yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ti tsꞌunobal ti icꞌot ta chꞌixtique, jaꞌ smelol ti oy jlom ti ta xaꞌiic ti lequil achꞌ cꞌope. Pero jaꞌ bat ta yoꞌntonic ti cꞌusi sventa sba banomile. Ilajic ta loꞌlael yuꞌun ti scꞌulejalique. Jaꞌ ijelav ti cꞌusitic ta scꞌan ti stuquique. Tey ichꞌay ta yoꞌntonic ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yan ti tsꞌunobal ti icꞌot ta lequil banomile, jaꞌ smelol ti oy jlom ti ta sjunul yoꞌntonic ta xaꞌiic ti lequil achꞌ cꞌope. Yalel toyol ta xꞌacꞌbat sbijilic yuꞌun ti lequil achꞌ cꞌope jech chac cꞌu chaꞌel ti sat tsꞌunobale ti oy jlom laj yacꞌ ta voꞌvinic (100), ta oxvinic (60), ta lajuneb schaꞌvinic (30) ta bej ti sate ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ti Jesuse lic yal yan babacꞌop: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal jun vinic ti laj stsꞌun lequil tsꞌunobal ti ta yosile. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cꞌalal jech yacal ta xvayique, jaꞌ o ital yajcronta ti vinique. Laj scap ta stsꞌunel ta trigo tꞌul ti batsꞌi trigoe. Cꞌalal jech laj spase, tey ibat. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cꞌalal ichꞌi ti trigoe, tey laj yacꞌ ti sjole. Jech xtoc tey ivinaj ti trigo tꞌule. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","’Ti yajꞌabteltac ti vinique bat yalbeic ti yajvalique: “Cajval, ti tsꞌunobal ti laj atsꞌune lec onoꞌox. ¿Bu ilocꞌ tal ti trigo tꞌul ti capal ichꞌie?” xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ti ajvalile jech laj yal: “Jaꞌ nan jun cajcronta laj stsꞌun”, xi. Jech ti jꞌabteletique jech lic sjaqꞌuic: “¿Mi ta xacꞌan ti chba jbulcutic loqꞌuel ti trigo tꞌule?” xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero ti ajvalile jech laj stacꞌ: “Chꞌan uto, yuꞌun ti mi ta xabulique, yicꞌal capal ta xlocꞌ ti batsꞌi trigoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jaꞌ lec, chꞌan utic, acꞌo chꞌiuc jmoj schiꞌuc ti trigoe. Cꞌalal ta sta yorail ti ta xichꞌ tsobel ti trigoe, vuꞌun ta jtac jelavel cajꞌabteltac yoꞌ jech ta stsobic baꞌyel ti trigo tꞌule. Ta spasic ta jujuchuc yoꞌ jech ta xichꞌ chiqꞌuel ta cꞌocꞌ. Tsꞌacal to un, ti trigoe ta xichꞌ tsobel yoꞌ jech ta jqꞌuej ta yavil”, xi ti vinique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ti Jesuse lic yal yan babacꞌop: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal ti becꞌ mostaza ti laj stsꞌun ta yosil ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ti uni jbej becꞌ mostazae más to biqꞌuit ta scotol ti yan sbecꞌ tsꞌunobaletique. Pero cꞌalal ta xchꞌie, jaꞌ más mucꞌ ta xbat ta scotol ti cꞌusitic yan tsꞌunobaletique. Jutuc xa mu coꞌoluc smucꞌul jpets ta teꞌ ta xbat. Jech o xal un, ti mutetique tey ta xtal spas stasic ta scꞌob-cꞌobtac ti mostazae ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ti Jesuse lic yal yan babacꞌop: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan ti spajubtasobil pan ti ta scap ta oxib sbisol harina ti antse, yoꞌ jech ta xpajub scotol ti votsꞌbil harinae ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ti Jesuse jaꞌ noꞌox ta babacꞌop laj xchanubtas ti cristianoetique. Muꞌyuc cꞌusi laj yal ti mi muꞌyuc ta xal ta babacꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ti jech taje, jaꞌ ta sventa yoꞌ jech ta xcꞌot ta pasel jech chac cꞌu chaꞌal ti laj stsꞌiba comel ti jꞌalcꞌope: Ta xicꞌopoj ta babacꞌop. Ta jvinajesbe scꞌoplal ti cꞌusi mu to ox xvinaj cꞌalal lic smeltsan tal banomil ti Diose, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ti Jesuse laj scꞌopon comel ti cristianoetique. Tsꞌacal to un, iꞌoch ta na. Jaꞌ o inopajic batel ti yajchancꞌoptaque. Jech lic yalbeic ti Jesuse: ―Albun caꞌicutic smelol ti trigo tꞌul ti laj ababaꞌale ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ti Jesuse jech laj stacꞌbe: ―Ti buchꞌu laj stsꞌun ti lequil tsꞌunobale, jaꞌ jcꞌoplal vuꞌun ti coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ti yav tsꞌunobale, jaꞌ ti cristianoetic ti oyic ta sbejel banomile. Ti lequil tsꞌunobale, jaꞌic ti buchutic ta xichꞌic ta mucꞌ ti ventainel yuꞌun ti Diose. Ti trigo tꞌule, jaꞌic ti buchꞌutic ventainbilic yuꞌun ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ti buchꞌu laj stsꞌun ti trigo tꞌule, jaꞌ ti pucuj stuque. Ti tsꞌunobal ti ta xichꞌ tsobele, jaꞌ smelol ti slajebal cꞌacꞌale. Ti jtsob-tsꞌunobaletique, jaꞌ ti ángeletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yan ti trigo tꞌul ti ta xichꞌ tsobele, ti ta xichꞌ chiqꞌuel ta cꞌoqꞌue, jaꞌ smelol ti jaꞌ jech sꞌelan ta xcꞌot ta pasel ta stojol cristianoetic ta slajebal cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ti vuꞌun coꞌol jꞌelantique ta xcalbe mantal ti cajꞌángeltaque yoꞌ jech ta stsobic loqꞌuel ta jtojol ti jsaꞌmuliletique schiꞌuc ti buchꞌutic ta xacꞌbe yil ta spasel mulil ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta xjipatic ochel ta cꞌocꞌ. Tey ta xꞌoqꞌuic. Tey xcꞌuxuxet ti yeique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yan ti buchꞌutic ta spasic ti cꞌusi ta scꞌan ti Diose, coꞌol sꞌelan xojobal cꞌacꞌal xnobetic ti bu ta xventainvan ti Jtotique. Ti mi oy achiquinique, chiquintaic lec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ti Jesuse jech laj yal xtoc: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal ti meꞌtaqꞌuin ti mucul ta jsep osile. Ti meꞌtaqꞌuine laj sta jun vinic. Jech ti vinique laj xchaꞌmuc lec comel ti bu onoꞌox oye. Jaꞌ yuꞌun un, xmuyubaj xa ba xchon scotol ti cꞌusitic oy yuꞌune, yoꞌ jech ta sman ti jsep osile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ti Jesuse jech laj yal xtoc: ―Jaꞌ jech xtoc ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal jun jbolomajel vinic ti ta saꞌolan ti lequil perla tone. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cꞌalal mi laj sta jun perla ton ti toj toyol stojole, jaꞌ yuꞌun un, ta xbat xchon scotol ti cꞌusitic oy yuꞌune, yoꞌ jech ta sman ti perla tone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jech laj yal xtoc ti Jesuse: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal ti stsacobil choy ti ta xichꞌ jipel ochel ta yut nabe, yoꞌ jech ta xꞌoch talel ti ep ta tos choye. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cꞌalal ta xnoj ta choy ti stsacobile, jech ti jtsac-choyetique ta snitic loqꞌuel ta tiꞌ nab. Tey ta xchotiic ta stꞌujel ti choye. Ta sticꞌ ta moch ti bu lequique. Yan ti bu mu xtune ta sjipic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jaꞌ jech sꞌelan ta xcꞌot ta pasel cꞌalal ta sta ti slajebal cꞌacꞌale. Ta xloqꞌuic batel ti ángeletique ta xchꞌaquel loqꞌuel ti chopol cristianoetic ta stojolic ti lequil cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ti chopol cristianoetique ta xjipatic ochel ta cꞌocꞌ. Tey ta xꞌoqꞌuic. Tey xcꞌuxuxet ti yeique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ti Jesuse jech laj sjacꞌ: ―¿Mi xavaꞌibeic smelol scotol ti vaꞌi sꞌelan laj cale? ―xi. Jech laj staqꞌuic: ―Laj caꞌicutic, Cajval ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ti Jesuse jech laj yalbe: ―Ti jun jchanubtasvanej yuꞌun ti mantale, cꞌalal chanubtasbil yuꞌun ti ventainel yuꞌun ti Diose, coꞌol sꞌelan jech chac cꞌu chaꞌal jun yajval na ti oy cꞌusi chaꞌtos xchabioj teye. Ti vinic taje ta snaꞌ stꞌunesel schibal, ti cꞌusi pocoꞌe, ti cꞌusi achꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cꞌalal laj yoꞌnton ta chanubtasvanej ta babacꞌop ti Jesuse, ilocꞌ batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Icꞌot ta steclumal. Tey lic chanubtasvanuc ta chꞌul na. Jech ti cristianoetique chꞌayal icꞌot yoꞌntonic. Jech ta xalbe sbaic: ―¿Bu laj sta sbijil ti vinic leꞌe? ¿Cꞌusi xut ti ta xacꞌ iluc ti smucꞌul stsatsale? ");
INSERT INTO tzotzc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yuꞌun ti vinic leꞌe, jaꞌ snichꞌon ti jcarpinteroe. Jaꞌ squerem ol xtoc ti Maríae. Ti yitsꞌinabtaque, jaꞌ ti Jacoboe, ti Josee, ti Simone, ti Judase. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jech ti yixleltac xtoque liꞌ nacalique. Jech o xal, ¿bu laj xchan talel scotol ti vi sꞌelan ta spase? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jech o xal ti cristianoetique muꞌyuc laj yichꞌic ta mucꞌ ti Jesuse. Ti Jesuse jech lic yal: ―Scotol cristianoetic ta xichꞌic ta mucꞌ jun jꞌalcꞌop. Pero ti ta slumal stuque, ti ta sna stuque, bajbil ta xcꞌot yuꞌunic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jech o xal ti Jesuse mu másuc tey laj yacꞌ ta ilel ti smucꞌul stsatsale. Jaꞌ ti mu xꞌichꞌat ta muqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti jech yorail taje, ti ajvalil Herodes ta Galilea banomile laj yaꞌibe scꞌoplal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jech o xal un, laj yalbe ti svinictaque: ―Ti vinic taje, jaꞌ ichaꞌcuxi talel ti Juan jꞌacꞌ-ichꞌ-voꞌe. Jech o xal ta xacꞌ iluc ti smucꞌul stsatsale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yuꞌun ti Herodese snaꞌoj lec ti laj sticꞌ ta chuquel ti Juane, ti laj xchuc ta cadena taqꞌuin ta scoj ti ants Herodíase, ti jaꞌ yajnil ti yitsꞌine, ti jaꞌ Felipe sbie. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ti Juane jech onoꞌox laj yalbe ti ajvalil Herodese: ―Mu xuꞌ ta xavajnilanbe yajnil ti avitsꞌine ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ti ajvalil Herodese ta smil ox yaꞌi ti Juane. Pero ixiꞌ yuꞌun ti cristianoetique. Yuꞌun ti cristianoetique xchꞌunojic ti jaꞌ jun yajꞌalcꞌop Dios ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cꞌalal ista scꞌacꞌalil ti cꞌusi ora ivocꞌ ti Herodese, laj spas qꞌuin. Jech ti yantsil ol ti Herodíase tey bat acꞌotajuc ta stojolic ti cristianoetic ti icꞌbilic ta qꞌuine. Ti Herodese toj cꞌupil sba laj yil. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jech o xal ti Herodese jech laj yalbe ti tsebe: ―Xil Dios, cꞌanbun ti cꞌusiuc noꞌox ta xacꞌane, ta xacacꞌbot ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Cꞌalal jech iꞌalbat ti tsebe, jaꞌ ba sjacꞌbe talel ti smeꞌe ti cꞌusi ta scꞌane. Jech vul yalbe ti ajvalile: ―Acꞌbun tal ta ba platu sjol ti Juan jꞌacꞌ-ichꞌ-voꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ti ajvalil Herodese iꞌoch ta at oꞌnton ti jech laj yaꞌie. Pero mu xuꞌ ta sutes ye, jaꞌ ti laj svaꞌan ta rextigo ti Diose schiꞌuc ti laj yaꞌiic scotolic ti buchꞌutic yicꞌoj talele. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jech o xal laj yal mantal ti acꞌo yichꞌ bojbel talel sjol ti Juan ti tiqꞌuil ta chuquele. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Cꞌalal laj sbojbeic sjol ti Juane, laj scajanic talel ta platu. Tey tal yacꞌbeic ti tsebe. Jech xtoc ti tsebe ba yacꞌbe ti smeꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ti yajchancꞌoptac ti Juane bat sloqꞌuesic talel sbecꞌtal ti Juane yoꞌ jech ta smucbeic. Tsꞌacal to un, ba yalbeic yaꞌi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cꞌalal jech laj yaꞌi ti Jesuse, stuc ilocꞌ batel. Iꞌoch bal ta barco. Ibat ti bu stsꞌijlan ti banomile. Pero ti cristianoetique laj yaꞌiic ti ibat ti Jesuse. Jech o xal iloqꞌuic batel ti ta jujun jteclume. Ixanavic bal ta yoquic yoꞌ chba saꞌic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cꞌalal ilocꞌ ta barco ti Jesuse, laj yil ti ep ti cristianoetique. Cꞌuxubaj yoꞌnton yuꞌunic. Ti Jesuse laj scolta ti jchameletic ti yicꞌojanic batele. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cꞌalal ta xa xmal batel ti cꞌacꞌale, inopajic bal ti yajchancꞌoptaque. Jech laj yalic: ―Mal xa ti cꞌacꞌale. Jaꞌ jech xtoc ti liꞌe muꞌyuc jnaclejetic. Jaꞌ yuꞌun un, albo yaꞌi ti cristianoetique ti acꞌo baticuc yoꞌ chba sman sveꞌelic ti ta jujun jteclume ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ti Jesuse jech laj stacꞌ: ―Acꞌbeic sveꞌel ti voꞌoxuque. ¿Cꞌu yuꞌun ta xbatic? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ti stuquique jech laj staqꞌuic: ―Muꞌyuc ep ti jveꞌelcutique. Cꞌajomal noꞌox voꞌob pan schiꞌuc chaꞌcot choy ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ti Jesuse jech laj yal: ―Ichꞌbeicun talel taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ti Jesuse laj yal mantal ti acꞌo choticuc ta yaxaltic scotolique. Tsꞌacal to un, lic stsac ti voꞌob pane schiꞌuc ti chaꞌcot choye. Laj sqꞌuel muyel ti vinajele. Laj yalbe vocol ti Diose. Tsꞌacal to un, lic xet ti pane, ti choye. Laj yacꞌbe jelavel ti yajchancꞌoptaque. Jech ti yajchancꞌoptaque lic spucbeic scotol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Scotolic iveꞌic lec. Nojic lec. Tsꞌacal to un, inoj lajchaꞌmoch scomelal ti veꞌlile. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ti iveꞌique, oy nan voꞌmiluc ti viniquetique. Parte ti antsetique schiꞌuc ti ololetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ti Jesuse laj yacꞌ ochicuc batel ta barco ti yajchancꞌoptaque yoꞌ jech baꞌyel ta xjelavic batel ta jot nab. Tey to icom stuc yoꞌ jech ta scꞌopon comel ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cꞌalal laj yoꞌnton ta scꞌoponel comele, jech ti Jesuse imuy batel ta vits yoꞌ ta sta ta cꞌoponel Dios stuc. Cꞌalal iꞌoch ti acꞌobale, stuc tey oy ta vits ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yan ti yajchancꞌoptaque tey xa xcajetic batel ta oꞌlol nab. Ti syucꞌbenal ti nabe ta smajolan ta jmec ti barcoe. Yuꞌun toj tsots ti iqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cꞌalal ta xa sacub talele, tey ta xanav talel ta ba voꞌ ti Jesuse. Inopaj tal ta stojol ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cꞌalal jech laj yilic ti yajchancꞌoptac ti ta xanav talel ta ba voꞌe, tey iꞌavanic ta xiꞌel: ―Tal xa sbel banomil ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ti Jesuse jech laj yal: ―Mu xaxiꞌic. Tsotsanic. Vuꞌunun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ti Pedroe jech laj yal: ―Cajval, mi ta melel ti voꞌote, alo ti acꞌo xanavcun talel ta ba voꞌ ti bu oyote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ti Jesuse jech laj yal: ―Laꞌ chaꞌe laꞌ ―xi. Jech ti Pedroe yal ta barco. Lic xanavic batel ta ba voꞌ yoꞌ chba sta ti bu oy ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero cꞌalal laj yil ti tsots ti iqꞌue, tey ital xiꞌel ta yoꞌnton. Cꞌalal ta xa xmutꞌij ta voꞌe, lic avanuc: ―Coltaun, Cajval ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti Jesuse ta ora noꞌox ba snitbe scꞌob. Jech laj yal: ―Muꞌyuc achꞌunoj ti xuꞌ cuꞌune. ¿Cꞌu yuꞌun lachibaj? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cꞌalal iꞌochic ti schibalic ta barcoe, jaꞌ o paj ti iqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jech ti buchꞌutic oyic ta yut barcoe lic squejan sbaic ta stojol ti Jesuse. Jech laj yalic: ―Melel, ti voꞌote Snichꞌonot ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cꞌalal ijelavic ta jot nabe, icꞌotic ta Genesaret banomil. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Cꞌalal laj yaꞌiic ti cristianoetic ti jaꞌ Jesús ti tey icꞌote, jech o xal laj spucbeic bal scꞌoplal ta slumalic. Jech xtoc laj yiqꞌuic talel ta stojol Jesús ti yajchamelique. ");
INSERT INTO tzotzc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ti cristianoetique laj scꞌanbeic vocol ti acꞌo yacꞌ ta piquel jutebuc stiꞌil scꞌuꞌ. Scotolic ti buchꞌutic laj sta ta picbel stiꞌil ti scꞌuꞌe, colem icomic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oy jlom jfariseoetic schiꞌuc jlom jchanubtasvanejetic yuꞌun mantal ti liquemic talel ta jteclum Jerusalene, inopajic ta stojol ti Jesuse. Jech lic sjaqꞌuic: ");
INSERT INTO tzotzc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Ti avajchancꞌoptaque, ¿cꞌu yuꞌun ta sbajic ti cꞌusi liquem yuꞌunic ti jtot jmeꞌtique? Muꞌyuc ta xcꞌot ta pasel yuꞌunic ti ep ta velta ta spoc scꞌobic ti cꞌalal ta xveꞌique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ti Jesuse jech lic sjacꞌbe: ―Ti voꞌoxuc eque, ¿cꞌu yuꞌun ta xabajbeic smantal ti Diose, yoꞌ jech staoj yav atsacojic ti stalel atot ameꞌique? ");
INSERT INTO tzotzc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yuꞌun ti Diose jech laj yal: “Ichꞌo ta mucꞌ atot ameꞌ. Yan ti buchꞌu chopol ta xcꞌopoj ta stojol ti stot smeꞌe, acꞌo chamuc”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero ti voꞌoxuque ta xachanubtasic ti xuꞌ jech ta xalbeic ti stot smeꞌique: “Mu xuꞌ ta jcoltaot. Yuꞌun scotol ti cꞌusi oy cuꞌune, laj xa cacꞌbe smotonin ti Diose”, xavutic ti atot ameꞌique, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Buchꞌuuc noꞌox ti jech ta xalic avuꞌunic taje, xuꞌ xa ti muꞌyuc ta scolta ti stot smeꞌique. Ti jech ta xapasic taje, laj xa avictaic comel smantal ti Diose yoꞌ jech staoj yav ta xapasic stalel ti atot ameꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ta xapacꞌta abaic. Ta melel jaꞌ acꞌoplalic ti cꞌusi laj stsꞌiba comel ti jꞌalcꞌop Isaíase: ");
INSERT INTO tzotzc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ti cristianoetic liꞌe jun yutsil ti ye ta xichꞌicun ta mucꞌ yilele. Pero ti yoꞌntonique nom oy ta jtojol. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Muꞌyuc cꞌusi bal o ti jech nijil chimilique. Yuꞌun ti cꞌusi ta xchanubtasvanique smantal noꞌox viniquetic, xi ti Dios ti laj stsꞌiba comel ti Isaíase, xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jech o xal ti Jesuse tey laj yicꞌ talel ti cristianoetique. Jech laj yal: ―Tsꞌetano achiquinic. Aꞌyio avaꞌiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ti cꞌusiuc noꞌox ti ta slajes ti vinique, maꞌuc ta soquesat o. Pero ti bu ta soquesat ti vinique, jaꞌ ti cꞌusi ta xlocꞌ ta yee ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jech ti yajchancꞌoptaque inopajic talel ta stojol ti Jesuse. Jech laj yalic: ―¿Mi xanaꞌ ti isoc sjolic ti jfariseoetic ti jech laj avale? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero ti Jesuse jech itacꞌav: ―Cꞌusiuc noꞌox teꞌal ti maꞌuc tsꞌunbil yuꞌun ti Jtot ti oy ta vinajele, ta xichꞌ bulel loqꞌuel schiꞌuc yibel. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chꞌan utic, yuꞌun maꞌsatetic ti ta snitbeic batel scꞌob ti yan maꞌsatetique. Ti mi coꞌol maꞌsatetic ta snit sbaic batele, schibal ta xbajic ta lom chꞌen ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ti Pedroe jech laj yalbe ti Jesuse: ―Albun caꞌicutic smelol ti babacꞌop ti vaꞌi sꞌelan laj avale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ti Jesuse jech laj stacꞌ: ―¿Mi muꞌyuc laj avaꞌibeic smelol ec ti jech laj cale? ");
INSERT INTO tzotzc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mi mu xanaꞌic ti cꞌusiuc noꞌox ti ta slajes ti vinique ta xꞌoch ta ye, ta xbat cꞌalal schꞌut? Tsꞌacal to ta xlocꞌ batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ti cꞌusitic chopol ti ta xlocꞌ ta ye ti vinique, ta xꞌayan talel ta yoꞌnton. Ti jech taje, jaꞌ ta soquesat yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yuꞌun ta yoꞌntonic ta xꞌayan talel ti chopol snopobil yuꞌunique, ti ta xmilvanique, ti ta xcꞌupinvanique, ti ta xmulivajique, ti ta xꞌelcꞌajique, ti ta sjutilanic ti cꞌope, ti cꞌusiuc noꞌox sjovil alique. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ti jech taje, jaꞌ ta soquesat ti vinique. Yan ti mi jaꞌ noꞌox muꞌyuc bu ta spoc scꞌobic ti cꞌalal ta xlic veꞌicuque, maꞌuc ta soquesatic o ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ti Jesuse ilocꞌ batel. Tey ibat ti bu oy chib jteclume ti jaꞌ ti Tiroe schiꞌuc ti Sidone. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Oy jun ants ti liquem tal ta Canaane ti xꞌavet tal ta stojol ti Jesuse: ―Cajval, Snitilulot David, cꞌuxubinun. Ti jtsebe ta xꞌilbajinat yuꞌun ti pucuje. Ep ta xichꞌ svocol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ti Jesuse muꞌyuc laj stacꞌbe ti antse. Ti yajchancꞌoptaque tal scꞌanbe vocol ti Jesuse: ―Ti ants liꞌe, albo yaꞌi ti acꞌo batuque. Yuꞌun liꞌ xꞌavet tal ta jpatique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ti Jesuse jech laj stacꞌbe ti antse: ―Jaꞌ noꞌox tacbilun talel yuꞌun ti Diose ta sventa ti jchꞌayel-chijetic ta slumal Israele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero ti antse inopaj tal squejan sba ta stojol. Jech laj yal: ―Cajval, coltaun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ti Jesuse jech laj stacꞌ: ―Mu lecuc ti ta jpojbetic sveꞌel ti calab jnichꞌnabtique, yoꞌ ta xcacꞌbetic sveꞌ ti tsꞌiꞌetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Manchuc mi jech iꞌalbat ti antse, jech laj yal: ―Jech xaval avaꞌuc, Cajval. Pero ti tsꞌiꞌetique ta stambeic schꞌuchꞌulil yot yajval ti ta xbaj ta ba mexae ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jech ti Jesuse jech laj yal: ―Toj echꞌem achꞌunojun, Ants. Jech acꞌo cꞌotuc ta pasel jech chac cꞌu chaꞌal ta xacꞌane ―xi. Cꞌalal jech laj yal taje, colem icom stseb ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ti Jesuse ilocꞌ batel ti bu to ox oye. Iꞌechꞌ batel ta stiꞌil nab Galilea. Tsꞌacal to tey imuy batel ta vits, tey cꞌot chotluc. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ep ti cristianoetic laj cꞌoticuc ta vits ti bu chotole. Yicꞌojanic talel coxovetic, maꞌsatetic, umaꞌetic, tuncoetic, schiꞌuc yan jchameletic. Laj yaqꞌuic ta stojol ti Jesuse. Scotol ti jchameletique icol yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ti cristianoetique chꞌayal icꞌot yoꞌntonic ti jech laj yilic ti lic cꞌopojicuc ti umaꞌe, ti lic lecubic ti tuncoe, ti lic xanavicuc ti coxove, ti lic jamuc sat ti maꞌsate. Jech o xal scotolic lic lequil-cꞌopojicuc ta stojol ti Dios yuꞌun ti Israele. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque. Jech lic yalbe: ―Cꞌux ta coꞌnton ti cristianoetique. Yuꞌun oy xa ta yoxibal cꞌacꞌal ti liꞌ tsobolic ta jtojole. Muꞌyuc xa cꞌusi ta slajesic. Jech o xal mu jcꞌan ta jtac batel ta snaic cꞌalal muꞌyuc veꞌemique. Ti mi ta jtac batele, xuꞌ ta slubtsajic ta be ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ti yajchancꞌoptaque jech laj yalic: ―¿Cꞌusi ta xcutcutic ti ta jtabecutic sveꞌel ti epal cristianoetic liꞌe? Yuꞌun ti bu oyotique mi jaꞌuc jnaclejetic oy ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ti Jesuse jech laj sjacꞌ: ―¿Jayib pan oy avuꞌunic? ―xi. Jech laj staqꞌuic: ―Jaꞌ noꞌox vucub pan schiꞌuc jaycot choy ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jech ti Jesuse laj yal mantal ti acꞌo chotlicuc scotolic ta lumtique. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cꞌalal jech laj chotlicuque, jaꞌ o lic stsac ti vucub pane schiꞌuc ti jaycot choye. Tey laj yalbe vocol ti Diose. Tsꞌacal to un, lic xet ti pane schiꞌuc ti choye. Laj yacꞌbe jelavel ti yajchancꞌoptaque. Jech ti yajchancꞌoptaque tey laj spucbeic ti epal cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iveꞌic scotolic. Nojic lec. Tsꞌacal to un, tey laj stsobic vucub moch scomelal ti sveꞌelique. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ti veꞌique, oy nan chanmil viniquetic. Parte ti ololetique schiꞌuc ti antsetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tsꞌacal to un, ti Jesuse laj scꞌopon comel ti cristianoetique. Tey iꞌoch bal ta barco. Bat cꞌalal to jteclum Magdala. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ti jfariseoetique schiꞌuc ti jsaduceoetique bat sqꞌuelic ti Jesuse yoꞌ jech ta sbajesic ta cꞌocꞌ. Laj scꞌanbeic ti acꞌo yacꞌ iluc smucꞌul stsatsal ti ta xlic talel ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ti Jesuse jech laj stacꞌbe: ―Mi ta xavilic ti lec tsoj ti vinajel ti cꞌalal mal xa bal ti cꞌacꞌale, jech ta xavalic: “Toj lec ti cꞌacꞌal ocꞌome”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yan ti mi ta xavilic ta sob icꞌluman tsoj schiꞌuc butꞌul ti vinajel ta sloqꞌueb cꞌacꞌale, jech ta xavalic: “Muꞌyuc lec ti cꞌacꞌal tanae”, xachiic. Toj ven xapacꞌta abaic. Lec xanaꞌic sqꞌuelel ti cꞌu sꞌelan xlaj echꞌuc ti jujun cꞌacꞌale. Pero mu xanaꞌic sqꞌuelel, mu xavaꞌibeic smelol ti cꞌusi ta jpas liꞌ ta atojolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ti chopol cristianoetique, ti muꞌyuc tucꞌ yoꞌntonique, ta scꞌan yaꞌiic ta sqꞌuelic ti jmucꞌul jtsatsale. Pero mu xꞌacꞌbat yilic. Jaꞌ noꞌox jech yepal ta xꞌacꞌbat yilic señail jech chac cꞌu chaꞌal icꞌot ta pasel ta stojol ti Jonase ―xi. Cꞌalal jech laj yale, laj yicta comel, ibat. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cꞌalal ijelavic batel ta jot stiꞌil nab ti yajchancꞌoptaque, ichꞌay ta yoꞌntonic ta yichꞌel bal ti spanique. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ti Jesuse jech laj yalbe: ―Bijanic me yuꞌun ti spajubtasobil spanic ti jfariseoetique, ti jsaduceoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ti yajchancꞌoptaque jech lic yalbe sbaic: ―Ti jech ta xal taje, jaꞌ ti ichꞌay ta coꞌntontic ta yichꞌel tal ti jpantique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ti Jesuse laj yil ti jech ta snopique. Jech laj yalbe: ―¿Cꞌu chaꞌal ta xavalic ti chꞌabal apanique? Mu xachꞌunic ti xuꞌ cuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mi mu to ta xcꞌot ta avoꞌntonic? ¿Mi yuꞌun ichꞌay xa ta avoꞌntonic ti ta voꞌob noꞌox pan laj jmalqꞌuin voꞌob mil viniquetic? Jaꞌ jech xtoc, ¿jayib moch laj atsobic ti scomelale? ");
INSERT INTO tzotzc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Mi yuꞌun ichꞌay xa ta avoꞌntonic xtoc ti ta vucbej pan laj jmalqꞌuin ti chanmil viniquetique? Jaꞌ jech xtoc, ¿jayib moch laj atsobic ti scomelale? ");
INSERT INTO tzotzc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ti cꞌalal laj calboxuc avaꞌiic ti bijanic me yuꞌun ti spajubtasobil spanic ti jfariseoetique, ti jsaduceoetique ti xacutique, ¿cꞌu chaꞌal ti muꞌyuc bu laj avaꞌibeic smelol ti maꞌuc scꞌoplal pan ta xcale? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cꞌalal jech laj yale, jech ti yajchancꞌoptaque jaꞌ o tey ivul ta yoꞌntonic ti maꞌuc spajubtasobil ti pane. Jaꞌ to laj snaꞌic ti jaꞌ smelol ti cꞌu sꞌelan ta xchanubtasvanic ti jfariseoetique schiꞌuc ti jsaduceoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cꞌalal icꞌot ta jteclum Cesarea Filipo ti Jesuse, tey laj sjacꞌbe ti yajchancꞌoptaque: ―¿Buchꞌuun ta xalic ti cristianoetic ti vuꞌun coꞌol jꞌelantique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ti stuquique jech laj staqꞌuic: ―Oy jlom ta xalic ti voꞌot la ti Juan jꞌacꞌ-ichꞌ-voꞌe. Oy jlom ta xalic ti voꞌot la ti Elíase. Ta xalic jlom xtoc ti voꞌot la ti Jeremíase. Mi moꞌoje, jaꞌ la jun jꞌalcꞌopot ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ti Jesuse jech laj yal: ―Ti voꞌoxuque, ¿buchꞌuun ti ta xavalique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ti Simón Pedroe jech laj yal: ―Voꞌot ti Cristoe, Snichꞌon ti cuxul Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ti Jesuse jech laj stacꞌ: ―Toj yan avutsil ti voꞌote, Simón, snichꞌon Jonás. Ti vaꞌi sꞌelan ta xanaꞌ ti Buchꞌuune, maꞌuc jun vinic laj yacꞌbot anaꞌ. Jaꞌ laj yacꞌbot anaꞌ ti Jtot ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Vuꞌun ta xcalbot avaꞌi ti Pedroote. Voꞌot ta aventa ta xlic boluc ti jchꞌunolajeletique. Mi jaꞌuc ta xmacatic ta be yuꞌun yip stsatsal ti lajebale. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta xcacꞌbot sllavial ti ventainel yuꞌun ti Dios ti oy ta vinajele. Ti mi chuculot xavut liꞌ ta banomile, jaꞌ jech chucul ta xꞌilat yuꞌun ti Dios ti oy ta vinajele. Ti mi colemot xavut liꞌ ta banomile, jaꞌ jech colem ta xꞌilat yuꞌun ti Dios ti oy ta vinajele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jech ti Jesuse laj yalbe ti yajchancꞌoptaque ti mu me buchꞌu xalbe yaꞌi ti jaꞌ Cristo ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti Jesuse jaꞌ o tey lic yalbe yaꞌiic ti yajchancꞌoptaque: ―Ti vuꞌune persa ta xibat ta Jerusalén. Tey ep ta xquichꞌ jvocol yuꞌun ti moletique, ti banquilal paleetique, ti jchanubtasvanejetic yuꞌun ti mantale. Ta xiyaqꞌuic ta milel. Pero ta xichaꞌcuxi ta yoxibal cꞌacꞌal ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jech ti Pedroe laj yicꞌ loqꞌuel ti Jesús ti bu oyique. Jech tsots laj yal: ―Mu jechuc scꞌan Dios, Cajval. Mu me xcꞌot ta atojol jech taje ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero ti Jesuse tey ijoybij. Jech laj yalbe ti Pedroe: ―Chꞌaco aba ta jtojol, Pucuj. Yuꞌun ta xamacun ta be. Yuꞌun maꞌuc ta xanop jech chac cꞌu chaꞌal ta snop ti Diose. Yuꞌun jaꞌ noꞌox ta xanop jech chac cꞌu chaꞌal ta snop ti viniquetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tsꞌacal to un, ti Jesuse jech lic yalbe yaꞌiic ti yajchancꞌoptaque: ―Mi oy buchꞌu ta scꞌan ta xistsꞌacliun batele, acꞌo me xtuchꞌ ta yoꞌnton ti scuxlejal stuque manchuc mi ta xichꞌ svocol. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yuꞌun ti buchꞌu tsots scꞌoplal ta xaꞌi ti scuxlejale, jaꞌ ta xchꞌay. Pero ti buchꞌu mu tsotsuc ta xaꞌi ti scuxlejal ta jventae, jaꞌ ta sta. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Cꞌusi bal o ti vinique ti mi jaꞌ noꞌox ta xyuꞌunin scotol ti sba banomile ti mi chꞌayel ta xbat ti schꞌulele? ¿Cꞌusi xa ta xut ta sman loqꞌuel ti schꞌulele? ");
INSERT INTO tzotzc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yuꞌun ti vuꞌun coꞌol jꞌelantique ta xichaꞌsut talel. Ta xquichꞌbe talel yutsilal slequilal ti Jtote schiꞌuc ti yajꞌángeltaque, yoꞌ jech chtal cacꞌbe yichꞌ stojol ti cristianoetic ti cꞌusi laj xa spasic ta jujun tale. ");
INSERT INTO tzotzc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta melel ta xcalboxuc avaꞌiic, oy jlomoxuc liꞌe oy ti mu to ta xachamique jaꞌ to mi laj avilic ti ta xital ventainvancun ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Echꞌem xa ox vaquib cꞌacꞌal cꞌalal ibatic ta sjol jun mucꞌ ta vits ti Jesuse schiꞌuc ti Pedroe, ti Jacoboe, ti Juane, ti jaꞌ yitsꞌin ti Jacoboe. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ti ta jol vitse, iyanij ti cꞌu sꞌelan to ox ti Jesuse tey ta stojol ti oxvoꞌ yajchancꞌoptaque. Lic ayanuc xojobal ti sate coꞌol sꞌelan jech chac cꞌu chaꞌal xojobal cꞌacꞌal. Ti scꞌuꞌe isacub ta jmec jech chac cꞌu chaꞌal ti luze. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ti oxib yajchancꞌoptaque jaꞌ o tey laj yilic ti ta xloꞌilajic ti Jesuse schiꞌuc ti Moisese, schiꞌuc ti Elíase. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jech ti Pedroe jech laj yalbe yaꞌi ti Jesuse: ―Cajval, toj lec ti liꞌ oyotique. Ti mi ta xacꞌane, ta jpascutic oxib axibal na, jun avuꞌun, jun yuꞌun ti Moisese, jun yuꞌun ti Elíase ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cꞌalal jech yacal ta xcꞌopoj ti Pedroe, jaꞌ o ital voliaticuc ta saquil toc. Tey laj yaꞌiic ti oy Buchꞌu ta xcꞌopoj talele: ―Jaꞌ ti jcꞌuxubinbil Nichꞌon liꞌe, ti ximuyubaj xa yuꞌune. Aꞌibeic lec ti scꞌope ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cꞌalal jech laj yaꞌiic ti oxib yajchancꞌoptaque, ta xiꞌel lic snijan sbaic ta lum. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jech ti Jesuse bat stij ti yajchancꞌoptaque. Jech lic yalbe: ―Licanic. Mu xaxiꞌic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cꞌalal lic stoy ti satique, muꞌyuc xa buchꞌu laj yilic. Jaꞌ xa noꞌox stuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cꞌalal ta xa xyalic tal ti ta vitse, ti Jesuse jech laj yal: ―Mu me buchꞌu xavalbe yaꞌi ti laj xa avilicun ti liyanije. Jaꞌ to xuꞌ xavinajesic ti cꞌalal ta xichaꞌcuxi ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ti yajchancꞌoptaque tey lic sjacꞌbeic ti Jesuse: ―¿Cꞌu chaꞌal ta xalic ti jchanubtasvanejetic yuꞌun ti mantale ti jaꞌ baꞌyel ta xtal ti Elíase? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ti Jesuse jech itacꞌav: ―Ta melel ta xcalboxuc avaꞌiic, ta xal ti scꞌop Diose ti baꞌyel ta xtal ti Elíase, yoꞌ ta xchapan scotol. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero vuꞌun ta xcalboxuc avaꞌiic, ti Elíase ay xa. Pero ti cristianoetique muꞌyuc laj yojtiquinic. Jech o xal laj spasic ti cꞌusitic ta scꞌan yoꞌntonic ta stojol ti Elíase. Jaꞌ jech ta spasic ta jtojol ec ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jech o xal ti yajchancꞌoptaque lic yaꞌibeic smelol ti jaꞌ scꞌoplal Juan jꞌacꞌ-ichꞌ-voꞌ ti vaꞌi sꞌelan laj yal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cꞌalal icꞌotic ti bu oy ti cristianoetique, tey inopaj talel jun vinic, vul squejan sba ta stojol ti Jesuse. Jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Cajval, cꞌuxubinbun ti jnichꞌone. Yuꞌun tsacbil ta tub icꞌ. Toj tsots ta xichꞌ svocol. Ep ta velta ta sjip sba ta cꞌocꞌ, ta sjip sba ta voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Laj quicꞌ talel ta stojol ti avajchancꞌoptaque, pero muꞌyuc xuꞌ yuꞌunic scoltael ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ti Jesuse jech itacꞌav: ―Jecheꞌoxuc. Muꞌyuc atuqꞌuilic. Ep xa cꞌacꞌal liꞌ oyun ta atojolique. Ep xa cꞌacꞌal liꞌ jtsꞌicojboxuque. Icꞌbun talel ti anichꞌone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jech o xal ti Jesuse laj yut loqꞌuel ti pucuj ti oy ta yoꞌnton ti quereme. Colem icom ta ora. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cꞌalal stuquic xa ti Jesús schiꞌuc ti yajchancꞌoptaque, tey laj sjacꞌbeic: ―¿Cꞌu chaꞌal muꞌyuc xuꞌ cuꞌuncutic sloqꞌuesel ti chopol pucuje? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ti Jesuse jech itacꞌav: ―Yuꞌun ti voꞌoxuque muꞌyuc lec achꞌunojic ti xuꞌ yuꞌun ti Diose. Ta melel ta xcalboxuc avaꞌiic, manchuc mi coꞌol sꞌelan smucꞌul jbej becꞌ mostaza ti achꞌunojic ti xuꞌ yuꞌun ti Diose, xuꞌ ta xavalbeic ti vits liꞌe: “Locꞌan batel, batan ta yan”, ti mi xavutique, ta xchꞌunboxuc. Muꞌyuc cꞌusi ti mu xcꞌot ta pasel ti mi achꞌunojic leque. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ti pucuj ti vi sꞌelane, jaꞌ noꞌox xuꞌ ta xlocꞌ ti mi ta jtatic ta cꞌoponel ti Diose schiꞌuc ti ta jcomtsan ti cotique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cꞌalal yacal ta xanavic batel ta Galilea banomile, ti Jesuse jech lic yalbe yaꞌiic ti yajchancꞌoptaque: ―Ti vuꞌun coꞌol jꞌelantique ta xquichꞌ aqꞌuel ta yoc ta scꞌob ti viniquetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta xiyilbajinicun. Ta xismilicun. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. Ti vaꞌi sꞌelan laj yal ti Jesuse, toj ep laj yat yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cꞌalal icꞌotic ta jteclum Capernaum ti Jesuse schiꞌuc ti yajchancꞌoptaque, jaꞌ o tey italic ti buchꞌutic ta scꞌanic ti patan taqꞌuin yuꞌun ti temploe. Tey ibatic ta stojol ti Pedroe ti jech laj sjaqꞌuique: ―Ti jchanubtasvanej avuꞌunique, ¿mi muꞌyuc van ta stoj ti patan taqꞌuin yuꞌun ti temploe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ti Pedroe jech itacꞌav: ―Ta stoj ―xut. Cꞌalal iꞌoch bal ta na ti Pedroe, jaꞌ baꞌyel lic cꞌopojuc ti Jesuse ti jech laj yale: ―¿Cꞌusi ta xanop ti voꞌote, Simón? Ti ajvaliletic liꞌ ta banomil ti ta scꞌanic ti patan taqꞌuine, ¿bu ta xba scꞌanic? ¿Mi jaꞌ chba scꞌanbe ti snichꞌnabique? ¿Mi jaꞌ ta scꞌanbe ti yan cristianoetique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ti Pedroe jech laj stacꞌ: ―Jaꞌ ta scꞌanbe ti yan cristianoetique ―xi. Ti Jesuse jech laj yal: ―Jech xaval avaꞌuc. Maꞌuc ta stojic patan taqꞌuin snichꞌnab ti ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero yoꞌ jech mu junuc ta jsoquesbe ti yoꞌntonique, batan ta nab, jipo ochel ti stsacobil choye. Tsaco loqꞌuel ti choy ti baꞌyel ta stsac ti stsacobile. Jachꞌbo ti yee. Tey ta xata jsep taqꞌuin ti lec ta xlocꞌ o ti jpatantaqꞌuintique. Ichꞌo batel. Tojbo ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tey inopajic talel ta stojol Jesús ti yajchancꞌoptaque. Jech laj sjacꞌbeic: ―Cꞌalal ta xlic ventainvane, albun caꞌicutic, ¿buchꞌu ti más banquilal ta xcꞌot cuꞌuncutique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ti Jesuse tey laj yicꞌ talel jun olol. Laj svaꞌan ta oꞌlol. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jech lic yal: ―Ta melel ta xcalboxuc avaꞌiic, ti mi mu xajelta avoꞌntonique, ti mi mu jechuc avoꞌntonic jech chac cꞌu chaꞌal ti olol liꞌe, mu xuꞌ xaꞌochic ti bu ta xventainvan ti Dios ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jech o xal ta xcalboxuc avaꞌiic, ti buchꞌu más banquilal ta xcꞌot ti bu ta xventainvan ti Diose, jaꞌ noꞌox ti buchꞌu ta sbicꞌtajes sba jech chac cꞌu chaꞌal ti olol liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Buchꞌuuc noꞌox ti ta jventa vuꞌun ta xichꞌ ta mucꞌ jun olol jech chac cꞌu chaꞌal ti olol liꞌe, vuꞌun ta xiyichꞌicun ta mucꞌ ec. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Buchꞌuuc noꞌox ti ta xchanubtas ta saꞌ mulil jun olol ti ta xichꞌun ta muqꞌue, jaꞌ lec ti chuc xi choꞌ ta snucꞌ, jip xi yalel ta nab. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Toj abol sbaic ti cristianoetic liꞌ ta banomile ti oy cꞌusi ta sta ti smulic yuꞌune. Oy onoꞌox. Pero jaꞌ toj abol sba ti buchꞌu ti jaꞌ ta scoj ti ta xacꞌbe sta smul yuꞌun ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jech o xal ti mi jaꞌ acꞌob mi avoc ta xata o amul yuꞌune, jaꞌ lec seto loqꞌuel. Jipo batel ta nom. Yuꞌun jaꞌ más lec mi ta xaꞌoch batel ta lequilale acꞌo mi jun avoc mi jun acꞌob. Jaꞌ toj vocol ti ta xajipat ochel ta cꞌocꞌ sbatel osil schiꞌuc schibal ti avoc acꞌobe. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jaꞌ jech xtoc ti mi jaꞌ asat ta xata o amul yuꞌune, pitso loqꞌuel. Jipo batel ta nom. Jaꞌ más lec mi ta xaꞌoch ta lequilale acꞌo mi jbej xa ti asate. Jaꞌ toj vocol ti ta xajipat ochel ta cꞌocꞌ schiꞌuc schaꞌbejal ti asate. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Mu me xabajic mi junuc ti ololetic liꞌe. Yuꞌun ta xcalboxuc avaꞌiic, ventainbilic yuꞌun ti ángeletic ti tey ta stojol ti Jtot ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yuꞌun ti vuꞌun coꞌol jꞌelantique jaꞌ tal jcolta ti buchꞌutic chꞌayemique. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Cꞌusi ta xanopic? Mi oy jun vinic ti oy voꞌvinic (100) ta cot ti schije, pero mi ta xchꞌay jcote, ¿mi mu van teyuc lamal ta scomtsan ta vits ti yane, yoꞌ chba saꞌ talel ti jcot ti ichꞌaye? ");
INSERT INTO tzotzc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi laj sta ta saꞌel ti jcot schije, jech o xal ti vinique xmuyubaj xa ti laj sta ti jcote. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaꞌ jech yoꞌnton ti Jtotic ti oy ta vinajele. Mu scꞌan mi junuc chꞌayel ta xbat ti ololetic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Mi oy jun achiꞌil ti oy cꞌusi chopol ta spasbote, batan, ba cꞌopono stuc. Albo yaꞌi ti oy cꞌusi chopol laj spase. Ti mi ta xichꞌbot ta mucꞌ ti acꞌope, ta xacomic ta lec schiꞌuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero ti mi mu ta xichꞌ ta mucꞌ ti acꞌope, icꞌo batel jun chibuc achiꞌil, yoꞌ jech ta xaꞌiic ti acꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mi mu xꞌichꞌbat ta mucꞌ ti scꞌopique, ba vinajesbo smul ta stojol ti jchꞌunolajeletique. Mi mu xꞌichꞌbat ta mucꞌ scꞌopic ti jchꞌunolajeletique, tey acꞌo comuc jech chac cꞌu chaꞌal jun vinic ti mu xichꞌ ta mucꞌ ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ta melel ta xcalboxuc avaꞌiic, chuculot mi xavutic liꞌ ta banomile, jaꞌ jech chucul ta xꞌilat yuꞌun ti Dios ti oy ta vinajele. Colemot mi xavutic liꞌ ta banomile, jaꞌ jech colem ta xꞌilat yuꞌun ti Dios ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Jaꞌ jech xtoc ta xcalboxuc avaꞌiic, mi oy chiboxuc liꞌ ta sba banomile ti jmoj avoꞌntonic ti oy cꞌusi ta xacꞌanbeic ti Diose, jech ti Jtot ti oy ta vinajele ta xayacꞌboxuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yuꞌun ti bu tsoboloxuc ta jventae, manchuc mi chib oxiboxuc, tey oyun ta atojolic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jech ti Pedroe bat sjacꞌbe ti Jesuse: ―Cajval, albun caꞌi, ¿jayib velta ta xcacꞌbe perdón ti jchiꞌil ti buchꞌu ti oy cꞌusi chopol ta spasbune? ¿Mi xuꞌ ta vucub velta? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ti Jesuse jech itacꞌav: ―Ta xcalbot avaꞌi, maꞌuc noꞌox vucub velta ti ta xavacꞌ perdone. Muꞌyuc spajeb. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal jun ajvalil ti ta scꞌan ta xchapanbe yil ti svinictaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cꞌalal naca to lic xchapanbe yil ti svinictaque, jaꞌ o icꞌbil tal jun svinic ti toj ep ta jmec ti yile. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ti yajꞌabtel ti ajvalile mu xa xtoj yuꞌun ti yile. Jech o xal ti ajvalile laj yal mantal ti acꞌo yichꞌ chonel batel ta yan ajvalil schiꞌuc yajnil, schiꞌuc snichꞌnabtac, schiꞌuc scotol ti cꞌusitic oy yuꞌune, yoꞌ jech ta xtoj ti yile. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jech ti jꞌabtele laj squejan sba ta stojol ti yajvale. Jech lic yal: “Cajval, cꞌuxubinun. Ta naca sta ta jtojbot scotol ti quile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ti ajvalile icꞌuxubaj yoꞌnton yuꞌun ti yajꞌabtele. Laj xchꞌaybe ti yile. Colem icom ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cꞌalal ilocꞌ batel ti vinique, tey laj snup sbaic ta be jun schiꞌil ti oy juteb yil yuꞌune. Ti jun vinic ti buchꞌu ichꞌaybat scotol ti yile, ta ora ba smichꞌbe snucꞌ ti schiꞌil ti buchꞌu oy juteb yil yuꞌune. Jutuc xa mu icham yuꞌun. Cꞌalal smichꞌojbe xa ti snuqꞌue, jech laj yalbe: “Tojbun talel ti avile”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jech o xal ti vinic ti oy juteb ti yile lic squejan sba ta stojol. Jech lic yalbe: “Cꞌuxubinun, ta naca sta ta jtojbot ti quile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ti vinique mu xaꞌibe schiquinal. Jaꞌ noꞌox tey ba sticꞌ ta chuquel ti schiꞌile jaꞌ to ti mi itojbate. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pero iꞌilat yuꞌun yan schiꞌiltac ta abtel ti jech ta spase. Jech o xal ti schiꞌiltaque toj cꞌux laj yaꞌiic. Jech o xal ba yalbeic yaꞌi ti yajvalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cꞌalal jech laj yaꞌi ti ajvalile, lic sta ta iqꞌuel ti vinique. Jech ti ajvalile jech laj yalbe: “Chopol jꞌabtelot. Qꞌuel avil, ti vuꞌune laj jtub ti avile jaꞌ ti laj acꞌanbun vocole. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jech laj apas jechuc ec yuꞌun ti achiꞌile ti jech chac cꞌu chaꞌal ti vuꞌun icꞌuxubaj coꞌnton ta atojole”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ti ajvalile tey icap sjol. Laj yal mantal ti acꞌo yichꞌ ep castigo ti yajꞌabtele, ti acꞌo stoj scotol ti yil eque. ");
INSERT INTO tzotzc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jaꞌ jech ta spas ta atojolic ti Jtot ti oy ta vinajele ti mi mu xavacꞌbe abaic perdón ta jujun tal ta sjunul avoꞌntonic ti achiꞌil abaique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cꞌalal laj yoꞌnton ta chanubtasvanej ti Jesuse, ilocꞌ batel ta Galilea banomil. Ibat cꞌalal ta Judea banomil. Ijelav batel ta jot ucꞌum Jordán ti oy ta sloqꞌueb cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ep ti cristianoetique stsꞌacliojic batel ti Jesuse. Jech xtoc laj scolta ep ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oy jun chib jfariseoetic ti inopajic batel ta stojol ti Jesuse yoꞌ ta sbajesic yaꞌi ta cꞌocꞌ ti yalojique. Jech lic sjacꞌbeic: ―Albun caꞌicutic, ¿mi xuꞌ ta jbaj ti cajnilcutic ta scoj ti cꞌusiuc noꞌox ti spaltae? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ti Jesuse jech itacꞌav: ―¿Mi muꞌyuc avilojic ti jech ta xal ti scꞌop Diose: “Ti ta sliquebal banomile, jun vinic, jun ants, laj smeltsan ti Diose”, xi? ");
INSERT INTO tzotzc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jaꞌ jech xtoc jech ta xal ti scꞌop Dios xtoque: “Ti vinique ta scomtsan stot smeꞌ yoꞌ jech chba yicꞌ ti yajnile. Jech ta xcomic ta jun”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jech o xal ti vinic schiꞌuc ti antse mu xa yuꞌunuc chaꞌvoꞌicuc. Jun ta xcꞌotic. Jech o xal ti vinique mu xuꞌ ta xchꞌac sbaic schiꞌuc ti yajnile ti cꞌalal ipasatic ta jun yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ti jfariseoetique jech laj sjaqꞌuic: ―¿Cꞌu chaꞌal laj yal ti Moisese ti xuꞌ ta jpasbecutic svunal sventa ti chꞌacobbaile yoꞌ jech ta jbaj jbacutic? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ti Jesuse jech laj stacꞌ: ―Ta scoj ti toj yij ti avoꞌntonique. Jech o xal laj yalboxuc ti mantale ti xuꞌ ta xachꞌac abaic schiꞌuc ti avajnilique. Pero ti ta sliquebale, mu jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Vuꞌun ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti viniquetique ti ta sbaj sbaic schiꞌuc ti yajnile, ti mu ta scojuc ti ants ti laj scꞌupin yan vinique, ti mi chba yicꞌ yan antse, laj xa sta smul. Jaꞌ jech xtoc buchꞌuuc noꞌox ti viniquetique ti mi ta xicꞌ ti ants ti buchꞌu laj scꞌupin yan vinique, laj xa sta smul ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jech ti yajchancꞌoptaque jech laj yalic: ―Ti mi jaꞌ jech scꞌoplal ti viniquetic schiꞌuc ti yajnilique, jaꞌ más lec ti mu saꞌ ti yajnilique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ti Jesuse jech laj yal: ―Mu scotolicuc xuꞌ yuꞌunic. Jaꞌ noꞌox ti buchꞌutic jech ta xꞌacꞌbatic snaꞌic yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oy smelol ti cꞌu chaꞌal mu saꞌ yajnilic ti jlom viniquetique. Oy jlom viniquetic ti stalelic o ti jech voqꞌuemique. Oy jlom viniquetic ti pasbilic ta capone. Oy jlom mu saꞌ yajnilic ta sventa yoꞌ jech ta xtun yuꞌun ti Diose. Ti buchꞌu jech ta xꞌacꞌbat snaꞌe, acꞌo spas ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Icꞌbat tal jayibuc ololetic ta stojol ti Jesuse yoꞌ jech ta scajan scꞌob ta stojolic, yoꞌ ta stabe ta cꞌoponel Dios ta stojolic. Pero ti yajchancꞌoptaque lic spajtsanic ti buchꞌutic ta xiqꞌuic talel ti ololetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ti Jesuse jech laj yal: ―Mu xapajtsanic ti ololetic ti jech ta xtal ta jtojole. Yuꞌun ti buchꞌutic ventainbilic yuꞌun ti Diose, coꞌol sꞌelan jech chac cꞌu chaꞌal ti ololetic liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jech ti Jesuse laj scajan scꞌob ta stojol ti ololetique. Tsꞌacal to ilocꞌ batel ti bu oye. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oy jun querem vinic ibat ta stojol ti Jesuse. Jech cꞌot sjacꞌbe: ―Lequil jchanubtasvanej, albun caꞌi, ¿cꞌusi lec scꞌan ta jpas yoꞌ jech ta jta ti jcuxlejal sbatel osile? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ti Jesuse jech laj stacꞌ: ―¿Cꞌu chaꞌal ta xavalbun ti lecune? Muꞌyuc buchꞌu junucal lec. Jaꞌ noꞌox lec ti Diose. Pero ti mi ta xacꞌan ta xata acuxlejale, chꞌuno ti mantaletique ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ti querem vinique jech laj sjacꞌ: ―¿Cꞌusi mantalil? ―xi. Ti Jesuse jech laj yal: ―Mu xamilvan. Mu xasaꞌ avants. Mu xaꞌelcꞌaj. Mu xajutbe smul achiꞌiltac. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ichꞌo ta mucꞌ atot ameꞌ. Cꞌuxubino achiꞌiltac jech chac cꞌu chaꞌal ta xacꞌuxubin aba atuque ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ti querem vinique jech laj yal: ―Scotol taje pasbil onoꞌox talel cuꞌun ta jbicꞌtal. ¿Cꞌusi xa yan scꞌan ta jpas? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ti Jesuse jech laj yal: ―Ti mi ta xacꞌan ti lec oyote, batan, chono scotol ti cꞌusitic oy avuꞌune. Ti stojole, acꞌbo ti meꞌonetique. Ti mi jech ta xapase, oy acꞌulejal tey ta vinajel. Tsꞌacal to, laꞌ tsꞌacliun batel ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cꞌalal jech laj yaꞌi ti querem vinique, at oꞌnton xa ilocꞌ batel, yuꞌun toj cꞌulej. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jech ti Jesuse tey lic yalbe yaꞌiic ti yajchancꞌoptaque: ―Ta melel ta xcalboxuc avaꞌiic, ti buchꞌu jcꞌulejetique toj vocol ta xꞌochic ti bu ta xventainvan ti Dios ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta jchaꞌalboxuc, ti buchꞌu jcꞌuleje toj vocol ta xꞌoch ti bu ta xventainvan ti Diose. Jaꞌ más to xuꞌ ta xjelav ta sat acuxa ti jun mucꞌ ta camelloe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cꞌalal jech laj yaꞌiic ti yajchancꞌoptaque, chꞌayal icꞌot yoꞌntonic. Jech o xal jech lic sjacꞌbe sbaic: ―Ti mi jech taje, ¿buchꞌu xa onoꞌox xuꞌ ta xcol? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ti Jesuse tey laj sqꞌuel ti yajchancꞌoptaque. Jech lic yalbe: ―Ta melel ta xcalboxuc avaꞌiic, ti viniquetique mu xuꞌ yuꞌunic ta stuquic noꞌox. Pero ti Diose xuꞌ ta spas scotol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jech o xal ti Pedroe jech laj yal: ―Cajval, ti vuꞌuncutique laj xa quictacutic comel scotol ti cꞌusitic oy cuꞌuncutique yoꞌ jech ta jtsꞌacliotcutic batel. Jech o xal, ¿cꞌusi ta jtacutic? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ti Jesuse jech laj stacꞌbe: ―Ta melel ta xcalboxuc avaꞌiic, ti cꞌalal ta sta scꞌacꞌalil ti ta xcom ta achꞌ scotole, tey chvul chotlucun ta jpas mantal ti yan yutsil ti vuꞌun coꞌol jꞌelantique. Jaꞌ jech ti voꞌoxuc ti laj atsꞌacliune tey ta xachotiic ec yoꞌ jech ta xapasic ta mantal ti lajchaꞌchop snitilultac ti Israele. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Buchꞌuuc noꞌox ti laj xa yictaic ti snaique, ti schiꞌilic ta voqꞌuele, ti stot smeꞌique, ti yajnil o mi smalalique, ti yalab snichꞌnabique, ti yosilique ta sventa ti ta xistsꞌacliune, ta xichꞌbe sqꞌuexol voꞌvinic (100) más. Jaꞌ jech xtoc ta xichꞌic ti achꞌ cuxlejal sbatel osile. ");
INSERT INTO tzotzc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero ep ti buchꞌutic ichꞌbilic ta mucꞌ avi liꞌe, pero jaꞌ muꞌyuc ichꞌbiluc ta mucꞌ ta xcꞌotic. Ep ti buchꞌutic muꞌyuc ichꞌbiluc ta mucꞌ avi liꞌe, pero jaꞌ ichꞌbilic ta mucꞌ ta xcꞌotic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ti Jesuse jech lic yal xtoc: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal jun yajval pinca ti sob ilocꞌ batele, ba saꞌ talel svinictac, yoꞌ jech ta xtuchꞌic ti uvae. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ti ajvalile ti cꞌalal laj xa sta ti yajꞌabteltaque, laj yalbe ti ta stoj jun denario taqꞌuin ta cꞌacꞌale. Tsꞌacal to un, laj stac batel ta yosil, ba abtejicuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsꞌacal to un, nopol xa batel baluneb ora icꞌluman, ilocꞌ batel. Jaꞌ o laj yil ta chꞌivit ti oy viniquetic ti chꞌabal yabtelique. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jech lic yalbe: “Batanic ta cabtel ta stuchꞌel ti uvae. Ta jtojoxuc ti cꞌuxi lec ta xavaꞌiique”, xut. Jech ti viniquetique bat abtejicuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yan to velta, nopol xa batel oꞌlol cꞌacꞌal, ilocꞌ batel ti ajvalile. Jaꞌ o laj sta xtoc viniquetic ti chꞌabal yabtelique. Laj stac batel ta yabtel xtoc. Yan to velta ta oxib ora mal cꞌacꞌal ilocꞌ batel. Jaꞌ o laj sta xtoc ti viniquetic ti chꞌabal yabtelique. Laj stac batel ta yabtel xtoc. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nopol xa bal voꞌob ora mal cꞌacꞌal ilocꞌ batel ta chꞌivit yan velta ti ajvalile. Jaꞌ o tey laj sta viniquetic ti chꞌabal ti yabtelique. Jech lic yalbe: “¿Cꞌu chaꞌal liꞌ oyoxuc sjunul cꞌacꞌal ti muꞌyuc ta xaꞌabtejique?” xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ti viniquetique jech itacꞌavic: “Yuꞌun muꞌyuc buchꞌu scꞌan ta xiyicꞌuncutic ta yabtel”, xiic. Ti ajvalile jech lic yalbe: “Batanic, ba abtejanic ta cosil. Ta jtojoxuc ti cꞌuxi lec ta xavaꞌiique”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cꞌalal mal xa ti cꞌacꞌale, ti ajvalile laj yalbe yaꞌi ti buchꞌu yichꞌoj ta sventa ti abtele: “Icꞌo talel scotol ti cajꞌabteltaque. Tojo. Jaꞌ baꞌyel xlic atoj ti buchꞌu tsꞌacal xa och ta abtele. Jaꞌ jech sꞌelan xcholet ta xatoj bal ti cajꞌabteltaque, yoꞌ jech slajeb xa ta xichꞌ stojolic ti buchꞌutic baꞌyel iꞌochic ta abtele”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jech o xal ti viniquetic ti nopol xa voꞌob ora mal cꞌacꞌal ti iꞌochic ta abtele, tal yichꞌ stojolic. Tey itojatic tsꞌacal jun denario taqꞌuin. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cꞌalal laj yichꞌ stojolic ti viniquetic ti baꞌyel iꞌochic ta abtele, laj snopic ti más to ep ta xtojatic ti stuquique. Pero muꞌyuc bu itojatic más. Jaꞌ noꞌox jun denario taqꞌuin iꞌacꞌbat ec. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cꞌalal laj yichꞌ ti stojolique, mu lecuc laj yaꞌiic ti coꞌol itojatique. Jech o xal bat scꞌanbeic parte ti ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jech laj yalic: “Ti viniquetic ti tsꞌacal iꞌochique, ti cꞌajomal noꞌox jun ora iꞌabtejique, pero ta xquilcutic ti coꞌol laj atojuncutique, cꞌalal ti vuꞌuncutique sjunul cꞌacꞌal jtsꞌicojcutic ti cꞌacꞌale”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ti ajvalile jech laj stacꞌbe: “Chiꞌiltic, muꞌyuc cꞌusi chopol ta jpasboxuc. Muꞌyuc bu ta xquelcꞌanbot ti acꞌacꞌale. ¿Mi mu laj jchapantic ti jun denario ta jtojot ti cꞌacꞌale? ");
INSERT INTO tzotzc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jech o xal tsaco ti atojole. Batan. Yuꞌun jech ta jcꞌan ta jtoj ti buchꞌu tsꞌacal iꞌoch ta abtele jech chac cꞌu chaꞌal ti laj jtojoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Muꞌyuc buchꞌu sventa ti cꞌusi ta jpas schiꞌuc ti jtaqꞌuine. ¿Mi yuꞌun van toj itꞌix ta xavaꞌi ti oy slequilal coꞌntone?” xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ati vaꞌi sꞌelan laj calboxuc taje, jaꞌ jech ta xcꞌot ta stojol ti cristianoetic ti buchꞌutic ep iꞌabtejic ta jtojol ti yalojique. Jaꞌ peqꞌuel ta xcom scꞌoplalic. Yan ti buchꞌutic ti mu epuc iꞌabtejic ta jtojol ti laj yaꞌiique, jaꞌ cajal scꞌoplal ta xcom. Yuꞌun ep ti buchꞌu icꞌbilique. Pero jun chib noꞌox ti buchꞌu tꞌujbilique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cꞌalal ta xanavic batel ta sbeilal Jerusalene, ti Jesuse laj yicꞌ loqꞌuel ti lajchaꞌvoꞌ yajchancꞌope. Jech lic yalbe: ");
INSERT INTO tzotzc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Qꞌuel avilic, liꞌ ta xijmuyotic batel ta Jerusalene. Ti vuꞌun coꞌol jꞌelantique ta xiꞌacꞌat batel ta yoc ta scꞌob ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. Ta xiyaqꞌuicun ta milel. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tey ta xiyaqꞌuicun batel ta stojol ti jyanlum cristianoetique yoꞌ jech ta xislabanicun, ta xismajicun, ta xisjocꞌanicun ta cruz. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cꞌalal ta xanavic batel ta Jerusalene, jaꞌ o tey inopaj batel ta stojol Jesús smeꞌ ti Jacoboe, ti Juane, jaꞌ ti snichꞌnab ti Zebedeoe. Jech ti smeꞌique cꞌot squejan sba ta stojol ti Jesuse yoꞌ jech ta scꞌanbe vocol. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ti Jesuse laj sjacꞌbe ti antse: ―¿Cꞌusi ta xacꞌan? ―xut. Ti antse jech laj yal: ―Cꞌalal ta sta scꞌacꞌalil ti ta xapas mantale, acꞌo ave ti jmoj ta xapasic mantal schiꞌuc ti chaꞌvoꞌ jquerem liꞌe, jun ta abatsꞌi cꞌob, jun ta atsꞌet cꞌob ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ti Jesuse jech itacꞌav: ―Ti voꞌoxuque mu xanaꞌ ti cꞌusi ta xacꞌanique. ¿Mi ta xcuch avuꞌunic ta yichꞌel ti vocole jech chac cꞌu chaꞌal ta xquichꞌ ti vuꞌune? ―xꞌutatic. Jech itacꞌavic: ―Ta xcuch cuꞌuncutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ti Jesuse jech laj yal: ―Melel, ta xavichꞌ avocolic jech chac cꞌu chaꞌal ta xquichꞌe. Pero ti jech ta xavalic ti ta jchotanoxuc jun ta jbatsꞌi cꞌob, jun ta jtsꞌeb cꞌobe, maꞌuc cabtel ta xcacꞌ taje. Jaꞌ ta xꞌacꞌbatic ti buchꞌutic jech chapanbil scꞌoplalic yuꞌun ti Jtote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cꞌalal jech laj yaꞌiic ti yan lajunvoꞌ yajchancꞌoptac ti jech laj scꞌanique, tey lic ilinicuc ta stojol ti chaꞌvoꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque. Jech laj yalbe: ―Ti voꞌoxuque xanaꞌic lec ti ajvaliletique tsots ta spas ta mantal ti cristianoetique. Jech xtoc ti buchꞌu tsots yabtel yichꞌojique, cajal ta spasvan ta mantal. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ti voꞌoxuque mu jechuc xapasic. Mi ta xacꞌanic ti ichꞌbiloxuc ta mucꞌ ta xacꞌotique, acꞌo abaic ta tunel yuꞌun ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Buchꞌuuc noꞌox ti ta scꞌan ti cajal ta xcꞌote, acꞌo yacꞌ sba ta tunel yuꞌun ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jaꞌ jech ti vuꞌun ti coꞌol jꞌelantique mu yuꞌunuc lital yoꞌ ta jmosovin ti cristianoetique. Tal cacꞌ jba ta tunel yuꞌunic. Yuꞌun lital cacꞌ jba ta milel, yoꞌ jech ta jtojbe scolelic ti epal cristianoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cꞌalal ta xa xloqꞌuic batel ta jteclum Jericoe, ep ti cristianoetic ti stsꞌacliojic batel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ti ta be ti bu ta xꞌechꞌique, tey chotajtic ta tiꞌ be chaꞌvoꞌ maꞌsatetic. Cꞌalal laj yaꞌiic ti tey ta xꞌechꞌ ti Jesuse, iꞌavanic: ―Cajval, Snichꞌon David, cꞌuxubinuncutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ti cristianoetique laj yalbeic ti acꞌo chꞌaniicuque. Pero ti stuquique más to tsots iꞌavanic: ―Cajval, Snichꞌon David, cꞌuxubinuncutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jech o xal ti Jesuse tey ivaꞌi, laj yicꞌ talel ti maꞌsatetique. Jech laj sjacꞌbe: ―¿Cꞌusi ta xacꞌanic ti ta jpase? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ti stuquique jech itacꞌavic: ―Cajval, ta jcꞌancutic ti jamuc ti jsatcutique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ti Jesuse icꞌuxubaj yoꞌnton yuꞌun. Jech o xal laj spicbe ti satique. Cꞌalal jech laj spase, ta ora noꞌox ijam ti satique. Tey laj xchiꞌinic batel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cꞌalal nopol xa scꞌan xcꞌot ta Jerusalén ti Jesús schiꞌuc ti yajchancꞌoptaque, icꞌotic ta jteclum Betfagé ti ta stsꞌel svitsal Olivose. Ti Jesuse laj stac jelavel chaꞌvoꞌ yajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jech laj yalbe: ―Batanic ta biqꞌuit jteclum leꞌe. Tey chucul ta xataic jun burro schiꞌuc jcot yol. Jitunic, icꞌbeicun talel. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ti mi oy buchꞌu cꞌusi ta xayalboxuque, albo yaꞌiic: “Jaꞌ ta xtun yuꞌun ti Cajvale. Ta jsutesbot noꞌox talel”, utic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ti jech taje, jaꞌ ta sventa yoꞌ ta xcꞌot ta pasel ti jech laj stsꞌiba comel ti jꞌalcꞌope: ");
INSERT INTO tzotzc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Albeic yaꞌi ti buchꞌutic nacajtic ta jteclum Sione: “Qꞌuel avilic, ti Ajvalil avuꞌunique liꞌ ta xtal ta atojolique. Mu snaꞌ stoy sba. Cajal ta xtal ta burro, yol jun animal ti jaꞌ jcuch-icatsile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jech ti chaꞌvoꞌ yajchancꞌoptaque ibatic. Jech laj spasic jech chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Laj yiqꞌuic talel ti meꞌ burro schiꞌuc ti yole. Tey laj scajanic scꞌuꞌic ta sba. Jech ti Jesuse icaji batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ti epal cristianoetique, oy jlom tey lic sqꞌuiꞌananic ti scꞌuꞌic ta be ti bu ta xꞌechꞌ ti Jesuse. Oy jlom laj sbojic cꞌob teꞌ. Laj slamanic ta be. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ti buchꞌutic jelavemic batele schiꞌuc ti comemic ta patile, tsots lic avanicuc: ―Yan yutsil ti snichꞌon ti ajvalil Davide. Toj lec ti buchꞌu tacbil talel yuꞌun ti Diose. Jun yutsil ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cꞌalal iꞌoch batel ta Jerusalén ti Jesuse, scotol ti cristianoetic ti tey ta Jerusalene tey xvochlajetic snetꞌ-netꞌ sbaic ta jmec. Jech ta sjacꞌolanbe sbaic: ―¿Buchꞌu leꞌe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ti cristianoetique jech ta xalic: ―Jaꞌ ti jꞌalcꞌop Jesuse ti liquem talel ta Nazaret ti oy ta Galilea banomile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tsꞌacal to ti Jesuse ibat ta templo yuꞌun ti Diose. Tey laj snuts loqꞌuel scotol ti buchꞌutic ta xchonilajique, ti ta xmanolajique. Jaꞌ jech xtoc laj svalcꞌunbe smexaic ti jeltaqꞌuinetique schiꞌuc xilaic ti jchonpalomaetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jech lic yal: ―Ta xal ti Dios ti tsꞌibabil ta scꞌope: “Ti jnae jaꞌ jtaobil ta cꞌoponel”, xi. Pero ti voꞌoxuque laj xa ajoybinic ta snail chꞌen jꞌeleqꞌuetic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti tey ta temploe inopajic talel ta stojol Jesús jun chib maꞌsatetic schiꞌuc coxovetic. Tey laj scoles. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale laj yilic ti smucꞌul stsatsale. Laj yaꞌiic xtoc ti jech tsots ta xꞌavanic ta templo ti ololetique: “Jun yutsil ti snichꞌon ajvalil Davide”, ti xiique. Jech o xal ti stuquique isoc sjolic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jech laj yalbeic ti Jesuse: ―¿Mi xavaꞌi ti vaꞌi sꞌelan ta xalique? ―xiic. Ti Jesuse jech laj stacꞌ: ―Ta xcaꞌi. Pero, ¿mi muꞌyuc aqꞌuelojic ta scꞌop Dios ti jech onoꞌox ta xale?: Pasbil avuꞌun ti jun yutsil ta xqꞌuejinic ti ololetique, ti jchuꞌnel-ololetique, xi onoꞌox ti tsꞌibabile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tey laj yicta comel. Bat ta jteclum Betania. Tey iꞌechꞌ yuꞌun ti acꞌobaltique. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sob xa ta yocꞌlomal ti cꞌalal ta xchaꞌsut batel ta Jerusalén ti Jesuse, lic yaꞌi viꞌnal. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tey laj yil jpets icux ti teqꞌuel ta tiꞌ bee. Inopaj bal ta stsel. Ba sqꞌuel mi oy sat. Pero muꞌyuc laj sta. Yanal noꞌox. Jech o xal ti Jesuse jech laj yalbe ti icuxe: ―Staojuc o yav ti jech chꞌabal asat ta xacome ―xut. Ta ora noꞌox lic taquijuc ti icuxe. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cꞌalal jech laj yilic ti yajchancꞌoptaque, chꞌayal icꞌot yoꞌntonic. Tey lic sjacꞌbeic ti Jesuse: ―Albun caꞌicutic, ¿cꞌu chaꞌal ti jech itaquij ta ora ti icuxe? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ti Jesuse jech itacꞌav: ―Ta melel ta xcalboxuc avaꞌiic, ti mi achꞌunojic ti xuꞌ yuꞌun ti Diose, ti mi mu xanaꞌeticuque, maꞌuc noꞌox jech ta xapasic jech chac cꞌu chaꞌal laj jpasbe ti icuxe. Xuꞌ ta xavalbeic ti vits liꞌe: “Locꞌan batel, ba jipo aba ta nab”, mi xavutique, jech ta xbat. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Scotol ti cꞌusitic ta xacꞌanbeic ti Diose, ti mi ta xachꞌunic ti ta xaꞌacꞌbatique, ta xavichꞌic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tsꞌacal to ti Jesuse iꞌoch bal ta templo. Ti cꞌalal tey ta xchanubtasvane, jaꞌ o tey inopajic batel ti banquilal paleetique schiꞌuc ti moletic yuꞌun ti jꞌisraeletique. Jech cꞌot sjacꞌbeic: ―Albun caꞌicutic, ¿cꞌusi avabtel ti vi sꞌelan ta xapase? ¿Buchꞌu laj yacꞌbot avabtel? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ti Jesuse jech laj stacꞌ: ―Jaꞌ jech ti vuꞌun eque, oy cꞌusi ta jcꞌan ta jacꞌboxuc ec. Ti mi xtacꞌ avuꞌunique, jaꞌ jechun ec ta xcalboxuc avaꞌiic ti buchꞌu laj yacꞌbun ti cabtele. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Albun caꞌi, ti Juan jꞌacꞌ-ichꞌ-voꞌe, ¿buchꞌu laj stac talel ti tal yacꞌ ichꞌ voꞌe? ¿Mi tacbil tal yuꞌun ti Diose? ¿Mi tacbil tal yuꞌun ti cristianoetique? ―xi. Jech ti stuquique lic sjacꞌolanbe sbaic ti cꞌusi xuꞌ ta xalique: ―Ti mi ta xcalbetic ti jaꞌ tacbil tal yuꞌun Dios mi xijchiotique, jech ti Jesuse ta xistacꞌbotic talel: “¿Cꞌu chaꞌal muꞌyuc bu laj avichꞌic ta mucꞌ?” xiyutotic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero ti mi ta xcalbetic ti jaꞌ tacbil tal yuꞌun ti viniquetic mi xijchiotique, toj xiꞌbal sba. Yuꞌun scotol ti cristianoetique xchꞌunojic ti jaꞌ icꞌopoj ta sventa Dios ti Juane ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jech o xal jech laj yalbeic ti Jesuse: ―Mu jnaꞌcutic ―xiic. Ti Jesuse jech laj yal: ―Jaꞌ jech ti vuꞌun eque, mi jaꞌuc ta xcalboxuc avaꞌiic buchꞌu laj yacꞌbun cabtel ti vi sꞌelan ta jpase ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ti Jesuse jech laj yal xtoc: ―¿Cꞌusi ta xanopic? Oy jun vinic ti oy chavoꞌ snichꞌone. Ti vinique jech laj yalbe ti jun snichꞌone: “Nichꞌon, ti cꞌacꞌal liꞌe, batan ta cosil, ba tuchꞌo ti uvae”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ti nichꞌonile jech itacꞌav: “Mu jcꞌan xibat”, xi. Pero tsꞌacal to lic snop ti jaꞌ lec ti ta xbat ta abtele. Jech o xal ibat. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tsꞌacal to ti totile jech lic yalbe ti jun snichꞌon xtoque: “Nichꞌon, ti cꞌacꞌal liꞌe, batan ta cosil, ba tuchꞌo ti uvae”, xut. Ti nichꞌonile jech itacꞌav: “Lec oy, Tot, ta xibat”, xi. Pero muꞌyuc ibat. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Albun caꞌi ti voꞌoxuque, ¿buchꞌu junucal ti laj spas ti cꞌusi laj scꞌan ti stotique? ―xi ti Jesuse. Ti stuquique jech itacꞌavic: ―Jaꞌ ti baꞌyel nichꞌonile ―xiic. Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, ti jcꞌanpatantaqꞌuinetique schiꞌuc ti jsaꞌmulil antsetique, jaꞌ baꞌyel ta xacꞌ sbaic ta ventainel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti Juan jꞌacꞌ-ichꞌ-voꞌe tal xchanubtasoxuc ti cꞌusi ta xapasic yoꞌ lec oyoxuque. Pero ti voꞌoxuque muꞌyuc laj achꞌunic. Yan ti jcꞌanpatantaqꞌuinetique schiꞌuc ti jsaꞌmulil antsetique laj xchꞌunic. Manchuc mi jech laj avilic, pero muꞌyuc bu laj ajelta ti chopol avoꞌntonique yoꞌ jech ta xachꞌunicun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ti Jesuse jech laj yal xtoc: ―Aꞌyio avaꞌiic ti yan babacꞌop liꞌe. Oy jun yajval pinca ti lic stsꞌun ti uvae. Lic smac ta moc ti yosile. Jaꞌ jech xtoc laj spasbe yavil yoꞌ bu ta xichꞌ pitsꞌel ti uvae schiꞌuc jun natil luchlebal yoꞌ ta sqꞌuel scotol. Tsꞌacal to un, laj yacꞌ comel ta chꞌom ti yosil ta stojol jꞌabteletic. Ibat ta nom. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cꞌalal sta xa scꞌacꞌalil ti ta xichꞌ tuchꞌel ti sat uvae, laj stac batel jun chib yajꞌabtel yoꞌ jech chba scꞌanic ti cꞌu yepal ta xichꞌ ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ti jchꞌom-osiletique laj stsaquic ti buchꞌutic tacbilic talele. Ti june laj smajic. Ti june laj smilic. Ti june laj yacꞌbeic ton. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pero ti yajval osile yan to velta laj stac talel yajꞌabteltac jech chac cꞌu chaꞌal ti ta baꞌyele. Pero ti jchꞌom-osiletique jaꞌ noꞌox jech laj spasic jech chac cꞌu chaꞌal laj spasic ti ta baꞌyele. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ta slajeb xa laj stac batel snichꞌon stuc. Jech laj snop: “Jaꞌ van ta xiyichꞌbeicun ta mucꞌ ti jnichꞌone”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ti jchꞌom-osiletique, cꞌalal laj yilic ti jaꞌ snichꞌon ti ajvalile, jech lic yalbe sbaic: “Leꞌ xtal ti buchꞌu ta xichꞌ comel ti osile. Laꞌ jmiltic yoꞌ jech ta xcom ta cuꞌuntic ti osile”, xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jech o xal ti jchꞌom-osiletique laj stsaquic, laj xjochic loqꞌuel, laj smilic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ti Jesuse jech lic sjacꞌbe ti cristianoetique: ―Cꞌalal ta sut talel ti yajval osile, ¿cꞌusi ta spasbe ti jꞌabteletic taje? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ti stuquique jech itacꞌavic: ―Ta smil scotol ti jmilvanej jꞌabteletique. Mi jaꞌuc juteb ta xcꞌuxubaj yoꞌnton yuꞌun. Jaꞌ jech xtoc ti yajval osile ta xlic saꞌ yan jꞌabteletic yoꞌ ta xacꞌ ta chꞌom ti yosile, yoꞌ jech ta xacꞌbeic ti cꞌu yepal ta xichꞌ slocꞌ ti yosile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ti Jesuse jech laj stacꞌbe: ―Ti voꞌoxuque, ¿mi muꞌyuc aqꞌuelojic ti scꞌop Dios ti jech ta xale?: Ti ton ti bajbil yuꞌun ti jꞌabteletique, tsꞌacal to jaꞌ jtunel icom ta sventa sliqueb ti nae. Jaꞌ yabtel stuc ti Cajvaltic Diose. Jun yutsil ta xcꞌot ta jtojoltic, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jech o xal ta xcalboxuc avaꞌiic, ti ventainel yuꞌun ti Dios ti oy ta atojolique, ta xbat ta yan. Ta xbat ta stojolic ti buchꞌutic snaꞌ xaqꞌuic ti sloqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Buchꞌuuc noꞌox ti ta xbajic ta sba ti tone, lilijem ta xcꞌotic. Mi cajal ta xcꞌot ta sbaic ti tone, polvo ta xcꞌotic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cꞌalal jech laj yaꞌiic ti banquilal paleetique, ti jfariseoetique ivul ta yoꞌntonic ti jaꞌ scꞌoplal stuquic ti jech iꞌalbatic yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jech o xal ta scꞌan ta stsaquic ox yaꞌiic. Pero ixiꞌic yuꞌun ti cristianoetique. Yuꞌun scotol xchꞌunojic ti ta xcꞌopoj ta sventa Dios ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yan to velta ti Jesuse jech lic yal ta babacꞌop: ");
INSERT INTO tzotzc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal jun ajvalil ti laj spas qꞌuin sventa ti ta xnupun ti snichꞌone. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ti ajvalile laj stac batel yajꞌabteltac ta stojolic ti buchꞌutic icꞌbilic yuꞌune. Pero ti buchꞌutic icꞌbilique mu scꞌan xtalic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yan to velta ti ajvalile laj stac batel yan yajꞌabteltac ta stojolic ti buchꞌutic icꞌbilic yuꞌune. Jech laj yalbe batel: “Batanic, ba albeic yaꞌi ti buchꞌutic icꞌbilic cuꞌune ti chapal xa cuꞌun ti veꞌlile. Laj xa jmil ti vacaxe schiꞌuc ti yan animaletic ti lec jubemique. Chapal xa scotol ti cꞌusitic ta xtune. Jech o xal acꞌo talicuc ta ora”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ti buchꞌutic icꞌbilique muꞌyuc bu laj yichꞌbeic ta mucꞌ ti scꞌop ti yajꞌabtel ti ajvalile. Oy jlom bat abtejicuc ta yosilic. Oy jlom batic ta chonolajel. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ti jlom xtoque laj stsacbeic ta majel, laj smilic ti yajꞌabteltac ti ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jech ti ajvalile toj echꞌem isoc sjol. Tey laj yalbe mantal ti yajsoldadotaque ti acꞌo ba smilic ti jmilvanejetique schiꞌuc ti acꞌo yichꞌ chicꞌbel ti slumalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsꞌacal to ti ajvalile lic yalbe ti yajꞌabteltaque: “Chapajem xa scotol cuꞌun sventa ti qꞌuine. Pero ti buchꞌutic icꞌbilic cuꞌune, maꞌuc icꞌbil cuꞌun jnaꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jech o xal batanic ti bu más ep ta xꞌechꞌic ti jbeinel ta callee. Ba iqꞌuic talel ta qꞌuin ti cꞌu yepal ti tey ta xataique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jech o xal ti yajꞌabteltaque iloqꞌuic batel ta calletic. Laj yiqꞌuic tal scotol ti jbeineletic ti cꞌu yepal laj staique. Mu tꞌujbiluc laj spasic. Jech ti sna ti ajvalile noj icom. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Jech o xal ti ajvalile iꞌoch batel ta yut sna. Tey ba sqꞌuel ti buchꞌutic icꞌbilic talel yuꞌune. Pero ti tey ta yut snae oy jun vinic ti muꞌyuc bu slapoj scꞌuꞌ sventa ti nupunele. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jech laj yalbe: “Chiꞌiltic, ¿cꞌusi laj avut ti laꞌoch talel liꞌe ti cꞌalal muꞌyuc alapoj ti acꞌuꞌ sventa ti nupunele?” xut. Pero ti vinique tsꞌijil icom. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jech o xal ti ajvalile laj yalbe yaꞌi ti buchꞌutic ta xacꞌ ti veꞌlile: “Chucbeic yoc scꞌob ti vinic liꞌe. Jipic batel ta icꞌal osil ti bu ta xꞌoqꞌue, ti bu xcꞌuxuxet ti yee”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yuꞌun ep ti buchꞌu icꞌbilique. Jun chib ti buchꞌu tꞌujbilique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jech ti jfariseoetique bat scomonopic yoꞌ jech oy cꞌusi ta sjacꞌbeic ti Jesuse, yoꞌ jech mi oy cꞌusi chopol ta xal, yoꞌ jech ta stabeic smul. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jech ti jfariseoetique laj staquic batel jun chib svinictac schiꞌuc jun chib svinictac ti ajvalil Herodese, ti jech laj yalic ta stojol ti Jesuse: ―Jchanubtasvanej, jnaꞌojcutic lec ti jaꞌ melel ti cꞌusi ta xavale. Jamal ta xavalbuncutic ti cꞌusi ta scꞌan Dios ti ta jpascutique. Mu labluc xavaꞌi ti cꞌusitic ta xayalbe ti cristianoetique. Yuꞌun mu tꞌujbiluc xanaꞌ xapas. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jech o xal albun caꞌicutic cꞌusi ta xanop. ¿Mi lec ti ta jtojtic ti patan taqꞌuin ti ta xichꞌ ti ajvalil romanoe? ¿Mi mu lecuc? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ti Jesuse laj yilbe yoꞌntonic ti jech chopol ta snopique. Jech o xal jech laj yal: ―Ta xapacꞌta abaic. ¿Cꞌu chaꞌal ta xacꞌan ta xabajesicun ta cꞌocꞌ? ");
INSERT INTO tzotzc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Acꞌbun quil jsep taqꞌuin ti jaꞌ stojobil ti patane ―xi. Tey laj yichꞌic talel jsep denario taqꞌuin. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Cꞌalal laj sqꞌuel ti Jesuse, jech laj sjacꞌbe: ―¿Buchꞌu sat, buchꞌu sbi liꞌ tsacale? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ti stuquique jech laj staqꞌuic: ―Jaꞌ ti ajvalile ―xiic. Jech o xal ti Jesuse jech laj yal: ―Acꞌbeic ti cꞌusi jaꞌ yuꞌun ti ajvalile. Jaꞌ jech xtoc acꞌbeic ti cꞌusi jaꞌ yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cꞌalal jech laj yaꞌiique, jech ti stuquique chꞌayal icꞌot yoꞌntonic. Tey laj yictaic comel ti Jesuse. Ibatic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jaꞌ onoꞌox jun scꞌacꞌalil taje, oy jlom jsaduceoetic ibatic ta stojol ti Jesuse. Ti jsaduceoetique xchꞌunojic ti muꞌyuc chaꞌcuxiel yuꞌun ti animaetique. Jech o xal jech laj yalic: ");
INSERT INTO tzotzc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Jchanubtasvanej, ti Moisese jech laj yal: “Mi oy jun vinic ti ta xicꞌ ti yajnile, ti mi chame, ti mi chꞌabal snichꞌon icome, jech o xal ti yitsꞌine ta scꞌan ti acꞌo yicꞌ ti meꞌunal antse, yoꞌ mu xchꞌay stsꞌunobal ti anima sbanquile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lec oy. Oy jchiꞌilcutic ti vucubic ta voqꞌuele. Ti sba banquilale laj saꞌ yajnil. Icham. Muꞌyuc snichꞌon icom. Tsꞌacal to, yitsꞌin ti animae laj yicꞌbe yajnil ti anima sbanquile. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero ti itsꞌinale icham xtoc. Muꞌyuc snichꞌon icom. Tsꞌacal to ti yoxibal itsꞌinale laj yicꞌ xtoc. Pero icham. Muꞌyuc snichꞌon icom. Jaꞌ jech icꞌot ta pasel yucubalic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsꞌacal to icham ti ants xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cꞌalal ta sta scꞌacꞌalil ti ta xchaꞌcuxiic ti animaetique, ¿buchꞌu junucal ta xajnilanic ti antse cꞌalal laj smalalin ti vucub viniquetique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ti Jesuse jech laj stacꞌbe: ―Chꞌayemoxuc ti jech ta xavalique. Yuꞌun mu xanaꞌic cꞌusi ta xal ti scꞌop Diose, ti smucꞌul stsatsal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ti cꞌalal ta xchaꞌcuxiic ti animaetique, mu xa ta xicꞌan sbaic. Jaꞌ jech xtoc muꞌyuc xa ta xaqꞌuic ta nupunel ti yalab snichꞌnabique. Jech ta xcꞌotic jech chac cꞌu chaꞌal yajꞌángeltac ti Dios ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ti jech ta xchaꞌcuxiic ti animaetique, ¿mi mu avilojicuc ti jech ta xal stuc ti Dios ti tsꞌibabil ta scꞌope?: ");
INSERT INTO tzotzc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Vuꞌun Diosun yuꞌun ti Abrahame, ti Isaaque, ti Jacobe”, xi. Ta stojol ti Diose muꞌyuc buchꞌu chamem. Scotolic cuxulic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cꞌalal jech laj yaꞌiique, chꞌayal icꞌot yoꞌntonic yuꞌun ti jech ichanubtasvan ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cꞌalal jech laj yaꞌiic ti jfariseoetic ti jech tsꞌijajtic icomic ti jsaduceoetique, lic stsob sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Oy jun ta scotolic ti jaꞌ jchanubtasvanej yuꞌun ti mantale ti ta scꞌan ta slajeltsabe yoꞌnton ti Jesuse. Jech cꞌot sjacꞌ: ");
INSERT INTO tzotzc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Jchanubtasvanej, ¿cꞌusi mantalil ti más tsots scꞌoplale? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ti Jesuse jech itacꞌav: ―“Cꞌano ti Dios avuꞌune ta sjunul avoꞌnton, ta sjunul achꞌulel, ta sjunul snopobil avuꞌun”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jaꞌ ti mantal ti más tsots scꞌoplal taje. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ti yan mantal ti jutuc mu coꞌoluc schiꞌuque, jaꞌ liꞌe: “Cꞌuxubino ti achiꞌiltaque jech chac cꞌu chaꞌal ti ta xacꞌuxubin aba atuque”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ti chib mantal liꞌe tey xa stsoboj sba scotol smantal ti Moisese schiꞌuc ti cꞌu sꞌelan ichanubtasvan ti jꞌalcꞌoptaque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cꞌalal tey to tsobolic ti jfariseoetique, ti Jesuse jech laj sjacꞌbe: ");
INSERT INTO tzotzc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Cꞌusi ta xanopic ta stojol ti Cristoe? ¿Buchꞌu snitilul? ―xi. Jech itacꞌavic: ―Jaꞌ snitilul ti Davide ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ti Jesuse jech laj yal: ―Ti mi jaꞌ snitilul ti Davide, ¿cꞌu chaꞌal ti Cajval xi ti David ta stojol ti Cristoe? Yuꞌun ti Davide, ta sventa ti ventainbil yoꞌnton yuꞌun ti Chꞌul Espíritue, jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ti Diose jech laj yalbe ti Cajvale: “Laꞌ chotlan ta jbatsꞌi cꞌob, jaꞌ to mi sta yorail ta xcacꞌbot ta avoc ta acꞌob ti avajcrontae”, xꞌutat ti Cristoe, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Cꞌu chaꞌal taje ti Cristoe ti jaꞌ snitilul ti Davide, cꞌalal ti David xtoque Cajval ti xute? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ti jech laj yale, muꞌyuc buchꞌu itacꞌ yuꞌunic jbeluc ti cꞌope. Jaꞌ o tey laj yicta sbaic ti mu xa cꞌusi laj sjacꞌbeic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jech ti Jesuse jech laj yalbe yaꞌiic ti cristianoetque schiꞌuc ti yajchancꞌoptaque: ");
INSERT INTO tzotzc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ti jchanubtasvanejetic yuꞌun ti mantale schiꞌuc ti jfariseoetique svaꞌanoj sbaic ta yalel smelol smantal ti Moisese. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jech o xal, chꞌunbeic, pasic ti cꞌusi ta xalique. Pero mu xachanbeic ti stalelique. Yuꞌun ti stuquique muꞌyuc ta spasic ti cꞌusi ta xalique. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Qꞌuel avil, ti stuquique ta xacꞌbeic ep yicatsic ti cristianoetic ti mu xa xlic yuꞌunique. Yuꞌun ta sujic ta xcuchel ti icatsile. Pero ti stuquique mi jaꞌuc juteb ta sticꞌ sniꞌ scꞌobic ta yiquel ti icatsile. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jech ta spasic scotol yoꞌ lec ta xꞌilatic. Yuꞌun ti stuquique lec ta xaꞌiic ti chucajtic ta stiꞌbaic ta scꞌobic ti smantal Dios ti tsꞌibabil ta jamal poqꞌue. Jech xtoc toj lec ta xaꞌiic ti más to nat ta slap ti scꞌuꞌique, ti oy lec ti stsitsimaltaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta scꞌanic ti más lec tꞌujbil schotlebic ti bu ta xveꞌique schiꞌuc ti chotlebal ichꞌbil ta mucꞌ ta jujun chꞌul nae. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta scꞌanic ti nupbilique, ti ichꞌbilic ta muqꞌue, ti jchanubtasvanej ti xꞌutatic ta callee. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero ti voꞌoxuque maꞌuc avabtelic ti ta xaꞌalbatic jchanubtasvanej ti xaꞌutatique. Yuꞌun ti voꞌoxuque achiꞌil noꞌox abaic. Yuꞌun jun noꞌox ti jchanubtasvanej avuꞌunique, jaꞌ ti Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Muꞌyuc buchꞌu xabis ta totil liꞌ ta sba banomile. Yuꞌun jun noꞌox Atotic ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Maꞌuc avabtel ti ta xacꞌanic biiltasel ti banquilal, xaꞌutatique. Yuꞌun ti banquilal avuꞌunique, jaꞌ ti Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ti buchꞌu ti ta xacꞌ sba ta tunel ta stojol ti yane, jaꞌ ti buchꞌu más cajal ta atojolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yan ti buchꞌu cajal ta xacꞌ sba ta stojol ti yane, ta specꞌtsanat. Yan ti buchꞌu ta sbicꞌtajes sba ta stojol ti yane, jaꞌ ta xꞌacꞌat ta ichꞌel ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Yuꞌun ta xamacꞌbeic stiꞌ ti bu ta xventainvan ti Dios ti oy ta vinajele, yoꞌ jech mu xꞌoch avuꞌunic ti yane. Yuꞌun ti voꞌoxuque mu xacꞌan xaꞌochic. Mi jaꞌuc xavacꞌ ochicuc ti buchꞌutic ta scꞌan ta xꞌoch yaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Ta xapojbeic snaic ti meꞌunal antsetique. Tsꞌacal to yoꞌ jech mu xvinaj ti cꞌusi chopol ta xapasique, jech o xal un, jal ta xataic ta cꞌoponel ti Diose. Ti jech ta xapasique, tsots castigo ta xavichꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Avacꞌojic persa ta saꞌel mi oy bu jun vinic ta xchanubtasel jech chac cꞌu chaꞌal ti achꞌunojique. Mi laj xa xchꞌun avuꞌunique, jech ti vinique chib to velta ta xjelav spucujil. Jaꞌ mu sta ti voꞌoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Toj abol abaic ti voꞌoxuque, maꞌsat jnitvanejoxuc. Jech ta xavalic: “Ti buchꞌu ta svaꞌan ta rextigo ti temploe, mu persauc ta xcꞌot ta pasel ti cꞌusi laj yale. Pero ti buchꞌu ta svaꞌan ta rextigo ti oro yuꞌun ti temploe, jaꞌ persa ta xcꞌot ta pasel”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Toj bolibemoxuc, maꞌsatoxuc. ¿Cꞌusi ti más tsots scꞌoplale? ¿Mi jaꞌ ti oroe? ¿Mi jaꞌ ti templo ti ta stunes ti oroe? ");
INSERT INTO tzotzc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jech ta xavalic xtoc: “Ti buchꞌu ta svaꞌan ta rextigo ti altare, mu persauc ta xcꞌot ta pasel ti cꞌusi laj yale. Pero ti mi ta svaꞌan ta rextigo ti smoton Dios ti tey cajal ta altare, jaꞌ persa ta xcꞌot ta pasel”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Toj bolibemoxuc, maꞌsatoxuc. ¿Cꞌusi ti más tsots scꞌoplale? ¿Mi jaꞌ ti smoton Diose? ¿Mi jaꞌ ti altar ti ta stunes ti smoton Diose? ");
INSERT INTO tzotzc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ti buchꞌu ta svaꞌan ta rextigo ti altare, maꞌuc noꞌox ti jech ta svaꞌan ta rextigo ti altare. Laj xa svaꞌan ta rextigo xtoc ti smoton Dios ti tey cajal ta altare. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ti buchꞌu ta svaꞌan ta rextigo ti temploe, maꞌuc noꞌox ta svaꞌan ta rextigo ti temploe. Jaꞌ jech xtoc laj xa svaꞌan ta rextigo ti Diose yuꞌun tey sventainoj ti temploe. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ti buchꞌu ta svaꞌan ta rextigo ti vinajele, laj xa svaꞌan ta rextigo ti Diose, ti jaꞌ tey chotol sventainoj ti vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Ti voꞌoxuque jaꞌ noꞌox tsots scꞌoplal ta xavaꞌiic ti ta xaloqꞌuesic jujun lajlajuneb ti tul nichime, ti culantue, ti cominoe, yoꞌ jech ta xavacꞌbeic smotonin ti Diose. Pero mu xavichꞌic ta mucꞌ ti bu más tsots scꞌoplal ta xchanubtasvan ti mantale jech chac cꞌu chaꞌal ti stuqꞌuil oꞌntonale, ti scꞌuxul oꞌntonale, ti yichꞌel ta mucꞌ ti Diose. Jaꞌ tsots scꞌoplal ti ta xapasic leꞌe. Pero mu me xavictaic ta yaqꞌuel ti lajlajunebe. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Maꞌsat jnitvanejoxuc. Ti voꞌoxuque mu xacꞌan xabiqꞌuic ti nene use. Pero lec xavaꞌiic sbiqꞌuel ti mucꞌ ta camelloe. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Ti voꞌoxuque jaꞌ jech aꞌelanic jech chac cꞌu chaꞌal ti vasoe, ti platoe, ti lec ta xapoquic ti spate. Pero ti yut avoꞌntonique nojem ta yuꞌuninel, ta yelcꞌanel ti cꞌusi oy yuꞌun ta achiꞌiltaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Maꞌsat jfariseo, poco baꞌyel ti yut vasoe, ti yut platoe, yoꞌ jech lec ta xcom ti yute schiꞌuc ti spate. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Ti voꞌoxuque coꞌol aꞌelanic jech chac cꞌu chaꞌal ti sna anima ti ta ba muquinale, ti lec saque, ti cꞌupil sba ta qꞌuelel ti spate. Pero ti ta yute, noj ta sbaquil anima ti ep ta tos ti cꞌusitic chopol teye. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jaꞌ jech aꞌelanic ti voꞌoxuque. Ti apat axoconique lec ta xilic ti cristianoetique. Pero ti ta yut avoꞌntonique, noj ta mulil, jaꞌ noꞌox ta xapacꞌta abaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic, toj abol abaic. Jaꞌ noꞌox ta xapacꞌta abaic. Ta xameltsanbeic lec sba smuquinal ti jꞌalcꞌopetique. Jech xtoc lec nichimtic xa ta xapasbeic ti sba smucobbail ti buchꞌu lec iꞌechꞌic liꞌ ta sba banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pero tsꞌacal to un, ta xavalic: “Ti oyucotic xa ox cꞌalal cuxulic to ox ti jmolmucꞌtique, muꞌyuc bu laj jticꞌ jbatic ta smilel jꞌalcꞌopetic ti jechuque”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ti jech ta xavalique, laj xavinajes abaic ti jaꞌ snitiluloxuc ti buchꞌutic laj smilic ti jꞌalcꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tsutsesic yabtel ti amolmucꞌtotique ti cꞌu sꞌelan laj sliquesique. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Jtiꞌval chon, ¿cꞌusi xavut ta xapoj abaic ta castigo yuꞌun ti tojob mulile? ");
INSERT INTO tzotzc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jech o xal ta jtac talel ta atojolic jꞌalcꞌopetic, jchanubtasvanejetic, bijil viniquetic. Pero ti voꞌoxuque ta xamilic jlom. Ta xajocꞌanic ta cruz jlom. Jlom ta xamajic ta jujun chꞌul na avuꞌunic. Ta xanutsic loqꞌuel ta jujun jteclum. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jech o xal cajal ta xcꞌot ta abaic ti laj lajuc ta milel scotol ti lequil viniquetique, ti lic onoꞌox talel ta stojol ti lequil Abele, ti ivul cꞌalal ta Zacaríase, jaꞌ snichꞌon ti Berequíase, ti voꞌoxuc laj amilic ta yut templo ti ta stsꞌel ti altare. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ta melel ta xcalboxuc avaꞌiic, ti jech ilajic ta milel ti lequil viniquetique, scotol ta xcom ta abaic avi tana liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Jerusalén, Jerusalén, ti voꞌoxuque ta xamilic ti jꞌalcꞌopetique. Ta xapujbeic ton ti buchꞌutic tacbilic tal yuꞌun ti Diose. Ep ta velta ta jcꞌan ta jtsoboxuc jech chac cꞌu chaꞌal ti meꞌ alacꞌ ti ta stsob ti yalab ta yolon xiqꞌue. Pero mu xacꞌanic. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Qꞌuel avilic, ti voꞌoxuque jipbil ta xcom ti anaique. ");
INSERT INTO tzotzc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yuꞌun ta xcalboxuc avaꞌiic, mu xa bu ta xavilbeicun ti jsate, jaꞌ to ti mi ta sta yorail ti ta xavalique: “Toj yan noꞌox yutsil ti Buchꞌu tacbil tal yuꞌun ti Cajvaltic Diose”, ti mi xachiique ―xi ta xꞌocꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Cꞌalal ilocꞌ batel ta templo ti Jesuse, ti tey xa ta xanav batele, inopaj batel ti yajchancꞌoptaque. Laj yacꞌbeic yil ti temploe. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ti Jesuse jech laj yal: ―Ti jech ta xavilic scotol liꞌe, ta melel ta xcalboxuc avaꞌiic, ta sta yorail ti mu jbejuc ton ti cajal ta xcom ta sba ti yan tone. Ta xlilij scotol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tsꞌacal to tey ibatic ta vits Olivos. Cꞌalal tey xa chotol ti Jesuse, ti yajchancꞌoptaque jech laj sjacꞌbeic ta mucul: ―Albun caꞌicutic, ¿cꞌusi ora ta xcꞌot ta pasel taje? ¿Cꞌusi señail ti ta xachaꞌsut talele? ¿Cꞌusi señail ti slajeb cꞌacꞌale? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ti Jesuse jech laj yal: ―Bijanic me, mu me buchꞌu xasloꞌlaoxuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yuꞌun ep ti buchꞌutic sbiinojic ti jbi ti jech ta xalique: “Vuꞌunun ti Cristo”, ti xie. Jech o xal ep ti buchꞌu ta sloꞌlae. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti voꞌoxuque ta xavaꞌibeic scꞌoplal ti oy la leto leꞌe, ti oy la leto taj toe, ti xie. Pero mu xaxiꞌic. Yuꞌun jech onoꞌox ta xcꞌot ta pasel. Pero maꞌuc to slajebal cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ti jun mucꞌ ta lume ta xlic scrontain sbaic schiꞌuc yan mucꞌ ta lum. Jaꞌ jech xtoc ti jun ajvalile ta xlic scrontain sbaic schiꞌuc ti yan ajvalile. Ta xtal viꞌnal. Ta xtal chamel. Buꞌyuc noꞌox oy niquel. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ti vaꞌi sꞌelan taje, sliquebal to ti vocole. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jech ti voꞌoxuque ta xaꞌacꞌatic ta cꞌabal. Ta xavichꞌic ilbajinel. Ta xavichꞌic milel. Scotol cristianoetic xtiꞌet sjolic ta atojolic ta jventa. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti jech taje, ep ti buchꞌutic ta xchꞌay ta yoꞌntonic ta yichꞌel ta mucꞌ ti Diose. Jech xtoc ta scrontain sbaic. Ta xacꞌan sbaic ta milel. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jech xtoc ep jloꞌlavanejetic ta xvul ta loqꞌuel ti ta xcꞌopojic ta sventa Dios ta xalique. Ep ta sloꞌlaic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ta xꞌayan ep ta tos ti mulile. Jech o xal ep ti buchꞌutic ta xictaic ti cꞌux ta xaꞌi sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ti buchꞌu staoj o yav yoꞌnton xcham xlaje, jaꞌ ta xcol. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ti lequil achꞌ cꞌop ti jaꞌ ventainel yuꞌun ti Diose ta xichꞌ puquel ta sbejel banomil, yoꞌ jech ta snaꞌic scotolic ti oy coltaele. Mi jech laj taje, jaꞌ o xa slajebal cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","’Ti jꞌalcꞌop Daniele laj stsꞌiba comel scꞌoplal ti jsoquesvanej ti ta xchꞌayvane. (Ti buchꞌu ta sqꞌuel liꞌe, acꞌo yaꞌi lec ti cꞌusi ta xale.) Cꞌalal ta xavilic ti ta xcꞌot vaꞌluc ta temploe, acꞌo jatavicuc batel ta vitstic ti buchꞌutic nacalic ta Judea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jech xtoc ti buchꞌu oy ta schaꞌcojal snae, mu me xyal talel ta sloqꞌuesel ti cꞌusi ta xtun yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jech xtoc ti buchꞌu oy ta yosile, mu me sut talel ta stamel ti scꞌuꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti jech cꞌacꞌal taje, abol sba ti antsetic ti buchꞌutic schiꞌuc ti yolique schiꞌuc ti buchꞌutic ta to xchuꞌun ti yolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ti voꞌoxuque, cꞌanbeic me ti Diose ti maꞌucuc me ta yorail sictic ti ta xajatavic batele, ti maꞌucuc me ta scꞌacꞌalil ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yuꞌun mu noꞌox albajuc ti vocol ta xtale. Sba to velta ti jech ta xichꞌ svocolic ti cristianoetique. Jaꞌ mu sta ti ta sliquebal banomile. Cꞌalal mi echꞌe, mu xa sta jech. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti manchucuc ta sbicꞌtajes vocol ti Diose, muꞌyuc buchꞌu junucal ta xcolic. Pero ta sbicꞌtajes ti vocole ta sventa scꞌuxul yoꞌnton yuꞌun ti buchꞌu tꞌujbilique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Mi oy buchꞌu ta xalboxuque: “Qꞌuel avilic, liꞌ xa oy ti Cristoe”, mi moꞌoje: “Leꞌ xa oy”, mi xayutique, mu xachꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yuꞌun toj ep ti jloꞌlavanejetic ti ta xtal liꞌ ta sba banomile, ti ta sbis sbaic ta Cristoe. Mi moꞌoje, ta xalic ti jaꞌ viniquetic ti ventainbilic yuꞌun ti Diose. Ep ta xaqꞌuic ta ilel señail ti tsots xuꞌ yuꞌunique, yoꞌ ta sloꞌlaic yaꞌiic ti buchꞌu tꞌujbilic yuꞌun ti Dios ti xuꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Laj xa jpocoꞌalboxuc avaꞌiic ti jech ta xcꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jech o xal mi oy buchꞌu ta xalboxuc: “Qꞌuel avilic, leꞌ xa oy ta xocol banomil”, mi xayutique, mu xabat tey. Mi ta xalboxuc: “Liꞌ xa oy ta jun na”, mi xayutique, mu xachꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yuꞌun ti cꞌalal ta sta yorail ti ta xichaꞌsut talele ti vuꞌun coꞌol jꞌelantique, scotol ta xilic ti coꞌol sꞌelan sactsel ti xvinaj ti xnoplajet xa ta vinajel ta sloqꞌueb cꞌacꞌale, ta smaleb cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ti bu oy ti animae tey chba stsob sbaic ti xulemetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Cꞌalal mi echꞌ xa yorail ti vocole, ta xꞌicꞌub ti cꞌacꞌale. Ti ue mu xa xacꞌ ti xojobale. Ti cꞌanaletique xlaj bajicuc yalel tal ta vinajel. Scotol ti cꞌusitic oy ta vinajele xlaj nicanuc. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jaꞌ o yorail ta xvinaj ta vinajel ti ta xichaꞌsut talel ti vuꞌun coꞌol jꞌelantique. Scotol ti cristianoetic ti oyic ta sjoylej banomile ta xꞌoqꞌuic. Yuꞌun ta xiyilicun ti ta xital ta ba toc schiꞌuc jmucꞌul jlequilal ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jaꞌ o tey ta jpas ta mantal ti cajꞌángeltaque ti tsots acꞌo yoqꞌuisanic ti cornetae yoꞌ ta stsobic tal ti calab jnichꞌnab ti tꞌujbil cuꞌune, ti buꞌyuc noꞌox oyic ta sjoylejal banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Cꞌalal ta xavilic ti ta xꞌuninaj scꞌobtac, ta sjelta yanal ti icuxe, xanaꞌic lec ti jaꞌ o xa yorail ti ta xtal ti voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jech xtoc, cꞌalal ta xavilic ti jech ta xcꞌot ta pasel scotole, naꞌic me lec ti nopolun xa talel ta tiꞌ nae. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ta melel ta xcalboxuc avaꞌiic, scotol ta xcꞌot ta pasel cꞌalal mu to ta xchamic ti cristianoetic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ti vinajele, ti banomile ta xlaj scꞌoplal. Pero ti jcꞌope mu stsꞌelbuj scꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ti scꞌacꞌalil yorail ti ta xitale, muꞌyuc buchꞌu snaꞌ. Mi jaꞌuc snaꞌ ti ángeletic ti oyic ta vinajele. Mi jaꞌuc jnaꞌ ti vuꞌun Snichꞌonun ti Diose. Jaꞌ noꞌox snaꞌoj stuc ti Totil Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jech chac cꞌu chaꞌal icꞌot ta pasel ti cꞌalal cuxul to ox ti Noee, jaꞌ noꞌox jech ta xcꞌot ta pasel ti cꞌalal ta xichaꞌsut tal ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cꞌalal mu to ox xtal ti nojel ta voꞌe, ti cristianoetique jaꞌ noꞌox batem ta yoꞌntonic ti veꞌel uchꞌ voꞌe, ti ta xicꞌan sbaique, ti ta xacꞌ ta nupunel ti yalab snichꞌnabique. Jaꞌ jech laj spasolanic o jaꞌ to ti cꞌalal iꞌoch bal ta barco ti Noee. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Muꞌyuc onoꞌox xaꞌiic cꞌuxi ital ti nojel ta voꞌe. Jaꞌ to laj yaꞌiic ti ta xnojic xa ta voꞌ scotolique. Tey ilaj scotolic. Jaꞌ jech sꞌelan ta xcꞌot ta pasel ti cꞌalal ta xichaꞌsut talel ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti jech ora taje, oy chib viniquetic ti jmoj ta xꞌabtejic ta yosilique. Jun ta xꞌicꞌat batel. Jun ta scomtsanat. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jaꞌ jech xtoc oy chib antsetic ti jmoj ta xjuchnajique. Jun ta xꞌicꞌat batel. Jun ta scomtsanat. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jech o xal ti voꞌoxuque viqꞌuiluc me asatic. Yuꞌun mu xanaꞌic ti cꞌusi ora ta xital ti Ajvalilune. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naꞌic me lec, ti snaꞌuc ti jun yajval na ti cꞌusi ora ta xꞌoch talel ti jꞌeleqꞌue, muꞌyuc ta xvay ti jechuque. Tey julavem o yoꞌ mu xjambat sna yuꞌun ti jꞌeleque. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaꞌ jech ti voꞌoxuc eque, chapalucoxuc me. Yuꞌun mu xanaꞌic ti cꞌusi ora ta xichaꞌsut talele. Ti vuꞌun coꞌol jꞌelantique yicꞌal jaꞌ o ta xivul cꞌalal maꞌuc yorail ti ta xanopique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Ti buchꞌu lequil jꞌabtele, ti oy sbijile, ta xꞌacꞌbat sventain comel sna ti yajvale, yoꞌ jech ta xacꞌbe sveꞌel ti schiꞌiltac ta abtel ti cꞌalal ta sta yorail ti ta xveꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xmuyubaj noꞌox ti jꞌabtele ti cꞌalal yacal ta spas yabtel ta xvul taatuc yuꞌun ti yajvale. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta melel ta xcalboxuc avaꞌiic, ti yajvale ta xacꞌbe sventain ti yajꞌabtele scotol ti cꞌusitic oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero mi jaꞌ jun chopol jꞌabtele, ta snop ti jal to scꞌan xtal ti yajvale. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jech o xal ta xlic yilbajin ti schiꞌiltac ta abtele. Tey chotol ta veꞌel, ta uchꞌ voꞌ schiꞌuc jyacubeletic. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jaꞌ yuꞌun un, ti chopol jꞌabtele chꞌayal yoꞌnton ta xvul taatuc yuꞌun ti yajvale, jaꞌ ti mu snaꞌ cꞌusi ora ta xvule. ");
INSERT INTO tzotzc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jech ti ajvalile ta xacꞌbe yichꞌ tsots castigo ti chopol jꞌabtele. Jech ta xichꞌ castigo jech chac cꞌu chaꞌal ta xichꞌic ti buchꞌutic ta spacꞌta sbaique. Jech o xal umbi, tey ta xꞌocꞌ, tey xcꞌuxuxet ye ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ti Jesuse jech laj yal xtoc: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal lajuneb tsebetic ti yichꞌojic batel ti slamparaic ti chba snupic ta be ti jnupunel vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oy voꞌob ti muꞌyuc sbijilique. Oy voꞌob ti oy sbijilique. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ti voꞌob ti muꞌyuc sbijilique, ti cꞌalal laj yichꞌic batel ti slamparaique, mu xa bu laj yichꞌic batel yan aceite yoꞌ ta snojesic yan velta. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero ti voꞌob bijique, ti cꞌalal laj yichꞌic batel ti slamparaique, laj to yichꞌic batel yan aceite ta limite. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ti jnupunel vinique ijalij. Jech o xal itsacatic ta vayel scotolic. Jech ivayic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nopol xa van oꞌlol acꞌobal ti cꞌalal jaꞌ o oy buchꞌu tsots iꞌavan ti jech laj yale: “Tal xa ti jnupunel vinique. Locꞌanic talel. Laꞌ nupic ta be”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Scotol ti tsebetique iliquic, lic xchapanic ti slamparaique. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pero ti voꞌob ti muꞌyuc sbijilique jech laj yalbeic ti voꞌob bije: “Acꞌbuncutic jutebuc avaceiteic. Yuꞌun ti jlamparacutique ta xa scꞌan ta xtub”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero ti bijil tsebetique jech laj staqꞌuic: “Mu stacꞌ. Ti mi ta xcacꞌcutique, mu xlocꞌ o cuꞌuncutic. Jaꞌ jech xtoc mu xlocꞌ o avuꞌunic ec. Jaꞌ lec, batanic ti bu ta xchone. Manic ti ta xtun avuꞌunique”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cꞌalal jech batemic ta smanel ti yaceiteic ti bolat tsebetique, jaꞌ o ivul ti jnupunele. Yan ti bijil tsebetique, ti xchapanoj onoꞌox sbaique, iꞌochic batel schiꞌuc ti jnupunele. Imac ti tiꞌ nae. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsꞌacal to italic ti yan tsebetique. Jech laj yalic: “Cajval, Cajval, jambuncutic”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero ti jnupunele jech laj stacꞌ: “Ta melel mu xacojtiquinic”, xꞌutatic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ti Jesuse jech laj yal: ―Ti voꞌoxuque vicꞌluc me asatic. Yuꞌun mu xanaꞌic ti cꞌusi ora, cꞌusi cꞌacꞌalil ta xital ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ti Jesuse jech laj yal xtoc: ―Ti ventainel yuꞌun ti Dios ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal jun vinic ti cꞌalal ta xa xlocꞌ batel ta yan lume, laj sta ta iqꞌuel ti yajꞌabteltaque ti ta xacꞌbe comel sventain ti staqꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ti jun yajꞌabtele iꞌacꞌbat comel voꞌob mil taqꞌuin. Ti jun xtoque iꞌacꞌbat comel chaꞌmil. Ti jun xtoque iꞌacꞌbat comel jmil. Jech laj spas, jaꞌ ti cꞌu sꞌelan xtojobic ta spiquele. Jech ti ajvalile ibat. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ti jꞌabtel ti buchꞌu laj yichꞌ comel ti voꞌob mil taqꞌuine, lic abtejuc schiꞌuc. Tey ijolin yuꞌun voꞌob mil. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jaꞌ jech xtoc ti jun jꞌabtel ti buchꞌu laj yichꞌ comel ti chaꞌmile, lic abtejuc schiꞌuc. Tey ijolin yuꞌun chaꞌmil. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ti jꞌabtel ti buchꞌu laj yichꞌ comel ti jmile, jaꞌ noꞌox bat sjom chꞌen ta banomil. Laj snacꞌbe staqꞌuin ti yajvale. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ta sjalil to un, isut talel ti ajvalile. Tey lic xchapan cuenta schiꞌuc ti yajꞌabteltaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jaꞌ icꞌot baꞌyel ti buchꞌu laj yichꞌ ti voꞌob mil taqꞌuine. Jech laj yal: “Cajval, liꞌ oy ti ataqꞌuin ti laj avacꞌbun comel ti voꞌob mile. Jaꞌ jech xtoc liꞌ oy voꞌob mil ti ijolin talel cuꞌune”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ti ajvalile jech laj yal: “Lec oy. Lequil jꞌabtelot. Lec laj aventain ti juteb laj cacꞌbot comele. Jech o xal más to ep ta xcacꞌbot aventain. Muyuban, ochan talel ta jtojol”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsꞌacal to icꞌot ti buchꞌu laj yichꞌ comel ti chaꞌmil taqꞌuine. Jech laj yal: “Cajval, liꞌ oy ti chaꞌmil ti laj avacꞌbun comele. Jaꞌ jech xtoc liꞌ oy chaꞌmil ti ijolin cuꞌune”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ti ajvalile jech laj yal: “Lec oy. Lequil jꞌabtelot. Lec laj aventain ti juteb ti laj cacꞌbot comele. Jech o xal más to ep ta xcacꞌbot aventain. Muyubajan. Ochan talel ta jtojol”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Cꞌalal icꞌot ti buchꞌu laj yichꞌ ti jmil taqꞌuine, jech laj yalbe ti yajvale: “Cajval, jnaꞌ lec ti tsots vinicote. Ta xatsob ti tsꞌunobal ti bu moꞌcot laj atsꞌune. Jech xtoc ta xatsob ti tsꞌunobal ti bu moꞌcot laj avije. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jech o xal lixiꞌ, libat jnacꞌ ta lum ti ataqꞌuine. Liꞌ oy ti jaꞌ avuꞌune”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ti ajvalile jech laj yal: “Chꞌajil jꞌabtel. Chopol jꞌabtel. ¿Mi xanaꞌ xa onoꞌox lec cacꞌtic ti ta jtsob ti bu moꞌcun laj jtsꞌune, ti ta jtsob ti bu moꞌcun laj jvije? ");
INSERT INTO tzotzc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mi jeche, jaꞌ lec ti batuc aticꞌ ta banco ti jtaqꞌuine, yoꞌ oy xa sjol ti jtaqꞌuin ta xquichꞌ ti cꞌalal ta xivule”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jech o xal ti ajvalile jech laj yalbe ti buchꞌutic tey oyique: “Pojbeic tal ti jmil taqꞌuin ti yichꞌoje. Ba acꞌbeic ti buchꞌu yichꞌoj ti lajunmile. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yuꞌun ti buchꞌu oy yuꞌune, ta xꞌacꞌbat más yoꞌ oy sobrail yuꞌun. Pero ti buchꞌu mu xꞌabtej schiꞌuc ti juteb iꞌacꞌbate, ta xpojbat sutel ti juteb ti acꞌbile. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ti chopol jꞌabtel liꞌe jipic batel ta icꞌal osil ti bu ta xoqꞌuita sbae, ti bu xcꞌuxuxet ti yee”, xi ti ajvalile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ti Jesuse jech laj yal xtoc: ―Cꞌalal xtal ochcun ta Ajvalil ti vuꞌun coꞌol jꞌelantique, joyolic ti cajꞌángeltac ta xichoti ta lequil chotlebal ti yan yutsile. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta stsob sbaic tal ta jtojol scotol ti cristianoetic ti oyic ta jujun lume. Ta jchꞌac loqꞌuel ti cristianoetique jech chac cꞌu chaꞌal ta spas ti jqꞌuelchije ti ta xchꞌac loqꞌuel ti schij ti capal schiꞌuc ti schivoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ti chije ta xcacꞌ ta jbatsꞌi cꞌob. Yan ti chivoe ta xcacꞌ ta jtsꞌet cꞌob. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jech ti vuꞌun Ajvalilune jech ta xcalbe yaꞌi ti buchꞌu oyic ta jbatsꞌi cꞌobe: “Laꞌic ta jtojol ti voꞌoxuc ti laꞌichꞌatic ta cꞌux yuꞌun ti Jtote. Ochanic ti bu ta xventainvan ti Jtote. Yuꞌun jech onoꞌox chapanbil acꞌoplalic ti cꞌalal muꞌyuc to ox bu meltsajem ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yuꞌun ti cꞌalal laj caꞌi ti viꞌnale, laj amalqꞌuinicun. Cꞌalal laj caꞌi ti taqui tiꞌile, laj avacꞌbeicun voꞌ cuchꞌ. Cꞌalal laj avilicun ti jcotcovilune, laj aviqꞌuicun ochel ta anaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cꞌalal laj avilicun ti chꞌabal jcꞌuꞌe, laj avacꞌbeicun. Cꞌalal laj avaꞌiic ti jchamelune, ay aqꞌuelicun. Cꞌalal tiqꞌuilun ta chuquele, ay aqꞌuelicun”, xichi ta stojolic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jech o xal ti buchꞌutic lec xa xꞌilatic yuꞌun ti Diose jech xlic yalic: “Cajval, ¿bu laj jmalqꞌuinotcutic ti cꞌalal laj avaꞌi viꞌnale? ¿Bu laj cacꞌbotcutic avuchꞌ voꞌ ti cꞌalal laj avaꞌi taqui tiꞌile? ");
INSERT INTO tzotzc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Bu laj quilotcutic ti jcotcovilote, ti laj quicꞌotcutic ochel ta jnacutique? ¿Bu laj cacꞌbotcutic acꞌuꞌ cꞌalal chꞌabal acꞌuꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bu ay jqꞌuelotcutic ti cꞌalal ip ta xavaꞌie? ¿Bu ay jqꞌuelotcutic ti cꞌalal tiqꞌuilot ta chuquele?” xiic ta jtojol. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ti vuꞌun Ajvalilune jech ta jtacꞌbeic: “Ta melel ta xcalboxuc avaꞌiic, ta sventa ti jech laj acꞌuxubinic ti jun jchiꞌile, acꞌo mi peqꞌuel ti scꞌoplale, jaꞌ laj acꞌuxubinicun”, xichi ta stojolic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ti vuꞌun Ajvalilune jech ta xcalbe ti buchꞌu oyic ta jtsꞌet cꞌobe: “Chꞌaco abaic ta jtojol ti voꞌoxuc chopol acꞌoplalique. Batanic ta cꞌocꞌ sbatel osil ti bu meltsanbil ti jaꞌ sventa ti pucuje schiꞌuc ti yajꞌángeltaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yuꞌun cꞌalal laj caꞌi viꞌnale, muꞌyuc bu laj amalqꞌuinicun. Cꞌalal laj caꞌi taqui tiꞌile, muꞌyuc bu laj avacꞌbeicun voꞌ cuchꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cꞌalal jcotcovilune, muꞌyuc bu laj aviqꞌuicun ochel ta anaic. Cꞌalal chꞌabal ti jcꞌuꞌe, muꞌyuc bu laj avacꞌbeicun. Cꞌalal ipune, tiqꞌuilun ta chuquele, muꞌyuc bu ay aqꞌuelicun”, xichi ta stojolic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jech ti stuquique jech ta xalic: “Cajval, ¿bu laj quilot ti ta xavaꞌi ti viꞌnale, ti ta xavaꞌi ti taqui tiꞌile, ti jcotcovilote, ti chꞌabal acꞌuꞌe, ti ip ta xavaꞌie, ti tiqꞌuilot ta chuquele, ti muꞌyuc laj jcoltaotcutic ti ta xavale?” xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ti vuꞌun Ajvalilune jech ta jtacꞌbeic: “Ta melel ta xcalboxuc avaꞌiic, ta sventa ti muꞌyuc laj acꞌuxubinic ti achiꞌilique, acꞌo mi peqꞌuel ti scꞌoplale, jaꞌ vuꞌun ti muꞌyuc laj acꞌuxubinicune”, xichi ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tsꞌacal to ti buchꞌutic chopolique ta xbatic ta tojob mulil sbatel osil. Yan ti buchꞌutic lec xa xꞌilatic yuꞌun ti Jtote ta xbatic ta sventa cuxlejal sbatel osil ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cꞌalal jech laj yal ti Jesuse, tey lic yalbe ti yajchancꞌoptaque: ");
INSERT INTO tzotzc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ti voꞌoxuque xanaꞌic ti chib xa cꞌacꞌal scꞌan ti qꞌuin Colele. Jech ti vuꞌun ti coꞌol jꞌelantique ta xiyaqꞌuic ta cꞌabal yoꞌ ta xisjipanic ta cruz ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti banquilal paleetique, ti jchanubtasvanejetic yuꞌun ti mantale, ti moletic yuꞌun ti jꞌisraeletique ta stsob sbaic ec ta yamaqꞌuil sna ti Caifase, jaꞌ ti banquilal yuꞌun ti paleetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cꞌalal tey xa tsobolique, lic scomonopic cꞌu sꞌelan ta mucul ta stsaquic ti Jesuse, yoꞌ ta xaqꞌuic ta milel. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jech lic yalbe sbaic: ―Maꞌuc ta yorail qꞌuin ta jtsactic yoꞌ jech mu xlic cꞌop yuꞌun ti epal cristianoetique ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ti Jesuse tey oy ta jteclum Betania ta sna ti Simone, jaꞌ ti jcꞌaꞌemal-chamel sbiinoje. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tey inopaj batel jun ants ti yichꞌoj batel sjarro ti meltsanbil ta alabastro tone. Noj ta aceite ti mu ta perfumee ti toyol stojole. Cꞌalal chotol ta mexa ti Jesuse, ti antse ba smalbe ta sjol ti aceitee. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cꞌalal laj yilic ti yajchancꞌoptaque, chopol laj yaꞌiic. Jech lic yalbe sbaic: ―¿Cꞌu chaꞌal laj yixlan ti muꞌil perfumee? ");
INSERT INTO tzotzc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Xuꞌ ta xichꞌ chonel ta toyol stojol ti jechuque, yoꞌ jech ta xichꞌ coltael ti buchꞌu abol sbaique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ti Jesuse laj yaꞌi. Jech o xal jech laj yalbe: ―¿Cꞌu chaꞌal ta xavaqꞌuic ta at oꞌnton ti ants liꞌe? Yuꞌun toj lec ti cꞌusi laj xa spasbune. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ti buchꞌutic abol sbaique liꞌ onoꞌox oy ta atojolique. Yan ti vuꞌune mu scotoluc cꞌacꞌal liꞌ oyun ta atojolique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ti jech laj smalbun ta jba ti aceitee, jaꞌ sventa jmucobbail. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ta melel ta xcalboxuc avaꞌiic, buꞌyuc noꞌox ti ta xichꞌ alel ti lequil achꞌ cꞌop ta sjoylej banomile, tey xvinajesbat scꞌoplal ti ants ti jech laj spas ta jtojole, yoꞌ jech mu xchꞌay scꞌoplal ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oy jun ta slajchaꞌvoꞌal ti yajchancꞌoptac ti sbiinoj Judas Iscariotee, bat scꞌopon sbaic schiꞌuc ti banquilal paleetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jech laj yal: ―¿Cꞌu yepal ta xavacꞌbun yoꞌ ta xcacꞌ ta acꞌobic ti Jesuse? ―xi. Jech o xal ti stuquique laj yaqꞌuic lajuneb schaꞌvinic (30) ta sep saquil taqꞌuin. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cꞌalal yichꞌoj xa taqꞌuin ti Judase, jaꞌ o lic snopilan cꞌusi ta xut yoꞌ jech ta xacꞌ ta cabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti sliquebal cꞌacꞌal ti qꞌuin ti cꞌalal ta sveꞌic ti pan ti chꞌabal yichꞌoj ti spajubtasobile, jech ti yajchancꞌoptaque inopajic batel ta stojol ti Jesuse. Jech lic sjacꞌbeic: ―Albun caꞌicutic, ¿bu ta xacꞌan ti chba jpascutic ti veꞌlil yoꞌ jech ta xaveꞌ sventa ti qꞌuin Colele? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ti Jesuse jech itacꞌav: ―Batanic ta sna jun vinic ti leꞌ ta jteclume. Albeic yaꞌi: “Jech ta xal ti Jchanubtasvaneje: Nopol xa corail. Liꞌ ta ana ta xiveꞌcutic sventa ti qꞌuin Colele schiꞌuc ti cajchancꞌoptaque, xi ti Cajvale”, xavutic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ti yajchancꞌoptaque jech laj spasic jech chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse. Tey laj xchapanic ti veꞌlil sventa ti qꞌuin Colele. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cꞌalal iꞌoch xa ti acꞌobale, ti Jesuse tey chotolic ta mexa schiꞌuc ti lajcheb yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cꞌalal xyaquetic ta veꞌele, ti Jesuse jech lic yal: ―Ta melel ta xcalboxuc avaꞌiic, oy jun avuꞌunic ti voꞌoxuque ti ta xavaqꞌuicun ta cꞌabale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Cꞌalal jech laj yaꞌiique, ochic ta at oꞌnton. Tey lic yalic ta stojol ti Jesuse: ―Cajval, ¿mi jaꞌ van liꞌ vuꞌune? xiic ta jujun tal. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ti Jesuse jech laj stacꞌ: ―Ti buchꞌu ta xiyacꞌ ta cꞌabale, jaꞌ ti buchꞌu jun jsetsꞌ ta xiveꞌcutique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ti vuꞌun coꞌol jꞌelantique jech onoꞌox ta xcꞌot ta jtojol jech chac cꞌu chaꞌal ti tsꞌibabil ta scꞌop Diose. Pero toj abol sba ti vinic ti buchꞌu jech ta xiyacꞌun ta cꞌabale. Jaꞌ lec ti manchucuc ivoqꞌue ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jech ti Judase ti jꞌacꞌvanej ta cꞌabale, jech lic yal: ―Jchanubtasvanej, ¿mi jaꞌ van ti vuꞌune? ―xi. Ti Jesuse jech laj stacꞌbe: ―Jaꞌ ti voꞌote ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cꞌalal xyaquet ta xveꞌique, ti Jesuse lic stsac ti pane. Laj yalbe vocol ti Diose. Tsꞌacal to laj xet. Laj yacꞌbe ti yajchancꞌoptaque. Jech lic yal: ―Veꞌanic ti pan liꞌe, jaꞌ ti jbecꞌtale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tsꞌacal to ti Jesuse lic stsac ti yavil yaꞌlel uvae. Laj yalbe vocol ti Diose. Tsꞌacal to laj yacꞌbe ti yajchancꞌoptaque. Jech laj yal: ―Uchꞌan acotolic ti yaꞌlel uva liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yuꞌun ti yaꞌlel uva liꞌe, jaꞌ xa ti cꞌot xa ta spasel ti achꞌ trate ta sventa ti ta xmal ti jchꞌichꞌele, ti jaꞌ sventa ta staic perdón yuꞌun smulic scotol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta melel ta xcalboxuc avaꞌiic, slajeb velta ti jech ta xcuchꞌ ti yaꞌlel uvae. Jaꞌ to jmoj ta xcuchꞌtic achꞌ yaꞌlel uva ti cꞌalal ta jtsob jbatic ti bu ta xventainvan ti Jtote ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cꞌalal laj yoꞌntonic ta sqꞌuejintael jun qꞌuejoje, tey ibatic ta vits Olivos. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jaꞌ yuꞌun ti Jesuse jech laj yal: ―Acotolic ti voꞌoxuque ta xchibaj avoꞌntonic ta jtojol ti acꞌobaltic liꞌe. Yuꞌun jech ta xal ti tsꞌibabil ta scꞌop Diose: “Ta xcacꞌ ta milel ti jqꞌuelchije. Jech ti chije tan puc ta xbat”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cꞌalal ta xichaꞌcuxie, vuꞌun ta xijelav batel ta Galilea banomil. Tsꞌacal to ta xacꞌotic ti voꞌoxuque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ti Pedroe jech laj yal: ―Manchuc mi ta xchibaj yoꞌntonic ti yane, ti vuꞌune mu xchibaj coꞌnton ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ti Jesuse jech laj yal: ―Ta melel ta xcalbot avaꞌi, Pedro, ti acꞌobaltic liꞌe cꞌalal mu to xlic ocꞌuc ti cotse, oxib xa ox velta ta xaval ti mu xavojtiquinune ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero ti Pedroe jech laj stacꞌbe ti Jesuse: ―Ta jamal ta xcalbot avaꞌi, manchuc mi jmoj ta xijlajotic ta milel, mi jaꞌuc ta xcal ti mu xacojtiquine ―xi. Pero maꞌuc noꞌox jech laj yal ti Pedroe. Jaꞌ jech laj yalic ti yan xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cꞌalal icꞌotic ta tsꞌunobaltic ti jaꞌ Getsemaní sbie, ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Chotlanic to comel liꞌe. Vuꞌune chba jta ta cꞌoponel ti Dios leꞌ ta jote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ti Jesuse yicꞌoj bal ti Pedroe schiꞌuc ti chaꞌvoꞌ snichꞌon ti Zebedeoe. Ti Jesuse lic yaꞌi ta yoꞌnton ti mu xa jayloqꞌueluc xꞌechꞌ ta xaꞌi ti vocole. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jech o xal jech laj yal: ―Ta xicham ta at oꞌnton xcaꞌi. Comanic to liꞌe. Mu xavayic. Vicꞌo me asatic ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jech ti Jesuse jech snatil ibat. Tey laj spatan sba ta lum. Laj sta ta cꞌoponel ti Diose ti jech laj yale: ―Tot, ti xuꞌuc ti mu xquichꞌ ti jvocole, coltaun yoꞌ mu xcꞌot ta jtojol. Pero maꞌucuc me ta xcꞌot ta pasel ti cꞌusi ta jcꞌan jtuque. Jaꞌ acꞌo cꞌotuc ta pasel ti cꞌusi ta xacꞌan atuque ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ti Jesuse isut batel ti bu icomic ti yajchancꞌope. Pero vayemic cꞌot sta. Jech o xal ti Jesuse jech laj yalbe ti Pedroe: ―¿Mi mu xuꞌ avuꞌunic ta xachiꞌinicun ti vicꞌluc asatic junuc orae? ");
INSERT INTO tzotzc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vicꞌluc me asatic. Taic me ta cꞌoponel ti Diose yoꞌ jech mu xastsaloxuc ti pucuje. Ta melel, oy yip ti avoꞌntonique. Pero muꞌyuc yip ti abecꞌtalique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti Jesuse ichaꞌsut batel schibal velta ti bu ta sta ta cꞌoponel ti Diose. Jech lic yal: ―Tot, mi mu xacꞌan ta xavetꞌesbun ti jvocole, acꞌo cꞌotuc ta pasel ti cꞌusi ta scꞌan avoꞌntone ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsꞌacal to un, isut tal ti Jesuse. Pero vayemic vul sta yan velta ti yajchancꞌope, jaꞌ ti ta smutsꞌbat satic yuꞌun ti vayele. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ti Jesuse tey laj yicta comel. Tey ba sta ta cꞌoponel ti Dios ta yoxibal xa veltae. Ti cꞌu sꞌelan laj yal ta baꞌyele, jaꞌ noꞌox jech laj yal xtoc. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsꞌacal to isut batel ti bu comemic ti yajchancꞌope. Jech lic yal: ―Vayanic. Cuxo avoꞌntonic. Qꞌuel avil, sta xa yorail ti ta xiꞌacꞌat ta scꞌob ti jsaꞌmuliletique, ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Licanic, batic. Yuꞌun tal xa ti buchꞌu ta xiyacꞌ ta cꞌabale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ti Jesuse yacal to ta xcꞌopoj cꞌalal jaꞌ o icꞌot ti Judase ti jaꞌ jun ta slajchebal ti yajchancꞌoptaque. Schiꞌuc talel epal cristianoetic schiꞌuc yespadaic schiꞌuc steꞌic ti jaꞌ tacbilic talel yuꞌun ti banquilal paleetique schiꞌuc ti moletic yuꞌun ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ti Judase, ti jꞌacꞌvanej ta cꞌabale, spocoꞌalojbe xa onoꞌox ti jtsacvanejetique: ―Ti buchꞌu ta jbutsꞌ ta xavilique, jaꞌ me umbi. Tsaquic batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cꞌalal cꞌot ti Judas ti bu oy ti Jesuse, jech laj yal: ―¿Mi liꞌ oyote, Jchanubtasvanej? ―xut. Jaꞌ o tey lic sbutsꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ti Jesuse jech laj yal: ―Chiꞌiltic, ¿cꞌusi tal apas? ―xꞌutat. Cꞌalal jech laj yilique, jaꞌ o tey tal stsaquic ti Jesuse. Laj xchuquic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Oy jun schiꞌilic ti Jesuse laj sloqꞌues ti yespadae. Laj sbojbe schiquin smosov ti banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ti Jesuse jech laj yalbe: ―Ticꞌo ochel ta sna ti avespadae. Yuꞌun ti buchꞌu ta xmilvan ta espadae, ta espada ta xcham ec. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mi mu xanaꞌ ti xuꞌ ta jcꞌanbe ti Jtote ti acꞌo stacbun talel más ta oxvinic ta mil (60,000) ti ángeletique? ");
INSERT INTO tzotzc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ti mi jech ta jpase, ¿cꞌu sꞌelan ta xcꞌot ta pasel ti cꞌusi tsꞌibabil ta scꞌop Dios ti ta xal ti ta onoꞌox xcꞌot ta pasele? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ti Jesuse jech laj yalbe ti jtsacvanejetique: ―Ti voꞌoxuque latalic schiꞌuc avespadaic schiꞌuc ateꞌic. Tal atsaquicun coꞌol sꞌelan jun jꞌelecꞌ cꞌalal scotol cꞌacꞌal tey oyun ta atojolic laj jchanubtasoxuc ti ta temploe. Pero mi jaꞌuc laj atsaquicun. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ti jech ta xapasique, jaꞌ ta sventa yoꞌ ta xcꞌot ta pasel ti cꞌusi tsꞌibabil ta scꞌop Dios ti laj yalic ti jꞌalcꞌopetique ―xi. Jech ti yajchancꞌoptaque laj yictaic comel stuc ti Jesuse. Ijatavic batel scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ti jtsacvanejetique tey laj yiqꞌuic batel ti Jesús ta stojol ti Caifase, jaꞌ ti banquilal pale yuꞌun ti paleetique. Tey ta sna ti Caifase stsoboj sbaic ti jchanubtasvanej yuꞌun ti mantale schiꞌuc ti moletic ti ichꞌbil yeique. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ti Pedroe nomtic tijil batel. Iꞌoch batel cꞌalal to yamaqꞌuil sna ti banquilal palee. Tey chotol schiꞌuc ti mayoletique yoꞌ ta sqꞌuel ti cꞌusi ta xcꞌot ta stojol ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ti banquilal paleetique, ti moletique, ti banquilal jchapanvanejetique ta saꞌolanic cꞌu sꞌelan ta stabeic smul ti Jesuse, manchuc mi jutbil, yoꞌ jech xuꞌ ta xaqꞌuic ta milel. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Manchuc mi oy ep ti cristianoetic ti buchꞌutic laj svaꞌan sbaic ta rextigo yoꞌ jech ta saꞌbeic smul ti Jesuse, pero mi jaꞌuc juteb oy bu laj stabeic ti smule. Tsꞌacal to tey ital chaꞌvoꞌ jutcꞌop rextigoetic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jech laj yalic: ―Ti vinic liꞌe, laj caꞌicutic ti jech laj yale: “Ti vuꞌune xuꞌ ta jlilin ti templo yuꞌun ti Diose. Tsꞌacal to ta jchaꞌvaꞌan ta oxib cꞌacꞌal jun achꞌ”, xi laj caꞌicutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tey ivaꞌi ti banquilal palee. Jech lic sjacꞌbe ti Jesuse: ―¿Cꞌu chaꞌal ti mu xapac ti acꞌoplale? ¿Cꞌu chaꞌal ti vaꞌi sꞌelan ta xaꞌalbat ti amule? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ti Jesuse tsꞌijil icom. Jech o xal ti banquilal palee jech laj yal: ―Ta sba ta sat ti cuxul Diose, jamal albun caꞌicutic, ¿mi voꞌot ti Cristo Snichꞌon ti Diose? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ti Jesuse jech itacꞌav: ―Vuꞌun, jech chac cꞌu chaꞌal ta xavale. Jech xtoc ta xcalboxuc avaꞌiic ti ta xavilicun ti coꞌol jꞌelantique ti ta xichoti ta sbatsꞌi cꞌob ti Dios ti scotol xuꞌ yuꞌune. Jech xtoc ta xavilicun ti ta xital ta ba toque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jech o xal ti banquilal palee lic xchꞌiꞌ ta jatel ti scꞌuꞌe, svinajeb ti toj chopol laj yaꞌie. Jech o xal jech laj yal: ―Ti vinic liꞌe laj xa xchopol-cꞌopta ti Diose. Mu xa persauc ta jcꞌantic yan rextigo. Ti voꞌoxuque laj xa avaꞌiic ti toj chopol ta xcꞌopoje. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Cꞌu sꞌelan ta xcꞌot ta avoꞌntonic taje? ―xi. Ti stuquique jech laj yalic: ―Oy smul. Acꞌo chamuc ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jech o xal ti jchapanvanejetique lic stubtabeic sat, lic smajic ti Jesuse. Oy jlom laj stꞌaxbeic ta majel ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Jech laj yalic: ―Ti mi voꞌot ti Cristoe, jech o xal naꞌo caꞌtic ti buchꞌu laj smajote ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Cꞌalal jech ta spasique, jech ti Pedroe chotol ta yamaqꞌuil na. Jaꞌ o tey ital jun mosovil ants ti jech laj yale: ―Ti voꞌot eque jaꞌ achiꞌil ta xanobal ti Jesús ti liquem talel ta Galileae ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ti Pedroe mu jamaluc laj yal sba. Jech laj stacꞌ: ―Mu jnaꞌ buchꞌu ti ta xavalbun taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ti Pedroe ta xa ox xlocꞌ batel ta tiꞌ moc cꞌalal jaꞌ o iꞌilat yuꞌun yan mosovil ants. Ti antse jech laj yalbe ti buchꞌu tey tsobolique: ―Ti vinic leꞌe jaꞌ schiꞌil ta xanobal ti Jesús ti liquem talel ta Nazarete ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ti Pedroe yan to velta laj smuc ta yoꞌnton ti Jesuse. Jech laj yal: ―Xil Dios, mu xcojtiquin buchꞌu ti vinic leꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lec xa ox jliquel yechꞌel, ti buchꞌutic tey stsoboj sbaique tey inopajic batel ta stsꞌel ti Pedroe. Jech laj yalbeic: ―Ta melel, ti voꞌote jaꞌ jun schiꞌilot ti Jesuse. Yuꞌun lec xvinaj cꞌu sꞌelan ti acꞌopojele ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ti Pedroe lic chopol-cꞌopojuc. Jech lic yal xtoc: ―Xil Dios, batsꞌi mu xcojtiquin buchꞌu ti vinic leꞌe ―xi. Cꞌalal jech laj yal ti Pedroe, jaꞌ o iꞌocꞌ ti cotse. ");
INSERT INTO tzotzc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jech o xal ti Pedroe tey ivul ta yoꞌnton ti jech onoꞌox iꞌalbat yuꞌun ti Jesuse: “Cꞌalal muꞌyuc to ta xꞌocꞌ ti cotse, ti voꞌote, oxib velta laj xa ox amucun ta avoꞌnton”, ti xꞌutate. Jech o xal ti Pedroe tey ilocꞌ batel. Tey bat smil sba ta oqꞌuel. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cꞌalal sacub xa ti osile, scotol ti banquilal paleetique schiꞌuc ti moletic yuꞌun ti jꞌisraeletique laj scomonopic cꞌusi xuꞌ ta spasic yoꞌ ta xaqꞌuic ta milel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jech o xal ti stuquique chucul scꞌob yicꞌojic batel ti Jesuse ta stojol ti ajvalil Poncio Pilatoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cꞌalal tey chucbil xa batel ti Jesuse, ti Judase, jaꞌ ti jꞌacꞌvanej ta cꞌabale, cꞌalal laj yil ti chapal xa scꞌoplal ti ta xichꞌ milel ti Jesuse, jech ti Judase yoꞌntonuc xa cꞌusi yut sba yaꞌi. Jech o xal ba sutes ti lajuneb schaꞌvinic (30) ta sep taqꞌuin ta stojol ti banquilal paleetique schiꞌuc ti moletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jech cꞌot yal: ―Laj xa jta jmul. Laj xa cacꞌ ta cꞌabal jun vinic ti chꞌabal smule ―xi. Pero ti stuquique jech laj staqꞌuic: ―¿Cꞌusi jventacutic? Jaꞌ aventa atuc ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jech o xal ti Judase laj sjip comel ti taqꞌuin ta yut ti temploe. Bat, ba xchuc snucꞌ. Tey jocꞌol icham. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ti banquilal paleetique laj stsobic ti taqꞌuine. Jech laj yalic: ―Ti taqꞌuin liꞌe, mu xa xuꞌ chba jticꞌtic ta scaxail ti smoton ti Diose. Yuꞌun jaꞌ stojol chꞌichꞌ ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ti taqꞌuin ti laj stamique, coꞌol laj scomonopic ti ta smanbeic ti sloqꞌuesoblumic ti jpatbinetique, yoꞌ jech ta xcom ta smucobbail ti jyanlumetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jech o xal ti banomil ti laj smanique, jaꞌ sbiinoj o icom “Yosilal chꞌichꞌ.” ");
INSERT INTO tzotzc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ti jech laj smanic ti osile, jaꞌ icꞌot ta pasel ti jech laj stsꞌiba comel ti jꞌalcꞌop Jeremíase: “Tey laj stsaquic ti lajuneb schaꞌvinic (30) ta sep taqꞌuine. Jaꞌ stojol ti jun jchiꞌiltic ti jech yepal laj yaqꞌuic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ti taqꞌuine, jaꞌ laj smanic o yosil ti jpatbinetique jech chac cꞌu chaꞌal yalojbun onoꞌox ti Cajvaltic Diose”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ti Jesuse icꞌbil batel ta stojol ti ajvalile. Jech laj sjacꞌbe: ―¿Mi voꞌot ti ajvalil yuꞌun ti jꞌisraeletique? ―xut. Ti Jesuse jech laj stacꞌ: ―Jaꞌ jech, jech chac cꞌu chaꞌal ta xavale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jech xtoc ti banquilal paleetique schiꞌuc ti moletique ta saꞌbeic smul ti Jesuse. Pero ti Jesuse mu xtacꞌav. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jech o xal ti Pilatoe jech lic yalbe: ―¿Mi mu xavaꞌi ti vaꞌi sꞌelan ta saꞌic ti amule? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ti Jesuse mi jaꞌuc itacꞌav. Jech o xal ti ajvalile chꞌayal cꞌot yoꞌnton. Labal laj yaꞌi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ti ajvalile jech onoꞌox stalel ti ta scolta batel jun jchuquel cꞌalal yorail ti qꞌuine, ti jaꞌ ta stꞌuj stuquic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oy tey tiqꞌuil ta chuquel jun vinic, Barrabás sbi, ti aꞌyinbil scꞌoplal ti toj chopole. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cꞌalal tsobol scotolique, jech ti Pilatoe jech lic sjacꞌ: ―¿Buchꞌu ta xacꞌanic ti ta jcolta batele? ¿Mi jaꞌ ti Jesús Barrabase, o mi jaꞌ ti Jesús ti sbiinoj Cristoe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jech laj sjacꞌ ti Pilatoe, jaꞌ ti laj yil ti ta yitꞌixal yoꞌntonic tal acꞌbatuque. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cꞌalal tey chotol ti ajvalil ti bu ta xchapanvane, jech ti yajnile laj stac talel mantal ti jech ta xale: “Mu xaticꞌ aba ta smilel ti jun lequil vinique. Yuꞌun ti ta acꞌobaltique livaychinaj ti toj echꞌem chopol ta sventa ti vinique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ti banquilal paleetique schiꞌuc ti moletique laj sbijubtasic ti cristianoetique ti jaꞌ acꞌo coluc ti Barrabase, ti jaꞌ acꞌo yichꞌ milel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ti ajvalile tey lic cꞌopojuc yan velta. Jech laj sjacꞌ: ―¿Buchꞌu junucal ti ta xacꞌanic ti ta jcolta batele? ―xi. Pero ti stuquique jech laj yalic: ―Jaꞌ ti Barrabase ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ti Pilatoe jech lic sjacꞌ: ―¿Cꞌusi ta xcut ti Jesús ti jaꞌ sbiinoj ti Cristoe? ―xi. Scotolic jech laj staqꞌuic: ―Jipano ta cruz ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jech ti Pilatoe jech lic yal: ―¿Cꞌusi chopol laj spas ti vinic liꞌe? ―xi. Pero ti stuquique lic chaꞌavanicuc yan velta: ―Jipano ta cruz ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cꞌalal laj yil ti Pilatoe ti muꞌyuc cꞌusi stacꞌ spase, ti cꞌajomal xvochvunic ta jmeque, lic stac ta cꞌanel jun boch voꞌ yoꞌ ta spoc scꞌob ta sba satic ti cristianoetique. Jech lic yal: ―Maꞌuc ta xcom ta jba ti ta xcham ti vinic liꞌe ti chꞌabal smule. Ta xcom ta abaic ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Scotolic jech itacꞌavic: ―Cajluc comuc ta jbacutic schiꞌuc ti calab jnichꞌnabcutic ti jech ta xchame ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jech o xal ti Pilatoe laj scolta batel ti Barrabase. Laj yal mantal ti acꞌo yichꞌ nucul ti Jesuse. Tsꞌacal to laj yal mantal ti acꞌo yichꞌ jipanel ta cruze. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ti yajsoldadotaque yicꞌojic batel ti Jesús ta cabiltoe. Tey laj stsob sbaic scotolic ti soldadoetic ta stojol ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tey lic slocꞌbeic ti scꞌuꞌe. Laj yacꞌbeic slap tsajal cꞌuꞌil. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tey lic xotic jun corona chꞌix ti laj xojbeic ta sjol ti Jesuse. Tey laj yacꞌbeic xqꞌuech jun jichꞌil teꞌ ta sbatsꞌi cꞌob. Jech lic squejan sbaic ta stojol yoꞌ ta slabanic ti jech laj yalique: ―Jun avutsil ti ajvalilot yuꞌun ti jꞌisraeletique ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jaꞌ jech xtoc laj stubtabeic sat. Tey laj stsacbeic ti sjichꞌil teꞌe. Laj sjisbeic ta sjol. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cꞌalal laj yoꞌntonic ta slabanele, tey laj slocꞌbeic ti stsajal cꞌuꞌe. Tey laj yacꞌbeic slap ti scꞌuꞌ onoꞌoxe. Tsꞌacal to un, laj yiqꞌuic batel yoꞌ ta sjipanic ta cruz. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cꞌalal ta xloqꞌuic xa batel yoꞌ ta sjipanic ta cruz ti Jesuse, jaꞌ o tey laj snupic ta be jun vinic ti liquem talel ta Cirene banomile, ti jaꞌ Simón sbie. Tey laj sujic ta xcuchel batel scruzal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tey icꞌotic ta jun vits, Gólgota sbi. Ti smelole, jaꞌ yavil ti sbaquil jolale. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Cꞌalal tey xa oyique, tey laj yacꞌbeic yuchꞌ ti Jesuse jun chꞌail pox ti capal ta hiele. Cꞌalal laj spas preva ti Jesuse, muꞌyuc bu laj yuchꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cꞌalal laj xa sjipanic ta cruz ti Jesuse, ti soldadoetique lic sqꞌuelic buchꞌu oy suerte yuꞌunic yoꞌ ta xvinaj buchꞌu junucal ta xichꞌbeic scꞌuꞌ ti Jesuse. Ti jech laj spasique, jaꞌ icꞌot ta pasel ti jech laj stsꞌiba comel ti jun jꞌalcꞌope: “Laj xchꞌacbe sbaic ti jcꞌuꞌe ti buchꞌu icꞌot yorail yuꞌunic junucal”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tsꞌacal to un, ti soldadoetique lic chotiicuc yoꞌ ta xchabiic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tey laj yacꞌbeic sletrail sjol scruzal ti ta xal ti cꞌu chaꞌal laj yichꞌ milele. Ti letrae jech ta xal: “Ti Jesús liꞌe, jaꞌ ti ajvalil yuꞌun ti jꞌisraeletique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jaꞌ jech xtoc laj yichꞌ jipanel ta cruz chaꞌvoꞌ jꞌeleqꞌuetic, jun ta sbatsꞌi cꞌob, jun ta stsꞌet cꞌob ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ti buchꞌutic ti tey xlaj echꞌicuque sjimolan xa sjolic ta xlabanvanic ti jech ta xalique: ");
INSERT INTO tzotzc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―Ti voꞌot ti ta xalilin ti temploe, ti ta yoxibal cꞌacꞌal ta xachaꞌvaꞌane, coltao quic aba atuc un. Mi voꞌot Snichꞌonot ti Diose, yalan talel ta cruz ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jaꞌ jech ta xlabanvanic ec ti banquilal paleetique, ti jchanubtasvanejetic yuꞌun ti mantale, ti jfariseoetique, ti moletique. Jech ta xalbe sbaic: ");
INSERT INTO tzotzc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Laj scoltaan ti yane, pero ti stuque mu xuꞌ yuꞌun scoltael sba. Ti mi jaꞌ ajvalil yuꞌun ti jꞌisraeletique, acꞌo yaluc talel ta cruz yoꞌ jech ta jchꞌuntic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yuꞌun xchꞌunoj ti jaꞌ jpojvanej yuꞌun ti Diose. Jech o xal, acꞌo coltaatuc yuꞌun ti Dios ti mi ta melel cꞌanbile. Yuꞌun laj xa yalbotic ti jaꞌ Snichꞌon ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jaꞌ jech xtoc ti chaꞌvoꞌ jꞌelecꞌ ti jipilic ta cruze ta xlabanvanic ec. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cꞌalal laj sta ti oꞌlol cꞌacꞌale, scotol ti banomile icꞌ icom. Ta oxib to ora mal cꞌacꞌal, isacub. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Cꞌalal jech ista ti oxib ora mal cꞌacꞌale, jaꞌ o tsots iꞌavan ti Jesuse: ―Elí, Elí, ¿lama sabactani? ―xi. “Dios cuꞌun, Dios cuꞌun, ¿cꞌu chaꞌal ti laj xa avictaun comel?” xi ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oy jlom ti tey oyique laj yaꞌiic ti jech iꞌavan ti Jesuse. Jech lic yalic: ―Ta xicꞌ talel ti jꞌalcꞌop Elíase ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Oy jun ta scotolic ibat ta anil. Ba stsꞌaj ta chꞌail pox ti esponjae. Tsꞌacal to laj xchuc ta niꞌ jichꞌel teꞌ ti esponjae. Tey laj stuch muyel yoꞌ ta xacꞌbe stsꞌutsꞌ ti Jesuse. Pero jech iꞌalbat yuꞌun ti yane: ");
INSERT INTO tzotzc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","―Chꞌan uto. Laꞌ jqueltic quic mi chtal coltaatuc yuꞌun ti Elíase ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yan to velta tsots lic avanuc ti Jesuse. Jaꞌ o tey icham. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti mucꞌ ta cortina ti oy ta temploe ijat. Lic tal sjatemal ta sjol cꞌalal to yoc. Chaꞌlic icom. Inic ti banomile. Laj javuc ti chꞌenetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ijam ti muquinaletique. Jaꞌ jech xtoc ichaꞌcuxiic ep ti buchꞌutic xchꞌunojic Dios ti cꞌalal ichamique. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ti buchꞌu ichaꞌcuxiique iloqꞌuic ta smuquinalic. Pero muꞌyuc bu iꞌochic ta ora ta chꞌul jteclum Jerusalén. Jaꞌ to tey iꞌochic batel ti cꞌalal ichaꞌcuxi xa ox ti Jesuse. Ep buchꞌutic laj yilic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ti banquilal soldadoe schiꞌuc ti soldadoetic ti ta schabiic ti Jesuse, cꞌalal laj yilic ti inic ti banomile, ti toj xiꞌbal sba ti cꞌusitic icꞌot ta pasele, ixiꞌic. Jech laj yalic: ―Melel, ti vinic liꞌe jaꞌ Snichꞌon Dios ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Oy ep antsetic ti ta nom vaꞌajtic ta sqꞌuelic ti icham ti Jesuse. Jaꞌic ti buchꞌutic stsꞌacliojic batel schiꞌuc laj scoltaic ti Jesús cꞌalal ixanav to ox ta Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ti ta scotol ti antsetique, tey oy ti María Magdalenae, schiꞌuc ti María ti jaꞌ smeꞌ ti Jacoboe schiꞌuc ti Josee, schiꞌuc smeꞌ ti snichꞌnabtac Zebedeoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cꞌalal ta xa xꞌicꞌube, jaꞌ o tal jun jcꞌulej vinic ti José sbie, ti liquem talel ta jteclum Arimateae. Jaꞌ jun vinic ti xchꞌunoj ti Jesús eque. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ti Josee ibat ta stojol ti Pilatoe yoꞌ ta scꞌanbe sbecꞌtal ti Jesuse. Ti Pilatoe laj yacꞌ ye ti xuꞌ ta xichꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jech o xal laj syales ta cruz ti Jesuse. Tey laj spix ta jun saquil pocꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tsꞌacal to un, ba sticꞌ ta achꞌ muquinal yuꞌun stuc ti Josee ti sjomoj ta tone. Tsꞌacal to tey laj smacbe comel ta jun mucꞌ ta ton ti ochebal stiꞌ ti muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jaꞌ jech xtoc tey chotolic ta nopol stiꞌ chꞌen ti María Magdalenae schiꞌuc ti yan Maríae. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cꞌalal echꞌ xa scꞌacꞌalil ta xchapan sbaic ta sventa ti cuxob oꞌntonale, ti banquilal paleetique schiꞌuc ti jfariseoetique bat scꞌoponic ti Pilatoe. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jech cꞌot yalbeic: ―Ajvalil, ivul ta coꞌntoncutic ti jech laj yal ti jutcꞌop vinic ti cꞌalal cuxul to oxe ti ta la xchaꞌcuxi ta yoxibal cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jech o xal tal calbotcutic ti acꞌo ba yichꞌ chabiel lec oxib cꞌacꞌal ti chꞌene, yoꞌ jech mu xtal yelcꞌanbeic loqꞌuel sbecꞌtal ta acꞌobaltic ti yajchancꞌoptaque. Yan ti mi laj yelcꞌanic loqꞌuele, xuꞌ ta xalbeic ti cristianoetique ti ichaꞌcuxi xae. Ti mi jech ta xcꞌot ta pasele, jaꞌ to más ep ta xlaj ta loꞌlael ti cristianoetique. Jaꞌ mu sta ti ta baꞌyel to oxe ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ti Pilatoe jech laj yal: ―Lec oy. Liꞌ oy cajsoldadotaque. Iqꞌuic batel. Acꞌo ba xchabiic lec ti tiꞌ chꞌen ti cꞌu yepal xuꞌ avuꞌunique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jech o xal tey ibatic, ba smacbe lec stiꞌ ti chꞌene. Tey laj yacꞌbeic señail ta smac ti stiꞌ chꞌene. Jaꞌ jech xtoc tey com xchabiic ti soldadoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cꞌalal echꞌ xa scꞌacꞌalil ti cuxob oꞌntonale, ti jutuc xa scꞌan sacub ti osil ti sliquebal cꞌacꞌal ti xemunae, jech ti María Magdalenae schiꞌuc ti yan Maríae bat sqꞌuelic ti muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta ora noꞌox inic ti banomile. Yuꞌun jaꞌ o iyal tal ta vinajel jun yajꞌángel ti Diose. Cꞌalal ivul ti bu mucul ti Jesuse, laj sloqꞌues ti mucꞌ ta ton ti jaꞌ smac ti tiꞌ chꞌene. Cꞌalal ilocꞌ yuꞌune, tey ichoti ta sba. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ti ángele coꞌol sꞌelan jech chac cꞌu chaꞌal jun sactselavel ti xjaplajet ti xojobale. Ti scꞌuꞌe sac ta jmec jech chac cꞌu chaꞌal ti saquil bote. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cꞌalal laj yilic ti soldadoetique, lic niquicuc ta xiꞌel, coꞌol sꞌelan chamem icomic. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jech ti ángele jech laj yalbe ti antsetique: ―Mu xaxiꞌic. Jnaꞌ ti jaꞌ ta xasaꞌic ti Jesuse ti jipil icham ta cruze. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Muꞌyuc xa liꞌe. Yuꞌun ichaꞌcuxi xa jech chac cꞌu chaꞌal ti laj yalboxuc onoꞌoxe. Laꞌ qꞌuelo avilic ti yavil ti bu to ox laj yaqꞌuic comele. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jech tal cal avaꞌiic liꞌe. Batanic ta ora, ba albeic ti yajchancꞌoptaque: “Ti Jesús ti ichame, chaꞌcuxi xa. Tey ta xavilic ta Galilea. Yuꞌun baꞌyel ta xcꞌot. Tsꞌacal to ta xacꞌotic ti voꞌoxuque”, xavut ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jech ti antsetique ta xiꞌel iloqꞌuic batel ta anil ta muquinal. Pero xmuyubajic xa xtoc. Ta ora bat yalbeic yaꞌi ti yajchancꞌoptaque ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta jech to yepal laj yacꞌ sba iluc ti Jesuse ta stojol ti antsetique. Tey cꞌot cꞌoponaticuc ti antsetique. Jech ti stuquique inopajic batel ta stojol ti Jesuse. Tey laj squejan sbaic. Laj smeybeic ti yoque. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jech ti Jesuse jech laj yal: ―Mu xaxiꞌic. Ba albeic yaꞌi ti quermanotaque ti acꞌo baticuc ta Galilea banomile. Tey ta xiyilicun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cꞌalal jech ta xanavic batel ti chaꞌvoꞌ antsetique, oy jun chib ti soldadoetique ibatic ta jteclum. Ba yalbeic yaꞌi ti banquilal paleetique scotol ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jech ti banquilal paleetique bat xchiꞌin ta loꞌil ti moletique yoꞌ ta scomonopic ti cꞌusi xuꞌ ta spasique. Jech o xal laj yacꞌbeic ep taqꞌuin ti soldadoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jech xtoc jech laj yalbeic: ―Ti voꞌoxuque jaꞌ me albeic yaꞌi ti cristianoetique: “Ti ta acꞌobaltique livaycutic. Muꞌyuc xcaꞌicutic ti tal ti yajchancꞌoptaque, tal sloqꞌuesbeic sbecꞌtal ti Jesuse”, chianic, xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ti mi laj yaꞌi ti ajvalil Pilatoe ti lavayique, mu xaxiꞌic. Vuꞌuncutic ta jpac acꞌoplalic yoꞌ jech mu xata avocolic ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jech o xal ti soldadoetique laj yichꞌic ti taqꞌuine. Jech bat yalic jech chac cꞌu chaꞌal ti ibijubtasatique. Jaꞌ jech ta xalolanic o ti jꞌisraeletic hasta ora liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jaꞌ jech ti buluchvoꞌ yajchancꞌoptaque tey ibatic ta Galilea banomil ta vits ti bu yaloj onoꞌox ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cꞌalal laj yilic ti Jesuse, tey lic squejan sbaic ta stojol. Laj yichꞌic ta mucꞌ, manchuc mi oy jun chib ti xnaꞌetique. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jech ti Jesuse inopaj talel ta stojolic ti jech laj yale: ―Ti vuꞌune liꞌacꞌbat xa ta coc ta jcꞌob scotol ti cꞌusitic oy ta vinajele, ti cꞌusitic oy ta banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jech o xal, batanic ta stojol scotol ti cristianoetic ti oyic ta jujun lum ti ta sjoylej banomile. Ba pasic ta cajchancꞌoptac. Acꞌbeic yichꞌ voꞌ ta sventa ti Jtotic Diose, ta jventa vuꞌun ti Snichꞌonilune, ta sventa ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chanubtasic ta spasel scotol ti cꞌusi laj xa calboxuc avaꞌiique. Naꞌic me lec ti tey jchiꞌinojoxuc scotol cꞌacꞌal cꞌalal to slajebal cꞌacꞌale ―xi ti Jesuse. Jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaꞌ jech sꞌelan ilic talel ti lequil achꞌ cꞌop yuꞌun ti Jesucristoe, Snichꞌon ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ti jꞌalcꞌop Isaíase jech laj stsꞌiba: Baꞌyel ta jtac jelavel ti cajꞌalcꞌop ta atojole yoꞌ jech ta smeltsan batel ti abee, xut Snichꞌon ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Oy buchꞌu tsots ta xꞌavan ta xocol banomil ti jech ta xale: “Meltsanbeic sbe ti Cajvaltique. Jambeic jun tuqꞌuil be”, ti xie, xi laj stsꞌiba ti Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jech o xal ital ti Juane. Tey ta xocol banomil ta xacꞌbe yichꞌic voꞌ ti cristianoetique. Ta xalbe ti acꞌo yictaic ti chopol yoꞌntonique, ti acꞌo yichꞌic voꞌe, yoꞌ jech ta staic perdón yuꞌun ti smulique. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ti cristianoetic ti oyic ta Judea banomile, ti oyic ta Jerusalene ibatic, ba yaꞌibeic scꞌop ti Juane. Ti buchꞌutic ta xal ti smulique ta xꞌacꞌbat yichꞌic voꞌ yuꞌun ti Juan ti tey ta ucꞌum Jordane. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Scꞌuꞌ ti Juane meltsanbil ta stsotsil camello. Nucul ti schuque. Ti sveꞌele, teꞌetical ajapom schiꞌuc cꞌulub. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ti Juane jech ta xalbe ti cristianoetique: ―Oy Buchꞌu tsꞌacal to ta xtal ta jtojol ti jaꞌ más to xuꞌ yuꞌune. Jaꞌ mu sta ti vuꞌune. Mi jaꞌuc xuꞌ ta jcujan jba ta sjitunbel ti yaqꞌuil xonobe. Muꞌyuc jlequilal ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ti vuꞌune voꞌ noꞌox ta xcacꞌ avichꞌic. Pero ti Buchꞌu ta to xtale jaꞌ ta xacꞌboxuc avichꞌic ti Chꞌul Espíritue ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ti jech yorail taje, jaꞌ o ilocꞌ talel ti Jesús ti ta jteclum Nazaret ti oy ta Galilea banomile. Tey iꞌacꞌbat yichꞌ voꞌ yuꞌun ti Juan ti ta ucꞌum Jordane. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cꞌalal ilocꞌ ta voꞌ ti Jesuse, laj yil ti jamal ti vinajele. Ti Chꞌul Espíritue tey iyal tal ta stojol coꞌol sꞌelan jcot paloma. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jaꞌ jech xtoc oy Buchꞌu icꞌopoj talel ta vinajel ti jech ta xale: ―Voꞌot ti jcꞌuxubinbil Nichꞌonote. Ximuyubaj xa ta atojol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tsꞌacal to un, icꞌbil ibat yuꞌun Chꞌul Espíritu ta xocol banomil. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ti Jesuse tey oy chaꞌvinic (40) cꞌacꞌal, chaꞌvinic (40) acꞌobal ti ta xocol banomile. Jaꞌ noꞌox chonetic tey oy. Ti pucuje tal slajeltsabe yoꞌnton. Pero ital coltaatuc yuꞌun ti yajꞌángeltac ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cꞌalal tiqꞌuil xa ta chuquel ti Juane, jech ti Jesuse ibat ta Galilea banomil ta yalel ti lequil achꞌ cꞌop yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ti Jesuse jech ta xal: ―Sta xa yorail ti ta xventainvan ti Diose. Ictaic ti chopol avoꞌntonique. Chꞌunic ti lequil achꞌ cꞌop ti jaꞌ colebale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ti Jesuse cꞌalal jech ta xanav batel ta stiꞌil nab Galileae, jaꞌ o laj yil ti Simone schiꞌuc ti yitsꞌin ti jaꞌ Andrese. Jaꞌ yabtelic ti tsac choye. Tey ta sjipic ochel ta voꞌ ti stsacobil schoye. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ti Jesuse jech laj yalbe: ―Batic, chiꞌinicun batel. Ta xcacꞌboxuc yan avabtelic. Jaꞌ ta xaviqꞌuic talel ti cristianoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta ora noꞌox laj yictaic comel ti stsacobil schoyique. Ibatic schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ixanav batel jutuc ti Jesuse. Tey laj yil ti Jacoboe schiꞌuc ti Juane, ti jaꞌ snichꞌnab ti Zebedeoe. Tey oyic ta barco ta stsꞌisic ti stsacobil schoyique. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","―Laꞌic ―xut. Jech ti stuquique laj yictaic comel ti stotic Zebedeo ta barcoe schiꞌuc ti svinictaque. Ibatic schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tey icꞌotic ta jteclum Capernaum. Cꞌalal scꞌacꞌalil ti cuxob oꞌntonale, ti Jesuse iꞌoch batel ta chꞌul na. Tey lic chanubtasvanuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ti cristianoetique elom ta xaꞌiic ti cꞌu sꞌelan ta xchanubtasvane. Yuꞌun ta xacꞌ ta ilel ti tsots yabtel yichꞌoje. Mu xcoꞌolaj schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti tey ta chꞌul na ti oy ta jteclume, oy jun vinic ti uninbil yuꞌun ti pucuje. Tey tsots lic avanuc: ");
INSERT INTO tzotzc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Cꞌu chaꞌal ta xaticꞌ aba ta jtojolcutic, Jesús, ti liquemot tal ta Nazarete? ¿Mi yuꞌun tal xa avacꞌbuncutic vocol? Yuꞌun xacojtiquinot. Jnaꞌoj lec ti tꞌujbilot yuꞌun ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ti Jesuse jech laj stacꞌ: ―Chꞌan chan. Ictao comel ti vinic liꞌe ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jech ti pucuje laj sjip ta lum ti vinique jech chac cꞌu chaꞌal junuc jtub-icꞌ. Tsots iꞌavan. Tey ilocꞌ batel ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Scotolic ixiꞌic. Jech lic sjacꞌbe sbaic: ―¿Cꞌusi leꞌe? Sba to velta laj quiltic. Ti vinic leꞌe oy yabtel ta spas ta mantal ti pucuje. Ta xchꞌunbat ti scꞌope ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta ora noꞌox ivinaj scꞌoplal ti Jesús ta sjunul Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cꞌalal iloqꞌuic batel ta chꞌul nae, jech ti Jesuse ibat schiꞌuc ti Juane schiꞌuc ti Jacoboe ta snaic ti Simone schiꞌuc ti Andrese. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ti smeꞌniꞌ ti Simone puchꞌul ta tem ta xaꞌi cꞌocꞌ. Laj yalbeic yaꞌi ti Jesuse ti ip ta xaꞌie. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jech o xal ti Jesuse ibat ti bu puchꞌul ti jchamele. Bat snitbe liquel scꞌob yoꞌ acꞌo vaꞌiuc. Ta jech to yepal iꞌechꞌ ti scꞌacꞌale. Jech ti stuque lic smeltsan veꞌlil. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cꞌalal ta xa xchꞌay ti cꞌacꞌale, tey laj yiqꞌuic talel ta stojol Jesús scotol ti jchameletique schiꞌuc ti buchꞌutic uninbilic yuꞌun ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Scotolic laj stsob sbaic ta tiꞌ na. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ti Jesuse laj scoles ep jchameletic ti cꞌusiuc noꞌox chamelal ta xaꞌiique. Jaꞌ jech xtoc laj stac loqꞌuel ti pucujetique. Ti Jesuse mu xacꞌ cꞌopojuc ti pucujetique, yuꞌun snaꞌic ti Buchꞌu ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yamal osil to ilocꞌ batel ta stiꞌil jteclum ti Jesuse. Bat ti bu stsꞌijlan ti banomile yoꞌ jech ta sta ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ti Simone schiꞌuc ti schiꞌiltaque bat saꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cꞌalal laj staique, jech laj yalbeic: ―Scotolic ta xasaꞌot ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ti Jesuse jech laj stacꞌ: ―Batic ta jujun jteclum ti liꞌ nopole. Ba caltic ti lequil achꞌ cꞌop tey xtoque. Yuꞌun jaꞌ cabtel lital ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jech o xal ti Jesuse lic xanavuc ta sjunul banomil Galilea. Ta xalolan ti lequil achꞌ cꞌop ta jujun chꞌul nae. Jaꞌ jech xtoc ta stacan loqꞌuel ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tey inopaj bal ta stojol Jesús jun vinic ti tsacbil ta cꞌaꞌemal chamele. Tey laj squejan sba. Jech laj yal: ―Ti xacꞌanuque, xuꞌ ta xcol avuꞌun ti jchamele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ti Jesuse icꞌuxubaj yoꞌnton. Laj scajan scꞌob ta sba ti jchamele. Jech laj yal: ―Ta jcꞌan ta xacol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cꞌalal jech laj yale, muꞌyuc xvinaj bu ibat ti cꞌaꞌemal chamele. Lec icom. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ti Jesuse jech laj yalbe: ―Lec oy. Batan. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Pero ta jcꞌubanbot ti mu me buchꞌu xavalbe yaꞌie. Jaꞌ noꞌox ba acꞌo aba iluc ta stojol ti palee. Acꞌbo me smoton ti Diose ti jech lacol xae jech chac cꞌu chaꞌal laj yal ti Moisese, yoꞌ jech scotolic ta snaꞌic ti col xa ti achamele ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ti vinique ibat. Lic yalolan ti cꞌu sꞌelan icole. Jech o xal ti Jesuse mu xuꞌ xꞌoch batel ta jujun jteclum ta sba ta sat ti cristianoetique. Jaꞌ noꞌox xuꞌ ta xanav ti bu chꞌabale. Pero ta xtal qꞌuelatuc yuꞌun ti cristianoetic ti buꞌyuc noꞌox ta xlic talele. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cꞌalal iꞌechꞌ chib oxib cꞌacꞌale, tey ichaꞌsut batel yan velta xtoc ta Capernaum jteclum ti Jesuse. Ivinaj scꞌoplal ti tey oy ta jun nae. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta ora noꞌox laj stsob sbaic ti epal cristianoetique. Mi jaꞌuc xa xuꞌ xꞌochic ta tiꞌ na. Ti Jesuse tey ta xal ti lequil achꞌ cꞌop yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tey ibatic chanvoꞌ viniquetic ti spoyojic batel jun jchamel vinic ti pasem ta mochꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ta scoj ti mu xjelavic ochel ti bu oy ti Jesuse, jech o xal ti chanib viniquetique tey imuyic batel ta jol na. Laj sjomic juteb jol na yoꞌ bu stuqꞌuil ti Jesuse. Laj xchechic yalel ta chꞌojon schiꞌuc svayeb ti jchamele. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ti Jesuse cꞌalal laj yil ti xchꞌunojic ti xuꞌ ta xcoltavane, jech laj yalbe ti jchamele: ―Nichꞌon, chꞌaybil amul ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Oy tey chotolic jun chib jchanubtasvanejetic yuꞌun ti mantale. Jech lic snop ta yoꞌntonic: ");
INSERT INTO tzotzc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Cꞌu chaꞌal jech ta xal ti vinic liꞌe? Ta xchopol-cꞌopta ti Diose. Yuꞌun muꞌyuc buchꞌu junucal ti ta xacꞌ perdón yuꞌun ti mulile. Jaꞌ noꞌox Dios xuꞌ ta xacꞌ ti perdone”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ti Jesuse snaꞌoj ti jech ta snopique. Jech lic yal: ―¿Cꞌu chaꞌal ti jech ta xanopique? ");
INSERT INTO tzotzc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cꞌusi ti más lec ta alele? ¿Mi jaꞌ ti chꞌaybil amul ti xie? ¿Mi jaꞌ ti lican, vaꞌlan, ichꞌo batel ti atem ti xie? ");
INSERT INTO tzotzc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lec oy, ti vuꞌun coꞌol jꞌelantique ta xcacꞌboxuc avilic ti quichꞌoj cabtel liꞌ ta banomile ti xuꞌ ta xcacꞌ perdón yuꞌun ti mulile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Jech o xal ti Jesuse jech laj yalbe ti jchamel vinique: ―Ti voꞌote ta xcalbot avaꞌi, lican, vaꞌlan. Balo batel atem. Batan ta ana ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cꞌalal jech laj yal ti Jesuse, ta ora noꞌox ivaꞌi ti jchamel vinique. Laj sbal ti steme. Ilocꞌ batel ta sba ta sat scotolic. Jech o xal ti cristianoetique toj elom laj yaꞌiic. Lic lequil cꞌopojicuc ta stojol ti Diose. Jech laj yalic: ―Mu bacꞌniuc xquiltic jech liꞌe ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsꞌacal to ti Jesuse bat yan velta ta stiꞌil nab. Cꞌalal ep icꞌot ti cristianoetic ta stojole, tey lic xchanubtas. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cꞌalal ixanav batel ti Jesuse, tey laj yil ti Levie, ti jaꞌ snichꞌon ti Alfeoe. Tey chotol ti bu ti tojob patane. Ti Jesuse jech laj yal: ―Batic ―xut. Jech ti Levie ivaꞌi, laj xchiꞌin batel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsꞌacal to ti Jesuse tey bat veꞌuc ta sna ti Levie. Ep ti jcꞌanpatantaqꞌuinetique schiꞌuc ti jsaꞌmuliletique jmoj chotolic ta mexa ta xveꞌic schiꞌuc ti Jesuse schiꞌuc ti yajchancꞌoptaque. Yuꞌun ep ta jmec ti buchꞌutic ti tsꞌacliic batele. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ti jchanubtasvanejetic yuꞌun ti mantale schiꞌuc ti jfariseoetique, cꞌalal laj yilic ti Jesús ti jmoj ta xveꞌic schiꞌuc ti jsaꞌmuliletique, jech lic yalbeic ti yajchancꞌoptaque: ―¿Cꞌu chaꞌal ti jmoj ta xveꞌic ti jchanubtasvanej avuꞌunique schiꞌuc ti jcꞌanpatantaqꞌuinetique schiꞌuc ti jsaꞌmuliletique? ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cꞌalal jech laj yaꞌi ti Jesuse, jech laj yal: ―Ti buchꞌutic muꞌyuc schamelique mu scꞌanic jpoxtavanej. Pero ti buchꞌutic oy schamelique ta scꞌanic ti jpoxtavaneje. Ti vuꞌune maꞌuc tal jsaꞌ ti buchꞌu lequique. Jaꞌ tal jsaꞌ ti buchꞌu jsaꞌmuliletique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Oy bu laj yicta yotic ti yajchancꞌoptac ti Juane schiꞌuc ti yajchancꞌoptac ti jfariseoetique. Jech o xal oy jun chib viniquetic ibatic ta stojol ti Jesuse ti jech laj sjacꞌbeique: ―¿Cꞌu chaꞌal ta xicta yotic ti yajchancꞌoptac ti Juane schiꞌuc ti yajchancꞌoptac ti jfariseoetique, pero ti avajchancꞌoptaque muꞌyuc ta xicta yotic? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ti Jesuse jech laj stacꞌbe: ―Cꞌalal icꞌbilic ta sqꞌuelic ti nupunele, ¿mi xuꞌ van ta xicta yotic cꞌalal tey schiꞌuquic ti jnupunele? ");
INSERT INTO tzotzc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero oy bu ta sta scꞌacꞌalil ti ta xꞌicꞌat batel ti jnupunele. Jaꞌ to ta xlic yicta ti yotique. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jaꞌ jech xtoc muꞌyuc buchꞌu ta spacꞌan ta achꞌ manta ti pocoꞌ cꞌuꞌile. Yan ti mi jech ta spasique, cꞌalal ta smuts ti achꞌ mantae, yantic xjatolaj bal ti pocoꞌ cꞌuꞌile. Ta xmuqꞌuib más ti sjatemale. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jaꞌ jech xtoc ti achꞌ yaꞌlel uvae, muꞌyuc buchꞌu ta sticꞌ ta spocoꞌ-avil. Yan ti mi jech ta spasique, cꞌalal xlic pajubuc ti yaꞌlel uvae, jech xlic stꞌomes ti spocoꞌ-avile. Tey ta xchꞌay ti yaꞌlel uvae. Ta xchꞌay ti yavil xtoque. Ti achꞌ yaꞌlel uvae ta xichꞌ tiqꞌuel ta jun achꞌ yavil ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cꞌalal jaꞌ o scꞌacꞌalil cuxob oꞌntonale, ti Jesuse tey ixanav batel schiꞌuc ti yajchancꞌoptaque ti bu tsꞌunul ti trigoe. Ti yajchancꞌoptaque tey laj stoquic batel ti trigoe, yoꞌ ta sjuꞌ xcꞌuxic. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jech ti jfariseoetique jech laj yalbeic: ―¿Cꞌu chaꞌal ta xꞌabtejic ti avajchancꞌoptaque ti cꞌalal mu xuꞌ jech ta jpastic ta scꞌacꞌalil cuxob oꞌntonale? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ti Jesuse jech laj yal: ―¿Mi yuꞌun muꞌyuc avilojic ti scꞌop Diose ti cꞌusi laj spas ti Davide schiꞌuc ti schiꞌiltac cꞌalal ta xlajic xa ta viꞌnale? ");
INSERT INTO tzotzc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ti Davide och batel ta templo yuꞌun ti Diose cꞌalal jaꞌ o ochem ta banquilal pale ti Abiatare. Jech ti Davide laj stsac ti chꞌul pane yoꞌ jech ta sveꞌ schiꞌuc ti svinictaque, ti cꞌalal jaꞌ noꞌox xuꞌ ta sveꞌic ti paleetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jech xtoc ti Jesuse jech laj yal: ―Ti cuxob oꞌntonale, maꞌuc nopbil yuꞌun Dios ti ta xchuc sba ti vinic yuꞌun ti scꞌacꞌalil cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jaꞌ jech xtoc ti vuꞌun coꞌol jꞌelantique quichꞌoj cabtel ti xuꞌ ta xcal ti cꞌusi stacꞌ pasel ta scꞌacꞌalil cuxob oꞌntonale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ti Jesuse iꞌoch bal yan velta ta chꞌul na. Tey oy jun vinic ti pasem ta mochꞌ ti jun scꞌobe. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ti jfariseoetique spaꞌiojic ti mi ta scolta ti jchameletic ta scꞌacꞌalil cuxob oꞌntonale, yoꞌ jech ta saꞌbeic ti smule. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ti Jesuse jech laj yalbe ti pasem ta mochꞌ ti scꞌobe: ―Lican. Laꞌ vaꞌan aba ta oꞌlol ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ti Jesuse tey lic sjacꞌbe ti jfariseoetique: ―¿Cꞌusi xuꞌ ta jpastic ta scꞌacꞌalil ti cuxob oꞌntonale? ¿Mi jaꞌ ti leque? ¿Mi jaꞌ ti chopole? ¿Mi jaꞌ lec ti ta xijcoltavane? ¿Mi jaꞌ lec ti ta xijmilvane? ―xi. Pero ti stuquique tsꞌijil icomic. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ti Jesuse ta il laj sqꞌuelbe batel sat ti jfariseoetique. Jaꞌ jech xtoc iꞌoch ta at oꞌnton ta scoj ti mu xaꞌibeic schiquinale. Jech laj yalbe ti vinique: ―Xachꞌo tal ti acꞌobe ―xi. Cꞌalal laj xachꞌ ti scꞌobe, lec icom. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jech ti jfariesoetique iloqꞌuic batel, bat scomonopic schiꞌuc svinictac ti Herodese ti cꞌuxi xuꞌ ta smilic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pero ti Jesuse tey ibat schiꞌuc ti yajchancꞌoptac ta stiꞌil nab Galilea. Jech xtoc ep cristianoetic tijilic batel ta spat. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cꞌalal laj yaꞌiic ti tsots xuꞌ yuꞌun ti Jesuse, ep laj talicuc yoꞌ jech ta sqꞌuelic. Oy buchꞌutic ti liquemic tal ta Judea banomile, ti liquemic tal ta Jerusalene, ti liquemic tal ta Idumea banomile, ti liquemic tal ta sloqꞌueb cꞌacꞌal ti ta jot ucꞌum Jordane, ti liquemic tal ta Tiro schiꞌuc ti Sidone. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jech o xal ti Jesuse laj yalbe yaꞌi ti yajchancꞌoptaque ti acꞌo xchapanic jun barco yoꞌ ta xꞌoch batel ti Jesuse, yoꞌ jech mu xnetꞌat yuꞌun ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Cꞌalal laj xa scolta ti epal jchameletique, pero yac to ta talel yan yoꞌ jech ta spiquic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jech ti pucujetic ti yuꞌninoj ti cristianoetique, ti cꞌalal ta xilic ti Jesuse, ta squejan sbaic ta stojol. Jech ta xꞌavanic: ―Voꞌot Snichꞌonot ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ti Jesuse tsots laj yalbe ti pucujetique ti mu me xalic ti jaꞌ Snichꞌon Dios ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsꞌacal to tey imuy batel ta vits ti Jesuse. Laj yicꞌ batel ti buchꞌutic ta scꞌan ta stꞌuj stuque. Jech italic ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jaꞌ o laj svaꞌan lajchaꞌvoꞌ yoꞌ ta stac batel ta yalel ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ti Jesuse laj yacꞌbe yabtelic ta scolesel ti jchameletique schiꞌuc ta sloqꞌuesel ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ti lajchaꞌvoꞌique jaꞌ jech ti sbiique: Ti Simone (Pedro iꞌacꞌbat sbi yuꞌun ti Jesuse.) ");
INSERT INTO tzotzc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ti Jacoboe, ti Juane (Jaꞌ snichꞌnab ti Zebedeoe. Boanerges iꞌacꞌbatic sbiic. Jbel xcꞌopojic, xi ti smelole.) ");
INSERT INTO tzotzc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ti Andrese Ti Felipee Ti Bartolomee Ti Mateoe Ti Tomase Ti Jacoboe (Jaꞌ snichꞌon ti Alfeoe.) Ti Tadeoe Ti Simone (Jaꞌ ti ochem to ox ta partido cananista.) ");
INSERT INTO tzotzc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ti Judas Iscariotee (Jaꞌ ti buchꞌu tsꞌacal to laj yacꞌ ta cꞌabal ti Jesuse.) Tsꞌacal to ti Jesuse och batel ta jun na schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yan velta xtoc ep laj stsob sbaic ti cristianoetic ti bu oye. Mu xa xuꞌ xꞌacꞌat veꞌicuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cꞌalal laj yaꞌiic ti yutsꞌ yalaltac ti Jesuse, italic yoꞌ ta xiqꞌuic batel. Yuꞌun laj snopic ti pas xa ta chuvaje. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jaꞌ jech xtoc ti jchanubtasvanejetic yuꞌun ti mantale ti liquemic tal ta Jerusalene, jech ta xalic: ―Ti vinic leꞌe yichꞌojbe stsatsal ti Beelzebue, ti jaꞌ banquilal yuꞌunic ti pucujetique. Jech o xal ta stsatsal Beelzebu ta sloqꞌues ti pucujetique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ti Jesuse lic yicꞌ talel ti jchanubtasvanejetic yuꞌun ti mantale. Jech lic yal jun babacꞌop: ―¿Cꞌusi xut ta sloqꞌues sbaic ti schiꞌil sbaic ta pucujale? ");
INSERT INTO tzotzc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ti mi ta scrontain sbaic jun ajvalil schiꞌuc ti schiꞌiltac ta abtele, mu xuꞌ jal ta spasic mantal. Tey ta soquic o. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jaꞌ jech xtoc ti mi ta scrontain sbaic ti yajvaltac jun nae, tey ta soquic ti yajval nae. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jaꞌ jech xtoc ti mi ta scrontain sba stuquic ti pucujetique, mu xuꞌ jal ta spasic mantal. Jaꞌ noꞌox ta slilin sba stuquic. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Yoꞌ jech xuꞌ ta xpojbat ti cꞌusi oy ta sna ti jun tsatsal vinique, jaꞌ noꞌox ti mi baꞌyel ta xchucbat yoc scꞌobe. Jech xuꞌ ta xpojbat batel ti cꞌusi oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ta melel ta xcalboxuc avaꞌiic, ti buchꞌutic chopol ti cꞌusi ta spasique schiꞌuc ti chopol ta xcꞌopojic ta stojol ti Diose, xuꞌ ta xꞌacꞌbatic perdón. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero ti buchꞌutic ti chopol ta xcꞌopojic ta stojol ti Chꞌul Espíritue, mu xa ta xꞌacꞌbatic perdón. Oy o smul sbatel osil ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jaꞌ jech laj yal ti Jesuse, jaꞌ ti ta xꞌalbat ti yichꞌojbe stsatsal ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsꞌacal to tey icꞌotic ti smeꞌe schiꞌuc ti yitsꞌinabtaque ti bu oy ti Jesuse. Pero tey icomic ta pana. Tey laj staic ta iqꞌuel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ti buchꞌutic jmoj chotajtic schiꞌuc ti Jesuse jech lic yalic: ―Ti ameꞌe schiꞌuc ti avitsꞌinabtaque tey oy ta pana. Ta saꞌot ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero ti Jesuse jech laj stacꞌ: ―¿Buchꞌu ti jmeꞌe? ¿Buchꞌu ti quitsꞌinabe? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ti Jesuse xcholet laj sqꞌuel batel ti buchꞌu tey chotolique. Jech lic yal: ―Ti jmeꞌe, ti quitsꞌinabe, jaꞌic ti buchꞌutic liꞌ chotajtique. ");
INSERT INTO tzotzc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yuꞌun buchꞌuuc noꞌox ti ta spasic ti cꞌusi scꞌan ti Diose, jaꞌ jmeꞌ, jaꞌ jvixobtac, jaꞌ quitsꞌinabtac ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yan velta lic chanubtasvanuc ta tiꞌ nab ti Jesuse. Ep ti cristianoetic laj stsob sbaic batel ti bu oye. Ti jech ep ta jmec ti cristianoetique, jech o xal ti Jesuse iꞌoch bal ta barco ti tey onoꞌox oy ta tiꞌ nabe. Tey ichoti. Ti epal cristianoetique icomic ta stiꞌil nab. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ep ta tos ti cꞌusi ichanubtasvan ta babacꞌope. Jech lic yal: ");
INSERT INTO tzotzc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Aꞌyio avaꞌiic liꞌe. Ilocꞌ batel jun jtsꞌunobajel vinic, bat tsꞌunubajuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cꞌalal yacal ta stsꞌunubaj batele, oy jlom tsꞌunobal icꞌot ta be. Tey ital ti mutetique. Laj stamic. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oy jlom cajal icꞌot ta ba tontic ti bu joy ti slumale. Ti tsꞌunobale ta ora noꞌox ivocꞌ. Jaꞌ ti muꞌyuc nat mucule. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Cꞌalal iqꞌuixnaj tal ti cꞌacꞌale, lic nucultajuc. Ta scoj ti chꞌabal lec stsꞌunoj ti yibele, tey itaquij. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oy jlom icꞌot ta yoc chꞌixtic. Cꞌalal ichꞌi talel ti chꞌixe, laj snetꞌ comel ti tsꞌunobale. Muꞌyuc isatin. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oy jlom icꞌot ta lequil banomil. Tey ivocꞌ talel. Lic chꞌiuc. Lec laj yacꞌ sat. Oy jlom laj yacꞌ lajuneb schaꞌvinic (30) ta bej ti sate. Oy jlom laj yacꞌ oxvinic (60) ta bej ti sate. Oy jlom laj yacꞌ voꞌvinic (100) ta bej ti sate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jech laj yal xtoc ti Jesuse: ―Ti buchꞌu oy schiquine, acꞌo me yaꞌibeic lec smelol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cꞌalal stuc xa com ti Jesús schiꞌuc ti lajcheb yajchancꞌoptaque schiꞌuc ti buchꞌutic scotol cꞌacꞌal ta xchiꞌinvanique, lic sjaqꞌuic ti cꞌusi ta xacꞌ ta naꞌel ti babacꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ti Jesuse jech laj yal: ―Dios ta xacꞌboxuc anaꞌic smelol ti ventainel ti mucul to oxe. Yan ti buchꞌutic ta sbajic ti ventainele, ta babacꞌop noꞌox ta xꞌalbatic, ");
INSERT INTO tzotzc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yoꞌ jech mu xilic ti cꞌalal ta xilique, yoꞌ jech mu xaꞌiic ti cꞌalal ta xaꞌiique, yoꞌ jech staoj yav ti chopol yoꞌntonique yoꞌ jech mu staic perdón yuꞌun ti smulique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ti Jesuse jech lic yal xtoc: ―Mi mu xavaꞌibeic smelol ti vaꞌi sꞌelan laj jbabaꞌale, ¿cꞌusi ta xavutic ta xavaꞌibeic smelol ti yan cꞌop ti ta jbabaꞌale? ");
INSERT INTO tzotzc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ti jtsꞌunobajel vinique coꞌol sꞌelan jech chac cꞌu chaꞌal ti buchꞌu ta xal ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Oy jlom cristianoetic coꞌol sꞌelanic jech chac cꞌu chaꞌal ti tsꞌunobal ti icꞌot ta bee. Ta xaꞌiic ti lequil achꞌ cꞌope. Pero ta xtal ta stojolic ti pucuje. Ta xchꞌaybat ta yoꞌntonic ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oy jlom cristianoetic coꞌol sꞌelanic jech chac cꞌu chaꞌal ti tsꞌunobal ti icꞌot ta ba tontique. Ta xaꞌiic ti lequil achꞌ cꞌope. Xmuyubajic xa ta xchꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero muꞌyuc yip yoꞌntonic. Jech o xal un, cꞌalal ta xcꞌot ta stojolic ti lajeltsaele, ti ilbajinel ta sventa ti scꞌop Diose, ta xchibaj yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Oy jlom cristianoetic coꞌol sꞌelanic jech chac cꞌu chaꞌal ti tsꞌunobal ti icꞌot ta yoc chꞌixtique. Ta xaꞌiic ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero ta xbat yoꞌntonic yuꞌun ti cꞌusitic ta scꞌanic liꞌ ta banomile. Ta xloꞌlabat yoꞌntonic yuꞌun ti cꞌulejale. Ta xlic scꞌanic ti cꞌusiuc noꞌox oy liꞌ ta sba banomile. Jech o xal un, ta xchꞌay ta yoꞌntonic ti lequil achꞌ cꞌop ti cꞌu xa ox yepal laj yaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Oy jlom cristianoetic coꞌol sꞌelanic jech chac cꞌu chaꞌal ti tsꞌunobal ti icꞌot ta lequil banomile. Ti jlome ta sjunul yoꞌntonic ta xichꞌic ta mucꞌ ti lequil achꞌ cꞌope. Ti cristianoetic taje coꞌol sꞌelanic jech chac cꞌu chaꞌal ti tsꞌunobal ti oy bu laj yacꞌ sat ta lajuneb schaꞌvinic (30), ta oxvinic (60), ta voꞌvinic (100) ta bej sat ti jujupets ti tsꞌunobale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ti Jesuse jech lic yal xtoc: ―Muꞌyuc buchꞌu ta stsan jun lampara yoꞌ chba snacꞌ ta yolon cajon, o mi ta yolon tem. Moꞌoj, cꞌalal mi laj stsan ti lamparae, ta scajan ta toyol yoꞌ jech ta xacꞌ xojobal. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ti cꞌusi nacꞌal to oxe, mu yuꞌunuc jech nacꞌal ta xcom o. Ta xichꞌ vinajesel. Ti cꞌusi macal to oxe, mu jechuc macal ta xcom o. Ta xichꞌ aꞌibel smelol. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ti voꞌoxuc ti oy achiquinique, aꞌyic lec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ti Jesuse jech lic yal xtoc: ―Ti voꞌoxuque tsꞌetano achiquinic ta yaꞌyiel ti cꞌusi ta xavaꞌiique. Ti cꞌu sꞌelan ta xavaꞌiique, jaꞌ jech yepal ta xataic. Pero maꞌuc noꞌox. Ta to xaꞌacꞌbatic más yuꞌun ti Dios ti cꞌusi ta xavaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yuꞌun ti buchꞌu ta sjunul yoꞌnton ta xaꞌie, ta xꞌacꞌbat más. Pero ti buchꞌu mu sjunuluc yoꞌnton ta xaꞌie, ta xpojbat ti juteb xchꞌunoje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ti Jesuse jech lic yal xtoc: ―Ti ventainel yuꞌun ti Diose coꞌol sꞌelan jech chac cꞌu chaꞌal cꞌalal ta stsꞌunobaj ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chbat vayuc. Tsꞌacal to ta xlic. Jaꞌ jech ta xꞌechꞌolaj ti cꞌacꞌal acꞌobal yuꞌune. Jech ti tsꞌunobale ta xvocꞌ talel. Ta xchꞌi. Pero ti stuque mu snaꞌ cꞌu sꞌelan ta xchꞌi talel. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jaꞌ yabtel stuc ti banomile. Jech o xal un, baꞌyel ta xlocꞌ talel ti yanale. Tsꞌacal to un, ta xacꞌ sat. Tsꞌacal to ta xyijub. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cꞌalal mi yijub ti tsꞌunobale, jaꞌ o ta xlocꞌ batel stsobel. Jaꞌ ti sta xa yorail ti ta xichꞌ tsobele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ti Jesuse jech lic yal xtoc: ―¿Cꞌu sꞌelan ta jcoꞌoltastic ti ventainel yuꞌun ti Diose? ¿Cꞌusi babacꞌopal ta jcoꞌoltastic o? ");
INSERT INTO tzotzc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Coꞌol sꞌelan jbej ta uni becꞌ mostaza ti ta xichꞌ tsꞌunele. Ti uni becꞌ mostazae, jaꞌ ti más biqꞌuit ta scotol ti tsꞌunobal ti oy ta banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mi laj yichꞌ tsꞌunele, ta xchꞌi talel. Más to mucꞌ ta xbat. Jaꞌ mu sta ti yan tsꞌunobale. Jaꞌ jech xtoc mucꞌtic ta xbat ti scꞌobtaque. Jech o xal ti mutetique xuꞌ ta xluchi ta scꞌobtac yoꞌ ta xcux yoꞌntonic ta yaxinal ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ti Jesuse ta babacꞌop noꞌox ta xchanubtas ti cristianoetique. Pero jaꞌ noꞌox laj yal ti bu cꞌalal xuꞌ ta xaꞌibeic ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti cꞌalal ta xchanubtasvane, puro noꞌox ta babacꞌop ta xal. Ti cꞌalal stuquic xa schiꞌuc ti yajchancꞌoptaque, tey ta xalbe scotol smelol ti babacꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cꞌalal iꞌoch acꞌobal ti jech cꞌacꞌal taje, ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Batic ta jot stiꞌil nab ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jech o xal ti yajchancꞌoptaque laj yictaic comel ti cristianoetic ti oyic ta stiꞌil nabe. Iꞌochic batel ta barco ti yoꞌ bu chotol onoꞌox ti Jesuse. Tey jmoj ibatic schiꞌuc yan barcoetic. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jaꞌ o tey ital tsots icꞌ. Ti syucꞌbenal ti voꞌe chlaj ochanuc ta barco. Ta xa xnoj ta voꞌ ti barcoe. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti Jesuse sjunul yoꞌnton tey vayal batel tey ta patil yacꞌoj lec xoncol. Ti yajchancꞌoptaque bat stijic talel. Jech laj yalic: ―Jchanubtasvanej, ¿mi mu aventauc ti ta xijmutꞌijotique? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jech ti Jesuse ilic. Jech laj yal: ―Tsꞌijlan ―xut ti iqꞌue. ―Chꞌan chan, tsꞌijlan ―xut ti nabe. Tey paj ti iqꞌue. Stsꞌijlan icom scotol. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jech ti Jesuse tey lic yalbe ti yajchancꞌoptaque: ―¿Cꞌu chaꞌal ep ta xaxiꞌic? ¿Cꞌu chaꞌal ti mu xachꞌunicun? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ti stuquique ochem xiꞌel ta yoꞌntonic. Tey lic sjacꞌbe sbaic ta jujun tal: ―¿Buchꞌu liꞌe ti ta xchꞌunbat scꞌop yuꞌun ti iqꞌue, yuꞌun ti nabe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ti Jesuse schiꞌuc ti yajchancꞌoptaque tey icꞌotic ta jot stiꞌil nab ta yosilal Gadara. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cꞌalal jech ilocꞌ batel ta barco ti Jesuse, ital ta stojol jun vinic ti uninbil yuꞌun ti pucuje, ti ilocꞌ tal ta ba muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yuꞌun ti vinic taje jaꞌ snainoj ti ba muqinale. Muꞌyuc buchꞌu junuc ti xuꞌ ta stsac yuꞌunique, manchuc mi ta xchuquic ta cadena. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Oy bu ep ta velta ti laj xchucbeic ta cadena taqꞌuin ti yoc scꞌobe, pero naca xtuchꞌel yuꞌun. Muꞌyuc buchꞌu xuꞌ ta stsalat. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cꞌacꞌal acꞌobal xꞌavet ta xanav ti ta vitsetique, ti tey ta muquinale. Ta syayijes sba ta tontic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cꞌalal laj yil ta nom ti Jesuse, ta anil ibat squejan sba ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tey lic yavta: ―Jesús, Snichꞌonot ti Dios ti oy ta cajale, mu xaticꞌ aba ta jtojol. Avocoluc, yuꞌunuc ti Diose, mu xavacꞌbun quichꞌ jvocol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jaꞌ jech laj yal ti vinic ta stojol ti Jesuse, jaꞌ ti laj xa onoꞌox spocoꞌal ti Jesuse: “Chopol pucuj, ictao ta yilbajinel ti vinic liꞌe”, ti xute. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ti Jesuse jech lic sjacꞌbe: ―¿Cꞌusi abi? ―xut. Jech itacꞌav: ―Legión ti jbie. Yuꞌun toj epuncutic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ep laj scꞌanbe vocol ti Jesuse, ti mu me xtacꞌatic batel ta yan banomil ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Oy tey ep xlamet chitometic ti ta xveꞌic ta yoc vitse. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ti pucujetique jech lic scꞌanbe vocol ti Jesuse: ―Acꞌo ave ti acꞌo ochcuncutic ta chitometique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jech ti Jesuse laj yacꞌ ye. Jech ti pucujetique iloqꞌuic batel ta stojol ti vinique. Ochic batel ta chitometic. Oy nopol chaꞌmiluc ti chitometique. Tey ba sjip sbaic ta barranco. Tsꞌajajtic icꞌot ta nab. Ijicꞌav scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ti jqꞌuel-chitometique ta xiꞌel ibatic ta anil. Bat yalic sloꞌilic ta jteclum schiꞌuc ta stiꞌil jteclum. Jech o xal scotol ti jnaclejetique tal sqꞌuelic ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cꞌalal icꞌotic bu oy ti Jesuse, laj yilic ti vinic ti uninbil to ox yuꞌun ti pucuje. Jun xa yoꞌnton chotol. Slapoj lec scꞌuꞌ. Tuqꞌuineb xa sjol. Cꞌalal laj yilique, ixiꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ti buchꞌutic laj yilique lic yalic ti cꞌusi icꞌot ta pasel ta stojol ti vinic ti uninbil to ox yuꞌun ti pucuje jech chac cꞌu chaꞌal ti chitometic xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jech o xal ti cristianoetique lic scꞌanbe vocol ti Jesuse ti acꞌo locꞌuc batel ta slumalique. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cꞌalal iꞌoch xa bal ta barco ti Jesuse, jech ti vinic ti uninbil to ox yuꞌun ti pucuje laj scꞌanbe vocol ti acꞌo icꞌatuc batele. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ti Jesuse muꞌyuc xacꞌ ye. Jech o xal jech laj yal: ―Batan ta ana schiꞌuc ti avutsꞌ avalaltaque. Ba albo yaꞌiic ti cꞌusi laj spas ti Dios ta atojole, ti laj xcꞌuxubinote ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jech ti vinique ibat, lic yalolan ta steclumaltac Decápolis scotol ti cꞌusi icꞌot ta pasel ta stojol yuꞌun ti Jesuse. Chꞌayal yoꞌntonic icꞌot scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cꞌalal isut batel ta barco ta jot stiꞌil nab ti Jesuse, ep cristianoetic tal ta stojol. Ti Jesuse tey icom ta stiꞌil nab. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tey ital ta stojol jun vinic ti Jairo sbie, ti jaꞌ banquilal jpasmantal ta chꞌul nae. Cꞌalal laj yil ti Jesuse, tey laj squejan sba ta yoc. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Laj scꞌanbe ep vocol ti Jesuse, ti jech laj yale: ―Ti jtsebe ta xa xcham. Avocoluc, laꞌ cajano acꞌob ta sba yoꞌ jech ta xcol, yoꞌ jech ta xcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ti Jesuse tey ibat schiꞌuc. Pero ep cristianoetic snetꞌnetꞌ xa sbaic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ti ta scotol ti tijilic batele, tey oy jun ants ti slajchebal xa jabil mu xmac ti yaꞌlele. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ep laj xa yichꞌ svocol yuꞌun epal jpoxtavanejetic. Laj xa slajes scotol ti cꞌusitic oy yuꞌune. Muꞌyuc cꞌusi itun o. Cꞌajomal yantic ta xꞌipaj batel yuꞌun ti schamele. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cꞌalal laj yaꞌibe scꞌoplal ti Jesuse, jech o xal ti antse laj schꞌic sba ochel ta scꞌal ti cristianoetique. Laj spicbe scꞌuꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yuꞌun ti antse jech ta xal ta yoꞌnton: “Ti mi ta jta ta picbel jutebuc scꞌuꞌe, colem ta xicom yuꞌun”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cꞌalal jech laj spas ti antse, jaꞌ o tey imac ti yaꞌlele. Laj yaꞌi ti lec xa oy ti sbecꞌtale. Colem xa ti schamele. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ti Jesuse laj yaꞌi ti oy buchꞌu laj scolta ta sventa ti smucꞌule. Joybij ta svalopat. Tey laj sqꞌuel scotol ti cristianoetique: ―¿Buchꞌu laj spicbun ti jcꞌuꞌe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ti yajchancꞌoptaque jech laj yalic: ―¿Cꞌu yuꞌun ta xajacꞌ ti buchꞌu laj spicun ti xachie? ¿Mi mu xavil ti ta xasnetꞌot ti cristianoetique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ti Jesuse tey xjoyet sjol ta sqꞌuel ti buchꞌu ay picvanuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jech ti antse tey xnicnun xa ta xiꞌel ibat quejiuc ta stojol ti Jesuse. Jaꞌ ti snaꞌoj xa ti cꞌusi icꞌot ta pasel ta stojole. Jech o xal jamal laj yal. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ti Jesuse jech lic yal: ―Tseb, lacol xa. Jaꞌ ti laj achꞌun ti xuꞌ cuꞌune. Junuc avoꞌnton batan. Colem xa ti achamele ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cꞌalal tey to ta xloꞌilaj ti Jesuse, jaꞌ o italic viniquetic ti lic talel ta sna ti Jairoe. Vul yalbeic stot ti tsebe: ―Ti atsebe cham xa. Jecheꞌ xa ta xavacꞌbe svocol ti jchanubtasvaneje ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ti Jesuse muꞌyuc xichꞌ ta mucꞌ ti jech laj yalique. Jaꞌ noꞌox jech laj yalbe ti Jairoe: ―Mu xaxiꞌ. Chꞌunun noꞌox ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ti Jesuse jaꞌ noꞌox laj yicꞌ batel ti Pedroe, ti Jacoboe, ti Juane, ti jaꞌ yitsꞌin ti Jacoboe. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cꞌalal icꞌot ti Jesús ta sna ti Jairoe, laj yil ti xvochlajetic xꞌavlajetic xa ta oqꞌuel ti jmuclumaletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ti Jesuse iꞌoch batel ta na. Jech laj yal: ―¿Cꞌu chaꞌal ti xavochlajetic ta oqꞌuele? Yuꞌun ti tseb liꞌe muꞌyuc chamem. Jaꞌ noꞌox ta xvay ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Scotolic laj stseꞌintaic ti Jesuse. Jech ti Jesuse laj stac loqꞌuel scotol. Jaꞌ noꞌox icomic ti stot smeꞌ ti tsebe schiꞌuc ti oxvoꞌ yajchancꞌoptaque. Iꞌochic bal ti bu oy ti tsebe. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti Jesuse laj snitbe scꞌob. Jech laj yal: ―Talita cumi ―xi. Ta xcalbot avaꞌi, Tseb, lican, xi ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ti tseb ti yichꞌoj lajcheb jabile, ta ora noꞌox ilic, lic xanavuc. Chꞌayal icꞌot yoꞌnton scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ti Jesuse tsots laj yal ti mu me buchꞌu xalbeic yaꞌi ti cꞌusi laj yilique. Jaꞌ jech xtoc laj yal ti acꞌo yaqꞌuic veꞌuc ti tsebe. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ti Jesuse ilocꞌ batel ti bu to ox oye. Ibatic cꞌalal to slumal stuc schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cꞌalal icꞌot scꞌacꞌalil ti cuxob oꞌntonale, ti Jesuse lic chanubtasvanuc ta chꞌul na. Ep ti cristianoetique chꞌayal icꞌot yoꞌntonic. Jech lic yalbe sbaic: ―¿Bu laj xchan talel scotol ti vinic leꞌe? ¿Buchꞌu iꞌacꞌbat ti sbijile, ti ep cꞌusi ta xacꞌ ta ilele? ");
INSERT INTO tzotzc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yuꞌun ti vinic leꞌe jaꞌ ti carpinteroe. Jaꞌ squerem ol ti Maríae. Jaꞌ schiꞌil ta voqꞌuel ti Jacoboe, ti Josee, ti Judase, ti Simone. Jaꞌ jech xtoc liꞌ oy jchiꞌuctic ta naclej ti yixleltaque ―xiic. Jech o xal muꞌyuc xꞌichꞌat ta mucꞌ tey. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero ti Jesuse jech lic yalbe ti cristianoetique: ―Scotolic ta xichꞌic ta mucꞌ ti jꞌalcꞌop ti nom ta xlic talele. Pero ti ta slumal stuque, ti yutsꞌ yalaltaque, ti buchꞌutic jmojic ta yut nae, mu xꞌichꞌat ta mucꞌ yuꞌun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jech o xal ti Jesuse muꞌyuc bu más laj yacꞌ ta ilel ti xuꞌ yuꞌun ti ta slumal stuque. Jun chib noꞌox laj scajan scꞌob ta sba ti jchameletic ti icol yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ti Jesuse labal laj yaꞌi ti mu xꞌichꞌat ta mucꞌ yuꞌun ti slumale. Tsꞌacal to un, ti Jesuse echꞌ chanubtasvanuc ta spat xocon ti jteclum Nazarete. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ti Jesuse laj yicꞌ talel ti lajcheb yajchancꞌoptaque. Tey lic stacan batel ta chaꞌchaꞌvoꞌ. Laj yacꞌanbe batel yabtelic ta sloqꞌuesel ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Laj yalbe ti mu me cꞌusi xichꞌic batel ti ta bee. Jaꞌ noꞌox acꞌo yichꞌic batel ti snamteꞌique. Mu me xichꞌic batel sveꞌelic, smoralic, staqꞌuinic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Laj yalbe batel ti jaꞌ noꞌox acꞌo slapic ti xonobique, ti mu me xichꞌic batel yan scꞌuꞌique, jchop noꞌox. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jech lic yal xtoc: ―Ti voꞌoxuque, ti bu ta xaꞌochic ta jun nae, tey comanic o jaꞌ to mi ta xaloqꞌuic batel ti bu oyoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mi oy bu ti mu xayichꞌic ta muqꞌue, mi mu scꞌan xaꞌiic ti cꞌusi ta xavalique, locꞌanic batel. Lilino comel ti spucuquil avoquique. Jaꞌ señail ti laj xa stoy sbaique. Ta melel ta xcalboxuc avaꞌiic, cꞌalal ta sta scꞌacꞌalil ti chapanele, jaꞌ más to tsots castigo ta xichꞌic. Jaꞌ mu sta ti buchꞌutic nacalic to ox ta Sodoma schiꞌuc Gomorra jteclume ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jech o xal ti yajchancꞌoptaque iloqꞌuic batel ta chaꞌchaꞌvoꞌ ta yalel ti acꞌo yictaic ti chopol yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jaꞌ jech xtoc ep laj sloqꞌuesic ti pucujetique. Laj yacꞌbeic aceite ta sba ep ti jchameletique, icolic yuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ti ajvalil Herodese laj yaꞌibe scꞌoplal ti cꞌu sꞌelan ta spas ti Jesuse. Yuꞌun yaꞌbinojic scotolic ti xuꞌ yuꞌune. Jech o xal ti ajvalile jech lic yal: ―Jaꞌ ichaꞌcuxi ti Juan jꞌacꞌ-ichꞌ-voꞌe. Jech o xal tsots xuꞌ yuꞌun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero ti yane jech ta xalic: ―Jaꞌ ti jꞌalcꞌop Elíase ―xiic. Ti yan xtoque jech ta xalic: ―Jaꞌ jun jꞌalcꞌop jech chac cꞌu chaꞌal ti jꞌalcꞌop ta voꞌnee ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cꞌalal laj yaꞌi ti ajvalil Herodes ti jech taje, jech lic yal: ―Taje, jaꞌ ti Juan jꞌacꞌ-ichꞌ-voꞌe ti vuꞌun laj cal ti acꞌo yichꞌ cꞌocbel ti sjole. Jaꞌ ichaꞌcuxi tal ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ti vaꞌi sꞌelan ta xal ti ajvalil Herodese, jaꞌ ti laj yal mantal ti acꞌo yichꞌ chuquel ta cadena taqꞌuin ta chuquinabe ta scoj ti Herodíase, ti jaꞌ yajnil to ox ti Felipee, ti jaꞌ yitsꞌin ti Herodese. Yuꞌun ti ajvalil Herodese laj spojbe yajnil ti yitsꞌine yoꞌ ta xajnilan. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ti Juan jꞌacꞌ-ichꞌ-voꞌe jech onoꞌox laj yal ta stojol ti ajvalil Herodese: ―Mu xuꞌ xavajnilanbe yajnil ti avitsꞌine ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jech o xal ti ants Herodíase xtiꞌet sjol ta stojol ti Juane. Jaꞌ noꞌox oy ta yoꞌnton ti acꞌo yichꞌ milele. Pero muꞌyuc cꞌusi xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yuꞌun ti ajvalil Herodese snaꞌoj lec ti jaꞌ tuqꞌuil vinic ti Juane. Jech o xal ta xchabi yoꞌ muꞌyuc cꞌusi ta spasbat yuꞌun ti ants Herodíase. Manchuc mi mu xaꞌibe lec smelol ti cꞌusi ta xale, pero ti ajvalil Herodese sjunul yoꞌnton tsꞌetel lec schiquin ta xaꞌibe scꞌop ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero ti ants Herodíase oy bu jamal laj sta ti bee. Jaꞌ o ti scꞌacꞌalil laj spas sqꞌuinal sjabilal ti ajvalil Herodese. Jech ti ajvalil Herodese laj stsob talel ti jpasmantaletic yuꞌune, ti jpasmantaletic yuꞌun ti soldadoetique, schiꞌuc ti cajal jꞌabteletic ti tey ta Galileae. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti yantsil ol ti Herodíase tey iꞌoch bal acꞌotajuc ti bu tsobol ta xveꞌic ta qꞌuine. Scotolic cꞌupil sba laj yilic ta jmec ti cꞌu sꞌelan iꞌacꞌotaj ti tsebe. Jech o xal ti ajvalil Herodese jech laj yalbe ti tsebe: ―Cꞌanbun ti cꞌusi ta xacꞌane, ta xacacꞌbot. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Manchuc mi ta xacꞌanbun oꞌlol ti bu cꞌalal jventainoje, ta xacacꞌbot, xil Dios ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jech ti tsebe ilocꞌ batel. Bat yalbe yaꞌi ti smeꞌe: ―¿Cꞌusi ta jcꞌanbe xanaꞌ ti ajvalile? ―xi. Ti smeꞌe jech laj stacꞌ: ―Cꞌanbo sjol ti Juan jꞌacꞌ-ichꞌ-voꞌe ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jech o xal ti tsebe iꞌoch batel ta anil ti bu oy ti Herodese. Jech cꞌot yal: ―Jaꞌ ta jcꞌanbot ta ora ti ta xavacꞌbun talel ta ba plato sjol ti Juan jꞌacꞌ-ichꞌ-voꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Cꞌalal jech laj yaꞌi ti ajvalil Herodese, tey iꞌoch ta at oꞌnton. Pero mu xa xuꞌ ta sutes ye, yuꞌun ti cꞌusi laj yale, laj xa yaꞌiic ti buchꞌu icꞌbilic yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jech o xal ti ajvalil Herodese ta ora noꞌox laj yalbe mantal jun yajsoldado ti acꞌo ba scꞌocbe talel sjol ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jech ti soldadoe bat ta chuquinab. Laj scꞌocbe sjol ti Juane. Laj yichꞌ talel ta jun plato. Tey tal yacꞌbe ti tsebe. Jech ti tsebe bat yacꞌbe ti smeꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cꞌalal laj yaꞌiic ti yajchancꞌoptac ti Juane, tey ba yichꞌbeic loqꞌuel talel ti sbecꞌtale yoꞌ ta smuquic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tsꞌacal to un, ti yajchancꞌoptaque lic stsob sbaic schiꞌuc ti Jesuse. Vul yalbeic yaꞌi scotol ti cꞌusi laj spasique schiꞌuc ti cꞌu sꞌelan ichanubtasvanique. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ti Jesuse jech lic yalbe: ―Laꞌic, batic, ba jcux coꞌntontic jliqueluc ti bu qꞌuejeltique ―xi. Ti jech laj yale, jaꞌ ti toj ep ta xtal ti cristianoetique, jaꞌ ti mu xa xuꞌ xꞌacꞌat veꞌicuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jech o xal ti Jesuse schiꞌuc ti yajchancꞌoptaque tey ibat stuquic ta barco ti bu stsꞌijlane. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero ep laj yilic ti ibate. Laj yojtiquinic ti jaꞌ ti Jesuse. Jech o xal ti liquemic tal ta jujun jteclume ibatic ta anil ti bu ta xcꞌotique. Ti stuquique baꞌyel icꞌotic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cꞌalal ilocꞌ ta barco ti Jesuse, tey laj yil ti epal cristianoetique. Jech o xal icuxubaj yoꞌnton ta stojolic, jaꞌ ti coꞌol sꞌelan tanijemal chij ti chꞌabal yaval ta xqꞌuelate. Jech o xal ti Jesuse ep ta tos ti cꞌu sꞌelan lic chanubtasvanuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cꞌalal mal xa ti cꞌacꞌale, jech ti yajchancꞌoptaque jech laj yalbeic ti Jesuse: ―Mal xa ti cꞌacꞌale. Jaꞌ jech xtoc chꞌabal jnaclejetic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jech o xal taco batel ti cristianoetique. Acꞌo baticuc ta jbicꞌtal jteclum ti liꞌ nopol noꞌoxe yoꞌ ta sman ti sveꞌelique. Yuꞌun muꞌyuc ti sveꞌelic liꞌe ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero ti Jesuse jech laj stacꞌ: ―Acꞌbo sveꞌelic ti voꞌoxuque ―xi. Ti stuquique jech laj yalic: ―¿Cꞌusi ta xcutcutic? ¿Bu ta jtacutic chib ciento denario taqꞌuin yoꞌ ta jmanbecutic ti sveꞌelique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ti Jesuse jech laj yal: ―Ba qꞌuelic quic jayib pan oy avuꞌunic ―xi. Cꞌalal laj snaꞌique, jech laj yalic: ―Cꞌajomal noꞌox oy voꞌob pan schiꞌuc chaꞌcot choy ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jech o xal ti Jesuse laj yal mantal ti acꞌo choticuc ta jujutsop ti ta yaxaltique. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tey ichotiic. Oy ta voꞌvinic (100), oy ta lajuneb yoxvinic (50) ti jujutsope. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jech ti Jesuse laj stsac ti voꞌob pane schiꞌuc ti chaꞌcot choye. Laj stoy muyel sat ta vinajel. Laj yalbe vocol ti Diose. Tey lic xetꞌ ti pane. Laj yacꞌbe ti yajchancꞌoptaque yoꞌ jech ta xchꞌacbeic ti cristianoetique. Jaꞌ jech xtoc ti Jesuse laj xetꞌ ti chaꞌcot choye yoꞌ jech acꞌo staic scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Scotolic iveꞌic. Lec inojic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tsꞌacal to un, lic stsobeic scomelal ti pane, ti choye. Inoj lajcheb moch ti scomelale. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Scotolic ti cꞌu yepal iveꞌique, jaꞌ voꞌob mil viniquetic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsꞌacal to un, ti Jesuse laj yalbe yaꞌi ti yajchancꞌoptaque ti acꞌo ochicuc batel ta barco yoꞌ ta xjelavic batel stuquic ta jteclum Betsaida. Ti stuque com to ta scꞌopon comel ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cꞌalal jech laj xa scꞌopon comele, imuy batel ta vits, ba scꞌopon ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cꞌalal iꞌoch ti acꞌobale, oꞌlol xa nab xcajet batel ti barcoe. Ti Jesuse tey to oy ta banomil. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pero ti Jesuse laj yil ti toj vocol ta xanav batel ti barcoe. Yuꞌun ta xmacat yuꞌun ti tsots iqꞌue. Cꞌalal ta xa sacube, ti Jesuse inopaj batel ta stojolic. Ta xanav batel ta ba voꞌ. Tucꞌ xa ox ta xjelav batel yilel. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cꞌalal laj yilic ti jech ta xanav talel ta ba voꞌe, jech o xal ti yajchancꞌoptaque laj snopic ti jaꞌ sbel-banomile. Tey iꞌavanic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yuꞌun scotolic laj yilic. Jech o xal ixiꞌic. Pero ti Jesuse lic cꞌopojuc ti jech laj yale: ―Tsotsanic me. Vuꞌunun. Mu xaxiꞌic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jech ti Jesuse iꞌoch ta barco ti bu oyique. Tey paj ti iqꞌue. Jech ti yajchancꞌoptaque elom laj yaꞌiic, chꞌayal icꞌot yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ti stuquique mu xcꞌot ta yoꞌntonic smucꞌul stsatsal ti Jesuse ti laj sboles ti pane, jaꞌ ta scoj ti yijuneb ti yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tey echꞌ stuchꞌic ti nabe. Icꞌotic ta Genesaret banomil. Tey laj xchuquic comel ti barco ta tiꞌ nabe. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cꞌalal naca to ta xloqꞌuic ta barcoe, ti cristianoetique ta ora noꞌox laj yojtiquinic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ibatic ta anil ta jujujot ti ta slumalique. Jech o xal un, tey laj spoyanic talel ti yajchamelic ti bu oy ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Buꞌyuc noꞌox ta xꞌoch batel, mi ta biqꞌuit jteclum, mi ta jteclum, mi ta naetic, tey laj yiqꞌuic talel ta be ti yajchamelique. Ta scꞌanbeic vocol ti Jesuse ti acꞌo yacꞌ ta piquel jutebuc ti stiꞌil scꞌuꞌe. Scotolic ti buchꞌutic laj staic ta piquele colem icomic. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tsꞌacal to un, inopajic batel ta stojol Jesús jun chib jfariseoetic schiꞌuc jun chib jchanubtasvanejetic yuꞌun ti mantale ti liquemic tal ta Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tey laj yilic ti muꞌyuc ta spoc scꞌobic ti ta xveꞌic jlom yajchancꞌoptac ti Jesuse. Yuꞌun laj yilic ti muꞌyuc ta spasic ti cꞌu sꞌelan liquem yuꞌunic ti mantal yuꞌun ti pocob cꞌobale. Jech o xal tey naꞌlevanic. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yuꞌun ti jfariseoetique schiꞌuc ti jꞌisraeletique staoj yav xchꞌunojic stalel ti stot smeꞌique, ti tsots scꞌoplal ti ep ta velta ta spoc scꞌobic ti cꞌalal mu to ta xveꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ti stuquique cꞌalal mi ta sutic talel ta chꞌivite, mu xuꞌ ta xveꞌic ti mi muꞌyuc ta xvul spoquic ep ta velta ti scꞌobique. Pero maꞌuc noꞌox jech yepal taje. Oy to yan ti stalel ta spasique. Ta suqꞌuic lec ti svasuique, ti sjarroique, ti pocob-cꞌobal ti pasbil ta taqꞌuine, schiꞌuc ti stemique. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jaꞌ yuꞌun un, ti jfariseoetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale jech lic sjacꞌbeic ti Jesuse: ―Qꞌuel avil ti avajchancꞌoptaque, ¿cꞌu chaꞌal mu jechuc ta spasic jech chac cꞌu chaꞌal liquem yuꞌunic ti jtot jmeꞌtique? Ti stuquique ta xveꞌic schiꞌuc ti yicꞌobal scꞌobique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ti Jesuse jech laj stacꞌbe: ―Jech onoꞌox albil acꞌoplalic ti toj toyol xapacꞌta abaique jech chac cꞌu chaꞌal laj stsꞌiba comel ti jꞌalcꞌop Isaíase: Ti cristianoetic liꞌe jun yutsil ti ye ta xiyichꞌicun ta muqꞌue. Pero ti yoꞌntonique nom oy ta jtojol. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Muꞌyuc cꞌusi bal o ti jech nijil chimilique. Yuꞌun ti cꞌusi ta xchanubtasvanique smantal noꞌox viniquetic, xi ti Diose, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yuꞌun ti voꞌoxuque ta xavictaic comel smantal ti Diose yoꞌ jech staoj yav ta xapasic stalel ti cristianoetique, ti jaꞌ noꞌox ta xasuqꞌuic ti ajarroique, ti avuchꞌob-voꞌ-vasuique, ti oy to yan ti jech ta xapasique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ti Jesuse jech laj yal xtoc: ―Ti jech staoj yav ta xapasic ti cꞌusi scꞌan ti avoꞌntonique, jaꞌ laj xa ajipic comel ta apat ta axoconic smantal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yuꞌun ti Moisese jech laj yal: “Ichꞌo ta mucꞌ atot ameꞌ. Ti buchꞌu chopol ta xcꞌopoj ta stojol ti stot smeꞌe, acꞌo chamuc”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jech ta xalbe stot smeꞌic ti viniquetic ti chanubtasbil avuꞌunique: “Mu xa xuꞌ ta jcoltaot. Yuꞌun scotol ti cꞌusi oy cuꞌune, laj xa cacꞌbe smotonin ti Diose, ti sbiinoj corbane”, xi avuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ti jech ta xal avuꞌunique, jaꞌ svinajeb ti lec ta xavaꞌiic ti muꞌyuc ta scolta ti stot smeꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaꞌ yuꞌun un, laj xa avalopatinic comel smantal ti Diose yoꞌ jech staoj yav ta xapasic ti stalel atot ameꞌique. Oy to yan ti xcoꞌolaj ta xapasique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yan to velta ti Jesuse laj yicꞌ talel ti cristianoetique. Jech laj yal: ―Aꞌyibeicun, tsꞌetano achiquinic. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Cꞌusiuc noꞌox ti ta slajes ti vinique, maꞌuc ta sta o smul. Ti bu ta sta o smul ti vinique, jaꞌ ti cꞌusi chopol ti ta xꞌayan talel ta yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ti voꞌoxuc ti oy achiquinique, aꞌyic me lec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Cꞌalal laj yicta comel cristianoetic ti Jesuse, iꞌoch batel ta na. Ti yajchancꞌoptaque tey lic sjaqꞌuic smelol ti babacꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ti Jesuse jech laj yal: ―Ti voꞌoxuque, ¿mi muꞌyuc xavaꞌibeic smelol ec? ¿Mi mu xanaꞌic xtoc ti cꞌusi ta slajes ti vinique, mu sta o smul? ");
INSERT INTO tzotzc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yuꞌun mu ta yoꞌntonuc ta xcꞌot. Ta schꞌut noꞌox ta xcꞌot. Tucꞌ ta xjelav. Tsꞌacal to ta xlocꞌ batel ―xi. Ti jech laj yal ti Jesuse, jaꞌ smelol ti lec scotol ti veꞌliletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jech laj yal xtoc ti Jesuse: ―Scotol ti cꞌusi chopol ta xꞌayan ta yoꞌnton ti vinique, jaꞌ ta sta o smul. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yuꞌun ta yut yoꞌnton ta xlic ti cꞌusi chopol ta snopilane, ti ta xcꞌupinvane, ti ta xmulivaje, ti ta xmilvane, ");
INSERT INTO tzotzc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ti ta xꞌelcꞌaje, ti ta xyuꞌninbe yaꞌi cꞌusi oy yuꞌun ti schiꞌile, ti muꞌyuc stuqꞌuile, ti ta xloꞌlavane, ti muꞌyuc sqꞌuexlale, ti itꞌix oꞌntone, ti cꞌusiuc noꞌox sbol ale, ti toyobbae, ti chꞌabal snopobil yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Scotol ti chopol taje, ta xlocꞌ talel ta yut yoꞌnton. Ta melel une, jaꞌ ta soquesat o ti vinique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ti Jesuse ilocꞌ batel, bat ta yosilal ti jteclum Tiroe schiꞌuc ti Sidone. Tey iꞌoch ta jun na. Yuꞌun mu scꞌan ti oy buchꞌu ta xꞌaꞌiate. Pero muc xuꞌ snacꞌ sba. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ta ora noꞌox iꞌaꞌibat scꞌoplal yuꞌun jun ants ti ta xꞌilbajinat yuꞌun pucuj ti yantsil ole. Jech ti antse tal squejan sba ta yoc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pero ti antse, jaꞌ jun jyanlum, liquem tal ta Sirofenicia banomil. Tal scꞌanbe vocol ti acꞌo loqꞌuesbatuc ti pucuj ti oy ta stojol ti stsebe. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ti Jesuse jech laj yal: ―Malao, acꞌo veꞌicuc baꞌyel ti alab nichꞌnabetique. Yuꞌun mu lecuc mi ta jpojbetic sveꞌel ti alab nichꞌnabetique yoꞌ ta xcacꞌbetic sveꞌ tsꞌiꞌetic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ti antse jech laj stacꞌ: ―Jech xaval avaꞌuc, Cajval. Pero ti bu ta xbaj ta yolon mexa schꞌuchꞌulil sveꞌelic ti alab nichꞌnabetique, ta stam sveꞌ ti tsꞌiꞌetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jech o xal ti Jesuse jech laj yal: ―Lec ti cꞌusi laj avale. Xuꞌ xabat. Ti pucuj ti ta xilbajin ti atsebe, locꞌ xa batel ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cꞌalal icꞌot ta sna ti antse, tey laj yil ti puchꞌul ta stem ti stsebe. Loqꞌuem xa ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ti Jesuse ilocꞌ batel ta yosilal ti jteclum Tiroe. Tey iꞌechꞌ ta jteclum Sidón schiꞌuc ti yosilal ti Decápolise. Tey cꞌot ta tiꞌil nab Galilea. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jaꞌ o tey icꞌbat talel jun vinic ti macal ti schiquine, ti jaꞌ umaꞌ xtoque. Tal cꞌanbatuc vocol ti Jesuse ti acꞌo scajan scꞌob ta sba ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ti Jesuse laj yicꞌ loqꞌuel ti bu tsobolic ti cristianoetique. Tey laj sticꞌbe ochel sniꞌ scꞌob ta schiquin ti vinique. Tsꞌacal to laj stubta sniꞌ scꞌob. Laj spicbe yocꞌ ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tsꞌacal to un, laj sqꞌuel muyel ti vinajele. Laj sjicꞌ yoꞌnton. Jech laj yal: ―Efata ―xi. Jaman, xi ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ti jech laj yal taje, jam ti schiquine, jam ti yee. Lec xa xuꞌ ta xcꞌopoj. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ti Jesuse laj yalbe ti mu me buchꞌu xalbe yaꞌiique. Manchuc mi jech laj yichꞌic albel, más to laj yal batel. ");
INSERT INTO tzotzc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yuꞌun toj chꞌayal cꞌot yoꞌntonic ti cristianoetique. Jech ta xalic: ―Lec scotol ti cꞌusi ta spase. Acꞌo mi macal schiquin, ta xjam. Acꞌo mi umaꞌ, ta xcꞌopoj yuꞌun ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Oy bu jun cꞌacꞌal ti ep laj stsob sbaic ti cristianoetique. Muꞌyuc xa sveꞌelic ta slajesic. Jech o xal ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque. Jech lic yalbe: ");
INSERT INTO tzotzc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Cꞌux ta coꞌnton scotol ti cristianoetique. Yuꞌun oy xa yoxibal cꞌacꞌal ti liꞌ oy ta jtojole, pero chꞌabal ti sveꞌelique. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ti mi ta jtac sutel ta snaique, xuꞌ ta xlubtsajic ta be. Yuꞌun oy jlom ti toj nom talemique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ti yajchancꞌoptaque jech itacꞌavic: ―¿Cꞌusi ta xcutic ta xcacꞌbetic sveꞌel ti cꞌalal chꞌabal buchꞌu nopol nacal liꞌe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ti Jesuse jech lic sjacꞌ: ―¿Jayib pan oy avuꞌunic? ―xi. Jech itacꞌavic: ―Vucub ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jech ti Jesuse laj yal ti acꞌo chotliicuc ta lumtique. Tsꞌacal to laj stsac ti vucub pane. Laj yalbe vocol ti Diose. Tsꞌacal to laj xetꞌ ti pane. Laj yacꞌbe ti yajchancꞌoptaque. Jech ti stuquique laj xchꞌacbeic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oy jaycotuc yuni choyic xtoc. Jech ti Jesuse laj yalbe vocol ti Diose. Laj yalbe ti yajchancꞌoptaque ti acꞌo xchꞌaquique. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tey iveꞌic scotolic. Noj lec schꞌutic. Tsꞌacal to un, inoj vucub moch scomelal ti veꞌlil ti laj stsobique. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ti cꞌu yepal iveꞌique, nopol van chanmil cristianoetic. Jech ti Jesuse laj scꞌopon comel ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tey iꞌoch bal ta barco schiꞌuc ti yajchancꞌoptaque. Ibatic ta Dalmanuta banomil. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ti jfariseoetique italic, lic svulic ti Jesuse yoꞌ jech ta sbajesic ta cꞌocꞌ. Jech o xal laj scꞌanic ti acꞌo yacꞌ ta ilel smucꞌul stsatsal ti xlic talel ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ti Jesuse tsots laj sjicꞌ yoꞌnton. Jech laj yal: ―¿Cꞌu chaꞌal ti cristianoetic ti ta scꞌanic ta sqꞌuel yaꞌi ti jmucꞌul jtsatsale? Ta melel ta xcalboxuc avaꞌiic, ti muꞌyuc xa cꞌusi yan señail ta xaꞌacꞌbat avilique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ti Jesuse laj yicta comel. Chaꞌoch batel ta barco. Ibat ta jot stiꞌil nab. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ti yajchancꞌoptaque chꞌay yoꞌntonic ta yichꞌel batel ti sveꞌelique. Cꞌajomal jun pan yichꞌojic batel cꞌalal ta xanavic batel ta barcoe. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Ti voꞌoxuque bijanic me yuꞌun ti spajubtasobil spanic ti jfariseoetique schiꞌuc spajubtasobil span ti Herodese ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ti stuquique jech lic yalolanbe sbaic: ―Ti jech ta xijyalbotique, jaꞌ ti chꞌabal quichꞌojtic talel ti jpantique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ti Jesuse laj snaꞌ ti jech ta xalbe sbaique. Jech laj yal: ―¿Cꞌu chaꞌal ta xavalbe abaic ti chꞌabal ti apanique? ¿Mi mu xavaꞌiic lec smelol? ¿Mi macal achiquinic? ¿Mi toj yij avoꞌntonic? ");
INSERT INTO tzotzc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Mi mu xavil ta asatic? ¿Mi mu xavaꞌi? ¿Mi chꞌay xa ta avoꞌntonic? ");
INSERT INTO tzotzc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cꞌalal laj jxetꞌ ti voꞌob pan ta stojol ti voꞌob mil viniquetique, ¿jayib moch laj atsobic ti scomelale? ―xi. Ti stuquique jech laj yalic: ―Lajcheb ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ti Jesuse jech laj yal: ―Cꞌalal laj jxetꞌ ti vucub pan ta stojol ti chanmil cristianoetique, ¿jayib moch laj atsobic ti scomelale? ―xi. Jech laj staqꞌuic: ―Vucub ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jech o xal ti Jesuse jech laj yal: ―¿Mi xanaꞌetic to un chaꞌe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsꞌacal to icꞌotic ta jteclum Betsaida. Tey icꞌbil tal ta stojol Jesús jun vinic ti maꞌsate. Laj scꞌanbeic vocol ti acꞌo scajan scꞌob ta sbae. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jech o xal laj snitbe batel scꞌob ti maꞌsate. Laj yicꞌ loqꞌuel ta stiꞌil jteclum. Tey laj xjaxbe stub ta sat. Laj scajan scꞌob ta sba. Tey lic sjacꞌbe mi xil xa jutuc ti saquilal osile. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ti maꞌsate lic stoy sat. Jech laj yal: ―Ta xquil ti xvaꞌlajet ti viniquetique, pero coꞌol sꞌelan teꞌetic. Pero ta xanav ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jech o xal ti Jesuse lic xchaꞌpicbe sat ti maꞌsate. Jech ti maꞌsate más to lic sqꞌuel ti cꞌusi ta xile. Jamal icom ti sate. Laj yil scotol. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jech o xal ti Jesuse laj stac batel ta sna. Jech laj yal: ―Mu xaꞌoch batel ta jteclum. Muꞌyuc buchꞌu xavalbe yaꞌi ti jam ti asate ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsꞌacal to un, ti Jesuse ibatic schiꞌuc ti yajchancꞌoptaque ta bicꞌtal lum ti oy ta Cesarea Filipo banomile. Cꞌalal tey oyic ta bee, tey lic sjacꞌbe ti yajchancꞌoptaque: ―¿Buchꞌuun ta xalic ti cristianoetique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ti yajchancꞌoptaque jech laj staqꞌuic: ―Oy jlom ta xalic ti voꞌot la ta Juan jꞌacꞌ-ichꞌ-voꞌe. Oy jlom ta xalic ti voꞌot la ti Elíase. Ti jlom xtoque ta xalic ti voꞌot la jun jꞌalcꞌopote ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ti Jesuse jech laj sjacꞌ: ―Ti voꞌoxuque, ¿buchꞌuun ta xanopic? ―xi. Ti Pedroe jech laj yal: ―Voꞌot ti Cristoe ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ti Jesuse laj yalbe ti mu me buchꞌu xalbe yaꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jech ti Jesuse jech lic yalbe ti yajchancꞌoptaque: ―Ti vuꞌun coꞌol jꞌelantique mu noꞌox albajuc xlic quichꞌ jvocol yuꞌun ti moletique, yuꞌun ti banquilal paleetique, yuꞌun ti jchanubtasvanejetic yuꞌun ti mantale. Ta xisbajicun. Ta xiyaqꞌuic ta milel. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cꞌalal jech laj yaꞌiique, ti Pedroe jech snatil laj yicꞌ batel ti Jesuse. Lic jajantavanuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ti Jesuse ijoybij, laj sqꞌuel ti yajchancꞌoptaque. Jech laj yalbe ti Pedroe: ―Chꞌac aba ta jtojol, Pucuj. Yuꞌun ti voꞌote maꞌuc ta xanop ti cꞌusi ta scꞌan ti Diose. Jaꞌ noꞌox ta xanop jech chac cꞌu chaꞌal ti viniquetique ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jech ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque schiꞌuc ti cristianoetique. Jech lic yal: ―Mi oy buchꞌu ta scꞌan ta xistsꞌacliun batele, acꞌo xchꞌay ta yoꞌnton ti scuxlejal stuque, manchuc mi ta xichꞌ svocol. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ti buchꞌu ta xcꞌuxubin sbae, jaꞌ ta xchꞌay ti scuxlejale. Yan ti buchꞌu ta xchꞌay ti scuxlejal ta jventae, ta sventa ti lequil achꞌ cꞌop xtoque, ta sta scuxlejal. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta melel ta xcalboxuc avaꞌiic, muꞌyuc cꞌusi bal o jun vinic mi ta xyuꞌunin scotol ti sba banomile, ti mi chꞌayel ta xbat ti schꞌulele. ");
INSERT INTO tzotzc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Cꞌusi xa xut ta sman loqꞌuel talel ti schꞌulel ti chꞌayel ta xbate? ");
INSERT INTO tzotzc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi oy buchꞌu ti ta xqꞌuexavic ta jtojole schiꞌuc mi ta xqꞌuexavic ta xchꞌunel ti jcꞌop ta stojol ti jsaꞌmuliletique, jaꞌ jechun ti vuꞌun coꞌol jꞌelantique ta xiqꞌuexav ta stojolic ec cꞌalal ta xichaꞌsut talel schiꞌuc yutsilal ti Jtote schiꞌuc ti chꞌul ángeletique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ti Jesuse jech lic yal xtoc: ―Ta melel ta xcalboxuc avaꞌiic, oy jlomoxuc liꞌe ti mu to bu ta xachamique jaꞌ to mi laj avilic yutsilal smucꞌul ti Dios ti ta xventainvane ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cꞌalal echꞌem xa ox vaquib cꞌacꞌale, ti Jesuse ibat ta jun toyol vits. Jaꞌ noꞌox laj yicꞌ batel ti Pedroe, ti Jacoboe, ti Juane. Tey iyanij ta stojol ti oxib yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ti scꞌuꞌe tey lic yacꞌ xojobal. Toj sac ta jmec jech chac cꞌu chaꞌal ti bote. Mi jaꞌuc junuc buchꞌu jech snaꞌ xchucꞌ scꞌuꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ti oxibique laj yilic ti tey ta xloꞌilaj schiꞌuc ti Elíase schiꞌuc ti Moisese. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jech o xal ti Pedroe jech lic yalbe ti Jesuse: ―Jchanubtasvanej, toj lec ti liꞌ oyotique. Jaꞌ lec ta jpascutic oxib axibal na, jun avuꞌun, jun yuꞌun Elías, jun yuꞌun Moisés ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yuꞌun ti yajchancꞌoptaque oyic ta xiꞌel, jech o xal ti Pedroe mu stacꞌ aꞌyeluc ta xaꞌi cꞌusi ta xal. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsꞌacal to tey yal talel toc ta sbaic. Vul voliaticuc. Ti ta toque laj yaꞌiic ti oy Buchꞌu ta xcꞌopoj ti jech ta xale: ―Jaꞌ ti jcꞌuxubinbil Nichꞌon liꞌe. Aꞌyic me ti scꞌope ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cꞌalal jech laj yaꞌiique, jech ti stuquique lic sqꞌuelic ta jujot. Pero muꞌyuc xa buchꞌu laj yilic. Jaꞌ xa noꞌox stuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cꞌalal ta xa xyalic talel ta vitse, ti Jesuse tsots laj yalbe yaꞌiic ti oxvoꞌique: ―Mu me buchꞌu xavalbe yaꞌiic. Jaꞌ to xuꞌ ta xavalic ti cꞌalal ta xichaꞌcuxi ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jech o xal ti oxvoꞌique yoꞌntonic noꞌox snaꞌic. Pero ta sjacꞌolanbe sbaic cꞌu chaꞌal ti jech ta xchaꞌcuxi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jech o xal ti yajchancꞌoptaque lic sjacꞌbeic ti Jesuse: ―¿Cꞌu chaꞌal ta xalic ti jchanubtasvanejetic yuꞌun ti mantale ti jaꞌ baꞌyel ta xvul ta loqꞌuel ti Elíase? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ti Jesuse jech laj stacꞌ: ―Ta melel, jech tsꞌibabil ta scꞌop Dios ti jaꞌ baꞌyel ta xvul ta loqꞌuel ti Elíase yoꞌ jech ta xchapan scotol. Pero ta xal xtoc ti jcꞌoplal ti tsꞌibabil ta scꞌop Diose ti ta xquichꞌ jvocole, ti ta xquichꞌ bajel ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ta xcalboxuc avaꞌiic, ay xa ti Elíase. Tey ipasbat ta stojol ti cꞌusi ta scꞌan ti cristianoetique jech chac cꞌu chaꞌal ta xal ti scꞌop Dios ti ta onoꞌox xcꞌot ta pasele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tsꞌacal to un, isutic talel ti bu oy ti yan yajchancꞌoptaque. Laj yilic ti joyobtabilic ta epal cristianoetique. Tey oy jun chib jchanubtasvanejetic yuꞌun ti mantale ti ta stsacolan sbaic ta cꞌop schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cꞌalal laj yilic ti ital ti Jesuse, chꞌayal icꞌot yoꞌnton scotolic. Bat scꞌoponic ta anil. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jech ti Jesuse laj sjacꞌbe ti cristianoetique: ―¿Cꞌusi palta ti jech xavochlajetic xae? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Oy jun ta scotolic ti jech laj staqꞌue: ―Jchanubtasvanej, liꞌ quicꞌojbot talel ti jnichꞌone. Yuꞌun ta xꞌilbajinat yuꞌun ti pucuje. Ta xmacbat ye. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Buꞌyuc noꞌox ta xjipat ta lum yuꞌun ti pucuje. Cꞌalal jech ta xyal ta lume, xvocan xa ye, xcꞌuxuxet ye. Yantic xa xlubtsaj batel. Laj xa jcꞌanbe vocol ti avajchancꞌoptaque ti acꞌo sloqꞌuesic ti pucuje. Pero muꞌyuc xuꞌ yuꞌunic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ti Jesuse jech laj stacꞌ: ―Jecheꞌ cristianooxuc, mu cꞌusi achꞌunojic. Ep xa cꞌacꞌal liꞌ oyun ta atojolique. Ep xa cꞌacꞌal liꞌ jtsꞌicojboxuque. Iqꞌuic talel ti quereme ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tey laj yiqꞌuic talel. Ti pucuje, cꞌalal laj yil ti Jesuse, laj stubbe yicꞌ ti quereme. Iyal ta lum. Xbalalij xa. Xvocan xa ye. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ti Jesuse laj sjacꞌbe stot ti quereme: ―¿Cꞌu xa sjalil ti jech oye? ―xut. Ti stote jech laj yal: ―Ta sbicꞌtal onoꞌox tsacbil talel. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ti pucuje ep ta velta laj xa sjipbun ta cꞌocꞌ, ta voꞌ, yoꞌ ta smil yaꞌi ti jnichꞌone. Jech o xal un, mi oy cꞌusi xavut, coltauncutic, cꞌuxubinuncutic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ti Jesuse jech laj yal: ―Ti mi ta xachꞌune, scotol xuꞌ ta xcꞌot ta pasel ta stojol ti buchꞌu ta xchꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jech o xal stot ti quereme tsots iꞌavan: ―Ta jchꞌun. Coltaun xa más ta xchꞌunel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cꞌalal laj yil ti Jesús ti yantic ta stsob sba talel ti cristianoetique, jech laj yut ti pucuje: ―Umaꞌ pucuj, Jmacal chiquin, ta xcalbot, locꞌan. Ictao comel ti quereme. Mu xa xachaꞌoch ta stojol ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jech ti pucuje tsots iꞌavan. Laj sjip ta lum, laj stubbe yicꞌ. Tey ilocꞌ batel. Chamem xa sꞌelan laj yicta comel ti quereme. Ep laj yalic ti chamem xa ti quereme. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ti Jesuse laj snitbe liquel scꞌob. Jech ti quereme ivaꞌi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jech ti Jesuse iꞌoch batel ta jun na schiꞌuc ti yajchancꞌoptaque. Jech ti yajchancꞌoptaque jech laj sjacꞌbeic ta mucul: ―¿Cꞌu chaꞌal muꞌyuc xuꞌ cuꞌuncutic ta sloqꞌuesel ti pucuje? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ti Jesuse jech laj yal: ―Ti jech pucuj leꞌe, jaꞌ noꞌox xuꞌ ta xlocꞌ batel ta sventa ti ta jcꞌopontic ti Diose, ti ta jcomtsan ti cotique ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Cꞌalal iloqꞌuic batel ti bu oyic to oxe, tey iꞌechꞌic ta Galilea banomil. Ti Jesuse mu scꞌan ti ta xꞌaꞌiate. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yuꞌun jaꞌ jech ta xchanubtas ti yajchancꞌoptaque: ―Ti vuꞌun coꞌol jꞌelantique ta xiꞌacꞌat batel ta yoc ta scꞌob ti viniquetique, yoꞌ jech ta xismilicun. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ti stuquique muꞌyuc laj yaꞌibeic smelol ti vaꞌi sꞌelan laj yale. Yuꞌun ta xiꞌic ta sjacꞌbel ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tey icꞌotic ta jteclum Capernaum. Cꞌalal oyic xa ta nae, ti Jesuse lic sjacꞌbe ti yajchancꞌoptaque: ―¿Cꞌusi ti ta xavalolanic talel ti cꞌalal lijtal ta bee? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ti stuquique tsꞌijil icomic. Jaꞌ ti tey laj sjacꞌolanbe sbaic talel ta be buchꞌu ti más banquilal yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jech o xal ti Jesuse ichoti. Laj yicꞌ talel ti lajcheb yajchancꞌoptaque. Jech laj yalbe: ―Mi oy buchꞌu ta scꞌan ti banquilal ta xcꞌote, biqꞌuit acꞌo yacꞌ sba, acꞌo yacꞌ sba ta tunel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsꞌacal to un, ti Jesuse laj snit talel jun olol. Tey laj svaꞌan ta oꞌlol ti bu oyique. Ti Jesuse lic spet ti olole. Jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Buchꞌuuc noꞌox ti ta xichꞌ ta mucꞌ jun olol ta jventa vuꞌun jech chac cꞌu chaꞌal ti olol liꞌe, jaꞌ ta xiyichꞌ ta mucꞌ. Buchꞌuuc noꞌox ti ta xiyichꞌ ta muqꞌue, maꞌuc noꞌox ta xiyichꞌ ta mucꞌ. Jaꞌ ta xichꞌ ta mucꞌ ti Buchꞌu laj stacun talele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ti Juane jech laj yalbe ti Jesuse: ―Jchanubtasvanej, laj quilcutic jun vinic ti ta sloqꞌues pucuj ta abie. Ta scoj ti mu jmojuc ta xixanav jchiꞌuctique, jech o xal laj jpajtsancutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ti Jesuse jech laj yal: ―Chꞌan uto. Mu xapajtsanic. Yuꞌun ti buchꞌu tsots xuꞌ yuꞌun ta jventae, maꞌuc jun vinic ti chopol ta xcꞌopoj ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yuꞌun ti buchꞌu mu xiscrontainotique, jaꞌ jchiꞌiltic ta abtel. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Buchꞌuuc noꞌox ti ta jventa vuꞌun ta xacꞌboxuc acꞌo mi jun vaso voꞌ ta sventa ti voꞌoxuc cuꞌunoxuque, ta melel umbi, ta sta ti smotonique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ti Jesuse jech laj yal xtoc: ―Buchꞌuuc noꞌox ti ta xchanubtas ta saꞌ mulil junuc ti ololetic ti ta xiyichꞌ ta muqꞌue, jaꞌ lec ti chuc xi choꞌ ta snuqꞌue, jip xi yalel ta nab. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mi ta scoj noꞌox acꞌob ta xata o amul yuꞌune, jaꞌ lec seto loqꞌuel. Yuꞌun jaꞌ más lec mi ta xaꞌoch batel ta cuxlejale acꞌo mi jun xa acꞌob. Jaꞌ mu lecuc mi schibal acꞌobic ta xabat ta tojob mulile ti bu mu xtub o ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ti tey ta cꞌoqꞌue, cuxul o ti xuvite. Mu xtub o ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mi ta scoj noꞌox avacan ta xata o amul yuꞌune, jaꞌ lec seto loqꞌuel xtoc. Yuꞌun jaꞌ más lec mi ta xaꞌoch batel ta cuxlejale acꞌo mi jun xa avacan. Jaꞌ mu lecuc ti mi schibal avacan ta xajipat ochel ta tojob mulile ti bu mu xtub o ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ti tey ta cꞌoqꞌue, cuxul o ti xuvite. Mu xtub o ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mi ta scoj noꞌox asat ta xata o amul yuꞌune, jaꞌ lec pitso loqꞌuel jbejuc. Yuꞌun jaꞌ más lec mi ta xaꞌoch batel ti bu ta xventainvan ti Diose acꞌo mi jbej xa asat. Jaꞌ mu lecuc mi schibal sbec asatic ta xajipat ochel ta tojob mulile. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ti tey ta cꞌoqꞌue, cuxul o ti xuvite. Mu xtub o ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Scotolic ta cꞌocꞌ ta vocol ta xmeltsaj jech chac cꞌu chaꞌal ta xichꞌ acꞌbel yatsꞌmil ti smoton Dios ti ta xichꞌ chicꞌbele. ");
INSERT INTO tzotzc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ti atsꞌame, toj tunel. Pero mi ta xchꞌay ti schiꞌile, muꞌyuc xa cꞌusi xtun o. Jech ti voꞌoxuque, oyuc yutsilal avoꞌntonic. Jmojuc me avoꞌntonic acotolic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ti Jesuse ilocꞌ batel ta jteclum Capernaum. Ibat ta Judea banomil schiꞌuc ti ta jot ucꞌum Jordán ti oy ta sloqꞌueb cꞌacꞌale. Cꞌalal jech tey oy ti Jesuse, ti cristianoetique tey lic stsob sbaic yan velta ti bu oye. Jech ti Jesuse tey lic chanubtasvanuc jech chac cꞌu chaꞌal ta spas onoꞌox. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tey inopajic batel jun chib jfariseoetic yoꞌ jech ta sbajesic ta cꞌocꞌ ti Jesuse. Jech o xal lic sjaqꞌuic mi xuꞌ ta sbaj sbaic jun vinic schiꞌuc ti yajnile. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ti Jesuse jech laj stacꞌ: ―Albun caꞌi, ¿cꞌu sꞌelan laj yalboxuc ti Moisese? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ti stuquique jech laj yalic: ―Ti Moisese ta xal ti xuꞌ ta jbaj jbacutic. Ti mi ta xichꞌ meltsanel svunal ti bajobbaile, jech ti vinique xuꞌ ta scomtsan ti yajnile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ti Jesuse jech laj stacꞌ: ―Ti Moisese jech laj yalboxuc ta scoj ti toj yij avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ti ta sliquebale, ti cꞌalal lic smeltsan scotol ti Diose, laj spas jun vinic, jun ants. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jech o xal ti vinique ta scomtsan stot smeꞌ yoꞌ jech ta xicꞌ ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jech ta spas ta jun ti chaꞌvoꞌique. Jech o xal ti vinic schiꞌuc ti antse mu xa yuꞌunuc chaꞌvoꞌicuc. Comic xa ta jun. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jech o xal ti vinique mu xuꞌ ta xchꞌac sbaic ti cꞌalal pasbilic ta jun yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cꞌalal oyic ta nae, ti yajchancꞌoptaque lic sjacꞌbeic scꞌoplal ti jech taje. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ti Jesuse jech laj yalbe: ―Buchꞌuuc noꞌox ti viniquetic ti ta sbaj ti yajnile, ti ta xicꞌ yan antse, laj xa sta smul ta scoj ti laj sbaj ti sbaꞌyel ajnile. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jaꞌ jech ti ants xtoque, mi ta sjip comel ti smalele, ti chba yicꞌ yan vinique, laj sta smul ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Oy jlom cristianoetic ti yicꞌojic talel ololetic ta stojol ti Jesuse yoꞌ jech ta scajan scꞌob ta sba. Pero ti yajchancꞌoptaque laj spajtsanic ti buchꞌutic ta xiqꞌuic talel ti ololetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cꞌalal jech laj yil ti Jesuse, vocol laj yaꞌi. Jech o xal jech laj yal: ―Acꞌo talicuc ta jtojol ti ololetique. Mu xamac ta be. Yuꞌun ti buchꞌutic coꞌol sꞌelan yoꞌntonic jech chac cꞌu chaꞌal ti ololetic liꞌe, jaꞌ ventainbilic yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta melel ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti mu jechuc yoꞌntonic jech chac cꞌu chaꞌal ti ololetic liꞌe, mu xuꞌ ta xꞌochic batel ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jech ti Jesuse laj spet ti ololetique. Laj scajan scꞌob ta sba yoꞌ jech ta xacꞌbe bendición. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cꞌalal ilocꞌ xa bal ta xanobal ti Jesuse, tey ital ta anil jun vinic. Tey laj squejan sba ta stojol. Jech lic yalbe: ―Lequil Jchanubtasvanej, ¿cꞌusi ta scꞌan ta jpas yoꞌ ta jta ti jcuxlejal sventa sbatel osile? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ti Jesuse jech laj yal: ―¿Cꞌu chaꞌal jech ta xavalbun ti lequil vinicune? Ti buchꞌu leque, jaꞌ noꞌox ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ti voꞌote xanaꞌ lec ti mantaletique: “Mu xasaꞌ avants. Mu xamilvan. Mu xaꞌelcꞌaj. Mu xajut cꞌop. Mu xaloꞌlavan. Ichꞌo ta mucꞌ atot ameꞌ”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ti vinique jech laj stacꞌ: ―Jchanubtasvanej, scotol taje ta jbicꞌtal onoꞌox jchꞌunoj talel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ti Jesuse cꞌuxubaj yoꞌnton laj sqꞌuel batel ti vinique. Jech laj yal: ―Jun xa noꞌox scꞌan ti ta xapase. Batan, ba chono scotol ti cꞌusitic xꞌayan avuꞌune. Jech ti stojole, acꞌbo ti buchꞌutic meꞌonetique. Ti mi jech ta xapase, jaꞌ jech umbi, oy acꞌulejal ta vinajel. Tsꞌacal to un, laꞌ me. Manchuc mi ta xavichꞌ avocol, tsꞌacliun batel ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cꞌalal jech laj yaꞌi ti vinique, lic svul yoꞌnton. Ta at oꞌnton xa ibat. Yuꞌun toj jcꞌulej. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jech o xal ti Jesuse lic sqꞌuel spat xocon. Jech laj yalbe ti yajchancꞌoptaque: ―Batsꞌi toj vocol ta xꞌoch ti jcꞌulejetic ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ti yajchancꞌoptaque toj chꞌayal cꞌot yoꞌntonic yuꞌun ti cꞌop taje. Pero ti Jesuse jech lic xchaꞌal: ―Jnichꞌnab, toj vocol ta xꞌoch ti bu ta xventainvan ti Diose ti buchꞌutic jaꞌ noꞌox spatoj yoꞌntonic yuꞌun ti scꞌulejalique. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jaꞌ más to xuꞌ ta xjelav ta sat acuxa ti jcot comelloe. Ti buchꞌu jcꞌuleje toj vocol ta xꞌoch ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cꞌalal jech laj yaꞌiic ti yajchancꞌoptaque, chꞌayal icꞌot yoꞌntonic. Jech lic sjacꞌolanbe sbaic: ―Ti mi jaꞌ jech taje, ¿buchꞌu xa onoꞌox ta xcol? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ti Jesuse laj sqꞌuel batel. Jech laj yalbe: ―Ta melel, ti viniquetique mu xuꞌ ta scolta sba stuquic. Pero ti Diose xuꞌ yuꞌun. Yuꞌun ti Diose muꞌyuc cꞌusi ti mu xuꞌ yuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ti Pedroe jech lic yal: ―Cajval, ti vuꞌuncutique laj xa jcomtsancutic ti cꞌusitic xꞌayan cuꞌuncutique. Liꞌ xa jchiꞌinojotcutique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ti Jesuse jech laj stacꞌ: ―Ta melel ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti ta xtuchꞌ ta yoꞌnton ti snae, ti schiꞌiltac ta voqꞌuele, ti stot smeꞌe, ti yajnile, ti snichꞌnabe, ti yosile, ta jventa vuꞌun, ta sventa ti lequil achꞌ cꞌop ti jaꞌ colebale, toj lec ti jech taje. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Yuꞌun liꞌ noꞌox ta banomile ta stabeic voꞌvinic (100) sqꞌuexol más ti snae, ti schiꞌiltac ta voqꞌuele, ti smeꞌe, ti snichꞌnabe, ti yosile, acꞌo mi ta xichꞌ ilbajinel xtoc. Tsꞌacal to ta sta ti scuxlejal sbatel osile. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Oy ep ti buchꞌutic ichꞌbilic ta mucꞌ avi liꞌe, pero oy bu ta sta yorail ti muꞌyuc ichꞌbilic ta mucꞌ ta xcꞌotique. Oy ep ti buchꞌutic muꞌyuc ichꞌbilic ta mucꞌ avi liꞌe, pero ta sta yorail ti ichꞌbilic ta mucꞌ ta xcꞌotique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ti Jesuse, tijil batel ta spat ti yajchancꞌoptac ti cꞌalal ta xa xmuyic batel ta sbelel Jerusalene. Jech ti stuquique tey chꞌayal yoꞌntonic ti cꞌusi laj yaꞌiique. Xiꞌeluc xa xtoc ti tey tsꞌacalic batele. Ti Jesuse laj xchꞌac loqꞌuel ti lajchaꞌvoꞌ yajchancꞌoptaque. Tey lic yalbe yaꞌi ti cꞌusi ta xcꞌot ta pasele: ");
INSERT INTO tzotzc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Ti voꞌoxuque ta xavilic ti ta xijmuy batel ta Jerusalene. Ti vuꞌun ti coꞌol jꞌelantique tey ta xiꞌacꞌat ta cꞌabal ta stojol ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. Ta xacꞌ yeic yoꞌ ta xquichꞌ milel. Tey ta xiyaqꞌuicun ta stojol ti jyanlum cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tey ta xislabanicun. Ta xismajicun. Ta xistubtaicun. Tsꞌacal to un, ta xismilicun. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ti Jacoboe schiꞌuc ti Juane, ti jaꞌ snichꞌnab ti Zebedeoe, inopajic batel ta stojol ti Jesuse. Jech laj yalic: ―Jchanubtasvanej, ta jcꞌanbotcutic vocol ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ti Jesuse tey laj stacꞌ: ―¿Cꞌusi ta xacꞌan ti ta jpasboxuque? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ti stuquique jech laj yalic: ―Cꞌalal ta sta yorail ti ta xapas mantale, acꞌo ave ti ta xichoticutic jun ta abatsꞌi cꞌob, jun ta atsꞌet cꞌob ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ti Jesuse jech laj stacꞌ: ―Ti voꞌoxuque mu xanaꞌ ti cꞌusi ta xacꞌanique. ¿Mi ta xcuch avuꞌunic ta yichꞌel ti vocole jech chac cꞌu chaꞌal ti vuꞌune? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ti stuquique jech laj staqꞌuic: ―Ta xcuch cuꞌuncutic ―xiic. Ti Jesuse jech laj yal: ―Jech melel, jech onoꞌox ta xataic ti vocole jech chac cꞌu chaꞌal ta jta ti vuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ti jech ta xacꞌanic ti ta xachotiic jun ta jbatsꞌi cꞌobe, ti jun ta jtsꞌeb cꞌobe, maꞌuc cabtel ta xcacꞌ. Ti buchꞌu ta xchoti ta jxocone, jaꞌ noꞌox ta xꞌacꞌbatic ti buchꞌutic jech albil scꞌoplalique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cꞌalal jech laj yaꞌiic ti lajunvoꞌ yajchancꞌoptaque, mu lecuc laj yaꞌiic. Laj yiltaic ti Jacoboe, ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque. Jech laj yal: ―Ti voꞌoxuque xanaꞌic lec, ti ajvaliletic liꞌ ta banomile stoyoj sbaic ti jech oy yabtelique. Ti buchꞌu cajale ta xacꞌ ta ilel ti tsots ti yabtele yichꞌoje. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mu me jechuc xapasic ti voꞌoxuque. Ti buchꞌu ta scꞌan ichꞌbil ta mucꞌ ta xcꞌot ta atojolique, jaꞌ ta scꞌan ti acꞌo yacꞌ sba ta mosovinel yuꞌun ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ti buchꞌu ta scꞌan ti ichꞌbil ta muqꞌue, jaꞌ ta scꞌan ti ta xacꞌ sba ta mosovinel yuꞌun ti schiꞌiltaque. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ti vuꞌun ti coꞌol jꞌelantique maꞌuc lital mosovinvancun. Jaꞌ tal cacꞌ jba ta tunel, tal cacꞌ jba ta milel ta sventa stojol scolel ti epal cristianoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Icꞌotic ta jteclum Jericó. Tey ta xa xlocꞌ batel ta stiꞌil jteclum ti Jesuse schiꞌuc ti yajchancꞌoptaque, schiꞌuc ti epal cristianoetique. Tey chotol ta tiꞌ be ta scꞌan limoxna oy jun maꞌsat, Bartimeo sbi, ti jaꞌ snichꞌon ti Timeoe. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cꞌalal laj yaꞌi ti ta xa xnopaj tal ti Jesús ti liquem tal ta Nazarete, tey lic avanuc ti maꞌsate: ―Jesús, Snichꞌon David, cꞌuxubinun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oy ep buchꞌu ipajtsanvanic yoꞌ acꞌo chꞌaniuc. Pero ti maꞌsate más to tsots lic avanuc: ―Jesús, Snichꞌon David, cꞌuxubinun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jech ti Jesuse tey ivaꞌi. Jech laj yal: ―Iqꞌuic talel ―xi. Jech o xal ti cristianoetique jech laj yalbeic: ―Tsotsan, vaꞌlan. Yuꞌun ta xicꞌot ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jech ti maꞌsate ta ora noꞌox laj sjip comel ti smochib cꞌuꞌe. Ibit liquel ta anil. Inopaj batel ta stojol ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ti Jesuse jech laj sjacꞌbe: ―¿Cꞌusi ta xacꞌan ta jpasbot? ―xut. Ti maꞌsate jech itacꞌav: ―Jchanubtasvanej, ta jcꞌan ti ta xajambun ti jsate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ti Jesuse jech laj yalbe: ―Xuꞌ xabat. Jam xa ti asate ta sventa ti laj achꞌunune ―xi. Cꞌalal jech laj yal ti Jesuse, ta ora noꞌox ijam ti sate. Tey laj xchiꞌin batel ta be. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cꞌalal icꞌotic nopol xa Jerusalene ti bu oy ti chib jteclum Betfagee schiꞌuc ti Betaniae, ti oy ta yelobal ti vits Olivose, ti Jesuse laj stac jelavel chaꞌvoꞌ yajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jech laj yalbe: ―Batanic ta uni jteclum ti leꞌ xjelav batele. Cꞌalal mi lacꞌotique, tey ta xataic jun burro chucul, ti muꞌyuc to bu cajlebinbile. Jitunic, nitic talel liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi oy buchꞌu ta xalboxuc: “¿Cꞌu chaꞌal jech ta xapasic?” mi xayutique, albeic yaꞌi: “Jaꞌ ta xtun yuꞌun ti Cajvaltique. Tsꞌacal to ta sutesbot talel”, xavutic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jech o xal ti chaꞌvoꞌique ibatic. Tey chucul laj staic ti uni burroe nopol ta tiꞌ na ti oy ta tiꞌ bee. Tey laj sjitunic talel. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Oy jlom ti buchꞌu tey oyique, jech laj yalic: ―¿Cꞌusi ta xapasic? ¿Cꞌu chaꞌal ta xajitunic ti burroe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ti chaꞌvoꞌique jech laj stacꞌbeic jech chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse. Jech o xal muꞌyuc cꞌusi iꞌalbatic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tey laj snitic batel ti burro ti bu icom ti Jesuse. Ti stuquique lic scajan scꞌuꞌic ta sba ti burroe. Jech ti Jesuse tey icaji batel. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ep ti buchꞌutic laj sqꞌuiananic ta banomil ti scꞌuꞌique. Oy yan xtoc laj sbojic yanal teꞌ. Laj yaqꞌuic ta be. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ti buchꞌu jbaꞌbeic batele, ti buchꞌu jtsꞌac patic talele, jech lic avanicuc: ―Yan yutsil ti Buchꞌu tacbil talel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yan yutsil ti jventainvanej ta xtale jech chac cꞌu chaꞌal iventainvan ti jtotic Davide. Jun yutsil ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jaꞌ jech iꞌoch batel ta Jerusalén ti Jesuse. Jaꞌ jech xtoc iꞌoch batel ta templo. Cꞌalal laj sqꞌuel ti cꞌu sꞌelan scotol ta jujot ti temploe, tey ilocꞌ batel. Ibat ta Betania schiꞌuc ti lajchaꞌvoꞌ yajchancꞌoptaque. Yuꞌun mal xa cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta yocꞌlomal, cꞌalal iloqꞌuic batel ta Betaniae, ti Jesuse lic yaꞌi viꞌnal. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tey laj yil ta nom jpets icux ti oy yanale. Jech o xal bat sqꞌuel mi oy ti sate. Pero muꞌyuc sat laj sta. Jaꞌ noꞌox yanal, yuꞌun maꞌuc to yorail ta satin. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jech ti Jesuse jech laj yalbe ti icuxe: ―Muꞌyucuc buchꞌu sloꞌbot o asat ―xut. Ti yajchancꞌoptaque laj yaꞌiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tsꞌacal to un, ti Jesuse schiꞌuc ti yajchancꞌoptaque icꞌotic ta Jerusalén. Cꞌalal iꞌoch batel ta templo ti Jesuse, lic snutsan loqꞌuel scotol ti buchꞌu ta xchonilajic ta smanolajic teye. Laj svalcꞌunbe smexaic ti jeltaqꞌuinetique. Laj svalcꞌunbe xilaic ti jchonpalomaetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mi jaꞌuc jun ta xacꞌ ochuc ti oy cꞌusi xcuchojic ochel ta temploe. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ti Jesuse jech lic chanubtasvanuc: ―Jech ta xal ti Dios ti tsꞌibabil ta scꞌope: “Ti templo cuꞌune jaꞌ jtaobil ta cꞌoponel yuꞌun ti cristianoetic ti oyic ta sjoylej banomile”, xi ti Diose. Pero ti voꞌoxuque joybij avuꞌunic ta snail chꞌen jꞌeleqꞌuetic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, laj yaꞌiic ti jech laj spas ti Jesuse. Jech o xal ti stuquique lic snopic cꞌusi ta xutic yoꞌ ta xaqꞌuic ta milel. Jaꞌ ti laj yilic ti toj lec laj yaꞌiic ti cristianoetic ti cꞌu sꞌelan ichanubtasvane. Jech o xal ixiꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cꞌalal iꞌoch ti acꞌobale, ti Jesuse ilocꞌ batel ti ta jteclum Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sob xa ta yocꞌlomal, iꞌechꞌic yan velta ti bu teqꞌuel ti icuxe. Jech ti yajchancꞌoptaque laj yilic ti taquijem xa schiꞌuc ti yibele. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ti Pedroe ivul ta yoꞌnton. Jech lic yalbe ti Jesuse: ―Jchanubtasvanej, qꞌuel avil ti icux ti laj avute, taquijem xa ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ti Jesuse jech itacꞌav: ―Chꞌunic ti xuꞌ yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta melel ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti ta xalbe yaꞌi ti vits liꞌe: “Locan, batel liꞌe, ba jipo aba ta nab”, mi xute, ti mi mu xnaꞌetuc ti yoꞌntone, ti mi ta xchꞌun ti ta xcꞌot ta pasel ti cꞌusi laj yale, ta onoꞌox xcꞌot ta pasel. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jech o xal ta xcalboxuc, scotol ti cꞌusi ta xacꞌanbe ti Dios ti cꞌalal ta xataic ta cꞌoponele, ti mi ta xachꞌun ti laꞌacꞌbat xae, jech onoꞌox laj xa ataic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mi oy buchꞌu aqꞌuelojbe smul cꞌalal ta xataic ta cꞌoponel ti Diose, acꞌbo perdón, yoꞌ jech ti Atotic ti oy ta vinajele, ta xacꞌboxuc perdón yuꞌun ti amulique. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero mi mu xavaqꞌuic perdone, jech ti Atotic ti oy ta vinajele, mu xacꞌboxuc perdón yuꞌun ti amulique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ti Jesuse schiꞌuc ti yajchancꞌoptaque ichaꞌsutic batel ta Jerusalén. Cꞌalal tey och batel ta temploe, inopajic talel ta stojol ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, schiꞌuc ti moletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ti stuquique jech lic sjacꞌbeic ti Jesuse: ―¿Cꞌusi avabtel avichꞌoj? ¿Buchꞌu laj yacꞌbot avabtel ti vi sꞌelan ta xapase? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ti Jesuse jech laj stacꞌbe: ―Jaꞌ jechun ec, ta jcꞌan ta jacꞌboxuc jbel cꞌop. Ti mi xuꞌ ta xatacꞌbeicune, ta xcalboxuc avaꞌiic buchꞌu yacꞌojbun cabtel ti jech ta jpase. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Albun caꞌi, ¿buchꞌu laj stac talel ti Juane yoꞌ jech ta xacꞌ ichꞌ voꞌ? ¿Mi tacbil talel yuꞌun ti Diose? ¿Mi tacbil talel yuꞌun viniquetic noꞌox? Tacꞌbeicun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ti stuquique jech lic yalolanbe sbaic: ―Ti mi ta xcaltic ti jaꞌ tacbil talel yuꞌun ti Diose, ti stuque xuꞌ ta xistacꞌbotic: “¿Cꞌu chaꞌal ti muꞌyuc laj avichꞌic ta mucꞌ?” xijyut. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ti mi ta xcaltic ti jaꞌ tacbil yuꞌun ti viniquetic ti mi xcutique, melel, toj xiꞌbal sba. Yuꞌun scotolic snaꞌojic ti jaꞌ tacbil talel yuꞌun Dios ti Juane ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jech o xal ti stuquique jech laj yalbeic ti Jesuse: ―Mu jnaꞌcutic ―xutic. Jech o xal ti Jesuse jech laj yal: ―Jaꞌ jechun ec, mi jaꞌuc ta xcalboxuc avaꞌiic buchꞌu yacꞌojbun cabtel ti jech ta jpase ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ti Jesuse jech lic yal ta babacꞌop: ―Oy jun vinic ti ep laj stsꞌun uva ti ta yosile. Laj smac lec ta moc. Laj spasbe jun yavil ti bu ta xichꞌ pitsꞌel ti sat uvae. Laj smeltsan jun toyol luchlebal yoꞌ jech ta xichꞌ chabiel scotol. Tsꞌacal to un, laj yacꞌ ta chꞌom ti yosil ta stojol ti jꞌabteletique. Ibat ta nom ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cꞌalal sta xa yorail ti ta xichꞌ tuchꞌel ti uvae, laj stac talel jun yajꞌabtel yoꞌ ta scꞌan ti cꞌu yepal ta xichꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero ti jꞌabteletique laj stsaquic. Laj smajic. Muꞌyuc cꞌusi laj yacꞌbeic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tsꞌacal to un, ti yajval banomile lic xchaꞌtac batel yan yajꞌabtel. Pero jaꞌ jech xtoc ti jꞌabteletique laj yutic, laj yacꞌbeic ton, laj syayijesbeic sjol. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ti yajval banomile laj to xchaꞌtac batel yan yajꞌabtel. Pero laj smilic xtoc. Tsꞌacal to ti yajval banomile laj stac batel ep yajꞌabteltac. Pero jaꞌ noꞌox jech xtoc, oy jlom ilajic ta milel, oy jlom ilajic ta majel. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Oy to jun snichꞌon xtoc ti cꞌux ta xaꞌie. Slajeb xa laj stac batel ti jech laj snop ta yoꞌntone: “Ta xiyichꞌbeicun ta mucꞌ ti jnichꞌone”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero ti jꞌabteletique jech laj yalbe sbaic: “Ti vinic leꞌe, jaꞌ ti buchꞌu ta xichꞌ comel ti osile. Laꞌ jmiltic yoꞌ jech ta xcuꞌunintic ti osile”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jech o xal laj stsaquic, laj smilic. Laj xjochic loqꞌuel ta spat ti tsꞌunobaltique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jech o xal ti Jesuse tey lic sjacꞌ: ―¿Cꞌusi ta spas ti yajval banomil ti jech taje? Ta xtal smil ti jꞌabteletique. Jech ti yosile ta xacꞌ ta chꞌom ta yan. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Ti voꞌoxuque, ¿mi muꞌyuc avilojic ta scꞌop Dios ti jech ta xale? Ti ton ti bajbil yuꞌun ti jꞌabteletique, tsꞌacal to jaꞌ jtunel icom sventa sliqueb ti nae. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jaꞌ yabtel stuc ti Diose. Jun yutsil ta xcꞌot ta jtojoltic, ti xie ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ti stuquique ta scꞌan xa ox ta stsaquic ta chuquel ti Jesuse. Yuꞌun laj yaꞌiic lec ti jaꞌ scꞌoplal stuquic ti jech laj sbabacꞌopta ti Jesuse. Pero muꞌyuc laj stsaquic, yuꞌun ixiꞌic yuꞌun ti cristianoetique. Jech o xal un, laj yictaic comel ti Jesuse. Ibatic. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsꞌacal to un, ti stuquique laj staquic batel ta stojol Jesús jun chib jfariseoetic schiꞌuc jun chib svinictac ti Herodese yoꞌ jech mi oy cꞌusi chopol ta xlocꞌ ta ye, yoꞌ jech ta xbaj ta cꞌocꞌ yuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jech o xal ti stuquique italic, jech lic yalic: ―Jchanubtasvanej, ti vuꞌuncutique jnaꞌojcutic lec ti tucꞌ ta xachanubtasvane. Maꞌuc ta xacꞌan ti lec acꞌoplal yuꞌun ti cristianoetique. Jech o xal un, mu xajel ti cꞌu sꞌelan ta xachanubtasvane. Jaꞌ noꞌox oy ta avoꞌnton ti ta xachanubtasvan ti cꞌu sꞌelan ta jtacutic slequilal ti Diose. Jech o xal un, ti patan taqꞌuin yuꞌun ti ajvalil romanoe, ¿mi lec ti ta jtojtique? ¿Mi mu lecuc ti ta jtojtique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ti Jesuse snaꞌoj xa onoꞌox ti jecheꞌ onoꞌox ta xloꞌlavanique. Jech o xal jech laj yal: ―¿Cꞌu chaꞌal ti ta xayalesicun avaꞌi ta cꞌoqꞌue? Acꞌbun quil jsepuc taqꞌuin ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ti stuquique laj yichꞌic talel ti taqꞌuine. Cꞌalal laj sqꞌuel ti Jesuse, tey laj sjacꞌ: ―¿Buchꞌu sat, buchꞌu sbi ti liꞌ tsacale? ―xi. Ti stuquique jech laj staqꞌuic: ―Jaꞌ ti ajvalile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jech ti Jesuse jech laj yal: ―Acꞌbeic ti ajvalil romano ti cꞌusi jaꞌ yuꞌune. Jaꞌ jech xtoc, acꞌbeic ti Dios ti cꞌusi jaꞌ yuꞌune ―xi. Ti stuquique chꞌayal icꞌot yoꞌntonic ti jech itacꞌbatique. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jech xtoc un, bat sqꞌuelic Jesús jun chib jsaduceoetic. Ti jsaduceoetique xchꞌunojic ti muꞌyuc ta xchaꞌcuxi ti animaetique. Jech o xal jech laj yalic: ");
INSERT INTO tzotzc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Jchanubtasvanej, ti Moisese laj stsꞌibabuncutic comel ti mi oy buchꞌu ta xcham jun vinic ti chꞌabal yol ta xicta comel ti yajnile, jech o xal ti yitsꞌine, acꞌo yicꞌbe yajnil ti animae, yoꞌ jech mu xchꞌay stsꞌunobal ti sbanquile. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Qꞌuel avil, oy viniquetic ti vucubic ta voqꞌuele ti jech icꞌot ta pasele. Ti sba banquilale laj yicꞌ yajnil. Pero icham. Chꞌabal snichꞌon icom. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tsꞌacal to un, ti schaꞌvoꞌal itsꞌinale laj yicꞌbe yajnil ti animae. Jech xtoc icham. Chꞌabal snichꞌon icom. Jaꞌ jech laj spas xtoc ti yoxibal itsꞌinale. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jaꞌ jech laj yiqꞌuic ti jun ants ti yucubalique. Icham scotolic. Mi jaꞌuc junuc yuꞌunic ti oy snichꞌon icome. Tsꞌacal to icham ec ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jech o xal cꞌalal ta sta yorail ti ta xchaꞌcuxi ti animaetique, albun caꞌicutic, ¿buchꞌu junucal yuꞌunic ti yajnil ta xcome cꞌalal ti vucub viniquetic laj yajnilanic ti antse? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ti Jesuse jech laj stacꞌbe: ―Toj chꞌayemoxuc ta jꞌechꞌel. Yuꞌun mu xavaꞌiic ti scꞌop Diose, mi jaꞌuc ti smucꞌul stsatsal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cꞌalal sta yorail ti ta xchaꞌcuxiic ti animaetique, laj scꞌoplal ti jech ta saꞌ ti snup schiꞌilique. Laj scꞌoplal ti jech ta xacꞌ ta nupunel ti yantsꞌil nichꞌonique. Yuꞌun ta xcꞌotic jech chac cꞌu chaꞌal ti ángeletic ti oy ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Cꞌu chaꞌal ta xanopic ti muꞌyuc ta xchaꞌcuxi ti animaetique? ¿Mi yuꞌun muꞌyuc aqꞌuelojic ti cꞌu sꞌelan tsꞌibabil ta scꞌop Dios yuꞌun ti Moisése, ti cꞌalal icꞌopoj ti Dios ta stojol ti coꞌol sꞌelan ta xcꞌacꞌ ti jpets uni teꞌe? Jech laj yal: “Diosun yuꞌun ti Abrahame, yuꞌun ti Isaaque, yuꞌun ti Jacobe”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ta stojol ti Diose, muꞌyuc buchꞌu chamem. Scotolic cuxulic. Jech o xal ti voꞌoxuque toj chꞌayemoxuc ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jaꞌ jech xtoc inopaj talel ta stojol Jesús jun jchanubtasvanej yuꞌun ti mantale, yuꞌun laj yaꞌi ti laj stsac sbaic ta cꞌop ti Jesús schiꞌuc ti jsaduceoetique. Laj yaꞌi ti lec tucꞌ laj stacꞌ ti Jesuse. Jech o xal jech laj sjacꞌ: ―¿Cꞌusi junucal mantal ti más tsots scꞌoplal ta scotole? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ti Jesuse jech laj stacꞌbe: ―Ti mantal ti más tsots scꞌoplale, jaꞌ liꞌe: “Aꞌyio avaꞌiic, Israel, ti Cajvaltic Dios cuꞌuntique, jaꞌ noꞌox stuc Ajvalil. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jech o xal un, cꞌano ti Cajvaltic Diose ta sjunul avoꞌnton, ta sjunul achꞌichꞌel, ta sjunul avip, ta sjunul snopobil avuꞌun”, ti xie. Jaꞌ ti mantal ti más tsots scꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ti yan ti jutuc mu coꞌoluque, jaꞌ liꞌe: “Cꞌuxubino ti achiꞌile jech chac cꞌu chaꞌal ta xacꞌuxubin aba atuc”, ti xie. Ti chib mantal liꞌe jaꞌ ti más tsots scꞌoplale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ti jchanubtasvanej yuꞌun ti mantale jech laj yal: ―Lec ti jech laj aval, Jchanubtasvanej. Melel ti cꞌusi laj avale. Jun noꞌox ti Diose. Muꞌyuc xa yan jech chac cꞌu chaꞌal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ti jech ta jcꞌantic ti Diose ta sjunul coꞌntontic, ta sjunul snopobil cuꞌuntic, ta sjunul jchꞌichꞌeltic, ta sjunul quiptic, ti ta jcꞌuxubintic ti jchiꞌiltic jech chac cꞌu chaꞌal ta jcꞌuxubin jba jtuctique, jaꞌ ti más tsots scꞌoplal taje. Jaꞌ mu sta scꞌoplal ti smoton Dios ti ta jmiltique, ti ta jchicꞌbetic ta altare ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cꞌalal laj yil ti Jesús ti lec tucꞌ laj staqꞌue, jech laj yal: ―Mu xa nomuc oyot ta stojol ti ventainel yuꞌun ti Diose ―xi. Cꞌalal jech laj yaꞌiique, muꞌyuc xa cꞌusi laj sjacꞌolanbeic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","36","Ti Jesuse tey ta xchanubtasvan ta templo ti jech ta xale: ―Ti jchanubtasvanejetic yuꞌun ti mantale, ¿cꞌu chaꞌal ta xalic ti jaꞌ snitilul David ti Cristoe, cꞌalal ti Davide, ta sventa ti ventainbil yuꞌun ti Chꞌul Espíritue, jech laj yal? Ti Diose jech laj yalbe ti Cajvale: “Laꞌ chotlan ta jbatsꞌi cꞌob, jaꞌ to mi ta xcacꞌ ta avoc ta acꞌob ti avajcrontae”, xꞌutat, xi ti Davide. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Cꞌusi xut ti Cristo ti jaꞌ snitilul ti Davide cꞌalal ti David Cajval ti xute? ―xi ti Jesuse. Ti epal cristianoetique sjunul yoꞌntonic ta xaꞌibeic scꞌop ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ti Jesuse jech ta xchanubtas ti cristianoetique: ―Bijanic me yuꞌun ti jchanubtasvanejetic yuꞌun ti mantale. Yuꞌun ti stuquique toj lec ta xaꞌiic ti nat scꞌuꞌ slapojique. Toj lec ta xaꞌiic ti ichꞌbilic ta mucꞌ ti buꞌyuc noꞌox ta xanavique. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ti stuquique ta saꞌic ti chotlebal ti bu ichꞌbil ta mucꞌ tey ta chꞌul nae. Jaꞌ jech xtoc ta saꞌic ti chotlebal ti bu ichꞌbil ta mucꞌ ti cꞌalal ta xꞌicꞌatic ta veꞌele. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta spojbe sna ti meꞌonal antsetique. Pero yoꞌ jech mu xacꞌ ta ilel ti cꞌusi ta spojique, jal ta xa scꞌoponic ti Diose. Jech o xal ti stuquique jaꞌ más tsots castigo ta xichꞌic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Oy bu jun velta ti Jesuse tey chotol ta yut templo ta yeloval scaxail smoton ti Diose. Laj yil ti ta xaqꞌuic comel ti taqꞌuin sventa smoton ti Diose. Ep ti jcꞌulejetique ta xaqꞌuic comel ep ti staqꞌuinique. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Cꞌalal jech ta spasique, jaꞌ o icꞌot jun meꞌon ants ti laj sticꞌ ochel ta caxa chib biqꞌuit taqꞌuin ti jutuc ti stojole. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jech o xal ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque. Jech laj yalbe: ―Ta melel ta xcalboxuc avaꞌiic, ti meꞌon ants leꞌe, jaꞌ más ep laj yacꞌ ta xil ti Diose. Jaꞌ mu sta ti yan ti buchꞌutic ep laj yaqꞌuique. ");
INSERT INTO tzotzc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yuꞌun ti buchꞌu ep laj yaqꞌuique, sobrail xa noꞌox. Pero ti meꞌon ants leꞌe laj yacꞌ comel scotol ti cꞌajomal jaꞌ ta xtun yuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cꞌalal tey xa ta xloqꞌuic batel ta temploe, oy jun yajchancꞌop ti jech lic yale: ―Jchanubtasvanej, qꞌuel avil yutsiquil ti tone. Toj lec meltsanbil ti templo liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ti Jesuse jech laj stacꞌ: ―Jech xaval avaꞌuc ti jun yutsiquil meltsanbile. Pero oy bu ta sta scꞌacꞌalil ti ta xlilije. Mi jaꞌuc jbej ton ti cajal ta xcom ta sba ti yan tone. Scotol lilijem ta xcom ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jech ti Jesuse schiꞌuc ti yajchancꞌoptaque ibatic ta vits Olivos ta yeloval ti temploe. Cꞌalal tey chotol ti Jesuse, jech ti Pedroe, ti Jacoboe, ti Juane, ti Andrese tal sjaqꞌuic ta mucul: ");
INSERT INTO tzotzc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Ta jcꞌan ti ta xavalbun caꞌicutic, ¿cꞌusi ora ta xcꞌot ta pasel ti jech taje? ¿Cꞌusi svinajeb ti cꞌalal poꞌot xa sta yorail ti jech ta xcꞌot ta pasele? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ti Jesuse jech laj stacꞌbe: ―Bijanic me. Mu me xataic loꞌlael. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yuꞌun ep ti buchꞌutic sbiinoj ti jbi ti jech ta xalique: “Vuꞌun Cristoun”, ti xiique. Ep ta xlajic ta loꞌlael. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ti voꞌoxuque, cꞌalal ta xavaꞌibeic scꞌoplal ti oy xa leto liꞌe, ti oy xa leto leꞌe, ti xiique, mu me xaxiꞌic. Yuꞌun jech onoꞌox ta xcꞌot ta pasel. Pero maꞌuc to slajebal ti cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Baꞌyel ta xlic scrontain sbaic ti mucꞌtic lumetique, ta scrontain sbaic ti ajvaliletique. Buꞌyuc noꞌox oy niquel, oy viꞌnal. Buꞌyuc noꞌox xvochlajet ti cristianoetique. Ti vaꞌi sꞌelan ta xcꞌot ta pasele, jaꞌ sliquebal to ti vocole. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Jech ti voꞌoxuque qꞌuelo me abaic. Yuꞌun ta xaꞌacꞌatic batel ta entregal ta stojol ti ajvaliletique. Ta xavichꞌic majel ta chꞌul na. Ti voꞌoxuque ta jventa vuꞌun ti jech ta xavaꞌan abaic ta stojol ti ajvaliletique, ti reyetique, yoꞌ jech tey ta xavalbe yaꞌiic ti jcꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cꞌalal mu to ta sta yorail ti slajebal cꞌacꞌale, tsots scꞌoplal ti ta xichꞌ alel ti colebal ta sjoylej ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cꞌalal ta xaꞌacꞌatic batel ta stojol ti ajvaliletique, mu xavat avoꞌntonic, mu xapocoꞌnopic ti cꞌusi ta xcꞌot avalique. Alic ti cꞌusi ta xacꞌboxuc anaꞌic ti Dios cꞌalal tey oyoxuc ta stojolique. Yuꞌun maꞌuc ti voꞌoxuc ti ta xacꞌopojique, jaꞌ ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti viniquetique ta xacꞌ ta entregal ti schiꞌil ta voqꞌuele yoꞌ acꞌo yichꞌ milel. Ti totiletique ta xacꞌ ta entregal ti snichꞌonique yoꞌ acꞌo yichꞌ milel. Ti nichꞌoniletique ta xacꞌ ta entregal ti stotique yoꞌ acꞌo chamuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ta jventa vuꞌun ti jech ta xayichꞌic ta cronta scotol ti cristianoetique. Mu lecuc ta xayilic. Pero buchꞌuuc noꞌox ti staoj yav yoꞌntonic xcham xlaje, jaꞌ ta xcolic. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ti jꞌalcꞌop Daniele laj stsꞌiba comel scꞌoplal ti jsoquesvanej ti ta xchꞌayvane. (Ti buchꞌu ta sqꞌuel liꞌe, acꞌo yaꞌi lec ti cꞌusi ta xale.) Cꞌalal ta xavilic ti tey xa oy ti bu maꞌuc sventae, acꞌo jatavicuc batel ta vitstic ti buchꞌutic nacalic ta Judea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jaꞌ jech xtoc ti buchꞌutic muyemic batel ta schaꞌcojal sna ti jech cꞌacꞌal taje, mu xa me xyal batel ta stamel ti cꞌusi ta xtun yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jaꞌ jech xtoc ti buchꞌutic oyic ta osiltique, mu xa me xtal ta sna ta stamel ti scꞌuꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jaꞌ toj abol sbaic ti antsetic ti buchꞌutic schiꞌuc to ti yolique, schiꞌuc ti buchꞌutic ta to xchuꞌun ti yolic ti jech cꞌacꞌal taje. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ti voꞌoxuque, taic me ta cꞌoponel ti Diose ti maꞌucuc me ta yorail sictic ti ta xajatavic batele. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuꞌun mu noꞌox albajuc ti vocol ta xtale. Sba to velta ti jech ta xichꞌ svocolic ti cristianoetique. Jaꞌ mu sta ti laj yichꞌ tal svocolic ti cristianoetic ti sliquebal banomile. Cꞌalal mi echꞌe, muꞌyuc xa jech ta xtal ti vocole. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti manchucuc ta sbicꞌtajes vocol ti Cajvaltique, muꞌyuc buchꞌu junuc ta xcol ti jechuque. Pero ta sbicꞌtajes ta sventa ti cꞌux ta xaꞌi ti buchꞌu tꞌujbilic yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Mi oy buchꞌu ta xalboxuc: “Qꞌuel avilic, liꞌ xa oy ti Cristoe”, o mi moꞌoje: “Leꞌ xa oy”, mi xayutique, mu xachꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yuꞌun toj ep jloꞌlavanejetic ta xtal ti ta sbis sbaic ta Cristoe. O mi moꞌoje, ta xalic ti ta xcꞌopojic ta sventa ti Diose. Ti jloꞌlavanejetique ep ta xaqꞌuic iluc ti tsots xuꞌ yuꞌunique yoꞌ jech ta xloꞌlavanic. Ti xuꞌuc yuꞌunique, ta sloꞌlaic ti buchꞌutic tꞌujbilic xa yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Laj xa jpocoꞌalboxuc ti jech onoꞌox ta xcꞌot ta pasele. Qꞌuelo me abaic. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Cꞌalal mi echꞌ xa yorail ti vocole, ti cꞌacꞌale ta xꞌicꞌub. Ti ue mu xa xacꞌ ti xojobale. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ti cꞌanaletique ta xbajuc yal tal ti oy ta vinajele. Scotol ti cꞌusitic oy ta vinajele xlaj nicanuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jech o xal un, jaꞌ o yorail ti ta xiyilicun ti tey ta xital ta ba toc schiꞌuc jmucꞌul jlequilal ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jaꞌ o ta xcalbe mantal ti cajángeltaque yoꞌ ta stsobic talel ti calab jnichꞌnab ti tꞌujbilic cuꞌune, ti buꞌyuc noꞌox oyic ta sjoylej banomile. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ti voꞌoxuque, vuleso me ta avoꞌntonic ti cꞌalal ta xavilic ti ta xꞌuninaj scꞌobtac ti ta sjelta yanal ti icuxe, xanaꞌic lec ti jaꞌ o xa yorail ti ta xtal ti voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jaꞌ jech sꞌelan xtoc ti cꞌalal ta xcꞌot ta pasel ti vaꞌi sꞌelan laj calboxuque, naꞌic me lec ti nopolun xa talel ta tiꞌ nae. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta melel ta xcalboxuc avaꞌiic, ti vaꞌi sꞌelan laj cal taje, oy to cuxajtic ti cristianoetic cꞌalal ta xꞌechꞌ scotol ti vocol taje. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ti vinajele, ti banomile ta xlaj scꞌoplal. Pero ti jcꞌope mu stselbuj. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ti scꞌacꞌalil yorail ti ta xichaꞌsut talele, muꞌyuc buchꞌu snaꞌ. Mu snaꞌic ti ángeletic ti oyic ta vinajele. Mi jaꞌuc jnaꞌ ti vuꞌun Snichꞌonun ti Diose. Jaꞌ noꞌox snaꞌ stuc ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Jech o xal un, viqꞌuiluc me asatic. Tucꞌulano me abaic. Cꞌoponic me ti Diose. Yuꞌun mu xanaꞌic cꞌusi ora ti ta xcꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ti cꞌalal ta xichaꞌsut talele, coꞌol sꞌelan jech chac cꞌu chaꞌal jun vinic ti ta xbat ta nome. Pero cꞌalal mu to ta xlocꞌ batele, ta xacꞌbe comel sventain sna ti yajꞌabtele. Ta xacꞌbe comel yabtel ta jujun. Jun ta xalbe comel ti acꞌo xchabi lec ti tiꞌ nae. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jech o xal ti voꞌoxuque viqꞌuiluc me asatic. Yuꞌun mu xanaꞌic cꞌusi ora ta xvul ti yajval nae. Mi naca ta xꞌoch acꞌobal, mi ta oꞌlol acꞌobal, mi naca sba oqꞌuel cots, mi ta sob icꞌloman, mu xanaꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jech o xal un, ti voꞌoxuque mu me vayemucoxuc chvul staoxuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ti cꞌusi ta xcalboxuc ti voꞌoxuque, jaꞌ jech ta xcalbe yaꞌi ti yane ti viqꞌuiluc me ti satique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chib xa cꞌacꞌal scꞌan ta xlic ti qꞌuin Colel ti cꞌalal jaꞌ o ta sveꞌic ti pan ti muꞌyuc yichꞌoj ti spajubtasobile. Jech ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, ta saꞌbeic smelol ti cꞌu sꞌelan ta sloꞌlaic yoꞌ jech ta xaqꞌuic ta milel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero jech ta xalic xtoc: ―Ti cꞌalal jech ta xichꞌ tsaquele, maꞌuc ti cꞌalal syaquil ti qꞌuine, yoꞌ jech mu xlic epal cꞌop yuꞌunic ti cristianoetique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ti Jesuse tey oy ta Betania jteclum ta sna Simón ti sbiinoj ti jcꞌaꞌemal-chamele. Cꞌalal jech chotol ta mexa ti Jesuse, jaꞌ o ital jun ants ti yichꞌoj talel jun jaru ti meltsanbil ta alabastro tone, ti noj ta aceite ti capbil ta nardo ti toj toyol ti stojole. Ti antse laj svocꞌ ti jarue. Laj smalbe ti aceite ta sjol ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Cꞌalal jech laj spase, oy jlom ti buchꞌu tey oyique isoc sjolic ti jech laj spas ti antse. Jech o xal tey lic yalbe sbaic: ―¿Cꞌu chaꞌal ti jech laj yixlan ti aceite ti capal ta nardoe? ");
INSERT INTO tzotzc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jaꞌ lec ti lajuc yichꞌ chonel ti más ta oxib ciento denario taqꞌuine yoꞌ jech ta xichꞌ coltael ti buchꞌutic abol sbaique ―xiic. Jech o xal chopol laj yaꞌiic ti jech laj spas ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ti Jesuse jech laj yal: ―Chꞌan utic, ¿cꞌu chaꞌal ta xavaqꞌuic ta vul oꞌnton ti antse? Toj yan noꞌox yutsil ti jech laj spas ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yuꞌun ti buchꞌutic abol sbaique liꞌ onoꞌox oy ta atojolique. Xuꞌ xacoltaic ti cꞌusiuc ora ta xacꞌanique. Yan ti vuꞌune mu liꞌuc jchiꞌinojoxuc oe. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Qꞌuel avil ti ants liꞌe, laj xa spas ti cꞌu yepal xuꞌ yuꞌune. Laj xa smuibtasbun ti jbecꞌtale yoꞌ ta xquichꞌ muquel. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta melel ta xcalboxuc avaꞌiic, buꞌyuc noꞌox ti ta xichꞌ alel ti lequil achꞌ cꞌop ta sjoylej banomile, jaꞌ jech xtoc ta xvinajesbat scꞌoplal ti ants liꞌe, yoꞌ jech mu xchꞌay ta yoꞌnton ti cristainoetic scꞌoplal ti ants liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jech ti Judas Iscariotee, ti jaꞌ jun ta slajchaꞌvoꞌal ti yajchancꞌoptaque, ilocꞌ batel. Bat ta stojol ti banquilal paleetique yoꞌ ta spasic jun trate, yoꞌ ta xacꞌ ta cꞌabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cꞌalal laj yaꞌiic ti banquilal paleetique, jun to yutsil laj yaꞌiic. Tey laj yalic ti ta xacꞌbeic ti taqꞌuine. Jech o xal ti Judase lic saꞌolan cꞌusi ta xut yoꞌ ta xacꞌ ta cꞌabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti sba cꞌacꞌal sliqueb ti qꞌuine, ti cꞌalal jaꞌ o ta sveꞌic ti pan ti chꞌabal yichꞌoj ti spajubtasobile, cꞌalal jaꞌ o yorail xtoc ti ta xichꞌ milel ti chij sventa ti qꞌuin Colele, jech ti yajchancꞌoptaque jech lic sjacꞌbeic ti Jesuse: ―¿Bu ta xacꞌan ti chba jpascutic ti veꞌlil yoꞌ jech ta xaveꞌ ta sventa ti qꞌuin Colele? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ti Jesuse laj stac batel chib yajchancꞌop ti jech laj yalbee: ―Batanic leꞌ ta jteclume. Tey ta xataic jun vinic ti xcuchoj batel jun qꞌuib voꞌe. Nablanic batel ta spat. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti bu ta xꞌoch ta nae, albeic yaꞌi ti yajval nae: “Jech laj yal ti Jchanubtasvaneje: ¿Bu oy ti cuarto ti ta xiveꞌ schiꞌuc ti cajchancꞌoptac ta sventa ti qꞌuin Colele? xi laj yal talel”, xavutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jech ti yajval nae ta xacꞌboxuc avilic jun mucꞌ ta cuarto ti oy ta schaꞌcojal na ti meltsajem xae. Tey ta xameltsanic ti jveꞌeltique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jech ti chaꞌvoꞌ yajchancꞌope iloqꞌuic batel. Tey icꞌotic ta jteclum. Tey laj staic jech chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse. Jech o xal tey lic smeltsanic ti veꞌlil sventa ti qꞌuin Colele. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cꞌalal iꞌoch ti acꞌobale, tey icꞌotic schiꞌuc ti lajchaꞌvoꞌ yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cꞌalal tey xa ta xveꞌic ta mexae, ti Jesuse jech lic yal: ―Ta melel ta xcalboxuc avaꞌiic, oy jun avuꞌunic liꞌ jchiꞌinoj ta veꞌele ti ta xiyacꞌun ta cꞌabale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cꞌalal jech laj yaꞌiique, ochic ta at oꞌnton. Jech lic sjacꞌbeic ta jujun tal ti Jesuse: ―¿Mi jaꞌ li vuꞌune? ¿Mi jaꞌ li vuꞌune? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ti Jesuse jech laj stacꞌ: ―Jaꞌ jun ta alajchebalic ti ta jun jsetsꞌcutic ta xiveꞌ schiꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ti vuꞌun coꞌol jꞌelantique jech onoꞌox ta xcꞌot ta jtojol jech chac cꞌu chaꞌal ti tsꞌibabil ta scꞌop Diose. Pero toj abol sba ti vinic ti buchꞌu jech ta xiyacꞌ ta cꞌabale. Jaꞌ lec ti manchucuc ivocꞌ talele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cꞌalal xyaquet ta xveꞌique, ti Jesuse lic stsac ti pane. Laj yalbe vocol ti Diose. Tsꞌacal to laj xetꞌ ti pane. Laj yacꞌbe batel ti yajchancꞌoptaque. Jech lic yal: ―Veꞌanic ti pan liꞌe, jaꞌ ti jbecꞌtale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsꞌacal to ti Jesuse laj stsac ti sbisol yaꞌlel uvae. Cꞌalal laj yalbe vocol ti Diose, laj yacꞌbe batel ti yajchancꞌoptaque. Scotolic laj yuchꞌic ti yaꞌlel uvae. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ti Jesuse jech lic yal: ―Ti yaꞌlel uva ti laj avuchꞌique, jaꞌ xa icꞌot ta pasel ti achꞌ trate ta sventa ti ta xmal ti jchꞌichꞌele ta sventa slequilal ti epal cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta melel ta xcalboxuc avaꞌiic, slajeb velta ti jech ta xcuchꞌ ti yaꞌlel uvae. Jaꞌ to ta xcuchꞌtic yan velta ti achꞌ yaꞌlel uvae ti cꞌalal ta jtsob jbatic ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cꞌalal laj yoꞌntonic ta sqꞌuejintael jun qꞌuejoje, tey ibatic ta vits Olivos. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jech o xal ti Jesuse jech laj yal: ―Acotolic ti voꞌoxuque ta xchibaj avoꞌntonic ta jtojol ti acꞌobal liꞌe. Yuꞌun jech ta xal ti tsꞌibabil ta scꞌop Diose: “Ta xcacꞌ ta milel ti jqꞌuelchije. Jech ti chije tan puc ta xbat”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cꞌalal ta xichaꞌcuxie, vuꞌun ta xijelav batel ta Galilea banomil. Tsꞌacal to ta xacꞌotic ti voꞌoxuque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ti Pedroe jech laj yal: ―Manchuc mi ta xchibaj yoꞌntonic ti yane, pero ti vuꞌune mu xchibaj coꞌnton ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ti Jesuse jech laj stacꞌ: ―Ta melel ta xcalbot avaꞌi, Pedro, ti acꞌobal tana liꞌe ti cꞌalal mu to xlic ocꞌuc schibal velta ti cotse, oxib xa ox velta laj aval ti mu xavojtiquinune ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero ti Pedroe jech laj stacꞌbe ti Jesuse: ―¡Bu xata ti jech ta xcale! Manchuc mi jmoj ta xijlajotic ta milel, mi jaꞌuc ta xcal ti mu xacojtiquine ―xi. Pero maꞌuc noꞌox stuc. Jech laj yal scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsꞌacal to icꞌotic ta tsꞌunobaltic ti jaꞌ Getsemaní sbie. Ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Chotlanic to comel liꞌe. Vuꞌune chba jta ta cꞌoponel ti Dios leꞌ ta jote ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ti Jesuse yicꞌoj batel ti Pedroe, ti Jacoboe, ti Juane. Ti Jesuse tey lic yaꞌi ta yoꞌnton ti mu xa jayloqꞌueluc xꞌechꞌ ta xaꞌi ti vocole. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jech o xal jech laj yal: ―Mu noꞌox albajuc ta xcat coꞌnton. Xuꞌ ta xicham o ta xcaꞌi. Ti voꞌoxuque liꞌ to comanique. Mu me xavayic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jech ti Jesuse jech snatil ibat. Lic spatan sba ta banomil. Laj scꞌanbe ti Diose ti xuꞌuc ta xqꞌuejbat batel ti svocole, yoꞌ jech mu xcꞌot ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ti cꞌalal laj sta ta cꞌoponel ti Diose, jech laj yal: ―Tot, ti voꞌote scotol xuꞌ avuꞌun. Coltaun yoꞌ mu xcꞌot ta jtojol ti jvocole. Pero maꞌuc ta jcꞌan jech chac cꞌu chaꞌal ta jcꞌan jtuc. Jaꞌuc me ti cꞌusi ta xacꞌan ti voꞌote ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ti Jesuse isut batel ti bu icomic ti oxib yajchancꞌope. Pero vayemic cꞌot sta. Jech o xal jech laj yalbe ti Pedroe: ―Simón, ¿mi ta xavay? ¿Mi mu xuꞌ avuꞌun ti vicluc asat junuc orae? ");
INSERT INTO tzotzc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vicꞌo me asatic. Taic me ta cꞌoponel ti Diose yoꞌ jech mu xayuꞌuninic ti pucuje. Ta melel, tsots avoꞌntonic. Pero muꞌyuc yip ti abecꞌtalique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jech ti Jesuse ichaꞌsut batel yan velta ti bu ta sta ta cꞌoponel ti Diose. Mu yanuc ti scꞌope. Coꞌol jech chac cꞌu chaꞌal ti laj yal ta baꞌyele. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tsꞌacal to un, isut talel. Pero vayemic vul sta ti yajchancꞌoptaque. Jaꞌ ti mu chaꞌbel xvicꞌ ti satique. Jaꞌ ti ta smutsbat satic yuꞌun ti vayele. Mu stacꞌ aꞌyeluc ta xaꞌiic cꞌusi xuꞌ ta stacꞌbeic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cꞌalal isut talel ta yoxibal veltae, jech laj yal: ―Vayanic xa. Cux avoꞌntonic. Yuꞌun sta xa yorail ti ta xiꞌacꞌat bal ta cꞌabal yuꞌun ti jsaꞌmuliletique ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Vaꞌlanic, batic. Yuꞌun tal xa ti buchꞌu ta xiyacꞌ ta cꞌabale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ti Jesuse, yacal to ta xcꞌopoj cꞌalal jaꞌ o icꞌot ti Judase, ti jaꞌ jun ta slajchaꞌvoꞌal ti yajchancꞌoptaque. Ti stuque tal schiꞌuc epal cristianoetic, schiꞌuc yespadaic, schiꞌuc steꞌic ti jaꞌ tacbilic talel yuꞌun ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, schiꞌuc ti moletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ti jꞌacꞌvanej ta cꞌabal Judase, spocoꞌalojbe xa onoꞌox señail ti cꞌu sꞌelan ta spas ti jech laj yale: ―Ti buchꞌu ta jbutsꞌ ta xavilique, jaꞌ me umbi. Tsaquic me, chuquic me lec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jech o xal un, cꞌalal icꞌot ti Judas ti bu oy ti Jesuse, jech cꞌot yalbe: ―Jchanubtasvanej, Jchanubtasvanej ―xi. Jaꞌ o laj sbutsꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ta jech to yepal laj stsaquic ti Jesuse. Laj xchuquic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Oy jun ti buchꞌu tey oye laj sloqꞌues ti yespadae. Laj sbojbe schiquin ti yajꞌabtel ti banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ti Jesuse jech laj yalbe ti jtsacvanejetique: ―Latalic schiꞌuc avespadaic schiꞌuc ateꞌic yoꞌ ta xachuquicun batel coꞌol sꞌelan jun jꞌelecꞌun yilel. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Scotol cꞌacꞌal tey oyun ta atojolic laj jchanubtasoxuc ti ta temploe. Pero mi jaꞌuc laj atsaquicun. Ti jech ta xapasic avi tana liꞌe, jaꞌ ta sventa yoꞌ ta xcꞌot ta pasel ti cꞌusi tsꞌibabil ta scꞌop Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jech ti yajchancꞌoptaque laj yictaic comel stuc ti Jesuse. Ijatavic batel. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oy jun querem vinic spixoj sba ta saquil pocꞌ ti tey nabal ibat ta spat ti Jesuse. Tey itsacat ec. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero ti querem vinique laj yicta comel ti saquil poqꞌue. Tꞌanal ijatav batel ta anil. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jech ti Jesuse icꞌbil batel ta stojol ti banquilal palee. Tey lic stsob sbaic scotol ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, schiꞌuc ti moletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ti Pedroe nomtic tijil batel ta spat ti Jesuse. Iꞌoch batel cꞌalal to yamaqꞌuil sna ti banquilal palee. Tey chotol icom ta cꞌatimol schiꞌuc ti mayoletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ti banquilal paleetique schiꞌuc ti banquilal jchapanvanejetique lic saꞌbeic smul ti Jesuse yoꞌ xuꞌ ta xaqꞌuic ta milel. Pero muꞌyuc bu laj stabeic ti smule. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ep ti buchꞌutic ta sjutbeic smul ti Jesuse, pero mu jmojuc ti scꞌopique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oy jlom ta jecheꞌ laj svaꞌan sbaic ta rextigo ti jech lic yalique: ");
INSERT INTO tzotzc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Qꞌuel avil, ti vuꞌuncutique laj caꞌicutic ti jech laj yal ti vinic liꞌe: “Vuꞌun ta jlilin ti templo ti meltsanbil yuꞌun ti cristianoetique. Pero ta oxib cꞌacꞌal ta jvaꞌan yan achꞌ ti maꞌuc meltsanbil yuꞌun ti cristianoetique”, xi laj caꞌicutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Manchuc mi jech laj yalic ti jutcꞌop rextigoetique, pero mu jmojuc ti scꞌopique. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jech o xal ti banquilal palee tey lic vaꞌiuc ta stojol ti jchapanvanejetique. Jech lic sjacꞌbe ti Jesuse: ―¿Cꞌu chaꞌal mu xapac ti acꞌoplale? ¿Cꞌusi taje ti vaꞌi sꞌelan ti amule? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ti Jesuse muꞌyuc laj stacꞌ, tsijil icom. Jech o xal ti banquilal palee jech lic xchaꞌjacꞌbe yan velta: ―¿Mi voꞌot ti Cristoe, Snichꞌonot ti lequil Diose? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ti Jesuse jech laj yal: ―Melel, Vuꞌunun. Ti voꞌoxuque ta xavilicun ti coꞌol jꞌelantique ti ta xichoti ta sbatsꞌi cꞌob ti Dios ti scotol xuꞌ yuꞌune. Jaꞌ jech xtoc ta xavilicun ti ta xichaꞌsut talel ta ba toque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jech o xal ti banquilal palee lic xchꞌiꞌ ta jatel ti scꞌuꞌe, svinajeb ti toj echꞌem chopol ti jech laj yaꞌi cꞌusi laj yal ti Jesuse. Jech ti stuque jech lic yal: ―Mu xa persauc ta jcꞌantic yan rextigo. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ti voꞌoxuque laj xa avaꞌiic ti ta xchopol-cꞌopta ti Diose. Jech o xal, ¿cꞌu xachiic xanaꞌ? ―xi. Scotol laj yalic: ―Chamuc ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jech o xal oy jlom lic stubtabeic sat. Oy jlom lic smacbeic ti sate yoꞌ jech ta xacꞌbeic majel. Jech ta xalbeic: ―Naꞌo caꞌicutic ti buchꞌu laj smajote ―xutic. Ti mayoletique laj smajbeic ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti Pedroe tey oy ta yamaquil sna ti banquilal palee. Tey icꞌot jun ants ti jaꞌ yajꞌabtel ti banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ti antse ti cꞌalal laj yil ti Pedro ti tey chotol ta xcꞌatin ta tiꞌ cꞌoqꞌue, tey laj sqꞌuelbe sat. Jech lic yalbe: ―Ti voꞌot eque jaꞌ achiꞌil ta xanobal ti Jesús ti liquem talel ta Nazarete ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ti Pedroe laj smuc ta yoꞌnton. Jech laj yal: ―Mu xcojtiquin. Mu jnaꞌ buchꞌu ti vaꞌi sꞌelan ta xavale ―xi. Tey ilocꞌ batel ta spat ti tiꞌ moque. Jaꞌ o tey lic ocꞌuc ti cotse. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ti antse lic sqꞌuelbe batel sat yan velta ti Pedroe. Tey lic yal ta stojol ti buchꞌutic chotolic ta xcꞌatinique: ―Ti vinic leꞌe jaꞌ jun schiꞌil ti Jesuse ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ti Pedroe laj xchaꞌmuc ta yoꞌnton yan velta ti Jesuse. Cꞌalal naca to jech laj yal ti antse, jaꞌ o tey laj yalic xtoc ti buchꞌutic tey chotolic ta xcꞌatinique: ―Ta melel, ti voꞌote jaꞌ achiꞌil abaic. Yuꞌun liquemot tal ta Galilea. Yuꞌun coꞌol sꞌelan acꞌopojelic ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ti Pedroe lic chopol-cꞌopojuc. Jech laj yal xtoc: ―Xil Dios, batsꞌi mu xcojtiquin buchꞌu ti vinic ti ta xavlic taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naca to jech laj yal ti Pedroe, cꞌalal jaꞌ o lic ocꞌuc schaꞌoqꞌuelal ti cotse. Jaꞌ o ivul ta yoꞌnton ti Pedroe ti jech onoꞌox iꞌalbat yuꞌun ti Jesuse: “Cꞌalal muꞌyuc to ox ta xꞌocꞌ ti schaꞌoqꞌuelal ti cotse, oxib xa ox velta ta xaval ti mu xavojtiquinune”, ti xꞌutat onoꞌoxe. Cꞌalal jech laj snaꞌe, jaꞌ o tey lic yoqꞌuita sba ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cꞌalal sacub xa ti osile, ti banquilal paleetique bat stsob sbaic schiꞌuc ti moletique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, schiꞌuc scotol ti banquilal jchapanvanejetique. Scotolic ti vaꞌi yepal taje xchucojic batel ti Jesús ta stojol ti Pilatoe. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ti Pilatoe jech laj sjacꞌ: ―¿Mi voꞌot ti ajvalilot yuꞌun ti jꞌisraeletique? ―xut. Ti Jesuse jech laj stacꞌ: ―Jaꞌ jech, jech chac cꞌu chaꞌal ta xaval ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ti banquilal paleetique ep ta tos ti cꞌusitic lic saꞌbeic ti smule. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jech o xal ti Pilatoe lic xchaꞌjacꞌ: ―¿Cꞌu chaꞌal ti mu xapac acꞌoplale? Qꞌuel avil ti cꞌu sꞌelan ta saꞌic ti amule ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ti Jesuse tsijil icom. Jech o xal ti Pilatoe mu stacꞌ aꞌyeluc ta xaꞌi cꞌusi xuꞌ ta snop. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ti Pilatoe jech onoꞌox stalel ti ta scolta batel jun jchuquel cꞌalal yorail ti qꞌuine, jaꞌ ti buchꞌu ta scꞌan ta stꞌujic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti ta chuquinabe, oy jun jchuquel, Barrabás sbi, schiꞌuc yan jchuqueletic ti jaꞌ imilvanic ti cꞌalal ta ox spojbeic yabtel ti ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ti jꞌisraeletique tal scꞌanbeic ti Pilatoe ti acꞌo scolta batel jun jchuquel jech chac cꞌu chaꞌal liquem onoꞌox yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ti Pilatoe jech laj stacꞌ: ―¿Mi jaꞌ ta xacꞌanic ti ta jcolta batel ti ajvalil yuꞌun ti Israele? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jaꞌ jech laj yal ti Pilatoe, yuꞌun laj yil ti ta yitꞌixal yoꞌntonic ti banquilal paleetique ti tal acꞌbatuc ta stojol ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero ti banquilal paleetique lic sliquesbe sjol ti cristianoetique yoꞌ acꞌo yalic scotolic ti coluc batel ti Barrabase. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ti Pilatoe jech lic sjacꞌ: ―¿Cꞌusi ta xacꞌanic ta jpasbe ti ajvalil yuꞌun Israel ta xavalique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ti stuquique xꞌavlajetic xa lic tacꞌavicuc: ―¡Jipano ta cruz! ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ti Pilatoe jech laj yal: ―¿Cꞌusi chopol laj spas? ―xi. Pero ti stuquique lic chaꞌavanicuc: ―¡Jipano ta cruz! ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ti Pilatoe ta scꞌan ti lec ta xꞌilat yuꞌun ti cristianoetique. Jech o xal laj scolta loqꞌuel ti Barrabase. Laj yal mantal ti acꞌo yichꞌ tsitsel ta nucul ti Jesuse. Tsꞌacal to laj yacꞌ batel yoꞌ ta xichꞌ jipanel ta cruz. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jech ti soldadoetique laj yiqꞌuic batel ta yamaqꞌuil cabilto ti Jesuse. Tey laj stsob sbaic scotol ti yan soldadoetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Laj yacꞌbeic slap cꞌuꞌil ti icꞌicꞌ losantic sba stsajale. Laj xojbeic xotbil chꞌix ta sjol. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Cꞌalal jech laj spasique, lic avanicuc ta naꞌlevanej: ―Jun avutsil ti ajvalilot yuꞌun ti Israele ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tey lic smajbeic sjol ta jun jichꞌil teꞌ. Laj stubtaic. Xquejeletic xa ta spas sbaic ta yichꞌel ta mucꞌ yilel. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cꞌalal laj yoꞌntonic ta snaꞌleele, jaꞌ o tey lic sloqꞌuesbeic ti cꞌuꞌil ti icꞌicꞌ losantic sba stsajale. Laj yacꞌbeic slap ti scꞌuꞌ onoꞌoxe. Tsꞌacal to un, ti soldadoetique laj yiqꞌuic loqꞌuel yoꞌ chba sjipanic ta cruz. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jaꞌ o tey tal jun vinic ti liquem talel ta Cirene banomile ti Simón sbie, jaꞌ stotic ti Alejandroe, ti Rufoe. Cꞌalal tey iꞌechꞌe, tey laj sujic ta xcuchel batel scruzal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tey icꞌbil ibat ti Jesuse ta jun vits ti jaꞌ Gólgota sbie. Jaꞌ yavil sbaquil jolal, xi ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tey laj yacꞌbeic yuchꞌ ti Jesuse jun chꞌail pox ti capal ta mirrae. Pero ti Jesuse muꞌyuc laj yuchꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tey laj sjipanic ta cruz. Ti soldadoetique laj sqꞌuelic buchꞌu oy suerte yuꞌunic yoꞌ ta xvinaj buchꞌu junucal ta xichꞌbeic scꞌuꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cꞌalal laj sjipanic ta cruz ti Jesuse, baluneb ora icꞌluman. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ti sletrail sjol scruzal ti Jesuse ta xal cꞌu chaꞌal ti laj yichꞌ milele, jaꞌ jech ta xal: “Ti ajvalil yuꞌun Israele”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jaꞌ jech xtoc laj yichꞌ jipanel ta cruz chaꞌvoꞌ jꞌeleqꞌuetic, jun ta sbatsꞌi cꞌob, jun ta stsꞌet cꞌob. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ti jech taje, jaꞌ jech icꞌot ta pasel jech chac cꞌu chaꞌal ti tsꞌibabil ta scꞌop Diose: “Jun to chopol vinic ta xꞌilat ec”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ti buchꞌutic ta xꞌechꞌic teye, sjimolan xa sjolic ta xlabanvanic ti jech ta xalique: ―¿Bu ibat avuꞌun ti ta xaval ti ta xalilin ti temploe, ti ta oxib cꞌacꞌal ta xavaꞌan ta achꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Colta aba quic atuc. Yalan talel ti jech jipilot ta cruze ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Maꞌuc noꞌox taje. Jaꞌ jech xtoc ti banquilal paleetique, ti jchanubtasvanejetic yuꞌun ti mantale ta xlabanvanic ti jech ta xalbe sbaique: ―Laj scolta ti yane. Pero ti stuque mu xuꞌ ta scolta sba. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mi melel jaꞌ ti Cristoe, ti Ajvalil yuꞌun ti Israele, ti mi ta xquiltic ti ta syales sba ta cruze, ta melel umbi, ta jchꞌuntic ―xiic. Jaꞌ jech ta xnaꞌlevanic xtoc ti chaꞌvoꞌ ti jipilic ta cruze. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cꞌalal laj sta ti oꞌlol cꞌacꞌale, scotol ti banomile icꞌ icom. Ta oxib to ora mal cꞌacꞌal isacub. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti jech ora taje, jaꞌ o tsots iꞌavan ti Jesuse: ―Eloi, Eloi, ¿lama sabactani? ―xi. Dios cuꞌun, Dios cuꞌun, ¿cꞌu chaꞌal laj avictaun comel? xi ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oy jlom ti tey oyique laj yaꞌiic ti jech iꞌavan ti Jesuse. Jech lic yalic: ―Aꞌyio avaꞌiic, ta xavta talel ti jꞌalcꞌop Elíase ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Oy jun ta scotolic ibat ta anil. Laj stsꞌaj ta chꞌail pox ti esponjae. Tsꞌacal to laj xchuc ta niꞌ jichꞌil teꞌ ti esponjae. Tey laj stuchbe muyel yoꞌ ta xacꞌbe stsꞌutsꞌ ti Jesuse. Pero jech iꞌalbat yuꞌun ti yane: ―Chꞌan uto. Laꞌ jqꞌueltic quic mi ta xtal yalesatuc yuꞌun ti Elíase ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jech ti Jesuse jaꞌ o tsots iꞌavan. Tey icham. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ti mucꞌ ta cortina ti oy ta temploe, ijat. Lic tal sjatemal ta sjol cꞌalal to yoc. chaꞌlic icom. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ti banquilal soldado romano ti nopol vaꞌal ti bu oy ti Jesuse, cꞌalal jech laj yaꞌi ti cꞌu sꞌelan iꞌavane, ti cꞌu sꞌelan ichame, jech laj yal: ―Ta melel, ti vinic leꞌe jaꞌ Snichꞌon ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jaꞌ jech xtoc oy jun chib antsetic ti nom vaꞌajtic ta sqꞌuelic ti Jesuse. Ti bu oy ti antsetique, tey oy ti María Magdalenae, ti Salomee, ti María ti jaꞌ smeꞌ ti Jacoboe schiꞌuc ti Josee. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ti antsetic taje jaꞌic ti buchꞌutic laj stsꞌacliic batele schiꞌuc laj scoltaic ti Jesús cꞌalal ixanav to ox ta Galilea banomile. Pero maꞌuc noꞌox jech yepal ti antsetic taje. Oy to tey yan antsetic ti laj xchiꞌinic talel ti Jesús cꞌalal ital ta Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cꞌalal poꞌot xa xꞌicꞌube, jaꞌ o xa yorail ti ta xchapan sbaic ti jꞌisraeletic sventa ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tey ital jun vinic ti José sbie, ti liquem talel ta jteclum Arimateae, ti jaꞌ jun vinic ti yichꞌoj tsots yabtel sventa ti banquilal jchapanvanejetique. Jaꞌ jun vinic ti smalaoj onoꞌox ti ta xventainvan ti Diose. Tsots yoꞌnton iꞌoch batel ta stojol ti Pilatoe. Bat scꞌanbe sbecꞌtal ti Jesuse yoꞌ ta smuc. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ti Pilatoe chꞌayal icꞌot yoꞌnton ti jech icham xa ti Jesuse. Jech o xal laj sta ta iqꞌuel ti banquilal soldado yuꞌune yoꞌ ta sjacꞌbe mi jech ta melel ti icham xa ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cꞌalal laj yal ti banquilal soldado ti jeche, jech o xal ti Pilatoe laj yacꞌ ye ti acꞌo ba mucbatuc sbecꞌtal yuꞌun ti Josee. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jech o xal ti Josee laj sman jlic lequil mucꞌ ta saquil pocꞌ. Tey bat syalesbe sbecꞌtal ti Jesuse. Laj spix ta pocꞌ. Tsꞌacal to bat sticꞌ ta muquinal ti jombil ta tone. Laj smac ta ton stiꞌ ti muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ti María Magdalenae schiꞌuc ti María, smeꞌ ti Josee, laj yilic ti bu laj yichꞌ muquele. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cꞌalal iꞌechꞌ xa ti scꞌacꞌalil ti cuxob oꞌntonale, ti Maríae Magdalenae schiꞌuc ti Salomee, schiꞌuc ti María, smeꞌ ti Jacoboe, lic smanic perfume yoꞌ chba smalic ta sba sbecꞌtal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sob xa ta sliquebal cꞌacꞌal ti xemunae, tey icꞌotic ti bu mucule. Loqꞌuem xa tal ti cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Cꞌalal jech ta xanavic batel ti antsetique, jech lic yalbe sbaic: ―¿Buchꞌu xuꞌ ta sloqꞌuesbotic smac stiꞌ ti muquinale? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cꞌalal icꞌotique, laj yilic ti muꞌyuc xa macal ta mucꞌ ta ton stiꞌ ti muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tey iꞌochic batel ta yut. Jaꞌ o tey laj yilic chotol ta stuqꞌuil batsꞌi cꞌobal jun querem vinic ti slapoj nat saquil cꞌuꞌile. Ixiꞌic ti antsetique. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero ti stuque jech laj yal: ―Mu xaxiꞌic. Ti voꞌoxuque ta xasaꞌic ti Jesús ti Buchꞌu liquem talel ta Nazarete, ti laj yichꞌ jipanel ta cruze. Pero ichaꞌcuxi xa. Muꞌyuc xa liꞌ oye. Qꞌuel avil ti yav ti bu laj yaqꞌuique. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Batanic, ba albeic yaꞌi ti yajchancꞌoptaque schiꞌuc ti Pedroe ti jaꞌ baꞌyel ta xcꞌot ta Galilea banomil ti stuque. Tsꞌacal to ta xacꞌotic ti voꞌoxuque. Tey ta xavilic jech chac cꞌu chaꞌal ti laj yalboxuc onoꞌoxe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jech ti antsetique jatvil iloqꞌuic ta muquinal, yuꞌun xniclajetic xa ta xiꞌel. Muꞌyuc buchꞌu laj yalbeic, yuꞌun ta xiꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cꞌalal ichaꞌcuxi ti Jesuse sob ta sliqueb cꞌacꞌal ti xemunae, baꞌyel laj yacꞌ sba iluc ta stojol ti María Magdalenae, jaꞌ ti buchꞌu iloqꞌuesbat ti vucub pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ti stuque jaꞌ bat yalbe yaꞌi ti ichaꞌcuxi ti Jesuse ta stojol ti buchꞌutic jmoj ixanavic to ox schiꞌuque, ti buchꞌutic ta xꞌoqꞌuic yuꞌun ti at oꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cꞌalal laj yaꞌiic ti cuxul ti Jesuse, ti laj yil xa ti María Magdalenae, muꞌyuc laj xchꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsꞌacal to ti Jesuse yan o cꞌu sꞌelan laj yacꞌ sba ta ilel ta stojol ti chaꞌvoꞌ yajchancꞌop ti cꞌalal ta xanavic batel ta bee. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cꞌalal laj yilic ti chaꞌvoꞌique, bat yalbeic yaꞌi ti yan yajchancꞌoptaque. Pero muꞌyuc bu laj xchꞌunic xtoc. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tsꞌacal to ti Jesuse laj yacꞌ sba iluc ta stojol ti buluchvoꞌ yajchancꞌoptaque ti cꞌalal tey chotolic ta mexae. Laj sjajanta ta scoj ti mu xchꞌunic ti jech ichaꞌcuxie, ti toj yij ti yoꞌntonique. Jaꞌ ti muꞌyuc laj yichꞌbeic ta mucꞌ scꞌop ti buchꞌutic laj yilic ti chaꞌcuxiem xae. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ti stuque jech lic yal: ―Ti voꞌoxuque, batanic ta scotol banomil. Ba alic ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ti buchꞌutic ta xichꞌic ta mucꞌ ti lequil achꞌ cꞌope, ti ta xichꞌic voꞌ xtoque, ta staic coltael. Pero ti buchꞌutic mu xichꞌic ta mucꞌ ti lequil achꞌ cꞌope, ta onoꞌox stoj ti smulique. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ti buchꞌutic ta xiyichꞌicun ta muqꞌue, jaꞌ jech ti señail ta qꞌuelele: Ta jventa vuꞌun ta sloqꞌuesic ti pucujetique. Ta xcꞌopojic ta achꞌ cꞌopetic. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Manchuc mi ta stsaquic ta scꞌobic ti chonetique, manchuc mi ta xuchꞌic cꞌusiuc venenoal, muꞌyuc cꞌusi ta spasbatic. Jaꞌ jech xtoc cꞌalal ta scajan scꞌobic ta sba ti jchameletique, ta xcol yuꞌunic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cꞌalal laj yoꞌnton ta scꞌoponel ti yajchancꞌoptaque, jech ti Cajvaltic Jesuse iꞌicꞌat muyel ta vinajel. Bat chotluc ta sbatsꞌi cꞌob ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jech ti yajchancꞌoptaque iloqꞌuic batel ta yalel ta scotol banomil ti lequil achꞌ cꞌop ti jaꞌ colebale. Jaꞌ stuc ti Cajvaltique laj xchiꞌin batel ti yajchancꞌoptaque. Jech xtoc iꞌacꞌbatic smucꞌul stsatsal yoꞌ jech ta xvinaj ti jaꞌ scꞌop Dios ta spuquic ti yajchancꞌoptaque. Jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ep ti buchꞌutic laj yaqꞌuic persa ta tsꞌibael scꞌoplal ti cꞌusitic icꞌot ta pasel ta jtojoltique jech chac cꞌu chaꞌal laj xchanubtasotic ti buchꞌutic laj yilic ta sliquebale, ti laj scolta sbaic ta yalel ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Jaꞌ jech ti vuꞌun eque, naca sta xcholet laj jacꞌ lec talel scotol scꞌoplal ti cꞌu sꞌelan ilic talel ta sliquebe. Jech o xal un, Teófilo, ti lec xquil jbatique, lec ta xcaꞌi ti xcholet ta jtsꞌibabot tal ti cꞌusitic laj yichꞌ pasele, yo jech ta xanaꞌ lec ti jaꞌ melel ti cꞌu sꞌelan laj xa avichꞌ chanubtasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cꞌalal tiqꞌuil to ox ta ajvalil ti Herodes ti ta Judea banomile, tey nacal jun pale, Zacarías ti sbie. Jaꞌ jmoj ta xꞌabtej schiꞌuc ti jvocꞌ Abías sbie. Ti yajnile, jaꞌ sbiinoj Elisabet. Jaꞌ snitilulic talel ti pale Aarone. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ti schibalique lec xꞌilatic yuꞌun ti Diose. Jaꞌ ti laj spasbeic smantal ti Cajvaltic Diose. Jech o xal mu xuꞌ ta saꞌbat smulic yuꞌun ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero chꞌabal ti yalab snichꞌnabique. Yuꞌun mu snaꞌ xꞌalaj ti Elisabete. Jaꞌ jech xtoc meꞌel molic xa. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ti pale Zacaríase, oy jun cꞌacꞌal ti jaꞌ icꞌot yorail ti ta xichꞌ ta sventa ti yabtele schiꞌuc ti schiꞌiltaque ti ta xtunic yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ti cꞌalal jech ta sqꞌuel yorailic ti paleetique, jaꞌ icꞌot ta stojol ti Zacaríase ti ta xchicꞌ pom ta templo yuꞌun ti Cajvaltic Diose ti jaꞌ jech onoꞌox liquem yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cꞌalal yacal ta xchicꞌ ti pome, scotolic ti cristianoetique tey ta scꞌoponic Dios ta yamaqꞌuil ti temploe. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jaꞌ o tey laj yil ti Zacaríase, vaꞌal jun yajꞌángel ti Cajvaltique tey ta xocon altar chicꞌobil pom ti oy ta batsꞌi cꞌobe. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ti Zacaríase cꞌalal laj yil ti ángele, mu stacꞌ aꞌyeluc cꞌusi ta spas. Yuꞌun toj echꞌem ixiꞌ ta jmec. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ti ángele jech laj yal: ―Zacarías, mu xaxiꞌ. Yuꞌun ti Diose laj xa yaꞌi ti acꞌope. Ti avajnil Elisabete xlic xchiꞌin yol. Ta xavacꞌbe sbiin Juan. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Toj echꞌem noꞌox xamuyubaj yuꞌun. Xpatet avoꞌnton yuꞌun ti jech ta xvoqꞌue. Jaꞌ jech xtoc ep ti cristianoetique xmuyubajic ec ti cꞌalal ta xvoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yuꞌun ti anichꞌone ep ta xtun ta stojol ti Diose. Cꞌalal mu to bu ta xvoqꞌue, ventainbil onoꞌox yuꞌun ti Chꞌul Espíritue. Mu snaꞌ xuchꞌ yaꞌlel uva ti pajuneb xae, mi jaꞌuc pox. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta sventa ti stuque, ep ti jꞌisraeletique ta sutic talel ta stojol ti Dios yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti Juan taje, jaꞌ jbaꞌyej be yuꞌun ti Cajvaltique. Coꞌol yoꞌntonic, coꞌol xuꞌ yuꞌunic jech chac cꞌu chaꞌal ti jꞌalcꞌop Elíase. Ta scoꞌoltasbe yoꞌntonic ti totiletique schiꞌuc ti snichꞌnabique. Jaꞌ jech xtoc ta xchanubtas ta spasel cꞌusi lec ti buchꞌutic toyobbaique. Jaꞌ jech ta stuqꞌuibtasbe yoꞌntonic ti cristianoetique yoꞌ jech ta xichꞌic ta mucꞌ ti Cajvaltic ti cꞌalal ta xtale ―xi ti ángele. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ti Zacaríase jech laj sjacꞌbe ti ángele: ―¿Cꞌusi xcut ta jnaꞌ mi melel ti jech ta xcꞌot ta jtojole? Yuꞌun ti vuꞌune toj molun xa. Jaꞌ jech ti cajnil eque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ti ángele jech laj stacꞌ: ―Vuꞌun Gabrielun. Yajtunelun ti Diose. Jaꞌ laj stacun talel yoꞌ tal calbot avaꞌi ti lequil aꞌyeje. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero ta scoj ti mu xachꞌun ti cꞌusi laj calbote, macal ta xcom ave. Mu xuꞌ ta xacꞌopoj. Scotol ti vaꞌi sꞌelan laj calbot liꞌe, ta onoꞌox xcꞌot ta pasel ti cꞌusi ora yoraile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jaꞌ jech xtoc ti cristianoetique vaꞌajtic ta smalaic ti cꞌusi ora ta xlocꞌ talel ti Zacaríase. Jaꞌ jech xtoc labal ta xaꞌiic ti jalij xa ta jmec ti mu xlocꞌ talel ta temploe. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cꞌalal ilocꞌ talel ti Zacaríase, mu xa xuꞌ xcꞌopoj. Jech o xal jaꞌ o laj snaꞌic ti oy cꞌusi iꞌacꞌbat yil yuꞌun Dios ti ta temploe. Yuꞌun jaꞌ noꞌox ta spasolan señail ta scꞌob. Yuꞌun umaꞌ xa ilocꞌ talel. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cꞌalal echꞌ scꞌacꞌalil ti cꞌu sjalil xtunilan ta templo ti Zacaríase, tey ibat ta sna. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tsꞌacal to ti Elisabete lic xchiꞌin yol. Muꞌyuc xlocꞌ ta sna voꞌob u. Tey ta snopilan ta yoꞌnton: ");
INSERT INTO tzotzc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ti jech laj spasbun ti Cajvaltic avi tana liꞌe, yoꞌ jech mu xa ta xilabanat yuꞌun ti cristianoetique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cꞌalal echꞌ xa ox vaquib ue, ti Diose laj stac batel ti ángel Gabriel ta jteclum Nazaret ti oy ta Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ti ángele itacat batel ta stojol jun tojol tseb ti jaꞌ María sbie. Ti stuque jacꞌbil xa yuꞌun jun vinic, José sbi, ti jaꞌ snitilul ti ajvalil Davide. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ti ángele iꞌoch batel ti bu oye. Jech cꞌot yalbe: ―¿Mi liꞌ oyote ti voꞌot tꞌujbilot yuꞌun ti Diose, ti chiꞌinbilot yuꞌun ti Cajvaltic Diose? Toj echꞌem laj xa xcꞌuxubinot ti Diose. Jaꞌ mu sta ti yan antsetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cꞌalal jech laj yil ti ángele, chꞌayal icꞌot yoꞌnton yuꞌun ti scꞌopojele. Tey lic sjacꞌbe cꞌusi smelol ti jech iꞌalbate. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ti ángele jech itacꞌav: ―María, mu xaxiꞌ. Ti voꞌote laj xa ata ti lec xaꞌilat yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ti liꞌe xlic achiꞌin avol. Ta xꞌayan jun aquerem. Ta xavacꞌbe sbi Jesús. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tsots yabtel ta xichꞌ. Yuꞌun jaꞌ Snichꞌon ti cuxul Dios ta vinajele. Ti Cajvaltic Diose ta xacꞌbe yabtel yoꞌ ta xcom ta Ajvalil jech chac cꞌu chaꞌal ti amolmucꞌtotic David ta voꞌnee. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Muꞌyuc spajeb ti yabtel ti ta sventain ti jꞌisraeletique. Staoj o yav sbatel osil ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jech o xal ti Maríae jech lic sjacꞌbe ti ángele: ―¿Cꞌusi ta xcut ta xcꞌot ta pasel taje ti cꞌalal muꞌyuc to jmalale? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ti ángele jech itacꞌav: ―Ti Chꞌul Espíritue ta xtal ta atojol. Ti smucꞌul stsatsal ti Dios ti oy ta vinajele, ta svoliot jech chac cꞌu chaꞌal junuc toc. Jech o xal ti avol ti ta xavoqꞌuese chꞌul olol. Bisbil ta xcꞌot ta Snichꞌon ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jaꞌ jech ti avutsꞌ avalal, Elisabete, ta svoqꞌues yol ec. Manchuc mi meꞌel xa, manchuc mi oy bu iꞌalbat scꞌoplal ti mu snaꞌ xꞌalaje, pero oy xa svaquibal yual schiꞌuc ti yole. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yuꞌun ti Diose, muꞌyuc cꞌusi ti mu xuꞌ yuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jech o xal ti Maríae jech itacꞌav: ―Jechuc. Acꞌo smosovinun ti Cajvale. Acꞌo spasbun ti Diose jech chac cꞌu chaꞌal ti laj avalbune ―xi. Jaꞌ o tey ibat ti ángele. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ti jech cꞌacꞌal taje, ti Maríae ibat ta anil ta jun jteclum ti oy ta svitsal Judea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tey iꞌoch bal ta sna ti Zacaríase. Cꞌot scꞌopon ti Elisabete. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cꞌalal icꞌoponat ti Elisabete, tey lic bacuc ti olol ta schꞌute. Ti stuque iventainat yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jech o xal un, tsots jech laj yal: ―Ti Diose toj echꞌem laj xcꞌuxubinot. Jaꞌ mu sta ti yan antsetique. Ti avole toj echꞌem yichꞌoj bendición. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Buchꞌuun ti vuꞌune yoꞌ jech tal svuꞌlanun smeꞌ ti Cajvale? ");
INSERT INTO tzotzc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Xmuyubaj noꞌox lic bacuc ti col ta jchꞌut ti cꞌalal vul acꞌoponune. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Toj yan noꞌox yutsil ti jech laj achꞌune. Yuꞌun ta onoꞌox xcꞌot ta pasel ti cꞌusi laj yalbot ti Cajvaltic Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jech o xal ti Maríae jech laj yal: Xmuyubaj xa coꞌnton yuꞌun ti Cajvaltic Dios ta xcaꞌie. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Xmuyubaj noꞌox coꞌnton ta stojol ti Diose, ti Cajcoltavaneje. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yuꞌun ti Diose laj yichꞌun ta venta ti pobre yajmosovune. Scotol ti cristianoetic ti cꞌu yepal ti ta xꞌechꞌic liꞌ ta sba banomile ta xalic ti jcꞌoplal ti ximuyubaje. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yuꞌun ti Diose, ti scotol xuꞌ yuꞌune, toj echꞌem lec ti cꞌusitic laj spasbune. Yuꞌun jaꞌ Chꞌul Dios. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Staoj yav ta xcꞌuxubin scotol ti buchꞌutic ta xiꞌtaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Laj xa yacꞌ ta ilel ti yabtel ti tsots xuꞌ yuꞌune. Laj xa stsal ti buchꞌutic toj toyobbaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Laj xa specꞌtsan ti buchꞌutic cajal xaꞌi sbaique. Yan ti buchꞌutic ta snijan sbaique toyesatic xa. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ti buchꞌutic ta xviꞌnajique acꞌbatic ti cꞌusitic xtun yuꞌunique. Yan ti buchꞌutic jcꞌulejetique smeyoj scꞌobic iloqꞌuic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Laj scolta ti slumal Israele, ti jaꞌ yajtunele. Muꞌyuc laj xchꞌay ta yoꞌnton ti jech cꞌux ta xaꞌie. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yuꞌun jech onoꞌox yaloj ta stojol ti jtot jmeꞌtique, ta stojol ti Abrahame schiꞌuc ti yalab snichꞌnabtaque ti cꞌux ta xaꞌivan sbatel osile, xi ti Maríae. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ti Maríae nopol van oxibuc u ijocꞌtsaj ta sna ti Elisabete. Tsꞌacal to un, isut batel ta sna stuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsꞌacal to un, ista scꞌacꞌalil ti ta svoqꞌues yol ti Elisabete. Iꞌayan jun querem. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Cꞌalal laj yaꞌi ti slacꞌnataque schiꞌuc ti yutsꞌ yalaltac ti Elisabete, bat spatbeic yoꞌnton. Yuꞌun laj yaꞌiic ti icꞌuxubinat yuꞌun ti Cajvaltic Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cꞌalal yichꞌoj xa svaxaquibal cꞌacꞌale, bat yacꞌbeic yichꞌ circuncisión ti olole. Ti yutsꞌ yalaltaque ta scꞌanic ox ta xacꞌbe sbiin Zacarías jech chac cꞌu chaꞌal ti stote. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero ti smeꞌe jech laj yal: ―Moꞌoj, ta sbiin Juan ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pero ti stuquique jech laj yalic: ―¿Cꞌu chaꞌal? Yuꞌun muꞌyuc jech abiic taje ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jech o xal ti stuquique laj spasic señail ta stojol ti stot ti olole yoꞌ jech ta snaꞌic cꞌusi ta xacꞌbe sbiin. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ti totile laj scꞌan uni tenelteꞌ ti jech laj stsꞌibae: “Juan ta sbiin”, xi. Scotolic labal laj yaꞌiic ti jech taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta jech to yepal ijam ye ti Zacaríase. Tey lic yalbe slequilal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ti jech taje, más to chꞌayal icꞌot yoꞌntonic scotol ti slacꞌnataque. Jaꞌ jech xtoc scotol ti jnaclejetic ti ta svitsal Judea banomile, jaꞌ ta xalic ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Scotol ti buchꞌutic laj yaꞌiique ta snopilan ta sjacꞌolanbe sbaic ta jujun tal: ―¿Cꞌusi ta xlic spas ti olol taje? ―xiic. Yuꞌun laj yaꞌiic ti ta melel acꞌbil bendición yuꞌun ti Cajvaltic Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ti stot ti neneꞌe, jaꞌ ti Zacaríase, noj ta yoꞌnton ti Chꞌul Espíritue. Jech lic cꞌopojuc ti cꞌu sꞌelan iꞌacꞌbat snaꞌ yuꞌun ti Diose: ");
INSERT INTO tzotzc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Jun yutsil ti Dios yuꞌun ti jꞌisraeletique. Yuꞌun tal xa ta jtojoltic ti voꞌotic yalab snichꞌnabotique. Laj xa scoltaotic. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yuꞌun ti Diose laj xa yacꞌbotic jun mucꞌul Jcoltavanej ti iꞌayan tal ta jun snitilul ti ajvalil Davide, ti jaꞌ yajtunel to oxe. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yuꞌun jech onoꞌox yaloj ta sventa ti chꞌul jꞌalcꞌoptac ta voꞌnee: ");
INSERT INTO tzotzc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jaꞌ ta xispojotic ta yoc ta scꞌob ti cajcrontatic ti xtiꞌet sjolic ta jtojoltique. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yaloj xtoc ti ta xcꞌuxubin ti jmolmucꞌtotique, ti muꞌyuc ta xchꞌay ta yoꞌnton ti schꞌul trate ti laj spase. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ti jech liꞌe, jaꞌ icꞌot ta pasel ti trate ti jech onoꞌox albil ti jmolmucꞌtotic Abraham yuꞌun ti Diose, ti ");
INSERT INTO tzotzc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ta onoꞌox xiscoltaotic loqꞌuel ta scꞌob ti cajcrontatique, yoꞌ jech mu ta xiꞌeluc ta xcacꞌ jbatic ta tunel. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yuꞌun lecubtasbilotic, tuqꞌuibtasbilotic ta stojol ti jayib cꞌacꞌal cuxulotique. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ti voꞌote, Nichꞌon, yajꞌalcꞌop ti cajal Dios ta xabiine. Yuꞌun ti voꞌote, jbaꞌyej be ta xabat yuꞌun ti Cajvaltique. Ta xameltsanbe batel beetic yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta xavacꞌbe snaꞌ ti yalab snichꞌnabe ti ta staic perdón yuꞌun ti smulique, yoꞌ jech ta staic ti coltaele. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ta sventa ti oy scꞌuxul yutsil yoꞌnton ti Dios cuꞌuntique, jech o xal un, ta xacꞌbotic talel cꞌalal to toyol jun xojobal achꞌ cꞌacꞌal, yoꞌ ta xꞌacꞌbat saquilal osil ti buchꞌutic oyic ta icꞌal osile, ti oyic ta sqꞌueoval ti lajebale, yoꞌ ta xijyacꞌbotic quiltic batel sbelal ti lamajem coꞌntontique, xi ti Zecaríase. ");
INSERT INTO tzotzc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jech ti olole yantic xchꞌi batel. Jaꞌ jech xtoc yantic ta xꞌacꞌbat yip yoꞌnton yuꞌun ti Chꞌul Espíritue. Tey ibat nacluc ta xocol banomil. Tsꞌacal to un, laj yacꞌ sba ta ojtiquinel ta stojol ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Cꞌalal jaꞌ o tiqꞌuil ta banquilal ajvalil ti Augusto Cesare, laj yal mantal ti acꞌo yichꞌ tsacbel sbiic ti cristianoetic ti cꞌu yepal oy ta sjoylej banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sba to velta ti jech lic ti tsacob biile. Jaꞌ o icꞌot ta pasel ti cꞌalal tiqꞌuil ta gobernador ti Cirenio ti oy ta Siriae. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Scotolic tsots scꞌoplal chba yacꞌ ta tsaquel sbiic ti bu oy ti steclumalique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jech o xal ti Josee ilocꞌ batel ti ta jteclum Nazaret ti oy ta Galileae. Ibat ta jteclum Belén ti bu ivocꞌ ti Davide ti oy ta Judeae. Yuꞌun ti Josee jaꞌ snitilul ti Davide. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tey ibat ta Belén, ba yacꞌ ta tsaquel sbiic schiꞌuc ti Maríae, jaꞌ ti chapal xa scꞌoplal ti ta xicꞌ sbaique. Pero schiꞌuc xa ox ti yole. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ti cꞌalal tey xa oyic ta jteclum Belene, jaꞌ o ista scꞌacꞌalil ti ta xvocꞌ yol ti Maríae. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tey ivocꞌ ti sba yole. Laj svol ta uni pocꞌ. Tey ba xpuchꞌan ta yav sveꞌeb vacax. Jaꞌ ti muꞌyuc xocol laj staic ti bu ta xchꞌamunic ti nae. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti tey nopol ta Belene, oy jun chib jqꞌuelchijetic ti tey ta xꞌechꞌ yuꞌunic ti acꞌobale yoꞌ ta xchabi ti schijic ta osiltique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ta ora noꞌox laj yilic yajꞌángel ti Cajvaltique. Ti stuquique joyobtabilic icꞌotic ta yutsilal xojobal ti Cajvaltique. Ep ixiꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ti ángele jech laj yal: ―Mu xaxiꞌic. Yuꞌun oy cꞌusi lec achꞌ tal calboxuc avaꞌiic, ti jaꞌ ta staic o smuyubajel yoꞌnton scotolique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yuꞌun ti liꞌe ivocꞌ xa jun Jcoltavanej avuꞌunic ta steclumal ti Davide, jaꞌ ti Cajvaltic Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ti señail ti ta xataic ti neneꞌe, tey volbil ta pocꞌ, puchꞌul ta sveꞌeb vacax ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta jliquel noꞌox jaꞌ o ivinaj talel ta vinajel ep yan schiꞌiltac ti ángele. Ti epal ángeletique jech ta xalbeic slequilal ti Diose: ");
INSERT INTO tzotzc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―Jun yutsil ti Dios ti oy ta vinajele. Acꞌo acꞌbatuc jun yoꞌnton ti cristianoetic liꞌ ta sba banomil ti buchꞌutic xmuyubajic ta stojole ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jech o xal un, cꞌalal sutic muyel ta vinajel ti ángeletique, ti jchabiejchijetique tey lic yalbe sbaic ta jujun tal: ―Batic un chaꞌe, ba jqꞌueltic ta Belén ti cꞌusi icꞌot ta pasele, ti jech laj yalbotic caꞌitic ti Cajvaltique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tey ibatic ta anil. Tey laj staic ti Maríae, ti Josee, ti olole puchꞌul ta sveꞌeb vacax. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cꞌalal laj yilic ti olole, tey laj yal sloꞌilic ti cꞌu sꞌelan iꞌalbatic yuꞌun ti ángele, scꞌoplal ti olole. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Scotol ti buchꞌu laj yaꞌiic ti cꞌu sꞌelan ta xalic ti jqꞌueljchijetique, chꞌayal icꞌot yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero ti Maríae mu xchꞌay ta yoꞌnton scotol taje. Tey onoꞌox ta snopilan. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ti jqꞌuelchijetique xmuyubajic xa ta xalbeic slequilal Dios ti cꞌalal isutic batele. Yuꞌun scotol ti cꞌusi laj yaꞌiique, ti cꞌusi laj yilique, coꞌol icꞌot ta pasel jech chac cꞌu chaꞌal iꞌalbatique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cꞌalal yichꞌoj xa svaxaquibal (8) cꞌacꞌal ti olole, laj yacꞌbeic yichꞌ circuncisión. Tey laj yacꞌbeic sbi Jesús jech chac cꞌu chaꞌal iꞌalbat ti María yuꞌun ti ángel cꞌalal muꞌyuc to ox xlic xchiꞌine. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cꞌalal itsꞌaqui scꞌacꞌalil ti ta xchabi sba ti Maríae jech chac cꞌu chaꞌal ta xal smantal ti Moisese, tey laj yiqꞌuic batel ti olol cꞌalal to jteclum Jerusalén, yoꞌ ta xba yacꞌbeic sventain ti Cajvaltic Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jaꞌ jech laj spasic taje, yuꞌun jech tsꞌibabil ta scꞌop ti Cajvaltic Diose: “Scotol ti ba olol ti jaꞌ querem xlaj vocꞌuque, jaꞌ xtun cuꞌun”, xi ti Cajvaltic Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jaꞌ yuꞌun un, jech ibatic, bat yacꞌbeic smoton ti Diose jech chac cꞌu chaꞌal tsꞌibabil ta smantale: “Acꞌo yichꞌel batel chaꞌcot toltora, mi moꞌoje, chaꞌcot paloma”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti jech taje, jaꞌ o tey nacal ta Jerusalén jun lequil vinic ti sbiinoj Simeone, ti jaꞌ xrioxinoj o ti Diose, ti smalaoj scoltaelic ti jꞌisraeletique. Ti Chꞌul Espíritue oy ta stojol ti Simeone. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jaꞌ jech xtoc iꞌacꞌbat snaꞌ ti muꞌyuc to ta xcham ti mi mu ta xilbe sat ti Cristo ti ta xtacat talel yuꞌun ti Cajvaltic Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ti Simeone iꞌicꞌat batel ta templo yuꞌun ti Chꞌul Espíritue. Jaꞌ jech xtoc ti stot smeꞌ ti neneꞌ Jesuse yicꞌojic batel ta templo, yoꞌ jech ta spasic jech chac cꞌu chꞌal ta xal ti mantale. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jech ti Simeone tey laj spet ti olole. Jech lic yalbe slequilal ti Diose: ");
INSERT INTO tzotzc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Cꞌajval, xuꞌ xa jun coꞌnton ta xavacꞌ chamcun. Yuꞌun icꞌot xa ta pasel avuꞌun ti cꞌusi laj avalbe ti avajtunele. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yuꞌun laj xa quil ta jsat ti Jcoltavaneje ");
INSERT INTO tzotzc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ti laj atac talel ta stojol scotol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jaꞌ saquilal osil yuꞌunic ti maꞌuc jꞌisraeletique. Jaꞌ jech xtoc jaꞌ yichꞌel ta mucꞌ ti jꞌisraeletic ti jaꞌ anichꞌnabe, xi ti Simeone. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ti Josee schiꞌuc ti smeꞌ ti Jesuse toj elom noꞌox laj yaꞌiic ti vaꞌi sꞌelan laj yal ti Simeón ta stojol ti olole. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jech o xal ti Simeone laj yacꞌbe bendición ti olole. Tsꞌacal to jech laj yalbe ti Maríae, smeꞌ ti Jesuse: ―Qꞌuel avil, ti olol liꞌe jaꞌ sbainoj ti ep ta xbajic ti jꞌisraeletique. Mi moꞌoje, ta staic coltael. Jaꞌ señail svinajeb xtoc ti ep ta sbajique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jaꞌ yuꞌun un, jaꞌ jech ta xvinaj ti cꞌu sꞌelan ta snop ta yoꞌntonic ta jujun tale. Pero ti jech scotol taje, ti voꞌote, coꞌol sꞌelan cuchilu ta xtiꞌvan yipal ta avoꞌnton ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jaꞌ jech xtoc tey oy jun ants, Ana sbi, ti jaꞌ ta xal ti cꞌusi ta xꞌacꞌbat snaꞌ yuꞌun ti Diose. Ti Anae jaꞌ yantsil nichꞌon ti Fanuele, ti jaꞌ snitilul ti Aser sbie. Yayil xa ti Anae. Tseb to ox ti imalije. Vucub jabil laj yicꞌ sbaic schiꞌuc ti smalale. Tsꞌacal to icham ti smalale ");
INSERT INTO tzotzc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yichꞌoj xa chanib yoꞌvinic (84) jabil ti comem ta meꞌonal antse. Tey onoꞌox oy ti ta temploe. Tey ta xtunilan yuꞌun ti Cajvaltic Dios ta cꞌacꞌal acꞌobale. Ta scomtsan yot. Ta sta ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jaꞌ o tey icꞌot ti Anae. Tey laj yal: “Colaval”, xut ti Diose. Tsꞌacal to un, tey lic yalbe scꞌoplal ti neneꞌ Jesús ta stojol scotol ti tey ta Jerusalene, jaꞌ ti buchꞌutic smalaojic ti ta xcolique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cꞌalal laj spasic scotol ti cꞌusi ta xal smantal ti Cajvaltic Diose, tsꞌacal to un, isutic batel ta steclumalic ta Nazaret ti oy ta Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ti Jesuse yantic jujun cꞌacꞌal ta xchꞌi. Lec tsots, lec bij ichꞌi talel, jaꞌ ti ta xꞌacꞌbat ep bendición yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ti stot smeꞌ ti Jesuse stalelic onoꞌox ti ta xbatic ta qꞌuin Colel jujun jabil ti tey ta Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cꞌalal yichꞌoj xa lajcheb (12) jabil ti Jesuse, jmoj ibatic ta Jerusalén schiꞌuc ti stot smeꞌe, jaꞌ ti jech stalelic ti ta xbatic ta qꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cꞌalal laj ti qꞌuine, ti Josee schiꞌuc ti Maríae isutic batel ta snaic. Pero muꞌyuc laj sqꞌuelic mi tey schiꞌuquic batel ti Jesuse. Tey icom ta Jerusalén. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cꞌalal oyic ta bee, jech o xal jech laj yal ta yoꞌntonic: “Tey nan bu nabal ta xtal ta stojol yan cristianoetic”, xiic. Jech o xal sjunul yoꞌntonic tey ixanavic jun cꞌacꞌal. Cꞌalal laj yilic ti chꞌabale, jaꞌ o tey lic sjaqꞌuic, lic saꞌic ta stojol ti yutsꞌ yalaltaque schiꞌuc ti buchꞌu xojtiquinique. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero muꞌyuc laj staic. Jech o xal sutic batel ta Jerusalén. Bat saꞌic tey. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta yoxibal to cꞌacꞌal tey laj staic ta templo. Tey chotolic schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. Tey ta xaꞌi ti cꞌusi ta xalique. Tey ta sjacꞌolan xtoc ti cꞌusi smelole. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tey scotolic ta xchꞌay yoꞌntonic ta yaꞌyiel ti cꞌu sꞌelan ta xtacꞌave schiꞌuc ti cꞌu sꞌelan ti sbijile. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cꞌalal laj yilic ti stot smeꞌe, chꞌayal icꞌot yoꞌntonic. Ti smeꞌe jech laj yal: ―Col, ¿cꞌu chaꞌal ti jech apasbuncutique? Ti vuꞌun schiꞌuc ti atote ep laj cat coꞌntoncutic ta saꞌelot ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ti Jesuse jech itacꞌav: ―¿Cꞌu chaꞌal ta xasaꞌicun? ¿Mi mu xanaꞌic ti jaꞌ tsots scꞌoplal ta xcaꞌi ti ta jpasbe yabtel ti Jtote? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ti stot smeꞌe muꞌyuc laj yaꞌibeic smelol ti jech laj yale. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jech o xal jmoj isutic batel ta Nazaret. Lec laj xchꞌunbe smantal ti stot smeꞌe. Pero ti smeꞌe mu xchꞌay ta yoꞌnton scotol ti cꞌusi iꞌalbate. ");
INSERT INTO tzotzc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Cꞌalal ichꞌi xa tal ti Jesuse, oy sbijil. Lec ilbil yuꞌun ti Diose schiꞌuc scotol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ti ta syoꞌlajunebal (15) xa ox jabil yochel ta ajvalil ti Tiberio César ti tey ta jteclum Romae, ti ta Judeae jaꞌ o ochem ta gobernador ti Poncio Pilatoe. Ti ta Galileae jaꞌ o ochem ta gobernador ti Herodese. Ti ta Itureae schiꞌuc ti Traconitee jaꞌ o ochem ta gobernador ti Felipee, ti jaꞌ yitsꞌin ti Herodese. Ti ta Abiliniae jaꞌ o ochem ta gobernador ti Lisaniase. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ti ta jteclum Jerusalene jaꞌ o ochemic ta banquilal paleetic ti Anase schiꞌuc ti Caifase. Jaꞌ o yorail ti icꞌoponat yuꞌun Dios ti Juane, ti jaꞌ snichꞌon ti pale Zacaríase, ti oy ta xocol banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jech o xal ti Juane iꞌechꞌ ta scotol ti banomil ti nopol ta tiꞌ ucum Jordane. Ta xalbe yaꞌiic ti cristianoetique ti acꞌo yichꞌic ti voꞌe, ti acꞌo yictaic ti chopol yoꞌntonique, yoꞌ jech ta staic perdón yuꞌun ti smulique. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ti jech taje, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal laj stsꞌiba comel ti jꞌalcꞌop Isaíase: Oy buchꞌu tsots ta xcꞌopoj ta xocol banomil ti jech ta xale: “Jambeic tuqꞌuil be ti Cajvaltique. Meltsanbeic lec sbe. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Scotol ti yemeltique ta xichꞌ nojesel. Scotol ti bu slomol spulul ti vitsetique ta xichꞌ pasel ta parejo. Scotol ti beetic ti bu xotajtique ta xichꞌ tuqꞌuibtasel. Scotol ti be ti bu lomajtique ta xichꞌ pasel ta parejo. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Scotol ti cristianoetique ta xilic ti coltael ti ta xacꞌ ti Diose”, xi ti buchꞌu ta xꞌavane, xi ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Cꞌalal ta xloqꞌuic batel yoꞌ ta xichꞌic voꞌ yuꞌun ti Juane, jech ta xꞌalbatic: ―Snichꞌnab jtiꞌval chon, ¿buchꞌu laj yalboxuc avaꞌiic yoꞌ ta xapoj abaic yuꞌun ti tsots castigo ti nopol xa xtale? ");
INSERT INTO tzotzc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pasic ti cꞌusi leque yoꞌ ta xvinaj ti jelbil ti atalelique. Maꞌuc noꞌox ta xavalic: “Ti vuꞌuncutique snitiluluncutic Abraham”, ti xachiique. Yuꞌun ta xcalboxuc avaꞌiic, ti tonetic liꞌe xuꞌ ta xjoybij ta snitilul Abraham yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yuꞌun chapal xa ti eqꞌuele yoꞌ ta xichꞌ bojel ti teꞌetique. Scotol ti teꞌetic ti bu mu lecuc ti sate, ta xichꞌ bojel. Ta xichꞌ chiqꞌuel ta cꞌocꞌ ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jech o xal ti cristianoetique jech laj sjacꞌbeic: ―¿Cꞌusi scꞌan ta jpascutic un chaꞌe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ti Juane jech itacꞌav: ―Ti buchꞌu oy chaꞌlic ti scꞌuꞌe, acꞌo yacꞌbe jlic ti buchꞌu chꞌabal yuꞌune. Ti buchꞌu oy sveꞌele, acꞌo xchꞌac yoꞌ ta xacꞌbe ti buchꞌu chꞌabal yuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jaꞌ jech xtoc tey italic jun chib ti jcꞌanpatantaqꞌuinetique yoꞌ ta scꞌanic ichꞌvoꞌ. Jech laj sjacꞌbeic ti Juane: ―Jchanubtasvanej, ¿cꞌusi scꞌan ta jpascutic ec? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ti Juane jech laj stacꞌbe: ―Jaꞌ noꞌox xatsobic ti patan ti cꞌu yepal ta xal ti mantale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jaꞌ jech xtoc tey italic jun chib soldadoetic. Tey lic sjaqꞌuic: ―Ti vuꞌuncutique, ¿cꞌusi scꞌan ta jpascutic? ―xiic. Ti Juane jech itacꞌav: ―Mu xasibtasvanic. Mu me xajutbeic smul ti muꞌyuc cꞌusi spasojique. Mu xapojic ti cꞌusi oy yuꞌunique. Junuc avoꞌntonic ti cꞌu yepal ta xavichꞌic tojole ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Scotol ti cristianoetique ta xloꞌilaj yoꞌntonic, ta snopic: “Ti Juan leꞌe jaꞌ van ti Cristoe”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero ti Juane jech laj yalbe scotol ti cristianoetique: ―Ti vuꞌune, voꞌ noꞌox ta xcacꞌ avichꞌic. Pero ti Buchꞌu ta to xtale, ta xacꞌboxuc avichꞌic ti Chꞌul Espíritue ti coꞌol sꞌelan cꞌoqꞌue. Ti stuque jaꞌ más tsots xuꞌ yuꞌun. Jaꞌ mu sta ti vuꞌune. Mi jaꞌuc xuꞌ cuꞌun sjitunbel ti yaqꞌuil xonobe, jaꞌ ti muꞌyuc jlequilale. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yuꞌun stsacoj xa ti yicꞌaobil strigoe. Ta stꞌujbe loqꞌuel ti scꞌaꞌepale yoꞌ stuc xa ti trigo ta xcome. Ti trigo ti tꞌujbil xae ta sqꞌuej ta yavil. Yan ti scꞌaꞌepale ta xchicꞌ ta cꞌocꞌ ti bu mu xtube ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jaꞌ jech sꞌelan laj yal ti Juane. Pero oy to ep yan laj sbijubtas ti cristianoetic ti cꞌalal ta xalbe ti lequil achꞌ cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jaꞌ jech xtoc ti Juane laj sjajanta ti ajvalil Herodese, ta scoj ti laj yicꞌ ti Herodíase, ti jaꞌ yajnil ti yitsꞌine, jaꞌ ti Felipee, schiꞌuc ti yan cꞌusi chopol laj xa spase. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero ti Herodese muꞌyuc laj yichꞌ ta mucꞌ ti cꞌusi iꞌalbate. Más to chopol lic spas. Laj sticꞌ ta chuquel ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cꞌalal mu to ta xcꞌot ta pasel taje, cꞌalal ta to xacꞌbe yichꞌ voꞌ cristianoetic ti Juane, jech ti Jesuse bat yichꞌ voꞌ ec. Cꞌalal tey ta sta ta cꞌoponel Dios ti Jesuse, jaꞌ o ijam ti vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jaꞌ jech xtoc iyal talel ta vinajel ti Chꞌul Espíritu ta stojol ti Jesuse jech chac cꞌu chaꞌal junuc paloma. Jaꞌ o oy Buchꞌu ivinaj scꞌopojel ta vinajel ti jech ta xale: ―Voꞌot ti jcꞌuxubinbil Nichꞌonote. Ximuyubaj xa ta atojol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ti Jesuse yichꞌoj nan lajuneb schaꞌvinic (30) jabil ti cꞌalal lic stsac ti yabtele. Ti stot ti Jesuse jaꞌ ti José ti xchunojique. Ti stot ti Josee jaꞌ ti Elie. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ti stot ti Elie jaꞌ ti Matate. Ti stot ti Matate jaꞌ ti Levie. Ti stot ti Levie jaꞌ ti Melquie. Ti stot ti Melquie jaꞌ ti Janae. Ti stot ti Janae jaꞌ ti Josee. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ti stot ti Josee jaꞌ ti Matatíase. Ti stot ti Matatíase jaꞌ ti Amose. Ti stot ti Amose jaꞌ ti Nahume. Ti stot ti Nahume jaꞌ ti Eslie. Ti stot ti Eslie jaꞌ ti Nagaie. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ti stot ti Nagaie jaꞌ ti Maate. Ti stot ti Maate jaꞌ ti Matatíase. Ti stot ti Matatíase jaꞌ ti Semeie. Ti stot ti Semeie jaꞌ ti Josee. Ti stot ti Josee jaꞌ ti Judae. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ti stot ti Judae jaꞌ ti Joanae. Ti stot ti Joanae jaꞌ ti Resae. Ti stot ti Resae jaꞌ ti Zorobabele. Ti stot ti Zorobabele jaꞌ ti Salatiele. Ti stot ti Salatiele jaꞌ ti Nerie. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ti stot ti Nerie jaꞌ ti Melquie. Ti stot ti Melquie jaꞌ ti Adie. Ti stot ti Adie jaꞌ ti Cosame. Ti stot ti Cosame jaꞌ ti Elmodame. Ti stot ti Elmodame jaꞌ ti Ere. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ti stot ti Ere jaꞌ ti Josuee. Ti stot ti Josuee jaꞌ ti Eliezere. Ti stot ti Eliezere jaꞌ ti Jorime. Ti stot ti Jorime jaꞌ ti Matate. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ti stot ti Matate jaꞌ ti Levie. Ti stot ti Levie jaꞌ ti Simeone. Ti stot ti Simeone jaꞌ ti Judae. Ti stot ti Judae jaꞌ ti Josee. Ti stot ti Josee jaꞌ ti Jonane. Ti stot ti Jonane jaꞌ ti Eliaquime. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ti stot ti Eliaquime jaꞌ ti Meleae. Ti stot ti Meleae jaꞌ ti Mainane. Ti stot ti Mainane jaꞌ ti Matatae. Ti stot ti Matatae jaꞌ ti Natane. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ti stot ti Natane jaꞌ ti Davide. Ti stot ti Davide jaꞌ ti Isaie. Ti stot ti Isaie jaꞌ ti Obede. Ti stot ti Obede jaꞌ ti Booze. Ti stot ti Booze jaꞌ ti Salmone. Ti stot ti Salmone jaꞌ ti Naasone. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ti stot ti Naasone jaꞌ ti Aminadabe. Ti stot ti Aminadabe jaꞌ ti Arame. Ti stot ti Arame jaꞌ ti Esrome. Ti stot ti Esrome jaꞌ ti Farese. Ti stot ti Farese jaꞌ ti Judae. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ti stot ti Judae jaꞌ ti Jacobe. Ti stot ti Jacobe jaꞌ ti Isaaque. Ti stot ti Isaaque jaꞌ ti Abrahame. Ti stot ti Abrahame jaꞌ ti Taree. Ti stot ti Taree jaꞌ ti Nacore. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ti stot ti Nacore jaꞌ Seruge. Ti stot ti Seruge jaꞌ ti Ragaue. Ti stot ti Ragaue jaꞌ ti Pelege. Ti stot ti Pelege jaꞌ ti Hebere. Ti stot ti Hebere jaꞌ ti Salae. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ti stot ti Salae jaꞌ ti Cainane. Ti stot ti Cainane jaꞌ ti Arfaxade. Ti stot ti Arfaxade jaꞌ ti Seme. Ti stot ti Seme jaꞌ ti Noee. Ti stot ti Noee jaꞌ ti Lameque. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ti stot ti Lameque jaꞌ ti Matusalene. Ti stot ti Matusalene jaꞌ ti Enoque. Ti stot ti Enoque jaꞌ ti Jarede. Ti stot ti Jarede jaꞌ ti Mahalaleele. Ti stot ti Mahalaleele jaꞌ ti Cainane. ");
INSERT INTO tzotzc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ti stot ti Cainane jaꞌ ti Enose. Ti stot ti Enose jaꞌ ti Sete. Ti stot ti Sete jaꞌ ti Adane. Ti stot ti Adane jaꞌ ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ti Jesuse noj ta yoꞌnton ti Chꞌul Espíritu ti cꞌalal ilocꞌ talel ta ucꞌum Jordane. Icꞌbil ibat yuꞌun ti Chꞌul Espíritu ta xocol banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tey ijalij chaꞌvinic (40) cꞌacꞌal, muꞌyuc iveꞌ. Tsꞌacal to lic yaꞌi viꞌnal. Jaꞌ o tey tal ti pucuje ta slajeltsabe yoꞌnton ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jech ti pucuje jech laj yal: ―Mi ta melel Snichꞌonot ti Diose, albo ti ton liꞌe ti acꞌo joybijuc ta pane ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ti Jesuse jech laj stacꞌbe: ―Ta xal ti tsꞌibabil ta scꞌop Diose: “Maꞌuc noꞌox ta pan ta xcuxi ti vinique. Jaꞌ ta xcuxi o ta jujubel ti scꞌop Diose”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tsꞌacal to un, ti pucuje tey laj yicꞌ batel ta jun toyol vits. Ta jliquel noꞌox laj yacꞌbe yil scotol yutsilal ti lumetic ti oy ta sjoylej banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ti pucuje jech laj yal: ―Ta xcacꞌbot sventain ti lumetic ti jun yutsiquil ta xavile. Yuꞌun jaꞌ acꞌbilun ta coc ta jcꞌob scotol. Xuꞌ ta xcacꞌbe ti buchꞌu ta jcꞌan ta xcacꞌbee. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ti mi ta xaquejan aba ta yichꞌelun ta muqꞌue, jaꞌ avuꞌun scotol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ti Jesuse jech laj stacꞌbe: ―Chꞌaco aba ta jtojol, Pucuj. Yuꞌun ta xal ti tsꞌibabil ta scꞌop Diose: “Jaꞌ noꞌox ichꞌo ta mucꞌ ti Dios avuꞌune. Jaꞌ noꞌox acꞌo aba ta tunel yuꞌun”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yan to velta ti pucuje tey laj yicꞌ muyel ta jol templo tey ta Jerusalene. Jech laj yal: ―Mi ta melel Snichꞌonot ti Diose, jipo aba yalel liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yuꞌun ti scꞌop Dios ti tsꞌibabile jech ta xal: Ti Diose ta xalbe mantal ti yajꞌángeltaque yoꞌ jech ta xchabiot. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ta snitot yalel ta scꞌobic yoꞌ mu xyayij avoc ta ton, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ti Jesuse jech laj stacꞌbe: ―Jech ta xal xtoc ti tsꞌibabil ta scꞌop Diose: “Mu xalajeltsabe yoꞌnton ti Dios avuꞌune”, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cꞌalal laj yil ti pucuj ti muꞌyuc xa cꞌusi jtosucal ti xuꞌ ta slajeltsabe yoꞌnton ti Jesuse, tey laj sqꞌuej sba batel cꞌuc sjalil. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ti Jesuse isut batel ta Galilea. Noj ta yoꞌnton smucꞌul stsatsal ti Chꞌul Espíritue. Buꞌyuc noꞌox ta xꞌalbat scꞌoplal ti Jesús ta sjoylejal ti lum teye. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ti Jesuse ta xchanubtasvan ta jujun chꞌul na. Scotolic xmuyubajic noꞌox yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jech o xal ti Jesuse ibat ta Nazaret jteclum ti bu ichꞌie. Iꞌoch batel ta chꞌul na ti cꞌalal scꞌacꞌalil ti cuxob oꞌntonale jech chac cꞌu chaꞌal ta spas onoꞌoxe. Tey ivaꞌi ta yavtael ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jaꞌ iꞌacꞌbat sqꞌuel ti vun ti laj stsꞌiba comel ti jꞌalcꞌop Isaíase. Cꞌalal laj sjame, jaꞌ laj sta ti jech tsꞌibabile: ");
INSERT INTO tzotzc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ti Chꞌul Espíritu yuꞌun ti Cajvaltique liꞌ oy ta jtojole. Jaꞌ ti laj xa stꞌujun ti Diose yoꞌ ta xcalbe ti lequil achꞌ cꞌop ti buchꞌutic abol sbaique. Laj stacun talel yoꞌ jech ta jpoxtabe yoꞌntonic ti buchꞌutic oyic ta vul oꞌntone. Tal calbe yaꞌiic scolelic ti buchꞌutic chucajtique. Jaꞌ jech xtoc tal jambe sat ti maꞌsatetique. Tal cacꞌbe scoltaelic ti buchꞌutic ilbajinbilique. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yuꞌun tal calbe yaꞌiic ti jaꞌ yorail ti ta staic ti cꞌuxubinel yuꞌun ti Cajvaltic Diose, xi ta xal ti scꞌop Dios ti bu laj yavta ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jech o xal ti Jesuse laj sbal ti vune. Laj yacꞌbe sutel ti buchꞌu ta xꞌabtej ta chꞌul nae. Tey lic chotluc. Scotol ti oyic ta chꞌul nae ta sqꞌuelolanic ta jmec ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ti stuque jech lic yal: ―Ta ora liꞌe cꞌot xa ta pasel ta atojolic ti cꞌusi tsꞌibabil ta scꞌop Dios ti laj cavtaboxuque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Scotolic lec ta xalbeic scꞌoplal ti Jesuse. Jaꞌ jech xtoc elom laj yaꞌiic ti cꞌu sꞌelan ti scꞌope. Pero jech ta sjacꞌbe sbaic xtoc: ―¿Mi mu jaꞌuc snichꞌon ti José leꞌe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ti Jesuse jech laj yal: ―Oy nan ta avoꞌntonic ta xavalbeicun jech chac cꞌu chaꞌal xꞌale ti cꞌope: “Jpoxtavanej, poxtao aba tuc”, ti xie. Mi moꞌoje, jech ta xaval: “Ti cꞌusi laj caꞌicutic ti laj apas ta jteclum Capernaume, jaꞌ noꞌox jech paso liꞌ ta ateclumal atuque”, xachiic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ti Jesuse jech to laj yal batel: ―Ta melel ta xcalboxuc avaꞌiic, muꞌyuc junucal jꞌalcꞌop ti ichꞌbil ta mucꞌ yuꞌun ti schiꞌiltac ti ta slumal stuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Jamal ta xcalboxuc avaꞌiic, liꞌ ta jlumaltic voꞌotic jꞌisraelotique oy ep meꞌonal antsetic ti cꞌalal cuxul to ox ti jꞌalcꞌop Elíase, ti cꞌalal muꞌyuc bu yacꞌ voꞌ oꞌlol schanibal jabile, ti mu noꞌox albajuc ti viꞌnal ta sjoylejal ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ti Elíase muꞌyuc bu itacat batel ta stojol mi jaꞌuc junuc ti meꞌonal antsetic ti liꞌ nacajtic ta Israele. Yuꞌun jaꞌ noꞌox itacat batel ti Elíase ta stojol jun jyanlum meꞌonal ants ti nacal ta jteclum Sareptae ti nopol ta xil sbaic schiꞌuc ti jteclum Sidone. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jaꞌ jech xtoc ep ti jcꞌaꞌemalchameletic liꞌ ta slumal Israel ti cꞌalal jaꞌ o ochem to ox ta jꞌalcꞌop ti Eliseoe. Pero muꞌyuc bu ay scolta junuc ti jchameletique. Jaꞌ noꞌox laj scolta ti jun jyanlum vinic Naamán ti nacal ta Siria banomile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cꞌalal jech laj yaꞌiic taje, scotolic ti tey ta chꞌul nae icap sjolic ta jmec. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jech o xal ivaꞌi scotolic. Laj sloqꞌuesic batel ta stiꞌ jteclum ti Jesuse. Laj yiqꞌuic batel xtoc cꞌalal to sjol jun vits yoꞌ jech ta sjipic yalel ti bu liclique ti by oy ti jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ti Jesuse tey iꞌechꞌ batel ta oꞌlol. Tey ibat. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jech o xal ti Jesuse tey ibat ta jteclum Capernaum ti oy ta Galilea banomile. Tey lic chanubtasvanuc ti cꞌalal jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Scotolic elom ta xaꞌiic ti cꞌu sꞌelan ta xchanubtasvane. Jaꞌ ti laj yacꞌ iluc ti tsots yichꞌoj ti yabtele. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti tey ta chꞌul nae oy jun vinic ti uninbil yuꞌun ti pucuje. Jech tsots iꞌavan: ");
INSERT INTO tzotzc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Chꞌan utuncutic. ¿Cꞌu chaꞌal ti jech xtal aticꞌ aba ta jtojolcutic, Jesús ti liquemot talel ta Nazarete? ¿Mi yuꞌun tal avilbajinuncutic? Ti vuꞌune xacojtiquinot lec. Jnaꞌoj lec ti tꞌujbilot yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ti Jesuse laj sjajanta ti pucuje. Jech laj yalbe: ―Chꞌan chan. Ictao comel ti vinic liꞌe ―xi. Jech ti pucuje laj sjip ta lum ti vinique tey ta stojol ti cristianoetique. Tey ilocꞌ batel ta stojol ti vinique. Muꞌyuc xa cꞌusi chopol ipasbat. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Scotolic ixiꞌic. Jech ta xalolanbe sbaic: ―¿Cꞌusi xut ti vinic leꞌe ti ta stsatsal noꞌox scꞌop ta stac loqꞌuel ti pucuje, ti ta xchꞌunbat ti scꞌope? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Buꞌyuc noꞌox ta jujot ipucbat batel scꞌoplal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jech ti Jesuse ilocꞌ batel tey ta chꞌul na. Tey iꞌoch batel ta sna ti Simone. Smeꞌniꞌ ti Simone tsots ip ta xaꞌi cꞌocꞌ. Tey laj scꞌanbeic vocol ti Jesuse ti acꞌo scolta ti jchamele. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ti Jesuse tey icuji batel ti bu puchꞌul ti jchamele. Laj spas loqꞌuel ta mantal ti cꞌoqꞌue. Ta ora noꞌox paj ti scꞌacꞌale. Tey lic malqꞌuinvanuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cꞌalal mal xa ti cꞌacꞌale, scotolic yicꞌojanic talel ta stojol Jesús ti yajchamelique ti cꞌusiuc noꞌox chamelal ta xaꞌiique. Jech ti stuque laj scajan scꞌob ta jujun tal. Jaꞌ jech colem icom scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jaꞌ jech xtoc oy ep ti jchameletique ti uninbil yuꞌun ti pucuje. Jech ta xꞌavanic ti cꞌalal ta xloqꞌuic xa batele: ―Voꞌot Snichꞌonot ti Diose ―xiic. Pero ti Jesuse laj sjajanta ti pucujetique. Muꞌyuc bu laj yacꞌ cꞌopojuc. Yuꞌun ti pucujetique snaꞌojic onoꞌox ti jaꞌ ti Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cꞌalal sacub xa ti osile, ti Jesuse ilocꞌ batel. Tey ibat ti bu stsꞌijlane. Pero ti cristianoetique tey lic saꞌic. Icꞌotic ti bu oye. Ta scꞌan ta spajes yaꞌiic yoꞌ jech mu xlocꞌ batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ti Jesuse jech laj yal: ―Yuꞌun tsots scꞌoplal ta xibat ta yan parte ta yalel ti ventainel yuꞌun ti Diose. Yuꞌun jaꞌ cabtel ti jech tacbilun talele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaꞌ jech ta xchanubtasvan echꞌel ta jujun chꞌul na ti tey ta Galileae. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Oy jun velta ti Jesuse tey oy ta tiꞌ nab Genesaret. Ep ta jmec ti cristianoetic ti tey icꞌot ta stojole. Snetꞌnetꞌ xa sbaic batel yoꞌ ta xaꞌiic ti lequil achꞌ cꞌop yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ti Jesuse laj yil ti oy chib barco xocajtic tey ta stiꞌil nabe. Jaꞌ ti loqꞌuemic batel ta barco ti jtsac-choyetique. Yuꞌun ta xchuqꞌuic ti stsacobil schoyique. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ti Jesuse tey iꞌoch batel ta jun barco ti jaꞌ yuꞌun ti Simone. Tey laj yalbe yaꞌi ti acꞌo och ochuc batel jutuc más ta yut nabe. Ti Jesuse tey lic chotluc ta barco. Tey lic xchanubtas ti cristianoetic ti tey oyic ta tiꞌ nabe. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cꞌalal laj cꞌopojuque, jech laj yalbe yaꞌi ti Simone: ―Xujic batel ti barco ti bu snatil ti nabe. Tey jipic yalel ti stsacobil achoyique yoꞌ jech ta xatsaquic ti choye ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ti Simone jech itacꞌav: ―Jchanubtasvanej, sjunul acꞌobal liꞌabtejcutic. Mi jcotuc laj jtsaccutic ti choye. Pero ti jech ta xaval mantale, ta jchꞌun ti cꞌusi ta xavale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cꞌalal jech laj spasique, tey noj talel ta choy ti stsacobil schoyique. Scꞌan xa ta xjat yaꞌi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jech o xal laj svelcꞌobtaic ti schiꞌiltac ti oyic ta yan barcoe yoꞌ xtal coltavanicuc. Tey laj snojesic ta choy ti chaꞌcot barcoe. Scꞌan xa ti ta xmutꞌij yaꞌi ti sbarcoique. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cꞌalal jech laj yil ti Simón Pedroe, tey laj squejan sba ta stojol ti Jesuse. Jech laj yal: ―Cajval, chꞌaco aba ta jtojol. Yuꞌun ti vuꞌune jsaꞌmulilun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yuꞌun ti Simone ta xiꞌ. Jaꞌ jech ta xiꞌic ti schiꞌiltac eque. Jaꞌ ti laj yilic ti toj ep laj stsaquic ti choye. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jaꞌ jech xtoc ixiꞌic ti Jacobe, ti Juane, ti jaꞌ snichꞌnab ti Zebedeoe, ti jaꞌ schiꞌil sbaic ta abtel schiꞌuc ti Simone. Pero ti Jesuse jech laj yalbe ti Simone: ―Mu xaxiꞌ, Simón. Avi tana liꞌe, ta xcacꞌ yan avabtel ta yiqꞌuel talel cristianoetic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Cꞌalal laj sloqꞌuesic batel ta tiꞌ nab ti sbarcoique, tey laj yictaic comel scotol. Bat xchiꞌinic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cꞌalal tey oy ta jun jteclum ti Jesuse, jaꞌ o tey icꞌot jun vinic ti tsacbil ta cꞌaꞌemal chamele. Cꞌalal laj yil ti Jesuse, tey lic spatan sba ta lumtic. Tey laj scꞌanbe vocol ti jech laj yale: ―Cajval, mi ta xacꞌane, xuꞌ ta xcol avuꞌun ti jchamele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jech ti Jesuse tey laj scajan scꞌob ta sba. Jech lic yalbe: ―Ta jcꞌan. Colem ta xacom ―xi. Cꞌalal jech laj yale, ta ora noꞌox sac chꞌay schamel ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ti Jesuse laj yalbe yaꞌi ti vinique ti mu me buchꞌu xalbe yaꞌie. Jech laj yal: ―Jaꞌ noꞌox batan, ba acꞌo aba ta ilel ta stojol ti palee. Ichꞌo batel ti matanal yuꞌun ti alecubtasele jech chac cꞌu chaꞌal ta xal smantal ti Moisese, yoꞌ jech ta snaꞌic scotolic ti colemot xa yuꞌun ti achamele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Scꞌoplal ti Jesuse, yantic xpuc batel más. Jech o xal ep ti cristianoetique ta stsob sbaic ta stojol yoꞌ ta xaꞌibeic ti scꞌope, yoꞌ ta xcoltaatic yuꞌun ti schamelique. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ti Jesuse tey ibat ti bu muꞌyuc ti cristianoetique yoꞌ ta sta ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Oy jun cꞌacꞌal ti ta xchanubtasvan ti Jesuse. Tey oy chotajtic jun chib jfariseoetic schiꞌuc jun chib jchanubtasvanejetic yuꞌun ti mantale ti liquemic tal ta jujun jteclum ti tey ta Galileae, ti ta Judeae, schiꞌuc ti ta Jerusalene. Ti smucꞌul stsatsal ti Diose laj yacꞌ ta ilel ta stojol ti Jesuse yoꞌ ta scoles ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jaꞌ o talic viniquetic ti tey spoyojic talel ta stem jun vinic ti pasem ta mochꞌe. Ta scꞌan ta xꞌochic yaꞌiic batel yoꞌ ta xaqꞌuic ta stsꞌel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero muꞌyuc bu laj staic ti bu xuꞌ ta xꞌochic batele, jaꞌ ti noj ta cristianoetique. Jech o xal tey imuyic batel ta jol na. Laj sloqꞌuesic ti texae. Tey laj xchechic yalel ta chꞌojon schiꞌuc stem ti jchamele. Tey icꞌot ta oꞌlol ti cristianoetic yoꞌ bu oy ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ti Jesuse cꞌalal laj yil ti xchꞌunojic ti xuꞌ ta xcol ti jchamele, jech laj yalbe ti jchamele: ―Ti voꞌote, chꞌaybil xa ti amule ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jech ti jfariseoetique, ti jchanubtasvanejetic yuꞌun ti mantale tey lic snopic: “¿Buchꞌu ti vinic liꞌe ti chopol ta xcꞌopoj ta stojol ti Diose? Muꞌyuc buchꞌu xuꞌ ta xchꞌay jmultic, jaꞌ noꞌox stuc ti Diose”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero ti Jesuse yiloj ti jech ta snopique. Jech o xal jech lic yal: ―¿Cꞌu chaꞌal jech ta xanopic ti voꞌoxuque? ");
INSERT INTO tzotzc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cꞌusi ti más lec ta alele? ¿Mi jaꞌ ti acꞌbilot xa perdón ti xie? ¿Mi jaꞌ ti lican, vaꞌlan batel ti xie? ");
INSERT INTO tzotzc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lec chaꞌe, ti vuꞌun ti coꞌol jꞌelantique ta xcacꞌboxuc avilic ti quichꞌoj cabtel liꞌ ta sba banomile yoꞌ ta xcacꞌbe perdón yuꞌun smulic ti cristianoetique ―xi. Jech o xal ti Jesuse jech lic yalbe ti vinic ti pasem ta mochꞌe: ―Ta xcalbot avaꞌi, lican. Tsaco batel ti ateme. Batan ta ana ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta ora noꞌox ilic ti mochꞌ ta sba ta sat scotolique. Tey laj yichꞌ batel ti steme. Xmuyubaj xa ta stojol ti Dios cꞌalal ibat ta snae. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Scotolic toj chꞌayal icꞌot yoꞌntonic. Ta xalbeic slequilal ti Diose. Jaꞌ jech xtoc ta xiꞌel jech laj yalic: ―Jaꞌ to laj quiltic o ti toj yan yutsil icꞌot ta pasele ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tsꞌacal to ti Jesuse ilocꞌ batel. Jaꞌ o tey laj yil jun jcꞌanpatantaqꞌuin ti Leví sbie. Tey chotol ti bu ta stojic onoꞌox ti patane. Jech laj yalbe: ―Tsacliun batel ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jech ti Levie tey ilic batel. Laj yicta comel scotol. Tey bat schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tsꞌacal to ti Levie tey laj spas jun mucꞌul qꞌuin ta sna sventa ti Jesuse. Jaꞌ jech xtoc tey oy ep yan jcꞌanpatantaqꞌuinetic schiꞌuc yantic ti jmoj chotolic ta mexa schiꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero ti jfariseoetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale lic stsaquic ta cꞌop ti yajchancꞌoptac ti Jesuse. Jech laj yalic: ―¿Cꞌu chaꞌal ti jmoj ta xaveꞌic ta xavuchꞌic voꞌ schiꞌuc ti jcꞌanpatantaqꞌuinetique, schiꞌuc ti jsaꞌmuliletique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ti Jesuse jech laj stacꞌbe: ―Mu scꞌanic jpoxtavanej ti buchꞌu lequique, ti muꞌyuc schamelique, jaꞌ noꞌox ti buchꞌu oy schamelique. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ti vuꞌune maꞌuc tal quicꞌ ti buchꞌu lequique. Jaꞌ noꞌox tal quicꞌ ti jsaꞌmuliletique yoꞌ jech ta xicta ti schopolalique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jech o xal un, ti stuquique jech laj sjacꞌbeic ti Jesuse: ―Ti yajchancꞌoptac ti Juane schiꞌuc ti yajchancꞌoptac ti jfariseoetique mu noꞌox albajuc ta scomtsan ti yotique yoꞌ ta scꞌoponic ti Diose. Pero ti avajchancꞌoptaque, ¿cꞌu chaꞌal ti jaꞌ noꞌox veꞌel uchꞌom ta spasique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ti Jesuse jech laj stacꞌbe: ―¿Mi yuꞌun xuꞌ ta xavacꞌbe yicta yotic ti buchꞌutic icꞌbilic ta qꞌuel nupunel ti cꞌalal tey to xchiꞌinojic ti jnupunele? ");
INSERT INTO tzotzc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero oy bu ta sta scꞌacꞌalil ti ta xꞌicꞌat batel ti jnupunel vinique. Jaꞌ to xlic yicta yotic umbi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jaꞌ jech xtoc lic yalbe yaꞌi jun babacꞌop ti jech ta xale: ―Muꞌyuc buchꞌu ta setic loqꞌuel jutebuc achꞌ cꞌuꞌil ti ta spaqꞌuic ta pocoꞌ cꞌuꞌile. Yan ti mi jech ta spase, ta xchꞌay ti achꞌ cꞌuꞌile. Jaꞌ jech xtoc ti juteb achꞌ cꞌuꞌile mu snupin o ti pocoꞌ cꞌuꞌile. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jaꞌ jech xtoc muꞌyuc buchꞌu ti ta sticꞌ ochel ta spocoꞌ-avil ti achꞌ yaꞌlel uvae. Yan ti mi jech ta spase, cꞌalal ta xpajub ti yaꞌlel uvae, ta xtꞌom ti spocoꞌ-avile. Ta xchꞌay ti yaꞌlel uvae. Ta xchꞌay ti yavil xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jech o xal un, ta scꞌan achꞌ ti yavile, achꞌ ti yaꞌlel uvae, yoꞌ lec ta xcom schibal. ");
INSERT INTO tzotzc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ti buchꞌu yuchꞌoj xa ti pasem yaꞌlel uvae, jaꞌ mu xa scꞌan xuchꞌ ti achꞌ yaꞌlel uvae. Yuꞌun jech ta xal: “Jaꞌ toj lec ti pasem xae”, xi ti vinique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Oy jun cꞌacꞌal ti jaꞌ scꞌacꞌalil cuxob oꞌntonale, jaꞌ o ti Jesuse schiꞌuc ti yajchancꞌoptaque tey ixanavic batel ti bu tsꞌunbil ti trigoe. Tey laj sbulic batel yoꞌ ta sjuꞌ xcꞌuxic ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oy jun chib jfariseoetic jech lic sjaqꞌuic: ―¿Cꞌu yuꞌun jech ta xaꞌabtejic ti cꞌalal mu stacꞌ cꞌusi ta jpastic ta scꞌacꞌalil ti cuxob oꞌntonale? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ti Jesuse jech laj stacꞌbe: ―Ti voꞌoxuque, ¿mi mu avilojic ti scꞌop Dios ti oy cꞌusi laj spas ti Davide ti cꞌalal ta xviꞌnajic schiꞌuc ti schiꞌiltaque? ");
INSERT INTO tzotzc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iꞌoch batel ta templo yuꞌun ti Diose. Laj stam ti chꞌul pane. Tey laj slajesic schiꞌuc ti schiꞌiltaque. Pero ti chꞌul pan taje, jaꞌ noꞌox xuꞌ ta sveꞌic ti paleetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ti Jesuse jech laj yal xtoc: ―Jaꞌ jech ti vuꞌun coꞌol jꞌelantique, vuꞌun jventainoj ti scꞌacꞌalil cuxob oꞌntonale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta yan xa cꞌacꞌal, ti jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale, ti Jesuse iꞌoch batel ta chꞌul na. Tey lic chanubtasvanuc. Tey oy jun vinic ti pasem ta mochꞌ ti sbatsꞌi cꞌobe. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ti jchanubtasvanejetic yuꞌun ti mantale schiꞌuc ti jfariseoetique ta spaꞌiic ti Jesuse. Ta sqꞌuel yilic mi ta scolta jchameletic ti ta scꞌacꞌalil ti cuxob oꞌntonale yoꞌ jech xuꞌ ta saꞌbeic smul. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ti Jesuse snaꞌoj xa ti jech ta snopique. Jech o xal jech lic yalbe ti vinic ti pasem ta mochꞌ ti scꞌobe: ―Lican. Laꞌ vaꞌlan liꞌ ta oꞌlole ―xut. Ti vinique tey tal vaꞌluc ta oꞌlol. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jech o xal ti Jesuse jech laj yalbe ti yane: ―Ta jacꞌ jbeluc acꞌopic. ¿Cꞌusi scꞌan pasel ti ta scꞌacꞌalil cuxob oꞌntonale? ¿Mi jaꞌ ti cꞌusi leque? ¿Mi jaꞌ ti chopole? ¿Mi jaꞌ lec ti ta xijcoltavane? ¿Mi jaꞌ lec ti ta xijmilvane? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jech ti Jesuse xjoyet sjol lic sqꞌuel ti cꞌu yepal tey tsobolique. Jech laj yalbe ti vinique: ―Xachꞌo talel ti acꞌobe ―xut. Jech ti vinique laj xachꞌ ti scꞌobe. Lec xa icom. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ti yantique toj echꞌem noꞌox isoc ti sjolique. Tey laj sjacꞌbe sbaic cꞌusi xuꞌ ta spasbeic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tsꞌacal to un, oy bu jun cꞌacꞌal ibat ta jun vits ti Jesuse. Ba sta ta cꞌoponel ti Diose. Sjunul acꞌobal tey laj sta ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cꞌalal sacub xae, laj yicꞌ talel ti yajchancꞌoptaque. Tey laj stꞌuj loqꞌuel lajchaꞌvoꞌ ti laj yacꞌbe yabtelic yoꞌ jech iꞌochic ta jcholcꞌopetic. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ti sbitac ti lajchaꞌvoꞌique jaꞌic liꞌe: Ti Simone, ti jaꞌ Pedro iꞌacꞌbat sbie. Ti Andrese, ti jaꞌ schiꞌil ta voqꞌuel ti Simone. Ti Jacoboe Ti Juane Ti Felipee Ti Bartolomee ");
INSERT INTO tzotzc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ti Mateoe Ti Tomase Ti Jacoboe, ti jaꞌ snichꞌon ti Alfeoe. Ti Simone, ti jaꞌ tiqꞌuil to ox ta partido cananistae. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ti Judase, ti jaꞌ schiꞌil ta voqꞌuel ti Jacoboe. Ti Judas Iscariotee, ti buchꞌu laj yacꞌ ta cꞌabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ti Jesuse tey iyalic talel ta vits schiꞌuc ti yajchancꞌoptaque. Tey icꞌotic ta jun stenlej. Tey tsobol laj staic ep cristianoetic ti liquemic tal ta Jerusalene, ti liquemic tal ta yan jteclumetic ti oyic ta Judea banomile, ti liquemic tal ta tiꞌ nab ti nopol ta chib jteclum ti Tiro schiꞌuc ti Sidone. Yuꞌun tal yaꞌibeic scꞌop ti Jesuse. Jaꞌ jech xtoc ta scꞌanic ti acꞌo coluc ti schamelique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ti buchꞌutic ta xꞌilbajinatic yuꞌun ti pucuje icoltaatic ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Scotol ti cristianoetique ta scꞌan ta sta yaꞌiic ta piquel ti Jesuse. Jaꞌ ti ta xcol scotolic ta sventa ti smucꞌul stsatsale. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jech ti Jesuse lic sqꞌuelbe sat ti yajchancꞌoptaque. Jech lic yal: ―Toj yan noꞌox yutsil ti voꞌoxuc meꞌonoxuque. Yuꞌun jaꞌ avuꞌunic ti ventainel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Toj yan noꞌox yutsil ti voꞌoxuc ti ta xavaꞌiic viꞌnale. Yuꞌun ta xataic ti jun avoꞌntonique. ’Toj yan noꞌox yutsil ti voꞌoxuc ti ta xaꞌoqꞌuique. Yuꞌun tsꞌacal to xlic muyubajanic. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Toj yan noꞌox yutsil ti voꞌoxuc ti cꞌalal crontainbiloxuque, ti cꞌalal tacbiloxuc loqꞌuele, ti cꞌalal ilbajinbiloxuque, ti cꞌalal bajbil abiic coꞌol sꞌelan chopoloxuc ta xaꞌilatic ta jventa ti coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Muyubajanic noꞌox. Patetuc noꞌox avoꞌntonic ti jech cꞌacꞌal taje. Yuꞌun ta xavichꞌic ti mucꞌ ta matanal ti oy ta vinajele. Yuꞌun jech onoꞌox laj spasic ti smolmucꞌtotic ti cristianoetic liꞌe, ti laj yilbajinic onoꞌox ti jꞌalcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero toj abol abaic ti voꞌoxuc ti jcꞌulejoxuque. Yuꞌun laj xa ataic ti xamuyubajique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Toj abol abaic ti voꞌoxuc ti muꞌyuc viꞌnal ta xavaꞌiic avi cꞌacꞌale. Yuꞌun xlic avaꞌiic viꞌnal. Toj abol abaic ti voꞌoxuc xatseꞌinic noꞌox avi cꞌacꞌale. Yuꞌun ta xlic ocꞌanic ta at oꞌnton. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Toj abol abaic ti voꞌoxuc ti lec albil acꞌoplalic avi liꞌe. Yuꞌun jech onoꞌox laj spasic ti smolmucꞌtotic ti cristianoetic liꞌe, ti lec icꞌopojic ta stojol ti chopol jꞌalcꞌopetique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ti Jesuse jech laj yal xtoc: ―Ti voꞌoxuc ti ta xavaꞌiic ti cꞌusi ta xcale, jech ta xcalboxuc avaꞌiic, cꞌuxubino avajcronta. Lec xapasic ta stojol ti buchꞌu xtiꞌet sjole. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cꞌanbeic slequil Dios ti buchꞌutic chopol ta xcꞌopojic ta atojolique. Cꞌoponbeic Dios ta stojolic ti buchꞌutic ta xayilbajinoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mi oy buchꞌu ta smajbot ti jot xocon asate, acꞌbo smaj ti jot xtoque. Mi oy buchꞌu ta spojbot batel ti acꞌuꞌe, acꞌo yichꞌ batel ti acoton xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mi oy cꞌusi ta scꞌanboxuque, acꞌbeic batel. Mi oy buchꞌu ta spojbot ti cꞌusi oy avuꞌune, mu me xasaꞌ cꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ti mi ta xacꞌan ti lec ti cꞌusi ta spasboxuc ti yane, lecuc me ti cꞌusi ta xapasic eque. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ti mi jaꞌ noꞌox ta xacꞌuxubinic ti buchꞌutic ta xcꞌuxubinoxuque, ¿cꞌusi ti lec ti ta xapasique? Yuꞌun ti buchꞌutic toj chopolique cꞌux ta xaꞌi sbaic ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ti mi jaꞌ noꞌox lec ta xapasic ta stojol ti buchꞌutic lec ta spasic ta atojolique, ¿cꞌusi ti lec ta xapasic taje? Yuꞌun ti buchꞌutic toj chopolique jech ta spasic ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ti mi jaꞌ noꞌox ta xavacꞌbeic xchꞌamun ti buchꞌutic ta xavaꞌiic ti ta sutesbote, ¿cꞌusi lec ta xapasic? Yuꞌun ti buchꞌutic toj chopolique jaꞌ jech ta xacꞌbe sbaic ta chꞌom, yuꞌun ta xaꞌi ti ta sutesbe sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero ti voꞌoxuque jaꞌ ta scꞌan ti ta xacꞌuxubinic ti avajcrontaique. Lec xapasic ta stojol. Acꞌbeic xchꞌamun ti cꞌusi xtun yuꞌunique, manchuc mi mu ta sutesbot. Ti mi jech ta xapasique, jech smucꞌul ti amotonic ta xavichꞌique. Jaꞌ jech xtoc yalab snichꞌnaboxuc ti Dios ti oy ta vinajele. Yuꞌun ti Diose toj yan noꞌox yutsil yoꞌnton ta stojol ti buchꞌutic toj chopolique, ti mu snaꞌ xal colaval ti xiique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jechuc me scꞌuxul avoꞌntonic jech chac cꞌu chaꞌal ti Jtotic Dios ti oy scꞌuxul yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Mu xasaꞌbeic smul ti yane, yoꞌ jech mu xataic chapanel yuꞌun ti Diose. Mu xavacꞌbeic stoj smul ti yane. Jech ti Diose mu xacꞌ atoj amulic ec. Aqꞌuic perdón. Jech ti Diose ta xacꞌboxuc perdón ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Acꞌbeic me ti cꞌusitic xtun yuꞌun ti yane. Jech ti Diose ta xacꞌboxuc ec. Ti cꞌusitic ta xacꞌboxuque, jun yutsil, tsinbil lec, lec nojem ti sbisole. Ti cꞌu sꞌelan ta xapasic ta stojol ti yane, jaꞌ jech ta spas ti Dios ta atojolique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ti Jesuse jech lic yal yan babacꞌop: ―¿Mi xuꞌ ta xtun jun maꞌsat ta yiqꞌuel batel ti yan maꞌsate? Ti mi jeche, ¿mi mu van jmojuc ta xbajic yalel ta lom chꞌen? ");
INSERT INTO tzotzc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ti buchꞌu ta xichꞌ chanubtasele, mu xcoꞌolaj schiꞌuc ti jchanubtasvanej yuꞌune. Jaꞌ to ti mi tsuts yuꞌun xchanele, jaꞌ to coꞌol ta xcꞌot jech chac cꞌu chaꞌal ti jchanubtasvanej yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Cꞌusi xavut ti ta xavil ti uni juteb cꞌaꞌep ti oy ta sat ti avermanoe cꞌalal mu xavil ti tey oy ti schumanil cꞌaꞌep ta asate? ");
INSERT INTO tzotzc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ti mi mu xavaꞌi ti tey oy schumanil cꞌaꞌep ta asate, ¿cꞌusi xuꞌ ti ta xavalbe ti avermanoe: “Ta jloqꞌuesbot ti juteb cꞌaꞌep ti oy ta asate”, ti xachie? Jecheꞌ ta xapacꞌta aba. Jaꞌ lec, loqꞌueso baꞌyel ti schumanil cꞌaꞌep ta asate. Jaꞌ yuꞌun umbi, jaꞌ to xuꞌ ta xavil lec yoꞌ jech ta xaloqꞌuesbe ti uni juteb cꞌaꞌep ti oy ta sat ti avermanoe. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Scotol ti lequil teꞌetique mu xuꞌ ta xacꞌ chopol ti sate. Jaꞌ jech xtoc ti chopol teꞌetique mu xuꞌ ta xacꞌ lec ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Stacꞌ ojtiquinel ti jujutos teꞌe ti cꞌu sꞌelan ta xacꞌ ti sate. Mu xuꞌ ta xacꞌ icux ti chꞌix teꞌe. Jaꞌ jech xtoc mu xuꞌ ta xacꞌ uva ti steꞌel macome. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ti lequil vinique, lec ti cꞌusi ta xale. Jaꞌ ti oy ta yoꞌnton ti leque. Ti chopol vinique, chopol ti cꞌusitic ta xalolane. Jaꞌ ti oy ta yoꞌnton ti chopole. Ti cꞌusitic ta xloqꞌuilan ta yeique, yuꞌun jaꞌ onoꞌox jech ta snop ti yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Cꞌu yuꞌun ta xavalbeicun: “Cajval, Cajval”, xachiic ti cꞌalal muꞌyuc ta xapasic ti cꞌusi ta xcale? ");
INSERT INTO tzotzc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ti buchꞌu ta xiyaꞌibe ti cꞌusi ta xcalbee, ti ta spasbun ti cꞌusi ta xcalbee, ta xcalboxuc avaꞌiic ti cꞌu sꞌelan ti vinic taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ti vinic taje coꞌol sꞌelan jech chac cꞌu chaꞌal jun vinic ti ta smeltsan ti snae. Pero baꞌyel laj sjombe lec nat ti yave. Tey lic stsacan lec ta ba ton ti yoc snae. Cꞌalal inoj talel ti ucꞌume, tey tsots ch-echꞌ spul ti nae. Pero muꞌyuc ibutqꞌuij yuꞌun. Jaꞌ ti lec tsacal ta ton ti sliquebe. ");
INSERT INTO tzotzc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ti buchꞌu ta xiyaꞌibe ti cꞌusi ta xcalbee, pero mi muꞌyuc ta spasbun ti cꞌusi ta xcalbee, coꞌol sꞌelan jech chac cꞌu chaꞌal jun vinic ti laj smeltsan ti sna ti ta ba lum noꞌoxe. Muꞌyuc laj yacꞌbe lec sliqueb. Cꞌalal inoj talel ti ucꞌume, tey tsots echꞌ spul ti nae. Ijin batel. Lilijem icom ta jꞌechꞌel ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cꞌalal laj yoꞌnton ti Jesus ta scꞌoponel ti cristianoetique, tey ibat ta jteclum Capernaum. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tey oy jun banquilal soldado romano ti oy jun yajꞌabtel ti toj lec scꞌanoje. Ti yajꞌabtele ip ta xaꞌi. Jutuc xa mu ta xcham. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ti banquilal soldadoe, cꞌalal laj yaꞌibe scꞌoplal ti Jesuse, laj stac batel jun chib moletic yuꞌun ti jꞌisraeletique, yoꞌ jech ta scꞌanbeic vocol ti Jesuse, ti acꞌo taluc scoltabe ti yajꞌabtele. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ti stuquique nopajic batel ta stojol ti Jesuse. Tey lic scꞌanbeic ep vocol ti jech laj yalbeique: ―Ti banquilal soldadoe ta scꞌan ti ta xacoltae. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yuꞌun ti stuque toj lec ta xiscꞌuxubinotic ti voꞌotic jꞌisraelotique. Jech o xal laj yal mantal ti laj yacꞌ ta meltsanel ti jchꞌul nacutique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jech ti Jesuse tey bat schiꞌuc ti jꞌicꞌvanejetique. Pero cꞌalal nopol xa scꞌan ta xcꞌotic ta nae, ti banquilal soldadoe laj stac talel jun chib schiꞌiltac ti jech tal yalbeic ti Jesuse: ―Cajval, mu xa xalubtsan aba. Yuꞌun jech laj yalbuncutic tal ti banquilal soldadoe: “Muꞌyuc jlequilal yoꞌ ta xaꞌoch ta jna. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jech o xal muꞌyuc ay quicꞌot talel jtuc. Jaꞌ noꞌox alo mantal. Jech ti cajꞌabtele ta xcol. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pasbilun ta mantal yuꞌun yan banquilal. Ti vuꞌun eque ta jpas ta mantal ti cajsoldadotaque. Mi ta xcalbe batan leꞌe, mi xcute, ta xbat. Laꞌ liꞌe, mi xcute, ta xtal. Ti cꞌusi ta xcalbe ti cajꞌabtele, ta spas”, xayut ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cꞌalal jech laj yaꞌi ti Jesuse, toj elom laj yaꞌi ti jech yoꞌnton ti vinique. Jech o xal lic sqꞌuel batel ti cristianoetic ti buchꞌutic schiꞌuc batele. Jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, muꞌyuc buchꞌu junuc jech jtaoj ti voꞌoxuc jꞌisraelal cristianooxuque ti jech toj ep xchꞌunojicun jech chac cꞌu chaꞌal ti vinic taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cꞌalal isutic batel ta na ti jun chib jtaquele, colem xa cꞌot staic ti jchamele. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tsꞌacal to ti Jesuse schiꞌuc ti yajchancꞌoptaque, schiꞌuc ti yan epal cristianoetique ibatic ta jun jteclum ti jaꞌ Naín sbie. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cꞌalal nopol xa scꞌan xcꞌot ta jteclume, laj yil ti poybil talel jun anima ti ta xba yichꞌ muquele, ti cꞌajomal jun yol ti meꞌunal antse. Tey xchiꞌinojic talel ep cristianoetic ti liquemic talel ta jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cꞌalal laj yil ti Cajvaltique, tey icꞌuxubaj yoꞌnton yuꞌun ti meꞌunal antse. Jech laj yalbe: ―Mu xaꞌocꞌ ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jech ti Jesuse inopaj batel. Tey lic scajan scꞌob ta sba ti scajonale. Ti jpoyivanejetique tey ivaꞌiic. Ti Jesuse jech laj yalbe ti animae: ―Querem, ta xcalbot avaꞌi, lican talel ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jech ti buchꞌu chamem xa oxe lic chotluc, lic cꞌopojuc. Jech ti Jesuse laj yacꞌbe batel ti smeꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cꞌalal jech laj yilique, scotolic tey lic xiꞌicuc. Jaꞌ jech xtoc tey lic yalbeic slequilal ti Dios ti jech laj yalique: ―Jun mucꞌ ta jꞌalcꞌop ivul ta jtojolcutic ―xiic. Jaꞌ jech ta xalic xtoc: ―Ti Diose tal xa scoltaotic ti yalab snichꞌnabotique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sjoylej Judea ivinaj ti jech laj spas ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti Juane laj yaꞌi ti jech taje. Yuꞌun iꞌalbat yuꞌun ti yajchancꞌoptaque. Jech o xal laj yicꞌ talel chaꞌvoꞌ yajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Laj stac batel ta stojol ti Jesuse yoꞌ ta sjacꞌbeic mi jaꞌ ta melel ti Cristo ti ta onoꞌox xtale, o mi ta to smalaic yan. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jech ti yajtacbolaltac ti Juane tey inopajic batel ta stojol ti Jesuse. Jech cꞌot yalbeic: ―Ti Juan jꞌacꞌ-ichꞌ-voꞌe laj stacuncutic talel yoꞌ ta jacꞌbotcutic, ¿mi voꞌot ti Cristoot ti albil onoꞌox scꞌoplal ti ta xatale, o mi ta to jmalacutic yan? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Cꞌalal jech tey oyique, ti Jesuse jaꞌ o yacal ta scolta epal cristianoetic ti ep ta tos ti schamelique, ti buchꞌutic ta xꞌilbajinatic yuꞌun ti pucuje, schiꞌuc ti ta xjam satic ti maꞌsatetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jech o xal ti Jesuse jech laj stacꞌbe: ―Batanic, ba albeic yaꞌi ti Juane ti cꞌusi laj avaꞌiique, ti cꞌusi laj avilique: “Ti maꞌsatetique xilic xa. Ti coxovetique ta xanavic xa. Ti jcꞌaꞌemal-chameletique colic xa yuꞌun ti schamelique. Ti jmacal-chiquinetique jam xa schiquinic. Ti animaetique ichaꞌcuxesatic xa. Ti buchꞌutic abol sbaique ta xichꞌic albel scꞌoplal ti lequil coltaele. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Toj jun yutsil ti buchꞌu mu xchibaj yoꞌnton ta jtojole”, xavutic ti Juane ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cꞌalal iloqꞌuic batel ti yajtacbolaltac ti Juane, jech ti Jesuse laj yalbe yaꞌi ti epal cristianoetic scꞌoplal ti Juane. Jech lic yal: ―¿Cꞌusi ay aqꞌuelic ti ta xocol banomile? ¿Mi jaꞌ jun aj ti xlaꞌet ta iqꞌue? ");
INSERT INTO tzotzc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ti mi maꞌuc une, ¿cꞌusi ay aqꞌuelic un chaꞌe? ¿Mi ay aqꞌuelic jun vinic ti jun yutsil ti scꞌuꞌe? Pero xanaꞌic lec ti voꞌoxuque, ti vinic ti buchꞌu jun yutsil ti scꞌuꞌe, jaꞌic noꞌox ti buchꞌutic xmuyubajic tey ta sna ti ajvaliletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jaꞌ yuꞌun un, ¿cꞌusi ay aqꞌuelic ta melel? ¿Mi jaꞌ jun jꞌalcꞌop? Jech melel, jaꞌ ay aqꞌuelic jun jꞌalcꞌop ti más to jelavem yuꞌunic ti yan jꞌalcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ti Juane, jaꞌ ti jun ti ta xꞌalbat scꞌoplal ti tsꞌibabil ta scꞌop Diose: Ta jtacbot jelavel cajꞌabtel ta atojol yoꞌ jech ta smeltsan abe, ti xi scꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta xcalboxuc avaꞌiic, ti ta scotol ti cristianoetique, jaꞌ noꞌox stuc ti Juan jꞌacꞌ-ichꞌ-voꞌe ti más cajale. Manchuc mi jech scꞌoplal ti Juane, pero ti buchꞌu ta xacꞌ sba ta ventainel yuꞌun ti Diose, acꞌo mi peqꞌuel, jaꞌ más cajal ta xcꞌot. Jaꞌ mu sta ti Juane ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cꞌalal jech laj yaꞌiique, scotol ti cristianoetique schiꞌuc ti jcꞌanpatantaqꞌuinetique ti iꞌacꞌbatic yichꞌic voꞌ yuꞌun ti Juane, jaꞌ o ivul ta yoꞌntonic ti yan yutsil yoꞌnton ti Dios ta stojolique. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ti jfariseoetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, ti muꞌyuc xꞌacꞌbat yichꞌic voꞌ yuꞌun ti Juane, laj sbajic ti cꞌusi ta scꞌan ta ox spas ti Dios ta stojolique. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ti Cajvaltique jech laj yal: ―¿Cꞌu sꞌelan ta jcoꞌoltasbe stalel ti cristianoetic avi tana liꞌe? ¿Cꞌusi xcoꞌolajic o? ");
INSERT INTO tzotzc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Coꞌol sꞌelan stalelic jech chac cꞌu chaꞌal ololetic ti ta xtajinic ta chꞌivit ti ta xavta ti jchop schiꞌilique: “Laj coqꞌuisancutic ti amae, pero ti voꞌoxuque muꞌyuc bu xaꞌacꞌotajic. Xmeꞌinaj xa liqꞌuejincutic, pero muꞌyuc bu xaꞌoqꞌuic”, xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Cꞌalal tal ti Juane, mu jmojuc stsobetic ta veꞌel ta uchꞌ voꞌ schiꞌuc ti yantique. Pero ti voꞌoxuque: “Ventainbil yuꞌun pucuj leꞌe”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tsꞌacal to un, lital ti vuꞌun coꞌol jꞌelantique. Laj avilic ti oy buchꞌutic laj jchiꞌin ta veꞌel ta uchꞌ voꞌe. Pero ti voꞌoxuque jech laj avalic ta jtojol: “Qꞌuel avil, toj echꞌem jveꞌel uchꞌ voꞌ. Lec xil sbaic schiꞌuc ti jsaꞌmuliletique schiꞌuc ti jcꞌanpatantaqꞌuinetique”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yan ti sbijil Diose tey ta xvinaj ta stojol ti buchꞌutic oy sbijilique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Oy jun ta scotol ti jfariseoetique laj yicꞌ ta veꞌel ti Jesuse. Tey ibat ti Jesuse. Tey cꞌot chotluc ta mexa. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti ta jteclum taje, tey nacal jun chopol ants. Cꞌalal laj yaꞌi ti ta xbat veꞌuc ti Jesús ta sna ti jfariseoe, tey yichꞌoj cꞌotel jun jarru ti meltsanbil ta alabastro ton ti noj ta perfumee. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Xꞌocꞌolet xa laj squejan sba ta yoc ti Jesuse. Ta yaꞌlel sat lic spocbe yacan. Tsꞌacal to ta stsatsal sjol laj staquijesbe. Tey lic sbutsꞌ. Tey lic smalbe ti perfume ta yacan ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cꞌalal jech laj yil ti jfariseo ti yicꞌoj batel ti Jesuse, jech lic snop: “Ti jaꞌuc jun yajꞌalcꞌop Dios ti vinic liꞌe, ta melel ta xaꞌi ti ta xpocbat yoc yuꞌun jun jmulivajel ants ti jechuque”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jech o xal ti Jesuse jech laj yalbe ti jfariseoe: ―Simón, oy cꞌusi ta xcalbot avaꞌi ―xi. Ti jfariseoe jech itacꞌav: ―Jchanubtasvanej, albun caꞌi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ti Jesuse jech lic yal: ―Oy chaꞌvoꞌ vinic ti oy yilic ta stojol jun vinic ti ta xacꞌ ta chꞌom ti staqꞌuine. Ti jun vinique oy yil voꞌob ciento (500) denario taqꞌuin. Ti jun vinic xtoque jaꞌ noꞌox lajuneb yoxvinic (50) denario taqꞌuin ti yile. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ti chaꞌvoꞌ viniquetique mu xa xtoj yuꞌunic ti yilique. Jech o xal ti buchꞌu ta xacꞌ ta chꞌom ti staqꞌuine laj xchꞌaybe ti yil schaꞌvoꞌalique. Jech o xal albun caꞌi, ¿buchꞌu junucal más scꞌanoj ti yajval taqꞌuine? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ti Simone jech laj stacꞌ: ―Ti ta xcaꞌie, jaꞌ más ta xcꞌanvan ti buchꞌu ichꞌaybat ep yile ―xi. Ti Jesuse jech lic yal: ―Oy arazon jech aval avaꞌuc ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jech ti Jesuse laj sqꞌuel batel ti antse. Jech lic yalbe ti Simone: ―¿Mi mu xavil ti ants liꞌe? Cꞌalal liꞌoch talel ta anae, muꞌyuc bu laj avacꞌbun voꞌ yoꞌ ta jpoc ti coque. Pero ti ants liꞌe, ta yaꞌlel sat laj spocbun ti coque. Jaꞌ jech xtoc laj staquijes ta stsatsal sjol. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ti voꞌote muꞌyuc bu xabutsꞌun ti cꞌalal liꞌoch talel liꞌ ta anae. Pero ti ants liꞌe, ti cꞌalal liꞌoch talele, mu xlaj yoꞌnton ta sbutsꞌel ti cacane. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ti voꞌote muꞌyuc bu laj avacꞌbun jutebuc aceite ta jol. Pero ti stuque laj smalbun ti perfume ta coque. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaꞌ yuꞌun un, ta xcalbot avaꞌi, ti jech toj ep cꞌuxun ta yoꞌnton ti ants liꞌe, jaꞌ svinajeb ti ta xaꞌi ti acꞌbil xa perdón yuꞌun ti ep smule. Pero ti buchꞌu jutuc noꞌox chꞌaybil ti smule, jutuc noꞌox ta svinajes scꞌuxul ti yoꞌntone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ti Jesuse jech lic yalbe ti antse: ―Scotol ti amule chꞌaybil xa ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ti buchꞌutic icꞌbilique, ti jmoj chotajtic schiꞌuc ti Jesuse, jech lic yalbe sbaic: ―¿Buchꞌu van ti vinic liꞌe ti xuꞌ ta xacꞌ perdón yuꞌun ti mulile? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero ti Jesuse jech laj yalbe yaꞌi ti antse: ―Lacol xa, jaꞌ ti laj achꞌunune. Batan. Junuc avoꞌnton ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsꞌacal to ti Jesuse ixanav batel ta epal jteclumetic schiꞌuc ta bicꞌtal jteclumetic. Tey ta xalolan batel ti ventainel yuꞌun ti Diose. Tey xchiꞌinoj batel ti lajchaꞌvoꞌ yajtacbolaltaque. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Jaꞌ jech xtoc schiꞌuc batel jayibuc antsetic, jaꞌic ti buchꞌutic icoltaatic yuꞌun ti schamelique, schiꞌuc xtoc ti uninbilic to ox yuꞌun ti pucuje. Ta scotol ti antsetique, tey oy ti María Magdalenae, jaꞌ ti buchꞌu iloqꞌuesbat ti vucub pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jaꞌ jech xtoc tey oy ti Juanae, yajnil ti Chuzae, ti jaꞌ jun vinic ti yichꞌoj ta sventa ti cꞌusi xꞌayan yuꞌun ti ajvalil Herodese. Jaꞌ jech xtoc tey oy ti Susanae schiꞌuc yan antsetic ti comon ta stsobic ti cꞌusitic oy yuꞌunique yoꞌ jech ta scoltaic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ep iloqꞌuic talel ti cristianoetic ti oyic ta jujun jteclume yoꞌ ta xba sqꞌuelic ti Jesuse. Cꞌalal ep xa stsoboj sbaique, tey lic chanubtasvanuc ta babacꞌop ti jech laj yal ti Jesuse: ");
INSERT INTO tzotzc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Oy jun vinic bat svij ti stsꞌunobale. Cꞌalal yacal ta svij batele, oy jlom icꞌot ta be. Laj yichꞌ pechꞌel ta teqꞌuel. Jech xtoc tal ti mutetique. Laj stam slajesic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oy jlom icꞌot ta ba tontic. Cꞌalal ivocꞌ talel ti tsꞌunobale, tey laj taquijuc. Jaꞌ ti muꞌyuc yox ti slumale. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oy jlom ti tsꞌunobale icꞌot ta chꞌixtic. Cꞌalal ichꞌi talel ti chꞌixetique, laj snetꞌ comel. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero jlom ti tsꞌunobale icꞌot ta lequil banomil. Lec ichꞌi talel. Lec laj yacꞌ sat. Oy jlom laj yacꞌ voꞌvinic (100) ta bej sat jujupets ti tsꞌunobaletique ―xi. Cꞌalal jech laj yal ti Jesús taje, tey tsots lic cꞌopojuc ti jech laj yal xtoque: ―Ti mi oy achiquinique, aꞌyic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jech ti yajchancꞌoptaque lic sjacꞌbeic ti cꞌusi smelol ti babacꞌop taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ti Jesuse jech laj yal: ―Ti voꞌoxuque, Dios ta xacꞌboxuc anaꞌic ti ventainel ti mucul to oxe. Pero ti yane, ta babacꞌop noꞌox ta xcalbe yaꞌiic yoꞌ jech mu xilic ti cꞌusi ta xilique, yoꞌ jech mu xaꞌiic ti cꞌusi ta xaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Jaꞌ jech smelol ti babacꞌope. Ti tsꞌunobale, jaꞌ smelol ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ti tsꞌunobal ti icꞌot ta bee, jaꞌ smelol ti oy jlom cristianoetic ti ta xaꞌiic ti scꞌop Diose. Pero ital ti pucuj ta stojolique. Tal pojbaticuc loqꞌuel ta yoꞌntonic yoꞌ jech mu xchꞌunic, yoꞌ jech mu xcolic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti tsꞌunobal ti icꞌot ta tontique, jaꞌ smelol ti oy jlom ti xmuyubajic ta xaꞌiic ti scꞌop Diose. Pero ta sventa ti muꞌyuc ayanem lec yibel ti scꞌop Dios ta yoꞌntonique, jech o xal ta xchꞌunic cꞌuc sjaliluc. Pero cꞌalal xtal ti lajeltsaele, ta xchibajic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ti tsꞌunobal ti icꞌot ta chꞌixtique, jaꞌ smelol ti oy jlom ti ta xaꞌiic ti scꞌop Diose. Pero staoj yav ti stalelique. Ta slubtsajic ta be yuꞌun ti sloꞌil yoꞌntonique, ti scꞌulejalique, ti cꞌusi ta scꞌanique. Jech o xal ta xchꞌay ta yoꞌntonic ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero ti tsꞌunobal ti icꞌot ta lequil banomile, jaꞌ smelol ti jlom ti ta sjunul yoꞌntonic ta xaꞌiic, ta xichꞌic ta mucꞌ ti scꞌop Diose. Staoj yav jun yoꞌntonic. Jech o xal lec ta xtunic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Muꞌyuc buchꞌu junucal ti cꞌalal ta stsan ti lamparae, ti ta smacbe ti xojobale. O mi moꞌoje, ta xba sticꞌ ta yolon tem. Moꞌoj, mu jechuc. Ta scajanic lec ta toyol yoꞌ ta xacꞌ lec ti xojolbale, yoꞌ ta xilic lec ti buchꞌutic ta xꞌochic ta yut nae. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Muꞌyuc cꞌusi macal ta xcom ti mu xvinaje. Muꞌyuc cꞌusi ta mucul ti mu xichꞌ naꞌele. Ta xvinaj. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Jech o xal un, aꞌyic lec ti scꞌop Diose. Yuꞌun ti buchꞌu ta xaꞌie, ta xꞌacꞌbat snaꞌ más. Pero ti buchꞌu mu tsotsuc scꞌoplal ta xaꞌie, muꞌyuc cꞌusi ta xꞌacꞌbat snaꞌ. Cꞌajomal ta xpojbat loqꞌuel ti cꞌu yepal xchꞌunoje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Smeꞌ ti Jesuse schiꞌuc ti yitsꞌinabtaque tey icꞌotic ti bu oye. Pero mu xuꞌ xꞌochic batel. Yuꞌun toj ep ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pero oy buchꞌu ba yalbe yaꞌi ti Jesuse: ―Ti ameꞌe schiꞌuc ti avitsꞌinabtaque tey oyic ta pana. Ta scꞌan ta scꞌoponot yaꞌiic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ti Jesuse jech laj stacꞌbe: ―Ti buchꞌu ta xaꞌiic ti scꞌop Diose, ti ta spasic ti cꞌusi ta xale, jaꞌ jmeꞌ, jaꞌ quitsꞌinabtac ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Oy jun cꞌacꞌal ti Jesuse iꞌochic batel ta barco schiꞌuc ti yajchancꞌoptaque. Jech laj yal: ―Batic ta jot stiꞌil nab ―xi. Jech ibatic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cꞌalal tey ta xanavic batel ta barcoe, tey lic vayuc ti Jesuse. Ta jech to yepal tey lic tsots icꞌ. Scꞌan xa ta xnoj ta voꞌ ti barcoe. Xiꞌbal xa sba ti ta xmutꞌij yalele. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jech o xal ti yajchancꞌoptaque ba stijic ti Jesuse. Jech laj yalic: ―Jchanubtasvanej, Jchanubtasvanej, ta xa xijmutꞌijotic ―xiic. Ti Jesuse tey ivaꞌi. Laj spajes ti iqꞌue, ti nabe. Paj scotol. Tsꞌijil icom ta jꞌechꞌel. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―¿Bu ibat avuꞌunic ti achꞌunojicune? ―xi. Pero ti stuquique tey ixiꞌic. Chꞌayal icꞌot yoꞌntonic. Tey lic sjacꞌolanbe sbaic ta jujun tal: ―¿Buchꞌu van ti vinic liꞌe ti ta xchꞌunbat smantal yuꞌun ti iqꞌue, ti nabe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tsꞌacal to un, icꞌotic ta jot stiꞌil nab yelobal Galilea ti jaꞌ slumal Gadarae. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cꞌalal yal ta barco ti Jesuse, jaꞌ o inopaj tal jun vinic ti liquem talel ta jteclume. Ti vinique oy xa ep scꞌacꞌalil ti ta xꞌilbajinat yuꞌun ti pucujetique. Muꞌyuc xa bu ta slap scꞌuꞌ. Muꞌyuc xa bu ta xnaqui ta sna. Jaꞌ xa noꞌox tey snainoj ti ba muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cꞌalal laj yil ti Jesuse, tey laj squejan sba ta stojol. Tey lic avanuc: ―¿Cꞌu chaꞌal ta xtal aticꞌ aba ta jtojol, Jesús, Snichꞌonot ti cajal Diose? Ta jcꞌanbot vocol ti mu xavilbajinune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ti jech ta xal taje, yuꞌun ti Jesuse yacal xa ta spas loqꞌuel ta mantal ti chopol pucujetique, ti acꞌo locꞌuc batel ta stojol ti vinique. Ti pucujetique ep ta velta laj yilbajin ti vinique. Ti cristianoetique manchuc mi laj xchucbeic yoc scꞌob ta cadena taqꞌuin yoꞌ jech mu xjatav, pero ti stuque ta xtuchꞌ yuꞌun. Ti pucuje ta sjatviltas batel ta xocol banomil ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ti Jesuse jech laj sjacꞌ: ―¿Cꞌusi abi? ―xut. Ti stuque jech laj stacꞌ: ―Legión ti jbie ―xi. Jaꞌ jech laj yal ti vinique, jaꞌ ti toj ep ti pucujetic ti ochem ta yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ti pucujetique laj scꞌanbeic ti Jesuse ti mu xtacatic batel ta xaꞌabe. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jech xtoc jaꞌ o tey oy ep chitometic xlamet ta saꞌ sveꞌelic ta vits. Jech ti pucujetique laj scꞌanbeic vocol ti Jesuse ti acꞌo yacꞌ ye yoꞌ ta sticꞌ sbaic ta chitometique. Ti Jesuse laj yacꞌ ye. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jech ti pucujetique iloqꞌuic batel ta stojol ti vinique. Iꞌochic batel ta chitometic. Jech ti chitometique scotolic ba sjipan sbaic yalel ta barranco. Tsꞌajatic icꞌotic ta nab. Tey ijicꞌavic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ti jqꞌuelchitometique, cꞌalal laj yilic ti jech icꞌot ta pasele, ta xiꞌel xa ibatic ta anil. Bat yalic sloꞌilic ti ta jteclume schiꞌuc sjoylej ti steclumalique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jech ti cristianoetique iloqꞌuic batel, ba sqꞌuelic ti vaꞌi sꞌelan icꞌot ta pasele. Cꞌalal icꞌotic ti bu oy ti Jesuse, tey laj staic ti vinic ti buchꞌu loqꞌuesbat ti pucujetique. Tey xa chotol ta yoc ti Jesuse. Slapoj xa scꞌuꞌ. Lec xa ti sjole. Tuqꞌuineb xa. Pero ti cristianoetique tey to ta xiꞌic yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ti buchꞌutic laj yilique, laj yalic ti cꞌu sꞌelan icol ti vinic ti uninbil to ox yuꞌun ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jech o xal ti cristianoetic ti nacalic ta Gadarae tey lic scꞌanbeic vocol ti Jesuse ti acꞌo locꞌuc batel teye. Yuꞌun ta xiꞌic ta jmec. Jech o xal ti Jesuse iꞌoch ta barco. Ibat. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jech ti vinic ti buchꞌu iloqꞌesbat ti pucujetique lic scꞌanbe vocol ti Jesuse ti acꞌo xchiꞌin batele. Pero ti Jesuse laj yal ti acꞌo comuque. Jech laj yalbe: ");
INSERT INTO tzotzc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Sutan batel ta ana. Ba alo scotol ti cꞌu sꞌelan laj spas ti Dios ta atojole ―xi. Jech ti vinique ibat. Tey laj yal sloꞌil ta sjunul jteclum ti cꞌu sꞌelan icoltaat yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cꞌalal isut batel ta jot stiꞌil nab ti Jesuse, xmuyubajic xa ti cristianoetic cꞌalal jech icꞌote. Jaꞌ ti scotolic tey ta smalaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jaꞌ o tey icꞌot jun vinic ti Jairo sbie, ti jaꞌ jpasmantal yuꞌun ti chꞌul nae. Ti vinic taje laj squejan sba ta yoc ti Jesuse. Laj scꞌanbe vocol ti acꞌo batuc ta snae. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yuꞌun cꞌajomal noꞌox jun oy ti stsebe, ti jaꞌ yichꞌoj xa lajcheb jabile, ti jutuc xa mu ta xchame. Cꞌalal ibat ti Jesuse, ep ti cristianoetic tsꞌacajtic batel ti snetꞌnetꞌ xa sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ti ta scotol ti cristianoetique, oy tey jun ants ti oy xa slajchebal jabil ti ta xichꞌ svocol ti mu xmac ti yaꞌlele. Laj xa slajes scotol ti staqꞌuin yuꞌun ti jpoxtavanejetique. Pero mi junuc buchꞌu ipoxtaj yuꞌunic ti chamele. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ti antse inopaj batel ta spat ti Jesuse. Ba spicbe ti stiꞌil scꞌuꞌe. Cꞌalal jech laj spase, ta ora noꞌox paj ti yaꞌlele. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ti Jesuse jech laj sjacꞌ: ―¿Buchꞌu laj spicun? ―xi. Scotol laj yalic ti muꞌyuque. Ti Pedroe schiꞌuc ti schiꞌiltaque jech lic yal: ―Jchanubtasvanej, jaꞌ ti cristianoetic ti ta snetꞌote, ti ta stacoltaot ta jujote. Jech o xal, ¿cꞌu chaꞌal ta xajacꞌ: “Buchꞌu laj spicun”, ti xachie? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero ti Jesuse jech laj yal: ―Oy buchꞌu laj spicun. Yuꞌun laj caꞌi ti oy buchꞌu laj jcolta yuꞌun ti jmucꞌul jtsatsale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Cꞌalal jech ivinaj ti antse, xnicnun xa ta xiꞌel tal squejan sba ta yoc ti Jesuse. Jamal laj yal ta sba ta sat scotol ti cristianoetique ti cꞌu chaꞌal laj spicbe scꞌuꞌ ti Jesuse, jech xtoc ti colem icom ta ora noꞌox yuꞌun ti schamele. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ti Jesuse jech laj yalbe: ―Tseb, lacol xa yuꞌun laj achꞌunun. Junuc avoꞌnton, batan ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yacal to ta xcꞌopoj ti Jesuse, cꞌalal jaꞌ o ivul jun vinic ti ilic tal ta sna ti Jairoe, jaꞌ ti jpasmantal yuꞌun ti chꞌul nae. Jech laj yalbe ti Jairoe: ―Ti avantsil nichꞌone cham xa. Chꞌan xa uto ti Jchanubtasvaneje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Cꞌalal laj yaꞌi ti Jesuse, jech laj yal: ―Mu xaxiꞌ. Chꞌunun noꞌox. Jech ti atsebe ta xcol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cꞌalal icꞌotic ta nae, ti Jesuse mi jaꞌuc junuc oy buchꞌu laj yacꞌ ochuc batel ti bu oy ti tsebe. Jaꞌ noꞌox ochic batel ti Pedroe, ti Jacoboe, ti Juane, schiꞌuc ti stot smeꞌ ti tsebe. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Scotol ti cristianoetique tey xꞌavlajetic xa ta yoqꞌuitael ti tsebe. Pero ti Jesuse jech laj yal: ―Mu xaꞌoqꞌuic. Ti tsebe muꞌyuc chamem. Jaꞌ noꞌox ta xvay ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero tseꞌej noꞌox laj yaꞌiic. Yuꞌun snaꞌojic lec ti chamem xae. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jech ti Jesuse tey laj snitbe scꞌob. Tsots lic yalbe: ―Tseb, lican talel ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ti tsebe lic cuxiuc. Ta ora noꞌox lic vaꞌiuc. Ti Jesuse laj yal mantal ti acꞌo yaqꞌuic veꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ti stot smeꞌ ti tsebe chꞌayal icꞌot yoꞌntonic. Pero ti Jesuse laj yal mantal ti mu me buchꞌu xalbe yaꞌiic ti jech icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ti Jesuse laj stsob ti lajchaꞌvoꞌ yajchancꞌoptaque. Laj yacꞌbe yabtelic, laj yacꞌbe stsatsalic ta sloqꞌuesel ti cꞌusiuc noꞌox pucujale, ta scolesel ti chameletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Laj stac batel ta yalel ti ventainel yuꞌun ti Diose, ta scolesel ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jech laj yal: ―Mu cꞌusi xavichꞌic batel sventa abeic, mi jaꞌuc anamteꞌic, mi jaꞌuc amoralic, mi jaꞌuc avotic, mi jaꞌuc ataqꞌuinic. Jlic noꞌox acꞌuꞌic xavichꞌic batel, mu me chaꞌlicuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Comanic tey ti buꞌyuc noꞌox na ta xacꞌotique jaꞌ to mi ta xaloqꞌuic batel teye. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ti bu mu xaꞌichꞌatic ta muqꞌue, locꞌanic batel ti ta jteclum teye. Lilinic comel ti spucuquil avoquique. Jaꞌ señail ti iltabilic ta xcꞌot yuꞌun ti Diose ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jech o xal ti yajchancꞌoptaque iloqꞌuic batel. Ibatic ta bicꞌtal jteclumetic ta yalel ti lequil achꞌ cꞌop ti jaꞌ colebale. Jaꞌ jech xtoc ta scolesanic batel ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Scotol ti cꞌusi ta spas ti Jesuse laj yaꞌi ti ajvalil Herodese. Mu stacꞌ aꞌyeluc ta xaꞌi cꞌusi ta snop. Yuꞌun oy jlom ta xalic ti jaꞌ ichaꞌcuxi ti Juan ti ichame. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ti yan xtoque ta xalic ti jaꞌ ti jꞌalcꞌop Elías ti ivul ta loqꞌuele. Ti yan xtoque ta xalic ti jaꞌ nan jun voꞌneal jꞌalcꞌop ti ichaꞌcuxie. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jech o xal ti Herodese jech laj yal: ―Ti Juane, vuꞌun laj cal mantal ti laj yichꞌ cꞌocbel sjole. ¿Buchꞌu van taje ti ep ta xcaꞌibe ti scꞌoplale? ―xi. Jech o xal ti ajvalil Herodese ta scꞌan ta sqꞌuel yaꞌi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cꞌalal isutic talel ti jcholcꞌopetique, lic yalbeic ti Jesuse ti cꞌusi laj spasique. Jech ti Jesuse laj yicꞌ batel ti bu stsꞌijlane, ti nopol ta jteclum Betsaidae. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero cꞌalal laj yaꞌiic ti cristianoetique, bat staic. Jech ti Jesuse muꞌyuc laj sbaj. Laj yalbe yaꞌiic ti ventainel yuꞌun ti Diose. Laj scolta ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cꞌalal ta xa xmal ti cꞌacꞌale, ti lajchaꞌvoꞌ jcholcꞌopetique inopajic batel ta stojol ti Jesuse. Jech cꞌot yalbeic: ―Taco xa batel scotol ti cristianoetique yoꞌ ta xba saꞌ bu ta xcux yoꞌntonic, yoꞌ xuꞌ ta xba saꞌ sveꞌelic ta jujun bicꞌtal lum ti bu nopol noꞌoxe. Yuꞌun ti liꞌ bu oyotique, muꞌyuc cꞌusi xꞌayan ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ti Jesuse jech laj yal: ―Acꞌbeic sveꞌel ti voꞌoxuque ―xi. Ti stuquique jech laj yalic: ―¿Cꞌusi ta xcutcutic ti cꞌajomal xa noꞌox voꞌbej pan schiꞌuc chaꞌcot choye? Jaꞌ noꞌox mi ta xba jmanbecutic tal sveꞌel ti cristianoetique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yuꞌun nopol voꞌmiluc viniquetic ti tey tsobolique. Ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Albeic yaꞌi ti acꞌo chotlicuc lajuneb yoxvinic (50) ta jujuvoqꞌue ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jech laj spasic jech chac cꞌu chaꞌal iꞌalbatic. Tey ichotiic scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jech ti Jesuse laj stsac ti voꞌbej pane schiꞌuc ti chaꞌcot choye. Laj stoy muyel sat ta vinajel. Tey laj yalbe vocol ti Diose. Tsꞌacal to lic xetꞌ ti choye, ti pane. Tey laj yacꞌbe batel ti yajchancꞌoptaque yoꞌ jech ta spucbeic batel ta scotol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Scotolic inojic lec. Tsꞌacal to lic stsobic lajcheb moch ti scomelale. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Oy jun cꞌacꞌal ti Jesuse laj sqꞌuej sba batel ta scꞌoponel ti Diose. Jech laj sjacꞌbe ti yajchancꞌoptac ti tey schiꞌuque: ―¿Buchꞌuun ta xalic ti cristianoetic xanaꞌe? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jech itacꞌavic ti stuquique: ―Oy jlom ta xalic ti voꞌot la ti Juan jꞌacꞌ-ichꞌ-voꞌe. Ti jlom xtoque ta xalic ti voꞌot la ti Elíasote. Pero oy to jlom xtoc ta xalic ti voꞌot la jun voꞌneal jꞌalcꞌop ti ichaꞌcuxie ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ti Jesuse jech laj sjacꞌ: ―Ti voꞌoxuque, ¿buchꞌuun ti ta xanopique? ―xut. Ti Pedroe jech laj yal: ―Ti voꞌote jaꞌ ti Cristo ti talemot ta stojol ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ti Jesuse tsots laj scꞌubanbe ti mu me buchꞌu junucal xalbe yaꞌi ti jaꞌ Cristo ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ti stuque jech laj yal: ―Ti vuꞌun coꞌol jꞌelantique ta xquichꞌ ep vocol. Ta xisbajicun ti moletique, ti banquilal paleetique, ti jchanubtasvanejetic yuꞌun ti mantale. Ta xiyaqꞌuicun ta milel. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tsꞌacal to jech laj yalbe scotol ti cristianoetique: ―Ti mi oy buchꞌu ta scꞌan ta xistsꞌacli batele, acꞌo me xtuchꞌ ta yoꞌnton ti scuxlejal stuque manchuc mi ta xichꞌ svocol. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yuꞌun ti buchꞌu tsots scꞌoplal ta xaꞌi ti scuxlejale, jaꞌ ta xchꞌay. Pero ti buchꞌu mu tsotsuc ta xaꞌi ti scuxlejal ta jventae, jaꞌ ta sta. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Cꞌusi bal o ti vinique ti mi jaꞌ noꞌox ta xyuꞌunin scotol ti sba banomile ti mi chꞌayel ta xbat ti stuque? ");
INSERT INTO tzotzc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ti mi oy buchꞌu ta xqꞌuexav ta jtojol schiꞌuc xtoc ta xqꞌuexav yuꞌun ti lequil achꞌ cꞌop cuꞌune, jaꞌ noꞌox jech ti vuꞌun eque, ti coꞌol jꞌelantique, ta xiqꞌuexav ta stojol cꞌalal ta xital ta ajvalil, schiꞌuc yutsilal ti Jtote, schiꞌuc ti chꞌul ángeletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta melel ta xcalboxuc avaꞌiic, oy jlomoxuc liꞌe oy to mu ta xachamic jaꞌ to mi laj avilic ti ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Echꞌem xa vaxaquib cꞌacꞌal ti vaꞌi sꞌelan laj yal ti Jesuse, imuy batel ta vits yoꞌ ta sta ta cꞌoponel ti Diose. Tey xchiꞌinoj batel ti Pedroe, ti Jacoboe, ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cꞌalal yacal ta sta ta cꞌoponel ti Diose, jaꞌ o lic yanijuc ti sate. Ti scꞌuꞌe toj sac icom. Lic xojobanuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jaꞌ o tey ivinaj chaꞌvoꞌ viniquetic ti ta xloꞌilajic schiꞌuc ti Jesuse. Ti chaꞌvoꞌique jaꞌ ti Moisese, ti Elíase. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tey joyobtabilic ta xojobal ti toj yan yutsile. Ti chaꞌvoꞌ viniquetique ta xalic ti ta xichꞌ svocol ti ta xichꞌ milel ti Jesús ta Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Manchuc mi xvay yaꞌiic ti Pedroe schiꞌuc ti schiꞌiltaque, pero ivicꞌ ti satique. Tey laj yilic ti yan yutsilal ti Jesuse schiꞌuc ti chaꞌvoꞌ viniquetic ti tey schiꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cꞌalal ta xa xchꞌac sbaic batel ti chaꞌvoꞌ viniquetic ta stojol ti Jesuse, ti Pedroe jech laj yal: ―Jchanubtasvanej, toj lec ti liꞌ oyotique. Ta jpascutic oxib axibal na, jun avuꞌun, jun yuꞌun ti Moisese, jun yuꞌun ti Elíase ―xi. Jech laj yal ti Pedroe, jaꞌ ti mu stacꞌ aꞌyeluc cꞌusi ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Cꞌalal jech yacal ta xcꞌopoje, jaꞌ o tal voliaticuc ta toc. Ep ixiꞌic ti jech volibilic ta toque. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ti ta toque oy Buchꞌu icꞌopoj ti jech ta xale: ―Jaꞌ ti Jnichꞌon liꞌe ti toj cꞌux ta xcaꞌie. Aꞌyibeic ti scꞌopojele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cꞌalal ilaj cꞌopojuc ti Buchꞌu ta xcꞌopoj talele, jaꞌ o tey laj yilic ti stuc xa ti Jesuse. Ti stuquique muꞌyuc buchꞌu laj yalbeic yaꞌi ti cꞌusi laj yilique. Tsꞌijil icomic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta yocꞌlomal cꞌalal iyalic talel ta vitse, ep cristianoetic ba snupic ta be ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Oy jun vinic ta scotol ti cristianoetique ti tsots iꞌavan ti jech laj yale: ―Jchanubtasvanej, yuꞌun jun ti jnichꞌone, avocoluc coltabun. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuꞌun ta xꞌilbajinat yuꞌun ti pucuje. Cꞌalal ta xꞌilbajinate, tsots ta xꞌavan ta jmec. Ta xtubbat yicꞌ. Xvocan xa ye ta xcom. Ta xilbajin. Mu xcomtsanat. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Laj xa jcꞌanbe vocol ti avajchancꞌoptaque yoꞌ ta sloqꞌues ti pucuje. Pero muꞌyuc xuꞌ yuꞌunic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ti Jesuse jech itacꞌav: ―Jecheꞌoxuc. Muꞌyuc atuqꞌuilic. Ep xa cꞌacꞌal liꞌ oyun ta atojolic ti jtsꞌicojboxuque. Icꞌbun talel ti anichꞌone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cꞌalal tey inopaj talel ti quereme, ijipat ta lum yuꞌun ti pucuje. Tey itubbat yicꞌ yan velta. Pero ti Jesuse laj sjajanta ti pucuje. Laj scolta ti quereme. Laj yacꞌbe batel ti stote. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Scotolic chꞌayal icꞌot yoꞌntonic yuꞌun smucꞌul stsatsal ti Diose. Cꞌalal chꞌayal yoꞌnton scotolic yuꞌun ti cꞌusi ta spas ti Jesuse, jech laj yalbe ti yajchancꞌoptaque: ");
INSERT INTO tzotzc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Aꞌyic lec liꞌe. Mu xachꞌay ta avoꞌntonic. Ti vuꞌun coꞌol jꞌelantique ta xquichꞌ aqꞌuel ta cꞌabal ta stojol ti cristianoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Muꞌyuc xaꞌibeic smelol ti yajchancꞌoptaque ti jech laj yale. Yuꞌun mu to ta xꞌacꞌbat snaꞌic ti smelole. Jaꞌ jech xtoc ta xiꞌic ta sjacꞌbeic smelol ti vaꞌi sꞌelan laj yale. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jech ti yajchancꞌoptaque lic svul sbaic buchꞌu ti más banquilal ta xcꞌot yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero ti Jesuse laj snaꞌ ti jech ta snopique. Jech o xal laj yicꞌ talel jun chꞌin querem ti laj svaꞌan ta stsꞌele. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jech laj yal: ―Buchꞌuuc noꞌox ti ta jventa vuꞌun ta xichꞌ ta mucꞌ ti olol liꞌe, ta xiyichꞌicun ta mucꞌ ec. Jaꞌ jech xtoc ta xichꞌic ta mucꞌ ti Buchꞌu laj stacun talele. Ti buchꞌu más peqꞌuel ta xacꞌ sba ta atojolique, jaꞌ más banquilal ta xcꞌot ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jech laj yal ti Juane: ―Jchanubtasvanej, laj quilcutic jun vinic ti ta sloqꞌues pucuj ta sventa abie. Ti jech muꞌyuc liꞌ jchiꞌuctique, jech o xal laj jpajtsancutic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ti Jesuse jech laj yal: ―Mu xapajtsanic. Yuꞌun ti buchꞌu mu xiscrontainotique, jaꞌ jchiꞌiltic ta abtel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cꞌalal poꞌot xa sta yorail ti ta xchaꞌsut muyel ta vinajel ti Jesuse, sjunul yoꞌnton ibat cꞌalal Jerusalén. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Laj stac jelavel yajtuneltac ta biqꞌuit jteclum ti oy ta Samaria banomile yoꞌ ta xba xchꞌamunic na. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ti jsamariaetique laj yilic ti ta xbat onoꞌox ta Jerusalene. Jech o xal muꞌyuc xacꞌ ta chꞌom ti snaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cꞌalal jech laj yilic ti yajchancꞌoptaque, jaꞌ ti Juane, ti Jacoboe, jech laj yalic: ―Cajval, ¿mi ta xacꞌan ti acꞌo jcꞌantic yaluc talel cꞌocꞌ ta vinajele yoꞌ jech ta xlajic scotolic jech chac cꞌu chaꞌal laj spas ti jꞌalcꞌop Elíase? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jech ti Jesuse tey lic sqꞌuelbe sat ti chaꞌvoꞌique. Jech laj yalbe ti laj sjajantae: ―Ti voꞌoxuque mu xavaꞌiic buchꞌu schꞌulel avichꞌojic. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yuꞌun ti vuꞌun coꞌol jꞌelantique maꞌuc tal jchꞌaybe scuxlejalic ti cristianoetique. Jaꞌ tal jcolta ―xi. Jech o xal tey ibatic ta yan biqꞌuit jteclum. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cꞌalal yacalic ta xanavic batel ta bee, jaꞌ o ital jun vinic ti jech laj yalbe ti Jesuse: ―Cajval, ta jcꞌan ta jchiꞌinot batel ti buꞌyuc noꞌox ta xabate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ti Jesuse jech laj stacꞌbe: ―Ti vete oy schꞌenic. Ti mutetique oy stasic. Pero ti vuꞌun coꞌol jꞌelantique mi jaꞌuc oy bu juteb ti xuꞌ ta jcux ti coꞌntone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ti Jesuse jech laj yalbe ti yane: ―Batic ―xut. Pero ti stuque jech laj yal: ―Cajval, acꞌbun to permiso ta jmuc baꞌyel ti jtote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ti Jesuse jech laj stacꞌbe: ―Acꞌo smuc stuc yanimaic ti buchꞌu chamemic onoꞌoxe. Pero ti voꞌote, ba alo ti ventainel yuꞌun ti Diose ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jech ti jun xtoque jech laj yal: ―Cajval, ta jcꞌan ta jchiꞌinot batel. Pero malaun jutuc. Yuꞌun ta to xba cal jba comel ta jna ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ti Jesuse jech laj yal: ―Ti buchꞌu ta sqꞌuel svalopat ti yicꞌojbe batel yabtejeb ti vacaxe, mu xtun ta yabtelanel ti ventainel yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsꞌacal to un, laj stꞌuj yan lajuneb schanvinic (70) ta voꞌ jꞌabteletic. Laj stacan jelavel ta chaꞌchaꞌvoꞌ yoꞌ ta xbatic ta jujun jteclum ti yoꞌ bu ta xꞌechꞌ onoꞌox ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jech laj yalbe: ―Ta melel ta xcalboxuc avaꞌiic, ep ti tsꞌunobal ti ta scꞌan tsobele. Pero muꞌyuc ep ti jꞌabteletique. Jech o xal cꞌanbeic ti yajval tsꞌunobale ti acꞌo stac talel jꞌabteletic ta stsobel ti tsꞌunobale. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Qꞌuel avilic, coꞌol aꞌelanic jech chac cꞌu chaꞌal chijetic ta jtacoxuc batel ta stojol ti jtiꞌoval oqꞌuiletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mu me xavichꞌic batel anutiꞌic, mi jaꞌuc yavil ataqꞌuinic. Mi jaꞌuc ta xavichꞌic batel chaꞌchop axonobic. Mu me teyuc noꞌox xchꞌayet avoꞌntonic ta loꞌil ta be. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cꞌalal ta xaꞌochic ta jun nae, jech baꞌyel xavalic: “Ichꞌic spatobil avoꞌntonic ti jnaclejoxuc liꞌe”, xavutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi lec ta xaꞌiic ti spatobil yoꞌntonique, jaꞌ yuꞌun umbi, acꞌbeic comel. Pero mi mu lecuc ta xaꞌiique, mu me xavaqꞌuic comel ti spatobil yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Comanic ta sna ti bu ta scꞌanic ti spatobil yoꞌntonique. Jmoj xaveꞌic. Jmoj xalajesic ti cꞌusi oy yuꞌunique. Yuꞌun ti jꞌabteletique ta xichꞌ stojolic. Mu me jaꞌuc xapasic ti xalocꞌ xaꞌochic batel ta jujun nae. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cꞌalal ta xacꞌotic ta jun jteclum ti bu ta xaꞌichꞌatic ta muqꞌue, lajesic ti cꞌusi ta xacꞌboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Colesic ti jchameletic ti tey oye. Albeic yaꞌi: “Liꞌ xa oy ta atojolic ti ventainel yuꞌun ti Diose”, utic. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero mi ta xacꞌotic ta jun jteclum ti bu mu xayichꞌic ta muqꞌue, locꞌanic batel ta calletic. Jech xavalic: ");
INSERT INTO tzotzc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Scotol ti spucuquil ti alumalic ti laj xa spac sba ta jxonobcutique, ta jlilincutic comel. Jaꞌ svinajeb ti iltabiloxuc yuꞌun ti Diose. Pero naꞌic me lec, ti ventainel yuꞌun ti Diose liꞌ xa oy ta atojolique”, utic. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta xcalboxuc avaꞌiic, cꞌalal ta sta yorail ti chapanele, toj tsots ta xichꞌ castigo ti jteclume. Jaꞌ mu sta ta xichꞌic castigo ti cristianoetic ti nacajtic to ox ta Sodoma jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Abol aba, jteclum Corazín. Abol aba, jteclum Betsaida. Ati lajuc yilic ti cristianoetic ti nacajtic to ox ta Tiro schiꞌuc ti ta Sidón jteclume jech chac cꞌu chaꞌal ta xavilic avi liꞌe, voꞌne xa laj sjelta yoꞌntonic, laj slapic cꞌuꞌil sventa at oꞌnton, laj svijbe sbaic tan ti jechuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ti cꞌalal ta sta yorail ti chapanele, toj echꞌem ta xavichꞌic castigo. Jaꞌ mu sta ta xichꞌic castigo ti buchꞌutic nacajtic to ox ta Tiro schiꞌuc ti ta Sidone. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jaꞌ jech xtoc ti voꞌot eque, jteclum Capernaum, ta xanop ti ta xavichꞌ toyesel muyel cꞌalal to vinajel. Pero ¡bu xata ti jeche! Jaꞌ noꞌox ta xavichꞌ yalesel batel ta lajebal ti bu ticꞌajtic ti animaetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Ti buchꞌutic ta xayichꞌic ta muqꞌue, ta xiyichꞌic ta mucꞌ ec. Ti buchꞌutic ta xasbajique, ta xisbajic ec. Ti buchꞌutic ta xisbajique, ta sbajic ti Buchꞌu laj stacun talele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xmuyubajic xa isutic talel ti lajuneb schanvinic (70) ta voꞌe. Jech laj yalic: ―Cajval, cꞌalal ta pucujetic laj xchꞌun cuꞌuncutic taquel loqꞌuel ta aventa ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ti Jesuse jech laj yal: ―Jech, yuꞌun vuꞌun laj quil ti coꞌol sꞌelan leb chauc ti cꞌalal ijipat yalel talel ta vinajel ti banquilal pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Vuꞌun laj xa cacꞌboxuc atsatsalic yoꞌ xuꞌ avuꞌunic ta spechꞌel ta teqꞌuel ti chone schiꞌuc ti tseque, yoꞌ jech ta xatsalbeic scotol yip ti avajcrontaique. Mi jaꞌuc jutebuc ti cꞌusi xuꞌ ta spasboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero maꞌuc noꞌox xamuyubajic yuꞌun ti laj xchꞌunboxuc amantalic ti pucujetique. Jaꞌ muyubajanic yuꞌun ti tsacajtic abiic tey ta vinajele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta jech to yepal ti Jesuse xmuyubaj xa yuꞌun ti Chꞌul Espíritue. Jech lic yal: ―Yan avutsil, Tot, yajvalot vinajel banomil. Yuꞌun laj avacꞌbe snaꞌ scoltael ti buchꞌu muꞌyuc sbijilique. Jaꞌ muꞌyuc laj avacꞌbe snaꞌ scoltael ti buchꞌu oy sbijilique, ti jamal sba satic ti yalojique. Jech, yuꞌun jech laj acꞌan atuc, Tot. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ti Jtote laj xa yacꞌbun ta coc ta jcꞌob scotol ti cꞌusitic oye. Muꞌyuc buchꞌu xiyojtiquin ti vuꞌun Nichꞌonilune. Jaꞌ noꞌox xiyojtiquin stuc ti Jtote. Jaꞌ jech xtoc muꞌyuc buchꞌu junucal ta xojtiquin ti Jtote. Jaꞌ noꞌox ti vuꞌun Nichꞌonilune. Jaꞌ jech xtoc ta xojtiquinic ti Jtote ti buchꞌutic ta xcacꞌbe yojtiquinique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ti Jesuse lic sqꞌuel batel ti yajchancꞌoptaque ti jech laj yalbee: ―Toj yan noꞌox yutsil ti ta xavilic ta asatic ti cꞌusi laj jpase. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jech ta xcalboxuc avaꞌiic, yuꞌun ep ti jꞌalcꞌopetique schiꞌuc ti ajvaliletique ta scꞌan ta sqꞌuelic ox yaꞌiic jech chac cꞌu chaꞌal ta xavilique, pero muꞌyuc laj yilic. Jech xtoc ta scꞌan ta xaꞌiic ox jech chac cꞌu chaꞌal ti ta xavaꞌiique, pero muꞌyuc laj yaꞌiic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oy jun banquilal jchanubtasvanej yuꞌun ti mantale bat scꞌopon ti Jesuse yoꞌ ta slajeltsabe yoꞌnton. Jech cꞌot sjacꞌbe: ―Jchanubtasvanej, ¿cꞌusi xuꞌ ta jpas yoꞌ ta jta ti jcuxlejal sbatel osile? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ti Jesuse jech laj stacꞌbe: ―¿Cꞌusi ti tsꞌibabil tey ta mantale? ¿Cꞌu sꞌelan chaqꞌuel? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ti jchanubtasvanej yuꞌun ti mantale jech itacꞌav: ―Cꞌano ti Cajval Dios avuꞌune ta sjunul avoꞌnton, ta sjunul achꞌichꞌel, ta scotol avip, ta scotol abijil. Jaꞌ jech xtoc cꞌuxubino ti achiꞌiltaque jech chac cꞌu chaꞌal ta xacꞌuxubin aba atuc ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jech ti Jesuse jech laj yal: ―Lec ti jech laj ataqꞌue. Ti mi jech ta xapas taje, ta xata acuxlejal ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ti jchanubtasvanej yuꞌun ti mantale, ti ta spoj sba yaꞌie yuꞌun ti cꞌusi laj yale, jech laj yalbe ti Jesuse: ―¿Buchꞌu ti jchiꞌile? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ti Jesuse jech laj stacꞌbe: ―Oy jun vinic ta xyal batel ta sbelal Jerusalén. Ta xbat ta jteclum Jericó. Tey iꞌelcꞌanat yuꞌun jꞌeleqꞌuetic. Tey iꞌelcꞌanbat batel scotol ti cꞌusitic oy yuꞌune schiꞌuc scꞌuꞌ xtoc. Lec iꞌacꞌbat majel. Ijatavic ti jꞌeleqꞌuetique. Chamemtic xa sꞌelan laj yicta comel ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jaꞌ o tey echꞌ jun pale ti bu telel ti vinic ta bee. Cꞌalal laj yile, sqꞌuel noꞌox comel. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jaꞌ jech xtoc tey icꞌot jun levita vinic ti bu telel ti vinique. Cꞌalal laj yile, sqꞌuel noꞌox comel xtoc. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero oy jun jyanlum vinic ti jaꞌ liquem tal ta Samaria banomile, tey ixanav bal ti bu telel ti vinique. Cꞌalal laj yile, icꞌuxubaj yoꞌnton yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jech ti jyanlum vinique inopaj batel ta stojol ti vinique. Tey lic xpoxtabe ta aceite ta vino ti syayijemale. Tey laj spix ta pocꞌ. Tsꞌacal to laj scajan batel ta sba sburro. Tey laj yicꞌ batel ta chꞌom na. Tey laj xchabi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta yocꞌlomal ti cꞌalal ta xa xlocꞌ batel ti jsamaria vinique, tey laj sloqꞌues chaꞌsep taqꞌuin. Laj yacꞌbe ti yajval nae. Jech laj yal: “Chabibun ti vinic liꞌe. Ti mi mu xlocꞌ o ti cꞌu yepal laj cacꞌbot comele, ta jtojbot cꞌalal ta xisut talel”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Cꞌu sꞌelan laj avaꞌi? Ti oxib viniquetic ti laj jbabaꞌale, ¿buchꞌu junucal ti laj sbis ta schiꞌil ti vinic ti ilaj ta majel yuꞌun ti jꞌeleqꞌuetique? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ti jchanubtasvanej yuꞌun ti mantale jech laj yal: ―Jaꞌ ti buchꞌu ti icꞌuxubaj yoꞌnton ta stojole ―xi. Ti Jesuse jech laj yalbe: ―Batan, ba paso jech ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Cꞌalal jech ta xanav batel ti Jesuse, icꞌot ta jun biqꞌuit jteclum. Ti teye, tey nacal jun ants, jaꞌ Marta sbi. Laj yicꞌ ochel ta sna. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ti Martae oy jun schiꞌil ta voqꞌuel ti jaꞌ María sbie. Ti Maríae sjunul yoꞌnton tal chotluc ta stojol ti Jesuse yoꞌ ta xaꞌi ti cꞌusi ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero ti Martae sujoj sba ta spasel ti cꞌusitic ta scꞌan pasele. Tey inopaj batel ti stojol ti Jesuse. Jech laj yalbe: ―Cajval, ¿mi mu xatucꞌulan ti jtuc tuc ictabilun ta abtel yuꞌun ti jchiꞌil ta voqꞌuele? Albo yaꞌi ti acꞌo tal scoltaune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ti Jesuse jech laj stacꞌbe: ―Marta, Marta, jaꞌ noꞌox asujoj aba ti ep ti cꞌusi ta scꞌan pasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero oy jun ti cꞌusi tsots scꞌoplale. Ti Maríae laj xa stꞌuj ti bu más tsots scꞌoplale, ti muꞌyuc buchꞌu ta xpojbate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Oy jun cꞌacꞌal ti oy bu ta sta ta coponel Dios ti Jesuse. Ti cꞌalal laj yoꞌntone, jech laj yal jun yajchancꞌop: ―Cajval, chanubtasuncutic ta scꞌoponel ti Diose jech chac cꞌu chaꞌal laj xchanubtas yajchancꞌoptac ti Juane ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ti Jesuse jech laj yal: ―Jech xavalic ti cꞌalal ta xataic ta cꞌoponel ti Diose: Jtotic Dios, tey oyot ta vinajel, ichꞌbiluc ta mucꞌ ti achꞌul bie. Laꞌ ventainuncutic. Cꞌotuc ta pasel ti cꞌusi ta scꞌan avoꞌnton liꞌ ta banomile jech chac cꞌu chaꞌal ta xichꞌ pasel tey ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Acꞌbuncutic ti jveꞌelcutic ti xtun cuꞌuncutic avi cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Acꞌbuncutic perdón yuꞌun ti jmulcutique jech chac cꞌu chaꞌal ta xcacꞌbecutic perdón ti buchꞌu laj xa saꞌ smul ta jtojolcutique. Pojuncutic, mu me xavacꞌuncutic ta lajeltsael yuꞌun ti pucuje, xachiic, ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ti Jesuse jech laj yal xtoc: ―Xcaltic noꞌox avaꞌi xtoc ti oy jun achiꞌil ti lec xavil abaic schiꞌuque ti ta xacꞌot ta sna ta oꞌlol acꞌobale. Jech ta xavalbe: “Chiꞌiltic, jqꞌuextic oxibuc apan. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yuꞌun naca to ivul ta jna jun jchiꞌil ti ay ta xanobale. Pero muꞌyuc cꞌusi ta xcacꞌbe slajes”, ti xachie. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Xuꞌ nan ta xcaltic xtoc ti jech ta xtacꞌav tal ta yut snae: “Mu xatijbun jvayel. Yuꞌun macal lec ti stiꞌ jnae. Yuꞌun jchiꞌinojun ta vayel ti jnichꞌnabtaque. Mu xuꞌ ta xilic yoꞌ ta xcacꞌbot ti cꞌusi ta xacꞌane”, xayut. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta xcalboxuc avaꞌiic, acꞌo mi lec xavil abaic schiꞌuc, pero mu xlic yacꞌbot ti cꞌusi ta xtun avuꞌune. Pero ti tey noꞌox xavulvun ta jmeque, ta xtavan xaꞌi. Jech o xal ta onoꞌox xlic yacꞌbot ti cꞌusi ta xacꞌanbee. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaꞌ yuꞌun un, ta xcalboxuc avaꞌiic, cꞌanbeic ti Diose, ta xayacꞌboxuc. Saꞌolanic, ta xataic. Cꞌojilanic ti tiꞌ nae, ta xajambatic. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yuꞌun ti buchꞌu ta scꞌane, ta xichꞌ. Ti buchꞌu ta saꞌe, ta sta. Ti buchꞌu ta stij ti tiꞌ nae, ta xjambat. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ti voꞌoxuc totiloxuque, ¿mi ta xavacꞌbeic jbej ton ti cꞌalal pan ta scꞌanboxuc ti anichꞌonique? Jaꞌ jech xtoc, ¿mi ta xavacꞌbeic jcot chon ti cꞌalal choy ta scꞌanboxuque? ");
INSERT INTO tzotzc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jaꞌ jech xtoc, ¿mi ta xavacꞌbeic jcot tsec ti cꞌalal ta scꞌanboxuc ton alaqꞌue? ");
INSERT INTO tzotzc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Manchuc mi jech chopoloxuc, pero xanaꞌic lec stꞌujel ti cꞌusi ta xavacꞌbeic ti anichꞌonique. Jaꞌuc xa van ti Atotic ti oy ta vinajele ta xacꞌbe ti Chꞌul Espíritu ti buchꞌu ta scꞌane ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ti Jesuse laj sloqꞌues jun chopol pucuj ti oy ta yoꞌnton jun vinic ti pasem ta umaꞌe. Cꞌalal ilocꞌ batel ti chopol pucuje, jech ti umaꞌe lic jamuc ti yee. Chꞌayal icꞌot yoꞌntonic ti cristianoetic ti jech laj spase. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero oy jlom jech laj yalic: ―Ti vinic liꞌe ta stac loqꞌuel ti chopol pucujetique jaꞌ ta stsatsal ti banquilal yuꞌunique, jaꞌ ti Beelzebue ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oy jlom xtoc ta scꞌan ta slajeltsabe yoꞌnton ti Jesuse. Jech o xal laj scꞌanbeic ti acꞌo yacꞌ iluc señail ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ti Jesuse snaꞌoj ti jech ta snopique. Jech o xal jech laj yal: ―Buchꞌuuc noꞌox ajvalilal ti mi ta xlic xchꞌacan sbaique, ti mi xlic stsacan sbaic ta letoe, ta soques sba stuquic. Jaꞌ jech xtoc ti mi ta xchꞌac sbaic ti jchop nacleje, jaꞌ jech xtoc ta soques sba stuquic. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jaꞌ jech xtoc ti pucuje, ti mi ta syanijes sba stuque, ti mi ta scrontain sba stuque, ¿cꞌusi xut ta xjalij ti stsatsale? Jaꞌ jech ta xcalboxuc avaꞌiic, yuꞌun ta xavalbeicun ti ta stsatsal ti Beelzebue ti jech ta jloqꞌues ti pucujetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti mi jaꞌ jeche, ¿buchꞌu van ta xcoltaat yuꞌun ti avinictac ti jech xuꞌ yuꞌunic ta sloqꞌuesel ti pucujetique? Jech o xal ti avinictaque ta svinajesboxuc ti toj chꞌayemoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta smucꞌul stsatsal ti Diose ti jech ta jloqꞌues ti chopol pucujetique. Liꞌe, jaꞌ ta xacꞌ ta naꞌel ti liꞌ xa oy ta atojolic ti ventainel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Cꞌalal oy jun tsatsal vinic ti lec xchapanoj sba schiꞌuc ti yabtejeb ti ta xchabi ti snae, scotol ti cꞌusi oy yuꞌune lec xchabioj. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero mi ta xtal jun vinic ti más to tsots xuꞌ yuꞌune, ta stsalat ti vinique. Jech xlic pojbatuc ti yabtejeb ti jaꞌ spatoj o yoꞌnton schiꞌuque. Ta xpojbat ti cꞌusitic oy yuꞌune. Ta xchꞌacbat batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Buchꞌuuc noꞌox ti mu lecuc ta xil ti cꞌusi ta jpase, jaꞌ ta xiscrontain. Jaꞌ jech xtoc ti buchꞌu mu xiscolta ta stsobele, jaꞌ noꞌox ta stani batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Cꞌalal ta xlocꞌ batel ti pucuj ta yoꞌnton jun vinique, ta xba xanavuc ta xocol banomil. Ta saꞌ ti bu ta xcux yoꞌntone. Pero cꞌalal ta xil ti muꞌyuc ta stae, jech xlic snop ta yoꞌnton: “Ta xichaꞌsut batel ta jna ti bu lilocꞌ talele”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cꞌalal ta sut talele, xocol ta stabe yoꞌnton ti vinique, coꞌol sꞌelan jbej na ti lec mesbile, ti lec chꞌubabile. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jech o xal ti pucuje ta xbat yicꞌ talel yan vucub schiꞌil ti más toj echꞌem chopole. Jaꞌ mu sta ti stuque. Scotolic ti pucujetique ta xꞌoch naclicuc ta yoꞌnton ti vinique. Jech ti vinique jaꞌ to toj echꞌem chopol ta xcom. Jaꞌ mu sta ti ta baꞌyele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Cꞌalal yacal jech ta xal ti Jesús ti vaꞌi sꞌelan taje, oy jun ants ta scotol ti cristianoetique ti jech iꞌavane: ―Yan noꞌox yutsil ti ants ti buchꞌu laj svoqꞌuesote, ti laj stsꞌitesote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero ti Jesuse jech laj yal: ―Jaꞌ yan yutsilic ti buchꞌutic ta xaꞌiic ti cꞌusi ta xal ti Diose, ti ta xchꞌunique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cꞌalal yacal ta stsob sbaic talel ti cristianoetic ta stojol ti Jesuse, tey lic cꞌopojuc ti jech laj yale: ―Ti cristianoetic ta ora liꞌe toj chopolic. Ta scꞌanic señail ti oy cꞌusi ta xꞌacꞌbat yilique. Pero muꞌyuc cꞌusi ta xꞌacꞌbat yilic. Jaꞌ noꞌox ta xꞌacꞌbat yilic jech chac cꞌu chaꞌal icꞌot ta stojol ti jꞌalcꞌop Jonase. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti cꞌusi icꞌot ta stojol ti Jonase, jaꞌ señail laj yilic ti cristianoetic ti oyic ta Ninivee. Jaꞌ jech ti vuꞌun ti coꞌol jꞌelantique, ti cꞌusi ta xcꞌot ta jtojole, jaꞌ señail ta xilic ti cristianoetic avi liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti scꞌacꞌalil ti chapanele, ti cꞌalal ta xichꞌ chapanel ti cristianoetic avi liꞌe, jech ti meꞌ ajvalil ti liquem talel ta xocon sloqꞌueb cꞌacꞌale ta svaꞌan sba ta xchapanel. Yuꞌun ti stuque ta namal banomil ilic talel ta yaꞌyiel sbijil ti ajvalil Salomone. Ti vuꞌun liꞌe, jaꞌ jelavem ti jcꞌoplale. Jaꞌ mu sta ti Salomone. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jech xtoc ti buchꞌutic nacajtic to ox ta Ninive jteclume tey ta xlic vaꞌicuc ta chapanvanej ti cꞌalal ta xichꞌic chapanel ti cristianoetic avi liꞌe. Yuꞌun ti stuquique laj sjelta yoꞌntonic ti cꞌalal ay yal scꞌop Dios ti Jonase. Ti vuꞌun liꞌe, jaꞌ jelavem jcꞌoplal. Jaꞌ mu sta scꞌoplal ti Jonase. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Mu yuꞌunuc ta jtsantic ti lampara ti chba cacꞌtic ta nacꞌaltique, o chba jticꞌtic ta yolon cajon. Moꞌoj, ta xcacꞌtic lec ta toyol yoꞌ ta xilic lec ti buchꞌu ta xꞌochic talel ta yut nae. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ti asatique coꞌol sꞌelan lampara cꞌotem yuꞌun ti abecꞌtalique. Ti mi lec ti asatique, jech oy ta saquil osil sjunul ti abecꞌtalique. Pero ti mi chopol ti asatique, jech oy ta icꞌal osil sjunul ti abecꞌtalique. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Qꞌuelo me abaic, ti luz ti oy ta atojolique, mu me xjoybij ta icꞌal osil. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ti mi sjunlejal abecꞌtal oy ta saquilal osile, ti mi muꞌyuc jutebuc oy icꞌal osile, scotol xavilic lec, coꞌol sꞌelan jun lampara ti ta xacꞌ xojobal ta atojole ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cꞌalal laj yoꞌnton ta cꞌopojel ti Jesuse, jaꞌ o tal jun jfariseo vinic ti laj yicꞌ batel ta veꞌel ta snae. Ti Jesuse iꞌoch batel. Tey cꞌot chotluc ta mexa. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ti jfariseoe toj labal laj yaꞌi ti cꞌalal laj yil ti mu laj yichꞌbe ta mucꞌ ti stalelique, ti ep ta velta ta spoc scꞌobic cꞌalal xlic veꞌicuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero ti Cajvaltique jech laj yal: ―Ti voꞌoxuque, jfariseoetic, lec ta xapocbeic spat ti avasuique schiꞌuc ti asetsique. Pero ti voꞌoxuque jaꞌ noꞌox nojem ta avoꞌntonic ta spasel ti chopole schiꞌuc ti elecꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Toj pimuneboxuc. ¿Mi mu xanaꞌic, ti Buchꞌu laj smeltsan ti spat xocone ti jaꞌ laj smeltsan xtoc ti yute? ");
INSERT INTO tzotzc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Acꞌo sventain Dios ti yut avoꞌntonique. Jaꞌ yuꞌun umbi, jech lec ta xcom scotol. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Toj abol abaic ti voꞌoxuque, jfariseoetic. Jaꞌ noꞌox tsots scꞌoplal ta xavaꞌiic ti ta xaloqꞌuesic jujun ti ta lajlajunebe yoꞌ jech ta xavacꞌbeic ti Diose, ti tꞌul nichime, ti lulae, schiꞌuc scotol ti cꞌusitic ta xatsꞌunique. Pero muꞌyuc cꞌotem ta pasel avuꞌunic ti tucꞌ avoꞌntonique, ti oy scꞌuxul avoꞌntonic ta stojol ti Diose. Jaꞌ más tsots scꞌoplal ti jech ta scꞌan ta xapasique. Pero mu me xavictaic ta spasel ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Toj abol abaic ti voꞌoxuque, jfariseoetic. Jaꞌ noꞌox ta xacꞌanic ti ta xbat chotlanic ti bu ichꞌbil ta mucꞌ ti chotlebal ti ta jujun chꞌul naetique. Jaꞌ noꞌox ta xacꞌanic ichꞌbiloxuc ta mucꞌ, cꞌoponbiloxuc ti ta calletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Toj abol abaic ti voꞌoxuque, jchanubtasvanejetic yuꞌun ti mantale, jfariseoetic. Jaꞌ noꞌox ta xapacꞌta abaic. Yuꞌun jech aꞌelanic jech chac cꞌu chaꞌal smuquinal ti animae, ti mu xvinaj ti cꞌusi tiqꞌuil ta yute. Cꞌalal ta xꞌechꞌ ti cristianoetic tey ta sbae, mu snaꞌ cꞌusi tey oy ta yolon ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oy jun jchanubtasvanej yuꞌun ti mantale ti jech laj yale: ―Jchanubtasvanej, ti jech ta xaval taje, chopol ta xcaꞌicutic ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero ti Jesuse jech laj yal: ―Toj abol abaic ti voꞌoxuque, jchanubtasvanejetic yuꞌun ti mantale. Yuꞌun jaꞌ noꞌox ta xavacꞌbeic ep yicatsic ti cristianoetique ti mu xa xlic yuꞌunique. Mi jaꞌuc jutebuc sniꞌ acꞌobic ti ta xaticꞌ aba ta scoltaele. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Toj abol abaic ti voꞌoxuque. Ta xameltsanbe lec smuquinal ti jꞌalcꞌopetic ta voꞌnee ti jaꞌ laj smilic ti amolmucꞌtotique. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jaꞌ jech ta xavaqꞌuic iluc ti jmoj avoꞌntonic ti cꞌu sꞌelan laj spasic ti amolmucꞌtotic ta voꞌnee. Ti stuquique laj smilic ti jꞌalcꞌopetic ta voꞌnee. Ti voꞌoxuque ta xameltsanbe lec ti smuquinale. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ta sventa ti oy sbijil ti Diose, jech laj yal: “Ta jtac batel cajꞌalcꞌoptac, cajtacbolaltac ta stojolic. Oy jlom ta smilic. Oy jlom ta snutsic batel”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jech o xal ti cristianoetic avi liꞌe ta xꞌichꞌbat yeic yuꞌun ti Diose ti jech ilajic ta milel ti jꞌalcꞌopetique ti lic onoꞌox talel ta sliquebal banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yuꞌun ilic onoꞌox talel ta stojol Abel. Ivul cꞌalal to ta Zacarías ti jaꞌ laj smilic ta stsꞌel ti altare. Jech o xal ta xcalboxuc avaꞌiic, ti Diose ta xichꞌbe ye ti cristianoetic avi liꞌe ti jech ilajic ti jꞌalcꞌopetic ta voꞌnee. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Toj abol abaic ti voꞌoxuque, jchanubtasvanejetic yuꞌun ti mantale. Yuꞌun ti voꞌoxuque tey anacꞌojic, mu xavaqꞌuic ta ojtiquinel sbelal ti lequilale. Ti cꞌalal mu xaꞌochic ti voꞌoxuque, jaꞌ jech xtoc mu xavaqꞌuic ochuc ti buchꞌutic ta scꞌan ta xꞌoch yaꞌiic batele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cꞌalal jech laj yoꞌnton ta yalel ti Jesuse, jech ti jchanubtasvanejetic yuꞌun ti mantale, ti jfariseoetique icap sjolic ta stojol. Ep ta tos lic yilbajinic ta sjacꞌolanbel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yuꞌun ta sqꞌuelic yaꞌiic mi oy cꞌusi chopol ta xlocꞌ ta ye yoꞌ jech ta xbaj ta cꞌocꞌ, yoꞌ jech ta saꞌbeic smul. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yantic ta stsobilan sbaic talel ep ta mil ti cristianoetique, ti mu sventaicuc mi ta stacoltaan sbaique. Ti Jesuse baꞌyel jech lic yalbe ti yajchancꞌoptaque: ―Bijanic me yuꞌun ti spajubtasobil spanic ti jfariseoetique. Ti vaꞌi sꞌelan ta xcale, jaꞌ ti jaꞌ noꞌox ta spacꞌta sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yuꞌun muꞌyuc cꞌusi ta mucul ta xcom ti mu xvinaje. Muꞌyuc cꞌusi ta macal ta xcom ti mu xichꞌ aꞌyiele. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jaꞌ yuꞌun un, scotol ti cꞌusi ta xavalic ta mucule, ta xichꞌ aꞌyiel ta jamal. Manchuc mi ta mucul ti cꞌusi ta xavalique, manchuc mi lec bajal ti tiꞌ nae, pero ta onoꞌox xvinaj scotol. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Voꞌoxuc ti lec ta xquil jbatique, ta xcalboxuc avaꞌiic, mu me xaxiꞌic yuꞌun ti buchꞌutic jaꞌ noꞌox xuꞌ ta smilic ti abecꞌtalique. Yuꞌun jaꞌ noꞌox jech yepal xuꞌ yuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero ta xcalboxuc avaꞌiic ti buchꞌu ta scꞌan ti ta xaxiꞌtaique. Jaꞌ me xiꞌtaic ti Buchꞌu ti cꞌalal ta smiloxuque, ti xuꞌ yuꞌun ta xacꞌoxuc echꞌel cꞌalal to tojob mulil. Jaꞌ me xiꞌtaic taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Mi mu ta chaꞌsepuc uni taqꞌuin ta xichꞌ chonel voꞌcot ti uni mute? Pero ti Diose mu jcotuc ta xchꞌay ta yoꞌnton. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ti voꞌoxuque ti jujubej ti stsatsal ajolique atbil yuꞌun ti Diose. Jech o xal mu me xaxiꞌic. Yuꞌun más tsots acꞌoplalic. Jaꞌ mu sta ti mutetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti jamal ta xalic ti jaꞌ yuꞌunun ti Cristo ti xiic ta stojol ti cristianoetique, jaꞌ jech ti vuꞌun coꞌol jꞌelantic eque, jamal ta xcal ta stojol ti yajꞌángeltac ti Diose: “Jaꞌ cuꞌuntac leꞌe”, xichi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yan ti buchꞌutic ti ta xalic ti maꞌuc yuꞌunun ti Cristo ti xiic ta stojol ti cristianoetique, jaꞌ jech ti vuꞌun eque: “Maꞌuc cuꞌuntac leꞌe”, xichi ta stojol ti yajꞌángeltac ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Buchꞌuuc noꞌox ti chopol ta xcꞌopojic ta jtojol ti vuꞌun coꞌol jꞌelantique, xuꞌ ta xꞌacꞌbatic perdón. Yan ti buchꞌu chopol ta xcꞌopojic ta stojol ti Chꞌul Espíritue, mu xa xꞌacꞌbatic perdón. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cꞌalal icꞌbil ta xabatic ta chꞌul nae, o mi ta stojol ti jchapanvanejetique, o mi ta stojol ti jꞌopisialetique, mu xavul avoꞌntonic ti cꞌu sꞌelan ta xatacꞌavique, ti cꞌu sꞌelan xuꞌ ta xavalique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yuꞌun ti cꞌalal ta sta yorail ti ta xacꞌopojique, jaꞌ ta xacꞌboxuc anaꞌic ti Chꞌul Espíritue ti cꞌusi xuꞌ ta xavalique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oy jun vinic ta scotol ti cristianoetique ti jech laj yalbe ti Jesuse: ―Jchanubtasvanej, albo yaꞌi ti jbanquile ti acꞌo xchꞌac ti jrextocutique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ti Jesuse jech laj yal: ―Chiꞌiltic, ¿buchꞌu laj svaꞌanun ta juez ta jchꞌac-osil avuꞌunic? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jech laj yal xtoc: ―Bijanic me, qꞌuelo me abaic yuꞌun ti scꞌupijel avoꞌntonique. Yuꞌun maꞌuc ta sta o scuxlejal ti vinic ti mi oy cꞌusi ep xꞌayan yuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ti Jesuse jech laj yal jun babacꞌop: ―Oy jun jcꞌulej vinic. Ti tey ta yosile toj lec ilocꞌ ti cꞌusitic laj stsꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jech o xal ti jcꞌuleje jech lic snop: “¿Cꞌusi xuꞌ ta jpas? Muꞌyuc xa yavil ti bu xuꞌ ta jqꞌuej ti cꞌusi oy cuꞌune”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jech vul ta yoꞌnton: “¡Aaah! vul xa ta jol ti cꞌusi ta jpase. Jaꞌ ta jlomes scotol ti yav quixim ti biqꞌuitique, yoꞌ ta jmeltsan yan más mucꞌtic. Tey ta jqꞌuej scotol ti cꞌusitic xꞌayan cuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jaꞌ yuꞌun un, jech ta xcalbe jba: Jcuxtic un coꞌnton. Yuꞌun ep ti cꞌusi oy qꞌuejel cuꞌuntic ta sventa jayib jabile. Muyubajcutic, veꞌcutic, cuchꞌtic voꞌ”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ti Diose jech laj yal: “Toj bol vinicot. Yuꞌun ti acꞌobal tana liꞌe ta xacham. Jech ti cꞌusitic aqꞌuejoje, ¿buchꞌu van yuꞌun ta xcom?”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaꞌ jech ta xcꞌot ta stojol ti vinique ti buchꞌu ta sbusan ti scꞌulejal stuque, pero abol sba ta stojolal ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tsꞌacal to ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Ta melel ta xcalboxuc avaꞌiic, mu me xavulilan avoꞌntonic cꞌusi ta xata aveꞌelic yoꞌ ta xacuxiic. Jaꞌ jech xtoc mu me xavulilan avoꞌntonic cꞌusi ta xata acꞌuꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yuꞌun ti acuxlejalique jaꞌ tsots scꞌoplal. Jaꞌ mu sta ti aveꞌelique. Ti abecꞌtalique jaꞌ tsots scꞌoplal. Jaꞌ mu sta ti acꞌuꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Qꞌuelic lec ti joje. Mu snaꞌ stsꞌunobajic. Mu snaꞌ xcꞌajavic. Muꞌyuc yavil ti bu ta sqꞌuej ti sveꞌelique. Pero malqꞌuinbilic yuꞌun ti Diose. Ti voꞌoxuque jaꞌ más tsots acꞌoplalic. Jaꞌ mu sta ti mutetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Cꞌusi bal o ti jech ep xvulvun avoꞌntonique? ¿Mi yuꞌun jaꞌ to tey xnatij acuxlejalic yuꞌun? ");
INSERT INTO tzotzc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ti mi muꞌyuc cꞌusi xuꞌ avuꞌun jutebuque, ¿cꞌu yuꞌun ta xavul avoꞌntonic ta saꞌel ti cꞌusitic yane? ");
INSERT INTO tzotzc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Qꞌuelic lec cꞌu sꞌelan ta xchꞌi ti nichimetique. Mu snaꞌ xꞌabtejic. Mu snaꞌ xnaujic. Pero jaꞌ más jelavem yutsil ti nichime. Jaꞌ mu sta jech yutsil scꞌuꞌ laj slap ti ajvalil Salomone manchuc mi mu noꞌox albajuc ti scꞌulejale. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ti mi jaꞌ jech ti Dios ta scꞌuꞌiltas ti nichim ti oy ta yaxaltique ti cꞌalal ocꞌom ta xichꞌ chiqꞌuel ta cꞌoqꞌue, ¡bu xata ti mu xascꞌuꞌiltasoxuc eque! ¡Cꞌu stu un! viniquetic, mu xachꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jech o xal ti voꞌoxuque altic ti xvulvun avoꞌntonic ta saꞌel ti cꞌusi ta xaveꞌique, ti cꞌusi ta xavuchꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yuꞌun scotol ti cristianoetic liꞌ ta sba banomile, jaꞌ noꞌox stsꞌacliojic batel taje. Pero ti voꞌoxuque oy jun Atotic ti snaꞌoj lec scotol ti cꞌusitic xtun avuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jaꞌ batuc avoꞌntonic yuꞌun ti ventainel yuꞌun ti Diose. Jech xtoc umbi, ta xaꞌacꞌbatic scotol ti cꞌusitic ta xtun avuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Mu xaxiꞌic cuni chijtac. Muꞌyuc epoxuc ta melel. Pero ti Atotique xmuyubaj ta sventainoxuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jech o xal chonic scotol ti cꞌusitic oy avuꞌunique. Ti stojole acꞌbeic ti buchꞌu meꞌonetique. Jaꞌ saꞌic ti cꞌusi mu snaꞌ xlaje, yoꞌ jech oy acꞌulejalic ta vinajel ti mu snaꞌ xlaje, ti bu mu xꞌoch ti jꞌeleqꞌue, ti mu snaꞌ xjochꞌine. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ti bu oy ti acꞌulejalique, tey oy batem ti avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Chaplucoxuc me lec schiꞌuc ti alamparaic ti tsanale. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jechuc aꞌelanic jech chac cꞌu chaꞌal jun jtunel ti chapal ta smala ti cꞌusi ora ta sut talel ta nupunel ti yajvale, yoꞌ jech ta sjam ta ora ti tiꞌ na ti cꞌalal ta stije. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Xmuyubaj noꞌox ti jꞌabteletic ti jech viquil satic ta xvul taaticuc yuꞌun ti yajvale. Ta melel ta xcalboxuc avaꞌiic, jaꞌ stuc ti ajvalile ta xacꞌ chotluc ta mexa veꞌuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Manchuc mi ta xvul ta oꞌlol acꞌobal, mi ta tijil sacub, pero mi julavem ta xtaatique, xmuyubajic ti jꞌabteletic taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Naꞌic lec liꞌe, ati tauc snaꞌ ti yajval naꞌ ti cꞌusi ora ta xcꞌot ti jꞌeleqꞌue, mi jaꞌuc ta xvay. Mi jaꞌuc ta xacꞌ ta jamel ti snae yoꞌ ta xꞌelcꞌanbat ti cꞌusi oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jechuc me chaplucoxuc ti voꞌoxuque. Yuꞌun ti cꞌalal maꞌuc yorail ta xanopique, jaꞌ o ta xisut tal ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ti Pedroe jech laj sjacꞌ: ―Cajval, ti babacꞌop ti vaꞌi sꞌelan laj avale, ¿mi jaꞌ noꞌox sventa vuꞌuncutic? ¿Mi jaꞌ sventa scotol ti cristianoetique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ti Jesuse jech laj yal: ―Ti buchꞌu lequil jꞌabtele, ti oy sbijile, ta xꞌacꞌbat sventain comel sna ti yajvale, yoꞌ ta xacꞌbe sveꞌel ti schiꞌiltac ta abtel ti cꞌalal ta sta yorail ti ta xveꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xmuyubaj noꞌox ti jꞌabtele ti cꞌalal yacal ta spas yabtel ta xvul taatuc yuꞌun ti yajvale. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta melel ta xcalboxuc avaꞌiic, ti yajvale ta xacꞌbe sventain ti yajꞌabtele scotol ti cꞌusitic oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero mi jaꞌ jun chopol jꞌabtele, ta snop ti jal to scꞌan xtal ti yajvale. Jech o xal xlic yilbajin ti schiꞌiltac ta abtele. Tey chotol ta veꞌel, ta uchꞌ voꞌ schiꞌuc jyacubeletic. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jaꞌ yuꞌun un, ti chopol jꞌabtele chꞌayal yoꞌnton ta xvul taatuc yuꞌun ti yajvale, jaꞌ ti mu snaꞌ cꞌusi ora ta xvule. Jech o xal un, tey ta xꞌacꞌbat yichꞌ tsots castigo yuꞌun ti ajvalile. Jech ta xichꞌ castigo jech chac cꞌu chaꞌal ta xichꞌic ti buchꞌutic jbajmantaletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Jech ti jꞌabtele ti mi snaꞌoj lec cꞌusi ta scꞌan pasbel ti yajvale, pero mi muꞌyuc ta xchapan sba, mi muꞌyuc ta xchꞌune, jaꞌ ep ta moj ta xꞌacꞌbat tsots castigo. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ti jꞌabtele ti mu snaꞌ cꞌusi ta scꞌan pasbel ti yajvale, pero oy yan ti cꞌusi ta spase ti xuꞌ ta xichꞌ castigo yuꞌune, pero mu epuc ta moj ta xichꞌ. Yuꞌun ti buchꞌu ep ta xꞌacꞌbat sventain comele, ep ta xcꞌanbat cuenta. Jaꞌ jech xtoc ti buchꞌu muꞌyuc jaltabil ti cꞌusi ta sventaine, jaꞌ más ta xꞌichꞌbat ye. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ti vuꞌune tal jtsanbe scꞌacꞌal ti banomile. ¡Jcꞌanuc xa caꞌi ti tilemuc xae! ");
INSERT INTO tzotzc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Persa tey ta xiꞌechꞌ ta vocol. Yacalun xa batel ta vocol avi liꞌe yoꞌ jech ta xcꞌot ta tsutsel. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Mi ta xachꞌunic ti tal jcoꞌoltasbe yoꞌnton ti cristianoetique? Ta xcalboxuc avaꞌiic ti moꞌoje. Lital yoꞌ jech xlic scrontain sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yuꞌun alavi batele, ti voꞌob cristianoetic ta jbej nae, chaꞌchꞌac ti yoꞌntonique. Ti oxibique ta scrontainic ti chibe. Ti chibe ta scrontainic ti oxibique. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ti totile ta scrontain ti snichꞌone. Ti nichꞌonile ta scrontain ti stote. Ti meꞌile ta scrontain ti stsebe. Ti tsebe ta scrontain ti smeꞌe. Ti meꞌalibale ta scrontain ti yalibe. Ti alibale ta scrontain ti smeꞌalibe ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ti Jesuse jech laj yalbe xtoc ti cristianoetique: ―Ti voꞌoxuque cꞌalal ta xavilic ti ta xlic talel ti toc ta smaleb cꞌacꞌale, ta xavalic ti ta xtal voꞌe. Jaꞌ jech onoꞌox ta xcꞌot ta pasel. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cꞌalal ta xavilic ti ta xtal icꞌ ta xocon smaleb cꞌacꞌale, ta xavalic ti ta xvaꞌi ti cꞌacꞌale. Jaꞌ jech onoꞌox ta xcꞌot ta pasel. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ta xapacꞌta abaic. Xanaꞌic lec sqꞌuelel cꞌu sꞌelan ti vinajele, ti banomile. ¿Cꞌu chaꞌal mu xanaꞌic sqꞌuelel ti cꞌusi ta xcꞌot ta pasel ta atojolic avi liꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Cꞌu chaꞌal mu xanop atuquic ti cꞌusi lec ta pasele? ");
INSERT INTO tzotzc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ti mi oy buchꞌu chba yacꞌot ta yoc ta scꞌob ti jꞌopisialetique, cꞌalal jech ta xaxanavic batel ta bee, bicꞌtajeso aba, lajesbo yoꞌnton ta ora, yoꞌ mu xba yacꞌot ta stojol ti jueze. Yuꞌun ti mi lacꞌot xa ta stojol ti jueze, ta xacꞌot batel ta scꞌob ti mayole. Jech ti mayole chba sticꞌot ta chuquel. ");
INSERT INTO tzotzc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ta melel ta xcalboxuc avaꞌiic, mu xaloqꞌuic talel ta jecheꞌ noꞌox, jaꞌ to ti mi laj atoj comel scotol ti amultaique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jaꞌ o yorail ti italic jun chib viniquetique, tal xchapbeic yaꞌi ti Jesuse ti cꞌu sꞌelan laj spas ti Pilatoe, ti laj smil jun chib viniquetic ti liquemic talel ta Galileae. Tey icapij schꞌichꞌelic schiꞌuc schꞌichꞌelic ti animaletic ti tey laj smilic ta sventa smoton ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ti Jesuse jech laj yal: ―Ti jech ilajic ta milel ti jgalilea viniquetique, ¿mi yuꞌun van ta xanopic ti jaꞌ más ep ti smulique? ¿Mi jaꞌ jutuc smulic ti yan schiꞌiltaque? ");
INSERT INTO tzotzc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ta xcalboxuc avaꞌiic ti mu jechuque. Yuꞌun mi mu xajelta avoꞌntonique, acotolic jech ta xcꞌot ta atojolic ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ti vaxaclajunvoꞌ (18) ti ichamic ti cꞌalal ilom talel ti mucꞌ ta torre yuꞌun ti Siloee, ¿mi yuꞌun van ta xanopic ti jaꞌ más ep smulic ti jech ichamique? ¿Mi jaꞌ jutuc smulic ti yan cristianoetic ti nacajtic ta Jerusalene? ");
INSERT INTO tzotzc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ta xcalboxuc avaꞌiic ti mu jechuque. Mi mu xajelta avoꞌntonique, acotolic jech ta xcꞌot ta atojolic ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ti Jesuse jech lic yal babacꞌop: ―Oy jun vinic ti stsꞌunoj jpets icux ta yosile, ba sqꞌuel mi ta xacꞌ ti sate. Pero mu jbejuc laj sta. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jech o xal ti vinique jech laj yalbe ti yajchabiej-osile: “Qꞌuel avil, oy xa yoxibal jabil ti liꞌ xivaꞌvun ta sqꞌuelbel sat ti icux liꞌe. Pero muꞌyuc ta jtabe. Jech o xal tsꞌeto loqꞌuel. Jecheꞌ tey smacoj ti banomile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ti jchꞌabiej-osile jech laj stacꞌbe: “Cajval, comtsano to ti jabil liꞌe. Yuꞌun ta jlocꞌbe lec ti yoque. Ta xcacꞌbe lec scꞌaꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ti mi jech ta jpase, ta nan xacꞌ sat. Yan ti mi mu xacꞌ ti jsate, jech xtoc umbi, tsꞌeto loqꞌuel”, xi ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Oy jun cꞌacꞌal ti jaꞌ o scꞌacꞌalil cuxob oꞌntonale, ti Jesuse ta xchanubtasvan ta jun chꞌul na. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tey oy jun ants ti oy xa svaxaclajunebal (18) jabil ti vujqꞌuinbat spat yuꞌun ti pucuje. Jech o xal ti antse mu xuꞌ tucꞌ xvaꞌvun ta xanav. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cꞌalal laj yil ti Jesuse, laj yicꞌ talel. Jech laj yalbe: ―Ants, colemot xa yuꞌun ti achamele ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jech ti Jesuse laj scajan scꞌob ta sba ti antse. Ta ora noꞌox ituqꞌuib. Tey lic yalbe slequilal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ti banquilal jpasmantal tey ta chꞌul nae icap sjol. Yuꞌun ti Jesuse laj scolta ti ants ta scꞌacꞌalil ti cuxob oꞌntonale. Ti banquilale jech laj yalbe ti cristianoetique: ―Jchiꞌiltac, oy vaquib cꞌacꞌal ti xuꞌ ta xijꞌabtejotique. Jech o xal jaꞌ o yorail ti xuꞌ ta xatal avacꞌ abaic ta poxtaele. Pero maꞌuc ti ta scꞌacꞌalil ti cuxob oꞌntonale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jech ti Jesuse jech laj stacꞌbe: ―Ti voꞌoxuque ta xapacꞌta abaic. ¿Mi mu xajitunic ti avacaxique, ti aburroique yoꞌ jech ta xavacꞌbe voꞌ yuchꞌ ti cꞌalal jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale? ");
INSERT INTO tzotzc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ti ants liꞌe, jaꞌ snitilul ti Abrahame. Oy xa svaxaclajunebal (18) jabil ti chucbil yuꞌun ti pucuje. ¿Mi jaꞌ mu stacꞌ ta jcolesbe ti schamel ta scꞌacꞌalil ti cuxob oꞌntonale? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cꞌalal jech laj yal ti Jesús taje, ti yajcrontae iqꞌuexavic scotolic. Pero scotol ti cristianoetique xmuyubajic xa ti jech laj yilic ti toj mucꞌ ti cꞌusi laj yacꞌ ta ilel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ti Jesuse jech laj yal: ―¿Cꞌusi xcoꞌolaj o ti ventainel yuꞌun ti Diose? ¿Cꞌu sꞌelan ta jcoꞌoltas o? ");
INSERT INTO tzotzc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Coꞌol sꞌelan jech chac cꞌu chaꞌal ti becꞌ mostaza ti laj stsꞌun ta yosil ti vinique. Cꞌalal ta xchꞌie, jaꞌ más mucꞌ ta xbat ta scotol ti cꞌusitic yan tsꞌunobaletique. Jutuc xa mu jpetsuc ta teꞌ smucꞌul ta xbat. Jech o xal un, ti mutetique tey ta xtal spas stasic ta scꞌob cꞌobtac ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jech laj yal xtoc ti Jesuse: ―¿Cꞌu sꞌelan ta jcoꞌoltas o ti ventainel yuꞌun ti Diose? ");
INSERT INTO tzotzc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Coꞌol sꞌelan jech chac cꞌu chaꞌal ti juteb spajubtasobil pan ti ta scap ta oxib sbisol harina ti jun antse, yoꞌ jech ta xpajub scotol ti votsꞌbil harinae ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Cꞌalal ta xbat ta Jerusalene, ti Jesuse ta xꞌechꞌ chanubtasvanuc ta jujun jteclum schiꞌuc ta jujun bicꞌtal jteclum. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oy buchꞌu ti jech laj sjaqꞌue: ―Cajval, ¿mi jutuc noꞌox ti buchꞌutic ta xcolique? ―xi. Ti Jesuse jech laj stacꞌbe: ");
INSERT INTO tzotzc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Aqꞌuic persa ochanic batel ti ta biqꞌuit tiꞌ nae. Yuꞌun ta xcalboxuc avaꞌiic, ep ti buchꞌutic ta scꞌan ta xꞌochic yaꞌiique, pero mu xuꞌ xꞌochic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yuꞌun ta sta yorail ti xlic smac tiꞌ na ti yajval nae. Jech o xal ti cꞌu avepalic ti oyoxuc ta spat ti tiꞌ nae xlic acꞌojilanic ti tiꞌ nae. Jech xlic avalic: “Cajval, jambuncutic”, xachiic. Pero ti stuque jech ta stacꞌboxuc: “Mu jnaꞌ bu liquemoxuc talel”, xayutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jech ti voꞌoxuque jech xlic avalbeic: “Qꞌuel avil, jmoj lijveꞌotic, laj cuchꞌtic voꞌ. Ti ta scalleal jlumalcutic voꞌot laj achanubtasuncutic”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero ti stuque jech ta stacꞌboxuc: “Laj xa calboxuc avaꞌiic ti mu jnaꞌ bu liquemoxuc talele. Qꞌuejo abaic loqꞌuel liꞌ ta jtojole, yuꞌun acotolic laj xa apasic ti cꞌusitic chopole”, xayutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tey ta xlic avoqꞌuita abaic. Tey xlic xcꞌuxetuc aveic cꞌalal ta xavilic ti Abrahame, ti Isaaque, ti Jacobe, schiꞌuc scotol ti jꞌalcꞌopetique ti ochemic xa ti bu ta xventainvan ti Diose. Pero ti voꞌoxuque jipbiloxuc loqꞌuel. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yuꞌun ta xtalic ti cristianoetic ti ta xlic talel ta schanjotal ti banomile, yoꞌ ta xchotiic ta veꞌel ti bu ta xventainvan ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jaꞌ o yorail ti oy jlom cristianoetic ichꞌbilic ta mucꞌ avi liꞌe, pero jaꞌ mu ichꞌbiluc ta mucꞌ ta xcꞌotic. Oy jlom cristianoetic mu ichꞌbiluc ta mucꞌ avi liꞌe, pero jaꞌ ichꞌbilic ta mucꞌ ta xcꞌotic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti jech cꞌacꞌal taje, jaꞌ o tey icꞌotic jun chib jfariseoetic ti jech laj yalique: ―Locꞌan batel liꞌe. Yuꞌun ti ajvalil Herodese ta smilot yaꞌi ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero ti Jesuse jech laj stacꞌbe: ―Batanic, ba albeic yaꞌi ti mañoso vet taje: “Qꞌuel avil, ti tanae, ti ocꞌome ta to jloqꞌues ti pucujetique, ta to jcoles ti jchameletique. Jaꞌ to chaꞌej ta stsuts cuꞌun, xi”, utic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yuꞌun ta onoꞌox jtam batel ti jbe ti tanae, ti ocꞌome, ti chaꞌeje. Yuꞌun mu lecuc ti ta xlaj jun yajꞌalcꞌop Dios ti maꞌuc ta jteclum Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Jerusalén, Jerusalén, ti voꞌoxuque ta xamilic ti jꞌalcꞌopetique. Ta xapujbeic ton ti buchꞌutic tacbilic tal yuꞌun ti Diose. Ep ta velta ta jcꞌan ta jtsoboxuc caꞌi jech chac cꞌu chaꞌal ti meꞌ alacꞌ ti ta stsob ti yalab ta yolon xiqꞌue. Pero mu xacꞌanic. ");
INSERT INTO tzotzc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Qꞌuel avilic, ti voꞌoxuque jipbil ta xcom ti anaique. Yuꞌun ta xcalboxuc avaꞌiic, mu xa bu ta xavilbun ti jsate, jaꞌ to ti mi ta sta yorail ti ta xavalique: “Toj yan noꞌox yutsil ti Buchꞌu tacbil tal yuꞌun ti Cajvaltic Diose”, ti mi xachiique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Oy jun cꞌacꞌal ti jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale, bat veꞌuc ti Jesús ta sna jun banquilal yuꞌun ti jfariseoetique. Jech xtoc ti yan jfariseoetique ta xpaꞌivanic. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tey oy ta stojol xtoc jun vinic ti ip ta xaꞌi sitale. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jech ti Jesuse lic sjacꞌbe ti jchanubtasvanejetic yuꞌun ti mantale schiꞌuc ti jfariseoetique: ―¿Mi xuꞌ ta jcolestic jun jchamel ti ta scꞌacꞌalil cuxob oꞌntonale? ¿Mi mu xu? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jech ti stuquique tsꞌijil icomic. Ti Jesuse tey laj yicꞌ talel ti jchamele. Laj scoles. Laj yalbe ti acꞌo batuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jech iꞌalbatic ti jfariseoetique: ―Ti mi oy buchꞌu junucal avuꞌunic ti ta xbaj ta jocꞌ ti aburroique, ti avacaxique, ¿mi muꞌyuc van chbat aloqꞌuesic talel ta ora noꞌox manchuc mi scꞌacꞌalil cuxob oꞌntonal? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero muꞌyuc xtacꞌ yuꞌunic jbeluc. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cꞌalal ti Jesús laj yil ti jqꞌuel-nupunel ti ta stꞌujic chotlebal ti ichꞌbilic ta mucꞌ tey ta mexae, jech lic bijubtasvanuc: ");
INSERT INTO tzotzc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Mi oy buchꞌu ta xayiqꞌuic ta qꞌuel nupunele, mu me jaꞌuc chba achotan aba ta sliqueb chotlebal. Yuꞌun xuꞌ ta xcꞌot yan achiꞌil ti más ichꞌbil ta mucꞌ yuꞌun ti buchꞌu laj yicꞌot ta qꞌuine, ti jaꞌ mu sta ti voꞌote. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ti buchꞌu laj yicꞌoxuc ta qꞌuine xuꞌ ti jech ta xalbote: “Chiꞌiltic, ictao comel ti bu chotolote. Acꞌo chotluc ti jun liꞌe”, xayut. Jech ti voꞌote ta qꞌuexlal xa ta xba chotlan ti ta slajeb xa chotlebal ti ta patile. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cꞌalal ti mi oy buchꞌu ta xicꞌot ta qꞌuel nupunele, jaꞌ lec ti mi ta xachoti noꞌox ta patile. Cꞌalal ta xilot ti buchꞌu laj yicꞌote, xuꞌ ta xalbot: “Chiꞌiltic, jelavan talel liꞌ ta chotlebal ti jaꞌ ichꞌbil ta muqꞌue”, xayut. Jaꞌ jech ichꞌbilot ta mucꞌ ta xacꞌot yuꞌunic ti buchꞌutic tey chotajtic ta mexae. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yuꞌun ti buchꞌu ta xacꞌ sba ta ichꞌel ta muqꞌue, jaꞌ ta xpecꞌtsanbat scꞌoplal. Yan ti buchꞌu biqꞌuit ta xacꞌ sbae, jaꞌ ta xꞌacꞌat ta ichꞌel ta mucꞌ ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ti Jesuse jech laj yalbe ti vinic ti buchꞌu iꞌicꞌvane: ―Cꞌalal ti mi oy buchꞌu ta xavicꞌ ta veꞌele, mu me jaꞌuc noꞌox ta xavicꞌ ti buchꞌutic lec xavil aba achiꞌuque, ti avermanotaque, ti avutsꞌ avalaltaque, ti alacꞌna jcꞌulejique. Yuꞌun ti stuquique xuꞌ ta spacbot sutel. Jech ti voꞌote jaꞌ noꞌox jech yepal sqꞌuexol laj ata. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cꞌalal ta xapas ti qꞌuine, jaꞌ lec icꞌo talel ta veꞌel ti buchꞌutic abol sbaique, ti mancoetique, ti coxovetique, ti maꞌsatetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Xamuyubaj ti jech ta xapase. Yuꞌun ti stuquique muꞌyuc sqꞌuexol yuꞌunic. Pero ti voꞌote ta xavichꞌbe sqꞌuexol ti cꞌalal ta xchaꞌcuxiic ti buchꞌutic lec yoꞌntonique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cꞌalal jech laj yaꞌiic taje, oy jun ta scotol ti tey chotolic ta mexae jech laj yalbe ti Jesuse: ―Toj yan noꞌox yutsil ti buchꞌutic ta xꞌoch veꞌicuc ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ti Jesuse jech laj yal: ―Oy jun vinic laj yacꞌ jun mucꞌul veꞌel. Laj yal mantal ti acꞌo yichꞌ iqꞌuel talel epal cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cꞌalal yorail xa ti veꞌele, laj yalbe ti yajꞌabtele: “Batan, ba albo yaꞌiic ti buchꞌutic icꞌbilique, laꞌic la, yuꞌun chapajem xa scotol, xavut”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Scotol ti buchꞌutic icꞌbilique tey lic spac scꞌoplalic. Ti june jech laj yal: “Jaꞌ to noꞌox laj jman cosil. Tsots scꞌoplal chba jqꞌuel. Mu xuꞌ xibat. Ta xavil ti jtoyobbaile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ti yan xtoque jech laj yal: “Jaꞌ to noꞌox laj jman voꞌob par cajꞌabtel vacax. Ta jcꞌan jqꞌuel cꞌu sꞌelan ta xꞌabtej. Jech ta xavil ti jtoyobbaile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ti yan xtoque jech laj yal: “Jaꞌ to noꞌox linupun. Jech o xal mu cꞌusi xcut ta xibat”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ti jꞌabtele cꞌot yalbe ti yajvale ti vaꞌi sꞌelan itacꞌavic ti cristianoetique. Jech o xal ti ajvalile toj chopol iyaꞌi. Jech laj yalbe ti yajꞌabtele: “Batan ta ora ta jteclum. Ba xanavan ta calletic, ta bicꞌtal beetic. Icꞌo talel ti buchꞌutic abol sbaique, ti coxovetique, ti maꞌsatetique, ti mancoetique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tsꞌacal to isutic talel ti jꞌabtele. Jech cꞌot yal: “Cajval, laj xa jpas jech chac cꞌu chaꞌal laj avale. Pero xocol to ti chotlebale”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jech ti ajvalile jech laj yalbe ti yajꞌabtele: “Batan yan velta xtoc ta calletic ta jteclum, ta bicꞌtal beetic. Persa icꞌo talel ti cristianoetic ti tey ta xatae yoꞌ ta xnoj ti jnae. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yuꞌun ta melel ta xcalboxuc avaꞌiic, scotol ti buchꞌu baꞌyel laj quiqꞌue mi junuc buchꞌu ta xveꞌ ta jnaꞌ”, xi ti ajvalile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ep ti cristianoetic ti tsꞌacajtic batel ta spat ti Jesuse. Ti Jesuse ijoybij. Jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ti mi oy buchꞌu ta scꞌan ta xtal ta jtojole, pero mi mu xtuchꞌ ta yoꞌnton ti stote, ti smeꞌe, ti yajnile, ti snichꞌnabtaque, ti yermanotaque, ti yixleltaque, ti scuxlejal stuque, mu xuꞌ ta xcom ta cajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jaꞌ jech xtoc ti buchꞌu ta scꞌan ta xistsꞌacli batele, pero mi mu scꞌan xichꞌ svocol ta jventa ti vuꞌune, mu xuꞌ ta xcom ta cajchancꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mi oy buchꞌu junucal avuꞌunic ti ta scꞌan ta smeltsan yaꞌi ti natil torree, ¿mi mu baꞌyeluc ta xchoti ta snopel cꞌu yepal ta xlaj yoꞌ jech ta xil mi stsuts o yuꞌun ti yabtele? ");
INSERT INTO tzotzc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yan ti mi ta jech noꞌox yepal ta xlic abtejuque, ta xlic sliquesbe ti yoque, tsꞌacal to mi mu stsuts yuꞌune, cꞌalal ta xilic ti muꞌyuc stsuts yuꞌune, ta xlic labanatuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Jech ta xꞌalbat: “Ti vinic leꞌe lic smeltsan ti torree. Pero muꞌyuc stsuts yuꞌun”, xi scꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mi oy jun ajvalil ti ta spas leto schiꞌuc yan ajvalile, ¿mi mu baꞌyeluc ta xchoti ta snopel lec mi xuꞌ yuꞌun ta stsalel ti jtob ta mil (20,000) soldado yajcrontae ti cꞌalal lajunmil (10,000) noꞌox ti yajsoldado stuque? ");
INSERT INTO tzotzc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mi ta xaꞌi ti mu xuꞌ yuꞌune, cꞌalal jech nom to xtal ti yajcrontae, ta stac batel yajtuneltac ta scꞌanel ti acꞌo pajuc ti cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jech o xal un, buchꞌuuc noꞌox ti voꞌoxuque ti mu xtuchꞌ ta avoꞌntonic ti cꞌusi oy avuꞌunique, mu xuꞌ ta xacomic ta cajchancꞌoptac. ");
INSERT INTO tzotzc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ti atsꞌame toj tunel. Pero mi ta xchꞌay schiꞌile, ¿mi oy to cꞌusi ta xtun o? ");
INSERT INTO tzotzc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mi jaꞌuc ta xtun ta scꞌaꞌal banomil. Mi jaꞌuc ta xtun ti ta xichꞌ capel ti bu busul ti cꞌaꞌepe. Jaꞌ noꞌox taniel ta xbat. Ti buchꞌu oy schiquine, acꞌo yaꞌiic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Scotol ti jcꞌanpatantaqꞌuinetique schiꞌuc ti jsaꞌmuliletique inopajic batel yoꞌ jech ta xaꞌiic ti cꞌusi ta xal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pero ti jfariseoetique, ti jchanubtasvanejetic yuꞌun ti mantale tey lic labanvanicuc. Jech laj yalic: ―Ti vinic leꞌe lec ta xaꞌi ta xicꞌ ta xchiꞌin ta veꞌel ti jsaꞌmuliletique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jech ti Jesuse jech lic yalbe jun babacꞌop: ");
INSERT INTO tzotzc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Mi oy buchꞌu junucal avuꞌunic ti oy voꞌvinic (100) ta cꞌot ti schije, ti mi chꞌay comel jcotuque, ¿mi mu teyuc lamal ta xicta comel ta yaxaltic ti yepale yoꞌ ta xba saꞌ tal ti jcot chꞌayeme? ¿Mi mu jechuc ta spas jaꞌ to ti mi laj sta talele? ");
INSERT INTO tzotzc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cꞌalal mi laj sta talele, xmuyubaj xa ta scajan talel ta snequeb. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cꞌalal mi cꞌot ta snae, ta xba stsob talel ti schiꞌiltaque, ti slacꞌnataque. Jech ta xal: “Muyubajcutic. Yuꞌun laj xa jta ti jcot jchij ti chꞌayem to oxe”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ta xcalboxuc avaꞌiic, jaꞌ noꞌox jech ec ti Dios ti oy ta vinajele xmuyubaj xa ti cꞌalal ta sjelta yoꞌnton ti jun jsaꞌmulile. Jaꞌ mu sta xmuyubaj yuꞌun ti balunlajuneb yoꞌvinic (99) ti buchꞌu lec onoꞌoxe, ti mu xa persauc ta sjelta ti yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Qꞌuel avilic, mi oy jun ants ti oy lajunsep staqꞌuine, mi ta xchꞌay yuꞌun ti june, ¿mi mu xlic stsan ti slamparae, mi mu naca sta xlic smes ti yut snae jaꞌ to ti mi laj stae? ");
INSERT INTO tzotzc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Cꞌalal mi laj stae, ta xicꞌ talel ti schiꞌiltaque, ti slacꞌnataque. Jech ta xal: “Muyubajcutic. Yuꞌun laj jta ti jsep taqꞌuin ti chꞌayem cuꞌune”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ta melel ta xcalboxuc avaꞌiic, jaꞌ noꞌox jech ec ti yajꞌángeltac ti Diose xmuyubajic xa ti cꞌalal ta sjelta yoꞌnton ti jun jsaꞌmulile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jech laj yal xtoc ti Jesuse: ―Oy jun vinic ti oy chaꞌvoꞌ snichꞌone. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ti itsꞌinale jech laj yalbe ti stote: “Tot, acꞌbun ti jrexto ti cꞌu yepal ta onoꞌox xavacꞌbune”, xi. Jech ti totile lic xchꞌacbe ti snichꞌnab ti cꞌusi oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ti itsꞌinale mu xa jaluc cꞌacꞌal ijalij. Lic xchon ti cꞌu yepal sparte ti iꞌacꞌbat yuꞌun ti stote. Ti stojole, ibat schiꞌuc cꞌalal to yan lum. Tey lic yixtolan ti staqꞌuine. Laj yacꞌbe sba ti cꞌusi xa scꞌan ti yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cꞌalal laj xa slajes scotol ti staqꞌuine, jaꞌ o ital tsots viꞌnal ti tey ta jteclume. Jech ti stuque lic yaꞌi viꞌnal. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jech ti stuque ba saꞌ yabtel ta stojol jun vinic ti tey ta jteclume. Tsꞌacal to un, itacat batel ta sqꞌuelel chitom ta yosil ti ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ti stuque ta scꞌan ta snojes yaꞌi ti schꞌut yuꞌun sveꞌel ti chitome. Yuꞌun muꞌyuc buchꞌu xꞌacꞌbun ti sveꞌele. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ti stuque jech lic snop ta yoꞌnton: “Jun yepal jꞌabteletic ta sna ti jtote, oy lec sveꞌelic. Sobra to yuꞌunic. Pero ti vuꞌun liꞌe ta xicham ta viꞌnal. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ta xichaꞌsut batel ti bu oy ti jtote. Jech ta xcꞌot calbe: Tot, laj xa jta jmul ta stojol ti Diose. Laj xa jta jmul ta atojol ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mu xa xtal yutsil ti ta xabisun ta anichꞌone. Bisun xa noꞌox jech chac cꞌu chaꞌal junuc avajꞌabtel, ta xcut cꞌotel”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jech o xal un, lic stam batel ti sbee. Isut batel ta sna ti stote. ’Cꞌalal nom to scꞌan ta xcꞌote, laj yil ti totile. Icꞌuxubaj yoꞌnton yuꞌun. Ba snup ta be ta anil. Laj smey. Laj sbutsꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ti nichꞌonile jech laj yal: “Tot, laj xa jta jmul ta stojol ti Diose, ta atojol ec. Mu xa xtal yutsil xabisun ta anichꞌon”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ti totile jech laj yalbe ti yajꞌabteltaque: “Ba loqꞌuesic talel ta ora ti lequil cꞌuꞌile. Acꞌbeic slap ti jnichꞌone. Jaꞌ jech xtoc acꞌbeic ti yixtolal sniꞌ scꞌobe schiꞌuc xonob. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nitic talel ti jubem chꞌin vacaxe. Milic. Ta jtiꞌtic. Yuꞌun ta jpastic qꞌuin. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yuꞌun ti jnichꞌon liꞌe chamem xa ox, pero icuxi talel. Chꞌayem to ox, pero laj xa jtatic”, xi. Jech tey lic spasic ti qꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Yan ti banquilal nichꞌonile oy ta yosil. Cꞌalal isut talele, cꞌalal nopol xa scꞌan ta xcꞌot ta nae, jaꞌ o laj yaꞌi ti musicae schiꞌuc ti acꞌote. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ti stuque laj yicꞌ talel jun jꞌabtel. Laj sjacꞌbe ti cꞌusi ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ti jꞌabtele jech laj yal: “Yuꞌun isut xa talel ti avitsꞌine. Jech o xal ti atote laj yal mantal ti laj yichꞌ milel ti jun jubem chꞌin vacaxe. Yuꞌun lec ivul. Muꞌyuc cꞌusi laj spas”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero ti banquilal nichꞌonile icap sjol. Cꞌalal mu scꞌan xꞌoch batel ta nae, ilocꞌ talel ti totile. Tal scꞌanbe vocol ti acꞌo ochuc batele. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ti stuque jech laj yalbe ti stote: “Ti voꞌote xanaꞌ ti ep xa jabil ti ta xitun avuꞌune. Muꞌyuc jtoy jba ta atojol. Pero mi jaꞌuc laj avacꞌbun mi jcotuc chivo yoꞌ ta jpascutic qꞌuin schiꞌuc ti buchꞌutic lec xquil jbacutic jchiꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Avi tana un, cꞌalal vul ti anichꞌon ti laj yixtolanbot ta ants ti ataqꞌuine, laj amilbe ti jubem chꞌin vacaxe”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jech ti totile jech laj yalbe: “Nichꞌon, scotol cꞌacꞌal liꞌ jchiꞌinojote. Scotol ti cꞌusi oy cuꞌune, jaꞌ avuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Avi tana un, jech scꞌan ti jech ta jpastic ti qꞌuine. Muyubajcutic. Yuꞌun ti avitsꞌine chamem to ox, pero icuxi xa talel. Chꞌay to ox, pero laj xa jtatic”, xꞌutat ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ti Jesuse jech lic yalbe xtoc ti yajchancꞌoptaque: ―Oy jun jcꞌulej vinic. Oy jun yajꞌabtel ti yichꞌoj ta sventa ti cꞌusitic oy yuꞌune. Oy buchꞌu bat, ba yal ta stojol ti ajvalile ti ta xꞌixtolanbat yuꞌun ti yajꞌabtele ti cꞌusitic oy yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jech o xal ti ajvalile laj stac ta iqꞌuel ti yajꞌabtele. Jech laj yalbe: “¿Cꞌu chaꞌal ti jech ta xcaꞌi acꞌoplal taje? Chapanbun talel scotol ti cꞌusitic avichꞌoj ta aventae. Yuꞌun mu xa xuꞌ ta xacom aventainbun ti cabtele”, xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ti jꞌabtele jech lic snop: “¿Cꞌusi xuꞌ ta jpas taje? Yuꞌun ti cajvale ta xa xistuchꞌbun ti cabtele. Yuꞌun mu xa xuꞌ cuꞌun tsots ti abtele. Mi ta xba jcꞌan limoxnae, ta xiqꞌuexav. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Aaah! laj xa jnaꞌ cꞌusi xuꞌ ta jpas yoꞌ xuꞌ ta xiyiqꞌuic ochel ta yut snaic ti cꞌalal chꞌabal xa ti cabtele”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jech o xal un, ti jꞌabtele lic sta ta iqꞌuel ta jujun tal ti buchꞌutic oy yilic yuꞌun ti ajvalile. Jech ti buchꞌu baꞌyel icꞌote laj sjacꞌbe: “¿Cꞌu yepal avil yuꞌun ti cajvale?”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ti stuque jech laj stacꞌ: “Oy voꞌvinic (100) barril aceite quil yuꞌun”, xi. Ti jꞌabtele jech laj yalbe: “Liꞌ oy svunal ti avile. Chotlan ta ora. Tsaco comel lajuneb yoxvinic (50) barril noꞌox”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tsꞌacal to jech lic sjacꞌbe ti jun xtoque: “Ti voꞌote, ¿cꞌu yepal avil?”, xut. Ti stuque jech laj yal: “Oy voꞌvinic (100) ta bis trigo quil yuꞌun”, xi. Ti jꞌabtele jech laj yalbe: “Liꞌ oy svunal avil. Jaꞌ noꞌox tsaco chanvinic (80) ta bis”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ti ajvalile laj yil ti echꞌem sbijil ti chopol yajꞌabtele, ti ta sta ti cꞌusi ta xtun yuꞌune. Yuꞌun ti cristianoetic liꞌ ta sba banomile toj lec snaꞌic cꞌu sꞌelan ta scolta sbaic ta jujun tal yoꞌ lec oyic. Jaꞌ mu sta ti buchꞌutic ti oyic ta saquilal osile. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Jech o xal jech ta xajcꞌubanboxuc, tunesic ti cꞌusi oy avuꞌunic liꞌ ta banomil ti snaꞌ xlaje yoꞌ jech ta xacoltavanic. Yuꞌun ti cꞌalal ta xlaj scꞌoplal ti cꞌusitic ta xatunesique, oy buchꞌu xmuyubaj xa ta xayicꞌoxuc ochel ta vinajel. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ti buchꞌu ta slequil yoꞌnton ta stunes ti juteb cꞌusi oy yuꞌune, jaꞌ jech xtoc ta slequil yoꞌnton ta stunes ti ep cꞌusi oy yuꞌune. Yan ti buchꞌu muꞌyuc slequil yoꞌnton ta stunes ti juteb oy yuꞌune, jaꞌ jech xtoc umbi, muꞌyuc slequil yoꞌnton ta stunesel ti cꞌusi ep yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mi mu ta slequiluc avoꞌntonic ta xatunesic ti cꞌusitic xꞌayan avuꞌunic liꞌ ta sba banomil ti snaꞌ xlaje, ¿buchꞌu ta xacꞌboxuc atunesic ti batsꞌi cꞌulejale? ");
INSERT INTO tzotzc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mi mu ta slequiluc avoꞌntonic ta stunesel ti maꞌuc avuꞌunique, ¿buchꞌu ta xayacꞌboxuc avichꞌic ti cꞌusi jaꞌ avuꞌun atuquique? ");
INSERT INTO tzotzc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Muꞌyuc buchꞌu xuꞌ ta xꞌabtej ta chaꞌvoꞌ ajvalil. Yuꞌun ti june, lec ta xcꞌanat. Yan ti june, mu lecuc ta xcꞌanat. Ti june, lec ta xꞌabtej ta stojol. Yan ti june, ta stoy sba ta stojol. Jaꞌ jech ti voꞌoxuc eque, mu xuꞌ ta xavacꞌ abaic ta tunel yuꞌun ti Diose ti mi jaꞌ batem avoꞌntonic yuꞌun ti taqꞌuine ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ti jfariseoetique, cꞌalal laj yaꞌiic ti jech laj yal ti Jesuse, tey lic slabanic. Yuꞌun jaꞌ noꞌox batem ta yoꞌntonic ta scꞌanel ti taqꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ti Jesuse jech laj yalbe: ―Ti voꞌoxuque ta xapacꞌta abaic. Yan noꞌox yutsil avoꞌntonic ta xavaqꞌuic iluc yilel ta stojol ti cristianoetique. Pero yiloj avoꞌntonic ti Dios ti cꞌu aꞌelanique, ti jaꞌ noꞌox ichꞌbiloxuc ta mucꞌ yuꞌun ti cristianoetique. Pero ti Diose ta sbajoxuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Cꞌalal mu to ox ta xvul ta loqꞌuel ti Juane, tey xa onoꞌox oy smantal ti Moisese schiꞌuc ti cꞌu sꞌelan ichanubtasvan ti jꞌalcꞌopetique. Pero cꞌalal jech itale, jaꞌ o tey lic yalbe scꞌoplal ti lequil cꞌope, ti jaꞌ ti ventainel yuꞌun ti Diose. Jech o xal ep ti buchꞌutic ta xaqꞌuic persa yoꞌ ta xꞌochique. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Scotol smantal ti Diose ta onoꞌox xcꞌot ta pasel. Mi jaꞌuc juteb stacꞌ chꞌayel. Más to xuꞌ ta stacꞌ chꞌayel ti vinajele, ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Ti jun vinic ti ta sbaj sbaic schiꞌuc ti yajnile, ti mi chba yicꞌ yan antse, laj xa sta smul. Jaꞌ jech xtoc ti buchꞌu ta xicꞌ ti bajbil antse, laj xa sta smul ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Oy jun jcꞌulej vinic ti jun yutsiquil ti scꞌuꞌ ta slape. Jaꞌ jech xtoc jun yutsiquil ti sveꞌel ti ta slajese. Jaꞌ jech xtoc jujun cꞌacꞌal ta spas qꞌuin. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oy jun vinic xtoc ti abol sbae, ti jaꞌ Lázaro sbie. Noj ta yayijemal chamel ti sbecꞌtale. Tey xchotet ta stiꞌ sna ti jcꞌuleje. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ti pobre vinic taje ta scꞌan ta slajes yaꞌi ti cꞌusitic ta xbaj yalel ta smexa ti jcꞌuleje. Jaꞌ jech xtoc ta xtal lecꞌbatuc yuꞌun tsꞌiꞌ ti syayijemale. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sta scꞌacꞌalil, icham ti pobre vinique. Icꞌat batel yuꞌun ángeletic yoꞌ jech chba xchiꞌin sbaic schiꞌuc ti Abraham ti oy ta lequilale. Jaꞌ jech xtoc ti jcꞌuleje icham ec. Laj yichꞌ muquel. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Cꞌalal ta xichꞌ svocol ti jcꞌulej tey ti bu ta xbat ti animaetique, laj stoy muyel sat. Tey laj yil ta nom ti Abrahame schiꞌuc ti Lázaroe. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jech ti jcꞌuleje tey lic avanuc: “Totic Abraham, ichꞌun ta cꞌux. Albo yaꞌi ti Lázaroe ti acꞌo stsꞌaj talel jutebuc sniꞌ scꞌob ta voꞌ yoꞌ xtal sicubtasbun ti coqꞌue. Yuꞌun ta xquichꞌ ep vocol ti liꞌ ta cꞌoqꞌue”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ti Abrahame jech laj yalbe: “Nichꞌon, vuleso ta avoꞌnton ti cꞌalal tey to ox oyot ta sba banomile, laj ata scotol ti cꞌusi ta scꞌan ti avoꞌntone. Ti Lázaro liꞌe toj abol sba iꞌechꞌ ta sba banomil. Ta ora ti stuque laj xa sta ti lequilal liꞌe. Yan ti voꞌote ta xavichꞌ avocol. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jaꞌ jech xtoc, yuꞌun oy jun mucꞌ ta liquil chꞌen ta oꞌlol cuꞌuntic. Jech o xal, manchuc mi oy buchꞌu ta scꞌan ta xjelav talel ti bu oyote, mu xuꞌ. Jaꞌ jech xtoc, manchuc mi oy buchꞌu ta scꞌan ta xtal yaꞌi ti liꞌ bu oyuncutique, mu xuꞌ”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jech o xal ti jcꞌuleje jech laj yal: “Chꞌul abolajan, Totic Abraham, taco batel ti Lázaro ta sna ti jtote. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yuꞌun tey oy voꞌob jchiꞌil ta voqꞌuel. Ta jcꞌan ti acꞌo ba yalbe yaꞌi yoꞌ jech mu xtalic liꞌ ta tsots vocole”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ti Abrahame jech laj yal: “Ti stuquique oy ta scꞌobic ti cꞌusitic tsꞌibabil yuꞌun ti Moisese schiꞌuc ti jꞌalcꞌopetique. Acꞌo xchꞌunic”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ti jcꞌuleje jech itacꞌav: “Jech, Totic Abraham, pero mu xchꞌunic. Pero mi ta xilic ti oy buchꞌu ta xchaꞌcuxi batele, ta sjelta ti yoꞌntonique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ti Abrahame jech laj yal: “Mi mu scꞌan xchꞌunic ti cꞌusitic tsꞌibabil yuꞌun ti Moisese schiꞌuc ti jꞌalcꞌopetique, jaꞌ jech xtoc mu onoꞌox xchꞌunic, acꞌo mi oy buchꞌu ta xchaꞌcuxi batel”, xi ti Abrahame ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Oy onoꞌox cꞌusi ta sbajesatic ta mulil ti cristianoetique. Pero toj abol sba ti buchꞌu jaꞌ ta scoj ta syales ta mulil ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ti buchꞌu jeche, jaꞌ lec ti chuc xi choꞌ ta snucꞌ, jip xi yalel ta nab yoꞌ jech mu xchanubtas ta sa mulil junuc ti ololetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Bijanic me. Mi oy jun achiꞌil ti laj saꞌ smul ta atojole, albo yaꞌi ta jamal. Mi ta sjelta ti yoꞌntone, acꞌbo perdón. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Manchuc mi ta saꞌ smul ta atojol vucub velta ta cꞌacꞌal, jaꞌ jech xtoc mi vucub velta ta xtal yalbot: “Mu xa bu ta jpas yan velta”, mi xie, acꞌbo perdón ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ti yajtacbolaltac ti Jesuse jech laj yalic: ―Coltauncutic ta xchꞌunelot más ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti Cajvaltique jech laj yal: ―Ti achꞌunojicuc jutebuc ti xuꞌ yuꞌun ti Diose, acꞌo mi jech chac cꞌu chaꞌal smucꞌul ti sbecꞌ mostazae, xuꞌ ta xavalbeic ti jpets sicómoro teꞌ liꞌe: “Pitso aba loqꞌuel liꞌe, ba tsꞌuno aba ta nab”, mi xavutique, jech ti teꞌe ta xchꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ti voꞌoxuque mi oy jun avajꞌabtel ti cꞌalal ta sut talel ta abtele, mi ta sqꞌuelel ti vacaxe, ¿mi yuꞌun van ta xavalbeic: “Laꞌ, ochan talel, chotlan, veꞌan”, mi xavutic? ");
INSERT INTO tzotzc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mu jechuc. Ti voꞌoxuque jech ta xavalbeic: “Chapano talel jveꞌel yuꞌun ta xiveꞌ ta xcuchꞌ voꞌ. Tsꞌacal to xuꞌ ta xaveꞌ ta xavuchꞌ voꞌ ti voꞌote”, xavutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Mi yuꞌun van ta xavalbeic: “Colaval”, xavutic, cꞌalal laj spas ti cꞌusi laj avalbee? Mu jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaꞌ jechoxuc ec, cꞌalal mi laj apasic ti cꞌu sꞌelan yaloj ti Diose, ta scꞌan ti jech ta xavalbeique: “Muꞌyuc cꞌusi xituncutic o. Yuꞌun jaꞌ noꞌox jech yepal laj jpascutic ti cꞌu yepal laj caꞌi ti jaꞌ cabtelcutique”, xavutic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cꞌalal jech ta xanav batel ta Jerusalén ti Jesuse, tey iꞌechꞌ batel ti bu stsꞌaquinoj sba yosilic ti Samaria banomile schiꞌuc ti Galileae. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cꞌalal tey icꞌot ta jun biqꞌuit jteclume, jaꞌ o tey italic lajunvoꞌ (10) viniquetic ti tsacbilic ta cꞌaꞌemal chamele. Pero nom vaꞌajtic icomic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tey lic avanicuc: ―Jesús, Jchanubtasvanej, cꞌuxubinuncutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Cꞌalal jech laj yil ti Jesuse, jech laj yal: ―Batanic, ba acꞌo abaic ta ilel ta stojol ti paleetique ―xi. Cꞌalal jech ta xanavic batele, jaꞌ o tey icol ti schamelique. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oy buchꞌu jun yuꞌunic ti cꞌalal laj yil ti colem xae, isut talel. Tsots xꞌavet xa talel ta xalbe slequilal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tey ivul squejan sba ta stojol ti Jesuse. Laj spatan sba cꞌalal to lum yoꞌ ta xalbe colaval. Ti vinic taje jaꞌ jun jsamaria. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jech ti Jesuse jech laj yal: ―¿Mi mu lajunvoꞌicuc ti icol ti schamelique? ¿Bu oy ti yan balunebe? ");
INSERT INTO tzotzc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Mi cꞌajomal noꞌox stuc isut talel ti jyanlum vinique yoꞌ ta xalbe slequilal ti Diose? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jech lic yalbe ti vinique: ―Lican, batan. Colemot xa, yuꞌun laj achꞌunun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ti jfariseoetique laj sjacꞌbeic ti Jesuse cꞌusi ora ta xvul ti ventainel yuꞌun ti Diose. Ti Jesuse jech laj stacꞌbe: ―Cꞌalal ta xvul ta loqꞌuel ti ventainel yuꞌun ti Diose, mu xvinaj ta qꞌuelel. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mu xuꞌ ta xalic ti liꞌ xa oye, ti leꞌ xa oye, ti xiique. Yuꞌun ti ventainel yuꞌun ti Diose liꞌ xa oy ta atojolique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jech laj yalbe yaꞌi ti yajchancꞌoptaque: ―Oy bu ta sta jun cꞌacꞌal ti ta xacꞌanic ti ta xaqꞌuelicun avaꞌi ti vuꞌun coꞌol jꞌelantique. Pero mu xavilicun. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Oy buchꞌu jech ta xalic: “Liꞌ xa oye, leꞌ xa oye”, xiic. Pero mu me xabatic, mu me xatsꞌacliic batel ti buchꞌu jech ta xalic taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yuꞌun cꞌalal ta sta scꞌacꞌalil ti ta xital ti vuꞌun coꞌol jꞌelantique, coꞌol sꞌelan jech chac cꞌu chaꞌal ti sactselavel ti yan sꞌelan xjaplajet buꞌyuc noꞌox ta jujot vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero baꞌyel ep ta xquichꞌ vocol. Yuꞌun ta xisbajicun ti cristianoetic avi liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jech chac cꞌu chaꞌal laj spasic ti cristianoetic ti cꞌalal cuxul to ox ti Noee, jaꞌ noꞌox jech ta spasic ti cꞌalal ta xichaꞌsut talel ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yuꞌun ti stuquique jaꞌ noꞌox batem ta yoꞌntonic ti veꞌele, ti uchꞌ voꞌe, ti ta xicꞌan sbaique, ti ta xacꞌ ta nupunel ti yalab snichꞌnabique. Jaꞌ jech laj spasolanic o ti cristianoetique jaꞌ to ti cꞌalal iꞌoch batel ta barco ti Noee. Tal ti nojel ta voꞌe. Icham scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaꞌ jech icꞌot ta pasel xtoc ti cꞌalal cuxul to ox ti Lote. Yuꞌun ti cristianoetique jaꞌ noꞌox batem ta yoꞌntonic ta xveꞌic, ta xuchꞌic voꞌ, ta xmanolajic, ta xchonolajic, ta stsꞌunobajic, ta spas snaic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero cꞌalal ilocꞌ batel ti Lot ti ta jteclum Sodomae, jaꞌ o iyal talel ti cꞌocꞌ schiꞌuc asufre ti ta vinajele. Tey imilatic scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jaꞌ jech stalel yoꞌntonic ti cristianoetic ti cꞌalal ta sta yorail ti ta xichaꞌsut talele, ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ti jech cꞌacꞌal taje, mi oy buchꞌu muyem batel ta schaꞌcojal snae, mu xa me xyal batel ta sloqꞌuesel ti cꞌusitic oy yuꞌune. Jaꞌ jech xtoc mi oy buchꞌu batem ta yabtele, mu xa me sut talel ta sna. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Vuleso me ta avoꞌntonic ti cꞌu sꞌelan icꞌot ta pasel ta stojol yajnil ti Lote. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ti buchꞌutic ta spoj yaꞌiic ti scuxleje, jaꞌ ta xchꞌay. Yan ti buchꞌutic mu spoj ti scuxleje, jaꞌ ta sta ti scuxlejale. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Jaꞌ o ta yacꞌobalil taje, ta xcalboxuc avaꞌiic ti oy buchꞌu chaꞌvoꞌ ti jmoj ta xvayic ta jun teme, jun ta xꞌicꞌat batel, jun ta scomtsanat. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ti chaꞌvoꞌ antsetic ti jmoj ta xjuchꞌinajique, jun ta xꞌicꞌat batel, jun ta scomtsanat. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ti chaꞌvoꞌ viniquetic ti jmoj ta xꞌabtejic ta yosilique, jun ta xꞌicꞌat batel, jun ta scomtsanat ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cꞌalal jech laj yaꞌiic ti yajchancꞌoptaque, jech lic sjaqꞌuic: ―¿Bu ta xcꞌot ta pasel ti vaꞌi sꞌelan taje, Cajval? ―xiic. Ti Jesuse jech laj stacꞌ: ―Ti bu oy ti animae, tey ta stsob sbaic batel ti xulemetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ti Jesuse jech laj xchanubtas ta babacꞌop ti yajchancꞌoptaque yoꞌ jech mu xlubtsajic ta stael ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jech lic yal: ―Oy jun juez ta jun jteclum ti muꞌyuc cꞌusi bal o ta xaꞌi ti Diose. Muꞌyuc cꞌusi bal o ta xaꞌi ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti ta jteclum taje, oy tey jun meꞌunal ants ti ta xcꞌot scꞌan parte ta stojol ti jueze yuꞌun yajcronta. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero ti jueze ep cꞌacꞌal ti muꞌyuc laj xchapan ti antse. Tsꞌacal to lic snop: ");
INSERT INTO tzotzc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","“Acꞌo mi muꞌyuc cꞌusi bal o ta xcaꞌi ti Diose, acꞌo mi mu jventauc ti cristianoetique, pero taꞌlo xcaꞌi ti liꞌ xvaꞌvun ta jtojol ti antse. Jech o xal ta jchapan, ta jpoj yoꞌ jech mu liꞌuc noꞌox xvaꞌvune”, xi ti jueze ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti Jesuse jech laj yal: ―Jaꞌ jech laj yal ti chopol juez taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ti Diose, ¿mi mu van jechuc ta spoj ti buchꞌu tꞌujbilic yuꞌun ti cꞌacꞌal acꞌobal ta sta ta cꞌoponele? ¿Mi mu van ta xꞌichꞌbat ta mucꞌ ti scꞌope? ");
INSERT INTO tzotzc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta xcalboxuc avaꞌiic, ta spojoxuc ta ora. Pero cꞌalal ta xichaꞌsut talel ti vuꞌun coꞌol jꞌelantique, ¿mi staoj to yav yichꞌojic ta mucꞌ Dios ti cristianoetique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ti Jesuse jech laj yalbe babacꞌop ti buchꞌutic lequic ti yalojique, ti cꞌalal mu lecuc xilic ti yane: ");
INSERT INTO tzotzc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Oy chib viniquetic ba staic ta cꞌoponel ti Dios ta temploe. Ti june jaꞌ jun jfariseo. Ti june jaꞌ jun jcꞌanpatantaqꞌuin. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ti jfariseoe vaꞌal lic sta ta cꞌoponel ti Dios ti jech laj yale: “Colavalbun, Dios, ti mu jechuc jꞌelan jech chac cꞌu chaꞌal ti yane, ti ta xꞌelcꞌajique, ti muꞌyuc stuqꞌuil ti yoꞌntonique, ti ta xmulivajique. Mi jaꞌuc jutebuc jech coꞌnton jech chac cꞌu chaꞌal ti jcꞌanpatantaqꞌuin liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ti vuꞌune chib velta ta xquicta cot ti ta jujun xemunae. Jaꞌ jech xtoc jun ta xcacꞌbot ti ta lajlajuneb ti cꞌu yepal ta jpas canale”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yan ti jcꞌanpatantaqꞌuine ta patil noꞌox tey nijil icom ta qꞌuexlal. Mi jaꞌuc jutebuc ta stoy muyel sat ta vinajel. Jaꞌ noꞌox tey laj smajolan ti stiꞌ yoꞌntone. Jech laj yal: “Dios, cꞌuxubinun, yuꞌun jsaꞌmulilun”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta melel ta xcalboxuc avaꞌiic, cꞌalal isut batel ta sna ti jcꞌanpatantaqꞌuine, lec xa xꞌilat yuꞌun ti Diose. Yan ti jfariseoe muꞌyuc bu laj sta ti lec xꞌilat yuꞌun ti Diose. Yuꞌun ti buchꞌu cajal ta xacꞌ sbae, jaꞌ ta specꞌtsanat. Yan ti buchꞌu biqꞌuit ta xacꞌ sbae, jaꞌ ta xꞌacꞌat ta ichꞌel ta mucꞌ ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jaꞌ jech xtoc ti cristianoetique tey yicꞌojanic talel ololetic ta stojol ti Jesuse, yoꞌ acꞌo scajan scꞌob ta stojolic. Pero cꞌalal laj yilic ti yajchancꞌoptaque, tey laj spajesic ti buchꞌutic yicꞌojic talel ti ololetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ti Jesuse laj yicꞌ talel ti yajchancꞌoptaque. Jech lic yalbe: ―Chꞌan utic ti ololetique, acꞌo taluc ta jtojol. Mu xamacbe yoꞌnton. Yuꞌun ti buchꞌu jech yoꞌntonic jech chac cꞌu chaꞌal ti ololetic liꞌe, jaꞌ yuꞌunic ti ventainel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta melel ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti mu jechuc yoꞌnton jech chac cꞌu chaꞌal yoꞌnton ti jun olole, mu xuꞌ ta xꞌoch ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oy jun banquilal yuꞌunic ti jꞌisraeletique jech laj sjacꞌbe ti Jesuse: ―Jlequil Jchanubtasvanej, ¿cꞌusi ta scꞌan ta jpas yoꞌ jech ta jta ti jcuxlejal sbatel osile? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ti Jesuse jech laj yalbe: ―¿Cꞌu chaꞌal ta xavalbun ti lecune? Muꞌyuc buchꞌu junucal ti lec yoꞌntone, cꞌajomal noꞌox ti Dios stuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ti voꞌote anaꞌoj lec ti mantaletic ti jech ta xale: “Mu xamulivaj. Mu xamilvan. Mu xaꞌelcꞌaj. Mu xajutbe cꞌop yan. Ichꞌo ta mucꞌ atot ameꞌ”, ti xi ti mantale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ti vinique jech laj stacꞌbe: ―Ta jbicꞌtal onoꞌox laj jchꞌun talel scotol ti mantaletic taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cꞌalal jech laj yaꞌi ti Jesús taje, jech laj yalbe: ―Jun xa noꞌox scꞌan ti cꞌusi ta xapase. Chono scotol ti cꞌusitic xꞌayan avuꞌune. Ti stojole, acꞌbo ti meꞌonetique. Jech xtoc umbi, oy acꞌulejal tey ta vinajel. Ti mi jech laj apase, laꞌ tsꞌacliun batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cꞌalal jech laj yaꞌi ti vinic taje, och ta at oꞌnton. Yuꞌun toj cꞌulej. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cꞌalal jech laj yil ti ta xat yoꞌntone, ti Jesuse jech laj yal: ―Ti jcꞌulejetique toj vocol ta xꞌoch ti bu ta xventainvan ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yuꞌun más to xuꞌ ta xjelav ta sat acuxa ti mucꞌ ta camelloe. Jaꞌ toj vocol ta xꞌoch batel ti jcꞌulej vinic ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Cꞌalal laj yaꞌiic ti jech laj yal ti Jesuse, ti cristianoetique jech lic yalic: ―Ti mi jech taje, ¿buchꞌu xa onoꞌox xuꞌ ta xcol? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ti Jesuse jech laj yal: ―Ti cꞌusi mu xuꞌ yuꞌunic spasel ti viniquetique, ti Diose xuꞌ ta spas scotol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ti Pedroe jech laj yal: ―Cajval, ti vuꞌuncutique laj xa quictacutic comel scotol ti cꞌusitic oy cuꞌuncutique, yoꞌ ta jtsꞌacliotcutic batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ti Jesuse jech laj stacꞌbe: ―Ta melel ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti laj yicta ti snaique, ti stot smeꞌique, ti schiꞌiltac ta voqꞌuele, ti yajnilique, ti snichꞌnabique ta sventa ti ventainel yuꞌun ti Diose, ");
INSERT INTO tzotzc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ta xichꞌic ep sqꞌuexol liꞌ ta sba banomile. Jech xtoc ti ta achꞌ banomil ti ta xtale, ta xichꞌic ti scuxlejalic sventa sbatel osile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ti Jesuse laj yicꞌ loqꞌuel ti lajchaꞌvoꞌ yajchancꞌoptaque. Jech laj yal: ―Tana liꞌe, ta xijbatotic ta Jerusalén yoꞌ ta xcꞌot ta pasel ta jtojol ti vuꞌun coꞌol jꞌelantique jech chac cꞌu chaꞌal laj stsꞌibaic comel ti jꞌalcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yuꞌun ta xiꞌacꞌat ta yoc ta scꞌob ti jyanlumetique. Ta xislabanic. Ta xiyutilanic. Ta xistubtaic. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jaꞌ jech xtoc ta xismajicun. Tsꞌacal to ta xismilicun. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ti stuquique muꞌyuc laj yaꞌiic ti jech taje. Mi jaꞌuc laj yaꞌibeic smelol ti jech iꞌalbatique. Yuꞌun mu xcꞌot ta yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ti Jesuse cꞌalal poꞌot xa scꞌan xcꞌot ta jteclum Jericoe, tey oy chotol ta tiꞌ be jun maꞌsat vinic ti ta scꞌan limoxnae. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cꞌalal laj yaꞌi ti ep cristianoetic ta xꞌechꞌe, ti maꞌsate laj sjacꞌ: ―¿Cꞌusi ta xcꞌot ta pasel taje? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tey laj yalbeic: ―Jaꞌ ti Jesús ti liquem talel ta Nazarete liꞌ ta xꞌechꞌ ta bee ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jech ti maꞌsate lic avanuc: ―Jesús, Snichꞌonot David, cꞌuxubinun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ti buchꞌu jbaꞌbeic batele laj spajtsanic yoꞌ acꞌo chꞌaniuc. Pero ti stuque más to tsots iꞌavan: ―Snichꞌonot David, cꞌuxubinun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jech ti Jesuse tey ivaꞌi. Laj yal ti acꞌo yiqꞌuic talele. Cꞌalal tey xa oy ta stsꞌele, jech laj sjacꞌbe: ");
INSERT INTO tzotzc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Cꞌusi ta xacꞌan ta jpasbot? ―xut. Ti maꞌsate jech laj stacꞌ: ―Cajval, ta jcꞌan ti ta xajambun ti jsate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ti Jesuse jech laj yal: ―Lec oy, jamuc ti asate, jaꞌ ti laj achꞌunune ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ta ora noꞌox ijam ti sate. Tey laj stsꞌacli batel ti Jesuse. Tey xmuyubaj xa ta xalbe slequilal ti Diose. Scotol ti cristianoetique ti laj yilic ti ijam sat ti maꞌsate, jaꞌ jech laj yalbeic slequilal ti Dios eque. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ti Jesuse iꞌoch batel ti ta jteclum Jericoe. Jelavel ijelav. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ti teye oy jun jcꞌulej vinic, Zaqueo sbi, ti jaꞌ banquilal yuꞌun ti jcꞌanpatantaqꞌuinetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ti stuc taje ta scꞌan ta xojtiquin yaꞌi ti Jesuse. Pero mu sta ta qꞌuelel yuꞌun toj ep ti cristianoetique. Jaꞌ jech xtoc yuꞌun toj pecꞌpecꞌ ti Zaqueoe. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jech ti stuque ijelav batel ta anil. Ba muyuc ta jpets sicómoro teꞌ yoꞌ jech ta xil ti bu ta xꞌechꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cꞌalal iꞌechꞌ ti Jesús ti bu oye, laj stoy muyel sat. Jech laj yal: ―Yalan talel ta anil, Zaqueo. Yuꞌun ti cꞌacꞌal liꞌe ta xicom ta ana ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jech ti Zaqueoe iyal ta anil. Xmuyubaj xa laj yicꞌ batel ta sna ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Cꞌalal jech laj yilic taje, scotolic xvulajetic xa liquel ta labanvanej ti ta xalic ti Jesuse ti ibat comuc ta sna jun jsaꞌmulile. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tsꞌacal to un, ti Zaqueoe ivaꞌi. Jech laj yalbe ti Jesuse: ―Qꞌuel avil, Cajval, ti cꞌusitic xꞌayan cuꞌune ta xcacꞌbe oꞌloluc ti meꞌonetique. Mi oy buchꞌu laj jloꞌla ta scꞌanbel ti staqꞌuine, ta jsutesbe chanib velta más ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ti Jesuse jech laj yalbe: ―Avi ti cꞌacꞌal liꞌe, vul xa ti coltael ti liꞌ ta jbej nae. Yuꞌun ti vinic liꞌ xtoque, jaꞌ snitilul ti Abrahame. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yuꞌun ti vuꞌun coꞌol jꞌelantique jaꞌ tal jsaꞌ, jaꞌ tal jcolta ti buchꞌutic chꞌayemique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Cꞌalal jech tsꞌetel schiquin ti cristianoetic ta yaꞌyiel ti vaꞌi sꞌelan ta xal ti Jesuse, jech ti stuque jech laj yal jun babacꞌop, yuꞌun nopol xa batel ta Jerusalén. Yuꞌun ti cristianoetique ta snopic ti cꞌot xa yorail ti ta xa xꞌoch ta Ajvalil ti Buchꞌu tꞌujbil yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jech o xal jech laj yal: ―Oy jun snichꞌon ajvalil ti ibat ta namal banomile. Tsꞌacal to ta sut talel yoꞌ ta sventain ti yabtele. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cꞌalal mu to ta xlocꞌ batele, laj stac ta iqꞌuel lajunvoꞌ yajꞌabtel. Tey laj yacꞌanbe comel ta jujun tal jujusep taqꞌuin ti ep yichꞌoje. Jech laj yal: “Bolomajanic me schiꞌuc ti jtaqꞌuine jaꞌ to ti mi lisut talele”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ti cristianoetic ti tey nacajtique xtiꞌet sjolic yuꞌun ti vinique. Jech o xal laj staquic batel jun chib jꞌalmantal yoꞌ ta xcꞌot yalbeic ti ajvalile: “Mu jcꞌancutic ti jaꞌ ta xꞌoch ta ajvalil ta jlumalcutic ti vinic leꞌe”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero acꞌbil xa yabtel ti ta xꞌoch ta ajvalile. Jech o xal isut talel ta slumal. Caꞌlal ivule, lic staan ta iqꞌuel ti yajꞌabteltac ti buchꞌutic laj yacꞌanbe comel ti staqꞌuine, yoꞌ ta snaꞌ cꞌu yepal laj spas canal ti taqꞌuin yuꞌunic ta jujun tale. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ti buchꞌu baꞌyel icꞌot ta stojol ti ajvalile, jech laj yalbe: “Cajval, ti taqꞌuin ti laj avacꞌbun comele, ijolin cuꞌun lajuneb velta más”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ti ajvalile jech laj stacꞌbe: “Lec oy. Jaꞌ jun lequil jꞌabtelot. Ti ta slequil avoꞌnton laj aventain ti jutebe, jech o xal ta xaꞌoch ta ajvalil cuꞌun ti ta xaventain lajuneb jteclume”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tey ital ti jun xtoque. Jech vul yal: “Cajval, ti ataqꞌuin ti laj avacꞌbun comele, ijolin cuꞌun voꞌob velta más”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jech laj stacꞌbe xtoc: “Jech ti voꞌot eque ta xaꞌoch ta ajvalil cuꞌun ti ta xaventain voꞌob jteclume”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tsꞌacal to ital ti jun xtoque. Jech vul yal: “Cajval, liꞌ oy ti ataqꞌuine. Laj jqꞌuej. Laj jpix lec ta uni panyo. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jech laj jpas, yuꞌun lixiꞌ avuꞌun, yuꞌun tsots vinicot. Ta xatsob ti tsꞌunobal ti bu moꞌcot laj atsꞌune. Jech xtoc ta xatsob ti tsꞌunobale ti bu moꞌcot laj avije”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jech ti ajvalile jech laj yal: “Chopol jꞌabtelot, ta jchapanot yuꞌun ti acꞌop ti jech ta xavale. Yuꞌun anaꞌoj ti tsots vinicune, ti ta jtsob ti bu moꞌcun laj jtsꞌune, ta jtsob ti bu moꞌcun laj jvije. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jech o xal, ¿cꞌu chaꞌal mu laj aticꞌ ta banco ti jtaqꞌuine yoꞌ jech ta xquichꞌbe schiꞌuc ti sjol cꞌalal ta xisut talel ta jnae?”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ti ajvalile jech laj yalbe ti buchꞌu tey oyique: “Pojbeic ti taqꞌuin leꞌe. Acꞌbeic ti buchꞌu yichꞌoj lajunebe”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pero ti jꞌabteletique jech laj yalic: “Cajval, pero oy xa yuꞌun lajuneb une”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero ti ajvalile jech laj stacꞌ: “Ta xcalboxuc avaꞌiic, ti buchꞌu oy xa yuꞌune, ta to xꞌacꞌbat más. Yan ti buchꞌu muꞌyuc xjolin yuꞌune, ta xichꞌ pojbel ti juteb acꞌbile. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jaꞌ jech xtoc ti jcrontae, jaꞌ ti buchꞌutic mu scꞌan ti ta xiꞌoch ta ajvalile, icꞌbeicun talel liꞌe. Milbeicun ta jsat”, xi ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cꞌalal jech laj yoꞌnton ta yalel jech taje, ti Jesuse laj stam batel sbe cꞌalal to Jerusalén. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cꞌalal jutuc xa scꞌan xcꞌot ti ta chib jteclum Betfagee schiꞌuc ti Betaniae ti nopol ta stsꞌel ti vits Olivose, tey laj stac jelavel chib yajchancꞌoptac. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jech laj yalbe: ―Batanic ta biqꞌuit jteclum leꞌe. Cꞌalal ta xacꞌotique, tey chucul ta xataic jcot burro ti muꞌyuc to cajlebinbile. Jitunic. Icꞌbeicun talel. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ti mi oy buchꞌu ta xasjacꞌbeic: “¿Cꞌu chaꞌal ta xajitunic?” mi xayutique, albo yaꞌiic: “Jaꞌ ta xtun yuꞌun ti Cajvaltique”, utic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jech ti yajchancꞌoptaque ibatic. Jech laj staic scotol jech chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cꞌalal jech ta xa sjitunic ti burroe, jech ti yajvale jech laj sjaqꞌuic: ―¿Cꞌu chaꞌal ta xajitunic ti burroe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ti stuquique jech laj stacꞌbeic: ―Yuꞌun ta xtun yuꞌun ti Cajvaltique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jech ti stuquique laj yiqꞌuic batel ti burro ta stojol ti Jesuse. Tey lic slamic ti scꞌuꞌic ta sba ti burroe. Tey laj scajanic muyel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cꞌalal jech yacal ta xanav batel ti Jesuse, tey ta sqꞌuiananic batel ti scꞌuꞌic ta bee. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cꞌalal nopajic xa yalel ta svitsal Olivose, scotolic ti jchꞌunolajeletic ti stsꞌacliojic batel ti Jesuse, xmuyubajic xa iꞌavanic. Lic yalbeic slequilal ti Diose. Yuꞌun laj yilic scotol ti smucꞌul stsatsal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jech ta xalic: ―Yan yutsil ti Ajvalil tacbil talel yuꞌun ti Diose. Lec yoꞌnton ti Diose. Toj yan yutsil ti Dios ti oy ta vinajele ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oy jun chib jfariseoetic ti tey capalic schiꞌuc ti cristianoetique ti jech laj yalique: ―Jchanubtasvanej, pajtsano ti avajchancꞌoptaque ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ti Jesuse jech laj stacꞌbe: ―Ta melel ta xcalboxuc avaꞌiic, ti mi ta jpajtsane, jaꞌ xlic avanicuc ti tonetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cꞌalal nopol xa scꞌan xcꞌot ta Jerusalene, cꞌalal jech laj yil ti jteclume, jech ti Jesuse ocꞌ ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jech laj yal: ―Ti cꞌacꞌal liꞌe, ti tauc xavaꞌiic jutebuc ti jaꞌ ta xacꞌboxuc scꞌuxobil avoꞌntonique, toj lec ti jechuque. Pero tana liꞌ une, macal ti asatique. Mu xavilic. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta sta scꞌacꞌalil ti ta xavichꞌ ilbajinel yuꞌun ti avajcrontaique. Ta sjoyobtaic ti jteclum liꞌe, yoꞌ jech macbiloxuc ta be ta jujot. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lilijem ta xcom ta lum ti jteclum avuꞌunique. Mi jaꞌuc jbej ton cajal ta xcom ta sba ti yan tone. Milbil ta xacom acotolic. Jech ta xcꞌot ta pasel, yuꞌun muꞌyuc laj avichꞌic ta mucꞌ ti cꞌalal tal svuꞌlanoxuc ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jech ti Jesuse och batel ta templo. Tey laj snutsan loqꞌuel ti buchꞌutic ta xchonilajic, ta xmanolajic teye. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ti stuque jech laj yal: ―Jech ta xal ti Dios ti tsꞌibabil ta scꞌope: “Ti jnae jaꞌ snail jtaobil ta cꞌoponel”, xi. Pero ti voꞌoxuque laj xa ajoybinic ta snail chꞌen jꞌeleqꞌuetic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ti Jesuse jujun cꞌacꞌal ta xchanubtasvan ti tey ta temploe. Pero ti banquilaletic yuꞌun ti paleetique, ti jchanubtasvanejetic yuꞌun ti mantale, jech xtoc ti banquilal jpasmantal yuꞌun ti jteclume, tey ta saꞌolanic cꞌu sꞌelan xuꞌ ta xaqꞌuic ta milel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero mu staic cꞌusi xuꞌ ta xutic. Yuꞌun scotol ti cristianoetique tsꞌetel schiquinic ta xaꞌiic ti cꞌusi ta xal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Oy jun cꞌacꞌal ti Jesuse ta xchanubtas ti cristianoetic tey ta temploe. Tey ta xalolan ti lequil achꞌ cꞌop ti jaꞌ colebale. Jaꞌ o tey icꞌotic ti banquilaletic yuꞌun ti paleetique, ti jchanubtasvanejetic yuꞌun ti mantale, schiꞌuc ti moletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jech laj yalic: ―Albuncutic, ¿cꞌusi avabtel avichꞌoj ti jech ta xapase? ¿Buchꞌu laj yacꞌbot avabtel? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ti Jesuse jech laj yal: ―Jaꞌ jech ti vuꞌun eque, oy cꞌusi ta jcꞌan ta jacꞌboxuc jbeluc. Jaꞌ yuꞌun un, tacꞌbeicun. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Buchꞌu laj stac talel ti Juane ti tal yacꞌ ichꞌ voꞌe? ¿Mi jaꞌ ti Diose? ¿Mi jaꞌ ti viniquetique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ti stuquique jech lic yalolanbe sbaic: ―¿Cꞌusi ta xcaltic xanaꞌic? Ti mi ta xcalbetic ti jaꞌ tacbil talel yuꞌun Diose, ti mi xijchie, jech ta xistacꞌbotic talel: “¿Cꞌu chaꞌal muꞌyuc bu laj avichꞌic ta mucꞌ?”, xiyut umbi. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero ti mi ta xcalbetic ti jaꞌ tacbil talel yuꞌun ti viniquetique, ti mi xijchie, xuꞌ ta xismilotic ta ton scotol ti cristianoetique. Yuꞌun snaꞌojic lec ti jaꞌ icꞌopoj ta sventa Dios ti Juane ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jech o xal ti stuquique laj yalic ti mu snaꞌic ti buchꞌu laj stac talel ti Juane ti tal yacꞌ ichꞌ voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ti Jesús une jech laj yal: ―Mi jaꞌuc ti vuꞌun eque, mu xcalboxuc avaꞌiic ti buchꞌu laj yacꞌbun cabtel ti jech ta jpase ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tsꞌacal to ti Jesuse laj scꞌopon ti cristianoetique. Jech laj yalbe jun babacꞌop: ―Oy jun vinic ti laj stsꞌun uva ta yosile. Tsꞌacal to laj yacꞌ ta chꞌom ti yosil ta stojol jun chib jꞌabteletic. Jech ti yajval osile ibat ta nom. Jal ijocꞌtsaj. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cꞌalal sta xa scꞌacꞌalil ti ta xichꞌ tuchꞌel ti sat uvae, ti yajval osile laj stac batel jun yajꞌabtel yoꞌ chba scꞌan ti cꞌu yepal ta xichꞌ ti slocꞌ yosile. Pero ti stuquique tey lic smajic. Muꞌyuc cꞌusi laj yacꞌbeic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tsꞌacal to ti yajval osile laj stac batel yan yajꞌabtel ta stojol ti jchꞌom-osiletique. Pero jaꞌ noꞌox jech laj yilbajinic, laj smajic. Muꞌyuc cꞌusi laj yacꞌbeic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jaꞌ jech xtoc ti yajval osile laj xchaꞌtac batel yan yajꞌabteltac. Pero ti jchom-osiletique tey laj syayijesic. Tey laj sjipic loqꞌuel ta pat moc. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tsꞌacal to ti yajval osile jech lic snop: “¿Cꞌusi xuꞌ ta jpas? Jaꞌ lec ta jtac batel ti jcꞌanbil nichꞌone. Cꞌalal ta xilique, ta nan xichꞌic ta mucꞌ”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ti jchꞌom-osiletique, cꞌalal laj yilique, tey lic yalbe sbaic ta jujun tal: “Leꞌe, jaꞌ ti buchꞌu ta xrextoin ti osile. Laꞌ jmiltic yoꞌ jech ta xcuꞌunintic ti osile”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jech ti jchꞌom-osiletique laj xjochic loqꞌuel ta yut ti osile. Tey bat smilic ta spat ―xi ti Jesuse. Jech ti Jesuse jech laj sjacꞌ: ―¿Cꞌusi van ta xcꞌot ta pasel ta stojolic yuꞌun ti yajval osil taje? ");
INSERT INTO tzotzc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ta xtal smil ti jchꞌom-osiletique. Ti yosile ta xacꞌ ta chꞌom ta yan ―xi. Cꞌalal jech laj yaꞌiic taje, jech laj yalic: ―Mu jechuc scꞌan ti Dios taje ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero ti Jesuse lic sqꞌuelbe batel ti satique. Jech laj yal: ―¿Cꞌusi smelol ta xal ti jech tsꞌibabil ta scꞌop Diose? Ti ton ti bajbil yuꞌun ti jꞌabteletique, tsꞌacal to jaꞌ jtunel icom sventa sliqueb ti nae, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Buchꞌuuc noꞌox ti ta xbaj ta sba ti ton taje, lilijem ta xcomic. Yan ti mi jaꞌ cajal ta xcꞌot ta sbaic ti tone, polvo ta xcomic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale laj yaꞌiic ti jaꞌ scꞌoplal stuquic ti vaꞌi sꞌelan laj sbabaꞌal ti Jesuse. Jech o xal ta scꞌan ta stsaquic ox ta ora. Pero ixiꞌic yuꞌun ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jech o xal ti stuquique laj staquic batel jpaꞌivanejetic ti lec yoꞌntonic yilele, yoꞌ jech ta sjacꞌbeic ti Jesuse mi oy cꞌusi jbeluc chopol ta xlocꞌ ta ye, yoꞌ jech xuꞌ ta xaqꞌuic batel ta scꞌob ti ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jech o xal ti stuquique jech laj sjaqꞌuic: ―Jchanubtasvanej, jnaꞌojcutic lec ti tucꞌ ta xachanubtasvane. Mu xanaꞌ ti yalel toyol avoꞌnton ta stojol ti cristianoetique. Yuꞌun jaꞌ noꞌox ta xachanubtasvan ta melel ti cꞌusi ta scꞌan ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jech o xal albun caꞌicutic, ¿mi lec ti ta jtojtic ti patan taqꞌuin ti ta xichꞌ ti ajvalil romanoe? ¿Mi moꞌoj? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ti Jesuse laj snaꞌ ti chopol ta snop ta yoꞌntonique. Jech o xal ti stuque jech laj yal: ―¿Cꞌu chaꞌal ti ta xacꞌan ta xabajesicun avaꞌi ta cꞌoqꞌue? ");
INSERT INTO tzotzc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Acꞌbun quil jsepuc taqꞌuin. ¿Buchꞌu sat, buchꞌu sbi ti liꞌ tsacale? ―xi. Ti stuquique jech laj staqꞌuic: ―Jaꞌ ti ajvalile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jaꞌ yuꞌun un, ti Jesuse jech laj stacꞌbe: ―Acꞌbeic ti cꞌusi jaꞌ yuꞌun ti ajvalile. Acꞌbeic Dios xtoc ti cꞌusi jaꞌ yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ti stuquique muꞌyuc xuꞌ yuꞌunic sbajesel ta cꞌocꞌ ti cꞌusi ta xal ti Jesús ta sba ta sat ti cristianoetique. Jaꞌ noꞌox chꞌayal icꞌot yoꞌntonic stuquic ti vaꞌi sꞌelan laj yal ti Jesuse. Jech o xal tey tsꞌijtsꞌajic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsꞌacal to un, oy jlom jsaduceoetic bat sqꞌuelic ti Jesuse. Ti jsaduceoetique jaꞌ ti xchꞌunojic onoꞌox ti muꞌyuc bu ta xchaꞌcuxiic ti animaetique. Jech o xal jech laj yalbeic ti Jesuse: ");
INSERT INTO tzotzc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Jchanubtasvanej, ti Moisese laj stsꞌiba comel ti mi oy jun vinic ti ta xicꞌ ti yajnile, ti mi chame, ti mi chꞌabal snichꞌon icome, jech o xal ti yitsꞌine ta scꞌan ti acꞌo yicꞌ ti meꞌunal antse, yoꞌ mu xchꞌay stsꞌunobal ti anima sbanquile. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lec oy. Oy viniquetic ti vucubic ta voqꞌuele. Ti banquilale laj yicꞌ yajnil. Pero icham. Muꞌyuc snichꞌon icom. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jech ti schibal itsꞌinale laj yicꞌ ti antse. Jaꞌ jech xtoc icham. Chꞌabal snichꞌon icom. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jaꞌ jech laj spas ti yoxibale. Laj yicꞌ noxtoc ti antse. Jaꞌ jech laj spasic ti yan xtoque. Pero icham svucvoꞌalic, mi junuc inichꞌnajic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jaꞌ jech xtoc un, icham ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jech o xal albun caꞌicutic, ti cꞌalal ta sta scꞌacꞌalil ti chaꞌcuxiele, ¿buchꞌu junucal yajnil ta xcom ti vucubic taje cꞌalal laj smalalin yucubal ti antse? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ti Jesuse jech laj stacꞌbe: ―Ti liꞌ ta sba banomile, ti viniquetique, ti antsetique ta xicꞌan sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yan ti buchꞌutic ta xchaꞌcuxiique, ti xuꞌ ta xꞌochic batel ti ta yan banomile, ti teye mu xa yuꞌunuc ta xicꞌan sbaic. Mi jaꞌuc xa ta xaqꞌuic ta nupunel ti yalab snichꞌnabique. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yuꞌun ti teye, muꞌyuc xa ta xchamic ti cristianoetique. Jaꞌ xa jech sꞌelan jech chac cꞌu chaꞌal ti ángeletique. Yalab snichꞌnab xa ti Diose. Jaꞌ ti ichaꞌcuxiic xae. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jaꞌ noꞌox jech ta xacꞌ jnaꞌtic ti Moisese ti ta xchaꞌcuxi ti animaetique. Yuꞌun jech iꞌalbat yuꞌun Dios cꞌalal ta xtil ti jpets teꞌe: “Vuꞌun Diosun yuꞌun ti Abrahame, yuꞌun ti Isaaque, yuꞌun ti Jacobe”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yuꞌun ti Diose, maꞌuc Dios yuꞌunic ti buchꞌutic chamemique. Jaꞌ Dios yuꞌunic ti buchꞌutic cuxajtique. Yuꞌun ta stojol ti Diose, scotol cuxulic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jech o xal oy jun chib jchanubtasvanejetic yuꞌun ti mantale jech laj yalic: ―Toj lec ti cꞌusi laj avale, Jchanubtasvanej ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jech o xal un, muꞌyuc xa cꞌusi más laj sjaqꞌuic. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ti Jesuse jech laj yal: ―¿Cꞌu chaꞌal ta xalic, ti Cristoe jaꞌ snichꞌon ti Davide? ");
INSERT INTO tzotzc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yuꞌun ti Davide jech laj yal stuc ti tsꞌibabil ta svun Salmose: Ti Diose jech laj yalbe ti Cajvale. “Laꞌ chotlan ti jbatsꞌi cꞌob, ");
INSERT INTO tzotzc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jaꞌ to mi ta sta yorail ti ta jtsalbot ti avajcrontae”, xꞌutat, xi ti Davide. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Cꞌusi xut ti Cristo ti jaꞌ Snichꞌon ti Davide, cꞌalal ti David stuque, Cajval ti xute? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Scotol ti cristianoetique tsꞌetajtic schiquinic ta xaꞌiic ti cꞌalal jech laj yalbe yajchancꞌoptac ti Jesuse: ");
INSERT INTO tzotzc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Bijanic me yuꞌun ti jchanubtasvanejetic yuꞌun ti mantale. Yuꞌun ti stuquique toj lec ta xaꞌiic ti nat slapoj ti scꞌuꞌique. Jaꞌ noꞌox ta scꞌanic ti nupbilic ti ichꞌbilic ta mucꞌ ti ta chꞌivite. Ti ta chꞌul nae, jaꞌ ta saꞌic ti chotlebal ti bu ichꞌbil ta muqꞌue. Jaꞌ jech xtoc jaꞌ ta saꞌic ti bu lec chotlebal ti bu ta xꞌicꞌatic ta veꞌele. ");
INSERT INTO tzotzc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jaꞌ jech xtoc ta spojbeic snaic ti meꞌlal antsetique. Tsꞌacal to yoꞌ mu xvinajic ti cꞌusi chopol laj spasic ti yalojique, jal ta jmec ta staic ta cꞌoponel ti Diose. Ti stuquic taje tsots ta xichꞌic castigo ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ti Jesuse tey laj yil ta templo ti ta stiqꞌuic ochel staqꞌuinic ti jcꞌulejetic ta scaxail smoton ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jaꞌ jech xtoc laj yil jun meꞌlal ants ti toj abol sbae ti laj sticꞌ ochel chib biqꞌuit cobre ti taqꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, ti meꞌlal ants leꞌe ti abol sbae, jaꞌ más ep laj yacꞌ. Jaꞌ mu sta laj yacꞌ ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yuꞌun ti yane jaꞌ noꞌox ta xaqꞌuic sobrail ti staqꞌuinique. Yan ti antse laj yacꞌ comel scotol ti yuni taqꞌuin ti jaꞌ smanobil yuni veꞌele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Oy jlom ta xalbeic scꞌoplal ti temploe, ti toj jun yutsiquil ti stanale schiꞌuc ti yan ti cꞌusitic laj yichꞌ aqꞌuel ta matanale. Jech ti Jesuse jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Scotol ti vi sꞌelan ta xavilic liꞌe, ta sta yorail ti lilijem ta xcome. Mu jbejuc ton ti cajal ta xcom ta sba ti yan tone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jech o xal tey lic sjacꞌbeic ti Jesuse: ―Jchanubtasvanej, ¿cꞌusi ora ta xcꞌot ta pasel taje? ¿Cꞌusi señail ti jech ta xcꞌot ta pasele? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ti Jesuse jech laj yal: ―Bijanic me. Mu me xalajic ta loꞌlael. Yuꞌun ep ti buchꞌutic sbiinojic ti jbi ti jech ta xalique: “Vuꞌun ti Cristoune”, xiic. Oy yan ti jech ta xalique: “Jaꞌ xa me yorail ta xtal ti Cristoe”, xiic. Pero mu xatsꞌacliic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jaꞌ jech xtoc cꞌalal ta xavaꞌibeic scꞌoplal ti letoe, ti ta scrontain sbaic ti cristianoetique, mu xaxiꞌic yuꞌun. Yuꞌun baꞌyel jech ta xcꞌot ta pasel. Pero maꞌuc to yorail ti slajebal cꞌacꞌale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jech to laj yalolan batel ti Jesuse: ―Ti jun mucꞌ ta jteclume ta stsac sbaic ta leto schiꞌuc ti yan mucꞌ ta jteclume. Ti jun ajvalile ta stsac sbaic ta leto schiꞌuc ti yan ajvalile. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta xtal mucꞌ ta niquel. Ta xtal mucꞌ viꞌnal. Ta xlic chamel buꞌyuc noꞌox ta jujun lum. Jech xtoc ti ta vinajele oy ep ta tos ta xvinaj señail ti toj xiꞌbal sbae. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Cꞌalal mu to xcꞌot ta pasel taje, ta xanutsatic batel. Ta xavichꞌic aqꞌuel ta chapanel ta jujun chꞌul na. Ta xaticꞌatic ta chuquel. Icꞌbil ta xabatic ta stojol ti banquilal ajvaliletique schiꞌuc ti gobernadoretique ti vuꞌun ta jventae. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jaꞌ o yorail ti jamal ta xavalbeicun ti jcꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nopic me lec ti voꞌoxuque ti mu xacajnopic cꞌusi xuꞌ ta xavalic yoꞌ ta xapoj abaique. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yuꞌun vuꞌun ta xcacꞌ ti abijilic ti cꞌu sꞌelan xuꞌ ta xatacꞌbeic ti avajcrontaique. Jech o xal mu xuꞌ ta stsaloxuc ta cꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ti voꞌoxuque ta xaꞌacꞌatic batel ta cꞌabal yuꞌun ti atot ameꞌique, yuꞌun ti achiꞌiltac ta voquele, yuꞌun ti avutsꞌ avalaltaque, yuꞌun ti buchꞌutic lec xavil abaique. Oy jlom ti voꞌoxuque ta xalajic ta milel yuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Scotol ti cristianoetic liꞌ ta sba banomile xtiꞌet sjolic ta atojolic ta jventa. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ti voꞌoxuque mi jaꞌuc jbej stsatsal ajolic ti ta xchꞌaye. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mi staoj yav jun avoꞌntonic xacham xalajique, ta xavichꞌ acuxlejalic. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Cꞌalal ta xavilic ti jteclum Jerusalén ti joyobtabil ta soldadoetique, naꞌic me ti jaꞌ yorail ti ta xichꞌ lilinele. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jech o xal un, ti buchꞌutic oyic ti liꞌ ta Judea banomile, acꞌo me jatavicuc batel ta vitsetic. Ti buchꞌutic ti ticꞌajtic liꞌ ta Jerusalene, acꞌo me loqꞌuicuc batel. Ti buchꞌutic loqꞌuemic batel ta yabtelique, mu xa me sutic talel ta jteclum. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yuꞌun sta xa yorail ti castigoe. Jaꞌ xa cꞌot ta pasel jech chac cꞌu chaꞌal ti tsꞌibabil ta scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti jech cꞌacꞌal taje, toj abol sbaic ti antsetic ti buchꞌutic schiꞌuc ti yolique, o mi ta to xchuꞌun ti yolique. Yuꞌun mu noꞌox albajuc ta xtal ti vocol liꞌ ta banomile. Toj tsots ta jmec ti castigo ta xichꞌic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oy jlom ta xchamic ta leto. Ti jlom xtoque chucbil ta xbatic ta jujun yan lumetic. Ti jyanlumetique ta soquesic ti jteclum Jerusalén liꞌe jaꞌ to mi itsꞌaqui scꞌacꞌalil ti cꞌu sjalil ta xꞌacꞌbat spasique. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Jaꞌ jech xtoc jaꞌ o xlic vinajuc ti oy señail ti ta cꞌacꞌale, ti ta ue, ti ta cꞌanaletique. Ti cristianoetic liꞌ ta banomil ti oyic ta jujun lume, mu stacꞌ aꞌyeluc ta xaꞌiic yuꞌun ti xiꞌele. Yuꞌun ti tsots xjumumet ti mare, ti xvaꞌi xcꞌotij ti voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ti cristianoetique ta xyalic ta lum ta xiꞌel. Yuꞌun mu snaꞌic cꞌusi ta xcꞌot ta pasel ta sjunlej ti banomile. Jaꞌ jech xtoc ti cꞌusitic oy ta vinajele xlaj nicanicuc scotol. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jaꞌ o tey ta xiyilicun ti vuꞌun coꞌol jꞌelantique, ti ta xital ta ba toc schiꞌuc ti jmucꞌul jlequilale. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cꞌalal xlic cꞌotuc ta pasel ti jech taje, tsotsanic me, toyo me ti asatique. Yuꞌun nopol xa scꞌan ti ta xataic ti acolelique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jaꞌ jech xtoc ti Jesuse lic yal yan babacꞌop jech chac cꞌu chaꞌal liꞌe: ―Qꞌuel avilic ti icuxe schiꞌuc ti cꞌusiuc noꞌox teꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cꞌalal yacal ta xchꞌi tal ti achꞌ yanale, xanaꞌic lec ti poꞌot xa sta yorail ta xlic yaluc ti chaquiloꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaꞌ jech xtoc cꞌalal ta xavilic ti xlic cꞌotuc ta pasel ti vaꞌi sꞌelan laj cale, naꞌic me ti poꞌot xa sta yorail ti xlic ventainvanuc ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ta melel ta xcalboxuc avaꞌiic, mu to ta xcham scotol ti cristianoetic liꞌe ti cꞌalal ta xcꞌot ta pasel scotol taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ti banomile, ti vinajele xlaj scꞌoplal. Pero ti jcꞌope mu xlaj scꞌoplal. Ta onoꞌox xcꞌot ta pasel. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Bijanic me. Mu me xyijub avoꞌntonic yuꞌun ti yacubele, ti cꞌusitic yan ta xapasique, ti jaꞌ noꞌox xvulvun avoꞌntonic ti cꞌusi ta xavut abaic liꞌ ta sba banomile, yoꞌ jech mu chꞌayaluc avoꞌntonic xataatic ti jech cꞌacꞌal taje, ");
INSERT INTO tzotzc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ti coꞌol sꞌelan jun petsꞌ ti ta stsacvane. Yuꞌun jaꞌ jech sꞌelan ta xcꞌot ta pasel ta stojol scotol ti cristianoetic ti oyic ta sjoylej banomil ti cꞌalal ta sta ti scꞌacꞌalile. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jech o xal ti voꞌoxuque chaplucoxuc me. Taic me ta cꞌoponel scotol cꞌacꞌal ti Diose, yoꞌ jech xuꞌ ta xapoj abaic yuꞌun scotol ti cꞌusitic ta xcꞌot ta pasele, yoꞌ jech xuꞌ ta xcꞌot avaꞌan abaic ta jtojol ti vuꞌun coꞌol jꞌelantique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ti ta cꞌacꞌaltique ta xchanubtasvan ta templo ti Jesuse. Ti ta acꞌobaltique ta xbat ta vits ti jaꞌ Olivos sbie. ");
INSERT INTO tzotzc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Scotol ti cristianoetique jujun sob icꞌloman ta xbatic ta templo yoꞌ ta xaꞌiic ti ta xchanubtasvan ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nopol xa scꞌan ti qꞌuin ti ta xichꞌ veꞌel ti pan ti chꞌabal yichꞌoj ti spajubtasobile, jaꞌ ti qꞌuin Colele. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale ta snopilan cꞌusi xuꞌ ta spasic yoꞌ ta xaqꞌuic ta milel ti Jesuse. Pero ta xiꞌic yuꞌun ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jech ti pucuje tey iꞌoch ta yoꞌnton ti Judase, ti jaꞌ sbi xtoc ti Iscariotee, ti jaꞌ jun ta slajchaꞌvoꞌal jcholcꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jech ti stuque bat scꞌopon ti banquilal paleetique schiꞌuc ti buchꞌutic tsots yabtelic yichꞌojic tey ta temploe. Tey laj yal ti cꞌu sꞌelan xuꞌ ta xacꞌ ta cꞌabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jech ti stuquique xmuyubajic xa. Jech o xal laj yalic ti ta xacꞌbeic taqꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jech ti Judase tey laj stsac ti taqꞌuine. Tey lic saꞌolan ti cꞌu sꞌelan xuꞌ ta xacꞌ ta cꞌabal ti Jesuse ti cꞌalal jaꞌ o chꞌabal ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sta xa yorail ti qꞌuin ti ta sveꞌic ti pan ti chꞌabal yichꞌoj ti spajubtasobile. Jaꞌ jech xtoc jaꞌ o ti scꞌacꞌalil ti ta xichꞌ milel ti chij ti jaꞌ sventa smelol ti qꞌuin Colele. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jech o xal ti Jesuse jech laj yalbe ti Pedroe, ti Juane: ―Batanic, ba chapanic ti veꞌlil sventa ti qꞌuin Colele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ti chaꞌvoꞌique jech laj sjacꞌbeic: ―¿Bu ta xacꞌan ti chba jchapancutique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ti Jesuse jech laj stacꞌ: ―Cꞌalal ta xaꞌochic batel ti ta jteclume, tey ta xanupic ta be jun vinic ti xcuchoj talel jbej qꞌuib voꞌe. Tijlanic batel ta spat cꞌalal to na ti bu ta xꞌoche. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Albeic yaꞌi ti yajval nae: “Ti Jchanubtasvaneje jech ta xayalbot: ¿Bu oy ti cuarto ti xuꞌ ta xiveꞌcutic schiꞌuc ti cajchancꞌoptac sventa ti qꞌuin Colele? xayut”, xavutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ti yajval nae tey ta xacꞌ avilic jun mucꞌ ta cuarto ti oy ta schaꞌcojal nae ti chapanbil xae. Tey xameltsanic ti veꞌlile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ti chaꞌvoꞌique tey ibatic. Tey laj staic scotol jech chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse. Jech tey lic spasic ti veꞌlil sventa ti qꞌuin Colele. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cꞌalal ista yorail ti veꞌebale, jech ti Jesuse schiꞌuc ti yajchancꞌoptaque lic chotlicuc ta mexa. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jech ti Jesuse jech lic yal: ―Jech onoꞌox oy ta coꞌnton ti ta jcꞌan ti jmoj ta xijveꞌotic jcotoltic sventa ti qꞌuin Colele cꞌalal mu to ta xichame. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yuꞌun ta xcalboxuc avaꞌiic, slajeb xa velta ti jech jmoj ta xijveꞌotique jaꞌ to ti mi cꞌot yorail ti ta jtsob jbatic ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jech o xal un, ti Jesuse lic stsac ti sbisol yaꞌlel uvae. Tey laj yalbe vocol ti Diose. Jech laj yalbe ti yajchancꞌoptaque: ―Tsaquic liꞌe. Comon uchꞌic acotolic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yuꞌun ta xcalboxuc avaꞌiic, slajeb xa velta ti ta xcuchꞌ ti yaꞌlel uvae jaꞌ to mi sta yorail ti ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tsꞌacal to xtoc un, lic stsac ti pane. Tey laj yalbe vocol ti Diose. Tey lic xetꞌ ti pane. Tey laj yacꞌbe batel ti yajchancꞌoptaque. Jech lic yal: ―Ti liꞌe, jaꞌ jbecꞌtal ti ta xichꞌ aqꞌuel ta milel ta sventa alequilalic ti voꞌoxuque. Jech me xapasolanic o. Yuꞌun jaꞌ jnaꞌobil ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cꞌalal laj yoꞌntonic ta veꞌele, laj stsac xtoc ti sbisol yaꞌlel uvae. Jech lic yal: ―Ti yaꞌlel uva liꞌe, jaꞌ xa ti icꞌot ta pasel ti achꞌ trate ta sventa ti ta xmal ti jchꞌichꞌele, ti jaꞌ sventa alequilalic ti voꞌoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ti vinic ti buchꞌu ta xiyacꞌ ta cꞌabale tijil scꞌob ta jcꞌob ti liꞌ ta mexae. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ti vuꞌun coꞌol jꞌelantique ta xcꞌot ta jtojol ti bu albil onoꞌoxe. Pero toj abol sba ti vinic ti buchꞌu ta xiyacꞌ ta cꞌabale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jech o xal ti yajchancꞌoptaque lic sjacꞌolanbe sbaic ta jujun tal: ―¿Buchꞌu van ti jꞌacꞌvanej ta cꞌabal taje? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsꞌacal to un, ti yajchancꞌoptaque tey lic sjacꞌolanbe sbaic ti buchꞌu junucal ti más ichꞌbil ta mucꞌ ta xcꞌot yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ti Jesuse jech laj yal: ―Ti ajvaliletic ti oy ta jujun lume lec ta xaꞌiic ti ta spasvanic ta mantale. Jaꞌ jech xtoc lec ta xaꞌiic ti lec ti ajvalil leꞌe, xi scꞌoplal yuꞌun ti yajꞌabteltaque. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero ti voꞌoxuque mu me jechuc xpasic ec. Ti buchꞌu ichꞌbil ta mucꞌ ta xcꞌot avuꞌunique, jaꞌ ta scꞌan ti biqꞌuit acꞌo yacꞌ sbae. Ti buchꞌu ta scꞌan ta spas mantale, jaꞌ ta scꞌan ti acꞌo yacꞌ sba ta tunele. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Buchꞌu ti más cajal ti scꞌoplale? ¿Mi jaꞌ ti buchꞌu chotol ta smala sveꞌel ta mexae? ¿Mi jaꞌ ti buchꞌu ta xacꞌ ti veꞌlile? ¿Mi mu jaꞌuc van xanaꞌ ti buchꞌu smala sveꞌel ta mexae? Pero ti vuꞌune liꞌ oyun ta atojolique yoꞌ jech ta xitun avuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ti voꞌoxuque tey onoꞌox oyoxuc ta jtojol cꞌalal lic quichꞌolan talel ti jvocole. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jech o xal ta xcacꞌboxuc avabtelic ti ta xapas mantale jech chac cꞌu chaꞌal ti Jtot ti laj yacꞌbun cabtele ti ta jpas mantale. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti voꞌoxuque tey ta xaveꞌic, ta xavuchꞌic voꞌ ta jmexa ti bu ta jpas mantale. Jaꞌ jech xtoc tey ta xachotiic ta xchapanel ti lajchaꞌchop jꞌisraeletique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ti Cajvaltique jech laj yal xtoc: ―Simón, Simón, ti pucuje laj xa scꞌanbe ti Diose yoꞌ jech ta slilinoxuc jech chac cꞌu chaꞌal ti trigo ti ta xichꞌ icꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero ti vuꞌun eque laj xa jcꞌanbe vocol ti Dios ta atojole yoꞌ jech mu xchibaj avoꞌnton. Cꞌalal mi ayan yip ti avoꞌntone, coltao me ti avermanotaque yoꞌ ta stsatsub ti yoꞌntonique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ti Simone jech laj stacꞌ: ―Cajval, jchapanoj xa jba ta jchiꞌinot batel ta chuquel manchuc mi coꞌol ta xijlaj ta milel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ti Jesuse jech lic stacꞌbe: ―Pedro, ta xcalbot avaꞌi, ti tana liꞌe, cꞌalal mu to xlic ocꞌuc ti cotse, oxib xa ox velta laj xa aval ti mu xavojtiquinune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ti Jesuse jech laj sjacꞌbe ti yajchancꞌoptaque: ―Ti cꞌalal laj jtacoxuc batele ti muꞌyuc laj avichꞌic batel ti anutiꞌique, ti yav ataqꞌuinique, ti yan axonobique, ¿mi oy cꞌusi vocol laj avaꞌiic? ―xi. Ti stuquique jech laj yalic: ―Muꞌyuc ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jech ti Jesuse jech laj yalbe: ―Avi tana liꞌe, mu xa jechuc. Ti buchꞌu oy ti snutiꞌique, ti buchꞌu oy yav ti staqꞌuinique, acꞌo yichꞌ batel. Jaꞌ jech xtoc ti buchꞌutic chꞌabal ti yespadae, acꞌo xchon jlicuc scꞌuꞌ yoꞌ ta sman. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta melel ta xcalboxuc avaꞌiic, ta persa ta xcꞌot ta pasel ta jtojol jech chac cꞌu chaꞌal ti tsꞌibabil ta scꞌop Diose: “Jsaꞌmulil vinic leꞌe”, ti xie. Yuꞌun scotol ti cꞌusi tsꞌibabil jcꞌoplal ti ta scꞌop Diose, persa ta onoꞌox xcꞌot ta pasel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ti yajchancꞌoptaque jech laj yalic: ―Cajval, liꞌ xa oy chib espada ―xiic. Ti Jesuse jech laj stacꞌ: ―Chꞌan xa utic taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsꞌacal to ilocꞌ batel ti Jesuse. Ibat ta vits Olivos, jaꞌ ti stalel onoꞌox ti tey ta xcꞌotilane. Ti yajchancꞌoptaque tey tsꞌacajtic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cꞌalal icꞌotique, ti Jesuse jech laj yal: ―Taic me ta cꞌoponel ti Diose yoꞌ mu xastsaloxuc ti pucuje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsacal to ti Jesuse tey laj xchꞌac sba batel ta stojolic. Jech snatil ibat jech chac cꞌu chaꞌal ta jtentic jbej ton. Tey lic squejan sba yoꞌ ta sta ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jech laj yal: ―Tot, ti mi ta xacꞌane, coltaun yoꞌ mu xcꞌot ta jtojol ti jvocole. Pero maꞌuc ti cꞌusi ta scꞌan ti coꞌntone. Jaꞌ ti cꞌusi ta xacꞌan atuque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jech o xal, jaꞌ o ital jun ángel ta vinajel, yoꞌ jech tal acꞌbatuc yip ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cꞌalal jech mu noꞌox albajuc ta xaꞌi ti vocole, más to tsots lic scꞌopon Dios ti Jesuse. Jech ti schiqꞌue coꞌol sꞌelan chꞌichꞌ ti mucꞌtic ta xbaj ta banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cꞌalal laj yoꞌnton ta scꞌoponel ti Diose, tey ibat ti bu icomic ti yajchancꞌoptaque. Vayemic cꞌot sta, yuꞌun tsalatic yuꞌun ti at oꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jech o xal ti Jesuse jech laj yal: ―¿Cꞌu chaꞌal ti ta xavayique? Licanic, taic me ta cꞌoponel ti Diose yoꞌ jech mu xastsaloxuc ti pucuje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yacal to ta xcꞌopoj ti Jesuse, cꞌalal jaꞌ o tey icꞌotic ti epal cristianoetique. Ti Judase, ti jaꞌ jun ta slajchaꞌvoꞌal ti yajchancꞌoptaque, jaꞌ jbaꞌbe talel yuꞌun ti cristianoetique. Tey inopaj batel ta stojol ti Jesuse yoꞌ ta sbutsꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jech ti Jesuse jech laj yal: ―Judas, ¿mi ta jbutsꞌel noꞌox ta xavacꞌun ta cꞌabal ti vuꞌun coꞌol jꞌelantique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cꞌalal laj yilic ti buchꞌutic xchiꞌinojic ti Jesuse, jech laj sjaqꞌuic: ―Cajval, ¿mi ta xcacꞌbecutic espada? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oy jun yuꞌunic laj sbojbe sbatsꞌi chiquin ti yajtunel ti banquilal yuꞌun ti paleetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero ti Jesuse jech laj yalbe: ―Chꞌan uto, xuꞌ xa ―xi. Jech ti Jesuse ba spicbe schiquin ti mosovile. Tey ilecub yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tsꞌacal to ti Jesuse laj scꞌopon ti jtsavanejetique, jaꞌic ti banquilal paleetique, ti jꞌopisialetic yuꞌun ti temploe, ti moletique. Jech laj yalbe: ―¿Mi yuꞌun jꞌelecꞌun ta xavilic ti tal atsaquicun schiꞌuc avespadaic schiꞌuc ateꞌique? ");
INSERT INTO tzotzc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Cꞌalal tey to ox oyun ta atojolic jujun cꞌacꞌal ta temploe, mi jaꞌuc jutebuc laj atsaquicun. Pero liꞌe, jaꞌ xa yorail ti xuꞌ ta xapasic ti cꞌusi ta scꞌan ti avoꞌntonique. Yuꞌun jaꞌ yorail ti xuꞌ ta spas ti cꞌusi scꞌan yoꞌnton ti buchꞌu yichꞌoj ta sventa ti icꞌal osile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jech o xal ti jtsavanejetique laj xchuquic batel ti Jesuse. Tey laj yiqꞌuic batel ta sna ti banquilal yuꞌun ti paleetique. Ti Pedroe tey nomtic xtijet batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Cꞌalal icꞌotique, tey lic stsanic cꞌocꞌ ta oꞌlol amacꞌ. Tey lic sjoy sbaic ta cꞌatimol. Jaꞌ jech ti Pedro eque tey ba scap sba ta cꞌatimol ec. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jech xtoc jaꞌ o ital jun mosovil ants. Cꞌalal laj yil ti tey chotol ta xcꞌatin ti Pedroe, tey lic sqꞌuel batel lec. Jech laj yal: ―Ti vinic leꞌe, jaꞌ schiꞌil ti buchꞌu tsacbil talele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ti Pedroe laj sjut cꞌop, jech laj yalbe ti antse: ―Ants, mu xcojtiquin taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lec xa ox jliquel xtoc un, jaꞌ o ital jun vinic ti jech laj yale: ―Ti voꞌote jaꞌ achiꞌil abaic schiꞌuc ti vinic leꞌe ―xi. Ti Pedroe jech laj yal: ―¡Bu xata, Chiꞌiltic! muꞌcun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jun ora yechꞌel xtoc, jech lic yal jun vinic: ―Ta melel ti vinic leꞌe, jaꞌ schiꞌil sbaic schiꞌuc ti buchꞌu chucbil talele. Yuꞌun liquem talel ta Galilea ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ti Pedroe jech laj yal: ―Chiꞌiltic, mu jnaꞌ ti cꞌusi ta xaval taje ―xi. Cꞌalal jech yacal ta xal ti Pedroe, jaꞌ o iꞌocꞌ ti cotse. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jech ti Cajvaltique laj sjoybin batel sat. Tey laj sqꞌuel batel ti Pedroe. Jech ti Pedroe jaꞌ o ivul ta yoꞌnton ti jech onoꞌox iꞌalbat yuꞌun ti Cajvaltique: “Ti tana liꞌe, ti cꞌalal mu to xlic ocꞌuc ti cotse, oxib xa ox velta laj xa aval ti mu xavojtiquinune”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jech o xal ti Pedroe ilocꞌ batel. Tey bat smil sba ta oqꞌuel. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ti viniquetic ti ta xchabiic ti Jesuse lic slabanic, tey lic smajic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tey lic smacbeic sat ta pocꞌ. Tey laj smajbeic ti xocon sate. Jech lic yalbeic: ―Naꞌo caꞌitic, ¿buchꞌu laj smajot? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ep ta tos cꞌusitic ta xalbeic ti Jesuse yoꞌ ta xilbajinic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ta yocꞌlomal ti cꞌalal sac xa ti osile, lic stsob sbaic ti moletic yuꞌun ti jꞌisraeletique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale, schiꞌuc ti banquilal paleetique. Laj yiqꞌuic echꞌel ti Jesús ta stojol ti banquilal jchapanvanejetique. Tey lic sjacꞌbeic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Albun caꞌicutic, ¿mi voꞌot ti Cristoe? ―xutic. Ti stuque jech laj stacꞌ: ―Ti mi ta xcalbot ti vuꞌunune, mu xachꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ti mi oy cꞌusi ta jacꞌboxuque, mi jaꞌuc xtacꞌ avuꞌunic ec. Jaꞌ jech xtoc mu xacoltaicun batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ti cꞌacꞌal tana liꞌe, jaꞌ sliquebal ti ta xba chotlucun ta xocon sbatsꞌi cꞌob Dios ti scotol xuꞌ yuꞌune, ti vuꞌun coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jech o xal scotolic jech lic sjaqꞌuic ta ora: ―Ati xcaltic un chaꞌe, voꞌot Snichꞌonot ti Diose ―xiic. Ti Jesuse jech laj stacꞌ: ―Vuꞌunun jech chac cꞌu chaꞌal ta xavalique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jech ti stuquique jech laj yalic: ―Mu xa persauc rextigo ta jcꞌantic. Laj xa caꞌitic ti jech laj yal ta ye stuque ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jech o xal scotolic ivaꞌiic. Tey laj yiqꞌuic batel ti Jesús ta stojol ti Pilatoe. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tey lic sjutbeic ti smule. Jech laj yalic: ―Ti vinic liꞌe yacal ta soquesbe yoꞌnton ti jchiꞌilcutic laj jtacutique. Yuꞌun ta xalbe ti mu lecuc ti mi ta jtojcutic ti patan ti ta scꞌan ti ajvalil romanoe. Jaꞌ jech xtoc ta xalbe sba ti jaꞌ Cristoe, ti jaꞌ jun ajvalile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jech ti Pilatoe jech laj sjacꞌ: ―¿Mi voꞌot ajvalilot yuꞌun ti jꞌisraeletique? ―xut. Ti Jesuse jech laj stacꞌ: ―Jaꞌ jech, jech chac cꞌu chaꞌal ta xavale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jech ti Pilatoe tey lic yalbe ti banquilal paleetique schiꞌuc ti cristianoetique: ―Mu jtabe jutebuc smul ti vinic liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ti stuquique más to tsots lic cꞌopojicuc: ―Oy smul. Yuꞌun soc xa yoꞌntonic ti jchiꞌilcutic ta Judeae ti cꞌu sꞌelan ta xchanubtasvane. Tey lic sliques talel ta Galilea. Avi tana un, liꞌ xa oy ta xchanubtasvan une ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cꞌalal jech laj yꞌai ti Pilato taje, jech o xal lic sjacꞌbe mi ta melel ti jaꞌ liquem talel ta Galilea ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cꞌalal iꞌalbat ti jaꞌ liquem talel ta Galileae, jech o xal ti Pilatoe laj stac batel ta stojol ti Herodese, ti jaꞌ ajvalil ta Galileae, ti jaꞌ o yorail xtoc ti tey oy ta Jerusalén ti Herodese. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ti Herodese cꞌalal laj yil ti Jesuse, xmuyubaj xa ta jmec. Yuꞌun voꞌne xa onoꞌox ta scꞌan ta sqꞌuel yaꞌi. Yuꞌun yaꞌbinojbe onoꞌox scꞌoplal. Jech o xal ti Herodese ta scꞌan ti acꞌo acꞌbatuc yil ti cꞌusi tsots xuꞌ yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ep ti cꞌusitic laj sjacꞌbee. Pero ti Jesuse muꞌyuc laj stacꞌ jbeluc. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jaꞌ jech xtoc tey oyic ti banquilal paleetique schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. Ep ta jmec laj saꞌbeic smul. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jech ti Herodese schiꞌuc ti yajsoldadotaque muꞌyuc cꞌusi bal o laj yilic. Jaꞌ jech xtoc yoꞌ ta slabanic ti Jesuse, jun yutsil laj yacꞌbe slap scꞌuꞌ jech chac cꞌu chaꞌal ti ajvalile. Tsaꞌcal to un, ti Herodese laj stac batel yan velta ta stojol ti Pilatoe. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Manchuc mi scrontainoj to ox sbaic ti Herodese schiꞌuc ti Pilatoe, pero ti jech cꞌacꞌal taje, jaꞌ o yorail icomic lec ta amigo. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jech o xal ti Pilatoe laj stsob scotol ti banquilal paleetique, ti jꞌopisialetique, schiꞌuc ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jech laj yal: ―Ti voꞌoxuque laj avicꞌbeicun talel ti vinic liꞌe ti ta xavalic ti ta soquesbe yoꞌnton ti achiꞌilique. Pero avilojic lec ti laj xa jacꞌbe ti smule. Pero muꞌyuc bu laj jtabe ti voꞌoxuc ta xavalic ti oy ti smule. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jaꞌ jech xtoc ti Herodese muꞌyuc bu laj stabe smul ec. Jech o xal laj stac sutel talel. Ti voꞌoxuque laj avilic ti muꞌyuc cꞌusi chopol laj spas ti yoꞌ xuꞌ ta xichꞌ milele. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jaꞌ noꞌox ta jtsits. Tsꞌacal to ta jcolta batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ti ta jujun qꞌuin Colele, ti Pilatoe ta scolta batel jun jchuquel ti buchꞌu ta scꞌan stꞌujic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero scotol ti cristianoetique tsots lic avanicuc: ―Mu jcꞌancutic ti jaꞌ ta xacolta ti vinic liꞌe. Jaꞌ coltao ti Barrabase ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti Barrabase iꞌoch ta chuquel ta scoj ti laj scrontain ti ajvalil ta Jerusalene. Jaꞌ jech xtoc jaꞌ jun jmilvanej. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ti Pilatoe ta scꞌan ta scolta yaꞌi batel ti Jesuse. Jech o xal icꞌopoj yan velta ta stojol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ti stuquique más to tsots lic avanicuc: ―¡Jipano ta cruz! ¡Jipano ta cruz! ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ti Pilatoe ta yoxibal xa velta lic yal: ―¿Cꞌusi ti chopol laj spas ti vinic liꞌe? Ti vuꞌune muꞌyuc bu laj jtabe jutebuc smul yoꞌ jech ta xichꞌ milel. Jaꞌ noꞌox ta jtsits. Tsꞌacal to ta jcolta batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ti cristianoetique tsots lic avanicuc ti acꞌo yichꞌ jipanel ta cruze. Ti jech ep iꞌavanic ti cristianoetique schiꞌuc ti banquilal paleetique, jech o xal laj xa staic ti jech ta scꞌanic onoꞌoxe. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jech o xal ti Pilatoe laj xchꞌun ti jech ta scꞌanique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Laj scolta batel ti Barrabase ti jaꞌ laj stꞌujique, ti buchꞌu tiqꞌuil ta chuquele, ti ta spojbe ox yabtel ti ajvalile, ti imilvane. Yan ti Jesuse laj yacꞌ ta milel jech chac cꞌu chaꞌal ta scꞌan ti yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Cꞌalal yicꞌojic xa batel ta sjipanic ta cruz ti Jesuse, jaꞌ o tey laj snupic ta be jun vinic, Simón sbi, ti ta xtal ta Jerusalene, ti liquem tal ta Cirene banomile. Laj stsaquic ti Simone. Laj yacꞌbeic xcuch ti cruze. Tey tsꞌacal batel ta spat ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ep cristianoetic tsꞌacajtic batel schiꞌuc ep antsetic ti xꞌocꞌ xꞌavanic xa ta at oꞌnton yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ti Jesuse laj sqꞌuel ti antsetique. Jech laj yalbe: ―Antsetic ti voꞌoxuc liꞌ nacaloxuc ta Jerusalene, mu xavoqꞌuitaicun. Oqꞌuitao abaic atuquic schiꞌuc ti avalab anichꞌnabique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yuꞌun ta xcꞌot scꞌacꞌalil ti jech ta xavalique: “Yan yutsil ti antsetic ti buchꞌutic chꞌabal ti yolique, ti buchꞌutic muꞌyuc onoꞌox yilojic ti alajele”, xachiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cꞌalal ta xavichꞌic avocolique, ti cristianoetique jech ta xalbeic ti vitsetique: “Loman talel ta jbacutic”, xutic. Jaꞌ jech xtoc jech ta xalbeic ti stselejaltique: “Nacꞌuncutic”, xutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yuꞌun ti mi jech ta spasbeic ti jpets yaxal teꞌe. ¿Mi mu jechuc ta spasbeic xtoc ti taqui teꞌetique? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jaꞌ jech xtoc un, ti soldadoetique yicꞌojic batel chaꞌvoꞌ vinic ti tsots smulique, yoꞌ jech jmoj ta xlajic ta milel schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ti cꞌalal icꞌotic ta vits ti jaꞌ baquil jolal sbie, tey lic sjocꞌanic ta cruz ti Jesuse schiꞌuc ti chaꞌvoꞌ chopol viniquetique. Tey laj sjocꞌanic jun ta sbatsꞌi cꞌob, jun ta stsꞌet cꞌob ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cꞌalal ta xa sjocꞌanic ta cruze, ti Jesuse jech lic yal: ―Tot, acꞌbo perdón ti cristianoetic liꞌe. Yuꞌun mu snaꞌic ti cꞌusi ta spasique ―xi. Ti soldadoetique lic sqꞌuelic suerte yoꞌ ta xvinaj buchꞌu junucal ta xichꞌbeic scꞌuꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ti cristianoetique tey vaꞌajtic ta sqꞌuelic. Ti jꞌopisialetique tey laj slabanic ti Jesuse. Jech ta xalic: ―Laj scolta ti yane. Jech o xal un, acꞌo scolta sba stuc ec un, yoꞌ ta xvinaj mi jaꞌ ti Cristoe ti tꞌujbil yuꞌun ti Dios ta melele ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ti soldadoetic xtoque ta slabanic ti Jesuse. Inopajic batel ta stsꞌel, laj yacꞌbeic yuchꞌ chꞌail pox. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jaꞌ jech ta xalbeic: ―Ti mi voꞌot ti ajvalilot yuꞌun ti jꞌisraeletique, coltao aba quic atuc un ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ti ta sjol scruzal ti Jesuse tey oy tsꞌibabil ta griego cꞌop, ta latin cꞌop, ta hebreo cꞌop ti jech ta xale: “Jaꞌ ajvalil yuꞌun ti jꞌisraeletique”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oy jun ti ta schaꞌvoꞌal ti chopol viniquetic ti jipil ta cruze jech lic chopol cꞌopojuc ta stojol ti Jesuse: ―Mi voꞌot ti Cristoe, coltao aba quic atuc. Jaꞌ jech xtoc coltauncutic ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero ti jun xtoque lic sjajanta ti schiꞌile. Jech laj yalbe: ―¿Mi mu xanaꞌ xaxiꞌ yuꞌun ti Diose ti cꞌalal jmoj ta xquichꞌtic castigo schiꞌuque? ");
INSERT INTO tzotzc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ti voꞌotique jaꞌ tey xijtunotic o ti ta xquichꞌ ti jvocoltic liꞌe. Yuꞌun ta jtojtic ti cꞌusi laj jpastique. Pero ti vinic liꞌe muꞌyuc cꞌusi chopol spasoj ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jech o xal jech laj yal: ―Jesús, mu xachꞌayun ta avoꞌnton ti cꞌalal xlic apas mantale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ti Jesuse jech laj stacꞌbe: ―Ta melel ta xcalbot avaꞌi, ti cꞌacꞌal liꞌe chba jchiꞌin jbatic ta lequilal ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Poꞌot xa nan batel ti oꞌlol cꞌacꞌale, cꞌalal icꞌ icom scotol ti banomile. Ta oxib to ora mal cꞌacꞌal isacub. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Imac sat ti cꞌacꞌale. Jech ti mucꞌ ta cortina ti jocꞌol ta yut temploe tey ijat ta oꞌlol. Pas ta chaꞌlic. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jech ti Jesuse tsots lic avanuc: ―Tot, ta xcacꞌ ta avoc ta acꞌob ti jchꞌulele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ti jpasmantal yuꞌun ti romano soldadoetique, cꞌalal laj yil ti jech icꞌot ta pasele, lic lequil cꞌopojuc ta stojol ti Diose. Jech laj yal: ―Ta melel, ti vinic liꞌe chꞌabal ti smule ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Scotol ti cristianoetic ti tey laj yilic ti cꞌusi icꞌot ta pasele, tey smajolanic xa batel ti stiꞌ yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Scotol ti buchꞌutic ti lec xil sbaic schiꞌuc ti Jesuse, schiꞌuc ti antsetic ti buchꞌutic laj stsꞌacliic batel ti cꞌalal iꞌechꞌ tal ta Galilea banomile, nom vaꞌajtic icomic ta sqꞌuelel ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oy jun lequil vinic ti tucꞌ yoꞌntone, José sbi, ti jaꞌ liquem talel ta jteclum Arimatea ti tey ta Judea banomile, ti jaꞌ jun banquilal jchapanvanej yuꞌun ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ti José liꞌe smalaoj onoꞌox ti ventainel yuꞌun ti Diose. Jech o xal muꞌyuc laj scoꞌoltas sjolic schiꞌuc ti yan banquilal jchapanvanejetic ti jech laj spasique. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jech ti Josee ibat ta stojol ti Pilatoe yoꞌ ta scꞌanbe sbecꞌtal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cꞌalal laj syales tal ta cruz sbecꞌtal ti Jesuse, tey lic xpixbe ta jun mucꞌ ta saquil pocꞌ. Tsꞌacal to tey bat sticꞌ ta achꞌ muquinal ti jombil ta tone, ti muꞌyuc to buchꞌu tey mucbile. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ti jech icham ti Jesuse, jaꞌ o xa smalel cꞌacꞌal ti ta xchapan sbaic yuꞌun ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ti antsetic ti jmoj liquemic talel ti ta Galilea schiꞌuc ti Jesuse, ba sqꞌuelic ti bu laj yichꞌ muquele. Jaꞌ jech xtoc laj sqꞌuelic lec comel ti bu laj yacꞌbeic comel sbecꞌtal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cꞌalal isutic batel ta snaique, tey lic xchapanic ti aceite capal ta perfumee. Cꞌalal jech laj yoꞌntonique, tey lic xcux yoꞌntonic yuꞌun ti cuxob oꞌntonale jech chac cꞌu chaꞌal ta xal ti mantale. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sob xa ta sliquebal cꞌacꞌal ti xemunae, ti antsetique ichaꞌsutic batel ta muquinal ti bu mucul ti Jesuse. Yichꞌojic batel ti perfume ti xchapanojic xa onoꞌoxe. Jaꞌ jech xtoc oy yan antsetic tey xchiꞌinojic batel. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cꞌalal icꞌotique, jaꞌ to laj yilic ti balchꞌunbil xa loqꞌuel ti mucꞌ ta ton ti jaꞌ smacoj ti tiꞌ muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ti antsetique tey iꞌochic batel ta yut chꞌen. Pero muꞌyuc xa bu tey laj stabeic sbecꞌtal ti Cajvaltic Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cꞌalal jech laj yilic ti antsetique, ochemic ta xiꞌel ta jmec. Mu stacꞌ aꞌyeluc cꞌusi ta spasic. Jaꞌ o tey laj yilic vaꞌajtic ta stsꞌelic chaꞌvoꞌ vinic ti oy xojobal ti scꞌuꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tey laj snijan sbaic ta banomil yuꞌun ti xiꞌele. Ti viniquetique jech lic yalic: ―¿Cꞌu chaꞌal liꞌ ta xasaꞌic ta muquinal ti Buchꞌu cuxul xae? ");
INSERT INTO tzotzc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Muꞌyuc xa liꞌ oye. Yuꞌun ichaꞌcuxi xa. Vuleso ta avoꞌntonic ti jech onoꞌox laj yalboxuc ti cꞌalal tey to ox oy ta Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jech laj yal: “Ti vuꞌun coꞌol jꞌelantique baꞌyel ta xiꞌacꞌat batel ta scꞌob ti jsaꞌmuliletique, ti ta xisjipanic ta cruze. Pero ta yoxibal cꞌacꞌal ta xichaꞌcuxi”, ti xayutoxuque ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jech ti antsetique jaꞌ o tey ivul ta yoꞌntonic ti jech onoꞌox iꞌalbatic yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cꞌalal iloqꞌuic batel ta muquinale, scotol ti cꞌusi laj yilique, laj yaꞌiique tey cꞌot yalbeic yaꞌi ta stojol ti buluchvoꞌ jcholcꞌopetique schiꞌuc ti yan cristianoetic ti buchꞌutic tey oyique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ti antsetic ti buchꞌu yichꞌojic batel scꞌoplal ti Jesús ta stojol ti jcholcꞌopetique, jaꞌic ti María Magdalenae, ti Juanae, ti María ti jaꞌ smeꞌ ti Jacoboe, schiꞌuc ti yan antsetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ti yajcholcꞌoptaque laj snopic ti ta sjutic ti antsetique. Jech o xal muꞌyuc laj xchꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yan ti Pedroe ilocꞌ batel ta anil cꞌalal to muquinal. Cꞌalal icꞌote, tey laj yil ti saquil poqꞌue ti maꞌuc xa tey ti bu oy to oxe. Jech o xal elom noꞌox laj yaꞌi isut batel ta na. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti jech cꞌacꞌal taje, jaꞌ o tey ta xanavic batel chaꞌvoꞌ viniquetic ti xchꞌunojic ti Jesuse, ti tey ta xbatic ta jteclum Emause. Ti jteclum Emause oy nan nopol oxib reva xil sbaic schiꞌuc ti Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ti chaꞌvoꞌique tey ta sloꞌiltaic batel scotol ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cꞌalal jech yacal ta xloꞌilajic batele, jaꞌ o tey inopaj ti Jesuse. Tey jmoj laj xchiꞌin sbaic batel ta xanobal. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Manchuc mi tey schiꞌuquic batel, pero macbil satic yoꞌ jech mu xojtiquinic ti Buchꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jech ti Jesuse tey lic sjacꞌbe ti chaꞌvoꞌique: ―¿Cꞌusi ti aloꞌilic ti ta xavalic talel ta bee? ¿Cꞌu chaꞌal ti ta xavat avoꞌntonique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jech itacꞌav ti june, ti jaꞌ Cleofas sbie: ―Ti cꞌusi icꞌot ta pasel ta Jerusalén ti volje chamjee, scotol cristianoetic snaꞌojic. ¿Mi voꞌot xa noꞌox van atuc jꞌechꞌelbeot ti muꞌyuc avaꞌbinoje? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jech o xal un, ti Jesuse jech lic sjacꞌ: ―¿Cꞌusi icꞌot ta pasel? ―xi. Ti stuquique jech lic yalic: ―Jaꞌ ti Jesús ta Nazarete, ti jaꞌ jun jꞌalcꞌop ti tsots xuꞌ yuꞌune, ti toj lec ichanubtasvan ta sba ta sat ti Diose, ta sba ta sat ti cristianoetic xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","¡Cꞌu stu un! ti banquilal paleetique schiꞌuc ti jchapanvanejetic cuꞌuntique laj yaqꞌuic ta scꞌob ti ajvalile yoꞌ jech laj yichꞌ milel ta cruz. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jaꞌ jpatoj xa ox coꞌntoncutic yuꞌun, ti jaꞌ ta xispojotic ti voꞌotic jꞌisraelotique. Maꞌuc noꞌox scotol jech taje. Oy xa ta yoxibal cꞌacꞌal ti jech icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jaꞌ jech xtoc oy jun chib antsetic ti jaꞌ jchiꞌilcutique lisibtascutic. Yuꞌun laj yalic ti ay sqꞌuelic ta sob icꞌluman nax ta muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pero muꞌyuc xa la bu tey laj stabeic sbecꞌtal ti Jesuse. Jaꞌ noꞌox tey laj staic ángeletic ti laj yalic ti cuxul xae. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tsꞌacal to jun chib jchiꞌilcutic bat sqꞌuelic ti muquinale. Jech sꞌelan laj staic jech chac cꞌu chaꞌal laj yalic ti antsetique. Pero ti Jesuse muꞌyuc bu laj yilic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jech o xal ti Jesuse jech laj yal: ―Mu xavaꞌibeic smelol. Toj macal achiquinic. Toj vocol ta xachꞌunic scotol ti cꞌusi yaloj comel ti jꞌalcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mi mu persauc ti baꞌyel ta xichꞌ svocol ti Cristoe cꞌalal mu to ta xichꞌ ti slequilale? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jech ti Jesuse lic yalbe smelol scꞌoplal stuc ti bu tsꞌibabil ta scꞌop Diose. Tey lic ta slibrotac ti Moisese. Jaꞌ jech sꞌelan xcholet laj yal batel ti cꞌu sꞌelan laj stsꞌiba comel ta slibroic ti jꞌalcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Cꞌalal icꞌotic ta jteclum ti bu ta xbatic onoꞌoxe, ti Jesuse jelavel xa ox ta xjelav spas sba yilel. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero ti stuquique laj stsatsal pajtsanic. Jech laj yalbeic: ―Coman ta jtojolcutic. Yuꞌun bat xa ti cꞌacꞌale. Ta xa xꞌoch ti acꞌobale ―xutic. Jech o xal ti Jesuse iꞌoch batel. Tey icom schiꞌuc ti chaꞌvoꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cꞌalal tey chotolic ta mexae, jech ti Jesuse tey laj stsac ti pane. Laj yalbe vocol ti Diose. Laj xetꞌ ti pane. Tey laj yacꞌbe ti chaꞌvoꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cꞌalal jech laj spase, ta ora noꞌox ijam ti satique. Jaꞌ o laj yojtiquinic. Pero ti Jesuse tey isac chꞌay ta ora. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jech ti chaꞌvoꞌique tey lic yalbe sbaic: ―Cꞌalal yacal ta xiyalbotic talel ta be smelol ti cꞌusi tsꞌibabil ta scꞌop Diose, ¿mi mu lajuc caꞌitic ta coꞌntonic ta melel ti jun yutsile? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jech ti stuquique ta ora noꞌox isutic batel ta Jerusalén. Tey icꞌotic ti bu tsobol laj staic ti buluchvoꞌ jchancꞌopetique schiꞌuc ti yane. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Cꞌalal jech icꞌotique, ti buluchvoꞌ jchancꞌopetique jech lic yalic: ―Ta melel, ichaꞌcuxi ti Cajvaltique. Yuꞌun laj yil ti Simone ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jech ti chaꞌvoꞌique lic yalic ec ti cꞌu sꞌelan iꞌalbatic ta bee, ti cꞌu sꞌelan laj yojtiquinic ti Jesuse ti cꞌalal laj xetꞌ ti pane. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ti cꞌalal jech yacalic ta sloꞌiltaele, jaꞌ o icꞌot svaꞌan sba ta oꞌlol ti Jesuse. Jech lic yal: ―Junuc avoꞌntonic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ti stuquique toj xiꞌel icꞌotic. Yuꞌun xacꞌtoicuc noꞌox ti jaꞌ jun chꞌulelal ti laj yilique. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ti Jesuse jech laj yal: ―¿Cꞌu chaꞌal ta xaxiꞌic? ¿Cꞌu chaꞌal xanaꞌetic to? ");
INSERT INTO tzotzc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Qꞌuel avilic ti jcꞌobe schiꞌuc ti cacane. Muꞌyuc yanijemun. Piquicun. Qꞌuelicun. Yuꞌun ti jun chꞌulelale muꞌyuc sbecꞌtal muꞌyuc sbaquil jech chac cꞌu chaꞌal ta xavilicune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cꞌalal jech laj yal taje, tey laj yacꞌ ta ilel ti scꞌobe, ti yacane. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero ti stuquique mu to xchꞌunic. Yuꞌun chꞌayal cꞌot yoꞌntonic ti jech xmuyubajique. Jech ti Jesuse jech laj yal: ―¿Mi oy cꞌusi jutebuc jlajestic? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jech o xal un, tey laj yacꞌbeic juteb vobil choy schiꞌuc juteb ajapom. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ti Jesuse tey laj stsac. Laj slajes ta sba ta satic ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tsꞌacal to jech lic yalbe: ―Ti cꞌusi icꞌot ta pasel ta jtojole, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal laj calboxuc ti cꞌalal tey to ox jchiꞌucoxuque. Yuꞌun tsots scꞌoplal ta xcꞌot ta jtojol jech chac cꞌu chaꞌal tsꞌibabil ta mantal yuꞌun ti Moisese, schiꞌuc ti tsꞌibabil ta slibroic ti jꞌalcꞌopetique, schiꞌuc ti tsꞌibabil ta salmoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jech o xal un, tey ijambat yoꞌntonic yuꞌun ti Jesuse, yoꞌ jech ta xaꞌibeic smelol ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jech lic yal: ―Yuꞌun jaꞌ jech tsꞌibabil ta scꞌop Dios ti ta persa ta onoꞌox xcham ti Cristoe. Jaꞌ jech xtoc ta persa ti ta onoꞌox xchaꞌcuxi ta yoxibal cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jaꞌ jech xtoc jaꞌ ta jventa ta xichꞌ alanbel yaꞌi scotol ti cristianoetique ti acꞌo sjelta yoꞌntonic yoꞌ jech ta staic perdón yuꞌun ti smulique. Pero baꞌyel liꞌ ta xlic ta Jerusalene. Jaꞌ jech ta xichꞌ albel batel sbejel banomil. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Voꞌoxuc rextigooxuc ti jech icꞌot xa ta pasel taje. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pero malaic to un. Yuꞌun ta jtacboxuc talel ta atojolic ti oy cꞌusi yaloj onoꞌox ti Jtot ta xaqꞌue. Mu to xaloqꞌuic batel liꞌ ta jteclum Jerusalene jaꞌ to ti mi laj xa avichꞌic atsatsalic ti ta xlic talel ta vinajele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jech o xal ti Jesuse laj yicꞌ loqꞌuel ti yajchancꞌoptac ti tey ta jteclum Jerusalene. Ibatic ta Betania. Cꞌalal tey xa oyique, laj stoy ti scꞌobe, laj yacꞌbe bendición. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cꞌalal jech laj yacꞌbe bendicione, jaꞌ o tey laj xchꞌac sba ta stojolic. Icꞌbil ibat ta vinajel. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ti yajchancꞌoptaque cꞌalal laj yoꞌntonic ta yichꞌel ta muqꞌue, xmuyubajic xa isutic batel ta Jerusalén. ");
INSERT INTO tzotzc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Scotol cꞌacꞌal oyic ta templo. Ta xichꞌic ta mucꞌ ti Diose. Jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cꞌalal lic meltsajuc talel scotol ti cꞌusitic oye, tey onoꞌox oy ti Jesucristoe, jaꞌ ti Buchꞌu ta xacꞌ ta naꞌel stalel ti Diose. Ti stuque tey onoꞌox schiꞌuc sbaic schiꞌuc ti Diose. Yuꞌun jaꞌ onoꞌox Dios ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti ta sliquebale, ti stuque tey onoꞌox schiꞌuc sbaic schiꞌuc ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta sventa ti Jesucristoe, imeltsaj scotol ti cꞌusitic oye. Muꞌyuc buchꞌu yan laj smeltsan ti cꞌusitic oye. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jaꞌ tey iꞌayan talel ta stojol ti cuxlejale. Ti cuxlejal taje, jaꞌ saquilal osil yuꞌun ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ti cuxlejal taje xnobobet ta icꞌal osil. Ti icꞌal osile, mu xuꞌ yuꞌun stubel ti saquilale. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oy jun vinic ti tacbil talel yuꞌun ti Diose, Juan sbi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yuꞌun tal yalbe yaꞌiic ti cristianoetique ti jaꞌ batsꞌi jꞌacꞌ-cuxlejal ti Jesucristoe, yoꞌ jech ta xchꞌunic Jesús yuꞌun ti cꞌusi ta xal ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ti Juane maꞌuc stuc ti jꞌacꞌ-cuxlejale. Yuꞌun jaꞌ noꞌox jun vinic ti tacbil talel yuꞌun ti Diose yoꞌ ta svinajesbe scꞌoplal ti jꞌacꞌ-cuxlejale. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ti Buchꞌu ta xacꞌ ta naꞌel stalel ti Diose, ti jaꞌ ta xacꞌ xojobal ta stojol scotol ti cristianoetique, ta xa xvul ta loqꞌuel liꞌ ta banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cꞌalal ital liꞌ ta banomile, manchuc mi jaꞌ laj spas ti banomile, pero ti cristianoetique muꞌyuc xojtiquinic Buchꞌu. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ital ta stojol ti yalab snichꞌnabe, jaꞌ ti jꞌisraeletique, pero ti stuquique muꞌyuc laj yichꞌic ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Manchuc mi bajbil, pero oy jlom laj xchꞌunic, laj yichꞌic ta mucꞌ. Ti buchꞌutic jech taje, iꞌacꞌbat yipic ti xuꞌ ta xꞌochic ta batsꞌi snichꞌnab ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti buchꞌu ta xꞌochic ta snichꞌnab ti Diose, jaꞌ ta xvoqꞌuesatic ta achꞌ yuꞌun ti Diose. Mu xcoꞌolaj schiꞌuc jech chac cꞌu chaꞌal ta xvoqꞌuesatic yuꞌun ti stot smeꞌique, mi jaꞌuc ti cꞌusi ta scꞌan yoꞌnton stuc ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ti Jesucristoe, jaꞌ ti Buchꞌu ta xacꞌ ta naꞌel stalel ti Diose, laj yichꞌ sbecꞌtal. Inaqui ta jtojolcutic. Oy ep scꞌuxul ti yoꞌntone. Melel ti stuque. Laj quilbecutic ti yutsilal slequilale, ti jaꞌ yutsilal slequilal stuc ti jun noꞌox Snichꞌon ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ti Juane laj yalbe scꞌoplal ti Jesucristoe. Jech laj yal: ―Jaꞌ me ti vinic leꞌe ti Buchꞌu laj calboxuc scꞌoplale, ti laj onoꞌox calboxuc avaꞌiic ti oy Buchꞌu tsꞌacal ta xtal ta patil cuꞌune ti jaꞌ toj cajale, ti jaꞌ mu sta ti vuꞌune. Yuꞌun ti stuc leꞌe, tey xa onoꞌox ti cꞌalal muꞌyucun to oxe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Laj xa quichꞌtic jcotoltic ti smucꞌ ta cꞌulejal ti Snichꞌon Diose, ti muꞌyuc spajeb ti bendicione. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ti smantal Dios ti laj caꞌitique, jaꞌ ivul ta jtojoltic ta sventa ti Moisese. Ti melele, ti cꞌuxubinel yuꞌun ti Diose, lijꞌacꞌbat yuꞌun ti Jesucristoe. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Muꞌyuc buchꞌu junucal yiloj ti Diose. Pero ti jun noꞌox Snichꞌone, ti coꞌol yoꞌntonic schiꞌuc ti Stote, jaꞌ tal yacꞌ ta ojtiquinel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ti jpasmantal jꞌisraeletic ta Jerusalene laj staquic batel paleetic schiꞌuc levitaetic ta sjacꞌbel ti Juane buchꞌu ti stuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ti Juane jech jamal laj yal: ―Ti vuꞌune muꞌcun ti Cristoune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ti stuquique jech laj xchaꞌjaqꞌuic: ―¿Buchꞌuot ti voꞌot un chaꞌe? ¿Mi jaꞌ voꞌot ti jꞌalcꞌop Elíase? ―xutic. Ti Juane jech laj yal: ―Muꞌcun ―xi. Tsꞌacal to jech laj sjaqꞌuic yan velta: ―¿Mi voꞌot ti jꞌalcꞌop ti vinajem scꞌoplal ti ta xtal onoꞌoxe? ―xutic. Ti Juane jech laj stacꞌ: ―Muꞌcun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jech laj yalic yan velta xtoc: ―¿Buchꞌuot ta melel un chaꞌe? Yuꞌun tsots scꞌoplal ta xquichꞌcutic batel acꞌoplal ta stojol ti buchꞌutic laj stacuncutic talele. ¿Cꞌusi xuꞌ ta xavalbe aba atuc? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ti Juane jech laj stacꞌbe: ―Jaꞌ vuꞌunun ti buchꞌu tsots ta xcꞌopoj ta xocol banomile jech chac cꞌu chaꞌal laj yal ti jꞌalcꞌop Isaías ti jech laj yale: “Jambeic jun tuqꞌuil be ti Cajvaltique”, ti albil scꞌoplal ti xie ―xi ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ti buchꞌutic bat scꞌoponic ti Juane, jaꞌ tacbilic batel yuꞌun ti jfariseoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ti stuquique jech laj sjacꞌbeic yan velta ti Juane: ―Ti mi moꞌcot ti Cristoe, ti mi moꞌcot ti Elíase, ti mi moꞌcot ti yan jꞌalcꞌop ta xtale, ¿cꞌu chaꞌal ti ta xavacꞌ ichꞌ voꞌe? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jech itacꞌav ti Juane: ―Ti vuꞌune, voꞌ noꞌox ta xcacꞌ ichꞌuc. Pero oy jun talem ta atojolic ti mu xavojtiquinique. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pero jaꞌ noꞌox tsꞌacal to ta sliques ti yabtele. Pero ti stuque jaꞌ más cajal. Ti vuꞌune muꞌyuc jlequilal jtuqꞌuilal ta sjitunbel yaqꞌuil ti xonobe ―xi ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Scotol taje tey icꞌot ta pasel ti bu sbiinoj Betabarae ti oy ta sloqꞌueb cꞌacꞌal ti ta ucꞌum Jordane. Jaꞌ tey laj yacꞌ ichꞌ voꞌ ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta yocꞌlomal un, laj yil ti Juane ti ta xnopaj talel ti Jesús ta stojole. Jech laj yal: ―Qꞌuel avilic, ti vinic leꞌe, jaꞌ ti uni chij yuꞌun ti Diose ti ta xchꞌaybe smul ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ti vinic leꞌe, jaꞌ ti Buchꞌu laj xa onoꞌox calboxuc avaꞌiic ti scꞌoplale, cꞌalal jech laj cale: “Oy Buchꞌu tsꞌacal ta xtal ta patil cuꞌune, ti jaꞌ toj cajale, ti jaꞌ mu sta ti vuꞌune. Yuꞌun ti stuc leꞌe oy xa onoꞌox ti cꞌalal muꞌyucun to oxe”, ti xacutique. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ti vuꞌun eque, mi jaꞌuc to ox jnaꞌ Buchꞌu ta melel ti vinic leꞌe. Jech o xal ti vuꞌune ta xcacꞌolan talel ti ichꞌ voꞌe, yoꞌ tsots scꞌoplal ta xavojtiquinic Buchꞌu ta melel ti vinic leꞌe ti voꞌoxuc jꞌisraeloxuque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jaꞌ jech xtoc ti Juane jech laj yal: ―Vuꞌun laj quil ti Chꞌul Espíritu iyal talel ta vinajel coꞌol sꞌelan jcot ta paloma ti tey icom o ta stojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Manchuc mi jech laj quil, pero mu to jnaꞌ Buchꞌu ta melel. Pero ti Buchꞌu laj stacun talel ta yaqꞌuel ichꞌ voꞌe, jech laj yalbun: “Cꞌalal ta xavil ti ta xyal talel ti Chꞌul Espíritu ta stojol jun vinique, ti ta xcom o ta stojole, jaꞌ me ti Buchꞌu ta xacꞌ avichꞌic ti Chꞌul Espíritue”, xiyut. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Laj xa quil un. Jech o xal un, rextigoun yuꞌun ti ta melel jaꞌ Snichꞌon Dios ti vinic leꞌe ―xi ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti ta yocꞌlomale, tey oy yan velta schiꞌuc chib yajchancꞌoptac ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cꞌalal laj yil ti tey ta xꞌechꞌ ti Jesuse, ti Juane jech laj yal: ―Qꞌuel avilic, ti vinic leꞌe jaꞌ ti uni chij yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cꞌalal laj yaꞌiic ti vaꞌi sꞌelan iꞌalbatic yuꞌun ti Juane, jech o xal ti chaꞌvoꞌ yajchancꞌoptaque laj stsꞌacliic batel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ti Jesuse joybij sqꞌuel ti svalopate. Laj yil ti ta stsꞌacliat batele. Jech o xal jech laj yal: ―¿Cꞌusi ta xasaꞌic? ―xi. Ti chaꞌvoꞌique jech laj staqꞌuic: ―Jchanubtasvanej, ¿bu nacalot? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ti Jesuse jech laj stacꞌ: ―Laꞌic, ba qꞌuel avilic ―xi. Jech o xal ti chaꞌvoꞌique bat sqꞌuel. Tey laj yilic ti bu nacale. Tey mal cꞌacꞌal yuꞌunic, yuꞌun chanib xa ora mal cꞌacꞌal laj snup sbaic ta be. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Oy jun ta schibalic ti laj yaꞌiic ti vaꞌi sꞌelan laj yal ti Juane, ti jech laj stsꞌacliic batel ti Jesuse, jaꞌ ti Andrese, ti schiꞌil sbaic ta voqꞌuel schiꞌuc ti Simón Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jech ti Andrese baꞌ saꞌ ta ora ti schiꞌil ta voqꞌuele, jaꞌ ti Simone. Jech laj yal: ―Laj xa jtacutic ti Mesíase ―xut. Ti Mesíase, jaꞌ smelol ti Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jech ti Andrese yicꞌoj batel ti Simone ti bu oy ti Jesuse. Cꞌalal jech laj yil ti Jesuse, jech laj yal: ―Ti voꞌote, Simón, jaꞌ snichꞌonot ti Jonase. Avi tana ta xabiin Cefas ―xi. Ti Cefase, jaꞌ smelol Pedro. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti ta yocꞌlomale, ta scꞌan ta xbat ta Galilea banomil ti Jesuse. Cꞌalal jech ibate, tey laj snup ta be ti Felipee. Jech laj yalbe: ―Chiꞌinun batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti Felipee jaꞌ liquem talel ta jteclum Betsaida, ti bu nacalic ti Andrese schiꞌuc ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ti Felipee ba saꞌ ti Natanaele. Jech laj yalbe: ―Laj xa quilcutic ti vinic ti Buchꞌu tsꞌibabil scꞌoplal yuꞌun ti jꞌalcꞌopetique schiꞌuc ti tsꞌibabil scꞌoplal ta slibroal mantaletic yuꞌun ti Moisese. Jaꞌ ti Jesús ti snichꞌon José ti nacal ta jteclum Nazarete ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ti Natanaele jech laj yal: ―¡Bu xata ti ta xlocꞌ jun lequil vinic ti ta Nazarete! ―xi. Ti Felipee jech laj stacꞌ: ―Batic, ba qꞌuel avil ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Cꞌalal laj yil ti Jesuse ti ta xnopaj talel ti Natanaele, jech laj yal: ―Liꞌ xtal jun batsꞌi jꞌisraelal vinic ti mu snaꞌ xloꞌlavane ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Cꞌalal jech laj yaꞌi ti Natanaele, jech laj sjacꞌ: ―¿Cꞌuxi yoꞌ laj avojtiquinun? ―xut. Ti Jesuse jech laj yalbe: ―Laj quilot ti cꞌalal oyot ta yolon icuxe, ti cꞌalal muꞌyuc to ta xicꞌot talel ti Felipee ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ti Natanaele jech laj yal: ―Jchanubtasvanej, voꞌot ti Snichꞌon Dios un chaꞌe. Voꞌot ti Ajvalil yuꞌun ti jꞌisraeletique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ti Jesuse jech laj stacꞌbe: ―Ti jaꞌ noꞌox laj calbot ti laj quilot ta yolon icuxe, laj xachꞌunun ta jech yepal. Pero maꞌuc noꞌox jech yepal ta xavil. Ta to xavil batel ti oy cꞌusitic más mucꞌtic ta xcꞌot ta pasel cuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jaꞌ jech xtoc ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, ta xavilic jamal ti vinajele. Ta xavilic ti yajꞌángeltac ti Diose ti ta xmuy xyalic ta jtojol vuꞌun ti coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Echꞌem xa ox oxib cꞌacꞌal ti cꞌalal oy buchꞌu ta xnupun ta jteclum Caná ti oy ta Galilea banomile. Ti smeꞌ ti Jesuse tey oy ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jech xtoc ti Jesuse schiꞌuc ti yajchancꞌoptaque icꞌbilic ta qꞌuel nupunel ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","¡Cꞌu stu un! laj ti yaꞌlel uvae. Jech o xal smeꞌ ti Jesuse jech laj yalbe ti yole: ―Laj xa yuꞌunic ti yaꞌlel uvae ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ti Jesuse jech laj stacꞌbe: ―Junmeꞌtic, ¿cꞌu chaꞌal jech xtal avalbun? Mu to xcꞌot ti coraile ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ti smeꞌe jech laj yalbe ti jtuneletique: ―Ti voꞌoxuque pasic me scotol ti cꞌusi ta xalboxuc ti cole ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ti teye, oy tey vacbej bin ti meltsanbil ta tone. Jaꞌ jtunel yuꞌunic ti jꞌisraeletique sventa chꞌamobil voꞌ sventa spocobil ti scꞌobique. Ti jujubej bin taje, ta xꞌoch nan yuꞌun nopol chanvinic, voꞌvinic ta litro voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ti Jesuse jech laj yalbe ti jtuneletique: ―Nojesic ta voꞌ ti binetic liꞌe ―xi. Ti stuquique laj snojesic. Xjaxet icom ta voꞌ yuꞌunic stiꞌ ti bine. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jaꞌ o jech laj yal ti Jesuse: ―Lupic loqꞌuel jutebuc ti voꞌe. Ba acꞌbeic ti jpasmantal yuꞌun ti qꞌuine ―xi. Jech laj spasic ti jtuneletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti jpasmantal yuꞌun ti qꞌuine laj spas preva ti voꞌe. Jaꞌ to laj yaꞌi ti yaꞌlel uva xae. Pero mu snaꞌ bu ital. Jaꞌ noꞌox snaꞌic ti jtuneletique. Yuꞌun ti stuquique laj slupic loqꞌuel ti voꞌ ti oy ta bine. Jech o xal ti jpasmantal yuꞌun ti qꞌuine laj yicꞌ talel ti jnupunele. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Jech laj yalbe: ―Jcotoltic jech ti jtaleltic ti jaꞌ baꞌyel ta xcuchꞌtic ti lequil yaꞌlel uvae. Cꞌalal mi laj xa yuchꞌic ep ti jqꞌuel-qꞌuinetique, tsꞌacal to un, jaꞌ to ta xlic yichꞌ uchꞌel ti jutuc xa lec meltsanbile. Pero ti voꞌote jaꞌ laj aqꞌuej to ti bu lec meltsanbile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ti vaꞌi sꞌelan laj spas ti Jesús ta Caná jteclum ti oy ta Galileae, jaꞌ sba velta laj yacꞌ iluc ti señail ti jun yutsil ti smucꞌul stsatsale. Jech o xal ichꞌbil ta mucꞌ icꞌot ti Jesús yuꞌun ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsꞌacal to un, ti Jesuse ibat ta jteclum Capernaum schiꞌuc ti smeꞌe, schiꞌuc ti yitsꞌinabtaque, schiꞌuc ti yajchancꞌoptaque. Tey ijocꞌtsajic jayib cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nopol xa scꞌan ti qꞌuin Colel yuꞌun ti jꞌisraeletique. Jech o xal ti Jesuse ibat ta jteclum Jerusalén. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ti teye, noj cꞌot sta ti templo yuꞌun ti jchon-vacaxetique, ti jchon-chijetique, ti jchon-palomaetique, schiꞌuc ti jel-taqꞌuinetic chotajtic ta smexaic ta sjelbeic staqꞌuinic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ti jech laj yile, jech ti Jesuse tey lic smochilan chꞌojon. Tey laj snutsan loqꞌuel ti jchonolajeletique schiꞌuc ti svacaxique, ti schijique. Jaꞌ jech xtoc laj stanibe staqꞌuin, laj svalcꞌunbe smexaic ti jel-taqꞌuinetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jech laj yalbe ti jchon-palomaetique: ―Loqꞌuesic batel ti paloma liꞌe. Mu xapasic ta chꞌivit sna ti Jtote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cꞌalal jech laj yilic ti yajchancꞌoptaque, ivul ta yoꞌntonic ti jech ta xal ti scꞌop Diose: “Oy onoꞌox ta coꞌnton ti ta jcꞌan caꞌi ti lec ti atemploe. Jaꞌ yuꞌun ta jta vocol”, xi scꞌoplal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jech o xal ti jꞌisraeletique laj sjacꞌbeic ti Jesuse: ―¿Cꞌusi señail ta xavacꞌbun quilcutic yoꞌ ta jnaꞌcutic buchꞌu yacꞌojbot avabtel ti jech ta xapase? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ti Jesuse jech laj stacꞌbe: ―Lilinic ti templo liꞌe, ta oxib cꞌacꞌal ta jvaꞌan ta achꞌ ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jech ti jꞌisraeletique jech laj yalbeic: ―Ta vaquib yoxvinic (46) jabil icꞌot ta vaꞌiel ti templo liꞌe. ¡Bu xata ti voꞌot ta xavaꞌan ta oxib cꞌacꞌal yan achꞌe! ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ti templo ti ta xal ti Jesuse, jaꞌ sbecꞌtal stuc. Maꞌuc scꞌoplal ti mucꞌ ta temploe. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jech o xal ti cꞌalal ichaꞌcuxi ti Jesuse, jaꞌ o ivul ta yoꞌntonic ti yajchancꞌoptaque ti jech onoꞌox laj yal ti stuque. Jaꞌ jech xtoc laj xchꞌunic ti melel ti scꞌop Dios ti jech onoꞌox laj yale. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ti Jesuse, cꞌalal oy ta qꞌuin Colel tey ta Jerusalene, ep ti buchꞌutic laj yichꞌic ta mucꞌ ta sventa ti laj yacꞌ iluc ti smucꞌul stsatsale. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ti Jesuse mu sjunuluc yoꞌnton ta stojolic. Yuꞌun xojtiquinbe yoꞌntonic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mu persauc ti oy buchꞌu ta xꞌalbat ti cꞌu sꞌelan yoꞌnton ti cristianoetique. Yuꞌun yiloj stuc ti cꞌusi oy ta yoꞌnton ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oy jun jfariseo vinic, Nicodemo sbi, ti ichꞌbil ye yuꞌun ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ti Nicodemoe tey ibat scꞌopon ta acꞌobaltic ti Jesuse. Jech laj yalbe: ―Jchanubtasvanej, jnaꞌojcutic lec ti tacbilot talel yuꞌun ti Diose yoꞌ jech tal achanubtasuncutic. Yuꞌun muꞌyuc buchꞌu junucal ti jech ta xacꞌ iluc smucꞌul stsatsal jech chac cꞌu chaꞌal ta xapase ti mi muꞌyuc chiꞌinbil yuꞌun ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ti Jesuse jech lic stacꞌbe: ―Ta melel ta xcalbot avaꞌi, ti buchꞌu mu xvocꞌ ta achꞌe, mu xuꞌ ta xil ti bu ta xventainvan ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ti Nicodemoe jech laj sjacꞌbe: ―Pero, ¿cꞌusi xut jun yijil vinic ta xvocꞌ ta achꞌ? ¿Mi yuꞌun xuꞌ ta xꞌoch batel ta schꞌut ti smeꞌe yoꞌ jech ta xvocꞌ yan velta? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ti Jesuse jech laj stacꞌbe: ―Ta melel ta xcalbot avaꞌi, muꞌyuc buchꞌu ta xꞌoch batel ti bu ta xventainvan ti Diose ti mi muꞌyuc voqꞌuem ta sventa ti voꞌe schiꞌuc ta sventa ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ti buchꞌu voqꞌuem ta sventa ti stot smeꞌique, stalel noꞌox stot smeꞌ. Ti buchꞌu voqꞌuem ta sventa ti Chꞌul Espíritue, yichꞌojbe stalel ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mu me loꞌiluc noꞌox xavaꞌiic ti vaꞌi sꞌelan laj calbote, yuꞌun acotolic ta scꞌan ta xachaꞌvoqꞌuic ta achꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Qꞌuel avil, ti iqꞌue buꞌyuc noꞌox xjumet ta jujot. Ta xavaꞌi ti xjumete. Pero mu xanaꞌ bu ta xtal bu ta xbat. Jaꞌ jech sꞌelanic scotol ti buchꞌutic ta xvoqꞌuic yuꞌun ti Chꞌul Espíritue ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jech xtoc ti Nicodemoe laj xchaꞌjacꞌ: ―¿Cꞌu onoꞌox xi ta utel taje? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ti Jesuse jech laj stacꞌbe: ―¿Mi mu banquilal jchanubtasvanejucot yaꞌyel yuꞌun ti achiꞌiltaque? ¿Mi mu xavaꞌibe smelol taje? ");
INSERT INTO tzotzc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ta melel ta xcalbot avaꞌi, ti vuꞌuncutique ta xcalbecutic scꞌoplal ti cꞌusi jnaꞌcutique. Jaꞌ jech xtoc rextigouncutic ti cꞌusi quilojcutique. Pero ti cꞌusi ta xcalcutique, mu xacꞌan xachꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi mu xachꞌun ti laj calbot ti oy cꞌusi ta xcꞌot ta pasel liꞌ ta banomile, ¿cꞌusi ta xavut ta xachꞌun mi ta xcalbot scꞌoplal ti oy cꞌusi ta xcꞌot ta pasel ta vinajele? ");
INSERT INTO tzotzc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Mi jaꞌuc oy buchꞌu muyem batel sqꞌuel ti cꞌusi oy ta vinajele. Jtuc noꞌox quiloj. Yuꞌun tey liquemun talel ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jech chac cꞌu chaꞌal ti Moisés laj sjipan ta teꞌ slocꞌobbail chon ta xocol banomile, jaꞌ jech ta xquichꞌ jipanel ta cruz ec ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jech o xal scotol ti buchꞌutic ta xischꞌunique, mu xchꞌayic. Ta sta scuxlejalic sbatel osil ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yuꞌun ti Diose ep laj xcꞌuxubin ti cristianoetique. Jech o xal laj yacꞌ talel ti jun noꞌox Snichꞌone. Buchꞌuuc noꞌox ti ta xchꞌunic ti jaꞌ Jpojvanej yuꞌunique, mu xchꞌayic. Ta sta scuxlejalic sbatel osil. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ti Diose mu yuꞌunuc laj stac talel ti Snichꞌone yoꞌ tal yacꞌbe stoj smul ti cristianoetique. Jaꞌ tal scolta. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ti buchꞌu ta xchꞌun ti jaꞌ Jpojvanej yuꞌun ti Snichꞌon Diose, mu xꞌacꞌbat stoj ti smulique. Pero ti buchꞌu mu xchꞌun ti jaꞌ Jpojvanej yuꞌune, chapal xa scꞌoplal ti ta stoj ti smule ta scoj ti mu xchꞌun ti jun noꞌox Snichꞌon Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ti buchꞌutic mu xchꞌunique chapal xa scꞌoplal ti ta stoj ti smulique. Yuꞌun ti cꞌalal ital liꞌ ta banomil ti Jesucristo ti jaꞌ luze, mu lecuc laj yaꞌiic. Jaꞌ lec laj yaꞌiic ti icꞌal osile. Jaꞌ mu laj scꞌanic ti saquilal osile. Yuꞌun lec ta xaꞌiic spasel ti chopole. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Scotolic ti buchꞌutic ti ta spasic ti chopole, xtiꞌet sjolic yuꞌun ti luze. Mu scꞌan xnopajic ta stojol ti luze yoꞌ jech mu xvinajesbatic ti cꞌusi chopol ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ti buchꞌu coꞌol yoꞌntonic schiꞌuc ti melele ta xnopajic ta stojol ti luze yoꞌ jech ta xvinaj ti tey svaꞌanoj sba ti Dios ti cꞌusi ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsꞌacal to ti Jesuse schiꞌuc ti yajchancꞌoptaque ibatic ta Judea banomil. Tey ijocꞌtsajic jun chib cꞌacꞌal, yuꞌun ta xaqꞌuic ichꞌ voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jaꞌ jech xtoc ti Juane ta xacꞌ ichꞌ voꞌ ti ta jteclum Enón ti jaꞌ nopol xil sbaic schiꞌuc ti jteclum Salime, yuꞌun ti teye oy ep voꞌ. Ti cristianoetique tey ta xtalic ta xꞌacꞌbat yichꞌic voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jech icꞌot ta pasel cꞌalal muꞌyuc to ox ta xꞌoch ta chuquel ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oy jun chib yajchancꞌoptac ti Juane lic stsac sbaic ta cꞌop schiꞌuc jun chib jꞌisraeletic yuꞌun ti cꞌu sꞌelan liquem yuꞌunic ti slecubtasobil sbaic ta xalique. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jech o xal ti yajchancꞌoptac ti Juane ibatic ta stojol ti Juane. Jech lic yalbeic: ―Jchanubtasvanej, ti vinic ti laj avalbuncutic scꞌoplal ti voꞌot achiꞌuc to ox ta stiꞌil ucꞌum Jordán ta sloqꞌueb cꞌacꞌale, avi tana un, ta xacꞌ ichꞌ voꞌ. Scotolic ta stsꞌacliic batel ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ti Juane jech laj stacꞌ: ―Muꞌyuc cꞌusi xuꞌ yuꞌun jun vinic ti mi maꞌuc acꞌbil yabtel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ti voꞌoxuque laj avaꞌiic lec cꞌalal jamal laj cal ti moꞌcun ti Cristoune, ti jaꞌ noꞌox jun vinicun ti tacbilun jelavel talel yuꞌun ti xichie. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ti ta jun nupunele, ti vinic ti buchꞌu ta xicꞌ ti tsebe, jaꞌ yuꞌun o. Ti vinic ti buchꞌu lec ta xil sbaic schiꞌuc ti jnupunel vinique, xmuyubaj xa ta xaꞌibe ti scꞌope. Jaꞌ jech ti vuꞌun eque, ximuyubaj xa yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jaꞌ tsots scꞌoplal ti yantic batel ti ichꞌbil ta mucꞌ ta xcꞌot ti stuque. Yan ti vuꞌune, yantic ta xchꞌay batel ti jcꞌoplale ―xi ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ti Buchꞌu ta xlic talel ta vinajele, jaꞌ banquilal yuꞌun scotol. Yan ti buchꞌu ayanem liꞌ ta banomile, sba banomil noꞌox, jech xtoc sba banomil noꞌox ti scꞌope. Yan ti Buchꞌu ta xlic talel ta vinajele, jaꞌ banquilal yuꞌun scotol. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jech xtoc ta xalbe scꞌoplal ti cꞌusi yiloje, ti cꞌusi yaꞌyioj teye. Pero mu xchꞌunbat ti cꞌusi ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ti mi oy buchꞌu ta xchꞌun ti cꞌusi ta xal ti Buchꞌu liquem talel ta vinajele, ta xlic yil ti jaꞌ melel xcꞌot xcꞌopoj ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ti Buchꞌu tacbil talel yuꞌun ti Diose, jaꞌ noꞌox ta xal ti cꞌusi oy ta ye ti Diose. Yuꞌun ti Diose mu bisbiluc laj yacꞌbe ti Chꞌul Espíritu yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ti Totile cꞌux ta xaꞌi ti Snichꞌone. Jech o xal un, laj xa yacꞌbe ta yoc ta scꞌob scotol ti cꞌusitic oye. ");
INSERT INTO tzotzc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ti buchꞌu ta xchꞌun ti jaꞌ Jpojvanej yuꞌun ti Nichꞌonile, oy scuxlejal sbatel osil. Yan ti buchꞌu mu scꞌan xchꞌun ti jaꞌ Jpojvanej yuꞌun ti Nichꞌonile, mu sta ti cuxlejale. Jaꞌ noꞌox ta xichꞌ tsots castigo yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ti jfariseoetique laj yaꞌiic ti ep ti cristianoetic ta stsꞌacliic batel ti Jesuse schiꞌuc ti ep ta xacꞌ ti ichꞌ voꞌe, ti jaꞌ mu sta ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero maꞌuc stuc Jesús ti ta xacꞌ ti ichꞌ voꞌe, yuꞌun jaꞌ ta xaqꞌuic ichꞌ voꞌ ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Cꞌalal jech laj yaꞌi ti Jesús taje, ilocꞌ batel ti ta Judea banomile. Isut batel ta Galilea banomil. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ti jech isut batele, iꞌechꞌ ta yosilal Samaria. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jech ti Jesuse icꞌot ta jteclum Sicar ti oy ta Samariae, ti nopol xil sbaic schiꞌuc ti banomil ti jaꞌ yuꞌun to ox ti Jacobe, ti laj yacꞌbe comel ti snichꞌone, jaꞌ ti Josee. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ti teye oy jun jocꞌ ti sbiinoj sjocꞌ Jacobe. Ti jech lubem xa ta xanobal ti Jesuse, icꞌot chotiuc ta stiꞌil ti joqꞌue yuꞌun jutuc xa scꞌan oꞌlol cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Cꞌalal jech chotol ta stiꞌil jocꞌ ti Jesuse, jaꞌ o tal slup voꞌ jun ants ti liquem talel ta Samariae. Ti Jesuse jech laj yal: ―Acꞌbun jutebuc avaꞌal cuchꞌ ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ti yajchancꞌoptaque muꞌyuc tey oyic. Yuꞌun ibatic ta jteclum ta smanel talel sveꞌelic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ti jsamaria antse jech laj stacꞌbe: ―¿Cꞌu chaꞌal ta xacꞌanbun voꞌ avuchꞌ ti voꞌot jꞌisraelote cꞌalal ti vuꞌun jsamaria antsune? ―xi. Jaꞌ jech laj yal ti antse, yuꞌun ti jꞌisraeletique mu lecuc xil sbaic schiꞌuc ti jsamariaetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ti Jesuse jech laj stacꞌbe: ―Ti xanaꞌuc ti cꞌusi ta xacꞌ ti Diose, ti xanaꞌuc ti Buchꞌu ta scꞌanbot ti voꞌe, ta melel umbi, voꞌot ta xacꞌanbun ti voꞌ ti jechuque. Jech ti vuꞌune ta xcacꞌbot ti cuxul voꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ti antse jech laj yal: ―Ti voꞌote, ¿bu ta xata talel ti cuxul voꞌ ti ta xavacꞌbune ti cꞌalal toj nat ti joqꞌue? Jaꞌ jech xtoc muꞌyuc cꞌusi oy avuꞌun yoꞌ ta xalup loqꞌuel tal ti voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Mi yuꞌun voꞌot más to cajal latal yaꞌyel? ¿Mi jaꞌ mu sta ti jmolmucꞌtotcutic Jacobe, ti jaꞌ laj yacꞌbuncutic ti jocꞌ liꞌe, ti liꞌ laj yuchꞌ ti stuque, ti liꞌ laj yuchꞌ xtoc ti snichꞌnabtaque schiꞌuc scotol ti cꞌusitic oy yuꞌune? ―xi ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ti Jesuse jech laj stacꞌbe: ―Scotolic ti buchꞌutic ta xuchꞌic ti voꞌ liꞌe, ta xchaꞌtaquij ti yoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yan ti buchꞌutic ta xuchꞌic ti voꞌ ti vuꞌun ta xcaqꞌue, mu xtaquij o ti yoꞌntonique. Yuꞌun jech ta xcꞌot ta yoꞌntonic jech chac cꞌu chaꞌal nioꞌ ti mu snaꞌ xꞌule. Tey xtuctun o ta yoꞌntonic ti jaꞌ ta xꞌacꞌbat scuxlejalic sbatel osile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ti antse jech laj stacꞌbe: ―Acꞌbun ti voꞌ taje yoꞌ jech mu xtaquij ti coꞌntone, jaꞌ jech xtoc yoꞌ mu liꞌuc xivaꞌvun ta slupel ti voꞌ liꞌ ta joqꞌue ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ti Jesuse jech laj yalbe: ―Batan, ba icꞌo talel ti amalale. Jaꞌ jech xtoc un, laꞌic liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ti antse jech laj stacꞌ: ―Muꞌyuc jmalal ―xi. Jech ti Jesuse laj stacꞌbe: ―Oy arazon ti jech chꞌabal amalal ta xavale. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yuꞌun laj xa amalalin voꞌob viniquetic. Yan ti tey achiꞌuc avi liꞌe, maꞌuc amalal. Jech o xal jamal laj aval ti chꞌabal amalale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cꞌalal jech laj yaꞌi ti antse, jech laj yal: ―Ta xquil ti voꞌot jun jꞌalcꞌopote. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ti jmolmucꞌtotcutic ta voꞌnee jech yaloj caꞌicutic ti vuꞌuncutic jsamariauncutique ti laj yichꞌic ta mucꞌ ti Dios liꞌ ta vitse. Yan ti voꞌoxuc jꞌisraeloxuque ta xavalic ti ta scꞌan ti cꞌalal to Jerusalén chba quichꞌtic ta mucꞌ ti Diose ―xi ti antse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ti Jesuse jech laj stacꞌbe: ―Chꞌunbun ti oy bu ta sta yorail ti mi jaꞌuc ta vitse, mi jaꞌuc ta Jerusalén ti chba avichꞌic ta mucꞌ ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ti voꞌoxuc jsamariaoxuque mu xanaꞌic ti buchꞌu ta xavichꞌic ta muqꞌue. Yan ti vuꞌuncutic jꞌisraeluncutique jnaꞌcutic ti Buchꞌu ta xquichꞌcutic ta muqꞌue. Yuꞌun ti coltaele ta xlic tal ta stojol ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sta xa yorail, jaꞌ xa yorail avi liꞌe, ti buchꞌutic ta xichꞌic ta mucꞌ ti Diose, jaꞌ ta xichꞌic ta mucꞌ ti Dios ti ta yut yoꞌntonic ta melele. Yuꞌun ti Jtotic Diose jaꞌ jech oy ta yoꞌnton ti jaꞌ jech acꞌo ichꞌatuc ta muqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yuꞌun ti Diose mu xvinaj ta qꞌuelel. Jech o xal ti buchꞌutic ta xichꞌic ta muqꞌue, acꞌo locꞌuc ayanuc ta yut yoꞌnton ta melel ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ti antse jech laj stacꞌ: ―Caꞌbinoj ti ta xtal ti Mesíase, jaꞌ ti Cristo ta xalique. Cꞌalal mi itale, xtal svinajesbuncutic scotol ti cꞌusi mu jnaꞌcutique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ti Jesuse jech laj yal: ―Ti taje, vuꞌunun ti liꞌ yacal ta xicꞌopoj ta atojole ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Cꞌalal jech yacal ta xloꞌilaj ti Jesuse, jaꞌ o italic ti yajchancꞌoptaque. Labal laj yaꞌiic ti jech ta xchiꞌin ta loꞌil ants ti Jesuse. Pero ti stuquique muꞌyuc buchꞌu junucal laj sjacꞌbeic ti cꞌusi ta scꞌan ti antse, ti cꞌusi ti sloꞌilique. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jech ti antse tey laj yicta comel ti sqꞌuibe. Ibat ta jteclum. Jech laj yalbe ti schiꞌiltaque: ");
INSERT INTO tzotzc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Laꞌic, ba jqꞌueltic avilic jun vinic ti buchꞌu laj xa svinajesbun scotol ti cꞌusi laj jpase. Mu jnaꞌ mi jaꞌ ti Cristo chcale ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Cꞌalal jech laj yaꞌiique, iloqꞌuic batel ta jteclum. Bat sqꞌuelic bu oy ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cꞌalal mu to ta xvulic ti cristianoetique, ti yajchancꞌoptaque lic scꞌanbe vocol ti Jesús ti jech laj yalique: ―Jchanubtasvanej, veꞌan jutebuc ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero ti Jesuse jech laj yal: ―Oy yan jveꞌel ta jlajes ti voꞌoxuc mu xavojtiquinique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ti yajchancꞌoptaque jech lic sjacꞌbe sbaic: ―¿Mi yuꞌun van oy buchꞌu tal acꞌbatuc sveꞌel? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ti Jesuse jech laj yal: ―Ti jveꞌele, jaꞌ ti ta jpas ti cꞌusi ta scꞌan ti Buchꞌu laj stacun talele, ti ta jtsutsesbe ti yabtele. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ti voꞌoxuque ta xavalic ti scꞌan to chanib u ta xichꞌ tsobel ti tsꞌunobale. Pero vuꞌun ta xcalboxuc avaꞌiic, qꞌuel avilic, toyic batel asatic ta tsꞌunobaltic. Yuꞌun yij xa ti tsꞌunobale. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ti buchꞌu ta xꞌabtej ta stsobel ti tsꞌunobale ta xichꞌ stojol. Ti tsꞌunobal ti ta stsobe, jaꞌ cuxlejal sbatel osil. Jech o xal ti buchꞌu ta stsꞌune schiꞌuc ti buchꞌu ta stsobe coꞌol xmuyubaj yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yuꞌun melel ti oy me jech xꞌale ti cꞌop xavaꞌie: “Yan o ti buchꞌu laj stsꞌune. Yan o ti buchꞌu laj stsobe”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yuꞌun vuꞌun laj xa jtacoxuc batel ta stsobel ti tsꞌunobal ti moꞌcoxuc laj avichꞌ avocolic ta stsunele. Yuꞌun yan ti buchꞌu iꞌabtejique. Pero ti voꞌoxuque ta xatsobic ti yabtelic ti yane ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ti jnaclejetic tey ta Samariae ep laj xchꞌunic ti Jesuse ta sventa ti ants ti jech laj yale: “Laj yalbun scotol ti cꞌusi laj jpase”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cꞌalal icꞌotic ti jsamariaetic ta stojol ti Jesuse, laj scꞌanbeic vocol ti Jesuse ti acꞌo comuc ta stojolique. Jech ti Jesuse icom chib cꞌacꞌal tey. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Más to iꞌepajic ta xchꞌunel ta sventa ti cꞌusi ta xal stuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ti stuquique jech laj yalbeic ti antse: ―Avi tana un, maꞌuc noꞌox ta jchꞌuncutic ti cꞌusi laj avalbuncutique. Yuꞌun ti vuꞌuncutique laj xa caꞌicutic, laj xa jnaꞌcutic ti jaꞌ ta melel ti Cristoe, ti jaꞌ Jcoltavanej yuꞌun ti cristianoetique. Jech o xal ta jchꞌuncutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cꞌalal echꞌ ti chib cꞌacꞌale, ti Jesuse ilocꞌ batel ti tey ta Samaria banomile. Ibat cꞌalal to Galilea banomil. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yuꞌun jech laj yalbe sba scꞌoplal stuc ti Jesuse: “Ti jun jꞌalcꞌope muꞌyuc ichꞌbil ta mucꞌ yuꞌun ti slumal stuque”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cꞌalal icꞌot ta Galilea ti Jesuse, ti cristianoetic teye xmuyubajic laj yichꞌic ta mucꞌ. Yuꞌun ti stuquique laj yilic cꞌusitic laj xa spas ti Jesuse ti cꞌalal iꞌayic ta qꞌuin Colel ti ta Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tsꞌacal to un, ti Jesuse isut batel ta jteclum Caná ti oy ta Galileae, ti bu ijoybij yuꞌun ta yaꞌlel uva ti voꞌe. Ti teye oy jun yajꞌabtel ajvalil ti tsots yabtel yichꞌoje ti ip ta xaꞌi ti snichꞌon ti oy ta Capernaume. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ti jꞌabtele, cꞌalal laj yaꞌi ti tal xa ta Galilea ti Jesuse, bat sqꞌuel. Laj scꞌanbe vocol ti acꞌo batuc ta sna, ti acꞌo coltabatuc ti snichꞌone, yuꞌun ta xcham xa. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ti Jesuse laj yal: ―Ti voꞌoxuque mi mu xcacꞌ avilic ti jmucꞌul jtsatsale, mu xachꞌunicun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ti jꞌabtele jech laj yal: ―Cajval, batic ta ora yoꞌ to mu ta xcham ti jnichꞌone ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ti Jesuse jech laj yal: ―Batan xa ta ana. Ti anichꞌone cuxul xa ―xi. Ti jꞌabtele laj xchꞌun ti jech iꞌalbat yuꞌun ti Jesuse. Jech o xal ibat. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cꞌalal nopol xa scꞌan xcꞌot ta snae, jaꞌ o iloqꞌuic talel yajtuneltac, tal nupatuc ta be ti jech laj yalique: ―Ti anichꞌone col xa ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ti jꞌabtele laj sjacꞌbe ti yajtuneltaque ti cꞌusi ora icol ti snichꞌone. Ti stuquique laj yalic: ―Jliquel xa stsꞌebujel cꞌacꞌal volje paj ti scꞌacꞌale ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ti totile laj snaꞌ ti jaꞌ jech ora ti jech iꞌalbat yuꞌun ti Jesuse: “Ti anichꞌone cuxul xa”, ti xꞌutate. Ti stuque schiꞌuc ti cꞌu yepal tey ta nae laj xchꞌunic ti jaꞌ Jcoltavanej ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jaꞌ schibal velta laj yacꞌ iluc smucꞌul stsatsal ti Jesús cꞌalal ilocꞌ talel ta Judeae, ivul ta Galilea. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsꞌacal to un, ti Jesuse isut batel ta Jerusalén ti bu ta spasic qꞌuin ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ti tey ta jteclum Jerusalene, oy jun mucꞌ ta tiꞌ mocꞌ ti Chijetic sbie. Tey nopol oy jun yavil stsꞌanleb voꞌ ti Betesda sbi ta hebreo cꞌope, ti yichꞌoj voꞌob scotcotil scoriolal nae. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ti ta yolon scoriolal ti nae, ep ti jchameletic ti tey puchꞌajtic ta lumtique, ti maꞌsatetique, ti coxovetique, schiꞌuc ti aluneb ti sbecꞌtalique. Yuꞌun ta smalaic ti ta xlic yuqꞌuilajuc ti voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yuꞌun xchꞌunojic ti ta xyal talel ta vinajel jun ángel ti xtal syuqꞌuilan ti voꞌ snom staje. Jech ti buchꞌu baꞌyel ta stsꞌaj sba ochele ta xcol ti cꞌusiuc noꞌox ti schamelique. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ti teye, oy jun vinic ti chib xa jabil scꞌan ta sta chaꞌvinic (38) jabil ti oy ti schamele. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Cꞌalal laj yil ti Jesús ti tey puchꞌul ti vinique, ti jal xa ta jmec stsꞌicoj ti schamele, jech lic sjacꞌbe: ―¿Mi ta xacꞌan ta xacol? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ti jchamele jech laj stacꞌ: ―Qꞌuitsꞌin, muꞌyuc buchꞌu xuꞌ ta xistsꞌaj ochel ti cꞌalal ta xyuqꞌuilaj ti voꞌe. Cꞌalal ta jcꞌan jticꞌ jba caꞌi ochel ta voꞌe, yan o ti buchꞌu baꞌyel ta stsꞌaj sba ta anil ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ti Jesuse jech laj yalbe: ―Lican, balo batel ti apope, batan ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Cꞌalal jech laj yaꞌi ti jchamele, ta ora noꞌox icol. Laj sbal batel ti spope. Lic xanavuc. Ti cꞌalal icol ti jchamel vinique, jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jech o xal ti jꞌisraeletique laj yalbe ti vinic ti buchꞌu col xae: ―Ti cꞌacꞌal liꞌe, jaꞌ scꞌacꞌalil ti cuxob oꞌntonale. Jech o xal mu xuꞌ xacuch batel ti apope ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ti vinique jech laj stacꞌ: ―Ti Buchꞌu laj scolesune laj yalbun: “Balo bal ti apope, batan”, xiyut ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ti jꞌisraeletique jech laj sjacꞌbeic: ―¿Buchꞌu ti jech laj yalbote ti balo batel ti apope, batan ti xayute? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ti vinique mu xojtiquin ti Buchꞌu icoltaate. Yuꞌun ti Jesuse icapij ta epal cristianoetic ti tey oyique. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsꞌacal to un, ti Jesuse tey laj sta ta templo ti vinique. Jech laj yalbe: ―Ti liꞌe colemot xa. Mu xa me xasaꞌ amul yoꞌ jech mu xcꞌot ta atojol ti más to chopole ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jech ti vinique bat yalbe yaꞌi ti jꞌisraeletique ti jaꞌ icoltaat yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jech o xal ti jꞌisraeletique lic scrontainic ti Jesuse. Ta scꞌan ta smilic yaꞌiic. Yuꞌun mu lecuc laj yaꞌiic ti jech ta spas ta scꞌacꞌalil cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ti Jesuse jech laj yalanbe: ―Qꞌuel avilic, ti Jtote yacal ta abtel. Jaꞌ jech ti vuꞌune ta xiꞌabtej ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jech o xal ti jꞌisraeletique más to ta scꞌan ta smilic yaꞌiic ti Jesuse. Yuꞌun maꞌuc noꞌox ti mu xichꞌ ta mucꞌ ti mantal yuꞌun ti cuxob oꞌntonale. Jaꞌ jech xtoc yuꞌun ta scoꞌoltas sba schiꞌuc ti Diose, jaꞌ ti laj yal ti jaꞌ stot ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, ti vuꞌun Snichꞌonun ti Diose muꞌyuc cꞌusi xuꞌ ta jpas ti ta jtuc noꞌoxe. Jaꞌ noꞌox ta jpas ti ta xquil ti cꞌusi ta spas ti Jtote. Scotol ti cꞌusi ta spas ti Jtote, jaꞌ jech ta jpas ti vuꞌun Snichꞌonun eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yuꞌun ti Jtote cꞌux ta xiyaꞌi ti vuꞌun Snichꞌonune. Jaꞌ ta xacꞌbun jnaꞌ scotol ti cꞌusi ta spase. Oy to cꞌusi más ta xacꞌbun jpas ti toj chꞌayal avoꞌntonic ta xacꞌotic yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jech chac cꞌu chaꞌal ti Jtot ti ta xchaꞌcuxes ti animaetic yoꞌ ta xacꞌbe scuxlejale, jaꞌ jech ti vuꞌun Snichꞌonune ta xcacꞌbe scuxlejal ti buchꞌu ta jcꞌan ta xcacꞌbee. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ti Jtote mi junuc ta xchapan. Vuꞌun laj xa yacꞌbun quichꞌ ta jventa ti ta jchapan scotole. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jech ta jpas yoꞌ jech scotolic acꞌo yichꞌicun ta mucꞌ ti Snichꞌonune jech chac cꞌu chaꞌal ta xichꞌic ta mucꞌ ti Jtote. Yan ti buchꞌu mu xiyichꞌicun ta mucꞌ ti Snichꞌonune, mu xichꞌic ta mucꞌ ti Jtot ti laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ta melel ta xcalboxuc avaꞌiic, buchꞌuuc noꞌox ti ta stsꞌetan lec schiquin ta yaꞌyiel ti cꞌusi ta xcale, ti ta xichꞌic ta mucꞌ ti Buchꞌu laj stacun talele, oy xa scuxlejal sbatel osil. Muꞌyuc ta xichꞌic chapanel. Laj xa yicta comel ti chamebale, bat xa sta ti cuxlejale. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","’Ta melel ta xcalboxuc avaꞌiic, sta xa yorail, jaꞌ xa yorail liꞌe, ti buchꞌu chamemique ta xaꞌibeicun jcꞌopojel ti vuꞌun Snichꞌonun ti Diose. Ti buchꞌutic ta xichꞌic ta mucꞌ ti jcꞌope ta xcuxiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yuꞌun ti Jtote statel o cuxul. Jech o xal un, oy smucꞌul stsatsal ta yaqꞌuel ti cuxlejale. Jaꞌ jech ti vuꞌun Nichꞌonilune acꞌbilun jmucꞌul jtsꞌatsꞌal ta yaqꞌuel ti cuxlejal eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jaꞌ jech xtoc ti Jtote yacꞌojbun tsots cabtel yoꞌ ta xichapanvan, jaꞌ ti vuꞌun coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ti jech taje, mu chꞌayaluc xcꞌot avoꞌntonic yuꞌun. Yuꞌun ta sta yorail ti scotol ti animaetique ta xaꞌibeicun ti jcꞌopojele. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jech ti animaetique ta xloqꞌuic talel ti buꞌyuc noꞌox mucajtique. Ti buchꞌutic lec laj spasique ta xchaꞌcuxiic yoꞌ ta staic ti cuxlejale. Yan ti buchꞌutic chopol laj spasique ta xchaꞌcuxiic yoꞌ jech ta xꞌacꞌbat stoj ti smulique. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Muꞌyuc cꞌusi xuꞌ ta jpas ta jtuc noꞌox. Ti ta xichapanvane, jaꞌ ti cꞌu sꞌelan ta xiꞌalbate. Lec tucꞌ ta xichapanvan, yuꞌun maꞌuc ta jpas ti cꞌu sꞌelan ta jcꞌan jtuque. Yuꞌun jaꞌ ta jpas ti cꞌusi ta scꞌan ti Jtot ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yan ti jtucuc noꞌox ta jvinajes ti jcꞌoplale, jech ti voꞌoxuque xuꞌ xanaꞌetic cuꞌun umbi. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero liꞌe, oy xa onoꞌox buchꞌu laj svinajes jcꞌoplal ta atojolic. Jnaꞌoj lec ti melel ti cꞌusi laj yalboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ti cꞌalal oy cꞌusi laj ataquic ta jaqꞌuel ta stojol ti Juane, ti cꞌusi laj stacꞌboxuque, jaꞌ melel. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mu persauc ta svinajesbun jcꞌoplal jun vinic. Ti jech laj calboxuc taje, jaꞌ noꞌox yoꞌ acꞌo achꞌunic ti ta xacolique. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuꞌun ti cꞌusi laj yalboxuc ti Juane coꞌol sꞌelan jun lampara ti tsanal ta xacꞌ xojobale. Jech ti voꞌoxuque jayib noꞌox cꞌacꞌal xamuyubajic xa yuꞌun ti luz taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ta sventa ti Juane jaꞌ noꞌox laj avaꞌibeicun ti jcꞌoplale. Pero ta sventa ti cabtel ti laj yacꞌbun jpas ti Jtote, jaꞌ ta xacꞌboxuc anaꞌic ti ta melel tacbilun talel yuꞌun ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Manchuc mi muꞌyuc avaꞌyiojic ti scꞌopojele, manchuc mi muꞌyuc avilojic ti stuque, pero ti Jtot ti laj stacun talele ta xalboxuc ti jcꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pero scꞌopojel ti Jtote mu xꞌoch ta avoꞌntonic. Yuꞌun mu xacꞌan xavichꞌicun ta mucꞌ ti vuꞌun tacbilun talel yuꞌun stuc ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ti voꞌoxuque ta xaqꞌuelic ta jmec ti scꞌop Diose, jaꞌ ti avalojic ti jaꞌ tey ta xataic o ti acuxlejal sbatel osile. Pero ti scꞌop Dios ti ta xaqꞌuelique jaꞌ ta xalboxuc ti jcꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero ti voꞌoxuque mu xacꞌan xanopajic talel ta jtojol yoꞌ jech ta xataic ti cuxlejal taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ti vuꞌune maꞌuc tal jsaꞌ ti lec xa aveic yilel ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jaꞌ jech xtoc yuꞌun xacojtiquinoxuc. Jnaꞌ lec ti mu xacꞌanic ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ti vuꞌune tacbilun talel yuꞌun ti Jtote. Pero ti voꞌoxuque mu xavichꞌicun ta mucꞌ. Pero mi ta xtal yan vinic ti spasoj sba ta mantal stuque, leꞌe, jaꞌ toj lec xavaꞌiic yichꞌel ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ti mi jaꞌ noꞌox ta xacꞌanic ti ichꞌel ta mucꞌ yuꞌun ti achiꞌiltaque, ti mi mu xasaꞌic ti ichꞌbiloxuc ta mucꞌ yuꞌun ti Dios stuque, ti jech taje, mu xuꞌ xavichꞌicun ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mu xanopic ti ta jticꞌboxuc amulic ta stojol ti Jtote. Ti buchꞌu ta sticꞌ amulique, jaꞌ ti Moisese, jaꞌ ti buchꞌu apatoj avoꞌntonic yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yuꞌun ti achꞌunojicuc ti cꞌusi laj stsꞌiba ti Moisese, ta xachꞌunbun jcꞌop ti jechuque. Yuꞌun jaꞌ jcꞌoplal ti laj stsꞌiba comel ti Moisese. ");
INSERT INTO tzotzc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero mi mu xacꞌan xachꞌunic ti cꞌusi laj stsiba comel ti Moisese, mi jaꞌ xa van ta xachꞌunic ti cꞌusi ta xcale ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsꞌacal to un, ti Jesuse ibat ta stiꞌil nab Galilea, ti jaꞌ onoꞌox ti nab Tiberias xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ep ti cristianoetic ti tsꞌacajtic batele, yuꞌun laj yilic ti oy smucꞌul stsatsal ti laj scoltaan ti jchameletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ti Jesuse muy batel ta vits. Tey ichotiic schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yuꞌun nopol xa scꞌan ti qꞌuin Colele, ti jaꞌ sqꞌuinic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cꞌalal ti Jesús laj yil ti ep ti cristianoetic ta xtal tsꞌacliatuque, jech laj yalbe ti Felipee: ―¿Bu chba jmanbetic talel sveꞌel scotol ti cristianoetic liꞌe? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jech laj yal ti stuque yoꞌ jech ta xvinaj cꞌu sꞌelan ta stacꞌ ti Felipee. Yuꞌun ti Jesuse snaꞌoj ti cꞌusi ta spase. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ti Felipee jech laj stacꞌbe: ―Acꞌo mi ta jmantic talel chib ciento denario taqꞌuin ti veꞌlile, mi jaꞌuc xloqꞌuic o jujutiꞌuc jujun ―xi ti Felipee. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ti Andrese, ti jaꞌ jun yajchancꞌop ti Jesuse, ti jaꞌ yitsꞌin ti Simón Pedroe, jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Liꞌ oy jun querem ti oy voꞌbej pan yichꞌoje schiꞌuc chaꞌcot choy. Pero ¿cꞌusi bal o ta xaꞌi ti jech yepal ti cristianoetique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ti Jesuse jech laj yal: ―Albeic yaꞌi ti acꞌo chotlicuc scotolic ―xi. Yuꞌun ti bu oyique yuꞌun toj lec ti yaxaltique. Jaꞌ yuꞌun un, chotiic nopol van voꞌmil viniquetic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jech ti Jesuse laj stsac ti pane. Tey laj yalbe vocol ti Diose. Tsꞌacal to un, tey laj yacꞌbe batel ti yajchancꞌoptaque. Jech ti yajchancꞌoptaque laj spuquic batel ti pane ta stojol scotolic ti cꞌu yepal tey chotolique. Jaꞌ jech xtoc laj spuquic batel ti choye. Ti buchꞌutic ta to scꞌanique acꞌbatic to. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cꞌalal noj ti schꞌutique, ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Tsobic ti scomelale yoꞌ mu jecheꞌuc noꞌox ta xꞌixtolaj ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Laj stsobic lajcheb moch schꞌuchꞌulil ti scomelal ti voꞌbej pane. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ti jech laj yilic ti cristianoetique, ti laj yacꞌ iluc smucꞌul stsatsal ti Jesuse, jech laj yalic: ―Ta melel ti vinic liꞌe jaꞌ ti jun jꞌalcꞌop ti albil onoꞌox scꞌoplal ti ta xtal liꞌ ta banomile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ti Jesuse laj yilbe yoꞌntonic ti cristianoetique ti ta persa ta scomtsanat ta ajvalil yuꞌunique. Jech o xal ti stuque laj sqꞌuej sba batel. Ibat ta jun toyol vits yoꞌ jech stuc tey ta xcom. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cꞌalal acꞌobaltic xae, jech ti yajchancꞌoptac ti Jesuse yalic batel ta nab. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jech ti stuquique tey iꞌochic batel ta jun barco yoꞌ jech ta xjelavic batel ta jot stiꞌil nab, yoꞌ jech ta xcꞌotic ta Capernaum jteclum. Cꞌalal jal xa yicꞌubele, jech ti Jesuse muꞌyuc to sutem talel ti bu oye. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jaꞌ jech xtoc un, tey lic tsots icꞌ. Xvaꞌi xcotij xa ti nabe. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ti cꞌalal xanavic xa ox batel oꞌloluc schibal revae, laj yilic ti tey ta xnopaj batel ta stsꞌel barco ti Jesuse. Ta xanav batel ta ba voꞌ ti stuque. Jech ti stuquique lic xiꞌicuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ti Jesuse jech laj yal: ―Vuꞌunun. Mu xaxiꞌic ―xut ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jech ti stuquique muꞌyuc xa xiꞌel ta xaꞌiic. Laj yiqꞌuic ochel ta barco. Jaꞌ jech xtoc ta ora noꞌox icꞌotic ti bu ta xbatic onoꞌoxe. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ta yocꞌlomal un, jech ti cristianoetic ti icomic ta jot stiꞌil nabe laj yilic ti jaꞌ tey ibatic ti yajchancꞌoptac ti Jesuse ta jcꞌot barco ti tey to ox oye. Yan ti Jesuse muꞌyuc tey schiꞌuc batel ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jaꞌ jech xtoc jaꞌ o yacal ta xcꞌot yan barcoetic ti ta jteclum Tibériase, ti bu nopol laj sveꞌic ti pane, ti bu laj yalbe vocol Dios ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Cꞌalal laj yilic ti cristianoetic ti muꞌyuc tey ti Jesús schiꞌuc ti yajchancꞌoptaque, jech o xal tey iꞌochic ta barco ti tey onoꞌox ta xcꞌote. Ibatic ta jteclum Capernaum ta saꞌel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cꞌalal icꞌotic ti stuquic ta jot nabe, tey laj staic ti Jesuse. Jech laj sjacꞌbeic xtoc: ―Jchanubtasvanej, ¿cꞌusi ora lavul liꞌe? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, ti voꞌoxuque ta xasaꞌicun yuꞌun noj lec achꞌutic ti cꞌalal laveꞌique. Yan ti jmucꞌul jtsatsal ti ta xcacꞌ iluque, jaꞌ mu tsotsuc scꞌoplal ta xavaꞌiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mu xasuj abaic ta saꞌel ti aveꞌelic ti snaꞌ xlaje. Jaꞌ aqꞌuic persa ta saꞌel ti aveꞌelic ti mu snaꞌ xlaje, ti ta xacꞌ acuxlejalic sbatel osile. Vuꞌun ta xcacꞌboxuc ti aveꞌelique, vuꞌun ti coꞌol jꞌelantique. Jech o xal laj stacun talel ti Diose, jaꞌ ti Totile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ti cristianoetique jech laj yalic: ―¿Cꞌusi ta scꞌan ta jpascutic yoꞌ jech ta xcꞌot ta pasel ti cꞌusi ta scꞌan yoꞌnton ti Dios ti ta jpascutique? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ti Jesuse jech laj stacꞌbe: ―Ti cꞌusi ta scꞌan ti Dios ti ta xapasique, jaꞌ ti ichꞌicun ta mucꞌ ti laj stacun talele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ti stuquique jech laj sjaqꞌuic: ―¿Cꞌusi señail ta xavacꞌ iluc yoꞌ ta xquilcutic yoꞌ ta jchꞌuncutic mi voꞌot ti Jcoltavanejote? ");
INSERT INTO tzotzc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yuꞌun ti jmolmucꞌtotcutic ta voꞌnee laj sveꞌic ti maná ta xocol banomile jech chac cꞌu chaꞌal ta xal ti scꞌop Diose: “Dios laj yacꞌbe pan ti liquem talel ta vinajele”, xi ti scꞌop Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti Jesuse jech laj stacꞌbe: ―Ta melel ta xcalboxuc avaꞌiic, maꞌuc Moisés laj yacꞌ ti pan ti liquem talel ta vinajele. Ti Buchꞌu ta xacꞌ talel ti pane, ti jaꞌ cuxlejal ti liquem talel ta vinajele, jaꞌ ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yuꞌun ti pan ti ta xacꞌ ti Diose, jaꞌ ti Buchꞌu yal talel ta vinajele. Yuꞌun jaꞌ ta xacꞌbe scuxlejal ti cristianoetique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jech ti stuquique jech laj yalic: ―Acꞌbuncutic o ti pan taje ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ti Jesuse jech laj stacꞌbe: ―Vuꞌunun ti pan ti ta xacꞌ cuxlejale. Ti buchꞌu ta xtal ta jtojole mu xaꞌi o viꞌnal. Ti buchꞌu ta xchꞌunune mu xaꞌi o taqui tiꞌil. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero laj onoꞌox calboxuc avaꞌiic, manchuc mi ta xavilicun, pero mu xachꞌunicun. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Scotolic ti buchꞌutic ta xiyacꞌbun ti Jtote ta xtal ta jtojol. Muꞌyuc ta jtac loqꞌuel ti buchꞌu ta xtal ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ti jech lilic talel ta vinajele, maꞌuc tal jpas ti cꞌusi ta scꞌan ti coꞌntone. Ti jech litale, jaꞌ tal jpas ti cꞌusi ta scꞌan yoꞌnton ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ti oy ta yoꞌnton ti Jtot ti laj stacun talele, jaꞌ ti mu me xchꞌayic junuc cuꞌun ti laj yacꞌbun ti Jtote. Yuꞌun vuꞌun tal jchaꞌcuxes ti ta slajebal cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ti oy ta yoꞌnton ti Buchꞌu laj stacun talele, jaꞌ ti buchꞌu ta sqꞌuelicun ti vuꞌunun Snichꞌonun ti Diose, ti ta xischꞌunicune, jaꞌ ti ta sta scuxlejalic sbatel osile, yoꞌ jech ta jchaꞌcuxes ti ta slajebal cꞌacꞌale ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cꞌalal jech laj yaꞌiic ti jꞌisraeletic ti vaꞌi sꞌelane, lic snaꞌleic ti Jesuse. Jaꞌ ti laj yalbe sba stuc ti jaꞌ pan ti liquem talel ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jech lic yalbe sbaic ti stuquique: ―Ti Jesuse liꞌe, ¿mi mu jaꞌuc snichꞌon ti Josee? Yuꞌun xcojtiquintic ti stote, ti smeꞌe. Jech o xal un, ¿cꞌu chaꞌal ta xalbe sba ti liquem talel ta vinajele? ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ti Jesuse jech laj stacꞌbe: ―Chꞌanchanic ta vulajetel schiꞌuc ti jech laj cal taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Muꞌyuc buchꞌu xuꞌ ta xtal ta jtojol ti mi maꞌuc icꞌbil talel yuꞌun ti Jtot ti laj stacun talele. Ti vuꞌune ta jchaꞌcuxes ta slajebal cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ti tsꞌibabil ta libro yuꞌun ti jꞌalcꞌopetique, jech ta xal: “Scotolic ta xchanubtasatic yuꞌun ti Diose”, ti xie. Jech o xal un, ti buchꞌutic ta xaꞌibeic scꞌopojel ti Jtote ta xchanbeic yoꞌnton. Ta xtalic ta jtojol. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Mu yuꞌunuc oy buchꞌu laj yilic ti Jtote. Ti buchꞌu yiloje, jaꞌ ti Buchꞌu liquem talel ta stojol ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Batsꞌi ta melel ta xcalboxuc avaꞌiic, ti buchꞌu ta xischꞌunune oy scuxlejal sbatel osil. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Vuꞌunun ti pan ti ta xacꞌ cuxlejale. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ti amolmucꞌtotic ta voꞌnee, ti laj sveꞌic ti maná ta xocol banomile, pero ichamic onoꞌox. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero mi oy buchꞌu ta sveꞌ ti pan ti liquem talel ta vinajele, vuꞌun ta xcal ti mu xchame. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Vuꞌunun ti cuxul pan taje ti liquem talel ta vinajele. Ti buchꞌu ta sveꞌ ti pan taje, ta xcuxi o sbatel osil. Ti pan ti vuꞌun ta xcaqꞌue, jaꞌ ti jbecꞌtal jtuque. Yuꞌun ta xcacꞌ ta cꞌabal yoꞌ jech ta sta scuxlejal scotol ti cristianoetique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jech ti jꞌisraeletique xvulajetic xa. Jech lic yalbe sbaic: ―¿Cꞌusi xut ta xijyacꞌbotic jveꞌtic ti sbecꞌtale? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, mi mu xaveꞌic ti jbecꞌtal ti coꞌol jꞌelantique, mi mu xavuchꞌbeic ti jchꞌichꞌele, muꞌyuc acuxlejalic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yan ti buchꞌu ta sveꞌbun ti jbecꞌtale, ti ta xuchꞌbun ti jchꞌichꞌele, oy scuxlejal sbatel osil. Jaꞌ jech xtoc vuꞌun ta jchaꞌcuxes ta slajebal cꞌacꞌal. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yuꞌun ti jbecꞌtale jaꞌ batsꞌi veꞌlil. Ti jchichꞌele jaꞌ batsꞌi jꞌuchꞌel. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ti buchꞌu ta sveꞌ ti jbecꞌtale, ti ta xuchꞌ ti jchꞌichꞌele, cuxul ta jtojol. Cuxulun ta stojol ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ti Totil ti Buchꞌu laj stacun talele cuxul o. Jaꞌ jechun ec, cuxulun ta sventa. Jaꞌ jech xtoc ti buchꞌu ta smalqꞌuin sba ta jtojole, jaꞌ ta xcuxi ta jventa. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ti pan ti ta xcal ti liquem talel ta vinajele, ti pan taje, mu xcoꞌolaj jech chac cꞌu chaꞌal ti maná ti laj sveꞌic ti amolmucꞌtotic ta voꞌnee, yuꞌun chamic onoꞌox. Ti buchꞌu ta sveꞌ ti pan liꞌe, ta xcuxi o sbatel osil ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ti vaꞌi sꞌelan ichanubtasvan ti Jesuse, tey ichanubtasvan ta chꞌul na ti tey ta Capernaum jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cꞌalal jech laj yaꞌiic ti chanubtasel taje, ep ti buchꞌutic stsꞌacliojic batel ti Jesús ti jech laj yalique: ―Ti vaꞌi sꞌelan ta xchanubtasvan taje, toj vocol ta chꞌunel. ¿Mi yuꞌun oy buchꞌu ta xchꞌunbat ti vaꞌi sꞌelan ta xchanubtasvane? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ti Jesuse laj yil ti xvulajetic ta labanvanej ti vaꞌi sꞌelan laj yale. Jech o xal ti stuque jech laj sjacꞌ: ―¿Mi yuꞌun ta soques avoꞌntonic taje? ");
INSERT INTO tzotzc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cꞌusi van ta xcꞌot ta avoꞌntonic ti cꞌalal ta xavilic ti ta xisut batel ti bu lilic talel ti vuꞌun coꞌol jꞌelantique? ");
INSERT INTO tzotzc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ti jꞌacꞌ-cuxlejale, jaꞌ ti Chꞌul Espíritue. Yan ti lum achꞌele, mu xacꞌ cuxlejal. Ti cꞌusi laj xa calboxuc avaꞌiique, jaꞌ melel cuxul ti jcꞌope. Jaꞌ ta xacꞌ cuxlejal. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero oy jlom avuꞌunic ti mu xachꞌunique ―xi ti Jesuse. Jaꞌ jech sꞌelan laj yal ti Jesuse, jaꞌ ti yiloj ti ta sliquebal talel ti oy buchꞌutic mu xchꞌunique. Jaꞌ jech xtoc yiloj ti buchꞌu ta xꞌacꞌvan batel ta cꞌabale. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jech laj yal ti Jesuse: ―Jech onoꞌox laj calboxuc avaꞌiic ti muꞌyuc buchꞌu ta xtal ta jtojol ti mi maꞌuc icꞌbil talel yuꞌun ti Jtot ti xacutique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ti cꞌalal jech laj yal taje, jaꞌ o tey ep lic xchacꞌ sbaic ti buchꞌutic stsꞌacliojic to ox ti Jesuse. Muꞌyuc xa laj xchiꞌinic batel. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jech o xal ti Jesuse jech laj sjacꞌbe ti lajchaꞌvoꞌ yajchancꞌoptaque: ―Ti voꞌoxuque, ¿mi ta xacꞌan ta xabatic ec? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ti Simón Pedroe jech laj stacꞌ: ―Cajval, ¿buchꞌu xa ta jtsꞌaclicutic batel? Yuꞌun ti acꞌope jaꞌ cuxlejal sbatel osil. Ti cꞌusi ta xavale jaꞌ melel. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ti vuꞌuncutique laj xa jchꞌunotcutic. Jaꞌ jech xtoc jnaꞌcutic ti voꞌot ti Cristoote, Snichꞌonot ti cuxul Diose ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ti Jesuse jech itacꞌav: ―¿Mi mu laj jtꞌujoxuc ti lajchaꞌvoꞌoxuque? Manchuc mi jaꞌ jech laj jpas, oy jun avuꞌunic ti jaꞌ pucuje ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ati vaꞌi sꞌelan laj yal ti Jesuse, jaꞌ ta xalbe scꞌoplal ti Judas Iscariotee, ti jaꞌ snichꞌon ti Simone. Yuꞌun ti Judase jaꞌ ta xꞌacꞌvan batel ta cꞌabal manchuc mi jaꞌ jun ta slajchaꞌvoꞌal ti yajchancꞌoptac ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cꞌalal jech laj yoꞌnton taje, ti Jesuse lic xanavuc tey ta yosilal Galilea. Yuꞌun mu scꞌan ti tey oy o ta Judeae. Yuꞌun ta scꞌan ta xmilat yuꞌun ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nopol xa scꞌan sqꞌuinal ti axibal nae, ti jaꞌ jun qꞌuin yuꞌunic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ti yitsꞌinabtaque jech laj yalic: ―Mu liꞌuc noꞌox xacome. Batan ta Judea yoꞌ jech ta xayilic ti avajtsꞌaclivanejtaque ti oy cꞌusi xuꞌ avuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yuꞌun ti mi ta jcꞌantic ti ta xcacꞌ jbatic ta ojtiquinele, mu ta muculuc ta jpastic cꞌusi ta scꞌan pasele. Yuꞌun ti cꞌusi ta xapas liꞌe, ba acꞌo ta ilel ta sba ta sat scotol ti cristianoetic teye ―xutic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ti jech laj yalic ti yitsꞌinabe, yuꞌun mu xichꞌic ta mucꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ti Jesuse jech laj stacꞌbe: ―Yuꞌun mu to ta xcꞌot yorail cuꞌun. Ti voꞌoxuque cꞌusuc noꞌox ora xuꞌ xabatic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yuꞌun ti buchꞌutic coꞌol avoꞌntonic schiꞌuque, muꞌyuc xtiꞌet sjolic ta atojolic. Yan ti vuꞌune ta xiscrontainicun, jaꞌ ti jamal ta xcalbe yaꞌiic ti cꞌusi chopol ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ti voꞌoxuque batanic ta qꞌuin. Ti vuꞌune mu xibat. Yuꞌun mu to sta yorail ta xcꞌot ti coraile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cꞌalal jech laj yal taje, tey icom ta Galilea. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cꞌalal jech batemic xa ta qꞌuin ti yitsꞌinabe, jech ti Jesuse ibat ec. Pero mucultic ibat, yuꞌun mu scꞌan xacꞌ sba iluc. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ti jꞌisraeletique jech ta xalic ti ta saꞌvanic ta qꞌuine: ―¿Bu oy xanaꞌ ti vinique? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ti ta scotol ti cristianoetic teye ta xalbeic scꞌoplal ti Jesuse. Ti jlome ta xalic ti jaꞌ jun lequil vinique. Ti jlome ta xalic ti jaꞌ jun chopol vinique. Yuꞌun ta sloꞌlaan ti cristianoetique, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mi jaꞌuc oy buchꞌu jamal ta xalbe scꞌoplal ti Jesuse, yuꞌun ta xiꞌic yuꞌun ti jchapanvanej jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cꞌalal oꞌlol xa ox batel ti qꞌuine, och batel ta templo ti Jesuse. Tey lic chanubtasvanuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jech xtoc ti jꞌisraeletique chꞌayal icꞌot yoꞌntonic ti jech laj yalique: ―¿Cꞌusi xut ep sbijil ti vinic leꞌe ti cꞌalal muꞌyuc yichꞌoj chanubtasele? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ti Jesuse jech laj stacꞌ: ―Maꞌuc jbijil jtuc ti jech ta xichanubtasvane. Yuꞌun jaꞌ yacꞌojbun ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mi oy buchꞌu sjunul yoꞌnton ta scꞌan ta spas ti cꞌusi ta scꞌan ti Diose, tey ta xlic yil mi liquem talel ta stojol ti Diose, o mi jaꞌ noꞌox ta jnop jtuc ti cꞌu sꞌelan ta xichanubtasvane. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Buchꞌuuc noꞌox ti jaꞌ noꞌox ta snop stuc ti cꞌusi ta xale, yuꞌun jaꞌ noꞌox ta scꞌan ichꞌel ta mucꞌ yuꞌun ti cristianoetique. Yan ti Buchꞌu ta xacꞌ persa ti jaꞌ ichꞌbil ta mucꞌ ta xcꞌot yuꞌun ti Buchꞌu itacat talele, leꞌe, jaꞌ melel ti cꞌusi ta xale. Maꞌuc jloꞌlavanej. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Mi mu jaꞌuc Moisés laj yacꞌ avichꞌic ti mantale? Manchuc mi jech avichꞌojic, pero muꞌyuc buchꞌu junucal xchꞌun avuꞌunic ti mantal taje. Yuꞌun ta xacꞌan ta xamilicun avaꞌiic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ti cristianoetique jech laj yalic: ―Ti voꞌote achꞌulelinojbe schꞌulel pucuj. ¿Buchꞌu ta scꞌan ta smilot yaꞌi? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ti Jesuse jech laj yal: ―Ti cꞌusi laj jpas avilic ta scꞌacꞌalil cuxob oꞌntonale, acotolic chꞌayal avoꞌntonic yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ti Moisese laj yacꞌboxuc mantal yuꞌun ti circuncisione. Pero maꞌuc laj sliques stuc. Yuꞌun jaꞌ laj sliques ti amolmucꞌtotic ta voꞌnee. Pero ti voꞌoxuque ta xayacꞌbeic yichꞌ circuncisión jun biqꞌuit querem manchuc mi ta scꞌacꞌalil ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jaꞌ yuꞌun un, yoꞌ jech mu xata amulic yuꞌun smantal ti Moisese, jech o xal ti voꞌoxuque ta xavacꞌbeic yichꞌ circuncisión ti biqꞌuit quereme manchuc mi jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale. ¿Cꞌu chaꞌal xtiꞌet ajolic ta jtojol ti jech laj jcolesbe schamel sjunul sbecꞌtal ti vinique ti jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale? ");
INSERT INTO tzotzc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ti cꞌalal ta xachapanvanique, nopic lec ti cꞌusi ta xavalique. Mu xaticꞌbe smul ta ora noꞌox ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ti buchꞌutic tey nacalic ta Jerusalene, oy jlom ti jech lic sjacꞌbe sbaique: ―¿Mi mu jaꞌuc ti vinic leꞌe ti ta saꞌic yoꞌ ta smilique? ");
INSERT INTO tzotzc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Qꞌuel avil, chꞌan xutic ti tey vaꞌal ta xchanubtas ti cristianoetique. ¿Mi yuꞌun ta xchꞌunic xanaꞌ ti jꞌabteletic eque ti jaꞌ Cristo ti vinic leꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero ti voꞌotique jnaꞌojtic lec ti bu liquem talele. Yan ti cꞌalal ta xtal ti Cristoe, muꞌyuc buchꞌu snaꞌ bu ta xlic talel ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Cꞌalal jech laj yaꞌi ti Jesús taje, ti tey ta xchanubtasvan ta temploe, jech tsots lic yal: ―Ati xcaltic un chaꞌe xavojtiquinicun, xanaꞌic bu liquemun talel. Pero mu talemucun ta jmantal jtuc. Yuꞌun jaꞌ tacbilun talel yuꞌun ti Buchꞌu lec yoꞌntone, ti voꞌoxuc mu xavojtiquinique. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ti vuꞌune xcojtiquin ti Buchꞌu laj stacun talele. Yuꞌun tey liquemun talel ta stojol ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ti cꞌalal jech laj yaꞌiique, ta scꞌan stsaquic ox yaꞌiic ta chuquel. Pero muꞌyuc buchꞌu junucal itsac yuꞌunic. Yuꞌun mu to ta xcꞌot yorail ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero oy ep ti buchꞌutic laj xchꞌunic ti jaꞌ Cristo ti Jesuse. Jech o xal jech laj yalic: ―Cꞌalal mi tal ti Cristoe, ¿mi yuꞌun van jaꞌ más to ta xacꞌ ta ilel ti smucꞌul stsatsale, mi jaꞌ mu sta ta spas ti vinic leꞌe? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ti jfariseoetique laj yaꞌiic ti cꞌu sꞌelan ta xalic ti cristianoetic scꞌoplal ti Jesuse. Jech ti stuquique schiꞌuc ti banquilal paleetique laj staquic batel mayoletic yuꞌun ti temploe yoꞌ ta stsaquic ta chuquel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ti Jesuse jech laj yal: ―Mu xa jaluc liꞌ oyun ta atojolique. Yuꞌun ta xisut batel ta stojol ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jech ti voꞌoxuque ta xlic asaꞌicun. Pero mu xataicun. Yuꞌun mu xuꞌ ta xacꞌotic tey ti bu xicꞌote ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jech ti jꞌisraeletique jech lic sjacꞌbe sbaic ta jujun tal: ―¿Bu ta xbat yaꞌyeluc ti ta xal ti mu xuꞌ ta jtatic ta saꞌele? ¿Mi yuꞌun van ta xbat ta stojol ti jꞌisraeletic ti tanijemic ta naclej schiꞌuc ti jyanlum cristianoetique, yoꞌ jech chbat xchanubtas ti jyanlum cristianoetique? ");
INSERT INTO tzotzc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Cꞌusi smelol ta xal ti jech laj yalbotique: “Ta xasaꞌicun, pero mu xataicun. yuꞌun ti bu ta xibate, mu xuꞌ ta xacꞌotic tey”, ti xie? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ti slajeb cꞌop qꞌuin ti jaꞌ tsots scꞌoplal yuꞌunique, ti Jesuse jaꞌ o tey lic svaꞌan sba. Tey lic tsots cꞌopojuc ti jech laj yale: ―Mi oy buchꞌu ta xaꞌi taqui tiꞌile, acꞌo taluc ta jtojol, acꞌo yuchꞌ ti voꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Ti yoꞌntonic ti buchꞌutic ta xischꞌunune coꞌol sꞌelan cuxul sat voꞌ ti yoꞌntonique”, xi ta xal ti scꞌop Diose ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ti vaꞌi sꞌelan laj yal ti Jesuse, jaꞌ ta xacꞌ ta naꞌel ti ta xichꞌic ti Chꞌul Espíritu ti buchꞌutic ta xchꞌunique. Yuꞌun muꞌyuc to talem ti Chꞌul Espíritue. Yuꞌun ti Jesuse muꞌyuc to sutem batel ta vinajel ta yichꞌel ti slequilale, ti yutsilale. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cꞌalal jech laj yaꞌiic ti jlom cristianoetic taje, jech laj yalic: ―Melel, ti vinic liꞌe jaꞌ ti jꞌalcꞌop ti ta onoꞌox xtale ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ti yane jech laj yalic: ―Jaꞌ ti Cristoe ―xiic. Pero ti yan xtoque jech laj yalic: ―¡Bu xata ti ta Galilea ta xlic talel ti Cristoe! ");
INSERT INTO tzotzc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ti Cristoe yuꞌun ta xlic talel ta snitilul ti ajvalil Davide. Tey ta jteclum Belén ti ta slumal stuc ti Davide, xi ta xal ti scꞌop Diose ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jech o xal ti cristianoetique chaꞌchꞌac icꞌot yoꞌntonic yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Oy jlom ta ox stsaquic yaꞌiic ta chuquel, pero muꞌyuc vuꞌ yuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ti mayoletic yuꞌun ti temploe isutic batel yoꞌ bu oy ti jfariseoetique schiꞌuc ti banquilal paleetique. Ti stuquique jech laj sjaqꞌuic: ―¿Cꞌu chaꞌal ti mu laj atsaquic talele? ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ti mayoletique jech itacꞌavic: ―Yuꞌun muꞌyuc buchꞌu jech jun vinic ta xcꞌopoj jech chac cꞌu chaꞌal ti vinic leꞌe ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ti jfariseoetique jech laj yalic: ―¿Mi yuꞌun laj avacꞌ abaic ta loꞌlael ec? ");
INSERT INTO tzotzc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Mi yuꞌun xavacꞌtouc ti oy buchꞌu laj xa xchꞌun ti banquilal cuꞌuntique schiꞌuc ti jfariseoetique? ");
INSERT INTO tzotzc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero ti cristianoetic ti mu xojtiquinic ti mantale, chopol ta xꞌilatic yuꞌun ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ti Nicodemoe, jaꞌ ti buchꞌu ay sqꞌuel ta acꞌobaltic ti Jesuse, jaꞌ jun jfariseo ec. Jech o xal jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Mu xuꞌ jsaꞌbetic smul jun vinic ti mi muꞌyuc to caꞌbinojtic lec ti cꞌusi laj xa spase, xi ti mantal cuꞌuntique ―xi ti Nicodemoe. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ti stuquique jech lic staqꞌuic: ―¿Mi yuꞌun jgalilea vinicot ec? Qꞌuelo lec ti scꞌop Diose. Tey ta xavil ti mu xlocꞌ talel jun jꞌalcꞌop ta Galileae ―xꞌutat ti Nicodemoe. ");
INSERT INTO tzotzc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tsꞌacal to un, ta jujun tal ibat ta snaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ti Jesuse ibat ta vits Olivos. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cꞌalal isacub ta yocꞌlomale, isut batel ta templo. Jaꞌ o tey lic stsob sbaic talel ti cristianoetic ta stojole. Tey ichoti lic chanubtasvanuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ti jchanubtasvanejetic yuꞌun ti mantale schiꞌuc ti jfariseoetique tey yicꞌojic talel jun ants ti yacal ta xmulivaj laj staique. Tey laj svaꞌanic ta oꞌlol. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jech laj yalbeic ti Jesuse: ―Jchanubtasvanej, ti ants liꞌe yacal ta xmulivaj laj staic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti buchꞌu jech ants jech chac cꞌu chaꞌal liꞌe, ta xalbotic ta smantal ti Moisese ti acꞌo yichꞌ milel ta tone. Ti voꞌote, ¿cꞌusi ta xaval? ―xutic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ti jech laj yalic taje, yuꞌun ta slajeltsabe yoꞌnton yoꞌ jech ta stabeic smul ti Jesuse. Ti Jesuse cuji. Lic stsꞌiba ti banomil ta sniꞌ scꞌobe. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ti jech tey xvulajetic ta sjaqꞌuele, jech ti Jesuse tey ivaꞌi. Jech laj yal: ―Buchꞌuuc noꞌox junucal avuꞌunic ti mu snaꞌ saꞌ smule, jaꞌ acꞌo syales baꞌyel ti ton ta stojol ti antse ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jech xtoc lic chaꞌcujiuc ta stsꞌibael ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cꞌalal jech laj yaꞌiic ti stuquique, lic yaꞌiic ta yoꞌntonic ti oy smulique. Jech o xal un, ta jujun tal iloqꞌic batel. Jaꞌ baꞌyel iloqꞌuic batel ti moletique. Cꞌalal jech loqꞌuemic xa batel scotolique, stuc xa icomtsanatic ti antse schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ti Jesuse tey ivaꞌi. Laj yil ti muꞌyuc xa buchꞌu tey oye, ti jaꞌ xa noꞌox stuc ti antse. Jech laj yalbe ti antse: ―Ants, ¿bu ibat ti buchꞌutic ta saꞌ amule? ¿Mi mu junuc buchꞌu laj yacꞌ atoj ti amule? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ti antse jech itacꞌav: ―Muꞌyuc chquil, Cajval ―xi. Ti Jesuse jech laj yal: ―Mi jaꞌuc ti vuꞌun ta xcacꞌ atoj ti amul eque. Avi liꞌe batan. Mu xa me xasaꞌ amul yan velta ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ti Jesuse jech icꞌopoj yan velta ta stojol ti cristianoetique: ―Vuꞌun luzun yuꞌun ti cristianoetique. Ti buchꞌu ta xistsꞌaclie, oy luz yuꞌun ti jaꞌ ta xꞌacꞌbat ti scuxlejale. Mi jaꞌuc ta xanav ta icꞌal osil ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ti jfariseoetique jech laj yalic: ―Ti voꞌote jaꞌ noꞌox ta xavalbe aba acꞌoplal atuc. Ti jech ta xaval taje, muꞌyuc cꞌusi bal o ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ti Jesuse jech itacꞌav: ―Ti ta xcalbe jba jcꞌoplal jtuque, yuꞌun jaꞌ melel. Yuꞌun jnaꞌ bu lital, bu ta xibat xtoc. Ti voꞌoxuque mu xanaꞌic bu talemun, bu ta xibat. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ti voꞌoxuque atalelic noꞌox atuquic ti ta xachapanvanique. Yan ti vuꞌune muꞌyuc buchꞌu ta jsaꞌbe smul. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ti mi ta xichapanvane, ta yutsil coꞌnton. Yuꞌun mu jtucuc noꞌox ti jech ta xichapanvane. Yuꞌun tacbilun talel yuꞌun ti Jtote, jaꞌ ti ta xischiꞌin ta xchapanele. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ti mi oy chib rextigo ti coꞌol scꞌopique, chꞌunbeic, xi ti mantal avuꞌunic ti tsꞌibabile. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lec oy chaꞌe, ti vuꞌune rextigoun jtuc. Ti yan rextigo xtoque jaꞌ ti Jtot ti laj stacun talele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jech ti stuquique jech laj staqꞌuic: ―¿Bu oy ti atote? ―xutic. Ti Jesuse jech laj stacꞌ: ―Ti voꞌoxuque mu xavojtiquinicun. Mi jaꞌuc xavojtiquinic ti Jtot xtoque. Ti yuꞌunuc xavojtiquinicune, xavojtiquinic ti Jtot ti jechuque ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jaꞌ jech laj yal ti Jesuse cꞌalal ta xchanubtasvan ta templo ti bu oy scaxail smoton ti Diose. Pero muꞌyuc buchꞌu itsacvanic ta chuquel, yuꞌun mu to ta xcꞌot ti yoraile. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ti Jesuse jech lic xchaꞌal: ―Ti vuꞌune ta xibat. Ti voꞌoxuque ta xasaꞌicun. ¡Cꞌu stu un! tey acuchoj amul ta xachamic. Yuꞌun ti bu ta xibate, mu xuꞌ xacꞌotic tey ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ti jꞌisraeletique jech laj yalic: ―Ti vaꞌi sꞌelan ta xal ti mu xacꞌotic tey ti bu ta xibate, ti xie, ¿mi yuꞌun ta smil sba yaꞌyel? ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ti Jesuse jech laj yalbe: ―Ti voꞌoxuque liꞌ noꞌox ayanemoxuc liꞌ ta sba banomile. Yan ti vuꞌune liquemun talel ta vinajel. Ti voꞌoxuque sba banomil oyoxuc. Pero ti vuꞌune maꞌuc liꞌ liquemun ta sba banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jech o xal laj calboxuc avaꞌiic ti acuchoj amulic xacham xalajique, yuꞌun ti mi mu xachꞌunic ti Buchꞌuun ta melele, jech acuchoj amulic xacham xalajic, ti xacutoxuque ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jech ti stuquique jech laj sjacꞌbeic: ―¿Buchꞌuot un chaꞌe? ―xutic. Ti Jesuse jech laj stacꞌ: ―Laj xa calboxuc avaꞌiic ta sliquebal. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Oy ep ti cꞌusi xuꞌ ta xcalboxuc ti ta jchapanoxuque. Pero ti Buchꞌu laj stacun talele, jaꞌ melel ti stuque. Jech o xal un, ta xcalboxuc avaꞌiic ti cꞌusi laj caꞌi ta stojole ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jech ti stuquique muꞌyuc laj yaꞌiic ti jaꞌ ta xalbe scꞌoplal ti Stote. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ti Jesuse jech laj yal: ―Cꞌalal ti voꞌoxuc ta xajipanicun ta cruz ti vuꞌun ti coꞌol jꞌelantique, jaꞌ to tey ta xavojtiquinicun ti Buchꞌuun ta melele. Yuꞌun scotol ti cꞌusi ta xcale, maꞌuc ta jmantal jtuc. Yuꞌun jaꞌ noꞌox ta xcal ti cꞌu sꞌelan lichanubtasat yuꞌun ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yuꞌun ti Buchꞌu laj stacun talele liꞌ xchiꞌinojune. Yuꞌun muꞌyuc yictaojun comel jtuc ti Jtote. Yuꞌun ti vuꞌune jaꞌ ta jpas ti cꞌusi lec ta xile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ti cꞌalal jech laj yal ti Jesús taje, ep laj xchꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ti Jesuse jech laj yalbe ti jꞌisraeletic ti buchꞌutic laj xchꞌunique: ―Ti voꞌoxuque ti mi staoj o yav avoꞌntonic ta xachꞌunic ti cꞌusi laj calboxuque, jaꞌ cajchancꞌopoxuc ta melel. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jaꞌ jech xtoc umbi, ta xlic avojtiquinic ti melele. Ti melele jaꞌ ta scoltaoxuc loqꞌuel ta mosovil ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ti stuquique jech laj staqꞌuic: ―Muꞌyuc quilojcutic mosovinel. Yuꞌun ti vuꞌuncutique snitiluluncutic ti Abrahame. ¿Cꞌu chaꞌal ta xaval ti ta jtacutic coltaele? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, scotol ti buchꞌu ta saꞌ smulique, jaꞌ mosovinbilic yuꞌun ti mulile. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ti jun mosovile mu xcom o ta sna ti yajvale. Yan ti mero nichꞌonile ta xcom o ta sna ti stote. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jech o xal un, ti mi ta jcoltaoxuc ti vuꞌun Nichꞌonilune, jech ti voꞌoxuque muꞌyuc xa mosovinbiloxuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jnaꞌ lec ti voꞌoxuque ti jaꞌ snitiluloxuc ti Abrahame. Pero mu xacꞌan xachꞌunic ti cꞌusi ta xcale. Ta xamilicun avaꞌiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ti vuꞌune jaꞌ ta xcal ti cꞌusi laj yacꞌbun quil ti Jtote. Ti voꞌoxuque jaꞌ ta xapasic ti cꞌusi ta xaꞌalbatic yuꞌun ti atotique ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ti stuquique jech itacꞌavic: ―Ti jtotcutique jaꞌ ti Abrahame ―xiic. Pero ti Jesuse jech laj yalbe: ―Ti meleluc ti jaꞌuc snichꞌnaboxuc ti Abrahame, ta xapasic jech chac cꞌu chaꞌal laj spas ti stuc jechuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Manchuc mi ta xcalboxuc avaꞌiic ti melel ti chanubtasbilun yuꞌun ti Diose, ti voꞌoxuque ta xamilicun avaꞌiic. Yan ti Abrahame muꞌyuc laj spas jech chac cꞌu chaꞌal ti ta xapasique. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ti voꞌoxuque jaꞌ jech ta xapasic jech chac cꞌu chaꞌal ta spas ti atotique ―xi ti Jesuse. Ti stuquique jech laj yalic: ―Ti vuꞌuncutique maꞌuc tsobbilal ololuncutic. Yuꞌun oy jun jtotcutic, jaꞌ ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ti Jesuse jech laj yal: ―Ti ta meleluc ti jaꞌuc Atotic ti Diose, lec xavilicun ti jechuque. Yuꞌun liquemun talel ta stojol ti Diose ti jech liꞌ oyune. Mu yuꞌunuc talemun ta jmantal jtuc. Yuꞌun jaꞌ tacbilun talel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Cꞌu chaꞌal ti mu xavaꞌiic ti cꞌusi ta xcale? Yuꞌun mu xacꞌan xavaꞌiic ti jcꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ti atotique jaꞌ ti pucuje. Yuꞌun jaꞌ yuꞌunoxuc. Jech o xal ta xapasic ti cꞌusi ta scꞌan ti stuque. Ti pucuje ta sliquebal onoꞌox talel ti jaꞌ jmilvaneje. Mu scꞌan scoꞌoltas sba schiꞌuc ti melele. Jech o xal un, mi jaꞌuc juteb ta xal ti melele. Ti buchꞌu ta sjut ti cꞌope coꞌol sꞌelan jech chac cꞌu chaꞌal ti stuque. Yuꞌun jaꞌ jutcꞌop onoꞌox. Yuꞌun jaꞌ totil jutcꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ti jech ta xcalboxuc ti melele, jech o xal mu xacꞌan xachꞌunicun. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Buchꞌu junucal avuꞌunic ti xuꞌ ta xacꞌ ta ilel ti oy jmule? Ti mi melel ti cꞌusi ta xcalboxuque, ¿cꞌu chaꞌal mu xacꞌan xachꞌunic? ");
INSERT INTO tzotzc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ti buchꞌutic jaꞌ snichꞌnabtac ti Diose ta xchꞌunbeic ti scꞌope. Yan ti voꞌoxuque maꞌuc snichꞌnaboxuc ti Diose. Jech o xal mu xacꞌan xachꞌunbeic ti scꞌope ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ti jꞌisraeletique jech laj yalic: ―Oy smelol ti jech ta xcalcutic ti jaꞌ jun jsamaria vinicote, ti achꞌulelinojbe schꞌulel ti pucuje ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ti Jesuse jech laj stacꞌ: ―Maꞌuc quichꞌojbe schꞌulel ti pucuje. Ti cꞌusi ta jpase, jaꞌ yichꞌel ta mucꞌ ti Jtote. Pero ti voꞌoxuque maꞌuc ta xavaqꞌuicun ta ichꞌel ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ti vuꞌune maꞌuc oy ta coꞌnton ti lec jcꞌoplal avuꞌunique. Pero oy Buchꞌu ta xiyacꞌun ta ichꞌel ta mucꞌ, jaꞌ ti Buchꞌu ta xchapan scotole. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ta melel ta xcalboxuc avaꞌiic, ti buchꞌu ta xichꞌ ta mucꞌ ti cꞌusi ta xcale, mi jaꞌuc ta xcham o ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ti jꞌisraeletique jech laj staqꞌuic: ―Ta melel onoꞌox ti achꞌulelinojbe schꞌulel ti pucuje. Yuꞌun ti Abrahame, scotol ti jꞌalcꞌopetique ichamic. Pero ti voꞌote ta xaval: “Ti buchꞌu ta xichꞌ ta mucꞌ ti cꞌusi ta xcale, mu xcham o”, xachi. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mi voꞌot toj echꞌem xuꞌ avuꞌun latal? ¿Mi jaꞌ mu sta ti jtotic Abrahame? Ti stuque icham. Ti jꞌalcꞌopetique ichamic xtoc. ¿Buchꞌuot ta xabis aba? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ti Jesuse jech laj stacꞌbe: ―Yan ti mi jaꞌ noꞌox ta xcacꞌ jba ta ichꞌel ta mucꞌ jtuque, muꞌyuc cꞌusi bal o. Yuꞌun ti Buchꞌu ta xiyacꞌun ta ichꞌel ta muqꞌue, jaꞌ ti Jtote, ti jaꞌ Dios avuꞌunic ta xavalique. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ti voꞌoxuque mu xavojtiquinic. Yan ti vuꞌune xcojtiquin. Yan ti mi ta xcal ti mu xcojtiquin ti Diose, jutcꞌopun ta jꞌechꞌel jech chac cꞌu chaꞌal ti voꞌoxuque. Ta melel ti vuꞌune xcojtiquin. Jech o xal ta jchꞌun ti cꞌusi ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ti Abrahame, ti jaꞌ amolmucꞌtotic ta voꞌnee, xmuyubaj xa yoꞌnton ti laj yaꞌi ti ta xitale. Laj yil ti litale. Jech o xal xmuyubaj xa yoꞌnton ta jmec ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ti jꞌisraeletique jech laj yalbeic ti Jesuse: ―Ti voꞌote muꞌyuc to avichꞌoj lajuneb yoxvinic (50) jabil. ¿Cꞌusi laj avut ti laj avil ti Abrahame? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ti Jesuse jech laj stacꞌ: ―Ta melel ta xcalboxuc avaꞌiic, ti cꞌalal muꞌyuc to ox voqꞌuem ti Abrahame, tey xa onoꞌox oyun ti vuꞌune ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jech ti stuquique laj stsaquic ton yoꞌ ta xacꞌbeic ti Jesuse. Pero ti stuque laj sqꞌuej sba. Ilocꞌ batel ta templo. Tey iꞌechꞌ batel ta oꞌlol yuꞌunic. Ibat. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cꞌalal jech ta xanav batel ti Jesuse, tey laj yil jun vinic ti maꞌsat onoꞌox voqꞌueme. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ti yajchancꞌoptaque jech laj sjacꞌbeic: ―Jchanubtasvanej, ¿cꞌu chaꞌal ti maꞌsat ivocꞌ ti vinic liꞌe? ¿Mi yuꞌun jaꞌ ta scoj smul ti stot smeꞌe, mi ta scoj smul stuc? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ti Jesuse jech laj yal: ―Maꞌuc ta scoj stuc. Mi jaꞌuc ta scoj smul ti stot smeꞌe. Ti jech maꞌsat ivoqꞌue, yoꞌ jech acꞌo vinajuc yabtel ti Dios ta stojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yoꞌ to sac ti osile, ta scꞌan ta jpasbe yabtel ti Buchꞌu laj stacun talele. Yuꞌun ta xa xtal ti acꞌobaltique cꞌalal muꞌyuc xa buchꞌu xuꞌ ta xꞌabteje. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ti jech liꞌ to oyun ta sba banomile, vuꞌunun ti saquilal osil yuꞌunic ti cristianoetique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cꞌalal jech laj yal ti Jesuse, laj stubta ti banomile. Laj spas juteb achꞌel ta stub. Laj sbonbe ta sat ti maꞌsate. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tsꞌacal to un, jech laj yal ti Jesuse: ―Batan, ba poco ti asat ti ta sat voꞌ ti Siloé sbie ―xi. (Ti smelol ti Siloee jaꞌ tacbil.) Jech ti maꞌsate ba spoc ti sate. Cꞌalal isut talele, lec xa xil ti osile. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jech laj yalic ti slacꞌnataque schiꞌuc ti buchꞌutic ti yilojic onoꞌox ti maꞌsate: ―¿Mi mu jaꞌuc ti vinic leꞌe ti xchotet ta scꞌan limuxnae? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oy jlom ta xalic: ―Jaꞌ ―xiic. Ti yan xtoque jech ta xalic: ―Maꞌuc. Jaꞌ noꞌox ti xcoꞌolaje ―xiic. Pero ti vinique: ―Vuꞌunun ―xi stuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jech laj sjacꞌbeic: ―¿Cꞌusi laj avut ti ta xavil xae? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ti stuque jech laj stacꞌ: ―Ti vinic ti jaꞌ sbi Jesuse laj spas achꞌel. Laj sbonbun ta jsat. “Batan ta sat voꞌ ti Siloé sbie. Tey xapoc ti asate”, xiyutun. Libat ec un. Cꞌalal jech laj jpoc ti jsate, laj quil ti saquilal osile ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ti vinique jech ijacꞌbat: ―¿Bu oy ti vinic taje? ―xutic. Ti stuque jech laj yal: ―Mu jnaꞌ ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ti maꞌsat to oxe icꞌbil ibat ta stojol ti jfariseoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ti jech laj spas achꞌel ti laj scolta maꞌsat ti Jesuse, jaꞌ o ta scꞌacꞌalil ti cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ti jfariseoetique laj xchaꞌjacꞌbeic ti maꞌsat to oxe ti cꞌusi laj yut ti xil xa ti osile. Ti stuque jech laj yal: ―Laj sbonbun achꞌel ta jsat. Tsꞌacal to laj jpoc. Avi tana un, ta xquil ti osile ―xi ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oy jlom jfariseoetique jech laj yalic: ―Ti vinic ti jech laj spas taje maꞌuc tacbil talel yuꞌun ti Diose. Yuꞌun mu xchabi ti scꞌacꞌalil ti cuxob oꞌntonale ―xiic. Pero ti yan xtoque jech ta xalic: ―¿Cꞌusi xut ta xacꞌ ta ilel smucꞌul stsatsal ti mi jaꞌ jun jsaꞌmulile? ―xiic. Jech o xal un, ti stuquique chaꞌchꞌac yoꞌnton icꞌotic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jech lic xchaꞌjacꞌbeic ti maꞌsat to oxe: ―Ti voꞌote ¿cꞌusi vinical ta xaval ti laj sjambot ti asate? ―xutic. Ti stuque jech laj yal: ―Ti vuꞌun ta xcale jaꞌ jun jꞌalcꞌop ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ti jꞌisraeletique mu scꞌan xchꞌunic ti jaꞌ maꞌsat to ox ti ta xil ti osile. Jech o xal laj staquic ta iqꞌuel stot smeꞌ ti maꞌsat to oxe. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ti stuquique jech laj sjacꞌbeic: ―¿Mi jaꞌ anichꞌon liꞌe ti ta xavalic ti maꞌsat ivoqꞌue? ¿Cꞌu chaꞌal ti jech ta xil xa osil avi tana une? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ti stot smeꞌe jech laj staqꞌuic: ―Jnaꞌcutic ti jaꞌ jqueremcutique, ti maꞌsat ivoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero ti jech ta xil xa ti osile, leꞌe, mu jnaꞌcutic. Jaꞌ jech xtoc mi jaꞌuc jnaꞌcutic ti buchꞌu ijambun ti sate. Jacꞌbeic avaꞌiic stuc. Yuꞌun julem xa schꞌulel. Xuꞌ ta xayalbot avaꞌiic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jaꞌ jech laj yal ti stot smeꞌe, jaꞌ ti ta xiꞌic yuꞌun ti jꞌisraeletique. Yuꞌun laj xa scomonop scꞌopic, buchꞌuuc noꞌox ti ta xal ti jaꞌ Cristo ti Jesuse, ta xtenat loqꞌuel ta chꞌul na yuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jech o xal: “Jacꞌbeic avaꞌiic ti jqueremcutique, julem xa schꞌulel”, ti xiique. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jech o xal ti jꞌisraeletique laj xchaꞌtaic ta iqꞌuel ti vinic ti maꞌsat to oxe. Jech laj yalbeic: ―Albun caꞌicutic ta melel ta sba ta sat ti Diose. Yuꞌun ti vinic taje jnaꞌcutic ti jaꞌ jun jsaꞌmulile ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ti stuque jech laj stacꞌ: ―Mu jnaꞌ mi jaꞌ jun jsaꞌmulil, mi maꞌuc. Ti cꞌusi jnaꞌ leque, jaꞌ ti maꞌsatun to oxe. Avi tana un, ta xquil xa ti saquilal osile ―xi ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ti stuquique jech lic xchaꞌjacꞌbeic: ―¿Cꞌu sꞌelan laj spas? ¿Cꞌusi laj yut ti laj sjam ti asate? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ti vinique jech laj stacꞌbe: ―Laj xa calboxuc avaꞌiic. Pero mu xacꞌan xachꞌunbeicun. ¿Cꞌu chaꞌal ti ep ta velta ta xacꞌan ti ta xcalboxuque? ¿Mi yuꞌun ta xacꞌan ta xatsꞌacli avaꞌiic ec? ―xi ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ti stuquique jech xjajet xa laj yalic: ―Ti voꞌote tsꞌaclio ti vinic taje. Yan ti vuꞌuncutique jaꞌ ta jtsꞌaclicutic ti Moisese. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yuꞌun jnaꞌojcutic ti icꞌoponat yuꞌun Dios ti Moisese. Pero ti vinic taje mi jaꞌuc jnaꞌcutic ti bu liquem talele ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ti vinique jech laj stacꞌ: ―Toj labal ta xcaꞌi avuꞌunic ti mu xanaꞌic ti bu liquem talele ti cꞌalal jaꞌ laj sjambun ti jsate. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jnaꞌtic lec, ti Diose mu xaꞌibe scꞌop ti jsaꞌmuliletique. Yuꞌun jaꞌ noꞌox ta xaꞌibe scꞌop ti buchꞌutic ta xichꞌic ta muqꞌue, ti ta spasic ti cꞌusi ta scꞌan ti yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yuꞌun muꞌyuc xcaꞌibetic o scꞌoplal ti ta sjambe sat jun vinic ti maꞌsat voqꞌueme. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti maꞌucuc tacbil talel yuꞌun Dios ti vinic taje, muꞌyuc cꞌusi xuꞌ yuꞌun ta spas ti jechuque ―xi ti maꞌsat to oxe. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ti stuquique jech laj yalic: ―Yuꞌun jsaꞌmulilot onoꞌox lavocꞌ talel ti voꞌote. ¿Mi voꞌot cajal ta xacꞌan ta xachanubtasuncutic avaꞌi? ―xutic. Tey laj sjipic loqꞌuel ta chꞌul na. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ti Jesuse laj yaꞌi ti jipbil xa loqꞌuel ta chꞌul na ti maꞌsat to oxe. Cꞌalal laj snup sbaic ta bee, jech laj yalbe: ―¿Mi ta xachꞌun ti Snichꞌon ti Diose? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ti vinique jech laj yal: ―Albun caꞌi Buchꞌu yoꞌ jech ta xquichꞌ ta mucꞌ ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jech laj stacꞌ ti Jesuse: ―Laj xa avil. Vuꞌunun, jaꞌ ti Buchꞌu yacal ta xachiꞌin ta loꞌile ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jech ti vinique laj squejan sba ta stojol ti Jesuse. Jech laj yalbe: ―Ta jchꞌun, Cajval ―xi ti vinique. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tsꞌacal to un, jech laj yal ti Jesuse: ―Ti lital liꞌ ta sba banomile, tal jvinajesbe cꞌu sꞌelan yoꞌnton ti cristianoetique. Tal jambe sat ti maꞌsatetique. Yan ti buchꞌu jamal ti sat yalojique, ta xjoybijic ta maꞌsat ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oy jlom jfariseoetic ti tey xchiꞌinoje, ti cꞌalal jech laj yaꞌiic taje, jech laj sjaqꞌuic: ―¿Mi yuꞌun maꞌsatuncutic yaꞌyel ec un? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jech laj stacꞌ ti Jesuse: ―Ati yuꞌunuc maꞌsatucoxuque, muꞌyuc amulic ti jechuque. Pero ti jech ta xavalic ti ta xavilique, oy amulic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ti Jesuse jech laj yal: ―Ta melel ta xcalboxuc avaꞌiic, ti buchꞌu mu xꞌoch ta stiꞌ scorral ti chije, ti jaꞌ tey chba ochuc talel ti bu maꞌuc stiꞌe, jaꞌ jun jꞌelecꞌ ti ta xꞌelcꞌaje. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero ti Buchꞌu ta xꞌoch batel ta tiꞌ corrale, jaꞌ ti jqꞌuelchij umbi, ti ta xchabi ti chije. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ti jchabiej tiꞌ corrale ta sjam ti stiꞌe yoꞌ ta xꞌoch batel ti jqꞌuelchije. Jech ti schijtaque ta xaꞌibeic scꞌopojel ti yajvalique. Ta sloqꞌuesbe sbi ti schijtac ti cꞌalal ta sloqꞌues talel ta corrale. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cꞌalal jech laj xa sloqꞌues talel scotol ti schije, jaꞌ jbaꞌbe ta xanav batel ti stuque. Jech ti schijtaque tijilic ta xbat ta spat. Yuꞌun ta xaꞌibeic ti scꞌopojele. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mu stsꞌacliic batel ti buchꞌu mu xojtiquinique. Jaꞌ noꞌox ta xjatavic batel. Yuꞌun mu xaꞌibeic scꞌopojel ti buchꞌu mu xojtiquinique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ti jech laj sbabacꞌopta ti Jesuse, pero ti stuquique muꞌyuc laj yaꞌibeic smelol ti cꞌusi laj yale. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jech laj xchaꞌal ti Jesuse: ―Ta melel ta xcalboxuc avaꞌiic, vuꞌunun ti tiꞌ corral ti bu ta xꞌoch batel ti chijetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ti buchutic baꞌyel italique, jaꞌ jꞌeleqꞌuetic ti ta xꞌelcꞌajique. Pero ti chijetique muꞌyuc laj yaꞌibeic ti scꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Vuꞌunun ti tiꞌ corrale. Ti buchꞌu ta xꞌoch talel ta jtojole, jaꞌ ta xcol. Jaꞌ jech xtoc coꞌol sꞌelan jun chij ti xlocꞌ xꞌoch ta corrale. Ta sta lec ti sveꞌele. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yan ti jꞌeleqꞌue jaꞌ noꞌox ta xtal soques, ta xtal yelcꞌan, ta xtal smil ti chijetique. Pero ti vuꞌune tal cacꞌbe scuxlejal ti mu noꞌox albajuc ti yutsilale. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Vuꞌunun ti lequil jꞌilchije. Jech o xal un, ta xcacꞌ jba ta milel yuꞌun ti jchijtaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yan ti buchꞌu tojel noꞌox ta scꞌan ta sqꞌuel ti chije, cꞌalal ta xil ti ta xtal ti jtiꞌoval oqꞌuile, ta xjatav batel. Ta xicta comel ti chije. Yuꞌun maꞌuc ti batsꞌi jqꞌuelchije. Jaꞌ jech xtoc ti chijetique maꞌuc yuꞌun. Jech ti jtiꞌoval oqꞌuile ta stsac ti chije. Tan puc ta xbat yuꞌun. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ti vinic taje yuꞌun jaꞌ noꞌox stojol ta scꞌan ti ta xꞌabteje. Jech o xal ta xjatav batel. Mu sventauc ti chijetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Vuꞌun ti lequil jꞌilchije. Ti Jtote xiyojtiquin. Jech ti vuꞌune xcojtiquin ec. Jaꞌ jech xcojtiquin ti jchijtaque. Jech ti stuquique xiyojtiquinic ec. Jech o xal un, ta xcacꞌ jba ta milel yuꞌun ti jchijtaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oy to yan jchij ti muꞌyuc to tiqꞌuil liꞌ ta corrale. Persa chba quicꞌ talel. Ti stuquique ta xchꞌunic iqꞌuel. Jun noꞌox corral ta xcom. Jun noꞌox ti jꞌilchije. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Ti Jtote cꞌux ta xiyaꞌi yuꞌun ta xcacꞌ ti jcuxleje yoꞌ jech ta jchaꞌichꞌ ti jcuxlejale. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Muꞌyuc buchꞌu xuꞌ ta xismilun. Pero ti jech ta xcꞌot ta pasele, yuꞌun jech ta xlocꞌ ta coꞌnton jtuc. Yuꞌun oy ta jba ti ta xcacꞌ ti jcuxleje. Oy ta jba ti ta jchaꞌichꞌ ti jcuxlejale. Jaꞌ jech albilun talel yuꞌun ti Jtote ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cꞌalal jech laj yaꞌiic ti jꞌisraeletique, lic spas sbaic ta chaꞌvocꞌ xtoc. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oy ep ti jech ta xalique: ―¿Cꞌu chaꞌal ta xachꞌunbeic scꞌop leꞌe? Yuꞌun chuvajibem, xchꞌulelinojbe schꞌulel pucuj ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ti yan xtoque jech ta xalic: ―Ati yuꞌunuc xchꞌulelinojucbe schꞌulel ti pucuje, mu xuꞌ ta xcꞌopoj jech chac cꞌu chaꞌal leꞌe. Ati yuꞌunuc xchꞌulelinojucbe schꞌulel ti pucuje, ¿mi yuꞌun xuꞌ yuꞌun ta sjambe sat ti maꞌsatetic jechuque? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ti tey ta Jerusalene, ti jꞌisraeletique jaꞌ o yacalic ta spasic sqꞌuinal snaꞌobil ti stsajobil templo yuꞌunique. Jaꞌ o yorail ti sictique. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ti Jesuse tey ta xanav ta templo ta cotcot na ti Salomón sbie. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ti jꞌisraeletique tey laj sjoyobtaic ti Jesuse. Jech laj yalbeic: ―Tey to xmacmun ti coꞌntoncutic avuꞌune. ¿Mi voꞌot ti Cristoote? Alo xchꞌaꞌ ta jamal ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jech laj stacꞌ ti Jesuse: ―Laj xa calboxuc avaꞌiic, pero mu xachꞌunic. Ti cꞌusi ta jpase ti jaꞌ ta smantal stuc ti Jtote, jamal ta xayacꞌboxuc avilic ti Buchꞌuun ta melele. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero ti voꞌoxuque mu xachꞌunic, yuꞌun maꞌuc jchijoxuc jech chac cꞌu chaꞌal laj calboxuc avaꞌiic ta baꞌyele. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yuꞌun ti jchijtaque ta xaꞌiic ti jcꞌopojele. Jech ti vuꞌun eque xcojtiquin ti stuquic eque. Ta xistsꞌacliicun. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yuꞌun ta xcacꞌbe scuxlejal sbatel osil. Mi jaꞌuc chꞌayel ta xbatic. Muꞌyuc buchꞌu ta xispojbun ta coc ta jcꞌob. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Laj xa yacꞌbun ti Jtote ti jaꞌ banquilal ta scotole. Muꞌyuc buchꞌu ta spojbun ta yoc ta scꞌob. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ti vuꞌune schiꞌuc ti Jtote jununcutic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Cꞌalal jech laj yaꞌiic ti jꞌisraeletique, laj stamic ton yoꞌ jech ta xacꞌbeic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ti Jesuse jech laj yal: ―Ta sventa smucꞌul stsatsal ti Jtote, ep ti cꞌusi laj jpas ta atojolique. ¿Cꞌusi junucal ti laj jpase yoꞌ jech ta xavacꞌbeicun ti tone? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ti jꞌisraeletique jech laj staqꞌuic: ―Maꞌuc ta xacacꞌbecutic ton yuꞌun ti cꞌusi lec laj apase. Jaꞌ ti toj chopol ta xacꞌopoj ta stojol ti Diose. Yuꞌun ti acꞌope ta xabis aba ta Dios ti cꞌalal vinicot noꞌoxe ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jech laj stacꞌ ti Jesuse: ―Ta xal ti Diose: “Voꞌoxuc diosoxuc”, xi ti mantal avuꞌunic ti tsꞌibabile. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jnaꞌtic lec ti jech tsꞌibabil ta scꞌop Diose. Mu xuꞌ ta jmuctic. Diosetic, laj yacꞌbe sbi ti buchꞌutic laj xchꞌunbeic ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ti Diose laj stꞌujun, laj stacun talel liꞌ ta sba banomile. Jech o xal, ¿cꞌu chaꞌal ta xavalic ti chopol ta xicꞌopoj ta stojol ti Diose ti laj cal vuꞌunun Snichꞌonun Dios ti xichie? ");
INSERT INTO tzotzc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ti mi maꞌuc ta jpas ti cꞌusi ta spas ti Jtote, mu xachꞌunicun. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Manchuc mi mu xachꞌunic ti vuꞌun Snichꞌonun ti Diose, pero chꞌunic ti cabtel ti ta jpas ta atojolique, yoꞌ jech xanaꞌic xachꞌunic ti oy ta jtojol ti Jtote, ti oyun ta stojol eque ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yan to velta ta ox stsaquic ta chuquel. Pero tey icol batel yuꞌunic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jech ti Jesuse isut batel ta jot ucꞌum Jordán ti oy ta sloqꞌueb cꞌacꞌale. Tey icom ti buy to ox laj yacꞌ ichꞌ voꞌ ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ep cristianoetic bat sqꞌuelic. Jech laj yalic: ―Ti Juan jꞌacꞌ-ichꞌ-voꞌe muꞌyuc cꞌusi laj yacꞌ iluc smucꞌul stsatsal. Pero scotol ti cꞌusi laj yalbe scꞌoplal ti vinic liꞌe, jaꞌ melel ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ti teye ep laj xchꞌunic ti jaꞌ Jcoltavanej ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oy jun vinic ti ip ta xaꞌie, ti jaꞌ sbi Lázaroe. Tey nacal ta Betania, ti jaꞌ steclumalic ti Maríae schiꞌuc ti Martae, ti jaꞌ schiꞌil sbaic ta voqꞌuele. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ti María taje jaꞌ ti buchꞌu laj smalbe muil aceite ta yoc ti Cajvaltique, ti laj staquintasbe ta stsotsil sjole. Jaꞌ yixlel ti jchamel Lázaroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jech o xal ti chib antsetique jech laj yalic ti laj staic ta iqꞌuel ti Jesuse: ―Cajval, ti buchꞌu toj lec xacꞌopon abaic schiꞌuque ip ta xaꞌi ―xutic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cꞌalal jech laj yaꞌi ti Jesuse, jech laj yal: ―Ti jech ip ta xaꞌi taje, mu xcham o schiꞌuc. Jaꞌ noꞌox ta sventa ti ta xvinaj yutsilal slequilal ti Diose. Ti chamel taje jaꞌ ta sventa yoꞌ jech ta xvinaj cutsilal jlequilal ti vuꞌun Snichꞌonun ti Diose ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Manchuc mi ti Jesús cꞌux ta xaꞌi ti Martae, ti Maríae, ti Lázaroe, ");
INSERT INTO tzotzc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","pero cꞌalal iꞌalbat ti ip ta xaꞌi ti Lázaroe, tey to icom chib cꞌacꞌal ti bu onoꞌox oye. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsꞌacal to un, jech laj yalbe ti yajchancꞌoptaque: ―Batic yan velta ta Judea ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ti yajchancꞌoptaque jech laj staqꞌuic: ―Jchanubtasvanej, ti jꞌisraeletic teye achꞌ to noꞌox ti jutuc mu laj smilot ta tone. Avi tana un, ¿mi ta xacꞌan ta xabat avaꞌi yan velta? ―xutic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ti Jesuse jech laj yal: ―¿Mi mu yichꞌojuc lajcheb ora ti jun cꞌacꞌale? Ti mi ta xijxanav ta cꞌacꞌaltique, mu jbosi cacantic. Yuꞌun sac jaman ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yan ti mi ta xijxanav ta acꞌobaltique, ta jbosi cacantic. Yuꞌun chꞌabal sac jaman ti banomile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tsꞌacal to un, ti Jesuse jech laj yalbe ti yajchancꞌoptaque: ―Vay xa ti Lázaro ti lec jcꞌopon jbatic schiꞌuque. Pero ta xbat jtij liquel ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ti yajchancꞌoptaque jech laj staqꞌuic: ―Cajval, ti mi ta xvaye, jaꞌ svinajeb ti ta xa xlecube ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ti vaꞌi sꞌelan ta xal ti Jesuse, jaꞌ ta xal ti cham ti Lázaroe. Yan ti yajchancꞌoptaque laj snopic ti ta xal ti batsꞌi vayel noꞌoxe. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jech o xal un, ti Jesuse jamal laj yalbe ti yajchancꞌoptaque: ―Cham xa ti Lázaroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ximuyubaj xa ti muꞌyuc tey oyune. Más lec ti jech icꞌot ta pasele ta sventa ti voꞌoxuque yoꞌ jech ta xachꞌunicun. Pero batic, ba jqꞌueltic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ti Tomase, ti jaꞌ sbiinoj ti vache, jech laj yalbe ti yan jchancꞌopetique: ―Batic ec yoꞌ jmoj tey chba chamcutic schiꞌuc ti Jesuse ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cꞌalal jech icꞌot ti Jesuse, schanibal xa ox cꞌacꞌal smuclej ti Lázaroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ti Betaniae nopol xil sbaic schiꞌuc ti Jerusalene, jutuc más ta oꞌlol reva. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ep ti jꞌisraeletique bat svuꞌlanic yoꞌ ta spatbeic yoꞌnton ti Martae, ti Maríae yuꞌun jaꞌ ti cham xa ti schiꞌilic ta voqꞌuele. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cꞌalal laj yaꞌi ti Marta ti ta xa xcꞌot ti Jesuse, locꞌ batel, ba snup ta be. Yan ti Maríae tey icom ta na. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ti Martae jech laj yalbe ti Jesuse: ―Cajval, ti liꞌuc oyote, muꞌyuc xcham ti jchiꞌil ta voqꞌuel ti jechuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ta jnaꞌ ti cꞌusi ta xacꞌanbe ti Diose ta xacꞌbot scotol ―xi ti Martae. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ti Jesuse jech laj yal: ―Ti achiꞌil ta voqꞌuele ta xchaꞌcuxi talel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ti Martae jech laj yal: ―Ta jnaꞌ ti ta xchaꞌcuxie. Pero jaꞌ to ti cꞌalal xchaꞌcuxiic ti animaetic ta slajebal cꞌacꞌale ―xi ti Martae. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ti Jesuse jech laj yal: ―Vuꞌunun ti chaꞌcuxiebale schiꞌuc ti cuxlejale. Ti buchꞌu ta xchꞌunune, manchuc mi ta xcham, ta xchaꞌcuxi. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ti buchꞌu ti cuxulic to avi liꞌe ti ta xischꞌune, mu xchamic o. ¿Mi ta xachꞌun taje? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ti Martae jech laj yal: ―Ta jchꞌun, Cajval. Ta jchꞌun ti voꞌot ti Cristoote, ti Snichꞌonot ti Diose, ti ta onoꞌox xatal ta banomile ―xi ti Martae. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cꞌalal jech laj yale, ti Martae bat yicꞌ talel ti schiꞌil ta voqꞌuele, jaꞌ ti Maríae. Jech cꞌot yalbe ta mucul: ―Liꞌ xa oy ti Jchanubtasvaneje. Ta xastaot ta iqꞌuil ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Cꞌalal jech laj yaꞌi taje, ta ora ivaꞌi batel. Bat sqꞌuel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ti Jesuse tey to oy ti bu laj snup ta be ti Martae. Yuꞌun muꞌyuc to ochem batel ta jteclum. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Cꞌalal jech locꞌ batel ta anil ti Maríae, ti jꞌisraeletic ti ta spatic oꞌntonale tey tsꞌacal ibatic. Yuꞌun laj snopic ti tey chba ocꞌuc ta muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Cꞌalal icꞌot ti María ti bu oy ti Jesuse, tey laj squejan sba ta yoc. Jech laj yal: ―Cajval, ti liꞌuc oyucote, muꞌyuc xcham ti jchiꞌil ta voqꞌuel ti jechuque ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Cꞌalal laj yil ti Jesús ti ta xꞌocꞌ ti Maríae schiꞌuc ti jꞌisraeletic ti tsꞌacalic batele, och ta at oꞌnton ec. Mu xꞌechꞌ ta xaꞌi ti meꞌunale. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ti Jesuse jech laj sjacꞌ: ―¿Bu laj amuquic? ―xi. Jech laj yalic: ―Laꞌ jqꞌueltic avil, Cajval ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ti Jesuse iꞌocꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ti jꞌisraeletique jech laj yalic: ―Qꞌuel avil, ep cꞌux ta xaꞌi sbaic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero oy jlom jech laj yalic: ―Ti vinic leꞌe jaꞌ laj sjambe sat ti maꞌsate. ¿Mi muꞌyuc cꞌusi laj yut jutebuc yoꞌ muꞌyuc xcham ti Lázaroe? ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ti Jesuse lic yaꞌi yan velta ti meꞌunale. Tey inopaj batel ta muquinal. Macbil stiꞌ ta jun mucꞌ ta ton. Yuꞌun coꞌol sꞌelan jun nail chꞌen. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jech laj yal ti Jesuse: ―Loqꞌuesic ti tone ―xi. Ti Martae, ti jaꞌ schiꞌil ta voqꞌuel ti animae, jech laj yal: ―Tu xa van, Cajval. Yuꞌun oy xa schanibal cꞌacꞌal schamel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ti Jesuse jech laj yal: ―Ta xavilbe yutsilal slequilal Dios ti mi ta xachꞌunune, ¿mi mu xacutot? ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tey lic sloqꞌuesic ti tone. Ti Jesuse laj stoy muyel sat ta vinajel. Jech laj yal: ―Colaval, Tot, yuꞌun laj avaꞌibun ti jcꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ta jnaꞌ ti ta xavaꞌibun onoꞌox ti jcꞌope. Ta xcal jech ta sventa slequilal ti cristianoetic ti liꞌ oyique, yoꞌ jech ta xchꞌunic ti voꞌot laj atacun talele ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cꞌalal jech laj yal ti Jesús taje, tsots iꞌavan: ―Locꞌan talel tey, Lázaro ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tsꞌotbil ta manta yoc scꞌob ilocꞌ talel ti animae. Pixbil ta manta ti sat xtoque. Ti Jesuse jech laj yal: ―Jitunic, acꞌo batuc ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ti jꞌisraeletic ti buchꞌutic xchiꞌinojic batel ti Maríae, ti cꞌalal laj yilic laj xchaꞌcuxes anima ti Jesuse, jaꞌ to jech ep laj xchꞌunic ti jaꞌ Jcoltavanej ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero oy jlom bat yalbeic yaꞌi jfariseoetic ti cꞌusi laj spas ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ti jfariseoetique schiꞌuc ti banquilal paleetique bat stsob sbaic schiꞌuc ti banquilal jchapanvanejetique. Jech laj yalic: ―¿Cꞌusi ta xcutic ti vinic taje ti ep ta xacꞌ iluc ti smucꞌul stsatsale? ");
INSERT INTO tzotzc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yan ti mi chꞌan noꞌox xcutique, scotolic ta xlic yichꞌic ta mucꞌ. Jech ti ajvalil tey ta Romae ta xtal slilinic ti jlumaltique schiꞌuc ti templo cuꞌuntique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero oy jun yuꞌunic ti jaꞌ Caifás sbie, ti jaꞌ o sjabilal tiqꞌuil ta banquilal pale ti Caifase, ti jech laj yale: ―Mu xanaꞌbeic smelol ti voꞌoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mu xanaꞌic ti jaꞌ más lec ti acꞌo chamuc jun vinic ta sventa ti jteclumaltique. Jaꞌ toj vocol ti mi ta xlaj scotol ti jteclumaltique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ti vaꞌi sꞌelan laj yal ti Caifase, maꞌuc laj snop stuc. Yuꞌun jaꞌ iꞌacꞌbat snaꞌ yuꞌun ti Diose ti acꞌo chamuc ti Jesús ta sventa ti jꞌisraeletique ti cꞌalal jaꞌ o tiqꞌuil ta banquilal pale ti Caifás ti jabil taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero maꞌuc noꞌox ta sventa ti jꞌisraeletic ti jech ta xcham ti Jesuse. Jaꞌ jech xtoc jaꞌ ta sventa stsobel scotol ti snichꞌnab Dios ti buꞌyuc noꞌox tanijemique. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti jech cꞌacꞌal taje, jaꞌ o lic snop scꞌopic ti jꞌopisialetic yuꞌun ti jꞌisraeletique yoꞌ jech ta smilic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jech o xal un, ti Jesuse mu xa xacꞌ sba iluc ta stojol ti jꞌisraeletique. Ilocꞌ batel ti tey ta Judeae. Bat ta stsꞌel xocol banomil ta jun jteclum ti jaꞌ sbiinoj Efraine. Tey icom schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jutuc xa scꞌan xlic ti qꞌuin Colel yuꞌun ti jꞌisraeletique. Ep ti cristianoetic ti liquemic talel ta jujun jteclume batic ta Jerusalén yoꞌ jech ta xchapan sbaic ti cꞌu sꞌelan liquem yuꞌunique ti cꞌalal mu to xlic ti qꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ta saꞌic ti Jesuse. Ti cꞌalal tey oyic ta temploe, jech lic sjacꞌbe sbaic: ―¿Cꞌusi ta xanop? ¿Mi ta xtal ta qꞌuin xanaꞌic, o mi moꞌoj? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ti jfariseoetique schiꞌuc ti banquilal paleetique yalojic onoꞌox mantal ti mi oy bu ta xilic ti Jesuse, acꞌo yalic yoꞌ jech ta stsaquic ta chuquel. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vaquib xa cꞌacꞌal scꞌan ti qꞌuin Colele cꞌalal ti Jesuse ibat ta Betania ti bu nacal ti Lázaroe, jaꞌ ti buchꞌu ichaꞌcuxesat yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tey laj spasic veꞌlil ta sventa ti Jesuse. Ti Martae jaꞌ ta xacꞌ ti veꞌlile. Ti Lázaroe tey chotol ta mexa ta xveꞌic schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ti Maríae laj yichꞌ talel oꞌlol litro muil aceite ti jaꞌ puru nardoe, ti toj ep stojole. Laj sqꞌuebbe ta sba yoc ti Jesuse. Tsꞌacal to un, ta stsotsil sjol laj staquintasbe ti yoque. Sjunul yut na tanij smuil ti perfumee. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ti Judas Iscariotee, ti jaꞌ snichꞌon ti Simone, ti jaꞌ jun yajchancꞌop ti Jesuse, jaꞌ ti buchꞌu ta xꞌacꞌvan ta cꞌabale, jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Cꞌu chaꞌal mu laj yichꞌ chonel ta oxib ciento denario taqꞌuin ti perfumee, yoꞌ jech ta xichꞌ coltael ti buchꞌu abol sbaique? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ti jech laj yal ti Judas taje, maꞌuc oy ta yoꞌnton ti buchꞌu abol sbaique. Yuꞌun jꞌelecꞌ xaꞌi sba. Jaꞌ jech xtoc yuꞌun oy ta scꞌob ti yavil taqꞌuine. Jech o xal un, tey ta stam loqꞌuel ti taqꞌuin ti buchꞌu ta xaqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ti Jesuse jech laj yal: ―Chꞌan uto ti ants liꞌe. Yuꞌun laj yacꞌbun quichꞌ ti muil perfume ti xchabioj onoꞌox sventa ti jmucobbaile. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yuꞌun ti buchꞌutic abol sbaique liꞌ onoꞌox oy ta atojolique. Yan ti vuꞌune mu liꞌuc oyucun o ta atojolique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ep jꞌisraeletic laj yaꞌiic ti oy ta Betania ti Jesuse. Tey bat sqꞌuelic. Pero maꞌuc noꞌox bat sqꞌuelic ti Jesuse. Bat sqꞌuelic xtoc ti Lázaro ti ichaꞌcuxesat yuꞌun ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ti banquilal paleetique laj scomonopic ti ta smilic ti Lázaroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yuꞌun jaꞌ ta scoj ti Lázaroe ti ep ta xchꞌac sbaic batel ti jꞌisraeletique, jaꞌ ti ta xchꞌunic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ti ta yocꞌlomale, ep ti cristianoetic ti ibatic ta qꞌuin Colele, yuꞌun laj yaꞌiic ti ta xcꞌot ti Jesús ta jteclum Jerusalene. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jech o xal un, scotolic lic sbojic yanal xan. Bat snupic ta be ti Jesuse. Jech lic avanicuc: ―Toj yan yutsil ti Diose. Yan yutsil ti Buchꞌu talem ta sventa ti Diose. Yan yutsil ti Ajvalil cuꞌun ti voꞌotic jꞌisraelotique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tey laj sta jcot burro ti Jesuse. Laj scajlebin batel jech chac cꞌu chaꞌal ta xal ti scꞌop Diose: ");
INSERT INTO tzotzc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mu xaxiꞌ, jteclum Sión. Leꞌ cajal ta xtal ta burro ti Ajvalil avuꞌune, xi ti tsꞌibabile. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ti jech icꞌot ta pasel taje, muꞌyuc laj yaꞌibeic smelol ti yajchancꞌoptaque. Jaꞌ to laj yaꞌibeic smelol ti cꞌalal laj xa yichꞌ slequilal ti Jesuse. Laj snaꞌic ti jech onoꞌox tsꞌibabil ti scꞌoplale. Yuꞌun jech onoꞌox icꞌot ta pasel. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ti cristianoetic ti buchꞌutic ayic schiꞌuc ti Jesús ti cꞌalal laj yicꞌ loqꞌuel talel ta smuquinal ti Lázaroe, ti laj xchaꞌcuxese, laj yalic ti cꞌusi laj yilique. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jech o xal ep cristianoetic bat snupic talel ta be ti Jesuse. Yuꞌun laj yaꞌiic ti laj yacꞌ iluc ti smucꞌul stsatsale. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ti jfariseoetique jech laj yalbe sbaic: ―Qꞌuel avilic, mu xuꞌ cuꞌuntic ta jpajestic ti cristianoetique. Yuꞌun scotol tey ta xbatic ta stojol ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ti ta scotol ti cristianoetic ti batemic ta yichꞌel ta mucꞌ Dios ta qꞌuin ti ta Jerusalene, tey oy jun chib jyanlumetic, ti jaꞌ jgreciaetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jech ti jgreciaetique nopajic batel ta stojol ti Felipee ti liquem talel ta Betsaida ti oy ta Galileae. Jech laj scꞌanbeic vocol: ―Ta jcꞌan ta jqꞌuel caꞌicutic ti Jesuse ―xutic ti Felipee. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ti Felipee bat yalbe ti Andrese. Jech schibalic bat yalbeic yaꞌi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ti Jesuse jech laj yal: ―Sta xa yorail ta xquichꞌ jlequilal ti vuꞌun ti coꞌol jꞌelantique. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta melel ta xcalboxuc avaꞌiic, mi mu xbaj ta lum ta xcham ti jbej sat trigoe, staoj yav jun jun o. Pero ti mi ta xchame, ta xbol ti tsꞌunobale. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ti buchꞌu cꞌux ta xaꞌi ti scuxlejal liꞌ ta sba banomile, jaꞌ ta xchꞌay. Yan ti buchꞌu mu tsotsuc scꞌoplal ta xaꞌi ti scuxlejal liꞌ ta sba banomile, jaꞌ ta sta scuxlejal sbatel osil. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mi oy buchꞌu ta scꞌan ta xtun cuꞌune, acꞌo me stsꞌacliun batel. Ti bu oyune tey oy ec. Ti buchꞌu ta xtun cuꞌune, ichꞌbil ta mucꞌ ta xcꞌot yuꞌun ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Mu xꞌechꞌ ta xcaꞌi ti vocole. ¿Cꞌusi ta xcal? ¿Mi jaꞌ ta xcal: “Tot, coltaun ti cꞌusi ta xcꞌot ta jtojol avi liꞌe”, mi xichie? Moꞌoj, yuꞌun jaꞌ jtu ti jech litale ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jech lic scꞌopon Dios ti Jesuse: ―Tot, acꞌo aba ta ichꞌel ta mucꞌ atuc ―xi. Jaꞌ o tey ivinaj ti oy Buchꞌu ta xcꞌopoj talel ta vinajel ti jech ta xale: ―Laj xa cacꞌ jba ta ichꞌel ta mucꞌ. Pero yan to velta ta xcacꞌ jba ta ichꞌel ta mucꞌ ―xi ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ti cristianoetic teye laj yaꞌiic ti oy Buchꞌu icꞌopoje. Laj yalic ti jaꞌ jun chauque. Ti yan xtoque ta xalic ti jaꞌ icꞌoponat yuꞌun jun ángel. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jech laj yal ti Jesuse: ―Maꞌuc ta jventa vuꞌun ti oy Buchꞌu icꞌopoj laj avaꞌiique. Yuꞌun jaꞌ ta aventaic ti voꞌoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Avi tana un, ta xlic yichꞌ chapanel ti cristianoetique. Jaꞌ jech xtoc jaꞌ xa yorail ti ta xichꞌ jipel loqꞌuel ti buchꞌu ta spas mantal liꞌ ta banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cꞌalal ta sta yorail ta xquichꞌ jipanel ta cruze, vuꞌun ta jtijbe talel yoꞌnton scotol ti cristianoetique ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ti vaꞌi sꞌelan laj yal ti Jesuse, jaꞌ ta xacꞌ ta naꞌel ti cꞌu sꞌelan ta xchame. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ti cristianoetique jech laj yalic: ―Oy bu caꞌbinojcutic ti cꞌalal ta xꞌech sqꞌuelel slibroal ti mantal cuꞌuncutique ti cuxul o sbatel osil ti Cristoe. Mi voꞌot ti Cristoote, ¿cꞌu chaꞌal ta xaval ti ta xquichꞌ milel ti vuꞌun coꞌol jꞌelantique, ti xachie? ¿Buchꞌuot un chaꞌe? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jech laj stacꞌ ti Jesuse: ―Ti luze liꞌ to oy ta atojolique, pero mu xa jaluc. Xanavanic ta luz yoꞌ to oy ta atojolic, yoꞌ jech mu chꞌayaluc avoꞌntonic xastaoxuc ti icꞌal osile. Yuꞌun ti buchꞌu ta xanav ta icꞌal osile, mu snaꞌ bu ta xbat. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chꞌunic ti luze yoꞌ to liꞌ vaꞌal ta atojolique, yoꞌ jech ta xacꞌotic ta snichꞌnab ti luze ―xi ti Jesuse. Cꞌalal jech laj yal taje, ibat ti Jesuse. Ba snacꞌ sba. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Acꞌo mi laj yacꞌ iluc smucꞌul stsatsal ti Jesús ta stojol ti jꞌisraeletique, pero mi jaꞌuc xchꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ti jech taje, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal laj stsꞌiba comel ti jꞌalcꞌop Isaíase: Cajval, ¿buchꞌu ta xchꞌun ti cꞌusi ta xcaltique? ¿Buchꞌu ta xchꞌun ti smucꞌul stsatsal ta xꞌacꞌbat yile? xi ti Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oy smelol ti cꞌu chaꞌal mu xchꞌunique. Yuꞌun jech onoꞌox laj stsꞌiba xtoc ti Isaíase: ");
INSERT INTO tzotzc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Laj jmacbe satic, laj yijubtasbe yoꞌntonic, yoꞌ mu xilic, yoꞌ jech mu xaꞌiic ta yoꞌntonic, yoꞌ jech mu xtal yacꞌ sbaic ta poxtael ta jtojol, xi ti Dios ti laj stsꞌiba ti Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jech laj yal ti Isaíase, jaꞌ ti laj yilbe slequilal yutsilal ti Jesuse. Jaꞌ jech xtoc laj yalbe scꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Manchuc mi oy jꞌisraeletic ti muc bu laj xchꞌunique, pero oy ep ti laj xchꞌunic ti jaꞌ Jcoltavanej ti Jesuse. Oy jlom jpasmantaletic laj xchꞌunic xtoc. Pero mu xal sbaic, yuꞌun ta xiꞌic ti ta xjipatic loqꞌuel ta chꞌul na yuꞌun ti jfariseoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yuꞌun ti stuquique jaꞌ lec ta xaꞌiic ti ichꞌbilic ta mucꞌ yuꞌun ti cristianoetique. Jaꞌ mu scꞌanic ti ta xꞌacꞌatic ta ichꞌel ta mucꞌ yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jech tsots lic yal ti Jesuse: ―Ti buchꞌu ta xischꞌune, maꞌuc noꞌox ta xischꞌunun. Ta xchꞌun ti Jtot ti buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ti buchꞌu ta xiyile, ta xil xtoc ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Vuꞌunun ti luz ti lital ta banomile yoꞌ jech ti buchꞌu ta xischꞌunune, mu xcomic ta icꞌal osil. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ti buchꞌu ta xaꞌi ti jcꞌope, pero ti mi mu xchꞌune, maꞌuc vuꞌun ta jchapan. Yuꞌun ti vuꞌune lital coltavancun. Maꞌuc lital chapanvancun. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ti buchꞌu ta xisbajune, ti mu xichꞌ ta mucꞌ ti jcꞌope, ta xa xichꞌ chapanel yuꞌun ti jcꞌop ta slajebal cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yuꞌun mu ta jmantaluc noꞌox jtuc ti cꞌu sꞌelan ta xicꞌopoje. Ti cꞌu sꞌelan ta xicꞌopoje, ti cꞌu sꞌelan ta xichanubtasvane, jaꞌ ta smantal ti Jtot ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jnaꞌ lec ti cꞌu sꞌelan laj yalbun talel ti Jtote, jaꞌ sventa cuxlejal sbatel osil. Jech o xal ti cꞌu sꞌelan ta xcale coꞌol jech chac cꞌu chaꞌal laj yalbun talel ti Jtote ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jaꞌ xa yacꞌubalil ti qꞌuin Colele. Snaꞌoj xa ti Jesuse ti cꞌot xa yorail ta xicta comel ti banomile, ti ta sut batel ta stojol ti Stote. Ti stuque laj onoꞌox xcꞌuxubin ti yajchancꞌoptac ti liꞌ ta banomile. Pero ta to xacꞌbe yil más ti scꞌuxul yoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ti yorail ta xveꞌique, tijbat xa yoꞌnton yuꞌun pucuj ti Judas Iscariotee, ti jaꞌ snichꞌon ti Simone, ti jaꞌ ta xacꞌ ta cꞌabal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ti Jesuse snaꞌoj xa ti acꞌbat xa ta scꞌob yuꞌun stot scotol ti cꞌusitic oye. Yuꞌun ti stuque liquem talel ta stojol ti Diose. Tey ta sut batel ta stojol xtoc. Pero ep cꞌux ta xaꞌi ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ti Jesuse lic vaꞌiuc ti jech chotol ta mexae. Laj slocꞌ ti schaꞌlomal scꞌuꞌe. Tey laj stsac jun toalla. Lic stsꞌot ta schucbenal. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tsꞌacal to un, lic sqꞌueb voꞌ ta pocob cꞌobal. Tey lic spocbe yacan ti yajchancꞌoptaque. Tey laj scusbe yacan ta toalla ti tey tsꞌotol ta schucbenale. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cꞌalal jech lic pocbatuc yacan ti Simón Pedroe, ti stuque jech laj yal: ―Cajval, ¿mi voꞌot ta xapocbun ti coque? ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jech laj stacꞌ ti Jesuse: ―Avi tana liꞌe mu xavaꞌibe smelol ti jech ta jpase. Pero tsꞌacal to ta xlic avaꞌibe smelol ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ti Pedroe jech laj yal: ―Mi jaꞌuc ta xcacꞌ apoc ti coc vuꞌune ―xi ti Pedroe. Jech laj yal ti Jesuse: ―Ti mi muꞌyuc ta jpocbote, mu xuꞌ jchiꞌin jbatic ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jaꞌ yuꞌun un, jech laj yal ti Simón Pedroe: ―Maꞌuc noꞌox xapocbun ti cacane, Cajval. Jaꞌ jech xtoc pocbun ti jole, ti jcꞌobe ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ti Jesuse jech laj yal: ―Ti Buchꞌu naca to atineme, mu xa persauc ta xichꞌ poquel sjunul. Jaꞌ xa noꞌox ta xichꞌ pocbel ti yacane, yuꞌun pocbil xa sjunul. Ti voꞌoxuque pocbiloxuc xa, acꞌo mi mu acotolicuc ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ti muꞌyuc pocbiloxuc acotolic ti xie, yuꞌun snaꞌoj ti oy buchꞌu ta xꞌacꞌvan ta cꞌabale. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cꞌalal jech laj yoꞌnton ta spocbel yacan ti yajchancꞌoptaque, ti Jesuse tey lic slap ti scꞌuꞌe. Tey bat chotluc ta mexa yan velta. Jech laj yal: ―¿Mi laj avaꞌibeic smelol ti jech laj jpas ta atojolique? ");
INSERT INTO tzotzc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jchanubtasvanej, Cajval, ti xavuticune. Melel avaꞌuquic, yuꞌun vuꞌunun. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ti Vuꞌun Jchanubtasvanejun Ajvalilun avuꞌunique laj xa jpoc ti avacanique. Ti voꞌoxuque jech me xapocbe abaic avacanic ta jujun tal. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yuꞌun laj xa cacꞌ avilic yoꞌ jech ta xapasic jech chac cꞌu chaꞌal laj jpase. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta melel ta xcalboxuc avaꞌiic, ti mosovile, maꞌuc cajal ta xacꞌ sba ta stojol ti yajvale. Ti buchꞌu tacbile, maꞌuc cajal ta xacꞌ sba ta stojol ti jtacvaneje. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ti mi ta xavaꞌibeic smelol ti jech laj jpase, ti mi ta xapasic xtoc jech chac cꞌu chaꞌal laj cacꞌ avilique, xamuyubajic noꞌox. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ti jech laj calboxuc taje, maꞌuc acotolic. Yuꞌun jnaꞌoj ti buchꞌutic tꞌujbil cuꞌune. Pero yuꞌun tsots scꞌoplal ta xcꞌot ta pasel jech chac cꞌu chaꞌal tsꞌibabil ta scꞌop Diose: “Ti buchꞌu ti jmoj ta xiveꞌ schiꞌuque ijoybij ta cajcronta”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cꞌalal ta xavilic ti jech ta xcꞌot ta pasele, jpocoꞌalojboxuc xa onoꞌox avaꞌiic yoꞌ jech ta xachꞌunic ti Buchꞌuun ta melele. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ta melel ta xcalboxuc avaꞌiic, ti buchꞌu ta xichꞌ ta mucꞌ ti buchꞌu ta jtac batele, vuꞌun ta xiyichꞌun ta mucꞌ. Ti buchꞌu ta xiyichꞌun ta muqꞌue, ta xichꞌ ta mucꞌ ti Buchꞌu laj stacun talele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cꞌalal jech laj yale, ti Jesuse lic ochuc ta at oꞌnton. Jech jamal laj yal: ―Ta melel ta xcalboxuc avaꞌiic, oy jun avuꞌunic ti ta xiyacꞌ ta cꞌabale ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Cꞌalal jech laj yaꞌiic ti yajchancꞌoptaque, lic sqꞌuel sbaic ta jujun tal. Yuꞌun mu snaꞌic buchꞌu scꞌoplal ti jech ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Oy jun yajchancꞌop ti tey nopol ta xveꞌ schiꞌuque, ti cꞌux ta xaꞌi sbaic schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ti Simón Pedroe lic spas seña ti acꞌo sjacꞌ ti buchꞌu scꞌoplal ta xalbe taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jech ti stuque más to laj snaban sba ta stsꞌel ti Jesuse. Jech laj yalbe: ―¿Buchꞌu, Cajval? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ti Jesuse jech laj stacꞌ: ―Ta jtsꞌaj juteb pan ta setsꞌ. Ti buchꞌu ta xcacꞌbe ta xavile, jaꞌ me umbi ―xi. Jech o xal laj stsꞌaj ti juteb pane. Tey laj yacꞌbe ti Judas Iscariotee, ti jaꞌ snichꞌon ti Simone. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cꞌalal jech laj stsac pan ti Judase, ta ora noꞌox ochꞌ ti pucuj ta yoꞌntone. Jech laj yal ti Jesuse: ―Paso me ta ora ti cꞌusi ta onoꞌox xapase ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ti buchꞌutic tey ta xveꞌic ta mexae, mi junuc laj yaꞌibeic smelol ti vaꞌi sꞌelan laj yal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Oy jlom laj snopic ti ipasat ta mantal yuꞌun ti Jesuse ti acꞌo bat sman talel ti cꞌusi ta xtun yuꞌunic ta sventa ti qꞌuine. Oy jlom laj snopic ti oy cꞌusi ta xacꞌbe ti meꞌunetique, yuꞌun jaꞌ yichꞌoj ta sventa yavil taqꞌuin ti Judase. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cꞌalal jech laj stsac pan ti Judase, locꞌ batel. Acꞌobaltic xa. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Cꞌalal locꞌ xa batel ti Judase, ti Jesuse jech laj yal: ―Avi tana un, ti vuꞌun coꞌol jꞌelantique ta xvinaj ti jlequilale. Jech xtoc ta xvinaj yutsilal ti Diose ta sventa ti cꞌusi ta xcꞌot ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ti mi jech ta xvinaj yutsilal ti Dios ta jtojol ti coꞌol jꞌelantique, jech o xal un, ti Diose ta xacꞌ ta ilel ti jlequilal cutsilale. Jutuc xa scꞌan ta xa xcꞌot ta pasel. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jnichꞌnabtac, mu xa jaluc liꞌ oyun ta atojolique. Ta xasaꞌicun, pero coꞌol ta xacalboxuc avaꞌiic jech chac cꞌu chaꞌal laj calbe yaꞌiic ti jꞌisraeletique: “Mu xuꞌ xabatic ti bu ta xibate”, ti xcutic onoꞌoxe. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ta xcacꞌboxuc comel ti achꞌ mantal liꞌe: Cꞌux me xavaꞌi abaic ta jujun tal jech chac cꞌu chaꞌal cꞌux laj caꞌioxuc. Jaꞌ me jech cꞌux xavaꞌi abaic ta jujun tal ti voꞌoxuc une. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ti mi jech cꞌux ta xavaꞌi abaique, scotol ti cristianoetique ta xilic ti jaꞌ cajchancꞌopoxuque ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ti Simón Pedroe jech laj sjacꞌbe ti Jesuse: ―¿Bu ta xabat un, Cajval? ―xi. Jech laj stacꞌ ti Jesuse: ―Ti bu ta xibate, mu to xuꞌ xabat avi liꞌe. Pero ta xatsꞌacliun onoꞌox ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ti Pedroe jech laj yal: ―¿Cꞌu chaꞌal ti mu to xuꞌ ta jtsꞌacliot batel avi liꞌe, Cajval? Yuꞌun chapalun xa ta xcacꞌ jba ta milel ta aventa ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ti Jesuse jech laj stacꞌbe: ―¿Mi melel ti chapalot xa ta xavacꞌ aba ta milel ta jventae? Ta melel ta xcalbot avaꞌi, laj xa ox amucun ta avoꞌnton oxib velta ti cꞌalal mu to ta xꞌocꞌ ti cotse ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ti Jesuse jech laj yalbe yaꞌiic ti yajchancꞌoptaque: ―Mu me xchibaj avoꞌntonic ti voꞌoxuque. Chꞌunic me ti Diose. Chꞌunicun ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti bu nacal ti Jtote, ep naetic tey yoꞌ xuꞌ ta xijnaquiotic. Ati yuꞌunuc muꞌyucuque, laj xa calboxuc avaꞌiic ti jechuque. Jech o xal un, ta xibat ta smeltsanel ti bu ta xacꞌotique. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cꞌalal mi laj xa jmeltsan comel ti bu ta xacꞌotique, ta xisut talel yan velta yoꞌ jech ta xquicꞌoxuc batel, yoꞌ jech tey oyoxuc ti bu oyun eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ti voꞌoxuque xanaꞌic ti bu ta xibate schiꞌuc xanaꞌic xtoc ti bee ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ti Tomase jech laj yal: ―Mu jnaꞌcutic ti bu ta xabate, Cajval. ¿Cꞌusi ta xcutcutic yoꞌ ta jnaꞌcutic ti bee? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ti Jesuse jech laj stacꞌbe: ―Vuꞌunun ti bee. Vuꞌunun ti melele. Jaꞌ jech xtoc vuꞌunun ti cuxlejale. Jaꞌ noꞌox ta jventa vuꞌun yoꞌ jech xuꞌ ta xacꞌotic ta stojol ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ti mi xavojtiquinicune, jaꞌ jech xtoc xavojtiquinic ti Jtote. Avi liꞌe, liꞌ ta xlic avojtiquinic ti Jtote. Yuꞌun liꞌ avilojic xae ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jech laj yal ti Felipee: ―Acꞌbun quilcutic ti Totil taje, Cajval. Jaꞌ to jech xuꞌ o ta xcaꞌicutic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jech laj stacꞌ ti Jesuse: ―Felipe, jal xa liꞌ oyun ta atojolique, ¿mi mu to xavojtiquinicun xtoc? Ti buchꞌu ta xiyojtiquinune, ta xojtiquin ti Jtote. Jech o xal un, ¿cꞌu chaꞌal ta xacꞌan ta xcacꞌbot avil ti Jtote? ");
INSERT INTO tzotzc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mi mu xachꞌun ti oyun ta stojol ti Jtote, ti oy ta jtojol ti Jtote? Ti cꞌusi ta xcalboxuque, maꞌuc ta xcal ta coꞌnton jtuc. Jaꞌ ta jpasbe yabtel stuc ti Jtot ti jech oy ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chꞌunic ti oyun ta stojol ti Jtote. Jaꞌ jech xtoc chꞌunic ti oy ta jtojol ti Jtot eque. Mi mu xcꞌot ta avoꞌntonic ti cꞌusi laj cal liꞌe, pero ta sventa ti cabtele, chꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ta melel ta xcalboxuc avaꞌiic, ti buchꞌu ta xchꞌunune, jaꞌ jech ta spas jech chac cꞌu chaꞌal ta jpas eque. Xuꞌ to ti jaꞌ más jelavem ta spase. Yuꞌun ta xibat ti bu oy ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Scotol ti cꞌusi ta xacꞌanbeic ti Dios ta jventae, ta xacacꞌboxuc yoꞌ jech ta jvinajesbe yutsilal Jtot ti vuꞌun Nichꞌonilune. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuꞌun vuꞌun ta jpas ti cꞌusiuc noꞌox ta xacꞌanic ta jventae. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Ti mi cꞌux ta xavaꞌiicune, chꞌunic ti jmantale. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jech ti vuꞌune ta jcꞌanbe ti Jtote ti acꞌo stacꞌboxuc talel ti Chꞌul Espíritu ti jaꞌ Melele yoꞌ ta scoltaoxuc yoꞌ ta xchiꞌinoxuc o. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yan ti buchꞌutic lec ta xaꞌiic ti sba banomile mu xuꞌ ta xichꞌic. Yuꞌun mu xilic, mu xojtiquinic ti Chꞌul Espíritue. Yan ti voꞌoxuque xavojtiquinic. Yuꞌun tey oy ta atojolic. Tey ta xcom o ta atojolic. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mu xaquictaoxuc comel atuquic. Yuꞌun ta xtal jchiꞌinoxuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mu xa jaluc ti liꞌ ta xiyilicun ti cristianoetique. Yan ti voꞌoxuque ta xavilicun. Ti jech cuxulun ti vuꞌune, jech ta xacuxiic o ta jventa ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ti cꞌalal jech ta xtal ti Chꞌul Espíritue, jaꞌ o tey ta xanaꞌic ti oyun ta stojol ti Jtote, ti oyun ta atojolic eque, ti oyoxuc ta jtojol eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ti buchꞌu snaꞌ xchꞌun ti jmantale ta xacꞌ ta ilel ti cꞌux ta xiyaꞌie. Ti buchꞌu cꞌux ta xiyaꞌie, jaꞌ jech xtoc cꞌux ta xꞌaꞌiat yuꞌun ti Jtote. Jech ti vuꞌun eque cꞌux ta xcaꞌi. Ta xcacꞌ jba iluc ta stojol ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ti Judase, pero maꞌuc ti Judas Iscariotee, jech laj yal: ―Cajval, ¿cꞌu chaꞌal jaꞌ noꞌox ta xavacꞌ aba iluc ta jtojolcutic? ¿Cꞌu chaꞌal mu jaꞌuc ta xavacꞌ aba iluc ta stojol ti cristianoetic liꞌ ta sba banomile? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ti Jesuse jech laj stacꞌbe: ―Ti buchꞌu cꞌux ta xiyaꞌie ta xchꞌun ti cꞌusi ta xcale. Ta xcꞌuxubinat yuꞌun ti Jtote. Jech ti Jtote schiꞌuc ti vuꞌune ta xinaquicutic ta stojol. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ti buchꞌu mu cꞌuxuc ta xiyaꞌie, mu xchꞌun ti cꞌusi ta xcale. Ti cꞌusi ta xcal avaꞌiique maꞌuc jcꞌop jtuc. Jaꞌ scꞌop ti Jtot ti laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Jech ta xcalboxuc avaꞌiic scotol taje yoꞌ to liꞌ oyun ta atojolique. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yan ti Chꞌul Espíritu ti ta stac talel ti Jtot ta jventae, jaꞌ ta xascoltaoxuc, ta spatboxuc avoꞌntonic, ta xaschanubtasoxuc scotol. Jaꞌ ta sjulesboxuc ta ajolic scotol ti vaꞌi sꞌelan laj calboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ta xibat. Ta xcacꞌboxuc comel smucꞌul avoꞌntonic. Ti smucꞌul avoꞌntonic ti ta xcacꞌ comele, mu xcoꞌolaj schiꞌuc jech chac cꞌu chaꞌal ta xacꞌ ti cristianoetic liꞌ ta sba banomile. Jech o xal mu me xavat avoꞌntonic. Mu xaxiꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Laj xa calboxuc avaꞌiic ti ta xibate. Laj xa calboxuc avaꞌiic xtoc ti ta xtal jchiꞌinoxuc yan veltae. Mi ta melel ti cꞌux ta xavaꞌiicune, xamuyubajic xa jechuc ti laj avaꞌiic ti ta xibat ti bu oy ti Jtote. Yuꞌun ti stuque jaꞌ jelavem smucꞌul. Mu sta ti vuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jaꞌ jech ta xcalboxuc avaꞌiic yoꞌ to liꞌ oyune. Ta jpocoꞌalboxuc avaꞌiic yoꞌ jech ta xachꞌunicun ti cꞌalal ta xcꞌot ta pasel taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mu xa jaluc ta jchiꞌinoxuc ta loꞌil. Yuꞌun ta xa xtal ti buchꞌu ta spas mantal liꞌ ta sba banomile, acꞌo mi muꞌyuc cꞌusi xuꞌ yuꞌun ta jtojol. ");
INSERT INTO tzotzc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero tsots scꞌoplal ti jech ta xcꞌot ta pasele, yoꞌ jech ta snaꞌic ti cristianoetique ti cꞌux ta xcaꞌi ti Jtote, ti ta jpas ti cꞌusi yalojbune. Vaꞌlanic, batic ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ti Jesuse jech laj yal: ―Ti vuꞌune coꞌol jꞌelan jech chac cꞌu chaꞌal ti smucꞌ ta aqꞌuil ti uvae. Ti Jtote coꞌol sꞌelan jech chac cꞌu chaꞌal ti jchabiej uvae. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ti scꞌob-cꞌobtac ti uva ti mu xacꞌ ti sate ta sboj loqꞌuel. Pero ti bu lec ta xacꞌ ti sate ta sloqꞌuesbe ti scꞌaꞌepale. Ta set loqꞌuel ti bu taquijemique yoꞌ jech ta xacꞌ lec ti sate. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ti voꞌoxuque lecubtasbiloxuc xa ta sventa ti cꞌu sꞌelan laj jchanubtasoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Junuc avoꞌntonic ta jtojol jech chac cꞌu chaꞌal ti jun coꞌnton ta atojolique. Ti jun scꞌobe mu xuꞌ ta xacꞌ sat ta stuc noꞌox ti mi muꞌyuc tsacal schiꞌuc ti smucꞌ ta aqꞌuile. Jaꞌ jech ti voꞌoxuque muꞌyuc cꞌusi lec ta xapasic ti mi mu junuc avoꞌntonic ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Vuꞌunun ti smucꞌ ta aqꞌuile. Voꞌoxuc ti scꞌob-cꞌobtaque. Ti buchꞌu jun yoꞌnton ta jtojole, jun coꞌnton ta stojol ec. Ep ta xacꞌ ti sate. Yan ti mi chꞌacaloxuc ta jtojole, muꞌyuc cꞌusi xuꞌ avuꞌunic. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ti buchꞌu ta xchꞌac sba ta jtojole ta xichꞌ setel loqꞌuel. Ta xtaquij jech chac cꞌu chaꞌal scꞌobtac ti uvae. Ta xichꞌ tsobel yoꞌ jech ta xichꞌ chiqꞌuel ta cꞌocꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mi staoj yav jun avoꞌntonic ta jtojole, mi mu xchꞌay ta avoꞌntonic ti cꞌu sꞌelan laj jchanubtasoxuque, cꞌanbeic ti Dios ti cꞌusi ta xacꞌanique, ta xaꞌacꞌbatic. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ti mi lec ti cꞌusi ta xapasique, ta xavaqꞌuic ta ichꞌel ta mucꞌ ti Jtote. Jaꞌ jech xtoc umbi, ta xacꞌotic ta batsꞌi cajchancꞌoptac. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ti vuꞌune cꞌux ta xacaꞌioxuc jech chac cꞌu chaꞌal cꞌux ta xiyaꞌi ti Jtote. Tey me oyuc o ta avoꞌntonic ti cꞌux ta xcaꞌioxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ti mi ta xachꞌunic ti jmantale, staoj yav ta xavaꞌiic ti scꞌuxul coꞌntone jech chac cꞌu chaꞌal ti vuꞌun ta jchꞌunbe smantal ti Jtote ti staoj yav ta xcaꞌi ti scꞌuxul yoꞌnton ta jtojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ti jech laj calboxuc ti junuc avoꞌntonic ta jtojole, jaꞌ ta sventa yoꞌ jech ta xataic ti xamuyubajique jech chac cꞌu chaꞌal ti ximuyubaje. Jech ta xataic ti jun yutsil ti acuxlejalique. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jaꞌ jech ti jmantal liꞌe: Cꞌux me xavaꞌi abaic jech chac cꞌu chaꞌal cꞌux ta xcaꞌioxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ti jech echꞌem cꞌux ta xcaꞌi jbatique, jaꞌ ti ta xcacꞌ jbatic ta milel yuꞌun ti buchꞌu lec xquil jbatic schiꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ti voꞌoxuque lec ta xquil jbatic ti mi ta xapasic ti cꞌusi ta xcalboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Maꞌuc xa mosoviloxuc ta xcalboxuc. Yuꞌun ti mosovile mu snaꞌ cꞌusi ta spas ti yajvale. Jech o xal un, lec xquil jbatic, xacutoxuc. Yuꞌun laj xa cacꞌboxuc anaꞌic scotol ti cꞌu sꞌelan laj yalbun ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ti voꞌoxuque moꞌcoxuc laj atꞌujicun. Vuꞌun laj jtꞌujoxuc. Laj jtꞌujoxuc yoꞌ ta xba apasic ti cꞌusi leque ti jaꞌ sventa sbatel osile. Jech ti Jtote ta xayacꞌboxuc ti cꞌusi ta xacꞌanic ta jventae. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jech o xal un, jaꞌ jech ti jmantal ta xcalboxuque: Cꞌux me xavaꞌi abaic ta jujun tal. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Ti mi ta xascrontainoxuc ti cristianoetique, naꞌic me ti jech laj scrontainicun ta baꞌyele. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ti coꞌoluc ta xapasic schiꞌuc ti cristianoetique, cꞌux ta xaꞌioxuc jech chac cꞌu chaꞌal cꞌux ta xaꞌi sbaique. Pero ti vuꞌune laj jtꞌujoxuc loqꞌuel talel ta stojolic ti cristianoetique. Jech o xal un, cronta ta xayiloxuc. Yuꞌun mu xa coꞌoluc avoꞌntonic schiꞌuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Juleso me ta avoꞌntonic ti jech laj calboxuque: “Ti mosovile maꞌuc cajal ta xacꞌ sba ta stojol ti yajvale”, ti xichie. Ti mi laj quichꞌ ilbajinele, jaꞌ noꞌox jech ta xavichꞌic ilbajinel ec. Jaꞌ jech xtoc ti mi ta xchꞌunic ti cristianoetic ti cꞌu sꞌelan laj jchanubtasoxuque, jaꞌ jech ta xachꞌunbat acꞌopic ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ti voꞌoxuque ta onoꞌox xavichꞌic ilbajinel ta jventa. Yuꞌun mu xojtiquinic ti Buchꞌu laj stacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ti cristianoetique muꞌyuc smulic ti jechuque ti manchuc lital jchanubtase. Pero avi tana liꞌe, muꞌyuc xa cꞌusi xuꞌ spac o scꞌoplal yuꞌun ti smulique. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ti buchꞌu xtiꞌet sjolic ta jtojole, xtiꞌet sjolic ta stojol ti Jtot eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Muꞌyuc smulic ti cristianoetic jechuque ti manchuc laj yilic ti cꞌusi laj jpas ti muꞌyuc buchꞌu yan ti jech ta spase. Pero laj xa yilic. Manchuc mi jech laj yilic ti cꞌusi laj xa jpase, pero xtiꞌet sjolic ta jtojol. Xtiꞌet sjolic ta stojol ti Jtot eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ti jech xtiꞌet sjolic ta jtojole, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal tsꞌibabil ta mantal yuꞌunique: “Ta jecheꞌ noꞌox xtiꞌet sjolic ta jtojol”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Pero cꞌalal ta xtal ti Chꞌul Espíritu ti jaꞌ melele, ti ta jcꞌanbe talel ti Jtote, jaꞌ ta scoltaoxuc, jaꞌ ta smuqꞌuibtasboxuc avoꞌntonic. Yuꞌun ti Chꞌul Espíritue jaꞌ ta xalboxuc avaꞌiic ti jcꞌoplale. ");
INSERT INTO tzotzc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jaꞌ jech ti voꞌoxuc eque ta xavalbeicun jcꞌoplal yuꞌun ta sliquebal onoꞌox laj achiꞌinicun talel. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Jech ta xcalboxuc avaꞌiic yoꞌ jech mu xchibaj avoꞌntonic cꞌalal muꞌyuc liꞌ oyune. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yuꞌun ta xavichꞌic jipel loqꞌuel ta chꞌul naꞌ. Ta xcꞌot ta pasel xtoc ti mi oy buchꞌu ta xasmiloxuque, ta snopic ti jaꞌ jech ta xtunic yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ti jech ta spasboxuque, yuꞌun mu xojtiquinic ta jꞌechꞌel ti Jtote. Mi jaꞌuc ta xiyojtiquinic ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ti cꞌalal ta xavilic ti jech ta xcꞌot ta pasele, jaꞌ me juleso ta ajolic ti jech onoꞌox laj calboxuc avaꞌiique. ’Ta sliquebal, muꞌyuc laj calboxuc avaꞌiic ti ta xavichꞌic ilbajinele, yuꞌun liꞌ to jchiꞌinojoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero avi tana liꞌe, tey ta xibat ta stojol ti Buchꞌu laj stacun talele. Ti bu ta xibate, muꞌyuc buchꞌu junucal avuꞌunic ta sjacꞌ ti bu ta xibate. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yuꞌun jaꞌ noꞌox laꞌochic ta at oꞌnton yuꞌun ti jech laj calboxuc taje. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ti jech ta xibate, jamal ta xcalboxuc avaꞌiic ti jaꞌ más leque. Yuꞌun jaꞌ alequilalic. Yuꞌun ti mi mu xibate, mu xtal ta atojolic ti Buchꞌu ta scoltaoxuque, ti ta xacꞌ smucꞌul avoꞌntonique. Yan ti mi libate, ta jtac talel. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cꞌalal jech ta xtal ti Chꞌul Espíritue, jaꞌ ta xacꞌbe snaꞌic ti cristianoetique ti oy ti smulique. Jaꞌ jech xtoc ta xꞌacꞌbat snaꞌic ti oy jun lequilale. Jaꞌ jech xtoc ta xꞌacꞌbat snaꞌic ti ta xichꞌic chapanel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oy smulic, jaꞌ ti mu xischꞌunicune. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tey ta xilic ti oy jun lequilale, yuꞌun ti vuꞌune ta xibat ti bu oy ti Jtote. Jech ti voꞌoxuque, slajeb xa ti liꞌ aqꞌuelojbeicun ti jsate. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tey ta xꞌacꞌbat snaꞌic ti chapanel yuꞌun ti Diose, yuꞌun laj xa yichꞌ chapanel ta yichꞌel castigo ti jpasmantal yuꞌun ti sba banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Acꞌo mi oy to ep ti cꞌusi ta jcꞌan ta xcalboxuc avaꞌiique, pero mu to xuꞌ xavaꞌibeic ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cꞌalal ta xtal ti Chꞌul Espíritu ti jaꞌ melele, jaꞌ ta xacꞌboxuc anaꞌic scotol ti melele. Mu ta yoꞌntonuc stuc ti cꞌusi ta xale. Jaꞌ ta xal ti cꞌusi ta xꞌalbat yuꞌun ti Jtote. Jaꞌ jech xtoc ta xacꞌboxuc anaꞌic ti cꞌusitic ta to xcꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ti Chꞌul Espíritue jaꞌ ta xiyacꞌ ta ichꞌel ta mucꞌ. Yuꞌun ti cꞌusitic laj cal laj jpase, jaꞌ ta xacꞌboxuc anaꞌic scotol. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Scotol ti cꞌusitic oy yuꞌun ti Jtote, jaꞌ cuꞌun ec. Jech o xal un, laj calboxuc avaꞌiic scꞌoplal ti Chꞌul Espíritue, yuꞌun jaꞌ ta xichꞌ ta sventa ti cꞌusitic oy cuꞌune, yoꞌ jech ta xacꞌboxuc avojtiquinic ti voꞌoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mu xa jaluc ti ta xavilicun liꞌe. Tsꞌacal to ta xlic avilicun. Yuꞌun ta xibat ti bu oy ti Jtote ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oy jlom ti yajchancꞌoptaque jech lic sjacꞌbe sbaic ta jujun tale: ―¿Cꞌusi smelol ti jech ta xal taje? Yuꞌun ta xal ti mu xa jaꞌuc ti liꞌ ta jqꞌueltique. Jaꞌ jech xtoc ta xal ti tsꞌacal to ta xlic jqꞌueltique. ¿Cꞌusi taje ti ta xbat ti bu oy ti Totile? ");
INSERT INTO tzotzc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Mu xa jaluc”, ti xie. ¿Cꞌusi smelol ta xal? Mu xcaꞌitic smelol ti jech ta xcꞌopoje ―xiic ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ti Jesuse laj yil ti oy cꞌusi ta xjacꞌbate. Jech o xal jech laj yal: ―Laj cal: “Mu xa jaluc ti ta xavilicun liꞌe. Tsꞌacal to ta xlic avilicun”, ti xichie. ¿Mi jaꞌ ta xajacꞌbe abaic ta sventa ti jech laj cale? ");
INSERT INTO tzotzc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ta melel ta xcalboxuc avaꞌiic, ta xlic ocꞌanic. Ta xavat avoꞌntonic. Yan ti cristianoetic ti uninbilic yuꞌun ti sba banomile ta xlic muyubajicuc. Ti jech ta xavat avoꞌntonique, ta xlic joybijuc ta smuyubajel avoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cꞌalal ta svoqꞌues yol ti jun antse, mu xꞌechꞌ ta xaꞌi ti svocole. Yuꞌun sta xa yorail ti scꞌuxule. Tsꞌacal to un, mi vocꞌ xa ti yole, ta xchꞌay ta yoꞌnton ti scꞌuxule. Yuꞌun xmuyubaj xa ti lec vocꞌ ti yole. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaꞌ jech ti voꞌoxuque, mu xꞌechꞌ ta xavaꞌiic ti avocolique. Pero cꞌalal ta xisut talel jqꞌueloxuque, ta xlic muyubajuc ti avoꞌntonique. Jaꞌ jun smuyubajel avoꞌntonic ti muꞌyuc buchꞌu xaspojboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Cꞌalal jech ta xcꞌot scꞌacꞌalil taje, muꞌyuc xa cꞌusi ta xajacꞌbeicun. Ta melel ta xcalboxuc avaꞌiic, scotol ti cꞌusi ta xacꞌanbeic ti Jtot ta jventae, ta xayacꞌboxuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Avi liꞌe mu to cꞌusi acꞌanojbeic ti Jtot ta jventae. Pero cꞌanic. Jech ta xavichꞌic ec, yoꞌ jech ta xataic ti smuyubajel avoꞌntonique. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ta babacꞌop laj jcꞌoponoxuc to ox. Pero ta sta yorail ti maꞌuc xa ta babacꞌop ta jcꞌoponoxuque. Yuꞌun jamal ta xcalboxuc avaꞌiic liquel scꞌoplal ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti jech cꞌacꞌal taje cꞌalal ti oy cꞌusi ta xacꞌanbeic ti Jtot ta jventae, mu xa persauc ti ta jcꞌanbe vocol ti Jtot ta aventaique. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yuꞌun ti Jtote cꞌux ta xayaꞌioxuc. Cꞌux ta xaꞌioxuc, jaꞌ ti cꞌux ta xavaꞌiicune. Jaꞌ jech xtoc laj achꞌunic ti liquemun talel ta stojol ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Lilic talel ta stojol ti Jtote yoꞌ jech lital liꞌ ta sba banomile. Avi tana un, ta xquicta comel ti sba banomile. Ta xisut batel ti bu oy ti Jtote ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ti yajchancꞌoptaque jech laj yalic: ―Avi tana un, jamal ta xavalbuncutic. Yuꞌun maꞌuc xa ta babacꞌop ta xacꞌopoj. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ta xquilcutic ti ta xanaꞌ scotole. Yuꞌun mu xa persauc ta jacꞌbotcutic. Jech o xal ta jchꞌuncutic ti liquemot talel ta stojol ti Diose ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jech laj stacꞌ ti Jesuse: ―¿Mi jech ta xachꞌunic tana liꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jaꞌ xa yorail tana liꞌ une ti tan puc ta xabatic ti voꞌoxuque. Yuꞌun ta xavictaicun comel jtuc. Pero mu jtucuc ta xicom. Yuꞌun xchiꞌinojun ti Jtote. ");
INSERT INTO tzotzc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jaꞌ jech laj calboxuc avꞌiic taje, yoꞌ jech jun avoꞌntonic ta jtojol. Yuꞌun ti liꞌ ta sba banomile ta xlic avichꞌ avocolic. Pero tsotsanic me. Yuꞌun tsal xa cuꞌun ti sba banomile ―xut ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ti cꞌalal laj cꞌopojuc ti Jesuse, tey laj sqꞌuel muyel ti vinajele. Jech laj yal: ―Sta xa yorail, Tot, acꞌo ta ichꞌel ta mucꞌ ti Anichꞌonune yoꞌ jech ta xacꞌot ta ichꞌel ta mucꞌ ti Anichꞌonun eque. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yuꞌun avacꞌojbun cabtel ti jbainoj scotol ti cristianoetique yoꞌ jech ta staic scuxlejalic sbatel osil ti buchꞌutic laj avacꞌbune. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ti jech ta staic ti scuxlejalic sbatel osile, jaꞌ ta sventa ta xyojtiquinot ti atuc noꞌox Diosot ta melele, schiꞌuc ta xiyojtiquinicun ti vuꞌun Jcoltavanejun ti laj atacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ti vuꞌune laj xa cacꞌot ta ichꞌel ta mucꞌ liꞌ ta sba banomile. Jaꞌ jech xtoc tsuts xa cuꞌun ti cabtel ti laj avacꞌbun jpase. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Avi tana un, Tot, acꞌun ta ichel ta mucꞌ ti tey ta atojole jech chac cꞌu chaꞌal quichꞌoj to ox ta atojol ti cꞌalal muꞌyuc to ox meltsajem ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ti buchꞌutic laj xa atꞌuj loqꞌuel ti liꞌ ta sba banomile, ti laj avacꞌbune, laj xa cacꞌbe snaꞌic ti Buchꞌuot ta melele. Ti buchꞌutic laj avacꞌbune jaꞌ avuꞌun onoꞌox. Jaꞌ jech xtoc laj xa xchꞌunic ti acꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Scotol ti cꞌusi laj xa avacꞌbune, avi tana un, laj xa snaꞌic ti tey liquem talel ta atojole. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yuꞌun laj xa calbe yaꞌiic ti acꞌop ti laj avacꞌbune. Jech ti stuquique laj xa xchꞌunic. Laj yilic ti ta melel liquemun talel ta atojole. Jech o xal un, ta xchꞌunic ti laj atacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ta xa jcꞌanbot vocol yuꞌunic ti buchꞌutic laj avacꞌbune. Maꞌuc ta jcꞌanbot vocol yuꞌunic ti buchꞌutic ventainbilic yuꞌun ti sba banomile. Jaꞌ noꞌox ta jcꞌanbot vocol yuꞌunic ti buchꞌutic laj avacꞌbune. Yuꞌun jaꞌ avuꞌuntac. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Scotol ti cuꞌuntaque, jaꞌ avuꞌun. Ti avuꞌuntaque, jaꞌ cuꞌun ec. Jaꞌ jech xtoc ti cutsilale xojobin ta stojolic. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Mu xa liꞌuc ta xicom ta sba banomile. Yan ti stuquique liꞌ ta xcomic ta sba banomile. Yuꞌun ta xtal jchiꞌinot, Jchꞌul Tot. Chabio me ta amucꞌul ta atsatsal ti buchꞌu laj xa avacꞌbune, yoꞌ jech coꞌoluc yoꞌntonic jech chac cꞌu chaꞌal ti voꞌotique. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ti cꞌalal laj jchiꞌin liꞌ ta banomil ti buchꞌutic laj avacꞌbune, lec laj jchabi ta sventa ti amucꞌul atsatsale. Mi junuc ichꞌay. Jaꞌ noꞌox ichꞌay ti buchꞌu chꞌayem xa onoꞌoxe yoꞌ ta xcꞌot ta pasel jech chac cꞌu chaꞌal tsꞌibabil ta acꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Avi tana un, tey xa ta xital ti bu oyote. Pero yoꞌ to liꞌ oyun ta banomile jech ta jcꞌoponic comel ti buchꞌutic laj xa avacꞌbune, yoꞌ jech ta staic ti xmuyubaj yoꞌntonic jech chac cꞌu chaꞌal ti vuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Laj xa calbe yaꞌi ti acꞌope. Pero crontainbilic yuꞌun ti cristianoetique. Yuꞌun ti stuquique mu xa coꞌoluc yoꞌntonic schiꞌuc ti cristianoetique jech chac cꞌu chaꞌal ti vuꞌune ti mu coꞌoluc coꞌnton schiꞌuque. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Maꞌuc ta jcꞌanbot ti ta xachꞌac loqꞌuel ta stojol ti cristianoetique. Yuꞌun jaꞌ noꞌox ta jcꞌanbot vocol ti ta xapoj yoꞌ jech mu stsalatic yuꞌun ti pucuje. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jech chac cꞌu chaꞌal ti vuꞌun ti mu coꞌoluc coꞌnton schiꞌuc ti cristianoetic liꞌ ta banomile, jaꞌ jech ti stuqique, mu xa coꞌoluc yoꞌntonic schiꞌuc ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ti buchꞌutic laj avacꞌbune, lecubtaso atuc ta sventa ti melele. Ti achꞌul cꞌope, jaꞌ ti melele. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jech chac cꞌu chaꞌal laj atacun talel ta stojol ti cristianoetique, jaꞌ jech ti stuquique ta jtac batel ta stojol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta sventa ti stuquique jech ta xcacꞌ jba ta avoc ta cꞌob yoꞌ jech ta xitun avuꞌun, yoꞌ jech ti stuquique lecubtasbilic ta xcꞌotic ta jventa. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Maꞌuc noꞌox ta jcꞌanbot vocol yuꞌun ti stuquique. Jaꞌ jech xtoc ta xa jcꞌanbot vocol yuꞌunic ti buchꞌutic tsꞌacal to ta xlic xchꞌunicun ta sventa ti ta xlic yaꞌiic ti acꞌop ti ta xꞌalbatique. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta jcꞌanbot vocol ti scotolicuc ti coꞌoluc o ti yoꞌntonique. Ti junuc yoꞌntonic ta jtojoltique jech chac cꞌu chaꞌal ti oyot ta jtojole, ti oyun ta atojol eque, Tot. Ta jcꞌan ti coꞌoluc ti yoꞌntonique, yoꞌ jech ta xchꞌunic ti cristianoetique ti voꞌot laj atacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Laj xa cacꞌbe yichꞌic ti jlequilal ti laj avacꞌbune yoꞌ jech jun yoꞌntonic jech chac cꞌu chaꞌal ti junotique. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tey oyun ta stojolic jech chac cꞌu chaꞌal oyot ta jtojole yoꞌ jech ti stuquique ta xcꞌotic ta jun yoꞌntonic ta jbel scꞌoplal. Jech ti cristianoetique ta xlic yilic ti voꞌot laj atacun talele, ti toj cꞌux ta xavaꞌie jech chac cꞌu chaꞌal cꞌux ta xavaꞌiune. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tot, ti buchꞌutic laj xa avacꞌbune, ta jcꞌan ti tey oyicuc ti bu ta xicꞌote, yoꞌ jech ta xilic ti jlequilal ti laj avacꞌbune. Yuꞌun acꞌuxubinojun onoꞌox ti cꞌalal muꞌyuc to ta xlic meltsajuc talel ti banomile. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Jchꞌul Tot, ti cristianoetic ti buchꞌutic sventainojic ti sba banomile mu xayojtiquinot. Ti vuꞌune xacojtiquin. Ti buchꞌu laj xa avacꞌbune laj xa snaꞌic ti voꞌot laj atacun talele. ");
INSERT INTO tzotzc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Laj xa cacꞌbe snaꞌic ti Buchꞌuote. Pero ta to xcacꞌbe snaꞌic más yoꞌ jech ta xcꞌot ta yoꞌntonic ti scꞌuxul avoꞌnton ti oy ta jtojole, yoꞌ jech oyun ta stojolic ―xut ti Stote. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cꞌalal laj yoꞌnton ta scꞌoponel Dios ti Jesuse, iloqꞌuic batel schiꞌuc ti yajchancꞌoptaque. Batic ta jot stiꞌil ucꞌum Cedrón. Ti teye oy tsꞌunobaltic. Tey iꞌochic batel ti Jesuse schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ti Judase, jaꞌ ti jꞌacꞌvanej ta cꞌabale, xojtiquin lec ti tsꞌunobaltic taje. Jaꞌ ti ep ta velta tey ta xcꞌot stsob sbaic ti Jesuse schiꞌuc ti yajchancꞌoptaque. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tey icꞌot ti Judase schiꞌuc soldadoetic, schiꞌuc mayoletic yuꞌun ti temploe ti jaꞌ tacbilic batel yuꞌunic ti banquilal paleetique, schiꞌuc ti jfariseoetique. Chapalic batel schiꞌuc yabtejebic, schiꞌuc yinternoic, schiꞌuc stojic. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero ti Jesuse snaꞌoj xa onoꞌox scotol ti cꞌusi ta xcꞌot ta pasel ta stojole. Tey ilocꞌ batel. Jech laj sjacꞌ: ―¿Buchꞌu ta xasaꞌic? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jech laj stacꞌ ti stuquique: ―Jaꞌ ti Jesús ta Nazarete ―xutic. Ti Jesuse jech laj stacꞌ: ―Vuꞌunun ―xi. Ti Judase, ti jaꞌ jꞌacꞌvanej ta cꞌabale, tey xa schiꞌuc ti jtsacvanejetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cꞌalal vuꞌunun ti xi ti Jesuse, sutic ta svalopatic ti jtsacvanejetique. Tey ilomic ta lum. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ti Jesuse jech laj xchaꞌjacꞌ: ―¿Buchꞌu ta xasaꞌic? ―xi. Ti stuquique jech laj yalic: ―Jaꞌ ti Jesús ta Nazarete ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ti Jesuse jech laj yal: ―Laj xa calboxuc avaꞌiic ti vuꞌunune. Mi vuꞌun ta xasaꞌicune, chꞌan utic ti jchiꞌiltaque, acꞌo baticuc ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ti jech laj yale, jaꞌ ta sventa yoꞌ ta xcꞌot ta pasel jech chac cꞌu chaꞌal laj yal stuc ti Jesuse: “Ti buchꞌutic laj yacꞌbun ti Jtote, mu junuc ichꞌayic cuꞌun”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jech ti Simón Pedroe laj snit loqꞌuel ti yespada yichꞌoje. Laj sbojbe sbatsꞌi chiquin ti Malco sbie, ti jaꞌ smosov ti banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ti Jesuse jech laj yalbe ti Pedroe: ―Ticꞌo ta sna ti avespadae. Mi locꞌ xa ta yoꞌnton ti Jtot ti ta xquichꞌ ti jvocole, ¿mi yuꞌun xavacꞌtouc mu ta xquichꞌ ti jvocole? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ti soldadoetique schiꞌuc ti banquilal yuꞌunique, schiꞌuc ti mayoletic yuꞌun ti jꞌisraeletique, laj stsaquic laj xchuquic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tey laj yiqꞌuic batel ta sna ti Anase. Ti Anase jaꞌ smuniꞌ ti Caifase. Ti Caifase, jaꞌ o sjabilal ti tiqꞌuil ta banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ti Caifás taje, jaꞌ onoꞌox ti laj yalbe yaꞌiic ti jꞌisraeletique: “Jaꞌ lec ti acꞌo chamuc jun noꞌox vinic ta sventa ti jlumaltique”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ti Simón Pedroe schiꞌuc ti jun jchancꞌope tijilic batel ta spat ti Jesuse. Ti jun jchancꞌope lec ojtiquinbil yuꞌun ti banquilal palee. Jech o xal un, jmoj ochic batel schiꞌuc ti Jesús ta yamaqꞌuil sna ti banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yan ti Pedroe tey icom ta spat tiꞌ moc. Jech o xal ti jun jchancꞌop ti ojtiquinbil yuꞌun ti banquilal palee, ilocꞌ batel. Bat scꞌopon ti meꞌ jqꞌuel tiꞌ moque. Tey laj yacꞌ ochuc ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ti meꞌ jqꞌuel tiꞌ moque laj sjacꞌbe ti Pedroe: ―¿Mi maꞌuc jun yajchancꞌopot ti vinic leꞌe? ―xi. Jech laj stacꞌ ti Pedroe: ―Moꞌcun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Toyol ti sique. Jech o xal ti mosoviletique schiꞌuc ti mayoletique laj stsanic cꞌocꞌ. Tey ivaꞌi cꞌatinicuc. Jech ti Pedroe tey ivaꞌi cꞌatinuc schiꞌuc ti mayoletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ti banquilal paleetique lic sjacꞌbeic ti Jesuse buchꞌutic ti yajchancꞌoptaque schiꞌuc cꞌusi ti ta xchanubtasvane. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jech laj yal ti Jesuse: ―Muꞌyuc cꞌusi ta mucul lichanubtasvan. Yuꞌun tey laj jvaꞌan jba ta xchanubtasel ti cristianoetic ta temploe, schiꞌuc ti ta chꞌul naetic ti bu ta stsob sbaic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Cꞌu chaꞌal ti vuꞌun ta xajacꞌbeicune? Jaꞌ jacꞌbeic ti cristianoetique. Jaꞌ snaꞌ stuquic ti cꞌu sꞌelan laj jchanubtase. Acꞌo yal avaꞌiic stuquic ti cꞌu sꞌelan laj jchanubtase ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cꞌalal jech laj yal ti Jesús taje, tey vaꞌal jun mayol yuꞌun ti temploe laj yacꞌbe majel ta sat. Jech laj yalbe: ―¿Mi jaꞌ jech ta xatacꞌbe ti banquilal pale taje? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jech laj stacꞌ ti Jesuse: ―Ti mi oy cꞌusi chopol laj cale, albun caꞌi ti cꞌusi chopole. Yan ti mi lec ti cꞌusi laj cale, ¿cꞌu chaꞌal ta xamajun? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jech ti Anase chucul laj stac batel ta stojol ti banquilal pale Caifase. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti jech tey vaꞌal ta xcꞌatin ta tiꞌ cꞌocꞌ ti Pedroe, jech ijacꞌbat: ―¿Mi maꞌuc jun yajchancꞌopot ti vinic leꞌe? ―xꞌutat. Ti Pedroe mu jamaluc laj yal: ―Moꞌcun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tey oy jun yajmosov ti banquilal palee, ti jaꞌ yutsꞌ yalal ti buchꞌu laj sbojbe schiquin ti Pedroe. Jech laj sjacꞌ: ―¿Mi mu lajuc quilot tey ta tsꞌunobaltic schiꞌuc ti vinic leꞌe? ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ti Pedroe tey laj smuc ta yoꞌnton yan velta ti Jesuse. Jaꞌ o tey lic ocꞌuc ti cotse. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Icꞌbil loqꞌuel ti Jesuse ta sna ti Caifase. Yicꞌojic batel ta cabilto yuꞌun ti gobernadore. Ti jꞌisraeletique muꞌyuc xꞌochic batel ta cabilto yoꞌ jech mu sta smulic ti cꞌu sꞌelan liquem yuꞌunique, yoꞌ jech xuꞌ ta xveꞌic ta sventa ti qꞌuin Colele. Yuꞌun ta xa sacub talel ti osile. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jech o xal ti Pilatoe ilocꞌ batel. Laj sjacꞌbe ti jchapanvanej jꞌisraeletique: ―¿Cꞌusi smul avuꞌunic ti vinic liꞌe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jech laj staqꞌuic: ―Ti muꞌyucuc tsots ti smule, muꞌyuc xquicꞌcutic talel ta atojol ti jechuque ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jech laj stacꞌ ti Pilatoe: ―Iqꞌuic batel. Chapanic atuquic coꞌol jech chac cꞌu chaꞌal ta xal ti mantal avuꞌunique ―xꞌutatic. Ti jꞌisraeletique jech laj staqꞌuic: ―Ti vuꞌuncutic jꞌisraeluncutique muꞌyuc quichojcutic mantal ti xuꞌ ta ximilvancutique ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jaꞌ jech icꞌot ta pasel ti laj yal ti Jesús ti cꞌu sꞌelan ta xchame. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ti Pilatoe chaꞌoch batel ta cabilto. Laj yicꞌ ochel ti Jesuse. Jech laj sjacꞌbe: ―¿Mi voꞌot ajvalilot yuꞌun ti jꞌisraeletique? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jech laj yal ti Jesuse: ―¿Mi ta ajol atuc ti jech ta xajaqꞌue? ¿Mi yuꞌun oy buchꞌu laj yalbot avaꞌi ti jcꞌoplale? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jech laj stacꞌ ti Pilatoe: ―¿Mi yuꞌun jꞌisraelun ec? Jaꞌ laj yacꞌot ta coc ta jcꞌob ti ateclumale, ti banquilal paleetique. ¿Cꞌusi laj apas? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jech laj stacꞌ ti Jesuse: ―Ti jech Ajvalilune, maꞌuc liꞌ ta sba banomile. Ti yuꞌunuc jaꞌuque, laj xa sliques cꞌop ti cajchancꞌoptac ti jechuque, yoꞌ jech mu xistsaquicun ti jteclumale. Pero liꞌe, maꞌuc liꞌ ti ta xiꞌoch ta Ajvalilale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ti Pilatoe jech laj yal: ―Ati xcaltic un chaꞌe, voꞌot ti ajvalilote ―xi. Jech laj stacꞌ ti Jesuse: ―Ajvalilun jech chac cꞌu chaꞌal ta xavale. Yuꞌun jaꞌ jtu ti tal vocꞌcun ta sba banomile, yoꞌ tal cal ti melel ta stojol ti cristianoetique. Scotolic ti buchꞌutic ta xchꞌunic ti melele, ta xaꞌiic ti cꞌusi ta xcale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jech laj stacꞌ ti Pilatoe: ―¿Cꞌusi ti melele? ―xut. Cꞌalal jech laj sjaqꞌue, ilocꞌ batel ti Pilatoe. Bat scꞌopon ti jꞌisraeletique. Jech laj yal: ―Mu jutebuc laj jtabe smul ti vinic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ti voꞌoxuque jech stalel liquem avuꞌunic ti ta yorail qꞌuin Colele ta xacꞌanic ti ta jcolta batel jun jchuquele. Jech o xal un, ¿mi jaꞌ ta xacꞌanic ti ta jcolta batel ti ajvalil avuꞌunic ta xavalique? ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ta jech to yepal jech lic avanicuc scotolic: ―Mu xacolta leꞌe. Jaꞌ coltao batel ti Barrabase ―xutic. Ti Barrabás taje jaꞌ jun jꞌelecꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jech o xal ti Pilatoe laj yal mantal ti acꞌo yichꞌ tsitsel ta nucul ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jech ti soldadoetique laj yacꞌbeic slap xotbil chꞌix ta sjol ti Jesuse. Jaꞌ jech xtoc laj yacꞌbe slap cꞌuꞌil ti icꞌicꞌ losantic sba stsajale. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tsꞌacal to un, lic sjoy sbaic ta slabanel ti Jesuse. Jech laj yalic: ―Toj lec mucꞌ ta ajvalilot yuꞌun ti jꞌisraeletique ―xutic. Ta xacꞌbeic majel ta sat. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ti Pilatoe chaꞌlocꞌ batel. Jech laj yal: ―Qꞌuel avilic, ta xquicꞌ loqꞌuel tal ti vinique. Ta jvaꞌan ta atojolic yoꞌ jech ta xavaꞌic ti mu jtabe jutebuc ti smule ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jech ti Jesuse slapoj loqꞌuel ti xotbil chꞌix ta sjole schiꞌuc ti cꞌuꞌil ti icꞌicꞌ losantic sba stsajale. Ti Pilatoe jech laj yal: ―Liꞌ oy ti vinique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cꞌalal jech laj yilic ti banquilal paleetique schiꞌuc ti mayoletique, jech lic avanicuc: ―¡Jipano ta cruz! ¡Jipano ta cruz! ―xiic. Ti Pilatoe jech laj yal: ―Ba jipanic ta cruz ti voꞌoxuque. Yuꞌun mu jtabe jutebuc smul ti vinic liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ti jꞌisraeletique jech laj staqꞌuic: ―Oy mantal cuꞌuncutic. Ti mantal cuꞌuncutique ta xal ti acꞌo chamuque. Yuꞌun ta sbis sba ta Snichꞌon Dios ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cꞌalal jech laj yaꞌi ti Pilato taje, más to och xiꞌel ta yoꞌnton. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ichaꞌoch batel ta cabilto. Jech laj sjacꞌbe ti Jesuse: ―¿Bu liquemot talel? ―xut. Pero muꞌyuc cꞌusi laj stacꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ti Pilatoe jech laj yal: ―¿Cꞌu chaꞌal ti mu xatacꞌbune? ¿Mi mu xanaꞌ ti oy cabtel ti xuꞌ ta jipanot ta cruze, jaꞌ jech xtoc ti oy cabtel ti xuꞌ ta jpojote? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jech laj stacꞌ ti Jesuse: ―Muꞌyuc cꞌusi xuꞌ avuꞌun ta jtojol ti manchuc laj yacꞌbot avabtel ti Diose. Pero ti buchꞌu tal yacꞌun ta acꞌobe, jaꞌ toj ep smul, mu sta ti voꞌote ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cꞌalal jech laj yaꞌi taje, tey lic saꞌolan ti Pilato ti cꞌu sꞌelan xuꞌ ta scolta batel ti Jesuse. Pero ti jꞌisraeletique jech lic yavtaic: ―Mi ta xacolta batel ti vinique, maꞌuc lequil jtunelot yuꞌun ti mucꞌ ta ajvalil Césare. Buchꞌuuc noꞌox ti ta sbis sba ta ajvalile, jaꞌ yajcronta ti ajvalil Césare ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cꞌalal jech laj yaꞌi ti Pilato taje, laj yal mantal ti acꞌo sloqꞌuesic batel ti Jesús ti bu oye. Jech ti Pilatoe tey bat chotluc ta chapanobbail ti jaꞌ Gabata sbi ta hebreo cꞌope. Pacbil ton, xi ti smelole. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nopol xa batel oꞌlol cꞌacꞌal ti scꞌacꞌalil ti mu to ta xlic ti qꞌuin Colele cꞌalal jech laj yal ti Pilato ta stojol ti jꞌisraeletique: ―Liꞌ oy ti ajvalil avuꞌunique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero ti stuquique jech lic avanicuc: ―¡Acꞌo chamuc! ¡Acꞌo chamuc! ¡Jipano ta cruz! ―xutic. Ti Pilatoe jech laj yal: ―¿Mi yuꞌun vuꞌun ta jipan ta cruz ti ajvalil avuꞌunique? ―xi. Pero ti banquilal paleetique jech laj staqꞌuic: ―Jaꞌ noꞌox ajvalil cuꞌuncutic ti Césare. Muꞌyuc yan ajvalil ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Cꞌalal jech laj yaꞌi ti Pilato taje, laj yacꞌ batel ta cꞌabal ti Jesuse yoꞌ jech ta xichꞌ jipanel ta cruz. Jech ti stuquique laj yiqꞌuic batel. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ti Jesuse ilocꞌ batel, xcuchoj batel ta snequeb ti scruzale, yoꞌ jech ta xbat ti bu Baquil Jolil sbiinoje. Gólgota ti sbi ta hebreo cꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jaꞌ tey laj sjipanic ta cruz ti Jesuse. Tey laj sjipanic ta cruz yan chaꞌvoꞌ xtoc. Ta oꞌlol oy ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Laj yal mantal ti Pilatoe ti acꞌo yichꞌ aqꞌuel sletrail ti sjol scruzale: “Jesús ta Nazaret, jaꞌ ajvalil yuꞌunic ti jꞌisraeletique”, xi ti letrae. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ep ta jmec ti jꞌisraeletique ta sqꞌuelic ti cꞌusi ta xal ti letrae. Yuꞌun ti bu laj sjipanic ta cruz ti Jesuse nopol noꞌox ti jteclume. Jech xtoc ti letrae tsꞌibabil ta hebreo, ta griego, schiꞌuc ta latín cꞌop. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jech o xal ti banquilal paleetic yuꞌun ti jꞌisraeletique jech laj yalbeic ti Pilatoe: ―Cꞌu chaꞌal laj atsꞌiba jech leꞌe ti ta xal: “Ajvalil yuꞌun ti jꞌisraeletique”, ti xie. Jaꞌ lec tsꞌibao: “Ti buchꞌu ta xalbe sba ti ajvalilun yuꞌun ti jꞌisraeletique”, ti xie ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ti Pilatoe jech laj stacꞌbe: ―Ti cꞌusi laj xa jtsꞌibae, jaꞌ jech ta xcom o ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ti soldadoetique, cꞌalal laj xa sjipanic ta cruz ti Jesuse, laj stambeic ti scꞌuꞌe. Laj spasic ta chanchꞌac. Jujulic laj yichꞌic ti chanibique. Jaꞌ jech xtoc laj stsacbeic ti scotone. ¡Cꞌu stu un! jis noꞌox jalbil. Muꞌyuc tsꞌisbil. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jech o xal ti soldadoetique jech laj yalbe sbaic ta jujun tal: ―Altic ta jattic. Jaꞌ lec laꞌ jqꞌueltic suerte yoꞌ jech ta xvinaj buchꞌu junucal ta xichꞌ cuꞌuntic ―xiic. Ti jech taje, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal ta xal ti scꞌop Diose: “Laj xchꞌacbe sbaic ti jcꞌuꞌe. Laj sqꞌuelic suerte yuꞌun ti jcꞌuꞌe”, ti xie. Jech onoꞌox laj spasic ti soldadoetique. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ta yoc scruzal ti Jesuse tey vaꞌal ti smeꞌe, schiꞌuc ti schiꞌil ta voqꞌuel ti smeꞌe, schiꞌuc ti Maríae, ti jaꞌ yajnil ti Cleofase, schiꞌuc ti María Magdalenae. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ti Jesuse, ti cꞌalal laj yil ti smeꞌ ti tey vaꞌal ta stsꞌel ti jun yajchancꞌop ti cꞌuxubinbil yuꞌune, jech laj yalbe ti smeꞌe: ―Meꞌ, tey vaꞌal ta atsꞌel ti avole ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jech laj yalbe xtoc ti yajchancꞌope: ―Tey vaꞌal ti ameꞌe ―xut. Cꞌalal jech laj yaꞌi ti yajchancꞌope, laj yicꞌ batel ta sna smeꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Snaꞌoj xa lec ti Jesuse ti scotol icꞌot xa ta pasel ta stojole. Jaꞌ jech xtoc yoꞌ ta xcꞌot ta pasel jech chac cꞌu chaꞌal ta xal ti scꞌop Diose jech laj yal: ―Taquin coꞌnton ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Oy tey jun jarru ti noj ta chꞌail poxe. Tey laj stsꞌajic ta chꞌail pox ti esponjae. Tey laj xchuquic ti esponja ta jun scꞌob hisopo teꞌ sbie. Tey laj xtuchic muyel ta ye ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cꞌalal jech laj yuchꞌ chꞌail pox ti Jesuse, jech lic yal: ―Cuch xa cuꞌun scotol ―xi. Tey nijbuj, icham. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jun xa cꞌacꞌal scꞌan ti qꞌuin Colele. Ti jꞌisraeletique mu scꞌanic ti tey jipil ta cruz ta xcom sbecꞌtalic ti jmileletic ti cꞌacꞌal ta sta scꞌacꞌalil ti cuxob oꞌntonale. Yuꞌun ti scꞌacꞌalil cuxob oꞌntonale, jaꞌ jun cꞌacꞌal ti ichꞌbil ta mucꞌ yuꞌunique. Jech o xal un, laj scꞌanbeic ti Pilatoe ti acꞌo yal mantal ti acꞌo yichꞌic cꞌasbel sbaquil yoꞌic ti buchꞌu jipil ta cruze, yoꞌ jech xuꞌ ta syalesic talel ta cruz. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jech ti soldadoetique lic scꞌasbeic sbaquil yoꞌ ti baꞌyel tey jipile. Tsꞌacal to yichꞌ cꞌasbel sbaquil yoꞌ ti jun ti tey jipil ta xocon ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero, cꞌalal nopajic batel ta stsꞌel ti Jesuse, laj yilic ti chamem xae. Jech o xal muꞌyuc xa laj scꞌasbeic sbaquil ti yoꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero ti jun soldadoe laj to spajbe ta lanza xocon schꞌilteꞌ ti Jesuse. Ta ora noꞌox ilocꞌ talel chꞌichꞌ schiꞌuc voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ti buchꞌu laj stsꞌiba ti cꞌop liꞌe ti jech ta xal taje, yuꞌun laj yil stuc. Melel ti cꞌusi ta xale. Yuꞌun jaꞌ snaꞌ lec ta melel ti jech ta xale, yoꞌ ta xachꞌunic ec. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ti jech taje yoꞌ ta xcꞌot ta pasel jech chac cꞌu chaꞌal ta xal ti scꞌop Diose: “Mu xacꞌasbeic mi junuc sbaquil”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ti ta yan scꞌop Diose jech ta xal xtoc: “Ta xilic ti buchꞌu laj syayijesic ta lanzae”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tsꞌacal to ti Josee, ti liquem talel ta jteclum Arimateae, ba yichꞌbe ye ti Pilatoe ti mi xuꞌ ta xichꞌ batel sbecꞌtal ti Jesuse. Yuꞌun ti Josee jaꞌ jun ti xchꞌunoj ti Jesuse. Jaꞌ noꞌox ti ta mucule, yuꞌun ta xiꞌ yuꞌun ti jꞌisraeletique. Jech ti Pilatoe laj yacꞌ ye ti xuꞌ ta xichꞌbe batel sbecꞌtal Jesús ti Josee. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tey ital ec ti Nicodemoe ti buchꞌu ay scꞌopon ta acꞌobaltic ti Jesuse. Yichꞌoj talel nopol lajuneb schaꞌvinic (30) kilo muil momoletic ti capal schiꞌuc mirra, schiꞌuc yan muil pox ti áloe sbie. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jech ti Josee schiꞌuc ti Nicodemoe laj spoyic batel sbecꞌtal ti Jesuse. Laj slilinic ta sba manta ti muil momoletique. Tey laj xpixic ta manta sbecꞌtal ti Jesuse jech chac cꞌu chaꞌal stalelic ta smuc sbaic ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ti bu laj yichꞌ jipanel ta cruz ti Jesuse, oy tey jun tsꞌunobaltic. Ti tey ta tsꞌunobaltique, oy tey jun achꞌ muquinal ti jombil ta tone ti mu to junuc anima ticꞌbile. ");
INSERT INTO tzotzc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tey laj stiqꞌuic comel sbecꞌtal ti Jesuse. Yuꞌun ti muquinale jaꞌ nopol noꞌox. Pero maꞌuc noꞌox ti nopole. Yuꞌun jaꞌ o xa yorail ti ta xlic scꞌacꞌalil ti cuxob oꞌntonal yuꞌun ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ti ta sliquebal cꞌacꞌal xemunae, sob ta jmec, ti María Magdalenae ibat ta muquinal. Tey laj yil ti muꞌyuc xa macal ta ton ti tiꞌ muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Cꞌalal jech laj yile, ibat ta anil ti bu comem ti Simón Pedroe schiꞌuc ti jun jchancꞌop ti lec cꞌanbil yuꞌun ti Jesuse. Jech laj yalbe yaꞌiic: ―Laj xa sloqꞌuesic ta muquinal ti Cajvaltique. Mu jnaꞌcutic bu laj yaqꞌuic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ti Pedroe schiꞌuc ti jun jchancꞌope batic ta muquinal. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jmoj ibatic ta anil. Pero ti jun jchancꞌope jaꞌ ijelav batel ta anil. Jaꞌ baꞌyel icꞌot ta muquinal. Jaꞌ tsꞌacal to icꞌot ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ti jun jchancꞌope cuji sqꞌuel ochel ti muquinale. Tey laj yil ti spixobil ti Jesuse. Pero muꞌyuc xꞌoch batel. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Cꞌalal icꞌot ti Simón Pedroe, och batel ta muquinal. Tey laj yil xtoc ti spixobil ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ti Simón Pedroe tey laj yil ti jlic poc ti jaꞌ spixobil sjol ti Jesuse, lec pacbil. Pero yan o ti bu acꞌbil comele. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jaꞌ jech xtoc iꞌoch batel ti jun jchancꞌop ti buchꞌu baꞌyel icꞌot ta muquinale. Laj yil ti jech icꞌot ta pasele. Laj xchꞌun ti ichaꞌcuxi xa ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero ti chaꞌvoꞌique muꞌyuc to bu laj yaꞌibeic smelol ti jech ta xal ti scꞌop Diose ti tsots scꞌoplal ta xchaꞌcuxi Jesús ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jech ti stuquique isut batel ta snaic. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ti Maríae tey xꞌocꞌolet icom ta tiꞌ muquinal. Cꞌalal tey ta xꞌoqꞌue, laj scujan sba ta sqꞌuelel ochel ti muquinale. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Laj yil chaꞌvoꞌ ángeletic ti sac ti scꞌuꞌique. Jun chotol ta sjol, jun chotol ta yoc ti bu to ox tutsꞌul ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jech laj sjaqꞌuic ti ángeletique: ―Ants, ¿cꞌu chaꞌal ta xaꞌocꞌ? ―xiic. Ti Maríae jech itacꞌav: ―Yuꞌun laj xa yichꞌic batel sbecꞌtal ti Cajvale. Mu jnaꞌ bu laj yaqꞌuic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cꞌalal naca to jech laj yale, tey joybij. Tey laj yilbe sat ti Jesuse. Pero mu snaꞌ mi jaꞌ ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ti Jesuse jech laj sjacꞌ: ―¿Cꞌu chaꞌal ta xaꞌocꞌ, Ants? ¿Buchꞌu ta xasaꞌ? ―xi. Ti Maríae yacꞌtouc ti jaꞌ ti jchabiej-tsꞌunobale. Jech laj yal: ―Banquil, ti mi voꞌot laj apoy loqꞌuel ti Cajvale, albun caꞌi bu laj avacꞌ yoꞌ jech ta jpoy batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ti Jesuse jech laj yal: ―María ―xi. Ti Maríae ijoybij. Jech laj yal ta hebreo cꞌop: ―Raboni ―xi. (Jchanubtasvanej, xi ti smelole.) ");
INSERT INTO tzotzc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ti Jesuse jech laj yal: ―María, mu xapicun. Yuꞌun muꞌyuc to muyemun batel ti bu oy ti Jtote. Batan, ba albo yaꞌi ti quermanotaque ti ta ximuy batel ti bu oy ti Jtote, ti jaꞌ Atotic eque, ti jaꞌ Dios cuꞌune, ti jaꞌ Dios avuꞌunic eque ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jech ti María Magdalenae bat yalbe yaꞌi ti yajchancꞌoptaque ti laj xa yilbe sat ti Jesuse. Jaꞌ jech xtoc laj yalbe yaꞌiic ti cꞌu sꞌelan iꞌalbat yuꞌun ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Taje, jaꞌ o scꞌacꞌalil ti sliquebal cꞌacꞌal xemunae, ti ta acꞌobaltique, jaꞌ o tey stsoboj sbaic ta na ti yajchancꞌoptaque. Bajalic lec ta na ta scoj xiꞌel yuꞌun ti jꞌisraeletique. Ti Jesuse tey iꞌoch batel, tey icꞌot svaꞌan sba ta oꞌlol yuꞌunic. Jech laj yal: ―Mu xaxiꞌic. Junuc avoꞌntonic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cꞌalal jech laj yal taje, laj yacꞌ ta ilel ti scꞌobe, ti xocone. Jech ti stuquique xmuyubajic xa ti laj yilic ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tsꞌacal to jech laj yal yan velta ti Jesuse: ―Junuc avoꞌntonic. Jech chac cꞌu chaꞌal laj stacun talel ti Jtote, jaꞌ jech ta xajtacoxuc batel ec ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jech xtoc un, ti Jesuse laj xvuchꞌta ti yajchancꞌoptaque. Jech laj yalbe: ―Ichꞌic ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ti buchꞌu ta xavalbe ti chꞌaybil xa ti smule, jech chꞌaybil ta xcꞌot. Yan ti buchꞌu ta xavalbe ti muꞌyuc chꞌaybil ti smule, muꞌyuc onoꞌox chꞌaybil ti smule ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ti Tomase, ti jaꞌ jun ta slajchaꞌvoꞌal ti yajchancꞌope, ti jaꞌ sbiinoj vache, muꞌyuc tey ti cꞌalal icꞌot ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ti yan jchancꞌopetique jech laj yalbeic: ―Laj xa quilcutic ti Cajvaltique ―xutic. Ti Tomase jech laj yal: ―Mi mu xquil ta scꞌob ti yayijem ta lauxe, mi muꞌyuc ta jticꞌ ochel sniꞌ jcꞌob ta yav lauxe, mi muꞌyuc ta jticꞌ ochel ti sniꞌ jcꞌob ta xocone, mu to xuꞌ ta jchꞌun ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Cꞌalal echꞌ xa ox vaxaquib cꞌacꞌale, tey tsobolic yan velta ta jun na ti yajchancꞌoptaque. Jaꞌ to tey oy ti Tomase. Acꞌo mi lec bajal ti tiꞌ na yuꞌunique, och batel ti Jesuse. Tey cꞌot svaꞌan sba ta oꞌlol yuꞌunic. Jech laj yal: ―Junuc avoꞌntonic ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jech lic yalbe ti Tomase: ―Ticꞌo ochel ti sniꞌ acꞌob liꞌ ta jcꞌobe. Qꞌuelo ti jcꞌobe. Ticꞌo ochel ti acꞌob ta jxocone. Chꞌunun. Mu teyuc noꞌox xanaꞌet ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jech laj stacꞌ ti Tomase: ―Voꞌot ti Cajvalote, ti Diosot cuꞌune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jech laj yal ti Jesuse: ―Avi tana, Tomás, ta xachꞌunun, jaꞌ ti laj xa avilune. Toj yan yutsilic ti buchꞌutic ti muꞌyuc laj yilicune, pero ti laj xchꞌunicune ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ti Jesuse ep to laj yacꞌ iluc smucꞌul stsatsal ta stojol ti yajchancꞌoptaque, ti muꞌyuc tsꞌibabil icom ta libro liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ti cꞌu yepal tsꞌibabil liꞌe, yoꞌ jech ta xachꞌunic ti jaꞌ Cristo ti Jesuse, ti jaꞌ Snichꞌon ti Diose, yoꞌ jech ta xataic acuxlejalic cꞌalal ta xachꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsꞌacal to un, ti Jesuse laj to yacꞌ sba iluc ta stojol ti yajchancꞌoptac ti ta stiꞌil nab Tiberiase. Cꞌalal laj yacꞌ sba iluque, jaꞌ jech chac cꞌu chaꞌal liꞌe: ");
INSERT INTO tzotzc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tey oy jmoj tsobolic ti Simón Pedroe schiꞌuc ti Tomase, ti jaꞌ vach sbiinoje, schiꞌuc ti Natanaele ti liquem talel ta jteclum Caná ti oy ta Galileae, schiꞌuc ti chaꞌvoꞌ snichꞌnab ti Zebedeoe, schiꞌuc yan chaꞌvoꞌ yajchancꞌop ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ti Simón Pedroe jech laj yal: ―Ta xibat ta tsac choy ―xi. Ti schiꞌiltaque jech laj yalic: ―Jech ti vuꞌuncutique ta xba jchiꞌinotcutic ec ―xiic. Tey ibatic. Iꞌochic batel ta jun barco. Sjunul acꞌobal ixanavic ta stsaquel ti choye. Pero muꞌyuc laj staic mi jcotuc. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cꞌalal ta xa sacub talele, jaꞌ o tey ivul ta loqꞌuel ta tiꞌ nab ti Jesuse. Pero ti yajchancꞌoptaque mu snaꞌic buchꞌu. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ti Jesuse jech laj yal: ―Queremotic, ¿mi muꞌyuc laj ataic jcotuc ti choye? ―xi. Ti yajchancꞌoptaque jech itacꞌavic: ―Chꞌabal ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ti Jesuse jech laj yal: ―Jipic ochel ti stsacobil achoyic ta sbatsꞌi xocon ti barcoe. Tey ta xataic talel ti choye ―xi. Ti yajchancꞌoptaque laj xchꞌunic ti jech iꞌalbatique. Tsꞌacal to un, mu stacꞌ nitel loqꞌuel talel ta voꞌ ti stsacobil schoyique, jaꞌ ti toj noj ta choye. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pero ti jun jchancꞌop ti lec cꞌanbil yuꞌun ti Jesuse, jech laj yalbe ti Pedroe: ―Jaꞌ ti Cajvaltique ―xi. Ti cꞌalal jech laj yaꞌi ti Simón Pedro ti jaꞌ ti Cajvaltique, lic slap ta anil ti scꞌuꞌ ti slocꞌoj to oxe. Ta ora noꞌox tey laj sjip sba batel ta voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pero ti yan yajchancꞌoptaque icꞌotic ta tiꞌ nab schiꞌuc ti barcoe. Tey xjochojic talel ti stsacobil schoyique yuꞌun noj ta choy. Yuꞌun oy nan voꞌvinicuc (100) noꞌox metro ti ochemic batel ta yutil nabe. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cꞌalal icꞌotic ta tiꞌ nabe, tey laj staic ti xꞌubet xa yacꞌalil ti cꞌoqꞌue. Tey cajal jcot choy ta sba ti acꞌale. Jaꞌ jech xtoc tey oy pan. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ti Jesuse jech laj yal: ―Ichꞌic talel jaycotuc choy ti naca to laj atsaquique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ti Simón Pedroe imuy batel ta yut barco. Ba xjoch talel ta tiꞌ nab ti stsacobil schoy ti noj ta mucꞌtic choye. Oꞌlol schibal ciento schiꞌuc oxcot (153) ti choye. Manchuc mi noj ta choy ti stsacobil schoyique, pero muꞌyuc xjat. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ti Jesuse jech laj yal: ―Laꞌ veꞌanic ―xi. Muꞌyuc buchꞌu junucal ti yajchancꞌoptac laj sjacꞌbeic ti Buchꞌue. Jaꞌ ti snaꞌojic xa ti jaꞌ ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ti Jesuse laj stsac ti pane. Laj yacꞌbe ti yajchancꞌoptaque. Jaꞌ jech laj spas schiꞌuc ti choye. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jaꞌ xa yoxibal velta ti laj yacꞌ sba iluc ta stojol ti yajchancꞌoptaque ti cꞌalal chaꞌcuxiem xae. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cꞌalal ilaj yoꞌntonic ta veꞌele, ti Jesuse jech lic sjacꞌbe ti Simón Pedroe: ―Simón, snichꞌonot ti Jonase, ¿mi más to cꞌuxun ta avoꞌnton? ¿Mi jaꞌ mu sta ti yan liꞌe? ―xi. Jech laj stacꞌ ti Pedroe: ―Jech, Cajval, anaꞌoj lec ti cꞌuxot ta coꞌntone ―xi. Ti Jesuse jech laj yalbe: ―Ti mi jech cꞌuxun ta avoꞌntone, qꞌuelo ti jmimitaque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jech lic sjacꞌ yan velta ti Jesuse: ―Simón, snichꞌonot ti Jonase, ¿mi cꞌuxun ta avoꞌnton? ―xi. Ti Pedroe jech laj stacꞌbe: ―Jech, Cajval, anaꞌoj lec ti cꞌuxot ta coꞌntone ―xi ti Pedroe. Ti Jesuse jech laj yal: ―Ti mi jech cꞌuxun ta avoꞌntone, qꞌuelo ti jchijtaque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ta yoxibal xa velta jech lic sjacꞌ ti Jesuse: ―Simón, snichꞌonot ti Jonase, ¿mi cꞌuxun ta avoꞌnton? ―xi. Ti Pedroe och ta at oꞌnton, jaꞌ ti yoxibal xa velta ti jacꞌbat, ¿mi cꞌuxun ta avoꞌnton? ti xꞌutate. Jech laj yal ti Pedroe: ―Cajval, anaꞌoj scotol. Xanaꞌ lec ti cꞌuxot ta coꞌntone ―xi. Jech laj yal ti Jesuse: ―Ti mi jech cꞌuxun ta avoꞌntone, qꞌuelo me ti jchijtac un chaꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta melel ta xcalbot avaꞌi, ti cꞌalal aqueremal to oxe, laj alap lec acꞌuꞌ. Labat ti bu ta xacꞌane. Pero cꞌalal sta yorail ti ta xayijube, ta xalichꞌ ti acꞌobe, yan o ti buchꞌu ta xacꞌ alap ti acꞌuꞌe. Ta xicꞌot batel ti bu mu xmuyubaj avoꞌntone ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ti jech laj yal taje, ti Jesuse ta xacꞌbe snaꞌ ti cꞌu sꞌelan ta xcham ti Pedroe, yoꞌ jech ichꞌbil ta mucꞌ ta xcꞌot ti Dios yuꞌune. Tsꞌacal to un, ti Jesuse jech laj yalbe: ―Tsꞌacliun batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Cꞌalal ijoybij ta spat ti Pedroe, laj yil ti tey tijil batel ta spatic ti jun jchancꞌop ti ep cꞌuxubinbil yuꞌun ti Jesuse, jaꞌ ti buchꞌu nabal ta stsꞌel Jesús ti cꞌalal jmoj ta xveꞌic ti jech laj sjaqꞌue: “Cajval, ¿buchꞌu ta xacꞌot ta cꞌabal?”, ti xi laj sjaqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cꞌalal jech laj yil ti Pedroe, jech laj sjacꞌbe ti Jesuse: ―Cajval, ati jun vinic leꞌe, ¿cꞌusi ta xcꞌot ta pasel ta stojol? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ti Jesuse jech laj stacꞌbe: ―Ti mi ta jcꞌan ti cuxul to ta jta ti cꞌalal ta xichaꞌsut talele, ¿cꞌusi aventa? Ti voꞌote jaꞌ noꞌox tsacliun batel ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jaꞌ yuꞌun un, ipuc scꞌoplal yuꞌunic ti muꞌyuc ta xcham ti jun jchancꞌope. Pero mu yuꞌunuc laj yal ti Jesús ti mu ta xchame. Jaꞌ laj yal: “Ti mi ta jcꞌan ti cꞌuxul to ta jta ti cꞌalal ta xichaꞌsut talele, ¿cꞌusi aventa?”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ti jun jchancꞌop taje, jaꞌ ti buchꞌu laj stsꞌiba ti libro liꞌe, ti jaꞌ yiloj scotol ti cꞌusi icꞌot ta pasele. Jnaꞌtic ti melel ti cꞌusi ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Oy to ep ti cꞌusi laj spas ti Jesuse. Ati lajuc yichꞌ tsꞌibael ta jujutos ti cꞌusi laj spase, ti vuꞌun ta jnope mu xꞌoch o ta scotol banomil ti libroetic ti scotoluc lajuc yichꞌ tsꞌibaele. Jechuc. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ti lec xquil jbatique, ti ta baꞌyel libro ti laj jtsꞌibabote, jaꞌ laj calbot avaꞌi scotol ti cꞌu sꞌelan ilic abtejuc, ti cꞌu sꞌelan ichanubtasvan ti Jesuse, ");
INSERT INTO tzotzc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","jaꞌ to ti cꞌalal ista scꞌacꞌalil imuy batel ta vinajele. Cꞌalal mu to ox ta xmuy batel ta vinajele, laj stꞌuj ti yajcholcꞌoptaque. Laj sbijubtas ta sventa ti Chꞌul Espíritue ti cꞌu sꞌelan xuꞌ ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cꞌalal ichaꞌcuxi xa ti Jesuse, laj yacꞌ sba iluc stuc ta stojol ti yajcholcꞌoptaque. Chaꞌvinic (40) cꞌacꞌal, ep ta tos ti cꞌu sꞌelan laj yacꞌ sba iluc ta stojolique, yoꞌ jech ta snaꞌic ti chaꞌcuxiem xae. Jaꞌ jech xtoc tey laj yal ti ventainel yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ti Jesuse cꞌalal tey to schiꞌuc ti yajcholcꞌoptaque, laj yalbe yaꞌi ti mu to xloqꞌuic batel ta jteclum Jerusalene. Jech laj yal: ―Malaic liꞌe, jaꞌ to ti mi laj avichꞌic ti cꞌusi yaloj onoꞌox ti Jtot ti ta xaqꞌue jech chac cꞌu chaꞌal laj calboxuc avaꞌiique. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ta melel, ti Juane voꞌ laj yacꞌ ta ichꞌel. Yan ti voꞌoxuque jutuc xa scꞌan ti ta xavichꞌic ti Chꞌul Espíritue ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cꞌalal tey to ox tsobolic schiꞌuc ti Jesuse, jech laj sjaqꞌuic ti yajcholcꞌoptaque: ―Cajval, ¿mi jaꞌ xa yorail liꞌe ti ta xavacꞌ jventain jba jtuccutic yan velta ti jꞌisraeluncutique? ―xutic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jech laj stacꞌ ti Jesuse: ―Leꞌe, jaꞌ yabtel stuc ti Jtote. Yuꞌun snaꞌoj stuc ti cꞌusi ora ta spase. Maꞌuc aventaic ti voꞌoxuque. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero cꞌalal ta xavichꞌic ti Chꞌul Espíritue, ta xacꞌboxuc atsatsalic yoꞌ jech ta xaloqꞌuic batel ta yalel ti jcꞌoplale. Ta xavalic liꞌ ta Jerusalene, ti ta sjunul slumal ti Judeae, ti ta sjunul slumal ti Samariae, ti ta sjoylej banomile ―xi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cꞌalal jech laj yoꞌnton ta yalel taje, ti yajcholcꞌoptaque tey laj yilic ti icꞌbil imuy batel ta vinajel ti Jesuse. Jaꞌ o tey tal voliatuc ta toc. Tey ichꞌay batel ta satic ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cꞌalal jech sqꞌuelojic ti ta xmuy batel ta vinajel ti Jesuse, jaꞌ o laj yilic ti tey vaꞌal ta stsꞌelic chaꞌvoꞌ viniquetic ti saquic ti scꞌuꞌique. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ati chaꞌvoꞌ viniquetique jech laj yalic: ―Galilea viniquetic, ¿cꞌu chaꞌal tey vaꞌaloxuc ta sqꞌuelel muyel ti vinajele? Ti Jesús ti liꞌ imuy batel ta atojolique, jaꞌ noꞌox jech ta xchaꞌsut talel jech chac cꞌu chaꞌal laj avilic ti imuy batel ta vinajele ―xꞌutatic. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ti stuquique iloqꞌuic batel ti ta vits ti jaꞌ sbiinoj Olivose. Sutic batel ta Jerusalén. Mu nomuc ta xil sbaic. Jaꞌ noꞌox jech snatil ixanavic jech chac cꞌu chaꞌal ta xal smantalil ti scꞌacꞌalil cuxob oꞌntonale. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cꞌalal icꞌotic ta Jerusalene, tey imuyic batel ta schaꞌcojal na ti bu oyic onoꞌoxe. Ti ta scotolic taje, tey oyic ti Pedroe, ti Jacoboe, ti Juane, ti Andrese, ti Felipee, ti Tomase, ti Bartolomee, ti Mateoe, ti Jacoboe, jaꞌ ti snichꞌon ti Alfeoe, ti Simone, jaꞌ ti buchꞌu tiqꞌuil to ox ta partido cananistae, schiꞌuc ti Judase, jaꞌ ti schiꞌil ta voqꞌuel ti Jacoboe. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Scotolic ti vaꞌi yepalic taje jun yoꞌnton ta stsob sbaic yoꞌ ta staic ta cꞌoponel ti Diose jmoj schiꞌuc ti Maríae ti jaꞌ smeꞌ ti Jesuse, ti schiꞌiltac ta voqꞌuel ti Jesuse, schiꞌuc yan antsetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ti jech ta stsobilan sbaique, tey lic vaꞌiuc ti Pedro ta oꞌlol ti jchꞌunolajeletique, ti nopol van vacvinic (120) ta voꞌe. Jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Quermanotac, tsots scꞌoplal ti jech icꞌot ta pasel jech chac cꞌu chaꞌal laj stsꞌiba ta scꞌop Dios ti Davide ta sventa ti ventainbil yuꞌun ti Chꞌul Espíritue. Laj stsꞌiba scꞌoplal ti Judase, ti jaꞌ itun ta jꞌicꞌvanej ti cꞌalal laj xchuquic batel ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuꞌun ti Judase jaꞌ jchiꞌilcutic ti jmoj quichꞌoj cabtelcutique. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ti taqꞌuin ti itojbat yuꞌun ti cꞌusi chopol laj spase, laj smanic o jsep banomil. Tsꞌacal to un, ti Judase pajal sjol ibaj yalel. Tey itꞌom. Ilocꞌ scotol ti sbeel schꞌute. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cꞌalal jech laj yaꞌiic ti jnaclejetic ta Jerusalene, laj yacꞌbe sbiin Acéldama ti banomile. Ti smelol ta scꞌop stuquique, jaꞌ osilal chꞌichꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yuꞌun ti ta libro Salmoe jech ta xal: Xocluc comuc o ti snae. Muꞌyuc buchꞌu xnaqui o tey, ti xie. Jech ta xal xtoc: Vaꞌiuc yan yajval ti yabtele, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Oy liꞌ viniquetic ta jtojoltique ti chiꞌinvanic onoꞌox cꞌalal liꞌ to ox jchiꞌuccutic ti Cajvaltic Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ti viniquetic taje jaꞌ yilojic scotol cꞌalal iꞌacꞌbat yichꞌ voꞌ ti Jesús yuꞌun ti Juane schiꞌuc ti cꞌalal to imuy batel ta vinajele. Tsots scꞌoplal ti acꞌo yichꞌic tꞌujel junuc ti buchꞌu yilojic taje yoꞌ jech ta jchiꞌincutic, yoꞌ jech ta xcꞌot ta rextigo ti ichaꞌcuxi ti Jesuse ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Cꞌalal jech laj yaꞌiique, jaꞌ o tey laj svaꞌanic chaꞌvoꞌ viniquetic, jaꞌ ti Matíase schiꞌuc ti José Barsabase. Ti yan sbi xtoc ti Josee jaꞌ Justo. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jech lic scꞌoponic ti Diose: ―Cajval, xavojtiquinbe yoꞌnton scotol cristianoetic. Acꞌbun quilcutic buchꞌu junucal laj atꞌuj ti chaꞌvoꞌ liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ti buchꞌu laj atꞌuje, jaꞌ ta xichꞌbe yabtel ti Judase ti ichꞌay yabtel ta scoj ti smule, ti tey ibat ti bu onoꞌox jech laj scꞌane ―xutic ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tsꞌacal to un, lic sqꞌuelic suerte ti buchꞌue. Jaꞌ icꞌot ta stojol ti Matíase. Tey icom ta abtel schiꞌuc ti buluchvoꞌ yajcholcꞌoptac ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cꞌalal sta scꞌacꞌalil ti qꞌuin Pentecostese, ti jchꞌunolajeletique tey tsobolic ti bu onoꞌox ta stsob sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jaꞌ o ta jech yepal laj yaꞌiic ti oy cꞌusi tsots xjumet ti ilic talel ta vinajele jech chac cꞌu chaꞌal xjumet tsots icꞌ. Tey xjumet icꞌot ta yut na ti bu chotajtic ti jchꞌunolajeletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tey laj yilic ti coꞌol sꞌelan leb cꞌocꞌ ti laj xchꞌacan sba batel ta stojolic ta jujun ti cꞌu yepal tey tsobolique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Scotol ti jchꞌunolajeletique noj icꞌotic ta yoꞌntonic ti Chꞌul Espíritue. Tey lic cꞌopojicuc ta yan cꞌopetic, jaꞌ ti cꞌu sꞌelan ta xꞌacꞌbat snaꞌic yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti jech icꞌot ta pasele, jaꞌ o tey talemic ta Jerusalén ep jꞌisraeletic ti ta spasic onoꞌox smantal ti Moisese, ti liquemic talel ta jujun lum ti oyic ta sjoylej banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cꞌalal jech laj yaꞌiic ti oy cꞌusi tsots xjumete, tey ibat stsob sbaic ti jꞌisraeletique. Mu stacꞌ aꞌyeluc cꞌusi ta xalic. Yuꞌun ta xcꞌoponatic ta scꞌop stuquic jujun. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ti jꞌisraeletique toj elom laj yaꞌiic. Chꞌayal icꞌot yoꞌntonic ta jmec. Jech lic yalbe sbaic ta jujuntal: ―¿Mi mu jaꞌuc van liquemic talel ta Galilea scotolic ti vaꞌi sꞌelan ta xcꞌopojique? ");
INSERT INTO tzotzc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cꞌusi xutic ti ta xcꞌopojic ta jcꞌop jtuctic ti liquemotic ta jujun lume? ");
INSERT INTO tzotzc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yuꞌun ep ta chop liꞌ jtaoj jbatique. Oy jlomotic liquemotic talel ta Partia, ta Media, ta Elam, ta Mesopotamia, ta Juda, ta Capadocia, ta Ponto, ta Asia. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Oy jlomotic liquemotic ta Frigia, ta Panfilia, ta Egipto, ta Africa tey ta jelavel lum Cirene. Oy jlom liquemic talel ta Roma ti xchꞌunojic xa jech chac cꞌu chaꞌal ti jchꞌunojtique. Oy jlom jchiꞌiltic ti tey voqꞌuemic ta Romae. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oy jlom liquemic talel ta Creta, ta Arabia. Pero jcotoltic ta xcaꞌitic ta jcꞌop jtuctic ti yutsilal ti Diose ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Scotolic chꞌayal yoꞌntonic. Mu stacꞌ aꞌyeluc ta xaꞌiic cꞌusi ta snopic. Jech o xal jech ta sjacꞌanbe sbaic: ―¿Cꞌusi xal o ti jech leꞌe? ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero oy jlom lic labanvanuc. Jech ta xalic: ―Yuꞌun ta xyacubic ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ti Pedroe tey lic vaꞌiuc schiꞌuc ti yan buluchvoꞌ jcholcꞌopetique. Jech tsots lic cꞌopojuc ti Pedroe: ―Jchiꞌiltac ti liꞌ ta Judeae schiꞌuc ti voꞌoxuc ti talemoxuc ta Jerusalene, aꞌyic avaꞌiic lec ti cꞌusi ta xcalboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Maꞌuc jyacubeluncutic jech chac cꞌu chaꞌal ta xanopique, yuꞌun naca to baluneb ora icꞌluman. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ti jech liꞌe, jaꞌ icꞌot ta pasel jech chac cꞌu chaꞌal laj yal ti jꞌalcꞌop Joele: ");
INSERT INTO tzotzc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jech laj yal ti Diose: Cꞌalal poꞌot xa sta ti slajebaltic batel cꞌacꞌale, ta xcacꞌbe yichꞌic ti Jchꞌul Espíritu scotol ti cristianoetique. Ti avalab anichꞌnabique ta xalbeicun jcꞌoplal. Ti jvaꞌlej viniquetique oy cꞌusi xlic cacꞌbe yilic. Ti moletique oy cꞌusi ta xcacꞌbe yilic ta svayichic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti jech cꞌacꞌal taje, ta xcacꞌbe yichꞌic ti Jchꞌul Espíritu ti cajꞌabteltac viniquetique, ti antsetique, yoꞌ jech ta xalbeicun jcꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oy cꞌusi ta xcacꞌ iluc ta vinajel ti chꞌayal ta xcꞌot yoꞌntonique. Ti liꞌ ta banomile, ta xcacꞌ iluc chꞌichꞌ, cꞌocꞌ, chꞌayil ti capal ta toque. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ti cꞌacꞌale ta xꞌicꞌub. Ti ue ta stsajub jech chac cꞌu chaꞌal chꞌichꞌ cꞌalal poꞌot xa sta scꞌacꞌalil ti ta xchaꞌsut talel ti Cajvaltique. Ti cꞌacꞌal taje, jaꞌ jun mucꞌ ta cꞌacꞌal ti yan yutsile. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Scotol ti buchꞌutic ta scꞌanbeic vocol ti Cajvaltique, jaꞌ ta xcolic, xi ti Diose, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Aꞌyio avaꞌiic lec, Jchiꞌiltac, ti cꞌusi ta xcale. Ti Jesús ti liquem talel ta Nazarete, anaꞌojic lec ti jaꞌ jun vinic ti acꞌbat yabtel yuꞌun ti Dios ta atojolique. Yuꞌun ep ta tos laj yacꞌ iluc ti tsots xuꞌ yuꞌune ta sventa smucꞌul stsatsal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Acꞌo mi jech, pero cꞌalal laꞌacꞌbatic ta avoc ta acꞌobique, ti voꞌoxuque achucojic batel yoꞌ laj avaqꞌuic ta milel ta cruz jmoj schiꞌuc ti viniquetic ti toj chopolique. Ti jech taje, jaꞌ icꞌot ta pasel ti snopoj stꞌujoj onoꞌox ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero ti Diose laj xchaꞌcuxes ti Jesuse. Yuꞌun mu xuꞌ ti ta xlaj o ta jꞌechꞌele. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yuꞌun ti ajvalil Davide jech laj yalbe scꞌoplal ti Jesuse: Tey onoꞌox vaꞌal ta xquil ti Dios ta jtojole. Ti stuque tey onoꞌox oy ta jbatsꞌi xocon, jech mu xixiꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jech o xal xmuyubaj ti coꞌntone. Jun yutsil ti cꞌusitic ta xlocꞌ ta quee. Jech o xal un, jun coꞌnton ta xicham. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yuꞌun jnaꞌoj, ti voꞌote mu xavacꞌ comuc o ti jchꞌulel ti bu oy ti animaetique. Mi jaꞌuc ta xavacꞌ cꞌaꞌuc sbecꞌtal ti avajtunel ti cꞌux ta xavaꞌie. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Laj avacꞌbun quil ti sbeelal cuxlejale. Jech xtoc ximuyubaj xa ti oyun ta atojole, xi ti Davide. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Jchiꞌiltac, jnaꞌojtic lec ta melel ti icham ti jmolmucꞌtotic Davide. Laj yichꞌ muquel. Ti smuquinale tey to ta xquiltic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero ti Davide jaꞌ jun jꞌalcꞌop. Jech o xal snaꞌoj lec ti iꞌalbat yuꞌun ti Diose ti oy jun snitilul ta xcom ta sqꞌuexole, ti jaꞌ Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ti Davide coꞌol sꞌelan ti yiloj xa ta voꞌnee ti laj yal ti ta xchaꞌcuxi ti Cristoe. Laj yal xtoc ti mu xcꞌaꞌ ti sbecꞌtale, ti mu xcom o schꞌulel ti Jesús ti bu oy schꞌulelic ti animaetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ti Jesús taje ichaꞌcuxesat yuꞌun ti Diose. Vuꞌun rextigouncutic scotol taje. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta smucꞌul stsatsal ti Diose icꞌat muyel ta vinajel. Tey cꞌot chotluc ta sbatsꞌi cꞌob. Laj yichꞌ ti Chꞌul Espíritu ti albil onoꞌox yuꞌun ti Dios ti ta xaqꞌue. Scotol ti vi sꞌelan ti laj avilique, ti laj avaꞌiique, jaꞌ liquem talel ta stojol ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Maꞌuc stuc ti David ti imuy batel ta vinajele. Yuꞌun ti Davide jech laj yal: Ti Diose jech laj yalbe ti Cajvale: “Laꞌ chotlan ta jbatsꞌi jcꞌob, ");
INSERT INTO tzotzc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","jaꞌ to mi sta yorail ta xcacꞌbot ta avoc ta acꞌob ti avajcrontae”, xut, xi ti Davide. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Jech o xal, acꞌo jnaꞌtic lec jcotoltic ti jꞌisraelotique, ti Jesús ti Buchꞌu laj avaqꞌuic ta milel ta cruze, ti Diose laj xa svaꞌan ta Ajvalil ta Jcoltavanej. ¿Cꞌu chaꞌal xijnaꞌetotic? ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cꞌalal jech laj yaꞌiic taje, jech o xal lic yaꞌiic ta yoꞌntonic ti oy smulique. Jech lic sjacꞌbeic ti Pedroe schiꞌuc ti yan jcholcꞌopetique: ―Jchiꞌiltac, ¿cꞌusi scꞌan ta jpascutic? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jech laj stacꞌ ti Pedroe: ―Ictaic ti chopol avoꞌntonique. Sutanic talel ta stojol ti Diose. Ichꞌic voꞌ ta sventa ti Jesucristoe yoꞌ jech ta xaꞌacꞌbatic perdón yuꞌun ti amulique. Jech ti Diose ta xacꞌboxuc ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yuꞌun jech onoꞌox albil yuꞌun ti Diose ti ta xavichꞌic schiꞌuc ti avalab anichꞌnabique. Jaꞌ jech xtoc ta xichꞌic ti buchꞌutic nom oyique. Yuꞌun ti Chꞌul Espíritue jaꞌ sventa scotolic ti buchꞌutic ta xꞌicꞌatic yuꞌun ti Cajvaltic Diose ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jaꞌ jech yepal laj yal ti Pedroe. Pero oy to yan ti jech laj sbijubtas ti schiꞌiltaque: ―Qꞌuelo me abaic. Mu me xachanbe yoꞌntonic ti chꞌayemal cristianoetic liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jech o xal ti cristianoetic ti buchꞌutic laj xchꞌunic ti cꞌusi laj yal ti Pedroe, laj yichꞌic voꞌ. Ti jech cꞌacꞌal taje iꞌepajic más nopol oxmil ti jchꞌunolajeletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Scotolic jun yoꞌntonic xchꞌunojic batel ti cꞌu sꞌelan ta xchanubtasatic yuꞌun ti yajꞌcholcꞌoptac ti Jesuse. Jmoj yoꞌntonic scotolic. Jun yoꞌntonic ta staic ta cꞌoponel ti Diose. Ta stsob sbaic ta spasel snaꞌobil ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Scotol ti cristianoetique labal xiꞌel ta xaꞌiic ti cꞌalal ta sqꞌuelic ti ta xaqꞌuic iluc smucꞌul stsatsal ti Diose schiꞌuc ti ta xaqꞌuic señailetic ti yajcholcꞌoptac ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Scotol ti buchꞌutic xchꞌunojique jmoj yoꞌntonic ta scoltaan sbaic ti cꞌusitic oy yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yuꞌun ta xchonic ti cꞌusitic oy yuꞌunique yoꞌ jech ta scoltaic ti buchꞌu abol sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jujun cꞌacꞌal ta stsob sbaic ta templo. Jech xtoc ta stsob sbaic ta naetic ta spasic snaꞌobil ti Cajvaltique. Xmuyubajic noꞌox ta xveꞌic scotolic. Biqꞌuit yacꞌoj sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Scotolic ta xalbeic slequilal ti Diose. Lec xꞌilatic yuꞌun ti yan cristianoetique. Ti Cajvaltique yantic ta sboles batel jujun cꞌacꞌal ti jchꞌunolajeletic ti buchꞌutic ta staic ti coltaele. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Oy jun cꞌacꞌal ti nopol xa batel oxib ora mal cꞌacꞌale, ibatic ta templo ti Pedroe schiꞌuc ti Juane. Yuꞌun jaꞌ xa yorail ti ta xichꞌ tael ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ti ta stiꞌ temploe, scotol cꞌacꞌal, tey chotol jun vinic ti coxov onoꞌox ivoqꞌue. Tey chba xchotanic ta tiꞌ templo ti Alacꞌ sba ti sbie, yoꞌ ta scꞌanbe limoxna ti buchꞌu tey ta xꞌoche. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ti coxov vinique cꞌalal laj yil ti ta xꞌochic batel ta templo ti Pedroe schiꞌuc ti Juane, tey lic syeꞌ scꞌob yoꞌ ta scꞌanbe limoxna. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ti Pedroe schiꞌuc ti Juane tey laj sqꞌuelic ti coxov vinique. Ti Pedroe jech lic yalbe: ―Qꞌueluncutic talel ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ti coxov vinique tey lic stoy muyel sat. Yacꞌtouc ti oy cꞌusi ta xꞌacꞌbate. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jech laj yal ti Pedroe: ―Muꞌyuc jtaqꞌuin. Muꞌyuc jcꞌulejal ta xcacꞌbot. Pero oy yan ti cꞌusi xuꞌ ta xcacꞌbote. Ta sventa ti Jesucristo ta Nazarete, vaꞌlan, xanavan ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jech ti Pedroe laj snitbe liquel sbatsꞌi cꞌob ti coxov vinique. Cꞌalal jech laj spase, ta ora noꞌox tey itsatsub ti yacane schiꞌuc ti sat yoque. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jech ti coxove bit, ivaꞌi. Tey lic xanavuc. Tey iꞌoch batel schiꞌuquic ta templo. Xbitbun noꞌox ta xanav batel. Xmuyubaj xa ta xalbe slequilal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Scotol ti cristianoetique laj yilic ti lec xa ta xanave schiꞌuc ti tey ta xalbe slequilal ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Toj chꞌayl icꞌot yoꞌntonic ta xiꞌel ti jech icꞌot ta pasele. Yuꞌun ti cristianoetique xojtiquinic lec ti jaꞌ ti coxov vinic ti buchꞌu tey ta xichꞌ chotanel ta stiꞌ templo ti Alacꞌ sba sbie, yoꞌ jech tey ta scꞌan ti limoxnae. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ti coxov ti buchꞌu icole tey xnabet batel ta spat ti Pedroe, ti Juane. Mu xꞌictavan. Scotol ti cristianoetique tey chꞌayal yoꞌntonic bat sqꞌuelic ti bu ti Pedroe schiꞌuc ti Juane ti ta scoreolal templo ti jaꞌ Salomón ti sbie. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ti cꞌalal jech laj yil ti Pedroe, jech lic yalbe ti cristianoetique: ―Jchiꞌiltac, ¿cꞌu chaꞌal ti toj elom ta xavaꞌiique? ¿Cꞌu chaꞌal ti ta xaqꞌueluncutic ta jmeque? ¿Mi yuꞌun ta xanopic ti ta jtsatsalcutic ta jlequilalcutic ti jech icol ti jech ta xanav ti vinic liꞌe? ");
INSERT INTO tzotzc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ti jech liꞌe, jaꞌ laj scolta ti Dios yuꞌun ti jmolmucꞌtotique, jaꞌ ti Abrahame, ti Isaaque, ti Jacobe. Yuꞌun laj xa yacꞌ ta ichꞌel ta mucꞌ ti Snichꞌone, jaꞌ ti Jesuse, ti Buchꞌu laj avaqꞌuic ta yoc ta scꞌob ti jchapanvanejetique. Cꞌalal ta scolta ox yaꞌi batel ti Pilatoe, pero mu jechuc laj acꞌanic. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jaꞌ laj acꞌanic ti acꞌo coluc batel ti jmilvaneje. Maꞌuc laj acꞌanic ti acꞌo coluc batel ti Chꞌul vinique. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jaꞌ jech laj avaqꞌuic ta milel ti jꞌacꞌ-cuxlejale. Pero ichaꞌcuxesat yuꞌun ti Diose. Ti jech ichaꞌcuxie, rextigouncutic. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ti jech icol ti coxove, jaꞌ ta sventa ti Jesús ti quichꞌojcutic ta muqꞌue. Jaꞌ stuc Jesús laj yacꞌbe yip yacan ti vinic ti xavojtiquinique. Ti jech jchꞌunojcutic ti Jesuse, jaꞌ jech colem icꞌot jech chac cꞌu chaꞌal ti ta xavilique. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Jnaꞌoj lec, Jchiꞌiltac, ti voꞌoxuque schiꞌuc ti jpasmantal avuꞌunique, cꞌalal laj avaqꞌuic ta milel ti Jesuse, mi jaꞌuc laj anaꞌic ta melel ti cꞌusi ta xapasique. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ti jech laj apasique, jaꞌ icꞌot ta pasel yuꞌun ti Diose ti jech onoꞌox laj yalic comel ti jꞌalcꞌopetique ti ta onoꞌox xichꞌ svocol ti Cristo Jcoltavaneje. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jech o xal, Jchiꞌiltac, ictaic ti chopol avoꞌntonique. Sutanic talel ta stojol ti Diose, yoꞌ jech chꞌaybil ta xcꞌot ti amulique. Jech ti Cajvaltique ta xacꞌboxuc scuxobil avoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ti Diose laj stacboxuc talel ti Jesucristoe, ti jech onoꞌox albil scꞌoplal ta voꞌne ti ta xcom ta Avajcoltavanejique. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Manchuc mi jaꞌ jech albil scꞌoplal ti Jesucristoe, pero mu to ta xtal ta ora. Tey to ta xcom ta vinajel jaꞌ to ti mi sta yorail ti ta xcom ta achꞌ scotol yuꞌun ti Diose jech chac cꞌu chaꞌal yalojic onoꞌox comel ti chꞌul jꞌalcꞌopetic ta voꞌnee. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ti Moisese jech onoꞌox laj yalbe ti jmolmucꞌtotic ta voꞌnee: “Ti Cajvaltic Diose ta stacboxuc talel jun jꞌalcꞌop ti ta xꞌayan liꞌ ta atojolique jech chac cꞌu chaꞌal ti vuꞌune. Ichꞌbeic ta mucꞌ ti cꞌusi ta xayalboxuque. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yuꞌun scotol ti buchꞌutic mu xichꞌic ta mucꞌ ti jꞌalcꞌop taje, acꞌo yichꞌ chꞌaquel loqꞌuel ta stojol ti yalab snichꞌnab ti Diose, yoꞌ jech ta xichꞌ svocolic”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ti cꞌusi icꞌot ta pasel ta jtojoltic liꞌ ta orae, jech onoꞌox lic yal tal ti jꞌalcꞌop Samuele. Jaꞌ jech xcholet laj yalic talel scotol ti jꞌalcꞌopetic ti cꞌu yepal laj echꞌuc talele. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Scotol ti cꞌusi laj yalbe ti jꞌalcꞌopetic ti oy cꞌusi ta xacꞌ ti Diose, jaꞌ avuꞌunic. Ta sventa yoꞌ lec oyoxuc, jech ti Diose laj spas trate schiꞌuc ti jmolmucꞌtotic Abrahame, ti jech laj yal ti Diose: “Ta sventa anitilultac ta staic bendición scotol ti cristianoetic ti oyic ta sjoylej banomile”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Cꞌalal laj xchaꞌcuxes Snichꞌon ti Diose, baꞌyel laj stac talel ta atojolic, yoꞌ jech ta scoltaoxuc, yoꞌ jech ta xavictaic ta spasel ti chopole ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ti Pedroe schiꞌuc ti Juane yacalic ta xcꞌopojic ta stojol ti cristianoetique, cꞌalal jaꞌ o talic ti paleetique schiꞌuc ti banquilal yuꞌunic ti jchabiej temploe, schiꞌuc ti jsaduceoetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Toj capem tal ti sjolique. Yuꞌun ti Pedroe schiꞌuc ti Juane ta xalbe yaꞌi ti cristianoetique ti ta xchaꞌcuxi ti animaetique jech chac cꞌu chaꞌal ichaꞌcuxi ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jech o xal laj stsaquic batel, laj stiqꞌuic comel ta chuquel. Ta yocꞌlomal to laj sloqꞌuesic. Yuꞌun mal xa ti cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ti buchꞌutic laj yaꞌiic ti cꞌu sꞌelan laj yal ti Pedroe ep laj xchꞌunic. Iꞌepajic ti jchꞌunolajeletic nopol voꞌmil ti jaꞌ noꞌox viniquetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta yocꞌlomal tey laj stsob sbaic ta Jerusalén ti banquilaletic yuꞌun ti jꞌisraeletique, schiꞌuc ti moletic ti ichꞌbil yeique, schiꞌuc ti jchanubtasvanejetic yuꞌun ti mantale. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jaꞌ jech xtoc tey oy ti Anas ti banquilal pale to oxe, ti Caifase, ti Juane, ti Alejandroe. Talic xtoc scotolic ti buchꞌutic jaꞌic yutsꞌ yalaltac ti banquilal paleetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tey laj yalic mantal ti acꞌo sloqꞌuesic talel ta chuquinab ti Pedroe schiꞌuc ti Juane. Tsꞌacal to tey lic svaꞌanic ta oꞌlol. Jech lic sjacꞌbeic: ―¿Buchꞌu ta sventa, buchꞌu laj yacꞌboxuc avabtelic ti jech ta xapasique? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ti Pedroe ta sventa ti ventainbil yoꞌnton yuꞌun ti Chꞌul Espíritue, jech laj yal: ―Banquilal jꞌabteletic, moletic yuꞌun ti jlumaltique, ");
INSERT INTO tzotzc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yuꞌun ti jech ta xajaqꞌuic ti ta xacꞌan xanaꞌic ti cꞌu sꞌelan icol ti coxov vinique, ");
INSERT INTO tzotzc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","jamal ta xcalboxuc avaꞌiic yoꞌ jech ta xanaꞌic, yoꞌ jech ta snaꞌic scotol ti jchiꞌiltique. Ti vinic ti colem xa ti ta xavilic ti liꞌ vaꞌal ta atojolique, jaꞌ coltaat yuꞌun ti Jesucristo ta Nazarete, jaꞌ ti Buchꞌu laj ajocꞌanic ta cruze. Pero ichaꞌcuxesat yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ti Jesús taje jaꞌ ti jbej ton ti laj ajipic loqꞌuel ti voꞌoxuc jꞌabteloxuque. Pero jaꞌ itun ta sliquebal ti nae. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Muꞌyuc xa yan ti bu ta jta ti jcoltaeltique. Yuꞌun muꞌyuc laj svaꞌan yan Jcoltavanej ti Dios liꞌ ta banomile. Jaꞌ noꞌox ta sventa Jesús ta jtatic ti jcoltaeltique ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ti jchapanvanejetique laj yilic ti muꞌyuc xiꞌel ta xaꞌiic cꞌalal ta xcꞌopojic ti Pedroe, ti Juane. Laj yilic xtoc ti jaꞌ viniquetic ti muꞌyuc yichꞌojic chanubtasele, ti jaꞌ cristiano noꞌoxe. Jech o xal tey labal ta xaꞌiic. Tey ivul ta yoꞌntonic ti jaꞌic ti jmoj to ox ixanavic schiꞌuc ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jaꞌ jech xtoc ti coxov vinic to oxe tey jmoj vaꞌajtic schiꞌuc ti Pedroe schiꞌuc ti Juane. Jech o xal ti jchapanvanejetique muꞌyuc cꞌusi xuꞌ ta stabeic ti smulique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tey itacatic loqꞌuel ti bu tsobolique. Stuquic xa noꞌox tey xvulajetic comic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jech ta xalbe sbaic: ―¿Cꞌusi ta xcutic ti viniquetic leꞌe? Yuꞌun scotol ti jnaclejetic liꞌ ta Jerusalene laj xa snaꞌic lec ti laj xa yaqꞌuic iluc ti smucꞌul stsatsal ti Diose. Mu xa xuꞌ ta jmuctic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jaꞌ lec, laꞌ jsibtastic yoꞌ jech mu xꞌepajic ti cristianoetic ti buchꞌutic ta xichꞌic albel scꞌoplal ti Jesuse ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jech o xal itaatic ta iqꞌuel yan velta. Tsots iꞌalbatic ti mu xa xalbeic scꞌoplal ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero ti Pedroe, ti Juane jech laj staqꞌuic: ―Jchiꞌiltac, nopo avaꞌiic lec, ¿mi jaꞌ lec ta xil ti Diose ti jaꞌ ta jchꞌuncutic ti amantalique, mi jaꞌ lec ti jaꞌ ta jchꞌunbecutic smantal ti Diose? ");
INSERT INTO tzotzc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yuꞌun ti vuꞌuncutique mu xuꞌ xquicta jbacutic ta yalel ti cꞌusi quilojcutique, ti cꞌusi caꞌyiojcutique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Manchuc mi laj yichꞌic sibtasel yuꞌun ti jchapanvanejetique, pero icoltaatic batel. Yuꞌun mu snaꞌic cꞌusi ta xut yoꞌ ta xacꞌbeic castigo. Jaꞌ ti scotol ti cristianoetique ta xalbeic slequilal ti Diose ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ti vinic ti buchꞌu icol ta sventa smucꞌul stsatsal ti Diose más ta chaꞌvinic (40) jabil yichꞌoj. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ti Pedroe schiꞌuc ti Juane ti cꞌalal icoltaatic batele, tey ibatic ti bu oy ti yan schiꞌiltaque. Tey laj yalic ti cꞌu sꞌelan iꞌalbatic yuꞌun ti banquilal paleetique schiꞌuc ti moletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cꞌalal jech laj yaꞌiique, scotolic jech laj yalic ti laj staic ta cꞌoponel ti Diose: ―Cajval, voꞌot Diosot ti laj apas ti vinajele, ti banomile, ti nabe, scotol ti cꞌusitic oye. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ta sventa ti Chꞌul Espíritu avuꞌune, laj sjam ye ti avajtunel Davide ti jech laj avale: Muꞌyuc cꞌusi bal o ti xvochvun ti cristianoetic ta sjoylej banomile. Muꞌyuc cꞌusi bal o ti cꞌusi ta snop stuquique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ti ajvaliletique schiꞌuc ti jpasmantaletic liꞌ ta banomile laj stsob sbaic, yoꞌ jech ta xiscrontainic ti Diosune schiꞌuc ti Buchꞌu tꞌujbil cuꞌune, Jaꞌ ti Cristoe, xachi ta acꞌop, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ti Herodese, ti Poncio Pilatoe, melel, laj stsob sbaic liꞌ ta Jerusalene schiꞌuc ti jyanlum cristianoetique, schiꞌuc ti jchiꞌilcutique ta scrontainel ti Achꞌul Nichꞌon Jesuse, ti jaꞌ vaꞌanbil avuꞌun ta Jcoltavaneje. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ti jech taje, jaꞌ laj spasic scotol jech chac cꞌu chaꞌal anopoj ti ta xcꞌot ta pasel onoꞌoxe. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Avi tana un, Cajval, qꞌuel avi sꞌelan ta sibtasvanic. Acꞌbun yip coꞌntoncutic ti avajꞌabteluncutique yoꞌ jech mu ta xiꞌeluc ta xcalcutic ti acꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta sventa amucꞌul atsatsal, coleso ti jchameletique. Acꞌo iluc ti tsots xuꞌ avuꞌun ta sventa ti Achꞌul Nichꞌon Jesuse ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cꞌalal jech laj yoꞌntonic ta scꞌoponel ti Diose, tsots inic ti bu stsoboj sbaic ti jchꞌunolajeletique. Scotolic iventainbatic yoꞌntonic yuꞌun ti Chꞌul Espíritue. Oy yip yoꞌntonic ta yalel batel ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ti epal jchꞌunolajeletique jmoj yoꞌntonic scotolic. Mi jaꞌuc oy bu ta xalic ti jaꞌ yuꞌun stuquic ti cꞌusi oy yuꞌunique. Yuꞌun ti cꞌusitic oy yuꞌunique, ta xalic ti jaꞌ yuꞌun scotolic. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ti jcholcꞌopetique tsots xuꞌ yuꞌunic. Ta xalbeic scꞌoplal ti ichaꞌcuxi ti Cajvaltic Jesuse. Scotolic ep ta xꞌacꞌbatic bendición yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Muꞌyuc buchꞌu junucal ta xichꞌ svocol yuꞌunic. Yuꞌun scotolic ti buchꞌutic oy yosilique, mi snaique, ta xchonic. Ta xichꞌic talel ti taqꞌuine. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tey chba yacꞌbeic ti jcholcꞌopetique yoꞌ jech ti stuquique ta xchꞌacbeic ti jchꞌunolajeletic ti buchꞌutic muꞌyuc cꞌusi oy yuꞌunique. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jaꞌ jech laj spas jun vinic ti oy ta stojol ti jchunolajeletique. Ti jun vinic taje, jaꞌ jun levita ti jaꞌ José sbie. Voqꞌuem talel ta Chipre banomil ti joyobtabil ta nabe. Ti jcholcꞌopetique laj yacꞌbeic yan sbi ti Josee, jaꞌ Bernabé, Jpat oꞌntonal, xi ti smelol ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ti vinic taje laj xchon jsep yosil. Ti stojol ti yosile laj yacꞌbe ti jcholcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero oy jun vinic ti jech laj spas eque, ti jaꞌ Ananías ti sbie. Safira sbi ti yajnile. Laj xchon jsep yosilic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ti vinic taje laj xchꞌac comel oꞌlol ti taqꞌuine. Ti oꞌlole yichꞌoj batel ta stojol ti jcholcꞌopetique coꞌol schiꞌuc ti tsꞌacal ti taqꞌuin yilele. Ti yajnile snaꞌoj scotol ti jech laj snopique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ti Pedroe jech laj yal: ―Ananías, ¿cꞌu chaꞌal laj avacꞌ ochuc ta avoꞌnton ti pucuje, ti jech ta xajut cꞌop ta stojol ti Chꞌul Espíritue, ti laj achꞌac comel oꞌlol ti taqꞌuin ti cꞌu yepal latojbat yuꞌun ti avosile? ");
INSERT INTO tzotzc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ti avosil ti laj achone, ¿mi yuꞌun maꞌuc avuꞌun? Ti cꞌalal laj achone, ¿mi yuꞌun maꞌuc avuꞌun ti taqꞌuine? Jech o xal, ¿cꞌu chaꞌal jech laj anop? Maꞌuc laj aloꞌla ti cristianoetique. Jaꞌ laj aloꞌla ti Diose ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cꞌalal jech laj yaꞌi ti Ananíase, ta ora noꞌox tey yal ta lum. Chamel icꞌot. Scotol ti buchꞌutic laj yaꞌiic taje, lic xiꞌicuc ta jmec. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tey italic jun chib jvaꞌlej viniquetic. Laj xpixic ta pocꞌ ti animae. Tey bat smuquic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Echꞌ xa ox nan oxib ora, jaꞌ o iꞌoch batel yajnil ti Ananíase. Mu snaꞌ ti cꞌusi icꞌot ta pasele. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ti Pedroe tey laj sjacꞌbe ti antse: ―Albun caꞌi, ¿mi jech onoꞌox yepal stojol ti avosilic jech chac cꞌu chaꞌal laj avalique? ―xi. Jech laj yal ti antse: ―Jaꞌ jech yepal stojol ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ti Pedroe jech laj yal: ―¿Cꞌu chaꞌal jech jmoj avoꞌntonic ti ta xalajeltsabeic yoꞌnton ti Chꞌul Espíritu yuꞌun ti Cajvaltique? Leꞌ xtalic ti viniquetic ti buchꞌutic ay smuquic ti amalale. Avi tana ta xayiqꞌuic batel ec ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta ora noꞌox tey iyal ta lum ta yoc ti Pedroe. Chamel icꞌot. Cꞌalal iꞌochic ti jmucvanejetique, chamem xa vul staic ti ants xtoque. Tey laj spoyic loqꞌuel. Tey ba smuquic ta xocon ti smalale. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ti jchꞌunolajeletique schiꞌuc ti yan cristianoetique cꞌalal laj yaꞌiic ti cꞌusi icꞌot ta pasele, toj echꞌem ixiꞌic ta jmec. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ti jcholcꞌopetique ep laj yaqꞌuic iluc smucꞌul stsatsal ti Diose ta stojol ti cristianoetique. Scotolic ta stsob sbaic ta coreol ti jaꞌ Salomón sbie. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ti yan cristianoetique oy xiꞌel ta yoꞌntonic ti ta stsob sbaic schiꞌuc ti jchꞌunolajeletique. Pero ta xalic ti toj lec ti stalelique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ep ti cristianoetique laj xchꞌunic ti Cajvaltique, viniquetic, antsetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ti cristianoetique ta sloqꞌuesic ta calle ti jchameletic yuꞌunique. Tey xtal xpuchꞌanic schiꞌuc stem o mi schiꞌuc svayeb ti jchameletique. Jaꞌ ti spatoj yoꞌntonique, acꞌo mi snacꞌobal noꞌox ti Pedro ta xcꞌot ta stojol ti jchameletique, yoꞌ jech ta xcolic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jaꞌ jech xtoc ti cristianoetic ti nacajtic ta jujun jteclum ti oy ta sjoylej ti Jerusalene, ta xicꞌanic talel ti yajchamelique schiꞌuc ti buchꞌutic ta xꞌilbajinatic yuꞌun ti pucujetique. Scotolic icolic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ti banquilal palee schiꞌuc ti jsaduceoetic ti jmoj sjolic schiꞌuque lic yitꞌixal yoꞌntonic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jech o xal laj stsaquic, laj stiqꞌuic ta mucꞌ ta chuquinab ti jcholcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ti ta acꞌobaltique, tal sjam ti tiꞌ chuquinab jun yajꞌángel ti Cajvaltique. Laj sloqꞌues batel ti jcholcꞌopetique. Jech laj yalbe: ");
INSERT INTO tzotzc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Locꞌan batel. Batanic ta mucꞌ ta templo. Ba albeic yaꞌi ti cristianoetique scꞌoplal ti achꞌ cuxlejale ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ti cꞌalal jech laj yaꞌiique, sob xa ta yocꞌlomal ibatic ta templo. Tey lic chanubtasvanicuc. Yan ti banquilal palee schiꞌuc ti jsaduceoetique laj stsob sbaic talel scotol ti banquilal jchapanvanejetique, jaꞌic ti moletic yuꞌun ti jꞌisraeletique. Tey laj yalic mantal ti acꞌo yichꞌ loqꞌuesel talel ta chuquinab ti jcholcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cꞌalal icꞌotic ta chuquinab ti mayoletique, muꞌyuc xa tey laj staic. Isutic batel, bat yalic ti muꞌyuc xa tey laj staique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Jech cꞌot yalic: ―Lec bajal laj jtacutic ti tiꞌ chuquinabe. Tey vaꞌajtic ti soldadoetique xchabiojic ti tiꞌ chuquinabe. Pero cꞌalal laj jamcutique, muꞌyuc xa tey laj jtacutic ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cꞌalal jech laj yaꞌiic ti banquilal palee schiꞌuc ti banquilal jchabiej temploe, schiꞌuc ti paleetique, tey lic sjacꞌbe sbaic: ―¿Bu to onoꞌox cꞌalal ta xpaj ti cꞌop taje? ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Cꞌalal jech ta xalbe sbaique, jaꞌ o tal jun vinic ti jech vul yale: ―Ti viniquetic ti laj atiqꞌuic ta chuquele tey xa oy ta templo ta xchanubtas ti cristianoetique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jech ti banquilal yuꞌun ti jchabiej temploe tey ibatic schiꞌuc ti yajmayoltaque. Tey laj stsaquic talel ti jcholcꞌopetique. Pero lec noꞌox laj yiqꞌuic talel. Jaꞌ ti oy xiꞌel ta xaꞌiic mi ta xlajic ta ton yuꞌun ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cꞌalal laj yiqꞌuic talele, cꞌot yaqꞌuic ta stojol ti banquilal jchapanvanejetique. Jech ti banquilal palee jech laj yal: ");
INSERT INTO tzotzc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ti vuꞌuncutique laj xa calboxuc avaꞌiic ti mu xa xavalbe scꞌoplal ti vinic taje. Pero, ¿bu ibat avuꞌunic ti mantale? Yuꞌun ivinaj xa avuꞌunic sjunul Jerusalén ti cꞌu sꞌelan ta xachanubtasvanique. Pero maꞌuc noꞌox. Yuꞌun ta xacajan ta jbacutic ti jech icham ti vinic taje ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jech ti Pedroe schiꞌuc ti yan jcholcꞌopetique jech itacꞌavic: ―Jaꞌ cabtelcutic ti ta jchꞌunbecutic smantal ti Diose manchuc mi mu scꞌanic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ti Dios yuꞌun ti jmolmucꞌtotique laj xchaꞌcuxes ti Jesuse, jaꞌ ti Buchꞌu laj ajipanic ta cruze. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ti Diose laj xa yacꞌ ta sbatsꞌi cꞌob ti Jesuse. Jaꞌ xa banquilal Ajvalil. Jaꞌ xa Jcoltavanej cuꞌuntic ti jꞌisraelotique, yoꞌ xuꞌ to ta xquictatic ti chopol coꞌntontique, yoꞌ jech ta jtatic perdón yuꞌun ti jmultique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ti jech taje, rextigouncutic schiꞌuc ti Chꞌul Espíritue ti iꞌacꞌbat ti buchꞌutic ta xchꞌunbeic ti cꞌusi ta scꞌan ti Cajvaltique ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cꞌalal jech laj yaꞌiique, icap sjolic. Ta scꞌan ta smilic yaꞌiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ti ta scotolic ti jchapanvanejetique oy tey jun jfariseo vinic ti Gamaliel ti sbie. Jaꞌ jun banquilal jchanubtasvanej yuꞌun ti mantale, ti ichꞌbil ta mucꞌ yuꞌun ti cristianoetique. Laj yal mantal ti acꞌo yichꞌ loqꞌuesel jliqueluc ti jcholcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tsꞌacal to un, jech lic yalbe ti jchapanvanejetique: ―Jchiꞌiltac, bijanic me ti cꞌusi ta xapasbeic ti viniquetic liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vuleso me ta avoꞌntonic scꞌoplal ti Teudas ta voꞌnee. Ti Teudase laj snop ti cajal xaꞌi sbae. Tey tsꞌacliat yuꞌun nopol chanib ciento (400) viniquetic. Pero ilaj ta milel. Jech ti schiꞌiltaque tan puc ibat. Tey laj o scꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsꞌacal to un, jaꞌ jech laj spas ti Judas xtoque, jaꞌ ti buchꞌu liquem talel ta Galilea banomile. Cꞌalal ista sjabilal ti tsacobbiile, ep viniquetic laj stsꞌacliic batel. Pero jech xtoc ilaj ta milel. Ti schiꞌiltaque tey laj stani sbaic batel. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jech o xal chꞌan utic ti viniquetic liꞌe. Mu xaticꞌ abaic ta stojolic. Yuꞌun ti mi jaꞌ noꞌox smantal cristiano ti cꞌusi ta spasique, tey ta xlaj scꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero mi jaꞌ yabtel Dios ti cꞌusi ta spasique, mu xuꞌ ta xachꞌaybeic scꞌoplal. Jaꞌ lec, bijanic me, naca me jaꞌuc ta xacrontainic ti Diose ―xi ti Gamaliele. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Scotol ti jchapanvanejetique oy smelol laj yaꞌiic ti cꞌusi laj yal ti Gamaliele. Tey laj yiqꞌuic ochel ti jcholcꞌopetic ta stojol ti jchapanvanejetique. Tey laj yacꞌbeic nucul. Jaꞌ jech xtoc tey laj yalbeic ti mu xa xuꞌ ta xalbeic scꞌoplal ti Jesuse. Tsꞌacal to laj scoltaic batel. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ti jcholcꞌopetique xmuyubajic xa iloqꞌuic batel ta stojol ti jchapanvanejetique. Jaꞌ ti jech laj scꞌan ti Dios ti ta xichꞌic qꞌuexlal ta sventa ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pero mu xicta sbaic ta yalel scꞌoplal ti Jesucristoe. Tey onoꞌox ta xchanubtasvanic jujun cꞌacꞌal tey ta templo schiꞌuc ta naetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tsꞌacal to un, cꞌalal iꞌepajic ti jchꞌunolajeletique, lic cꞌop yuꞌunic. Ti jsaꞌcꞌopetique, jaꞌic ti jꞌisraelal jchꞌunolajeletic ti ta xcꞌopojic ta griego cꞌope. Lic yalic ti jaꞌ cꞌuxubinbil ti meꞌunal antsetic ti ta xcꞌopojic ta hebreo cꞌope, ti jaꞌ muꞌyuc cꞌuxubinbil ti meꞌunal antsetic yuꞌunique ti cꞌalal ta xichꞌ chꞌaquel ti veꞌlil jujun cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jech o xal ti lajchaꞌvoꞌ jcholcꞌopetique lic stsobic talel scotol ti jchꞌunolajeletique. Jech lic yalic: ―Mu lecuc ti mi jaꞌ ta jpajtsan jbacutic ta yalel ti lequil achꞌ cꞌop yuꞌun ti Diose, yoꞌ jech ta jventaincutic ta xchꞌaquel ti veꞌlile. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jech o xal, Quermanotac, jaꞌ lec, tꞌujic vucvoꞌ viniquetic ti liꞌ oy ta jtojoltique, ti ojtiquinbil lec avuꞌunique, ti oy sbijilique, ti ventainbil yoꞌntonic yuꞌun ti Chꞌul Espíritue. Jaꞌ acꞌo sbainic ti abtel liꞌe. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jech ti vuꞌuncutique jaꞌ noꞌox ta jtacutic ta cꞌoponel ti Diose schiꞌuc ta xcalcutic ti scꞌop Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lec laj yaꞌiic scotolic ti jech taje. Tey lic stꞌujic: Ti Estebane (Jaꞌ jun vinic ti xchꞌunoj ti Cajvaltique, ti ventainbil yuꞌun ti Chꞌul Espíritue.) Ti Felipee Ti Prócoroe Ti Nicanore Ti Timone Ti Parmenase Ti Nicolase (Jaꞌ jun jyanlum vinic ti liquem talel ta Antioquíae, ti xchꞌunoj to ox cꞌu sꞌelan xchꞌunojic ti jꞌisraeletique.) ");
INSERT INTO tzotzc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Cꞌalal laj stꞌujique, tey yicꞌojic batel ta stojol ti jcholcꞌopetique. Tey laj scꞌoponbeic Dios ta stojolic. Tey laj scajan scꞌobic ta sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jech ti scꞌop Diose yantic ta xbol batel. Jaꞌ jech xtoc yantic ta xꞌepajic batel ti jchꞌunolajeletic ti ta Jerusalene. Jech xtoc ep paleetic yuꞌun ti jꞌisraeletique laj xchꞌunic ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ti Estebane jaꞌ jun vinic ti yichꞌojbe smucꞌul stsatsal slequilal ti Diose. Jech o xal ep laj yacꞌ iluc smucꞌul stsatsal Dios ta stojol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Oy jayvoꞌ jꞌisraeletic ti ta stsob sbaic ta chꞌul na ti Colemic xa ta mosovil sbie. Jaꞌic tey liquemic talel ta jteclum Cirene, ta jteclum Alejandría, ta Cilicia, ta Asia. Ti vaꞌi yepalic taje tey lic stsaquic ta cꞌop ti Estebane. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero mu xuꞌ ta stsalic ta cꞌop ti Estebane. Jaꞌ ti acꞌbil sbijil yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jech o xal ti jsaꞌcꞌopetique laj stojic jun chib viniquetic yoꞌ acꞌo yalic ti laj yaꞌiic ti chopol ta xcꞌopoj ta stojol ti Moisese, ta stojol ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jech o xal tey xvochlajetic xa liquel ti cristianoetique, ti moletique, ti jchanubtasvanejetic yuꞌun ti mantale. Jech o xal tey ibatic, laj stsaquic ti Estebane. Laj yiqꞌuic batel ta stojol ti banquilal jchapanvanejetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jaꞌ jech xtoc laj saꞌic yan jutcꞌop rextigoetic ti jech laj yalique: ―Ti vinic liꞌe mu xicta sba ti chopol ta xcꞌopoj ta stojol ti chꞌul templo cuꞌuntique schiꞌuc ti mantale. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Laj caꞌicutic xtoc ti jech ta xale: “Ti Jesús ta Nazarete ta slilin ti temploe. Ta syanijes ti cꞌu sꞌelan liquem cuꞌuntic ti laj yacꞌbotic comel ti Moisese”, xi ta xal ―xiic ti jutcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Scotolic ti jchapanvanejetique schiꞌuc ti cristianoetic ti cꞌu yepal tey chotolique, cꞌalal laj sqꞌuelbeic batel sat ti Estebane, tey laj yilic ti coꞌol sꞌelan sat jun ángele. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ti banquilal palee jech lic sjacꞌbe ti Estebane: ―¿Mi jech scotol taje? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ti Estebane jech laj stacꞌ: ―Jtot meꞌoxuc, Jchiꞌiltac, aꞌyibeicun avaꞌiic lec ti cꞌusi ta xcalboxuque. Ti Chꞌul Dios cuꞌuntique laj yacꞌ sba iluc ta stojol ti jmolmucꞌtotic Abrahame ti cꞌalal nacal to ox ta Mesopotamia banomile, cꞌalal muꞌyuc to ox ta xbat nacluc ta Harane. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jech laj yal ti Diose: “Ictao comel ti avosile, scotol ti avutsꞌ avalaltaque. Batan ta banomil ti bu ta xcacꞌbot avile”, xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jech o xal ti Abrahame ilocꞌ batel ti jech nacal to ox ta Caldea banomile. Ibat nacluc ta Harán. Tey icham ti stote. Tsꞌacal to un, ti Abrahame icꞌat talel yuꞌun ti Diose liꞌ ta jlumaltic ti liꞌ nacalotic avi tanae. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero mi jaꞌuc jun ta yav acꞌanil laj sta ti srexto osil ti iꞌacꞌbat ti Abraham yuꞌun ti Diose. Pero iꞌalbat yuꞌun ti Diose ti cꞌalal ta xcham ti Abrahame, jaꞌ ta xꞌacꞌbat yichꞌic ti snichꞌnabtaque manchuc mi muꞌyuc to ti snichꞌnabe. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jaꞌ jech xtoc ti Abrahame iꞌalbat yuꞌun ti Diose ti coꞌol sꞌelan jyanlumetic ta xanavic ta yan banomil ti snitilultaque, ti ta xꞌochic ta mosovil chanib ciento (400) jabil ti ta xꞌilbajinatique. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jaꞌ jech xtoc ti Abrahame jech iꞌalbat yuꞌun ti Diose: “Pero vuꞌun ta jchapan ti jteclum ti buchꞌu ta smosovinvane. Tsꞌacal to un, ta xloqꞌuic talel ti anitilultaque, yoꞌ jech xtal yichꞌicun ta mucꞌ ta banomil liꞌe”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ti Diose laj spasic jun trate schiꞌuc ti Abrahame. Svinajeb ti tratee, jaꞌ ti circuncisione. Jech o xal cꞌalal ivocꞌ snichꞌon ti Abrahame, jaꞌ ti Isaaque, laj yacꞌbe yichꞌ circuncisión cꞌalal yichꞌoj xa ox svaxaquibal cꞌacꞌal svoqꞌuele. Jaꞌ jech laj spas xtoc ti Isaaque schiꞌuc ti snichꞌone, jaꞌ ti Jacobe. Jaꞌ jech laj spas xtoc ti Jacobe schiꞌuc ti snichꞌnabtaque, jaꞌ ti lajchaꞌvoꞌ totil meꞌiletic ti bu lijꞌayanotic talele. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ti snichꞌnabtac ti Jacob taje, ti jaꞌic ti jtotic jmeꞌtic ta voꞌnee, lic yitꞌixal yoꞌntonic yuꞌun ti schiꞌilic ta voqꞌuele, jaꞌ ti Josee. Jech o xal laj xchonic yoꞌ ta xꞌicꞌat batel ta Egipto banomil. Pero ti Josee chiꞌinbil yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Scotol svocol ti Josee, icoltaat yuꞌun ti Diose. Iꞌacꞌbat sbijil. Jech o xal laj sta ti lec iꞌilat yuꞌun ti Faraone, ti jaꞌ ajvalil yuꞌun ti Egipto banomile. Jech ti Faraone laj svaꞌan ti Josee yoꞌ ta sventain ti Egipto banomile schiꞌuc ti laj sventainbe sna stuc ti ajvalil Faraone. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Jech xtoc lic mucꞌ ta viꞌnal. Tey laj yichꞌ svocolic scotol ti cristianoetic ti oyic ta Egipto banomile, ti oyic ta Canaan banomile. Jech o xal ti jmolmucꞌtotique muꞌyuc xa bu ta sta ti sveꞌelique. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Cꞌalal laj yaꞌi ti Jacob ti oy trigo ta Egipto banomile, tey laj stac batel ti snichꞌnabtaque, jaꞌic ti jmolmucꞌtotic ta voꞌnee. Jaꞌ sba velta ti ibatic taje. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ti cꞌalal ibatic ta schibal veltae, ti Josee laj yacꞌ sba ta ojtiquinel ta stojol ti sbanquiltaque. Jech ti ajvalil ti oy ta Egiptoe laj snaꞌ ti jaꞌ jun hebreo vinic ti Josee. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jech ti Josee laj stac ta iqꞌuel ti stote, jaꞌ ti Jacobe schiꞌuc ti yutsꞌ yalaltaque. Ti ta scotolique, oy voꞌlajuneb schanvinic (75) ta voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jaꞌ jech sꞌelan icꞌot ta pasel ti ba nacluc ta Egipto banomil ti Jacobe. Tey icham ta Egipto. Tey chamic xtoc ti jmolmucꞌtotic ta voꞌnee. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tsꞌacal to un, ti sbaquil ti jmolmucꞌtotic Jacobe laj xcuchbeic loqꞌuel ti ta Egiptoe. Tey bat smuquic ta osil ti bu laj sman ti Abrahame, ti jaꞌ yosilic to ox ti snichꞌnabtac ti Hamor ti oy ta Siqueme. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Cꞌalal poꞌot xa sta yorail ti ta xcꞌot ta pasel ti cꞌusi yaloj onoꞌox ti Dios ta stojol ti Abrahame, jech ti jꞌisraeletic ti tiqꞌuilic ta Egipto banomile ta xꞌepajic ta jmec. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tey och jun ajvalil ti ta Egiptoe ti muꞌyuc laj yojtiquin ti anima Josee. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ti ajvalil taje laj sloꞌla laj yutilan ti jmolmucꞌtotic ta voꞌnee. Laj yalbe mantal ti acꞌo sjipic ti achꞌ voqꞌuel ololetique yoꞌ jech ta xchamic. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti jech yorail taje, jaꞌ o ivocꞌ ti Moisese, ti jaꞌ jun querem ti lec ta xil ti Diose. Ti stot smeꞌ ti neneꞌ Moisese tey laj stsꞌitesic oxib u ta yut snaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Cꞌalal sta yorail ti bat sjipique, jaꞌ stuc ti yantsil nichꞌon ti ajvalile laj stam, laj stsꞌites jech chac cꞌu chaꞌal junuc yol stuc. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jech o xal un, ti Moisese ichanubtasat scotol ti cꞌu sꞌelan sbijilic ti jꞌepicio cristianoetique. Oy yip ti scꞌop ti cꞌusi ta xale schiꞌuc ti cꞌusi ta spase. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Cꞌalal yichꞌoj xa chaꞌvinic (40) jabile, ti Moisese bat svuꞌlan ti schiꞌiltaque, jaꞌ ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jaꞌ o tey laj yil ti ta xmajat yuꞌun jun jꞌejipcio vinic ti jun schiꞌile. Jech o xal ti Moisese ba sticꞌ sba yoꞌ jech ta spoj, yoꞌ ta spac sutel ti cꞌusi ta spasbat ti schiꞌile. Tey laj smil comel ti jꞌepicio vinique. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yuꞌun laj snop ti Moisese ti acꞌo yilic ti schiꞌiltaque ti ta xcoltaatic yuꞌun ti Dios ta sventa ti stuque. Pero ti schiꞌiltaque muꞌyuc laj snaꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta yocꞌlomal un, tey laj yil ti Moisese ti ta smaj sbaic chaꞌvoꞌ jꞌisraeletic. Jech o xal ti Moisese ba sticꞌ sba yoꞌ ta spajtsan ti schiꞌiltaque. Jech laj yalbe: “¿Cꞌu chaꞌal ta xamaj abaic ti jaꞌ achiꞌil abaique?”, xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ti buchꞌu ta xꞌilbajin ti schiꞌile laj stacꞌolta batel ti Moisese. Jech laj yal: “¿Buchꞌu laj yacꞌbot avabtel yoꞌ jech ta xacom ta ajvalil ti jech ta xachapanuncutique? ");
INSERT INTO tzotzc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Mi yuꞌun ta xacꞌan ta xamilun avaꞌi jech chac cꞌu chaꞌal volje laj amil ti jꞌepico vinique?”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cꞌalal jech laj yaꞌi ti Moisese, ijatav batel cꞌalal yosilal Madián sbi. Tey inaqui jech chac cꞌu chaꞌal jyanlum cristiano. Tey iꞌayan chaꞌvoꞌ snichꞌon. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Cꞌalal chaꞌvinic (40) xa ox jabil snacleje, oy jun cꞌacꞌal ta xanav ta xocol banomil nopol vits Sinaí. Tey laj yil jun ángel ta jpets biqꞌuit teꞌ ti volol ta cꞌocꞌ ti ta xa xcꞌacꞌ yilele. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ti Moisese elom laj yaꞌi ti cꞌusi laj yile. Cꞌalal inopaj batel yoꞌ ta sqꞌuel yil leque, jaꞌ o laj yaꞌibe scꞌopojel ti Cajvaltic Dios ti jech laj yale: ");
INSERT INTO tzotzc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Vuꞌun Diosun yuꞌun ti amolmucꞌtotaque. Diosun yuꞌun ti Abrahame, yuꞌun ti Isaaque, yuꞌun ti Jacobe”, xi. Cꞌalal jech laj yaꞌi ti Moisese, lic nicuc ta xiꞌel. Mi jaꞌuc xa scꞌan sqꞌuel batel ti cꞌoqꞌue. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pero ti Cajvaltic Diose jech laj yal: “Loqꞌueso ti axonobe. Yuꞌun ti bu vaꞌalote, jaꞌ chꞌul banomil. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yuꞌun laj xa quil ti oy svocolic ti calab jnichnab ti oy ta Egiptoe. Laj xa caꞌi ti xꞌajlajetic yuꞌun ti svocolique. Jech o xal liyal talel yoꞌ tal jcolta loqꞌuel ta mosovil. Laꞌ chaꞌe, yuꞌun ta jtacot batel ta Egipto”, xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Acꞌo mi jech bajbil ti Moisés yuꞌun ti schiꞌiltaque, manchuc mi iꞌalbat: “¿Buchꞌu laj stacot talel yoꞌ ta xacom ta ajvalil ta jchapanvanej cuꞌuncutic?”, ti xꞌutate, pero ti Diose laj stac batel, yoꞌ ta xcom ta ajvalil, yoꞌ ta xcom ta jcoltavanej. Jaꞌ jech icoltaat ta sventa ti ángel ti laj yacꞌ sba iluc ta jpets teꞌ ti ta xa xcꞌacꞌ yilele. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ti Moisés taje laj sloqꞌues talel ti jmolmucꞌtotic ti oyic to ox ta mosovil ti ta Egiptoe. Tey laj yacꞌ iluc smucꞌul stsatsal Dios ti ta Egiptoe, ti ta Tsajal Nabe, schiꞌuc chaꞌvinic (40) jabil ti tey oyic ta xocol banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ti Moisés taje jaꞌ laj yalbe yaꞌi ti jchiꞌiltic ta voꞌnee: “Ti Diose ta stacboxuc talel jun jꞌalcꞌop ti ta xꞌayan ta atojolique jech chac cꞌu chaꞌal ti listacun talel ti vuꞌune. Ichꞌic me ta mucꞌ ti cꞌusi ta xale”, xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaꞌ onoꞌox ti Moisés taje ti tey schiꞌuc ti jchiꞌiltic ta xocol banomile. Jaꞌ ta sventa ti Moisese ti ta xaꞌiic ti jchiꞌiltic ti cꞌu sꞌelan icꞌopoj ti ángel ti ta jol vits Sinaie. Jaꞌ jech xtoc laj yichꞌ ti cꞌop ti jaꞌ cuxlejale yoꞌ jech ta xiyetꞌesbotic talel. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero ti jmolmucꞌtotic ta voꞌnee muꞌyuc laj yichꞌic ta mucꞌ ti Moisese. Laj sbajic. Jaꞌ noꞌox oy ta yoꞌntonic ti ta sutic batel yaꞌiic ta Egipto banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jech o xal un, ti jmolmucꞌtotique laj yalbeic ti Aarone: “Ta jcꞌancutic ti ta xameltsanbuncutic jayibuc rioxetic yoꞌ jech ta xiyicꞌotic batel. Yuꞌun mu jnaꞌtic cꞌusi laj spas ti Moisese ti cꞌalal laj sloqꞌuesotic talel ta yosilal Egiptoe”, xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jech o xal un, tey laj smeltsanic ti riox yuꞌunique, jaꞌ slocꞌobbail jun neneꞌ vacax. Laj smilbeic smoton. Xmuyubajic xa laj spasbeic sqꞌuinal ti srioxic ti laj smeltsan ta scꞌob stuquique. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jech ti Diose tey laj xchꞌac sba batel ta stojolic. Tey laj yacꞌbe comel ta sba ti acꞌo yichꞌic ta mucꞌ ti cꞌanaletic ti oy ta vinajele coꞌol sꞌelan jech chac cꞌu chaꞌal tsꞌibabil ta slibro ti jꞌalcꞌopetique: Ti voꞌoxuc jꞌisraeloxuque ti chaꞌvinic jabil ti laxanavic ta xocol banomile, ¿mi jaꞌ laj avaqꞌuic ta jmoton ti animaletic laj amilique? ");
INSERT INTO tzotzc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Moꞌoj, yuꞌun jaꞌ noꞌox acuchojic batel ti avajrioxic Moloc ti tiqꞌuil ta caxae schiꞌuc ti slocꞌobbail ti cꞌanal riox Refán sbie. Jaꞌ noꞌox slocꞌobbail ti laj ameltsan atuquic yoꞌ jech ta xavichꞌic ta mucꞌ. Jech o xal ta jloqꞌuesoxuc batel ta alumalic. Ta jtacoxuc batel ta sjelavel to ti Babilonia banomile, xi ti tsꞌibabile. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ti ta xocol banomile, ti jmolmucꞌtotique tey yichꞌojic ti templo nucule, ti bu chabibil ti chaꞌpech ton ti jaꞌ tey tsꞌibabil smantal ti Diose. Ti templo nucule jaꞌ jech laj yichꞌ pasel jech chac cꞌu chaꞌal iꞌalbat ti Moisés yuꞌun ti Diose cꞌalal iꞌalbat ti jech sꞌelan acꞌo spas jech chac cꞌu chaꞌal iꞌacꞌbat yile. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ti templo nucule xcholet itun yuꞌunic ti jmolmucꞌtotique. Ti jmolmucꞌtotic ti laj xchiꞌinic talel ti Josuee, laj yichꞌic ochel ti templo nucule cꞌalal laj spasic ta canal ti jyanlum cristianoetic ti liꞌ to ox oyic ta jlumaltique. Ti jech taje, jaꞌ stuc ti Diose laj sloqꞌues batel ti jyanlum cristianoetique yoꞌ jech ta xꞌoch naclicuc ti stuquique. Jaꞌ jech sꞌelan xcholet laj sventainic talel ti templo nucul ti jmolmucꞌtotique, jaꞌ to cꞌalal ista yorail ti och ta ajvalil ti Davide. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","’Ti ajvalil Davide laj sta ti lec iꞌilat yuꞌun ti Diose. Jech o xal un, ta ox svaꞌan jun mucꞌ ta templo yoꞌ jech ta xnaqui ti Dios yuꞌun ti Jacobe. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero jaꞌ xa laj smeltsan ti templo yuꞌun ti Diose ti ajvalil Salomone. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero ti cajal Diose mu xnaqui ta templo ti meltsanbil yuꞌun ti cristianoetique jech chac cꞌu chaꞌal laj yal ti jun jꞌalcꞌope: ");
INSERT INTO tzotzc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ti vinajele jaꞌ tey chotolun. Ti banomile jaꞌ stecꞌleb coc. Jech o xal un, ¿cꞌusi xa nailal ta jcꞌan ta spasbeicun? ¿Bu oy ti na ti xuꞌ ta jcux coꞌntone? ");
INSERT INTO tzotzc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Mi mu ta jcꞌobuc laj jmeltsan scotol ti cꞌusitic oye? xi ti Diose, xi ti jꞌalcꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Pero ti voꞌoxuque staoj yav ti toj yij ti avoꞌntonique. Ti achiquinique, ti avoꞌntonique coꞌol sꞌelan jech chac cꞌu chaꞌal ti buchꞌu mu xojtiquinic ti Diose. Jaꞌ noꞌox ta xacrontainic ti Chꞌul Espíritue jech chac cꞌu chaꞌal laj spasic ti jmolmucꞌtotique. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Buchꞌu junucal ti jꞌalcꞌopetic ti muꞌyuc laj yilbajinic ti amolmucꞌtotique? Ti stuquique laj smilic ti jꞌalcꞌopetic ti laj yalbeic scꞌoplal ti oy Buchꞌu ta xtal ti lec yoꞌntone. Caꞌlal jech ital ti Buchꞌu lec yoꞌntone, voꞌoxuc laj avaqꞌuic ta cꞌabal. Laj amilic. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ti voꞌoxuque laj avichꞌic ti mantale ta sventa ti ángeletique. Pero muꞌyuc laj achꞌunic ―xi ti Estebane. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cꞌalal jech laj yaꞌiic ti jchapanvanejetique, cap sjolic. Xcꞌuxuxet xa yeic ta scrontainel ti Estebane. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ti Estebane, ti ventainbil yoꞌnton yuꞌun ti Chꞌul Espíritue, laj sqꞌuel muyel ti vinajele. Laj yilbe yutsilal ti Diose. Tey laj yil ti Jesús ti vaꞌal ta sbatsꞌi cꞌob ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jech lic yal: ―Qꞌuel avilic, jamal ti vinajel ta xquile. Tey vaꞌal ta sbatsꞌi cꞌob Dios ti Jesús ti coꞌol jꞌelantique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero ti jchapanvanejetique laj smac ti schiquinique. Xꞌavlajetic xa bat stsaquic ti Estebane. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tey laj yiqꞌuic batel ta stiꞌil jteclum. Tey ba yacꞌbeic ton. Ti rextigoetique laj yaqꞌuic comel ta chabiel scꞌuꞌic ta stojol ti querem vinic Sauloe. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Cꞌalal jech yacal ta xacꞌbeic ton ti Estebane, jech lic sta ta cꞌoponel ti Diose: ―Cajval Jesús, ichꞌbun ta aventa ti jchꞌulele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsꞌacal to un, lic squejan sba. Tsots lic avanuc: ―Cajval, mu me xavacꞌ ta avoꞌnton smulic ti cristianoetic liꞌe ―xi. Cꞌalal jech laj yale, jaꞌ o icham. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ti Sauloe xmuyubaj xa ti jech ilaj ta milel ti Estebane. Jaꞌ o yorail ilic yichꞌic ilbajinel ti jchꞌunolajeletic ti ta Jerusalene. Scotolic ti jchꞌunolajeletique iloqꞌuic ta Jerusalén. Tan puc ibatic. Jlom tey itanijic ta Judea banomil. Jlom tey ibatic cꞌalal Samaria banomil. Jaꞌ xa noꞌox tey icomic ta Jerusalén ti lajchaꞌvoꞌ jcholcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oy jun chib viniquetic ti oy scꞌuxul yoꞌntonique laj smuquic ti Estebane. Ep laj yoqꞌuitaic ti Estebane. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yan ti Sauloe tey sujoj sba ta yilbajinel ti jchꞌunolajeletique. Tey ta xjochan loqꞌuel ta jujun naetic viniquetic, antsetic, yoꞌ jech ta stac batel ta chuquel. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ti jchꞌunolajeletic ti buchꞌutic itanijic loqꞌuel ta Jerusalene, buꞌyuc noꞌox ti ta xanavique, ta xalic ti lequil achꞌ cꞌop ti jaꞌ colebale. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Oy jun ta scotol ti jchꞌunolajeletic ti jaꞌ Felipe sbie. Ti Felipee ibat ta jun jteclum ti oy ta Samaria banomile. Tey lic yalbe yaꞌi ti cristianoetique scꞌoplal ti Cristoe. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ti cristianoetic ti ta jteclume laj stsob sbaic. Ta sjunul yoꞌntonic tsꞌetel schiquinic ta xaꞌiic ti cꞌusi ta xal ti Felipee. Jaꞌ jech xtoc laj yilic smucꞌul stsatsal Dios ti laj yacꞌ iluque. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yuꞌun ep ti cristianoetic ti ta xꞌilbajinatic yuꞌun ti pucujetique ta xcolic. Ti pucujetic ti cꞌalal ta xlocꞌ batele, tsots ta xꞌavan. Jaꞌ jech xtoc ep jtꞌeltꞌel chameletic, coxovetic laj colicuc. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jaꞌ yuꞌun un, xmuyubajic xa scotol ti jteclume. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Oy tey jun vinic, Simón sbi, ti jaꞌ jꞌacꞌchamel to oxe. Ep laj sloꞌla ti cristianoetic ti oyic ta Samaria banomile, yuꞌun ta xal ti tsots xuꞌ yuꞌune. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Scotol ti cristianoetique, cꞌalal ta biqꞌuit ta mucꞌ, tsꞌijilic ta xaꞌibeic scꞌop ti Simone. Jech ta xalic ti cristianoetique: ―Ti vinic leꞌe yichꞌojbe smucꞌul stsatsal ti Diose ―xi scꞌoplal. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Scotolic laj yichꞌic ta mucꞌ ti Simone. Jaꞌ ti jal laj sloꞌla ti cristianoetic yuꞌun ti yacꞌ chamelal to oxe. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero ti cristianoetic ti cꞌalal lic xchꞌunic ti lequil achꞌ cꞌop ti laj yal ti Felipee, scꞌoplal ti Jesucristoe, schiꞌuc scꞌoplal ti ventainele, jech o xal un, laj yichꞌic voꞌ, viniquetic, antsetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jaꞌ jech xtoc ti Simone laj xchꞌun, laj yichꞌ voꞌ ec. Tey lic xchiꞌin ta xanobal ti Felipee. Toj elom ta xaꞌi ti cꞌu sꞌelan ta xacꞌ ta ilel smucꞌul stsatsal Dios ti Felipee. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ti jcholcꞌopetic ti oyic ta Jerusalene laj yaꞌiic ti laj xchꞌunic scꞌop Dios ti jsamariaetique. Jech o xal tey laj staquic batel ti Pedroe, ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cꞌalal icꞌotique, laj scꞌoponbeic Dios ta stojol ti Samaria jchꞌunolajeletique, yoꞌ jech ta xichꞌic ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jech laj spasic, yuꞌun mu to junuc yichꞌojic ti Chꞌul Espíritue. Yuꞌun jaꞌ to noꞌox yichꞌojic voꞌ sventa ti Cajvaltic Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jech o xal ti Pedroe, ti Juane tey laj scajan scꞌobic ta sba ti jchꞌunolajeletique. Jaꞌ o laj yichꞌic ti Chꞌul Espíritue. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Cꞌalal jech laj yil ti Simone ti ta xichꞌic Chꞌul Espíritu ti jchꞌunolajeletic ti cꞌalal ta scajan scꞌobic ti jcholcꞌopetique, jech o xal ti Simone laj yal ti ta xacꞌ taqꞌuine. Jech lic yal: ");
INSERT INTO tzotzc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","―Acꞌbun quichꞌ ec ti vi sꞌelan tsots xuꞌ avuꞌunique, yoꞌ jech ti vuꞌune cꞌalal ta jcajan jcꞌob ta sba ti cristianoetique, ta xichꞌic ti Chꞌul Espíritu cuꞌun eque ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jech laj yal ti Pedroe: ―Mu baluc xcaꞌi ti ataqꞌuine. Batan ta chꞌayel schiꞌuc. ¿Mi yuꞌun xavacꞌtouc ti stacꞌ manel ta taqꞌuin ti cꞌusi ta xacꞌ ti Diose? ");
INSERT INTO tzotzc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ti voꞌote maꞌuc aventa ta xaticꞌ aba ta yabtel ti Diose, yuꞌun muꞌyuc tucꞌ avoꞌnton ta stojol ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ictao ti jech chopol ta xanope. Cꞌanbo vocol ti Diose, jqꞌueltic quic mi ta to van xata perdón yuꞌun ti Dios ti cꞌusi laj anop ta avoꞌntone. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yuꞌun quiloj ti noj ta yitꞌixal ti avoꞌntone, ti toj chuculot yuꞌun ti mulile ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ti Simone jech laj stacꞌ: ―Cꞌoponbeicun Dios ta jtojol yoꞌ jech mu xcꞌot ta pasel ta jtojol ti vaꞌi sꞌelan laj avalbeicune ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Cꞌalal laj yoꞌntonic ta yalbe yaꞌi ti cristianoetic ti cꞌu sꞌelan icoltaatic yuꞌun ti Diose schiꞌuc ti laj yalic ti lequil achꞌ cꞌope, tsꞌacal to un, isutic batel ta Jerusalén ti Pedroe, ti Juane. Tey echꞌ yalic ti lequil achꞌ cꞌop ta stojol ti cristianoetic ti oyic ta jujun jteclum ti ta Samaria banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tsꞌacal to un, tal jun yajꞌángel ti Cajvaltique ti jech laj yalbe ti Felipee: ―Lican, batan ta be ti oy ta xocon smaleb cꞌacꞌale ti ta xyal talel ta Jerusalene, ti ta xcꞌot ta jteclum Gazae ―xi. Ti be taje, jaꞌ ti ta xꞌechꞌ ta xocol banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tey ibat ti Felipee. Cꞌalal jech ta xanav batele, laj snup sbaic ta be schiꞌuc jun vinic ti liquem talel ta Etiopía banomile. Ti vinic taje jaꞌ jun capon ti tsots yabtel yichꞌoje. Yuꞌun sventainojbe staqꞌuin ti meꞌ ajvalil Candace ti ta Etiopíae. Ti vinique iꞌay ta Jerusalén. Ay sta ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ti vinic taje ta xa sut batel ta slumal. Tey chotol batel ta carreta. Ta sqꞌuel batel ti scꞌop Dios ti stsꞌibaoj ti jꞌalcꞌop Isaíase. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ti chꞌul Espíritue jech laj yalbe ti Felipee: ―Nopajan batel ta stsꞌel ti carreta leꞌe ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Cꞌalal jech inopaj batel ti Felipee, tey laj yaꞌi ti ta sqꞌuel ti libro ti tsꞌibabil yuꞌun ti Isaíase. Jech lic sjacꞌbe ti vinique: ―¿Mi xavaꞌibe smelol ti cꞌusi ta xaqꞌuele? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ti vinique jech laj stacꞌ: ―¿Cꞌusi chcut ta xcaꞌibe ti smelol ti cꞌalal muꞌyuc buchꞌu ta xalbune? ―xi. Jech ti vinique tey laj yalbe ti Felipee ti acꞌo muyuc xchiꞌin ta chotleje. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ti bu ta sqꞌuel batel scꞌop Dios ti vinique, jaꞌ jech ta xal: Jech chac cꞌu chaꞌal chij ti icꞌbil batel ta smilobile, jech chac cꞌu chaꞌal junuc chij ti muꞌyuc cꞌusi snaꞌ ta xal cꞌalal ta xichꞌ locꞌbel ti stsotsile, jaꞌ jech sꞌelan ti vinique, muꞌyuc bu icꞌopoj jbeluc. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ti stuque iꞌacꞌat ta qꞌuexlal. Muꞌyuc laj xchapanbeic lec scꞌoplal. ¿Buchꞌu xuꞌ ta xal ti ta xbol ti yalab snichꞌnabe ti cꞌalal imilate? xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ti vinic taje jech laj sjacꞌbe ti Felipee: ―Avocoluc, albun caꞌi, ¿buchꞌu scꞌoplal ti vaꞌi sꞌelan ta xal ti jꞌalcꞌope? ¿Mi jaꞌ scꞌoplal stuc, mi scꞌoplal yan? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jech ti Felipee tey lic yalbe smelol ti jaꞌ scꞌoplal ti Jesús ti bu ta sqꞌuel ti vinique. Tey xcholet laj yalbe batel scꞌoplal ti Jesuse ti butic tsꞌibabil ta scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Cꞌalal tey iꞌechꞌic ti bu oy voꞌe, jech laj yal ti vinique: ―Oy voꞌ liꞌe, ¿mi xuꞌ ta xquichꞌ voꞌ xanaꞌ? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jech laj stacꞌ ti Felipee: ―Mi achꞌunoj ta sjunul avoꞌnton ti Cajvaltique, xuꞌ umbi ―xi. Ti vinique jech itacꞌav: ―Jchꞌunoj ti jaꞌ Snichꞌon Dios ti Jesucristoe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jech o xal ti vinique lic yal mantal ti acꞌo pajuc ta xanobal ti scarretae. Tey jmoj iyalic batel ta voꞌ. Jech ti Felipee laj yacꞌbe yichꞌ voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cꞌalal isutic muyel talel ta voꞌe, ti Chꞌul Espíritu yuꞌun ti Cajvaltique tey laj yicꞌ batel ti Felipee. Ti vinique muꞌyuc xa bu laj yil ti Felipee. Pero xmuyubaj xa yoꞌnton ti cꞌalal ta xanav batele. ");
INSERT INTO tzotzc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ti Felipee jaꞌ to laj yil ti tey xa oy ta Azoto jteclume. Tey ta xalolan batel ti lequil achꞌ cꞌope. Tey icꞌot cꞌalal to jteclum Cesarea. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yan ti Sauloe mu xicta sba ta sibtasel ta smilel ti jchꞌunolajeletic yuꞌun ti Cajvaltique. Jech o xal bat scꞌopon ti banquilal palee. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Bat scꞌanbe vunetic yoꞌ ta xacꞌbe yil ti paleetic ti oyic ta jujun chꞌul na ti ta jteclum Damascoe. Jech laj spas ti Sauloe yoꞌ jech xuꞌ ta stsacan talel ta chuquel cꞌalal to Jerusalén ti cristianoetic ti buchꞌutic xchꞌunojic ti lequil achꞌ cꞌope, viniquetic, antsetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Cꞌalal jech ta xanav batel ta bee, ti nopol xa scꞌan ta xcꞌot ta jteclum Damasco ti Sauloe, ta jech to yepal joyobtabil icꞌot ta xojobal luz ti ilic talel ta vinajele. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jech ti Sauloe iyal ta lum. Laj yaꞌi ti oy Buchꞌu ta xcꞌopoj ti jech ta xale: ―Saulo, Saulo, ¿cꞌu chaꞌal ta xacrontainun? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jech laj sjacꞌ ti Sauloe: ―¿Buchꞌuot? ―xi. Ti Buchꞌu ta xcꞌopoje jech laj stacꞌ: ―Vuꞌun Jesusun, ti Buchꞌu ta xacrontaine. Ta xayayijes aba atuc jech chac cꞌu chaꞌal ti vacax ti ta syayijes sba stuc ti cꞌalal ta slic ta teqꞌuel ti yabtejebe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Xnicnun xa ta xiꞌel lic sjacꞌ ti Sauloe: ―¿Cꞌusi ta xacꞌan ta jpas, Cajval? ―xut. Jech laj yal ti Cajvaltique: ―Lican, ochan batel ti ta jteclume. Tey ta xaꞌalbat ti cꞌusi xuꞌ ta xapase ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ti viniquetic ti xchiꞌinojic ti Sauloe ixiꞌic ta jmec. Jaꞌ ti laj yaꞌiic ti oy Buchꞌu ta xcꞌopoje, pero muꞌyuc buchꞌu laj yilic. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ti Sauloe lic vaꞌiuc ti tey puchꞌul ta lume. Cꞌalal ivaꞌie, mu xa xil ti osile. Jech o xal un, nitbil batel scꞌob yuꞌun ti schiꞌiltaque cꞌalal to jteclum Damasco. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Cꞌalal tey oye, oxib cꞌacꞌal macal ti sate. Muꞌyuc bu iveꞌ. Muꞌyuc cꞌusi laj yuchꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ti ta jteclum Damascoe tey nacal jun jchꞌunolajel ti Ananías sbie. Ti Cajvaltique laj yacꞌ sba iluc ta stojol. Jech laj yal: ―Ananías ―xi. Jech laj stacꞌ ti Ananíase: ―Liꞌ oyun, Cajval ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ti Cajvaltique jech laj yalbe ti Ananíase: ―Lican, batan tey ta calle ti jaꞌ Tuqꞌuil calle sbie. Tey ta xajacꞌ ta sna ti Judase mi tey oy jun vinic ti liquem talel ta jteclum Tarso ti jaꞌ Saulo ti sbie. Yuꞌun ti Sauloe yacal ta scꞌopon ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yuꞌun ti Sauloe iꞌacꞌbat xa yil ti ta xcꞌot jun vinic Ananías ti sbie, ti ta scajan scꞌob ta sbae yoꞌ jech ta xjam ti sate ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Cꞌalal jech laj yaꞌi ti Ananíase, jech laj yal: ―Cajval, ep ti buchꞌu yalojbun scꞌoplal ti vinic taje, ti toj chopol ti cꞌusi ta spase, ti ta xilbajin ti cristianoetic ti oy ta Jerusalene ti buchꞌutic ta xa xchꞌunote. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aviloj, Cajval, ti ital liꞌ ta jteclum Damascoe, ti yichꞌojbe talel ye ti banquilal palee, yoꞌ jech tal xchucan batel scotol ti buchꞌutic ta scꞌanic coltael ta atojole ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ti Cajvaltique jech laj yal: ―Batan ta stojol ti vinic taje. Yuꞌun tꞌujbil xa cuꞌun yoꞌ ta xalbun ti jcꞌoplal ta stojol ti jyanlum cristianoetique schiꞌuc ti ajvalil yuꞌunique, schiꞌuc ti jꞌisraeletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ta xcacꞌbe yil ti vinic taje ti ep ta xichꞌ svocol ta jventae ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jech o xal ti Ananíase ibat ta na ti bu tiqꞌuil ti Sauloe. Iꞌoch batel ta yut na. Icꞌot scajan scꞌob ta sba. Jech laj yalbe: ―Quermano Saulo, ti Cajvaltic Jesuse ti Buchꞌu laj yacꞌ sba iluc ta be ti cꞌalal latal liꞌe, laj yalbun talel ti liꞌ ta xital ta atojole, yoꞌ jech ta sjam ti asate, yoꞌ jech ta sventainbot avoꞌnton ti Chꞌul Espíritue ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Cꞌalal jech laj yal ti Ananíase, ta jech to yepal laj pochuc loqꞌuel ta sat jech chac cꞌu chaꞌal junuc smicꞌal choy. Jaꞌ o tey ijam ti sate. Jech o xal ti Sauloe lic vaꞌluc. Tey laj yichꞌ voꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tsꞌacal to ti Sauloe lic veꞌuc. Itsatsub ti sbecꞌtale. Tey icom jun chib cꞌacꞌal ta stojol ti jchꞌunolajeletic ti nacalic ta jteclum Damascoe. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsꞌacal to ti Sauloe tey lic yal ta jujun chꞌul na ti jaꞌ Snichꞌon Dios ti Jesuse. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Scotol ti buchꞌutic ti ta xaꞌibe scꞌop ti Sauloe toj elom noꞌox ta xaꞌi ta jmec. Jech ta xalbe sbaic: ―Ti vinic leꞌe, ¿mi mu jaꞌuc ti ta xilbajin ti buchꞌutic ta scꞌanic coltael ta stojol ti Jesús ti tey ta Jerusalene? Jaꞌ jech xtoc, ¿mi mu jaꞌuc ti tal liꞌ xtoc yoꞌ jech ta xchucan batel, yoꞌ jech ta xba yacꞌ ta stojol ti banquilal pale ti buchꞌutic ta scꞌanic coltael ta stojol ti Jesuse? ―xut sbaic. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero ti Sauloe muꞌyuc xiꞌel ta xaꞌi ta xacꞌ ta naꞌel ti jaꞌ Jcoltavanej ti Jesuse. Ti jꞌisraeletic ti nacajtic ta jteclum Damascoe mu stacꞌ aꞌyeluc ta xaꞌi cꞌusi xuꞌ ta staqꞌuic. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Echꞌ xa ox jaylajuneb cꞌacꞌal, ti jꞌisraelal cristianoetique lic scomonopic ti ta smilic ti Sauloe. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Cꞌalal jech ta snopic ti jꞌisraelal cristianoetique, laj yaꞌi ti Sauloe. Cꞌacꞌal acꞌobal ta smalaic tey ta jujun stiꞌ smacal ti jteclume yoꞌ ta smilic ti Sauloe. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero ti jchꞌunolajeletique ta acꞌobaltic laj sjatbiltasic ti Sauloe. Laj stiqꞌuic ochel ta mucꞌ ta moch. Tey laj xchechic yalel ta chꞌojon ta pat moc ti jaꞌ smacoj ti jteclume. Jaꞌ jech icol batel. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cꞌalal icꞌot ta Jerusalén ti Sauloe, ta stsob sba yaꞌi schiꞌuc ti jchꞌunolajeletique. Pero ti jchꞌunolajeletique ep ta xiꞌic yuꞌun. Yuꞌun mu snaꞌic mi jaꞌ xa jchꞌunolajel ec. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Acꞌo mi jech ta xiꞌic, pero ti Bernabee laj yicꞌ batel ta stojol ti jcholcꞌopetique. Cꞌot yalbe yaꞌiic ti cꞌu sꞌelan laj yil ti Cajvaltic ta be ti Sauloe schiꞌuc ti cꞌu sꞌelan icꞌoponat yuꞌun ti Cajvaltique, ti ta sjunul yoꞌnton ti Sauloe laj yalbe scꞌoplal Jesús ti ta Damascoe. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jech o xal ti Sauloe tey icom ta Jerusalén. Jmoj lic xanavicuc schiꞌuc ti jcholcꞌopetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ti Sauloe muꞌyuc xiꞌel ta xaꞌi ta xalbe scꞌoplal ti Cajvaltique. Ta xloꞌilajic ta stacꞌolanbe sbaic schiꞌuc ti jꞌisraeletic ti buchꞌutic ta xcꞌopojic ta griego cꞌope. Pero ti stuquique ta smilic yaꞌi ti Sauloe. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cꞌalal jech laj yaꞌiic ti jchꞌunolajeletique, laj yiqꞌuic batel ti Sauloe cꞌalal to Cesarea. Cꞌalal tey icꞌotique, tey laj staquic batel cꞌalal to jteclum Tarso. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tey paj yilbajinelic ti jchꞌunolajeletic ti oyic ta Judeae, ti ta Galileae, ti ta Samariae. Tey itsatsub ti yontonique. Scotolic ti jchꞌunolajeletique ta xiꞌtaic ti Cajvaltique. Ti jech coltabilic yuꞌun ti Chꞌul Espíritue, yacal ta xꞌepajic batel. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Cꞌalal ta svuꞌlanan jchꞌunolajeletic ti Pedroe, bat sqꞌuel ti jchꞌunolajeletic ti nacajtic ta jteclum Lidae. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tey laj sta jun vinic ti jaꞌ Eneas sbie. Oy xa svaxaquibal jabil xpuchꞌlej ta stem. Yuꞌun pasem ta mochꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ti Pedroe jech laj yalbe: ―Eneas, Jesucristo ta scoltaot. Lican, vaꞌlan. Toyo ti avayebe ―xut. Ti Enease ta ora noꞌox ilic batel. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Scotol ti cristianoetic ti nacajtic ta jteclum Lidae, ti ta jteclum Sarone, laj yilic ti jech icol ti vinique. Jech o xal laj yictaic comel ti cꞌu sꞌelan liquem yuꞌunic ta voꞌnee. Laj xchꞌunic ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ti jech yorail taje, tey nacal ta jteclum Jope jun jchꞌunolajel ants ti Tabita sbie. Yan ti ta griego cꞌope, jaꞌ Dorcas, xi. Ti ants taje stalel jech cuxul ta spas ti leque, yuꞌun ta scolta ti buchꞌu abol sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pero ti Dorcase itsacat ta chamel, icham. Cꞌalal jech laj yichꞌ poquele, tey bat stutsꞌanic ta schaꞌcojal na. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ti jteclum Jopee nopol xil sbaic schiꞌuc ti jteclum Lidae ti bu oy ti Pedroe. Ti jchꞌunolajeletic teye yaꞌbinojic ti tey oy ti Pedroe. Jech o xal ti jchꞌunolajeletique laj staquic batel chaꞌvoꞌ viniquetic ti jech cꞌot yalic ta stojol ti Pedroe: ―Batic ta ora ta Jopee ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ti Pedroe jmoj ibatic schiꞌuc ti chaꞌvoꞌ viniquetique. Cꞌalal icꞌot ta jteclum Jopee, ti jchꞌunolajeletique yicꞌojic batel ti Pedro ta schaꞌcojal na ti bu tutsꞌul ti animae. Cꞌalal tey xa oye, xꞌocꞌlajetic xa talel ti meꞌlal antsetique, tal yacꞌbeic yil ti Pedroe ti cꞌuꞌil ti jaꞌ smeltsanoj ti anima Dorcas cꞌalal cuxul to oxe. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ti Pedroe laj stacꞌ loqꞌuel ti cꞌu yepal tey oyique. Tey lic squejan sba ta scꞌoponel ti Diose. Sqꞌueloj batel ti anima antse. Jech laj yalbe: ―Tabita, lican talel ―xut. Jech ti animae lic svicꞌ ti sate. Tey laj yil ti Pedroe. Tey lic chotluc. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jech ti Pedroe laj snitbe liquel scꞌob. Jaꞌ jech xtoc tey laj yicꞌ talel ti jchꞌunolajeletique schiꞌuc ti meꞌlal antsetique. Tey laj yacꞌ iluc ti cuxul xa ti Dorcase. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ti jech taje puc scꞌoplal ta jteclum Jope. Jech o xal ep ti buchꞌutic laj xchꞌunic ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ti Pedroe icom jayibuc cꞌacꞌal ti ta jteclume ta sna jun vinic, Simón sbi, ti jaꞌ jcꞌaꞌesej-nucule. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ti tey ta jteclum Cesareae oy jun vinic, Cornelio sbi. Jaꞌ capitán yuꞌun ti jvocꞌ soldado ti Italiano sbie. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jaꞌ jun vinic ti yichꞌojic ta mucꞌ ti Diose schiꞌuc ti cꞌu yepal tey ta snae. Ta xiꞌtaic ti Diose. Jaꞌ jech xtoc ti Cornelioe ta xcꞌuxubin ti jꞌisraeletic ti buchꞌu abol sbaique. Mu xicta sba ta scꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Oy jun cꞌacꞌal, nopol xa batel oxib ora mal cꞌacꞌal, laj yil jun yajꞌángel ti Diose ti iꞌoch batel ti bu oye. Jech laj yal: ―Cornelio ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ti Cornelioe tsꞌijil icom ta xiꞌel ta sqꞌuel batel ti ángele. Jech laj sjacꞌbe: ―¿Cꞌusi, Cajval? ―xut. Ti ángele jech laj stacꞌ: ―Ti ta xata ta cꞌoponel ti Diose, ti ta xacolta ti buchꞌu abol sbaique, ichꞌbil xa ta venta yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jech o xal un, taco batel avinictac ta jteclum Jope yoꞌ jech xba yiqꞌuic talel ti Simone, ti jaꞌ Pedro ti yan sbi xtoque. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ti stuque xchꞌamunojbe sna ti Simone, ti jaꞌ jcꞌaꞌesej-nucule, ti nopol ta tiꞌ nab ti snae. Ti Pedro taje jaꞌ ta xalbot avaꞌi ti cꞌusi xuꞌ ta xapase ―xi ti ángele. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cꞌalal jech ibat ti ángel ti icꞌopoje, ti Cornelioe lic sta ta iqꞌuel chaꞌvoꞌ svinic schiꞌuc jun yajsoldado ti lec xil sbaic schiꞌuque, ti jaꞌ xchꞌunoj ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Lic yalbe scotol ti cꞌu sꞌelan laj yile. Tsꞌacal to un, laj stac batel cꞌalal to jteclum Jope. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ta yocꞌlomal un, cꞌalal nopol xa scꞌan xcꞌot ti ta jteclum Jope ti svinictaque, jech ti Pedroe jaꞌ o imuy batel ta schaꞌcojal na yoꞌ jech ta sta ta cꞌoponel ti Diose. Jaꞌ ti nopol xa scꞌan oꞌlol cꞌacꞌale. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ti Pedroe ta xviꞌnaj. Ta xveꞌ yaꞌi. Cꞌalal yacal to ta xichꞌ meltsanel ti veꞌlile, oy cꞌusi laj yil. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Laj yil ti ijam ti vinajele, ti jun to mucꞌ ta manta ti xlichꞌet yalel talel ta banomile. Chucajtic schanjotal ti sba sniꞌtaque. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ti tey ta mantae tey ticꞌajtic ep ta tos chonetic ti chanib yacꞌane schiꞌuc ti yan chonetique, schiꞌuc ti mutetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jaꞌ o tey laj yaꞌi ti oy Buchꞌu ta xcꞌopoj ti jech ta xale: ―Lican, vaꞌlan, Pedro. Milo, tiꞌan ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ti Pedroe jech laj stacꞌ: ―Mu jcꞌan, Cajval. Yuꞌun muꞌyuc bu jtiꞌ o ti cꞌusi chopole, ti cꞌusi mu stacꞌ tiꞌele ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ti Buchꞌu ta xcꞌopoje jech lic yal xtoc: ―Ti cꞌusi lecubtasbil yuꞌun ti Diose, mu xuꞌ xaval ti chopole ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxib velta ti jech iꞌalbat ti Pedroe. Tsꞌacal to un, ti mantae imuy batel ta vinajel. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Cꞌalal jech chꞌayal yoꞌnton ti Pedro ta snopel ti cꞌusi xal o ti jech laj yile, jaꞌ o icꞌotic ta tiꞌ na svinictac ti Cornelioe, ti ta sjacꞌolanic talel sna ti Simone. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cꞌalal icꞌotique, jamal yeic cꞌot sjaqꞌuic: ―¿Mi liꞌ oy ta xchꞌamun ana jun vinic ti jaꞌ Simón sbie, ti yan sbie jaꞌ Pedro? ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Cꞌalal jech chꞌayal to yoꞌnton ti Pedro ta snopilanel ti cꞌusi laj yile, jech iꞌalbat yuꞌun ti Chꞌul Espíritue: ―Qꞌuel avil, tal saꞌot oxib viniquetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Vaꞌlan, yalan batel ta olon. Chiꞌino batel ti jꞌicꞌvanejetique. Mu xanaꞌetuc. Yuꞌun vuꞌun laj jtac talel ―xꞌutat. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ti Pedroe iyal batel ti bu oy ti viniquetic ti jaꞌ tacbilic talel yuꞌun ti Cornelioe. Jech laj yalbe: ―Vuꞌunun ti buchꞌu ta xasaꞌique. ¿Cꞌu chaꞌal tal asaꞌicun? ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ti viniquetique jech laj staqꞌuic: ―Tacbiluncutic talel yuꞌun ti capitán Cornelioe. Jun lequil vinic ti xiꞌtaoj ti Diose, ti jaꞌ cꞌuxubinbil yuꞌun ti jꞌisraeletique. Yuꞌun iꞌalbat yuꞌun yajꞌángel ti Diose ti acꞌo avichꞌ iqꞌuel batele yoꞌ jech ta xabat ta sna, yoꞌ jech ta xaꞌi ti cꞌusi ta xavalbee ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jech o xal ti Pedroe laj yacꞌ ochicuc batel ta na ti viniquetique. Tey icomic jun acꞌobal. Ta yocꞌlomal un, ti Pedroe ibatic schiꞌuc ti jꞌicꞌvanejetique, schiꞌuc jun chib jchꞌunolajeletic ti nacajtic ta jteclum Jopee. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ta yan cꞌacꞌal un, icꞌotic ta Cesarea ti bu ta xmalavan ti Cornelioe. Tey xa tsobolic schiꞌuc yutsꞌ yalaltac, schiꞌuc ti buchꞌu lec xil sbaic schiꞌuque, ti jaꞌ laj staan talel ta iqꞌuele. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cꞌalal icꞌot ta na ti Pedroe, jech ti Cornelioe ilocꞌ batel. Ba snup talel ta be. Laj squejan sba ta stojol yoꞌ jech ta xichꞌ ta mucꞌ. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ti Pedroe jech laj yal: ―Mu xaquejan aba ta jtojol. Vaꞌlan. Vinicun noꞌox jech chac cꞌu chaꞌal ti voꞌote ―xut. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Cꞌalal jech jmoj ta xloꞌilajic batele, ochic batel ta yut na. Tey laj sta noj ta cristianoetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ti Pedroe jech lic yal: ―Ti voꞌoxuque xanaꞌic lec ti cꞌu sꞌelan liquem yuꞌunic ti jꞌisraeletique, ti mu xuꞌ ta jtsob jbacutic schiꞌuc ti jyanlum cristianoetique. Mi jaꞌuc xuꞌ ta xiꞌochcutic ta yut snaic. Pero laj xchanubtasun ti Diose ti mu junuc cristiano ti ta jbis ta chopole. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jech o xal muꞌyuc cꞌusi laj cal ti cꞌalal laj ataicun ta iqꞌuele. Ta ora noꞌox liꞌ lital ta atojolique. Jech o xal un, albun caꞌi, ¿cꞌu chaꞌal ti laj ataicun ta iqꞌuele? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jech laj stacꞌ ti Cornelioe: ―Oy xa chanib cꞌacꞌal, jech ora jech chac cꞌu chaꞌal liꞌe, yuꞌun jaꞌ o liꞌ oyun ta jna. Quictaoj cot yoꞌ jech ta jta ta cꞌoponel ti Diose ta sventa mal cꞌacꞌal. Jaꞌ o laj quil jun vinic ti xnobobet xojobal ti scꞌuꞌ slapoje. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jech laj yalbun: “Cornelio, laj xa yaꞌibot acꞌop ti Diose. Yiloj ti jech ta xacolta ti buchꞌu abol sbaique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jech o xal un, Cornelio, taco batel avinictac cꞌalal to jteclum Jope yoꞌ jech ta xba yiqꞌuic talel ti Simone, ti jaꞌ Pedro ti yan sbie. Tey xchꞌamunojbe sna jun vinic jcꞌaꞌesej-nucul ti jaꞌ Simón sbie, ti nopol ta tiꞌ nab nacale. Cꞌalal ta xtale, ta xachiꞌin abaic ta loꞌil”, xiyutun. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jech o xal un, ta ora noꞌox laj jtac batel jvinictac ta saꞌelot. Lec ti jech latale. Avi tana un, tsobolotic liꞌ ta stojol ti Diose. Ta jcꞌan ta xcaꞌicutic scotol ti cꞌu sꞌelan laꞌacꞌbat anaꞌ yuꞌun ti Cajvaltique ―xi ti Cornelioe. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jech lic yal ti Pedroe: ―Avi tana ta jnaꞌ lec, ti Diose mu jeltosuc yoꞌnton ta stojol ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Buꞌyuc noꞌox slumal ti cristianoetique ichꞌbilic ta mucꞌ yuꞌun ti Diose cꞌalal ta xiꞌtaique, ti lec ta spasique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ti vuꞌuncutic jꞌisraeluncutique laj yacꞌbun jnaꞌcutic ti Diose ti ta jtacutic jun coꞌntoncutic ta sventa ti Jesucristoe, ti jaꞌ Jcoltavanej cuꞌuntic jcotoltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Cꞌalal laj yoꞌnton ti Juan ta yalel ti lequil achꞌ cꞌope, ta yacꞌbel yichꞌ voꞌ ti cristianoetique, anaꞌojic lec ti cꞌusi icꞌot ta pasel ta sjunul Judea banomile, ti ilic talel ti ta Galilea banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Anaꞌojic lec, ti Diose laj yacꞌbe yichꞌ ti Chꞌul Espíritu ti Jesús ti liquem talel ta Nazarete, yoꞌ jech tsots xuꞌ yuꞌun ta spas ti cꞌusi leque, ti ta scoltaan ti buchꞌutic ta xꞌilbajinatic yuꞌun ti pucuje. Jaꞌ jech sꞌelan laj spas, jaꞌ ti chiꞌinbil coltabil yuꞌun ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yuꞌun rextigouncutic ti jech laj spas ti Jesús ti ta sjoylej Judea banomile schiꞌuc xtoc ti ta jteclum Jerusalene. Tsꞌacal to un, jipil ta cruz icham yuꞌunic ti cristianoetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero ti Diose laj xchaꞌcuxes ta yoxibal cꞌacꞌal. Jech laj scꞌan ti Diose ti laj yacꞌ quilcutique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Muꞌyuc laj yacꞌ sba iluc ta stojol scotol ti cristianoetique. Jaꞌ noꞌox laj yacꞌ sba iluc ta jtojolcutic. Jaꞌ ti jech onoꞌox nopbil jcꞌoplalcutic yuꞌun ti Diose ti jech ta xicomcutic ta yajrextigoe. Jmoj liveꞌcutic, laj cuchꞌcutic voꞌ schiꞌuc ti Jesuse ti cꞌalal chaꞌcuxiem xae. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Laj stacuncutic ta yalel ti lequil achꞌ cꞌop ta stojol ti cristianoetique. Jaꞌ jech xtoc ti iꞌacꞌbat xa yabtel yuꞌun Dios ti jaꞌ Jchapanvanej yuꞌun ti buchꞌu cuxule, ti buchꞌu chamemique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jaꞌ jech xtoc scotol ti jꞌalcꞌopetique laj yalic talel scꞌoplal ti Jesuse. Ti buchꞌu ta xichꞌic ta muqꞌue, ta xichꞌic perdón yuꞌun smulic ta sventa ti Jesuse ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Cꞌalal jech syaquil ta xcꞌopoj ti Pedroe, jaꞌ o ital ti Chꞌul Espíritu ta stojol ti cꞌu yepal ta xaꞌibeic ti scꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ti jꞌisraelal jchꞌunolajeletic ti jaꞌ xchiꞌinojic talel ti Pedroe, toj elom laj yaꞌiic ti jech laj yichꞌic Chꞌul Espíritu ti jyanlumetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yuꞌun laj yaꞌiic ti ta xcꞌopojic ta yan cꞌopetique schiꞌuc ti ta xlequil-cꞌopojic ta stojol ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jech o xal ti Pedroe jech laj yal: ―Laj xa yichꞌic ti Chꞌul Espíritue jech chac cꞌu chaꞌal ti voꞌotique. ¿Mi oy buchꞌu ta xmacbun yoꞌnton ta yichꞌel voꞌ ti jyanlumetic xanaꞌic liꞌe? ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jech o xal ti Pedroe laj yal ti acꞌo yichꞌic voꞌ ta sventa ti Jesucristoe. Tsꞌacal to un, ti jyanlumetique laj scꞌanbe vocol ti Pedroe ti acꞌo comuc jun chibuc cꞌacꞌal teye. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ti yan jcholcꞌopetique schiꞌuc ti jchꞌunolajeletic ti oyic ta Judea banomile laj yaꞌibeic scꞌoplal ti jyanlumetic ti laj xa xchꞌunic ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cꞌalal jech isut batel ta Jerusalén ti Pedroe, tey isaꞌbat smul yuꞌun ti jchꞌunolajeletic ti buchꞌutic ta xalic ti tsots scꞌoplal ta xichꞌ circuncisión ti jyanlumetique. Jech lic sjaqꞌuic: ");
INSERT INTO tzotzc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","―¿Cꞌu chaꞌal ay atsob abaic, jmoj laveꞌ schiꞌuc ti jyanlumetique? ―xutic. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jech ti Pedroe xcholet lic xchap scotol ti cꞌusi laj yil ti icꞌot ta pasele. Jech lic yal: ");
INSERT INTO tzotzc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Ti jech tey oyun ta jteclum Jopee, cꞌalal ta jta ta cꞌoponel ti Diose, laj quil ti coꞌol sꞌelan jun mucꞌ ta mantae, ti xlichꞌet yal talel ta vinajele. Chucbil schanjotal ti sbae. Tey ivul ti bu oyune. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cꞌalal laj jqꞌuel lec ti cꞌusi tiqꞌuil ta yute, tey laj quil ti tey oy chonetic ti chanib yacane schiꞌuc yan chonetic, schiꞌuc mutetic. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Laj caꞌi ti oy Buchꞌu ta xcꞌopoj ti jech ta xalbune: “Pedro, lican. Milo, tiꞌan”, xiyut. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero jech laj cal: “Mu jcꞌan, Cajval. Mu bacꞌniuc jnaꞌ jtiꞌ ti cꞌusi chopole”, xcut. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jech laj yalbun ti Buchꞌu ta xcꞌopoj talel ta vinajele: “Ti cꞌusi lecubtasbil yuꞌun ti Diose, mu xuꞌ xaval ti chopole”, xiyut. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxib velta jech laj yalbun. Tsꞌacal to un, scotol imuy batel ta vinajel. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Cꞌalal jech laj quile, jaꞌ o tey icꞌotic oxib viniquetic tey ta na ti bu oyune. Ta Cesarea to tacbilic talel yoꞌ tal saꞌicun. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ti Chꞌul Espíritue laj yalbun ti junuc coꞌnton acꞌo batcun schiꞌuc ti jꞌicꞌvanejetique. Jaꞌ jech xtoc laj xchiꞌinun batel ti vaquib jchꞌunolajeletic ti liꞌ oyique. Jcotolcutic liꞌochcutic batel ta sna ti jun vinique. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tey laj yalbuncutic ti laj yil ti tey vaꞌal icꞌot jun ángel ta sna ti jech iꞌalbate: “Taco batel avinictac ta jteclum Jope yoꞌ jech ta xiqꞌuic talel ti Simone, ti jaꞌ Pedro ti yan sbie. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jaꞌ ta xayalbot avaꞌi ti stuque cꞌu sꞌelan ta xata ti coltael schiꞌuc ti cꞌu yepal oy ta anae”, xꞌutat la ti vinique, xiyut. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Cꞌalal lic calbe yaꞌiic ti coltaele, jaꞌ o ital ti Chꞌul Espíritu ta stojolic coꞌol sꞌelan jech chac cꞌu chaꞌal ital ta jtojoltic ta baꞌyele. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Cꞌalal jech laj quile, jaꞌ o tey ivul ta coꞌnton jech chac cꞌu chaꞌal laj yal ti Cajvaltic Jesuse: “Laj yacꞌ ichꞌ voꞌ ti Juane. Pero ti voꞌoxuque ta xavichꞌic ti Chꞌul Espíritue”, ti xie. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","’Ti mi jech laj spas ti Dios ti laj yacꞌbe yichꞌ Chꞌul Espíritu ti jyanlumetique jech chac cꞌu chaꞌal laj quichꞌtic ti voꞌotic cꞌalal laj jchꞌuntic ti Cajvaltic Jesucristoe, ¿buchꞌuun yaꞌyel ta jmacbe yabtel ti Diose? ―xi ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ti jchꞌunolajeletic ta Jerusalene, cꞌalal laj yaꞌiic ti vaꞌi sꞌelan taje, tsꞌijil icomic. Jech lic lequil cꞌopojicuc ta stojol ti Diose: ―Ati chcaltic un chaꞌe, ti jyanlumetique xuꞌ ta xictaic ti chopol yoꞌntonique yoꞌ jech ta staic ti scuxlejalic sbatel osil yuꞌun ti Diose ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ti jꞌisraelal jchꞌunolajeletic ti laj tanijicuc batel ti cꞌalal laj yichꞌ milel ti Estebane, oy jlom ibatic ta Fenicia banomil, ta Chipre banomil, ta Antioquía jteclum. Tey lic yalic ti lequil achꞌ cꞌop ta stojol ti schiꞌil sbaic ta jꞌisraele. Muꞌyuc laj yalbeic ti jyanlumetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero oy jlom jchꞌunolajeletic ti liquemic talel ta Chipre ta Cirene ti icꞌotic ta jteclum Antioquíae. Ti jchꞌunolajeletic taje tey lic yalbeic yaꞌi xtoc ti lequil achꞌ cꞌop yuꞌun ti Cajvaltic Jesuse, ti jyanlumetique. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ti chꞌunolajeletic taje coltabilic yuꞌun smucꞌul stsatsal ti Cajvaltique. Jech o xal ep ti jyanlumetique laj yictaic comel ti cꞌu sꞌelan xchꞌunojic to oxe. Jaꞌ laj xchꞌunic ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cꞌalal jech laj yaꞌiic ti jchꞌunolajeletic ti oyic ta Jerusalene, jech o xal laj staquic batel ti Bernabee cꞌalal to Antioquía. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cꞌalal icꞌot ti Bernabee, laj yil ti ta melel laj xa svaꞌan sba ti Dios ta stojolic ti jyanlumetique. Jech o xal xmuyubaj xa. Tey laj sbijubtas scotol ti jchꞌunolajeletique ti staojuc o yav junuc yoꞌntonic ta stojol ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ti Bernabee jaꞌ jun lequil vinic. Ventainbil yoꞌnton yuꞌun ti Chꞌul Espíritue, ti xchꞌunoj ti ta xcoltavan ti Cajvaltique. Jech o xal un, ep laj xchꞌunic Cajvaltic ta sventa ti Bernabee. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsꞌacal to un, ti Bernabee ibat ta jteclum Tarso ta saꞌel ti Sauloe. Cꞌalal laj stae, laj yicꞌ batel cꞌalal to Antioquía. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tey icomic jun jabil schiꞌuc ti jchꞌunolajeletique. Laj xchanubtasic ep ti cristianoetique. Jaꞌ tey ilic talel ti laj sbiinic jaꞌ cristoetic ti jchꞌunolajeletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ti jech yorail taje, oy jun chib viniquetic ta Jerusalén ti ta xalic ti cꞌusi ta xꞌacꞌbat snaꞌic yuꞌun ti Diose. Tey ibatic ta Antioquía. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Oy jun yuꞌunic ta scotolic ti jaꞌ Agabo sbie. Tey lic svaꞌan sba ta stojol ti jchꞌunolajeletique. Ta sventa ti iꞌacꞌbat snaꞌ yuꞌun ti Chꞌul Espíritue, laj yal ti ta xtal mucꞌ ta viꞌnal ta sjunul banomile. Jech onoꞌox icꞌot ta pasel cꞌalal tiqꞌuil ta ajvalil ti Claudioe. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jech ti jchꞌunolajeletic ti oyic ta jteclum Antioquíae iꞌayan ta yoꞌntonic ti ta scoltaic ti jchꞌunolajeletic ti oyic ta Judeae, jaꞌ ti cꞌu yepal xuꞌ yuꞌunic ta jujun tale. ");
INSERT INTO tzotzc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jaꞌ jech laj spasic. Ti cꞌusi laj stsobique, laj yacꞌbeic ti Bernabee, ti Sauloe, yoꞌ jech ta xacꞌbeic ti ancianoetic ti oyic ta Judeae. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ti jech yorail taje, jaꞌ o lic yilbajin jlom jchꞌunolajeletic ti ajvalil Herodese. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Laj yacꞌ ta milel ta espada ti Jacoboe, ti jaꞌ yitsꞌin ti Juane. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ti jech laj spas ti ajvalil Herodese, toj lec laj yaꞌiic ti jꞌisraeletique. Jech o xal laj stsac ta chuquel ti Pedroe. Ti jech taje, jaꞌ o yorail ti qꞌuin ti ta sveꞌic pan ti chꞌabal yichꞌoj ti spajubtasobile. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Cꞌalal jech tsacbil xa ox batel ti Pedroe, ti ajvalil Herodese laj sticꞌ ta chuquel ti bu lec chabibil ta chanchop soldadoetic ti oy chanib soldado ti jujuchope. Yuꞌun laj snop ta yoꞌnton ti ta svaꞌan ta sba ta sat ti cristianoetique ti cꞌalal mi iꞌechꞌ ti qꞌuin Colele. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jaꞌ yuꞌun ti Pedroe lec chabibil ti tey ta chuquinabe. Pero ti jchꞌunolajeletique yacꞌojbeic yipal ta stael ta cꞌoponel ti Dios ta sventa ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ta yacꞌobalil ti cꞌalal yocꞌlomal xa ti ta xichꞌ vaꞌanel ta sba ta sat ti cristianoetic yuꞌun ti Herodese, ti Pedroe lec chabibil ta chaꞌvoꞌ soldado ta xvay. Chucul lec ta chib cadena. Ti yan soldadoetique lec xchabiojic ti tiꞌ chuquinabe. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ta jech to yepal icꞌot jun yajꞌángel ti Cajvaltique. Jech sac jaman ta xojobal icom ti yut chuquinabe. Ti ángele laj svuyilanbe xocon ti Pedroe yoꞌ stij. Jech laj yal: ―Lican ta ora ―xi. Ta jech to yepal ijituj ti cadena ti oy ta scꞌob ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ti ángele jech laj yal: ―Chuco achꞌut. Lapo axonob ―xut. Cꞌalal jech laj spas ti Pedroe, jech laj yal ti ángele: ―Lapo ti acꞌuꞌ ti smacobil sique. Tijlan talel ta jpat ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ti Pedroe tijil batel ta spat ti ángele. Batsꞌi mu aꞌyibajuc ta xaꞌi mi ta melel jech ta spas ti ángele, mi moꞌoj. Yacꞌtouc ti jaꞌ noꞌox oy cꞌusi ta xꞌacꞌbat yile. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tey ijelavic batel ti bu oy ti sliqueb jchabivanejetique. Iꞌechꞌic batel ti bu oy ti schibal jchabivanejetique. Cꞌalal icꞌotic ta mucꞌ ta tiꞌ chuquinab taqꞌuin ti ta sventa callee, ta jech to yepal ijam stuc. Tey iloqꞌuic batel. Cꞌalal ixanavic batel jun callee, tey ictaat comel stuc ti Pedro yuꞌun ti ángele. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jaꞌ to tey laj yil ti Pedro ti melel onoꞌoxe. Jech laj yal ta yoꞌnton: ―Avi tana ta xquil ti ta melel laj stac talel yajꞌángel ti Cajvaltique, yoꞌ jech tal scoltaun ta yoc ta scꞌob ti ajvalil Herodese schiꞌuc ti cꞌusi snopoj ta spasbun ti jꞌisraeletique ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cꞌalal jech ta snopilan batel ti Pedroe, ibat ta sna María ti jaꞌ smeꞌ ti Juane, ti jaꞌ Marcos ti yan sbi xtoque. Yuꞌun ti teye ep stsoboj sbaic ti jchꞌunolajeletic ti ta staic ta cꞌoponel ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cꞌalal jech icꞌot scꞌoj ti tiꞌ nae, jaꞌ o tal jun tseb, Rode ti sbie. Tal sqꞌuel buchꞌu ta scꞌojilan ti tiꞌ nae. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Cꞌalal laj yaꞌibe scꞌopojel ti Pedroe, pero muꞌyuc bu laj sjam ti tiꞌ nae. Cajomal xmuyubaj xa ibat ta anil. Ba yalbe yaꞌi ti jchꞌunolajeletic ti tey xa vaꞌal ta tiꞌ na ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pero ti stuquique jech laj yalic: ―Xlic achuvaj ―xutic. ―Melel ti cꞌusi ta xcale ―xi ti tsebe. Manchuc mi jech laj yaꞌiic, pero ti jchꞌunolajeletique jech laj yalic: ―Maꞌuc. Jaꞌ schꞌulel ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero ti Pedroe tey xcꞌojcun o ta tiꞌ na. Cꞌalal bat sjamique, tey laj yilic. Tey ixiꞌic. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero ti Pedroe laj spas señail ta scꞌob ti acꞌo chꞌaniicuque. Tey lic yal ti cꞌu sꞌelan iloqꞌuesat ta chuqinab yuꞌun ti Cajvaltique. Jech laj yal: ―Albeic yaꞌi ti Jacoboe schiꞌuc ti yan quermanotique ―xi. Jech o xal ti Pedroe ibat ta yan parte. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cꞌalal sacub ti osile, mu stacꞌ aꞌyeluc ta xaꞌiic ti soldadoetic ti cꞌusi icꞌot ta pasel ti chꞌabal xa ti Pedroe. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ti Herodese laj yal mantal ti acꞌo yichꞌ saꞌel bu ta jmec ti Pedroe. Cꞌalal muꞌyuc laj yichꞌ taele, lic xchapan cuenta schiꞌuc ti soldadoetique. Tey laj yal mantal ti acꞌo yichꞌ milel ti soldadoetique. Tsꞌacal to un, ti Herodese ilocꞌ batel ta Judea. Bat nacluc ta jteclum Cesarea. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ti ajvalil Herodese isoc sjol schiꞌuc ti cristianoetic ti nacalic ta jteclum Tiroe schiꞌuc ti ta jteclum Sidone. Pero ti stuquique laj scomonop scꞌopic ti jaꞌ xlocꞌ venta ti mi ta xtalic ta stojol ti ajvalil Herodese. Yuꞌun tey ta xlic talel sveꞌelic ta banomil ti bu smacoj ti Herodese. Jech o xal un, ti stuquique lic smatantasic ti Blastoe ti jaꞌ yichꞌoj tsots yabtel yuꞌun ti ajvalil Herodese. Yuꞌun ta scꞌanic ti ta sventa ti Blastoe yoꞌ jech ta staic ti ta xcomic ta lec schiꞌuc ti ajvalil Herodese. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jech o xal ti Herodese oy jun cꞌacꞌal ti laj sta ta iqꞌuel ti cristianoetic taje. Ti jech cꞌacꞌal taje, ti ajvalil Herodese lic slap ti slequil cꞌuꞌe. Bat chotluc ta schotleb ti bu ta xchapanvane. Tey laj yalbe ti cꞌusi ta xale. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ti cristianoetique jech lic avanicuc: ―Ti buchꞌu ta xcꞌopoj liꞌe, maꞌuc jun vinic. Jaꞌ jun riox ―xiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ta ora noꞌox iꞌacꞌbat chamel ti ajvalil Herodese yuꞌun jun yajꞌángel ti Cajvaltique. Yuꞌun maꞌuc laj yacꞌ ta ichꞌel ta mucꞌ ti Diose. Jech o xal bolol ta xuvit icham. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero ti scꞌop Diose yantic ta xtanij batel. Ta xꞌepajic ti jchꞌunolajeletique. ");
INSERT INTO tzotzc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ti Bernabee, ti Sauloe, cꞌalal tsuts yuꞌunic ti cꞌusi ta scꞌan pasel ta Jerusalene, isutic batel. Laj yiqꞌuic batel ti Juane, ti jaꞌ Marcos ti yan sbie. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ti ta stojol ti jchꞌunolajeletic ti oyic ta jteclum Antioquíae, oy jꞌalcꞌopetic, oy jchanubtasvanejetic. Jaꞌic ti Bernabee, ti Sauloe, ti Simone, Negro ti yan sbi xtoque, ti Lucioe ti liquem talel ta Cirene banomile, ti Manaene ti ichꞌi talel ta stojol ti ajvalil Herodes ta Galileae. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Oy jun cꞌacꞌal ti viniquetic taje ti scomtsanoj yotic ta staic ta cꞌoponel ti Diose. Jech iꞌalbatic yuꞌun ti Chꞌul Espíritue: ―Tꞌujbun loqꞌuel ti Bernabee, ti Sauloe, yoꞌ jech ta xichꞌic ti yabtel ti vuꞌun ta xcacꞌbee ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Cꞌalal laj yoꞌntonic ta scomtsanel ti yotique, ti ta scꞌoponel ti Diose, laj scajan scꞌobic ta sbaic. Tsꞌacal to tey laj staquic batel. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jech o xal ti Bernabee, ti Sauloe itacatic batel yuꞌun ti Chꞌul Espíritue. Icꞌotic ta Seleucia jteclum. Tsꞌacal to un, iꞌochic batel ta jun barco yoꞌ jech ta xcꞌotic ta Chipre banomil. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cꞌalal icꞌotic teye, lic yalic ti scꞌop Dios ta jujun chꞌul na yuꞌun ti jꞌisraeletic tey ta jteclum Salamina ti bu xpaj ti barcoe. Jaꞌ tey batem xtoc ti Juane ti jaꞌ yajcoltobbaique. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tey lic xanobtaic ti cꞌu sjamlej ti Chipre banomile. Tey icꞌotic ta jteclum Pafos. Tey laj staic jun jꞌilol jꞌisraelal vinic, Barjesús ti sbie. Ta xal ti ta xcꞌopoj ta sventa ti Diose ti cꞌalal jaꞌ jun jutcꞌope. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ti jꞌilol taje, jaꞌ svinic ti bijil ajvalil Sergio Pauloe. Ti ajvalile laj stac ta iqꞌuel ti Bernabee, ti Sauloe. Yuꞌun ta scꞌan ta xaꞌi ti scꞌop Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ti jꞌilol taje, jaꞌ Elimas ti yan sbi xtoque, laj yacꞌ persa ta spajesel ti jcholcꞌopetique yoꞌ jech mu xchꞌun scꞌop Dios ti ajvalil Sergio Pauloe. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jech o xal ti Sauloe, ti jaꞌ Pablo sbi xtoque, ti ventainbil yoꞌnton yuꞌun ti Chꞌul Espíritue, tey laj sqꞌuel batel ti jꞌilol vinique. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Jech laj yalbe: ―Jtiꞌoꞌnton, Jloꞌlavanej, Snichꞌon pucuj, ta xacrontain scotol ti cꞌusi leque. ¿Cꞌu chaꞌal mu xavicta aba ta soquesel yabtel ti Cajvaltique? ");
INSERT INTO tzotzc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Avi tana un, ta xayacꞌbot castigo ti Cajvaltique. Maꞌsat ta xacom. Mi jaꞌuc xuꞌ ta xavil ti saquilal osil ti jayib cꞌacꞌale ―xut. Ta jech to yepal imac ti sate. Mu xa xil ti saquilal osile. Jech o xal lic saꞌolan buchꞌu ta xnitbat batel scꞌob. Yuꞌun mu xa xil. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cꞌalal jech laj yil ti ajvalile, laj xchꞌun ti Cajvaltique. Yuꞌun yan yutsil ta xaꞌi ti ta xꞌalbat scꞌoplal ti Cajvaltique. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ti Pabloe schiꞌuc ti schiꞌiltaque tey iꞌochic batel ta jun barco ta jteclum Pafos. Tey ibatic ta jteclum Perge ti oy ta Panfilia banomile. Yan ti Juan Marcose ictavan comel. Isut batel ta Jerusalén. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tsꞌacal to un, iloqꞌuic batel ta jteclum Pergee. Ibatic ta jteclum Antioquía ti oy ta Pisidia banomile. Ti teye, ochic batel ta chꞌul na ti cꞌalal jaꞌ o scꞌacꞌalil ti cuxob oꞌntonale. Tey ichotiic. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ti jpasmantaletic yuꞌun ti chꞌul nae, cꞌalal laj yoꞌntonic ta sqꞌuelel ti vun sventa ti mantale schiꞌuc ti svun ti jꞌalcꞌopetique, laj staquic batel jꞌalmantal ti jech laj yale: ―Jchiꞌiltac, mi oy ta avoꞌnton ti cꞌusi ta xacꞌan xaval yoꞌ ta xabijubtas ti cristianoetique, xuꞌ xaval avi liꞌe ―xi. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tey lic vaꞌiuc ti Pabloe. Laj spas seña ta scꞌob ti acꞌo stsꞌijliicuque. Jech laj yal: ―Aꞌyio avaꞌiic, Jchiꞌiltac, schiꞌuc voꞌoxuc jyanlumoxuc ti ta xaxiꞌtaic ti Diose. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ti Dios cuꞌuntic jꞌisraelotique laj stꞌuj ti jmolmucꞌtotic ta voꞌnee. Laj spas ta jun mucꞌ ta jteclum ti cꞌalal tiqꞌuilic to ox ta mosovil ta Egipto banomile. Pero ta sventa stsatsal stuc laj sloqꞌues talel ta mosovil. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ti Diose, chaꞌvinic (40) jabil laj stsꞌicbe stalel yoꞌntonic ti jmolmucꞌtotic ta voꞌnee ti cꞌalal jech xjoyetic talel ta xocol banomile. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jaꞌ jech xtoc ti Diose laj slilin vuc-chop lumetic ti nacalic ta Canaán banomile, yoꞌ jech ta xticꞌatic ochel ta yosilic ti jmolmucꞌtotique. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Oy nan oꞌlol yoꞌobal ciento (450) jabil ti jmolmucꞌtotique iventainatic yuꞌun ti Dios ta sventa ti jchapanvanejetique. Jaꞌ jech sꞌelan iventainatic jaꞌ to cꞌalal sta yorail ivaꞌi ti jꞌalcꞌop Samuele. ");
INSERT INTO tzotzc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ti jmolmucꞌtotique lic scꞌanic jun ajvalil. Tey iꞌacꞌbatic jun ajvalil yuꞌun ti Diose