﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzoZNT_vpl;
CREATE TABLE tzoZNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzoZNT_vpl WRITE;
INSERT INTO tzoZNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jaꞌ liꞌ tsꞌibabil sbiic ti smucꞌtatotac ti Jesucristoe. Ti Jesucristoe jaꞌ smucꞌtatot ti Davide. Ti Davide jaꞌ smucꞌtatot ti Abraame. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iꞌayan screm ti Abraame, Isaac sbi. Iꞌayan screm ti Isaaque, Jacov sbi. Iꞌayan screm ti Jacove, Judá sbi. Ti Judae ep sbanquil yitsꞌin. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Vach iꞌayan screm ti Judae, Fares sbi ti june, Zara sbi ti june. Ti smeꞌique Tamar sbi. Iꞌayan screm ti Farese, Esrom sbi. Iꞌayan screm ti Esrome, Aram sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Iꞌayan screm ti Arame, Aminadav sbi. Iꞌayan screm ti Aminadave, Naasón sbi. Iꞌayan screm ti Naasone, Salmón sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Iꞌayan screm ti Salmone, Booz sbi. Ti smeꞌ Booze Raav sbi. Iꞌayan screm ti Booze, Obed sbi. Ti smeꞌ Obede Rut sbi. Iꞌayan screm ti Obede, Isaí sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iꞌayan screm ti Isaie, David sbi, iꞌoch ta preserente. Iꞌayan screm ti Davide, Salomón sbi. Ti smeꞌ Salomone yajnil toꞌox jun vinic Urías sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Iꞌayan screm ti Salomone, Roboam sbi. Iꞌayan screm ti Roboame, Abías sbi. Iꞌayan screm ti Abíase, Asa sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Iꞌayan screm ti Asae, Josafat sbi. Iꞌayan screm ti Josafate, Joram sbi. Iꞌayan screm ti Jorame, Uzías sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Iꞌayan screm ti Uzíase, Jotam sbi. Iꞌayan screm ti Jotame, Acaz sbi. Iꞌayan screm ti Acaze, Ezequías sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Iꞌayan screm ti Ezequíase, Manasés sbi. Iꞌayan screm ti Manasese, Amón sbi. Iꞌayan screm ti Amone, Josías sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iꞌayan screm ti Josíase, Jeconías sbi. Ti Jeconíase oy ep sbanquil yitsꞌin. Cꞌalal cuxul xchiꞌuc sbanquil yitsꞌin ti Jeconíase, jaꞌo chucul ibatic ta Babilonia ti jchiꞌiltactic ta israelale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tey xaꞌox tspasatic ta mantal ta Babilonia ti jchiꞌiltactique ti cꞌalal iꞌayan screm ti Jeconíase, Salatiel sbi. Iꞌayan screm ti Salatiele, Zorobabel sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Iꞌayan screm ti Zorobabele, Abiud sbi. Iꞌayan screm ti Abiude, Eliaquim sbi. Iꞌayan screm ti Eliaquime, Azor sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Iꞌayan screm ti Azore, Sadoc sbi. Iꞌayan screm ti Sadoque, Aquim sbi. Iꞌayan screm ti Aquime, Eliud sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iꞌayan screm ti Eliude, Eleazar sbi. Iꞌayan screm ti Eleazare, Matán sbi. Iꞌayan screm ti Matane, Jacov sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iꞌayan screm ti Jacove, José sbi. Ti Josee isaꞌ yajnil, María sbi. Ti Maríae iꞌayan sba yol, jaꞌ ti Jesuse, jaꞌ stꞌujoj Riox ti chispasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jaꞌ yech iꞌechꞌ chanlajunqꞌuex totil meꞌil ti ilic tal ta Abraame cꞌalal to David. Naca smomtac Abraam. Jaꞌ noꞌox yech noxtoc iꞌechꞌ chanlajunqꞌuex totil meꞌil ti ilic tal ta xchꞌamaltac ti Davide cꞌalal to chucul ibatic ta Babilonia ti jchiꞌiltactic ta israelale, Naca smomtac David. Ti cꞌalal chucul ibatic ta Babilonia ti jchiꞌiltactique, iꞌechꞌ chanlajunqꞌuex totil meꞌil noxtoc, jaꞌo xa iꞌayan ti Cristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ti cꞌalal iꞌayan ti Jesucristoe, jaꞌ yech smelol chac liꞌi. Ti smeꞌe, jaꞌ ti Maríae, jaꞌ scꞌubanoj ti Josee. Mu toꞌox chicꞌ sbaic. Ti Maríae ixchiꞌin yol ta syuꞌel Chꞌul Espíritu. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ti Josee lec yoꞌon, mu scꞌan xal aꞌyuc ti ta ox xicta ti slecome, yuꞌun mu scꞌan xacꞌ ta qꞌuexlal. Mucul ox chicta. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ti cꞌalal yech xaꞌox snopoj ti Josee, jaꞌo la ivaychin. Isvaychin la jun anjel ta vinajel. ―José, voꞌot smomot ti Davide, mu xavat avoꞌon. Icꞌo li Maríae. Li yol xchiꞌinoje maꞌuc xchꞌamal vinic; jaꞌ ta syuꞌel li Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Crem ta xꞌayan. Jesús xavacꞌbe sbiin yuꞌun jaꞌ chastojbe amulic, voꞌoxuc ti stꞌujojoxuc onox li Rioxe ―xꞌutat la yilel yuꞌun ti anjel ta svayiche. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jaꞌ icꞌot ti cꞌusi yaloj ti Rioxe ti cꞌalal ixchꞌamunbe ye ti yajꞌalcꞌop ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta to xchiꞌin yol jun tojol tseb. Crem ta xꞌayan. Emanuel ta sbiin yuꞌun jaꞌ Riox ti chtal xchiꞌinotique, xi onox ti jꞌalcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ti cꞌalal ijulav ti Josee, ti cꞌusi iꞌalbat yuꞌun ti anjele ixchꞌun. Iyicꞌ onox ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero muc xchiꞌin sbaic ta ora. Jaꞌto ixchiꞌin sbaic cꞌalal iꞌayan ti sba yole. Ti Josee Jesús iyacꞌbe sbiin ti unene. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ti Jesuse tey iꞌayan ta jteclum Belén liꞌ ta estado Judeae. Jaꞌo ta scoviernoal ti Erodese. Ti cꞌalal ayanem xaꞌox ti Jesuse, ital ta Jerusalén jayvoꞌ pꞌijil viniquetic liquemic tal ta loqꞌueb cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Liꞌ yul sjaqꞌuique: ―¿Bu iꞌayan ti muchꞌu scꞌoplal chaspasic ta mantal, voꞌoxuc li juriooxuque? Yuꞌun iquilticotic jpꞌej cꞌanal cꞌalal teyoticotic ta jnaticotic ta loqꞌueb cꞌacꞌale. Jaꞌ seña ti iꞌayan xa ti muchꞌu chaspasic ta mantale. Jaꞌ tal quichꞌticotic ta mucꞌ ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cꞌalal iyaꞌi ti Erodese, mu xa snaꞌ cꞌu tspas xchiꞌuc ti jchiꞌiltactic liꞌ nacajtic ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ti Erodese istac ta iqꞌuel scotol ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Cꞌalal tsobolic xa scotolique, lic sjacꞌ bu scꞌoplal ch-ayan ti Cristoe ti chtal spasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","―Scꞌoplal ch-ayan ta Belén liꞌ ta estado Judeae. Jaꞌ onox yech istsꞌibaic ti yajꞌalcꞌop Riox ti ta voꞌnee: ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Acꞌu la mi cꞌox jteclum li Belen ta yosilic ti smomtac ti Juda ti ta voꞌnee, pero ta to la xvinaj scꞌoplal ta tsꞌacal. Yuꞌun la jaꞌ tey ta xꞌayan ti muchꞌu chtal spasotic ta mantale, voꞌotic li jꞌisraelotique, ti stꞌujojotic onox ti Rioxe, xi onox ti yajꞌalcꞌope ―xi ti paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ti Erodese mucul istac ta iqꞌuel ti pꞌijil viniquetique. Isjacꞌbe cꞌusi ora iyilic ti cꞌanale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cꞌalal laj sjaqꞌue ―Batanic ta Belén. Ba jaqꞌuic yoꞌto cꞌu chaꞌal xataic ti unene. Mi ataique, xꞌechꞌ avalbecon yuꞌun chba quichꞌ ta mucꞌ uc ―xi ti Erodese, pero chloꞌlovan noꞌox. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Cꞌalal laj albaticuc ti pꞌijil viniquetique, ibatic. Ti cꞌanal iyilic ta loqꞌueb cꞌacꞌale, jaꞌ babe echꞌel yuꞌunic. Cꞌalal iyilic ti chanav toe, xmuyubajic echꞌel. Ti cꞌanale tey ipaj ta stuqꞌuil jpꞌej na yoꞌ bu ti unene. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tey iꞌoch ti pꞌijil viniquetique. Iyilic ti unene xchiꞌuc ti smeꞌe, jaꞌ ti Maríae. Iyichꞌic ta mucꞌ ti unene. Isquejan sbaic, jaꞌo isnijan sba ta balamil noxtoc. Iyacꞌbeic smoton: oro, xchiꞌuc becꞌtal pom, xchiꞌuc mirra. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tsꞌacal to iꞌalbatic la ta svayichic yuꞌun ti Rioxe ti mu xa yaꞌuc echꞌ scꞌoponic ti Erodese. Yechꞌo un cꞌalal isutic ta slumalique, jun xa o be istamic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ti cꞌalal isutic xaꞌox ti pꞌijil viniquetique, ivaychin la ti Josee. Isvaychin la jun anjel ta vinajel. ―Lican ta ora, icꞌo echꞌel li unene xchiꞌuc li smeꞌe. Batanic ta Egipto. Teanic o me. Jaꞌto mi lacalbeique xasutic tal. Yuꞌun li Erodese chlic saꞌ li unene yuꞌun yoꞌonuc smil ―xꞌutat la yilel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ti Josee ora ilic. Ta acꞌubaltic ibatic ta Egipto. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tey inaquiic. Jaꞌto isutic tal cꞌalal icham ti Erodese. Jaꞌ icꞌot ti cꞌusi iyal ti yajꞌalcꞌop Riox ti ta voꞌnee: “Ta la xbat ta Egipto ti Xchꞌamal Rioxe. Tsꞌacal to la chicꞌ sutel tal”, xi ti jꞌalcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ti Erodese, cꞌalal iyul ta sjol ti iloꞌloat yuꞌun ti pꞌijil viniquetique, icap tajmec. Isloqꞌues mantal ti acꞌu yichꞌ milel scotol cꞌox crem ta Belene. Jaꞌ ti bu chib to sjabilalique xchiꞌuc ti más cꞌoxetique. Ti Erodese snaꞌoj cꞌusi ora iyilic cꞌanal ti pꞌijil viniquetique, yechꞌo ti jaꞌ iyacꞌ ta milel ti cꞌoxetic chib sjabilale yuꞌun isnop ti tey capal chlaj ti unene. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaꞌ yech icꞌot ta Belén chac cꞌu chaꞌal icꞌot ta jteclum Ramá ti ta voꞌnee ti iyal ti Jeremías yajꞌalcꞌop Rioxe: ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ti antsetic ta jteclum Ramae chlic la oqꞌuicuc. Chat la yoꞌonic, choqꞌuitaic la ti yolique. Abol la sbaic, chat la yoꞌonic tajmec, jaꞌ la ti chmilbatic ti yolique, xi ti Jeremíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cꞌalal tey toꞌox ta Egipto ti Josee, icham ti Erodese. Ti Josee isvaychin la jun anjel ta vinajel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Lican, icꞌo echꞌel li unene xchiꞌuc li smeꞌe. Sutanic ta alumalic yoꞌ bu lachiꞌiltac ta israelale. Ti muchꞌu tsmil ox li unene icham xa ―xꞌutat la yilel yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ilic ti Josee, iyicꞌ tal ti unene xchiꞌuc ti smeꞌe. Iyulic liꞌ ta jlumaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ti cꞌalal iyulique, yan xa o covierno ochem liꞌ ta estado Judeae. Jaꞌ xa ochem screm ti ánima Erodese, Arquelao sbi. Ti cꞌalal iyaꞌi ti Josee, ixiꞌ. Muc xnaqui liꞌ ta Judeae. Iꞌalbat la ta svayich yuꞌun ti Rioxe ti acꞌu ba nacluc ta estado Galileae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yechꞌo ti ta jteclum Nazaret ba nacluque. Jaꞌ icꞌot ti yech onox tsꞌibabil scꞌoplal yuꞌun yajꞌalcꞌoptac Riox ti ta voꞌnee: “Jesus Nazaret”, xi la scꞌoplal yuꞌun ti crixchanoetique ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti cꞌalal tey toꞌox ta Nazaret ti Jesuse, ti Juan jꞌacꞌ-ichꞌvoꞌe lic yal aꞌyuc scꞌop Riox ta xocol balamil liꞌ ta estado Judeae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","―Ictaic xa spasel li cꞌusitic chopole yuꞌun chlic xa pasvanuc ta mantal ti Rioxe ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti Juane tsꞌibabil onox scꞌoplal yuꞌun ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee. Jaꞌ yech istsꞌiba chac liꞌi: Ta to xtal jun jchiꞌiltic ta israelal, tsots ch-avetaj ta xocol balamil. “Chtal xa ti Cajvaltique. Ictaic xa spasel li cꞌusitic chopole. Xachꞌunbeic me ti cꞌusitic chayalbeique”, xi chalbe ti jchiꞌiltactique, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ti Juane jalbil tsatsal cameyo scꞌuꞌ. Nucul xchuc xchꞌut. Naca cochiꞌ xchiꞌuc ajapom islajes. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ti jchiꞌiltactic ta israelale ti liꞌ nacajtic ta Jerusalene, xchiꞌuc ti muchꞌutic liꞌ nacajtic ta sjunlej estado Judeae, xchiꞌuc ti muchꞌutic tey nacajtic ta tiꞌ ucꞌum Jordane, ba yaꞌiic cꞌusi chal ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ti muchꞌutic jamal iyalic ti cꞌusitic chopol tspasique, iꞌacꞌbatic yichꞌic voꞌ ta ucꞌum Jordán yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ti Juane iyil ti tey chcꞌot ep ti muchꞌutic ochemic ta fariseoale xchiꞌuc ti muchꞌutic ochemic ta saduceoale. Cꞌot scꞌanic ichꞌvoꞌ uc. ―Li voꞌoxuque jaꞌ achiꞌilic li quiletel chone. Ti cꞌalal chaꞌi ti chtal cꞌocꞌ li chone, chjatav. Jaꞌ yechoxuc uc. ¿Miꞌn avaꞌiic xa yaꞌel ti chavichꞌic castico ti tal acꞌanic ta ora li ichꞌvoꞌe? ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mi chavichꞌic voꞌe, jaꞌ tscꞌan ti jꞌechꞌel xavictaic spasel li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mu me xanopic yech chac liꞌi: “Jaꞌ jmucꞌtatoticotic ti Abraame, yechꞌo un chicuxioticotic onox ta sbatel osil uc”, mu me xachiic. Chacalbeic, ti Rioxe xuꞌ tscꞌatajes ta smom Abraam li tonetic liꞌi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Li voꞌoxuque coꞌoloxuc xchiꞌuc teꞌel loꞌbol ti chopol ta loꞌbel sate. Tombil xa yeqꞌuelal ta yoc yuꞌun chboje loqꞌuel scotol. Chichꞌ chiqꞌuel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Li voꞌone jaꞌ noꞌox chcacꞌbe yichꞌic voꞌ ti muchꞌutic chictaic spasel li cꞌusitic chopole. Pero oy muchꞌu tsꞌacal to ta xtal, más oy syuꞌel. Li voꞌone mi jaꞌuc slicbel xonob, mu xlic cuꞌun yuꞌun mu cꞌu xitun o. Jaꞌ chayacꞌbe achiꞌinic ti Chꞌul Espíritue ti coꞌol xchiꞌuc cꞌoqꞌue yuꞌun jaꞌ tsloqꞌues o li cꞌusitic chopol ta avoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ti muchꞌutic tscꞌanic loqꞌuesbel li cꞌusitic chopol ta yoꞌonique, jaꞌ chbatic ta vinajel. Yan ti muchꞌutic mu scꞌanic loqꞌuesbele jaꞌ ch-ochic ta cꞌocꞌ ta sbatel osil. Coꞌol xchiꞌuc ti muchꞌu ta sjicꞌa strigoe. Ti cꞌalal xlaj sjicꞌae, ta xchꞌol ta stenal. Li yoctaque ta xchicꞌ ―xꞌutatic yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ti cꞌalal yolel chacꞌ ichꞌ voꞌ ti Juane, jaꞌo ilocꞌ tal ta estado Galilea ti Jesuse, tey icꞌot ta ucꞌum Jordán yuꞌun tscꞌan ti ch-acꞌbat yichꞌ voꞌ yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ti Juane mu scꞌan xacꞌbe yichꞌ voꞌ ti Jesuse. ―Voꞌot chavacꞌbon quichꞌ voꞌ ti yechuque. Maꞌuc yech smelol ti voꞌon chacacꞌbe avichꞌ voꞌe ―xi ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","―Acꞌbon quichꞌ voꞌ. Jaꞌ jtsꞌacubtastic scotol ti cꞌusi tscꞌan ti Rioxe ―xi ti Jesuse. Yechꞌo un ti Juane iyacꞌbe yichꞌ voꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ti cꞌalal laj yichꞌ voꞌ ti Jesuse, ilocꞌ ta ucꞌum. Jaꞌo ijam li vinajele. Iyil iyal tal ta sba ti Chꞌul Espíritue ti jun xchiꞌuc ti Rioxe. Coꞌol xchiꞌuc paloma yilel. Jaꞌo ichiꞌine yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ti Rioxe icꞌopoj tal ta vinajel. ―Liꞌi jaꞌ Jchꞌamal, jcꞌanoj tajmec. Jun coꞌon yuꞌun ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ti cꞌalal laj yichꞌ voꞌ ti Jesuse, iyulesbat ta sjol yuꞌun ti Chꞌul Espíritue ti chbat ta xocol balamile yoꞌ xqꞌuele o yuꞌun ti totil pucuje mi ta xchꞌun loꞌloele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ti cꞌalal tey ta xocol balamil ti Jesuse, muc xveꞌ chaꞌvinic cꞌacꞌal xchiꞌuc chaꞌvinic acꞌubal. Lic viꞌnajuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ti cꞌalal chviꞌnaj xa tajmeque, jaꞌo icꞌot ti totil pucuje, Satanás sbi. Cꞌot sloꞌlo ti yaloje. ―Ti mi yech ti voꞌot Xchꞌamalot li Rioxe, alboquic li tonetic liꞌi acꞌu cꞌatajuc ta pan ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","―Tsꞌibabil ta scꞌop Riox ti mu ta panuc noꞌox chicuxioticotique. Jaꞌ tscꞌan ta jchꞌunbeticotic noxtoc li cꞌusitic chiyalboticotic ti Rioxe ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ti pucuje iyicꞌ tal ta Jerusalén ti Jesuse. Isvaꞌan ta jol templo. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","―Ti mi yech ti voꞌot Xchꞌamalot li Rioxe, jip aba yalel. Tsꞌibabil ta scꞌop Riox ti “chastacbe tal anjeletic ti Rioxe yoꞌ mu cꞌu xapas oe. Jaꞌ stsacoj chacꞌot yoꞌ mu xayayij o ta tone”, xi tsꞌibabil ―xꞌutat yuꞌun pucuj ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","―Tsꞌibabil noxtoc ta scꞌop Riox ti mu xuꞌ jqꞌuelbeticotic yoꞌon ti Rioxe ―xꞌutat yuꞌun Jesús ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ti pucuje iyicꞌ muyel ta jpꞌej toyol vits noxtoc ti Jesuse. Ora iyacꞌbe yil sjunlej balamil ta syuꞌel xchiꞌuc ti cꞌu xꞌelan tspas mantal li jyuꞌeletique, xchiꞌuc ti cꞌu xꞌelan ichꞌbilic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","―Chacacꞌbe acuentain sjunlej mi chavichꞌon ta muqꞌue, mi chaquejletaone ―xi ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","―Batan, Satanás. Mu jchꞌun li cꞌusi chavalbone. Tsꞌibabil ta scꞌop Riox ti stuc noꞌox chquichꞌticotic ta mucꞌ ti Rioxe, ti jaꞌ ta jpasticotic ti cꞌusi tscꞌane ―xꞌutat yuꞌun Jesús ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ti pucuje ibat. Jaꞌo ital ta ora anjeletic, tal scoltael ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cꞌalal iyaꞌi ti Jesuse ti itiqꞌue ta chuquel ti Juane, isut ta Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jaꞌ iscomtsan li slumale, jaꞌ li Nazarete, tey ba nacluc ta jteclum Capernaum. Li Capernaume ta tiꞌnab yoꞌ bu yosil smomtac ti Zabulone xchiꞌuc ti Neftalí ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaꞌ icꞌot ti cꞌusi iyal ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Li yosil smomtac ti Zabulone xchiꞌuc li yosil smomtac ti Neftalí ti ta voꞌnee, chlic ta tiꞌmar cꞌalal to jech ucꞌum Jordán, Galilea chacꞌbeic sbi ti namal crixchanoetic tey chtal naclicuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ti jchiꞌiltactique ti tsꞌacal to chtal naclicuc teyoꞌe, abol sbaic. Tsꞌacal to jun yoꞌonic yuꞌun jaꞌ tey chul ta slumalic ti muchꞌu stꞌujoj Riox chistojbotic li jmultique, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cꞌalal ba nacluc ta Capernaum ti Jesuse, jaꞌo lic yal: ―Ictaic xa spasel li cꞌusitic chopole yuꞌun chlic xa pasvanuc ta mantal ti Rioxe ―xut ti jchiꞌiltactique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ti cꞌalal tey chanav ta tiꞌtiꞌnab ta estado Galilea ti Jesuse, tey iyil chaꞌvoꞌ jchiꞌiltic ta israelal, sbanquil yitsꞌin noꞌox sbaic. Li banquilale Simón sbi. Pedro li xchaꞌpꞌelel sbie. Andrés sbi li itsꞌinale. Tey yolel tsjipic ta nab snutiꞌic tsacobil choy yuꞌun tsacchoy yabtelic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","―Laꞌ chiꞌinicon, ta jel avabtelic. Chajchanubtasic cꞌuxi chba avicꞌbecon tal crixchanoetic ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ora iyictaic o li tsacchoye, jaꞌ ba xchiꞌinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ijelav echꞌel ti Jesuse xchiꞌuc li chaꞌvoꞌ jchiꞌiltique. Tey iyil otro chaꞌvoꞌ, sbanquil yitsꞌin noꞌox sbaic uc. Jaꞌ scremotic ti Zebedeoe. Li banquilale Jacobo sbi. Li itsꞌinale Juan sbi. Ticꞌajtic ta canova xchiꞌuc stotic, yolel ta stsꞌisic snutiꞌic tsacobil choy yuꞌun jatem. ―Laꞌ chiꞌinicon ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tey iscomtsanic ti stotique xchiꞌuc ti scanovaique, jaꞌ ba xchiꞌinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ti Jesuse ixanav ta sjunlej estado Galilea xchiꞌuc li yajchancꞌoptaque. Ixchanubtas jchiꞌiltactic ta israelal ta scotol bicꞌtal temploetic. Jaꞌ iyal ti ista xa yora tspasvan ta mantal ti Rioxe. Icol yuꞌun ep jchameletic noxtoc, cꞌusuc noꞌox ipic o ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ivinaj ta sjunlej estado Siria ti icol yuꞌun ep jchameletique. Yechꞌo un ti butic iꞌechꞌ ti Jesuse tey iyiqꞌuic tal ti jchameletique. Ep ta tos chamel chaꞌiic. Jlom oy cꞌusi cꞌux chaꞌiic, jlom ochem pucuj ta yoꞌonic. Oy jtupꞌ-iqꞌuetic, oy muchꞌutic chꞌabal yip jun yoc scꞌobic. Ti Jesuse icol yuꞌun scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ep tajmec crixchanoetic ixchiꞌinic echꞌel ti Jesuse. Jaꞌ ti muchꞌutic tey nacajtic ta Galileae, xchiꞌuc ta Decapolise, xchiꞌuc liꞌ ta Jerusalene, xchiꞌuc ta yan jteclumetic liꞌ ta estado Judeae, xchiꞌuc ti muchꞌutic tey nacajtic ta jech ucꞌum Jordane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cꞌalal iyil ti Jesuse ti batsꞌi ep tajmec stsoboj sbaic ti jchiꞌiltactic ta israelale, imuy jtsꞌuj ta chꞌut vits, tey ichoti. Lichotioticotic uc, voꞌoticotic li yajchancꞌopoticotique. Ibatic uc ti muchꞌutic sjunul yoꞌon chaꞌiic cꞌusi chal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ti Jesuse lic chanubtasvanuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ti muchꞌutic snaꞌojic ti muc bu lec yoꞌonique, chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun chlic pasaticuc ta mantal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ti muchꞌutic choqꞌuita sbaic yuꞌun li smulique, chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun chpatbat yoꞌonic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ti muchutic mu snaꞌ stoy sbaique, chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun ta slumalinic ti achꞌ balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ti muchꞌutic sjunul yoꞌon tscꞌanic lecubtasbel yoꞌonique, chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun ta xlecubtasbat yoꞌonic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ti muchꞌutic chcꞌuxubinvanique chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun ta xcꞌuxubinatic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ti muchꞌutic sjunul yoꞌon tspasic li cꞌusitic lec chil ti Rioxe, chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun chba sqꞌuelbeic sat ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ti muchꞌutic tspajesic cꞌope chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun “jchꞌamaloxuc”, xꞌutatic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ti muchꞌutic ch-ilbajinatic o ti cꞌusitic lec tspasique, chilic to ta tsꞌacal ti jun yoꞌonique yuꞌun chlic pasaticuc ta mantal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","’Li voꞌoxuque mi chopol cꞌusi chayalbeic o crixchanoetic ti avichꞌojicon ta muqꞌue, mi chayilbajinique, mi chasnopbe amulique, mu xavat o avoꞌonic. Junuc noꞌox avoꞌonic yuꞌun lec ti cꞌusi chcꞌot ataic ta vinajele. Jaꞌ yech iꞌilbajinatic ti yajꞌalcꞌoptac Riox ti ta voꞌne uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Li voꞌoxuque coꞌoloxuc cꞌu chaꞌal atsꞌam yaꞌel yuꞌun voꞌoxuc ta xlecub avuꞌunic li balamile. Ti mi lec li cꞌusitic chapasique, chatunic liꞌ ta sba balamile. Ti mi chopol li cꞌusitic chapasique, mu cꞌu xatunic o. Coꞌol cꞌu chaꞌal atsꞌam ti mu xa bu chiꞌe, mu xa cꞌu stu. Chichꞌ taniel. Chtecꞌulanat yuꞌun li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Li voꞌoxuque coꞌoloxuc cꞌu chaꞌal luz yaꞌel liꞌ ta sba balamile. Chavaqꞌuic iluc ti lec avoꞌonique, jaꞌ chilic o li crixchanoetique ti xuꞌ chlecub yoꞌonic uque. Coꞌol xchiꞌuc jun jteclum ta jolvits, lec xvinaj, mu stacꞌ naqꞌuel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jaꞌ noꞌox yech noxtoc cꞌalal ta jtsan jcastique, mu jmactic ta almul. Toyol onox chcacꞌtic yoꞌ xilic o osil scotol ti muchꞌutic teyic ta yut nae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Li voꞌoxuque jaꞌ yech tscꞌan chvinaj ti lec avoꞌonique yoꞌ xilic o li crixchanoetique, yoꞌ xlic yichꞌic o ta mucꞌ ti Jtotic Riox ta vinajele ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iyal noxtoc ti Jesuse: ―Mu me xanopic ti tal jchꞌaybe smantal ti Rioxe xchiꞌuc ti cꞌusitic iyalic ti yajꞌalcꞌoptac ti ta voꞌnee. Maꞌuc tal jchꞌay; tal jtsꞌacubtas scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta melel chacalbeic, cꞌalal mu toꞌox chlaj li vinajel balamile, mi jpꞌel mu xchꞌay ti cꞌusitic yaloj ti Rioxe, persa chcꞌot scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ti muchꞌu mu xchꞌun jtosuc li smantaltac Rioxe, mi jaꞌ yech ta xchanubtas li crixchanoetique, jaꞌ mu tsotsuc yabtel chcꞌot yoꞌ bu tspas mantal ti Rioxe. Ti muchꞌu ta xchꞌun scotol smantal ti Rioxe, mi jaꞌ yech ta xchanubtas li crixchanoetique, jaꞌ tsots yabtel chcꞌot yoꞌ bu tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chacalbe avaꞌiic, ti muchꞌutic ta xchanubtasvanic ta smantaltac Rioxe xchiꞌuc li jfariseoetique, chalic ti lec yoꞌonique. Yan li voꞌoxuque jaꞌ tscꞌan ti ta melel lec avoꞌonique. Mi jaꞌ yechoxuc chac cꞌu chaꞌal li jfariseoetique, mu xuꞌ chaꞌochic uc yoꞌ bu tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Avaꞌyojic ti iꞌalbatic ti voꞌne moletique ti mu me xmilvanique. “Ti muchꞌu chmilvane milic”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Li voꞌone chacalbeic, ti muchꞌu tscapan li xchiꞌile, xchiꞌuc ti muchꞌu “mu cꞌu balot o”, xut li xchiꞌile, xchiꞌuc ti muchꞌu “toj sonsoot”, xut li xchiꞌile, coꞌol smul cꞌu chaꞌal li jmilvanejetique. Coꞌol chba yichꞌic castico ta cꞌocꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Jaꞌ tscꞌan ti lec xavil abaic ta acotolique. Mi chba avacꞌbe smoton Riox yoꞌ xchicꞌobil smotone, mi tey iyul ta ajol ti oy amul yuꞌun lachiꞌile, tey ictao comel ta stsꞌel xchicꞌobil smoton Riox li cꞌusi avichꞌoj echꞌele. Baꞌyi ba lajesbo yoꞌon ti muchꞌu oy amul yuꞌune. Mi ilaj yoꞌone, xtal avacꞌbe smoton ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Mi oy bu ata amul yuꞌun lachiꞌile, tscꞌan ti chba alajesbe yoꞌon ta orae. Ti mi mu xba alajesbe yoꞌone, chayicꞌ echꞌel ta stojol jmeltsanejcꞌop. Li jmeltsanejcꞌope chayacꞌ ta scꞌob jchabiejtemplo. Li jchabiejtemploe chasticꞌ ta chuquel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta melel chacalbeic, mi mu xapasic chac cꞌu chaꞌal lacalbeique, li jmeltsanejcꞌope chacꞌ atojic scotol lamulique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Avaꞌyojic ti iꞌalbatic ti voꞌne moletique ti mu me saꞌ yantsique, ti mu me saꞌ yajmul li antsetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Li voꞌone chacalbeic, ti muchꞌutic chpichꞌ yoꞌon antsetique, coꞌol xa xchiꞌuc yants chcꞌot. Ti muchꞌutic chpichꞌ yoꞌon viniquetique, coꞌol xa xchiꞌuc yajmul chcꞌot. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Mi jaꞌ chata o amulic lasatique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o ta vinajele. Mi asatic noꞌox chaꞌochic o ta cꞌocꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jaꞌ noꞌox yech noxtoc mi jaꞌ chata o amulic lacꞌobique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o ta vinajele. Mi acꞌobic noꞌox chaꞌochic o ta cꞌocꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Avaꞌyojic noxtoc ti iꞌalbatic ti voꞌne moletique: “Ti muchꞌu ta xchꞌac yajnile, acꞌu smeltsanbe svunal ti ixchꞌac xa sbaique, acꞌu yacꞌbe ti yajnile. Jaꞌto mi oy svunale xuꞌ xchꞌac sbaic”, xꞌutatic onox. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Li voꞌone chacalbeic, ti muchꞌu ta xchꞌac yajnile, mi muc bu saꞌoj yajmul ti ta xchꞌaque, coꞌol xchiꞌuc isaꞌ yajmul yaꞌel ti yajnile yuꞌun ixchꞌac. Ti muchꞌu chicꞌ chꞌacbalal antse, coꞌol xchiꞌuc yants chcꞌot noxtoc ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iyal noxtoc ti Jesuse: ―Avaꞌyojic noxtoc ti iꞌalbatic ti voꞌnee: “Mi chavaꞌanic ta rextico ti Rioxe, xapasic me li cꞌusi chavalique”, xꞌutatic onox. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Li voꞌone chacalbeic, mu me xavaꞌanic ta rextico li vinajele, yuꞌun jaꞌ tey chotol tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu me xavaꞌanic ta rextico li balamile, yuꞌun jaꞌ scuentainoj ti Rioxe. Mu me xavaꞌanic ta rextico li jteclum Jerusalene, yuꞌun jaꞌ stꞌujoj ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu me xavaꞌanic ta rextico lajolique, yuꞌun jaꞌ spasoj ti Rioxe. Li stsatsal ajolique mu stacꞌ xasacubtasic, mu stacꞌ xavicꞌubtasic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yechuc me li cꞌusi chavalique. Ti mi chanopic cꞌope, jaꞌ mulil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Avaꞌyojic ti iꞌalbatic ti voꞌnee: “Ti mi atꞌusbe jpꞌejuc sat achiꞌile, chavichꞌ tꞌusbel jpꞌejuc asat uc. Ti mi acolesbe jpꞌejuc stanal ye achiꞌile, chavichꞌ colesbel jpꞌejuc stanal ave uc”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Li voꞌone chacalbeic, ti muchꞌu ilbaj xayilique, tsꞌiquic me. Ti mi oy muchꞌu chasmajbe jot xocon asate, albo ti xuꞌ tsmaj xchaꞌjotole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ti mi oy muchꞌu chasticꞌbe amul ta stojol li jmeltsanejcꞌopetique, mi chaspojbe lacamisae, acꞌbo. Acꞌbo noxtoc lapimilcꞌuꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ti mi oy muchꞌu chayalbe chacuchbe echꞌel yicats junuc revae, cuchbo echꞌel chibuc reva. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ti mi oy muchꞌu chascꞌanbe li cꞌusuc avuꞌune, acꞌbo. Ti mi oy cꞌusi chaxchꞌamunbee, mu me xajalan ―xiyutoticotic ti Jesuse―. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Avaꞌyojic noxtoc ti iꞌalbatic ti voꞌnee: “Cꞌuxubinic lachiꞌilique. Lacrontaique crontainic”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Li voꞌone chacalbeic, cꞌuxubinic acrontaic. Cꞌanbeic bentisyon ti muchꞌutic chopol cꞌusi chayalbeique. Lec xacꞌoponic ti muchꞌutic mu scꞌan sqꞌuel asatique. Cꞌoponbeic Riox ti muchꞌutic chayilbajinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ti mi yech chapasique, chvinaj ti xchꞌamaloxuc xa ti Jtotic Riox ta vinajele. Ti Rioxe ta xlocꞌ tal yuꞌun li cꞌacꞌale scuenta scotol crixchanoetic, acꞌu mi lec yoꞌonic, acꞌu mi chopol sjolic. Jaꞌ noꞌox yech li voꞌe chiyacꞌbotic ta parejo. Jaꞌ chvinaj o ti scꞌanoj scotol crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ti mi jaꞌ noꞌox acꞌanojic li muchꞌutic scꞌanojoxuque, mu xvinaj ti lec avoꞌonique. Coꞌoloxuc xchiꞌuc jcꞌan-locꞌ-cꞌusiticuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ti mi jaꞌ noꞌox chacꞌoponic li muchꞌutic lec xavojtiquinique, mu xvinaj ti lec avoꞌonique. Coꞌoloxuc xchiꞌuc li muchꞌutic mu xichꞌic ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Li voꞌoxuque tscꞌan chvinaj ti lec avoꞌonic chac cꞌu chaꞌal chvinaj slequil yoꞌon ti Jtotic Riox ta vinajele ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Liyalboticotic noxtoc ti Jesuse: ―Mu me xatoy o abaic ti cꞌalal chapasic cꞌusitic tscꞌan ti Jtotic Riox ta vinajele. Mi chacꞌanic o ichꞌel ta muqꞌue, mu xayacꞌbe amotonic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ti cꞌalal chavacꞌ alimoxnaique, mu me xaꞌiꞌonicuc to chac cꞌu chaꞌal ti muchꞌutic yichꞌojic ta mucꞌ Riox ti yalojique. Ti cꞌalal chacꞌ slimoxnaic ta bicꞌtal temploetique, mi ta cayatic, chalic to aꞌyuc yoꞌ xꞌichꞌeic o ta mucꞌ yuꞌun li crixchanoetique. Ta melel chacalbeic, ti muchꞌutic yech tspasique jaꞌ noꞌox lec ch-ileic yuꞌun li crixchanoetique; mu cꞌu stu ch-ileic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ti cꞌalal chavacꞌ alimoxnaic li voꞌoxuque, mu me xanopic ti chavaqꞌuic iluque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Acꞌu mi mucul chavaqꞌuic, ti Jtotic Rioxe yiloj onox. Chayacꞌbeic bentisyon. Li bentisyon chayacꞌbeique chilic scotol crixchanoetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ti cꞌalal chacꞌoponic Rioxe, mu me xanopic chac cꞌu chaꞌal tsnopic ti muchꞌutic yichꞌojic ta mucꞌ Riox ti yalojique. Yuꞌun ichꞌel noꞌox ta mucꞌ tscꞌanic ti cꞌalal tsvaꞌan sbaic ta bicꞌtal temploetique, mi ta yesquinail cayaetic, ti cꞌalal tscꞌoponic Rioxe. Ta melel chacalbeic, ti muchꞌutic yech tsnopique jaꞌ noꞌox lec ch-ileic yuꞌun li crixchanoetique; mu cꞌu stu ch-ileic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ti cꞌalal chacꞌoponic Riox li voꞌoxuque, mu me xanopic ti chavaqꞌuic iluque. Qꞌuejo aba atuc ti cꞌalal chacꞌopon Rioxe. Acꞌu mi atuc chacꞌopon, ti Jtotic Rioxe yiloj onox. Chayacꞌbeic bentisyon. Li bentisyon chayacꞌbeique chilic scotol crixchanoetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ti cꞌalal chacꞌoponic Rioxe, mu me teyuc noꞌox chavalulanbeic ti cꞌusi avalbeic xae chac cꞌu chaꞌal tscꞌoponic yajsantoic ti muchꞌutic maꞌuc jchiꞌiltique. Leꞌe yuꞌun tsnopic ti jaꞌto yech ch-aꞌibatic o ti ep ta echꞌel chalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Li voꞌoxuque mu me xapasic yech. Ti Jtotic Riox ta vinajele snaꞌoj ti cꞌusitic chtun avuꞌunic ti cꞌalal mu toꞌox chacꞌanbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ti cꞌalal chacꞌoponic Rioxe, xavalic chac liꞌi: Tot, Cajval, teyot ta vinajel, acꞌu quichꞌoticotic ta mucꞌ jcotolticotic liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jaꞌ ta jcꞌanticotic ti chapas mantal atuc liꞌ ta sba balamile. Ta vinajele jaꞌ tspasic li cꞌusitic lec chavile. Jaꞌ noꞌox yech acꞌu jpasticotic liꞌ ta sba balamil li cꞌusitic lec chavile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Acꞌbon jveꞌelticotic lavie. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Acꞌboticotic pertonal yuꞌun jmulticotic yuꞌun icacꞌbeticotic xa pertonal li muchꞌutic ista smul cuꞌunticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Coltaoticotic yoꞌ mu jpasticotic o li cꞌusitic chopole. Voꞌot chapas mantal ta sbatel osil. Voꞌot oy alequilal ayuꞌelal. Voꞌot chaquichꞌticotic ta mucꞌ ta sbatel osil. Toj lec ti jaꞌ yech chcꞌote, xachiic ti cꞌalal chacꞌoponic Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Mi chavaqꞌuic ta pertonal ti muchꞌu oy smul avuꞌunique, jaꞌ noꞌox yech chayacꞌbeic pertonal yuꞌun amulic uc ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ti mi mu xaꞌacꞌvanic ta pertonale, jaꞌ noꞌox yech mu xayacꞌbeic pertonal yuꞌun amulic uc ti Jtotic Riox ta vinajele ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Iyal noxtoc ti Jesuse: ―Mi chavicta avotic cꞌalal chacꞌoponic Rioxe, mu me xapasic chac cꞌu chaꞌal tspasic ti muchꞌutic yichꞌojic ta mucꞌ Riox ti yalojique. Yuꞌun tsbon satic ta tanil tiꞌ cꞌocꞌ yoꞌ xvinaj o ti yictaoj yotique. Ta melel chacalbeic, ti muchꞌutic yech tspasique jaꞌ noꞌox lec ch-ileic yuꞌun li crixchanoetique; mu cꞌu stu ch-ileic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ti cꞌalal chavicta avotic li voꞌoxuque, mu me xanopic ti chavaqꞌuic iluque. Tuso ajolic, poco asatic chac cꞌu chaꞌal chapasic onoxe yoꞌ mu xvinaj o ti avictaoj avotique. Ti Jtotic Riox ta vinajele yiloj onox, chayacꞌbeic bentisyon. Li bentisyon chayacꞌbeique chilic scotol crixchanoetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mu me xatsob acꞌulejalic liꞌ ta sba balamile. Liꞌtoe chlaj ta vach chon li cꞌusuc avuꞌunique, chcuxin, chbat ta jꞌelecꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Li cꞌusuc avuꞌunique más lec aqꞌuic tunuc yuꞌun Riox yoꞌ oy o acꞌulejalic ta vinajele. Teyoꞌe mu xꞌoch vach chon sepꞌ acꞌuꞌic, mu xcuxin, mu xꞌoch jꞌelecꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ti bu lacꞌulejalique, jaꞌ tey batem avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mi chacꞌuxubinic achiꞌilique, coꞌol xchiꞌuc lec asatic yaꞌel yuꞌun chavaqꞌuic tunuc yuꞌun Riox li cꞌusuc avuꞌunique. Mi yech chapasique, lec chabatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yan ti mi mu xacꞌuxubinvanique, coꞌol xchiꞌuc maꞌsatoxuc yaꞌel yuꞌun mu xavaqꞌuic tunuc yuꞌun Riox li cꞌusuc avuꞌunique. Mi yech chapasique, chopol chabatic. Jaꞌ ta xchꞌay xavaꞌiic li scꞌop Rioxe ti avaꞌyojic xae. Más to chopol chabatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Mu xuꞌ mi chaꞌvoꞌ avajvale. Coꞌol xchiꞌuc jun mozoil ti mu xuꞌ chaꞌvoꞌ yajvale. Mi chaꞌvoꞌ yajvale, li june chopol chil; li june lec chil. Li june yichꞌoj ta mucꞌ; li june mu xichꞌ ta mucꞌ. Jaꞌ noꞌox yech mu xuꞌ chatunic yuꞌun Riox mi jaꞌ noꞌox ta avoꞌonic li taqꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Yechꞌo un chacalbeic, mu me xavat avoꞌonic ti cꞌuxi chacuxiic liꞌ ta sba balamile, ti cꞌuxi chaveꞌ chavuchꞌic voꞌe, ti bu chata acꞌuꞌ apoqꞌuique. Yuꞌun jaꞌ layacꞌbe apat axoconic achꞌulelic ti Rioxe, yechꞌo un chacꞌ aveꞌelic, chacꞌ acꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Qꞌuelavilic li mutetique, mu snaꞌ xꞌabtejic. Mu snaꞌ xꞌovolajic, mu snaꞌ xcꞌajavic, chꞌabal stenal sveꞌelic. Jaꞌ chmacꞌlinatic yuꞌun ti Jtotic Riox ta vinajele. Ali voꞌoxuque más to chaxcꞌuxubinic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Acꞌu mi xavat avoꞌonic, mu xanatubic o chaꞌchꞌixuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Cꞌu yuꞌun ti chavat o avoꞌonic ti bu chata acꞌuꞌ apoqꞌuique? Qꞌuelavilic cꞌu slequil ta xchꞌi li nichimetic ta stentejtique. Pero mu xꞌabtejic, mu sjal scꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Chacalbe avaꞌiic. Ti Salomón ti ta más voꞌnee jcꞌulej tajmec, lequic sba ti scꞌuꞌ spoqꞌue, pero mu xcoꞌolaj xchiꞌuc li nichime. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Li tsꞌiꞌlele batsꞌi yox tajmec lavie, pero ocꞌob chaꞌej chichꞌ tiqꞌuel ta jorno, chtaꞌaj o pan. Acꞌu mi muc bu jal ta xchꞌi li tsꞌiꞌlele pero batsꞌi yox tajmec xchaꞌle ti Rioxe. ¿Mi jaꞌ xa mu xayacꞌbeic acꞌuꞌic yaꞌel un? Yuꞌun mu to chachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yechꞌo un mu me xavat avoꞌonic ti cꞌuxi chaveꞌ chavuchꞌic voꞌe, ti bu chata acꞌuꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ti muchꞌutic mu to ta xchꞌunic li scꞌop Rioxe chat yoꞌonic. Li voꞌoxuque snaꞌoj cꞌusitic chtun avuꞌunic ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yechꞌo un chꞌunic cꞌusi chayalbeic ti Rioxe. Mi achꞌunique, chayacꞌbeic ti cꞌusitic chtun avuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mu me xavat avoꞌonic cꞌusi chapasic li ocꞌobe yuꞌun mu xanaꞌic cꞌusi chcꞌot. Taꞌluc o me ti cꞌu xꞌelan avocolic jujun cꞌacꞌale. Mu me xasaꞌic yan ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iyal noxtoc ti Jesuse: ―Mu me xanopbe smul achiꞌil yoꞌ ti mu xayalbe o ti Rioxe ti oy amule. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ti cꞌu xꞌelan abol sba avuꞌun lachiꞌile, jaꞌ noꞌox yech chayacꞌbe castico ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Acꞌu mi mu cꞌusi más chopol tspas lachiꞌile, li voꞌote yochelot ta sqꞌuelel. Mu xavaꞌi aba ti más to chopol li cꞌusi chapase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","“Chopol ti xꞌelan chapase”, xavut lachiꞌile, pero ¿cꞌuxi chapꞌijubtasvan ti más to chopol cꞌusitic chapas li voꞌote? ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Li voꞌote chanop ti mu cꞌusi chopol chapase. Mi chacꞌan chapꞌijubtas lachiꞌile, jaꞌ tscꞌan ti voꞌot baꞌyi chavicta spasel li cꞌusitic chopole. Mi avil xa ti lecote, xuꞌ xa xapꞌijubtas lachiꞌile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ti muchꞌu mu scꞌan albel li scꞌop Rioxe ti jaꞌ chacuxiic o ta sbatel osile, mu xachaꞌalbe. Yuꞌun jaꞌ xchiꞌil li tsꞌiꞌe ti mu xaꞌi pajesel cꞌalal chtiꞌvane. Jaꞌ xchiꞌil noxtoc li chitome ti tstecꞌulan li natsꞌil bu toyol stojole ti leclec sbae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Mi mu xavicta abaic ta scꞌanulanbel ti Rioxe, ta onox xayacꞌbeic li cꞌusitic chacꞌanique. Coꞌol xchiꞌuc li muchꞌu tsaꞌ cꞌusi chtun yuꞌune, tsta. Coꞌol xchiꞌuc li muchꞌu chcꞌopoj ta tiꞌnae, chtacꞌbat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Li muchꞌutic mu xicta sba ta scꞌanele, ch-acꞌbatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Li voꞌoxuque, ti cꞌalal chascꞌanbeic pan lachꞌamalique, maꞌuc ton chavacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ti cꞌalal chascꞌanbeic choye, maꞌuc chon chavacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Li voꞌoxuque chopol ajolic pero xanaꞌic cꞌusi lec chavacꞌbeic lachꞌamalique. Ti Jtotic Riox ta vinajele más lec cꞌusi chayacꞌbeic mi chacꞌanbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ti mi chacꞌan ti lec chayil li crixchanoetique, jaꞌ tscꞌan ti lec chavil uque. Jaꞌ yech chal li scꞌop Rioxe ti stsꞌibaojic ti Moisese xchiꞌuc ti yan yajꞌalcꞌoptac Riox ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Vocol ta tael li sbelel vinajele pero saꞌic me. Ep ti muchꞌutic chbatic ta cꞌoqꞌue yuꞌun mu vocluc ta tabel sbelel. Jayvoꞌ noꞌox ti muchꞌutic chbatic ta vinajele. Jaꞌ noꞌox chbatic ti muchꞌutic chichꞌic ta mucꞌ ti Rioxe ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iyal noxtoc ti Jesuse: ―Pꞌijanic me, mu me xachꞌunic loꞌloel yuꞌun ti muchꞌutic chalic yilel li scꞌop Rioxe. Yuꞌun chtal scꞌoponoxuc manxoic yilel chac cꞌu chaꞌal chij, pero li yoꞌonique jaꞌ chac cꞌu chaꞌal li oqꞌuile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jaꞌ chavilic o ti cꞌusi tspasique. Anaꞌojic ti mu xataic uva ta jtecꞌ chꞌixe, ti mu xataic icꞌux ta saquil chꞌixe. Jaꞌ noꞌox yech ti muchꞌutic chalic yilel li scꞌop Rioxe, mu cꞌusi lec chataic yuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Li teꞌel loꞌbol ti bu onox leque, lec li sate. Ti bu onox chopole, chopol li sate. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mu scap sba li leque xchiꞌuc li chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Li jtecꞌ loꞌbol ti chopol sate ta stsꞌete, ta xchiqꞌue. Jaꞌ noꞌox yech ti muchꞌutic chalic yilel li scꞌop Rioxe, ch-ochic ta cꞌocꞌ ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yechꞌo un mi avilic ti chopol cꞌusitic tspasique, naꞌic me ti jaꞌ jloꞌlovanetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ep ti muchꞌutic “Cajval, Cajval”, xiyute, pero mu scotoluc ch-ochic yoꞌ bu ta jpas mantale. Jaꞌ noꞌox ch-ochic ti muchꞌutic tspasic ti cꞌusitic tscꞌan ti Jtot ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ep ti muchꞌutic jaꞌ yech chiyalbeic ti cꞌalal sta yora chcalbe bu chbatic ta sbatel osil li crixchanoetique: “Cajval, icalticotic acꞌop. Voꞌot ta ayuꞌel ijloqꞌuesticotic pucujetic. Ep ta echꞌel icacꞌticotic iluc alequilal ayuꞌelal”, chiyutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Maꞌuc jchꞌamaloxuc. Batanic, mu xajcꞌanic yuꞌun jaꞌ achꞌunbeic smantal ti pucuje”, ta xcutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ti muchꞌu chaꞌi li cꞌusi chcale, mi ta xchꞌune, coꞌol xchiꞌuc jun vinic ti pꞌije, ismeltsan sna ta ba ton. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ital tsots voꞌ. Li spat xocon snae, inoj. Tsots iꞌechꞌ icꞌ yoꞌ bu li snae, pero muc xlom yuꞌun ta ba ton smeltsanoj. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ti muchꞌu chaꞌi li cꞌusi chcale, mi mu xchꞌune, coꞌol xchiꞌuc sonso vinic ti ta ba yiꞌ smeltsanoj snae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ital tsots voꞌ. Li spat xocon snae, inoj. Tsots iꞌechꞌ icꞌ yoꞌ bu li snae, ilom ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cꞌalal laj loꞌilajuc ti Jesuse, ti jchiꞌiltactique xchꞌayet xa yoꞌonic ti xꞌelan ichanubtasvane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yuꞌun lec snaꞌ ti cꞌusitic tscꞌan ti Rioxe. Maꞌuc yech ichanubtasvan chac cꞌu chaꞌal jchiꞌiltactic ti ta xchanubtasvanic yilel ta smantaltac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ti cꞌalal iyal tal ta yoc vits ti Jesuse, ep jchiꞌiltactic isnapꞌletaic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Isnupic ta be jun jchiꞌiltic ta israelal ip ta lepra. Isquejan sba ta yichon ti Jesuse, jaꞌo isnijan sba ta balamil noxtoc. ―Cajval, acꞌanuc la avetꞌesbon li chamel xꞌelan ipon oe, yuꞌun jnaꞌoj ti voꞌot xuꞌ chavetꞌesbone ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ti Jesuse iyacꞌ scꞌob ta sba ti jchamele. ―Echꞌuc cheꞌe ―xut. Ora iꞌechꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","―Mu me muchꞌu xavalbe yaꞌi ti voꞌon laquetꞌesbot lachamele. Jaꞌ noꞌox ba acꞌbo yil li palee. Acꞌbo smoton Riox chac cꞌu chaꞌal yaloj ti Moisese yoꞌ xilic o li jchiꞌiltactique ti lecot xae ―xut echꞌel vinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Ti cꞌalal iꞌoch ta Capernaum ti Jesuse, tey ital jun capitan soltero. ―Cajval, mi mu xaꞌabulaj xavetꞌesbon xchamel li jmozoe yuꞌun ip. Puchꞌul ta tem yuꞌun chꞌabal yip jun yoc scꞌob. Cꞌux tajmec chaꞌi ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","―Chba jqꞌuel cheꞌe. Chba quetꞌesbe ti xchamele ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","―Cajval, mu tsotsuc cabtel ti voꞌot chabat ta jnae. Xuꞌ jaꞌ noꞌox alo jpꞌeluc ti acꞌu echꞌuc xchamel li jmozoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Li voꞌone mantal noꞌox ta jchꞌun ti ta jpas ta mantal li solteroetique. “Batan”, mi xcut li june, chbat. “Laꞌ to”, mi xcut li june, chtal. “Paso chac liꞌi”, mi xcut li jmozoe, tspas ―xi ti capitan solteroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ti cꞌalal iyaꞌi ti Jesuse, xchꞌayet xa yoꞌon. ―Ta melel chacalbeic, muc bu jtaoj yech junuc jchiꞌiltic ta israelal ti ta xchꞌun chac cꞌu chaꞌal ta xchꞌun li vinic liꞌi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chacalbeic noxtoc. Ta sta yora ti chtal ep crixchanoetic ta sjunlej balamil ti maꞌuc jchiꞌiltic ta israelale. Ta xꞌochic yoꞌ bu tspas mantal ti Rioxe. Jaꞌ chtal xchiꞌinic ti jmucꞌtatotic ti ta más voꞌnee, jaꞌ ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ti muchꞌutic scꞌoplal ox ch-ochic yoꞌ bu tspas mantal ti Rioxe, mu xꞌochic yuꞌun mu xichꞌic ta mucꞌ ti Rioxe. Ta xꞌaqꞌueic echꞌel ta icꞌ osil. Tey xꞌoqꞌueletic, xcꞌuxuxet o yeic yuꞌun tsots castico chichꞌic ―xꞌutatic yuꞌun Jesús ti muchꞌutic napꞌajtic echꞌel ta spate. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","―Xuꞌ xa chabat yuꞌun icꞌot xa li cꞌusi achꞌunoje ―xꞌutat yuꞌun Jesús ti capitan solteroe. Ora iꞌechꞌ xchamel ti smozoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ti Jesuse ibat ta sna Pedro. Iyil ti tey puchꞌul ta stem ti sniꞌmeꞌel Pedroe yuꞌun tilem. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ti Jesuse istsacbe scꞌob. Ora itupꞌ scꞌacꞌal, lic macꞌlinvanuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ti cꞌalal iꞌoch acꞌubale, iyiqꞌuic tal ep ti muchꞌutic ochem pucuj ta yoꞌonique. Ti Jesuse ta jpꞌel noꞌox cꞌop isloqꞌues ti pucujetique. Icol yuꞌun scotol jchameletic ti italic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jaꞌ icꞌot ti cꞌusi iyal ti Isaías ti ta voꞌnee. “Jaꞌ ch-echꞌ o cuꞌuntic chamel, cꞌusuc noꞌox chamelal ipotic o”, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cꞌalal iyil ti Jesuse ti joyletabil ta crixchanoetique ―Batic ta jech nab ―xut li yajchancꞌoptaque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tey icꞌot jun ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ―Cajval, chajchiꞌin echꞌel ti butic chabate ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","―Li vete oy xchꞌen, li mute oy stsoꞌop. Voꞌon ti coꞌol crixchanootique chꞌabal jna. Nopo lec mi chachiꞌinon echꞌele ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tey icꞌot jun ti muchꞌutic tey onox xchiꞌuquic sjil cꞌacꞌal ti Jesuse. ―Cajval, acꞌon to echꞌel. Jaꞌto chtal jchiꞌinot ti cꞌalal xcham li jtote ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","―Batic, chiꞌinon echꞌel. Ti muchꞌutic mu xiyichꞌic ta muqꞌue, chamemic yaꞌel. Tey acꞌu smuc sba stuquic ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iꞌoch ta canova xchiꞌuc yajchancꞌoptac ti Jesuse, ijelavic ta jech nab. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cꞌalal chanavic ta ba nabe, ilic tsots icꞌ, xyucꞌyon xa tajmec li nabe. Ep iꞌoch voꞌ ta yut canova, chmuc xaꞌox yalel. Ti Jesuse tey vayem ta yut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Li yajchancꞌoptaque istijic ti Jesuse. ―Cajval, coltaoticotic yuꞌun chimucotic xa yalel ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","―¿Mi mu to bu achꞌunojic yaꞌel ti voꞌon tsots jyuꞌele? ¿Cꞌu yuꞌun ti chaxiꞌique? ―xꞌutatic yuꞌun ti Jesuse. Ilic ti Jesuse, ispajes li iqꞌue, ivaxi yuꞌun li nabe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Xchꞌayet xa o yoꞌonic li yajchancꞌoptaque. ―¿Cꞌusi vinical liꞌi ti jliquel ispajes li iqꞌue, ti ivaxi yuꞌun li nabe? ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ti Jesuse xchiꞌuc li yajchancꞌoptaque icꞌotic ta jech nab ta slumal jgadaraetic. Cꞌalal ilocꞌ ta canova ti Jesuse, ital chaꞌvoꞌ vinic ochem pucuj ta yoꞌonic. Ta muquenal iloqꞌuic tal yuꞌun jaꞌ snainojic li chꞌojbil tonetique ti yoꞌ bu chichꞌic tiqꞌuel ti ánimaetique. Mu xa muchꞌu scꞌan xꞌechꞌ tey ta bee yuꞌun oy xiꞌelalic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iꞌavanic: ―¿Cꞌusi acuentaoticotic o li voꞌote, Jesús, Xchꞌamal Riox? Mu to sta yora ti chavacꞌboticotic casticoe ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jaꞌo tey xlamet ep chitometic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","―Mi chaloqꞌuesoticotic ta yoꞌonic li viniquetic liꞌi, abulajan alo acꞌop ti chiꞌochoticotic ta chitometique ―xi ti pucujetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Ba ochanic ―xꞌutatic yuꞌun ti Jesuse. Ti pucujetique iloqꞌuic ta yoꞌonic ti chaꞌvoꞌ vinique, iꞌochic ta chitometic. Ti chitometique stusus xa yalel scotol, ipꞌajic ta nab, ijicꞌav scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ti jchabichitometique ixiꞌic. Ba yalic ta jteclum ti icham scotol ti chitometique, ti lec xa ti chaꞌvoꞌ xchiꞌilic ti ochem toꞌox pucuj ta yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ti crixchanoetic ta jteclume ilocꞌ scotolic, tal sqꞌuelic ti Jesuse. Cꞌalal iyulique ―Abulajan locꞌan echꞌel liꞌtoe ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsꞌacal to iꞌoch ta canova ti Jesuse, isut ta Capernaum yoꞌ bu nacale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Cꞌalal tey xaꞌoxe, sqꞌuechojic cꞌotel ta pop jun jchiꞌiltic ta israelal, chꞌabal yip jun yoc scꞌob. Ti Jesuse iyil ti xchꞌunojic ti oy syuꞌele. ―Jchꞌamal, mu xavat avoꞌon. Acꞌbilot xa pertonal yuꞌun lamule ―xut ti jchamele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tey jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. “Li vinic liꞌi tspꞌis sba ta Riox”, xi ta yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ti Jesuse yiloj ti cꞌusi tsnopique. ―¿Cꞌu yuꞌun ti xꞌelan chanopique? ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ti xꞌelan icalbe li vinique ti “acꞌbilot xa pertonal yuꞌun lamule” xcute, muchꞌuuc noꞌox xuꞌ chal yech yuꞌun mu vocluc ta alel. Jaꞌ noꞌox yech mu vocluc ta alel ti “lican, xanavan” xichiotique. Pero jaꞌ tscꞌan chaqꞌuelic mi chcꞌot scꞌop ti muchꞌu yech chale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Li voꞌone ical ti acꞌbil xa pertonal yuꞌun smul li vinique. Pero qꞌuelic me cꞌusi ta jpas lavie yoꞌ xavilic o ti voꞌon noꞌox ta xcacꞌbe pertonal yuꞌun smulic li crixchanoetic liꞌ ta sba balamile, voꞌon ti coꞌol crixchanootique ―xꞌutatic yuꞌun ti Jesuse. ―Lican, tamo echꞌel lapope, batan ta ana ―xꞌutat yuꞌun Jesús ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ora ilic, ibat ta sna. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ti cꞌalal iyilic ti crixchanoetique, xchꞌayet xa yoꞌonic. ―Coliyal Riox ti acꞌbil syuꞌel li vinic liꞌi ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cꞌalal laj chanubtasvanuque, ibat ti Jesuse. Liyil ti tey chotolon ta jcꞌanbe li slocꞌ cꞌusiticuque. Mateo jbi. Laꞌ, batic ―xiyut ti Jesuse. Ora ba jchiꞌin. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tsꞌacal to libatoticotic ta jna xchiꞌuc ti Jesuse xchiꞌuc li yan jchiꞌiltac ta yajchancꞌope. Ep icꞌotic uc ti jchiꞌiltac toꞌox ta cꞌan-locꞌ-cꞌusiticuque xchiꞌuc ti muchꞌutic más chopol cꞌusitic tspasique. Jcotolticotic ijchol jbaticotic ta mexa. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tey icꞌotic jayvoꞌ jfariseoetic. Cꞌalal iyilic ti tsobol chiveꞌoticotic xchiꞌuc ti jchiꞌiltac toꞌox ta cꞌan-locꞌ-cꞌusiticuque, xchiꞌuc ti muchꞌutic más chopol cꞌusitic tspasique ―Lavajchanubtasvanejique ¿cꞌu yuꞌun ti tsobol chveꞌ xchiꞌuc li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li muchꞌutic más chopol cꞌusitic tspasique? ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ti Jesuse iyaꞌi ti cꞌusi iyalique. ―Ti muchꞌutic leque mu cꞌu stu yuꞌunic jpoxtavanej. Jaꞌ noꞌox ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ba nopbeic cꞌusi smelol ti jaꞌ yech yaloj ti Rioxe: “Jaꞌ ta jcꞌan ti chacꞌuxubinvanique, mu jaꞌuc noꞌox ti chamilbecon jmotone”, xi ti Rioxe. Li voꞌone maꞌuc tal jsaꞌ ti muchꞌutic chꞌabal smul ti yalojique. Jaꞌ tal jsaꞌ ti muchꞌutic oy smulique yoꞌ xictaic oe ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oy yajchancꞌoptac ti Juan jꞌacꞌ-ichꞌvoꞌe. Oy jayvoꞌ cꞌot sjacꞌbeic ti Jesuse: ―¿Cꞌu yuꞌun ti mu xicta yotic lavajchancꞌoptac voꞌote? Li voꞌoticotique xchiꞌuc li yajchancꞌoptac jfariseoetique ep ta echꞌel chquicta coticotic ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Itacꞌav ti Jesuse: ―Cꞌalal teyotic ta nupunele, cꞌalal tey jchiꞌinojtic li jnupunele, mu jaꞌuc o chcat coꞌontic. Jaꞌ noꞌox yech lavi liꞌto jchiꞌuc li cajchancꞌoptaque, mu xicta yotic, mu xat yoꞌonic. Jaꞌto chicta yotic ti cꞌalal ximilee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Muc muchꞌu tspacꞌan ta achꞌ manta li cꞌaꞌcꞌuꞌule yuꞌun tsmuts li achꞌe, chjat más li cꞌaꞌcꞌuꞌule. Jaꞌ noꞌox yech ti muchꞌutic ta xchꞌunic ti voꞌon noꞌox chcacꞌ cuxlicuc ta sbatel osile, achꞌ xa li cꞌusitic tspasique, mu xa spasic ti cꞌusitic ispasic toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jaꞌ chac cꞌu chaꞌal li achꞌ yaꞌlel uvae, muc muchꞌu ta xchꞌol ta pocoꞌ nuculal chivo. Ti mi ta xchꞌol ta pocoꞌ nucule, ti cꞌalal xvocane, ta xtꞌom li nucule. Yech noꞌox ta xmal. Yech noꞌox ta xchꞌay noxtoc li yave. Li achꞌ yaꞌlel uvae jaꞌ tscꞌan ti achꞌ yav chichꞌ chꞌolel oe yoꞌ lec xcom o xchiꞌuc li yave ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ti cꞌalal chloꞌilaj ti Jesuse, jaꞌo tey icꞌot jun jchiꞌiltic ta israelal, jmeltsanejcꞌop ta jun biqꞌuit templo. Isquejan sba ta yichon ti Jesuse, jaꞌo isnijan sba ta balamil noxtoc. ―Naca to icham jtseb. ¿Mi mu xaꞌabulaj xba avacꞌ acꞌob ta sba yoꞌ xchaꞌcuxi oe? ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ti Jesuse ibat xchiꞌuc. Libatoticotic uc, voꞌoticotic li yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Oy jun ants slajchebal xa jabil ti mu xmac xchamele. Inopoj ta spat ti Jesuse, ista ta picbel sne spimilcꞌuꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Acꞌu mi spimilcꞌuꞌ noꞌox jpicbe, ta xmac o li jchamele”, xi ta yoꞌon ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ti Jesuse ijoyij, isqꞌuel ti antse. ―Mu cꞌu xal avoꞌon. Yuꞌun achꞌunoj ti tsots jyuꞌele, yechꞌo ti ch-echꞌ lachamele ―xut. Ora imac ti xchamele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ti Jesuse icꞌot ta sna ti jmeltsanejcꞌope, iꞌoch. Iyil ti tey jꞌamareroetique, ti tey ch-ocꞌ ch-avanic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","―Locꞌanic to echꞌel. Li tsebe muc bu chamem, ta xvay noꞌox ―xi. Tseꞌej xaꞌi scotolic ti xꞌelan iyale yuꞌun snaꞌojic ti ichame. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ti Jesuse istac loqꞌuel scotol ti muchꞌutic teye, iꞌoch echꞌel yoꞌ bu telel ti ánimae, istsacbe scꞌob. Ora ichaꞌcuxi ti tsebe, ilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ora ivinaj ta sjunlej jlumaltic ti ixchaꞌcuxes tseb ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ibat noxtoc ti Jesuse. Tey napꞌalic echꞌel chaꞌvoꞌ jchiꞌiltic ta israelal, maꞌsatetic. Tsots iyaptaic ti Jesuse: ―Smom David, ¡cꞌuxubinoticotic! ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cꞌalal iꞌoch ta yut na ti Jesuse, ital ti chaꞌvoꞌ maꞌsate. ―¿Mi chachꞌunic ti xuꞌ ta jam lasatique? ―xꞌutatic yuꞌun ti Jesuse. ―Cajval, ta jchꞌunticotic ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ti Jesuse ispicbe sat xchaꞌvaꞌal. ―Lavi achꞌunojic ti xuꞌ chajambe lasatique, yechꞌo un jamuc ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ora ijam ti satique. ―Mu me muchꞌu xavalbeic ti lajambe lasatique ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero cꞌalal isutique, iyalic aꞌyuc ta sjunlej jlumaltic ti ijambat satic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ti cꞌalal jaꞌ toꞌox chloqꞌuic echꞌel ti chaꞌvoꞌ maꞌsate, yicꞌojic cꞌotel jun umaꞌ yoꞌ bu ti Jesuse, jchiꞌiltic noꞌox ta israelal. Ochem pucuj ta yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ti Jesuse isloqꞌuesbe ti pucuje. Ijam ye ti vinique. Xchꞌayet xa yoꞌonic ti crixchanoetique. ―¡Mi junuc jchiꞌiltic muc bu xquiltic yech tspas! ¡Sba to iquiltic o! ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cꞌalal iyilic ti jfariseoetique ―Li vinic liꞌi ta syuꞌel totil pucuj tsloqꞌues pucujetic ti ochem ta yoꞌonic li crixchanoetique ―xut sbaic, tslabanic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ti Jesuse ixanav ta scotol jteclumetic xchiꞌuc scotol parajeletic. Ichanubtasvan ta scotol bicꞌtal temploetic. Iyal aꞌyuc ti chlic xa pasvanuc ta mantal ti Rioxe. Cꞌusuc noꞌox chamelal ipic o ti crixchanoetique, iꞌetꞌesbatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tey tsobol ep crixchanoetic, abol sbaic iyil yuꞌun coꞌol xchiꞌuc chij ti chꞌabal xchabiele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","―Ta melel ti ep ti muchꞌutic tscꞌan chaꞌiic li scꞌop Rioxe; jaꞌ jutuc noꞌox ti muchꞌutic chalique. Coꞌol xchiꞌuc mi ep li cꞌajoje, jaꞌ jutuc noꞌox li jcꞌajome. ");
INSERT INTO tzoZNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yechꞌo un cꞌanbeic ti Rioxe ti acꞌu stac echꞌel ti muchꞌutic chba yalic aꞌyuc li cꞌusi yaloje yuꞌun jaꞌ tstꞌuj stuc ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jlajchavaꞌalticotic ti yajchancꞌopoticotic ti Jesuse, liyacꞌbe jyuꞌelticotic ti xuꞌ ta jloqꞌuesticotic pucujetic ta yoꞌonic li jchiꞌiltactique, ti xuꞌ chquetꞌesbeticotic xchamel ti muchꞌutic ipe, cꞌusuc noꞌox chamelal chaꞌiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Li jbiticotique jaꞌ liꞌi: Li muchꞌu baꞌyi itꞌujee Simón. Pedro li xchaꞌpꞌelel sbie. Xchiꞌuc Andrés, jaꞌ yitsꞌin li Pedroe. Xchiꞌuc Jacobo xchiꞌuc yitsꞌin Juan sbi, li scremotic Zebedeoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Xchiꞌuc Felipe, xchiꞌuc Bartolomé, xchiꞌuc Tomás, xchiꞌuc voꞌon li Mateo jbie ti jcꞌan-locꞌ-cꞌusiticucon toꞌoxe. Xchiꞌuc otro jun Jacobo screm Alfeo. Xchiꞌuc Lebeo, li Tadeo sbi noxtoque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xchiꞌuc Simón ti sticꞌoj sba ta partido cananeoe. Xchiꞌuc Judas Iscariote, jaꞌ ti iyacꞌ entrucal ta tsꞌacal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ti Jesuse listac echꞌel jlajchavaꞌalticotic. Lec lixchanubtasoticotic echꞌel. ―Mu me xabatic ta slumal li yan crixchanoetique, mi jaꞌuc ta slumal jsamariaetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tey noꞌox xabatic yoꞌ bu jchiꞌiltactic ta israelale, yuꞌun coꞌolic xchiꞌuc jchꞌayel chijetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba albeic ti ista xa yora tspasatic ta mantal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Etꞌesbeic xchamel ti muchꞌutic ipe. Chaꞌcuxesic ánimaetic. Etꞌesbeic xchamel ti muchꞌutic ip ta leprae. Loqꞌuesbeic pucujetic ta yoꞌonic. Ta matanal lacacꞌbe ayuꞌelic yechꞌo un ta matanal xavetꞌesbeic li xchamelique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mu me xavichꞌ echꞌel ataqꞌuinic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mu me xavichꞌ echꞌel aveꞌelic. Mu me xavichꞌ echꞌel chꞌaqꞌuex acꞌuꞌic. Mu me xavichꞌ echꞌel axonobic, mi jaꞌuc anamteꞌic. Jaꞌ chac cꞌu chaꞌal ti muchꞌutic chbat ta abtele tey tsta sveꞌelic, jaꞌ noꞌox yech tey chata aveꞌelic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ti bu chaꞌochique, mi ta jteclum, mi ta parajel, jaqꞌuic me ti muchꞌu lec scꞌoplale. Jaꞌ xachꞌamunbeic sna ti cꞌu sjalil teyoxuc ta jteclume o mi ta parajel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cꞌalal chaꞌochic ta snae, “acꞌu yacꞌboxuc bentisyon ti Rioxe”, xavutic cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi chayichꞌic ta mucꞌ ti cajchancꞌopoxuque, tstaic li bentisyone. Mi mu xayichꞌic ta muqꞌue, mu staic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi oy bu jteclumal ti mu xacꞌ ta chꞌom snaique, mi mu scꞌan xaꞌiic li cꞌusi chavalique, cꞌalal chaloqꞌuic teyoꞌe, xalilinic comel spucucal avoquic. Jaꞌ seña ti chcom ta sba stuquic ti mu xchꞌunic pasel ta mantal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta melel chacalbeic, ti cꞌalal sta yora chcalbe bu chbatic ta sbatel osil li crixchanoetique, más castico chichꞌic li jchiꞌiltactic ti bu mu xayotesique. Jaꞌ jutuc noꞌox castico chichꞌic ti jsodomaetique xchiꞌuc ti jgomorraetic ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Chajtaquic echꞌel chac cꞌu chaꞌal chijetic ti tey chcꞌot staic oqꞌuiletique, yuꞌun chcꞌot ataic jchiꞌiltactic ti yoꞌonicuc smiloxuque. Pꞌijanic me chac cꞌu chaꞌal quiletel chon. Lecuc me avoꞌonic chac cꞌu chaꞌal paloma. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pꞌijanic me yuꞌun oy muchꞌu chayiqꞌuic echꞌel ta stojol jmeltsanejcꞌopetic ta bicꞌtal temploetic yoꞌ bu chaꞌiic smantal Riox li jchiꞌiltactique. Chayacꞌbeic arsial li jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yuꞌun ti avichꞌojicon ta muqꞌue, oy chayiqꞌuic echꞌel ta stojol jyuꞌeletic yechꞌo un xuꞌ xavalbeic li cꞌusitic caloje. Tey chaꞌiic li muchꞌutic maꞌuc jchiꞌiltique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ti cꞌalal chaꞌaqꞌueic entrucale, mu me baꞌyiuc xanopic ti cꞌusi chcꞌot avalique, ti cꞌuxi chatacꞌavique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jaꞌ chaspꞌijubtasic cꞌuxi chatacꞌavic ti Chꞌul Espíritue ti jun xchiꞌuc ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Oy bu chacꞌ ta milel yitsꞌin, mi sbanquil. Oy bu chacꞌ ta milel xchꞌamal. Oy bu tscrontain stot smeꞌ, chaqꞌuic ta milel noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yuꞌun ti avichꞌojicon ta muqꞌue, mu scꞌan sqꞌuel asatic li crixchanoetique. Ti muchꞌutic chcuch yuꞌunic li ilbajinele, mi mu xicta o sbaique, jaꞌ chcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mi oy bu chataic ilbajinel ta jun jteclume, batanic ta yan o jteclum. Ta melel chacalbeic, ti cꞌalal xichaꞌsut tal voꞌon ti coꞌol crixchanootique, mu toꞌox bu lajem avalbeic jchiꞌiltactic ta scotol jteclumetic liꞌ ta jlumaltique ti cꞌusitic caloje. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Voꞌoxuc li cajchancꞌopoxuque, ti chatunic cuꞌune, mu me xanopic ti lec chayilic li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta onox xacrontainatic chac cꞌu chaꞌal chicrontainat voꞌon lavajchanubtasvanejicone, voꞌon lavajvalicone. Li voꞌone chispꞌisic ta pucuj li crixchanoetique. Mi jaꞌ xa li voꞌoxuque ti coꞌol xchiꞌuc jchꞌamaloxuque, más to chaspꞌisic ta pucuj. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Mu me xaxiꞌic o li crixchanoetique yuꞌun persa onox chaꞌiic ti cꞌusitic calojboxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jaꞌ avabtelic ti jamal chavalic aꞌyuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mu me xaxiꞌic o ti muchꞌutic yoꞌonicuc smiloxuque yuꞌun mu staic ta milel lachꞌulelique. Ti Rioxe ti jaꞌ xuꞌ chastiqꞌuic ta cꞌocꞌ xchiꞌuc achꞌulelique, jaꞌ me xavichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Li cꞌox mutetique, jnaꞌojtic ti toj yalem stojole pero xchabioj ti Jtotic Riox ta vinajele. Mu xcham mi maꞌuc yech tscꞌan ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jaꞌ noꞌox yech xchabiojoxuc uc. Cꞌalal ta stsatsal ajolic nitbil jaypꞌej. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yechꞌo un mu me xaxiꞌic. Yuꞌun más tsots acꞌoplalic yuꞌun ti Rioxe; jaꞌ jutuc noꞌox li mutetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Mi jamal chavalbeic crixchanoetic ti avichꞌojicon ta muqꞌue, jaꞌ noꞌox yech jamal chcalbe uc ti Jtot tey ta vinajele ti avichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yan mi mu jamluc chavalbeic crixchanoetic ti avichꞌojicon ta muqꞌue, jaꞌ noꞌox yech uc, chcalbe ti Jtote ti mu xavichꞌicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mu me xanopic ti tal jcoꞌoltasbe sjol li crixchanoetic liꞌ ta sba balamile. Ta xcrontainatic ti muchꞌutic chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Oy bu tscrontain o stot li creme. Oy bu tscrontain o smeꞌ li tsebe. Jaꞌ noꞌox yech li alibal uque oy bu tscrontain o yalib meꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Xaqꞌuel avilic mu nomuc chtal lacrontaique: ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ti muchꞌu mu xiyichꞌ o ta mucꞌ ti chiꞌ ta utel yuꞌun li stot smeꞌe, mu xuꞌ xixchiꞌin. Ti muchꞌu mu xiyichꞌ o ta mucꞌ yuꞌun chiꞌ mi xꞌilin li xchꞌamaltaque, mu xuꞌ xixchiꞌin noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ti muchꞌu mu scꞌan xacꞌ svocol chac cꞌu chaꞌal chcacꞌ jvocole, mu xuꞌ xixchiꞌin. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ti muchꞌu mu xiyichꞌ o ta mucꞌ ti jaꞌ chiꞌ o li milele, yuꞌun onox ta xꞌoch ta cꞌocꞌ ta sbatel. Yan ti muchꞌu muc ta alel yuꞌun mi jaꞌ xlaj oe, jaꞌ ta xcuxi ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ti muchꞌutic ta xchꞌunic li cꞌusitic caloje ti chavalic aꞌyuque, coꞌol xchiꞌuc voꞌon chixchꞌunbeic yaꞌel. Jaꞌ chchꞌunbeic yaꞌel ti Jtot uque yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ti muchꞌutic chichꞌic ta mucꞌ ti muchꞌu chal aꞌyuc li scꞌop Rioxe yuꞌun snaꞌojic ti chtun yuꞌun ti Rioxe, coꞌol chichꞌ smotonic xchiꞌuc ti muchꞌu chal aꞌyuc li scꞌop Rioxe. Ti muchꞌutic chichꞌic ta mucꞌ jun vinic yuꞌun snaꞌojic ti lec yoꞌone, coꞌol chichꞌ smotonic xchiꞌuc li muchꞌu lec yoꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta melel chacalbeic, ti muchꞌutic jaꞌ noꞌox chayacꞌbeic jbochuc voꞌe yuꞌun ti chilic ti chatunic cuꞌune, chichꞌ smotonic uc ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ti cꞌalal laj yalboticotic mantal jlajchavaꞌalticotic ti Jesuse, tsobol lilocꞌoticotic xchiꞌuc yuꞌun ba chanubtasvanuc. Ba yal aꞌyuc scꞌop Riox ta jlumalticotic ta estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti Juane tey tiqꞌuil ta chuquel. Iyaꞌi ti cꞌusitic tspas ti Cristoe, yechꞌo un istac echꞌel jayvoꞌ yajchancꞌoptac. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ti cꞌalal icꞌotique, iscꞌoponic ti Jesuse: ―Liꞌ listacoticotic tal li Juan jꞌacꞌ-ichꞌvoꞌe. Tal jacꞌboticotic mi voꞌot ti scꞌoplal chtal apasoticotic ta mantale, o mi ta to jmalaticotic otro jun ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","―Ba albeic li Juane li cꞌusitic ical avaꞌiique xchiꞌuc li cꞌusitic ijpas avilique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Li maꞌsatetique xil xa sbeic. Li coxoetique lec xa chanavic. Iꞌechꞌ xa xchamelic li muchꞌutic ip ta leprae. Ijam xa xchiquinic li pacꞌchiquinetique. Li muchꞌutic chamemic xaꞌoxe ijchaꞌcuxesic xa. Li meꞌonetique icalbe xa yaꞌiic ti oy cuxlejal ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mu me xicta sba li Juane, acꞌu yichꞌon o ta mucꞌ. Junuc me yoꞌon, xiyutoticotic tal li Jesuse”, xavutic cꞌotel li Juane ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ti cꞌalal isutic ti yajchancꞌoptac ti Juane, ti Jesuse lic yalbe crixchanoetic scꞌoplal ti Juane: ―Ti cꞌalal laꞌayic ta xocol balamile, maꞌuc puj ay aqꞌuelic ti xbat ta jot ta jot ta iqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yajꞌalcꞌop Riox ay aqꞌuelic. Avilic ti muc bu lec stsꞌacubtasoj sbae. Ti much utic stsꞌacubtasoj sbaique, ti mu cꞌu meꞌanal chaꞌiique, jaꞌ li preserenteetique yuꞌun jcꞌulejetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Li Juan ay aqꞌuelique maꞌuc yech. Pero más tsots yabtel chac cꞌu chaꞌal ti yan yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tsꞌibabil onox scꞌoplal ta scꞌop Riox li Juane ti jaꞌ chjelav tal cuꞌune. Baꞌyi ta jtac echꞌel mantal. Jaꞌ chalbe li crixchanoetique ti tey chacꞌote yoꞌ xaꞌichꞌe o ta muqꞌue, xiyut ti Jtote, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta melel chacalbeic, ta scotol li crixchanoetique muc muchꞌu más tsots yabtel chac cꞌu chaꞌal li Juan jꞌacꞌ-ichꞌvoꞌe. Pero ti muchꞌu ta xchꞌun pasel ta mantal yuꞌun ti Rioxe, acꞌu mi mu tsotsuc yabtel, más ch-acꞌbat yil cꞌu xꞌelan tspas mantal ti Rioxe. Jaꞌ mu sta yech ch-acꞌbat yil li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ti cꞌalal lic yal aꞌyuc li Juan jꞌacꞌ-ichꞌvoꞌe ti chlic xa pasvanuc ta mantal ti Rioxe, cꞌal tana, oy muchꞌutic sjunul yoꞌon ta xchꞌunic pasel ta mantal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ti cꞌalal mu toꞌox ta xtal li Juane, avaꞌyojic onox ti istsꞌiba comel ti Moisese xchiꞌuc ti yan yajꞌalcꞌoptac Riox ti ta más voꞌnee ti ta sta yora tspasvan ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mi chachꞌunic ti ista xa yora tspasvan ta mantal ti Rioxe, chul ta ajolic ti jaꞌ sqꞌuexol Elías li Juan liꞌ xae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Voꞌoxuc ti avaꞌiic cꞌusi icale, nopbeic smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Chacalbeic cꞌu xaꞌelanic, voꞌoxuc ti cuxuloxuc lavie. Caltic noꞌox yaꞌel ti oy cꞌoxetic tey chtajinic ta chꞌivite. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Li jlome iyalbeic li jayvoꞌ xchiꞌiltac ta tajimole: “Icoqꞌuesinticotic ama pero muc xaꞌacꞌotajic o. Limeꞌanajꞌocꞌoticotic pero muc xaꞌoqꞌuic noxtoc. Mu cꞌusi xacꞌanic”, xutic. Jaꞌ yechoxuc uc yuꞌun mu cꞌusi xacꞌanic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ti cꞌalal ital li Juane, muc xaxchiꞌinic ta veꞌel ta uchꞌvoꞌ pero chopol avaꞌiic. “Ochem pucuj ta yoꞌon”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ti cꞌalal lital voꞌon ti coꞌol crixchanootique, lajchiꞌinic ta veꞌel ta uchꞌvoꞌ pero chopol avaꞌiic noxtoc. “Qꞌuelavil, tol xveꞌ, tol xuchꞌ yaꞌlel uva”, xachiic. “Lec xil noxtoc li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li muchꞌutic chopol cꞌusitic tspasique”, xachiic. Ti spꞌijubtasojicoxuc ti Rioxe, avichꞌoticotic ta mucꞌ xchiꞌuc Juan ti yechuque. Jaꞌ chul o ta ajolic ti spꞌijubtasojoticotic ti Rioxe, yechꞌo ti ijpasticotic ti cꞌusitic ijpasticotique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ti Jesuse iyalbe scꞌoplal ti jchiꞌiltactic ta israelal ta jteclumetic yoꞌ bu iyacꞌulan iluc slequilal syuꞌelale yuꞌun muc xictaic spasel li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Li jchiꞌiltactic ta jteclum Corazine xchiꞌuc ta jteclum Betsaidae, iyilic jayꞌechꞌel ti oy jlequilal jyuꞌelale, pero muc xiyichꞌic o ta mucꞌ. Yechꞌo un ta onox xichꞌic castico ta sbatel osil. Ti jtiroetique xchiꞌuc ti jsidonetic ti ta más voꞌnee muc xilic li jlequilal jyuꞌelale. Ti iyilicuque, islapic jalbil tsatsal chivo ti chꞌixaltic ta lapele, isbon sbaic ta tanil tiꞌ cꞌocꞌ ti yechuque. Jaꞌ seña ti chat o yoꞌonic ti cꞌusitic chopol spasojique yuꞌun chictaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chacalbe avaꞌiic, ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, jaꞌ más castico chichꞌic li jchiꞌiltactic ta Corazine xchiꞌuc ta Betsaida lavie. Jaꞌ jutuc noꞌox castico chichꞌic ti jtiroetique xchiꞌuc ti jsidonetic ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Li jchiꞌiltactic ta Capernaume chalic ti jaꞌ chichꞌic crasiae, pero mu xꞌacꞌbatic. Yuꞌun iyilic jayꞌechꞌel ti oy jlequilal jyuꞌelale pero muc xiyichꞌic o ta mucꞌ. Yechꞌo un ta onox xichꞌic castico ta sbatel osil. Ti jsodomaetic ti ta más voꞌnee muc xilic li jlequilal jyuꞌelale. Ti iyilicuque, oy Sodoma cꞌal tana ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chacalbe avaꞌiic, ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, jaꞌ más castico chichꞌic li jchiꞌiltactic ta Capernaum lavie. Jaꞌ jutuc noꞌox castico chichꞌic ti jsodomaetic ti ta más voꞌnee ―xut jchiꞌiltactic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lic scꞌopon Riox ti Jesuse: ―Tot, voꞌot yajvalot vinajel balamil. Colaval ti muc xavacꞌ yaꞌibeic smelol cꞌusi ical, cꞌusi ijpas ti muchꞌutic pꞌij ti yalojique, ti jaꞌ noꞌox avacꞌ yaꞌibeic smelol ti muchꞌutic tscꞌanic coltael chac cꞌu chaꞌal tscꞌanic coltael li cꞌoxetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Lec ti jaꞌ yech apase, Tot ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ti Jesuse jaꞌ yech lic yalbe ti crixchanoetique: ―Ti Jtote yacꞌojbon entrucal scotol ti cꞌusitic oye. Muc muchꞌu snaꞌ cꞌu xꞌelan li coꞌone, jaꞌ noꞌox snaꞌoj ti Jtote. Jaꞌ noꞌox yech ti Jtot uque, muc muchꞌu snaꞌbe cꞌu xꞌelan yoꞌon. Jtuc noꞌox jnaꞌojbe. Jaꞌ noꞌox ta snaꞌic uc ti muchꞌutic chcalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Voꞌoxuc ti iꞌechꞌ xa avoꞌonic ta saꞌel ti cꞌuxi chacuxiic ta sbatel osile, chꞌunic ti voꞌon chcacꞌ acuxlejalic ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ichꞌicon me ta mucꞌ. Jaꞌ chanic cꞌu xꞌelan li coꞌone yuꞌun lec coꞌon, mu jnaꞌ jtoy jba. Ti mi jaꞌ yech chapasique, chacuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ti mi chavichꞌicon ta muqꞌue, mu vocluc tspas avuꞌunic cꞌusi lec chil ti Rioxe ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ti jꞌechꞌele tey liꞌechꞌoticotic ta be ta trigoaltic xchiꞌuc ti Jesuse. Jaꞌo scꞌacꞌalil ta jcuxtic. Liviꞌnajoticotic, voꞌoticotic li yajchancꞌopoticotique. Ijcꞌasticotic jaychev trigo, ijuꞌ jcꞌuxticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Liyiloticotic jayvoꞌ jfariseoetic. ―Qꞌuelavil lavajchancꞌoptaque, tspasic ti cꞌusi mu xuꞌ jpastic ta scꞌacꞌalil ta jcuxtique ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","―¿Mi muc bu aqꞌuelojic yaꞌel ta scꞌop Riox ti cꞌusi ispas ti Davide cꞌalal iviꞌnaj xchiꞌuc ti xchiꞌiltac ta xanvile? ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tey icꞌotic ta templo. Ti Davide jaꞌ iscꞌan sveꞌ ti pan ta ba mexae ti smotoninoj ti Rioxe. Acꞌu mi yaloj ti Rioxe ti jaꞌ noꞌox tsveꞌic li paleetique, pero isveꞌic xchiꞌuc xchiꞌiltac ti Davide. Pero muc bu ista o smul uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Mi muc bu aqꞌuelojic yaꞌel cꞌusi istsꞌiba ti Moisese yoꞌ bu chal ti ch-abtejic onox ta mucꞌta templo li paleetic ta scꞌacꞌalil ta jcuxtique? Pero mu sta o smulic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Li paleetique xuꞌ xꞌabtejic ta mucꞌta templo cꞌalal jaꞌo scꞌacꞌalil ta jcuxtique. Jaꞌ noꞌox yech xuꞌ scꞌas scꞌuxic jaychevuc trigo li cajchancꞌoptaque. Li voꞌone más tsots cabtel chac cꞌu chaꞌal li paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ti Rioxe yaloj ti jaꞌ tscꞌan ti chicꞌuxubinvanotique, ti mu jaꞌuc noꞌox ti chichꞌ milbel smotone. Ti avaꞌibeicuc smelole, muc xaticꞌbeic smul ti muchꞌutic chꞌabal smulique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Voꞌon ti coꞌol crixchanootique, voꞌon yajvalon li scꞌacꞌalil ta jcuxtique. Voꞌon chcal ti cꞌusi xuꞌ jpastique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tsꞌacal to licꞌototicotic ta stemploic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tey jun jchiꞌiltic smochꞌoj sba sniꞌtac jun scꞌob. Tey jayvoꞌ jfariseoetic. ―¿Mi xuꞌ chichꞌ etꞌesbel xchamel ta scꞌacꞌalil ta jcuxtic ti muchꞌu ipe? ―xutic ti Jesuse yoꞌ stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","―Li voꞌoxuque, mi oy bu ipꞌaj ta chꞌen jcotuc achij ti cꞌalal jaꞌo ta jcuxtique, ¿mi muc bu chba aloqꞌuesic yaꞌel? ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Li jcot chije mu masuc tsots scꞌoplal. Jaꞌ más tsots scꞌoplal li jun crixchanoe. Yechꞌo un xuꞌ jpastic cꞌusi lec ta scꞌacꞌalil ta jcuxtique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","―Tuqꞌuibtaso li sniꞌtac acꞌobe ―xꞌutat yuꞌun Jesús ti vinique. Istuqꞌuibtas ti sniꞌtac scꞌobe, lec xa icom chac cꞌu chaꞌal ti jun scꞌobe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ti jfariseoetique iloqꞌuic echꞌel, ba snopic cꞌuxi tstaic ta milel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ti Jesuse snaꞌoj ti cꞌusi tsnopique, yechꞌo un ixchꞌac sba loqꞌuel. Ichiꞌinat echꞌel yuꞌun ep crixchanoetic. Iyetꞌesbe xchamel ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tsots iyalbe ti jchameletique: ―Mu me xavinajesic jcꞌoplal ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jaꞌ icꞌot ti iyal onox ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee ti jaꞌ ta xetꞌes chamel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Qꞌuelavil ti muchꞌu jtꞌujoj ti chtun cuꞌune. Jcꞌanoj tajmec, jun coꞌon yuꞌun. Chcacꞌbe xchiꞌin ti Chꞌul Espíritue ti junon jchiꞌuque. Cacꞌojbe yabtel ti xuꞌ tslecubtasbe yoꞌonic uc li muchꞌutic maꞌuc achiꞌilique yoꞌ xcuxiic o ta sbatel osil uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mu sliques cꞌop, mu stoyojuc sba xcꞌopoj yoꞌ xꞌichꞌe o ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Muc bu tspꞌaj ti muchꞌutic mu cꞌu stu chaꞌi sbaique, ti coꞌolic xchiꞌuc vochꞌem aje, ti coꞌolic xchiꞌuc bu mu xtil lec jcastique. Ti muchꞌutic yech chaꞌi sbaique ta spatbe yoꞌonic, ta xacꞌ cuxlicuc ta sbatel osil yoꞌ mu xba yichꞌic o casticoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jaꞌ chilic o li muchꞌutic maꞌuc achiꞌilique ti xuꞌ chcuxiic ta sbatel osil uque, xi ti Rioxe, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yicꞌojic cꞌotel jun jchiꞌiltic ochem pucuj ta yoꞌon. Maꞌsat ti vinique, umaꞌ noxtoc. Ti Jesuse isloqꞌuesbe ti pucuj ta yoꞌone. Ijam sat, ijam ye. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Xchꞌayet xa yoꞌonic ti crixchanoetique. ―Jaꞌ nan li smom Davide ti scꞌoplal onox chispasotic ta mantale ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cꞌalal iyaꞌiic ti jfariseoetique ―Li vinic leꞌe ta syuꞌel totil pucuj ti tsloqꞌues pucujetic ti ochem ta yoꞌonic li crixchanoetique ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ti Jesuse yiloj onox ti cꞌusi tsnopique. ―Mi tscrontain sbaic jun preserente xchiꞌuc li xchiꞌiltac ta meltsanejcꞌope, ta xchꞌac o sbaic. Mi chut sbaic li jchop jnaclomale, mi chut sbaic li yajvaltac jteclume, ta xchꞌac o sbaic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaꞌ noꞌox yech ti Satanase, mi tsloqꞌues xchiꞌil ta pucujal ti ochem ta yoꞌonic li crixchanoetique, ¿cꞌu ma xi tspas mantal ti mi yech tspase? ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ti xꞌelan chacalbeique, yuꞌun chavalic ti ta syuꞌel totil pucuj ti ta jloqꞌues ti pucujetique. Ti yechuc xavalique, ¿muchꞌu ma ta syuꞌel ta sloqꞌuesic pucujetic lavajchancꞌopic uque? Lavajchancꞌopique xuꞌ chalic ti maꞌuc yech li cꞌusi chavalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Li voꞌone ta syuꞌel Chꞌul Espíritu ti jun xchiꞌuc ti Rioxe ti ta jloqꞌues pucujetique, jaꞌ chvinaj o ti liꞌ xa tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Caltic noꞌox yaꞌel ti oy muchꞌu yoꞌonuc ochuc ta sna jun tsatsal vinique ti yoꞌonuc yelcꞌanbe li cꞌusuc yuꞌune. ¿Mi maꞌuc tscꞌan ti baꞌyi ta xchuc li vinique yoꞌ xcuch o yuꞌun yelcꞌanbel li cꞌusuc yuꞌune? Ti Satanase coꞌol xchiꞌuc tsatsal vinic yaꞌel. Li voꞌone icuch xa cuꞌun spojbel li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ti muchꞌu chopol chil li cꞌusi ta jpase, jaꞌ jcronta. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Chacalbeic, ti muchꞌutic chopol li cꞌusitic tspasique, mi tspꞌisic ta pucuj ti Rioxe, ch-aqꞌueic to ta pertonal mi tscꞌanbeique. Jaꞌ noꞌox ti muchꞌutic tspꞌisic ta syuꞌel pucuj ti Chꞌul Espíritue, mu xa xꞌaqꞌueic o ta pertonal ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ti muchꞌutic chispꞌisic ta pucuj, voꞌon ti coꞌol crixchanootique, ch-aqꞌueic to ta pertonal mi tscꞌanbeic ti Rioxe. Jaꞌ noꞌox ti muchꞌutic tspꞌisic ta syuꞌel pucuj ti Chꞌul Espíritue, mu xa xꞌaqꞌueic o ta pertonal ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ti bu onox lec li teꞌel loꞌbole, lec li sate. Ti bu onox chopole, chopol li sate. Yechꞌo un nopic lec cꞌu xꞌelan atsꞌunbalic ti chopol chavilicone, yuꞌun naca lec li cꞌusitic ta jpase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Li voꞌoxuque jaꞌ achiꞌilic li quiletel chone yuꞌun chopol ajolic. Yechꞌo ti chopol chacꞌopojique. Ti cꞌusi chanopique, jaꞌ yech chlocꞌ ta aveic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ti muchꞌu lec yoꞌone lec li cꞌusi chlocꞌ ta yee yuꞌun lec ti cꞌusi tsnope. Ti muchꞌu chopol li cꞌusi tsnope, chopol li cꞌusi chlocꞌ ta yee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chacalbeic noxtoc, ti jayꞌechꞌel chopol cꞌusi avalbeic lachiꞌilique, jaꞌ yech chavichꞌic o castico ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mi lec cꞌusi ilocꞌ ta aveic liꞌ ta sba balamile, chꞌabal amulic chayilic ti Rioxe. Mi chopole, chavichꞌic castico ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tey jayvoꞌ jfariseoetic xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ―Jchanubtasvanej, acꞌo quilticotic ayuꞌel yoꞌ jchꞌunticotic o ti stacojot tal ti Rioxe ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","―Voꞌoxuc ti cuxuloxuc lavie, chopol ajolic. Yuꞌun jaꞌ noꞌox chacꞌan chaqꞌuelic li jyuꞌele pero muc bu chcacꞌ avilic. Jaꞌ noꞌox chavaꞌibecon jcꞌoplal chac cꞌu chaꞌal avaꞌibeic scꞌoplal ti Jonas yajꞌalcꞌop Riox ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ti Jonase oxib cꞌacꞌal xchiꞌuc oxib acꞌubal tey tiqꞌuil ta yut xchꞌut mucꞌta choy. Jaꞌ noꞌox yech li voꞌon uque, ti cꞌalal ximilee, oxib cꞌacꞌal xchiꞌuc oxib acꞌubal muculon, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, más castico chavichꞌic, voꞌoxuc ti cuxuloxuc lavie. Jaꞌ jutuc noꞌox castico chichꞌic ti jníniveetic ti ta más voꞌnee. Yuꞌun iyictaic spasel li cꞌusitic chopole ti cꞌalal iꞌalbatic scꞌop Riox yuꞌun ti Jonase. Li voꞌone más tsots cabtel chac cꞌu chaꞌal ti Jonase, pero mu xacꞌan xachꞌunic li cꞌusitic chacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, más castico chavichꞌic, voꞌoxuc ti cuxuloxuc lavie. Jaꞌ jutuc noꞌox castico chichꞌ ti ants preserentee ti nom ilic tal ta xocon vinajel ta sure, ti tal yaꞌibe srazón ti preserente Salomone. Li voꞌone más to jnaꞌ razón chac cꞌu chaꞌal ti Salomone pero mu xacꞌan xachꞌunic li cꞌusitic chacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ti cꞌalal chlocꞌ ta yoꞌon jun crixchano ti pucuje, chbat ta xocol balamil, chba saꞌ bu chnaqui, pero mu sta. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Más lec chisut echꞌel ta yoꞌon li vinique”, xi ti pucuje. Ti cꞌalal chcꞌote, leclectic chcꞌot sta li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yechꞌo un ti pucuje chba saꞌ tal vucvoꞌ xchiꞌil, jaꞌ ti bu chopol tajmeque. Tey ch-ochic ta yoꞌon li vinique, más to tsoc sjol tajmec. Jaꞌ noꞌox yech chachaꞌleatic uc, voꞌoxuc ti chavaꞌiic ti cꞌusi chcale, mi mu xavichꞌicon ta muqꞌue ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cꞌalal tey chloꞌilaj ta yut na ti Jesuse, jaꞌo icꞌotic ta tiꞌna ti smeꞌe xchiꞌuc yitsꞌintac yuꞌun chac scꞌoponic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oy muchꞌu iꞌalbon ti Jesuse: ―Tey ta tiꞌna ameꞌ xchiꞌuc avitsꞌintac yuꞌun la tscꞌan chascꞌopon ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","―Chcal avaꞌi ti muchꞌutic coꞌol xchiꞌuc jmeꞌe, ti coꞌol xchiꞌuc quitsꞌintaque ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ti Jesuse lisbichcꞌobtaoticotic, voꞌoticotic li yajchancꞌopoticotique. ―Li jayvoꞌ liꞌi jaꞌ coꞌol xchiꞌuc jmeꞌ, jaꞌ coꞌol xchiꞌuc quitsꞌintac yaꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Scotol ti muchꞌutic jaꞌ tspasic cꞌusi tscꞌan ti Jtotic Riox ta vinajele, jaꞌ coꞌol xchiꞌuc jmeꞌ, coꞌol xchiꞌuc quitsꞌintac, coꞌol xchiꞌuc quixleltac yaꞌel ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti Jesuse ilocꞌ ta na, tey ba chotluc ta tiꞌnab. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ep tajmec jchiꞌiltactic istsob sbaic echꞌel. Ti Jesuse iꞌoch chotluc ta canova, tey xcajet ta ba voꞌ. Li jchiꞌiltactique tey lamal ta tiꞌnab. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ti Jesuse lic scꞌopon. Ep cꞌusitic iyal ta loꞌil. ―Caltic noꞌox yaꞌel ti oy jun vinic ba svaj strigoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ti cꞌalal isvaje, oy jlom ta be icꞌot. Ital mutetic, istam. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oy jlom ta tontic icꞌot ti bu chꞌabal lec slumale. Ora ivocꞌ yuꞌun muc bu pim slumal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Cꞌalal iqꞌuepe, icꞌanub, itaquij, yuꞌun chꞌabal lec yisim. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oy jlom ta chꞌixtic icꞌot. Ti cꞌalal ichꞌi li chꞌixe, iyolontaj li trigoe, jaꞌ ichꞌajub o. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oy jlom ta lequil balamil icꞌot. Lec ichꞌi, ibeqꞌuin. Oy iyacꞌ cien, oy iyacꞌ oxvinic (60), oy iyacꞌ lajuneb xchaꞌvinic (30). ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Voꞌoxuc ti avaꞌiic ti cꞌusi icale, nopbeic smelol ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Voꞌoticotic li yajchancꞌopoticotique, cꞌalal jtucticotic xa xchiꞌuc ti Jesuse ―¿Cꞌu yuꞌun ti mu jamluc xavalbe li jchiꞌiltactique? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","―Li voꞌoxuque jamal lacalbeic cꞌu xꞌelan tspas ta mantal crixchanoetic ti Rioxe. Li yantique mu jamluc chcalbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ti muchꞌutic sjunul yoꞌon ta xchꞌunique, más ta xpꞌijubtasatic yuꞌun ti Rioxe yoꞌ xchꞌunic o leque, yuꞌun tscꞌan ta xchꞌunic. Yan ti muchꞌutic mu sjunuluc yoꞌon ta xchꞌunique, ti jaypꞌel snaꞌique ta xpojbatic ta jmoj. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yechꞌo ti ta loꞌil noꞌox chcalbeique. Yuꞌun ep ta echꞌel iyilic ti oy jlequilal jyuꞌelale, pero coꞌol xchiꞌuc muc xilic. Ep ta echꞌel iyaꞌiic ti cꞌusi icale, pero muc xaꞌibeic smelol yuꞌun stoyoj sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jaꞌ icꞌot ti cꞌusi istsꞌiba ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee: Ep to ta echꞌel chaꞌiic lachiꞌiltaque, pero mu xaꞌibeic smelol. Ep to ta echꞌel chilic, pero coꞌol xchiꞌuc mu xilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yuꞌun stoyoj sbaic. Yuꞌun mu xictaic spasel li cꞌusitic chopole, yechꞌo ti mu xcacꞌ cuxlicuc ta sbatel osile, xi ti Rioxe, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Li voꞌoxuque layacꞌbeic xa bentisyon ti Rioxe yechꞌo ti avilic xa li cꞌusitic ijpase, avaꞌiic xa li cꞌusitic icale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta melel chacalbeic, ep yajꞌalcꞌoptac Riox xchiꞌuc ep ti muchꞌutic lec yoꞌonic ti ta más voꞌnee ti tscꞌan ox tsqꞌuelic ti cꞌusitic ta jpase, pero muc xa xilic. Tscꞌan ox chaꞌiic ti cꞌusitic chcale, pero muc xa xaꞌiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Aꞌibeic cꞌusi smelol ti liloꞌilaj ta scuenta jvajtrigoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jlom mu xaꞌibeic smelol ti tscꞌan tspasatic ta mantal yuꞌun ti Rioxe. Ta xtal ta ora ti pucuje, chtal chꞌaybatuc ta sjolic li scꞌop Rioxe. Jaꞌ yech smelol li becꞌ trigo ti icꞌot ta bee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Li becꞌ trigo ti icꞌot ta tontique, jaꞌ seña ti muchꞌutic cꞌalal chaꞌiic li scꞌop Rioxe, ora ta xchꞌunic, jun xa yoꞌonic yilel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero mu sjunuluc yoꞌon ta xchꞌunic. Ti cꞌalal xꞌilbajinatique, ora chicta sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Li becꞌ trigo ti icꞌot ta chꞌixtique, jaꞌ seña ti muchꞌutic yaꞌyojic xa li scꞌop Rioxe, pero jaꞌ noꞌox ta yoꞌonic li cꞌusitic oy ta sba balamile. Jaꞌ chloꞌloatic o. Jaꞌ yolontabil chcom yaꞌel li scꞌop Rioxe yuꞌun mu jꞌechꞌeluc ta xchꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Li becꞌ trigo ti icꞌot ta lequil balamile, ti iyacꞌ ciene, ti iyacꞌ oxvinique (60), ti iyacꞌ lajuneb xchaꞌvinique (30), jaꞌ seña ti muchꞌutic jꞌechꞌel ta xchꞌunic li scꞌop Rioxe, ti lec xaꞌibeic smelole. Coꞌol xchiꞌuc chbeqꞌuin yaꞌel yuꞌun chalic aꞌyuc li scꞌop Rioxe. Acꞌu mi ch-ilbajinatic, mu xicta o sbaic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ti Jesuse iyalbe jun loꞌil noxtoc li jchiꞌiltactique. ―Chacalbe avaꞌiic cꞌu xꞌelan tspasatic ta mantal ti muchꞌutic chichꞌic ta mucꞌ ti Rioxe. Caltic noꞌox yaꞌel ti oy jun vinic ti ba svaj strigo ta yosile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cꞌalal vayem xa scotolique, ital scronta. Tal svaj jobel yoꞌ bu svajoj strigo li vinique. Ti cꞌalal laj svaj jobel li scrontae, ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ichꞌi li trigoe, ibeqꞌuin. Jaꞌto ivinaj li jobele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Totic, ¿mi mu nacauc trigo avaj ta avosile? Iquilticotic nax ti capal ta jobele”, xiic li smozotaque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Taje jcronta isvaj”, xi. “¿Mi chba jbulticotic li jobele?”, xiic li smozotaque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mu yaꞌuc ba abulic naca me capluc abulic loqꞌuel li jtrigoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tey acꞌu chꞌiuc xchaꞌtosol. Cꞌalal sta yora chichꞌ loqꞌuele, cꞌalal yolel sloqꞌuele, tꞌujic loqꞌuel baꞌyuc li jobele, chuquic yuꞌun chachiqꞌuic. Tsꞌacal to xaloqꞌuic li trigoe, xamajic, xachꞌolic ta stenal, ta xcutic li jlocꞌtrigoetique”, xut smozotac li yajval osile ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ti Jesuse iyal jun loꞌil noxtoc: ―Chacalbe avaꞌiic noxtoc cꞌu xꞌelan tspasvan ta mantal ti Rioxe. Acꞌu mi muc bu ep lavie pero ta to xpꞌolic. Coꞌol xchiꞌuc becꞌ mustisya ti istsꞌun ta yosil jun vinic ti toyol ibate. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Li becꞌ mustisyae más biqꞌuit chac cꞌu chaꞌal sbecꞌ yan tsꞌunubiletic. Pero cꞌalal xchꞌie, más toyol chbat. Chtal mutetic, tey tspas stsoꞌopic ta scꞌobcꞌobtac ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ti Jesuse iyal jun loꞌil noxtoc: ―Chacalbe avaꞌiic cꞌu xꞌelan tspasvan ta mantal ti Rioxe. Oy syuꞌel, xuꞌ tslecubtas o avoꞌonic yoꞌ xapasic o li cꞌusitic leque. Coꞌol xchiꞌuc li svuquesobil xchꞌut pane. Acꞌu mi jsetꞌ noꞌox xacꞌbe svuquesobil xchꞌut vucub teꞌ arina li antse, pero ta xvuc o xchꞌut scotol ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ti Jesuse naca ta loꞌil iyalbe li jchiꞌiltactique pero oy smelol ti cꞌusitic iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yuꞌun jaꞌ icꞌot ti cꞌusi iyal ti yajꞌalcꞌoptac Riox ti ta voꞌnee. Naca ta loꞌil chalbe li crixchanoetique. Li cꞌusitic chale muc bu xcaꞌitic o yech ta spasel balamil, xi onox tsꞌibabil ta scꞌop Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ti Jesuse iscꞌopon comel li jchiꞌiltactique, iꞌoch ta yut na. Liꞌochoticotic uc, voꞌoticotic li yajchancꞌopoticotique. ―Alo caꞌiticotic cꞌusi smelol li loꞌil scuenta jobel avale ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","―Li jvajtrigoe, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Li cosile jaꞌ sjunlej li balamile. Li trigoe jaꞌ ti muchꞌutic ta xchꞌunic cꞌusi lec chil ti Rioxe. Li jobele jaꞌ ti muchꞌutic chopol cꞌusitic tspasique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Li jcronta ti isvaj jobele, jaꞌ ti totil pucuje. Ti yora chichꞌ loqꞌuele, jaꞌo cꞌalal xlaj li balamile. Li jlocꞌtrigoetique jaꞌ ti anjeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ti cꞌu xꞌelan istsobic ti jobele, ti ixchiqꞌuique, jaꞌ yech chcꞌot cꞌalal xlaj li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Voꞌon ti coꞌol crixchanootique, ta jtac tal cajꞌanjeltac. Jaꞌ chtal stsobic ti muchꞌutic tsocbe sjol li xchiꞌile xchiꞌuc scotol ti muchꞌutic chopol cꞌusitic tspasique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tstenic ochel ta cꞌocꞌ. Tey xꞌoqꞌueletic, xcꞌuxuxet o yeic yuꞌun tsots castico chichꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yan ti muchꞌutic lec yoꞌonique ch-acꞌbat xojobalic cꞌalal teyic xa yoꞌ bu tspas mantal ti Jtotic Riox ta vinajele, yuꞌun jaꞌ xchꞌamaltac. Ti xojobalique coꞌol xchiꞌuc xojobal cꞌacꞌal. Voꞌoxuc ti avaꞌiic cꞌusi icale, nopbeic smelol ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ti Jesuse iyal jun loꞌil noxtoc: ―Mi sjunul avoꞌon chachꞌunic pasel ta mantal yuꞌun ti Rioxe, mu xa cꞌusi palta chavaꞌiic, xamuyubajic xa tajmec. Coꞌol xchiꞌuc jun vinic ti mucul ista epal taqꞌuin ta jsetꞌ osile. Xmuyubaj xa tajmec. Tey noꞌox ixchaꞌmuc comel, jaꞌ ba xchon scotol li cꞌusuc yuꞌune, jaꞌ isman li jsetꞌ osil yoꞌ bu mucul li taqꞌuine ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ti Jesuse iyal jun loꞌil noxtoc: ―Mi sjunul avoꞌon chachꞌunic pasel ta mantal yuꞌun ti Rioxe, xamuyubajic tajmec. Coꞌol xchiꞌuc jun jmanolajel ti tscꞌan tsman perlaetic ti toyol stojole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cꞌalal iyil jpꞌej ti leclec sbae, xmuyubaj xa tajmec. Ba xchon scotol li cꞌusuc yuꞌune, jaꞌ isman ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ti Jesuse iyal jun loꞌil noxtoc: ―Chcal avaꞌiic cꞌu xꞌelan tspas mantal ti Rioxe. Ti Rioxe coꞌol xchiꞌuc jtsac-choyetic yaꞌel ti sjipojic ta nab snutiꞌique ti ep tajmec choy ocheme. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Li jtsac-choyetique, mi inoj li snutiꞌique, ta snitic loqꞌuel ta tiꞌ nab, ta stꞌujic li choye. Ti bu leque chaqꞌuic ta moch. Ti bu chopole ta stenic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jaꞌ yech tspas ti Rioxe ti cꞌalal xlaj li balamile. Ta stac tal ti anjeletique, chtal stꞌujic li crixchanoetique. Slecoj chaqꞌuic ti muchꞌutic chopol sjolique, slecoj chaqꞌuic ti muchꞌutic lec yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ti muchꞌutic chopol sjolique chteneic ochel ta cꞌocꞌ. Tey xꞌoqꞌueletic, xcꞌuxuxet o yeic yuꞌun tsots castico chichꞌic ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","―¿Mi avaꞌibeic smelol scotol ti cꞌusitic icale? ―xiyutoticotic ti Jesuse. ―Cajval, icaꞌiticotic ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","―Ti avaꞌibeic xa smelole, coꞌoloxuc xchiꞌuc jun vinic yaꞌel ti oy scotol cꞌusi chtun yuꞌune. Yuꞌun jaꞌ iyichꞌ comel ti cꞌusuc yuꞌun ti ánima stote. Oy onox cꞌusuc yuꞌun uc. Yechꞌo un oy scotol ti cꞌusi chtun yuꞌune. Jaꞌ noꞌox yechoxuc uc, avaꞌyojic ti cꞌusitic iꞌalbatic yuꞌun Riox ti voꞌne moletique xchiꞌuc ti cꞌusitic jaꞌ to lacalbeique. Yechꞌo un xuꞌ chavalic aꞌyuc cꞌu xꞌelan tspasvan ta mantal ti Rioxe ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ti cꞌalal laj loꞌilajuc ti Jesuse, ilocꞌ teyoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ibat ta steclumal ta Nazaret. Iꞌoch ta templo teyoꞌe, tey ichanubtasvan. Ti muchꞌutic iyaꞌiique xchꞌayet xa yoꞌonic. ―¿Bu ista spꞌijil li jchiꞌiltic leꞌe ti naca lec li cꞌusi chale? ¿Bu ista syuꞌel ti scotol cꞌusi xuꞌ tspase? ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pero jaꞌ screm li carpinteroe, jaꞌ yol li Maríae. Jaꞌ sbanquilic li Jacoboe, xchiꞌuc li Josee, xchiꞌuc li Simone, xchiꞌuc li Judase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jaꞌ xibnelic noxtoc li antsetic ti liꞌ nacajtic jchiꞌuctique. ¿Bu ixchan scotol ti xꞌelan tspase? ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Muc xchꞌunic ti jaꞌ stacoj tal ti Rioxe. ―Ti muchꞌutic chalic aꞌyuc li scꞌop Rioxe, mi chbatic ta yan o jteclume, ch-ichꞌbatic ta mucꞌ. Yan ta steclumal stuquique xchiꞌuc ta snaique, mu xꞌichꞌbatic ta mucꞌ ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta steclumal ti Jesuse muc bu ep iyacꞌ iluc slequilal syuꞌelal, jaꞌ ti muc xchꞌunic ti tacbil tal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti covierno Erodese iyaꞌi ti ep cꞌusitic tspas ti Jesuse yuꞌun vinajem scꞌoplal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","―Taje jaꞌ nan ti Juan jꞌacꞌ-ichꞌvoꞌe. Yuꞌun nan ichaꞌcuxi, yechꞌo ti oy syuꞌele ―xut ti xchiꞌiltac tey ta opisinae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jaꞌ ta smantal ti Erodese ti itsac ti Juane, ti ichuque ta carina ta yut chuclebale yoꞌ mu xtae o ta milel yuꞌun ti yajnil toꞌox yitsꞌine. Erodías sbi ti antse. Felipe sbi ti yitsꞌine. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","―Maꞌuc yech chal li leye ti apojbe yajnil lavitsꞌine ―xꞌutat yuꞌun Juan ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ti Erodese yoꞌonuc smil ti Juane pero ixiꞌ o toꞌox ti jchiꞌiltactic ta israelale, yuꞌun xchꞌunojic ti jaꞌ yajꞌalcꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tsꞌacal to cꞌalal ilocꞌ sjabilal ti Erodese, ispas sqꞌuinal. Ti stseb Erodíase iꞌacꞌotaj. Ti cꞌu xꞌelan iꞌacꞌotaje, lec iyil ti Erodese xchiꞌuc ti muchꞌutic tey tsobolique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","―Cꞌanbon ti cꞌusi chacꞌane, lojriox chacacꞌbe ―xut tseb ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ti tsebe ba sjacꞌbe smeꞌ ti cꞌusi tscꞌanbe ti Erodese. Cꞌalal iꞌalbat ti cꞌusi tscꞌane, ba yalbe ti Erodese: ―Jaꞌ acꞌbon tal ta plato sjol li Juan jꞌacꞌ-ichꞌvoꞌe ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ti Erodese iyat yoꞌon. Ta scoj ti isvaꞌan ta rextico ti Rioxe, xchiꞌuc ti yaꞌyojic ti muchꞌutic tey xchiꞌuc ta mexae, yechꞌo un iyal ti xuꞌ chichꞌbe sjol ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jaꞌo istac echꞌel yajsolterotac ti acꞌu ba stuchꞌbeic tal sjol ti Juan ta chuclebale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ispachbeic tal ta plato, iyacꞌbeic ti tsebe. Ti tsebe ba yacꞌbe smeꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Icꞌot yajchancꞌoptac ti Juane, ay sloqꞌuesic, ba smuquic. Ba yalbeic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ti Jesuse iyaꞌi ti ipꞌise ta Juan yuꞌun ti Erodese, iꞌoch echꞌel ta canova, ibat ta xocol balamil. Cꞌalal iyaꞌiic ti jchiꞌiltactic ta israelale ti ibat xa ti Jesuse, oy jayib jteclum iloqꞌuic echꞌel, ba staic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ti cꞌalal lilocꞌoticotic ta canovae, tey xa tsobol ep crixchanoetic cꞌot jtaticotic. Ti Jesuse iscꞌuxubin, iyetꞌesbe xchamel ti jchameletic tey capalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cꞌalal ch-icꞌub xaꞌox osile ―Liꞌtoe xocol balamil. Imal xa cꞌacꞌal noxtoc. Más lec taco echꞌel li crixchanoetique, acꞌu ba sman sveꞌelic ta naetic ―xcuticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","―Mu persauc xbatic. Macꞌlinic voꞌoxuc ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","―Mu cꞌusi oy cuꞌunticotic. Cꞌajom noꞌox voꞌpꞌej pan xchiꞌuc chaꞌcot choy liꞌ quichꞌojticotique ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","―Ichꞌic tal ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ti Jesuse iyalbe ti jchiꞌiltactique ti acꞌu chotlicuc ta stentejtique. Ixchꞌam ti voꞌpꞌej pane xchiꞌuc ti chaꞌcot choye, isqꞌuel vinajel, “colaval” xut ti Rioxe. Jaꞌo ixut ti pane, ixchꞌac noxtoc ti choye. Liyacꞌboticotic. Voꞌoticotic xa icacꞌbeticotic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iveꞌ scotolic, lec inojic. Ijtsobticotic ti pane xchiꞌuc ti choye ti cꞌu yepal muc xlaj yuꞌun ti crixchanoetique. Inoj lajcheb moch ti sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Oy nan voꞌmiluc viniquetic iveꞌic. Slecoj ti antsetique xchiꞌuc ti cꞌoxetique, muc bu nitbil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tsꞌacal to ―Ochanic echꞌel ta canova, tꞌab batanic ta jech nab ―xiyutoticotic ti Jesuse. Ti Jesuse stuc xa iscꞌopon comel ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ti cꞌalal laj scꞌopon comele, imuy ta vits, ba scꞌopon Riox. Cꞌalal iꞌicꞌube, stuc tey ta vits ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Li voꞌoticotique oꞌlol xaꞌox nab xilocꞌoticotic echꞌel. Ital tsots icꞌ ta quelavticotic, xyucꞌyon xa tajmec li nabe. Mu xa xanav ti canovae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cꞌalal poꞌot xaꞌox sacube, listaoticotic ta oꞌlol nab ti Jesuse. Iquilticotic ti chanav tal ta yoc ta ba name. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ti cꞌalal iquilticotique, lixiꞌoticotic. Xcacꞌticoticuc me chꞌulelal. Xiꞌavlajetoticotic xa tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ora icꞌopoj ti Jesuse: ―Voꞌon Jesuson, mu me xaxiꞌic ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","―Cajval, mi yech chaval ti voꞌote, alo ti xuꞌ chital ta ba nab uque, chtal jnupot ―xi li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Laꞌ ―xꞌutat. Ilocꞌ ta canova li Pedroe, ixanav ta yoc ta ba nab, ba snup ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Cꞌalal iyaꞌi ti tsots iqꞌue, ixiꞌ. Chmuc xaꞌox yalel ta voꞌ. ―¡Cajval, coltaon! ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti Jesuse ora istsacbe scꞌob. ―¿Cꞌu yuꞌun ti chaxiꞌe? ¿Mi mu to bu achꞌunoj yaꞌel ti voꞌon tsots jyuꞌele? ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cꞌalal iꞌochic ta canovae, ipaj li iqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Voꞌoticotic ti teoticotic ta yut canovae ijquejan jbaticotic, iquichꞌticotic ta mucꞌ ti Jesuse. ―Ta melel voꞌot Xchꞌamalot ti Rioxe ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ti cꞌalal licꞌototicotic ta Genesaret ta jech nabe, tey lilocꞌoticotic ta canova. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti jchiꞌiltactic ta israelale ti tey nacajtique iyojtiquinic ti jaꞌ ti Jesuse. Ora ivinaj ta sjunlej Genesaret ti tey icꞌot ti Jesuse. Iyicꞌbeic tal scotol jchameletic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Oy jlom jchameletic iscꞌanbeic ti Jesuse ti jaꞌ noꞌox acꞌu yacꞌ ta piquel ti sne spimilcꞌuꞌe. Ti muchꞌutic ispique iꞌechꞌ o ti xchamelic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tey icꞌotic jayvoꞌ jfariseoetic xchiꞌuc jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, liꞌ liquemic echꞌel ta Jerusalene. Cꞌot sjacꞌbeic ti Jesuse: ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Cꞌu yuꞌun ti maꞌuc yech tspasic lavajchancꞌoptaque chac cꞌu chaꞌal ispasic ti voꞌne moletique? Yuꞌun jliquel noꞌox tspoc scꞌobic cꞌalal chveꞌique. Ti voꞌne moletique jal ispoc scꞌobic ti cꞌalal iveꞌique yoꞌ lec xꞌileic o yuꞌun ti Rioxe ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Itacꞌav ti Jesuse: ―¿Cꞌu yuꞌun ti maꞌuc chachanubtasvanic o li smantaltac Rioxe, ti jaꞌ chavalic ti cꞌu xꞌelan scostumbreic ti voꞌne moletique? ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Ichꞌo ta mucꞌ atot ameꞌ”, xi ti Rioxe. “Mi oy muchꞌu chopol cꞌusi chalbe li stot smeꞌe, milic”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Yan li voꞌoxuque chachanubtasic ti acꞌu noꞌox yalic ti yacꞌojic xa ta smoton Riox li cꞌusuc yuꞌunique. Mi iyalbeic xa yech ti stot smeꞌique ti yacꞌojic xa ta smoton Riox li cꞌusuc yuꞌunique, xuꞌ xa mu scꞌuxubinic li stot smeꞌique. Ti xꞌelan chavalique, maꞌuc chachanubtasvanic o li smantaltac Rioxe. Jaꞌ chavalic ti cꞌu xꞌelan smantalic ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yech noꞌox chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Jaꞌ acꞌoplalic ti iꞌalbat yuꞌun Riox ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Lachiꞌiltaque yech noꞌox chalic ti chiyichꞌic ta muqꞌue, mu sjunuluc yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Smantal noꞌox crixchano ti ta xchanubtasvanic oe, mu voꞌonicon caloj, xi ti Rioxe, xi onox ti Isaíase ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","―Jchiꞌiltactic, nopojanic tal. Laꞌ aꞌyic li cꞌusi chcale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Li cꞌusitic chalajesique muc bu chata o amulic ta stojol ti Rioxe. Jaꞌ chata o amulic li cꞌusitic chopol chavalique ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Voꞌoticotic li yajchancꞌopoticotique linopojoticotic echꞌel yoꞌ bu ti Jesuse. ―¿Mi anaꞌoj ti chopol iyaꞌi jfariseoetic ti xꞌelan avalbee? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","―Li jfariseoetique chalic ti mu persauc xachꞌunic scotol ti cꞌusitic yaloj ti Jtot tey ta vinajele. Yechꞌo un ta onox xchꞌay scꞌoplalic chac cꞌu chaꞌal chichꞌ bulel tsꞌiꞌlel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yechꞌo un mu me xavat avoꞌonic. Yuꞌun coꞌolic xchiꞌuc maꞌsat ti yoꞌonuc yacꞌbe yil be li xchiꞌil ta maꞌsatile. Pero mi coꞌol maꞌsatetique, coꞌol chpꞌajic ta chꞌen ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","―Alboticotic smelol li loꞌil avale ―xi li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","―¿Mi muc xavaꞌibeic smelol yaꞌel uc? ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mi mu xanaꞌic yaꞌel ti ta achꞌutic noꞌox chcꞌot li cꞌusitic chalajesique, ti chatsaꞌtaic loqꞌuele? ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yan li cꞌusitic chopol chavalique, ta avoꞌonic chlic tal, jaꞌ chata o amulic ta stojol ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Li crixchanoetique ta yoꞌonic onox tsnopic li cꞌusitic chopole. Chmilvanic, tsaꞌ yantsic, tsaꞌ yajmulic, ch-elcꞌajic, tsnopic cꞌop, tol xloꞌiltavanic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Li cꞌusitic chopol liꞌi jaꞌ chata o amulic ta stojol ti Rioxe. Mi jaꞌ noꞌox muc bu jal chapoc acꞌobic cꞌalal chaveꞌique, muc bu chata o amulic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ti Jesuse ilocꞌ echꞌel, ibat ta stsꞌel li chib jteclum Tiroe xchiꞌuc li Sidone. Libatoticotic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tey icꞌot jun jcanaanil ants. Ti antse iyapta ti Jesuse: ―Totic, smom David, cꞌuxubinbon li jtsebe yuꞌun ochem pucuj ta yoꞌon. Abol sba tajmec ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ti Jesuse muc xtacꞌav. ―Abulajan taco echꞌel li antse yuꞌun tsots chiyaptaotic ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","―Li voꞌone jaꞌ noꞌox tacbilon tal scuenta jchiꞌiltac ta israelal yuꞌun coꞌolic xchiꞌuc jchꞌayel chijetic ―xꞌutat yuꞌun Jesús ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ti antse isquejan sba ta yichon ti Jesuse, jaꞌo isnijan sba ta balamil noxtoc. ―Totic, loqꞌuesbon pucuj ta yoꞌon li jtsebe ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","―Oy onox xavaꞌi loꞌil ti chopol mi ta jpojbetic spanic li unetique, mi jaꞌ chcacꞌbetic slajes li cꞌox tsꞌiꞌetique ―xꞌutat yuꞌun chqꞌuele cꞌu xꞌelan chtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","―Yechaꞌa, totic. Pero oy onox chpꞌaj xchꞌuchꞌulil spanic ta yolon smexa li unetique. Jaꞌ tstamic li cꞌox tsꞌiꞌetique. Cꞌuxubinon yech uc ―xi ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","―Chquil ti sjunul avoꞌon achꞌunoj ti oy jyuꞌele. Acꞌu cꞌotuc li cꞌusi acꞌanbone ―xꞌutat yuꞌun Jesús ti antse. Ora ilocꞌ pucuj ta yoꞌon ti stsebe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ti Jesuse ilocꞌ echꞌel, ibat ta tiꞌnab tey noꞌox ta estado Galilea. Imuy ta vits, ichoti. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tey icꞌotic epal crixchanoetic yoꞌ bu ti Jesuse. Yicꞌojic cꞌotel coxoetic, xchiꞌuc maꞌsatetic, xchiꞌuc umaꞌetic, xchiꞌuc ti muchꞌutic tuncoe, xchiꞌuc yan jchameletic. Tey cꞌot yaqꞌuic yoꞌ bu ti Jesuse. Iyetꞌesbe xchamel scotol ti jchameletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ti jchiꞌiltactique xchꞌayet xa yoꞌonic ti cꞌalal iyilic ti ijam xa yeic ti muchꞌutic umaꞌetic toꞌoxe, ti lec xa yoc scꞌobic ti muchꞌutic tunco toꞌoxe, ti lec xa chanavic ti muchꞌutic coxoetic toꞌoxe, ti ijam xa satic ti muchꞌutic maꞌsatetic toꞌoxe. Ti Riox quichꞌojtic ta mucꞌ voꞌotic li jꞌisraelotique, lec ibat scꞌoplal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ti Jesuse listsoboticotic, voꞌoticotic li yajchancꞌopoticotique. ―Toj abol sbaic chquil li jchiꞌiltactic liꞌi, yuꞌun yoxibal xa cꞌacꞌal liꞌ jchiꞌuctique, mu xa cꞌu slajesic. Ti mi ta jtac echꞌel ta snaic lavi muc bu veꞌemique, yicꞌal xlubtsajic ta be ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","―¿Bu ta jtaticotic ep pan liꞌ ta xocol balamile ti ta jmacꞌlinticotic o li epal crixchanoetique? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","―¿Jaypꞌej to li jpantique? ―xiyutoticotic. ―Vucpꞌej xchiꞌuc jaycot cꞌox choy ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ti Jesuse iyalbe ti crixchanoetique ti acꞌu chotlicuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ixchꞌam ti vucpꞌej pane xchiꞌuc ti choye, “colaval”, xut ti Rioxe. Jaꞌo ixut ti pane, ixchꞌac noxtoc ti choye, liyacꞌboticotic. Voꞌoticotic xa icacꞌbeticotic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iveꞌ scotolic, lec inojic. Ijtsobticotic ti pane xchiꞌuc ti choye ti cꞌu yepal muc xlaj yuꞌun ti crixchanoetique. Inoj vucub moch ti sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Oy nan chanmiluc viniquetic iveꞌic. Slecoj ti antsetique xchiꞌuc ti cꞌoxetique, muc bu nitbil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ti cꞌalal laj veꞌicuque ―Batanic xa un ―xut crixchanoetic ti Jesuse. Jaꞌo liꞌochoticotic ta canova xchiꞌuc ti Jesuse. Libatoticotic ta stsꞌel jteclum Magdala. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tey icꞌotic jayvoꞌ jfariseoetic xchiꞌuc jayvoꞌ jsaduceoetic. Oy cꞌusi isjacꞌbeic ti Jesuse yoꞌ stabeic o smul ti yalojique. ―Acꞌo quilticotic mi yech ti oy ayuꞌele. Jqꞌueltiquic mi oy cꞌusi xyal tal avuꞌun ta vinajel yoꞌ jchꞌunticotic o ti stacojot tal ti Rioxe ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Itacꞌav ti Jesuse: ―Cꞌalal ch-icꞌube, “ti ocꞌobe qꞌuepel yuꞌun tsoj li vinajele”, xachiic. Yuꞌun onox qꞌuepel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta sobe “chtal voꞌ tana. Tsoj li vinajele, macal osil”, xachiic. Yuꞌun onox ta xtal. Xavilic cꞌu xꞌelan li vinajele pero ti avalojique, jaꞌ mu xavilic ti stacojon tal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Voꞌoxuc ti cuxuloxuc lavie, chopol ajolic. Mu xavichꞌic ta mucꞌ ti Rioxe. Yuꞌun jaꞌ noꞌox chacꞌan chaqꞌuelic li jyuꞌele pero muc bu chcacꞌ avilic. Jaꞌ noꞌox chavaꞌibecon jcꞌoplal chac cꞌu chaꞌal avaꞌibeic scꞌoplal ti Jonas yajꞌalcꞌop Riox ti ta más voꞌnee ―xꞌutatic yuꞌun ti Jesuse. Tey lamal iscomtsan crixchanoetic ti Jesuse, libatoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Licꞌototicotic ta jech nab xchiꞌuc ti Jesuse. Voꞌoticotic li yajchancꞌopoticotique muc jnaꞌ xquichꞌ jpanticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","―Qꞌuelo me abaic ta svuquesobil xchꞌut span li jfariseoetique xchiꞌuc li jsaduceoetique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","―Ti xꞌelan chale, jaꞌ nan ti muc jnaꞌtic tal ti jpantique ―xcut jbaticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ti Jesuse snaꞌoj cꞌusi icalbe jbaticotic. ―¿Cꞌu yuꞌun ti xavalvalbe abaic ti muc xanaꞌic tal ti jpantique? Yuꞌun mu to bu achꞌunojic yaꞌel ti voꞌon tsots jyuꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yuꞌun ichꞌay xa xavaꞌiic ti voꞌpꞌej noꞌox pan iveꞌic o ti voꞌmil viniquetique, xchiꞌuc ti jayib moch atsobbeic sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yuꞌun ichꞌay xa xavaꞌiic noxtoc ti vucpꞌej noꞌox pan iveꞌic o ti chanmil viniquetique, xchiꞌuc ti jayib moch atsobbeic sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yechꞌo ti mu to xavaꞌibeic smelol ti maꞌuc svuquesobil xchꞌut pan ti “qꞌuelo me abaic ta svuquesobil xchꞌut span li jfariseoetique xchiꞌuc li jsaduceoetique”, xacutique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Icaꞌibeticotic smelol ti maꞌuc svuquesobil xchꞌut pane. Jaꞌ noꞌox iyal ti pꞌijiconticotic ti mu me jchꞌunticotic ti cꞌusi chalic ti jfariseoetique xchiꞌuc ti jsaduceoetique. Yuꞌun chalic ti mu persauc jchꞌuntic scotol ti cꞌusitic yaloj ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Libatoticotic ta stsꞌel jteclum Cesarea de Filipo xchiꞌuc ti Jesuse. ―¿Cꞌusi van cabtel yalojic li jchiꞌiltactique, voꞌon ti coꞌol crixchanootique? ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","―Jlom chalic ti voꞌot Juan jꞌacꞌ-ichꞌvoꞌote. Jlom chalic ti voꞌot Eliasote. Jlom chalic ti voꞌot Jeremíasote. Jlom chalic ti voꞌot yajꞌalcꞌopot Riox ti ta más voꞌnee ti yuꞌun nan ichaꞌcuxie ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","―Li voꞌoxuque, ¿cꞌusi cabtel ti avalojique? ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","―Voꞌot Cristoot ti yaloj Riox chapasoticotic ta mantale. Voꞌot Xchꞌamalot Riox ta vinajel ti cuxul ta sbatel osile ―xut li Simon Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Itacꞌav ti Jesuse: ―Simón, screm Jonás, yacꞌojbot bentisyon ti Rioxe. Yuꞌun maꞌuc crixchano isyules ta ajol li cꞌusi cabtele. Jaꞌ isyules ta ajol ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Li voꞌote ti Pedro icacꞌ abie, yuꞌun ep to ta xchꞌunic avuꞌun ti voꞌon tal jtoj amulique. Ta persa chcꞌot yech. Acꞌu mi yoꞌonuc xchꞌay jcꞌoplal ti pucuje pero mu xchꞌay yuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Voꞌot chcom ta aba ti chavalbe yaꞌi crixchanoetic cꞌu xꞌelan xuꞌ chcꞌotic yoꞌ bu ti Rioxe. Ti muchꞌutic mu xavacꞌ ta pertonale mi oy cꞌusi chopol ispasique, jaꞌ noꞌox yech mu xꞌaqꞌueic ta pertonal yuꞌun ti Rioxe. Yan ti muchꞌutic chavacꞌ ta pertonale, ch-aqꞌueic ta pertonal yuꞌun ti Riox uque ―xꞌutat li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","―Mu to me muchꞌu xavalbeic ti voꞌon stꞌujojon Riox chajpasic ta mantale ―xiyutoticotic jcotolticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lic yalboticotic noxtoc ti Jesuse: ―Persa chibat ta Jerusalén yuꞌun tey chba cacꞌ jvocol. Yuꞌun tey chistsaquic li jmeltsanejcꞌopetique, xchiꞌuc li totil paleetique, xchiꞌuc li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Jaꞌ chiyaqꞌuic ta milel, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Li Pedroe ilocꞌlocꞌ echꞌel xchiꞌuc ti Jesuse. ―Cajval, acꞌu scꞌuxubinot ti Rioxe, maꞌuc yech smelol ti chavichꞌ milele ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ti Jesuse isqꞌuelbe sat li Pedroe. ―¿Cꞌu yuꞌun chachꞌunbe smantal ti Satanase? Mu me xapajeson. Li voꞌote maꞌuc chanop ti cꞌusi tscꞌan ti Rioxe. Jaꞌ yech chanop chac cꞌu chaꞌal tsnop li yan crixchanoetique ―xꞌutat yuꞌun Jesús li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","―Ti muchꞌutic chiyichꞌic ta muqꞌue, mu me cꞌuxuc ta yoꞌon spat xoconic. Acꞌu cuchuc yuꞌunic ilbajinel chac cꞌu chaꞌal ta xcuch cuꞌun li voꞌone, acꞌu mi jaꞌ xlajic o. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ti muchꞌutic mu xiyichꞌic ta muqꞌue ti jaꞌ chiꞌic o li milele, yuꞌun onox ta xꞌochic ta cꞌocꞌ ta sbatel osil. Yan ti muchꞌutic muc ta alel yuꞌunic mi jaꞌ xlajic oe, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mi jaꞌ noꞌox ta avoꞌonic li cꞌusitic oy ta sba balamile, mu cꞌusi bal o yuꞌun chaꞌochic onox ta cꞌocꞌ ta sbatel osil. Acꞌu mi jcꞌulejoxuc tajmec liꞌ ta sba balamile, pero mu xuꞌ chaman abaic loqꞌuel li ta cꞌoqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta sta yora chital xchiꞌuc slequilal syuꞌelal ti Jtote, voꞌon ti coꞌol crixchanootique. Chixchiꞌinic tal anjeletic ta vinajel. Ti cꞌu xꞌelan ch-echꞌic jujun liꞌ ta sba balamile, jaꞌ yech chtal jtojic yaꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta melel chacalbeic, lavi jayvoꞌ liꞌoxuque, oy mu toꞌox chachamic ti cꞌalal xlic pasvancon ta mantale, voꞌon ti coꞌol crixchanootique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ti cꞌalal ilaj vaquib cꞌacꞌal ti yech iyal ti Jesuse, jaꞌo iꞌiqꞌueic muyel ta jpꞌej mucꞌta vits li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juan yitsꞌin Jacoboe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Li oxvoꞌe iyilic la ti iyacꞌ xojobal ti Jesuse. Ti xojobal sate coꞌol la xchiꞌuc xojobal cꞌacꞌal. Ti scꞌuꞌe sac la tajmec, coꞌol la xchiꞌuc luz. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jaꞌo la iyilic ti Moisese xchiꞌuc ti Eliase, tey la chloꞌilajic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","―Cajval, lec ti liꞌotic oe. Mi xacꞌane, ta jmeltsanticotic oxpꞌejuc sucbil yanal teꞌ; jpꞌej avuꞌun, jpꞌej yuꞌun Moisés, jpꞌej yuꞌun Elías ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ti cꞌalal yolel chloꞌilaj li Pedroe, jaꞌo la ital lumal toc, ibutꞌij la scotolic. Iyacꞌ la xojobal li lumal toque. Iyaꞌiic la icꞌopoj ta yut lumal toc ti Rioxe. ―Liꞌi jaꞌ Jchꞌamal. Jcꞌanoj tajmec. Batsꞌi jun coꞌon yuꞌun. Xachꞌunbeic me li cꞌusitic chayalbeique ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ti cꞌalal iyaꞌiic ti oxvoꞌ jchiꞌilticotic ta yajchancꞌop ti Jesuse, ixiꞌic la tajmec, ispatan la sbaic ta lum. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Itijeic la yuꞌun ti Jesuse: ―Licanic, mu xaxiꞌic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta jliquel o isqꞌuelic la ta jujot pero stuc xa la tey vaꞌal iyilic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ti cꞌalal iyalic tale ―Mu to me muchꞌu xavalbeic yaꞌi ti cꞌusi avilique. Jaꞌto me xavalic aꞌyuc ti cꞌalal xichaꞌcuxi loqꞌuel ta jmuquenal voꞌon ti coꞌol crixchanootique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","―¿Cꞌu yuꞌun chalic li jchanubtasvanejetic ta smantal Rioxe ti baꞌyi chtal ti Eliase, ti tsꞌacal to chatale? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","―Ta melel jaꞌ yech tsꞌibabil ta scꞌop Riox ti jaꞌ baꞌyi ta xtal ti Eliase. Jaꞌ chtal yalbe li jchiꞌiltactique ti acꞌu yictaic spasel li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Chacalbeic, ti Eliase iꞌay xa, pero muc xojtiquinic. Li crixchanoetique ispasbeic ti cꞌusi tscꞌan yoꞌonique, ismilic. Jaꞌ noꞌox yech chismilic uc, voꞌon ti coꞌol crixchanootique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jaꞌ la iyul o ta sjolic ti jaꞌ scꞌoplal Juan jꞌacꞌ-ichꞌvoꞌ ti iyal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ti cꞌalal iyulic yoꞌ bu tsoboloticotic xchiꞌuc ti crixchanoetique, tey icꞌot jun jchiꞌiltic, isquejan sba ta yoc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Cajval, cꞌuxubinbon li jcreme yuꞌun staoj tupꞌ-icꞌ. Toj abol sba. Ep ta echꞌel icꞌot ta cꞌocꞌ. Ep ta echꞌel ipꞌaj ta voꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iquicꞌbe tal lavajchancꞌoptaque, icalbeic ti acꞌu sloqꞌuesic ti pucuje, pero muc xlocꞌ yuꞌunic ―xut ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","―Chopol ajolic, mu onox xachꞌunic tajmec. ¿Cꞌu to onox ora chachꞌunic yaꞌel ti voꞌne xa liꞌ jchiꞌucoxuque, ti jal xa lajtsꞌicbeique? Icꞌbecon tal li creme ―xiyutoticotic xchiꞌuc ti jchiꞌiltactique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ti Jesuse istac loqꞌuel ti pucuje. Ora ilocꞌ ta yoꞌon ti creme. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ti cꞌalal jtucticotic xae ―¿Cꞌu yuꞌun ti muc xlocꞌ cuꞌunticotic ti pucuje? ―xcuticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","―Yuꞌun mu to chachꞌunic ti voꞌon chajcoltaic ta spasel scotole. Ta melel chacalbeic, acꞌu mi jutuc noꞌox achꞌunojic ti oy jyuꞌele, acꞌu mi coꞌol xchiꞌuc jpꞌej becꞌ mustisya, pero spas xa avuꞌunic li cꞌusitic vocol ta pasele. Jaꞌ chac cꞌu chaꞌal mi chavalic ti acꞌu locꞌuc li vits liꞌi, tspas avuꞌunic. Scotol xa xuꞌ avuꞌunic mi jaꞌ yech achꞌunojique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero li jtos pucujetic ti ijloqꞌuese, jaꞌto ta xlocꞌ mi chacꞌoponic Rioxe, mi chavicta avotique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ti cꞌalal teoticotic toꞌox ta Galilea xchiꞌuc ti Jesuse ―Voꞌon ti coꞌol crixchanootique chiꞌaqꞌue entrucal ta stojol crixchanoetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chismilic, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xiyutoticotic. Ti cꞌalal icaꞌiticotique, icat coꞌonticotic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ti cꞌalal licꞌototicotic ta Capernaume, tey icꞌotic jayvoꞌ jtsob-tojel-aqꞌuel scuenta mucꞌta templo. ―¿Mi chacꞌ chib dracma lavajchanubtasvanejique? ―xꞌutat li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Chacꞌ ―xi. Cꞌalal iꞌoch ta yut na li Pedroe, jaꞌ baꞌyi icꞌoponat yuꞌun ti Jesuse. ―Simón, ¿cꞌusi chanop? ¿Muchꞌu tscꞌanbe taqꞌuin li preserenteetic liꞌ ta sba balamile? ¿Mi jaꞌ tscꞌanbe li xchꞌamaltaque, o mi yan crixchanoetic tscꞌanbe? ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","―Yan crixchanoetic tscꞌanbe ―xi li Pedroe. ―Jaꞌ colem chcom li xchꞌamaltaque. Jaꞌ noꞌox yech li voꞌon uque, mu persauc chacacꞌ ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero yoꞌ mu soc o sjolique, batan ta nab, ticꞌo ochel ta nab li ansuelo tsacob choye. Li primero choy chanit loqꞌuele, jachꞌbo ye. Tey yumoj chata jsep estatero. Ichꞌo tal, acꞌbo li muchꞌutic ta stsobe. Tey batuc scuenta jchaꞌvaꞌaltic ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti cꞌalal iyacꞌ tojel aqꞌuel ti Jesuse, jaꞌo ijacꞌbeticotic, voꞌoticotic li yajchancꞌopoticotique: ―¿Muchꞌu junucal tsots yabtel chichꞌ ti cꞌalal chaꞌoch ta pasmantale? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","―Laꞌ ―xut jun cꞌox crem ti Jesuse. Isvaꞌan ta oꞌlol yoꞌ bu tsoboloticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","―Ta melel chacalbeic, mi chacꞌanic coltael yuꞌun ti Rioxe chac cꞌu chaꞌal tscꞌanic coltael yuꞌun stotic li cꞌoxetique, xuꞌ chaꞌochic yoꞌ bu ta jpas mantale. Ti mi mu xacꞌanic coltaele, mu xuꞌ chaꞌochic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mi mu xavacꞌ abaic ta ichꞌel ta mucꞌ chac cꞌu chaꞌal mu snaꞌ xacꞌ sba ta ichꞌel ta mucꞌ li cꞌox liꞌi, jaꞌ tsots avabtel chacꞌotic yoꞌ bu ta jpas mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mi chachanubtasic ta jcꞌop li muchꞌu jaꞌ yech yoꞌon chac cꞌu chaꞌal yoꞌon li cꞌox liꞌi, chvinaj ti voꞌon avichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yan mi chachanubtasic ta spasel cꞌusi chopol junuc ti muchꞌutic jaꞌ yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique ti yichꞌojicon ta muqꞌue, más lec ti lachucbaticuc jcotuc choꞌ ta anuqꞌuique, ti latenaticuc ochel ta mare, ti lachamicuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lavi cuxuloxuc to ta sba balamile, oy onox cꞌusi chopol chtal ta avoꞌonic. Yechꞌo un qꞌuelo me abaic, mu me voꞌoticoxuc ta amulic mi tsaꞌ smul lachiꞌilique. Mi voꞌoxuc ta amulic tsaꞌ smul lachiꞌilique, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mi jaꞌ chata o amulic lavoc acꞌobique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o ta vinajele. Mi avoc acꞌobic noꞌox chaꞌochic o ta cꞌocꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jaꞌ noꞌox yech noxtoc mi jaꞌ chata o amulic lasatique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o ta vinajele. Mi asatic noꞌox chaꞌochic o ta cꞌocꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Pꞌijanic me, mu me xapꞌajic junuc li cꞌoxetic lacalbeique yuꞌun scotol xchabioj ti anjeletic ta vinajele. Ta melel chacalbeic, ti anjeletic ta xchabivanique chcꞌot scꞌoponic ti Jtot tey ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Voꞌon ti coꞌol crixchanootique, tal jpojoxuc yuꞌun scꞌoplal chaꞌochic ta cꞌocꞌ ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Caltic noꞌox yaꞌel ti oy jun vinic oy cien xchije. Mi ichꞌay jcotuque, lamal chicta li noventa y nuevee ti cꞌalal chba saꞌ tal li jcot chꞌayeme. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta melel chacalbeic, ti muc bu chꞌayem li noventa y nuevee, jun yoꞌon. Pero mi ista li jcot ti ichꞌaye, más to jun yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaꞌ noꞌox yech ti Jtot tey ta vinajele, mu scꞌan ti ch-och ta cꞌocꞌ junuc li cꞌoxetic lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Ti mi oy bu ista smul avuꞌun junuc achiꞌil ta yichꞌelon ta muqꞌue, ba lequilꞌalbo atuc ti cꞌusi chopol ispase. Ti mi ta xchꞌune, lec chacomic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ti mi mu xchꞌune, icꞌo echꞌel junuc o mi chaꞌvoꞌuc achiꞌil yoꞌ oy o rextico ti cꞌusi avalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ti mi muc xachꞌunbatic li cꞌusi avalbeique, albo abaic acotolic ti cꞌu avepalic sjunul avoꞌonic avichꞌojicon ta muqꞌue. Comonꞌalbeic ti cꞌusi chopol tspase. Mi mu xaxchꞌunbe acotolic noxtoque, tey comuc chac cꞌu chaꞌal yan crixchano, chac cꞌu chaꞌal jcꞌan-locꞌ-cꞌusiticuc ti mu xichꞌic ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ta melel chacalbeic, ti muchꞌutic mu xavaqꞌuic ta pertonal mi oy cꞌusi chopol ispasique, jaꞌ noꞌox yech mu xꞌaqꞌueic ta pertonal yuꞌun ti Rioxe. Yan ti muchꞌutic chavaqꞌuic ta pertonale, ch-aqꞌueic ta pertonal yuꞌun ti Riox uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Chacalbeic noxtoc, mi oy chaꞌvoꞌoxuc ti coꞌol ajolic chacꞌoponic ti Jtot tey ta vinajele, scotol li cꞌusi chacꞌanbeique chayacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mi oy atsoboj abaic chaꞌvoꞌ oxvoꞌuc, voꞌoxuc ti avichꞌojicon ta muqꞌue, tey jchiꞌucoxuc ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","―Cajval, ¿jayꞌechꞌel tscꞌan chcacꞌbe pertonal mi ista smul cuꞌun junuc jchiꞌile? ¿Mi xuꞌ ta vucꞌechꞌel noꞌox? ―xi li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","―Muc bu chacalbe mi vucꞌechꞌel noꞌox. Mu atbiluc jayꞌechꞌel tscꞌan chavacꞌ pertonal. Scotol cꞌacꞌal tscꞌan chavacꞌ pertonal ―xꞌutat yuꞌun ti Jesuse―. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Chacalbeic cꞌu xꞌelan tspas mantal ti Rioxe. Caltic noꞌox yaꞌel ti oy jun preserente ti oy yil xchiꞌiltac tey ta opisinae. Li preserentee tscꞌan xa sutesbel li staqꞌuine, yechꞌo un istac ta iqꞌuel ti muchꞌutic oy yile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jaꞌ baꞌyi ital ti muchꞌu oy lajunmil yile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Li vinique mu xa sut yuꞌun. Yechꞌo un li preserentee isloqꞌues mantal ti acꞌu chonatuc ta mozoil scotolic xchiꞌuc yajnil, xchiꞌuc xchꞌamaltac, xchiꞌuc scotol cꞌusuc yuꞌun, yoꞌ sut o li yile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ti cꞌalal iyaꞌi li vinique, isquejan sba, iscꞌopon li preserentee: “Totic Preserente, abulajan malabon to li quile. Chajsutesbe onox scotol”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Icꞌuxubinat yuꞌun li preserentee, ichꞌaybat scotol li yile, icoltaat echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ti cꞌalal ilocꞌ echꞌel li vinique, isnup ta be jun xchiꞌil ti tey ta opisina uque. Oy cien yil uc. Istsac li xchiꞌile, ismichꞌbe snucꞌ. “Sutesbon ta ora lavile”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Li xchiꞌile isquejan sba uc. “Abulajan malabon to li quile, chajsutesbe onox scotol”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero mu xa smala. Ba sticꞌ ta chuquel. “Jaꞌto xaloqꞌues mi lisutesbe scotol li yile”, xut comel li jchabichuclebale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ti cꞌalal iyil li yan xchiꞌiltac tey ta opisinae ti isticꞌ ta chuquel li xchiꞌile, chopol iyilic. Ora ba yalbeic li preserentee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Li preserentee istac ta iqꞌuel. “Li voꞌote chopol ajol. Ti avalbon ti chajmalabe to lavile, yechꞌo un ijnop ti chajchꞌaybe scotole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Cꞌu yuꞌun ti muc xacꞌuxubin lachiꞌile chac cꞌu chaꞌal lajcꞌuxubine?” xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Icap li preserentee. Iyacꞌbe ta scꞌob li muchꞌutic ch-ilbajinvanic ta chuclebale. “Jaꞌto xaloqꞌuesic mi lisutesbe scotol li yile”, xut comel li muchꞌutic ch-ilbajinvanique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Li voꞌoxuque jaꞌ noꞌox yech chaxchaꞌleic ti Jtot tey ta vinajel uque mi mu sjunuluc avoꞌon chavaqꞌuic ta pertonal lachiꞌilique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ti Jesuse cꞌalal laj yal chac taje, ilocꞌ ta estado Galilea, ital liꞌ ta estado Judeae. Tey iyul ta jech ucꞌum Jordán. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ep jchiꞌiltactic tijilic tal xchiꞌuc ep jchameletic. Ti Jesuse iyetꞌesbe xchamel scotol ti jchameletic ti tey tijajtic tale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tey icꞌotic jayvoꞌ jfariseoetic. Oy cꞌusi isjacꞌbeic ti Jesuse yoꞌ stabeic o smul ti yalojique. Isjacꞌbeic mi xuꞌ ta xchꞌac o yajnil li viniquetique ti cꞌusuc noꞌox smul tstabeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Itacꞌav ti Jesuse: ―¿Mi muc bu aqꞌuelojic yaꞌel ta scꞌop Riox yoꞌ bu chal ti cꞌalal ipase yuꞌun Riox ti primero vinique, jun vinic jun ants ispas? ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Li cremotique ta xchꞌac sbaic xchiꞌuc stot smeꞌic ti cꞌalal sta yajnilique. Xchaꞌvaꞌalic jun xa chcꞌotic”, xi ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yechꞌo un mu xa chaꞌvoꞌuc, junic xa. Ti muchꞌutic nupul tsꞌacalique jun xa ch-ileic yuꞌun ti Rioxe, mu xa xuꞌ xchꞌac sbaic ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","―¿Cꞌu yuꞌun iyal mantal ti Moisese: “Ti muchꞌu ta xchꞌac yajnile, acꞌu smeltsanbe svunal ti ixchꞌac xa sbaique. Li vune jaꞌ chichꞌ li yajnile yoꞌ xil o ti chꞌacbil xae”, xi? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","―Ti xꞌelan istsꞌiba comel ti Moisese, jaꞌ ti mu xachꞌunic tajmeque. Ti cꞌalal ismeltsan balamil ti Rioxe, maꞌuc yech. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Li voꞌone chcal avaꞌiic. Ti muchꞌu ta xchꞌac yajnile, mi muc bu saꞌoj yajmul ti ta xchꞌaque, mi chicꞌ yan antse, coꞌol xchiꞌuc yants chcꞌot. Ti muchꞌu chicꞌ chꞌacbalal antse coꞌol xchiꞌuc yants chcꞌot noxtoc ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","―Mi yech scꞌoplal ti muchꞌutic oy yajnile, más lec ti mu yaꞌuc jsaꞌ cajnilticotique ―xcuticotic voꞌoticotic li yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","―Mu xcuch avuꞌun acotolic ti mu xasaꞌ avajnilique. Jaꞌ noꞌox chcuch yuꞌun ti muchꞌutic yech acꞌbil yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oy viniquetic ti stalel mu saꞌ yajnilique. Oy viniquetic ti pasbilic ta capone. Oy viniquetic ti mu saꞌ yajnilique yoꞌ xtunic o más yuꞌun ti Rioxe. Ti muchꞌutic yeche, mi chaꞌiic ti yech tscꞌan ti Rioxe, acꞌu spasic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tey yicꞌojbeic cꞌotel cꞌoxetic ti Jesuse yuꞌun acꞌu yacꞌ scꞌob ta sjolic, acꞌu scꞌoponbe Riox. Voꞌoticotic li yajchancꞌopoticotique ijpajesticotic ti muchꞌutic iyiqꞌuic tal ti cꞌoxetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","―Mu xavutic. Acꞌu talicuc li cꞌoxetique. Yuꞌun ti muchꞌutic jaꞌ yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique, ta xchꞌunic cꞌusi chal ti Rioxe ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ti cꞌalal laj yacꞌ scꞌob ta sjol cꞌoxetic ti Jesuse, ilocꞌ teyoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oy jun jchiꞌiltic cꞌot scꞌopon ti Jesuse. ―Jchanubtasvanej, voꞌot ti lec avoꞌone, ¿cꞌusi lec tscꞌan ta jpas yoꞌ xicuxi o ta sbatel osile? ―xut ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Itacꞌav ti Jesuse: ―¿Cꞌu yuꞌun ti “lec avoꞌon”, xavutone? Jun noꞌox ti muchꞌu lec yoꞌone, jaꞌ ti Rioxe. Mi chacꞌan chacuxi ta sbatel osile, tscꞌan chachꞌunbe smantal ti Rioxe ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","―¿Cꞌusitic mantalil ti tscꞌan ta jchꞌune? ―xi ti vinique. ―“Mu me xamilvan, mu me xasaꞌ avants, mu me xaꞌelcꞌaj, mu me xanopbe smul achiꞌil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ichꞌo ta mucꞌ atot ameꞌ. Cꞌuxubino me achiꞌiltac chac cꞌu chaꞌal chacꞌuxubin aba atuque”, xi li mantale ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","―Li cꞌusitic avale cꞌoxon toꞌox lic jchꞌun. ¿Cꞌusi xa ti muc bu jchꞌunoje? ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","―Mi chacꞌan ti lec chayil ti Rioxe, ba chono li cꞌusuc avuꞌune. Li stojole qꞌuelanbo li meꞌonetique yoꞌ oy o acꞌulejal ta vinajele. Tsꞌacal to xtal achiꞌinon ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cꞌalal iyaꞌi chac taje, iyat yoꞌon, yuꞌun toj ep cꞌusuc yuꞌun. Isut echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","―Ta melel chacalbeic, li jcꞌulejetique tsots ta chꞌunel chaꞌiic cꞌusi chal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chacalbeic noxtoc, coꞌol xchiꞌuc jcot cameyo ti mu xjelav ta chac acuxae, jaꞌ yech mu xꞌochic yoꞌ bu tspas mantal Riox ti muchꞌutic jaꞌ noꞌox ta yoꞌonic li scꞌulejalique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ti cꞌalal icaꞌiticotique, xchꞌayet xa coꞌonticotic. ―¿Muchꞌu xa onox ta xcuxi ta sbatel osil ti mi mu xcuxiic li jcꞌulejetique? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ti Jesuse isqꞌuel jsaticotic. ―Mu xuꞌ chacuxiic ta sbatel osil ta atuquic. Jaꞌ noꞌox chacuxiic mi chascoltaic ti Rioxe ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","―Li voꞌoticotique jcomtsanojticotic xa li cꞌusuc cuꞌunticotique. Jnapꞌletaojoticotic xa. ¿Cꞌusi chquichꞌticotic li voꞌoticotique cheꞌe? ―xi li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","―Ta melel chacalbeic, ti cꞌalal sta yora ta jlecubtas li balamile, voꞌon ti coꞌol crixchanootique, tey chul chotlicon ta jmucꞌta chotleb yuꞌun voꞌon ta jpas ta mantal scotol li crixchanoetique. Voꞌoxuc ti achiꞌinicone coꞌol ta jpastic mantal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Scotol ti muchꞌutic muc ta alel yuꞌunic mi iscomtsan o snaique, mi sbanquiltac, mi yitsꞌintac, mi svixtac, mi yixleltac, mi xibneltac, mi smuctac, mi stot, mi smeꞌ, mi xchꞌamaltac, mi yosil, yuꞌun ti yichꞌojicon ta muqꞌue, voꞌon chcacꞌbeic cien ta echꞌel sqꞌuexol ti cꞌusitic chcom yuꞌunique. Ta xcuxiic ta sbatel osil noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ep ti muchꞌutic totil yalojic lavie, pero mu cꞌu stu chcꞌotic yoꞌ bu tspas mantal ti Rioxe, yuꞌun ta stoy sbaic. Ep ti muchꞌutic muc bu ichꞌbilic ta mucꞌ lavie, pero más tsots yabtel chcꞌotic yoꞌ bu tspas mantal ti Rioxe, yuꞌun mu snaꞌ stoy sbaic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ti Jesuse liyalboticotic jun loꞌil: ―Chacalbeic cꞌu xꞌelan tspas mantal ti Rioxe. Caltic noꞌox yaꞌel ti oy jun vinic stsꞌunoj ep uvae. Sob ilocꞌ echꞌel, ba saꞌ tal yajꞌabteltac. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ti cꞌalal istae, iyalbe ti tstoj jun denario ta cꞌacꞌale. Istac echꞌel ta uvatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ti cꞌalal ista baluneb orae; ilocꞌ echꞌel noxtoc li yajval uvae. Tey vaꞌajtic ista viniquetic ta chꞌivit, chꞌabal yabtelic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Ba coltaicon yuꞌun oy jtsꞌunoj uva. Lec chajtojic”, xut. Li viniquetique ixchꞌunic li abtele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Li yajval uvae ilocꞌ echꞌel noxtoc ta ol cꞌacꞌal, ba saꞌ tal yan yajꞌabtel. Ilocꞌ noxtoc ta oxib ora xmal cꞌacꞌal. Jaꞌ yech ispas jujuꞌechꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ilocꞌ echꞌel noxtoc ta voꞌob ora xmal cꞌacꞌal. Tey ista viniquetic, chꞌabal yabtelic. “¿Cꞌu yuꞌun ti liꞌ xavaꞌetic sjunul cꞌacꞌale?” xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Yuꞌun muc muchꞌu xiyicꞌoticotic ta abtel”, xiic. “Ba coltaicon yuꞌun oy jtsꞌunoj uva. Lec chajtojic”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ti cꞌalal ch-icꞌub xaꞌox osile, iyalbe ti yajqꞌuel jꞌabtele: “Icꞌo sutel tal scotol li cajꞌabtele, acꞌbo stojolic. Jaꞌ baꞌyi xatoj li muchꞌutic tsꞌacal to italique. Tsꞌacal to xatoj li muchꞌutic baꞌyi italique”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jaꞌ baꞌyi italic li muchꞌutic ta voꞌob xa ora istsac yabtelique. Jujun denario itojatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ti cꞌalal italic li muchꞌutic baꞌyi istsac yabtelique, isnopic ti más chtojatique, pero coꞌol yepal itojatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ti cꞌalal iyichꞌ stojolic li muchꞌutic sob istam yabtelique, iscapanic o li yajval abtele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Jun xa noꞌox ora iꞌabtej li muchꞌutic tsꞌacal to italique, pero coꞌol yepal atojoticotic. Li voꞌoticotique sjunul cꞌacꞌal liꞌabtejoticotic. Cꞌux cꞌacꞌal icaꞌiticotic. Liluboticotic tajmec”, xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mu chopluc ti xꞌelan lajchaꞌleique. Yuꞌun baꞌyi icaltic ti jun denario chajtojic ta cꞌacꞌale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ichꞌo echꞌel latojolique, batanic. Yuꞌun yech coꞌon ti coꞌol chajtoj acotolique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Xuꞌ jpas ti cꞌusi scꞌan coꞌon xchiꞌuc li cꞌusuc cuꞌune. Mu me xacapic o ti xꞌelan ijpase”, xi li yajval abtele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ti cꞌu xꞌelan iyicꞌ ep yajꞌabtel li yajval abtele, jaꞌ noꞌox yech ta xquicꞌ scotol crixchanoetic pero mu scotolicuc scꞌanic pasel ta mantal. Jaꞌ noꞌox scꞌanic pasel ta mantal ti muchꞌutic jtꞌujoj chtunic cuꞌune. Mi muc bu ichꞌbilic ta mucꞌ lavie, jaꞌ tsots yabtel chcꞌotic yoꞌ bu ta jpas mantale, yuꞌun mu snaꞌ stoy sbaic. Yan ti muchꞌutic totil yalojic lavie, jaꞌ mu cꞌu stu chcꞌotic yoꞌ bu ta jpas mantale yuꞌun ta stoy sbaic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ti cꞌalal litaloticotic liꞌ ta Jerusalén xchiꞌuc ti Jesuse, listsoboticotic ta tiꞌil be jlajchavaꞌalticotic ti yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Anaꞌojic ti chibatic ta Jerusalene. Voꞌon ti coꞌol crixchanootique tey chiꞌaqꞌue entrucal ta stojol li totil paleetique xchiꞌuc li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Tey tsnopic ti chiyaqꞌuic ta milele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chiꞌaqꞌue entrucal ta stojol li muchꞌutic nom liquemic tale. Chislabanic, chiyacꞌbeic arsial, jaꞌo chisjipanic ta cruz. Chicham, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ti yajnil Zebedeoe tsobol icꞌotic xchiꞌuc scremotic, cꞌot scꞌoponic ti Jesuse. Li scremotique jaꞌ jchiꞌilticotic ta yajchancꞌop ti Jesuse. Ti smeꞌique isquejan sba ta yichon ti Jesuse, jaꞌo isnijan sba ta balamil noxtoc yuꞌun oy cꞌusi tscꞌanbe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","―¿Cꞌusi chacꞌan? ―xꞌutat ti jmemeꞌtique. ―Alo jpꞌeluc amantal ti coꞌol chachoti xchiꞌuc li chaꞌvoꞌ jcreme, jun ta abatsꞌicꞌob, jun ta asurto, ti cꞌalal chaꞌoch ta pasmantale ―xut ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","―Mu xanaꞌic cꞌu xꞌelan svocolal li cꞌusi chacꞌanbecone. ¿Mi xuꞌ chavacꞌ avocolic, mi xuꞌ chavichꞌic milel chac cꞌu chaꞌal chquichꞌ milel li voꞌone? ―xꞌutatic li chaꞌvoꞌ jchiꞌilticotique. ―Xuꞌ ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","―Ta melel ta onox xavacꞌ avocolic chac cꞌu chaꞌal chcacꞌ jvocol li voꞌone. Chavichꞌic milel noxtoc. Pero mi chacꞌan chachotiic junuc ta jbatsꞌicꞌobe, junuc ta jsurtoe, mu voꞌonicon chcal ti xuꞌe. Jaꞌ chal ti Jtote ti muchꞌutic tey ta xchotiique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ti cꞌalal icaꞌiticotic, voꞌoticotic li lajunvoꞌoticotique, lic jcapanticotic o li Jacoboe xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ti Jesuse listsob jcotolticotic. ―Anaꞌojic cꞌu xꞌelan tspasic li preserenteetic ta yantic nacione. Ilbaj xꞌilvanic, mantal noꞌox tspasic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Li voꞌoxuque maꞌuc me yech xapasic. Ti muchꞌu junucal ta xcom avuꞌunic ta avajpasmantalique, mi tscꞌan ti ichꞌbil ta muqꞌue, jaꞌ tscꞌan ti mu jtoybailuque, ti sjunul yoꞌon chtun avuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jaꞌ chanic chac cꞌu chaꞌal li voꞌone. Voꞌon ti coꞌol crixchanootique, muc bu tal pasvancon ta mantal. Ti litale, yuꞌun tal tunicon yuꞌun scotol crixchanoetic. Tal cacꞌ jba ta milel ta scoj amulic yoꞌ xuꞌ xacuxiic o ta sbatel osile ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ti cꞌalal lilocꞌoticotic tal ta jteclum Jericó xchiꞌuc ti Jesuse, ep jchiꞌiltactic tijajtic talel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tey chotajtic ta tiꞌilbe chaꞌvoꞌ jchiꞌiltic, maꞌsatetic. Cꞌalal iyaꞌiic ti tey ch-echꞌ ti Jesuse, iyaptaic: ―¡Cajval, smom David, cꞌuxubinoticotic! ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ti crixchanoetique ispajesic. ―¡Anchanic! ―xutic tajmec ti maꞌsatetique. Pero más to tsots iꞌavanic: ―¡Cajval, smom David, cꞌuxubinoticotic! ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Vaꞌ xi ti Jesuse. Iꞌalbatic ti acꞌu talicuque. ―¿Cꞌusi chajchaꞌleic un? ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","―Cajval, abulajan jambon li jsaticotique ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ti Jesuse iscꞌuxubin, ispicbe ti satique. Ora ijam ti satique, napꞌal italic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ti cꞌalal poꞌot xaꞌox xiyuloticotic liꞌ ta Jerusalene, tey liꞌechꞌoticotic tal ta tsꞌel Betfajé ta yoc vits Olivotic. Ti Jesuse istac echꞌel chaꞌvoꞌ jchiꞌilticotic ta yajchancꞌop. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","―Batanic leꞌ ta parajele. Tey noꞌox chucul chataic jcot meꞌburro xchiꞌuc yol. Jitunic, nitic tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi oy muchꞌu chasjacꞌbeic cꞌu yuꞌun ti chajitunic li burroe, xavalbeic ti voꞌon chtun cuꞌune. “Ta xtal noꞌox jsutesticotic ta ora”, xavutic ―xꞌutatic echꞌel yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jaꞌ icꞌot ti cꞌusi iyal ti yajꞌalcꞌop Riox ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jchiꞌiltactic, ta la xtal ti muchꞌu chispasotic ta mantale. Lec la yoꞌon, mu la snaꞌ stoy sba. Cajal la ta yol burro ch-och tal, xi onox ti yajꞌalcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ibat li chaꞌvoꞌe, ixchꞌunic ti cꞌusi iꞌalbatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Isnitic tal xchiꞌuc yol ti burroe. Iyacꞌbe stasin spimilcꞌuꞌic. Iscajlebin tal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ep tajmec ti muchꞌutic isqꞌui spimilcꞌuꞌic ta be yoꞌ bu iꞌechꞌ tal ti Jesuse. Jlom iscꞌasic yanal teꞌ, iyaqꞌuic ta be yuꞌun iyichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ti muchꞌutic babee xchiꞌuc ti muchꞌutic tijajtique, iꞌavan scotolic. ―¡Coliyalbotic Riox ti jaꞌ tal spasotic ta mantal li smom Davide! ¡Lec tajmec li preserente listacbotic tal ti Jtotic Riox ta vinajele! “Colaval, Cajval”, chiicuc uc ti anjeletic ta vinajele ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jaꞌ yech iꞌoch tal liꞌ ta Jerusalén ti Jesuse. Scotol ti muchꞌutic liꞌ ta yutil jteclume ―¿Muchꞌu leꞌe? ―xiic, xnechetic xa tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","―Jaꞌ li Jesuse, li yajꞌalcꞌop Rioxe ti liquem tal ta Nazaret ta estado Galileae ―xiic ti jchiꞌiltactic xchiꞌinojic tal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ti Jesuse ibat ta stemplo Riox. Isnuts loqꞌuel scotol ti jchonolajeletic tey ta tiꞌ mucꞌta temploe. Isbutqꞌuinbe smexaic ti jeltaqꞌuinetique. Isbutqꞌuinbe xilaic ti jchonpalomaetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","―“Li jnae jaꞌ scuenta chtal ataicon o ta cꞌoponel”, xi ti Rioxe, xi tsꞌibabil. Li voꞌoxuque snailchꞌen jꞌeleqꞌuetic xachaꞌleic ―xꞌutatic ti jchonolajeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tey icꞌot maꞌsatetic xchiꞌuc coxoetic ta tiꞌ templo yoꞌ bu ti Jesuse. Ti Jesuse isjambe sat ti maꞌsatetique, islecubtasbe yoc ti coxoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tey jayvoꞌ totil paleetic xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Iyilic ti cꞌusi ispas ti Jesuse. Iyaꞌiic ti tsots chcꞌopojic ti cꞌox cremotique: “Coliyalbotic Riox ti jaꞌ tal spasotic ta mantal li smom Davide”, xi ti cꞌoxetique. Icapic o ti moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","―¿Mi xavaꞌi cꞌusi chalic li cꞌox cremotique? ―xutic ti Jesuse. ―Xcaꞌi ―xi―. ¿Mi muc bu aqꞌuelojic yaꞌel ti jaꞌ yech tsꞌibabil ta scꞌop Rioxe: Li cꞌoxetique más lec chalic acꞌoplal, xi onox tsꞌibabil? ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ilocꞌ liꞌ ta Jerusalén ti Jesuse, ibat ta Betania. Tey ivay. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sob ta yocꞌomal isut tal noxtoc liꞌ ta Jerusalén ti Jesuse. Iviꞌnaj ta be. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iyil jtecꞌ icꞌux ta tiꞌil be, ba sqꞌuel mi oy sat, pero chꞌabal, naca noꞌox yanal. Ti Jesuse iyal ti mu xa bu tsatin oe. Ora itaquij. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cꞌalal iquilticotic li voꞌoticotique, xchꞌayet xa coꞌonticotic. ―¿Cꞌu yuꞌun itaquij ta ora li icꞌuxe? ―xichioticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","―Ta melel chacalbeic, mi chachꞌunic ti voꞌon chajcoltaique, mi mu xchibetuc avoꞌonique, tspas avuꞌunic li cꞌusitic vocol ta pasele; mu cꞌajomuc noꞌox tspas avuꞌunic chac cꞌu chaꞌal ijchaꞌle li icꞌuxe. Jaꞌ chac cꞌu chaꞌal mi chavalbeic ti acꞌu locꞌuc li vits liꞌi, ti acꞌu tꞌubuc ta mare, tspas avuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Scotol ti cꞌusi chacꞌanbeic ti Rioxe, mi jꞌechꞌel achꞌunojic ti chayacꞌbeique, ta onox xavichꞌic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ti Jesuse cꞌalal iyul ta tiꞌ mucꞌta templo liꞌ ta Jerusalene, lic chanubtasvanuc. Tey icꞌotic ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌoptique. ―¿Muchꞌu layalbe ti xꞌelan chapase? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","―Oy cꞌusi chajacꞌbeic uc. Mi chavalbecon ti cꞌusi chajacꞌbeique, chacalbeic ti muchꞌu liyalbe ti xꞌelan ta jpase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Muchꞌu ta smantal ti iyacꞌ ichꞌvoꞌ ti Juane? ¿Mi Riox, o mi crixchano? ―xꞌutatic yuꞌun ti Jesuse. Xalxalbe xa sbaic: ―Mi chcaltic ti ta smantal Rioxe, “¿cꞌu yuꞌun ti muc xachꞌunique cheꞌe?” xi biꞌa. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mi chcaltic ti ta smantal crixchanoe, xiꞌel sba. Yuꞌun li jchiꞌiltactique xchꞌunojic scotolic ti jaꞌ yajꞌalcꞌop Riox ti Juane ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yechꞌo un ―Mu jnaꞌticotic ―xiic. ―Jaꞌ yechon uc, mu xacalbeic ti muchꞌu liyalbe ti xꞌelan ta jpase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Cꞌusi chanopic? Caltic noꞌox yaꞌel ti oy chaꞌvoꞌ screm jun vinique. “Crem, batan ta abtel ta uvatic”, xut li june. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Mu jcꞌan xibat”, xi. Tsꞌacal to isnop ti chbate, ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Iyalbe li jun screm noxtoque. Jaꞌ noꞌox yech iyalbe chac cꞌu chaꞌal iyalbe li june. “Tot, chibat”, xi. Pero muc xbat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Li voꞌoxuque ¿cꞌusi chanopic? Li chaꞌvoꞌ cremotique ¿muchꞌu junucal ti ixchꞌunbe smantal li stotique? ―xꞌutatic yuꞌun ti Jesuse. ―Jaꞌ li muchꞌu baꞌyi iyichꞌ albele ―xiic. ―Ta melel chacalbeic, chavalic ti chopol tajmec li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li antsetic tol saꞌ yajmulique, pero jaꞌ xa ta xchꞌunic cꞌusi lec chil ti Rioxe. Voꞌoxuc ti mu xavichꞌic ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti Juan jꞌacꞌ-ichꞌvoꞌe jaꞌ tal yalboxuc ti cꞌusi tscꞌan chapasique, pero muc xachꞌunic. Li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li antsetic tol saꞌ yajmulique, jaꞌ ixchꞌunic. Iyictaic spasel li cꞌusitic chopole. Cꞌalal avilic ti iyictaic xae, li voꞌoxuque muc xachꞌunic noxtoc. Muc xavictaic spasel li cꞌusitic chopole ―xꞌutatic yuꞌun ti Jesuse―. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Aꞌyic me, chacalbeic yan loꞌil. Caltic noꞌox yaꞌel ti oy jun vinic istsꞌun ep uva ta yosile. Isjoy ta moc. Ixchꞌoj ton scuenta spitsꞌobil yaꞌlel. Ismeltsan jpꞌej toyol na scuenta sqꞌuelobil li uvae. Isaꞌ comel ti muchꞌutic ta xchabi li uvae. Ibat ta nom li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Ti cꞌalal itaꞌaje, istac tal yajꞌabteltac ti tscuchic echꞌel ti cꞌu yepal yaloj chichꞌe. Yul scꞌanbeic li muchꞌutic ta xchabiique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Li jchabiejꞌuvae istsaquic li yajꞌabteltac yajval osile. Li june ismajic, li june ismilic, li june iyacꞌbeic ton. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Li yajval osile istac tal yan yajꞌabteltac noxtoc, más to ep istac tal. Jaꞌ noꞌox yech ichaꞌleatic uc chac cꞌu chaꞌal ichaꞌleatic li muchꞌutic baꞌyi itaqueic tale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Tsꞌacal to istac tal screm li yajval osile. “Jaꞌ nan chichꞌic ta mucꞌ li jcreme”, xi isnop. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cꞌalal iyilic li jchabiejꞌuvae ti jaꞌ xa screm li yajval osile, “leꞌe jaꞌ xa chichꞌbe comel yosil li stote. Más lec jmiltic yoꞌ xquichꞌbetic o comel voꞌotic li yosile”, xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Isloqꞌuesic ta pat moc, ismilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ti cꞌalal sut tal li yajval uvae, ¿cꞌusi chul chaꞌleaticuc xanaꞌic li jchabiejꞌuvae? ―xut jmeltsanejcꞌopetic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","―Chmileic yuꞌun chopol li cꞌusi tspasique. Li yajval osile yan xa o muchꞌutic chacꞌbe xchabi li uvae. Jaꞌ tsaꞌ li muchꞌutic lec chaqꞌuic entrucal li uvae ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","―¿Mi muc bu aqꞌuelojic yaꞌel ta scꞌop Riox yoꞌ bu chal ti “coꞌol xchiꞌuc jpꞌej ton ti istꞌuj li yajval nae ti chacꞌ ta xchiquin snae, ti ipꞌaje yuꞌun li yajꞌalvaniltaque pero jaꞌ onox iꞌoch ta chiquin na. Jaꞌ noꞌox yech ti muchꞌu stꞌujoj ti Rioxe, acꞌu mi xpꞌaje pero chichꞌ onox tsots yabtel. Lec tajmec ti xꞌelan tspas ti Rioxe”, xi tsꞌibabil? ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yechꞌo un chacalbeic, iꞌechꞌ xa yoꞌon ti chayalbeic mantal ti Rioxe. Jaꞌ xa ch-albatic mantal ti muchꞌutic tspasic cꞌusitic lec chil ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ti muchꞌu tsots chcꞌot ta ba tone, chyayij. Mi jaꞌ netꞌbil icꞌote, ta xcham o. Voꞌon li tonon yaꞌele. Ti muchꞌutic mu xiyichꞌic ta muqꞌue, voꞌon chcalbeic ti ch-ochic ta cꞌocꞌ ta sbatel osile ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ti totil paleetique xchiꞌuc ti jfariseoetique, cꞌalal iyaꞌiic cꞌu xꞌelan iloꞌilaj ti Jesuse, iyul ta sjolic ti jaꞌ scꞌoplalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Isnopic cꞌuxi ta staic ta tsaquel ti Jesuse pero xiꞌemic. Yuꞌun ti yan jchiꞌiltactique xchꞌunojic ti jaꞌ yajꞌalcꞌop Riox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ti Jesuse iyalbe yan loꞌil ti jchiꞌiltactique: ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Chacalbeic cꞌu xꞌelan tspas mantal ti Rioxe. Caltic noꞌox yaꞌel ti oy jun preserente ti tsnupultas screme. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Istac echꞌel smozotac, ba yiqꞌuic tal ti muchꞌutic yalojbe xa onox ti chtal ta nupunele. Pero muc xtalic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Istac echꞌel yan smozotac noxtoc. “Ba albeic li muchꞌutic calojbe xa onox ti chtalique: Liꞌ listac tal li cajvale. Batanic la ta nupunele. Chapal xa li veꞌlile. Milbil xa li vacaxetique xchiꞌuc li yan stsꞌunubtac ti lec jupꞌemique, xavutic cꞌotel”, xut echꞌel li smozotaque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ti muchꞌutic tacbil ta iqꞌuele muc xchꞌunic. Jaꞌ noꞌox ba spasic ti cꞌusi tscꞌan yoꞌonique. Li june ba sqꞌuel cꞌusitic stsꞌunoj. Li june ba chonolajuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Li jlome istsaquic li smozotac preserentee, ismajic, ismilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ti cꞌalal iyaꞌi li preserentee, icap o tajmec. Istac echꞌel yajsolterotac, ba smilel li muchꞌutic imilvane. Ixchicꞌbeic noxtoc li steclumalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Li preserentee iyalbe li yan smozotaque: “Chapal xa li cꞌusitic chtun ta nupunele, pero ti muchꞌutic jtacoj ta iqꞌuele mu xchꞌunic tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Batanic ta bebetic. Iqꞌuic tal li muchꞌutic chataique, jaꞌ acꞌu talicuc ta qꞌuin”, xut echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ilocꞌ echꞌel li smozotaque, ibatic ta bebetic. Iyiqꞌuic tal li muchꞌutic istaic ta bee. Tey capal italic li muchꞌutic chopol sjole xchiꞌuc li muchꞌutic lec yoꞌone. Noj icꞌot ta crixchano sna li preserentee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Li preserentee och scꞌopon li crixchanoetique. Iyil jun vinic ti maꞌuc slapoj li cꞌuꞌul scuenta nupunele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Li voꞌote, ¿cꞌuxi laꞌoch tal? Yuꞌun maꞌuc alapoj li cꞌuꞌul scuenta nupunel ti cacꞌoj scꞌoplal chalape”, xut. Li vinique muc xtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Li preserentee iyalbe li smozotaque: “Chucbeic yoc scꞌob li vinique. Aqꞌuic echꞌel ta icꞌ osil. Tey xꞌoqꞌuelet, xcꞌuxuxet o ye yuꞌun tsots li castico chichꞌe”, xi li preserentee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jaꞌ seña ti chicꞌ scotol crixchanoetic ti Rioxe pero muc scotolicuc scꞌanic pasel ta mantal. Jaꞌ noꞌox scꞌanic pasel ta mantal ti muchꞌutic stꞌujoj chtunic yuꞌune ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ti jfariseoetique ba snopic cꞌusi tsjacꞌbeic ti Jesuse yoꞌ xaꞌiic o ti cꞌu xꞌelan chtacꞌave, yoꞌ stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Istaquic tal yajchancꞌopic xchiꞌuc svinictac Erodes. ―Jchanubtasvanej, jnaꞌojticotic ti yech scotol li cꞌusi chavale. Jamal chaval cꞌusi tscꞌan Riox ti ta jpasticotique. Mu tꞌujbiluc chachaꞌle ti muchꞌu chavalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Alo caꞌiticotic cꞌusi chanop. ¿Mi lec chil xanaꞌ ti Rioxe ti chcacꞌbeticotic tojel aqꞌuel ti preserente Césare, o mi chopol chil? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ti Jesuse iyil ti oy smanyaique. ―¿Cꞌu yuꞌun ti xꞌelan tal avalbecone? Mu xa xanaꞌ yilel xachaꞌle abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Acꞌbecon quil jsepuc taqꞌuin ti chcacꞌtic ta tojel aqꞌuele ―xꞌutatic. Iyacꞌbeic yil jun denario. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","―¿Muchꞌu slocꞌol liꞌi? ¿Muchꞌu sbi? ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―César ―xiic. ―Jaꞌ tscꞌan chavacꞌbeic ti cꞌusi tscꞌan ti preserente Césare. Jaꞌ noꞌox yech tscꞌan chavacꞌbeic ti cꞌusi tscꞌan ti Rioxe ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ti cꞌalal iyaꞌiic ti xꞌelan itacꞌav ti Jesuse, xchꞌayet xa yoꞌonic sutel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta jliquel o tey icꞌotic jayvoꞌ jsaduceoetic yoꞌ bu ti Jesuse, jaꞌ li muchꞌutic chalic ti mu xa xichaꞌcuxiotic ti cꞌalal xichamotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Jchanubtasvanej, stsꞌibaoj comel ti Moisese ti mi icham junuc vinique, mi chꞌabal screm icome, li itsꞌinale mi chꞌabal to yajnile, acꞌu yicꞌbe yajnil ti ánima sbanquile. Mi iꞌayan screme, jaꞌ yech chacꞌbe sbi chac cꞌu chaꞌal sbi ti ánima sbanquile yoꞌ mu xchꞌay o sbie, xi ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oy toꞌox vucvoꞌic, sbanquil yitsꞌin sbaic. Ti banquilale isaꞌ yajnil, pero icham. Chꞌabal xchꞌamal icom. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ti itsꞌinale iyicꞌbe yajnil ti ánima sbanquile pero icham uc. Chꞌabal xchꞌamal icom uc. Jaꞌ noꞌox yech ispas ti yoxvaꞌal itsꞌinale. Svucvaꞌalic iyiqꞌuic ti antse pero muc xꞌayan xchꞌamalic junuc ti cꞌalal ichamique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tsꞌacal to icham ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mi ichaꞌcuxiique, ¿muchꞌu onovan junucal ti chiqꞌue yuꞌun iyicꞌ svucꞌvaꞌalic? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Itacꞌav ti Jesuse: ―Li voꞌoxuque mu xanaꞌic li cꞌusi chavalique yuꞌun mu xanaꞌic cꞌusi chal li scꞌop Rioxe. Mi jaꞌuc xanaꞌic cꞌu xꞌelan syuꞌel ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ti cꞌalal xchaꞌcuxiic ti muchꞌutic chbatic ta vinajele, mi antsuc, mi vinicuc, mu xa bu chicꞌ sbaic. Yuꞌun mu xa snaꞌ xchamic. Coꞌolic xa xchiꞌuc anjeletic ta vinajel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lavi mu xachꞌunic ti ta xchaꞌcuxiic ti ánimaetique, ¿mi muc bu aqꞌuelojic yaꞌel ti cꞌu xꞌelan iyalbe scꞌoplal Abraam, xchiꞌuc Isaac, xchiꞌuc Jacov ti Rioxe? ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Voꞌon Yajvalicon ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove”, xi. Ti xꞌelan iyale, yuꞌun cuxajtic ch-ileic yuꞌun ti Rioxe acꞌu mi voꞌne xa xchamelic ti moletique. Ti Rioxe jaꞌ yajvalic ti muchꞌutic cuxajtic ta sbatel osile. Li voꞌoxuque chamem xchiꞌuc xchꞌulelic ti avalojique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ti cꞌalal iyaꞌiic ti jchiꞌiltactique ti xꞌelan iyal ti Jesuse, xchꞌayet xa yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ti cꞌalal iyaꞌi ti jfariseoetique ti mu xa snaꞌic cꞌuxi chtacꞌavic ti jsaduceoetique, istsob sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tey jun jfariseo, jchanubtasvanej yilel ta smantaltac Riox. Oy cꞌusi isjacꞌbe ti Jesuse yoꞌ stabe o smul ti yaloje: ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Jchanubtasvanej, ta scotol li smantaltac Riox ti iyal ti Moisese, ¿cꞌusi jtosucal ti más tsotse? ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Itacꞌav ti Jesuse: ―“Cꞌanic me ta sjunul avoꞌonic ti Rioxe. Jaꞌ acꞌu tunuc yuꞌun lapꞌijilique”, xi li mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Leꞌe jaꞌ más tsots. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Li xchibale tsots noxtoc. “Cꞌuxubino me achiꞌiltac chac cꞌu chaꞌal chacꞌuxubin aba atuque”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Xchibal li mantal lacalbee jaꞌ smacoj scotol li smantaltac Rioxe xchiꞌuc ti cꞌusitic iyalic ti yajꞌalcꞌoptac Riox ti ta voꞌnee ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ti cꞌalal tey tsobolic ti jfariseoetique, ijacꞌbatic yuꞌun ti Jesuse: ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Cꞌusi chanopic? Ti Cristoe, ti muchꞌu stꞌujoj Riox tspasvan ta mantale, ¿muchꞌu ti smucꞌtatot ti ta voꞌnee? ―xut. ―Jaꞌ ti Davide ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","―Mi jaꞌ mucꞌtatotile, ¿cꞌu yuꞌun ti “Cajval”, xi ti Davide? Ti Davide ipꞌijubtasat yuꞌun ti Chꞌul Espíritue, jaꞌ yech istsꞌiba chac liꞌi: ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ti Cajvale iꞌalbat yuꞌun ti Rioxe: “Chachoti ta jbatsꞌicꞌob, chapas mantal ti cꞌu sjalil xchꞌun o amantal cuꞌun scotol lacrontae”, xꞌutat, xi ti Davide. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ti Davide “Cajval”, xut ti muchꞌu stꞌujoj Riox tspasvan ta mantale. ¿Cꞌu yuꞌun “Cajval”, xut mi jaꞌ smom noꞌoxe? ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mi jun muc xtacꞌavic. Mu xa cꞌusi isjaqꞌuic o. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ti Jesuse liyalboticotic, voꞌoticotic li yajchancꞌopoticotique, xchiꞌuc ti jchiꞌiltactic tey tsobolique: ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Li muchꞌutic ta xchanubtasvanic ta smantal Rioxe xchiꞌuc li jfariseoetique, jaꞌ icom ta sbaic li smantaltac Riox ti iyal ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yechꞌo un chꞌunic me li scꞌop Riox chayalbeique, pero mu xapasic yech chac cꞌu chaꞌal ta spasique. Yuꞌun maꞌuc yech tspasic chac cꞌu chaꞌal ta xchanubtasvanique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Coꞌol xchiꞌuc chpechꞌic icatsil ti vocol chlic ta cuchele. Voꞌoxuc noꞌox chacꞌ acuchic; li stuquique mu xlic yuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Scotol li cꞌusi tspasique jaꞌ noꞌox yoꞌ lec xꞌileic o yuꞌun li crixchanoetique. Li scꞌoxꞌav smantal Rioxe más mucꞌ spasojic. Lec chaꞌiic ti xtolet scꞌuꞌic cꞌalal yoquique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jaꞌ tscꞌanic ti bail ta xchotiic jujun qꞌuine, ti bail ta xchotiic ta temploetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jaꞌ tscꞌanic ti cꞌoponbilic ta chꞌivite, ti “jchanubtasvanej” xꞌutatique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Li voꞌoxuque mu me jaꞌuc xacꞌanic ti “jchanubtasvanej” xaꞌutatique yuꞌun jun noꞌox lavajchanubtasvanejique, jaꞌ li voꞌone ti yaloj Riox chajpasic ta mantale. Li voꞌoxuque coꞌoloxuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Muc muchꞌu xapꞌis ta atotic liꞌ ta sba balamile. Jun noꞌox li Jtotique, jaꞌ ti Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mu me jaꞌuc xacꞌanic ti chayajvalinic li yan achiꞌilique yuꞌun jun noꞌox lavajvalique, jaꞌ li voꞌone ti yaloj Riox chajpasic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ti muchꞌu tscꞌan ti ichꞌbil ta muqꞌue, jaꞌ tscꞌan ti mu jtoybailuque, ti sjunul yoꞌon chtun avuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yuꞌun li muchꞌu ta stoy sbae ch-aqꞌue ta qꞌuexlal yuꞌun ti Rioxe. Yan li muchꞌu mu snaꞌ stoy sbae, ch-aqꞌue ta ichꞌel ta mucꞌ yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Mu xacꞌanic pasel ta mantal yuꞌun ti Rioxe, yechꞌo ti chapajesic li muchꞌutic scꞌanic pasel ta mantal yuꞌun ti Rioxe. Yechꞌo un ta onox xavichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Yech noꞌox ti jal chacꞌoponic Rioxe, chaloꞌlobeic to cꞌusuc yuꞌun li meꞌanal antsetique. Yechꞌo un más castico chavichꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Chalubtsan abaic ta saꞌel mi oy bu xata junuc avajchancꞌopic. Mi ataique, más to tsoc sjol avuꞌunic. Voꞌoxuc ta amulic ti chba yichꞌic castico ta cꞌoqꞌue. Yechꞌo un ta onox xavichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Li voꞌoxuque yech chanopic ti chavaqꞌuic iluc cꞌusitic lec chil ti Rioxe, yechꞌo un ta onox xavichꞌic castico ta sbatel osil. Yuꞌun jaꞌ yech chavalic: “Ti muchꞌu tsvaꞌan ta rextico li mucꞌta temploe, mu persauc spas li cꞌusi chale. Yan ti muchꞌu tsvaꞌan ta rextico li oro tey ta mucꞌta temploe, jaꞌ persa tspas li cꞌusi chale”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sonsooxuc. Coꞌoloxuc xchiꞌuc maꞌsat. Jaꞌ mu másuc tsots scꞌoplal li oroe; jaꞌ más tsots scꞌoplal li mucꞌta templo yoꞌ bu tiqꞌuil li oroe yuꞌun jaꞌ tey chmilbat smoton ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jaꞌ yech chavalic noxtoc: “Ti muchꞌu tsvaꞌan ta rextico li xchicꞌobil smoton Rioxe, mu persauc spas li cꞌusi chale. Yan ti muchꞌu tsvaꞌan ta rextico li smoton Riox ti tey ta xchiqꞌuee, jaꞌ persa tspas li cꞌusi chale”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sonsooxuc. Coꞌoloxuc xchiꞌuc maꞌsat. Jaꞌ mu másuc tsots scꞌoplal li smoton Rioxe; jaꞌ más tsots scꞌoplal li xchicꞌobile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ti muchꞌu tsvaꞌan ta rextico li xchicꞌobil smoton Rioxe, jaꞌ xa yajrextico noxtoc li smoton Riox ti tey ta xchiqꞌuee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jaꞌ noꞌox yech noxtoc ti muchꞌu tsvaꞌan ta rextico li mucꞌta temploe, jaꞌ xa yajrextico noxtoc ti Rioxe yuꞌun tey. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ti muchꞌu tsvaꞌan ta rextico li vinajele jaꞌ xa yajrextico noxtoc li smucꞌta chotleb Rioxe, xchiꞌuc ti Riox tey chotole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Chanitic ta lajlajuneb li cꞌusitic chlocꞌ avuꞌunique: li alavenae, xchiꞌuc li anise, xchiꞌuc li cominoe. Chaloqꞌuesic jujun ti cꞌalal anitojic xaꞌox ta lajlajunebe, chavacꞌbeic ti Rioxe. Ti avalojique, jaꞌ noꞌox tsots scꞌoplal ti chachꞌunic leꞌe. Jaꞌ xuꞌ mu xachꞌun chavaꞌiic ti bu tsots scꞌoplale, ti tscꞌan lec chameltsanic cꞌope, ti chacꞌuxubinvanique, ti yech li cꞌusitic chavalique. Yechꞌo un ta onox xavichꞌic castico ta sbatel osil. Más lec ti apasicuc noxtoc ti bu tsots scꞌoplale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yech noꞌox ti chachanubtasvanique, mu xavaꞌi abaic ti muc bu chꞌunem avuꞌunic uc ti bu tsots scꞌoplale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe, yechꞌo un ta onox xavichꞌic castico ta sbatel osil. Coꞌoloxuc xchiꞌuc li muchꞌu jaꞌ noꞌox tspocbe spat li basoe xchiꞌuc li pulatue, yan li yute mu sucꞌ, oy yicꞌubal. Jaꞌ yech lecoxuc yilel, pero jaꞌ noꞌox ta avoꞌonic ti cꞌusi oy lec yuꞌun lachiꞌilique. Chavalbeic ti acꞌu yaqꞌuic ta smoton Rioxe yuꞌun anaꞌojic ti voꞌoxuc chavichꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Li voꞌoxuque, jfariseoetic, coꞌoloxuc xchiꞌuc maꞌsat. Ictaic spasel li cꞌusitic chopole, jaꞌ pasic li cꞌusitic lec chil ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe, yechꞌo un ta onox xavichꞌic castico ta sbatel osil. Coꞌoloxuc xchiꞌuc muquenal ti sacpꞌejan xae, leclec sba yilel, pero li yute noj ta baquel ánima xchiꞌuc li cꞌusitic tey cꞌaꞌeme. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jaꞌ yech lec avoꞌonic yilel pero yech noꞌox. Yuꞌun chanopic cꞌop, chapasic li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe, yechꞌo un ta onox xavichꞌic castico ta sbatel osil. Yuꞌun voꞌoxuc chachaꞌmeltsanbeic chachaꞌbonbeic smuquenal ti yajꞌalcꞌoptac Riox ti ta más voꞌnee ti lec yoꞌonique, pero mu xachꞌunic ti iyalic jcꞌoplale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yech noꞌox ti chavalbeic li crixchanoetique: “Ti liꞌoticoticuc xaꞌox cꞌalal iꞌechꞌic ta balamil ti voꞌne moletique, muc bu ijticꞌ jbaticotic ta smilel ti yajꞌalcꞌoptac Riox ti yechuque”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jaꞌ chvinaj o ti coꞌol ajolic xchiꞌuc ti amucꞌtatotique ti ismilic ti yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Voꞌoxuc xa chatsꞌacubtasic ti cꞌusitic ispasic ti amucꞌtatotic ti ta voꞌnee yuꞌun poꞌot xa xamilicon uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Ti amucꞌtatotic ti ta voꞌnee coꞌolic xchiꞌuc quiletel chon. Jaꞌ yechoxuc uc. Mu xuꞌ chapoj abaic, persa onox chba avichꞌic castico ta cꞌocꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ta jtac tal cajꞌalcꞌoptac ti snaꞌic cꞌusi tscꞌan ti Rioxe. Jlom chamilic, jlom chajipanic ta cruz, jlom chavacꞌbeic arsial ta yut temploetic, chanutsic loqꞌuel ta jujun jteclum liꞌ ta alumalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ti Rioxe voꞌoxuc chacꞌ ta abaic ti jayvoꞌ imileic tal ti muchꞌutic lec yoꞌonique. Ti cꞌalal imile ti Abel lec yoꞌone, cꞌalal to Zacarías ti screm Berequíase, ti ismilic ta tiꞌ mucꞌta templo yoꞌ bu stsꞌel xchicꞌobil smoton Rioxe, voꞌoxuc chcom ta abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ta melel chacalbeic, voꞌoxuc ti cuxuloxuc lavie, voꞌoxuc chcom ta abaic scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Li voꞌoxuque xchiꞌuc lachiꞌiltac liꞌ ta Jerusalene, jaꞌ amanyaic ti chamilic li yajꞌalcꞌoptac Rioxe. Chavacꞌbeic ton li muchꞌutic chastacbeic tal ti Rioxe. Pero oy xa jayꞌechꞌel ti coꞌonuc jtsoboxuc chac cꞌu chaꞌal tslutsꞌ yol li meꞌchꞌeque, pero muc xacꞌanic tsobel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Toj abol aba chacomic yuꞌun mu xa bu chaxchiꞌinic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chacalbeic ti mu xa bu chavilicon oe. Jaꞌto ti cꞌalal xavalic ti “toj lec tajmec li muchꞌu itaque tal yuꞌun ti Rioxe”, xachiique, jaꞌto chavilicon noxtoc ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Cꞌalal chilocꞌoticotic xaꞌox ta stiꞌil smacol mucꞌta templo liꞌ ta Jerusalén xchiꞌuc ti Jesuse, icacꞌbeticotic yil ti lec tajmec meltsanbil li temploe xchiꞌuc li naetic ta sjoyobe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","―Lequic avaꞌuquicaꞌa. Ta melel chacalbeic, ta sta yora ti ta xlomesate. Busul chcom scotol ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ti cꞌalal tey chotol ta vits Olivotic ti Jesuse, ijacꞌbeticotic: ―Alo caꞌiticotic cꞌusi ora ta xlomesat li templo avale. ¿Cꞌusi seña ti cꞌalal poꞌot xaꞌox xachaꞌsut tale? ¿Cꞌusi seña ti cꞌalal poꞌot xaꞌox xlaj li balamile? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","―Pꞌijanic me, mu me xachꞌunic loꞌloel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yuꞌun ep ti muchꞌutic chtale, “voꞌon Cristoon”, xiic. Ep ti muchꞌutic ta xchꞌunic loꞌloele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti cꞌalal chavaꞌiic ti oy acꞌ cꞌoqꞌue, ti cꞌalal chavaꞌiic ti chlic acꞌ cꞌocꞌ ta nome, mu me xaxiꞌic. Chcꞌot onox yech, pero li balamile maꞌuc toꞌox chlaj. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta sliquesic acꞌ cꞌocꞌ li crixchanoetic ta yantic o balamile. Ta sliquesic acꞌ cꞌocꞌ li preserenteetic noxtoque. Oy bu ch-echꞌ chamel, oy bu ch-echꞌ viꞌnal. Oy bu ch-echꞌ tsots niquel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Taje sliqueb to vocol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Oy chaꞌiqꞌueic echꞌel ta stojol jmeltsanejcꞌopetic, chaꞌilbajinatic. Jlom chamilatic. Ep crixchanoetic chopol chilic ti avichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cꞌalal chlic ilbajinele, ep muchꞌutic chicta o sbaic. Ti muchꞌutic chicta o sbaique chopol chilic ti muchꞌutic mu xicta sbaique. Jaꞌ xa tstiqꞌuic cꞌop ti acꞌu tsacaticuc ti muchꞌutic mu xicta sbaique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta to xtalic ep ti muchꞌutic chalic yilel li scꞌop Rioxe. Ep ti muchꞌutic ta xchꞌun yuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ch-epaj li cꞌusitic chopole, ep ti muchꞌutic mu xa xcꞌuxubinvanique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ti muchꞌutic chcuch yuꞌunic li ilbajinele, mi mu xicta o sbaique, jaꞌ chcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Baꞌyi onox chvinaj ta sjunlej balamil ti ista xa yora tspasvan ta mantal ti Rioxe. Mi ivinaje, jaꞌ xa o chlaj li balamile ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Ti chajtsꞌibabeic liꞌi, jaꞌ yoꞌ xachꞌunic o ti cꞌusi liyalboticotic ti Jesuse. ―Voꞌoxuc ti liꞌ nacaloxuc ta Judeae, ti cꞌalal xavilic ti vaꞌanbil ta yut templo li cꞌusi mu scꞌan ti Rioxe chac cꞌu chaꞌal iyal onox ti Daniel yajꞌalcꞌop Riox ti ta voꞌnee, yechꞌo un ba nacꞌ abaic ta vitstic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lavi pachꞌal li sba anaique, mi jaꞌo oy muchꞌu tey xvaꞌete, ti cꞌalal xyal tale, mu xa me xꞌoch stam cꞌusuc yuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ti muchꞌutic tey ta yabtele, mu xa me yaꞌuc sut stam spimilcꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Abol sbaic tajmec ti muchꞌutic oy xchꞌute xchiꞌuc ti muchꞌutic ta xchuꞌun to yolique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cꞌoponic Riox ti mu me jaꞌuc o tol sic, ti mu me jaꞌuc o scꞌacꞌalil chacuxic ti cꞌalal xajatavique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yuꞌun tsots tajmec li castico ta xtale. Muc bu xꞌechꞌ o yech ta spasel balamil, jaꞌto chtal. Ti cꞌalal xꞌechꞌe, mu xa bu chtal noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti Rioxe xchꞌacoj ti cꞌu sjalil li casticoe. Ti jaluc tajmeque, chalaj acotolic ti yechuque. Ti mu jaluc li casticoe, jaꞌ ta scuentaic ti muchꞌutic stꞌujoje ti xchꞌunojbeic li scꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’“Leꞌ xa li Cristoe”, “taj xa li Cristoe”, mi oy muchꞌu xayutique, mu me xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yuꞌun chtalic ti muchꞌutic tspꞌis sbaic ta Cristoe xchiꞌuc ti muchꞌutic chalic yilel li scꞌop Rioxe. Chaqꞌuic iluc syuꞌelic yoꞌ xchꞌunic o loꞌloel li crixchanoetique. Yoꞌonuc sloꞌloic uc li muchꞌutic stꞌujoj ti Rioxe, pero mu xa xchꞌunic loꞌloel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Li voꞌoxuque pꞌijanic me, baꞌyi me lacalbeic scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tey xa ta xocol balamil li Cristoe”, mi oy muchꞌu xayutique, mu me xba aqꞌuelic. “Tey xa ta yut na”, mi oy muchꞌu xayutic noxtoque, mu me xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ti cꞌalal xichaꞌsut tal voꞌon ti coꞌol crixchanootique, chiyilic scotol crixchanoetic chac cꞌu chaꞌal xlebluj chavuc chquiltic ti buyotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chichꞌic onox castico ti muchꞌutic mu xiyichꞌic ta muqꞌue. Coꞌol xchiꞌuc cꞌusi xcham, tey ta stsob sba xulemal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ti cꞌalal xlaj echꞌuc scotol li castico lacalbeique, jaꞌo chmac sat li cꞌacꞌale, chꞌabal xa li jchꞌulmeꞌtique. Li cꞌanaletique jupꞌejtic chpꞌaj. Chnic scotol li cꞌusitic oy ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jaꞌo chil scotol crixchanoetic ti chiyal tal voꞌon ti coꞌol crixchanootique. Scotol crixchanoetic ta sjunlej balamil ch-oqꞌuic ta xiꞌel. Yuꞌun chilic ti oy jyuꞌele, ti oy jxojobal ti cꞌalal xiyal tal ta ba toc ta balamil, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsots ch-ocꞌ corneta noxtoc, jaꞌo ta xyalic tal cajꞌanjeltac. Jaꞌ chtal stsobic ta sjunlej balamil ti muchꞌutic jtꞌujoje ti xchꞌunojic cꞌusi caloje. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Naꞌic me, cꞌalal xavilic ti chlaj xa cocojuc yanal li icꞌuxe, jaꞌ chvinaj o ti ch-och xa voꞌtique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaꞌ noꞌox yech ti cꞌalal xavilic ti chlaj cꞌotuc li cꞌusitic icale, jaꞌ chvinaj o ti chichaꞌsut xa tale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ta melel chacalbeic, oy toꞌox cuxuloxuc jlom ti cꞌalal xtal ti jaytos castico lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Li vinajel balamile chlaj onox. Yan li cꞌusitic chcale, mu xchꞌay, persa chcꞌot scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Muc muchꞌu snaꞌ ti cꞌusi ora chichaꞌsut tale, mi jaꞌuc ti anjeletic ta vinajele, mi voꞌonicon mu jnaꞌ. Stuc noꞌox snaꞌoj ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Jaꞌ chac cꞌu chaꞌal ispas ti crixchanoetic ti ta más voꞌnee ti cꞌalal liꞌ toꞌox ti Noee, jaꞌ noꞌox yech tspasic uc ti cꞌalal sta yora chichaꞌsut tal, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cꞌalal mu toꞌox chtal ti nojele, jun yoꞌon iveꞌic, iyuchꞌic voꞌ, islajesic scotol ti cꞌusi scꞌan yoꞌonique, inupunic, iyacꞌ ta nupunel stsebic. Ti cꞌalal ital ti nojele, cꞌalal iꞌoch ta barco ti Noee, icom ti cꞌusitic ispasique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Muc xchꞌunic ti chtal nojele. Jaꞌto ixchꞌunic cꞌalal itale, pero muc xa xcolic, icham scotolic. Jaꞌ noꞌox yech cꞌalal xichaꞌsut tal, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mi oy chaꞌvoꞌ vinic ti tsobol ch-abtejique, yicꞌal jun chquicꞌ echꞌel, jun chcom. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mi oy chaꞌvoꞌ ants ti tsobol chjuchꞌunique, yicꞌal jun chquicꞌ echꞌel, jun chcom. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ichꞌicon noꞌox me ta mucꞌ, malaicon, yuꞌun mu xanaꞌic cꞌusi ora chichaꞌsut tal, voꞌon lavajvalicone. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Chacalbe avaꞌiic, ti anaꞌojicuc ti jayib ora acꞌubal chtal li jꞌeleqꞌue, amala, achabi ana ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaꞌ noꞌox yech tscꞌan chamalaicon noꞌox acꞌu mi mu xanaꞌic cꞌusi ora chichaꞌsut tal, voꞌon ti coꞌol crixchanootique. Mu me chꞌayemuc avoꞌonic chul jtaoxuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Caltic noꞌox yaꞌel ti oy jun jꞌabtel ti sjunul yoꞌon ch-abteje, ti snaꞌ stucꞌulan abtele. Jaꞌ ch-acꞌbat smacꞌlin li xchiꞌiltac ta abtele ti cꞌalal sta yora veꞌebale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jun yoꞌon li jꞌabtele ti yolel ch-abtej chul stael yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta melel chacalbeic, ti muchꞌu sjunul yoꞌon ch-abteje ch-acꞌbat scuentain li cꞌusuc yuꞌun yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yan mi chopol sjol li jꞌabtele, “mu to nan xtal li cajvale”, xi tsnop. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chlic yut, chlic smaj li xchiꞌiltac ta abtele. Jaꞌ chba xchiꞌin ta veꞌel ta uchꞌ pox li jyacubeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Li yajvale jaꞌo chul tal ti cꞌalal chꞌayem yoꞌon cꞌusi ta xchaꞌle li xchiꞌiltaque yuꞌun mu xchꞌun ti poꞌot xa xule. ");
INSERT INTO tzoZNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chul acꞌbatuc tsots castico yuꞌun li yajvale. Coꞌol chichꞌ castico xchiꞌuc ti muchꞌutic yichꞌojic ta mucꞌ Riox ti ta alele. Tey xꞌoqꞌueletic, xcꞌuxuxet o yeic yuꞌun tsots castico chichꞌic ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ti Jesuse iyal jun loꞌil noxtoc. ―Chacalbeic cꞌu xꞌelan ti cꞌalal xtal jpas mantale. Caltic noꞌox yaꞌel ti oy lajunvoꞌ tojol tsebetic ti ba snupic tal ta be li jnupunele. Iyichꞌ echꞌel scꞌoqꞌuic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Li voꞌvoꞌe lec pꞌijic; li voꞌvoꞌe sonsoic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Li sonso tsebetique jaꞌ noꞌox iyichꞌ echꞌel ti cꞌu yepal chꞌolol yaceiteal li scꞌoqꞌuique, muc xichꞌbeic echꞌel más. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Li pꞌijil tsebetique isnojesbe echꞌel yaceiteal li scꞌoqꞌuique, iyichꞌic to echꞌel más. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Li jnupunele muc xtal ta ora. Li tsebetique iꞌoch svayelic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ta ol acꞌubal iꞌaptaatic: “Chtal xa li jnupunele. Ba nupic tal ta be”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ora ijulavic li tsebetique. Ixchꞌolbeic más yaceiteal li scꞌoqꞌuique, istsanic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Acꞌbon jsetꞌuc avaceiteic yuꞌun chtupꞌ xa li jcꞌocꞌticotique”, xiic li sonso tsebetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Iꞌi. Yicꞌal mu xlocꞌ o cuꞌunticotic uc. Ba manic tal”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ti cꞌalal ba smanic tale, jaꞌo iyul li jnupunele. Li tsebetic ti chapajtique tsobol iꞌochic xchiꞌuc jnupunel. Li yajval nae ismac li stiꞌ snae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsꞌacal to iyulic li yan tsebetique. “Cajval, Cajval, jamboticotic li stiꞌ anae, chiꞌochoticotic tal uc”, xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ta melel chacalbeic, muc bu chajambeic stiꞌ jna yuꞌun muc xachꞌunic ti cꞌusi icale. Coꞌol xchiꞌuc mu xacojtiquinic”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Jaꞌ noꞌox yech li voꞌoxuque, tscꞌan ti chamalaicon noꞌoxe yuꞌun mu xanaꞌic cꞌusi ora chichaꞌsut tal, voꞌon ti coꞌol crixchanootique. Mi ta sob, o mi ta xmal, o mi ta acꞌubaltic, mu xanaꞌic cꞌusi ora ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ti Jesuse iyal jun loꞌil noxtoc. ―Chacalbeic cꞌu xꞌelan ti cꞌalal xtal jpas mantale. Caltic noꞌox yaꞌel ti oy jun vinic ibat ta nome. Ti cꞌalal mu toꞌox chbate, istsob li yajꞌabteltaque. Iyacꞌbe comel sliqueb jujun. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Li june iꞌacꞌbat voꞌmil, li june iꞌacꞌbat chaꞌmil, li june iꞌacꞌbat jmil. Li muchꞌu pꞌije ep iꞌacꞌbat. Yan li muchꞌu sonsotic noꞌoxe jutuc iꞌacꞌbat. Ti cꞌalal laj yacꞌ comel staqꞌuin li vinique, jaꞌo ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Li muchꞌu iꞌacꞌbat voꞌmile lic equelajuc o, ijolin yuꞌun voꞌmil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jaꞌ noꞌox yech li muchꞌu iꞌacꞌbat chaꞌmile, ijolin yuꞌun chaꞌmil uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yan li muchꞌu jmil noꞌox iꞌacꞌbate isnacꞌ, ismuc ta balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Jal iꞌay li yajvalique. Ti cꞌalal isut tale, istsob li yajꞌabteltaque. “¿Cꞌusi yepal ijolin avuꞌunic li jtaqꞌuine?”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jaꞌ baꞌyi ital li muchꞌu iyichꞌ comel voꞌmile, yichꞌoj tal noxtoc li voꞌmil sjole. “Totic, liꞌ li voꞌmil ataqꞌuin avacꞌbon comele xchiꞌuc voꞌmil ijolin cuꞌun”, xut li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Chquichꞌ cheꞌe. Li voꞌote lec xanaꞌ xaꞌabtej. Jutuc ti lacacꞌbee pero sjunul avoꞌon laꞌabtej o. Lavie chacacꞌbe más. Laꞌ jchiꞌin o jbatic yoꞌ jun o avoꞌon ta sbatel osile”, xꞌutat yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ital li muchꞌu yichꞌoj chaꞌmile. “Totic, liꞌ li chaꞌmil ataqꞌuin avacꞌbon comele xchiꞌuc chaꞌmil ijolin cuꞌun”, xut li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Chquichꞌ cheꞌe. Li voꞌote lec xanaꞌ xaꞌabtej uc. Jutuc ti lacacꞌbee pero sjunul avoꞌon laꞌabtej o. Lavie chacacꞌbe más uc. Laꞌ jchiꞌin o jbatic yoꞌ jun o avoꞌon ta sbatel osile”, xꞌutat yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ital li muchꞌu jmil noꞌox yichꞌoje. “Totic, jnaꞌoj ti jlajelote. Jnaꞌoj ti chavichꞌbe xchiꞌuc sjol lataqꞌuine. Chavichꞌ ti bu muc bu avacꞌoj avocole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yechꞌo un lixiꞌ mi xchꞌay cuꞌun lataqꞌuine, solel ijmuc ta balamil. Ichꞌo sutel yuꞌun avuꞌun onox”, xut li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mu xatun, chꞌajot tajmec. Chaval ti voꞌon chquichꞌ ti bu muc bu cacꞌoj jvocole. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Avacꞌbeuc li muchꞌu snaꞌ sjolintasele, yul quichꞌ xchiꞌuc sjol ti yechuque”, xꞌutat yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Pojbeic li jmil cacꞌojbee, jaꞌ acꞌbeic li muchꞌu iyichꞌ tal lajunmile”, xut li yan yajꞌabtele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ti muchꞌutic sjunul yoꞌon ta xꞌabtejique, más ta xꞌacꞌbatic, mu cꞌu snaꞌic o. Yan ti muchꞌutic mu sjunuluc yoꞌon ta xꞌabtejique, ti cꞌu yunen epal iꞌacꞌbatique, ta xpojbatic ta jmoj. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Li chꞌajil jꞌabtel liꞌe acꞌo echꞌel ta icꞌ osil. Tey xꞌoqꞌuelet, xcꞌuxuxet o ye yuꞌun tsots castico chichꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ti cꞌalal xtal pasvancon ta mantal, voꞌon ti coꞌol crixchanootique, chixchiꞌinic tal scotol anjeletic. Jaꞌo chcalbe bu chbatic ta sbatel osil li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta jtsob scotol. Ti cꞌalal tsobolic xae, chlic jchꞌac, coꞌol xchiꞌuc jchabichij ti ta xchꞌac li xchije xchiꞌuc li xchivoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ti muchꞌutic lec yoꞌonique chcacꞌ ta jbatsꞌicꞌob. Yan ti muchꞌutic chopol sjolique chcacꞌ ta jsurto. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Voꞌon li jpasvanejon ta mantale jaꞌ yech chcalbe ti muchꞌutic tey ta jbatsꞌicꞌobe: “Li voꞌoxuque laꞌic yuꞌun slecubtasoj avoꞌonic ti Jtote. Ochicotic ta pasmantal yuꞌun jaꞌ yech iyal ti Jtote ti cꞌalal ispas li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ti cꞌalal liviꞌnaje, avacꞌbecon aveꞌelic. Ti cꞌalal itaquij jtiꞌe, avacꞌbecon avaꞌalic. Acꞌu mi muc xavojtiquinicon, avoteson ta anaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ti cꞌalal avilic ti chꞌabal jcꞌuꞌ jpoqꞌue, avacꞌbecon. Ti cꞌalal ipone, ay avulaꞌanicon. Ti cꞌalal tiqꞌuilon ta chuquele, ay aqꞌuelicon”, ta xcutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jaꞌ yech chtacꞌavic ti muchꞌutic lec yoꞌonique: “Cajval, ¿cꞌusi ora laquilticotic ti laviꞌnaje ti icacꞌticotic aveꞌele? ¿Cꞌusi ora laquilticotic ti itaquij atiꞌe ti lacacꞌbeticotic voꞌe? ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Cꞌusi ora lacotes ta jnaticotic ti muc xacojtiquinticotique? ¿Cꞌusi ora iquilticotic ti chꞌabal acꞌuꞌ apoqꞌue ti lacacꞌbeticotique? ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Cꞌusi ora iquilticotic ti laꞌipaje ti ay jvulaꞌanoticotique? ¿Cꞌusi ora iquilticotic ti tey tiqꞌuilot ta chuquele ti ay jqꞌueloticotique?” xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ta melel chacalbeic, yuꞌun acꞌuxubinic jun jchiꞌiltic ta yichꞌel ta mucꞌ ti Rioxe ti muc xꞌichꞌe ta muqꞌue, coꞌol xchiꞌuc voꞌon acꞌuxubinicon yaꞌel”, ta xcutic, voꞌon li jpasvanejon ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ti muchꞌutic tey ta jsurtoe: “Locꞌanic yuꞌun chopol ajolic. Ba ochanic ta cꞌocꞌ ta sbatel osil yoꞌ bu meltsanbil scuenta li totil pucuje xchiꞌuc li bicꞌtal pucujetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ti cꞌalal liviꞌnaje, muc xavacꞌbecon aveꞌelic. Ti cꞌalal itaquij jtiꞌe, muc xavacꞌbecon avaꞌalic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ti cꞌalal licꞌot ta anaique, avalic ti mu xavojtiquinicone, muc xavotesicon. Ti cꞌalal avilic ti chꞌabal jcꞌuꞌ jpoqꞌue, muc xavacꞌbecon. Ti cꞌalal ipone, ti cꞌalal tiqꞌuilon ta chuquele, muc xꞌay aqꞌuelicon”, ta xcutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Cajval, pero ¿cꞌusi ora laquilticotic ti laviꞌnaje, ti itaquij atiꞌe, ti muc xacojtiquinticotique, ti iquilticotic ti chꞌabal acꞌuꞌ apoqꞌue, ti ipote, ti tiqꞌuilot ta chuquele ti muc xajcꞌuxubinticotic chavale?” xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ta melel chacalbeic, yuꞌun muc xacꞌuxubinic junuc li muchꞌutic muc xꞌichꞌeic ta muqꞌue, coꞌol xchiꞌuc voꞌon muc xacꞌuxubinicon yaꞌel”, ta xcutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jaꞌ chba yichꞌic o castico ta sbatel osil ti muc xcꞌuxubinvanique. Yan ti muchꞌutic lec yoꞌonique chcuxiic ta sbatel osil ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ti cꞌalal laj yal yech ti Jesuse, jaꞌo liyalboticotic noxtoc, voꞌoticotic li yajchancꞌopoticotique: ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Anaꞌojic ti chib xa cꞌacꞌal scꞌan li sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌtique. Jaꞌo chiꞌaqꞌue entrucal, chisjipanic ta cruz, voꞌon ti coꞌol crixchanootique ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti totil paleetique, xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc ti cajmeltsanejcꞌoptique, istsob sbaic ta stiꞌ sna ti totil palee, jaꞌ ti Caifase. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Isaꞌic ti cꞌu to xi xuꞌ tsmucultsaquic ti Jesuse yuꞌun tscꞌan tsmilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","―Más lec mu yaꞌuc jtsactic lavi ta qꞌuine naca me licuc o sjol li jchiꞌiltactique ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ibat ta Betania ti Jesuse. Tey icꞌot ta sna Simón ti ip toꞌox ta leprae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tey icꞌot jun ants, yichꞌoj cꞌotel slimete meltsanbil ta alabastro ton, noj ta yaꞌlel muil nichim. Toyol tajmec stojol. Cꞌalal tey chotol ta mexa ti Jesuse, jaꞌo iscoconbe ta sjol ti sbel slimetee yuꞌun iyichꞌ ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ti cꞌalal iquilticotic li voꞌoticotique, licapoticotic o. ―¿Cꞌu yuꞌun ti yech noꞌox ta smal li yaꞌlel muil nichime? ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Más lec ti ixchonuque, yuꞌun toyol stojol. Li stojole xuꞌ chichꞌ meꞌonetic ti yechuque ―xichioticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ti Jesuse snaꞌoj ti cꞌusi ijnopticotique. ―Voꞌoxuc ta amulic ti chat yoꞌon li antse. Li cꞌusi liyacꞌbee, lec. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Li meꞌonetique liꞌ onox achiꞌuquique. Li voꞌone muc bu jal liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ti liscoconbe li yaꞌlel muil nichime, jaꞌ seña ti chimuquee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ta melel chacalbeic, chvinaj onox ta sjunlej balamil ti voꞌon chcacꞌ acuxlejalic ta sbatel osile. Chvinaj noxtoc ti liscoconbe yaꞌlel muil nichim li antse ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ti jun jchiꞌilticotic ti lajchavoꞌoticotic oe, jaꞌ ti Judas Iscariotee, ba scꞌopon ti totil paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","―¿Cꞌu yepal chavacꞌbecon mi chacacꞌbeic entrucal ti Jesuse? ―xut. Iꞌacꞌbat treinta plata. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti Judase isaꞌ ti cꞌu to xi xuꞌ chacꞌ entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti cꞌalal ilic li qꞌuin ti chichꞌ veꞌel pan ti muc bu yichꞌoj svuquesobil xchꞌute ―¿Bu chacꞌan ti chba jmeltsanticotic li chꞌiom chij ti ta jtiꞌtic ta sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌtique? ―xcuticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","―Batanic ta Jerusalén. Jaꞌ xcꞌot acꞌoponic li muchꞌu lec xcojtiquintique. “Liꞌ la chtal jtiꞌticotic ta ana li chij ta qꞌuine yuꞌun la poꞌot xa xmile li Jchanubtasvaneje”, xavutic cꞌotel ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ijchꞌunticotic ti cꞌusi iyal ti Jesuse, ijmeltsanticotic ti jveꞌelticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cꞌalal icꞌ xaꞌox osile, ijchol jbaticotic ta mexa xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ti cꞌalal yolel chiveꞌoticotique ―Ta melel chacalbeic, oy junoxuc ti chavaqꞌuicon entrucale ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ti cꞌalal icaꞌiticotique, icat o coꞌonticotic. ―Cajval ¿mi voꞌon van? ―xcuticotic jujuntal. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","―Iꞌi. Jaꞌ li muchꞌu jun jpulatu chiveꞌ jchiꞌuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta melel voꞌon ti coꞌol crixchanootique chquichꞌ milel chac cꞌu chaꞌal tsꞌibabil onox ta scꞌop Rioxe. Abol sba li muchꞌu chiyacꞌ entrucale. Más lec ti manchuc iꞌayane ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ti Judase ti snopoj xa onox ti chacꞌ entrucal ti Jesuse ―Jchanubtasvanej, ¿mi voꞌon van? ―xi uc. ―Voꞌot ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ti cꞌalal yolel chiveꞌoticotique, istam jpꞌej pan ti Jesuse. “Colaval” xut ti Rioxe, jaꞌo ixut ti pane. ―Ilo, veꞌanic. Liꞌi jaꞌ jbecꞌtal jtacupal ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Istam noxtoc jun baso yaꞌlel uva, “colaval” xut ti Rioxe. ―Uchꞌan acotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Liꞌi jaꞌ jchꞌichꞌel, jaꞌ seña ti chcꞌot onox ti cꞌusi tsꞌacal to iyal ti Jtote ti ta jchꞌichꞌel chtoj lamulique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chacalbeic ti mu xa bu chcuchꞌ li yaꞌlel uvae. Jaꞌto chcuchꞌ ti cꞌalal tey xa tsobolotic jcotoltic yoꞌ bu chacꞌ jpas mantal ti Jtote ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ti cꞌalal laj jqꞌuevujintaticotic ti Rioxe, libatoticotic ta vits Olivotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","―Liꞌ ta jliquele chacomtsanicon acotolic. Tsꞌibabil onox: “Ti Rioxe ta la xacꞌ ta milel ti muchꞌu stꞌujoj chispasotic ta mantale. Ti cꞌalal xmilee, ta la stani sbaic echꞌel ti xchiꞌiltaque, coꞌol la cꞌu chaꞌal chij ti ta stani sba echꞌel mi imile li xchabielique”, xi tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ti cꞌalal xichaꞌcuxie, chibat ta Galilea. Tey xa chcꞌot ataicon ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","―Acꞌu mi xascomtsan li yantique, pero li voꞌone mu xajcomtsan ―xi li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","―Ta melel chacalbe, lavi ta acꞌubaltique ti cꞌalal mu toꞌox ch-ocꞌ queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","―Muc ta alel mi coꞌol lilajotique. Jamal chcal ti xacojtiquine ―xi li Pedroe. Jaꞌ yech icalticotic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tey licꞌototicotic ta Getsemaní sbi xchiꞌuc ti Jesuse. ―Chotlanic liꞌtoe yuꞌun chba jcꞌopon Riox leꞌtoe ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ti Jesuse jaꞌ iyicꞌ echꞌel li Pedroe xchiꞌuc xchaꞌvaꞌal screm ti Zebedeoe. Iyat la yoꞌon ti Jesuse. Yan la sba yoꞌon iyaꞌi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","―Chcat coꞌon tajmec, chicham yaꞌel. Comanic liꞌtoe. Mu me xavayic uc ―xꞌutatic la li oxvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ti Jesuse ijelav to la echꞌel jsetꞌ. Isquejan la sba, jaꞌo la isnijan sba ta balamil noxtoc. Iscꞌopon la Riox. ―Tot, ti xuꞌuc to ti mu xichame, lec. Pero maꞌuc me xcꞌot li cꞌusi chal coꞌon jtuque, jaꞌ acꞌu jpas li cꞌusi chacꞌan li voꞌote ―xi la iscꞌopon Riox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ti cꞌalal laj scꞌopon Rioxe, isut la tal yoꞌ bu li oxvoꞌ jchiꞌiltaque. Vayemic la yul staelic. Iꞌalbat li Pedroe: ―¿Mi mu xcuch avuꞌunic junuc ora yaꞌel li vayele? ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mu me xavayic, cꞌoponic Riox yoꞌ mu xapasic o li cꞌusitic chopole. Ta melel avoꞌonicuc acꞌoponic Riox, pero lapat axoconique mu xuꞌ yuꞌun ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti Jesuse ba la scꞌopon Riox noxtoc: ―Tot, yuꞌun avaloj ti chichame, xuꞌ xicham ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ti cꞌalal isut tale, vayemic yul staelic noxtoc li oxvoꞌe yuꞌun la mu xcuch chaꞌiic li vayele. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ti Jesuse ba la scꞌopon Riox ta yoxꞌechꞌelal. Jaꞌ no la yech iyal chac cꞌu chaꞌal iyal ta baꞌyie. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ti cꞌalal isut tale ―Xuꞌ mi chavayic toe. Mi chacuxic to, cuxic. Ista xa yora ti chiꞌaqꞌue entrucal ta stojol jmulaviletic, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Licanic, batic. Qꞌuelavilic, leꞌ xa xtal li muchꞌu chiyacꞌ entrucale ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ti cꞌalal xyaquet chloꞌilaj ti Jesuse, jaꞌo tey icꞌot ti Judase. Jaꞌ lajchavoꞌoticotic o ta yajchancꞌop ti Jesuse. Ep crixchanoetic xchiꞌinoj cꞌotel; oy yespadaic, oy steꞌic. Jaꞌ stacojic echꞌel ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌoptic, voꞌotic li jꞌisraelotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ti Judase yaloj xa onox la cꞌu xꞌelan chacꞌ entrucal ti Jesuse: ―Ti muchꞌu ta jbutsꞌe, jaꞌ me xatsaquic ―xi ono la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ti Judase inopoj yoꞌ bu ti Jesuse: ―¿Mi liꞌote? Jchanubtasvanej ―xut. Jaꞌo isbutsꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","―Jchiꞌiltic, ti cꞌusi tal apase, paso ta ora ―xꞌutat yuꞌun ti Jesuse. Jaꞌo inopoj ti crixchanoetique, istsaquic ti Jesuse, ixchuquic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Oy jun jchiꞌilticotic ta yajchancꞌop ti Jesuse, isloqꞌues yespada, istuchꞌbe jun xchiquin ti smozo más totil palee. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","―Ticꞌo ta sna lavespadae ―xꞌutat yuꞌun ti Jesuse―. Ti muchꞌu chmilvan ta espadae jaꞌ noꞌox yech ta espada ta xcham uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mi mu xanaꞌ ti xuꞌ ta jcꞌopon ta ora ti Jtote yoꞌ xistacbe o tal más ta sesenta mil yajꞌanjeltac spojicone? ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero maꞌuc yech ta jpas, yuꞌun persa ta xcꞌot ti cꞌusi tsꞌibabil ta scꞌop Rioxe ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ti Jesuse iyalbe ti crixchanoetique. ―¿Cꞌu yuꞌun ti ta espada ta teꞌ tal atsaquicon chac cꞌu chaꞌal jꞌeleqꞌue? Ti tey onox chichanubtasvan ta tiꞌ mucꞌta templo jujun cꞌacꞌale, ¿cꞌu yuꞌun ti mu teyuc noꞌox atsaquicon yaꞌele? ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ti xꞌelan tal atsaquicone, jaꞌ icꞌot ti yech onox stsꞌibaojic ti yajꞌalcꞌoptac Riox ti ta voꞌnee ―xi ti Jesuse. Voꞌoticotic li yajchancꞌopoticotique lijatavoticotic. Stuc xa tey ijcomtsanticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ti cꞌalal istsaquic ti Jesuse, liꞌ iyiqꞌuic tal ta sna Caifase, jaꞌ ti totil palee. Tey tsobol ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc ti cajmeltsanejcꞌoptique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Li Pedroe nomnomtic tijil tal ta spat ti Jesuse. Ti cꞌalal iyul ta sna ti más totil palee, ixchiꞌin la ta chotlej ta tiꞌna jayvoꞌ jchabiejtemplo yuꞌun la tscꞌan chaꞌi cꞌu xꞌelan chcom o scꞌoplal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌoptique, lic la saꞌic chaꞌvoꞌ xchiꞌilic ta meltsanejcꞌop ti coꞌol cꞌusi chalique yuꞌun la tsaꞌbeic smul ti Jesuse yoꞌ xmile oe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero mu la bu istaic ti chaꞌvoꞌ coꞌol cꞌusi chalique. Yech no la ti ep jnopmulile, mu la coꞌoluc ti cꞌusi chalique. Isvaꞌan la sbaic otro chaꞌvoꞌ jnopmulil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","―Li vinic liꞌi caꞌyojticotic ti iyal ti xuꞌ tslomes li stemplo Rioxe, ti xuꞌ la chchaꞌvaꞌan ta oxib cꞌacꞌale ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ti totil palee isvaꞌan la sba. ―¿Cꞌu yuꞌun ti mu xatacꞌave? ¿Mi yech avaloj chac taje? ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mi jpꞌel mu la bu itacꞌav ti Jesuse. Ti totil palee isjacꞌbe la noxtoc: ―Ti Riox cuxul ta sbatel osile chaꞌi li cꞌusi chajacꞌbee. Jamal xavalboticotic mi voꞌot ti stꞌujojot Riox chapasoticotic ta mantale. ¿Mi voꞌot Xchꞌamalot ti Rioxe? ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","―Voꞌon ―xi la ti Jesuse―. Chacalbeic noxtoc, voꞌon ti coꞌol crixchanootique, chavilic chlic jpas ta mantal crixchanoetic ta syuꞌel ti Rioxe. Tsꞌacal to chil scotol crixchanoetic ti ta toc chichaꞌsut tale ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ti más totil palee isjat la scꞌuꞌ, yuꞌun la istabe xa smul ti yaloje. ―Icaꞌitic xa ti tspꞌis sba ta Rioxe. ¿Cꞌu xa stu cuꞌuntic yan rextico? ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Cꞌusi chanopic uc? ―xut la ti xchiꞌiltac ta meltsanejcꞌope. ―Acꞌu chamuc ta jmoj ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jaꞌo la istubtabeic sat ti Jesuse, ismajic la. Jlom la istꞌaxbeic ta majel sat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","―Mi yech chaval ti voꞌot Cristoote, alo caꞌtic muchꞌu lasmaj ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Li Pedroe tey la chotol ta tiꞌna. Ital la cꞌoponatuc yuꞌun jun quiarail: ―Li voꞌot uque jaꞌ achiꞌil li Jesuse ti liquem tal ta Galileae ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Li Pedroe iyal la yoꞌ bu tsobolique ti mu xojtiquin ti Jesuse: ―Mu jnaꞌ li cꞌusi chavale ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jaꞌo la ibat ta tiꞌbe li Pedroe. Iꞌojtiquine la yuꞌun otro jun quiarail. ―Li vinic leꞌe jaꞌ xchiꞌil li Jesus Nazarete ―xut la ti crixchanoetic ti tey tsobolique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","―Lojriox mu xcojtiquin li vinic chavale ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta jliquel o tal la scꞌoponel yuꞌun crixchanoetic li Pedroe: ―Ta melel jaꞌ achiꞌil li Jesuse yuꞌun jaꞌ yech chacꞌopoj chac cꞌu chaꞌal chcꞌopoje ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","―Lojriox mu xcojtiquin li vinic chavalique ―xi la. Jaꞌo la iꞌocꞌ quelem. ");
INSERT INTO tzoZNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Li Pedroe iyul la ta sjol ti yech onox iꞌalbat yuꞌun ti Jesuse: “Ti cꞌalal mu toꞌox ch-ocꞌ queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone”, xꞌutat onox yuꞌun ti Jesuse. Ilocꞌ la li Pedroe, ba la yoqꞌuita sba tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ti cꞌalal isacube, ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌoptic voꞌotic li jꞌisraelotique, isnopic cꞌu xꞌelan chcꞌot sticꞌbeic smul ti Jesuse yoꞌ xꞌaqꞌue o ta milel yuꞌun ti coviernoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ixchucbeic echꞌel scꞌob, ba yacꞌbeic entrucal ti covierno Poncio Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ti Judase, ti muchꞌu iyacꞌ entrucal ti Jesuse, ti cꞌalal iyaꞌi ti inop xa scꞌoplal ti chmile ti Jesuse, ba sutes li treinta plata ti iꞌacꞌbat yuꞌun ti totil paleetique xchiꞌuc ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","―Ijta xa jmul yuꞌun icacꞌ entrucal li muchꞌu chꞌabal smule ―xut cꞌotel. ―Li voꞌoticotique mu cꞌu jcuentaticotic o; ta amul atuc ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ti Judase isten comel ta tiꞌ mucꞌta templo li taqꞌuine, ba xchuc snucꞌ ta chꞌojon. Ismil sba stuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ti totil paleetique istsobic li taqꞌuine. ―Mu yaꞌuc jcaptic ta limoxna li taqꞌuin liꞌi, yuꞌun stojol xchꞌichꞌel jun vinic ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Coꞌol isnopic ti tsmanic o jsetꞌ osile. Jaꞌ chcom ta smuquenalic mi oy liꞌ ichamic jchiꞌiltactic ti nom liquemic tale. Jaꞌ ismanbeic yosil li jpatpꞌine. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Li osile “Chꞌichꞌ Lum” isbiin yuꞌunic. Jaꞌ yech sbi cꞌal tana. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jaꞌ icꞌot ti cꞌusi iyal ti Jeremías yajꞌalcꞌop Riox ti ta voꞌnee: “Tsutesbat li treinta platae, jaꞌ stojol ti muchꞌu mu scꞌanic ti tspasvan ta mantale, yuꞌun jaꞌ yech yepal tstojic ti muchꞌu chacꞌ entrucale. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yosil jpatpꞌin ta smanbeic, xiyut ti Rioxe”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ti Jesuse tey xa ta stojol Pilato. ―¿Mi yech ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale? ―xꞌutat yuꞌun ti Pilatoe. ―Yech ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌoptique ep isnopbeic smul ti Jesuse, pero muc xtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","―¿Mi mu xavaꞌi ti chalic ti toj ep amule? ―xi ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Muc xtacꞌav ti Jesuse. Ti Pilatoe xchꞌayet xa yoꞌon ti muc spac scꞌoplal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ta jujun sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌtique, ti Pilatoe isloqꞌues jun jchuquel ti bu junucal tscꞌanic loqꞌuesbel ti jchiꞌiltactique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tey tiqꞌuil ta chuquel jun jchiꞌiltic vinajem scꞌoplal ti toj pucuje, Barrabás sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cꞌalal tey tsobolic scotol ti jchiꞌiltactique ―¿Muchꞌu junucal ti chajloqꞌuesbeique? ¿Mi jaꞌ li Barrabase, mi jaꞌ li Jesuse ti chal ti jaꞌ tꞌujbil yuꞌun Riox chaspasic ta mantale? ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ti xꞌelan iyal ti Pilatoe, yuꞌun snaꞌoj ti yitꞌixal noꞌox yoꞌonic ti totil paleetique ti iyaqꞌuic entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ti Pilatoe, cꞌalal tey chotol yoꞌ bu chal cꞌu xꞌelan chcom scꞌoplal ti muchꞌu tsmeltsanbe scꞌoplale, jaꞌo itacbat tal mantal yuꞌun ti yajnile. “Pꞌijan me, mu me xavilbajin li vinique yuꞌun chꞌabal smul. Yuꞌun ijvaychin samel, icat o coꞌon tajmec”, xi tal ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌoptique ispꞌijubtasic ti crixchanoetique ti jaꞌ acꞌu scꞌanic loqꞌuesbel ti Barrabase, ti jaꞌ acꞌu yalic ti acꞌu yichꞌ milel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ti Pilatoe isjacꞌ noxtoc ti muchꞌu junucal tsloqꞌuese. ―Jaꞌ loqꞌueso li Barrabase ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","―¿Cꞌusi ta jchaꞌle li Jesuse ti iyal ti jaꞌ tꞌujbil yuꞌun Riox chaspasic ta mantale? ―xi ti Pilatoe. ―¡Jipano ta cruz! ―xiic scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―¿Cꞌusi smul avuꞌunic? ―xi ti Pilatoe. Más to tsots iꞌavanic: ―¡Jipano ta cruz! ―xiic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ti Pilatoe cꞌalal iyil ti mu xꞌichꞌe ta muqꞌue, ti xꞌavlajet tajmec ti jchiꞌiltactique, istac ta cꞌanel voꞌ, ispoc scꞌob yoꞌ xilic o ti jchiꞌiltactique ti mu sticꞌ sbae. ―Mu voꞌonicon chcom ta jba ti chmile li vinic liꞌi ti chꞌabal smule; voꞌoxuc chcom ta abaic ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","―Xuꞌ. Comuc ta jbaticotic xchiꞌuc col jchꞌamalticotic ti chmilee ―xiic scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ti Pilatoe isloqꞌues ta chuquel ti Barrabase. Jaꞌo iyalbe ti yajsolterotaque ti acꞌu yacꞌbeic arsial ti Jesuse. Ti cꞌalal laj yacꞌbeique, iyacꞌ orten ti acꞌu ba sjipanel ta cruze. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ti yajsolterotac coviernoe iyiqꞌuic ochel ta yut palacio ti Jesuse. Istsob sba scotol ti solteroetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Islocꞌbeic scꞌuꞌ ti Jesuse, islambeic natil tsajal cꞌuꞌul. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ixotic chꞌix, ixojbeic ta sjol, jaꞌ la scorona ti ta alele. Iyacꞌbeic jun aj ta sbatsꞌicꞌob, jaꞌ la sbaston ti ta alele. Isquejan sbaic ta yichon ti Jesuse, iyichꞌic ta mucꞌ yilel. ―¡Toj leclec aba caꞌuctic ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale! ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Istubtaic. Isquilbeic ti aje, isjisbeic ta sjol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ti cꞌalal laj slabanique, islocꞌbeic ti tsajal cꞌuꞌule, jaꞌ iyacꞌbeic slap ti scꞌuꞌ onoxe. Iyiqꞌuic echꞌel, ba sjipanic ta cruz. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ti cꞌalal iloqꞌuic echꞌel ti solteroetique xchiꞌuc ti Jesuse, isnupic ta be jun jchiꞌiltic ta jurioal, Simón sbi. Ti Simone liquem tal ta jun jteclum, Cirene sbi. Ti solteroetique iyaqꞌuic ta persa ti Simone ti acꞌu scajan echꞌel ta snequeb scruzal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ti Jesuse iyiqꞌuic echꞌel yoꞌ Gólgota sbie. Li Golgotae “Baquel Jol Anima”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iyacꞌbeic binagre capal xchiꞌuc cꞌusi chꞌa, pero muc xuchꞌ, yuꞌun iyaꞌi ti jaꞌ spajesobil scꞌuxul li lavuxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ti solteroetique isjipanic ta cruz ti Jesuse. Tsꞌacal to ixchꞌacbe sbaic ti scꞌuꞌe. Itajinic isqꞌuelic ti muchꞌu junucal chichꞌ julique. Jaꞌ icꞌot ti yech onox iyal ti yajꞌalcꞌop Riox ti ta voꞌnee: “Ta la xchꞌacbe sbaic li scꞌuꞌ spoqꞌue. Ta la xtajinic, ta la sqꞌuelic ti muchꞌu junucal chichꞌ julique”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ichoti ti solteroetique, ixchabiic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Isbajbeic jpech tabla ta sjol scruzal ti Jesuse, tey yaloj ti cꞌusi smul ti imile oe. “Liꞌi jaꞌ Jesús, yajpasvanejic ta mantal li jurioetique”, xi tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oy chaꞌvoꞌ jꞌelecꞌ coꞌol isjipanic ta cruz xchiꞌuc ti Jesuse, jun scruzal ta sbatsꞌicꞌob, jun ta surto. Ti scruzal Jesuse jaꞌ ta oꞌlol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ti muchꞌutic tey iꞌechꞌique ilabanvanic, isjimulan sjolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―Aval ti chalomes li mucꞌta temploe, ti xuꞌ chachaꞌvaꞌan ta oxib cꞌacꞌale. Yechꞌo un pojoquic aba un. Mi yech ti voꞌot Xchꞌamalot ti Rioxe, yalanquic tal un ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ilabanvanic uc ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc ti cajmeltsanejcꞌoptique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Iyetꞌesbe xchamelic li crixchanoetique. Li stuc une mu xuꞌ scolta sba un. Mi yech ti jaꞌ chispasotic ta mantal voꞌotic li jꞌisraelotique, acꞌuquic yaluc tal ta ora un yoꞌ jchꞌuntic oe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iyal ti chcoltaat yuꞌun ti Rioxe. Acꞌuquic coltaatuc ta ora un mi yech ti lec ch-ilee. Yuꞌun iyal ti jaꞌ Xchꞌamal ti Rioxe ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ilabanvanic uc ti chaꞌvoꞌ jꞌeleqꞌue ti coꞌol jipajtic ta cruz xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ta ol cꞌacꞌal iꞌicꞌub. Ta oxib to ora xmal isacub. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta oxib ora xmal jaꞌo tsots iꞌavan ti Jesuse: ―Elí, Elí ¿lama sabactani? ―xi. Ti cꞌusi iyale, “Cajval, Cajval, ¿cꞌu yuꞌun ti acomtsanone?” xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oy jayvoꞌ ti iyaꞌiique. ―Jaꞌ chapta ti jꞌalcꞌop Elíase ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jaꞌo ibat ta anil jun ti muchꞌu iyaꞌie, ba stam tal esponja. Istsꞌaj ta binagre, ixoj ta aj, iyacꞌbe stsꞌutsꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","―Mu xavacꞌbe. Jqꞌueltiquic mi chtal syalesel ta cruz yuꞌun ti Elíase ―xꞌutat yuꞌun ti yantique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ti Jesuse tsots iꞌavan noxtoc, jaꞌo xa ilocꞌ xchꞌulel. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jaꞌo ijat ta oꞌlol ti mucꞌta pocꞌ scꞌalobil li mucꞌta temploe. Ijat yalel cꞌalal yoc. Iꞌechꞌ tsots niquel. Li mucꞌtic tone laj vocꞌuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ijam muquenaletic, ep ichaꞌcuxiic ti muchꞌutic yichꞌojic ta mucꞌ Riox ti cꞌalal ichamique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iloqꞌuic ta smuquenalic pero muc xꞌochic tal ta ora liꞌ ta yutil Jerusalene. Jaꞌto iꞌochic tal ti cꞌalal ichaꞌcuxi loqꞌuel ta smuquenal ti Jesuse. Iꞌileic yuꞌun ep crixchanoetic liꞌ ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ti capitan solteroe xchiꞌuc ti yajsolterotaque ti tey ta xchabiic ti Jesuse, ixiꞌic tajmec ti cꞌalal iꞌechꞌ ti niquele, xchiꞌuc ti cꞌalal iyilic ti cꞌusitic icꞌote. ―Melel ti jaꞌ xchꞌamal Rioxe ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tey ep antsetic noxtoc, nom tsqꞌuelic ti jipil ta cruz ti Jesuse. Jaꞌ li muchꞌutic ixchiꞌinic ta xanvil ta estado Galilea ti Jesuse, ti ismacꞌlinique. Xchiꞌinojic tal cꞌalal ital liꞌ ta estado Judeae. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tey capal li María liquem tal ta Magdalae, xchiꞌuc li otro jun Maríae, li smeꞌic Jacoboe xchiꞌuc li Josee. Tey noxtoc smeꞌic li scremotic Zebedeoe, jaꞌ li Jacoboe xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Oy jun jchiꞌiltic jcꞌulej, liquem tal ta jteclum Arimatea, José sbi. Yichꞌoj ta mucꞌ uc ti Jesuse. Cꞌalal icꞌ xaꞌoxe, li Josee ba scꞌopon ti Pilatoe, ba scꞌanbe spat xocon ti ánima Jesuse. Ti Pilatoe iyacꞌ permiso. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ti Josee isyales ta cruz ti ánimae, ispix ta saquil pocꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ba sticꞌ ta chꞌojbil ton, jaꞌ smuquenal ti Josee. Isetetin tal mucꞌta setset ton, ismac o comel li tiꞌchꞌene, ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Li María liquem tal ta Magdalae xchiꞌuc li otro jun Maríae, tey chotol icomic ta tiꞌchꞌen. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Svoljeal ox ijchap jbatic ti ta jcuxtic ta savaroe, istsob sbaic scotol ti totil paleetique xchiꞌuc ti jfariseoetique. Ba scꞌoponic ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","―Señor Gobernador, jnaꞌojticotic ti jaꞌ yech iyal cꞌalal cuxul toꞌox ti jloꞌlovaneje: “Ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Alo mantal ti acꞌu ba smaquel lec li muquenale, ti acꞌu xchabiel oxibuc cꞌacꞌale. Yuꞌun yicꞌal xba sloqꞌuesic ta acꞌubaltic li yajchancꞌoptaque, yicꞌal xalbeic li crixchanoetique ti ichaꞌcuxi xa loqꞌuel ta smuquenale, yicꞌal más to ep xchꞌunic o loꞌloel li crixchanoetique ―xutic ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","―Tey li solteroetique, iqꞌuic echꞌel. Acꞌu ba smaquic, acꞌu ba xchabiic ti bu cꞌalal xuꞌe ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba smaquic lec li tiꞌil muquenale. Iyacꞌbeic seyo li tone. Ti cꞌalal laj smaquique, tey com xchabiic ti solteroetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Svoljeal ox ijcuxtic, cꞌalal naca toꞌox xcꞌot ta teqꞌuel ta primero cꞌacꞌal xemanae, jaꞌ li romincoe, li María liquem tal ta Magdalae xchiꞌuc li otro jun Maríae, ba sqꞌuelbeic smuquenal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cꞌalal mu toꞌox chbatique, iꞌechꞌ tsots niquel, istac tal jun anjel ti Cajvaltique. Yul setetin loqꞌuel li smac stiꞌil chꞌene, ichoti ta sba li tone. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ti anjele oy xojobal chac cꞌu chaꞌal chavuc ti xlebluje. Sac tajmec ti scꞌuꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ti cꞌalal iyilic anjel ti solteroetique ti ta xchabiic li tiꞌ chꞌene, xtꞌeleletic xa ta xiꞌel, chamem icomic yilel. Cꞌalal icꞌotic ta chꞌen li antsetique, iꞌalbatic la yuꞌun ti anjele: ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","―Mu me xaxiꞌic. Jnaꞌoj ti jaꞌ chasaꞌic ti Jesuse ti icham ta cruze. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mu xa bu liꞌi; ichaꞌcuxi xa chac cꞌu chaꞌal layalbeic onoxe. Laꞌ qꞌuelavilic yoꞌ bu istelanic toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Batanic ta ora, ba albeic li yajchancꞌoptaque ti ichaꞌcuxi xae. Albeic ti baꞌyi chbat ta Galileae. Tey chcꞌot staic. Jaꞌ noꞌox chacalbeic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Li antsetique mu xa la aꞌibaj cꞌusi tsnopic, mi chiꞌic, mi jun la yoꞌonic. Anil tal yalboticotic, voꞌoticotic li yajchancꞌopoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ti cꞌalal italique, isnupic la ta be ti Jesuse. ―¿Bu chabatic? ―xꞌutatic la. Li antsetique isquejletaic la, ismeybeic la yoc, iyichꞌic la ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","―Mu xaxiꞌic. Ba albeic li jchiꞌiltaque, jaꞌ li muchꞌutic coꞌol quichꞌojtic ta mucꞌ ti Jtotic Riox jchiꞌuctique, ti acꞌu baticuc ta Galileae. Tey chcꞌot staicon ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ti cꞌalal mu toꞌox chulic li antsetique, jaꞌo iyulic ta jteclum jayvoꞌ solteroetic ti ixchabibeic smuquenal ti Jesuse. Yul yalbeic totil paleetic ti cꞌusitic iyilique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti totil paleetique istsob sbaic ta ora xchiꞌuc ti cajmeltsanejcꞌoptique. Coꞌol isnopic ti cꞌusi tspasique. Iyacꞌbeic la ep taqꞌuin ti solteroetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","―Jaꞌ yech xavalic: “Ti cꞌalal listsacoticotic vayel ta acꞌubale, ti ánimae ay sloqꞌuesel yuꞌun li yajchancꞌoptaque”, chianic me. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ti mi iyaꞌi li coviernoe, tey chba jmeltsanticotic acꞌoplalic yoꞌ mu xasmilic oe ―xutic la ti solteroetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ti solteroetique ixchꞌamic la ti taqꞌuine, jaꞌ yech iyalic chac cꞌu chaꞌal iꞌalbatique. Scotol li jchiꞌiltactic ta jurioale jaꞌ yech chalic cꞌal tana ti muc xchaꞌcuxi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Voꞌoticotic li buluchvoꞌ yajchancꞌopoticotic ti Jesuse, libatoticotic ta Galilea. Tey licꞌototicotic ta vits yoꞌ bu yalojboticotic onox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ti cꞌalal iquilticotic ti Jesuse, ijquejletaticotic. Pero oy chaꞌvoꞌ oxvoꞌ ti muc xchꞌunic ti jaꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","―Vo-on liꞌacꞌbat jcuentain vinajel balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yechꞌo un batanic ta sjunlej balamil, ba albeic crixchanoetic ti cꞌusi lacalbeique. Acꞌbo yichꞌic voꞌ ta scuenta ti Jtote, ta jcuenta voꞌon li Chꞌamalilone, ta scuenta ti Chꞌul Espíritue. Jaꞌ seña ti chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chanubtasic chac cꞌu chaꞌal lajchanubtasique yoꞌ xchꞌunic o uc ti cꞌusitic lacalbeique. Naꞌic me ti liꞌ jchiꞌinojoxuc o ti cꞌu sjalil mu toꞌox bu chlaj li balamile ―xiyutoticotic ti Jesuse.");
INSERT INTO tzoZNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaꞌ la yech ivinaj ti jaꞌ chacꞌ jcuxlejaltic ta sbatel osil ti Jesucristoe, ti Xchꞌamal Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee jaꞌ onox yech stsꞌibaoj comel chac liꞌi: Baꞌyi ta jtac echꞌel mantal. Jaꞌ chalbe crixchanoetic ti tey chacꞌote yoꞌ xaꞌichꞌe o ta muqꞌue, xut Xchꞌamal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yechꞌo un ta to xtal jun jchiꞌiltic ta israelal, tsots ch-avetaj ta xocol balamil: “Chtal xa ti Cajvaltique. Ictaic xa spasel li cꞌusitic chopole. Xachꞌunbeic me ti cꞌusitic chayalbeique”, xi chalbe ti jchiꞌiltactique, xi onox comel ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jaꞌ la scꞌoplal ti Juane ti iyal ta xocol balamil ti chacꞌbe yichꞌ voꞌ ti muchꞌutic chictaic spasel li cꞌusitic chopole yoꞌ ti xꞌaqꞌueic o ta pertonal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ti jchiꞌiltac ta israelal liꞌ ta sjunlej estado Judeae xchiꞌuc liꞌ ta jteclum Jerusalene, ba la yaꞌiic cꞌusi iyal ti Juane. Ti muchꞌutic jamal iyalic ti cꞌusitic chopol tspasique iꞌacꞌbatic la yichꞌic voꞌ ta ucꞌum Jordán yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ti Juane jalbil tsatsal cameyo la ti scꞌuꞌe. Nucul la ti xchuc xchꞌute. Naca la cochiꞌ xchiꞌuc ajapom islajes. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iyalbe la ti jchiꞌiltac ta israelale ti oy muchꞌu tsꞌacal to chtale, ti más oy syuꞌele. ―Li voꞌone mi jaꞌuc yaqꞌuil xonob, mu xjituj cuꞌun yuꞌun mu cꞌu xitun o. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Li voꞌone jaꞌ noꞌox lacacꞌbe avichꞌic voꞌ. Yan ti muchꞌu tsꞌacal to chtale jaꞌ chayacꞌbe achiꞌinic ti Chꞌul Espíritue ―xi la ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ti cꞌalal yolel chacꞌ ichꞌvoꞌ ti Juane, jaꞌo la ilocꞌ tal ta jteclum Nazaret ta estado Galilea ti Jesuse. Tey la icꞌot ta ucꞌum Jordán, iꞌacꞌbat la yichꞌ voꞌ uc yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ti cꞌalal ilocꞌ ta ucꞌum ti Jesuse, iyil la ti ijam li vinajele. Iyil la ti iyal tal ta sba ti Chꞌul Espíritue, coꞌol la xchiꞌuc paloma yilel. Jaꞌo la ichiꞌine yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ti Rioxe icꞌopoj la tal ta vinajel: ―Voꞌot Jchꞌamalot. Jcꞌanojot tajmec. Jun coꞌon avuꞌun ―xꞌutat la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ti cꞌalal laj yichꞌ voꞌ ti Jesuse, iyulesbat la ta sjol yuꞌun ti Chꞌul Espíritue ti chbat ta xocol balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaꞌvinic la cꞌacꞌal tey ta xocol balamil. Naca la teꞌtiquil chon oy. Jaꞌo la tey icꞌot ti Satanase, cꞌot la sloꞌlo ti yaloje. Ti Jesuse ichabiat la yuꞌun anjeletic ta vinajel ti cꞌu sjalil teye. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tsꞌacal to cꞌalal tiqꞌuil xaꞌox ta chuquel ti Juane, ti Jesuse isut la echꞌel ta Galilea. Jaꞌ la ba yal aꞌyuc ti tspasvan xa ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","―Ista xa yora chaspasic ta mantal ti Rioxe. Ictaic xa spasel li cꞌusitic chopole, chꞌunic ti chaspasic xa ta mantale ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ti Jesuse ibat la ta tiꞌtiꞌnab ta Galilea. Tey la iyil chaꞌvoꞌ jchiꞌilticotic ta israelal, sbanquil yitsꞌin noꞌox sbaic. Li banquilale Simón sbi. Andrés sbi li itsꞌinale. Tey la yolel tsjipic ta nab snutiꞌic tsacobil choy, yuꞌun la tsacchoy yabtelic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","―Laꞌ chiꞌinicon, ta jel avabtelic. Chajchanubtasic cꞌuxi chba avicꞌbecon tal crixchanoetic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ora la iyictaic o li tsacchoye, jaꞌ la ba xchiꞌinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ijelav la echꞌel jsetꞌ ti Jesuse. Tey la iyil otro chaꞌvoꞌ, sbanquil yitsꞌin noꞌox sbaic uc. Jaꞌ la scremotic ti Zebedeoe. Li banquilale Jacobo sbi. Li itsꞌinale Juan sbi. Ticꞌajtic la ta canova xchiꞌuc stotic, yolel la ta stsꞌisic snutiꞌic tsacobil choy, yuꞌun la jatem. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","―Laꞌ chiꞌinicon ―xꞌutatic la yuꞌun ti Jesuse. Tey la iscomtsanic ti stotique xchiꞌuc ti scanovaique, jaꞌ la ba xchiꞌinic ti Jesuse. Ti stotique tey la icom ta canova xchiꞌuc stojbalaltac. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tey la icꞌotic ta jteclum Capernaum. Ti cꞌalal icꞌot scꞌacꞌalil ta xcuxic li jchiꞌiltac ta israelale, ti Jesuse iꞌoch la ta templo teyoꞌe, ichanubtasvan la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ti jchiꞌiltac teyoꞌe xchꞌayet xa la yoꞌonic ti cꞌu xꞌelan ichanubtasvane yuꞌun la lec snaꞌ ti cꞌusitic tscꞌan ti Rioxe. Maꞌuc la yech ichanubtasvan chac cꞌu chaꞌal li jchiꞌiltaque ti ta xchanubtasvanic yilel ta smantaltac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tey la jun jchiꞌilticotic, ochem la pucujetic ta yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iꞌavan la: ―¿Cꞌusi acuentaoticotic o, Jesus Nazaret? ¿Miꞌn tal atacoticotic echꞌel yoꞌ bu chba quichꞌticotic casticoe? Jnaꞌoj muchꞌuot. Voꞌot Xchꞌamalot ti Rioxe, voꞌot ti chꞌabal amule ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ti Jesuse ispajes la ti pucujetique ti xchꞌamunojbeic ye ti vinique. ―Anchanic, locꞌanic ta yoꞌon li vinique ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ti vinique itꞌelelinat la tajmec ti cꞌalal iloqꞌuic ti pucujetic ta yoꞌone. Tsots la iꞌavanic ti cꞌalal iloqꞌuique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Xchꞌayet xa la yoꞌonic ti muchꞌutic teyique. ―¿Muchꞌu onox leꞌe ti oy syuꞌele, ti ta xchꞌunbat smantal yuꞌun ti pucujetique? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ti xꞌelan ispas ti Jesuse, ora la ivinaj ta sjunlej estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ti cꞌalal iloqꞌuic ta templo ti Jesuse xchiꞌuc ti Jacoboe, xchiꞌuc ti Juane, ibatic la ta sna Simón xchiꞌuc Andrés. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ti sniꞌmeꞌel Simone tey la puchꞌul ta stem yuꞌun la tilem. ―Abulajan qꞌuelbon li jniꞌmeꞌele ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ti Jesuse inopoj la echꞌel yoꞌ bu puchꞌul ti jmemeꞌtique. Istsacbe la scꞌob, isnit la liquel. Ora la itupꞌ scꞌacꞌal, lic la macꞌlinvanuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ti cꞌalal iꞌoch acꞌubale, ti muchꞌutic oy yajchamele tey la yicꞌojbeic cꞌotel ti Jesuse xchiꞌuc la ti muchꞌutic ochem pucuj ta yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tey la lamal icꞌotic ta tiꞌna ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ti Jesuse icol la yuꞌun ti jchameletique. Cꞌusuc no la chamelal chaꞌiic icol la yuꞌun scotol. Isloqꞌues la pucujetic ti ochem ta yoꞌonic ti crixchanoetique. Ti pucujetique muc la xꞌaqꞌue cꞌopojicuc yuꞌun ti Jesuse yuꞌun la snaꞌojic ti jaꞌ Xchꞌamal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta yocꞌomal icꞌ toꞌox la ilic ti Jesuse, ilocꞌ la ta jteclum, ibat la yoꞌ bu chꞌabal crixchanoe, ba la scꞌopon Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Li Simone xchiꞌuc li xchiꞌiltaque ba la saꞌic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ti cꞌalal istaique ―Chasaꞌot li crixchanoetique ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","―Batic ta jteclumetic ti liꞌ noꞌox nopole. Yuꞌun chba calbe yaꞌiic uc li jchiꞌiltactique ti chlic xa pasvanuc ta mantal ti Rioxe, yuꞌun jaꞌ tacbilon o tal ti chcal aꞌyuque ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ixanavic la ta sjunlej estado Galilea. Ti Jesuse xcholet la iyal ta bicꞌtal temploetic ti chlic xa pasvanuc ta mantal ti Rioxe. Isloqꞌues la pucujetic ti ochem ta yoꞌonic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tey la icꞌot jun jchiꞌilticotic, ip la ta lepra. Isquejan la sba ta yichon ti Jesuse. ―Acꞌanuc la avetꞌesbon li chamel xꞌelan ipon oe, yuꞌun jnaꞌoj ti voꞌot xuꞌ chavetꞌesbone ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ti Jesuse abol la sba iyil, iyacꞌ la scꞌob ta sba ti jchamele. ―Echꞌuc cheꞌe ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ora la iꞌechꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ti Jesuse tsots la iyalbe ti vinique: ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Mu me muchꞌu xavalbe yaꞌi ti voꞌon laquetꞌesbot lachamele. Jaꞌ noꞌox ba acꞌbo yil li palee. Acꞌbo smoton Riox chac cꞌu chaꞌal yaloj ti Moisese yoꞌ xilic o li jchiꞌiltactique ti lecot xae ―xut la echꞌel vinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ibat la ti vinique, lic la yal aꞌyuc ti jaꞌ iꞌetꞌesbon xchamel yuꞌun ti Jesuse. Jaꞌ la yech ivinaj o ti chetꞌes chamel ti Jesuse, yechꞌo un mucul xa la ch-och ta jteclumetic. Tey o la ta xocol balamil. Pero ep la jchiꞌiltac ta israelal ba staic, buyuc noꞌox la laj licuc echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsꞌacal to cꞌalal iꞌechꞌ jayib cꞌacꞌale, ti Jesuse isut la ta Capernaum. Ti jchiꞌiltac ta israelale iyaꞌiic la ti tey xa icꞌot ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ora la istsob sbaic echꞌel yoꞌ bu ti Jesuse. Mu xa la xꞌochic o ti yut nae. Lamal xa la jlom ta tiꞌna. Ti Jesuse iyal la scꞌop Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tey la sqꞌuechojic cꞌotel ta pop jun jchiꞌilticotic, chꞌabal la yip jun yoc scꞌob. Chanvoꞌ la yajval. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Muc la sta ochel sbeic jaꞌ la ti toj noj ti nae. Solel la imuyic ta bana yuꞌun pachꞌal. Ixchꞌojic la jsetꞌ, tey la isyalesic xchiꞌuc spop ti jchamele. Tey la icꞌot ta stuqꞌuil ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ti Jesuse iyil la ti xchꞌunojic ti oy syuꞌele. ―Jchꞌamal, acꞌbilot xa pertonal yuꞌun lamule ―xut la ti jchamele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tey la chotajtic jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Cꞌu yuꞌun ti xꞌelan chale? Tspꞌis sba ta Riox. Muc muchꞌu xuꞌ chiyacꞌbotic pertonal yuꞌun li jmultique, jaꞌ noꞌox ti Rioxe”, xi la ta yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ti Jesuse yiloj la ti cꞌusi isnopique. ―¿Cꞌu yuꞌun ti xꞌelan chanopique? ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ti xꞌelan icalbe li vinique ti “acꞌbilot xa pertonal yuꞌun lamule”, xcute, muchꞌuuc noꞌox xuꞌ chal yech, yuꞌun mu vocluc ta alel. Jaꞌ noꞌox yech mu vocluc ta alel ti “lican, tamo echꞌel lapope, xanavan”, xichiotique. Pero jaꞌ tscꞌan chaqꞌuelic mi chcꞌot scꞌop ti muchꞌu yech chale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Li voꞌone ical ti acꞌbil xa pertonal yuꞌun smul li vinique. Pero qꞌuelic me cꞌusi ta jpas lavie yoꞌ xavilic o ti voꞌon noꞌox ta xcacꞌbe pertonal yuꞌun smulic li crixchanoetic liꞌ ta sba balamile, voꞌon ti coꞌol crixchanootique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Voꞌon chacalbe, lican, tamo echꞌel lapope, batan ta ana ―xꞌutat la yuꞌun Jesús ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ora la ilic. Iyil la scotolic ti iyichꞌ echꞌel ti spope, ilocꞌ la echꞌel. Xchꞌayet xa la yoꞌonic ti crixchanoetique. ―Coliyal Riox muc bu xquiltic o yech ti xꞌelan tspase ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tsꞌacal to ibat la ta tiꞌnab ti Jesuse. Ep la jchiꞌiltac ta israelal istsob sbaic echꞌel. Ti Jesuse ichanubtasvan la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ti cꞌalal laj chanubtasvanuque, ibat la. Iꞌile la li Levie, li screm Alfeoe, tey la chotol ta xchotleb yoꞌ bu tscꞌanbe li slocꞌ cꞌusiticuque. ―Laꞌ, batic ―xꞌutat la yuꞌun ti Jesuse. Ibat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsꞌacal to cꞌalal tey chveꞌ ta sna Leví ti Jesuse, tey la ep jcꞌan-locꞌ-cꞌusiticuc xchiꞌuc la ti muchꞌutic más chopol cꞌusitic tspasique. Ixchol la sbaic ta mexa scotolic xchiꞌuc ti Jesuse yuꞌun la tsobolic cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tey la jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc la jayvoꞌ jfariseoetic. Chopol la iyilic ti tsobol chveꞌ xchiꞌuc jcꞌan-locꞌ-cꞌusiticuc ti Jesuse, xchiꞌuc ti muchꞌutic más chopol cꞌusitic tspasique. ―Lavajchanubtasvanejique ¿cꞌu yuꞌun ti tsobol chveꞌ xchiꞌuc li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li muchꞌutic más chopol cꞌusitic tspasique? ―xꞌutatic la li jayvoꞌ icꞌbilic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ti Jesuse iyaꞌi la ti cꞌusi iyalique. ―Ti muchꞌutic leque mu cꞌu stu yuꞌunic jpoxtavanej; jaꞌ noꞌox ti muchꞌutic ipe. Li voꞌone maꞌuc tal jsaꞌ ti muchꞌutic chꞌabal smul ti yalojique. Jaꞌ tal jsaꞌ ti muchꞌutic oy smulique yoꞌ xictaic oe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Oy yajchancꞌoptac ti Juan jꞌacꞌ-ichꞌvoꞌe. Oy yajchancꞌoptac ti jfariseoetique. Cꞌalal yictaoj yotique, oy la jayvoꞌ cꞌot sjacꞌbeic ti Jesuse: ―¿Cꞌu yuꞌun ti mu xicta yotic lavajchancꞌoptac voꞌote? Li voꞌoticotique xchiꞌuc li yajchancꞌoptac jfariseoetique chquicta coticotic ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Itacꞌav la ti Jesuse: ―Cꞌalal teyotic ta nupunele, cꞌalal tey jchiꞌinojtic li jnupunele, mu jaꞌuc o chquicta cotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jaꞌ noꞌox yech lavi liꞌto jchiꞌuc li cajchancꞌoptaque, mu xicta yotic. Jaꞌto chicta yotic ti cꞌalal ximilee. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Muc muchꞌu tspacꞌan ta achꞌ manta li cꞌaꞌcꞌuꞌule. Yuꞌun tsmuts li achꞌe, chjat más li cꞌaꞌcꞌuꞌule. Jaꞌ noꞌox yech ti muchꞌutic ta xchꞌunic ti voꞌon noꞌox chcacꞌ cuxlicuc ta sbatel osile, achꞌ xa li cꞌusitic tspasique, mu xa spasic ti cꞌusitic ispasic toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jaꞌ chac cꞌu chaꞌal li achꞌ yaꞌlel uvae, muc muchꞌu ta xchꞌol ta pocoꞌ nuculal chivo. Ti mi ta xchꞌol ta pocoꞌ nucule, ti cꞌalal xvocane, ta xtꞌom li nucule. Yech noꞌox ta xmal. Yech noꞌox ta xchꞌay noxtoc li yave. Li achꞌ yaꞌlel uvae jaꞌ tscꞌan ti achꞌ yav chichꞌ chꞌolel oe yoꞌ lec xcom o xchiꞌuc li yave ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ta scꞌacꞌalil ta xcuxic li jchiꞌiltac ta israelale, li jayvoꞌ tsobol chanavic xchiꞌuc ti Jesuse jaꞌo la iꞌechꞌic xchiꞌuc ta be ta trigoaltic. Iscꞌasic la jaychev trigo, isjuꞌ la scꞌuxic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iꞌileic la yuꞌun jayvoꞌ jfariseo. ―¿Cꞌu yuꞌun ti tscꞌasic trigo ta scꞌacꞌalil ta jcuxtic lavajchancꞌoptaque? ―xꞌutat la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","―¿Mi muc bu aqꞌuelojic yaꞌel ta scꞌop Riox ti cꞌusi ispas ti Davide ti cꞌalal iviꞌnaj xchiꞌuc ti xchiꞌiltac ta xanvile? ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tey icꞌotic ta templo. Jaꞌo ochem ta totil pale ti Abiatare. Ti Davide jaꞌ iscꞌan sveꞌ ti pan ta ba mexae ti smotoninoj ti Rioxe. Acꞌu mi yaloj ti Rioxe ti jaꞌ noꞌox tsveꞌic li paleetique, pero isveꞌic xchiꞌuc xchiꞌiltac ti Davide. Pero muc bu ista o smul uc ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iyal noxtoc ti Jesuse: ―Ti Rioxe xchꞌacoj jun cꞌacꞌal yuꞌun ta jcuxtic. Pero maꞌuc ichꞌaque o li jun cꞌacꞌale ti chisujatotic ta xchabiele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Voꞌon ti coꞌol crixchanootique, voꞌon yajvalon li scꞌacꞌalil ta jcuxtique. Voꞌon chcal ti cꞌusi xuꞌ jpastique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ti Jesuse ibat la noxtoc ta templo teyoꞌe. Tey la jun jchiꞌilticotic, smochꞌoj la sba sniꞌtac jun scꞌob. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tey la jayvoꞌ jfariseoetic. Jaꞌ la tspaꞌiic ti Jesuse, ta la sqꞌuelic mi oy chetꞌes chamel ta scꞌacꞌalil ta xcuxic li jchiꞌiltaque yoꞌ la stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","―Laꞌ vaꞌlan liꞌ ta oꞌlole ―xꞌutat la yuꞌun Jesús ti vinic smochꞌoj sba sniꞌtac jun scꞌobe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ti Jesuse isjacꞌbe la ti jfariseoetique: ―Ta scꞌacꞌalil ta jcuxtique, ¿cꞌusi yaloj ti Rioxe ti xuꞌ jpastique? ¿Mi xuꞌ jpastic li cꞌusitic leque, o mi jaꞌ ta jpastic li cꞌusitic chopole? ¿Mi xuꞌ chichꞌ etꞌesbel xchamelic li muchꞌutic ipe, o mi tey noꞌox jqꞌuelojtic chamicuc? ―xut la. Mu la bu itacꞌavic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ti Jesuse icap la, isqꞌuelbe la sat ti jfariseoetique, jaꞌ la chopol iyaꞌi ti mu xchꞌunic tajmeque. ―Tuqꞌuibtaso li sniꞌtac acꞌobe ―xꞌutat la yuꞌun Jesús ti vinique. Istuqꞌuibtas la, lec xa la icom ti scꞌobe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ti jfariseoetique iloqꞌuic la echꞌel, ba la scꞌoponbeic svinictac Erodes. Ba la snopic cꞌuxi tstaic ta milel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ti Jesuse ilocꞌ la teyoꞌe, ibat la ta tiꞌnab. Tey la xchiꞌuquic echꞌel li jayvoꞌ tsobol chanavic xchiꞌuque. Ep la tajmec jchiꞌiltac napꞌajtic echꞌel, tey noꞌox la liquemic jlom ta estado Galilea. Ti jlome liꞌ la iliquic echꞌel ta estado Judeae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ti jlome liꞌ la iliquic echꞌel ta jteclum Jerusalene. Jlom la ta estado Idumea, jlom la ta jech ucꞌum Jordán, jlom la ta stsꞌel li chib jteclum Tiro xchiꞌuc Sidone. Yuꞌun la iyaꞌiic ti ep cꞌusitic ispas ti Jesuse, yechꞌo la ti ep tajmec ba sqꞌuelique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","―Nopojesic noꞌox tal jcotuc canova. Mi chnetꞌvan tajmec li crixchanoetique, chiꞌoch ―xꞌutatic la li jayvoꞌ icꞌbilic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yuꞌun la ep xa jchiꞌiltac iꞌetꞌesbat xchamelic yuꞌun ti Jesuse, yechꞌo un ti muchꞌutic ipe snetꞌnetꞌ xa la sbaic tal yuꞌun la tscꞌan tspiquic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ti muchꞌutic ochem pucuj ta yoꞌonique, ti bu la xilic ti Jesuse, jliquel la tsquejan sbaic ta yichon. Ch-avanic la. ―Voꞌot Xchꞌamalot Riox ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ti Jesuse tsots la iyalbe ti pucujetique ti mu yaꞌuc yalic yeche. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsꞌacal to imuy la echꞌel ta vits ti Jesuse. Iyicꞌ la muyel ti muchꞌutic scꞌan yoꞌon chicꞌ echꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Istꞌuj la lajchavoꞌ ti ta xchiꞌin oe, ti ta stac echꞌel ta yalel aꞌyuc li cꞌusitic chale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Iꞌacꞌbat la syuꞌelic ti chetꞌesbeic xchamel ti muchꞌutic ipe, ti tsloqꞌuesbeic pucujetic ta yoꞌonic ti jchiꞌiltac ta israelale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Li lajchavoꞌ itꞌujeique, jaꞌ sbiic liꞌi: Simón, Pedro la iꞌacꞌbat sbiin yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Xchiꞌuc Jacobo xchiꞌuc yitsꞌin, Juan sbi, li scremotic Zebedeoe. Boanérjes la iꞌacꞌbat sbiic yuꞌun ti Jesuse. Li Boanérjese “coꞌol xchiꞌuc chavuc”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xchiꞌuc Andrés, xchiꞌuc Felipe, xchiꞌuc Bartolomé, xchiꞌuc Mateo, xchiꞌuc Tomás, xchiꞌuc otro jun Jacobo screm Alfeo. Xchiꞌuc Tadeo, xchiꞌuc Simón ti sticꞌoj sba ta partido cananeoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Xchiꞌuc Judas Iscariote, jaꞌ ti iyacꞌ entrucal ta tsꞌacal ti Jesuse. Ti cꞌalal laj tꞌujaticuc li lajchavoꞌe, ibat la xchiꞌuquic yoꞌ bu xchꞌamunoj na ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Istsob la sba ep jchiꞌiltac noxtoc, inoj la ti yut nae. Li lajchavoꞌe mi jaꞌuc xa la stacꞌ xveꞌic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ti cꞌalal iyaꞌiic ti yitsꞌintaque ti toj ep crixchanoetic stsoboj sba yoꞌ bu xchꞌamunoj na ti Jesuse, tal ox la yiqꞌuic loqꞌuel. ―Yuꞌun nan chlic xchuvaj ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tey la jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, liꞌ la liquemic echꞌel ta Jerusalene. ―Li vinic leꞌe jaꞌ ochem ta yoꞌon ti totil pucuje. Ta syuꞌel totil pucuj ti tsloqꞌues pucujetic ti ochem ta yoꞌonic li crixchanoetique ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","―Nopojanic tal liꞌtoe ―xꞌutatic la yuꞌun Jesús ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe―. Ti Satanase ¿miꞌn la tscꞌan tsloqꞌues anaꞌojic ti jaꞌ onox xchiꞌil ta pucujal ti tey ochem ta yoꞌonic li crixchanoetique? ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ti yechuc tspase, coꞌol xchiꞌuc jun preserente ti tscrontain sbaic xchiꞌuc li xchiꞌiltac ta meltsanejcꞌope, ta xchꞌac o sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Coꞌol xchiꞌuc jchop jnaclomal mi chut sbaique, ta xchꞌac o sbaic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jaꞌ noꞌox yech ti Satanase, ti mi tsloqꞌues xchiꞌil ta pucujal ti ochem ta yoꞌonic li crixchanoetique, mu xuꞌ jal tspas mantal ti mi yech tspase. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Caltic noꞌox yaꞌel ti oy muchꞌu yoꞌonuc ochuc ta sna jun tsatsal vinique ti yoꞌonuc yelcꞌanbe li cꞌusuc yuꞌune. Jaꞌ tscꞌan ti baꞌyi ta xchuc li vinique yoꞌ xcuch o yuꞌun yelcꞌanbel li cꞌusuc yuꞌune. Ti Satanase coꞌol xchiꞌuc tsatsal vinic yaꞌel. Li voꞌone icuch xa cuꞌun spojbel li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ta melel chacalbeic, ti muchꞌutic chopol cꞌusitic tspase, mi tspꞌisic ta pucuj ti Rioxe, ch-aqꞌueic to ta pertonal mi tscꞌanbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jaꞌ noꞌox ti muchꞌutic tspꞌisic ta syuꞌel pucuj ti Chꞌul Espíritue, mu xa xꞌaqꞌueic o ta pertonal ta sbatel osil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ti xꞌelan iꞌalbatique, jaꞌ la ti iyalic ti ochem pucuj ta yoꞌon ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tey la icꞌot yitsꞌintac ti Jesuse xchiꞌuc la ti smeꞌique yuꞌun la ba scꞌoponic ti Jesuse. Tey la vaꞌajtic ta tiꞌna, istaquic la ta iqꞌuel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ep la ti muchꞌutic tey chotajtic ta jujot xocon ti Jesuse. ―Tey ta tiꞌna ameꞌ xchiꞌuc avitsꞌintac yuꞌun la tscꞌan chascꞌopon ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","―Chcal avaꞌiic ti muchꞌutic coꞌol xchiꞌuc jmeꞌe, ti coꞌol xchiꞌuc quitsꞌintaque ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jaꞌo la ixchol ta qꞌuelel ti muchꞌutic tey chotajtique. ―Li jayvoꞌ liꞌi jaꞌ coꞌol xchiꞌuc jmeꞌ, jaꞌ coꞌol xchiꞌuc quitsꞌintac yaꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Scotol ti muchꞌutic jaꞌ tspasic cꞌusi tscꞌan ti Rioxe, jaꞌ coꞌol xchiꞌuc jmeꞌ, coꞌol xchiꞌuc quitsꞌintac, coꞌol xchiꞌuc quixleltac yaꞌel ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ibat la ta tiꞌnab ti Jesuse. Tey la ichanubtasvan noxtoc. Ep la tajmec jchiꞌiltac ta israelal istsob sbaic. Ti Jesuse iꞌoch la chotluc ta yut canova, tey la xcajet ta ba voꞌ. Ti crixchanoetique tey la lamal ta tiꞌnab. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ti cꞌalal ichanubtasvan ti Jesuse, ep la cꞌusi iyal ta loꞌil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Aꞌyic me li cꞌusi chcale. Caltic noꞌox yaꞌel ti oy jun vinic ba svaj strigoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ti cꞌalal isvaje, oy jlom ta be icꞌot. Ital mutetic, istam. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oy jlom ta tontic icꞌot, ti bu chꞌabal lec slumale. Ora ivocꞌ yuꞌun muc bu pim slumal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Cꞌalal iqꞌuepe, icꞌanub, itaquij yuꞌun chꞌabal lec yisim. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oy jlom ta chꞌixtic icꞌot. Ti cꞌalal ichꞌi li chꞌixe, iyolontaj li trigoe, jaꞌ ichꞌajub o, muc bu ibeqꞌuin. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oy jlom ta lequil balamil icꞌot, ibeqꞌuin. Oy iyacꞌ lajuneb xchaꞌvinic (30), oy iyacꞌ oxvinic (60), oy iyacꞌ cien. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Voꞌoxuc ti avaꞌiic ti cꞌusi icale, nopbeic smelol ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Li lajchavoꞌe xchiꞌuc ti muchꞌutic ichiꞌinvan sjil cꞌacꞌale, ti cꞌalal stuquic xaꞌox tey xchiꞌuquic ti Jesuse, isjacꞌbeic la cꞌusi smelol ti loꞌil iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","―Li voꞌoxuque jamal lacalbeic cꞌu xꞌelan tspas ta mantal crixchanoetic ti Rioxe. Li yantique ta loꞌil noꞌox chcalbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ep ta echꞌel iyilic ti oy jlequilal jyuꞌelale, pero coꞌol xchiꞌuc muc xilic. Ep ta echꞌel iyaꞌiic ti cꞌusi icale, pero muc xaꞌibeic smelol yuꞌun stoyoj sbaic. Jaꞌ ti mu xictaic spasel li cꞌusitic chopole, yechꞌo ti mu xꞌacꞌbatic pertonal yuꞌun li smulique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","’Ti mi muc xavaꞌibeic smelol li loꞌile, jaꞌ noꞌox yech mu xavaꞌibeic smelol li yan loꞌil ti ta to xcale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Li jvajtrigoe jaꞌ seña ti muchꞌu chal li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Li becꞌ trigo ti icꞌot ta bee, jaꞌ seña ti muchꞌutic yaꞌyojic xa li scꞌop Rioxe, pero mu xchꞌunic. Ta xtal ta ora ti pucuje, chtal chꞌaybatuc ta sjolic li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Li becꞌ trigo ti icꞌot ta tontique, jaꞌ seña ti muchꞌutic cꞌalal chaꞌiic li scꞌop Rioxe, ora ta xchꞌunic, jun xa yoꞌonic yilel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero mu sjunuluc yoꞌon ta xchꞌunic. Ti cꞌalal xꞌilbajinatique, ora chicta sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Li becꞌ trigo ti icꞌot ta chꞌixtique, jaꞌ seña ti muchꞌutic yaꞌyojic xa li scꞌop Rioxe pero jaꞌ noꞌox ta yoꞌonic li cꞌusitic oy ta sba balamile. Jaꞌ chloꞌloatic o. Cꞌusuc noꞌox chpichꞌ o yoꞌonic. Jaꞌ yolontabil chcom yaꞌel li scꞌop Rioxe yuꞌun mu jꞌechꞌeluc ta xchꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Li becꞌ trigo ti icꞌot ta lequil balamile, ti iyacꞌ lajuneb xchaꞌvinique (30), ti iyacꞌ oxvinique (60), ti iyacꞌ ciene, jaꞌ seña ti muchꞌutic jꞌechꞌel ta xchꞌunic li scꞌop Rioxe. Coꞌol xchiꞌuc chbeqꞌuin yaꞌel yuꞌun chalic aꞌyuc li scꞌop Rioxe. Acꞌu mi ch-ilbajinatic, mu xicta o sbaic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ti Jesuse jaꞌ la yech lic yal noxtoc: ―Muc muchꞌu ta stsan scas ti jaꞌo tsmac ta almule, ti jaꞌo tsticꞌ ta yolon teme. Toyol onox chacꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Li cꞌusitic lacalbeique, jamal me xavalic ti cꞌusi orae, mu me avoꞌonicuc noꞌox snaꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Voꞌoxuc ti avaꞌiic ti cꞌusi icale, nopbeic smelol ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iꞌalbatic la noxtoc: ―Aꞌibeic me lec smelol li cꞌusi chacalbeique. Ti jaypꞌel chachꞌunic li cꞌusi chacalbeique, más to chaspꞌijubtasic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ti muchꞌutic sjunul yoꞌon ta xchꞌunique, más ta xpꞌijubtasatic yuꞌun ti Rioxe yoꞌ xchꞌunic o leque, yuꞌun tscꞌan ta xchꞌunic. Yan ti muchꞌutic mu sjunuluc yoꞌon ta xchꞌunique, ti jaypꞌel snaꞌique ta xpojbatic ta jmoj ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ti Jesuse jaꞌ la yech lic yal noxtoc: ―Ti Rioxe tey snaꞌoj stuc cꞌu xꞌelan tspas ta mantal crixchanoetic. Coꞌol xchiꞌuc trigo ti isvaj ta yosil jun vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Li vinique jun yoꞌon chvay. Cꞌalal sacube, chlic. Jaꞌ noꞌox chil ti ivocꞌ xa li strigoe pero mu snaꞌ cꞌu xꞌelan ivocꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yuꞌun snaꞌoj ta xchꞌi stuc. Baꞌyi chlocꞌ yanal, tsꞌacal to chlic beqꞌuinuc, tsꞌacal to chyijub. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti cꞌalal xyijube, chba slocꞌ yuꞌun yora xa ta loqꞌuel ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ti Jesuse jaꞌ la yech lic yal noxtoc: ―Chacalbe avaꞌiic cꞌu xꞌelan tspasvan ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Acꞌu mi muc bu ep lavie, pero ta to xpꞌol. Coꞌol xchiꞌuc becꞌ mustisya ti biqꞌuit tajmeque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero cꞌalal xchꞌie, más toyol chbat. Jaꞌ mu sta yech li yan tsꞌunubiletic ti biqꞌuitic sbeqꞌue. Li mustisyae yijic scꞌobtac. Chtal mutetic, tey tspas stsoꞌopic ta scꞌobcꞌobtac yuꞌun oy lec squevual ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ti cꞌu xꞌelan tspas mantal ti Rioxe, naca la ta loꞌil iyal ti Jesuse yoꞌ la mu xicta o sbaic ta yaꞌyel li jchiꞌiltac ta israelale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti cꞌusitic iyale, naca la ta loꞌil. Li lajchavoꞌe cꞌalal stuquic xa xchiꞌuquic ti Jesuse, iꞌalbatic la cꞌusi smelol ti loꞌiletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ti cꞌalal iꞌicꞌub osile ―Batic ta jech nab ―xꞌutatic la yuꞌun Jesús li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iscꞌoponic la comel ti crixchanoetic tey lamalic ta tiꞌnabe, jaꞌo la iꞌochic echꞌel ta canova ti tiqꞌuil o onox ti Jesuse. Tey la ibat yan canovaetic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jaꞌo la ilic tsots icꞌ, xyucꞌyon xa la tajmec li nabe. Ep la iꞌoch voꞌ ta yut canova, chmuc xaꞌox la yalel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti Jesuse tey la vayem ta chac canova, yacꞌoj la xonjol. Istijic la. ―Jchanubtasvanej, ¿mi muc ta alel avuꞌun ti chimucotic xa yalele? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ilic la ti Jesuse, ispajes la li iqꞌue, ivaxi la yuꞌun li nabe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","―¿Cꞌu yuꞌun ti chaxiꞌique? ¿Mi mu to bu achꞌunojic yaꞌel ti voꞌon tsots jyuꞌele? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Más to la ixiꞌic. Xalxalbe xa la sbaic: ―¿Muchꞌu li vinic liꞌi ti jliquel ispajes li iqꞌue, ti ivaxi yuꞌun li nabe? ―xut xa la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Icꞌotic la ta jech nab ta steclumal jgadaraetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ti cꞌalal iloqꞌuic ta canovae, ital la jun vinic, ochem la pucuj ta yoꞌon. Ta muquenal la ilocꞌ tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jaꞌ xa la snainoj li chꞌojbil tonetic yoꞌ bu chichꞌic tiqꞌuel ti ánimaetique. Mu la muchꞌu xchuc yuꞌun, mi jaꞌuc la ta carina. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ep la ta echꞌel ichucbat yoc scꞌob ta carina pero ituchꞌ la yuꞌun. Mu la muchꞌu stsac yuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ta cꞌacꞌal acꞌubal tey la xꞌavet ta vitstic xchiꞌuc ta muquenal. Ta la stam ton, tsyayijes o la sba. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ti vinique nomnom toꞌox la iyil ti Jesuse, anil la ital, yul la squejan sba ta yichon. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Iꞌavan la. ―¿Cꞌusi acuentaon o li voꞌote? Jesús, Xchꞌamal Riox ta vinajel. Mu me xavacꞌbon castico. Ti Rioxe yaꞌyoj ti xꞌelan chacalbee ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ti xꞌelan iyale, yuꞌun la iyal xaꞌox ti Jesuse ti acꞌu locꞌuc ti pucuj ta yoꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","―¿Cꞌusi abi? ―xꞌutat la yuꞌun Jesús ti vinique. ―Lejion. Yuꞌun oy jaymil liꞌ ochemoticotic ta yoꞌon li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Abulajan, mu xatacoticotic loqꞌuel liꞌ ta slumal jgadaraetique ―xutic la Jesús ti pucujetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jaꞌo la tey xlamet ep chitometic ta chꞌut vits. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","―Abulajan alo acꞌop ti chiꞌochoticotic ta chitometique ―xi la ti pucujetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ti Jesuse iyacꞌ la permiso. Ti pucujetique ilocꞌ la ta yoꞌon ti vinique, iꞌochic la ta chitometic. Ti chitometique oy la chaꞌmiluc. Stusus xa la yalel scotol, ipꞌajic la ta nab, ijicꞌav la scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ti jchabichitometique ixiꞌic la. Ba la yalic ta jteclum, ba la yalbeic ti muchꞌutic tey nopol nacajtic uque. Ti crixchanoetique tal la sqꞌuelic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ti cꞌalal icꞌotic yoꞌ bu ti Jesuse, iyilic la ti tey xa chotol ti vinique ti ochem toꞌox ep pucujetic ta yoꞌone. Oy xa la scꞌuꞌ, lec xa la. Ixiꞌic o la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ti muchꞌutic iyilic ti cꞌu xꞌelan ilecub ti vinic ochem toꞌox pucujetic ta yoꞌone, xchiꞌuc ti cꞌu xꞌelan icham ti chitometique, iyalbeic la ti muchꞌutic tey laj cꞌotuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Scotol ti crixchanoetique jaꞌ la yech lic yalbeic ti Jesuse: ―Abulajan locꞌan echꞌel liꞌtoe ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti cꞌalal iꞌoch ta canova ti Jesuse ―Chajchiꞌin echꞌel ―xi la tajmec ti muchꞌu ochem toꞌox pucujetic ta yoꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","―Iꞌi. Batan ta ana, ba albo lachiꞌiltaque ti lascꞌuxubin xa ti Rioxe, ti ilocꞌ xa ti pucujetic ta avoꞌone ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ibat la ti vinique, ba la yal aꞌyuc ta Decapolis yoꞌ bu lajuneb jteclumetique ti iloqꞌuesbat pucujetic ta yoꞌon yuꞌun ti Jesuse. Ti cꞌalal iyaꞌiic ti crixchanoetique, xchꞌayet xa la yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ti cꞌalal isut noxtoc ta jech nab ti Jesuse, ep la tajmec jchiꞌiltac istsob sbaic ta tiꞌnab yoꞌ bu icꞌote. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tey la icꞌot jun jmeltsanejcꞌop ta templo teyoꞌe, Jairo la sbi. Ti Jairoe, cꞌalal iyil ti Jesuse, isquejan la sba ta yichon, jaꞌo la isnijan sba ta balamil noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","―Ta xcham xa jtseb. Abulajan ba acꞌo acꞌob ta sba yoꞌ xcuxi oe ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ti Jesuse ibat la xchiꞌuc. Tey la napꞌalic echꞌel slajchavaꞌalic xchiꞌuc epal crixchanoetic, snetꞌnetꞌ xa la sbaic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Oy la jun ants, slajchebal xa la jabil ti mu xmac xchamele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ep la isaꞌ jpoxtavanej, muc la xqꞌuele lec, muc la xmac o ti chamele. Más la iꞌipaj o. Ilaj la scotol ti staqꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iyaꞌi la ti chetꞌes chamel ti Jesuse, napꞌal la ibat ta spat ti epal crixchanoetique. Ispitsꞌ la sba jelavel, ista la ta picbel spimilcꞌuꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Acꞌu mi spimilcꞌuꞌ noꞌox jpicbe, ta xmac o li jchamele”, xi la ta yoꞌon ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ora la imac ti xchamele, iyaꞌi la ti lec xae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ti Jesuse iyaꞌi la ti oy muchꞌu iꞌechꞌ xa xchamel ta syuꞌele. Ijoyij la, isqꞌuel la ti crixchanoetique. ―¿Muchꞌu taj lispicbe jcꞌuꞌe? ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","―Tol chnetꞌvan chavil li crixchanoetique. ¿Cꞌu yuꞌun ti chajacꞌ ti muchꞌu laspique? ―xiic la li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ti Jesuse isqꞌuel la ta jujot xocon ti muchꞌu ipicbon ti spimilcꞌuꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ti antse xtꞌeltꞌon xa la ta xiꞌel yuꞌun la snaꞌoj ti jaꞌ ilecub oe. Isquejan la sba ta yichon ti Jesuse, jaꞌo la isnijan sba ta balamil noxtoc. Jamal la iyalbe ti ta scoj chamel ti ispicbe spimilcꞌuꞌe, ti jaꞌ ilecub o ti cꞌalal ispique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","―Ants, yuꞌun achꞌun ti oy jyuꞌele, yechꞌo ti lecot xae. Mu cꞌu xal avoꞌon, batan ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ti cꞌalal yolel chloꞌilaj ti Jesuse, jaꞌo la ital jayvoꞌ ti muchꞌutic teyic ta sna ti Jairoe. ―Icham xa latsebe. Yech xa noꞌox chba yacꞌ svocol li Jchanubtasvaneje ―xutic la yulel ti Jairoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ti Jesuse, cꞌalal iyaꞌi ti cꞌusi iꞌalbat ti jmeltsanejcꞌope ―Mu xavat avoꞌon. Jaꞌ noꞌox chꞌuno ti oy jyuꞌele ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ti Jesuse mu la scꞌan xchiꞌin echꞌel ep crixchanoetic. Jaꞌ no la iyicꞌ echꞌel li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc yitsꞌin, jaꞌ li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ti cꞌalal icꞌot ta sna jmeltsanejcꞌop ti Jesuse, iyil la ti xnechetique, ti tol ch-ocꞌ ch-avanique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ti Jesuse iꞌoch la ta yut na. ―¿Cꞌu yuꞌun ti xanechetique, ti tol chaꞌoqꞌuique? Li tsebe muc bu chamem, ta xvay noꞌox ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tseꞌej la xaꞌi scotolic ti xꞌelan iyale yuꞌun la snaꞌojic ti ichame. Ti Jesuse istac la loqꞌuel scotol ti muchꞌutic teyique. Jaꞌ noꞌox la teyic ti stot smeꞌ tsebe xchiꞌuc li oxvoꞌe. Iꞌochic la echꞌel yoꞌ bu telel ti ánimae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti Jesuse istsacbe la scꞌob ti tsebe. ―Talita cumi ―xut. Li talita cumie, “tseb, chacalbe lican”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ora la ichaꞌcuxi ti tsebe, ilic la, ixanav la yuꞌun lajcheb xa sjabilal. Xchꞌayet xa la yoꞌonic ti muchꞌutic teyique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ti Jesuse tsots la iyalbe ti stot smeꞌ tsebe ti mu me muchꞌu xalbeique. Iyalbe la noxtoc ti acꞌu yacꞌbeic sveꞌel ti tsebe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ti Jesuse ilocꞌ la teyoꞌe, ibat la ta steclumal ta Nazaret. Ibatic la li lajchavoꞌ uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ti cꞌalal icꞌot scꞌacꞌalil ta xcuxic li jchiꞌiltac ta israelale, ti Jesuse ibat la ta templo teyoꞌe, cꞌot la chanubtasvanuc. Ep la ti muchꞌutic iyaꞌiic ti cꞌusi iyal ti Jesuse, xchꞌayet xa la yoꞌonic. ―¿Bu ista spꞌijil li jchiꞌiltic leꞌe ti naca lec li cꞌusi chale? ¿Bu ista syuꞌel ti scotol cꞌusi xuꞌ tspase? ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pero jaꞌ li carpinteroe, jaꞌ yol li Maríae. Jaꞌ sbanquilic li Jacoboe, xchiꞌuc li Josee, xchiꞌuc li Judase, xchiꞌuc li Simone. Jaꞌ xibnelic noxtoc li antsetic ti liꞌ nacajtic jchiꞌuctique ―xut la sbaic. Yechꞌo la ti muc xichꞌic ta mucꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","―Li muchꞌutic chalic aꞌyuc li scꞌop Rioxe, mi chbatic ta yan o jteclume, ch-ichꞌbatic ta mucꞌ. Yan ta steclumal stuquique, xchiꞌuc yoꞌ bu li xchiꞌilic ta ayanele, xchiꞌuc ta snaique, mu xꞌichꞌbatic ta mucꞌ ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yechꞌo la ti muc bu ep iyacꞌ iluc slequilal syuꞌelal ta steclumal ti Jesuse. Jaꞌ noꞌox la iꞌechꞌ xchamelic ti jayvoꞌ iyacꞌbe scꞌob ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ti Jesuse xchꞌayet xa la yoꞌon ti mu xchꞌunique. Jaꞌo la ibat ta parajeletic ti tey noꞌox nopolic ta Nazarete, ichanubtasvan la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Li lajchavoꞌe itsobatic la yuꞌun ti Jesuse. Ta chaꞌchaꞌvoꞌ la itaqueic echꞌel. Iꞌacꞌbat la syuꞌelic ti xuꞌ tsloqꞌuesbeic pucujetic ta yoꞌon li jchiꞌiltaque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iꞌalbatic la ti jaꞌ noꞌox chichꞌ echꞌel snamteꞌique, ti mu yaꞌuc yichꞌ echꞌel sveꞌelique, mi jaꞌuc snutiꞌic, mi jaꞌuc staqꞌuinic, ti mu me cꞌusi yan xichꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jaꞌ noꞌox la iꞌalbatic ti acꞌu slap echꞌel xonobique, ti mu me slap echꞌel chaꞌlom scꞌuꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","―Ti bu nail chcꞌot achꞌamunique teanic o me ti cꞌu sjalil teyoxuc ta jteclume. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mi oy bu jteclumal ti mu xacꞌ ta chꞌom snaique, mi mu scꞌan xaꞌiic li cꞌusi chavalique, locꞌanic teyoꞌe. Lilinic comel spucucal avoquic, jaꞌ seña ti chcom ta sba stuquic ti mu xchꞌunic pasel ta mantal yuꞌun ti Rioxe. Ta melel chacalbeic, ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil li crixchanoetique, más castico chichꞌic li jchiꞌiltactic ti bu mu xayotesique. Jaꞌ jutuc noꞌox castico chichꞌic ti jsodomaetique xchiꞌuc ti jgomorraetic ti ta más voꞌnee ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iloqꞌuic la echꞌel slajchavaꞌalic, ba la yalbeic li jchiꞌiltac ta israelale ti acꞌu yictaic spasel li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ep la isloqꞌuesic pucujetic ti ochem ta yoꞌonic ti jchiꞌiltaque. Ep la jchameletic isjaxbeic jutsꞌuj aceite, iꞌechꞌ o la ti chamele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ti covierno Erodese iyaꞌi la ti ep cꞌusitic tspas ti Jesuse yuꞌun la vinajem scꞌoplal. ―Taje jaꞌ nan ti Juan jꞌacꞌ-ichꞌvoꞌe. Yuꞌun nan ichaꞌcuxi, yechꞌo ti oy syuꞌele ―xi la ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","―Jaꞌ nan ti jꞌalcꞌop Elías ti ta voꞌnee ―xi la jlom. ―Jaꞌ nan yajꞌalcꞌop Riox chac cꞌu chaꞌal ti yajꞌalcꞌoptac ti ta voꞌnee ―xi la jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ti cꞌalal iyaꞌi cꞌusi iyal crixchanoetic ti Erodese ―Jaꞌ nan ti Juan icacꞌ ta tuchꞌbel sjole. Yuꞌun nan ichaꞌcuxi ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jaꞌ la ta smantal ti Erodese ti itsac ti Juane, ti ichuque ta carina ta yut chuclebale yoꞌ la mu xtae o ta milel yuꞌun ti yajnil toꞌox yitsꞌine. Erodías sbi ti antse. Felipe sbi ti yitsꞌine. Yuꞌun la spojojbe yajnil yitsꞌin ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","―Maꞌuc yech chal li leye ti apojbe yajnil lavitsꞌine ―xꞌutat la yuꞌun Juan ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jaꞌ la chopol iyaꞌi ti Erodíase ti xꞌelan iyal ti Juane, yoꞌonuc la smil. Pero mu la cꞌuxi sta ta milel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ti Erodese iyichꞌ la ta mucꞌ ti Juane yuꞌun la snaꞌoj ti lec yoꞌone, ti mu snaꞌ saꞌ smule. Yechꞌo un iyal la ti acꞌu xchabiele yoꞌ la mu xtae o ta milel yuꞌun ti antse. Ti cꞌalal chaꞌi cꞌusi ch-alulanbat yuꞌun ti Juane, mu xa la aꞌibaj cꞌusi tsnop. Jaꞌ noꞌox la ti sjunul yoꞌon chaꞌie. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero ti Erodíase ista la ti cꞌu to xi xuꞌ chacꞌ ta milel ti Juane yuꞌun la ilocꞌ sjabilal ti Erodese, ispas la sqꞌuinal. Ismacꞌlin la ti jyuꞌeletique xchiꞌuc capitan solteroetic xchiꞌuc moletic ti tey ta Galileae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti stseb Erodíase iꞌoch la echꞌel yoꞌ bu chveꞌique, iꞌacꞌotaj la. Ti cꞌu xꞌelan iꞌacꞌotaje, lec la iyil ti Erodese xchiꞌuc ti muchꞌutic tey tsobol xchiꞌuc ta mexae. ―Cꞌanbon ti cꞌusi chacꞌane, chacacꞌbe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Acꞌu mi xacꞌan oꞌloluc ti bu cꞌalal jcuentainoj li balamile, lojriox chacacꞌbe ―xut la tseb ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ti tsebe ilocꞌ la, ba la sjacꞌbe smeꞌ ti cꞌusi tscꞌanbe ti Erodese. ―Meꞌ, ¿cꞌusi ta jcꞌan xanaꞌ? ―xut la. ―Jaꞌ cꞌanbo sjol li Juan jꞌacꞌ-ichꞌvoꞌe ―xi la ti smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ti tsebe ora la iꞌoch yoꞌ bu ti Erodese. ―Jaꞌ ta jcꞌan ti chavacꞌbon tal ta ora ta plato sjol li Juan jꞌacꞌ-ichꞌvoꞌe ―xut la cꞌotel ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ti Erodese iyat la yoꞌon tajmec. Ta scoj ti isvaꞌan ta rextico ti Rioxe xchiꞌuc ti yaꞌyojic noxtoc ti muchꞌutic tey xchiꞌuc ta mexae, mu la xuꞌ chaꞌi ti tsnop cꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jaꞌo la istac echꞌel jun yajsoltero ti acꞌu ba stuchꞌbe tal sjol ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ibat la ta chuclebal ti solteroe, ba la stuchꞌbe tal sjol ti Juane. Ispachbe la tal ta plato, iyacꞌbe la ti tsebe. Ti tsebe ba la yacꞌbe ti smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ti cꞌalal iyaꞌi ti yajchancꞌoptaque, ay la sloqꞌuesic, ba la smuquic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ti cꞌalal isutic li apoxtoletique, cꞌot la yalbeic ti Jesuse ti cꞌusitic ispasique, xchiꞌuc ti cꞌu xꞌelan ichanubtasvanique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","―Laꞌic, jchꞌac jbatic echꞌel, ba jsaꞌtic bu qꞌuejeltique. Ba cuxic jliqueluc ―xꞌutatic la yuꞌun ti Jesuse. Yuꞌun la xtal xbat tajmec ti crixchanoetique, mi jaꞌuc la stacꞌ xveꞌic jliqueluc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yechꞌo un iꞌochic la echꞌel ta canova, ibatic la ta qꞌuejeltic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ti cꞌalal ibatique, ep la muchꞌutic iꞌilvan. Iyojtiquinic la ti jaꞌ ti Jesuse, ibatic la ta tiꞌtiꞌnab, anilic la echꞌel. Ep la jteclumetic ti bu iliquic echꞌele. Jaꞌ la baꞌyi icꞌotic ti bu chcꞌot ti Jesuse. Jaꞌ la tsꞌacal to icꞌot ti Jesuse xchiꞌuc li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ti cꞌalal ilocꞌ ta canova ti Jesuse, ep la tajmec jchiꞌilticotic tey tsobolic cꞌot sta. Iscꞌuxubin la yuꞌun la coꞌolic xchiꞌuc chij ti chꞌabal xchabielique. Lic la xchanubtas. Ep la cꞌusitic iyal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ti cꞌalal imal cꞌacꞌale, li lajchavoꞌe lic la yalbeic ti Jesuse: ―Mu cꞌusi oy liꞌtoe. Mal xa cꞌacꞌal noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Más lec taco echꞌel li crixchanoetique, acꞌu ba sman sveꞌelic ta parajeletic ti liꞌ noꞌox nopolique ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","―Macꞌlinic voꞌoxuc ―xꞌutatic la yuꞌun ti Jesuse. ―¿Bu chba jmanticotic tal chibuc cien denario pan ti chcacꞌbeticotic sveꞌique? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","―Ba qꞌuelic jaypꞌej pan avichꞌojic tal ―xꞌutatic la. Ti cꞌalal iyilic jaypꞌeje, ba la yalbeic ti Jesuse: ―Cꞌajom noꞌox voꞌpꞌej pan xchiꞌuc chaꞌcot choy ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ti Jesuse iyalbe la ti crixchanoetique ti acꞌu chotlicuc ta stentejtique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ta spotolpotol la ichotiic. Oy la ta cien, oy la ta cincuentatic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ti Jesuse ixchꞌam la ti voꞌpꞌej pane xchiꞌuc ti chaꞌcot choye, isqꞌuel la vinajel, “colaval”, xut la ti Rioxe. Jaꞌo la ixut ti pane, iꞌacꞌbatic la li lajchavoꞌe. Li lajchavoꞌe jaꞌ xa la iyacꞌbeic ti crixchanoetique. Ti Jesuse ixchꞌac la noxtoc ti chaꞌcot choye, iꞌacꞌbatic la li lajchavoꞌe, jaꞌ xa la iyacꞌbeic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iveꞌ la scotolic, lec la inojic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Li lajchavoꞌe istsobic la ti pane xchiꞌuc ti choye ti cꞌu yepal muc xlaj yuꞌun ti crixchanoetique, inoj la lajcheb moch ti sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ti cꞌu yepal iveꞌique oy la voꞌmiluc ti viniquetic noꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tsꞌacal to li lajchavoꞌe lic la albaticuc yuꞌun ti Jesuse: ―Ochanic echꞌel ta canova, tꞌab batanic ta jech nab ta jteclum Betsaida ―xꞌutatic la. Ti Jesuse tey to la icom. Stuc xa la iscꞌopon comel ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ti cꞌalal laj scꞌopon comele, imuy la ta vits, ba la scꞌopon Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ti cꞌalal iꞌoch orisyone, oꞌlol xaꞌox la nab xloqꞌuic echꞌel li lajchavoꞌe. Ti Jesuse stuc la tey ta vits. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iyil la ti chlubic xa ta xanubtasel ti canovae, yuꞌun la toj tsots li icꞌ ital ta yelavique. Ti cꞌalal poꞌot xaꞌox sacube, tal la staelic yuꞌun ti Jesuse. Ixanav la tal ta yoc ta ba nab. Tucꞌ ox la chjelav yilel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ti cꞌalal iyilic ti chanav tal ta ba nabe ―Chꞌulelal nan ―xiic xa la. Xꞌavlajetic xa la yuꞌun la ixiꞌic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ora la icꞌoponatic yuꞌun ti Jesuse: ―Voꞌon Jesuson, mu me xaxiꞌic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ti cꞌalal iꞌoch ta canova ti Jesuse, ora la ipaj li iqꞌue. Xchꞌayet xa la yoꞌonic li lajchavoꞌe, yuꞌun la mu snaꞌic cꞌuxi ipaj li iqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mu la snaꞌic noxtoc ti jaꞌ ta syuꞌel ti Jesuse ti ipꞌol ti pane, yuꞌun la mu toꞌox ta xchꞌunic ti oy syuꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ti cꞌalal iyulic ta jech nabe, tey la iloqꞌuic ta canova ta jun stentejtic, Genesaret sbi. Tey la ixchuquic comel ti scanovaique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ti cꞌalal ilocꞌ ta canova ti Jesuse, ora la iꞌojtiquine yuꞌun ti jchiꞌiltac ta israelale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ivinaj la ta sjunlej Genesaret ti tey iyul ti Jesuse. Ti cꞌalal iꞌaꞌiat bu chanave, jaꞌ la tey tsqꞌuechic echꞌel ta pop ti jchameletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Buyuc noꞌox la ibat ti Jesuse, acꞌu la mi ta cꞌox jteclumetic, acꞌu la mi ta mucꞌta jteclumetic, acꞌu la mi ta parajeletic, tey la tal spuchꞌanic ta tiꞌilbe ti jchameletique. Oy la jlom jchameletic iscꞌanbeic ti Jesuse ti jaꞌ noꞌox la acꞌu yacꞌ ta piquel ti sne spimilcꞌuꞌe. Ti muchꞌutic ispique iꞌechꞌ o la ti xchamelic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tey la icꞌotic jayvoꞌ jfariseoetic yoꞌ bu ti Jesuse, xchiꞌuc la jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, liꞌ la liquemic echꞌel ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Li lajchavoꞌe iꞌileic la ti oy jayvoꞌic ti muc bu jal ispoc scꞌobic cꞌalal iveꞌique. Ti jfariseoetique chalic ti chopol ch-ileic yuꞌun Riox ti muchꞌutic muc bu jal tspoc scꞌobique. Jaꞌ la yech istaic o mulil ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ti jfariseoetique xchiꞌuc scotol ti jchiꞌiltac ta jurioale jaꞌ xchanojic cꞌu xꞌelan ti voꞌne moletique. Mi jliquel noꞌox tspoc scꞌobique, mu xuꞌ chveꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ti cꞌalal tsutic tal ta chꞌivite, mu xuꞌ chul veꞌicuc mi jliquel noꞌox tspoc scꞌobique. Oy to cꞌusi yan xchꞌunojic, jaꞌ ti cꞌu xꞌelan ta sucꞌ sbochique, xchiꞌuc sjaroique, xchiꞌuc spꞌinique, xchiꞌuc ti ta spoc stemique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ti jfariseoetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, cꞌot la sjacꞌbeic ti Jesuse: ―¿Cꞌu yuꞌun ti maꞌuc yech tspasic avajchancꞌoptac chac cꞌu chaꞌal ispasic ti voꞌne moletique? Yuꞌun jliquel noꞌox tspoc scꞌobic cꞌalal chveꞌique. Ti voꞌne moletique jal ispoc scꞌobic ti cꞌalal iveꞌique yoꞌ lec xꞌileic o yuꞌun ti Rioxe ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","―Yech noꞌox chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Jaꞌ acꞌoplalic ti iꞌalbat yuꞌun Riox ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee. Lachiꞌiltaque yech noꞌox chalic ti chiyichꞌic ta muqꞌue, mu sjunuluc yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Smantal noꞌox crixchano ti ta xchanubtasvanic oe, mu voꞌonicon caloj, xi ti Rioxe, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Li voꞌoxuque maꞌuc chachꞌunic li smantaltac Rioxe. Jaꞌ chachꞌunbeic scostumbreic ti voꞌne moletique, jaꞌ ti cꞌu xꞌelan chasucꞌ lajaroique, xchiꞌuc labochique, xchiꞌuc li cꞌusitic yan chapasique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iꞌalbatic la noxtoc: ―Li voꞌoxuque maꞌuc chachanubtasvanic o li smantaltac Rioxe. Jaꞌ chavalic ti cꞌu xꞌelan scostumbreic ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Ichꞌo ta mucꞌ atot ameꞌ”, xi ti Rioxe. Iyal noxtoc: “Mi oy muchꞌu chopol cꞌusi chalbe li stot smeꞌe, milic”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Yan li voꞌoxuque chachanubtasic ti acꞌu noꞌox yalic ti yacꞌojic xa ta smoton Riox li cꞌusuc yuꞌunique. Mi iyalbeic xa yech li stot smeꞌique ti yacꞌojic xa ta smoton Riox li cꞌusuc yuꞌunique, xuꞌ xa mu scꞌuxubinic li stot smeꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ti xꞌelan chavalique, maꞌuc chachanubtasvanic o li smantaltac Rioxe. Jaꞌ chavalic ti cꞌu xꞌelan scostumbreic ti voꞌne moletique. Oy to cꞌusi yan chavalic noxtoc ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cꞌalal laj yal chac taje ―Nopojanic tal ―xut la scotol jchiꞌilticotic ti Jesuse―. Aꞌibeic me smelol li cꞌusi chacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Li cꞌusitic chalajesique, muc bu chata o amulic ta stojol ti Rioxe. Jaꞌ chata o amulic li cꞌusitic chopol chavalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Voꞌoxuc ti avaꞌiic cꞌusi icale, nopbeic smelol ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ti Jesuse tey la lamal iscomtsan ti crixchanoetique, iꞌoch la ta yut na yoꞌ bu xchꞌamunoje. Li lajchavoꞌe lic la sjacꞌbeic cꞌusi smelol ti cꞌusi iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","―¿Mi muc xavaꞌibeic smelol yaꞌel uc? ¿Mi mu xanaꞌic yaꞌel ti muc bu chata o amulic ta stojol Riox li cꞌusitic chalajesique? ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Li cꞌusitic chalajesique ta achꞌutic noꞌox chcꞌot, chatsaꞌtaic loqꞌuel ―xꞌutatic la yuꞌun ti Jesuse. Ti cꞌusi iyal ti Jesuse, jaꞌ smelol ti naca lec scotol li veꞌlile. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lic la yal noxtoc: ―Ti muchꞌutic chopol cꞌusi chalique, ti chopol cꞌusi tspasique, jaꞌ ta sta o smulic ta stojol ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta yoꞌonic onox ta snopic li cꞌusitic chopole. Tsaꞌ yantsic, tsaꞌ yajmulic, chmilvanic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ch-elcꞌajic, tol xpichꞌ o yoꞌonic li cꞌusitic oye, naca chopol cꞌusitic tspasic, chloꞌlovanic, mu xqꞌuexavic ta spasel li cꞌusitic chopole, tol xacꞌ o scꞌacꞌal yoꞌonic mi oy cꞌusuc yuꞌun li xchiꞌilique, tol xloꞌiltavanic, stoyoj sbaic, mu xichꞌ smelolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Scotol li cꞌusitic chopol liꞌi, ta yoꞌonic chlic tal, jaꞌ tsta o smulic ta stojol ti Rioxe ―xꞌutatic la li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ti Jesuse ilocꞌ la echꞌel teyoꞌe, ibat la ta stsꞌel li chib jteclum Tiroe xchiꞌuc li Sidone. Iꞌoch la ta jpꞌej na. Mu la scꞌan xvinaj ti buye, pero ivinaj onox la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Oy la jun ants, oy la stseb ochem pucuj ta yoꞌon. Iyaꞌi la ta ora ti tey xa ti Jesuse. Tey la icꞌot, isquejan la sba ta yichon ti Jesuse, jaꞌo la isnijan sba ta balamil noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ti antse maꞌuc la jchiꞌilticotic ta israelal, tey noꞌox la liquem ta Sirofenícia. ―Abulajan, loqꞌuesbon pucuj ta yoꞌon li jtsebe ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Itacꞌav la ti Jesuse: ―Oy onox xavaꞌi loꞌil ti nojuc baꞌyuc li unetique. Chopol mi mu xnojique. Chopol mi ta jpojbetic li spanique, mi jaꞌ chcacꞌbetic slajes li cꞌox tsꞌiꞌetique ―xꞌutat la, yuꞌun la chqꞌuele cꞌu xꞌelan chtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","―Yechaꞌa, totic. Pero oy onox chpꞌaj xchꞌuchꞌulil span ta yolon smexa li unetique. Jaꞌ tstam li cꞌox tsꞌiꞌetique. Cꞌuxubinon yech uc ―xi la ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","―Ti xꞌelan latacꞌave, loqꞌuem xa pucuj ta yoꞌon latsebe. Xuꞌ xa xabat ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ti cꞌalal icꞌot ta sna ti antse, loqꞌuem xaꞌox la pucuj ta yoꞌon ti stsebe, puchꞌul xa la ta stem cꞌot sta. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ti Jesuse ilocꞌ la echꞌel ta stsꞌel Tiro, iꞌechꞌ la ta stsꞌel Sidón, iꞌechꞌ la ta Decápolis yoꞌ bu li lajuneb jteclume, tey noꞌox la icꞌot ta tiꞌnab ta estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tey la yicꞌojbeic cꞌotel jun jchiꞌilticotic, umaꞌ la, pacꞌchiquin la noxtoc. ―Abulajan, acꞌo acꞌob ta sba li vinic liꞌi ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ti Jesuse ilocꞌlocꞌ la echꞌel xchiꞌuc ti vinique, ispajbe la sniꞌ scꞌob ta jujun xchiquin ti vinique. Istubta la scꞌob noxtoc, ispicbe la yocꞌ ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ti Jesuse isqꞌuel la vinajel, isjicꞌ la yoꞌon. ―Efata ―xut la ti vinique. Li Efatae “acꞌu jamuc”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ora la ijam ti xchiquine xchiꞌuc ti yee, lec xa la xcꞌopoj. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ti Jesuse iyalbe la ti crixchanoetique ti mu me xalic aꞌyuc ti cꞌusi ispase, pero mu la bu ixchꞌunic. Acꞌu la mi ep ta echꞌel iꞌalbatic ti mu yaꞌuc yalic aꞌyuque, pero más to la iyalic aꞌyuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jaꞌ la ti xchꞌayet xa o yoꞌonic ti cꞌalal iyilique. ―Naca lec li cꞌusitic tspase. Acꞌu mi umaꞌ, chjam yuꞌun ye. Acꞌu mi pacꞌchiquin, chjam yuꞌun xchiquin noxtoc ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti jꞌechꞌele ep la tajmec jchiꞌilticotic istsob sbaic yoꞌ bu ti Jesuse, mu xa la cꞌu slajesic. Li lajchavoꞌe itsobatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Toj abol sbaic chquil li jchiꞌiltactic liꞌi yuꞌun yoxibal xa cꞌacꞌal liꞌ jchiꞌuctique, mu xa cꞌu slajesic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ti mi ta jtac echꞌel ta snaic lavi muc bu veꞌemique, yicꞌal xlubtsajic ta be yuꞌun nom liquemic tal li jlome ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","―¿Bu ta jtaticotic ep pan liꞌ ta xocol balamile ti ta jmacꞌlinticotic oe? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","―¿Jaypꞌej to li jpantique? ―xꞌutatic la. ―Vucpꞌej ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ti Jesuse iyalbe la ti crixchanoetique ti acꞌu chotlicuque. Ixchꞌam la ti vucpꞌej pane, “colaval”, xut la ti Rioxe. Jaꞌo la ixut ti pane, jaꞌ la iꞌacꞌbatic li lajchavoꞌe. Jaꞌ xa la iyacꞌbeic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oy la jaycot scꞌox choyic noxtoc. Ti Jesuse “colaval” xut la noxtoc ti Rioxe. ―Acꞌbeic li crixchanoetique ―xꞌutatic la noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iveꞌ la scotolic, lec la inojic. Istsobic la ti cꞌu yepal muc xlaj yuꞌun ti crixchanoetique, inoj la vucub moch ti sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Oy la chanmiluc ti iveꞌique. Ti cꞌalal laj veꞌicuc ti crixchanoetique ―Batanic xa un ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Li lajchavoꞌe jaꞌo la iꞌoch xchiꞌuquic ta canova ti Jesuse, italic la ta stsꞌel Dalmanuta. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tey la icꞌotic jayvoꞌ jfariseoetic, oy la cꞌusi isjacꞌbeic ti Jesuse yoꞌ la stabeic o smul ti yalojique. ―Acꞌo quilticotic mi yech ti oy ayuꞌele. Jqꞌueltiquic mi oy cꞌusi xyal tal avuꞌun ta vinajel yoꞌ jchꞌunticotic o ti stacojot tal ti Rioxe ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ti Jesuse isjicꞌ la yoꞌon, yuꞌun la toj chopol iyaꞌi ti mu xchꞌunic tajmeque. ―Voꞌoxuc ti cuxuloxuc lavie, avilic ti oy jyuꞌele. ¿Cꞌu yuꞌun chacꞌanic ti oy cꞌusi ta jyales tal ta vinajele? Ta melel chacalbeic, lavie mu xcacꞌ avilic ti oy jyuꞌele ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ti Jesuse tey la iscomtsan ti jfariseoetique, iꞌoch la ta canova xchiꞌuc li lajchavoꞌe, ibatic la ta jech nab. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Li lajchavoꞌe muc la snaꞌ xichꞌ echꞌel spanic. Cꞌajom la jpꞌej pan tey ta scanovaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","―Qꞌuelo me abaic ta svuquesobil xchꞌut span li jfariseoetique xchiꞌuc li Erodese ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","―Ti xꞌelan chale, jaꞌ nan ti muc jnaꞌtic tal ti jpantique ―xut xa la sbaic li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ti Jesuse snaꞌoj la ti cꞌusi chalique. ―¿Cꞌu yuꞌun ti xavalvalbe abaic ti muc xanaꞌic tal ti jpantique? Yuꞌun mu to bu achꞌunojic yaꞌel ti voꞌon tsots jyuꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oy asatic pero coꞌol xchiꞌuc mu xavilic. Oy achiquinic pero coꞌol xchiꞌuc mu xavaꞌiic. ¿Mi ichꞌay xa xavaꞌiic ti cꞌusitic ijpase? ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ti cꞌalal ijxutilan ti voꞌpꞌej pane cꞌalal ijmacꞌlintic ti voꞌmil viniquetique, ¿jayib moch inoj ti sovrae? ―xꞌutatic la. ―Lajcheb ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Ti cꞌalal ijxutilan ti vucpꞌej pane cꞌalal ijmacꞌlintic ti chanmile, ¿jayib moch inoj ti sovrae? ―xꞌutatic la. ―Vucub ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","―¿Mi mu to xavaꞌibeic smelol li cꞌusi lacalbeique? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ti Jesuse tey la icꞌot ta jteclum Betsáida. Tey la yicꞌojbeic cꞌotel jun jchiꞌilticotic, maꞌsat la. ―Abulajan, picbo sat li vinic liꞌi ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ti Jesuse istsacbe la scꞌob ti maꞌsate, isnit la loqꞌuel ta tiꞌ jteclum. Istubtabe la ti sate, ispicbe la ta xchibal scꞌob. Isjacꞌbe la mi xil xa osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ti vinique isqꞌuel la osil. ―Chquil li crixchanoetique pero coꞌol xchiꞌuc teꞌ yilel, jaꞌ noꞌox ti chanavique ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ti Jesuse ispicbe la noxtoc ti sate. Ti vinique isqꞌuel la noxtoc li osile. Lec xa la icom ti sate, lec xa la xil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ti Jesuse istac la sutel ta sna: ―Mu me xaꞌechꞌ ta yutil jteclum, mu me muchꞌu xavalbe ti lec xa lasate ―xꞌutat la echꞌel yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Li lajchavoꞌe ibatic la ta parajeletic ta stsꞌel jteclum Cesarea de Filipo xchiꞌuquic ti Jesuse. Ijacꞌbatic la ta be yuꞌun ti Jesuse: ―¿Cꞌusi van cabtel yalojic li jchiꞌiltactique? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","―Jlom chalic ti voꞌot Juan jꞌacꞌ-ichꞌvoꞌote. Jlom chalic ti voꞌot Elíasote. Jlom chalic ti voꞌot yajꞌalcꞌopot Riox ti ta más voꞌnee ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―Li voꞌoxuque ¿cꞌusi cabtel ti avalojique? ―xꞌutatic la. ―Voꞌot Cristoot ti yaloj Riox chapasoticotic ta mantale ―xut la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","―Mu to me muchꞌu xavalbeic ti cꞌusi cabtele ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lic la yal noxtoc ti Jesuse: ―Voꞌon ti coꞌol crixchanootique, jnaꞌoj ti ta onox xcacꞌ tajmec jvocole. Mu xiyichꞌic ta mucꞌ li jmeltsanejcꞌopetique xchiꞌuc li totil paleetique, xchiꞌuc li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Jaꞌ chiyaqꞌuic ta milel, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xꞌutatic la li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ti jamal iyal ti chmilee, yechꞌo un li Pedroe ilocꞌlocꞌ la echꞌel xchiꞌuc ti Jesuse. ―Cajval, maꞌuc yech smelol ti chavichꞌ milele ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ti Jesuse ijoyij la, iqꞌuele la scotolic. Iꞌalbat la li Pedroe: ―¿Cꞌu yuꞌun chachꞌunbe smantal ti Satanase? Mu me xapajeson. Li voꞌote maꞌuc chanop ti cꞌusi tscꞌan ti Rioxe. Jaꞌ yech chanop chac cꞌu chaꞌal tsnop li yan crixchanoetique ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cꞌalal laj yal chac taje ―Nopojanic tal ―xut la ti epal crixchanoetique xchiꞌuc la li lajchavoꞌe―. Ti muchꞌutic chiyichꞌic ta muqꞌue, mu me cꞌuxuc ta yoꞌon spat xoconic. Acꞌu cuchuc yuꞌunic ilbajinel chac cꞌu chaꞌal ta xcuch cuꞌun li voꞌone, acꞌu mi jaꞌ xlajic o. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ti muchꞌutic mu xiyichꞌic ta muqꞌue, ti jaꞌ chiꞌic o li milele, yuꞌun onox ta xꞌochic ta cꞌocꞌ ta sbatel osil. Yan ti muchꞌutic muc ta alel yuꞌunic mi jaꞌ xlajic oe, ti chalic aꞌyuc li cꞌusi chcale, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mi jaꞌ noꞌox ta avoꞌonic li cꞌusitic oy ta sba balamile, mu cꞌusi bal o yuꞌun chaꞌochic onox ta cꞌocꞌ ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Acꞌu mi jcꞌulejoxuc tajmec liꞌ ta sba balumile, pero mu xuꞌ chaman abaic loqꞌuel li ta cꞌoqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi chaqꞌuexavic ta yalel aꞌyuc ti avichꞌojicon ta muqꞌue, mi chaqꞌuexavic ta yalbel cꞌusi caloj li jchiꞌiltactic lavie, ti mu xichꞌic ta mucꞌ ti Rioxe, ti chopol cꞌusitic tspasique, jaꞌ noꞌox yechon uc, voꞌon ti coꞌol crixchanootique, “leꞌe maꞌuc jchꞌamal”, chichi ti cꞌalal xital xchiꞌuc syuꞌel ti Jtote xchiꞌuc ti anjeletic ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","’Ta melel chacalbeic, lavi jayvoꞌ liꞌoxuque oy mu toꞌox chachamic ti cꞌalal xlic pasvanuc ta mantal ti Rioxe. Chavilic ti chlecubtasbat yoꞌonic ta syuꞌel ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ti cꞌalal ilaj vaquib cꞌacꞌal ti yech iyal ti Jesuse, jaꞌo la iꞌiqꞌueic muyel ta jpꞌej mucꞌta vits li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juane. Li oxvoꞌe iyilic la ti iyacꞌ xojobal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ti scꞌuꞌe xlebebet xa la tajmec saquil. Mu la muchꞌu yech xꞌucꞌumaj ta sjunlej balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jaꞌo la iyilic ti Eliase xchiꞌuc ti Moisese, tey la chloꞌilajic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","―Jchanubtasvanej, lec ti liꞌotic oe. Ta jmeltsanticotic oxpꞌejuc sucbil yanal teꞌ; jpꞌej avuꞌun, jpꞌej yuꞌun Moisés, jpꞌej yuꞌun Elías ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mu la snaꞌ ti cꞌusi iyale yuꞌun la ixiꞌic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ital la lumal toc, ibutꞌij la scotolic. Iyaꞌiic la icꞌopoj ta yut lumal toc ti Rioxe. ―Liꞌi jaꞌ Jchꞌamal. Jcꞌanoj tajmec. Xachꞌunbeic me li cꞌusitic chayalbeique ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta jliquel o isqꞌuelic la ta jujot, pero stuc xa la tey vaꞌal iyilic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ti cꞌalal iyalic tale ―Mu to me muchꞌu xavalbeic yaꞌi ti cꞌusi avilique. Jaꞌto me xavalic aꞌyuc ti cꞌalal xichaꞌcuxi loqꞌuel ta jmuquenal voꞌon ti coꞌol crixchanootique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yechꞌo un mu to la muchꞌu iyalbeic, yoꞌon noꞌox la snaꞌic. ―¿Cꞌusi van smelol ti ta xchaꞌcuxi loqꞌuel ta smuquenale? ―xut la sba stuquic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","―¿Cꞌu yuꞌun chalic li jchanubtasvanejetic ta smantal Rioxe ti baꞌyi chtal ti Eliase, ti tsꞌacal to chatale? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","―Ta melel jaꞌ yech tsꞌibabil ta scꞌop Riox ti jaꞌ baꞌyi ta xtal ti Eliase. Jaꞌ chtal yalbe li jchiꞌiltactique ti acꞌu yictaic spasel li cꞌusitic chopole. Voꞌon ti coꞌol crixchanootique, tsꞌibabil onox jcꞌoplal uc ti chcacꞌ tajmec jvocole yuꞌun mu cꞌu jtu chiꞌile. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Chacalbeic, ti Eliase iꞌay xa, jaꞌ ti Juan jꞌacꞌ-ichꞌvoꞌe. Li crixchanoetique ispasbeic ti cꞌusi tscꞌan yoꞌonique, ismilic. Yuꞌun jaꞌ onox yech tsꞌibabil scꞌoplal ti Juane ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ti cꞌalal iyulic yoꞌ bu comemic li yane, tey la joyol yul staic ep crixchanoetic. Jaꞌ la ta oꞌlol li yane. Oy la cꞌusi chjacꞌulanbatic yuꞌun ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ti crixchanoetique ti cꞌalal iyilic ti Jesuse, xchꞌayet xa la yoꞌonic, ba la scꞌoponic ta anil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","―¿Cꞌusi chavalbe abaic xchiꞌuc li cajchancꞌoptaque? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Itacꞌav la jun ti muchꞌutic tey tsobolique: ―Jchanubtasvanej, yuꞌun liꞌ quicꞌojbot tal li jcreme. Ochem pucuj ta yoꞌon, pasem o ta umaꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Buyuc noꞌox chlic ilbajinatuc yuꞌun ti pucuje. Ta xjipe ta lum, ta spotspotsvocan ye, ta scꞌux sba ye, ta steꞌ sba yoc scꞌob. Icalbe lavajchancꞌoptaque ti acꞌu sloqꞌuesic ti pucuje, pero muc xlocꞌ yuꞌunic ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","―Mu onox xachꞌunic tajmec. ¿Cꞌu to onox ora chachꞌunic yaꞌel ti voꞌne xa liꞌ jchiꞌucoxuque, ti jal xa lajtsꞌicbeique? Icꞌbecon tal li creme ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iyiqꞌuic la tal. Ti pucuj ochem ta yoꞌone, ti cꞌalal iꞌile ti Jesuse, jaꞌo la iyilbajin ti creme, ilic la stupꞌ-icꞌ, iyal la ta lum. Tey xa la xbalet, spotspotsvocan xa la ye. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ti Jesuse isjacꞌbe la ti stot ti creme: ―¿Cꞌu xa ora sliquel ti xꞌelan tspase? ―xi la. ―Voꞌne xa. Biqꞌuit toꞌox. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ep ta echꞌel icꞌot ta cꞌocꞌ, ep ta echꞌel ipꞌaj ta voꞌ yuꞌun tscꞌan chmile yuꞌun ti pucuje. Mi voꞌot xa xlocꞌ avuꞌune, abulajan cꞌuxubinbon, loqꞌuesbon ―xi la ti stot ti creme. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","―Mi chachꞌune, ta xlocꞌ. Ti muchꞌutic ta xchꞌunic ti oy jyuꞌele, ta staic li cꞌusi tscꞌanique ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ora la itacꞌav ti stot ti creme: ―Ta jchꞌun. Coltaon ta xchꞌunel mi oy to cꞌusi mu jchꞌun chavile ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ti Jesuse, ti cꞌalal iyil ti istsob sbaic tal ta anil ti epal crixchanoetique, ora la isloqꞌues ti pucuje. ―Pucuj, voꞌot ta amul ti umaꞌ li creme, ti pacꞌchiquin noxtoque. Voꞌon chajtac loqꞌuel. Locꞌan ta yoꞌon li creme. Mu xa me xachaꞌoch ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Cꞌalal ilocꞌ ti pucuje, iꞌavan la. Ti creme itꞌelelinat la comel, chamem la yilel icom. Ep la muchꞌutic iyalic ti icham xa oe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ti Jesuse istsacbe la scꞌob ti creme, isnit la liquel. Ora la ilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ti cꞌalal iꞌoch yoꞌ bu xchꞌamunoj na ti Jesuse, cꞌalal stuquic xaꞌox xchiꞌuc li lajchavoꞌe ―¿Cꞌu yuꞌun ti muc xlocꞌ cuꞌunticotic ti pucuje? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","―Li jtos pucujetic ti ijloqꞌuese, jaꞌto ta xlocꞌ mi chacꞌoponic Rioxe, mi chavicta avotique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Li lajchavoꞌe iloqꞌuic la ta Capernaum xchiꞌuquic ti Jesuse, iꞌechꞌic la ta yan jteclumetic ta estado Galilea. Ti Jesuse mu la scꞌan xvinaj ti bu ch-echꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yuꞌun la jaꞌ noꞌox ta xchanubtasatic li lajchavoꞌe. ―Voꞌon ti coꞌol crixchanootique chiꞌaqꞌue entrucal ta stojol crixchanoetic. Chismilic, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Li lajchavoꞌe muc la xaꞌibeic smelol ti xꞌelan iꞌalbatique. Ixiꞌic la ta sjacꞌbel cꞌusi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Li lajchavoꞌe isutic la noxtoc ta Capernaum xchiꞌuquic ti Jesuse. Ti cꞌalal teyic xaꞌox yoꞌ bu xchꞌamunoj na ti Jesuse ―¿Cꞌusi avalbe abaic tal ta bee? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Muc la xtacꞌavic. Yuꞌun la jaꞌ chalbe sbaic tal ti muchꞌu junucal ta xcom yuꞌunic ta yajpasmantalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ichoti la ti Jesuse. ―Nopojanic tal. Chacalbe avaꞌiic, ti muchꞌu junucal ta xcom avuꞌunic ta avajpasmantalique, mi tscꞌan ti ichꞌbil ta muqꞌue, jaꞌ tscꞌan ti mu jtoybailuque, ti sjunul yoꞌon chtun avuꞌunique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","―Laꞌ ―xut la jun cꞌox crem ti Jesuse. Isvaꞌan la ta oꞌlol yoꞌ bu tsobolique, tsꞌacal to ispet la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Mi chachanubtasic ta jcꞌop li muchꞌu jaꞌ yech yoꞌon chac cꞌu chaꞌal yoꞌon li cꞌox liꞌi, chvinaj ti voꞌon chavichꞌicon ta muqꞌue. Jaꞌ noꞌox yech chavichꞌic ta mucꞌ yaꞌel ti Jtot uque yuꞌun jaꞌ listac tal ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","―Jchanubtasvanej, oy muchꞌu iquilticotic ti tsloqꞌuesbe pucujetic ta yoꞌon li crixchanoetique. Ta sloqꞌues abi ti cꞌalal ta sloqꞌues ti pucuje. Pero ijpajesticotic yuꞌun muc bu jchiꞌintic o ―xut la Jesús li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","―Mu me xapajesic. Ti muchꞌu tsloqꞌues pucuj ta jyuꞌele, yuꞌun mu chopluc cꞌusi chiyalbe ta tsꞌacal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Acꞌu mi muc bu jchiꞌintic, mi mu xiscrontainotique, yuꞌun lec chiyilotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ti muchꞌutic jaꞌ noꞌox chayacꞌbeic jbochuc voꞌe yuꞌun ti chilic ti chatunic cuꞌune, voꞌon li Cristoone, ta melel chacalbeic ti chichꞌ smotonic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ti mi chachanubtasic ta spasel cꞌusi chopol junuc ti muchꞌutic jaꞌ yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique ti yichꞌojicon ta muqꞌue, más lec ti lachucbaticuc jcotuc choꞌ ta anuqꞌuique, ti latenaticuc ta mare, ti lachamicuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ti mi jaꞌ chata o amulic lacꞌobique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o ta vinajele. Mi acꞌobic noꞌox chaꞌochic o ta cꞌocꞌ ti yoꞌ bu mu snaꞌ xtupꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ti muchꞌutic tey chbatique mu xꞌechꞌ li svocolique yuꞌun mu snaꞌ xtupꞌ ta jmoj li cꞌoqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jaꞌ noꞌox yech mi jaꞌ chata o amulic lavoquique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o ta vinajele. Mi avoquic noꞌox chaꞌochic o ta cꞌocꞌ ti yoꞌ bu mu snaꞌ xtupꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ti muchꞌutic tey chbatique mu xꞌechꞌ li svocolique yuꞌun mu snaꞌ xtupꞌ ta jmoj li cꞌoqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jaꞌ noꞌox yech mi jaꞌ chata o amulic lasatique, chopol. Tscꞌan chapajesic yoꞌ xaꞌochic o yoꞌ bu tspas mantal ti Rioxe. Mi asatic noꞌox chaꞌochic o ta cꞌocꞌ ta sbatel osile, abol abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ti muchꞌutic tey chbatique mu xꞌechꞌ li svocolique yuꞌun mu snaꞌ xtupꞌ ta jmoj li cꞌoqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ti muchꞌutic ta xtunic yuꞌun ti Rioxe jaꞌto onox chlecubic o li vocole. Lec ch-ileic yuꞌun ti Rioxe chac cꞌu chaꞌal lec iyil smoton ti cꞌalal iyichꞌ yatsꞌmele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Li atsꞌame mu xuꞌ ti chꞌabale. Jaꞌto chmuib o li veꞌlile ti cꞌalal oye. Ti snaꞌuc soc li atsꞌame, mu xuꞌ xchaꞌlecub. Jaꞌ noꞌox yech jaꞌ tscꞌan ti lec avoꞌonique yoꞌ lec xavil o abaique ―xꞌutatic la li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ti Jesuse ilocꞌ la tal ta Capernaum, ital la liꞌ ta estado Judeae xchiꞌuc ta jech ucꞌum Jordán. Ep la tajmec jchiꞌilticotic istsob sbaic noxtoc yoꞌ bu ti Jesuse. Ti Jesuse lic la chanubtasvanuc chac cꞌu chaꞌal ta spas onoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tey la icꞌotic jayvoꞌ jfariseoetic. Oy la cꞌusi isjacꞌbeic yoꞌ la stabeic o smul ti yalojique. Isjacꞌbeic la mi xuꞌ xchꞌac yajnil li viniquetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","―¿Cꞌu xꞌelan yaloj comel ti Moisese? ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","―Ti Moisese iyal ti xuꞌ xchꞌac sbaique, jaꞌ noꞌox ti persa tsmeltsanbe svunale. Li vune jaꞌ chichꞌ li antse yoꞌ xil o ti chꞌacbil xae ―xi la ti jfariseoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","―Ti xꞌelan istsꞌiba comel ti Moisese, jaꞌ ti mu xachꞌunic tajmeque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ti cꞌalal ismeltsan balamil ti Rioxe, xchiꞌuc scotol li cꞌusitic oye, jun vinic jun ants ispas. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jaꞌ yech tsꞌibabil ta scꞌop Riox: “Li cremotique ta xchꞌac sbaic xchiꞌuc stot smeꞌic ti cꞌalal sta yajnilique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Xchaꞌvaꞌalic jun xa chcꞌotic”, xi ti Rioxe. Yechꞌo un mu xa chaꞌvoꞌuc, junic xa. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ti muchꞌutic nupul tsꞌacalique jun xa ch-ileic yuꞌun ti Rioxe, mu xa xuꞌ xchꞌac sbaic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsꞌacal to cꞌalal teyic xaꞌox yoꞌ bu xchꞌamunoj na ti Jesuse, li lajchavoꞌe isjaqꞌuic la cꞌusi smelol ti cꞌusi iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","―Ti muchꞌu ta xchꞌac yajnile, mi chicꞌ yan antse, coꞌol xchiꞌuc yants chcꞌot. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jaꞌ noꞌox yech li antse, mi ta xchꞌac smalale, mi chicꞌ yan vinique, coꞌol xchiꞌuc yajmul chcꞌot ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tey la yicꞌojbeic cꞌotel cꞌoxetic ti Jesuse yuꞌun la acꞌu yacꞌ scꞌob ta sjolic. Cꞌalal iyilic li lajchavoꞌe, ispajesic la ti muchꞌutic chicꞌ tal li cꞌoxetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cꞌalal iyil ti Jesuse, chopol la iyaꞌi. ―Mu xavutic. Acꞌu talicuc li cꞌoxetique. Yuꞌun ti muchꞌutic jaꞌ yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique, ta xchꞌunic cꞌusi chal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta melel chacalbeic, ti muchꞌutic maꞌuc yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique, mu xꞌochic yoꞌ bu tspas mantal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ti Jesuse ispet la ti cꞌoxetique, iyacꞌ la scꞌob ta sjolic, iyacꞌbe la bentisyon. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ti cꞌalal chlocꞌ xaꞌox echꞌel ti Jesuse, jaꞌo la anil cꞌotel jun jchiꞌilticotic. Isquejan la sba ta yichon ti Jesuse. ―Jchanubtasvanej, voꞌot ti lec avoꞌone, ¿cꞌusi tscꞌan ta jpas yoꞌ xicuxi o ta sbatel osile? ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Itacꞌav la ti Jesuse: ―¿Cꞌu yuꞌun ti “lec avoꞌon”, xavutone? Jun noꞌox ti muchꞌu lec yoꞌone, jaꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Anaꞌoj cꞌusi chal li mantaletique: “Mu me xasaꞌ avants, mu me xamilvan, mu me xaꞌelcꞌaj, mu me xanopbe smul achiꞌil, mu me xaloꞌlovan, ichꞌo ta mucꞌ atot ameꞌ”, xi tsꞌibabil ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","―Jchanubtasvanej, li cꞌusitic avale, cꞌoxon toꞌox lic jchꞌun ―xi la ti jcꞌuleje. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ti Jesuse isqꞌuelbe la sat, cꞌux la ta yoꞌon iyil. ―Oy to cꞌusi tscꞌan chapas. Ba chono li cꞌusuc avuꞌune. Li stojole qꞌuelanbo li meꞌonetique yoꞌ oy o acꞌulejal ta vinajele. Tsꞌacal to xtal achiꞌinon acꞌu mi xaꞌilbajinat uc ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cꞌalal iyaꞌi chac taje, iyat la yoꞌon tajmec yuꞌun la toj ep cꞌusuc yuꞌun. Isut la echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Li lajchavoꞌe icholatic la ta qꞌuelel yuꞌun ti Jesuse. ―Li jcꞌulejetique tsots ta chꞌunel chaꞌiic cꞌusi chal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Xchꞌayet xa la yoꞌonic ti xꞌelan iꞌalbatique. ―Jchꞌamaltac, li muchꞌutic spatoj o yoꞌonic li scꞌulejalique, tsots ta chꞌunel chaꞌiic cꞌusi chal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Coꞌol xchiꞌuc jcot cameyo ti mu xjelav ta chac acuxae, jaꞌ yech mu xꞌochic yoꞌ bu tspas mantal Riox ti muchꞌutic jaꞌ noꞌox ta yoꞌonic li scꞌulejalique ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ti cꞌalal iyaꞌiic li lajchavoꞌe, más to la xchꞌayet o yoꞌonic. ―¿Muchꞌu xa onox ta xcuxi ta sbatel osil ti mi mu xcuxiic li jcꞌulejetique? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iqꞌuelbat la satic yuꞌun ti Jesuse. ―Mu xuꞌ chacuxiic ta sbatel osil ta atuquic. Jaꞌ noꞌox chacuxiic mi chascoltaic ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","―Li voꞌoticotique jcomtsanojticotic xa li cꞌusuc cuꞌunticotique. Jnapꞌletaojoticotic xa ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","―Ta melel chacalbeic, scotol ti muchꞌutic muc ta alel yuꞌunic mi iscomtsan o snaique, mi sbanquiltac, mi yitsꞌintac, mi svixtac, mi yixleltac, mi smuctac, mi stot, mi smeꞌ, mi yajnil, mi xchꞌamaltac, mi yoltac, mi yosil, yuꞌun ti yichꞌojicon ta muqꞌue, ti chalic aꞌyuc ti tspasvan xa ta mantal ti Rioxe, voꞌon chcacꞌbeic cien ta echꞌel sqꞌuexol ti cꞌusitic chcom yuꞌunique. Mi sna, mi sbanquiltac, mi yitsꞌintac, mi svixtac, mi smuctac, mi yixleltac, mi smeꞌ, mi xchꞌamaltac, mi yoltac, mi yosil, ta jqꞌuextabeic scotol. Ta xꞌilbajinatic noxtoc. Tsꞌacal to ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ep ti muchꞌutic totil yalojic lavie, pero mu cꞌu stu chcꞌotic yoꞌ bu tspas mantal ti Rioxe yuꞌun ta stoy sbaic. Ep ti muchꞌutic muc bu ichꞌbilic ta mucꞌ lavie, pero más tsots yabtel chcꞌotic yoꞌ bu tspas mantal ti Rioxe yuꞌun mu snaꞌ stoy sbaic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ti cꞌalal italic liꞌ ta Jerusalén xchiꞌuquic ti Jesuse, jaꞌ la babe tal ti Jesuse. Xchꞌayet o la yoꞌonic ti babe tale. Li stuquique xiꞌemic la tal. Itsobatic la ta tiꞌilbe slajchavaꞌalic yuꞌun ti Jesuse, iꞌalbatic la ti cꞌusi ta xchaꞌleat ti cꞌalal xulic liꞌ ta Jerusalene: ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Anaꞌojic ti chibatic ta Jerusalene. Voꞌon ti coꞌol crixchanootique, tey chiꞌaqꞌue entrucal ta stojol li totil paleetique xchiꞌuc li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Tey tsnopic ti chiyaqꞌuic ta milele. Chiꞌaqꞌue entrucal ta stojol li muchꞌutic nom liquemic tale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chislabanic, chiyacꞌbeic arsial, chistubtaic. Chismilic, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Li scremotic Zebedeoe, jaꞌ ti Jacoboe xchiꞌuc li Juane, inopojic la yoꞌ bu ti Jesuse. ―Jchanubtasvanej, ta jcꞌan ti chaꞌabulaj chavacꞌboticotic li cꞌusi ta jcꞌanticotique ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","―¿Cꞌusi chacꞌanic un? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","―Ti cꞌalal chaꞌoch ta pasmantale, jaꞌ ta jcꞌanticotic ti chichotioticotic jun ta abatsꞌicꞌobe, jun ta asurtoe ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","―Mu xanaꞌic cꞌu xꞌelan svocolal li cꞌusi chacꞌanbecone. ¿Mi xuꞌ chavacꞌ avocolic, mi xuꞌ chavichꞌic milel chac cꞌu chaꞌal chquichꞌ milel li voꞌone? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Xuꞌ ―xiic la. ―Ta melel ta onox xavacꞌ avocolic chac cꞌu chaꞌal chcacꞌ jvocol li voꞌone. Chavichꞌic milel noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero mi chacꞌan chachotiic junuc ta jbatsꞌicꞌobe, junuc ta jsurtoe, mu voꞌonicon chcal ti xuꞌe. Jaꞌ chal ti Jtote ti muchꞌutic tey ta xchotiique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ti cꞌalal iyaꞌiic li lajunvoꞌe, lic la scapanic o ti Jacoboe xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Itsobatic la slajchavaꞌalic yuꞌun ti Jesuse. ―Anaꞌojic cꞌu xꞌelan tspasic li preserenteetic ta yantic nacione. Ilbaj xꞌilvanic, mantal noꞌox tspasic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Li voꞌoxuque maꞌuc me yech xapasic. Ti muchꞌu junucal ta xcom avuꞌunic ta avajpasmantalique, mi tscꞌan ti ichꞌbil ta muqꞌue, jaꞌ tscꞌan ti mu jtoybailuque, ti sjunul yoꞌon chtun avuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jaꞌ chanic chac cꞌu chaꞌal li voꞌone. Voꞌon ti coꞌol crixchanootique, muc bu tal pasvancon ta mantal. Ti litale, yuꞌun tal tunicon yuꞌun scotol crixchanoetic. Tal cacꞌ jba ta milel ta scoj amulic yoꞌ xuꞌ xacuxiic o ta sbatel osile ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Li lajchavoꞌe tey la iyulic ta jteclum Jericó xchiꞌuquic ti Jesuse. Cꞌalal iloqꞌuic tal teyoꞌe, ep la jchiꞌilticotic tijajtic tal. Tey la chotol tscꞌan limoxna ta tiꞌil be istaic jun maꞌsat, Bartimeo la sbi. Timeo la sbi ti stote. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cꞌalal iyaꞌi ti tey ch-echꞌ ti Jesus Nazarete, iyapta la. ―¡Jesús, smom David, cꞌuxubinon! ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ti epal crixchanoetique ispajesic la. ―¡Anchan! ―xutic la tajmec ti maꞌsate. Pero más to la tsots iꞌavan: ―¡Smom David, cꞌuxubinon! ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Vaꞌ xi la ti Jesuse. ―Albeic acꞌu taluc ―xut la ti crixchanoetique. ―Mu xavat avoꞌon. Batan la xal li Jesuse ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ora la isjip comel ti spimilcꞌuꞌe, ivaꞌi la ta anil, ba la sta ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","―¿Cꞌusi chajchaꞌle un? ―xꞌutat la yuꞌun ti Jesuse. ―Jchanubtasvanej, abulajan jambon li jsate ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","―Yuꞌun achꞌun ti oy jyuꞌele, chjam lasate. Xuꞌ xa xabat ―xꞌutat la yuꞌun ti Jesuse. Ora la ijam ti sate, napꞌal la ital uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Li lajchavoꞌe ti cꞌalal poꞌot xaꞌox la xulic liꞌ ta Jerusalén xchiꞌuquic ti Jesuse, tey la iyulic ta Betfajé xchiꞌuc ta Betania ta yoc vits Olivotic. Itaqueic la echꞌel chaꞌvoꞌ yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Batanic leꞌ ta parajele. Ta ochel noꞌox tey chucul chataic jcot chex burro, mu to muchꞌu scajlebinoj. Jitunic, nitic tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi oy muchꞌu chasjacꞌbeic cꞌu yuꞌun ti chajitunic li burroe, xavalbeic ti voꞌon chtun cuꞌune. “Ta xtal noꞌox jsutesticotic ta ora”, xavutic ―xꞌutatic la echꞌel yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ibatic la. Tey la chucul istaic ta tiꞌil be ta tsꞌel tiꞌna jcot chex burro. Isjitunic la tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tey la vaꞌajtic jayvoꞌ crixchanoetic. ―¿Cꞌu yuꞌun chajitunic li burroe? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jaꞌ la yech iyalbeic chac cꞌu chaꞌal iꞌalbatic yuꞌun ti Jesuse, iꞌacꞌbatic la tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Isnitic la tal ti burroe. Iyacꞌbeic la stasin spimilcꞌuꞌic, iscajlebin la tal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ep la muchꞌutic isqꞌui spimilcꞌuꞌic ta be yoꞌ bu iꞌechꞌ tal ti Jesuse. Jlom la iscꞌasic yanal teꞌ, iyaqꞌuic la ta be yuꞌun la iyichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ti muchꞌutic babee xchiꞌuc ti muchꞌutic tijajtique, iꞌavan la scotolic: ―¡Coliyalbotic Riox, lec tajmec li preserente listacbotic tal ti Jtotic Riox ta vinajele! ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Acꞌu quichꞌtic ta mucꞌ yuꞌun tal spasotic ta mantal chac cꞌu chaꞌal ispas mantal ti jmucꞌtatotic David ti ta voꞌnee! “¡Colaval, Cajval”, chiicuc uc ti anjeletic ta vinajele! ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jaꞌ la yech iꞌoch tal liꞌ ta Jerusalén ti Jesuse. Tucꞌ la ibat cꞌalal tiꞌ mucꞌta templo. Isqꞌuel la sjunlej tiꞌ templo. Cꞌalal laj sqꞌuele, ilocꞌ la echꞌel, ibat la ta Betania. Xchiꞌuquic la echꞌel li lajchavoꞌe yuꞌun la ch-icꞌub xaꞌox. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta yocꞌomal iloqꞌuic la tal ta Betania xchiꞌuquic ti Jesuse, isutic la tal liꞌ ta Jerusalene. Ti Jesuse iviꞌnaj la ta be. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iyil la ta nom jtecꞌ icꞌux, oy la yanal. Ba la sqꞌuel mi oy sat. Pero chꞌabal la, naca noꞌox la yanal, yuꞌun la maꞌuc toꞌox yora tsatin. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ti Jesuse iyal la ti mu xa bu tsatin oe. Iyaꞌiic la li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ti cꞌalal iyulic liꞌ ta Jerusalene, ibatic la ta tiꞌ mucꞌta templo. Ti Jesuse isnuts la loqꞌuel scotol ti jchonolajeletic tey ta tiꞌ temploe. Isbutqꞌuinbe la smexaic ti jeltaqꞌuinetique. Isbutqꞌuinbe la xilaic ti jchonpalomaetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ti muchꞌutic oy yicatse mu la xacꞌ echꞌuc ta tiꞌ templo. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lic la chanubtasvanuc. ―¿Mi mu anaꞌojicuc ti yech onox tsꞌibabil ta scꞌop Riox: “Li jnae jaꞌ scuenta chtal staicon o ta cꞌoponel ti jaylajuntos crixchanoetic ta sjoylej balamile”, xi ti Rioxe? Li voꞌoxuque snailchꞌen jꞌeleqꞌuetic xachaꞌleic ―xꞌutatic la ti jchonolajeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iyaꞌiic la ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti totil paleetique. Chopol la iyaꞌiic, lic la scomonnopic cꞌuxi ta staic ta milel ti Jesuse pero xiꞌemic la. Yuꞌun la ep jchiꞌilticotic lec iyaꞌiic ti cꞌu xꞌelan ichanubtasvane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ti cꞌalal iꞌoch orisyone, ilocꞌ la echꞌel ta Jerusalén ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sob ta yocꞌomal tey la iꞌechꞌic tal noxtoc yoꞌ bu ti icꞌuxe. Iyilic la ti taquin xa xchiꞌuc yisime. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Li Pedroe iyul la ta sjol ti cꞌusi iyal ti Jesuse. ―Jchanubtasvanej, qꞌuelavil li icꞌuxe ti aval ti mu xa bu tsatin oe, taquin xa ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Itacꞌav la ti Jesuse: ―Chꞌunic ti oy syuꞌel ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta melel chacalbeic, mi chachꞌunic ti chascoltaique, mi mu xchibetuc avoꞌonique, mi jꞌechꞌel achꞌunojic ti chascoltaique, ti cꞌusi chavalique, ta onox xcꞌot. Jaꞌ chac cꞌu chaꞌal mi chavalbeic ti acꞌu locꞌuc li vits liꞌi, ti acꞌu tꞌubuc ta mare, tspas avuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yechꞌo un chacalbeic, scotol ti cꞌusitic chacꞌanbeic ti Rioxe, mi jꞌechꞌel achꞌunojic ti chayacꞌbeique, ta onox xavichꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ti cꞌalal chacꞌoponic Rioxe, mi jaꞌo iyul ta ajolic ti oy smul avuꞌun lachiꞌilique, acꞌo ta pertonal. Jaꞌ noꞌox yech chayaqꞌuic ta pertonal uc ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yan mi mu xavaqꞌuic ta pertonal lachiꞌilique, jaꞌ noꞌox yech mu xayaqꞌuic ta pertonal uc ti Jtotic Riox ta vinajele ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iyulic la noxtoc liꞌ ta Jerusalene. Cꞌalal tey xvaꞌet ta tiꞌ mucꞌta templo ti Jesuse, tey la tal cꞌoponatuc yuꞌun totil paleetic xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc la jayvoꞌ jmeltsanejcꞌopetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","―¿Muchꞌu layalbe ti xꞌelan chapase? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","―Oy cꞌusi chajacꞌbeic uc. Mi chavalbecon ti cꞌusi chajacꞌbeique, chacalbeic ti muchꞌu liyalbe ti xꞌelan ta jpase. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Muchꞌu ta smantal ti iyacꞌ ichꞌvoꞌ ti Juane? ¿Mi Riox, o mi crixchano? Albecon caꞌi ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xalxalbe xa la sbaic: ―Mi chcaltic ti ta smantal Rioxe, “¿cꞌu yuꞌun ti muc xachꞌunique cheꞌe?” xi biꞌa. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mi chcaltic ti ta smantal crixchanoe, xiꞌel sba ―xut la sbaic. Ti xꞌelan iyalic ti xiꞌel sbae, jaꞌ la ti scotol jchiꞌilticotic xchꞌunojic ti jaꞌ yajꞌalcꞌop Riox ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yechꞌo un ―Mu jnaꞌticotic ―xiic la. ―Jaꞌ yechon uc, mu xacalbeic ti muchꞌu liyalbe ti xꞌelan ta jpase ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ti Jesuse lic la yalbe jun loꞌil li jchiꞌiltac ta israelale. ―Caltic noꞌox yaꞌel ti oy jun vinic istsꞌun ep uva ta yosile. Isjoy ta moc. Ixchꞌoj ton scuenta spitsꞌobil yaꞌlel. Ismeltsan jpꞌej toyol na scuenta sqꞌuelobil li uvae. Isaꞌ comel ti muchꞌutic ta xchabi li uvae. Ibat ta nom li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Ti cꞌalal itaꞌaje, istac tal jun yajꞌabtel ti tscuch echꞌel ti cꞌu yepal yaloj chichꞌe. Yul scꞌanbe li muchꞌutic ta xchabiique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Li jchabiejꞌuvae istsaquic li yajꞌabtel yajval osile, ismajic, isnutsic sutel. Mu cꞌusi iyacꞌbeic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Li yajval osile istac tal otro jun yajꞌabtel. Ti cꞌalal iyule, iyacꞌbeic ton, iyayij sjol yuꞌunic. Ilbaj xchaꞌleic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Istac tal otro jun. Ti cꞌalal iyule, solel ismilic ta jmoj. Oy to yan yajꞌabtel istac tal. Jlom ismajic, jlom ismilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Oy jun screm li yajval osile, scꞌanoj tajmec. Jaꞌ slajeb xa istac tal. “Jaꞌ nan chichꞌic ta mucꞌ li jcreme”, xi isnop. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero li jchabiejꞌuvae, ti cꞌalal iyilic ti jaꞌ xa screm li yajval osile, “leꞌe jaꞌ xa chichꞌbe comel yosil li stote. Más lec jmiltic yoꞌ xquichꞌbetic o comel voꞌotic li yosile”, xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Istsaquic, ismilic, isjipic loqꞌuel ta pat moc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Jaꞌ noꞌox yech li yajval uvae chtal smil li jchabiejꞌuvae. Yan xa o muchꞌutic ta xacꞌbe xchabi li uvae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Mi muc bu aqꞌuelojic yaꞌel ta scꞌop Riox yoꞌ bu chal ti “coꞌol xchiꞌuc jpꞌej ton ti istꞌuj li yajval nae ti chacꞌ ta xchiquin snae ti ipꞌaje yuꞌun li yajꞌalvaniltaque, pero jaꞌ onox iꞌoch ta chiquin na. Jaꞌ noꞌox yech uc ti muchꞌu stꞌujoj ti Rioxe, acꞌu mi xpꞌaje, pero chichꞌ onox tsots yabtel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lec tajmec ti xꞌelan tspas ti Rioxe”, xi tsꞌibabil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ti totil paleetique, xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc ti jmeltsanejcꞌopetique, taꞌox la stsaquic ti Jesuse yuꞌun la iyaꞌiic ti jaꞌ scꞌoplalic ti loꞌil iyale. Pero ixiꞌic la ta stsaquel, jaꞌ la ti ep tajmec ti crixchanoetic tey tsobolique. Tey la vaꞌal iscomtsanic, ibatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsꞌacal to istaquic la tal jayvoꞌ jfariseoetic xchiꞌuc jayvoꞌ svinic Erodes. Oy la cꞌusi tal sjacꞌbeic ti Jesuse yoꞌ la stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","―Jchanubtasvanej, jnaꞌojticotic ti yech scotol li cꞌusi chavale. Jamal chaval cꞌusi tscꞌan Riox ti ta jpasticotique. Mu tꞌujbiluc chachaꞌle ti muchꞌu chavalbee. Alo caꞌiticotic cꞌusi chanop. ¿Mi lec chil xanaꞌ ti Rioxe ti chcacꞌbeticotic tojel aqꞌuel ti preserente Césare, o mi chopol chil? ¿Mi chcacꞌbeticotic, o mi iꞌi? ―xutic la yulel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ti Jesuse iyil la ti oy smanyaique. ―¿Cꞌu yuꞌun ti xꞌelan tal avalbecone? Acꞌbecon quil jsepuc taqꞌuin ti chcacꞌtic ta tojel aqꞌuele ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iyacꞌbeic la yil. ―¿Muchꞌu slocꞌol liꞌi? ¿Muchꞌu sbi? ―xꞌutatic la yuꞌun ti Jesuse. ―César ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","―Jaꞌ tscꞌan chavacꞌbeic ti cꞌusi tscꞌan ti preserente Césare. Jaꞌ noꞌox yech tscꞌan chavacꞌbeic ti cꞌusi tscꞌan ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. Ti cꞌalal iyaꞌiic ti xꞌelan itacꞌav ti Jesuse, xchꞌayet xa la yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsꞌacal to tey la icꞌotic jayvoꞌ jsaduceoetic yoꞌ bu ti Jesuse, jaꞌ ti muchꞌutic chalic ti mu xa xichaꞌcuxiotic ti cꞌalal xichamotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Jchanubtasvanej, ti Moisese stsꞌibaoj comel ti mi icham junuc vinique, mi chꞌabal screm icome, li itsꞌinale mi chꞌabal to yajnile, acꞌu yicꞌbe yajnil ti ánima sbanquile. Mi iꞌayan screme, jaꞌ yech chacꞌbe sbi chac cꞌu chaꞌal sbi ti ánima sbanquile yoꞌ mu xchꞌay o sbie”, xi ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oy toꞌox vucvoꞌic, sbanquil yitsꞌin sbaic. Ti banquilale isaꞌ yajnil, pero icham, chꞌabal xchꞌamal icom. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ti itsꞌinale iyicꞌbe yajnil ti ánima sbanquile pero icham uc. Chꞌabal xchꞌamal icom uc. Jaꞌ noꞌox yech ispas ti yoxvaꞌal itsꞌinale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Svucvaꞌalic iyiqꞌuic ti antse pero muc xꞌayan xchꞌamalic junuc ti cꞌalal ichamique. Tsꞌacal to icham ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mi ichaꞌcuxiique, ¿muchꞌu onovan junucal ti chiqꞌue yuꞌun iyicꞌ svucvaꞌalic? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Itacꞌav la ti Jesuse: ―Li voꞌoxuque mu xanaꞌic li cꞌusi chavalique yuꞌun mu xanaꞌic cꞌusi chal li scꞌop Rioxe. Mi jaꞌuc xanaꞌic cꞌu xꞌelan syuꞌel ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ti cꞌalal xchaꞌcuxiic ti muchꞌutic chbatic ta vinajele, mi antsuc, mi vinicuc, mu xa bu chicꞌ sbaic. Yuꞌun mu xa snaꞌ xchamic. Coꞌolic xa xchiꞌuc anjeletic ta vinajel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lavi mu xachꞌunic ti ta xchaꞌcuxiic ti ánimaetique, ¿mi muc bu aqꞌuelojic yaꞌel li svun Moisese yoꞌ bu chal ti cꞌalal icꞌoponat yuꞌun Riox ta jtecꞌ cꞌox chꞌixe? “Voꞌon Yajvalicon ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove”, xꞌutat. Ti xꞌelan iꞌalbate, yuꞌun cuxajtic ch-ileic yuꞌun ti Rioxe acꞌu mi voꞌne xa xchamelic ti moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ti Rioxe jaꞌ Yajvalic ti muchꞌutic cuxajtic ta sbatel osile. Li voꞌoxuque chamem xchiꞌuc xchꞌulelic ti avalojique. Yechꞌo un mu xanaꞌic li cꞌusi chavalique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tey la jun jchanubtasvanej yilel ta smantaltac Riox. Iyaꞌi la ti tey chloꞌilaj xchiꞌuc Jesús ti jsaduceoetique. Ti cꞌalal iyaꞌi ti ta yav ta yav chtacꞌav ti Jesuse, inopoj la echꞌel uc. ―Ta scotol li smantaltac Rioxe ¿cꞌusi jtosucal ti más tsotse? ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Itacꞌav la ti Jesuse: ―Li smantal Rioxe ti más tsotse jaꞌ liꞌi: “Jchiꞌiltactic, aꞌyic me. Voꞌotic li jꞌisraelotique jun noꞌox cajvaltic ta jcotoltic, jaꞌ ti Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cꞌanic me ta sjunul avoꞌonic ti Rioxe. Jaꞌ acꞌu tunuc yuꞌun lapꞌijilique xchiꞌuc lavipique”, xi li mantale. Leꞌe jaꞌ más tsots. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Li xchibale tsots noxtoc. “Cꞌuxubino me achiꞌiltac chac cꞌu chaꞌal chacꞌuxubin aba atuque”, xi. Mu cꞌusi yan mantal ti más tsotse ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","―Yechaꞌa, Jchanubtasvanej. Melel ti jun noꞌox ti Rioxe, chꞌabal yan. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Melel jaꞌ tscꞌan ti ta jcꞌantic ta sjunul coꞌontic ti Cajvaltique, ti acꞌu tunuc yuꞌun li jpꞌijiltique xchiꞌuc li quiptique, ti tscꞌan ta jcꞌuxubintic jchiꞌiltic chac cꞌu chaꞌal ta jcꞌuxubin jba jtuctique. Jaꞌ más tsots scꞌoplal. Jaꞌ mu másuc tsots scꞌoplal scotol li smoton Riox ti chichꞌ milele, ti chichꞌ chiqꞌuele ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ti cꞌalal iyaꞌi ti Jesuse ti lec itacꞌave, ―Jutuc xa scꞌan xachꞌun pasel ta mantal yuꞌun ti Rioxe ―xut la. Mu xa la muchꞌu cꞌusi isjacꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ti cꞌalal ichanubtasvan ta tiꞌ mucꞌta templo ti Jesuse, jaꞌ la yech lic yal: ―¿Cꞌu yuꞌun chalic li muchꞌutic ta xchanubtasvanic ta smantal Rioxe ti smom noꞌox David ti Cristoe, ti muchꞌu stꞌujoj Riox tspasvan ta mantale? ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ti Davide ipꞌijubtasat yuꞌun li Chꞌul Espíritue, jaꞌ yech iyal chac liꞌi: Ti Cajvale iꞌalbat yuꞌun ti Rioxe: “Chachoti ta jbatsꞌicꞌob chapas mantal ti cꞌu sjalil xchꞌun o amantal cuꞌun scotol lacrontae”, xꞌutat, xi ti Davide. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ti Davide “Cajval” xut ti muchꞌu stꞌujoj Riox tspasvan ta mantale. ¿Cꞌu yuꞌun “Cajval”, xut mi jaꞌ smom noꞌoxe? ―xꞌutatic la yuꞌun ti Jesuse. Ti crixchanoetic tey lamalique sjunul la yoꞌon iyaꞌiic cꞌusi iyal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ti Jesuse jaꞌ la yech lic yal ti cꞌalal ichanubtasvane: ―Qꞌuelo me abaic, mu me xasloꞌloic li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Li stuquique lec chaꞌiic ti xtolet scꞌuꞌic cꞌalal yoquique. Jaꞌ tscꞌanic ti cꞌoponbilic ta chꞌivite. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jaꞌ tscꞌanic ti bail ta xchotiic ta bicꞌtal temploetique, ti bail ta xchotiic cꞌalal chveꞌic ta jujun qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta sloꞌlobeic cꞌusuc yuꞌun li meꞌanal antsetique. Yech noꞌox ti jal tscꞌoponic Rioxe, jaꞌ noꞌox yoꞌ mu xvinaj o ti chopol cꞌusi tspasique. Yechꞌo un más castico chichꞌic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ti Jesuse ichoti la ta tiꞌ mucꞌta templo ta stuqꞌuil xcaxail limoxna. Iyil la ti isticꞌ slimoxnaic ti jchiꞌilticotique. Ep la jcꞌulejetic isticꞌ la ep staqꞌuinic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tey la icꞌot jun meꞌanal ants, meꞌon la tajmec. Chaꞌsep no la ta cinco isticꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Li lajchavoꞌe itsobatic la yuꞌun ti Jesuse. ―Ta melel chacalbeic, li meꞌanal ants leꞌe más ep iyacꞌ chil ti Rioxe chac cꞌu chaꞌal iyacꞌ li yantique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yuꞌun naca xa sovra staqꞌuinic ti iyaqꞌuique. Yan li meꞌanal antse iyacꞌ scotol ti cꞌu yepal oy yuꞌune ti jaꞌ ox ta sman o ti cꞌusi chtun yuꞌune ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Li lajchavoꞌe ti cꞌalal chloqꞌuic xaꞌox la ta stiꞌil smacol mucꞌta templo xchiꞌuquic ti Jesuse, jaꞌ la yech lic yal jun: ―Jchanubtasvanej, qꞌuelavil slequiquil tajmec li ton acꞌbil ta temploe. Qꞌuelavil slequiquil li naetic ta sjoyobe ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","―Lequic avaꞌucaꞌa. Pero ta sta yora ti ta xlomesate. Busul chcom scotol ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Li lajchavoꞌe tey la ba chotlicuc ta vits Olivotic ta stuqꞌuil templo xchiꞌuquic ti Jesuse. Li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juane, xchiꞌuc li Andrese, lic la sjacꞌbeic ta mucul ti Jesuse: ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Alo caꞌiticotic cꞌusi ora ta xlomesat li temploe. ¿Cꞌusi seña ti cꞌalal poꞌot xaꞌox xlome? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","―Pꞌijanic me, mu me xachꞌunic loꞌloel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yuꞌun ep ti muchꞌutic chtale, “voꞌon Cristoon”, xiic. Ep ti muchꞌutic ta xchꞌunic loꞌloele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ti cꞌalal chavaꞌiic ti oy acꞌ cꞌoqꞌue, ti cꞌalal chavaꞌiic ti chlic xa acꞌ cꞌocꞌ ta nome, mu me xaxiꞌic. Chcꞌot onox yech pero li balamile maꞌuc toꞌox chlaj. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta sliquesic acꞌ cꞌocꞌ li crixchanoetic ta yantic o balamile. Ta sliquesic acꞌ cꞌocꞌ li preserenteetic noxtoque. Oy bu ch-echꞌ tsots niquel, oy bu ch-echꞌ tsots viꞌnal. Taje sliqueb to vocol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Li voꞌoxuque pꞌijanic me. Oy chaꞌiqꞌueic echꞌel ta stojol jmeltsanejcꞌopetic ta bicꞌtal temploetic. Oy chavichꞌic arcial teyoꞌe. Chaꞌiqꞌueic echꞌel ta stojol coviernoetic xchiꞌuc ta stojol preserenteetic ta scoj ti avichꞌojicon ta muqꞌue, jaꞌ yoꞌ xavalbeic o li cꞌusi caloje. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Baꞌyi onox chvinaj ta sjunlej balamil ti ista xa yora tspasvan ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ti cꞌalal xaꞌiqꞌueic echꞌele, mu me baꞌyiuc xanopic ti cꞌusi chcꞌot avalique, ti cꞌuxi chatacꞌavique. Jaꞌ chaspꞌijubtasic cꞌuxi chatacꞌavic ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oy bu chacꞌ ta milel yitsꞌin, o mi sbanquil. Oy bu chacꞌ ta milel xchꞌamal. Oy bu tscrontain stot smeꞌ, chaqꞌuic ta milel noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ep muchꞌutic chopol chayilic o ti avichꞌojicon ta muqꞌue. Li muchꞌutic chcuch yuꞌunic li ilbajinele, mi mu xicta o sbaique, jaꞌ chcuxiic ta sbatel osil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ti chajtsꞌibabeic liꞌi, jaꞌ yoꞌ xachꞌunic o ti cꞌusi iꞌalbatic yuꞌun Jesús li lajchavoꞌe. ―Voꞌoxuc ti liꞌ nacaloxuc ta Judeae, ti cꞌalal xavilic ti vaꞌanbil ta yut templo li cꞌusi mu scꞌan ti Rioxe chac cꞌu chaꞌal iyal onox ti Daniel yajꞌalcꞌop Riox ti ta voꞌnee, yechꞌo un ba nacꞌ abaic ta vitstic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lavi pachꞌal li sba anaique, mi jaꞌo oy muchꞌu tey xvaꞌete, ti cꞌalal xyal tale, mu xa me xꞌoch stam cꞌusuc yuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ti muchꞌutic tey ta yabtelique, mu xa me yaꞌuc sut stam spimilcꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Abol sbaic tajmec ti muchꞌutic oy xchꞌute xchiꞌuc ti muchꞌutic ta xchuꞌun to yolique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cꞌoponic Riox ti mu me jaꞌuc o tol sic ti cꞌalal xajatavique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuꞌun tsots tajmec li castico ta xtale. Muc bu xꞌechꞌ o yech ta spasel balamil, jaꞌto chtal. Ti cꞌalal xꞌechꞌe, mu xa bu chtal noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti Rioxe xchꞌacoj ti cꞌu sjalil li casticoe. Ti jaluc tajmeque, chalaj acotolic ti yechuque. Ti mu jaluc li casticoe, jaꞌ ta scuentaic ti muchꞌutic stꞌujoje ti xchꞌunojbeic li scꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’“Leꞌ xa li Cristoe”, “taj xa li Cristoe”, mi oy muchꞌu xayutique, mu me xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yuꞌun chtalic ti muchꞌutic tspꞌis sbaic ta Cristoe, xchiꞌuc ti muchꞌutic chalic yilel li scꞌop Rioxe. Chaqꞌuic iluc syuꞌelic yoꞌ xchꞌunic o loꞌloel li crixchanoetique. Yoꞌonuc sloꞌloic uc li muchꞌutic stꞌujoj ti Rioxe, pero mu xa xchꞌunic loꞌloel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Li voꞌoxuque pꞌijanic me, baꞌyi me lacalbeic scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ti cꞌalal xlaj echꞌuc scotol li castico lacalbeique, jaꞌo chmac sat li cꞌacꞌale, chꞌabal xa li jchꞌulmeꞌtique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Li cꞌanaletique jupꞌejtic chpꞌaj. Chnic scotol li cꞌusitic oy ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jaꞌo chil scotol crixchanoetic ti oy jyuꞌele, ti oy jxojobal ti cꞌalal xiyal tal ta ba toc ta balamil, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta jtac echꞌel cajꞌanjeltac jaꞌ chba stsobic tal ta sjunlej balamil ti muchꞌutic jtꞌujoje ti xchꞌunojic cꞌusi caloje. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Naꞌic me, cꞌalal xavilic ti chlaj xa cocojuc yanal li icꞌuxe, jaꞌ chvinaj o ti ch-och xa voꞌtique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jaꞌ noꞌox yech ti cꞌalal xavilic chlaj cꞌotuc li cꞌusitic icale, jaꞌ chvinaj o ti chichaꞌsut xa tale. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta melel chacalbeic, oy toꞌox cuxuloxuc jlom ti cꞌalal xtal ti jaytos castico lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Li vinajel balamile chlaj onox. Yan li cꞌusitic chcale mu xchꞌay, persa chcꞌot scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Muc muchꞌu snaꞌ ti cꞌusi ora chichaꞌsut tale, mi jaꞌuc ti anjeletic ta vinajele, mi voꞌonicon mu jnaꞌ. Stuc noꞌox snaꞌoj ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ichꞌicon noꞌox me ta mucꞌ, malaicon. Cꞌoponic Riox yuꞌun mu xanaꞌic cꞌusi ora chichaꞌsut tal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Coꞌol xchiꞌuc jun vinic ti ibat ta nome. Li yajꞌabteltaque iyalbe comel ti acꞌu xchabibel li snae. Iyacꞌbe comel yabtel jujun. Li muchꞌu ta xchabi tiꞌnae, iyalbe comel ti mu me xvaye, ti acꞌu smalaele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jaꞌ noꞌox yechoxuc uc, tscꞌan chamalaicon yuꞌun mu xanaꞌic cꞌusi ora chichaꞌsut tal voꞌon lavajvalicone, mi ta yochel acꞌubal, o mi ta ol acꞌubal, o mi ta sba yoqꞌuel quelem, o mi ta icꞌluman. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mu me chꞌayemuc avoꞌonic chul jtaoxuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Li voꞌoxuque lacalbeic xa ti malaicon noꞌoxe. Jaꞌ yech chcalbe scotol crixchanoetic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chib xaꞌox cꞌacꞌal scꞌan li sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, voꞌoticotic li jꞌisraeloticotique. Jaꞌo cꞌalal chichꞌ veꞌel pan ti muc bu yichꞌoj svuquesobil xchꞌute. Ti totil paleetique, xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, isnopic la ti cꞌu to xi xuꞌ tsmucultsaquic ti Jesuse yuꞌun la tscꞌan tsmilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","―Más lec mu yaꞌuc jtsactic lavi ta qꞌuine naca me licuc o sjol li jchiꞌiltactique ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ti cꞌalal tey ta Betania ti Jesuse, tey la chveꞌ ta mexa ta sna Simón ti ip toꞌox ta leprae. Jaꞌo la tey icꞌot jun ants, yichꞌoj la cꞌotel slimete meltsanbil ta alabastro ton. Noj la ta yaꞌlel muil nichim, nardo sbi. Toyol tajmec stojol. Iscꞌasbe la snucꞌ ti slimetee. Ti sbele iscoconbe la ta sjol ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oy la jayvoꞌ icapic o. ―¿Cꞌu yuꞌun ti yech noꞌox ta smal li yaꞌlel nardoe? ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Más lec ti ixchonuque, yuꞌun más ta oxib cien denario stojol ti yechuque. Li stojole xuꞌ chichꞌ meꞌonetic ti yechuque ―xut la sbaic. Yuꞌun la chopol iyilic ti xꞌelan ispas ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","―¿Cꞌu yuꞌun ti xꞌelan chavalique? Anchanic xa. Li cꞌusi liyacꞌbee lec. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Li meꞌonetique liꞌ onox achiꞌinojique, cꞌusuc noꞌox ora xuꞌ chacꞌuxubinic. Yan li voꞌone muc bu jal liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Li antse ispas xa ti cꞌusi xuꞌ chaꞌie. Ti liscoconbe li yaꞌlel nardoe, jaꞌ seña ti chimuquee. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta melel chacalbeic, chvinaj onox ta sjunlej balamil ti voꞌon chcacꞌ acuxlejalic ta sbatel osile. Chvinaj noxtoc ti liscoconbe yaꞌlel nardo li antse ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ti Judas Iscariotee jaꞌ lajchavoꞌic o ta yajchancꞌop ti Jesuse. Jaꞌ la ba scꞌopon ti totil paleetique yuꞌun la tspas trate ti chacꞌ entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ti cꞌalal iyaꞌi ti totil paleetique, xmuyubajic xa la tajmec. ―Chacacꞌbeticotic taqꞌuin ―xutic la ti Judase. Ti Judase isaꞌ la ti cꞌu to xi xuꞌ chacꞌ entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti cꞌalal ilic li qꞌuin ti chichꞌ veꞌel pan ti muc bu yichꞌoj svuquesobil xchꞌute, cꞌalal tsmilic li chꞌiom chijetic scuenta li sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, li lajchavoꞌe isjacꞌbeic la ti Jesuse: ―¿Bu chacꞌan ti chba jmeltsanticotic li chꞌiom chij ti ta jtiꞌtic ta qꞌuine? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Itaqueic la tal chaꞌvoꞌ yuꞌun ti Jesuse. ―Batanic ta Jerusalén. Tey chataic ta be jun vinic scuchoj jpꞌej qꞌuib yaꞌal. Jaꞌ napꞌletaic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti bu ch-oche xcꞌot acꞌoponic li yajval nae. Jaꞌ yech xcꞌot avalbeic: “Liꞌ listacoticotic tal li Jchanubtasvaneje: ¿Bu la jcꞌolucal chavacꞌboticotic lanae ti ta jtiꞌticotic o li chij ta qꞌuine xchiꞌuc li cajchancꞌoptaque?” xavutic cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tey chacꞌ avilic jcꞌol ta xchaꞌcojol sjol sna, lec mucꞌ, chꞌubabil xa. Jaꞌ tey xameltsanic li jveꞌeltique ―xꞌutatic la tal li chaꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Italic la, iꞌochic la tal ta yutil jteclum. Jaꞌ la yech istaic chac cꞌu chaꞌal iꞌalbatic tal yuꞌun ti Jesuse. Jaꞌ la tey ismeltsanic ti veꞌlil scuenta qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ti cꞌalal iꞌoch orisyone, tsobolic la yulel ta na xchiꞌuquic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ti cꞌalal cholol chveꞌic ta mexae ―Ta melel chacalbeic, oy junoxuc ti liꞌ tsobol chiveꞌotique chavaqꞌuicon entrucal ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ti cꞌalal iyaꞌiique, iyat la yoꞌonic. ―¿Mi voꞌon van? ―xiic la jujuntal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","―Ta alajchavaꞌalique, jaꞌ li muchꞌu jun jpulatu chiveꞌ jchiꞌuque jaꞌ chiyacꞌ entrucal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Voꞌon ti coꞌol crixchanootique, chquichꞌ milel chac cꞌu chaꞌal tsꞌibabil onox ta scꞌop Rioxe. Abol sba li muchꞌu chiyacꞌ entrucale. Más lec ti manchuc iꞌayane ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ti cꞌalal yolel chveꞌique, istam la jpꞌej pan ti Jesuse. “Colaval” xut la ti Rioxe, jaꞌo la ixut ti pane, iꞌacꞌbatic la li lajchavoꞌe. ―Ilo, veꞌanic. Liꞌi jaꞌ jbecꞌtal jtacupal ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Istam la noxtoc jun baso yaꞌlel uva, “colaval” xut la ti Rioxe, jaꞌo la iꞌacꞌbatic noxtoc. Iyuchꞌic la scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","―Liꞌi jaꞌ jchꞌichꞌel, jaꞌ seña ti chcꞌot onox ti cꞌusi tsꞌacal to iyal ti Jtote ti ta jchꞌichꞌel chtoj lamulique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta melel chacalbeic ti mu xa bu chcuchꞌ li yaꞌlel uvae. Jaꞌto chcuchꞌ ti cꞌalal tey xa tsobolotic jcotoltic yoꞌ bu chacꞌ jpas mantal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ti cꞌalal laj sqꞌuevujintaic ti Rioxe, ibatic la ta vits Olivotic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","―Liꞌ ta jliquele chacomtsanicon acotolic. Tsꞌibabil onox: “Ti Rioxe ta la xacꞌ ta milel li muchꞌu stꞌujoj chispasotic ta mantale. Ti cꞌalal xmilee, ta la stani sbaic echꞌel ti xchiꞌiltaque, coꞌol la cꞌu chaꞌal chij ti ta stani sba echꞌel mi imile li xchabielique”, xi tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ti cꞌalal xichaꞌcuxie, chibat ta Galilea. Tey xa chcꞌot ataicon ―xꞌutatic la yuꞌun Jesús li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","―Acꞌu mi xascomtsan li yane, li voꞌone mu xajcomtsan ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","―Ta melel chacalbe, lavi ta acꞌubaltique ti cꞌalal mu toꞌox ch-ocꞌ xchaꞌoqꞌuelal li queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","―Muc ta alel mi coꞌol lilajotique. Jamal chcal ti xacojtiquine ―xi la tajmec li Pedroe. Jaꞌ la yech iyal scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tey la icꞌotic ta Getsemaní sbi xchiꞌuquic ti Jesuse. ―Chotlanic liꞌtoe yuꞌun chba jcꞌopon Riox leꞌtoe ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Oxvoꞌ no la iꞌiqꞌueic echꞌel yuꞌun ti Jesuse, jaꞌic la li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juane. Ti Jesuse iyat la yoꞌon. Yan la sba yoꞌon iyaꞌi. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","―Chcat coꞌon tajmec, chicham yaꞌel. Comanic liꞌtoe, mu me xavayic uc ―xꞌutatic la li oxvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ti Jesuse ijelav to la echꞌel jsetꞌ. Isquejan la sba, jaꞌo la isnijan sba ta balamil noxtoc. Iscꞌopon la Riox, jaꞌ la iscꞌanbe ti xuꞌuc to mu xchame. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","―Tot, mu cꞌusi vocol chavaꞌi. Ti xuꞌuc to ti mu xichame, lec. Pero maꞌuc me xcꞌot li cꞌusi chal coꞌon jtuque, jaꞌ acꞌu jpas li cꞌusi chacꞌan li voꞌote ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Isut la tal yoꞌ bu li oxvoꞌe. Vayemic la yul staelic. Iꞌalbat la li Pedroe: ―Simón, ¿mi vayemot? ¿Mi mu xcuch avuꞌun junuc ora yaꞌel li vayele? ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu me xavayic, cꞌoponic Riox yoꞌ mu xapasic o li cꞌusitic chopole. Ta melel avoꞌonicuc acꞌoponic Riox, pero lapat axoconique mu xuꞌ yuꞌun ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ti Jesuse ba la scꞌopon Riox noxtoc. Jaꞌ no la yech iyal chac cꞌu chaꞌal iyal ta baꞌyie. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ti cꞌalal isut tale, vayemic la yul staelic noxtoc li oxvoꞌe, yuꞌun la mu xcuch chaꞌiic li vayele. Mu xa la snaꞌic cꞌuxi chtacꞌavic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ti Jesuse ba la scꞌopon Riox yoxꞌechꞌelal. Ti cꞌalal isut tale, vayemic la yul staelic noxtoc. ―Xuꞌ mi chavayic toe. Mi chacuxic to, cuxic. Más lec taꞌluc o xa. Yuꞌun ista xa yora ti chiꞌaqꞌue entrucal ta stojol jmulaviletic, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Licanic, batic. Qꞌuelavilic, leꞌ xa xtal li muchꞌu chiyacꞌ entrucale ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ti cꞌalal xyaquet chloꞌilaj ti Jesuse, jaꞌo la tey icꞌot ti Judase, jaꞌ lajchavoꞌic o ta yajchancꞌop ti Jesuse. Xchiꞌuc la cꞌotel epal crixchanoetic, oy la yespadaic, oy la steꞌic. Jaꞌ la stacojic echꞌel ti totil paleetique, xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ti Judase, ti snopoj xa onox ti chacꞌ entrucal ti Jesuse, yaloj xa la cꞌu xꞌelan chacꞌ iluc ti Jesuse: ―Ti muchꞌu ta jbutsꞌe, jaꞌ me xatsaquic. Lec me xachabiic echꞌel ―xi onox la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ti cꞌalal icꞌot ti Judase, inopoj la yoꞌ bu ti Jesuse. ―Jchanubtasvanej ―xut la. Jaꞌo la isbutsꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaꞌo la inopoj ti crixchanoetique, istsaquic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Oy la jun isloqꞌues la yespada, istuchꞌbe la jun xchiquin ti smozo más totil palee. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ti Jesuse iyalbe la ti crixchanoetique: ―¿Cꞌu yuꞌun ti ta espada ta teꞌ tal atsaquicon chac cꞌu chaꞌal jꞌeleqꞌue? ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ti tey onox chichanubtasvan ta tiꞌ mucꞌta templo jujun cꞌacꞌale, ¿cꞌu yuꞌun ti mu teyuc noꞌox atsaquicon yaꞌele? Ti xꞌelan tal atsaquicone, jaꞌ icꞌot ti yech onox tsꞌibabil comel ta scꞌop Rioxe ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Li buluchvoꞌe ijatav la scotolic, stuc xa la tey iscomtsanic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oy jun svaꞌlej crem napꞌal ital ta spat ti Jesuse. Chꞌabal scꞌuꞌ, jlic noꞌox manta svoloj o sba. Itsaque ox. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero ijatav, cꞌajom itabat ta tsaquel ti manta svoloj o sbae. Xtꞌanet xa echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ti Jesuse iyiqꞌuic la tal ta stojol ti más totil palee. Istsob la sba scotolic ti totil paleetique, xchiꞌuc ti jmeltsanejcꞌopetique, xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Li Pedroe nomnomtic la tijil tal ta spat ti Jesuse. Ti cꞌalal iyul ta sna ti más totil palee, ixchiꞌin la ta chotlej ta tiꞌna jayvoꞌ jchabiejtemplo, tey la icꞌatin xchiꞌuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ti totil paleetique xchiꞌuc ti cajmeltsanejcꞌopticotique, lic la saꞌic chaꞌvoꞌ xchiꞌilic ta meltsanejcꞌop ti coꞌol cꞌusi chalique yuꞌun la tsaꞌbeic smul ti Jesuse yoꞌ la xmile oe. Pero mu la bu istaic ti chaꞌvoꞌ coꞌol cꞌusi chalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yech no la ti ep jnopmulile, mu la coꞌoluc ti cꞌusi chalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Isvaꞌan la sba yan jnopmulil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Li vinic liꞌi caꞌyojticotic ti iyal ti xuꞌ tslomes li templo liꞌi ti meltsanbil ta cꞌobole, ti xuꞌ la chchavaꞌan ta oxib cꞌacꞌale, mu xa la ta cꞌoboluc chvaꞌi ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mu la coꞌoluc ti cꞌusi iyalique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ti más totil palee isvaꞌan la sba ta oꞌlol. ―¿Cꞌu yuꞌun ti mu xatacꞌave? ¿Mi yech avaloj chac taje? ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mi jpꞌel mu la bu itacꞌav ti Jesuse. Ti totil palee isjacꞌbe la noxtoc: ―¿Mi voꞌot Cristoot ti yaloj Riox chapasoticotic ta mantale? ¿Mi voꞌot Xchꞌamalot ti Rioxe? ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","―Voꞌon ―xi la ti Jesuse―. Voꞌon ti coꞌol crixchanootique chavilic chlic jpas ta mantal crixchanoetic ta syuꞌel ti Rioxe. Tsꞌacal to chil scotol crixchanoetic ti ta toc chichaꞌsut tale ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ti totil palee isjat la scꞌuꞌ, yuꞌun la istabe xa smul ti yaloje. ―¿Cꞌu xa stu cuꞌuntic yan rextico? ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Icaꞌitic xa ti tspꞌis sba ta Rioxe. ¿Cꞌusi chanopic uc? ―xut la ti xchiꞌiltac ta meltsanejcꞌope. ―Acꞌu chamuc ta jmoj ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ti jlome lic la stubtaic ti Jesuse. Ismacbeic la sat, ismajic la. ―¿Muchꞌu li lasmaje? ―xutic la. Ti jchabiejtemploe imajvanic la uc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti Jesuse tey la ta xchaꞌcojol jolna. Li Pedroe tey la icom ta tiꞌna. Ital la jun squiara ti más totil palee. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iꞌile la ti tey chcꞌatin li Pedroe. Iqꞌuelbat la sat. ―Li voꞌote jaꞌ achiꞌil li Jesus Nazarete ―xꞌutat la yuꞌun ti quiaraile. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","―Mu xcojtiquin. Mu jnaꞌ li cꞌusi chavale ―xi la li Pedroe. Jaꞌo la ibat ta tiꞌbe li Pedroe. Jaꞌo la iꞌocꞌ quelem. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Li Pedroe iꞌile la noxtoc yuꞌun ti quiaraile. ―Li vinic leꞌe jaꞌ xchiꞌil li Jesuse ―xꞌutatic la yuꞌun quiarail ti muchꞌutic tey tsobolique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","―Mu xcojtiquin ―xi la noxtoc li Pedroe. Ta jliquel o jaꞌ la yech lic albatuc noxtoc yuꞌun ti muchꞌutic tey tsobolique: ―Yech ti jaꞌ achiꞌile yuꞌun xvinaj ti jgalileaote. Jaꞌ yech chacꞌopoj chac cꞌu chaꞌal chcꞌopojique ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","―Lojriox mu xcojtiquin li vinic chavalique ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jaꞌo la iꞌocꞌ xchaꞌoqꞌuelal quelem. Li Pedroe iyul la ta sjol ti yech onox iꞌalbat yuꞌun ti Jesuse: “Ti cꞌalal mu toꞌox ch-ocꞌ xchaꞌoqꞌuelal queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone”, xꞌutat onox la yuꞌun ti Jesuse. Ti cꞌalal iyul ta sjole, iyoqꞌuita la sba. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ti cꞌalal isacube, istsob la sbaic scotolic li muchꞌutic oy yabtele: jaꞌ ti totil paleetique, xchiꞌuc ti cajmeltsanejcꞌopticotique, xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Isnopic la cꞌu xꞌelan chcꞌot sticꞌbeic smul ti Jesuse yoꞌ la xꞌaqꞌue o ta milel yuꞌun ti coviernoe. Ixchucbeic la echꞌel scꞌob, ba la yacꞌbeic entrucal ti covierno Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ti Pilatoe isjacꞌbe la ti Jesuse: ―¿Mi yech ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale? ―xut la. ―Yech ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ti totil paleetique ep la isnopbeic smul ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ti Pilatoe isjacꞌbe la noxtoc ti Jesuse: ―¿Cꞌu yuꞌun ti mu xatacꞌave? Qꞌuelavil, chalic ti toj ep amule ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ti Jesuse mu la bu itacꞌav. Ti Pilatoe xchꞌayet xa la yoꞌon ti muc bu ispac scꞌoplal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ta jujun sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, ti Pilatoe isloqꞌues jun jchuquel ti bu junucal tscꞌanic loqꞌuesbel ti jchiꞌilticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tey tiqꞌuil ta chuquel xchiꞌuc xchiꞌil ta milvanej jun jchiꞌilticotic, Barrabás sbi. Yuꞌun istsob toꞌox sbaic, iscrontainic ti coviernoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ti cꞌalal tey tsobol ti jchiꞌilticotique, iyalbeic ti Pilatoe ti acꞌu sloqꞌues junuc jchuquel chac cꞌu chaꞌal tspas onox jujun qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","―¿Mi jaꞌ chacꞌanic ti ta jcolta liꞌi ti chal ti jaꞌ chaspasic ta mantale? ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ti xꞌelan iyal ti Pilatoe, yuꞌun snaꞌoj ti yitꞌixal noꞌox yoꞌonic ti totil paleetique ti iyaqꞌuic entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ti totil paleetique ispꞌijubtasic ti crixchanoetique ti jaꞌ acꞌu scꞌanic loqꞌuesbel ti Barrabase. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","―¿Cꞌusi ta jchaꞌle li muchꞌu chaspasic ta mantal chavalique? ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iꞌavan scotolic noxtoc: ―¡Jipano ta cruz! ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―¿Cꞌusi smul avuꞌunic? ―xi ti Pilatoe. Más to tsots iꞌavanic. ―¡Jipano ta cruz! ―xiic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ti Pilatoe jaꞌ tscꞌan ti ichꞌbil ta mucꞌ yuꞌun ti crixchanoetique, yechꞌo ti jaꞌ isloqꞌues ti Barrabase. Jaꞌo iyalbe ti yajsolterotaque ti acꞌu yacꞌbeic arsial ti Jesuse. Ti cꞌalal laj yacꞌbeique, iyacꞌ orten ti acꞌu ba sjipanel ta cruze. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ti yajsolterotac coviernoe iyiqꞌuic ochel ta yut palacio ti Jesuse, jaꞌ ti Pretorio sbie. Istsob sbaic scotol ti solteroetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Islambeic jlic cꞌuꞌul, morado. Ixotic chꞌix, ixojbeic ta sjol. Jaꞌ la scorona ti ta alele. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lic slabanic. ―¡Toj leclec aba caꞌuctic ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale! ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Isjisbeic aj ta sjol. Istubtaic. Isquejan sbaic ta yichon ti Jesuse, iyichꞌic ta mucꞌ yilel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tsꞌacal to islocꞌbeic ti morado cꞌuꞌul ti slamojbeic toꞌoxe, jaꞌ iyacꞌbeic slap ti scꞌuꞌ onoxe. Iyiqꞌuic echꞌel, ba sjipanic ta cruz. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ti cꞌalal iloqꞌuic echꞌel ti solteroetique xchiꞌuc ti Jesuse, isnupic ta be jun jchiꞌilticotic ta jurioal, jaꞌ stotic li Alejandroe xchiꞌuc li Rufoe, Simón sbi. Ti Simone liquem tal ta jun jteclum, Cirene sbi. Ti solteroetique iyaqꞌuic ta persa ti Simone ti acꞌu scajan echꞌel ta snequeb scruzal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ti Jesuse iyiqꞌuic echꞌel yoꞌ Gólgota sbie. Li Gólgotae “Baquel Jol Anima”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iyacꞌbeic yaꞌlel uva capal ta mirra pero muc xuchꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ti solteroetique isjipanic ta cruz ti Jesuse. Tsꞌacal to ixchꞌacbe sbaic ti scꞌuꞌe. Itajinic isqꞌuelic ti muchꞌu junucal chichꞌ julique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta baluneb ora sob isjipanic ta cruz ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tsꞌibabil ta sjol scruzal ti cꞌusi smul ti imile oe. “Liꞌi jaꞌ yajpasvanejic ta mantal li jurioetique”, xi tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oy chaꞌvoꞌ jꞌelecꞌ coꞌol isjipanic ta cruz xchiꞌuc ti Jesuse, jun scruzal ta sbatsꞌicꞌob, jun ta surto. Ti scruzal Jesuse jaꞌ ta oꞌlol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jaꞌ icꞌot ti yech onox tsꞌibabil scꞌoplal ta scꞌop Rioxe: “Ta spꞌise ta jmulavil”, xi tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Ti muchꞌutic tey iꞌechꞌique ilabanvanic, isjimulan sjolic. ―¡Qꞌuelavil un! Aval ti chalomes li mucꞌta temploe, ti xuꞌ chachaꞌvaꞌan ta oxib cꞌacꞌale, yechꞌo un pojoquic aba un. Yalanquic tal un ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ilabanvanic uc ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ―Iyetꞌesbe xchamelic li crixchanoetique. Li stuc une mu xuꞌ scolta sba un. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mi yech ti jaꞌ chispasotic ta mantal voꞌotic li jꞌisraelotique, acꞌuquic yaluc tal ta ora un yoꞌ xquiltic oe, yoꞌ jchꞌuntic oe ―xiic. Ilabanvanic uc ti chaꞌvoꞌ jꞌeleqꞌue ti coꞌol jipajtic ta cruz xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta ol cꞌacꞌal iꞌicꞌub. Ta oxib to ora xmal isacub. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta oxib ora xmal jaꞌo tsots iꞌavan ti Jesuse: ―Eloi, Eloi, ¿lama sabactani? ―xi. Ti cꞌusi iyale, “Cajval, Cajval, ¿cꞌu yuꞌun ti acomtsanone?” xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oy jayvoꞌ ti iyaꞌiique. ―¡Vaꞌi un! Jaꞌ chapta ti jꞌalcꞌop Elíase ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jaꞌo ibat ta anil jun ti muchꞌu iyaꞌie, ba stam tal esponja. Istsꞌaj ta binagre, ixoj ta aj, iyacꞌbe stsꞌutsꞌ ti Jesuse. ―Mu xavacꞌbe. Jqꞌueltiquic mi chtal syalesel ta cruz yuꞌun ti Elíase ―xꞌutat yuꞌun ti yantique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ti Jesuse tsots iꞌavan noxtoc, jaꞌo xa ilocꞌ xchꞌulel. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jaꞌo ijat ta oꞌlol ti mucꞌta pocꞌ scꞌalobil li mucꞌta temploe. Ijat yalel cꞌalal yoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ti capitán solteroe tey vaꞌal ta stuqꞌuil ti Jesuse. Cꞌalal iyil ti ilocꞌ xchꞌulel cꞌalal laj avanuque ―Melel ti jaꞌ xchꞌamal Rioxe ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tey jayvoꞌ antsetic noxtoc, nom tsqꞌuelic ti jipil ta cruz ti Jesuse. Tey capal li María liquem tal ta Magdalae, xchiꞌuc Salomé, xchiꞌuc otro jun María li smeꞌic Josee xchiꞌuc li “cꞌox Jacobo” sbi cuꞌunticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jaꞌ li muchꞌutic ixchiꞌinic ta xanvil ta estado Galilea ti Jesuse, ti ismacꞌlinique. Ep yan antsetic tey, jaꞌ ti muchꞌutic tsobol italic ta Jerusalén xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ti cꞌalal icham ti Jesuse, jaꞌo ta scꞌacꞌalil ta xchap sbaic li jchiꞌilticotic ti ta xcuxic ta yocꞌomale. Tey jun jchiꞌilticotic, José sbi, liquem tal ta jteclum Arimatea. Ti Josee ochem ta meltsanejcꞌop cuꞌunticotic. Ichꞌbil ta mucꞌ. Smalaoj uc ti chtal pasvanuc ta mantal ti Rioxe. Ta smalel cꞌacꞌal ti Josee isnop ti chba scꞌopon ti Pilatoe. Muc bu xiꞌem, ba scꞌanbe spat xocon ti ánima Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ti Pilatoe toj chꞌayel la yoꞌon icꞌot ti cꞌalal iyaꞌi ti icham xa ti Jesuse. Yuꞌun yiloj ti mu xcham ta ora ti muchꞌutic chjipanat ta cruze. Istac la ta iqꞌuel ti capitan solteroe, isjacꞌbe la mi yech ti icham xa ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ti cꞌalal iyal ti capitan solteroe ti icham xae, ti Pilatoe iyacꞌ la permiso ti xuꞌ chichꞌ ti Josee. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yechꞌo un ti Josee isman jlic saquil pocꞌ, jaꞌo isyales ta cruz ti Jesuse. Ispix ta saquil pocꞌ, ba sticꞌ ta chꞌojbil ton. Isetetin tal mucꞌta setset ton, ismac o comel li tiꞌchꞌene. ");
INSERT INTO tzoZNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Li María liquem tal ta Magdalae xchiꞌuc li otro jun Maríae li smeꞌ Josee, iyilic bu itiqꞌue comel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ti cꞌalal ichꞌay cꞌacꞌal ta savaroe, li María liquem tal ta Magdalae, xchiꞌuc li Salomee, xchiꞌuc li otro jun Maríae li smeꞌ Jacoboe, ismanic la muil tsꞌiꞌlel ti chba yacꞌbeic ta spat xocon ti ánima Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sob ta primero cꞌacꞌal xemana, jaꞌ li romincoe, ibatic la yoꞌ bu telanbil ti Jesuse. Naca la ilocꞌ cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","―¿Muchꞌu chisetetinbotic loqꞌuel tana li ton ta tiꞌ chꞌene? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ti cꞌalal icꞌotique, setetinbil xaꞌox la loqꞌuel li mucꞌta ton macbil o stiꞌil li chꞌene. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iꞌochic la, tey la iyilic jun crem yilel, tey la chotol ta sbatsꞌicꞌobic. Nat la scꞌuꞌ, sac la. Ixiꞌic o la tajmec li antsetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","―Mu me xaxiꞌic. Jnaꞌoj ti jaꞌ chasaꞌic ti Jesus Nazarete ti icham ta cruze. Ichaꞌcuxi xa. Mu xa bu liꞌi. Qꞌuelavilic yoꞌ bu istelanic toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ba albeic li Pedroe xchiꞌuc li yan yajchancꞌope ti jaꞌ baꞌyi chcꞌot ta Galilea li Jesuse. Tey chcꞌot staic ti cꞌu chaꞌal iꞌalbatic onoxe ―xꞌutatic la li antsetique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Li antsetique anil la iloqꞌuic. Xtꞌeleletic xa tal ta xiꞌel. Mu la muchꞌu iyalbeic ta be, jaꞌ la ti xiꞌemique. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ti cꞌalal ichaꞌcuxi ti Jesuse sob ta primero cꞌacꞌal xemana, jaꞌ li romincoe, baꞌyi iyacꞌ sba iluc ta stojol li María liquem tal ta Magdalae, jaꞌ ti iloqꞌuesbat vucvoꞌ pucuj ta yoꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Li Maríae tal la yal ti iyil ti Jesuse. Jaꞌ la iꞌalbatic li muchꞌutic ixchiꞌinic toꞌoxe. Chat la yoꞌonic ch-oqꞌuic la yul staelic yuꞌun li Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cꞌalal iyaꞌiic ti ichaꞌcuxi xa ti Jesuse, ti iyil li Maríae, muc la xchꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsꞌacal to ti Jesuse iyacꞌ la sba iluc ta be ta stojol chaꞌvoꞌ ti ixchiꞌinic toꞌoxe. Muc la xojtiquinic ta ora yuꞌun la maꞌuc iyilic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Li chaꞌvoꞌe isutic la tal liꞌ ta Jerusalene, jaꞌ la tal albaticuc li yantique ti iyilic ti Jesuse, pero muc la xchꞌunic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Más to tsꞌacal iyacꞌ la sba iluc ta stojolic li buluchvoꞌe, jaꞌo la yolel chveꞌic. ―¿Cꞌu yuꞌun ti mu xachꞌunic tajmeque? ―xꞌutatic la yuꞌun ti Jesuse. Yuꞌun la muc xchꞌunic ti cꞌalal iꞌalbatic yuꞌun ti muchꞌutic iyilic ti chaꞌcuxieme. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iꞌalbatic la yuꞌun ti Jesuse: ―Batanic ta sjunlej balamil. Ba albeic scotol crixchanoetic ti voꞌon xuꞌ chcacꞌ cuxlicuc ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ti muchꞌutic ta xchꞌunique, ti chichꞌic voꞌe, jaꞌ chcuxiic ta sbatel osil. Yan ti muchꞌutic mu xchꞌunique jmoj scꞌoplal ch-ochic ta cꞌocꞌ ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ti muchꞌutic ta xchꞌunique chaqꞌuic iluc ti oy jlequilal jyuꞌelale. Voꞌon ta jyuꞌel ta sloqꞌuesic pucujetic ta yoꞌonic li crixchanoetique. Chcꞌopojic ta ora ta yan o cꞌopetic. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Acꞌu mi oy bu tstaic ta piquel quiletel chon, acꞌu mi xꞌacꞌbatic beneno, mu xchamic o. Ti cꞌalal xacꞌ scꞌobic ta sba li jchameletique, ta xꞌechꞌ li chamele ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ti cꞌalal laj cꞌoponaticuc comele, jaꞌo la ibat ta vinajel ti Cajvaltic Jesuse. Tey cꞌot chotluc ta sbatsꞌicꞌob ti Rioxe, tey tspas mantal xchiꞌuc. ");
INSERT INTO tzoZNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Li yajchancꞌoptaque iloqꞌuic ta yalel aꞌyuc ta sjunlej balamil ti cꞌusitic iyal comele. Icoltaatic ta yalel aꞌyuc yuꞌun ti Cajvaltique. Iyaqꞌuic iluc ti oy slequilal syuꞌelale, jaꞌ ivinaj o ti jaꞌ yaloj comel ti cꞌusitic iyalic aꞌyuque.");
INSERT INTO tzoZNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Jtotic Teófilo, voꞌot ti ichꞌbilot ta muqꞌue, ep xa muchꞌutic istsꞌibaic ta vun ti cꞌusitic ispas iyal ti Cajvaltic Jesuse ti cꞌalal iꞌay liꞌ ta sba balamile. Jaꞌ liyalboticotic ti muchꞌutic iyilic cꞌu xꞌelan iyacꞌ iluc slequilal syuꞌelal ti Jesuse, ti jaꞌ itunic ta svinajesel ti cꞌusitic iyale. Ijnop uc ti jaꞌ lec chajtsꞌibabe scotol li cꞌusitic icaꞌi tal ta sliquebe. Yechꞌo un, jtotic Teófilo, xcholet chajtsꞌibabe yoꞌ xanaꞌ o lec ti yech ti cꞌu xꞌelan lachanubtasate. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti cꞌalal ochem ta coviernoal ta estado Judea ti Erodese, oy la jun yajpaleic li jꞌisraeletique, Zacarías la sbi. Li jꞌisraeletique oy jayqꞌuex yajpaleic yuꞌun sjeljel sbaic ti chtunic ta mucꞌta temploe. Ti jqꞌuexe Abías sbiic. Jaꞌ la tey tiqꞌuil ti Zacaríase. Elisabet la sbi ti yajnile. Ti smucꞌtatot ti ta más voꞌne ti Elisabete, jaꞌ la ti Aarone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ti Cajvaltique yiloj ti lec yoꞌon xchiꞌuc yajnil ti Zacaríase. Yuꞌun la xchꞌunojic ti cꞌusitic yaloj ti Cajvaltique, yechꞌo ti chꞌabal smul iꞌileique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero chꞌabal la xchꞌamal yuꞌun la mu snaꞌ xꞌalaj ti Elisabete. Meꞌel mol xa la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ti Zacaríase xchiꞌuc ti xchiꞌiltac ta paleale icꞌot la scꞌacꞌalil ti chtunic yuꞌun Riox ta stemploique yuꞌun tsjel onox sbaic juqꞌuex ti paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ti jqꞌuex ta xtunique jaꞌ la stalelic ti chtajinic jujun cꞌacꞌale yuꞌun la tsqꞌuelic muchꞌu junucal chcꞌot ta sba ti chba yacꞌ pom ta yut temploe. Ti cꞌalal itajinique, jaꞌ la icꞌot ta sba ti Zacaríase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ti cꞌalal ch-och yaqꞌuic pom ta yut templo ti paleetique, li yan crixchanoetique tey la tscꞌoponic Riox ta tiꞌ templo. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ti cꞌalal tey chacꞌ pom ta yut templo ti Zacaríase, jaꞌo la ital jun anjel ta vinajel. Tey la vaꞌal iyul ta stsꞌel smexail yav yacꞌlel pom ta stuqꞌuil sbatsꞌicꞌob ti Zacaríase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ti cꞌalal iyil anjel ti Zacaríase, mu xa la snaꞌ cꞌusi tspas, ixiꞌ la tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","―Zacarías, mu xaxiꞌ. Iyichꞌ xa ta mucꞌ ti cꞌusi avalbe li Rioxe. Ta xꞌayan yol lavajnile. Crem ta xꞌayan. Juan xavacꞌbe sbiin. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti cꞌalal xꞌayane, xamuyubajic xa. Ep ti muchꞌutic xmuyubajique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yuꞌun ta xtun tajmec yuꞌun li Rioxe. Muc bu chuchꞌ pasem yaꞌlel uva, muc bu chuchꞌ pox. Ta chꞌutil toꞌox chichꞌ tal Chꞌul Espíritu. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ep achiꞌiltac ta israelal ta xictaic spasel li cꞌusitic chopole ti cꞌalal xꞌalbatic yuꞌun ti Juane, jaꞌ chichꞌic ta mucꞌ li Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jaꞌ baꞌyi chtal ti Juane, jaꞌ tsꞌacal to chtal li Cajvaltique. Ti Juane coꞌol spꞌijil, coꞌol syuꞌel xchiꞌuc ti jꞌalcꞌop Elias ti ta voꞌnee. Jaꞌ chtal yalbe lachiꞌiltaque ti acꞌu yictaic spasel li cꞌusitic chopole yoꞌ scꞌuxubinic o li xchꞌamalic ta jupꞌej nae, yoꞌ xichꞌic o ta mucꞌ li Rioxe, yoꞌ xichꞌic o ta mucꞌ ti cꞌalal xul li Cajvaltique ―xꞌutat la yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","―¿Cꞌuxi ta jnaꞌ mi yech li cꞌusi avalbone? Yuꞌun molon xa, meꞌel xa li cajnil uque ―xut la anjel ti Zacaríase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","―Voꞌon Gabrielon, teon ta stsꞌel xchotleb li Riox ta vinajele. Jaꞌ listac tal. Jaꞌ tal calbot avaꞌi ti ch-ayan jun acreme. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lavi mu xachꞌun ti cꞌusi lacalbee, chapas ta umaꞌ. Jaꞌto chjam ti cꞌalal xꞌayan ti acreme. Ta onox xꞌayan ti cꞌusi ora snopoj li Rioxe ―xꞌutat la ti Zacaríase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti crixchanoetic tey ta tiꞌ temploe, smalaojic la chlocꞌ tal ti Zacaríase. ―¿Cꞌusi van tspas ti yilel mu xlocꞌ tale? ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ti cꞌalal ilocꞌ tale, umaꞌ xa la. Ta scꞌob xa la iyacꞌ iluc ti cꞌusi ispase. Jaꞌ la iyul o ta sjolic ti oy cꞌusi iꞌacꞌbat yil ta yut templo yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ti cꞌalal itsꞌaqui ti jayib cꞌacꞌal chtun ta templo ti Zacaríase, isut la echꞌel ta sna. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ixchiꞌin la yol ti yajnile, jaꞌ ti Elisabete. Ti cꞌalal oy xa la xchꞌute, voꞌob la u tey ta sna. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ti Cajvaltique iyil ti chislaban li crixchanoetique, yechꞌo ti liscꞌuxubine. Mu xa bu xocolon”, xi la isnopilan ti Elisabete. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Svaquibal xaꞌox la u ixchiꞌin yol ti Elisabete, ti Rioxe istac la tal noxtoc ti anjel Gabriele. Tey la icꞌot ta jteclum Nazaret ta estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Cꞌot la scꞌopon jun tojol tseb, María la sbi. Cꞌubanbil xaꞌox la. José la sbi ti vinique. David la sbi ti smucꞌtatot ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","―Voꞌot lastꞌuj li Rioxe. Liꞌ xchiꞌinojote. Muc muchꞌu yan tseb ta xtꞌuje chac cꞌu chaꞌal li voꞌote ―xꞌutat la yuꞌun anjel ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ti cꞌalal iyaꞌi cꞌusi iꞌalbat yuꞌun anjel ti Maríae, mu xa la snaꞌ cꞌuxi chtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","―María, mu xaxiꞌ, chatun yuꞌun li Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chavayantas jun crem. Jesús xavacꞌbe sbiin. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jaꞌ Xchꞌamal Riox ta vinajel. Jaꞌ chtal tunuc yuꞌun Riox liꞌ ta sba balamile. Jaꞌ ch-och ta pasmantal. Jaꞌ chaspasic ta mantal chac cꞌu chaꞌal ispas ta mantal achiꞌiltac ti amucꞌtatot David ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jaꞌ noꞌox ti ta sbatel osil chaspasic ta mantale, voꞌoxuc li jꞌisraeloxuque ―xꞌutat la yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","―¿Cꞌuxi ta jchiꞌin col ti muc bu quiloj vinique? ―xi la ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","―Jaꞌ ta syuꞌel Chꞌul Espíritu ti chachiꞌin avole. Ti avol ch-ayane, chꞌabal smul yuꞌun jaꞌ Xchꞌamal li Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Chcal avaꞌi ti ch-ayan screm lanamtalchiꞌil Elisabete. Acꞌu mi meꞌel xa, acꞌu mi mu snaꞌ xꞌalaj, pero svaquibal xa u ixchiꞌin yol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mu cꞌusi tsots chaꞌi li Rioxe ―xꞌutat la yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","―Lec ti mi yech tscꞌan ti Cajvaltique. Acꞌu spas chac cꞌu chaꞌal avalbone ―xi la ti Maríae. Ti cꞌalal laj yal ti anjele, ibat la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tsꞌacal to ilocꞌ la echꞌel ti Maríae, sujom la ibat ta jun jteclum ta vitstic ta estado Judea. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jaꞌ la tey nacal ti Zacaríase. Tey la icꞌot ti Maríae. ―¿Mi liꞌote, meꞌ? ―xi la cꞌotel. ―Liꞌone ―xi la ti Elisabete. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti Elisabete, ti cꞌalal iyaꞌi ti jaꞌ María ti icꞌopoje, tsots la ibacꞌ ti yole. Ipꞌijubtasat la yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tsots la icꞌopoj: ―Muc muchꞌu yan tseb ta xtꞌuje yuꞌun Riox chac cꞌu chaꞌal li voꞌote. Ta scotol li unetique muc muchꞌu yan lec ch-ile yuꞌun li Rioxe chac cꞌu chaꞌal ti avol voꞌote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mu cꞌusi jtu ti voꞌot tal avulaꞌanon ti smeꞌot Cajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti cꞌalal lacꞌopoje, tsots ibacꞌ li col ta jchꞌute yuꞌun xmuyubaj xa. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lec ti achꞌun ti cꞌusi layalbe ti Cajvaltique yuꞌun chcꞌot onox ti cꞌusi iyale ―xꞌutat la yuꞌun Elisabet ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Itacꞌav la ti Maríae: Coliyal Cajvaltic jun coꞌon tajmec ti chtal stojbon jmule. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Acꞌu mi mu cꞌu jtu chiꞌile pero chitun yuꞌun ti Rioxe. Ti jayqꞌuex crixchanoetic ta to xꞌechꞌic liꞌ ta sba balamile, “Iꞌacꞌbat bentisyon yuꞌun jaꞌ iyayantas ti Cajvaltic Jesucristoe”, xi jcꞌoplal yuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ti Rioxe oy slequilal syuꞌelal. Lec tajmec ti cꞌusi iyul ta jtojole yechꞌo un acꞌu quichꞌtic ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ti mi chichꞌic ta mucꞌ Riox li crixchanoetic ti ch-echꞌic liꞌ ta sba balamile, ta xcꞌuxubinatic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ti Rioxe yacꞌoj iluc ti stuc noꞌox oy syuꞌele. Tspajes ti muchꞌutic ta stoy sbaique, jaꞌ ti muchꞌutic pꞌij ti yalojique, yoꞌ mu spasic o ti cꞌusitic snopoj tspasique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mi jaꞌ yech tspasic li jyuꞌeletique, ta xloqꞌuesatic. Jaꞌ ch-ochic ti muchꞌutic mu snaꞌ stoy sbaique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ti muchꞌutic tscꞌanic lecubtasbel yoꞌonique ta xlecubtasbatic. Yan ti muchꞌutic lec yoꞌonic ti yalojique, jaꞌ mu xlecubtasbatic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Voꞌotic li jꞌisraelotique, chixcꞌuxubinotic onox ti jayvoꞌ quichꞌojtic ta muqꞌue. Mu onox xchꞌay scꞌoplal ti cꞌu xꞌelan iꞌalbatic ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Iꞌalbat onox ti jmucꞌtatotic Abraame ti ta xcꞌuxubinat ta sbatel osil xchiꞌuc voꞌotic li smomotique, xi la ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ti Maríae ixchiꞌin la sbaic ta naclej oxib u xchiꞌuc ti Elisabete. Ti cꞌalal ilocꞌ oxib ue, isut la ta sna. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ti cꞌalal ista yual icol ti Elisabete, crem la iꞌayan ti yole. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ti xchiꞌiltac Elisabete xchiꞌuc ti slacꞌnataque, iyaꞌiic la ti icꞌuxubinat yuꞌun ti Rioxe, ti iꞌayan xa yole. Xmuyubajic xa la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ti cꞌalal ista vaxaquib cꞌacꞌal yayanel ti unene, iyacꞌbeic la yichꞌ circuncisión. Ti xchiꞌiltaque isnopic la ti jaꞌ ta xichꞌbe sbi ti stote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","―Maꞌuc chichꞌbe sbi li stote. Juan chcacꞌbeticotic sbiin ―xi la ti smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","―¿Cꞌu yuꞌun ti Juan chavacꞌbeic sbiine? Yuꞌun muc muchꞌu yech sbi junuc cuꞌuntic liꞌtoe ―xꞌutat la yuꞌun ti xchiꞌiltaque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Isjacꞌbeic la ti stot unene. Iyacꞌbeic la seña ta scꞌobic ti acꞌu yal cꞌusi sbi chacꞌbe ti screme. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ti Zacaríase iscꞌan la jpech cꞌox tabla, istsꞌiba la: “Juan chcacꞌbe sbiin”, xi la. Xchꞌayet xa la yoꞌon scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jaꞌo la ijam ye ti Zacaríase, lic la cꞌopojuc. ―Colaval ti acꞌuxubinoticotique ―xut la ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ixiꞌ la tajmec scotol ti slacꞌnataque. Ti muchꞌutic tey nacajtic ta vitstic ta estado Judeae, iyaꞌi la scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ti muchꞌutic iyaꞌie “¿Cꞌusi van yabtel li crem taje?” xi la isnopilanic. Ti creme chabibil la yuꞌun ti Cajvaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ti Zacaríase, jaꞌ ti stot unene, ichꞌamunbat la ye yuꞌun ti Chꞌul Espíritue, iyal la ti cꞌusi poꞌot xa xcꞌote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","Coliyalbotic ti Rioxe, jaꞌ ti Cajvaltic, voꞌotic li jꞌisraelotique, chistacbotic tal Jtojmulil, voꞌotic ti stꞌujojotic onoxe. Oy slequilal syuꞌelal. Jaꞌ smom ti Davide ti lec tajmec itun yuꞌun Riox ti voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ti Rioxe ixchꞌamunbe ye ti yajꞌalcꞌoptac ti voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iyalic onox ti ta xcꞌot yora ti mu xa bu chispasotic ta mantal li muchꞌutic chiscrontainotique, ti scꞌacꞌalotic yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chixcꞌuxubinotic onox chac cꞌu chaꞌal iꞌalbatic ti voꞌne moletique. Yechꞌo un chquiltic ti mu onox xchꞌay xaꞌi ti cꞌusi iyalbe ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Jaꞌ jcꞌoplaltic ti iꞌalbat ti jmucꞌtatotic Abraame ti ta onox xcꞌot yora ti mu xa bu chispasotic ta mantal li jcrontatique, yoꞌ mu xa cꞌusi xixiꞌotic o ta yichꞌel ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Yechꞌo un jun coꞌontic chquichꞌtic ta mucꞌ ti cꞌu sjalil cuxulotic liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Li voꞌote, crem, ti cꞌalal xachꞌie, voꞌot yajꞌalcꞌopot ti Riox ta vinajele. Yuꞌun voꞌot baꞌyi chavalbe scꞌoplal ti Cajvaltique, jaꞌ tsꞌacal to chtal ti stuque. Voꞌot baꞌyi chlic avalbe li jchiꞌiltactique ti acꞌu yictaic spasel li cꞌusitic chopole, ti acꞌu yichꞌic ta mucꞌ ti Cajvaltic cꞌalal xule. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Voꞌotic ti stꞌujojotic onoxe, voꞌot chavalbe li jchiꞌiltactique ti ch-aqꞌueic ta pertonal yuꞌun ti Rioxe ti mi ta xchꞌunic ti jaꞌ tstoj jmultic ti Cajvaltique. Ti mi ixchꞌunique, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ti Jtotic Rioxe ta slequil noꞌox yoꞌon ti chixcꞌuxubinotique, ti chistacbotic xa tale. Lec ti liꞌ chul ta jlumaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jaꞌ tstoj jmultic yoꞌ ti lec xiyilotic o ti Rioxe. Jaꞌ ta xchꞌaybe scꞌoplal ti chiꞌochotic ta cꞌocꞌ ta sbatel osile, xi la ti Zacaríase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tsots la yoꞌon ichꞌi ti creme. Stuc la ba nacluc ta xocol balamil. Ti cꞌalal ista yora isvinajesbe scꞌoplal ti Cajvaltique, li xchiꞌiltac ta israelale tey la istsob sbaic echꞌel, ba la yaꞌiic cꞌusi chal ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti preserente Augusto Césare jaꞌo la scuentainoj sjunlej balamil ti cꞌalal iꞌayan ti Juane. Isloqꞌues la mantal ti acꞌu ba yacꞌ ta tsaquel sbiic scotol ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jaꞌo la isliquesic yech ti cꞌalal tiqꞌuil ta coviernoal ta estado Siria ti Cirenioe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yechꞌo la ti ba yacꞌ ta tsaquel sbiic scotol ti crixchanoetic ta jujun slumale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ti Josee ilocꞌ la ta jteclum Nazaret ta estado Galilea, ibat la ta estado Judea. Icꞌot la ta jteclum Belén yuꞌun la jaꞌ tey ayanem ti smucꞌtatot ti ta voꞌnee, jaꞌ la ti Davide. Jaꞌ la slumal ti Jose uque, yechꞌo la ti tey ba yacꞌ ta tsaquel sbiic ta Belén xchiꞌuc ti yajnile, jaꞌ ti Maríae. Pero mu toꞌox la bu chcol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ti cꞌalal teyic ta Belene, jaꞌo la icol ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Noj xa la istaic ti otele. Na vacax xa la iꞌacꞌbat xchꞌamunic. Tey la iꞌayan ti sba yole. Isvol la ta pocꞌ, ispuchꞌan la ta yav sveꞌel vacax ti unen creme. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ta tiꞌ Belene oy la tey jayvoꞌ jchabichijetic ta acꞌubaltic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jaꞌ la tey istac tal jun anjel ti Cajvaltique. Ti Cajvaltique xlebluj la yulel xojobal yoꞌ bu ti jchabichijetique. Ti cꞌalal iyilique, ixiꞌic la tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","―Mu xaxiꞌic. Yuꞌun oy cꞌusi lec chacalbeic yoꞌ jun o avoꞌon acotolic voꞌoxuc li jꞌisraeloxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nax iꞌayan ta Belén li muchꞌu ta stoj amulique. Jaꞌ stꞌujoj Riox ti chaspasic ta mantale. Jaꞌ Cajvaltic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chacalbeic cꞌu xꞌelan chataic li unene. Volbil ta pocꞌ, tey puchꞌanbil ta yav sveꞌel vacax ―xꞌutatic la yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jaꞌo la ivinaj epal anjeletic ta vinajel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Lec tajmec yoꞌon li Riox ta vinajele! Chcꞌuxubin li crixchanoetique yoꞌ spas o ta jun yoꞌonique, xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ti cꞌalal isut ta vinajel ti anjeletique ―Batic ta Belén cheꞌe. Ba jqꞌueltic cꞌusi icꞌot chac cꞌu chaꞌal liyalbotic ti Cajvaltique ―xut la sbaic ti jchabichijetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sujom la ibatic. Ti cꞌalal icꞌotique, tey la istaic ti Maríae xchiꞌuc ti Josee. Ti unene tey la puchꞌul ta yav sveꞌel vacax istaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ti cꞌalal laj sqꞌuelic ti unene, isvinajesbeic la scꞌoplal. Iyalic la noxtoc ti cꞌusi iꞌalbatic yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ti muchꞌutic iyaꞌi ti cꞌusi iyal ti jchabichijetique, xchꞌayet xa la yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ti Maríae muc la xchꞌay xaꞌi ti cꞌusitic iyal ti jchabichijetique, isnopilan la cꞌusi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ti cꞌalal isutic ti jchabichijetique, “Coliyalbotic Riox”, xiic la echꞌel, yuꞌun iyaꞌiic xa, iyilic xa ti cꞌusi iꞌalbatic yuꞌun ti anjel ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ti cꞌalal ilaj vaxaquib cꞌacꞌal yayanel ti unen creme, iyichꞌ la circuncisión. Jesús la iyacꞌbeic sbiin yuꞌun la jaꞌ yech iyal ti anjele ti cꞌalal chꞌabal toꞌox ta chꞌutile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Stsꞌibaoj onox ti Moisese ti cꞌu sjalil mu xuꞌ xbatic ta templo ti cꞌalal chcolic ti yajnilique. Ti cꞌalal itsꞌaqui yuꞌun ti Maríae, ibat la ta mucꞌta templo ta Jerusalén xchiꞌuc ti Josee, yuꞌun la ba yalbeic ti Rioxe ti jaꞌ yuꞌun ti scꞌoxcremique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yuꞌun jaꞌ onox yech yaloj mantal ti Rioxe ti tsꞌibabil comele: “Scotol li sba achꞌamalique, mi creme, jaꞌ cuꞌun”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iyacꞌbeic la smoton Riox noxtoc yuꞌun jaꞌ onox yech yaloj mantal ti Rioxe: “Mi chꞌabal xchije, acꞌu sqꞌuelanbon chaꞌcotuc toltora, o mi chaꞌcotuc paloma”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oy toꞌox la jun jꞌisrael tey ta Jerusalene, Simeón la sbi. Lec la yoꞌon, yichꞌoj la ta mucꞌ ti Rioxe. Smalaoj la chtal ti muchꞌu chloqꞌuesatic o ta scꞌob ti preserente ta Romae. Ti Simeone chiꞌinbil xa ono la yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Albil xa la yuꞌun ti Chꞌul Espíritue ti jaꞌto la ta xcham cꞌalal xilbe sat ti Cristoe ti stꞌujoj Riox ch-och ta pasmantale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ti Simeone iꞌalbat la yuꞌun ti Chꞌul Espíritue ti acꞌu la batuc ta mucꞌta temploe. Jaꞌo la ibatic ta templo ti Josee, xchiꞌuc ti Maríae, xchiꞌuc ti unene, yuꞌun la ba spasic chac cꞌu chaꞌal chal li mantale. Tey la cꞌot staic ta tiꞌ templo ti Simeone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ti Simeone ispet la ti unene, “colaval”, xut la ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Cajval, lavi iquil xa ti cꞌusi avalbone, jun coꞌon chicham, voꞌon ti chitun avuꞌune. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Yuꞌun iquil xa li muchꞌu atac tal stoj jmulticotique ti jaylajuntosoticotic liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Li namal crixchanoetique jaꞌ luz chcꞌot yuꞌunic yaꞌel yuꞌun chilic ti xuꞌ chcuxiic ta sbatel osil uque. Liꞌ iyul ta jlumalticotic li muchꞌu ta stoj li jmulticotique. Jaꞌ chvinaj o ti atꞌujojoticotique, ti acꞌanojoticotique, xi la ti Simeone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ti Josee xchiꞌuc ti smeꞌ unene xchꞌayet xa la yoꞌonic ti oy scꞌoplal ti unene. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","―Acꞌu yacꞌboxuc bentisyon ti Rioxe ―xꞌutatic la yuꞌun ti Simeone. ―Lavole jaꞌ chvinaj o cꞌu xꞌelan yoꞌon li jchiꞌiltactic ta israelale. Chcrontainat tajmec, mu xcꞌane tajmec yuꞌun jlom li jchiꞌiltactique. Chlic avat o avoꞌon ti mu xcꞌanee. Pero oy jlom jchiꞌiltactic ti chlecub o yoꞌonique ―xꞌutat la yuꞌun Simeón ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jaꞌo la tey ta tiꞌ templo jun jꞌisraelal ants, Ana la sbi. Yajꞌalcꞌop Riox la. Fanuel la sbi ti ánima stote. Jaꞌ la smucꞌtatot ti Aser ti ta más voꞌnee. Meꞌel xa la ti Anae. Vucub noꞌox la jabil oy smalal yuꞌun la icham ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Oy xa la ochenta y cuatro sjabilal ti meꞌanal antse. Scotol la cꞌacꞌal chcꞌotilan ta tiꞌ templo. Tey la chba scꞌopon Riox, chicta la yot baqꞌuintic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti Simeone jaꞌo la yolel chal ti cꞌusi tal spas ti unene ti cꞌalal tey icꞌot ti Anae. Ti Anae “colaval ti ital xa li muchꞌu ta stoj li jmulticotique”, xut la ti Riox uque. Tsꞌacal to la isvinajesbe scꞌoplal ti unene. Iyalbe la scotol li xchiꞌiltac ta Jerusalene, jaꞌ ti muchꞌutic smalaojic ti chtal ti muchꞌu ta stoj li jmultique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ti Josee xchiꞌuc ti Maríae, ti cꞌalal laj spasic scotol ti cꞌusitic yaloj ti Rioxe, isutic la ta steclumalic ta Nazaret ta estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lec la ichꞌi ti Jesuse. Pꞌij la tajmec. Acꞌbil la bentisyon yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ti stot smeꞌ ti Jesuse chcꞌotic onox la jujun jabil ta Jerusalén ta qꞌuin, jaꞌ la sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi stot smeꞌic li jꞌisraeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ti cꞌalal oy xaꞌox la lajcheb sjabilal ti Jesuse, ibat la ta qꞌuin uc yuꞌun la jaꞌo xa yech sjabilalic chlic baticuc ta qꞌuin li cremotique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ti cꞌalal ilaj ti qꞌuine, isutic la ta snaic ti Josee xchiꞌuc ti Maríae. Ti scremique tey la icom ta Jerusalén. Muc la xilic bu icom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Isnopic la ti xchiꞌuc echꞌel ti xchiꞌiltaque. Ti cꞌalal ixanavic xaꞌox jun cꞌacꞌale, isjacꞌbeic la ti xchiꞌiltaque xchiꞌuc ti muchꞌutic xojtiquinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero mu la bu istaic. Ichaꞌsutic la ta Jerusalén. Ti cꞌalal icꞌotique, cꞌot la saꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta yoxibal to la cꞌacꞌal istaic ta yut jpꞌej na ti tsacal xchiꞌuc mucꞌta temploe. Tey la chotol ta oꞌlol yoꞌ bu stsoboj sbaic ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Tey la chaꞌi cꞌusi chalic li jchanubtasvanejetic yilele. Oy la cꞌusi tsjacꞌulan ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Li jchanubtasvanejetique xchꞌayet xa la yoꞌonic ti naca lec smelol cꞌusi isjacꞌ ti Jesuse, xchiꞌuc ti cꞌu xꞌelan itacꞌave. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ti Josee xchiꞌuc ti Maríae, ti cꞌalal iyilic ti tey xchiꞌuc jchanubtasvanejetic ti scremique, xchꞌayet xa la yoꞌonic uc. ―Crem, ¿cꞌu yuꞌun ti xꞌelan chapase? Lajsaꞌticotic xa tajmec. Icat coꞌonticotic ti muc bu lajtaticotic ta saꞌele ―xi la ti smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","―¿Cꞌu yuꞌun ti chasaꞌicone? ¿Mi mu xanaꞌic ti liꞌon ta sna li Jtote? ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ti Josee xchiꞌuc ti Maríae muc la xaꞌibeic smelol cꞌusi iyal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsobol xa la isut xchiꞌuquic ta Nazaret ti Jesuse. Ti cꞌu sjalil tey tsobol xchiꞌuquique, lec la ixchꞌun mantal. Ti smeꞌe muc la xchꞌay xaꞌi ti cꞌu xꞌelan itacꞌav cꞌalal tey ta temploe, xchiꞌuc ti lec ixchꞌun mantal cꞌalal tey ta snae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ichꞌi la ti Jesuse, cꞌuncꞌun la iyul xchꞌulel. Cꞌuncꞌun la ivinaj ti lec iꞌile yuꞌun ti Rioxe, ti lec iꞌile yuꞌun ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ti Tiberio Césare svoꞌlajunebal xaꞌox la jabil yochel ta preserenteal ta Roma ti cꞌalal lic yal aꞌyuc scꞌoplal Cajvaltic Jesús ti Juane. Jaꞌo la ochem ta coviernoal ta estado Judea ti Poncio Pilatoe. Jaꞌo la ochem ta coviernoal ta estado Galilea ti Erodese. Jaꞌo la ochem ta coviernoal ta estado Iturea xchiꞌuc ta estado Traconite ti yitsꞌin Erodese ti Felipe sbie. Jaꞌo la ochem ta coviernoal ta estado Abilinia ti Lisániase. Jaꞌo la ochemic ta totil paleal yuꞌun jꞌisraeletic ti Anase xchiꞌuc ti Caifase. Jaꞌo la tey ta xocol balamil ti Juane, ti screm Zacaríase. Jaꞌo la iꞌalbat yuꞌun Riox ti chal aꞌyuc scꞌoplal ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ti Juane tey la iꞌechꞌ ta tsꞌel ucꞌum Jordán. ―Ictaic xa spasel li cꞌusitic chopole, ichꞌic voꞌ yoꞌ xayaqꞌuic o ta pertonal ti Rioxe ―xiulan la echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ti Isaíase ti yajꞌalcꞌop Riox ti ta voꞌnee, stsꞌibaojbe onox scꞌoplal ti Juane. Jaꞌ yech istsꞌiba chac liꞌi: Ta to xtal jun jchiꞌiltic ta israelal. Tsots ch-avetaj ta xocol balamil: “Chtal xa ti Cajvaltique. Ictaic xa spasel li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Xachꞌunbeic me ti cꞌusitic chayalbeique yoꞌ lec xabatic oe. Jaꞌ ta slecubtas coꞌontic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jaꞌ tstoj jmultic jcotoltic yuꞌun jaꞌ chtaque tal yuꞌun ti Rioxe”, xi chalbe ti jchiꞌiltactique, xi onox ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ep la tajmec ti muchꞌutic cꞌot scꞌanic ichꞌvoꞌe. ―Li voꞌoxuque jaꞌ achiꞌilic li quiletel chone. Ti cꞌalal chaꞌi ti chtal cꞌocꞌ li chone, chjatav. Jaꞌ yechoxuc uc. ¿Miꞌn avaꞌiic xa yaꞌel ti chavichꞌic castico ti tal acꞌanic ta ora li ichꞌvoꞌe? ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mi chavichꞌic voꞌe, jaꞌ tscꞌan ti jꞌechꞌel xavictaic spasel li cꞌusitic chopole. Mu me xanopic yech chac liꞌi: “Jaꞌ jmucꞌtatoticotic ti Abraame, yechꞌo un chicuxioticotic onox ta sbatel osil uc”, mu me xachiic. Chacalbeic, ti Rioxe xuꞌ tscꞌatajes ta smom Abraam li tonetic liꞌi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Li voꞌoxuque coꞌoloxuc xchiꞌuc teꞌel loꞌbol ti chopol ta loꞌbel sate. Tombil xa yeqꞌuelal ta yoc yuꞌun chboje loqꞌuel scotol. Chichꞌ chiqꞌuel ―xꞌutatic la yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","―¿Cꞌusi ma tscꞌan ta jpasticotic un cheꞌe? ―xutic la ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","―Mi oy chaꞌlic acꞌuꞌe, qꞌuelanbo jlicuc li muchꞌu chꞌabal scꞌuꞌe. Mi oy aveꞌele, qꞌuelanbo li muchꞌu chꞌabal sveꞌele ―xꞌutatic la yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Icꞌotic la jayvoꞌ jcꞌan-locꞌ-cꞌusiticuc yuꞌun la yoꞌonuc yichꞌic voꞌ uc. ―Jchanubtasvanej, li voꞌoticotique ¿cꞌusi tscꞌan ta jpasticotic uc? ―xutic la ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","―Mu me xacꞌanbeic más li slocꞌ cꞌusiticuque. Jaꞌ noꞌox yech yepal xacꞌanic ti cꞌu chaꞌal avichꞌojic mantale ―xꞌutatic la yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tey la jayvoꞌ solteroetic noxtoc. ―Ali voꞌoticotique ¿cꞌusi tscꞌan ta jpasticotic uc? ―xutic la ti Juane. ―Mu me muchꞌu xasibtasic, mu me xasaꞌic mulil yoꞌ xatsacvanic oe, yoꞌ xacꞌanic o taqꞌuine. Junuc o avoꞌonic ti cꞌu yepal chatojatique ―xꞌutatic la yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ti crixchanoetique smala smalaic la chul ti muchꞌu stꞌujoj Riox chtal pasvanuc ta mantale. Ti cꞌalal iyilic ti muc bu chule ―Jaꞌ nan stuc li Juane ti chtal chale ―xiic xa la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","―Li voꞌone jaꞌ noꞌox chacacꞌbeic ichꞌvoꞌ. Yan ti muchꞌu tsꞌacal to chtale, más oy syuꞌel. Li voꞌone mi jaꞌuc yaqꞌuil xonob, mu xjituj cuꞌun yuꞌun mu cꞌu xitun o. Jaꞌ chayacꞌbe achiꞌinic ti Chꞌul Espíritue ti coꞌol xchiꞌuc cꞌoqꞌue yuꞌun jaꞌ tsloqꞌues o li cꞌusitic chopol ta avoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ti muchꞌutic tscꞌanic loqꞌuesbel li cꞌusitic chopol ta yoꞌonique, jaꞌ chbatic ta vinajel. Yan ti muchꞌutic mu scꞌanic loqꞌuesbele, jaꞌ ch-ochic ta cꞌocꞌ ta sbatel osil. Coꞌol xchiꞌuc ti muchꞌu ta sjicꞌa strigoe. Ti cꞌalal xlaj sjicꞌae, ta xchꞌol ta stenal. Li yoctaque ta xchicꞌ ―xꞌutatic la yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ti Juane oy to la ep cꞌusitic lec iyalbe li xchiꞌiltac ta israelale. Jaꞌ la iyalbe ti liꞌ xa ti muchꞌu scꞌoplal chtal pasvanuc ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ti covierno Erodese iyalbe la ti cꞌusitic chopol tspase. Iyalbe la ti chopol ti ispojbe yajnil ti yitsꞌine. Ti antse Erodías la sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero muc la xchꞌun ti Erodese. Más to la stoyel iyaꞌi, isticꞌ o la ta chuquel ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ti cꞌalal yolel chacꞌ ichꞌvoꞌ ti Juane, jaꞌo la tey icꞌot ti Jesuse, iyichꞌ la voꞌ uc. Iscꞌopon la Riox. Ti cꞌalal yolel tscꞌopon Rioxe, ijam la li vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iyal la tal ta sba ti Chꞌul Espíritue, coꞌol la xchiꞌuc paloma yilel. Jaꞌo la ichiꞌine yuꞌun ti Chꞌul Espíritue. Ti Rioxe icꞌopoj la tal ta vinajel: ―Voꞌot Jchꞌamalot. Jcꞌanojot tajmec. Jun coꞌon avuꞌun ―xꞌutat la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ti Jesuse oy xa nan treinta sjabilal ti cꞌalal lic yal aꞌyuc li scꞌop Rioxe. Ti crixchanoetique iyalic la ti jaꞌ screm ti Josee pero maꞌuc. Ti Jesuse jaꞌ smom ti Elie ti stot Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ti stot Elie Matat sbi. Ti stot Matate Leví sbi. Ti stot Levie Melquí sbi. Ti stot Melquie Jana sbi. Ti stot Janae José sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ti stot Josee Matatías sbi. Ti stot Matatíase Amós sbi. Ti stot Amose Naum sbi. Ti stot Naume Esli sbi. Ti stot Eslie Nagai sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ti stot Nagaie Maat sbi. Ti stot Maate Matatías sbi. Ti stot Matatíase Semei sbi. Ti stot Semeie José sbi. Ti stot Josee Judá sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ti stot Judae Joana sbi. Ti stot Joanae Resa sbi. Ti stot Resae Zorobabel sbi. Ti stot Zorobabele Salatiel sbi. Ti stot Salatiele Neri sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ti stot Nerie Melquí sbi. Ti stot Melquie Adi sbi. Ti stot Adie Cosam sbi. Ti stot Cosame Elmodam sbi. Ti stot Elmodame Er sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ti stot Ere Josué sbi. Ti stot Josuee Eliezer sbi. Ti stot Eliezere Jorim sbi. Ti stot Jorime Matat sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ti stot Matate Leví sbi. Ti stot Levie Simeón sbi. Ti stot Simeone Judá sbi. Ti stot Judae José sbi. Ti stot Josee Jonán sbi. Ti stot Jonane Eliaquim sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ti stot Eliaquime Melea sbi. Ti stot Meleae Mainán sbi. Ti stot Mainane Matata sbi. Ti stot Matatae Natán sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ti stot Natane David sbi. Ti stot Davide Isaí sbi. Ti stot Isaie Obed sbi. Ti stot Obede Booz sbi. Ti stot Booze Salmón sbi. Ti stot Salmone Naasón sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ti stot Naasone Aminadav sbi. Ti stot Aminadave Aram sbi. Ti stot Arame Esrom sbi. Ti stot Esrome Fares sbi. Ti stot Farese Judá sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ti stot Judae Jacov sbi. Ti stot Jacove Isaac sbi. Ti stot Isaaque Abraam sbi. Ti stot Abraame Taré sbi. Ti stot Taree Nacor sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ti stot Nacore Serug sbi. Ti stot Serugue Ragau sbi. Ti stot Ragaue Peleg sbi. Ti stot Pelegue Eber. Ti stot Ebere Sala sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ti stot Salae Cainán sbi. Ti stot Cainane Arfajad sbi. Ti stot Arfajade Sem sbi. Ti stot Seme Noé sbi. Ti stot Noee Lamec sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ti stot Lameque Matusalén sbi. Ti stot Matusalene Enoc sbi. Ti stot Enoque Jared sbi. Ti stot Jarede Malaleel sbi. Ti stot Malaleele Cainán sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ti stot Cainane Enós sbi. Ti stot Enose Set sbi. Ti stot Sete Adán sbi. Ti stot Adane jaꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ti Jesuse chiꞌinbil xa la loqꞌuel yuꞌun ti Chꞌul Espíritue ti cꞌalal ilocꞌ ta ucꞌum Jordane. Iyulesbat la ta sjol ti chbat ta xocol balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaꞌvinic la cꞌacꞌal tey iꞌilbajinat ta xocol balamil yuꞌun ti pucuje. Muc la xveꞌ pero muc la xviꞌnaj. Tsꞌacal to la iviꞌnaj. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","―Ti mi yech ti voꞌot Xchꞌamalot li Rioxe, alboquic li ton liꞌi acꞌu cꞌatajuc ta pan ―xꞌutat la yuꞌun ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","―Tsꞌibabil ta scꞌop Riox ti mu ta panuc noꞌox chicuxioticotique. Jaꞌ tscꞌan ta jchꞌunbeticotic noxtoc li cꞌusitic chiyalboticotic ti Rioxe ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ti pucuje iyicꞌ la muyel ta jpꞌej toyol vits ti Jesuse. Ora la iyacꞌbe yil sjunlej balamil ta syuꞌel xchiꞌuc ti cꞌu xꞌelan tspasic mantal li jyuꞌeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","―Chacacꞌbe acuentain sjunlej li balamile yoꞌ xayichꞌ o ta mucꞌ scotol li crixchanoetique. Yuꞌun voꞌon jcuentainoj, yechꞌo un xuꞌ chcacꞌbe ti muchꞌu scꞌan coꞌon chcacꞌbee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ti mi chaquejletaone, mi chavichꞌon ta muqꞌue, chacacꞌbe acuentain sjunlej ―xꞌutat la yuꞌun ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","―Batan, Satanás. Mu jchꞌun li cꞌusi chavalbone. Tsꞌibabil ta scꞌop Riox ti stuc noꞌox chquichꞌticotic ta mucꞌ ti Rioxe, ti jaꞌ ta jpasticotic ti cꞌusi tscꞌane ―xꞌutat la yuꞌun Jesús ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ti pucuje iyicꞌ la echꞌel ta Jerusalén ti Jesuse. Isvaꞌan la ta jol templo. Ti cꞌalal tey xaꞌox la vaꞌajtic ta jol temploe, ―Ti mi yech ti voꞌot Xchꞌamalot li Rioxe, jip aba yalel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tsꞌibabil ta scꞌop Riox ti “chastacbe tal anjeletic ti Rioxe yoꞌ mu cꞌu xapas oe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jaꞌ stsacoj chacꞌot yoꞌ mu xayayij o ta tone”, xi tsꞌibabil ―xꞌutat la yuꞌun pucuj ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","―Tsꞌibabil noxtoc ta scꞌop Riox ti mu xuꞌ jqꞌuelbeticotic yoꞌon ti Rioxe ―xꞌutat la yuꞌun Jesús ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ti cꞌalal iyil ti pucuje ti mu cꞌusi xchꞌun jtosuc ti Jesuse, iyicta la jayib cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ti Jesuse isut la echꞌel ta Galilea. Spas la yuꞌun scotol ta syuꞌel ti Chꞌul Espíritue. Ivinaj la scꞌoplal ta sjunlej estado Galilea xchiꞌuc ti butic nopol xile, ti naca lec li cꞌusitic tspase xchiꞌuc li cꞌusitic chale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ichanubtasvan la ta bicꞌtal temploetic yuꞌun li xchiꞌiltac ta israelale. ―Toj lec ta xchanubtasvan li jchiꞌiltic leꞌe ―xiic la ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ti Jesuse ilocꞌ la teyoꞌe, ibat la ta steclumal ta Nazaret. Ti cꞌalal icꞌot scꞌacꞌalil ta xcuxic li jꞌisraeletique, ibat la ta templo teyoꞌe yuꞌun la nopem onox xaꞌi ti chcꞌotilane. Ivaꞌi la, yuꞌun la jaꞌ tscꞌan chapta li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Iꞌacꞌbat la li balbil vun ti stsꞌibaoj comel ti Isaiase ti yajꞌalcꞌop Rioxe. Ti cꞌalal isjilchꞌun li vune, jaꞌ la ista yoꞌ bu chal chac liꞌi: ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Li voꞌone liꞌ xa xchiꞌinojon ti Chꞌul Espíritue ti jun xchiꞌuc ti Rioxe. Stꞌujojon ti Rioxe ti voꞌon chcalbe li muchꞌutic abol sbaic ta mulile ti xuꞌ chcacꞌ cuxlicuc ta sbatel osile. Yuꞌun coꞌol xchiꞌuc jchuqueletic ti tscꞌanic loqꞌuesele. Coꞌol xchiꞌuc maꞌsatetic ti tscꞌanic jambel satique. Coꞌol xchiꞌuc mozoiletic ti tscꞌanic loqꞌuesele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ti Rioxe listac tal ta yalel aꞌyuc ti ista xa yora chacꞌ iluc ti cꞌanvaneme, xi la tsꞌibabil ti yoꞌ bu iyapta ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ti cꞌalal ilaje, isbal la li vune, jaꞌ la iyacꞌbe ti muchꞌu tey chtun ta temploe. Ichoti la. Li muchꞌutic teye isqꞌuelic la tajmec ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","―Lavie icꞌot xa li cꞌusi tsꞌibabil ta scꞌop Riox ti avaꞌiique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lec la iyaꞌi scotolic ti cꞌusitic iyal ti Jesuse. Xchꞌayet o xa la yoꞌonic ti lec ti cꞌusitic iyale. ―¡Pero jaꞌ screm ti Josee! ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","―Oy muchꞌutic jaꞌ yech chalic: “Mi yech chaval ti jpoxtavanejote, poxtao aba atuc. Ti mi lecot xae, jaꞌto yech ta jchꞌunticotic o ti jpoxtavanejote”, xiic. Jaꞌ noꞌox yech avoꞌonicuc avalbecon: “Paso liꞌ ta jteclumaltic chac cꞌu chaꞌal apas ta Capernaume. Ti mi apase, jaꞌto yech ta jchꞌunticotic o ti oy ayuꞌele”, avoꞌonicuc avuticon uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","’Ta melel chacalbeic, ti muchꞌutic chalic aꞌyuc li scꞌop Rioxe, mi chbatic ta yan o jteclume, ch-ichꞌbatic ta mucꞌ. Yan ta steclumal stuquique mu xꞌichꞌbatic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ta melel chacalbeic, ti cꞌalal liꞌ toꞌox ta sba balamil ti Elías yajꞌalcꞌop Rioxe, oy ep meꞌanal antsetic liꞌ ta jlumaltique. Oxib jabil xchiꞌuc oꞌlol muc xacꞌ voꞌ. Tsots iꞌechꞌ viꞌnal ta sjunlej jlumaltic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ti Elíase muc xtaque echꞌel ta sna meꞌanal antsetic liꞌ ta jlumaltique. Tey itaque echꞌel ta sna jun meꞌanal ants ti maꞌuc jchiꞌiltique, tey nacal ta jteclum Sarepta. Nopol xil sba xchiꞌuc jteclum Sidón. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jaꞌ noꞌox yech cꞌalal cuxul toꞌox ti Eliseo yajꞌalcꞌop Rioxe, ep jchiꞌiltactic ip ta lepra, pero mi jun muc xetꞌesbe ti xchamele. Jaꞌ noꞌox iyetꞌesbe xchamel ti Naamane ti liquem tal ta Siriae ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ti cꞌalal iyaꞌiic ti muchꞌutic tey tsobol ta temploe, icapic o la tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Istsaquic la loqꞌuel ta jteclum ti Jesuse, iyiqꞌuic la muyel ta jolvits yuꞌun la tsjipic ox ta chꞌen. Li jteclume tey noꞌox ta chꞌut vits. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ti Jesuse xcaquet xa la jelavel ta oꞌlol crixchanoetic, ibat la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ti Jesuse ibat la ta jteclum Capernaum ta estado Galilea. Ta scꞌacꞌalil ta xcuxic li jꞌisraeletique, iꞌoch la ta templo teyoꞌe, ichanubtasvan la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ti muchꞌutic teye xchꞌayet xa la yoꞌonic ti cꞌu xꞌelan ichanubtasvane. Yuꞌun la lec snaꞌ ti cꞌusitic tscꞌan ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tey la jun jꞌisrael ta templo, ochem la pucujetic ta yoꞌon. Iꞌavan la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿Cꞌusi acuentaoticotic o, Jesús Nazaret? ¿Miꞌn tal atacoticotic echꞌel yoꞌ bu chba quichꞌticotic casticoe? Jnaꞌoj muchꞌuot. Voꞌot Xchꞌamalot ti Rioxe, voꞌot ti chꞌabal amule ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ti Jesuse ispajes la ti pucujetique ti xchꞌamunojbe ye ti vinique. ―Anchanic, locꞌanic ta yoꞌon li vinique ―xut la. Ti cꞌalal ilocꞌ ta yoꞌon ti vinique, ijipe la comel ta lum yuꞌun ti pucujetique, pero muc la xyayij. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Xchꞌayet xa la yoꞌonic ti crixchanoetique: ―¿Muchꞌu onox leꞌe ti oy syuꞌele, ti ta xchꞌunbat smantal yuꞌun ti pucujetique? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ti xꞌelan ispas ti Jesuse, ora la ivinaj ta scotol jteclumetic xchiꞌuc ta scotol parajeletic ti tey noꞌox ta stsꞌel Capernaume. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ti cꞌalal ilocꞌ ta templo ti Jesuse, ibat la ta sna Simón. Ti sniꞌmeꞌel Simone tilem la tajmec. ―Abulajan qꞌuelbon li jniꞌmeꞌele ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ti Jesuse inopoj la echꞌel yoꞌ bu puchꞌul ti jmemeꞌtique, iyal la ti acꞌu tupꞌuc scꞌacꞌale. Ora la itupꞌ, lic la macꞌlinvanuc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ti cꞌalal ichꞌay cꞌacꞌale, li muchꞌutic oy yajchamele tey la yicꞌojbeic cꞌotel ti Jesuse, cꞌusuc no la chamelal chaꞌiic. Ti Jesuse xcholet la iyacꞌ scꞌob ta sba ti jchameletique, icol la scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ep la noxtoc ti muchꞌutic iloqꞌuesbat pucuj ta yoꞌonique. Ti cꞌalal ilocꞌ ti pucujetique, iꞌavanic la. ―Voꞌot Xchꞌamalot ti Rioxe ―xiic la. Yechꞌo un ti pucujetique muc la xꞌaqꞌue cꞌopojicuc más yuꞌun ti Jesuse, yuꞌun la snaꞌojic ti jaꞌ stꞌujoj Riox ti tspasvan ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ti cꞌalal isacub ta yocꞌomale, ilocꞌ la ta jteclum ti Jesuse, ibat la yoꞌ bu chꞌabal crixchanoe. Ti crixchanoetique isaꞌic la tajmec. Cꞌalal istaique, yoꞌonicuc la spajesic, mu la xaqꞌuic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","―Persa chba calbe yaꞌiic li jchiꞌiltactic ta yantic jteclume ti chlic xa pasvanuc ta mantal ti Rioxe. Yuꞌun jaꞌ tacbilon o tal ti chcal aꞌyuque ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ti Jesuse xcholet la iyal ta bicꞌtal temploetic ta estado Galilea ti chlic xa pasvanuc ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ti Jesuse tey la icꞌot ta tiꞌnab Genesaret tey noꞌox ta estado Galilea. Ep la istsob sba crixchano yoꞌ bu ti Jesuse. Snetꞌnetꞌ xa la sbaic echꞌel yuꞌun la tscꞌan chaꞌiic ti cꞌusitic chal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ti Jesuse tey la iyil chaꞌcot xocol canova ta stsꞌel tiꞌnab. Li yajvaltaque tey la ta xchucꞌ snutiꞌic ta tiꞌnab yuꞌun la tsacchoy yabtelic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ti Jesuse iꞌoch la ta jcot canova, jaꞌ la scanova li Simone. ―Xanubtaso loqꞌuel jsetꞌuc lacanovae ―xꞌutat la li Simone. Ti Jesuse ichoti la ta yut canova, jaꞌo la lic xchanubtas li crixchanoetic tey lamal ta tiꞌnabe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ti cꞌalal laj chanubtasvanuque ―Lacanovae xanubtaso echꞌel ta snabil li voꞌe. Jaꞌ tey xajip lanutiꞌique. Jaꞌ tey chataic ep choy ―xꞌutat la yuꞌun Jesús li Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","―Jchanubtasvanej, sjunul acꞌubal liꞌabtejoticotic pero muc bu ijtaticotic. Lavi voꞌot chavale, ta jipticotic ta voꞌ li stsacobil jchoyticotique ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ti cꞌalal isjip ochel ta voꞌ li stsacobil xchoyique, inoj la tajmec ta choy. Chjat xa la ti snutiꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Isvelu la tal yan xchiꞌilic yuꞌun la tscꞌanic coltael. Italic la. Inoj la ta choy xchaꞌcotol ti canovae. Jutuc xa la muc xmuc yalel yuꞌun la toj ol li choye. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ti cꞌalal iyil li Simon Pedroe ti inoj ta choy xchaꞌcotol ti canovae, isquejleta la ti Jesuse. ―Cajval, mu xachiꞌinon. Li voꞌone jmulavilon ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ti xꞌelan iyale, yuꞌun la xchꞌayet xa o yoꞌonic ti ep tajmec istaic choy xchiꞌuc li xchiꞌiltaque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jaꞌ noꞌox yech xchꞌayet xa la yoꞌonic uc li Jacoboe xchiꞌuc li Juane, jaꞌ li scremotic Zebedeoe, yuꞌun la jaꞌ xchiꞌil sbaic ta tsacchoy xchiꞌuc li Simone. ―Mu me xaxiꞌ. Ta jel avabtel. Chba avicꞌbon tal crixchanoetic ―xꞌutat la yuꞌun Jesús li Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jaꞌ noꞌox la ti isloqꞌuesic ta tiꞌnab ti scanovaique, iyictaic o la li tsacchoye, jaꞌ la ba xchiꞌinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ti cꞌalal tey ta jun jteclum ti Jesuse, tey la icꞌot jun jꞌisrael, ip la ta lepra. Cꞌalal iyil Jesús ti vinique, isquejan la sba ta yichon, jaꞌo la isnijan sba ta balamil noxtoc. ―Cajval, acꞌanuc la avetꞌesbon li chamel xꞌelan ipon oe, yuꞌun jnaꞌoj ti voꞌot xuꞌ chavetꞌesbone ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ti Jesuse iyacꞌ la scꞌob ta sba ti jchamele. ―Echꞌuc cheꞌe ―xut la. Ora la iꞌechꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","―Mu me muchꞌu xavalbe yaꞌi ti voꞌon laquetꞌesbot lachamele. Jaꞌ noꞌox ba acꞌbo yil li palee. Acꞌbo smoton Riox chac cꞌu chaꞌal yaloj ti Moisese yoꞌ xilic o li jchiꞌiltactique ti lecot xae ―xut la echꞌel vinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero más to la ivinaj ti chetꞌes chamel ti Jesuse. Más to la ep crixchanoetic tey icꞌotic yuꞌun la tscꞌan chaꞌiic li cꞌusitic chale, tscꞌanic la etꞌesbel xchamelic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ti Jesuse oy la ibat stuc ta xocol balamil, ba la scꞌopon Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ti jꞌechꞌele xyaquet la ta xchanubtasvan ti Jesuse. Tey la chotajtic jayvoꞌ jfariseoetic xchiꞌuc jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Talemic la ta scotol cꞌox jteclumetic ta estado Galilea, xchiꞌuc la ta estado Judea, xchiꞌuc la ta jteclum Jerusalén. Ti Jesuse iyacꞌ la iluc slequilal syuꞌelal Riox, iyetꞌesbe la xchamel scotol li jchameletic italique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tey la icꞌot jayvoꞌ jꞌisraeletic, sqꞌuechojic la cꞌotel ta pop jun xchiꞌilic, chꞌabal la yip jun yoc scꞌob. Tscꞌan ox la ch-ochic xchiꞌuquic ta yut na, chba ox la spuchꞌanic ta yichon ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero muc la sta ochel sbeic yuꞌun la toj noj ti nae. Solel la imuyic ta bana yuꞌun pachꞌal. Ixchꞌojic la jsetꞌ, tey la isyalesic xchiꞌuc spop ti jchamele. Tey la icꞌot ta stuqꞌuil ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ti Jesuse iyil la ti xchꞌunojic ti oy syuꞌele. ―Jchiꞌiltic, acꞌbilot xa pertonal yuꞌun lamule ―xut la ti jchamele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti jfariseoetique, “¿muchꞌu liꞌi ti tspꞌis sba ta Rioxe? Muc muchꞌu xuꞌ chiyacꞌbotic pertonal yuꞌun li jmultique, jaꞌ noꞌox ti Rioxe”, xi la ta yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ti Jesuse yiloj la ti cꞌusi tsnopique. ―¿Cꞌu yuꞌun ti xꞌelan chanopique? ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ti xꞌelan icalbe li vinique ti “acꞌbilot xa pertonal yuꞌun lamule”, xcute, muchꞌuuc noꞌox xuꞌ chal yech, yuꞌun mu vocluc ta alel. Jaꞌ noꞌox yech mu vocluc ta alel ti: “Lican, xanavan”, xichiotique. Pero jaꞌ tscꞌan chaqꞌuelic mi chcꞌot scꞌop ti muchꞌu yech chale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Li voꞌone ical ti acꞌbil xa pertonal yuꞌun smul li vinique. Pero qꞌuelic me cꞌusi ta jpas lavie yoꞌ xavilic o ti voꞌon noꞌox ta xcacꞌbe pertonal yuꞌun smulic li crixchanoetic liꞌ ta sba balamile, voꞌon ti coꞌol crixchanootique ―xꞌutatic la yuꞌun ti Jesuse. ―Voꞌon chacalbe, lican, tamo echꞌel lapope, batan ta ana ―xꞌutat la yuꞌun Jesús ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ora la ilic. Iyil la scotolic ti iyichꞌ echꞌel ti spope, ibat la ta sna. “Colaval”, xut la echꞌel ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Cꞌalal iyil ti crixchanoetique, xchꞌayet xa la yoꞌonic. ―Coliyal Riox muc bu xquiltic o yech ti xꞌelan tspase ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ti cꞌalal laj spas yech ti Jesuse, ilocꞌ la teyoꞌe. Iyil la jun jcꞌan-locꞌ-cꞌusiticuc, tey la chotol ta xchotleb yoꞌ bu tscꞌanbe li slocꞌ cꞌusiticuque. Leví la sbi li vinique. ―Laꞌ, batic ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Li Levie iyicta la li yabtele, jaꞌ la ixchiꞌin echꞌel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tsꞌacal to li Levie iyicꞌ la echꞌel ta sna ti Jesuse, iyacꞌbe la sveꞌel. Ep la xchiꞌil ta cꞌan-locꞌ-cꞌusiticuc istac ta iqꞌuel. Oy to la muchꞌutic yan iyicꞌ. Ixchol la sbaic ta mexa scotolic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti jfariseoetique, chopol la iyilic ti tsobol chveꞌ xchiꞌuc jcꞌan-locꞌ-cꞌusiticuc ti Jesuse. ―¿Cꞌu yuꞌun ti tsobol chaveꞌ achiꞌuquic li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li muchꞌutic más chopol cꞌusitic tspasique? ―xꞌutatic la li jayvoꞌ icꞌbilic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jaꞌ la itacꞌav ti Jesuse: ―Ti muchꞌutic leque mu cꞌu stu yuꞌunic jpoxtavanej. Jaꞌ noꞌox ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Li voꞌone maꞌuc tal jsaꞌ li muchꞌutic chꞌabal smul ti yalojique. Jaꞌ tal jsaꞌ ti muchꞌutic oy smulique yoꞌ xictaic oe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oy la muchꞌutic cꞌot sjacꞌbeic ti Jesuse: ―¿Cꞌu yuꞌun ti mu xicta yotic lavajchancꞌoptac voꞌote? Li yajchancꞌoptac Juane ep ta echꞌel chicta yotic tscꞌoponic Riox. Jaꞌ noꞌox yech noxtoc li yajchancꞌoptac jfariseoetique ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Itacꞌav la ti Jesuse: ―Cꞌalal teotic ta nupunele, cꞌalal tey jchiꞌinojtic li jnupunele, mu jaꞌuc o chquicta cotic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jaꞌ noꞌox yech lavi liꞌto jchiꞌuc li cajchancꞌoptaque, mu xicta yotic. Jaꞌto chicta yotic ti cꞌalal ximilee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","’Muc muchꞌu tsjat jsetꞌuc li yachꞌcꞌuꞌe ti tspacꞌan o li scꞌaꞌcꞌuꞌe. Mi yech tspase, yech chixtalan li achꞌ cꞌuꞌule. Mi jaꞌuc onox snupin yuꞌun tsmuts li achꞌe. Jaꞌ noꞌox yech ti muchꞌutic ta xchꞌunic ti voꞌon noꞌox chcacꞌ cuxlicuc ta sbatel osile, achꞌ xa li cꞌusitic tspasique, mu xa spasic ti cꞌusitic ispasic toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jaꞌ chac cꞌu chaꞌal li achꞌ yaꞌlel uvae, muc muchꞌu ta xchꞌol ta pocoꞌ nuculal chivo. Ti mi ta xchꞌol ta pocoꞌ nucule, ti cꞌalal xvocane, ta xtꞌom li nucule. Yech noꞌox ta xmal. Yech noꞌox ta xchꞌay noxtoc li yave. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Li achꞌ yaꞌlel uvae jaꞌ tscꞌan ti achꞌ yav chichꞌ chꞌolel oe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ti muchꞌu nopem xaꞌi yuchꞌel li paseme, mu scꞌan ti bu chiꞌ toe. “Más lec chcaꞌi li paseme”, xiic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ta scꞌacꞌalil ta xcuxic li jꞌisraeletique li jayvoꞌ tsobol chanavic xchiꞌuc ti Jesuse, jaꞌo la iꞌechꞌic xchiꞌuc ta be ta trigoaltic. Iscꞌasic la jaychev trigo, isjuꞌ la scꞌuxic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iꞌileic la yuꞌun jayvoꞌ jfariseo. ―¿Cꞌu yuꞌun chacꞌasic trigo ta scꞌacꞌalil ta jcuxtique? ―xꞌutatic la yuꞌun ti jfariseoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jaꞌ la itacꞌav ti Jesuse: ―¿Mi muc bu aqꞌuelojic yaꞌel ta scꞌop Riox ti cꞌusi ispas ti Davide cꞌalal iviꞌnaj xchiꞌuc ti xchiꞌiltac ta xanvile? ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tey icꞌotic ta templo. Ti Davide jaꞌ iscꞌan sveꞌ ti pan ta ba mexae ti smotoninoj ti Rioxe. Acꞌu mi yaloj ti Rioxe ti jaꞌ noꞌox tsveꞌic li paleetique, pero isveꞌic xchiꞌuc xchiꞌiltac ti Davide. Pero muc bu ista o smul uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","’Voꞌon ti coꞌol crixchanootique, voꞌon yajvalon li scꞌacꞌalil ta jcuxtique. Voꞌon chcal ti cꞌusi xuꞌ jpastique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta scꞌacꞌalil ta xcuxic li jꞌisraeletique, ti Jesuse iꞌoch la ta jun biqꞌuit templo, ichanubtasvan la. Tey la jun vinic smochꞌoj la sba sniꞌtac sbatsꞌicꞌob. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tey la jayvoꞌ li muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc la jayvoꞌ jfariseoetic. Jaꞌ la tspaꞌiic ti Jesuse. Ta la sqꞌuelic mi oy chetꞌes chamel ta scꞌacꞌalil ta xcuxique yoꞌ la stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ti Jesuse snaꞌoj la li cꞌusi tsnopique. ―Laꞌ vaꞌlan liꞌ ta oꞌlole ―xut la ti vinic smochꞌoj sba sniꞌtac sbatsꞌicꞌobe. Ti vinique tey la ba vaꞌluc ta oꞌlol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ti Jesuse iscꞌopon la ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti jfariseoetique: ―Oy cꞌusi chajacꞌbeic. Ta scꞌacꞌalil ta jcuxtique ¿cꞌusi yaloj ti Rioxe ti xuꞌ jpastique? ¿Mi xuꞌ jpastic li cꞌusitic leque, o mi jaꞌ ta jpastic li cꞌusitic chopole? ¿Mi xuꞌ chichꞌ etꞌesbel xchamel li muchꞌutic ipe, o mi tey noꞌox jqꞌuelojtic chamicuc? ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ti Jesuse isqꞌuelbe la sat ti muchꞌutic tey chotajtique. ―Tuqꞌuibtaso li sniꞌtac acꞌobe ―xꞌutat la yuꞌun Jesús ti vinique. Istuqꞌuibtas la, lec xa la icom ti scꞌobe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti jfariseoetique, icap o la sjolic. Isnopic la cꞌusi xuꞌ ta xchaꞌleic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti cꞌalal jaꞌo yech ispase, imuy la echꞌel ta vits ti Jesuse, ba la scꞌopon Riox. Sjunul la acꞌubal tey iscꞌopon Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ti cꞌalal isacube, istsob la scotol ti muchꞌutic ixchiꞌin scotol cꞌacꞌale. Jaꞌo la istꞌuj lajchavoꞌ ti ta xchiꞌin oe, ti ta stac echꞌel ta yalel aꞌyuc li cꞌusitic chale. Apoxtoletic isbiinic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Li lajchavoꞌ itꞌujeique, jaꞌ sbiic liꞌi: Simón, Pedro la iꞌacꞌbat sbiin yuꞌun ti Jesuse. Xchiꞌuc Andrés, jaꞌ yitsꞌin li Pedroe. Xchiꞌuc Jacobo, xchiꞌuc Juan, xchiꞌuc Felipe, xchiꞌuc Bartolomé. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xchiꞌuc Mateo, xchiꞌuc Tomás, xchiꞌuc otro jun Jacobo screm Alfeo. Xchiꞌuc Simón ti sticꞌoj sba ta partido zelotee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xchiꞌuc Judas, jaꞌ sbanquil yitsꞌin sba xchiꞌuc li Jacoboe. Xchiꞌuc Judas Iscariote, jaꞌ ti iyacꞌ entrucal ta tsꞌacal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ti cꞌalal iyalic tal ta yoc vits xchiꞌuc Jesús li lajchavoꞌe xchiꞌuc ti muchꞌutic ixchiꞌinic ti cꞌalal iꞌay ta vitse, tey la lamal ep crixchanoetic cꞌot staic ta stentejtic. Oy la jlom liquemic tal ta estado Judea xchiꞌuc ta jteclum Jerusalén. Oy la jlom liquemic tal ta chib jteclum Tiro xchiꞌuc Sidón li ta stsꞌel tiꞌmare. Yuꞌun la ba yaꞌiic cꞌusi chal ti Jesuse. Iscꞌanic la etꞌesbel xchamelic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ti muchꞌutic ochem pucuj ta yoꞌonique icꞌotic la noxtoc. Iloqꞌuesbat la scotolic ti pucujetic ochem ta yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ti crixchanoetique yoꞌonuc la spiquic ti Jesuse yuꞌun la iyilic ti ta slequilal syuꞌelal noꞌox iꞌechꞌ ti chamele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Li lajchavoꞌe iqꞌuelbat la satic yuꞌun ti Jesuse. ―Voꞌoxuc ti povreoxuque, chavilic to ta tsꞌacal ti jun avoꞌonique yuꞌun chlic spasoxuc ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Voꞌoxuc ti abol abaic ta viꞌnal lavie, chavilic to ta tsꞌacal ti jun avoꞌonique yuꞌun chayacꞌbeic cꞌusitic chtun avuꞌunic ti Rioxe. ’Voꞌoxuc ti chaꞌoqꞌuic lavie, chavilic to ta tsꞌacal ti jun avoꞌonique yuꞌun jaꞌ chaspatbe avoꞌonic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Voꞌoxuc ti mu scꞌan sqꞌuel asatic li crixchanoetique, ti chasnutsique, ti chaspꞌajique, ti chopol cꞌusi chayalbeic o ti avichꞌojicon ta mucꞌ voꞌon ti coꞌol crixchanootique, chavilic to ta tsꞌacal ti jun avoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Junuc noꞌox avoꞌonic ti cꞌalal yech chcꞌote, yuꞌun lec ti cꞌusi chcꞌot ataic ta vinajele. Li muchꞌutic mu scꞌan sqꞌuel asatique jaꞌ onox yech ispasic ti smucꞌtatotic ti ta más voꞌnee. Abol sba ixchaꞌleic ti yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Voꞌoxuc ti jcꞌulejoxuque, ti mu cꞌusi palta chavaꞌiique, chavil to avocolic ta tsꞌacal yuꞌun mu cꞌusi chayacꞌbeic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Voꞌoxuc ti noj achꞌutic lavie, chavilic to viꞌnal ta tsꞌacal. ’Voꞌoxuc ti chatseꞌinic lavie, chavil to avocolic yuꞌun chavat avoꞌonic chavoqꞌuita to abaic ta tsꞌacal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Voꞌoxuc ti lec chayilic li crixchanoetique, mu cꞌusi bal o yuꞌun chavil to avocolic ta tsꞌacal. Yuꞌun jaꞌ yechoxuc chac cꞌu chaꞌal ti muchꞌutic ispꞌis sbaic ta yajꞌalcꞌoptac Riox ti ta más voꞌnee. Yech noꞌox ti lec iꞌileic yuꞌun ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Voꞌoxuc ti liꞌ chavaꞌiic li cꞌusitic chcal lavie, chacalbeic. Cꞌuxubino acrontaic. Ti muchꞌutic mu scꞌan sqꞌuel asatique, lec me xacꞌoponic, xacoltaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mi chopol ti cꞌusitic chayalbeique, mu me cꞌusi chopol xavalbeic uc. Cꞌoponbeic Riox yoꞌ xlecub o yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ti mi oy muchꞌu chasmajbe jot xocon asate, albo ti xuꞌ smaj xchaꞌjotole. Ti mi oy muchꞌu chaspojbe apimilcꞌuꞌe, acꞌbo. Acꞌbo noxtoc li jlom ta yute. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ti mi oy muchꞌu chascꞌanbe li cꞌusuc avuꞌune, acꞌbo. Ti mi oy muchꞌu tspoj li cꞌusi avuꞌune, mu me xacꞌanbe sutel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mi chacꞌan ti lec chayil li crixchanoetique, jaꞌ tscꞌan ti lec chavil uque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Pero mi jaꞌ noꞌox acꞌanojic li muchꞌutic scꞌanojoxuque, mu xvinaj ti lec avoꞌonique. Coꞌoloxuc xchiꞌuc li muchꞌutic chopol sjole. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ti mi jaꞌ noꞌox chacꞌuxubinic li muchꞌutic chascꞌuxubinique, mu xvinaj ti lec avoꞌonique. Coꞌoloxuc xchiꞌuc li muchꞌutic chopol sjole. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ti mi jaꞌ noꞌox chavacꞌbeic xchꞌamun ataqꞌuinic li muchꞌu avilojic ti snaꞌ sutese, mu xvinaj ti lec avoꞌonique. Coꞌoloxuc xchiꞌuc li muchꞌutic chopol sjole. Yuꞌun jaꞌ noꞌox chacꞌbe xchꞌamun staqꞌuinic li muchꞌutic yilojic ti snaꞌ sutesele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Li voꞌoxuque tscꞌan chacꞌuxubinic li muchꞌutic chascrontainique. Tscꞌan lec chavilic scotol crixchanoetic. Ti mi oy cꞌusi chaxchꞌamunbee, acꞌbo, acꞌu mi mu sutes, yoꞌ xvinaj o ti xchꞌamaloxuc ti Rioxe, yoꞌ xata o ep amotonic ta vinajele. Ti Rioxe scꞌuxubinoj li muchꞌutic chopol sjol uque ti mu snaꞌ xalic colaval ti cꞌalal oy cꞌusi tstabeic Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jaꞌ más lec cꞌuxubinvananic chac cꞌu chaꞌal chcꞌuxubinvan ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Mu me xanopbe smul achiꞌilic yoꞌ ti mu xayalbe o ti Rioxe ti oy amule. Mi oy bu ista smul avuꞌunic lachiꞌilique, aqꞌuic ta pertonal yoꞌ ti xayacꞌbeic o pertonal yuꞌun amulic ti Riox uque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Acꞌbeic cꞌusi chtun yuꞌun lachiꞌilique yoꞌ ti xayacꞌbeic o cꞌusi chtun avuꞌunic ti Riox uque. Más to ep chaꞌacꞌbatic li voꞌoxuque. Jaꞌ chac cꞌu chaꞌal li muchꞌutic tsꞌacal chacꞌ li cꞌusi chaqꞌue, ti lec tsnojese, ti chtanij xa loqꞌuel ta stiꞌile, jaꞌ yech chavichꞌic ti cꞌusi chtun avuꞌunic li voꞌoxuque. Ti mi ep chavaqꞌuique, jaꞌ noꞌox yech ep chaꞌacꞌbatic uc. Ti mi jsetꞌ chavaqꞌuique, jaꞌ noꞌox yech jsetꞌ chayacꞌbeic ti Riox uque ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ti Jesuse iyal la jun loꞌil: ―Li muchꞌu maꞌsate mu stacꞌ xacꞌbe yil be li xchiꞌil ta maꞌsatile. Coꞌol chpꞌajic ta chꞌen. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Li jchanvune mu coꞌoluc snaꞌic xchiꞌuc yajmaestro yuꞌun jaꞌto ta xchan. Ti cꞌalal xchane, coꞌolic xa. Yechꞌo un tꞌujic ti muchꞌu chacꞌanic ti chaxchanubtasique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Acꞌu mi mu cꞌusi más chopol tspas lachiꞌile, li voꞌote yochelot ta sqꞌuelel. Mu xavaꞌi aba ti más to chopol li cꞌusi chapase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Chopol ti xꞌelan chapase”, xavut lachiꞌile, pero ¿cꞌuxi chapꞌijubtasvan ti más to chopol cꞌusitic chapas li voꞌote? Li voꞌote chanop ti mu cꞌusi chopol chapase. Mi chacꞌan chapꞌijubtas lachiꞌile, jaꞌ tscꞌan ti voꞌot baꞌyi chavicta spasel li cꞌusitic chopole. Mi avil xa ti lecote, xuꞌ xa xapꞌijubtas lachiꞌile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Jaꞌ chac cꞌu chaꞌal li teꞌel loꞌboletique, ti bu onox leque, lec li sate. Ti bu onox chopole, chopol li sate. Mu scap sba li leque xchiꞌuc li chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ti cꞌu xꞌelan sat li jtecꞌ teꞌe jaꞌ chvinaj o mi lec, mi chopol. Muc bu xavilic icꞌux ta jtecꞌ chꞌix, muc bu xavilic uva ta macom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jaꞌ noꞌox yech li muchꞌu lec yoꞌone lec chcꞌopoj, lec cꞌusi tsnop. Li muchꞌu chopol sjole chopol chcꞌopoj, chopol cꞌusi tsnop. Ti cꞌu xꞌelan ta snopique jaꞌ yech chlocꞌ ta yeic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Cꞌu yuꞌun ti “Cajval, Cajval” xavuticone ti muc bu chapasic li cꞌusitic icale? ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ti muchꞌu chaꞌi li cꞌusitic chcale, mi ta xchꞌune, chacalbe avaꞌiic cꞌu xꞌelan. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Coꞌol xchiꞌuc jun vinic ti ismeltsan sna ta ba tone. Nat isjocꞌ yalel jaꞌto ti ista li tone. Jaꞌto tey isliquesbe li stanal yoque. Ital tsots voꞌ, inoj li ucꞌume, icajtsaj cꞌalal ba osil, icꞌot yoꞌ bu li nae. Li pana xocon nae inoj. Pero muc xlom yuꞌun ta ba ton smeltsanoj. ");
INSERT INTO tzoZNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ti muchꞌu chaꞌi li cꞌusitic chcale, mi mu xchꞌune, coꞌol xchiꞌuc jun vinic ti ta ba balamil ismeltsan snae, chꞌabal stanal yoc. Ital tsots voꞌ, inoj li ucꞌume, icajtsaj cꞌalal ba osil, icꞌot yoꞌ bu li nae. Li pana xocon nae inoj. Ora ilom ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ti cꞌalal laj xchanubtas crixchanoetic ta yoc vits ti Jesuse, ibat la ta jteclum Capernaum. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oy la jun capitan soltero, tey la nacal ta Capernaum. Oy la jun smozo scꞌanoj la tajmec. Iꞌipaj la, ta xaꞌox la xcham ti smozoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ti cꞌalal iyaꞌibe scꞌoplal Jesús ti capitan solteroe, istac la echꞌel jayvoꞌ jmeltsanejcꞌopetic yuꞌun jurioetic ti tey ta Capernaume. Ba la yalbeic ti Jesuse mi mu la xꞌabulaj xba yetꞌesbe xchamel ti smozoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ti jmeltsanejcꞌopetique ibatic la yoꞌ bu ti Jesuse. ―Abulajan cꞌuxubino li capitan solteroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yuꞌun scꞌanojotic jcotoltic. Jaꞌ iyacꞌ taqꞌuin ti imeltsaj o li templo liꞌ ta jteclume ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ti Jesuse ixchiꞌin la echꞌel ti jmeltsanejcꞌopetique. Ti cꞌalal poꞌot xaꞌox la xcꞌotic ta snae, ti capitan solteroe istac la tal jayvoꞌ ti muchꞌutic lec scꞌopone yuꞌun la jaꞌ tal spajesic ti Jesuse. ―Totic, mu la xba avacꞌ avocol. Yuꞌun la mu tsotsuc yabtel ti voꞌot chabat ta snae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mu la smeloluc chaꞌi ti chtal scꞌoponot stuque. Xuꞌ la jaꞌ noꞌox alo jpꞌeluc ti acꞌu echꞌuc xchamel li smozoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mantal noꞌox la ta xchꞌun ti tspas ta mantal li solteroetique. Batan, mi xut la li june, chbat la. Laꞌ to, mi xut la li june, chtal la. Paso chac liꞌi, mi xut la li smozoe, tspas la, xiyutoticotic tal ―xutic la cꞌotel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ti cꞌalal iyaꞌi ti Jesuse, xchꞌayet xa la yoꞌon. Ijoyij la. ―Chacalbeic ti muc bu jtaoj junuc jchiꞌiltic ta israelal ti ta xchꞌun chac cꞌu chaꞌal ta xchꞌun li capitan solteroe ―xut la ti crixchanoetic tey napꞌajtic echꞌel ta spate. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ti cꞌalal isut ti muchꞌutic itaqueic tale, lec xa la cꞌot staic ti smozo capitan solteroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Li lajchavoꞌe tsobolic la echꞌel xchiꞌuquic ti Jesuse, ibatic la ta jun jteclum, Naín sbi. Ep la crixchanoetic napꞌal echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti cꞌalal poꞌot xaꞌox la xcꞌotic ta stiꞌ scorraltonal li jteclume, ti Jesuse iyil la ti oy muchꞌutic scuchojic tal ánimae yuꞌun chba smuquic. Ti ánimae screm la jun meꞌanal ants. Junjunuc o la ti yole. Ep la tajmec smuquel, jaꞌ la ti muchꞌutic tey nacajtic ta jteclume. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ti Cajvaltic Jesuse ti cꞌalal iyil ti antse, icꞌuxubaj la ta yoꞌon. ―Mu xaꞌocꞌ ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inopoj la echꞌel, ispicbe la sqꞌuechꞌobteꞌal ti ánimae. Ti muchꞌutic scuchojic tale vaꞌ xiic la. ―Crem, voꞌon chacalbe, lican ―xut la ánima ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ora la ichoti ti creme, lic la loꞌilajuc. ―Icꞌo echꞌel lacreme ―xꞌutat la yuꞌun Jesús ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ti muchꞌutic teye ixiꞌ la scotolic. Pero “coliyal Riox” xiic la. ―Li jchiꞌiltic liꞌi yajꞌalcꞌop Riox. Tsots syuꞌel ―xi la jlom. ―Voꞌotic jcꞌuxubineltic ti itaque tal yuꞌun ti Rioxe, voꞌotic ti stꞌujojotic onoxe ―xi la jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ti cꞌusi ispas ti Jesuse, ivinaj la ta sjunlej estado Judea xchiꞌuc ti butic nopol xile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti Juan jꞌacꞌ-ichꞌvoꞌe iꞌalbat la yuꞌun yajchancꞌoptac ti cꞌusitic tspas ti Jesuse. Ti cꞌalal iyaꞌie, iyalbe la chaꞌvoꞌ yajchancꞌop. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","―Ba jacꞌbeic li Jesuse mi jaꞌ xa ti muchꞌu scꞌoplal chtal spasotic ta mantale, o mi ta to jmalatic otro jun ―xꞌutatic la echꞌel ti chaꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ti cꞌalal icꞌotique, iscꞌoponic la ti Jesuse: ―Liꞌ listacoticotic tal li Juan jꞌacꞌ-ichꞌvoꞌe. Tal jacꞌboticotic mi voꞌot ti scꞌoplal chtal apasoticotic ta mantale, o mi ta to jmalaticotic otro jun ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti Jesuse jaꞌo la xyaquet ta xetꞌesbe xchamel ep jchameletic ti cꞌalal icꞌotique, xchiꞌuc la ti muchꞌutic ip ta chine. Ta la sloqꞌuesbe pucujetic ta yoꞌon ti crixchanoetique, ta la sjambe sat maꞌsatetic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","―Ba albeic li Juane li cꞌusitic ijpas avilique xchiꞌuc li cꞌusitic ical avaꞌiique. Li maꞌsatetique chil xa sbeic. Li coxoetique lec xa chanavic. Iꞌechꞌ xa xchamelic li muchꞌutic ip ta leprae. Ijam xa xchiquinic li pacꞌchiquinetique. Li muchꞌutic chamemic xaꞌoxe ijchaꞌcuxesic xa. Li meꞌonetique icalbe xa yaꞌiic ti oy cuxlejal ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mu me xicta sba li Juane, acꞌu yichꞌon o ta mucꞌ, junuc me yoꞌon, xiyutoticotic tal li Jesuse, xavutic cꞌotel li Juane ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ti cꞌalal isutic ti yajchancꞌoptac ti Juane, ti Jesuse lic la yalbe crixchanoetic scꞌoplal ti Juane. ―Ti cꞌalal laꞌayic ta xocol balamile, maꞌuc puj ay aqꞌuelic ti xbat ta jot ta jot ta iqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yajꞌalcꞌop Riox ay aqꞌuelic. Avilic ti muc bu lec stsꞌacubtasoj sbae. Ti muchꞌutic stsꞌacubtasoj sbaique, ti mu cꞌu meꞌanal chaꞌiique, jaꞌ li preserenteetique yuꞌun jcꞌulejetic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Li Juan ay aqꞌuelique, maꞌuc yech pero más tsots yabtel chac cꞌu chaꞌal ti yan yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tsꞌibabil onox scꞌoplal ta scꞌop Riox li Juane ti jaꞌ chjelav tal cuꞌune. Baꞌyi ta jtac echꞌel mantal. Jaꞌ chalbe li crixchanoetique ti tey chacꞌote yoꞌ xaꞌichꞌe o ta muqꞌue, xiyut ti Jtote, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chacalbe avaꞌiic, ta scotol li crixchanoetique muc muchꞌu más tsots yabtel chac cꞌu chaꞌal li Juan jꞌacꞌ-ichꞌvoꞌe. Pero ti muchꞌu ta xchꞌun pasel ta mantal yuꞌun ti Rioxe, acꞌu mi mu tsotsuc yabtel, más ch-acꞌbat yil cꞌu xꞌelan tspas mantal ti Rioxe. Jaꞌ mu sta yech ch-acꞌbat yil li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Li muchꞌutic iyaꞌiic ti cꞌusitic iyal li Juane xchiꞌuc li jcꞌan-locꞌ-cꞌusiticuque, ixchꞌunic yictael li cꞌusitic chopole, iscꞌanbeic ichꞌvoꞌ li Juane yoꞌ xꞌaqꞌueic o ta pertonal yuꞌun ti Rioxe. Yuꞌun iyaꞌiic ti oy smulic ta stojol ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Li jfariseoetique xchiꞌuc li muchꞌutic ta xchanubtasvanic ta smantal Rioxe, muc xchꞌunic yictael li cꞌusitic chopole, yechꞌo ti muc scꞌanbeic ichꞌvoꞌ li Juane. Ispꞌajic li pertonale ti ch-acꞌbatic ox yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’Chacalbeic cꞌu xaꞌelanic voꞌoxuc ti cuxuloxuc lavie. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Caltic noꞌox yaꞌel ti oy cꞌoxetic tey chtajinic ta chꞌivite. Li jlome iyalbeic li jayvoꞌ xchiꞌiltac ta tajimole: “Icoqꞌuesinticotic ama pero muc xaꞌacꞌotajic o. Limeꞌanajꞌocꞌoticotic pero muc xaꞌoqꞌuic noxtoc. Mu cꞌusi xacꞌanic”, xutic. Jaꞌ yechoxuc uc yuꞌun mu cꞌusi xacꞌanic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ti cꞌalal ital li Juane, muc xaxchiꞌinic ta veꞌel ta uchꞌvoꞌ pero chopol avaꞌiic. “Ochem pucuj ta yoꞌon”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ti cꞌalal lital voꞌon ti coꞌol crixchanootique, lajchiꞌinic ta veꞌel ta uchꞌvoꞌ pero chopol avaꞌiic noxtoc. “Qꞌuelavil tol xveꞌ, tol xuchꞌ yaꞌlel uva”, xachiic. Lec xil noxtoc li jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc li muchꞌutic más chopol cꞌusitic tspasique”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ti spꞌijubtasojicoxuc ti Rioxe, avichꞌoticotic ta mucꞌ xchiꞌuc Juan ti yechuque. Jaꞌ chul o ta ajolic ti spꞌijubtasojoticotic ti Rioxe, yechꞌo ti ijpasticotic ti cꞌusitic ijpasticotique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ti Jesuse iꞌiqꞌue la echꞌel ta veꞌel yuꞌun jun jfariseo. Ibat la, ichoti la ta mexa. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti cꞌalal xyaquet chveꞌ ta mexae, jaꞌo la tey icꞌot jun ants, chopol la cꞌusitic tspas. Yuꞌun la iyaꞌi ti tey ta sna jfariseo ti Jesuse. Yichꞌoj la cꞌotel jun slimete, noj la ta yaꞌlel muil nichim. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ti antse tey la icꞌot ta stsꞌel ti Jesuse. Iyoqꞌuita la sba. Ti yaꞌlel sate icꞌot la ta yoc ti Jesuse. Iscusbe la ta stsatsal sjol. Isbutsꞌbe la ti yoque. Jaꞌo la iscoconbe ta yoc ti sbel slimetee yuꞌun la iyichꞌ ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ti cꞌalal iyil ti muchꞌu iꞌicꞌvan ta veꞌele, “Ti jaꞌuc yajꞌalcꞌop Riox li vinic liꞌi, snaꞌoj ti chopol cꞌusitic tspas li ants ti chpicone”, xi la isnop ti jfariseoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","―Simón, oy cꞌusi chacalbe ―xꞌutat la yuꞌun ti Jesuse. ―¿Cꞌusi? ―xi la ti Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","―Caltic noꞌox yaꞌel ti oy jun vinic ichꞌamunbat staqꞌuin yuꞌun chaꞌvoꞌ vinique. Li june ixchꞌamun quiniento. Li june ixchꞌamun cincuenta. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ti cꞌalal iyil ti mu xa sut yuꞌunic li yajval taqꞌuine, ixchꞌaybe yil xchaꞌvaꞌalic. Li chaꞌvoꞌ vinic ti ichꞌaybat yile, ¿muchꞌu más cꞌanvanem xanaꞌ? ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","―Jaꞌ nan más cꞌanvanem li muchꞌu ichꞌaybat ep yile ―xi la ti Simone. ―Yech avaꞌuc ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ti Jesuse isqꞌuelbe la sat ti antse, jaꞌ la iscꞌopon ti Simone: ―Ti cꞌalal liꞌoch tale, muc muchꞌu lispocbe coc. Qꞌuelavil li ants liꞌi, jaꞌ lispocbe coc ta yaꞌlel sat. Liscusbe ta stsatsal sjol noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Li voꞌote muc xabutsꞌon ti cꞌalal liyule. Li antse lisbutsꞌbe coc. Yilel to tsbutsꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Li voꞌote muc xacoconbon aceite ta jol. Yan li antse liscoconbe yaꞌlel muil nichim ta coc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chacalbe avaꞌi, acꞌu mi ep smul li antse, lavie acꞌbil xa pertonal yuꞌun smul yuꞌun scꞌanojon tajmec. Li muchꞌu jutuc noꞌox smul ti yaloje ti icacꞌbe pertonale, jaꞌ mu másuc scꞌanojon ―xꞌutat la yuꞌun Jesús ti Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","―Li voꞌote laꞌacꞌbat xa pertonal yuꞌun lamule ―xꞌutat la yuꞌun Jesús ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","―¿Muchꞌu li vinic liꞌi ti cꞌalal ta mulil chacꞌ pertonal uque? ―xiic la ti muchꞌutic tey ta mexae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ti antse iꞌalbat la noxtoc yuꞌun ti Jesuse: ―Laꞌacꞌbat xa pertonal yuꞌun lamule yuꞌun achꞌunoj ti oy jyuꞌele. Yechꞌo un mu me cꞌu xal avoꞌon, batan ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsꞌacal to li lajchavoꞌe tsobol la ibatic ta jteclumetic xchiꞌuc ta parajeletic xchiꞌuquic ti Jesuse. Ti Jesuse jaꞌ la iyal ti chlic xa pasvanuc ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xchiꞌuquic la echꞌel jayvoꞌ antsetic. Oy la iloqꞌuesbatic pucuj ta yoꞌonic yuꞌun ti Jesuse, oy la iꞌetꞌesbat xchamelic. Tey la capal echꞌel jun ants, María la sbi, liquem la tal ta jteclum Magdala. Jaꞌ la ti iloqꞌuesbat vucvoꞌ pucuj ta yoꞌon yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tey la li Juana uque, li yajnil Chuzae. Li Chuzae jaꞌ la xchabiojbe sna li covierno Erodese. Tey la li Susana uque xchiꞌuc la yan antsetic. Jaꞌ la imacꞌlinatic li lajchavoꞌe xchiꞌuc ti Jesuse. Li antsetique isloqꞌues la stuquic li veꞌlile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ep la crixchanoetic liquemic la tal ta jujun jteclum istsob la sbaic yoꞌ bu ti Jesuse. Jaꞌo la iyal jun loꞌil ti Jesuse: ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Caltic noꞌox yaꞌel ti oy jun vinic ba svaj strigoe. Ti cꞌalal isvaje, oy jlom ta be icꞌot. Tey ilaj ta tecꞌulanel. Ital mutetic, istam. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oy jlom ta tontic icꞌot. Ti cꞌalal ichꞌi jsetꞌe, ora itaquij, yuꞌun itaquij li lum ta ba tone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oy jlom ta chꞌixtic icꞌot. Ti cꞌalal ichꞌi li chꞌixe, iyolontaj li trigoe, jaꞌ ichꞌajub o. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oy jlom ta lequil balamil icꞌot. Lec ichꞌi, ibeqꞌuin. Li jpꞌej trigoe iyacꞌ cien li sbeqꞌue ―xi la. Ti cꞌalal laj yal chac taje, tsots la icꞌopoj. ―Voꞌoxuc ti avaꞌiic cꞌusi icale, nopbeic smelol ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Li lajchavoꞌe isjacꞌbeic la ti Jesuse ti cꞌusi smelol ti loꞌil iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","―Li voꞌoxuque jamal lacalbeic cꞌu xꞌelan tspas ta mantal crixchanoetic ti Rioxe. Li yantique ta loꞌil noꞌox chcalbeic. Yuꞌun ep ta echꞌel iyilic ti oy jlequilal jyuꞌelale, pero coꞌol xchiꞌuc muc xilic. Ep ta echꞌel iyaꞌiic ti cꞌusi icale, pero muc xaꞌibeic smelol yuꞌun stoyoj sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Chacalbe avaꞌiic cꞌusi smelol li loꞌile. Li becꞌ trigoe jaꞌ seña li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Li becꞌ trigo ti icꞌot ta bee, jaꞌ seña ti muchꞌutic yaꞌyojic xa li scꞌop Rioxe pero mu xchꞌunic. Ta xtal ta ora ti pucuje, chtal chꞌaybatuc ta sjolic li scꞌop Rioxe yoꞌ mu xchꞌunic oe, yoꞌ mu xcuxiic o ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Li becꞌ trigo ti icꞌot ta tontique, jaꞌ seña ti muchꞌutic cꞌalal chaꞌiic li scꞌop Rioxe ora ta xchꞌunic, jun xa yoꞌonic yilel. Pero mu sjunuluc yoꞌon ta xchꞌunic. Ti cꞌalal xꞌilbajinatique, ora chicta sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Li becꞌ trigo ti icꞌot ta chꞌixtique, jaꞌ seña ti muchꞌutic yaꞌyojic xa li scꞌop Rioxe pero jaꞌ noꞌox ta yoꞌonic li cꞌusitic oy ta sba balamile. Jaꞌ chloꞌloatic o. Jaꞌ yolontabil chcom yaꞌel li scꞌop Rioxe yuꞌun mu jꞌechꞌeluc ta xchꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Li becꞌ trigo ti icꞌot ta lequil balamile, jaꞌ seña ti muchꞌutic jꞌechꞌel ta xchꞌunic li scꞌop Rioxe. Coꞌol xchiꞌuc chbeqꞌuin yaꞌel yuꞌun chalic aꞌyuc li scꞌop Rioxe. Acꞌu mi ch-ilbajinatic, mu xicta o sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Muc muchꞌu ta stsan scas ti jaꞌo tsmac ta pꞌine, ti jaꞌo tsticꞌ ta yolon teme. Toyol onox chacꞌ yoꞌ xilic o osil li muchꞌutic ch-ochique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaꞌ noꞌox yech jamal xavalic aꞌyuc li cꞌusitic lacalbeique, mu me avoꞌonicuc noꞌox snaꞌ. Jamal me xavalic aꞌyuc ti cꞌusi orae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Yechꞌo un aꞌibeic me lec smelol li cꞌusitic chacalbeique. Ti muchꞌutic sjunul yoꞌon ta xchꞌunique más ta xpꞌijubtasatic yuꞌun ti Rioxe yoꞌ xchꞌunic o leque, yuꞌun tscꞌan ta xchꞌunic. Yan ti muchꞌutic mu sjunuluc yoꞌon ta xchꞌunique, ti jaypꞌel snaꞌique ta xpojbatic ta jmoj ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tey la icꞌot yitsꞌintac ti Jesuse xchiꞌuc ti smeꞌique. Pero muc la xꞌochic yoꞌ bu ti Jesuse yuꞌun la tsinil tajmec crixchano ta yut na. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oy la muchꞌu iꞌalbon ti Jesuse: ―Tey ta tiꞌna ameꞌ xchiꞌuc avitsꞌintac yuꞌun la tscꞌan chascꞌopon ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","―Chcal avaꞌiic, ti muchꞌutic chaꞌiic li scꞌop Rioxe, ti tspasic chac cꞌu chaꞌal chale, jaꞌ coꞌol xchiꞌuc jmeꞌ, jaꞌ coꞌol xchiꞌuc quitsꞌintac yaꞌel ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ti jꞌechꞌele iꞌochic la ta canova slajchavaꞌalic xchiꞌuquic ti Jesuse. ―Batic ta jech nab ―xꞌutatic la. Ibatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ti cꞌalal chanavic xa la ta ba nabe, ivay la ti Jesuse. Ti cꞌalal vayeme, jaꞌo la ilic tsots icꞌ. Xyucꞌyon xa la tajmec li nabe. Ep la iꞌoch voꞌ ta yut canova, chmuc xaꞌox la yalel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Istijic la ti Jesuse. ―Jchanubtasvanej, ta xa me xichamotic ―xutic la. Ilic la ti Jesuse, ispajes la li iqꞌue, ivaxi la yuꞌun li nabe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","―¿Mi mu to bu achꞌunojic yaꞌel ti voꞌon tsots jyuꞌele? ―xꞌutatic la. Más to la ixiꞌic. Xchꞌayet xa la yoꞌonic. ―¿Muchꞌu li vinic liꞌi ti jliquel ispajes li iqꞌue, ti ivaxi yuꞌun li nabe? ―xut xa la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tey la icꞌotic ta jech nab ta steclumal jgadaraetic. Li Galileae liꞌ la ta jech nab icom yuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ti cꞌalal iloqꞌuic ta canovae, ital la jun jgadara. Voꞌne xa la ochem pucuj ta yoꞌon. Chꞌabal la scꞌuꞌ, chꞌabal la sna. Jaꞌ xa la snainoj li chꞌojbil tonetic yoꞌ bu chichꞌic tiqꞌuel ti ánimaetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ti cꞌalal iyil Jesús ti vinique, isquejan la sba ta yichon, jaꞌo la isnijan sba ta balamil noxtoc. Iꞌavan la. ―¿Cꞌusi acuentaon o li voꞌote? Jesús, Xchꞌamal Riox ta vinajel. Mu me xavacꞌbon castico ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ti xꞌelan iyale, yuꞌun la iyal xaꞌox ti Jesuse ti acꞌu locꞌuc pucuj ta yoꞌone. Ep toꞌox la ta echꞌel iꞌilbajinat yuꞌun pucuj ti vinique. Ti crixchanoetique ixchucbeic toꞌox la yoc scꞌob ta carina, pero ituchꞌ la yuꞌun. Tsuje toꞌox la echꞌel ta xocol balamil yuꞌun ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","―¿Cꞌusi abi? ―xꞌutat la yuꞌun Jesús ti vinique. ―Legionon ―xi la. Ti xꞌelan iyale, yuꞌun la ep pucujetic ochem ta yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","―Mu me xatacoticotic echꞌel ta natil chꞌen ―xutic la Jesús ti pucujetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jaꞌo la tey xlamet ep chitometic ta chꞌut vits. ―Abulajan alo acꞌop ti chiꞌochoticotic ta chitometique ―xi la ti pucujetique. Ti Jesuse iyacꞌ la permiso. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ti pucujetique ilocꞌ la ta yoꞌon ti vinique, iꞌoch la ta chitometic. Ti chitometique stusus xa la yalel scotol, ipꞌajic la ta nab, ijicꞌav la scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ti jchabichitometique, ti cꞌalal iyilic ti xꞌelan ispas ti chitometique, ixiꞌic la tajmec. Ora la ba yalic ta jteclum xchiꞌuc ta parajeletic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ti crixchanoetique tal la sqꞌuelic. Ti cꞌalal icꞌotic yoꞌ bu ti Jesuse, ti vinic ochem toꞌox ep pucujetic ta yoꞌone, iyilic la ti tey xa chotol ta stsꞌel yoc ti Jesuse. Oy xa la scꞌuꞌ, lec xa la. Ixiꞌic o la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ti muchꞌutic iyilic ti cꞌuxi ilecub ti vinique, iyalbeic la ti muchꞌutic tey laj cꞌotuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ti cꞌalal iyaꞌiique ―Abulajan locꞌan echꞌel liꞌtoe ―xutic la ti Jesuse yuꞌun la ixiꞌic tajmec. Yechꞌo un iꞌochic la ta canova slajchavaꞌalic xchiꞌuquic ti Jesuse, isutic la tal ta jech nab. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","―Chajchiꞌin echꞌel ―xi la tajmec ti muchꞌu ochem toꞌox pucujetic ta yoꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Iꞌi. Batan ta ana, ba albo lachiꞌiltaque ti lascꞌuxubin xa ti Rioxe, ti ilocꞌ xa ti pucujetic ta avoꞌone ―xꞌutat la yuꞌun ti Jesuse. Ibat la ti vinique, ba la yal ta sjunlej steclumal ti iloqꞌuesbat pucujetic ta yoꞌon yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ti cꞌalal isutic tal noxtoc liꞌ ta jech nabe, tey la lamal ep crixchanoetic chmalavanic ta tiꞌnab. Xmuyubajic xa la ti tey iyul ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tey la icꞌot jun vinic yoꞌ bu ti Jesuse, Jairo la sbi. Jmeltsanejcꞌop la ta templo teyoꞌe. Isquejan la sba ta yichon ti Jesuse, jaꞌo la isnijan sba ta balamil noxtoc. ―¿Mi mu xaꞌabulaj xibatic ta jna? ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yuꞌun ta xcham xa jtseb. Yo junuc o. Lajcheb xa sjabilal ―xut la ti Jesuse. Ti Jesuse ibat la. Tey la napꞌalic echꞌel slajchavaꞌalic xchiꞌuc epal crixchanoetic, snetꞌnetꞌ xa la sbaic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Oy la jun ants, slajchebal xa la jabil ti mu xmac xchamele. Ep la isaꞌ jpoxtavanej, muc la xqꞌuele lec, muc la xmac o ti xchamele. Ilaj la scotol ti staqꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ti antse napꞌal la ibat ta spat ti epal crixchanoetique, ispitsꞌ la sba jelavel, ista la ta picbel sne spimilcꞌuꞌ ti Jesuse. Ti cꞌalal ispique, ora la imac ti xchamele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","―¿Muchꞌu ti lispique? ―xi la ti Jesuse. ―Muc xquilticotic ―xi la scotolic. ―Jchanubtasvanej, tol chnetꞌvan chavil li crixchanoetique. Chasnetꞌot tal ta jujot. ¿Cꞌu yuꞌun ti chajacꞌ ti muchꞌu laspique? ―xi la xchiꞌuc xchiꞌiltac li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","―Oy muchꞌu lispic yuꞌun icaꞌi ti oy muchꞌu iꞌechꞌ xa xchamel ta jyuꞌele ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ti antse mu ox la scꞌan xvinaj ti yaloje. Ti cꞌalal iyaꞌi ti ivinaj xae, xtꞌeltꞌon xa la ta xiꞌel. Tey la ta oꞌlol crixchanoetic isquejan la sba ta yichon ti Jesuse, jaꞌo la isnijan sba ta balamil noxtoc. Jamal la iyalbe ti ta scoj chamel ti ispicbe spimilcꞌuꞌe, ti jaꞌ ilecub o ti cꞌalal ispique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","―Ants, yuꞌun achꞌun ti oy jyuꞌele, yechꞌo ti lecot xae. Mu cꞌu xal avoꞌon, batan ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ti cꞌalal yolel chloꞌilaj ti Jesuse, jaꞌo la ital jun ti muchꞌutic tey ta sna ti jmeltsanejcꞌope. ―Icham xa latsebe. Yech xa noꞌox chba yacꞌ svocol li Jchanubtasvaneje ―xut la yulel ti Jairoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","―Mu xavat avoꞌon. Jaꞌ noꞌox chꞌuno ti oy jyuꞌele. Ta xchaꞌcuxi latsebe ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ti cꞌalal icꞌot ta sna Jairo ti Jesuse, mu la scꞌan xchiꞌin ochel ep crixchanoetic, jaꞌ no la iyicꞌ ochel li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juane, xchiꞌuc ti stot smeꞌ tsebe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Oy la muchꞌutic tey ch-oqꞌuic ta pana. ―Mu xaꞌoqꞌuic. Li tsebe muc bu chamem, ta xvay noꞌox ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tseꞌej la xaꞌi scotolic ti xꞌelan iyale yuꞌun la snaꞌojic ti ichame. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ti Jesuse iꞌoch la echꞌel yoꞌ bu telel ti ánimae, istsacbe la scꞌob ti tsebe, tsots la icꞌopoj. ―Tseb, lican ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ora la ichaꞌcuxi ti tsebe, ilic la. ―Acꞌbeic sveꞌel ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ti stot smeꞌ tsebe xchꞌayet xa la yoꞌonic. ―Mu me muchꞌu xavalbeic ti ichaꞌcuxi latsebique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Li lajchavoꞌe itsobatic la yuꞌun ti Jesuse. Iꞌacꞌbat la syuꞌelic ti xuꞌ tsloqꞌuesbeic pucujetic ta yoꞌon li xchiꞌilique, xchiꞌuc ti ta xetꞌesic chamele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Itaqueic la echꞌel, ba la yalbe xchiꞌilic ti chlic xa pasvanuc ta mantal ti Rioxe, ba la yetꞌesbeic xchamel ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iꞌalbatic la ti mu yaꞌuc yichꞌic ti cꞌusitic chtun yuꞌunic ta bee. ―Mu me xavichꞌ echꞌel anamteꞌic, mi jaꞌuc anutiꞌic, mi jaꞌuc aveꞌelic, mi jaꞌuc ataqꞌuinic. Mi jaꞌuc xavichꞌ echꞌel chaꞌqꞌuex acꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ti bu nail chcꞌot achꞌamunique, teyanic o me. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mi oy bu jteclumal mu xacꞌ ta chꞌom snaique, locꞌanic teyoꞌe. Lilinic comel spucucal avoquic, jaꞌ seña ti chcom ta sba stuquic ti mu xchꞌunic pasel ta mantal yuꞌun ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iloqꞌuic la echꞌel, iꞌechꞌic la ta jujun parajel, iyalbe la ti xchiꞌilique ti chlic xa pasvanuc ta mantal ti Rioxe. Iyetꞌesbeic la xchamelic ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti covierno Erodese iyaꞌi la ti ep cꞌusitic tspas ti Jesuse. Mu xa la snaꞌ lec cꞌusi tsnop yuꞌun la oy jlom iyalic ti jaꞌ ichaꞌcuxi ti Juan jꞌacꞌ-ichꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","―Jaꞌ nan ti jꞌalcꞌop Elias ti ta más voꞌnee ―xiic la jlom. ―Jaꞌ nan ichaꞌcuxi junuc ti yajꞌalcꞌop Riox ti ta más voꞌnee ―xiic la jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","―Voꞌon ijloqꞌues mantal ti iyichꞌ tuchꞌbel sjol ti Juane. ¿Muchꞌu van taje ti chcaꞌibe scꞌoplal ti lec cꞌusitic tspase? ―xi la ti Erodese. Ti Erodese tscꞌan la tsqꞌuelbe sat ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ti cꞌalal isutic tal li apoxtoletique, yul la yalbeic ti Jesuse ti cꞌusitic ispasique. ―Jqꞌuej jbatic echꞌel ta xocol balamil ―xꞌutatic la yuꞌun ti Jesuse. Ibatic la ta stsꞌel jun jteclum Betsaida sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ti cꞌalal iyaꞌi ti crixchanoetique, ba la staic. Ti Jesuse lec la iyaꞌi ti icꞌotic ti crixchanoetique. Iyal la ti chlic xa pasvanuc ta mantal ti Rioxe. Iyetꞌesbe la xchamelic ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ti cꞌalal imal cꞌacꞌale, istsob la sbaic tal li lajchavoꞌe. ―Lavi nopol noꞌox li parajeletique, más lec taco echꞌel li crixchanoetique, acꞌu ba xchꞌamunic na, acꞌu ba sman sveꞌelic. Liꞌ ta xocol balamile mu cꞌusi oy ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","―Macꞌlinic voꞌoxuc ―xꞌutatic la. ―Mu cꞌusi oy cuꞌunticotic. Cꞌajom noꞌox voꞌpꞌej pan xchiꞌuc chaꞌcot choy. Jaꞌ noꞌox mi chba jmanbeticotic tale ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Oy la voꞌmiluc viniquetic ti tey lamale. ―Albeic li crixchanoetique ti acꞌu chotlicuc ta cincuentatique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iyalbeic la ti crixchanoetique, jaꞌ la yech ichoti scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ti Jesuse jaꞌ la ixchꞌam ti voꞌpꞌej pane xchiꞌuc ti chaꞌcot choye. Isqꞌuel la vinajel, “colaval” xut la ti Rioxe. Jaꞌo la ixut ti pane, ixchꞌac la noxtoc ti choye, iꞌacꞌbatic la li lajchavoꞌe. Li lajchavoꞌe jaꞌ xa la iyacꞌbeic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iveꞌ la scotolic, lec la inojic. Li lajchavoꞌe istsobic la ti pane xchiꞌuc ti choye ti cꞌu yepal muc xlaj yuꞌun ti crixchanoetique. Inoj la lajcheb moch ti sovrae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ti jꞌechꞌele isqꞌuej la sbaic xchiꞌuc ti Jesuse yuꞌun la stuc ba scꞌopon Riox. Ti cꞌalal laj scꞌopon Rioxe ―¿Cꞌusi van cabtel yalojic li jchiꞌiltactique? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","―Jlom chalic ti Juan acꞌ-ichꞌvoꞌote. Jlom chalic ti Elíasote. Jlom chalic ti yajꞌalcꞌopot Riox ti ta más voꞌnee ti yuꞌun nan ichaꞌcuxie ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―Li voꞌoxuque ¿cꞌusi cabtel ti avalojique? ―xꞌutatic la. ―Voꞌot Cristoot ti yaloj Riox chapasoticotic ta mantale ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","―Mu to me muchꞌu xavalbeic ti cꞌusi cabtele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","’Voꞌon ti coꞌol crixchanootique jnaꞌoj ti ta onox xcacꞌ jvocole. Mu xiyichꞌic ta mucꞌ li jmeltsanejcꞌopetique xchiꞌuc li totil paleetique, xchiꞌuc li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Jaꞌ chiyaqꞌuic ta milel, chimuque, ta yoxibal cꞌacꞌal chichaꞌcuxi ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ti Jesuse jaꞌ la yech lic yalbe scotol ti crixchanoetique: ―Ti muchꞌutic chiyichꞌic ta muqꞌue mu me cꞌuxuc ta yoꞌon spat xoconic. Acꞌu cuchuc yuꞌunic ilbajinel scotol cꞌacꞌal chac cꞌu chaꞌal ta xcuch cuꞌun li voꞌone, acꞌu mi jaꞌ xlajic o. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ti muchꞌutic mu xiyichꞌic ta muqꞌue ti jaꞌ chiꞌic o li milele, yuꞌun onox ta xꞌochic ta cꞌocꞌ ta sbatel osil. Yan ti muchꞌutic muc ta alel yuꞌunic mi jaꞌ xlajic oe, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mi jaꞌ noꞌox ta avoꞌonic li cꞌusitic oy ta sba balamile, mu cꞌusi bal o yuꞌun chaꞌochic onox ta cꞌocꞌ ta sbatel osil. Acꞌu mi jcꞌulejoxuc tajmec liꞌ ta sba balamile, pero mu xuꞌ chaman abaic loqꞌuel li ta cꞌoqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mi chaqꞌuexavic ta yalel ti avichꞌojicon ta muqꞌue, mi chaqꞌuexavic ta yalel aꞌyuc li cꞌusitic chcale, jaꞌ noꞌox yechon uc, voꞌon ti coꞌol crixchanootique, “leꞌe maꞌuc jchꞌamal”, chichi ti cꞌalal xital xchiꞌuc syuꞌel ti Jtote xchiꞌuc ti anjeletic ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta melel chacalbeic, lavi jayvoꞌ liꞌoxuque, oy mu toꞌox chachamic ti cꞌalal xlic pasvanuc ta mantal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Laj xaꞌox nan vaxaquibuc cꞌacꞌal ti yech iyal ti Jesuse, jaꞌo la ba scꞌopon Riox ta jpꞌej vits. Jaꞌ la iꞌiqꞌueic echꞌel li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ti cꞌalal yolel la tscꞌopon Riox ti Jesuse, ijel la ti sate. Ti scꞌuꞌe xlebebet xa la saquil, sac la tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jaꞌo la ivinaj chaꞌvoꞌ moletic, tey la chloꞌilajic xchiꞌuc ti Jesuse. Jaꞌ la ti Moisese xchiꞌuc ti Eliase, jaꞌic ti yajꞌalcꞌoptac Riox ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oy la xojobalic uc. Ti cꞌusi iyalic xchiꞌuc ti Jesuse, jaꞌ la iyalic ti cꞌu xꞌelan ta xcham tey ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Li Pedroe xchiꞌuc li xchiꞌiltaque tey la chnicavic, pero ivicꞌ o la satic. Iyilbeic la xojobal ti Jesuse xchiꞌuc ti chaꞌvoꞌ moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ti cꞌalal iyilic ti ta xaꞌox xbatic ti chaꞌvoꞌ moletique ―Jchanubtasvanej, lec ti liꞌotic oe. Ta jmeltsanticotic oxpꞌejuc sucbil yanal teꞌ; jpꞌej avuꞌun, jpꞌej yuꞌun Moisés, jpꞌej yuꞌun Elías ―xut la Jesús li Pedroe. Mu la snaꞌ ti cꞌusi iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ti cꞌalal yolel chloꞌilaj li Pedroe, jaꞌo la ital lumal toc, ibutꞌij la scotolic. Ixiꞌic la tajmec ti cꞌalal ibutꞌijic ta lumal toque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iyaꞌiic la icꞌopoj ta yut lumal toc ti Rioxe. ―Liꞌi jaꞌ Jchꞌamal. Jcꞌanoj tajmec. Xachꞌunbeic me li cꞌusitic chayalbeique ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ti cꞌalal laj cꞌopojuc ti Rioxe, stuc xa la tey vaꞌal iyilic ti Jesuse. Li oxvoꞌe mu la muchꞌu iyalbeic ta ora ti cꞌusi iyilique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta yocꞌomal ti cꞌalal iyalic tal ta vitse, ep la crixchanoetic ba snupic ta be ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tey la xchiꞌuquic jun vinic. Iꞌavan la. ―Jchanubtasvanej, abulajan cꞌuxubinbon li jcreme yuꞌun yo junuc o. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuꞌun ch-ilbajinat tajmec yuꞌun pucuj. Ta xꞌavan, ta xtꞌelelinat tajmec, ta spotspotsvocan ye. Yech xa xpichꞌtepichꞌte chaꞌi ti cꞌalal xꞌechꞌ juliquele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Icalbe xa lavajchancꞌoptaque ti acꞌu sloqꞌuesic ti pucuje, pero muc xlocꞌ yuꞌunic ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","―¿Mi mu to bu achꞌunojic yaꞌel ti oy syuꞌel ti Rioxe cheꞌe? ¿Cꞌu to onox ora chachꞌunic yaꞌel ti voꞌne xa liꞌ jchiꞌucoxuque, ti jal xa lajtsꞌicbeique? ―xꞌutatic la slajchavaꞌalic yuꞌun ti Jesuse. ―Icꞌo tal lacreme ―xꞌutat la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ti cꞌalal inopoj tal ti creme, ijipe la ta lum, itꞌelelinat la tajmec yuꞌun ti pucuje. Ti Jesuse isloqꞌues la ti pucuje, ilecub la ti creme. ―Icꞌo echꞌel lacreme ―xꞌutat la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Xchꞌayet xa la yoꞌonic scotolic ti cꞌalal iyilic ti tsots syuꞌel ti Rioxe. Ti cꞌalal chꞌayem o yoꞌonic scotolic ti cꞌusi ispas ti Jesuse, jaꞌo la iꞌalbatic li lajchavoꞌe: ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Aꞌyic me li cꞌusi chacalbeique, mu me xchꞌay xavaꞌiic. Voꞌon ti coꞌol crixchanootique chiꞌaqꞌue entrucal ta stojol crixchanoetic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Muc la xaꞌibeic smelol ti xꞌelan iyale yuꞌun la muc xꞌacꞌbat yaꞌibeic smelol yuꞌun ti Rioxe. Ixiꞌic la ta sjaqꞌuel cꞌusi smelol ti xꞌelan iꞌalbatique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","―¿Muchꞌu van junucal ta xcom cuꞌuntic ta cajpasmantaltic? ―xut la sbaic li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ti Jesuse yiloj la ti cꞌusi tsnopique, jaꞌo la isnit tal jun cꞌox crem, isvaꞌan la ta xocon. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","―Ti muchꞌutic ta xchanubtasic ta jcꞌop li muchꞌu jaꞌ yech yoꞌon cꞌu chaꞌal yoꞌon li cꞌox liꞌi, chvinaj ti voꞌon chiyichꞌic ta muqꞌue. Jaꞌ noꞌox yech chichꞌic ta mucꞌ yaꞌel ti Jtot uque yuꞌun jaꞌ listac tal. Jaꞌ noꞌox yechoxuc uc, jaꞌ chcom ta avajpasmantalic ti muchꞌu mu snaꞌ xacꞌ sba ta ichꞌel ta muqꞌue ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","―Jchanubtasvanej, oy muchꞌu iquilticotic ti tsloqꞌuesbe pucujetic ta yoꞌon li crixchanoetique. Ta sloqꞌues abi ti cꞌalal ta sloqꞌues ti pucuje. Pero ijpajesticotic yuꞌun muc bu jchiꞌintic o ―xut la Jesús li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","―Mu me xapajesic. Acꞌu mi muc bu jchiꞌintic, mi mu xiscrontainotique, yuꞌun lec chiyilotic ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ti cꞌalal poꞌot xaꞌox la xbat ta vinajel ti Jesuse ―Batic ta Jerusalén ―xꞌutatic la slajchavaꞌalic. Ti Jesuse mu la bu xiꞌem ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Istac la jelavel mantal ta estado Samaria. Tey la icꞌotic ta jun parajel. Ta ox la xchꞌamunic na, ta ox la sman sveꞌelic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ti jsamariaetique muc la xacꞌ ta chꞌom snaic yuꞌun la iyaꞌiic ti chbatic cꞌalal Jerusalén xchiꞌuquic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Li Jacoboe xchiꞌuc li Juane, ti cꞌalal iyilic ti mu xacꞌ ta chꞌom snaique ―Cajval, ¿mi chacꞌan ti chcalticotic mantal ti acꞌu yaluc tal cꞌocꞌ ta vinajele yoꞌ xlajic o ti cꞌu chaꞌal ispas ti Elíase? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iqꞌuelbat la sat xchaꞌvaꞌalic yuꞌun ti Jesuse. ―Ti xꞌelan chavalique, maꞌuc Riox chayalbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Voꞌon ti coꞌol crixchanootique, mu milvanejuc talem jpas. Tal jtojbe smulic yoꞌ mu xꞌochic o ta cꞌocꞌ ta sbatel osile ―xꞌutatic la yuꞌun ti Jesuse. Ti cꞌalal laj albaticuc yeche, ibatic la ta yan o parajel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ti cꞌalal yolel chanavique ―Cajval, chajchiꞌin echꞌel ti butic chabate ―xꞌutat la yuꞌun jun vinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","―Li vete oy xchꞌen, li mute oy stsoꞌop. Voꞌon ti coꞌol crixchanootique chꞌabal jna. Nopo lec mi chachiꞌinon echꞌele ―xꞌutat la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","―Laꞌ, batic ―xut la jun o vinic ti Jesuse. ―Cajval, acꞌon to echꞌel. Jaꞌto chtal jchiꞌinot ti cꞌalal xcham li jtote ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","―Ti muchꞌutic mu xiyichꞌic ta muqꞌue, chamemic yaꞌel. Tey acꞌu smuc sba stuquic. Li voꞌote ba albo yaꞌi li crixchanoetique ti chlic xa pasvanuc ta mantal ti Rioxe ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","―Cajval, coꞌonuc ba jchiꞌinot, pero acꞌon to echꞌel yuꞌun chba to jcꞌopon comel li muchꞌutic tey ta jnae ―xi la otro jun. ");
INSERT INTO tzoZNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","―Mi mu sjunuluc avoꞌon chachꞌun li cꞌusi chacalbee, coꞌolot xchiꞌuc li muchꞌu jot o sqꞌueloj cꞌalal tsvocꞌ yosil ta aradoe. Tey mu teyuc yoꞌon ch-abtej. Ti Rioxe jaꞌ tscꞌan ti sjunul coꞌontic ta jchꞌuntic cꞌusi chiyalbotique ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tsꞌacal to istꞌuj la yan setenta jꞌisraeletic ti Cajvaltic Jesuse. Ta chaꞌchaꞌvoꞌ la istac echꞌel ta jujun jteclum xchiꞌuc ta jujun parajel yuꞌun la snopoj onox ti tey ch-echꞌ ta tsꞌacale. Lec la ipꞌijubtasatic echꞌel yuꞌun ti Cajvaltic Jesuse: ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","―Ta melel ti ep ti muchꞌutic tscꞌan chaꞌiic li scꞌop Rioxe. Pero jaꞌ jutuc noꞌox ti muchꞌutic chalic aꞌyuque. Coꞌol xchiꞌuc mi ep li cꞌajoje, jaꞌ jutuc noꞌox li jcꞌajome. Yechꞌo un cꞌanbeic ti Rioxe ti acꞌu stac echꞌel ti muchꞌutic chba yalic aꞌyuc li cꞌusi yaloje yuꞌun jaꞌ tstꞌuj stuc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chajtaquic echꞌel chac cꞌu chaꞌal chijetic ti tey chcꞌot staic oqꞌuiletique, yuꞌun tey chcꞌot ataic jchiꞌiltactic ti yoꞌonuc smiloxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mu me xavichꞌ echꞌel ataqꞌuinic, mi jaꞌuc amorralic, mi jaꞌuc yan axonobic. Mu me muchꞌu jal xaloꞌilaj achiꞌuquic ta be. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ti bu jpꞌejucal na chachꞌamunique, “Junuc avoꞌonic”, xavutic cꞌotel li yajval nae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi tscꞌan ti jun yoꞌonique, ta onox staic. Mi iꞌie, mu onox staic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ti bu nail chachꞌamunique, teyanic o me, mu me xajelulanic. Ti cꞌusitic chaꞌacꞌbat alajesique, mu me xapꞌajic. Li muchꞌu chba yal aꞌyuc li cꞌusi chcale tey tsta sveꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ti bu jteclumal chacꞌ ta chꞌom snaique, ti cꞌusi chaꞌacꞌbat alajesique, mu me xapꞌajic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ti muchꞌutic ip teyoꞌe etꞌesbeic xchamelic. “Liꞌ xa me ti Rioxe, tscꞌan chaspasic ta mantal yuꞌun jaꞌ ta syuꞌel ti iꞌechꞌ lachamelique”, xavutic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ti bu jteclumal mu xacꞌ ta chꞌom snaique, locꞌanic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Liꞌ ta jlilinticotic comel spucucal cocticotic ti liꞌ ta alumalic ijtaticotique. Jaꞌ seña ti chcom ta aba atuquic ti muc xachꞌunic pasel ta mantal yuꞌun ti Rioxe. Mu xa xuꞌ xavalic ti muc xavaꞌiique”, xavutic comel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chacalbe avaꞌiic, ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, más castico chichꞌic li jchiꞌiltactic ti bu jteclumal mu xacꞌ ta chꞌom snaique. Jaꞌ jutuc noꞌox castico chichꞌic ti jsodomaetic ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Li jchiꞌiltactic ta jteclum Corazine xchiꞌuc ta jteclum Betsaidae, iyilic jayꞌechꞌel ti oy jlequilal jyuꞌelale, pero muc xiyichꞌic o ta mucꞌ. Yechꞌo un ta onox xichꞌic castico ta sbatel osil. Ti jtiroetique xchiꞌuc ti jsidonetic ti ta más voꞌnee, muc xilic li jlequilal jyuꞌelale. Ti iyilicuque, islapic jalbil tsatsal chivo ti chꞌixaltic ta lapele, ixchotan sbaic ta tanil tiꞌ cꞌocꞌ ti yechuque. Jaꞌ seña ti chat o yoꞌonic ti cꞌusitic chopol spasojique yuꞌun chictaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, jaꞌ más castico chichꞌic li jchiꞌiltactic ta Corazine xchiꞌuc ta Betsaida lavie. Jaꞌ jutuc noꞌox castico chichꞌic ti jtiroetique xchiꞌuc ti jsidonetic ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Li jchiꞌiltactic ta Capernaume, chalic ti jaꞌ chichꞌic crasiae pero mu xꞌacꞌbatic. Yuꞌun iyilic jayꞌechꞌel ti oy jlequilal jyuꞌelale pero muc xiyichꞌic o ta mucꞌ. Yechꞌo un ta onox xichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Ti muchꞌutic ta xchꞌunic ti cꞌusi chavalic aꞌyuque, coꞌol xchiꞌuc voꞌon chixchꞌunbeic yaꞌel. Ti muchꞌutic mu xchꞌunique, coꞌol xchiꞌuc voꞌon mu xixchꞌunbeic yaꞌel. Jaꞌ noꞌox yech mu xchꞌunbeic yaꞌel ti Jtot uque yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ti setenta itaqueic echꞌele jun la yoꞌonic isutic tal. ―Cajval, maꞌuc noꞌox iquetꞌesticotic chamel ta ayuꞌel; cꞌalal ta pucujetic ijloqꞌuesticotic ―xutic la yulel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Itacꞌav la ti Jesuse: ―Iquil ti ora ichꞌay syuꞌel ti Satanase coꞌol xchiꞌuc cꞌalal xlebluj li chavuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Voꞌon lacacꞌbe ayuꞌelic yoꞌ mu xcuch o yuꞌun li jcrontatique, yoꞌ mu cꞌu xaxchaꞌleic oe. Acꞌu mi oy bu xateqꞌuic quiletel chon, acꞌu mi tsec, jaꞌ noꞌox yech mu cꞌusi xuꞌ chaxchaꞌleic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mu me jaꞌuc noꞌox jun o avoꞌonic ti ta xchꞌun amantalic ti pucujetique. Jaꞌ me junuc o avoꞌonic ti tsꞌibabil xa abiic ta vinajele ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti Jesuse xmuyubaj xa la xchiꞌuc ti Chꞌul Espíritue. Jaꞌo la iscꞌopon Riox: ―Tot, voꞌot yajvalot vinajel balamil. Colaval ti muc xavacꞌ yaꞌibeic smelol cꞌusi ical cꞌusi ijpas ti muchꞌutic pꞌij ti yalojique, ti jaꞌ noꞌox avacꞌ yaꞌibeic smelol ti muchꞌutic tscꞌanic coltael chac cꞌu chaꞌal tscꞌanic coltael li cꞌoxetique. Lec ti jaꞌ yech apase, Tot ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ti Jesuse jaꞌ la yech lic yalbe ti crixchanoetique: ―Ti Jtote yacꞌojbon entrucal scotol ti cꞌusitic oye. Muc muchꞌu snaꞌ cꞌu xꞌelan li coꞌone, jaꞌ noꞌox snaꞌoj ti Jtote. Jaꞌ noꞌox yech ti Jtot uque, muc muchꞌu snaꞌbe cꞌu xꞌelan yoꞌon. Jtuc noꞌox jnaꞌojbe. Jaꞌ noꞌox ta snaꞌic uc ti muchꞌutic chcalbeique ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Li lajchavoꞌe slecoj la icꞌoponatic yuꞌun ti Jesuse: ―Li voꞌoxuque layacꞌbeic xa bentisyon ti Rioxe yechꞌo ti avilic xa li cꞌusitic ijpase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chacalbe avaꞌiic. Ep yajꞌalcꞌoptac Riox xchiꞌuc ep preserenteetic ti ta más voꞌnee ti tscꞌan ox tsqꞌuelic cꞌusi ta jpase, pero muc xa xilic. Tscꞌan ox chaꞌiic ti cꞌusi chcale, pero muc xa xaꞌiic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tey la jun ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, isvaꞌan la sba, oy la cꞌusi isjacꞌbe ti Jesuse yoꞌ la stabe o smul ti yaloje. ―Jchanubtasvanej, ¿cꞌusi ta jpas yoꞌ xicuxi o ta sbatel osile? ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","―¿Cꞌusi tsꞌibabil ta mantaletique cheꞌe? ¿Cꞌusi chal aviloj cheꞌe? ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","―“Cꞌanic me ta sjunul avoꞌonic ti Rioxe. Jaꞌ acꞌu tunuc yuꞌun lapꞌijilique xchiꞌuc lavipique. Cꞌuxubino me achiꞌiltac chac cꞌu chaꞌal chacꞌuxubin aba atuque”, xi li mantale ―xi la ti jchanubtasvanej yilele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","―Lec latacꞌav. Mi chapas chac taje, chacuxi ta sbatel osil ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ti jchanubtasvanej yilele ta ox la spoj sba. ―¿Muchꞌu li jchiꞌile? ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ti Jesuse iyalbe la chac cꞌu chaꞌal jun loꞌil noꞌox. ―Caltic noꞌox yaꞌel ti oy jun jchiꞌiltic ilocꞌ ta Jerusalene, ibat ta Jericó. Isnup ta be jꞌeleqꞌuetic. Iꞌelcꞌanbat scotol li cꞌusuc yuꞌune cꞌalal ta scꞌuꞌ. Imaje, iyayij tajmec. Li jꞌeleqꞌuetique ibatic. Li vinique chamem icom ta majel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta jliquel o iꞌechꞌ jun pale. Sqꞌuel noꞌox comel ti tey puchꞌul li xchiꞌile, ijelav echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jaꞌ noꞌox yech iꞌechꞌ jun levita, xchiꞌil ta abtel paleetic. Sqꞌuel noꞌox comel ti tey puchꞌul li xchiꞌile, ijelav echꞌel uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Jaꞌ noꞌox yech tey iꞌechꞌ jun jsamaria nom chbat. Ti cꞌalal iyile, icꞌuxubaj ta yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inopoj yoꞌ bu puchꞌule. Ispoxtabe li syayijemaltaque, isjaxbe jsetꞌ aceite xchiꞌuc bino, isvolbe ta pocꞌ. Jaꞌo iscajan ta sburro, iyicꞌ echꞌel ta otel, tey ixchabi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta yocꞌomal ti cꞌalal chlocꞌ xaꞌox echꞌel li jsamariae, iyacꞌbe comel chib denario li yajval otele. “Qꞌuelbon me li vinique. Mi oy cꞌusi más ilaj avuꞌune, tey chajtojbe ti cꞌalal xisut tale”, xut comel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Li voꞌote ¿muchꞌu junucal xanaꞌ ta yoxvaꞌal ti ispꞌis ta xchiꞌil li vinic ti imaje comel yuꞌun li jꞌeleqꞌuetique? ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","―Jaꞌ li muchꞌu icꞌuxubinvane ―xi la ti muchꞌu ta xchanubtasvan yilel ta smantaltac Rioxe. ―Batan, ba cꞌuxubinvanan yech uc cheꞌe ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Istam la echꞌel sbe noxtoc ti Jesuse, icꞌot la ta jun parajel. Tey la nacal jun ants, Marta la sbi. Iꞌiqꞌue la ochel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ti Martae oy la smuc, María la sbi. Ti Maríae tey la tal chotluc ta stsꞌel yoc ti Jesuse yuꞌun la chaꞌi cꞌusi chal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ti Martae sujem xa la tspas ti cꞌusi chacꞌbe ti jvulaꞌal tey icꞌote. ―Cajval, ¿mi lec chavil ti jtuc noꞌox chacꞌ cꞌu jpas li jmuque? Albo acꞌu scoltaon ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","―Marta, jaꞌ noꞌox yatel avoꞌon li cꞌusitic chapase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero jtos noꞌox li cꞌusi tsots scꞌoplale, jaꞌ li cꞌusi chcale. Li Maríae jaꞌ xa istꞌuj li cꞌusi más tsots scꞌoplale. Muc muchꞌu xuꞌ chpajeson ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ti jꞌechꞌele iscꞌopon la Riox ti Jesuse. Ti cꞌalal laj scꞌopone ―Cajval, chanubtasoticotic ta scꞌoponel ti Riox uque chac cꞌu chaꞌal ixchanubtas yajchancꞌoptac ti Juan jꞌacꞌ-ichꞌvoꞌe ―xi la jun li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","―Ti cꞌalal chacꞌoponic Rioxe, xavalic chac liꞌi: Tot, Cajval, teyot ta vinajel, acꞌu quichꞌoticotic ta mucꞌ jcotolticotic liꞌ ta sba balamile. Jaꞌ ta jcꞌanticotic ti chapas mantal atuc liꞌ ta sba balamile. Ta vinajele jaꞌ tspasic li cꞌusitic lec chavile. Jaꞌ noꞌox yech acꞌu jpasticotic liꞌ ta sba balamil li cꞌusitic lec chavile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Acꞌbon jveꞌelticotic lavie. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Acꞌboticotic pertonal yuꞌun jmulticotic yuꞌun icacꞌbeticotic xa pertonal li muchꞌutic ista smul cuꞌunticotique. Coltaoticotic yoꞌ mu jpasticotic o li cꞌusitic chopole, xachiic ti cꞌalal chacꞌoponic Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ti Jesuse iyal la jun loꞌil: ―Caltic noꞌox yaꞌel ti oy muchꞌu lec xacꞌopon aba achiꞌuquique, tey chacꞌot ta sna ta ol acꞌubal. “¿Mi jaꞌ noꞌox mu jqꞌuextic oxpꞌejuc apan? ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yuꞌun naca to iyul jvulaꞌal ta jna. Yuꞌun mu cꞌusi xcacꞌbe slajes”, xavut cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Mu jcꞌan xtal atijbon jvayel yuꞌun jmacoj xa lec li stiꞌ jnae. Yuꞌun vayemoticotic xa xchiꞌuc jchꞌamaltac, yechꞌo un mu xuꞌ xlic cacꞌbot”, xi chastacꞌbe ta yut sna. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Acꞌu mi lec xacꞌopon aba achiꞌuc pero mu scꞌan xlic yacꞌbot. Pero mi mu xavicta aba ta scꞌanulanbele, chlic yacꞌbot ti cꞌusitic chtun avuꞌune yuꞌun chaꞌi ti chtune. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaꞌ noꞌox yech mi mu xavicta abaic ta scꞌanulanbel ti Rioxe, ta onox xayacꞌbeic li cꞌusitic chacꞌanique. Coꞌol xchiꞌuc li muchꞌu tsaꞌ cꞌusi chtun yuꞌune, tsta. Coꞌol xchiꞌuc li muchꞌu chcꞌopoj ta tiꞌnae, chtacꞌbat. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Li muchꞌutic mu xicta sba ta scꞌanele, ch-acꞌbatic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Li voꞌoxuque, ti cꞌalal chascꞌanbeic pan lachꞌamalique, maꞌuc ton chavacꞌbeic. Ti cꞌalal chascꞌanbeic choye, maꞌuc chon chavacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ti cꞌalal chascꞌanbeic ton caxlane, maꞌuc tsec chavacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Li voꞌoxuque chopol ajolic pero xanaꞌic cꞌusi lec chavacꞌbeic lachꞌamalique. Ti Jtotic Riox ta vinajele más lec cꞌusi chayacꞌbeic mi chacꞌanbeique. Chacꞌbe Chꞌul Espíritu ti muchꞌutic tscꞌane ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ti Jesuse isloqꞌuesbe la pucuj ta yoꞌon jun umaꞌ. Jaꞌ la pasem o ta umaꞌ ti ochem pucuj ta yoꞌone. Ti cꞌalal ilocꞌ ti pucuje, ijam la ti yee. Ti crixchanoetique xchꞌayet xa la yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","―Li vinic leꞌe ta syuꞌel totil pucuj ti tsloqꞌues pucujetic ti ochem ta yoꞌonic li crixchanoetique ―xiic la jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ti jlome iyalbeic la ti Jesuse: ―Acꞌo quilticotic mi yech ti oy ayuꞌele. Jqꞌueltiquic mi oy cꞌusi xyal tal avuꞌun ta vinajel ―xutic la yoꞌ la stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ti Jesuse yiloj onox la ti cꞌusi tsnopique. ―Mi tscrontain sbaic jun preserente xchiꞌuc li xchiꞌiltac ta meltsanejcꞌope, ta xchꞌac o sbaic. Mi chut sbaic li jchop jnaclomale, ta xchꞌac o sbaic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jaꞌ noꞌox yech ti Satanase, mi tsloqꞌues xchiꞌil ta pucujal ti ochem ta yoꞌonic li crixchanoetique, ¿cꞌu ma xi tspas mantal ti mi yech tspase? Ti xꞌelan chacalbeique, yuꞌun chavalic ti ta syuꞌel totil pucuj ti ta jloqꞌues ti pucujetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti yechuc xavalique, ¿muchꞌu ma ta syuꞌel ta sloqꞌues pucujetic lavajchancꞌopic uque? Lavajchancꞌopique xuꞌ chalic ti maꞌuc yech li cꞌusi chavalique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Li voꞌone ta syuꞌel Riox ta jloqꞌues pucujetic, jaꞌ chvinaj o ti liꞌ xa tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Caltic noꞌox yaꞌel ti oy jun tsatsal vinique ti lec chapale, muc muchꞌu xuꞌ chpojbon li cꞌusuc yuꞌun ta snae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero mi ital li muchꞌu más tsotse, ta xcuch yuꞌun spojbel li yabtejebe ti jaꞌ spatoj o yoꞌone, ta onox xpojbat li cꞌusuc yuꞌune. Ti Satanase coꞌol xchiꞌuc tsatsal vinic yaꞌel. Li voꞌone coꞌol xchiꞌuc li muchꞌu más tsots yaꞌele yuꞌun ijpojbe xa li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ti muchꞌu chopol chil li cꞌusi ta jpase, jaꞌ jcronta. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ti cꞌalal chlocꞌ ta yoꞌon jun crixchano ti pucuje, chbat ta xocol balamil, chba saꞌ bu chnaqui, pero mu sta. “Más lec chisut echꞌel ta yoꞌon li vinique”, xi ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ti cꞌalal chcꞌote, leclectic chcꞌot sta li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yechꞌo un ti pucuje chba saꞌ tal vucvoꞌ xchiꞌil, jaꞌ ti bu chopol tajmeque. Tey ch-ochic ta yoꞌon li vinique, más to tsoc sjol tajmec ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ti cꞌalal xyaquet chloꞌilaj ti Jesuse, tey la capal jun ants ta epal crixchanoetic, iꞌavan la. ―Jun yoꞌon lameꞌe yuꞌun jaꞌ lastsꞌites ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","―Jiꞌ avaꞌucaꞌa. Pero mu xcoꞌolaj xchiꞌuc ti muchꞌutic chaꞌiic li scꞌop Rioxe ti ta xchꞌunique. Más to jun yoꞌonic ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ti cꞌalal xyaquet tstsob sbaic cꞌotel más ep crixchanoetique, lic la yal ti Jesuse: ―Voꞌoxuc ti cuxuloxuc lavie, chopol ajolic. Yuꞌun jaꞌ noꞌox chacꞌan chaqꞌuelic li jyuꞌele, pero muc bu chcacꞌ avilic. Jaꞌ noꞌox chavaꞌibecon jcꞌoplal chac cꞌu chaꞌal avaꞌibeic scꞌoplal ti Jonas yajꞌalcꞌop Riox ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ti Jonase iyilic ti jniniveetique ti tacbil echꞌel yuꞌun ti Rioxe. Jaꞌ noꞌox yech chavilic uc ti stacojon tal ti Rioxe, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, más castico chavichꞌic, voꞌoxuc ti cuxuloxuc lavie. Jaꞌ jutuc noꞌox castico chichꞌ ti ants preserentee ti nom ilic tal ta xocon vinajel ta sure, ti tal yaꞌibe srazón ti preserente Salomone. Li voꞌone más to jnaꞌ razón chac cꞌu chaꞌal ti Salomone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ti cꞌalal sta yora chalbe bu chbatic ta sbatel osil crixchanoetic ti Rioxe, más castico chavichꞌic voꞌoxuc ti cuxuloxuc lavie. Jaꞌ jutuc noꞌox castico chichꞌic ti jniniveetic ti ta más voꞌnee. Yuꞌun iyictaic spasel li cꞌusitic chopole ti cꞌalal iꞌalbatic scꞌop Riox yuꞌun ti Jonase. Li voꞌone más tsots cabtel chac cꞌu chaꞌal ti Jonase, pero mu xacꞌan xachꞌunic li cꞌusitic chacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Muc muchꞌu ta stsan slampara ti jaꞌo tsnaqꞌue, mi jaꞌuc tsmac ta almul. Toyol onox chacꞌ yoꞌ xilic o osil ti muchꞌutic ch-ochic ta yut nae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lasatique coꞌol xchiꞌuc alamparaic yaꞌel yuꞌun jaꞌ chavilic o mi lec, mi chopol lapat axoconique. Jaꞌ noꞌox yech li cꞌusitic chcale, jaꞌ chavilic o mi lec, mi chopol avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yechꞌo un qꞌuelo me abaic, mu me soc o ajolic li cꞌusitic leque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mi chachꞌunic li cꞌusitic chcale, chlecub o avoꞌonic. Coꞌol xchiꞌuc sacjaman yut anaic cꞌalal oy alamparaique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ti cꞌalal laj loꞌilajuc ti Jesuse, iꞌiqꞌue la echꞌel ta veꞌel yuꞌun jun jfariseo. Ti Jesuse ibat la, cꞌot la chotluc ta chotlebal yoꞌ bu ti mexae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ti jfariseoe ichꞌay o la yoꞌon ti muc spoc scꞌob ti Jesuse, ti tucꞌ la ba chotluque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ti Cajvaltic Jesuse iyalbe la ti jfariseoe: ―Li voꞌoxuque, jfariseoetic, coꞌoloxuc xchiꞌuc li muchꞌu jaꞌ noꞌox tspocbe spat li basoe xchiꞌuc li pulatue, yan li yute mu sucꞌ, oy yicꞌubal. Jaꞌ yech lecoxuc yilel pero jaꞌ noꞌox ta avoꞌonic ti cꞌusi oy lec yuꞌun lachiꞌilique. Chavalbeic ti acꞌu yaqꞌuic ta smoton Rioxe yuꞌun anaꞌojic ti voꞌoxuc chavichꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sonsooxuc tajmec yuꞌun chanopic ti muc bu yiloj avoꞌonic ti Rioxe ti jaꞌ laspasique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Más lec cꞌuxubinvananic, qꞌuelanic li cꞌusitic oy avuꞌunique yoꞌ lec xayilic o ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Li voꞌoxuque, jfariseoetic, chanopic ti jaꞌ noꞌox chanitic ta lajlajuneb li cꞌusitic chlocꞌ avuꞌunique: li alavenae, xchiꞌuc li lulae, xchiꞌuc li cꞌusitic yane. Chaloqꞌuesic jujun ti cꞌalal anitojic xaꞌox ta lajlajunebe, chavacꞌbeic ti Rioxe. Leꞌe chavaqꞌuic, pero jaꞌ muc bu lec chameltsanic li cꞌope. Mu sjunuluc avoꞌonic acꞌanojic ti Rioxe, yechꞌo un ta onox xavichꞌic castico ta sbatel osil. Más lec ti apasicuc noxtoc ti bu tsots scꞌoplale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Li voꞌoxuque, jfariseoetic, jaꞌ chacꞌanic ti bail chachotiic ta temploetique. Jaꞌ chacꞌanic ti cꞌoponbiloxuc ta chꞌivite, yechꞌo un ta onox xavichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Voꞌoxuc ti chachanubtasvanic ta smantaltac Rioxe, li voꞌoxuc uque, jfariseoetic, yech chanopic ti avichꞌojic ta mucꞌ ti Rioxe. Yuꞌun coꞌoloxuc xchiꞌuc muquenal ti mu xa xvinaje. Li muchꞌutic tey xvaꞌlajete mu snaꞌic mi oy ánima. Jaꞌ yechoxuc yaꞌel uc. Li muchꞌutic ta xchꞌunic li cꞌusi chavalique, mu snaꞌic ti coꞌol xchiꞌuc chamem chayilic ti Rioxe yuꞌun naca chopol li cꞌusitic chanopique. Yechꞌo un ta onox xavichꞌic castico ta sbatel osil ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jaꞌ la itacꞌav jun ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe: ―Jchanubtasvanej, ti xꞌelan chavale, yuꞌun chasaꞌ jmulticotic uc ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Itacꞌav la ti Jesuse: ―Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, chavalbeic lachiꞌilique ti persa ta xchꞌunique; yan li voꞌoxuque mu xachꞌunic. Coꞌol xchiꞌuc chapechꞌic icatsil ti vocol chlic ta cuchele. Jaꞌ chavacꞌbeic scuch lachiꞌilique; li voꞌoxuque mu xlic avuꞌunic. Yechꞌo un ta onox xavichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Maꞌuc noꞌox leꞌe, oy cꞌusi yan chapasic noxtoc. Chachaꞌmeltsanbeic smuquenal ti yajꞌalcꞌoptac Riox ti ta más voꞌnee ti ismilic ti amucꞌtatotique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jaꞌ chvinaj o ti lec chavaꞌiic ti imilvanique. Yechꞌo un ta onox xavichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ti Rioxe snaꞌoj onox ti yech ta xcꞌote, yechꞌo ti iyal onox chac liꞌi: “Ta jtac tal cajꞌalcꞌoptac xchiꞌuc apoxtoletic. Jlom ta smilic, jlom ta xilbajinic”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ti Rioxe voꞌoxuc chacꞌ ta abaic ti jayvoꞌ imileic tal ta spasel balamil ti yajꞌalcꞌoptaque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ti cꞌalal imile ti Abele cꞌalal to Zacarías ti ismilic ta tiꞌ mucꞌta templo yoꞌ bu stsꞌel xchicꞌobil smoton Rioxe, voꞌoxuc chcom ta abaic ti cuxuloxuc lavie. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Voꞌoxuc ti chachanubtasvanic ta smantal Rioxe, muc bu jamal chavalbeic cꞌu xꞌelan smelol li smantaltac Rioxe. Muc bu lec chachanubtasic li jchiꞌiltactique. Chapajesic ti muchꞌutic tscꞌan ta xchꞌunique yuꞌun cꞌalal ta voꞌoxuc mu xachꞌunic, yechꞌo un ta onox xavichꞌic castico ta sbatel osil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ti cꞌalal laj yal yech ti Jesuse, ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti jfariseoetique, icapic o la tajmec. Oy to la cꞌusi más isjacꞌulanbeic ti Jesuse yoꞌ la stabeic o smul ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti cꞌalal yolel chloꞌilaj xchiꞌuc jfariseoetic ti Jesuse, tey la istsob sbaic cꞌotel jaymil crixchanoetic, snetꞌnetꞌ xa la sbaic. Li lajchavoꞌe baꞌyi la icꞌoponatic yuꞌun ti Jesuse. ―Qꞌuelo me abaic ta svuquesobil xchꞌut span li jfariseoetique. Yuꞌun lec tajmec yoꞌonic yilel pero yech noꞌox tsnopic. Mu me xapasic yech li voꞌoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mi oy cꞌusi chopol chanopic lavie, chvinaj onox ti cꞌusi orae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Li cꞌusitic mucul chavalique chvinaj onox ta stojol Riox ti cꞌusi orae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Voꞌoxuc ti lec jcꞌopon jbatique, chacalbeic ti mu me xaxiꞌic o li muchꞌutic yoꞌonuc smiloxuque, yuꞌun mu staic ta milel lachꞌulelique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ti Rioxe ti jaꞌ xuꞌ chastiqꞌuic ta cꞌocꞌ xchiꞌuc achꞌulelique, jaꞌ me xavichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Li cꞌox mutetique, acꞌu mi voꞌcot ta chib taqꞌuin, pero mi jcot mu xchꞌay ta sjol ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jaꞌ noꞌox yech xchabiojoxuc uc. Cꞌalal ta stsatsal ajolic nitbil jaypꞌej. Yechꞌo un mu me xaxiꞌic. Yuꞌun más tsots acꞌoplalic yuꞌun ti Rioxe; jaꞌ jutuc noꞌox li mutetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Chacalbeic, ti muchꞌutic jamal chalbeic li crixchanoetique ti yichꞌojicon ta muqꞌue, jaꞌ noꞌox yech voꞌon ti coꞌol crixchanootique, jamal chcalbe ti Jtote xchiꞌuc ti yajꞌanjeltaque ti yichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yan ti muchꞌutic mu jamluc chalbeic li crixchanoetique ti yichꞌojicon ta muqꞌue, jaꞌ noꞌox yech chcalbe ti Jtote xchiꞌuc ti yajꞌanjeltaque ti mu xiyichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ti muchꞌutic chispꞌisic ta pucuj voꞌon ti coꞌol crixchanootique, ch-aqꞌueic to ta pertonal mi tscꞌanbeic ti Rioxe. Jaꞌ noꞌox ti muchꞌutic tspꞌisic ta syuꞌel pucuj ti Chꞌul Espíritue, mu xa xꞌaqꞌueic o ta pertonal ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ti cꞌalal chaꞌiqꞌueic echꞌel ta stojol jmeltsanejcꞌopetic ta temploetique, mu me baꞌyiuc xanopic ti cꞌusi chcꞌot avalique, ti cꞌuxi chatacꞌavique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Jaꞌ chaspꞌijubtasic ti Chꞌul Espíritue ti cꞌuxi chatacꞌavique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oy la tey jun vinic ta oꞌlol crixchanoetic, icꞌopoj la. ―Jchanubtasvanej, albo li jbanquile ti acꞌu xchꞌacbon jrasyon osile xchiꞌuc li cꞌusuc yuꞌun ti ánima jtoticotique ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","―Maꞌuc jmeltsanejcꞌopon ti ta jchꞌac li cꞌusuc avuꞌunique ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ti Jesuse jaꞌ la yech lic yalbe ti crixchanoetique: ―Qꞌuelo me abaic, mu me jaꞌuc noꞌox ta avoꞌonic li cꞌusitic oy ta sba balamile. Acꞌu mi oy ep cꞌusuc avuꞌunic pero maꞌuc chata o jun avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","’Caltic noꞌox yaꞌel ti oy jun jcꞌuleje. Ep ilocꞌ ti cꞌusitic stsꞌunoje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“¿Bu xa chlaj cacꞌan li cꞌusitic ilocꞌ ta cosile?”, xi isnop. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Iyul xa ta jol cꞌusi ta jpas. Ta jtuquibe li snailtaque, ta jmeltsan más mucꞌtic. Jaꞌ tey chcacꞌ scotol li cꞌusuc cuꞌune. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ti cꞌalal stsob sbae, mu cꞌu xal coꞌon. Oy cꞌusi ta jlajes, oy cꞌusi ta xcuchꞌ, xuꞌ jcux ti jaylajuneb jabil scꞌan coꞌone. Xlocꞌ o, yuꞌun oy ep”, xi isnop li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Sonsoot. Lavi ta acꞌubaltique chacham. Li cꞌusuc avuꞌune ¿muchꞌu ta xichꞌ comel un?” xꞌutat yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaꞌ noꞌox yech ti muchꞌutic ta stsob scꞌulejalique ti stuquic noꞌox chtun yuꞌunique, abol sba ch-ileic yuꞌun ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Li lajchavoꞌe icꞌoponatic la yuꞌun ti Jesuse: ―Chacalbe avaꞌiic, mu me xavat avoꞌonic ti cꞌuxi chacuxiic liꞌ ta sba balamile, ti cꞌuxi chaveꞌ chavuchꞌic voꞌe, ti bu chata acꞌuꞌ apoqꞌuique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yuꞌun jaꞌ layacꞌbe apat axoconic achꞌulelic ti Rioxe, yechꞌo un chacꞌ aveꞌelic, chacꞌ acꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Qꞌuelavilic li jojetique, mu snaꞌ xꞌabtejic. Mu snaꞌ xꞌovolajic, mu snaꞌ xcꞌajavic, chꞌabal stenal sveꞌelic. Jaꞌ chmacꞌlinatic yuꞌun ti Jtotic Riox ta vinajele. Ali voꞌoxuque más to chascꞌuxubinic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Acꞌu mi xavat avoꞌonic, mu xanatubic o chaꞌchꞌixuc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yuꞌun mu cꞌu xuꞌ avuꞌunic jsetꞌuc, ¿cꞌu yuꞌun ti chavat o avoꞌonic ti bu chataic li cꞌusitic chtun avuꞌunique? ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Qꞌuelavilic cꞌu slequil ta xchꞌi li nichimetique. Pero mu xꞌabtejic, mu xnavujic, mu sjal scꞌuꞌic. Chacalbe avaꞌiic, ti Salomón ti ta más voꞌnee jcꞌulej tajmec, lequic sba ti scꞌuꞌ spoqꞌue, pero mu xcoꞌolaj xchiꞌuc li nichime. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Li tsꞌiꞌlele batsꞌi yox tajmec lavie, pero ocꞌob chaꞌej chichꞌ tiqꞌuel ta jorno, chtaꞌaj o pan. Acꞌu mi muc jal ta xchꞌi li tsꞌiꞌlele pero batsꞌi yox tajmec xchaꞌle ti Rioxe. ¿Mi jaꞌ xa mu xayacꞌbeic acꞌuꞌic yaꞌel un? Yuꞌun mu to chachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yechꞌo un mu me xavat avoꞌonic ti cꞌuxi chaveꞌ chavuchꞌic voꞌe. Mu me cꞌusi xloꞌilaj o avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ti muchꞌutic mu to ta xchꞌunic li scꞌop Rioxe chat yoꞌonic. Li voꞌoxuque snaꞌoj cꞌusitic chtun avuꞌunic ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yechꞌo un chꞌunic cꞌusi chayalbeic ti Rioxe. Mi achꞌunique, chayacꞌbeic ti cꞌusitic chtun avuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Acꞌu mi muc bu epoxuc, pero mu me xaxiꞌic. Ti Rioxe ta slequil yoꞌon chayiqꞌuic ti chachiꞌinic ta pasmantale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chono scotol li cꞌusuc avuꞌunique. Li stojole acꞌbeic li meꞌonetique yoꞌ oy o acꞌulejalic ta vinajele. Teyoꞌe mu xꞌoch jꞌelecꞌ, mu xꞌoch vach chon sepꞌ acꞌuꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ti bu lacꞌulejalique, jaꞌ tey batem avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Malaicon noꞌox me chac cꞌu chaꞌal smalaojic ta sut tal ta nupunel yajvalic li mozoiletique ti slapoj noꞌox scꞌuꞌique, ti stsanoj noꞌox slamparaique. Ti cꞌalal xul cꞌopojuc ta stiꞌ sna li ajvalile, jliquel tsjambeic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jun yoꞌonic tajmec ti cꞌalal julavem chul staelic yuꞌun li yajvalique. Chacalbe avaꞌiic. Ta xcholatic ta mexa yuꞌun li yajvalique, ch-acꞌbat sveꞌelic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Acꞌu mi xul ta ol acꞌubal, acꞌu mi poꞌot sacub, mi julavem yul staelic yuꞌun li yajvalique, jun yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chacalbe avaꞌiic. Ti anaꞌojicuc ti jayib ora acꞌubal chtal li jꞌeleqꞌue, amalaic, achabi anaic ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaꞌ noꞌox yech tscꞌan chamalaicon noꞌox acꞌu mi mu xanaꞌic cꞌusi ora chichaꞌsut tal voꞌon ti coꞌol crixchanootique. Mu me chꞌayemuc avoꞌonic chul jtaoxuc ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","―Cajval, li loꞌil avale, ¿mi jaꞌ noꞌox jcꞌoplalticotic, o mi scꞌoplal scotol crixchanoetic? ―xut la Jesús li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Itacꞌav la ti Jesuse: ―Caltic noꞌox yaꞌel ti oy jun jꞌabtel ti sjunul yoꞌon ch-abteje, ti snaꞌ stucꞌulan abtele. Jaꞌ ch-acꞌbat smacꞌlin li xchiꞌiltac ta abtele ti cꞌalal sta yora veꞌebale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jun yoꞌon li jꞌabtele ti yolel ch-abtej chul stael yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta melel chacalbeic, ti muchꞌu sjunul yoꞌon ch-abteje ch-acꞌbat scuentain li cꞌusuc yuꞌun yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yan mi chopol sjol li jꞌabtele: “Mu to nan xtal li cajvale”, xi tsnop. Chlic yut, chlic smaj li xchiꞌiltac ta abtele. Jaꞌ chba xchiꞌin ta veꞌel ta uchꞌ pox li jyacubeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Li yajvale jaꞌo chul tal ti cꞌalal chꞌayem yoꞌon cꞌusi ta xchaꞌle li xchiꞌiltaque, yuꞌun mu xchꞌun ti poꞌot xa xule. Chul acꞌbatuc tsots castico yuꞌun li yajvale. Jaꞌ chba xchiꞌin li muchꞌutic coꞌol mu xchꞌunic mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Li jꞌabtele ti snaꞌoj xa cꞌusi tscꞌan li yajvale, ti mu spase, jaꞌ más castico chichꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yan li muchꞌu mu to snaꞌ cꞌusi tscꞌan li yajvale, mi mu to snaꞌ mi chichꞌ o castico li cꞌusitic ta spase, jaꞌ jutuc noꞌox castico chichꞌ. Li muchꞌu chpꞌijubtasat yuꞌun li yajvale, jaꞌ tscꞌan ti chtun yuꞌun ta tsꞌacale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Li voꞌone cꞌocꞌ yaꞌel tal cacꞌ liꞌ ta sba balamile. Chac tsacuc ta orae, lec biꞌa. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero más to chcacꞌ jvocol chac cꞌu chaꞌal lavie. Ti echꞌemuc xa li vocol scꞌoplal chquichꞌe, jun xa coꞌon ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mu me xanopic ti tal jcoꞌoltasbe sjol li crixchanoetic liꞌ ta sba balamile. Tal jchꞌaculan. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Li voꞌvoꞌ ta jpꞌej nae oy bu chaꞌchꞌac chcꞌotic. Mi chaꞌvoꞌ lec chiyile, oxvoꞌ chopol chiyil. Mi oxvoꞌ lec chiyile, chaꞌvoꞌ chopol chiyil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Oy bu tscrontain o screm li totile. Oy bu tscrontain o stot li creme. Oy bu tscrontain o stseb li meꞌile. Oy bu tscrontain o smeꞌ li tsebe. Oy bu tscrontain o yalib li meꞌelꞌalibale. Oy bu tscrontain o yalibmeꞌel li alibale ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ti Jesuse jaꞌ la yech lic yalbe ti epal crixchanoetique: ―Ti cꞌalal chavilic naca jmuyel li toque, “chtal voꞌ tana”, xachiic. Yuꞌun onox ta xtal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ti cꞌalal chtal icꞌ ta sure, “cꞌux cꞌacꞌal tana”, xachiic. Yuꞌun onox cꞌux cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chavilic cꞌu xꞌelan li vinajele li balamile, pero ti avalojique, mu xavilic ti stacojon tal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Cꞌu yuꞌun ti mu xanaꞌic li cꞌusitic leque? ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mi oy bu ata amul yuꞌun lachiꞌile, tscꞌan ti chba alajesbe yoꞌon ta orae. Ti mi mu xba alajesbe yoꞌone, chayicꞌ echꞌel ta stojol jmeltsanejcꞌop. Li jmeltsanejcꞌope chayacꞌ ta scꞌob jchabiejtemplo. Li jchabiejtemploe chasticꞌ ta chuquel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chacalbe avaꞌiic, mi mu xapasic chac cꞌu chaꞌal lacalbeique, li jmeltsanejcꞌope chacꞌ atojic scotol lamulique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti cꞌalal yech iyal ti Jesuse, oy la muchꞌutic iyalbeic ti cꞌu xꞌelan iyacꞌ ta milel jayvoꞌ jgalileaetic ta tiꞌ mucꞌta templo ta Jerusalén ti Pilatoe, jaꞌo la cꞌalal xyaquet chacꞌbeic smoton ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Itacꞌav la ti Jesuse: ―Ti jchiꞌiltactic ti imilatic ta tiꞌ mucꞌta temploe, mu me xavalic ti stuquic xa noꞌox tsots smulique. Li yan jchiꞌiltactic ta Galileae oy tsots smulic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jaꞌ noꞌox yechoxuc uc, ti mi mu xavictaic spasel li cꞌusitic chopole, coꞌol chaꞌochic ta cꞌocꞌ achiꞌuquic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ti vaxaclajunvoꞌ ichamic ti cꞌalal ilom ti qꞌuelob osil yoꞌ tsꞌel Siloée, mu me xavalic ti stuquic xa noꞌox tsots smulique, ti chꞌabal yan jchiꞌiltactic ti yech smulic ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jaꞌ noꞌox yechoxuc uc, ti mi mu xavictaic spasel li cꞌusitic chopole, coꞌol chaꞌochic ta cꞌocꞌ achiꞌuquic ta sbatel osil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ti Jesuse iyal la jun loꞌil: ―Caltic noꞌox yaꞌel ti oy jun vinic stsꞌunoj jtecꞌ icꞌux ta yut uvatique. Ba sqꞌuel mi oy sat, pero chꞌabal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Li teꞌel icꞌux liꞌi yoxibal xa jabil chul jqꞌuelulan mi oy sat, pero chꞌabal sat, yuꞌun mu snaꞌ satin. Más lec tsꞌeto loqꞌuel. Yech noꞌox tsmac balamil”, xut li yajchabiejꞌuvae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Cajval, teyuc to lavi jabile. Ta jvocꞌbequic li yoque. Ta xcacꞌbequic lec scꞌaꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jqꞌueltiquic mi mu satin o. Mi mu satine, jaꞌto xavacꞌ ta tsꞌetel”, xi li jchabiejꞌuvae ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti jꞌechꞌele ichanubtasvan la ta jun biqꞌuit templo ti Jesuse. Jaꞌo la ta scꞌacꞌalil ta xcuxic li jꞌisraeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tey la jun ants, oy xa la svaxaclajunebal jabil ip. Ipase la ta vujpat yuꞌun ti pucuje. Xvujvon xa la chanav. Mu xa la stacꞌ stuqꞌuibtas sba. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ti Jesuse iyil la ti jmemeꞌtique. ―Meꞌtic, laꞌ. Ta xtuqꞌuib lapate ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ti Jesuse iyacꞌ la scꞌob ta sba ti jmemeꞌtique, ora la ituqꞌuib ti spate. Ti jmemeꞌtique “colaval” xut la ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ti jmeltsanejcꞌop ta temploe icap o la tajmec ti istuqꞌuibtasbe spat jmemeꞌtic ti Jesuse ti ta scꞌacꞌalil ta xcuxique. ―Oy vaquib cꞌacꞌal ti xuꞌ chiꞌabtejotique. Jaꞌo xatalic mi chacꞌanic etꞌesbel achamelique. Maꞌuc o xatalic ta scꞌacꞌalil ta jcuxtique ―xut la ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Itacꞌav la ti Jesuse: ―Yech chanop ti xꞌelan chavale. Li voꞌoxuque chba onox avacꞌbeic yuchꞌ voꞌ avacaxic aburroic ti cꞌalal jaꞌo ta jcuxtique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Li jmemeꞌtic liꞌi ti coꞌol smomotic Abraam jchiꞌuctique, ti oy xa svaxaclajunebal jabil abol sba xchaꞌleat yuꞌun ti pucuje, jaꞌ noꞌox yech uc, xuꞌ jtuqꞌuibtasbe spat lavi ta scꞌacꞌalil ta jcuxtique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ti cꞌalal yech iyale, iqꞌuexav la scotolic ti muchꞌutic iscrontainic ti Jesuse. Ti jlome xmuyubajic xa la ti iyilic ti lec cꞌusitic tspas ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ti Jesuse iyal la jun loꞌil noxtoc: ―Chacalbe avaꞌiic cꞌu xꞌelan tspasvan ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Acꞌu mi muc bu ep lavie pero ta to xpꞌol. Coꞌol xchiꞌuc becꞌ mustisya ti istsꞌun ta yosil jun vinic ti toyol ibate. Ital mutetic, tey ispas stsoꞌopic ta scꞌobcꞌobtac ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ti Jesuse iyal la jun loꞌil noxtoc: ―Chacalbe avaꞌiic cꞌu xꞌelan tspasvan ta mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oy syuꞌel, xuꞌ tslecubtas o avoꞌonic yoꞌ xapasic o li cꞌusitic leque. Coꞌol xchiꞌuc li svuquesobil xchꞌut pane. Acꞌu mi jsetꞌ noꞌox xacꞌbe svuquesobil xchꞌut vucub teꞌ arina li antse, pero ta xvuc o xchꞌut scotol ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ti cꞌalal ibatic slajchavaꞌalic ta Jerusalén xchiꞌuquic ti Jesuse, mu la bu tucꞌ ibatic. Echꞌ la chanubtasvanuc ta jteclumetic xchiꞌuc ta parajeletic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oy la muchꞌu isjacꞌ: ―Cajval, ¿mi jayvoꞌ noꞌox yaꞌel ti chcuxiic ta sbatel osile? ―xi la. Itacꞌav la ti Jesuse: ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Vocol ta tael li sbelel vinajele pero saꞌic me. Ep ti muchꞌutic yoꞌonuc staique pero mu staic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ti Rioxe coꞌol xchiꞌuc jun vinic yaꞌel ti ismac stiꞌ snae. Tsꞌacal to chcꞌot atijic. “Cajval, Cajval, abulajan jamboticotic lanae”, chavutic. “Maꞌuc jchꞌamaloxuc”, chayutic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Lajchiꞌinticotic ta veꞌel ta uchꞌvoꞌ, achanubtasoticotic ta jlumalticotic”, chavutic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Lacalbeic xa ti maꞌuc jchꞌamaloxuque. Batanic, mu xajcꞌanic, yuꞌun chopol li cꞌusitic apasique”, chayutic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ti cꞌalal xavilic ti teyic yoꞌ bu tspas mantal Riox ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove, xchiꞌuc scotol ti yajꞌalcꞌoptac Riox ti ta más voꞌnee, jaꞌo chaꞌoqꞌuic, xcꞌuxuxet aveic yuꞌun laꞌalbatic xa ti mu xaꞌochique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tey chcꞌot noxtoc epal crixchanoetic ta sjunlej balamil. Jun yoꞌonic yoꞌ bu tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Oy muc bu ichꞌbil ta mucꞌ lavie, pero más tsots yabtel chcꞌotic yoꞌ bu tspas mantal ti Rioxe yuꞌun mu snaꞌ stoy sbaic. Oy totil yalojic lavie, pero mu cꞌu stu chcꞌotic yoꞌ bu tspas mantal ti Rioxe yuꞌun ta stoy sbaic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jaꞌo la tey icꞌotic jayvoꞌ jfariseo. ―Locꞌan echꞌel liꞌtoe yuꞌun yoꞌonuc smilot li Erodese ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Itacꞌav la ti Jesuse: ―Li Erodese coꞌol xchiꞌuc vet yuꞌun chtiꞌvan yaꞌel. Batanic, ba albeic ti ta to jloqꞌues pucujetic lavie xchiꞌuc li ocꞌobe, ta to xquetꞌesbe xchamelic ti muchꞌutic ipe. Chaꞌej to chlaj cuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Persa chixanav lavie, xchiꞌuc li ocꞌobe, xchiꞌuc li chaꞌeje. Yuꞌun tey chicham ta Jerusalén chac cꞌu chaꞌal tey ichamic ti yan yajꞌalcꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Li voꞌoxuque xchiꞌuc lachiꞌilic liꞌ ta Jerusalene, jaꞌ amanyaic ti chamilic li yajꞌalcꞌoptac Rioxe. Chavacꞌbeic ton li muchꞌutic chastacbeic tal ti Rioxe. Pero oy xa jayꞌechꞌel ti coꞌonuc jtsoboxuc chac cꞌu chaꞌal tslutsꞌ yol li meꞌchꞌeque, pero muc xacꞌanic tsobel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Toj abol aba chacomic yuꞌun mu xa bu chaxchiꞌinic ti Rioxe. Chacalbeic ti mu xa bu chavilicon oe. Jaꞌto ti cꞌalal xavalic ti “toj lec tajmec li muchꞌu itaque tal yuꞌun ti Rioxe”, xachiique, jaꞌto chavilicon noxtoc ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ta scꞌacꞌalil ta xcuxic li jꞌisraeletique iꞌiqꞌue la echꞌel ta veꞌel yuꞌun jun jfariseo ti Jesuse. Ochem la ta meltsanejcꞌop. Tey la yan xchiꞌiltac ta fariseoal yuꞌun la jaꞌ tspaꞌiic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tey la vaꞌal jun vinic ta stuqꞌuil ti Jesuse, liquem la situbel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","―¿Mi xuꞌ chichꞌ etꞌesbel xchamel ta scꞌacꞌalil ta jcuxtic ti muchꞌu ipe, o mi mu xuꞌ? ―xꞌutatic la yuꞌun Jesús ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc ti jfariseoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mi jun muc la xtacꞌavic. Ti Jesuse iyetꞌesbe la xchamel ti vinique. ―Batan xa ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","―Li voꞌoxuque, jfariseoetic, mi oy bu ipꞌaj ta chꞌen jcotuc aburroique, o mi jcotuc avacaxic ti cꞌalal jaꞌo ta jcuxtique, ¿mi muc bu chba aloqꞌuesic ta ora yaꞌel? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mu xa la snaꞌ cꞌuxi chtacꞌavic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ti Jesuse iyil la cꞌu xꞌelan tstꞌuj lec xchotlebic ti muchꞌutic iꞌiqꞌueic ta veꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ti cꞌalal chaꞌiqꞌueic ta nupunele, mu me xba chotlanic ta bail naca me oy muchꞌutic icꞌbilic tal ti más ichꞌbilic ta mucꞌ chac cꞌu chaꞌal li voꞌoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ti cꞌalal xul li muchꞌutic más ichꞌbilic ta muqꞌue, chtal yalboxuc li muchꞌu layiqꞌuique: “Locꞌanic liꞌtoe yuꞌun liꞌ ta xchotiic li jchiꞌiltactic liꞌi”, chayutic. Jaꞌo xaqꞌuexavic xa loqꞌuel, chba chotlanic ta slajeb chotlebal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ti cꞌalal chaꞌiqꞌueic ta veꞌele, chotlanic ta slajeb chotlebal. “Totic, liꞌ xtal chotlan ta baile”, mi chayutic li muchꞌu layiqꞌuique, chilic li muchꞌutic tey ta mexa uque ti ichꞌbiloxuc ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jaꞌ noꞌox yech ti muchꞌutic tstoy sbaique ch-aqꞌueic ta qꞌuexlal yuꞌun ti Rioxe. Yan li muchꞌutic mu snaꞌ stoy sbaique, jaꞌ ch-aqꞌueic ta ichꞌel ta mucꞌ yuꞌun ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ti Jesuse iyalbe la yaꞌi ti muchꞌu iꞌicꞌvan ta veꞌele: ―Ti cꞌalal chaꞌicꞌvan ta veꞌele, maꞌuc noꞌox me xavicꞌ li muchꞌutic lec xacꞌopon aba achiꞌuque. Maꞌuc noꞌox me xavicꞌ labanquile lavitsꞌine, xchiꞌuc lanamtalchiꞌile. Maꞌuc noꞌox me xavicꞌ lalacꞌnatac ti jcꞌulejetique. Yuꞌun yicꞌal spaquic ti avicꞌ ta veꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","Ti cꞌalal chaꞌicꞌvan ta veꞌele, tscꞌan chavicꞌ noxtoc li muchꞌutic meꞌone, xchiꞌuc li tuncoetique, xchiꞌuc li coxoetique, xchiꞌuc li maꞌsatetique yoꞌ xayacꞌbe o bentisyon ti Rioxe yuꞌun mu xuꞌ spaquic. Chavichꞌ amoton ti cꞌalal xachaꞌcuxiic xchiꞌuc li muchꞌutic coꞌol lec avoꞌon achiꞌuque ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Icꞌopoj la jun ti muchꞌutic tey chveꞌic ta mexa xchiꞌuc ti Jesuse: ―Jun yoꞌonic li muchꞌutic chveꞌic yoꞌ bu tspas mantal ti Rioxe ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ti Jesuse iyal la jun loꞌil: ―Caltic noꞌox yaꞌel ti oy jun vinic ti ispas ep veꞌlile yuꞌun tscꞌan chicꞌ ta veꞌel ep crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ti cꞌalal ista yora chveꞌique, istac echꞌel smozo: “Ba icꞌo tal li muchꞌutic calojbe xa onoxe. Batanic xa la, chapal xa li veꞌlile, xavut cꞌotel”, xut echꞌel li smozoe. Jaꞌ yech cꞌot yal li mozoile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Scotolic lic snopic ti cꞌusi tspoj o sbaique. “Muc bu xocolon yuꞌun jaꞌto ijman cosil yechꞌo un persa chba jqꞌuel. Abulajan, albo yaꞌi acꞌu yacꞌon ta pertonal”, xi li june. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Muc bu xocolon yuꞌun jaꞌto ijman voꞌob par jvocꞌ-osil vacax, yechꞌo un chba jqꞌuel cꞌu xꞌelan ch-abtejic. Abulajan, albo yaꞌi acꞌu yacꞌon ta pertonal”, xi li june. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Muc bu xocolon yuꞌun jaꞌto linupun”, xi li june. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Isut li mozoile, jaꞌ yech yul yalbe li yajvale ti cꞌu xꞌelan itacꞌbate. Li yajval veꞌlile icap o tajmec. “Batan ta anil ta chꞌivit xchiꞌuc ta cayatic, jaꞌ icꞌo tal li muchꞌutic meꞌone, xchiꞌuc li tuncoetique, xchiꞌuc li coxoetique, xchiꞌuc li maꞌsatetique”, xut echꞌel li smozoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ti cꞌalal iyul yuꞌun crixchanoetic li mozoile, “Cajval, ijchꞌun li cꞌusi avalbone. Ital xa li crixchanoetique, pero oy to xocol li chotlebale”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Batan xa ta bebetic xchiꞌuc ta belel trigoaltic, icꞌo tal ta persa li muchꞌutic chatae yoꞌ xnoj o li jnae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chacalbe, li muchꞌutic baꞌyi icalbe ti chtal veꞌicuque, mi jun muc bu chaꞌiic cꞌusi smuil li jveꞌele”, xut smozo li yajval veꞌlile ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ti Jesuse ep la tajmec crixchanoetic xchiꞌuc echꞌel. Isqꞌuel la spat, iyalbe la: ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ti muchꞌu tscꞌan chixchiꞌine, mi más scꞌanojon li voꞌone, mi jaꞌ jutuc noꞌox scꞌanoj li stot smeꞌe, li yajnile, li xchꞌamaltaque, li sbanquiltaque, li yitsꞌintaque, li svixtaque, li yixleltaque, ti mi mu cꞌuxuc ta yoꞌon li spat xocone, xuꞌ xixchiꞌin. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yan ti muchꞌu mu scꞌan xacꞌ svocol chac cꞌu chaꞌal chcacꞌ jvocol li voꞌone, mu xuꞌ xixchiꞌin. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Li voꞌoxuque, ti cꞌalal chavaꞌanic qꞌuelob osile, baꞌyi onox chanopic ti cꞌu yepal chlaje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ti mi jaꞌto chanopic cꞌu yepal chlaj cꞌalal aliquesojbeic xaꞌox li stanal yoque, yech noꞌox quechel chcom avuꞌunic. Ti cꞌalal chilic li crixchanoetic ti tey quechel avuꞌunique, chaslabanic o. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Li jchiꞌiltic leꞌe yech noꞌox ti isliquesbe svaꞌanel li qꞌuelob osile, pero muc xvaꞌi yuꞌun”, xi acꞌoplalic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jaꞌ noꞌox yech ti cꞌalal chbat ta acꞌ cꞌocꞌ jun preserentee, baꞌyi onox ta snop mi xcuch yuꞌun ta lajunmil soltero ti oy veinte mil yajsoltero li scrontae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mi iyil ti mu xcuch yuꞌune, ti cꞌalal nom toꞌox xtal li scrontae, ta stac echꞌel mantal ti chba slequilcꞌoponbel li scrontae yoꞌ xlaj o yoꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaꞌ noꞌox yechoxuc uc, mi xuꞌ chcom chavaꞌiic li cꞌusuc avuꞌunique, xuꞌ chachiꞌinicon. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Li atsꞌame mu xuꞌ ti chꞌabale. Jaꞌto chmuib o veꞌlil ti cꞌalal oye. Li atsꞌam liꞌ ta jlumaltique ti snaꞌ xchꞌay xchiꞌile, mu xa bu chtun cuꞌuntic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mi jaꞌuc ta cꞌaꞌal balamil mu xtun. Acꞌu mi xacap ta tsoꞌ vacax, mu xtun. Solel chichꞌ taniel. Jaꞌ noꞌox yech ti muchꞌutic chixchiꞌine, mi mu sjunuluc yoꞌone, mu cꞌu stu cuꞌun. Voꞌoxuc ti avaꞌiic cꞌusi icale, nopbeic smelol ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ti jcꞌan-locꞌ-cꞌusiticuque xchiꞌuc ti muchꞌutic más chopol cꞌusitic tspasique, inopoj la echꞌel yaꞌiic ti cꞌusitic chal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ti jfariseoetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, chopol la iyilic. ―Li vinic leꞌe ta xchiꞌin li muchꞌutic chopol cꞌusitic tspasique. Ta xchiꞌin ta veꞌel noxtoc ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ti Jesuse iyal la jun loꞌil: ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Caltic noꞌox yaꞌel ti oy cien achijique. Mi ichꞌay jcotuque, lamal chavictaic ta stentejtic li noventa y nuevee ti cꞌalal chba asaꞌic tal li jcot chꞌayeme. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ti cꞌalal xataique, mu xa cꞌu yech o avoꞌonic, chacajan tal ta anequebic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ti cꞌalal xayul ta anaique, chatsob li muchꞌutic lec xacꞌoponique xchiꞌuc alacꞌnatac. “Junuc coꞌontic yuꞌun ijta xa li jcot jchij ti ichꞌaye”, xavutic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jaꞌ noꞌox yech cꞌalal oy noventa y nueve lec yoꞌonique ti mu xa cꞌusi chopol tspasique, ti Rioxe jun yoꞌon. Pero cꞌalal xicta spasel cꞌusitic chopol otro jun crixchanoe, más to jun yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Caltic noꞌox yaꞌel ti oy jun ants oy lajunsep staqꞌuine. Mi ichꞌay jsepuque, ta stsan slámpara, ta smes li yut snae yoꞌto cꞌu chaꞌal mi istae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ti cꞌalal stae, ta stsob li muchꞌutic lec scꞌopone xchiꞌuc li slacꞌnataque. “Junuc coꞌontic yuꞌun ijta xa li jsep jtaqꞌuin ti ichꞌaye”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jaꞌ noꞌox yech jun yoꞌon xchiꞌuc yajꞌanjeltac ti Rioxe ti cꞌalal chicta spasel cꞌusitic chopol otro jun crixchanoe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ti Jesuse iyal la jun loꞌil noxtoc: ―Caltic noꞌox yaꞌel ti oy chaꞌvoꞌ screm jun vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Tot, acꞌbon xa ta ora li erensia ti cꞌu yepal chavacꞌbone”, xi li itsꞌinale. Li totile ixchꞌacbe xchaꞌvaꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ti cꞌalal ilaj xaꞌox jayib cꞌacꞌale, li itsꞌinale istsob scotol ti cꞌusitic iꞌacꞌbate. Ti cꞌalal laj stsobe, jaꞌo ibat ta nom. Tey ba yixtalan ti cꞌusitic iꞌacꞌbate. Ispas ti cꞌusi noꞌox xal yoꞌon stuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ti cꞌalal ilaj scotol ti staqꞌuine, jaꞌo iꞌechꞌ viꞌnal yoꞌ bu bateme. Iyaꞌi viꞌnal uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Isaꞌbe yabtel jun yajval jteclum. Itaque echꞌel ta rancho, ba xchabi chitom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Li creme xuꞌ xa chaꞌi ti tslajes li sveꞌel chitome yuꞌun muc xꞌacꞌbat sveꞌel yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ti jtote oy ep yajꞌabtel, noj xchꞌutic, mu cꞌusi snaꞌic. Li voꞌone liꞌ chicham ta viꞌnal chcaꞌie. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más lec chichaꞌsut echꞌel ta sna ti jtote. Tot, ijta xa jmul ta stojol ti Rioxe, xchiꞌuc ijta xa jmul ta atojol uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mu xa snupin ti crem xavutone. Más lec pꞌison xa ta avajꞌabtel, ta xcut cꞌotel”, xi isnop li creme ti cꞌalal iyil ti abol sbae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Isut ta sna stot. ’Li totile nom toꞌox iyil li screme, icꞌuxubaj ta yoꞌon. Anil xa ba snup ta be. Ismey, isbutsꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Tot, ijta xa jmul ta stojol ti Rioxe, xchiꞌuc ijta xa jmul ta atojol uc. Mu xa snupin ti crem xavutone”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ichꞌic tal ta ora li lequiquil cꞌuꞌule, acꞌbeic slap. Xojbeic yixtalal scꞌob, acꞌbeic xonob. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iqꞌuic tal li jupꞌem becerroe. Milic, jtiꞌtic, jpastic qꞌuin. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yuꞌun caloj ti chamem xa li jcreme, pero lavi isut tale, coꞌol xchiꞌuc ichaꞌcuxi yaꞌel. Yuꞌun ichꞌay toꞌox, pero lavie ijta xa yaꞌel”, xut smozotac li totile. Jaꞌo lic spasic qꞌuin. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ti cꞌalal iyul li itsꞌinale, batem ox ta abtel li banquilale. Ti cꞌalal isut tale, cꞌalal tey xaꞌox ta stsꞌel snae, iyaꞌi ti xnic xa qꞌuine, ti oy jꞌacꞌote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Isvelu jun smozoic, isjacꞌbe cꞌusi tspasic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Yuꞌun isut xa tal lavitsꞌine. Latote iyal ti acꞌu miluc li jupꞌem becerroe. Jaꞌ ti lec isut tal lavitsꞌine”, xꞌutat yuꞌun li smozoique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ti cꞌalal iyaꞌi li banquilale, icap o tajmec. Mu xa scꞌan xꞌoch ta sna. Li stote locꞌ yalbe ti acꞌu ochuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Li banquilale lic yalbe li stote: “Li voꞌote anaꞌoj ti liꞌon oe. Mi jaꞌuc jꞌechꞌel ti muc jchꞌun amantale. Mi jaꞌuc jcot chivo muc bu avacꞌbon ti ta jpas o qꞌuin xchiꞌuc li muchꞌutic lec jcꞌopon jba jchiꞌuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lavi iyul xa li jun acreme ti ay yixtalan ta antsetic lataqꞌuine, jaꞌ xa mu smilbeluc avuꞌun ta ora li jupꞌem becerroe”, xut li stote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Crem, li voꞌote liꞌot onoxe. Li cꞌusitic oye coꞌol cuꞌuntic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Más lec ti ta jpastic qꞌuine, ti junuc coꞌontique yuꞌun ichaꞌcuxi yaꞌel lavitsꞌine ti chamem xa ti caloje. Yuꞌun ichꞌay toꞌox, pero lavie ijta xa yaꞌel”, xut li screme ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Li lajchavoꞌe iꞌalbatic la jun loꞌil yuꞌun ti Jesuse: ―Caltic noꞌox yaꞌel ti oy jun jcꞌuleje. Oy yajmartomo. Oy muchꞌu isticꞌbe smul ta ajvalil li martomoe. Li smule jaꞌ ti iyixtalanbe cꞌusuc yuꞌun li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Itaque ta iqꞌuel yuꞌun li yajvale. “Icaꞌi ti chopol cꞌusi chapase. Albon caꞌi ti cꞌu yepal achonoj li cꞌusuc cuꞌune xchiꞌuc ti cꞌu to yepal teye yuꞌun chalocꞌ”, xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“¿Cꞌusi ta jnop lavi mu xa xiyacꞌbe cabtel li cajvale? Mu xuꞌ cuꞌun li abtele. Chiqꞌuexav noxtoc mi ta jcꞌan limoxnae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iyul xa ta jol cꞌusi ta jpas yoꞌ xiscꞌuxubin o li crixchanoetic ti cꞌalal xiloqꞌue”, xi isnop li martomoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jujuntal istac ta iqꞌuel li muchꞌutic oy yil yuꞌun li yajvale. “¿Cꞌu yepal avil yuꞌun li cajvale?” xut li muchꞌu baꞌyi itale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Cien tampo aceite”, xi. “Jato li spocoꞌvunale, chotlan, tsꞌibao ta achꞌ. Cincuenta tampo noꞌox xatsac ta vun”, xi li martomoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ali voꞌote ¿cꞌu yepal avil?” xut li muchꞌu tsꞌacal to itale. “Cien coxtal trigo”, xi. “Jato li spocoꞌvunale, tsꞌibao ta achꞌ. Ochenta coxtal noꞌox xatsac ta vun”, xi li martomoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Li martomo chopol sjole más snaꞌ snopel cꞌu xꞌelan yoꞌ sta o cꞌuxubinel ti cꞌalal xlocꞌ ta cabtele”, xi li ajvalile. Jaꞌ noꞌox yech li muchꞌutic jaꞌ noꞌox ta yoꞌonic cꞌu xꞌelan ch-echꞌic liꞌ ta sba balamile, más snaꞌic snopel cꞌu xꞌelan tscꞌuxubinic li xchiꞌilique yoꞌ xcꞌuxubinatic o uque. Yan li muchꞌutic xchꞌunojic li scꞌop Rioxe, más mu snaꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Voꞌoxuc ti oy cꞌusuc avuꞌunique, tscꞌan chacoltavanic o. Mu me atuquicuc noꞌox ti lec chaꞌechꞌic liꞌ ta sba balamile. Mi chacoltavanic o li cꞌusitic snaꞌ xlaje, chaꞌiqꞌueic ochel ta vinajel ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Li muchꞌu xchabiluj yuꞌun li cꞌusi jutuc acꞌbil xchabie, jaꞌ noꞌox yech xchabiluj yuꞌun li cꞌusi epe. Yan li muchꞌu mu xchabiluj yuꞌun li cꞌusi jutuque, jaꞌ noꞌox yech mu xchabiluj yuꞌun li cꞌusi epe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Jaꞌ noꞌox yech mu xacꞌ acuxlejalic ta sbatel osil ti Rioxe mi mu xacoltavanic o li cꞌusitic chatabeic Riox liꞌ ta sba balamile ti snaꞌ xlaje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Coꞌol xchiꞌuc jun mozoil ti mu xuꞌ chaꞌvoꞌ yajvale. Mi chaꞌvoꞌ yajvale, li june chopol chil; li june lec chil. Li june yichꞌoj ta mucꞌ; li june mu xichꞌ ta mucꞌ. Jaꞌ noꞌox yech mu xuꞌ chatunic yuꞌun Riox mi jaꞌ noꞌox ta avoꞌonic li taqꞌuine ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ti cꞌalal iyaꞌi ti jfariseoetique, islabanic o la ti Jesuse yuꞌun la jaꞌ noꞌox ta yoꞌonic li taqꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iꞌalbatic la yuꞌun ti Jesuse: ―Li voꞌoxuque toj lec yilel avoꞌonic pero ti Rioxe yiloj cꞌu xꞌelan lavoꞌonique. Ti muchꞌutic chacꞌ sbaic ta ichꞌel ta muqꞌue, chopol ch-ileic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ti cꞌalal mu toꞌox chtal ti Juan jꞌacꞌ-ichꞌvoꞌe, jaꞌ noꞌox avaꞌiic ti cꞌusitic yaloj ti Rioxe ti stsꞌibaoj ti Moisese xchiꞌuc ti yan yajꞌalcꞌoptac Riox ti ta más voꞌnee. Tsꞌacal to ti Juane layalbeic ti chlic xa pasvanuc ta mantal ti Rioxe. Lavie ep xa ti muchꞌutic sjunul yoꞌon ta xchꞌunic pasel ta mantal yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Li vinajel balamile chlaj onox; yan li cꞌusitic yaloj ti Rioxe, mi jpꞌel mu xchꞌay, persa chcꞌot scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Ti muchꞌu ta xchꞌac yajnile, mi chicꞌ yan antse, coꞌol xchiꞌuc yants chcꞌot. Ti muchꞌu chicꞌ chꞌacbalal antse coꞌol xchiꞌuc yants chcꞌot noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Oy toꞌox jun jcꞌulej. Naca lequic scꞌuꞌ islap, naca toyolic stojol. Scotol cꞌacꞌal ispas qꞌuin, naca lequic ti sveꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oy toꞌox jun jcꞌanlimoxna noxtoc, Lázaro sbi. Balbil ta chin. Tey chcꞌot xchotan sba ta stiꞌ sna ti jcꞌuleje, tey tscꞌan limoxna. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ti jcꞌanlimoxnae yoꞌonuc ba stam ti cꞌusitic chlaj pꞌajuc ta yolon smexa ti jcꞌuleje, pero muc xꞌacꞌbat stam. Ta xleqꞌue ta tsꞌiꞌ noxtoc, jaꞌ ti balbil ta chine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Icham ti jcꞌanlimoxnae. Ti xchꞌulele iꞌicꞌbat echꞌel ta vinajel yuꞌun anjeletic yoꞌ bu ti Abraame xchiꞌuc ti muchꞌutic lec yoꞌonic uque. Icham ti jcꞌulej uque, imuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ti xchꞌulele tey ibat ta cꞌotebal. Iyil ta nom ti Abraame. Iyil noxtoc ti tey ti Lázaroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ti jcꞌuleje iꞌavan. “Jtotic Abraam, cꞌuxubinon. Taco tal li Lázaroe. Acꞌu stsꞌaj tal sniꞌ scꞌob ta voꞌ, acꞌu tal stꞌuxubtasbon li coqꞌue yuꞌun abol jba tajmec liꞌ ta cꞌoqꞌue”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Yuleso ta ajol, quere, ti cꞌalal laꞌechꞌ ta sba balamile, batsꞌi jcꞌulejot tajmec. Li Lázaroe batsꞌi meꞌon tajmec iꞌechꞌ. Lavie liꞌ xa jun yoꞌone; li voꞌote yolel chavichꞌ castico. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mu xjelav li Lázaroe yuꞌun oy natil chꞌen ta oꞌlol. Muc muchꞌu xjelav teyoꞌe. Jaꞌ noꞌox yech muc muchꞌu xjelav tal liꞌtoe”, xi ti Abraame. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’“Mi mu xjelav tale cheꞌe, abulajan tacbon echꞌel ta sna li jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yuꞌun oy to voꞌvoꞌ quitsꞌin teyoꞌe. Acꞌu ba yalbe ti acꞌu yictaic spasel li cꞌusitic chopole yoꞌ mu xtalic o liꞌtoe. Yuꞌun toj tsots li casticoe”, xi ti jcꞌuleje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Tey onox yichꞌojic li svun Moisese xchiꞌuc li svuntac yan yajꞌalcꞌoptac Riox ti ta más voꞌnee. Xuꞌ jaꞌ xchꞌunic”, xi ti Abraame. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Jtotic Abraam, mu xchꞌunic. Ti oyuc noꞌox cꞌuxi chaꞌcuxiuc ti muchꞌu xojtiquinique, mi iyilic ti tey chcꞌot noxtoque, ta nan xchꞌunic biꞌa. Ta nan xictaic spasel li cꞌusitic chopole”, xi ti jcꞌuleje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Mi mu onox xchꞌunic ti cꞌusitic iyal ti Moisese xchiꞌuc ti yan yajꞌalcꞌop Riox ti ta más voꞌnee, acꞌu mi oy muchꞌu xchaꞌcuxi echꞌel xba yalbe, mi jaꞌuc onox xchꞌunic”, xut jcꞌulej ti Abraame ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Li lajchavoꞌe iꞌalbatic la yuꞌun ti Jesuse: ―Oy onox cꞌusi chopol chtal ta avoꞌonic. Yechꞌo un qꞌuelo me abaic, mu me voꞌoticoxuc ta amulic tsaꞌ smul lachiꞌilique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mi voꞌoxuc ta amulic ti tsaꞌ smulique, más lec ti avichꞌicuc chucbel jcotuc choꞌ ta anuqꞌuique, ti latenaticuc ochel ta mare. Ti lachamicuque, mu xa cꞌuxi saꞌ smul avuꞌunic li muchꞌutic yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique ti yichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Cuentaanic me cheꞌe. Ti mi oy bu ista smul avuꞌun junuc achiꞌil ta yichꞌelon ta muqꞌue, ba lequilꞌalbo atuc ti cꞌusi chopol ispase. “Mu xa bu ta jpas yech”, mi xie, acꞌo ta pertonal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ti mi ista smul avuꞌun vuc-echꞌeluc ta jun cꞌacꞌale, “mu xa bu ta jpas yech”, mi xayutilane, acꞌo ta pertonal ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","―Coltaoticotic ta xchꞌunel más ti voꞌot oy ayuꞌele ―xutic la Cajvaltic Jesús li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Itacꞌav la ti Cajvaltique: ―Acꞌu mi jutuc noꞌox achꞌunojic ti oy jyuꞌele, acꞌu mi coꞌol xchiꞌuc jpꞌej becꞌ mustisya, pero spas xa avuꞌunic li cꞌusitic vocol ta pasele. Jaꞌ chac cꞌu chaꞌal mi chavalbeic ti acꞌu buluc loqꞌuel li sicómoro teꞌ leꞌe, ti acꞌu tecꞌluc ta mare, tspas avuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Caltic noꞌox yaꞌel ti oy amozoique ti iꞌay ta vocꞌ-osile, o mi chabivacax. Ti cꞌalal xul ta anae, mu onox bu chavalbe ti chtal chotluc ta mexae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“Li voꞌote lapo amac, meltsanbon tal jveꞌel. Mi laj veꞌicone, jaꞌto chaveꞌ”, xavut. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Colaval” mi jaꞌuc xavut ti cꞌalal ixchꞌun amantale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaꞌ noꞌox yechoxuc uc, mi achꞌunic li cꞌusitic chayalbeic ti Rioxe, “Mu cꞌu xitunoticotic o. Jaꞌ noꞌox ijpasticotic ti cꞌu yepal liyalboticotique”, chianic me ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ti cꞌalal ibat ta Jerusalén ti Jesuse, tey la iꞌechꞌ ta stsꞌac estado Samaria xchiꞌuc estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ti cꞌalal icꞌot ta jun parajele, tal la snupel ta be yuꞌun lajunvoꞌ viniquetic. Nom la isvaꞌan sbaic yuꞌun la ipic ta lepra. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Iꞌavanic la. ―Jesús, jchanubtasvanej, abulajan cꞌuxubinoticotic ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ti Jesuse, ti cꞌalal iyil ti viniquetique ―Batanic, ba acꞌ abaic iluc ta stojol paleetic ―xꞌutatic la. Ti cꞌalal ibatique, iꞌechꞌ la ti xchamelique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cꞌalal iyil ti lec xa ti june, isut la tal ta ora yoꞌ bu ti Jesuse. Xꞌavet xa la tal: ―Colaval, Cajval, ti lecon xae ―xut la ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Isquejan la sba ta yichon ti Jesuse, jaꞌo la isnijan sba ta balamil noxtoc. ―Colaval ti lecon xa avuꞌune ―xut la. Ti muchꞌu yech ispase, liquem la tal ta estado Samaria. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","―Lajunvoꞌ ti iquetꞌesbe xchamelique. ¿Bu ma ti balunvoꞌ jchiꞌiltactique? ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Stuc noꞌox isut tal li jsamariae ti “colaval”, xut ti Rioxe ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","―Vaꞌlan, batan. Yuꞌun achꞌun ti oy jyuꞌele, yechꞌo ti lecot xae ―xꞌutat la yuꞌun Jesús ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ti jfariseoetique isjacꞌbeic la ti Jesuse ti cꞌu to ora chtal pasvanuc ta mantal ti Rioxe. ―Ti cꞌalal xlic pasvanuc ta mantal ti Rioxe, chꞌabal seña. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Liꞌ xa tspas mantal ti Rioxe”, “leꞌ xa tspas mantal ti Rioxe”, muc muchꞌu xi. Ti Rioxe tspasvan xa ta mantal, liꞌ xa achiꞌuquique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Li lajchavoꞌe lic la albaticuc yuꞌun ti Jesuse: ―Ta sta yora ti chlic avalic chac liꞌi: “Chac noꞌox taluc ta ora ti Cajvaltic Jesuse”, xachiic, pero mu to bu chital, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Oy jlom chloꞌlovanic noꞌox. “Leꞌ xa li Cajvaltic Jesuse”, “taj xa li Cajvaltic Jesuse”, xiic. Pero mu me xachꞌunic, mu me xba aqꞌuelic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ti cꞌalal xichaꞌsut tal voꞌon ti coꞌol crixchanootique, chiyil scotol crixchanoetic chac cꞌu chaꞌal xlebluj chavuque chquiltic ti buyotique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero baꞌyi chcacꞌ tajmec jvocol yuꞌun mu xiscꞌanic li jqꞌuex jchiꞌiltactic liꞌi. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jaꞌ chac cꞌu chaꞌal ispas ti crixchanoetic ti ta más voꞌnee ti cꞌalal liꞌ toꞌox ti Noee, jaꞌ noꞌox yech tspasic uc ti cꞌalal sta yora chichaꞌsut tal, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jun yoꞌon iveꞌic, iyuchꞌic voꞌ, islajesic scotol ti cꞌusi scꞌan yoꞌonique, inupunic, iyacꞌ ta nupunel stsebic. Ti cꞌalal ital ti nojele, cꞌalal iꞌoch ta barco ti Noee, icom ti cꞌusitic ispasique, icham scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaꞌ noꞌox yech ispasic uc ti crixchanoetic ti ta más voꞌnee ti cꞌalal liꞌ toꞌox ti Lote. Jun yoꞌon iveꞌic, iyuchꞌic voꞌ, islajesic scotol ti cꞌusi scꞌan yoꞌonique, iꞌequelajic, iꞌovolajic, ismeltsan snaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ti cꞌalal ilocꞌ ta Sodoma ti Lote, jaꞌo ital cꞌocꞌ xchiꞌuc asuvre ta vinajel, icham scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jaꞌ noꞌox yech tspasic li crixchanoetique ti cꞌalal xichaꞌsut tal, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ti cꞌalal xcꞌot yech ti cꞌu to orae, lavi pachꞌal li sba anaique, mi jaꞌo oy muchꞌu tey xvaꞌete, ti cꞌalal xyal tale, mu xa me xꞌoch stam cꞌusuc yuꞌun. Ti muchꞌutic tey ta yabtelique, mu xa me sut ta snaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yuleso ta ajolic cꞌusi ispas ti yajnil Lote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ti muchꞌutic mu xiyichꞌic ta muqꞌue ti jaꞌ chiꞌic o li milele, yuꞌun onox ta xꞌochic ta cꞌocꞌ ta sbatel osil. Yan ti muchꞌutic muc ta alel yuꞌunic mi jaꞌ xlajic oe, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Chacalbeic, mi onox cꞌu chaꞌal ta acꞌubaltic litale, mi oy muchꞌu vayem chaꞌvoꞌ ta jun noꞌox teme, yicꞌal jun chquicꞌ echꞌel, jun chcom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mi oy chaꞌvoꞌ ants ti tsobol ta xjuchꞌunique, yicꞌal jun chquicꞌ echꞌel, jun chcom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mi oy chaꞌvoꞌ vinic ti tsobol ta xꞌabtejique, yicꞌal jun chquicꞌ echꞌel, jun chcom ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","―¿Bu ma chcꞌot taj une, Cajval? ―xiic la li lajchavoꞌe. ―Yuꞌun chichꞌic onox castico ti muchꞌutic mu xiyichꞌic ta muqꞌue. Coꞌol xchiꞌuc mi oy cꞌusi ichame, tey ta stsob sba xulemal ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Li lajchavoꞌe iꞌalbatic la jun loꞌil yuꞌun ti Jesuse yoꞌ la mu xicta o sbaic ta scꞌoponel ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","―Caltic noꞌox yaꞌel ti oy jun jmeltsanejcꞌop ta jun jteclume, mu xichꞌ ta mucꞌ Riox, mu xichꞌ ta mucꞌ crixchanoetic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Caltic ti tey nacal jun meꞌanal antse, oy cꞌusi ipojbat. Ba scꞌanbe parte li jmeltsanejcꞌope. “Mi mu xaꞌabulaj xatacbon ta iqꞌuel li muchꞌu lispojbe cꞌusuc cuꞌune”, xut. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ep ta echꞌel ay scꞌanbe parte li jmeltsanejcꞌope. Li jmeltsanejcꞌope tsꞌacal to isnop: “Mi Rioxuc, mu xquichꞌ ta mucꞌ, mi jaꞌuc crixchano. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jaꞌ noꞌox lavi liꞌ xvaꞌvon li meꞌanal antse, ta jmeltsanbe li scꞌope. Yuꞌun mu jcꞌan ti liꞌ noꞌox xvaꞌvone”, xi li jmeltsanejcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","’Avaꞌiic cꞌu xꞌelan iyal li jmeltsanejcꞌop ti chopol sjole. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jaꞌ noꞌox yech ti Rioxe chacꞌbe castico ti muchꞌutic ch-ilbajinbon li xchꞌamaltaque ti cꞌacꞌal acꞌubal ta xcꞌopojique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ti cꞌalal sta yorae, ta ora chacꞌbe castico. Pero ti cꞌalal xichaꞌsut tal voꞌon ti coꞌol crixchanootique, ¿mi oy onovan muchꞌutic yichꞌojicon ta mucꞌ xul jta? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ti Jesuse iyal la jun loꞌil yoꞌ la xaꞌiic o ti chopol cꞌusitic tspasic ti muchꞌutic lec yoꞌonic ti yalojique ti tspꞌaj xchiꞌilique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Caltic noꞌox yaꞌel ti oy chaꞌvoꞌ vinic coꞌol ba scꞌoponic Riox ta tiꞌ mucꞌta temploe. Li june jfariseo; li june jcꞌan-locꞌ-cꞌusiticuc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Li jfariseoe vaꞌal iscꞌopon Riox, mu xa muchꞌu xtaon chaꞌi. “Colaval, Cajval, ti muc bu yechon chac cꞌu chaꞌal li yan jchiꞌiltaque ti ch-elcꞌajique, ti chopol sjolique, ti tsaꞌ yantsique. Muc bu yechon noxtoc chac cꞌu chaꞌal li jcꞌan-locꞌ-cꞌusiticuc liꞌ vaꞌale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Li voꞌone chaꞌechꞌel ta xemana chquicta cot. Li cꞌusitic ta jtae chacacꞌbe jun mi ijta lajunebe”, xut ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Li jcꞌan-locꞌ-cꞌusiticuque nom vaꞌal icom. Mi jaꞌuc scꞌan sqꞌuel muyel vinajel. Jaꞌ noꞌox ismajulan stiꞌ yoꞌon. “Cajval, cꞌuxubinon yuꞌun jmulavilon”, xut ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chacalbe avaꞌiic. Li jcꞌan-locꞌ-cꞌusiticuque acꞌbil xa pertonal yuꞌun smul ti cꞌalal isut ta snae. Yan li jfariseoe muc xꞌaqꞌue ta pertonal. Ti muchꞌutic stoyoj sbaique ch-aqꞌueic ta qꞌuexlal yuꞌun mu xcꞌaneic yuꞌun ti Rioxe. Yan ti muchꞌutic mu snaꞌ stoy sbaique jaꞌ ch-aqꞌueic ta ichꞌel ta mucꞌ yuꞌun ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tey la yicꞌojbeic cꞌotel cꞌoxetic ti Jesuse yuꞌun la acꞌu yacꞌ scꞌob ta sjolic yoꞌ staic o bentisyone. Cꞌalal iyilic li lajchavoꞌe, ispajesic la ti muchꞌutic chiqꞌuic tal cꞌoxetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","―Mu xavutic. Acꞌu talicuc li cꞌoxetique. Yuꞌun ti muchꞌutic jaꞌ yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique, ta xchꞌunic cꞌusitic chal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta melel chacalbeic, ti muchꞌutic maꞌuc yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li cꞌoxetique, mu xꞌochic yoꞌ bu tspas mantal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tey la jun jmeltsanejcꞌop yuꞌunic li jꞌisraeletique. ―Jchanubtasvanej, voꞌot ti lec avoꞌone, ¿cꞌusi tscꞌan ta jpas yoꞌ xicuxi o ta sbatel osile? ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","―¿Cꞌu yuꞌun ti “lec avoꞌon”, xavutone? Jun noꞌox ti muchꞌu lec yoꞌone, jaꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Anaꞌoj cꞌusi chal li smantaltac Rioxe: “Mu me xasaꞌ avants, mu me xamilvan, mu me xaꞌelcꞌaj, mu me xanopbe smul achiꞌil, ichꞌo ta mucꞌ atot ameꞌ”, xi ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","―Li cꞌusitic avale cꞌoxon toꞌox lic jchꞌun ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ti cꞌalal iyaꞌi ti Jesuse ―Oy to cꞌusi tscꞌan chapas. Ba chono li cꞌusuc avuꞌune. Li stojole qꞌuelanbo li meꞌonetique yoꞌ oy o acꞌulejal ta vinajele. Tsꞌacal to xtal achiꞌinon ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cꞌalal iyaꞌi chac taje, iyat la yoꞌon tajmec ti vinique yuꞌun la toj ep cꞌusuc yuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cꞌalal iyil ti Jesuse ti chat o yoꞌon tajmeque ―Li jcꞌulejetique tsots ta chꞌunel chaꞌiic cꞌusitic chal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Coꞌol xchiꞌuc jcot cameyo ti mu xjelav ta chac acuxae, jaꞌ yech mu xꞌochic yoꞌ bu tspas mantal Riox ti muchꞌutic jaꞌ noꞌox ta yoꞌonic li scꞌulejalique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ti muchꞌutic iyaꞌiic ti xꞌelan iyal ti Jesuse ―¿Muchꞌu xa onox ta xcuxi ta sbatel osil ti mi mu xcuxiic li jcꞌulejetique? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","―Mu xuꞌ chacuxiic ta sbatel osil ta atuquic. Jaꞌ noꞌox chacuxiic mi chascoltaic ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","―Li voꞌoticotique jcomtsanojticotic xa li cꞌusuc cuꞌunticotique. Jnapꞌletaojoticotic xa ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","―Ta melel chacalbeic, ti muchꞌutic muc ta alel yuꞌunic mi iscomtsan o snaique, mi stot smeꞌ, mi sbanquiltac, mi yitsꞌintac, mi svixtac, mi yixleltac, mi smuctac, mi yajnil, mi xchꞌamaltac, mi yoltac, yuꞌun ti chalic aꞌyuc ti tspasvan xa ta mantal ti Rioxe, más xa ep ch-acꞌbatic sqꞌuexol ti cꞌusitic chcom yuꞌunique. Tsꞌacal to ta xcuxiic ta sbatel osil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Li lajchavoꞌe itsobatic la yuꞌun ti Jesuse. ―Anaꞌojic ti chibatic ta Jerusalene. Yuꞌun ista xa yora ti cꞌu chaꞌal stsꞌibaojic comel ti yajꞌalcꞌoptac Riox ti ta más voꞌnee, ti ta xquil jvocol voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chiꞌaqꞌue entrucal ta stojol li muchꞌutic nom liquemic tale. Chislabanic, chismajic, chistubtaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chiyacꞌbeic arsial, jaꞌo chismilic. Chimuque. Ta yoxibal cꞌacꞌal chichaꞌcuxi ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Muc la xaꞌibeic smelol ti xꞌelan iyale, yuꞌun la muc xꞌacꞌbat yaꞌibeic smelol yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ti cꞌalal poꞌot xaꞌox la xcꞌotic ta jteclum Jericoe, tey la chotol istaic ta tiꞌil be jun xchiꞌilic ta israelal, maꞌsat la. Tey la tscꞌan limoxna. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cꞌalal iyaꞌi ti tey ta xꞌechꞌ ep xchiꞌiltaque, ijacꞌbatic la cꞌusi tspasic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iꞌalbat la yuꞌun li xchiꞌiltaque ti jaꞌ tey xchiꞌuquic echꞌel ti Jesus Nazarete. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jaꞌo la iꞌavan. ―¡Jesús, smom David, cꞌuxubinon! ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ti muchꞌutic babe echꞌele ispajesic la: ―¡Anchan! ―xutic la. Pero más to la tsots iꞌavan: ―¡Smom David, cꞌuxubinon! ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Vaꞌ xi la ti Jesuse. ―Icꞌbecon tal ―xut la ti crixchanoetique. Ti cꞌalal icꞌote ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Cꞌusi chajchaꞌle un? ―xꞌutat la yuꞌun ti Jesuse. ―Cajval, abulajan jambon li jsate ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","―Lavi achꞌun ti oy jyuꞌele, chjam xa lasate ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ora la ijam ti sate, ixchiꞌin la echꞌel ti Jesuse. ―Colaval ―xut la ti Rioxe. Cꞌalal iyilic ti crixchanoetique, “colaval, Cajval”, xiic la uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Li belel Jerusalene tey xꞌechꞌ ta yutil Jericó. Tey la iꞌechꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tey la nacal jun jcꞌulej, Zaqueo la sbi. Jaꞌ la totil yuꞌunic li jcꞌan-locꞌ-cꞌusiticuque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tscꞌan la chojtiquin ti Jesuse, tscꞌan la tsqꞌuelbe cꞌu xꞌelan sat. Pero mu la sta ta ilel yuꞌun la toj ep tajmec ti crixchanoetique. Xchiꞌuc la cꞌusuc, yuꞌun la comcom ti Zaqueoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yechꞌo un ijelav la echꞌel ta anil, ba la muyuc ta jtecꞌ sicómoro yoꞌ la sta o ta ilel ti Jesuse. Yuꞌun la snaꞌoj ti tey ta xꞌechꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ti cꞌalal icꞌot ta yolon teꞌ ti Jesuse, isqꞌuel la muyel. Iyil la ti tey luchul ti Zaqueoe. ―Zaqueo, yalan tal ta ora yuꞌun tey chibat ta ana ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ti Zaqueoe ora la iyal. Xmuyubaj xa la, iyicꞌ la echꞌel ta sna ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ti cꞌalal iyil ti xchiꞌiltac ta israelale, chopol la iyaꞌiic. ―Chopol ti ibat ta sna jmulavil li Jesuse ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ti Zaqueoe isvaꞌan la sba. ―Cajval, ta xcacꞌbe jꞌoꞌloluc cꞌusuc cuꞌun li meꞌonetique. Ti mi oy muchꞌu iquelcꞌanbe staqꞌuine, más xa ep ta jsutesbe. Ti mi iquelcꞌanbe cienuque, ta xa jsutesbe chanibuc cien ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","―Lavie acꞌbiloxuc xa pertonal yuꞌun amulic ajunlejic ta na. Yuꞌun achꞌun xa ti cꞌusi chal ti Rioxe chac cꞌu chaꞌal ixchꞌun ti Abraam ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Voꞌon ti coꞌol crixchanootique, yuꞌun jaꞌ tal jsaꞌoxuc, tal jpojoxuc yuꞌun scꞌoplal xaꞌox chaꞌochic ta cꞌocꞌ ta sbatel osil ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ti crixchanoetique tey la chaꞌiic cꞌusi chal ti Jesuse. Yuꞌun isnop ti jꞌisraeletique ti jaꞌ xa li muchꞌu stꞌujoj Rioxe ti chcꞌot xa ochuc ta preserenteal ta Jerusalene, yechꞌo un ti Jesuse isjoyꞌal la sba stuc ti cꞌalal poꞌot xaꞌox xcꞌotic ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","―Caltic noꞌox yaꞌel ti oy screm jun preserentee. Jcꞌulej tajmec li creme. Ibat ta nom, ba yichꞌ tal snombramiento scuenta preserenteal. Ti cꞌalal sut tale, chul spas mantal ta slumal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ti cꞌalal mu toꞌox chbate, istsob slajunvaꞌal li yajꞌabtele. Iyacꞌbe comel sliquebic li yajꞌabtele. Coꞌol yepal iyacꞌbe comel jujun. “Abtejanic o. Tey xaqꞌuelic cꞌu yepal chjolin avuꞌunic. Ti cꞌalal xisut tale, chul quichꞌ”, xꞌutatic comel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Li xchiꞌiltac ta slumale mu scꞌanic ti jaꞌ ch-och ta preserenteale. Istaquic echꞌel mantal ti mu yaꞌuc acꞌbatuc snombramientoe. “Mu jcꞌanticotic ti jaꞌ ch-och ta preserenteal ta jlumalticotique”, xiic cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Pero iyichꞌ onox snombramiento, isut tal. Ti cꞌalal iyule, istac ta iqꞌuel li yajꞌabteltaque yuꞌun chaꞌi cꞌu yepal ijolin yuꞌunic jujun li staqꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Li jun baꞌyi itale “Totic, lataqꞌuin avacꞌbon comele, ijolin cuꞌun lajunꞌechꞌel más ep”, xut li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Li voꞌote lec xanaꞌ xaꞌabtej. Jutuc ti lacacꞌbee pero sjunul avoꞌon laꞌabtej o, yechꞌo un chajticꞌ ta coviernoal scuenta lajuneb jteclum”, xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ital noxtoc li june. “Totic, lataqꞌuin avacꞌbon comele ijolin cuꞌun voꞌechꞌel más ep”, xut li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Li voꞌot uque chajticꞌ ta coviernoal scuenta voꞌob jteclum”, xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Ital noxtoc li june. “Totic, ilo lataqꞌuin avacꞌbon comele. Ijsutꞌ lec ta paño, ijnacꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yuꞌun lixiꞌ. Jnaꞌoj ti jlajelote. Jnaꞌoj ti chavichꞌbe xchiꞌuc sjol lataqꞌuine. Chavichꞌ ti bu muc bu avacꞌoj avocole”, xi ispoj sba li june. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","“Mu xatun, chꞌajot tajmec. Mi yech li cꞌusi chavale, ti jlajelone, ti chquichꞌ ti bu muc bu cacꞌoj jvocole, ¿cꞌu yuꞌun ti muc xavacꞌ jolinuc ta bancoe? Cꞌalal liyule, iquichꞌ xchiꞌuc sjol ti yechuque”, xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Pojbeic li taqꞌuine, jaꞌ acꞌbeic li muchꞌu isjolintas lajunꞌechꞌel más epe”, xꞌutatic li muchꞌutic teye. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“¡Totic, pero yichꞌoj xa lajuneb!” xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Chacalbe avaꞌiic, ti muchꞌutic sjunul yoꞌon ta xꞌabteje, más ta xꞌacꞌbatic. Yan ti muchꞌutic mu sjunuluc yoꞌon ta xꞌabteje, ti cꞌu yunenꞌepal iꞌacꞌbatique, ta xpojbatic ta jmoj. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Li muchꞌutic chiscrontainique, ti mu scꞌanic ti voꞌon preserenteone, iqꞌuic tal scotol liꞌtoe. Liꞌ ta jsat xamilique”, xi li preserentee ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ti cꞌalal laj loꞌilajuc ti Jesuse, iloqꞌuic la echꞌel teyoꞌe, ibatic la cꞌalal Jerusalén. Jaꞌ la babe echꞌel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti cꞌalal istabeic stuqꞌuil Betfajé xchiꞌuc Betania ta yoc jpꞌej vits Olivotic sbie, itaqueic la echꞌel chaꞌvoꞌ yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Batanic leꞌ ta parajele. Ta ochel noꞌox tey chucul chataic jcot burro, mu to muchꞌu scajlebinoj. Jitunic, nitic tal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mi oy muchꞌu chasjacꞌbeic cꞌu yuꞌun ti chajitunic li burroe, xavalbeic ti voꞌon chtun cuꞌune ―xꞌutatic la echꞌel yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ibatic la. Ti cꞌu xꞌelan iꞌalbatic echꞌele, jaꞌ la yech cꞌot staic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ti cꞌalal xyaquet tsjitunic li burroe ―¿Cꞌu yuꞌun ti chajitunic li jburroe? ―xꞌutatic la yuꞌun ti yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","―Yuꞌun jaꞌ chtun yuꞌun li Cajvaltic Jesuse ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Isnitic la tal yoꞌ bu ti Jesuse. Iyacꞌbeic la stasin spimilcꞌuꞌic, iscajlebin la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ti cꞌalal cajal xa echꞌel ta burro ti Jesuse, ti jꞌisraeletique isqꞌui la spimilcꞌuꞌic ta be yoꞌ bu ch-echꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ti cꞌalal poꞌot xaꞌox la staic li yaleltic ta yelav Jerusalén ta vits Olivotique, lic la avanicuc scotol ti muchꞌutic scotol cꞌacꞌal ixchiꞌinic ti Jesuse. Xmuyubajic xa la. “Colaval” xutic la ti Rioxe, ti yilojbeic slequilal syuꞌelal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","―¡Lec tajmec li preserente listacbotic tal ti Jtotic Riox ta vinajele! ¡Lec xa chiyilotic ti Rioxe! “Colaval, Cajval”, chiicuc uc ti anjeletic ta vinajele ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tey la capal jayvoꞌ jfariseoetic. ―Jchanubtasvanej, pajeso li muchꞌutic snapꞌletaojote ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","―Chacalbe avaꞌiic, mi ta xchꞌaniique, jaꞌ chlic avanicuc li tonetique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ti cꞌalal poꞌot xaꞌox la xcꞌotic ta Jerusalén xchiꞌuquic ti Jesuse, cꞌalal iyil jteclum ti Jesuse, iyoqꞌuita la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","―Ti xchꞌunicuc ti stacojon tal ti Rioxe yoꞌ jun o yoꞌonic xchiꞌuc ti Rioxe, lec ti yechuque. Pero iꞌechꞌ xa yora ti ch-acꞌbat xchꞌunique yuꞌun mu scꞌan xchꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yuꞌun tsta yora ti chtal sjoyintael yuꞌun li scrontaique, chtal smaquelic ta jujot. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chtal slomesbel scotol li snaique. Ta xlaj scotolic. Jaꞌ ti mu xchꞌunic ti voꞌon listac tal ti Rioxe, ti tal jtojbe li smulique ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ti Jesuse ibat la ta tiꞌ mucꞌta templo ta Jerusalén. Isnuts la loqꞌuel scotol ti jchonolajeletic teyoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","―“Li jnae jaꞌ scuenta chtal ataicon o ta cꞌoponel”, xi ti Rioxe, xi tsꞌibabil. Li voꞌoxuque snailchꞌen jꞌeleqꞌuetic xachaꞌleic ―xꞌutatic la ti jchonolajeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ti Jesuse tey la ichanubtasvan jujun cꞌacꞌal ta tiꞌ mucꞌta templo. Ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc ti jmeltsanejcꞌopetique, iscomonopic la cꞌuxi ta staic ta milel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero mu la cꞌuxi stacꞌ iyilic, jaꞌ la ti tey xchiꞌuc scotol ti crixchanoetique ti sjunul yoꞌon chaꞌiic cꞌusi chal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ti jꞌechꞌele tey la ta xchanubtasvan ta tiꞌ mucꞌta templo ti Jesuse. Jaꞌ la iyal ti chlic xa pasvanuc ta mantal ti Rioxe. Tey la icꞌotic jayvoꞌ totil paleetic, xchiꞌuc la jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, xchiꞌuc la jayvoꞌ jmeltsanejcꞌopetic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","―¿Muchꞌu layalbe ti xꞌelan chapase? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","―Oy cꞌusi chajacꞌbeic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Muchꞌu ta smantal ti iyacꞌ ichꞌvoꞌ ti Juane? ¿Mi Riox, o mi crixchano? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xalxalbe xa la sbaic: ―Mi chcaltic ti ta smantal Rioxe, “¿cꞌu yuꞌun ti muc xachꞌunique cheꞌe?” xi biꞌa. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mi chcaltic ti ta smantal crixchanoe, chiyacꞌbotic ton li jchiꞌiltactique yuꞌun xchꞌunoj scotolic ti jaꞌ yajꞌalcꞌop Riox ti Juane ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","―Mu jnaꞌticotic ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","―Jaꞌ yechon uc, mu xacalbeic ti muchꞌu liyalbe ti xꞌelan ta jpase ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ti Jesuse lic la yalbe jun loꞌil ti xchiꞌiltac ta israelale: ―Caltic noꞌox yaꞌel ti oy jun vinic istsꞌun ep uva ta yosile. Isaꞌ comel li muchꞌutic ta xchabiique. Ibat ta nom li yajvale. Tey ipaj. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ti cꞌalal itaꞌaj li uvae, istac tal jun yajꞌabtel, tal scuch echꞌel ti cꞌu yepal yaloj chichꞌe. Yul scꞌanbe li muchꞌutic ta xchabiique. Li jchabiejꞌuvae istsaquic li yajꞌabtel yajval osile, ismajic. Mu cꞌusi iyacꞌbeic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Li yajval osile istac tal otro jun yajꞌabtel. Jaꞌ noꞌox yech ixchaꞌleic, iyilbajinic noxtoc. Mi jsetꞌ mu cꞌusi iꞌacꞌbat echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Li yajval osile istac tal otro jun yajꞌabtel. Yoxvaꞌal xa o. Li jchabiejꞌuvae ismajic noxtoc. Isyayijesic, isnutsic loqꞌuel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’“¿Cꞌusi ta jnop cheꞌe? Más lec ta jtac echꞌel li jcreme ti jcꞌanoj tajmeque. Ti cꞌalal xilic ti jaꞌ jcreme, jaꞌ nan chichꞌic ta mucꞌ”, xi isnop li yajval osil yaꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Li jchabiejꞌuvae ti cꞌalal iyilic ti jaꞌ xa screm li yajval osile, “leꞌe jaꞌ xa chichꞌbe comel yosil li stote. Más lec jmiltic yoꞌ xquichꞌbetic o comel voꞌotic li yosile”, xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Isloqꞌuesic ta pat moc, ismilic. Ti cꞌalal sut tal li yajval uvae, ¿cꞌusi chul nopbaticuc xanaꞌic li jchabiejꞌuvae? ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chacalbe avaꞌiic ti chtal smil scotole. Yan xa o muchꞌutic chacꞌbe xchabi li uvae ―xꞌutatic la yuꞌun ti Jesuse. Ti cꞌalal iyaꞌiic ti jaꞌ scꞌoplalique ―¡Mu me yechuc xispasboticotic ti Rioxe cheꞌe! ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ti Jesuse isqꞌuelbe la sat ti crixchanoetique. ―Yuꞌun muc bu avaꞌyojbeic smelol li scꞌop Rioxe ti chal ti “coꞌol xchiꞌuc jpꞌej ton ti istꞌuj li yajval nae ti chacꞌ ta xchiquin snae ti ipꞌaje yuꞌun li yajꞌalvaniltaque, pero jaꞌ onox iꞌoch ta chiquin na. Jaꞌ noꞌox yech ti muchꞌu stꞌujoj ti Rioxe, acꞌu mi xpꞌaje, pero chichꞌ onox tsots yabtel”, xi tsꞌibabile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Qꞌuelavilic, ti muchꞌu tsots chcꞌot ta ba tone, chyayij. Mi jaꞌ netꞌbil icꞌote, ta xcham o. Voꞌon li tonon yaꞌele. Ti muchꞌutic mu xiyichꞌic ta muqꞌue, voꞌon chcalbeic ti ch-ochic ta cꞌocꞌ ta sbatel osile ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, taꞌox la stsaquic ta ora ti Jesuse yuꞌun la iyaꞌiic ti jaꞌ scꞌoplalique. Pero muc la stsaquic yuꞌun la ixiꞌic o li xchiꞌilique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jaꞌ noꞌox la ismalaic mi oy cꞌusi ora tstabeic smul ti yalojique yoꞌ la stsaquic o echꞌel ta stojol ti coviernoe. Ti cꞌalal iyilic ti muc bu tstabeic smule, jaꞌo la istaquic tal jayvoꞌ crixchanoetic, lec xa la yilel yul scꞌoponic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","―Jchanubtasvanej, jnaꞌojticotic ti yech scotol li cꞌusitic chavale. Jamal chaval cꞌusitic lec chil Riox ti ta jpasticotique. Mu tꞌujbiluc chachaꞌle ti muchꞌu chavalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Alo caꞌiticotic mi lec chil xanaꞌ ti Rioxe ti chcacꞌbeticotic tojel aqꞌuel ti preserente Césare, o mi chopol chil ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ti Jesuse iyil la ti oy smanyaique. ―¿Cꞌu yuꞌun ti xꞌelan tal avalbecone? ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Acꞌbecon quil jsepuc taqꞌuin ti chcacꞌtic ta tojel aqꞌuele ―xꞌutatic la. Iyacꞌbeic la yil. ―¿Muchꞌu slocꞌol liꞌi? ¿Muchꞌu sbi? ―xꞌutatic la yuꞌun ti Jesuse. ―César ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","―Jaꞌ tscꞌan chavacꞌbeic ti cꞌusi tscꞌan ti preserente Césare. Jaꞌ noꞌox yech tscꞌan chavacꞌbeic ti cꞌusi tscꞌan ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Acꞌu mi yoꞌonicuc saꞌbeic smul ta bail ta satil ti Jesuse pero muc la staic. Ti cꞌalal iyaꞌiic ti xꞌelan itacꞌav ti Jesuse, xchꞌayet xa la yoꞌonic. Mu xa la cꞌusi isjaqꞌuic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsꞌacal to tey la icꞌotic jayvoꞌ jsaduceoetic yoꞌ bu ti Jesuse, jaꞌ ti muchꞌutic chalic ti mu xichaꞌcuxiotic ti cꞌalal xichamotique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Jchanubtasvanej, stsꞌibaoj comel ti Moisese ti mi icham junuc vinique, mi chꞌabal screm icome, li itsꞌinale mi chꞌabal to yajnile, acꞌu yicꞌbe yajnil ti ánima sbanquile. Mi iꞌayan screme, jaꞌ yech chacꞌbe sbi chac cꞌu chaꞌal sbi ti ánima sbanquile yoꞌ mu xchꞌay o sbie, xi ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oy toꞌox vucvoꞌic, sbanquil yitsꞌin sbaic. Ti banquilale isaꞌ yajnil, pero icham, chꞌabal xchꞌamal icom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ti itsꞌinale iyicꞌbe yajnil ti ánima sbanquile pero icham uc. Chꞌabal xchꞌamal icom uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jaꞌ noꞌox yech ispas svucvaꞌalic. Svucvaꞌalic iyiqꞌuic ti antse pero muc xꞌayan xchꞌamalic junuc ti cꞌalal ichamique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsꞌacal to icham ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mi ichaꞌcuxiique, ¿muchꞌu onovan junucal ti chiqꞌue yuꞌun iyicꞌ svucvaꞌalic? ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Itacꞌav la ti Jesuse: ―Lavi liꞌic to ta sba balamile chnupun li viniquetique li antsetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ti muchꞌutic tꞌujbilic ti ta xchaꞌcuxiique ti chbatic ta vinajele, mi antsuc, mi vinicuc, mu xa bu chicꞌ sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yuꞌun mu xa snaꞌ xchamic. Coꞌolic xa xchiꞌuc anjeletic. Xchꞌamaltac xa Riox yuꞌun ichaꞌcuxesatic xa yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Cꞌalal ta Moisés iyal ti ta xchaꞌcuxi ti ánimaetique yuꞌun jaꞌ yech iꞌalbat yuꞌun ti Rioxe ti cꞌalal icꞌoponat ta jtecꞌ cꞌox chꞌixe. “Voꞌon Yajvalicon ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove”, xꞌutat. Ti xꞌelan iꞌalbate, yuꞌun cuxajtic ch-ileic yuꞌun ti Rioxe acꞌu mi voꞌne xa xchamelic ti moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti Rioxe jaꞌ yajvalic ti muchꞌutic cuxajtic ta sbatel osile. Li voꞌoxuque chamem xchiꞌuc xchꞌulelic ti avalojique. Ti Rioxe cuxul chil scotolic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jaꞌ xa la itacꞌavic jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ―Jchanubtasvanej, lec tajmec li cꞌusi avale ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yan ti jsaduceoetique mu xa la cꞌusi isjaqꞌuic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lic la sjacꞌ ti Jesuse: ―¿Cꞌu yuꞌun chalic ti smom noꞌox David ti Cristoe ti muchꞌu stꞌujoj Riox tspasvan ta mantale? ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ti Davide jaꞌ yech istsꞌiba ta svunal jqꞌuevujtic chac liꞌi: Ti Cajvale iꞌalbat yuꞌun ti Rioxe: “Chachoti ta jbatsꞌicꞌob, chapas mantal ti cꞌu sjalil xchꞌun o amantal cuꞌun scotol lacrontae”, xꞌutat, xi ti Davide. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ti Davide “Cajval”, xut ti muchꞌu stꞌujoj Riox tspasvan ta mantale. ¿Cꞌu yuꞌun “Cajval”, xut mi jaꞌ smom noꞌoxe? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Li lajchavoꞌe oy la cꞌusi iꞌalbatic yuꞌun ti Jesuse. Ep la xchiꞌilic ta israelal tey yaꞌyojic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Qꞌuelo me abaic, mu me xasloꞌloic li muchꞌutic ta xchanubtasvanic ta smantal Rioxe. Lec chaꞌiic ti xtolet scꞌuꞌic cꞌalal yoquique. Jaꞌ tscꞌanic ti cꞌoponbilic ta chꞌivite. Jaꞌ tscꞌanic ti bail ta xchotiic ta bicꞌtal temploetique xchiꞌuc ta jujun qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta sloꞌlobeic cꞌusuc yuꞌun li meꞌanal antsetique. Yech noꞌox ti jal tscꞌoponic Rioxe, jaꞌ noꞌox yoꞌ mu xvinaj o ti chopol cꞌusi tspasique. Yechꞌo un más castico chichꞌic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ti Jesuse iyil la ti isticꞌ staqꞌuin jcꞌulejetic yoꞌ bu li scaxail limoxna ta mucꞌta temploe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iyil la noxtoc ti tey icꞌot jun meꞌanal antse, meꞌon la tajmec. Chaꞌsep no la ta cinco isticꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","―Ta melel chacalbeic, li meꞌanal ants leꞌe más ep iyacꞌ chil ti Rioxe chac cꞌu chaꞌal iyacꞌ li yantique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yuꞌun naca xa sovra staqꞌuinic ti iyaqꞌuique. Yan li meꞌanal antse iyacꞌ scotol ti cꞌu yepal oy yuꞌune ti jaꞌ ox ta sman o ti cꞌusi chtun yuꞌune ―xꞌutatic la yuꞌun Jesús li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Oy la jayvoꞌ apoxtoletic lic yalbeic ti Jesuse: ―Qꞌuelavil slequiquil tajmec li ton acꞌbil ta temploe. Leclec sba tajmec li cꞌusitic pacꞌajtic ta spaqꞌue, jaꞌ yacꞌojic ti muchꞌutic sjunul yoꞌonic yichꞌojic ta mucꞌ ti Rioxe ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Lequic avaꞌuquicaꞌa, pero ta sta yora ti ta xlomesate. Busul chcom scotol ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","―Jchanubtasvanej, ¿cꞌusi ora ta xlomesat li temploe? ¿Cꞌusi seña ti cꞌalal poꞌot xaꞌox xlome? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","―Pꞌijanic me, mu me xachꞌunic loꞌloel. Yuꞌun ep ti muchꞌutic chtalique, “voꞌon Cristoon”, xiic. “Poꞌot xa xtal ti Cristoe”, xiic jlom. Pero mu me xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ti cꞌalal chavaꞌiic ti oy acꞌ cꞌoqꞌue, ti cꞌalal chavaꞌiic ti oy bu tscrontain yajpreserenteique, mu me xaxiꞌic. Chcꞌot onox yech, pero li balamile maꞌuc toꞌox chlaj, liꞌto cꞌuuc sjalile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","’Ta sliquesic acꞌ cꞌocꞌ li crixchanoetic ta yantic o balamile. Ta sliquesic acꞌ cꞌocꞌ li preserenteetic noxtoque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Oy bu ch-echꞌ tsots niquel, oy bu ch-echꞌ viꞌnal, oy bu ch-echꞌ chamel. Chavilic ep seña ta vinajel ti xiꞌel sba tajmeque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Cꞌalal mu toꞌox xcꞌot li cꞌusi lacalbeique, chatsaqueic, chamajeic, chaꞌiqꞌueic echꞌel ta stojol jmeltsanejcꞌopetic ta bicꞌtal temploetic, chatiqꞌueic ta chuquel. Chaꞌiqꞌueic echꞌel ta stojol preserenteetic xchiꞌuc ta stojol coviernoetic ta scoj ti avichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jaꞌ yoꞌ xavalbeic o ti cꞌusi caloje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mu me baꞌyiuc xanopic ti cꞌusi chcꞌot avalique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Voꞌon chajpꞌijubtasic ta cꞌop yoꞌ mu xcuch o yuꞌunic ti muchꞌutic chascrontainique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oy atot ameꞌic noꞌox ta spay avajvalic, oy abanquil avitsꞌinic noꞌox, oy anamtalchiꞌilic noꞌox, oy jaꞌ noꞌox ti muchꞌutic lec xacꞌopon aba achiꞌuquique. Oy jlom chamileic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ep muchꞌutic chopol chayilic o ti avichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero mu xuꞌ chasmilic mi maꞌuc yech tscꞌan ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ti muchꞌutic chcuch yuꞌun li ilbajinele, mi mu xicta o sbaique, jaꞌ chcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ti cꞌalal xavilic ti joyintabil ta yajsolterotac yan preserente li Jerusalene, naꞌic me ti jaꞌo xa chlaje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Voꞌoxuc ti liꞌ nacaloxuc ta Judeae, ba nacꞌ abaic ta vitstic. Li muchꞌutic liꞌ ta yutil jteclume acꞌu loqꞌuicuc echꞌel. Li muchꞌutic loqꞌuemic echꞌele mu xa me xꞌochic tal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yuꞌun ista xa yora chavichꞌic castico chac cꞌu chaꞌal stsꞌibaojic comel ti yajꞌalcꞌoptac Riox ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Abol sbaic tajmec ti muchꞌutic oy xchꞌute xchiꞌuc ti muchꞌutic ta xchuꞌun to yolique, yuꞌun tsots tajmec castico chayacꞌbeic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oy jlom chamileic ta espada. Oy jlom chachuqueic, chaꞌiqꞌueic echꞌel ta yantic o balamil. Li namal crixchanoetique chtal yixtalanic sjunlej li Jerusalene. Liꞌic o ti cꞌu sjalil ch-acꞌbatic permiso yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ti cꞌalal poꞌot xaꞌox xichaꞌsut tale, oy seña ta cꞌacꞌal, xchiꞌuc ta jchꞌulmeꞌtic, xchiꞌuc ta cꞌanaletic. Li crixchanoetic ta sjunlej balamile chiꞌic tajmec yuꞌun tsots tajmec chyucꞌyonaj li mare, xvoꞌoꞌet xa tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Li crixchanoetique ta xchamic xa yilel ta xiꞌel ta scoj ti cꞌusitic chlaj cꞌotuque. Xiꞌemic o mi oy cꞌusi más tsots chtale. Yuꞌun chnic scotol li cꞌusitic oy ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Chil scotol crixchanoetic ti oy jyuꞌele, ti oy jxojobal ti cꞌalal xiyal tal ta ba toc ta balamil voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ti cꞌalal xavilic ti chlic xa cꞌotuc li cꞌusitic lacalbeique, muyubajanic me yuꞌun anaꞌojic xa ti poꞌot xa xacuxiic ta sbatel osile ―xꞌutatic la yuꞌun Jesús li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Iyal la jun loꞌil noxtoc: ―Li icꞌuxe xchiꞌuc li yan teꞌetique, cꞌalal xavilic ti chlaj xa cocojuc yanale, jaꞌ chvinaj o ti ch-och xa voꞌtique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaꞌ noꞌox yech ti cꞌalal xavilic ti chlaj cꞌotuc ti cꞌusitic lacalbeique, jaꞌ chvinaj o ti chistac xa sutel tal ti Rioxe, ti chtal jpas mantal liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ta melel chacalbeic, oy toꞌox cuxuloxuc jlom ti cꞌalal xtal ti jaytos castico lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Li vinajel balamile chlaj onox. Yan li cꞌusitic chcale, mu xchꞌay, persa chcꞌot scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Qꞌuelo me abaic, mu me jaꞌuc ta avoꞌonic li cꞌusitic liꞌ ta sba balamile, xchiꞌuc li cꞌusitic chal avoꞌonique, xchiꞌuc li yacubele. Mu me jaꞌuc xavat o avoꞌonic ti bu chataic li cꞌusitic chtun avuꞌunique. Ti mi jaꞌ noꞌox ta avoꞌonique, chꞌayem avoꞌonic chul jtaoxuc ti cꞌalal xichaꞌsut tale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yuꞌun mu xanaꞌic cꞌusi ora chlic ti jaytos castico ta sjunlej balamile. Coꞌol xchiꞌuc cꞌusi xcacꞌbetic spetsꞌul ti tey petsꞌubil chlaje. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Li voꞌoxuque ichꞌicon noꞌox me ta mucꞌ, cꞌoponic Riox scotol cꞌacꞌal yoꞌ mu xaxiꞌic o li cꞌusitic chtal ti lacalbeique, yoꞌ jun o avoꞌonic chacꞌotic ta jtojol voꞌon ti coꞌol crixchanootique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ta cꞌacꞌaltique tey la ta xchanubtasvan ta tiꞌ mucꞌta templo ti Jesuse. Ta acꞌubaltique chlocꞌ la echꞌel, tey la chba vayuc ta vits Olivotic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jujun la sob chtalic ta tiꞌ mucꞌta templo ti crixchanoetique, yuꞌun la tscꞌan chaꞌiic cꞌusi chal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Poꞌot xaꞌox sqꞌuinic li jꞌisraeletique cꞌalal tsveꞌic pan ti muc bu yichꞌoj svuquesobil xchꞌute. Jaꞌ la sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi stot smeꞌic li jꞌisraeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe, isnopilanic la cꞌu xꞌelan tstaic ta milel ti Jesuse. Yuꞌun la xiꞌemic ta smilel. Yuꞌun la ep tajmec crixchanoetic lec chilic cꞌusitic tspas ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ti Judase, ti Iscariote iꞌacꞌbat sbiine, jaꞌ la lajchavoꞌic o. Ixchꞌunbe la smantal ti Satanase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ba la scꞌopon ti totil paleetique xchiꞌuc ti jayvoꞌ totil yuꞌunic ti jchabiejtemploe. Jaꞌ la ba yalbe ti cꞌu xꞌelan snopoj chacꞌ entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ti cꞌalal iyaꞌiique, xmuyubajic xa la tajmec. ―Chacacꞌbeticotic taqꞌuin ―xutic la ti Judase. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ixchꞌun la ti Judase. Isaꞌ la ti cꞌuxi xuꞌ chacꞌ entrucal ti Jesuse yoꞌ la ti mu xlic o cꞌop yuꞌunic ti xchiꞌiltac ta israelale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Ti cꞌalal ista scꞌacꞌalil ta sveꞌic pan ti muc bu yichꞌoj svuquesobil xchꞌute, cꞌalal tsmilic li chꞌiom chijetic scuenta li sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi stot smeꞌic li jꞌisraeletique, ti Jesuse istac echꞌel li Pedroe xchiꞌuc li Juane. ―Batanic, ba meltsanic li chij ta jtiꞌtic ta qꞌuine ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","―¿Bu chba jmeltsanticotic un? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","―Chacalbeic. Ti cꞌalal xaꞌochic ta yutil Jerusalene, tey chanupic ta be jun vinic scuchoj jpꞌej qꞌuib yaꞌal. Jaꞌ napꞌletaic echꞌel. Ti bu nail ch-oche, tey xaꞌochic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jaꞌ yech xcꞌot avalbeic li yajval nae. “Liꞌ listacoticotic tal li Jchanubtasvaneje. ¿Bu la jcꞌolucal chavacꞌboticotic lanae ti ta jtiꞌticotic o li chij ta qꞌuine?” xavutic cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tey chacꞌ avilic jcꞌol ta xchaꞌcojol sjol sna, lec mucꞌ. Tey xa yacꞌoj li cꞌusitic chtune. Jaꞌ tey xameltsanic li jveꞌeltique ―xꞌutatic la echꞌel li chaꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ibat la xchaꞌvaꞌalic. Jaꞌ la yech istaic chac cꞌu chaꞌal iꞌalbatic echꞌel yuꞌun ti Jesuse. Jaꞌ la tey ismeltsanic ti veꞌlil scuenta qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ti cꞌalal ista yora veꞌele, tey la icꞌot ti Jesuse. Ixchol la sbaic ta mexa xchiꞌuc li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","―Lavi mu to chimilee, sjunul coꞌon liꞌ chajchiꞌinic ta stiꞌel li chij scuenta li qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chacalbeic ti mu xa bu ta jtiꞌ li chije. Jaꞌto ta jtiꞌ ti cꞌalal tey xa tsobolotic jcotoltic yoꞌ bu chacꞌ jpas mantal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ti Jesuse istam la jun mucꞌta pꞌis yaꞌlel uva, “colaval” xut la ti Rioxe. ―Uchꞌanic acotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chacalbeic ti mu xa bu chcuchꞌ li yaꞌlel uvae. Jaꞌto chcuchꞌ ti cꞌalal tey xa tsobolotic jcotoltic yoꞌ bu chacꞌ jpas mantal ti Rioxe ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Istam la jpꞌej pan ti Jesuse, “colaval” xut la ti Rioxe. Ixut la ti pane, iꞌacꞌbatic la. ―Liꞌi jaꞌ jbecꞌtal jtacupal, yuꞌun chcacꞌ jba ta milel ta scoj amulic. Jaꞌ me yech xapasulanic o yoꞌ xanaꞌicon oe ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cꞌalal laj veꞌicuque, istam la noxtoc li mucꞌta pꞌise. ―Li yaꞌlel uva liꞌ chcuchꞌtique, jaꞌ seña ti chcꞌot onox cꞌusi yaloj ti Jtote ti ta jchꞌichꞌel chtoj lamulique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chacalbeic, li muchꞌu chiyacꞌ entrucale liꞌ jchiꞌuctic ta mexae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jaꞌ onox yech yaloj ti Rioxe ti chimile voꞌon ti coꞌol crixchanootique. Abol sba li muchꞌu chiyacꞌ entrucale ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lic la sjacꞌulanbe sbaic muchꞌu junucal ti chacꞌ entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jaꞌo la lic yalulanbe sbaic ti muchꞌu chcom ta yajpasmantalique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lic la albaticuc yuꞌun ti Jesuse: ―Li preserenteetic ta yantic nacione ilbaj xꞌilvanic, mantal noꞌox tspasic. Pero jaꞌ tscꞌanic ti “lec chcꞌuxubinvan li cajpreserentetic leꞌe”, ti xi scꞌoplale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Li voꞌoxuque maꞌuc me yech xapasic. Ti muchꞌu junucal ta xcom avuꞌunic ta avajpasmantalique, mi tscꞌan ti ichꞌbil ta muqꞌue, jaꞌ tscꞌan ti jaꞌ yech chac cꞌu chaꞌal li muchꞌu más creme, ti sjunul yoꞌon chtune. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Avilojic cꞌu xꞌelan tspasic li totiletic liꞌ ta sba balamile, mantal noꞌox tspasic, muc bu ch-abtejic. Naca noꞌox chcꞌot scꞌan sveꞌelic. Yan li voꞌone maꞌuc yech ta jpas. Tal tunicon avuꞌunic chac cꞌu chaꞌal li muchꞌu chichꞌ tal veꞌlile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Li voꞌoxuque jun avoꞌonic achiꞌinicon ti cꞌalal iquichꞌulan crontainele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Yechꞌo un chacacꞌbe apasic mantal chac cꞌu chaꞌal chiyacꞌbe jpas mantal ti Jtot uque yoꞌ coꞌol jun o coꞌontique. Coꞌol ta jpastic mantal. Voꞌoxuc chapasic ta mantal li lajchachop jchiꞌiltactic ta israelale ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","―Simón, chcal avaꞌi. Ti Satanase ay xa scꞌanbe permiso ti Rioxe ti tsqꞌuel mi sjunul avoꞌonic avichꞌojicon ta muqꞌue. Yuꞌun jaꞌ tscꞌan ti chavicta abaique, ti chatani abaic chac cꞌu chaꞌal chbat ta icꞌ li solepal trigoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Li voꞌote lajcꞌoponbe xa Riox yoꞌ mu jꞌechꞌeluc xavicta o aba ta yichꞌelon ta muqꞌue. Ti cꞌalal xavichꞌon ta mucꞌ noxtoque, voꞌot xa me xachanubtas lachiꞌiltac ta yichꞌelon ta muqꞌue yoꞌ mu xicta o sbaic uque ―xꞌutat la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","―Cajval, acꞌu mi coꞌol xiꞌochotic ta chuquel, acꞌu mi coꞌol xilajotic, muc ta alel ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","―Pedro, chacalbe, lavi ta acꞌubaltique ti cꞌalal mu toꞌox ch-ocꞌ queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","―Ti cꞌalal lajtaquic echꞌele, muc xavichꞌic echꞌel ataqꞌuinic, mi jaꞌuc aveꞌelic, mi jaꞌuc axonobic. ¿Mi oy cꞌusi palta avaꞌiic? ―xꞌutatic la yuꞌun Jesús li lajchavoꞌe. ―Chꞌabal ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","―Lavie li muchꞌu oy snutiꞌe, acꞌu yichꞌ echꞌel. Li muchꞌu oy yav staqꞌuine, acꞌu yichꞌ echꞌel uc. Li muchꞌu chꞌabal yespadae, acꞌu xchon jlicuc scꞌuꞌ, acꞌu sman o junuc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ti xꞌelan chacalbeique, yuꞌun chcꞌot onox ti cꞌu xꞌelan tsꞌibabil jcꞌoplale: “Ta spꞌise ta jmulavil”, xi onox tsꞌibabil ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","―Cajval, oy liꞌ chib espadae ―xutic la. ―Taꞌluc o xa li cꞌusi chcaltique ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tsꞌacal to ti Jesuse ilocꞌ la echꞌel, ibat la ta vits Olivotic yuꞌun la tey onox chcꞌotilan. Ixchiꞌinic la echꞌel li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ti cꞌalal icꞌotique ―Cꞌoponic Riox yoꞌ mu xapasic o li cꞌusi chopole ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ti Jesuse ijelav la echꞌel jtsꞌuj. Jaꞌ la yech snamal ibat chac cꞌu chaꞌal snamal xitenobajotique. Isquejan la sba, iscꞌopon la Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Tot, ti xuꞌuc to ti mu xichame, lec. Pero maꞌuc me xcꞌot li cꞌusi chal coꞌon jtuque, jaꞌ acꞌu jpas li cꞌusi chacꞌan li voꞌote ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iyil la ital jun anjel ta vinajel, jaꞌ la tal stsatsubtasbel ti spat xocone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Xvocolet xa la iscꞌopon Riox yuꞌun la mu xa xuꞌ iyaꞌi. Ichiqꞌuinaj la tajmec. Ti xchiqꞌue coꞌol la xchiꞌuc chꞌichꞌ, stsꞌujtsꞌon xa la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ti cꞌalal laj scꞌopon ti Rioxe, isut la yoꞌ bu li buluchvoꞌe. Vayem la itae scotolic yuꞌun la chat yoꞌonic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","―¿Cꞌu yuꞌun ti chavayique? Licanic, cꞌoponic Riox yoꞌ mu xapasic o li cꞌusitic chopole ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ti cꞌalal xyaquet chloꞌilaj ti Jesuse, jaꞌo la tey icꞌot epal crixchanoetic. Jaꞌ la babe ti Judase, jaꞌ la lajchavoꞌic o ta yajchancꞌop ti Jesuse. Cꞌot la sbutsꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","―Judas, ¿mi ta butsꞌel chavacꞌon entrucal yaꞌel voꞌon ti coꞌol crixchanootique? ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ti cꞌalal iyilic li buluchvoꞌe ti jaꞌ cꞌot stsaquel ti Jesuse ―Cajval, ¿mi xuꞌ chcacꞌbeticotic espada? ―xutic la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oy la jun xchiꞌilic ta yajchancꞌop ti Jesuse, isloqꞌues la yespada, istuchꞌbe la loqꞌuel sbatsꞌichiquin ti smozo más totil palee. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","―Mu xavut ―xꞌutat la yuꞌun ti Jesuse. Ti Jesuse ispicbe la syayijemal, lec xa la icom xchiquin ti mozoile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ti Jesuse iscꞌopon la ti totil paleetique, xchiꞌuc ti jayvoꞌ totil yuꞌunic ti jchabiejtemploe, xchiꞌuc ti jmeltsanejcꞌopetique ti cꞌot tsacvanicuque: ―¿Cꞌu yuꞌun ti ta espada ta teꞌ tal atsaquicon chac cꞌu chaꞌal jꞌeleqꞌue? ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ti tey onox chichanubtasvan ta tiꞌ mucꞌta templo jujun cꞌacꞌale, ¿cꞌu yuꞌun ti mu teyuc noꞌox atsaquicon yaꞌele? Ti xꞌelan tal atsaquicone, yuꞌun iꞌacꞌbat permiso yuꞌun Riox lavajvalique, jaꞌ ti Satanase, ti yajval mulile ―xꞌutatic la ti jtsacvanejetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ti cꞌalal istsaquic ti Jesuse, tey la iyiqꞌuic echꞌel ta sna ti más totil palee. Li Pedroe nomnomtic la tijil echꞌel ta spat ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ti cꞌalal icꞌotique, istsoyic la cꞌocꞌ ta oꞌlol tiꞌna. Tey la joyol chcꞌatinic ti crixchanoetique. Li Pedroe tey la ichoti, icꞌatin uc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iꞌile la yuꞌun jun quiarail ti tey chotol chcꞌatin li Pedroe. Iqꞌuelbat la sat. ―Li vinic leꞌe jaꞌ xchiꞌil li muchꞌu ay atsaquic tale ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","―Mu xcojtiquin ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta jliquel o iꞌojtiquine la yuꞌun jun vinic. ―Li voꞌote jaꞌ achiꞌil li vinic leꞌe ―xꞌutat la. ―Iꞌi, muc bu jchiꞌin ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Iꞌechꞌ xaꞌox la junuc ora. ―Melel jaꞌ xchiꞌil li Jesuse yuꞌun jgalilea uc ―xi la noxtoc otro jun. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","―Mu jnaꞌ li cꞌusi chavale ―xi la li Pedroe. Ti cꞌalal yolel chal yeche, jaꞌo la iꞌocꞌ quelem. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ti Cajvaltic Jesuse ijoyij la, iqꞌuelbat la sat li Pedroe. Jaꞌo la iyul ta sjol ti yech onox iꞌalbat yuꞌun ti Cajvaltique: “Lavie ti cꞌalal mu toꞌox ch-ocꞌ queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone”, xꞌutat onox la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ilocꞌ la echꞌel li Pedroe, ba la yoqꞌuita sba tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ti jayvoꞌ ixchabiic ti Jesuse islabanic la, ismajic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ismacbeic la sat ta pocꞌ. Istꞌaxbeic la ta majel xocon sat. ―Alo caꞌtic muchꞌu lasmaj ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Islabanic la tajmec. Scotol la cꞌusi iyalbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ti cꞌalal isacube, istsob la sba scotol ti jmeltsanejcꞌopetic yuꞌun li jꞌisraeletique, jaꞌ ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Ti Jesuse iyiqꞌuic la echꞌel yoꞌ bu tsobolique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Alboticotic mi voꞌot Cristoot ti yaloj Riox chapasoticotic ta mantale ―xutic la. ―Voꞌon, mi xacutique, mu onox xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mi oy cꞌusi chajacꞌbeic uque, jnaꞌoj ti mu xatacꞌbecone, ti mu xacoltaicon oe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Voꞌon ti coꞌol crixchanootique, chichoti xa ta sbatsꞌicꞌob ti Riox ta vinajele ti oy syuꞌele, ta jpas mantal ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","―¿Mi yech ti voꞌot Xchꞌamalot ti Rioxe cheꞌe? ―xut la scotolic. ―Yech ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","―¿Cꞌu xa stu cuꞌuntic yan rextico? Icaꞌitic xa ti tspꞌis sba ta Rioxe ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Istam la sba scotolic, iyiqꞌuic la echꞌel ta stojol covierno Pilato ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lic la sticꞌbeic smul. ―Li vinic liꞌi yolel tstsob svinic liꞌ ta jlumalticotique. Chal ti mu xuꞌ xcacꞌbeticotic tojel aqꞌuel ti preserente Césare. Jaꞌ la preserente li stuque. Jaꞌ la tꞌujbil yuꞌun Riox ti chispasoticotic ta mantale ―xutic la ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","―¿Mi yech ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale? ―xꞌutat la yuꞌun Pilato ti Jesuse. ―Yech ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","―Chꞌabal smul li vinic liꞌi ―xut la totil paleetic xchiꞌuc crixchanoetic ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Xꞌavlejetic xa la. ―Mu me xacolta yuꞌun jaꞌ ta socbe sjol scotol li jchiꞌilticotique. Ta xchanubtasvan ta sjunlej jlumalticotic liꞌ ta estado Judeae. Istambe tal ta estado Galilea, iyul xa liꞌ cꞌalale ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cꞌalal iyaꞌi ti Pilatoe ti baꞌyi ichanubtasvan ta estado Galilea ti Jesuse ―¿Mi jgalilea cheꞌe? ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ti cꞌalal iyaꞌi ti jaꞌe, istac la echꞌel ta stojol Erodes. Ti Erodese jaꞌ covierno ta estado Galilea. Ti cꞌalal istsaquic ti Jesuse, jaꞌo la tey talem ta Jerusalén ti Erodese. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ti Erodese, ti cꞌalal iyil ti Jesuse, xmuyubaj xa la tajmec yuꞌun la voꞌne xa onox tscꞌan chojtiquin. Yuꞌun la yaꞌyoj ti cꞌusitic lec ispase. “Tey ta jqꞌuel cꞌusi ora xquilbe slequilal syuꞌelal ti Jesuse”, xi onox la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ti Erodese ep la cꞌusitic isjacꞌulanbe ti Jesuse, pero mi jpꞌel muc la xtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Teic la noxtoc ti totil paleetique xchiꞌuc ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Capemic xa la tajmec isticꞌbeic la smul ta stojol Erodes ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ti Erodese xchiꞌuc ti yajsolterotaque muc la xichꞌic ta mucꞌ ti Jesuse. Islabanic la, istsꞌacubtasic la. Iyacꞌbeic la slap cꞌuꞌul, coꞌol la xchiꞌuc scꞌuꞌ preserenteetic. Tsꞌacal to istac la sutel ta stojol Pilato, slapoj la echꞌel ti cꞌuꞌule. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti Pilatoe jaꞌto la lec iscꞌopon o sbaic xchiꞌuc ti Erodese, yuꞌun la mu toꞌox bu lec xil sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ti Pilatoe istsob la scotol ti totil paleetique, xchiꞌuc ti jmeltsanejcꞌopetic yuꞌun li jurioetique, xchiꞌuc ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","―Li vinic liꞌ avicꞌojic tale, ti avalic ti jaꞌ tsocbe sjol li crixchanoetique, avaꞌyojic ti ijacꞌbe cꞌusi smule, pero mi jsetꞌ muc bu ijtabe smul. Yech noꞌox chanopic ti oy smule. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jaꞌ noꞌox yech li Erodese muc bu istabe smul uc. Ti istabeuc smule, muc stac sutel tal ti yechuque. Chꞌabal smul ti chichꞌ milele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jaꞌ noꞌox chcal ti acꞌu yichꞌ arsiale. Cꞌalal xlaje, ta jcolta echꞌel ―xꞌutatic la yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ta jujun sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi stot smeꞌic li jurioetique, ti Pilatoe tsloqꞌues jun jchuquel ti bu junucal tscꞌanic loqꞌuesbele. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Xꞌavlajet xa la scotol ti crixchanoetique: ―Jaꞌ acꞌu chamuc leꞌe. Jaꞌ loqꞌueso li Barrabase ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti Barrabase, ti iꞌoch ta chuquele, yuꞌun la istsob toꞌox svinic, iscrontain la ti covierno ta Jerusalene, imilvan la noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ti Pilatoe ixchaꞌcꞌopon la ti jurioetique yuꞌun tscꞌan ox la tscolta ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Xꞌavlajetic xa la liquel noxtoc. ―¡Jipano ta cruz! ¡Jipano ta cruz! ―xiic xa la tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","―Pero ¿cꞌusi smul avuꞌunic? Li voꞌone chꞌabal smul chcaꞌi ti ta xcham oe. Jaꞌ noꞌox chcal ti acꞌu yichꞌ arsiale. Cꞌalal xlaje, ta jcolta echꞌel ―xi la ta yoxꞌechꞌelal ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tey la xꞌavlajetic o, jaꞌ la tscꞌanic ti chjipanbatic ta cruze. Ti xꞌelan tey xꞌavlajetic ti crixchanoetique xchiꞌuc ti totil paleetique, ichꞌunbatic onox la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ti Pilatoe isloqꞌues la mantal chac cꞌu chaꞌal iscꞌan ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jaꞌ la isloqꞌues mantal ti acꞌu sloqꞌuesel ti muchꞌu iscꞌanic loqꞌuesbele, jaꞌ ti muchꞌu iꞌoch ta chuquel ta scoj ti istsob svinique, iscrontain coviernoe, xchiꞌuc ti imilvane. Ti Pilatoe iyacꞌ la orten ti acꞌu ba sjipanel ta cruz ti Jesuse yuꞌun la jaꞌ yech iscꞌan ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Cꞌalal iyiqꞌuic echꞌele, ti cꞌalal ba sjipanic ta cruze, scajanoj la echꞌel ta snequeb scruzal ti Jesuse. Isnupic la ta be jun jurio, Simón la sbi. Liquem la tal ta jun jteclum, Cirene sbi. Poꞌot xaꞌox la xꞌoch ta yutil Jerusalén. Istsaquic la, iyacꞌbeic la scuch echꞌel ti scruzal Jesuse. Jaꞌ la babe echꞌel ti Jesuse, jaꞌ la napꞌal ti Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ep la viniquetic, ep la antsetic napꞌalic echꞌel. Ti antsetique iyoqꞌuitabeic la tajmec svocol ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ti Jesuse iscꞌopon la ti antsetique. ―Antsetic, voꞌoxuc ti liꞌ nacaloxuc ta Jerusalene, mu xavoqꞌuitaicon. Oqꞌuitao aba atuquic, oqꞌuitao avolic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yuꞌun chtal onox li casticoe. Ti cꞌalal xtale, “más mu cꞌu snaꞌic li muchꞌutic mu snaꞌ xꞌalajique. Más abol jbatic, voꞌotic ti oy coltique”, xachiic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Chac noꞌox jinuc tal ta jbatic li vitsetique yoꞌ mu xa xcaꞌitic o li casticoe”, xachiic acotolic ti liꞌoxuc ta Jerusalene yuꞌun toj tsots li castico chtale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Li voꞌone jchꞌunoj scotol li cꞌusitic yaloj ti Rioxe pero chquil to jvocol. Buuc xa onox li voꞌoxuque, ti mu xachꞌunic cꞌusitic yaloj ti Rioxe, más to chavil avocolic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iyiqꞌuic la echꞌel otro chaꞌvoꞌ ti tsots smul staojique. Coꞌol la ba smilelic ta cruz xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ti cꞌalal icꞌotic yoꞌ bu Baquel Jol Anima sbi li balamile, tey la isjipanic ta cruz ti Jesuse xchiꞌuc ti chaꞌvoꞌ tsots smulique. Jun la scruzal ta jbatsꞌicꞌobtic, jun la ta jsurtotic. Jaꞌ la ta oꞌlol scruzal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti Jesuse iscꞌoponbe la Riox ti crixchanoetique: ―Tot, acꞌo ta pertonal li crixchanoetique yuꞌun mu snaꞌic li cꞌusi tspasique ―xi la. Ti solteroetique ixchꞌacbe la sbaic ti scꞌuꞌ Jesuse. Itajinic la, isqꞌuelic la muchꞌu junucal chichꞌ julic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ti crixchanoetic tey vaꞌajtic chqꞌuelvanique, islabanic la ti Jesuse. Ilabanvanic la ti jmeltsanejcꞌopetic uque. ―Iyetꞌesbe xchamelic li crixchanoetique. Mi yech ti jaꞌ tꞌujbil yuꞌun Riox chispasotic ta mantale, acꞌuquic scolta sba un ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ti solteroetique ilabanvanic la uc. Inopojic la ta yoc cruz, iyacꞌbeic la binagre ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","―Mi yech ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale, pojoquic aba un ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bajbil la jpech tabla ta sjol scruzal ti Jesus uque. Tsꞌibabil la ta oxtos cꞌop: griego, xchiꞌuc latin, xchiꞌuc ebreo. Jaꞌ la tey yaloj ti cꞌusi smul ti imile oe. “Liꞌi jaꞌ yajpasvanejic ta mantal li jurioetique”, xi la tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ti chaꞌvoꞌ tsots smule ti coꞌol ijipanatic ta cruz xchiꞌuc ti Jesuse, ti june islaban la ti Jesuse. ―Mi yech ti voꞌot Cristoote ti stꞌujojot Riox chapasoticotic ta mantale, pojoquic aba un. Pojoticotic uc ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ti june ispajes la ti xchiꞌile. ―¿Mi mu xaxiꞌ o ti Rioxe ti chalaban li muchꞌu coꞌol chimilatotic jchiꞌuctique? ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Li voꞌotique saꞌbil cuꞌuntic yuꞌun chopol cꞌusitic ijpastic. Li vinic liꞌi mu cꞌusi chopol spasoj ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","―Cajval, naꞌon me ti cꞌalal xtal apas mantal liꞌ ta sba balamile ―xut la Jesús ti muchꞌu ipajesvane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","―Ta melel chacalbe, lavie coꞌol chibatic ta vinajel ―xꞌutat la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ta oltic la cꞌacꞌal iꞌicꞌub, yuꞌun la imac sat li cꞌacꞌale. Oxib la ora icꞌ li osile. Ti mucꞌta pocꞌ scꞌalobil li mucꞌta templo ta Jerusalene, ijat la ta oꞌlol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ti Jesuse iꞌavan la. ―Tot, icꞌbon li jchꞌulele ―xi la. Jaꞌo la ilocꞌ xchꞌulel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ti capitan solteroe, ti cꞌalal iyil ti cꞌusitic icꞌote, iyichꞌ la ta mucꞌ ti Rioxe. ―Ta melel ti chꞌabal smul li vinic liꞌi ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Scotol ti crixchanoetic tey tsobolique, ti cꞌalal iyilic ti cꞌusitic icꞌote, isut la ta snaic. Smaj xa la echꞌel stiꞌ yoꞌonic yuꞌun la ixiꞌic mi tstojbeic Riox ti ismilic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ti muchꞌutic lec iscꞌopon sbaic xchiꞌuc ti Jesuse, xchiꞌuc li buluchvoꞌe, xchiꞌuc li antsetic ti liquemic tal ta estado Galilea ti ixchiꞌinic tal ti Jesuse, nomnomtic la isqꞌuelic. Iyilic la ti cꞌusitic icꞌote. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oy toꞌox la jun vinic, José la sbi. Liquem la tal ta jun jteclum Arimatea sbi, tey ta estado Judea. Ochem la ta meltsanejcꞌop. Lec la yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Smalaoj la ti chtal pasvanuc ta mantal ti Rioxe. Mu la bu isticꞌ sba ti cꞌalal isaꞌbeic smul Jesús ti yan jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ba la scꞌopon ti Pilatoe. Jaꞌ la ba scꞌanbe spat xocon ti ánima Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ti Pilatoe iyacꞌ la permiso. Ti Josee isyales la ta cruz ti ánimae, ispix la ta saquil pocꞌ, ba la sticꞌ ta chꞌojbil ton. Mu to la muchꞌu tey mucbil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Xmal xa la ismuquic. Jaꞌo la ti cꞌalal ta xchap sbaic ti ta xcuxic ta smalel cꞌacꞌale. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Li antsetic ixchiꞌinic tal ta Galilea ti Jesuse, ibatic la ta muquenal uc. Iyilic la cꞌu xꞌelan itelanat comel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ti cꞌalal iyilique, isut la ta snaic. Ti cꞌalal icꞌotique, ismeltsanic la ta ora muil poxetic yuꞌun la jaꞌ chba yacꞌbeic ta spat xocon ti Jesuse yoꞌ la mu xtuib o ta orae. Yuꞌun jaꞌ yech snaꞌic li jurioetique. Pero muc la xba yaqꞌuic ta ora yuꞌun la jaꞌo xa ta xcuxic chac cꞌu chaꞌal tsꞌibabil comel li smantal Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta primero cꞌacꞌal xemana, jaꞌ li romincoe, jaꞌo la ibat ta muquenal li antsetique. Más xa la ep ibatic. Sob toꞌox la tajmec iloqꞌuic. Iyichꞌic la echꞌel ti muil poxetic ismeltsanique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ti cꞌalal icꞌotique, setetinbil xaꞌox la loqꞌuel cꞌot staic li smac stiꞌil chꞌene. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iꞌochic la ta yut chꞌen pero mu xa la bu tey istaic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xchꞌayet o xa la yoꞌonic. Jaꞌo la iyilic chaꞌvoꞌ viniquetic yilel tey ta stsꞌelic. Chtupꞌ o la jsatic saquil ti scꞌuꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ixiꞌic la tajmec li antsetique, isnijan la sbaic. ―¿Cꞌu yuꞌun tal aqꞌuelic ta muquenal li muchꞌu cuxul ta sbatel osile? ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mu xa bu liꞌi, ichaꞌcuxi xa. Yuleso ta ajolic ti yech onox layalbeic ti cꞌalal tey toꞌox achiꞌuquic ta Galileae. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Voꞌon ti coꞌol crixchanootique, persa chiyaqꞌuic entrucal ta scꞌob jmulaviletic. Chisjipanic ta cruz, chismilic. Chimuque. Ta yoxibal cꞌacꞌal chichaꞌcuxi”, ti xayutic onoxe ―xꞌutatic la li antsetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Li antsetique iyul la ta sjolic ti yech onox iꞌalbatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ti cꞌalal iloqꞌuic ta chꞌene, isutic la. Ti cꞌusitic iꞌalbatique ba la yalbeic ta anil li buluchvoꞌe xchiꞌuc ti muchꞌutic xchꞌunojic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Li antsetic ti ba yalbeic li apoxtoletique, jaꞌic la li María liquem tal ta Magdalae, xchiꞌuc li Juanae, xchiꞌuc li otro jun Maríae li smeꞌ Jacoboe, xchiꞌuc li yan xchiꞌilique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Li apoxtoletique isnopic la ti chvoviic li antsetique, mu la bu ixchꞌunic ti cꞌusi iꞌalbatique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero li Pedroe anil la ibat ta muquenal. Ti cꞌalal icꞌote, isnachꞌita la ochel li yut chꞌene. Iyil la ti cꞌajom xa tey ti saquil poqꞌue ti pixbil o toꞌox spat xocon ti Jesuse. Ti cꞌalal isut li Pedroe, tey la tsnopilan cꞌusi smelol ti cꞌusi iyile. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti cꞌalal ichaꞌcuxi loqꞌuel ta smuquenal ti Jesuse, jaꞌo la ta smalel cꞌacꞌal oy la chaꞌvoꞌ ti yichꞌojic ta mucꞌ ti Jesuse, iloqꞌuic la echꞌel ta Jerusalén, ibatic la ta jun parajel Emaús sbi. Oy nan buluchibuc kilómetro xil sba xchiꞌuc li Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jaꞌ la tsloꞌiltaic echꞌel ti cꞌuxi icham ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cꞌalal yolel chloꞌilajique, jaꞌo la tey ital ta spatic ti Jesuse. Ixchiꞌinic la echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero imacbat la satic yuꞌun ti Rioxe, muc la xojtiquinic mi jaꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","―¿Cꞌusi laloꞌilique ti chavat o avoꞌonic chquile? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Itacꞌav la jun, Cleofas la sbi: ―Atuc xa noꞌox jnaꞌ ti liꞌ talemot ta Jerusalene ti muc bu avaꞌyoj ti cꞌusi ispasic sjayibal cꞌacꞌale ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","―¿Cꞌusi ispasic cheꞌe? ―xi la ti Jesuse. ―Yuꞌun ismilic ti Jesus Nazarete, ti muchꞌu iyal scꞌop Rioxe. Icoltaat tajmec yuꞌun ti Rioxe, iyacꞌulan iluc slequilal syuꞌelal. Lec ichanubtasvan. Lec icaꞌiticotic ti cꞌusi iyale. Lec iyaꞌiic scotol li jchiꞌiltactique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jaꞌ noꞌox li totil paleetique xchiꞌuc li cajmeltsanejcꞌoptique inop scꞌoplal yuꞌunic ti persa ta xchame, iyacꞌbeic entrucal li coviernoe. Ijipanat ta cruz. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Li voꞌoticotique jpatoj xaꞌox coꞌonticotic ti jaꞌ ch-och ta preserenteale, pero yoxibal xa cꞌacꞌal ti ismilique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Xchiꞌuc cꞌusuc, oy jayvoꞌ antsetic ti coꞌol ijchiꞌinticotic ti Jesuse, yamal toꞌox iꞌayic ta muquenal. Xchꞌayet o xa coꞌonticotic ti cꞌusi yul yalique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mu xa la bu tey istaic ti Jesuse. Iyilic la anjeletic, iꞌalbatic la ti cuxule. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Cꞌalal iyalic chac taje, ibatic jayvoꞌ viniquetic ti coꞌol ijchiꞌinticotic ti Jesuse, ba sqꞌuelbeic ti smuquenale. Jaꞌ la yech iyilic chac cꞌu chaꞌal iyal li antsetique. Pero ti Jesuse mu xa la bu iyilic ―xutic la Jesús li chaꞌvoꞌ ibat ta Emause. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","―Yuꞌun mu xachꞌunic tajmec ti cꞌusitic yaloj ti yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tsꞌibabil onox ti persa chacꞌ svocol ti Cristoe ti cꞌalal mu toꞌox ch-och ta pasmantale ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lic la albatuc yaꞌiic ti cꞌu xꞌelan tsꞌibabil scꞌoplal ta scꞌop Rioxe. Istambe la ta svun Moisés, xquechet la iyal ti cꞌu xꞌelan stsꞌibaojic comel ti yan yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ti cꞌalal icꞌotic ta Emause, ti Jesuse más to la nom chbat yilel. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Li chaꞌvoꞌ viniquetique ispajesic la ta persa. ―Pajan liꞌtoe, vayan, yuꞌun ch-icꞌub xa ―xutic la. Ti Jesuse ixchꞌun la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ti cꞌalal ichoti ta mexa xchiꞌuquique, istam la jpꞌej pan. “Colaval” xut la ti Rioxe, jaꞌo la ixut ti pane, iꞌacꞌbatic la li chaꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jaꞌo la ijambat satic yuꞌun ti Rioxe, jaꞌto la iyojtiquinic. Pero isacchꞌay la ta ora ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","―¿Cꞌu noꞌox yuꞌun ti muc xcojtiquintic yaꞌele ti cꞌalal iloꞌilaj tal ta bee, ti toj lec smelol iyal li scꞌop Rioxe? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ora la isutic ta Jerusalén. Tey la tsobolic cꞌot staic li buluchvoꞌ apoxtoletique. Oy la yan tey xchiꞌuquic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ti cꞌalal icꞌotique, jaꞌ la baꞌyi iꞌalbatic ti yech ti ichaꞌcuxi ti Cajvaltic Jesuse, ti iyacꞌ sba iluc ta stojol li Simon Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jaꞌo la lic yalic uc ti cꞌu xꞌelan iloꞌilaj xchiꞌuquic ta be ti Jesuse, ti muc xojtiquinic ta orae, ti jaꞌto iyojtiquinic ti cꞌalal ixut ti pane. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ti cꞌalal xyaquet toꞌox chalic cꞌu xꞌelan iyilic ti Jesuse, jaꞌo la tey vaꞌal iyul yoꞌ bu tsobolique. ―Junuc me avoꞌonic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Toj la xiꞌel icꞌotic. ―Chꞌulelal nan ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","―¿Cꞌu yuꞌun ti chaxiꞌique? ¿Cꞌu yuꞌun mu xachꞌunic ti voꞌone? ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Qꞌuelavilic li jcꞌobe xchiꞌuc li coque. Voꞌon. Laꞌ piquicon. Ti chꞌulelalicone, chꞌabal jpat jxocon, chꞌabal jbaquel ti yechuque ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cꞌalal iꞌalbatic chac taje, jaꞌo la iyacꞌ iluc ti scꞌobe xchiꞌuc ti yoque. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ti cꞌalal iyilique, mu xa la cꞌu yech o yoꞌonic. Pero mu la snaꞌic mi yech ti jaꞌe. Yech noꞌox la xchꞌayet yoꞌonic. ―¿Mi oy cꞌusi jlajestic jsetꞌuc? ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iyacꞌbeic la jsetꞌ bacubtasbil choy xchiꞌuc la jsetꞌ ajapom. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yiloj la scotolic ti istsaque, ti islajese. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","―Ti cꞌalal jchiꞌucoxuc toꞌoxe, lacalbeic ti persa onox ta xcꞌot chac cꞌu chaꞌal stsꞌibaoj comel jcꞌoplal ti Moisese xchiꞌuc ti yan yajꞌalcꞌoptac Rioxe, xchiꞌuc ta svunal jqꞌuevujtic ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Icoltaatic la ta yaꞌibel smelol ti cꞌusitic tsꞌibabil ta scꞌop Rioxe, jaꞌto la yech iyaꞌibeic o smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","―Tsꞌibabil ta scꞌop Riox “ti muchꞌu chtal pasvanuc ta mantale persa baꞌyi chacꞌ svocol, chmile, pero ta xchaꞌcuxi ta yoxibal cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Chvinaj scꞌoplal ta sjunlej balamil ti jaꞌ chloqꞌuic o ta mulil li crixchanoetique, ti chictaic o spasel li cꞌusitic chopole, ti ch-acꞌbatic o pertonal yuꞌun li smulique. Baꞌyi chvinaj liꞌ ta Jerusalene, tsꞌacal to ta xvinaj echꞌel ta yantic balamil”, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Voꞌoxuc rexticooxuc ti icacꞌ jvocole, ti lichaꞌcuxie, ti jaꞌ chloqꞌuic o ta mulil li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chajtacbeic tal ti Chꞌul Espíritue ti yaloj onox ti Jtote ti chacꞌ achiꞌinique. Liꞌanic to me ta Jerusalén ti cꞌu sjalil xtal o ti Chꞌul Espíritue yuꞌun jaꞌ ta stsatsubtas avoꞌonic ta yalel aꞌyuc ti cꞌusitic caloje xchiꞌuc ti cꞌusitic ijpase ―xꞌutatic la yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tsꞌacal to iꞌiqꞌueic la loqꞌuel ta Jerusalén yuꞌun ti Jesuse. Belel Betania la istamic echꞌel. Ti cꞌalal poꞌot xaꞌox la xcꞌotic ta Betaniae, istoy la xchibal scꞌob ti Jesuse, iꞌacꞌbatic la comel bentisyon li buluchvoꞌ apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ti cꞌalal yolel ch-acꞌbatic bentisyone, jaꞌo la imuy ta vinajel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ti cꞌalal iyilic ti imuye, más to la iyichꞌic ta mucꞌ. Xmuyubajic xa la sutel ta Jerusalén. ");
INSERT INTO tzoZNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Scotol la cꞌacꞌal chcꞌotilanic ta mucꞌta templo. ―Colaval ti atoj li jmulticotique ―xutic la ti Rioxe.");
INSERT INTO tzoZNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ti cꞌalal chꞌabal toꞌox li vinajel balamile, tey onox ti Muchꞌu ay yalbotic cꞌu xꞌelan yoꞌon ti Rioxe. Yuꞌun tey onox xchiꞌuc ti Rioxe. Ti Muchꞌu iꞌaye jaꞌ onox ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti cꞌalal chꞌabal toꞌox li vinajel balamile, tey onox xchiꞌuc ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ti Muchꞌu iꞌaye jaꞌ ispas scotol li cꞌusitic oye. Ti manchuc tey onox ti Muchꞌu ispase, mu cꞌusi oy ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ti Muchꞌu iꞌaye cuxul ta sbatel osil. Jaꞌ noꞌox yech xuꞌ chiyacꞌbotic jcuxlejaltic ta sbatel osil voꞌotic ti jmulavilotic liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Coꞌol xchiꞌuc luz ti oy xojobal ta acꞌubaltique ti mu snaꞌ xtupꞌe. Jaꞌ noꞌox yech ti Muchꞌu iꞌaye, acꞌu mi muc xꞌichꞌe ta mucꞌ yuꞌun ti crixchanoetique ti cꞌalal iꞌay liꞌ ta sba balamile, chalulan onox ti jaꞌ chacꞌ jcuxlejaltic ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Oy toꞌox jun jchiꞌilticotic ta jurioal, Juan sbi. Jaꞌ itꞌuje yuꞌun ti Rioxe ti jaꞌ iyalbe scꞌoplal ti Muchꞌu chiyacꞌbotic jcuxlejaltic ta sbatel osile. Ti baꞌyi tal yal aꞌyuque, jaꞌ yoꞌ jchꞌunticotic oe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Maꞌuc chiyacꞌbotic jcuxlejaltic ti Juane; jaꞌ noꞌox itꞌuje ti iyalbe scꞌoplal ti Muchꞌu chiyacꞌbotic jcuxlejaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yuꞌun poꞌot xaꞌox xacꞌ sba iluc ti stuc noꞌox xuꞌ chiyacꞌbotic jcuxlejaltic ta sbatel osil jcotoltique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jaꞌ onox ispas crixchanoetic xchiꞌuc scotol li cꞌusitic oye. Ti cꞌalal iꞌay liꞌ ta sba balamile, muc xchꞌunic ti crixchanoetique ti jaꞌ spasoj scotole. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Liꞌ iꞌay ta jlumalticotic, voꞌoticotic li juriooticotique, yuꞌun voꞌne onox stꞌujojoticotic. Pero ep jchiꞌilticotic muc xichꞌic ta mucꞌ ti cꞌalal iꞌaye. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ti jayvoꞌ iquichꞌticotic ta muqꞌue, ti ijchꞌunticotic ti jaꞌ chiyacꞌbotic jcuxlejaltic ta sbatel osile, “xchꞌamaloxuc xa Riox”, xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti “xchꞌamaloxuc xa Riox” xiyutoticotique, mu voꞌoticoticuc ijcꞌanticotic chꞌamalinel. Scꞌan noꞌox yoꞌon stuc ti Rioxe ti lixchꞌamalinoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ti Muchꞌu iꞌaye iꞌayan chac cꞌu chaꞌal voꞌotic. Lixchiꞌinoticotic ta naclej, voꞌoticotic li juriooticotique. Iquilticotic ti toj lec yoꞌone yuꞌun jaꞌ ti junjun Xchꞌamal ti Rioxe. Jaꞌ iyacꞌ quilticotic ti scꞌanojotic tajmec ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ti Juane liyalboticotic scꞌoplal: ―Leꞌe jaꞌ li muchꞌu lacalbeic ti tsꞌacal to chtale. Ical onox ti “jaꞌ tsꞌacal chtal ti muchꞌu más oy syuꞌele. Li voꞌone mu cꞌu xitun o. Ti cꞌalal mu toꞌox chiꞌayane, tey onox ti stuque”, xichi ―xi ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jcotoltic ti jchꞌunojtic xa ti jaꞌ Xchꞌamal Riox ti Jesucristoe, iquiltic xa ti toj lec yoꞌone, ti scꞌuxubinojotic scotol cꞌacꞌale, ti chiscoltaotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ti Moisese iyal comel li smantaltac Rioxe pero ti ital ti Jesucristoe, jaꞌ ivinaj o ti scꞌanojotic tajmec ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mi jun muc muchꞌu yiloj ti Rioxe. Ti Rioxe yo junuc o ti Xchꞌamale, scꞌanoj tajmec. Ti Riox Chꞌamalile jaꞌ iyacꞌ iluc cꞌu xꞌelan ti Stote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ti cꞌalal yolel chalbe scꞌoplal Jesucristo ti Juane, tey cꞌot cꞌoponatuc yuꞌun jayvoꞌ paleetic xchiꞌuc ti muchꞌutic iscoltaic ta abtel ti paleetique. Jaꞌ itacvanic echꞌel ti cajmeltsanejcꞌopticotic ta Jerusalene, voꞌoticotic li juriooticotique. ―¿Muchꞌuot? ―xutic cꞌotel ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ti Juane jamal iyal: ―Mu voꞌonicon Cristoon. Mu voꞌonicon stꞌujojon Riox ti ta jpas mantale ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","―¿Muchꞌuot cheꞌe? ¿Mi voꞌot ti Eliasote? ―xutic noxtoc. ―Mu voꞌonicon ―xi ti Juane. ―¿Mi mu voꞌoticot ti yajꞌalcꞌopot Riox ti ta jmalaticotic chtale? ―xutic noxtoc. ―Mu voꞌonicon ―xi ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","―¿Muchꞌuot cheꞌe? Yuꞌun chcꞌot calbeticotic ti muchꞌutic listacoticotic tale. ¿Cꞌusi talem apas cheꞌe? ―xutic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Itacꞌav ti Juane: ―Voꞌon jcꞌoplal ti iyal onox ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee. Jaꞌ yech iyal chac liꞌi: “Ta to xtal jun jchiꞌiltic ta israelal, tsots ch-avetaj ta xocol balamil. Chtal xa ti Cajvaltique. Ictaic xa spasel li cꞌusitic chopole. Xachꞌunbeic me ti cꞌusitic chale, xi chalbe ti jchiꞌiltactique”, xi onox ti Isaíase ―xi ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ti muchꞌutic itaqueic echꞌele ochemic ta fariseoal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","―¿Cꞌu yuꞌun ti chavacꞌ ichꞌvoꞌe mi mu voꞌoticot stꞌujojot Riox ti chapasoticotic ta mantale, mi mu voꞌoticot ti Eliasote, mi mu voꞌoticot ti yajꞌalcꞌopot Riox ti ta jmalaticotique? ―xutic noxtoc ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","―Li voꞌone jaꞌ noꞌox chcacꞌbe yichꞌic voꞌ ti muchꞌutic chictaic spasel li cꞌusitic chopole. Ti muchꞌu más oy syuꞌele liꞌ achiꞌuquic lavie pero mu to xavojtiquinic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jaꞌ ti lacalbeic onox ti tsꞌacal to chtale. Li voꞌone mu cꞌu xitun o. Acꞌu mi slocꞌbeluc noꞌox xonob, mu cꞌu xuꞌ jcolta o ―xꞌutatic yuꞌun ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jaꞌ yech iloꞌilajic ta jteclum Betábara ta jech ucꞌum Jordán yoꞌ bu iyacꞌ ichꞌvoꞌ ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta yocꞌomal iyil ti Juane ti tey xa xtal ti Jesuse. Ti Juane jaꞌ yech liyalboticotic chac liꞌi, voꞌoticotic ti tey jchiꞌucticotique: ―Qꞌuelavilic, leꞌ xa xtal li muchꞌu coꞌol xchiꞌuc xchij Riox yaꞌele. Ta xichꞌ milel yuꞌun jaꞌ chtoj o jmultic jcotoltic ta sjunlej balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Leꞌe jaꞌ ti muchꞌu lacalbeic ti tsꞌacal to chtale. Ical onox ti “jaꞌ tsꞌacal chtal li muchꞌu más oy syuꞌele. Li voꞌone mu cꞌu xitun o. Ti cꞌalal mu toꞌox chiꞌayane, tey onox li stuque”, xichi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Li voꞌone mu toꞌox xcojtiquin mi jaꞌ li Muchꞌu tstoj jmultique. Ti baꞌyi tal cacꞌ ichꞌvoꞌ li voꞌone, jaꞌ yoꞌ xcojtiquintic o jcotoltic, voꞌotic li jꞌisraelotique ―xiyutoticotic ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Iyal noxtoc: ―Iquil iyal tal ta vinajel ti Chꞌul Espíritue coꞌol xchiꞌuc paloma yilel. Tey icꞌot ta sba li Jesuse, jaꞌo ichiꞌine yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Li voꞌone mu toꞌox xcojtiquin, pero liyalbe onox ti Rioxe ti listac tal cacꞌ ichꞌvoꞌe: “Ti muchꞌu chcꞌot ta sba chavil li Chꞌul Espíritue, jaꞌ chayacꞌbe achiꞌinic li Chꞌul Espíritue”, xiyut onox. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Li voꞌone iquil xa. Lacalbeic xa ti jaꞌ Xchꞌamal ti Rioxe ―xiyutoticotic ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta yocꞌomal tey jchiꞌucticotic noxtoc ti Juane jchaꞌvaꞌalticotic ti yajchancꞌopoticotic toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ti Juane iyil ti tey iꞌechꞌ ti Jesuse. ―Qꞌuelavilic, jaꞌ ti coꞌol xchiꞌuc xchij Riox yaꞌel leꞌe yuꞌun jaꞌ chichꞌ milel ta scoj jmultic ―xiyutoticotic ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ti cꞌalal liyalboticotic chac taje, jaꞌ ba jchiꞌinticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ti Jesuse isqꞌuel sutel spat, iyil ti tey tijiloticotic echꞌele. ―¿Bu chabatic? ―xiyutoticotic. ―Jchanubtasvanej, ¿bu nacalot? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","―Batic, ba qꞌuelavilic ti bu nacalone ―xiyutoticotic ti Jesuse. Libatoticotic. Xmal xa cꞌacꞌal licꞌototicotic yoꞌ bu nacale. Tey jchiꞌucticotic iꞌoch acꞌubal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés sbi ti jchiꞌile ti coꞌol ijchiꞌinticotic echꞌel ti Jesuse yuꞌun coꞌol icaꞌiticotic ti cꞌusi iyal ti Juane. Ti Andrese oy sbanquil, Simon Pedro sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ora ba yalbe ti ijtaticotic xa li muchꞌu stꞌujoj Riox ti chispasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iyicꞌ tal yoꞌ bu ti Jesuse. Ti Jesuse isqꞌuelbe sat ti Simone. ―Li voꞌote, Simón, screm Jonás, Cefas chcacꞌ abiin ―xꞌutat. Cefas sbi ta ebreo cꞌope, Pedro sbi ta griego cꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta yocꞌomal isnop ti Jesuse ti chbat ta estado Galileae. Ti cꞌalal mu toꞌox chbate, ista jun jchiꞌilticotic ta israelal, Felipe sbi. ―Laꞌ chiꞌinon echꞌel ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti Felipee tey liquem tal ta jteclum Betsaida. Jaꞌ coꞌol slumal xchiꞌuc ti Andrese xchiꞌuc ti Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ti Felipee ora ba saꞌ ti Natanaele. ―Iquilticotic xa ti muchꞌu tsꞌibabil scꞌoplal ta svunic ti Moisese xchiꞌuc ti yan yajꞌalcꞌoptac Riox ti ta voꞌnee. Jesús sbi, screm José ta jteclum Nazaret ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","―Muc bu xcaꞌitic mi oy muchꞌu lec ti tey chlic tal ta Nazarete ―xi la ti Natanaele. ―Batic, ba jqꞌueltic avil ―xi la ti Felipee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ti Jesuse iyil ti nopol xa xtal ti Natanaele. ―Qꞌuelavilic, li jchiꞌiltic leꞌ xtale mu snaꞌ xloꞌlovan ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","―¿Cꞌuxi avojtiquinon? ―xi ti Natanaele. ―Laquil cꞌalal teyot ta yolon icꞌuxe ti cꞌalal mu toꞌox chba yicꞌot tal li Felipee ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","―Jchanubtasvanej, voꞌot Xchꞌamalot ti Rioxe. Voꞌot chapasoticotic ta mantal, voꞌoticotic li jꞌisraeloticotique ―xi ti Natanaele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","―Jaꞌ ti lacalbe ti laquil cꞌalal teyot ta yolon icꞌuxe, yechꞌo ti achꞌun o ti oy jyuꞌele. Lec ti achꞌune. Tsꞌacal to chavil ti scotol cꞌusi xuꞌ jpase ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","―Ta melel chacalbeic, voꞌon ti coꞌol crixchanootique, chavilic ti voꞌon chaquiqꞌuic echꞌel ta vinajele ti chba achiꞌinic ti Rioxe ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yoxibal xaꞌox cꞌacꞌal jcꞌotelticotic ta estado Galilea xchiꞌuc ti Jesuse, oy muchꞌu inupun ta jteclum Caná. Tey talem ta chꞌamunel ta sna jnupunel ti smeꞌ Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ti Jesuse xchiꞌuc li voꞌoticotique liꞌiqꞌueoticotic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti cꞌalal teyoticotique, ilaj ti yuchꞌbolique, jaꞌ li yaꞌlel uvae. ―Ilaj xa li yuchꞌbolique ―xꞌutat yuꞌun smeꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","―¿Cꞌu yuꞌun ti xꞌelan tal avalbone? Yuꞌun mu to tsta yora ta jtam li cabtele ―xut ti smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ti smeꞌe jaꞌ yech lic yalbe ti jcholveꞌliletique: ―Ti cꞌusi chayalbeic li cole, xachꞌunic me ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tey vuchajtic vaquib spꞌinal yaꞌalic naca ton. Tey tspulic loqꞌuel voꞌ ti tspoc o scꞌobic li jchiꞌiltac ta jurioale, yuꞌun stalelic ti jal tspoc scꞌobique yoꞌ lec xꞌileic o yuꞌun Riox ti yalojique. Ti jujun pꞌinal voꞌe xꞌoch o chaꞌpꞌej oxpꞌej qꞌuib voꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ti Jesuse iyalbe ti jcholveꞌliletique ti acꞌu snojesic ta voꞌ scotol li pꞌinal voꞌe. Isnojesic lec. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","―Pulic echꞌel jsetꞌuc, ba acꞌbeic spas proval li muchꞌu scuentainoj veꞌlile ―xꞌutatic yuꞌun ti Jesuse. Ispulic echꞌel, ba yacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ti muchꞌu scuentainoj ti veꞌlile, iyaꞌi ti más to leque, ora istac ta iqꞌuel ti jnupunel creme yuꞌun mu snaꞌ bu ital, yuꞌun voꞌ noꞌox ti ipas ta yaꞌlel uvae. Stuc snaꞌojic ti jcholveꞌliletique ti voꞌ noꞌox ispulic echꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ti muchꞌu scuentainoj ti veꞌlile lic yalbe ti creme: ―Li voꞌotique jtaleltic ti jaꞌ baꞌyi chcacꞌtic ta uchꞌel ti bu más lec li yaꞌlel uvae. Mi ep xaꞌox iyuchꞌique, jaꞌto chcacꞌtic ta uchꞌel ti bu siclamane. Li voꞌote jaꞌ anacꞌ li más leque, jaꞌto chavacꞌ ta uchꞌel ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jaꞌ yech ispas tey ta Caná ta estado Galilea ti Jesuse. Jaꞌ sliqueb iyacꞌ iluc slequilal syuꞌelal ti Jesuse. Voꞌoticotic ti yajchancꞌopoticotique ijchꞌunticotic ti jaꞌ Xchꞌamal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsꞌacal to libatoticotic ta jteclum Capernaum xchiꞌuc ti Jesuse, xchiꞌuc ti smeꞌe, xchiꞌuc ti yitsꞌintaque. Chib oxib noꞌox cꞌacꞌal tey lipajoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Poꞌot xaꞌox sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotic, voꞌoticotic li jꞌisraeloticotique. Jaꞌo ibat ta Jerusalén ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ti cꞌalal icꞌot ta tiꞌ mucꞌta templo ta Jerusalene, tey ista jchonvacaxetic, xchiꞌuc jchonchijetic, xchiꞌuc jchonpalomaetic. Tey chotajtic jeltaqꞌuinetic noxtoc yuꞌun jaꞌ tspasic o canal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ti Jesuse ixchuquilan chꞌojon coꞌol xchiꞌuc arsial. Jaꞌ isibtas o loqꞌuel scotol ti jchonchijetique xchiꞌuc ti jchonvacaxetique ti tey ta xchonolajic ta tiꞌ mucꞌta temploe. Ti jchoncꞌusiticuque sibtasbil iloqꞌuic echꞌel xchiꞌuc ti xchijique xchiꞌuc ti svacaxique. Ti Jesuse isbutqꞌuinbe smexaic ti jeltaqꞌuinetique, itanij ti staqꞌuinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","―Iqꞌuic loqꞌuel lapalomaique. Mu xapasic ta chꞌivit li stiꞌ sna Jtote ―xut ti jchonpalomaetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cꞌalal yech ispas ti Jesuse, voꞌoticotic ti yajchancꞌopoticotique iyul ta jolticotic ti yech onox tsꞌibabil ta scꞌop Rioxe: “Tot, jaꞌ chlic quichꞌ o crontainel ti sjunul coꞌon ta jcꞌan ti tey chacꞌoponat ta templo yoꞌ bu scꞌoplal onox chacꞌoponate”, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ti cajmeltsanejcꞌopticotique tal sjacꞌbeic ti Jesuse: ―Lavi xꞌelan chapase, ¿cꞌusi seña chavacꞌ quilticotic ti oy ayuꞌele? ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","―Lomeso avilic li templo liꞌi, ta oxib cꞌacꞌal ta jchaꞌvaꞌan ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","―Ta cuarenta y seis jabil ivaꞌi o li temploe. ¿Cꞌusi chachaꞌle ti ta oxib cꞌacꞌal chachaꞌvaꞌane? ―xi ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Li templo ti iyal ti Jesuse, jaꞌ isjoyꞌal sba stuc ti ta xchaꞌcuxi ta yoxibal cꞌacꞌal ti cꞌalal xichꞌ milele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yechꞌo un ti cꞌalal ichaꞌcuxie, iyul ta jolticotic ti jaꞌ onox yech iyalbe ti jmeltsanejcꞌopetique. Ijchꞌunticotic ti jaꞌ onox yech tsꞌibabil scꞌoplal ta scꞌop Rioxe. Ijchꞌunticotic noxtoc ti scꞌoplal noꞌox stuc ti iyalbe ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ti cꞌalal teyoticotic ta Jerusalén xchiꞌuc ti Jesuse ti cꞌu sjalil ti sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, ep jchiꞌiltac ta jurioal ixchꞌunic ti jaꞌ stꞌujoj Riox ti tspasvan ta mantal ti Jesuse ti cꞌalal iyilbeic slequilal syuꞌelale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ti Jesuse snaꞌoj ti mu scotoluc ti sjunul yoꞌonic ixchꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mu persauc oy muchꞌu xꞌalbon cꞌu xꞌelan yoꞌonic li crixchanoetique yuꞌun yiloj scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oy toꞌox jun jchiꞌilticotic ta jurioal, Nicodemo sbi. Jfariseo, ochem toꞌox ta meltsanejcꞌop cuꞌunticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ti Nicodemoe ay scꞌopon ta acꞌubaltic ti Jesuse. ―Jchanubtasvanej, jnaꞌojticotic ti stacojot tal ti Rioxe ti tal achanubtasoticotique. Ti manchuc xchiꞌinojot ti Rioxe, mu xuꞌ chavacꞌ iluc alequilal ayuꞌelal ti yechuque ―xi ti Nicodemoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","―Ta melel chacalbe, ti muchꞌu mu xchaꞌayan ta achꞌe, mu xuꞌ xꞌoch yoꞌ bu tspas mantal ti Rioxe ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","―¿Cꞌuxi ta xchaꞌayan ta achꞌ ti muchꞌu mol xae yuꞌun mu xa xuꞌ xchaꞌoch ta xchꞌut smeꞌ? ―xi ti Nicodemoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Itacꞌav ti Jesuse: ―Ta melel chacalbe, mi jaꞌ noꞌox chavichꞌic voꞌe, mi muc bu slecubtasoj avoꞌonic ti Chꞌul Espíritue, mu xuꞌ xaꞌochic yoꞌ bu tspas mantal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ti cꞌalal laꞌayanic liꞌ ta sba balamile, jmulaviloxuc chac cꞌu chaꞌal atot ameꞌic. Mi lachaꞌayanic ta syuꞌel ti Chꞌul Espíritue, chlecub avoꞌonic, mu xa xacꞌan xapasic li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mu me toj chꞌayeluc o avoꞌon ti xꞌelan lacalbee ti persa chachaꞌayan ta achꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Buyuc noꞌox batuc li iqꞌue chavaꞌi ti xjumumete pero mu xanaꞌ bu ilic tal, mu xanaꞌ bu chbat. Jaꞌ yech xꞌelan ta yoꞌon crixchanoetic ti Chꞌul Espíritue. Mu xanaꞌic ti tey ti Chꞌul Espíritue jaꞌto mi avilic ti lec xa yoꞌon jun crixchanoe ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","―Mu xcaꞌibe smelol taje ―xi ti Nicodemoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","―Li voꞌote yajchanubtasvanejot li jchiꞌiltactique pero mu xavaꞌibe smelol ti cꞌusi chacalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ta melel chacalbe, li voꞌone jaꞌ chcal ti cꞌusi jnaꞌe xchiꞌuc ti cꞌusi quiloje. Li voꞌoxuque mu xachꞌunic li cꞌusi chcale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ti mi mu xachꞌun cꞌusi tspas Riox liꞌ ta sba balamile chac cꞌu chaꞌal lacalbee, jaꞌ noꞌox yech mu xachꞌun mi chacalbe cꞌusi tspas Riox tey ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Mi jaꞌuc jun, muc muchꞌu ayem ta vinajel ti ayem sqꞌuel cꞌu xꞌelan teyoꞌe yoꞌ ti xayalbeic oe. Jtuc noꞌox xuꞌ chacalbeic yuꞌun tey liquemon tal, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jaꞌ chac cꞌu chaꞌal isjipan ta teꞌ slocꞌol quiletel chon ta xocol balamil ti Moisés ti ta más voꞌnee, jaꞌ noꞌox yech chisjipanic ta cruz uc, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Scotol ti muchꞌutic ta xchꞌunic ti jaꞌ chtoj o smulic ti chijipanat ta cruze, mu xꞌochic ta cꞌocꞌ, ta xcuxiic ta sbatel osil ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ti Rioxe batsꞌi scꞌanoj scotol crixchanoetic, yechꞌo ti istac tal ti junjun Xchꞌamale. Ti muchꞌutic ta xchꞌunic ti jaꞌ itojbon li smulique, mu xꞌochic ta cꞌocꞌ, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ti istac tal liꞌ ta sba balamil Xchꞌamal ti Rioxe, muꞌnuc tal yacꞌbe castico li crixchanoetique. Tal stojbe smulic yoꞌ ti xuꞌ xcuxiic o ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ti muchꞌutic ta xchꞌunic ti jaꞌ itojbon li smulique, mu xba yichꞌic castico. Yan ti muchꞌutic mu xchꞌunique jmoj scꞌoplal ti chba yichꞌic casticoe, jaꞌ ti mu xchꞌunic ti jaꞌ itojbon smulic yuꞌun ti junjun Xchꞌamal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jaꞌ chba yichꞌic o castico ti mu xchꞌunic ti iꞌay liꞌ ta sba balamil ti Xchꞌamal Rioxe, xchiꞌuc ti más lec chaꞌiic spasel li cꞌusitic chopole. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Scotol ti muchꞌutic jaꞌ tspasic li cꞌusitic chopole, chopol chaꞌiic cꞌusitic yaloj ti Xchꞌamal Rioxe. Mu scꞌan xichꞌic ta mucꞌ yuꞌun jaꞌ mu scꞌanic ti xvinaj li smulique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yan ti muchꞌutic jaꞌ tspasic ti cꞌusitic tscꞌan ti Rioxe, chichꞌbeic ta mucꞌ ti Xchꞌamale. Chvinaj ti yichꞌojic ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsꞌacal to locꞌ xanavconticotic ta estado Judea xchiꞌuc ti Jesuse, voꞌoticotic ti yajchancꞌopoticotique. Tey lipajoticotic jayib cꞌacꞌal. Iyichꞌic voꞌ ti yan crixchanoetic tey jchiꞌucticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jaꞌ noꞌox yech ti Juane tey chacꞌ ichꞌvoꞌ ta jteclum Enón yuꞌun oy tey lec ucꞌum. Li Enone nopol xil sba xchiꞌuc li jteclum Salime. Ti muchꞌutic jaꞌ ba staic ti Juane iꞌacꞌbatic yichꞌic voꞌ uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mu toꞌox ch-och ta chuquel ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oy jayvoꞌ yajchancꞌoptac ti Juane lic yalbe sbaic xchiꞌuc ti muchꞌutic tey jchiꞌucticotique, jaꞌ chopol iyaꞌiic ti oy xa chaꞌchop jꞌacꞌ-ichꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba yalbeic ti Juane: ―Jchanubtasvanej, ti muchꞌu avacꞌbe yichꞌ voꞌ ta jech ucꞌum Jordane ti avalbe scꞌoplale, ta xa me xacꞌ ichꞌvoꞌ uc. Scotol crixchanoetic jaꞌ xa chba staic ―xutic la cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Itacꞌav la ti Juane: ―Jaꞌ smantal stuc Riox ti cꞌusitic chacꞌ jpastic jujune. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Li voꞌoxuque avaꞌiic ti icalbe onox li jchiꞌiltactique ti mu voꞌonicon stꞌujojon Riox ta jpas mantale. Li voꞌone jaꞌ noꞌox listac tal ti Rioxe ti baꞌyi tal cal aꞌyuc ti chtal xa ti muchꞌu chispasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Anaꞌojic ti cꞌalal chicꞌ yajnil li vinique, li tsebe maꞌuc chicꞌ sba xchiꞌuc li yajacꞌoltac li slecome; jaꞌ onox chicꞌ li slecome. Li jacꞌoletique tsqꞌuelic noꞌox ti chnupunique. Cꞌalal chaꞌiic ti scꞌanoj sbaique, xmuyubajic xa. Jaꞌ noꞌox yechon uc, ximuyubaj xa ti jaꞌ chba staic Jesús li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Li Jesuse persa chvinaj scꞌoplal; li voꞌone ta xchꞌay jcꞌoplal ―xꞌutatic la yuꞌun ti Juan jꞌacꞌ-ichꞌvoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ti Muchꞌu talem ta vinajele snaꞌbe smelol scotol. Ti muchꞌutic liꞌic onox ta sba balamile, jaꞌ noꞌox snaꞌbeic smelol li cꞌusitic oy liꞌ ta sba balamile. Jaꞌ noꞌox chalic li cꞌusitic scuenta sba balamile. Yan ti Jesuse ti talem ta vinajele, snaꞌbe smelol scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jaꞌ chal ti cꞌusitic yiloje xchiꞌuc ti cꞌusitic yaꞌyoje. Pero jayvoꞌic noꞌox ti muchꞌutic ta xchꞌunic ti cꞌusi yaloje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ti muchꞌutic ta xchꞌunique jaꞌ chvinaj o ti xchꞌunojic ti istac xa tal Xchꞌamal ti Rioxe chac cꞌu chaꞌal yaloj onoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ti itaque tal yuꞌun Riox ti Jesuse, jaꞌ iyal ti cꞌusi yaloj ti Rioxe yuꞌun jꞌechꞌel iꞌacꞌbat xchiꞌin ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ti Rioxe scꞌanoj ti Xchꞌamale. Jaꞌ yacꞌojbe scuentain scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ti muchꞌutic ta xchꞌunic ti jaꞌ Xchꞌamal ti Rioxe, ta xcuxiic ta sbatel osil. Yan ti muchꞌutic mu xchꞌunique, mu xcuxiic ta sbatel osil. Ch-acꞌbatic tsots castico yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ti Jesuse iyaꞌi ti yech iꞌalbatic ti jfariseoetique: ―Más xa ep ti muchꞌutic iꞌacꞌbat yichꞌic voꞌ yuꞌun li Jesuse ti ta xchiꞌinique. Jaꞌ jayvoꞌ xa noꞌox ti muchꞌutic chba xchiꞌinic li Juane ―xꞌutatic la ti jfariseoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero ti Jesuse muc bu iyacꞌ ichꞌvoꞌ. Voꞌoticotic icacꞌticotic ti yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Cꞌalal iyaꞌi ti Jesuse ti iyaꞌiic xa ti jfariseoetique, ilocꞌ echꞌel ta Judea, ichaꞌsut echꞌel noxtoc ta estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ti cꞌalal ibat ta Galileae, isnop ti persa tey ch-echꞌ ta estado Samariae, yechꞌo un tey iꞌechꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Icꞌot ta jun jteclum, Sicar sbi, tey ta estado Samaria. Nopol xil sba xchiꞌuc srasyon osil ti José ti ta más voꞌnee ti iꞌacꞌbat comel yuꞌun ti ánima stote, jaꞌ ti Jacove. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Oy tey jun pozo, jaꞌ yacꞌoj ta joqꞌuel ti Jacove. Ti Jesuse tey ichoti ta tiꞌ pozo yuꞌun ilub ta xanbal. Poꞌot xaꞌox ol cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tey la icꞌot spul yaꞌal jun jsamariail ants. ―Acꞌbon jsetꞌuc avaꞌal yuꞌun ta xcuchꞌ ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Li voꞌoticotique batemoticotic xaꞌox ta yutil jteclum yuꞌun ba jmanticotic tal jveꞌelticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Itacꞌav la ti jsamariail antse: ―Li voꞌote jurioot. Li voꞌone jsamariaon. ¿Cꞌu yuꞌun ti chacꞌanbon voꞌ avuchꞌe? ―xi la. Ti xꞌelan iyal ti antse, yuꞌun muc bu lec xil sbaic xchiꞌuc jsamariaetic li jchiꞌiltac ta jurioale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ti Jesuse iyalbe la ti antse: ―Ti anaꞌuc onox ti cꞌusi tscꞌan chayacꞌbe ti Rioxe, ti avojtiquinicon muchꞌuon ti cꞌalal lajcꞌanbe avaꞌal chcuchꞌe, voꞌot baꞌyi acꞌanbon ti yechuque. Ti acꞌanbecone, lacacꞌbe li voꞌ ti chacuxi o ta sbatel osil ti yechuque ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","―Totic, mu cꞌu xapul o li voꞌe yuꞌun toj nat li pozoe. ¿Bu ma li voꞌ ti chavacꞌbon cuchꞌ ti chicuxi o ta sbatel osil chavale? ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ti jmucꞌtatotic Jacove jaꞌ liyacꞌboticotic li pozo liꞌi. Li voꞌe jaꞌ iyuchꞌ xchiꞌuc ti xchꞌamaltaque, xchiꞌuc ti svacaxe, xchiꞌuc ti xchije. ¿Mi voꞌot más tsots avabtel ti avaloje? ―xi la ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","―Ti muchꞌutic chuchꞌic li voꞌ liꞌi ta to xtaquij stiꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yan ti muchꞌutic chuchꞌic li voꞌ chcaqꞌue, mu xa bu ta xtaquij stiꞌic. Li voꞌ chcaqꞌue coꞌol xchiꞌuc ninabvoꞌ ti bu mu snaꞌ xꞌule, ti tey xchꞌolchꞌon o yaꞌel ta yoꞌonique, jaꞌ chcuxiic o ta sbatel osil ―xi la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","―Totic, acꞌbon cuchꞌ li voꞌ chavale yoꞌ mu xa xtaquij o jtiꞌe, yoꞌ mu xa xtal jpul o caꞌal liꞌ ta pozoe ―xi la ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","―Batan, ba icꞌo tal amalal ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","―Chꞌabal jmalal ―xi la. ―Yech chaval avaꞌuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Coꞌol xchiꞌuc chꞌabal amalal yuꞌun muc bu nupunemot xchiꞌuc li vinic avicꞌoj lavie. Oy xa achꞌacoj voꞌvoꞌ noxtoc ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","―Totic, voꞌot nan yajꞌalcꞌopot Riox cheꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ti voꞌne moletique iyichꞌic ta mucꞌ Riox liꞌ ta jolvitse. Voꞌoxuc li juriooxuque chavalic ti persa tey chba quichꞌtic ta mucꞌ Riox ta jteclum Jerusalene ―xi la ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","―Chꞌuno ti cꞌusi chacalbee. Ta sta yora ti mu xa persauc liꞌ chavichꞌic ta mucꞌ Jtotic Riox ta vitse, mi jaꞌuc ta Jerusalén. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Voꞌoxuc ti liꞌ nacaloxuc ta Samariae, mu xanaꞌic cꞌusi yaloj ti Rioxe ti avichꞌojic ta mucꞌ ti avalojique. Li voꞌoticotique jnaꞌojticotic ti yaloj onox ti Rioxe ti jun jchiꞌilticotic ta jurioal ti tstojbe smul scotol li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Poꞌot xa sta yora ti buyuc noꞌox tscꞌoponic Jtotic Riox ti muchꞌutic sjunul yoꞌon yichꞌojic ta muqꞌue. Ti Jtotic Rioxe jaꞌ tscꞌan ti muchꞌutic sjunul yoꞌonic chichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ti Rioxe chꞌabal sbecꞌtal, tey ta sjunlej balamil. Jaꞌ noꞌox yech ti muchꞌutic sjunul yoꞌonic chichꞌic ta muqꞌue, buyuc noꞌox xuꞌ tscꞌoponic, acꞌu mi ta snaic, acꞌu mi ta be, acꞌu mi ta yabtelic. Jaꞌ yech tscꞌan ti Rioxe ―xut la ants ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","―Caꞌyoj onox ti chtal ti muchꞌu stꞌujoj Riox chispasotic ta mantale. Ti cꞌalal xtale, jamal chiyalbotic scotol ―xi la ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","―Voꞌon ti liꞌ chiloꞌilajotique ―xut la ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti cꞌalal yolel chloꞌilajique, jaꞌo licꞌototicotic voꞌoticotic ti yajchancꞌopoticotique. Xchꞌayet xa coꞌonticotic ti iquilticotic chloꞌilaj xchiꞌuc jun ants ti Jesuse. Pero mi jun muc bu ijacꞌbeticotic cꞌusi ti sloꞌilique, cꞌusi tsjacꞌbe ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ti antse tey iscomtsan ta pozo ti sqꞌuibe, isut echꞌel ta yutil jteclum. Cꞌot la yalbe ti crixchanoetique: ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ba jqꞌueltic jun vinic tey ta pozo, liyalbe scotol ti cꞌusitic jpasoje. Jaꞌ xa nan ti muchꞌu stꞌujoj Riox ti scꞌoplal chtal spasotic ta mantale ―xi la cꞌotel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ti crixchanoetic ta jteclume tal sqꞌuelic ta ora ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cꞌalal mu toꞌox xulique ―Jchanubtasvanej, veꞌan ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","―Oy jveꞌel, pero mu xanaꞌic cꞌusi ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","―¿Miꞌn van oy muchꞌu ay acꞌbonuc sveꞌel? ―xcut jbaticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Lic yalboticotic ti Jesuse: ―Ti ta jpas cꞌusi tscꞌan ti Rioxe, jaꞌ jveꞌel yaꞌel yuꞌun jaꞌ listac tal. Persa ta jpas li cꞌusitic yalojbon ta jpase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Cꞌalal to chanib u chichꞌ loqꞌuel li trigoe”, xachiic. Aꞌyic me li cꞌusi chacalbeique. Quelavilic li crixchanoetic leꞌ xtalique, coꞌolic xchiꞌuc trigo ti taquin xae, ti chichꞌ xa loqꞌuele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Li jvajtrigoetique chtojatic. Li muchꞌutic tsloqꞌue chtojatic uc. Jaꞌ noꞌox yech ti muchꞌutic baꞌyi chalbeic scꞌop Riox li crixchanoetique, acꞌu mi muc xchꞌunic, pero coꞌol jun yoꞌonic xchiꞌuc ti muchꞌutic tsꞌacal to iyalbeique ti jaꞌto ixchꞌun yuꞌunique, yuꞌun ti jayvoꞌ ta xchꞌunique ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jaꞌ chac cꞌu chaꞌal chcaltique: “Yan o muchꞌu tsvaj, yan o muchꞌu tslocꞌ”, xichiotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Li antse voꞌon icalbe. Li crixchanoetique jaꞌ xa iꞌalbatic yuꞌun li antse. Voꞌoxuc xa chcom ta abaic xchanubtasel yoꞌ jꞌechꞌel xchꞌunic o ti voꞌon yajvalicone ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ep jsamariaetic tey ta Sicare ixchꞌunic ti jaꞌ tꞌujbil yuꞌun Riox tspasvan ta mantal ti Jesuse ti cꞌalal iyal ti antse ti iꞌalbat scotol ti cꞌusitic spasoje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yechꞌo un ti crixchanoetique tal scꞌoponic ti Jesuse. ―Abulajan, pajan to ―xutic. Tey lipajoticotic chib cꞌacꞌal xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ti cꞌalal iyaꞌiic ti cꞌu xꞌelan ichanubtasvan ti Jesuse, más to ep ixchꞌunic ti jaꞌ tꞌujbil yuꞌun Riox tspasvan ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","―Maꞌuc noꞌox ijchꞌunticotic o ti cꞌu yepal avalboticotique. Yuꞌun icaꞌi jtucticotic ti cꞌu xꞌelan ta xchanubtasvane. Jaꞌ ijchꞌunticotic o ti jaꞌ xa li muchꞌu tꞌujbil yuꞌun Riox tstoj jmultic jcotoltic ta sjunlej balamile ―xutic ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cꞌalal ilaj ti chib cꞌacꞌale, ilocꞌ echꞌel ta estado Samaria ti Jesuse, tey ibat ta estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ti ichaꞌsut echꞌel ta Galilea ti Jesuse, yuꞌun jaꞌ muc bu chcrontainat teyoꞌe yuꞌun mu xchꞌunbat ti cꞌusi chale. Jaꞌ chac cꞌu chaꞌal iyale: “Ti muchꞌutic chalic aꞌyuc li scꞌop Rioxe, mi chbatic ta yan o jteclume, ch-ichꞌbatic ta mucꞌ. Yan ta steclumal stuquique, mu xꞌichꞌbatic ta mucꞌ”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ti cꞌalal icꞌot ta Galilea ti Jesuse, xmuyubajic xa tajmec ti jchiꞌiltac ta jurioal teyoꞌe, jaꞌ ti iyilbeic slequilal syuꞌelal ti cꞌalal teyic ta qꞌuin ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ti Jesuse tey icꞌot noxtoc ta jteclum Caná tey noꞌox ta Galilea yoꞌ bu ti iscꞌatajes ta yaꞌlel uva ti voꞌe. Tey jun jchiꞌilticotic ta jurioal itiqꞌue ta meltsanejcꞌop ta jteclum Capernaum yuꞌun ti coviernoe. Ip screm. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ti jmeltsanejcꞌope iyaꞌi ti tey xa icꞌot ta Galilea ti Jesuse. Tal scꞌopon: ―¿Mi mu xaꞌabulaj xba avetꞌesbon xchamel li jcreme yuꞌun ta xcham xa? ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","―Li voꞌoxuque jaꞌ noꞌox chacꞌan chaqꞌuelic jlequilal jyuꞌelal, muꞌnuc chachꞌunic ti cꞌusi chacalbeique ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","―Totic, batic ta ora yoꞌto cuxul li jcreme ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","―Batan. Lec xa lacreme ―xꞌutat yuꞌun ti Jesuse. Ti vinique ixchꞌun ti cꞌusi iꞌalbat yuꞌun ti Jesuse, isut ta sna. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cꞌalal poꞌot xaꞌox la xcꞌot ta snae, tal la snupel ta be yuꞌun smozotac. ―Lec xa lacreme ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","―¿Cꞌusi ora ilecub? ―xi la ti vinique. ―Volje ta jun ora xmal itupꞌ scꞌacꞌal ―xi la ti smozotaque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ti vinique iyul la ta sjol ti yeche ora iꞌalbat yuꞌun ti Jesuse ti lec xa ti screme. Jaꞌ la iyichꞌ o ta mucꞌ ti Jesuse. Iyichꞌic la ta mucꞌ scotolic ti jayvoꞌ tey ta snae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ti cꞌalal isut tal ta estado Judea ti Jesuse, jaꞌto yul yacꞌ iluc xchaꞌechꞌelal slequilal syuꞌelal ta Galileae, jaꞌ ti iyetꞌesbe xchamel screm ti jmeltsanejcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsꞌacal to ichaꞌsut echꞌel ta Jerusalén ti Jesuse yuꞌun ista scꞌacꞌalil sqꞌuinic ti jchiꞌiltac ta jurioale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Joyol ta corralton li Jerusalene. Tey comem jun stiꞌil ti ch-och o echꞌel chijetic ti tey chichꞌ chiqꞌuel ta smoton Riox ta tiꞌ mucꞌta temploe. Ta tsꞌel tiꞌbee oy tey jun tanqueal voꞌ, Betesda sbi ta ebreo cꞌope. Oy tey voꞌpꞌej coycoyna ta tiꞌ voꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tey puchꞌajtic jchameletic. Oy maꞌsatetic, oy coxoetic, oy muchꞌutic alubem jun yoc scꞌob. Jaꞌ tsmalaic mi chyucꞌyonaj li voꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yuꞌun oy chyal tal jun anjel ta vinajel, chtal syuqꞌuilan baqꞌuintic li voꞌe. Cꞌalal chyucꞌyonaje, cꞌusuc noꞌox chamelal ip o ti muchꞌu baꞌyi ta sticꞌ sbae, jaꞌ ch-echꞌ o ti chamele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tey jun jchiꞌilticotic ta jurioal oy xa treinta y ocho jabil yipajel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ti Jesuse iyil ti tey puchꞌule. Snaꞌoj onox ti oy xa sjabilal ip ti vinique. ―¿Mi chacꞌan ch-echꞌ lachamele? ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","―Yuꞌun muc muchꞌu oy cuꞌun xisticꞌ ti cꞌalal chyucꞌyonaj li voꞌe. Cꞌalal chba xaꞌox jticꞌ jbae, oy xaꞌox muchꞌu baꞌyi isticꞌ sba ―xi ti muchꞌu ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","―Lican, balo echꞌel lapope, batan ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ora iꞌechꞌ ti xchamele, isbal echꞌel ti spope, ibat. Jaꞌo scꞌacꞌalil ta jcuxticotic voꞌoticotic li juriooticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ti cajmeltsanejcꞌopticotique iyalbeic ti muchꞌu iꞌechꞌ xchamele: ―Lavie ta jcuxtic. Mi chavichꞌ echꞌel lapope, yuꞌun mu xachꞌunbe smantal ti Rioxe ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","―Ti muchꞌu liyetꞌesbe jchamele, “balo echꞌel lapope, batan”, xiyut ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","―¿Muchꞌu ti “balo echꞌel lapope, batan”, ti xayute? ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ti vinic iꞌechꞌ xchamele mu snaꞌ muchꞌu iꞌetꞌesbon o, yuꞌun ora isqꞌuej sba loqꞌuel ti Jesuse, yechꞌo ti muc xa xile. Yuꞌun ep crixchanoetic tey stsoboj sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsꞌacal to ti vinique tey itae ta tiꞌ mucꞌta templo yuꞌun ti Jesuse. ―Qꞌuelavil, lecot xa. Mu xa me xasaꞌ yan amul yicꞌal me xavil más avocol ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ti vinique ba yalbe ti cajmeltsanejcꞌopticotique ti jaꞌ iꞌetꞌesbat xchamel yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ti iyetꞌesbe xchamel jchameletic ta scꞌacꞌalil ta jcuxticotic ti Jesuse, lic crontainvanicuc o ti cajmeltsanejcꞌopticotique. Yoꞌonicuc xa smilic o. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ti Jesuse iyalbe ti jmeltsanejcꞌopetique: ―Ti Jtote ch-abtej scotol cꞌacꞌal. Jaꞌ noꞌox yechon uc xuꞌ chiꞌabtej scotol cꞌacꞌal ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cꞌalal iyal chac taje, ti jmeltsanejcꞌopetique yoꞌonicuc xa smilic tajmec. Maꞌuc noꞌox ismulin ti mu xchabi li scꞌacꞌalil ta jcuxticotique; jaꞌ ismulin noxtoc ti iyal ti jaꞌ Stot ti Rioxe, yuꞌun iscoꞌoltas sba chac cꞌu chaꞌal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iꞌalbatic noxtoc yuꞌun ti Jesuse: ―Ta melel chacalbeic, voꞌon ti Xchꞌamalon ti Rioxe, mu cꞌusi ti jtuc noꞌox ta jpase. Ti cꞌusi tspas chquil ti Jtote, jaꞌ ta jpas. Scotol ti cꞌusi ta spas ti Jtote, jaꞌ noꞌox yech ta jpas uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Li voꞌone scꞌanojon ti Jtote. Ti cꞌusitic tspase chiyacꞌbe quil scotol. Lavie jutuc noꞌox chcacꞌ avilic, pero ep to cꞌusitic chacꞌ jpas ti Jtote. Ti cꞌalal jpase, más to ta xchꞌay o avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jaꞌ chac cꞌu chaꞌal ta xchaꞌcuxes ánimaetic ti Jtote, jaꞌ noꞌox yechon uc, ta jchaꞌcuxesic ti muchꞌutic ta jcꞌan ta jchaꞌcuxesique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ti Jtote maꞌuc chalbe ti bu chbatic ta sbatel osil li crixchanoetique. Voꞌon ti Xchꞌamalone liyalbe ti voꞌon chcalbeique yoꞌ xiyichꞌic o ta mucꞌ scotol crixchanoetic chac cꞌu chaꞌal ichꞌbil ta mucꞌ ti Jtote. Ti muchꞌutic mu xiyichꞌic ta muqꞌue, coꞌol xchiꞌuc jaꞌ mu xichꞌic ta mucꞌ yaꞌel ti Jtot uque yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ta melel chacalbeic, ti muchꞌutic chaꞌiic li cꞌusitic chcale, mi ta xchꞌunic ti jaꞌ listac tal ti Rioxe, ta xcuxiic ta sbatel osil. Mu xba yichꞌic castico yuꞌun chꞌabal xa scꞌoplal ti ch-ochic ta cꞌocꞌ ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ta melel chacalbeic, voꞌoxuc ti coꞌol xchiꞌuc chamemoxuc chaquilique, yora xa chavaꞌiic li cꞌusi chcale, voꞌon ti Xchꞌamalon ti Rioxe. Mi chachꞌunique, chacuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yuꞌun cuxulon ta sbatel osil yuꞌun ti Jtote chac cꞌu chaꞌal cuxul ta sbatel osil ti stuc uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Liyalbe noxtoc ti voꞌon chcalbe bu chbatic ta sbatel osil scotol li crixchanoetique, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mu me xchꞌay o avoꞌonic li cꞌusi lacalbeique. Yuꞌun ta sta yora ti chaꞌiic ti ta jcꞌoponic scotol ti ánimaetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jaꞌo ta xchaꞌcuxiic loqꞌuel ta smuquenalic. Ti muchꞌutic lec cꞌusitic ispasique ta xcuxiic ta sbatel osil. Yan ti muchꞌutic chopol cꞌusitic ispasique chba yichꞌic castico ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Li voꞌone mu cꞌusi ti jtuc noꞌox ta jpase. Maꞌuc ta jpas ti cꞌusi tscꞌan coꞌon jtuque. Jaꞌ ta jpas ti cꞌusi tscꞌan yoꞌon ti Jtote yuꞌun jaꞌ listac tal. Ti cꞌu xꞌelan chiyalbee, jaꞌ noꞌox yech ta xcalbe bu chbatic ta sbatel osil li crixchanoetique. Ti cꞌu xꞌelan iꞌechic liꞌ ta sba balamile jaꞌ yech chcalbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ti jtucuc noꞌox chcal jcꞌoplale, xuꞌ mu xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero oy cajrextico, jaꞌ ti Jtote, yechꞌo un tscꞌan chachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Li voꞌoxuque ataquic echꞌel mantal ti ay sjacꞌbel ti Juan jꞌacꞌ-ichꞌvoꞌe. Ti cꞌu xꞌelan iyal jcꞌoplal ti Juane, yech. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero maꞌuc crixchano li cajrexticoe. Jaꞌ noꞌox ta jyules ta ajolic yoꞌ xachꞌunic oe, yoꞌ xacuxiic o ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ti Juane coꞌol xchiꞌuc xojobal toj yaꞌel ti chquil o jbetique, yuꞌun jaꞌ layalbeic ti lital xae. Ti cꞌusi layalbeique jliquel noꞌox jun o avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jcꞌoplal noꞌox avaꞌibecon cꞌalal iyal ti Juane. Lavi ta jpas ti cꞌusitic yalojbon ti Jtote, jaꞌ chvinaj o ti stacojon tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jaꞌ cajrextico yuꞌun iyal xa li jcꞌoplale. Mi jpꞌel muc bu avaꞌyojic cꞌu xꞌelan chcꞌopoj ti Jtote, muc bu avilojic cꞌu xꞌelan. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Muc bu achꞌunojic li cꞌusi chale, jaꞌ ti mu xachꞌunic ti stacojon tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Ti avalojique, chacuxiic xa ta sbatel osil ti chaqꞌuelulanic noꞌox li scꞌop Rioxe. Pero maꞌuc yech chal li scꞌop Rioxe. Tey tsꞌibabil ti voꞌon chcacꞌ cuxlanic ta sbatel osile. Pero mu xacꞌan xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ti litale, mu voꞌonicon tal cacꞌ jba ta ichꞌel ta mucꞌ. Jaꞌ tal cacꞌ ta ichꞌel ta mucꞌ ti Jtote, jaꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Quiloj cꞌu xꞌelan avoꞌonic. Quiloj ti mu xacꞌanic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jaꞌ listac tal, pero mu to xacꞌan xavichꞌicon ta mucꞌ. Yan ti muchꞌu chtal ta smantal stuque, jaꞌ chavichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ti mu xachꞌunique, jaꞌ ti chacꞌanic ichꞌel ta mucꞌ yuꞌun lachiꞌilique; jaꞌ mu xacꞌanic ti lec chayilic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mu me xanopic ti voꞌon chcalbe amulic ti Jtote. Jaꞌ amulic ti avalojic ti ta sjunul avoꞌonic chachꞌunbeic li smantaltac Rioxe ti iyal ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ti achꞌunojicuc cꞌusi istsꞌiba ti Moisese, chachꞌunic ti voꞌon stacojon tal ti Rioxe yuꞌun jaꞌ jcꞌoplal ti istsꞌiba comele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lavi mu xachꞌunic ti cꞌusi stsꞌibaoj comel ti Moisese, jaꞌ noꞌox yech mu xachꞌunic ti cꞌusi chacalbeique ―xꞌutatic yuꞌun Jesús ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tsꞌacal to ibat ta jech nab ti Jesuse. Chib sbi li nabe: Nab ta Galilea, Nab ta Tibérias. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ep tajmec crixchanoetic napꞌalic echꞌel, jaꞌ ti iyilic ti iyetꞌesbe xchamelic ti muchꞌutic ipe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ti Jesuse liyicꞌoticotic muyel ta jpꞌej vits. Ichoti. Lichotioticotic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Poꞌot xaꞌox sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotic voꞌoticotic li juriooticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cꞌalal iyil ti Jesuse ti más xa ep ta stsob sba tal crixchanoetic yoꞌ bu chotole ―¿Bu chba jmantic tal pan ti chcacꞌbetic sveꞌ li crixchanoetic liꞌ lamalique? ―xꞌutat ti Felipee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ti Jesuse snaꞌoj onox cꞌuxi tspas. Ti isjaqꞌue, naca noꞌox tsqꞌuel cꞌuxi chtacꞌav ti Felipee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","―Ti oyuc doscientos denario jtaqꞌuintic jmantic o pane, acꞌu mi jusetꞌ noꞌox chcacꞌbetic, pero mu onox xloqꞌuic o ―xi ti Felipee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ti Jesuse iꞌalbat yuꞌun jun jchiꞌil ta yajchancꞌop, jaꞌ ti Andrese, ti yitsꞌin Simon Pedroe: ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Liꞌ jun creme yichꞌoj tal voꞌpꞌej pan pasbil ta cebada. Yichꞌoj tal chaꞌcot cꞌox choy noxtoc. Pero mu onox xloqꞌuic o yuꞌun batsꞌi ep tajmec li crixchanoetique ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","―Albeic li crixchanoetique acꞌu chotlicuc ―xiyutoticotic ti Jesuse. Yuꞌun stentejtic, tey ichotiic. Oy nan voꞌmiluc ti viniquetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ti Jesuse ixchꞌam ti pane. “Colaval”, xut ti Rioxe. Jaꞌo ixut ti pane, liyacꞌboticotic. Voꞌoticotic xa icacꞌbeticotic ti muchꞌutic tey chotajtique. Jaꞌ noꞌox yech icacꞌbeticotic noxtoc ti choye. Ti cꞌu yepal tscꞌan ti crixchanoetique, icacꞌbeticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ti cꞌalal inojique ―Tsobic scotol li sovra pane xchiꞌuc li sovra choye. Mu me xachꞌayic jsetꞌuc ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ijtsobticotic scotol. Inoj lajcheb moch ti sovra voꞌpꞌej pan ti pasbil ta cebadae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ti crixchanoetique iyilic ti ispꞌoles pan ti Jesuse. ―Jaꞌ xa li yajꞌalcꞌop Rioxe ti scꞌoplal onox chtale ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ti Jesuse snaꞌoj ti chtal ox yiqꞌuel ta persa yuꞌun ti jchiꞌiltac ta jurioale, ti chtiqꞌue ta pasmantale, yechꞌo un isqꞌuej sba loqꞌuel, stuc imuy ta vits. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ti cꞌalal poꞌot xaꞌox xꞌicꞌube, libatoticotic ta tiꞌnab li voꞌoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tey liꞌochoticotic ta canova, libatoticotic ta jech nab ta jteclum Capernaum. Iꞌicꞌub cuꞌunticotic ta be. Ti Jesuse muc bu jchiꞌucticotic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ital tsots icꞌ. Xyucꞌyon xa tajmec li nabe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lixanavoticotic xaꞌox jun reva xchiꞌuc oꞌlol ta nab, iquilticotic ti tey chanav tal ta yoc ta ba nab ti Jesuse. Inopoj tal ta jcanovaticotic. Lixiꞌoticotic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","―Mu me xaxiꞌic, voꞌon me ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ximuyubajoticotic xa iquicꞌticotic ochel ta canova. Ora licꞌototicotic ta jech nab yoꞌ bu chibatoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ti crixchanoetic tey icomic ta jech nabe, iyilic ti chꞌabal yan canovae, jcot noꞌox ti liꞌochoticotic o echꞌele. Iyilic ti muc xꞌoch ta canova ti Jesuse, ti jtucticotic noꞌox liꞌochoticotic voꞌoticotic ti yajchancꞌopoticotique. Ta yocꞌomal ital yan canovaetic. Iliquic tal ta jteclum Tibérias, tey nopol iꞌechꞌ yoꞌ bu isveꞌic pan ti crixchanoetique ti cꞌalal “colaval”, xut Riox ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ti crixchanoetique iyilic ti mu xa bu tey ti Jesuse, xchiꞌuc ti mu xa bu teyoticotic uque. Iꞌochic ta canova yuꞌun ba saꞌic ta Capernaum ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tey cꞌot staic ta jech nab ti Jesuse. ―Jchanubtasvanej, ¿cꞌusi ora layul liꞌtoe? ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","―Ta melel chacalbeic, ti tal asaꞌicone, muꞌnuc jaꞌ tal asaꞌicon o ti icacꞌ iluc li jlequilal jyuꞌelale. Jaꞌ tal asaꞌicon o ti lec lanojic ta pan cuꞌune. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mu me jaꞌuc noꞌox ta avoꞌonic ta saꞌel aveꞌelic ti snaꞌ xlaje. Jaꞌ tscꞌan chasaꞌic li veꞌlil mu snaꞌ xlaje ti chacuxiic o ta sbatel osile. Li veꞌlil chacalbeique, voꞌon chacacꞌbeic voꞌon ti coꞌol crixchanootique, yuꞌun jaꞌ yech yalojbon ti Jtotic Riox ta vinajele ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","―¿Cꞌusi tscꞌan Riox ti ta jpasticotique? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","―Ti cꞌusi tscꞌan Riox chapasique, jaꞌ tscꞌan chachꞌunic ti jaꞌ listac tale ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","―¿Cꞌusi seña chavacꞌ quilticotic mi yech ti stacojot tal ti Rioxe yoꞌ jchꞌunticotic o ti cꞌusi chavale? ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ti voꞌne moletique isveꞌic pan ta xocol balamil ti ital ta vinajele. Jaꞌ yech tsꞌibabil ta scꞌop Riox: “Ti Moisese iyacꞌ ta veꞌel pan ti ital ta vinajele”, xi. Acꞌboticotic uc ―xiic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","―Ta melel chacalbeic, ti pan isveꞌic ti voꞌne moletique, maꞌuc Moisés iyacꞌ. Riox iyacꞌ. Ti pan isveꞌique, jaꞌ noꞌox icuxiic o liꞌ ta sba balamile. Li pan ti chayacꞌbeic ti Jtote, chacuxiic o ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yuꞌun tey liquem tal ta vinajel, yechꞌo ti chacuxiic o ta sbatel osil voꞌoxuc ti liꞌoxuc ta sba balamile ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","―Cajval, acꞌboticotic scotol cꞌacꞌal li pan chavale ―xiic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Itacꞌav ti Jesuse: ―Voꞌon li panon yaꞌele yuꞌun voꞌon xuꞌ chcacꞌ cuxlanic ta sbatel osil. Ti muchꞌutic ta xchꞌunic ti voꞌon chcacꞌ cuxlicuc ta sbatel osile, jun xa yoꞌonic, mu xa cꞌusi xal yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Li voꞌoxuque acꞌu mi avilicon, pero mu xachꞌunic ti voꞌon chcacꞌ acuxlejalique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Scotol ti muchꞌutic chiyacꞌbe ti Jtote chiyichꞌic ta mucꞌ. Ti muchꞌutic chiyichꞌic ta muqꞌue muc bu ta jpꞌaj junuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ti lital liꞌ ta sba balamile, maꞌuc tal jpas ti cꞌusi tscꞌan coꞌone. Jaꞌ tal jpas ti cꞌusi tscꞌan yoꞌon ti Jtote yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ti cꞌusi tscꞌan yoꞌon ti Jtote ti jaꞌ listac tale, jaꞌ ti mu xꞌochic ta cꞌocꞌ junuc ti muchꞌutic chiyichꞌic ta muqꞌue, ti ta jchaꞌcuxesic ti cꞌalal poꞌot xaꞌox xlaj li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jaꞌ tscꞌan ti chcuxiic ta sbatel osil ti muchꞌutic ta xchꞌunic ti voꞌon Xchꞌamalon ti Rioxe, ti voꞌon chcacꞌ cuxlicuc ta sbatel osile. Ta jchaꞌcuxesic ti cꞌalal poꞌot xaꞌox xlaj li balamile ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ti jchiꞌiltac ta jurioale xmixlajetic xa ti cꞌalal iyal ti Jesuse ti coꞌol xchiꞌuc pane ti talem ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","―¡Pero jaꞌ li Jesuse li screm Josee! Xcojtiquinbetic li stot smeꞌe. ¿Cꞌu yuꞌun chal ti talem ta vinajele? ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iyal ti Jesuse: ―Mu xa me xamixmixcꞌopojic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jaꞌ noꞌox xuꞌ chiyichꞌic ta mucꞌ ti muchꞌutic ch-iqꞌueic tal yuꞌun ti Jtote, jaꞌ ti muchꞌu listac tale. Ti muchꞌutic chiyichꞌic ta muqꞌue, ta jchaꞌcuxesic ti cꞌalal poꞌot xaꞌox xlaj li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ti yajꞌalcꞌoptac Riox ti ta voꞌnee stsꞌibaojic onox chac liꞌi: “Scotolic ta xyulesbat ta sjolic yuꞌun ti Rioxe ti muchꞌu li Jtojmulile”, xi onox tsꞌibabil. Yechꞌo un ti muchꞌutic ta xchꞌunic ti cꞌalal chyulesbat ta sjolic yuꞌun ti Jtote, chiyichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Mi jun muc muchꞌu yiloj ti Rioxe. Jtuc noꞌox quiloj yuꞌun tey liquemon tal yoꞌ bu ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ta melel chacalbeic, ti muchꞌutic ta xchꞌunic ti jaꞌ listac tal ti Rioxe, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Voꞌon li panon yaꞌele yuꞌun voꞌon xuꞌ chcacꞌ cuxlanic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ti cꞌalal isveꞌic pan ta xocol balamil ti voꞌne moletique ti iꞌacꞌbatic yuꞌun ti Rioxe, muc xcuxiic o ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Li pan talem ta vinajel chcale ta xcuxiic o ta sbatel osil ti muchꞌutic ta sveꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Voꞌon li panon yaꞌele yuꞌun ta vinajel liquemon tal. Cuxulon ta sbatel osil. Scotol ti muchꞌutic tsveꞌic li pan chcale, ta xcuxiic ta sbatel osil. Li pan chcaqꞌue, jaꞌ li jbecꞌtale. Ta xcacꞌ yoꞌ xuꞌ xacuxiic o ta sbatel osil acotolique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","―¿Cꞌuxi chacꞌ jlajesbetic li sbecꞌtale? ―xut sbaic ti jchiꞌiltac ta jurioale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iꞌalbatic yuꞌun ti Jesuse: ―Ta melel chacalbeic, mi mu xalajesic li jbecꞌtale, voꞌon ti coꞌol crixchanootique, mi mu xavuchꞌic li jchꞌichꞌele, mu onox xacuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ti muchꞌutic ta slajesic li jbecꞌtale, ti chuchꞌic li jchꞌichꞌele, ta xcuxiic ta sbatel osil. Ta jchaꞌcuxesic ti cꞌalal poꞌot xaꞌox xlaj li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Li jbecꞌtale coꞌol xchiꞌuc lequil veꞌlil yaꞌel, li jchꞌichꞌele coꞌol xchiꞌuc lequil voꞌ yaꞌel, yuꞌun jaꞌ chacuxiic o ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ti muchꞌutic ta slajesic li jbecꞌtale, ti chuchꞌic li jchꞌichꞌele, yuꞌun yichꞌojicon ta mucꞌ. Liꞌ jchiꞌuquique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ti Jtot ti listac tale cuxul ta sbatel osil. Jaꞌ noꞌox yech cuxulon yuꞌun ta sbatel osil uc. Jaꞌ noꞌox yech ti muchꞌutic chislajesique, voꞌon chcacꞌ cuxlicuc ta sbatel osil uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Li pan talem ta vinajel chcale, mu xcoꞌolaj xchiꞌuc ti pan ti isveꞌic ti voꞌne moletique. Ti cꞌalal isveꞌique, muc bu icuxiic o ta sbatel osil. Yan ti muchꞌutic ta sveꞌic li pan chcale ta xcuxiic o ta sbatel osil ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jaꞌ yech iyal ti Jesuse ti cꞌalal ichanubtasvan ta templo yoꞌ bu chaꞌiic smantal Riox ti jchiꞌiltac ta Capernaume. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ep jchiꞌiltac ta jurioal ixchiꞌinic jujun cꞌacꞌal ti Jesuse. Ti cꞌalal iyaꞌiic chac taje ―Taje tsots ta chꞌunel. Muc muchꞌu xchꞌun yuꞌun ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ti Jesuse snaꞌoj ti jaꞌ yech iyalique. ―¿Mi jaꞌ chavicta o abaic ti xꞌelan lacalbeique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cꞌusi chavalic mi avilic limuy echꞌel yoꞌ bu liquemon tal voꞌon ti coꞌol crixchanootique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Chꞌunic li cꞌusi chacalbeique yuꞌun jaꞌ chacuxiic o ta sbatel osil. Jaꞌ noꞌox yech smelol ti cꞌusi lacalbeique. Muc bu lacalbeic ti oy cꞌusi chapasic yoꞌ xacuxiic o ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mu onox acotolicuc chachꞌunic ―xꞌutatic yuꞌun ti Jesuse. Ti cꞌalal istambe yalel cꞌusi talem spas ti Jesuse, snaꞌoj xa onox ti muchꞌutic mu xchꞌunic ti jaꞌ Xchꞌamal ti Rioxe. Snaꞌoj noxtoc ti muchꞌu ta xꞌacꞌon o entrucale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iyal noxtoc ti Jesuse: ―Lacalbeic onox ti jaꞌ noꞌox xuꞌ chiyichꞌic ta mucꞌ ti muchꞌutic ch-albatic yuꞌun ti Jtotic Riox ta vinajele ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yechꞌo ti ep jchiꞌiltac iyictaic xchiꞌinel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","―¿Mi chacꞌan chavictaicon uc? ―xiyutoticotic jlajchavaꞌalticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Itacꞌav ti Simon Pedroe: ―Cajval, ¿muchꞌu xa chba jacꞌbeticotic ti cꞌuxi chicuxioticotic ta sbatel osile ti atuc noꞌox anaꞌoje? ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Li voꞌoticotique jchꞌunojticotic ti voꞌot Cristoote, ti stꞌujojot Riox chapasoticotic ta mantale. Voꞌot Xchꞌamalot Riox ta vinajel ti cuxul ta sbatel osile ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","―Voꞌon lajtꞌuj alajchavaꞌalic, pero oy junoxuc ti chachꞌunbeic smantal ti pucuje ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jaꞌ iyalbe scꞌoplal ti Judase, ti screm Simon Iscariotee, yuꞌun jaꞌ iꞌacꞌon o entrucal ta tsꞌacal. Ti Judase jaꞌ toꞌox lajchavoꞌoticotic o ta yajchancꞌop ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ti Jesuse mu scꞌan xbat ta estado Judea yuꞌun ti cajmeltsanejcꞌopticotique yoꞌonicuc xa smilic. Yechꞌo un tey noꞌox locꞌ xanavuc ta sjunlej estado Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Poꞌot xaꞌox sqꞌuinic ta Jerusalén ti jchiꞌiltac ta jurioale. Jaꞌ li qꞌuin tspasic sucbil yanal teꞌ chvayic oe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ti Jesuse iꞌalbat yuꞌun ti yitsꞌintaque: ―Mu me xacom, batic ta Judea. Ti cꞌalal chilic chavacꞌ iluc alequilal ayuꞌelal ta qꞌuine, más to chayichꞌic o ta mucꞌ ti muchꞌutic xchiꞌinojot xae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ti muchꞌu tscꞌan chvinaj scꞌoplale mu mucluc tspas ti cꞌusi tspase. Mi jaꞌ avabtel ti xꞌelan chapase, acꞌbo yil scotol crixchanoetic ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ti itsꞌinaletique muc xchꞌunic uc ti jaꞌ tꞌujbil yuꞌun Riox tspasvan ta mantal ti sbanquilique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Itacꞌav ti Jesuse: ―Scꞌan to yora ti chibat ta qꞌuine. Li voꞌoxuque cꞌusuc noꞌox ora xuꞌ chabatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mu chopluc chayilic li crixchanoetique. Yan li voꞌone chopol chiyilic yuꞌun ta xcalbeic ti chopol li cꞌusitic tspasique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Li voꞌoxuque batanic. Li voꞌone mu to bu chibat yuꞌun scꞌan to sta yora ti chibate ―xut ti yitsꞌintaque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ti cꞌalal laj yalbe chac taje, tey ipaj ta Galilea. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ti cꞌalal batemic xaꞌox ta qꞌuin ti yitsꞌintaque, jaꞌto ibat ti Jesuse. Mucul ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ti cajmeltsanejcꞌopticotique tey tsaꞌic ta qꞌuin. ―¿Bu xanaꞌic ti Jesuse? ―xutic ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Scotol ti jꞌilqꞌuinetique naca jaꞌ sloꞌilic ti Jesuse. ―Toj lec yoꞌon ―xiic jlom. ―¡Leꞌe jloꞌlovanej! ―xiic jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mi jun muc muchꞌu jamal iyalbe scꞌoplal ti Jesuse yuꞌun xiꞌemic o ti cajmeltsanejcꞌopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ti cꞌalal ibat ta mucꞌta templo ti Jesuse, oxib xaꞌox cꞌacꞌal scꞌan xlaj ti qꞌuine. Tey cꞌot chanubtasvanuc ta tiꞌ templo. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ti jmeltsanejcꞌopetique xchꞌayet xa o yoꞌonic ti cꞌu xꞌelan ichanubtasvan ti Jesuse. ―¿Bu ixchan li jchiꞌiltic leꞌe ti muc bu jchanubtasojtique? ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iꞌalbatic yuꞌun ti Jesuse: ―Muc bu jyulesoj ta jol jtuc li cꞌusi chacalbeique. Jaꞌ yaloj ti Rioxe yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ti muchꞌu yoꞌonuc spas cꞌusi tscꞌan ti Rioxe, chyulesbat ta sjol mi jaꞌ scꞌop Riox ti chcale, o mi jyulesoj ta jol jtuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ti muchꞌu ta syules ta sjol stuc li cꞌusi chale, yuꞌun jaꞌ tscꞌan ichꞌel ta mucꞌ stuc. Li voꞌone jaꞌ chcacꞌ ta ichꞌel ta mucꞌ ti Rioxe yuꞌun jaꞌ listac tal. Muc bu ta jnop; yech chcal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Ti Moisese lastsꞌibabeic comel li smantaltac Rioxe. Mi jun muc bu achꞌunojic li mantaletique. Ti achꞌunojicuque cheꞌe, muc bu avoꞌonicuc amilicon ti yechuque ―xꞌutatic ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","―Taje oy pucuj ta avoꞌon. ¿Muchꞌu ti yoꞌonuc smilote? ―xi ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Itacꞌav ti Jesuse: ―Jun noꞌox jchamel ti iquetꞌesbe xchamel ta scꞌacꞌalil ta jcuxtique pero jaꞌ chopol avaꞌiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ti Moisese istsꞌiba onox ti chavaqꞌuic circuncisione, pero maꞌuc baꞌyi iꞌalbat. Jaꞌ baꞌyi iꞌalbatic ti moletic ti ta más voꞌnee. Li voꞌoxuque, acꞌu mi ta scꞌacꞌalil ta jcuxtic, chavacꞌbeic circuncisión li unen cremotique ti ilocꞌ xa vaxaquib cꞌacꞌal yayanelique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ti chavaqꞌuic circuncisión ta scꞌacꞌalil ta jcuxtique yuꞌun achꞌunojic cꞌusi yaloj ti Moisese, ¿cꞌu yuꞌun ti chopol chavilicon o ti iquetꞌesbe xchamel jun jchiꞌiltic ta scꞌacꞌalil ta jcuxtique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Chopol mi ora chaticꞌbeic smul jun vinique. Jaꞌ tscꞌan chanopic mi yech ti chopol cꞌusi ispase ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oy jayvoꞌ jchiꞌilticotic ti tey nacajtic ta Jerusalene jaꞌ yech lic yalic: ―¿Mi maꞌuc li vinic leꞌe ti tsaꞌic li cajmeltsanejcꞌoptique ti yoꞌonicuc smilique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Qꞌuelavil, liꞌto ta xchanubtasvan noxtoque pero mu cꞌusi xꞌalbat yuꞌun li jmeltsanejcꞌopetique. Yuꞌun nan ixchꞌunic xa ti jaꞌ ti muchꞌu stꞌujoj Riox ti scꞌoplal onox chtal spasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Leꞌe jnaꞌojtic bu liquem tal. Ti cꞌalal xtal ti muchꞌu tꞌujbil yuꞌun Riox ti chispasotic ta mantale, mu jnaꞌtic bu chlic tal ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ti Jesuse tsots icꞌopoj ti cꞌalal ichanubtasvan ta tiꞌ mucꞌta temploe. ―Ti avalojique, xavojtiquinicon. Anaꞌojic bu liquemon tal ti avalojique. Pero mu ta jmantaluc jtuc ti litale; jaꞌ listac tal ti Rioxe. Li voꞌoxuque muc bu avilojbeic cꞌu xꞌelan yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Li voꞌone quilojbe cꞌu xꞌelan yoꞌon yuꞌun tey liquemon tal yoꞌ bu ti Rioxe. Jaꞌ listac tal ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ti jmeltsanejcꞌopetique yoꞌonicuc stiqꞌuic ta chuquel ti Jesuse, pero muc muchꞌu istsac, jaꞌ ti mu toꞌox tsta yora chichꞌ tsaquele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ep ixchꞌunic ti jaꞌ xa ti muchꞌu tꞌujbil yuꞌun Riox ti scꞌoplal onox chtal spasoticotic ta mantale. ―Li jchiꞌiltic leꞌe chacꞌ iluc tajmec slequilal syuꞌelal chac cꞌu chaꞌal scꞌoplal onox ta spas ti muchꞌu chtal spasotic ta mantale. Jaꞌ xa leꞌe ―xiic ti muchꞌutic ixchꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ti jfariseoetique iyaꞌiic ti jaꞌ xa yech ta xmixmixꞌalic ti crixchanoetique ti jaꞌ ti muchꞌu tꞌujbil yuꞌun Riox ti scꞌoplal onox chtal spasoticotic ta mantale. Yechꞌo un ti totil paleetique xchiꞌuc ti jfariseoetique iyalbeic jayvoꞌ jchabiejtemplo ti acꞌu stsaquic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ti Jesuse iyalbe ti crixchanoetique: ―Mu xa bu jal chajchiꞌinic. Yuꞌun poꞌot xa xisut echꞌel, chba xa jta ti muchꞌu listac tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chasaꞌicon pero mu xataicon. Ti bu chibate mu xuꞌ chabatic ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","―¿Bu chbat ti yaloje ti mu xa jtatique? Yuꞌun nan jaꞌ chba sta ti jchiꞌiltactic ti batemic ta namal balamile. Yuꞌun nan jaꞌ chba xchanubtas li namal crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Cꞌusi smelol ti xꞌelan chale: “Chasaꞌicon pero mu xataicon. Ti bu chibate mu xuꞌ chabatic”, ti xie? ―xut sbaic ti cajmeltsanejcꞌopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta sbaqꞌuel qꞌuin isvaꞌan sba ta oꞌlol crixchanoetic ti Jesuse. Tsots icꞌopoj. ―Ti muchꞌutic tsaꞌ slequil yoꞌonic chac cꞌu chaꞌal tsaꞌ voꞌ yuchꞌic ti cꞌalal chtaquij xa stiꞌique, acꞌu yichꞌicon ta mucꞌ yuꞌun voꞌon ta jlecubtasbe li yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ti muchꞌutic ta xchꞌunic ti voꞌon ta jlecubtasbe li yoꞌonique, jaꞌ chcꞌot chac cꞌu chaꞌal tsꞌibabil ta scꞌop Rioxe: “Li slequil yoꞌonique coꞌol xchiꞌuc ninabvoꞌ ti tey xchꞌolchꞌon oe”, xi onox tsꞌibabil ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ti xꞌelan iyale, jaꞌ iyalbe scꞌoplal ti Chꞌul Espíritue ti scꞌoplal ch-acꞌbat xchiꞌinic ti muchꞌutic ta xchꞌunic ti jaꞌ ta xlecubtasbat yoꞌonic yuꞌun ti Jesuse. Yuꞌun mi jun mu toꞌox muchꞌu acꞌbil xchiꞌin ti Chꞌul Espíritue, jaꞌ ti mu toꞌox ta sut echꞌel ta vinajel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ti jchiꞌiltac ta jurioale, ti cꞌalal iyaꞌiic cꞌusi iyal ti Jesuse ―Melel ti jaꞌ xa ti yajꞌalcꞌop Rioxe ti scꞌoplal onox chtale ―xiic jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","―Leꞌe jaꞌ xa ti muchꞌu stꞌujoj Riox ti scꞌoplal onox chtal spasotic ta mantale ―xiic jlom. ―Mu ta Galileauc chlic tal ti muchꞌu scꞌoplal chtal spasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jaꞌ yech chal li scꞌop Rioxe ti jaꞌ smom ti David ti ta voꞌnee, ti tey ta xꞌayan ta jteclum Belene yoꞌ bu iꞌayan ti smucꞌtatote ―xiic jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tsotsic xa chalbe sbaic ti cꞌu xꞌelan scꞌoplal ti Jesuse yuꞌun mu coꞌoluc ti cꞌusi isnopique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ti jlome yoꞌonicuc stsaquic pero muc muchꞌu istsac. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ti jchabiejtemploe isutic yoꞌ bu ti totil paleetique yoꞌ bu ti jfariseoetique. Ti cꞌalal icꞌotique ―¿Cꞌu yuꞌun ti muc xatsaquic tale? ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","―Yuꞌun muc muchꞌu yech xcꞌopoj chac cꞌu chaꞌal xcꞌopoje ―xiic ti jchabiejtemploe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","―¿Mi achꞌunic xa loꞌloel yaꞌel uc? ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mi jun cajmeltsanejcꞌoptic muc bu xchꞌunojic ti jaꞌ xa ti muchꞌu scꞌoplal onox chtal spasotic ta mantale. Mi voꞌoticoticuc, muc bu jchꞌunojticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Li jchiꞌiltactic ti tey chaꞌiic cꞌusi chal li Jesuse, mu onox snaꞌic li mantaletique. Ichꞌayic xa o uc ―xiic ti jfariseoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tey ti Nicodemo uque, jaꞌ ti muchꞌu ay scꞌopon ta acꞌubaltic ti Jesuse, yuꞌun jfariseo uc. Ti Nicodemoe lic yal: ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Mu xuꞌ chcacꞌbetic castico jun jchiꞌiltic mi mu to bu caꞌyojtic ti cꞌusi chale, mi mu to jnaꞌtic ti cꞌusi smule. ¿Mi maꞌuc yech chal li mantaletic caꞌyojtique cheꞌe? ―xut ti xchiꞌiltac ta meltsanejcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","―¿Cꞌu chaꞌal? ¿Mi tey liquemot tal ta Galilea uc? Qꞌuelo lec cꞌusi chal li scꞌop Rioxe. Chavil ti mu junuc yajꞌalcꞌop Riox ilic tal ta Galileae ―xꞌutat ti Nicodemoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Isut ta snaic jujuntal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ti Jesuse ibat ta vits Olivotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sob ta yocꞌomal isut tal, tey icꞌot noxtoc ta tiꞌ mucꞌta templo ta Jerusalén. Cuncꞌun istsob sba ep jchiꞌilticotic yoꞌ bu ti Jesuse. Ti Jesuse ichoti, lic chanubtasvanuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tey icꞌotic jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe xchiꞌuc jayvoꞌ jfariseoetic. Tey yicꞌojbeic cꞌotel jun ants ti Jesuse. Yuꞌun la xchiꞌuc yajmul itae ti antse. Tey isvaꞌanic ta oꞌlol crixchanoetic yoꞌ bu ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","―Jchanubtasvanej, li ants liꞌi xchiꞌuc yajmul itae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti Moisese yaloj mantal ti chichꞌ milel ta ton ti muchꞌu jaꞌ yech tspase. Li voꞌote, ¿cꞌusi chaval? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ti xꞌelan iyalbeic ti Jesuse, naca noꞌox chaꞌiic cꞌu xꞌelan chtacꞌav yoꞌ stabeic o smul ti yalojique. Ti Jesuse isnijan sba, istsꞌiba balamil ta sniꞌ scꞌob. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ti mu xicta sbaic ta sjaqꞌuele, ichoti lec ti Jesuse. ―Mi oy muchꞌu junucal ti chꞌabal smul chaꞌie, jaꞌ baꞌyi acꞌu yacꞌbe ton li antse ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Isnijan sba noxtoc, ixchaꞌtsꞌiba balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cꞌalal iyaꞌiic ti xꞌelan iyal ti Jesuse, ti jmeltsanejcꞌopetique iyul ta sjolic ti oy smulique, jujuntal iloqꞌuic echꞌel. Jaꞌ baꞌyi iloqꞌuic echꞌel ti más moletique. Stuc xa tey icom ta oꞌlol crixchanoetic ti Jesuse xchiꞌuc ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ti Jesuse ichoti lec noxtoc, iyil ti mu xa bu tey ti muchꞌutic yicꞌojic cꞌotel ti antse, ti stuc xa teye. ―Laj xa batuc ti muchꞌutic ay yalbon lamule. Muc muchꞌu layacꞌbe ton ―xut ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","―Chꞌabalaꞌa, totic ―xi. ―Jaꞌ noꞌox yechon uc, muc bu chacacꞌbe castico. Batan, jaꞌ noꞌox ti mu xa me xasaꞌ yan amule ―xut echꞌel ti antse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ti Jesuse ichanubtasvan noxtoc, jaꞌ yech lic yal: ―Li voꞌone coꞌol xchiꞌuc aluzicon yaꞌel, voꞌoxuc ti teyoxuc ta icꞌ osil yaꞌel ta scoj li mulile. Ti muchꞌutic chiyichꞌic ta muqꞌue mu xa bu ta saꞌ smulic. Jaꞌ xa tspasic li cꞌusitic leque yuꞌun voꞌon ta jcoltaic. Jaꞌ chcuxiic ta sbatel osil ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","―Li voꞌote atuc noꞌox chaval acꞌoplal. Chꞌabal avajrextico yechꞌo ti mu xuꞌ jchꞌunticotic li cꞌusi chavale ―xi ti jfariseoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Itacꞌav ti Jesuse: ―Acꞌu mi jtuc noꞌox chcal jcꞌoplal pero xuꞌ xachꞌunic yuꞌun jnaꞌoj ti bu liquemon tale, jnaꞌoj noxtoc ti bu chibate. Li voꞌoxuque mu xanaꞌic bu liquemon tal. Mu xanaꞌic noxtoc ti bu chibate. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Chanopic ti yech noꞌox crixchanoone yechꞌo ti chasaꞌbecon jmule. Li voꞌone muc muchꞌu ta jsaꞌbe smul. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mi oy muchꞌu chcalbe ti oy smule, yuꞌun onox oy smul. Mu jtucuc noꞌox chcal ti oy smule; coꞌol chcalticotic xchiꞌuc ti Jtote, yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Li mantaletic avichꞌojique chal ti jaꞌto chachꞌunic mi oy chaꞌvoꞌ rexticoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Li voꞌone chcal jcꞌoplal. Jaꞌ chal jcꞌoplal ti Jtot uque, yuꞌun jaꞌ listac tal ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","―¿Bu ti atot chavale cheꞌe? ―xi ti jfariseoetique. ―Yuꞌun mu xachꞌunic ti tey liquemon tal ta vinajele, yechꞌo ti mu xachꞌunic ti jaꞌ Jtot ti Rioxe. Ti achꞌunojicuc ti tey liquemon tal ta vinajele, anaꞌojic ti jaꞌ Jtot ti Rioxe ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jaꞌ yech iyal ti Jesuse ti cꞌalal ichanubtasvan yoꞌ bu ti snail limoxnae ti tsacal xchiꞌuc ti mucꞌta temploe. Muc muchꞌu istsac ti Jesuse, jaꞌ ti mu toꞌox bu tsta yora chichꞌ tsaquele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ti Jesuse jaꞌ yech lic yalbe noxtoc: ―Li voꞌone chibat. Chasaꞌicon pero mu xataicon. Li voꞌoxuque tey acuchoj amul chachamic. Ti bu chibate mu xuꞌ chabatic ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","―Yuꞌun nan tsmil sba ti xꞌelan chale: “Ti bu chibate mu xuꞌ chabatic”, ti xie ―xut sbaic ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","―Li voꞌoxuque liꞌoxuc onox ta sba balamile; yan li voꞌone liquemon tal ta vinajel, yechꞌo ti mu coꞌoluc li cꞌusi ta jnoptique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yechꞌo ti lacalbeic ti tey acuchoj amul chachamique. Mi mu xachꞌunic ti liquemon tal ta vinajele, tey acuchoj amulic ti cꞌalal xachamique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","―¿Muchꞌuot cheꞌe? ―xi ti jmeltsanejcꞌopetique. ―Jaꞌ chac cꞌu chaꞌal lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Acꞌu mi ep cꞌusi xuꞌ chacalbeic, acꞌu mi xuꞌ chcal ti oy amulique, pero mu to bu chacalbeic scotol. Jaꞌ noꞌox chacalbeic ti cꞌusi yalojbon ti Jtote, yuꞌun jaꞌ listac tal. Ti Jtote yech ti cꞌusi chale ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ti jmeltsanejcꞌopetique muc xaꞌibeic smelol ti jaꞌ iyalbe scꞌoplal ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ti Jesuse iyal noxtoc: ―Cꞌalal chajipanicon ta cruz voꞌon ti coꞌol crixchanootique, jaꞌto chul ta ajolic ti liquemon tal ta vinajele. Chul ta ajolic noxtoc ti muc bu ijyules ta jol jtuc ti cꞌusi lacalbeique, ti jaꞌ noꞌox lacalbeic ti cꞌusi yalojbon ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ti Jtote ti listac tale liꞌ xchiꞌinojone. Mu xiyicta yuꞌun scotol cꞌacꞌal ta jpasbe ti cꞌusi jun o yoꞌone ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ti cꞌalal iyaꞌiic chac taje, ep ti muchꞌutic ixchꞌunic ti jaꞌ xa ti muchꞌu scꞌoplal onox chtal spasoticotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ti Jesuse jaꞌ yech lic yalbe ti jchiꞌiltac ta jurioale ti muchꞌutic ixchꞌunique: ―Mi mu xavicta abaic ta xchꞌunel li cꞌusi chacalbeique, jaꞌ chvinaj o ti jꞌechꞌel avichꞌojicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mi jꞌechꞌel avichꞌojicon ta muqꞌue, chul ta ajolic ti yech li cꞌusi chcale. Mi iyul ta ajolic ti yech li cꞌusi chcale, chaloqꞌuic ta mozoil ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","―Li voꞌoticotique jaꞌ jmolmucꞌtatoticotic ti Abraame. Muc muchꞌu smozoinojoticotic. ¿Cꞌu yuꞌun ti “chaloqꞌuic ta mozoil” xavutoticotique? ―xutic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","―Ta melel chacalbeic, ti muchꞌutic tsaꞌulan to smulique ticꞌajtic to ta mulil. Coꞌol xchiꞌuc mozoil ti mu xuꞌ tsloqꞌues sba stuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Li mozoile mu cꞌusi ch-acꞌbat yuꞌun li yajvale yuꞌun mu teyuc o. Yan li chꞌamalile oy cꞌusi ch-acꞌbat yuꞌun li stote yuꞌun tey o. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Voꞌon li Xchꞌamalon Rioxe, mi voꞌon chajloqꞌuesic ta mulile, jꞌechꞌel chaloqꞌuic o. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yech ti jaꞌ amolmucꞌtatotic ti Abraame pero maꞌuc yech isnop chac cꞌu chaꞌal chanopique. Li voꞌoxuque avoꞌonicuc amilicon. Mu xacꞌan xachꞌunic li cꞌusi chacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Li voꞌone jaꞌ chacalbeic ti cꞌusi yacꞌoj quil ti Jtote. Li voꞌoxuque jaꞌ chapasic ti cꞌusi chayalbeic latotique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","―Jaꞌ jtoticotic ti Abraame ―xiic. ―Ti jaꞌuc atotic ti Abraame, jaꞌ chapasic chac cꞌu chaꞌal ispas ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lavie avoꞌonicuc amilicon o ti yech li cꞌusi lacalbeique ti jaꞌ yalojbon ti Rioxe. Ti Abraame maꞌuc yech ispas. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Li voꞌoxuque jaꞌ chapasic ti cꞌu xꞌelan tspas latotique ―xꞌutatic yuꞌun ti Jesuse. ―Li voꞌoticotique mu tsobbalal unenoticoticuc. Jun ti jtoticotique, jaꞌ ti Rioxe ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","―Ti jaꞌuc atotic ti Rioxe, acꞌanojicon ti yechuque yuꞌun jaꞌ tey liquemon tal yoꞌ bu ti Rioxe. Mu ta jmantaluc jtuc ti litale; jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ti mu xavaꞌibeic smelol li cꞌusi chacalbeique, yuꞌun onox mu xacꞌan xavaꞌiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Li voꞌoxuque jaꞌ atotic ti pucuje yuꞌun jaꞌ noꞌox ta avoꞌonic spasulanel li cꞌusitic tscꞌane. Ti pucuje jmilvanej onox ta spasel balamil, yech o cꞌal tana. Ti cꞌusitic ta syules ta ajolique naca maꞌuc yech, naca nopbil cꞌop. Jaꞌ totil jnopcꞌop. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Li voꞌone yech li cꞌusitic chacalbeique pero mu xacꞌan xachꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Li voꞌoxuque mu xatabecon jmul yuꞌun yech li cꞌusitic chacalbeique. ¿Cꞌu yuꞌun ti mu xachꞌunique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ti muchꞌutic jaꞌ yichꞌojic ta mucꞌ ti Rioxe ta xchꞌunbeic li cꞌusitic chale. Ti mu xachꞌunique, yuꞌun maꞌuc avichꞌojic ta mucꞌ ti Rioxe ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ti cajmeltsanejcꞌopticotique jaꞌ yech lic yalbeic ti Jesuse: ―Yuꞌun onox yech ti cꞌusi icalticotique ti jsamariaote, ti oy pucuj ta avoꞌone ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","―Chꞌabal pucuj ta coꞌon. Jaꞌ chcacꞌ ta ichꞌel ta mucꞌ ti Jtote. Li voꞌoxuque mu xacꞌan xavichꞌicon ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jaꞌ chiyacꞌ ta ichꞌel ta mucꞌ ti Jtote, mu jtucuc noꞌox chcacꞌ jba ta ichꞌel ta mucꞌ. Jaꞌ snaꞌoj ti cꞌu xꞌelan li coꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ta melel chacalbeic, ti muchꞌutic ta xchꞌunic li cꞌusi chcale mu xchamic ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","―Lavie jnaꞌojticotic xa ti oy pucuj ta avoꞌone. Ti jmolmucꞌtatotic Abraame icham. Scotol ti yajꞌalcꞌoptac Rioxe ichamic uc. Li voꞌote chaval ti mu xchamic ti muchꞌutic ta xchꞌunic li cꞌusi chavale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mi voꞌot más tsots avabtel yaꞌel chac cꞌu chaꞌal ti jmolmucꞌtatotic Abraame ti ichame? Scotol ti yajꞌalcꞌoptac Rioxe ichamic uc. ¿Muchꞌuot ti avaloje? ―xutic Jesús ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","―Ti jtucuc noꞌox chcacꞌ jba ta ichꞌel ta muqꞌue, xuꞌ mu xavichꞌicon ta mucꞌ. Jaꞌ ti Jtote ti chiyacꞌ ta ichꞌel ta muqꞌue, jaꞌ ti Riox ti avichꞌojic ta mucꞌ ti avalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Li voꞌoxuque muc bu avilojbeic cꞌu xꞌelan yoꞌon ti Rioxe. Li voꞌone quilojbe cꞌu xꞌelan yoꞌon. Mi chcal ti muc bu quilojbe cꞌu xꞌelan yoꞌone, jnopcꞌopon chac cꞌu chaꞌal jnopcꞌopoxuque. Li voꞌone quilojbe cꞌu xꞌelan yoꞌon, ta jchꞌunbe li cꞌusi chiyalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ti atotic Abraam chavalique xmuyubaj xa ti iyaꞌi ti chital onoxe. Coꞌol xchiꞌuc iyil yaꞌel yuꞌun ixchꞌun ti chital onoxe, yechꞌo ti xmuyubaj xae ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","―Mu to sta cincuenta ajabilal. ¿Cꞌuxi avojtiquin ti Abraame ti cremot toe? ―xi ti cajmeltsanejcꞌopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","―Ta melel chacalbeic, cꞌalal mu toꞌox ch-ayan ti Abraame, li voꞌone teyon onox ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ti jmeltsanejcꞌopetique istamic ton, yoꞌonicuc xa smilic ti Jesuse. Muc xilic ilocꞌ ta stiꞌil ti smacol temploe, ibat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yoꞌ bu iꞌechꞌ ti Jesuse, tey iyil jun jchiꞌilticotic ta jurioal, maꞌsat ayanem ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","―Jchanubtasvanej, ¿muchꞌu ta smul ti maꞌsat iꞌayan li jchiꞌiltic leꞌe? ¿Mi ta smul stuc, o mi ta smul stot smeꞌ? ―xcuticotic voꞌoticotic ti yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","―Mu ta smuluc stuc, mi jaꞌuc ta smul stot smeꞌ. Ti maꞌsat iꞌayane, jaꞌ yoꞌ xvinaj o slequilal syuꞌelal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ti cꞌu sjalil liꞌ cuxulon ta sba balamile, persa ta jpas ti cꞌusi tscꞌan ti Jtote ti listac tale yoꞌ to xuꞌ jpas, yuꞌun poꞌot xa xismilic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ti cꞌu sjalil liꞌon ta sba balamile, coꞌol xchiꞌuc aluzicon yaꞌel voꞌoxuc ti liꞌoxuc ta sba balamile, yuꞌun chcacꞌ avilic cꞌu xꞌelan yoꞌon ti Rioxe ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cꞌalal laj yal chac taje, istubta balamil, ispas jsetꞌ achꞌel. Jaꞌ isjaxbe ta xchaꞌpꞌejel sat ti maꞌsate. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","―Ba poco lasate yoꞌ bu li tanqueal voꞌ Siloee ―xut. Li Siloee “tacbil” xi smelol. Ba spoc sat ti maꞌsate. Cꞌalal isute, xil xa osil yuꞌun ijam ti sate. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ti slacꞌnataque xchiꞌuc ti muchꞌutic yilojic onox ti maꞌsate, jaꞌ yech lic yalbe sbaic: ―Li vinic leꞌe ¿mi maꞌuc ti qꞌuex noꞌox tey tscꞌan limoxnae? ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","―Jaꞌ ―xiic jlom. ―Maꞌuc, yuꞌun oy xcoꞌolaj satic ―xiic jlom. ―Voꞌon ti maꞌsaton toꞌoxe ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","―¿Cꞌuxi ijam lasate? ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","―Jaꞌ ispas jsetꞌ achꞌel li jchiꞌiltic Jesús sbie. Jaꞌ lisjaxbe ta xchaꞌpꞌejel jsat. Cꞌalal laj sjaxbee, “batan, ba poco lasate yoꞌ bu li tanqueal voꞌ Siloee”, xiyut. Ay jpoc, jaꞌ ijam o. Lavie xquil xa osil ―xꞌutatic yuꞌun ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―¿Bu ma un? ―xutic. ―Mu jnaꞌ bu ibat ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ti maꞌsat toꞌoxe iyiqꞌuic echꞌel ta stojol jfariseoetic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ta scꞌacꞌalil ox ta jcuxticotic ti ispas jsetꞌ achꞌel ti isjambe o sat vinic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ti jfariseoetique isjacꞌbeic cꞌuxi ijam ti sate. ―Lisjaxbe jsetꞌ achꞌel, tsꞌacal to ay jpoc li jsate, jaꞌ ijam o ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","―Mu xichꞌ ta mucꞌ Riox li vinic chavale yuꞌun mu xchabi li scꞌacꞌalil ta jcuxtique ―xiic jayvoꞌ ti jfariseoetique. ―Ti muchꞌu oy smule mu xjam yuꞌun sat maꞌsatetic chac cꞌu chaꞌal ispas taj vinique ―xiic jlom. Lic yut sbaic ti jfariseoetique jaꞌ ti mu coꞌoluc ti cꞌusi isnopique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Isjacꞌbeic noxtoc ti vinique: ―Li voꞌote ¿muchꞌu lasjambe asat ti avaloje? ―xutic. ―Chcal voꞌone, jaꞌ yajꞌalcꞌop Riox ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ti jfariseoetique mu xchꞌunic ti jaꞌ ti maꞌsat toꞌoxe. Jaꞌto ixchꞌunic ti cꞌalal istacbeic ta iqꞌuel ti stot smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Cꞌalal icꞌot ti stot smeꞌe ―¿Mi jaꞌ acremic liꞌi ti maꞌsat iꞌayan chavalique? ¿Cꞌuxi ijam li sate? ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","―Jaꞌ jcremticotic ti maꞌsat iꞌayane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mu jnaꞌticotic cꞌuxi ijam li sate. Mu jnaꞌticotic noxtoc muchꞌu ijambon o. Jacꞌbeic stuc yuꞌun oy xa xchꞌulel ―xi ti stot smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ti xꞌelan iyal ti stot smeꞌe, yuꞌun xiꞌemic o ti cajmeltsanejcꞌopticotique. Yuꞌun ti jmeltsanejcꞌopetique yalojic xa ti mu xuꞌ ch-ochic ta junuc templo ti muchꞌutic jamal chalbe scꞌoplal ti Jesuse ti jaꞌ ti muchꞌu scꞌoplal onox chtal spasoticotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yechꞌo ti “jacꞌbeic stuc yuꞌun oy xa xchꞌulel”, xi ti stot smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ti jmeltsanejcꞌopetique istaquic ta iqꞌuel noxtoc ti maꞌsat toꞌoxe. ―Alo ti jaꞌ lasjambe asat ti Rioxe. Li vinic chavale, jnaꞌojticotic ti oy smule ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","―Mu jnaꞌ mi oy smul, jaꞌ noꞌox ti lisjambe xa li jsate ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","―¿Cꞌuxi isjam lasate? ―xutic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","―Lacalbeic xa. Mu xachꞌunic tajmec. ¿Cꞌu yuꞌun ti chajaqꞌuic noxtoque? ¿Mi chacꞌan chachiꞌinic uc? ―xꞌutatic yuꞌun ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","―Li voꞌote achiꞌinoj xa. Li voꞌoticotique jaꞌ ta jchꞌunticotic cꞌusi yaloj ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jnaꞌojticotic ti iscꞌopon sbaic xchiꞌuc ti Rioxe. Taj chavale, mu jnaꞌticotic bu liquem tal ―xiic ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Itacꞌav ti vinique: ―Mu jchꞌun jnaꞌ ti mu xanaꞌic une yuꞌun avilic xa ti lisjambe li jsate. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti Rioxe jnaꞌojtic ti mu xichꞌbe ta mucꞌ cꞌusi chalic ti muchꞌutic mu xꞌichꞌon o ta muqꞌue. Yan ti muchꞌutic ch-ichꞌon ta muqꞌue, ti tspasbeic cꞌusi tscꞌane, chichꞌbe ta mucꞌ li cꞌusi chalique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ta spasel balamil mu onox bu xcaꞌitic mi oy muchꞌu chjam yuꞌun sat ti muchꞌu maꞌsat iꞌayane. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti manchuc tacbil tal yuꞌun Riox li muchꞌu chcale, mu cꞌu xuꞌ spas ti yechuque ―xꞌutatic ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Cꞌalal iyaꞌiic chac taje, islabanic: ―Yuꞌun chopolot li voꞌote, yechꞌo ti maꞌsat laꞌayane. Pero lavie voꞌot xa chacꞌan chachanubtasoticotic ―xutic. Isnutsic loqꞌuel ta templo. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ti Jesuse iyaꞌi ti inutse loqꞌuel ta templo ti maꞌsat toꞌoxe. Isaꞌe yuꞌun ti Jesuse. Cꞌalal itae, ijacꞌbat: ―¿Mi achꞌunoj ti talem xa Xchꞌamal ti Rioxe? ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","―Totic, ¿bu li Xchꞌamal Riox chavale? Ta jchꞌun ―xi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","―Liꞌ aqꞌuelojbe sate. Voꞌon ti liꞌ chajcꞌopone ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Cꞌalal iyaꞌi ti vinique, isquejan sba ta yichon ti Jesuse, ―Cajval, ta jchꞌun ti voꞌot Xchꞌamalot ti Rioxe ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","―Ti lital liꞌ ta sba balamile, jaꞌ yoꞌ xvinaj o cꞌu xꞌelan yoꞌon li crixchanoetique. Ti muchꞌutic mu snaꞌic ti cꞌuxi chcuxiic ta sbatel osile, ti snaꞌojic ti chopol sjolique, ta onox xꞌacꞌbat xchꞌunic yuꞌun ti Rioxe ti voꞌon chcacꞌbe scuxlejalique. Coꞌol xchiꞌuc chjambat yaꞌel li satique. Yan ti muchꞌutic lec cꞌusitic tspasic ti yalojique, ti jaꞌ chcuxiic o ta sbatel osil ti yalojique, mu xꞌacꞌbat xchꞌunic ti voꞌon chcacꞌbe scuxlejalic ta sbatel osile. Coꞌol xchiꞌuc tspasatic ta maꞌsat yaꞌel ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ti jlom jfariseoetique ti tey xchiꞌuquic ti Jesuse, cꞌalal iyaꞌiic ti xꞌelan iyal ti Jesuse, ―Ti avaloje, yuꞌun maꞌsatoticotic uc ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","―Ti maꞌsaticoxuque, chꞌabal amulic ti yechuque. Jaꞌ amulic ti lec cꞌusitic chapasic ti avalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Ta melel chacalbeic, ti muchꞌutic mu ta tiꞌ corraluc ch-ochique, mi chpꞌitic ochel ta xocone, jaꞌ jꞌelecꞌchijetic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Li jchabichijetique ta tiꞌ corral ch-ochic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Li jchabiejtiꞌcorrale jaꞌ noꞌox chacꞌ ochuc li jchabichijetique. Li chije xaꞌibeic ye li yajvalique. Li jchabichijetique ta sbiiltasic jucot ti cꞌalal tsloqꞌuesique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mi laj sloqꞌues ti jaycot xchij jujun jchabichije, jaꞌ chjelav li jchabichije, jaꞌ napꞌal chbat li chije yuꞌun xaꞌibe ye li yajvale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mi iyaꞌiic ti maꞌuc ye li yajvalique, mu xbatic. Chjatavic ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jaꞌ yech iyal loꞌil ti Jesuse. Ti jchiꞌiltaque muc xaꞌibeic smelol ti cꞌusi iꞌalbatique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ti Jesuse iyalbe noxtoc ti jchiꞌiltac ta jurioale: ―Ta melel chacalbeic, voꞌon tiꞌcorralon yaꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Scotol ti muchꞌutic chaxchabiic ta alele ti liꞌic xa onox ti cꞌalal mu toꞌox chitale, naca jloꞌlovanejetic. Coꞌolic xchiꞌuc jꞌelecꞌchij. Ti muchꞌutic liyichꞌic ta muqꞌue muc xchꞌunic ti cꞌusi iꞌalbatique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Li voꞌone tiꞌcorralon yaꞌel, yuꞌun ti muchꞌutic chiyichꞌic ta muqꞌue ta xcuxiic ta sbatel osil. Mu xa cꞌusi xiꞌic o. Jun xa yoꞌonic, mu xa cꞌusi tscꞌanic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Li jꞌelecꞌchije ch-elcꞌaj noꞌox, tsocvan, chmilvan. Yan li voꞌone chcacꞌ cuxlicuc ta sbatel osil. Jaꞌ noꞌox yech jun yoꞌonic ch-echꞌic liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Li lequil jchabichije muc ta alel yuꞌun mi jaꞌ xlaj ta oqꞌuil li stuque yoꞌ mu xlaj o li xchije. Jaꞌ noꞌox yech li voꞌon uque, ta xcacꞌ jba ta milel yoꞌ xcuxiic o ta sbatel osil ti muchꞌutic chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Li jsaꞌabteletique, mi iyaꞌiic ti chtal oqꞌuile, lamal chictaic li chije, chjatavic. Oy jaycot chlaj ta oqꞌuil, jlom chjatavic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ti chjatavic li jsaꞌabteletique, yuꞌun staqꞌuin noꞌox tsaꞌic, yechꞌo ti mu cꞌu scuentaic o li chije. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Voꞌon li lequil jchabichijon yaꞌele, ta jchabi lec ti muchꞌutic chiyichꞌic ta muqꞌue. Quilojbe cꞌu xꞌelan yoꞌonic, yilojic cꞌu xꞌelan coꞌon uc chac cꞌu chaꞌal yiloj cꞌu xꞌelan coꞌon ti Jtote, quilojbe cꞌu xꞌelan yoꞌon uc. Chcacꞌ jba ta milel yuꞌunic ti muchꞌutic chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oy maꞌuc jchiꞌiltic ta jurioal chlic yichꞌicon ta mucꞌ uc. Persa ta xquiqꞌuic uc. Ta xchꞌunic ti cꞌusitic chcalbeique. Jtos chacꞌot achiꞌuquic. Jun noꞌox Avajchabivanejic, voꞌon chajchabiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Scꞌanojon ti Jtote yuꞌun chcacꞌ jba ta milel yuꞌunic ti muchꞌutic chiyichꞌic ta muqꞌue. Tsꞌacal to chichaꞌcuxi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Muc muchꞌu xuꞌ chismil. Scꞌan noꞌox coꞌon ti chcacꞌ jba ta milele. Xuꞌ chcacꞌ jba ta milel, xuꞌ chichaꞌcuxi noxtoc yuꞌun jaꞌ yech yalojbon ti Jtote ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cꞌalal laj yal chac taje, ti cajmeltsanejcꞌopticotique tsotsic xa iyalbe sbaic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ep iyalic ti oy pucuj ta yoꞌone, ti chlic xchuvaje. ―¿Cꞌu yuꞌun chavaꞌibeic li cꞌusi chale? ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","―Ti muchꞌu oy pucuj ta yoꞌone maꞌuc yech chcꞌopoj chac cꞌu chaꞌal chcꞌopoje. ¿Miꞌn chjam yuꞌun sat maꞌsatetic ti pucuje? ―xiic ti jlome. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ta Jerusalene jaꞌo yolel sqꞌuinic ti jchiꞌiltac ta jurioale, jaꞌ ti tsyules o ta sjolic cꞌusi ora ichaꞌtun yuꞌun Riox noxtoc ti mucꞌta temploe. Jaꞌo ta corixmatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ti Jesuse tey xvaꞌet ta coycoyna ta xocon templo yoꞌ Salomón sbie. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ti cajmeltsanejcꞌopticotique tal sjoyletaic ti Jesuse. ―¿Cꞌu to ora ti jamal chavalboticotic mi voꞌot chapasoticotic ta mantale? Alboticotic xa ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","―Lacalbeic xa, pero mu xachꞌunic. Avilic noxtoc li jlequilal jyuꞌelale ti jaꞌ yalojbon ti Jtote ti chcacꞌ iluque. Ti yechuque, jaꞌ avilic o ti voꞌon Xchꞌamalon ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ti mu xachꞌunique, jaꞌ ti mu xavichꞌicon ta muqꞌue chac cꞌu chaꞌal lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ti muchꞌutic chiyichꞌic ta muqꞌue chaꞌiic ti cꞌusi chcalbeique. Quilojbe cꞌu xꞌelan yoꞌonic. Tspasic ti cꞌusi chcalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta xcacꞌ cuxlicuc ta sbatel osil, mu xꞌochic ta cꞌocꞌ. Muc muchꞌu xuꞌ chispojbe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yuꞌun jaꞌ liyacꞌbe ti Jtote ti chiyichꞌic ta muqꞌue. Muc muchꞌu xuꞌ tspojbe ti Jtote yuꞌun más oy syuꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Li voꞌone junoticotic xchiꞌuc ti Jtote ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ti jmeltsanejcꞌopetique istamic ton noxtoc, yoꞌonicuc xa smilic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iꞌalbatic yuꞌun ti Jesuse: ―Jaꞌ ta smantal Jtot ti lec ti cꞌusitic lacacꞌbe avilique. ¿Cꞌusi chopol icacꞌ avilic ti avoꞌonicuc amilicone? ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","―Muꞌnuc jaꞌ chacacꞌbeticotic o ton ti lec cꞌusi apase; jaꞌ ti chapꞌis aba ta Rioxe ―xi ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Itacꞌav ti Jesuse: ―Tey tsꞌibabil ta scꞌop Riox ti avichꞌojique: “Voꞌoxuc jqꞌuexoloxuc”, xꞌutatic yuꞌun Riox ti jmeltsanejcꞌopetic ti ta voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Jqꞌuexoloxuc”, xi scꞌoplalic ti muchꞌutic iꞌacꞌbat yabtelic yuꞌun Riox ti voꞌnee. Mu xchꞌay ti cꞌusi yaloj ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Lec ti yech iꞌalbatique”, xachiic. Lec ti yech chavalique, pero ¿cꞌu yuꞌun chavalic ti ta jpꞌis noꞌox jba ta Rioxe ti ical ti voꞌon Xchꞌamalon ti Rioxe? Ti lital liꞌ ta sba balamile, yuꞌun jaꞌ listac tal ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ti mi maꞌuc yabtel Jtot ta jpas chavilique, mu me xachꞌunic ti voꞌon Xchꞌamalone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero ti mi jaꞌ yabtel Jtot ta jpas chavilique, chꞌunic me acꞌu mi mu xachꞌunic ti voꞌon Xchꞌamalone. Mi chachꞌunique, chul ta ajolic ti junoticotique ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ti jmeltsanejcꞌopetique ta ox stsaquic noxtoc ti Jesuse, pero muc staic ta tsaquel yuꞌun ora isqꞌuej sba echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ti Jesuse ichaꞌsut echꞌel ta jech ucꞌum Jordán yoꞌ bu ti iyacꞌ toꞌox ichꞌvoꞌ ti Juane. Tey ipaj jayib cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ti cꞌalal teye, ep jchiꞌilticotic ta jurioal tey icꞌotic yoꞌ bu ti Jesuse. ―Acꞌu mi muc xacꞌ iluc slequilal syuꞌelal Riox ti Juan jꞌacꞌ-ichꞌvoꞌe, pero yech ti cꞌu xꞌelan iyalbe scꞌoplal li jchiꞌiltic liꞌi ―xiic ti muchꞌutic tey icꞌotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ti muchꞌutic tey icꞌotique ep ixchꞌunic ti jaꞌ tacbil tal yuꞌun Riox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oy jun jchiꞌilticotic ta jurioal, Lázaro sbi. Itsaque ta chamel. Tey nacal ta Betania. Tey nacajtic chaꞌvoꞌ antsetic uc. María sbi ti june. Marta sbi ti june. Svix smuc noꞌox sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ti Maríae jaꞌ ti tsꞌacal to ismalbe muil nichim ta yoc ti Cajvaltic Jesuse, ti iscusbe ta stsatsal sjole. Jaꞌ stsebal ti Lázaroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ti stsebaltac Lázaroe istaquic ta iqꞌuel ti Jesuse: ―Cajval, li Lázaroe, ti acꞌanoje, tsots la me ip ―xi cꞌotel ti muchꞌu istaquic echꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cꞌalal iyaꞌi ti Jesuse ―Li chamel taje mu xcham o. Jaꞌ noꞌox yoꞌ xꞌichꞌe o ta mucꞌ ti Rioxe, yoꞌ xiꞌichꞌe o ta mucꞌ uque, voꞌon li Xchꞌamalone ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Ti Jesuse, acꞌu mi lec scꞌopon sbaic xchiꞌuc ti Martae, xchiꞌuc ti smuque, xchiꞌuc ti Lázaroe, cꞌalal iyaꞌi ti ipe, muc xba sqꞌuel ta ora. Chib to cꞌacꞌal tey ipaj ta jech ucꞌum Jordán. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsꞌacal to ―Suticotic ta Judea ―xiyutoticotic voꞌoticotic ti yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","―Jchanubtasvanej, achꞌ to me ti yoꞌonicuc smilot ta ton li jchiꞌiltactique. ¿Cꞌu yuꞌun ti chachaꞌsut echꞌel noxtoc teyoꞌe? ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","―Ti Rioxe lajcheb ora yacꞌoj li jujun cꞌacꞌale yuꞌun chiꞌabtejotic. Jaꞌ noꞌox yechon uc, yora to chiꞌabtej. Ti muchꞌutic jaꞌ tspasic cꞌusi tscꞌan ti Rioxe mu xiꞌic. Coꞌolic xchiꞌuc ti muchꞌutic chanavic ta cꞌacꞌaltique, mu cꞌusi spꞌosi o yoquic, xil sbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yan ti muchꞌutic mu xichꞌic ta mucꞌ ti Rioxe, coꞌolic xchiꞌuc ti muchꞌutic chanavic ta acꞌubaltique, tspꞌosi yoquic, mu xil sbeic ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tsꞌacal to liyalboticotic noxtoc: ―Lec jcꞌopon jbatic jchiꞌuctic ti Lázaroe, pero ivay xa. Chba jtij ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","―Cajval, mi iꞌoch xa svayele, yuꞌun nan yo jsetꞌ xa. Ch-echꞌ xa li chamele ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ti xꞌelan iyal ti Jesuse, yuꞌun icham ti Lázaroe. Li voꞌoticotique ijchꞌunticotic ti vayem noꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ti Jesuse jamal liyalboticotic ti ichame. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","―Lec ti mu teyicon cꞌalal ilocꞌ xchꞌulele yoꞌ xachꞌunic o ti stacojon tal ti Rioxe. Ba jqꞌueltic ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tey jun jchiꞌilticotic ta yajchancꞌop ti Jesuse, jaꞌ ti Tomase, ti “vach”, xcuticotique. ―Batic, coꞌol chamicotic xchiꞌuc li Cajchanubtasvanejtique ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ital ti Jesuse. Ti cꞌalal iyule, xchanibal xaꞌox cꞌacꞌal smuquel ti Lázaroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Li Betaniae nopol xil sba xchiꞌuc Jerusalén. Oy noꞌox nan oꞌloluc reva xil sba xchiꞌuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tey ep jchiꞌilticotic ta spatbeic yoꞌonic ti Martae xchiꞌuc ti Maríae, jaꞌ ti icham ti scremalique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ti Martae, cꞌalal iyaꞌi ti ital xa ti Jesuse, ora ba snup ta be. Ti Maríae tey icom ta snaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ti Martae jaꞌ yech lic yalbe ti Jesuse: ―Cajval, ti liꞌicot cꞌalal iꞌipaj ti jcremale, muc xcham ti yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Acꞌu mi oy xa scꞌacꞌalil ti ichame, scotol ti cꞌusitic chacꞌanbe ti Rioxe jnaꞌoj ti chayacꞌbee ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","―Ta xchaꞌcuxi loqꞌuel ta smuquenal ti acremale ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","―Jnaꞌoj onox ti ta xchaꞌcuxi loqꞌuel ta smuquenal ti cꞌalal poꞌot xaꞌox xlaj li balamile, jaꞌo cꞌalal ta xchaꞌcuxiic scotol ti muchꞌutic chamemic xaꞌoxe ―xi ti Martae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","―Voꞌon chajchaꞌcuxesic. Voꞌon chcacꞌ cuxlanic ta sbatel osil. Ti muchꞌutic chiyichꞌic ta muqꞌue, acꞌu mi xchamic, ta onox xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ti muchꞌutic ta xcuxiic ta sbatel osile, jaꞌ ti muchꞌutic yichꞌojicon ta muqꞌue, ichꞌay xa scꞌoplal ti ch-ochic ta cꞌocꞌ ta sbatel osile. ¿Mi achꞌunoj li voꞌote? ―xꞌutat yuꞌun Jesús ti Martae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","―Jchꞌunojaꞌa, Cajval. Jchꞌunoj ti voꞌot Cristoote, ti Xchꞌamalot Rioxe, ti stacojot tal ti Rioxe ―xi ti Martae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ti cꞌalal laj yal chac taje, ba yicꞌ tal ti smuque. Mucul la cꞌot yalbe: ―Ital xa li Jchanubtasvaneje. Ba la cꞌopono ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Cꞌalal iyaꞌi ti Maríae, ora tal scꞌopon ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mu toꞌox chcꞌot ta Betania ti Jesuse. Tey toꞌox yoꞌ bu icomtsanat yuꞌun ti Martae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ti jchiꞌilticotic tey tspatbeic yoꞌon ti Maríae, cꞌalal iyilic ti ilocꞌ ta anile, tijilic tal uc. ―Yuꞌun nan chba ocꞌuc ta smuquenal ti scremale ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ti Maríae, cꞌalal icꞌot yoꞌ bu ti Jesuse, isquejan sba ta yichon, jaꞌo isnijan sba ta balamil noxtoc. ―Cajval, ti liꞌicot cꞌalal iꞌipaj ti jcremale, muc xcham ti yechuque ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Cꞌalal iyil ti Jesuse ti ch-ocꞌ ti Maríae, ti ch-oqꞌuic noxtoc ti jchiꞌilticotic xchiꞌinoj tale, chopol iyaꞌi ti oy meꞌanal liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","―¿Bu ay amuquic? ―xꞌutatic. ―Ba jqꞌueltic avil ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iꞌocꞌ ti Jesus uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","―Qꞌuelavilic, batsꞌi scꞌanoj tajmec ti ánima Lázaroe ―xut sbaic ti jchiꞌilticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ti jlome jaꞌ yech lic yalic: ―Li vinic leꞌe chjam yuꞌun sat li maꞌsatetique. ¿Cꞌu yuꞌun ti muc xetꞌesbe xchamel ti ánima Lázaroe? Ti iyetꞌesbeuque, muc xcham ti yechuque ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ti Jesuse chopol iyaꞌi noxtoc ti oy meꞌanal liꞌ ta sba balamile. Jaꞌ yech icꞌot o yoꞌ bu mucbil ti Lázaroe. Ti smuquenal Lázaroe cꞌox nail chꞌen. Jpꞌej mucꞌta ton macbil o stiꞌil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","―Loqꞌuesic li tone ―xi ti Jesuse. ―Cajval, tu xa yuꞌun xchanibal xa cꞌacꞌal jmucojticotic ―xi ti Marta stsebal Lázaroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","―Lacalbe onox mi chachꞌune chavil cꞌu xꞌelan slequilal syuꞌelal ti Rioxe ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Isloqꞌuesic li tone ti macbil o stiꞌil smuquenal ti Lázaroe. Ti Jesuse isqꞌuel vinajel, iscꞌopon Riox: ―Tot, colaval ti chavaꞌi li cꞌusi chcale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jnaꞌoj ti scotol cꞌacꞌal chavaꞌie. Ti xꞌelan chacalbee, jaꞌ yoꞌ xaꞌiic o li muchꞌutic liꞌ nopol vaꞌajtique, yoꞌ xchꞌunic o ti voꞌot atacon tale ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cꞌalal laj yal chac taje, iyapta ti ánimae: ―¡Lázaro, locꞌan tal! ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ora ichaꞌcuxi. Cꞌamulanbil ta natil pocꞌ sjunlej ilocꞌ tal. Sutꞌul ta pocꞌ ti sjole. ―Jitunbeic li scꞌamobile, acꞌu batuc ―xut crixchanoetic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ti jchiꞌilticotic xchiꞌinoj tal ti Maríae, ep ixchꞌunic ti tacbil tal yuꞌun Riox ti Jesuse cꞌalal iyilic ti ichaꞌcuxi ti Lázaroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero oy jayvoꞌ ba yalbeic ti jfariseoetique ti ixchaꞌcuxes ánima ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yechꞌo un ti totil paleetique xchiꞌuc ti jfariseoetique istsob ti xchiꞌilic ta meltsanejcꞌope. ―¿Cꞌusi ta jnopbetic xanaꞌic taj jchiꞌiltic taje ti ep chacꞌ iluc syuꞌele? ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Tey acꞌu spas”, mi xichiotique, ta xchꞌun scotol jchiꞌiltactic ti jaꞌ xa ti muchꞌu tꞌujbil yuꞌun Riox ti chispasotic ta mantale. Yicꞌal stiqꞌuic ta preserenteal liꞌ ta jlumaltique. Ti mi iꞌoche, ta soc sjol ti preserente ta Romae. Yicꞌal stac tal yajsolterotac slomesic li jtemplotique xchiꞌuc scotol li naetique. Ti mi islomesique, ta xchꞌay jcꞌoplaltic jcotoltic ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tey jun xchiꞌilic ta meltsanejcꞌop, Caifás sbi. Ti Caifase jaꞌo sjabilal ochem ta más totil paleal. Jaꞌ yech lic yal: ―Li voꞌoxuque mu xanaꞌic snopel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Más lec mi jun noꞌox vinic chlaje; jaꞌ chopol mi lilajotic jcotoltique ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mu ta sjoluc stuc ti xꞌelan iyale. Yuꞌun jaꞌo ochem ta más totil paleal, yechꞌo ti ichꞌamunbat ye yuꞌun ti Rioxe ti iyal ti jaꞌ ta jqꞌuexolinticotic ti Jesuse voꞌoticotic li juriooticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mu jtucticoticuc noꞌox ijqꞌuexolinticotic. Jaꞌ ijqꞌuexolintic jcotoltic ta sjunlej balamil voꞌotic ti chquichꞌtic ta mucꞌ ti Rioxe, yechꞌo ti jtos xa noꞌox licꞌototic oe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti cajmeltsanejcꞌopticotique lec iyaꞌiic ti xꞌelan iyal ti Caifase, ora isnopic cꞌuxi tstaic ta milel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yechꞌo un ti Jesuse mu xa bu iyacꞌ sba iluc teyoꞌe, ibat ta stsꞌel xocol balamil ta jun jteclum Efraín sbi. Jchiꞌucticotic echꞌel voꞌoticotic ti yajchancꞌopoticotique. Tey lipajoticotic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Poꞌot xaꞌox sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotic voꞌoticotic li juriooticotique. Ep jchiꞌilticotic baꞌyi icꞌotic ta Jerusalén, cꞌot xchap sbaic chac cꞌu chaꞌal yaloj ti Rioxe yoꞌ lec xꞌileic o yuꞌun Riox ta qꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ti cꞌalal icꞌotic ta Jerusalene, lic saꞌic ta tiꞌ mucꞌta templo ti Jesuse yuꞌun tscꞌan ta xchiꞌinic. ―¿Mi chtal ta qꞌuin xanaꞌic? ¿Mi mu van bu yaꞌyoj ti chichꞌ tsaquele? ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ti xꞌelan iyalbe sbaique, yuꞌun yaloj xaꞌox mantal ti totil paleetique xchiꞌuc ti jfariseoetique ti acꞌu yal mi oy muchꞌu iyil buy ti Jesuse yuꞌun chba yichꞌ tsaquel tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Scan toꞌox vaquib cꞌacꞌal sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, ichaꞌsut noxtoc ta Betania ti Jesuse yoꞌ bu nacal ti Lázaroe, jaꞌ ti ichame, ti ichaꞌcuxesat loqꞌuel ta smuquenale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ti Lázaroe xchiꞌuc ti stsebaltaque ismeltsanic veꞌlil yuꞌun chichꞌic ta mucꞌ ti Jesuse. Tey liveꞌoticotic uc. Jaꞌ ixchol veꞌlil ti Martae. Ti Lázaroe coꞌol liveꞌoticotic ta mexa xchiꞌuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ti Maríae iyichꞌ tal oꞌlol kilo yaꞌlel muil nichim, jaꞌ li nardoe. Toyol tajmec stojol. Iscoconbe ta yoc ti Jesuse. Cꞌalal laj scoconbee, jaꞌo iscusbe ta stsatsal sjol. Li nardoe xmuet xa ta sjunlej yut na. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tey jun jchiꞌilticotic ta yajchancꞌop ti Jesuse, jaꞌ ti Judas Iscariotee ti iyacꞌ entrucal ta tsꞌacal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Cꞌu yuꞌun ti muc xchon ta oxib cien denario li yaꞌlel nardoe? Li stojole xuꞌ chichꞌ meꞌonetic ti yechuque ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ti xꞌelan iyale, muꞌnuc tscꞌuxubin li meꞌonetique; jaꞌ yoꞌonuc yelcꞌan. Yuꞌun chelcꞌan onox jutuc li jtaqꞌuinticotic xchabioje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iꞌalbat yuꞌun ti Jesuse: ―Mu xaval yech. Li yaꞌlel nardo ti liꞌ toꞌox snacꞌoje, jaꞌ ox ta xtun ti cꞌalal xichame, ti cꞌalal ximuquee, pero liyacꞌbe xa. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Li meꞌonetique scotol cꞌacꞌal liꞌ achiꞌinojique. Li voꞌone muc bu liꞌ jchiꞌinojoxuc scotol cꞌacꞌale ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ti jchiꞌilticotic tey tsobolic ta Jerusalene, iyaꞌiic ti ichaꞌsut noxtoc ta Betania ti Jesuse. Ora ibatic. Mu stucuc noꞌox ba sqꞌuelic ti Jesuse, cꞌalal ta Lázaro ba sqꞌuelic, jaꞌ ti ichaꞌcuxi loqꞌuel ta smuquenale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ti totil paleetique yoꞌonicuc ox smilic ti Lázaro uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yuꞌun jaꞌ ta smul ti ep xa jchiꞌilticotic iyictaic yichꞌel ta mucꞌ ti paleetique, ti jaꞌ xa iyichꞌic ta mucꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ta yocꞌomal tey stsoboj sbaic ta Jerusalén scotol ti jchiꞌilticotic ta jurioale yuꞌun jaꞌo xa li qꞌuine. Iyaꞌiic ti tey chcꞌot ta Jerusalén ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Isaꞌic yanal xan, iloqꞌuic echꞌel ta tiꞌ jteclum. Sjapojic echꞌel ti yanal xane yuꞌun ba snupic ta be ti Jesuse. Xꞌavlajetic xa echꞌel: ―¡Coliyalbotic Riox ti lec tajmec li preserente listacbotic tal voꞌotic li jꞌisraelotique! ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ti Jesuse ista jcot burro, iscajlebin chac cꞌu chaꞌal tsꞌibabil onox ta scꞌop Rioxe: ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jchiꞌiltactic, mu la me xcat coꞌontic. Ta la xtal ti muchꞌu chispasotic ta mantale. Cajal la ta burro ch-och tal, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Voꞌoticotic ti yajchancꞌopoticotique muc xcaꞌibeticotic smelol cꞌu yuꞌun ti cajal ta burro iꞌoch ta Jerusalene. Jaꞌto cꞌalal imuy ta vinajele iyul ta jolticotic ti tsꞌibabil onox ta scꞌop Riox ti ch-ichꞌe ta mucꞌ yuꞌun ti jchiꞌiltaque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Ti ba snupic ta bee, jaꞌ ti iyaꞌiic ti ixchaꞌcuxes loqꞌuel ta smuquenal ti Lázaroe. Jaꞌ iyal ti muchꞌutic tey xchiꞌuquic ti cꞌalal ixchaꞌcuxese. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero ti jfariseoetique jaꞌ yech lic yalbe sbaic: ―Qꞌuelavilic, mu xa me xaꞌi pajesel li jchiꞌiltactique. Ep xa ti muchꞌutic lec chilic li Jesuse ―xut sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tey jayvoꞌ jgreciaetic ta qꞌuine yuꞌun jaꞌ yech xchꞌunojic chac cꞌu chaꞌal xchꞌunojic li jchiꞌiltac ta jurioale. Tal yacꞌbeic smoton Riox uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Icꞌoponat ti Felipee, jaꞌ ti coꞌol yajchancꞌopoticotic ti Jesuse, ti liquem tal ta jteclum Betsaida ta estado Galileae. ―Totic, ¿mi xuꞌ jcꞌoponticotic li Jesuse? ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ti Felipee ba yalbe ti Andrese. Xchaꞌvaꞌalic xa iyalbeic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Itacꞌav ti Jesuse: ―Ista xa yora ti chiyacꞌ ta ichꞌel ta mucꞌ ti Rioxe, voꞌon ti coꞌol crixchanootique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta melel chacalbeic, persa chquichꞌ milel yoꞌ ep xcuxiic o ta sbatel osil li crixchanoetique. Coꞌol xchiꞌuc trigo, mi mucbile, ta xchꞌi, ta xbeqꞌuin. Mi muc bu mucbile, mu xchꞌi, mu xbeqꞌuin. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ti muchꞌutic mu scꞌan xiyichꞌic ta mucꞌ yuꞌun ti chiꞌic o li milele, yuꞌun onox ta xꞌochic ta cꞌocꞌ ta sbatel osil. Yan ti muchꞌutic muc ta alel yuꞌunic mi jaꞌ xlajic oe, ta xcuxiic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ti muchꞌutic ta xtunic cuꞌune, acꞌu yacꞌ svocolic chac cꞌu chaꞌal chcacꞌ jvocole. Mi icuch yuꞌunique, chba xchiꞌinicon ta vinajel. Ch-aqꞌueic ta ichꞌel ta mucꞌ yuꞌun ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Xuꞌ yaꞌel ti mu xichame, pero mu xuꞌ xcalbe ti Rioxe ti mu jcꞌan xichame, ti acꞌu spojone. Ti lital liꞌ ta sba balamile, persa chicham ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jaꞌo lic scꞌopon Riox: ―Tot, acꞌu cacꞌot ta ichꞌel ta mucꞌ ―xi. Itacꞌav tal ta vinajel ti Rioxe: ―Avacꞌon xa ta ichꞌel ta mucꞌ. Pero ta to xavacꞌon ta ichꞌel ta mucꞌ noxtoc ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ti crixchanoetic tey tsobolique iyaꞌiic ti oy cꞌusi tsots ibacꞌ ta vinajele. ―Ch-avan chavuc ―xiic jlom. ―Yuꞌun nan icꞌoponat yuꞌun jun anjel ta vinajel ―xiic jlom. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jaꞌ yech lic albaticuc yuꞌun ti Jesuse: ―Yuꞌun ti tsots listacꞌbe ti Jtote, jaꞌ yoꞌ xavaꞌiic o li voꞌoxuque ti iyaꞌi cꞌusi icalbee. Muꞌnuc jaꞌ yoꞌ xcaꞌi o li voꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yuꞌun ista xa yora ti ta jchꞌaybe syuꞌel ti pucuje ti jaꞌ chꞌunbil smantal liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jipil chicham ta scoj smulic li crixchanoetique yoꞌ voꞌon xa chiyichꞌic o ta muqꞌue ―xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jaꞌ icaꞌiticotic o ti jipil ta cruz ta xchame. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Itacꞌav ti jchiꞌiltaque: ―Caꞌyojbeticotic onox scꞌoplal ti muchꞌu stꞌujoj Riox chtal spasoticotic ta mantale. Tsꞌibabil ta scꞌop Riox ti cuxul o ta sbatel osile. Mi voꞌot ti chapasoticotic ta mantale, ¿cꞌu yuꞌun ti “jipil chicham voꞌon ti coꞌol crixchanootique”, xachie? ¿Muchꞌuot cheꞌe? ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Itacꞌav ti Jesuse: ―Mu xa jaluc liꞌ chajchanubtasique. Más lec chꞌunic li cꞌusi chacalbeique yoꞌto xuꞌ xachꞌunic, yoꞌ xacuxiic o ta sbatel osile. Jaꞌ chac cꞌu chaꞌal li jxanvile, mi jliquel xa noꞌox sac li osile, tsuj sba yoꞌ mu xꞌicꞌub o yuꞌun ta bee. Mi iꞌicꞌube, mu xa xil sbe, mu snaꞌ bu chbat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jaꞌ noꞌox yechoxuc uc, yoꞌto me liꞌ jchiꞌucoxuque, chꞌunic me ti voꞌon chcacꞌ acuxlejalique yoꞌ ti xacuxiic o ta sbatel osile ―xꞌutatic. Cꞌalal laj yal chac taje, muc xilic bu ibat ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ti jchiꞌiltac ta jurioale yech noꞌox ti ep ta echꞌel iyilbeic slequilal syuꞌelal ti Jesuse, muc xchꞌunic ti jaꞌ stꞌujoj Riox chacꞌ jcuxlejaltic ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jaꞌ icꞌot ti cꞌusi stsꞌibaoj ti Isaías yajꞌalcꞌop Riox ti ta voꞌnee. Acꞌu la mi ep ta echꞌel xilbeic slequilal syuꞌelal, pero ep la jchiꞌiltactic mu la scꞌan xchꞌunic ti jaꞌ stꞌujoj Riox chacꞌ jcuxlejaltic ta sbatel osile, xi stsꞌibaoj ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ti muc xchꞌunic ti jchiꞌiltac ta jurioale, yuꞌun jaꞌ icꞌot ti cꞌusi stsꞌibaoj noxtoc ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ep to ta echꞌel chaꞌiic lachiꞌiltaque, pero mu xaꞌibeic smelol. Ep to ta echꞌel chilic pero coꞌol xchiꞌuc mu xilic yuꞌun stoyoj sbaic. Yuꞌun mu scꞌan xictaic spasel li cꞌusitic chopole, yechꞌo ti mu xcacꞌ cuxlicuc ta sbatel osile, xi ti Rioxe, xi ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ti xꞌelan iyal ti Isaíase ti ep ta echꞌel chilbeic slequilal syuꞌelal ti muchꞌu chtaque tal yuꞌun ti Rioxe, yuꞌun iꞌacꞌbat yil ti Isaíase ti oy slequilal syuꞌelale. Yechꞌo ti jaꞌ yech iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Acꞌu mi ep jchiꞌilticotic ti muc xchꞌunique, pero ixchꞌunic onox jlom ti jaꞌ tacbil tal yuꞌun Riox ti Jesuse. Ixchꞌunic jayvoꞌ jmeltsanejcꞌopetic uc, pero muc bu iyalic ti xchꞌunojique. Mi iyalique, mu xꞌaqꞌue ochicuc ta junuc templo. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ti jmeltsanejcꞌopetique jaꞌ tsots scꞌoplal iyaꞌiic ti ichꞌbilic ta mucꞌ yuꞌun li crixchanoetique; jaꞌ mu tsotsuc scꞌoplal iyaꞌiic ti lec ch-ileic yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ti Jesuse iscꞌopon noxtoc ti jchiꞌiltaque. Tsots icꞌopoj: ―Ti muchꞌutic chiyichꞌic ta muqꞌue, mu jtucuc noꞌox chiyichꞌic ta mucꞌ. Jaꞌ chichꞌic ta mucꞌ yaꞌel ti Jtot uque yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ti muchꞌutic liyilic xae, coꞌol xchiꞌuc iyilic xa yaꞌel ti Jtot uque, jaꞌ ti listac tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Li voꞌone coꞌol xchiꞌuc aluzicon yaꞌel, voꞌoxuc ti teyoxuc ta icꞌ osil yaꞌel ta scoj li mulile. Ti muchꞌutic chiyichꞌic ta muqꞌue mu xa bu tsaꞌ smulic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ti muchꞌutic chaꞌi li cꞌusitic chcale, mi mu xiyichꞌic ta muqꞌue, mu to bu chcacꞌbeic castico. Muꞌnuc tal cacꞌbeic castico li crixchanoetique, yuꞌun tal jpojic jaꞌ ti scꞌoplal ch-ochic ta cꞌoc ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ti muchꞌutic mu xiyichꞌic ta muqꞌue, ti mu xchꞌunic li cꞌusi chcalbeique, chichꞌic onox castico cꞌalal xlaj li balamile. Jaꞌ chichꞌic o castico ti mu xchꞌunic li cꞌusi chcalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Muc bu jyulesoj ta jol jtuc li cꞌusitic chacalbeique. Jaꞌ yalojbon ti Jtote, yuꞌun jaꞌ listac tal. Jaꞌ liyalbe li cꞌusitic chacalbeique xchiꞌuc ti cꞌu xꞌelan chitacꞌave. ");
INSERT INTO tzoZNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jaꞌ ta smantal ti chacuxiic ta sbatel osil ti mi chachꞌunique. Li cꞌusitic chacalbeique jaꞌ yaloj ti Jtote. Naca noꞌox chcal avaꞌiic ti cꞌusitic yalojbone ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ti cꞌalal poꞌot xaꞌox sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, snaꞌoj xa ti Jesuse ti ista xa yora tscomtsan li balamile, ti chchaꞌsut xa echꞌel ta vinajel yoꞌ bu ti Stote. Ti Jesuse scꞌanojoticotic onox voꞌoticotic ti yajchancꞌopoticotique. Pero más to iyacꞌ quilticotic ti scꞌanojoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ti cꞌalal yolel chiveꞌoticotic xchiꞌuc ti Jesuse, ti Judas screm Simón Iscariotee yulesbil xaꞌox ta sjol yuꞌun ti pucuje ti jaꞌ chacꞌ entrucal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","4","Ti Jesuse, acꞌu mi snaꞌoj ti jaꞌ acꞌbil scuentain scotol yuꞌun ti Jtotic Rioxe, ti jaꞌ tacbil tal yuꞌun ti Rioxe, ti ch-iqꞌue sutele, iscoꞌoltas sba chac cꞌu chaꞌal mozoil. Ivaꞌi, islocꞌ spimilcꞌuꞌ, ixchꞌic ta xchꞌut jlic toalla. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Isqꞌueb voꞌ ta pocobcꞌobol, jaꞌ ispoc o li cocticotique. Cꞌalal laj spocboticotique, liscusboticotic ta toalla ti xchꞌicoj ta xchꞌute. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ti cꞌalal chpocbat xaꞌox yoc ti Simon Pedroe ―Cajval, maꞌuc yech smelol ti voꞌot chapoc li coque ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","―Li cꞌusi ta jpase mu xanaꞌbe smelol lavie. Tsꞌacal to chul ta ajol ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―Li voꞌone mu xcacꞌ apoc li coque ―xi ti Pedroe. ―Ti mi muc bu chajpoque, mu xuꞌ chba achiꞌinon ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","―Cajval, maꞌuc noꞌox xapoc li coque cheꞌe. Poco li jcꞌob uque, tsebiltason noxtoc ―xut ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","―Ti muchꞌu atinem xa onoxe mu xa persauc xichꞌ atintasel sjunlej. Xuꞌ ti yoc xa noꞌox xichꞌ pocbele yuꞌun atinem xa onox. Li voꞌoxuque lec xa lavoꞌonique pero mu acotolicuc ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Snaꞌoj xa ti Jesuse ti jaꞌ ch-acꞌon o entrucal yuꞌun ti Judase, yechꞌo ti iyal ti mu jcotolticoticuc ti lec li coꞌonticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ti cꞌalal laj spoc li cocticotique, ixchaꞌlap ti spimilcꞌuꞌe, ichoti ta mexa noxtoc. Jaꞌ yech lic yalboticotic: ―¿Mi xanaꞌic cꞌusi smelol ti ijpoc lavoquique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Li voꞌoxuque “Jchanubtasvanej, Cajval”, xavuticon. Lec ti yech chavalique. Ta melel ti voꞌon Avajvalicone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Acꞌu mi voꞌon Avajvalicon, acꞌu mi Avajchanubtasvanejicon, pero ijpoc lavoquique. Jaꞌ me yech xapasic uc. Mu me xatoy abaic, coltao me abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ti xꞌelan lacacꞌbe avilique, jaꞌ ta jcꞌan ti yech chapasic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta melel chacalbeic, li muchꞌu ch-abtej noꞌoxe mu tsotsuc yabtel; jaꞌ tsots yabtel li yajval abtele. Li muchꞌu mantal noꞌox ta xchꞌune mu tsotsuc yabtel; jaꞌ tsots yabtel li muchꞌu tspasvan ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Avaꞌiic xa. Mi yech chapasique, jun avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mu acotolicuc ti xꞌelan chacalbeique. Voꞌon ti lajtꞌujique, yuꞌun quiloj cꞌu xꞌelan avoꞌonic. Oy junoxuc ti chacrontainicone jaꞌ yoꞌ xcꞌot o chac cꞌu chaꞌal tsꞌibabil jcꞌoplal ta scꞌop Rioxe: “Ti muchꞌu coꞌol chiveꞌ jchiꞌuque jaꞌ chiscrontain”, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ti baꞌyi lacalbeic chac taje, jaꞌ yoꞌ mu xavicta o abaic ta xchꞌunel ti liquemon tal ta vinajele ti cꞌalal chavilic chcꞌot yeche. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ta melel chacalbeic, ti muchꞌutic ta xchꞌunic ti cꞌusi chavalic aꞌyuque, voꞌoxuc ti chajtaquic echꞌele, coꞌol xchiꞌuc voꞌon chixchꞌunbeic yaꞌel. Jaꞌ noꞌox yech chchꞌunbeic yaꞌel ti Jtot uque, yuꞌun jaꞌ listac tal ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ti cꞌalal laj yal chac taje, iꞌoch ta at-oꞌon. Jaꞌ yech lic yalboticotic: ―Ta melel chacalbeic, oy junoxuc ti chavaqꞌuicon entrucale ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Li voꞌoticotique jqꞌuelqꞌuelbe jba jsaticotic yuꞌun mu jnaꞌticotic muchꞌu junucal ti yech tspase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Voꞌon ti más scꞌanojon icaꞌi ti Jesuse, tey tsꞌeel chiveꞌ ta xocon. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ti Simon Pedroe liyacꞌbe seña ta scꞌob ti acꞌu jacꞌbe ti Jesuse ti muchꞌu junucal ti yech tspase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yuꞌun ti tey tsꞌeelon ta xocon ti Jesuse, ijacꞌbe: ―Cajval, ¿muchꞌu li chavale? ―xcut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","―Jaꞌ li muchꞌu ta jtsꞌajbe pan sveꞌe ―xiyut. Istsꞌaj jsetꞌ pan, jaꞌ iyacꞌbe ti Judas screm Simón Iscariotee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cꞌalal isveꞌ pan ti Judase, jaꞌo ixchꞌunbe smantal ti Satanase. ―Ti cꞌusi avaloj chapase, ba paso ta ora ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ti jayvoꞌ chololoticotic ta mexae, mi jaꞌuc jun muc xul ta jolticotic cꞌu yuꞌun ti xꞌelan iyalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yuꞌun jaꞌ xchabioj yav jtaqꞌuinticotic ti Judase, jlom ijnopticotic ti albil xa yuꞌun ti Jesuse ti oy cꞌusi chba sman tal ti chtun cuꞌunticotic ta qꞌuine. Jlom ijnopticotic ti albil xa yuꞌun ti Jesuse ti oy cꞌusi chba yacꞌbe li meꞌonetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cꞌalal laj sveꞌ pan ti Judase, jaꞌo ilocꞌ echꞌel. Icꞌ xaꞌox osil ti cꞌalal ilocꞌ echꞌele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Cꞌalal ibat xaꞌox ti Judase, ti Jesuse jaꞌ yech lic yalboticotic: ―Ista xa yora chiyacꞌ ta ichꞌel ta mucꞌ ti Rioxe, voꞌon ti coꞌol crixchanootique. Jaꞌ noꞌox yech chcacꞌ ta ichꞌel ta mucꞌ uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ti chcacꞌ ta ichꞌel ta muqꞌue, chiyacꞌ xa noꞌox ta ichꞌel ta mucꞌ uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jchꞌamaltac, mu xa bu jal liꞌ chajchiꞌinique. Chasaꞌicon. Jaꞌ chac cꞌu chaꞌal icalbe li jchiꞌiltactique, jaꞌ noꞌox yech chacalbeic uc. Ti bu chibate, mu to xuꞌ chabatic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chacalbeic achꞌ mantal, cꞌano me abaic. Jaꞌ me yech xacꞌan abaic chac cꞌu chaꞌal jcꞌanojoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mi acꞌanoj abaique, jaꞌ chil o scotol crixchanoetic ti achꞌunojic ti cꞌusi lacalbeique ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","―Cajval, ¿bu chabat? ―xi ti Simon Pedroe. ―Ti bu chibate mu to xuꞌ xachiꞌinon echꞌel lavie. Tsꞌacal to chabat ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","―Cajval, ¿cꞌu yuꞌun ti mu to xuꞌ xajchiꞌin echꞌel lavie? Mu xixiꞌ mi chismilic uque ―xi ti Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","―Yech chanop ti mu xaxiꞌe. Ta melel chacalbe, lavi ta acꞌubaltique ti cꞌalal mu toꞌox ch-ocꞌ queleme, oxꞌechꞌel xaꞌox aval ti mu xavojtiquinone ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ti Jesuse jaꞌ yech lic yalboticotic voꞌoticotic ti yajchancꞌopoticotique: ―Mu me xavat avoꞌonic. Chꞌunic me ti chascoltaic ti Jtote. Chꞌunic ti chajcoltaic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mucꞌ tajmec sna ti Jtote, oy jaycꞌol. Ti manchuc muqꞌue, maꞌuc yech chacalbeic ti yechuque. Yechꞌo un baꞌyi chba jtꞌuj ti bu chacꞌotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tsꞌacal to chtal quicꞌoxuc. Tey chachiꞌinicon o ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Anaꞌojic xa ti bu chibate. Anaꞌojic xa ti xuꞌ tey chabatic uque ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","―Cajval, mu jnaꞌticotic bu chabat. ¿Cꞌuxi ta jnaꞌticotic bu xbat sbelel? ―xi ti Tomase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","―Voꞌon chaquiqꞌuic echꞌel yoꞌ bu ti Jtotic Riox ta vinajele yuꞌun xcojtiquin. Ti cꞌu xꞌelan lacalbeique, yech. Voꞌon chcacꞌ acuxlejalic ta sbatel osil. Voꞌon noꞌox xuꞌ chaquiqꞌuic echꞌel yoꞌ bu ti Jtotic Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mi achꞌunojic ti ta vinajel liquemon tale, jaꞌ noꞌox yech achꞌunojic ti jaꞌ Jtot ti Rioxe. Poꞌot xa xachꞌunic ti jaꞌ Jtote xchiꞌuc ti voꞌne xa lic avilic tal yaꞌele ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","―Cajval, acꞌbon cojtiquinticotic ti Jtotic Riox ta vinajele yoꞌ jun o coꞌonticotique ―xi ti Felipe uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Itacꞌav ti Jesuse: ―Jal xa lajchiꞌinic. Li voꞌote, Felipe, ¿mi yilel to mu xachꞌun yaꞌel ti ta vinajel liquemon tale? Ti muchꞌutic liyilic xae, coꞌol xchiꞌuc iyilic xa yaꞌel ti Jtotic Riox uque. ¿Cꞌu yuꞌun ti xꞌelan chavale ti chacꞌan chavojtiquin ti Jtotic Rioxe? ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mi yilel to mu xachꞌun yaꞌel ti junoticotic xchiꞌuc ti Jtotic Rioxe? Li cꞌusitic chacalbeique, muc bu jyulesoj ta jol jtuc, jaꞌ yaloj ti Jtotic Rioxe. Ti chcacꞌ iluc li jlequilal jyuꞌelale, jaꞌ chvinaj o ti junoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chꞌunic me ti junoticotic xchiꞌuc ti Jtote. Mi mu xachꞌunic o li cꞌusi chacalbeique, jaꞌ chꞌunic o ti icacꞌ iluc li jlequilal jyuꞌelale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ta melel chacalbeic, mi chachꞌunic ti junoticotic xchiꞌuc ti Jtotic Rioxe, xuꞌ chavaqꞌuic iluc slequilal syuꞌelal Riox chac cꞌu chaꞌal ta jpase. Más to ep chlic yichꞌicon ta mucꞌ crixchanoetic avuꞌunic ti cꞌalal teyon xaꞌox xchiꞌuc ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mi jaꞌ chacꞌanbeic ti Jtotic Rioxe ti cꞌusitic tscꞌan coꞌone, chacacꞌbeic yoꞌ xcacꞌ o ta ichꞌel ta mucꞌ, voꞌon li Xchꞌamalone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mi jaꞌ chacꞌanbeic li cꞌusi tscꞌan coꞌone, chacacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Mi acꞌanojicone, chachꞌunic li cꞌusitic chacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chcalbe ti Jtote ti acꞌu stac tal xchiꞌinoxuc otro jun ti chtal scoltaoxuque. Chaxchiꞌinic ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jaꞌ ti Chꞌul Espíritue. Ti cꞌusi chasyulesbe ta ajolique naca yech. Ti muchꞌutic mu xiyichꞌic ta muqꞌue mu xꞌacꞌbatic ti Chꞌul Espíritue, jaꞌ ti mu xchꞌunic ti oye, mu snaꞌic cꞌu xꞌelan chpꞌijubtasvan. Yan li voꞌoxuque avaꞌiic xa cꞌu xꞌelan chpꞌijubtasvan. Jujuntal chtal xchiꞌinoxuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mu xajcomtsanic o, chtal jchiꞌinoxuc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Li crixchanoetic liꞌ ta sba balamile mu xa bu jal chiyilic. Mi lichame, mu xa bu chiyilic o. Li voꞌoxuque ta to xavilicon. Yuꞌun ti cuxulon ta sbatel osile, jaꞌ noꞌox yech chcacꞌ acuxlejalic ta sbatel osil uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ti cꞌalal chtal xchiꞌinoxuc ti Chꞌul Espíritue, jaꞌ chasyulesbe ta ajolic ti junoticotic xchiꞌuc ti Jtote. Jaꞌ chasyulesbe ta ajolic noxtoc ti avichꞌojicon ta muqꞌue. Jaꞌ chasyulesbe ta ajolic noxtoc ti liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mi chachꞌunic li cꞌusi chacalbeique, yuꞌun acꞌanojicon. Mi acꞌanojicone, jaꞌ noꞌox yech scꞌanojoxuc ti Jtot uque. Jcꞌanojoxuc uc. Más to chcacꞌ avilic cꞌu xꞌelan li coꞌone ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Lic sjacꞌ ti Judase, maꞌuc ti Judas Iscariotee, jaꞌ ti jun o Judase: ―Cajval, ¿cꞌu yuꞌun ti jtucticotic noꞌox chavacꞌ quilticotic cꞌu xꞌelan lavoꞌone? ¿Cꞌu yuꞌun ti mu xavacꞌbe yil scotol li crixchanoetique? ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Itacꞌav ti Jesuse: ―Ti muchꞌutic scꞌanojicone ta xchꞌunic li cꞌusitic chcalbeique. Cꞌanbilic yuꞌun ti Jtot uque. Chtal jchiꞌinticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ti muchꞌutic mu xiscꞌanique, mu xchꞌunic li cꞌusitic chcalbeique. Muc bu jyulesoj ta jol jtuc li cꞌusitic chacalbeique; jaꞌ yaloj ti Jtote yuꞌun jaꞌ listac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Lavi mu to chibate, lacalbeic xa scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ti Jtote icalbe xa ti acꞌu stac tal xchiꞌinoxuc ti Chꞌul Espíritue ti cꞌalal xibate. Chaxchanubtasic, ta syules ta ajolic scotol ti cꞌusitic lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ta jpas ta jun avoꞌonic. Yuꞌun jaꞌ ta jcꞌan ti jun avoꞌonic chac cꞌu chaꞌal jun coꞌone. Li cꞌusitic oy liꞌ ta sba balamile mu onox xata o jun avoꞌonic. Mu me xavat o avoꞌonic ti chibate. Mu me xaxiꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Lacalbeic xa ti chibate. Lacalbeic xa noxtoc ti chtal jchiꞌinoxuque. Ti acꞌanojiconuque, xamuyubajic xa ti yechuque yuꞌun lacalbeic xa ti chisut echꞌel, chba jta ti Jtote. Lavi liꞌon to ta sba balamile mu tsotsuc jyuꞌel chac cꞌu chaꞌal syuꞌel ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lavi mu to chibate, jaꞌ yech lacalbeic yoꞌ mu xavicta o abaic ta yichꞌelon ta mucꞌ ti cꞌalal xibate. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mu xa bu jal chajcꞌoponic yuꞌun poꞌot xa xtal yilbajinon ti muchꞌu liꞌ tspas mantal ta sba balamile, jaꞌ ti pucuje. Pero mu cꞌu xuꞌ xixchaꞌle. ");
INSERT INTO tzoZNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jaꞌ noꞌox ta jchꞌun ti cꞌusi yalojbon ti Jtote. Jaꞌ chul o ta sjol scotol crixchanoetic ti jcꞌanoj ti Jtote. Batic xa ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ti Jesuse jaꞌ yech lic yalboticotic voꞌoticotic ti yajchancꞌopoticotique: ―Mi chacꞌan chatunic cuꞌune, jaꞌ tscꞌan ti yechoxuc chac cꞌu chaꞌal scꞌobcꞌobtac li uvae ti tsacal ta smucꞌule. Voꞌon li smucꞌulon yaꞌele. Ti Jtote jaꞌ jchabiejꞌuva yaꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Voꞌoxuc scꞌobtacoxuc yaꞌel. Ti muchꞌutic chaꞌiic li cꞌusi chcale, mi mu spasic cꞌusi tscꞌan ti Jtote, coꞌolic xchiꞌuc cꞌob uva ti mu satine. Mi mu satin li cꞌob uvae, li jchabiejꞌuvae ta sboj loqꞌuel. Jaꞌ noꞌox yech uc ti muchꞌutic mu spasic cꞌusi tscꞌan ti Jtote, mu xcꞌaneic yuꞌun ti Jtote. Ti muchꞌutic chaꞌiic li cꞌusi chcale, mi jaꞌ tspasic cꞌusi tscꞌan ti Jtote, ta xcoltaatic ta yictael ti cꞌusi mu scꞌane chac cꞌu chaꞌal ta xchꞌulbe scꞌob uva li jchabiejꞌuvae yoꞌ satin o mase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Li voꞌoxuque lec xa avoꞌonic yuꞌun achꞌunic xa ti cꞌusitic lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jꞌechꞌel me xavichꞌicon ta mucꞌ yoꞌ xajcoltaic oe. Ti manchuc tsacal ta smucꞌul li scꞌobcꞌobtac uvae, mu satin. Jaꞌ noꞌox yechoxuc uc, mu cꞌusi lec spas avuꞌunic mi mu xavichꞌicon ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Voꞌon li smucꞌulon yaꞌele. Voꞌoxuc scꞌobtacoxuc yaꞌel. Mi chavichꞌicon ta muqꞌue, chajcoltaic ta spasel cꞌusi tscꞌan ti Jtote. Mi mu xajcoltaique, mu spas avuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ti muchꞌutic mu jꞌechꞌeluc chiyichꞌic ta muqꞌue, coꞌolic xchiꞌuc cꞌob uva ti mu satine, chichꞌ bojel, chtaquij. Tsꞌacal to chichꞌ tsobel, chichꞌ chiqꞌuel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mi jꞌechꞌel chavichꞌicon ta muqꞌue, mi jꞌechꞌel chachꞌunic li cꞌusitic chacalbeique, xuꞌ xacꞌanbeic Riox ti cꞌusitic chacꞌanique, chayacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi jaꞌ chapasic cꞌusi tscꞌan ti Jtote, jaꞌ ch-ichꞌe o ta mucꞌ. Jaꞌ chvinaj o ti achꞌunojic ti cꞌusitic lacalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jcꞌanojoxuc chac cꞌu chaꞌal scꞌanojon ti Jtote. Pasic me li cꞌusitic chacalbeique yoꞌ xanaꞌic o ti jcꞌanojoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Li voꞌone ta jchꞌun scotol ti cꞌusitic chiyalbe ti Jtote yechꞌo un jnaꞌoj ti scꞌanojone. Jaꞌ noꞌox yech mi chachꞌunic scotol li cꞌusitic chacalbeique, jaꞌ chanaꞌic o ti jcꞌanojoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ti ical ti jꞌechꞌel chavichꞌicon ta muqꞌue, jaꞌ yoꞌ jun o avoꞌonic chac cꞌu chaꞌal jun coꞌone, yoꞌ jun o avoꞌonic scotol cꞌacꞌale, mu xa cꞌusi xloꞌilaj o avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Li mantal chacalbeique, cꞌano me abaic chac cꞌu chaꞌal jcꞌanojoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ti muchꞌu tspoj li xchiꞌile, ti muc ta alel yuꞌun mi jaꞌ tey ilaj li stuque, jaꞌ chvinaj o ti scꞌanoj tajmeque. Jaꞌ yech jcꞌanojoxuc. Jaꞌ tscꞌan ti jaꞌ yechoxuc uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mi chapasic li cꞌusitic chacalbeique, coꞌol joltic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yuꞌun lacalbeic xa scotol ti cꞌusitic yalojbon ti Jtote, yechꞌo ti mu xa jꞌabtelicoxuc chcaꞌie. Ti muchꞌu jꞌabtel noꞌoxe mu xꞌalbat ti cꞌusi tsnop li yajvale. Yan li voꞌone lacalbeic xa scotol, jaꞌ ti coꞌol joltique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mu voꞌoticoxuc atꞌujicon, voꞌon lajtꞌujic yuꞌun chatunic cuꞌun. Mu yechuc noꞌox ti chatunic cuꞌune, yuꞌun ti muchꞌutic ta xchꞌun avuꞌunique ta xcuxiic ta sbatel osil. Mi jaꞌ chacꞌanbeic Jtotic Riox li cꞌusitic tscꞌan coꞌone, chayacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Li mantal chacalbeique: Cꞌano me abaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Mi chopol chayilic li crixchanoetique, mu me xavicta o abaic. Naꞌic me ti chopol liyilic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ti chopluc to cꞌusi chapasic chac cꞌu chaꞌal tspasique, lec chayilic ti yechuque. Yan lavie maꞌuc xa yech chapasic, jaꞌ ti laquiqꞌuic xae, yechꞌo ti chopol chayilique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Naꞌic me ti jaꞌ onox yech lacalbeique: “Li muchꞌu ch-abtej noꞌoxe mu tsotsuc yabtel; jaꞌ tsots yabtel li yajval abtele”, xacutic. Liyilbajinic li voꞌone, jaꞌ noꞌox yech chayilbajinic uc. Muc xichꞌic ta mucꞌ ti cꞌusitic icale, jaꞌ noꞌox yech mu xichꞌic ta mucꞌ li cꞌusitic chavalic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jaꞌ yech chachaꞌleatic ti avichꞌojicon ta muqꞌue yuꞌun mu to chichꞌic ta mucꞌ ti Jtote, jaꞌ ti listac tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ti manchuc tal jcꞌopon li crixchanoetique, muc xvinaj ti oy smulic ti yechuque. Lavie mu xuꞌ chalic ti chꞌabal smulique yuꞌun chopol chiyilic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ti muchꞌutic chopol chiyilique, coꞌol xchiꞌuc chopol chilic yaꞌel ti Jtot uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ti manchuc icacꞌbe yilic li jlequilal jyuꞌelale ti muc muchꞌu xuꞌ tspas yeche, muc xvinaj ti oy smulic ti yechuque. Pero lavie mu xuꞌ chalic ti chꞌabal smulique yuꞌun chopol iyilic ti cꞌusitic ijpasticotic xchiꞌuc ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ti chopol chiyilique, jaꞌ icꞌot ti yech onox tsꞌibabil jcꞌoplal ta scꞌop Riox ti tey yichꞌojique: “Yech noꞌox ti chopol chiyilique, chꞌabal jmul”, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ti cꞌalal xtal xchiꞌinoxuc ti Chꞌul Espíritu ta jtac tale, jaꞌ chasyulesbe ta ajolic ti cꞌusitic ijpase xchiꞌuc ti cꞌusitic ical aꞌyuque. Naca yech ti cꞌusitic chasyulesbe ta ajolique yuꞌun tey chlic tal yoꞌ bu ti Jtote. ");
INSERT INTO tzoZNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Li voꞌoxuc uque chavalic aꞌyuc ti cꞌusitic ijpase xchiꞌuc ti cꞌusitic ical aꞌyuque yuꞌun teyoxuc ti cꞌalal lic jtambe spasele, ti cꞌalal lic jtambe yalel aꞌyuque. Liꞌoxuc to cꞌal tanae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ti lacalbeic ti chopol chayilic li crixchanoetique, jaꞌ yoꞌ mu xavicta o abaic ti cꞌalal mu xaꞌox bu liꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Li jchiꞌiltactic ta israelale mu xacꞌ ochanic ta bicꞌtal temploetic. Ta sta yora ti chasmilic jayvoꞌuque yuꞌun tsnopic ti jaꞌ yech tscꞌan ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ti chasmilique, yuꞌun muc bu yichꞌojic ta mucꞌ ti Jtotic Riox ta vinajele, muc bu yichꞌojicon ta mucꞌ uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ti lacalbeic ti chopol chayilic li crixchanoetique, ti cꞌalal xcꞌot yeche, chul ta ajolic ti jaꞌ onox yech lacalbeic comele. ’Ti cꞌalal laquiqꞌuique mu toꞌox bu yech lacalbeic, jaꞌ ti liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","’Chisut xa echꞌel, chba xa jta ti Jtote, jaꞌ ti listac tale. Ti xꞌelan lacalbeique, chavat o avoꞌonic, muꞌnuc chajacꞌbecon ti bu chibate. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta melel chacalbeic, voꞌoxuc acꞌuxubinelic ti chisut echꞌel ta vinajele. Yuꞌun mi mu xisute, mu xtal scoltaoxuc ti Chꞌul Espíritue. Cꞌalal xisut echꞌele, jaꞌ ta jtac tal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ti cꞌalal xtale, ta syulesbe ta sjol scotol crixchanoetic ti oy smulique. Ta syulesbe ta sjolic noxtoc ti chꞌabal jmul li voꞌone. Ta syulesbe ta sjolic noxtoc ti chichꞌic o castico yuꞌun li smulique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Li smul ti chyulesbat ta sjolique, jaꞌ ti mu xchꞌunic ti stacojon tal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chyulesbat ta sjolic noxtoc ti chꞌabal jmul li voꞌone yuꞌun chisut xa echꞌel yoꞌ bu ti Jtote. Mu xa bu chavilicon liꞌ ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Chyulesbat ta sjolic noxtoc ti chichꞌic o castico yuꞌun li smulique, jaꞌ ti yaloj onox ti Rioxe ti chichꞌ castico ta sbatel osil ti muchꞌu chꞌunbil smantal liꞌ ta sba balamile, jaꞌ ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Acꞌu mi oy to cꞌusi yan chacalbeic, pero mu xavaꞌibeic smelol lavie. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ti cꞌalal xtal ti Chꞌul Espíritue, ti naca yech ti cꞌusitic chasyulesbe ta ajolique, jaꞌ chasyulesbe ta ajolic scotol ti cꞌusitic yaloj ti Rioxe. Muc bu tsyules ta sjol stuc ti cꞌusitic chasyulesbe ta ajolique; naca jaꞌ ti cꞌusitic ch-albat yuꞌun ti Rioxe. Jaꞌ chasyulesbe ta ajolic scotol ti cꞌusitic ta to xtale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jaꞌ chiyacꞌ ta ichꞌel ta mucꞌ yuꞌun jaꞌ yabtel ti chasyulesbe ta ajolic ti cꞌusitic ijpase xchiꞌuc ti cꞌusitic ical aꞌyuque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mu jtucuc chiyacꞌ ta ichꞌel ta mucꞌ. Coꞌol chiyacꞌoticotic ta ichꞌel ta mucꞌ xchiꞌuc ti Jtote yuꞌun junoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mu xa bu jal liꞌ chavilicone. Oy jun chib cꞌacꞌal ti mu xavilicone. Tsꞌacal to chavilicon noxtoc. Más to tsꞌacal chibat yoꞌ bu ti Jtote ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","―¿Cꞌusi smelol taj xꞌelan chale: “Mu xa bu jal liꞌ chavilicone. Oy jun chib cꞌacꞌal ti mu xavilicone. Tsꞌacal to chavilicon noxtoc. Más to tsꞌacal chibat yoꞌ bu ti Jtote”, ti xiyutotique? ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Cꞌusi smelol ti “mu xa bu jal”, xie? Mu xcaꞌibetic smelol ti cꞌusi chale ―xcut jbaticotic chaꞌvoꞌ oxvoꞌ ti yajchancꞌopoticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ti Jesuse snaꞌoj onox ti coꞌonticoticuc jacꞌbeticotic cꞌusi smelole, jaꞌo liyalboticotic: ―Jnaꞌoj ti chajacꞌbe abaic cꞌusi smelol ti “mu xa bu jal liꞌ chavilicone. Oy jun chib cꞌacꞌal ti mu xavilicone. Tsꞌacal to chavilicon noxtoc”, ti xacutique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ta melel chacalbeic, li voꞌoxuque chaꞌoqꞌuic, chavat avoꞌonic. Yan ti muchꞌutic mu xiyichꞌic ta muqꞌue xmuyubajic ti chismilique. Li voꞌoxuque muc bu jal chavat avoꞌonic, tsꞌacal to jun xa avoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Anaꞌojic cꞌu xꞌelan ti cꞌalal chcol ta alajel li antse, oy svocol. Mi icole, ta xchꞌay ta sjol li svocole. Xmuyubaj xa ti cꞌalal spetoj xa li yole. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaꞌ yechoxuc uc, lavie ta to xavat avoꞌonic. Ti cꞌalal chavilic jsat noxtoque, xamuyubajic xa. Mu xa muchꞌu xuꞌ chayacꞌbeic at-oꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Cꞌalal chavilicon noxtoc chac cꞌu chaꞌal lacalbeique, mu cꞌusi chajacꞌbecon yuꞌun icꞌot xa ti cꞌusitic lacalbeique. Ta melel chacalbeic, mi jaꞌ chacꞌanbeic Jtotic Riox li cꞌusitic tscꞌan coꞌone, chayacꞌbeic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mu to bu acꞌanojbeic li cꞌusitic tscꞌan coꞌone. Cꞌanbeic, chayacꞌbeic yoꞌ jun o avoꞌonique, mu xa cꞌusi chacꞌanic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ti cꞌusitic lacalbeique oy bu ta loꞌil noꞌox. Pero ta sta yora ti jamal chacalbeic scꞌoplal ti Jtotic Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti cꞌalal chacalbeique, atuquic xa noꞌox chacꞌanbeic li cꞌusitic chacꞌanique yuꞌun anaꞌojic ti jaꞌ yech tscꞌan coꞌone. Mu xa persauc voꞌon jcꞌanbe li cꞌusitic chacꞌanique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yuꞌun scꞌanojoxuc ti Jtotic Rioxe. Ti scꞌanojoxuque, jaꞌ ti acꞌanojicone, xchiꞌuc ti achꞌunic xa noxtoc ti tey liquemon tal yoꞌ bu ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ta melel ti tey lilic tal ti cꞌalal lital liꞌ ta sba balamile. Ta jcomtsan xa li balamile, chisut xa muyel ta vinajel yoꞌ bu ti Jtotic Rioxe ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","―Lavie jamal avalboticotic, maꞌuc xa loꞌil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jnaꞌojticotic xa ti anaꞌoj scotole. Yuꞌun anaꞌoj ti oy cꞌusi coꞌonuc jacꞌboticotic ti cꞌalal mu toꞌox chajacꞌbeticotique. Yechꞌo un ta jchꞌunticotic ti tey liquemot tal yoꞌ bu ti Rioxe ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","―Lavie chavalic ti achꞌunojique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pero liꞌ xa ta jliquel chacomtsanicone, chachꞌac abaic echꞌel. Pero mu jtucuc chicom, liꞌ onox xchiꞌinojon ti Jtotic Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ti jaypꞌel lacalbeique, jaꞌ yoꞌ mu xavat o avoꞌonic ti cꞌalal chaꞌilbajinatic liꞌ ta sba balamile. Li voꞌone icuch xa cuꞌun scotol li cꞌusitic liꞌ ta sba balamile. Jaꞌ noꞌox yech chajcoltaic yoꞌ xcuch o avuꞌunic uque ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ti cꞌalal laj yalboticotic yech ti Jesuse, jaꞌo isqꞌuel vinajel, iscꞌopon Riox. ―Tot, ista xa yora chicham chac cꞌu chaꞌal avaloj onoxe. Acꞌon ta ichꞌel ta mucꞌ, voꞌon lachꞌamalone, yoꞌ xacacꞌ o ta ichꞌel ta mucꞌ uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Avacꞌbon xa entrucal scotol crixchanoetic ta sjunlej balamil yuꞌun chcacꞌbe scuxlejalic ta sbatel osil ti jayvoꞌ atꞌujoj chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ti chcuxiic ta sbatel osile, jaꞌ ti xchꞌunojic ti voꞌot Rioxote. Xchꞌunojic noxtoc ti voꞌot atacon tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Iyil xa li crixchanoetique ti voꞌot quichꞌojot ta muqꞌue. Lajebal xa cuꞌun ti cꞌusitic avacꞌoj jpase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tot, acꞌon xa ta ichꞌel ta mucꞌ tey ta vinajel noxtoc chac cꞌu chaꞌal ichꞌbilon toꞌox ta mucꞌ ti cꞌalal chꞌabal toꞌox li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Icacꞌbe xa yilic cꞌu xꞌelan avoꞌon li viniquetic liꞌi, jaꞌ ti avacꞌ yichꞌicon ta muqꞌue. Baꞌyi onox atꞌujoj ti chiyichꞌic ta muqꞌue, yechꞌo ti ixchꞌunic xa ti cꞌusitic avaloje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Snaꞌojic xa ti voꞌot acoltaon ta spasel ti cꞌusitic ijpase, ti voꞌot acoltaon ta yalel ti cꞌusitic icale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Icalbeic xa ti cꞌusitic avalbone. Ixchꞌunic xa ti tey liquemon tal ta vinajele, ti voꞌot atacon tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Maꞌuc ta scuenta scotol crixchanoetic chajcꞌopon. Jaꞌ noꞌox chajcꞌopon ta scuenta li muchꞌutic avacꞌ yichꞌicon ta muqꞌue yoꞌ xcuxiic o cuꞌun ta sbatel osile yuꞌun jaꞌ avuꞌun. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Scotol ti muchꞌutic avacꞌ yichꞌicon ta muqꞌue jaꞌ cuꞌun. Jaꞌ avuꞌun uc. Coꞌol cuꞌuntic. Jaꞌ chiyaqꞌuic ta ichꞌel ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Stuquic xa chcomic liꞌ ta balamile yuꞌun chisut xa muyel tal ta vinajel yuꞌun chtal jtaot. Tot, voꞌot ti chꞌabal amule, abulajan chabibon scotol li muchꞌutic avacꞌ yichꞌicon ta muqꞌue yoꞌ coꞌol o sjolic scotolic chac cꞌu chaꞌal coꞌol joltique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ti cꞌu sjalil ijchiꞌinic liꞌ ta sba balamil ti jayvoꞌ avacꞌ yichꞌicon ta muqꞌue, voꞌot ta ayuꞌel ti mu junuc ichꞌay cuꞌune. Lec ijchabi, liꞌ xchiꞌinojicon scotolique. Jaꞌ noꞌox ti june ti scꞌoplal onox ch-och ta cꞌocꞌ ta sbatel osile, mu xa bu liꞌi. Jaꞌ icꞌot ti cꞌusi tsꞌibabil ta acꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Tot, chtal xa jchiꞌinot. Lavi liꞌto jchiꞌuquic ta sba balamile chajcꞌopon ta scuenta ti jayvoꞌ avacꞌbone yoꞌ jun o yoꞌonic chac cꞌu chaꞌal jun coꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Icalbeic xa ti cꞌusitic avalbone, pero chopol ch-ileic yuꞌun ti muchꞌutic mu xiyichꞌic ta muqꞌue, jaꞌ ti mu coꞌoluc sjolic xchiꞌuc li crixchanoetique chac cꞌu chaꞌal mu coꞌoluc jol jchiꞌuc li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Maꞌuc chajcꞌopon o ti chavicꞌ ta orae; jaꞌ chacalbe ti chachabie yoꞌ mu xloꞌloatic o yuꞌun ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Maꞌuc xa yech yoꞌonic chac cꞌu chaꞌal yoꞌonic li yan crixchanoetique, yuꞌun maꞌuc yech coꞌon uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Acꞌu me xchꞌunic ti yech li cꞌusi chavale yoꞌ mu xloꞌloatic o chac cꞌu chaꞌal chloꞌloatic li yan crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ti atacon tal liꞌ ta sba balamile jaꞌ tal cal aꞌyuc ti cꞌusitic avaloje. Jaꞌ noꞌox yechon uc ta jtaquic echꞌel ta yalel aꞌyuc ti cꞌusitic caloje. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta sjunul coꞌon ta jpas li cꞌusi chacꞌane yechꞌo un sjunul yoꞌonic tspasic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Mu stuquicuc noꞌox cajchancꞌoptac chajcꞌopon o. Chajcꞌopon noxtoc ta scuenta ti muchꞌutic jaꞌto chlic yichꞌicon ta mucꞌ yuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chacalbe ti coꞌoluc me sjolic scotol ti muchꞌutic chiyichꞌic ta muqꞌue chac cꞌu chaꞌal coꞌol joltique, xchiꞌuc ti coꞌolajuc joltic jchiꞌuctique yoꞌ xchꞌunic o scotol crixchanoetic ti voꞌot atacon tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ta jlecubtasbe yoꞌonic chac cꞌu chaꞌal lec coꞌon avuꞌune yoꞌ xcoꞌolaj o sjolic chac cꞌu chaꞌal coꞌol joltique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Li voꞌone ta xcoꞌolaj jol xchiꞌuquic. Li voꞌotique coꞌol onox joltic. Jaꞌ noꞌox yech ta xcoꞌolaj sjolic uc yoꞌ xilic o scotol crixchanoetic ti voꞌot atacon tale, xchiꞌuc ti acꞌanoj scotol ti muchꞌutic coꞌol joltic jchiꞌuctique chac cꞌu chaꞌal acꞌanojone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tot, ti jayvoꞌ avacꞌ yichꞌicon ta muqꞌue, jaꞌ ta jcꞌan ti chixchiꞌinic ta sbatel osil yoꞌ bu nacalote yoꞌ xilic o ti cꞌu xꞌelan chavacꞌon ta ichꞌel ta muqꞌue. Yuꞌun acꞌanojon onox ti cꞌalal chꞌabal toꞌox li balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tot, li voꞌote lec cꞌusi chapas, muc bu chavacꞌ ochuc ta cꞌocꞌ ti muchꞌutic liyichꞌic xa ta muqꞌue. Li yan crixchanoetique muc bu yilojic cꞌu xꞌelan avoꞌon. Li voꞌone quiloj cꞌu xꞌelan avoꞌon. Li jayvoꞌ liꞌique ixchꞌunic xa ti voꞌot atacon tale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Icacꞌbe xa yilic cꞌu xꞌelan avoꞌon. Pero más to chilic cꞌu xꞌelan avoꞌon yoꞌ scꞌan o sbaic chac cꞌu chaꞌal acꞌanojone. Mi scꞌanoj sbaique, jaꞌ chvinaj o ti jchiꞌinojique ―xi ti cꞌalal iscꞌopon Riox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ti cꞌalal laj scꞌopon Riox ti Jesuse, lilocꞌoticotic echꞌel xchiꞌuc. Lijelavoticotic ta jech ucꞌum, Cedrón sbi. Tey licꞌototicotic yoꞌ bu tsꞌunbil olivotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ti Judase spasoj xa trate ti chacꞌ entrucal ti Jesuse. Yiloj li olivotic uque yuꞌun tey onox chicꞌotilanoticotic xchiꞌuc ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iyicꞌ echꞌel jayvoꞌ solteroetic, xchiꞌuc jayvoꞌ jchabiejtemplo, xchiꞌuc ti jfariseoetique. Ti cꞌalal ibatique, yichꞌoj echꞌel yespadaic, xchiꞌuc stojic, xchiꞌuc slamparaic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ti Jesuse snaꞌoj onox ti cꞌusitic ta xchaꞌleate, ba snup ti jtsacvanejetique. ―¿Muchꞌu chasaꞌic? ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","―Jaꞌ ta jsaꞌticotic ti Jesus Nazarete ―xiic. ―Voꞌon ―xꞌutatic yuꞌun ti Jesuse. Tey ti Judas uque, jaꞌ ti muchꞌu iyacꞌ entrucale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ti cꞌalal “voꞌon”, xi ti Jesuse, ti jtsacvanejetique valapat ibatic, ilomic ta lum. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","―¿Muchꞌu chasaꞌic? ―xꞌutatic noxtoc yuꞌun ti Jesuse. ―Jaꞌ ta jsaꞌticotic ti Jesus Nazarete ―xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","―Lacalbeic xa ti voꞌone. Mi jtuc noꞌox chasaꞌicone, acꞌu baticuc li jchiꞌiltac liꞌi ―xꞌutatic yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ti xꞌelan iyale, jaꞌ yoꞌ xcꞌot o ti cꞌusi iyalbe ti Stote: “Ti jayvoꞌ avacꞌ yichꞌicon ta muqꞌue, mi jun muc xchꞌay cuꞌun”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tey sjelpꞌunoj yespada ti Simon Pedroe. Ora isloqꞌues ta sna, istuchꞌbe jun xchiquin smozo ti más totil palee. Sbatsꞌichiquin istuchꞌbe. Malco sbi ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","―Ticꞌo ta sna lavespadae. Mu xapojon yuꞌun persa ta xcacꞌ jvocol chac cꞌu chaꞌal yaloj ti Jtote ―xꞌutat yuꞌun Jesús ti Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ti capitan solteroe, xchiꞌuc ti yajsolterotaque, xchiꞌuc scotol ti jchabiejtemploe, jaꞌ istsaquic ti Jesuse, ixchuquic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Baꞌyi iyiqꞌuic echꞌel ta sna ti Anase. Yuꞌun jaꞌ sniꞌmol ti Caifase. Ti Caifase jaꞌo sjabilal ochem ta más totil paleal ti cꞌalal icham ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jaꞌ ti Caifase ti iyalbe ti xchiꞌiltac ta meltsanejcꞌope: “Más lec mi jun noꞌox vinic chlaje; jaꞌ chopol mi lilajotic jcotoltique”, ti xi onoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Voꞌon li Juanone xchiꞌuc ti Simon Pedroe tijiloticotic echꞌel ta spat ti Jesuse. Li voꞌone xiyojtiquin ti totil pale Anase. Ti cꞌalal iꞌoch ta stiꞌ sbe totil pale ti Jesuse, tijil liꞌoch uc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ti Pedroe tey icom ta pat moc. Yuꞌun ti xiyojtiquin ti totil palee, ba jcꞌopon ti jchabiejtiꞌmoque ti acꞌu yotesel ta yut moc ti Pedro uque. Iꞌotesat yuꞌun ti tseb ti chchabi tiꞌmoque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","―¿Mi mu voꞌoticot yajchancꞌopot li vinique? ―xꞌutat yuꞌun jchabiejtiꞌmoc ti Pedroe. ―Mu voꞌonicon ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ti smozotac totil palee xchiꞌuc jayvoꞌ jchabiejtemplo stsoyoj scꞌoqꞌuic yuꞌun tol sic. Tey vaꞌajtic chcꞌatinic. Tey vaꞌal chcꞌatin ti Pedro uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","―¿Muchꞌutic lavajchancꞌoptaque? ¿Cꞌusitic chavacꞌ ta chanel? ―xꞌutat yuꞌun totil pale Anas ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","―Ta sat scotol crixchanoetic lichanubtasvan ta bicꞌtal temploetic xchiꞌuc ta tiꞌ mucꞌta templo yoꞌ bu ta stsob sbaic li jchiꞌiltactique. Mu ta mucluc lichanubtasvan. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Cꞌu yuꞌun ti chajacꞌbone? Ti yechuque, jaꞌ jacꞌbo ti muchꞌutic iyaꞌiic ti cꞌusitic icale yuꞌun snaꞌojic ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ora imaje yuꞌun jun jchabiejtemplo ti tey vaꞌal ta stsꞌele. ―¿Cꞌu yuꞌun ti xꞌelan chatacꞌbe li totil palee? ―xꞌutat yuꞌun jchabiejtemplo ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","―Mi chopol ti cꞌusi icale, albon caꞌi ti cꞌusi chopol ical avaꞌie. Ti mi lec ti cꞌusi icale, ¿cꞌu yuꞌun ti amajone? ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ti Anase iyal ti acꞌu chucbatuc scꞌob ti Jesuse. Istacbe echꞌel ti totil pale Caifase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti cꞌalal tey toꞌox ta yut na ti Jesuse, ti Pedroe tey vaꞌal chcꞌatin ta pana. ―¿Mi mu voꞌoticot yajchancꞌopot li vinique? ―xꞌutat yuꞌun ti muchꞌutic tey coꞌol chcꞌatin xchiꞌuque. ―Mu voꞌonicon ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tey jun smozo ti totil pale Anase. Jaꞌ xchiꞌil ti muchꞌu ituchꞌbat xchiquine. ―¿Mi mu voꞌoticot ti laquil ta olivotic xchiꞌuc li vinique? ―xꞌutat yuꞌun ti mozoile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","―Mu voꞌonicon ―xi noxtoc ti Pedroe. Jaꞌo xa iꞌocꞌ quelem. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ti Jesuse iyiqꞌuic loqꞌuel ta sna ti Caifase, iyiqꞌuic echꞌel ta spalacio covierno. Naca toꞌox sacjaman ti cꞌalal icꞌotique. Ti paleetique xchiꞌuc ti xchiꞌiltaque muc xꞌochic ta opisina yuꞌun xchꞌunojic ti ta sta o smulic ta stojol Riox mi tscap sbaic xchiꞌuc ti muchꞌutic nom liquemic tale. Mi iscap sbaique, mu xuꞌ stiꞌic chij ta sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yechꞌo un ilocꞌ tal ta yopisina ti covierno Pilatoe. ―¿Cꞌusi smul avuꞌunic li vinic aviqꞌuic tale? ―xꞌutatic yuꞌun Pilato ti cajmeltsanejcꞌopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","―Ti chꞌabluc smule, muc xquicꞌticotic tal ti yechuque ―xutic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","―Iqꞌuic echꞌel, ba meltsanbeic scꞌoplal ta aley atuquic ―xꞌutatic yuꞌun ti Pilatoe. ―Li voꞌoticotique muc bu avalojboticotic mantal ti xuꞌ ximilvanoticotique. Voꞌot ti cꞌu xachie yuꞌun jaꞌ avabtel ―xutic Pilato ti cajmeltsanejcꞌopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ti iꞌoch ta scꞌob Pilato ti Jesuse, jaꞌ icꞌot ti iyal ti ta cruz ta xchame. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ti Pilatoe iꞌoch ta yopisina, iyicꞌ ochel ti Jesuse. ―¿Mi yech ti voꞌot chapas ta mantal lachiꞌiltac ta jurioale? ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","―¿Mi atuc noꞌox anop taje, o mi oy muchꞌu layalbe? ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","―Li voꞌone maꞌuc jurioon, mu cꞌu jcuenta o. Jaꞌ layicꞌ tal lachiꞌiltaque xchiꞌuc li totil paleetique. ¿Cꞌusi amul? ―xꞌutat yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","―Ti muchu liyalbe ta jpas mantale, maꞌuc crixchano. Ti crixchanouc liyalbee, lispoj li jvinictaque, muc xiꞌaqꞌue entrucal ta scꞌob cajmeltsanejcꞌopticotic ti yechuque, muc xiyiqꞌuic tal ti yechuque. Pero maꞌuc crixchano liyalbe ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","―Yuꞌun voꞌot chapas mantal cheꞌe ―xꞌutat yuꞌun ti Pilatoe. ―Voꞌon. Ti tal ayancon liꞌ ta sba balamile, jaꞌ tal cal li cꞌusitic yeche. Scotol ti muchꞌutic tscꞌan chaꞌiic li cꞌusitic yeche, jaꞌ chaꞌiic li cꞌusitic chcale ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","―¡Liꞌtoe mu cꞌusi yech! ―xi ti Pilatoe. Cꞌalal laj yal chac taje, ilocꞌ noxtoc ti Pilatoe, ba scꞌopon ti cajmeltsanejcꞌopticotique. ―Chꞌabal smul chcaꞌi li voꞌone. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yuꞌun ti nopem xavaꞌiic ti chajloqꞌuesbeic ta chuquel jun achiꞌilic ta sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi atot ameꞌique, ¿mi jaꞌ chajcoltabeic liꞌi ti chal ti jaꞌ chaspasic ta mantale? ―xut. ");
INSERT INTO tzoZNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jaꞌo xꞌavlajetic xa liquel scotolic noxtoc: ―¡Leꞌe, mu me xacolta! ¡Jaꞌ loqꞌueso li Barrabase! ―xiic. Ti Barrabase jꞌelecꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ti Pilatoe iyal ti acꞌu yacꞌbel arsial ti Jesuse. Iꞌacꞌbat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ti solteroetique ixotic chꞌix, ixojbeic ta sjol ti Jesuse. Jaꞌ la scorona ti ta alele. Islambeic natil cꞌuꞌul, morado. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","―¡Yajpasvanejot ta mantal yilel achiꞌiltac caꞌuctic! ―xutic. Ismajbeic sat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ilocꞌ noxtoc ti Pilatoe. ―Yoꞌ xavilic o ti muc bu ijtabe smule, chquicꞌ loqꞌuel tal ―xut ti jchiꞌiltaque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Cꞌalal ilocꞌ tal ti Jesuse, slapoj xaꞌox ti xotbil chꞌixe, scꞌuꞌunoj xaꞌox ti morado cꞌuꞌule. ―¡Qꞌuelavilic lachiꞌilique! ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cꞌalal iyilic ti totil paleetique xchiꞌuc ti jchabiejtemploe, xꞌavlajetic xa tajmec: ―¡Chamuc ta cruz! ¡Chamuc ta cruz! ―xiic. ―Ba milic ta cruz voꞌoxuc cheꞌe. Li voꞌone chꞌabal smul chcaꞌi ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","―Ti muchꞌu tspꞌis sba ta Xchꞌamal Rioxe persa chichꞌ milel yuꞌun jaꞌ yech chal li jleyticotique ―xiic ti cajmeltsanejcꞌopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cꞌalal iyaꞌi ti Pilatoe ti “tspꞌis sba ta Xchꞌamal Riox” xiique, más to ixiꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iꞌochic noxtoc ta yut opisina xchiꞌuc ti Jesuse. ―¿Bu liquemot tal cheꞌe? ―xut. Ti Jesuse muc xtacꞌav. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","―¿Cꞌu yuꞌun ti mu xatacꞌbone? ¿Mi mu xanaꞌ ti oy cabtele? Xuꞌ chacacꞌ ta milel ta cruz, xuꞌ chajcolta ―xꞌutat yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","―Mu cꞌu xuꞌ xachaꞌleon; jaꞌ noꞌox ti cꞌusi chacꞌ apas ti Riox ta vinajele yuꞌun jaꞌ layacꞌbe lavabtele. Li voꞌote jutuc amul. Jaꞌ más tsots smul li totil palee ti liyicꞌ tale ―xi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cꞌalal iyaꞌi ti Pilatoe ti cꞌusi iyal ti Jesuse, isnop ox cꞌuxi tscolta. Pero ti jchiꞌiltaque xꞌavlajetic xa tajmec: ―Mi chacolta li vinic leꞌe, yuꞌun mu coꞌoluc ajol xchiꞌuc ti Césare. Ti muchꞌu tspꞌis sba ta preserentee, jaꞌ tscrontain ti Césare ―xutic ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cꞌalal iyaꞌi ti Pilatoe ti cꞌusi iyal ti jchiꞌiltaque, iyal ti acꞌu yiqꞌuel loqꞌuel ta pana ti Jesuse. Li tiꞌnae pasbil ta cemento. Tey pasbil ta cemento xchotleb ta oꞌlol tiꞌna ti coviernoe. Jaꞌo tey chba chotluc cꞌalal chal cꞌu xꞌelan chcom scꞌoplal ti muchꞌu tsmeltsanbe scꞌoplale. Gabata sbi ta ebreo cꞌope. Tey ba chotluc ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jaꞌo xa scꞌacꞌalil ta smilic chꞌiom chij ta stiꞌic ta sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique. Poꞌot xaꞌox ol cꞌacꞌal ti cꞌalal tey ba chotluc ti Pilatoe. ―¡Qꞌuelavilic li muchꞌu chaspasic ta mantale! ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Xꞌavlajetic xa liquel ti jchiꞌiltaque: ―¡Acꞌu chamuc! ¡Jipano ta cruz! ―xiic. ―¿Mi lec ti ta jipan ta cruz li muchꞌu chaspasic ta mantale? ―xꞌutatic yuꞌun ti Pilatoe. ―Maꞌuc chispasoticotic ta mantal leꞌe. Jun noꞌox ti muchꞌu chispasoticotic ta mantale, jaꞌ ti Césare ―xiic ti totil paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ti Pilatoe ixchꞌun ti cꞌusi iyalic ti jchiꞌiltaque. Iyal ti acꞌu ba sjipanel ta cruz ti Jesuse. Ti solteroetique iyiqꞌuic echꞌel ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ti Jesuse scuchoj echꞌel scruzal tey ibat yoꞌ bu Baquel Jol Anima sbi li balamile. Gólgota sbi ta ebreo cꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tey isjipanic ta cruz ti Jesuse. Isjipanic ta cruz chaꞌvoꞌ viniquetic uc. Ti scruzal Jesuse jaꞌ ta oꞌlol. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ti Pilatoe iyacꞌ ta tsꞌibael jpech tabla, isbajbeic ta sjol scruzal ti Jesuse. “Liꞌi jaꞌ Jesus Nazaret. Jaꞌ yajpasvanejic ta mantal li jurioetique”, xi tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ep jchiꞌilticotic isqꞌuelic ti cꞌusi yaloje, yuꞌun tey noꞌox ta tiꞌ Jerusalén ijipanat ta cruz ti Jesuse. Tsꞌibabil ta ebreo cꞌop, ta griego cꞌop, ta latin cꞌop. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ti totil paleetique, cꞌalal iyilic cꞌu xꞌelan tsꞌibabile, ora ba yalbeic ti Pilatoe: ―¿Cꞌu yuꞌun ti “jaꞌ yajpasvanejic ta mantal li jurioetique”, xi avacꞌoj ta tsꞌibaele? Ti yechuque, jaꞌ yech avacꞌ ta tsꞌibael chac liꞌi: “Jaꞌ ispꞌis sba ta yajpasvanejic ta mantal li jurioetique”, xi ti yechuque ―xiic ti totil paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","―Ti cꞌu xꞌelan icacꞌ ta tsꞌibaele, acꞌu comuc xa o yech ―xꞌutatic yuꞌun ti Pilatoe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cꞌalal laj xaꞌox sjipanic ta cruz Jesús ti chanvoꞌ solteroetique, ispasic ta chanchꞌac ti scꞌuꞌtac ti Jesuse. Juchꞌac iyichꞌic. Icom to jlic yuꞌun chꞌabal stsꞌis. Jlic noꞌox jalbil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","―Mu yaꞌuc jatic li jlic liꞌi. Jqꞌueltic muchꞌu chichꞌ, tajincotic ―xut sbaic ti solteroetique. Ti xꞌelan ispasic ti solteroetique, jaꞌ icꞌot ti cꞌusi tsꞌibabil ta scꞌop Rioxe. “Ta xchꞌacbe sbaic ti jcꞌuꞌtaque. Ta xtajinic, ta sqꞌuelic muchꞌu junucal chichꞌ ti jlic jcꞌuꞌe”, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ti smeꞌ Jesuse xchiꞌuc ti smuque, jaꞌ ti María sbi uque ti yajnil Cleofase, xchiꞌuc ti jun María liquem tal ta jteclum Magdalae, tey vaꞌajtic ta yoc scruzal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Voꞌon ti yajchancꞌopon Jesuse ti más scꞌanojon icaꞌie, tey jchiꞌinojbe ti smeꞌe. Cꞌalal liyiloticotic ti Jesuse ―Jaꞌ xa avol leꞌe ―xut ti smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","―Li jmeꞌe jaꞌ xa ameꞌ ―xiyut uc. Iquicꞌ echꞌel ta jna ti smeꞌ Jesuse. Tey lixchiꞌin o. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ti Jesuse snaꞌoj ti icꞌot xa scotol ti cꞌu xꞌelan tsꞌibabil scꞌoplal ta scꞌop Rioxe. Slajeb xa iyal chac liꞌi: ―Chtaquij xa jtiꞌ ―xi. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tey pachal jboch binagre. Istsꞌajic esponja, ixojic ta isopo teꞌ, isluchbeic muyel ta ye ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cꞌalal istsꞌutsꞌ ti Jesuse ―Itoj xa cuꞌun smul scotol li crixchanoetique ―xi. Isnijan sba, jaꞌo ilocꞌ xchꞌulel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Voꞌoticotic li juriooticotique jaꞌo xa scꞌacꞌalil ta jcuxticotic ta yocꞌomal. Ti cajmeltsanejcꞌopticotique mu scꞌanic ti tey jipajtic ta cruz chvay ti oxvoꞌe. Ti jchiꞌiltaque persa ta xchabiic li sávaro ta slajel sqꞌuinal ti cꞌalal iloqꞌuic ta mozoil ti baꞌyi jtot jmeꞌticotique, yechꞌo un ba yalbeic ti Pilatoe ti acꞌu scꞌasbel yoquic yoꞌ xchamic o ta orae. Mi ichamique, xuꞌ xa syalesic ta cruz. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ti solteroetique iꞌalbatic ti acꞌu ba scꞌasbeic yoctaque. Ti june iscꞌasbeic yoc. Tsꞌacal to iscꞌasbeic yoc ti otro june, jaꞌ ti muchꞌutic tey jipajtic ta cruz ta jujot xocon scruzal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ti Jesuse muc scꞌasbeic yoc yuꞌun chamem xa iyilic cꞌalal icꞌotic yoꞌ bu jipile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Acꞌu mi chamem xa iyilic ti Jesuse, ti jun solteroe ixenbe to lanza ta xocon. Ora ilocꞌ xchꞌichꞌel xchiꞌuc voꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Li voꞌone iquil cꞌu xꞌelan icham ti Jesuse. Li cꞌusi chacalbeique, yech, yuꞌun iquil scotol. Chꞌunic me uc ti jaꞌ istoj li jmultique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ti muc scꞌasbat yoque, jaꞌ icꞌot ti cꞌusi tsꞌibabil ta scꞌop Rioxe: “Mi jun sbaquel mu scꞌasbat”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tsꞌibabil noxtoc ta scꞌop Riox: “Chavilic ti muchꞌu ta xenbat xocon avuꞌunique”, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oy jun jchiꞌilticotic ta jurioal, José sbi. Liquem tal ta jteclum Arimatea. Mucul xchꞌunoj ti jaꞌ tꞌujbil yuꞌun Riox chispasoticotic ta mantal ti Jesuse, yuꞌun jaꞌ xiꞌem o ti xchiꞌiltac ta meltsanejcꞌope. Cꞌalal iyil ti icham ti Jesuse, ba scꞌopon ti Pilatoe, jaꞌ ba sjacꞌbe mi xuꞌ syales ta cruz ti ánima Jesuse. Ti Pilatoe iyacꞌ permiso ti xuꞌ syalese, ti acꞌu ba smuque. Isyales ti Josee. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ital ti Nicodemo uque, jaꞌ ti ay loꞌilajuc ta acꞌubaltic xchiꞌuc ti Jesuse. Yichꞌoj tal chaꞌtos xuchꞌal teꞌ, pero mu. Jaꞌ li mirrae xchiꞌuc li aloee. Oy nan treinta kilouc yalal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iscꞌamulanic ta saquil pocꞌ ti ánima Jesuse. Tey capal iscꞌamic ti mirrae xchiꞌuc ti aloee, jaꞌ yoꞌ mu xtuib oe. Yuꞌun jaꞌ yech jtalelticotic ti cꞌalal ta jmuc jbaticotic voꞌoticotic li juriooticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ti bu isjipanic ta cruz ti Jesuse, oy tey nopol tsꞌunbil olivotic. Oy tey chꞌojbil ton ta yut olivotic scuenta ánima. Achꞌ chꞌen to, mu to muchꞌu tey ticꞌbil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaꞌ tey ay stiqꞌuic ti Jesuse yuꞌun nopol noꞌox. Ti istiqꞌuic ta orae, yuꞌun jaꞌo xa ta jcuxticotic ta smalel cꞌacꞌal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sob ta rominco, jaꞌ li primero cꞌacꞌal xemanae, icꞌ toꞌox la ibat ta muquenal ti María liquem tal ta Magdalae. Ti cꞌalal icꞌote, iyil ti setetinbil xaꞌox la loqꞌuel li smac stiꞌil chꞌene. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Isut tal ta anil, tal yalboticotic, voꞌon xchiꞌuc ti Simon Pedroe, voꞌon ti más scꞌanojon icaꞌi ti Jesuse. ―Isloqꞌuesic xa ti Cajvaltique. Naꞌtic bu ay yaqꞌuic ―xiyutoticotic yulel. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ora libatoticotic ta muquenal xchiꞌuc ti Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Coꞌol anil libatoticotic. Li voꞌone lijelav echꞌel, baꞌyi licꞌot ta tiꞌ chꞌen. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ijnachꞌita ochel li yut chꞌene. Iquil ti tey losol ti saquil poqꞌue pero muc xiꞌoch. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ti cꞌalal icꞌot ti Simon Pedroe, ora iꞌoch. Iyil ti tey losol ti saquil pocꞌ cꞌambil o toꞌox ti ánima Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iyil ti tey balbil comel ti sutꞌobil sjole, pero slecoj xchiꞌuc ti scꞌamobile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Voꞌon ti baꞌyi licꞌote, tsꞌacal to liꞌoch ta yut chꞌen. Cꞌalal iquil cꞌu xꞌelan comem ti poqꞌuetique, ijchꞌun ti ichaꞌcuxi xa loqꞌuel ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mu toꞌox jnaꞌbeticotic smelol ti tsꞌibabil onox ta scꞌop Riox ti persa ta xchaꞌcuxi loqꞌuel ta smuquenal ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lisut ta jnaꞌticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ti Maríae tey icom ta tiꞌ chꞌen, choqꞌuita sba. Ti cꞌalal yolel ch-oqꞌue, isnachꞌita la ochel li yut chꞌene. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iyil la ti tey chotajtic chaꞌvoꞌ anjel ta vinajele, jun la ta sjol, jun la ta yoc ti yoꞌ bu telanbil toꞌox ti ánima Jesuse. Sac la ti scꞌuꞌique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","―Ants, ¿cꞌu yuꞌun ti chaꞌoqꞌue? ―xꞌutat la ti Maríae. ―Yuꞌun isloqꞌuesic xa ti Cajvale. Mu jnaꞌ bu ba yaqꞌuic ―xut la ti anjeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cꞌalal laj yal chac taje, isqꞌuel la spat. Iyil la ti tey vaꞌal jun vinique, pero muc la xojtiquin mi jaꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","―¿Cꞌu yuꞌun ti chaꞌoqꞌue? ¿Muchꞌu chasaꞌ? ―xꞌutat la yuꞌun ti Jesuse. Ti Maríae isnop la ti jaꞌ ti jchabiejtsꞌunubaltique. ―Totic, mi voꞌot aloqꞌues ti ánimae, albon caꞌi bu ay avacꞌ yuꞌun ta jcuch echꞌel ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","―¡María! ―xꞌutat la yuꞌun ti Jesuse. Ti Maríae ijoyij la, iscꞌopon la ta jcꞌopticotic, jaꞌ li ebreo cꞌope: ―¡Raboni! ―xut la. Li Rabonie “jchanubtasvanej”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","―Mu me xtal apicon yuꞌun chibat xa yoꞌ bu ti Jtote. Batan, ba albo yaꞌiic li jchiꞌiltaque, jaꞌ li muchꞌutic coꞌol quichꞌojtic ta mucꞌ ti Jtotic Riox jchiꞌuctique: “Jaꞌ yech iyal tal li Jesuse: Chibat xa yoꞌ bu ti Jtote, jaꞌ Atotic uc. Jaꞌ Cajval, jaꞌ Avajvalic uc, xi”, xavut me cꞌotel li yantique ―xꞌutat la yuꞌun Jesús ti Maríae. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ti María liquem tal ta Magdalae isut tal. ―Iquil xa ti Cajvaltic Jesuse ―xiyutoticotic yulel voꞌoticotic ti yajchancꞌopoticotic ti Jesuse. Ti cꞌusitic iꞌalbat yuꞌun ti Jesuse liyalboticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Cꞌalal icꞌ xaꞌox osil ta primero cꞌacꞌal xemanae, jaꞌ li romincoe, teyoticotic ta yut na, voꞌoticotic ti yajchancꞌopoticotic ti Jesuse. Lec jmacojticotic ti tiꞌnae, yuꞌun xiꞌemoticotic o ti cajmeltsanejcꞌopticotique. Tey icꞌot ti Jesuse. Cꞌalal iquilticotique, tey xa vaꞌal ta oꞌlol yoꞌ bu tsoboloticotique. ―Junuc me avoꞌonic ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iyacꞌ quilticotic ti bu yayijem ti scꞌobe xchiꞌuc ti xocone. Ijchꞌunticotic ti jaꞌ ti Cajvaltic Jesucristoe. Ximuyubajoticotic xa. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Liyalboticotic noxtoc: ―Junuc me avoꞌonic. Jaꞌ chac cꞌu chaꞌal listac tal ta yalel aꞌyuc cꞌusi yaloj ti Jtote, jaꞌ noꞌox yech chajtaquic echꞌel ta yalel aꞌyuc ti cꞌusi caloje ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ti Jesuse lisvuchꞌtaoticotic. ―Ichꞌic ti Chꞌul Espíritu uque. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ti muchꞌutic chavaqꞌuic ta pertonal mi oy cꞌusi chopol ispasique, jaꞌ noꞌox yech ch-aqꞌueic ta pertonal yuꞌun ti Rioxe. Yan ti muchꞌutic mu xavaqꞌuic ta pertonale, jaꞌ noꞌox yech mu xꞌaqꞌueic ta pertonal yuꞌun ti Riox uque ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ti Tomase ti vach xcuticotique, chꞌabal ox tey ti cꞌalal icꞌot ti Jesuse. Ti Tomase jaꞌ lajchavoꞌoticotic o ta yajchancꞌop ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","―Iquilticotic xa ti Cajvaltic Jesuse ―xcuticotic. ―Jaꞌto mi iquil jtuc li yav lavux ta scꞌobe, mi ijpajbe sniꞌ jcꞌob ta yav lavuxe, mi ijticꞌ ochel jcꞌob ta yav lanza ta xocone, jaꞌto ta jchꞌun ti chaꞌcuxiem xae ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ti cꞌalal ilaj vaxaquib cꞌacꞌal iquilticotique, jaꞌo tey tsoboloticotic noxtoc ta yut na. Tey xa ti Tomas uque. Lec jmacojticotic ti tiꞌnae. Tey icꞌot noxtoc ti Jesuse. Cꞌalal iquilticotique, tey xa ta oꞌlol yoꞌ bu tsoboloticotique. ―Junuc me avoꞌonic ―xiyutoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iꞌalbat ti Tomase: ―Laꞌ pajo li sniꞌ acꞌob ta yav lavuxe. Qꞌuelavil li jcꞌobe. Ticꞌo ochel lacꞌob liꞌ ta yav lanza ta jxocone. Mu me teyuc noꞌox xanopilan, chꞌuno ti chaꞌcuxiemon xae ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","―¡Voꞌot Rioxot, voꞌot Cajvalot! ―xi ti Tomase. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","―Tomás, jaꞌto achꞌun ti cꞌalal avil atuc ti chaꞌcuxiemon xae. Toj lec ti muchꞌutic ta xchꞌunic ti muc xiyilique ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Voꞌoticotic ti yajchancꞌopoticotique, iquilticotic ti ep iyacꞌ iluc slequilal syuꞌelal ti Jesuse pero muc xichꞌ tsꞌibael scotol liꞌ ta vune. ");
INSERT INTO tzoZNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ti cꞌu yepal iyichꞌ tsꞌibaele, jaꞌ yoꞌ xachꞌunic o ti jaꞌ Xchꞌamal Riox ti Jesuse, ti jaꞌ tꞌujbil yuꞌun Riox ti scꞌoplal onox chtal pasvanuc ta mantale. Mi chachꞌunique, chacuxiic o ta sbatel osil. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Voꞌoticotic ti yajchancꞌopoticotique, tsꞌacal to iquilticotic ta tiꞌnab Tibérias ti Jesuse. Jaꞌ yech iquilticotic chac liꞌi: ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Teyoticotic ta tiꞌnab xchiꞌuc jchiꞌiltac, jaꞌ ti Simon Pedroe, xchiꞌuc ti Tomase ti vach xcuticotique, xchiꞌuc ti Natanaele ti liquem tal ta jteclum Caná ta estado Galileae. Tey jbanquil uc ti Zebedeo sbi ti jtoticotique. Tey otro chaꞌvoꞌ jchiꞌilticotic ta yajchancꞌop ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","―Chba jtsac tal choy ―xiyutoticotic ti Simon Pedroe. ―Batic, chba jchiꞌinoticotic uc ―xcuticotic. Liꞌochoticotic ta canova, libatoticotic. Sjunul acꞌubal ijsaꞌticotic ti choye pero mi jcot muc bu ijtaticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ti cꞌalal isacube, iquilticotic ti tey ta tiꞌnab ti Jesuse. Muc xcojtiquinticotic mi jaꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","―Jcremotic, ¿mi ataic xa li choye? ―xiyutoticotic. ―Chꞌabal to ―xcuticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","―Jipo ochel ta abatsꞌicꞌobic lanutiꞌique, tey chataic ―xiyutoticotic. Ti cꞌalal ijipticotique, inoj tajmec ta choy. Muc xlic cuꞌunticotic ochel ta yut canova. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Voꞌon li Juanone ti más scꞌanojon icaꞌi ti Jesuse, ―¡Jaꞌ li Cajvaltic Jesuse! ―xcut ti Pedroe. Cꞌalal iyaꞌi ti Simon Pedroe ti jaꞌ ti Cajvaltic Jesuse, ora islap scꞌuꞌ yuꞌun slocꞌoj toꞌox. Isjip sba ta nab, ba sta ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Li voꞌoticotique ta canova lilocꞌoticotic, tey jquilojticotic loqꞌuel ti jnutiꞌticotique yuꞌun noj ta choy. Mu másuc nom li tiꞌnabe, oy noꞌox nan cien metrouc snamal. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ti cꞌalal lilocꞌoticotic ta tiꞌnabe, iquilticotic ti tey tsoybil cꞌoqꞌue, batsꞌi lec yacꞌlel. Tey chtaꞌaj jcot choy. Oy tey pan noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","―Ichꞌic tal chaꞌcot oxcotuc lachoyique ―xiyutoticotic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Iꞌoch ta canova ti Simon Pedroe, ba snit loqꞌuel ta tiꞌnab ti jnutiꞌticotique. Noj ta mucꞌtic choy. Oy ciento cincuenta y tres. Acꞌu mi ep ti choye pero muc xjat ti stsacobile. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","―Laꞌ veꞌanic ―xiyutoticotic ti Jesuse. Mi jun muc jacꞌticotic ti muchꞌue yuꞌun icojtiquinticotic ti jaꞌ ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ti Jesuse istam ti pane xchiꞌuc ti vobil choye, liyacꞌboticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jaꞌ yoxꞌechꞌelal o iquilticotic ti Jesuse ti cꞌalal chaꞌcuxiem xaꞌox loqꞌuel ta smuquenale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ti cꞌalal laj veꞌiconticotique, jaꞌ yech lic albatuc ti Simon Pedroe: ―Simón, screm Jonás, ¿mi más to acꞌanojon chac cꞌu chaꞌal lachiꞌiltac liꞌi? ―xꞌutat yuꞌun ti Jesuse. ―Cajval, anaꞌoj ti jcꞌanojote ―xut. ―Ti muchꞌutic achꞌ to lic yichꞌicon ta muqꞌue, qꞌuelbon me chac cꞌu chaꞌal tsqꞌuel smimiꞌic li jchabichijetique ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","―Simón, screm Jonás, ¿mi acꞌanojon? ―xꞌutat noxtoc. ―Cajval, anaꞌoj ti jcꞌanojote ―xut. ―Ti muchꞌutic voꞌne xa lic yichꞌicon ta muqꞌue, chabibon me chac cꞌu chaꞌal ta xchabi xchijic li jchabichijetique ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","―Simón, screm Jonás, ¿mi acꞌanojon? ―xꞌutat ta yoxꞌechꞌelal. Ti Pedroe iyat o yoꞌon ti yoxꞌechꞌelal xa ijacꞌbate. ―Cajval, anaꞌoj scotol. Anaꞌoj ti jcꞌanojote ―xut. ―Scotol ti muchꞌutic yichꞌojicon ta muqꞌue, saꞌbo sveꞌelic chac cꞌu chaꞌal tsaꞌbe sveꞌel xchijic li jchabichijetique. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta melel chacalbe, ti cꞌalal cꞌoxot toꞌoxe mu cꞌu vocol avaꞌi; atuc alap acꞌuꞌ, labat ti bu scꞌan avoꞌone. Pero ti cꞌalal xamolibe, chachuque. Alichꞌoj acꞌob ta teꞌ chacham ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ti iꞌalbat chac taje, jaꞌ iyaꞌi o ti Pedroe ti cꞌu xꞌelan ta xchame. Ti jaꞌ yech ta xchame, jaꞌ chacꞌ o ta ichꞌel ta mucꞌ ti Rioxe. ―Ichꞌon o me ta mucꞌ ―xꞌutat yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ti Pedroe iyil ti napꞌalon echꞌel ta spatique, voꞌon li Juanone ti más scꞌanojon icaꞌi ti Jesuse, ti tey tsꞌeelon ta xocon ti cꞌalal liveꞌoticotique, jaꞌo ti cꞌalal ijacꞌbe ti muchꞌu junucal ch-acꞌon o entrucale. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cꞌalal liyil ti Pedroe ―Cajval, li jchiꞌil liꞌi ¿cꞌu xꞌelan ta xcham uc? ―xut ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","―Mi scꞌan coꞌon ti cuxul chul jta ti cꞌalal xichaꞌsut tale, mu acuentauc. Li voꞌote ichꞌon o me ta mucꞌ ―xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ora iyaꞌiic ti jchiꞌiltactic ta yichꞌel ta mucꞌ ti Cajvaltic Jesucristoe ti muc bu chicham ti yalojique. Ti Jesuse muc xal ti muc bu chichame. Jaꞌ noꞌox iyal: “Mi scꞌan coꞌon ti cuxul chul jta ti cꞌalal xichaꞌsut tale, mu acuentauc”, xꞌutat ti Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Scotol ti cꞌusitic ijtsꞌiba liꞌi yuꞌun iquil icaꞌi jtuc, voꞌon li Juanone, ti yajchancꞌopon toꞌox ti Jesuse. Jaꞌ yech ispas, jaꞌ yech iyal ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Toj ep cꞌusitic ispas ti Jesuse. Ti iyichꞌuc tsꞌibael scotole, toj ep libroetic ti yechuque. Ti cꞌu yepal tsꞌibabil liꞌi, xuꞌ chicuxiotic o ta sbatel osil.");
INSERT INTO tzoZNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ti vun lajtsꞌibabe ta baꞌyie, voꞌon li Lucasone, lacalbe xa ti cꞌusitic ispas ti Jesuse, ti cꞌu xꞌelan ichanubtasvan ti cꞌalal liꞌ toꞌox ta sba balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Lavie yan xa o cꞌusi chacalbe. Cꞌalal mu toꞌox la chbat ta vinajel ti Jesuse, ipꞌijubtasat la yuꞌun ti Chꞌul Espíritue, iꞌalbatic la comel mantal li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cꞌalal chaꞌcuxiem xaꞌoxe, iyilulanic to la chaꞌvinic cꞌacꞌal. Más to la iꞌalbatic cꞌu xꞌelan ta spasvan ta mantal ti Rioxe. Jaꞌ la isnaꞌic o ti chaꞌcuxieme. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cꞌalal xchiꞌuquic toꞌox la ti Jesuse ―Mu to me xaloqꞌuic echꞌel liꞌ ta Jerusalene. Malaic ti Chꞌul Espíritue ti yaloj onox ti Jtotic Riox ta vinajele ti chacacꞌbeic chac cꞌu chaꞌal lacalbeic onoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ti Juane layacꞌbe avichꞌic voꞌ. Li voꞌone poꞌot xa xacacꞌbeic ti Chꞌul Espíritue ―xꞌutatic la comel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cꞌalal tsobolic toꞌox la xchiꞌuquic ti Jesuse ―Cajval, ¿mi ista xa yora noxtoc ti liꞌ xa noꞌox chlocꞌ preserente ta jlumaltique? ¿Mi voꞌot xa chaꞌoch? ―xutic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","―Mu acuentaicuc cꞌusi ora. Stuc noꞌox snaꞌoj ti Jtotic Rioxe yuꞌun jaꞌ scuentainoj scotol. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ti cꞌalal xtal xchiꞌinoxuc ti Chꞌul Espíritue, jaꞌ ta stsatsubtas avoꞌonic. Chavalic aꞌyuc cꞌusi caloj liꞌ ta jteclum Jerusalene, xchiꞌuc liꞌ ta estado Judeae, xchiꞌuc ta estado Samaria, xchiꞌuc ta sjunlej balamil ―xꞌutatic la comel yuꞌun ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ti cꞌalal laj yal yech ti Jesuse, jaꞌo la imuy ta vinajel. Li apoxtoletique iyilic la imuy. Imac la ta toc, ichꞌay la ta satic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ti cꞌalal sqꞌuelojic muyel vinajel yoꞌ bu imuy ti Jesuse, jaꞌo la iyilic tey vaꞌajtic chaꞌvoꞌ anjel ta stsꞌelic, coꞌol la xchiꞌuc vinic yilel. Sac la scꞌuꞌ xchaꞌvaꞌalic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","―Jgalileaetic, ¿cꞌu yuꞌun chaqꞌuelic li vinajele? Ti cꞌu xꞌelan imuy li Jesuse, jaꞌ noꞌox yech ta xchaꞌsut tal ―xꞌutatic la yuꞌun ti anjeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Teic ox la ta vits Olivotic ti cꞌalal imuy ta vinajel ti Jesuse. Li vits Olivotique nopol xil sba xchiꞌuc Jerusalén. Jaꞌ noꞌox yech snamal chac cꞌu chaꞌal snamal chanavic ta scꞌacꞌalil ta xcuxic li jꞌisraeletique. Li apoxtoletique isutic la ta Jerusalén. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ti cꞌalal icꞌotique, imuyic la ta xchaꞌcojol jolna yoꞌ bu xchꞌamunojique. Jaꞌic li Pedroe, xchiꞌuc li Jacoboe, xchiꞌuc li Juane, xchiꞌuc li Andrese, xchiꞌuc li Felipee, xchiꞌuc li Tomase, xchiꞌuc li Bartolomee, xchiꞌuc li Mateoe, xchiꞌuc li otro jun Jacoboe li screm Alfeoe, xchiꞌuc li Simone ti ochem toꞌox ta partido jzeloteetique, xchiꞌuc li Judas yitsꞌin Jacoboe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tey la tsobol o scotolic, coꞌol la iscꞌoponic Riox jujun cꞌacꞌal. Tey la xchiꞌuquic jayvoꞌ antsetic. Tey la xchiꞌuquic noxtoc ti María smeꞌ Jesuse, xchiꞌuc yitsꞌintac ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ti cꞌalal tey tsobolic uc ti yane ti yichꞌojic ta mucꞌ ti Cajvaltic Jesucristo uque, jaꞌo la isvaꞌan sba ta oꞌlol li Pedroe. Oy nan ciento veinteuc ti tey tsobolique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Jchiꞌiltactic, viniquetic, antsetic, icꞌot onox ti cꞌusi tsꞌibabil ta scꞌop Riox ti ta más voꞌnee ti cꞌalal ichꞌamunbat ye yuꞌun Chꞌul Espíritu ti Davide. Jaꞌ iyal ti cꞌusi ispas xa ti Judase, jaꞌ ti iyicꞌ echꞌel ti muchꞌutic ixchuquic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ti Judase coꞌol toꞌox yajchancꞌopoticotic ti Jesuse. Ti ta alele, chal aꞌyuc uc ti cꞌusi iyal ti Jesuse ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ti Judase itojat la ti iyacꞌ entrucal ti Jesuse. Tsꞌacal to ba la sutes ti stojole, ismanic o la osil. Ti Judase ba la sjocꞌan sba chamuc yoꞌ bu ti osil ismanique. Jaꞌ noꞌox la ti muc tey jocꞌol icom chac cꞌu chaꞌal isnope. Ipꞌaj la, tsꞌucul la icꞌot. Toj la loqꞌuel sbiquil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iyaꞌiic la ti muchꞌutic tey nacal ta Jerusalene, Acéldama la isbiin ti osile. Li Aceldamae “Chꞌichꞌ Lum”, xi smelol. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Iyal la noxtoc li Pedroe: ―Tsꞌibabil onox ta svunal jqꞌuevujtic: Mu me muchꞌu xba nacluc teyoꞌe, xi tsꞌibabil. Tsꞌibabil noxtoc ti yan o muchꞌu chichꞌ li yabtel Judase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Yechꞌo un persa ta jtꞌujbetic sqꞌuexol. Jaꞌ ta jtꞌujtic junuc li muchꞌutic liꞌ onox jchiꞌuctique, ti scotol cꞌacꞌal coꞌol ijchiꞌinticotic ta xanvil ti Cajvaltic Jesuse, yoꞌ coꞌol xcalticotic ti ichaꞌcuxi ti Jesuse. Jaꞌ ta jtꞌujtic junuc li muchꞌutic coꞌol iquilticotic iꞌacꞌbat yichꞌ voꞌ yuꞌun Juan ti Jesuse cꞌalal to ti ibat ta vinajele ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Istꞌujic la chaꞌvoꞌ. Ti june José Barsabás la sbi. Justo la sbi noxtoc. Ti june Matías la sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ti cꞌalal laj stꞌujique, iscꞌoponic la Riox. ―Cajval, voꞌot avilojbe yoꞌon li crixchanoetique. Li chaꞌvoꞌ liꞌi acꞌo quilticotic muchꞌu junucal ti atꞌujoje, yuꞌun ta xꞌoch ta avajꞌapoxtol uc. Jaꞌ ta xꞌoch ta sqꞌuexol ti Judase. Ti Judase ichꞌay yuꞌun isaꞌ smul, yechꞌo ti ba yichꞌ castico ta sbatel osile ―xiic la ti cꞌalal iscꞌoponic Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lic la tajinicuc li apoxtoletique, jaꞌ la isqꞌuelic o muchꞌu junucal ta xcom. Jaꞌ la icom yuꞌunic ti Matíase. Yechꞌo un ipasic ta lajchavoꞌ noxtoc li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ta qꞌuin Pentecostese tey la tsobolic ta jun na li lajchavoꞌe, xchiꞌuc ti yane ti xchꞌunojic li scꞌop Riox uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Iyaꞌiic la ti oy cꞌusi tsots ibacꞌ ta vinajele. Coꞌol la xchiꞌuc icꞌ ti tsots xjumumete. Iyaꞌiic la scotolic ti bu chotajtique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Coꞌol la xchiꞌuc lebcꞌocꞌ iyilic, icꞌot la ta sjolic jujun. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tal la chiꞌinaticuc scotolic yuꞌun ti Chꞌul Espíritue. Jaꞌo la icꞌopojic ta yantic cꞌop, jaꞌ la ti cꞌusi cꞌopal iyulesbat ta sjolic yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tey la talemic ta Jerusalén uc ti jurioetique ti stanioj sbaic echꞌel ta yantic balamile, jaꞌic la ti muchꞌutic yichꞌojic ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ti cꞌalal iyaꞌiic ti cꞌusi xjumumete, ora la istsob sba scotolic. Iyaꞌiic la ti naca ta scꞌop stuquic icꞌoponatique, xchꞌayet xa la yoꞌonic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","―Li muchꞌutic liꞌ ta xcꞌopoje, ¿mi maꞌuc jchiꞌiltactic ti liquemic tal ta estado Galileae? ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cꞌu chaꞌal ti snaꞌic li jcꞌoptique? ¿Cꞌuxi ixchanic? ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yuꞌun ep ta tos jcꞌoptic ti liꞌ talemotic ta qꞌuine. Liquemotic tal jlom ta Partia, jlom ta Media, jlom ta Elám, jlom ta Mesopotamia, jlom liꞌ ta estado Judeae, jlom ta Capadocia, jlom ta Ponto, jlom ta Asia. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Jlom liquemotic tal ta Frigia, jlom ta Panfilia, jlom ta Egipto, jlom ta Africa ta sjelavel jteclum Cirenee. Talem jlom jromaetic ti jaꞌ yech xchꞌunojic chac cꞌu chaꞌal jchꞌunojtique. Talem jlom jchiꞌiltactic ti tey nacal ta Romae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jlom liquemic tal ta Creta, jlom ta Arabia. Pero jcotoltic xcaꞌi ta jcꞌoptic li cꞌusitic achꞌ to ispas ti Rioxe ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Xchꞌayet xa la yoꞌon scotolic, mu la snaꞌic cꞌu yuꞌun ti xꞌelan icꞌote. ―¿Cꞌusi smelol xanaꞌic? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ti jlome ilabanvanic la: ―Yuꞌun nan ta xyacubic ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Li Pedroe isvaꞌan la sba xchiꞌuc ti buluchvoꞌ xchiꞌiltaque. Tsots la icꞌopoj. ―Jchiꞌiltactic, voꞌoxuc ti liꞌ nacaloxuc ta estado Judeae xchiꞌuc voꞌoxuc ti liꞌ talemoxuc ta Jerusalene, aꞌyic me li cꞌusi ta xcale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Muc bu chiyacuboticotic chac cꞌu chaꞌal chavalique yuꞌun baluneb to ora. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Li cꞌusi chavilique, jaꞌ icꞌot xa ti cꞌusi iyal ti Joel yajꞌalcꞌop Riox ti ta voꞌnee. Jaꞌ yech liyalbe ti Rioxe, xi ti Joele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ti cꞌalal poꞌot xaꞌox xlaj li balamile, ep crixchanoetic ta sjunlej balamil ta xcacꞌbeic xchiꞌin Chꞌul Espíritu ti junon jchiꞌuque. Ti amomique jaꞌo chlic yalic ti cꞌusi caloje, acꞌu mi crem, acꞌu mi tseb. Ti bu svaꞌlej xa scremique chcacꞌbe yil li cꞌusi leque. Ti moletique oy cꞌusi chcacꞌbe yil ta svayichic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti muchꞌutic chiyichꞌic ta muqꞌue, mi vinic, mi ants, chcacꞌbe xchiꞌin Chꞌul Espíritu ti junon jchiꞌuque. Chlic yalic aꞌyuc ti cꞌusi chcalbee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chcacꞌ ta vinajel, chcacꞌ ta balamil ti cꞌusi xiꞌel sbae; chꞌichꞌ, xchiꞌuc cꞌocꞌ, xchiꞌuc chꞌayil. Ta xiꞌic o ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta xꞌicꞌub yuꞌun ta xmac sat li cꞌacꞌale. Li jchꞌulmeꞌtique ta stsajub chac cꞌu chaꞌal chꞌichꞌ. Jaꞌ yech ta xcꞌot ti cꞌalal poꞌot xaꞌox xcalbe bu chbat ta sbatel osil li crixchanoetique. Jaꞌo xa chvinaj ti muchꞌutic ta xcuxiic ta sbatel osile, xchiꞌuc ti muchꞌutic ta xꞌochic ta cꞌocꞌ ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Scotol ti muchꞌutic tscꞌan chcuxiic ta sbatel osile, chcacꞌ cuxlicuc, xi ti Rioxe, xi onox ti Joele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jchiꞌiltactic, aꞌyic me li cꞌusi chcale. Voꞌotic li jꞌisraelotique, acꞌu jyules ta joltic ti ep ta echꞌel iyacꞌ iluc slequilal syuꞌelal ti Jesus Nazarete. Iquiltic cꞌu xꞌelan ispas. Xchꞌayet xa coꞌontic. Ta melel ti acꞌbil yabtel yuꞌun ti Rioxe, yuꞌun naca ta syuꞌel Riox ispas. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iꞌaqꞌue entrucal yuꞌun onox yech snopoj ti Rioxe. Voꞌoxuc atsaquic, avacꞌbeic smil ta cruz ti muchꞌutic mu xichꞌ ta mucꞌ ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ti Rioxe ixchaꞌcuxes loqꞌuel ta smuquenal yuꞌun mu onox bu ta xcham o. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ti David ti ta voꞌnee jaꞌ yech iyalbe ti Rioxe: Achiꞌinojon sjil cꞌacꞌal. Liꞌot ta jpat ta jxocone, yechꞌo ti mu xixiꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yechꞌo un sjunul coꞌon ta xcalbe jchiꞌiltac ti quiloj chacꞌuxubinone. Ti cꞌalal xichame, jnaꞌoj ti chachaꞌcuxesone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Muc bu chicham o. Muc bu ta xcꞌaꞌ jpat jxocon, voꞌon lachꞌamalone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Avalbon xa ti chicuxi ta sbatel osile. Jun coꞌon ta sbatel osil ti cꞌalal xcꞌot jchiꞌinote, xi ti cꞌalal iscꞌopon Riox ti Davide. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Jchiꞌiltactic, jnaꞌojtic ti mu scꞌoplaluc stuc ti iyale. Ti Davide icham, ismuquic. Jnaꞌojtic ti bu mucbile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ti cꞌusi iyal ti cꞌalal iscꞌopon Riox ti Davide, jaꞌ scꞌoplal ti Cajvaltic Jesuse yuꞌun jaꞌ yech iscꞌopon Stot ti Cajvaltic Jesuse. Ti Davide ichꞌamunbat noꞌox ye, yuꞌun jaꞌ yajꞌalcꞌop Riox. Iꞌalbat noxtoc yuꞌun ti Rioxe ti jun smom ta xcom ta sqꞌuexole ti jaꞌ chispasotic ta mantal, voꞌotic li juriootique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yechꞌo ti iyal ti ta xchaꞌcuxi ti Cristoe, ti muc bu ta xcham oe, ti muc bu ta xcꞌaꞌ li spat xocone. Jaꞌ icꞌot ti cꞌusi iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Riox ixchaꞌcuxes ti Jesuse. Voꞌoticotic iquilticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta syuꞌel Riox iꞌiqꞌue muyel ta vinajel ti Jesuse. Lavie tey xa chotol ta sbatsꞌicꞌob ti Rioxe. Albil onox yuꞌun ti Jtotic Riox ta vinajele ti ta stac tal ti Chꞌul Espíritue. Yechꞌo un tal xa xchiꞌinoticotic. Avilic, avaꞌiic xa uc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ti Davide muc xbat ta vinajel xchiꞌuc spat xocon, pero jaꞌ yech iyal: Ti Cajvale iꞌalbat yuꞌun ti Rioxe: “Chachoti ta jbatsꞌicꞌob, chapas mantal ti cꞌu sjalil xchꞌun o amantal cuꞌun scotol lacrontae”, xꞌutat, xi ti Davide. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Acꞌu jyules ta joltic jcotoltic, voꞌotic li jꞌisraelotique, ti Jesús avaqꞌuic ta milel ta cruze, jaꞌ stꞌujoj Riox ti tspasvan ta mantale, ti tstoj jmultic jcotoltique ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ti cꞌalal iyaꞌiic ti xchiꞌiltac ta jurioale ti cꞌusi iyal li Pedroe, iyat la yoꞌonic tajmec yuꞌun li smulique. ―Jchiꞌiltactic, ¿cꞌusi tscꞌan ta jpasticotic? ―xꞌutat la li Pedroe xchiꞌuc li xchiꞌiltac ta apoxtolale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","―Ictaic xa spasel li cꞌusitic chopole, ichꞌic voꞌ ta scuenta ti Jesucristoe yoꞌ xayacꞌbeic o pertonal yuꞌun amulic ti Rioxe, yoꞌ xtal xchiꞌinoxuc o ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ti Rioxe yaloj onox ti chacꞌbe xchiꞌin Chꞌul Espíritu ti muchꞌutic ta xchꞌun iqꞌuel yuꞌun ti Rioxe. Xuꞌ chaxchiꞌinic uc. Xuꞌ xchiꞌinatic li jchꞌamaltic uque. Xuꞌ xchiꞌinatic li muchꞌutic maꞌuc jchiꞌiltique mi ta xchꞌunic iqꞌuel yuꞌun ti Rioxe ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Li Pedroe ep to la cꞌusi iyal. Ti slajeb xa ti cꞌusi iyale ―Ichꞌic ta mucꞌ ti Rioxe yoꞌ mu xaꞌochic o ta cꞌoqꞌue chac cꞌu chaꞌal ta xꞌochic ta cꞌocꞌ ta sbatel osil li muchꞌutic mu xichꞌ ta muqꞌue ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ti jayvoꞌ ixchꞌun cꞌusi iyal ti Pedroe iyichꞌic la voꞌ. Ta jun noꞌox cꞌacꞌale ixchꞌunic la oxmil xchiꞌiltac. Jaꞌ la yech ipꞌol ti muchꞌutic chichꞌic ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sjunul la yoꞌon ixchꞌunic ti cꞌusi iꞌalbatic yuꞌun li apoxtoletique. Coꞌol la sjolic scotolic. Ixchiꞌin la sbaic ta scꞌoponel Riox. Sjunul la yoꞌon ispasic chac cꞌu chaꞌal iyacꞌ iluc ti Cajvaltic Jesuse ti cꞌalal iꞌacꞌbat sveꞌic pane, ti iꞌacꞌbat yuchꞌic yaꞌlel uva li lajchavoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Li apoxtoletique ep la ta echꞌel iyaqꞌuic iluc slequilal syuꞌelal Riox yuꞌun la tey xchiꞌuquic. Xchꞌayet xa o la yoꞌonic scotol li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ti muchꞌutic ixchꞌun li scꞌop Rioxe, coꞌolcoꞌol la iscolta sbaic, ixchꞌacbe la sbaic ti cꞌusitic oy yuꞌunique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ti cꞌalal iyilic ti chꞌabal cꞌusuc yuꞌun ti yantique, ixchon la yosilic jlom, ixchon la cꞌusuc yuꞌunic jlom. Ti stojole jaꞌ la iyacꞌbeic ti muchꞌutic chꞌabal cꞌusuc yuꞌune. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Scotol la cꞌacꞌal istsob sbaic ta tiꞌ mucꞌta templo ta Jerusalén. Isveꞌic la pan ta snaic, iyuchꞌic la yaꞌlel uva yuꞌun snaꞌojic ti jaꞌ icham ta scoj jmultic ti Cajvaltic Jesuse. Coꞌol la iveꞌic, xmuyubajic xa la scotolic. Lec la iyil sbaic tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","―Coliyalbotic Riox ti istoj li jmultique ―xiic la. Lec la iꞌileic yuꞌun sjunlej jteclum. Ti Cajvaltic Jesucristoe ipꞌol la yuꞌun jujun cꞌacꞌal ti muchꞌutic ixchꞌunic ti tojbil smulique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Li Pedroe xchiꞌuc li Juane ba la scꞌoponic Riox ta tiꞌ mucꞌta templo. Ta oxib la ora xmal ibatic, yuꞌun jaꞌo yora ta scꞌoponic Riox scotol ti xchiꞌilique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tey la chotol ista jun xchiꞌilic, coxo la ayanem. Scotol la cꞌacꞌal chcuche echꞌel, tey la chcꞌot xchotanel ta stiꞌ scorraltonal mucꞌta templo yoꞌ “Leclec Sba” xi sbie. Tey toꞌox la ta scꞌan limoxna ti coxoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ti cꞌalal iyil ti ta xꞌochic ta yut corralton li Pedroe xchiꞌuc li Juane, icꞌanbatic la limoxna. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Li Pedroe xchiꞌuc li Juane isqꞌuelbeic la sat ti coxoe. ―Qꞌueloticotic ―xut la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ti coxoe iqꞌuelvan la. Ismala la mi oy cꞌusi ta xꞌacꞌbat. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","―Chꞌabal jtaqꞌuin pero oy cꞌusi chacacꞌbe. Jaꞌ ta syuꞌel ti Jesucristo Nazarete chacalbe, vaꞌlan, xanavan ―xut la coxo li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Li Pedroe istsacbe la sbatsꞌicꞌob ti coxoe, isnit la liquel. Ora la itsatsub xchibal yoc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ipꞌit la, vaꞌal la icꞌot, lic la xanavuc. Ichiꞌineic la ochel ta yut scorraltonal templo li Pedroe xchiꞌuc li Juane. Juliquel la chanav, juliquel la chpꞌitomaj ochel, xmuyubaj xa la tajmec. ―Coliyal Cajvaltic ti lecon xae ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ep la crixchanoetic iyil ti chanav xa ti coxoe, ti “coliyal Riox”, xie. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iyojtiquinic la ti jaꞌ ti jcꞌanlimoxna toꞌoxe ti tey xchotet ta stiꞌ scorraltonal templo yoꞌ “Leclec Sba” xi sbie. Xchꞌayet xa la yoꞌonic ti cꞌalal iyilic ti lec xa ti coxoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tey ta scorirolal mucꞌta templo yoꞌ Salomón sbie, tey la isvaꞌan sbaic li Pedroe xchiꞌuc li Juane. Tey la xchiꞌuquic ti coxo toꞌoxe yuꞌun la mu xꞌictavan. Ti crixchanoetique xchꞌayet xa la yoꞌonic ti lec xae. Istsob la sbaic tal scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Li Pedroe cꞌalal iyil ti istsob sba tal ti crixchanoetique, ―Jchiꞌiltactic, ¿cꞌu yuꞌun ti xchꞌayet avoꞌonique? ¿Cꞌu yuꞌun ti chaqꞌueloticotic tajmeque? Mu me xavalic ti ta jyuꞌel jtucticotique, ti ta slequil coꞌon jtucticotic ti chanav xa li vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ti Riox yichꞌojic ta mucꞌ ti jmucꞌtatotic ti ta más voꞌnee, jaꞌ ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove, iyacꞌ iluc ti oy syuꞌel ti Xchꞌamale, jaꞌ ti Jesuse, ti avacꞌbeic entrucal Pilatoe. Ti cꞌalal ta ox scolta li Pilatoe, li voꞌoxuque muc xacꞌanic ti ta xcole. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jaꞌ muc xacꞌanic ti jaꞌ ta xcol ti muchꞌu chꞌabal smule, ti lec yoꞌone. Jaꞌ acꞌanbeic scolel ti jmilvaneje. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jaꞌ avaqꞌuic ta milel ti muchꞌu chacꞌ jcuxlejaltic ta sbatel osile. Pero ichaꞌcuxesat yuꞌun ti Rioxe. Li cꞌusi ta xcalticotique, yech, yuꞌun iquilticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jchꞌunojticotic ti oy syuꞌel ti Jesuse. Jaꞌ ta syuꞌel ti lec xa li vinique ti liꞌ chavilique ti xavojtiquinique. Yuꞌun ijchꞌunticotic ti oy syuꞌel ti Jesuse, yechꞌo ti lec xae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Jchiꞌiltactic, jnaꞌoj ti muc xul ta ajolic ti jaꞌ ti Jesuse ti muchꞌu scꞌoplal ta stac tal ti Rioxe, yechꞌo ti avaqꞌuic ta milele. Jaꞌ noꞌox yech muc xul ta sjolic li cajmeltsanejcꞌoptic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yuꞌun jaꞌ icꞌot ti cꞌusi yaloj ti Rioxe ti cꞌalal ixchꞌamunbe ye ti yajꞌalcꞌoptac ti ta más voꞌnee. Iyalic onox ti persa ta xcham ti Cristoe ti jaꞌ stꞌujoj Riox chispasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Yechꞌo un ictaic xa spasel li cꞌusitic chopole, ichꞌic ta mucꞌ ti Rioxe yoꞌ xayacꞌbeic o pertonal yuꞌun lamulique, yoꞌ jun o avoꞌonique, yoꞌ stac o tal noxtoc ti Jesuse ti jaꞌ stꞌujoj Riox chispasotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ti Jesucristoe tey xa ta vinajel. Jaꞌto ta xtal ti cꞌalal sta yora ta slecubtas balamil ti Rioxe chac cꞌu chaꞌal iyal ti yajꞌalcꞌoptac ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ti Moisese jaꞌ yech iyalbe ti voꞌne moletique: “Ti Rioxe ta to xastꞌujbeic jun jꞌalcꞌop ta tsꞌacal. Jchiꞌiltic ta stꞌuj chac cꞌu chaꞌal li voꞌone. Xachꞌunbeic me ti cꞌusi chayalbeique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ti muchꞌutic mu xchꞌune mu stacꞌ chba xchiꞌinic ta sbatel osil ti Rioxe”, xi ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Iyal ti Samuel uque, ti yajꞌalcꞌop Riox ti ta más voꞌnee, ti ta xtal onox ti muchꞌu stꞌujoj ti Rioxe chac cꞌu chaꞌal icꞌot xae. Jaꞌ onox yech iyal ti yan yajꞌalcꞌoptac Riox ti tsꞌacal to laj taluque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Voꞌotic jcꞌoplaltic ti jaꞌ yech iꞌalbatic yuꞌun Riox ti voꞌne moletique: “Ti amome jaꞌ ta sta o bentisyon ti jaylajuntos crixchanoetic ta sba balamile”, xꞌutat onox yuꞌun Riox ti Abraame. ");
INSERT INTO tzoZNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ti Rioxe baꞌyi listacbotic tal ti Xchꞌamale, yuꞌun tal scoltaotic yoꞌ xquictatic o ta jujuntal spasel li cꞌusitic chopole ―xut la xchiꞌiltac li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ti cꞌalal yolel la chloꞌilaj xchiꞌuc crixchanoetic li Pedroe xchiꞌuc li Juane, tey la icꞌot jayvoꞌ paleetic xchiꞌuc ti totil jchabiejtemploe. Tey la icꞌot jayvoꞌ jsaduceoetic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Capemic la cꞌotel. Jaꞌ la capemic o ti ta xchanubtasvanic li Pedroe xchiꞌuc li Juane. Yuꞌun la iyalic ti ta xchaꞌcuxi ánimaetic chac cꞌu chaꞌal ichaꞌcuxi ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jaꞌ la itsaqueic o, itiqꞌueic la ta chuquel. Ti jchucvanejetique isnopic la ti ta yocꞌomal to ta smeltsanbeic scꞌoplale, yuꞌun la malem xaꞌox cꞌacꞌal ti cꞌalal itsaqueique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero ep la ixchꞌunic scꞌop Riox ti iyal li Pedroe xchiꞌuc li Juane. Oy xa la voꞌmil viniquetic xchiꞌuc ti muchꞌutic baꞌyi xchꞌunojique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta yocꞌomal istsob la sbaic ta Jerusalén ti jmeltsanejcꞌopetic yuꞌun li jꞌisraeletique. Jaꞌic la jlom ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tey la icꞌot ti Anas uque, ti loqꞌuem totil palee, xchiꞌuc la ti Caifase. Xchiꞌuc la yan chaꞌvoꞌ pale. Ti june Juan la sbi; ti june Alejandro la sbi. Tey la icꞌotic uc scotol xchiꞌilic ti totil paleetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ti cꞌalal tsobolic xaꞌox lae, jaꞌo la iloqꞌuesatic ta chuquel li Pedroe xchiꞌuc li Juane. Ivaꞌanatic la ta oꞌlol. ―¿Muchꞌu layalbeic, muchꞌu ta syuꞌel ti xꞌelan chapasique? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Li Pedroe ipꞌijubtasat la, itsatsubtasbat la yoꞌon yuꞌun ti Chꞌul Espíritue. ―Jtotic moletic, jmeltsanejcꞌopetic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Ti chajacꞌboticotic cꞌuxi ilecub yoc cuꞌunticotic li vinique, chcal avaꞌiic. Voꞌotic li jꞌisraelotique, acꞌu jyules ta joltic ti jaꞌ ta syuꞌel ti Jesucristo Nazarete ti ilecub yoc li vinic liꞌi. Jaꞌ ti muchꞌu avaqꞌuic ta milel ta cruze. Pero ichaꞌcuxesat yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Li voꞌoxuque jaꞌ achiꞌilic li alvaniletique ti ispꞌajic li ton ti istꞌuj li yajval nae ti jaꞌ ta xacꞌ ta xchiquin snae. Jaꞌ yechoxuc yuꞌun apꞌajic ti muchꞌu stꞌujoj ti Rioxe, jaꞌ ti Jesuse, pero lavie iꞌacꞌbat xa tsots yabtel yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yuꞌun jaꞌ noꞌox chispojotic yoꞌ mu xiꞌochotic o ta cꞌoqꞌue. Muc muchꞌu yan albil scꞌoplal ti chispojotique, jaꞌ noꞌox ti Jesucristoe ―xut la jmeltsanejcꞌopetic li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Cꞌalal iyil ti jmeltsanejcꞌopetique ti mu xiꞌic li Pedroe xchiꞌuc li Juane, xchꞌayet xa la yoꞌonic yuꞌun la snaꞌojic ti muc bu ichanubtasatic ta smantal Rioxe, ti chꞌabal yabtelique. Iyul la ta sjolic ti ixchiꞌinic toꞌox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Li Pedroe xchiꞌuc li Juane, ti tey la xchiꞌuquic ti coxo toꞌoxe, yechꞌo la ti mu xuꞌ chnopbat smulic yuꞌun ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yechꞌo un itaqueic la loqꞌuel jliquel ta pana. Ti jmeltsanejcꞌopetique isnopic la cꞌusi ta xchaꞌleic li Pedroe xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","―¿Cꞌusi ta jchaꞌletic xanaꞌic li viniquetique? Yuꞌun iyaqꞌuic iluc slequilal syuꞌelal Riox, yuꞌun ilecub yoc li vinique. Iyaꞌi xa scotol li muchꞌutic liꞌ nacajtic ta Jerusalene. Mu xuꞌ xcaltic ti mu yechuque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yoꞌ mu xa xalic o aꞌyuc ta sjunlej li jlumaltique, tsots acꞌu calbetic ti mu xa yaꞌuc yalbeic scꞌoplal ti Jesuse ―xut la sbaic ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ti cꞌalal laj snopique, iꞌiqꞌueic la ochel xchaꞌvaꞌalic. Tsots la iꞌalbatic ti mu xa la yaꞌuc yalbeic scꞌoplal ti Jesuse, ti mu xa la yaꞌuc chanubtasvanicuc oe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","―Alic cꞌusi jtosucal ti persa ta jchꞌunticotique. ¿Mi jaꞌ ta jchꞌunticotic li cꞌusi chavalique, o mi jaꞌ ta jchꞌunticotic cꞌusi yaloj ti Rioxe? ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yuꞌun persa chcalticotic ti cꞌusitic quilojticotique xchiꞌuc ti cꞌusitic caꞌyojticotique ―xiic la li Pedroe xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ti jmeltsanejcꞌopetique iyalic la noxtoc ti mu xa yaꞌuc yalbeic scꞌoplal ti Jesuse, jaꞌo la icoltaatic. Ta ox la xꞌacꞌbatic castico pero muc la xꞌacꞌbatic, yuꞌun la xiꞌem chaqꞌuic castico ti jmeltsanejcꞌopetique. Yuꞌun la scotol xchiꞌiltac “coliyal Riox” xiic ti iyilic ilecub yoc ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ti vinic ti ilecub yoc ta slequilal syuꞌelal ti Rioxe, oy xa la más ta chaꞌvinic sjabilal. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ti cꞌalal icolic echꞌel li Pedroe xchiꞌuc li Juane, cꞌot la yalbeic xchiꞌilic ta apoxtolal ti cꞌusitic iꞌalbatic yuꞌun ti paleetique xchiꞌuc ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ti cꞌalal iyaꞌiique, iscꞌoponic la Cajvaltic scotolic: ―Cajval, voꞌot acuentainoj scotol. Atuc noꞌox Rioxot. Voꞌot apas vinajel balamil, xchiꞌuc mar, xchiꞌuc scotol li cꞌusitic oye. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Voꞌot achꞌamunbe ye ti avajꞌalcꞌop David ti ta más voꞌnee ti jaꞌ yech iyale, ti jaꞌ yech istsꞌibae: Yech noꞌox ti ta to stoy sbaic ta tsꞌacal ti muchꞌutic maꞌuc jchiꞌiltic ta israelale. Yech noꞌox ti cꞌusitic ta to snopic ti jchiꞌiltactic uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ti yajpasvanejic ta mantale xchiꞌuc ti yajmeltsanejcꞌopique, coꞌol to ta scrontainic ti Rioxe xchiꞌuc ti muchꞌu stꞌujoj Riox ta spasvan ta mantale, xi onox. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Jaꞌ yech icꞌot yuꞌun liꞌ istsob sbaic ta Jerusalén li Erodese, xchiꞌuc li Poncio Pilatoe, xchiꞌuc li muchꞌutic maꞌuc jchiꞌilticotique, xchiꞌuc li jchiꞌilticotic ta israelale. Coꞌol isnopic ti ismilic ti achꞌamale, jaꞌ ti Jesuse, ti chꞌabal smule, ti jaꞌ atꞌujoj chispasoticotic ta mantale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jaꞌ yech ixchaꞌleic chac cꞌu chaꞌal anopoj onoxe yuꞌun jaꞌ yech acꞌan. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cajval, lavie yoꞌonicuc spajesoticotic, voꞌoticotic ti chitunoticotic avuꞌune. Tsatsubtaso coꞌonticotic, mu me xquicta o jbaticotic ta yalel aꞌyuc ti cꞌusi avaloje. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Acꞌo iluc ayuꞌel, acꞌu quetꞌesticotic chamel. Acꞌo cacꞌticotic iluc yan señailtac yuꞌun ti quichꞌojticotic ta mucꞌ lachꞌamale ―xiic la ti cꞌalal iscꞌoponic Cajvaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ti cꞌalal laj scꞌoponic ti Cajvaltique, xvuyvon xa la iyaꞌiic scotolic ti na yoꞌ bu tsobolique. Itsatsubtasbat la yoꞌonic scotolic yuꞌun ti Chꞌul Espíritue. Muc la xicta sbaic, jamal la iyalic aꞌyuc ti cꞌusi yaloj ti Cajvaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ti jaymil xchꞌunojique coꞌol la sjolic scotolic. Ti muchꞌutic oy la cꞌusuc yuꞌune muc xalic ti yuꞌun stuquique, coꞌol la yuꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Li apoxtoletique iyalic la ti cꞌu xꞌelan iyilic ti cꞌalal chaꞌcuxiem xaꞌox ti Cajvaltic Jesucristoe, yechꞌo la ti más ixchꞌunic o ti muchꞌutic xchꞌunoj li scꞌop Rioxe. ―Yech ti chaꞌcuxieme ―xiic xa la scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yechꞌo un mu xa la muchꞌu abol sba, yuꞌun ti muchꞌutic oy yosile, xchiꞌuc ti muchꞌutic oy snae, ixchonic la ti cꞌalal chꞌabal xa cꞌusuc yuꞌun ti xchiꞌilique. Iyichꞌbeic la tal stojol ti cꞌusi ixchonique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jaꞌ la iꞌacꞌbatic li apoxtoletique. Li apoxtoletique jaꞌ xa la iyacꞌbeic ti muchꞌutic chꞌabal cꞌusuc yuꞌune. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tey la jun vinic, José la sbi. Bernabé la iꞌacꞌbat sbi yuꞌun li apoxtoletique. Li Bernabee “jaꞌ ta spat coꞌontic”, xi la smelol. Ta Chipre la liquem tal. Leví la sbi ti smucꞌtatot ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ti Bernabee oy la yosil, ixchon la. Ti stojole jaꞌ la iꞌacꞌbatic li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oy la jun vinic, Ananías la sbi. Safira la sbi ti yajnile. Ixchon la jsetꞌ yosilic uc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero coꞌol la isnopic xchiꞌuc ti yajnile ti mu tsꞌacluc chacꞌ ti stojol yosilique. Yechꞌo la ti muc xichꞌ echꞌel scotole ti cꞌalal ba acꞌbaticuc li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","―Ananías, ¿cꞌu yuꞌun ti achꞌunbe smantal ti Satanase ti mu tsꞌacluc avacꞌ li stojol avosilique? Avaloj nan ti xuꞌ chaloꞌlo ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Li osile jaꞌ avuꞌun, mu persauc achon ti yechuque. Ti cꞌalal achone, atuc anop ti chavacꞌ tunuc li stojole. ¿Cꞌu yuꞌun achꞌacbe li stojole? Maꞌuc crixchano ti anopbe cꞌope; jaꞌ anopbe cꞌop ti Cajvaltique ―xꞌutat la yuꞌun li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ti cꞌalal iyaꞌi yech ti Ananíase, iyal la ta lum, toj la loqꞌuel xchꞌulel. Ixiꞌic la tajmec scotol ti muchꞌutic iyaꞌi ti icham xae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tey la jayvoꞌ svaꞌlej cremotic, isvolic la ta saquil pocꞌ ti ánimae, ba la smuquic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iꞌechꞌ la oxibuc ora, jaꞌo la iꞌoch tal ti yajnil uque, jaꞌ ti Safirae. Mu la snaꞌ mi chamem xa ti smalale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","―Albon mi yech yepal li stojol avosilic ti achonique ―xꞌutat la yuꞌun li Pedroe. ―Yechaꞌa ―xi la ti ants uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","―¿Cꞌu yuꞌun ti coꞌol anopic xchiꞌuc ti amalale ti chatoy abaic ta stojol ti Chꞌul Espíritue ti jun xchiꞌuc ti Cajvaltique? Liꞌ xa xtal ta pana li muchꞌutic ay smuc ti amalale. Jaꞌ noꞌox yech chba smuquelot uc ―xut la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ti cꞌalal iyaꞌi yech ti antse, iyal la ta lum, toj la loqꞌuel xchꞌulel uc. Ti cꞌalal iꞌoch ti cremotique, chamem xaꞌox la cꞌot staic ti antse, ba la smuquic. Jun la smuquenal xchiꞌuc ti smalale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ixiꞌic la tajmec scotol ti muchꞌutic xchꞌunoj li scꞌop Rioxe xchiꞌuc la ti muchꞌutic iyaꞌi ti xꞌelan ichamique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Li apoxtoletique ep la ta echꞌel iyaqꞌuic iluc slequilal syuꞌelal Riox tey ta Jerusalene. Scotol la cꞌacꞌal tey ta stsob sbaic ta scorirolal mucꞌta templo yoꞌ Salomón sbie. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ti yan xchiꞌilique lec la iyilic ti cꞌusitic ispas li apoxtoletique pero ta la xiꞌic ti ta stsob sba xchiꞌuquique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jujun la cꞌacꞌal ipꞌol ti muchꞌutic ixchꞌun li scꞌop Rioxe. Ep la viniquetic ixchꞌunic, ep la antsetic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ti muchꞌutic ipe isloqꞌuesic la tal ta caya xchiꞌuc stemic, xchiꞌuc spopic, yoꞌ bu ch-echꞌ li Pedroe. ―Acꞌu mi mu xpaj, acꞌu mi snacꞌobaluc noꞌox chcꞌot ta sba li jchameletique, ta onox xꞌechꞌ o li chamele ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ti muchꞌutic tey nacajtic ta yantic jteclum ta tsꞌel Jerusalene, ep la tey icꞌotic uc. Iyiqꞌuic la echꞌel yajchamelic uc xchiꞌuc la ti muchꞌutic ta xꞌilbajinatic yuꞌun ti pucujetic ochem ta yoꞌonique. Lec la icom scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pero ti totil palee xchiꞌuc ti muchꞌutic tey xchiꞌuquic ti coꞌol jsaduceoetique, iyitꞌixanic la ti cꞌalal iyilic ti jaꞌ ichꞌbilic ta mucꞌ li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Itsaqueic la, iꞌiqꞌueic la echꞌel ta cavilto, itiqꞌueic la ta chuquel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ta acꞌubaltique ital la jun anjel ta vinajel, jaꞌ la isjam ti tiꞌ chuclebale, iloqꞌuesatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Batanic ta tiꞌ mucꞌta templo, ba albeic lachiꞌilique ti xuꞌ ch-acꞌbatic scuxlejalic ta sbatel osil yuꞌun ti Jesucristoe ―xꞌutatic la yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cꞌalal isacub ti osile, tey la ba chanubtasvanicuc ta tiꞌ mucꞌta templo chac cꞌu chaꞌal iꞌalbatique. Ti totil palee xchiꞌuc ti jsaduceoetique istsobic la scotol ti jmeltsanejcꞌopetic yuꞌun li jꞌisraeletique. Ti cꞌalal stsoboj xaꞌox la sbaique, jaꞌo la istaquic echꞌel jayvoꞌ jchabiejtemplo ta chuclebal, ba la sloqꞌueselic tal li apoxtoletique. Ti yalojique, tey to la chucajtic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ti cꞌalal icꞌotic ta chuclebal ti jchabiejtemploe, mu xa la bu tey istaic li jchuqueletique. Isutic la tal yoꞌ bu ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Lec macal ijtaticotic li tiꞌ chuclebale. Tey vaꞌajtic noxtoc li solteroetique. Ti cꞌalal ijamticotique, mu xa muchꞌu tey ―xiic la cꞌotel ti jchabiejtemploe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ti cꞌalal iyaꞌiic ti totil paleetique xchiꞌuc ti totil jchabiejtemploe ―¿Cꞌu to xi ta xpaj cuꞌuntic? ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","―Li viniquetic atiqꞌuic ta chuquele tey xa ta xchanubtasvanic ta tiꞌ mucꞌta templo ―xi la cꞌotel jun vinic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cꞌalal iyaꞌi ti totil jchabiejtemploe xchiꞌuc ti xchiꞌiltaque, ora la ba yiqꞌuelic tal li apoxtoletique. Tucꞌ la iꞌiqꞌueic tal, muc la xmajeic tal ta be, yuꞌun la ixiꞌic ti jchabiejtemploe mi xꞌacꞌbatic ton yuꞌun ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ti cꞌalal cꞌot svaꞌanelic ta stojol ti jmeltsanejcꞌopetique ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tsots lacalbeic ti mu xa xavalbeic scꞌoplal ti Jesuse. Pero lavi noxtoque iyaꞌiic xa ta sjunlej Jerusalén. Voꞌoticotic jcuchojticotic avuꞌunic ti imile ti vinic chavalique ―xꞌutatic la yuꞌun ti totil palee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Itacꞌavic la xchiꞌuc xchiꞌiltac li Pedroe: ―Persa jaꞌ ta jchꞌunticotic cꞌusi yaloj ti Rioxe, maꞌuc ta jchꞌunticotic cꞌusi chal li crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ti Riox yichꞌojic ta mucꞌ ti voꞌne moletique, jaꞌ ixchaꞌcuxes loqꞌuel ta smuquenal ti Jesuse, jaꞌ ti muchꞌu avaqꞌuic ta milel ta cruze. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ti Rioxe iyacꞌ xa ta ichꞌel ta mucꞌ ti Jesuse, tey xa chotol ta sbatsꞌicꞌob. Jaꞌ xa ta spas mantal. Jaꞌ istoj jmultic. Jaꞌ chiscoltaotic ta yictael li cꞌusitic chopole, chiyacꞌbotic pertonal yuꞌun li jmultique, voꞌotic li jꞌisraelotique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Voꞌoticotic rexticooticotic ti acꞌbil yabtel yuꞌun Riox ti Jesuse. Jaꞌ rextico ti Chꞌul Espíritu uque. Yuꞌun iꞌacꞌbat xa xchiꞌinic yuꞌun ti Rioxe ti muchꞌutic yichꞌojic xa ta mucꞌ ti Cajvaltic Jesuse ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ti cꞌalal iyaꞌiic ti xꞌelan itacꞌavique, icapic la tajmec ti jmeltsanejcꞌopetique, jutuc xa la muc xmilvanic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jaꞌo la ivaꞌi ta ora jun vinic, ochem la ta fariseoal, jmeltsanejcꞌop la uc, Gamaliel la sbi. Jaꞌ la jun ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Ichꞌbil la ta mucꞌ tajmec yuꞌun scotol xchiꞌiltac ta israelal. Jaꞌ la iyal ti acꞌu loqꞌuicuc jliqueluc li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ti cꞌalal iloqꞌuique ―Jchiꞌiltactic, voꞌotic li jꞌisraelotique, acꞌu jnoptic lec ti cꞌusi ta jchaꞌletic li jchiꞌiltactique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yuleso ta ajolic cꞌu xꞌelan ti Téudas ti ta voꞌnee. Isnop ti xuꞌ ta spojbe yabtel ti jyuꞌele. Istsob chanib cien svinic, pero imile. Ti cꞌalal ilaje, ixchꞌaculan sba scotol ti svinique, tey xa ilaj o cꞌop. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsꞌacal to isliques cꞌop noxtoc jun vinic, Judas sbi. Tey liquem tal ta Galilea. Jaꞌo yora isloqꞌues mantal ti jyuꞌele ti acꞌu stsac sbiic li crixchanoetique, jaꞌ chac cꞌu chaꞌal li censoe. Ep ixchꞌunic cꞌusi iyal ti Judase, pero imile noxtoc. Ti cꞌalal ilaje, ixchꞌaculan sba scotol ti svinique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yechꞌo un chacalbeic, mu me yaꞌuc quilbajintic li jchiꞌiltactique. Acꞌu spasic ti cꞌusi chal yoꞌonique. Mi crixchano sliquesoj li cꞌusi chalique xchiꞌuc li cꞌusitic tspasique, ta onox xchꞌay. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero mi Riox sliquesoje, mu onox xchꞌay. Yechꞌo un jnoptic me lec, yicꞌal me jaꞌ ta jcrontaintic ti Rioxe ―xut la xchiꞌiltac ta meltsanejcꞌop ti Gamaliele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ixchꞌun la scotolic ti cꞌusi iyal ti Gamaliele. Ti cꞌalal laj yal yeche, jaꞌo la iꞌiqꞌueic ochel li apoxtoletique. Iꞌacꞌbatic la arsial. Tsots la iꞌalbatic ti mu xa yaꞌuc yalbeic scꞌoplal ti Jesuse. Ti cꞌalal ilaje, icoltaatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ti cꞌalal iloqꞌuic tal yoꞌ bu ti jmeltsanejcꞌopetique, xmuyubajic xa la tajmec ti yech iscꞌan Riox ti jaꞌ abol o sbaic ti yichꞌojic ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Muc la xicta o sbaic ta yalbel scꞌoplal ti Jesucristoe. Scotol la cꞌacꞌal ichanubtasvanic ta tiꞌ mucꞌta templo xchiꞌuc ta naetic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti cꞌalal ipꞌol xaꞌox ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe, tey la jꞌisraeletic ti xchanojic griego cꞌope, xchiꞌuc la jꞌisraeletic ti ta xcꞌopojic ta ebreo cꞌope, jaꞌ ti scꞌopic onox jꞌisraeletic ti ta más voꞌnee. Ti muchꞌutic chcꞌopoj ta griegoe istiqꞌuic la mulil yuꞌun la chopol iyaꞌiic ti mu sta sveꞌelic jujun cꞌacꞌal ti meꞌanal antsetic tey xchiꞌuquique. Jaꞌ iticꞌbat smulic ti muchꞌutic chcꞌopoj ta ebreoe yuꞌun la jaꞌ scuentainojic veꞌlil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Li lajchavoꞌ apoxtoletique istsobic la scotol ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe. ―Li voꞌoticotique chopol mi ta xquictaticotic yalel aꞌyuc li scꞌop Rioxe ti jcuentainojticotic noxtoc li veꞌlile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jchiꞌiltactic, tꞌujic vucvoꞌuc ti muchꞌutic lec avilojique, ti muchꞌutic pꞌijubtasbilic yuꞌun ti Chꞌul Espíritue ti jaꞌ ta scuentainic li veꞌlile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Li voꞌoticotique ta jcꞌoponticotic Cajvaltic, ta xcalticotic noxtoc ti cꞌusi yaloje ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ti cꞌusi iꞌalbatique, lec la iyaꞌi scotolic. Jaꞌ la istꞌujic ti ánima Estebane, yuꞌun la sjunul yoꞌon yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe. Pꞌijubtasbil la yuꞌun ti Chꞌul Espíritue. Istꞌujic la vacvoꞌ noxtoc. Ti sbiique jaꞌ la liꞌi: Felipe, xchiꞌuc Prócoro, xchiꞌuc Nicanor, xchiꞌuc Timón, xchiꞌuc Parmenas, xchiꞌuc Nicolás. Ti Nicolase liquem la tal ta jteclum Antioquía. Maꞌuc la jꞌisrael uc. Jaꞌ toꞌox la yech xchꞌunoj chac cꞌu chaꞌal xchꞌunoj li jꞌisraeletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ti cꞌalal laj stꞌujique, iyiqꞌuic la tal yoꞌ bu tsobol li apoxtoletique. Li apoxtoletique iscꞌoponbeic la Riox ti acꞌu coltaaticuque. Iyacꞌ la scꞌobic ta sjol ti vucvoꞌe, jaꞌ la seña ti ta xtunique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ta Jerusalene más la ipꞌol ti muchꞌutic iyichꞌ ta mucꞌ ti Cajvaltic Jesucristoe. Ep la paleetic ixchꞌunic noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ti ánima Estebane lec la tajmec yoꞌon, acꞌbil la syuꞌel, ep la ta echꞌel iyacꞌ iluc slequilal syuꞌelal Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tey la jayvoꞌ jꞌisraeletic, liquemic la tal ta jteclum Cirene, xchiꞌuc ta jteclum Alejandría, xchiꞌuc ta estado Cilicia, xchiꞌuc ta estado Asia. “Loqꞌuemic ta Mozoil” sbitac ti stemploique. Ti jayvoꞌ istsob sbaique ilic la sjolic, oy la cꞌusi iyalulanbeic ti ánima Estebane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero muc la xcuch yuꞌunic, mu xa la snaꞌic cꞌuxi chtacꞌavic, jaꞌ la ti pꞌijubtasbil yuꞌun Chꞌul Espíritu ti ánima Estebane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Istojic la jayvoꞌ jticꞌcꞌop yuꞌun la tsnopbeic smul ti ánima Estebane. Ipꞌijubtasatic la ti cꞌusi chalique. ―Jaꞌ me yech xavalbeic li jchiꞌiltactique: “Caꞌyojticotic ti yech chal li Estebane ti mu xa bu chtun ti cꞌusitic iyal ti Moisese xchiꞌuc ti cꞌusitic iyal ti Rioxe”, xavutic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ti cꞌalal laj pꞌijubtasaticuc ti jticꞌcꞌopetique, ba la yalbeic ti xchiꞌiltaque, icap o la sjolic li jꞌisraeletique, xchiꞌuc la jayvoꞌ jmeltsanejcꞌop, xchiꞌuc la jayvoꞌ ti muchꞌutic ta xchanubtasvanic yilel ta smantaltac Rioxe. Ti cꞌalal chꞌayem yoꞌon ti ánima Estebane, jaꞌo la istsaquic. Iyiqꞌuic la echꞌel yoꞌ bu ti jmeltsanejcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","―Li jchiꞌiltic liꞌi chal ti ta la xlom li jtemplotique, ti ta la xjel li mantaletique. Mu xicta sba ta yalel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Ti Jesus Nazarete ta slomes li templo liꞌi, ta sjel jcostumbretic ti isliques ti Moisese”, xi li jchiꞌiltic liꞌi ―xi la ti jticꞌcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ti jmeltsanejcꞌopetic tey chotajtique isqꞌuelbeic la sat ti ánima Estebane. Ti sate coꞌol la xchiꞌuc sat anjel ta vinajel iyilic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","―¿Mi yech li cꞌusi chal li jchiꞌiltactic liꞌi? ―xꞌutat la yuꞌun totil pale ti ánima Estebane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Itacꞌav ti ánima Estebane: ―Jtotic moletic, jchiꞌiltactic, ta xcal avaꞌiic. Ti Riox ta vinajele oy syuꞌel, oy xojobal. Iyacꞌ sba iluc ta stojol ti jmolmucꞌtatotic Abraam ti ta más voꞌnee ti cꞌalal tey nacal ta Mesopotamiae, ti cꞌalal mu toꞌox chba nacluc ta jteclum Arane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Locꞌan echꞌel liꞌ ta alumale, comtsano atot ameꞌ xchiꞌuc achiꞌiltac. Batan ta yan balamil ti bu chcacꞌ avile”, xꞌutat yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jaꞌo ilocꞌ ta Caldea ti Abraame, tey ba nacluc ta Arán. Tey icham ti stote. Iꞌalbat noxtoc yuꞌun ti Rioxe ti chlocꞌ teyoꞌe. Liꞌ itaque tale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ti Abraame muc xꞌacꞌbat jsetꞌuc yosil yuꞌun ti Rioxe. Ti bu inaquie xchꞌom noꞌox. Voꞌotic onox scꞌoplal ta xquichꞌtic li balamil liꞌi ti smomotique yuꞌun jaꞌ yech iꞌalbat yuꞌun ti Rioxe. Ti cꞌalal iꞌalbate, chꞌabal toꞌox xchꞌamal. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iꞌalbat noxtoc yuꞌun ti Rioxe ti baꞌyi chba nacluc ta yan o balamil ti smomtaque, ti tey ta smozoinatic chanib cien jabile. Tol svocolic; tsots ch-abtejic pero muc bu ta xtojeic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Voꞌon ta xcacꞌbe castico ti muchꞌutic ta smozoinvane. Ti cꞌalal stsꞌaqui ti chanib cien jabile, ta xloqꞌuic tal scotol ti amomtaque. Liꞌ chul yichꞌicon ta muqꞌue”, xꞌutat yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ti Abraame iꞌalbat yuꞌun ti Rioxe ti persa chichꞌic circuncisione. Yechꞌo un ti cꞌalal iꞌayan screm ti Abraame, jaꞌ ti Isaaque, ta svaxaquibal cꞌacꞌal yayanel iyacꞌbe circuncisión. Jaꞌ yech ispasulanic o. Ti cꞌalal iꞌayan screm ti Isaaque, jaꞌ ti Jacove, iyacꞌbe circuncisión uc. Ti cꞌalal iꞌayan scremotic ti Jacove, iyacꞌbe circuncisión uc, jaꞌ ti lajchavoꞌ jmucꞌtatotic ti ta más voꞌnee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ti jmucꞌtatotic ti ta más voꞌnee scoj yitꞌixal yoꞌonic ti ixchonic echꞌel ta Egipto ti yitsꞌinique, jaꞌ ti Josee. Ti Josee qꞌuelbil onox yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ti jayꞌechꞌel iꞌilbajinat ti Josee, icoltaat yuꞌun ti Rioxe. Ipꞌijubtasat, yechꞌo ti lec iꞌile yuꞌun ti preserente ta Egiptoe. Itiqꞌue ta coviernoal ti Josee, ispas mantal ta sjunlej Egipto. Iscuentainbe sna noxtoc ti preserentee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tsꞌacal to ital tsots viꞌnal ta sjunlej Egipto xchiꞌuc liꞌ ta Canaane. Abol sba tajmec ti crixchanoetique. Ti voꞌne moletique mu xa bu ista sveꞌelic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ti Jacove iyaꞌi ti oy trigo ta Egiptoe, istac echꞌel scremotic. Jaꞌto iꞌayic o. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ti cꞌalal ibatic ta xchaꞌechꞌelale, ti Josee iyacꞌ sba ta ojtiquinel. “Voꞌon Joseon ti achonicon tal liꞌ ta Egiptoe”, xut ti sbanquiltaque xchiꞌuc ti yitsꞌine. Ti preserentee jaꞌto iyojtiquinbe sbanquiltac xchiꞌuc yitsꞌin ti Josee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ti Josee istac ta iqꞌuel ti stote, jaꞌ ti Jacove. Ibat scotolic. Xchiꞌuc ti xchꞌamalique oy setenta y cinco. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jaꞌ yech ibat ta Egipto ti Jacove, tey icham. Tey icham ti voꞌne moletic uque, jaꞌ ti scremotic Jacove. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Liꞌ tal smuquic scotol ta nailchꞌen ta Siqueme yoꞌ bu smanoj ti Abraame. Jaꞌ ti ismanbe ti scremotic Amor ta Siqueme. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ti cꞌalal poꞌot xaꞌox xichꞌ yosilic ti moletique ti albil onox yuꞌun Riox ti Abraame, pꞌolemic xaꞌox tajmec ta Egiptoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tsꞌacal to iꞌoch achꞌ preserente ta Egiptoe pero muc xa xꞌojtiquine ti Josee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ti achꞌ preserentee iloꞌlovan. Iꞌilbajinatic tajmec ti voꞌne moletique. Ti preserentee isloqꞌues mantal ti acꞌu jipbatuc ta ucꞌum acꞌu chamuc scotol yunencremic ti voꞌne moletique. Ti xꞌelan iyal ti preserentee, yuꞌun mu scꞌan ti ta xpꞌol ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti cꞌalal yech sloqꞌuesoj mantal ti preserentee, jaꞌo iꞌayan ti Moisese. Lec iꞌile yuꞌun Riox ti Moisese. Oxib u tey ta sna ti stot smeꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Cꞌalal isloqꞌuesic ti acꞌu chamuque, itae yuꞌun stseb ti preserentee. Istsꞌites, ispꞌis ta yol. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ti Moisese ipꞌijub chac cꞌu chaꞌal ti jꞌegiptoetique. Lec snaꞌ xcꞌopoj, lec snaꞌ cꞌu spasel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ti cꞌalal oy xa chaꞌvinic sjabilal ti Moisese, tscꞌan chba svulaꞌan ti xchiꞌiltaque, jaꞌ ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ti cꞌalal ibate, iyil ti imajbat jun xchiꞌil yuꞌun jun jꞌegiptoe. Ti Moisese ismil ti jꞌegiptoe, jaꞌ ispoj ti xchiꞌile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ti Moisese isnop ti snaꞌoj xa xchiꞌiltac ti jaꞌ stꞌujoj Riox ta xloqꞌuesvan ta mozoile, pero mu snaꞌic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta yocꞌomal noxtoc ti Moisese iyil ti chut sbaic chaꞌvoꞌ xchiꞌiltaque, ba spajes. “¿Cꞌu yuꞌun ti chamaj abaique yuꞌun achiꞌil abaic?” xut. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ijavcꞌunat ox yuꞌun ti muchꞌu isliques cꞌope. “¿Muchꞌu layacꞌbe avabtel? Maꞌuc preserenteot. Maꞌuc jmeltsanejcꞌopot. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Miꞌn avoꞌonuc amilon avaꞌi chac cꞌu chaꞌal amil ti jun jꞌegipto voljee?” xꞌutat. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cꞌalal iyaꞌi ti Moisese ti vinajem xa ti imilvane, ijatav. Tey tal nacluc ta Madián. Tey isaꞌ yajnil, tey iꞌayan chaꞌvoꞌ screm. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Cꞌalal laj xaꞌox chaꞌvinic jabil syulel ta Madián ti Moisese, jaꞌo iyil ta xcꞌacꞌ jtecꞌ cꞌox chꞌix ta vits Sinaí ta xocol balamil. Iyil ta lebcꞌocꞌ ti Rioxe, coꞌol xchiꞌuc anjel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ti cꞌalal iyil ti mu xꞌan ti cꞌox chꞌixe, ichꞌay o yoꞌon. Inopoj echꞌel, ba sqꞌuel. Cꞌalal nopol xae, iyaꞌi icꞌopoj ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Voꞌon ti liyichꞌic ta mucꞌ ti amucꞌtatotac ti ta más voꞌnee, jaꞌ ti Abraame, xchiꞌuc ti Isaaque, xchiꞌuc ti Jacove”, xi. Ti Moisese xtꞌelelet xa ta xiꞌel, muc sqꞌuel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mu xuꞌ xtal anopon xchiꞌuc laxonobe, locꞌo. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Quiloj ti mozoinbil lachiꞌiltac ta Egiptoe, voꞌoxuc ti jtꞌujojoxuque. Jnaꞌoj ti abol sbaic tajmeque, yechꞌo ti liyal tale yuꞌun tal jloqꞌues ta scꞌob li jꞌegiptoetique. Batic ta Egipto”, xꞌutat yuꞌun Riox ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Jaꞌ ti Moisese ti muc xꞌichꞌe ta mucꞌ yuꞌun ti jchiꞌiltactic ta israelale, “¿Muchꞌu layacꞌbe avabtel? Maꞌuc preserenteot, maꞌuc jmeltsanejcꞌopot”, ti xꞌutate. Ti Rioxe istac echꞌel yuꞌun jaꞌ stotic chcꞌot yuꞌun jaꞌ ta xloqꞌuesvan. Jaꞌo itaque echꞌel yuꞌun ti Rioxe ti cꞌalal iyil ta jtecꞌ cꞌox chꞌixe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jaꞌ isloqꞌues tal ta Egipto ti voꞌne moletique. Ep ta echꞌel iyacꞌ iluc slequilal syuꞌelal Riox tey ta Egiptoe. Tsꞌacal to iyacꞌ iluc slequilal syuꞌelal Riox tey ta Tsajal Nab. Chaꞌvinic jabil iyacꞌ iluc slequilal syuꞌelal Riox ta xocol balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jaꞌ ti Moisese ti jaꞌ yech iyalbe ti voꞌne moletique: “Ti Rioxe ta to xastꞌujbeic jun jꞌalcꞌop ta tsꞌacal. Jchiꞌiltic ta stꞌuj chac cꞌu chaꞌal li voꞌone. Xachꞌunbeic me ti cꞌusi chayalbeique”, xi onox ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaꞌ onox ti Moisese ti ixanav ta xocol balamil xchiꞌuc ti voꞌne moletique. Ti moletique istsob sbaic ta yoc vits Sinaí. Tey icꞌoponat noxtoc yuꞌun Riox ti Moisese. Ti cꞌalal iyaꞌi cꞌusi iꞌalbat yuꞌun ti Rioxe, iyalbe ti moletique. Jaꞌ iyalbe ti cꞌusitic tscꞌan Riox ta spasique yoꞌ xcuxiic o ta sbatel osile. Ti icaꞌitic li voꞌotic uque, jaꞌ ti istsꞌiba comel ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ti voꞌne moletique muc xchꞌunic ti cꞌusi iyal ti Moisese yuꞌun ta stoy onox sbaic. Chac suticuc echꞌel ta Egipto. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Meltsano cajsantoticotic”, xutic liquel ti Aarone. “Yuꞌun jaꞌ babe ta xbat cuꞌunticotic. Ti Moisese mu jnaꞌticotic cꞌusi ispas ti yilel mu sut tale, jaꞌ ti muchꞌu lisloqꞌuesoticotic tal ta Egiptoe”, xiic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yechꞌo un ismeltsanbeic slocꞌol becerro. Ismilbeic smoton. Lec iyilic ti cꞌusi ismeltsanique, iyichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yechꞌo ti icoltaatic echꞌel yuꞌun ti Rioxe, jaꞌ iꞌacꞌbat yichꞌic ta mucꞌ li cꞌusitic oy xojobal ta vinajele. Jaꞌ yech istsꞌibaic ti yajꞌalcꞌoptac Rioxe: Jchiꞌiltactic, ti cꞌalal ixanavic tal chaꞌvinic jabil ta xocol balamil ti baꞌyi jtot jmeꞌtique, yech noꞌox la ti iyacꞌbeic smotonin vacax xchiꞌuc chij ti Rioxe, yuꞌun la mu sjunuluc yoꞌonic iyichꞌic ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yuꞌun la iscuchic tal ti yajsantoic Moloc sbie, istiqꞌuic la tal ta caxa. Iyichꞌic la tal noxtoc slocꞌol cꞌanal ti jaꞌ yichꞌojic ta muqꞌue, ti Renfán sbie. Ti cꞌusitic islocꞌtaique, jaꞌ la iyichꞌic ta mucꞌ. Ti jaꞌ noꞌox yech chapasic uque, ta la xaloqꞌuic echꞌel liꞌ ta jlumaltique. Chabatic la ta sjelavel jteclum Babilonia, xi onox tsꞌibabil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Cꞌalal teic ta xocol balamil ti voꞌne moletique, jaꞌ itun yuꞌunic ti templo nucule, jaꞌ tey icꞌoponatic yuꞌun ti Rioxe. Ti templo ispasique jaꞌ yech ispasic chac cꞌu chaꞌal iꞌacꞌbat yil yuꞌun Riox ti Moisese. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ti cꞌalal iꞌiqꞌueic tal yuꞌun Josué liꞌ ta jlumaltique, iscuchic tal ti templo nucule. Pero oy toꞌox yajvaltac li osile. Ti Rioxe iyal ti acꞌu smilic scotole yuꞌun icoltavan onox. Jaꞌ yech istaic o li osile. Ti cꞌalal iꞌoch ta preserente ti Davide, jaꞌ toꞌox ta xtunilan yuꞌunic ti templo nucule. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ti Davide lec iꞌile yuꞌun ti Rioxe. Iscꞌanbe ti tsvaꞌanbe stemploe. Jaꞌ ti Riox iyichꞌ ta mucꞌ ti jmucꞌtatotic Jacove. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero maꞌuc isvaꞌan ti Davide; jaꞌ xa isvaꞌan ti screme, jaꞌ ti Salomone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ti Rioxe mu xnaqui ta templo ti smeltsanoj crixchanoe yuꞌun tey ta vinajel. Jaꞌ yech iyal ti jun yajꞌalcꞌope: ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ti Rioxe jaꞌ la tspas mantal ta vinajel ta balamil. ¿Cꞌu la yuꞌun ti ta jvaꞌanbetic stemploe, yuꞌun la mu snaꞌ xnaqui? ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jaꞌ la spasoj scotol li cꞌusitic oye, xi ti jꞌalcꞌope. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Li voꞌoxuque atoyoj abaic chac cꞌu chaꞌal ti muchꞌutic mu xichꞌ ta mucꞌ ti Rioxe. Mu xacꞌan xachꞌunic li cꞌusi chale. Scotol cꞌacꞌal chacrontainic ti Chꞌul Espíritue. Jaꞌ yech chapasic uc chac cꞌu chaꞌal ispasic ti voꞌne moletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","53","Ti moletique iscrontainic scotol ti yajꞌalcꞌoptac Riox ti ta voꞌnee. Ismilic ti muchꞌutic iyal ti chtal ti muchꞌu lec yoꞌone. Cꞌalal ital ti muchꞌu lec yoꞌone, avaqꞌuic onox ta milel, voꞌoxuc ti avaꞌyojic mantaletic ti iyalic anjeletic ti ta voꞌnee, pero mu xachꞌunic ―xut la jmeltsanejcꞌopetic ti ánima Estebane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ti xꞌelan iyal ti ánima Estebane, icap o la sjolic. Xcꞌuxuxet xa la yeic yuꞌun scꞌacꞌal yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ti ánima Estebane tsatsubtasbil la yoꞌon yuꞌun ti Chꞌul Espíritue, isqꞌuel la vinajel. Iyilbe la xojobal ti Rioxe. Iyil la ti tey vaꞌal ta sbatsꞌicꞌob Riox ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","―Jamal chquil li vinajele. Tey ta sbatsꞌicꞌob Riox chquil li Jesuse, jaꞌ ti coꞌol crixchanootic jchiꞌuctique ―xi la ti ánima Estebane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ti jmeltsanejcꞌopetique chopol la iyaꞌiic ti xꞌelan iyal ti ánima Estebane. Xꞌavlajetic xa la. Ismac la xchiquinic, mu la scꞌan xaꞌiic ti cꞌusi chal ti ánima Estebane, yuꞌun la isnopic ti chopol chaꞌi ti Rioxe. Jaꞌo la iscomontsaquic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Istsaquic la loqꞌuel ta tiꞌ jteclum, ba la yacꞌbeic ton. Ti cꞌalal iyaqꞌuic tone, islocꞌ la spimilcꞌuꞌic. Iyacꞌbeic la xchabi jun svaꞌlej crem, Saulo la sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ti cꞌalal xyaquet chichꞌ ton ti ánima Estebane ―Cajval Jesús, chamicon xa ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Isquejan la sba, tsots la icꞌopoj. ―Cajval, acꞌo ta pertonal li jchiꞌiltac liꞌi yuꞌun mu snaꞌic li cꞌusi tspasique ―xi la. Cꞌalal laj yal yeche, jaꞌo la ilocꞌ xchꞌulel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Li Sauloe ―Más lec ti ichame ―xi la uc. Lic la yilbajin ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesucristo ta Jerusalene. Istani la sbaic ta scoj ti ilbajinele. Ti jlome istani la sbaic ta sjunlej estado Judea. Ti jlome ibatic la ta estado Samaria. Stuquic xa la tey icomic ta Jerusalén li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oy la jayvoꞌ viniquetic ti sjunul yoꞌon yichꞌojic ta mucꞌ ti Rioxe, jaꞌ la ba smuquic ti Estebane. Iyoqꞌuitaic la tajmec. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Li Sauloe yoꞌonuc la xchꞌaybe scꞌoplal ti muchꞌutic yichꞌojic ta mucꞌ ti Jesuse. Iꞌoch la ta naetic, istsac la loqꞌuel ti viniquetique xchiꞌuc ti antsetique, isticꞌ la ta chuquel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ti muchꞌutic istani sbaique, buyuc noꞌox la iyalic aꞌyuc ti jaꞌ chacꞌ jcuxlejaltic ta sbatel osil ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ti Felipee tey la ibat ta jun jteclum ta estado Samaria. Cꞌot la yalbe ti crixchanoetique ti iꞌay xa ti muchꞌu stꞌujoj Riox tspasvan ta mantale, jaꞌ ti Cristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ti crixchanoetic teyoꞌe istsob la sba scotolic, tal la yaꞌiic cꞌusi chal ti Felipee. Ti cꞌalal iyilic ti ep ta echꞌel iyacꞌ iluc slequilal syuꞌelal Riox ti Felipee, tsꞌijajtic xa la chaꞌiic ti cꞌusi iyale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ti muchꞌutic ochem pucuj ta yoꞌonique isloqꞌuesbe la. Ti cꞌalal ilocꞌ ti pucujetique, tsots la iꞌavanic. Ti muchꞌutic alubem jun yoc scꞌobe xchiꞌuc ti coxoetique, ilecubic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Xmuyubajic xa la scotol ti crixchanoetic tey ta jteclume. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tey la jun vinic, Simón la sbi. Jꞌilol toꞌox la, snaꞌ la májico noxtoc. Ep la isloꞌlo crixchanoetic tey ta Samariae yuꞌun la iyal ti oy syuꞌel uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Scotol crixchanoetic, ta biqꞌuit ta mucꞌ, iyichꞌic la ta mucꞌ ti jꞌilole. ―Li vinic liꞌi coꞌol syuꞌel xchiꞌuc ti Rioxe ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jaꞌ xa la yichꞌojic ta mucꞌ ti jꞌilole yuꞌun la voꞌne xa lic loꞌloaticuc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero cꞌalal iꞌalbatic yuꞌun ti Felipee ti jaꞌ stꞌujoj Riox chispasotic ta mantal ti Jesuse, ti jaꞌ istoj jmultique, ep la viniquetic, ep la antsetic ixchꞌunic. Ti ixchꞌunique, iꞌacꞌbat la yichꞌic voꞌ yuꞌun ti Felipee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ixchꞌun la ti Simón uque, iyichꞌ la voꞌ uc, jaꞌ la ixchiꞌin echꞌel ti Felipee. Cꞌalal iyil ti ep ta echꞌel iyacꞌ iluc slequilal syuꞌelal Riox ti Felipee, xchꞌayet xa la yoꞌon. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Cꞌalal iyaꞌi li apoxtoletic ta Jerusalene ti ixchꞌunic xa cꞌusi yaloj Cajvaltic Jesucristo li jsamariaetique, itaqueic la echꞌel ta Samaria li Pedroe xchiꞌuc li Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ti cꞌalal icꞌotique, iscꞌoponbeic la Riox ti jaylajunvoꞌ ixchꞌunique yoꞌ la xchiꞌineic o yuꞌun ti Chꞌul Espíritu uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yuꞌun la mu toꞌox bu chiꞌinbilic yuꞌun ti Chꞌul Espíritue, jaꞌ noꞌox la ti yichꞌojic xa voꞌ ta scuenta ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Li Pedroe xchiꞌuc li Juane iyacꞌ la scꞌobic ta sjol jujun ti muchꞌutic ixchꞌune, jaꞌ la ichiꞌineic o yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Cꞌalal iyil ti Simone, yoꞌonuc xa la yacꞌbe taqꞌuin li apoxtoletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","―Acꞌbecon jyuꞌel yech uc yoꞌ xichꞌic o cuꞌun Chꞌul Espíritu li muchꞌutic ta xcacꞌ jcꞌob ta sjolic uque ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","―Batan ta cꞌocꞌ xchiꞌuc lataqꞌuine yuꞌun chaval ti stacꞌ manel ti Chꞌul Espíritue ti chacꞌ jchiꞌintic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Li voꞌote mu xuꞌ chatun yuꞌun ti Rioxe yuꞌun yiloj ti chaloꞌlovane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ictao xa spasel li cꞌusitic chopole. Cꞌopono Riox, jqꞌueltiquic mi xaꞌacꞌbat to pertonal yuꞌun li cꞌusi chopol chanope. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yuꞌun chavacꞌ o scꞌacꞌal avoꞌon chquil ti oy jyuꞌelticotique. Tiqꞌuilot to ta mulil ―xꞌutat la yuꞌun li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","―Cꞌoponbecon Riox cheꞌe naca me ochicon ta cꞌocꞌ ta sbatel osil chac cꞌu chaꞌal avalbone ―xi la ti Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Li Pedroe xchiꞌuc li Juane, cꞌalal laj yalbeic crixchanoetic scotol ti cꞌu xꞌelan yilojbeic slequilal syuꞌelal ti Rioxe, xchiꞌuc ti cꞌalal laj yalic li scꞌop Rioxe, isutic la ta Jerusalén. Echꞌ la yalic noxtoc ta jujun parajel ta estado Samaria ti jaꞌ chacꞌ jcuxlejaltic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ti Felipee icꞌoponat la yuꞌun jun anjel ta vinajel: ―Batan ta xocon vinajel ta sur. Tey chanupbe li sbelel jteclum Gazae, jaꞌ li be chlic tal ta Jerusalene ―xꞌutat la. Li sbelel Gazae tey ch-echꞌ ta xocol balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ibat la ti Felipee. Tey la ista ta be jun jꞌetiopía. Ti yajpreserente jꞌetiopíaetique, ants la, Candace la sbi. Ti vinique pasbil la ta capón yuꞌun la ta xꞌabtej ta yabtel ti antse. Jaꞌ la xchabiojbe staqꞌuin xchiꞌuc cꞌusuc yuꞌun ti antse. Ti vinique ay la yacꞌbe smoton Riox ta Jerusalén. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jsutel xaꞌox la echꞌel ti cꞌalal itae yuꞌun ti Felipee. Jun la yoꞌon chotol echꞌel ta scarretacaꞌ. Yolel la tsqꞌuel echꞌel scꞌop Riox ti istsꞌiba ti Isaíase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","―Nopojan, chiꞌino echꞌel li vinic leꞌe ―xꞌutat la yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ti Felipee inopoj la. Iyaꞌi la ti yolel ta sqꞌuel scꞌop Riox ti istsꞌiba ti Isaías yajꞌalcꞌop Rioxe. ―¿Mi xavaꞌibe smelol li vun chaqꞌuele? ―xut la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","―Mu xcaꞌi yuꞌun muc muchꞌu xiyalbe smelol ―xi la. Iꞌiqꞌue la muyel ta carretacaꞌ ti Felipee. Ixchiꞌin la echꞌel ta chotlej. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Li scꞌop Riox ti yolel ta sqꞌuele, jaꞌ la yech chal: Chꞌan la xi ta milel chac cꞌu chaꞌal jcot chꞌiom chij, mu la cꞌusi chal. Jaꞌ la chac cꞌu chaꞌal chꞌan xi cꞌalal chlocꞌbat stsatsal li chije, jaꞌ noꞌox la yech ti muchꞌu chtal stojbotic jmultique, mu la cꞌusi chal ti cꞌalal xmilee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Abol la sba cuꞌuntic yuꞌun la muc bu lec ta smeltsanbat scꞌoplal. Tsnopic la ti jꞌechꞌel ta xchꞌay o scꞌoplal ti cꞌalal smilique, xi la li scꞌop Riox ti ta sqꞌuele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","―Albon caꞌi muchꞌu scꞌoplal ti liꞌ tsꞌibabile ―xꞌutat la ti Felipee―. ¿Mi scꞌoplal stuc ti Isaíase, mi yan o? ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","―Jaꞌ scꞌoplal ti Jesuse ―xut la ti Felipee. Lic la yalbe ti istoj xa jmultic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Icꞌotic la ta jun ucꞌum. ―Qꞌuelavil, oy liꞌ ucꞌume. ¿Mi mu xuꞌ xavacꞌbon quichꞌ voꞌ? ―xi la ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","―Mi jꞌechꞌel achꞌunoje, xuꞌ ―xi la ti Felipee. ―Jchꞌunoj ti jaꞌ Xchꞌamal Riox ti Jesucristoe ―xi la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ti vinique iyalbe la ti yajtijcaꞌe ti acꞌu spajes ti carretae. Ti vinique xchiꞌuc ti Felipee iyalic la, ibatic la ta ucꞌum. Iyichꞌ la voꞌ ti vinique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ti cꞌalal iloqꞌuic tal ta ucꞌume, ti Felipee iꞌiqꞌue la echꞌel yuꞌun ti Chꞌul Espíritue ti jun xchiꞌuc ti Cajvaltic Jesucristoe. Muc la xꞌile bu ibat. Ti vinique jun la yoꞌon isut ta slumal ti ixchꞌun xa ti itojbat xa smul yuꞌun ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ti Felipee tey la cꞌot vinajuc ta jteclum Azoto. Tey to la lic xanavuc. Ti bu iꞌech ta jujun jteclume, echꞌ la yal aꞌyuc ti jaꞌ chacꞌ jcuxlejaltic ti Cajvaltic Jesuse. Ibat la cꞌalal jteclum Cesarea. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Li Sauloe muc la xicta sba ta yilbajinel ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesuse. ―Chajmil mi mu xavicta abaique ―xut la. Ba la scꞌopon ti totil pale ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Iscꞌan la vun yoꞌ oy xa o yortene, jaꞌ la chcꞌot yacꞌbe yil ti jmeltsanejcꞌopetic ta bicꞌtal temploetic yoꞌ bu chaꞌiic smantal Riox ti xchiꞌiltac ta israelal ta jteclum Damascoe. Yuꞌun la jaꞌ chba sqꞌuel mi oy muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesucristo ta stemploique. Mi ants, mi vinic cꞌot stae, scꞌoplal la ti ta xchuc tal ta Jerusalene. Ti cꞌalal iyichꞌ ti vune, ibat la ta Damasco. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ti cꞌalal poꞌot xaꞌox la xcꞌot ta Damascoe, oy la cꞌusi xlebluj tal xojobal ta vinajel yoꞌ bu li Sauloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Iyal la ta lum, iyaꞌi la ti icꞌoponate: ―Saulo, ¿cꞌu yuꞌun ti chacrontainon yaꞌele? ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","―Cajval, ¿muchꞌuot cheꞌe? ―xut la. ―Voꞌon Jesuson ti chacrontainone. Ti xꞌelan chapase, avocol noꞌox chasaꞌbe aba ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Li Sauloe xtꞌelelet xa la ta xiꞌel. ―Cajval, ¿cꞌusi chacꞌan ti ta jpase? ―xut la. ―Lican, ochan echꞌel ta Damasco. Tey chaꞌalbat ti cꞌusi chapase ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ti xchiꞌiltac xchiꞌinoj echꞌel li Sauloe vaꞌ xiic la yuꞌun la ixiꞌic tajmec. Iyaꞌiic la ti oy muchꞌu icꞌopoje pero muc la xilic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Li Sauloe istam la sba. Cꞌalal isvicꞌ sate, mu xa la xil sbe. Nitbil xa la iꞌoch ta Damasco. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxib la cꞌacꞌal tupꞌem sat. Muc la xveꞌ, muc la xuchꞌ voꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tey la nacal ta Damasco jun vinic ti yichꞌoj ta mucꞌ ti Cajvaltic Jesuse, Ananías la sbi. Ti Cajvaltic Jesuse iyacꞌ la sba iluc ta stojol ti Ananíase. ―Ananías ―xꞌutat la. ―Cajval ¿cꞌusi chaval? ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","―Batan yoꞌ bu Tuqꞌuil caya sbie. Tey xacꞌot ta sna Judas. Tey chcꞌot ata jun achiꞌil, Saulo sbi, liquem tal ta jteclum Tarso. Lavie xyaquet ta scꞌopon Riox. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Icacꞌbe xa yil ti chcꞌot avacꞌ acꞌob ta sjole yoꞌ ti xchaꞌjam o li sate ―xꞌutat la ti Ananíase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ti cꞌalal iyaꞌi ti Ananíase ―Cajval, taje ep muchꞌutic yalojbon ti chilbajin ti muchꞌutic yichꞌojot ta mucꞌ tey ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Lavie yichꞌoj tal orten yuꞌun totil paleetic ti xuꞌ xchuc echꞌel li muchꞌutic yichꞌojot ta mucꞌ liꞌtoe ―xi la ti Ananíase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","―Batan. Li Sauloe jtꞌujoj onox yuꞌun jaꞌ chalbe cꞌusi caloj li muchꞌutic maꞌuc achiꞌilic ta israelale, xchiꞌuc li preserenteetique, xchiꞌuc voꞌoxuc ti coꞌol jꞌisraeloxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ta xcalbe ti voꞌon ta jcoj ti ep ta echꞌel ta xichꞌ ilbajinele ―xꞌutat la yuꞌun Cajvaltic Jesucristo ti Ananíase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ibat la ti Ananíase. Tey la icꞌot ta sna ti Judase. Ti cꞌalal iꞌoch ta yut nae, cꞌot la yacꞌ scꞌob ta sjol li Sauloe. ―Saulo, liꞌ listac tal ti Cajvaltic Jesuse ti coꞌol quichꞌojtic ta muqꞌue, jaꞌ ti muchꞌu avil ta bee. Listac tal yoꞌ ti xchaꞌjam o lasate, yoꞌ ti xaslecubtasbe o avoꞌon ti Chꞌul Espíritue ―xut la cꞌotel li Sauloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ora la ipꞌaj ti cꞌusi macal o toꞌox li sate, ijam la. Iꞌacꞌbat la yichꞌ voꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ti cꞌalal iveꞌe, itsatsub la noxtoc. Tey la ixchiꞌin jayib cꞌacꞌal ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristo ta Damascoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Li Sauloe ora la lic yal aꞌyuc ta jujun templo yoꞌ bu chaꞌiic smantal Riox ti xchiꞌiltac ta israelale ti jaꞌ Xchꞌamal Riox ti Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Scotol ti muchꞌutic iyaꞌiic ti jaꞌ xa yech chal li Sauloe, xchꞌayet xa la yoꞌonic. ―Li jchiꞌiltic leꞌe jaꞌ li muchꞌu iyilbajin ti muchꞌutic yichꞌoj ta mucꞌ ti Jesuse ti tey nacajtic ta Jerusalene. Liꞌ xa noxtoque yuꞌun tal xchuc echꞌel li muchꞌutic jaꞌ yech xchꞌunojique yuꞌun chba yacꞌbe entrucal ti totil paleetique ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Li Sauloe más to la itsatsub yoꞌon ta yalbel scꞌoplal ti Cajvaltic Jesuse. Iyalbe la yaꞌi ti xchiꞌiltac tey nacajtic ta Damascoe ti jaꞌ onox scꞌoplal chtal pasvanuc ta mantal ti Jesuse. Ti cꞌalal iyal chac taje, mu xa la snaꞌ cꞌuxi chtacꞌavic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cꞌalal oy xaꞌox scꞌacꞌalil lic yalbe scꞌoplal Jesucristo li Sauloe, ti xchiꞌiltac ta jurioal ti tey nacajtic ta Damascoe, lic la snopic cꞌu xꞌelan ta staic ta milel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ti cꞌusi isnopique iyaꞌi la li Sauloe. Ti crixchanoetique ta cꞌacꞌal ta acꞌubal la tey vaꞌajtic ta jujun stiꞌil smacol ti jteclume. Tey la ta smalaic mi chlocꞌ li Sauloe yoꞌ la staic o ta milele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Cꞌalal iꞌicꞌub ti osile, itiqꞌue la ta mucꞌta moch yuꞌun li muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesuse. Ixchuquic la ta chꞌojon ti moche, cꞌuncꞌun la iyalesat ta pat corralton. Jaꞌ la yech icol li Sauloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cꞌalal icꞌot ta Jerusalén li Sauloe, jaꞌ la tscꞌan ti chba xchiꞌin ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesuse. Pero xiꞌemic o la scotolic, yuꞌun la mu snaꞌic mi yech ti xchꞌunoj xa uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero ti Bernabee iyicꞌ la echꞌel li Sauloe yoꞌ bu li apoxtoletique. ―Li Saulo liꞌi iyil ta be ti Cajvaltic Jesuse, icꞌoponat. Jamal iyalbe scꞌoplal Jesús ta Damascoe ―xut la apoxtoletic ti Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","29","Jaꞌ la yech ixchiꞌinic o li Sauloe ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesús ta Jerusalene. Buyuc noꞌox la chanav li Sauloe jamal la chal aꞌyuc cꞌusi yaloj ti Cajvaltic Jesuse. Lic la yalulanbe sbaic scꞌoplal Cajvaltic Jesús xchiꞌuc xchiꞌiltac ta jurioal ti snaꞌic griego cꞌope, yuꞌun la jaꞌ tscꞌan ti acꞌu xchꞌunic uque. Pero yoꞌonicuc la smilic li Sauloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cꞌalal iyaꞌiic ti jchiꞌiltactic ta xchꞌunel li scꞌop Rioxe, iꞌiqꞌue la echꞌel ta jteclum Cesarea li Sauloe. Itaque la echꞌel ta slumal ta jteclum Tarso. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ti muchꞌutic xchꞌunoj scꞌop Riox ta estado Judeae, xchiꞌuc ta estado Galileae, xchiꞌuc ta estado Samariae, muc xa la xꞌilbajinatic. Jun xa la yoꞌon iyichꞌic ta mucꞌ ti Cajvaltic Jesucristoe. Itsatsubtasbat la yoꞌonic yuꞌun ti Chꞌul Espíritue, jaꞌ la yech ipꞌolic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Li Pedroe ba la svulaꞌan scotol ti muchꞌutic xchꞌunoj li scꞌop Rioxe. Echꞌ la sqꞌuel noxtoc ti muchꞌutic tey nacal ta jteclum Lidae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tey la cꞌot sta jun vinic, Eneas la sbi. Svaxaquibal xa la jabil spuchꞌlej yuꞌun la alubem jun yoc scꞌob. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","―Eneas, lavi ipote, jaꞌ chastsatsubtasbe avoc acꞌob ti Jesucristoe. Lican, tamo lavayebe ―xꞌutat la yuꞌun li Pedroe. Ora la ilic ti Enease. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Scotol ti muchꞌutic tey nacal ta Lidae xchiꞌuc ta jteclum Sarone, iyilic la ti lec xa ti Enease. Jaꞌ la iyictaic o ti cꞌusitic xchꞌunojic toꞌoxe; jaꞌ la istambeic o yichꞌel ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ti cꞌalal yech ispas li Pedroe, tey la jun ants ta jteclum Jope yichꞌoj la ta mucꞌ ti Cajvaltic Jesucristoe. Ti antse Tabita la sbi ta ebreo cꞌope, Dorcas la sbi ta griego cꞌope. Icꞌuxubinvan la. Isqꞌuelanbe la staqꞌuin noxtoc ti muchꞌutic chꞌabal staqꞌuine. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ti cꞌalal tey ta Lida li Pedroe, iꞌipaj la ti Dorcase, icham la. Iyatintasic la. Ti cꞌalal laj yatintasique, ba la stelanic ta jcꞌol o na. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Li Jopee nopol xil sba xchiꞌuc Lida. Ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesús ta Jopee, iyaꞌiic la ti tey ta Lida li Pedroe. Istaquic la echꞌel chaꞌvoꞌ vinic, ba la yiqꞌuel tal li Pedroe. ―Batic la ta Jope ―xꞌutat la cꞌotel li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ixchꞌun la, ora la ibat. Ti cꞌalal icꞌote, iꞌiqꞌue la ochel yoꞌ bu telel ti ánima Dorcase. Tey la tsobol scotol ti meꞌanal antsetique, choqꞌuitaic la tajmec ti ánimae. Ti scꞌuꞌique xchiꞌuc ti stsequique, iꞌacꞌbat la yil li Pedroe ti jaꞌ sjaloj ti ánimae ti cꞌalal cuxul toꞌoxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Li Pedroe istac la loqꞌuel scotol ti muchꞌutic tey yoꞌ bu telel ti ánimae. Ti cꞌalal iloqꞌuique, jaꞌo la isquejan sba li Pedroe, iscꞌopon la Cajvaltic. Ti cꞌalal laj scꞌopon Cajvaltique, isqꞌuelbe la sat ti ánimae. ―Tabita, lican ―xut la. Ti antse ichaꞌcuxi la, ora la isvicꞌ sat, iꞌile la ti tey li Pedroe, ichoti la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Li Pedroe isnit la liquel. Ti cꞌalal vaꞌal xa la ti Dorcase, li Pedroe iyicꞌ la ochel ti meꞌanal antsetique xchiꞌuc ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe, iyacꞌbe la yil scotolic ti ichaꞌcuxi xae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iyaꞌiic la scotol crixchanoetic ta Jopee. Ep la iyichꞌic o ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Li Pedroe tey la ipaj ta Jope ta sna jun vinic, Simón la sbi. Ti yajval nae naca la cꞌaꞌesejnucul yabtel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tey la nacal ta jteclum Cesarea jun vinic, nom la liquem tal, Cornelio la sbi. Capitan soltero la, cien la yajsoltero. Ti cien solteroe Italiano la sbiic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ti Cornelioe sjunul la yoꞌon yichꞌoj ta mucꞌ Riox sjunlejic ta na. Ep la iscꞌuxubin jꞌisraeletic, jaꞌ la ti muchꞌutic abol sbae. Scotol la cꞌacꞌal ta scꞌopon Cajvaltic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ta oxib la ora xmal cꞌacꞌal tey la chotol ta yut sna ti Cornelioe, oy la cꞌusi iꞌacꞌbat yil yuꞌun ti Rioxe. Iꞌoch la tal jun anjel ta vinajel yoꞌ bu chotole. ―Cornelio ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ti Cornelioe ixiꞌ la, sqꞌueloj xa la tajmec ch-och tal. ―Cajval, ¿cꞌusi chaval? ―xut la. ―Ti Rioxe yichꞌoj ta mucꞌ ti cꞌusi chavalulanbee. Yiloj ti chacꞌuxubin ti muchꞌutic abol sbae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yechꞌo un taco echꞌel avinictac ta Jope, acꞌu ba yiqꞌuic tal jun vinic Simón sbi, Pedro li xchaꞌpꞌelel sbie. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tey ta sna jun vinic Simón sbi uc. Cꞌaꞌesejnucul yabtel. Ti snae tey ta tsꞌel tiꞌmar. Li Pedroe jaꞌ chul yalbot ti cꞌusi lec chapase ―xꞌutat la yuꞌun anjel ti Cornelioe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cꞌalal ibat ti anjele, ti Cornelioe istac la ta iqꞌuel jun yajsoltero ti tey xchiꞌuc scotol cꞌacꞌale. Sjunul la yoꞌon yichꞌoj ta mucꞌ ti Riox uque. Istac la ta iqꞌuel chaꞌvoꞌ smozo noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Iyalbe la scotol ti cꞌusi iꞌalbat yuꞌun ti anjele. Ti cꞌalal laj yale, jaꞌo la istac echꞌel ta Jope yoxvaꞌalic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ta yocꞌomal ti cꞌalal poꞌot xaꞌox xcꞌotic ta Jope ti oxvoꞌe, jaꞌo la imuy ta bana li Pedroe. Poꞌot xaꞌox la ol cꞌacꞌal. Yuꞌun la tey ba scꞌopon Cajvaltic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Li Pedroe chviꞌnaj xaꞌox la tajmec, iscꞌan la sveꞌel. Ti cꞌalal xyaquet ta smeltsanbat ti sveꞌele, oy la cꞌusi iꞌacꞌbat yil yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ijam la iyil li vinajele. Iyil la ti oy cꞌusi iyal tale, coꞌol la xchiꞌuc mucꞌta saquil manta. Chucul la xchanjechel xchiquin iyal tal. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tey la chupul tal chonetic iyil. Ep la ta tos li cꞌusi chanib yoque, ep la ta tos quiletel chon, ep la ta tos mut iyil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","―Pedro, milo atiꞌ leꞌe ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","―Cajval, iꞌi. Yuꞌun mu onox bu jtiꞌ ti cꞌusitic avaloj ti mu xuꞌ jtiꞌticotique ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","―Li cꞌusi chacacꞌbee mu xaval ti mu xuꞌ xatiꞌe ―xꞌutat la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxꞌechꞌel la yech iꞌalbat. Jaꞌo xa la isut muyel ta vinajel iyil ti mucꞌta saquil mantae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Li Pedroe lic la loꞌilajuc yoꞌon yuꞌun la mu snaꞌ cꞌusi xal ti cꞌusi iyile. Ti cꞌalal xyaquet ta snope, jaꞌo xa la icꞌotic ta Jope ti viniquetic itaqueic tal yuꞌun ti Cornelioe. ―¿Bu nacal li Simon jcꞌaꞌesejnucule? ―xiic la cꞌotel. Icꞌotic la ta sna ti Simone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Isjaqꞌuic la mi tey li Simone, li Pedro xchaꞌpꞌelel sbie. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Li Pedroe, ti cꞌalal yolel ta snop cꞌusi xal ti cꞌusi iyile ―Tal saꞌot oxvoꞌ vinic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yalan, chiꞌino echꞌel. Mu me xchibetuc avoꞌon xabat yuꞌun voꞌon jtacoj tal ―xꞌutat la yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Li Pedroe iyal la. Ba la scꞌopon ti viniquetique ti itaqueic tal yuꞌun ti Cornelioe. ―Voꞌon ti chasaꞌicone. ¿Cꞌusi chavalic? ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","―Liꞌ listacoticotic tal jun capitan solteroe, Cornelio sbi. Lec yoꞌon. Yichꞌoj ta mucꞌ ti Rioxe. Lec xꞌile yuꞌun scotol achiꞌiltac ta jurioal. Iꞌalbat yuꞌun jun anjel ta vinajel ti chastac ta iqꞌuele, yuꞌun la chaꞌi cꞌusi chavalbe ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Li Pedroe iyicꞌ la ochel ta sna Simón ti viniquetique, tey la ivayic jun acꞌubal, ismacꞌlin la. Ta yocꞌomal to la ibat xchiꞌuc ti viniquetique. Li Pedroe ichiꞌine la echꞌel yuꞌun jayvoꞌ ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesús ta Jopee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ta xchibal to la cꞌacꞌal icꞌotic ta Cesarea. Ti Cornelioe tey xa la chmalavan. Stsoboj xa la scotol xchiꞌiltac xchiꞌuc ti muchꞌutic lec xojtiquine. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ti cꞌalal poꞌot xaꞌox la xcꞌot xchiꞌuc xchiꞌiltac li Pedroe, ba la nupvanuc ta be ti Cornelioe. Iquejletaat la li Pedroe, iꞌichꞌe la ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Li Pedroe isnit la liquel. ―Vaꞌlan yuꞌun coꞌol crixchanootic ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Xꞌiꞌlajetic la ochel xchiꞌuc cꞌalal yut sna ti Cornelioe. Tey la tsobol ep crixchanoetic cꞌot sta li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","―Li voꞌoxuque anaꞌojic cꞌu xiꞌelanoticotic, voꞌoticotic li juriooticotique. Anaꞌojic ti mu xuꞌ xiꞌochoticotic ta sna li muchꞌutic maꞌuc jchiꞌilticotic ta jurioale. Mu xuꞌ jcꞌoponticotic. Pero liyalbe ti Rioxe ti mu xuꞌ xcal ti chopol li muchꞌutic maꞌuc jchiꞌiltac ta jurioale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yechꞌo un sjunul coꞌon lital lavi ataquicon ta iqꞌuele. Yechꞌo un chajacꞌbeic cꞌu yuꞌun ti ataquicon ta iqꞌuele ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Lic la yal ti Cornelioe: ―Oy xa xchanibal cꞌacꞌal liꞌalbat yeche ora chac liꞌi. Liꞌon ta yut jnae, jaꞌo quictaoj cot, jaꞌo ta jcꞌopon Cajvaltic. Iquil coꞌol xchiꞌuc jun vinic yilel. Sac tajmec ti scꞌuꞌe, oy xojobal. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Cornelio, ti Cajvaltique yichꞌoj ta mucꞌ ti cꞌusi chavalulanbee. Yiloj ti chacꞌuxubin ti muchꞌutic abol sbae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Taco echꞌel avinictac ta Jope, acꞌu ba yiqꞌuic tal jun vinic Simón sbi, Pedro li xchaꞌpꞌelel sbie. Jaꞌ tey xchꞌamunojbe sna jun vinic, Simón sbi uc. Cꞌaꞌesejnucul yabtel. Ti snae tey ta tsꞌel tiꞌmar. Mi iyul li Pedroe, oy cꞌusi chayalbe”, xiyut ti anjel ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yechꞌo ti ora lajtac ta iqꞌuele. Lec ti latale. Coliyal Riox ti liꞌ tsoboloticotique, ti chavalboticotic cꞌu xꞌelan layalbee ―xi la ti Cornelioe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Itacꞌav li Pedroe: ―Ti Rioxe yuꞌun onox yech ti muc bu ta stꞌuj ti muchꞌu ta scꞌuxubine. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Buuc noꞌox balamilal lec ta xꞌileic yuꞌun Riox ti muchꞌutic ta xichꞌ ta muqꞌue, ti ta spasic cꞌusi lec chile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ti Rioxe listacboticotic tal ti Jesucristoe, jaꞌ tal yal ti chꞌabal jmultic chiyilotic o ti Rioxe ti mi chquichꞌtic ta muqꞌue. Ti Jesucristoe jaꞌ cajvaltic ta jcotoltic ta sjunlej balamil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Li voꞌoxuque avaꞌyojic cꞌu xꞌelan iyal aꞌyuc ta sjunlej jlumalticotic ti cꞌusi talem spase. Anaꞌojic ti tey istambe yalel ta estado Galileae ti cꞌalal yolel toꞌox chal ti chacꞌ ichꞌvoꞌ ti Juane. Tsꞌacal to iyal aꞌyuc ta estado Judea. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ti Jesus Nazarete avaꞌyojic ti chiꞌinbil yuꞌun ti Chꞌul Espíritue ti jun xchiꞌuc ti Rioxe, ti iyichꞌ slequilal syuꞌelal noxtoque, ti iscꞌuxubin crixchanoetic ti butic iꞌechꞌe, ti isloqꞌuesbe pucuj ti muchꞌutic ochem pucuj ta yoꞌone, ti iyetꞌesbe xchamel ti jchameletique ti cꞌusuc noꞌox chamelal iyaꞌiique, jaꞌ ti chiꞌinbil yuꞌun ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ti jayvoꞌ ijchiꞌinticotic ti Jesuse, iquilticotic scotol ti cꞌusitic ispas ta Jerusalene xchiꞌuc ta sjunlej estado Judeae. Li jchiꞌiltaque iyaqꞌuic ta milel ta cruz. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ti Rioxe ixchaꞌcuxes ta yoxibal cꞌacꞌal. Ti cꞌalal chaꞌcuxiem xaꞌoxe, ep ta echꞌel iquilticotic yuꞌun jaꞌ yech iscꞌan ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Scotol li jchiꞌilticotique muc xilic; jtucticotic noꞌox iquilticotic, voꞌoticotic ti stꞌujojoticotic onox ti Rioxe ti ta xcalticotic ti cuxul ti Jesuse. Ti cꞌalal chaꞌcuxiem xaꞌoxe, ijchiꞌinticotic to ta veꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Liyalboticotic comel ti chcalbeticotic scotol crixchanoetic ti jaꞌ acꞌbil yabtel yuꞌun ti Rioxe ti jaꞌ chalbe bu chbat ta sbatel osil ti muchꞌutic cuxule xchiꞌuc ti muchꞌutic chamem xae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jaꞌ onox yech iyalic ti yajꞌalcꞌoptac Riox ti ta voꞌnee, ti jaꞌ ta xꞌacꞌbatic o pertonal yuꞌun smul scotol ti muchꞌutic ta xchꞌun ti jaꞌ istoj jmultic ti Jesuse ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ti cꞌalal yolel chloꞌilaj li Pedroe, jaꞌo la ichiꞌineic yuꞌun Chꞌul Espíritu ti muchꞌutic tey tsobole. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ti jayvoꞌ xchiꞌiltac tey xchiꞌuc li Pedroe, xchꞌayet xa la yoꞌonic ti cꞌalal iyilic ti ichiꞌineic yuꞌun Chꞌul Espíritu ti muchꞌutic coꞌol maꞌuc juriootic jchiꞌuctique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yuꞌun la icꞌopojic ta ora ta yan o cꞌopetic, lec la iyalbeic scꞌoplal ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","―Ti jayvoꞌ liꞌ tsobole ichiꞌineic xa yuꞌun ti Chꞌul Espíritue chac cꞌu chaꞌal xchiꞌinojotic uque. ¿Cꞌu xachiic? ¿Mi mu xuꞌ xichꞌic voꞌ uc? ―xi la li Pedroe. ―Acꞌu yichꞌic ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Li Pedroe iyal la ti acꞌu yichꞌic voꞌ ta scuenta ti Cajvaltic Jesuse. Ti cꞌalal laj yichꞌique ―Abulajan pajan to jayibuc cꞌacꞌal liꞌtoe ―xꞌutat la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ti muchꞌutic xchꞌunoj scꞌop Riox ta Judeae xchiꞌuc li apoxtoletique, iyaꞌiic la ti ixchꞌunic xa scꞌop Riox ti muchꞌutic coꞌol maꞌuc juriootic jchiꞌuctique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cꞌalal isut ta Jerusalén li Pedroe, isaꞌbat la smul yuꞌun ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesuse ti iyalic ti persa la chichꞌic circuncisión ti muchꞌutic coꞌol maꞌuc juriootic jchiꞌuctique ti mi chichꞌic ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","―¿Cꞌu yuꞌun ti ay acꞌopon ti muchꞌutic maꞌuc jchiꞌiltique ti muc bu yichꞌojic circuncisione? ¿Cꞌu yuꞌun ti ay achiꞌin ta veꞌele? ―xꞌutat la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Li Pedroe xcholet la iyalbe smelol ti cꞌusitic icꞌote. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Ti cꞌalal teon ta Jopee, xyaquet ta jcꞌopon Cajvaltic, oy cꞌusi iyacꞌ quil. Iquil iyal tal ta vinajel coꞌol xchiꞌuc mucꞌta saquil manta. Chucul xchanjechel xchiquin tey iyul yoꞌ buyone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cꞌalal ijqꞌuelbe ti yute, tey chupul tal chonetic iquil. Ep ta tos li cꞌusi chanib yoque, ep ta tos quiletel chon, ep ta tos mut iquil. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Icaꞌi ti oy muchꞌu liscꞌopone: “Pedro, milo atiꞌ leꞌe”, xiyut. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Cajval, iꞌi. Yuꞌun mu onox bu jtiꞌ ti cꞌusitic avaloj ti mu xuꞌ jtiꞌticotique”, xcut. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Li cꞌusi chacacꞌbee mu xaval ti mu xuꞌ xatiꞌe”, xiyut. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxꞌechꞌel yech liyalbe. Jaꞌo xa isut muyel ta vinajel ti mucꞌta saquil mantae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jaꞌo xa icꞌot oxvoꞌ vinic yoꞌ bu jchꞌamunoj nae. Liquemic tal ta Cesarea. Tacbilic tal yuꞌun tal yiqꞌuicon. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ti Chꞌul Espíritue liyalbe ti ta jchiꞌin echꞌel ti viniquetique, xchiꞌuc ti junuc coꞌon baticone. Lixchiꞌinic echꞌel li vacvoꞌ jchiꞌiltactic liꞌi ti coꞌol jchꞌunojtic scꞌop Riox jchiꞌuctique. Licꞌototicotic ta sna ti muchꞌu listac ta iqꞌuele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ti vinique liyalbe ti iyil jun anjel ta vinajele. Ti cꞌalal tey chotol ta yut snae, tey la vaꞌal icꞌot ta xocon. “Taco echꞌel avinictac ta Jope. Acꞌu ba yiqꞌuic tal jun vinic Simón sbi, Pedro li xchaꞌpꞌelel sbie. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jaꞌ chtal yalbot ti cꞌu xꞌelan chacuxiic ta sbatel osil ajunlejic ta anae”, xꞌutat la yuꞌun ti anjele. Yechꞌo ti libate. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ti cꞌalal lic loꞌilajcon xchiꞌuquique, ichiꞌineic uc yuꞌun ti Chꞌul Espíritue chac cꞌu chaꞌal lixchiꞌinotic ti cꞌalal itale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jaꞌo iyul ta jol ti jaꞌ onox yech liyalboticotic comel ti Cajvaltic Jesucristoe: “Ti Juane layacꞌbe avichꞌic voꞌ. Li voꞌone poꞌot xa xacacꞌbeic ti Chꞌul Espíritue”, xiyutoticotic onox. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ti Rioxe iyacꞌbe xa xchiꞌin Chꞌul Espíritu uc ti jayvoꞌ maꞌuc jchiꞌiltic tey tsobolique. Ichiꞌineic xa chac cꞌu chaꞌal xchiꞌinojotique, yuꞌun iyichꞌic xa ta mucꞌ uc ti Cajvaltic Jesucristoe. Yechꞌo ti mu cꞌu xuꞌ xcal li voꞌone. ¿Mi xuꞌ ta jpajes yaꞌel ti cꞌusi tspas ti Rioxe? ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Cꞌalal iyaꞌiic ti muchꞌutic chalic ti persa chichꞌic circuncisión ti muchꞌutic maꞌuc jꞌisraele ti chichꞌic ta mucꞌ ti Cajvaltic Jesuse, mu xa la cꞌusi más iyalic. Lec la ibat scꞌoplal yuꞌunic ti Rioxe. ―Yuꞌun jaꞌ yech tscꞌan ti Rioxe ti chictaic spasel uc li cꞌusitic chopole li muchꞌutic maꞌuc jchiꞌiltique, yoꞌ xcuxiic o ta sbatel osil uque ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ti muchꞌutic yichꞌoj ta mucꞌ ti Jesucristoe ti istaic ilbajinel ti cꞌalal imile ti ánima Estebane, istani la sbaic ta yantic o balamil. Ti jlome ibatic la cꞌalal estado Fenicia. Ti jlome ibatic la cꞌalal Chipre. Ti jlome ibatic la cꞌalal jteclum Antioquía. Ti cꞌalal ibatique, iyalic la aꞌyuc cꞌusi yaloj ti Cajvaltic Jesucristoe. Pero jaꞌ noꞌox la iyalbeic ti xchiꞌilic ta jurioale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ti muchꞌutic ibatic ta Antioquíae, oy la ta Chipre liquemic tal, oy la ta jteclum Cirene liquemic tal. Ti cꞌalal icꞌotic ta Antioquíae, iloꞌilajic la xchiꞌuquic ti muchꞌutic coꞌol maꞌuc jꞌisraelotic jchiꞌuctique. Iyalbeic la ti jaꞌ noꞌox chacꞌ jcuxlejaltic ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ta syuꞌel ti Cajvaltique ep la ti muchꞌutic iyictaic ti cꞌusitic xchꞌunojic toꞌoxe, jaꞌ la istambeic yichꞌel ta mucꞌ ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesús ta Jerusalene, cꞌalal iyaꞌiic ti iyichꞌic xa ta mucꞌ uc ti muchꞌutic coꞌol maꞌuc jꞌisraelotic jchiꞌuctique, istaquic la echꞌel ta Antioquía li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ti cꞌalal icꞌot ta Antioquía li Bernabee, iyil la ti lecubtasbil xa yoꞌonic yuꞌun ti Rioxe. Yechꞌo un jun xa la yoꞌon li Bernabee. Iyalbe la ti sjunul yoꞌonic acꞌu yichꞌic ta mucꞌ ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Li Bernabee lec yoꞌon. Lecubtasbil yoꞌon yuꞌun ti Chꞌul Espíritue. Xchꞌunoj ti oy syuꞌel ti Cajvaltic Jesuse. Cꞌalal iyal li Bernabee, ep la lic yichꞌic ta mucꞌ ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tsꞌacal to ibat la ta Tarso li Bernabee, jaꞌ la ba saꞌ li Sauloe. Ti cꞌalal istae, iyicꞌ la echꞌel ta Antioquía. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jun la jabil tey ixchiꞌinic ti muchꞌutic xchꞌunoj li scꞌop Rioxe. Ep la crixchanoetic ixchanubtasic. Ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesuse, cristoetic la iꞌacꞌbat sbiic yuꞌun ti jꞌantioquíaetique. Jaꞌ la yech ilic o li biile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ti cꞌalal teic la ta Antioquía li Bernabee xchiꞌuc li Sauloe, jaꞌo la tey icꞌotic ta Antioquía jayvoꞌ yajꞌalcꞌop Riox, liquemic la tal ta Jerusalén. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ti june Agabo la sbi. Ipꞌijubtasat la yuꞌun ti Chꞌul Espíritue, iyalbe la ti muchꞌutic xchꞌunoj li scꞌop Rioxe ti chtal viꞌnal ta sjunlej balamile. Ti cꞌalal ital ti viꞌnale, jaꞌo ochem ta preserente ta Roma ti Claudioe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesús ta Antioquíae, isnopic la ti ta scoltaic ti muchꞌutic xchꞌunoj scꞌop Riox ta Judeae ti chaꞌiic viꞌnale. Ta jujuntal la isnopic ti cꞌu yepal chaqꞌuique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ti cꞌalal istsob sba yuꞌunique, jaꞌ la iꞌalbatic vocol li Bernabee xchiꞌuc li Sauloe ti chba yacꞌbeic ti muchꞌutic ta xchanubtasvan ta scꞌop Riox ta Jerusalene. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ti cꞌalal ba yaqꞌuic taqꞌuin ta Jerusalén li Bernabee xchiꞌuc li Sauloe, ti covierno Erodese jaꞌo la lic yilbajin jayvoꞌ ti muchꞌutic xchꞌunoj li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jaꞌ la ta smantal ti imile ta espada ti Jacoboe, jaꞌ ti sbanquil Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ti jurioetique xmuyubajic xa la ti icham ti Jacoboe. Cꞌalal iyil ti Erodese ti xmuyubajic xa ti crixchanoetique, iyal la noxtoc ti acꞌu tsacuc li Pedroe. Ti cꞌalal yech ispas ti Erodese, jaꞌo la ta sqꞌuin li jurioetique ti cꞌalal ta sveꞌic pan ti muc bu yichꞌoj svuquesobil xchꞌute. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ti cꞌalal itsaque la li Pedroe, itiqꞌue la ta chuquel. Ichabiat la ta chanqꞌuex solteroetic, chanchanvoꞌ la juqꞌuex. Ta vacvac ora la isjel sbaic. Ti Erodese isnop la ti ta slajel to qꞌuin ta sloqꞌues ta chuquel li Pedroe, ti ta bail ta satil chacꞌ ta milele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ti muchꞌutic xchꞌunoj li scꞌop Rioxe scotol la cꞌacꞌal iscꞌoponbeic Riox li Pedroe cꞌalal tiqꞌuil ta chuquele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Cꞌalal isnop ti Erodese ti ta yocꞌomal xa ta sloqꞌues ta chuquel li Pedroe, ta yacꞌubalile tey la vayem ta chuclebal li Pedroe, chucul la ta chaꞌpꞌej carina. Jujun la soltero ta jujot xocon li Pedroe. Ti carina chucul oe, xchucoj la ta scꞌobic ti solteroetic uque yoꞌ la xaꞌiic o mi xjatave. Oy la solteroetic noxtoc ta xchabiic jucꞌol ti tiꞌchuclebale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Li Pedroe itijbat la xocon yuꞌun jun anjel tacbil tal yuꞌun ti Cajvaltique. Jaꞌto la iyil ti sacjaman xa ti yut chuclebale. ―Lican ta ora ―xꞌutat la. Ti carina chucul o scꞌobe, ijituj la. Ilic la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","―Chuco achꞌut, lapo axonob ―xꞌutat la yuꞌun ti anjele. Cꞌalal laj xchuc xchꞌute, laj slap ti xonobe, ―Lapo apimilcꞌuꞌ, napꞌlan tal ―xꞌutat la yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Napꞌal la ilocꞌ li Pedroe pero mu la snaꞌ mi melel ti ta xcoltaat yuꞌun ti anjele. Isnop la ti chvaychine. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tey la iꞌechꞌic yoꞌ bu vaꞌal ta xchabivan ti jun solteroe, tsꞌacal to la iꞌechꞌic yoꞌ bu vaꞌal ti jun noxtoque. Cꞌalal icꞌotic ta tiꞌchuclebal ta cayae, ijam la stuc ti taqꞌuin tiꞌnae. Iloqꞌuic la, ibatic la ta jun o caya. Tey xa la icomtsanat yuꞌun ti anjele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ti cꞌalal iyul xchꞌulele, “lavie ijnaꞌ xa ti ta melel istac tal anjel ti Cajvale. Muc xacꞌ ti chismil li Erodese xchiꞌuc ti jayvoꞌ jchiꞌiltac yoꞌonuc smilicone”, xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cꞌalal iyil ti ta sba balamile, tucꞌ la ibat ta sna li Maríae, jaꞌ li smeꞌ Juane, jaꞌ ti Marcos sbi noxtoque. Ep la tey stsoboj sbaic ta scꞌoponic Cajvaltic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cꞌalal cꞌot stij tiꞌbe li Pedroe, ilocꞌ la tal jun tseb, Rode la sbi. Ba la sqꞌuel muchꞌu ti ta stij ti tiꞌbee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Cꞌalal iyaꞌibe ye ti jaꞌ li Pedroe, xmuyubaj xa la tajmec. Muc xa la isjam o ti tiꞌbee, iꞌoch la ta anil ta yut sna, ba la yalbe ti yane ti tey xa vaꞌal ta tiꞌbe li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pero muc la xchꞌunic. ―Yuꞌun chlic achuvaj ―xutic la ti tsebe. ―Ta melel jaꞌ li Pedroe ―xi la. ―Taje maꞌuc Pedro, jaꞌ nan ti anjel yajchabiel Pedroe ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Li Pedroe tey la tstijulan ti tiꞌbee. Cꞌun to la ba sjamic. Cꞌalal iꞌile ti jaꞌ li Pedroe, xchꞌayet xa la yoꞌonic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Iyacꞌ la seña ta scꞌob li Pedroe ti chꞌaniicuque. Lic la yal ti cꞌu xꞌelan iloqꞌuesat ta chuquel yuꞌun ti Cajvaltique. ―Albeic noxtoc li Jacoboe xchiꞌuc li jchiꞌiltactic ta xchꞌunel li scꞌop Rioxe ti lilocꞌ xa ta chuquele ―xut la ti muchꞌutic tey tsobole. Li Pedroe ibat la ta jun o jteclum. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cꞌalal isacube, xvulajetic xa la liquel ti solteroetique jaꞌ ti mu xa bu tey isacub li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ti Erodese isloqꞌues la mantal ti acꞌu saꞌel li Pedroe. Ti cꞌalal muc staique, istsob la ti yajsolterotaque, jaꞌ la ti jayvoꞌ ixchabiic li Pedroe. Ijacꞌbatic la cꞌu yuꞌun ti muc xilic iloqꞌue. Tsꞌacal to la isloqꞌues mantal ti acꞌu yichꞌic milele. Tsꞌacal to la ibat ta Cesarea ti Erodese yuꞌun la jaꞌ tey nacal. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ti Erodese scapanoj la ti jtiroetique xchiꞌuc ti jsidonetique. Ti jtiroetique xchiꞌuc ti jsidonetique coꞌol la isnopic ti chba scꞌoponic ti Erodese, ti chba slajesbeic yoꞌone. Isaꞌic la jun yajcꞌopojelic, Blasto la sbi. Coꞌol la ch-abtej xchiꞌuc ti Erodese. Yuꞌun la jaꞌ tscꞌanic ti chmanolajic yoꞌ bu scuentainoje. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ti Erodese iyal la cꞌusi ora xocol ti chba yichꞌ cꞌoponele. Ti cꞌalal ista scꞌacꞌalil ti cꞌusi ora yaloje, istsꞌacubtas la sba, tey la ba chotluc yoꞌ bu chal cꞌu xꞌelan chcom scꞌoplal ti muchꞌu tsmeltsanbe scꞌoplale. Lic la scꞌopon ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ti cꞌalal iyaꞌiic cꞌusi iyal ti Erodese ―Maꞌuc crixchano ti liꞌ ta xcꞌopoje, jaꞌ jun riox ―xiic la, xꞌavlajetic xa la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ti Erodese ora la iꞌipaj, iꞌacꞌbat la castico yuꞌun jun yajꞌanjel ti Cajvaltique, jaꞌ ti maꞌuc iyacꞌ ta ichꞌel ta mucꞌ ti Rioxe. Iꞌayan la xuvital, icham o la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Acꞌu mi oy ilbajinel pero ipꞌolic onox ti muchꞌutic xchꞌunoj li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Cꞌalal laj yaqꞌuic comel taqꞌuin ta Jerusalén li Bernabee xchiꞌuc li Sauloe, isutic la ta Antioquía. Iyiqꞌuic la echꞌel li Juane, jaꞌ ti Marcos sbi noxtoque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ti muchꞌutic xchꞌunoj scꞌop Riox ta Antioquíae, oy la jayvoꞌ ichanubtasvanic. Jaꞌic la li Bernabee, xchiꞌuc li Simone, jaꞌ la ti Negro sbi noxtoque. Xchiꞌuc Lucio ti liquem tal ta Cirenee. Xchiꞌuc Manaen ti coꞌol itsꞌitesatic xchiꞌuc ti ánima Erodese. Xchiꞌuc li Sauloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ti cꞌalal xyaquet la tscꞌoponic Cajvaltique, cꞌalal yictaoj la yotique ―Acꞌbecon echꞌel li Bernabee xchiꞌuc li Sauloe, acꞌu ba spas li cꞌusi caloj onox ta spase ―xꞌutatic la yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ti cꞌalal laj scꞌoponic ti Cajvaltique, iꞌacꞌbatic la cꞌobol ta sjolic li Bernabee xchiꞌuc li Sauloe, itaqueic la echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Cꞌalal itaqueic echꞌel yuꞌun Chꞌul Espíritu li Bernabee xchiꞌuc li Sauloe, tey la ibatic ta jun jteclum Seleucia sbi. Tey la iꞌochic ta barco, ibatic la cꞌalal Chipre balamil ta oꞌlol mar. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cꞌalal icꞌotique, iloqꞌuic la ta barco ta jun jteclum Salamina sbi. Tey la lic yalic aꞌyuc scꞌop Riox ta stemploic yoꞌ bu chaꞌiic smantal Riox li xchiꞌiltac ta jurioale. Ba la coltavanuc ta yalel aꞌyuc scꞌop Riox li Juan uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Li Bernabee xchiꞌuc li Sauloe ixanavic la ta sjunlej Chipre. Icꞌotic la ta jun jteclum Pafos sbi. Tey la istaic jun jꞌilol, xchiꞌilic la ta jurioal. Chal la scꞌop Riox ti yaloje. Barjesús la sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ti Barjesuse jaꞌ la xchiꞌil ta abtel ti preserente Sergio Pauloe. Ti Sergio Pauloe pꞌij la tajmec. Chac la yaꞌi li scꞌop Rioxe yechꞌo un itaqueic la ta iqꞌuel li Bernabee xchiꞌuc li Sauloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ti Barjesuse Elimas la isbiin. Li Elimase “jꞌilol”, xi la smelol. Ti Elimase iscrontain la li Bernabee xchiꞌuc li Sauloe yuꞌun la jaꞌ tscꞌan ti mu xchꞌun scꞌop Riox ti preserentee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Li Sauloe, li Pablo sbi noxtoque, pꞌijubtasbil la, tsatsubtasbil la yoꞌon yuꞌun ti Chꞌul Espíritue, isqꞌuelbe la sat ti jꞌilole. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","―Jloꞌlovanejot, chopol tajmec li cꞌusi chapase. Xchꞌamalot pucuj yuꞌun chacrontain li cꞌusitic leque. Li voꞌote mu xacꞌan ti oy muchꞌu ta xichꞌ ta mucꞌ ti Cajvaltic Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lavie chayacꞌbe castico ti Cajvaltique. Chtupꞌ asat. Mu xa xavil abe jayibuc cꞌacꞌal ―xut la jꞌilol li Pabloe. Ora la itupꞌ ti sate. Isaꞌ la muchꞌu ta xniton o. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cꞌalal iyil ti preserentee ti itupꞌ sat ti jꞌilole, iyichꞌ la ta mucꞌ ti Cajvaltic Jesucristoe. Lec la iyaꞌi li scꞌop Rioxe ti iꞌalbat yuꞌun li Bernabee xchiꞌuc li Pabloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Li Pabloe xchiꞌuc li xchiꞌiltac ta yalel aꞌyuc li scꞌop Rioxe, iꞌochic la ta barco ta Pafose, tey la cꞌot loqꞌuicuc ta jteclum Perge ta estado Panfilia sbi. Li Juane tey la icomtsanvan, isut la ta Jerusalén. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Li Pabloe xchiꞌuc li Bernabee jꞌechꞌelbe noꞌox la iꞌechꞌic ta Perge, ibatic la cꞌalal jteclum Antioquía ta estado Pisidia. Ta scꞌacꞌalil ta xcuxic ti xchiꞌiltac ta israelale, cꞌalal chba yaꞌibeic smantal Rioxe, ibatic la uc li Pabloe xchiꞌuc li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Cꞌalal laj yichꞌ aptael li smantaltac Rioxe xchiꞌuc ti cꞌusitic yan stsꞌibaojic comel ti jꞌalcꞌopetic ti ta voꞌnee, ti jmeltsanejcꞌopetic ta temploe istaquic la ta jaqꞌuel mi oy cꞌusi chalic jpꞌel chaꞌpꞌeluc li Pabloe xchiꞌuc li Bernabee, xuꞌ la chalic mi chcꞌopojique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Isvaꞌan la sba li Pabloe. Iyacꞌ la seña ta scꞌob ti chꞌaniicuque. ―Jchiꞌiltactic, xchiꞌuc voꞌoxuc ti maꞌuc jꞌisraeloxuque ti avichꞌojic ta mucꞌ uc ti Rioxe, aꞌyic me li cꞌusi chcale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ti Cajvaltique ti quichꞌojtic ta mucꞌ, voꞌotic li jꞌisraelotique, jaꞌ itꞌujeic ti voꞌne moletique. Cꞌalal teic toꞌox ta Egiptoe, ipꞌolesatic yuꞌun ti Rioxe. Tsꞌacal to ta syuꞌel Riox iloqꞌuesatic tal, yuꞌun maꞌuc onox tey slumalic ta Egiptoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ti voꞌne moletique itsꞌicbat sbolilic chaꞌvinic jabil yuꞌun ti Rioxe ti cꞌalal tey xjoyetic ta xocol balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ta Canaán balamile oy toꞌox vucub cꞌox nación. Ti voꞌne moletique icoltaatic yuꞌun ti Rioxe yechꞌo ti imil yuꞌunic ti vucub nacione, jaꞌ yech istaic o li osile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cuatro ciento cincuenta jabil ispas sbaic ta mantal stuquic ti voꞌne moletique. Iꞌoch jayqꞌuex yajmeltsanejcꞌopic, jaꞌ istꞌuj ti Rioxe. Jaꞌ yech ti cꞌalal ochem toꞌox ta jmeltsanejcꞌop ti Samuele, jaꞌ ti yajꞌalcꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Cꞌalal jaꞌo ocheme, lic scꞌan yajpreserenteic ti voꞌne moletique. Ti Rioxe iyal ti jaꞌ ch-och ta yajpreserenteic ti Saule, ti screm Cise. Ti Saule Benjamín sbi ti smucꞌtatot ti ta más voꞌnee. Chaꞌvinic jabil iꞌoch ta preserenteal ti Saule. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tsꞌacal to iloqꞌuesat yuꞌun ti Rioxe. Jaꞌ iꞌoch ta sqꞌuexol ti Davide. Yuꞌun ti Davide jaꞌ onox yech albil scꞌoplal yuꞌun ti Rioxe: “Li Davide li screm Isaíe, coꞌol jol jchiꞌuc yuꞌun jaꞌ ta spas ti cꞌusitic lec chquile”, xi onox ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ti Rioxe iyal onox ti ta xtal stojbotic jmultic jun smom ti Davide. Iꞌay xa, jaꞌ ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Cꞌalal mu toꞌox bu chvinaj ti talem xa ti Jesuse, ti Juane iyalbe onox li jchiꞌiltactic ta israelale ti acꞌu yictaic spasel li cꞌusitic chopole, ti acꞌu yichꞌic voꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Cꞌalal poꞌot xaꞌox xcham ti Juan jꞌacꞌ-ichꞌvoꞌe, jaꞌ yech iyal: “Mu voꞌonicon ti stꞌujojon Riox ti chajpasic ta mantale. Ta to xtal ti muchꞌu más oy syuꞌele. Li voꞌone mu cꞌu xuꞌ jcolta o. Mi jaꞌuc slocꞌbel xonob, mu xuꞌ cuꞌun”, xi ti Juane. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Jchiꞌiltactic, voꞌotic ti smomotic ti Abraame, xchiꞌuc voꞌoxuc ti maꞌuc jꞌisraeloxuque ti avichꞌojic ta mucꞌ uc ti Rioxe, chcalticotic avaꞌiic ti iꞌay xa ta jlumaltic ti muchꞌu ay stoj jmultique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Li jchiꞌiltactic ta Jerusalene xchiꞌuc ti jmeltsanejcꞌopetique, muc xichꞌic ta mucꞌ ti Jesuse. Mi jaꞌuc xichꞌic ta mucꞌ noxtoc ti cꞌusitic yaloj ti yajꞌalcꞌoptac Riox ti ta voꞌnee, ti jaꞌ ta xcaꞌitic ta scꞌacꞌalil ta jcuxtique. Yechꞌo ti iyaqꞌuic ta milel ti Jesuse. Jaꞌ icꞌot ti cꞌusitic stsꞌibaojic ti yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Acꞌu mi muc bu istabeic smul ti Jesuse ti yoꞌ xmile oe, pero iyalbeic ti Pilatoe ti acꞌu yacꞌ ta milele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Cꞌalal icꞌot scotol chac cꞌu chaꞌal tsꞌibabil scꞌoplale, iyalesat ta cruz, ba mucatuc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ti Rioxe ixchaꞌcuxes loqꞌuel ta smuquenal. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tsꞌacal to ibat ta Galilea. Ep to ta echꞌel iyacꞌ sba iluc ta stojol li yajchancꞌoptaque xchiꞌuc ti muchꞌutic yichꞌojic ta muqꞌue. Tsꞌacal to ibat xchiꞌuquic ta Jerusalén ti cꞌalal imuy ta vinajele. Iꞌalbatic comel ti acꞌu yalic aꞌyuc ti iyilic ti chaꞌcuxieme. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","’Li voꞌoticotic uque chcalticotic avaꞌiic ti iquilticotic xa ti icꞌot ti cꞌusi iꞌalbatic yuꞌun Riox ti voꞌne moletique. Yuꞌun yaloj onox ti Rioxe ti ta xchaꞌcuxes ti muchꞌu stꞌujoj chispasotic ta mantale. Icꞌot xa ti cꞌusi iyale yuꞌun ixchaꞌcuxes ti Jesuse. Jaꞌ onox yech tsꞌibabil ta xchaꞌcojol jqꞌuevujtic: “Voꞌot Jchꞌamalot. Ta to sta yora ta xcacꞌ iluc ti voꞌot Jchꞌamalote”, xi onox ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yuꞌun ichaꞌcuxesat yuꞌun Riox ti Jesuse, yechꞌo ti mu xa bu ta xchame. Jaꞌ onox yech iꞌalbatic yuꞌun Riox ti voꞌne moletique: “Ta onox xcꞌot li cꞌusi icalbe ti Davide”, xꞌutatic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yechꞌo ti istsꞌiba ta jcoj jqꞌuevujtic ti Davide: “Muc bu chavacꞌ cꞌaꞌuc li jpat jxocone, voꞌon lachꞌamalone, ti chꞌabal jmule”, xi. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Maꞌuc scꞌoplal stuc istsꞌiba ti Davide. Ti Davide jaꞌ ispas cꞌusi lec chil Riox ti cꞌu sjalil cuxul ta sba balamile. Ismuquic, icꞌaꞌ ti spat xocone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ti Jesuse ichaꞌcuxesat yuꞌun ti Rioxe, muc xcꞌaꞌ ti spat xocone. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Yechꞌo un, jchiꞌiltactic, naꞌic me ti jaꞌ noꞌox ta jtatic o pertonal yuꞌun jmultic ti Jesuse. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ti muchꞌutic ta xchꞌune, chꞌabal smul ch-ileic yuꞌun ti Rioxe. Li smantaltac Riox ti iyal ti Moisese mu xuꞌ ti chꞌabal jmultic chiyilotic o ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yechꞌo un qꞌuelo me abaic, mu me xcꞌot ta abaic chac cꞌu chaꞌal iyal ti yajꞌalcꞌoptac Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Voꞌoxuc ti mu la xacꞌanvanique, aꞌyic la me. Más to la chacꞌ iluc slequilal syuꞌelal ti Rioxe pero mi jaꞌuc onox la xachꞌunic o. Acꞌu la mi oy muchꞌu xayalbeic, chalabanic no la. Ti mu xachꞌunique, chaꞌochic la ta cꞌocꞌ ta sbatel osil, xi ti jꞌalcꞌopetique ―xi la li Pabloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ti cꞌalal iloqꞌuic ta templo li Pabloe xchiꞌuc li Bernabee, ep la muchꞌutic iyal ti tscꞌanic to albel cꞌalal vaxaquib cꞌacꞌal ti cꞌusi iꞌalbatique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ti cꞌalal ixchꞌac sbaic ti muchꞌutic iyaꞌiic li smantaltac Rioxe, ep la jurioetic, ep la maꞌuc jurioetic ti sjunul yoꞌonic yichꞌojic ta mucꞌ ti Rioxe, jaꞌ la napꞌal ibat ta spatic li Pabloe xchiꞌuc li Bernabee. Li Pabloe xchiꞌuc li Bernabee jaꞌ la yech iyalbeic ti jꞌechꞌel acꞌu xchꞌunic ti ta slequil noꞌox yoꞌon ti chꞌabal xa jmultic chiyilotic ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ti cꞌalal ilaj vaxaquib cꞌacꞌale, ep la istsob sbaic tal ti muchꞌutic tey nacal ta jteclume, jutuc xa la muc xtal scotolic ta yaꞌiel li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ti jurioetique ti muc bu xchꞌunojic ti iꞌay xa ti muchꞌu stꞌujoj Rioxe, lic la itꞌixajicuc ti cꞌalal iyilic ti ep tajmec istsob sbaic ta yaꞌiel cꞌusi chal li Pabloe. Iꞌalbat la li Pabloe ti maꞌuc yech li cꞌusi chale, ti mu la snaꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Li Pabloe xchiꞌuc li Bernabee muc la xiꞌic o. ―Li voꞌoxuque baꞌyi ical avaꞌiic li scꞌop Rioxe yuꞌun jaꞌ yech tscꞌan ti Rioxe. Ti mu xachꞌunique, jaꞌ chvinaj o ti mu xacꞌan xacuxiic ta sbatel osile. Lavie jaꞌ xa chba calbeticotic li muchꞌutic maꞌuc jchiꞌiltic ta israelale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yuꞌun jaꞌ yech liyalboticotic ti Cajvaltic Jesucristoe: Li voꞌoxuque lajloqꞌuesic xa ta mulil yoꞌ ti xba avalbeic o scotol crixchanoetic ta sjunlej balamile ti xuꞌ ta xcuxiic ta sbatel osil uque, xiyutoticotic ti Jesuse ―xi la li Pabloe xchiꞌuc li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ti cꞌalal iyaꞌiic ti muchꞌutic coꞌol maꞌuc juriootic jchiꞌuctique, xmuyubajic xa la ti iloqꞌuesatic ta mulil uque. ―Lec tajmec ti cꞌusi iyal ti Cajvaltic Jesucristoe ―xiic xa la. Ixchꞌunic la ti muchꞌutic stꞌujoj onox ti Rioxe ti ta xcuxiic ta sbatel osile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ti muchꞌutic ixchꞌun li scꞌop Rioxe iyalic la aꞌyuc ta sjunlej estado Pisidia. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ti jurioetique ti muc bu xchꞌunojic ti iꞌay xa ti muchꞌu stꞌujoj ti Rioxe, ba la sticꞌbeic cꞌop ti yajmeltsanejcꞌopic ta slumalique, xchiꞌuc la jayvoꞌ antsetic ti sjunul yoꞌonic xchꞌunojic yilel li smantaltac Rioxe, ti ichꞌbilic ta muqꞌue. Lic la ilbajinaticuc li Pabloe xchiꞌuc li Bernabee. Inutsatic la loqꞌuel teyoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Li Pabloe xchiꞌuc li Bernabee islilinic la comel spucucal yoquic. Jaꞌ la seña ti icom ta sba stuquic ti muc xchꞌunique. Ibatic la ta jun jteclum Iconio sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesucristo ta Pisidiae, jun la yoꞌon icomic, yuꞌun la lecubtasbil xa yoꞌonic yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ti cꞌalal icꞌotic ta Iconio li Pabloe xchiꞌuc li Bernabee, iꞌochic la ta templo yoꞌ bu chaꞌiic smantal Riox ti xchiꞌilic ta jurioale. Ti cꞌalal iyalbeic scꞌoplal ti Cajvaltic Jesucristoe, ep la tajmec xchiꞌilic ixchꞌunic. Ep la ixchꞌunic uc ti coꞌol maꞌuc juriootic jchiꞌuctique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ti yan xchiꞌilic ta jurioale ti muc xchꞌunique, iscoꞌoltasbe la sba sjolic xchiꞌuc ti muchꞌutic maꞌuc jurioetic uque ti tscrontainic li Pabloe xchiꞌuc li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Yuꞌun ti ep ti muchꞌutic ixchꞌunic li scꞌop Rioxe, yechꞌo un tey la ipajic li Pabloe xchiꞌuc li Bernabee. Jamal la iyalic cꞌusi yaloj ti Cajvaltic Jesucristoe, mu la bu ixiꞌic. Ti Cajvaltique iyacꞌ la iluc ti yech ti cꞌusi chalique, ti ta slequil noꞌox yoꞌon ta xcoltavane. Iꞌacꞌbat la syuꞌelic, iyaqꞌuic la iluc slequilal syuꞌelal ti Cajvaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ti yajvaltac jteclume ipasic la ta chaꞌchꞌac. Jchꞌac la ixchꞌunic ti cꞌusi iyal li apoxtoletique; jchꞌac la muc xchꞌunic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ti jchꞌac ti muc xchꞌunique xchiꞌuc ti yajmeltsanejcꞌopique, jaꞌ la iscoꞌoltasbe sba sjolic xchiꞌuc ti jurioetique ti muc xchꞌunic uque. Isnopic la ti ta smajic, ti ta smilic ta ton li Pabloe xchiꞌuc li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ti cꞌalal iyaꞌiic li Pabloe xchiꞌuc li Bernabee, ora la iloqꞌuic, ibatic la ta jteclum Listra ta estado Licaonia. Tsꞌacal to la ibatic ta jteclum Derbe tey noꞌox ta estado Licaonia. Ixanavic la ta sjunlej li Licaoniae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Iyalic la aꞌyuc ti jaꞌ noꞌox chacꞌ jcuxlejaltic ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Oy la tey jun vinic ta Listra, coxo la iꞌayan. Mi jaꞌuc la oy bu ixanav ta jmoj. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tey la chotol chaꞌi cꞌusi chal li Pabloe. Li Pabloe isqꞌuel la, iyilbe la ta sat ti xchꞌunoj ti xuꞌ chlecub ti yoque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Li Pabloe tsots la icꞌopoj: ―Vaꞌlan ―xut la ti vinique. Ti vinique ora la ivaꞌi, ixanav la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Cꞌalal iyil ti crixchanoetique ti lec xa chanav ti vinique, tsots la iꞌavanic. Jaꞌ la yech iyalic ta licaonia cꞌope: ―Yalem tal rioxetic liꞌtoe. Viniquetic yilel ―xut la sbaic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Li Bernabee Júpiter la isbiin. Li Pabloe Mercurio la isbiin yuꞌun la más icꞌopoj. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Oy la tey jun yeclexaic ta tiꞌ jteclum yoꞌ bu chotol ti yajsantoique, Júpiter la sbi. Ti yajpale Jupitere iyicꞌ la loqꞌuel vacaxetic ta stiꞌ scorraltonal li jteclume. Yacꞌojbe la snichimal snucꞌ ti vacaxetique. Ti palee xchiꞌuc ti crixchanoetique ta ox la smilic ti vacaxetique, jaꞌ ox la ch-acꞌbat smotoninic li Pabloe xchiꞌuc li Bernabee, yuꞌun la ch-ichꞌeic ox ta mucꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Cꞌalal iyaꞌiic li Pabloe xchiꞌuc li Bernabee, isjat la scꞌuꞌic yuꞌun la qꞌuexlal iyaꞌiic ti ta xꞌichꞌeic ta muqꞌue. Ora la ibatic ta oꞌlol crixchanoetic. Iꞌavanic la: ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Viniquetic, ¿cꞌu yuꞌun ti xꞌelan chapasique? Coꞌol crixchanootic. Ti litaloticotic liꞌtoe, jaꞌ tal calticotic avaꞌiic ti tscꞌan chavictaic li cꞌusitic avichꞌojic ta muqꞌue. Jaꞌ ichꞌic ta mucꞌ ti Riox ta vinajele ti cuxul ta sbatel osile. Jaꞌ ispas li vinajel balamile, xchiꞌuc li mare, xchiꞌuc scotol li cꞌusitic oye. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Voꞌne lic stsꞌic ti cꞌu xaꞌelanic ti jaylajuntosoxuc ta sjunlej balamile, voꞌoxuc ti maꞌuc jꞌisraeloxuque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ti Rioxe iyacꞌ onox avilic ti cuxule. Chacꞌ tal voꞌ, jaꞌ ta xchꞌi o li cꞌusitic chatsꞌunique yoꞌ xata o aveꞌelique, yechꞌo ti jun avoꞌonique ―xutic la ti crixchanoetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Acꞌu mi iꞌalbatic ti mu yaꞌuc spasic yeche, vocol la ixchꞌunic. Chmilbatic ox la ta persa ti smotonique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jaꞌo la tey icꞌotic jayvoꞌ jurioetic, liquemic la tal ta Antioquía xchiꞌuc ta Iconio. Lic la socbe sjol ti crixchanoetic ta Listrae, lic la acꞌbatuc ton li Pabloe. Iquile la loqꞌuel ta tiꞌ jteclum yuꞌun la icham xa ti yalojique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe tey la ba sjoy sbaic yoꞌ bu li Pabloe. Li Pabloe ilic la, ichaꞌoch la ta yutil jteclum. Ta yocꞌomal to la ilocꞌ echꞌel xchiꞌuc li Bernabee, ibatic la ta Derbe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ti cꞌalal icꞌotic ta Derbee, cꞌot la yalbeic ti crixchanoetique ti jaꞌ noꞌox chacꞌ jcuxlejaltic ti Jesuse. Ep la ti muchꞌutic ixchꞌune. Tsꞌacal to isutic la ta Listra, xchiꞌuc ta Iconio, xchiꞌuc ta Antioquía ta estado Pisidia. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Jujun la jteclum echꞌ spatbeic yoꞌon ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe. Iyalbeic la ti mu me xicta sbaique, ti oy onox ilbajinel ti mi tscꞌan chbatic yoꞌ bu tspas mantal ta sbatel osil ti Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Isvaꞌanbeic la yajchanubtasvanejic ta jujun templo ti muchꞌutic xchꞌunoj li scꞌop Rioxe. Iyicta la yotic cꞌalal iscꞌoponic Rioxe, jaꞌo la istꞌujic ti jchanubtasvanejetique. Ti cꞌalal laj stꞌujique, iscꞌoponbeic la Riox yoꞌ xcoltaatic o yuꞌun ti Cajvaltic Jesucristoe ti jaꞌ yichꞌojic ta muqꞌue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tsꞌacal to isutic la ta estado Panfilia li Pabloe xchiꞌuc li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Iyalic la aꞌyuc scꞌop Riox ta jteclum Perge. Tsꞌacal to ibatic la ta jteclum Atalia. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tey la iꞌochic ta barco, ichaꞌsutic la ta Antioquía yoꞌ bu icꞌoponbatic Rioxe yoꞌ xchiꞌineic o ta spasel ti cꞌusi tscꞌane. Yuꞌun la ispasic xa ti cꞌusitic tscꞌan ti Rioxe, yechꞌo la ti ichaꞌsutic ta Antioquía yoꞌ bu iliquique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ti cꞌalal icꞌotic ta Antioquíae, istsobic la scotol ti muchꞌutic xchꞌunoj li scꞌop Rioxe, jaꞌic li jꞌisraeletique xchiꞌuc li muchꞌutic coꞌol maꞌuc jꞌisraelotic jchiꞌuctique. Li Pabloe xchiꞌuc li Bernabee iyalic la scotol ti cꞌusitic icoltaatic ta spasel yuꞌun ti Rioxe, xchiꞌuc ti butic itaqueic echꞌel ta yalel li cꞌusi yaloje. Iyalic la noxtoc ti ep ixchꞌunic uc ti jaꞌ istoj jmultic ti Cajvaltic Jesucristoe ti muchꞌutic coꞌol maꞌuc jꞌisraelotic jchiꞌuctique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jal la tey ipajic, ixchiꞌinic la ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tey la icꞌot jayvoꞌ jꞌisraeletic ta Antioquíae, liquemic la tal ta Judea. Jaꞌ la yech cꞌot yalbeic ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesuse ti coꞌol maꞌuc jꞌisraelotic jchiꞌuctique: ―Mi mu xavichꞌic circuncisión chac cꞌu chaꞌal iyal ti Moisese, mu xacuxiic ta sbatel osil ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Li Pabloe xchiꞌuc li Bernabee tsots la istacꞌulanbe sbaic xchiꞌuc ti viniquetique, pero muc la smeltsaj yuꞌunic. Ti muchꞌutic yichꞌoj ta mucꞌ Cajvaltic Jesús ta Antioquíae, coꞌol la isnopic ti ta staquic echꞌel ta Jerusalén li Pabloe xchiꞌuc li Bernabee, xchiꞌuc la jayvoꞌ xchiꞌilic. Jaꞌ la ba sjacꞌbeic tal mi yech smantalic li apoxtoletique xchiꞌuc li jchanubtasvanejetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ti cꞌalal iloqꞌuic echꞌele, ay la sbeiltaselic yuꞌun ti muchꞌutic xchꞌunoj scꞌop Riox ta Antioquíae. Iꞌechꞌic la ta estado Fenicia, xchiꞌuc ta estado Samaria. Echꞌ la yalbeic ti muchꞌutic xchꞌunoj scꞌop Riox teyoꞌe ti oy xa ep lic yichꞌic ta mucꞌ Cajvaltic Jesús ti muchꞌutic coꞌol maꞌuc jꞌisraelotic jchiꞌuctique. Xmuyubajic xa la tajmec ti cꞌalal iyaꞌiique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ti cꞌalal icꞌotic ta Jerusalén li Pabloe xchiꞌuc li Bernabee, ichꞌbilic la ta mucꞌ icꞌotic yuꞌun ti muchꞌutic xchꞌunoj li scꞌop Rioxe, xchiꞌuc li apoxtoletique, xchiꞌuc li jchanubtasvanejetique. Li Pabloe xchiꞌuc li Bernabee iyalic la scotol ti cꞌusitic iꞌacꞌbat spasic yuꞌun ti Rioxe, xchiꞌuc ti butic itaqueic echꞌel ta yalel aꞌyuc ti cꞌusi yaloje. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tey la jayvoꞌ jfariseoetic ti yichꞌojic xa ta mucꞌ ti Cajvaltic Jesucristoe. Isvaꞌan la sbaic. ―Ti muchꞌutic maꞌuc jchiꞌiltactic ta israelale persa chichꞌic circuncisión mi chichꞌic ta mucꞌ ti Cajvaltic Jesucristoe. Chavalbeic noxtoc ti acꞌu xchꞌunic li smantaltac Riox ti iyal ti Moisese ―xiic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yechꞌo la ti istsob sbaic li apoxtoletique xchiꞌuc li jchanubtasvanejetique yuꞌun la isnopic cꞌusi chcom o. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Jal xaꞌox la iloꞌilajic, jaꞌo la isvaꞌan sba li Pedroe. ―Jchiꞌiltactic, anaꞌojic ti oy xa sjabilal listꞌuj ti Rioxe ti chcalbe yaꞌiic ti jaꞌ chacꞌ jcuxlejaltic ti Cajvaltic Jesucristoe li muchꞌutic maꞌuc jchiꞌiltique yoꞌ xchꞌunic oe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ti Rioxe yiloj coꞌontic jcotoltic. Yiloj ti ixchꞌun xa li muchꞌutic maꞌuc jchiꞌiltique, yechꞌo ti iyacꞌbe xa xchiꞌin ti Chꞌul Espíritu uque chac cꞌu chaꞌal iyacꞌ jchiꞌintique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ti Rioxe scꞌuxubinojotic jcotoltic. Coꞌol islecubtas coꞌontic yuꞌun coꞌol ijchꞌuntic ti jaꞌ istoj jmultic ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Cꞌu yuꞌun ti chatoy abaic ta stojol ti Rioxe? Li muchꞌutic maꞌuc jchiꞌiltique ti yichꞌojic xa ta mucꞌ ti Cajvaltic Jesuse, ilbajinel chaꞌiic mi chavalbeic ti persa ta xchꞌunic li mantaletique. Ti voꞌne moletique mu onox bu ichꞌun yuꞌunic li mantaletique. Jaꞌ noꞌox yechotic uc, mu xchꞌun cuꞌuntic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Li voꞌotique jchꞌunojtic xa ti ta slequil noꞌox yoꞌon ti Cajvaltic Jesuse ti chicuxiotic ta sbatel osile, mu ta mantaluc. Jaꞌ noꞌox yech chicuxiotic jcotoltic, acꞌu mi jꞌisraelotic, acꞌu mi maꞌuc ―xi la li Pedroe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chꞌab xi la scotolic. Li Bernabee xchiꞌuc li Pabloe lic la yalic uc ti ep iyaqꞌuic iluc slequilal syuꞌelal Riox ta slumalic ti muchꞌutic coꞌol maꞌuc jꞌisraelotic jchiꞌuctique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cꞌalal laj cꞌopojicuque, icꞌopoj la li Jacoboe: ―Jchiꞌiltactic, aꞌyic me li cꞌusi chcale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Li Simone liyalbotic xa cꞌu xꞌelan lic yicꞌ yan crixchanoetic ti Rioxe, yechꞌo ti lic yichꞌic ta mucꞌ uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jaꞌ onox yech stsꞌibaojic ti yajꞌalcꞌoptac Rioxe: ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ti amomique ta to xichꞌic ta mucꞌ ti Rioxe chac cꞌu chaꞌal ichꞌbil toꞌox ta mucꞌ ti cꞌalal tiqꞌuil ta spreserenteal ti Davide. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Jaꞌ yech ta xcꞌot yoꞌ ti xaqꞌuic o ta ichꞌel ta mucꞌ ti Rioxe. Jaꞌ yech chlic yichꞌic o ta mucꞌ Riox uc li yan crixchanoetic ta sjunlej balamile. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Jaꞌ yech snopoj ti Rioxe ti cꞌalal chꞌabal toꞌox li vinajel balamile, xi ti jꞌalcꞌopetique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Li chcal voꞌone, más lec ti mu yaꞌuc quilbajintic li muchꞌutic maꞌuc jchiꞌiltique ti iyichꞌic xa ta mucꞌ ti Riox ta vinajele. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","Más lec mi ta jtsꞌibabetic svunique. Jaꞌ noꞌox calbetic ti mu yaꞌuc stiꞌic ti cꞌusitic smotoninoj santoetique, ti mu saꞌ yantsique, ti mu saꞌ yajmulique, ti mu yaꞌuc stiꞌic ti cꞌusi xachꞌbil snucꞌ ta xchame, ti mu yaꞌuc stiꞌic chꞌichꞌe chac cꞌu chaꞌal jchꞌunojtic ti mu xuꞌ jtiꞌtique, yoꞌ mu chopluc o xaꞌiic li jchiꞌiltactic tey capalique. Yuꞌun ta jujun jteclum ta scꞌacꞌalil ta jcuxtique, jaꞌ ch-aptabatic ta stemploic li smantaltac Riox ti iyal comel ti Moisese chac cꞌu chaꞌal iꞌaptabatic ti voꞌnee ―xi la ti Jacoboe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Li apoxtoletique xchiꞌuc li jchanubtasvanejetique, xchiꞌuc ti muchꞌutic xchꞌunoj scꞌop Riox ta Jerusalene, isnopic la ti más lec xichꞌ tꞌujel chaꞌvoꞌuque ti ta staquic echꞌel ta Antioquíae, ti jaꞌ chba xchiꞌinic li Pabloe xchiꞌuc li Bernabee. Jaꞌ la istꞌujic li Silase xchiꞌuc li Judase, jaꞌ ti Barsabás sbi noxtoque. Yuꞌun la jaꞌ yichꞌojic ta mucꞌ scotolic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Istsꞌibaic la ti vune ti chichꞌic echꞌel li Judase xchiꞌuc li Silase. Jaꞌ la yech istsꞌibaic: “Jchiꞌiltactic, voꞌoxuc ti maꞌuc jꞌisraeloxuque ti liꞌ nacaloxuc ta Antioquíae, xchiꞌuc ta sjunlej estado Siriae, xchiꞌuc ta estado Ciliciae, ti jchiꞌil jbatic ta xchꞌunel li scꞌop Rioxe, chajcꞌoponticotic ta vun, voꞌoticotic ti apoxtoloticotique xchiꞌuc ti jchanubtasvanejoticotic liꞌ ta Jerusalene, xchiꞌuc li yan jchiꞌiltactique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Icaꞌiticotic ti oy jayvoꞌ muchꞌutic xchꞌunoj li scꞌop Rioxe ti ay svulaꞌanoxuque ti liꞌ iliquic echꞌele. Pero muc bu jtacojticotic tal. Jaꞌ chavat o avoꞌonic ti layalbeic ti persa chavichꞌic circuncisione, ti persa chachꞌunic scotol li smantaltac Rioxe. Yuꞌun layalbeic ti jaꞌto yech chacuxiic ta sbatel osile, pero muc bu xcalticotic yech. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yechꞌo ti ijtsob jbaticotique, yuꞌun ijnopticotic cꞌusi chcom o. Ijtꞌujticotic jayvoꞌ ti ijtacticotic tale, ti ixchiꞌinic tal li Bernabee xchiꞌuc li Pabloe, jaꞌ ti jcꞌanojticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jaꞌ ti muc bu ixiꞌic o ti jutuc xa muc xlajic yuꞌun ti yichꞌojic ta mucꞌ ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yechꞌo ti jaꞌ ijtacticotic tal li Judase xchiꞌuc li Silase. Jaꞌ tal yal avaꞌiic ti cꞌusi ijnopticotique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yuꞌun jaꞌ yech tscꞌan ti Chꞌul Espíritue ti mu xa cꞌusi yan mantal chcacꞌticotic achꞌunique. Lec chcaꞌiticotic uc. Jaꞌ noꞌox tscꞌan chachꞌunic li cꞌusi lajtsꞌibabeticotic tale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mu me xatiꞌic ti cꞌusitic smotoninoj santoetique. Mu me xatiꞌic chꞌichꞌ, mu me xatiꞌic ti cꞌusi xachꞌbil snucꞌ ta xchame, mu me xasaꞌ avantsic, mu me xasaꞌ avajmulic. Mi chachꞌunic scotole, lec chavil abaic. Jaꞌ noꞌox yech chacalbeticotic”, xi la tsꞌibabil echꞌel ti ta vune. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ti muchꞌutic itꞌujee ibatic la. Icꞌotic la ta Antioquía, cꞌot la stsobic scotol ti muchꞌutic xchꞌunoj li scꞌop Rioxe. Cꞌot la yaqꞌuic ti vune. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ti cꞌalal iꞌaptabat yaꞌiique, xmuyubajic xa la tajmec ti ipatbat yoꞌonique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Li Judase xchiꞌuc li Silase ichꞌamunbat la yeic yuꞌun ti Rioxe ti chalic aꞌyuc ti cꞌusi yaloje. Ixchanubtasic la ti muchꞌutic xchꞌunoj li scꞌop Rioxe, jun la yoꞌon icomic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Li Judase xchiꞌuc li Silase tey la ijalijic. Ti cꞌalal iyalic ti chtalique ―Teyuc cheꞌe, te jcꞌopon jbatic. Qꞌuelo me abaic echꞌel. Chiꞌinic echꞌel Cajvaltic. Xavalbeic me chabanuc ti muchꞌutic lastaquic tale ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Li Silase isnop la ti chpaj to ta Antioquíae. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Li Pabloe xchiꞌuc li Bernabee ipajic to la ta Antioquía uc. Ichanubtasvanic la. Ep la ti muchꞌutic ixchiꞌinic ta yalel aꞌyuc scꞌop Riox teyoꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tsꞌacal to la iyal li Pabloe: ―Ba xa jvulaꞌantic ti muchꞌutic xchꞌunoj scꞌop Riox ti butic jteclumal ay calbetique. Ba xa jqꞌueltic cꞌu xꞌelanic ―xut la li Bernabee. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Li Bernabee jaꞌ la tscꞌan chicꞌ echꞌel li Juane, jaꞌ ti Marcos sbi noxtoque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero li Pabloe mu xa la scꞌan xicꞌ echꞌel, jaꞌ la ti tey icomtsanvan ta estado Panfiliae, ti muc la scolta sba ta yalel li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Yuꞌun ti xꞌelan mu coꞌoluc isnopic ti chiqꞌuic echꞌel li Marcose, ixchꞌac o la sbaic. Li Bernabee jaꞌ la iyicꞌ echꞌel li Marcose. Iꞌochic la ta barco, ibatic la ta Chipre. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Li Pabloe jaꞌ xa la iyicꞌ echꞌel li Silase. Ti muchꞌutic xchꞌunoj scꞌop Riox ta Antioquíae, iscꞌoponic la Riox ti acꞌu chiꞌinaticuc, ti acꞌu qꞌuelaticuc echꞌel li Pabloe xchiꞌuc li Silase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Iloqꞌuic la echꞌel li chaꞌvoꞌe, iꞌechꞌic la ta estado Siria xchiꞌuc ta estado Cilicia. Echꞌ la spatbeic yoꞌon ti muchꞌutic xchꞌunoj scꞌop Riox ta jujun jteclume. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Tsꞌacal to icꞌotic la ta Derbe xchiꞌuc ta Listra li Pabloe xchiꞌuc li Silase. Ta Listrae tey la istaic jun ti muchꞌutic yichꞌoj ta mucꞌ ti Cajvaltic Jesucristoe, Timoteo sbi. Jurio la ti smeꞌe, yichꞌoj la ta mucꞌ uc ti Cajvaltic Jesucristoe. Ti stote jgrecia la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Li Timoteoe “sjunul yoꞌon yichꞌoj ta mucꞌ ti Cajvaltic Jesuse”, xiic la ti muchꞌutic xchꞌunoj scꞌop Riox ta Listrae xchiꞌuc ta Iconioe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Li Pabloe isnop ti chicꞌ echꞌel xchiꞌin li Timoteoe, yechꞌo un iyacꞌbe la yichꞌ circuncisión yoꞌ la xꞌichꞌbat o ta mucꞌ cꞌusi chale. Yuꞌun la ep jurioetic yoꞌ bu ta xbatique, snaꞌojic la scotolic ti jgrecia ti stote. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ti ta jujun jteclume echꞌ la yalbeic ti muchꞌutic xchꞌunoj li scꞌop Rioxe ti cꞌu xꞌelan icom o scꞌoplal yuꞌunic circuncisión li apoxtoletique xchiꞌuc li jchanubtasvanejetic ta Jerusalene, yoꞌ la xaꞌibeic o smelol uque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jun xa la yoꞌonic icomic ti muchꞌutic xchꞌunoj scꞌop Riox ta jujun jteclume, jujun la cꞌacꞌal ipꞌolic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Li Pabloe xchiꞌuc li Silase ipajesatic to la yuꞌun ti Chꞌul Espíritue ti mu to xuꞌ chba yalic aꞌyuc scꞌop Riox ta estado Asiae. Ta estado Frigia xchiꞌuc ta estado Galacia xa la ibatic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Cꞌalal icꞌotic ta stsꞌac estado Misiae, chbatic ox la ta estado Bitinia, pero ipajesatic la noxtoc yuꞌun ti Chꞌul Espíritue. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ta estado Misia xa la ibatic. Icꞌotic la ta jun jteclum ta tiꞌmar, Troas sbi. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Li Pabloe isvaychin la jun jmacedonia, tey la vaꞌal iyil. “Laꞌ coltaoticotic liꞌ ta Macedoniae”, xꞌutat la yilel ta svayiche. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ti cꞌalal ivaychin li Pabloe, teon uc, voꞌon li Lucasone. Jaꞌo ijchap jbaticotic, ijsaꞌticotic barco mi oy chbat ta Macedonia. Yuꞌun iyul ta jolticotic ti jaꞌ yech tscꞌan ti Rioxe ti tey chba calticotic aꞌyuc ti jaꞌ chacꞌ jcuxlejaltic ta sbatel osil ti Cajvaltic Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Liꞌochoticotic ta barco, tucꞌ libatoticotic ta jun balamil ta oꞌlol mar, Samotracia sbi. Ta yocꞌomal noxtoque lixanavoticotic ta barco, licꞌototicotic ta jun jteclum, Neápolis sbi. Jaꞌto tey lilocꞌoticotic ta barco. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ta cocticotic xa libatoticotic ta jteclum Filipose. Li Filipos ta estado Macedoniae, mucꞌta jteclum. Tey batem ep jromaetic. Tey lipajoticotic jayib cꞌacꞌal ta Filipose. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jaꞌo scꞌacꞌalil ta xcuxic li jꞌisraeletique ti cꞌalal lilocꞌoticotic ta tiꞌ jteclume. Libatoticotic ta tiꞌ ucꞌum. ―Ba jqꞌueltic mi muc muchꞌu tey stsoboj sbaic ta scꞌoponic Riox ―xichioticotic. Naca ants tey tsobol cꞌot jtaticotic. Lichotioticotic, icalbeticotic ti jaꞌ chacꞌ jcuxlejaltic ta sbatel osil ti Jesucristoe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Oy jun ants lec iyaꞌi ti cꞌusi icalticotique, Lidia sbi. Tey liquem tal ta jteclum Tiatira. Chon morado manta tspas. Xchꞌunoj ti jun noꞌox ti Rioxe, jaꞌ ti Riox ta vinajele. Ipꞌijubtasat yuꞌun ti Rioxe, yechꞌo ti ixchꞌun ti cꞌusi iyal li Pabloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iyichꞌic voꞌ sjunlejic ta na ti Lidiae. Ti cꞌalal laj yichꞌic voꞌe, ―Mi achꞌunojic ti quichꞌoj xa ta mucꞌ ti Cajvaltic Jesucristoe, tsoblicotic echꞌel ta jna. Xuꞌ xapajic jayibuc cꞌacꞌal ―xiyutoticotic ti Lidiae. Mu xaꞌi albel ti antse, yechꞌo un lipajoticotic. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ti jꞌechꞌele jaꞌo chibatoticotic yoꞌ bu ta scꞌoponic Rioxe, ijnupticotic ta be jun tseb, ochem pucuj ta yoꞌon. Xil scotol ti cꞌusi ta jpastique, snaꞌ yalel buy ti cꞌusi ta xchꞌaye. Oy yajvaltac. Ti yajvaltaque ep ispasic o canal ti snaꞌ yalel yeche. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ti bu ijnupticotique, tey noꞌox isut, napꞌal xa echꞌel ta jpaticotic. Iꞌavan: ―Li viniquetic leꞌe jaꞌ chtunic yuꞌun ti Riox ta vinajele. Jaꞌ chayalbeic ti cꞌuxi xuꞌ chacuxiic ta sbatel osile ―xi ti tsebe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ep cꞌacꞌal tey xnapꞌet, jaꞌ yech iyalulan. Chopol iyaꞌi li Pabloe. Isqꞌuel sutel spat. ―Jaꞌ ta syuꞌel ti Jesucristoe chacalbe, locꞌan ta yoꞌon li tsebe ―xut ti pucuje. Ora ilocꞌ ti pucuje. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ti yajvaltac ti tsebe iyilic ti mu xa bu tspasic o canale, jaꞌ ti ilocꞌ xa ti pucuj ta yoꞌone. Jaꞌ istsaquic o li Pabloe xchiꞌuc li Silase. Iyiqꞌuic echꞌel ta stojol jmeltsanejcꞌopetic ta chꞌivit yuꞌun jaꞌ tey tsmeltsanic cꞌop. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ti cꞌalal icꞌotique ―Li viniquetic liꞌi jurioetic. Ep ta socbe sjol crixchanoetic liꞌ ta jlumaltique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Oy cꞌusi chaqꞌuic ta chanel pero mu xtun jchantic. Mu xuꞌ jpastic yech lavi jaꞌ scuentainojotic ti preserente ta Romae ―xi ti yajvaltac tsebe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","―Yechaꞌa ―xi ti crixchanoetique. Ti jmeltsanejcꞌopetique isloqꞌuesic mantal ti acꞌu locꞌbatuc scꞌuꞌ li Pabloe xchiꞌuc li Silase, ti acꞌu acꞌbaticuc teꞌe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iꞌacꞌbatic tajmec. Ti cꞌalal ilaje, itiqꞌueic ta chuquel. Iyalbeic la ti jchabiejchuclebale ti acꞌu xchabi leque. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ti cꞌalal iꞌalbat yech ti jchabiejchuclebale, itiqꞌueic la ochel ta más yut ti chuclebale. Icacanbat la yoquic ta lotsꞌobteꞌ. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ta ol acꞌubale iscꞌoponic la Riox li Pabloe xchiꞌuc li Silase, isqꞌuevujintaic la ti Rioxe. Iyaꞌiic la ti yan jchuqueletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ti cꞌalal yolel chqꞌuevujinique, ital la tsots niquel. Xvuyvon xa la li chuclebale. Ora la ijam li stiꞌiltaque. Ijituj la ti carinaetic chucbil o scꞌobic scotol ti jchuqueletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Cꞌalal ital ti niquele, ijulav la ti jchabiejchuclebale. Iyil la ti jamajtic xa li tiꞌchuclebale, ora la isloqꞌues yespada. Ta ox la smil sba stuc yuꞌun la isnop ti ijatav xa scotol ti jchuqueletique. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Iꞌavan la li Pabloe: ―Mu xamil aba, liꞌoticotic jcotolticotique ―xut la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ti jchabiejchuclebale iscꞌan la cꞌocꞌ, iꞌoch la sqꞌuelelic ta anil li Pabloe xchiꞌuc li Silase. Pero xtꞌeltꞌon xa la. Isquejan la sba ta yichonic li Pabloe xchiꞌuc li Silase, jaꞌo la isnijan sba ta balamil noxtoc. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Li Pabloe xchiꞌuc li Silase iloqꞌuesatic la yuꞌun ti jchabiejchuclebale. ―Totic, ¿cꞌusi ta jpas yoꞌ xicuxi o ta sbatel osile? ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","―Chꞌuno ti jaꞌ istoj jmultic ti Cajvaltic Jesucristoe, yoꞌ xacuxi o ta sbatel osile. Jaꞌ noꞌox yech xuꞌ chacuxiic acotolic ―xutic la li Pabloe xchiꞌuc li Silase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iyalbeic la cꞌusi yaloj ti Cajvaltic Jesucristoe. Iyaꞌiic la sjunlejic ta na. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ti bu yayijemic ta majele, ipoxtabatic la ta acꞌubaltic yuꞌun ti jchabiejchuclebale. Iyichꞌic la voꞌ sjunlejic ta na ti jchabiejchuclebale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tsꞌacal to li Pabloe xchiꞌuc li Silase iꞌiqꞌueic la ochel ta sna ti jchabiejchuclebale, imacꞌlinatic la. Xmuyubajic xa la sjunlejic ta na ti ixchꞌunic xa li scꞌop Rioxe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ti cꞌalal isacube, ti jmeltsanejcꞌopetique istaquic la echꞌel jayvoꞌ mayoletic. ―Ba albo yaꞌi li jchabiejchuclebale ti acꞌu sloqꞌues li chaꞌvoꞌ jchuquele ―xꞌutatic la echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Cꞌalal iyaꞌi ti jchabiejchuclebale ti cꞌusi iyalic ti jmeltsanejcꞌopetique, iꞌalbat la li Pabloe: ―Li jmeltsanejcꞌopetique listacbe tal mantal ti xuꞌ xa chajloqꞌuesic echꞌele. Yechꞌo un xuꞌ xa xabatic. Qꞌuelo me abaic echꞌel. Junuc me avoꞌonic ―xꞌutatic la. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Itacꞌav li Pabloe: ―Li jmeltsanejcꞌopetique muc bu smeltsanoj jcꞌoplalticotic. Jaꞌ ta smantalic ti ta bail ta satil iquichꞌticotic teꞌe. Jaꞌ ta smantalic noxtoc ti liꞌochoticotic ta chuquele. Maꞌuc yech smelol ti xꞌelan tspasique yuꞌun scuentainojoticotic li Roma uque. Lavie yoꞌonuc sloqꞌuesoticotic ta mucul. Maꞌuc yech ti xꞌelan tspasique. Acꞌu tal sloqꞌuesoticotic stuquic ―xi la li Pabloe. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Isut la ti mayoletique, ba la yalbeic jmeltsanejcꞌopetic ti cꞌusi iyal li Pabloe. Ti cꞌalal iyaꞌiique, ixiꞌic la, yuꞌun la iyaꞌiic ti cuentainbilic yuꞌun Roma li Pabloe xchiꞌuc li Silase. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Italic la ti jmeltsanejcꞌopetique, icꞌanbatic la pertonal li Pabloe xchiꞌuc li Silase. Iloqꞌuesatic la ta chuquel. Tucꞌ la iꞌalbatic ti acꞌu loqꞌuicuc echꞌel ta jteclume. ");
INSERT INTO tzoZNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ti cꞌalal iloqꞌuic ta chuquele, tey ibatic ta sna ti Lidiae. Echꞌ spatbeic yoꞌonic ti muchꞌutic xchꞌunojic scꞌop Riox tey ta jteclume, jaꞌo xa iloqꞌuic echꞌel. ");
INSERT INTO tzoZNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ti cꞌalal ibat li Pabloe xchiꞌuc li Silase, tey la iꞌechꞌic ta jteclum Anfípolis xchiꞌuc ta jteclum Apolonia. Icꞌotic la ta jteclum Tesalónica. Tey la jpꞌej templo yoꞌ bu chaꞌiic smantal Riox li xchiꞌilic ta jurioale. ");
INSERT INTO tzoZNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yuꞌun jaꞌ onox yech stalel li Pabloe ti ta xꞌoch ta stemploic li xchiꞌiltaque yoꞌ bu chaꞌiic smantal Riox ti cꞌalal ta xcuxique, yech