﻿USE sofia;
DROP TABLE IF EXISTS sofia.tzoSA_vpl;
CREATE TABLE tzoSA_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tzoSA_vpl WRITE;
INSERT INTO tzoSA_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Liꞌi jaꞌ sjunal sbiic li snitilultac li Jesucristoe. Li Abrahame jaꞌ snitilul li David ti iꞌoch ta mucꞌta ajvalile. Li Abrahame schiꞌuc li Davide jaꞌ to snitilul li Jesucristoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Li snichꞌon li Abrahame Isaac sbi. Li snichꞌon li Isaaque Jacov sbi. Li snichꞌon li Jacove Judá sbi. Li Judae oy ep schiꞌiltac ta voqꞌuel. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Li snichꞌnab li Judae jaꞌ Fares schiꞌuc Zara sbiic. Tamar sbi li smeꞌique. Li snichꞌon li Farese Esrom sbi. Li snichꞌon li Esrome Aram sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Li snichꞌon li Arame Aminadab sbi. Li snichꞌon li Aminadabe Naasón sbi. Li snichꞌon li Naasone Salmón sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Li snichꞌon li Salmone Booz sbi. Li smeꞌ li Booze Rahab sbi. Li snichꞌon li Booze Obed sbi. Li smeꞌ li Obede Rut sbi. Li snichꞌon li Obede Isaí sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Li snichꞌon li Isaie David sbi, jaꞌ li iꞌoch ta mucꞌta ajvalile. Li snichꞌon li Davide Salomón sbi. Li smeꞌ li Salomone jaꞌ li yajnil toꞌox Uríase. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Li snichꞌon li Salomone Roboam sbi. Li snichꞌon li Roboame Abías sbi. Li snichꞌon li Abíase Asa sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Li snichꞌon li Asae Josafat sbi. Li snichꞌon li Josafate Joram sbi. Li snichꞌon li Jorame Uzías sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Li snichꞌon li Uzíase Jotam sbi. Li snichꞌon li Jotame Acaz sbi. Li snichꞌon li Acaze Ezequías sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Li snichꞌon li Ezequíase Manasés sbi. Li snichꞌon li Manasese Amón sbi. Li snichꞌon li Amone Josías sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Li snichꞌon li Josíase Jeconías sbi. Li Jeconíase oy ep schiꞌiltac ta voqꞌuel. Jaꞌ o ista scꞌacꞌalil tal chuqueicuc batel ta Babilonia balumil li jchiꞌiltactic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Batemic xaꞌox ta mozoil ta Babilonia balumil li jchiꞌiltactic li cꞌalal iꞌayan snichꞌon li Jeconíase, Salatiel sbi. Li snichꞌon li Salatiele Zorobabel sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Li snichꞌon li Zorobabele Abiud sbi. Li snichꞌon li Abiude Eliaquim sbi. Li snichꞌon li Eliaquime Azor sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Li snichꞌon li Azore Sadoc sbi. Li snichꞌon li Sadoque Aquim sbi. Li snichꞌon li Aquime Eliud sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Li snichꞌon li Eliude Eleazar sbi. Li snichꞌon li Eleazare Matán sbi. Li snichꞌon li Matane Jacov sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Li snichꞌon li Jacove José sbi. Li Josee la saꞌ yajnil, María sbi. Li Maríae laj yil sba yol, jaꞌ li Jesuse, jaꞌ li Cristo li tꞌujbil onoꞌox yuꞌun Dios ti chtal sventainutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jech iꞌechꞌ chanlajunchop totil meꞌiletic li ilic ta Abraham cꞌalal ta Davide. Jaꞌ snitilul stsacalulic li Abrahame. Jaꞌ jech nojtoc iꞌechꞌ chanlajunchop totil meꞌiletic ti ilic ta David cꞌalal to ichuqueic batel ta Babilonia balumil li jchiꞌiltactic ta israelale. Jaꞌ snitilul stsacalulic li Davide. Cꞌalal ichuqueic batel ta Babilonia balumil li jchiꞌiltactique, iꞌechꞌ to chanlajunchop totil meꞌiletic, jaꞌ o ivocꞌ li Cristoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cꞌalal ivocꞌ li Jesucristoe, jaꞌ jech chac liꞌi. Li smeꞌe, jaꞌ li Maríae, macbil xaꞌox yuꞌun li Josee. Cꞌalal muc toꞌox bu yicꞌoj sbaique, schiꞌuc xaꞌox yol li Maríae. Li yole acꞌbil yuꞌun li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Toj lequil vinic li Josee, mu scꞌan sloꞌilta, mu scꞌan xacꞌ ta qꞌuexlal li scꞌubanbil antse, jaꞌ li Maríae. Taꞌox xicta ta mucul, jaꞌ to mi oy chaꞌvoꞌ yajtextico yoꞌ jech lec ta xcome. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Cꞌalal jech snopoj li Josee, ivaychin. Li ta svaychile laj yil jun yajꞌangel Dios. Jech iꞌalbat yuꞌun li chꞌul ángele: ―José, joꞌot snitilulot li Davide, mu me xal avoꞌon, icꞌo li Maríae. Yuꞌun li yol li schiꞌuque maꞌuc snichꞌon vinic; jaꞌ acꞌbil yuꞌun li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ta xil jun querem. Jesús chavacꞌbe sbi yuꞌun jaꞌ chascoltaic ta amulic, joꞌoxuc ti tꞌujbiloxuc yuꞌun li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jech icꞌot ta pasel li cꞌusi laj yal Dios li cꞌalal la schꞌamunbe ye li buchꞌu iyal scꞌop Dios ta voꞌonee. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta schiꞌin yol jun tojol tseub. Querem ta xil. Emanuel ta xacꞌbe sbi. Dios jchiꞌuctic, xi smelol li sbie, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cꞌalal ijulav li Josee, ischꞌun li cꞌusi iꞌalbat yuꞌun li chꞌul ángele. Laj yicꞌ sbaic schiꞌuc li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero muc bu la schiꞌin sbaic jaꞌ to cꞌalal ivocꞌ li sba yole. Li Josee Jesús laj yacꞌbe sbi li quereme. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cꞌalal ivocꞌ Jesús li te ta jteclum Belén li ta Judea balumile, jaꞌ o ochem ta ajvalilal li Herodese. Cꞌalal voqꞌuem xaꞌox li Jesuse, italic ta Jerusalén jayvoꞌ pꞌijil viniquetic li liquemic talel ta nom li te ta sloqꞌueb cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tal sjaqꞌuic: ―¿Bu oy li mucꞌta ajvalil avuꞌunic li ivocꞌ xae, joꞌoxuc li jꞌisraeloxuque? Yuꞌun cꞌalal te oyuncutic ta jnacutic ta sloqꞌueb cꞌacꞌale, iquilcutic jpꞌej cꞌanal. Jaꞌ svinajeb ti voqꞌuem xa li buchꞌu ta xꞌoch ta ajvalilal avuꞌunique. Jaꞌ yuꞌun tal quichꞌcutic ta mucꞌ ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cꞌalal iyaꞌi li Herodese, icꞌopoj yoꞌonic schiꞌuc scotol li jchiꞌiltactic li te nacalic ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Li Herodese laj yicꞌan talel scotol li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, jaꞌ li jchiꞌiltic ta israelale. Cꞌalal tsobolic xaꞌox scotolique, la sjacꞌanbe bu chvocꞌ li Cristo li scꞌoplal ta xꞌoch ta mucꞌta ajvalil cuꞌuntique. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jech laj yalic: ―Te chvocꞌ ta jteclum Belén li liꞌ ta Judea balumile. Yuꞌun jech onoꞌox tsꞌibabil comel yuꞌun li buchꞌu iyal scꞌop Dios ta voꞌonee: ");
INSERT INTO tzoSA_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Acꞌo mi biqꞌuit noꞌox li jteclum Belén li te ta Judá balumile, pero jaꞌ ichꞌbil ta mucꞌ. Yuꞌun jaꞌ te chlic talel jun ajvalil avuꞌunic. Jaꞌ chaspasic ta mantal, joꞌoxuc li jꞌisraeloxuque, li tꞌujbiloxuc onoꞌox cuꞌune, xi li Diose, jech onoꞌox laj yal li buchꞌu iyal scꞌop Dios ta voꞌonee ―xiic li paleetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Li Herodese ta mucul laj yicꞌan talel li pꞌijil viniquetique. La sjacꞌbe cꞌu ora iyilic li cꞌanale. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Itaqueic batel ta Belén. Jech laj yal li Herodese: ―Batanic ta Belén. Jaqꞌuic lec bu stuqꞌuil oy li unene. Cꞌalal mi la ataique, liꞌ xꞌechꞌ avalbecune yoꞌ chba quichꞌ ta mucꞌ eꞌuc ―xi li Herodese, pero yuꞌun noꞌox ta xloꞌlovan. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Cꞌalal iyaꞌiic li cꞌusi iyal li ajvalil li pꞌijil viniquetique, ibatic. Jaꞌ sbabe batel yuꞌunic li cꞌanal li laj yilic ta sloqꞌueb cꞌacꞌale. Cꞌalal laj yilic ti ta to xanav batel li cꞌanale, xmuybajic noꞌox. Jaꞌ te tijilic batel. Te noꞌox ipaj ta stuqꞌuil na li yoꞌ bu oy li unene. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iꞌochic li pꞌijil viniquetique. Iyilic li unene schiꞌuc li smeꞌe, jaꞌ li Maríae. La squejan sbaic ta stojol li unene, laj yichꞌic ta mucꞌ. Laj yacꞌbeic smoton; jaꞌ cꞌanal taqꞌuin, schiꞌuc pomriox, schiꞌuc mirra. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Li pꞌijil viniquetique iꞌalbatic ta svaychilic yuꞌun Dios ti mu xa me xjelavic li yoꞌ bu oy li Herodese. Ta yan xa o be ibatic li cꞌalal isutic batel ta yosilalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cꞌalal sutemic xaꞌox li pꞌijil viniquetique, ivaychin li Josee. Iyil ta svaychil jun yajꞌangel Dios. Jech iꞌalbat: ―Lican, icꞌo batel li unene schiꞌuc li smeꞌe. Batanic ta ora ta Egipto balumil. Te oyanic. Jaꞌ to mi laj calboxuc ti chasutic batele, jaꞌ to xuꞌ chasutic. Yuꞌun li Herodese tsaꞌ li unene yuꞌun chac smil ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ijulav li Josee, ilic ta ora. Laj yicꞌ batel li unene schiꞌuc li smeꞌ li unene. Ta acꞌubaltic iloqꞌuic batel, ibatic ta Egipto. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te oyic cꞌalal to icham li Herodese. Jech icꞌot ta pasel li cꞌusi laj yal Dios li cꞌalal la schꞌamunbe ye li buchꞌu iyal scꞌop Dios ta voꞌonee: “Ta Egipto balumil ta xquicꞌ echꞌel li Jnichꞌone, xi li Diose”, xi onoꞌox li buchꞌu iyal scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cꞌalal iyaꞌi li Herodes ti iloꞌloat yuꞌun li pꞌijil viniquetique, toj echꞌem iꞌilin. Laj yal mantal ti acꞌo mileuc scotol li bicꞌtal queremutic li bu chib to jabil yichꞌojique, schiꞌuc li bu neneꞌic toe, li te oyic li cꞌu smucꞌul yosilal li Belene. Yuꞌun snaꞌoj Herodes li cꞌu ora laj yilic li cꞌanal li pꞌijil viniquetique, jaꞌ yuꞌun te capal laj yacꞌ ta milel li bu yichꞌojic xa chib jabile. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jech icꞌot ta pasel ta yosilal Belén jech chac cꞌu chaꞌal icꞌot ta pasel ta yosilal Ramá ta voꞌone ti laj yal li Jeremías li iyal scꞌop Dios ta voꞌonee: ");
INSERT INTO tzoSA_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ta yosilal Ramá chlic oqꞌuicuc li antsetic teye. Chlic yat yoꞌonic, choqꞌuita li yolique. Mu spas ta jun yoꞌonic yuꞌun imilbat li yolique, xi li Diose, xi li Jeremíase. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cꞌalal icham li Herodese, te toꞌox oy ta Egipto li Josee. Ivaychin. Icꞌoponat ta svaychil yuꞌun jun yajꞌangel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Jech laj yal li chꞌul ángele: ―Lican, icꞌo batel li unene schiꞌuc li smeꞌe. Sutan batel ta avosilalic li yoꞌ bu oy la achiꞌiltac ta israelale. Li buchꞌu chac toꞌox smil li unene icham xa ―xi li yajꞌangel Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ilic li Josee, laj yicꞌ sutel talel li unen schiꞌuc li smeꞌ li unene. Ijulic liꞌ ta cosilaltique. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yan xaꞌox o ajvalil ochem liꞌ ta Judea balumil li cꞌalal ijulique. Jaꞌ xa ochem li snichꞌon li ánima Herodese, Arquelao sbi. Cꞌalal iyaꞌi li Josee, ixiꞌ. Mu scꞌan xtal liꞌ ta Judea balumile. Iꞌalbat ta svaychil yuꞌun Dios ti acꞌo xba nacluc ta Galilea balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jaꞌ yuꞌun te ba nacluc ta jteclum Nazaret. Jech icꞌot ta pasel ti jech albil onoꞌox scꞌoplal Jesús yuꞌun li buchꞌutic iyalic scꞌop Dios ta voꞌonee: “Jaꞌ jnazaretal vinic, xi scꞌoplal li Jesús yuꞌun li crixchanoetique”, xiic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Cꞌalal te to oy ta Nazaret li Jesuse, jaꞌ o te lic yal scꞌop Dios ta taqui jamaltic li ta Judea balumil li Juan ti chacꞌ ta ichꞌel joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jech lic yal li Juane: ―Ictaic scotol li cꞌustic chopol chapasique yuꞌun ista xa scꞌacꞌalil chasventainic li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuꞌun jech onoꞌox tsꞌibabil scꞌoplal li Juan yuꞌun li Isaías li iyal scꞌop Dios ta voꞌonee. Jech laj yal: Chlic jun jchiꞌiltic ta israelal, tsots ta xal ta taqui jamaltic ti ta xa xtal li Cajvaltique. Jaꞌ yuꞌun ta xal nojtoc: “Ictaic scotol li cꞌustic chopol chapasique. Ichꞌbeic ta mucꞌ li scꞌope”, xi ta xalbe li jchiꞌiltactique, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Li scꞌuꞌ li Juane jaꞌ jalbil tsotsil cameyo. Li schuc schꞌute, nucul. Li sveꞌele xcꞌajben schiꞌuc spom mucꞌta pom. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Scotol li jchiꞌiltactic ta israelal li te nacalic ta Jerusalene ba yaꞌibeic scꞌop li Juane, schiꞌuc li buchꞌutic te nacalic ta spꞌejel li Judea balumile, schiꞌuc li buchꞌutic te nacalic ta nopol tiꞌ ucꞌum Jordane. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Scotol li buchꞌutic jamal iyalic smulique, iꞌacꞌbat yichꞌic joꞌ yuꞌun li Juan li te ta ucꞌum Jordane. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Iyil li Juane ti te ta xtalic ep li buchꞌutic ochemic ta fariseoale schiꞌuc li buchꞌutic ochemic ta saduceoale. Tal scꞌanic yichꞌic joꞌ eꞌuc. Li Juane jech laj yalbe: ―Li joꞌoxuque jun chac stsꞌunbaloxuc li orachone. Li orachone ta xjatav loqꞌuel ta anil li cꞌalal mi iyaꞌi ti ta xa xtal cꞌoqꞌue. Jaꞌ jechoxuc li joꞌoxuque. ¿Mi yuꞌun avaꞌiic ti ta onoꞌox xavichꞌic vocol yuꞌun Dios ti latalic ta anile, yoꞌ tal acꞌanic avichꞌic joꞌe? ");
INSERT INTO tzoSA_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pero scꞌan baꞌi xavaqꞌuic ta ilel mi avictaojic xa li cꞌustic chopol chapasique. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mu me jechuc xanopic: “Jaꞌ jmucꞌta moltotcutic ta voꞌone li Abrahame, jaꞌ jech ta onoꞌox xijcolcutic”, mu me xachiic. Chacalbeic, li Diose xuꞌ yuꞌun ta scꞌatajesbe ta snitilul Abraham li tonetic liꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Li joꞌoxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal teꞌetic ti muc bu lec li sat chaqꞌue. Te xa metsel li yecꞌlal li ta yoque yuꞌun ta xa xichꞌ tsꞌetel. Ta xichꞌ chiqꞌuel ta cꞌocꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Li joꞌone jaꞌ noꞌox cabtel ta xcacꞌbe yichꞌic joꞌ li buchꞌutic ta xictaic li cꞌustic chopol ta spasique. Pero oy to buchꞌu tsꞌacal ta xtal, jaꞌ más tsots yabtel yichꞌoj. Li joꞌone muc bu tsots cabtel quichꞌoj. Mu cꞌusi xuꞌ cuꞌun ta jcolta o. Acꞌo mi yetꞌesbeel xonob, mu xuꞌ chcaꞌi yuꞌun mu cꞌusi xitun o. Yan li buchꞌu tsꞌacal chtale, jaꞌ chayacꞌbeic avichꞌic li Chꞌul Espíritu ti coꞌol schiꞌuc cꞌoqꞌue yuꞌun ta sloqꞌues scotol li cꞌustic chopol ta avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Li buchꞌutic tscꞌan loqꞌuesbeel li cꞌustic chopol ta yoꞌonique, jaꞌ ta xꞌiqꞌueic o sbatel osil. Yan li buchꞌutic mu scꞌan loqꞌuesbeele jaꞌ chbatic o ta cꞌocꞌ li yoꞌ bu mu onoꞌox xtupꞌe. Jech chac cꞌu chaꞌal li buchꞌu ta xicꞌa strigoe, mi ilaj yoꞌon ta yicꞌaele, ta stsob scotol li strigoe, ta sticꞌ ochel ta snail. Scotol li steꞌele schiꞌuc li solile tschicꞌ ta cꞌocꞌ ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cꞌalal yacal ta xacꞌanbe yichꞌ joꞌ li crixchanoetic li Juane, jaꞌ o ilocꞌ talel ta Galilea balumil li Jesuse, te icꞌot ta ucꞌum Jordán yuꞌun tscꞌan ti acꞌo xꞌacꞌbat yichꞌ joꞌ yuꞌun li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Li Juane mu scꞌan xacꞌbe yichꞌ joꞌ li Jesuse. Jech laj yalbe Jesús li Juane: ―Joꞌot chavacꞌbun quichꞌ joꞌ ti jechuque. Mu jechuc o smelol ti joꞌon chacacꞌbe avichꞌ joꞌe ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Itacꞌav li Jesuse: ―Jaꞌ lec acꞌbun quichꞌ joꞌ yoꞌ acꞌo jpastic scotol li cꞌusi tscꞌan li Diose ―xi li Jesuse. Jaꞌ yuꞌun laj yacꞌbe yichꞌ joꞌ Jesús li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cꞌalal laj yichꞌ xa joꞌ li Jesuse, ilocꞌ ta ucꞌum. Iyil ta ora ti ijam li vinajele, ti iyal talel ta sba li Chꞌul Espíritu ti junic schiꞌuc li Diose. Coꞌol schiꞌuc jcot jculajteꞌ yilel. Jech iyichꞌ o li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Li Diose icꞌopoj talel ta vinajel, jech laj yal: ―Liꞌi jaꞌ Jnichꞌon ti toj cꞌux ta coꞌone. Ximuybaj noꞌox yuꞌun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Cꞌalal laj yichꞌ xa joꞌ li Jesuse, iꞌacꞌbat snaꞌ yuꞌun li Chꞌul Espíritu ti acꞌo batuc ta taqui jamaltique, yoꞌ acꞌo qꞌuelbatuc yoꞌon yuꞌun li banquilal pucuje. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cꞌalal te oy ta taqui jamaltic li Jesuse, muc bu xveꞌ chaꞌvinic cꞌacꞌal schiꞌuc chaꞌvinic acꞌubal, jaꞌ yuꞌun ital viꞌnal iyaꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Cꞌalal ta xviꞌnaj tajmec li Jesuse, ital li banquilal pucuje, jaꞌ li Satanase. Tal sloꞌlo Jesús ti yaloje. Jech laj yalbe: ―Mi joꞌot Snichꞌonot li Diose, albo li tonetic liꞌi ti acꞌo cꞌatajuc ta vaje ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Itacꞌav li Jesuse: ―Jech tsꞌibabil ta scꞌop Dios: “Mu ta vajuc noꞌox chijcuxiutic. Jaꞌ scꞌan ta jchꞌunbetic nojtoc li cꞌustic chijyalbutic li Diose”, xi tsꞌibabil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Li banquilal pucuje laj yicꞌ batel ta Jerusalén li Jesuse. Laj yicꞌ muyel ta sjol li mucꞌta chꞌulnae. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jech iyal li banquilal pucuje: ―Mi joꞌot Snichꞌonot li Diose, jip aba yalel liꞌi. Yuꞌun jech tsꞌibabil ta scꞌop li Diose: Dios chastacbe yalel yajꞌangeltac, jaꞌ chaschabi. Jaꞌ chastsac ba ta scꞌobic li chꞌul ángeletique yoꞌ jech mu xamaj aba ta ton, xi tsꞌibabil ―xꞌutat li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Itacꞌav li Jesuse: ―Pero jech tsꞌibabil ta scꞌop li Dios nojtoque: “Mu me xaqꞌuelbeic yoꞌon li Cajvaltic Diose”, xi tsꞌibabil. Mi ta jip jba yalele, yuꞌun ta jqꞌuelbe yoꞌon Dios mi ta melel chiscoltae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Li banquilal pucuje laj yicꞌ batel ta jun toyol vits nojtoc li Jesuse. Ta sjuꞌel noꞌox iyacꞌbe yil spꞌejel balumil ta ora noꞌox schiꞌuc li cꞌu sba ta spasic mantal li ajvaliletique. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jech laj yal li banquilal pucuje: ―Scotol li cꞌusi chavile, jaꞌ avuꞌun scotol mi chavichꞌun ta muqꞌue, mi chaquejan aba ta jtojole ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Itacꞌav li Jesuse: ―Batan, Satanás, mu jchꞌun li cꞌusi chavalbune. Yuꞌun jech tsꞌibabil ta scꞌop li Diose: “Jaꞌ noꞌox xavichꞌic ta mucꞌ stuc li Cajvaltic Diose. Jaꞌ noꞌox xapasic li cꞌusi tscꞌane”, xi tsꞌibabil ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Cꞌalal iyil li banquilal pucuj ti muc spas ta canal li Jesuse, ibat. Italic ta ora yajꞌangeltac li Diose, tal scoltaic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cꞌalal iyaꞌi Jesús ti ochem xa ta chuquel li Juane, isut batel ta Galilea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Laj yicta li jteclum Nazaret li bu ichꞌie, te ba nacluc ta jteclum Capernaum. Li Capernaume te oy ta tiꞌnab li ta yosilic li jtotic jmeꞌtic ta voꞌonee, jaꞌ li Zabulone schiꞌuc li Neftalíe. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jech icꞌot ta pasel li cꞌusi iyal li Isaías li iyal scꞌop Dios ta voꞌonee. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Li yosilic li snitilultac li ánima Zabulone, schiꞌuc li yosilic li snitilultac li ánima Neftalí, li te oy ta nopol tiꞌ mucꞌta nabe schiꞌuc cꞌalal ta tiꞌ ucꞌum Jordane, jaꞌ Galilea ta sbiin yuꞌunic li jyanlum crixchanoetic li te ta xnaquiique. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Scotol li jchiꞌiltactic ta israelal ti ta tsꞌacal to chnaquiic teye, chichꞌic ep vocol. Tsꞌacal to chilic ti xmuybajique yuꞌun jaꞌ te chcꞌot ta stojolic li buchꞌu acꞌbil yabtel yuꞌun li Diose, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cꞌalal ba nacluc ta jteclum Capernaum li Jesuse, jaꞌ o lic spas li yabtele. Laj yalanbe li jchiꞌiltactique: ―Ictaic scotol li cꞌustic chopol chapasique yuꞌun ista xa scꞌacꞌalil chasventainic li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Li Jesuse ixanav batel ta tiꞌtiꞌnab li te ta Galilea balumile. Te iyil chaꞌvoꞌ jchiꞌiltic ta israelal, jaꞌ sbanquil yitsꞌin sbaic. Li june Simón sbi, Pedro li schaꞌmojol sbie. Andrés sbi li itsꞌinale. Te yaquic tstiqꞌuel ochel snutiꞌic ta nab li stsacobil schoyique yuꞌun ta stsaquic choy. Yuꞌun jaꞌ yabtelic. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Li Jesuse jech laj yalanbe: ―Laꞌ chiꞌinicun batel, chajeltabeic la avabtelique. Chajchanubtasic li cꞌu sba chba asaꞌbecun talel crixchanoetique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Laj yictaic ta ora li yabtelique, la schiꞌinic batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cꞌalal ijelavic batel li Jesuse schiꞌuc li chaꞌvoꞌ jchiꞌiltique, te iyil yan chaꞌvoꞌ jchiꞌiltic. Jaꞌ sbanquil yitsꞌin noꞌox sbaic nojtoc. Jaꞌ snichꞌnab Zebedeo. Jacobo sbi li banquilale, Juan sbi li itsꞌinale. Te tiqꞌuilic ta yut canava schiꞌuc li stotique, yuꞌun yacal ta slutꞌilanic snutiꞌic stsacobchoyic yuꞌun jatem. Iꞌiqꞌueic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Te laj yictaic ta ora li stotique schiꞌuc li scanavaique, jaꞌ la schiꞌinic batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Li Jesuse la xan spꞌejel Galilea balumil schiꞌuc li yajchanbalajeltaque. Te ichanubtasvan ta jupꞌej chꞌulnaetic yuꞌun li jchiꞌiltactic ta israelale. Laj yalbe yaꞌiic ti ista xa scꞌacꞌalil ti chventainatic yuꞌun li Diose. La scoltaan nojtoc ep jchamelajeletic, cꞌusiuc noꞌox chamelal ti ip chaꞌiique. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta spꞌejel Siria balumile ivinaj scꞌoplal ti la scoltaan ep jchamelajeletic li Jesuse. Butic iꞌechꞌ li Jesuse te laj yiqꞌuic talel ta stojol ep jchamelajeletic. Ep ta chop chamel ta xaꞌiic. Laj talanuc li buchꞌutic oy cꞌustic cꞌux ta xaꞌiique, schiꞌuc li buchꞌutic ochem pucuj ta yoꞌonique, schiꞌuc li buchꞌutic snupojic tupꞌ‐iqꞌue, schiꞌuc li buchꞌutic muꞌyuc yipal jun yoc scꞌobique. Scotol icol yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Toj ep crixchanoetic la schiꞌinic batel li Jesuse. Jaꞌ li buchꞌutic te nacalic ta Galilea balumile, schiꞌuc ta Decápolis balumil li yoꞌ bu oy lajuneb jteclumetique, schiꞌuc ta jteclum Jerusalén, schiꞌuc ta yan jteclumetic li ta Judea balumile. Schiꞌuc li buchꞌutic te nacalic ta jot ucꞌum Jordane. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cꞌalal iyil Jesús ti toj ep te tsobolic li jchiꞌiltactic ta israelale, imuy ba jutuc ta vits li Jesuse. Te ichoti. Te lijbatcutic eꞌuc, joꞌoncutic li yajchanbalajeltacuncutique. Ibatic eꞌuc li buchꞌutic ta sloqꞌuel yoꞌonic tscꞌan chaꞌibeic scꞌop li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Lic chanubtasvanuc li Jesuse. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Li buchꞌutic tscꞌanic coltaele yuꞌun snaꞌic ti muꞌyuc onoꞌox slequil yoꞌonic li stuquic noꞌoxe, chilic ti xmuybajic noꞌoxe yuꞌun chventainatic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Li buchꞌutic ch‐oqꞌuic ta scoj ti oy smulique, chilic ti xmuybajic noꞌoxe yuꞌun chpatbat yoꞌonic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Li buchꞌutic mu snaꞌ stoy sbaique, chilic ti xmuybajic noꞌoxe yuꞌun jaꞌ ta schiꞌinic ta pasmantal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Li buchꞌutic ta sloqꞌuel yoꞌonic tscꞌanic ti acꞌo tuqꞌuibuc yoꞌonique, chilic ti xmuybajic noꞌoxe yuꞌun chtuqꞌuib yoꞌonic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Li buchꞌutic chcꞌuxubinvanique, chilic ti xmuybajic noꞌoxe yuꞌun chcꞌuxubinatic eꞌuc yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Li buchꞌutic ta sloqꞌuel yoꞌonic tscꞌan tspasic li cꞌustic ta scꞌan li Diose, chilic ti xmuybajic noꞌoxe yuꞌun chba yojtaquinic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Li buchꞌutic ta slajesbe yoꞌonic li buchꞌutic tscontrain sbaique, chilic ti xmuybajic noꞌoxe yuꞌun “jaꞌ jnichꞌnab”, xi scꞌoplalic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Li buchꞌutic chichꞌic ilbajinel ta sventa ti lec li cꞌustic tspasique, chilic ti xmuybajic noꞌoxe yuꞌun chventainatic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Li joꞌoxuque muybajanic noꞌox mi ta jventa joꞌon ti chopol chayilic li crixchanoetique, mi chayilbajinique, mi chasaꞌboxuc amulique. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muybajanic noꞌox me, patetuc me avoꞌonic yuꞌun toj lec li cꞌusi chcꞌot avichꞌic li te ta vinajele. Jech onoꞌox laj yichꞌic ilbajinel eꞌuc li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Li joꞌoxuque coꞌol schiꞌuc atsꞌamoxuc yaꞌel yuꞌun joꞌoxuc ta aventaic ta xtuqꞌuibic li crixchanoetique. Mi lec li cꞌustic chapasique, lec chatunic liꞌ ta balumile. Yan mi chopol li cꞌustic chapasique, mu cꞌusi xatunic o. Jech chac cꞌu chaꞌal li atsꞌam ti mi muc xa bu chiꞌe, mu xa cꞌusi xtun o, ta xichꞌ jipel batel. Te chlaj ta pechꞌulanel ta teqꞌuel yuꞌun li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Li joꞌoxuque coꞌol schiꞌuc xojobaloxuc cꞌocꞌ yaꞌel sventa ta xil o li crixchanoetique. Yuꞌun joꞌoxuc chavaqꞌuic ta ilel ti oy slequil avoꞌonique. Jech chac cꞌu chaꞌal mi oy jun mucꞌta jteclum ta jolvitse, lec xvinaj. Mu stacꞌ muquel, scotol cꞌacꞌal lec xvinaj o. Jaꞌ jechoxuc eꞌuc li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jech nojtoc mi ta jtsan jcantiltique, muc bu ta jnujmaquitic ta moch. Ta jcuxantic ta scuxanobil. Jech ta xacꞌ o xojobal ta spꞌejel li yut jnatique. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Li joꞌoxuque jaꞌ jech scꞌan chavaqꞌuic ta ilel ti tuqꞌuibem xa la avoꞌonique. Jaꞌ ta xilic o li crixchanoetique, jech chlic yichꞌic ta mucꞌ li Jtotic ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Mu me xanopic ti tal jchꞌaybe scꞌoplal li smantaltac li Diose schiꞌuc li cꞌustic laj yal li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Muc bu tal jchꞌaybe scꞌoplal li smantaltac li Diose; jaꞌ tal jpas scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Melel li cꞌusi chacalbeique, cꞌalal muc toꞌox bu lajem li vinajel balumile, mu jpꞌeluc ta xchꞌay scꞌoplal li cꞌustic yaloj li Diose, persa chcꞌot ta pasel scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Li buchꞌu jpꞌel xa noꞌox mu xacꞌ ta venta li smantaltac li Diose, mi jech chalbe yaꞌiic eꞌuc li crixchanoetique, jaꞌ itsꞌinal chcꞌot li yoꞌ bu tspas mantal li Diose. Li buchꞌu chacꞌ ta venta scotol li smantaltac li Diose, mi jech chalbe yaꞌiic eꞌuc li crixchanoetique, jaꞌ banquilal chcꞌot li yoꞌ bu tspas mantal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chacalbeic, li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li jfariseoetique, ta spꞌis sbaic ti oy slequil yoꞌonique. Pero li joꞌoxuque scꞌan ti ta melel oy slequil avoꞌonique. Yuꞌun mi jaꞌ noꞌox jechoxuc jech chac cꞌu chaꞌal li jfariseoetique, mu xuꞌ chaꞌochic eꞌuc li yoꞌ bu tspas mantal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Avaꞌiojic onoꞌox ti jech iꞌalbatic comel li jtotic jmeꞌtic ta voꞌonee: “Mu me xamilvanic. Li buchꞌu chmilvane ta me xichꞌ milel eꞌuc”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero joꞌon chacalbeic, li buchꞌu chilta li schiꞌile, schiꞌuc li buchꞌu chopol chil li schiꞌile, schiꞌuc li buchꞌu chopol li cꞌusi chalbe ta sat li schiꞌile, coꞌol schiꞌuc jmilvanej yaꞌel. Coꞌol te chbatic ta mucꞌta cꞌocꞌ schiꞌuc li jmilvanejetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Jaꞌ scꞌan ti lec chavil aba achiꞌuc la achiꞌiltaque. Mi chba avacꞌbeic smoton Dios li bu scajlebe, mi te ijul ta ajol ti oy amul ta stojol la achiꞌile, jaꞌ lec ictao te ta stsꞌel scajleb smoton Dios li cꞌusi avichꞌoj batele. Ba meltsanbano acꞌopic achiꞌuc li buchꞌu oy amul ta stojole. Mi imeltsaj avuꞌunique, jaꞌ to xuꞌ chtal avacꞌbe smoton li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Mi oy ata amulic ta stojol la achiꞌilique, jaꞌ scꞌan ti chameltsanbeic scꞌoplal ta orae. Yuꞌun mi muc bu smeltsaj la acꞌopique, chayacꞌ ta scꞌob li jꞌabteletique. Li jꞌabteletique chayacꞌ ta scꞌob mayoletic. Li mayoletique chastiqꞌuic ta chuquel. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Melel li cꞌusi chacalbeique, mi mu xapasic jech chac cꞌu chaꞌal laj calboxuque, scotol chayacꞌbeic atojic li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Avaꞌiojic onoꞌox ti jech iꞌalbatic li jtotic jmeꞌtic ta voꞌonee: “Mu me xasaꞌic avantsic. Li antsetique mu me saꞌ svinicalic”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero joꞌon chacalbeic, li buchꞌutic ta spichꞌ o yoꞌonic li antse, schiꞌuc li buchꞌutic ta spichꞌ o yoꞌonic li vinique, coꞌol schiꞌuc imulivaj xa yaꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Mi ta scoj noꞌox asatic ti chata o amulique, muc bu lec. Scꞌan ti chapajes abaique jech chaꞌochic o ta vinajel. Abol abaic mi ta scoj noꞌox asatic ti chabatic o ta mucꞌta cꞌocꞌ sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jech nojtoc mi ta scoj noꞌox acꞌobic ti chata o amulique, muc bu lec. Scꞌan ti chapajese jech chaꞌochic o ta vinajel. Abol abaic mi ta scoj noꞌox acꞌobic ti chabatic o ta mucꞌta cꞌocꞌ sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Avaꞌiojic nojtoc ti jech iꞌalbatic li jtotic jmeꞌtic ta voꞌonee: “Li buchꞌu chicta yajnile, acꞌo smeltsanbe sjunal ti yictaoj xa sbaique, acꞌo yacꞌbe ta scꞌob li yajnile, jaꞌ to jech xuꞌ chicta sbaic”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero joꞌon chacalbeic, li buchꞌu ta xicta yajnile, mi muc bu mulivajem schiꞌuc yan vinic ti jech ta xictae, coꞌol schiꞌuc mulivajem yaꞌel li yajnile yuꞌun la sutes. Li buchꞌu ta xicꞌ li sutem antse, chmulivaj nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Avaꞌiojic nojtoc ti jech iꞌalbatic comel ta voꞌonee: “Mi chavalic ti jaꞌ avajtexticoic li Diose, persa chapasic li cꞌusi avalique”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero joꞌon chacalbeic, mu me xavalic ti jaꞌ avajtexticoic li vinajele, yuꞌun te chotol ta spas mantal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu me xavalic ti jaꞌ avajtexticoic li balumile yuꞌun jaꞌ sventainoj li Diose. Mu me xavalic ti jaꞌ avajtexticoic li Jerusalene yuꞌun jaꞌ li jteclum ti tꞌujbil yuꞌun li banquilal ajvalile, jaꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu me xavalic ti jaꞌ avajtexticoic la ajolique yuꞌun jaꞌ spasoj li Diose. Yuꞌun li stsotsil ajolique mu stacꞌ chacꞌatajesic ta sac, mu stacꞌ chacꞌatajesic ta icꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Meleluc me li cꞌustic chavalique. Ti mi muc bu jeche, mu me xavalic. Yuꞌun mi chavalique, jaꞌ mulil. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Avaꞌiojic onoꞌox ti jech iꞌalbatic comel ta voꞌonee: “Mi chasocbeic jpꞌej sat la achiꞌilique, ta me xavichꞌic socbeel jpꞌej asatic eꞌuc. Mi chacꞌocbeic jpꞌej stanal ye la achiꞌilique, ta me xavichꞌic cꞌocbeel jpꞌej stanal aveic eꞌuc”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero joꞌon chacalbeic, mu me xapacbeic sutel li buchꞌu chopol li cꞌusi chaspasbeique. Mi oy buchꞌu chasmajbeic jot xocon asatique, acꞌo smajboxuc schaꞌjotol. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi oy buchꞌu ta jech noꞌox chasaꞌboxuc amulic ta stojol li jꞌabteletique, mi chac spojboxuc batel acꞌuꞌique, acꞌo yichꞌ batel. Acꞌo yichꞌ batel apuychijic nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mi oy buchꞌu chasujoxuc ta icatsil junuc revae, cuchbeic batel chibuc reva. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mi oy buchꞌu chascꞌanbeic li cꞌusi oy avuꞌunique, acꞌbeic. Mi oy cꞌusi chaschꞌamunbeique, mu me xajalanic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Avaꞌiojic nojtoc ti jech iꞌalbatic comel ta voꞌonee: “Cꞌuxubinano la achiꞌiltaquique, pero la avajcontraique contrainic”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero joꞌon chacalbeic, cꞌuxubino la avajcontraique. Cꞌanbeic Dios ti acꞌo yacꞌbe li cꞌustic lec li buchꞌutic chopol chcꞌopojic ta atojolique. Lec xacꞌoponic li buchꞌutic chayiltaique, jaꞌ chvinaj o ti jeltajem xa la avoꞌonique. Cꞌoponbeic Dios li buchꞌutic chayilbajinique yuꞌun mu snaꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mi jaꞌ jech chapasique, jaꞌ chvinaj o ti snichꞌnaboxuc li Jtotic Dios ta vinajele. Yuꞌun li Diose coꞌolcoꞌol ta xacꞌbe talel joꞌ ta stojolic li buchꞌutic lec yoꞌonique schiꞌuc li buchꞌutic chopol yoꞌonique. Jmoj ta xacꞌ qꞌuepuc ta stojol li buchꞌutic chopolique schiꞌuc li buchꞌutic lequique. Coꞌolcoꞌol ta xacꞌbe slequilal yutsilal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mi jaꞌ noꞌox oy ta avoꞌonic li buchꞌutic lec xavil aba achiꞌuquique, mu xvinaj o mi más lec la avoꞌonique. Yuꞌun jaꞌ noꞌox jechoxuc jech chac cꞌu chaꞌal li jtsobpatanetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi jaꞌ noꞌox lec chacꞌoponic li buchꞌutic lec xavojtaquin aba achiꞌuquique, mu xvinaj o mi más lec la avoꞌonique. Yuꞌun jaꞌ noꞌox jechoxuc jech chac cꞌu chaꞌal li buchꞌutic ti mu xichꞌic ta mucꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Li joꞌoxuque scꞌan ti oy slequil avoꞌonic jech chac cꞌu chaꞌal oy slequil yoꞌon li Jtotic Dios ta vinajele ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jech laj yalbuncutic nojtoc li Jesuse: ―Qꞌuelo me abaic li cꞌalal chapasic li cꞌustic tscꞌan li Diose. Mu me xapasic ta sventa chacꞌanic ichꞌel ta mucꞌ. Yuꞌun mi jech chapasique, altic. Muc bu chayacꞌbeic amotonic li Jtotic Dios ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cꞌalal mi oy buchꞌu chavacꞌbe slequil avoꞌone, maꞌuc me xaloꞌet xa o jech chac cꞌu chaꞌal li buchꞌutic spꞌisoj sbaic ti chichꞌic ta mucꞌ li Diose. Yuꞌun mu xichꞌ smelolic. Te xloꞌetic ta schꞌulnaic, mi ta chꞌivit cꞌuxi, li cꞌalal ta xacꞌ slequil yoꞌonique. Yuꞌun jaꞌ tscꞌanic ti lec ta xꞌileic yuꞌun li schiꞌilique. Melel li cꞌusi chacalbeique, altic ti jech tspasique yuꞌun jaꞌ noꞌox lec scꞌoplalic li ta schiꞌilique, mu cꞌu chtun o chil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Li joꞌoxuque mu me jechuc avoꞌonic ti chavaqꞌuic ta ilel li cꞌalal chavacꞌ slequil avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Acꞌo mi ta mucul chavaqꞌuic pero li Jtotic Diose sqꞌueloj scotol. Más chayacꞌboxuc slequilal yutsilal. Li slequilal yutsilal Dios ti chayacꞌbeique chil scotol crixchano. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Cꞌalal chataic ta naꞌel li Diose, mu me jechuc xapasic jech chac cꞌu chaꞌal tspasic li buchꞌutic spꞌisoj sbaic ti chichꞌic ta mucꞌ li Diose. Yuꞌun mu xichꞌ smelolic. Chvaꞌiic ta schꞌulnaic schiꞌuc ta chiquin cayaetic li cꞌalal ta staic ta naꞌel li Diose yoꞌ lec xꞌileic yuꞌun li schiꞌilique. Melel li cꞌusi chacalbeique, altic ti jech tspasique yuꞌun jaꞌ noꞌox lec scꞌoplalic li ta schiꞌilique, mu cꞌu chtun o chil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Li joꞌoxuque mu me jechuc avoꞌonic ti chavaqꞌuic ta ilel li cꞌalal chataic ta naꞌel li Diose. Vocꞌ abaic atuquic li cꞌalal chataic ta naꞌel li Diose. Acꞌo mi ta mucul chataic ta naꞌel pero li Jtotic Diose sqꞌueloj scotol. Más chayacꞌboxuc slequilal yutsilal. Li slequilal yutsilal Dios ti chayacꞌbeique chil scotol crixchano. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cꞌalal chataic ta naꞌel li Diose, mu me jechuc xacꞌoponic jech chac cꞌu chaꞌal tscꞌoponic li yajrioxic li jyanlumal crixchanoetic ti mu xichꞌic ta mucꞌ li Diose. Yuꞌun jaꞌ noꞌox ta schaꞌalulanic li cꞌusi chalic li cꞌalal tscꞌoponic li yajrioxique, yuꞌun chalic ti jaꞌ to jech ta xꞌaꞌibatic o li scꞌopique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Li joꞌoxuque mu me jechuc xapasic. Yuꞌun li Jtotic Diose snaꞌoj onoꞌox li cꞌustic chtun avuꞌunic li cꞌalal muc to bu acꞌanojbeique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Li cꞌalal chataic ta naꞌel Dios li joꞌoxuque, xi xacꞌopojique: Jtotic Dios ti te oyot ta vinajele, acꞌo me quichꞌotcutic ta mucꞌ jcotolcutic liꞌ ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Acꞌo me cꞌotuc scꞌacꞌalil chtal apas mantal atuc liꞌ ta balumile. Acꞌo me jaꞌuc jpascutic li cꞌusi chacꞌan liꞌ ta balumile jech chac cꞌu chaꞌal li te ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Acꞌbuncutic talel jveꞌelcutic li avi cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasbuncutic perton yuꞌun li jmulcutique jech chac cꞌu chaꞌal ta jpasbecutic perton li buchꞌutic oy smul cuꞌuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mu me xavacꞌuncutic ta pasel ta canal li ta mulile. Coltauncutic me. Yuꞌun joꞌot atuc chapas mantal sbatel osil. Echꞌem atsatsal ajuꞌel. Joꞌot chaquichꞌcutic ta mucꞌ sbatel osil. Jaꞌ jech acꞌo cꞌotuc ta pasel ta jtojolcutic, xachi xacꞌopojic li cꞌalal chataic ta naꞌel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Mi chapasbeic perton li buchꞌu oy smul avuꞌunique, jech chaspasbeic perton yuꞌun amulic eꞌuc li Jtotic ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mi mu xapasbeic perton li buchꞌu oy smul avuꞌunique, jaꞌ noꞌox jech eꞌuc muc bu chaspasbeic perton li Jtotic ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ti mi chavicta aviximic li cꞌalal chataic ta naꞌel li Diose, mu me xapasic jech chac cꞌu chaꞌal tspasic li buchꞌutic spꞌisoj sbaic ti yichꞌojic xa ta mucꞌ li Diose. Tsbon satic ta tan yoꞌ chaqꞌuic ta ilel ti yictaoj yiximique. Melel li cꞌusi chacalbeique, altic ti jech tspasique yuꞌun jaꞌ noꞌox lec scꞌoplalic li ta schiꞌilique, mu cꞌu chtun o chil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Li joꞌoxuque mu me jechuc avoꞌonic ti chavaqꞌuic ta ilel ti cꞌalal avictaoj aviximique. Tus ajolic, poc asatic jech chac cꞌu chaꞌal cꞌu sba cuxuloxuc onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jech muc buchꞌu chil ti avictaoj aviximique. Jaꞌ noꞌox chil stuc li Jtotic Diose. Mi jech chapasique, más chayacꞌboxuc slequilal yutsilal. Li slequilal yutsilal Dios ti chayacꞌbeique chil scotol crixchano. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mu me xbat avoꞌonic ta saꞌulanel acꞌulejalic liꞌ ta balumile yuꞌun chlaj ta chil, schiꞌuc ta xcuxin, schiꞌuc chbat ta elcꞌanel. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jaꞌ lec acꞌo tunuc yuꞌun Dios li cꞌustic oy avuꞌunique jech oy acꞌulejalic te ta vinajel, yuꞌun jaꞌ mu xlaj ta chil, schiꞌuc mu xcuxin, schiꞌuc mu xbat ta elcꞌanel. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yuꞌun mi te oy acꞌulejalique, jaꞌ te batem o avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mi chacꞌuxubinvanique, jech chatunic o yuꞌun li Diose. Jaꞌ jechoxuc jech chac cꞌu chaꞌal li lámpara mi lec chtile, lec chquiltic o osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mi mu xacꞌuxubinvanique, jaꞌ jechoxuc jech chac cꞌu chaꞌal li lámpara ti mu xtil leque yuꞌun oy bu soquem. Mi jaꞌ jech avoꞌonique, mu xuꞌ chatunic yuꞌun li Diose yuꞌun jaꞌ noꞌox chacꞌanic ti lec oyoxuc atuquique. Jaꞌ ta xchꞌay o ta avoꞌonic li scꞌop Dios li achꞌunojic toꞌoxe. Jech más chopol chcom o la avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Mu stacꞌ ti mi chaꞌvoꞌ avajvalique jech chac cꞌu chaꞌal jun jtunel ti mu stacꞌ ti chaꞌvoꞌ yajvale. Ti chaꞌvoꞌuc yajvale, li june chopol chil; li june lec chil. Lec chtun yuꞌun li june, jaꞌ mu xtun yuꞌun li june. Jaꞌ noꞌox jech eꞌuc li joꞌoxuque, mu xuꞌ chatunic yuꞌun Dios mi jaꞌ batem ta avoꞌonic la ataqꞌuinique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Jaꞌ yuꞌun chacalbeic. Mu me xcꞌopoj avoꞌonic ti cꞌusi chacuxiic o liꞌ ta balumile, jaꞌ ti bu chata aveꞌel avuchꞌobique, schiꞌuc nojtoc ti bu chata acꞌuꞌ apacꞌalique. Yuꞌun jaꞌ laj yacꞌboxuc abecꞌtalic acuxlejalic li Diose, jech nojtoc chacꞌ aveꞌelic acꞌuꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Qꞌuelavilic li mutetique, mu snaꞌic abtel. Mu snaꞌ xꞌovolajic, mu snaꞌ xcꞌajavic, muꞌyuc snail li sveꞌelique. Macꞌlanbilic noꞌox yuꞌun li Jtotic Dios ta vinajele. Pero li joꞌoxuque más to chascꞌuxubinic li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Altic ti chcꞌopoj avoꞌonique, maꞌuc me chnatub o acꞌacꞌalilic avorailic liꞌ ta balumil ti jech chcꞌopoj avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Cꞌu chaꞌal chcꞌopoj avoꞌonic ta sventa ti bu chata acꞌuꞌ apacꞌalique? Qꞌuelavilic li nichimetic li chchꞌiic ta yaxaltique. Muꞌyuc yoc scꞌobic. Mu snaꞌ xꞌabtejic, mu snaꞌ spasel scꞌuꞌic, pero lec cꞌupil sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Chacalbeic, li Salomón ta voꞌonee toj jcꞌulej, lec cꞌupil sba li scꞌuꞌ spacꞌale, pero mu xcoꞌolaj schiꞌuc jech chac cꞌu chaꞌal li nichimetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Li tsꞌiꞌleletique lec cꞌupil sba syaxal, pero ta schibal yoxibal cꞌacꞌale taquinic xaꞌox. Jaꞌ noꞌox sventa ta stsajubtasic o sjornoal pan. Acꞌo mi muc bu jal ta xchꞌi li tsꞌiꞌlele pero lec cꞌupil sba syaxal acꞌbil yuꞌun li Diose. Li joꞌoxuque más to chayacꞌboxuc acꞌuꞌic li Diose pero mu xcꞌot ta avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mu me xcꞌopoj avoꞌonic ti cꞌusi chalajesic, ti cꞌusi chavuchꞌic, ti bu chata acꞌuꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Li buchꞌutic mu to xojtaquinic li Diose jaꞌ jech chcꞌopoj yoꞌonic. Pero li Jtotic Dios ta vinajele jaꞌ snaꞌoj stuc scotol li cꞌustic chtun avuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jaꞌ yuꞌun scꞌan ti baꞌi chavacꞌ abaic ta scꞌob li Diose, schiꞌuc ti chapasic li cꞌustic tscꞌane, jech chayacꞌboxuc scotol li cꞌustic scꞌan avuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mu me xcꞌopoj avoꞌonic ta sventa li ocꞌobe yuꞌun mu xanaꞌic li cꞌusi chcꞌot ta pasele. Ti cꞌu sba avocolic jujun cꞌacꞌale, taꞌlouc o me. Mu me xasaꞌic más ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jech laj yal nojtoc li Jesuse: ―Mu me chopluc xavil achiꞌilic yoꞌ jech mu xcꞌot avichꞌic ichꞌbeel acꞌopic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yuꞌun mi chopol chavil la achiꞌilique, jaꞌ noꞌox jech chopol chayilic eꞌuc li Diose. Mi lec chavil la achiꞌilique, jaꞌ noꞌox jech lec chayilic eꞌuc li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Acꞌo mi jutuc noꞌox ti cꞌusi chopol ta spas la achiꞌilique, pero jaꞌ te batem o asatic. Pero mu xavaꞌi abaic ti más to toj chopol li cꞌusi chapasic li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jech chavalbe la achiꞌilique: “Mu me xapas jech”, xavutic. Pero ¿cꞌu sba chapꞌijubtasic la achiꞌilic mi joꞌoxuc más to toj chopol li cꞌustic chapasique? ");
INSERT INTO tzoSA_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Apꞌisoj abaic ti mu cꞌusi chopol avuꞌunique. Jaꞌ scꞌan ti baꞌi chavictaic spasel li cꞌustic chopole, tsꞌacal to xuꞌ chapꞌijubtasic la achiꞌilique. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Li buchꞌutic toj tsots yoꞌonique ti mu scꞌan xichꞌic ta mucꞌ li scꞌop Diose, jaꞌ lec mu xa me xachaꞌalbeic li scꞌop Dios ti jaꞌ sventa chijcuxiutic o sbatel osile. Yuꞌun jaꞌ jechic jech chac cꞌu chaꞌal jcot tsꞌiꞌ li bu mu xaꞌi pajesel cꞌalal ta xtiꞌvane. Jaꞌ jechic nojtoc jech chac cꞌu chaꞌal li chitom mi ch‐echꞌ spechꞌ ta teqꞌuel li natsꞌil ti bu toyol stojol ti lec cꞌupil sbae. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Cꞌanbeic li Diose jech chayacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Scotol li buchꞌutic tscꞌanbeique ta xꞌacꞌbatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Li joꞌoxuque, mi chascꞌanbeic vaj sveꞌ anichꞌonique, mu tonuc chavacꞌbeic slajes. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mi chascꞌanbeic choy stiꞌe, mu chonuc chavacꞌbeic stiꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Li joꞌoxuque chopoloxuc onoꞌox pero xanaꞌic li cꞌusi lec chavacꞌbeic la anichꞌnabique. Li Jtotic Dios ta vinajele jaꞌ snaꞌoj lec li cꞌusi chacꞌbe li buchꞌutic ta xcꞌanbate. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Mi chacꞌan ti lec li cꞌusi chaspasbeic li crixchanoetique, scꞌan ti jaꞌ noꞌox jechoxuc eꞌuque. Yuꞌun jaꞌ jech chal li scꞌop Dios ti stsꞌibaojic comel Moisés schiꞌuc li buchꞌutic yan iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Tamic batel li biqꞌuit bee, jaꞌ li sbelel li cuxlejal sventa sbatel osile. Li sbelel chꞌayel sventa sbatel osile jaꞌ más jamal. Ep li buchꞌutic ta stamique, yuꞌun jaꞌ mu vocluc ta tamel batel yuꞌun lec jamal li bee. Jaꞌ biqꞌuit li sbelel li cuxlejal sventa sbatel osile. Biqꞌuit li bu ta svocꞌ sba echꞌele. Atbil noꞌox li buchꞌutic ta stamic batele. Jaꞌ noꞌox xuꞌ ta stamic batel li buchꞌutic ta sbicꞌtajes sbaic ta stojol li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Pꞌijanic me, mu me xasloꞌloic li buchꞌutic spꞌisoj sbaic ti chalic li scꞌop Diose. Yuꞌun te chtalic li yoꞌ bu oyoxuque lec yoꞌonic yilel jech chac cꞌu chaꞌal chij. Pero li yoꞌonique jaꞌ jech chac cꞌu chaꞌal li jtiꞌaval bolome. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti cꞌusi tspasique jaꞌ te chavilic o. Jech chac cꞌu chaꞌal muc bu chataic sat tsꞌusub ta jtecꞌ chꞌix, schiꞌuc mu bu chataic sat higo ta chꞌix, jaꞌ jechic li buchꞌutic spꞌisoj sbaic ti chalic li scꞌop Diose, mu cꞌusi chataic o lec yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Li teꞌ li bu lec onoꞌoxe, lec li sat chaqꞌue. Li teꞌ li bu chopol onoꞌoxe, jaꞌ noꞌox jech chopol li sat chaqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Li bu lequil teꞌe naca lec li sat chaqꞌue. Li bu chopol li teꞌe naca chopol li sat chaqꞌue. Mu xuꞌ tscap sbaic li bu leque schiꞌuc li bu chopole. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Li teꞌ li bu chopol sate ta xichꞌ tsꞌetel, ta xtiqꞌue ta cꞌocꞌ. Jaꞌ noꞌox jechic eꞌuc li buchꞌutic spꞌisoj sbaic ti chalic li scꞌop Diose, ta xichꞌic vocol ta mucꞌta cꞌocꞌ sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jech ta sventa ti chopol li cꞌustic tspasique, jaꞌ chanaꞌic o ti jaꞌ jloꞌlovanejetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Oy ep buchꞌutic jech chalic: “Cajval, Cajval”, xiyutic, pero mu scotoluc ch‐ochic li yoꞌ bu ta jpas mantale. Jaꞌ noꞌox ch‐ochic li buchꞌutic tspasic li cꞌusi tscꞌan li Jtot ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Oy ep buchꞌu jech chiyalbeic li ta slajeb cꞌacꞌale: “Cajval, ta aventa joꞌot laj calcutic acꞌop. Joꞌot ta ajuꞌel la jloqꞌuescutic pucujetic. Ta aventa joꞌot ti ep laj cacꞌcutic ta ilel ajuꞌele”, xiyutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero joꞌone jaꞌ jech sba ta jtacꞌbeic: “Maꞌuc jnichꞌnaboxuc. Batanic, mu xajcꞌanic yuꞌun jaꞌ la achꞌunbeic smantal li pucuje”, xichi ta jtacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Li buchꞌu chiyaꞌibe li cꞌusi chcale, mi tschꞌune, jaꞌ jech chac cꞌu chaꞌal jun pꞌijil vinic ti la svaꞌan sna ta ba tone. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ital tsots joꞌ. Inoj ta joꞌ scotol li spat xocon li snae. Tsots iꞌechꞌ icꞌ li yoꞌ bu oy sna li vinique pero muc bu xjin li snae yuꞌun ta ba ton svaꞌanoj. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Li buchꞌu chiyaꞌibe li cꞌusi chcale, mi mu schꞌune, jaꞌ jech chac cꞌu chaꞌal jun vinic ti muc bu pꞌije, ti ta ba jiꞌtic noꞌox la svaꞌan li snae. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ital tsots joꞌ. Inoj ta joꞌ scotol li spat xocon li snae. Tsots iꞌechꞌ icꞌ li yoꞌ bu oy sna li vinique. Toj jinel noꞌox li snae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cꞌalal ilaj yoꞌon ta loꞌil li Jesuse, toj chꞌayel noꞌox yoꞌonic li jchiꞌiltactique ta sventa ti cꞌu sba ichanubtasvane. ");
INSERT INTO tzoSA_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Toj lec ichanubtasvan yuꞌun lec snaꞌ li cꞌusi tscꞌan li Diose. Muc bu jech ichanubtasvan jech chac cꞌu chaꞌal li jchiꞌiltactic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cꞌalal iyal talel ta yoc vits schiꞌuc yajchanbalajeltac li Jesuse, toj ep crixchanoetic la schiꞌinic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","La snupic ta be jun vinic ti tsacbil ta cꞌaꞌel chamele, jaꞌ jchiꞌiltic ta israelal. Tal squejan sba ta stojol li Jesuse. Jech laj yalbe: ―Cajval, mi xacꞌan xacoltabun li jchamele, coltaun. Jnaꞌoj ti scotol xuꞌ avuꞌune ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Li Jesuse laj yacꞌbe scꞌob ta sba li jchamelajele, jech laj yalbe: ―Ta jcolta la achamele. Colan chaꞌa ―xut. Icol ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Li Jesuse jech laj yalbe nojtoc: ―Mu me buchꞌu xavalbe ti la jcoltaote. Jaꞌ noꞌox ba acꞌ aba ta ilel ta stojol li palee. Acꞌbo li smoton Dios jech chac cꞌu chaꞌal yaloj onoꞌox li Moisés ta voꞌonee, jech tsnaꞌic o li jchiꞌiltactic ti icol xa la achamele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cꞌalal iꞌoch ta jteclum Capernaum schiꞌuc yajchanbalajeltac li Jesuse, te ital ta stojol jun jyanlumal vinic, jaꞌ banquilal soltaro. Yuꞌun tal yalbe vocol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jech laj yalbe: ―Cajval, ip li cajtunele. Te puchꞌul ta stem ta jna yuꞌun muꞌyuc yipal jun yoc scꞌob. Toj cꞌux ta xaꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Itacꞌav li Jesuse: ―Chba jcoltabe li schamele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Itacꞌav li banquilal soltaroe: ―Cajval, mu tsotsuc cabtel ti acꞌo joꞌot chabat ta jnae. Jaꞌ noꞌox alo jpꞌeluc mantal jech ta xcol o li cajtunele. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Li joꞌone ta mantal noj oyun ti ta jpas ta mantal li soltaroetique. “Batan”, mi xcut li june, chbat. “Laꞌ liꞌi”, mi xcut li yane, chtal. “Paso jech”, mi xcut li cajtunele, tspas ―xi li banquilal soltaroe. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cꞌalal iyaꞌi jech li Jesuse, xmuybaj o. Jech laj yalbe li buchꞌutic te schiꞌuque: ―Melel li cꞌusi chacalbeique, muc to bu jech jtaoj junuc jchiꞌiltic ta israelal ti jech tschꞌun jech chac cꞌu chaꞌal li vinic liꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chacalbeic nojtoc. Chcꞌot scꞌacꞌalil ti chtalic ep crixchanoetic ta spꞌejel balumil ti maꞌuc jchiꞌiltic ta israelale. Chba schiꞌinic li jtotic jmeꞌtic ta voꞌonee, jaꞌ li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove, li te yoꞌ bu ta spas mantal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yan li buchꞌutic jech chalique: “Jaꞌ jmoltotic ta voꞌone li Abrahame, jaꞌ yuꞌun ta onoꞌox xijꞌochutic li yoꞌ bu tspas mantal li Diose”, mi xiique, pero mu xꞌochic. Jaꞌ te chteneic batel ta icꞌal acꞌubal. Te xꞌoqꞌueletic o, te xcꞌuxuxet o yeic ta scoj ti tsots li vocol ti chichꞌique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Li Jesuse jech laj yalbe li banquilal soltaroe: ―Batan. Li cꞌusi achꞌunoje chcꞌot ta pasel ―xut. Icol ta ora li yajtunel li banquilal soltaroe. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Li Jesuse iꞌochic ta sna Pedro schiꞌuc li yan yajchanbalajeltaque. Iyil ti te puchꞌul ta stem li smeꞌniꞌ li Pedroe yuꞌun ip ta cꞌocꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Li Jesuse la spicbe scꞌob. Itupꞌ ta ora li scꞌacꞌale. Ilic ta stem, lic macꞌlanvanuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cꞌalal xtupꞌet xaꞌox li osile, laj yiqꞌuic talel ta stojol Jesús ep buchꞌutic ochem pucuj ta yoꞌonic. Li Jesuse ta jupꞌel noꞌox ye la sloqꞌuesan li pucujetic li ochem ta yoꞌonic li crixchanoetique, schiꞌuc icol yuꞌun scotol li jchamelajeletic li te yicꞌojic talele. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jech icꞌot o ta pasel li cꞌusi iyal Isaías ta voꞌonee. Jech laj yal: “Jaꞌ chtal scoltabutic li cꞌusiuc noꞌox chamelal ip chcaꞌitique”, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cꞌalal iyil Jesús ti joybil ta epal crixchanoetique, jech laj yalbe li yajchanbalajeltaque: ―Batic ta jot nab ―xutan. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tal scꞌopon Jesús jun li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech laj yalbe: ―Cajval, chajchiꞌin batel ti butic chabate ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Itacꞌav li Jesuse: ―Li vete jaꞌ oy to schꞌen, li mute jaꞌ oy to stas yaꞌel. Joꞌon li coꞌol crixchanoutique muꞌyuc jna. Nopo lec mi chacꞌan chachiꞌinun batele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Te ital jun li buchꞌutic ti te onoꞌox schiꞌuquic scotol cꞌacꞌal eꞌuc li Cajvaltique. Jech laj yalbe: ―Cajval, chavacꞌ xibat yuꞌun chba jchiꞌin li jtote. Mi ichame, ta jmuc comel, jaꞌ to chba jchiꞌinot ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Itacꞌav li Jesuse: ―Batic, chiꞌinun batel. Li buchꞌutic ti mu xiyichꞌic ta muqꞌue, coꞌol schiꞌuc chamemic yaꞌel. Te acꞌo smuc sba stuquic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iꞌoch ta canava li Jesuse, te iꞌochic eꞌuc li yajchanbalajeltaque yuꞌun chjelavic batel ta jot nab. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cꞌalal yaquic ta xanbal ta ba nabe, ital ta ora tsots icꞌ, tsots la syuqꞌuilan li nabe. Iꞌoch ep joꞌ ta yut li canavae, yuꞌun xaꞌox ta xmuquij yalel ta yut nab. Li Jesuse te vayal ta yut canava. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Li yajchanbalajeltaque la stijic ta ora li Jesuse. Jech laj yalbeic: ―Cajval, coltauncutic yuꞌun liꞌ xa chijcham ta nabe ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Itacꞌav li Jesuse: ―Ta scoj ti mu xachꞌunic ti oy juꞌele, jaꞌ yuꞌun chaxiꞌic ―xi. Ilic li Jesuse, la spajes li iqꞌue schiꞌuc li nabe, jliquel ichꞌab ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Toj chꞌayel noꞌox yoꞌonic li yajchanbalajeltaque, jech laj yalbe sbaic: ―¿Cꞌu nan chaꞌal li vinic liꞌi ti jliquel ipaj yuꞌun li iqꞌue schiꞌuc li nabe? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Icꞌotic ta jot nab ta yosilalic li jgadaraetique, te ilocꞌ ta canava schiꞌuc li yajchanbalajeltaque li Jesuse, ixanavic batel. Te isnupic ta be chaꞌvoꞌ viniquetic ti ochem pucuj ta yoꞌonique. Iloqꞌuic talel ta muquenal yuꞌun jaꞌ xa snainojic li jombil chꞌenetic li bu ta xmuqueic li ánimaetique. Li chaꞌvoꞌique toj xiꞌel sbaic. Muc xa buchꞌu ta xꞌechꞌic li te ta bee yuꞌun xiꞌemic o li chaꞌvoꞌ viniquetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Li chaꞌvoꞌique tsots laj yaptaic li Jesuse: ―Jesús, joꞌot Snichꞌonot Dios, ¿cꞌu chaꞌal tal aticꞌ aba ta jtojolcutic? Muc to bu cꞌotem scꞌacꞌalil chavacꞌ quichꞌcutic vocol ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Li bu vaꞌal li Jesuse te noꞌox nopol chveꞌ epal chitometic. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Li pucujetique la scꞌanbeic vocol li Jesuse, jech laj yalbeic: ―Mi chaloqꞌuesuncutic li ta yoꞌonic li viniquetic liꞌi, acꞌo xba ochcuncutic li ta chitometic leꞌe ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Locꞌanic batel ―xꞌutatic yuꞌun li Jesuse. Iloqꞌuic ta ora ta yoꞌon li chaꞌvoꞌ viniquetique, ba ochicuc li ta chitometique. Li chitometique iloqꞌuic ta anil scotol, iyalic ta yalebaltic. Itsꞌujic ochel ta nab, te ijicꞌav scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Li jchabiejchitometique ixiꞌic, ibatic ta anil ta jteclum. Ba yalbeic scotol crixchanoetic li cꞌusi icꞌot ta pasele. Ba yalbeic ti icham scotol li chitometique schiꞌuc ti icolic xa li chaꞌvoꞌ schiꞌilic ti ochem toꞌox pucujetic ta yoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Scotol li crixchanoetic li te nacalic ta jteclume iloqꞌuic batel, ba staic li Jesuse. Cꞌalal icꞌotique, laj yalbeic Jesús ti acꞌo locꞌuc ba te ta yosilalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ta tsꞌacale iꞌoch ta canava schiꞌuc yajchanbalajeltac li Jesuse, isut batel ta jteclum Capernaum, jaꞌ li bu nacale. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te iqꞌueche talel ta stojol Jesús jun jchiꞌiltic ta israelal ti muꞌyuc yipal jun yoc scꞌobe. Cꞌalal iyil Jesús ti schꞌunojic ti oy sjuꞌele, jech laj yalbe li jchamelajele: ―Jnichꞌon, mu xavat avoꞌon. Pasbilot xa perton yuꞌun scotol amul ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te oy chaꞌoxvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech la snop ta yoꞌonic: “Li vinic liꞌi ta stoy sba yuꞌun ta spꞌis sba ta Dios”, xi ta yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Li Jesuse sqꞌueloj li cꞌusi la snop ta yoꞌonique, jech laj yalbe: ―¿Cꞌu chaꞌal ti muc bu lec li cꞌusi chanopique? ");
INSERT INTO tzoSA_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta melel buchꞌuuc noꞌox xuꞌ ta xal: “Pasbilot xa perton yuꞌun amul” ti xie, yuꞌun mu vocluc ta alel. Jech nojtoc mu vocluc ta alel: “Lican, xanavan” ti xijchie. Pero jaꞌ scꞌan chaqꞌuelic mi melel chcꞌot ta pasel yuꞌun li buchꞌu jech chale. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Joꞌone laj cal xa ti pasbil xa perton yuꞌun li smul li vinique. Qꞌuelic me li cꞌusi ta jpas li avie yoꞌ jech chanaꞌic o ti joꞌon noꞌox ta jpasbe perton yuꞌun smulic li crixchanoetic liꞌ ta balumile, joꞌon li coꞌol crixchanoutique ―xut. Li Jesuse jech laj yalbe li jchamelajele: ―Lican, ichꞌo batel la apope, batan ta ana ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ilic ta ora li jchamelajele, ibat ta sna. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cꞌalal iyilic li epal crixchanoetique, toj chꞌayel noꞌox yoꞌonic. Laj yalic coliyal Dios ta sventa ti jech yacꞌojbe sjuꞌel jun vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cꞌalal ijelav batel jutuc li Jesuse, iyil ti te chotolun ta jchotleb li yoꞌ bu ta stoj spatanic li crixchanoetique. Mateo jbi. Jech laj yalbun li Jesuse: ―Laꞌ chiꞌinun batel ―xiyut. La jchiꞌin batel ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ta tsꞌacale ba veꞌuc li Jesuse. Istsob sbaic talel ep jtsobpatanetic schiꞌuc li buchꞌutic ti toj chopol cuxulique. Tal schiꞌinuncutic ta chotlej ta mexa. Te oyuncutic jcotolcutic, joꞌoncutic li yajchanbalajeltacuncutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Cꞌalal iyilic li jfariseoetic ti te oyique, jech la sjacꞌbuncutic: ―¿Cꞌu chaꞌal ta xveꞌ schiꞌuc jtsobpatanetic schiꞌuc li jpasmuliletic la avajchanubtasvanejique? ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Li Jesuse iyaꞌi li cꞌusi iyalique, jech itacꞌav: ―Li buchꞌutic muc bu ipique mu scꞌanic poxtael. Jaꞌ noꞌox tscꞌanic poxtael li buchꞌutic ipique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ba nopic li cꞌusi smelol ti jech yaloj li Diose: “Jaꞌ ta jcꞌan ti chacꞌuxubinvanique, maꞌuc noꞌox ti chamilbecun jmotone”, xi li Diose. Li joꞌone maꞌuc tal jsaꞌ li buchꞌutic muꞌyuc smulic ti yalojique; jaꞌ tal jsaꞌ li jpasmuliletique yoꞌ jech chictaic o li smulique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Li yajchanbalajeltac li Juan li iyacꞌ ta ichꞌel joꞌe te italic ta stojol Jesús. Jech tal sjacꞌbeic li Jesuse: ―Li jfariseoetique ep ta velta ta xicta yiximic. Jaꞌ noꞌox jechuncutic eꞌuc li joꞌoncutique. ¿Cꞌu chaꞌal mu xicta yiximic la avajchanbalajeltaque? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Itacꞌav li Jesuse: ―Cꞌalal yacal nupunele, te oy li jnupunel quereme, jaꞌ yuꞌun mu xuꞌ ta xat yoꞌonic li yutsꞌ yalaltac li jnupunel quereme yuꞌun te to schiꞌuquic. Jaꞌ noꞌox jechic eꞌuc li cajchanbalajeltaque, mu jechuc o smelol ti ta xicta yiximique, ti ta xat yoꞌonique, yuꞌun liꞌ to jchiꞌuquique. Jaꞌ to mi icꞌot scꞌacꞌalil ti chismilic li buchꞌutic chiscontrainique, jaꞌ to xuꞌ ta xicta yiximic li cajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Li buchꞌu ta schꞌun li cꞌusi chcale, persa chicta li cꞌusi schꞌunoj toꞌox ti jech chcol o ti yaloje. Persa ta sloqꞌuel yoꞌon ta schꞌun li cꞌusi chcale yoꞌ jech chcol o. Jech chac cꞌu chaꞌal li buchꞌu ta xpacꞌomaje, mu spacꞌ ta achꞌ pocꞌ ti muc toꞌox bu mutseme, yuꞌun mi imutse ta xjat más li poco poqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jech nojtoc li achꞌ yaꞌlel tsꞌusub ti ta xa xpajube, muc buchꞌu ta schꞌol ta poco yav li pasbil ta nucule. Mi jech ta spasique, cꞌalal ta xvocan stuc li yaꞌlel tsꞌusube, chtꞌom li yave. Altic chmal scotol li yaꞌlel tsꞌusube. Li yave altic ta xchꞌay. Li achꞌ yaꞌlel tsꞌusub ti ta xa xpajube, jaꞌ scꞌan ti ta achꞌ yav chichꞌ chꞌolele. Jech lec chcom o schiꞌuc yav li yaꞌlel tsꞌusub li pajubem xae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cꞌalal yacal ta loꞌil li Jesuse, te ital jun jchiꞌiltic ta israelal, jaꞌ jmeltsanejcꞌop ta jun chꞌulna. Tal squejan sba ta stojol li Jesuse, jech cꞌot yalbe: ―Naca to icham jtseub. ¿Mi mu xaꞌabolaj xba avacꞌ acꞌob ta sba yoꞌ jech ta xchaꞌcuxi? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Li Jesuse la schiꞌin batel li jmeltsanejcꞌope. Joꞌoncutic li yajchanbalajeltacuncutique lijbatcutic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Oy jun ants oy xa slajchaebal jabil ti mu xmac li schamele. Inopoj batel ta spat li Jesuse, la spicbe stiꞌ spuychij. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jech la snop ta yoꞌon: “Acꞌo mi jaꞌ noꞌox ta jpicbe li spuychije, chicol o”, xi ta yoꞌon li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Li Jesuse ijoypꞌij sqꞌuel li antse, jech laj yalbe: ―Jnichꞌon, junuc avoꞌon. Yuꞌun achꞌun ti oy juꞌele, jech chacol ―xut. Icol ta ora li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Li Jesuse te icꞌot ta sna li jmeltsanejcꞌope, iꞌoch. Laj yil ti te oy jtijꞌamayetique. Te xꞌavetic ta oqꞌuel li jchiꞌiltactique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jech iꞌalbatic yuꞌun li Jesuse: ―Locꞌanic to batel. Muc bu chamem li tseube, yuꞌun noꞌox chvay ―xi. Cꞌalal jech iyaꞌiic li jchiꞌiltactique, la stseꞌinic li Jesuse yuꞌun snaꞌic ti chamem li tseube. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Li Jesuse la stacan loqꞌuel scotol li jchiꞌiltactique, iꞌoch li yoꞌ bu telel li ánimae. La stsacbe scꞌob li ánima tseube, ichaꞌcuxi ta ora, itots. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ipuc scꞌoplal ta ora ta scotol cosilaltic ti la schaꞌcuxes li tseub li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ixanav batel nojtoc li Jesuse. Te jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Te tijilic batel chaꞌvoꞌ jchiꞌiltic ta israelal naca maꞌsatetic. Tsots laj yaptaic li Jesuse: ―Joꞌot snitilulot David ti scꞌoplal onoꞌox chaꞌoch ta ajvalilal cuꞌuncutique, ¡cꞌuxubinuncutic! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cꞌalal iꞌoch ta na li Jesuse, te italic ta stojol Jesús li chaꞌvoꞌ maꞌsatetique. Li Jesuse jech la sjacꞌbe: ―¿Mi chachꞌunic ti xuꞌ cuꞌun chajamboxuc la asatique? ―xut. ―Ta jchꞌuncutic, Cajval ―xi itacꞌavic li maꞌsatetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Li Jesuse la spicanbe sat li chaꞌvoꞌ maꞌsatetique. Jech laj yalbe: ―Ti achꞌunojic ti xuꞌ cuꞌun chajamboxuc la asatique, jech acꞌo jamuc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ijam ta ora li satique. Li Jesuse tsots laj yalbe: ―Mu me buchꞌu xavalbeic ti la jamboxuc la asatique ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero cꞌalal isutique, la spuquinbeic scꞌoplal Jesús ta spꞌejel cosilaltic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cꞌalal muc toꞌox bu sutemic batel li chaꞌvoꞌ maꞌsatetique, te icꞌbil talel ta stojol Jesús jun umaꞌ vinic, jaꞌ jchiꞌiltic ta israelal nojtoc. Ochem pucuj ta yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Li Jesuse la sloqꞌuesbe li pucuj li ochem ta yoꞌon li vinique. Lic cꞌopojuc li vinique. Toj chꞌayel noꞌox yoꞌonic li epal crixchanoetique. Jech laj yalic: ―¡Muc bu quilojtic jech tspas junuc jchiꞌiltic li a sbae! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cꞌalal iyilic li jfariseoetic li te oyique, jech laj yalbe sbaic: ―Li vinic liꞌi ta sjuꞌel banquilal pucuj ta sloqꞌues li pucujetic li ochem ta yoꞌonic li crixchanoetique ―xi la snaꞌleic. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Li Jesuse ixanav batel ta scotol jteclumetic schiꞌuc ta coloniaetic. Te ichanubtasvan ta jupꞌej schꞌulnaic. Laj yalbe yaꞌiic li lequil cꞌope, jaꞌ ti ista xa scꞌacꞌalil ti chventainatic yuꞌun li Diose. Li Jesuse la scoltaanbe nojtoc li cꞌusiuc noꞌox chamelal ip chaꞌiic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cꞌalal iyil Jesús ti ep crixchanoetic te tsobolique, toj abol sbaic iyil. Yuꞌun jaꞌ jechic jech chac cꞌu chaꞌal chij ti muꞌyuc yajchabivanejique. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jech laj yalbuncutic, joꞌoncutic li yajchanbalajeltacuncutique: ―Melel oy ep li buchꞌutic chac yaꞌiic li scꞌop Diose pero jaꞌ muc bu ep li buchꞌutic chal li scꞌop Diose. Jech chac cꞌu chaꞌal mi ep li cꞌajoje pero jaꞌ muc bu ep li jcꞌajavile. ");
INSERT INTO tzoSA_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jaꞌ yuꞌun cꞌanbeic Dios ti acꞌo stac batel li buchꞌutic chba yalbeic li scꞌope yuꞌun jaꞌ Yajval li abtele ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Li lajchavoꞌuncutic ti yicꞌojuncutic ta yajchanbalajel li Jesuse, laj yacꞌbun jtsatsal juꞌelcutic eꞌuc ti ta jloqꞌuesbecutic pucujetic ta yoꞌonic li crixchanoetique, schiꞌuc ti ta jcoltabecutic ti cꞌustic noꞌox ip chaꞌiique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jaꞌ jbicutic liꞌi: Li buchꞌu baꞌi itꞌujee jaꞌ Simón li Pedro schaꞌmojol sbie. Schiꞌuc Andrés, jaꞌ yitsꞌin li Pedroe. Schiꞌuc Jacobo schiꞌuc yitsꞌin li Juan sbie, jaꞌ snichꞌnab li Zebedeoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Schiꞌuc Felipe, schiꞌuc Bartolomé, schiꞌuc Tomás, schiꞌuc joꞌon li Mateoun ti jtsobpatanun toꞌoxe. Schiꞌuc li otro jun Jacobo, jaꞌ snichꞌon Alfeo. Schiꞌuc Lebeo li Tadeo schaꞌmojol sbie. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Schiꞌuc Simón ti la schiꞌin toꞌox li jcananeoetique. Schiꞌuc Judas Iscariote li buchꞌu tsꞌacal to iyacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Li Jesuse la stacuncutic batel, joꞌoncutic li lajchavoꞌuncutique. Lec lischanubtasuncutic batel, jech laj yalbuncutic: ―Mu me xabatic ta yosilalic li buchꞌutic maꞌuc jchiꞌiltic ta israelale schiꞌuc ta yosilalic li jsamariaetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jaꞌ noꞌox te xabatic li yoꞌ bu oyic li jchiꞌiltactic ta israelale, yuꞌun chꞌayemic jech chac cꞌu chaꞌal li chijetique. Yan o be stamojic. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ba albeic ti ista xa scꞌacꞌalil ti chventainatic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Coltaanic li buchꞌutic tsacbilic ta chamele. Chaꞌcuxesic ánimaetic. Coltaanbeic schamelic li buchꞌutic tsacbilic ta cꞌaꞌel chamele. Loqꞌuesic pucujetic ta yoꞌonic li crixchanoetique. La atsatsal ajuꞌelic li laj cacꞌboxuque jaꞌ amotonic. Jech ta matanal me xacoltavanic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mu me xavichꞌic batel ataqꞌuinic. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mu me xavichꞌic batel aveꞌelic. Mu me xavichꞌic batel chaꞌlic acꞌuꞌic, schiꞌuc axonobic, schiꞌuc anamteꞌic. Yuꞌun li buchꞌutic ta xꞌabtejique te ta xꞌacꞌbat sveꞌelic. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Buyuc noꞌox chaꞌochic, mi ta jteclumetic, mi ta coloniaetic, jaqꞌuic me li buchꞌu lec scꞌoplale. Jaꞌ te xachꞌamunbeic sna jaꞌ to mi laloqꞌuic ta slumalic teye. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cꞌalal chaꞌochic ta snae, jech xavalbeic: “Acꞌo spasboxuc ta jun avoꞌonic li Diose”, utic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi chayichꞌic ta mucꞌ ti cajchanbalajeltacoxuque, chilic ti jun yoꞌonique. Mi mu xayichꞌic ta muqꞌue, mu xilic o ti jun yoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Li buchꞌutic mu xayotesic ta snaique, ti mu scꞌan xaꞌiic acꞌopique, lilinic comel spucucal la avoquique. Jaꞌ noj jech nojtoc cꞌalal mi laloqꞌuic batel ta slumalique, lilinic comel spucucal avoquic nojtoc. Jaꞌ senyail ti icom xa ta sba stuquic ti muc bu xichꞌic ta mucꞌ li jcꞌop li la avalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Melel li cꞌusi chacalbeique, cꞌalal ta xcꞌot scꞌacꞌalil ti ta xichꞌ cꞌop li Diose, jaꞌ más tsots vocol ta xichꞌic li jchiꞌiltactic li te ta jteclum li bu muc bu xayotesique. Li vocol ta xichꞌic li crixchanoetic li te ta jteclum Sodoma schiꞌuc li ta jteclum Gomorra ta voꞌonee, jaꞌ mu sta jech. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Chajtaquic batel jech chac cꞌu chaꞌal chijetic ti chcꞌot staic oqꞌuiletique, yuꞌun te chcꞌot ataic jchiꞌiltactic ti chac smiloxuque. Jaꞌ scꞌan ti pꞌijoxuc me jech chac cꞌu chaꞌal li orachon ti lec pꞌije. Pero lecuc me avoꞌonic jech chac cꞌu chaꞌal li stsue. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pꞌijanic me yuꞌun oy buchꞌu mu xascꞌanic. Chayaqꞌuic ta scꞌob li buchꞌutic oy yabtelic li te ta schꞌulnaique, te chastsitsic. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta sventa ti avichꞌojicun ta muqꞌue chayiqꞌuic batel ta stojol li ajvaliletique, jaꞌ yuꞌun xuꞌ xavalic li jcꞌop ta stojolique, schiꞌuc ta stojol li buchꞌutic maꞌuc jchiꞌiltic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cꞌalal chaꞌaqꞌueic ta cꞌabale, mu me xal avoꞌonic li cꞌusi chavalique, schiꞌuc li cꞌu sba chatacꞌavique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yuꞌun jaꞌ tsjules ta ajolic li Chꞌul Espíritu ti junic schiꞌuc li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Oy buchꞌutic chaqꞌuic ta milel yitsꞌinic mi sbanquilic. Oy buchꞌutic chaqꞌuic ta milel li snichꞌonique. Oy buchꞌutic tscontrainic stot smeꞌic, chaqꞌuic ta milel nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta sventa ti avichꞌojicun ta muqꞌue ti chascontrainic li crixchanoetique. Li buchꞌutic chcuch yuꞌun scotol li vocole, mi mu schibajes yoꞌonique, jaꞌ chcolic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mi oy bu chataic ilbajinel majel ta jun jteclume, batanic ta yan o jteclum. Melel li cꞌusi chacalbeique, cꞌalal chichaꞌtal nojtoque, joꞌon li coꞌol crixchanoutique, muc toꞌox bu lajem avalojbeic jcꞌop li jchiꞌiltactic ta scotol jteclumetic liꞌ ta cosilaltique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Joꞌoxuc li cajchanbalajeltacoxuque, joꞌoxuc ti chatunic cuꞌune, mu me xanopic ti lec chaꞌileic yuꞌun li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta onoꞌox xavichꞌic contrainel jech chac cꞌu chaꞌal ta xquichꞌ contrainel, joꞌon ti Avajchanubtasvanejicune, joꞌon ti Avajvalicune. Jech chalic jcꞌoplal li crixchanoetic ti pucujune. Jaꞌ xaval li joꞌoxuque ti jnichꞌnaboxuque, más to chayalbeic ti pucujoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Mu me xasibtes abaic yuꞌun li crixchanoetique yuꞌun persa ta xaꞌiic onoꞌox li cꞌustic calojboxuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jaꞌ avabtelic ti jamal chavalic batele. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mu me xasibtes abaic yuꞌun li buchꞌutic chac smiloxuque yuꞌun mu snaꞌ xcham la achꞌulelique. Jaꞌ me xaxiꞌic li Diose yuꞌun jaꞌ xuꞌ yuꞌun chasticꞌoxuc ta mucꞌta cꞌocꞌ schiꞌuc achꞌulelic. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Xanaꞌic ti mu cꞌusi bal o stojol ta chaꞌcot li bicꞌtal mutetique. Pero mu jcotuc ta stsꞌuj yalel ta balumil mi mu jechuc ta scꞌan li Jtotique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Li joꞌoxuque atbil scotol ti jaypꞌej li stsotsil ajolique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jaꞌ yuꞌun mu me xaxiꞌic. Yuꞌun más to cꞌuxoxuc ta yoꞌon li Diose; jaꞌ jutuc noꞌox cꞌuxubinbilic li bicꞌtal mutetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Li buchꞌutic ti jamal ta xalic ta stojol li crixchanoetic ti yichꞌojicun ta muqꞌue, jaꞌ noꞌox jechun eꞌuc li joꞌone, jamal chcal ta stojol Jtot ta vinajel ti melel yichꞌojicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yan li buchꞌutic ti mu jamluc ta xalic ta stojol li crixchanoetic ti yichꞌojicun ta muqꞌue, jaꞌ noꞌox jechun eꞌuc, ta xcalbe Jtot ti muc bu yichꞌojicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Mu me xanopic ti tal jpasbeic ta jmoj yoꞌonic li crixchanoetic liꞌ ta balumile. Moꞌoj, muc bu tal jpasbeic ta jmoj yoꞌonic. Ta jventa joꞌon chlic scontrain sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta jventa joꞌon chlic scontrain sbaic jun vinic schiꞌuc stot. Jech nojtoc li tseube ta scontrain li smeꞌe. Jaꞌ noꞌox jech eꞌuc li alibale ta scontrain li smeꞌalibe. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta jventa joꞌon ta scontrain sbaic jchop jnaclej. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Li buchꞌu mu scꞌan xiyichꞌ ta mucꞌ ta scoj ti ta xiꞌ mi ch‐iltae yuꞌun stot smeꞌe, mu xuꞌ xcacꞌ ta jcꞌob. Li buchꞌu mu scꞌan xiyichꞌ ta mucꞌ ta scoj ti ta xiꞌ mi ch‐ilin li snichꞌnabe, mu xuꞌ xcacꞌ ta jcꞌob nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Li buchꞌu mu scꞌan xichꞌ vocol jech chac cꞌu chaꞌal ta xquichꞌ vocol li joꞌone, mu xuꞌ xcacꞌ ta jcꞌob. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Li buchꞌu tscꞌuxubin li scuxlejal liꞌ ta balumile, ti mu scꞌan xcham ta jventa joꞌone, jaꞌ ta xchꞌay o sbatel osil. Yan li buchꞌu mu xichꞌ ta cꞌux li scuxlejal liꞌ ta balumile, ti mu sventauc mi te ta xcham ta jventa joꞌone, jaꞌ ta xcuxi o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Li buchꞌutic chichꞌic ta mucꞌ li jcꞌop ti chavalique, joꞌon chiyichꞌic ta mucꞌ. Mi chiyichꞌic ta muqꞌue, jaꞌ ch‐ichꞌe ta mucꞌ li Jtot yaꞌele ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Li buchꞌutic ta xichꞌic ta mucꞌ jun li buchꞌu chal scꞌop Diose, yuꞌun snaꞌic ti jaꞌ acꞌbil yabtel yuꞌun li Diose, coꞌol ta xichꞌ smotonic schiꞌuc li buchꞌu iyal scꞌop Diose. Li buchꞌutic chichꞌic ta mucꞌ jun vinic yuꞌun snaꞌic ti tucꞌ yoꞌone, coꞌol ta xichꞌ smotonic schiꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Li buchꞌutic ti jaꞌ noꞌox chayacꞌbeic jbochuc yoxoꞌ avuchꞌic yuꞌun chilic ti chatunic cuꞌune, melel chacalbeic ti chichꞌ smotonic eꞌuc ta sventa ti laj yacꞌ yoxoꞌ avuchꞌique ―xijyutcutic li Jesúse. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cꞌalal laj yalbuncutic mantal li Jesuse, joꞌoncutic li lajchavoꞌuncutic li yajchanbalajeltacuncutique, lijlocꞌcutic batel. Ba chanubtasvanuc li Jesuse, ba yal scꞌop Dios ta jteclumetic ta Galilea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Li Juan li te tiqꞌuil ta chuquele, laj yaꞌi li cꞌustic ta spas li Cristoe. Jaꞌ yuꞌun la stac batel jayvoꞌ yajchanbalajeltac. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jech cꞌot sjacꞌbeic li Jesuse: ―¿Mi joꞌot Cristoot ti scꞌoplal onoꞌox chtal sventainuncutique, mi ta to jmalacutic yan? utic cꞌotel”, xijyutcutic talel li Juane ―xutic cꞌotel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Itacꞌav li Jesuse: ―Ba albeic Juan scotol li cꞌustic avaꞌiic ti laj cale schiꞌuc li cꞌustic avilic ti yacun spasele. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Li maꞌsatetic toꞌoxe xilic xa osil. Li coxoetic toꞌoxe lec xa chanavic. Icolic xa li buchꞌutic tsacbilic toꞌox ta cꞌaꞌel chamele. Ijam xa schiquinic li buchꞌutic macal toꞌox schiquinique. Li buchꞌutic telelic xaꞌoxe ichaꞌcuxiic xa cuꞌun. Li meꞌonetique iꞌalbatic xa yaꞌiic ti ta xcꞌuxubinatic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mu me xchibaj yoꞌon ta jtojol li Juane, acꞌo muybajuc noꞌox, xijyutcutic talel li Jesuse”, utic cꞌotel li Juane ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cꞌalal yuꞌun xaꞌox chbatic li yajchanbalajeltac li Juane, li Jesuse lic yalbe li epal crixchanoetic li cꞌu sba scꞌoplal li Juane. Jech laj yal: ―Li buchꞌu a aqꞌuelic li te ta taqui jamaltique, xanaꞌic xa onoꞌox ti ta yav oy li cꞌu sba ichanubtasvane, ti maꞌuc jech chac cꞌu chaꞌal jtecꞌ aj ti chbat ta jujot ta iqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Avilic ti muꞌyuc lec scꞌuꞌe. Yuꞌun li buchꞌutic ti toj lec scꞌuꞌique, jaꞌ li buchꞌutic te oyic ta sna ajvaliletique. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Cꞌalal a aqꞌuelique, xanaꞌic xa onoꞌox ti jaꞌ li buchꞌu laj yal li scꞌop Diose. Melel chacalbeic, li Juan li a aqꞌuelique, jaꞌ más banquilal yuꞌunic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Li Juane jaꞌ onoꞌox ti tsꞌibabil scꞌoplal ta scꞌop Dios ti baꞌi ta xtal cuꞌune. Jech tsꞌibabil: Baꞌi ta jtac batel li cajtacbalale. Jaꞌ ta xalbe crixchanoetic ti chabate yoꞌ jech chayichꞌic ta mucꞌ, xiyut li Jtote, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Melel li cꞌusi chacalbeique, ta scotol li crixchanoetique muc buchꞌu jech yichꞌoj tsots yabtel jech chac cꞌu chaꞌal yichꞌoj li Juan li iyacꞌ ta ichꞌel joꞌe. Pero li buchꞌu ta xacꞌ sba ta scꞌob li Diose, acꞌo mi muc bu yichꞌoj tsots yabtel, jaꞌ más ta xꞌacꞌbat yil li cꞌu sba sjuꞌel li Diose. Li Juane jaꞌ jutuc noꞌox iyil. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cꞌalal la stsac yabtel li Juan li iyacꞌ ta ichꞌel joꞌe, cꞌalal tana, oy buchꞌutic ta sloqꞌuel yoꞌonic chacꞌ sbaic ta ventainel yuꞌun li Diose. Li buchꞌutic ta sloqꞌuel yoꞌonic ta scꞌanic ventainele ta onoꞌox xventainatic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cꞌalal muc toꞌox bu talem li Juane, jech onoꞌox tsꞌibabil ta scꞌop Dios yuꞌun scotol li buchꞌutic iyalic scꞌop Dios ta voꞌone ti jech ta xcꞌot ta pasele. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mi chachꞌunic ti ista xa scꞌacꞌalil ti chventainvan li Diose, jech chanaꞌic o ti jaꞌ sqꞌuexol Elías li Juan li liꞌ xa oye. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Chacalbeic li cꞌu sba atalelic li liꞌ oyoxuc ta balumile. Jaꞌ jechoxuc jech chac cꞌu chaꞌal li unetic ti te chotolic ta xtajinic ta chꞌivite, jech chalanbeic li schiꞌilique: ");
INSERT INTO tzoSA_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“La jupancutic amay sventa nupunel pero muc bu xaꞌacꞌotajic. Cꞌalal xijuetcutic ta oqꞌuel ta scoj ti oy buchꞌu icham cuꞌuncutique, muc bu xaꞌoqꞌuic nojtoc. Mu cꞌusi xacꞌanic”, xut li schiꞌiltac ta tajimole. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yuꞌun cꞌalal ital li Juane, muc bu xaschiꞌinic ta veꞌel. Jaꞌ jech sba la avalic: “Ochem pucuj ta yoꞌon”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cꞌalal lital, joꞌon li coꞌol crixchanoutique, la jchiꞌinoxuc ta veꞌel. Pero jaꞌ jech sba la avalic nojtoc: “Qꞌuelavil toj echꞌem xveꞌ, toj echꞌem xuchꞌ yaꞌlel tsꞌusub. Lec xil sbaic nojtoc schiꞌuc li buchꞌutic chopol cꞌustic tspasic jech chac cꞌu chaꞌal li jtsobpatanetique schiꞌuc li yan jpasmuliletique”, xachiic. Ti acꞌbiluc apꞌijilic yuꞌun li Diose, la avichꞌicuncutic ta mucꞌ schiꞌuc li Juan ti jechuque. Jaꞌ xanaꞌic o ti acꞌbil jpꞌijilcutic yuꞌun Dios ti la jpascutic li cꞌustic la jpascutique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Li Jesuse laj yal cꞌu sba scꞌoplalic li jchiꞌiltactic ta israelal li te ta jteclumetic li bu laj yacꞌulan ta ilel stsatsal sjuꞌele, jaꞌ ti muc bu xictaic li cꞌustic chopol ta spasique. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Ta onoꞌox xichꞌic tsots vocol li jchiꞌiltactic li te nacalic ta jteclum Corazine schiꞌuc li jchiꞌiltactic li te nacalic ta jteclum Betsáidae, yuꞌun iyilic jayib velta ti oy jtsatsal juꞌele pero muc bu xiyichꞌic ta mucꞌ. Li jyanlumal crixchanoetie li te nacalic ta jteclum Tiro schiꞌuc ta jteclum Sidón ta voꞌonee, muc bu xiyilbeic li jtsatsal juꞌele. Ti iyilicuque, la slapic jalbil tsotsil tentsun ti chꞌixaltic ta lapele, schiꞌuc la sbon sbaic ta tanil cꞌocꞌ ti jechuque. Jaꞌ senyail ti ta xat o yoꞌonic li cꞌustic chopol spasojique, jech ta xictaic o. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Chacalbeic, cꞌalal ta xcꞌot scꞌacꞌalil ti ta xichꞌ cꞌop li Diose, jaꞌ tsots ta xichꞌic vocol li jchiꞌiltactic li te nacalic ta Corazín schiꞌuc ta Betsáida li avie. Li vocol ti ta xichꞌic li jyanlumal crixchanoetic li te nacalic ta Tiro schiꞌuc ta Sidón ta voꞌonee, jaꞌ mu sta jech. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Li jchiꞌiltactic li te nacalic ta jteclum Capernaume ta snopic ti jaꞌ ep ta xichꞌbeic slequilal yutsilal li Diose, pero altic. Jaꞌ tsots ta xichꞌic vocol yuꞌun iyilic jayib velta ti oy jtsatsal juꞌele pero muc bu xiyichꞌic ta mucꞌ. Li crixchanoetic li te nacalic ta jteclum Sodoma ta voꞌonee muc bu xiyilbeic li jtsatsal juꞌele. Ti iyilicuque, cꞌalal tana te to oy li jteclum Sodoma ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chacalbeic, cꞌalal ta xcꞌot scꞌacꞌalil ti ta xichꞌ cꞌop li Diose, jaꞌ tsots ta xichꞌic vocol li jchiꞌiltactic li te nacalic ta Capernaum li avie. Li vocol ti ta xichꞌic li crixchanoetic li ta Sodoma ta voꞌonee, jaꞌ mu sta jech ―xut li jchiꞌiltactic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jech lic scꞌopon Stot li Jesuse: ―Tata, joꞌot yajvalot li vinajel balumile. Colaval ti muc bu xavacꞌbe yaꞌibeic smelol li cꞌusi laj cal schiꞌuc li cꞌusi la jpas li buchꞌutic pꞌijique schiꞌuc li buchꞌutic lec snaꞌic ti yalojique. Jaꞌ noꞌox la avacꞌbe yaꞌibeic smelol li buchꞌutic ta scꞌanic coltaele jech chac cꞌu chaꞌal ta scꞌanic coltael li unetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tata, lec ti jech la acꞌane ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Li Jesuse xi lic yalanbe li crixchanoetique: ―Scotol yacꞌojbun ta jcꞌob li Jtote. Joꞌon li Snichꞌonune muc buchꞌu snaꞌ li cꞌu sba li coꞌone. Jaꞌ noꞌox stuc Jtot snaꞌoj li cꞌu sba li coꞌone. Jaꞌ noꞌox jech eꞌuc li Jtote, muc buchꞌu snaꞌbe li cꞌu sba yoꞌone. Joꞌon noꞌox jnaꞌojbe li cꞌu sba yoꞌon li Jtote, schiꞌuc snaꞌic eꞌuc li buchꞌutic chcacꞌbe snaꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Laꞌic ta jtojol acotolic, joꞌoxuc ti lubemoxuc ta saꞌel li cꞌu sba lec chaꞌileic yuꞌun li Diose. Joꞌon chacacꞌbeic li scuxob avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Acꞌ abaic ta jcꞌob. Jaꞌ ichꞌic li cꞌu sba li coꞌone yuꞌun toj lec coꞌon, mu jnaꞌ jtoy jba. Mi jech chapasique, chataic li scuxob avoꞌonique yuꞌun chanaꞌic ti lec chayilic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ti laj calboxuc ti chavacꞌ abaic ta jcꞌobe, mu tsotsuc ta pasel. Schiꞌuc li cꞌustic ta jcꞌane mu vocluc ta pasel chavaꞌiic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ta yan o cꞌacꞌal te lijelavcutic ta be ta trigotic schiꞌuc li Jesuse. Jaꞌ o scꞌacꞌalil ta jcuxtic. Lijviꞌnajcutic, joꞌoncutic li yajchanbalajeltacuncutique. La jcꞌascutic jaychex trigo la juꞌ jcꞌuxcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lijyiluncutic jayvoꞌ jfariseoetic, jech laj yalbeic li Jesuse: ―Qꞌuelavil, la avajchanbalajeltaque ta spasic li cꞌusi mu xuꞌ jpastic li ta scꞌacꞌalil ta jcuxtique ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Itacꞌav li Jesuse: ―Aqꞌuelojic ta scꞌop Dios li cꞌusi la spas li David li cꞌalal iviꞌnajic schiꞌuc li schiꞌiltac ta xanbale. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Te icꞌotic ta chꞌulna. Li Davide la sveꞌ li pan li te oy ta mexa ta sventa smoton li Diose. Acꞌo mi yaloj Dios ti jaꞌ noꞌox xuꞌ ta sveꞌic li paleetique, pero la sveꞌic schiꞌuc li schiꞌiltac li Davide. Pero muc bu sta o smul ti jech la spase. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Joꞌoxuque aqꞌuelojic li scꞌop Dios li la stsꞌiba Moisés ta voꞌonee. Ta xal ti ta onoꞌox xꞌabtejic te ta chꞌulna li ta scꞌacꞌalil ta jcuxtic li paleetique. Pero muc bu ta sta smulic ti jech ta xꞌabtejique. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Li paleetique xuꞌ ta xꞌabtejic ta chꞌulna li cꞌalal jaꞌ o scꞌacꞌalil ta jcuxtique. Jaꞌ noꞌox jech eꞌuc xuꞌ ta scꞌas scꞌuxic jaychexuc trigo li cajchanbalajeltaque. Yuꞌun li joꞌone tsots cabtel quichꞌoj; jaꞌ mu tsotsuc yabtel iyichꞌ li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mu xavaꞌibeic smelol li cꞌusi laj yal li Diose. Jech laj yal: “Jaꞌ ta jcꞌan ti chacꞌuxubinvanique, maꞌuc noꞌox ti chamilbecun jmotone”, xi. Ti avaꞌibecuc smelole, muc xaticꞌbeic smulic li buchꞌutic muꞌyuc smulic ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Joꞌon li coꞌol crixchanoutique, joꞌon yajvalun li scꞌacꞌalil ti ta jcuxtique. Joꞌon chcal li cꞌustic xuꞌ ta pasele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ibat li Jesuse. Te lijꞌochcutic schiꞌuc ta schꞌulnaic li jchiꞌiltactic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te oy jun jchiꞌiltic ti smochꞌoj sba sbicꞌtaltac jun scꞌobe. Te oyic eꞌuc jayvoꞌ jfariseoetic jech la sjacꞌbeic li Jesúse: ―¿Mi xu chijcoltavan ta scꞌacꞌalil ta jcuxtique? ―xiic, yuꞌun tscꞌan tsaꞌbeic smul li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Itacꞌav li Jesuse: ―Li joꞌoxuque, mi oy bu itsꞌuj ta chꞌen jcotuc achijic ta scꞌacꞌalil ta jcuxtique, ¿mi muc chba aloqꞌuesic talel yaꞌel? ");
INSERT INTO tzoSA_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero li jcot chije muꞌyuc más sbalil. Jaꞌ más ta xtun li jun crixchanoe. Jaꞌ yuꞌun xuꞌ ta jpastic li cꞌusi lec li ta scꞌacꞌalil ta jcuxtique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Li Jesuse jech laj yalbe li vinique: ―Tuqꞌuibtasano li sbicꞌtaltac acꞌobe ―xut. La stuqꞌuibtasan li sbicꞌtaltac scꞌobe, icol ta ora li scꞌobe. Lec xa icom jech chac cꞌu chaꞌal li jun scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iloqꞌuic batel li jfariseoetique, ba snopbeic scꞌoplal Jesús ti cꞌu sba xuꞌ tsmilique. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Li Jesuse snaꞌoj li cꞌusi tsnopique, jaꞌ yuꞌun la svocꞌ sba batel. Te ichiꞌinat batel yuꞌun ep jchamelajeletic. La scoltabe schamelic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tsots laj yalanbe li jchamelajeletique: ―Mu me xapuquic ba jcꞌoplal ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jaꞌ icꞌot ta pasel ti jech onoꞌox laj yal Isaías li iyal scꞌop Dios ta voꞌone ti jaꞌ ta xcoltavan li Jesuse. Yuꞌun ichꞌamunbat ye yuꞌun li Diose, jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Qꞌuelavil li buchꞌu cacꞌojbe yabtele, jaꞌ ti tꞌujbil onoꞌox cuꞌune. Toj cꞌux ta coꞌon. Ximuybaj noꞌox yuꞌun. Chcacꞌbe yichꞌ li Chꞌul Espíritu cuꞌune. Cacꞌojbe yabtel sventa xuꞌ ta xcolic o eꞌuc li jyanlum crixchanoetic ta spꞌejel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mu sliques cꞌop, mu snaꞌ ti stoyoj noꞌox sba chcꞌopoj yoꞌ ta xꞌichꞌe ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mu schibajesbe yoꞌonic li buchꞌutic ti mu cꞌusi xtun o chaꞌiic, ti jaꞌ jechic jech chac cꞌu chaꞌal jpꞌej aj ti bu vochꞌeme, schiꞌuc jech chac cꞌu chaꞌal cantil ti bu mu xtil leque. Jaꞌ noꞌox yabtel ta scoltaan yoꞌ jech ta xcuxiic o sbatel osil. Jech mu xba yichꞌic o vocol. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Li buchꞌutic maꞌuc jꞌisraeletique jaꞌ ta xilic o ti xuꞌ ta xcolic eꞌuc ta sventa li buchꞌu cacꞌojbe yabtele, xi li Diose, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Te yichꞌojic talel ta stojol Jesús jun jchiꞌiltic ochem pucuj ta yoꞌon. Maꞌsat schiꞌuc umaꞌ nojtoc li vinique. Li Jesuse la scolta, jech icꞌopoj ta ora schiꞌuc ijam sat. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Toj chꞌayel noꞌox yoꞌonic li epal crixchanoetique. Jech laj yalbe sbaic: ―Jaꞌ nan li snitilul David ti scꞌoplal onoꞌox ta xꞌoch ta ajvalilal cuꞌuntique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cꞌalal iyaꞌiic li jfariseoetique, jech laj yalic: ―Li vinic liꞌi ta sjuꞌel banquilal pucuj ta sloqꞌues li pucujetic li ochem ta yoꞌonic li crixchanoetique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Li Jesuse sqꞌueloj li cꞌusi iyal ta yoꞌonique. Jech laj yalbe: ―Mi ta scontrain sbaic jun ajvalil schiꞌuc schiꞌiltac ta abtele, ta soquic o. Mi ta scontrain sbaic ta jpꞌej noꞌox snailique, schiꞌuc mi ta scontrain sbaic yajvaltac jun jteclume, ta soquic o nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaꞌ noꞌox jech eꞌuc li banquilal pucuje, jaꞌ li Satanase, mi ta sloqꞌues schiꞌil ta pucujal ta yoꞌonic li crixchanoetique, mu xuꞌ spas mantal mi jech ta spase. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Li joꞌoxuque chavalic ti ta sjuꞌel banquilal pucuj ta jloqꞌues li pucujetique. Ti meleluque, ¿buchꞌu ta sventa ta sloqꞌuesic pucujetic eꞌuc la avajchanbalajeltaquique? La avajchanbalajeltaquique xuꞌ ta xalic ti mu meleluc li cꞌusi chavalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Li joꞌone ta sventa li Chꞌul Espíritu ta jloqꞌues li pucujetique, jaꞌ ta xvinaj o ti liꞌ xa ta spas mantal ta atojolic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Li buchꞌu tscꞌan ch‐och ta sna jun tsatsal vinique yoꞌ chelcꞌanbe li cꞌustic oy yuꞌune, scꞌan ta schuc baꞌi li tsatsal vinique, jaꞌ to jech xuꞌ chelcꞌanbe batel li cꞌustic oy yuꞌune. Li Satanase jaꞌ jech chac cꞌu chaꞌal li tsatsal vinique yuꞌun jaꞌ sventainoj li crixchanoetique. Pero la jpas xa ta canal yuꞌun la jpojbe li vinic li te toꞌox oy ta scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Li buchꞌu muc bu lec chil li cꞌusi ta jpase, jaꞌ chiscontrain o. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Chacalbeic, li buchꞌutic chopol li cꞌustic ta spasique, schiꞌuc mi chopol ta xcꞌopojic ta stojol li Diose, ta to spasbatic perton yuꞌun Dios ti mi tscꞌanbeique. Yan li buchꞌutic chopol ta xcꞌopojic ta stojol li Chꞌul Espíritue, muc xa bu ta spasbatic o perton sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Li buchꞌutic chopol ta xcꞌopojic ta jtojol, joꞌon li coꞌol crixchanoutique, ta to spasbatic perton yuꞌun Dios ti mi tscꞌanbeique. Jaꞌ noꞌox li buchꞌutic chopol ta xcꞌopojic ta stojol li Chꞌul Espíritue, muc xa bu ta spasbatic o perton sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jech laj yalbe nojtoc li Jesuse: ―Ti cꞌu sba sat li teꞌe, jaꞌ ta xquiltic o mi lec, mi chopol. Li teꞌ li bu lec onoꞌoxe, lec li sat ta xaqꞌue. Li teꞌ li bu chopol onoꞌoxe, jaꞌ noꞌox jech chopol li sat ta xaqꞌue. Jaꞌ yuꞌun nopic lec ti cꞌu sba la atsꞌunbalic ta scoj ti mu lecuc chavilicune, yuꞌun naca lec li cꞌustic ta jpase. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Li joꞌoxuque jaꞌ achiꞌilic li orachone yuꞌun chopol avoꞌonic. Jaꞌ yuꞌun mu xuꞌ ti lec chacꞌopojique. Yuꞌun li cꞌu sba chal ta avoꞌonique jaꞌ jech chlocꞌ ta aveic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Li buchꞌu lec yoꞌone jaꞌ noꞌox jech lec li cꞌu sba ta xcꞌopoje yuꞌun lec li cꞌusi snopoje. Li buchꞌu chopol li cꞌusi ta snope, jaꞌ ta xal li cꞌu sba snopoje. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Chacalbeic nojtoc, li cꞌu yepal la asaꞌbeic smul la achiꞌilique ta onoꞌox xaꞌichꞌbat acꞌopic li cꞌalal ta xcꞌot scꞌacꞌalil ti ta xichꞌ cꞌop li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mi lec li cꞌu sba lacꞌopojic liꞌ ta balumile, jech lec chayilic li Diose. Mi chopol li cꞌu sba lacꞌopojique, jech chavichꞌic o vocol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Te oyic jayvoꞌ jfariseoetic schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, acꞌbun quilcutic ta vinajel la atsatsal ajuꞌele yoꞌ jech ta jnaꞌcutic o ti acꞌbilot yuꞌun Dios la avabtele ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Itacꞌav li Jesuse: ―Li buchꞌutic chopol yoꞌonic ti mu junuc yoꞌonic ta stojol li Diose, tscꞌan tsqꞌuelic li juꞌele pero muc bu chcacꞌbe yilic. Jaꞌ noꞌox chcacꞌbe yilic jech chac cꞌu chaꞌal icꞌot ta pasel ta stojol li Jonase, jaꞌ li buchꞌu iyal scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jech chac cꞌu chaꞌal te tiqꞌuil ta yut schꞌut mucꞌta choy oxib cꞌacꞌal schiꞌuc oxib acꞌubal li Jonase, jaꞌ noꞌox jechun eꞌuc li joꞌone, li cꞌalal chimilee, oxib cꞌacꞌal schiꞌuc oxib acꞌubal muculun, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cꞌalal ta xcꞌot scꞌacꞌalil ti ta xichꞌ cꞌop li Diose, jaꞌ más tsots chavichꞌic vocol li joꞌoxuc ti liꞌ to oyoxuc ta balumile. Li vocol ti ta xichꞌic li crixchanoetic ta Nínive ta voꞌonee, jaꞌ mu sta jech. Yuꞌun cꞌalal a yalbe scꞌop Dios li crixchanoetic ta Nínive li Jonase, laj yictaic ta ora li cꞌustic chopol tspasique. Li Jonase mu tsotsuc yabtel laj yichꞌ. Joꞌon ti liꞌ oyun ta atojolique, tsots cabtel quichꞌoj, pero mu xavaqꞌuic ta venta li cꞌusi chacalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Oy toꞌox jun ants ta voꞌone ti ochem ta ajvalilal ta jun balumil ta xocon vinajel ta sur. Cꞌalal ta xcꞌot scꞌacꞌalil ti ta xichꞌ cꞌop li Diose, jaꞌ más tsots chavichꞌic vocol li joꞌoxuc ti liꞌ to oyoxuc ta balumile. Li vocol ta xichꞌ li meꞌajvalile, jaꞌ mu sta jech. Yuꞌun li antse nom ital, tal yaꞌibe scꞌop li mucꞌta ajvalil Salomone yuꞌun iyaꞌi ti lec pꞌije. Pero li Salomone mu tsotsuc yabtel laj yichꞌ. Joꞌon ti liꞌ oyun ta atojolique, más to joꞌon jnaꞌ, pero mu xavichꞌicun ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Joꞌoxuc ti liꞌ chavaꞌibecun li jcꞌope, más to chasoquic o ta scoj ti mu xavichꞌicun ta muqꞌue. Jaꞌ jech chac cꞌu chaꞌal jun vinic ti ilocꞌ pucuj ta yoꞌone. Li pucuje ibat ta taqui jamaltic, ba saꞌ bu ta xcux yoꞌon, pero muc bu sta. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jech iyal ta yoꞌon: “Jaꞌ lec chichaꞌsut batel nojtoc ta yoꞌon li vinique”, xi. Cꞌalal icꞌote, xocol cꞌot sta li bu toꞌox oye, yuꞌun li vinique muc bu yacꞌoj sba ta scꞌob li Diose. Stuc noꞌox stuqꞌuibtasoj sba jutuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaꞌ jech li pucuje ba saꞌ talel jucvoꞌ schiꞌiltac ta pucujal, jaꞌ li bu toj echꞌem chopolique. Tal ochicuc ta yoꞌon li vinique. Te inaquiic o. Li vinique más to isoc o tajmec. Jaꞌ noꞌox jech chapasbatic eꞌuc, joꞌoxuc ti liꞌ chavaꞌibecun li jcꞌope, yuꞌun mu xavichꞌicun ta mucꞌ ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cꞌalal te yac ta loꞌil li Jesuse, jaꞌ o te icꞌotic ta amacꞌ li smeꞌ li Jesuse schiꞌuc li yitsꞌinab li Jesuse yuꞌun chac scꞌoponic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oy buchꞌu tal albatuc ta ora li Jesuse: ―Te oyic ta amacꞌ ameꞌ schiꞌuc la avitsꞌinabe yuꞌun chac scꞌoponicot ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Itacꞌav li Jesuse: ―Melel jaꞌ jmeꞌ, jaꞌ quitsꞌinab li te oyique. Pero li buchꞌutic ta spasic li cꞌusi ta scꞌan li Jtot ta vinajele, jaꞌ coꞌol schiꞌuc jmeꞌ yaꞌel. Jaꞌ coꞌol schiꞌuc jchiꞌiltac ta voqꞌuel yaꞌel ―xut. Li Jesuse la syeꞌ scꞌob ta jtojolcutic, joꞌoncutic li yajchanbalajeltacuncutique. Jech laj yal: ―Qꞌuelavilic li jayvoꞌic ti liꞌ oyique, jaꞌ coꞌol schiꞌuc jmeꞌ yaꞌel. Jaꞌ coꞌol schiꞌuc jchiꞌiltac ta voqꞌuel yaꞌel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Li Jesuse ilocꞌ ta na, te ba chotluc ta tiꞌnab. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Toj ep jchiꞌiltactic la stsob sbaic talel jech iꞌoch ta canava te ta ba nab li Jesuse, te ichoti. Li jchiꞌiltactique te tsobolic ta tiꞌnab. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Li Jesuse lic scꞌopon li crixchanoetique. Oy ep cꞌusi laj yal ta loꞌil. Jech laj yal: ―Oy jun vinic ilocꞌ batel ta vajtrigo. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cꞌalal la svaj li strigoe, oy jaypꞌej icꞌot ta be. Ital mutetic, la stam sbicꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oy jaypꞌej icꞌot ta tontic ti bu muꞌyuc lec slumale. Ijav ta ora yuꞌun muc bu pim slumal. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Cꞌalal iqꞌuepe, icꞌanub ta ora, itaquij o yuꞌun muc bu yacꞌoj yibel. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oy jaypꞌej icꞌot ta yolon chꞌixtic. Cꞌalal ichꞌi li chꞌixe, inetꞌe comel, jaꞌ icꞌoxib o, muc bu satin. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oy jaypꞌej icꞌot ta lequil balumil. Lec ichꞌi, lec isatin. Oy iyacꞌ joꞌvinic (100) ta pꞌej, oy iyacꞌ oxvinic (60) ta pꞌej, oy iyacꞌ lajuneb schaꞌvinic (30) ta pꞌej. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Cꞌalal jtuccutic xa jchiꞌucutic li Jesuse, joꞌoncutic li yajchanbalajeltacuncutique, jech la jacꞌbecutic: ―¿Cꞌu chaꞌal ti muc jamal chavalbe li jchiꞌiltactique? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Itacꞌav li Jesuse: ―Li joꞌoxuque acꞌbiloxuc anaꞌic li cꞌu sba ta sventainan crixchanoetic li Diose, pero li yanetique mu xꞌacꞌbat snaꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yuꞌun li buchꞌutic jutuc to schꞌunojique, más to chcoltaatic yuꞌun Dios ti acꞌo schꞌunic leque, yuꞌun chacꞌ ta yoꞌonic. Li buchꞌutic mu scꞌan schꞌunique, li cꞌu yepal snaꞌique ta xpojbatic ta jꞌechꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jaꞌ yuꞌun ta loꞌil noꞌox chcalbeic. Yuꞌun altic noꞌox ti iyilic xa ti scotol xuꞌ cuꞌune yuꞌun muc xacꞌ ta yoꞌonic. Altic ti iyaꞌiic xa li cꞌusi laj cale, muc xaꞌibeic smelol yuꞌun mu onoꞌox scꞌan xaꞌiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jech icꞌot ta pasel li cꞌusi la stsꞌiba li Isaías li iyal scꞌop Dios ta voꞌonee: Ep xa ta velta avaꞌiic avilic pero mu xavaꞌibeic smelol, mu xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yuꞌun toj tsots avoꞌonic jech mu xuꞌ chachꞌunic o. Yuꞌun mu onoꞌox xachꞌunic li cꞌusi chavaꞌiique schiꞌuc li cꞌusi chavilique, jech mu xavaꞌibeic o smelol. Yuꞌun mu onoꞌox xacꞌan xavictaic li cꞌustic chopol chapasique, jech mu xacolic o cuꞌun, xi li Diose, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Joꞌoxuc li cajchanbalajeltacoxuque la scꞌuxubinoxuc xa li Diose jaꞌ yuꞌun chacꞌan chavaꞌibeic smelol li cꞌusi chcale schiꞌuc li cꞌusi ta jpase. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Melel li cꞌusi chacalbeique, ep li buchꞌutic iyalic scꞌop Dios ta voꞌonee schiꞌuc ep li buchꞌutic ti tucꞌ yoꞌonic ta voꞌonee, chac ox sqꞌuelic eꞌuc li cꞌusi ta jpase, pero muc xa xilic. Chac ox yaꞌiic eꞌuc li cꞌusi ta xcale, pero muc xa xaꞌiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Aꞌibeic me smelol li loꞌil li laj calboxuc ta sventa li jvajtrigoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oy buchꞌutic li cꞌalal chaꞌiic ti tscꞌan tsventain crixchanoetic li Diose, mu xaꞌibeic smelol. Jech chtal ta ora li pucuje, chtal chꞌaybatuc ta sjolic ta ora li scꞌop Dios ti iyaꞌiique. Jaꞌ jech smelol li becꞌ trigo li icꞌot ta bee. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Li becꞌ trigo li icꞌot ta tontique, jaꞌ senyail li buchꞌutic li cꞌalal ta xaꞌiic li scꞌop Diose, ta ora noꞌox tschꞌunic, xmuybajic noꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero mu ta sloqꞌueluc yoꞌonic la schꞌunic, jech cꞌalal ta xichꞌic vocol cꞌalal schꞌunojique, ta xchibaj yoꞌonic ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Li becꞌ trigo li icꞌot ta yolon chꞌixtique, jaꞌ senyail li buchꞌutic yaꞌiojic li scꞌop Diose, ti jaꞌ noꞌox batem ta yoꞌonic li cꞌustic oy liꞌ ta balumile. Jaꞌ te loꞌlobilic o yuꞌun li cꞌustic ta scꞌanique. Te netꞌbil icom o yaꞌel li scꞌop Dios li laj yaꞌiique, jech muc schꞌunic o. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Li becꞌ trigo li icꞌot ta lequil balumile, ti iyacꞌ joꞌvinic ta jpꞌej sbeqꞌue, schiꞌuc ti iyacꞌ oxvinic ta pꞌej sbeqꞌue, schiꞌuc ti iyacꞌ lajuneb schaꞌvinic ta pꞌej sbeqꞌue, jaꞌ senyail li buchꞌutic chacꞌ ta yoꞌonic li scꞌop Diose, ti lec chaꞌibeic li smelole. Ta satin ta yoꞌonic yaꞌel li scꞌop Diose. Acꞌo mi ta xichꞌic vocol, mu xchibaj o yoꞌonic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Li Jesuse laj yal loꞌil nojtoc. Jech laj yal: ―Chacalbeic ti cꞌu sba chventainatic li buchꞌutic chichꞌic ta mucꞌ li Diose. Jaꞌ jech chac cꞌu chaꞌal jun vinic ti ba svaj strigo ta yosile. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Cꞌalal vayalic xaꞌox scotolique, ital ta acꞌubaltic li yajcontrae. Tal svajbe sbecꞌ lobol tꞌul li yoꞌ bu vajbil xaꞌox li trigoe. Cꞌalal la svaj li sbecꞌ lobol tꞌul li yajcontrae, isut batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cꞌalal ichꞌi li trigoe, isatin. Jaꞌ to te ivinaj li lobol tꞌule. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Li yajtuneltac li yajval osile jech la sjacꞌbeic: “Cajval, ¿mi mu naca trigouc li la avaj ta avosile? Li avie iquilcutic ti capal schiꞌuc lobol tꞌule”, xiic li yajtuneltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Itacꞌav li yajval osile: “Jaꞌ la svaj li cajcontrae”, xi. Li yajtuneltaque jech iyalic: “Mi chacꞌane, chba jbulcutic loqꞌuel li lobol tꞌule”, xut li yajvalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Itacꞌav li yajval osile: “Moꞌoj, mu xba abulic li lobol tꞌule naca me te capal xbul loqꞌuel li trigoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Acꞌo chꞌiuc schaꞌchopol jaꞌ to mi ista yora ta xichꞌ tuchꞌele. Cꞌalal ta xa xichꞌ tuchꞌele, jech chcalbeic li cajtuchꞌtrigoetique: Tꞌujic loqꞌuel lec baꞌi li lobol tꞌule, chuquic ta juchuc yuꞌun ta xichꞌ chiqꞌuel. Tsꞌacal to xatsobic li jtrigoe, xatiqꞌuic ochel ta snail jtrigo, xcutic”, xi li yajval osile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Laj yal yan loꞌil li Jesuse, jech laj yalbe li jchiꞌiltactique: ―Chacalbeic nojtoc li cꞌu sba ta sventainan crixchanoetic li Diose. Acꞌo mi muc bu ep li buchꞌutic ta xventainatic li avie pero ta tsꞌacale ta xꞌepaj. Jaꞌ jech chac cꞌu chaꞌal li becꞌ mustasa ti la stsꞌun ta yosil jun vinique ti toyol ibate. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Li becꞌ mustasae toj biqꞌuitic, pero mi ichꞌie, toyol chbat. Jaꞌ mu sta jech smucꞌul li yan tsꞌunubiletic li biqꞌuitic sbecꞌ eꞌuque. Li mustasae chacꞌ ep scꞌob. Ta xtal mutetic, ta spas stasic ta scꞌobtac ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Laj yal yan loꞌil li Jesuse. Jech laj yal: ―Chacalbeic li cꞌu sba ta sventainan crixchanoetic li Diose. Oy lec stsatsal jech chac cꞌu chaꞌal svochesobil pan. Li jucub cuartia harinae, manchuc mi jutuc noꞌox chacꞌbe scap li antse, pero lec ta xvoch o spꞌejel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Li Jesuse naca ta loꞌil noꞌox laj yalanbe li jchiꞌiltactique pero oy smelol li cꞌustic laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yuꞌun jaꞌ icꞌot ta pasel li cꞌusi laj yal li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Jech laj yalic: Naca ta loꞌil ta xalanbe li crixchanoetique. Jaꞌ ta xal li cꞌustic muc bu yaꞌiojic ti cꞌalal ismeltsan balumil li Diose, xi tsꞌibabil ta scꞌop Dios. Jaꞌ scꞌoplal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Li Jesuse la scꞌopon comel li jchiꞌiltactique, iꞌoch ta yut na. La jchiꞌincutic ochel, joꞌoncutic li yajchanbalajeltacuncutique. Jech la jacꞌbecutic: ―Albun caꞌicutic li cꞌusi smelol li loꞌil li sventa lobol tꞌul li la avale ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jech laj yalbuncutic li Jesuse: ―Li trigoe joꞌon la jvaj, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Li cosile jaꞌ spꞌejel li balumile. Li trigoe jaꞌ li buchꞌutic ta xacꞌ sbaic ta ventainel yuꞌun li Diose. Li lobol tꞌule jaꞌ li buchꞌutic chopol li cꞌustic tspasique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Li cajcontra ti la svaj li lobol tꞌule, jaꞌ li banquilal pucuje. Li yorail ta xichꞌ tuchꞌele jaꞌ li slajeb cꞌacꞌale. Li jtuchꞌtrigoetique jaꞌ li yajꞌangeltac li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jech chac cꞌu chaꞌal la stsobic li lobol tꞌul ti la schiqꞌuique, jaꞌ jech ta xcꞌot ta pasel ta slajeb cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Joꞌon li coꞌol crixchanoutique ta jtac talel cajꞌangeltac. Jaꞌ chtal stsobic scotol li buchꞌutic ta socbe yoꞌon li schiꞌilique schiꞌuc li buchꞌutic chopol li cꞌustic tspasique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jaꞌ ta sjipic ochel ta cꞌocꞌ. Te xꞌoqꞌueletic o, te xcꞌuxuxet o yeic ta scoj ti tsots li vocol chichꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yan li buchꞌutic tucꞌ yoꞌonique ch‐acꞌbat xojobalic li cꞌalal te xa oyic li yoꞌ bu ta spas mantal li Jtotique yuꞌun jaꞌ snichꞌnab. Li xojobalique jaꞌ jech chac cꞌu chaꞌal li xojobal li cꞌacꞌale. Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jech laj yal nojtoc li Jesuse: ―Li cꞌu sba ta xventainvan li Diose, jaꞌ jech chac cꞌu chaꞌal li meꞌtaqꞌuin ti te mucul ta lum ta jsetꞌ osile. Oy jun vinic ista, te la schaꞌmuc comel nojtoc. Xmuybaj tajmec, jech ba schon scotol li cꞌustic oy yuꞌune, yuꞌun jaꞌ chac sman li jsetꞌ osil li bu ista li meꞌtaqꞌuine. Jaꞌ noꞌox jech li joꞌoxuque, scꞌan ti jaꞌ noꞌox batem ta avoꞌonic ti chacꞌanic ventainel yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jech laj yal nojtoc li Jesuse: ―Li cꞌu sba ta xventainvan li Diose, jaꞌ jech chac cꞌu chaꞌal jpꞌej natsꞌil li bu toj toyol stojole ti jaꞌ tsaꞌ li buchꞌu chmanolaje. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cꞌalal ista li natsꞌil li bu toj toyol stojole, ba schon scotol li cꞌustic oy yuꞌune, yuꞌun jaꞌ chac sman li jpꞌej natsꞌile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jech laj yal nojtoc li Jesuse: ―Li cꞌu sba ta spas mantal li Diose, jaꞌ jech chac cꞌu chaꞌal jtsac‐choyetic ti tstiqꞌuic ochel snutiꞌic ta nabe. Te ch‐och ep ta chop choyetic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cꞌalal mi inoj li snutiꞌique, ta sloqꞌuesic ba ta tiꞌnab. Te chba chotlicuc stꞌujel li bu lequique, ta stiqꞌuic ta moch. Yan li bu chopolique ta sjipic ba. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jaꞌ jech ta xcꞌot ta pasel ta slajeb cꞌacꞌal. Chtal li yajꞌangeltac li Diose, jaꞌ chtal svoqꞌuelic li buchꞌutic chopol yoꞌonique schiꞌuc li buchꞌutic lec yoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta xjipeic ochel ta mucꞌta cꞌocꞌ li buchꞌutic chopol yoꞌonique. Te xꞌoqꞌueletic o, te xcꞌuxuxet o yeic ta scoj ti tsots li vocol ti ta xichꞌique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Li Jesuse jech la sjacꞌbuncutic: ―¿Mi avaꞌibeic smelol scotol li cꞌustic laj cale? ―xi. La jtacꞌbecutic: ―Laj caꞌicutic, Cajval ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jech laj yalbuncutic nojtoc: ―Lec ti avaꞌibeic li smelole. Yuꞌun li joꞌoxuque avaꞌiojic onoꞌox li cꞌustic iꞌalbatic yuꞌun Dios li jtotic jmeꞌtic ta voꞌonee. Li avie avaꞌiic xa eꞌuc ti cꞌu sba chasventainic li Diose. Jaꞌ jechoxuc jech chac cꞌu chaꞌal jun yajval na ti oy scotol li cꞌustic ta xtun yuꞌune. Yuꞌun jaꞌ yichꞌojbe comel li cꞌustic toꞌox yuꞌun li ánima stote, schiꞌuc oy cꞌustic yuꞌun stuc. Te xa yichꞌoj scotol li cꞌustic ta xtun yuꞌune ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cꞌalal ilaj yoꞌon ta loꞌil li Jesuse, ilocꞌ batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Isut batel ta jteclum Nazaret li yoꞌ bu ichꞌie. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Te ichanubtasvan ta schꞌulnaic li jchiꞌiltactic ta israelale. Li buchꞌutic iyaꞌiique toj chꞌayel noꞌox yoꞌonic. Jech laj yalbe sbaic: ―¿Bu iyichꞌ spꞌijil li jchiꞌiltic liꞌi? ¿Bu ista stsatsal sjuꞌel ti scotol xuꞌ yuꞌune? ");
INSERT INTO tzoSA_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jaꞌ snichꞌon li carpinteroe. Jaꞌ yol li Maríae. Li yitsꞌinabe jaꞌ li Jacoboe, schiꞌuc li Josee, schiꞌuc li Simone, schiꞌuc li Judase. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jaꞌ yixleltac nojtoc li liꞌ jchiꞌuctic ta nacleje. ¿Bu ischan scotol ti jech ta spase? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jaꞌ yuꞌun muc bu schꞌunic ti jaꞌ acꞌbil yabtel yuꞌun li Diose. Li Jesuse jech laj yalbe li crixchanoetique: ―Li butic chcꞌotic li buchꞌutic ta xalic li scꞌop Diose jaꞌ acꞌbilic ta venta. Pero ta yosilal stuquique schiꞌuc ta snaique mu xꞌaqꞌueic ta venta ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jech muc bu ep iyacꞌ ta ilel stsatsal sjuꞌel li te ta jteclum li yoꞌ bu ichꞌi li Jesuse, yuꞌun mu schꞌunic ti jaꞌ acꞌbil yabtel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Li ajvalil ta Galilea balumile, jaꞌ li Herodese, iyaꞌi li cꞌustic tspas li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jaꞌ yuꞌun laj yalbe li yajꞌabteltaque: ―Taje jaꞌ li Juan li iyacꞌ ta ichꞌel joꞌe. Yuꞌun ichaꞌcuxi, jaꞌ yuꞌun oy sjuꞌel yoꞌ tspas li cꞌustic lec ta spase ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yuꞌun li Herodese jaꞌ onoꞌox la stac ta tsaquel li Juane, la spas mantal ti acꞌo chuqueuc ta carena ta yut chucvanab ta scoj li Herodíase, jaꞌ li yajnil toꞌox li yitsꞌin li Herodese. Felipe sbi li yitsꞌine. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ti la sticꞌ ta chuquel Juan li Herodese, yuꞌun chopol iyaꞌi ti jech iꞌalbate: “Mu lecuc chil Dios ti apojbe yajnil la avitsꞌine”, xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jaꞌ yuꞌun li Herodese chac toꞌox yacꞌ ta milel li Juane pero ixiꞌ o li ta jchiꞌiltactic ta israelale yuꞌun schꞌunojic ti jaꞌ chal li scꞌop Dios li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Más to tsꞌacal li cꞌalal ilocꞌ ta sjabilal li Herodese la spas sqꞌuinal. Li stseub li Herodíase iꞌacꞌotaj ta satic scotol li buchꞌutic te oyique. Li Herodese toj lec sba iyil. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jech laj yalbe li tseube: ―Cꞌanbun ti cꞌusi chacꞌane. Yiloj Dios ti chacacꞌbee ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Li tseube la sjacꞌbe smeꞌ ti cꞌusi acꞌo scꞌanbe li Herodese, jech iꞌalbat yuꞌun smeꞌ ti cꞌusi acꞌo scꞌanbee. Li tseube jech ba yalbe li Herodese: ―Acꞌbun talel ta pulatu sjol li Juan li iyacꞌ ta ichꞌel joꞌe ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Cꞌalal iyaꞌi li Herodese, chopol iyaꞌi. Pero ta scoj ti la stꞌabbe sbi li Diose schiꞌuc ti laj yaꞌiic eꞌuc li buchꞌutic te coꞌol iveꞌic ta mexae, jaꞌ yuꞌun iyal ti xuꞌ ta xichꞌbe sjol li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","La stac batel ta ora yajsoltarotac yoꞌ acꞌo ba stuchꞌbeic talel sjol li Juan li te tiqꞌuil ta chuquele. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","La spachbeic talel sjol Juan ta jun pulatu, laj yacꞌbeic li tseube. Li tseube ba yacꞌbe li smeꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Italic li yajchanbalajeltac li Juane, laj yichꞌbeic batel li sbecꞌtal stacupale, ba smuquic. Ba yalbeic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Li Jesuse iyaꞌi ti ipꞌise ta Juan yuꞌun li Herodese, iꞌoch ta canava, ibat ta taqui jamaltic. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Cꞌalal iyaꞌiic li jchiꞌiltactic ta israelal ti ibat li Jesuse, oy jayib ta jteclum bu iloqꞌuic batel yuꞌun ba staic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cꞌalal lijlocꞌcutic ta canavae, ep te tsobolic ijtacutic. Li Jesuse la scꞌuxubinan, la scoltaan li jchamelajeletic ti te capal italique. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cꞌalal xtupꞌet xaꞌox osile, la jcꞌoponcutic Jesús, joꞌoncutic li yajchanbalajeltacuncutique. Jech laj calbecutic: ―Liꞌi taqui jamaltic. Ibat xa li cꞌacꞌale. Jaꞌ lec tacano me batel li crixchanoetique, acꞌo ba sman sveꞌelic ta naetic ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Itacꞌav li Jesuse: ―Mu persauc bu xbatic. Macꞌlanic li joꞌoxuque ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","La jtacꞌbecutic: ―Mu cꞌusi oy cuꞌuncutic. Jaꞌ noꞌox joꞌpꞌej pan schiꞌuc chaꞌcot choy liꞌ quichꞌojcutique ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Itacꞌav li Jesuse: ―Ichꞌic talel ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Li Jesuse laj yalanbe li jchiꞌiltactic ti acꞌo chotlicuc ta yaxaltique. Li Jesuse la stsac li joꞌpꞌej pane schiꞌuc li chaꞌcot choye. La sqꞌuel muyel ta vinajel, laj yalbe coliyal Dios. La xutilan li pane schiꞌuc la stuchꞌilan li choye. Laj yacꞌbuncutic, joꞌoncutic li yajchanbalajeltacuncutique. La jpucbecutic scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iveꞌ scotolic, inojic o lec. La jtsobbecutic scomenal li pane schiꞌuc li scomenal li choye, inoj lajchamoch. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ti cꞌu yepal iveꞌique, oy nan joꞌmiluc viniquetic. Jaꞌ slecoj li antsetique schiꞌuc li unetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Li Jesuse laj yalbuncutic ti acꞌo ochcuncutic ta ora ta canavae ti baꞌi chijelavcutic ta jot nabe. Li Jesuse stuc xa te icom, iscꞌoponan comel li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cꞌalal ilaj yoꞌon ta scꞌoponel comele, imuy batel ta vits, ba sta ta naꞌel Dios. Cꞌalal iꞌoch acꞌubale, stuc te oy ta vits li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Li joꞌoncutique ta oꞌlol nab xaꞌox xijꞌechꞌcutic. Toj tsots li iqꞌue, xyucꞌlajet tajmec li nabe. Toj vocol ta xanav batel li canavae yuꞌun ta snup sbaic schiꞌuc li iqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cꞌalal poꞌot xaꞌox tsacube, ital Jesús li yoꞌ bu oyuncutique. Iquilcutic ti yac ta xanbal talel ta ba nabe. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cꞌalal iquilcutic ti yac ta xanbal talel ta ba nabe, lijxiꞌcutic tajmec. La jnopcutic ti jaꞌ chꞌulelale. Xijꞌavetcutic tajmec yuꞌun toj echꞌem lijxiꞌcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Icꞌopoj ta ora li Jesuse, jech lijyalbuncutic: ―Mu me xaxiꞌic, joꞌon Jesusun. Tsatsubtaso avoꞌonic ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Itacꞌav li Pedroe: ―Cajval, mi melel ti joꞌote, alo ti xuꞌ chixanav talel ta ba nab eꞌuc yoꞌ chtal jnupot ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Itacꞌav li Jesuse: ―Laꞌ me ―xi. Ilocꞌ ta canava li Pedroe, ixanav batel ta ba nab yuꞌun chba snup li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero cꞌalal iyaꞌi ti toj tsots li iqꞌue, ixiꞌ. Yuꞌun xaꞌox ta xmuquij yalel ta yut nab, laj yapta Jesús li Pedroe: ―¡Coltaun, Cajval! ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Li Jesuse ta ora la stsacbe scꞌob li Pedroe, laj yalbe: ―¿Cꞌu chaꞌal chaxiꞌ? ¿Mi muc to bu achꞌunoj ti joꞌon chajcoltae? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cꞌalal iꞌochic xaꞌox ta yut canavae, ipaj ta ora li iqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Joꞌoncutic li te oyuncutic ta yut canavae la jquejan jbacutic, laj quichꞌcutic ta mucꞌ li Jesuse. Laj calbecutic: ―Melel joꞌot Snichꞌonot li Diose ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cꞌalal lijcꞌotcutic ta jot nabe, te lijlocꞌcutic ta canava ta Genesaret balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Li jchiꞌiltactic ta israelal ti te nacalique iyojtaquinic ti jaꞌ Jesús li te icꞌote. Ba yalic ta ora ta spꞌejel Genesaret ti ital li Jesuse. Laj yiqꞌuic talel ta stojol Jesús ep jchamelajeletic. ");
INSERT INTO tzoSA_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Oy buchꞌutic iyalbeic vocol Jesús ti jaꞌ noꞌox acꞌo yacꞌ ta piquel li stiꞌ spuychije. Li buchꞌutic la spicbeic li stiꞌ spuychije icolic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tal scꞌoponic Jesús jayvoꞌ jfariseoetic schiꞌuc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac Dios ti liquemic talel ta Jerusalene. Jech laj yalbeic: ");
INSERT INTO tzoSA_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Cꞌu chaꞌal mu jechuc ta spasic la avajchanbalajeltac jech chac cꞌu chaꞌal li stalelic li jtotic jmeꞌtic ta voꞌonee? Yuꞌun muc bu jal ta spoc scꞌobic li cꞌalal chveꞌic la avajchanbalajeltaque. Yan li jtotic jmeꞌtic ta voꞌonee jal la spoc scꞌobic li cꞌalal iveꞌique, yoꞌ jech lec ta xꞌileic o yuꞌun li Diose ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Itacꞌav li Jesuse: ―Li joꞌoxuque muc bu avichꞌojic ta mucꞌ li smantaltac li Diose. Jaꞌ noꞌox avichꞌojbeic stalel li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yuꞌun jech onoꞌox yaloj li Diose: “Ichꞌo ta mucꞌ atot ameꞌ”, xi. “Li buchꞌu ta xalbe stot smeꞌ ti acꞌo lajuc chamuque, jaꞌ acꞌo mileuc”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Pero li joꞌoxuque lec chavaꞌiic mi jech ta xalbeic li stot smeꞌique: “Li cꞌu yepal ta jtae laj xa cal ti chcacꞌ ta sventa smoton li Diose”, mi xutic li stot smeꞌique, li joꞌoxuque lec chavaꞌiic ti jech chalique. Chavalbeic ti xuꞌ xa mu scꞌuxubin li stot smeꞌique. Jaꞌ jech chavictabeic o li smantaltac Dios ta scoj ti jaꞌ avichꞌojbeic li stalelic li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jloꞌlovanejoxuc. Jaꞌ acꞌoplalic ti jech iꞌalbat yuꞌun Dios li Isaías ta voꞌonee. Jech la stsꞌiba: ");
INSERT INTO tzoSA_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","La achiꞌiltaque ta ye noꞌox chiyichꞌic ta mucꞌ, mu ta sloqꞌueluc yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jaꞌ smantal noꞌox crixchanoetic ti ta xchanubtasvanic oe. Maꞌuc jcꞌop ti chaqꞌuic ta chanele, xi li Diose, xi onoꞌox li Isaíase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Li Jesuse lic scꞌoponan scotol li jchiꞌiltactique. Jech laj yalbe: ―Aꞌibeic lec smelol li cꞌusi chacalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Muc bu chopol chayilic Dios ta sventa li cꞌustic chalajesique. Jaꞌ noꞌox chopol chayilic o li cꞌustic chlocꞌ ta aveique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Joꞌoncutic li yajchanbalajeltacuncutique lijnopojcutic batel ta stojol li Jesuse, jech laj calbecutic: ―¿Mi xanaꞌ ti mu lecuc iyaꞌiic li jfariseoetic ti jech la avalbee? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Itacꞌav li Jesuse: ―Li jfariseoetique ta xchanubtasvanic ti mu persauc chachꞌunic scotol li cꞌusi yaloj li Jtot ta vinajele. Jaꞌ yuꞌun ta onoꞌox xlaj scꞌoplalic jech chac cꞌu chaꞌal ta xichꞌ bulel li tsꞌiꞌleletique. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jech mu me xcꞌopoj o avoꞌonic. Yuꞌun jaꞌ jechic jech chac cꞌu chaꞌal li maꞌsatetic ti tscꞌan chacꞌbeic yil be li schiꞌilic ta maꞌsatile. Pero mi coꞌol maꞌsatetique, jech coꞌol ta stsꞌujic yalel ta lom chꞌen ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jech laj yal li Pedroe: ―Albuncutic li smelol li loꞌil la avale ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Itacꞌav li Jesuse: ―¿Mi muc bu xavaꞌibeic smelol eꞌuc li joꞌoxuque? ");
INSERT INTO tzoSA_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mi mu xanaꞌic li cꞌustic chalajesique ta achꞌutic ta xcꞌot, echꞌel noꞌox ch‐echꞌ? ");
INSERT INTO tzoSA_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yan li cꞌustic chlocꞌ ta aveique ta avoꞌonic chlic talel, jech chopol chayilic o li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yuꞌun ta yoꞌonic li crixchanoetique chlic talel li cꞌustic chopol ta snopique, mi chmilvanic, mi chmulivajic, mi ch‐elcꞌajic, mi tsjutic cꞌop, mi tsloꞌiltaan schiꞌilic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ta scoj li cꞌustic chopol tspasique, jaꞌ chopol ta xꞌileic o yuꞌun li Diose. Mi jaꞌ noꞌox muc bu jal chapoc acꞌobic li cꞌalal chaveꞌique, maꞌuc chopol chayilic o li Diose ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ilocꞌ batel li Jesuse, la jchiꞌincutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Te lijbatcutic ta nopol chib jteclum Tiro schiꞌuc Sidón. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Te ilocꞌ talel jun ants, jaꞌ snitilul li buchꞌutic li te toꞌox nacalic ta Canaán balumil ta voꞌonee. Acꞌo mi mu onoꞌox xquilcutic ta lec li buchꞌutic ti maꞌuc jchiꞌiltic ta israelale, pero li antse laj yapta li Jesuse: ―Tata, joꞌot snitilulot li Davide, cꞌuxubinbun li jtseube yuꞌun ochem pucuj ta yoꞌon. Toj echꞌem ta xichꞌ vocol ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Li Jesuse mu jpꞌeluc itacꞌav. Joꞌoncutic li yajchanbalajeltacuncutique jech laj calbecutic li Jesuse: ―Avocoluc taco ba li antse yuꞌun toj tsots chijyaptautic talel ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Li Jesuse jech la stacꞌbe li antse: ―Joꞌone jaꞌ noꞌox tacbilun talel ta sventa li jchiꞌiltac ta israelale yuꞌun chꞌayemic jech chac cꞌu chaꞌal li chijetique. Yan o be stamojic ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Li antse tal squejan sba ta stojol li Jesuse, jech laj yalbe: ―Tata, coltaun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Itacꞌav li Jesuse: ―Muc bu lec mi ta jpojbetic yot li nichꞌoniletique sventa ta xcacꞌbetic sveꞌic li tsꞌiꞌetique ―xut, yuꞌun chqꞌuelbat yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Itacꞌav li antse: ―Jnaꞌoj, tata. Pero oy onoꞌox ta stsꞌuj yalel schꞌuchꞌulil yotic ta yolon smexaic li nichꞌoniletique. Jaꞌ ta stsob sveꞌic li tsꞌiꞌetique. Jaꞌ jechun li joꞌone, abolajan cꞌuxubinun ―xi li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Li Jesuse jech la stacꞌbe: ―Chquil ti ta sloqꞌuel avoꞌon achꞌunoj ti joꞌon Jcoltavanejune. Jech acꞌo cꞌotuc ta pasel li cꞌusi chacꞌanbune ―xut. Ilocꞌ ta ora li pucuj ta yoꞌon li stseube. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Li Jesuse ilocꞌ batel, ibat ta tiꞌnab ta Galilea balumil. La jchiꞌincutic batel. Lijmuycutic batel ta vits, te cꞌot chotlucuncutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","La stsob sbaic talel ta stojol Jesús ep jchiꞌiltactic. Laj yicꞌanic talel coxoetic, schiꞌuc maꞌsatetic, schiꞌuc umaꞌetic, schiꞌuc buchꞌutic muꞌyuc scꞌobic, schiꞌuc yan jchamelajeletic. Te cꞌot yaqꞌuic ta stojol li Jesuse. Icol yuꞌun scotol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Li jchiꞌiltactique toj chꞌayel yoꞌonic li cꞌalal iyilic ti ijam ye li umaꞌetique, schiꞌuc ti imeltsaj xa lec scꞌobic li buchꞌutic ti muc onoꞌox bu lec scꞌobique, schiꞌuc ti lec xa chanavic li coxoetique, schiꞌuc ti ijam xa satic li maꞌsatetic toꞌoxe. Jech lec ibat scꞌoplal li Dios cuꞌuntic, joꞌotic li jꞌisraelutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Li Jesuse la stsobuncutic, joꞌoncutic li yajchanbalajeltacuncutique, jech laj yalbuncutic: ―Toj abol sbaic li jchiꞌiltactic liꞌi, yuꞌun yoxibal xa cꞌacꞌal liꞌ tsobolic ta jtojole, chꞌabal xa cꞌusi tslajesic. Mu jcꞌan ta jtaquic batel ta snaic cꞌalal chviꞌnajique naca me lubtsajicuc ta be ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jech la jtacꞌbecutic: ―¿Bu ta jtacutic epal pan liꞌ ta taqui jamaltic sventa ta jmacꞌlantascutic o yuꞌun toj epic? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","La sjacꞌbuncutic li Jesuse: ―¿Jaypꞌej pan oy avuꞌunic? ―xijyutcutic. Lijtacꞌavcutic: ―Jucpꞌej schiꞌuc chaꞌoxcot bicꞌtal choy ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Li Jesuse laj yalbe jchiꞌiltactic ti acꞌo chotlicuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","La stsac li jucpꞌej pane schiꞌuc li bicꞌtal choye, laj yalbe coliyal Dios. La xutilan li pane schiꞌuc la stuchꞌilan li bicꞌtal chove, laj yacꞌbuncutic, joꞌoncutic li yajchanbalajeltacuncutique. La jpucbecutic li jchiꞌiltactique. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iveꞌ scotolic, inojic o lec. La jtsobbecutic scomenal li pane schiꞌuc li scomenal li choye, inoj jucmoch. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ti cꞌu yepal iveꞌique jaꞌ chanmil li viniquetique. Jaꞌ slecoj li antsetique schiꞌuc li unetique, muc bu xꞌochic ta atel. ");
INSERT INTO tzoSA_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Li Jesuse la scꞌopon comel li jchiꞌiltactique, laj yalanbe ti acꞌo baticuque. Lijꞌochcutic ta canava schiꞌuc li Jesuse. Lijbatcutic ta nopol jteclum Magdala. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Italic jayvoꞌ jfariseoetic schiꞌuc jsaduceoetic yuꞌun chac sqꞌuelic li cꞌu sba chtacꞌav li Jesuse. Jech cꞌot yalic: ―Acꞌbun quilcutic ta vinajel la atsatsal ajuꞌele yoꞌ jech ta jnaꞌcutic o ti acꞌbilot yuꞌun Dios la avabtele ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Itacꞌav li Jesuse: ―Cꞌalal ichꞌay xaꞌox cꞌacꞌale, jech chavalic: “Ocꞌobe lec qꞌuepel yuꞌun tsoj li vinajele”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta sobe jaꞌ noꞌox jech chavalic nojtoc: “Ta xtal joꞌ tana yuꞌun toj tsoj li vinajele schiꞌuc oy ep toc”, xachiic. Jloꞌlovanejoxuc. Xanaꞌic sqꞌuelel li cꞌu sba ta vinajele pero jaꞌ mu xanaꞌic sqꞌuelel ti avalojic li cꞌustic lec ti cꞌotem xa ta pasel ta atojolic li avie. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Li buchꞌutic chopol yoꞌonic ti mu junuc yoꞌonic ta stojol li Diose, tscꞌanic ti chcacꞌulan ta ilel li jtsatsal juꞌele. Pero mu xꞌacꞌbat yilic. Jaꞌ noꞌox ta xꞌacꞌbat yilic jech chac cꞌu chaꞌal icꞌot ta pasel ta stojol li Jonase, jaꞌ li iyal scꞌop Dios ta voꞌonee ―xut. Li Jesuse laj yicta comel li crixchanoetique, lijlocꞌcutic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lijcꞌotcutic ta jot nab schiꞌuc li Jesuse. Joꞌoncutic li yajchanbalajeltacuncutique muc bu xjul ta jolcutic chquichꞌcutic ba jpancutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Laj yalbuncutic li Jesuse: ―Qꞌuelo me abaic ta sventa svochesobil spanic li jfariseoetique schiꞌuc li jsaduceoetique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Li joꞌoncutique jech laj calbe jbacutic: ―Jaꞌ nan chijyalbutic yuꞌun muc bu xquichꞌtic talel li jpantique ―xcut jbacutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Li Jesuse iyil cꞌu sba coꞌoncutic, jech laj yalbuncutic: ―¿Cꞌu chaꞌal jaꞌ chanopic ta sventa ti muc bu xavichꞌic talel jpantique? Yuꞌun muc to bu achꞌunojic chaꞌa ti scotol xuꞌ cuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mu to xcꞌot ta avoꞌonic. ¿Mi ichꞌay xa avaꞌiic ti ta joꞌpꞌej pan noꞌox iveꞌic o li joꞌmil viniquetique schiꞌuc ti jaymoch scomenal la atsobique? ");
INSERT INTO tzoSA_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Mi ichꞌay xa avaꞌiic nojtoc ti ta jucpꞌej pan noꞌox iveꞌic o li chanmil viniquetique schiꞌuc ti jaymoch scomenal la atsobique? ");
INSERT INTO tzoSA_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Mi muc xavaꞌibeic smelol ti maꞌuc ta sventa pan ti jech laj calboxuque: “Qꞌuelo me abaic ta sventa svochesobil spanic li jfariseoetique schiꞌuc li jsaduceoetique”, ti xacutique? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jech laj caꞌibecutic o smelol ti maꞌuc ta sventa li batsꞌi svochesobil pane. Jaꞌ noꞌox laj yalbuncutic ti acꞌo jqꞌuel jbacutic ta sventa li cꞌu sba ta xchanubtasvanic li jfariseoetic schiꞌuc li jsaduceoetique. Yuꞌun chalic ti mu persauc ta jchꞌuntic scotol li cꞌustic yaloj li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cꞌalal lijcꞌotcutic schiꞌuc Jesús ta nopol jteclum Cesarea Filipoe, jtuccutic te la sjacꞌbuncutic li Jesuse: ―¿Cꞌusi la cabtel ta xalic li jchiꞌiltactic, joꞌon li coꞌol crixchanoutique? ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","La jtacꞌbecutic: ―Oy buchꞌutic ta xalic ti joꞌot Juanot li iyacꞌ ta ichꞌel joꞌ toꞌoxe. Oy yan ta xalic ti joꞌot Elíasote. Oy buchꞌutic ta xalic ti joꞌot Jeremíasote. Oy yan ta xalic ti joꞌot jun li buchꞌutic iyalic scꞌop Dios ta voꞌonee ti yuꞌun nan ichaꞌcuxie ―xijchicutic lijtacꞌavcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jech la sjacꞌbuncutic nojtoc: ―Li joꞌoxuque, ¿cꞌusi cabtel ti avalojic eꞌuque? ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Itacꞌav li Simón Pedroe: ―Joꞌot Cristoot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique. Joꞌot Snichꞌonot li cuxul Diose ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Itacꞌav li Jesuse: ―Lec ta smelol latacꞌav, Simón, joꞌot snichꞌonot Jonás. Maꞌuc crixchano laj yacꞌbot anaꞌ ti cꞌusi cabtele. Jaꞌ laj yacꞌbot anaꞌ li Jtotic ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jech chacalbe eꞌuc. Joꞌot Pedroot, joꞌot ta aventa ep buchꞌutic ta schꞌunic ti joꞌon Yajcoltavanejicune. Ta persa ta xcꞌot ta pasel. Acꞌo mi tscꞌan ta schꞌaybun jcꞌoplal li pucuje pero mu xuꞌ yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta xcom ta aventa ti chavalbe yaꞌiic li crixchanoetic ti cꞌu sba xuꞌ ta xcꞌotic ta stojol li Diose. Li buchꞌutic ti mu xictaic li cꞌustic chopol tspasique, albo ti oy smulic ta xꞌileic yuꞌun li Diose. Pero li buchꞌutic ti laj xa yictaic li cꞌustic chopol tspasique, albo ti muꞌyuc xa smulic ta xꞌileic yuꞌun li Diose ―xꞌutat yuꞌun Jesús li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Li Jesuse jech laj yalbuncutic: ―Mu to me buchꞌu xavalbeic ti joꞌon tꞌujbilun yuꞌun Dios ti chajventainique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Li Jesuse jech laj yalbuncutic: ―Persa chibat ta Jerusalén yuꞌun jaꞌ te chcꞌot quichꞌ vocol. Chiꞌaqꞌue ta scꞌob li jꞌabteletique, schiꞌuc li banquilal paleetique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Chiyaqꞌuic ta milel, chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Li Pedroe laj yicꞌ loqꞌuel jutuc li Jesuse, jech laj yalbe: ―Cajval, acꞌo scꞌuxubinot li Diose, mu jechuc o smelol ti chamilee ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Li Jesuse la sqꞌuelbe sat li Pedroe, laj yalbe: ―Satanás, locꞌan ta jtojol yuꞌun chac amacun. Maꞌuc chanop li cꞌusi tscꞌan li Diose. Jaꞌ noꞌox chanop li cꞌusi tscꞌan li crixchanoetique ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Li Jesuse jech laj yalbuncutic: ―Li buchꞌu tscꞌan chtal ta jtojole mu me scꞌuxubin sba. Acꞌo cuchuc yuꞌun vocol jech chac cꞌu chaꞌal chcuch cuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Li buchꞌu tscꞌuxubin li scuxlejal liꞌ ta balumile, ti mu scꞌan xcham ta jventa joꞌone, jaꞌ ta xchꞌay o sbatel osil. Yan li buchꞌu mu xichꞌ ta cꞌux li scuxlejal liꞌ ta balumile, ti mu sventauc mi te ta xcham ta jventa joꞌone, jaꞌ ta xcuxi o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Acꞌo mi oy buchꞌu ti chal ti tsbain scotol li cꞌustic oy liꞌ ta balumile, pero mu cꞌusi ta xtun o li scꞌulejal li cꞌalal ta xchame. Yuꞌun maꞌuc ta sta o scuxlejal sbatel osil li scꞌulejale, yuꞌun mu stacꞌ sman li scuxlejal sventa sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta xcꞌot scꞌacꞌalil ti chital schiꞌuc stsatsal sjuꞌel li Jtote, joꞌon li coꞌol crixchanoutique. Chischiꞌinic talel li yajꞌangeltaque. Chtal cacꞌanbe stojolic ta jujuntal li cꞌu sba la spasique, mi lec, mi chopol. ");
INSERT INTO tzoSA_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Melel li cꞌusi chacalbeique, oy jayvoꞌoxuc liꞌi ti muc to bu chachamique jaꞌ to mi la avilic ti ta jventainan xa li crixchanoetique, joꞌon li coꞌol crixchanoutique ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Cꞌalal jech laj yal li Jesuse, ta svaquibal to cꞌacꞌal laj yicꞌ batel Pedro, schiꞌuc Jacobo, schiꞌuc Juan, jaꞌ li yitsꞌin Jacoboe, ta jpꞌej toyol vits. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Li Jesuse iyacꞌ xojobal sat ta stojol li oxvoꞌique. Li xojobal sate jaꞌ jech chac cꞌu chaꞌal li xojobal cꞌacꞌale. Xleblun tajmec saquil nojtoc li scꞌuꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jaꞌ o iyilic te Moisés schiꞌuc Elías, te la schiꞌin sbaic ta loꞌil schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Li Pedroe jech laj yalbe li Jesuse: ―Cajval, lec ti liꞌ oyutique. Mi chacꞌane, ta jpascutic oxpꞌej yaxna liꞌi; jpꞌej avuꞌun, jpꞌej yuꞌun Moisés, jpꞌej yuꞌun li Elíase ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cꞌalal yac toꞌox ta loꞌil li Pedroe, ital toc, imaquic ta toc scotolic. Iyacꞌ xojobal li toque. Iyaꞌiic icꞌopoj ta yut toc li Diose, jech laj yal: ―Liꞌi jaꞌ Jnichꞌon ti toj cꞌux ta coꞌone. Ximuybaj noꞌox yuꞌun. Aꞌibeic scꞌop ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cꞌalal iyaꞌiic li oxvoꞌ jchiꞌiltacutic ta yajchanbalajeltac li Jesuse, la spatan sbaic ta balumil. Ixiꞌic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Li Jesuse la stijan liquel, jech laj yalbe: ―Licanic, mu xaxiꞌic ―xut ");
INSERT INTO tzoSA_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cꞌalal la stoy satique, stuc xa noꞌox te vaꞌal iyilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cꞌalal iyalic talel ta jolvitse, jech iꞌalbatic yuꞌun li Jesuse: ―Muc to me buchꞌu xavalbeic li cꞌusi la avilique jaꞌ to mi lichaꞌcuxi loqꞌuel ta jmuquenal, joꞌon li coꞌol crixchanoutique ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Joꞌoncutic li yajchanbalajeltacuncutique jech la jacꞌbecutic li Jesuse: ―¿Cꞌu chaꞌal ta xalic li jchanubtasvanejetic ta smantaltac Dios ti persa baꞌi ta xtal li Elíase, ti tsꞌacal to chatal joꞌote? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Itacꞌav li Jesuse: ―Ta melel jech tsꞌibabil ta scꞌop Dios ti jaꞌ baꞌi ta xtal li Elíase. Yuꞌun chtal yalanbe ti acꞌo yictaic li cꞌustic chopol ta spasic li jchiꞌiltactique. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Joꞌon chacalbeic ti iꞌay xa li Elíase pero muc bu xojtaquinic. Li crixchanoetique la spasbeic li cꞌusi ta scꞌan yoꞌon stuquique, la smilic. Jaꞌ noꞌox jech chismilic eꞌuc, joꞌon li coꞌol crixchanoutique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jech la jnaꞌcutic o ti jaꞌ scꞌoplal Juan li iyacꞌ ta ichꞌel joꞌ li laj yal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cꞌalal lijcꞌotcutic li yoꞌ bu tsobolic li crixchanoetique, te ital jun jchiꞌiltic ta israelal, la squejan sba ta stojol li Jesuse. Jech laj yalbe: ");
INSERT INTO tzoSA_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Cajval, cꞌuxubinbun jnichꞌon yuꞌun snupoj tupꞌ icꞌ. Toj echꞌem chichꞌ vocol. Ep ta velta ta xyal ta cꞌocꞌ schiꞌuc ta xyal ta ucꞌum. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Laj quicꞌ talel ta stojol la avajchanbalajeltaque pero mu xcol yuꞌunic li jnichꞌone ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Li Jesuse jech laj yalbuncutic schiꞌuc li jchiꞌiltactique: ―Toj tsots avoꞌonic, mu xacꞌan xachꞌunic. Oy xa scꞌacꞌalil liꞌ jchiꞌucoxuque, pero muc to bu chcꞌot ta avoꞌonic. Oy xa scꞌacꞌalil la jtsꞌicboxuc li cꞌu abaique. Iqꞌuic talel li quereme ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Li Jesuse la stac loqꞌuel li pucuje, ilocꞌ ta yoꞌon li quereme, icol ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Li joꞌoncutique tsꞌacal to la jacꞌbecutic Jesús ti cꞌalal jtuccutic xae: ―¿Cꞌu chaꞌal ti muc xlocꞌ cuꞌuncutic li pucuje? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Itacꞌav li Jesuse: ―Yuꞌun muc to bu achꞌunojic lec ti joꞌon chajcoltaic ta spasel scotole. Melel li cꞌusi chacalbeique, manchuc mi jutuc noꞌox achꞌunojic ti joꞌon chajcoltaique, mi jaꞌ noꞌox jech chac cꞌu chaꞌal jpꞌej becꞌ mustasae, pero xuꞌ xa chapasic li cꞌustic tsots ta pasele. Jech chac cꞌu chaꞌal mi chavalbeic ti acꞌo locꞌuc li vits liꞌi, jaꞌ chcꞌot ta pasel avuꞌunic. Acꞌo mi jutuc noꞌox achꞌunojic jech chac cꞌu chaꞌal jpꞌej becꞌ mustasae, scotol xa xuꞌ avuꞌunic o. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero li jchop ta pucujetic li la jloqꞌuese, jaꞌ to ta xlocꞌ mi chataic ta naꞌel li Diose schiꞌuc mi chavicta aviximique ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cꞌalal te toꞌox chijxanavcutic ta Galilea balumil schiꞌuc li Jesuse, jech laj yalbuncutic: ―Joꞌon li coꞌol crixchanoutique ta xiꞌaqꞌue ta scꞌob crixchanoetic. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Chismilic, chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xijyutcutic. Cꞌalal icaꞌicutic jeche, toj echꞌem icat coꞌoncutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cꞌalal lijcꞌotcutic ta jteclum Capernaume, te italic jayvoꞌ jtsobtaqꞌuinetic sventa ta xtun li ta mucꞌta chꞌulnae. Jech ijacꞌbat li Pedroe: ―¿Mi ta xacꞌ eꞌuc li chib dracma taqꞌuin la Avajchanubtasvanejique? ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Itacꞌav li Pedroe: ―Ta xacꞌ ―xi. Cꞌalal iꞌoch ta yut na li Pedroe, jaꞌ baꞌi icꞌoponat yuꞌun Jesús. Jech ijacꞌbat: ―¿Cꞌusi chanop, Simón? ¿Buchꞌu ta scꞌanbe taqꞌuin li mucꞌtic ajvaliletic liꞌ ta balumile? ¿Mi jaꞌ ta scꞌanbe li snichꞌnabe, mi yan crixchanoetic ta scꞌanbe? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Itacꞌav li Pedroe: ―Jaꞌ ta scꞌanbe li yan crixchanoetique ―xi. Jech iꞌalbat nojtoc: ―Jech colem ta xcomic li snichꞌnabtaque. Jaꞌ noꞌox jechun eꞌuc li joꞌone, mu persauc ta jtoj ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero yoꞌ mu soc o sjolic ta jtojole, jaꞌ lec batan ta nab, ticꞌo ochel li tsacob choye ta yut nab. Li sba choy chanit loqꞌuele jachꞌbo ye. Te chata jsep estatero taqꞌuin. Ichꞌo talel, acꞌbo li buchꞌutic ta stsobe. Jaꞌ jventa jtaqꞌuintic jchaꞌvaꞌaltic ti chavaqꞌue ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","La jacꞌbecutic Jesús, joꞌoncutic li yajchanbalajeltacuncutique: ―¿Buchꞌu más banquilal ta xcom cuꞌuncutic ti cꞌalal chaꞌoch ta ajvalile? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Li Jesuse iyicꞌ talel jun biqꞌuit querem. La svaꞌan ta oꞌlol li yoꞌ bu oyuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jech laj yalbuncutic: ―Melel li cꞌusi chacalbeique, mi mu xacoꞌoltajes abaic jech chac cꞌu chaꞌal li unetique, mu xuꞌ chaꞌochic li yoꞌ bu ta jpas mantale. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Li buchꞌutic lec chaꞌiic pasel ta mantal jech chac cꞌu chaꞌal li unen liꞌi, jaꞌ banquilal ta xcomic li yoꞌ bu ta jpas mantale. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Li buchꞌutic ti ta jventa joꞌon chichꞌic ta mucꞌ li buchꞌu ti jech yoꞌon jech chac cꞌu chaꞌal li unen liꞌi, joꞌon chiyichꞌic ta mucꞌ yaꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pero li buchꞌu ta socbe yoꞌon junuc li buchꞌutic ti jech yoꞌonic jech chac cꞌu chaꞌal li unetic ti schꞌunojic ti joꞌon Yajcoltavanejicune, jaꞌ lec acꞌo chucbatuc jun choꞌ ta snucꞌ, acꞌo jipeuc ochel ta nab, acꞌo chamuc o. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Joꞌoxuc li liꞌ to oyoxuc ta balumile, abol abaic yuꞌun oy ep buchꞌutic tscꞌan chasocboxuc avoꞌonic. Ta melel ta onoꞌox xavaꞌiic ti xuꞌ ta soc avoꞌonic ta scojique. Pero toj abol sbaic li buchꞌutic jech ta spasique. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mi ta scoj noꞌox avoc acꞌobic ti chata o amulique, muc bu lec. Scꞌan ti chapajese jech chaꞌochic o ta vinajel. Abol abaic mi ta scoj noꞌox avoc acꞌobic ti chabatic o ta mucꞌta cꞌocꞌ sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jech nojtoc mi ta scoj noꞌox asatic ti chata o amulique, muc bu lec. Scꞌan ti chapajes abaique jech chaꞌochic o ta vinajel. Abol abaic mi ta scoj noꞌox asatic ti chabatic o ta mucꞌta cꞌocꞌ sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Qꞌuelo me abaic, mu me xapꞌajic junuc li unetic ti laj cale yuꞌun chabibilic yuꞌun li yajꞌangeltac Diose. Melel li cꞌusi chacalbeique, li ángeletic li ta xchabivanique scotol ora chcꞌot scꞌoponic li Jtot ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yuꞌun joꞌon li coꞌol crixchanoutique tal jcoltaoxuc acotolic yuꞌun chꞌayemoxuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Cꞌusi chanopic? Mi oy jun vinic ti oy joꞌvinic (100) ta cot schije, pero mi ichꞌay comel jcotuque, ¿mi mu teuc lamal chicta li balunlajuneb yoꞌvinic (99) ta cote yoꞌ chba saꞌ li jcot ti ichꞌaye? ");
INSERT INTO tzoSA_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Melel li cꞌusi chacalbeique, cꞌalal mi la sta li jcote, xmuybaj xa yuꞌun tsꞌacal xa li schije. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jaꞌ noꞌox jech eꞌuc li Jtot ta vinajele, mu scꞌan ti ta xchꞌay junuc li unetic li laj cale. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Mi oy ista smul ta atojol jun li buchꞌu coꞌol avichꞌojicun ta muqꞌue, ba meltsano acꞌopic atuquic. Mi chacꞌ ta ventae, jech lec chacomic schiꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mi mu xacꞌ ta venta la acꞌope, icꞌo batel jun chaꞌvoꞌuc achiꞌil yuꞌun jaꞌ avajtextico ta sventa li cꞌusi chavalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mi mu xacꞌbe ta venta nojtoc li scꞌopique, albo ta stojol scotol li buchꞌutic yichꞌojicun ta mucꞌ li cꞌalal chatsob abaique. Mi mu schꞌun li cꞌusi chavalic acotolique, acꞌo comuc jech chac cꞌu chaꞌal yan crixchano, jech chac cꞌu chaꞌal li jtsobpatanetic ti muc bu yichꞌojic ta mucꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Melel li cꞌusi chacalbeique, li buchꞌutic ti mu xictaic li cꞌustic chopol tspasique, albeic ti oy smulic ta xꞌileic yuꞌun li Diose. Pero li buchꞌutic ti laj xa yictaic li cꞌustic chopol tspasique, albeic ti muꞌyuc xa smulic ta xꞌileic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Chacalbeic nojtoc, mi oy chaꞌvoꞌoxuc ti jmoj avoꞌonic chataic ta naꞌel li Jtot ta vinajele, scotol li cꞌustic chacꞌanbeique chayacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yuꞌun mi oy atsoboj abaic chaꞌvoꞌ oxvoꞌuc, joꞌoxuc ti avichꞌojicun ta muqꞌue, te oyun ta oꞌlol li yoꞌ bu oyoxuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Li Pedroe jech la sjacꞌbe li Jesuse: ―Cajval, ¿jayten scꞌan ta jpasbe perton mi oy la sta smul ta jtojol jun jchiꞌile? ¿Mi jucten noꞌox nan? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Itacꞌav li Jesuse: ―Muc bu chacalbe mi jucten noꞌox. Mu atbiluc noꞌox ti jayten scꞌan chapasbe pertone. Jaꞌ scꞌan ti scotol cꞌacꞌal chapasbe pertone. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Chacalbeic cꞌu sba ta spas mantal li Diose. Jaꞌ jech chac cꞌu chaꞌal jun ajvalil ti oy qꞌuexbil staqꞌuin yuꞌun li yajꞌabteltaque. Pero li ajvalile tscꞌan ti acꞌo sutesbatuque, jaꞌ yuꞌun la stacan ta iqꞌuel li buchꞌutic oy sqꞌuexe. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cꞌalal lic scꞌoponan li buchꞌutic oy sqꞌuexe, ital li buchꞌu oy lajunmil sqꞌuexe. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Li vinique mu xa sut yuꞌun. Jaꞌ yuꞌun li ajvalile laj yal mantal ti acꞌo choneuc ta jtunel scotolic schiꞌuc yajnil schiꞌuc snichꞌnabe, schiꞌuc scotol li cꞌustic oy yuꞌune, yoꞌ jaꞌ chtoj o li sqꞌuexe. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Cꞌalal iyaꞌi li vinique, la squejan sba ta stojol li ajvalile, jech laj yalbe: “Ajvalil, avocoluc malabun to li jqꞌuexe. Chajsutesbe scotol”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Icꞌuxubinat yuꞌun li ajvalile, ichꞌaybat scotol li sqꞌuexe, icoltaat batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ilocꞌ batel li vinique. Te isnup ta be jun schiꞌil ta abtel. Oy qꞌuexbil joꞌvinic (100) staqꞌuin eꞌuc. La stsac li schiꞌile, la smichꞌbe ta snucꞌ, jech laj yalbe: “Sutesbun ta ora la aqꞌuexe”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Li schiꞌil ta abtele la squejan sba ta stojol, jech laj yalbe: “Avocoluc malabun to li jqꞌuexe, chajsutesbe scotol”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero mu xa smala. Ba sticꞌ ta chuquel. Jech laj yalbe comel li jchabiejchucvanabe: “Jaꞌ to xaloqꞌuesbun mi la sutesbun scotol li sqꞌuexe”, xut comel. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cꞌalal iyilic li yan schiꞌiltac ta abtel ti la sticꞌ ta chuquel li schiꞌile, chopol iyilic. Ba yalbeic ta ora li ajvalil li cꞌusi la spas li buchꞌu ep toꞌox yile. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Li ajvalile la stac ta iqꞌuel li buchꞌu ep toꞌox yile, jech laj yalbe: “Toj chopolot. Li joꞌote la acꞌanbun vocol jech la jchꞌaybot scotol la aqꞌuexe. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Cꞌu chaꞌal muc xacꞌuxubin eꞌuc la achiꞌile jech chac cꞌu chaꞌal la jcꞌuxubinote?” xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Iꞌilin o li ajvalile. Laj yacꞌbe ta scꞌob li buchꞌutic ta xchucvanique. Jech laj yalbe: “Jaꞌ to xaloqꞌuesic batel mi la sutesbun scotol li sqꞌuexe”, xut comel li jchucvanejetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Li joꞌoxuque jaꞌ noꞌox jech chaspasbeic eꞌuc li Jtot ta vinajele mi mu ta sloqꞌueluc avoꞌonic chapasbeic perton la achiꞌilique ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cꞌalal ilaj yoꞌon ta scꞌoponeluncutic li Jesuse, ilocꞌ batel ta Galilea balumil. La jchiꞌincutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Te lijcꞌotcutic ta Judea balumil ta jot ucꞌum Jordán. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ep jchiꞌiltactic te tijilic batel schiꞌuc ep jchamelajeletic. Li Jesuse la scoltaanbe schamelic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Te italic ta stojol Jesús jayvoꞌ jfariseoetic yuꞌun tal sqꞌuelbeic yoꞌon li cꞌu sba chtacꞌav li Jesuse. Jech la sjacꞌbeic: ―¿Mi xuꞌ ta xquictacutic o cajnilcutic ti cꞌusiuc noꞌox smul tstae? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Itacꞌav li Jesuse: ―Aqꞌuelojic xa ta scꞌop Dios li bu ta xal li cꞌalal ipase yuꞌun Dios li sba vinique, jun vinic schiꞌuc jun ants ipase. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Schiꞌuc aqꞌuelojic ti jech yaloj Dios: “Li queremutique ta svocꞌ sbaic schiꞌuc stot smeꞌic li cꞌalal tsaꞌ li yajnilique. Li chaꞌvoꞌique jun xa chcꞌotic”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaꞌ yuꞌun mu xa chaꞌvoꞌicuc, junic xa. Li buchꞌutic junic xa yuꞌun li Diose, mu xuꞌ ta xicta sbaic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","La sjacꞌbeic nojtoc li Jesuse: ―¿Cꞌu chaꞌal jech laj yal mantal li Moisés ta voꞌonee: “Li buchꞌu chicta yajnile, acꞌo smeltsanbe sjunal ti yictaoj xa sbaique, acꞌo yacꞌbe ta scꞌob li yajnile, jaꞌ to jech xuꞌ chicta sbaic”, xi li Moisese? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Itacꞌav li Jesuse: ―Jaꞌ ta scoj ti toj tsots yoꞌonic li jtotic jmeꞌtic ta voꞌone ti jech laj yal mantal li Moisese. Ta sliqueb balumile muc bu jech. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero joꞌon chacalbeic, li buchꞌu ta xicta yajnile, mi maꞌuc ta scoj ti la saꞌ svinical ti chicta oe, mi chicꞌ yan antse, chmulivaj. Schiꞌuc nojtoc li buchꞌu chicꞌ li sutem antse chmulivaj nojtoc ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Joꞌoncutic li yajchanbalajeltacuncutique jech laj calbecutic li Jesuse: ―Mi jech scꞌoplal li buchꞌu oy yajnile, jaꞌ lec ti mu jsaꞌ cajnilcutique ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Itacꞌav li Jesuse: ―Mu acotolicuc xcuch avuꞌunic ti muc bu chasaꞌ avajnilique. Jaꞌ noꞌox ta xcuch yuꞌunic li buchꞌutic jech ch‐acꞌbat snaꞌic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oy viniquetic ti stalelic onoꞌox ti jech yoꞌonic ti mu saꞌ yajnilique. Oy viniquetic ti pasbilic ta capone. Oy viniquetic ti mu saꞌ yajnilique yoꞌ jech más xuꞌ ta spasic li cꞌustic tscꞌan li Diose. Li buchꞌutic jech tsnopique, mi chaꞌiic ti jech ta scꞌan li Diose, acꞌo me spasic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iꞌicꞌbat talel unetic ta stojol li Jesuse yoꞌ acꞌo yacꞌanbe scꞌob ta sjolic schiꞌuc acꞌo scꞌoponbe Dios ta stojolic. Joꞌoncutic li yajchanbalajeltacuncutique chopol icaꞌicutic. La jpajescutic li buchꞌutic laj yiqꞌuic talel li unetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero li Jesuse jech laj yalbuncutic: ―Acꞌo talicuc ta jtojol li unetique, mu me xapajesic. Yuꞌun li buchꞌutic jaꞌ jechic jech chac cꞌu chaꞌal li unetique lec to chaꞌiic pasel ta mantal yuꞌun li Diose ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cꞌalal laj yacꞌanbe o scꞌob ta sjolic li unetic li Jesuse, lijlocꞌcutic batel jchiꞌucutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oy jun vinic tal scꞌopon li Jesuse, jaꞌ jchiꞌiltic ta israelal. Jech la sjacꞌbe li Jesuse: ―Lequil jchanubtasvanej, ¿cꞌusi ti lec ta jpase ti yoꞌ jech chicuxi o sbatel osile? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Itacꞌav li Jesuse: ―Muc buchꞌu junuc lec, jaꞌ noꞌox li Diose. Jaꞌ yuꞌun ¿cꞌu chaꞌal chavalbun ti lequil jchanubtasvanejune? Mi chacꞌan chacuxi sbatel osile, scꞌan chachꞌun li smantaltac li Diose ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jech la sjacꞌ li vinique: ―¿Cꞌustic mantalil ti scꞌan ta jchꞌune? ―xi. Itacꞌav li Jesuse: ―“Mu me xamilvan. Mu me xamulivaj. Mu me xaꞌelcꞌaj. Mu me xasaꞌbe smul achiꞌil. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ichꞌo ta mucꞌ atot ameꞌ. Cꞌuxubino achiꞌiltac jech chac cꞌu chaꞌal cꞌux chavaꞌi aba atuque”, xi li mantale ―xꞌute yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Itacꞌav li vinique: ―Scotol li cꞌustic la avale ta jbicꞌtal onoꞌox lic jchꞌun. ¿Cꞌusi yan scꞌan ta jchꞌun? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Itacꞌav li Jesuse: ―Mi chacꞌan ti lec chayil li Diose, ba chono scotol li cꞌustic oy avuꞌune. Li stojole qꞌuelananbo li meꞌonetique jaꞌ oy o acꞌulejal ta vinajel. Tsꞌacal to xtal achiꞌinun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cꞌalal iyaꞌi jech li vinique, iyat tajmec yoꞌon li cꞌalal isut batele yuꞌun toj ep cꞌustic oy yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Li Jesuse jech laj yalbuncutic: ―Melel li cꞌusi chacalbeique, li jcꞌulejetique toj vocol chacꞌ sbaic ta scꞌob li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chacalbeic nojtoc, jech chac cꞌu chaꞌal mu xjelav jcot cameyo ta chac acuxae, jaꞌ noꞌox jech mu xuꞌ ta xꞌoch li yoꞌ bu ta spas mantal Dios li buchꞌutic jaꞌ noj batem ta yoꞌonic li scꞌulejalique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cꞌalal jech laj caꞌicutic, joꞌoncutic li yajchanbalajeltacuncutique, toj chꞌayel noꞌox coꞌoncutic. Jech laj calcutic: ―Mi mu xcolic li jcꞌulejetique, ¿buchꞌu ma ti chcol yaꞌele chaꞌa? ―xijchicutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Li Jesuse isqꞌuel jsatcutic. Jech laj yalbuncutic: ―Li crixchanoetique mu xuꞌ ta scolta sba stuquic sventa sbatel osil. Jaꞌ noꞌox xuꞌ ta xcolic ta sventa li Diose, yuꞌun scotol xuꞌ yuꞌun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Li Pedroe la stacꞌbe li Jesuse: ―Li joꞌoncutique laj xa quictacutic scotol li cꞌustic oy toꞌox cuꞌuncutique. Liꞌ xa jchiꞌucotcutique. ¿Cꞌusi ta xquichꞌcutic li joꞌoncutique chaꞌa? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Li Jesuse jech laj yalbuncutic: ―Melel li cꞌusi chacalbeique, cꞌalal ta xcꞌot scꞌacꞌalil ti ta jtuqꞌuibtas li balumile, te chjul chotlucun ta jmucꞌta chotleb yuꞌun joꞌon ta jpas ta mantal scotol, joꞌon li coꞌol crixchanoutique. Scotol crixchanoetic chiyichꞌic ta mucꞌ. Joꞌoxuc ti la achiꞌinicune ta jchiꞌin jbatic ta pasmantal. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Li buchꞌutic laj xa yicta snaique, mi sbanquiltac, mi yitsꞌinabtac, mi svixobtac, mi yixleltac, mi smucobtac, mi stot, mi smeꞌ, mi snichꞌnab, mi yosil, ta jventa joꞌone, ta stabe más sqꞌuexol li cꞌustic oy toꞌox yuꞌune. Schiꞌuc ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero li buchꞌutic banquilal spꞌisoj sbaic li avie jaꞌ itsꞌinal chcomic yuꞌun la stoy sbaic. Yan li buchꞌutic itsꞌinal ta xꞌileic li avie jaꞌ banquilal chcomic yuꞌun la sbicꞌtajes sbaic. Ep li buchꞌutic itsꞌinal ta xcomique; ep nojtoc li buchꞌutic banquilal ta xcomique ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Li Jesuse jech laj yalbuncutic nojtoc: ―Chacalbeic li cꞌu sba ta spas mantal li Diose. Jaꞌ jech chac cꞌu chaꞌal jun vinic ti stsꞌunoj ep tsꞌusube. Sob ilocꞌ batel, ba saꞌ talel svinictac ta abtel. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cꞌalal la sta li svinictaque, laj yalbe ti ta stoj jun denario taqꞌuin ta cꞌacꞌale. La stac batel li ta tsꞌusubtique. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cꞌalal ista baluneb orae, ilocꞌ batel nojtoc li yajval tsꞌusubtique. Te vaꞌalic ista viniquetic ta chꞌivit ti muꞌyuc yabtelique. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jech laj yalbe: “Batanic ta cabtel te ta tsꞌusubtic. Chajtojic ti cꞌu yepal chapasique”, xut. Li viniquetique la schꞌunic, ibatic ta abtel. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ichaꞌlocꞌ batel nojtoc ta oꞌlol cꞌacꞌal yuꞌun ba saꞌ talel yan svinictac ta abtel. Ilocꞌ nojtoc ta oxib ora ta mal cꞌacꞌal. Jaꞌ noꞌox jech ispas jujun velta. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ilocꞌ batel nojtoc ta joꞌob ora ta mal cꞌacꞌal. Te la sta viniquetic ti muꞌyuc yabtelique. Jech laj yalbe: “¿Cꞌu chaꞌal liꞌ xavaꞌetic sjunul cꞌacꞌale?” xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Itacꞌavic: “Yuꞌun muc buchꞌu xijyicꞌuncutic ta abtel”, xiic. Jech laj yalbe: “Batanic ta cabtel te ta tsꞌusubtic. Chajtojic ti cꞌu yepal chapasique”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cꞌalal ibat xaꞌox cꞌacꞌale, jech laj yalbe li yajqꞌuelꞌabtele: “Icꞌano sutel talel scotol li jvinictac ta abtele, acꞌbo stojolic. Jaꞌ baꞌi xlaj atojan li buchꞌutic tsꞌacal italique. Tsꞌacal to xavacꞌanbe stojol li buchꞌutic baꞌi italique”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jaꞌ baꞌi italic li buchꞌutic ta joꞌob xa ora la stsac yabtelique. Ta jujun denario taqꞌuin itojeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cꞌalal ital li buchꞌutic baꞌi la stsac yabtelique, la snopic ti jaꞌ más ta xtojeique pero parejo itojeic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cꞌalal laj yichꞌ stojolic li buchꞌutic sob iꞌochic ta abtele, iꞌilinic ta stojol li yajval abtele. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jech laj yalbeic li yajval abtele: “Jun xa noꞌox ora iꞌabtejic li buchꞌutic tsꞌacal xa italique, pero parejo la atojuncutic. Li joꞌoncutique sjunul cꞌacꞌal lijꞌabtejcutic. Toj cꞌux cꞌacꞌal icaꞌicutic. Lijlubcutic tajmec”, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Itacꞌav li yajval abtele: “Muc bu chopol li cꞌusi la jpasboxuque. Yuꞌun baꞌi laj caltic ti ta jun denario taqꞌuin chajtojic ta cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ichꞌo batel la atojolique, batanic. Yuꞌun jech la jcꞌan ti parejo chajtojic acotolique. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Xuꞌ ta jpas li cꞌusi ta jcꞌan schiꞌuc li cꞌusi oy cuꞌune. Mu me xtiꞌetuc o avoꞌonic ta sventa li cꞌusi lec la jpase”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Li cꞌu sba la spasbe li svinictac ta abtele, jaꞌ noꞌox jech ta spasbatic eꞌuc li buchꞌutic ta xꞌabtejic cuꞌun liꞌ ta balumile. Li buchꞌutic itsꞌinal ta xꞌileic li avie, jaꞌ banquilal chcomic yuꞌun la sbicꞌtajes sbaic. Li buchꞌutic banquilal spꞌisoj sbaic li avie jaꞌ itsꞌinal chcomic yuꞌun la stoy sbaic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cꞌalal te yacuncutic ta xanbal batel ta sbelel Jerusalén schiꞌuc Jesús, joꞌoncutic li yajchanbalajeltacuncutique, laj yicꞌuncutic loqꞌuel jutuc ta tiꞌbe, jech laj yalbuncutic: ");
INSERT INTO tzoSA_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Xanaꞌic ti te chijbat ta Jerusalene. Joꞌon li coꞌol crixchanoutique te chiꞌaqꞌue ta scꞌob li banquilal paleetique schiꞌuc ta scꞌob li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Te chalic ti chiyaqꞌuic ta milele. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chiyaqꞌuic ta scꞌob li buchꞌutic maꞌuc jchiꞌiltactic ta israelale. Chisnaꞌleic, chistsitsic. Ta tsꞌacale chisjocꞌanic ta cruz, te chicham. Chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Italic ta stojol Jesús schiꞌuc smeꞌic li chaꞌvoꞌ jchiꞌiltacutic ta yajchanbalajeltac li Jesuse, jaꞌ li Jacobo schiꞌuc li Juane. Zebedeo sbi li stotique. Li smeꞌique la squejan sba ta stojol li Jesuse yuꞌun oy cꞌusi ta scꞌanbe. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jech ijacꞌbat yuꞌun li Jesuse: ―¿Cꞌusi chacꞌan? ―xut. Itacꞌav li meꞌile: ―Alo jpꞌeluc amantal ti coꞌol chachotiic schiꞌuc li chaꞌvoꞌ cole, jun ta abatsꞌicꞌob, jun ta atsꞌet, li cꞌalal ta xcꞌot scꞌacꞌalil ti chtal apas mantale ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Itacꞌav li Jesuse: ―Mu xanaꞌic cꞌu sba svocolal li cꞌusi chacꞌanbecune. ¿Mi xcuch avuꞌunic li at‐oꞌone, li vocole, li milele, jech chac cꞌu chaꞌal ta xquichꞌe? ―xi li Jesuse. Itacꞌavic: ―Xuꞌ cuꞌuncutic ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jech laj yal nojtoc li Jesuse: ―Melel chavichꞌic vocol jech chac cꞌu chaꞌal ta xquichꞌe. Pero ti chacꞌan chachotiic jun ta jbatsꞌicꞌobe, jun ta jtsꞌete, joꞌone mu xuꞌ chacalbeic. Jaꞌ ta xal stuc li Jtot ti buchꞌutic te ta xchotiique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cꞌalal laj caꞌicutic li cꞌusi laj yalic li chaꞌvoꞌ jchiꞌilcutique, li lajunvoꞌuncutique chopol icaꞌicutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Li Jesuse laj yicꞌuncutic jcotolcutic, jech laj yalbuncutic: ―Xanaꞌic cꞌu sba ta spasic li ajvaliletic yuꞌunic li jyanlumal crixchanoetique. Jaꞌ noꞌox ta spasic mantal. Jech nojtoc li buchꞌutic acꞌbil yabtelic yuꞌun li ajvalile jaꞌ noꞌox ta sujvanic ta abtel. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Pero li joꞌoxuque mu me xapasic jech. Li buchꞌu junucal avuꞌunic ti tscꞌan chcom ta banquilal avuꞌunique, ti tscꞌan ichꞌbil ta muqꞌue, acꞌo sbicꞌtajes sba ta atojolic, acꞌo tunuc avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jech chac cꞌu chaꞌal joꞌon li coꞌol crixchanoutique, muc bu tal pasvancun ta mantal. Ti litale, yuꞌun tal tuncun yuꞌun scotol li crixchanoetique. Tal cacꞌ jba ta milel ta scojic yoꞌ jech chcolic o sbatel osil ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cꞌalal lijlocꞌcutic batel ta jteclum Jericó schiꞌuc li Jesuse, te tijilic batel ep jchiꞌiltactic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te chotolic ta tiꞌbe chaꞌvoꞌ jchiꞌiltic ta israelal, jaꞌ maꞌsatetic. Cꞌalal iyaꞌiic ti te ch‐echꞌ li Jesuse, laj yaptaic: ―¡Cajval, joꞌot snitilulot David ti scꞌoplal onoꞌox chaꞌoch ta ajvalilal cuꞌuncutique, ichꞌuncutic ta cꞌux! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pero li yan jchiꞌiltactique la spajesic. ―¡Anchanic! ―xutic. Pero más to tsots icꞌopojic: ―¡Cajval, joꞌot snitilulot David, ichꞌuncutic ta cꞌux! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ivaꞌi li Jesuse. Iꞌalbatic ti acꞌo talicuc ta stojole. Jech la sjacꞌbe: ―¿Cꞌusi chacꞌanic chajpasbeic? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Itacꞌavic: ―Cajval, avocoluc jambun li jsatcutique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Li Jesuse la scꞌuxubinan, la spicanbe satic. Ijam ta ora li satique. La schiꞌinic batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cꞌalal nopol xa xijbatcutic ta Jerusalene, te lijcꞌotcutic ta nopol Betfajé te ta yoc vits Olivatic. Li Jesuse la stac batel chaꞌvoꞌ jchiꞌilcutic ta yajchanbalajeltac. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Laj yalbe echꞌel: ―Batanic leꞌ ta coloniae. Te chucul chataic jcot meꞌburro schiꞌuc jcot yol. Jitunic, nitic talel. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi oy buchꞌu chasjacꞌbeic ti cꞌu chaꞌal chajitunic li burroe, albeic: “Yuꞌun ta xtun yuꞌun li Cajvaltique”, utic, jech chayacꞌboxuc talel ―xꞌutatic batel yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Scotol jech icꞌot ta pasel yuꞌun jaꞌ icꞌot ta pasel li cꞌusi laj yal li buchꞌu iyal scꞌop Dios ta voꞌonee. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Albo li buchꞌutic ti jaꞌ steclumalic li Jerusalene: “Ta xtal li ajvalil avuꞌunique. Lec noꞌox yoꞌon, mu snaꞌ stoy sba. Cajal ta burro chtal, jaꞌ yol jꞌicatsnom meꞌburro”, uto, xiyut li Diose, xi onoꞌox laj yal li buchꞌu iyal scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ibatic li chaꞌvoꞌique, jaꞌ ischꞌunic li cꞌusi iꞌalbatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","La snitic talel schiꞌuc yol li meꞌburroe. Laj yacꞌbeic spuychijic sventa staspat. La scajlebin li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ep buchꞌutic la sqꞌuianic spuychijic ta be li bu ch‐echꞌ ba li Jesuse. Oy yanetic la scꞌasic yanal teꞌ, la slamanic ta be yuꞌun chichꞌic ta mucꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Li buchꞌutic sbabe batele schiꞌuc li buchꞌutic tijilic talele, tsots icꞌopojic scotolic, jech laj yalic: ―¡Acꞌo quichꞌtic ta mucꞌ li snitilul li David ti tal ochuc ta ajvalilal cuꞌuntique! ¡Toj lec li buchꞌu tacbil talel yuꞌun li Cajvaltic Diose! ¡Acꞌo acꞌbatuc más slequilal yutsilal Dios! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cꞌalal iꞌoch batel ta Jerusalén li Jesuse, xꞌupꞌetic tajmec scotol li jchiꞌiltactique. Jech la sjaqꞌuic: ―¿Buchꞌu leꞌe? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Itacꞌavic li jchiꞌiltactic ti schiꞌuquic talel li Jesuse: ―Jaꞌ Jesús. Jaꞌ li buchꞌu ta xal scꞌop Dios li te liquem talel ta Nazaret ta Galilea balumile ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Li Jesuse te icꞌot ta yamaqꞌuil li mucꞌta chꞌulna ta Jerusalene. Te jchiꞌucutic cꞌotel, joꞌoncutic li yajchanbalajeltacuncutique. La snutsan loqꞌuel scotol li jpꞌolmaletic schiꞌuc li jmanolajeletic li te ta yamaqꞌuil li mucꞌta chꞌulnae. La svalcꞌunbe smexaic li jeltaqꞌuinetique. La sbutqꞌuinbe xilaic li jchon jculajteꞌetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jech laj yalbe: ―Jech tsꞌibabil ta scꞌop Dios: “Li jnae jaꞌ snail li bu chataicun ta naꞌele”, xi li Diose. Pero li joꞌoxuque apasic xa ta snailchꞌen jꞌeleqꞌuetic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Li te ta yamaqꞌuil li mucꞌta chꞌulnae italic ta stojol Jesús maꞌsatetic schiꞌuc coxoetic. Icol yuꞌun scotol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Te oyic jayvoꞌ banquilal paleetic schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Iyilic li cꞌustic la spas li Jesuse, schiꞌuc iyaꞌiic ti tsots chcꞌopojic li bicꞌtal queremutique ti jech chalulanique: “Acꞌo quichꞌtic ta mucꞌ li snitilul David li tal ochuc ta ajvalilal cuꞌuntique”, xiic. Iꞌilinic o. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jech tal sjacꞌbeic li Jesuse: ―¿Mi chavaꞌi li cꞌusi chalic li bicꞌtal queremutique? ―xutic. Itacꞌav li Jesuse: ―Xcabin. Aqꞌuelojic ti jech tsꞌibabil ta scꞌop li Diose: Li unetique jaꞌ más lec ta xalic acꞌoplal, xi onoꞌox tsꞌibabil. Jaꞌ yuꞌun jech icꞌot ta pasel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ilocꞌ batel li Jesuse. Lijbatcutic ta biqꞌuit jteclum Betania. Jaꞌ te vayal lijcꞌotcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sob ta yocꞌomal lijchaꞌbatcutic nojtoc li ta Jerusalén schiꞌuc li Jesuse. Cꞌalal te xijbatcutic ta bee, ilic sviꞌnal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iyil ti oy jtecꞌ higo ta nopol tiꞌbee. Ba sqꞌuel mi oy sat. Pero muꞌyuc sat ista, jaꞌ noꞌox oy yanal. Li Jesuse jech laj yalbe comel li teꞌel higoe: ―Muc xa bu chasatin o ―xut. Itaquij ta ora li teꞌel higoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cꞌalal iquilcutic, joꞌoncutic li yajchanbalajeltacuncutique, toj chꞌayel noꞌox coꞌoncutic. Jech laj calcutic: ―¿Cꞌu chaꞌal ti itaquij ta ora li teꞌel higoe? ―xijchicutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Li Jesuse jech laj yalbuncutic: ―Melel li cꞌusi chacalbeique, mi chachꞌunic ti joꞌon chajcoltaique, maꞌuc noꞌox xuꞌ chapasic jech chac cꞌu chaꞌal la jpasbe li jtecꞌ higoe, jaꞌ chapasic li cꞌustic vocol ta pasel ti mu xuꞌ avuꞌunic atuquique. Jech chac cꞌu chaꞌal mi chavalbeic li vits liꞌi ti acꞌo qꞌuejuque, ti acꞌo sjip sba ochel ta nabe, ta spas avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Scotol li cꞌusi chacꞌanbeic li Diose, chꞌunic ti chayacꞌbeique, jech chataic o scotol ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cꞌalal lijcꞌotcutic ta mucꞌta chꞌulna li te ta Jerusalene, lic chanubtasvanuc ta yamaqꞌuil mucꞌta chꞌulna li Jesuse. Te italic eꞌuc li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuntique. Jech la sjacꞌbeic: ―¿Buchꞌu laj yacꞌbot ajuꞌel yoꞌ chapas li cꞌustic chapase? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Itacꞌav li Jesuse: ―Oy cꞌusi chajacꞌbeic eꞌuc. Mi chavalbecun li cꞌusi chajacꞌbeique, chacalbeic eꞌuc ti buchꞌu liyacꞌbe juꞌel ti jech ta jpase. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Li ichꞌ joꞌ ti iyacꞌ li Juane, ¿buchꞌu iꞌacꞌbat yabtel ti jech la spase? ¿Mi jaꞌ Dios iꞌacꞌbat, mi crixchano noꞌox iꞌacꞌbat? ―xut. Te lic yalulanbe sbaic: ―Mi chcaltic ti jaꞌ iꞌacꞌbat yabtel yuꞌun li Diose, jech chijyalbutic: “¿Cꞌu chaꞌal muc bu xachꞌunic chaꞌa?” xijyututic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mi icaltic ti iꞌacꞌbat yuꞌun crixchanoe, pero chijxiꞌutic yuꞌun li jchiꞌiltactique yuꞌun scotolic schꞌunojic ti jaꞌ iyal scꞌop Dios li Juane ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jech la stacꞌbeic li Jesuse: ―Mu jnaꞌcutic ―xiic. Jech iꞌalbatic yuꞌun li Jesuse: ―Jaꞌ jechun eꞌuc, muc bu chacalbeic ti buchꞌu liyacꞌbe juꞌel ti jech ta jpase. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Cꞌusi chanopic? Oy jun vinic oy chaꞌvoꞌ snichꞌnab. Li june jech laj yalbe: “Jnichꞌon, batan ta abtel li ta jtsꞌusubtique”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Itacꞌav li snichꞌone: “Mu jcꞌan xibat”, xi. Pero tsꞌacal to isnop ti ta xbate, ibat. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","La scꞌopon li jun snichꞌone. Jaꞌ noꞌox jech iyalbe jech chac cꞌu chaꞌal iyalbe li june. Itacꞌav li snichꞌone: “Xuꞌuc, tata, chibat”, xi. Pero muc bu xbat. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Li joꞌoxuque ¿cꞌusi chanopic? Li chaꞌvoꞌ queremutique ¿buchꞌu junucal la schꞌunbe smantal li stotique? ―xut. Itacꞌavic: ―Jaꞌ li buchꞌu baꞌi iꞌalbate ―xiic. Li Jesuse jech laj yal: ―Melel li cꞌusi chacalbeique, li buchꞌutic ti chavalic ti mu schꞌunbeic smantaltac li Diose, jaꞌ li jtsobpatanetique schiꞌuc li jmulivajel antsetique, jaꞌ chacꞌ xa sbaic ta scꞌob li Diose. Li joꞌoxuque mu xacꞌanic ventainel yuꞌun Dios. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti ital ta atojolic li Juan li iyacꞌ ta ichꞌel joꞌe, jaꞌ tal yalboxuc li cꞌusi scꞌan ti chapasique, pero muc bu xachꞌunic. Yan li jtsobpatanetique schiꞌuc li jmulivajel antsetique, jaꞌ ischꞌunic, laj yictaic li cꞌustic chopol tspasique. Cꞌalal avilic ti laj yictaic spasel li cꞌustic chopole, muc bu xavictaic eꞌuc li joꞌoxuque. Muc bu xachꞌunic o. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Aꞌiic yan loꞌil ti chacalbeique. Oy jun vinic la stsꞌun ep tsꞌusub ta yosil. La sjoy ta moc li tsꞌusubtique. La sjom ton jaꞌ yav sventa spitsꞌobil yaꞌlel li sat tsꞌusube. La spas jun toyol sqꞌuelobil osil. La saꞌbe comel yajval buchꞌutic ta schabiic li tsꞌusubtique. Ibat ta nom li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Cꞌalal ista yora ta xtaꞌaj li sat tsꞌusube, la stac batel yajtuneltac yuꞌun ba yichꞌic talel li cꞌu onoꞌox yepal yaloj chichꞌe. Cꞌot scꞌanbeic li buchꞌutic ta schabiique. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero li jchabiejtsꞌusubtique la stsaquic li yajtuneltac li yajval osile. Li june la smajic, li june la smilic, li june laj yacꞌbeic ton. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Li yajval osile la stac batel yan yajtuneltac nojtoc, jaꞌ to más ep la stac batel. Pero jaꞌ noꞌox jech la spasbeic nojtoc jech chac cꞌu chaꞌal la spasbeic li buchꞌutic baꞌi itaqueic batele. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Tsꞌacal to la stac batel li snichꞌone. Jech la snop li yajval osile: “Jaꞌ nan ch‐aqꞌue ta venta li jnichꞌone”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero cꞌalal iyilic li jchabiejtsꞌusubtic ti jaꞌ xa snichꞌon li yajval osile, jech laj yalbe sbaic: “Leꞌe jaꞌ chichꞌbe comel li yosil li stote. Jaꞌ lec ta jmiltic yoꞌ jech joꞌotic chquichꞌbetic o comel li yosile”, xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","La stsaquic, la sloqꞌuesic ta pat moc, te la smilic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cꞌalal ta sut talel li yajval tsꞌusubtique, ¿cꞌusi chjul spasbe xanaꞌic li jchabiejtsꞌusubtique? ―xut li jꞌabteletic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Itacꞌavic: ―Ta xmileic yuꞌun toj chopol li cꞌusi la spasique. Li yajval osile yan xa o buchꞌutic chacꞌbe schabiic li tsꞌusubtique. Jaꞌ ta saꞌ li buchꞌutic lec chaqꞌuic ta cꞌabal li sat tsꞌusube ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Li Jesuse jech laj yalbe nojtoc: ―Aqꞌuelojic li cꞌusi chal li scꞌop Diose: Jech chac cꞌu chaꞌal li yajval na ti la stꞌuj jpꞌej ton sventa ta xacꞌ ta chiquin nae, pero li svinictac ta vaꞌanejnae mu scꞌanic. Li ton li la spꞌajique jaꞌ onoꞌox iꞌoch ta chiquin na. Jaꞌ noꞌox jech eꞌuc li buchꞌu tꞌujbil yuꞌun li Diose, acꞌo mi mu xcꞌanee, pero ta onoꞌox xꞌacꞌbat tsots yabtel. Toj lec ti jech ta spas li Diose, xi tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chacalbeic, li joꞌoxuque ilaj xa scꞌoplal ti chasventainic li Diose. Jaꞌ xa ta xventainatic li buchꞌutic ta spasic li cꞌustic ta scꞌan li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Li buchꞌutic chopol chiyilique, jaꞌ chopol chbatic o. Ta onoꞌox xquichꞌbe scꞌopic. Mi ical ti ta chꞌayel chbatique, ta xchꞌayic o sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cꞌalal iyaꞌiic li cꞌusi laj yal ta loꞌil li Jesús li banquilal paleetic schiꞌuc li jfariseoetique, ijul ta sjolic ti jaꞌ scꞌoplalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","La snopic cꞌuxi xuꞌ ta stsaquic li Jesuse. Pero ixiꞌic o li ta jchiꞌiltactique yuꞌun schꞌunojic ti jaꞌ ta xal li scꞌop Dios li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Li Jesuse laj yalbe yan loꞌil nojtoc li jchiꞌiltactique. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Chacalbeic li cꞌu sba ta spas mantal li Diose. Jaꞌ jech chac cꞌu chaꞌal jun ajvalil ti la spas qꞌuin sventa ta xnupun li snichꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","La stac batel yajtuneltac, ba yicꞌanic talel li buchꞌutic yalojbe xa onoꞌox ti acꞌo xtal sqꞌuelic li qꞌuin nupunele. Pero mu scꞌan xtalic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","La stac batel yan yajtuneltac nojtoc. Jech laj yalbe batel: “Jech xavalbeic li buchꞌutic calojbe xa onoꞌox ti acꞌo talicuque: Batanic la, meltsanbil xa scotol li veꞌlile, milbil xa li vacaxetique schiꞌuc li yan stsꞌunubtac ti lec jupꞌemique. Ba la qꞌuelic li qꞌuin nupunele, utic cꞌotel”, xut batel li yajtuneltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero li buchꞌutic icꞌbilique muc bu schꞌunic. Muc bu xaqꞌuic ta venta ti jech iꞌalbatique. Solel jaꞌ ba spasic li cꞌusi tscꞌan stuquique. Li june ba sqꞌuel li cꞌustic stsꞌunoje. Li june ba pꞌolmajuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Li yanetique la stsaquic li yajtuneltac li ajvalile, la smajic, la smilic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cꞌalal iyaꞌi li ajvalil ti jech ispasique, iꞌilin tajmec. La stac batel yajsoltarotac yoꞌ acꞌo ba mileicuc li buchꞌutic imilvanique. La schicꞌbeic nojtoc li steclumalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Li ajvalile jech laj yalbe nojtoc li yan yajtuneltaque: “Chapal xa scotol li cꞌustic ta xtun ta sventa li qꞌuin nupunele, pero li buchꞌutic jtacanoj ta iqꞌuele muc bu xaqꞌuic ta venta. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Batanic ta bebetic. Iqꞌuic talel li buchꞌutic chataique, acꞌo xtal sqꞌuelic li qꞌuin nupunele”, xut batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iloqꞌuic batel li yajtuneltaque, ibatic ta bebetic. Laj yiqꞌuic talel scotol li buchꞌutic la staanic ta bee. Te capal italic li buchꞌutic chopolique schiꞌuc li buchꞌutic lequique. Noj icꞌot ta crixchano li na li bu ta spasic li qꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Li ajvalile och scꞌoponan li buchꞌutic la stacan ta iqꞌuele. Te iyil jun vinic ti maꞌuc slapoj li cꞌuꞌil ti yacꞌoj sventa nupunele. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jech laj yalbe: “Joꞌote, ¿cꞌuxi laꞌoch talel liꞌi yuꞌun maꞌuc alapoj li cꞌuꞌil sventa nupunel ti cacꞌoj chalapique?” xut. Muc bu xtacꞌav li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Li ajvalile jech laj yalbe li yajtuneltaque: “Chucbeic yoc scꞌob li vinique. Jipic batel ta icꞌal acꞌubal. Te xꞌoqꞌuelet o, te xcꞌuxuxet o ye ta scoj ti tsots li vocol ta xichꞌe”, xi li ajvalile. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jaꞌ svinajeb ti scotol icꞌbilic yuꞌun li Diose pero jutuc noꞌox li buchꞌutic tꞌujbilique, yuꞌun jutuc noꞌox li buchꞌutic ta scꞌanic ventainele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Li jfariseoetique ba snopic li cꞌusi tsjacꞌbeic li Jesuse yoꞌ jech chaꞌiic li cꞌu sba chtacꞌave, yoꞌ cꞌuxi ta stabeic o smul ti yalojique. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","La staquic batel yajchanbalajeltaquic schiꞌuc svinictac li Herodese. Jech tal sjacꞌbeic li Jesuse: ―Jchanubtasvanej, jnaꞌojcutic ti melel scotol li cꞌusi chavale, ti jamal chaval li cꞌusi tscꞌan Dios ti acꞌo jpascutique, ti mu tꞌujbiluc chachaꞌle li buchꞌu chavalbee. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Alo caꞌicutic li cꞌusi chanope. ¿Mi lec chil Dios ti ta jtojbecutic jpatancutic li Césare, mi moꞌoj? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Li Jesuse snaꞌoj ti yuꞌun noꞌox chqꞌuelbat yoꞌone, jech la stacꞌbe: ―¿Cꞌu chaꞌal tal aqꞌuelbecun coꞌon? Jloꞌlovanejoxuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ichꞌic talel junuc li taqꞌuin sventa ta jtojtic o jpatantique ―xꞌutatic. Ba yichꞌbeic talel jun denario taqꞌuin. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jech ijacꞌbatic yuꞌun li Jesuse: ―¿Buchꞌu slocꞌol liꞌi? ¿Buchꞌu sbi liꞌi? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Itacꞌavic: ―Jaꞌ César ―xiic. Jech iꞌalbatic yuꞌun li Jesuse: ―Scꞌan ta jpasbetic li yabtel ti ta xal li Césare yuꞌun jaꞌ mucꞌta ajvalil. Jech nojtoc scꞌan ta jpasbetic li cꞌusi ta xal li Diose ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cꞌalal iyaꞌiic li cꞌu sba itacꞌav li Jesuse, toj chꞌayel noꞌox yoꞌonic. Isutic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta jliquel oe italic jayvoꞌ jsaduceoetic eꞌuc, jaꞌ li buchꞌutic ta xalic ti muꞌyuc chaꞌcuxesele. Jech la sjacꞌbeic li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Jchanubtasvanej, jech la stsꞌiba comel li Moisés ta voꞌonee: “Mi icham jun vinic, mi muꞌyuc snichꞌon chcome, li itsꞌinal ti muꞌyuc to yajnile, jaꞌ acꞌo yicꞌbe yajnil li ánima sbanquile. Cꞌalal ta xil schꞌamale, jaꞌ acꞌo yacꞌbe sbiinbe sbi li ánima sbanquile, jaꞌ yoꞌ mu xchꞌay o li sbi li ánima sbanquile”, xi li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oy jucvoꞌ jchiꞌiltic ta israelal sbanquil yitsꞌin noꞌox sbaic. Li banquilale la saꞌ yajnil, pero icham, muꞌyuc snichꞌon icom. Li itsꞌinale laj yicꞌbe yajnil li ánima sbanquile. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","27","Jaꞌ jech la spasulanic sjucvaꞌalic. Xcholet sjucvaꞌalic laj yiqꞌuic li antse yuꞌun laj chamicuc. Tsꞌacal to icham eꞌuc li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cꞌalal ta xchaꞌcuxiique, ¿buchꞌu junucal ta xicꞌ o li antse yuꞌun scotolic laj yicꞌulanic? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Itacꞌav li Jesuse: ―Mu xanaꞌic li cꞌusi chal li scꞌop Diose. Mu xanaꞌic li cꞌu sba sjuꞌel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cꞌalal ta xchaꞌcuxiique, muꞌyuc xa yajnil li viniquetique, muꞌyuc xa smalal li antsetique. Jaꞌ xa jechic jech chac cꞌu chaꞌal li yajꞌangeltac Dios ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ti jech muc bu achꞌunojic ti ta xchaꞌcuxiic li ánimaetique, ¿mi yuꞌun muc bu aqꞌuelojic li cꞌusi laj yal Dios ta sventa li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove? Acꞌo mi voꞌone xa chamemic, pero te to ch‐albat scꞌoplalic: ");
INSERT INTO tzoSA_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Joꞌon Diosun yuꞌun li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove”, xi li Diose yuꞌun cuxulic. Ti lajemicuc o schiꞌuc schꞌulelic jech chac cꞌu chaꞌal chavalique, muꞌyuc Dios yuꞌunic yaꞌel. Li Diose jaꞌ Dios yuꞌunic li buchꞌutic cuxulic o sbatel osile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cꞌalal iyaꞌiic li jchiꞌiltactic ti jech laj yal li Jesuse, toj chꞌayel noꞌox yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cꞌalal iyaꞌiic li jfariseoetic ti muc bu xtojobic ta staqꞌuel li jsaduceoetique, la stsob sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Te oy jun jfariseo ti spꞌisoj sba ta jchanubtasvanej ta smantaltac li Diose. La sjacꞌbe li Jesuse yuꞌun ta sqꞌuel cꞌu sba chtacꞌav: ");
INSERT INTO tzoSA_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Jchanubtasvanej, ta scotol smantaltac li Dios ti laj yal comel li Moisés ta voꞌonee, ¿cꞌusi junucal ti más tsotse? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Itacꞌav li Jesuse: ―“Sloqꞌueluc me avoꞌonic cꞌanic me li Dios cuꞌuntique. Acꞌbo sventain avoꞌonic schiꞌuc apꞌijilic. Acꞌo tunuc yuꞌun”, xi li mantale. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Leꞌe jaꞌ li más tsotse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Li schibale jaꞌ noꞌox jech tsots nojtoc. Jech chal: “Cꞌuxubino me achiꞌilic jech chac cꞌu chaꞌal cꞌux chavaꞌi aba atuque”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Li chib mantal liꞌi jaꞌ smacoj scotol li yan smantaltac li Diose schiꞌuc li cꞌustic laj yalic li buchꞌutic iyalic scꞌop Dios ta voꞌonee ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cꞌalal te tsobolic li jfariseoetique, li Jesuse jech laj yal scꞌoplal stuc: ");
INSERT INTO tzoSA_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Cꞌusi chanopic? ¿Buchꞌu ti smucꞌta moltot ta voꞌone li Cristo li tꞌujbil yuꞌun Dios ti chventainvane? ―xut. Itacꞌavic: ―Jaꞌ smucꞌta moltot li Davide ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Li Jesuse jech la sjacꞌbe nojtoc: ―Mi jaꞌ mucꞌta moltotil li Davide, ¿cꞌu chaꞌal “Cajval”, xi li Davide? Ta sventa li Chꞌul Espíritue jech la stsꞌiba li Davide: ");
INSERT INTO tzoSA_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Li Cajvale xi iꞌalbat yuꞌun li Diose: “Chachoti ta jbatsꞌicꞌob, chapas mantal jaꞌ to mi la jpas ta canal scotol la avajcontrataque”, xꞌutat li Cristoe, xi li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Li Davide “Cajval”, xut li buchꞌu tꞌujbil yuꞌun Dios ti chventainvane. ¿Cꞌu chaꞌal “Cajval”, xut mi jaꞌ snitilul noꞌoxe? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mu junuc buchꞌu itacꞌavic. Jech mu cꞌusi la sjaqꞌuic o. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Li Jesuse lic scꞌoponuncutic, joꞌoncutic li yajchanbalajeltacuncutique, schiꞌuc li jchiꞌiltactic li te tsobolique. Jech laj yalbuncutic: ");
INSERT INTO tzoSA_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li jfariseoetique, jaꞌ icom ta sbaic li smantaltac Diose ti laj yal li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaꞌ yuꞌun chꞌunic me li scꞌop Dios ti chayalbeique, pero mu me xapasic jech chac cꞌu chaꞌal ta spasic li stuquique. Yuꞌun muc bu jech ta spasic li cꞌu sba ta xchanubtasvanique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Coꞌol schiꞌuc ta spechꞌic lec icatsil ti toj ole, ti vocol ta xlic ta petele. Joꞌoxuc noꞌox chacꞌ acuchic pero li stuquique mu xlic yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Scotol li cꞌusi ta spasique jaꞌ noꞌox yoꞌ acꞌo lec ch‐ileic o yuꞌun li crixchanoetique. Li sbiqꞌuit‐av smantaltac Dios ti acotolic chachuquic ta acꞌobic ta atiꞌbaic li cꞌalal chataic ta naꞌel li Diose, li jfariseoetique jaꞌ más mucꞌ spasojic. Schiꞌuc li scꞌuꞌic ta slapique nat stsitsimal spasojic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Lec chaꞌiic ti ta xchotiic li bu tꞌujbil chotlebal ta jujun qꞌuine. Lec chaꞌiic nojtoc ti ta xchotiic li bu tꞌujbil chotlebal ta chꞌulnaetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jaꞌ lec chaꞌiic ti lequil cꞌoponbilic yuꞌun li jchiꞌiltactic li te ta chꞌivite. Jaꞌ lec chaꞌiic ti “jchanubtasvanej” xꞌutatic yuꞌun li jchiꞌiltactique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero li joꞌoxuque mu me xacꞌanic ti “jchanubtasvanej” xaꞌutatique yuꞌun jun noꞌox la Avajchanubtasvanejique, jaꞌ li joꞌone ti tꞌujbilun yuꞌun Dios ti chajventainique. Li joꞌoxuque achiꞌil noꞌox abaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mu me buchꞌu xapꞌis ta atotic liꞌ ta balumile, yuꞌun jun noꞌox li Jtotique, jaꞌ li Dios ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mu me xacꞌanic ti “Cajval” xaꞌutatique yuꞌun jun noꞌox la Avajvalique, jaꞌ li joꞌone ti tꞌujbilun yuꞌun Dios ti chajventainique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Li buchꞌu banquilal avuꞌunique acꞌo sbicꞌtajes sba ta atojolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Li buchꞌu junucal ta stoy sba ta atojolique jaꞌ ta xbicꞌtajese yuꞌun li Diose. Yan li buchꞌu junucal ta sbicꞌtajes sba ta atojolique, jaꞌ ta xꞌaqꞌue ta ichꞌel ta mucꞌ yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Yuꞌun jaꞌ li chapajesic li buchꞌutic ta scꞌanic ventainel yuꞌun li Diose, pero li joꞌoxuque mu xacꞌanic ventainel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Altic ti jal chataic ta naꞌel li Diose, yuꞌun ta to xaloꞌlobeic li cꞌustic oy yuꞌun li meꞌanal antsetique. Jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Chalubtsan abaic ta saꞌel mi oy bu xataic junuc avajchanbalajelic. Mi la ataique, más to ta soc o avuꞌunic. Jaꞌ yuꞌun joꞌoxuc ta acojic ti chba yichꞌ vocol ta mucꞌta cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Joꞌoxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal jun maꞌsat. Chavichꞌic tsots vocol yuꞌun apꞌisoj abaic ti chavaqꞌuic ta ilel bee. Yuꞌun jech chavalic: “Li buchꞌu chal ti jaꞌ yajtextico li mucꞌta chꞌulnae, mu persauc tspas li cꞌusi chale. Yan li buchꞌu chal ti jaꞌ yajtextico li cꞌanal taqꞌuin li te ta mucꞌta chꞌulnae, jaꞌ persa tspas li cꞌusi chale”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mu xanaꞌic snopel. Jaꞌ jechoxuc jech chac cꞌu chaꞌal jun maꞌsat. Yuꞌun mu másuc ichꞌbil ta mucꞌ li cꞌanal taqꞌuine; jaꞌ más ichꞌbil ta mucꞌ li mucꞌta chꞌulna li yoꞌ bu tiqꞌuil li cꞌanal taqꞌuine yuꞌun jaꞌ te ta xmilbat smoton li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jech chavalic nojtoc: “Buchꞌu chal ti jaꞌ yajtextico li scajleb smoton li Diose, mu persauc tspas li cꞌusi chale. Yan li buchꞌu chal ti jaꞌ yajtextico ti milbil smoton Dios li te cajanbile, jaꞌ persa tspas li cꞌusi chale”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mu xanaꞌic snopel. Jaꞌ jechoxuc jech chac cꞌu chaꞌal jun maꞌsat. Yuꞌun mu másuc ichꞌbil ta mucꞌ li smoton li Diose; jaꞌ más ichꞌbil ta mucꞌ li yoꞌ bu cajal chcꞌacꞌ li smoton li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Li buchꞌu chal ti jaꞌ yajtextico li scajleb smoton li Diose, jaꞌ xa yajtextico cꞌalal ta smoton Dios li te cajanbile. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jech nojtoc li buchꞌu chal ti jaꞌ yajtextico li mucꞌta chꞌulnae, jaꞌ xa yajtextico nojtoc li Diose yuꞌun jaꞌ te yacꞌoj sba li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Li buchꞌu chal ti jaꞌ yajtextico li vinajele jaꞌ xa yajtextico cꞌalal ta smucꞌta chotleb li Diose, schiꞌuc li Dios li te chotole. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Yuꞌun jaꞌ noꞌox chanopic ti persa chavatic ta lajlajuneb li cꞌustic atsꞌunojique, jaꞌ li tulnichime, schiꞌuc li anise, schiꞌuc li cominoe. Chaloqꞌuesic jujun li ta lajlajuneb ta sventa smoton li Diose. Pero jaꞌ mu xacꞌan xapasic li bu persa scꞌan pasel li smantaltac li Dios ti laj yal comel li Moisese. Mu xavaqꞌuic ta venta ti scꞌan ti lec chameltsanic cꞌope, ti chacꞌuxubinvanique, ti melel li cꞌustic chavalique. Jaꞌ lec ti lauc apasic nojtoc ti bu persa scꞌan pasele. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Altic ti chachanubtasvanique yuꞌun jaꞌ noꞌox chachꞌunic li bu mu tsotsuque. Yan li bu tsotse jaꞌ mu xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Jech chac cꞌu chaꞌal ti buchꞌu jaꞌ noꞌox ta spocbe spat xocon li vasoe schiꞌuc li pulatue, yan li yute muc bu tsuqꞌuic, noj ta icꞌubal. Jaꞌ noꞌox jechoxuc li joꞌoxuque. Lecoxuc yilel pero jaꞌ noꞌox batem ta avoꞌonic scꞌupinel li cꞌustic oy yuꞌun la achiꞌilique. Chavalbeic ti acꞌo yaqꞌuic ta smoton li Diose pero joꞌoxuc noꞌox chavichꞌic atuquic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Joꞌoxuc li jfariseooxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal jun maꞌsat. Jaꞌ lec acꞌo ta poquel baꞌi la avoꞌonique jech chatuqꞌuibic o, jech lec nojtoc scotol li cꞌusi chapasique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Jaꞌ jechoxuc jech chac cꞌu chaꞌal chꞌenal ánima ti lec bonbil spat xocon ta tane, ti lec cꞌupil sba ta qꞌuelele, pero ta yute noj ta baquil ánimaetic schiꞌuc scotol li cꞌustic te cꞌaꞌemique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jaꞌ jechoxuc li joꞌoxuque. Tucꞌ la avoꞌonic yilel ta stojol li crixchanoetique, pero altic. Naca loꞌlovanej anopojic schiꞌuc li cꞌustic chopole. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Yuꞌun joꞌoxuc chachaꞌachꞌubtasbeic schiꞌuc chachaꞌbonbeic lec smuquenal li buchꞌutic iyalic scꞌop Dios ta voꞌone ti lec tucꞌ yoꞌonique, pero mu xachꞌunic li cꞌustic laj yalic ta jventae. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Altic ti jech chavalbeic li crixchanoetique: “Ti oyucuncutic xaꞌox li cꞌalal iꞌechꞌic ta balumil li jtotic jmeꞌtic ta voꞌonee, muc bu jticꞌ jbacutic ta smilel li buchꞌutic iyalic scꞌop Dios ti jechuque”, xavutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jaꞌ chvinaj o ti coꞌol avoꞌonic achiꞌuquic la atot ameꞌic ti la smilanic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Joꞌoxuc to chatsꞌacubtasic li cꞌusi la spasic la atot ameꞌic ta voꞌonee yuꞌun poꞌot xa chapasbecun jech eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’La atot ameꞌique jaꞌ jechic jech chac cꞌu chaꞌal li orachone. Jaꞌ noꞌox jechoxuc eꞌuc li joꞌoxuque, yuꞌun coꞌol avoꞌonic achiꞌuquic la atot ameꞌique. Mu xuꞌ avuꞌunic chapoj abaic, persa onoꞌox chba avichꞌic vocol li te ta mucꞌta cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chajtacboxuc to talel buchꞌutic ta xal scꞌop Dios ti lec pꞌijique, ti lec snaꞌ xchanubtasvanic ta sventa li cꞌusi tscꞌan li Diose. Oy noꞌox buchꞌu chamilic, oy noꞌox buchꞌu chajocꞌanic ta cruz, oy noꞌox buchꞌu chatsitsic ta yut achꞌulnaic schiꞌuc chanutsic loqꞌuel ta jujun jteclum li te ta avosilalique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaꞌ yuꞌun joꞌoxuc ta xcom ta abaic ti imileic scotol li buchꞌutic tucꞌ yoꞌonique. Cꞌalal imile li Abele, jaꞌ li tuqꞌuil vinique, ti cꞌalal to icꞌot ta lajel li Zacaríase, jaꞌ li snichꞌon Berequíase, ti imile ta yamaqꞌuil li mucꞌta chꞌulna ta nopol scajleb smoton li Diose, joꞌoxuc icom ta abaic scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Melel li cꞌusi chacalbeique, joꞌoxuc ti liꞌ to oyoxuc ta balumile chacuchbeic scotol li svocolic la atot ameꞌic ti imilvanique. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Joꞌoxuc li liꞌ nacaloxuc ta Jerusalene, atalelic o ti chamilic li buchꞌutic chalic li scꞌop Diose. Chavacꞌbeic ton li buchꞌutic tacbilic talel yuꞌun Dios liꞌ ta atojolique. Pero ep xa ta velta la jcꞌan jtsoboxuc jech chac cꞌu chaꞌal ta stsob yol ta yolon xicꞌ li meꞌcaxlane, pero mu xacꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aꞌiic, toj abol abaic chacomic. Muc xa bu liꞌ achiꞌuquic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jech chacalbeic, muc xa bu chavilicun. Jaꞌ to mi icꞌot scꞌacꞌalil ti jech chavalique: “Toj lec li buchꞌu tacbil talel yuꞌun li Cajvaltic Diose”, mi xachiique, jaꞌ to chavilicun nojtoc ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Cꞌalal yuꞌun xaꞌox chijlocꞌcutic ta stiꞌ smacol li mucꞌta chꞌulna li te ta Jerusalén schiꞌuc li Jesuse, laj cacꞌbecutic yil ti toj cꞌupil sba meltsanbil li chꞌulnae schiꞌuc li naetic li teye. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Li Jesuse jech laj yalbuncutic: ―Laj xa avilic scotol liꞌi. Melel li cꞌusi chacalbeique, chcꞌot scꞌacꞌalil ti mu jpꞌejuc ton latsal chcome yuꞌun chtal sjinesic jyanlumal crixchanoetic ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Li Jesuse ibat ta vits Olivatic, te ichoti. Te lijbatcutic eꞌuc, joꞌoncutic li yajchanbalajeltacuncutique. Jech la jacꞌbecutic li Jesuse: ―Alo caꞌicutic cꞌu ora chcꞌot ta pasel ti chjinesat li mucꞌta chꞌulna li la avale. ¿Cꞌu sba chavacꞌbe svinajeb baꞌi ti yoꞌ chquilcutic o ti poꞌot xa chachaꞌtale? ¿Cꞌu sba chavacꞌbe svinajeb baꞌi ti yoꞌ chquilcutic o nojtoc ti poꞌot xa slajeb cꞌacꞌale? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Itacꞌav li Jesuse: ―Qꞌuelo me abaic, mu me buchꞌu xasloꞌloic. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yuꞌun oy ep buchꞌutic chalic ti jaꞌ sbi li jbie. Jech chalic: “Joꞌon Cristoun li tꞌujbilun yuꞌun Dios ti chajventainique”, xiic. Jaꞌ jech ep buchꞌutic ta schꞌunic loꞌloel. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Cꞌalal chavaꞌiic ti oy cꞌop liꞌi, schiꞌuc cꞌalal chavaꞌiic ti oy cꞌop ta nome, mu xaxiꞌic. Ta onoꞌox xcꞌot ta pasel pero maꞌuc toꞌox slajeb cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chlic saꞌic cꞌop li crixchanoetic ta yantic o balumile. Chlic saꞌic cꞌop li ajvaliletic nojtoque. Chtal tsots viꞌnal schiꞌuc chamel. Schiꞌuc oy bu tsots ch‐echꞌ niquel ta balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero taje sliqueb to li vocole. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Chaꞌaqꞌueic ta scꞌob jꞌabteletic yoꞌ jech chavichꞌic vocol, oy noꞌox buchꞌu chlaj ta milel avuꞌunic. Ep crixchanoetic chopol chayilic ta sventa ti avichꞌojicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Oy ep buchꞌutic ta xchibaj o yoꞌonic. Li buchꞌutic ta xchibaj yoꞌonique chopol chilic li buchꞌutic mu xchibaj yoꞌonique. Jamal chalic ti bu nacalique yoꞌ acꞌo tsaqueicuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta xlocꞌ ep jloꞌlovanejetic. Ep buchꞌutic ta schꞌunic loꞌloel. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Toj echꞌem ta xpꞌol li cꞌusi chopole jech ep buchꞌutic mu xa cꞌuxuc ta yoꞌonic li schiꞌiltaquique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero li buchꞌutic chcuch yuꞌun scotol li vocole, mi mu schibajes yoꞌonique, jaꞌ chcolic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero ta persa baꞌi ta xichꞌ alel ta spꞌejel balumil ti ista xa scꞌacꞌalil ti chventainatic yuꞌun li Diose. Jaꞌ o ta sta yorail li slajeb cꞌacꞌale ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Li cꞌusi chajtsꞌibaboxuc batel liꞌi, nopbeic lec li smelole yuꞌun jech onoꞌox laj yalbuncutic li Jesuse: ―Li cꞌalal chavilic ti te vaꞌanbil ta yut li mucꞌta chꞌulna li cꞌusi chopol chil li Diose jech chac cꞌu chaꞌal laj yal Daniel li iyal scꞌop Dios ta voꞌonee, jatavanic batel ta anil ta vitstic, joꞌoxuc li liꞌ nacaloxuc ta Judeae. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Li buchꞌutic ti te oyic ta sjol snaic ti pachꞌale, cꞌalal ta xyalic talele, mu xa me xꞌoch sloqꞌuesic li cꞌustic oy ta yut snaique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Li buchꞌutic ti te oyic ta yabtelique, mu xa me sutic talel ta snaic yoꞌ chtal yichꞌic li spuychijique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Toj abol sbaic li buchꞌutic schiꞌuc yolique schiꞌuc li buchꞌutic ta to xchuꞌun yolique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taic ta naꞌel Dios ti mu me ta yora sictic, mi ta scꞌacꞌalil chacux avoꞌonic li cꞌalal chajatavique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yuꞌun toj tsots li vocol li chtal ta slajebe. Muc onoꞌox bu jech echꞌem li cꞌalal ilic li balumile schiꞌuc cꞌalal tana. Mi iꞌechꞌ li tsots vocol taje, muc xa bu chtal. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ti manchuc tspajes li vocol li Diose, mu junuc buchꞌu chcol avuꞌunic ti jechuque. Pero ta sventa li buchꞌutic tꞌujbilique, li Diose tspajes li vocole. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Mi oy buchꞌu jech chayalbeic: “Liꞌ xa oy li Cristoe”, mi xayutique, mu me xachꞌunic. Mi oy buchꞌu yan nojtoc jech chayalbeic: “Leꞌ xa oy li Cristoe”, mi xayutique, mu me xavaqꞌuic ta venta. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yuꞌun chtalic li buchꞌutic spꞌisoj sbaic ti jaꞌ tꞌujbilic yuꞌun Dios ti chasventainique, schiꞌuc spꞌisoj sbaic ti jaꞌ chalic li scꞌop Diose, pero altic chalic. Chaqꞌuic ta ilel ti oy sjuꞌelique yoꞌ jech chloꞌloj o li crixchanoetique. Tscꞌan tsloꞌloic eꞌuc li buchꞌutic tꞌujbilic yuꞌun li Diose, pero mu xloꞌloj yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Qꞌuelo me abaic li joꞌoxuque, jaꞌ me yuꞌun cac noꞌox chacalbeic scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mi oy buchꞌu jech chayalbeic: “Te xa oy ta taqui jamaltic li Cristoe”, mi xayutique, mu me xba aqꞌuelic. Mi oy buchꞌu yan nojtoc jech chayalbeic: “Te xa oy ta yut na”, mi xiique, mu me xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yuꞌun jaꞌ jech chac cꞌu chaꞌal li chauc ti xleblajet ta xquiltic ti butic xa oyutique, jaꞌ jech scotol crixchaneotic chiyilic cꞌalal chichaꞌtal, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ta onoꞌox xtal tsots vocol ta stojolic li buchꞌutic ti mu xiyichꞌic ta muqꞌue, jech chac cꞌu chaꞌal mi oy cꞌusi chameme, ta onoꞌox stsob sbaic talel li xulemetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Cꞌalal mi iꞌechꞌ scotol li vocol li laj calboxuque, jaꞌ o chmac sat li cꞌacꞌale. Mi jaꞌuc li ue mu xacꞌ xojobal nojtoc. Li cꞌanaletique ta stsꞌujan yalel nojtoc. Ta xnic scotol li cꞌustic oy ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jaꞌ chilic o scotol crixchanoetic li cꞌu sba chichaꞌtale, joꞌon li coꞌol crixchanoutique. Scotol crixchanoetic ta spꞌejel balumil ta xꞌoqꞌuic ta scoj xiꞌel. Yuꞌun chilic ti oy jtsatsal oy juꞌel li cꞌalal chiyal talel ta toc ta vinajel, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tsots chjupanat oqꞌues nojtoc, jech chyal talel li cajꞌangeltaque. Jaꞌ chtal tsobeicuc scotol li buchꞌutic tꞌujbilic cuꞌun ta spꞌejel li balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Naꞌic me ti cꞌalal ch‐unenaj li teꞌel higoe, jaꞌ chanaꞌic o ti poꞌot xa yora joꞌtique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jaꞌ noꞌox jech li cꞌalal chavilic ti chcꞌot ta pasel scotol li cꞌusi laj cale, jaꞌ chanaꞌic o ti poꞌot xa scꞌacꞌalil chichaꞌtale, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Melel chacalbeic, li buchꞌutic iyaꞌiic li cꞌu sba chlic li tsots vocol li laj calboxuc liꞌi, oy toꞌox cuxuloxuc li cꞌalal chlique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Li cꞌustic caloje mu xchꞌay scꞌoplal, ta onoꞌox xcꞌot ta pasel scotol. Jaꞌ xlaj to li vinajel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Li cꞌu ora chichaꞌtale muc buchꞌu snaꞌ, mi jaꞌuc li ángeletic ta vinajele, mi joꞌcun li Nichꞌonilune. Jaꞌ noꞌox snaꞌ stuc li Jtotique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Jech chac cꞌu chaꞌal la spasic li crixchanoetic ta voꞌone li cꞌalal liꞌ toꞌox oy li Noee, jaꞌ noꞌox jech ta spasic eꞌuc li cꞌalal ta sta scꞌacꞌalil ti chichaꞌtal, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cꞌalal muc toꞌox bu talem li nojelale, jaꞌ noꞌox batem ta yoꞌonic ta saꞌel sveꞌelic, ta xnupunic, schiꞌuc ta xacꞌ ta malijel stseubic. Jaꞌ to ipajic li cꞌalal ital li nojelale. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Muc onoꞌox bu ischꞌunic ti chtal nojelale. Jaꞌ to ischꞌunic li cꞌalal itale, pero muc xa bu xcolic, ilaj scotolic. Jaꞌ jech chcꞌot ta pasel li cꞌalal chichaꞌtal, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mi oy chaꞌvoꞌ viniquetic ti coꞌol ta xꞌabtejic ta yabtelique, jun ta xquicꞌ ba, jun ta xcom. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mi oy chaꞌvoꞌ antsetic coꞌol ta xjuchꞌunique, jun ta xquicꞌ ba, jun ta xcom. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Vicꞌluc noꞌox me asatic chaꞌa, yuꞌun mu xanaꞌic cꞌu ora chichaꞌtal, joꞌon la Avajvalicune. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naꞌic me jech chac cꞌu chaꞌal li yajval na ti mu snaꞌ mi chtal jun jꞌelecꞌ ta acꞌubaltique. Ti snaꞌojuque, mu xꞌoch svayel ti jechuque. Mu cꞌusi ta xchꞌay yuꞌun ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaꞌ noꞌox jechoxuc eꞌuc li joꞌoxuque, scꞌan ti vicꞌluc asatic chamalaicune. Yuꞌun mu xanaꞌic li cꞌu ora chichaꞌtal, joꞌon li coꞌol crixchanoutique. Mu me chꞌayluc avoꞌonic chjul jtaoxuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Li buchꞌu lequil jtunele jun yoꞌon ta xꞌabtej ta stojol li yajvale. Yuꞌun pꞌij ta xꞌile yuꞌun li yajvale, ta xꞌacꞌbat yabtel ti jaꞌ ta smacꞌlan schiꞌiltac ta abtel li cꞌalal ta sta yora chveꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xmuybaj noꞌox li jtunel ti jun yoꞌon yacal spasel chjul taatuc yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Melel li cꞌusi chacalbeique, li buchꞌu ti jun yoꞌon ta xꞌabteje ta xꞌacꞌbat sventain scotol li cꞌustic oy yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero mi chopol li jtunele jech chlic snop: “Mu to nan xtal ta ora li cajvale”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jech chlic yutan chlic smajan li schiꞌiltac ta abtel ti acꞌbil sventaine. Jaꞌ chba schiꞌinan ta veꞌel li buchꞌutic jyacubeletique. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Li yajvale jaꞌ o chjul talel li cꞌalal chꞌayal yoꞌon ti cꞌusiuc noꞌox ta spasbe li schiꞌiltaque yuꞌun mu schꞌun ti poꞌot xa chtal li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chjul acꞌbatuc yichꞌ tsots vocol yuꞌun li yajvale. Coꞌol ta xichꞌ vocol schiꞌuc li jloꞌlovanejetique. Te xꞌoqꞌuelet o, te xcꞌuxuxet o ye ta scoj ti tsots li vocol ta xichꞌe ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Li Jesuse jech lijyalbuncutic yan loꞌil: ―Chacalbeic li cꞌu sba ta xcꞌot ta pasel li cꞌalal chtal jpas mantale. Jaꞌ jech chac cꞌu chaꞌal lajunvoꞌ tojol tsebetic ti laj yichꞌic batel scantilic yuꞌun ba snupic ta be li jnupunel quereme. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Li joꞌvoꞌique lec pꞌijic. Li joꞌvoꞌic nojtoque muc bu pꞌijic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Li tsebetic li muc bu pꞌijique jaꞌ noꞌox laj yichꞌic batel scantilic, muc bu laj yichꞌbeic batel más yaseteil. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yan li tsebetic ti lec pꞌijique la snojesic ba scantilic, iyichꞌic ba más yaseteil ta yan o yav. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Li jnupunel quereme muc bu xtal ta ora. Li tsebetique iꞌoch svayelic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ta oꞌlol acꞌubal iyaꞌiic ti jech iꞌaptaatique: “Chtal xa li jnupunel quereme. Locꞌanic batel ta ora, ba nupic talel ta be”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ijulavic ta ora li tsebetique. La schꞌolbeic más yaseteil li scantilique, la smeltsanic lec. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Li tsebetic ti muc bu pꞌijique jech laj yalbeic li buchꞌutic pꞌijique: “Acꞌbuncutic jsetꞌuc avaseteic yuꞌun ta xtupꞌ xa li jcantilcutique”, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Itacꞌavic li buchꞌutic pꞌijique: “Mu xuꞌ. Oy yicꞌal mu xlocꞌ o cuꞌuncutic eꞌuc. Jaꞌ lec ba manic talel li bu ta xchonee”, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Cꞌalal jaꞌ o batemic o ta smanele, jaꞌ o ital li jnupunel quereme. Li tsebetic ti lec chapalique iꞌochic li yoꞌ bu ta spasic li qꞌuin nupunele. Li yajval nae la smac li tiꞌnae. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tsꞌacal to italic li yan tsebetique. Jech laj yalic: “Cajval, Cajval, jambuncutic li stiꞌ anae, otesuncutic”, xiic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jech itacꞌbatic: “Melel li cꞌusi chacalbeique, muc bu chajambeic stiꞌ jna yuꞌun mu jmojuc coꞌontic”, xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Jaꞌ jech li joꞌoxuque, scꞌan ti vicꞌluc asatique yuꞌun mu xanaꞌic cꞌu ora chichaꞌtal, joꞌon li coꞌol crixchanoutique. Mi ta sob, mi ta mal cꞌacꞌal, mi ta acꞌubaltic, mu xanaꞌic ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Laj yalbuncutic yan loꞌil nojtoc li Jesuse: ―Chacalbeic li cꞌu sba ta xcꞌot ta pasel li cꞌalal chtal jpas mantale. Jaꞌ jech chac cꞌu chaꞌal jun vinic ti chbat ta nome. Cꞌalal muc toꞌox bu bateme, laj yicꞌan talel li yajtuneltaque. Laj yacꞌbe sventain comel li staqꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Li june laj yacꞌbe comel joꞌmil, li schaꞌvaꞌale laj yacꞌbe comel chaꞌmil, li yoxvaꞌale laj yacꞌbe comel jmil. Li buchꞌu lec pꞌije jaꞌ ep iꞌacꞌbat. Yan li buchꞌu mu snaꞌ leque jutuc noꞌox iꞌacꞌbat. Cꞌalal laj yacꞌ comel li staqꞌuine, jaꞌ o ibat ta nom. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Li buchꞌu iꞌacꞌbat joꞌmile lic sman spꞌolmal yoꞌ chjolin o li taqꞌuine. Jech ijolin yuꞌun joꞌmil. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jaꞌ noꞌox jech la spas eꞌuc li buchꞌu chaꞌmil noꞌox iꞌacꞌbate. Ijolin yuꞌun chaꞌmil eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yan li buchꞌu jmil noꞌox iꞌacꞌbate la snacꞌbe noꞌox staqꞌuin li yajvale, la smuc ta balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Cꞌalal voꞌone xaꞌox sbatel li yajvalique, ichaꞌsut talel. La stacan ta iqꞌuel li yajtuneltaque, la sjacꞌanbe cꞌu yepal ijolin yuꞌunic li taqꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jaꞌ baꞌi ital li buchꞌu yichꞌoj comel joꞌmile, te yichꞌojbe talel li joꞌmil sjol nojtoque. Jech cꞌot yalbe li yajvale: “Cajval, liꞌ oy li joꞌmil ataqꞌuin ti la avacꞌbun comele schiꞌuc li joꞌmil ti ijolin cuꞌune”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jech iꞌalbat yuꞌun li yajvale: “Stacꞌ jtsac. Lequil cajtunelot yuꞌun jun avoꞌon laꞌabtej ta jventa. Jutuc noꞌox laj cacꞌbot, pero li avie chacacꞌbe más ti cꞌusticuque. Laꞌ jchiꞌin jbatic o jech xijmuybajutic o sbatel osil”, xꞌutat yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ital eꞌuc li buchꞌu yichꞌoj chaꞌmile, jech cꞌot yalbe li yajvale: “Cajval, liꞌ oy li chaꞌmil ataqꞌuin ti la avacꞌbun comele schiꞌuc li chaꞌmil ti ijolin cuꞌune”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jech iꞌalbat yuꞌun li yajvale: “Stacꞌ jtsac. Lequil cajtunelot yuꞌun jun avoꞌon laꞌabtej ta jventa. Jutuc noꞌox laj cacꞌbot, pero li avie chacacꞌbe más ti cꞌusticuque. Laꞌ jchiꞌin jbatic o jech xijmuybajutic o sbatel osil”, xꞌutat yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ital eꞌuc li buchꞌu jmil noꞌox yichꞌoje, jech cꞌot yalbe li yajvale: “Cajval, jnaꞌoj onoꞌox ti toj tsots avoꞌone. Jaꞌ jechot jech chac cꞌu chaꞌal li buchꞌu ta scꞌaj li bu maꞌuc la stsꞌune, schiꞌuc ta stsob li bu maꞌuc laj yicꞌae. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jaꞌ yuꞌun lixiꞌ mi xchꞌay cuꞌun la ataqꞌuine, jaꞌ yuꞌun la jmuc ta balumil. Ichꞌo sutel yuꞌun avuꞌun onoꞌox”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jech iꞌalbat yuꞌun li yajvale: “Mu xatun, chꞌajil jtunelot. Chaval ti joꞌon ta xquichꞌ li bu mu joꞌcun la jtsꞌune schiꞌuc li bu mu joꞌcun laj quicꞌae. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jaꞌ lec ti avacꞌbeuc li buchꞌu snaꞌ sjolintasel taqꞌuine. Cꞌalal litale, iquichꞌ sutel schiꞌuc sjol ti jechuque”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Li yajvale jech laj yalbe li yan yajtunele: “Pojbeic li jmil taqꞌuin ti cacꞌojbee, jaꞌ acꞌbeic li buchꞌu laj yichꞌ talel lajunmile”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jaꞌ noꞌox jech eꞌuc li buchꞌu ta xacꞌ tunuc yuꞌun Dios li cꞌu yepal iꞌacꞌbate, ch‐acꞌbat más yuꞌun li Diose jech mu cꞌu snaꞌ o. Yan li buchꞌu mu xacꞌ xtun yuꞌun Dios li cꞌu yepal iꞌacꞌbate ta xpojbat sutel. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Li chꞌajil jtunel liꞌi jipo batel ta icꞌal acꞌubal. Te xꞌoqꞌuelet o, te xcꞌuxuxet o ye ta scoj ti tsots li vocol ta xichꞌe ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jech laj yalbuncutic li Jesuse: ―Cꞌalal chtal ochcun ta ajvalilale, joꞌon li coꞌol crixchanoutique, chischiꞌinic yalel talel scotol li ángeletique. Jaꞌ o chlaj quichꞌanbe scꞌop li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta jtsob talel ta jtojol scotol li crixchanoetique. Cꞌalal te xa tsobolic ta jtojole, chlic jvocꞌan jech chac cꞌu chaꞌal li jchabiejchij ti tsvocꞌ li schij schiꞌuc li stentsune. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Scotol li crixchanoetic ti lequique jaꞌ chlaj cacꞌan ta jbatsꞌicꞌob. Yan li chopol crixchanoetique jaꞌ ta jtsꞌetcꞌob chlaj cacꞌan. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Joꞌon li mucꞌta ajvalilune jech chcalbe li buchꞌutic te oyic ta jbatsꞌicꞌobe; “Laꞌic yuꞌun tuqꞌuibtasbiloxuc xa yuꞌun li Jtote. Ochcutic ta pasmantal yuꞌun jech onoꞌox yaloj ta voꞌone li Jtot li cꞌalal la spas li balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yuꞌun cꞌalal liviꞌnaje, la avacꞌbecun jveꞌel. Cꞌalal itaquij jtiꞌe, la avacꞌbecun yoxoꞌ cuchꞌ. Acꞌo mi mu xavojtaquinicun, la avotesicun ta anaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cꞌalal tꞌanalune, la avacꞌbecun jcꞌuꞌ. Cꞌalal ipune, a aqꞌuelicun. Cꞌalal tiqꞌuilun ta chuquele, a aqꞌuelicun”, xichi chcalbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jech ta xtacꞌavic li buchꞌutic tucꞌ yoꞌonique: “Cajval, ¿pero cꞌu ora laj quilcutic ti laviꞌnaje ti laj cacꞌcutic aveꞌele? ¿Cꞌu ora laj quilcutic ti taquin atiꞌe ti laj cacꞌcutic yoxoꞌ avuchꞌe? ");
INSERT INTO tzoSA_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Cꞌu ora laj cotesotcutic ta jnacutic ti mu xacojtaquincutique? ¿Cꞌu ora iquilcutic ti tꞌanalote ti laj cacꞌcutic acꞌuꞌe? ");
INSERT INTO tzoSA_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Cꞌu ora iquilcutic ti ipote ti a jqꞌuelotcutique? ¿Cꞌu ora iquilcutic ti te tiqꞌuilot ta chuquele ti a jqꞌuelotcutique?” xi chtacꞌavic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Joꞌon li mucꞌta ajvalilune jech ta jtacꞌbe: “Melel li cꞌusi chacalbeique, ti jech la acꞌuxubinic jun li buchꞌu yichꞌojun ta mucꞌ ti muc bu acꞌbil ta ventae, coꞌol schiꞌuc joꞌon la acꞌuxubinicun yaꞌel”, xichi ta jtacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Joꞌon li mucꞌta ajvalilune jech chcalbe li buchꞌutic te oyic ta jtsꞌetcꞌobe: “Vocꞌ abaic ta jtojol yuꞌun mu xatunic. Batanic ta mucꞌta cꞌocꞌ sbatel osil, jaꞌ li cꞌocꞌ ti meltsanbil xa cuꞌun sventa te ch‐och li banquilal pucuj schiꞌuc li itsꞌinal pucujetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yuꞌun cꞌalal liviꞌnaje, muc bu xavacꞌbecun jveꞌel. Cꞌalal itaquij coꞌone, muc bu xavacꞌbecun yoxoꞌ cuchꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Cꞌalal licꞌot ta anaique, avalic ti mu xavojtaquinicune, jech muc bu xavotesicun. Cꞌalal tꞌanalune, muc bu xavacꞌbecun jcꞌuꞌ. Cꞌalal ipune schiꞌuc cꞌalal tiqꞌuilun ta chuquele, muc bu a aqꞌuelicun”, xichi chcalbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jech ta xtacꞌavic eꞌuc: “Cajval, pero ¿cꞌu ora laj quilcutic ti laviꞌnaje, ti itaquij atiꞌe, ti muc bu xacojtaquincutique, ti tꞌanalote, ti ipote, ti tiqꞌuilot ta chuquele ti muc bu xajcꞌuxubincutic chavale?” xi chtacꞌavic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jech ta jtacꞌbeic: “Melel li cꞌusi chacalbeique, yuꞌun muc bu xacꞌuxubinic junuc li buchꞌu muc bu acꞌbil ta ventae, coꞌol schiꞌuc joꞌon muc bu xacꞌuxubinicun”, xichi ta jtacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jech chba yichꞌic o vocol sbatel osil. Yan li buchꞌutic tucꞌ yoꞌonique jaꞌ ta xcuxiic o sbatel osil ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cꞌalal ilaj yoꞌon ta loꞌil li Jesuse, jech laj yalbuncutic nojtoc, joꞌoncutic li yajchanbalajeltacuncutique: ");
INSERT INTO tzoSA_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Xanaꞌic ti chib xa cꞌacꞌal scꞌan li qꞌuin Coltaele. Jaꞌo chiꞌaqꞌue ta cꞌabal, joꞌon li coꞌol crixchanoutique. Chisjocꞌanic ta cruz ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletic cuꞌuntique, la stsob sbaic ta yamacꞌ li más banquilal palee, jaꞌ li Caifase. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","La snopic cꞌu sba xuꞌ ta stsaquic ta mucul li Jesuse yoꞌ tsmilic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jech laj yalbe sbaic: ―Jaꞌ lec mu jtsactic ta qꞌuin yuꞌun naca me sliquesic cꞌop li jchiꞌiltactique ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lijbatcutic ta Betania schiꞌuc li Jesuse. Te lijcꞌotcutic ta sna Simón, jaꞌ li buchꞌu tsacbil toꞌox ta cꞌaꞌel chamele. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te ital jun ants, yichꞌoj talel slimeta pasbil ta alabastro ton ti noj ta muil vomole. Toj toyol stojol li muil vomole. La smalbe ta sjol Jesús li cꞌalal te chotol ta tiꞌmexae. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cꞌalal laj quilcutic, joꞌoncutic li yajchanbalajeltacuncutique, lijꞌilincutic o. Jech laj calcutic: ―¿Cꞌu chaꞌal jech noꞌox ta xlaj li muil vomole? ");
INSERT INTO tzoSA_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jaꞌ lec ti lauc schone yuꞌun toyol stojol. Li stojole xuꞌ jaꞌ ta xꞌacꞌbatic li meꞌonetique ―xijchicutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Li Jesuse snaꞌoj li cꞌusi la jnopcutique, jech laj yalbuncutic: ―¿Cꞌu chaꞌal chavaqꞌuic xcꞌopoj yoꞌon li antse yuꞌun lec li cꞌusi la yacꞌbune? ");
INSERT INTO tzoSA_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Li meꞌonetique scotol cꞌacꞌal liꞌ achiꞌuquique. Yan li joꞌone mu scotoluc cꞌacꞌal liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ti jech la smalbun muil vomol li antse, jaꞌ sventa li cꞌalal chimuquee. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Melel li cꞌusi chacalbeique, ti buyuc noꞌox chichꞌ alel ta spꞌejel balumil ti jaꞌ noꞌox chcolic ta jventae, te chalic nojtoc li cꞌusi laj yacꞌbun li antse. Jech ta snaꞌic o scotol crixchanoetic ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oy jununcutic ti lajchavoꞌuncutic ti yajchanbalajeltacuncutic li Jesuse, jaꞌ Judas Iscariote sbi. Jaꞌ ba scꞌopon li banquilal paleetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jech laj yalbe: ―¿Cꞌu yepal chavacꞌbecun mi chcacꞌ ta acꞌobic li Jesuse? ―xut. Iꞌacꞌbat lajuneb schaꞌvinic (30) saquil taqꞌuin. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Li Judase jaꞌ xa noꞌox smalaoj cꞌu ora tspas ta canal chacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta sliqueb qꞌuin cꞌalal ta jveꞌtic pan ti muc bu yichꞌoj svochesobile, jech ba jacꞌbecutic Jesús, joꞌoncutic li yajchanbalajeltacuncutique: ―¿Bu chacꞌan chba jmeltsancutic li chexel chij ti chalajes ta sventa li qꞌuin Coltaele? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Itacꞌav li Jesuse: ―Batanic ta Jerusalén. Te chcꞌot ataic li jun vinic ti lec xcojtaquine. Jech xavalbeic: “Jutuc xa scꞌan sta yorail chimile. Liꞌ chtal jlajescutic ta ana li chij sventa li qꞌuin Coltaele, xi li cajchanubtasvanejtique”, utic cꞌotel ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Joꞌoncutic li yajchanbalajeltacuncutique la jchꞌuncutic li cꞌusi laj yalbuncutic li Jesuse, la jmeltsancutic li veꞌlil sventa li qꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cꞌalal iꞌoch acꞌubale, te lijchoticutic jcotolcutic ta mexa schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cꞌalal yacuncutic ta veꞌele, jech laj yalbuncutic li Jesuse: ―Melel chacalbeic, oy junoxuc li joꞌoxuque ti jaꞌ chiyacꞌ ta cꞌabale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Cꞌalal icaꞌicutique, icat coꞌoncutic jcotolcutic. Ta jujuntal la jacꞌbecutic li Jesuse: ―¿Mi joꞌon nan? Cajval ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Itacꞌav li Jesuse: ―Jaꞌ li buchꞌu ti jun jpulatucutic chijveꞌcutic jchiꞌuque jaꞌ chiyacꞌ ta cꞌabal. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta melel joꞌon li coꞌol crixchanoutique chimile jech chac cꞌu chaꞌal tsꞌibabil onoꞌox ta scꞌop li Diose. Toj abol sba li buchꞌu chiyacꞌ ta cꞌabale. Jaꞌ lec ti muꞌyucuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Li Judase, jaꞌ li buchꞌu snopoj xa onoꞌox ta xacꞌ ta cꞌabal li Jesuse, jech la sjacꞌbe eꞌuc: ―¿Mi joꞌon nan? Jchanubtasvanej ―xi. Itacꞌav li Jesuse: ―Joꞌot ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cꞌalal yacaluncutic ta veꞌele, la stam jpꞌej pan li Jesuse, laj yalbe coliyal Dios, la xut li pane, laj yacꞌbuncutic jcotolcutic. Jech laj yal: ―Ilo, veꞌanic. Liꞌi jaꞌ jbecꞌtal ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","La stsac nojtoc jun vaso yaꞌlel tsꞌusub, laj yalbe coliyal Dios, laj yacꞌbuncutic. Jech laj yal: ―Uchꞌanic acotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Liꞌi jaꞌ jchꞌichꞌel, jaꞌ senyail ti mu xlaj scꞌoplal ti cꞌusi iyal ta tsꞌacal li Jtot sventa chacolic oe. Yuꞌun jtuc chcacꞌ jba ta milel, ta jmal jchꞌichꞌel, jaꞌ jech ta xtoj o smulic scotol li crixchanoetique. Jech oy ep buchꞌutic tspasbatic o perton yuꞌun li smulique. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chacalbeic ti jaꞌ to chcuchꞌ nojtoc li yaꞌlel tsꞌusube ti cꞌalal te xa tsobolutic jcotoltic li yoꞌ bu ta jpas mantal yuꞌun li Jtote ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cꞌalal la jqꞌueojintacutic jun sqꞌueoj Dios, lijlocꞌcutic batel, lijbatcutic ta vits Olivatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Li Jesuse jech laj yalbuncutic: ―Tanae chavictaicun acotolic. Yuꞌun jech onoꞌox tsꞌibabil ta scꞌop Dios: “Chcacꞌ ta milel li buchꞌu cacꞌojbe yabtel ti chasventainique. Cꞌalal mi imilee, ta spuc sbaic batel li schiꞌiltaque jech chac cꞌu chaꞌal ta spuc sbaic batel li chijetic mi imile li yajchabivanejique”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Cꞌalal chaꞌcuxiemun xaꞌoxe, joꞌon baꞌi chibat ta Galilea balumil, tsꞌacal to chabatic. Te chcꞌot ataicun ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Itacꞌav li Pedroe: ―Acꞌo mi chayictaic scotolic, li joꞌone muc bu chaquicta ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Li Jesuse jech laj yalbe: ―Melel li cꞌusi chacalbee, tana cꞌalal muc toꞌox bu oqꞌuem jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Itacꞌav li Pedroe: ―Acꞌo mi coꞌol chijmile, pero jamal chcal ti xacojtaquine ―xi. Jaꞌ noꞌox jech icalcutic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Te lijcꞌotcutic schiꞌuc Jesús li yoꞌ bu Getsemaní sbie. Jech laj yalbuncutic li Jesuse: ―Chotlanic comel liꞌi yuꞌun chba jta ta naꞌel Dios leꞌe ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Li Jesuse laj yicꞌ echꞌel Pedro schiꞌuc li chaꞌvoꞌ snichꞌnab Zebedeoe. Lic yat tajmec yoꞌon li Jesuse. Jech xa noꞌox toj chopol yoꞌon chaꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jech laj yalbe li oxvoꞌique: ―Toj echꞌem ta xcat coꞌon, jun chac chicham chcaꞌi. Comanic liꞌi. Mu me xꞌoch avayelic, taic ta naꞌel Dios jech chac cꞌu chaꞌal ta jta ta naꞌele ―xꞌutatic yuꞌun Jesús li oxvoꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ibat xi snamal li Jesuse. La spatan sba ta lumtic, la sta ta naꞌel Dios: ―Tata, ti jech la chacꞌan ti mu xichame, lec chcaꞌi. Pero maꞌuc me xcꞌot ta pasel li cꞌusi ta jcꞌan jtuque. Jaꞌ acꞌo jpas li cꞌusi chacꞌan atuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Cꞌalal ilaj yoꞌon ta stael ta naꞌel Dios li Jesuse, isut talel li yoꞌ bu oyic li oxvoꞌ jchiꞌiltaque. Vayalic cꞌot sta. Li Jesuse jech laj yalbe li Pedroe: ―¿Mi mu xuꞌ avuꞌunic acoltaicun ta stael ta naꞌel Dios jliqueluc? ");
INSERT INTO tzoSA_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jaꞌ lec julavanic, taic ta naꞌel Dios yoꞌ jech mu xaspasic ta canal li pucuje. Ta melel chacꞌan chataic ta naꞌel Dios pero jaꞌ noꞌox chaschꞌayic la abecꞌtalique. Naca vayel chasmilic ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ba sta ta naꞌel Dios schibal velta li Jesuse: ―Tata, yuꞌun avaloj ti chichame, xuꞌ chicham jech chac cꞌu chaꞌal chacꞌane ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Isut talel schibal velta li Jesuse. Vayalic cꞌot sta nojtoc yuꞌun mu xvicꞌ satic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Te icomic nojtoc yuꞌun ba sta ta naꞌel Dios yoxibal velta. Jaꞌ noꞌox jech la schaꞌal jech chac cꞌu chaꞌal iyal li cꞌalal la sta ta naꞌel Dios baꞌie. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ital ta yoxibal velta li Jesuse, jaꞌ jech iyalbe li oxvoꞌ jchiꞌiltaque: ―¿Mi yoquel to vayaloxuc? ¿Mi mu xviqꞌuej asatic? Ista xa yora chiꞌaqꞌue ta scꞌob jpasmuliletic, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Licanic, batic. Qꞌuelavilic, leꞌ xa xtal li buchꞌu chiyacꞌ ta cꞌabale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Cꞌalal jaꞌ o yacal ta loꞌil li Jesuse, ital li Judase, jaꞌ jun jchiꞌilcutic toꞌox ti lajchavoꞌuncutique. Ep crixchanoetic schiꞌuc talel, yichꞌojic talel smachitaic schiꞌuc steꞌic. Jaꞌ tacbilic talel yuꞌun li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuntic, joꞌotic li jꞌisraelutique. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Li Judase, jaꞌ li jꞌacꞌvanej ta cꞌabale, yaloj xa onoꞌox cꞌu sba chacꞌ ta ilel ti buchꞌu junucal li Jesuse: ―Li buchꞌu ta jtsꞌutsꞌune, yuꞌun xa onoꞌox me jaꞌ li Jesuse. Jaꞌ o me xba atsaquic ―xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Li Judase inopoj batel ta ora ta stojol li Jesuse, jech laj yalbe: ―Jchanubtasvanej ―xut. La stsꞌutsꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Li Jesuse jech laj yalbe: ―¿Mi jaꞌ xa tal apas li cꞌusi anopoje? ―xut. Jaꞌ o inopojic talel ta ora li crixchanoetique, la stsaquic li Jesuse, la schuquic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Oy jununcutic li yajchanbalajeltacuncutic li Jesuse, la sloqꞌues smachita, la sjaxbe ta bojel jun schiquin li yajtunel li más banquilal palee. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Li Jesuse jech laj yalbe: ―Ticꞌo ta sna la amachitae. Li buchꞌu ta xacꞌ machitae jaꞌ noꞌox jech ta machita ta xlaj. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mi mu xanaꞌ ti xuꞌ ta jta ta naꞌel ta ora li Jtote jech chistacbe talel más ta oxvinic ta mil (60,000) yajꞌangeltac yoꞌ chtal scoltaicun? ");
INSERT INTO tzoSA_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero maꞌuc jech ta jpas yuꞌun persa ta xcꞌot ta pasel li cꞌusi tsꞌibabil ta scꞌop Dios ta voꞌone ti yaloj onoꞌox ti chcꞌot ta pasele ―xꞌutat yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Li Jesuse la scꞌopon scotol li crixchanoetique, jech laj yalbe: ―¿Cꞌu chaꞌal tal atsaquicun jech chac cꞌu chaꞌal jun jꞌelecꞌ, tsꞌaclomoxuc xa talel ta amachitaic, ta ateꞌic? Yuꞌun scotol cꞌacꞌal te chotolun ta yamaqꞌuil li mucꞌta chꞌulnae, te lichanubtasvan. ¿Cꞌu chaꞌal mu teuc noꞌox la atsaquicun? ");
INSERT INTO tzoSA_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ti jech la atsaquicune, jaꞌ icꞌot ta pasel ti jech tsꞌibabil onoꞌox yuꞌun li buchꞌutic iyalic scꞌop Dios ta voꞌonee ―xi li Jesuse. Joꞌoncutic li yajchanbalajeltacuncutique lijatavcutic batel jcotolcutic, stuc te laj quictacutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Cꞌalal la stsaquic li Jesuse, laj yiqꞌuic batel ta stojol Caifás, jaꞌ li más banquilal palee. Te tsobolic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletic cuꞌuntique. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Li Pedroe nomnom tijil batel ta spat Jesús cꞌalal to icꞌotic ta yamacꞌ li más banquilal palee. Iꞌoch batel, la schiꞌin ta chotlej li yajmayoltac li banquilal palee yuꞌun chac sqꞌuel cꞌu sba ta xichꞌ meltsanbeel scꞌoplal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuntique lic saꞌic chaꞌvoꞌ schiꞌiltaquic ta abtel ti coꞌol li cꞌusi chalique yoꞌ ta saꞌbeic o smul li Jesuse, yuꞌun tscꞌanic ti acꞌo chamuque. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero muc bu staic chaꞌvoꞌ ti coꞌol li cꞌusi chalique. Altic ti ep la sjutic cꞌop ta stojol li Jesuse. Ta tsꞌacale ivaꞌiic yan chaꞌvoꞌ jutcꞌopetic nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jech laj yalic: ―Li vinic liꞌi yaloj ti xuꞌ yuꞌun ta sjines li smucꞌta chꞌulna li Diose. Ta oxib la cꞌacꞌal ta schaꞌvaꞌan nojtoc ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Li más banquilal palee ivaꞌi, jech la sjacꞌbe li Jesuse: ―¿Cꞌu chaꞌal mu xatacꞌav? ¿Mi melel li cꞌusi chalique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mu jpꞌeluc bu itacꞌav li Jesuse. Li más banquilal palee la sjacꞌbe nojtoc li Jesuse: ―Ta xaꞌi li cuxul Dios ti jech chajacꞌbote. Albun ta jamal mi joꞌot Cristoot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique. ¿Mi joꞌot Snichꞌonot li Diose? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Itacꞌav li Jesuse: ―Joꞌon ―xi―. Chacalbeic nojtoc, joꞌon li coꞌol crixchanoutique chavilic chlic jventainan crixchanoetic ta stsatsal sjuꞌel Dios. Tsꞌacal to chilic scotol crixchanoetic ti chital ta toc ta vinajele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Li más banquilal palee la sjat scꞌuꞌ yuꞌun la snop ti istabe xa tsots smul li Jesuse. Jech laj yal: ―Avaꞌiic xa ti ta spꞌis sba ta Diose. ¿Cꞌu chaꞌal ta jsaꞌtic yan textico? La avaꞌiic xa ti ta stoy sba ta stojol li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Cꞌusi chanopic eꞌuc? ―xut li schiꞌiltac ta abtele. Itacꞌavic: ―Acꞌo chamuc ta jꞌechꞌel ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lic stubtabeic sat li Jesuse, la smajic. Oy yanetic la slecꞌbeic ta majel xocon sat. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Jech laj yalbeic: ―Joꞌot ti Cristoot chavale, alo buchꞌu li la smajote ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Li Pedroe te chotol ta amacꞌ. Tal cꞌoponatuc yuꞌun jun criara: ―Joꞌote jaꞌ achiꞌin eꞌuc li Jesús li liquem talel ta Galilea balumile ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Li Pedroe laj yal ta stojol scotolic ti mu xojtaquin li Jesuse: ―Mu jnaꞌ li cꞌusi chavale ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Te ibat ta tiꞌmoc li Pedroe. Te iꞌojtaquine yuꞌun yan criara. Li criarae laj yalbe li buchꞌutic te oyique: ―Leꞌe jaꞌ la schiꞌin li Jesús li liquem talel ta Nazarete ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Li Pedroe la stꞌabbe sbi Dios li cꞌalal jech iyale: ―Xilchox mu xcojtaquin li vinic chavale ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ta jliquel tal cꞌoponatuc yuꞌun yanetic li Pedroe, jech laj yalbeic: ―Ta melel jaꞌ achiꞌil li Jesuse yuꞌun jaꞌ jech acꞌopojel ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lic chopolcꞌopojuc li Pedroe, la stꞌabbe sbi Dios nojtoc: ―Xilchox mu xcojtaquin li vinic chavalique ―xi. Jaꞌ o iꞌocꞌ jcots. ");
INSERT INTO tzoSA_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ijul ta sjol li Pedro ti jech onoꞌox iꞌalbat yuꞌun li Jesuse: “Cꞌalal muc toꞌox bu oqꞌuem jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune”, xꞌute onoꞌox yuꞌun li Jesuse. Ilocꞌ batel li Pedroe, toj echꞌem laj yoqꞌuita sba. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cꞌalal isacube, scotol li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuntic, joꞌotic li jꞌisraelutique, la spasic ta jmoj scꞌopic ti cꞌu sba ta smilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chucul iyiqꞌuic batel, cꞌot yacꞌbeic ta scꞌob li gobernadore, jaꞌ li Poncio Pilatoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Li Judase, jaꞌ li buchꞌu laj yacꞌ ta cꞌabal li Jesuse, cꞌalal iyil ti imeltsaj xa scꞌoplal ti ta xmile li Jesuse, lic snop ti ta sutes li lajuneb schaꞌvinic (30) saquil taqꞌuin li iꞌacꞌbat yuꞌun li banquilal paleetique schiꞌuc li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jech cꞌot yalbe li banquilal paleetique schiꞌuc li jꞌabteletique: ―Ijta xa jmul yuꞌun laj cacꞌ ta cꞌabal li buchꞌu muꞌyuc smule ―xi cꞌotel li Judase. Itacꞌavic li banquilal paleetic schiꞌuc li jꞌabteletique: ―Mu xa cꞌu jventacutic o li joꞌoncutique. Joꞌot xa ta aba atuc ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Li Judase la sjip ochel ta yut mucꞌta chꞌulna li taqꞌuine, ilocꞌ batel, ba schuc snucꞌ ta chꞌojon, jech la smil sba stuc. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Li banquilal paleetique la stsobic li taqꞌuine. Jech la snopic: ―Mu lecuc mi ta jcaptic ta smoton Dios li taqꞌuin liꞌi, yuꞌun jaꞌ stojol schꞌichꞌel jun vinic ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La snopic ti ta smanic o jsetꞌuc osil sventa smuquenalic li buchꞌutic nom talemic ti yan o slumalique. Jaꞌ yosil li jpatpꞌine. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Li osile Yosil Chꞌichꞌ la sbiin yuꞌunic. Jaꞌ jech sbi o cꞌalal tana. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jech icꞌot ta pasel li cꞌusi laj yal li Jeremías li iyal scꞌop Dios ta voꞌonee: “Ta stsobic li lajuneb schaꞌvinic (30) saquil taqꞌuine, jaꞌ stojol li jchiꞌiltic ti mu xcꞌane yuꞌun li jchiꞌiltactic ti chventainvane. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jaꞌ ta smanbeic o yosil li jpatpꞌine jech chac cꞌu chaꞌal laj yalbun li Diose”, xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Li Jesuse te oy ta stojol Pilato. Jech ijacꞌbat: ―¿Mi joꞌot mucꞌta ajvalilot yuꞌun la achiꞌiltac ta israelale? ―xꞌutat. Itacꞌav li Jesuse: ―Joꞌon ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuntique la saꞌbeic smul li Jesuse, pero mu jpꞌeluc itacꞌav li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Li Pilatoe jech laj yalbe li Jesuse: ―¿Mi muc xavaꞌi li cꞌu sba a stiqꞌuic amule? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mu jpꞌeluc bu itacꞌav li Jesuse. Li Pilatoe toj chꞌayel noꞌox yoꞌon ti cꞌalal iyaꞌi ti muc spac scꞌoplal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Li Pilatoe jech stalel onoꞌox ti ta jujun qꞌuin Coltael ta scolta jun jchuquel li bu junucal ta scꞌanbeic scolel li jchiꞌiltactique. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te tiqꞌuil ta chuquel jun jchiꞌiltic ta israelal ti vinajem scꞌoplal ti toj chopole, Barrabás sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cꞌalal te tsobolic scotol li jchiꞌiltactique, jech la sjacꞌ li Pilatoe: ―¿Buchꞌu junucal chacꞌanic ti ta jcoltae? ¿Mi jaꞌ chacꞌanic ti ta jcolta li Barrabase, mi jaꞌ chacꞌanic ti ta jcolta li Jesús ti yaloj ti jaꞌ tꞌujbil yuꞌun Dios ti chasventainique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yuꞌun snaꞌoj onoꞌox li Pilato ti ta scoj ti xtiꞌet noꞌox yoꞌonic li banquilal paleetic ti jech laj yaqꞌuic ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cꞌalal te chotol li Pilato li yoꞌ bu ta xal ti cꞌu sba chcom scꞌoplal li buchꞌu ta smeltsanbe scꞌoplale, la stac talel mantal li yajnile, jech laj yal talel: “Pꞌijan me, mu me cꞌusi chopol xapasbe li lequil vinique. Yuꞌun la jvaychin samel li vinique. Toj echꞌem icat coꞌon yuꞌun”, xi li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuntique la schanubtasic li crixchanoetic ti jaꞌ noꞌox acꞌo scꞌanbeic scolel li Barrabase, pero li Jesuse: ―Alic ti acꞌo mileuque ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Li Pilatoe la sjacꞌbe nojtoc li crixchanoetique: ―¿Buchꞌu junucal chacꞌanic ti chajcoltabeique? ―xut. Itacꞌavic: ―Jaꞌ coltao li Barrabase ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jech laj yal nojtoc li Pilatoe: ―¿Cꞌusi chacꞌanic ta jpasbe li Jesús ti yaloj ti ja tꞌujbil yuꞌun Dios ti chasventainique? ―xi. Itacꞌavic scotolic: ―¡Jocꞌano ta cruz! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Li Pilatoe jech laj yal: ―Pero ¿cꞌusi smul avuꞌunic? ―xi. Tsots itacꞌav scotolic: ―¡Jocꞌano ta cruz! ―xiic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cꞌalal laj yil Pilato ti muꞌyuc ta ventae, ti toj echꞌem chcꞌopojic ch‐avanic li jchiꞌiltactique, la stsac joꞌ, la spoc scꞌob ta stojol li jchiꞌiltactique. Jech laj yalbe: ―Mu ta jmuluc mi ta xmile li lequil vinic liꞌi; joꞌoxuc ta amulic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jech itacꞌavic scotolic: ―Acꞌo comuc ta jbacutic jchiꞌuc calab jnichꞌnabcutic ti ta xmilee ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Li Pilatoe la sloqꞌues ta chuquel li Barrabase. Pero li Jesuse iꞌaqꞌue ta scꞌob soltaroetic yoꞌ acꞌo stsitsic ta nucul, tsꞌacal to chba sjocꞌanic ta cruz. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Li yajsoltarotac li gobernadore laj yiqꞌuic ochel ta yut cavilto li Jesuse. La stsob sbaic scotol li soltaroetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","La slocꞌbeic scꞌuꞌ li Jesuse, la slapbeic tsajal cꞌuꞌil. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","La xotic chꞌix, la xojbeic ta sjol sventa scorona. Laj yacꞌbeic jtel aj ta sbatsꞌicꞌob sventa svaxton. La squejan sbaic ta stojol yuꞌun ta snaꞌleic. Jech laj yalbeic: ―¡Toj lec mucꞌta ajvalilot avaꞌuc yuꞌun la achiꞌiltac ta israelale! ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","La stubtaic. La spojbeic li aje, la sjisbeic ta sjol. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cꞌalal ilaj yoꞌonic ta snaꞌleele, la slocꞌbeic li tsajal cꞌuꞌile, la slapbeic li scꞌuꞌ onoꞌoxe. Laj yiqꞌuic batel, ba sjocꞌanic ta cruz. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cꞌalal iloqꞌuic batel li soltaroetic schiꞌuc li Jesuse, te la snupic ta be jun jchiꞌiltic ta israelal, Simón sbi. Cirene sbi li slumale. Iyacꞌbeic echꞌel sqꞌuechbeel scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Te icꞌotic li yoꞌ bu Gólgota sbie, jaꞌ “Baquil Jolil”, xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Te laj yacꞌbeic yuchꞌ pajal yaꞌlel tsꞌusub capal ta chꞌail vomol. Taꞌox xuchꞌ li Jesuse pero muc bu xuchꞌ yuꞌun iyaꞌi ti jaꞌ smacobil scꞌuxul li svocol ti ta xichꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Li soltaroetique la sjocꞌanic ta cruz li Jesuse. Ta tsꞌacale la spasic canal tajimol yoꞌ jech chilic bu jlicucal li scꞌuꞌ spacꞌaltac Jesús ti chichꞌbeic jujunique. Jaꞌ icꞌot ta pasel ti jech onoꞌox laj yal li buchꞌu iyal scꞌop Dios to voꞌonee: “Ta spasic canal tajimol yoꞌ jech chilic bu jlicucal li jcꞌuꞌ jpacꞌaltac ti chichꞌic jujunique”, xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te la schotan sbaic li soltaroetique, la schabiic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","La sbajbeic jpech teꞌ ta sjol scruzal li Jesuse, jaꞌ li bu tsꞌibabil ti cꞌusi smul ti la smilique. Jech chal: “Liꞌi jaꞌ Jesús, jaꞌ li mucꞌta ajvalil yuꞌun li jꞌisraeletique”, xi tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oy chaꞌvoꞌ jꞌeleqꞌuetic coꞌol la sjocꞌanic ta cruz schiꞌuc li Jesuse, jun cruz ta sbatsꞌicꞌob, jun ta stsꞌetcꞌob li scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Li buchꞌutic te iꞌechꞌique inaꞌlevanic eꞌuc, isjimulan sjolic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Jech laj yalic: ―Ti aval chajines li mucꞌta chꞌulnae, ti ta oxib noꞌox cꞌacꞌal chachaꞌvaꞌan chavale, colta aba atuc. Mi melel ti joꞌot Snichꞌonot li Diose, yalan ta cruz ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jaꞌ jech inaꞌlevanic eꞌuc li banquilal paleetique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletic cuꞌuntique. Jech laj yalic: ");
INSERT INTO tzoSA_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―La scoltaan li crixchanoetique pero li stuc juꞌune, mu xuꞌ tscolta sba. Mi melel ti jaꞌ mucꞌta ajvalil cuꞌuntic, joꞌotic li jꞌisraelutique, acꞌo yaluc ta ora ta cruz. Jaꞌ to ta jchꞌuntic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Laj yal ti ta xcoltaat yuꞌun li Diose, jech acꞌo coltaatuc ta ora mi melel ti lec ta xꞌile yuꞌun li Diose. Yuꞌun yaloj onoꞌox ti jaꞌ Snichꞌon li Diose ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jaꞌ jech inaꞌlevanic eꞌuc li chaꞌvoꞌ jꞌeleqꞌuetic li te jocꞌajtic ta cruz schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cꞌalal oꞌlol xaꞌox cꞌacꞌale, imac sat li cꞌacꞌale, icom ta icꞌal acꞌubal. Jaꞌ to ta oxib ora ta mal cꞌacꞌal ijam. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta oxib ora ta mal cꞌacꞌale tsots icꞌopoj li Jesuse: ―Elí, Elí ¿lama sabactani? ―xi. “Dios cuꞌun, Dios cuꞌun, ¿cꞌu chaꞌal la atenun ta avoꞌon?” xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oy jayvoꞌ buchꞌutic iyaꞌiic, jech laj yalic: ―Jaꞌ chapta li Elíase ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ibat ta anil jun vinic, ba stsac talel jpꞌej li cꞌusi cꞌunputsane. La stsꞌaj ta pajal yaꞌlel tsꞌusub, la xoj ta aj, laj yacꞌbe stsꞌuꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jech iꞌalbat yuꞌun li yanetique: ―Jmalatic, jqꞌueltiquic mi chtal yalesatuc ta cruz yuꞌun li Elíase ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Li Jesuse tsots to icꞌopoj, jaꞌ xa o ilocꞌ schꞌulel. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Li mucꞌta pocꞌ li te lichꞌil ta yut li mucꞌta chꞌulnae, ijat ta oꞌlol. Ijat yalel cꞌalal olon. Tsots inic li balumile. Li mucꞌtic tonetique laj vocꞌanuc ta oꞌlol. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ep muquenaletic laj jamuc. Ichaꞌcuxiic li buchꞌutic yichꞌojic ta mucꞌ li Dios li cꞌalal ichamique. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iloqꞌuic ta smuquenalic pero muc bu xꞌochic ba ta ora ta Jerusalén. Jaꞌ to iꞌochic li cꞌalal ichaꞌcuxi loqꞌuel ta smuquenal li Jesuse. Te iꞌileic yuꞌun ep crixchanoetic li te ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Li banquilal soltaro schiꞌuc li yajsoltarotac li te ta xchabiic li Jesuse, toj xiꞌelic noꞌox li cꞌalal iyaꞌiic inic li balumile schiꞌuc cꞌalal iyilic scotol li cꞌustic icꞌot ta pasele. Jech laj yalbe sbaic: ―Ta melel jaꞌ snichꞌon Dios li vinic liꞌi ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cꞌalal jocꞌol xaꞌox ta cruz li Jesuse, te oy ep antsetic nomnom tsqꞌuelic talel. Jaꞌ li antsetic li la schiꞌinic ta xanbal li Jesús li ta Galilea balumile, schiꞌuc ti la smacꞌlanique. Jaꞌ la schiꞌinic talel cꞌalal ta Judea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Te oy li María li liquem talel ta Magdalae, schiꞌuc otro jun María, jaꞌ li smeꞌic Jacobo schiꞌuc li Josee. Te oy nojtoc li smeꞌic li snichꞌnab Zebedeoe, jaꞌ li Jacobo schiꞌuc li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Te oy jun jcꞌulej vinic, jaꞌ jchiꞌiltic. Liquem talel ta jteclum Arimatea. José sbi. Schꞌunoj eꞌuc ti jaꞌ Cajcoltavanejtic li Jesuse. Cꞌalal xtupꞌet xaꞌox osile, li Josee ba scꞌopon Pilato, ba scꞌanbe li sbecꞌtal stacupal li Jesuse. Li Pilatoe laj yal mantal ti acꞌo yacꞌbeel batele. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Li Josee laj yicꞌbe batel sbecꞌtal stacupal li Jesuse, la spix ta saquil pocꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ba smuc ta jombil chꞌut chꞌen. Jaꞌ smuquenal li Josee. La stselelin talel jpech mucꞌta ton, jaꞌ la smac o comel li tiꞌchꞌene, ibat. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Li María li liquem talel ta Magdalae schiꞌuc li otro jun Maríae, te chotol icomic ta stuqꞌuil tiꞌchꞌen. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cꞌalal iꞌechꞌ xaꞌox li scꞌacꞌalil ta jchapan jbatic sventa ta jcuxtic ta savaroe, la stsob sbaic talel scotol li banquilal paleetique schiꞌuc li jfariseoetique. Te italic ta stojol li Pilatoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jech cꞌot yalbeic: ―Ajvalil, jnaꞌojcutic ti jech yaloj li jloꞌlovanej li cꞌalal cuxul toꞌoxe: “Ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal”, xi iyal. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Alo mantal ti acꞌo ba yichꞌ chabiel oxibuc cꞌacꞌal li smuquenale naca me xtal loqꞌuesbatuc sbecꞌtal stacupal ta acꞌubaltic yuꞌun li yajchanbalajeltaque. Naca me jech ta xalbeic li crixchanoetique: “Ichaꞌcuxi xa loqꞌuel ta smuquenal”, naca me xiic, jech más to echꞌem ta xloꞌloatic o li crixchanoetique ―xutic li Pilatoe. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Itacꞌav li Pilatoe: ―Te oy soltaroetic, iqꞌuic batel. Ba pasic li cꞌu sba xanaꞌic schabiele ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jech ibatic, ba smacbeic lec li stiꞌ smuquenale. La spaqꞌuic comel li spat xocon li mucꞌta ton li macbil o stiꞌ li chꞌene. Laj yacꞌbeic seyoal li bu pacꞌbile. Te laj yacꞌbeic comel schabiic li soltaroetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cꞌalal echꞌem xaꞌox li scꞌacꞌalil ta jcuxtique, poꞌot xaꞌox sacub ta sba cꞌacꞌal ta xemana, jaꞌ li romincoe, ba sqꞌuelbeic smuquenal Jesús li María li liquem talel ta Magdalae schiꞌuc li otro jun Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cꞌalal muc toꞌox bu batemique, tsots inic li balumile yuꞌun iyal talel ta vinajel jun yajꞌangel li Cajvaltic Diose. Te jul stselelin loqꞌuel li mucꞌta ton li macbil o stiꞌ li chꞌene, te ichoti ta sba. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Li chꞌul ángele oy xojobal jaꞌ jech chac cꞌu chaꞌal li slebuel chauque. Batsꞌi sac tajmec li scꞌuꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cꞌalal iyilic li chꞌul ángel li soltaroetic ti la schabiic li chꞌene, iniquic tajmec ta xiꞌel, chamem icomic yilel. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Li chꞌul ángele jech laj yalbe li antsetique: ―Mu xaxiꞌic. Jnaꞌoj ti jaꞌ chasaꞌic li Jesús ti te icham ta cruze. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mu xa bu liꞌi; ichaꞌcuxi xa jech chac cꞌu chaꞌal yalojboxuc onoꞌoxe. Laꞌ qꞌuelavilic li bu toꞌox la stelanique. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Batanic ta ora, ba albeic li yajchanbalajeltaque ti chaꞌcuxiem xae. Albeic ti jaꞌ baꞌi ta xcꞌot ta Galilea li Jesuse. Te chcꞌot staic, te chilbeic sat. Jaꞌ noꞌox jech chacalbeic ―xꞌutatic yuꞌun li chꞌul ángele. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Li antsetique ixiꞌic loqꞌuel li ta chꞌene, italic ta anil. Xmuybajic xa tal yalbuncutic, joꞌoncutic li yajchanbalajeltacuncutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cꞌalal yaquic talel ta xanbale, te isnupic ta be li Jesuse. ―¿Bu chabatic? ―xꞌutatic. Li antsetique la squejan sbaic ta stojol li Jesuse, la smeybeic yoc yuꞌun laj yichꞌic ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jech iꞌalbatic yuꞌun li Jesuse: ―Mu xaxiꞌic. Ba albeic li quermanotactic ti acꞌo baticuc ta Galileae, jaꞌ li buchꞌutic coꞌol quichꞌojtic ta mucꞌ li Jtotic Diose. Te chcꞌot staicun ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cꞌalal naca toꞌox isutic batel li antsetique, jaꞌ o icꞌotic ta jteclum jayvoꞌ li soltaroetic li la schabibeic li smuquenal li Jesuse. Ba yalbeic li banquilal paleetic scotol li cꞌustic icꞌot ta pasel ta stojolique. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Li banquilal paleetique la stsob sbaic ta ora scotolic schiꞌuc li jꞌabteletic cuꞌuntique. Coꞌol la smeltsanbeic scꞌoplal li cꞌusi ta spasique. Iꞌacꞌbatic ep taqꞌuin li soltaroetique. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jech iꞌalbatic yuꞌun li banquilal paleetique: ―Jech me xavalic: “Ta acꞌubal cꞌalal jaꞌ o ochem jvayelcutique, a sloqꞌuesbeic sbecꞌtal stacupal Jesús li yajchanbalajeltaque”, chianic me. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mi iyaꞌi li gobernadore, joꞌoncutic chba jmeltsancutic la acꞌoplalique yoꞌ mu xamileic o ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Li soltaroetique la schꞌamic li taqꞌuine, jaꞌ jech laj yalic li cꞌu sba iꞌalbatique. Jaꞌ jech scꞌoplal cꞌalal tana ta stojol scotol li jchiꞌiltactic ta israelale ti muc bu chaꞌcuxiem li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Joꞌoncutic li buluchvoꞌuncutic ta yajchanbalajeltacuncutic li Jesuse, te lijbatcutic ta Galilea. Te lijcꞌotcutic ta vits li bu yalojbuncutic onoꞌox li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cꞌalal iquilcutic li Jesuse, la jquejan jbacutic ta stojol. Pero oy chaꞌoxvoꞌuncutic ti muc bu jchꞌuncutic ti jaꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Li Jesuse jech laj yalbuncutic: ―Joꞌon liꞌacꞌbat xa jventain scotol, schiꞌuc vinajel schiꞌuc balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaꞌ yuꞌun batanic ta spꞌejel balumil, ba albeic jcꞌop scotol li crixchanoetique. Acꞌbeic yil ti jventainojoxuc xae, jech ta xacꞌ sbaic ti acꞌo jventainic eꞌuque. Acꞌbo yichꞌic joꞌ ta sventa li Jtote, schiꞌuc ta jventa joꞌon li Nichꞌonilune, schiꞌuc ta sventa li Chꞌul Espíritue. Jaꞌ senyail ti yichꞌojicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chanubtasic jech chac cꞌu chaꞌal la jchanubtasoxuque yoꞌ jech ta schꞌunic eꞌuc scotol li cꞌustic laj calboxuque. Naꞌic me ti jchiꞌucoxuc scotol cꞌacꞌal cꞌalal ta slajeb cꞌacꞌale ―xijyutcutic li Jesuse.");
INSERT INTO tzoSA_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaꞌ jech ilic li lequil achꞌ cꞌope, jaꞌ ti chijcolutic ta sventa li Cajvaltic Jesucristoe, jaꞌ li Snichꞌon Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jaꞌ la stsꞌiba comel Isaías li iyal scꞌop Dios ta voꞌone, ti baꞌi ta xtal jun yajtacbalal li Diose ti ta xalbe scꞌoplal ti ta xtal li Cajvaltique. Jech tsꞌibabil: “Baꞌi ta jtac batel li cajtacbalale. Jaꞌ ta xalbe crixchanoetic ti chabate yoꞌ jech chayichꞌic ta mucꞌ”, xut Snichꞌon li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jaꞌ yuꞌun chlic jun jchiꞌiltic ta israelal. Tsots chal ta taqui jamaltic ti chtal li Cajvaltique. Jaꞌ yuꞌun ta xal nojtoc: “Ictaic scotol li cꞌustic chopol chapasique. Ichꞌbeic ta mucꞌ li scꞌope”, xi chalbe li jchiꞌiltactique, xi la stsꞌiba li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jaꞌ yuꞌun li Juan li te ta taqui jamaltique lic yal ti ta xacꞌbe yichꞌic joꞌ li buchꞌutic chictaic li cꞌustic chopol ta spasique yoꞌ jech ta spasbatic perton yuꞌun smulic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ba yaꞌibeic scꞌop Juan scotol li jchiꞌilcutic ta israelale li te nacalic ta Judea balumile, schiꞌuc li buchꞌutic te nacalic ta jteclum Jerusalene. Li buchꞌutic jamal iyalic ta stojol Juan li cꞌu sba smulique, iꞌacꞌbat yichꞌic joꞌ yuꞌun li Juane li te ta ucꞌum Jordane. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Li scꞌuꞌ li Juane jaꞌ jalbil tsotsil cameyo. Li schuc schꞌute nucul. Li sveꞌele xcꞌajben schiꞌuc spom mucꞌta pom. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Li Juane jech iyalbe li jchiꞌilcutic ta israelale: ―Oy to buchꞌu tsꞌacal ta xtal, jaꞌ más tsots yabtel yichꞌoj. Li joꞌone muc bu tsots cabtel quichꞌoj. Mu cꞌusi xuꞌ cuꞌun ta jcolta o. Acꞌo mi slocꞌbeel xonob, mu xuꞌ chcaꞌi yuꞌun mu cꞌusi xitun o. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Li joꞌone jaꞌ noꞌox laj cacꞌboxuc avichꞌic joꞌ. Yan li buchꞌu tsꞌacal ta xtale jaꞌ chacꞌ avichꞌic li Chꞌul Espíritue ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cꞌalal yacal ta xacꞌanbe yichꞌ joꞌ li jchiꞌiltac li Juane, jaꞌ o ilocꞌ batel ta jteclum Nazaret li ta Galilea balumil li Jesuse. Te icꞌot ta ucꞌum Jordán, te iꞌacꞌbat yichꞌ joꞌ eꞌuc yuꞌun li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cꞌalal ilocꞌ ta ucꞌum li Jesuse, iyil ta ora ti ijam li vinajele. Iyil iyal talel ta sba li Chꞌul Espíritue, coꞌol schiꞌuc jcot jculajteꞌ yilel. Jech iyichꞌ o li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Li Diose icꞌopoj talel ta vinajel, jech laj yal: ―Joꞌot Jnichꞌonot, toj cꞌuxot ta coꞌon. Ximuybaj noꞌox avuꞌun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cꞌalal laj xaꞌox yichꞌ joꞌ li Jesuse, iꞌacꞌbat snaꞌ yuꞌun li Chꞌul Espíritu ti acꞌo batuc ta taqui jamaltique. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chaꞌvinic cꞌacꞌal te ijocꞌtsaj ta taqui jamaltic. Jaꞌ noꞌox te oy teꞌtical chonetic. Li banquilal pucuje, jaꞌ li Satanase, tal sloꞌlo Jesús ti yaloje, pero li Jesuse icoltaat yuꞌun li yajꞌangeltac Dios ti cꞌu sjalil te oye. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cꞌalal ochem xaꞌox ta chuquel li Juane, li Jesuse ibat ta Galilea balumil. Ba yalbe yaꞌiic li jchiꞌilcutic ta israelal li lequil achꞌ cꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jech laj yal: ―Ista xa scꞌacꞌalil chasventainic li Diose. Ictaic scotol li cꞌustic chopol chapasique, chꞌunic li lequil achꞌ cꞌop ti laj cale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Li Jesuse ixanav batel ta tiꞌtiꞌnab li te ta Galilea balumile. Iyil te chaꞌvoꞌ jchiꞌilcutic ta israelal, Simón schiꞌuc yitsꞌin, li Andrés sbie. Te yaquic tstiqꞌuel ochel snutiꞌic li stsacobil schoyic ta nab yuꞌun ta stsaquic choy, yuꞌun jaꞌ yabtelic. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Li Jesuse jech laj yalbe: ―Laꞌ chiꞌinicun batel, chajeltabeic la avabtelique. Chajchanubtasic li cꞌu sba chba asaꞌbecun talel crixchanoetique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Laj yictaic ta ora li yabtelique, la schiꞌinic batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cꞌalal ijelavic batel jutuc li Jesuse schiꞌuc li chaꞌvoꞌique, iyil te oy yan chaꞌvoꞌ jchiꞌilcutic, Jacobo schiꞌuc li yitsꞌine, jaꞌ li Juan sbie. Jaꞌ snichꞌnab li Zebedeoe. Te tiqꞌuilic ta yut canava schiꞌuc li stotique yuꞌun yacal ta slutꞌilanic li snutiꞌic li stsacobil schoyique yuꞌun jatem. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iꞌiqꞌueic yuꞌun li Jesuse. Te laj yictaic ta ora li stotique schiꞌuc li scanavaique, jaꞌ la schiꞌinic batel li Jesuse. Li totile te icom ta canava schiꞌuc li svinictaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Icꞌotic ta jteclum Capernaum. Li ta scꞌacꞌalil ta jcuxcutique, iꞌoch Jesús ta schꞌulnaic li jchiꞌiltacutic ta israelale, te ichanubtasvan. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Li jchiꞌiltacutique toj chꞌayel noꞌox yoꞌonic ta sventa ti cꞌu sba ichanubtasvane. Toj lec ichanubtasvan yuꞌun lec snaꞌ li cꞌusi ta scꞌan li Diose. Muc bu jech ichanubtasvan jech chac cꞌu chaꞌal li jchiꞌilcutic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te oy jun jchiꞌilcutic ta chꞌulna ti ochem pucujetic ta yoꞌone. Tsots icꞌopoj, jech laj yalbe li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús, joꞌot li liquemot talel ta Nazarete, ¿cꞌu chaꞌal tal aticꞌ aba ta jtojolcutic? ¿Mi yuꞌun tal atacuncutic batel li yoꞌ bu chquichꞌcutic o vocole? Xacojtaquin buchꞌuot. Joꞌot Snichꞌonot li Diose, joꞌot ti muꞌyuc amule ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Li Jesuse la spajes li pucujetic ti te schꞌamunojbeic ye li vinique, jech laj yalbe: ―Anchanic, locꞌanic batel ta yoꞌon li vinique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Li pucujetique la stupꞌbeic yicꞌ li vinique. Toj tsots iꞌavanic, iloqꞌuic ta yoꞌon li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Toj chꞌayel noꞌox yoꞌonic scotol li crixchanoetique. Jech laj yalbe sbaic: ―¿Buchꞌu ti liꞌ taleme? Muc bacꞌne xquiltic li a sba la spase. Oy sjuꞌel. Xuꞌ yuꞌun ta sloqꞌues li pucujetique, chꞌunbil smantal ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Li cꞌusi la spas li Jesuse ipuc scꞌoplal ta ora ta spꞌejel Galilea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cꞌalal ilocꞌ ta chꞌulna li Jesús schiꞌuc Jacobo schiꞌuc Juan, ibatic ta snaic Simón schiꞌuc Andrés. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Li smeꞌniꞌ li Simone te puchꞌul ta stem yuꞌun ip ta cꞌocꞌ. Laj yalbeic Jesús li cꞌusi ip chaꞌi li jchamelajele. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Li Jesuse inopoj ba ta stem li jchamelajele, la stsacbe scꞌob, la snit liquel. Itupꞌ ta ora li scꞌacꞌale, lic macꞌlanvanuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cꞌalal xtupꞌet xaꞌox li osile, laj yiqꞌuic talel ta stojol Jesús ep jchamelajeletic schiꞌuc ep li buchꞌutic ochem pucuj ta yoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Te tsobol icꞌotic ta tiꞌna scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Li Jesuse la scoltaan li jchamelajeletique. Cꞌusiuc noꞌox chamelal ip chaꞌiique laj coluc yuꞌun scotol. Schiꞌuc la sloqꞌuesan scotol li pucujetic li ochem ta yoꞌonic li crixchanoetique. Mu xꞌaqꞌue cꞌopojicuc yuꞌun Jesús li pucujetique yuꞌun snaꞌojic ti jaꞌ li Snichꞌon li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta yocꞌomal icꞌ to ilic li Jesuse, ilocꞌ batel, ibat li yoꞌ bu muꞌyuc crixchanoetique. Te ba sta ta naꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Li Simón schiꞌuc li schiꞌiltaque ba saꞌic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cꞌalal istaique, jech laj yalbeic: ―Chasaꞌic scotol li crixchanoetique ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Itacꞌav li Jesuse: ―Batic li ta jujun jteclum li liꞌ noꞌox nopole. Yuꞌun chba calbe yaꞌiic li jchiꞌiltactic ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose, yuꞌun jaꞌ cabtel ti tacbilun talel liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ibat schiꞌuc li yajchanbalajeltac ta scotol chꞌulnaetic ta Galilea balumile. Ba yal ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose. La sloqꞌuesan nojtoc li pucujetic li ochem ta yoꞌonic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ital ta stojol Jesús jun jchiꞌilcutic ta israelal tsacbil ta cꞌaꞌel chamel. La squejan sba ta stojol li Jesuse. Ta sloqꞌuel yoꞌon jech laj yalbe: ―Mi xacꞌan xacoltabun li jchamele, coltaun. Jnaꞌoj ti scotol xuꞌ avuꞌune ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Li Jesuse la scꞌuxubin li jchamelajele. Laj yacꞌbe scꞌob ta sba, jech laj yalbe: ―Ta jcolta la achamele. Colan chaꞌa ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Icol ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Li Jesuse tsots laj yalbe mantal li vinique, jech laj yalbe: ");
INSERT INTO tzoSA_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Mu me buchꞌu xavalbe ti la jcoltaote. Jaꞌ noꞌox ba acꞌ aba ta ilel ta stojol li palee. Acꞌbo li smoton Dios jech chac cꞌu chaꞌal yaloj onoꞌox li Moisés ta voꞌonee, jaꞌ ta snaꞌic o li jchiꞌiltactic ti icol xa la achamele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ilocꞌ li vinique pero lic spuquin batel ti icoltaat yuꞌun li Jesuse. Ta scoj ti ipuquij scꞌoplal ti icoltavan li Jesuse, jaꞌ yuꞌun ta mucul xa ta xꞌoch ba li ta jteclumetique. Te noj oy li bu muꞌyuc crixchanoe. Pero ep crixchanoetic ba staic li Jesuse, buyuc noꞌox liquemic talel. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cꞌalal iꞌechꞌ xaꞌox jayib cꞌacꞌale, isut batel ta Capernaum li Jesús schiꞌuc li yajchanbalajeltaque. Li crixchanoetique iyaꞌiic ti te oy li ta schꞌomna li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","La stsob sbaic batel ta ora li yoꞌ bu oy li Jesuse. Mu xa xꞌochic o ta yut na, tsinilic cꞌalal ta tiꞌna. Li Jesuse laj yal li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Te qꞌuechbil talel ta stojol Jesús jun vinic ti muꞌyuc yipal jun yoc scꞌobe. Chanvoꞌ yajval la sqꞌuechic talel. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mu xuꞌ xꞌochic li yoꞌ bu oy li Jesuse yuꞌun stsinoj sbaic tajmec ochel li crixchanoetique. Te imuyic ta jolna yuꞌun pachꞌal li jolnae. La sjomic jutuc li jolnae yoꞌ xuꞌ ta schechic yalel li jchamelajele. Te icꞌot yuꞌunic li yoꞌ bu oy li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cꞌalal iyil Jesús ti schꞌunojic ti oy sjuꞌele, jech laj yalbe li jchamelajele: ―Jnichꞌon, pasbilot xa perton yuꞌun la amule ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te chotolic jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech la snop ta yoꞌonic: ");
INSERT INTO tzoSA_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Cꞌu chaꞌal jech ta xal li vinique? Ta spꞌis sba ta Dios. Muc buchꞌu xuꞌ chispasbutic perton yuꞌun jmultic, jaꞌ noꞌox Dios stuc”, xi ta yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Li Jesuse sqꞌueloj li cꞌusi la snop ta yoꞌonique, jech laj yalbe: ―¿Cꞌu chaꞌal ti chanopic jeche? ―xi li Jesuse―. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta melel buchꞌuuc noꞌox xuꞌ ta xal: “Pasbilot xa perton yuꞌun amul”, ti xie, yuꞌun mu vocluc ta alel. Jech nojtoc mu vocluc ta alel: “Lican, xanavan”, ti xijchie. Pero jaꞌ scꞌan chaqꞌuelic mi melel ta xcꞌot ta pasel yuꞌun li buchꞌu jech ta xale. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Joꞌone laj cal xa ti pasbil xa perton yuꞌun li smul li vinique. Qꞌuelic me li cꞌusi ta jpas li avie yoꞌ jech chanaꞌic o ti joꞌon noꞌox ta jpasbe perton yuꞌun smulic li crixchanoetic liꞌ ta balumile, joꞌon li coꞌol crixchanoutique ―xi li Jesuse. Li Jesuse jech laj yalbe li jchamelajele: ");
INSERT INTO tzoSA_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Joꞌon chacalbe, lican, ichꞌo batel la apope, batan ta ana ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ilic ta ora li jchamelajele, laj yichꞌ batel li spope, ilocꞌ batel ta stojol scotolic. Cꞌalal iyilic li crixchanoetique, toj chꞌayel noꞌox yoꞌonic. Laj yalic coliyal Dios ta sventa ti jech yacꞌojbe sjuꞌel jun vinique. Jech laj yalbe sbaic: ―Muc bu quilojtic ti oy buchꞌu jech sjuꞌele ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ichaꞌbat nojtoc ta tiꞌnab schiꞌuc li yajchanbalajeltac li Jesuse. Toj ep crixchanoetic la stsob sbaic ta stojol li Jesuse. Te lic chanubtasvanuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cꞌalal ijelav batel li Jesuse, te iyil Leví, jaꞌ snichꞌon Alfeo. Te chotol ta schotleb li yoꞌ bu ta stoj spatanic li crixchanoetique. Jech iꞌalbat yuꞌun li Jesuse: ―Laꞌ chiꞌinun batel ―xut. Li Levie la schiꞌin batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tsꞌacal to cꞌalal te ta xveꞌ ta mexa ta sna Leví li Jesuse, te oy nojtoc ep jtsobpatanetic schiꞌuc li buchꞌutic ti toj chopol cuxulique, yuꞌun te schiꞌuquic talel li Jesuse schiꞌuc li yajchanbalajeltaque. Te coꞌol la schiꞌinic ta chotlej ta mexa li Jesuse schiꞌuc li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te oyic nojtoc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc jayvoꞌ jfariseoetic. Iyilic ti coꞌol ta xveꞌ Jesús schiꞌuc li jtsobpatanetique schiꞌuc li jpasmuliletique. Jaꞌ yuꞌun laj yalbeic li yajchanbalajeltac li Jesuse: ―¿Cꞌu chaꞌal ta schiꞌin ta veꞌel li jtsobpatanetic schiꞌuc li jpasmuliletic la avajchanubtasvanejique? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Li Jesuse iyaꞌi li cꞌusi iyalique, jech itacꞌav: ―Li buchꞌutic muc bu ipique mu scꞌanic poxtael. Jaꞌ noꞌox ta scꞌanic poxtael li buchꞌutic ipique. Li joꞌone maꞌuc tal jsaꞌ li buchꞌutic muꞌyuc smulic ti yalojique. Jaꞌ tal jsaꞌ li jpasmuliletique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cꞌalal jaꞌ o yictaoj yiximic li yajchanbalajeltac li Juane schiꞌuc li yajchanbalajeltac li jfariseoetique, oy buchꞌutic tal sjacꞌbeic li Jesuse: ―Yictaoj yiximic li yajchanbalajeltac li Juane schiꞌuc li yajchanbalajeltac li jfariseoetique. ¿Cꞌu chaꞌal mu xicta yiximic eꞌuc la avajchanbalajeltaque? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Itacꞌav li Jesuse: ―Cꞌalal yacal nupunele, te oy li jnupunel quereme, jaꞌ yuꞌun mu xuꞌ ta xicta yiximic li yutsꞌ yalaltac li jnupunel quereme yuꞌun te to schiꞌuquic. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jaꞌ noꞌox jechic eꞌuc li cajchanbalajeltaque, mu jechuc o smelol ti ta xicta yiximique yuꞌun liꞌ to jchiꞌuquique. Jaꞌ to mi icꞌot scꞌacꞌalil ti chismilic li buchꞌutic chiscontrainique, jaꞌ to xuꞌ ta xicta yiximic li cajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Li buchꞌu ta schꞌun li cꞌusi ta xcale, persa ta xicta li cꞌusi schꞌunoj toꞌox ti jech ta xcol o ti yaloje. Persa ta sloqꞌuel yoꞌon ta schꞌun li cꞌusi ta xcale yoꞌ jech ta xcol o. Jech chac cꞌu chaꞌal li buchꞌu ta xpacꞌomaje, mu spacꞌ ta achꞌ pocꞌ ti muc toꞌox bu mutseme, yuꞌun mi imutse, ta xjat más li poco poqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jech nojtoc li achꞌ yaꞌlel tsꞌusub ti ta xa xpajube, muc buchꞌu ta schꞌol ta poco yav li pasbil ta nucule. Mi jech ta spasique, cꞌalal ta xvocan stuc li yaꞌlel tsꞌusube, ta xtꞌom li yave. Altic ta xmal scotol li yaꞌlel tsꞌusube. Li yave altic ta xchꞌay. Li achꞌ yaꞌlel tsꞌusub ti ta xa xpajube, jaꞌ scꞌan ti ta achꞌ yav ta xichꞌ chꞌolele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cꞌalal jaꞌ o scꞌacꞌalil ta jcuxtique, te ijelavic ta be ta trigotic schiꞌuc li yajchanbalajeltac li Jesuse. Li yajchanbalajeltaque la scꞌasic jaychex trigo. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iꞌileic yuꞌun jayvoꞌ jfariseoetic, jech iꞌalbat li Jesuse: ―Qꞌuelavil. ¿Cꞌu chaꞌal ta spasic la avajchanbalajeltac li cꞌusi mu xuꞌ jpastic li ta scꞌacꞌalil ta jcuxtique? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Itacꞌav li Jesuse: ―Aqꞌuelojic ta scꞌop Dios li cꞌusi la spas li David li cꞌalal iviꞌnajic schiꞌuc li schiꞌiltac ta xanbale. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te icꞌotic ta chꞌulna li cꞌalal jaꞌ o ochem ta banquilal pale li Abiatare. Li Davide la sveꞌ li pan li te oy ta ba mexa ta sventa smoton li Diose. Acꞌo mi yaloj Dios ti jaꞌ noꞌon xuꞌ ta sveꞌic li paleetique, pero la sveꞌic schiꞌuc li schiꞌiltac li Davide. Pero muc bu sta o smul ti jech la spase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jech laj yal nojtoc li Jesuse: ―Li Diose laj yacꞌbutic jun cꞌacꞌal sventa ta jcuxtic. Maꞌuc laj yacꞌ ta sventa ti chucbilutic o ta schabiel li cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Joꞌon li coꞌol crixchanoutique, joꞌon yajvalun li scꞌacꞌalil ti ta jcuxtique. Joꞌon chcal li cꞌustic xuꞌ ta pasele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iꞌoch Jesús schiꞌuc li yajchanbalajeltac ta jun schꞌulnaic li jchiꞌiltacutic ta israelale. Te oy jun jchiꞌilcutic ti smochꞌoj sba sbicꞌtaltac jun scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te oyic eꞌuc jayvoꞌ jfariseoetic. Te sqꞌuelojic mi ta xcoltavan Jesús li ta scꞌacꞌalil ta jcuxcutique yuꞌun tscꞌan tsaꞌbeic smul. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Li Jesuse jech laj yalbe li vinic ti smochꞌoj sba sbicꞌtaltac jun scꞌobe: ―Laꞌ vaꞌlan liꞌ ta oꞌlole ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Li Jesuse jech la sjacꞌbe li jfariseoetic li te oyique: ―Li scꞌacꞌalil ta jcuxtique, ¿cꞌusi yaloj Dios ti acꞌo jpastique? ¿Mi xuꞌ ta jpastic li cꞌusi leque, mi jaꞌ ta jpastic li cꞌusi chopole? ¿Mi chijcoltavan, mi chijmilvan? ―xut. Muc bu xtacꞌavic. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Li Jesuse iꞌilin ta stojolic li jfariseoetic li te oyic ta jujot xocone, yuꞌun chopol iyaꞌi ti toj tsots li yoꞌonique. Jech laj yalbe li vinic ti smochꞌoj sba sbicꞌtaltac jun scꞌobe: ―Tuqꞌuibtasano li sbicꞌtaltac acꞌobe ―xut. La stuqꞌuibtasan li sbicꞌtaltac scꞌobe, icol ta ora li scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iloqꞌuic batel li jfariseoetique. Ba scꞌoponbeic li svinictac li Herodese yuꞌun ta snopbeic scꞌoplal Jesús ti cꞌu sba xuꞌ tsmilique. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Li Jesuse ibat ta tiꞌnab schiꞌuc li yajchanbalajeltaque. Pero te tijil ibatic epal crixchanoetic li liquemic talel ta Galilea balumil schiꞌuc li ta Judea balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Oy buchꞌutic liquemic talel ta jteclum Jerusalén schiꞌuc ta Idumea balumil. Schiꞌuc oy buchꞌutic liquemic talel ta jot ucꞌum Jordán, schiꞌuc ta yosilal li chib jteclum, Tiro schiꞌuc Sidón. Yuꞌun iyaꞌiic ti oy ep cꞌustic la spas li Jesuse, jaꞌ yuꞌun toj ep crixchanoetic tal sqꞌuelic. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Nopojesic talel junuc canava, te chiꞌoch cꞌalal mi chisnetꞌic li epal crixchanoetique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yuꞌun ep xa crixchanoetic icolic yuꞌun li Jesuse, jaꞌ yuꞌun scotol jchamelajeletic ta xnetꞌvanic yuꞌun ta scꞌan ta spiquic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cꞌalal laj yilic Jesús li pucujetic li ochemic ta yoꞌonic li crixchanoetique, jliquel laj quejiuc yuꞌun ta stojol Jesús li crixchanoetic ti bu ochemic ta yoꞌonique. Tsots icꞌopojic, jech laj yalic: ―Joꞌot Snichꞌonot Dios ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Li Jesuse tsots laj yalbe li pucujetique ti mu me xalic ti jaꞌ Snichꞌon li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tsꞌacal to imuy batel ta vits li Jesuse. Laj yicꞌ batel li buchꞌutic tscꞌan chicꞌ batel stuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","La stꞌuj lajchavoꞌ jchiꞌilcutic ta schiꞌin o, schiꞌuc ta stac batel ta spuquel li scꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Laj yacꞌanbe stsatsal sjuꞌelic ti ta scoltaanic li jchamelajeletique schiꞌuc ta sloqꞌuesanic li pucujetic ta yoꞌonic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Li lajchavoꞌ viniquetic li la stꞌuj li Jesuse, jaꞌic sbiic liꞌi: La stꞌuj Simón, jaꞌ Pedro laj yacꞌbe sbi. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Schiꞌuc Jacobo snichꞌon Zebedeo. Schiꞌuc yitsꞌin li Jacoboe, jaꞌ Juan sbi. Jaꞌ Boanérges iꞌacꞌbat sbiic yuꞌun li Jesuse, yuꞌun li Jacobo schiꞌuc li Juane jaꞌ jechic jech chac cꞌu chaꞌal li chauc ti ta jpꞌel noꞌox ora ta xlebuje, yuꞌun tscꞌan chaqꞌuic vocol ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","La stꞌuj nojtoc Andrés, schiꞌuc Felipe, schiꞌuc Bartolomé, schiꞌuc Mateo, schiꞌuc Tomás, schiꞌuc otro jun Jacobo, jaꞌ snichꞌon Alfeo. Schiꞌuc Tadeo, schiꞌuc Simón ti la schiꞌin toꞌox li jcananeoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Schiꞌuc Judas Iscariote, li buchꞌu tsꞌacal to iyacꞌ ta cꞌabal li Jesuse. Cꞌalal la stꞌuj li lajchavoꞌ yajchanbalajeltac li Jesuse, ibatic ta schꞌomna. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","La stsob sbaic batel nojtoc li crixchanoetique. La stsin sbaic tajmec. Mu xtal yutsil chveꞌic schiꞌuc li yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cꞌalal iyaꞌiic li yutsꞌ yalaltac Jesús ti te tsinil ep crixchanoetic ta schꞌomnae, taꞌox scꞌan xiqꞌuic loqꞌuel li Jesuse yuꞌun iyalic ti chjovi sjole. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te oy jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, jaꞌ jchiꞌilcutic ta israelal. Te liquemic talel ta Jerusalén. Jech laj yalic: ―Li vinic liꞌi ochem banquilal pucuj ta yoꞌon, jaꞌ yuꞌun ta sjuꞌel banquilal pucuj ta sloqꞌues li pucujetic li ochem ta yoꞌonic li crixchanoetique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Li Jesuse laj yapta li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech laj yal ta loꞌil: ―¿Cꞌu sba xuꞌ ta sloqꞌues schiꞌil ta pucujal li Satanase? ");
INSERT INTO tzoSA_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jech chac cꞌu chaꞌal mi ta scontrain sbaic jun ajvalil schiꞌuc schiꞌiltac ta abtele, ta soquic o. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mi ta scontrain sbaic ta jpꞌej noꞌox snailique, ta soquic o nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jaꞌ noꞌox jech eꞌuc li Satanase, mi ta sloqꞌues schiꞌil ta pucujal ta yoꞌonic li crixchanoetique, mu xuꞌ spas mantal mi jech ta spase. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Li buchꞌu tscꞌan ch‐och ta sna jun tsatsal vinique yoꞌ chelcꞌanbe li cꞌustic oy yuꞌune, scꞌan ta schuc baꞌi li tsatsal vinique, jaꞌ to jech xuꞌ chelcꞌanbe batel li cꞌustic oy yuꞌune. Li Satanase jaꞌ jech chac cꞌu chaꞌal li tsatsal vinique yuꞌun jaꞌ sventainoj li crixchanoetique. Pero la jpas xa ta canal yuꞌun la jpojbe li vinic ti te toꞌox oy ta scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Melel chacalbeic, li buchꞌutic chopol li cꞌustic ta spasique, schiꞌuc mi chopol ta xcꞌopojic ta stojol li Diose, ta to spasbatic perton yuꞌun Dios ti mi tscꞌanbeique. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yan li buchꞌutic chopol ta xcꞌopojic ta stojol li Chꞌul Espíritue, muc xa bu ta spasbatic o perton sbatel osil ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ti jech iꞌalbatique yuꞌun iyalic ti ochem pucuj ta yoꞌon li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Te icꞌotic li yitsꞌinab li Jesuse schiꞌuc li smeꞌique yuꞌun jaꞌ ba scꞌoponic li Jesuse. Te vaꞌalic ta amacꞌ la staquic ta iqꞌuel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ep buchꞌutic te chotolic ta jujot xocon li Jesuse. Jech iꞌalbat li Jesuse: ―Te oyic ta amacꞌ ameꞌ schiꞌuc la avitsꞌinabe yuꞌun chac scꞌoponicot ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","35","Itacꞌav li Jesuse: ―Melel jaꞌ jmeꞌ, jaꞌ quitsꞌinab li te oyique. Pero li buchꞌutic ti liꞌ oyique ti ta spasic li cꞌusi ta scꞌan li Diose, jaꞌ coꞌol schiꞌuc jmeꞌ yaꞌel. Jaꞌ coꞌol schiꞌuc jchiꞌiltac ta voqꞌuel yaꞌel ―xi li Jesuse. La sqꞌuel li buchꞌutic li te nopol chotolique, jech laj yal: ―Qꞌuelavilic li jayvoꞌic ti liꞌ oyique, jaꞌ coꞌol schiꞌuc jmeꞌ yaꞌel. Jaꞌ coꞌol schiꞌuc jchiꞌiltac ta voqꞌuel yaꞌel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Li Jesuse ibat ta tiꞌnab schiꞌuc li yajchanbalajeltaque, te ichanubtasvan nojtoc. Toj ep jchiꞌilcutic la stsob sbaic talel li yoꞌ bu oy li Jesuse, jaꞌ yuꞌun iꞌoch ta canava ta ba nab li Jesuse, te ichoti. Li crixchanoetique te oyic ta tiꞌnab. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cꞌalal ichanubtasvan li Jesuse, oy ep cꞌusi laj yal ta loꞌil. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Aꞌiic. Ilocꞌ batel jun jvajtrigo. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cꞌalal la svaj li strigoe, oy jaypꞌej icꞌot ta be. Ital mutetic, la stam sbicꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oy jaypꞌej icꞌot ta tontic ti bu muꞌyuc lec slumale. Ijav ta ora yuꞌun muc bu pim slumal. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Cꞌalal iqꞌuepe, icꞌanub ta ora, itaquij o yuꞌun muc bu yacꞌoj yibel. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oy jaypꞌej icꞌot ta yolon chꞌixtic. Cꞌalal ichꞌi li chꞌixe, inetꞌe comel, jaꞌ icꞌoxib o, muc bu satin. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oy jaypꞌej icꞌot ta lequil balumil. Lec isatin. Oy iyacꞌ lajuneb schaꞌvinic (30) ta pꞌej, oy iyacꞌ oxvinic (60) ta pꞌej, oy iyacꞌ joꞌvinic (100) ta pꞌej. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cꞌalal stuquic xa te oyic schiꞌuc li yajchanbalajeltac li Jesuse, schiꞌuc li buchꞌutic scotol cꞌacꞌal ta xchiꞌinvanique, la sjacꞌbeic Jesús cꞌusi smelol li loꞌil laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Li Jesuse jech laj yalbe: ―Li joꞌoxuque acꞌbiloxuc anaꞌic li cꞌu sba ta sventainan crixchanoetic li Diose, pero li yanetique mu xꞌacꞌbat snaꞌic. Jaꞌ noꞌox ta xcalbeic ta loꞌil. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yuꞌun altic noꞌox ti iyilic xa ti scotol xuꞌ cuꞌune, yuꞌun muc xacꞌ ta yoꞌonic. Altic ti iyaꞌiic xa li cꞌusi laj cale, muc xaꞌibeic smelol yuꞌun mu onoꞌox scꞌan xaꞌiic. Yuꞌun mu scꞌan xictaic li cꞌustic chopol tspasique, jech mu spasbatic perton yuꞌun li smulique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jech laj yal nojtoc li Jesuse: ―Mi muc bu xavaꞌibeic smelol eꞌuc li loꞌil li laj cale, ¿cꞌu sba xuꞌ chavaꞌibeic smelol li yan loꞌil ti ta to xcale? ");
INSERT INTO tzoSA_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Li jvajtrigoe jaꞌ li buchꞌu ta xal li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Li becꞌ trigo li icꞌot ta bee, jaꞌ senyail li buchꞌutic yaꞌiojic xa li scꞌop Diose, pero mu xaqꞌuic ta venta. Ta xtal ta ora li pucuje, chtal chꞌaybatuc ta sjolic ta ora li scꞌop Dios ti iyaꞌiique. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Li becꞌ trigo li icꞌot ta tontique, jaꞌ senyail li buchꞌutic li cꞌalal ta xaꞌiic li scꞌop Diose ta ora noꞌox tschꞌunic, xmuybajic noꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero muꞌyuc stsatsal yoꞌonic. Cꞌalal chichꞌic vocol cꞌalal schꞌunojique, ta xchibaj yoꞌonic ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Li becꞌ trigo li icꞌot ta yolon chꞌixtique, jaꞌ senyail li buchꞌutic yaꞌiojic li scꞌop Diose, ti jaꞌ noꞌox batem ta yoꞌonic li cꞌustic oy liꞌ ta balumile. Jaꞌ te loꞌlobilic o yuꞌun li cꞌustic ta scꞌanique. Cꞌusiuc noꞌox ta spichꞌ o yoꞌonic. Te netꞌbil icom o yaꞌel li scꞌop Dios li laj yaꞌiique, jech muc schꞌunic o. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Li becꞌ trigo li icꞌot ta lequil balumile, ti iyacꞌ lajuneb schaꞌvinic (30) ta pꞌej sbeqꞌue, schiꞌuc ti iyacꞌ oxvinic (60) ta pꞌej sbeqꞌue, schiꞌuc ti iyacꞌ joꞌvinic (100) ta pꞌej sbeqꞌue, jaꞌ senyail li buchꞌutic ta xacꞌ ta yoꞌonic li scꞌop Diose. Ta satin ta yoꞌonic yaꞌel li scꞌop Diose. Acꞌo mi ta xichꞌic vocol, mu xchibaj o yoꞌonic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jech laj yal nojtoc li Jesuse: ―Mi ta jtsan jcantiltique, muc bu ta jnujmaquitic, muc bu ta jmuctic ta yolon tem nojtoc. Ta jcuxantic ta scuxanobil. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jaꞌ noꞌox jech eꞌuc li joꞌoxuque, li cꞌustic la jchanubtasoxuc o liꞌi, mu me xamuquic. Jaꞌ avabtelic ti jamal chavalic batel ti cꞌu orae. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jech laj yal nojtoc li Jesuse: ―Aꞌibeic lec smelol li cꞌustic chacalbeique. Li cꞌu yepal chachꞌunic li cꞌusi laj calboxuque, más to ep chacꞌ anaꞌic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yuꞌun li buchꞌutic jutuc to schꞌunojique, más to chcoltaatic yuꞌun Dios ti acꞌo schꞌunic leque, yuꞌun chacꞌ ta yoꞌonic. Li buchꞌutic mu scꞌan schꞌunique, li cꞌu yepal snaꞌique, ta xpojbatic ta jꞌechꞌel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jech laj yal nojtoc li Jesuse: ―Chacalbeic li cꞌu sba ta sventainan crixchanoetic li Diose. Stuc snaꞌ cꞌu sba tspas jech chac cꞌu chaꞌal trigo ti la svaj ta yosil jun vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Li vinique jun yoꞌon ta xvay ta acꞌubaltic, ta xlic ta cꞌacꞌaltic. Jaꞌ noꞌox ti iyil ti ijav xa li strigoe pero mu snaꞌ li cꞌu sba ijave. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yuꞌun te chchꞌi stuc. Baꞌi ta xlocꞌ yanal, ta xacꞌ sat, tsꞌacal to ta xyijub li sate. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cꞌalal mi yij xa li sate, chba stuchꞌic yuꞌun yora xa ta tuchꞌel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jech laj yal nojtoc li Jesuse: ―Chacalbeic nojtoc li cꞌu sba ta sventainan crixchanoetic li Diose. Acꞌo mi muc bu ep li buchꞌutic ta xventainatic li avie pero ta tsꞌacale ta xꞌepaj. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jaꞌ jech chac cꞌu chaꞌal becꞌ mustasa ti ta jtsꞌuntic ti toj biqꞌuitique. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mi ichꞌie, toyol chbat. Jaꞌ mu sta jech smucꞌul li yan tsꞌunubiletic li biqꞌuitic sbecꞌ eꞌuque. Li mustasae toyol chbat schiꞌuc ep chacꞌ scꞌob. Ta xtal mutetic, ta spas stasic ta scꞌobtac yuꞌun oy lec yaxinal ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Li Jesuse ta loꞌil noꞌox laj yalbe li jchiꞌiltac ti cꞌu sba ta spas mantal li Diose. Jaꞌ noꞌox laj yal li cꞌu yepal xaꞌibeic smelole. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Naca ta loꞌil noꞌox laj yalanbe. Cꞌalal stuquic xa schiꞌuc li yajchanbalajeltac li Jesuse, laj yalbe li cꞌu sba smelol li loꞌil li laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cꞌalal xtupꞌet xaꞌox osile, jech laj yalbe li yajchanbalajeltac li Jesuse: ―Jelavcutic ba ta jot nab ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Li yajchanbalajeltaque la scꞌoponic comel li crixchanoetic li te schiꞌuquique, la schiꞌinic batel Jesús li ta yut canavae. Oy yan canavaetic la schiꞌinic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ital ta ora tsots icꞌ, tsots la syuqꞌuilan li nabe. Iꞌoch ep joꞌ ta yut li canavae, yuꞌun xaꞌox ta xmuquij yalel ta yut nab. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Li Jesuse te vayal ta chac canava yacꞌoj xon sjol. Itije yuꞌun li yajchanbalajeltaque. Jech laj yalbeic: ―Jchanubtasvanej, ¿mi yuꞌun mu xavaꞌi ti yuꞌun xa chijmuquijutic yalel ta yut nabe? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ilic li Jesuse, la spajes li iqꞌue schiꞌuc li nabe, jliquel ichꞌab ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Ta scoj ti mu xachꞌunic ti oy juꞌele jaꞌ yuꞌun chaxiꞌic ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero más to ixiꞌic. Jech laj yalbe sbaic: ―¿Cꞌu nan chaꞌal li vinic liꞌi ti jliquel ipaj yuꞌun li iqꞌue schiꞌuc li nabe? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Li Jesuse ibat ta jot nab li ta yosilal li jgadáraetic schiꞌuc li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cꞌalal iloqꞌuic ta canava schiꞌuc yajchanbalajeltac li Jesuse, te ital ta ora jun vinic ochem pucuj ta yoꞌon. Te ilic talel ta muquenal. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yuꞌun jaꞌ sna li jombil chꞌenetic li bu chmuqueic li ánimaetique. Muc buchꞌu xchuc yuꞌun acꞌo mi ta carena. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ep ta velta ichucbat yoc scꞌob ta carena pero la stuchꞌ li carenae. Muc buchꞌu xuꞌ tspas ta manxo. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cꞌacꞌal acꞌubal te xꞌavet batel ta vitstic schiꞌuc ta muquenal. Ta stsac ton, ta syaintas o sba. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Li vinique nom noj iyil li Jesuse, ital ta anil, la squejan sba ta stojol. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Li Jesuse jech laj yalbe li pucuje: ―Pucuj, locꞌan ta yoꞌon li vinique ―xut. Cꞌalal jech iyal li Jesuse, tsots icꞌopoj li vinique: ―Jesús, joꞌot Snichꞌonot Dios ta vinajel, ¿cꞌu chaꞌal tal aticꞌ aba ta jtojol? Li Diose chaꞌi ti jech chacalbee. Avocoluc mu me xavacꞌbun quichꞌ vocol ―xi li pucuje. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Li Jesuse jech la sjacꞌbe li vinique: ―¿Cꞌusi abi? ―xut. ―Legionuncutic yuꞌun ep ta mil liꞌ ochemuncutic ta yoꞌon li vinique ―xiic li pucujetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Li pucujetique ta sloqꞌuel yoꞌonic laj yalbeic Jesús ti mu me xtaqueic loqꞌuel ta yosilal li jgadáraetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te ta chꞌut vits oy ep chitometic ta saꞌ sveꞌelic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Li pucujetique laj yalbeic li Jesuse: ―Mi chaloqꞌuesuncutique, tacuncutic batel li yoꞌ bu oy li chitometique, te chba ochcuncutic ―xiic li pucujetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Li Jesuse iyal ti te acꞌo baticuque. Iloqꞌuic ta yoꞌon li vinic li pucujetique, ba ochicuc li ta chitometique. Li chitometique oy nan chaꞌmiluc. Iloqꞌuic ta anil scotol, iyalic ta yalebaltic, itsꞌujic ochel ta nab, te ijicꞌav scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Li jchabiejchitometique ixiꞌic batel. Ba yalbeic scotol crixchanoetic li ta jteclum schiꞌuc li buchꞌu te nopol nacalique. Jaꞌ yuꞌun li crixchanoetique tal sqꞌuelic li cꞌusi ispasique. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te icꞌotic li yoꞌ bu oy li Jesuse. Iyilic ti te chotol li vinic li ochem toꞌox pucujetic ta yoꞌone. Slapoj xa scꞌuꞌ, meltsajem xa, tuqꞌuibem xa. Li crixchanoetique ixiꞌic o. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Li buchꞌutic iyilic li cꞌu sba icol li vinic li ochem toꞌox pucujetic ta yoꞌone, schiꞌuc cꞌu sba icham li chitometique, laj yalbeic li buchꞌutic te icꞌotique. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Scotolic laj yalbeic li Jesuse: ―Avocoluc locꞌan batel ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cꞌalal iꞌoch ta canava li Jesuse, li vinic li ochem toꞌox pucujetic ta yoꞌone la scꞌanbe vocol Jesús ti acꞌo xuꞌ tschiꞌin batele. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Itacꞌav li Jesuse: ―Mu xba achiꞌinun. Batan ta ana, ba albo achiꞌiltac ti laj xa scoltaot li Diose, ti laj xa scꞌuxubinote ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ibat li vinique, laj yal batel ta yosilal ti icoltaat yuꞌun li Jesuse. Decápolis sbi li yosilale yuꞌun oy lajuneb jteclumetic li teye. Cꞌalal iyaꞌiic li crixchanoetique, toj chꞌayel noꞌox yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cꞌalal isut batel ta jot nab li Jesuse, toj ep jchiꞌilcutic la stsob sbaic talel ta stojol li te ta tiꞌnabe. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Te ital ta stojol jun jchiꞌilcutic, Jairo sbi. Jaꞌ jmeltsanejcꞌop ta jun chꞌulna. Cꞌalal iyil Jesús li Jairoe, tal spatan sba ta stojol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jech laj yalbe: ―Ta xcham xa li cunen tseube. Avocoluc ba acꞌ acꞌob ta sba, acꞌo coluc, acꞌo cuxiuc ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Li Jesuse la schiꞌin batel. Stsoboj sbaic echꞌel ta spat xocon Jesús li crixchanoetique yuꞌun toj epic la schiꞌinic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Oy jun ants lajchaeb xa jabil ti mu xmac li schamele. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ep la saꞌ jpoxtavanejetic pero jaꞌ noꞌox yan sba iyichꞌ o vocol, schiꞌuc ilaj scotol li cꞌustic oy yuꞌune. Pero muc bu xcol o li ta svomolique, más iꞌipaj o. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iyaꞌi ti xuꞌ yuꞌun chcoltavan li Jesuse, te tijil ibat ta spat li epal crixchanoetique. La spitsꞌ sba jelavel, la sta ta picbeel spuychij li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yuꞌun jech la snop: “Acꞌo mi jaꞌ noꞌox ta jpicbe li spuychije, chicol o”, xi ta yoꞌon li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Imac ta ora li schamele, iyaꞌi ti lec xa oye. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Li Jesuse iyaꞌi ta ora ti oy buchꞌu icol ta sjuꞌele. Ijoypꞌij sqꞌuel li crixchanoetique, jech la sjacꞌbe: ―¿Buchꞌu lispicbe jpuychij? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Itacꞌavic li yajchanbalajeltaque: ―Toj netꞌnetꞌ jbatic jchiꞌuctic li crixchanoetic chavile. ¿Cꞌu chaꞌal chajacꞌ ti buchꞌu la spicbot apuychije? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Li Jesuse la sqꞌuel ta jujot xocon ti buchꞌu ipicbat li spuychije. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Li antse ta xnic ta xiꞌel yuꞌun snaꞌoj ti jaꞌ icole. La squejan sba ta stojol li Jesuse, jamal laj yalbe scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Li Jesuse jech laj yalbe: ―Jnichꞌon, yuꞌun la achꞌun ti oy juꞌele, jaꞌ yuꞌun lacol. Junuc avoꞌon batan, yuꞌun icol xa la achamele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cꞌalal jaꞌ o yacal ta loꞌil li Jesuse, icꞌot jayvoꞌ li iliquic talel ta sna li Jairoe. Jech cꞌot albatuc li Jairoe: ―Icham xa la atseube. Altic xa chba yacꞌ svocol avuꞌun li Jchanubtasvaneje ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te xabin li Jesuse, jech lic yalbe li jmeltsanejcꞌope: ―Mu xavat avoꞌon. Jaꞌ noꞌox chꞌuno ti scotol xuꞌ ta jpase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Li Jesuse mu scꞌan ti ep buchꞌutic ta schiꞌin batele. Jaꞌ noꞌox laj yicꞌ batel Pedro, schiꞌuc Jacobo schiꞌuc yitsꞌin, jaꞌ li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cꞌalal icꞌotic ta sna li jmeltsanejcꞌope, li Jesuse iyil ti oy ep buchꞌutic te xꞌupꞌetic, ti xꞌavetic noꞌox ta oqꞌuele. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Li Jesuse iꞌoch ta yut na. Jech la sjacꞌbe: ―¿Cꞌu chaꞌal ti xaꞌavetic ta oqꞌuele? Muc bu chamem li tseube, yuꞌun noꞌox chvay ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Cꞌalal jech iyaꞌiic li jchiꞌiltacutique, la stseꞌinic li Jesuse yuꞌun snaꞌic ti chamem li tseube. Li Jesuse la stacan loqꞌuel scotol li buchꞌutic te oyique. Jaꞌ noꞌox icom li stot smeꞌ li tseube schiꞌuc li oxvoꞌ yajchanbalajeltac li Jesuse. Te iꞌochic li yoꞌ bu telel li ánimae. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Li Jesuse la stsacbe scꞌob li ánima tseube, jech laj yalbe: ―Talita cumi ―xut. “Tseub, lican chacalbe”, xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ichaꞌcuxi ta ora, itots li tseube. Ixanav batel yuꞌun lajchaeb xa jabil yichꞌoj. Scotol li buchꞌutic ti te oyique toj chꞌayel noꞌox yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Li Jesuse tsots laj yalbe mantal li stot smeꞌ li tseube ti mu me buchꞌu xalbeique. Laj yalbe nojtoc ti acꞌo yacꞌbeic sveꞌel li tseube. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Li Jesuse isut batel ta jteclum Nazaret li yoꞌ bu ichꞌie. La schiꞌin batel li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cꞌalal jaꞌ o scꞌacꞌalil ta jcuxcutique, li Jesuse ibat ta schꞌulnaic li jchiꞌiltacutic ta israelale. Te cꞌot chanubtasvanuc. Ep buchꞌutic laj yaꞌibeic scꞌop li Jesuse. Toj chꞌayel noꞌox yoꞌonic. Jech laj yalbe sbaic: ―¿Bu iyichꞌ spꞌijil li jchiꞌiltic liꞌi? Toj lec li cꞌusi chale. Schiꞌuc oy sjuꞌel, xuꞌ yuꞌun ta spas scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yuꞌun jaꞌ li carpinteroe, jaꞌ yol li Maríae. Jaꞌ yitsꞌinab li Jacoboe, schiꞌuc li Josee, schiꞌuc li Judase, schiꞌuc li Simone. Jaꞌ yixleltac nojtoc li liꞌ jchiꞌuctic ta nacleje ―xut sbaic. Jaꞌ yuꞌun muc bu xichꞌic ta mucꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jech iꞌalbatic yuꞌun li Jesuse: ―Li butic chcꞌotic li buchꞌutic ta xalic li scꞌop Diose jaꞌ acꞌbilic ta venta. Pero ta yosilalic stuquique schiꞌuc ta snaique, schiꞌuc ta stojol yutsꞌ yalaltaquique, mu xꞌaqꞌueic ta venta ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jech muc bu ep iyacꞌ ta ilel stsatsal sjuꞌel li bu ichꞌi li Jesuse. Jaꞌ noꞌox oy jayvoꞌ jchamelajeletic icolic yuꞌun ti cꞌalal laj yacꞌanbe scꞌob ta sbaique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Li Jesuse ichꞌay o yoꞌon ta scoj ti mu schꞌunique. Jaꞌ yuꞌun ibat ta scotol coloniaetic ti te noꞌox nopolic li ta jteclum Nazarete, te ichanubtasvan. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Li Jesuse la stsob li lajchavoꞌ yajchanbalajeltaque. Ta chaꞌchaꞌvoꞌ la stac batel. Laj yacꞌanbe stsatsal sjuꞌelic ti ta sloqꞌuesanbeic pucujetic ta yoꞌonic li jchiꞌiltacutic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Laj yalbe ti mu me cꞌusi xichꞌic batele. Jaꞌ noꞌox acꞌo yichꞌic batel snamteꞌic. Mu me xichꞌic batel sveꞌelic, mi snutiꞌic, mi staqꞌuinic schiꞌuc cꞌusi yan. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jaꞌ noꞌox iꞌalbatic ti acꞌo slap batel xonobique, ti mu me slap batel chaꞌlom scꞌuꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jech laj yalbe nojtoc: ―Ti bu chcꞌot achꞌamunic nae, te me oyanic o. Jaꞌ to mi chabatic ta yan jteclume, jaꞌ to xaloqꞌuic batel li ta achꞌomnaique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mi oy buchꞌu mu xayotesic ta snae, mi mu scꞌan xaꞌi acꞌopique, locꞌanic batel li ta slumalique. Cꞌalal chaloqꞌuic batele, lilinic comel spucucal la avoquique. Jaꞌ senyail ti jaꞌ xa icom ta sba stuquic ti muc bu xichꞌic ta mucꞌ li cꞌusi la avalbeique. Melel li cꞌusi chacalbeique, cꞌalal ta xcꞌot scꞌacꞌalil ta xichꞌ cꞌop li Diose, jaꞌ más tsots vocol ta xichꞌic li jchiꞌiltactic li te ta jteclum li bu mu xayotesique. Li vocol ta xichꞌic li crixchanoetic li te ta jteclum Sodoma schiꞌuc li ta jteclum Gomorra ta voꞌonee, jaꞌ mu sta jech ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ibatic, ba yalbeic li jchiꞌiltacutic ta israelal ti acꞌo yictaic li cꞌustic chopol tspasique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","La sloqꞌuesanbeic ep pucuj ta yoꞌonic. Laj yacꞌbeic asete ta sjol ep jchamelajeletic, icolic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Li ajvalil Herodese iyaꞌi ti ep li cꞌustic tspas li Jesuse yuꞌun scotol crixchanoetic yaꞌiojic. Li Herodese jech laj yal: ―Taje jaꞌ li Juan li iyacꞌ ta ichꞌel joꞌe. Yuꞌun ichaꞌcuxi, jaꞌ yuꞌun oy sjuꞌel yoꞌ tspas li cꞌustic lec ta spase ―xi li Herodese. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oy yanetic jech laj yalic: ―Jaꞌ Elías li iyal scꞌop Dios ta voꞌonee ―xiic. Oy yanetic jech laj yalic: ―Jaꞌ jech chal scꞌop Dios jech chac cꞌu chaꞌal li buchꞌutic iyalic scꞌop Dios ta voꞌonee ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cꞌalal iyaꞌi Herodes li cꞌusi iyalic li crixchanoetique, jech laj yal: ―Jaꞌ Juan ti laj cacꞌ ta tuchꞌbeel li sjole, yuꞌun nan ichaꞌcuxi loqꞌuel ta smuquenal ―xi li Herodese. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yuꞌun li Herodese jaꞌ onoꞌox la stac ta tsaquel li Juane. La spas mantal ti acꞌo chuqueuc ta carena ta yut chucvanab ta scoj li Herodíase, jaꞌ li yajnil toꞌox li yitsꞌin li Herodese. Felipe sbi li yitsꞌine. Yuꞌun li Herodese la spojbe yajnil li yitsꞌine, laj yicꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ti la sticꞌ ta chuquel Juan li Herodese, yuꞌun chopol iyaꞌi ti jech iꞌalbate: ―Mu lecuc chil Dios ti apojbe yajnil la avitsꞌine ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Li Herodíase chopol iyaꞌi eꞌuc ti jech laj yal li Juane jaꞌ yuꞌun chac smil. Pero mu to xuꞌ tsmil yuꞌun chabibil ta soltaroetic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Li Herodese iyichꞌ ta mucꞌ li Juane yuꞌun snaꞌoj ti jaꞌ lequil vinique, ti mu cꞌusi chopol tspase. Jaꞌ yuꞌun laj yacꞌ ta chabiel yoꞌ mu xmile. Acꞌo mi muc bu xaꞌibe smelol li cꞌusi laj yal li Juane, pero lec la schiquinta li cꞌalal ichanubtasat yuꞌun li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","22","Li cꞌalal ilocꞌ ta sjabilal li Herodese, la spas sqꞌuinal. Laj yicꞌan scotol li buchꞌutic yacꞌanojbe yabtele, jaꞌ li jꞌabteletique, schiꞌuc li banquilal soltaroetique, schiꞌuc li buchꞌutic ichꞌbilic ta mucꞌ li te ta Galilea balumile. Yuꞌun tscꞌan tschiꞌin ta veꞌel ta qꞌuin. Li Herodíase snaꞌ ti jaꞌ xa yorail ti xuꞌ chacꞌ ta milel li Juane. Jaꞌ yuꞌun och acꞌotajuc li stseub li Herodíase. Li Herodese schiꞌuc li buchꞌutic te coꞌol chveꞌic ta mexa schiꞌuque, toj lec iyilic li cꞌu sba iꞌacꞌotaj li tseube. Cꞌalal ilaj yoꞌon ta acꞌot li tseube, jech laj yalbe li tseub li Herodese: ―Cꞌanbun ti cꞌusi chacꞌane, chacacꞌbe. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yiloj Dios ti chacacꞌbee. Manchuc mi chacꞌan oꞌloluc ti bu cꞌalal jmacoj li balumile, chacacꞌbe ―xut li tseube. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Locꞌ sjacꞌbe smeꞌ li tseube: ―¿Cꞌusi nan ta jcꞌan xanaꞌ? ―xut li smeꞌe. Itacꞌav li smeꞌe: ―Jaꞌ xacꞌanbe sjol li Juan li iyacꞌ ta ichꞌel joꞌe ―xut li stseube. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ibat ta anil li tseube, iꞌoch li yoꞌ bu oy li Herodese. Jech laj yalbe: ―Jaꞌ ta jcꞌan ti chavacꞌbun ta ora ta pulatu sjol li Juan li iyacꞌ ta ichꞌel joꞌe ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Li Herodese iyat tajmec yoꞌon. Pero ta scoj ti la stꞌabbe sbi li Diose schiꞌuc ti laj yaꞌiic nojtoc li buchꞌutic te schiꞌuque, jaꞌ yuꞌun isnop ti mu xa xuꞌ ta sutes li scꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","La stac batel ta ora jun yajsoltaro yoꞌ acꞌo ba stuchꞌbe talel sjol li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ibat li soltaroe, ba stuchꞌbe li sjol li Juane. La spach talel ta jun pulatu, laj yacꞌbe li tseube. Li tseube ba yacꞌbe li smeꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cꞌalal iyaꞌiic li yajchanbalajeltac li Juane, a yichꞌbeic li sbecꞌtal stacupale, ba smucbeic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Li lajchavoꞌ li itaqueic batel yuꞌun Jesús isutic talel ta stojol li Jesuse. Cꞌot yalbeic Jesús scotol li cꞌustic la spasique schiꞌuc li cꞌu sba ichanubtasvanique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta scoj ti te xtal xbat tajmec li crixchanoetique jech mu xtal yutsil xveꞌic. Jaꞌ yuꞌun jech laj yalbe li yajchanbalajeltac li Jesuse: ―Laꞌic, batic, jvocꞌ jbatic batel ta taqui jamaltic yoꞌ jech xuꞌ te chacuxic jliqueluc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iꞌochic ta canava, stuquic noꞌox la svocꞌ sbaic batel ta taqui jamaltic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ep buchꞌutic iyilic ti cꞌalal ibatique. Laj yojtaquinic ti te oy li Jesuse jech ibat ta yoquic ta anil ta tiꞌtiꞌnab. Ep ta jteclum ti bu iliquic batele. Jaꞌ baꞌi icꞌotic ta taqui jamaltic, tsꞌacal to icꞌotic li Jesuse schiꞌuc li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cꞌalal ilocꞌ ta canava li Jesuse, ep te tsobolic ista. Laj yichꞌan ta cꞌux yuꞌun jaꞌ jechic jech chac cꞌu chaꞌal chij ti muꞌyuc yajchabivanejique. Lic schanubtas. Ep cꞌustic laj yalbe. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cꞌalal mal xaꞌox cꞌacꞌale, jech iꞌalbat yuꞌun li yajchanbalajeltac li Jesuse: ―Toj mal xa cꞌacꞌal, taqui jamaltic liꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jaꞌ lec tacano me batel li crixchanoetique acꞌo ba sman sveꞌelic ta coloniaetic li liꞌ noꞌox nopolique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Itacꞌav li Jesuse: ―Macꞌlanic li joꞌoxuque ―xꞌutatic. Itacꞌavic: ―¿Bu ta jtacutic chib ciento denario taqꞌuin sventa ta jmancutic o pan ti chcacꞌbecutic sveꞌique? ―xi itacꞌavic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Itacꞌav li Jesuse: ―¿Jaypꞌej pan avichꞌojic talel? Qꞌuelic ―xꞌutatic. Cꞌalal iyilic li cꞌu yepale, laj yalbeic li Jesuse: ―Jaꞌ noꞌox joꞌpꞌej pan schiꞌuc chaꞌcot choy liꞌ quichꞌojcutique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Li Jesuse laj yalbe li crixchanoetic ti acꞌo stsob sbaic ta jutsobe, schiꞌuc ti acꞌo chotlicuc ta yaxaltique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ichotiic ta jutsob. La stsob sbaic ta joꞌvinic (100) schiꞌuc ta lajlajuneb yoxvinic (50). ");
INSERT INTO tzoSA_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Li Jesuse la stsac li joꞌpꞌej pane schiꞌuc li chaꞌcot choye. La sqꞌuel muyel ta vinajel, laj yalbe coliyal Dios. La xutilan li pane, laj yacꞌbe li yajchanbalajeltaque. Li yajchanbalajeltaque la spucbeic li crixchanoetique. Li Jesuse la stuchꞌilan nojtoc li chaꞌcot choye, laj yacꞌbe spuquic li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iveꞌ scotolic, inojic o lec. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","La stsobic li scomenal li pane schiꞌuc li scomenal li choye, inoj lajchamoch. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ti cꞌu yepal iveꞌique jaꞌ joꞌmil viniquetic. Jaꞌ slecoj li antsetique schiꞌuc li unetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Li Jesuse laj yalbe li yajchanbalajeltac ti acꞌo ochicuc ta ora ta canavae, yoꞌ acꞌo jelavicuc batel ta jot nab li te ta jteclum Betsáidae. Te to icom li Jesuse. Stuc xa la scꞌopon comel li jchiꞌiltacutique. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cꞌalal ilaj yoꞌon ta scꞌoponel comele, ibat ta vits li Jesuse, ba sta ta naꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cꞌalal iꞌoch acꞌubale, ta oꞌlol nab xaꞌox xꞌechꞌic li yajchanbalajeltaque. Li Jesuse te toꞌox oy stuc ta vits. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Li Jesuse iyil ti lubemic xa ta xanubtasel li canavae yuꞌun ta snup sbaic schiꞌuc li iqꞌue. Cꞌalal poꞌot xaꞌox tsacube, ibat Jesús li yoꞌ bu oyic li yajchanbalajeltaque. Ixanav batel ta yoc ta ba nab. Tucꞌ ta xjelav batel yilel. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cꞌalal iyilic li yajchanbalajeltac ti ta xanav batel ta yoc ta ba nab li Jesuse, la snopic ti jaꞌ chꞌulelale. Xꞌavetic tajmec yuꞌun toj echꞌem ixiꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jech iꞌalbatic ta ora yuꞌun li Jesuse: ―Mu me xaxiꞌic, joꞌon Jesusun. Tsatsubtaso avoꞌonic ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Cꞌalal och schiꞌin ta canava li yajchanbalajeltaque, ipaj ta ora li iqꞌue. Toj chꞌayel noꞌox yoꞌonic li yajchanbalajeltaque yuꞌun mu snaꞌic cꞌu sba ipaj li iqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mu snaꞌic nojtoc ti jaꞌ ta sjuꞌel Jesús ipꞌol li pane yuꞌun mu toꞌox schꞌunic ti xuꞌ yuꞌun tspas scotole. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cꞌalal icꞌotic ta jot nabe, te iloqꞌuic ta canava ta Genesaret balumil. Te la schuquic comel li canavae. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cꞌalal ilocꞌ ta canava li Jesuse, iꞌojtaquine ta ora yuꞌun li jchiꞌiltacutic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba yalic ta ora ta scotol Genesaret ti te xa oy ta yosilalic li Jesuse. Cꞌalal iyaꞌiic ti bu oy li Jesuse, la sqꞌuechic talel ta ora li yajchamelajeletique. Te laj yiqꞌuic talel ta stojol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Buyuc noꞌox iꞌoch li Jesuse, mi ta bicꞌtal jteclum, mi ta mucꞌta jteclum, mi ta coloniaetic, te tal spuchꞌanic ta tiꞌtiꞌbe li jchamelajeletique. Oy jchamelajeletic iyalbeic vocol Jesús ti jaꞌ noꞌox acꞌo yacꞌ ta piquel li stiꞌ spuychije. Li buchꞌutic la spicbeic li stiꞌ spuychije icolic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Te italic ta stojol Jesús jayvoꞌ jfariseoetic schiꞌuc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose ti liquemic talel ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iyilic ti oy jayvoꞌ yajchanbalajeltac Jesús ti muc bu jal la spoc scꞌobic li cꞌalal iveꞌique. Li jfariseoetique ta xalic ti muc bu lec ta xꞌileic o yuꞌun Dios li buchꞌutic ti muc bu jal ta spoc li scꞌobique. Jech isaꞌbat smulic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yuꞌun li jfariseoetique schiꞌuc scotol li jchiꞌiltacutic ta israelale jaꞌ yichꞌojbeic stalelic li jtotic jmeꞌtic ta voꞌonee. Mi muc bu jal ta spoc li scꞌobique, muc bu ta xveꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cꞌalal ta sutic talel ta chꞌivite, muc bu ta xveꞌic mi muc bu jal ta spoc li scꞌobique. Oy ep cꞌusi yan schꞌunojic, jaꞌ ti cꞌu sba ta sucꞌ sbochique, schiꞌuc ta sucꞌ xaluic schiꞌuc spꞌinic, schiꞌuc ta spoc stemic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Li jfariseoetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, jech la sjacꞌbeic li Jesuse: ―¿Cꞌu chaꞌal muc bu yichꞌojbeic stalel li jtotic jmeꞌtic ta voꞌone la avajchanbalajeltaque? Yuꞌun muc bu jal ta spoc scꞌobic li cꞌalal ta xveꞌique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Itacꞌav li Jesuse: ―Jloꞌlovanejoxuc. Jaꞌ acꞌoplalic ti jech iꞌalbat yuꞌun Dios li Isaías li iyal scꞌop Dios ta voꞌonee: La achiꞌiltaque ta ye noꞌox chiyichꞌic ta mucꞌ, mu ta sloqꞌueluc yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Altic ta xalic ti chiyichꞌic ta muqꞌue. Jaꞌ smantal noꞌox crixchanoetic li ta xchanubtasvanic oe; maꞌuc jcꞌop ti ta xaqꞌuic ta chanele, xi li Diose, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yuꞌun li joꞌoxuque jaꞌ avictaojic li smantal li Diose. Jaꞌ avichꞌojbeic li cꞌu sba stalel li crixchanoetique. Jaꞌ li cꞌu sba chasuqꞌuic la axaluique schiꞌuc la abochique, schiꞌuc li cꞌustic yan chapasique ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jech laj yalbe nojtoc: ―Pꞌijoxuc ta snopel li cꞌu sba chavalique yoꞌ chavictabeic li smantaltac li Diose ta scoj ti jaꞌ avichꞌojbeic stalel li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yuꞌun jech yaloj li Moisese: “Ichꞌo ta mucꞌ atot ameꞌ”, xi. Jech yaloj nojtoc: “Li buchꞌu ta xalbe stot smeꞌ ti acꞌo lajuc chamuque, jaꞌ acꞌo mileuc”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero li joꞌoxuque lec chavaꞌiic mi jech ta xalbeic li stot smeꞌique: “Li cꞌu yepal ta jtae laj xa cal ti ta xcacꞌ ta sventa smoton li Diose”, mi xutic li stot smeꞌique, li joꞌoxuque lec chavaꞌiic ti jech ta xalique. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chavalbeic ti xuꞌ xa mu scꞌuxubin li stot smeꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaꞌ jech chavictabeic o li smantaltac Dios ta scoj ti jaꞌ avichꞌojbeic li stalelic li jtotic jmeꞌtic ta voꞌonee. Oy ep cꞌusi yan jech chapasic ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Li Jesuse la schaꞌicꞌ ta stojol li jchiꞌiltacutique, jech laj yalbe: ―Aꞌiic me li cꞌusi chacalbeique. Aꞌibeic lec smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Muc bu chopol chayilic li Dios ta sventa li cꞌustic chalajesique. Ti chopol chayilic li Diose, jaꞌ ta scoj li cꞌustic chopol chanopilanique. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Li Jesuse te laj yicta li crixchanoetique, iꞌoch li ta schꞌomnae. Lic jacꞌbatuc yuꞌun li yajchanbalajeltac li smelol li cꞌusi laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Itacꞌav li Jesuse: ―¿Mi mu xavaꞌibeic smelol eꞌuc li joꞌoxuque? ¿Mi mu xanaꞌic ti muc bu chopol chayilic li Dios ta sventa li cꞌustic chalajesique? ");
INSERT INTO tzoSA_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yuꞌun li cꞌusi chalajesique ta achꞌutic ta xcꞌot, echꞌel noꞌox ch‐echꞌ ―xꞌutatic. Li smelol li cꞌusi laj yal li Jesuse, jaꞌ ti naca lec scotol li veꞌlile. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jech laj yalbe nojtoc li yajchanbalajeltaque: ―Li cꞌusi chopol ta snop ta yoꞌonic li crixchanoetique jaꞌ chopol ta xꞌileic o yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Yuꞌun ta yoꞌonic li crixchanoetique ta xlic talel li cꞌustic chopol ta snopique, mi ta xmulivajic, mi ta xmilvanic, mi ta xꞌelcꞌajic, mi ta spichꞌ o yoꞌonic li cꞌustic oy yuꞌun li schiꞌilique, mi ta xcontrainvanic, mi ta xloꞌlovanic, mi mu xqꞌuexavic ta spasel li cꞌustic chopole, mi xtiꞌet noꞌox yoꞌonic, mi ta sloꞌiltaan schiꞌilic, mi ta stoy sbaic, mi mu xichꞌ smelol xcꞌopojic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Scotol li cꞌustic chopol liꞌi jaꞌ ta xlic talel ta yoꞌonic li crixchanoetique, jaꞌ chopol ta xꞌileic o yuꞌun li Diose ―xut li yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ilocꞌ batel schiꞌuc li yajchanbalajeltac li Jesuse. Ibatic ta yosilal chib jteclum Tiro schiꞌuc Sidón. Te iꞌochic ta jun na. Li Jesuse mu scꞌan ti acꞌo yaꞌiic ti bu oye, pero iyaꞌiic ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yuꞌun te oy jun ants ochem pucuj ta yoꞌon li stseube. Iyaꞌi ti te xa oy li Jesuse. Ital ta ora, la spatan sba ta stojol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Li antse maꞌuc jchiꞌilcutic ta israelal, jaꞌ liquem talel ta Sirofenícia balumil. Acꞌo mi mu onoꞌox xquilcutic ta lec li buchꞌutic ti maꞌuc jchiꞌilcutic ta israelale, pero li antse ta sloqꞌuel yoꞌon la scꞌanbe Jesús ti acꞌo loqꞌuesbatuc li pucuj li ochem ta yoꞌon li stseube. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jech iꞌalbat yuꞌun li Jesuse: ―Acꞌo nojicuc baꞌi li nichꞌoniletique. Muc bu lec mi ta jpojbetic li yotique sventa ta xcacꞌbetic sveꞌic li tsꞌiꞌetique ―xi yuꞌun chqꞌuelbat yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Itacꞌav li antse: ―Jnaꞌoj, tata. Pero oy onoꞌox ta stsꞌuj yalel schꞌuchꞌulil yotic ta yolon smexaic li nichꞌoniletique. Jaꞌ ta stsob sveꞌic li tsꞌiꞌetique. Jaꞌ jechun li joꞌone, abolajan cꞌuxubinun ―xi li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Li Jesuse jech laj yalbe: ―Ta sventa ti jech la avale, loqꞌuem xa li pucuj li ta yoꞌon la atseube, jech xuꞌ xa chabat ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ibat li antse. Cꞌalal icꞌot ta snae, puchꞌul xa ta stem cꞌot sta li stseube yuꞌun loqꞌuem xa li pucuj li ochem ta yoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Li Jesuse ilocꞌ batel ta yosilal jtiroetic, ijelav batel li ta yosilal jsidonetic schiꞌuc ta yosilal li Decápolise. Te icꞌot ta tiꞌnab ta Galilea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te iyiqꞌuic talel ta stojol Jesús jun jchiꞌilcutic ta israelal, jaꞌ umaꞌ, schiꞌuc macal schiquin nojtoc, mu xaꞌi cꞌoponel. La scꞌanbeic Jesús ti acꞌo yacꞌbe scꞌob ta sba li vinique yoꞌ acꞌo coluc. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Li Jesuse slecoj laj yicꞌ loqꞌuel stuc li vinique, la sticꞌ ochel sbicꞌtal scꞌob ta jujun schiquin li vinique. Schiꞌuc la stubta scꞌob, la spicbe yocꞌ li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Li Jesuse la sqꞌuel muyel ta vinajel, la sjicꞌ yoꞌon, jech laj yalbe li vinique: ―Efata ―xut. “Acꞌo jamuc”, xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ijam ta ora li schiquine schiꞌuc li yee, lic cꞌopojuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Li Jesuse laj yalbe li crixchanoetic ti mu me spuquinic echꞌel li cꞌusi la spase, pero muc bu schꞌunic. Acꞌo mi ep ta velta iꞌalbatic ti mu me spuquinic echꞌele, más to la spuquinic. ");
INSERT INTO tzoSA_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yuꞌun toj chꞌayel noꞌox yoꞌonic li cꞌalal laj yilique. Jech laj yalic: ―Toj lec li cꞌustic ta spas li Jesuse. Acꞌo mi umaꞌ schiꞌuc macal schiquin, yuꞌun ta xcol yuꞌun ―xiic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Toj ep jchiꞌiltacutic la stsob sbaic nojtoc ta stojol li Jesuse, mu cꞌusi tslajesic. Li Jesuse laj yicꞌ li yajchanbalajeltaque, jech laj yalbe: ");
INSERT INTO tzoSA_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Toj abol sbaic chquil li jchiꞌiltactic liꞌi yuꞌun yoxibal xa cꞌacꞌal liꞌ jchiꞌuctique, chꞌabal xa cꞌusi tslajesic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ti mi muc veꞌemic ta jtac sutel ta snaique, oy yicꞌal tslubtsajic ta be yuꞌun oy jayvoꞌic ti nom liquemic talele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Itacꞌavic li yajchanbalajeltaque: ―¿Bu ta jtacutic epal pan liꞌ ta taqui jamaltic sventa ta jmacꞌlantascutic oe? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ijacꞌbatic yuꞌun li Jesuse: ―¿Jaypꞌej pan oy avuꞌunic? ―xꞌutatic. Itacꞌavic: ―Jucpꞌej ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Li Jesuse laj yalbe li crixchanoetic ti acꞌo chotlicuque. La stsac li jucpꞌej pane, laj yalbe coliyal Dios. La xutilan li pane, laj yacꞌbe li yajchanbalajeltaque. La spuquic li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oy jaycot bicꞌtal choy nojtoc. Laj yalbe coliyal Dios nojtoc li Jesuse. Laj yalbe li yajchanbalajeltac ti acꞌo spucbeic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iveꞌ scotolic, inojic o lec. La stsobbeic li scomenale, inoj jucmoch. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Li cꞌu yepal iveꞌique oy nan chanmiluc. Cꞌalal iveꞌique, itaqueic sutel ta snaic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Li Jesuse iꞌoch ta ora ta canava schiꞌuc li yajchanbalajeltaque, ibatic ta Dalmanuta balumil. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tal scꞌoponic Jesús jayvoꞌ jfariseoetic yuꞌun tsqꞌuelic cꞌuxi tstabeic smul. Laj yalbeic ti acꞌo yacꞌ ta ilel ta vinajel li sjuꞌele yoꞌ jech ta snaꞌic o ti jaꞌ acꞌbil yabtel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Li Jesuse la sjicꞌ yoꞌon yuꞌun toj chopol iyaꞌi ti mu schꞌunique. Jech laj yalbe: ―¿Cꞌu chaꞌal chacꞌanic ti acꞌo cacꞌ ta ilel ta vinajel li juꞌele, joꞌoxuc ti liꞌ to oyoxuc ta balumile? Yuꞌun ep xa ta velta laj cacꞌ avilic ti scotol xuꞌ cuꞌune. Melel chacalbeic, mu xa bu chcacꞌ avilic yan ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Li Jesuse laj yicta li jfariseoetique, iꞌoch ta canava schiꞌuc li yajchanbalajeltaque, ibatic ta jot nab. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Li yajchanbalajeltac li Jesuse muc bu xjul ta sjolic chichꞌ ba spanic. Jpꞌej noꞌox pan te yichꞌojic batel ta canava. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Qꞌuelo me abaic ta sventa svochesobil spanic li jfariseoetique schiꞌuc svochesobil span li Herodese ―xut li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Li yajchanbalajeltaque jech laj yalbe sbaic: ―Jaꞌ nan chijyalbutic yuꞌun muc bu xquichꞌtic talel li jpantique ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Li Jesuse iyil cꞌu sba yoꞌonic, jech laj yalbe: ―¿Cꞌu chaꞌal jaꞌ chanopic ta sventa ti muc bu xavichꞌic talel jpantique? Yuꞌun muc to bu achꞌunojic chaꞌa ti scotol xuꞌ cuꞌune. Toj tsots avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oy asatic pero muc xavilic. Oy achiquinic pero muc xavaꞌiic. ¿Mi mu xjul ta ajolic li cꞌusi la jpase? ");
INSERT INTO tzoSA_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cꞌalal la jxutilan joꞌpꞌej pan sventa la jmacꞌlantastic joꞌmil viniquetique, ¿jaymoch li scomenal la atsobique? ―xꞌutatic. ―Lajchamoch ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Li cꞌalal la jxutilan jucpꞌej pan sventa li chanmile, ¿jaymoch li scomenal la atsobique? ―xꞌutatic. ―Jucmoch ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jech iꞌalbatic yuꞌun li Jesuse: ―¿Mi muc xavaꞌibeic smelol ti jaꞌ ta sventa li cꞌu sba ta xchanubtasvanic li jfariseoetic ti “qꞌuelo me abaic ta sventa li svochesobil spanic li jfariseoetique” ti xacutique? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te icꞌotic ta jteclum Betsáida schiꞌuc li yajchanbalajeltac li Jesuse. Te snitojic talel ta stojol Jesús jun jchiꞌilcutic ta israelal yuꞌun maꞌsat. Laj yalbeic vocol Jesús ti acꞌo sjambe sate. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Li Jesuse la stsacbe scꞌob li maꞌsate, la snit loqꞌuel ta tiꞌ jteclum. La stubtabe li sate, la spicbe ta schibal scꞌob. La sjacꞌbe mi xil xa jutuc osil. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Li vinique la sqꞌuel osil jech laj yal: ―Chquil chanavic li crixchanoetique pero coꞌol schiꞌuc teꞌetic chquil ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Li Jesuse la schaꞌpicbe nojtoc li sate, ijam o lec li sate, lec xa xil o osil. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Li Jesuse la stac sutel ta sna li vinique, jech laj yalbe: ―Mu me xaꞌoch ta yut jteclum, mu me buchꞌu xavalbe ti ijam xa asate ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Li Jesuse ibat schiꞌuc li yajchanbalajeltac li ta scotol colonia li te ta nopol mucꞌta jteclum Cesarea Filipoe. Cꞌalal ta xanavic batel ta bee, la sjacꞌbe li yajchanbalajeltac li Jesuse: ―¿Cꞌusi la cabtel ta xalic li jchiꞌiltactique? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Itacꞌavic: ―Oy buchꞌutic ta xalic ti joꞌot Juanot li iyacꞌ ta ichꞌel joꞌ toꞌoxe. Oy yan ta xalic ti joꞌot Elíasote. Oy yan ta xalic ti joꞌot jun li buchꞌutic iyalic scꞌop Dios ta voꞌonee ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ijacꞌbatic yuꞌun li Jesuse: ―Li joꞌoxuque ¿cꞌusi cabtel ti avalojic eꞌuque? ―xꞌutatic. Itacꞌav li Pedroe: ―Joꞌot Cristoot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Li Jesuse laj yalbe li yajchanbalajeltac ti mu to me buchꞌu xalbeic ti jaꞌ tꞌujbil yuꞌun Dios ti chventainvane. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Joꞌon li coꞌol crixchanoutique, jnaꞌoj ti ta onoꞌox xquichꞌ ep vocole yuꞌun mu xiyilic ta lec li jꞌabteletique, schiꞌuc li banquilal paleetique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Chiyaqꞌuic ta milel, chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Li Jesuse jamal laj yal ti ta xmilee. Li Pedroe laj yicꞌ loqꞌuel li Jesuse, jech laj yalbe: ―Cajval, mu jechuc o smelol ti chamilee ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ijoypꞌij li Jesuse, la sqꞌuel li yajchanbalajeltaque. Jech laj yalbe li Pedroe: ―Satanás, locꞌan ta jtojol yuꞌun chac amacun. Maꞌuc chanop li cꞌusi ta scꞌan li Diose. Jaꞌ noꞌox chanop li cꞌusi ta scꞌan li crixchanoetique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Li Jesuse laj yicꞌ li epal crixchanoetique schiꞌuc li yajchanbalajeltaque. Jech laj yalbe: ―Li buchꞌu tscꞌan chtal ta jtojole mu me scꞌuxubin sba. Acꞌo cuchuc yuꞌun vocol jech chac cꞌu chaꞌal ta xcuch cuꞌune, acꞌo mi te ta xcham. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Li buchꞌu tscꞌuxubin li scuxlejal liꞌ ta balumile, ti mu scꞌan xcham ta jventa joꞌone, jaꞌ ta xchꞌay o sbatel osil. Yan li buchꞌu mu sventauc mi te ta xcham ta jventa joꞌone ti ta spuc batel li jcꞌope, jaꞌ ta xcuxi o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Acꞌo mi oy buchꞌu ti chal ti tsbain scotol li cꞌustic oy liꞌ ta balumile, pero mu cꞌusi ta xtun o li scꞌulejal li cꞌalal ta xchame. Yuꞌun maꞌuc ta sta o scuxlejal sbatel osil li scꞌulejale. ");
INSERT INTO tzoSA_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Li buchꞌu ta xqꞌuexav ta schꞌunel li jcꞌop ta stojol li crixchanoetic li avie, ti mu junuc yoꞌon ta stojol li Diose, schiꞌuc ti chopol li cꞌustic ta spase, “maꞌuc jnichꞌon”, xichi li cꞌalal chichaꞌtale, joꞌon li coꞌol crixchanoutique. Schiꞌuc xa stsatsal sjuꞌel li Jtot chitale, schiꞌuc chischiꞌinic talel li ángeletique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jech laj yal nojtoc li Jesuse: ―Melel li cꞌusi chacalbeique, oy jayvoꞌoxuc liꞌi ti muc to bu chachamique jaꞌ to mi avilic ti ta sventainan xa crixchanoetic li Diose, jaꞌ li ta xjeltabat yoꞌonic ta stsatsal li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cꞌalal jech laj yal li Jesuse, ta svaquibal to cꞌacꞌal laj yicꞌ batel Pedro, schiꞌuc Jacobo, schiꞌuc Juan ta jpꞌej toyol vits. Li Jesuse iyacꞌ xojobal sat ta stojol li oxvoꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Li scꞌuꞌ Jesuse isacub tajmec. Muc buchꞌu snaꞌ xchucꞌomaj ta spꞌejel balumil ti jech saquile. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jaꞌ o iyilic te ivinaj chaꞌvoꞌ viniquetic ti chloꞌilajic schiꞌuc li Jesuse. Jaꞌic Elías schiꞌuc Moisés li iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Li Pedroe jech laj yalbe li Jesuse: ―Jchanubtasvanej, lec ti liꞌ oyutique. Jaꞌ lec ta jpascutic oxpꞌej yaxna liꞌi; jpꞌej avuꞌun, jpꞌej yuꞌun Moisés, jpꞌej yuꞌun li Elíase ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yuꞌun muc xnop yuꞌun lec li cꞌusi laj yale yuꞌun ixiꞌic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ital toc, imaquic ta toc scotolic. Iyaꞌiic icꞌopoj ta yut toc li Diose, jech laj yal: ―Liꞌi jaꞌ Jnichꞌon ti toj cꞌux ta coꞌone. Aꞌibeic li cꞌusi ta xale ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cꞌalal ijam li toque, la sqꞌuelic ta jujot, pero stuc xa noꞌox te vaꞌal iyilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cꞌalal yacal ta xyalic talel ta vitse, jech iꞌalbatic yuꞌun li Jesuse: ―Mu to me buchꞌu xavalbeic li cꞌusi la avilique jaꞌ to mi lichaꞌcuxi loqꞌuel ta jmuquenal, joꞌon li coꞌol crixchanoutique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jaꞌ yuꞌun muc buchꞌu laj yalbeic, ta yoꞌon noꞌox stuquic. Jaꞌ noꞌox iloꞌilaj stuquic ta sventa li cꞌu sba smelol ti ta xchaꞌcuxi loqꞌuel ta smuquenale. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jech la sjacꞌbeic li Jesuse: ―¿Cꞌu chaꞌal ta xalic li jchanubtasvanejetic ta smantaltac Dios ti persa baꞌi ta xtal li Elíase, ti tsꞌacal to chatal joꞌote? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Itacꞌav li Jesuse: ―Ta melel jech tsꞌibabil ta scꞌop Dios ti jaꞌ baꞌi ta xtal li Elíase, yuꞌun chtal yalanbe ti acꞌo yictaic li cꞌustic chopol ta spasic li jchiꞌiltactique. Schiꞌuc tsꞌibabil onoꞌox jcꞌoplal eꞌuc ti ta persa ta xquichꞌ vocol, joꞌon li coꞌol crixchanoutique, yuꞌun mu xiscꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Chacalbeic ti iꞌay xa li Elíase, jaꞌ li Juan li iyacꞌ ta ichꞌel joꞌe. Pero li crixchanoetique la spasbeic li cꞌusi ta scꞌan yoꞌon stuquique, la smilic. Yuꞌun jech onoꞌox tsꞌibabil scꞌoplal li Juane ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cꞌalal icꞌotic li yoꞌ bu oyic li yan yajchanbalajeltaque, iyilic ti te tsobol epal crixchanoetique. Te oy jayvoꞌic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, jaꞌ o te ta svulilan sbaic schiꞌuc li yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cꞌalal iyilic Jesús li crixchanoetique, toj chꞌayal noꞌox yoꞌonic, ba scꞌoponic ta anil. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jech ijacꞌbatic yuꞌun li Jesuse: ―¿Cꞌusi chajacꞌbe abaic schiꞌuc li cajchanbalajeltaque? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Itacꞌav jun li buchꞌutic te tsobolique: ―Jchanubtasvanej, liꞌ quicꞌoj talel ta atojol li jquereme yuꞌun ochem pucuj ta yoꞌon. Jaꞌ yuꞌun pasem o ta umaꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Buyuc noꞌox chlic ilbajinatuc yuꞌun li pucuje. Ta xjipe ta lum, ta xvocan ye, ta xcꞌux sba ye, ta steꞌ sba yoc scꞌob. Laj calbeic vocol la avajchanbalajeltac ti acꞌo sloqꞌuesique, pero mu xlocꞌ yuꞌunic ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Itacꞌav li Jesuse: ―Toj tsots avoꞌonic, mu xachꞌunic. Oy xa scꞌacꞌalil liꞌ jchiꞌucoxuque pero muc to bu chcꞌot ta avoꞌonic. Oy xa scꞌacꞌalil la jtsꞌicboxuc li cꞌu abaique. Iqꞌuic talel li quereme ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Laj yiqꞌuic talel li quereme. Li pucuj ti ochem ta yoꞌon li quereme, cꞌalal iyil li Jesuse, jaꞌ o la stupꞌbe yicꞌ li quereme, jech iyal ta lum. Te xbalet ta lumtic, ilocꞌ svoc ye. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Li Jesuse jech la sjacꞌbe stot li quereme: ―¿Cꞌu xa ora liquem ti jech ta spase? ―xi li Jesuse. Itacꞌav: ―Voꞌone xa. Biqꞌuit toꞌox li cꞌalal ilic yuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ep ta velta ijipe ta cꞌocꞌ, ijipe ta ucꞌum yoꞌ ta xmile yuꞌun li pucuje. Pero mi xuꞌ avuꞌune, abolajan cꞌuxubinbun, coltabun ―xi li stot li quereme. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Li Jesuse jech laj yalbe: ―Mi chachꞌune, ta xcol. Yuꞌun scotol li buchꞌu tschꞌune ta spasbat scotol ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tsots icꞌopoj ta ora li stot li quereme: ―Ta jchꞌun. Coltaun ti mi oy to cꞌusi mu jchꞌun chavile ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cꞌalal iyil Jesús ti ta stsob sbaic talel ta anil ep crixchanoetique, la sloqꞌues ta ora li pucuje. Jech laj yalbe: ―Pucuj, joꞌot ta acoj ti jech pasem ta umaꞌ li quereme schiꞌuc ti macal schiquine. Joꞌon chajtac loqꞌuel. Locꞌan ta yoꞌon li quereme. Mu xa me xachaꞌoch nojtoc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsots iꞌavan li pucuje, la stupꞌbe comel yicꞌ li quereme, jaꞌ o ilocꞌ batel. Li quereme chamem icom yilel. Ep buchꞌutic laj yalic ti icham xa oe. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Li Jesuse la stsacbe scꞌob li quereme, la snit liquel, itots ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tsꞌacal to cꞌalal te xaꞌox oyic ta na li yoꞌ bu onoꞌox schꞌomna li Jesuse, jech ijacꞌbat yuꞌun li yajchanbalajeltaque: ―¿Cꞌu chaꞌal ti muc bu xlocꞌ cuꞌuncutic li pucuje? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Itacꞌav li Jesuse: ―Li jchop ta pucujetic li la jloqꞌuese, jaꞌ to ta xlocꞌ mi chataic ta naꞌel li Diose schiꞌuc mi chavicta aviximique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Li Jesuse ilocꞌ batel ta Capernaum schiꞌuc li yajchanbalajeltaque, te iꞌechꞌic ta yan jteclumetic ta Galilea balumil. Pero li Jesuse mu scꞌan ti ta xaꞌiic li crixchanoetic ti te ch‐echꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yuꞌun tscꞌan tschanubtas li yajchanbalajeltaque. Jech laj yalbe: ―Joꞌon li coꞌol crixchanoutique chiꞌaqꞌue ta scꞌob crixchanoetic. Chismilic. Chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Li yajchanbalajeltaque muc bu xaꞌibeic smelol li cꞌusi laj yal li Jesuse. Pero muc bu sjacꞌbeic li Jesuse yuꞌun chal yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Li Jesuse isutic batel ta Capernaum schiꞌuc li yajchanbalajeltaque. Cꞌalal ochemic xaꞌox ta schꞌomna li Jesuse, jech la sjacꞌbe li yajchanbalajeltaque: ―¿Cꞌusi la avalbe abaic talel ta bee? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Muc bu xtacꞌavic yuꞌun li ta bee te xjovilvulajetic o talel ti buchꞌu junucal ta xcom ta banquilal yuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ichoti li Jesuse, laj yalbe ti acꞌo nopojicuc talel li lajchavoꞌique, jech laj yalbe: ―Li buchꞌu tscꞌan chcom ta banquilal avuꞌunique, acꞌo sbicꞌtajes sba ta atojolic, acꞌo tunuc avuꞌunic ―xut li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iyicꞌ talel jun biqꞌuit querem li Jesuse. La svaꞌan ta oꞌlol li yoꞌ bu oyique, tsꞌacal to la spet. Jech laj yalbe li yajchanbalajeltaque: ");
INSERT INTO tzoSA_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Li buchꞌutic ti ta jventa joꞌon chichꞌic ta mucꞌ li buchꞌu jech yoꞌon jech chac cꞌu chaꞌal li unen liꞌi, joꞌon chiyichꞌic ta mucꞌ yaꞌel. Mi chiyichꞌic ta muqꞌue, jaꞌ ch‐ichꞌe ta mucꞌ li Jtot yaꞌele ti listac talele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Li Juane jech laj yalbe li Jesuse: ―Jchanubtasvanej, oy buchꞌu iquilcutic ta sloqꞌuesbe pucujetic ta yoꞌonic li crixchanoetique. Ta xal abi li cꞌalal ta sloqꞌuese. Pero la jpajescutic yuꞌun mu bacꞌne jchiꞌintic ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Itacꞌav li Jesuse: ―Mu me xapajesic. Yuꞌun li buchꞌu chacꞌ ta ilel stsatsal sjuꞌel Dios ta jventa joꞌone, mu tsꞌacluc to chopol chcꞌopoj ta jtojol. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Li buchꞌu ta sloqꞌues pucuj jech chac cꞌu chaꞌal ta jloqꞌuestique, jaꞌ coꞌol cabtel jchiꞌuctic. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Li buchꞌu ti jaꞌ noꞌox chayacꞌbeic jbochuc yoxoꞌ avuchꞌic yuꞌun chil ti chatunic cuꞌune, joꞌon li Cristoune, melel chacalbeic ti ta xichꞌ smoton eꞌuc ta sventa ti laj yacꞌ yoxoꞌ avuchꞌique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jech laj yal nojtoc li Jesuse: ―Li buchꞌu ta socbe yoꞌon junuc li buchꞌutic ti jech yoꞌonic jech chac cꞌu chaꞌal li unetic ti schꞌunojic ti joꞌon Yajcoltavanejicune, jaꞌ lec acꞌo chucbatuc jun choꞌ ta snucꞌ, acꞌo jipeuc ochel ta nab, acꞌo chamuc o. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mi ta scoj noꞌox acꞌobic ti chata o amulique, muc bu lec. Scꞌan ti chapajese jech chaꞌochic o ta vinajel. Abol abaic mi ta scoj noꞌox acꞌobic ti chabatic o ta mucꞌta cꞌocꞌ li bu mu xtupꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Li te ta mucꞌta cꞌoqꞌue mu xꞌechꞌ li vocole, mu xtupꞌ li cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jech nojtoc mi ta scoj noꞌox avoquic chata o amulique, muc bu lec. Scꞌan ti chapajese jech chaꞌochic ta vinajel. Abol abaic mi ta scoj noꞌox avoquic ti chabatic o ta mucꞌta cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Li te ta mucꞌta cꞌoqꞌue mu xꞌechꞌ li vocole, mu xtupꞌ li cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jech nojtoc mi ta scoj noꞌox asatic chata o amulique, muc bu lec. Scꞌan ti chapajes abaique jech chaꞌochic li yoꞌ bu ta spas mantal li Diose. Abol abaic mi ta scoj noꞌox asatic ti chabatic o ta mucꞌta cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Li te ta mucꞌta cꞌoqꞌue mu xꞌechꞌ li vocole, mu xtupꞌ li cꞌoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Li buchꞌu tscꞌan chtune yuꞌun li Diose persa ta stsꞌic vocol yoꞌ jech lec ta xꞌile yuꞌun li Diose. Jech chac cꞌu chaꞌal ti ta persa iꞌacꞌbat yatsꞌmel smoton Dios ta voꞌonee yoꞌ jech lec iyil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Li atsꞌame ta xtun, pero mi ichꞌay xa schiꞌil li atsꞌame, mu xa cꞌusi xtun o yuꞌun mu xa xchaꞌchiꞌub nojtoc. Jaꞌ noꞌox jech eꞌuc li joꞌoxuque, scꞌan ti chcuch avuꞌunic li vocole, schiꞌuc scꞌan ti jun avoꞌonic acotolique jech chatuneic yuꞌun li Diose ―xut li yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iloqꞌuic ta Capernaum schiꞌuc yajchanbalajeltac li Jesuse, ibatic ta Judea balumil, schiꞌuc ta jot ucꞌum Jordán. Toj ep jchiꞌiltacutic la stsob sbaic nojtoc ta stojol li Jesuse. Li Jesuse lic schanubtas jech chac cꞌu chaꞌal tspas onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te italic ta stojol Jesús jayvoꞌ jfariseoetic yuꞌun oy cꞌusi tsjacꞌbeic, yuꞌun tsqꞌuel mi tstabeic o smul li Jesuse. La sjacꞌbeic mi xuꞌ ta xicta yajnilic li viniquetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Itacꞌav li Jesuse: ―¿Cꞌusi mantal yaloj comel li Moisese? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Itacꞌavic li jfariseoetique: ―Li Moisese laj yal mantal ti xuꞌ ta smeltsanbe sjunal ti cꞌalal chicta sbaique, jech acꞌo yacꞌbe ta scꞌob li yajnile, jaꞌ to jech xuꞌ chicta sbaic ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Itacꞌav li Jesuse: ―Jaꞌ ta scoj ti toj tsots yoꞌonic li jtotic jmeꞌtic ta voꞌone ti jech laj yal mantal li Moisese. Jaꞌ yuꞌun jech la stsꞌiba comel. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ta sliqueb balumile cꞌalal la spas scotol li cꞌustic oy li Diose, jun vinic schiꞌuc jun ants noꞌox la spas. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yuꞌun jech tsꞌibabil ta scꞌop Dios: “Li queremutique ta svocꞌ sbaic schiꞌuc stot smeꞌic li cꞌalal tsaꞌ yajnilique. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Li chaꞌvoꞌique jun xa chcꞌotic”, xi. Jaꞌ yuꞌun mu xa chaꞌvoꞌicuc, junic xa. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Li buchꞌutic junic xa yuꞌun li Diose, mu xuꞌ xicta sbaic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tsꞌacal to cꞌalal te xaꞌox oy ta schꞌomna li Jesuse, ijacꞌbat yuꞌun li yajchanbalajeltac li cꞌu sba smelol li cꞌusi iyale. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Li Jesuse jech laj yalbe: ―Li buchꞌu chicta yajnile, mi chicꞌ yan antse, chmulivaj. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jaꞌ noꞌox jech eꞌuc li antse, mi chicta li smalale, mi tsmalin yan vinique, chmulivaj ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Li jchiꞌiltacutique iyiqꞌuic talel unetic ta stojol li Jesuse yoꞌ acꞌo yacꞌanbe scꞌob ta sjolic. Li yajchanbalajeltaque la spajesic li buchꞌutic laj yiqꞌuic talel li unetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cꞌalal iyil Jesús ti ta xpajesvanic li yajchanbalajeltaque, chopol iyaꞌi. Jech laj yalbe: ―Acꞌo talicuc ta jtojol li unetique, mu me xapajesic. Yuꞌun li buchꞌutic jaꞌ jechic jech chac cꞌu chaꞌal li unetique, lec to chaꞌiic pasel ta mantal yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Melel chacalbeic, li buchꞌutic mu scoꞌoltajes sbaic jech chac cꞌu chaꞌal li unetique, mu xuꞌ xꞌochic li yoꞌ bu ta spas mantal li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","La spet li unetic li Jesuse, laj yacꞌanbe scꞌob ta sjolic, schiꞌuc laj yacꞌbe slequil yutsilal. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cꞌalal ilocꞌ xaꞌox batel li Jesuse, ital ta anil jun jchiꞌilcutic ta israelal. La squejan sba ta stojol li Jesuse, jech la sjacꞌbe: ―Lequil jchanubtasvanej, ¿cꞌusi ta jpas yoꞌ chicuxi o sbatel osil? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Itacꞌav li Jesuse: ―¿Cꞌu chaꞌal chavalbun ti lequil jchanubtasvanejune? Yuꞌun jaꞌ noꞌox jun ti leque, jaꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xanaꞌ ti jech chal li mantaletique: “Mu me xamulivaj, mu me xamilvan, mu me xaꞌelcꞌaj, mu me xasaꞌbe smul achiꞌil, mu me xaloꞌlovan, ichꞌo ta mucꞌ atot ameꞌ”, xi tsꞌibabil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Itacꞌav li vinique: ―Jchanubtasvanej, scotol li cꞌustic la avale, ta jbicꞌtal onoꞌox lic jchꞌun ―xi li jcꞌulej vinique. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Li Jesuse la sqꞌuelbe sat li vinique, toj cꞌux ta yoꞌon iyil. Jech laj yalbe: ―Pero oy to cꞌusi scꞌan chapas. Ba chono scotol li cꞌustic oy avuꞌune. Li stojole qꞌuelananbo li meꞌonetique, jaꞌ oy o acꞌulejal ta vinajel. Tsꞌacal to xtal achiꞌinun ta ichꞌ vocol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cꞌalal iyaꞌi jech li vinique, toj chibajel noꞌox yoꞌon. Chat tajmec yoꞌon ibat yuꞌun toj ep cꞌustic oy yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Li Jesuse la sqꞌuel li crixchanoetic li te oy ta jujot xocone. Jech laj yalbe li yajchanbalajeltaque: ―Li jcꞌulejetique toj vocol chacꞌ sbaic ta scꞌob li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Li yajchanbalajeltaque toj chꞌayel noꞌox yoꞌonic ta sventa ti jech iyale. Li Jesuse jech laj yalbe nojtoc: ―Jnichꞌnabtac, li buchꞌutic jaꞌ noj batem ta yoꞌonic li scꞌulejalique toj vocol chacꞌ sbaic ta scꞌob li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jech chac cꞌu chaꞌal mu xjelav jcot cameyo ta chac acuxae, jaꞌ jech mu xuꞌ xꞌoch li yoꞌ bu ta spas mantal Dios li buchꞌutic ti jaꞌ noj batem ta yoꞌonic li scꞌulejalique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Cꞌalal jech iyaꞌiic li yajchanbalajeltaque, más to toj chꞌayel noꞌox yoꞌonic. Jech laj yalbe sbaic: ―Mi mu xcolic li jcꞌulejetique, ¿buchꞌu ma ti chcol yaꞌele chaꞌa? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Li Jesuse isqꞌuelbe sat li yajchanbalajeltaque, jech laj yalbe: ―Li crixchanoetique mu xuꞌ ta scolta sba stuquic sventa sbatel osil. Jaꞌ noꞌox xuꞌ ta xcolic ta sventa li Diose, yuꞌun scotol xuꞌ yuꞌun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Li Pedroe jech laj yalbe li Jesuse: ―Li joꞌoncutique laj xa quictacutic scotol li cꞌustic oy toꞌox cuꞌuncutique. Liꞌ xa jchiꞌucotcutique ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Itacꞌav li Jesuse: ―Melel li cꞌusi chacalbeique, li buchꞌutic laj xa yicta snaique, mi sbanquiltac, mi yitsꞌinabtac, mi svixobtac, mi yixleltac, mi smucobtac, mi stot, mi smeꞌ, mi snichꞌnabtac, mi yalabtac, mi yosil ta jventa joꞌon yoꞌ ta spuquic batel li jcꞌope, ta stabe más sqꞌuexol li cꞌustic oy toꞌox yuꞌune. Mi sna, mi sbanquiltac, mi yitsꞌinabtac, mi svixobtac, mi smucobtac, mi yixleltac, mi smeꞌ, mi snichꞌnabtac, mi yalabtac, mi yosil, scotol ta xꞌacꞌbat. Ta xichꞌ contrainel nojtoc. Tsꞌacal to ta xcuxiic o sbatel osil li te ta achꞌ balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero li buchꞌutic banquilal spꞌisoj sbaic li avie, jaꞌ itsꞌinal chcomic yuꞌun la stoy sbaic. Yan li buchꞌutic itsꞌinal ta xꞌileic li avie, jaꞌ banquilal chcomic yuꞌun la sbicꞌtajes sbaic. Ep li buchꞌutic itsꞌinal ta xcomique; ep nojtoc li buchꞌutic banquilal ta xcomique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cꞌalal yacalic ta xanbale yuꞌun chbatic ta Jerusalén schiꞌuc li yajchanbalajeltac li Jesuse, jaꞌ sbabe batel li Jesuse. Li yajchanbalajeltaque ichꞌay yoꞌonic ti ta xjelav batele, ixiꞌic. Li Jesuse laj yicꞌ li lajchavoꞌique, laj yalbe li cꞌusi tspasbat li cꞌalal chcꞌot ta Jerusalene: ");
INSERT INTO tzoSA_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Xanaꞌic ti te chijbat ta Jerusalene. Joꞌon li coꞌol crixchanoutique, te chiꞌaqꞌue ta scꞌob li banquilal paleetique schiꞌuc ta scꞌob li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Te chalic ti chiyaqꞌuic ta milele. Chiyaqꞌuic ta scꞌob li buchꞌutic maꞌuc jchiꞌiltactic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chislabanic, chistsitsic ta nucul, chistubtabeic jsat. Chismilic, chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Li Jacobo schiꞌuc li Juane, jaꞌ li snichꞌnab li Zebedeoe, inopojic talel ta stojol li Jesuse. Jech laj yalbeic: ―Jchanubtasvanej, ta jcꞌan ti chavacꞌbuncutic li cꞌusi chajcꞌanbecutique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Itacꞌav li Jesuse: ―¿Cꞌusi chacꞌanic ti chajpasbeique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Itacꞌav li chaꞌvoꞌique: ―Cꞌalal chtal apas mantale, acꞌo chotlucuncutic jun ta abatsꞌicꞌob, jun ta atsꞌet ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Itacꞌav li Jesuse: ―Mu xanaꞌic cꞌu sba svocolal li cꞌusi chacꞌanbecune. ¿Mi xcuch avuꞌunic li at‐oꞌone, li vocole, li milele, jech chac cꞌu chaꞌal ta xquichꞌe? ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Itacꞌavic: ―Xuꞌ cuꞌuncutic ―xiic. Iꞌalbatic yuꞌun li Jesuse: ―Melel ta onoꞌox xavichꞌic vocol jech chac cꞌu chaꞌal chquichꞌe. Chavichꞌic milel nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ti chacꞌan chachotiic jun ta jbatsꞌicꞌob, jun ta jtsꞌete, joꞌone mu xuꞌ chacacꞌbeic. Jaꞌ ta xal stuc li Jtot ti buchꞌutic te ta xchotiique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Li lajunvoꞌique chopol iyaꞌiic li cꞌusi iyalic li chaꞌvoꞌique. Jaꞌ yuꞌun iꞌiltaatic li chaꞌvoꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Li Jesuse laj yicꞌ li lajchavoꞌique, jech laj yalbe: ―Xanaꞌic li cꞌu sba ta spasic li ajvaliletic yuꞌunic li jyanlumal crixchanoetique. Jaꞌ noꞌox ta spasic mantal. Jech nojtoc li buchꞌutic acꞌbil yabtelic yuꞌun li ajvalile, jaꞌ noꞌox ta sujvanic ta abtel. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Pero li joꞌoxuque mu me xapasic jech. Li buchꞌu junucal avuꞌunic ti tscꞌan chcom ta banquilale, ti tscꞌan ichꞌbil ta muqꞌue, acꞌo sbicꞌtajes sba ta atojolic, acꞌo tunuc avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jech chac cꞌu chaꞌal joꞌon li coꞌol crixchanoutique, muc bu tal pasvancun ta mantal. Ti litale, yuꞌun tal tuncun yuꞌun scotol li crixchanoetique. Tal cacꞌ jba ta milel ta scojic yoꞌ jech chcolic o sbatel osil ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Icꞌotic ta jteclum Jericó. Tsꞌacal to cꞌalal iloqꞌuic batel schiꞌuc li yajchanbalajeltac li Jesuse, toj ep jchiꞌiltacutic tijilic batel. Te chotol ta tiꞌbe istaic jun maꞌsat, Bartimeo sbi. Jaꞌ snichꞌon Timeo. Te chcꞌanolaj. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cꞌalal iyaꞌi li maꞌsat ti te ch‐echꞌ Jesús li liquem talel ta Nazarete, laj yapta: ―¡Jesús, joꞌot snitilulot David ti scꞌoplal onoꞌox chaꞌoch ta ajvalilal cuꞌuncutique, ichꞌun ta cꞌux! ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Li epal crixchanoetic li te schiꞌuquic echꞌel li Jesuse, laj yutic la spajesic li maꞌsate: ―¡Anchan! ―xutic. Pero más to tsots icꞌopoj li maꞌsate: ―¡Joꞌot snitilulot David, ichꞌun ta cꞌux! ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ivaꞌi li Jesuse, laj yalbe crixchanoetic ti acꞌo yiqꞌuic talele. Jech laj yalbeic li maꞌsate: ―Mu xavat avoꞌon. Lican, chastac ta iqꞌuel li Jesuse ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","La sjip comel ta ora li spuychij li maꞌsate, itots ta anil, ital ta stojol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jech iꞌalbat yuꞌun li Jesuse: ―¿Cꞌusi chacꞌan chajpasbe? ―xꞌutat. Itacꞌav li maꞌsate: ―Jchanubtasvanej, avocoluc jambun li jsate ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Itacꞌav li Jesuse: ―Batan, ijam xa la asate yuꞌun la achꞌun ti oy juꞌele ―xi li Jesuse. Ijam ta ora li sate, la schiꞌin batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cꞌalal nopol xaꞌox xbatic ta Jerusalén schiꞌuc li yajchanbalajeltac li Jesuse, te icꞌotic ta colonia Betfajé schiꞌuc li biqꞌuit jteclum Betaniae, li te ta yoc vits Olivatique. Li Jesuse la stac jelavel chaꞌvoꞌ yajchanbalajeltac. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jech laj yalbe: ―Batanic leꞌ ta coloniae. Cꞌalal chaꞌochique, te chucul chataic jcot chexel burro muc to bu cajlebinbil. Jitunic, nitic talel. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi oy buchꞌu chasjacꞌbeic ti cꞌu chaꞌal chajitunic li burroe, albeic: “Yuꞌun ta xtun yuꞌun li Cajvaltique. Ta stac sutel ta ora”, utic ―xꞌutatic batel yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ibatic. Te chucul ta tiꞌbe ta nopol tiꞌna istaic jcot chexel burro. La sjitunic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Oy jayvoꞌ crixchanoetic te vaꞌalic, jech laj yalic: ―¿Cꞌu chaꞌal chajitunic li burroe? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Laj yalbeic jech chac cꞌu chaꞌal iꞌalbatic batel yuꞌun li Jesuse, jech iꞌacꞌbat yiqꞌuic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","La snitic talel li burroe. Laj yacꞌbeic spuychijic sventa staspat, la scajlebin li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ep buchꞌu la sqꞌuianic spuychijic ta be li bu ch‐echꞌ ba li Jesuse. Oy yanetic la scꞌasic yanalteꞌ, la slamanic ta be yuꞌun chichꞌic ta mucꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Li buchꞌutic sbabe batele schiꞌuc li buchꞌutic tijilic talele, tsots icꞌopojic scotolic. Jech laj yalic: ―¡Coliyal Dios toj lec li buchꞌu la stacbutic talele! ");
INSERT INTO tzoSA_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Acꞌo quichꞌtic ta mucꞌ li buchꞌu tal spasutic ta mantal jech chac cꞌu chaꞌal la spas mantal li jtotic jmeꞌtic David ta voꞌonee! ¡Acꞌo acꞌbatuc más slequilal yutsilal Dios! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jaꞌ jech iꞌoch ta Jerusalén li Jesuse. Te icꞌot ta yamaqꞌuil li mucꞌta chꞌulnae. La sqꞌuel li buchꞌutic te oyic ta yamaqꞌuil li chꞌulnae. Iloqꞌuic batel, ibatic ta Betania schiꞌuc li lajchavoꞌ yajchanbalajeltaque yuꞌun mal xaꞌox cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta yocꞌomal iloqꞌuic ta Betania nojtoc li Jesús schiꞌuc li yajchanbalajeltaque yuꞌun chbatic ta Jerusalén. Li Jesuse ilic sviꞌnal. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iyil ta nom jtecꞌ higo. Oy yanal jech ba sqꞌuel mi oy sat. Pero muꞌyuc sat ista, jaꞌ noꞌox oy yanal, yuꞌun maꞌuc toꞌox yora ta satin. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Li Jesuse jech laj yalbe comel li teꞌel higoe: ―Muc xa bu chasatin o ―xut. Iyaꞌiic li yajchanbalajeltac ti jech laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cꞌalal icꞌotic ta Jerusalene, te ibatic schiꞌuc yajchanbalajeltac ta yamaqꞌuil li mucꞌta chꞌulna li Jesuse. La snutsan loqꞌuel scotol li jpꞌolmaletique, schiꞌuc li jmanolajeletic li te ta yamaqꞌuil li mucꞌta chꞌulnae. La svalcꞌunbe smexaic li jeltaqꞌuinetique. La sbutqꞌuinbe xilaic li jchonjculajteꞌetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Schiꞌuc mu xacꞌ ti oy buchꞌu ta xꞌechꞌ schiꞌuc yicats li te ta yamaqꞌuil li mucꞌta chꞌulnae. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te lic chanubtasvanuc li Jesuse, jech laj yal: ―Avilojic ti jech tsꞌibabil comel ta scꞌop li Diose: “Li jnae jaꞌ snail li bu chistaic ta naꞌel li crixchanoetic ta spꞌejel balumile”, xi li Diose. Pero li joꞌoxuque apasic xa ta snailchꞌen jꞌeleqꞌuetic ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iyaꞌiic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li banquilal paleetique. Chopol iyaꞌiic, jech lic snopic ti cꞌu sba xuꞌ tsmilic li Jesuse yuꞌun ixiꞌic mi te chba schiꞌinic Jesús scotol li jchiꞌiltacutique. Yuꞌun ep li jchiꞌiltacutique labal iyaꞌiic li cꞌu sba ichanubtasvan li Jesuse yuꞌun toj lec iyaꞌiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cꞌalal xtupꞌet xaꞌox osile, iloqꞌuic batel ta Jerusalén li Jesuse schiꞌuc li yajchanbalajeltaque, isutic batel ta Betania. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta sob ta yocꞌomale te ichaꞌechꞌic nojtoc li yoꞌ bu li teꞌel higoe. Iyilic ti taquin xa cꞌalal ta yibel li teꞌel higoe. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ijul ta sjol Pedro li cꞌusi laj yalbe li teꞌel higo li Jesuse. Laj yalbe li Jesuse: ―Jchanubtasvanej, qꞌuelavil li teꞌel higo li lavalbe ti muc xa bu ta satin oe, itaquij o ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Itacꞌav li Jesuse: ―Chꞌunic ti scotol xuꞌ yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Melel li cꞌusi chacalbeique, mi chachꞌunic ti joꞌon chajcoltaique, mi mu xanopic ti mu xuꞌe, mi achꞌunojic ti ta onoꞌox xapasbatic li cꞌusi chavalique, ta onoꞌox xcꞌot ta pasel li cꞌusi chavalique. Jech chac cꞌu chaꞌal mi chavalbeic ti acꞌo locꞌuc li vits liꞌi, ti acꞌo sjip sba ochel ta nabe, ta onoꞌox xaspasbeic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jech chacalbeic, scotol li cꞌusi chacꞌanbeic li Diose, chꞌunic ti chaꞌacꞌbatique jech ta onoꞌox xavichꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cꞌalal chataic ta naꞌel li Diose, mi chjul ta ajolic ti oy buchꞌu oy smul avuꞌunique, pasbeic perton. Jech chaspasbeic perton eꞌuc yuꞌun amulic li Jtotic ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yan mi mu xapasbeic perton la achiꞌilique, jaꞌ noꞌox jech eꞌuc muc bu chaspasbeic perton li Jtotic ta vinajele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Icꞌotic nojtoc ta Jerusalén schiꞌuc li yajchanbalajeltac li Jesuse. Cꞌalal te chanav Jesús ta yamaqꞌuil li mucꞌta chꞌulnae, te tal cꞌoponatuc yuꞌun li banquilal paleetic schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc jayvoꞌ li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jech la sjacꞌbeic li Jesuse: ―¿Buchꞌu laj yacꞌbot ajuꞌel yoꞌ chapas li cꞌustic chapase? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Itacꞌav li Jesuse: ―Oy cꞌusi chajacꞌbeic eꞌuc. Mi chavalbecun li cꞌusi chajacꞌbeique, chacalbeic eꞌuc ti buchꞌu liyacꞌbe juꞌel ti jech ta jpase. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Buchꞌu iꞌacꞌbat yabtel li Juan ti iyacꞌ ta ichꞌel joꞌe? ¿Mi jaꞌ Dios iꞌacꞌbat, mi crixchano noꞌox iꞌacꞌbat? Albecun caꞌi ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Te lic yalulanbe sbaic: ―Mi chcaltic ti jaꞌ iꞌacꞌbat yabtel yuꞌun li Diose, jech chijyalbutic: “¿Cꞌu chaꞌal muc bu xachꞌunic chaꞌa?” xijyututic. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mi icaltic ti jaꞌ iꞌacꞌbat yabtel yuꞌun crixchano li Juane, pero muc bu lec chaꞌi li jchiꞌiltactique ―xut sbaic. Ti jech laj yalbe sbaique, yuꞌun scotol jchiꞌiltacutic schꞌunojic ti melel laj yal scꞌop Dios li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jaꞌ yuꞌun jech itacꞌavic: ―Mu jnaꞌcutic ―xiic. Iꞌalbatic yuꞌun li Jesuse: ―Jaꞌ jechun eꞌuc, muc bu chacalbeic ti buchꞌu liyacꞌbe juꞌel ti jech ta jpase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Li Jesuse lic yalbe jun loꞌil li jchiꞌiltacutic ta israelale. Jech laj yalbe: ―Oy jun vinic la stsꞌun ep tsꞌusub ta yosil. La sjoy ta moc li tsꞌusubtique. La sjom ton jaꞌ yav sventa spitsꞌobil yaꞌlel li sat tsꞌusube. La spas jun toyol sqꞌuelobil osil. La saꞌbe comel buchꞌutic ta schabiic li tsꞌusubtique. Ibat ta nom li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Cꞌalal ista yora ta xtaꞌaj li sat tsꞌusube, la stac batel jun yajtunel yuꞌun ba yichꞌ talel li cꞌu onoꞌox yepal yaloj chichꞌe. Cꞌot scꞌanbe li buchꞌutic ta schabiique. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero li jchabiejtsꞌusubtique la stsaquic li jtunele, la smajic, la staquic sutel. Mu cꞌusi xacꞌbeic echꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Li yajval li osile la stac batel yan yajtunel nojtoc. Pero laj yacꞌbeic ton, iyaij sjol. Toj echꞌem iyilbajinic batel. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","La stac batel yan yajtunel nojtoc li yajval osile pero la smilic. Ep yan yajtuneltac la stac batel pero jaꞌ noꞌox jech la spasbeic. Oy jꞌoꞌlol la smajic, oy jꞌoꞌlol la smilic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Oy jun snichꞌon li yajval osile, toj cꞌux ta yoꞌon. Jaꞌ slajeb xa la stac batel. Jech la snop li yajval osile: “Jaꞌ nan ch‐aqꞌue ta venta li jnichꞌone”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero cꞌalal iyilic li jchabiejtsꞌusubtic ti jaꞌ xa snichꞌon li yajval osile, jech laj yalbe sbaic: “Leꞌe jaꞌ chichꞌbe comel li yosil li stote. Jaꞌ lec ta jmiltic yoꞌ jech joꞌotic chquichꞌbetic o comel li yosile”, xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","La stsaquic, la smilic, la sloqꞌuesic ta pat moc. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’Cꞌalal ta sut talel li yajval tsꞌusubtique, ¿cꞌusi chjul spasbe xanaꞌic li jchabiejtsꞌusubtique? Chlaj smilan. Yan xa o buchꞌutic ta xacꞌbe schabiic li tsꞌusubtique. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Aqꞌuelojic li cꞌusi chal li scꞌop Diose: Jech chac cꞌu chaꞌal li yajval na ti la stꞌuj jpꞌej ton sventa ta xacꞌ ta chiquin nae, pero li svinictac ta vaꞌanejnae mu scꞌanic. Li ton li la spꞌajique jaꞌ onoꞌox iꞌoch ta chiquin na. Jaꞌ noꞌox jech eꞌuc, li buchꞌu tꞌujbil yuꞌun li Diose, acꞌo mi mu xcꞌanee, pero ta onoꞌox xꞌacꞌbat tsots yabtel. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Toj lec ti jech tspas li Diose, xi tsꞌibabil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Li banquilal paleetique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletique, taꞌox stsaquic li Jesuse yuꞌun snaꞌic ti jaꞌ scꞌoplal stuquic li laj yal ta loꞌile. Pero ixiꞌic yuꞌun li crixchanoetique jech muc bu stsaquic. Te laj yictaic, ibatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ta tsꞌacale la staquic talel ta stojol Jesús jayvoꞌ jfariseoetic schiꞌuc jayvoꞌ svinictac li Herodese yuꞌun oy cꞌusi tsjacꞌbeic li Jesuse, jaꞌ yoꞌ tstabeic o smul ti yalojique. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Cꞌalal icꞌotic ta stojol li Jesuse, jech laj yalbeic: ―Jchanubtasvanej, jnaꞌojcutic ti melel scotol li cꞌusi chavale, ti jamal chaval li cꞌusi tscꞌan Dios ti acꞌo jpascutique, ti mu tꞌujbiluc chachaꞌle li buchꞌu chavalbee. Alo caꞌicutic li cꞌusi chanope. ¿Mi lec chil Dios ti ta jtojbecutic jpatancutic li Césare, mi moꞌoj? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Li Jesuse snaꞌoj ti yuꞌun noꞌox chqꞌuelbat yoꞌone, jech la stacꞌbe: ―¿Cꞌu chaꞌal tal aqꞌuelbecun coꞌon? Ichꞌic talel junuc li taqꞌuin sventa ta jtojtic o jpatantique, ta jqꞌuel ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Laj yichꞌbeic talel. Ijacꞌbatic yuꞌun li Jesuse: ―¿Buchꞌu slocꞌol liꞌi? ¿Buchꞌu sbi liꞌi? ―xꞌutatic. Itacꞌavic: ―Jaꞌ César ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iꞌalbatic yuꞌun li Jesuse: ―Scꞌan ta jpasbetic li yabtel ti chal li Césare yuꞌun jaꞌ mucꞌta ajvalil. Jech nojtoc scꞌan ta jpasbetic li cꞌusi chal li Diose ―xꞌutatic. Cꞌalal iyaꞌiic li cꞌu sba itacꞌav li Jesuse, toj chꞌayel noꞌox yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Italic ta stojol Jesús jayvoꞌ li jsaduceoetique, jaꞌ li buchꞌutic chalic ti muꞌyuc chaꞌcuxesele. Jech la sjacꞌbeic li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Jchanubtasvanej, jech la stsꞌiba comel li Moisés ta voꞌonee: “Mi icham jun vinic, mi muꞌyuc snichꞌon chcome, li itsꞌinal ti muꞌyuc to yajnile, acꞌo yicꞌbe yajnil li ánima sbanquile. Cꞌalal ta xil schꞌamale, jaꞌ acꞌo yacꞌbe sbiinbe sbi li ánima sbanquile, jaꞌ yoꞌ mu xchꞌay o li sbi li ánima sbanquile”, xi li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oy jucvoꞌ jchiꞌiltic ta israelal sbanquil yitsꞌin noꞌox sbaic. Li banquilale la saꞌ yajnil, pero icham li banquilale, muꞌyuc snichꞌon icom. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Li itsꞌinale laj yicꞌbe yajnil li ánima sbanquile. Tsꞌacal to icham eꞌuc. Muꞌyuc snichꞌon icom nojtoc. Jaꞌ jech la spasulanic sjucvaꞌalic. Xcholet sjucvaꞌalic laj yiqꞌuic li antse yuꞌun laj chamicuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Muc bu icom snichꞌon sjucvaꞌalic cꞌalal ichamique. Tsꞌacal to icham eꞌuc li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cꞌalal ta xchaꞌcuxiique, ¿buchꞌu junucal ta xicꞌ o li antse yuꞌun scotolic laj yicꞌulanic? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Itacꞌav li Jesuse: ―Mu xanaꞌic li cꞌusi chal li scꞌop Diose. Mu xanaꞌic li cꞌu sba sjuꞌel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cꞌalal ta xchaꞌcuxiique, muꞌyuc yajnil li viniquetique, muꞌyuc smalal li antsetique. Jaꞌ xa jechic jech chac cꞌu chaꞌal li yajꞌangeltac Dios ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ti jech muc bu achꞌunojic ti ta xchaꞌcuxiic li ánimaetique, ¿mi yuꞌun muc bu aqꞌuelojic ta sjun Moisés li yoꞌ bu chal li cꞌalal icꞌoponat yuꞌun Dios li te ta jtecꞌ biqꞌuit chꞌixe? Jech iꞌalbat yuꞌun li Diose: “Joꞌon Diosun yuꞌun li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove”, xꞌutat. Acꞌo mi voꞌone xa chamemic, pero te to ch‐albat scꞌoplalic yuꞌun li Diose yuꞌun cuxulic. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ti lajemicuc o schiꞌuc schꞌulelic jech chac cꞌu chaꞌal chavalique, muꞌyuc Dios yuꞌunic yaꞌel. Li Diose jaꞌ Dios yuꞌunic li buchꞌutic cuxulic o sbatel osile. Mu to xanaꞌic tajmec ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Te inopoj talel jun li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose yuꞌun iyaꞌi ti te chloꞌilajic Jesús schiꞌuc li jsaduceoetique. Cꞌalal iyaꞌi ti lec itacꞌbatic yuꞌun li Jesuse, jech la sjacꞌbe eꞌuc: ―Ta scotol smantaltac li Dios ti laj yal comel li Moisés ta voꞌonee, ¿cꞌusi junucal ti más tsotse? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Itacꞌav li Jesuse: ―Li smantal Dios ti más tsotse jaꞌ liꞌi: “Aꞌiic me, jchiꞌiltac, joꞌotic li jꞌisraelutique. Jun noꞌox li Cajvaltic Diose, jaꞌ li Dios cuꞌuntique. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sloqꞌueluc me avoꞌonic cꞌanic me li Dios cuꞌuntique. Acꞌbo sventain avoꞌonic, schiꞌuc apꞌijilic, schiꞌuc atsatsalic. Acꞌo tunuc yuꞌun”, xi li mantale. Leꞌe jaꞌ li más tsotse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Li schibale jaꞌ noꞌox jech tsots nojtoc. Jech chal: “Cꞌuxubino me achiꞌilic jech chac cꞌu chaꞌal cꞌux chavaꞌi aba atuque”, xi. Li chib mantal liꞌi jaꞌ li más tsotse ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Itacꞌav li vinique: ―Jchanubtasvanej, melel li cꞌusi avale. Ta melel jun noꞌox Dios oy, muꞌyuc yan. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Melel jaꞌ scꞌan ti acꞌo jcꞌantic ta sloqꞌuel coꞌontic li Dios cuꞌuntique, ti acꞌo cacꞌbetic sventain li coꞌontic, schiꞌuc jpꞌijiltic, schiꞌuc li jtsatsaltique, ti acꞌo tunuc yuꞌun li Diose. Schiꞌuc scꞌan nojtoc ti acꞌo jcꞌuxubintic jchiꞌiltic jech chac cꞌu chaꞌal cꞌux chcaꞌi jba jtuctique. Jaꞌ li más tsotse. Jaꞌ mu tsotsuc scꞌoplal li smoton Dios ti ta jchicꞌtique schiꞌuc ti ta jmiltique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cꞌalal iyaꞌi Jesús ti lec itacꞌav li jchanubtasvaneje, jech laj yalbe: ―Jutuc xa scꞌan chavacꞌ aba ta scꞌob li Diose ―xut. Mu xa buchꞌu junucal isjacꞌbe. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Cꞌalal ichanubtasvan Jesús ta yamaqꞌuil li mucꞌta chꞌulnae, jech laj yal scꞌoplal stuc: ―¿Cꞌu chaꞌal chalic li jchanubtasvanejetic ta smantaltac li Diose ti snitilul noꞌox David li Cristoe, jaꞌ li buchꞌu tꞌujbil yuꞌun Dios ti chventainvane? ");
INSERT INTO tzoSA_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yuꞌun li Davide ta sventa li Chꞌul Espíritue jech laj yal: Li Cajvale jech iꞌalbat yuꞌun li Diose: “Chachoti ta jbatsꞌicꞌob, chapas mantal jaꞌ to mi la jpas ta canal scotol la avajcontrataque”, xꞌutat li Cristoe, xi li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Li Davide laj yal ti jaꞌ yajval li buchꞌu tꞌujbil yuꞌun Dios ti chventainvane, jech maꞌuc noꞌox snitilul David li Cristoe ―xi li Jesuse. Li epal crixchanoetic li te tsobolique ta sloqꞌuel yoꞌonic laj yaꞌibeic scꞌop li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jech laj yal cꞌalal ichanubtasvan li Jesuse: ―Qꞌuelo me abaic, mu me xasloꞌlooxuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jaꞌ lec chaꞌiic ti ta slapic nat scꞌuꞌic li cꞌalal ta xloqꞌuic ta xanbale, schiꞌuc lec chaꞌiic ti lequil cꞌoponbilic yuꞌun li jchiꞌiltactic li te ta chꞌivite. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lec chaꞌiic nojtoc ti ta xchotiic li bu tꞌujbil chotlebal ta chꞌulnaetique. Jech tspasic nojtoc li ta jujun qꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Schiꞌuc ta sloꞌlobeic li cꞌustic oy yuꞌun li meꞌanal antsetique. Jaꞌ yuꞌun altic ti jal ta staic ta naꞌel li Diose. Ta onoꞌox xichꞌic tsots vocol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Li Jesuse ichoti ta yamaqꞌuil li mucꞌta chꞌulna ta stuqꞌuil scaxail taqꞌuin li yoꞌ bu ta sticꞌbeic smoton Dios li jchiꞌiltacutic ta israelale. Iyil ti te ta stiqꞌuic smoton Dios li jchiꞌiltacutique. Ep jcꞌulejetic la stiqꞌuic ep taqꞌuin. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te ital jun meꞌanal ants ti mu cꞌusi xꞌayan yuꞌune. Jaꞌ noꞌox chaꞌsep cinco la sticꞌ ta caxa. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Li Jesuse laj yicꞌ li yajchanbalajeltaque, jech laj yalbe: ―Melel chacalbeic, jaꞌ más ep laj yacꞌ li meꞌanal ants leꞌe, jaꞌ mu sta jech yepal laj yaqꞌuic li yanetic ta xil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yuꞌun naca scomenal xa staqꞌuinic laj yaqꞌuic. Yan li meꞌanal antse laj yacꞌ scotol li cꞌu yepal oy yuꞌun ti ta toꞌox sman o li cꞌustic ta xtun yuꞌune ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cꞌalal yuꞌun xaꞌox chloqꞌuic ta stiꞌ smacol li mucꞌta chꞌulna li Jesús schiꞌuc li yajchanbalajeltaque, jech iꞌalbat yuꞌun jun li yajchanbalajele: ―Jchanubtasvanej, qꞌuelavil, toj cꞌupil sba li stanal li chꞌulnae schiꞌuc li naetic liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Itacꞌav li Jesuse: ―Toj cꞌupil sba chavilic li avie, pero chcꞌot scꞌacꞌalil ti mu jpꞌejuc ton latsal chcome, yuꞌun chtal sjinesic jyanlumal crixchanoetic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Li Jesuse te ba chotluc ta vits Olivatic schiꞌuc li yajchanbalajeltaque ta stuqꞌuil li mucꞌta chꞌulnae. Li Pedro, schiꞌuc Jacobo, schiꞌuc Juan, schiꞌuc Andrés, stuquic jech laj sjacꞌbeic li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Alo caꞌicutic cꞌu ora chcꞌot ta pasel ti chjinesat li mucꞌta chꞌulna li la avale. ¿Cꞌu sba chavacꞌbe svinajeb baꞌi ti yoꞌ chquilcutic o ti poꞌot xa chcꞌot ta pasele? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Itacꞌav li Jesuse: ―Qꞌuelo me abaic, mu me buchꞌu xasloꞌloic. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yuꞌun oy ep buchꞌutic chalic ti jaꞌ sbi li jbie, jech chalic: “Joꞌon Cristoun li tꞌujbilun yuꞌun Dios ti chajventainique”, xiic. Jaꞌ jech ep buchꞌutic ta schꞌunic loꞌloel. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Cꞌalal chavaꞌiic ti oy cꞌop liꞌi, schiꞌuc cꞌalal chavaꞌiic ti oy cꞌop ta nome, mu xaxiꞌic. Ta onoꞌox xcꞌot ta pasel pero maꞌuc toꞌox slajeb cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chlic saꞌic cꞌop li crixchanoetic ta yantic o balumile. Chlic saꞌic cꞌop li ajvaliletic nojtoque. Schiꞌuc oy bu ch‐echꞌ niquel ta balumil. Chtal tsots viꞌnal. Pero taje sliqueb to li vocole. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pero li joꞌoxuque qꞌuelo me abaic. Yuꞌun li jchiꞌiltactic ta israelale oy buchꞌutic chayacꞌ ta scꞌob jꞌabteletic li te ta mucꞌta chꞌulnae. Oy buchꞌutic chastsitsic ta nucul li te ta chꞌulnaetique. Ta sventa ti avichꞌojicun ta muqꞌue, chayiqꞌuic batel ta stojol li gobernadoretique schiꞌuc ta stojol li mucꞌtic ajvaliletique. Jaꞌ yuꞌun xuꞌ xavalic li jcꞌop ta stojolique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yuꞌun persa baꞌi ta xꞌalbatic li crixchanoetic ta spꞌejel balumil ti jaꞌ noꞌox chcolic ta jventa joꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cꞌalal chba yacꞌoxuc ta cꞌabale, mu me xal avoꞌonic li cꞌusi chavalique schiꞌuc li cꞌu sba chatacꞌavique. Yuꞌun jaꞌ tsjules ta ajolic li Chꞌul Espíritue li cꞌu sba chatacꞌavique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oy buchꞌutic chaqꞌuic ta milel yitsꞌinic, mi sbanquilic. Oy buchꞌutic chaqꞌuic ta milel li snichꞌonique. Oy buchꞌutic tscontrainic stot smeꞌic, chaqꞌuic ta milel. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ep buchꞌutic chopol chayilic ta sventa ti avichꞌojicun ta muqꞌue. Pero li buchꞌutic chcuch yuꞌun scotol li vocole, mi mu schibajes yoꞌonique, jaꞌ chcolic o sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Li cꞌusi chajtsꞌibabeic batel liꞌi, nopbeic lec li smelole yuꞌun jech onoꞌox laj yal li Jesuse: ―Li cꞌalal chavilic ti te vaꞌanbil ta yut mucꞌta chꞌulna li cꞌusi chopol chil li Diose jech chac cꞌu chaꞌal laj yal Daniel li iyal scꞌop Dios ta voꞌonee, jatavanic batel ta anil ta vitstic, joꞌoxuc li liꞌ nacaloxuc ta Judeae. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Li buchꞌutic ti te oyic ta sjol snaic ti pachꞌale, cꞌalal ta xyalic talele, mu xa me xꞌoch sloqꞌuesic li cꞌustic oy ta yut snaique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Li buchꞌutic ti te oyic ta yabtelique, mu xa me sutic talel ta snaic yoꞌ chtal yichꞌic li spuychijique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Toj abol sbaic li buchꞌutic schiꞌuc yolique schiꞌuc li buchꞌutic ta to xchuꞌun yolique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taic ta naꞌel Dios ti mu me ta yora sictic li cꞌalal chajatavique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuꞌun toj tsots li vocol li ta xtale. Muc onoꞌox bu jech echꞌem li cꞌalal ilic li balumile, schiꞌuc cꞌalal tana. Mi iꞌechꞌ li tsots vocol taje, mu xa bu chtal. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ti manchuc tspajes li vocol li Diose, mu junuc buchꞌu chcol avuꞌunic ti jechuque. Pero ta sventa li buchꞌutic tꞌujbilique, li Diose tspajes li vocole. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Mi oy buchꞌu jech chayalbeic: “Liꞌ xa oy li Cristoe”, mi xayutique, mu me xachꞌunic. Mi oy buchꞌu yan nojtoc jech chayalbeic: “Leꞌ xa oy li Cristoe”, mi xayutique, mu me xavaqꞌuic ta venta. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yuꞌun chtalic li buchꞌutic spꞌisoj sbaic ti jaꞌ tꞌujbilic yuꞌun Dios ti chasventainique, schiꞌuc spꞌisoj sbaic ti jaꞌ chalic li scꞌop Diose, pero altic chalic. Chaqꞌuic ta ilel ti oy sjuꞌelique yoꞌ jech chloꞌloj o li crixchanoetique. Tscꞌan tsloꞌloic eꞌuc li buchꞌutic tꞌujbilic yuꞌun li Diose, pero mu xloꞌloj yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Qꞌuelo me abaic li joꞌoxuque, jaꞌ me yuꞌun cac noꞌox chacalbeic scotol. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Cꞌalal mi iꞌechꞌ scotol li vocol li laj calboxuque, jaꞌ o chmac sat li cꞌacꞌale. Mi jaꞌuc li ue, mu xacꞌ xojobal. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Li cꞌanaletique ta stsꞌujan yalel nojtoc. Ta xnic scotol li cꞌustic oy ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jaꞌ xa o ta xilic scotol li crixchanoetique ti chiyal talel ta toc ta vinajel schiꞌuc jtsatsal, schiꞌuc juꞌel, schiꞌuc xojobal, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta jtac yalel talel li cajꞌangeltaque yoꞌ acꞌo stsobic scotol li buchꞌutic tꞌujbilic cuꞌun li buyuc noꞌox oyic ta spꞌejel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Naꞌic me li cꞌalal ch‐unenaj li teꞌel higoe, jaꞌ chanaꞌic o ti poꞌot xa yora joꞌtique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jaꞌ noꞌox jech li cꞌalal chavilic ti chcꞌot ta pasel scotol li cꞌusi laj cale, jaꞌ chanaꞌic o ti poꞌot xa scꞌacꞌalil chichaꞌtale, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Melel chacalbeic, li buchꞌutic iyaꞌiic li cꞌu sba chlic li tsots vocol ti laj calboxuc liꞌi, oy toꞌox cuxuloxuc li cꞌalal chlique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Li cꞌustic caloje mu xchꞌay scꞌoplal, ta onoꞌox xcꞌot ta pasel scotol. Jaꞌ xlaj to li vinajel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Li cꞌu ora chichaꞌtale muc buchꞌu snaꞌ, mi jaꞌuc li ángeletic ta vinajele, mi joꞌcun li Nichꞌonilune. Jaꞌ noꞌox snaꞌ stuc li Jtotique. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Qꞌuelo me abaic, vicꞌluc noꞌox me asatic, taic ta naꞌel Dios yuꞌun mu xanaꞌic cꞌu ora chichaꞌtal. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jaꞌ jech chac cꞌu chaꞌal jun vinic cꞌalal chbat ta nome, chacꞌbe comel ta scꞌob yajtuneltac li snae. Chacꞌbe comel yabtel jujunic. Li buchꞌu jaꞌ yabtel ta schabi tiꞌnae, chalbe comel ti vicꞌluc noꞌox me sate. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jech li joꞌoxuque vicꞌluc noꞌox me asatic chamalaicun yuꞌun mu xanaꞌic cꞌu ora chichaꞌtal, joꞌon la Avajvalicune, mi ta yochel acꞌubal, mi ta oꞌlol acꞌubal, mi ta sba oqꞌuelal jcots, mi ta sob cꞌuxi. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mu me chꞌayluc avoꞌonic chjul jtaoxuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Joꞌoxuque laj xa calboxuc ti scꞌan ti vicꞌluc asatique. Scꞌan ti acꞌo jechic eꞌuc scotol li crixchanoetique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Scꞌan toꞌox chib cꞌacꞌal li qꞌuin Coltael cuꞌuncutique, joꞌoncutic li jꞌisraeluncutique. Jaꞌ li qꞌuin li cꞌalal ta jveꞌcutic pan ti muc bu yichꞌoj svochesobile. Li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, la snopic cꞌu sba xuꞌ ta stsaquic ta mucul li Jesuse yoꞌ tsmilic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jech laj yalbe sbaic: ―Jaꞌ lec mu jtsactic ta qꞌuin yuꞌun naca me sliquesic cꞌop li jchiꞌiltactique ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Cꞌalal te oy ta Betania li Jesuse, te oy ta sna li Simón ti tsacbil toꞌox ta cꞌaꞌel chamele. Cꞌalal te chveꞌ ta mexa li Jesuse, ital jun ants yichꞌoj talel slimeta pasbil ta alabastro ton. Noj ta muil vomol, nardo sbi. Toj toyol stojol. La scꞌasbe snucꞌ li limetae, la smalbe ta sjol Jesús li sbele. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Oy jayvoꞌ iꞌilinic, jech laj yalbe sbaic: ―¿Cꞌu chaꞌal jech noꞌox ta xlaj li muil vomole? ");
INSERT INTO tzoSA_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jaꞌ lec ti lauc schone yuꞌun más ta oxib ciento denario taqꞌuin ilocꞌ stojol ti jechuque. Li stojole xuꞌ jaꞌ ta xꞌacꞌbatic li meꞌonetique ―xiic. Jaꞌ yuꞌun laj yutic li antse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Li Jesuse jech laj yalbe: ―Mu xavutic li antse. Mu me xavaqꞌuic xcꞌopoj yoꞌon. Lec li cꞌusi laj yacꞌbune. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Li meꞌonetique scotol cꞌacꞌal liꞌ achiꞌuquique jech cꞌusiuc noꞌox ora xuꞌ chacꞌuxubinic. Yan li joꞌone mu scotoluc cꞌacꞌal liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Li antse laj xa spas li cꞌusi xuꞌ yuꞌune. Ti jech la smalbun li muil vomole, jaꞌ ta sventa li cꞌalal chimuquee. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Melel li cꞌusi chacalbeique, ti buyuc noꞌox chichꞌ alel ta spꞌejel balumil ti jaꞌ noꞌox chcolic ta jventae, te chalic nojtoc li cꞌusi laj yacꞌbun li antse. Jech ta snaꞌic o scotol crixchanoetic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Li Judas Iscariotee, jaꞌ jun li lajchavoꞌ yajchanbalajeltac li Jesuse, ba scꞌopon li banquilal paleetique yoꞌ tspas trato ti chacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cꞌalal iyaꞌiic li banquilal paleetique, xmuybajic tajmec. Laj yalbeic Judas ti chacꞌbeic taqꞌuine. Li Judase jaꞌ xa noꞌox smalaoj cꞌu ora tspas ta canal chacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ta sliqueb qꞌuin cꞌalal ta jveꞌcutic pan ti muc bu yichꞌoj svochesobile, schiꞌuc cꞌalal ta jmilcutic li chexel chijetic ta sventa qꞌuin Coltaele, jech ijacꞌbat yuꞌun li yajchanbalajeltac li Jesuse: ―¿Bu chacꞌan chba jmeltsancutic li chexel chij ti chalajes ta sventa li qꞌuin Coltaele? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Li Jesuse la stac batel chaꞌvo li yajchanbalajeltaque. Jech laj yalbe batel: ―Batanic ta Jerusalén. Te chataic ta be jun vinic scuchoj jpꞌej qꞌuib yaꞌal. Jaꞌ te tijlanic batel ta spat. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Xcꞌot acꞌoponic li yajval na li bu ta xꞌoche. Jech xavalbeic: “Jech laj yal li jchanubtasvaneje: ¿Bu jcꞌolucal ana li yoꞌ bu ta jlajescutic li chij sventa li qꞌuin Coltael jchiꞌuc li cajchanbalajeltaque? xi laj yal talel”, utic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te chacꞌ avilic jcꞌol sna ta schaꞌcojol sna ti lec jamal yute, chꞌubabil xa lec. Jaꞌ te xameltsanic li jveꞌeltique ―xut batel li chaꞌvoꞌ yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ibatic li chaꞌvoꞌique, iꞌochic ta yut jteclum. Jaꞌ jech istaic li cꞌu sba iꞌalbatic batel yuꞌun li Jesuse. Jaꞌ te la smeltsanic li veꞌlil sventa li qꞌuin Coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cꞌalal xtupꞌet xaꞌox osile, ibatic li ta na schiꞌuc li lajchavoꞌ yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cꞌalal te xa ta xveꞌic ta mexae, li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Melel chacalbeic, oy junoxuc li joꞌoxuque li liꞌ coꞌol chijveꞌutic ti jaꞌ chiyacꞌ ta cꞌabale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cꞌalal iyaꞌiique, iyat yoꞌonic scotolic. Ta jujuntal la sjacꞌbeic li Jesuse: ―¿Mi joꞌon nan? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Itacꞌav li Jesuse: ―Jaꞌ jun li lajchavoꞌoxuc liꞌi. Jaꞌ li buchꞌu ti jun jpulatucutic chijveꞌcutic jchiꞌuque jaꞌ chiyacꞌ ta cꞌabal. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Joꞌon li coꞌol crixchanoutique, chimile jech chac cꞌu chaꞌal tsꞌibabil onoꞌox ta scꞌop li Diose. Toj abol sba li buchꞌu chiyacꞌ ta cꞌabale. Jaꞌ lec ti muꞌyucuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cꞌalal chveꞌique, la stam jpꞌej pan li Jesuse, laj yalbe coliyal Dios, la xut li pane, laj yacꞌbe li yajchanbalajeltaque. Jech laj yalbe: ―Ilo, veꞌanic. Liꞌi jaꞌ jbecꞌtal ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","La stsac nojtoc jun vaso yaꞌlel tsꞌusub, laj yalbe coliyal Dios, laj yacꞌbe nojtoc li yajchanbalajeltaque. Laj yuchꞌic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jech laj yal li Jesuse: ―Liꞌi jaꞌ jchꞌichꞌel, jaꞌ senyail ti mu xlaj scꞌoplal ti cꞌusi iyal ta tsꞌacal li Jtot sventa chacolic oe. Yuꞌun jtuc chcacꞌ jba ta milel, ta jmal jchꞌichꞌel, jaꞌ jech ta xtoj o smulic scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Melel chacalbeic, jaꞌ to chcuchꞌ nojtoc li yaꞌlel tsꞌusube ti cꞌalal te xa tsobolutic jcotoltic li yoꞌ bu ta jpas mantal yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cꞌalal la sqꞌueojintaic jun sqꞌueoj Dios, iloqꞌuic batel schiꞌuc li yajchanbalajeltac li Jesuse, ibatic ta vits Olivatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Tanae chavictaicun acotolic. Yuꞌun jech onoꞌox tsꞌibabil ta scꞌop Dios: “Chcacꞌ ta milel li buchꞌu cacꞌojbe yabtel ti chasventainique. Cꞌalal mi imilee, tspuc sbaic batel li schiꞌiltaque jech chac cꞌu chaꞌal tspuc sbaic batel li chijetic mi imile li yajchabivanejique”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cꞌalal chaꞌcuxiemun xaꞌoxe, joꞌon baꞌi chibat ta Galilea, tsꞌacal to chabatic. Te chcꞌot ataicun ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Itacꞌav li Pedroe: ―Acꞌo mi chayictaic scotolic, li joꞌone muc bu chaquicta ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Li Jesuse jech laj yalbe: ―Melel li cꞌusi chacalbee, tana cꞌalal muc toꞌox bu oqꞌuem schaꞌoqꞌuelal jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Itacꞌav li Pedroe: ―Acꞌo mi coꞌol chijmile, pero jamal chcal ti xacojtaquine ―xi tajmec. Jaꞌ noꞌox jech laj yalic eꞌuc li yanetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Te icꞌotic Jesús schiꞌuc yajchanbalajeltac li yoꞌ bu Getsemaní sbie. Jech laj yalbe li yajchanbalajeltaque: ―Chotlanic comel liꞌi yuꞌun chba jta ta naꞌel Dios leꞌe ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Li Jesuse laj yicꞌ echꞌel Pedro, schiꞌuc Jacobo, schiꞌuc Juan. Lic yat tajmec yoꞌon li Jesuse. Jech xa noꞌox toj chopol yoꞌon chaꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jech laj yalbe li oxvoꞌique: ―Toj echꞌem chcat coꞌon, jun chac chicham chcaꞌi. Comanic liꞌi, mu me xꞌoch avayelic ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ibat xi snamal li Jesuse. La spatan sba ta lumtic, la sta ta naꞌel Dios, la scꞌanbe ti xuꞌuc mu xchame. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jech laj yal: ―Tata, scotol xuꞌ avuꞌun. Xuꞌ avuꞌun mi chajeltaune. Pero maꞌuc me xcꞌot ta pasel li cꞌusi ta jcꞌan jtuque, jaꞌ acꞌo jpas li cꞌusi chacꞌan atuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Isut talel li Jesuse. Vayalic cꞌot sta li oxvoꞌique. Li Jesuse jech laj yalbe li Pedroe: ―Simón, ¿mi vayalot? ¿Mi mu xuꞌ ti vicꞌluc asat jliqueluque? ");
INSERT INTO tzoSA_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu me xavayic, taic ta naꞌel Dios yoꞌ jech mu xaspasic ta canal li pucuje. Ta melel chacꞌan chataic ta naꞌel Dios, pero jaꞌ noꞌox chaschꞌayic la abecꞌtalique. Naca vayel chasmilic ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ba sta ta naꞌel Dios nojtoc li Jesuse. Jaꞌ noꞌox jech laj yal jech chac cꞌu chaꞌal laj yal ta baꞌie. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cꞌalal isut talel nojtoc li Jesuse, vayalic cꞌot sta nojtoc li oxvoꞌique yuꞌun mu xvicꞌ satic. Jech xa noꞌox mu snaꞌic cꞌu sba ta xtacꞌavic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ba sta ta naꞌel Dios yoxibal velta nojtoc li Jesuse. Cꞌalal isut talele, vayalic cꞌot sta nojtoc. Jech laj yalbe: ―¿Mi yoquel to vayaloxuc? ¿Mi mu xviqꞌuej la asatique? Taꞌluc o li vayele, ista xa yora chiꞌaqꞌue ta scꞌob jpasmuliletic, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Licanic, batic. Qꞌuelavilic, leꞌ xa xtal li buchꞌu chiyacꞌ ta cꞌabale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cꞌalal jaꞌ o yacal ta loꞌil li Jesuse, ital li Judase, jaꞌ jun li lajchavoꞌ yajchanbalajeltaque. Ep crixchanoetic schiꞌuc talel, yichꞌojic talel smachitaic schiꞌuc steꞌic. Jaꞌ tacbilic talel yuꞌun li banquilal paleetique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Li Judase, jaꞌ li jꞌacꞌvanej ta cꞌabale, yaloj xa onoꞌox cꞌu sba chacꞌ ta ilel ti buchꞌu junucal li Jesuse: ―Li buchꞌu ta jtsꞌutsꞌune, yuꞌun xa onoꞌox me jaꞌ li Jesuse. Jaꞌ o me xba atsaquic. Chuquic me lec batel ―xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cꞌalal icꞌotique, inopoj talel ta ora ta stojol Jesús li Judase. Jech laj yalbe: ―Jchanubtasvanej ―xut. La stsꞌutsꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaꞌ o inopojic talel li crixchanoetique, la stsaquic ta ora li Jesuse, la schucbeic scꞌob. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Oy jun li yajchanbalajeltac li Jesuse la sloqꞌues smachita, la sjaxbe ta bojel jun schiquin li yajtunel li más banquilal palee. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Li Jesuse jech laj yalbe li crixchanoetic li te italique: ―¿Cꞌu chaꞌal tal atsaquicun jech chac cꞌu chaꞌal jun jꞌelecꞌ, tsꞌaclomoxuc xa talel ta amachitaic, ta ateꞌic? ");
INSERT INTO tzoSA_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yuꞌun scotol cꞌacꞌal te lichanubtasvan ta atojolic ta yamaqꞌuil li mucꞌta chꞌulnae. ¿Cꞌu chaꞌal mu teuc noꞌox la atsaquicun? Ti jech la atsaquicune, jaꞌ icꞌot ta pasel ti jech onoꞌox tsꞌibabil comel ta scꞌop Diose ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Li yajchanbalajeltac li Jesuse ijatavic batel scotolic, iyictaic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oy jun svaꞌlej querem te tijil ibat ta spat li Jesuse. Muc bu slapoj scꞌuꞌ li quereme, jaꞌ noꞌox stsꞌotoj o sba ta jlic schij. Taꞌox stsaque yuꞌun li mayoletique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero li quereme la scolta comel li schije, tꞌanal ijatav batel. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Laj yiqꞌuic batel Jesús ta stojol li más banquilal palee. Te la stsob sbaic li banquilal paleetique, schiꞌuc li jꞌabteletique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Li Pedroe nomnom tijil batel ta spat Jesús cꞌalal to icꞌotic ta yamacꞌ li más banquilal palee. Te la schiꞌin ta chotlej li yajmayoltac li más banquilal palee, te icꞌatinic schiꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Li banquilal paleetique schiꞌuc li jꞌabteletic cuꞌuncutique, lic saꞌic chaꞌvoꞌ schiꞌiltaquic ta abtel ti coꞌol li cꞌusi chalique yoꞌ ta saꞌbeic o smul li Jesuse, yuꞌun tscꞌanic ti acꞌo chamuque. Pero muc bu staic chaꞌvoꞌ ti coꞌol li cꞌusi chalique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Altic ti ep la sjutic cꞌop ta stojol li Jesuse, mu coꞌoluc li cꞌusi chalique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ivaꞌiic yan jutcꞌopetic nojtoc, jech laj yalic: ");
INSERT INTO tzoSA_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Li vinic liꞌi laj caꞌicutic ti jech laj yale: “Ta jines li mucꞌta chꞌulna liꞌi li pasbil ta cꞌabale. Ta oxib noꞌox cꞌacꞌal ta jchaꞌvaꞌan ta achꞌ, mu xa pasbiluc yuꞌun li crixchanoetique”, xi ―xiic li jutcꞌopetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero mu coꞌoluc scꞌopic nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ivaꞌi ta oꞌlol li más banquilal palee. Jech la sjacꞌbe li Jesuse: ―¿Cꞌu chaꞌal mu xatacꞌav? ¿Mi melel li cꞌusi chalique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mu jpꞌeluc bu itacꞌav li Jesuse. Li más banquilal palee la sjacꞌbe nojtoc li Jesuse: ―¿Mi joꞌot Cristoot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique? ¿Mi joꞌot Snichꞌonot li Diose? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Itacꞌav li Jesuse: ―Joꞌon ―xi―. Joꞌon li coꞌol crixchanoutique, chavilic chlic jventainan crixchanoetic ta stsatsal li Diose. Tsꞌacal to chilic scotol crixchanoetic ti chital ta toc ta vinajele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Li más banquilal palee la sjat scꞌuꞌ yuꞌun la snop ti istabe xa tsots smul li Jesuse. Jech laj yal: ―¿Cꞌu chaꞌal ta jsaꞌtic yan textico? ");
INSERT INTO tzoSA_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","La avaꞌiic xa ti ta spꞌis sba ta Diose. ¿Cꞌusi chanopic eꞌuc? ―xut li schiꞌiltac ta abtele. Itacꞌav scotolic ti acꞌo chamuque. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lic stubtabeic sat li Jesuse. La smacbeic sat, la smajic, jech la sjacꞌbeic: ―Alo buchꞌu li la smajote ―xutic. Li yajmayoltac li paleetique imajvanic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Li Jesuse te icꞌbil muyel ta schaꞌcojol na. Li Pedroe te chotol icom ta yamaqꞌuil sna li más banquilal palee. Te ital jun scriara li más banquilal palee. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iyil ti te chcꞌatin li Pedroe. La sqꞌuel lec, jech laj yalbe: ―Joꞌote jaꞌ achiꞌin eꞌuc li Jesús li liquem talel ta jteclum Nazarete ―xꞌute li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Li Pedroe laj yal ti mu xojtaquin li Jesuse: ―Mu xcojtaquin. Mu jnaꞌ li cꞌusi chavale ―xi. Te ibat ta tiꞌmoc li Pedroe. Jaꞌ o iꞌocꞌ jcots. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Li criarae ischaꞌil li Pedroe. Jech laj yalbe li buchꞌutic te oyique: ―Li vinic leꞌe jaꞌ schiꞌil li Jesuse ―xi li criarae. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Li Pedroe laj yal nojtoc ti mu xojtaquine. Ta jliquel nojtoque iꞌalbat yuꞌun li buchꞌutic te oyique: ―Ta melel jaꞌ achiꞌil yuꞌun xvinaj ti jgalileal vinicote yuꞌun jaꞌ jech acꞌop ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lic chopolcꞌopojuc li Pedroe, la stꞌabbe sbi Dios: ―Xilchox mu xcojtaquin li vinic chavalique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jaꞌ o iꞌocꞌ schaꞌoqꞌuelal jcots. Ijul ta sjol li Pedro ti jech onoꞌox iꞌalbat yuꞌun li Jesuse: “Cꞌalal muc toꞌox bu oqꞌuem schaꞌoqꞌuelal jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune”, xꞌute onoꞌox yuꞌun li Jesuse. Cꞌalal ijul ta sjol li cꞌusi iꞌalbat yuꞌun Jesús li Pedroe, laj yoqꞌuita sba. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cꞌalal isacube, la stsob sbaic scotol li buchꞌutic oy yabtelique, jaꞌ li banquilal paleetique, schiꞌuc li jꞌabteletic cuꞌuncutic, joꞌoncutic li jꞌisraeluncutique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. La spasic ta jmoj scꞌopic ti cꞌu sba ta smilic li Jesuse. La schuquic echꞌel, laj yacꞌbeic ta scꞌob li gobernadore, jaꞌ li Pilatoe. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Li Pilatoe jech la sjacꞌbe li Jesuse: ―¿Mi joꞌot mucꞌta ajvalilot yuꞌun la achiꞌiltac ta israelale? ―xut. Itacꞌav li Jesuse: ―Joꞌon ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Li banquilal paleetique ep la saꞌbeic smul li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Li Pilatoe jech la sjacꞌbe nojtoc li Jesuse: ―¿Cꞌu chaꞌal mu xatacꞌav? Qꞌuelavil, ep ta saꞌic amul ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mu jpꞌeluc bu itacꞌav li Jesuse. Li Pilatoe toj chꞌayel noꞌox yoꞌon ti cꞌalal iyaꞌi ti muc bu spac scꞌoplal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Li Pilatoe jech stalel onoꞌox ti ta jujun qꞌuin Coltael ta scolta jun jchuquel li bu junucal tscꞌanbeic scolel li jchiꞌiltacutique. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te tiqꞌuil ta chuquel jun jchiꞌilcutic, Barrabás sbi. Te tiqꞌuilic ta chuquel schiꞌuc schiꞌiltac ta milvanej. Yuꞌun la stsob sbaic, la scontrainic li gobernadore. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Cꞌalal te tsobolic scotol li jchiꞌiltacutic ta israelale, lic yalbeic Pilato ti acꞌo scolta jun jchuquel jech chac cꞌu chaꞌal ta spas onoꞌox ta jujun qꞌuin Coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jech la sjacꞌ li Pilatoe: ―¿Mi jaꞌ chacꞌanic ta jcolta li mucꞌta ajvalil avuꞌunique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yuꞌun snaꞌoj onoꞌox li Pilato ti ta scoj ti xtiꞌet noꞌox yoꞌonic li banquilal paleetic ti laj yaqꞌuic ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Li banquilal paleetique la schanubtasic li crixchanoetic ti jaꞌ noꞌox acꞌo scꞌanbeic scolel li Barrabase. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Li Pilatoe la sjacꞌ nojtoc: ―¿Cꞌusi chacꞌanic ta jpasbe li buchꞌu spꞌisoj sba ta ajvalil avuꞌunic ti avalojique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsots itacꞌavic scotolic: ―¡Jocꞌano ta cruz! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―¿Pero cꞌusi smul avuꞌunic? ―xi li Pilatoe. Pero más to tsots itacꞌav scotolic: ―¡Jocꞌano ta cruz! ―xiic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Li Pilatoe jaꞌ tscꞌan ti lec ch‐ile yuꞌun li crixchanoetique, jaꞌ yuꞌun la spas li cꞌusi iꞌalbate. La scolta li Barrabase. Pero li Jesuse iꞌaqꞌue ta scꞌob soltaroetic yoꞌ acꞌo stsitsic ta nucul, tsꞌacal to chba sjocꞌanic ta cruz. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Li yajsoltarotac li gobernadore laj yiqꞌuic ochel ta yut cavilto li Jesuse. Te la stsob sbaic scotol li yan schiꞌiltac ta soltaroile. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","La slapbeic icꞌpocꞌan tsajal cꞌuꞌil li Jesuse. La slapbeic scoronail sjol jaꞌ xotbil chꞌix. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lic snaꞌleic, jech laj yalbeic: ―¡Toj lec mucꞌta ajvalilot avaꞌuc yuꞌun la achiꞌiltac ta israelale! ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La sjisbeic aj ta sjol. La stubtaic. La squejan sbaic, la snijan sbaic ta stojol Jesús yuꞌun tsnaꞌleic. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cꞌalal ilaj yoꞌonic ta snaꞌleele, la slocꞌbeic li icꞌpocꞌan tsajal cꞌuꞌile, la slapbeic li scꞌuꞌ onoꞌoxe. Laj yiqꞌuic batel, ba sjocꞌanic ta cruz. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cꞌalal iloqꞌuic batel li soltaroetic schiꞌuc li Jesuse, te la snupic ta be jun jchiꞌilcutic ta israelal, Simón sbi. Oy chaꞌvoꞌ snichꞌnab, jaꞌ li Alejandro schiꞌuc Rufoe. Cirene sbi li slumale. Iyacꞌbeic echꞌel sqꞌuechbeel scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Te laj yiqꞌuic batel Jesús li yoꞌ bu Gólgota sbie. Jaꞌ Baquil Jolil, xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Te laj yacꞌbeic yuchꞌ pajal yaꞌlel tsꞌusub capal ta chꞌail vomol, mirra sbi. Li mirrae jaꞌ sventa smacobil scꞌuxul, pero li Jesuse muc bu xuchꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Li soltaroetique la sjocꞌanic ta cruz li Jesuse. Ta tsꞌacale la spasic canal tajimol yoꞌ jech chilic bu jlicucal li scꞌuꞌ spacꞌaltac Jesús ti chichꞌbeic jujunique. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta baluneb ora ta sob la sjocꞌanic ta cruz li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","La sbajbeic jpech teꞌ ta sjol scruzal li Jesuse, jaꞌ li bu tsꞌibabil ti cꞌusi smul ti la smilique. Jech chal: “Liꞌi jaꞌ li mucꞌta ajvalil yuꞌun li jꞌisraeletique”, xi tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oy chaꞌvoꞌ jꞌeleqꞌuetic coꞌol la sjocꞌanic ta cruz schiꞌuc li Jesuse, jun cruz ta sbatsꞌicꞌob, jun ta stsꞌetcꞌob li scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jaꞌ icꞌot ta pasel ti jech onoꞌox tsꞌibabil scꞌoplal ta scꞌop Diose: “Ta spꞌise ta jpasmulil”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Li buchꞌutic te iꞌechꞌique inaꞌlevanic eꞌuc. Isjimulan sjolic, jech laj yalic: ―¡Qꞌuelavil juꞌun! Ti aval chajines li mucꞌta chꞌulnae schiꞌuc ti chachaꞌvaꞌan ta oxib noꞌox cꞌacꞌale, colta aba atuc. Yalan ta cruz ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jaꞌ jech inaꞌlevanic eꞌuc li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech laj yalbe sbaic: ―La scoltaan li crixchanoetique pero li stuc juꞌune mu xuꞌ scolta sba. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mi melel ti jaꞌ Cristoe, ti jaꞌ mucꞌta ajvalil cuꞌuntique, acꞌo yaluc ta ora ta cruz. Jaꞌ to te chquiltic o, jaꞌ to ta jchꞌuntic ―xiic. Jaꞌ jech ilabanvanic eꞌuc li chaꞌvoꞌ jꞌeleqꞌuetic li te jocꞌajtic ta cruz schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cꞌalal oꞌlol xaꞌox cꞌacꞌale, imac sat li cꞌacꞌale. Jaꞌ to ta oxib ora ta mal cꞌacꞌal ijam sat li cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta oxib ora ta mal cꞌacꞌal tsots icꞌopoj li Jesuse: ―Eloi, Eloi, ¿lama sabactani? ―xi. “Dios cuꞌun, Dios cuꞌun, ¿cꞌu chaꞌal la atenun ta avoꞌon?” xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oy jayvoꞌic buchꞌutic iyaꞌiic, jech laj yalic: ―Avaꞌiic, jaꞌ chapta li Elíase ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ibat ta anil jun vinic, ba stsac talel jpꞌej li cꞌusi cꞌunputsane. La stsꞌaj ta pajal yaꞌlel tsꞌusub, la xoj ta aj, laj yetꞌesbe muyel, laj yacꞌbe stsꞌuꞌ li Jesuse. Jech iꞌalbat yuꞌun li yanetique: ―Jmalatic, jqꞌueltiquic mi chtal yalesatuc ta cruz yuꞌun li Elíase ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Li Jesuse tsots to icꞌopoj, jaꞌ xa o ilocꞌ schꞌulel. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Li mucꞌta pocꞌ li te lichꞌil ta yut li mucꞌta chꞌulnae, ijat ta oꞌlol. Ijat yalel cꞌalal olon. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te vaꞌal ta stuqꞌuil Jesús li banquilal soltaroe. Cꞌalal iyil ti icham li Jesuse, jech laj yal: ―Ta melel jaꞌ snichꞌon Dios li vinic liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te oy nojtoc jayvoꞌ antsetic nomnom tsqꞌuelic talel. Jaꞌ te oy li María li liquem talel ta Magdalae, schiꞌuc Salome, schiꞌuc yan María, jaꞌ smeꞌ li Josee schiꞌuc li biqꞌuit Jacobo sbi cuꞌuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jaꞌ li antsetic ti la schiꞌinic ta xanbal Jesús li te ta Galilea balumil ti la smacꞌlanique. Te oyic nojtoc ep yan antsetic ti la schiꞌinic talel ta Jerusalén li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Cꞌalal jech icꞌot ta pasele, jaꞌ o scꞌacꞌalil ta jchapan jbacutic sventa ta jcuxcutic ta yocꞌomal. Te oy jun jchiꞌilcutic ta israelal, José sbi, liquem talel ta jteclum Arimatea. Li Josee yichꞌoj yabtel li te ta mucꞌta chꞌulnae. Schiꞌuc ichꞌbil ta mucꞌ. Smalaoj eꞌuc scꞌacꞌalil chtal ventainvanuc li Diose. Cꞌalal mal xaꞌox cꞌacꞌale, li Josee tsots yoꞌon ibat ta sna Pilato, ba scꞌanbe li sbecꞌtal stacupal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Li Pilatoe toj chꞌayel noꞌox yoꞌon cꞌalal iyaꞌi ti chamem xa li Jesuse, yuꞌun mu bacꞌne xil ti chchamic ta ora li buchꞌutic chjocꞌanatic ta cruze. Jaꞌ yuꞌun la stac ta iqꞌuel li banquilal soltaroe, la sjacꞌbe mi melel ti chamem xa li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cꞌalal iꞌalbat yuꞌun li banquilal soltaro ti chamem xa li Jesuse, laj yal mantal ti acꞌo yichꞌbe batel sbecꞌtal stacupal Jesús li Josee. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Li Josee la sman jlic saquil pocꞌ. La syales ta cruz li Jesuse, la spix li ta saquil poqꞌue, ba smuc ta jombil chꞌut chꞌen. La stselelin talel jpech mucꞌta ton, jaꞌ la smac o comel li tiꞌchꞌene. ");
INSERT INTO tzoSA_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Li María li liquem talel ta Magdalae schiꞌuc li otro jun Maríae, jaꞌ li smeꞌ Josee, iyilic bu la smuquic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cꞌalal iꞌechꞌ xaꞌox li scꞌacꞌalil ta jcuxcutique, la smanic muil vomol li María li liquem talel ta Magdalae, schiꞌuc li Salomee, schiꞌuc li otro jun María li smeꞌ Jacoboe, yuꞌun chba yacꞌbeic ta sbecꞌtal stacupal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta sob ta sba cꞌacꞌal ta xemanae, jaꞌ li romincoe, ibatic li yoꞌ bu mucbil li Jesuse. Loqꞌuem xaꞌox li cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jech laj yalbe sbaic: ―¿Buchꞌu chistselelinbutic loqꞌuel tana li ton li te ta tiꞌ chꞌene? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cꞌalal icꞌotique, jaꞌ to iyilic ti tselelinbil xa loqꞌuel li mucꞌta ton li macbil toꞌox o stiꞌ li chꞌene. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Cꞌalal iꞌochic ta yut chꞌene, te iyilic jun vinic yilel. Te chotol ta stuqꞌuil sbatsꞌicꞌobic. Tolen saquil cꞌuꞌil slapoj. Ixiꞌic tajmec li antsetique. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Li vinique jech laj yalbe li antsetique: ―Mu xaxiꞌic. Jnaꞌoj ti jaꞌ chasaꞌic li Jesús li liquem talel ta Nazarete, ti te icham ta cruze. Pero ichaꞌcuxi xa. Mu xa bu liꞌi. Qꞌuelavilic li bu toꞌox la stelanique. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ba albeic li Pedro schiꞌuc li yan yajchanbalajeltac ti jaꞌ baꞌi chcꞌot ta Galilea li Jesuse. Te chcꞌot staic jech chac cꞌu chaꞌal iꞌalbatic onoꞌox yuꞌun li Jesuse ―xꞌutatic batel li antsetque. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Li antsetique ixiꞌic loqꞌuel li ta chꞌene, ibatic ta anil. Xtꞌelajetic batel ta xiꞌel. Muc buchꞌu laj yalbeic ta be yuꞌun ixiꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cꞌalal ichaꞌcuxi Jesús ta sob ta sba cꞌacꞌal ta xemanae, jaꞌ li romincoe, baꞌi laj yacꞌ sba ta ilel ta stojol li María li liquem talel ta Magdalae, jaꞌ li iloqꞌuesbat jucub pucuj ta yoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ibat li Maríae, ba yalbe li yajchanbalajeltac ti ichaꞌcuxi xa li Jesuse. Li yajchanbalajeltac li Jesuse chat yoꞌonic, yaquic ta oqꞌuel li cꞌalal icꞌot li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cꞌalal iyaꞌiic ti chaꞌcuxiem xa li Jesuse schiꞌuc ti laj yil li Maríae, muc bu schꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tsꞌacal to laj yacꞌ sba ta ilel Jesús te ta be ta stojol chaꞌvoꞌ jchiꞌilcutic ti yichꞌojic ta mucꞌ eꞌuque. Syanijesoj sat li Jesuse jech muc bu xojtaquinic ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Li chaꞌvoꞌique isutic ta Jerusalén, ba yalbeic li yanetic ti iyilic li Jesuse, pero muc bu xchꞌunbatic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta más tsꞌacale laj yacꞌ sba ta ilel Jesús ta stojol li buluchvoꞌ yajchanbalajeltac li cꞌalal jaꞌ o chveꞌique. Tsots itꞌabbatic yuꞌun Jesús ta scoj ti mu schꞌunique schiꞌuc ti toj tsots yoꞌonique. Yuꞌun muc bu schꞌunic li cꞌusi laj yalic li buchꞌutic iyilic ti chaꞌcuxiem xa li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jech iꞌalbatic yuꞌun li Jesuse: ―Batanic ta spꞌejel balumil. Albeic scotol li crixchanoetic ti jaꞌ noꞌox ta xcolic ta jventae. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Scotol buchꞌutic ta schꞌunic ti chcolic ta jventae schiꞌuc ti chichꞌic joꞌe, jaꞌ chcolic. Yan li buchꞌutic mu schꞌunique jaꞌ ch‐acꞌbat yichꞌic vocol ta scoj smulic. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Li buchꞌutic ta schꞌunique chaqꞌuic ta ilel li juꞌele. Ta sloqꞌuesic pucujetic ta yoꞌon crixchanoetic ta juꞌel. Chcꞌopojic ta ora noꞌox ta yantic o cꞌop. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Acꞌo mi chtiꞌatic ta quiletan chonetic, acꞌo mi ch‐acꞌbat yuchꞌic chamebal vomol, mu cꞌusi tspasbatic. Chacꞌanbeic scꞌobic ta sbaic li jchamelajeletique, chcol yuꞌunic ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cꞌalal ilaj yoꞌon ta scꞌoponel li yajchanbalajeltac li Cajvaltique, jaꞌ o imuy ba ta vinajel. Cꞌot chotluc ta sbatsꞌicꞌob li Diose, te tspas mantal schiꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Li yajchanbalajeltaque ba yalic ta spꞌejel balumil ti jaꞌ noꞌox chijcolutic ta sventa li Cajvaltique. Te schiꞌuc sbaic ta abtel schiꞌuc li Cajvaltique. Iꞌacꞌbat yaqꞌuic ta ilel li stsatsal sjuꞌel li Cajvaltique yoꞌ acꞌo vinajuc ti ta melel jaꞌ scꞌop li Cajvaltic li ta spuquique.");
INSERT INTO tzoSA_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Ajvalil Teófilo, ep buchꞌutic la stsꞌibaic xa ta jun li cꞌustic lec icꞌot ta pasel ta jtojolcutique. Jaꞌ jech chac cꞌu chaꞌal laj yalbun caꞌicutic li buchꞌutic iyilic cꞌalal lic stsac yabtel li Jesuse, ti jaꞌ yabtelic yalel li scꞌope, jaꞌ jech la stsꞌibaic ta jun scotol. Joꞌon eꞌuc li Lucasune la jnop ti jaꞌ lec ti chacalbe scotol li cꞌustic icaꞌi ta sliquebe schiꞌuc cꞌalal to avie, yuꞌun icaꞌi xa scotol li cꞌustic icꞌot ta pasele. Jech xchapet chajtsꞌibabe scotol yoꞌ jech chanaꞌ o ti jaꞌ melel li cꞌu sba lachanubtasee. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cꞌalal ochem ta ajvalilal te ta Judea balumil li Herodese, jaꞌ o ochem ta paleal yuꞌun li jꞌisraeletic jun vinic, Zacarías sbi. Li paleetic yuꞌunique oy jayvoqꞌuic yuꞌun tsjel sbaic ta abtel. Li Zacaríase jaꞌ schiꞌiltac ta paleal li jvocꞌ Abías sbie. Li yajnil Zacaríase Elisabet sbi. Li smoltot ta voꞌone li Elisabete Aarón sbi, jaꞌ li sba pale li itiqꞌue ta abtel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Li Diose sqꞌueloj ti tucꞌ yoꞌonic schiꞌuc yajnil li Zacaríase. Yuꞌun schꞌunojic li cꞌusi yaloj li Cajvaltic Diose, jech muꞌyuc smul iꞌileic yuꞌun Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero muꞌyuc schꞌamalic yuꞌun mu snaꞌ xil yol li Elisabete. Mol meꞌelic xa schaꞌvaꞌalic. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Li Zacaríase ista scꞌacꞌalil ti jaꞌ ta xꞌabtej ta stojol Dios te ta mucꞌta chꞌulna schiꞌuc li schiꞌiltac ta paleale. Yuꞌun li paleetique ta sjel sbaic li jujuvoqꞌuique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Li jayvoꞌic ti jaꞌ yorail ta xꞌabtejique, stalelic ti ta spasic canal tajimol jujun cꞌacꞌale ta sqꞌuelic buchꞌu junucal ta xcꞌot ta stojol ti chba schicꞌ pomriox li te ta yut li mucꞌta chꞌulna yuꞌun li Diose. Cꞌalal jech la spasique, jaꞌ icꞌot ta stojol li Zacaríase. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cꞌalal ta schiqꞌuic pomriox ta yut li mucꞌta chꞌulna li paleetique, li crixchanoetique te vaꞌalic ta amacꞌ ta staic ta naꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cꞌalal jaꞌ o te ta schicꞌ pomriox li Zacaríase, ital jun yajꞌangel Dios. Te vaꞌal ijul ta nopol scajleb schicꞌobil pomriox li te ta sbatsꞌicꞌob li Zacaríase. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cꞌalal iyil li chꞌul ángel li Zacaríase, ixiꞌ tajmec, iyal yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jech iꞌalbat yuꞌun li chꞌul ángele: ―Mu me xaxiꞌ, Zacarías. Laj xa yaꞌibot acꞌop li Diose. Ta xil yol li Elisabete, jaꞌ la avajnile. Querem ta xil. Juan chavacꞌbe sbi. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Cꞌalal mi ivoqꞌue, xamuybaj noꞌox yuꞌun. Ep buchꞌutic xmuybaj eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yuꞌun ta xichꞌ tsots yabtel ta stojol Dios. Mu xuchꞌ yaꞌlel tsꞌusub li pajubem xae, schiꞌuc mu xuchꞌ pox. Ichꞌbil ta venta yuꞌun li Chꞌul Espíritu li cꞌalal ta xvoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Oy ep achiꞌiltac ta israelal ta xictaic smulic ta sventa li Juane, jaꞌ ta xacꞌ sbaic ta scꞌob li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Li Juane jaꞌ baꞌi ta xtal, jaꞌ tsꞌacal ta xtal la Avajcoltavanejique. Li Juane coꞌol sjol yoꞌonic jech chac cꞌu chaꞌal li Elías ta voꞌonee yuꞌun ta smelol noꞌox chal batel li cꞌusi tscꞌan li Diose. Baꞌi chtal yalbe achiꞌiltac ti acꞌo yictaic li cꞌustic chopol tspasique yoꞌ jech jmoj yoꞌonic schiꞌuc snichꞌnabic ta jupꞌej snaique. Ta stuqꞌuibtasbe yoꞌonic li buchꞌutic mu schꞌunic mantale yoꞌ acꞌo yichꞌic ta mucꞌ li Cajvaltic li cꞌalal mi itale ―xi li chꞌul ángele. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Li Zacaríase la sjacꞌbe li chꞌul ángele: ―¿Cꞌu sba ta jnaꞌ o mi melel li cꞌusi avalbune? Yuꞌun molun xa, meꞌel xa eꞌuc li cajnile ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Itacꞌav li chꞌul ángele: ―Joꞌon Gabrielun, joꞌon te chiꞌabtej ta stojol li Diose. Tacbilun talel yuꞌun Dios ti tal jcꞌoponote. Jaꞌ chacalbe ti chavil jun anichꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero ta scoj ti mu xachꞌun li cꞌusi laj calbote chapas ta umaꞌ. Jaꞌ to mi ista scꞌacꞌalil ta xvocꞌ la anichꞌone jech chac cꞌu chaꞌal laj calbote, jaꞌ to ta xjam la avee. Yuꞌun ta onoꞌox xcꞌot ta pasel ti chavil la anichꞌone mi icꞌot scꞌacꞌalil li cꞌu sba snopoj li Diose ―xꞌutat li Zacaríase. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Li crixchanoetic li te oyic ta amaqꞌue, te tsmalaic ta xlocꞌ talel li Zacaríase. Iyal yoꞌonic yuꞌun ijocꞌtsaj xa li ta yut li mucꞌta chꞌulnae. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cꞌalal ilocꞌ talel li Zacaríase, mu xa xcꞌopoj, macal xa ye. Jech la snaꞌic o ti oy cꞌusi iꞌacꞌbat yil yuꞌun Dios te ta yut li mucꞌta chꞌulnae. Jaꞌ xa noꞌox la syeꞌulan scꞌob yoꞌ chacꞌ ta ilel li cꞌusi ispase, yuꞌun ipas ta umaꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cꞌalal itsꞌaqui ti jayib cꞌacꞌal te ta xꞌabtej li ta mucꞌta chꞌulna li Zacaríase, isut batel ta sna. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lic schiꞌin yol li yajnile, jaꞌ li Elisabete. Cꞌalal schiꞌuc xaꞌox yole, joꞌob u te icom ta sna. Jech la snopilan: ");
INSERT INTO tzoSA_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Iyil li Cajvaltic Dios ti chisnaꞌleic li crixchanoetique, jaꞌ yuꞌun liscꞌuxubin. Jaꞌ yuꞌun oyun xa ta crixchano”, xi ta yoꞌon li Elisabete. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cꞌalal svaquibal xaꞌox u schiꞌuc yol li Elisabete, li Diose la stac talel li yajꞌangel Gabriele li ta jteclum Nazaret li te ta Galilea balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Li chꞌul ángel Gabriele tacbil batel yuꞌun Dios ti acꞌo ba scꞌopon jun tojol tseub, María sbi. Pero macbil xaꞌox yuꞌun jun vinic, José sbi. Li smucꞌta moltot ta voꞌone li Josee, jaꞌ li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Li chꞌul ángele te icꞌot li yoꞌ bu oy li tseube, jech laj yalbe: ―Joꞌot tꞌujbilot yuꞌun Dios. Liꞌ achiꞌuque. Muc buchꞌu yan tseub jech ta xꞌacꞌbat slequilal yutsilal Dios jech chac cꞌu chaꞌal li joꞌote ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cꞌalal iyaꞌi li cꞌusi iꞌalbat yuꞌun li chꞌul ángel li Maríae, icꞌopoj yoꞌon ti cꞌu chaꞌal ti jech iꞌalbate. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Laj yal nojtoc li chꞌul ángele: ―Mu xaxiꞌ, María, yuꞌun lec chayil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aꞌio li cꞌusi chacalbee. Chachiꞌin avol. Chavil jun querem. Jesús chavacꞌbe sbi. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta xꞌichꞌe ta mucꞌ yuꞌun jaꞌ Snichꞌon Dios ta vinajel. Ta xꞌaqꞌue yuꞌun Dios ti ch‐och ta ajvalilale. Jaꞌ chlic spasoxuc ta mantal jech chac cꞌu chaꞌal la spas ta mantal achiꞌiltac ta voꞌone la amoltotic Davide. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Sbatel osil chaspasoxuc ta mantal, joꞌoxuc li jꞌisraeloxuque. Muꞌyuc slajeb ti tspasvan ta mantale ―xi li chꞌul ángele. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Itacꞌav li Maríae: ―¿Cꞌu sba ta jchiꞌin col yuꞌun muc to bu quiloj vinic? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Itacꞌav li chꞌul ángele: ―Yuꞌun chjul ta atojol li Chꞌul Espíritue. Ta sventa sjuꞌel Dios chachiꞌin la avole. La avol ti chavile muꞌyuc smul chtal yuꞌun jaꞌ Snichꞌon Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aꞌio, schiꞌuc xa yol eꞌuc la avutsꞌ avalal, jaꞌ li Elisabete. Manchuc mi meꞌel xa pero svaquibal xa u schiꞌuc yol, jaꞌ li mu onoꞌox snaꞌ xil yole. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Li Diose scotol xuꞌ yuꞌun ―xi li chꞌul ángele. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Itacꞌav li Maríae: ―Jechuc, acꞌo tuncun yuꞌun li Diose. Acꞌo spasbun li cꞌusi la avalbune ―xut. Ibat li chꞌul ángele. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tsꞌacal to ilocꞌ batel li Maríae, ibat ta anil ta jun jteclum li ta vitstic li te ta Judea balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jaꞌ to te nacal li Zacaríase. Jaꞌ te icꞌot li Maríae. Iꞌoch ta na. “Yaa”, xut cꞌotel li Elisabete. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cꞌalal iyaꞌi li Elisabet ti icꞌoponat yuꞌun li Maríae, tsots inic li yol li schiꞌuque. Li Elisabete iꞌacꞌbat ta sjol ta yoꞌon yuꞌun li Chꞌul Espíritue ti cꞌu sba chcꞌopoj ta orae. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jech tsots icꞌopoj li Elisabete: ―Muc buchꞌu yan tseub ta xꞌacꞌbat slequilal yutsilal Dios jech chac cꞌu chaꞌal li joꞌote. Toj lec la avol ti chavile. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Cꞌuxi joꞌot tal ajulaꞌanun li smeꞌot li Cajvaltique yuꞌun muꞌyuc tsots cabtel ma joꞌone? ");
INSERT INTO tzoSA_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yuꞌun cꞌalal la acꞌoponune, inic li col li jchiꞌuque yuꞌun xmuybaj xa. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Toj lec ti la achꞌun ti chcꞌot ta pasel li cꞌusi laꞌalbat yuꞌun li Cajvaltic Diose ―xi li Elisabete. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Li Maríae jech laj yal: Toj echꞌem slequilal yutsilal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ximuybaj noꞌox ta stojol yuꞌun jaꞌ Cajcoltavanej. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Acꞌo mi mu cꞌusi xitun o pero iyil ti chitun yuꞌune. Li crixchanoetique jech ta xalic ti cꞌalal ta xꞌechꞌic liꞌ ta balumile: “Xmuybaj noꞌox ti iꞌacꞌbat schiꞌin svoqꞌues li Cajvaltique”, xi jcꞌoplal yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Li Diose oy stsatsal sjuꞌel. Toj lec li cꞌusi icꞌot ta jtojol yuꞌune jech acꞌo ichꞌeuc ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Li crixchanoetic li ta xꞌechꞌic liꞌ ta balumile, mi ta xichꞌic ta mucꞌ li Diose, ta xichꞌic cꞌuxubinel. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Li Diose yacꞌoj ta ilel ti scotol xuꞌ yuꞌune. Xuꞌ yuꞌun ta spajesbe yabtel li buchꞌutic ta stoy sbaique, jaꞌ li buchꞌutic pꞌij chaꞌi sbaique, jech mu xuꞌ ta spasic li cꞌustic snopojique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Li Diose xuꞌ yuꞌun ta sloqꞌues ta yabtel li mucꞌta ajvaliletique. Xuꞌ yuꞌun ta xacꞌbe tsots yabtel li buchꞌutic mu cꞌusi bal o ch‐ileique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Naca lec li cꞌustic ta xꞌacꞌbat ta yoꞌonic li buchꞌutic snaꞌic ti muc bu lequic li stuquique. Yan li buchꞌutic ti lec spꞌisoj sbaique jaꞌ mu cꞌusi ta staic o. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Joꞌotic li jꞌisraelutique chiscoltautic onoꞌox li jayvoꞌutic li quichꞌojtic ta muqꞌue. Mu xchꞌay ta yoꞌon ti jech onoꞌox laj yalbe li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yuꞌun laj yalbe onoꞌox li jtotic jmeꞌtic Abraham ta voꞌone ti ta scꞌuxubin sbatel osil schiꞌuc li snitilultaque, xi li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Li Maríae te la schiꞌin sbaic oxib u schiꞌuc li Elisabete, isut batel ta sna. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cꞌalal ista yual ta xcux li Elisabete, querem iyil. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Li yutsꞌ yalaltac li Elisabete schiꞌuc li slacꞌnataque, iyaꞌiic ti iyil xa li yole yuꞌun icꞌuxubinat yuꞌun li Diose. Jech coꞌol xmuybajic scotolic schiꞌuc li Elisabete. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cꞌalal ilocꞌ vaxaquib cꞌacꞌal svoqꞌuel li unen quereme, ba yacꞌbeic yichꞌ circuncisión. Li yutsꞌ yalaltaque la snopic ti jaꞌ ta xichꞌbe sbi stot li unen quereme. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero li smeꞌe jech laj yal: ―Maꞌuc chcacꞌbecutic sbi li stote. Juan ta xcacꞌbecutic sbi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jech iꞌalbat: ―¿Cꞌu chaꞌal Juan chavacꞌbeic sbi? Yuꞌun muc buchꞌu jech sbi cuꞌuntic liꞌi ―xꞌutat yuꞌun li yutsꞌ yalaltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","La sjacꞌbeic stot li unene. Laj yacꞌbeic senya ta scꞌobic yoꞌ acꞌo yal ti cꞌusi sbi ta xacꞌbe li snichꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Li Zacaríase la scꞌan jpech unen tenelteꞌ, la stsꞌiba: “Juan ta xcacꞌbe sbi”, xi. Jech toj chꞌayel noꞌox yoꞌonic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ijam ye ta ora, lic cꞌopojuc li Zacaríase. Laj yalbe coliyal Dios ti jech icꞌuxubinatique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ixiꞌic tajmec scotolic li slacꞌnataque. Li buchꞌutic te nacalic ta vitstic ta Judea balumile, iyaꞌi scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Scotol li buchꞌutic iyaꞌiique jech la snopilanic ta yoꞌonic: “¿Cꞌusi yabtel ta stsac li querem taje?” xi ta yoꞌonic. Yuꞌun li quereme qꞌuelbil chabibil yuꞌun li Cajvaltic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Li Zacaríase, jaꞌ li stot li unen quereme, ijulesbat ta sjol ta yoꞌon yuꞌun li Chꞌul Espíritue li cꞌusi ta xcꞌot ta pasele. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Coliyal li Cajvaltic Diose, jaꞌ li Dios cuꞌuntic, joꞌotic li jꞌisraelutique, chtal xa sqꞌuelutic, joꞌotic ti tꞌujbilutic onoꞌox yuꞌune. Chtal xa scoltautic. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta xtal xa li Cajcoltavanejtique, jaꞌ li oy sjuꞌel oy stsatsale. Jaꞌ snitilul li Davide, jaꞌ li lec itune yuꞌun Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Li Diose voꞌone onoꞌox la schꞌamunbe ye li buchꞌutic iyalic ba li scꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jaꞌ laj yalic ti chijcolutic loqꞌuel ta scꞌob li buchꞌutic chiscontrainutique, ti xtiꞌet noꞌox yoꞌonic ta jtojoltique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chiscꞌuxubinutic jech chac cꞌu chaꞌal iꞌalbatic onoꞌox li jtotic jmeꞌtic ta voꞌonee. Jech ta xquiltic o ti mu xchꞌay ta yoꞌon li cꞌusi laj yalbe li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Jaꞌ joꞌotic jcꞌoplaltic ti laj yalbe li jtotic jmeꞌtic Abraham ti ta jꞌechꞌel chiscoltautic loqꞌuel ta scꞌob li buchꞌutic snacojutique, jech muꞌyuc xa xiꞌel ta xcaꞌitic, xuꞌ xa chijtun yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Jech jun noꞌox coꞌontic ta xquichꞌtic ta mucꞌ li jayib cꞌacꞌal liꞌ cuxulutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Li jnichꞌone jaꞌ ta xal li scꞌop Diose. Jaꞌ baꞌi chlic abtejuc; jaꞌ tsꞌacal chlic abtejuc li Cajvaltique. Jaꞌ chlic yalbe jchiꞌiltactic ti acꞌo yictaic li cꞌustic chopol ta spasique, jaꞌ jech chichꞌic o ta mucꞌ li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jaꞌ ta xalbe ti ta spasbatic perton yuꞌun li smulique, jaꞌ jech chcolic o mi ta schꞌunic ti jaꞌ Yajcoltavanejic li Cajvaltique, yuꞌun tꞌujbilutic onoꞌox yuꞌun Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ta slequil noꞌox yoꞌon chiscꞌuxubinutic li Dios cuꞌuntique; ta xa xistacbutic talel li Cajcoltavanejtique. Toj lec ti liꞌ ta xtal ta jtojoltique. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jaꞌ chiscoltautic yoꞌ jaꞌ lec chijyilutic o li Diose, ti jaꞌ chlaj o scꞌoplal ti chijchꞌayutic o sbatel osile, xi li Zacaríase. ");
INSERT INTO tzoSA_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cꞌalal ichꞌi li quereme, iꞌayan stsatsal yoꞌon. Jech stuc te ba nacluc ta taqui jamaltic. Cꞌalal icꞌot scꞌacꞌalil lic yal li scꞌop Diose, te ba yaꞌiic li schiꞌiltac ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Li Augusto Césare jaꞌ o ajvalil ta sventa spꞌejel balumil li cꞌalal ivocꞌ li Juane. Iyal mantal ti acꞌo yacꞌ ta tsaquel ta jun sbiic scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jaꞌ sba toꞌox jech ispasic li cꞌalal tiqꞌuil ta gobernador te ta Siria balumil li Cirenioe. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jech scotol crixchanoetic ba yacꞌ ta tsaquel sbiic ta slumal stuquic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Li Josee ilocꞌ batel ta jteclum Nazaret li te ta Galilea balumile, ibat ta Judea balumil. Te icꞌot ta jteclum Belén yuꞌun te ivocꞌ li smoltot ta voꞌonee, jaꞌ li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yuꞌun jaꞌ slumal icꞌot eꞌuc li Josee, jaꞌ yuꞌun te ba yacꞌ ta tsaquel sbiic ta Belén schiꞌuc li yajnile, jaꞌ li Maríae. Pero muc toꞌox bu xcuxoj li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cꞌalal te oyic ta Belene, jaꞌ o ista yual ta xcux li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Querem li sba yole. La spix ta pocꞌ, la spuchꞌan ta veꞌeb vacax. Yuꞌun muc bu xocol istaic li snail vayebal ti chaqꞌuic ta loqꞌuele, yuꞌun jpꞌej noꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te ta nopol tiꞌ Belén te oy jayvoꞌ jchabiejchijetic. Te ta schabi schijic ta acꞌubaltic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te ivinaj ta ora jun yajꞌangel Dios. Joybil icꞌotic ta xojobal Dios. Cꞌalal iyilic li jchabiejchijetique, ixiꞌic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Xi iꞌalbatic yuꞌun li chꞌul ángele: ―Mu xaxiꞌic. Oy cꞌusi lec chacalbeic yoꞌ jech xamuybajic o acotolic. Acꞌo yaꞌiic scotol la achiꞌiltaquic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nax ivocꞌ ta Belén Avajcoltavanejic, jaꞌ tꞌujbil yuꞌun Dios ti ta xꞌoch ta mucꞌta ajvalil avuꞌunique. Jaꞌ Cajvaltic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chacalbeic li cꞌu sba chataic li unene. Pixbil ta pocꞌ chataic, te puchꞌul ta veꞌeb vacax ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Te ivinaj ta ora ep tajmec yajꞌangeltac Dios. Laj yalic slequilal Dios. Jech laj yalic: ");
INSERT INTO tzoSA_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Toj echꞌem slequilal Dios ta vinajel! Acꞌo pasuc ta jun yoꞌonic li crixchanoetic ta sventa ti oy slequil yoꞌon li Dios ta stojolique, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cꞌalal isutic ta vinajel li chꞌul ángeletique, xi laj yalbe sbaic li jchabiejchijetique: ―Batic ta Belén chaꞌa. Ba jqꞌueltic cꞌusi li lec icꞌot ta pasel li lijyalbutic li Diose ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ibatic ta anil. Te istaic li María schiꞌuc li Josee, schiꞌuc li unen li te puchꞌul ta veꞌeb vacaxe. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cꞌalal iyilic li unene, ba spucbeic scꞌoplal. Ba yalic li cꞌusi iꞌalbatic yuꞌun li chꞌul ángele. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Scotol li buchꞌutic iyaꞌiic li cꞌu sba laj yalic li jchabiejchijetique, toj chꞌayel noꞌox yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Li Maríae muc xchꞌay ta yoꞌon scotol li cꞌusi laj yalic li jchabiejchijetique, la snopilan li cꞌusi smelole. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Isutic li jchabiejchijetique. Iyichꞌic ta mucꞌ li Diose, laj yalbeic slequilal. Yuꞌun iyaꞌiic xa, iyilic xa scotol jech chac cꞌu chaꞌal iꞌalbatic yuꞌun li yajꞌangel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cꞌalal ilocꞌ vaxaquib cꞌacꞌal svoqꞌuel li unen quereme, laj yichꞌ circuncisión. Jesús laj yacꞌbeic sbi yuꞌun jech onoꞌox iꞌalbatic yuꞌun li yajꞌangel Dios li cꞌalal muc toꞌox bu schiꞌuc yol li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta xal ta smantaltac Dios li la stsꞌiba Moisés ta voꞌonee, mi querem yol li antse, jaꞌ to xuꞌ ta xbat ta mucꞌta chꞌulna mi itsꞌaqui oxlajuneb schaꞌvinic (33) cꞌacꞌal svoqꞌuele. Li Maríae itsꞌaqui xa yuꞌun li oxlajuneb schaꞌvinic cꞌacꞌale, ibatic ta mucꞌta chꞌulna li te ta Jerusalén schiꞌuc li Josee, yuꞌun ba yaqꞌuic ta scꞌob Dios li squeremique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yuꞌun jech ta xal li smantal Dios li tsꞌibabil comele: “Scotol li sba achꞌamalique, mi quereme, jaꞌ cuꞌun”, xi onoꞌox li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Laj yacꞌbeic smoton Dios nojtoc yuꞌun jech yaloj ta mantal li Diose: “Mi muꞌyuc schije, acꞌo yicꞌ talel chaꞌcot pruvoc, mi chaꞌcot stsu, sventa jmoton”, xi onoꞌox li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oy jun jꞌisraelal vinic te ta Jerusalén, Simeón sbi. Tucꞌ yoꞌon ta stojol Dios, lec yichꞌoj ta mucꞌ. Smalaoj ti ta xtal jun ajvalil yuꞌunique yuꞌun jaꞌ ta xcolic loqꞌuel ta scꞌob li yan ajvalile. Li Simeone ventainbil yoꞌon yuꞌun li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Acꞌbil xa snaꞌ yuꞌun li Chꞌul Espíritu ti jaꞌ to ta xcham mi iyilbe sat li Cristo li tꞌujbil yuꞌun Dios ti ta xꞌoch ta ajvalilal yuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Li Simeone ijulesbat ta sjol ta yoꞌon yuꞌun li Chꞌul Espíritu ti acꞌo batuc li ta mucꞌta chꞌulna li te ta Jerusalene. Jech cꞌalal ibatic li ta mucꞌta chꞌulna li José schiꞌuc li Maríae, schiꞌuc li unene, yuꞌun ba spasic jech chac cꞌu chaꞌal ta xal li mantaletique, te xaꞌox oy ta yamaqꞌuil li mucꞌta chꞌulna li Simeone. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Li Simeone la spet li unene, laj yalbe coliyal Dios. Xi laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Cajval, jun xa coꞌon, icꞌun me ta atojol te ta vinajel jech chac cꞌu chaꞌal avalojbun onoꞌoxe, joꞌon la avajtunelune. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Yuꞌun iquil xa ta jsat li Cajcoltavanejcutic ti la atac talel ta jtojolcutic jcotolcutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jaꞌ saquil chꞌul osil yuꞌunic yaꞌel li jyanlumal crixchanoetique yuꞌun chilic eꞌuc ti xuꞌ ta xcolique. Joꞌoncutic li jꞌisraeluncutic ti tꞌujbiluncutic onoꞌox avuꞌune, avichꞌojuncutic ta mucꞌ yuꞌun liꞌ ijul ta jtojolcutic li Jcoltavaneje, xi li Simeone. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Li José schiꞌuc smeꞌ li unene toj chꞌayel noꞌox yoꞌonic ti oy scꞌoplal li unene. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Li Simeone la scꞌanbe slequilal yutsilal Dios ta stojolic. Jech laj yalbe nojtoc li smeꞌ li unene, jaꞌ li Maríae: ―Aꞌio me, ta sventa la avol liꞌi jaꞌ ta xvinaj o cꞌu sba yoꞌonic li jchiꞌiltactic ta israelale. Ep ta xichꞌ contrainel la avole yuꞌun mu xcꞌane yuꞌun ep jchiꞌiltactic. Jech chlic avat avoꞌon ta scoj ti mu xcꞌanee. Pero oy yan jchiꞌiltactic ta xtuqꞌuib yoꞌonic ta sventa la avole ―xi li Simeone. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te oy ta yamaqꞌuil li mucꞌta chꞌulna jun jꞌisraelal ants, Ana sbi. Jaꞌ ta xal scꞌop Dios eꞌuc. Jaꞌ yantsilnichꞌon Fanuel, jaꞌ smoltot ta voꞌone li Asere. Meꞌel xa li Anae. Jucub noꞌox jabil laj yicꞌ sbaic schiꞌuc li smalale yuꞌun icham. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Li Anae chanib xa yoꞌvinic (84) jabil yichꞌoj. Ep xa jabil ti muꞌyuc smalale. Scotol cꞌacꞌal te ta xcꞌotilan ta yamaqꞌuil li mucꞌta chꞌulnae. Cꞌacꞌal acꞌubal te ta xtune yuꞌun li Diose yuꞌun ta xicta yixim, schiꞌuc ta sta ta naꞌel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Li Simeone jaꞌ o yacal ta xal li cꞌusi yabtel li unen li cꞌalal icꞌot li Anae. Li Anae laj yalbe coliyal Dios eꞌuc yuꞌun ital xa li Jcoltavaneje. Tsꞌacal to lic spucbe scꞌoplal li unene. Laj yalbe scotol schiꞌiltac li te ta Jerusalene, jaꞌ li buchꞌutic smalaojic ti ta xcolique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cꞌalal la spasic scotol li cꞌusi yaloj Dios li José schiꞌuc li Maríae, isutic batel ta slumalic ta Nazaret ta Galilea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lec sba ichꞌi li quereme, jaꞌ li Jesuse. Lec oy schꞌulel ichꞌi, lec pꞌij, yuꞌun coltabil yuꞌun Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Li stot smeꞌ li Jesuse scotol jabil te ta xcꞌotilanic ta Jerusalén li cꞌalal qꞌuin o Coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cꞌalal yichꞌoj xaꞌox lajchaeb jabil li Jesuse, ibatic ta qꞌuin ta Jerusalén yuꞌun jech smantal Dios ti persa ta xbat scotol li viniquetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cꞌalal iꞌechꞌ qꞌuine, isut batel ta snaic li José schiꞌuc li Maríae, pero mu snaꞌic mi te icom ta Jerusalén li squeremique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Xalic noꞌox ti te xbat schiꞌuquic li yutsꞌ yalaltaque. Cꞌalal ixanavic xa batel jun cꞌacꞌale, la sjacꞌbeic li yutsꞌ yalaltaque schiꞌuc li buchꞌutic xojtaquinic li quereme. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero muc bu staic. Ichaꞌsutic batel cꞌalal ta Jerusalén, te cꞌot saꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ta yoxibal to cꞌacꞌal te istaic ta yut jun na li te ta mucꞌta chꞌulna ta Jerusalene. Li Jesuse te chotol ta oꞌlol li yoꞌ bu tsobolic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Te chaꞌi li cꞌusi chalic li jchanubtasvanejetique schiꞌuc oy cꞌusi ta sjacꞌulan li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Scotol li jchanubtasvanejetique ichꞌay o yoꞌonic ta sventa ti toj lec ta smelol ta xtacꞌav li Jesuse, schiꞌuc ti oy cꞌusi lec tsjaqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Li José schiꞌuc li Maríae, cꞌalal iyilic ti te schiꞌuc li jchanubtasvanejetic li squeremique, ichꞌay yoꞌonic eꞌuc. Li Jesuse jech iꞌalbat yuꞌun li smeꞌe: ―Querem, ¿cꞌu chaꞌal jech chapasbuncutic? La jsaꞌotcutic tajmec. Icat coꞌoncutic yuꞌun muc bu xajtacutic ta saꞌel ―xꞌutat yuꞌun li smeꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Itacꞌav li Jesuse: ―¿Cꞌu chaꞌal chasaꞌicun? ¿Mi mu xanaꞌic ti liꞌ oyun li yoꞌ bu ta spasbat yabtel li Jtote? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Li José schiꞌuc li Maríae muc bu xaꞌibeic smelol li cꞌusi laj yal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Li Jesuse schiꞌuc sutel ta Nazaret li stot smeꞌe. Ti jayib jabil te schiꞌuc li stot smeꞌe la schꞌunbe scotol li smantalique. Li Maríae muc xchꞌay ta yoꞌon li cꞌu sba itacꞌav li te ta mucꞌta chꞌulna li yole, schiꞌuc ti lec ichꞌunbat li smantalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Cꞌalal ichꞌi li Jesuse, lec pꞌij. Lec iꞌile yuꞌun Dios, lec iꞌile nojtoc yuꞌun li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Li Tiberio Césare sjoꞌlajunebal xa jabil yochel ta mucꞌta ajvalil li te ta jteclum Roma li cꞌalal lic stsac yabtel li Juane. Ta Judea balumile jaꞌ te ochem ta gobernador li Poncio Pilatoe. Ta Galilea balumile jaꞌ te ochem ta gobernador li Herodese. Ta Iturea balumile schiꞌuc ta Traconite balumile, jaꞌ te ochem ta gobernador li yitsꞌin Herodese, jaꞌ li Felipe sbie. Ta Abilinia balumile jaꞌ te ochem ta gobernador li Lisániase. Li banquilal paleetic yuꞌun li jꞌisraeletique jaꞌ ochemic li Anás schiꞌuc Caifase. Cꞌalal jaꞌ o jech yichꞌanoj yabtelique, jaꞌ o te oy ta taqui jamaltic li Juane, jaꞌ li snichꞌon Zacaríase. Jaꞌ o ista yora iꞌacꞌbat snaꞌ yuꞌun Dios ti acꞌo yalbe li schiꞌiltac li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Li Juane te ixanav batel ta tiꞌtiꞌ ucꞌum Jordán. Jech laj yal: ―Ictaic scotol li cꞌustic chopol chapasique, ichꞌic joꞌ jech chaspasboxuc perton yuꞌun amulic li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Li Juane jech onoꞌox tsꞌibabil comel scꞌoplal yuꞌun li Isaías li iyal scꞌop Dios ta voꞌonee. Jech la stsꞌiba: Chlic jun jchiꞌiltic ta israelal, tsots chal ta taqui jamaltic ti chtal li Cajvaltique. Jaꞌ yuꞌun chal nojtoc: “Ictaic scotol li cꞌustic chopol chapasique. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jaꞌ ichꞌbeic ta mucꞌ li scꞌope yoꞌ jaꞌ lec chabatic yuꞌun jaꞌ tstuqꞌuibtas coꞌontic. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yuꞌun jaꞌ Cajcoltavanejtic li tacbil talel yuꞌun li Diose. Jaꞌ chtal scolta scotol li crixchanoetique”, xi chalbe li jchiꞌiltactique, xi onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Toj ep buchꞌutic ba scꞌanbeic ti acꞌo xꞌacꞌbatic yichꞌic joꞌ yuꞌun li Juane. Li Juane jech laj yalbe: ―Li joꞌoxuque jun chac stsꞌunbaloxuc li orachone. Li orachone ta xjatav loqꞌuel ta anil li cꞌalal mi iyaꞌi ti ta xtal cꞌoqꞌue. Jaꞌ jechoxuc li joꞌoxuque. ¿Mi yuꞌun avaꞌiic ti ta onoꞌox xavichꞌic vocol yuꞌun Dios ti latalic ta anile, yoꞌ tal acꞌanic avichꞌic joꞌe? ");
INSERT INTO tzoSA_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pero scꞌan baꞌi xavaqꞌuic ta ilel mi avictaojic xa li cꞌustic chopol chapasique. Mu me xanopic: “Jaꞌ jmucꞌta moltotcutic ta voꞌone li Abrahame, jaꞌ jech ta onoꞌox xijcolcutic”, mu me xachiic. Chacalbeic, li Diose xuꞌ yuꞌun ta scꞌatajesbe ta snitilul Abraham li tonetic liꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Li joꞌoxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal teꞌetic ti muc bu lec li sat ta xaqꞌue. Te xa metsel yecꞌlal li ta yoque yuꞌun ta xa xichꞌ tsꞌetel. Ta xichꞌ chiqꞌuel ta cꞌocꞌ ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Li crixchanoetique jech la sjacꞌbeic li Juane: ―¿Cꞌusi scꞌan ti ta jpascutique chaꞌa? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Itacꞌav li Juane: ―Li buchꞌu oy chaꞌlic scꞌuꞌe acꞌo yacꞌbe jlicuc li buchꞌu muꞌyuc scꞌuꞌe. Li buchꞌu oy sveꞌele acꞌo yacꞌbe li buchꞌu muꞌyuc sveꞌele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Italic jayvoꞌ jtsobpatanetic yuꞌun tscꞌan chichꞌic joꞌ eꞌuc. Jech cꞌot sjacꞌbeic li Juane: ―Jchanubtasvanej, li joꞌoncutique ¿cꞌusi ta jpascutic eꞌuc? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Li Juane jech laj yalbe: ―Mu me xacꞌanbeic ta más li spatanic ti chatsobique. Jaꞌ noꞌox jech yepal xacꞌanbeic ti cꞌu sba avichꞌojic mantale ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Te oy nojtoc jayvoꞌ soltaroetic. Jech la sjacꞌbeic eꞌuc li Juane: ―Li joꞌoncutique ¿cꞌusi ta jpascutic eꞌuc? ―xiic. Itacꞌav li Juane: ―Mu me buchꞌu xasibtesic, mu me buchꞌu xasaꞌbeic smul yoꞌ jech xuꞌ chacꞌanbeic o li staqꞌuinique. Muybajanic noꞌox ti cꞌu yepal chavichꞌ atojolique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Scotol li crixchanoetique ta xal ta yoꞌonic mi jaꞌ xa nan li buchꞌu tꞌujbil yuꞌun Dios ti ta xꞌoch ta ajvalilal li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Li Juane jech laj yalbe scotol li crixchanoetique: ―Li joꞌone jaꞌ noꞌox cabtel ta xcacꞌbe yichꞌic joꞌ li buchꞌutic chictaic li cꞌustic chopol ta spasique. Pero oy to buchꞌu tsꞌacal ta xtal, jaꞌ más tsots yabtel yichꞌoj. Li joꞌone muc bu tsots cabtel quichꞌoj. Mu cꞌusi xuꞌ cuꞌun ta jcolta o. Acꞌo mi slocꞌbeel xonob, mu xuꞌ chcaꞌi yuꞌun mu cꞌusi xitun o. Yan li buchꞌu tsꞌacal ta xtale, jaꞌ chayacꞌbeic avichꞌic li Chꞌul Espíritu ti coꞌol schiꞌuc cꞌoqꞌue yuꞌun ta sloqꞌues scotol li cꞌustic chopol ta avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Li buchꞌutic ta scꞌan loqꞌuesbeel li cꞌustic chopol ta yoꞌonique, jaꞌ ta xꞌiqꞌueic o sbatel osil. Yan li buchꞌutic mu scꞌan loqꞌuesbeele jaꞌ ta xbatic o ta cꞌocꞌ li yoꞌ bu mu onoꞌox xtupꞌe. Jech chac cꞌu chaꞌal li buchꞌu ta xicꞌa strigoe. Mi ilaj yoꞌon ta yicꞌaele, ta stsob scotol li strigoe, ta sticꞌ ochel ta snail. Scotol li steꞌele schiꞌuc li solile ta schicꞌ ta cꞌocꞌ ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Li Juane oy ep cꞌustic lec laj yalbe li schiꞌiltac ta israelale. Jaꞌ laj yalbe ti liꞌ xa oy li buchꞌu scꞌoplal onoꞌox chtal ventainvanuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Laj yalbe nojtoc li ajvalil Herodes ti ep li cꞌustic chopol ta spase. Laj yalbe nojtoc ti chopol ti la spojbe yajnil li yitsꞌine. Herodías sbi li antse. Jaꞌ Felipe sbi li yitsꞌin li Herodese. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero muc schꞌun. Más to chopol li cꞌusi la spas li Herodese yuꞌun la sticꞌ ta chuquel li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cꞌalal jaꞌ o te ta xacꞌbe yichꞌic joꞌ ep crixchanoetic li Juane, te icꞌot li Jesuse, iꞌacꞌbat yichꞌ joꞌ eꞌuc. La sta ta naꞌel Dios li Jesuse. Cꞌalal jaꞌ o ta sta ta naꞌel Diose, ijam li vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iyal talel ta sba Jesús li Chꞌul Espíritue. Coꞌol schiꞌuc jcot jculajteꞌ yilel. Jech iyichꞌ o li Chꞌul Espíritue. Li Diose icꞌopoj talel ta vinajel, jech laj yal: ―Joꞌot Jnichꞌonot, toj cꞌuxot ta coꞌon. Ximuybaj noꞌox avuꞌun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cꞌalal lic stsac li yabtel li Jesuse, yichꞌoj lajuneb schaꞌvinic (30) jabil. Ta xalic li crixchanoetic ti jaꞌ snichꞌon Josee pero maꞌuc. Li Jesuse jaꞌ smom li Elí ti jaꞌ stot li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Li stot li Elie jaꞌ Matat. Li stot li Matate jaꞌ Leví. Li stot li Levie jaꞌ Melqui. Li stot li Melquie jaꞌ Jana. Li stot li Janae jaꞌ José. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Li stot li Josee jaꞌ Matatías. Li stot li Matatíase jaꞌ Amós. Li stot li Amose jaꞌ Nahúm. Li stot li Nahume jaꞌ Esli. Li stot li Eslie jaꞌ Nagai. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Li stot li Nagaie jaꞌ Maat. Li stot li Maate jaꞌ Matatías. Li stot li Matatíase jaꞌ Semei. Li stot li Semeie jaꞌ José. Li stot li Josee jaꞌ Judá. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Li stot li Judae jaꞌ Joana. Li stot li Joanae jaꞌ Resa. Li stot li Resae jaꞌ Zorobabel. Li stot li Zorobabele jaꞌ Salatiel. Li stot li Salatiele jaꞌ Neri. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Li stot li Nerie jaꞌ Melqui. Li stot li Melquie jaꞌ Adi. Li stot li Adie jaꞌ Cosam. Li stot li Cosame jaꞌ Elmodam. Li stot li Elmodame jaꞌ Er. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Li stot li Ere jaꞌ Josué. Li stot li Josuee jaꞌ Eliezer. Li stot li Eliezere jaꞌ Jorim. Li stot li Jorime jaꞌ Matat. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Li stot li Matate jaꞌ Leví. Li stot li Levie jaꞌ Simeón. Li stot li Simeone jaꞌ Judá. Li stot li Judae jaꞌ José. Li stot li Josee jaꞌ Jonán. Li stot li Jonane jaꞌ Eliaquim. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Li stot li Eliaquime jaꞌ Melea. Li stot li Meleae jaꞌ Mainán. Li stot li Mainane jaꞌ Matata. Li stot li Matatae jaꞌ Natán. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Li stot li Natane jaꞌ David. Li stot li Davide jaꞌ Isaí. Li stot li Isaie jaꞌ Obed. Li stot li Obede jaꞌ Booz. Li stot li Booze jaꞌ Salmón. Li stot li Salmone jaꞌ Naasón. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Li stot li Naasone jaꞌ Aminadab. Li stot li Aminadabe jaꞌ Aram. Li stot li Arame jaꞌ Esrom. Li stot li Esrome jaꞌ Fares. Li stot li Farese jaꞌ Judá. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Li stot li Judae jaꞌ Jacov. Li stot li Jacove jaꞌ Isaac. Li stot li Isaaque jaꞌ Abraham. Li stot li Abrahame jaꞌ Taré. Li stot li Taree jaꞌ Nacor. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Li stot li Nacore jaꞌ Serug. Li stot li Serugue jaꞌ Ragau. Li stot li Ragaue jaꞌ Peleg. Li stot li Pelegue jaꞌ Heber. Li stot li Hebere jaꞌ Sala. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Li stot li Salae jaꞌ Cainán. Li stot li Cainane jaꞌ Arfajad. Li stot li Arfajade jaꞌ Sem. Li stot li Seme jaꞌ Noé. Li stot li Noee jaꞌ Lamec. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Li stot li Lameque jaꞌ Matusalén. Li stot li Matusalene jaꞌ Enoc. Li stot li Enoque jaꞌ Jared. Li stot li Jarede jaꞌ Mahalaleel. Li stot li Mahalaleele jaꞌ Cainán. ");
INSERT INTO tzoSA_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Li stot li Cainane jaꞌ Enós. Li stot li Enose jaꞌ Set. Li stot li Sete jaꞌ Adán. Li stot li Adane jaꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Li Jesuse ventainbil yoꞌon yuꞌun li Chꞌul Espíritu li cꞌalal laj yicta li Juan li te ta ucꞌum Jordane. Iꞌiqꞌue batel ta taqui jamaltic yuꞌun li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chaꞌvinic cꞌacꞌal te oy ta taqui jamaltic. Muc bu xveꞌ pero muc xviꞌnaj. Tsꞌacal to ital viꞌnal iyaꞌi jech ital li banquilal pucuje, tal sloꞌlo Jesús ti yaloje. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jech iꞌalbat yuꞌun li banquilal pucuje: ―Mi joꞌot Snichꞌonot li Diose, albo li ton liꞌi ti acꞌo cꞌatajuc ta vaje ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Itacꞌav li Jesuse: ―Jech tsꞌibabil ta scꞌop Dios: “Mu ta vajuc noꞌox chijcuxiutic. Jaꞌ scꞌan ta jchꞌunbetic nojtoc li cꞌustic chijyalbutic li Diose”, xi tsꞌibabil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Li banquilal pucuje laj yicꞌ batel ta jun toyol vits li Jesuse. Ta sjuꞌel noꞌox iyacꞌbe yil spꞌejel balumil ta ora noꞌox schiꞌuc li cꞌu sba ta spasic mantal li ajvaliletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jech laj yal li banquilal pucuje: ―Joꞌot chacacꞌbe aventain scotol li cꞌusi chavile jech chaꞌichꞌe o ta mucꞌ yuꞌun scotol li crixchanoetique. Yuꞌun joꞌon acꞌbil jventain scotol, jech xuꞌ chcacꞌbe eꞌuc li buchꞌutic ta jcꞌan chcacꞌbee. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Scotol li cꞌusi chavile jaꞌ avuꞌun scotol mi chavichꞌun ta muqꞌue, mi chaquejan aba ta jtojole ―xi li banquilal pucuje. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Itacꞌav li Jesuse: ―Batan, Satanás, mu jchꞌun li cꞌusi chavalbune. Yuꞌun jech tsꞌibabil ta scꞌop Dios: “Jaꞌ noꞌox xavichꞌic ta mucꞌ stuc li Cajvaltic Diose. Jaꞌ noꞌox xapasic li cꞌusi ta scꞌane”, xi tsꞌibabil ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Li banquilal pucuje laj yicꞌ batel ta Jerusalén li Jesuse. Laj yicꞌ muyel ta sjol li mucꞌta chꞌulnae. Cꞌalal te xaꞌox vaꞌalic ta jol chꞌulnae, xi iyal li banquilal pucuje: ―Mi joꞌot Snichꞌonot li Diose, jip aba yalel liꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yuꞌun jech tsꞌibabil ta scꞌop li Diose: Dios chastacbe yalel yajꞌangeltac, jaꞌ chaschabi. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jaꞌ chastsac ba ta scꞌobic li chꞌul ángeletique yoꞌ jech mu xamaj aba ta ton, xi tsꞌibabil ―xꞌutat li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Itacꞌav li Jesuse: ―Pero jech tsꞌibabil ta scꞌop li Dios nojtoque: “Mu me xaqꞌuelbeic yoꞌon li Cajvaltic Diose”, xi tsꞌibabil. Mi ta jip jba yalele, yuꞌun ta jqꞌuelbe yoꞌon Dios mi ta melel chiscoltae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cꞌalal iyil li banquilal pucuj ti muc spas ta canal li Jesuse, ibat. Li banquilal pucuje ta smala sqꞌuel cꞌu ora ta spas ta canal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Li Jesuse isut batel ta Galilea. Scotol xuꞌ yuꞌun ta spas ta sventa stsatsal li Chꞌul Espíritue. Ipuc scꞌoplal ta spꞌejel Galilea balumil ti naca lec li cꞌustic la spase schiꞌuc li cꞌustic laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Te ichanubtasvan ta schꞌulnaic li schiꞌiltac ta israelale. Lec scꞌoplal yuꞌunic Jesús li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Li Jesuse isut batel ta jteclum Nazaret li yoꞌ bu ichꞌie. Cꞌalal jaꞌ o scꞌacꞌalil ta xcuxic li jꞌisraeletique, te ibat ta chꞌulna eꞌuc li Jesuse. Yuꞌun nopem onoꞌox te chcꞌotilan ta chꞌulna li cꞌalal jaꞌ o scꞌacꞌalil ta xcuxique. Li Jesuse ivaꞌi yuꞌun ta scꞌan ta xapta li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Iꞌacꞌbat li balbil jun li tsꞌibabil comel yuꞌun li Isaías li iyal scꞌop Dios ta voꞌonee. Cꞌalal la sjilchꞌun li balbil june, jaꞌ la sta li bu jech tsꞌibabile: ");
INSERT INTO tzoSA_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Jaꞌ sventainojun li Chꞌul Espíritu ti junic schiꞌuc li Diose. Tꞌujbilun yuꞌun Dios yoꞌ ta xcalbeic ti ta xcꞌuxubinatic yuꞌun Dios li meꞌonetique. Li buchꞌutic ta xat yoꞌonique, tal calbeic ti ta jventa joꞌon ta stsatsubtasbat yoꞌonique. Li buchꞌutic ochemic ta jtunel yuꞌun li mulile, tal calbeic ti ta jventa joꞌon chloqꞌuic ta jꞌechꞌele. Li buchꞌutic maꞌsatetic yaꞌel ta scoj li smulique, tal calbeic ti ta jventa joꞌon ta xjam li satique. Li buchꞌutic chopol ta xꞌileique, tal calbeic ti joꞌon tal jcoltae. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Listac talel yoꞌ ta xcalbeic ti ista xa scꞌacꞌalil ta xcoltaatic yuꞌun li Diose, xi ta xal li bu la sqꞌuel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Cꞌalal ilaj yoꞌon ta sqꞌuelel li scꞌop Dios li Jesuse, la sbal li june, laj yacꞌbe li buchꞌu ti jaꞌ yabtel ta schabie. Ichoti Jesús ta stojol scotolic. Scotol li buchꞌutic te oyic ta yut li chꞌulnae la sqꞌuelbeic sat li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Li Jesuse jech laj yal: ―Li avie icꞌot xa ta pasel li cꞌusi tsꞌibabil ta scꞌop Dios li avaꞌiique ―xi laj yalbe scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Scotolic lec iyalbeic scꞌoplal li Jesuse. Ichꞌay o yoꞌonic ta sventa ti toj lec li cꞌusi laj yale. Jech laj yalbe sbaic: ―Liꞌi xcojtaquintic. Jaꞌ snichꞌon li Josee ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Li Jesuse jech laj yal: ―Oy buchꞌutic jech ta xalic: “Mi melel ti joꞌot jpoxtavanejote, poxta aba atuc. Jaꞌ to ta jchꞌuncutic o ti ta melel joꞌot jpoxtavanejote”, xiic. Jech chacꞌan chavalbecun yaꞌel yuꞌun chacꞌanic ti acꞌo jpas liꞌ ta jlumaltic li cꞌusi avaꞌiic ti la jpas li te ta jteclum Capernaume. Yuꞌun jaꞌ to chachꞌunic o ti avalojique mi avilic icacꞌ ta ilel li jtsatsal juꞌele ti joꞌon acꞌbil cabtel yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jech laj yalbe nojtoc: ―Melel li cꞌusi chacalbeique, li butic chcꞌotic li buchꞌutic ta xalic li scꞌop Diose jaꞌ acꞌbilic ta venta. Pero ta yosilal stuquique mu xꞌaqꞌueic ta venta. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Melel li cꞌusi chacalbeique, cꞌalal liꞌ toꞌox oy ta balumil li Elías li iyal scꞌop Dios ta voꞌonee, oꞌlol schanibal jabil muc bu xacꞌ joꞌ liꞌ ta cosilaltique. Jech itsaqueic ta viꞌnal scotol li crixchanoetique. Li ta jchiꞌiltactic ta israelale oy ep meꞌanal antsetic. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero li Elíase muc bu te xtaque batel li yoꞌ bu oyic li meꞌanal antsetic li ta jlumaltique. Jaꞌ te itaque batel ta sna jun meꞌanal ants ti maꞌuc jchiꞌiltic ta israelale. Jaꞌ te nacal ta jteclum Sarepta, jaꞌ nopol xil sbaic schiꞌuc li jteclum Sidone. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jech nojtoc cꞌalal liꞌ toꞌox oy ta balumil li Eliséo li iyal scꞌop Dios ta voꞌonee, ep jchiꞌiltactic tsacbilic ta cꞌaꞌel chamel. Pero mu junuc icoltaatic. Jaꞌ noꞌox icoltaat li Naamán li liquem talel ta Siria balumile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cꞌalal laj yaꞌibeic scꞌop Jesús li jꞌisraeletic li te tsobolic ta chꞌulnae, chopol iyaꞌiic, iꞌilinic. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Laj yiqꞌuic loqꞌuel ta tiꞌ jteclum li Jesuse. Li jteclume te oy ta chꞌut vits. Laj yiqꞌuic batel ta jol vits li Jesuse yuꞌun tscꞌan ta sjipic yalel ta chꞌentic. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Li Jesuse te ijelav batel ta oꞌlol li crixchanoetique, ibat. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Li Jesuse te ibat ta jteclum Capernaum li te ta Galilea balumile. Cꞌalal ista scꞌacꞌalil ta xcuxic li jꞌisraeletique, li Jesuse te iꞌochic ta chꞌulna schiꞌuc li yajchanbalajeltaque. Te ichanubtasvan li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Li crixchanoetique toj chꞌayel noꞌox yoꞌonic ti cꞌu sba ichanubtasvan li Jesuse. Toj lec ichanubtasvan yuꞌun lec snaꞌ li cꞌusi ta scꞌan li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Te oy ta yut chꞌulna jun jꞌisraelal vinic ochem pucujetic ta yoꞌon. Tsots icꞌopoj li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Jech laj yal: ―¿Cꞌu chaꞌal tal aticꞌ aba ta jtojolcutic, joꞌot Jesusot ti liquemot talel ta Nazarete? ¿Mi yuꞌun tal atacuncutic batel li yoꞌ bu ta xquichꞌcutic o vocole? Xacojtaquin buchꞌuot. Joꞌot Snichꞌonot li Diose, joꞌot ti muꞌyuc amule ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Li Jesuse la spajes li pucujetic li te schꞌamunojbe ye li vinique, jech laj yalbe: ―Anchanic, locꞌanic batel ta yoꞌon li vinique ―xut. Iyal ta lum li vinic ta scoj li pucujetique, jech laj locꞌuc ta yoꞌon li vinic li pucujetique. Muc bu xyaij li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Li crixchanoetique toj chꞌayel noꞌox yoꞌonic scotolic, jech laj yalbe sbaic: ―¿Buchꞌu li liꞌ taleme? Oy stsatsal sjuꞌel. Xuꞌ yuꞌun ta sloqꞌues li pucujetique. Chꞌunbil smantal ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Cꞌalal jech la spas li Jesuse, ipuc scꞌoplal ta scotol li bicꞌtal jteclumetic li te nopol ta Capernaume. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Cꞌalal ilocꞌ ta chꞌulna li Jesuse, te ibat ta sna Simón Pedro. Te oy smeꞌniꞌ li Pedroe, ip ta cꞌocꞌ. Li Pedroe jech laj yalbe li Jesuse: ―Avocoluc coltabun li jmeꞌniꞌe ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Li Jesuse inopoj ba li yoꞌ bu puchꞌul li antse, laj yal ti acꞌo tupꞌuc li scꞌacꞌale. Itupꞌ ta ora li scꞌacꞌale. Ilic ta stem, lic macꞌlanvanuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cꞌalal yuꞌun xaꞌox chchꞌay cꞌacꞌale, laj yiqꞌuic talel ta stojol Jesús scotol li jchamelajeletique, cꞌusiuc noꞌox chamelal ip chaꞌiic. Li Jesuse laj yacꞌanbe scꞌob ta sbaic, icol o scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Oy ep buchꞌutic ilocꞌ pucujetic ta yoꞌonic. Li pucujetique tsots icꞌopojic li cꞌalal iloqꞌuique. Jech laj yalic: ―Joꞌot Snichꞌonot li Diose ―xiic. Li Jesuse laj yalbe li pucujetique ti acꞌo mu xcꞌopojique. Yuꞌun li pucujetique snaꞌojic ti jaꞌ tꞌujbil yuꞌun Dios ti ta xꞌoch ta ajvalilal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta yocꞌomal cꞌalal isacub osile, ilocꞌ batel li Jesuse, ibat li yoꞌ bu muꞌyuc crixchanoetique. Cꞌalal ilocꞌ batele, isaꞌe yuꞌun li crixchanoetique. Cꞌalal istaique, tscꞌan ta spajesic yoꞌ acꞌo jocꞌtsajuc li te ta slumalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Li Jesuse jech laj yalbe: ―Persa chba calbeic li jchiꞌiltactic ta yan jteclumetic ti ista xa scꞌacꞌalil ti chventainvan li Diose. Yuꞌun jaꞌ cabtel ti tacbilun talel liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Li Jesuse ibat ta schꞌulnaic li schiꞌiltac li te ta Galilea balumile, ba yal ti ista xa scꞌacꞌalil ti chventainvan li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Li Jesuse te icꞌot ta tiꞌnab ta Galilea balumil. Genesaret sbi li nabe. Li crixchanoetique toj ep la stsob sbaic talel li yoꞌ bu oy li Jesuse yuꞌun tscꞌan chaꞌiic li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Li Jesuse iyil te chib canava ta nopol tiꞌnab. Li yajvaltac li chib canavae jaꞌ jtsac‐choyetic. Loqꞌuemic batel ta schuqꞌuel snutiꞌic li stsacobil schoyique. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Li Jesuse iꞌoch ta jun canava, jaꞌ scanava li Simón Pedroe. Laj yalbe Pedro ti acꞌo xanubtas batel jutuc ta nab li scanavae. Li Jesuse te ichoti ta yut li canavae, la schanubtas scotol li crixchanoetic li te tsobolic ta tiꞌnabe. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cꞌalal ilaj yoꞌon ta schanubtasel li crixchanoetic li Jesuse, jech laj yalbe li Pedroe: ―Xanubtaso batel la acanavae, batic li yoꞌ bu lec nat li nabe. Jaꞌ te xatiqꞌuic ochel la atsacobchoyique yuꞌun jaꞌ te chataic ep li choye ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Itacꞌav li Pedroe: ―Jchanubtasvanej, sjunul acꞌubal ijsaꞌcutic li choye pero muc bu ijtacutic jcotuc. Pero ta sventa ti joꞌot chaval mantale, jech ta jticꞌcutic ochel nojtoc li jtsacobchoycutique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cꞌalal la sticꞌ ochel ta yut nab li stsacob schoyique, toj ep tajmec iꞌoch li choye. Ijat li stsacob schoyique yuꞌun toj ol li choye. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","La svelcꞌabtaic talel li yan schiꞌiltaquic li te tiqꞌuilic ta yan canavae yoꞌ acꞌo xtal coltaaticuc. Italic. Li chib canavae inoj ta choy. Jutuc xa mu imuquij ta nab li canavaetique yuꞌun toj ol li choye. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cꞌalal iyil Simón Pedro ti inoj ta choy schibal li canavae, la squejan sba ta stojol li Jesuse. Jech laj yalbe: ―Cajval, mu xachiꞌinun yuꞌun li joꞌone jpasmulilun ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ti jech laj yale, yuꞌun toj chꞌayel noꞌox yoꞌonic, toj labal iyaꞌiic schiꞌuc li schiꞌiltac ti toj ep istaic li choye. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Toj labal iyaꞌiic eꞌuc li Jacobo schiꞌuc Juan, jaꞌ li snichꞌnab li Zebedeoe, jaꞌ li schiꞌil sbaic ta tsac‐choy schiꞌuc li Simone. Li Jesuse jech laj yalbe li Pedroe: ―Mu me xaxiꞌ. Chajeltabe avabtel. Chajchanubtas li cꞌu sba chba asaꞌbun talel crixchanoetique ―xꞌutat yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Cꞌalal iloqꞌuic ta tiꞌnabe, iloqꞌuic ta canava. Laj yictaic o li yabtelique, la schiꞌinic batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ta yan o cꞌacꞌal cꞌalal te oy ta jun jteclum li Jesuse, ital jun jꞌisraelal vinic tsacbil ta cꞌaꞌel chamel. Cꞌalal iyil ti te oy li Jesuse, tal squejan sba ta stojol. Jech laj yalbe: ―Cajval, mi xacꞌan xacoltabun li jchamele, coltaun. Jnaꞌoj ti scotol xuꞌ avuꞌune ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Li Jesuse laj yacꞌbe scꞌob ta sba li jchamelajele, jech laj yalbe: ―Ta jcolta la achamele. Colan chaꞌa ―xut. Icol ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Li Jesuse jech laj yalbe nojtoc: ―Mu me buchꞌu xavalbe ti la jcoltaote. Jaꞌ noꞌox ba acꞌ aba ta ilel ta stojol li palee. Acꞌbo li smoton Dios jech chac cꞌu chaꞌal yaloj onoꞌox li Moisés ta voꞌonee, jaꞌ ta snaꞌic o li jchiꞌiltactic ti icol xa la achamele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jech ipuc o scꞌoplal li Jesuse. Toj ep crixchanoetic ta xtalulanic ta stojol li Jesuse yuꞌun tscꞌan ta xaꞌibeic scꞌop, schiꞌuc tscꞌanic coltael ta schamelic. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Li Jesuse oy la svocꞌ sba batel ta taqui jamaltic yuꞌun ba sta ta naꞌel Dios stuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ta yan o cꞌacꞌal cꞌalal jaꞌ o ta xchanubtasvan li Jesuse, te chotolic eꞌuc jayvoꞌ jfariseoetic schiꞌuc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jaꞌ te liquemic talel ta jujun jteclum ta Galilea balumil, schiꞌuc ta Judea balumil, schiꞌuc li ta jteclum Jerusalene. Li Jesuse iꞌacꞌbat stsatsal sjuꞌel yuꞌun Dios jech icol yuꞌun scotol li jchamelajeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Te italic ta stojol Jesús jayvoꞌ jꞌisraeletic, la sqꞌuechic talel jun schiꞌil ti muꞌyuc yipal jun yoc scꞌobe. Tscꞌan ch‐ochic ta yut na li yoꞌ bu oy li Jesuse yuꞌun chba spuchꞌanbeic ta stojol Jesús li jchamelajele. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero mu xuꞌ xꞌochic yuꞌun stsinoj sbaic tajmec ochel li crixchanoetique. Te imuyic ta jolna yuꞌun pachꞌal li jolnae. La sjomic jutuc li jolnae yuꞌun jaꞌ te la schechic yalel schiꞌuc spop li jchamelajele. Te icꞌot yuꞌunic li yoꞌ bu oy li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Li Jesuse iyil ti schꞌunojic ti oy sjuꞌele, jech laj yalbe li jchamelajele: ―Tata, pasbilot xa perton yuꞌun scotol amul ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li jfariseoetique jech la snop ta yoꞌonic: “Li vinic liꞌi ta spꞌis sba ta Dios. Muc buchꞌu xuꞌ chispasbutic perton yuꞌun jmultic, jaꞌ noꞌox Dios stuc”, xi ta yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Li Jesuse sqꞌueloj li cꞌusi la snop ta yoꞌonique, jech laj yalbe: ―¿Cꞌu chaꞌal ti muc bu lec li cꞌusi chanopique? ");
INSERT INTO tzoSA_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ta melel buchꞌuuc noꞌox xuꞌ ta xal: “Pasbilot xa perton yuꞌun amul”, ti xie, yuꞌun mu vocluc ta alel. Jech nojtoc mu vocluc ta alel: “Lican, xanavan”, ti xijchie. Pero jaꞌ scꞌan chaqꞌuelic mi melel ta xcꞌot ta pasel yuꞌun li buchꞌu jech ta xale. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Joꞌone laj cal xa ti pasbil xa perton yuꞌun li smul li vinique. Qꞌuelic me li cꞌusi ta jpas li avie yoꞌ jech chanaꞌic o ti joꞌon noꞌox ta jpasbe perton yuꞌun smulic li crixchanoetic liꞌ ta balumile, joꞌon li coꞌol crixchanoutique ―xi li Jesuse. Li Jesuse jech laj yalbe li jchamelajele: ―Joꞌon chacalbe, lican, ichꞌo batel la apope, batan ta ana ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ilic ta ora li jchamelajele. Te sqꞌuelojic scotolic ti laj yichꞌ batel li spope, ibat ta sna. Laj yal batel slequilal Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Cꞌalal iyilic li crixchanoetique, toj chꞌayel noꞌox yoꞌonic. Laj yalic coliyal Dios. Ta sventa ti toj chꞌayel yoꞌonique, ixiꞌic. Jech laj yalbe sbaic: ―Muc bu jech quilojtic jech chac cꞌu chaꞌal iquiltic li avie ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cꞌalal la spas jech li Jesuse, ilocꞌ batel. Te iyil jun jtsobpatan, Leví sbi. Te chotol ta schotleb li yoꞌ bu ta stoj spatanic li crixchanoetique. Li Jesuse jech laj yalbe: ―Laꞌ chiꞌinun batel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Li Levie laj yicta o li yabtele, la schiꞌin batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ta tsꞌacale laj yicꞌ ta veꞌel Jesús li Levie yuꞌun chichꞌ ta mucꞌ. Schiꞌuc laj yicꞌ ep schiꞌiltac nojtoc li coꞌol jtsobpatanetic schiꞌuque. Schiꞌuc oy buchꞌutic yan laj yicꞌan nojtoc. Te coꞌol la schiꞌinic ta chotlej ta mexa li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jfariseoetique, chopol iyilic li cꞌusi ta spas Jesús schiꞌuc li yajchanbalajeltaque. Jaꞌ yuꞌun laj yalbeic li yajchanbalajeltaque: ―¿Cꞌu chaꞌal chachiꞌinic ta veꞌel li jtsobpatanetic schiꞌuc li jpasmuliletique? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Itacꞌav li Jesuse: ―Li buchꞌutic muc bu ipique mu scꞌanic poxtael. Jaꞌ noꞌox ta scꞌanic poxtael li buchꞌutic ipique. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Li joꞌone maꞌuc tal jsaꞌ li buchꞌutic muꞌyuc smulic ti yalojique. Jaꞌ tal jsaꞌ li jpasmuliletique yoꞌ jech chictaic o li smulique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oy buchꞌutic jech la sjacꞌbeic li Jesuse: ―Li yajchanbalajeltac li Juane ep ta velta ta xicta yiximic yuꞌun ta staic ta naꞌel Dios. Jech ta spasic eꞌuc li yajchanbalajeltac li jfariseoetique. ¿Cꞌu chaꞌal mu jechuc ta spasic eꞌuc la avajchanbalajeltaque yuꞌun scotol cꞌacꞌal chveꞌic? ―xutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Li Jesuse jech laj yalbe: ―Cꞌalal yacal nupunele, te oy li jnupunel quereme, jaꞌ yuꞌun mu xuꞌ ta xicta yiximic li yutsꞌ yalaltac li jnupunel quereme yuꞌun te to schiꞌuquic. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jaꞌ noꞌox jechic eꞌuc li cajchanbalajeltaque, mu jechuc o smelol ti ta xicta yiximique, ti ta xat yoꞌonique, yuꞌun liꞌto jchiꞌuquique. Jaꞌ to mi icꞌot scꞌacꞌalil ti chismilic li buchꞌutic chiscontrainique, jaꞌ to xuꞌ ta xat yoꞌonic, xuꞌ ta xicta yiximic li cajchanbalajeltaque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Li Jesuse jech laj yalbe jun loꞌil: ―Li buchꞌu ta schꞌun li cꞌusi ta xcale, persa ta xicta li cꞌusi schꞌunoj toꞌox ti jech ta xcol o ti yaloje. Persa ta sloqꞌuel yoꞌon ta schꞌun li cꞌusi ta xcale yoꞌ jech ta xcol o. Jech chac cꞌu chaꞌal li buchꞌu ta xpacꞌomaje, maꞌuc yuꞌun ta stuchꞌ loqꞌuel jsetꞌuc yachꞌcꞌuꞌ yoꞌ ta spacꞌ o li scꞌaꞌcꞌuꞌe. Ti mi jech tspase, altic chixtalan li yachꞌcꞌuꞌe. Yuꞌun li achꞌ poqꞌue ta sjat más li poco cꞌuꞌile yuꞌun muc toꞌox bu mutsem. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jech nojtoc li achꞌ yaꞌlel tsꞌusub ti ta xa xpajube, muc buchꞌu ta schꞌol ta poco yav li pasbil ta nucule. Mi jech ta spasique, cꞌalal ta xvocan stuc li yaꞌlel tsꞌusube, ta xtꞌom li yave. Altic ta xmal scotol li yaꞌlel tsꞌusube. Li yave altic ta xchꞌay. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Li achꞌ yaꞌlel tsꞌusub li ta xa xpajube, jaꞌ scꞌan ti ta achꞌ yav ta xichꞌ chꞌolele. Jech lec ta xcom o schiꞌuc yav li yaꞌlel tsꞌusub li pajubem xae. ");
INSERT INTO tzoSA_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Li buchꞌu yuchꞌoj xa li poco yaꞌlel tsꞌusub li pajubem xae, mu scꞌan xuchꞌ li achꞌ yaꞌlel tsꞌusube. Jech ta xal: “Jaꞌ toj lec li poco yaꞌlel tsꞌusube”, xiic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ta scꞌacꞌalil ta xcuxic li jꞌisraeletique, te ijelavic ta be ta trigotic schiꞌuc li yajchanbalajeltac li Jesuse. Li yajchanbalajeltaque la scꞌasic jaychex trigo, la sjuꞌ scꞌuxic. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iꞌileic yuꞌun jayvoꞌ jfariseoetic, jech laj yalic: ―¿Cꞌu chaꞌal chapasic li cꞌusi mu xuꞌ jpastic li ta scꞌacꞌalil ta jcuxtique? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Itacꞌav li Jesuse: ―Aqꞌuelojic ta scꞌop Dios li cꞌusi la spas li David li cꞌalal iviꞌnajic schiꞌuc li schiꞌiltac ta xanbale. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Te icꞌotic ta chꞌulna. Li Davide la sveꞌ li pan li te oy ta mexa ta sventa smoton li Diose. Acꞌo mi yaloj Dios ti jaꞌ noꞌox xuꞌ ta sveꞌic li paleetique, pero la sveꞌic schiꞌuc li schiꞌiltac li Davide. Pero muc bu sta o smul ti jech la spase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jech laj yal nojtoc li Jesuse: ―Joꞌon li coꞌol crixchanoutique, joꞌon yajvalun li scꞌacꞌalil ti ta jcuxtique. Joꞌon chcal li cꞌustic xuꞌ ta pasele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta yan o cꞌacꞌal cꞌalal jaꞌ o scꞌacꞌalil ta xcuxic li jꞌisraeletique, li Jesuse iꞌoch ta schꞌulnaic, ichanubtasvan. Te oy jun vinic ti smochꞌoj sba sbicꞌtaltac sbatsꞌicꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te oyic eꞌuc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc jayvoꞌ jfariseoetic. Tal sqꞌuelic mi ta xcoltavan Jesús li ta scꞌacꞌalil ta xcuxique yuꞌun tscꞌan ta saꞌbeic smul. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Li Jesuse snaꞌoj li cꞌusi ta snop ta yoꞌonique, jech laj yalbe li vinic ti smochꞌoj sba sbicꞌtaltac sbatsꞌicꞌobe: ―Laꞌ vaꞌlan liꞌ ta oꞌlole ―xut. Li vinique ba vaꞌluc ta oꞌlol. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Li Jesuse jech laj yalbe li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac Dios schiꞌuc li jfariseoetique: ―Oy cꞌusi chajacꞌbeic. Li scꞌacꞌalil ta jcuxtique ¿cꞌusi yaloj Dios ti acꞌo jpastique? ¿Mi xuꞌ ta jpastic li cꞌusi leque, mi jaꞌ ta jpastic li cꞌusi chopole? ¿Mi chijcoltavan, mi chijmilvan? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Li Jesuse la sqꞌuelanbe satic li buchꞌutic te chotolique. Jech laj yalbe li jchamelajele: ―Tuqꞌuibtasano li sbicꞌtaltac acꞌobe ―xut. La stuqꞌuibtasan li sbicꞌtaltac sbatsꞌicꞌobe, icol ta ora li scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Li jchanubtasvanejetic schiꞌuc li jfariseoetique isoc sjolic ta ora. La snopbeic scꞌoplal Jesús ti cꞌu sba xuꞌ tsmilique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cꞌalal jech icꞌot ta pasele, jaꞌ o ba sta ta naꞌel Dios ta vits li Jesuse. Sjunul acꞌubal te ista ta naꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cꞌalal isacub osile, laj yicꞌ scotol li buchꞌutic la schiꞌin scotol cꞌacꞌale. La stꞌuj lajchavoꞌ yajchanbalajeltac yuꞌun jaꞌ ta sventainic comel ta yalel li scꞌope. Jaꞌ yajtacbalaltac. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","La stꞌuj Simón, jaꞌ Pedro laj yacꞌbe yan sbi. Schiꞌuc Andrés, jaꞌ yitsꞌin li Pedroe. Schiꞌuc Jacobo, schiꞌuc Juan, schiꞌuc Felipe, schiꞌuc Bartolomé. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Schiꞌuc Mateo, schiꞌuc Tomás, schiꞌuc otro jun Jacobo, jaꞌ snichꞌon Alfeo. Schiꞌuc Simón ti la schiꞌin toꞌox li jzeloteetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Schiꞌuc Judas, jaꞌ schiꞌil sbaic ta voqꞌuel schiꞌuc li Jacoboe. Schiꞌuc Judas Iscariote li buchꞌu tsꞌacal to iyacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cꞌalal iyal talel ta vits schiꞌuc li yajchanbalajeltac li Jesuse, schiꞌuc li buchꞌutic la schiꞌinic cꞌalal iꞌay ta vitse, te cꞌot staic ep crixchanoetic ta stenlejaltic. Te liquemic talel ta Judea balumil schiꞌuc ta jteclum Jerusalén, schiꞌuc ta chib jteclum Tiro schiꞌuc Sidón sbiic, te oy ta nopol tiꞌnab. Yuꞌun tal yaꞌibeic scꞌop li Jesuse schiꞌuc ta scꞌanic ti acꞌo coltaaticuc li ta schamelique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Italic eꞌuc li buchꞌutic ochem pucujetic ta yoꞌonique. Scotol icol yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Scotol li crixchanoetique tscꞌan ta spiquic li Jesuse yuꞌun iyilic ti ta stsatsal sjuꞌel noꞌox Jesús icolic scotol li jchamelajeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Li Jesuse la sqꞌuelanbe sat li yajchanbalajeltaque schiꞌuc li crixchanoetic li te tsobolique, jech laj yalbe: ―Joꞌoxuc ti mu cꞌusi xꞌayan avuꞌunique chavilic ti xamuybajic noꞌoxe yuꞌun jaꞌ chasventainoxuc li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Joꞌoxuc ti chaviꞌnajic li avie, chavilic ti xamuybajic noꞌoxe yuꞌun chaꞌacꞌbat aveꞌelic yuꞌun li Diose. ’Joꞌoxuc ti chaꞌoqꞌuic li avie, chavilic ti xamuybajic noꞌoxe yuꞌun jaꞌ chastsatsubtasboxuc avoꞌonic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Joꞌoxuc ti chopol chayiloxuc li crixchanoetique, ti chaspꞌajoxuque, ti chayutoxuque, ti chaslabanoxuque, jaꞌ ta jventa joꞌon li coꞌol crixchanoutique, pero chavilic ti xamuybajic noꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cꞌalal jech ta xcꞌot ta pasel ta atojolique, mu me xavat avoꞌonic. Muybajanic noꞌox yuꞌun toj lec li cꞌusi chcꞌot avichꞌic li te ta vinajele. Jech onoꞌox la spasic eꞌuc li smoltotic ta voꞌonee, ep laj yilbajinic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Yan li joꞌoxuc ti jcꞌulejoxuque, chavichꞌic vocol ta tsꞌacal. Yuꞌun oy avuꞌunic li cꞌustic chacꞌanic li avie, jaꞌ yuꞌun mu xa cꞌusi chanopic. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Joꞌoxuc ti noj achꞌutic li avie, chavichꞌic vocol ta tsꞌacal yuꞌun mu cꞌusi chaꞌacꞌbatic yuꞌun li Diose. ’Joꞌoxuc ti xamuybajic noꞌox li avie, chavichꞌic vocol yuꞌun chavat avoꞌonic chaꞌoqꞌuic ta tsꞌacal. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Joꞌoxuc ti lec chayiloxuc scotol li crixchanoetic li avie, chavichꞌic vocol ta tsꞌacal. Yuꞌun jaꞌ jechoxuc jech chac cꞌu chaꞌal li buchꞌutic la spꞌis sbaic ta yalel li scꞌop Dios ta voꞌonee ti lec iꞌileic yuꞌun scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Joꞌoxuc ti chavaꞌibecun jcꞌop li avie jech chacalbeic: Cꞌuxubino la avajcontraique. Mi chayiltaoxuque, acꞌbeic yil li slequil avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mi chopol chascꞌoponoxuque, lec me xacꞌoponic. Mi chayilbajinoxuque, cꞌoponbeic Dios yuꞌun mu snaꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mi chasmajbeic jot xocon asatique, acꞌo smajboxuc schaꞌjotol. Mi chaspojboxuc apuychijique, acꞌo yichꞌ. Acꞌo yichꞌ batel acꞌuꞌic nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mi chascꞌanboxuc li cꞌusi oy avuꞌunique, acꞌbeic. Mi chaspojboxuc li cꞌustic oy avuꞌunique, mu me xba acꞌanbeic sutel. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mi chacꞌan ti lec li cꞌusi chaspasbeic li crixchanoetique, jaꞌ scꞌan ti jaꞌ noꞌox jechoxuc eꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mi jaꞌ noꞌox oy ta avoꞌonic li buchꞌutic lec xavil aba achiꞌuquique, mu xvinaj o mi más lec la avoꞌonique. Yuꞌun jaꞌ noꞌox jechoxuc jech chac cꞌu chaꞌal li buchꞌutic chopol scuxleje. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mi jaꞌ noꞌox chacꞌuxubinic li buchꞌutic lec xavil aba achiꞌuquique, mu xvinaj o mi más lec la avoꞌonique. Yuꞌun jaꞌ noꞌox jechoxuc jech chac cꞌu chaꞌal li buchꞌutic chopol scuxleje. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mi jaꞌ noꞌox chavacꞌbe sqꞌuex ataqꞌuinic li buchꞌu snaꞌ sutesele, mu xvinaj o mi más lec la avoꞌonique. Yuꞌun jaꞌ noꞌox jechoxuc jech chac cꞌu chaꞌal li buchꞌutic chopol yoꞌone. Yuꞌun jaꞌ noꞌox chacꞌbe sqꞌuex staqꞌuinic li buchꞌu snaꞌ sutesele. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Li joꞌoxuque scꞌan chacꞌuxubinic li buchꞌu chascontrainoxuque. Scꞌan ti lec chavil scotol li crixchanoetique. Acꞌo ta qꞌuexel li cꞌusi ta scꞌanique acꞌo mi mu sutes. Jaꞌ más chataic o ti lequilal ta vinajele. Jaꞌ chavaqꞌuic o ta ilel ti joꞌoxuc snichꞌnaboxuc li Diose. Yuꞌun li Diose ta scꞌuxubin eꞌuc li buchꞌutic chopol yoꞌonique ti mu snaꞌ xalbeic coliyal Dios ti jech icꞌuxubinatique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jaꞌ lec cꞌuxubinvananic jech chac cꞌu chaꞌal ta xcꞌuxubinvan li Jtotic Dios ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Mu me chopluc xavil achiꞌilic yoꞌ jech mu xcꞌot avichꞌic ichꞌbeel acꞌopic yuꞌun li Diose. Mu me xasaꞌbeic smul achiꞌilic yoꞌ jech mu xaꞌalbat amulic eꞌuc yuꞌun li Diose. Pasbeic perton yoꞌ jech chaspasboxuc perton eꞌuc li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Acꞌbeic smoton achiꞌilic yoꞌ jech chayacꞌboxuc amotonic eꞌuc li Diose. Más to ep chaꞌacꞌbatic li joꞌoxuque. Jaꞌ jech chac cꞌu chaꞌal li buchꞌutic ti lec tsꞌacal ta xacꞌ li cꞌusi ta xaqꞌue, ti lec ta snojese, ti ta xtanij xa loqꞌuel ta stiꞌe, jaꞌ jech chavichꞌic eꞌuc li joꞌoxuque. Mi ep chavaqꞌuique, jaꞌ noꞌox jech ep chaꞌacꞌbatic eꞌuc. Mi jutuc noꞌox chavaqꞌuique, jaꞌ noꞌox jech jutuc noꞌox chayacꞌbeic eꞌuc li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Li Jesuse jech laj yal ta loꞌil: ―Li buchꞌu maꞌsate ¿mi xuꞌ ta xacꞌbe yil be li schiꞌil ta maꞌsatile? ¿Mi mu coꞌoluc ta stsꞌujic yalel ta lom chꞌen? ");
INSERT INTO tzoSA_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Li jchanjune muc bu coꞌolic schiꞌuc li yajchanubtasvaneje yuꞌun jaꞌ to tschan. Mi ischan xa scotol li cꞌu sba ichanubtasat yuꞌun li yajchanubtasvaneje, coꞌolic xa. Jaꞌ yuꞌun li joꞌoxuque scꞌan chatꞌujic lec li buchꞌu chaschanubtasoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Li joꞌoxuque acꞌo mi jutuc noꞌox ti cꞌusi chopol ta spas la achiꞌilique, pero jaꞌ te batem o asatic. Pero mu xavaꞌi abaic ti más to toj chopol li cꞌusi chapasic li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Jech chavalbe la achiꞌilique: “Mu me xapas jech”, xavutic. Pero ¿cꞌu sba chapꞌijubtasic la achiꞌilic mi joꞌoxuc más to toj chopol li cꞌustic chapasique? Apꞌisoj sbaic ti mu cꞌusi palta avuꞌunique. Jaꞌ scꞌan ti baꞌi chavictaic spasel li cꞌustic chopole, tsꞌacal to xuꞌ chapꞌijubtasic la achiꞌilique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Li teꞌ li bu lec onoꞌoxe, lec li sat ta xaqꞌue. Li teꞌ li bu chopol onoꞌoxe, jaꞌ noꞌox jech chopol li sat ta xaqꞌue. Mu xuꞌ ta scap sbaic li bu leque schiꞌuc li bu chopole. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ti cꞌu sba sat li teꞌe jaꞌ ta xquiltic o mi lec, mi chopol. Jech chac cꞌu chaꞌal muc bu chataic sat higo ta jtecꞌ chꞌix, schiꞌuc muc bu chataic sat tsꞌusub ta chꞌix, jaꞌ jechic li buchꞌutic spꞌisoj sbaic ti ta xalic li scꞌop Diose, mu cꞌusi lec chataic o yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Li buchꞌu lec yoꞌone lec li cꞌu sba ta xcꞌopoje, yuꞌun lec li cꞌusi snopoje. Li buchꞌu chopol yoꞌone chopol li cꞌu sba ta xcꞌopoje, yuꞌun chopol li cꞌusi snopoje. Yuꞌun li cꞌu sba chal ta avoꞌonique jaꞌ jech chlocꞌ ta aveic. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Li joꞌoxuque altic ti “Cajval, Cajval” xavuticune, yuꞌun mu xapasic li cꞌustic chacalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Li buchꞌu chiyaꞌibe li cꞌusi ta xcale, mi ta schꞌune, chacalbeic cꞌu sba. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jaꞌ jech chac cꞌu chaꞌal jun vinic li la svaꞌan sna ta ba tone. La sjom yalel nat li balumile jaꞌ to ti ista li tone. Jaꞌ te la sliquesbe muyel li yoc li nae. Cꞌalal ital tsots joꞌe, inoj tajmec li ucꞌume, imal loqꞌuel ta stiꞌ, icꞌot ta spat xocon li snae. Pero muc bu xjin li snae yuꞌun ta ba ton svaꞌanoj. ");
INSERT INTO tzoSA_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Li buchꞌu chiyaꞌibe li cꞌusi ta xcale, mi mu schꞌune, jaꞌ jech chac cꞌu chaꞌal jun vinic li la svaꞌan sna ti naca noj te juchul ta sba balumile. Cꞌalal ital tsots joꞌe, inoj tajmec li ucꞌume, imal loqꞌuel ta stiꞌ, icꞌot ta spat xocon li snae. Toj jinel noꞌox li snae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cꞌalal ilaj yoꞌon ta schanubtasel li crixchanoetic li te ta yoc vits li Jesuse, ibat ta jteclum Capernaum. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oy jun jyanlum vinic te nacal ta Capernaum, jaꞌ banquilal soltaro. Jaꞌ te liquem talel li ta mucꞌta jteclum Romae. Oy jun yajtunel toj lec cꞌux ta yoꞌon. Itsaque ta chamel li yajtunele, ta xaꞌox xcham. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cꞌalal iyaꞌibe scꞌoplal Jesús li banquilal soltaroe, la stac batel jayvoꞌ banquilaletic yuꞌun li jꞌisraeletic li te ta Capernaume, ba yalbeic Jesús mi xꞌabolaj chba coltabatuc li yajtunele. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Li banquilaletique ibatic li yoꞌ bu oy li Jesuse, jech cꞌot yalbeic: ―Abolajan cꞌuxubinbun li banquilal soltaroe. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yuꞌun cꞌuxutic ta yoꞌon jcotoltic, joꞌotic li jꞌisraelutique. Jaꞌ la stoj scotol li svaꞌanobil li jchꞌulnacutic li liꞌ ta jteclume ―xutic cꞌotel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Li Jesuse la schiꞌin batel li banquilaletic yuꞌunic li jꞌisraeletique. Cꞌalal jutuc xaꞌox scꞌan xcꞌotic ta sna li banquilal soltaroe, li banquilal soltaroe la stac talel jayvoꞌ li buchꞌutic lec scꞌopon sba schiꞌuque yuꞌun tal spajesic li Jesuse. Jech laj yalbeic: ―Tata, mu la xba avacꞌ avocol yuꞌun jech laj yalbuncutic talel li banquilal soltaroe: “Li joꞌone mu tsotsuc cabtel ti jaꞌ chischꞌunbe ta jmantal ti jaꞌ chtal ta jnae. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jaꞌ yuꞌun muc bu xꞌa jcꞌopon jtuc. Xuꞌ jaꞌ noꞌox acꞌo yal talel jpꞌeluc ti acꞌo coluc li cajtunele. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Li joꞌone ta mantal noj oyun ti ta jpas ta mantal li soltaroetique. Batan, mi xcut li june, ta xbat. Laꞌ liꞌi, mi xcut li yane, ta xtal. Paso jech, mi xcut li cajtunele, ta spas”, xijyutcutic talel ―xutic cꞌotel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cꞌalal iyaꞌi li Jesuse, xmuybaj o. Ijoypꞌij, jech laj yalbe li crixchanoetic li te tijilic talel ta spate: ―Ta melel muc to bu jech jtaoj junuc jchiꞌiltic ta israelal ti jech ta schꞌun jech chac cꞌu chaꞌal li banquilal soltaroe ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Li buchꞌutic itaqueic talel yuꞌun li banquilal soltaroe isutic batel. Cꞌalal icꞌotique, colem xaꞌox cꞌot staic li yajtunel li banquilal soltaroe. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Li Jesuse tsꞌacal to ibat schiꞌuc li yajchanbalajeltac ta jteclum Naín. Ep crixchanoetic ibatic nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cꞌalal nopolic xaꞌox batel ta tiꞌ jteclume, iyil Jesús ti oy buchꞌutic stelojic talel jun ánima yuꞌun chba smuquic. Jaꞌ squerem jun meꞌanal ants. Cꞌajomal jun li yole. Ep buchꞌutic schiꞌuc batel li antse, jaꞌic li buchꞌutic te nacalic ta jteclume. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cꞌalal iyil li ants li Cajvaltique, toj abol sba iyil, iyichꞌ ta cꞌux. Xi laj yalbe: ―Mu xaꞌocꞌ ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inopoj li Jesuse, la spicbe stenelteꞌal li ánimae. Li buchꞌutic stelojic batele ivaꞌiic. Li Jesuse jech laj yalbe li ánimae: ―Querem, joꞌon chacalbe, lican ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ichoti ta ora li quereme, lic loꞌilajuc. Li Jesuse jech laj yalbe li antse: ―Icꞌo batel la avole ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Scotol li buchꞌutic te xbatique toj labal iyaꞌiic. Laj yalbeic coliyal Dios. Oy jech laj yalic: ―Toj tsots yabtel yichꞌoj li jchiꞌiltique. Jaꞌ jun banquilal yuꞌunic li buchꞌutic ta xalic scꞌop Dios liꞌ talem ta jtojoltique ―xiic. Oy yan jech laj yalic: ―Jaꞌ tacbil talel yuꞌun Dios yoꞌ chiscoltautic, joꞌotic ti tꞌujbilutic onoꞌox yuꞌune ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ipuc batel scꞌoplal Jesús ta spꞌejel Judea balumil schiꞌuc ta yan o balumil ti stsꞌaquinoj sbaic schiꞌuc li Judea balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Li Juan li iyacꞌ ta ichꞌel joꞌe, iꞌalbat yuꞌun li yajchanbalajeltac li cꞌustic ta spas li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Cꞌalal iyaꞌi li Juane, laj yicꞌ talel chaꞌvoꞌ yajchanbalajeltac. Jech laj yalbe: ―Ba jacꞌbeic Jesús mi ta melel jaꞌ tꞌujbil yuꞌun Dios ti chisventainutic ti scꞌoplal chtale, mi ta to jmalatic yan ―xut batel. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cꞌalal icꞌotic li bu oy li Jesuse, jech laj yalbeic: ―La stacuncutic talel li Juan li iyacꞌ ta ichꞌel joꞌe. Chajacꞌbecutic mi joꞌot li buchꞌu tꞌujbil yuꞌun Dios ti scꞌoplal onoꞌox chtal sventainuncutique, mi ta to jmalacutic yan ―xutic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Li Jesuse jaꞌ o yacal ta scoltaanbe schamel ep jchamelajeletic li cꞌalal icꞌotique. Ta scolta li buchꞌutic chꞌiem chin ta sbecꞌtalique, ta sloqꞌuesbe pucujetic ta yoꞌonic li buchꞌutic ochem pucuj ta yoꞌonique, ta sjambe sat li buchꞌutic maꞌsatetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Itacꞌav li Jesuse: ―Ba albeic Juan scotol li cꞌustic avilic ti yacun spasele schiꞌuc li cꞌustic avaꞌiic ti laj cale. “Li maꞌsatetic toꞌoxe xilic xa osil. Li coxoetic toꞌoxe lec xa chanavic. Icolic xa li buchꞌutic tsacbilic toꞌox ta cꞌaꞌel chamele. Ijam xa schiquinic li buchꞌutic macal toꞌox schiquinique. Li buchꞌutic telelic xaꞌoxe ichaꞌcuxiic xa cuꞌun. Li meꞌonetique iꞌalbatic xa yaꞌiic ti ta xcꞌuxubinatic yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mu me xchibaj yoꞌon ta jtojol li Juane, acꞌo muybajuc noꞌox, xijyutcutic talel li Jesuse”, utic cꞌotel li Juane ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cꞌalal isutic batel li chaꞌvoꞌic ti itaqueic talel yuꞌun li Juane, li Jesuse lic yalbe li epal crixchanoetic li cꞌu sba scꞌoplal li Juane. Jech laj yal: ―Li buchꞌu a aqꞌuelic li te ta taqui jamaltique, xanaꞌic xa onoꞌox ti ta yav oy li cꞌu sba ichanubtasvane, ti maꞌuc jech chac cꞌu chaꞌal jtecꞌ aj ti chbat ta jujot ta iqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Avilic ti muꞌyuc lec scꞌuꞌe. Yuꞌun li buchꞌutic ti toj lec scꞌuꞌique, jaꞌ li buchꞌutic te oyic ta sna ajvaliletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cꞌalal a aqꞌuelique, xanaꞌic xa onoꞌox ti jaꞌ li buchꞌu laj yal li scꞌop Diose. Melel chacalbeic, li Juan li a aqꞌuelique, jaꞌ más banquilal yuꞌunic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Li Juane jaꞌ onoꞌox ti tsꞌibabil scꞌoplal ta scꞌop Dios ti baꞌi ta xtal cuꞌune. Jech tsꞌibabil: Baꞌi ta jtac batel li cajtacbalale. Jaꞌ ta xalbe crixchanoetic ti chabate yoꞌ jech chayichꞌic ta mucꞌ, xiyut li Jtote, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chacalbeic, ta scotol li crixchanoetique muc buchꞌu jech yichꞌoj tsots yabtel jech chac cꞌu chaꞌal yichꞌoj li Juan li chacꞌ ta ichꞌel joꞌe. Pero li buchꞌu ta xacꞌ sba ta scꞌob li Diose, acꞌo mi muc bu yichꞌoj tsots yabtel, jaꞌ más ta xꞌacꞌbat yil li cꞌu sba sjuꞌel li Diose. Li Juane jaꞌ jutuc noꞌox iyil. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Li buchꞌutic iyaꞌiic li cꞌusi laj yal li Juane schiꞌuc li jtsobpatanetic nojtoque, laj yichꞌic joꞌ yuꞌun li Juane. Jech laj yalic: “Ta melel lec li cꞌusi ta xal li Diose ti scꞌan ti acꞌo quictatic li cꞌustic chopol ta jpastique, ti acꞌo quichꞌtic joꞌe yoꞌ jech chispasbutic perton”, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yan li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li jfariseoetic ti muc bu acꞌbilic yichꞌic joꞌ yuꞌun li Juane, muc bu xaqꞌuic ta venta ti jech ta scꞌan li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’Chacalbeic li cꞌu sba atalelic li liꞌ oyoxuc ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jaꞌ jechoxuc jech chac cꞌu chaꞌal li unetic ti te chotolic ta xtajinic ta chꞌivite, jech chalanbeic li schiꞌilique: “La jupancutic amay sventa nupunel pero muc bu xaꞌacꞌotajic. Cꞌalal xijuetcutic ta oqꞌuel ta scoj ti oy buchꞌu icham cuꞌuncutique, muc bu xaꞌoqꞌuic nojtoc. Mu cꞌusi xacꞌanic”, xut li schiꞌiltac ta tajimole. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yuꞌun cꞌalal ital li Juan li iyacꞌ ta ichꞌel joꞌe, muc bu xaschiꞌinic ta veꞌel. Jaꞌ jech sba la avalic: “Ochem pucuj ta yoꞌon”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Cꞌalal lital, joꞌon li coꞌol crixchanoutique, la jchiꞌinoxuc ta veꞌel. Pero jaꞌ jech sba la avalic nojtoc: “Qꞌuelavil toj echꞌem xveꞌ, toj echꞌem xuchꞌ yaꞌlel tsꞌusub. Lec xil sbaic nojtoc schiꞌuc li buchꞌutic chopol cꞌustic tspasic jech chac cꞌu chaꞌal li jtsobpatanetique schiꞌuc li yan jpasmuliletique”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ti acꞌbiluc apꞌijilic yuꞌun li Diose, la avichꞌicuncutic ta mucꞌ schiꞌuc li Juan ti jechuque. Jaꞌ xanaꞌic o ti acꞌbil jpꞌijilcutic yuꞌun Dios ti la jpascutic li cꞌustic la jpascutique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Li Jesuse iꞌiqꞌue ta veꞌel yuꞌun jun vinic li ochem ta fariseoale. Li Jesuse ibat ta sna li vinique, ba veꞌuc. Li schotlebique jech chac cꞌu chaꞌal tem. Jaꞌ te ta spatan sbaic li cꞌalal ta xveꞌic ta mexae. Li Jesuse te ba spatan sba. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jaꞌ o te yac ta veꞌel ta mexa li Jesuse ital jun jmulivajel ants, yuꞌun iyaꞌi ti te ta xveꞌ ta sna li jfariseo li Jesuse. Yichꞌoj talel slimeta ti noj ta muil vomole. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Li antse te ivaꞌi ta nopol yoc Jesús. Lic yoqꞌuita sba. La spocbe yoc Jesús ta yaꞌlel sat. Cꞌalal la spoque, la scusbe ta stsotsil sjol. La stsꞌutsꞌunbe yoc. La smalbe ta yoc nojtoc li sbel li limetae yuꞌun ta xichꞌ ta mucꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Cꞌalal iyil li jfariseoe, jaꞌ li buchꞌu laj yicꞌ ta veꞌel li Jesuse, jech iyal ta yoꞌon: “Ti jaꞌuc li buchꞌu ta xal scꞌop Dios li vinic liꞌi, snaꞌ ti jaꞌ jmulivajel li ants ti jechuque”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Li Jesuse jech laj yalbe li jfariseoe: ―Simón, oy cꞌusi chacalbe ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Li Jesuse jech laj yal: ―Oy jun vinic iqꞌuexbat staqꞌuin yuꞌun chaꞌvoꞌ viniquetic. Li june joꞌob ciento la sqꞌuex. Li june lajuneb yoxvinic (50) la sqꞌuex. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero mu sut yuꞌunic li sqꞌuexique, jaꞌ yuꞌun li yajval taqꞌuine la schꞌay ta yoꞌon li staqꞌuine, la schꞌaybe yilic schaꞌvaꞌalic. Li joꞌote ¿cꞌusi chanop? Li chaꞌvoꞌ vinic ti ichꞌaybat li yilique, ¿mi coꞌol cꞌux ta yoꞌonic li yajval taqꞌuine, mi oy buchꞌu ti más cꞌux ta yoꞌone? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Itacꞌav li Simone: ―Jaꞌ nan más cꞌux ta yoꞌon li buchꞌu más ep yil ti ichꞌaybate ―xi. Jech iꞌalbat yuꞌun li Jesuse: ―Jaꞌ melel li cꞌusi chavale ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Li Jesuse la sqꞌuelbe sat li antse, jech laj yalbe li Simone: ―Qꞌuelavil li ants liꞌi. Cꞌalal liꞌoch ta anae, muc buchꞌu la spocbun coc. Li ants liꞌi lispocbe coc ta yaꞌlel sat. Liscusbe ta stsotsil sjol nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Li joꞌote muc bu xatsꞌutsꞌunun li cꞌalal lijule. Li ants liꞌi jul stsꞌutsꞌunbun coc li cꞌalal ijule. Chavil ti yacal to chispasbune. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Li joꞌote muc bu xamalbun asete ta jol. Li ants liꞌi lismalbe muil vomol ta coc. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chacalbe, acꞌo mi ep smul li antse, li avie pasbil xa perton yuꞌun smul yuꞌun toj cꞌuxun ta yoꞌon. Li buchꞌu ta snop ti muc bu ep smul la jpasbe pertone, jaꞌ jutuc noꞌox cꞌuxun ta yoꞌon ―xꞌutat yuꞌun li Jesús li Simone. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Li Jesuse jech laj yalbe li antse: ―Pasbilot xa perton yuꞌun scotol amul ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Li buchꞌutic li te coꞌol oyic ta mexa schiꞌuc li Jesuse, jech laj yalbe sbaic: ―¿Bu ilic talel li vinic ti cꞌalal ta smul crixchanoetic xuꞌ ta spasbe perton ti yaloje? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Li Jesuse jech laj yalbe li antse: ―Lapasbat xa perton yuꞌun amul yuꞌun ta sloqꞌuel avoꞌon avichꞌun ta mucꞌ. Jech junuc xa avoꞌon batan ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsꞌacal to ixanav batel ta scotol jteclumetic schiꞌuc coloniaetic li Jesuse. Laj yal batel li lequil achꞌ cꞌope, jaꞌ ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose. Te schiꞌuc batel li lajchavoꞌ yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Oy jayvoꞌ antsetic nojtoc la schiꞌinic li Jesuse, jaꞌ li iloqꞌuesbat pucuj ta yoꞌonic yuꞌun li Jesuse schiꞌuc li icoltaatic ta schamelique. Te schiꞌuquic jun ants, María sbi, jaꞌ li te liquem talel ta jteclum Magdalae. Jaꞌ li iloqꞌuesbat jucub pucuj ta yoꞌon yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te oy eꞌuc li Juanae, jaꞌ yajnil jun vinic Chuza sbi. Li Chuzae jaꞌ yichꞌojbe ta venta sna li ajvalil Herodese. Te oy eꞌuc li Susanae schiꞌuc oy ep yan antsetic li la smacꞌlanic Jesús schiꞌuc li yajchanbalajeltaque. Pero stuquic la sloqꞌuesic li veꞌlil li antsetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cꞌalal la stsob sbaic ta stojol Jesús ep tajmec crixchanoetic li liquemic talel ta jujun jteclume, li Jesuse oy cꞌusi laj yal ta loꞌil. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Oy jun vinic ilocꞌ batel ta vajtrigo. Cꞌalal la svaj li strigoe, oy jaypꞌej icꞌot ta be. Te la spechꞌulanic ta teqꞌuel li crixchanoetique. Ital mutetic, la stam sbicꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oy jaypꞌej icꞌot ta tontic. Cꞌalal ichꞌi jutuque, itaquij ta ora yuꞌun muꞌyuc lec slumal. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oy jaypꞌej icꞌot ta yolon chꞌixtic. Cꞌalal ichꞌi li chꞌixe, inetꞌe comel, jaꞌ icꞌoxib o. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oy jaypꞌej icꞌot ta lequil balumil. Lec ichꞌi, lec isatin. Laj yacꞌ joꞌvinic (100) ta pꞌej li jupꞌej becꞌ trigoe ―xi li Jesuse. Cꞌalal laj yal jech li Jesuse, tsots lic cꞌopojuc. Jech laj yal: ―Li joꞌoxuc ti avaꞌiic li cꞌusi laj cale, nopbeic lec smelol ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Li Jesuse ijacꞌbat yuꞌun li yajchanbalajeltaque: ―¿Cꞌusi smelol li loꞌil la avalbuncutique? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jech itacꞌav li Jesuse: ―Li joꞌoxuque acꞌbiloxuc anaꞌic li cꞌu sba ta sventainan crixchanoetic li Diose, pero li yanetique ta loꞌil noꞌox chcalbeic. Yuꞌun altic noꞌox ti iyilic xa ti scotol xuꞌ cuꞌune, yuꞌun muc xacꞌ ta yoꞌonic. Altic ti iyaꞌiic xa li cꞌusi laj cale, muc xaꞌibeic smelol yuꞌun mu onoꞌox scꞌan xaꞌiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Aꞌibeic me smelol li loꞌil li laj calboxuque. Li sat trigoe jaꞌ senyail li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Li becꞌ trigo li icꞌot ta bee, jaꞌ senyail li buchꞌutic li cꞌalal ta xaꞌiic li scꞌop Diose, mu xaqꞌuic ta venta. Ta xtal ta ora li pucuje, chtal chꞌaybatuc ta sjolic ta ora li scꞌop Dios li iyaꞌiique yoꞌ jech mu schꞌunic, jech mu xcolic o. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Li becꞌ trigo li icꞌot ta tontique, jaꞌ senyail li buchꞌutic li cꞌalal ta xaꞌiic li scꞌop Diose, ta ora noꞌox ta schꞌunic, xmuybajic noꞌox. Pero mu ta sloqꞌueluc yoꞌonic la schꞌunic jech muꞌyuc stsatsal yoꞌonic o. Cꞌalal chichꞌic vocol cꞌalal schꞌunojique, ta xchibaj yoꞌonic ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Li becꞌ trigo li icꞌot ta yolon chꞌixtique, jaꞌ senyail li buchꞌutic jaꞌ noꞌox batem ta yoꞌonic li cꞌustic oy liꞌ ta balumile. Jaꞌ te loꞌlobilic o yuꞌun li cꞌustic ta scꞌanique. Te netꞌbil icom o yaꞌel li scꞌop Dios li laj yaꞌiique, jech muc schꞌunic o. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Li becꞌ trigo li icꞌot ta lequil balumile, ti iyacꞌ joꞌvinic ta pꞌej sbeqꞌue, jaꞌ senyail li buchꞌutic ta xacꞌ ta yoꞌonic li scꞌop Diose. Ta satin ta yoꞌonic yaꞌel li scꞌop Diose. Acꞌo mi ta xichꞌic vocol, mu xchibaj o yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Mi ta jtsan jcantiltique, muc bu ta jnujmaquitic, mu jmuctic ta yolon tem nojtoc. Ta jcuxantic ta scuxanobil jaꞌ chilic o lec osil scotol li buchꞌutic ta xꞌochic talel ta yut jnatique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jaꞌ noꞌox jech persa onoꞌox ta xvinaj li cꞌustic laj calboxuque. Jaꞌ avabtelic ti jamal chavalic batele. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Jaꞌ yuꞌun aꞌibeic lec smelol li cꞌustic chacalbeique. Li buchꞌutic jutuc to schꞌunojique, más to chcoltaatic yuꞌun Dios ti acꞌo schꞌunic leque, yuꞌun chacꞌ ta yoꞌonic. Li buchꞌutic mu scꞌan schꞌunique, li cꞌu yepal snaꞌique ta xpojbatic ta jꞌechꞌel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Te icꞌotic li smeꞌ li Jesuse schiꞌuc li yitsꞌinab li Jesuse. Pero muc bu staic ta cꞌoponel li Jesuse yuꞌun te tsinil epal crixchano ta yut na, jaꞌ yuꞌun mu xuꞌ xꞌochic li yoꞌ bu oy li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oy buchꞌu tal albatuc ta ora li Jesuse: ―Te oyic ta amacꞌ ameꞌ schiꞌuc la avitsꞌinabe yuꞌun chac scꞌoponicot ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Itacꞌav li Jesuse: ―Melel jaꞌ jmeꞌ, jaꞌ quitsꞌinab li te oyique. Pero li buchꞌutic chaꞌiic schiꞌuc ti ta spasic li cꞌusi ta xal li Diose, jaꞌ coꞌol schiꞌuc jmeꞌ yaꞌel. Jaꞌ coꞌol schiꞌuc jchiꞌiltac ta voqꞌuel yaꞌel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ta yan o cꞌacꞌal iꞌochic ta canava schiꞌuc li yajchanbalajeltac li Jesuse. Jech laj yalbe: ―Batic ta jot nab ―xut. Ibatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cꞌalal jaꞌ o chanav batel ta ba nab li canavae, ivay li Jesuse. Jaꞌ o ital tsots icꞌ. Tsots la syuqꞌuilan li nabe. Iꞌoch ep joꞌ ta yut li canavae, yuꞌun xaꞌox ta xmuquij yalel ta yut nab. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Li Jesuse itije yuꞌun li yajchanbalajeltaque. Jech laj yalbeic: ―Jchanubtasvanej, ta xa xijmuquij yalel ta yut nab ―xiic. Ilic li Jesuse, la spajes li iqꞌue schiꞌuc li nabe, jliquel ichꞌab ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Muc to bu achꞌunojic lec ―xut. Toj chꞌayel noꞌox yoꞌonic, ixiꞌic. Jech laj yalbe sbaic: ―¿Cꞌu nan chaꞌal li vinic liꞌi? Yuꞌun cꞌalal ta icꞌ, cꞌalal ta nab chpaj yuꞌun ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Icꞌotic ta jot nab ta yosilalic li jgadáraetique, te iloqꞌuic ta canava schiꞌuc yajchanbalajeltac li Jesuse. Li Galileae ta jot nab icom yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cꞌalal lic xanavuc batel li Jesuse, tal nupatuc ta be ta ora yuꞌun jun jgadárail vinic. Voꞌone xaꞌox ochem pucujetic ta yoꞌon. Muꞌyuc xa scꞌuꞌ, muꞌyuc xa sna. Jaꞌ xa snainoj li jombil chꞌenetic li bu chmuqueic li ánimaetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Li vinique, cꞌalal iyil li Jesuse, tal spatan sba ta balumil ta stojol. Tsots icꞌopojic li pucujetic li ochem ta yoꞌone, jech laj yalic: ―Jesús, joꞌot Snichꞌonot Dios ta vinajel, ¿cꞌu chaꞌal tal aticꞌ aba ta jtojolcutic? Avocoluc mu me xavacꞌbuncutic quichꞌcutic vocol ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ti jech iyalic li pucujetique, yuꞌun albatemic xa yuꞌun Jesús ti acꞌo loqꞌuicuc ta yoꞌon li vinique. Yuꞌun ep xa ta velta jech laj yilbajinic li vinic li pucujetique. Li crixchanoetique la schucbeic ta carena taqꞌuin li yoc scꞌobe yoꞌ jech mu xmajvan o, pero ta xtuchꞌ yuꞌun. Ta xꞌiqꞌue batel ta taqui jamaltic yuꞌun li pucujetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Li Jesuse jech la sjacꞌbe li vinique: ―¿Cꞌusi abi? ―xut. Itacꞌav: ―Legionuncutic, yuꞌun ep ta mil liꞌ ochemuncutique ―xiic li pucujetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Li pucujetique ta sloqꞌuel yoꞌonic laj yalbeic Jesús ti mu me xtaqueic sutel ta xab li bu onoꞌox oyique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oy ep chitometic te ta xveꞌic ta chꞌut vits. Li pucujetique laj yalbeic Jesús ti jaꞌ te acꞌo ba ochicuc li ta chitometique. Li Jesuse laj yal ti acꞌo baticuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Li pucujetique iloqꞌuic batel ta yoꞌon li vinique, te ba ochicuc li ta chitometique. Li chitometique iloqꞌuic ta anil scotol, iyalic ta yalebaltic. Itsꞌujic ochel ta nab, te ijicꞌav scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Li jchabiejchitometique, cꞌalal iyilic li cꞌusi ispas li chitometique, ixiꞌic. Ibatic ta anil ta jteclum schiꞌuc ibatic ta coloniaetic, ba yalic ti icham scotol li chitometique schiꞌuc ti icol xa ta schamel li vinic li ochem toꞌox pucujetic ta yoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Li jgadárail crixchanoetique tal sqꞌuelic ta ora li cꞌusi icꞌot ta pasele. Cꞌalal icꞌotic li yoꞌ bu oy li Jesuse, te istaic li schiꞌilique, jaꞌ li ilocꞌ ep pucujetic ta yoꞌone. Te xa chotol ta nopol yoc li Jesuse, slapoj xa scꞌuꞌ, meltsajem xa, tuqꞌuibem xa. Pero li crixchanoetique ixiꞌic o. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Li buchꞌutic iyilic li cꞌu sba icol li vinic ti ochem toꞌox pucujetic ta yoꞌone, laj yalbeic li buchꞌutic te icꞌotique. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Scotol li jgadárail crixchanoetique laj yalbeic Jesús ti acꞌo locꞌuc ba te ta yosilalique, yuꞌun ixiꞌic tajmec. Jaꞌ yuꞌun iꞌoch ta canava schiꞌuc li yajchanbalajeltac li Jesuse, isutic batel ta jot nab. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Li vinic li ilocꞌ ep pucujetic ta yoꞌone laj yalbe li Jesuse: ―Chajchiꞌin batel ―xi. Li Jesuse laj yalbe ti acꞌo comuque. Jech laj yalbe: ");
INSERT INTO tzoSA_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Batan ta ana, ba albo achiꞌiltac ti laj xa scoltaot li Diose ―xꞌutat yuꞌun li Jesuse. Isut batel li vinique, ba yal ta scotol slumal ti icoltaat yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cꞌalal isut batel ta jot nab schiꞌuc li yajchanbalajeltac li Jesuse, oy ep jꞌisraeletic te ta smalaic ta tiꞌnab. Xmuybajic xa scotolic li cꞌalal icꞌot li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Te ital ta stojol Jesús jun vinic, Jairo sbi. Jaꞌ jmeltsanejcꞌop li ta schꞌulnaique. La spatan sba ta balumil ta stojol li Jesuse. Laj yalbe ti acꞌo batuc ta snae. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yuꞌun ta xcham xa li stseube. Cꞌajomal jun li snichꞌone, lajchaeb to jabil yichꞌoj. Li Jesuse ibat schiꞌuc li yajchanbalajeltaque. Cꞌalal yacal ta xanbal batele, ep crixchanoetic ibatic eꞌuc. Snetꞌnetꞌ sbaic batel. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te schiꞌuquic batel jun ants oy xa slajchaebal jabil ti mu xmac li schamele. Ilaj yoꞌon ta poxtael ta jpoxtavanejetic. Ilaj scotol li cꞌustic oy yuꞌune pero muc bu xcol o. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Li antse inopoj batel ta spat li Jesuse, la spicbe stiꞌ spuychij, jaꞌ icol o ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Li Jesuse jech laj yal: ―¿Buchꞌu lispicbe jpuychij? ―xi. Itacꞌavic scotolic: ―Mu jnaꞌ, muc bu la jpic apuychij ―xiic scotolic. Li Pedroe jech laj yal schiꞌuc laj yalic nojtoc li schiꞌiltaque: ―Jchanubtasvanej, toj snetꞌnetꞌ sbaic talel li crixchanoetic chavile. Ta xnetꞌvanic talel ta jujot. ¿Cꞌu chaꞌal “buchꞌu lispicbe jpuychij” xachi? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Li Jesuse jech laj yal: ―Oy buchꞌu lispicbe jpuychij yuꞌun icaꞌi ti oy buchꞌu icol ta juꞌele ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Li antse, cꞌalal iyil ti snaꞌoj Jesús li cꞌusi la spase, xtꞌeltꞌun xa ta xiꞌel tal spatan sba ta balumil ta stojol li Jesuse. Jamal laj yalbe ti cꞌu chaꞌal la spicbe li spuychije. Iyaꞌiic scotol li crixchanoetic ti jech laj yal li antse: ―Cꞌalal jech la jpase, licol o ta ora ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Li Jesuse jech laj yalbe: ―Jnichꞌon, yuꞌun la achꞌun ti oy juꞌele, jaꞌ yuꞌun lacol. Junuc avoꞌon batan ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cꞌalal jaꞌ o yacal ta loꞌil li Jesuse, ital jun vinic. Jaꞌ te ilic talel ta sna li Jairoe. Jech tal albatuc li Jairoe: ―Icham xa la atseube. Mu xa xavacꞌbe svocol li jchanubtasvaneje ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Cꞌalal iyaꞌi li Jesuse, laj yalbe li Jairoe: ―Mu xavat avoꞌon. Jaꞌ noꞌox chꞌuno ti xuꞌ cuꞌun ta jcolta la atseube ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cꞌalal icꞌot ta sna Jairo li Jesuse, mu scꞌan ti ep buchꞌu ta schiꞌin ochele. Laj yal ti jaꞌ noꞌox ta xicꞌ ochel li Pedroe, schiꞌuc Jacobo, schiꞌuc Juan, schiꞌuc stot smeꞌ li tseube. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Oy ep buchꞌutic te xꞌavetic ta oqꞌuel ta amacꞌ. Li Jesuse jech laj yalbe: ―Mu xaꞌoqꞌuic. Muc bu chamem li tseube, yuꞌun noꞌox chvay ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Cꞌalal jech iyaꞌiic li buchꞌutic te oyique, la stseꞌinic li Jesuse yuꞌun snaꞌic ti chamem li tseube. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Li Jesuse iꞌoch ta yut na, la stsacbe scꞌob li ánima tseube, tsots la scꞌopon, jech laj yalbe: ―Tseub, lican ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ichaꞌcuxi ta ora, itots li tseube. Li Jesuse laj yal mantal ti acꞌo yacꞌbeic sveꞌele. ");
INSERT INTO tzoSA_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Li stot smeꞌ li tseube toj chꞌayel o yoꞌonic. Li Jesuse laj yalbe li stot smeꞌ li tseube ti mu me buchꞌu xalbeic batel ti la schaꞌcuxesbe li stseubique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Li Jesuse la stsob li lajchavoꞌ yajchanbalajeltaque. Laj yacꞌanbe stsatsal sjuꞌelic ti ta sloqꞌuesanbeic pucujetic ta yoꞌonic li schiꞌiltaquique, schiꞌuc ta scoltaanic ta schamelic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","La stac batel yoꞌ chba yalbeic schiꞌiltaquic ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose, schiꞌuc acꞌo scoltaanic li buchꞌutic tsacbilic ta chamele. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jech laj yalbe: ―Mu me xavichꞌic batel li cꞌustic chtun avuꞌunic ta sventa abeique. Mu me xavichꞌic batel anamteꞌic, schiꞌuc anutiꞌic, schiꞌuc aveꞌelic, schiꞌuc ataqꞌuinic. Mu me xavichꞌic batel chaꞌlic acꞌuꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Li bu junucal na chaꞌotesatique, te me oyanic o jaꞌ to mi laloqꞌuic ta slumalic teye. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Li bu junucal jteclum ti mu xascꞌanoxuque locꞌanic batel. Cꞌalal chaloqꞌuic batele, lilinic comel spucucal la avoquique. Jaꞌ senyail ti jaꞌ xa icom ta sba stuquic ti muc bu xichꞌic ta mucꞌ li jcꞌop li la avalique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iloqꞌuic batel li yajchanbalajeltac li Jesuse. Iꞌechꞌic ba ta jujun colonia. Laj yalanbeic li schiꞌiltaquique ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose. Schiꞌuc la scoltaanic li buchꞌutic tsacbilic ta chamele. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Li ajvalil ta Galilea balumile, jaꞌ li Herodese, iyaꞌi li cꞌustic tspas li Jesuse. Iyal yoꞌon yuꞌun oy buchꞌu iyalic ti jaꞌ ichaꞌcuxi li Juan li iyacꞌ ta ichꞌel joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oy yan iyalic ti jaꞌ li Elías ti iyal scꞌop Dios ta voꞌone ti scꞌoplal onoꞌox chtal nojtoque. Oy yan iyalic ti jaꞌ ichaꞌcuxi junuc li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Li Herodese jech laj yal: ―Joꞌon laj cacꞌ ta tuchꞌbeel sjol li Juane. ¿Buchꞌu nan taj nojtoc ti ta xcaꞌibe scꞌoplal ti ep li cꞌustic lec ta spase? ―xi. Jaꞌ yuꞌun chac sqꞌuelbe sat yaꞌi li Herodese. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cꞌalal isutic batel ta stojol Jesús li yajchanbalajeltaque, cꞌot yalbeic scotol li cꞌustic la spasique. Li Jesuse la svocꞌ sba batel ta taqui jamaltic schiꞌuc li yajchanbalajeltaque. Te ibatic ta nopol jteclum Betsáida. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Cꞌalal iyaꞌiic li crixchanoetic li bu ibat li Jesuse, ba saꞌic. Li Jesuse lec iyaꞌi li cꞌalal icꞌotic li crixchanoetique. Laj yalbe yaꞌiic ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose. La scoltaan nojtoc li jchamelajeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cꞌalal mal xaꞌox cꞌacꞌale, li lajchavoꞌique jech laj yalbeic li Jesuse: ―Jaꞌ lec tacano me batel li crixchanoetique, acꞌo baticuc ta coloniaetic li liꞌ noꞌox nopole. Acꞌo ba schꞌamunic na, acꞌo ba sman sveꞌelic yuꞌun taqui jamaltic liꞌi, mu cꞌusi xꞌayan ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Itacꞌav li Jesuse: ―Macꞌlanic li joꞌoxuque ―xut. Itacꞌavic li yajchanbalajeltaque: ―Mu cꞌusi oy cuꞌuncutic. Jaꞌ noꞌox joꞌpꞌej pan schiꞌuc chaꞌcot choy liꞌ quichꞌojcutique. ¿Mi chba jmanbecutic talel li sveꞌelique? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Li cꞌu yepal viniquetic te stsoboj sbaique oy nan joꞌmiluc. Jaꞌ slecoj li antsetique schiꞌuc li unetique, muc bu atbil. Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Albeic li crixchanoetique ti acꞌo stsob sbaic ta lajlajuneb yoxvinic (50) jutsobe, acꞌo chotlicuc ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Laj yalic mantal li yajchanbalajeltaque. Lic stsob sbaic ta lajlajuneb yoxvinic li crixchanoetique, ichotiic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Li Jesuse la stsac li joꞌpꞌej pane schiꞌuc li chaꞌcot choye. La sqꞌuel muyel ta vinajel, laj yalbe coliyal Dios. La xutilan li pane schiꞌuc li choye, laj yacꞌbe li yajchanbalajeltaque. Li yajchanbalajeltaque la spucbeic li epal crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iveꞌ scotolic, inojic o lec. La stsobic li scomenal li pane schiꞌuc li scomenal li choye, inoj lajchamoch. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ta yan o cꞌacꞌal la svocꞌ sba loqꞌuel li ta crixchanoetic li Jesús schiꞌuc li yajchanbalajeltaque yuꞌun ba sta ta naꞌel Dios stuc. Cꞌalal ilaj yoꞌon ta stael ta naꞌel Dios li Jesuse, la sjacꞌbe li yajchanbalajeltaque: ―¿Cꞌusi la cabtel ta xalic li jchiꞌiltactique? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Itacꞌavic: ―Oy buchꞌutic ta xalic ti joꞌot Juanot li iyacꞌ ta ichꞌel joꞌ toꞌoxe. Oy yan ta xalic ti joꞌot Elíasote. Oy yan ta xalic ti joꞌot jun li buchꞌutic iyalic scꞌop Dios ta voꞌonee ti yuꞌun nan ichaꞌcuxie ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Li Jesuse jech laj yal: ―Li joꞌoxuque ¿cꞌusi cabtel ti avalojic eꞌuque? ―xut. Itacꞌav li Pedroe: ―Joꞌot tꞌujbilot yuꞌun Dios ti chaventainuncutique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Mu to me buchꞌu xavalbeic ti joꞌon tꞌujbilun yuꞌun Dios ti chajventainique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jech laj yalbe nojtoc li yajchanbalajeltaque: ―Joꞌon li coꞌol crixchanoutique jnaꞌoj ti ta onoꞌox xquichꞌ ep vocole. Mu xiscꞌanic li jꞌabteletique, schiꞌuc li banquilal paleetique, schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Chiyaqꞌuic ta milel. Chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Li Jesuse jech laj yalbe scotol li crixchanoetique: ―Li buchꞌu tscꞌan chtal ta jtojole, mu me scꞌuxubin sba. Scotol cꞌacꞌal acꞌo cuchuc yuꞌun vocol jech chac cꞌu chaꞌal ta xcuch cuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Li buchꞌu tscꞌuxubin li scuxlejal liꞌ ta balumile, ti mu scꞌan xcham ta jventa joꞌone, jaꞌ ta xchꞌay o sbatel osil. Yan li buchꞌu mu xichꞌ ta cꞌux li scuxlejal liꞌ ta balumile, ti mu sventauc mi te ta xcham ta jventa joꞌone, jaꞌ ta xcuxi o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Acꞌo mi oy buchꞌu ti chal ti tsbain scotol li cꞌustic oy liꞌ ta balumile, pero mu cꞌusi ta xtun o li scꞌulejal li cꞌalal ta xchame. Yuꞌun maꞌuc ta sta o scuxlejal sbatel osil li scꞌulejale. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Li buchꞌu ta xqꞌuexav ta schꞌunel li jcꞌop ta stojol li crixchanoetic li avie, ti mu junuc yoꞌon ta stojol li Diose, “maꞌuc jnichꞌon”, xichi li cꞌalal chtal ochcun ta ajvalilale, joꞌon li coꞌol crixchanoutique. Schiꞌuc xa stsatsal sjuꞌel li Jtot chitale, schiꞌuc chischiꞌinic talel li ángeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Melel li cꞌusi chacalbeique, oy jayvoꞌoxuc liꞌi ti muc to bu chachamique jaꞌ to mi avilic ti ta sventainan xa crixchanoetic li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cꞌalal jech laj yal li Jesuse, ta svaxaquibal to cꞌacꞌal ba sta ta naꞌel Dios ta jpꞌej vits li Jesuse. Laj yicꞌ batel Pedro, schiꞌuc Jacobo, schiꞌuc Juan. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cꞌalal yacal ta stael ta naꞌel Dios li Jesuse, iyacꞌ xojobal li sate. Isacub tajmec li scꞌuꞌe, xleblun tajmec saquil. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Cꞌalal isacub tajmec li scꞌuꞌe, jaꞌ o te ivinaj chaꞌvoꞌ viniquetic ti chloꞌilajic schiꞌuc li Jesuse. Jaꞌic Moisés schiꞌuc Elías li iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oy xojobalic eꞌuc. Li cꞌusi laj yalic schiꞌuc li Jesuse, jaꞌ ti cꞌu sba ta xcham te ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Li Pedroe schiꞌuc li schiꞌiltaque te chnicavic, pero te ivicꞌ o satic. Laj yilbeic xojobal li Jesuse schiꞌuc li chaꞌvoꞌ viniquetic li te schiꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cꞌalal iyilic ti ta xa xbat li chaꞌvoꞌ viniquetique, li Pedroe jech laj yalbe li Jesuse: ―Jchanubtasvanej, lec ti liꞌ oyutique. Jaꞌ lec ta jpascutic oxpꞌej yaxna liꞌi, jpꞌej avuꞌun, jpꞌej yuꞌun Moisés, jpꞌej yuꞌun Elías ―xi li Pedroe yuꞌun muc xnop yuꞌun lec li cꞌusi laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Cꞌalal yac toꞌox ta loꞌil li Pedroe, ital toc, imaquic ta toc scotolic. Ixiꞌic tajmec li cꞌalal imaquic ta toque. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iyaꞌiic icꞌopoj ta yut toc li Diose, jech laj yal: ―Liꞌi jaꞌ Jnichꞌon ti toj cꞌux ta coꞌone. Aꞌibeic scꞌop ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cꞌalal ilaj yoꞌon ta loꞌil li Diose, stuc xa noꞌox te vaꞌal iyilic li Jesuse. Li yajchanbalajeltaque muc xalbeic ta ora li yan schiꞌiltaquique li cꞌu sba iyilique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta yocꞌomal cꞌalal iyalic talel ta vitse, te tsobol istaic epal crixchanoetic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te schiꞌuquic jun vinic, tsots icꞌopoj, jech laj yal: ―Jchanubtasvanej, avocoluc coltabun jnichꞌon yuꞌun cꞌajomal yo jun li jnichꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuꞌun ta xꞌilbajinat yuꞌun pucuj. Ta xꞌavan, ta xtupꞌ yicꞌ, ta xvocan ye. Juliquel noꞌox ta xchꞌabulun ba pero ta xchaꞌlic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Laj calbeic vocol la avajchanbalajeltac ti acꞌo sloqꞌuesbecun li pucuj li ochem ta yoꞌone, pero mu xlocꞌ yuꞌunic ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Li Jesuse jech laj yal: ―Toj tsots avoꞌonic, mu xacꞌan xachꞌunic. Oy xa scꞌacꞌalil liꞌ jchiꞌucoxuque pero muc to bu chcꞌot ta avoꞌonic. Oy xa scꞌacꞌalil la jtsꞌicboxuc li cꞌu abaique ―xi. Jech laj yalbe li vinique: ―Icꞌo talel la anichꞌone ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cꞌalal inopoj talel li quereme, ijipe ta lum yuꞌun li pucuje, itupꞌbat yicꞌ. Li Jesuse la stac loqꞌuel li pucuje, icol ta ora li quereme. Li Jesuse jech laj yalbe li stot li quereme: ―Icꞌo batel la anichꞌone ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Scotolic toj chꞌayel noꞌox yoꞌonic li cꞌalal iyilic ti toj echꞌem sjuꞌel li Diose. Cꞌalal te toꞌox chꞌayem yoꞌon scotolic ta sventa li cꞌusi la spas li Jesuse, li Jesuse jech laj yalbe li yajchanbalajeltaque: ");
INSERT INTO tzoSA_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Aꞌiic li cꞌusi chacalbeique, mu me xchꞌay ta avoꞌonic. Joꞌon li coꞌol crixchanoutique chiꞌaqꞌue ta scꞌob crixchanoetic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Li yajchanbalajeltaque muc bu xaꞌibeic smelol li cꞌusi laj yale yuꞌun muc bu xꞌacꞌbat yaꞌiic yuꞌun li Diose. Ixiꞌic ta sjaqꞌuel li cꞌu sba smelol li cꞌusi iꞌalbatique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Li yajchanbalajeltac li Jesuse lic svulilan o sbaic ta sventa buchꞌu junucal más banquilal ta xcom yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Li Jesuse snaꞌoj li cꞌusi ta snopique jaꞌ yuꞌun laj yicꞌ talel jun unen. La svaꞌan ta xocon. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jech laj yalbe li yajchanbalajeltaque: ―Li buchꞌutic ti ta jventa joꞌon ta xichꞌic ta mucꞌ li buchꞌu ti jech yoꞌon jech chac cꞌu chaꞌal li unen liꞌi, joꞌon chiyichꞌic ta mucꞌ yaꞌel. Mi chiyichꞌic ta muqꞌue, jaꞌ ch‐ichꞌe ta mucꞌ li Jtot yaꞌele ti listac talele. Jaꞌ noꞌox jechoxuc eꞌuc li joꞌoxuque, li buchꞌu ta sbicꞌtajes sba ta atojolique jaꞌ banquilal ta xcom avuꞌunic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Li Juane jech laj yalbe li Jesuse: ―Jchanubtasvanej, oy buchꞌu iquilcutic ta sloqꞌuesbe pucujetic ta yoꞌonic li crixchanoetique. Ta xal abi li cꞌalal ta sloqꞌuese. Pero la jpajescutic yuꞌun mu bacꞌne jchiꞌintic ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Itacꞌav li Jesuse: ―Mu me xapajesic. Yuꞌun li buchꞌu ta sloqꞌues pucuj jech chac cꞌu chaꞌal ta jloqꞌuestique, jaꞌ jmoj cabtel jchiꞌuctic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cꞌalal jutuc xaꞌox scꞌan sta scꞌacꞌalil ta xꞌiqꞌue muyel ta vinajel li Jesuse, muc bu xiꞌ ti ta xbat ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oy buchꞌu baꞌi la stac jelavel yoꞌ acꞌo ba schꞌamunic na li yoꞌ bu ta xcꞌotique schiꞌuc acꞌo sman sveꞌelic. Ibatic, te icꞌotic ta jun colonia te ta Samaria balumil. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Li jsamariaetic li te nacalique muc bu xaqꞌuic ta chꞌom snaic yuꞌun iyaꞌiic ti te chbatic ta Jerusalén schiꞌuc li yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Li chaꞌvoꞌ yajchanbalajeltaque, jaꞌ li Jacobo schiꞌuc li Juane, cꞌalal iyilic ti muc xaqꞌuic ta chꞌom snaique, jech laj yalbeic li Jesuse: ―Cajval, ¿mi chacꞌan ti ta jpascutic mantal ti acꞌo yaluc talel cꞌocꞌ ta vinajele yoꞌ jech acꞌo chamicuc jech chac cꞌu chaꞌal la spas li Elíase? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Li Jesuse la sqꞌuelbe sat li chaꞌvoꞌ li yajchanbalajeltaque, jech laj yalbe: ―Mu me xavalic jech chac taje. Yuꞌun maꞌuc Dios ti sventainojoxuc ti mi jech chavalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Joꞌon li coꞌol crixchanoutique mu me yuꞌunuc tal jmilic yoꞌ acꞌo chꞌayicuc o sbatel osil li crixchanoetique. Yuꞌun me tal jcoltaic ―xi li Jesuse. Cꞌalal laj yalbe jech, ibatic ta yan o colonia. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cꞌalal yacalic ta xanbal ta bee, li Jesuse jech iꞌalbat yuꞌun jun vinic: ―Cajval, chajchiꞌin batel ti butic chabate ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Itacꞌav li Jesuse: ―Li vete jaꞌ oy to schꞌen, li mute jaꞌ oy to stas yaꞌel. Joꞌon li coꞌol crixchanoutique muꞌyuc jna. Nopo lec mi chacꞌan chachiꞌinun batele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Li Jesuse jech laj yalbe jun vinic: ―Chiꞌinun batel ―xut. Itacꞌav li vinique: ―Cajval, chavacꞌ xibat yuꞌun chba jchiꞌin li jtote. Mi ichame, ta jmuc comel, jaꞌ to chba jchiꞌinot ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Itacꞌav li Jesuse: ―Li buchꞌutic ti mu xiyichꞌic ta muqꞌue, coꞌol schiꞌuc chamemic yaꞌel. Te acꞌo smuc sba stuquic. Li joꞌote ba albo yaꞌiic li crixchanoetic ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oy buchꞌu yan jech laj yal: ―Cajval, chba jchiꞌinot. Pero ta chavacꞌ xibat yuꞌun chba jcꞌopon comel scotol li buchꞌutic te ta jnae ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Itacꞌav li Jesuse: ―Mi mu ta sloqꞌueluc avoꞌon chachꞌun li cꞌusi chacalbee, jaꞌ jechot jech chac cꞌu chaꞌal li buchꞌu mu teuc batem sat li cꞌu sba ta sloc li yosile. Mu xlaj o li yabtele. Jaꞌ jech mu xuꞌ chatun yuꞌun Dios mi mu ta yavuc oy avoꞌon ta stojol li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ta tsꞌacal la stꞌuj yan lajuneb schanvinic (70) jꞌisraeletic li Cajvaltique. Ta chaꞌchaꞌvoꞌ la stac batel ta jujun jteclum schiꞌuc ta jujun colonia yuꞌun snopoj ti tsꞌacal to te ta xjelav eꞌuc li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Xi laj yalbe scotolic: ―Melel oy ep li buchꞌutic chac yaꞌiic li scꞌop Diose pero jaꞌ muc bu ep li buchꞌutic chal li scꞌop Diose. Jech chac cꞌu chaꞌal mi ep li cꞌajoje pero jaꞌ muc bu ep li jcꞌajavile. Jaꞌ yuꞌun cꞌanbeic Dios ti acꞌo stac batel li buchꞌutic chba yalbeic li scꞌope yuꞌun jaꞌ Yajval li abtele. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Batanic. Chajtaquic batel jech chac cꞌu chaꞌal chijetic ti chcꞌot staic oqꞌuiletique yuꞌun te chcꞌot ataic jchiꞌiltactic ti chac smiloxuque. Jaꞌ yuꞌun pꞌijanic me. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mu me xavichꞌic batel ataqꞌuinic, mu me xavichꞌic batel aveꞌelic. Mu me xavichꞌic batel yan axonobic. Li buchꞌu chanupic ta bee mu me jaluc xaloꞌilaj achiꞌuquic. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Li bu junucal na chaꞌochique baꞌi jech xavalbeic: “Acꞌo spasboxuc ta jun avoꞌonic li Diose”, utic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi ta scꞌan ti jun yoꞌonique, chilic ti jun yoꞌonique. Mi mu scꞌanique, mu xilic o ti jun yoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Li na li bu chaꞌotesatique te me oyanic o. Mu me xajelulanic la anailique. Scotol li cꞌusi chaꞌacꞌbatique, lajesic. Yuꞌun li buchꞌu ta xtaque batel ta abtele te ta xꞌacꞌbat sveꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cꞌalal chacꞌotic ta jujun jteclume, mi oy buchꞌu chayotesic ta snae, lajesic scotol li cꞌustic chayacꞌbeique. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mi oy jchamelajeletic teye, coltaanic. Xi xavalbeique: “Naꞌic ti ista xa scꞌacꞌalil chasventainic li Diose, yuꞌun avilic xa ti la scoltaoxuque”, utic. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mi oy bu junucal jteclum ti mu xayotesic ta snaique, xanavanic batel ta cayaetic, xi xavalique: ");
INSERT INTO tzoSA_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ta jlilincutic comel li spucucal coccutic liꞌ ta atojolique. Jaꞌ senyail ti icom xa ta aba atuquic ti muc xavichꞌuncutic ta muqꞌue. Avaꞌiic xa ti ista xa scꞌacꞌalil chasventainic li Diose”, utic comel. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chacalbeic, cꞌalal ta xcꞌot scꞌacꞌalil ta xichꞌ cꞌop li Diose, jaꞌ más tsots vocol ta xichꞌic li jchiꞌiltactic li te ta jteclum li bu muc xayotesique. Li vocol ti ta xichꞌic li crixchanoetic li ta Sodoma ta voꞌonee, jaꞌ mu sta jech. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Ta onoꞌox xichꞌic tsots vocol li jchiꞌiltactic li te nacalic ta jteclum Corazine schiꞌuc li jchiꞌiltactic li te nacalic ta jteclum Betsáidae, yuꞌun iyilic jayib velta ti oy jtsatsal juꞌele pero muc bu xiyichꞌic ta mucꞌ. Li jyanlumal crixchanoetic li te nacalic ta jteclum Tiro schiꞌuc ta jteclum Sidón ta voꞌonee, muc bu xiyilbeic li jtsatsal juꞌele. Ti iyilicuque, la slapic jalbil tsotsil tentsun ti chꞌixaltic ta lapele, schiꞌuc la sbon sbaic ta tanil cꞌocꞌ ti jechuque. Jaꞌ senyail ti ta xat o yoꞌonic li cꞌustic chopol spasojique, jech ta xictaic o. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cꞌalal ta xcꞌot scꞌacꞌalil ta xichꞌ cꞌop li Diose, jaꞌ tsots ta xichꞌic vocol li jchiꞌiltactic li te nacalic ta Corazín schiꞌuc ta Betsáida li avie. Li vocol ti ta xichꞌic li jyanlumal crixchanoetic li te nacalic ta Tiro schiꞌuc ta Sidón ta voꞌonee, jaꞌ mu sta jech. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Li jchiꞌiltactic li te nacalic ta jteclum Capernaume, ta snopic ti jaꞌ ep ta xichꞌbeic slequilal yutsilal li Diose, pero altic. Jaꞌ tsots ta xichꞌic vocol yuꞌun iyilic jayib velta ti oy jtsatsal juꞌele pero muc bu xiyichꞌic ta mucꞌ ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Li buchꞌutic chayichꞌic ta muqꞌue joꞌon ichꞌbilun ta mucꞌ yaꞌel. Yan li buchꞌutic mu xayichꞌic ta muqꞌue joꞌon mu xiyichꞌic ta mucꞌ yaꞌel. Li buchꞌutic mu xiyichꞌic ta muqꞌue jaꞌ mu xichꞌic ta mucꞌ eꞌuc li Jtot ti listac talele ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Li lajuneb schanvinic (70) li itaqueic batele xmuybajic noꞌox isutic talel. Jech cꞌot yalbeic li Jesuse: ―Cajval, ta achꞌuljuꞌel cꞌalal ta pucujetic la jloqꞌuescutic ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Li Jesuse jech laj yal: ―Jaꞌ jech chac cꞌu chaꞌal ta xlebuj chauc ti toj chꞌayel ta orae, jaꞌ jech iquil ilaj stsatsal yabtel li Satanase. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aꞌiic, laj xa cacꞌboxuc ajuꞌelic yoꞌ jech xuꞌ avuꞌunic chapasic ta canal li buchꞌutic chiscontrainutique, jaꞌ ti toj chopolique, ti ta scꞌan ti coꞌol chachꞌayic o sbatel osil achiꞌuquique. Jaꞌ jech chac cꞌu chaꞌal chajuꞌic ta teqꞌuel stsec schiꞌuc yan chonetic, jaꞌ jech chapasic ta canal scotol li buchꞌutic chiscontrainutique. Mu cꞌusi xuꞌ chaspasbeic. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mu me xamuybajic noꞌox ti chꞌunbil amantalic yuꞌun li pucujetique. Jaꞌ me acꞌo muybajanic o ta sventa ti te xa tsꞌibabil abiic ta vinajele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Li Jesuse xmuybaj noꞌox ta ora ta sventa li Chꞌul Espíritu li oy ta yoꞌone, jech lic scꞌopon Stot: ―Tata, joꞌot yajvalot li vinajel balumile. Colaval ti muc bu xavacꞌbe yaꞌibeic smelol li cꞌusi laj cal schiꞌuc li cꞌusi la jpas li buchꞌutic pꞌijique schiꞌuc li buchꞌutic lec snaꞌic ti yalojique. Jaꞌ noꞌox la avacꞌbe yaꞌibeic smelol li buchꞌutic ta scꞌanic coltaele jech chac cꞌu chaꞌal ta scꞌanic coltael li unetique. Tata, lec ti jech la acꞌane ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Li Jesuse xi lic yalanbe li crixchanoetique: ―Scotol yacꞌojbun ta jcꞌob li Jtote. Joꞌon li Snichꞌonune muc buchꞌu snaꞌ li cꞌu sba li coꞌone. Jaꞌ noꞌox stuc Jtot snaꞌoj li cꞌu sba li coꞌone. Jaꞌ noꞌox jech eꞌuc li Jtote muc buchꞌu snaꞌbe li cꞌu sba yoꞌone. Joꞌon noꞌox jnaꞌojbe li cꞌu sba yoꞌon li Jtote, schiꞌuc snaꞌic eꞌuc li buchꞌutic ta xcacꞌbe snaꞌique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Li Jesuse jaꞌ lic scꞌoponan li yajchanbalajeltaque, xi laj yalbe: ―Joꞌoxuc li cajchanbalajeltacoxuque la scꞌuxubinoxuc xa li Diose yuꞌun avilic xa li cꞌustic ta jpase. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chacalbeic, ep li buchꞌutic iyalic scꞌop Dios ta voꞌonee schiꞌuc ep li ajvaliletic ta voꞌonee chac ox sqꞌuelic eꞌuc li cꞌusi ta jpase, pero muc xa xilic. Chac ox yaꞌiic eꞌuc li cꞌusi ta xcale, pero muc xa xaꞌiic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te oy jun li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. La svaꞌan sba yuꞌun oy cꞌusi ta sjacꞌbe li Jesuse. Yuꞌun noꞌox tsqꞌuel cꞌu sba chtacꞌav. Jech laj yalbe: ―Jchanubtasvanej, ¿cꞌusi ti lec ta jpase yoꞌ jech chicuxi o sbatel osile? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Li Jesuse jech laj yalbe li vinique: ―¿Cꞌusi tsꞌibabil ta smantaltac li Diose yuꞌun aqꞌueloj xa? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Itacꞌav li vinique: ―“Sloqꞌueluc me avoꞌonic cꞌanic me li Dios cuꞌuntique. Acꞌbo sventain avoꞌonic, schiꞌuc atsatsalic, schiꞌuc apꞌijilic. Acꞌo tunuc yuꞌun. Cꞌuxubino me achiꞌilic jech chac cꞌu chaꞌal cꞌux chavaꞌi aba atuque”, xi li smantal Diose ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Itacꞌav li Jesuse: ―Lec latacꞌav. Ti mi jaꞌ chapas taje, chacuxi o sbatel osil ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Li vinique ta scꞌan ta spoj sba, jech laj yalbe li Jesuse: ―¿Buchꞌu li jchiꞌile? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Li Jesuse oy cꞌusi laj yal ta loꞌil, jech laj yal: ―Oy jun jchiꞌiltic ta israelal ilocꞌ batel ta Jerusalén, ibat ta Jericó. Cꞌalal yac ta xanbal batel ta bee, te isnup ta be jꞌeleqꞌuetic. Ipojbat scotol li cꞌustic oy yuꞌune, schiꞌuc ilocꞌbat scꞌuꞌ, schiꞌuc imaje. Ep iyaij. Ibatic li jꞌeleqꞌuetique. Chamem xa icom yilel li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tsꞌacal to te iꞌechꞌ batel jun pale cuꞌuntic. Cꞌalal iyil ti te puchꞌul li jchiꞌiltique, la sjoy sbe li palee, ijelav o batel. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tsꞌacal to te iꞌechꞌ batel jun yajcoltaob paleetic li ta mucꞌta chꞌulnae. Cꞌalal icꞌot li bu puchꞌul li jchiꞌiltique, la sjoy sbe eꞌuc, ijelav o batel. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tsꞌacal to te iꞌechꞌ batel jun jyanlum vinic liquem talel ta Samaria balumil. Cꞌalal iyil ti te puchꞌul li jchiꞌiltique, li jsamariail vinique iyichꞌ ta cꞌux. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Inopoj batel li bu puchꞌule. La spoxtabe scotol li bu yaijeme, la sjaxbe asete schiꞌuc vino, la spixbe lec ta pocꞌ. La scajan batel ta sba sburro, laj yicꞌ batel li yoꞌ bu chaqꞌuic ta loqꞌuel nae. Te la schabi. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta yocꞌomal cꞌalal ilocꞌ batel li jsamariail vinique, laj yacꞌbe comel chib denario taqꞌuin li yajval nae. Jech laj yalbe comel: “Chabibun me lec li vinique. Mi oy cꞌusi más ta xlaj avuꞌune, chajtojbe scotol cꞌalal mi lisut talele”, xut comel li yajval nae. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Li joꞌote ¿cꞌusi chanop? Li oxvoꞌique ¿buchꞌu junucal la spꞌis ta schiꞌil li jchiꞌiltic ti imaje comel yuꞌun li jꞌeleqꞌuetique? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Itacꞌav li jun ti spꞌisoj sba ta jchanubtasvanej ta smantaltac li Diose: ―Jaꞌ li buchꞌu icꞌuxubinvane ―xi. Li Jesuse jech laj yalbe: ―Batan, ba cꞌuxubinvanan jech eꞌuc li joꞌote ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Li Jesuse te icꞌot ta jun colonia schiꞌuc li yajchanbalajeltaque. Te nacal jun ants, Marta sbi. Te iꞌotesat ta na li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Oy smuc li Martae, María sbi. Li Maríae te tal chotluc ta nopol yoc li Jesuse yuꞌun tscꞌan chaꞌibe scꞌop. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Li Martae jaꞌ noꞌox batem ta yoꞌon li cꞌusi ta spas ta snae yuꞌun ta xmacꞌlanvan. Inopoj talel ta stojol li Jesuse, jech laj yalbe: ―Cajval, ¿mi mu cꞌusi ta xal avoꞌon ti jtuc noꞌox chiyacꞌbe jmeltsan li veꞌlil li jmuque? Jaꞌ lec albo acꞌo tal scoltaun eꞌuc ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Itacꞌav li Jesuse: ―Marta, ta sventa ti jaꞌ noꞌox batem ta avoꞌon la avabtele jech muc bu jun avoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero jaꞌ persa chavaꞌibun li jcꞌope. Li Maríae laj xa snop ti jaꞌ chaꞌi li jcꞌope, jech muc buchꞌu xuꞌ chpojbat ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ta yan o cꞌacꞌal cꞌalal ilaj yoꞌon ta stael ta naꞌel Dios li Jesuse, jech iꞌalbat yuꞌun jun li yajchanbalajeltaque: ―Cajval, chanubtasuncutic ta stael ta naꞌel Dios eꞌuc jech chac cꞌu chaꞌal la schanubtas yajchanbalajeltac li Juan li iyacꞌ ta ichꞌel joꞌe ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Itacꞌav li Jesuse: ―Cꞌalal chataic ta naꞌel li Diose, xi xacꞌopojique: “Jtotic Dios ti te oyot ta vinajele, acꞌo me quichꞌotcutic ta mucꞌ jcotolcutic liꞌ ta balumile. Acꞌo me cꞌotuc scꞌacꞌalil chtal apas mantal atuc liꞌ ta balumile. Acꞌo me jaꞌuc jpascutic li cꞌusi chacꞌan liꞌ ta balumile jech chac cꞌu chaꞌal li te ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Acꞌbuncutic talel jveꞌelcutic li avi cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasbuncutic perton yuꞌun li jmulcutique jech chac cꞌu chaꞌal ta jpasbecutic perton li buchꞌutic oy smul cuꞌuncutique. Mu me xavacꞌuncutic ta pasel ta canal li ta mulile. Coltauncutic me”, xachi xacꞌopojic li cꞌalal chataic ta naꞌel li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jech laj yal ta loꞌil nojtoc li Jesuse: ―Ti jechuc ti oy buchꞌu lec xacꞌopon aba achiꞌuc ti te chcꞌot schꞌamun ana yuꞌun te chvaye, pero mu cꞌusi oy avuꞌun ti chamacꞌlan oe. Pero oy jun achiꞌil ti chba acꞌopon ta oꞌlol acꞌubale yuꞌun chba aqꞌuexbe oxibuc span sventa chamacꞌlan o la avuloꞌ li icꞌot ta anae. Jech chcꞌot avalbe: “Jqꞌuextic oxibuc apan yuꞌun naca to icꞌot culoꞌ. Pero mu cꞌusi xcacꞌbe slajes”, xavut. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jech chayalbe: “Mu xuꞌ, yuꞌun jmacoj xa lec li stiꞌ jnae. Chijvaycutic xa jchiꞌuc jnichꞌnab jech mu xuꞌ chlic cacꞌbot”, xayut. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pero mi mu xlaj avoꞌon ta sjacꞌbeele, chlic yacꞌbot scotol li cꞌustic ta xtun avuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaꞌ noꞌox jech li Diose mi mu xlaj coꞌontic ta scꞌanulanbeele, ta onoꞌox xijyacꞌbutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yuꞌun li buchꞌutic ta scꞌanique ta xꞌacꞌbatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Li joꞌoxuque, mi chascꞌanbeic vaj sveꞌ anichꞌonique, mu tonuc chavacꞌbeic slajes. Mi chascꞌanbeic choy stiꞌe, mu chonuc chavacꞌbeic stiꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mi chascꞌanbeic ton caxlan sloꞌe, mu jcotuc stsec chavacꞌbeic stiꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Li joꞌoxuque chopoloxuc onoꞌox pero xanaꞌic li cꞌusi lec chavacꞌbeic la anichꞌnabique. Li Jtotic Dios ta vinajele jaꞌ snaꞌoj lec li cꞌusi ta xacꞌbe li buchꞌutic ta xcꞌanbate. Jaꞌ ta xacꞌbe li Chꞌul Espíritue ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Li Jesuse la sloqꞌuesbe pucuj ta yoꞌon jun umaꞌ vinic. Ti jech umaꞌ li vinique, jaꞌ ta scoj li pucuj li ochem ta yoꞌone. Cꞌalal ilocꞌ li pucuj ta yoꞌone, ijam li yee. Li crixchanoetique toj chꞌayel noꞌox yoꞌonic ti cꞌalal iyilic ti ijam ye li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero oy jayvoꞌ jech iyalic: ―Li vinic liꞌi ta sjuꞌel banquilal pucuj ta sloqꞌues li pucujetic li ochem ta yoꞌonic li crixchanoetique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oy yan jaꞌ noꞌox tscꞌan ta sqꞌuelbeic yoꞌon li Jesuse, jech laj yalbeic: ―Jchanubtasvanej, acꞌbun quilcutic ta vinajel la atsatsal ajuꞌele yoꞌ jech ta jchꞌuncutic o ti tsots avabtele ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Li Jesuse snaꞌoj li cꞌusi ta snop ta yoꞌonique, jech laj yalbe: ―Mi ta scontrain sbaic jun ajvalil schiꞌuc schiꞌiltac ta abtele, ta soquic o. Mi ta scontrain sbaic ta jpꞌej noꞌox snailique, ta soquic o nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jaꞌ noꞌox jech eꞌuc li Satanase, mi ta sloqꞌues schiꞌil ta pucujal ta yoꞌonic li crixchanoetique, mu xuꞌ spas mantal mi jech ta spase. Ti jech chacalbeique, yuꞌun chavalic ti ta sjuꞌel Satanás ta jloqꞌues li pucujetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti meleluque, ¿buchꞌu ta sventa ta sloqꞌuesic pucujetic eꞌuc la avajchanbalajeltaquique? La avajchanbalajeltaquique xuꞌ ta xalic ti mu meleluc li cꞌusi chavalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Li joꞌone ta sventa stsatsal sjuꞌel Dios ta jloqꞌues li pucujetique, jaꞌ ta xvinaj o ti liꞌ xa ta spas mantal ta atojolic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Li buchꞌu tsatsal vinic schiꞌuc ti oy lec yabtejeb ti ta schabi o li snae, muc buchꞌu xuꞌ ta xpojbun li cꞌustic oy ta snae. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero ti mi ipase ta canal yuꞌun li buchꞌu más tsotse, ta xpojbat li yabtejeb ti jaꞌ spatoj o yoꞌone, jech ta xpojbat o li cꞌustic oy yuꞌune. Li Satanase jaꞌ jech chac cꞌu chaꞌal li tsatsal vinique yuꞌun jaꞌ sventainoj li crixchanoetique. Pero li joꞌone jaꞌ jechun jech chac cꞌu chaꞌal li más tsatsal vinique yuꞌun la jpas xa ta canal. Yuꞌun la jpojbe li vinic li te toꞌox oy ta scꞌobe. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Li buchꞌu muc bu lec ta xil li cꞌusi ta jpase jaꞌ chiscontrain o. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Joꞌoxuc li liꞌ chavaꞌibecun li jcꞌope, más to chasoquic o ta scoj ti mu xavichꞌicun ta muqꞌue. Jaꞌ jech chac cꞌu chaꞌal jun vinic ti ilocꞌ pucuj ta yoꞌone. Li pucuje ibat ta taqui jamaltic, ba saꞌ bu ta xcux yoꞌon, pero muc bu sta. Jech iyal ta yoꞌon: “Jaꞌ lec chichaꞌsut batel nojtoc ta yoꞌon li vinique”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cꞌalal icꞌote, xocol cꞌot sta li bu toꞌox oye, yuꞌun li vinique muc bu yacꞌoj sba ta scꞌob li Diose. Stuc noꞌox stuqꞌuibtasoj sba jutuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jech li pucuje ba saꞌ talel jucub schiꞌiltac ta pucujal, jaꞌ li bu toj echꞌem chopolique. Tal ochicuc ta yoꞌon li vinique. Te inaquiic o. Li vinique más to isoc o tajmec ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Cꞌalal jaꞌ o yacal ta xcꞌopoj li Jesuse, oy jun ants li te schiꞌuquic li crixchanoetique tsots icꞌopoj, jech laj yalbe li Jesuse: ―Jaꞌ más xmuybaj la ameꞌe yuꞌun jaꞌ la svoqꞌuesot ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Itacꞌav li Jesuse: ―Scotol li buchꞌutic ta xaꞌiic schiꞌuc ti ta schꞌunic li cꞌustic ta xꞌalbatic yuꞌun li Diose, jaꞌ más xmuybajic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cꞌalal yacal ta stsob sbaic talel li crixchanoetic ta stojol li Jesuse, xi laj yalbe: ―Joꞌoxuc li liꞌ oyoxuc ta balumile, chopol avoꞌonic. Chacꞌan chaqꞌuelic li juꞌele pero muc bu chcacꞌ avilic. Jaꞌ noꞌox chcacꞌ avilic jech chac cꞌu chaꞌal icꞌot ta pasel ta stojol li Jonase, jaꞌ li buchꞌu iyal scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jech chac cꞌu chaꞌal li jyanlumal crixchanoetic li te nacalic ta jteclum Nínivee isnaꞌic ti tacbil ba yuꞌun Dios li Jonase, jaꞌ chanaꞌic o ti tacbilun talel yuꞌun li Diose, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Oy toꞌox jun ants ta voꞌone ti ochem ta ajvalilal ta jun balumil ta xocon vinajel ta sur. Cꞌalal chcꞌot scꞌacꞌalil ta xichꞌ cꞌop li Diose, jaꞌ más tsots chavichꞌic vocol li joꞌoxuc ti liꞌ to oyoxuc ta balumile. Li vocol ta xichꞌ li meꞌajvalile, jaꞌ mu sta jech. Yuꞌun li antse nom ital, tal yaꞌibe scꞌop li mucꞌta ajvalil Salomone yuꞌun iyaꞌi ti lec pꞌije. Pero li Salomone mu tsotsuc yabtel laj yichꞌ. Joꞌon ti liꞌ oyun ta atojolique, más to joꞌon jnaꞌ, pero mu xavichꞌicun ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Cꞌalal ta xcꞌot scꞌacꞌalil ta xichꞌ cꞌop li Diose, jaꞌ más tsots chavichꞌic vocol li joꞌoxuc ti liꞌ to oyoxuc ta balumile. Li vocol ti ta xichꞌic li crixchanoetic ta Nínive ta voꞌonee, jaꞌ mu sta jech. Yuꞌun cꞌalal a yalbe scꞌop Dios li crixchanoetic ta Nínive li Jonase, laj yictaic ta ora li cꞌustic chopol tspasique. Li Jonase mu tsotsuc yabtel laj yichꞌ. Joꞌon ti liꞌ oyun ta atojolique, tsots cabtel quichꞌoj, pero mu xavaqꞌuic ta venta li cꞌusi chacalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Jech chac cꞌu chaꞌal mi oy chatsanic lámparae, muc bu chavaqꞌuic ti bu mu xvinaje, muc bu chanujmaquiic ta moch. Chavaqꞌuic ta sjocꞌleb yoꞌ jaꞌ lec chilic o osil scotol li buchꞌutic ta xꞌochic talel ta anaique. Jaꞌ noꞌox jechun eꞌuc yuꞌun jamal laj cacꞌ avilic ti tacbilun talel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","La asatique jaꞌ jech chac cꞌu chaꞌal li lámparae. Mi lec ta xtil li lámparae, lec ta xquiltic o osil. Yan mi mu xtile, oyutic ta icꞌal acꞌubal. Jaꞌ noꞌox jechoxuc eꞌuc, mi achꞌunojic li cꞌustic yaloj li Diose, jaꞌ chanaꞌic o ti tacbilun talel yuꞌun li Diose. Yan mi muc bu achꞌunojique, mu xanaꞌic ti tacbilun talel yuꞌun li Diose. Jaꞌ yuꞌun chac aqꞌuelic mi oy juꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jaꞌ yuꞌun qꞌuelo me abaic, mu me ta scojuc noꞌox ti tsots avoꞌonic ti mu xanaꞌic ti joꞌon tacbilun talel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yuꞌun mi ta sloqꞌuel avoꞌonic achꞌunojic li cꞌustic yaloj li Diose, xanaꞌic lec ti tacbilun talel yuꞌun Dios jech chac cꞌu chaꞌal lec chavilic osil mi lec xtil li lámparae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cꞌalal ilaj yoꞌon ta loꞌil li Jesuse, iꞌiqꞌue batel ta veꞌel yuꞌun jun vinic ochem ta fariseoal. Li Jesuse ibat, te cꞌot chotluc ta mexa. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Li jfariseoe toj chꞌayel noꞌox yoꞌon cꞌalal iyil ti muc bu jal la spoc scꞌob li Jesuse li cꞌalal ba chotluc ta mexae. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Li Cajvaltique xi laj yal: ―Joꞌoxuc li jfariseooxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal li buchꞌu jaꞌ noꞌox ta spocbe spat xocon li vasoe schiꞌuc li pulatue. Yan li yute muc bu tsuqꞌuic, noj ta icꞌubal. Jaꞌ noꞌox jechoxuc li joꞌoxuque. Lecoxuc yilel pero jaꞌ noꞌox batem ta avoꞌonic scꞌupinel li cꞌustic oy yuꞌun la achiꞌilique. Chavalbeic ti acꞌo yaqꞌuic ta smoton Diose pero joꞌoxuc noꞌox chavichꞌic atuquic. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Muc bu pꞌijoxuc. ¿Mi chanopic ti mu xil avoꞌonic li Dios ti jaꞌ la spasoxuque? ");
INSERT INTO tzoSA_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jaꞌ lec cꞌuxubinvananic, qꞌuelanic li cꞌustic oy avuꞌunique, jaꞌ lec chayilic o li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Joꞌoxuc li jfariseooxuque ta onoꞌox xavichꞌic tsots vocol yuꞌun jaꞌ noꞌox chanopic ti persa chavatic ta lajlajuneb li cꞌustic atsꞌunojique: jaꞌ li tulnichime, schiꞌuc li lulae, schiꞌuc scotol li cꞌustic yan atsꞌunojique. Chaloqꞌuesic jujun li ta lajlajunebe ta sventa smoton li Diose. Chanopic ti persa chavacꞌbeic Dios li cꞌustic oy avuꞌunique, pero mu xavaqꞌuic ta venta ti scꞌan ti lec chameltsanic cꞌope, schiꞌuc ti ta sloqꞌueluc avoꞌonic chacꞌanic li Diose. Jaꞌ lec ti lauc apasic nojtoc ti bu persa scꞌan pasele. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Joꞌoxuc li jfariseooxuque ta onoꞌox xavichꞌic tsots vocol yuꞌun lec chavaꞌiic ti chachotiic li bu tꞌujbil chotlebal li te ta chꞌulnaetique. Jaꞌ lec chavaꞌiic ti lequil cꞌoponbiloxuc yuꞌun li jchiꞌiltactic li te ta chꞌivite. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Joꞌoxuc li jfariseooxuque, jloꞌlovanejoxuc, jaꞌ yuꞌun ta onoꞌox xavichꞌic tsots vocol. Jaꞌ jechoxuc jech chac cꞌu chaꞌal li chꞌenal ánima li bu muc bu acꞌbil senyaile jech mu xvinaj. Li buchꞌutic te ta xjelavic ta sbae, mu snaꞌic mi oy ánima li te ta yute. Jaꞌ noꞌox jechoxuc li joꞌoxuque, li buchꞌutic ta schꞌunic li cꞌusi chavalique, mu snaꞌic ti chamem chayilic li Diose yuꞌun naca chopol li cꞌustic oy ta avoꞌonique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jech itacꞌav jun li buchꞌu spꞌisoj sba ta jchanubtasvanej ta smantaltac li Diose: ―Jchanubtasvanej, ti avaꞌi sba chavale, yuꞌun chopol chaviluncutic eꞌuc ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Li Jesuse jech itacꞌav: ―Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose, ta onoꞌox xavichꞌic tsots vocol. Yuꞌun coꞌol schiꞌuc chapechꞌic lec icatsil ti toj ole, ti vocol ta xlic ta petele. Jaꞌ noꞌox chavacꞌbeic scuch la achiꞌilique, pero li joꞌoxuque mu xlic avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Ta onoꞌox xavichꞌic tsots vocol yuꞌun jaꞌ avichꞌojbeic yoꞌon la atot ameꞌic ta voꞌonee. Yuꞌun chachaꞌachꞌubtasbeic lec smuquenal li buchꞌutic iyalic scꞌop Dios ta voꞌonee, jaꞌ li buchꞌutic la smilanic la atot ameꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jaꞌ chvinaj o ti coꞌol avoꞌonic achiꞌuquic la atot ameꞌic ta voꞌonee. Joꞌoxuc to chatsꞌacubtasic li cꞌusi la spasic la atot ameꞌic ta voꞌonee yuꞌun poꞌot xa chapasbecun jech eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Li Diose snaꞌoj onoꞌox ti jech ta xcꞌot ta pasele, jaꞌ yuꞌun jech onoꞌox laj yal: “Ta jtacbeic batel li buchꞌutic ta xalic li jcꞌope schiꞌuc li jchanubtasvanejetique. Oy jayvoꞌ ta smilic, oy jayvoꞌ ta xilbajinic”, xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Jaꞌ yuꞌun joꞌoxuc ta xcom ta abaic ti imileic li cꞌu yepal li buchꞌutic iyalic scꞌop Dios li cꞌalal imeltsaj li vinajel balumile schiꞌuc cꞌalal tana. Cꞌalal imile li Abele ti cꞌalal to icꞌot ta lajel li Zacaríase ti imile ta yamaqꞌuil li mucꞌta chꞌulna ta nopol scajleb smoton li Diose, joꞌoxuc icom ta abaic scotol. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Joꞌoxuc ti apꞌisoj abaic ta jchanubtasvanej ta smantaltac li Diose, ta onoꞌox xavichꞌic tsots vocol yuꞌun laj xa ajelbeic smelol li smantaltac li Diose. Yuꞌun mu xachꞌun atuquic, jaꞌ yuꞌun muc bu chachanubtasic lec la achiꞌiltaquique. Jaꞌ yuꞌun joꞌoxuc chamaquic li buchꞌutic tscꞌan tschꞌunique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cꞌalal laj yal jech li Jesuse, li buchꞌutic ti spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jfariseoetique, iꞌilinic tajmec. Jaꞌ yuꞌun lic smucꞌtajacꞌbeic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yuꞌun ta sqꞌuelic ti cꞌu sba chtacꞌav li Jesuse yoꞌ jaꞌ ta stabeic o smul ti yalojique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Cꞌalal jaꞌ o te chloꞌilaj schiꞌuc li jfariseoetic li Jesuse, la stsob sbaic talel ta stojol Jesús ep ta mil crixchanoetic. Te snetꞌnetꞌ sbaic scotolic. Li Jesuse baꞌi jech laj yalbe li yajchanbalajeltaque: ―Qꞌuelo me abaic ta sventa svochesobil spanic li jfariseoetique. Yuꞌun tucꞌ yoꞌonic yilel pero jaꞌ noꞌox ta xloꞌlovanic. Li joꞌoxuque mu me xapasic jech. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yuꞌun mi oy cꞌusi chopol chanop ta avoꞌonic li avie, ta onoꞌox xvinaj bu cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Scotol li cꞌustic chavalic ta mucule ta onoꞌox xvinaj bu cꞌacꞌal te ta stojol li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Joꞌoxuc ti lec chaquilique, chacalbeic ti mu me xasibtes abaic yuꞌun li buchꞌutic chac smiloxuque, yuꞌun mu snaꞌ xcham la achꞌulelique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jaꞌ me xaxiꞌic li Diose yuꞌun jaꞌ xuꞌ yuꞌun chasticꞌoxuc ta mucꞌta cꞌocꞌ schiꞌuc achꞌulelic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Xanaꞌic ti lajuneb noꞌox centavo stojol ta joꞌcot li bicꞌtal mutetique. Pero mu jcotuc ta xchꞌay ta yoꞌon li Diose, scotol schabioj. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Li joꞌoxuque atbil scotol li jaypꞌej li stsotsil ajolique. Jaꞌ yuꞌun mu me xaxiꞌic. Yuꞌun más to cꞌuxoxuc ta yoꞌon li Diose; jaꞌ jutuc noꞌox cꞌuxubinbilic li bicꞌtal mutetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Chacalbeic, li buchꞌutic ti jamal ta xalic ta stojol li crixchanoetic ti yichꞌojicun ta muqꞌue, jaꞌ noꞌox jechun eꞌuc li joꞌon li coꞌol crixchanoutique, jamal ta xcal ta stojol Jtot ti melel yichꞌojicun ta muqꞌue, schiꞌuc ta stojol li yajꞌangeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yan li buchꞌutic ti mu jamluc ta xalic ta stojol li crixchanoetic ti yichꞌojicun ta muqꞌue, jaꞌ noꞌox jechun eꞌuc, ta xcalbe Jtot schiꞌuc li yajꞌangeltaque ti muc bu yichꞌojicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Li buchꞌutic chopol ta xcꞌopojic ta jtojol, joꞌon li coꞌol crixchanoutique, ta to spasbatic perton yuꞌun Dios ti mi tscꞌanbeique. Jaꞌ noꞌox li buchꞌutic chopol ta xcꞌopojic ta stojol li Chꞌul Espíritue, muc xa bu ta spasbatic o perton sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cꞌalal chaꞌaqꞌueic ta scꞌob li jꞌabteletic li ta chꞌulnaetique, mu me xcꞌopoj avoꞌonic ti cꞌusi chavalique schiꞌuc li cꞌu sba chatacꞌavique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yuꞌun jaꞌ tsjules ta ajolic li Chꞌul Espíritue ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oy jun vinic te cacal ta oꞌlol crixchanoetic, jech laj yalbe li Jesuse: ―Jchanubtasvanej, albo li jbanquil ti acꞌo svocꞌbun li yosil li ánima jtotcutique, schiꞌuc nojtoc li cꞌustic oy yuꞌun toꞌoxe ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Li Jesuse jech itacꞌav: ―Tata, maꞌuc cabtel ta jmeltsan acꞌopic yuꞌun muc bu yacun ta meltsanejcꞌop ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Li Jesuse jech laj yalbe scotolic: ―Qꞌuelo me abaic, mu me xapichꞌ o avoꞌonic li cꞌustic oy liꞌ ta balumile. Manchuc mi oy cꞌusi ep chataic pero maꞌuc noꞌox me xamuybajic o ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Li Jesuse jech laj yal ta loꞌil: ―Oy jun vinic lec jcꞌulej. Lec iyacꞌ scotol li cꞌustic la stsꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jech la snop: “¿Cꞌu sba ta xcut? Mu xa jnaꞌ bu ta jticꞌ li cꞌustic ilocꞌ ta cosile”, xi ta yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tsꞌacal to jech la snop: “Jnaꞌ xa cꞌusi ta jpas. Jaꞌ ta jines li snail li bu cacꞌoj li cꞌustic oy cuꞌune, ta jvaꞌan más mucꞌ. Jaꞌ te ta jticꞌ scotol li cꞌustic oy cuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi la stsob sba cuꞌun scotole, tsꞌacal xuꞌ jech ta xcal ta coꞌon: Oy xa ep jveꞌel ta sventa jayib jabil jech xuꞌ ta jcux. Yuꞌun la jta xa scotol li cꞌustic ta scꞌan coꞌone. Xuꞌ ta jveꞌ, xuꞌ ta xcuchꞌ jech ximuybaj noꞌox, xichi”, xi la snop li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Cꞌalal jech snopoj ta spase, jech iꞌalbat yuꞌun li Diose: “Mu xanaꞌ snopel. Ta acꞌubal tanae chacham. Li cꞌustic oy avuꞌune ¿buchꞌu ta sbalin yaꞌel?” xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaꞌ jech scꞌoplal li buchꞌu jaꞌ noꞌox ta scꞌan ta stsob ep scꞌulejal stuque. Ta stojol li Diose abol sba ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Chacalbeic, mu me xcꞌopoj o avoꞌonic ti cꞌusi chacuxiic o liꞌ ta balumile, jaꞌ ti bu chata aveꞌel avuchꞌobique, schiꞌuc nojtoc ti bu chata acꞌuꞌ apacꞌalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yuꞌun jaꞌ laj yacꞌboxuc abecꞌtalic acuxlejalic li Diose, jech nojtoc chacꞌ aveꞌelic acꞌuꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Qꞌuelavilic li jojetique, mu snaꞌic abtel. Mu snaꞌ xꞌovolajic, mu snaꞌ xcꞌajavic, muꞌyuc snail li sveꞌelique. Macꞌlanbilic noꞌox yuꞌun li Jtotic Diose. Pero li joꞌoxuque más to chascꞌuxubinic li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Altic ti chcꞌopoj avoꞌonique, maꞌuc me ta xnatub o acꞌacꞌalic avorailic liꞌ ta balumil ti jech chcꞌopoj avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Maꞌuc jsetꞌ mu cꞌusi xuꞌ avuꞌunic. Altic chcꞌopoj o avoꞌonic ti cꞌustic ta xtun avuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Qꞌuelavilic li nichimetic li ta xchꞌiic ta yaxaltique. Muꞌyuc yoc scꞌobic. Mu snaꞌ xꞌabtejic, mu snaꞌ spasel scꞌuꞌic, pero lec cꞌupil sbaic. Chacalbeic, li Salomón ta voꞌonee toj jcꞌulej, lec cꞌupil sba li scꞌuꞌ spacꞌale, pero mu xcoꞌolaj schiꞌuc jech chac cꞌu chaꞌal li nichimetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Li tsꞌiꞌleletique lec cꞌupil sba syaxal, pero ta schibal yoxibal cꞌacꞌale taquinic xaꞌox. Jaꞌ noꞌox sventa ta stsajubtasic o sjornoal pan. Acꞌo mi muc bu jal ta xchꞌi li tsꞌiꞌlele pero lec cꞌupil sba syaxal acꞌbil yuꞌun li Diose. Li joꞌoxuque más to chayacꞌboxuc acꞌuꞌic li Diose pero mu xcꞌot ta avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mu me xcꞌopoj o avoꞌonic ti cꞌusi chalajesic, ti cꞌusi chavuchꞌique. Mu me cꞌusi xcꞌopoj o avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Li buchꞌutic mu to xojtaquinic li Diose jaꞌ jech ta xcꞌopoj yoꞌonic. Pero li Jtotic Dios ta vinajele jaꞌ snaꞌoj stuc scotol li cꞌustic ta xtun avuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jaꞌ yuꞌun scꞌan ti chavacꞌ abaic ta scꞌob li Diose, jech chayacꞌboxuc scotol li cꞌustic scꞌan avuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Acꞌo mi muc bu epoxuc, acꞌo mi mu cꞌusi xuꞌ avuꞌunic pero mu me xaxiꞌic. Yuꞌun li Diose ta slequil yoꞌon snopoj ti coꞌol chapasic mantal schiꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chonic scotol li cꞌustic oy avuꞌunique. Li stojole acꞌbeic li meꞌonetique jech oy acꞌulejalic te ta vinajel. Muꞌyuc slajeb sbatel osil, yuꞌun li teye muꞌyuc jꞌelecꞌ schiꞌuc muꞌyuc chon ti chlajesune. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yuꞌun mi te oy acꞌulejalique, jaꞌ te batem o avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Vicꞌluc me asatic, aqꞌuic me ta ilel scotol cꞌacꞌal ti amalaojic cꞌu ora chital, joꞌon ti Avajvalicune. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Scꞌan ti jechoxuc jech chac cꞌu chaꞌal li jtuneletic ti smalaojic cꞌu ora ta sut talel li yajvalic li batem ta sqꞌuinal nupunele. Cꞌalal ta xcꞌot cꞌopojuque, ta sjambeic ta ora stiꞌ sna ti acꞌo ochuc li yajvalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Li jtuneletic ti viqꞌuil sat ta xcꞌot taaticuc yuꞌun li yajvalique xmuybajic noꞌox. Melel li cꞌusi chacalbeique, li jtuneletic ti viqꞌuil satic ta xcꞌot taaticuque, ta xꞌalbatic yuꞌun li yajvalic ti acꞌo ba chotiicuc ta mexae, ta xꞌacꞌbat sveꞌelic yuꞌun li yajvalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Manchuc mi ta oꞌlol acꞌubal, mi ta poꞌot sacub ta xcꞌot, mi jech viqꞌuil o satic chcꞌot taaticuc yuꞌun li yajvalique, lec ta xꞌileic o. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Naꞌic me, jech chac cꞌu chaꞌal yajval na ti mu snaꞌ mi ta xtal jꞌelecꞌ ta acꞌubaltique. Ti snaꞌojuque, mu xꞌoch svayel ti jechuque. Mu cꞌusi ta xbat ta elcꞌanel yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jaꞌ jech li joꞌoxuque, scꞌan ti vicꞌluc asatique yuꞌun mu xanaꞌic li cꞌu ora chichaꞌtal, joꞌon li coꞌol crixchanoutique. Mu me chꞌayluc avoꞌonic chjul jtaoxuc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Li Pedroe jech la sjacꞌbe li Jesuse: ―Cajval, li loꞌil la avale, ¿mi jtuc noꞌox jcꞌoplalcutic, mi jaꞌ scꞌoplalic eꞌuc li yanetic li liꞌ oyique? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Li Cajvaltique jech laj yal: ―Jaꞌ scꞌoplal scotol li buchꞌutic chtunic cuꞌune. Li buchꞌu lequil jtunele jun yoꞌon ta xꞌabtej ta stojol li yajvale. Yuꞌun pꞌij ta xꞌile yuꞌun li yajvale, ta xꞌacꞌbat yabtel ti jaꞌ ta smacꞌlan schiꞌiltac ta abtel li cꞌalal ta sta yora chveꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Xmuybaj noꞌox li jtunel ti jun yoꞌon yacal tspasel chjul taatuc yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Melel li cꞌusi chacalbeique, li buchꞌu ti jun yoꞌon ta xꞌabteje ta xꞌacꞌbat sventain scotol li cꞌustic oy yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero mi jech chlic yal ta yoꞌon li jtunele: “Mu to nan xtal ta ora li cajvale”, mi xie, jech chlic yutan chlic smajan li schiꞌiltac ta abtel ti acꞌbil sventaine. Jaꞌ chba schiꞌinan ta veꞌel li buchꞌutic jyacubeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Li yajvale jaꞌ o chjul talel li cꞌalal chꞌayal o yoꞌon ti cꞌusiuc noꞌox ta spasbe li schiꞌiltaque yuꞌun mu schꞌun ti poꞌot xa chtal li yajvale. Chjul acꞌbatuc yichꞌ tsots vocol yuꞌun li yajvale. Jaꞌ te chba schiꞌin li buchꞌutic coꞌol mu schꞌunic mantale. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Li jtunel ti snaꞌ li cꞌustic tscꞌan li yajvale pero mi mu spase, ta xichꞌ tsots vocol. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yan li buchꞌu mu snaꞌ li cꞌustic tscꞌan li yajvale, schiꞌuc mu snaꞌ mi ta xichꞌ vocol ta scoj li cꞌustic ta spase, jaꞌ mu sta jech chichꞌ vocol. Li buchꞌu ta xꞌacꞌbat ep spꞌijil yuꞌun li yajvale, jaꞌ yuꞌun jaꞌ scꞌan ti ep acꞌo abtejuc yuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Li joꞌone coꞌol schiꞌuc tal jticꞌ cꞌocꞌ yaꞌel liꞌ ta balumile. Jech chac cꞌu chaꞌal oy cꞌusi tsmeltsaj yuꞌun li cꞌoqꞌue, oy cꞌusi chchꞌay o ta jꞌechꞌel yuꞌun, jaꞌ noꞌox jechun eꞌuc, ta jventa joꞌon ta xtuqꞌuibic li buchꞌutic ta schꞌunic ti joꞌon Yajcoltavanejicune. Li buchꞌutic mu scꞌan schꞌunique ta soquic o. Jaꞌ yuꞌun soquem o sjolic ta jtojol li avie. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero más to ep ta xquichꞌ vocol. Ti cꞌotemuc xa ta pasel scotol li cꞌu yepal albil ta xquichꞌe, mu xa jnopilan ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Mi chavalic ti tal jpasbeic ta jmoj yoꞌonic li crixchanoetic liꞌ ta balumile? Jamal chacalbeic, muc bu tal jpasbeic ta jmoj yoꞌonic. Ta jventa joꞌon chlic scontrain sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yuꞌun ta xcꞌot ta pasel ti tspasic ta chaꞌvocꞌ li joꞌvoꞌic ta snailique. Mi chaꞌvoꞌ lec chiyilique, oxvoꞌ chopol chiyilic; mi oxvoꞌ lec chiyilique, chaꞌvoꞌ chopol chiyilic. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta jventa joꞌon chlic scontrain snichꞌon. Oy nichꞌonil chlic scontrain stot. Oy meꞌil chlic scontrain stseub. Oy tseub chlic scontrain smeꞌ. Oy meꞌalibal chlic scontrain yalib. Oy alibal chlic scontrain smeꞌalib ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Li Jesuse jech laj yalbe nojtoc li epal crixchanoetique: ―Cꞌalal chavilic ta xlocꞌ talel toc ta smaleb cꞌacꞌale, jech chavalic: “Ta xtal joꞌ tana”, xachiic. Ta melel chtal li joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cꞌalal chavaꞌiic chtal icꞌ ta xocon vinajel ta sure, jech chavalic: “Toj qꞌuixin tana”, xachiic. Ta melel qꞌuixin. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jloꞌlovanejoxuc. Xanaꞌic sqꞌuelel li cꞌu sba ta vinajele schiꞌuc li ta balumile, pero jaꞌ mu xanaꞌic sqꞌuelel ti avalojic li cꞌustic lec ti cꞌotem xa ta pasel ta atojolic li avie. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Cꞌu chaꞌal mu xanaꞌic li cꞌusi lec ta pasele? ");
INSERT INTO tzoSA_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mi oy ata amulic ta stojol la achiꞌilique, jaꞌ scꞌan ti chameltsanbeic scꞌoplal ta orae. Yuꞌun mi muc bu smeltsaj la acꞌopique, chayacꞌ ta scꞌob li jꞌabteletique. Li jꞌabteletique chayacꞌ ta scꞌob mayoletic. Li mayoletique chastiqꞌuic ta chuquel. ");
INSERT INTO tzoSA_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chacalbeic, mi mu xapasic jech chac cꞌu chaꞌal laj calboxuque, scotol chayacꞌbeic atojic li jꞌabteletique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ta scꞌacꞌalil noꞌox li cꞌalal te to stsoboj sbaique, oy buchꞌutic laj yalbeic Jesús li cꞌu sba imile jayvoꞌ jꞌisraeletic li liquemic talel ta Galileae. Jaꞌ li iꞌaqꞌueic ta milel yuꞌun Pilato li te ta yamaqꞌuil li mucꞌta chꞌulna li ta Jerusalén li cꞌalal jaꞌ o te yacal ta smilbeic smoton li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Li Jesuse jech laj yalbe: ―¿Mi chanopic ti muꞌyuc yan jchiꞌiltic ta Galilea ta voꞌone schiꞌuc cꞌalal to tana ti más ep smulic jech chac cꞌu chaꞌal más ep smulic ti avalojic li jchiꞌiltactic li imileic chavalique? ");
INSERT INTO tzoSA_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chacalbeic, mu jechuc li cꞌusi chanopique. Coꞌol onoꞌox chachꞌayic o sbatel osil mi mu xavictaic eꞌuc li cꞌustic chopol chapasique. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Li vaxaclajunvoꞌ ti ichamic li cꞌalal ijin yalel li na sventa qꞌuelob osil li te ta nopol stanqueal joꞌ Siloee, ¿mi chanopic ti muꞌyuc yan jchiꞌiltic ta Jerusalén ta voꞌone schiꞌuc cꞌalal to tana ti más ep smulic jech chac cꞌu chaꞌal más ep smulic ti avalojic li jchiꞌiltactic li ichamique? ");
INSERT INTO tzoSA_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chacalbeic, muc bu jech li cꞌusi chanopique. Coꞌol onoꞌox chachꞌayic o sbatel osil mi mu xavictaic eꞌuc li cꞌustic chopol chapasique ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Li Jesuse la scoꞌoltajes jech chac cꞌu chaꞌal jtecꞌ higo li jꞌisraeletique. Jech laj yal: ―Oy jun vinic stsꞌunoj jtecꞌ higo ta tsꞌunbaltic. Tsꞌacal to ba sqꞌuel mi oy sat li teꞌel higo ti stsꞌunoje pero muꞌyuc sat ista. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jech laj yalbe li yajchabiejtsꞌusube: “Li teꞌel higo liꞌi yoxibal xa jabil liꞌ chtal jqꞌuelulan mi ta satine, pero mu snaꞌ satin. Jaꞌ lec tsꞌeto, yuꞌun altic liꞌ smacoj balumile”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Itacꞌav li yajchabiejtsꞌusube: “Cajval, liꞌ to oyuc junuc jabile. Ta jlocbe lec sjoyobal li yoque. Ta xcacꞌbe lec syaxal. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mi jech ta jpase, ta nan xlic satinuc. Mi mu satine, jaꞌ to xuꞌ ta xichꞌ tsꞌetel”, xi li yajchabiejtsꞌusube ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ta yan o cꞌacꞌal ichanubtasvan Jesús ta yut jun chꞌulna. Jaꞌ scꞌacꞌalil o ta xcuxic li jꞌisraeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te oy jun ants vaxaclajuneb (18) xa jabil tsacbil ta chamel yuꞌun isocbat sbaquil yuꞌun pucuj. Xpatpun chanav, mu xuꞌ stuqꞌuibtas sba. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Li Jesuse iyil li antse, laj yicꞌ talel ta stojol. Jech laj yalbe: ―Yaa, chacol ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Li Jesuse laj yacꞌbe scꞌob ta sba li antse, ituqꞌuib ta ora li sbaquile, lic yal coliyal Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Li banquilal li te ta chꞌulnae iꞌilin li cꞌalal icoltavan Jesús ta scꞌacꞌalil ta xcuxique. Jech lic yalbe li schiꞌiltaque: ―Oy vaquib cꞌacꞌal xuꞌ chijꞌabtejutic. Ta scꞌacꞌalil ti xuꞌ chijꞌabtejutique jaꞌ o xatalic mi chacꞌanic coltaele. Mu me xatalic li ta scꞌacꞌalil ta jcuxtique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Itacꞌav li Cajvaltique: ―Jloꞌlovanejoxuc. Li jujunoxuque ¿mi mu xajitun batel avacax, mi acaaꞌ cꞌusi, ta scꞌacꞌalil ta jcuxtic yoꞌ acꞌo ba yuchꞌic joꞌ? ");
INSERT INTO tzoSA_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Li ants liꞌi ti svaxaclajunebal xa jabil tsacbil ta chamel yuꞌun li Satanase, jaꞌ jchiꞌiltic, pero chopol avaꞌiic ti ijcolta ta scꞌacꞌalil ta jcuxtique ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cꞌalal jech laj yal li Jesuse, iqꞌuexavic scotol li buchꞌutic chopol chilic li Jesuse. Pero ep crixchanoetic xmuybajic noꞌox yuꞌun iyilic ti toj lec scotol li cꞌustic la spas li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Li Jesuse jech laj yal jun loꞌil: ―Chacalbeic li cꞌu sba ta sventainan crixchanoetic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Acꞌo mi muc bu ep li buchꞌutic ta xventainatic li avie pero ta tsꞌacale ta xꞌepaj. Jaꞌ jech chac cꞌu chaꞌal li becꞌ mustasa ti la stsꞌun ta yosil jun vinique ti toyol ibate. Laj yacꞌ ep scꞌob. Ital mutetic, la spas stasic ta scꞌobtac ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Laj yal yan loꞌil li Jesuse. Jech laj yal: ―Chacalbeic li cꞌu sba ta sventainan crixchanoetic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oy lec stsatsal jech chac cꞌu chaꞌal svochesobil pan. Li jucub cuartia harinae, manchuc mi jutuc noꞌox chacꞌbe scap li antse, pero lec ta xvoch o spꞌejel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Li Jesuse ixanavic batel ta be schiꞌuc yajchanbalajeltac yuꞌun ta xbatic ta Jerusalén. Echꞌ chanubtasvanuc ta scotol jteclumetic schiꞌuc ta coloniaetic li bu ijelave. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oy buchꞌu jech la sjacꞌ: ―Cajval, ¿mi atbil noꞌox li buchꞌutic ta xcolique? ―xi. Itacꞌav li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Jaꞌ biqꞌuit li sbelel li cuxlejal sventa sbatel osile. Ep li buchꞌutic tscꞌan tstamique pero chacalbeic ti mu xuꞌ yuꞌunique. Yuꞌun jaꞌ noꞌox xuꞌ ta stamic li buchꞌutic ta sbicꞌtajes sbaic ta stojol li Diose. Jaꞌ yuꞌun bicꞌtajeso me abaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jech chac cꞌu chaꞌal mi la smac xa tiꞌna li yajval nae, mi tsꞌacal to chtal atijic li tiꞌnae, jech chavalbeic: “Cajval, Cajval, jambuncutic li tiꞌnae”, xavutic. Pero jech chayalbeic li yajval nae: “Maꞌuc jnichꞌnaboxuc”, xayutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jech chavalbeic: “La jchiꞌinotcutic ta veꞌel, la achanubtasuncutic ta jteclumalcutic”, xavutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jech chayalbeic: “Laj calboxuc xa ti maꞌuc jnichꞌnaboxuque. Batanic, mu xajcꞌanic yuꞌun naca chopol li cꞌustic la apasique”, xayutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","Chavilic ti te xa ochemic li yoꞌ bu ta spas mantal Dios li jtotic jmeꞌtic ta voꞌonee, jaꞌ li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove, schiꞌuc scotol li buchꞌutic iyalic scꞌop Dios ta voꞌonee, schiꞌuc ep jyanlum crixchanoetic li liquemic talel ta spꞌejel balumile. Xmuybajic noꞌox. Li joꞌoxuque te xaꞌoqꞌueletic o, te xcꞌuxuxet o aveic ta scoj ti mu xa xuꞌ chaꞌochique. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aꞌiic, oy buchꞌutic itsꞌinal ta xꞌileic li avie, jaꞌ banquilal chcomic yuꞌun la sbicꞌtajes sbaic. Pero oy buchꞌutic banquilal spꞌisoj sbaic li avie, jaꞌ itsꞌinal chcomic yuꞌun la stoy sbaic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ital ta ora jayvoꞌ jfariseoetic. Jech laj yalbeic li Jesuse: ―Locꞌan batel yuꞌun chac smilot li Herodese ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Li Jesuse jech laj yalbe: ―Li Herodese jaꞌ jech chac cꞌu chaꞌal jcot vet yuꞌun chtiꞌvan yaꞌel. Batanic, jech xcꞌot avalbeic: “Li avie schiꞌuc ocꞌobe ta to jloqꞌues pucujetic, ta to jcolta jchamelajeletic. Chaꞌej ta xlaj coꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Persa chixanav batel li avie schiꞌuc ocꞌob chaꞌej. Yuꞌun te chimile ta Jerusalén jech chac cꞌu chaꞌal te imileic li buchꞌutic yan iyalic scꞌop Diose, xijyutcutic talel”, utic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Joꞌoxuc schiꞌuc scotol la achiꞌiltac li te ta Jerusalene, atalelic o ti chamilic li buchꞌutic chalic li scꞌop Diose. Chavacꞌbeic ton li buchꞌutic tacbilic talel yuꞌun Dios liꞌ ta atojolique. Pero ep xa ta velta la jcꞌan jtsoboxuc jech chac cꞌu chaꞌal ta stsob yol ta yolon xicꞌ jcot meꞌcaxlane, pero mu xacꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aꞌiic, toj abol abaic chacomic. Muc xa bu liꞌ achiꞌuquic li Diose. Jech chacalbeic, muc xa bu chavilicun o. Jaꞌ to mi icꞌot scꞌacꞌalil ti jech chavalique: “Toj lec li buchꞌu tacbil talel yuꞌun li Cajvaltic Diose”, mi xachiique, jaꞌ to chavilicun nojtoc ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cꞌalal jaꞌ o scꞌacꞌalil ta xcuxic li jꞌisraeletique, li Jesuse iꞌiqꞌue batel ta veꞌel yuꞌun jun banquilal jfariseo. Li yan schiꞌiltac ta fariseoale te italic eꞌuc yuꞌun ta sqꞌuelic li cꞌustic ta spas li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cꞌalal iꞌoch ta na li Jesuse, te ista jun vinic situbem sjunul sbecꞌtal. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Li Jesuse jech la sjacꞌbe li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li jfariseoetique: ―¿Mi xuꞌ ta jcoltatic jchamelajeletic ta scꞌacꞌalil ta jcuxtique? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Muc bu xtacꞌavic. Li Jesuse la scolta li vinic ti situbem sbecꞌtale. Laj yalbe nojtoc ti acꞌo sutuc batele. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Li Jesuse jech la sjacꞌbe li jfariseoetique: ―Li joꞌoxuque, mi oy bu itsꞌuj ta chꞌen jcotuc aburroic, mi jcotuc avacaxic ta scꞌacꞌalil ta jcuxtique, ¿mi muc chba aloqꞌuesic talel yaꞌel? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Muc bu xtacꞌavic li cꞌalal jech laj yal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cꞌalal iyil Jesús ti buchꞌutic icꞌbilic ta veꞌele ta scꞌan ta xchotiic li bu tꞌujbil chotlebale, jech laj yal ta loꞌil: ");
INSERT INTO tzoSA_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Mi oy buchꞌu chayiqꞌuic ta sqꞌuinal nupunele, mu me xba achotan abaic li bu tꞌujbil chotlebale yuꞌun naca me oy buchꞌu ichꞌbil lec ta mucꞌ ti icꞌbil talel ta qꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jaꞌ chlic yalboxuc li buchꞌu iꞌicꞌvane: “Locꞌan, yuꞌun jaꞌ liꞌ ta xchoti li jchiꞌiltic liꞌi”, xayutic. Jech xaqꞌuexetic xa li cꞌalal chba chotlanic ta slajeb li chotlebale. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cꞌalal chaꞌiqꞌueic ta veꞌele, jaꞌ lec ba chotlanic ta slajeb chotlebal. Cꞌalal chtal li buchꞌu laj yicꞌoxuque, jech chayalbeic: “Tata, liꞌ xatal ta tꞌujbil chotlebale”, xayutic. Jech scotol li buchꞌutic te chotolic ta mexa achiꞌuque ta xilic ti ichꞌbiloxuc ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yuꞌun li buchꞌutic ta scꞌan ti ichꞌbilic ta muqꞌue, ta xbicꞌtajeseic yuꞌun li Diose. Yan li buchꞌutic ta sbicꞌtajes sbaique jaꞌ ta xꞌaqꞌueic ta ichꞌel ta mucꞌ yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Li Jesuse jech laj yalbe eꞌuc li buchꞌu iꞌicꞌvan ta veꞌele: ―Cꞌalal chaꞌicꞌvan ta veꞌele, mu me jaꞌuc noꞌox xavicꞌ li buchꞌutic lec xacꞌopon aba achiꞌuque, schiꞌuc la achiꞌiltac ta voqꞌuele, schiꞌuc la avutsꞌ avalaltaque, schiꞌuc la alacꞌnatac ti jcꞌulejique. Oy me yicꞌal chayicꞌ ta veꞌel eꞌuc, chaspacbe ti laj avicꞌ ta veꞌele. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cꞌalal chaꞌicꞌvan ta veꞌele, jaꞌ xavicꞌ li meꞌonetique, schiꞌuc li muꞌyuc scꞌobique, schiꞌuc li pecꞌaetique, schiꞌuc li coxoetique, schiꞌuc li maꞌsatetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jech chayacꞌbe slequilal yutsilal li Diose yuꞌun mu xuꞌ ta spaquic sutel. Chavichꞌ atojolic nojtoc li cꞌalal coꞌol chachaꞌcuxiic achiꞌuc li buchꞌutic lec tucꞌ yoꞌonique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cꞌalal jech iyaꞌiic li buchꞌutic te ta xveꞌic eꞌuc ta mexa schiꞌuc li Jesuse, oy buchꞌu jech laj yalbe li Jesuse: ―Xmuybajic noꞌox li buchꞌutic jech ta schiꞌinic ta veꞌel li cꞌalal chtal spas mantal li buchꞌu tꞌujbil yuꞌun li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Li Jesuse jech laj yal ta loꞌil: ―Oy jun vinic iyacꞌ veꞌel. La stac ta iqꞌuel ep crixchanoetic acꞌo tal veꞌicuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cꞌalal ista yora ta xveꞌique, la stac batel yajtunel acꞌo ba yicꞌan talel li buchꞌutic yalanojbe xa onoꞌoxe. Jech laj yalbe batel: “Ba albo li buchꞌutic calanojbee acꞌo taluc scotolic yuꞌun imeltsaj xa li veꞌlile”, xut batel li yajtunele. Jaꞌ jech cꞌot yal li yajtunele. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero scotolic iyalic ti oy bu chbatique. Li june jech laj yal: “Mu xuꞌ chibat yuꞌun jaꞌ to la jman cosil jech persa chba jqꞌuel. Avocoluc albo acꞌo spasbun perton”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Li yane jech laj yal: “Mu xuꞌ chibat yuꞌun jaꞌ to la jman lajuncot jꞌabtel vacax. Jaꞌ chba jqꞌuel mi lec xꞌabtejic. Avocoluc albo acꞌo spasbun perton”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Li yane jech laj yal: “Mu xuꞌ chibat yuꞌun jaꞌ to linupun”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cꞌalal isut talel li yajtunele, laj yalbe yajval li cꞌu sba itacꞌav li jujunique. Li yajval veꞌlile iꞌilin. Jech laj yalbe li yajtunele: “Batan ta anil ta chꞌivit schiꞌuc ta cayaetic li liꞌ ta jteclume. Jaꞌ ba icꞌano talel li meꞌonetique, schiꞌuc li pecꞌaetique, schiꞌuc li muꞌyuc scꞌobique, schiꞌuc li coxoetique, schiꞌuc li maꞌsatetique”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Li jtunele la schꞌun li cꞌusi iꞌalbat yuꞌun li yajvale. Tsꞌacal to jech tal yalbe li yajvale: “Cajval, ijchꞌun xa scotol li cꞌusi la avalbune. Italic xa li crixchanoetique, pero oy to ep xocol li veꞌlile”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Li vinique jech laj yalbe li yajtunele: “Batan xa ta bebetic schiꞌuc ta sbelel trigotic. Ba icꞌano talel ta persa li buchꞌutic chatae. Jaꞌ lec mi inoj li jnae. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chacalbe, scotol li buchꞌutic baꞌi laj calbe ti acꞌo tal veꞌicuque, mu junuc chcacꞌbe xa yaꞌibeic smuil li veꞌlile”, xi li yajval veꞌlile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cꞌalal ixanav batel li Jesuse, ichiꞌinat batel yuꞌun epal crixchanoetic. Li Jesuse ijoypꞌij, jech laj yalbe: ");
INSERT INTO tzoSA_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Li buchꞌu chischiꞌine jaꞌ scꞌan ti joꞌon más cꞌuxun ta yoꞌone. Jaꞌ scꞌan ti mu másuc cꞌux ta yoꞌon li stot smeꞌe, schiꞌuc yajnil, schiꞌuc snichꞌnab, schiꞌuc sbanquiltac, schiꞌuc yitsꞌinabtac, schiꞌuc svixobtac, schiꞌuc yixleltac. Scꞌan nojtoc ti mu másuc ta snop li cꞌu sba ta xcuxi liꞌ ta balumile. Jaꞌ jech xuꞌ chischiꞌin. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Li buchꞌu junucal ti mu scꞌan xichꞌ vocol jech chac cꞌu chaꞌal ta xquichꞌ vocole, mu xuꞌ chtal ta jtojol. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jech chac cꞌu chaꞌal mi oy buchꞌu ta spas smucꞌta na ti ep ta coje, baꞌi ta snop li cꞌu yepal taqꞌuin ta xlaj yuꞌun scotole. Ta snop nojtoc jaycoj ta spas, yuꞌun ta snop mi stsuts yuꞌun li cꞌu smucꞌul ta spase. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yuꞌun mi mu snop lec baꞌie, cꞌalal mi la sliquesbe xa yoque, ta tsꞌacal ta xil ti mu stsuts yuꞌune, ta squechan. Ta xlic labanatuc yuꞌun scotol li buchꞌutic ta xilique. Jech ta xalic: ");
INSERT INTO tzoSA_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Qꞌuelavil li vinique, la sliquesbe svaꞌanel li snae pero muc bu stsuts yuꞌun”, xi scꞌoplal. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jech nojtoc, mi oy jun ajvalil chba spasic cꞌop schiꞌuc yan ajvalile, baꞌi ta snop mi xuꞌ ta spas ta canal li buchꞌu ta spasic cꞌop schiꞌuque ti ta lajunmil noꞌox yajsoltaro ti jaꞌ jtob ta mil yajsoltaro li yajcontrae. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mi iyil ti mu xuꞌ yuꞌune, cꞌalal nom to xtal li yajcontrae, ta stac batel schiꞌil ta abtel acꞌo ba slequilcꞌopon li yajcontrae, yoꞌ acꞌo pasuc ta jmoj yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jaꞌ noꞌox jech eꞌuc li joꞌoxuque, mi oy buchꞌu mu scꞌan xicta scotol li cꞌustic oy yuꞌune, mu xuꞌ chischiꞌin o. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Jech chac cꞌu chaꞌal li atsꞌam ti lec ta xtun cuꞌuntique, pero mi ichꞌay xa schiꞌile, mu xa cꞌusi xtun o yuꞌun mu xa xchaꞌchiꞌub nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pero mi chiꞌ toe, ta xtun ta sventa veꞌlil. Ta xtun nojtoc ta sventa syaxal balumil. Pero mi ichꞌay xa schiꞌile, mu xa cꞌusi xtun o. Acꞌo mi ta syaxal balumil mu xa xtun. Ta xichꞌ jipel batel o. Jaꞌ noꞌox jech eꞌuc li buchꞌutic chischiꞌinique, mi mu ta jꞌechꞌeluc jun yoꞌonic ta jtojole, mu xtunic o cuꞌun. Li joꞌoxuc ti avaꞌiique nopbeic lec smelol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","La stsob sbaic talel ta stojol Jesús jtsobpatanetic schiꞌuc yan crixchanoetic ti chopol scꞌoplalic eꞌuque, yuꞌun ta scꞌan ta xaꞌibeic scꞌop li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Li buchꞌutic ti spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc li jfariseoetique, chopol iyilic. Jech laj yalic: ―Li vinic liꞌi jaꞌ ta xicꞌan ta stojol li buchꞌutic chopol li cꞌustic ta spasique. Ta schiꞌin ta veꞌel nojtoc ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Li Jesuse jech laj yalbe jun loꞌil: ");
INSERT INTO tzoSA_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿Cꞌusi chanopic? Mi oy jun vinic ti oy joꞌvinic (100) ta cot schije, pero mi ichꞌay comel jcotuque, ¿mi mu teuc lamal chicta li yoꞌ bu oy lec sveꞌelic li balunlajuneb yoꞌvinic (99) ta cote ti chba saꞌ talel li jcot ti ichꞌaye? ");
INSERT INTO tzoSA_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cꞌalal mi la sta li jcote, xmuybaj xa, ta scajan talel ta snequeb. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cꞌalal chjul ta snae, ta xicꞌ talel scotol li yutsꞌ yalaltaque schiꞌuc li slacꞌnataque, jech chalbe: “Muybajanic me yuꞌun ijta xa li jcot jchij ti ichꞌay toꞌoxe”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chacalbeic, jaꞌ noꞌox jech eꞌuc li Diose, xmuybaj noꞌox ta sventa li cꞌu yepal oy ta stojole. Pero más to xmuybaj schiꞌuc li yajꞌangeltac mi oy jun crixchano ta xicta li cꞌustic chopol tspase. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Mi oy jun ants ti oy lajunsep saquil taqꞌuine, mi ichꞌay jsepuc yuꞌune, ¿mi mu stsan stoj schiꞌuc mi mu smes lec sna yoꞌ ta saꞌ lec li jsep saquil taqꞌuin ti ichꞌay yuꞌune? ");
INSERT INTO tzoSA_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mi istae, ta xicꞌ talel scotol li yutsꞌ yalaltaque schiꞌuc li slacꞌnataque, jech chalbe: “Muybajanic me yuꞌun ijta xa li jsep saquil taqꞌuin li chꞌayem toꞌox cuꞌune”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chacalbeic, jaꞌ noꞌox jech eꞌuc li Diose, xmuybaj schiꞌuc li yajꞌangeltac mi oy jun crixchano ta xicta li cꞌustic chopol tspase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Li Jesuse jech laj yal nojtoc: ―Oy jun vinic chaꞌvoꞌ snichꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Li itsꞌinale jech laj yalbe li stote: “Tata, acꞌbun li cꞌu yepal anopoj ti chavacꞌbune”, xut. Li totile la svocꞌbe li cꞌu yepal snopoj chacꞌbe li jujun snichꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cꞌalal iꞌechꞌ chib oxib cꞌacꞌale, li itsꞌinale la stsob scotol li cꞌustic oy yuꞌune, ilocꞌ batel, ibat ta yan o balumil. Te la slajes scotol li cꞌustic oy yuꞌune yuꞌun jaꞌ ibat ta yoꞌon li cꞌustic ta scꞌan yoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cꞌalal ilaj scotol li staqꞌuine, iꞌechꞌ tsots viꞌnal li bu nacale. Iyaꞌi viꞌnal eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jaꞌ yuꞌun ibat ta jtunel ta sna jun vinic li te noꞌox nopol nacale. Li vinique la spas ta mantal li quereme, la stac batel acꞌo ba chabibatuc schitom. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Li quereme ta xviꞌnaj tajmec jech chac sloꞌ eꞌuc li vaxe, jaꞌ li sveꞌel li chitometique. Pero mu cꞌusi iꞌacꞌbat slajes yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Cꞌalal jech oy svocol ta viꞌnale, jech la snopilan: “Oy ep yajtunel li jtote pero lec noj schꞌutic scotolic. Oy to ta xcom yuꞌunic. Li joꞌone chicham xa ta viꞌnal. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jaꞌ más lec chisut batel nojtoc ta sna li jtote. Jech chcꞌot calbe: Tata, ijta xa jmul ta stojol li Diose schiꞌuc ijta xa jmul ta atojol eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jaꞌ lec mu xa xapꞌisun ta anichꞌon. Pꞌisun ta avajtunel noꞌox, xcut cꞌotel”, xi la snop ta yoꞌon li quereme. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Isut batel ta sna stot. ’Cꞌalal nom toꞌox xtale, iꞌile yuꞌun li stote. Li totile iyil ti isut to talel li snichꞌone. Xmuybaj xa tajmec ba snup ta be ta ora, la smey, la stsꞌutsꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jech iꞌalbat yuꞌun li snichꞌone: “Tata, ijta xa jmul ta stojol li Diose schiꞌuc ijta xa jmul ta atojol eꞌuc. Jaꞌ lec mu xa xapꞌisun ta anichꞌon”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Cꞌalal jech iꞌalbat yuꞌun li snichꞌone, muc bu jech la snop li totile. Jech laj yalbe li yajtuneltaque: “Ichꞌic talel ta ora li cꞌuꞌil li bu toj leque, acꞌbeic slap. Acꞌbeic yaniyoal scꞌob schiꞌuc xonob. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iqꞌuic talel li chꞌiom vacax li bu lec xa jupꞌeme. Milic jtiꞌtic. Yuꞌun ta jpastic qꞌuin. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ical ti chamem xa li jnichꞌone. Li avie ichaꞌcuxi xa yaꞌel. Yuꞌun voꞌone xa ichꞌay. Li avie ijta xa”, xi. Lic spasic li qꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Cꞌalal icꞌot li itsꞌinale, muc toꞌox bu te oy li banquilale yuꞌun batem ta abtel. Cꞌalal isut talele, te xa nopol xtal ta stsꞌel sna, iyaꞌi ti ta spasic qꞌuin li stote. Iyaꞌi ti yacal ta xꞌacꞌotajique. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Laj yicꞌ loqꞌuel jun yajtunelic, la sjacꞌbe cꞌusi sventa li qꞌuin ta spasique. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jech iꞌalbat: “Yuꞌun isut talel la avitsꞌine. La atote la smil li chꞌiom vacax li bu lec xa jupꞌem cuꞌuntique, jaꞌ sventa ti lec isut talel la avitsꞌine”, xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Cꞌalal iyaꞌi jech li banquilale, iꞌilin. Mu scꞌan xꞌoch ta sna. Cꞌalal iyaꞌi li stote, locꞌ yalbe ti acꞌo ochuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Li banquilale jech laj yalbe li stote: “Ep xa jabil liꞌabtej avuꞌun. Muc bu la jpꞌaj amantal. Pero mu cꞌusi avacꞌojbun. Mu jcotuc tentsun avacꞌojbun ti jech ta jpas o qꞌuin jchiꞌuc li buchꞌutic lec jcꞌopon jba jchiꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero cꞌalal isut talel li quitsꞌine, la amil ta ora li chꞌiom vacax li bu lec xa jupꞌem cuꞌuntique, la apasbe o sqꞌuinal ta sventa ti isut talele. Pero ep jmulivajel antsetic imulivaj schiꞌuc, jaꞌ te ilaj o scotol li cꞌusi la avacꞌbee. Pero jaꞌ cꞌux ta avoꞌon”, xut li stote. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Itacꞌav li stote: “Jnichꞌon, li joꞌote scotol cꞌacꞌal liꞌ jchiꞌuc jbatique. Scotol li cꞌustic oy cuꞌune, jaꞌ avuꞌun eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jaꞌ scꞌan ti jech ta jpastic qꞌuine schiꞌuc ti xijmuybajutique yuꞌun ichaꞌcuxi xa talel yaꞌel la avitsꞌin ti chamem toꞌox ti calojtique. Yuꞌun voꞌone xa ichꞌay pero isut xa talel”, xut ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Li Jesuse jech laj yalbe yan loꞌil li yajchanbalajeltaque: ―Oy jun vinic, lec jcꞌulej. Oy yajchabiejna, jaꞌ yacꞌojbe sventain scotol li cꞌustic oy yuꞌun schiꞌuc staqꞌuin. Oy buchꞌu ba ticꞌbatuc smul li jchabiejnae ta stojol li yajvale. Li smul ti iꞌalbate jaꞌ ti la slajesbe li cꞌustic oy yuꞌun li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Li vinique laj yapta talel li yajchabiejnae, jech laj yalbe: “Icaꞌi ti chopol li cꞌusi chapase. Albun cꞌu yepal la achon schiꞌuc cꞌu to yepal te oy avuꞌun li cꞌustic laj cacꞌbot achabie, yuꞌun mu xa xuꞌ chachabibun jna”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Li jchabiejnae jech la snop ta yoꞌon: “¿Cꞌuxi chiveꞌ mi chisnuts loqꞌuel li cajvale? Mu xuꞌ cuꞌun abtel. Chiqꞌuexav nojtoc mi chicꞌanolaje. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jnaꞌ xa cꞌusi ta jpas cꞌalal mi lilocꞌ ta chabiejnae yoꞌ jech oy buchꞌu chiscꞌuxubinic chiyotesic ta snaic”, xi la snop. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Laj yicꞌ tal ta jujuntal li buchꞌutic oy yilic schiꞌuc li yajvale. La sjacꞌbe li buchꞌu baꞌi itale: “¿Cꞌu yepal avil schiꞌuc li cajvale?” xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Itacꞌav: “Joꞌvinic (100) barril asete quichꞌoj”, xi. Li jchabiejnae jech laj yalbe: “Jato li sjunal avile. Chotlan, tsꞌibao ta achꞌ. Lajuneb noꞌox yoxvinic (50) barril xatsꞌiba”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta tsꞌacale la sjacꞌbe li yane: “Li joꞌote ¿cꞌu yepal la avile?” xut. Itacꞌav: “Joꞌvinic (100) coxtal trigo quichꞌoj”, xi. Li jchabiejnae jech laj yalbe: “Jato li sjunal avile, tsꞌibao ta achꞌ. Chanvinic (80) noꞌox coxtal xatsꞌiba”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Li yajvale jech laj yal: “Li chopol vinique pꞌij. Snaꞌ snopel li cꞌu sba ta xichꞌ cꞌuxubinel li cꞌalal mi ilocꞌ liꞌ ta jnae”, xi li yajvale. Jaꞌ noꞌox jech li buchꞌutic jaꞌ noꞌox batem ta yoꞌonic li cꞌu sba lec ta xꞌechꞌic liꞌ ta balumile, jaꞌ más snaꞌic snopel li cꞌu sba ta scꞌuxubin schiꞌilic yoꞌ jech ta xcꞌuxubinatic eꞌuque. Yan li buchꞌutic yichꞌojic ta mucꞌ Dios ti yalojique, jaꞌ mu snaꞌic snopel cꞌu sba ta scꞌuxubin schiꞌilic yoꞌ jech ta xcꞌuxubinatic yuꞌun Dios eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Li joꞌoxuque chacalbeic, li cꞌustic oy avuꞌunique naca noꞌox acꞌbiloxuc, jech scꞌan chacoltavanic o. Mu me jaꞌ noꞌox batem ta avoꞌonic ti lec chaꞌechꞌic liꞌ ta balumil schiꞌuc li cꞌustic oy avuꞌunique yuꞌun xlaj noꞌox. Mi chacoltavanique, jech chaꞌiqꞌueic ochel ta vinajel sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Li buchꞌu lec ta schabi li cꞌusi ti jutuc noꞌox acꞌbil sventaine, jaꞌ noꞌox jech lec ta schabi mi ep li cꞌusi acꞌbil sventaine. Yan li buchꞌu mu schabi li cꞌusi acꞌbil sventain ti jutuc noꞌoxe, jaꞌ noꞌox jech eꞌuc mu schabi mi acꞌbil sventain epe. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mi jech mu xachabiic li cꞌustic oy avuꞌunic ti jaꞌ noꞌox acꞌbiloxuc yuꞌun Dios sventa chapasic o li cꞌusi ta scꞌane, jech mu xayacꞌbeic li cꞌusi sventa sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yuꞌun li cꞌustic oy avuꞌunic liꞌ ta balumile naca noꞌox yacꞌoj achꞌamunic li Diose. Pero mi mu xavaqꞌuic tunuc yuꞌun li Diose, jech mu xayacꞌbeic li cꞌusi jaꞌ avuꞌunic atuquic ti jaꞌ sventa sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jech chac cꞌu chaꞌal jun jtunel ti mu stacꞌ ti chaꞌvoꞌ yajvale. Ti chaꞌvoꞌuc yajvale, li june chopol chil; li june lec chil. Lec ta xtun yuꞌun li june; jaꞌ mu xtun yuꞌun li june. Jaꞌ noꞌox jech eꞌuc li joꞌoxuque, mu xuꞌ chatunic yuꞌun Dios mi jaꞌ noj batem ta avoꞌonic la ataqꞌuinique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Cꞌalal jech iyaꞌiic li jfariseoetique, la snaꞌleic li Jesuse yuꞌun stalelic ti xpichꞌet o yoꞌonic yuꞌun li taqꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Li Jesuse jech laj yalbe: ―Ta stojol li crixchanoetique chavaqꞌuic ta ilel ti tucꞌ avoꞌonic ti avalojique. Li Diose snaꞌ ti muc bu lec la avoꞌonique. Yuꞌun li buchꞌu ta xacꞌ sba ta ichꞌel ta mucꞌ ta stojol li crixchanoetique, jaꞌ muc bu lec ta xꞌile yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Cꞌalal muc toꞌox bu talem li Juan li iyacꞌ ta ichꞌel joꞌe, jaꞌ noꞌox avaꞌiic li cꞌusi yaloj Dios ti la stsꞌiba Moisés schiꞌuc li buchꞌutic yan iyalic scꞌop Dios ta voꞌonee. Tsꞌacal to laj yalboxuc li Juan ti ista xa scꞌacꞌalil chasventainic li Diose. Li avie oy xa ep li buchꞌutic ta sloqꞌuel yoꞌonic chacꞌ sbaic ta scꞌob li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Acꞌo mi la sjel li cꞌusi laj yal li Diose pero ta onoꞌox xcꞌot ta pasel li cꞌusi baꞌi laj yale. Li cꞌustic yaloj li Diose mu xchꞌay scꞌoplal, ta onoꞌox xcꞌot ta pasel scotol. Jaꞌ xlaj to li vinajel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Li buchꞌu chicta yajnile, mi chicꞌ yan antse, chmulivaj. Schiꞌuc nojtoc li buchꞌu chicꞌ li sutem antse chmulivaj nojtoc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Li Jesuse jech laj yal nojtoc: ―Oy jun vinic lec jcꞌulej. Toj lequic scotol li scꞌuꞌ spacꞌale. Naca toyolic stojol. Scotol cꞌacꞌal naca lec cꞌustic ta slajes. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oy jun vinic nojtoc, Lázaro sbi. Ep cꞌaꞌal chinetic ilocꞌ ta sbecꞌtal. Te chcꞌot schotan sba ta stiꞌ sna li jcꞌulej vinique yuꞌun chcꞌanolaj. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Li Lázaroe chac sveꞌ li cꞌustic ta stsꞌuj yalel ta yolon smexa li jcꞌulej vinique, pero mu xꞌacꞌbat. Li bu cꞌaꞌem li sbecꞌtale te ta xlecꞌulanbat ta tsꞌiꞌetic. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Icꞌot scꞌacꞌalil ti icham li jcꞌanolajele. Li schꞌulele iꞌicꞌbat batel yuꞌun li yajꞌangeltac li Diose. Te ba acꞌatuc li yoꞌ bu oy li Abrahame schiꞌuc li buchꞌutic coꞌol lec tucꞌ yoꞌonique. Icham eꞌuc li jcꞌulej vinique, imuque. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Li schꞌulele te ibat li yoꞌ bu oy li schꞌulelic li buchꞌutic muc bu xichꞌic ta mucꞌ li Diose. Cꞌalal te ta xichꞌ tsots vocole, la sqꞌuel batel ta nom li bu oy li Abrahame. Iyil ti te oy eꞌuc li Lázaroe. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Li jcꞌulej vinique tsots iyapta li Abrahame: “Tata, cꞌuxubinun. Taco talel li Lázaroe. Acꞌo stsꞌaj talel sbicꞌtal scꞌob ta joꞌ, acꞌo tal sicubtasbun li coqꞌue yuꞌun toj tsots ta xquichꞌ vocol liꞌ ta cꞌoqꞌue”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Li Abrahame jech laj yalbe: “Jmom, juleso ta ajol li cꞌu sba laꞌechꞌ ta balumile, ti lec jcꞌulejote. Li Lázaroe jaꞌ meꞌon tajmec, pero liꞌ xa oy ta lequilale, xmuybaj noꞌox. Li joꞌote te chavichꞌ o vocol. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mu xuꞌ xtal li Lázaroe yuꞌun oy mucꞌta xab ta oꞌlol. Muc buchꞌu xuꞌ ta xjelav batel te li yoꞌ bu oyote, jech muc buchꞌu xuꞌ ta xjelav talel liꞌi eꞌuc”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Itacꞌav li jcꞌulej vinique: “Mi mu xuꞌ chtal scoltaune, avocoluc taco batel ta sna li jtote. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yuꞌun oy to joꞌvoꞌ quitsꞌinab te comemic ta jna. Acꞌo ba yalbe ti mu me xtalic liꞌi yuꞌun toj tsots ichꞌ vocol liꞌi”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Li Abrahame jech laj yalbe: “Te onoꞌox yichꞌojbeic sjunic li Moisese schiꞌuc li buchꞌutic yan iyalic scꞌop Dios ta voꞌonee. Xuꞌ jaꞌ acꞌo schꞌunic li cꞌustic yalojique”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Itacꞌav li vinique: “Tata, mu scꞌan schꞌunic. Pero ti oyuc jun buchꞌu xojtaquinic ti ta xchaꞌcuxi ti te chba cꞌoponaticuque, jaꞌ to ta schꞌunic o, jaꞌ to te chictaic o li cꞌustic chopol ta spasique”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Li Abrahame jech laj yalbe: “Mi mu scꞌan schꞌunic li cꞌusi yalojic li Moisese schiꞌuc li buchꞌutic yan iyalic scꞌop Dios ta voꞌonee, acꞌo mi chcꞌot cꞌoponaticuc yuꞌun li buchꞌu chaꞌcuxieme, mu schꞌunic nojtoc”, xut ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Scotol cꞌacꞌal oy buchꞌu ta scꞌan chasocboxuc avoꞌonic. Pero toj abol sba li buchꞌu ta socvane. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jaꞌ lec acꞌo chucbatuc jun choꞌ ta snucꞌ, acꞌo jipeuc ochel ta nab, acꞌo chamuc o. Jech mu xa bu tsocbat yoꞌonic li buchꞌutic ti jech yoꞌonic jech chac cꞌu chaꞌal li unetic ti schꞌunojic ti joꞌon Yajcoltavanejicune. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Pꞌijanic me. Mi oy ista smul ta atojol junuc li buchꞌu coꞌol avichꞌojicun ta muqꞌue, jaꞌ scꞌan ti chavalbe ti mu me spas jeche. Mi iyicta li cꞌusi chopol ta spase, pasbo perton. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mi ta sta smul ta atojol ep ta velta ta jun noꞌox cꞌacꞌale, mi jech chtal yalulanbot jujun velta ti cꞌalal ta sta smule: “Muc xa bu ta jpas jech”, mi xayute, pasbo perton ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Li yajtacbalaltaque jech laj yalbeic li Cajvaltique: ―Acꞌbun más ta jol ta coꞌoncutic ti ta jchꞌuncutic ti joꞌot chacoltauncutique ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Li Cajvaltique jech laj yalbe: ―Manchuc mi jutuc noꞌox achꞌunojic ti joꞌon chajcoltaique, mi jaꞌ noꞌox jech chac cꞌu chaꞌal jpꞌej becꞌ mustasae, pero xuꞌ xa chapasic li cꞌustic tsots ta pasele. Jech chac cꞌu chaꞌal mi chavalbeic ti acꞌo buluc loqꞌuel li jtecꞌ higo liꞌi, ti acꞌo ba chꞌiuc ta nabe, jaꞌ ta xcꞌot ta pasel avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Mi oy avajtunel ti iꞌay ta sloquel avosil, mi ta schabiel achij cꞌuxi, cꞌalal chjul ta anae, muc bu jech chavalbe: “Laꞌ me, laꞌ chotlan liꞌ ta mexae”, muc bu xavut. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jech chavalbe: “Acꞌo smac achꞌut, meltsanbun talel jveꞌel. Jaꞌ to chaveꞌ eꞌuc mi ilaj coꞌon ta veꞌele”, xavut nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Cꞌalal mi la schꞌunbot la amantale, muc bu chavalbe coliyal ti la schꞌun la amantale yuꞌun jaꞌ yabtel o ti jech ta spase. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jaꞌ noꞌox jech eꞌuc li joꞌoxuque, mi la achꞌunic scotol li cꞌustic chayalbeic li Diose, mu me xatoy abaic yuꞌun mu cꞌusi xuꞌ avuꞌun apas atuquic. Jaꞌ noꞌox la apasic li cꞌusi avabtel yacꞌojboxuc li Diose. Ti laj yacꞌoxuc li Diose yuꞌun tscꞌan ti chatunic yuꞌune ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cꞌalal ibat ta Jerusalén li Jesuse, te ijelav ta stsꞌaquil li Galilea balumile schiꞌuc li Samaria balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Te iꞌoch ta jun colonia. Te italic ta be lajunvoꞌ viniquetic tsacbilic ta cꞌaꞌel chamel. Nom la svaꞌan sbaic li yoꞌ bu oy li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tsots laj yaptaic li Jesuse: ―Jesús, jchanubtasvanej, avocoluc cꞌuxubinuncutic ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Cꞌalal iyil li viniquetic li Jesuse, jech laj yalbe: ―Batanic, ba acꞌ abaic ta ilel ta stojol li paleetique ―xut. La schꞌunic, ibatic. Jech icol o scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pero oy jun ti cꞌalal iyil ti icol xae, isut talel ta ora ta stojol li Jesuse. Tsots icꞌopoj talel, laj yalbe coliyal Dios ta sventa ti icol xae. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","La spatan sba ta balumil ta stojol li Jesuse, jech laj yalbe: ―Colaval ti la acoltaune ―xut. Li vinic ti jech laj yale liquem talel ta Samaria balumil. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Li Jesuse jech laj yalbe li buchꞌutic te schiꞌuque: ―Lajunvoꞌ ti la jcoltaic li ta schamelique. Qꞌuelavil, muc bu sutic xa talel li balunvoꞌ jchiꞌiltic ta israelale, muc bu xtal yalbeic coliyal Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Jaꞌ noꞌox isut talel li jyanlumal vinic liꞌi, jaꞌ tal yalbe coliyal Dios ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Li Jesuse jech laj yalbe li vinique: ―Lican, batan. Yuꞌun la achꞌun ti oy juꞌele jaꞌ yuꞌun lacol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Li jfariseoetique la sjacꞌbeic Jesús cꞌu ora chtal ichꞌvanuc ta venta li Diose. Itacꞌav li Jesuse: ―Cꞌalal chlic ichꞌvanuc ta venta li Diose, muꞌyuc senyail. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Muc buchꞌu xuꞌ jech chal: “Liꞌ xa ta spas mantal li Diose”, “Leꞌ xa ta spas mantal li Diose”, muc buchꞌu xuꞌ xi. Yuꞌun li ichꞌel ta venta yuꞌun li Diose liꞌ xa oy ta atojolique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Ta sta scꞌacꞌalil ti jech chavalique: “Taluc ta ora li Cajvaltique”, xachiic, pero mu to xuꞌ xital, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jech chlic yalic li crixchanoetique: “Liꞌ xa oy li Cajvaltique”, xayutic. Oy yan jech ta xalic: “Leꞌ xa oy li Cajvaltique”, xayutic. Mu me xachꞌunic, mu me xabatic li bu chayalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yuꞌun jaꞌ jech chac cꞌu chaꞌal li chauc ti xleblajet ta xquiltic ti butic xa oyutique, jaꞌ jech scotol crixchanoetic chiyilic cꞌalal chichaꞌtal, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero persa baꞌi chquichꞌ ep vocol yuꞌun mu xiscꞌanic li jchiꞌiltactic ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jech chac cꞌu chaꞌal la spasic li crixchanoetic ta voꞌone li cꞌalal liꞌ toꞌox oy li Noee, jaꞌ noꞌox jech ta spasic eꞌuc li cꞌalal ta sta scꞌacꞌalil chichaꞌtal, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cꞌalal muc toꞌox bu talem li nojelale, jaꞌ noꞌox batem ta yoꞌonic ta saꞌel sveꞌelic schiꞌuc yuchꞌobic, ta xnupunic schiꞌuc ta xacꞌ ta malijel stseubic. Jaꞌ to ipajic li cꞌalal ital li nojelale schiꞌuc iꞌoch ta barco li Noee yuꞌun icham scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jaꞌ jech la spasic eꞌuc li crixchanoetic ta voꞌone li cꞌalal liꞌ toꞌox oy li Lote. Jaꞌ noꞌox batem ta yoꞌonic ta saꞌ sveꞌelic, ta xmanolajic, ta xpꞌolmajic, ta xꞌovolajic, ta svaꞌan snaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jaꞌ to ipajic li cꞌalal iyal talel cꞌocꞌ ta vinajel schiꞌuc azufree, ilocꞌ batel ta Sodoma li Lote yuꞌun icham scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cꞌalal chichaꞌtal, joꞌon li coꞌol crixchanoutique, jaꞌ jech ta spasic eꞌuc li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Cꞌalal chichaꞌtal, joꞌon li coꞌol crixchanoutique, mu me jaꞌuc noꞌox batem ta avoꞌonic li cꞌustic oy avuꞌunic liꞌ ta balumile. Li buchꞌutic ti te oyic ta sjol snaic ti pachꞌale, cꞌalal ta xyalic talele, mu xa me xꞌoch sloqꞌuesic li cꞌustic oy ta yut snaique. Li buchꞌutic ti te oyic ta yabtelique, mu xa me sutic talel ta snaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Naꞌic me li cꞌusi icꞌot ta pasel ta stojol li yajnil Lot ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mi jaꞌ avacꞌojic tajmec ta venta li cꞌu sba chacuxiic liꞌ ta balumile, chachꞌayic o. Yan mi mu xavaqꞌuic más ta venta li cꞌu sba chacuxiic liꞌ ta balumile, jaꞌ chacuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Chacalbeic, mi ta acꞌubaltic chitale, mi oy chaꞌvoꞌ ta xvayic ta jun teme, jun ta xquicꞌ ba, jun ta xcom. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mi oy chaꞌvoꞌ antsetic coꞌol ta xjuchꞌunique, jun ta xquicꞌ ba, jun ta xcom. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mi oy chaꞌvoꞌ viniquetic ti coꞌol ta xꞌabtejic ta yabtelique, jun ta xquicꞌ ba, jun ta xcom ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jech ijacꞌbat yuꞌun li yajchanbalajeltaque: ―Cajval, ¿bu ta xcꞌot ta pasel taje? ―xutic. Itacꞌav li Jesuse: ―Jech chac cꞌu chaꞌal mi oy cꞌusi chameme ta onoꞌox xlaj ta xulem, jaꞌ jech ta onoꞌox xtal tsots vocol ta stojolic li buchꞌutic ti mu xiyichꞌic ta muqꞌue ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Li Jesuse laj yalbe ta loꞌil li yajchanbalajeltaque ti acꞌo me mu xlaj yoꞌonic ta stael ta naꞌel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xi laj yalbe: ―Oy jun jmeltsanejcꞌop ta jun jteclum mu xichꞌ ta mucꞌ li Diose, mu xacꞌ ta venta nojtoc li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oy jun meꞌanal ants ti te nacal eꞌuque. Li antse ep ta velta a scꞌopon li jmeltsanejcꞌope, jech laj yalbe: “Avocoluc coltaun yuꞌun oy buchꞌu chiscontrain”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Li jmeltsanejcꞌope ep cꞌacꞌal mu scꞌan smeltsanbe scꞌop li meꞌanal antse. Tsꞌacal to jech la snop: “Mu xixiꞌ yuꞌun li Diose, mu xixiꞌ yuꞌun eꞌuc li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jaꞌ noꞌox ta scoj ti liꞌ xtantun li meꞌanal antse ta jmeltsanbe li scꞌope. Yuꞌun mu jcꞌan ti liꞌ noꞌox xtantune”, xi li jmeltsanejcꞌope ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jech laj yal nojtoc li Cajvaltique: ―La avaꞌiic li cꞌu sba iyal li jmeltsanejcꞌop ti chopol yoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yan li Dios ti tucꞌ yoꞌone, mi jech chacꞌanbeic ta cꞌacꞌal acꞌubal ti acꞌo scoltaoxuc ti cꞌusi vocolal chavaꞌiic, joꞌoxuc li tꞌujbiloxuc yuꞌune, persa ta spas yuꞌun mu xlaj yoꞌon ta yaꞌiel la acꞌopique. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cꞌalal mi ista scꞌacꞌalile, chascoltaic ta ora. Pero cꞌalal chichaꞌtal, joꞌon li coꞌol crixchanoutique, ¿mi yoquel toꞌox avichꞌojicun ta mucꞌ liꞌ chjul jtaoxuque? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Li Jesuse laj yal jun loꞌil yoꞌ jech acꞌo yaꞌibeic smelol li buchꞌutic tucꞌ yoꞌonic ti yalojique, ti ta spꞌajic li schiꞌiltaquique. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Oy chaꞌvoꞌ viniquetic coꞌol ba staic ta naꞌel Dios ta yamaqꞌuil li mucꞌta chꞌulnae. Li june jaꞌ jfariseo; li june jaꞌ jtsobpatan. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Li jfariseoe te vaꞌal ista ta naꞌel li Diose, stoyoj noꞌox sba. Jech laj yal: “Dios, colavalbun ti muc bu jechun jech chac cꞌu chaꞌal li yan jchiꞌiltaque. Yuꞌun li stuquique ta xꞌelcꞌajic, chopol yoꞌonic, ta xmulivajic. Muc bu jechun nojtoc jech chac cꞌu chaꞌal li jtsobpatan li liꞌ chasta ta naꞌele. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Li joꞌone chib velta ta xquicta quixim ta jujun xemana. Scotol li cꞌustic ta jtae ta xcat ta lajlajuneb. Jujun ta jloqꞌues ta lajlajuneb sventa amoton”, xut li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero li jtsobpatane nomnom noꞌox vaꞌal icom yuꞌun ta xiꞌ li Diose. Mu scꞌan stoy sat ta vinajel nojtoc. Yuꞌun snaꞌ ti chopol li yoꞌone, jaꞌ noꞌox la smajulan stiꞌ yoꞌon, jech la scꞌopon Dios: “Dios, cꞌuxubinun yuꞌun jpasmulilun”, xut li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chacalbeic, li jtsobpatane pasbil xa perton yuꞌun smul li cꞌalal isut batel ta snae. Yan li jfariseoe muc bu spasbat perton yuꞌun smul. Yuꞌun li buchꞌutic ta stoy sbaique jaꞌ ta xbicꞌtajese yuꞌun li Diose. Yan li buchꞌutic ta sbicꞌtajes sbaique, jaꞌ ta xꞌaqꞌueic ta ichꞌel ta mucꞌ yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iꞌicꞌbat talel unetic ta stojol li Jesuse yoꞌ acꞌo yacꞌanbe scꞌob ta sjolic yoꞌ jech ta xichꞌic slequilal yutsilal Dios. Cꞌalal iyilic li yajchanbalajeltaque, la spajesic li buchꞌutic laj yiqꞌuic talel li unetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Li Jesuse laj yicꞌ ta stojol li unetique schiꞌuc li stot smeꞌique. Jech laj yalbe li yajchanbalajeltaque: ―Acꞌo talicuc ta jtojol li unetique, mu me xapajesic. Yuꞌun li buchꞌutic jaꞌ jechic jech chac cꞌu chaꞌal li unetique, lec to chaꞌiic pasel ta mantal yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Melel chacalbeic, li buchꞌutic mu scoꞌoltajes sbaic jech chac cꞌu chaꞌal li unetique, mu xuꞌ xꞌochic li yoꞌ bu ta spas mantal li Diose ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oy jun jmeltsanejcꞌop yuꞌun li jꞌisraeletique jech ijacꞌbat li Jesuse: ―Lequil jchanubtasvanej, ¿cꞌusi ta jpas yoꞌ chicuxi o sbatel osile? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Itacꞌav li Jesuse: ―¿Cꞌu chaꞌal chavalbun ti lequil jchanubtasvanejune? Yuꞌun jaꞌ noꞌox jun ti leque, jaꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xanaꞌ ti jech chal li mantaletique: “Mu me xamulivaj, mu me xamilvan, mu me xaꞌelcꞌaj, mu me xasaꞌbe smul achiꞌil, ichꞌo ta mucꞌ atot ameꞌ”, xi ―xꞌutat yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Itacꞌav li vinique: ―Scotol li cꞌustic la avale ta jbicꞌtal onoꞌox lic jchꞌun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cꞌalal iyaꞌi Jesús ti jech itacꞌave, jech laj yalbe: ―Pero oy to cꞌusi scꞌan xapas. Ba chono scotol li cꞌustic oy avuꞌune. Li stojole qꞌuelananbo li meꞌonetique jaꞌ oy o acꞌulejal ta vinajel. Tsꞌacal to xtal achiꞌinun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cꞌalal iyaꞌi jech li vinique, iyat tajmec yoꞌon yuꞌun toj ep cꞌustic oy yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cꞌalal iyil Jesús ti chat yoꞌone, jech laj yal: ―Li jcꞌulejetique toj vocol chacꞌ sbaic ta scꞌob li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jech chac cꞌu chaꞌal mu xjelav jcot cameyo ta chac acuxae, jaꞌ noꞌox jech mu xuꞌ ta xꞌoch li yoꞌ bu ta spas mantal Dios li buchꞌutic jaꞌ noꞌox batem ta yoꞌonic li scꞌulejalique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Li buchꞌutic iyaꞌiic ti jech laj yal li Jesuse, jech lic sjacꞌbeic: ―Mi mu xcolic li jcꞌulejetique, ¿buchꞌu ma ti chcol yaꞌele chaꞌa? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Li Jesuse itacꞌav: ―Li crixchanoetique mu xuꞌ ta scolta sba stuquic sventa sbatel osil. Jaꞌ noꞌox xuꞌ ta xcolic ta sventa li Diose, yuꞌun scotol xuꞌ yuꞌun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Li Pedroe jech laj yal: ―Li joꞌoncutique laj xa quictacutic scotol li cꞌustic oy toꞌox cuꞌuncutique. Liꞌ xa jchiꞌucotcutique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Itacꞌav li Jesuse: ―Melel li cꞌusi chacalbeique, li buchꞌutic laj xa yicta snaic, mi stot, mi smeꞌ, mi sbanquiltac, mi yitsꞌinabtac, mi svixobtac, mi yixleltac, mi smucobtac, mi yajnil, mi snichꞌnab yuꞌun chaꞌiic ti persa tspasic li cꞌustic tscꞌan li Diose, ta stabe más sqꞌuexol li cꞌustic oy toꞌox yuꞌune schiꞌuc ta xcuxiic o sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Li Jesuse la sqꞌuej sbaic echꞌel jutuc schiꞌuc li lajchavoꞌ yajchanbalajeltaque. Jech laj yalbe: ―Xanaꞌic ti te chijbat ta Jerusalene. Joꞌon li coꞌol crixchanoutique, te chcꞌot ta pasel scotol li jcꞌoplal li la stsꞌibaic comel li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Chiꞌaqꞌue ta scꞌob li buchꞌutic maꞌuc jchiꞌiltic ta israelale. Chislabanic, chismajic, chistubtaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chistsitsic ta nucul, chismilic, chimuque, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Li yajchanbalajeltaque muc bu xaꞌibeic smelol ti jech laj yale. Mu snaꞌic mi jech ta xcꞌot ta pasel. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cꞌalal nopolic xaꞌox batel ta jteclum Jericó li Jesuse, te chotol ta tiꞌbe istaic jun maꞌsat. Jaꞌ jꞌisraelal vinic. Te ta xcꞌanolaj. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cꞌalal iyaꞌi li maꞌsat ti te ch‐echꞌic ep schiꞌiltaque, la sjacꞌbe ti bu chbatique. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iꞌalbat yuꞌun schiꞌiltac ti jaꞌ te schiꞌuquic echꞌel li Jesús li liquem talel ta Nazarete. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Cꞌalal iyaꞌi li maꞌsate, tsots laj yapta li Jesuse: ―¡Jesús, joꞌot snitilulot David ti scꞌoplal onoꞌox chaꞌoch ta ajvalilal cuꞌuncutique, ichꞌun ta cꞌux! ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Li buchꞌutic sbabeic batele la spajesic: ―¡Anchan! ―xutic. Pero más to tsots icꞌopoj li vinique: ―¡Joꞌot snitilulot David, ichꞌun ta cꞌux! ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ivaꞌi li Jesuse. Laj yalbe ti acꞌo snitic talel ta stojole. Cꞌalal icꞌot li yoꞌ bu oye, la sjacꞌbe: ");
INSERT INTO tzoSA_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Cꞌusi chacꞌan chajpasbe? ―xut. Itacꞌav li vinique: ―Cajval, avocoluc jambun li jsate ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Itacꞌav li Jesuse: ―Ijam xa la asate yuꞌun la achꞌun ti oy juꞌele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ijam ta ora li sate, la schiꞌin batel li Jesuse, ep laj yal coliyal Dios. Cꞌalal iyilic li crixchanoetique, laj yalic coliyal Dios eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Li sbelel Jerusalene te xꞌechꞌ ta yut jteclum Jericó, te iꞌechꞌ batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oy jun vinic te ta jteclum Jericó, Zaqueo sbi. Yichꞌoj tsots yabtel. Jaꞌ banquilal yuꞌun li jtsobpatanetique. Jcꞌulej. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Li Zaqueoe tscꞌan ta sqꞌuel li cꞌu sba li Jesuse. Tscꞌan chojtaquin. Pero muc bu xil yuꞌun toj ep li crixchanoetique. Yuꞌun cꞌalal vinic noꞌox li Zaqueoe. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jaꞌ yuꞌun ijelav ta anil, imuy ta jtecꞌ higo te ta nopol tiꞌbe li yoꞌ bu chjelav li Jesuse yoꞌ xil o chjelav teye. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cꞌalal icꞌot ta yolon li teꞌ li Jesuse, la sqꞌuel muyel. Iyil ti te luchul li Zaqueoe, jech laj yalbe: ―Zaqueo, yalan talel ta ora yuꞌun te chibat ta ana ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Iyal ta ora li Zaqueoe. Xmuybaj xa laj yicꞌ batel ta sna li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Cꞌalal iyil li crixchanoetic ti ibat ta sna Zaqueo li Jesuse, chopol iyaꞌiic. Te xꞌupꞌetic noꞌox liquel yuꞌun snaꞌojic ti jaꞌ jloꞌlovanej li Zaqueoe. Iyalic ti ba schiꞌin jpasmulil li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Li Zaqueoe ivaꞌi, jech laj yalbe li Cajvaltique: ―Cajval, ta xcacꞌbe jꞌoꞌloluc li cꞌustic oy cuꞌun li meꞌonetique. Mi oy buchꞌu la jloꞌlobe staqꞌuine, más to ep ta jsutesbe. Mi la jloꞌlo joꞌvinique (100), chanib ciento chcacꞌbe ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Li Jesuse jech laj yal: ―Li avie lacol xa acotolic li ta anae. Coꞌol xa avoꞌon achiꞌuc li jtotic jmeꞌtic Abraham ta voꞌonee yuꞌun la achꞌun xa ti joꞌon Avajcoltavanejune. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Joꞌon li coꞌol crixchanoutique tal jcoltaoxuc acotolic yuꞌun chꞌayemoxuc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Cꞌalal te chaꞌiic li cꞌusi chal Jesús li crixchanoetique, li Jesuse laj yal jun loꞌil yuꞌun poꞌot xaꞌox chcꞌotic ta Jerusalén. Jaꞌ laj yal ta loꞌil ti maꞌuc to scꞌacꞌalil ta xꞌoch ta ajvalilale. Yuꞌun la snop li jꞌisraeletic ti jaꞌ xa ta xꞌoch ta ajvalilal yuꞌunic li te ta Jerusalene, ti jaꞌ li buchꞌu tꞌujbil yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Li Jesuse jech laj yal: ―Oy snichꞌon jun mucꞌta ajvalil. Lec jcꞌulej li nichꞌonile. Ibat ta nom ta yan o balumil, ba schꞌam talel yabtel yuꞌun ta xꞌoch ta ajvalilal. Jaꞌ chlic sventain scotol li schiꞌiltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cꞌalal muc toꞌox bu bateme, laj yicꞌ talel lajunvoꞌ yajtuneltac. Ta jujuntal laj yacꞌbe jujusep taqꞌuin ti ep ta cien yichꞌoje. Jech laj yalbe: “Ba jolintasic. Cꞌalal mi lisut talele, jaꞌ to chjul quichꞌ”, xut comel. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Li crixchanoetique chopol iyaꞌiic ti jaꞌ ta xꞌoch ta ajvalilal li schiꞌilique. Jaꞌ yuꞌun la staquic batel buchꞌu chba yal li bu ba schꞌam talel yabtele. Jech cꞌot yalic: “Mu jcꞌancutic ti jaꞌ ta xꞌoch ta ajvalilal cuꞌuncutic li jchiꞌilcutic taje”, xiic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Cꞌalal laj yichꞌ yabtel sventa ajvalil li vinique, isut batel. Cꞌalal icꞌote, la stacan ta iqꞌuel li yajtuneltaque yuꞌun tscꞌan chaꞌi cꞌu yepal ijolin yuꞌunic jujunic li staqꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Li buchꞌu baꞌi itale jech laj yal: “Cajval, lajunsep ijolin cuꞌun la ataqꞌuin li la avacꞌbun comele”, xut li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Itacꞌav li yajvale: “Lec oy. Joꞌote lequil jtunelot. Yuꞌun jun avoꞌon la ajolintas li jtaqꞌuine, jaꞌ yuꞌun chcacꞌ aventain lajuneb jteclum”, xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ital nojtoc li yane, jech laj yal: “Cajval, joꞌsep ijolin cuꞌun la ataqꞌuin li la avacꞌbun comele”, xut li yajvale. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Itacꞌav li yajvale: “Joꞌote joꞌob jteclum chcacꞌ aventain”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Ital nojtoc li yane, jech laj yal: “Cajval, ilo li jsep ataqꞌuin li la avacꞌbune. La jpix lec ta panyo, la jnacꞌ lec. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yuꞌun lixiꞌ avuꞌun. Jnaꞌoj onoꞌox ti toj tsots avoꞌone. Jnaꞌoj ti chavichꞌ sutel schiꞌuc sjol la ataqꞌuine, chavichꞌ li bu maꞌuc avabtele”, xi la spoj sba. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Jech iꞌalbat yuꞌun li yajvale: “Mu xatun, chꞌajil jtunelot. Mu junuc avoꞌon ta jtojol jaꞌ yuꞌun mu xacꞌan xaꞌabtej. Ta xquichꞌ acꞌop li cꞌu sba la avale. Mi xanaꞌ ti toj tsots coꞌone ta sventa ti ta xquichꞌ li bu maꞌuc cabtel chavale, ¿cꞌu chaꞌal muc xꞌa aticꞌ ta sjolintasobil taqꞌuin ti acꞌo xjolin li jtaqꞌuine? Cꞌalal litale, iquichꞌ sutel schiꞌuc sjol ti jechuque”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jech laj yalbe li yan li te oyique: “Pojbeic li jsep jtaqꞌuin ti cacꞌojbee, jaꞌ acꞌbeic li buchꞌu laj yichꞌ talel li lajunsepe”, xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jech laj yalic: “¡Cajval, pero yichꞌoj xa lajunsep!” xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Itacꞌav li ajvalile: “Chacalbeic, scotol li buchꞌutic ta xꞌabtejic cuꞌune ta sta li cꞌusi ta xtun yuꞌunique. Ta to xcacꞌbe más nojtoc. Yan li buchꞌutic mu scꞌan xꞌabtejic cuꞌune mu cꞌusi ta staic o. Ta jpojbe ta jꞌechꞌel li cꞌustic cacꞌojbeique. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jech nojtoc li buchꞌutic chiscontrainique, ti mu scꞌanic ti joꞌon ta jventainique, iqꞌuic talel scotolic liꞌi. Liꞌ ta jsat xamilique”, xi li ajvalile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cꞌalal jech laj yal loꞌil li Jesuse, jaꞌ sbabe batel yuꞌun chbat ta Jerusalén schiꞌuc li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Te icꞌotic ta nopol colonia Betfagé sbi, schiꞌuc ta jteclum Betania, te ta yoc vits Olivatic. Li Jesuse la stac jelavel chaꞌvoꞌ yajchanbalajeltac. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jech laj yalbe: ―Batanic leꞌ ta coloniae. Cꞌalal chaꞌochique, te chucul chataic jcot burro muc to bu cajlebinbil. Jitunic, nitic talel. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mi oy buchꞌu chasjacꞌbeic ti cꞌu chaꞌal chajitunic li burroe, albeic: “Yuꞌun ta xtun yuꞌun li Cajvaltique”, utic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ibatic li chaꞌvoꞌique. Li cꞌu sba iꞌalbatic batel yuꞌun li Cajvaltique jaꞌ jech cꞌot staic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cꞌalal jaꞌ o te ta sjitunic li burroe, jech iꞌalbatic yuꞌun li yajvale: ―¿Cꞌu chaꞌal chajitunic li jburroe? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Itacꞌavic: ―Yuꞌun ta xtun yuꞌun li Cajvaltique ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","La snitic talel li yoꞌ bu oy li Jesuse. Laj yacꞌbeic spuychijic sventa staspat, la scajlebin li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Cꞌalal cajal xa batel ta burro li Jesuse, li jꞌisraeletique la sqꞌuianic spuychijic ta be li bu ch‐echꞌ ba li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cꞌalal nopol xa batel ta Jerusalén li yoꞌ bu vits Olivatique, tsots lic cꞌopojicuc scotol li buchꞌutic ti scotol cꞌacꞌal te schiꞌuquic li Jesuse. Xmuybajic noꞌox laj yalbeic coliyal Dios ta sventa ti iyilbeic ep stsatsal sjuꞌel ti iyacꞌ ta ilel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jech laj yalic: ―¡Toj lec li ajvalil li la stacbutic talel li Cajvaltic Diose! ¡Lec xa chijyilutic li Diose! ¡Acꞌo quichꞌtic ta mucꞌ! ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oy jayvoꞌ jfariseoetic te schiꞌuquic. Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, pajeso li buchꞌutic yichꞌojicot ta muqꞌue yuꞌun xꞌavetic tajmec ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Li Jesuse jech laj yalbe: ―Chacalbeic, mi ta xpajic li buchꞌutic yichꞌojicun ta muqꞌue, jaꞌ chlic cꞌopojicuc li tonetique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cꞌalal nopolic xaꞌox ba ta Jerusalén li Jesuse, la sqꞌuel li jteclume, laj yoqꞌuita li schiꞌiltac li te nacalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jech laj yal: ―Xanaꞌicuc ti yorail xa chacolique, lec, pero mu xanaꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yuꞌun chcꞌot scꞌacꞌalil chtal sjoy sbaic liꞌ ta jteclum li buchꞌutic chascontrainoxuque, chasmaquic ta jujot. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chtal sjinesic la ateclumalique. Mu jpꞌejuc ton latsal chcom, scotol ta sjinesic. Chasmilic acotolic nojtoc. Jaꞌ ta scoj ti mu xachꞌunic ti joꞌon tacbilun talel yuꞌun Dios sventa chajcoltaique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Li Jesuse iꞌoch ta yamaqꞌuil li mucꞌta chꞌulna li te ta Jerusalene. La snutsan loqꞌuel scotol li jpꞌolmaletic li te oyique. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jech laj yalbe: ―Jech tsꞌibabil ta scꞌop Dios: “Li jnae jaꞌ snail li bu chataicun ta naꞌele”, xi li Diose. Pero li joꞌoxuque apasic xa ta snailchꞌen jꞌeleqꞌuetic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Li Jesuse scotol cꞌacꞌal te ichanubtasvan ta yamaqꞌuil li mucꞌta chꞌulna li te ta Jerusalene. Li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletique, la snopilanic cꞌu sba xuꞌ ta smilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero muc bu staic, yuꞌun scotol crixchanoetic ta sloqꞌuel yoꞌon laj yaꞌibeic scꞌop li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ta yan o cꞌacꞌal te ichanubtasvan ta yamaqꞌuil li mucꞌta chꞌulna te ta Jerusalén li Jesuse. Laj yalbe ti ista xa scꞌacꞌalil ta xventainatic yuꞌun li Diose. Te italic jayvoꞌ banquilal paleetic schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, schiꞌuc li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jech la sjacꞌbeic li Jesuse: ―Albun caꞌicutic ti buchꞌu laj yacꞌbot ajuꞌel yoꞌ chapas li cꞌustic chapase ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Itacꞌav li Jesuse: ―Oy cꞌusi chajacꞌbeic eꞌuc. Albecun. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Li ichꞌjoꞌ ti iyacꞌ li Juane, ¿buchꞌu iꞌacꞌbat yabtel ti jech la spase? ¿Mi jaꞌ Dios iꞌacꞌbat, mi crixchano noꞌox iꞌacꞌbat? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Te lic yalulanbe sbaic: ―Mi chcaltic ti jaꞌ iꞌacꞌbat yabtel yuꞌun li Diose, jech chijyalbutic: “¿Cꞌu chaꞌal muc bu xachꞌunic chaꞌa?” xijyututic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mi icaltic ti iꞌacꞌbat yuꞌun crixchanoe, chijyacꞌbutic ton li jchiꞌiltactique. Yuꞌun scotolic schꞌunojic ti jaꞌ iyal scꞌop Dios li Juane ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jech laj yalbeic Jesús ti mu snaꞌic buchꞌu iꞌacꞌbat yabtel li Juan li laj yacꞌ ta ichꞌel joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Li Jesuse jech laj yalbe: ―Jaꞌ jechun eꞌuc, muc bu chacalbeic ti buchꞌu liyacꞌbe juꞌel ti jech ta jpase ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Li Jesuse lic scꞌopon li jꞌisraeletique, laj yalbe loꞌil. Jech laj yal: ―Oy jun vinic la stsꞌun ep tsꞌusub ta yosil. La saꞌbe comel yajval buchꞌutic ta schabiic li tsꞌusubtique. Ibat ta nom li yajvale, te ijocꞌtsaj. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cꞌalal ista yora ta xtaꞌaj li sat tsꞌusube, la stac batel jun yajtunel yuꞌun ba yichꞌ talel li cꞌu onoꞌox yepal yaloj chichꞌe. Cꞌot scꞌanbe li buchꞌutic ta schabiique. Pero li jchabiejtsꞌusubtique la stsaquic li yajtunel li yajval osile, la smajic. Mu cꞌusi xacꞌbeic echꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Li yajval li osile la stac batel yan yajtunel nojtoc. Pero la smajic, laj yilbajinic nojtoc. Mu jsetꞌuc laj yacꞌbeic echꞌel nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Li yajval li osile la stac batel yan yajtunel nojtoc. Jaꞌ yoxibal xa velta. Pero li jchabiejtsꞌusubtique la smajic nojtoc. La syaintasic, la snutsic loqꞌuel. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Li yajval li osile jech la snop: “¿Cꞌusi ta jnop? Jaꞌ lec ta jtac batel li jnichꞌon ti toj cꞌux ta coꞌone. Mi iyilic ti jaꞌ jnichꞌone, jaꞌ to nan chaqꞌuic ta venta”, xi ta yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero cꞌalal iyilic li jchabiejtsꞌusubtic ti jaꞌ xa snichꞌon li yajval osile, jech laj yalbe sbaic: “Leꞌe jaꞌ chichꞌbe comel li yosil li stote. Jaꞌ lec ta jmiltic yoꞌ jech joꞌotic chquichꞌbetic o comel li yosile”, xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","La sloqꞌuesic ta pat moc, te la smilic. Cꞌalal ta sut talel li yajval tsꞌusubtique, ¿cꞌusi chjul spasbe xanaꞌic li jchabiejtsꞌusubtique? ");
INSERT INTO tzoSA_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chacalbeic, li jchabiejtsꞌusubtique chlaj smilan. Yan xa o buchꞌutic ta xacꞌbe schabiic li tsꞌusubtique ―xi li Jesuse. Cꞌalal iyaꞌiic jeche, jech laj yalic: ―¿Mi jech nan chispasbutic li Diose? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Li Jesuse la sqꞌuelbe sat li crixchanoetique, jech laj yalbe: ―Nopic mi mu jechuc xlocꞌ smelol ti jech tsꞌibabil ta scꞌop li Diose: Jech chac cꞌu chaꞌal li yajval na ti la stꞌuj jpꞌej ton sventa ta xacꞌ ta chiquin nae, pero li svinictac ta vaꞌanejnae mu scꞌanic. Li ton li la spꞌajique jaꞌ onoꞌox iꞌoch ta chiquin na. Jaꞌ noꞌox jech eꞌuc li buchꞌu tꞌujbil yuꞌun li Diose, acꞌo mi mu xcꞌanee, pero ta onoꞌox xꞌacꞌbat tsots yabtel, xi tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Li buchꞌutic chopol chiyilique jaꞌ chopol chbatic o. Ta onoꞌox xquichꞌbe scꞌopic. Mi ical ti ta chꞌayel ta xbatique, ta xchꞌayic o sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, taꞌox stsaquic ta ora li Jesuse yuꞌun ijul ta sjolic ti jaꞌ scꞌoplalique. Pero muc buchꞌu itsacvanic yuꞌun ixiꞌic o li schiꞌiltaquique. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jaꞌ noꞌox la smalaic mi oy cꞌu ora xocol li Jesuse. Cꞌalal iyilic ti xocol xae, la staquic batel ta ora jayvoꞌ li buchꞌutic jun yoꞌonic ta stojol Jesús yilele yuꞌun oy cꞌusi chba sjacꞌbeic. Mi muc bu lec chtacꞌav li Jesuse, jaꞌ te tstabeic o smul ti yalojique, jech xuꞌ ta stsaquic, ta xiqꞌuic batel ta stojol li gobernadore. Te chcꞌot sticꞌbeic smul ti yalojique. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jech la sjacꞌbeic li Jesuse: ―Jchanubtasvanej, jnaꞌojcutic ti melel scotol li cꞌusi chavale, ti jamal chaval li cꞌusi tscꞌan Dios ti acꞌo jpascutique, ti mu tꞌujbiluc chachaꞌle li buchꞌu chavalbee. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Alo caꞌicutic mi lec chil Dios ti ta jtojbecutic jpatancutic li Césare, mi moꞌoj ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Li Jesuse snaꞌoj ti yuꞌun noꞌox chqꞌuelbat yoꞌone, jech la stacꞌbe: ");
INSERT INTO tzoSA_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Acꞌbecun quil junuc li taqꞌuin sventa ta jtojtic o jpatantique ―xut. Laj yacꞌbeic. Cꞌalal iyil li Jesuse, jech laj sjacꞌbe: ―¿Buchꞌu slocꞌol liꞌi? ¿Buchꞌu sbi liꞌi? ―xꞌutatic. Itacꞌavic: ―Jaꞌ César ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iꞌalbatic yuꞌun li Jesuse: ―Scꞌan ta jpasbetic li yabtel ti chal li Césare yuꞌun jaꞌ mucꞌta ajvalil. Jech nojtoc scꞌan ta jpasbetic li cꞌusi chal li Diose ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Acꞌo mi chac saꞌbeic smul Jesús li te ta stojol li schiꞌiltaquique pero muc bu stabeic smul. Toj chꞌayel noꞌox yoꞌonic ti cꞌu sba itacꞌav li Jesuse, jech mu xa cꞌusi más la sjaqꞌuic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsꞌacal to italic ta stojol Jesús jayvoꞌ jsaduceoetic eꞌuc, jaꞌ li buchꞌutic ta xalic ti muꞌyuc chaꞌcuxesele. Jech la sjacꞌbeic li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Jchanubtasvanej, jech la stsꞌiba comel li Moisese: “Mi icham jun vinic, mi muꞌyuc snichꞌon ta xcome, li itsꞌinal ti muꞌyuc to yajnile, jaꞌ acꞌo yicꞌbe yajnil li ánima sbanquile. Cꞌalal ta xil schꞌamale, jaꞌ acꞌo yacꞌbe sbiinbe sbi li ánima sbanquile jaꞌ yoꞌ mu xchꞌay o li sbi li ánima sbanquile”, xi li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oy jucvoꞌ jchiꞌiltic ta israelal sbanquil yitsꞌin noꞌox sbaic. Li banquilale la saꞌ yajnil, pero icham, muꞌyuc snichꞌon icom. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Li itsꞌinale laj yicꞌbe yajnil li ánima sbanquile pero icham nojtoc. Muꞌyuc snichꞌon icom eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jaꞌ jech la spasulan sjucvaꞌalic. Xcholet sjucvaꞌalic laj yiqꞌuic li antse yuꞌun laj chamicuc. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tsꞌacal to icham eꞌuc li antse. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cꞌalal ta xchaꞌcuxiique, ¿buchꞌu junucal ta xicꞌ o li antse yuꞌun scotolic laj yicꞌulanic? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Itacꞌav li Jesuse: ―Ti cꞌalal liꞌ to oyic ta balumile xuꞌ chnupunic li vinic antsetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Li buchꞌutic ta xchaꞌcuxiique, mu xa bu ta xnupunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yuꞌun mu xa snaꞌ xchamic eꞌuc jech chac cꞌu chaꞌal li chꞌul ángeletique. Snichꞌnab xa Dios o yuꞌun ichaꞌcuxesatic xa yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Li Moisese iyal eꞌuc ti cuxulic li buchꞌutic voꞌone xa ichamique. Yuꞌun jaꞌ la stsꞌibabe comel scꞌoplal li cꞌalal iꞌalbat yuꞌun Dios li te yoꞌ bu itil li jtecꞌ biqꞌuit chꞌixe. Acꞌo mi voꞌone xa chamemic li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove, pero te to ch‐albat scꞌoplalic: “Joꞌon Diosun yuꞌun li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove, xi li Diose”, xi li Moisese yuꞌun cuxulic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti lajemicuc o schiꞌuc schꞌulelic jech chac cꞌu chaꞌal chavalique, muꞌyuc Dios yuꞌunic yaꞌel. Li Diose jaꞌ Dios yuꞌunic li buchꞌutic cuxulic o sbatel osile. Jech ichꞌbil o ta mucꞌ sbatel osil li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Li buchꞌutic itacꞌavique jaꞌic jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, toj lec li cꞌusi la avale ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yan li jsaduceoetique mu xa cꞌusi yan la sjacꞌbeic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Li Jesuse jech laj yal scꞌoplal stuc: ―¿Cꞌu chaꞌal ta xalic ti jaꞌ snitilul David li Cristo li tꞌujbil yuꞌun Dios ti chventainvane? ");
INSERT INTO tzoSA_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Yuꞌun li Davide jech la stsꞌibabe scꞌoplal ta sjunal Salmose: Li Cajvale jech iꞌalbat yuꞌun li Diose: “Chachoti ta jbatsꞌicꞌob, chapas mantal jaꞌ to mi la jpas ta canal scotol la avajcontrataque”, xꞌutat li Cristoe, xi li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Li Davide “Cajval”, xut li buchꞌu tꞌujbil yuꞌun Dios ti chventainvane. ¿Cꞌu chaꞌal “Cajval”, xut mi jaꞌ snitilul noꞌoxe? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Scotol li jꞌisraeletic li te tsobolique iyaꞌiic ti cꞌalal jech laj yalbe yajchanbalajeltac li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Qꞌuelo me abaic yuꞌun chopol li cꞌusi tspasic li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Jaꞌ lec chaꞌiic ti nat scꞌuꞌic ta slapique. Lec chaꞌiic ti lequil cꞌoponbilic yuꞌun li jchiꞌiltactic li te ta chꞌivite. Lec chaꞌiic ti ta xchotiic li bu tꞌujbil chotlebal ta chꞌulnaetic schiꞌuc li ta jujun qꞌuine. ");
INSERT INTO tzoSA_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jech nojtoc ta sloꞌlobeic li cꞌustic oy yuꞌun li meꞌanal antsetique. Jaꞌ yuꞌun altic ti jal ta staic ta naꞌel li Diose. Ta onoꞌox xichꞌic tsots vocol ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Li Jesuse te sqꞌueloj li cꞌalal la sticꞌbeic smoton Dios li ta scaxail li te ta mucꞌta chꞌulna li jcꞌulejetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iyil nojtoc ti te ital jun meꞌanal ants ti mu cꞌusi oy yuꞌune. Jaꞌ noꞌox chaꞌsep cinco la sticꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Melel chacalbeic, jaꞌ más ep laj yacꞌ li meꞌanal ants leꞌe. Jaꞌ mu sta jech yepal laj yaqꞌuic li yanetic ta xil li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yuꞌun naca scomenal xa staqꞌuinic laj yaqꞌuic. Yan li meꞌanal antse laj yacꞌ scotol li cꞌu yepal oy yuꞌun sventa ta toꞌox sman o li cꞌustic ta xtun yuꞌune ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Oy jayvoꞌic laj yalbeic Jesús ti toj cꞌupilic sba li stanal li mucꞌta chꞌulna, schiꞌuc li cꞌustic slocꞌtaojic li te snapꞌanojic ta cꞌal chꞌulna ti jaꞌ la stojic li buchꞌutic ta sloqꞌuel yoꞌonic tscꞌan chacꞌbeic smoton li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Li Jesuse jech laj yal: ―Li chꞌulna liꞌi ti toj cꞌupil sba ta xquiltic li avie, chcꞌot scꞌacꞌalil ta xichꞌ jinesel scotol. Mu jpꞌejuc ton latsal chcom, scotol ta xichꞌ jinesel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jech la sjacꞌbeic li Jesuse: ―Jchanubtasvanej, ¿cꞌu ora chcꞌot ta pasel ti chjinesat li mucꞌta chꞌulna li la avale? ¿Cꞌu sba chavacꞌbe svinajeb baꞌi ti yoꞌ chquilcutic o ti poꞌot xa chcꞌot ta pasele? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Li Jesuse itacꞌav: ―Qꞌuelo me abaic, mu me buchꞌu xasloꞌloic. Yuꞌun oy ep buchꞌutic chalic ti jaꞌ sbi li jbie, jech chalic: “Joꞌon Cristoun ti tꞌujbilun yuꞌun Dios ti chajventainique”, xiic. Oy yan jech chalic: “Jaꞌ xa scꞌacꞌalil ta xtal li Cristoe”, xiic. Pero mu me xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cꞌalal chavaꞌiic ti oy cꞌop liꞌi schiꞌuc cꞌalal chavaꞌiic ti oy cꞌop ta nome, mu xaxiꞌic. Ta onoꞌox xcꞌot ta pasel pero maꞌuc toꞌox slajeb cꞌacꞌal ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jech laj yal nojtoc: ―Chlic saꞌic cꞌop li crixchanoetic ta yantic o balumile. Chlic saꞌic cꞌop li ajvaliletic nojtoque. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Schiꞌuc oy bu tsots ch‐echꞌ niquel ta balumil. Schiꞌuc oy bu tsots ch‐echꞌ viꞌnal schiꞌuc chamel. Chavilic ep senyail stsatsal sjuꞌel Dios ta vinajel, jaꞌ toj xiꞌelic sba. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Cꞌalal muc toꞌox bu chcꞌot ta pasele, chastsaquic, chasmajic, chayaqꞌuic ta scꞌob li buchꞌutic oy yabtelic ta chꞌulnaetique, chastiqꞌuic ta chuquel. Ta sventa ti avichꞌojicun ta muqꞌue, chayiqꞌuic batel ta stojol li ajvaliletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jaꞌ yuꞌun xuꞌ xavalic li jcꞌop ta stojolique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Naꞌic me, mu me xal avoꞌonic li cꞌusi chavalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yuꞌun joꞌon chajcoltaic ta cꞌop. Chcacꞌ apꞌijilic jech mu xaspasic ta canal li buchꞌutic chascontrainique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Oy atot ameꞌic noꞌox chayaqꞌuic ta cꞌabal, oy achiꞌiltaquic noꞌox ta voqꞌuel chayaqꞌuic ta cꞌabal, oy avutsꞌ avalalic noꞌox chayaqꞌuic ta cꞌabal. Oy jaꞌ noꞌox chayaqꞌuic ta cꞌabal li buchꞌutic lec chacꞌopon aba achiꞌuquique. Cꞌalal te xa oyoxuc ta scꞌobique, oy noꞌox buchꞌu chlaj ta milel avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ep buchꞌutic chopol chayilic ta sventa ti avichꞌojicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero jaꞌ noꞌox mi scꞌan stuc Dios ti chasmilique, chasmilic. Mi mu jechuc ta scꞌan li Diose, mu cꞌusi xuꞌ chaspasbeic. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Li buchꞌutic chcuch yuꞌun scotol li vocole, mi mu schibajes yoꞌonique, jaꞌ chcolic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Cꞌalal chavilic ti liꞌ joyolic yajsoltarotac li yan ajvalil ta spat xocon smacol li jteclum ti pasbil ta tone, naꞌic me ti yuꞌun icꞌot xa scꞌacꞌalil ti ta xichꞌ jinesele. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Acotolic ti liꞌ nacaloxuc ta Judea balumile, jatavanic batel ta anil ta vitstic. Li buchꞌutic liꞌ oy ta yut jteclume acꞌo loqꞌuicuc batel. Li buchꞌutic loqꞌuemic batele mu xa me xchaꞌochic talel. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yuꞌun icꞌot xa scꞌacꞌalil ti chavichꞌic vocol jech chac cꞌu chaꞌal tsꞌibabil onoꞌox comel yuꞌun li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Toj abol sbaic li buchꞌutic schiꞌuc yolique schiꞌuc li buchꞌutic ta to xchuꞌun yolique yuꞌun toj tsots chavichꞌic vocol yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oy noꞌox buchꞌu avuꞌunic chamileic ta machita. Oy noꞌox buchꞌu avuꞌunic chachuqueic, chaꞌiqꞌueic batel ta yosilal jyanlum crixchanoetic. Jech lachꞌayic o, joꞌoxuc ti liꞌ toꞌox nacaloxuc ta jteclum Jerusalene. Li jyanlum crixchanoetique iꞌoch xa ta sbaic li jteclume, jaꞌ xa ti cꞌusi tspasbeique. Jaꞌ to mi itsꞌaqui li cꞌu sjalil ta xꞌacꞌbat yichꞌic ta venta yuꞌun li Diose, jaꞌ to chjeltaj yajval. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Li cꞌalal poꞌot xaꞌox chichaꞌtale, oy cꞌusi ta xvinaj ta vinajel ti toj xiꞌel sba, toj labal sbae. Yuꞌun ta xcꞌataj li cꞌacꞌale, schiꞌuc li ue, schiꞌuc li cꞌanaletique. Jech nojtoc ta xjeltaj li cꞌu sba ta xnic li nabe. Más to tsots ta xyuqꞌuilan sba jech ta xiꞌic o li crixchanoetic ta spꞌejel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Li crixchanoetique muꞌyuc xa stsatsal yoꞌonic ta scoj li xiꞌele yuꞌun ta xiꞌic mi oy cꞌusi ta xcꞌot ta pasel liꞌ ta balumile. Yuꞌun scotol li cꞌustic te oy ta vinajele chlaj nicuc scotol. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jaꞌ xa o ta xilic scotol li crixchanoetique ti chiyal talel ta toc ta vinajel schiꞌuc jtsatsal schiꞌuc juꞌel, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cꞌalal chavilic chlic cꞌotuc ta pasel scotol li cꞌustic laj calboxuque, muybajanic noꞌox me yuꞌun xanaꞌic ti poꞌot xa chacolic o sbatel osile ―xut li yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Laj yalbe yan loꞌil nojtoc: ―Naꞌic me li cꞌu sba ta xchꞌi li teꞌel higo schiꞌuc scotol li yan teꞌetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cꞌalal ta xꞌunenaje, jaꞌ chanaꞌic o ti poꞌot xa yora joꞌtique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jaꞌ noꞌox jech li cꞌalal chavilic ti chcꞌot ta pasel scotol li cꞌusi laj cale, jaꞌ chanaꞌic o ti poꞌot xa scꞌacꞌalil chistacun talel li Diose yoꞌ chtal jpas mantal liꞌ ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Melel chacalbeic, li buchꞌutic iyaꞌiic li cꞌu sba chlic li tsots vocol li laj calboxuc liꞌi, oy toꞌox cuxuloxuc li cꞌalal chlique. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Li cꞌustic caloje mu xchꞌay scꞌoplal, ta onoꞌox xcꞌot ta pasel scotol. Jaꞌ xlaj to li vinajel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","’Qꞌuelo me abaic, maꞌuc noj me batem ta avoꞌonic li cꞌustic oy liꞌ ta balumile, schiꞌuc li cꞌustic chacꞌan atuquique, schiꞌuc li cꞌu sba chacuxiic liꞌ ta balumile. Mi yuꞌun jaꞌ noꞌox te batem o avoꞌonique, chꞌayem avoꞌonic chjul jtaoxuc li cꞌalal chichaꞌtale. Jech chac cꞌu chaꞌal jcot tsꞌiꞌ ti mu sqꞌuel li bu ta xꞌechꞌe, cꞌalal ta xaꞌie ochem ta petsꞌ, jaꞌ noꞌox jech eꞌuc li crixchanoetique, mu snaꞌic cꞌu ora ta xtal li ichꞌ vocol ta spꞌejel balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pero li joꞌoxuque vicꞌluc me asatic, taic ta naꞌel Dios scotol cꞌacꞌal ti acꞌo cuchuc avuꞌunic li vocol li ta xtale. Jaꞌ muꞌyuc amulic chacꞌotic ta jtojol, joꞌon li coꞌol crixchanoutique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Li Jesuse ta cꞌacꞌaltic te ichanubtasvan ta yamaqꞌuil li mucꞌta chꞌulna li te ta Jerusalene. Yan li ta jujun acꞌubale ilocꞌ batel, te ba vayuc ta vits Olivatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta jujun sob italic scotol li crixchanoetic li te ta yamaqꞌuil li mucꞌta chꞌulnae, yuꞌun chaꞌibeic scꞌop li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Poꞌot xaꞌox qꞌuin yuꞌun li jꞌisraeletique cꞌalal ta sveꞌic pan ti muc bu yichꞌoj svochesobile. Jaꞌ qꞌuin Coltael sbi. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose, la snopic li cꞌu sba xuꞌ tsmilic li Jesuse yuꞌun ta xiꞌic o li ta schiꞌiltaquique mi xꞌacꞌbatic ton, yuꞌun scotolic lec iyilic li cꞌustic tspas li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Li Satanase, jaꞌ li banquilal pucuje, iꞌoch ta yoꞌon li Judase, jaꞌ li Iscariote iꞌacꞌbat yan sbie. Jaꞌ jun li lajchavoꞌ yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Li Judase ba scꞌopon li banquilal paleetique schiꞌuc li banquilal mayoletic ti schabiojic li smucꞌta chꞌulnaic li te ta Jerusalene. Jaꞌ ba yalbe yaꞌiic ti ta spas trato ti chacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Cꞌalal iyaꞌiique, xmuybajic tajmec. Laj yalic cꞌu yepal taqꞌuin ta xacꞌbeic li Judase. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cꞌalal iyaꞌi Judas li cꞌu yepal taqꞌuin ta xꞌacꞌbate, xmuybaj xa. Isnop cꞌu ora xuꞌ chacꞌ ta cꞌabal li Jesuse yoꞌ jaꞌ mu xlic o cꞌop yuꞌunic li schiꞌiltac ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ista scꞌacꞌalil ta sveꞌic pan ti muc bu yichꞌoj svochesobile, schiꞌuc ta slajesic li chexel chijetic ta sventa qꞌuin Coltael jech chac cꞌu chaꞌal yaloj onoꞌox li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Li Jesuse la stac batel Pedro schiꞌuc li Juane. Jech laj yalbe batel: ―Batanic, ba meltsanic li chexel chij li ta jtiꞌtic ta sventa li qꞌuin Coltaele ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jech laj sjaqꞌuic: ―¿Bu chacꞌan chba jmeltsancutic? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Itacꞌav li Jesuse: ―Chacalbeic. Cꞌalal chaꞌochic ta Jerusalene, te chanupic ta be jun vinic scuchoj jpꞌej qꞌuib yaꞌal. Jaꞌ te tijil xabatic, te xaꞌochic eꞌuc li ta na li bu ta xꞌoche. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jech xcꞌot avalbeic li yajval nae: “Jech laj yal talel li Jchanubtasvaneje: ¿Bu jcꞌolucal ana li yoꞌ bu ta jtiꞌcutic chij ta sventa qꞌuin Coltael jchiꞌuc li cajchanbalajeltaque? xi laj yal talel”, utic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Te chacꞌ avilic jcꞌol sna ta schaꞌcojol sna ti lec jamal yute. Te xa schapanoj li cꞌustic ta xtun cuꞌuntique. Jaꞌ te xameltsanic li chije ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ibatic li chaꞌvoꞌique. Jaꞌ jech istaic jech chac cꞌu chaꞌal iꞌalbatic batel yuꞌun li Jesuse. Jaꞌ te la smeltsanic li chij sventa li qꞌuin Coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cꞌalal yora xa chveꞌique, ital li Jesuse. Te ichoti ta mexa schiꞌuc li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Li Jesuse jech lic yalbe li yajchanbalajeltaque: ―Ta sloqꞌuel coꞌon liꞌ chajchiꞌinic ta slajesel li chij ta sventa li qꞌuin Coltael li cꞌalal muc toꞌox bu smilojicune. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chacalbeic ti jaꞌ to ta jlajes nojtoc li chije ti cꞌalal te xa tsobolutic jcotoltic li yoꞌ bu ta jpas mantal yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Li Jesuse la stsac jun vaso yaꞌlel tsꞌusub, laj yalbe coliyal Dios. Jech laj yalbe li yajchanbalajeltaque: ―Ilo, uchꞌanic acotolic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chacalbeic ti jaꞌ to chcuchꞌ nojtoc li yaꞌlel tsꞌusube ti cꞌalal te xa tsobolutic jcotoltic li yoꞌ bu ta jpas mantal yuꞌun li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","La stam nojtoc jpꞌej pan, laj yalbe coliyal Dios, la xut li pane, laj yacꞌbe li yajchanbalajeltaque. Jech laj yalbe: ―Liꞌi jaꞌ jbecꞌtal yuꞌun chcacꞌ jba ta milel ta acojic. Jech me xapasulanic yoꞌ jech chanaꞌic o ti joꞌoxuc ta acojic ti lichame ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cꞌalal ilaj yoꞌonic ta veꞌele, la stsac nojtoc li vasoe, jech laj yalbe li yajchanbalajeltaque: ―Li yaꞌlel tsꞌusub li liꞌ chavuchꞌique, jaꞌ svinajeb ti mu xlaj scꞌoplal ti cꞌusi yaloj onoꞌox li Jtot ti ta sventa jchꞌichꞌel ta jꞌechꞌel ta xchꞌay o la amulique. Yuꞌun jtuc chcacꞌ jba ta milel, ta jmal jchꞌichꞌel, jaꞌ jech ta xtoj o la amulique. Jaꞌ yuꞌun mu xa cꞌusi chavaqꞌuic ta stojol li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Chacalbeic, li buchꞌu chiyacꞌ ta cꞌabale, jaꞌ liꞌ coꞌol oyutic ta mexa jchiꞌuctique. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yuꞌun jech onoꞌox yaloj Dios ti chismilique, joꞌon li coꞌol crixchanoutique. Pero toj abol sba li buchꞌu chiyacꞌ ta cꞌabale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Li yajchanbalajeltaque lic sjacꞌbe sbaic buchꞌu junucal yuꞌunic ti ta xacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Li yajchanbalajeltac li Jesuse la svulilan sbaic ta sventa buchꞌu chcom ta más banquilal yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Li Jesuse jech lic yalbe: ―Li ajvaliletic yuꞌun li jyanlum crixchanoetique jaꞌ noꞌox ta spasic mantal. Tstoy sbaic ta stojol li svinictaquique. Acꞌo mi jech tspasic, pero ta scꞌanic “lec ta xcꞌuxubinvanic leꞌe”, tscꞌanic ti xi scꞌoplalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero li joꞌoxuque mu me xapasic jech. Li buchꞌu junucal avuꞌunic ti tscꞌan chcom ta banquilal avuꞌunique, ti tscꞌan ichꞌbil ta muqꞌue, acꞌo sbicꞌtajes sba ta atojolic, acꞌo tunuc avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nopic li cꞌu sba li buchꞌu banquilaletic liꞌ ta balumile ti naca noꞌox tspasic mantale, muc bu ch‐abtejic. Yan li joꞌone mu jechuc ta jpas. Yuꞌun joꞌon tal tuncun avuꞌunic liꞌ ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Li joꞌoxuque jun avoꞌonic la achiꞌinicun li cꞌalal laj quichꞌulan contrainele. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Jaꞌ yuꞌun chacacꞌbe avabtelic. Yuꞌun laj xa yacꞌbun cabtel li Jtotique ta xcꞌot scꞌacꞌalil ta jpas mantal. Jaꞌ yuꞌun ta jchiꞌin jbatic ta pasmantal. Muybajanic noꞌox cꞌalal chcꞌot scꞌacꞌalile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Li Cajvaltique jech laj yalbe li Simone: ―Simón, aꞌio, li Satanase a xa scꞌan ta stojol Dios ti ta sqꞌuelboxuc avoꞌonic li avie. Yuꞌun ta scꞌan ti acꞌo chibajuc avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero li joꞌote laj xa jcꞌoponbot Dios yoꞌ jech mu xchibaj o avoꞌon. Cꞌalal chlic asutes avoꞌon nojtoque, tsatsubtasbo yoꞌonic li buchꞌutic coꞌol chavichꞌicun ta muqꞌue ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Li Pedroe jech laj yal: ―Cajval, acꞌo mi chistiqꞌuic ta chuquel, acꞌo mi chismilic, li joꞌone muc bu chaquicta ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Itacꞌav li Jesuse: ―Pedro, chacalbe, tana cꞌalal muc toꞌox bu oqꞌuem jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Li Jesuse jech lic yalbe scotolic: ―Cꞌalal la jtacoxuc batel ta yalel li jcꞌope, muꞌyuc ataqꞌuinic, muꞌyuc aveꞌelic, muꞌyuc axonobic batel. ¿Mi oy cꞌusi muc xataic? ―xut. Itacꞌavic: ―Moꞌoj, la jtacutic scotol ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Li Jesuse jech laj yalbe: ―Jech chac cꞌu chaꞌal soltaroetic ti ta schapan sbaic lec yuꞌun ta scꞌan ta spasvanic ta canal ta cꞌope, ta xichꞌ batel staqꞌuinic schiꞌuc sveꞌelic. Mi muꞌyuc smachitae, ta schon spuychijic yoꞌ ta sman o li smachitae. Jaꞌ noꞌox jech eꞌuc li joꞌoxuc li avie, jaꞌ scꞌan ti chachꞌunic ti chascoltaic li Diose jech chcuch avuꞌunic li cꞌalal chavichꞌic contrainele. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yuꞌun persa ta xcꞌot ta pasel scotol ti jech onoꞌox tsꞌibabil jcꞌoplale: “Ta spꞌise ta jpasmulil”, xi onoꞌox tsꞌibabil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Li yajchanbalajeltaque jech lic yalic: ―Cajval, liꞌ oy chib machitae ―xutic. Itacꞌav li Cajvaltique: ―Tequeꞌ ―xi. (Ti jech itacꞌav li Cajvaltique, yuꞌun iyaꞌi ti muc bu xaꞌibeic smelol li cꞌusi laj yale.) ");
INSERT INTO tzoSA_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ilocꞌ batel li Jesuse, ibat ta vits Olivatic yuꞌun te onoꞌox ta xcꞌotilan. Ichiꞌine batel yuꞌun li yajchanbalajeltaque. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cꞌalal icꞌotique, li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Taic ta naꞌel Dios yoꞌ jech mu xaspasic ta canal li pucuje ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Li Jesuse ijelav batel jutuc. Jaꞌ jech snamal ibat jech chac cꞌu chaꞌal snamal chcꞌot xijtenobaj ta tone. Te la squejan sba, la sta ta naꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jech laj yal: ―Tata, ti jech la xacꞌan ti mu xichame, lec chcaꞌi. Pero maꞌuc me xcꞌot ta pasel li cꞌusi ta jcꞌan jtuque. Jaꞌ acꞌo jpas li cꞌusi chacꞌan atuque ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Li Jesuse iyil jun chꞌul ángel tacbil talel. Tal acꞌbatuc stsatsal sbecꞌtal stacupal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yuꞌun mu xa xcuch chaꞌi li svocole jaꞌ yuꞌun ep ista ta naꞌel Dios. Ep ichiqꞌuin. Li schiqꞌue jaꞌ jech chac cꞌu chaꞌal chꞌichꞌ xpꞌajlajet ilocꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cꞌalal ilaj yoꞌon ta stael ta naꞌel li Diose, isut talel li yoꞌ bu oyic li yajchanbalajeltaque. Vayalic cꞌot sta yuꞌun toj echꞌem chat yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jech cꞌot yalbe: ―¿Cꞌu chaꞌal chavayic? Jaꞌ lec licanic, taic ta naꞌel Dios yoꞌ jech mu xaspasic ta canal li pucuje ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Cꞌalal jaꞌ o yacal ta loꞌil li Jesuse, ital ep crixchanoetic. Jaꞌ sbabe talel li Judase, jaꞌ li yajchanbalajel toꞌox li Jesuse. Li Judase te icꞌot li yoꞌ bu oy li Jesuse, cꞌot stsꞌutsꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Li Jesuse jech laj yal: ―Judas, mu junuc avoꞌon ta jtojol ti chatsꞌutsꞌunune, jaꞌ noꞌox ta sventa li cꞌu sba chavacꞌun o ta cꞌabal, joꞌon li coꞌol crixchanoutique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cꞌalal iyilic li yajchanbalajeltac Jesús ti jaꞌ tal stsaquic li Jesuse, jech lic yalbeic li Jesuse: ―Cajval, mi chacꞌane, chcacꞌbecutic machita ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oy jun buchꞌu la sloqꞌues smachita. La sjaxbe ta bojel jun schiquin li yajtunel li más banquilal palee. Li schiquin li iboj loqꞌuele jaꞌ sbatsꞌichiquin. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Li Jesuse jech laj yalbe li yajchanbalajeltaque: ―Mu me xapajesic li crixchanoetique. Acꞌo spasbecun li cꞌusi ta scꞌanique ―xut. Li Jesuse la spicbe li syaijemal schiquin li jtunele, lec xa icom schiquin. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Li Jesuse jech laj yalbe li jchucvanejetique, jaꞌ li banquilal paleetique, schiꞌuc li banquilal mayoletic ti schabiojic li smucꞌta chꞌulnaique, schiꞌuc li jꞌabteletique: ―¿Cꞌu chaꞌal tal atsaquicun jech chac cꞌu chaꞌal jun jꞌelecꞌ, tsꞌaclomoxuc xa talel ta amachitaic, ta ateꞌic? ");
INSERT INTO tzoSA_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yuꞌun scotol cꞌacꞌal te oyun ta atojolic ta yamaqꞌuil li mucꞌta chꞌulnae. ¿Cꞌu chaꞌal mu teuc noꞌox la atsaquicun? Ti jech la atsaquicune, yuꞌun iꞌacꞌbat yuꞌun Dios la avajvalique, jaꞌ li Satanás li sventainoj li mulile ―xut li jchucvanejetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Cꞌalal la stsaquic li Jesuse, laj yiqꞌuic batel ta sna li más banquilal palee. Li Pedroe nomnom tijil batel ta spat li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Te la snopꞌic cꞌocꞌ ta yamaqꞌuil sna li más banquilal palee yuꞌun ta xcꞌatinic. Te ichotiic ta tiꞌ cꞌocꞌ. Li Pedroe te la schiꞌin ta chotlej li yanetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Oy jun criara iyil ti te chotol ta xcꞌatin li Pedroe. Yuꞌun lec tilem li cꞌoqꞌue jaꞌ yuꞌun iꞌile. La sqꞌuelbe lec sat, jech lic yal: ―Liꞌi jaꞌ schiꞌil sbaic schiꞌuc li buchꞌu leꞌ tsacbile ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Li Pedroe laj yal ti mu xojtaquine. Jech laj yal: ―Mu xcojtaquin li vinic chavale, yaa ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ta jliquel te iꞌojtaquine yuꞌun yan nojtoc. Jech iꞌalbat: ―Joꞌote jaꞌ achiꞌil eꞌuc li vinic leꞌe ―xꞌutat. Itacꞌav li Pedroe: ―Tata, mu joꞌcun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Oy xaꞌox nan ta jun ora oy buchꞌu yan jech iꞌalbat scꞌoplal li Pedroe: ―Ta melel jaꞌ schiꞌil li Jesuse yuꞌun jaꞌ te liquem talel ta Galilea eꞌuc ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Itacꞌav li Pedroe: ―Tata, mu jnaꞌ li cꞌusi chavale ―xi. Jaꞌ o iꞌocꞌ jcots. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Li Jesuse la sqꞌuelbe sat li Pedroe. Ijul ta sjol li Pedroe ti jech onoꞌox iꞌalbat yuꞌun li Cajvaltique: “Cꞌalal muc toꞌox bu oqꞌuem jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune”, xꞌute onoꞌox yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ilocꞌ batel li Pedroe, toj echꞌem laj yoqꞌuita sba. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Li jayvoꞌ li iꞌacꞌbat schabiic li Jesuse lic snaꞌleic, la smajic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","La smacbeic sat ta pocꞌ. La slecꞌbeic ta majel xocon sat, jech laj yalbeic: ―Alo buchꞌu li la smajote ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ep la slabanic. Ep cꞌusi chopol laj yalbeic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cꞌalal isacub osile, la stsob sbaic scotol li jꞌabteletic yuꞌunic li jꞌisraeletique, jaꞌ li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Laj yiqꞌuic batel Jesús li bu ta stsob sbaique. Jech laj yalbeic: ");
INSERT INTO tzoSA_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Albuncutic ta jamal mi joꞌot Cristoot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique ―xutic. Itacꞌav li Jesuse: ―Mi chacalbeic ti joꞌon li Cristoune, mu xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mi oy cꞌusi chajacꞌbeique, mu xatacꞌavic. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Joꞌon li coꞌol crixchanoutique ista xa scꞌacꞌalil ti chba chotlucun ta sbatsꞌicꞌob li Diose. Jaꞌ te chlic jpas mantal ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Scotolic jech laj yalic: ―¿Mi joꞌot Snichꞌonot Dios apꞌisoj aba? ―xutic. ―Joꞌon ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jech laj yalbe sbaic: ―¿Cꞌu chaꞌal ta jsaꞌtic yan textico? Laj xa caꞌitic ti ta stoy sba ta stojol li Diose ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ilic scotolic, laj yiqꞌuic batel ta stojol Pilato li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te lic sticꞌbeic smul. Jech laj yalic: ―Li vinic liꞌi ta xal ti mu xuꞌ ta xcacꞌbecutic jpatancutic li mucꞌta ajvalil Césare, yuꞌun ta xal ti jaꞌ ajvalil stuque. Ta xal ti jaꞌ tꞌujbil yuꞌun Dios ti chisventainuncutique. Ta stsob svinictac yuꞌun ta scꞌan ta sliques cꞌop liꞌ ta cosilalcutique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Li Pilatoe la sjacꞌbe li Jesuse: ―¿Mi joꞌot ajvalilot yuꞌun la achiꞌiltac ta israelale? ―xut. Itacꞌav li Jesuse: ―Joꞌon ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Li Pilatoe jech lic yalbe li banquilal paleetique schiꞌuc scotol li crixchanoetique: ―Muc bu la jtabe smul li vinic liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jech tsots lic cꞌopojicuc nojtoc: ―Mu me xacolta batel yuꞌun jaꞌ ta soc li jchiꞌiltacutique. Ta xchanubtasvan ta scotol cosilalcutic liꞌ ta Judeae. Ta sliquebe te ichanubtasvan ta Galilea. Li avie liꞌ xa itale ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cꞌalal iyaꞌi Pilato ti jaꞌ baꞌi te lic chanubtasvanuc ta Galilea li Jesuse, la sjacꞌbe li crixchanoetic mi jaꞌ te liquem talel ta Galileae. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cꞌalal iyaꞌi ti te liquem talel ta Galilea li Jesuse, ijul ta sjol Pilato ti jaꞌ ichꞌbil ta venta yuꞌun li ajvalil Herodese. Jaꞌ yuꞌun la stac batel li yoꞌ bu oy li Herodese yuꞌun te talem ta paxyal ta Jerusalén. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Cꞌalal iyil Jesús li Herodese, xmuybaj xa. Yuꞌun voꞌone caj chac yojtaquin yuꞌun yaꞌiojbe scꞌoplal ti oy cꞌustic tspas li Jesuse. “Ti oy la bu chquil ti cꞌu sba chacꞌ ta ilel stsatsal sjuꞌel li Jesuse”, xi onoꞌox ta yoꞌon li Herodese. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Li Herodese lic sjacꞌulanbe li cꞌu sba xuꞌ yuꞌun chacꞌ ta ilel li stsatsal sjuꞌele. Li Jesuse mu jpꞌeluc bu itacꞌav. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Te oyic li banquilal paleetique schiꞌuc li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Soquem sjolic ta stojol li Jesuse. Ta sloqꞌuel yoꞌonic la sticꞌbeic smul ta stojol li Herodese. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Li Herodese schiꞌuc li yajsoltarotaque muc bu xichꞌic ta mucꞌ li Jesuse. Jaꞌ noꞌox la slabanic, la slapbeic natil cꞌuꞌil sventa ajvaliletic. Tsꞌacal to la staquic sutel ta stojol li Pilatoe, te slapoj batel li cꞌuꞌile. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Li Pilatoe scontrainoj sbaic toꞌox schiꞌuc li Herodese, pero cꞌalal la stac batel ta stojol Herodes li Jesuse, te ilaj o yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Li Pilatoe laj yicꞌan talel scotol li banquilal paleetique, schiꞌuc li jꞌabteletic yuꞌunic li jꞌisraeletique, schiꞌuc scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jech laj yalbe: ―La achiꞌilic liꞌi la avalic ti jaꞌ ta soc scotol la achiꞌiltaquique, jaꞌ yuꞌun la aviqꞌuic talel liꞌ ta jtojole. Pero laj xa quichꞌbe scꞌop liꞌ ta atojolique. Mu jsetꞌuc la jtabe smul. Mu meleluc li cꞌusi la avalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jech nojtoc li Herodese muc bu stabe smul eꞌuc. Ti lauc stabe smule, muc bu stac sutel liꞌ ta jtojol ti jechuque. Jech muꞌyuc smul ti chavaqꞌuic ta milele. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jaꞌ noꞌox chcal ti acꞌo yichꞌ tsitsele, ta jcolta batel ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Li Pilatoe ta persa ta scolta batel jun jchuquel ta jujun qꞌuin Coltael li bu junucal tscꞌanbeic scolel li jꞌisraeletique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jech scotol li crixchanoetique tsots lic cꞌopojicuc: ―Leꞌe acꞌo ba yichꞌ jocꞌanel ta cruz. Jaꞌ acꞌo coluc li Barrabase ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Li Barrabase itiqꞌue ta chuquel ta scoj ti la stsob svinictac yuꞌun la scontrain li ajvalil li te ta Jerusalene, schiꞌuc imilvan nojtoc. Jaꞌ jꞌisraelal vinic.) ");
INSERT INTO tzoSA_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Li Pilatoe la schaꞌcꞌopon li jꞌisraeletique yuꞌun chac scolta batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tsots lic cꞌopojicuc nojtoc li crixchanoetique: ―¡Jocꞌano ta cruz! ¡Jocꞌano ta cruz! ―xiic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Li Pilatoe jech la schaꞌjacꞌbe yoxibal velta li crixchanoetique: ―Pero ¿cꞌusi smul avuꞌunic? Li joꞌone muc bu jtabe smul ti ta xmilee. Jaꞌ noꞌox chcal ti acꞌo yichꞌ tsitsel ta nucule, ta jcolta batel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero más to tsots icꞌopojic: ―¡Jocꞌano ta cruz! ―xiic. Cꞌalal jech la sujic Pilato li crixchanoetique schiꞌuc li banquilal paleetic yuꞌunique, ichꞌunbatic li cꞌusi iyalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Li Pilatoe laj yal mantal ti acꞌo ba jocꞌanatuc ta cruz li Jesuse yuꞌun jech la scꞌanic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jaꞌ la scolta batel li buchꞌu la scꞌanbeic scolele, jaꞌ li itiqꞌue ta chuquel ta scoj ti la stsob svinictac yuꞌun la scontrain li ajvalile, schiꞌuc ti imilvan nojtoque. Li Pilatoe laj yacꞌ ta cꞌabal li Jesuse yoꞌ acꞌo spasbeic li cꞌusi ta scꞌanique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Li soltaroetique laj yiqꞌuic batel li Jesuse. Cꞌalal sqꞌuechoj xa batel scruzal li Jesuse, te la snupic ta be jun jꞌisraelal vinic, Simón sbi. Cirene sbi li slumale. Te ta xꞌoch batel ta Jerusalén. La stsaquic, iyacꞌbeic echꞌel sqꞌuechbeel scruzal li Jesuse. Jaꞌ sbabe batel li Jesuse, jaꞌ tijil batel li Simone. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oy ep viniquetic schiꞌuc ep antsetic la schiꞌinic batel li Jesuse. Li antsetique toj echꞌem laj yoqꞌuitaic li Jesuse. Toj echꞌem iyat yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Li Jesuse la scꞌopon: ―Antsetic, joꞌoxuc li liꞌ nacaloxuc ta Jerusalene, mu me xavoqꞌuitaicun. Oqꞌuita aba atuquic schiꞌuc oqꞌuitaic la avalabique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yuꞌun ta xcꞌot scꞌacꞌalil ta xtal ichꞌ vocol. Jech chavalic: “Jaꞌ lec li buchꞌutic mu onoꞌox snaꞌ xꞌalajique yuꞌun mu sta jech chichꞌic vocol jech chac cꞌu chaꞌal chquichꞌtic, joꞌotic ti oy coltique”, xachiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Joꞌoxuc li liꞌ oyoxuc ta Jerusalene jech chlic avalic: “Ti oy la cꞌuxi jinuc talel li vitse ti acꞌo snetꞌutique”, xachiic yuꞌun toj tsots li ichꞌ vocol chtale. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Li joꞌone ta jchꞌun scotol li cꞌustic yaloj li Diose pero ep chiyacꞌbeic quichꞌ vocol. Li joꞌoxuc li mu xachꞌunic li cꞌustic yaloj li Diose, ¡cꞌuxi ta xcuch avuꞌunic li vocol ta xtal ta atojolique! ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oy chaꞌvoꞌ jꞌisraelal viniquetic iꞌiqꞌueic batel eꞌuc ti tsots smulique, coꞌol ba yichꞌic jocꞌanel ta cruz schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cꞌalal icꞌotic li yoꞌ bu Baquil Jolil sbi li balumile, te la sjocꞌanic ta cruz li Jesuse schiꞌuc li chaꞌvoꞌ viniquetic ti tsots smulique. Jun cruz ta sbatsꞌicꞌob, jun ta stsꞌetcꞌob li scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Li Jesuse lic scꞌoponbe Dios li crixchanoetique: ―Tata, pasanbo perton yuꞌun mu snaꞌic li cꞌusi tspasique ―xi. Li soltaroetique la spasic canal tajimol yoꞌ jech chilic bu jlicucal li scꞌuꞌ spacꞌaltac Jesús ti ta xichꞌbeic jujunique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Li crixchanoetic li te vaꞌalic ta xqꞌuelvanique, la snaꞌleic li Jesuse. Te vaꞌalic eꞌuc li jmeltsanejcꞌopetique, la snaꞌleic eꞌuc li Jesuse. Jech laj yalic: ―La scoltaan li crixchanoetique. Mi melel ti tꞌujbil yuꞌun Dios ti chisventainutique, acꞌo scolta sba stuc ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Li soltaroetique ti naca jromail viniquetique ilabanvanic eꞌuc. Inopojic talel, laj yacꞌbeic yuchꞌ pajal yaꞌlel tsꞌusub li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jech laj yalbeic: ―Mi melel ti joꞌot mucꞌta ajvalilot yuꞌun la achiꞌiltac ta israelale, colta aba atuc ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oy jpech teꞌ te bajbil ta sjol scruzal li Jesuse tsꞌibabil ta griego cꞌop, schiꞌuc ta latin cꞌop, schiꞌuc ta hebreo cꞌop. Jech chal: “Liꞌi jaꞌ li mucꞌta ajvalil yuꞌun li jꞌisraeletique”, xi tsꞌibabil li ta teꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Li viniquetic ti tsots smulic li te coꞌol jocꞌolic ta cruz schiꞌuc li Jesuse, jun la stoy sba ta stojol li Jesuse, jech laj yal: ―Mi melel ti joꞌot Cristoot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique, colta aba atuc. Jech coltauncutic eꞌuc ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Li june la spajes li schiꞌile, jech laj yalbe: ―¿Mi mu xaxiꞌ li Dios ti chatoy aba ta stojol li vinic li liꞌ coꞌol chijmileutique? ");
INSERT INTO tzoSA_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Li joꞌotique oy jmultic jaꞌ yuꞌun ta xquichꞌtic vocol. Yuꞌun jaꞌ chijꞌacꞌbat jtojtic li cꞌustic chopol la jpastique. Li vinic liꞌi mu cꞌusi chopol spasoj ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Li vinic ti la spajes li schiꞌile jech laj yalbe li Jesuse: ―Cajval, naꞌun me ti cꞌalal chtal apas mantal liꞌ ta balumile ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Itacꞌav li Jesuse: ―Melel chacalbe, li avie chachiꞌinun batel ta vinajel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Cꞌalal jech laj yal li Jesuse, oꞌlol xaꞌox cꞌacꞌal. Jaꞌ o icom ta icꞌal acꞌubal ta spꞌejel balumil cꞌalal to ta oxib ora ta mal cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Imac sat li cꞌacꞌale. Li mucꞌta pocꞌ li te lichꞌil ta yut li mucꞌta chꞌulna ta Jerusalene ijat ta oꞌlol. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Li Jesuse tsots icꞌopoj, jech laj yal: ―Tata, chcacꞌ ta acꞌob li jchꞌulele ―xi. Jaꞌ xa o ilocꞌ schꞌulel. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cꞌalal iyil li banquilal soltaro li cꞌustic icꞌot ta pasele, iyichꞌ ta mucꞌ li Diose, jech laj yal: ―Ta melel muꞌyuc smul li vinic liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Scotol li crixchanoetic li te tsobolique cꞌalal iyilic scotol li cꞌustic icꞌot ta pasele, isutic batel ta snaic. La smajulan batel stiꞌ yoꞌonic yuꞌun ixiꞌic mi ch‐acꞌbat yichꞌic vocol yuꞌun Dios ta scoj ti la smilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Scotol li buchꞌutic lec la scꞌopon sbaic schiꞌuc li Cajvaltique, schiꞌuc li yajchanbalajeltac li Cajvaltique, schiꞌuc li antsetic li liquemic talel ta Galilea li la schiꞌinic talel li Jesuse, nomnom vaꞌalic la sqꞌuelic scotol li cꞌustic icꞌot ta pasele. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Te oy jun vinic, José sbi, liquem talel ta jteclum Arimatea ta Judea balumil. Jaꞌ jmeltsanejcꞌop li te ta mucꞌta chꞌulna ta Jerusalene. Jaꞌ lequil vinic. Smalaoj chtal ventainaticuc yuꞌun li Diose. Lec tucꞌ yoꞌon, muc bu la sticꞌ sba li cꞌalal la saꞌbeic smul Jesús li yan jmeltsanejcꞌopetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ba scꞌopon Pilato, ba scꞌanbe li sbecꞌtal stacupal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Li Pilatoe laj yal mantal ti acꞌo yacꞌbeel batele. Li Josee ba syalesbe ta cruz li sbecꞌtal stacupal li Jesuse. La spix ta saquil pocꞌ, te ba smuc ta jombil chꞌut chꞌen. Achꞌ chꞌen to, muꞌyuc to buchꞌu mucbil tey. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mal xaꞌox cꞌacꞌal ti la smuquique. Jaꞌ xa o scꞌacꞌalil ta schapan sbaic sventa ta xcuxic mi ichꞌay cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Li antsetic li liquemic talel ta Galilea li la schiꞌinic talel li Jesuse, ibatic ta muquenal eꞌuc. Iyilic bu la smucbeic comel sbecꞌtal stacupal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cꞌalal iyilique, isutic batel ta snaic. Cꞌalal icꞌotic ta snaique, la smeltsanic ta ora muil vomoletic yuꞌun jaꞌ chba yacꞌbeic ta sbecꞌtal stacupal li Cajvaltique yoꞌ jech mu xtuib o ta ora. Yuꞌun jaꞌ jech stalelic o li jꞌisraeletique. Pero muc bu xba yaqꞌuic ta ora yuꞌun jaꞌ xa scꞌacꞌalil ta xcuxic jech chac cꞌu chaꞌal ta xal li mantaletic yuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta sba scꞌacꞌalil li xemanae, jaꞌ li romincoe, ibatic ta muquenal li antsetique. Scꞌan toꞌox sacub osil li cꞌalal ibatique. Yichꞌojic batel li muil vomoletic li la smeltsanique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cꞌalal icꞌotique, tselelinbil xaꞌox loqꞌuel cꞌot staic li mucꞌta ton li macbil o stiꞌ li chꞌene. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iꞌochic ta yut li chꞌene pero muc xa bu te oy istaic li sbecꞌtal stacupal li Cajvaltic Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cꞌalal te ta xcꞌopoj yoꞌonique, te vaꞌalic iyilic ta stsꞌelic chaꞌvoꞌ coꞌol schiꞌuc viniquetic yilel. Toj sac li scꞌuꞌique ta xtupꞌ o tajmec jsatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ixiꞌic tajmec li antsetique, la squejan sbaic. Jech iꞌalbatic yuꞌun li viniquetique: ―¿Cꞌu chaꞌal tal aqꞌuelic liꞌ ta muquenal li buchꞌu cuxul o sbatel osile? ");
INSERT INTO tzoSA_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Muc xa bu liꞌi, ichaꞌcuxi xa loqꞌuel. Naꞌic me ti jech onoꞌox laj yalboxuc li cꞌalal te toꞌox oyoxuc ta Galileae. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jech laj yal: “Ta persa chiꞌaqꞌue ta scꞌob jpasmuliletic, joꞌon li coꞌol crixchanoutique. Chisjocꞌanic ta cruz, te chismilic. Chismuquic, pero ta yoxibal cꞌacꞌal chichaꞌcuxi loqꞌuel ta jmuquenal”, xayutic onoꞌox ―xꞌutatic li antsetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Li antsetique ijul ta sjolic ta ora ti jech onoꞌox albilique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Iloqꞌuic ta yut li chꞌene, isutic batel. Li cꞌustic iꞌalbatique ba yalbe yaꞌiic li buluchvoꞌ yajchanbalajeltac li Jesuse schiꞌuc li yanetique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Li antsetic li ba yalbeic li yajtacbalaltac li Jesuse, jaꞌ li María li liquem talel ta Magdalae, schiꞌuc Juana, schiꞌuc otro jun María, jaꞌ li smeꞌ Jacoboe, schiꞌuc yan antsetic li te schiꞌuquique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Li jtacbalaletique la snopic ti altic li cꞌusi ta xalic li antsetique, jech muc bu schꞌunic li cꞌusi laj yalique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yan li Pedroe ta ora ibat ta anil ta smuquenal li Jesuse. Cꞌalal icꞌote, la snachꞌta ochel li yut chꞌene. Iyil ti jaꞌ xa noꞌox te oy li saquil pocꞌ li la spixbeic o sbecꞌtal stacupal li Cajvaltique. Mu xa bu te oy li sbecꞌtal stacupale. Jech ep icꞌopoj batel yoꞌon li cꞌalal isut batele. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta scꞌacꞌalil cꞌalal ichaꞌcuxi loqꞌuel ta chꞌen li Cajvaltique, ta mal cꞌacꞌal oy chaꞌvoꞌ ti yichꞌojic ta mucꞌ li Jesuse, iloqꞌuic batel ta Jerusalén, te ibatic ta sbelel li colonia Emáus sbie. Oy nan chibuc reva xil sbaic schiꞌuc li Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Te tslabanic batel li cꞌu sba la smilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cꞌalal jaꞌ o tslabanique, te ital ta spatic li Jesuse. Te schiꞌuquic batel ta xanbal. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero imacbat satic yuꞌun li Diose jech muc bu xojtaquinic mi jaꞌ Jesús li te schiꞌuquic batel ta bee. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jech ijacꞌbatic yuꞌun li Jesuse: ―¿Cꞌusi li yacal chavalique? ―xꞌutatic. Te ipajic. Li Jesuse iyil ti toj echꞌem ta xat yoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Itacꞌav li june, jaꞌ Cléofas sbi: ―Li jchiꞌiltactic li te talemic ta qꞌuelqꞌuin ta Jerusalene iyaꞌiic scotolic li cꞌusi jaꞌ to noꞌox icꞌot ta pasel li te ta Jerusalene. ¿Cꞌu chaꞌal muc bu xavaꞌi li joꞌote? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Itacꞌav li Jesuse: ―¿Cꞌusi icꞌot ta pasel? ―xi. Itacꞌavic: ―Yuꞌun la smilic li Jesús li liquem talel ta Nazarete. Jaꞌ li buchꞌu iyal scꞌop Diose. Lec icoltaat yuꞌun Dios jech iyacꞌulan ta ilel stsatsal sjuꞌel. Schiꞌuc lec ichanubtasvan, icꞌot ta coꞌoncutic li scꞌope. Lec iꞌile yuꞌun jchiꞌiltactic ta israelal. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jaꞌ noꞌox li banquilal paleetic schiꞌuc li jmeltsanejcꞌopetic cuꞌuntique iꞌacꞌvanic ta cꞌabal. Ta stojol li ajvalile imeltsaj scꞌoplal yuꞌunic ti ta persa ta xchame. La sjocꞌanic ta cruz. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Li joꞌoncutique jpatoj coꞌoncutic ti jaꞌ ta xꞌoch ta ajvalilal cuꞌuntique, joꞌotic li jꞌisraelutique. Pero yoxibal xa cꞌacꞌal ti imilee. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero oy cꞌusi yan icaꞌicutic sob nax. Toj chꞌayel o coꞌoncutic ta sventa li cꞌusi laj yalbuncutic li antsetic li coꞌol la jchiꞌincutic li Jesuse. Yuꞌun iꞌayic sob nax ta smuquenal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Pero muc xa bu te oy istaic li sbecꞌtal stacupal li Jesuse. Cꞌalal iyilic ti muc xa bu te oye, isutic batel, ba yalbuncutic. Te la iyilic chꞌul ángeletic ti laj yalic ti chaꞌcuxiem xa li Cristoe. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ibatic jayvoꞌ jchiꞌiltac eꞌuc, a sqꞌuelbeic li smuquenale. Li cꞌu sba laj yalic li antsetique jaꞌ jech iyilic eꞌuc. Pero muc bu xilic eꞌuc li Jesuse ―xutic li Jesús li chaꞌvoꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jech iꞌalbatic yuꞌun li Jesuse: ―Muc bu pꞌijoxuc. Vocol chachꞌunic scotol li cꞌustic yalojic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mi mu jechuc tsꞌibabil ti ta persa baꞌi ta xichꞌ vocol li Cristoe, ti tsꞌacal to ta xꞌoch ta ajvalilale? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Li Jesuse iꞌalbat yaꞌiic scotol li bu tsꞌibabil scꞌoplal ta scꞌop li Diose. Jaꞌ baꞌi laj yal li bu la stsꞌiba comel li Moisese, xchapet laj yal li cꞌusi la stsꞌibaic li yan li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Cꞌalal icꞌotic ta Emáuse, li Jesuse jꞌechꞌel ox ch‐echꞌ batel yilel. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Li chaꞌvoꞌ viniquetique la spajesic. Jech laj yalbeic: ―Pajan liꞌi, och chiꞌinuncutic yuꞌun icꞌ xa osil ―xutic. Ischꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cꞌalal te schiꞌuquic ta chotlej ta mexae, la stam jpꞌej pan li Jesuse, laj yalbe coliyal Dios, la xut li pane, laj yacꞌanbe. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cꞌalal jech la spas li Jesuse, te lic acꞌbatuc yojtaquinic yuꞌun Dios. Pero ta ora te isac‐chꞌay li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jech laj yalbe sbaic: ―¿Cꞌu chaꞌal muc bu jnaꞌtic mi jaꞌ li Cajvaltique yuꞌun toj lec laj caꞌitic li cꞌalal laj yalbutic talel ta be li smelol li scꞌop Diose? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Isutic batel ta ora ta Jerusalén, ba yalbeic li schiꞌiltaquic li coꞌol yichꞌojic ta mucꞌ li Cajvaltique. Te tsobolic cꞌot staic li buluchvoꞌ yajchanbalajeltac li Jesuse schiꞌuc oy yan schiꞌiltaquic li te oyique. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jech iꞌalbatic yuꞌun li schiꞌiltaquic li te ta Jerusalene: ―Ta melel chaꞌcuxiem xa li Cajvaltique. Laj xa yacꞌ sba ta ilel ta stojol li Simón Pedroe ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Li chaꞌvoꞌique lic yalic eꞌuc li cꞌu sba iloꞌilajic batel ta be schiꞌuc li Jesuse, schiꞌuc ti muc bu xojtaquinique, ti jaꞌ to laj yojtaquinic li cꞌalal la xut li pane. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cꞌalal jaꞌ o te chloꞌilajic scotolique, te vaꞌal ijul ta ora ta stojolic li Jesuse. Jech laj yal: ―Junuc me avoꞌonic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ixiꞌic tajmec. Iyalic ti chꞌulelale. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Li Jesuse jech laj yalbe: ―¿Cꞌu chaꞌal chaxiꞌic? ¿Cꞌu chaꞌal chanopic ti mu joꞌcune? ");
INSERT INTO tzoSA_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Qꞌuelavilic li jcꞌob schiꞌuc li coque. Joꞌon. Laꞌ picbecun. Ti chꞌulelalucune, muꞌyuc jbecꞌtal, muꞌyuc jbaquil ti jechuque ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cꞌalal laj yal jech li Jesuse, laj yacꞌ ta ilel li scꞌobe schiꞌuc li yoque. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cꞌalal iyilique, toj echꞌem xmuybajic xa. Pero mu snaꞌic lec mi ta melel ti chaꞌcuxiem xae yuꞌun ichꞌay yoꞌonic. Ijacꞌbatic yuꞌun li Jesuse: ―¿Mi oy jsetꞌuc veꞌlil avichꞌojic talel? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Laj yacꞌbeic jsetꞌ vobil choy schiꞌuc laj yacꞌbeic jsetꞌ spom mucꞌta pom. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Scotolic te sqꞌuelojic li cꞌalal la stsac li veꞌlil li Jesuse, schiꞌuc li cꞌalal la slajese. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jech lic albaticuc: ―Cꞌalal jchiꞌucoxuc toꞌoxe, laj onoꞌox calboxuc ti persa ta xcꞌot ta pasel scotol li cꞌu sba tsꞌibabil comel jcꞌoplal ta sjun Moisés, schiꞌuc ta sjunic li yan li buchꞌutic iyalic scꞌop Dios ta voꞌonee, schiꞌuc ta sjunal Salmoetic ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Te iꞌacꞌbat spꞌijilic yuꞌun li Jesuse yoꞌ jech ta schꞌunic o ti jech onoꞌox tsꞌibabil scꞌoplal ta scꞌop li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jech laj yal nojtoc li Jesuse: ―Tsꞌibabil ta scꞌop Dios nojtoc ti ta onoꞌox xquichꞌ vocol schiꞌuc chimile, joꞌon ti scꞌoplal onoꞌox chtal ventainvancune, schiꞌuc ti ta onoꞌox xichaꞌcuxi ta yoxibal cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Schiꞌuc ti ta onoꞌox xꞌalbatic scotol crixchanoetic ti acꞌo yictaic li cꞌustic chopol ta spasique, ti acꞌo schꞌunic ti joꞌon Yajcoltavanejicune, jech ta spasbatic perton yuꞌun smulic. Jaꞌ baꞌi ta xꞌalbatic li buchꞌutic liꞌ nacalic ta Jerusalene. Tsꞌacal to chlic albaticuc scotol li crixchanoetic ta spꞌejel balumile, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Joꞌoxuc texticooxuc yuꞌun joꞌoxuc avilic ti laj quichꞌ vocole schiꞌuc ti chaꞌcuxiemun xae. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aꞌiic, chajtacbeic yalel li Chꞌul Espíritu ti yaloj onoꞌox Jtot ti chayacꞌbeique. Liꞌ to me oyanic ta Jerusalén jaꞌ to mi ital li Chꞌul Espíritue. Jaꞌ ta xꞌoch ta avoꞌonic jech ta xꞌayan o stsatsal avoꞌonic, jaꞌ xuꞌ o avuꞌunic chapuquic batel li jcꞌope ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ta yan o cꞌacꞌal laj yicꞌ loqꞌuel ta Jerusalén li yajchanbalajeltac li Jesuse. Jaꞌ te ibatic ta sbelel jteclum Betania. Cꞌalal icꞌotic ta nopol Betaniae, la stoy schibal scꞌob li Jesuse yuꞌun iyacꞌ comel slequilal yutsilal. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cꞌalal yacal ta xacꞌ comel slequilal yutsilale, jaꞌ xa o imuy ba ta vinajel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Cꞌalal iyilic ti imuy batel ta vinajele, más laj yichꞌic ta mucꞌ. Xmuybajic tajmec cꞌalal isutic batel ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Scotol cꞌacꞌal ibatic ta yamaqꞌuil li mucꞌta chꞌulna li te ta Jerusalene. Xmuybajic noꞌox laj yalbeic coliyal Dios ta sventa ti icoltaatic xae.");
INSERT INTO tzoSA_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cꞌalal muꞌyuc toꞌox vinajel balumile, te onoꞌox oy li Jesucristoe, jaꞌ li buchꞌu a yalbutic li cꞌu sba yoꞌon li Jtotic Diose. Te onoꞌox schiꞌuc sbaic schiꞌuc li Jtotic Diose. Li Jesucristoe jaꞌ Dios stuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cꞌalal muꞌyuc toꞌox li vinajel balumile, te onoꞌox schiꞌuc sbaic schiꞌuc li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Li Jesucristoe jaꞌ la spas scotol li cꞌustic oye. Mu jechuc noꞌox iꞌayan stuc li cꞌustic oye. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jaꞌ sventainoj cuxlejal sventa sbatel osil. Jech ta jnaꞌtic o ti xuꞌ chijcuxiutic o sbatel osil ta sventae jech chac cꞌu chaꞌal cuxul o li stuque. Jaꞌ sjamobil jsatic jchiquintic yoꞌ ta jtatic o jcuxlejaltic sbatel osil, joꞌotic ti oyutic ta mulil liꞌ ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaꞌ jech chac cꞌu chaꞌal xojobal cꞌocꞌ li te xojobian ta acꞌubal ti mu xtupꞌ li cꞌalal te tsanale. Jaꞌ noꞌox jech eꞌuc li Jesucristoe, acꞌo mi mu scꞌan xichꞌic ta mucꞌ li crixchanoetic li cꞌalal iꞌay liꞌ ta balumile, ta onoꞌox xal ti chijcuxiutic o sbatel osil ta sventae, joꞌotic ti jchꞌunojtic ti jaꞌ Cajcoltavanejtique. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oy toꞌox jun jchiꞌilcutic ta israelal, Juan sbi. Jaꞌ iꞌacꞌbat yabtel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tal yal ti ta xtal xa li Jesucristoe, jaꞌ li Cajcoltavanejtic ti ta xacꞌ jcuxlejaltic sventa sbatel osile, yoꞌ jech acꞌo schꞌunic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Maꞌuc jcoltavanej li Juane. Jaꞌ noꞌox ti yichꞌoj tsots yabtel sventa ta xalbe scꞌoplal li Jcoltavaneje. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cꞌalal yacal ta xalbe scꞌoplal li Jcoltavanej li Juane, jaꞌ o te iyacꞌ sba ta ilel li Jesucristoe. Jaꞌ ti ta xacꞌ jnaꞌtic ti jaꞌ noꞌox ta sventa stuc ti xuꞌ chijcuxiutic o sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Li Jesucristoe jaꞌ la spas li crixchanoetique schiꞌuc scotol li cꞌustic oye. Pero cꞌalal iꞌay liꞌ ta balumile, muc bu schꞌunic li crixchanoetic ti jaꞌ la spas scotole. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A schiꞌinuncutic, joꞌoncutic li jꞌisraeluncutique, yuꞌun voꞌone onoꞌox tꞌujbiluncutic yuꞌun li Diose. Pero ep jchiꞌiltac ti muc bu xichꞌic ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jcotolcutic li jayvoꞌ la jchꞌuncutic ti jaꞌ acꞌbil yabtel yuꞌun Dios ti jaꞌ Cajcoltavanejtique, snichꞌnaboxuc xa Dios, xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti jech snichꞌnaboxuc xa Dios xijyutcutique, yuꞌun lijchaꞌvocꞌcutic xa ta achꞌ. Pero mu jechuc jech chac cꞌu chaꞌal chijꞌvocꞌutic ta jtot ta jmeꞌtique. Ti chijꞌvocꞌutic ta achꞌe, jaꞌ ta sventa li Diose yuꞌun chisjeltabutic li coꞌontique. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Li Jesucristoe toj lec yoꞌon yuꞌun jaꞌ Snichꞌon li Jtotic Diose. Cꞌajomal jun Snichꞌon. A pasuc ta crixchano jech chac cꞌu chaꞌal li joꞌotique. La schiꞌinuncutic ta naclej, joꞌoncutic li jꞌisraeluncutique. Iquilcutic ti toj lec yoꞌone yuꞌun lec la scꞌuxubinuncutic, schiꞌuc melel scotol li cꞌustic laj yalbuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Li Juan li iyacꞌ ta ichꞌel joꞌe, jech laj yalbe scꞌoplal li Snichꞌon Dios ta stojol li jchiꞌiltacutique: ―Jaꞌ liꞌi li buchꞌu laj calboxuc ti tsꞌacal to ta xtale. Jech laj cal: “Jaꞌ tsots yabtel yichꞌoj. Li joꞌone muc bu tsots cabtel quichꞌoj. Cꞌalal muc toꞌox bu voqꞌuemune, te onoꞌox oy li stuque”, xichi onoꞌox ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Li Snichꞌon Diose toj lec yoꞌon. Joꞌotic ti quichꞌojtic xa ta muqꞌue, iquiltic xa ti oy slequil yoꞌon ta jtojoltique. Yuꞌun scotol cꞌacꞌal ta xquiltic ti chiscoltautique, ti chijyacꞌbutic slequil coꞌontique. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ta sventa li Moisese laj caꞌitic li smantaltac li Diose, pero muc bu xchꞌun cuꞌuntic. Ta sventa li Jesucristoe lec xa chijyilutic li Diose yuꞌun la schꞌaybutic o ta jꞌechꞌel li jmultique. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mu junuc buchꞌu yiloj li Diose. Li Diose cꞌajomal jun Snichꞌon, pero coꞌol yoꞌonic. Li Dios Nichꞌonile jaꞌ laj yacꞌ ta ilel ti cꞌu sba li Stote. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Cꞌalal lic yalbe scꞌoplal Jesucristo li Juan li iyacꞌ ta ichꞌel joꞌe, te icꞌotic ta stojol jayvoꞌ paleetic schiꞌuc li buchꞌutic la scoltaic ta yabtelic li paleetique. Tacbilic talel yuꞌun li jꞌabteletic cuꞌuncutic li te ta Jerusalene, joꞌoncutic li jꞌisraeluncutique. Jaꞌ tal sjacꞌbeic li Juan li iyacꞌ ta ichꞌel joꞌe: ―¿Buchꞌuot? ¿Mi joꞌot ti scꞌoplal onoꞌox chatale? ―xutic cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Itacꞌav li Juane, jamal laj yal: ―Mu joꞌcun Cristoun ti tꞌujbil yuꞌun Dios ti scꞌoplal onoꞌox chtal ventainvanuque ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","La schaꞌjacꞌbeic nojtoc: ―¿Buchꞌuot chaꞌa? ¿Mi joꞌot li Elíasote? ―xutic. Itacꞌav li Juane: ―Mu joꞌcun ―xi. La sjacꞌbeic nojtoc: ―¿Mi mu joꞌcot li buchꞌu ta jmalacutic ti chtal yal li scꞌop Diose? ―xutic. Itacꞌav li Juane: ―Mu joꞌcun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","La sjacꞌbeic nojtoc: ―Pero ¿buchꞌuot chaꞌa? Albun caꞌicutic yoꞌ jech chcꞌot calbecutic li buchꞌutic la stacuncutic talele. ¿Cꞌusi avabtel chaꞌa? Albun caꞌicutic ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Itacꞌav li Juane: ―Joꞌon jcꞌoplal li laj yal li Isaías li iyal scꞌop Dios ta voꞌonee. Jech laj yal: “Ta xlic jun jchiꞌiltic ta israelal, tsots ta xcꞌopoj ta taqui jamaltic. Jech chal: Ta xa xtal li Cajvaltique. Jaꞌ lec ictaic scotol li cꞌustic chopol chapasique, xi ta xalbe li jchiꞌiltactique”, jech onoꞌox laj yal li Isaíase ―xi itacꞌav li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Li buchꞌutic itaqueic talele jaꞌ ochemic ta fariseoal. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jech la sjacꞌbeic nojtoc li Juane: ―¿Cꞌu chaꞌal chavacꞌ ta ichꞌel joꞌ mi mu joꞌcot ti tꞌujbilot yuꞌun li Dios ti chaventainuncutique, mi mu joꞌcot li Elíasote, mi mu joꞌcot li buchꞌu ta jmalacutic ti chtal yal li scꞌop Diose? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Itacꞌav li Juane: ―Li joꞌone jaꞌ noꞌox cabtel chcacꞌbe yichꞌic joꞌ li buchꞌutic chictaic li cꞌustic chopol tspasique. Yan li buchꞌu más tsots yabtel yichꞌoje jaꞌ te achiꞌuquic pero mu to xavojtaquinic. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jaꞌ li buchꞌu tsꞌacal ta xtale. Li joꞌone muc bu tsots cabtel quichꞌoj. Mu cꞌusi xuꞌ cuꞌun ta jcolta o. Acꞌo mi slocꞌbeel xonob, mu xuꞌ chcaꞌi yuꞌun mu cꞌusi xitun o ―xi li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jaꞌ jech icꞌot ta pasel te ta jteclum Betábara li te ta jot ucꞌum Jordane, jaꞌ te li yoꞌ bu laj yacꞌ ta ichꞌel joꞌ li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta yocꞌomal laj yil Juan ti te ta xtal Jesús li yoꞌ bu oye. Li Juane jech laj yalbuncutic, joꞌoncutic li te jchiꞌucutique: ―Qꞌuelavilic, leꞌ xa xtal li buchꞌu acꞌbil tsots yabtel yuꞌun li Diose. Jaꞌ coꞌol schiꞌuc schij Dios yaꞌel yuꞌun ta xmile, jech ta xtoj o jmultic jcotoltic ta spꞌejel balumil. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Leꞌe jaꞌ li buchꞌu laj calboxuc scꞌoplale. Jech laj cal: “Jaꞌ tsꞌacal ta xtal li buchꞌu tsots yabtel yichꞌoje. Li joꞌone muc bu tsots cabtel quichꞌoj. Cꞌalal muc toꞌox bu voqꞌuemune, te xa onoꞌox oy li stuque”, xacutic onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Li joꞌone mu toꞌox xcojtaquin ti jaꞌ Cajcoltavanejtic li vinique. Jaꞌ to icojtaquin li cꞌalal laj yacꞌbun quil li Diose. Ti baꞌi tal cacꞌ ta ichꞌel joꞌ li joꞌone yoꞌ jech acꞌo xavojtaquinic eꞌuc, joꞌotic li jꞌisraelutique ―xijyutcutic li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jech laj yal nojtoc li Juan li iyacꞌ ta ichꞌel joꞌe: ―Iquil iyal talel ta vinajel li Chꞌul Espíritue coꞌol schiꞌuc jculajteꞌ yilel. Te icꞌot ta sba, jech iyichꞌ o li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Li joꞌone mu toꞌox xcojtaquin. Li Dios li laj yacꞌbun cabtel ti tal cacꞌ ta ichꞌel joꞌe, jech onoꞌox yalojbun: “Li buchꞌu chavil ti chjul li Chꞌul Espírtu ta sbae, jaꞌ li buchꞌu chayacꞌboxuc avichꞌic li Chꞌul Espíritue”, xiyut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Li joꞌone iquil xa. Laj calboxuc xa ti jaꞌ Snichꞌon li Diose ―xijyutcutic li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta yocꞌomal te jchiꞌucutic nojtoc li Juane jchaꞌvaꞌalcutic yuꞌun yajchanbalajeltacuncutic toꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Li Juane iyil ti te xbat li Jesuse, jech laj yalbuncutic: ―Qꞌuelavilic, jaꞌ li coꞌol schiꞌuc schij Dios yaꞌel leꞌe yuꞌun ta xmile ta scoj jmultic ―xijyutcutic li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cꞌalal laj caꞌicutic ti jech laj yal li Juane, jaꞌ ba jchiꞌincutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Li Jesuse la sqꞌuel svalapat, iyil ti te tijiluncutic batel ta spate. Jech la sjacꞌbuncutic: ―¿Cꞌusi chasaꞌic? ―xijyutcutic. La jtacꞌbecutic: ―Jchanubtasvanej, ¿bu nacalot? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Itacꞌav li Jesuse: ―Batic, ba qꞌuelavilic li bu nacalune ―xijyutcutic. La jchiꞌincutic batel, ba jqꞌuelcutic li bu nacale. Te jchiꞌucutic iꞌoch acꞌubal yuꞌun mal xaꞌox cꞌacꞌal lijcꞌotcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Li jchiꞌil li coꞌol laj caꞌibecutic scꞌop li Juane, ti coꞌol la jchiꞌincutic batel li Jesuse, jaꞌ Andrés sbi. Li Andrese oy sbanquil, jaꞌ Simón Pedro sbi. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Li Andrese ba scꞌopon ta ora li sbanquile, jaꞌ li Simone. Xi cꞌot yalbe: ―Ijtacutic xa li buchꞌu tꞌujbil yuꞌun Dios ti chisventainutique ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Li Andrese laj yicꞌ talel ta stojol Jesús li sbanquile. Li Jesuse la sqꞌuelbe sat li Simone, jech laj yalbe: ―Joꞌot Simonot, snichꞌonot Jonás. Cefas chacacꞌbe abi ―xut. Cefas sbi ta jcꞌopcutic, jaꞌ Pedro sbi ta griego cꞌop. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta yocꞌomal la snop Jesús ti chijbatcutic ta Galilea balumile. Cꞌalal muc toꞌox bu batemuncutique, te la sta jun jchiꞌilcutic ta israelal. Felipe sbi li vinique. Li Jesuse jech laj yalbe: ―Laꞌ chiꞌinun batel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Li Felipee jaꞌ te liquem talel ta jteclum Betsaida. Jaꞌ coꞌol slumalic schiꞌuc li Andrese schiꞌuc li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Li Felipee ba saꞌ ta ora li Natanaele. Jech cꞌot yalbe: ―Ijtacutic xa li buchꞌu tsꞌibabil comel scꞌoplal ta sjunic li jtotic jmeꞌtic Moisese schiꞌuc li yan li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Jaꞌ Jesús, snichꞌon José li te ta jteclum Nazarete ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Itacꞌav li Natanaele: ―Muc bu caꞌiojtic mi oy buchꞌu lec te chlic talel ta Nazarete ―xi. Itacꞌav li Felipee: ―Batic, ba jqꞌueltic avil ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Li Jesuse iyil ti nopol xa xtal li Natanaele, jech laj yal: ―Qꞌuelavilic, li jchiꞌiltic li leꞌ xa xtale jaꞌ lequil vinic, mu snaꞌ xloꞌlovan ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Itacꞌav li Natanaele: ―¿Cꞌuxi avojtaquinun? ―xi. Itacꞌav li Jesuse: ―Iquilot li cꞌalal te oyot ta yolon higo teꞌe li cꞌalal muc toꞌox bu batem yicꞌot talel li Felipee ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Itacꞌav li Natanaele: ―Jchanubtasvanej, joꞌot Snichꞌonot li Diose. Joꞌot chaꞌoch ta ajvalilal cuꞌuncutic, joꞌoncutic li jꞌisraeluncutique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Li Jesuse jech laj yalbe: ―Ti jech laj calbot ti iquilot li cꞌalal te oyot ta yolon higo teꞌe, jech chachꞌun o ti oy juꞌele. Lec ti chachꞌune. Ta yan cꞌacꞌal más to chavil ti scotol xuꞌ cuꞌun ta jpase ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Li Jesuse jech laj yalbuncutic jcotolcutic: ―Melel li cꞌusi chacalbeique, joꞌon li coꞌol crixchanoutique chavilic ti ta jventa joꞌon ti chabatic ta stojol li Diose ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cꞌalal yoxibal xaꞌox cꞌacꞌal jcꞌotelcutic ta Galilea balumil schiꞌuc li Jesuse, oy buchꞌu chnupun li te ta jteclum Caná li te ta Galilea balumile. Te tal sqꞌuel li qꞌuin nupunel eꞌuc li smeꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Li Jesuse schiꞌuc joꞌoncutic li yajchanbalajeltacuncutique lijꞌiqꞌuecutic ta sqꞌuelel li qꞌuin nupunel eꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cꞌalal te oyuncutic ta qꞌuine, ilaj li yuchꞌobique, jaꞌ li yaꞌlel tsꞌusube. Jech iꞌalbat Jesús yuꞌun li smeꞌe: ―Ilaj xa yuꞌunic li yuchꞌobique ―xi li smeꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Li Jesuse jech laj yalbe: ―¿Cꞌu chaꞌal jech chtal avalbun? Muc to bu cꞌotem scꞌacꞌalil chlic jpas li cabtele ―xut li smeꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Li smeꞌe jech ba yalbe li jꞌacꞌveꞌliletique: ―Li cꞌustic chayalbeic li cole chꞌunic me ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te juchajtic vacpꞌej spꞌinal yaꞌalic pasbilic ta ton, jaꞌ sventa ta spoc o scꞌobic. Yuꞌun jech jtalelcutic ti persa jal ta jpoc jcꞌobcutic, joꞌoncutic li jꞌisraeluncutique, yoꞌ jech lec chijyilcutic li Dios ti calojcutique. Li jujun pꞌinal joꞌe xꞌoch o joꞌpꞌej vacpꞌej qꞌuib joꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Li Jesuse jech laj yalbe li jꞌacꞌveꞌliletique: ―Nojesic ta joꞌ scotol li pꞌinal joꞌetique ―xut. La snojesic lec. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Li Jesuse jech laj yalbe: ―Lupic batel jsetꞌuc, ba acꞌbeic yaꞌi li buchꞌu yichꞌoj ta venta sqꞌuelel li veꞌlile ―xut. La slupic batel, ba yacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Li buchꞌu yichꞌoj ta venta sqꞌuelel scotol li veꞌlile, cꞌalal laj yaꞌi ti más to leque, mu snaꞌ bu ital yuꞌun batsꞌi joꞌ noꞌox ti ipas ta yaꞌlel tsꞌusube. Stuc noꞌox snaꞌojic li jꞌacꞌveꞌliletic ti batsꞌi joꞌ li cꞌalal la slupic batele. Li buchꞌu yichꞌoj ta venta sqꞌuelel scotol li veꞌlile, laj yicꞌ talel li jnupunel quereme. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Jech laj yalbe: ―Li joꞌotique jech jtaleltic ti jaꞌ baꞌi ta xcacꞌtic ta uchꞌel li bu más lec li yaꞌlel tsꞌusube. Cꞌalal mi ep xaꞌox laj yuchꞌique, jaꞌ to ta xcacꞌtic ta uchꞌel li bu siclamane. Li joꞌote jaꞌ la anacꞌ li bu más leque, jaꞌ to chavacꞌ ta uchꞌel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jaꞌ jech icꞌot ta pasel te ta jteclum Caná li te ta Galilea balumile. Jaꞌ sba to velta laj yacꞌ ta ilel stsatsal sjuꞌel li Jesuse. Joꞌoncutic li yajchanbalajeltacuncutique la jchꞌuncutic ti jaꞌ Snichꞌon li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsꞌacal to te iyal batel ta jteclum Capernaum li Jesuse. La jchiꞌincutic batel, joꞌoncutuc li yajchanbalajeltacuncutique, schiꞌuc li smeꞌe, schiꞌuc li yitsꞌinabe. Chib oxib noꞌox cꞌacꞌal te lijocꞌtsajcutic li ta Capernaume. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Poꞌot xaꞌox scꞌacꞌalil li qꞌuin Coltael cuꞌuncutique, joꞌoncutic li jꞌisraeluncutique. Li Jesuse ibat ta Jerusalén. La jchiꞌincutic batel, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ta yamaqꞌuil li mucꞌta chꞌulna ta Jerusalene te cꞌot jtacutic jchonvacaxetic, schiꞌuc jchonchijetic, schiꞌuc jchonjculajteꞌetic. Te chotolic nojtoc li jeltaqꞌuinetique yuꞌun jech tspasic o canal. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Li Jesuse la schapulan chꞌojon sventa stsitsob. Jaꞌ la sibtesan o loqꞌuel scotol li jchonchijetique, schiꞌuc li jchonvacaxetic li te oyic ta yamaqꞌuil li mucꞌta chꞌulnae. Li jchoncꞌusticuque sibtesbilic iloqꞌuic batel schiꞌuc li schijique schiꞌuc li svacaxique. Li Jesuse la svalcꞌunbe smexaic li jeltaqꞌuinetique, itanij yalel li staqꞌuinique. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jech laj yalbe li jchonjculajteꞌetique: ―Iqꞌuic loqꞌuel la amutique. Li sna Jtote mu me xapasic ta nail chꞌivit ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Cꞌalal jech la spas li Jesuse, joꞌoncutic li yajchanbalajeltacuncutique, ijul ta jolcutic ti jech onoꞌox tsꞌibabil ta scꞌop li Diose: “Tata, ta sventa ti ta sloqꞌuel coꞌon ta jcꞌan ti acꞌo xaꞌichꞌe ta mucꞌ li te ta chꞌulna li bu scꞌoplal onoꞌox chaꞌichꞌe ta muqꞌue, jaꞌ yuꞌun chlic quichꞌ contrainel”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Li jꞌabteletic cuꞌuncutic li te ta mucꞌta chꞌulnae, jech tal sjacꞌbeic li Jesuse: ―¿Buchꞌu laj yacꞌbot avabtel ti xuꞌ chatac loqꞌuel liꞌ ta yamaqꞌuil mucꞌta chꞌulna li jpꞌolmaletique? Acꞌbun quilcutic atsatsal ajuꞌel yoꞌ jech ta jnaꞌcutic o ti jaꞌ yacꞌojbot avabtel li Diose ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Itacꞌav li Jesuse: ―Jinesic li chꞌulna liꞌi, ta oxib cꞌacꞌal ta jchaꞌvaꞌan ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Li jꞌabteletique jech laj yalbeic li Jesuse: ―Ta vaquib yoxvinic (46) jabil ivaꞌi li chꞌulna liꞌi. ¿Cꞌu chavut ti avaloje ti ta oxib noꞌox cꞌacꞌal chachaꞌvaꞌane? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Li chꞌulna ti laj yal li Jesuse, jaꞌ laj yal ta sventa li sbecꞌtal stuque, yuꞌun cꞌalal ta xchame, ta xchaꞌcuxi ta yoxibal cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jech cꞌalal ichaꞌcuxi ta yoxibal cꞌacꞌal li Jesuse, joꞌoncutic li yajchanbalajeltacuncutique jaꞌ to te ijul ta jolcutic ti jech onoꞌox laj yalbe li jꞌabteletique. Jaꞌ to ijchꞌuncutic ti jech onoꞌox tsꞌibabil comel scꞌoplal ta scꞌop Dios ti persa ta xchame schiꞌuc ti ta xchaꞌcuxi loqꞌuel ta smuquenale. Jaꞌ to ijchꞌuncutic o ti melel li cꞌusi laj yalbe li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Te xaꞌox oy ta Jerusalén li Jesús li cꞌalal ilic li qꞌuin Coltaele. Te jchiꞌucutic, joꞌoncutic li yajchanbalajeltacuncutique. Ep jchiꞌiltacutic ta israelal la schꞌunic ti jaꞌ tꞌujbil yuꞌun Dios ti chventainvan li Jesús li cꞌalal iyilbeic stsatsal sjuꞌele. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Li Jesuse snaꞌoj ti mu scotoluc li jchiꞌiltaque ti ta sloqꞌuel yoꞌonic ta xacꞌ sbaic ta ventainele. ");
INSERT INTO tzoSA_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yuꞌun mu persauc ti oy buchꞌu ta xꞌalbun li cꞌu sba yoꞌonic li crixchanoetique. Li stuque sqꞌuelojbe onoꞌox li cꞌu sba yoꞌonic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oy toꞌox jun jchiꞌilcutic ta israelal, Nicodemo sbi. Ochem ta fariseoal. Jaꞌ jun jꞌabtel li te ta mucꞌta chꞌulna cuꞌuncutic li te ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Li Nicodemoe a scꞌopon ta acꞌubal li Jesuse. Jech laj yalbe: ―Jchanubtasvanej, jnaꞌojcutic ti jaꞌ stacojot talel li Diose ti tal achanubtasuncutique. Ti manchuc chiꞌinbilot yuꞌun li Diose, mu xuꞌ chavacꞌ ta ilel atsatsal ajuꞌel ti jechuque ―xi li Nicodemoe. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Itacꞌav li Jesuse: ―Melel li cꞌusi chacalbee, li buchꞌu muc bu chaꞌvoqꞌuem ta achꞌe, mu xuꞌ ta xꞌoch li yoꞌ bu ta spas mantal li Diose ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Li Nicodemoe jech la sjacꞌbe li Jesuse: ―¿Cꞌu sba xuꞌ ta xchaꞌvocꞌ ta achꞌ li buchꞌu mol xae? Yuꞌun mu xa xuꞌ ta xchaꞌoch ta yut schꞌut smeꞌ nojtoc yoꞌ jech xuꞌ ta xchaꞌvocꞌ ta achꞌ ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Itacꞌav li Jesuse: ―Melel li cꞌusi chacalbee, mi jaꞌ noꞌox chavichꞌic li joꞌe, ti mi muc bu jeltajem avoꞌonic yuꞌun li Chꞌul Espíritue, mu xuꞌ chaꞌochic li yoꞌ bu ta spas mantal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Cꞌalal lavoqꞌuic liꞌ ta balumile, jpasmuliloxuc jech chac cꞌu chaꞌal la atot ameꞌique. Pero mi chachaꞌvoqꞌuic ta sventa li Chꞌul Espíritue, chjeltaj la avoꞌonique, mu xa xapasic li cꞌusi chopole. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mu me toj chꞌayeluc o avoꞌon ti laj calbot ti ta persa chachaꞌvocꞌ ta achꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Buyuc noꞌox ta xbat li iqꞌue. Chavaꞌi ti xjumumet noꞌoxe pero mu xanaꞌ bu ilic talel, mu xanaꞌ bu chbat. Jaꞌ jech ta xꞌabtej ta yoꞌon crixchanoetic li Chꞌul Espíritue. Mu xanaꞌic cꞌu sba ch‐abtej jaꞌ to mi avilic ti jeltajem xa yoꞌon jun crixchanoe ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Li Nicodemoe jech la sjacꞌbe li Jesuse: ―¿Cꞌu sba ta xcꞌot ta pasel taje? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Itacꞌav li Jesuse: ―Joꞌot jchanubtasvanejot yuꞌun li jchiꞌiltactique pero mu xavaꞌibe smelol li cꞌusi chacalbee. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Melel li cꞌusi chacalbee, li joꞌone jaꞌ chcal li cꞌusi jnaꞌe schiꞌuc li cꞌusi quiloje. Li joꞌoxuque mu xavichꞌic ta mucꞌ li cꞌusi chcale. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi mu xachꞌun li cꞌusi ta spas Dios li liꞌ ta balumil jech chac cꞌu chaꞌal laj calbote, ¿mi la jaꞌ xa chachꞌun mi chacalbe li cꞌusi ta spas Dios li te ta vinajele? ");
INSERT INTO tzoSA_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mu junuc buchꞌu ayem sqꞌueloj ta vinajel li cꞌu sba li teye yoꞌ jech xuꞌ chayalbeic. Jtuc noꞌox xuꞌ chacalbeic yuꞌun te liquemun talel, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jaꞌ jech chac cꞌu chaꞌal la sjocꞌan ta teꞌ slocꞌol chon ta taqui jamaltic li jtotic jmeꞌtic Moisés ta voꞌonee, jaꞌ noꞌox jech eꞌuc chijocꞌanat ta cruz, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Scotol buchꞌu ta schꞌunic ti jaꞌ sventa chcolic o ti chijocꞌanat ta cruze, ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Li Jtotic Diose toj cꞌux ta yoꞌon scotol crixchanoetic liꞌ ta balumile jaꞌ yuꞌun listac talel, joꞌon li Snichꞌonune. Yepal o junun li Snichꞌonune. Scotol buchꞌutic ta schꞌunic ti joꞌon ta jcoltaique, jaꞌ muc bu chchꞌayic o sbatel osil. Ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Li Jtotic Diose listac yalel talel liꞌ ta balumile, pero muc bu tal cacꞌbe yichꞌic vocol li crixchanoetic ta scoj li smulique. Yuꞌun tal jcoltaic ta scoj smulic scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Li buchꞌutic ta schꞌunic ti joꞌon ta jcoltaique, jaꞌ muc bu ta xichꞌic vocol yuꞌun li smulique. Li buchꞌutic mu scꞌanic coltaele, icom xa scꞌoplal ti ta xichꞌic vocole yuꞌun mu schꞌunic ti joꞌon Yajcoltavanejicune, joꞌon li Snichꞌonun li Diose. Yepal o junun li Snichꞌonune. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Li buchꞌutic mu schꞌunique ta xichꞌic vocol yuꞌun liꞌ xa lital ta balumile, joꞌon li Snichꞌonun li Diose. Jaꞌ jech chac cꞌu chaꞌal cꞌalal mi isacub xa li osile ta xvinaj scotol mi oy cꞌusi chopol iyichꞌ pasel, jaꞌ noꞌox jech eꞌuc li cꞌalal lital liꞌ ta balumile, joꞌon li Snichꞌonun li Diose, jaꞌ ivinaj o ti oy smulic scotol li crixchanoetique. Li crixchanoetique mu scꞌan xiyichꞌic ta mucꞌ yuꞌun chopol scotol li cꞌustic ta spasique. Jaꞌ lec chaꞌiic spasel li cꞌustic chopole. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Scotol li buchꞌutic chopol li cꞌusi ta spasique mu scꞌan ti acꞌo vinajuc li smulique, jaꞌ yuꞌun mu scꞌan xiyichꞌic ta mucꞌ, joꞌon li Snichꞌonun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yan li buchꞌutic ta spasic li cꞌusi yaloj li Diose, jaꞌ chiyichꞌic ta mucꞌ, jaꞌ ta xvinaj o ti jaꞌ yichꞌojic ta mucꞌ li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tsꞌacal to ilocꞌ batel ta jteclum Jerusalén li Jesuse. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Te lijxanavcutic ta Judea balumil. Te lijocꞌtsajcutic jayib cꞌacꞌal. Te iyichꞌic joꞌ scotol li buchꞌutic coꞌol te jchiꞌucutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jech eꞌuc li Juane te chacꞌ ta ichꞌel joꞌ te ta jteclum Enón yuꞌun oy lec ucꞌum tey. Li Enone nopol xil sbaic schiꞌuc jteclum Salim. Li buchꞌutic te ibatic li yoꞌ bu oy li Juane, iꞌacꞌbatic yichꞌic joꞌ yuꞌun li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Muc toꞌox bu ochem ta chuquel li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oy jayvoꞌ li yajchanbalajeltac li Juane lic yalulanbe sbaic schiꞌuc jayvoꞌ jchiꞌilcutic ta israelal ti te coꞌol jchiꞌucutic li Jesuse, ti mu xuꞌ ti jaꞌ te chba yichꞌic joꞌ ta stojol Jesús li jchiꞌiltacutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jech ba yalbeic li Juane: ―Jchanubtasvanej, li buchꞌu te ital ta atojol li leꞌ ta jot ucꞌum Jordán li la avalbe scꞌoplale, ta xacꞌ ta ichꞌel joꞌ eꞌuc. Scotol crixchanoetic te chba schiꞌinic ―xutic li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Itacꞌav li Juane: ―Jaꞌ ta smantal stuc Dios ti cꞌusi abtelal chijyacꞌbutic li jujunutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Li joꞌoxuque avaꞌiic li cꞌalal jech laj cale: “Mu joꞌcun ti tꞌujbilun yuꞌun Dios ti chajventainique. Li joꞌone jaꞌ noꞌox laj yacꞌbun cabtel Dios ti baꞌi tal cal ti ta xa xtal li buchꞌu chisventainutique”, xcut li jchiꞌiltactique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xanaꞌic li cꞌalal ta xicꞌ yajnil jun vinique, li antse maꞌuc ta xicꞌ sba schiꞌuc li buchꞌu yutsꞌ yalal li slecom vinique. Jaꞌ ta xicꞌ sbaic schiꞌuc li slecom vinique. Li yutsꞌ yalaltac li slecom vinique naca noꞌox ta sqꞌuelic ti ta xnupunique. Cꞌalal chaꞌiic ti lec scꞌanoj sbaique, xmuybajic noꞌox. Jaꞌ noꞌox jechun eꞌuc, ximuybaj noꞌox ti jaꞌ chba schiꞌinic Jesús li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Persa ta xpuc batel scꞌoplal li Jesuse. Li joꞌone ta onoꞌox xlaj jcꞌoplal ―xi li Juan li iyacꞌ ta ichꞌel joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Li Jesuse jaꞌ tacbil yalel talel yuꞌun li Diose, jaꞌ yichꞌoj ta venta scotol. Li buchꞌu liꞌ onoꞌox oy ta balumile, jaꞌ noꞌox oy yabtel liꞌ ta balumile. Jaꞌ noꞌox ta xal li cꞌustic chil liꞌ ta balumile. Li Jesuse jaꞌ te liquem talel ta vinajel, jaꞌ scotol xuꞌ yuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jaꞌ ta xal li cꞌustic yiloj te li yoꞌ buꞌ oy li Diose schiꞌuc li cꞌustic yaꞌioje. Pero mu epuc li buchꞌutic ta xichꞌbeic ta mucꞌ li scꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yan li buchꞌutic ta schꞌunic li cꞌustic ta xal li Jesuse, jaꞌ svinajeb ti ta schꞌunic ti icꞌot xa ta pasel ti yaloj onoꞌox Dios ti ta stac talel li Snichꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Li Jesuse jaꞌ ti itaque yalel talel yuꞌun li Diose, jaꞌ ta xal scꞌop Dios yuꞌun iꞌacꞌbat ta jꞌechꞌel yuꞌun Dios li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Li Jtotic Diose toj cꞌux ta yoꞌon li Snichꞌone. Jaꞌ yacꞌojbe sventain scotol. ");
INSERT INTO tzoSA_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Scotol buchꞌutic ta schꞌunic ti chcolic ta sventa li Snichꞌon li Diose, ta xcuxiic o sbatel osil. Scotol buchꞌutic mu schꞌunique mu xcuxiic o sbatel osil. Ta xꞌacꞌbatic yichꞌic tsots vocol yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Li Jesuse laj yaꞌi ti jech iꞌalbatic li jfariseoetique: ―Jaꞌ más epic xa li buchꞌutic ta schiꞌinic li Jesuse yuꞌun ep ta xacꞌ ta ichꞌel joꞌ. Jaꞌ jutuc xa li buchꞌutic ta schiꞌinic li Juane ―xꞌutatic li jfariseoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero muc bu xacꞌ ta ichꞌel joꞌ li Jesuse. Joꞌoncutic noꞌox laj cacꞌcutic ta ichꞌel joꞌ, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Cꞌalal jech iyaꞌi li Jesuse, jech laj yalbuncutic: ―Jaꞌ lec locꞌcutic batel li liꞌ ta Judea balumile ―xijyutcutic. Lijlocꞌcutic batel li ta Judeae, te lijsutcutic batel ta cosilalcutic ta Galilea balumil. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Cꞌalal lijsutcutic batel ta Galilea schiꞌuc li Jesuse, la snop Jesús ti persa te chijelavcutic ta Samaria balumile, jaꞌ yuꞌun te lijelavcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Lijcꞌotcutic ta jun jteclum te ta Samaria, Sicar sbi. Jaꞌ te nopol xil sba schiꞌuc li yosil li ánima José ta voꞌone li iꞌacꞌbat comel yuꞌun li ánima stote, jaꞌ li Jacove. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te oy jun jocꞌbil ucꞌum, jaꞌ sjocꞌbil ucꞌum li ánima Jacov ta voꞌonee. Li Jesuse te ichoti ta nopol li jocꞌbil ucꞌume yuꞌun lubem xa ta xanbal. Poꞌot xaꞌox oꞌlol cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Te tal slup yaꞌal jun jsamariail ants. Li Jesuse jech laj yalbe: ―Acꞌbun jsetꞌuc avaꞌal chcuchꞌ ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Joꞌoncutic li yajchanbalajeltacuncutique batemuncutic xaꞌox ta yut jteclum yuꞌun ba jmancutic talel jveꞌelcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Li jsamariail antse jech itacꞌav: ―¿Cꞌu chaꞌal chacꞌanbun joꞌ avuchꞌ yuꞌun jꞌisraelal vinicot? Li joꞌone jsamariail antsun ―xut. Ti jech laj yal li antse, yuꞌun mu xil sbaic ta lec li jsamariaetic schiꞌuc li jchiꞌiltac ta israelale. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Itacꞌav li Jesuse: ―Ti xanaꞌuc li cꞌusi ta scꞌan chayacꞌbe li Diose schiꞌuc ti avojtaquinucun onoꞌox li cꞌalal la jcꞌanbot avaꞌal cuchꞌe, joꞌot baꞌi la acꞌanbun joꞌ ti jechuque. Ti acꞌanbucune, laj cacꞌbot li joꞌ ta sventa ti chacuxi o sbatel osile ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Li antse jech laj yal: ―Tata, mu cꞌusi xalup o li joꞌe yuꞌun toj nat li jocꞌbil ucꞌume. ¿Bu chata li joꞌ ti chavacꞌbun cuchꞌ yoꞌ chicuxi o sbatel osil chavale? ");
INSERT INTO tzoSA_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Li jtotic jmeꞌtic Jacov ta voꞌonee jaꞌ laj yacꞌbuncutic li jocꞌbil ucꞌum liꞌi. Li joꞌ liꞌi jaꞌ laj yuchꞌic schiꞌuc snichꞌnabtac, schiꞌuc svacaxic, schiꞌuc schijic. ¿Mi joꞌot más tsots avabtel avichꞌoj? ―xi li antse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Itacꞌav li Jesuse: ―Scotol buchꞌutic ta xuchꞌic li joꞌ liꞌi ta to xtaquij yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero li buchꞌutic ta xuchꞌic li joꞌ ti chcaqꞌue jaꞌ mu xa xtaquij o yoꞌonic. Li joꞌ ti chcaqꞌue jaꞌ jech chac cꞌu chaꞌal nioꞌ ti mu xꞌule, ti te xnixnun o ta yoꞌonique jech ta xcuxiic o sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Li antse jech laj yal: ―Tata, acꞌbun cuchꞌ li joꞌ chavale yoꞌ jech mu xa xtaquij o coꞌon, jech mu xa xtal jlup o caꞌal liꞌi ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Itacꞌav li Jesuse: ―Batan, ba icꞌo talel amalal ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Itacꞌav li antse: ―Muꞌyuc jmalal ―xi. Itacꞌav li Jesuse: ―Melel ti muꞌyuc amalale. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yuꞌun yoꞌvaꞌal xa amalal la avicta. Yan li buchꞌu avicꞌoj aba achiꞌuc li avie maꞌuc amalal, aloꞌlobil vinic noꞌox. Melel li cꞌusi la avale ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Li antse jech laj yal: ―Tata, jaꞌ avabtel chaval scꞌop Dios chcaꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Li jtotic jmeꞌtic ta voꞌonee laj yichꞌic ta mucꞌ Dios li liꞌ ta jol vitse. Joꞌoxuc li jꞌisraeloxuque chavalic ti persa te chba quichꞌcutic ta mucꞌ Dios li ta jteclum Jerusalene ―xi li antse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Li Jesuse jech laj yalbe li antse: ―Chꞌuno li cꞌusi chacalbee. Ta xcꞌot scꞌacꞌalil ti chlaj scꞌoplal ti chavichꞌic ta mucꞌ li Jtotic Dios li liꞌ ta vitse schiꞌuc li te ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Joꞌoxuc li liꞌ nacaloxuc ta Samariae, mu cꞌusi xtun o avuꞌunic li cꞌustic la stsꞌibaic comel li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Jech mu xanaꞌic ti jech onoꞌox yaloj Dios ti jaꞌ jun jchiꞌilcutic ta israelal li buchꞌu ta scoltaan ta scoj smulic scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Poꞌot xa ta xcꞌot scꞌacꞌalil ti buyuc noꞌox xuꞌ chichꞌic ta mucꞌ Dios li buchꞌutic ti ta melel yichꞌojic ta muqꞌue. Yuꞌun li Jtotic Diose ta saꞌ li buchꞌutic ti jech ta xꞌichꞌe ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Muꞌyuc sbecꞌtal stacupal li Jtotic Diose, te onoꞌox oy ta spꞌejel balumil. Jaꞌ jech li buchꞌutic ti ta sloqꞌuel yoꞌonic yichꞌojic ta muqꞌue, buyuc noꞌox xuꞌ chichꞌic ta mucꞌ, mi ta snaic, mi ta be, mi ta yabtelic. Jaꞌ jech scꞌan ti chquichꞌtic ta mucꞌ li Diose ―xꞌutat li ants yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Li antse jech laj yal: ―Caꞌioj onoꞌox ti chtal li buchꞌu tꞌujbil yuꞌun Dios ti chisventainutique. Cꞌalal ta xtale, jamal chijyalbutic scotol li cꞌusi ta scꞌan li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Itacꞌav li Jesuse: ―Joꞌon li liꞌ chajcꞌopone ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Cꞌalal yaquic ta loꞌil schiꞌuc li ants li Jesuse, jaꞌ o lijulcutic talel, joꞌoncutic li yajchanbalajeltacuncutique. Toj chꞌayel noꞌox coꞌoncutic cꞌalal iquilcutic ti chloꞌilaj schiꞌuc jun jsamariail ants li Jesuse. Pero muc buchꞌu la sjacꞌ junucal cuꞌuncutic ti cꞌusi tsjacꞌbe li antse schiꞌuc ti cꞌu chaꞌal chloꞌilaj schiꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Li antse te laj yicta ta jocꞌbil ucꞌum li sqꞌuibe. Isut batel ta yut jteclum. Jech cꞌot yalbe li crixchanoetique: ");
INSERT INTO tzoSA_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Batic, ba jqꞌueltic avilic jun vinic te ta jocꞌbil ucꞌum ti laj yalbun scotol li cꞌustic jpasanoje. Jaꞌ xa nan li buchꞌu tꞌujbil yuꞌun Dios li scꞌoplal onoꞌox chtal sventainutique ―xi li antse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iloqꞌuic talel ta ora li crixchanoetic li te ta jteclume, tal sqꞌuelic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cꞌalal ibat xaꞌox li antse, joꞌoncutic li yajchanbalajeltacuncutique jech laj calbecutic li Jesuse: ―Jchanubtasvanej, veꞌan ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Itacꞌav li Jesuse: ―Oy jveꞌel, pero mu xanaꞌic cꞌusi ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Li joꞌoncutique jech laj calbe jbacutic: ―¿Mi yuꞌun nan oy buchꞌu a acꞌbatuc sveꞌel? ―xcut jbacutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Li Jesuse jech laj yalbuncutic: ―Jaꞌ jveꞌel ti ta jpasbe li cꞌusi ta scꞌan li Diose, jaꞌ ti listac talele. Jaꞌ ta jneles li cabtel ti yacꞌojbune. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jech chavalic: “Cꞌalal to chanib u tsta yora ta tuchꞌel li trigoe”, xachiic. Aꞌiic me li cꞌusi chacalbeique. Qꞌuelavilic li crixchanoetic li leꞌ xa xtalique. Jaꞌ jechic jech chac cꞌu chaꞌal li trigo li cꞌalal taquin xae, jaꞌ xa yora ta tuchꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Li buchꞌutic ta stsꞌunic trigoe ta xichꞌ stojolic. Jech eꞌuc li buchꞌutic ta stuchꞌique ta xichꞌ stojolic. Jaꞌ noꞌox jech eꞌuc li buchꞌutic ta spuquic batel li jcꞌope ta xichꞌ stojolic. Li buchꞌutic baꞌi ta xalbeic jcꞌop li crixchanoetic ti mu schꞌunique, ta onoꞌox xichꞌ stojolic. Li buchꞌutic tsꞌacal to ta xalbeic li jcꞌop ti jaꞌ to ta schꞌunic li crixchanoetique, ta xichꞌ stojolic eꞌuc. Coꞌol xmuybajic schiꞌuc li buchꞌutic baꞌi laj yalic li jcꞌope, yuꞌun li jayvoꞌ ta schꞌunique ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jech ta xcꞌot ta pasel jech chac cꞌu chaꞌal ta xalique: “Yan o buchꞌu ta stsꞌun, yan o buchꞌu ta stuchꞌ”, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Li antse joꞌon laj calbe jtuc. Li crixchanoetique jaꞌ xa iꞌalbatic yuꞌun li antse. Joꞌoxuc xa ta abaic ti chachanubtasic leque yoꞌ jech acꞌo schꞌunic ti joꞌon ta jcoltaique ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ep jsamariail crixchanoetic li te nacalic ta jteclume la schꞌunic ti jaꞌ tꞌujbil yuꞌun Dios li Jesús ti chventainvan li cꞌalal jech laj yal li antse: “Laj yalbun scotol li cꞌustic jpasanoje”, xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jech li crixchanoetique tal sqꞌuelic li Jesuse, yuꞌun tal scꞌanbeic vocol ti acꞌo jocꞌtsajuque. Te lijocꞌtsajcutic chib cꞌacꞌal schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cꞌalal iyaꞌiic li cꞌu sba ichanubtasvan li Jesuse, ep buchꞌutic la schꞌunic ti ta melel jaꞌ li Cristo ti tꞌujbil yuꞌun Dios ti chventainvane. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jech laj yalbeic li antse: ―Maꞌuc noꞌox ta sventa ti cꞌu sba la avalbuncutic ti la jchꞌuncutique. Icaꞌicutic jtucutic li cꞌu sba ta xchanubtasvane. Jech ta jnaꞌcutic o ti jaꞌ tꞌujbil yuꞌun Dios ti chiscoltautic yuꞌun jmultic jcotoltic ta spꞌejel li balumile ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cꞌalal iꞌechꞌ li chib cꞌacꞌale, ilocꞌ batel ta Samaria balumil li Jesuse, te ibat ta cosilalcutic ta Galilea balumil. Te jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ti isut batel ta cosilalcutic li Jesuse, yuꞌun jaꞌ muc buchꞌu ta xcontrainat tey. Yuꞌun muc buchꞌu ta xꞌichꞌbat ta mucꞌ li scꞌope. Jech chac cꞌu chaꞌal yaloj onoꞌox li Jesuse: “Li buchꞌu ta xal li scꞌop Diose jaꞌ mu xꞌaqꞌue ta venta li yoꞌ bu ichꞌie”, xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cꞌalal icꞌot ta Galilea balumil li Jesuse, xmuybajic xa li jchiꞌiltacutic ta israelal teye, yuꞌun yilojic xa onoꞌox li cꞌustic la spas Jesús li cꞌalal iꞌayic ta qꞌuin Coltael li te ta Jerusalene. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Li Jesuse te ichaꞌcꞌot nojtoc li ta jteclum Caná li te ta Galilea balumile, jaꞌ te li yoꞌ bu la scꞌatajes ta yaꞌlel tsꞌusub li joꞌe. Te oy ta jteclum Capernaum jun yajꞌabtel li ajvalile. Jaꞌ jchiꞌilcutic ta israelal. Ip snichꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Li yajꞌabtel li ajvalile iyaꞌi ti icꞌot xa Jesús li te ta Galilea balumile. Tal scꞌanbe vocol li Jesuse ti acꞌo ba coltabatuc li snichꞌone yuꞌun ta xa xcham. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Li Jesuse jech laj yalbe: ―Li joꞌoxuque jaꞌ to chachꞌunic ti joꞌon Jcoltavanejun ti cꞌalal mi la avilic ti ta xcacꞌ ta ilel jtsatsal juꞌele ―xut li jayvoꞌ li te nopol vaꞌalique. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Li yajꞌabtel li ajvalile jech laj yalbe li Jesuse: ―Tata, batic ta ora yoꞌ to cuxul to li jnichꞌone ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Li Jesuse jech iyal: ―Batan. Icol xa la anichꞌone ―xut. Li vinique ischꞌun li cꞌusi iꞌalbat yuꞌun li Jesuse, isut batel ta sna. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cꞌalal cꞌotebal xaꞌox ta snae, tal nupeuc ta be yuꞌun li yajtuneltaque. Jech iꞌalbat: ―Icol xa la anichꞌone ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jech isjacꞌ li vinique: ―¿Cꞌu ora icol? ―xi. Itacꞌav li yajtuneltaque: ―Volje ta jun ora stsꞌepꞌujel cꞌacꞌal itupꞌ li scꞌacꞌale ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Li vinique ijul ta sjol ti jech onoꞌox ora iꞌalbat yuꞌun li Jesuse ti icol xa li snichꞌone. Jaꞌ te ischꞌunic o ti jaꞌ Yajcoltavanejic li Jesuse schiꞌuc scotolic li te ta snailique. ");
INSERT INTO tzoSA_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ti cꞌalal ijul xa talel ta judeajel icꞌot ta Galilea balumil li Jesuse, jaꞌ o laj yacꞌ ta ilel schibal velta li stsatsal sjuꞌele, jaꞌ ti la scoltabe snichꞌon li yajꞌabtel li ajvalile. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tsꞌacal to icꞌot scꞌacꞌalil jun qꞌuin cuꞌuncutic, joꞌoncutic li jꞌisraeluncutique. Jaꞌ yuꞌun ibat ta Jerusalén li Jesuse. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Li ta Jerusalene oy jun stiꞌ smacol, jaꞌ li bu ta xꞌoch li chijetic sventa ta xtun li ta mucꞌta chꞌulnae. Li ta nopol tiꞌ moque oy jun stanqueal joꞌ Betesda sbi ta jcꞌopcutic. Schiꞌuc oy joꞌpꞌej cotcot na ta stiꞌ li stanqueal joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jaꞌ te puchꞌajtic ep jchamelajeletic. Oy maꞌsatetic schiꞌuc coxoetic. Oy buchꞌutic muꞌyuc yipal jun yoc scꞌobic. Jaꞌ te tsmalaic mi chlic yuqꞌuilajuc li joꞌe. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Li jchiꞌiltaque jech schꞌunojic ti baqꞌuintic ta xyal talel ta stanqueal joꞌ jun yajꞌangel Dios yoꞌ ta syuqꞌuilan li joꞌe. Schꞌunojic nojtoc ti cꞌalal chlic yuqꞌuilajuc li joꞌe, cꞌusiuc noꞌox chamelal ip chaꞌi li buchꞌu baꞌi ta sjip sba ochel li ta joꞌe, jaꞌ ta xcol o. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te oy jun jchiꞌilcutic ta israelal ti vaxaclajuneb schaꞌvinic (38) xa jabil tsacbil ta chamele. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Li Jesuse, cꞌalal iyil ti te puchꞌule, snaꞌoj ti oy xa sjabilal ti ip li vinique. Jech la sjacꞌbe: ―¿Mi chacꞌan chacol? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Itacꞌav li jchamelajele: ―Tata, muc buchꞌu oy cuꞌun ti xuꞌ chisticꞌ ochel li cꞌalal ta xyuqꞌuilaj li joꞌe. Cꞌalal chibate, oy xaꞌox buchꞌu baꞌi ochem ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Li Jesuse jech laj yalbe: ―Totsan, balo apop, xanavan ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Icol ta ora li vinique. La sbal li spope, ixanav batel. Cꞌalal icoltaat li jchiꞌilcutique, jaꞌ o scꞌacꞌalil ta jcuxcutic, joꞌoncutic li jꞌisraeluncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Li jꞌabteletic cuꞌuncutique jech laj yalbeic li vinic ti colem xae: ―Li avie jaꞌ scꞌacꞌalil ta jcuxtic. Mi chavichꞌ batel la apope, chapꞌajbe smantal li Diose ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Itacꞌav li vinique: ―Li buchꞌu liscoltae jech laj yalbun: “Balo apop, xanavan”, xiyut ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jech la sjacꞌbeic li vinique: ―¿Buchꞌu ti jech laj yalbote: “Balo apop, xanavan”, ti xayute? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Li vinic ti colem xae mu snaꞌ buchꞌu icoltaun yuꞌun la svocꞌ sba loqꞌuel ta ora li Jesuse, jech muc xa bu xil. Yuꞌun toj ep crixchanoetic te stsoboj sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tsꞌacal to te itae yuꞌun Jesús ta yamaqꞌuil li mucꞌta chꞌulna li vinic ti la scoltae. Jech iꞌalbat yuꞌun li Jesuse: ―Qꞌuelavil, colemot xa. Pero ictao me scotol li cꞌusi chopol chapase naca me más to ep chavichꞌ vocol ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Li vinique ba yalbe li jꞌabteletic cuꞌuncutique ti jaꞌ icoltaat yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ta scoj ti la scolta jun vinic li Jesús li ta scꞌacꞌalil ta jcuxcutique, lic contrainatuc yuꞌun li jꞌabteletic cuꞌuncutique. Chac smilic o. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Li Jesuse jech laj yalbe li jꞌabteletique: ―Scotol cꞌacꞌal ta xꞌabtej li Jtote. Jaꞌ noꞌox jechun eꞌuc xuꞌ chiꞌabtej ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cꞌalal laj yal jech li Jesuse, li jꞌabteletic cuꞌuncutique más to isoc sjolic, chac smilic tajmec li Jesuse. Pero maꞌuc noꞌox ta sventa ti mu schabi li scꞌacꞌalil ta jcuxcutique. Jaꞌ ta sventa nojtoc ti la scoꞌoltajes sba jech chac cꞌu chaꞌal li Diose, yuꞌun laj yal ti jaꞌ Stot li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Li Jesuse jech laj yalbe: ―Melel li cꞌusi chacalbeique, joꞌon Snichꞌonun li Diose mu cꞌusi xuꞌ ta jpas jtuc. Li cꞌu sba ta spas li Jtote jaꞌ noꞌox jech ta jpas eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Li joꞌone toj cꞌuxun ta yoꞌon li Jtote. Scotol chiyacꞌbe quil li cꞌustic ta spase. Li avie jutuc noꞌox chavilic, pero ep to chiyacꞌbe jpas li Jtote. Cꞌalal mi la jpase, más to ta xchꞌay o avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jaꞌ jech chac cꞌu chaꞌal ta schaꞌcuxes ánimaetic li Jtote, jaꞌ noꞌox jechun eꞌuc, xuꞌ ta jchaꞌcuxes li buchꞌutic ta jcꞌan ta jchaꞌcuxesique. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Li Jtote muc bu ta xichꞌbe scꞌopic li crixchanoetique. Joꞌon li Snichꞌonune yalojbun ti ta xquichꞌbe scꞌopique, yoꞌ jech acꞌo yichꞌicun ta mucꞌ scotol crixchanoetic jech chac cꞌu chaꞌal ta xꞌichꞌe ta mucꞌ li Jtote. Li buchꞌutic mu xiyichꞌic ta muqꞌue, mu xichꞌic ta mucꞌ eꞌuc li Jtot yaꞌele, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Melel li cꞌusi chacalbeique, li buchꞌutic ta xaꞌibecun li jcꞌope, mi ta schꞌunic ti jaꞌ ta xcoltaatic yuꞌun li buchꞌu listac talele, ta xcuxiic o sbatel osil. Muc bu ta xichꞌic vocol yuꞌun iloqꞌuic xa li bu sventa ta xchꞌayic o sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Melel li cꞌusi chacalbeique, joꞌoxuc li chamemoxuc chaquilique, ista xa scꞌacꞌalil chavaꞌibecun li jcꞌope, joꞌon li Snichꞌonun li Diose. Li buchꞌutic ta schꞌunic ti joꞌon Yajcoltavanejicune ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jech chac cꞌu chaꞌal sventainoj cuxlejal sventa sbatel osil li Jtote, jaꞌ noꞌox jechun eꞌuc li joꞌone, yacꞌojbun jventain li cuxlejal sventa sbatel osil li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yacꞌojbun cabtel sventa ta xquichꞌbe scꞌopic scotol li crixchanoetique yuꞌun li joꞌone coꞌol crixchanoutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mu me toj chꞌayeluc o avoꞌonic ta sventa ti jech laj calboxuque. Yuꞌun ta me xcꞌot scꞌacꞌalil ta xaꞌiic jcꞌopojel scotol li ánimaetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jech ta xchaꞌcuxiic loqꞌuel ta smuquenalic. Li buchꞌutic ti lec li cꞌustic la spasique ta xcuxiic o sbatel osil. Yan li buchꞌutic ti chopol li cꞌustic la spasique ta xꞌacꞌbat yichꞌic vocol sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Li joꞌone mu cꞌusi xuꞌ ta jpas jtuc. Maꞌuc ta jpas li cꞌusi ta jnop jtuque. Li cꞌu sba laj yalbun li Jtote, jaꞌ noꞌox jech ta xquichꞌbe scꞌopic scotol li crixchanoetique. Tucꞌ ta xquichꞌbe scꞌopic yuꞌun jaꞌ ta jpas li cꞌusi ta scꞌan li Jtote, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ti jtucuc noꞌox ta xcal li jcꞌoplale, li joꞌoxuque xuꞌ chanopic ti muꞌyuc sbalil li cꞌusi chacalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Li joꞌone oy cajtextico, jaꞌ li buchꞌu chal jcꞌoplale. Jaꞌ melel li jcꞌoplal li ta xale. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Li joꞌoxuque la ataquic ta jaqꞌuel ta stojol Juan li iyacꞌ ta ichꞌel joꞌe. Li cꞌu sba laj yal jcꞌoplal li Juane, jaꞌ melel. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero maꞌuc to persa ti jech laj yal jcꞌoplale. Jaꞌ noꞌox ta julesboxuc ta ajolic yoꞌ acꞌo xachꞌunic o, jech chacolic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Li Juane coꞌol schiꞌuc xojobal cꞌocꞌ yaꞌel ti ta xacꞌ ta ilel li bee, yuꞌun jaꞌ laj yalboxuc li cꞌusi lec ta pasele. Li cꞌusi laj yalboxuque jliquel noꞌox xamuybajic o. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ta sventa li Juane jaꞌ noꞌox la avaꞌibecun jcꞌoplal. Li ta cabtel ti chacꞌ jpas li Jtote, jech ta xvinaj o ti tacbilun talel yuꞌun li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Li Jtote, jaꞌ ti listac talele, jaꞌ cajtextico nojtoc yuꞌun laj xa yal jcꞌoplal eꞌuc. Muc bu avaꞌiojic jutuc li cꞌu sba li scꞌopojele, muc bu avilojic cꞌu sba li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Schiꞌuc muꞌyuc ta avoꞌonic li scꞌope yuꞌun mu xachꞌunic ti joꞌon Avajcoltavanejicun li tacbilun talel yuꞌun li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Chaqꞌuelic li scꞌop Diose, chanopic ti jech chacuxiic o sbatel osile. Pero mu jechuc ta xal li scꞌop Diose. Jaꞌ te tsꞌibabil jcꞌoplal ti ta jventa joꞌon chacuxiic o sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero mu xacꞌan xavichꞌicun ta mucꞌ yoꞌ jech chacuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ti litale, yoꞌ acꞌo xavichꞌicun ta mucꞌ jech chacuxiic o sbatel osil; maꞌuc noꞌox ti lec xa aveic ta jtojole. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero jqꞌueloj li cꞌu sba avoꞌonique. Jnaꞌoj ti muꞌyuc onoꞌox ta avoꞌonic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Li joꞌone jaꞌ listac talel li Jtote pero mu xavichꞌicun ta mucꞌ. Yan li buchꞌu jech noꞌox ta xtal stuque jaꞌ chavichꞌic ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mu xuꞌ chachꞌunic yuꞌun jaꞌ noꞌox chacꞌanic ti lec xa yeic ta atojolic la achiꞌiltaquique. Maꞌuc chacꞌanic ti lec chayilic li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mu me xanopic ti joꞌon chajticꞌbeic amulic ta stojol li Jtote. Ta sventa ti jaꞌ ta sloqꞌuel avoꞌonic chachꞌunic scotol li smantaltac Dios ti avalojic ti laj yal Moisés ta voꞌonee, jaꞌ amulic o, yuꞌun mu xchꞌun avuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ti achꞌunojicuc li cꞌusi la stsꞌiba li Moisés ta voꞌonee, jech chachꞌunic eꞌuc ti joꞌon Avajcoltavanejicun ti jechuque. Yuꞌun jaꞌ jcꞌoplal li la stsꞌiba comel li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mi mu xachꞌunic li cꞌusi tsꞌibabil comel yuꞌun li Moisese, ¿mi la jaꞌ xa chachꞌunic nojtoc li cꞌusi chacalbeique? ―xꞌutatic yuꞌun Jesús li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ta tsꞌacal ibat ta jot nab li Jesuse. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Galilea sbi li nabe, Tiberias sbi nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ep crixchanoetic jchiꞌucutic batel schiꞌuc li Jesuse yuꞌun iyilic ti ep iyacꞌ ta ilel stsatsal sjuꞌele, jaꞌ ti la scoltaan jchamelajeletique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Li Jesuse laj yicꞌuncutic muyel ta jun biqꞌuit vits. Te ichoti. Lijchoticutic eꞌuc, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Poꞌot xaꞌox li qꞌuin Coltael cuꞌuncutic, joꞌoncutic li jꞌisraeluncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cꞌalal iyil Jesús ti te chtal ta stojol epal crixchanoetique, jech ijacꞌbat Felipe yuꞌun li Jesuse: ―¿Bu chba jmantic talel pan sventa chcacꞌbetic sveꞌic li epal crixchanoetic ti liꞌ xa oyique? ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Li Jesuse snaꞌoj onoꞌox li cꞌu sba tspase, pero jech la sjacꞌbe yuꞌun tsqꞌuel cꞌu sba ta xtacꞌav li Felipee. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Itacꞌav li Felipee: ―Ti oyuc lajunvinic (200) denario taqꞌuin sventa ta jmantic o li pane, acꞌo mi jutuc noꞌox chcacꞌbetic, pero mu xloqꞌuic o ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Li Jesuse jech iꞌalbat yuꞌun jun jchiꞌilcutic ta yajchanbalajeltac li Jesuse, jaꞌ li Andrese, jaꞌ yitsꞌin li Simón Pedroe: ");
INSERT INTO tzoSA_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Oy jun querem liꞌi yichꞌoj talel joꞌpꞌej pan. Yichꞌoj talel chaꞌcot choy nojtoc. Pero mu xloqꞌuic o, yuꞌun toj epic li crixchanoetique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Li Jesuse jech laj yalbuncutic: ―Albeic li crixchanoetique acꞌo chotlicuc ―xijyutcutic. Yuꞌun naca yaxaltic noꞌox te ichotiic. Oy nan joꞌmiluc li viniquetique. Yan li antsetique schiꞌuc li unetique muc bu xichꞌic atel. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Li Jesuse la stsac li pane, laj yalbe coliyal Dios. La xutilan, laj yacꞌbuncutic, joꞌoncutic li yajchanbalajeltacuncutique. Joꞌoncutic la jpucbecutic li buchꞌutic te chotolique. Jech nojtoc la jpucbecutic ba li choye ti cꞌu yepal la scꞌanic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cꞌalal inojic scotolique, li Jesuse jech laj yalbuncutic, joꞌoncutic li yajchanbalajeltacuncutique: ―Tsobbeic scotol li scomenal li pane schiꞌuc li scomenal li choye. Mu me xquictatic ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","La jtsobcutic scotol. Inoj lajchamoch li scomenal li joꞌpꞌej pane. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Li crixchanoetique, cꞌalal iyilic ti la spꞌoles pan li Jesuse, jech laj yalbe sbaic: ―Melel li vinic liꞌi jaꞌ xa li buchꞌu ta xal scꞌop Dios ti scꞌoplal chtal sventainutique ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Li Jesuse snaꞌanojbe yoꞌonic li jchiꞌiltaque ti chiqꞌuic batel ta persa yoꞌ ta stiqꞌuic ta ajvalilal cuꞌuncutic, joꞌoncutic li jꞌisraeluncutique. Jaꞌ yuꞌun la svocꞌ sba batel ta vits li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Xtupꞌet xaꞌox osil li cꞌalal lijyalcutic batel ta tiꞌ nab, joꞌoncutic li yajchanbalajeltacuncutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Te lijꞌochcutic ta canava yuꞌun chijbatcutic ta jteclum Capernaum li te ta jot nabe. Jliquel xaꞌox acꞌubal te yacuncutic ta xanbal ta ba nab. Muc toꞌox bu staojuncutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Toj tsots ital icꞌ. Lic syuqꞌuilan sba li nabe. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cꞌalal oy xaꞌox nan oꞌloluc schibal reva lijxanavcutic batel ta ba nabe, iquilcutic te yac talel ta xanbal ta yoc ta ba nab li Jesuse. Inopoj talel li ta jcanavacutique. Lijxiꞌcutic tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Li Jesuse jech laj yalbuncutic: ―Mu me xaxiꞌic, joꞌon me ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Xijmuybajcutic xa laj quicꞌcutic ochel ta canava li Jesuse. Lijcꞌotcutic ta ora ta jot nab li bu jnopojcutic onoꞌox ti chijbatcutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Li crixchanoetic li te icomic ta jot nabe iyilic ti muꞌyuc yan canavae, jaꞌ noꞌox jun li bu lijꞌochcutic o batele. Iyilic nojtoc ti muc bu xꞌoch ta canava li Jesuse, jaꞌ noꞌox jtuccutic lijꞌochcutic, joꞌoncutic li yajchanbalajeltacuncutique. Ta yocꞌomal italic yan canavaetic li te liquemic talel ta jteclum Tiberiase. Jaꞌ te nopol iꞌechꞌic li yoꞌ bu la sveꞌic pan li crixchanoetique li cꞌalal laj yalbe coliyal Dios li Cajvaltic Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iyilic li crixchanoetique ti muc xa bu te li Jesuse, schiꞌuc muc xa bu te oyuncutic eꞌuc, joꞌoncutic li yajchanbalajeltacuncutique, jaꞌ yuꞌun te iꞌochic ta canava eꞌuc. Te italic ta Capernaum, jaꞌ tal saꞌic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cꞌalal te la staic ta jot nab li Jesuse, jech la sjacꞌbeic: ―Jchanubtasvanej, ¿cꞌu ora lajul liꞌi? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Itacꞌav li Jesuse: ―Melel li cꞌusi chacalbeique, ti tal asaꞌicune, maꞌuc sventa ti laj cacꞌ ta ilel li jtsatsal juꞌele. Jaꞌ noꞌox tal asaꞌicun o ti lec lanojic ta pane. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mu me jaꞌuc noꞌox batem ta avoꞌonic ta saꞌel la aveꞌelic ti xlaj noꞌoxe. Jaꞌ scꞌan ti chasaꞌic la aveꞌelic li muꞌyuc slajeb ti chacuxiic o sbatel osile. La aveꞌelic ti chacalbeique, joꞌon chacacꞌbeic, joꞌon li coꞌol crixchanoutique, yuꞌun jaꞌ jech acꞌbil cabtel yuꞌun li Diose, jaꞌ li Jtote ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Li jchiꞌiltaque jech la sjacꞌbeic li Jesuse: ―¿Cꞌu chcutcutic ta jpasbecutic li cꞌusi ta scꞌan li Diose? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Itacꞌav li Jesuse: ―Li cꞌusi ta scꞌan Dios ti chapasique, jaꞌ ti acꞌo xachꞌunic ti joꞌon Avajcoltavanejicune, joꞌon ti liꞌ tacbilun talel yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jech la sjaqꞌuic nojtoc li jchiꞌiltaque: ―¿Cꞌusi senyail chavacꞌbun quilcutic o ti tacbilot talel yuꞌun li Diose yoꞌ jech ta jchꞌuncutic o li cꞌusi chavale? ¿Cꞌusi abtelal chavacꞌbun quilcutic o? ");
INSERT INTO tzoSA_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Li jtotic jmeꞌtic ta voꞌonee la sveꞌic li manavaj li te ta taqui jamaltique. Jech tsꞌibabil ta scꞌop Dios: “Li Moisese laj yacꞌ ta veꞌel vaj li talem ta vinajele”, xi tsꞌibabil. Acꞌbuncutic jech eꞌuc ―xiic li jchiꞌiltaque. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Li Jesuse jech laj yalbe: ―Melel li cꞌusi chacalbeique, maꞌuc Moisés ti laj yacꞌ li vaj ti la sveꞌic li jtotic jmeꞌtic ta voꞌonee. Dios laj yacꞌ talel li vaje. Li vaj ti la sveꞌic li jtotic jmeꞌtique jaꞌ noꞌox sventa icuxiic o li liꞌ ta balumile. Yan li avie li vaj ti chayacꞌbeic li Jtote, jaꞌ sventa chacuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Li vaj ti chayacꞌbeic li Diose, liquem talel ta vinajel. Jaꞌ sventa chacuxiic o sbatel osil, joꞌoxuc ti liꞌ oyoxuc ta balumile ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Laj yalic li jchiꞌiltaque: ―Cajval, acꞌbuncutic scotol cꞌacꞌal li vaj chavale ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Itacꞌav li Jesuse: ―Li liꞌ ta balumile ta vaj cuxuloxuc. Jaꞌ noꞌox jech nojtoc ta jventa joꞌon xuꞌ chacuxiic o sbatel osil yuꞌun joꞌon vajun yaꞌel. Li buchꞌutic chiyichꞌic ta muqꞌue, mi ta schꞌunic ti joꞌon ta jcoltaique, mu xa cꞌusi yan ta scꞌanic, xmuybajic noꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero li joꞌoxuque mu xacꞌan xachꞌunic ti joꞌon chajcoltaique, jaꞌ yuꞌun laj calboxuc ti muꞌyuc jbalil chavilicune. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Scotol buchꞌutic ti tꞌujbilic onoꞌox yuꞌun Jtot ti chiyichꞌic ta muqꞌue, jaꞌ chiyichꞌic ta mucꞌ. Ximuybaj noꞌox ta xquicꞌan. Mu xcacꞌ xchꞌayic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ti liyal talel liꞌ ta balumile, maꞌuc tal jpas li cꞌusi ta jcꞌan jtuque. Jaꞌ tal jpas li cꞌusi ta scꞌan li Jtot ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Li Jtote jaꞌ tscꞌan ti mu xchꞌay junuc cuꞌun li cꞌu yepal tꞌujbilic onoꞌox yuꞌun ti acꞌo xiyichꞌic ta muqꞌue. Mi ichamique, ta jchaꞌcuxesanic scotolic ta slajeb cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yuꞌun jaꞌ jech sba tscꞌan li Jtote ti acꞌo cuxiicuc o sbatel osil scotol li buchꞌutic ta schꞌunic ti joꞌon Snichꞌonun li Diose, schiꞌuc ta schꞌunic ti joꞌon Yajcoltavanejicune. Mi ichamique, ta jchaꞌcuxesanic scotolic ta slajeb cꞌacꞌal ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Li jchiꞌiltac ta israelale muc bu schꞌunic li cꞌalal laj yal Jesús ti jaꞌ vaj yaꞌel ti te liquem talel ta vinajele. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jech laj yalbe sbaic: ―Jaꞌ snichꞌon José li Jesús liꞌi. Xcojtaquinbetic li stot smeꞌe. ¡Cꞌu ma sba ti chal ti liquem talel ta vinajele! ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Itacꞌav li Jesuse: ―¿Cꞌu chaꞌal mu xachꞌunic li cꞌusi laj cale? ");
INSERT INTO tzoSA_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Muc buchꞌu xuꞌ chiyichꞌ ta mucꞌ mi muc bu tijbil sjol yoꞌon yuꞌun li Jtote, jaꞌ ti listac talele. Li buchꞌutic chiyichꞌic ta muqꞌue, mi ichamique, ta jchaꞌcuxesanic ta slajeb cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jech la stsꞌibaic comel li buchꞌutic iyalic scꞌop Dios ta voꞌonee: “Scotolic ch‐acꞌbat snaꞌic yuꞌun Dios ti buchꞌu ta xcoltavane”, xi onoꞌox tsꞌibabil. Jech scotol buchꞌutic tscꞌan tsnaꞌique, jaꞌ ta xꞌacꞌbat spꞌijilic yuꞌun li Jtote jech chiyichꞌic ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Muc buchꞌu yiloj li Diose. Jtuc noꞌox quiloj yuꞌun te liquemun talel ta stojol. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Melel li cꞌusi chacalbeique, li buchꞌutic ta schꞌunic ti tacbilun talel yuꞌun li Diose jaꞌ ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Joꞌon vajun yaꞌel yuꞌun ta jventa joꞌon chacuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Cꞌalal la sveꞌic manavaj li te ta taqui jamaltic li jtotic jmeꞌtic ta voꞌonee, muc bu xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Li vaj ta xcale jaꞌ te liquem talel ta vinajel. Li buchꞌutic ta sveꞌique jaꞌ ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Joꞌon li vajun yaꞌele yuꞌun te liquemun talel ta vinajel. Ta jventa joꞌon chacuxiic o sbatel osil. Scotol buchꞌutic ta sveꞌic li vaj ta xcale, jaꞌ ta xcuxiic o sbatel osil. Li vaj li chcaqꞌue jaꞌ li jbecꞌtale. Ta xcacꞌ ta sventa xuꞌ ta xcuxiic o sbatel osil scotol li crixchanoetique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Li jchiꞌiltac ta israelale jech laj yalbe sbaic: ―¡Cꞌu ma sba chijyacꞌbutic jlajestic li sbecꞌtale! ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Li Jesuse jech itacꞌav: ―Melel li cꞌusi chacalbeique, mi muc bu alajesojic li jbecꞌtale, joꞌon li coꞌol crixchanoutique, mi muc bu avuchꞌojic li jchꞌichꞌele, mu xacuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Li buchꞌutic ta slajesic li jbecꞌtale schiꞌuc ta xuchꞌic li jchꞌichꞌele ta xcuxiic o sbatel osil. Mi ichamique, ta jchaꞌcuxesanic ta slajeb cꞌacꞌal. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Li jbecꞌtale coꞌol schiꞌuc lequil veꞌlil yaꞌel. Li jchꞌichꞌele coꞌol schiꞌuc lequil joꞌ yaꞌel jech chacuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Li buchꞌutic ta slajesic li jbecꞌtale schiꞌuc ta xuchꞌic li jchꞌichꞌele jaꞌ te jchiꞌuquic o, jech te oyun o ta yoꞌonic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Li Jtot ti listac talele cuxul o sbatel osil. Jaꞌ noꞌox jechun eꞌuc, cuxulun o sbatel osil ta sventa li Jtote. Jaꞌ noꞌox jechic eꞌuc li buchꞌutic chislajesique, ta jventa joꞌon ta xcuxiic o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Li vaj ta xcale jaꞌ te liquem talel ta vinajel. Maꞌuc jech sba jech chac cꞌu chaꞌal li manavaj ti la sveꞌic li jtotic jmeꞌtic ta voꞌonee. Cꞌalal la sveꞌic manavaj li jtotic jmeꞌtic ta voꞌonee, muc bu xcuxiic o sbatel osil. Yan li avie li buchꞌutic ta sveꞌic li vaj ta xcale jaꞌ ta xcuxiic o sbatel osil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jaꞌ jech laj yal Jesús li cꞌalal ichanubtasvan ta schꞌulnaic li jchiꞌiltac ta israelal li te ta Capernaume. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ep li jchiꞌiltac ta israelal la schiꞌinic jujun cꞌacꞌal li Jesuse, pero cꞌalal iyaꞌiic li cꞌu sba ichanubtasvane, jech laj yalic: ―Altic chal ti liquem talel ta vinajele. Mu jchꞌuntic ti avaꞌi sba chale ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Li Jesuse snaꞌoj ti oy jchiꞌiltac ti mu schꞌunic li cꞌusi laj yale. Jech la sjacꞌbe: ―¿Mi chopol avaꞌiic li cꞌusi laj cale? ");
INSERT INTO tzoSA_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Cꞌu chavalic mi la avilic ti chimuy batel li bu liquemun talele, joꞌon li coꞌol crixchanoutique? ");
INSERT INTO tzoSA_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jaꞌ persa scꞌan chachꞌunic li cꞌusi chcale yoꞌ jech chacuxiic o sbatel osil. Jaꞌ jech smelol li cꞌusi laj calboxuque. Maꞌuc to uts li cꞌustic chapasique. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero mu acotolicuc chachꞌunic ―xꞌutatic yuꞌun li Jesuse. Cꞌalal lic stsac yabtel li Jesuse, snaꞌoj xa onoꞌox li buchꞌutic mu schꞌunic ti jaꞌ Jcoltavaneje schiꞌuc li buchꞌu ta xꞌacꞌvan ta cꞌabale. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Li Jesuse jech laj yalbuncutic jcotolcutic: ―Laj onoꞌox calboxuc ti muc buchꞌu xuꞌ chiyichꞌ ta mucꞌ mi muc bu tijbil sjol yoꞌon yuꞌun li Jtote ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jaꞌ yuꞌun ep jchiꞌiltac laj yictaic comel li Jesuse, jaꞌ li buchꞌutic coꞌol toꞌox la jchiꞌincutique. Mu xa bu la schiꞌinic batel. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Li Jesuse jech la sjacꞌbuncutic, joꞌoncutic li lajchavoꞌuncutique: ―Li joꞌoxuque ¿mi chacꞌan chavictaicun eꞌuc? ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Itacꞌav li Simón Pedroe: ―Cajval, ¡bu xa chba jacꞌcutic ta yan! Atuc noꞌox xanaꞌ li cꞌu sba chijcuxicutic o sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Li joꞌoncutique jchꞌunojcutic. Jnaꞌcutic ti joꞌot li Cristoote, ti tꞌujbilot yuꞌun Dios ti chaventainuncutique. Joꞌot Snichꞌonot li cuxul Diose ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Itacꞌav li Jesuse: ―Joꞌon la jtꞌujoxuc li lajchavoꞌoxuque pero oy junoxuc ti jaꞌ ventainbil yuꞌun li pucuje ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jaꞌ Judas li laj yalbe scꞌoplale, jaꞌ li snichꞌon Simón Iscariotee, yuꞌun jaꞌ ta xꞌacꞌvan ta cꞌabal. Li Judase jaꞌ jchiꞌilcutic ta yajchanbalajeltac Jesús ti lajchavoꞌuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ta tsꞌacal ixanav ta scotol jteclumetic li ta Galilea balumil li Jesuse. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Li Jesuse mu scꞌan chbat ta Judea balumil yuꞌun li jꞌabteletic cuꞌuncutique te yacal tsnopbeel scꞌoplal cꞌu sba tsmilic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Poꞌot xaꞌox jun qꞌuin yuꞌun li jchiꞌiltac ta israelale li te ta Jerusalene. Jaꞌ li qꞌuin ti ta smeltsanan syaxnaic ti ta xꞌochic o li jchiꞌiltaque. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Li Jesuse jech iꞌalbat yuꞌun li yitsꞌinabe: ―Mu xavicta aba, batic ta Judea. Yuꞌun cꞌalal ta xilic ti ep chavacꞌ ta ilel atsatsal ajuꞌel li te ta qꞌuine, jech más chayichꞌic o ta mucꞌ li buchꞌutic schꞌunojic xa la acꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Li buchꞌu ta scꞌan ta xpuc scꞌoplale mu ta muculuc ta spas li cꞌu sba yabtele. Mi jaꞌ avabtel o ti jech chapase, acꞌ aba ta ilel ta stojol scotol crixchanoetic ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Li yitsꞌinabtaque mu schꞌunic eꞌuc ti jaꞌ tꞌujbil yuꞌun Dios ti chventainvan li sbanquilique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Li Jesuse jech laj yalbe: ―Muc to bu tsta scꞌacꞌalil ti chibat ta qꞌuine. Li joꞌoxuque cꞌuc noꞌox ora xuꞌ chabatic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Li crixchanoetique muc bu chopol chayilic li joꞌoxuque. Yan li joꞌone chopol chiyilic yuꞌun joꞌon ta xcalbeic ti chopol li cꞌustic ta spasique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Li joꞌoxuque batanic li ta qꞌuine. Yan li joꞌone muc to bu chibat yuꞌun muc to bu tsta scꞌacꞌalil ti chibate ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cꞌalal jech laj yalbe li yitsꞌinabtac li Jesuse, te lijocꞌtsajcutic ta Galilea schiꞌuc Jesús, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Batemic xaꞌox ta qꞌuin li te ta Jerusalén li yitsꞌinabtac li Jesús li cꞌalal lijbatcutic eꞌuc schiꞌuc li Jesuse. Muc bu la jchiꞌincutic batel li crixchanoetique. Jtuccutic noꞌox lijbatcutic yuꞌun mu scꞌan xacꞌ sba ta ilel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Li jꞌabteletic cuꞌuncutic, joꞌoncutic li jꞌisraeluncutique, te oyic ta qꞌuin ta saꞌic li Jesuse. Jech ta sjacꞌulanbeic li crixchanoetique: ―¿Bu oy xanaꞌic li Jesuse? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Scotol li jꞌilqꞌuinetique naca jaꞌ sbel yeic li Jesuse. Oy buchꞌutic jech laj yalic: ―Toj lec yoꞌon ―xiic. Oy yan jech laj yalic: ―¡Muc bu lec! Jaꞌ jloꞌlovanej ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero mu junuc buchꞌu tsjamalꞌal li Jesuse yuꞌun ta xiꞌic li ta jꞌabteletic cuꞌuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cꞌalal yoxibal xaꞌox cꞌacꞌal liquem qꞌuine, ibat ta mucꞌta chꞌulna li Jesuse. Cꞌot chanubtasvanuc ta yamaqꞌuil li mucꞌta chꞌulnae. Te jchiꞌucutic ti yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Li jꞌabteletique toj chꞌayel noꞌox yoꞌonic li cꞌu sba ichanubtasvan li Jesuse. Jech laj yalic: ―¿Bu ischan li jchiꞌiltic liꞌi yuꞌun muc buchꞌu la schanubtas cuꞌuntic? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Li Jesuse jech laj yal: ―Maꞌuc jcꞌop jtuc li liꞌ chichanubtasvan oe. Jaꞌ scꞌop stuc li Diose, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Li buchꞌu tscꞌan tspas li cꞌusi ta scꞌan li Diose, ta xꞌacꞌbat snaꞌ mi jaꞌ scꞌop Dios li chcale, mi jcꞌop noꞌox jtuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Li buchꞌu ta xchanubtasvan o li cꞌusi ta snop stuque, jaꞌ noꞌox ta scꞌan ichꞌel ta mucꞌ stuc. Li joꞌone ta xcacꞌ ta ichꞌel ta mucꞌ li Diose, jaꞌ ti listac talele. Muc bu chiloꞌlovan. Jaꞌ melel li cꞌusi chcale. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Li Moisés li iyal scꞌop Dios ta voꞌonee la stsꞌibaboxuc comel li mantaletique. Pero mu junuc buchꞌu schꞌunoj jech chac cꞌu chaꞌal ta xal li mantaletique. Ti achꞌunojicuc li mantaletique, muc bu chanopic chamilicun ti jechuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jech itacꞌavic li jchiꞌiltaque: ―Ochem pucuj ta ajol taje. ¿Buchꞌu chac smilot? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Itacꞌav li Jesuse: ―Jun noꞌox vinic la jcolta ta scꞌacꞌalil ta jcuxtic pero acotolic toj chꞌayel noꞌox o avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Li Moisese laj yalboxuc ti chavaqꞌuic ta ichꞌel circuncisione, pero maꞌuc baꞌi iꞌalbat li Moisese. Jaꞌ baꞌi iꞌalbat li jtotic jmeꞌtic ta más voꞌonee. Li joꞌoxuque acꞌo mi ta scꞌacꞌalil ta jcuxtic, chavacꞌbeic yichꞌ circuncisión li unetic li yichꞌojic xa vaxaquib cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ti chavaqꞌuic circuncisión ta scꞌacꞌalil ta jcuxtique yoꞌ jech mu xapꞌajbeic smantal li Moisese, ¿cꞌu chaꞌal chopol chavilicun ti la jcolta jun jchiꞌiltic li ta scꞌacꞌalil ta jcuxtique? ");
INSERT INTO tzoSA_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Muc bu lec mi chaticꞌbeic smul ta ora jun vinique. Jaꞌ scꞌan chanopic mi melel ti chopol li cꞌusi la spase ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oy jayvoꞌ li jchiꞌiltac li te nacalic ta Jerusalene jech laj yalic: ―¿Mi maꞌuc li vinic liꞌi ti ta saꞌic li jꞌabteletic cuꞌuntic ti chac smilique? ");
INSERT INTO tzoSA_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Qꞌuelavilic, liꞌ to ta xchanubtasvan ta jtojoltique. Pero mu cꞌusi ta xꞌalbat yuꞌun li jꞌabteletique. ¿Mi yuꞌun schꞌunojic xa ti jaꞌ li tꞌujbil yuꞌun Dios ti scꞌoplal onoꞌox chtal sventainutique? ");
INSERT INTO tzoSA_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Li joꞌotique jnaꞌojtic ti bu liquem talel li vinic liꞌi. Cꞌalal ta xtal li buchꞌu tꞌujbil yuꞌun Dios ti chisventainutique, muc buchꞌu snaꞌ bu ta xlic talel ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Li Jesuse tsots icꞌopoj li te ta yamaqꞌuil li mucꞌta chꞌulna ta Jerusalén li cꞌalal ichanubtasvane. Jech iyal: ―Xavojtaquinicun ti avalojique. Anaꞌojic li bu liquemun talel ti avalojique. Pero mu ta jmantaluc jtuc ti litale. Jaꞌ listac talel li Diose, jaꞌ melel li scꞌope. Pero mu xavojtaquinic li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Li joꞌone xcojtaquin yuꞌun jaꞌ te liquemun talel ta stojol. Jaꞌ listac talel liꞌi ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Chac stiqꞌuic o ta chuquel li Jesuse, pero muc buchꞌu tstsac yuꞌun muc to bu cꞌotem scꞌacꞌalil ta stsaquic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero oy ep buchꞌutic la schꞌunic ti jaꞌ xa li buchꞌu tꞌujbil yuꞌun Dios ti scꞌoplal onoꞌox chtal ventainvanuque. Jech laj yalic: ―Li jchiꞌiltic liꞌi chacꞌ ta ilel ep stsatsal sjuꞌel jech chac cꞌu chaꞌal scꞌoplal ta spas li buchꞌu scꞌoplal onoꞌox chtal sventainutique. Jaꞌ xa li liꞌ oye ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Li jfariseoetique iyaꞌiic ti jaꞌ jech ta xloꞌilajic li buchꞌutic la schꞌunic xa ti jaꞌ Jesús li buchꞌu tꞌujbil yuꞌun Dios ti scꞌoplal onoꞌox chtal ventainvanuque. Jaꞌ yuꞌun li banquilal paleetique schiꞌuc li jfariseoetique laj yalbeic jayvoꞌ yajmayolic ti acꞌo stsaquic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Li Jesuse jech laj yalbe li jchiꞌiltaque: ―Mu xa jaluc liꞌ jchiꞌucoxuque. Ta xa xibat li yoꞌ bu oy li buchꞌu listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Li joꞌoxuque chasaꞌicun pero mu xataicun. Li yoꞌ bu chibate mu xuꞌ chabatic tey eꞌuc li joꞌoxuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Li jꞌabteletic cuꞌuncutique jech lic yalulanbe sbaic: ―¿Bu chbat ti yaloj ti mu xa jtatique? ¿Mi jaꞌ nan te chbat li yoꞌ bu oy li jchiꞌiltactic li spucoj sbaic batel ta yosilal li jgreciaetique? ¿Mi jaꞌ nan chba schanubtas li jgreciaetique? ");
INSERT INTO tzoSA_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Cꞌu sba smelol taje ti jech laj yale: “Chasaꞌicun pero mu xataicun. Li yoꞌ bu chibate mu xuꞌ chabatic tey eꞌuc li joꞌoxuque”, ti xijyututique? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta mucꞌta qꞌuine la svaꞌan sba ta oꞌlol crixchanoetic li Jesuse. Tsots icꞌopoj, jech laj yalbe li jchiꞌiltaque: ―Li buchꞌutic ta saꞌulanic li cꞌu sba xuꞌ ta xtuqꞌuibic jech chac cꞌu chaꞌal ta saꞌulan joꞌ yuchꞌ mi chtaquij stiꞌe, acꞌo yichꞌicun ta mucꞌ. Joꞌon ta jtuqꞌuibtasbe yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Li buchꞌutic ta schꞌunic ti joꞌon ta jcoltaique, jech ta xcꞌot ta pasel jech chac cꞌu chaꞌal tsꞌibabil ta scꞌop li Diose: “Li slequil li yoꞌonique jaꞌ jech chac cꞌu chaꞌal li nioꞌ ti te xnixnun oe”, xi tsꞌibabil ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ti jech laj yal Jesuse, jaꞌ laj yalbe scꞌoplal yabtel li Chꞌul Espíritu li scꞌoplal onoꞌox ta xꞌacꞌbat ta yoꞌonic li buchꞌutic ta schꞌunic ti jaꞌ Yajcoltavanejic li Jesuse. Pero muc toꞌox bu talem li Chꞌul Espíritue yuꞌun muc toꞌox bu sutem batel ta vinajel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cꞌalal iyaꞌiic li jchiꞌiltac ta israelal li cꞌusi laj yal li Jesuse, oy buchꞌutic jech laj yalic: ―Ta melel jaꞌ xa li buchꞌu ti scꞌoplal onoꞌox chtal yal li scꞌop Diose ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Oy yan jech laj yalic: ―Liꞌi jaꞌ xa li buchꞌu tꞌujbil yuꞌun Dios ti scꞌoplal onoꞌox chtal sventainutique ―xiic. Oy yan jech laj yalic: ―Mu teuc chlic talel ta Galilea li buchꞌu scꞌoplal chtal sventainutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chal ta scꞌop Dios ti te ta xvocꞌ ta Belene yuꞌun jaꞌ snitilul David ta voꞌonee. Jaꞌ te ta xvocꞌ li yoꞌ bu ivocꞌ li Davide ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jaꞌ yuꞌun la svoqꞌuilan sbaic ta cꞌop li jchiꞌiltac ta stojol li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Oy buchꞌutic chac stsaquic li Jesuse pero muc buchꞌu stsac. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Li mayoletique isutic ta stojol li banquilal paleetique schiꞌuc li jfariseoetique. Jech ijacꞌbatic: ―¿Cꞌu chaꞌal muc bu xatsaquic talel? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Itacꞌavic li mayoletique: ―Yuꞌun muc buchꞌu jech chloꞌilaj jech chac cꞌu chaꞌal chloꞌilaj li vinique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jech iꞌalbatic yuꞌun li jfariseoetique: ―¿Mi laloꞌloatic eꞌuc li joꞌoxuque? ");
INSERT INTO tzoSA_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mu junuc jꞌabteletic cuꞌuntic schꞌunojic ti jaꞌ xa li buchꞌu scꞌoplal ti chisventainutique. Mi joꞌcuncutic muc bu jchꞌunojcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Li jchiꞌiltactic li te tsobolic ta stojol li Jesuse mu snaꞌic li cꞌusi ta xal li mantaletique. Ichꞌayic xa o ―xiic li jfariseoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te oy eꞌuc li Nicodemoe, jaꞌ li buchꞌu a scꞌopon ta acꞌubal li Jesuse, yuꞌun ochem ta fariseoal eꞌuc. Li Nicodemoe jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Mu xuꞌ ta xcacꞌbetic yichꞌ vocol jun jchiꞌiltic mi muc bu caꞌiojtic li cꞌusi ta xale, schiꞌuc mi mu to jnaꞌtic ti cꞌusi smule. ¿Mi mu jechuc ta xal li mantaletic cuꞌuntique? ―xi li Nicodemoe. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jech laj yalbeic li Nicodemoe: ―¿Mi yuꞌun te liquemot talel ta Galilea eꞌuc li joꞌote? Qꞌuelo li scꞌop Diose jech chanaꞌ o ti mu junuc li buchꞌu ta xal scꞌop Dios ti te chlic talel ta Galileae ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Isutic batel ta snaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Li Jesuse ibat ta vits Olivatic. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ta sob ta yocꞌomal lijsutcutic talel schiꞌuc li Jesuse, te lijbatcutic nojtoc li ta mucꞌta chꞌulna li ta Jerusalene. Ep jchiꞌiltac italic ta stojol Jesús. Ichoti li Jesuse, lic chanubtasvanuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Te italic eꞌuc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose schiꞌuc jayvoꞌ li jfariseoetique. Te yicꞌojic talel jun ants. Li antse yacal ta mulivajel istaic. Cꞌot yaqꞌuic ta stojol Jesús ta oꞌlol crixchanoetic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jech laj yalbeic li Jesuse: ―Jchanubtasvanej, li ants liꞌi yacal ta mulivajel ijtacutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Li Moisés li iyal scꞌop Dios ta voꞌonee yalojbutic mantal ti acꞌo acꞌbatuc ton li buchꞌu jech ta spase. ¿Cꞌusi chanop eꞌuc li joꞌote? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ti jech laj yalbeic li Jesuse, yuꞌun tsqꞌuelbeic yoꞌon yuꞌun chac saꞌbeic smul. Li Jesuse la snijan sba, la stsꞌiba balumil ta sbicꞌtal scꞌob. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ti mu xlaj yoꞌonic ta sjaqꞌuele, jech la stuqꞌuibtas sba li Jesuse, jech laj yal: ―Mi oy buchꞌu junucal ti muꞌyuc amulique, jaꞌ baꞌi acꞌo yacꞌbe ton li antse ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","La schaꞌnijan sba nojtoc li Jesuse, la schaꞌtsꞌiba nojtoc li balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cꞌalal iyaꞌiic ti jech laj yal Jesús li jꞌabteletique, icꞌopoj yoꞌonic ta scoj li smulique. Ta jujuntal iloqꞌuic batel. Jaꞌ baꞌi iloqꞌuic batel li buchꞌutic más molic xae. Jaꞌ xa noꞌox te icom li Jesús schiꞌuc li ants li te ta oꞌlol crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Li Jesuse la schaꞌtuqꞌuibtas sba, iyil ti muc xa bu te oyic li buchꞌutic laj yiqꞌuic talel li antse, jaꞌ xa noꞌox stuc te oy li antse. Li Jesuse jech laj yalbe li antse: ―Li buchꞌutic laj yalic amule ibatic xa. Muc buchꞌu laj yacꞌbot ton ta scoj la amule ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Itacꞌav li antse: ―Muꞌyuc, tata ―xi. Li Jesuse jech laj yalbe: ―Jaꞌ jechun eꞌuc, muc bu chacacꞌbe avichꞌ vocol ta scoj la amule. Batan, mu xa me xasaꞌ amul ―xꞌutat batel li antse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Li Jesuse ichanubtasvan nojtoc, jech laj yal: ―Li joꞌone coꞌol schiꞌuc xojobal cꞌocꞌun yaꞌel ta atojolic, joꞌoxuc ti oyoxuc ta icꞌal acꞌubal yaꞌel ta scoj li mulile. Li buchꞌutic chiyichꞌic ta muqꞌue ta xictaic spasel li mulile. Jaꞌ xa ta spasic li cꞌustic leque yuꞌun joꞌon ta jcoltaic, jech ta xcuxiic o sbatel osil ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Li Jesuse jech iꞌalbat yuꞌun li jfariseoetique: ―Li joꞌote atuc noꞌox chaval acꞌoplal. Muꞌyuc avajtextico jech mu jchꞌuncutic li cꞌusi chavale ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Itacꞌav li Jesuse: ―Acꞌo mi chavalic ti jtuc noꞌox ta xcal jcꞌoplale, pero jaꞌ melel li cꞌusi chcale. Yuꞌun jnaꞌoj ti bu liquemun talele, jnaꞌoj ti bu chibate. Li joꞌoxuque mu xanaꞌic ti bu liquemun talele, jech mu xanaꞌic bu chibat nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Li joꞌoxuque chanopic ti crixchanoun noꞌoxe jech chasaꞌbecun jmul. Li joꞌone muc buchꞌu ta jsaꞌbe smul. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mi oy buchꞌu ta xcalbe ti oy smule, yuꞌun xa onoꞌox oy smul. Yuꞌun mu jtucuc noꞌox ta jnop ti oy smule; jaꞌ coꞌol ta xcalcutic jchiꞌuc li Jtote, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Li mantaletic li avichꞌojique ta xal ti jaꞌ to xuꞌ chachꞌunic mi jmoj scꞌopic li chaꞌvoꞌ texticoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Li joꞌone ta xcal jcꞌoplal jtuc. Pero jaꞌ jech ta xal jcꞌoplal eꞌuc li Jtote, jaꞌ ti listac talele ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Li jfariseoetique jech la sjacꞌbeic li Jesuse: ―¿Bu oy la atot chavale? ―xutic. Itacꞌav li Jesuse: ―Mu xavojtaquinicun, jech mu xavojtaquinic eꞌuc li Jtote. Ti xavojtaquinicune, jech xavojtaquinic eꞌuc li Jtote ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jaꞌ jech laj yal Jesús li cꞌalal ichanubtasvan li ta yut jcꞌol chꞌulna li yoꞌ bu laj yaqꞌuic smoton Dios li jchiꞌiltaque. Pero muc buchꞌu tal stsaquic li Jesuse yuꞌun muc to bu cꞌotem scꞌacꞌalil ti ta stsaquee. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Li Jesuse jech laj yalbe nojtoc li jchiꞌiltac ta israelale: ―Li joꞌone chibat. Chasaꞌicun pero mu xataicun. Te acuchoj amulic chachamic. Li bu chibate mu xuꞌ chabatic te li joꞌoxuque ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jech laj yalbe sbaic li jchiꞌiltaque: ―¿Mi yuꞌun nan ta smil sba stuc ti avaꞌi sba chale: “Li bu chibate mu xuꞌ chabatic tey li joꞌoxuque”, ti xijyututique? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Li Jesuse jech iyal: ―Li joꞌoxuque liꞌ lachꞌiic lacꞌopojic ta sba balumile; li joꞌone liquemun talel ta vinajel, jaꞌ yuꞌun mu coꞌoluc ta jnoptic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ti laj calboxuc ti te acuchoj amulic chachamique, yuꞌun mu xachꞌunic ti joꞌon chajcoltaique, jaꞌ yuꞌun te acuchoj o amulic chachamic ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jech lic sjaqꞌuic nojtoc li jꞌabteletique: ―¿Buchꞌuot chaꞌa? ―xutic. Itacꞌav li Jesuse: ―Jaꞌ noꞌox jech chac cꞌu chaꞌal laj calboxuc ta baꞌie. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Acꞌo mi oy ep li cꞌusi xuꞌ chacalbeique, acꞌo mi oy amulic ti xuꞌ chacalbeique pero muc to bu chacalbeic. Yuꞌun jaꞌ noꞌox chacalbeic li cꞌusi albilun yuꞌun li Jtote, jaꞌ ti listac talele. Li Jtote jaꞌ melel li cꞌusi chale ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta sventa ti mu schꞌunic ti te liquem talel ta vinajel li Jesuse, jech muc bu xaꞌibeic o smelol ti jaꞌ laj yalbe scꞌoplal li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Li Jesuse jech laj yalbe nojtoc: ―Cꞌalal chajocꞌanicun ta cruz, joꞌon li coꞌol crixchanoutique, jaꞌ to te chanaꞌic o ti joꞌon Avajcoltavanejicune. Schiꞌuc chanaꞌic ti jaꞌ noꞌox laj calboxuc li cꞌu sba yalojbun li Jtote, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Li Jtote liꞌ jchiꞌuque, mu xiyicta yuꞌun scotol cꞌacꞌal ta jpasbe li cꞌusi ta scꞌane ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cꞌalal jech laj yal li Jesuse, ep buchꞌutic la schꞌunic ti jaꞌ xa li buchꞌu scꞌoplal onoꞌox chtal ventainvanuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Li Jesuse jech laj yalbe li jchiꞌiltac ta israelal ti la schꞌunic ti jaꞌ tꞌujbil yuꞌun Dios ti chventainvane: ―Mi chachꞌunic ta jꞌechꞌel li cꞌusi laj calboxuque, jech ta xvinaj ti ta melel cuꞌunoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jech chanaꞌic ti jaꞌ melel li cꞌusi laj cale. Ta sventa li jcꞌop ti jaꞌ melele jech chaloqꞌuic o ta jtunel ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Itacꞌavic: ―Li joꞌoncutique jaꞌ jnitilulcutic li Abrahame. Mu junuc buchꞌu ochem ta jtunel cuꞌuncutic. ¿Cꞌu chaꞌal jech chaval: “Jech chaloqꞌuic o ta jtunel”, ti xachie? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Itacꞌav li Jesuse: ―Melel li cꞌusi chacalbeique, scotol li buchꞌutic ta saꞌulan smulique jaꞌ te oyic ta jtunel yuꞌun li smulique. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Li buchꞌutic ochemic ta jtunele mu cꞌusi ta xꞌacꞌbatic yuꞌun li yajvalique, jaꞌ noꞌox jayib cꞌacꞌal ta xꞌacꞌbat sventainic. Yan li nichꞌoniletique ta xꞌacꞌbatic o ta jꞌechꞌel scotol li cꞌustic oy yuꞌun li stotique. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Joꞌon li snichꞌonun li Diose, mi joꞌon chajloqꞌuesic ta jtunel yuꞌun li mulile, ta melel chaloqꞌuic o ta jꞌechꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Melel jaꞌ anitilulic li Abrahame pero mu coꞌoluc avoꞌonic achiꞌuquic yuꞌun chac amilicun. Naca milvanej noꞌox batem ta avoꞌonic ta scoj ti mu xcꞌot ta avoꞌonic li jcꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Li joꞌone jaꞌ noꞌox ta xcal li cꞌustic quiloj ta stojol li Jtote. Li joꞌoxuque jaꞌ chapasic li cꞌusi chayalbeic la atotique ―xꞌutatic yuꞌun li Jesuse: ");
INSERT INTO tzoSA_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Itacꞌavic: ―Jaꞌ coꞌol jchꞌunojcutic jech chac cꞌu chaꞌal li jnitilulcutic Abrahame ―xiic. Li Jesuse jech laj yalbe: ―Ti jechuc achꞌunojic jech chac cꞌu chaꞌal li Abrahame, chapasic jech chac cꞌu chaꞌal la spas li Abraham ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Li avie chacꞌan chamilicun yuꞌun laj calboxuc avaꞌiic li cꞌusi melel ti laj yalbun talel li Diose. Li Abrahame muc bu jech la spas. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Joꞌoxuque jaꞌ chapasbeic yabtel la atotique ―xut. Itacꞌavic: ―Li joꞌoncutique maꞌuc tsobbil unenuncutic. Jun noꞌox li jtotcutique, jaꞌ li Diose ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Li Jesuse jech laj yalbe: ―Ti jaꞌuc atotic li Diose, cꞌuxun ta avoꞌonic ti jechuque. Yuꞌun te liquemun talel ta stojol li Diose. Mu ta jmantaluc jtuc ti litale; jaꞌ listac talel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ti mu xavaꞌibeic smelol li jcꞌope, yuꞌun mu onoꞌox xacꞌan xavaꞌiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Li joꞌoxuque jaꞌ atotic li pucuje. Jaꞌ noꞌox batem ta avoꞌonic chapasic li cꞌustic ta scꞌan li pucuje. Yuꞌun li stuque jmilvanej onoꞌox li cꞌalal ilic li balumile, jaꞌ jech cꞌalal tana. Mu scꞌan li cꞌusi melele yuꞌun chopol onoꞌox li yoꞌone. Stalel onoꞌox ti jutcꞌope. Jaꞌ banquilal jutcꞌop o. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Li joꞌone jaꞌ melel li cꞌusi chacalbeique, pero mu xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Li joꞌoxuque mu xatabecun jmul. Melel li jcꞌop li laj calboxuque. ¿Cꞌu chaꞌal mu xachꞌunbecun? ");
INSERT INTO tzoSA_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Li buchꞌutic snichꞌnabtac li Diose ta xichꞌbeic ta mucꞌ li scꞌop li Diose. Ti mu xavichꞌic ta mucꞌ li scꞌop Diose, yuꞌun maꞌuc snichꞌnaboxuc li Diose ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Itacꞌavic li jchiꞌiltac ta israelale, jech laj yalbeic li Jesuse: ―Jaꞌ melel li cꞌusi la jnopcutique. Li joꞌote jsamariail vinicot. Ochem pucuj ta avoꞌon ―xi la snaꞌleic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Itacꞌav li Jesuse: ―Muc bu ochem pucuj ta coꞌon. Jaꞌ ta xcacꞌ ta ichꞌel ta mucꞌ li Jtote. Li joꞌoxuque mu xavichꞌicun ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pero mu jtucuc noꞌox ta xcacꞌ jba ta ichꞌel ta mucꞌ. Jaꞌ chiyacꞌ ta ichꞌel ta mucꞌ eꞌuc li Jtote. Li buchꞌutic mu xiyichꞌic ta muqꞌue jaꞌ ch‐ichꞌbat scꞌopic yuꞌun li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Melel li cꞌusi chacalbeique, li buchꞌutic ta xacꞌ ta yoꞌonic li jcꞌope jaꞌ muc bu ta xcham ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Li jchiꞌiltaque jech laj yalbeic li Jesuse: ―Jnaꞌojcutic xa ti ta melel ochem pucuj ta avoꞌone. Li jnitilulcutic Abrahame icham. Ichamic eꞌuc li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Li joꞌote chaval ti muc bu ta xcham li buchꞌutic ta xacꞌ ta yoꞌonic la acꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mi yuꞌun joꞌot más tsots avabtel avichꞌoj ti avaloje? Li jnitilulcutic Abrahame más tsots yabtel iyichꞌ pero icham. Ichamic eꞌuc li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Li joꞌote ¿bu talemot ti avaloje? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Itacꞌav li Jesuse: ―Ti jtucuc noꞌox ta xcacꞌ jba ta ichꞌel ta muqꞌue, xuꞌ mu xachꞌunic. Pero moꞌoj. Jaꞌ chiyacꞌ ta ichꞌel ta mucꞌ li Jtote, jaꞌ li Dios avuꞌunic ti avalojique. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero mu xavojtaquinic. Li joꞌone xcojtaquin. Mi ta xcal ti mu xcojtaquine, ta jut cꞌop jech chac cꞌu chaꞌal chajutic cꞌop li joꞌoxuque. Li joꞌone xcojtaquin li Diose, ta jchꞌunbe li cꞌustic chiyalbune. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","La anitilulic Abraham ti chavalique, xmuybaj noꞌox yuꞌun yaꞌiojbun jcꞌoplal ti chitale. Ischꞌun ti chitale jech xmuybaj o ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Li jꞌabteletic cuꞌuncutique jech laj yalbeic li Jesuse: ―Muc to bu avichꞌoj lajuneb yoxvinic (50) jabil. ¿Cꞌuxi xavojtaquin li Abrahame yuꞌun queremot to? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Li Jesuse jech itacꞌav: ―Melel li cꞌusi chacalbeique, cꞌalal muc toꞌox bu voqꞌuem li Abrahame, te onoꞌox oyun li joꞌone ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","La stamic ton li jchiꞌiltaque yuꞌun chac smilic ta ton li Jesuse. Li Jesuse ijelav batel ta oꞌlol crixchanoetic jech muc bu xilic ilocꞌ ta stiꞌ smacol li mucꞌta chꞌulnae, ibat. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Li yoꞌ bu lijelavcutic batel schiꞌuc li Jesuse, te iquilcutic jun jchiꞌilcutic ta israelal, maꞌsat onoꞌox ivocꞌ li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Joꞌoncutic li yajchanbalajeltacuncutique jech la jacꞌbecutic li Jesuse: ―Jchanubtasvanej, ¿buchꞌu ta smul ti jech maꞌsat ivocꞌ li vinic liꞌi? ¿Mi ta smul stuc, mi ta smul stot smeꞌ? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Itacꞌav li Jesuse: ―Mu ta smuluc stuc, mu ta smuluc stot smeꞌ. Ti jech maꞌsat ivocꞌ li jchiꞌiltique, yoꞌ jech acꞌo vinajuc o sjuꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yoꞌ to cuxulun liꞌ ta balumile, persa ta jpasbe yabtel li Jtote, jaꞌ ti listac talele. Yuꞌun poꞌot xa chimile. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ti jayib to cꞌacꞌal liꞌ oyun ta balumile, jaꞌ jechun jech chac cꞌu chaꞌal xojobal cꞌocꞌ ta atojolic, joꞌoxuc li liꞌ oyoxuc ta balumile, yuꞌun joꞌon chacacꞌbe avilic ti xuꞌ chacolic ta jventae ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cꞌalal laj yal jech li Jesuse, la stubta balumil, la spas jsetꞌ achꞌel. Jaꞌ la sbonbe o schaꞌpꞌejel sat li maꞌsat vinique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jech laj yalbe: ―Batan, ba poco la asate li te ta stanqueal joꞌ, Siloé sbie ―xꞌutat. Li Siloée jaꞌ “tacbil” xi smelol. Ibat li maꞌsate, ba spoc li sate. Cꞌalal isute, lec xa xil osil yuꞌun ijam xa li sate. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jech laj yalbe sbaic li buchꞌutic te nopol nacalic schiꞌuque, schiꞌuc li buchꞌutic yilojic ti jech onoꞌox maꞌsat ivoqꞌue: ―Li vinic liꞌi ¿mi maꞌuc li buchꞌu te onoꞌox chotol ta xcꞌanolaje? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Oy jayvoꞌ jech laj yalic: ―Jaꞌ leꞌe ―xiic. Oy yan jech laj yalic: ―Maꞌuc, yuꞌun noꞌox toj jmoj satic ―xiic. Jech laj yal li vinique: ―Joꞌon chavilicune ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jech la sjacꞌbeic: ―¿Cꞌuxi ijam la asate? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Itacꞌav li vinique: ―Oy jun jchiꞌiltic, Jesús sbi, la spas jsetꞌ achꞌel, jaꞌ la sbonbun ta jsat. Cꞌalal la sbonbune, jech laj yalbun: “Batan li yoꞌ bu stanqueal joꞌ Siloé sbie, ba poco la asate”, xiyut. Ba jpoc li jsate, jech ijam o. Li avie xquil xa osil ―xi li maꞌsat toꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jech la sjacꞌbeic: ―¿Bu oy li vinic chavale? ―xutic. Itacꞌav: ―Mu jnaꞌ bu ibat ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Laj yiqꞌuic batel li vinic li maꞌsat toꞌoxe, te ba yaqꞌuic ta stojol li jfariseoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jaꞌ o scꞌacꞌalil ta jcuxcutic li cꞌalal la spas jsetꞌ achꞌel li Jesuse ti la sjambe o sat li maꞌsate. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Li jfariseoetique la sjacꞌbeic nojtoc li vinique: ―¿Cꞌu sba ijam la asate? ―xutic. Itacꞌav li vinique: ―La sbonbun achꞌel ta jsat. Tsꞌacal to ba jpoc li jsate. Jaꞌ yuꞌun xquil xa osil ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oy jayvoꞌ jfariseoetic jech laj yalic: ―Muc bu yichꞌoj ta mucꞌ Dios li vinic chavale yuꞌun mu schabi li scꞌacꞌalil ta jcuxtique ―xꞌutat. Oy yan jech laj yalic: ―Li buchꞌu oy smule mu xuꞌ ta sjambe sat maꞌsatetic jech chac cꞌu chaꞌal ta spas li vinic taje ―xiic. Yantic o iyalic jujunic li jfariseoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","La schaꞌjacꞌbeic nojtoc li vinique: ―Li joꞌote ¿buchꞌu ti avaloj li la sjambot asate? ―xutic. Itacꞌav li vinique: ―Li joꞌone ta xcal ti jaꞌ jun li buchꞌutic ti jaꞌ yabtelic ta xalic li scꞌop Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Li jfariseoetique muc bu schꞌunic ti jaꞌ li maꞌsat toꞌoxe li vinic ti ijam xa sate. Jaꞌ to cꞌalal ba yicꞌbeic talel li stot smeꞌe, jaꞌ to ischꞌunic ti jaꞌ li maꞌsat toꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Cꞌalal icꞌot li stot smeꞌe, jech la sjacꞌbeic: ―¿Mi jaꞌ avol anichꞌonic liꞌi li maꞌsat onoꞌox ivocꞌ ti chavalique? ¿Cꞌu sba ijam li sat ti xil xa osile? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Itacꞌav li stot smeꞌe: ―Jaꞌ col jnichꞌoncutic, jaꞌ li maꞌsat onoꞌox ivoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero mu jnaꞌcutic cꞌu sba ijam sat ti xil xa osile. Mu jnaꞌcutic nojtoc ti buchꞌu ijambat li sate. Jacꞌbeic stuc yuꞌun oy xa schꞌulel ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ti jech laj yalic li stot smeꞌe, yuꞌun ta xiꞌic o li ta jꞌabteletic cuꞌuncutique. Yuꞌun li jꞌabteletic cuꞌuncutique smeltsanojbeic xa scꞌoplal ti ta jꞌechꞌel mu xuꞌ ta xꞌochic ta chꞌulna li buchꞌu jamal ta xalbeic scꞌoplal li Jesuse ti jaꞌ xa li buchꞌu scꞌoplal onoꞌox chtal ventainvanuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jaꞌ yuꞌun ti jech laj yalic li stot smeꞌ li maꞌsat toꞌoxe: “Oy xa schꞌulel, jacꞌbeic stuc”, ti xiic noꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Li jꞌabteletique laj yiqꞌuic talel nojtoc li vinic ti maꞌsat toꞌoxe. Jech laj yalbeic: ―Jaꞌ alo ti Dios la scoltaote. Li vinic chavale jnaꞌojcutic ti mu xichꞌ ta mucꞌ li Diose ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Itacꞌav li vinique: ―Mu me jnaꞌ junbi mi mu xichꞌ ta mucꞌ Dios li vinique. Jaꞌ noꞌox me jaꞌ ti ijam xa jsat yuꞌune ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jech la sjacꞌbeic nojtoc: ―¿Cꞌu laj yut la sjambot la asate? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Itacꞌav li vinique: ―Laj xa calboxuc. Mu xachꞌunic. ¿Cꞌu chaꞌal ti chacꞌan chavaꞌiic nojtoque? ¿Mi yuꞌun chacꞌan chatijletaic eꞌuc? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lic snaꞌleic, jech laj yalbeic: ―Li joꞌote jaꞌ xa chatijleta li buchꞌu mu xichꞌ ta mucꞌ li Diose. Li joꞌoncutique jaꞌ ta jchꞌunbecutic li cꞌusi yaloj Moisés ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jnaꞌojcutic ti la scꞌopon sbaic schiꞌuc Dios li Moisese. Li buchꞌu chavale mu jnaꞌcutic bu liquem talel ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Itacꞌav li vinique: ―Labal chcaꞌi ti mu xanaꞌic bu liquem talele. Yuꞌun chavilic ti jaꞌ la sjambun li jsate. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jnaꞌojtic ti mu xꞌacꞌbat ta venta scꞌop yuꞌun Dios li buchꞌutic mu xichꞌic ta muqꞌue. Li buchꞌu ta xichꞌ ta mucꞌ li Diose, ti ta spasbe li cꞌusi ta scꞌane, ta xꞌaꞌibat scꞌop yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cꞌalal ilic li balumile, jech cꞌalal to tana, muc buchꞌu jech caꞌiojbetic scꞌoplal ti xuꞌ ta sjambe sat li buchꞌu maꞌsat onoꞌox ivoqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti manchuc te liquem talel ta stojol Dios li buchꞌu ta xcale, mu cꞌusi xuꞌ ta spas ti jechuque ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Cꞌalal jech iyaꞌiique, la snaꞌleic: ―Li joꞌote ta scoj ti toj chopolote jaꞌ yuꞌun maꞌsat lavocꞌ. Pero li avie joꞌot xa chacꞌan chachanubtasuncutic ―xutic. Jaꞌ yuꞌun la snutsic o loqꞌuel li ta schꞌulnaique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Li Jesuse laj yaꞌibe scꞌoplal li vinic ti inutse o loqꞌuel ta chꞌulnae. Ital li Jesuse, tal scꞌopon li vinique. Jech la sjacꞌbe: ―Li joꞌote ¿mi achꞌunoj ti talem xa li Snichꞌon Diose? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Itacꞌav li vinique: ―Tata ¿bu oy? Ta jchꞌun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Li Jesuse jech laj yalbe: ―Liꞌ xa aqꞌuelojbe sate yuꞌun joꞌon li liꞌ chajcꞌopone ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Cꞌalal iyaꞌi li vinique, la squejan sba ta stojol Jesús, jech laj yalbe: ―Cajval, ta jchꞌun ti joꞌot Snichꞌonot li Diose ―xi li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Li Jesuse jech laj yalbe li vinique: ―Lital liꞌ ta balumile yoꞌ acꞌo vinajuc o li cꞌu sba yoꞌonic li crixchanoetique. Li buchꞌutic ta scꞌan onoꞌox xojtaquinic li Diose, jaꞌ ta xjambat satic yaꞌel yuꞌun ta xojtaquinic. Yan li buchꞌutic xojtaquinic Dios ti yalojique, jaꞌ ta spasic ta maꞌsat yaꞌel yuꞌun mu xuꞌ chojtaquinic o ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oy jayvoꞌ jfariseoetic te schiꞌuquic li Jesuse. Cꞌalal iyaꞌiic ti jech laj yal li Jesuse, jech la sjacꞌbeic: ―¿Mi yuꞌun maꞌsatuncutic ti avaloje? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Itacꞌav li Jesuse: ―Ti maꞌsatucoxuque, muꞌyuc amulic ti jechuque. Ta scoj ti chavalic ti xavojtaquinic li Diose, jaꞌ amulic o ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Li Jesuse jech laj yal nojtoc: ―Melel li cꞌusi chacalbeique, li buchꞌutic mu ta tiꞌ corral ta xꞌochique, mi ta xpꞌitic ochel ta ba corrale, jaꞌ jꞌelecꞌchijetic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yan li buchꞌutic ta xꞌochic ta tiꞌ corrale jaꞌ jchabiejchijetic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Li jchabiej tiꞌcorrale ta sjambe stiꞌ li corrale yoꞌ acꞌo ochuc li jchabiejchijetique. Li chijetique xaꞌibeic cꞌu sba scꞌopojel li yajchabivanejique. Li jchabiejchijetique ta sbiiltasanic li schijtaquique li cꞌalal ta sloqꞌuesic batele. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cꞌalal mi la sloqꞌuesic scotol li jaycot schijtaquique, jaꞌ sbabe ta xbatic li jchabiejchijetique. Te tijil ta xbatic ta spatic li schijique yuꞌun ta xꞌaꞌibatic li cꞌu sba scꞌopojelic yuꞌun li schijique. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yan mi ta xaꞌiic ti maꞌuc scꞌopojel li yajchabivanejiique, mu xbatic. Ta xjatavic comel yuꞌun ta xaꞌiic ti maꞌuc scꞌopojel li yajchabivanejique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jaꞌ jech laj yal ta loꞌil li Jesuse. Li jchiꞌiltaque muc bu xaꞌibeic smelol li cꞌusi iꞌalbatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Li Jesuse jech laj yalbe nojtoc li jchiꞌiltaque: ―Melel chacalbeic, li buchꞌutic ta xꞌochic ta stojol li Diose, ta jventa joꞌon ta xꞌochic, jech chac cꞌu chaꞌal chijetic li cꞌalal ta xꞌochic ta corrale, ta tiꞌ corral ta xꞌochic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Scotol buchꞌutic spꞌisoj sbaic ta avajchabivanejic ti baꞌi liꞌ onoꞌox oyique, naca jloꞌlovanejetic. Jaꞌ jechic jech chac cꞌu chaꞌal jꞌelecꞌchijetic yuꞌun chac spojbecun li buchꞌutic ta scꞌan chiyichꞌic ta muqꞌue. Li buchꞌutic chiyichꞌic ta muqꞌue jaꞌ muc bu xacꞌbeic ta venta li scꞌop li jloꞌlovanejetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Li joꞌone coꞌol schiꞌuc tiꞌcorralun yaꞌel yuꞌun scotol buchꞌutic ta schꞌunic ti ta xcolic ta jventae, jaꞌ schij Dios yaꞌel. Jaꞌ jech chac cꞌu chaꞌal chijetic ti lec chabibilic li cꞌalal ta xloqꞌuique schiꞌuc cꞌalal ta xꞌochique, yoꞌ jech ta sta lec sveꞌelic, jaꞌ noꞌox jechic eꞌuc li buchꞌutic jaꞌ xa schijtac Dios yaꞌele, lec ta jchabian. Xmuybajic noꞌox, mu cꞌusi yan ta scꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Li jꞌelecꞌchije jaꞌ noꞌox yabtel ta xꞌelcꞌaj, ta xmilvan, ta socvan. Yan li joꞌone jaꞌ tal cacꞌbe scuxlejalic sventa sbatel osil, jech lec oyic o. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Li buchꞌu yuꞌun stuc li chijetique lec ta schabi. Mu sventauc mi jaꞌ te ta xlaj ta bolom li stuque. Jaꞌ noꞌox jechun eꞌuc li joꞌone, lec ta jchabi li buchꞌutic ta schꞌunic ti joꞌon Yajcoltavanejicune. Ta xcacꞌ jba ta milel ta scojic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Li buchꞌu jsaꞌabtel noꞌoxe, cꞌalal ta xtal li bolome, ta xicta comel li sqꞌuelbalal chijtaque, ta xjatav batel. Jech oy jaycot ta xlaj ta bolom. Li yane chlaj jatavuc echꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ti ta xjatavic batel li jsaꞌabteletique, yuꞌun noꞌox tsaꞌ staqꞌuinic, jaꞌ yuꞌun mu cꞌu sventa o li sqꞌuelbalal chijtaque. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Li buchꞌu yuꞌun stuc li chije, lec ta schabi li schijtaque schiꞌuc lec xojtaquinan. Jaꞌ noꞌox jechun eꞌuc li joꞌone, lec ta jchabiic li buchꞌutic ta schꞌunic ti ta xcolic ta jventae. Xcojtaquinic, jech xiyojtaquinic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Xcojtaquin jbacutic jchiꞌuc li buchꞌutic chiyichꞌic ta muqꞌue jech chac cꞌu chaꞌal xcojtaquin jbacutic jchiꞌuc li Jtote. Xiyojtaquin li Jtote, jech xcojtaquin eꞌuc. Ta xcacꞌ jba ta milel ta scojic li buchꞌutic chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oy buchꞌutic maꞌuc jchiꞌiltactic ta israelal ta xlic schꞌunic ti joꞌon Yajcoltavanejicune. Persa ta xquicꞌan eꞌuc. Ta schꞌunic eꞌuc li cꞌusi ta xcale, jech jmojoxuc xa achiꞌuquic ti jayvoꞌ chachꞌunic ti joꞌon Avajcoltavanejicune. Jun noꞌox Avajchabivanejic acotolic, yuꞌun joꞌon ti Avajchabivanejicune. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Toj cꞌuxun ta yoꞌon li Jtote yuꞌun ta xcacꞌ jba ta milel ta scojic li buchꞌutic chiyichꞌic ta muqꞌue. Tsꞌacal to chichaꞌcuxi. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Muc buchꞌu xuꞌ chismil. Ta slequil coꞌon jtuc ti ta xcacꞌ jba ta milele. Xuꞌ ta xcacꞌ jba ta milel, xuꞌ chichaꞌcuxi nojtoc yuꞌun jech yalojbun li Jtote ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Li jchiꞌiltaque la svoqꞌuilan sbaic ta cꞌop ta sventa ti jech laj yal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Oy ep jech laj yalic: ―Ochem pucuj ta yoꞌon. Chjovi leꞌe. ¿Cꞌu chaꞌal lec xa chavaꞌibeic li cꞌusi ta xale? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oy yan jech laj yalic: ―Li buchꞌu ochem pucuj ta yoꞌone muc bu lec ta xcꞌopoj. Mu junuc pucuj xuꞌ ta sjambe sat li maꞌsatetique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te ta jteclum Jerusalene jaꞌ xa o qꞌuin yuꞌun li jchiꞌiltac ta israelale. Li qꞌuine jaꞌ sventa ta snaꞌic o ti cꞌu ora ichaꞌlic tunuc yuꞌun Dios nojtoc li mucꞌta chꞌulnae. Jaꞌ o yora sictic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Li Jesuse te chanav ta stentennail mucꞌta chꞌulna li yoꞌ bu Salomón sbie. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Li jꞌabteletic cuꞌuncutique te tal set sbaic li yoꞌ bu oy li Jesuse. Jech la sjacꞌbeic: ―¿Jayib to cꞌacꞌal liꞌ chavacꞌ xcꞌopoj coꞌoncutique? Mi joꞌot ti tꞌujbilot yuꞌun Dios ti chaventainuncutique, jamal xavalbuncutic ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Itacꞌav li Jesuse: ―Laj xa calboxuc pero mu xachꞌunic. La avilic nojtoc ti ep laj cacꞌ ta ilel jtsatsal juꞌel ta sventa li Jtote. Jech ta xvinaj o ti joꞌon Snichꞌonun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ti mu xachꞌunique, yuꞌun mu cuꞌunucoxuc jech chac cꞌu chaꞌal laj calboxuc onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Li buchꞌutic cuꞌune ta xaꞌiic li cꞌusi ta xcalbeique. Xcojtaquinic. Chiyichꞌic ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chcacꞌ xcuxiic o sbatel osil, jech mu xchꞌayic o sbatel osil. Muc buchꞌu xuꞌ chispojbe loqꞌuel ta jcꞌob. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yuꞌun jaꞌ yacꞌojbun ta jcꞌob li Jtot ti scotol xuꞌ yuꞌune. Muc buchꞌu xuꞌ ta spojbeic ta scꞌob li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Li joꞌone jununcutic jchiꞌuc li Jtote ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Li jꞌabteletique ba schaꞌtamic talel ton nojtoc yuꞌun chac smilic ta ton li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jech iꞌalbatic yuꞌun li Jesuse: ―Naca lec li cꞌustic laj cacꞌ avilic ta sventa li Jtote. ¿Cꞌusi ti chopol laj cacꞌ avilic ti chac amilicun ta tone? ―xꞌutatic yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Itacꞌavic li jꞌabteletic cuꞌuncutique: ―Maꞌuc ta sventa li cꞌusi lec la apas ti chacacꞌbecutic tone. Jaꞌ ta sventa ti chatoy aba ta stojol li Diose. Yuꞌun crixchanoot noꞌox pero chapꞌis aba ta Dios ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Itacꞌav li Jesuse: ―Jech tsꞌibabil ta scꞌop Dios li te avichꞌojique: “Li joꞌoxuque jqꞌuexoloxuc”, xꞌutatic yuꞌun Dios li jꞌabteletic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Jqꞌuexoloxuc”, xi scꞌoplalic li buchꞌutic iꞌacꞌbat yabtelic yuꞌun Dios ta voꞌonee. Mu xlaj scꞌoplal ti jech onoꞌox yaloj ta scꞌop li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Toj lec ti jech iꞌalbatique”, xachiic. Lec ti jech chavalique. Pero ¿cꞌu chaꞌal chavalbecun ti ta jtoy jba ta stojol Dios ti laj cal ti joꞌon Snichꞌonun li Diose? Yuꞌun jech acꞌbil cabtel yuꞌun li Jtot ti lital liꞌ ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mi maꞌuc yabtel Jtot ta jpas chavilique, mu me xachꞌunic ti joꞌon Snichꞌonune. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Acꞌo mi mu xachꞌunic ti joꞌon Snichꞌonune, pero chꞌunic me ta sventa li cꞌusi ta jpase yuꞌun jaꞌ yabtel Jtot ti ta jpase. Jech chanaꞌic o ti jununcutic jchiꞌuc li Jtote ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Li jꞌabteletic cuꞌuncutique chac stsaquic nojtoc li Jesuse. Pero muc bu stsaquic yuꞌun la svocꞌ sba batel ta ora li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Li Jesuse ichaꞌbat nojtoc ta jot ucꞌum Jordán li yoꞌ bu laj yacꞌ ta ichꞌel joꞌ li Juane. Te lijbatcutic eꞌuc. Te lijocꞌtsajcutic jayib cꞌacꞌal schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cꞌalal te oyuncutique, ep jchiꞌiltac ta israelal italic ta stojol li Jesuse. Jech laj yalic: ―Acꞌo mi muc bu xacꞌ ta ilel stsatsal sjuꞌel Dios li Juan li iyacꞌ ta ichꞌel joꞌe, pero jaꞌ melel li cꞌusi laj yal ta sventa li jchiꞌiltic liꞌi ―xiic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Li buchꞌutic italique oy ep la schꞌunic ti jaꞌ Yajcoltavanejic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oy jun jchiꞌilcutic ta israelal, Lázaro sbi. Itsaque ta chamel. Te nacal ta jteclum Betania li te ta Judea balumile. Jaꞌ te nacalic eꞌuc li chaꞌvoꞌ antsetic María schiꞌuc Marta li smuc svix sbaique. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Li Maríae jaꞌ li tsꞌacal to la smalbe muil vomol ta yoc li Cajvaltique schiꞌuc ti la scusbe yoc ta stsotsil sjole. Jaꞌ yixlel li Lázaroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Li yixleltac Lázaroe la staquic ta iqꞌuel li Jesuse: ―Cajval, ip li Lázaroe, jaꞌ li toj cꞌux ta avoꞌone ―xi cꞌotel li buchꞌu la staquic batele. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cꞌalal iyaꞌi li Jesuse, jech laj yal: ―Li schamele mu xcham o. Jaꞌ noꞌox ta sventa acꞌo ichꞌeuc ta mucꞌ li Diose, schiꞌuc acꞌo xiꞌichꞌe ta mucꞌ eꞌuc, joꞌon li Snichꞌonun li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Li Jesuse, acꞌo mi cꞌux ta yoꞌon li Martae, schiꞌuc li smuque, schiꞌuc li Lázaroe, cꞌalal iyaꞌi ti ip li Lázaroe, chib to cꞌacꞌal te lijocꞌtsajcutic li yoꞌ bu oyuncutic onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tsꞌacal to jech laj yalbuncutic li Jesuse, joꞌoncutic li yajchanbalajeltacuncutique: ―Sutcutic batel nojtoc li ta Judeae ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jech laj calbecutic: ―Jchanubtasvanej, achꞌ to te chac smilicot ta ton li jchiꞌiltactique. ¿Mi chacꞌan chachaꞌsut batel tey? ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Itacꞌav li Jesuse: ―Li Diose lajchaeb ora yacꞌoj li ta jujun cꞌacꞌale yoꞌ jech xuꞌ chijꞌabtej. Jaꞌ noꞌox jechun eꞌuc li joꞌone, yora to xuꞌ chiꞌabtej. Jech chac cꞌu chaꞌal li buchꞌu ta xanav ta cꞌacꞌaltique mu spꞌosi yoc yuꞌun sac to li osile. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yan mi iꞌicꞌub xa li osile, ta spꞌosi yoc yuꞌun mu xa xil sbe. Jech li joꞌone, jaꞌ to mi icꞌot scꞌacꞌalil yuꞌun Dios ti chimilee, jaꞌ to xuꞌ chismilic li jchiꞌiltactique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jech laj yal nojtoc li Jesuse: ―Li Lázaro ti lec jcꞌopon jbatic jchiꞌuctique vayal xa, pero chba jtij acꞌo julavuc ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jech laj calbecutic, joꞌoncutic li yajchanbalajeltacuncutique: ―Cajval, mi iꞌoch xa svayele, jaꞌ svinajeb ti ta smeltsaje ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ti jech laj yal li Jesuse yuꞌun chamem xa li Lázaroe. Joꞌoncutic li yajchanbalajeltacuncutique la jnopcutic ti yuꞌun noꞌox ta xvaye. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Li Jesuse jamal laj yalbuncutic ti chamem xa li Lázaroe. Jech laj yal nojtoc: ");
INSERT INTO tzoSA_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","―Ximuybaj noꞌox ti muc bu te oyun li cꞌalal ichame yoꞌ jech chachꞌunic o ti joꞌon Avajcoltavanejicune. Batic, ba jqꞌueltic ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Li jun jchiꞌilcutic ta yajchanbalajeltac li Jesuse, jaꞌ li Tomase, jaꞌ li vach xcutcutique, jech laj yalbuncutic: ―Batic, coꞌol acꞌo chamcutic jchiꞌuctic li Cajchanubtasvanejtique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","La jchiꞌincutic batel li Jesuse. Cꞌalal lijcꞌotcutique, oy xaꞌox schanibal cꞌacꞌal smucojic li Lázaroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Li Betaniae nopol xil sbaic schiꞌuc li Jerusalene. Oy noꞌox nan oꞌloluc reva xil sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Oy ep jchiꞌiltac talemic ta spatbeic yoꞌonic li Martae schiꞌuc li Maríae ta scoj ti icham li sbanquilique. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Li Martae, cꞌalal iyaꞌi ti chtal li Jesuse, ta ora ba snup ta be. Li Maríae te icom ta snaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Li Martae jech iyalbe li Jesuse: ―Cajval, ti liꞌuc oyot cꞌalal itsaque ta chamel li jbanquile, muc bu xcham ti jechuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero manchuc mi oy xa scꞌacꞌalil ti ichame, jnaꞌoj onoꞌox ti scotol li cꞌusi chacꞌanbe li Diose chayacꞌbe ―xi li Martae. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Li Jesuse jech laj yalbe: ―Ta xchaꞌcuxi loqꞌuel ta smuquenal la abanquile ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Itacꞌav li Martae: ―Jnaꞌoj onoꞌox ti ta xchaꞌcuxi loqꞌuel ta smuquenal ta slajeb cꞌacꞌal li cꞌalal ta xchaꞌcuxiic scotol li buchꞌutic chamemique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Li Jesuse jech laj yal: ―Oy chaꞌcuxesel schiꞌuc oy cuxlejal sbatel osil ta jventa jtuc. Li buchꞌutic ta schꞌunic ti joꞌon ta jcoltaique, acꞌo mi ta xchamic, pero ta xcuxiic sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Scotol buchꞌutic ta xcuxiic sbatel osile, jaꞌ li buchꞌutic schꞌunojic ti joꞌon ta jcoltaique, ilaj scꞌoplal ti ta xchꞌayic o sbatel osile. ¿Mi achꞌunoj jech? ―xꞌutat yuꞌun Jesús li Martae. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Itacꞌav li Martae: ―Jchꞌunoj, Cajval. Jchꞌunoj ti joꞌot Cristoote, ti joꞌot Snichꞌonot li Diose, ti joꞌot tꞌujbilot yuꞌun Dios chacoltauncutic yuꞌun li jmulcutique ―xi li Martae. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cꞌalal laj yal jech li Martae, ba yicꞌ talel ta ora li smuque, jaꞌ li Maríae. Ta mucul laj yalbe: ―Ital xa li Jchanubtasvaneje, ta la xastac ta iqꞌuel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Cꞌalal iyaꞌi li Maríae, ta ora ilocꞌ batel yuꞌun ba scꞌopon li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pero muc toꞌox bu cꞌotemuncutic ta Betania schiꞌuc li Jesuse. Te toꞌox oyuncutic li yoꞌ bu lijcomcutic yuꞌun li Martae. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Li jchiꞌiltac li te oyic ta na schiꞌuc li Maríae, jaꞌ li jpat‐oꞌonetique, cꞌalal iyilic ti ilocꞌ batel ta anil li Maríae, ibatic eꞌuc. Jech laj yalic: ―Yuꞌun chba ocꞌuc ta smuquenal li sbanquile ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Cꞌalal icꞌot li María li yoꞌ bu oyuncutic schiꞌuc li Jesuse, iyil ti te vaꞌal li Jesuse, ba spatan sba ta balumil ta stojol. Jech laj yalbe: ―Cajval, ti liꞌuc oyot li cꞌalal itsaque ta chamel li jbanquile, muc bu xcham ti jechuque ―xi li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Cꞌalal iyil Jesús ti ta xꞌocꞌ li Maríae schiꞌuc ta xꞌoqꞌuic eꞌuc li jchiꞌiltac li te schiꞌuc talele, chopol iyil Jesús ti jech oy at‐oꞌon liꞌ ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jech la sjacꞌbe: ―¿Bu la amuquic? ―xut. Itacꞌavic: ―Taje. Ba jqꞌueltic avil ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iꞌocꞌ eꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Li jchiꞌiltaque jech laj yalbe sbaic: ―Qꞌuelavilic, toj cꞌux ta yoꞌon li Lázaroe ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Oy buchꞌutic jech laj yalic: ―Li vinic liꞌi xuꞌ ta sjambe sat li buchꞌutic maꞌsatetique. ¿Cꞌu chaꞌal jaꞌ muc scolta li Lázaroe? Ti lajuc scoltae, muc bu xcham ti jechuque ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Cꞌalal lijcꞌotcutic ta smuquenal li Lázaroe, li Jesuse chopol iyaꞌi nojtoc ti jech oy at‐oꞌon liꞌ ta balumile. Li smuquenal li Lázaroe jaꞌ jombil ton. Li smac stiꞌe jaꞌ jun mucꞌta pechpech ton. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Li Jesuse jech laj yal: ―Tselelinic loqꞌuel li tone ―xi. Itacꞌav li yixlel Lázaroe, jaꞌ li Martae: ―Cajval, tu xa yuꞌun oy xa ta chanib cꞌacꞌal la jmuccutic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Li Jesuse jech laj yalbe: ―Laj xa calbot ti mi chachꞌun ti joꞌon Jcoltavanejune jech chavil o li cꞌu sba li stsatsal sjuꞌel li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","La stselelinic loqꞌuel li ton li smacojbeic o stiꞌ li smuquenal li Lázaroe. Li Jesuse la sqꞌuel muyel ta vinajel, la sta ta naꞌel Dios: ―Tata, colaval ti chavaꞌibun li jcꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jnaꞌoj ti scotol cꞌacꞌal chavaꞌibun li jcꞌope. Jech chacalbe yoꞌ acꞌo yaꞌiic eꞌuc li buchꞌutic liꞌ nopol vaꞌalique yoꞌ ta schꞌunic o ti joꞌot la atacun talele ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cꞌalal laj yal jeche, tsots iyapta li ánimae: ―¡Lázaro, locꞌan talel! ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jliquel ichaꞌcuxi loqꞌuel yuꞌun. Sutꞌul ta pocꞌ ilocꞌ talel. Li sjole chucul ta panyo. Li Jesuse jech laj yalbe li crixchanoetique: ―Jilchꞌunbeic li spixe, acꞌo batuc ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Li jchiꞌiltac li schiꞌuquic talel li Maríae, ep buchꞌutic la schꞌunic ti jaꞌ Jcoltavanej li Jesuse li cꞌalal iyilic ti la schaꞌcuxes li ánimae. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero oy jayvoꞌ ba yalbeic li jfariseoetic ti la schaꞌcuxes Lázaro li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Li banquilal paleetique schiꞌuc li jfariseoetique la stsobic li schiꞌilic ta abtele. Jech laj yalic: ―¿Cꞌusi ta jpasbetic li vinic taje? Yuꞌun ep ta xacꞌ ta ilel stsatsal sjuꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Te acꞌo spas jech”, mi xijchie, chlic schꞌunic scotol li jchiꞌiltactic ti jaꞌ tꞌujbil yuꞌun Dios ti chisventainutique. Ta stiqꞌuic ta ajvalilal jech ta soc sjol li mucꞌta ajvalil li te ta Romae. Ta stac talel yajsoltarotac. Chtal sjinesic li mucꞌta chꞌulna cuꞌuntique schiꞌuc li jteclumaltique, jech chijpuc batel jcotoltic ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Te oy jun schiꞌilic ta abtel, Caifás sbi. Jaꞌ o ochem ta más banquilal pale li Caifase. Jech laj yal: ―Li joꞌoxuque mu xanaꞌic snopel. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jaꞌ lec mi jun noꞌox jchiꞌiltic ta xchame, jaꞌ chopol mi chijchamutic jcotoltique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero mu ta sventauc stuc ti jech laj yale. Yuꞌun jaꞌ o ochem ta más banquilal pale, jech ichꞌamunbat ye yuꞌun Dios ta sventa acꞌo yal ti jaꞌ jqꞌuexol jcotolcutic li jꞌisraeluncutic li cꞌalal mi ta xcham ta jcojcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero li Jesuse maꞌuc noꞌox snopoj ti ta xcham ta jcojcutic, joꞌoncutic li jꞌisraeluncutique. Jaꞌ ta xcham ta sventa scotol li buchꞌutic ta xichꞌic ta mucꞌ Dios li butic noꞌox oyic ta spꞌejel li balumile, yoꞌ jech jmojutic xa jcotoltic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Cꞌalal jech laj yal li Caifase, li jꞌabteletic cuꞌuncutique lic snopic ta ora cꞌu sba xuꞌ ta smilic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Li Jesuse muc xa bu xacꞌ sba ta ilel ta stojol scotol li jchiꞌiltac ta israelale. Ibat ta yan o balumil li Jesuse. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. Li bu lijbatcutique jaꞌ nopol xil sba schiꞌuc li taqui jamaltique. Te lijcꞌotcutic ta jteclum Efraín. Te lijocꞌtsajcutic schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Poꞌot xaꞌox li qꞌuin Coltael cuꞌuncutique. Ep jchiꞌiltac baꞌi ibatic ta Jerusalén, ba yacꞌbeic smoton Dios yoꞌ ta xꞌacꞌbatic perton yuꞌun li smulique, yoꞌ jech xuꞌ ta slajesic li chij sventa li qꞌuin Coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Cꞌalal icꞌotic ta Jerusalén li jchiꞌiltaque, te lic saꞌic Jesús yuꞌun chac yojtaquinic. Scotol buchꞌutic te xa oyic ta yamaqꞌuil li mucꞌta chꞌulnae, jech lic sjacꞌulanbe sbaic: ―¿Cꞌusi chanop? ¿Mi ta xtal ta qꞌuin xanaꞌ li Jesuse yuꞌun yaꞌioj ti ta xichꞌ tsaquele? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ti jech laj yalbe sbaique, yuꞌun yaloj xaꞌox mantal li banquilal paleetique schiꞌuc li jfariseoetique ti acꞌo yalic mi oy buchꞌutic iyilic bu oy li Jesuse yoꞌ acꞌo ba yichꞌ tsaquel. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vaquib xaꞌox cꞌacꞌal scꞌan li qꞌuin Coltaele, jaꞌ o ichaꞌbat Jesús li ta jteclum Betaniae. Jaꞌ te li yoꞌ bu nacal li Lázaro ti ichaꞌcuxesat loqꞌuel ta smuquenal yuꞌun li Jesuse. Jchiꞌucutic batel, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Li Lázaro schiꞌuc li yixleltaque laj yicꞌuncutic ta veꞌel schiꞌuc li Jesuse. Ti jech la spasique, yuꞌun jaꞌ chichꞌic ta mucꞌ li Jesuse. Jaꞌ imacꞌlanvan li Martae. Li Lázaroe te la schiꞌinuncutic ta veꞌel ta mexa. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Li Maríae laj yichꞌ talel oꞌlol kilo muil vomol, nardo sbi. Toj toyol stojol li nardoe. Te tal smalbe ta yoc li Jesuse. Cꞌalal la smalbee, la scusbe ta stsotsil sjol. Li smuil li vomole ipuc ta spꞌejel yut na. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te oy eꞌuc li jun jchiꞌilcutic ta yajchanbalajeltac li Jesuse, jaꞌ li Judas Iscariote ti ta tsꞌacal iyacꞌ ta cꞌabal li Jesuse. Jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Cꞌu chaꞌal muc bu schon ta oxib ciento denario taqꞌuin li muil vomol liꞌi? Li stojole xuꞌ jaꞌ ta xꞌacꞌbatic li meꞌonetique ―xi li Judase. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ti jech laj yal li Judase, maꞌuc ta scꞌuxubin li meꞌonetique. Jaꞌ ta scꞌan ta xelcꞌan stuc yuꞌun jaꞌ schabioj li yav jtaqꞌuincutique. Te onoꞌox ta xelcꞌan jutuc li jtaqꞌuincutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Li Jesuse jech laj yalbe li Judase: ―Mu me xaval jech. Li muil vomol li liꞌ toꞌox snacꞌoje jaꞌ sventa li cꞌalal chimuquee. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Li meꞌonetique scotol cꞌacꞌal liꞌ achiꞌuquic onoꞌoxe. Li joꞌone mu scotoluc cꞌacꞌal liꞌ jchiꞌucoxuque ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Li jchiꞌiltac li te xa tsobolic ta Jerusalene iyaꞌiic ti te xa lijchaꞌcꞌotcutic ta Betania schiꞌuc li Jesuse. Italic ta ora. Pero maꞌuc noꞌox tal sqꞌuelic li Jesuse, jaꞌ tal sqꞌuelic eꞌuc li Lázaroe, jaꞌ li ichaꞌcuxesat loqꞌuel ta smuquenal yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jaꞌ yuꞌun li banquilal paleetique la snopic ti ta smilic eꞌuc li Lázaroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yuꞌun jaꞌ ta sventa ti ep xa jchiꞌiltac laj yictaic li paleetique yuꞌun ischꞌunic xa ti jaꞌ Jcoltavanej li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ta yocꞌomal te tsobolic ta Jerusalén scotol li jchiꞌiltac ta israelale yuꞌun jaꞌ xa o qꞌuin. Iyaꞌiic ti te ta xbat ta Jerusalén li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jech scotolic la saꞌic talel yanal xan, iloqꞌuic talel ta jteclum. Sbichojic talel li yanal xane tal snupic ta be li Jesuse. Tsots icꞌopojic talel, jech laj yalic: ―¡Coliyal Dios toj lec li buchꞌu la stacbutic talele! Jaꞌ ta xꞌoch ta ajvalilal cuꞌuntic, joꞌotic li jꞌisraelutique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Li Jesuse ista jcot burro. Jaꞌ la scajlebin jech chac cꞌu chaꞌal tsꞌibabil onoꞌox comel scꞌoplal ta scꞌop Diose: ");
INSERT INTO tzoSA_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Joꞌoxuc li jꞌisraeloxuque, mu me xavat avoꞌonic. Chtal li ajvalil avuꞌunique. Cajal ta burro chtal, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Joꞌoncutic li yajchanbalajeltacuncutique muc bu xcaꞌibecutic smelol li cꞌalal jech cajal ta burro iꞌoch ta Jerusalén li Jesuse. Jaꞌ to cꞌalal imuy batel ta vinajel li Jesuse, jaꞌ to ijul ta jolcutic ti jech onoꞌox tsꞌibabil comel scꞌoplal ti jech ta xꞌichꞌe ta mucꞌ yuꞌun li jchiꞌiltaque. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Ti tal nupvanicuc ta be li jchiꞌiltaque, yuꞌun iyaꞌiic ti la schaꞌcuxes Lázaro li Jesuse. Jaꞌ iꞌalbatic yuꞌun li buchꞌutic te schiꞌuquic Jesús li cꞌalal la schaꞌcuxes loqꞌuel ta smuquenal li Lázaroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Li jfariseoetique jech laj yalbe sbaic: ―Qꞌuelavilic, mu xuꞌ ta jpajestic li jchiꞌiltactique yuꞌun ep buchꞌutic lec chilic li Jesuse ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oy jayvoꞌ jgreciaetic te ta xcꞌotilanic ta qꞌuin eꞌuc yuꞌun jaꞌ jech schꞌunojic jech chac cꞌu chaꞌal schꞌunojic li jchiꞌiltac ta israelale. Te tal yacꞌbeic smoton Dios ta qꞌuin eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","La scꞌoponic li Felipee, jaꞌ li jchiꞌilcutic ta yajchanbalajeltac li Jesuse. Jaꞌ te liquem talel ta Galilea balumil li te ta jteclum Betsaidae. Jech laj yalbeic: ―Tata, chac jcꞌoponcutic li Jesuse ―xutic li Felipee. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Li Felipee ba yalbe eꞌuc li Andrese. Ibat schaꞌvaꞌalic, ba yalbeic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jech iꞌalbatic yuꞌun li Jesuse: ―Ista xa scꞌacꞌalil ta xvinaj ti acꞌbil cabtel ta sventa scotol crixchanoetic, joꞌon li coꞌol crixchanoutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Melel li cꞌusi chacalbeique, persa chimile, jaꞌ jech ep buchꞌutic ta xꞌacꞌbat scuxlejalic ta sventa sbatel osil. Jaꞌ jech chac cꞌu chaꞌal jpꞌej becꞌ trigo, mi muc bu ta xichꞌ muquel leque, stuc o. Yan mi ta xichꞌ muquel leque, ep ta xlic satinuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jaꞌ noꞌox jech li buchꞌu cꞌux chaꞌi li scuxlejal liꞌ ta balumile, ti mu scꞌan xcham ta jventa joꞌone, jaꞌ ta xchꞌay o sbatel osil. Yan li buchꞌu mu xichꞌ ta cꞌux li scuxlejal liꞌ ta balumile, ti mu sventauc mi te ta xcham ta jventa joꞌone, jaꞌ ta xcuxi o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Scotol buchꞌutic ta scꞌan ta xtunic cuꞌune, acꞌo cuchuc yuꞌun li vocole jech chac cꞌu chaꞌal ta xcuch cuꞌune. Te chcꞌot schiꞌinicun o ta naclej ta vinajel. Li buchꞌutic ta xtunic cuꞌune jaꞌ ta xꞌaqꞌueic ta ichꞌel ta mucꞌ yuꞌun li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Acꞌo mi mu jcꞌan xicham, pero mu jechuc ta xcalbe li Diose: “Tata, coltaun, mu me xicham”, mu xichi ta stojol. Ti lital liꞌ ta balumile, jaꞌ sventa chicham ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jech lic scꞌopon Dios li Jesuse: ―Tata, acꞌo xaꞌichꞌe ta mucꞌ ta jventa ―xi. Iꞌaꞌibat scꞌop yuꞌun li Diose, jech icꞌopoj talel ta vinajel: ―Ichꞌbilun xa ta mucꞌ ta aventa. Pero más to ta xquichꞌ ichꞌel ta mucꞌ ta aventa ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Li crixchanoetic li te oyique iyaꞌiic ti oy cꞌusi tsots inic ta vinajele. Oy buchꞌutic jech laj yalic: ―Ta xꞌavan chauc ―xiic. Oy yan jech laj yalic: ―Jaꞌ icꞌoponat yuꞌun jun yajꞌangel Dios ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Li Jesuse jech laj yal: ―Ti jech tsots liscꞌopon li Jtote, maꞌuc sventa ti acꞌo jnaꞌ ti laj yaꞌibun li jcꞌope. Jaꞌ sventa ti acꞌo xanaꞌic li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ista xa scꞌacꞌalil ti ta xvinaj ti oy smulic li buchꞌutic mu scꞌan xiyichꞌic ta muqꞌue. Icꞌot xa scꞌacꞌalil ti ta jchꞌaybe stsatsal li yabtel li pucuj ti jaꞌ sventainoj scotol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ti chicham ta cruze, yoꞌ jech ta xquicꞌan scotol li buchꞌutic tscꞌan chiyichꞌic ta mucꞌ ta spꞌejel li balumile ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jech laj yacꞌbun jnaꞌcutic ti ta cruz ta xmilee. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Itacꞌav li jchiꞌiltaque: ―Caꞌiojbecutic onoꞌox scꞌoplal li buchꞌu tꞌujbil yuꞌun Dios ti chtal sventainutique. Tsꞌibabil comel ta scꞌop Dios ti cuxul o sbatel osile. Mi joꞌot chaventainuncutique, ¿cꞌu chaꞌal jech chaval: “Persa chicham ta cruz, joꞌon li coꞌol crixchanoutique”, ti xachie? ¿Buchꞌuot chaꞌa? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Itacꞌav li Jesuse: ―Mu xa epuc cꞌacꞌal liꞌ chajchanubtasoxuque. Jaꞌ lec ichꞌic ta mucꞌ li cꞌusi ta xcale yuꞌun yorail to chavichꞌic ta mucꞌ. Jaꞌ jech chacolic o sbatel osil. Jech chac cꞌu chaꞌal li buchꞌu ta xanav ta bee, mi jliquel xa noꞌox sac li osile, ta xacꞌbe yipal yoꞌ jech mu xꞌicꞌub osil ta be yuꞌun. Yuꞌun mi iꞌicꞌube, mu xa xil osil, mu xa snaꞌ bu ta xbat. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jaꞌ noꞌox jechoxuc eꞌuc li joꞌoxuque, yoꞌ to liꞌ jchiꞌucoxuque, chꞌunic ti joꞌon tꞌujbilun yuꞌun Dios sventa chajcoltaique, jech snichꞌnaboxuc xa Dios ―xi li Jesuse. Cꞌalal laj yal jech li Jesuse, la svocꞌ sba batel. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Altic ti ep laj yacꞌ ta ilel stsatsal sjuꞌel ta stojolic li jchiꞌiltac ta israelale, yuꞌun muc bu schꞌunic ti jaꞌ tꞌujbil yuꞌun Dios sventa Cajcoltavanejtique. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yuꞌun jaꞌ icꞌot ta pasel li cꞌusi la stsꞌiba li Isaías li iyal scꞌop Dios ta voꞌonee. Jech la stsꞌiba: Acꞌo mi ep chacꞌ ta ilel stsatsal sjuꞌel, pero li jchiꞌiltactique mu schꞌunic ti jaꞌ acꞌbil yabtel yuꞌun Dios ti jaꞌ Cajcoltavanejtique, xi onoꞌox laj yal li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mu xuꞌ schꞌunic li jchiꞌiltaque yuꞌun jaꞌ icꞌot ta pasel li cꞌusi la stsꞌiba nojtoc li Isaíase: ");
INSERT INTO tzoSA_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ta jmacbe satic, ta jtsatsubtasbe yoꞌonic yoꞌ jech mu xilic, jech mu xcꞌot ta yoꞌonic. Yuꞌun mu onoꞌox scꞌan xictaic li cꞌustic chopol tspasique, jech mu xcolic o cuꞌun, xi li Diose, jech iyal onoꞌox li Isaíase. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ti jech laj yal li Isaías ti ep ta xacꞌ ta ilel stsatsal sjuꞌele, yuꞌun iꞌacꞌbat xa yil ti oy sjuꞌel li buchꞌu tꞌujbil yuꞌun Dios ti chventainvane. Jaꞌ yuꞌun jech iyalbe scꞌoplal. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Acꞌo mi ep li jchiꞌiltac ti muc bu la schꞌunique, pero oy jꞌoꞌlol la schꞌunic ti jaꞌ tꞌujbil yuꞌun Dios li Jesuse. Schiꞌuc oy jayvoꞌ li jꞌabteletique la schꞌunic eꞌuc. Pero muc bu iyalic ta jamal ti schꞌunojique naca me mu xꞌaqꞌueic ochicuc li ta schꞌulnaique. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Li jꞌabteletique más la scꞌanic ti lec ta xꞌileic yuꞌun li crixchanoetique. Jaꞌ mu másuc la scꞌanic ti lec acꞌo ileicuc yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Li Jesuse la scꞌopon nojtoc li jchiꞌiltaque. Tsots icꞌopoj, jech laj yalbe: ―Scotol buchꞌutic ta schꞌunic ti joꞌon ta jcoltaique, jaꞌ schꞌunojic ti ta xcoltaatic yuꞌun li Jtote yuꞌun jaꞌ listac talel. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Scotol buchꞌutic liyojtaquinic xae, ojtaquinbil xa li Jtote, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Li joꞌone xojobal cꞌocꞌun avuꞌunic yaꞌel, joꞌoxuc li liꞌ to oyoxuc ta balumile. Scotol buchꞌutic ta schꞌunic ti joꞌon Yajcoltavanejicune, ta xpꞌijubic, jaꞌ ta xojtaquinic o li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Li buchꞌutic laj yaꞌibecun xa li jcꞌope, mi mu schꞌunic ti joꞌon Yajcoltavanejicune, muc to bu ta xquichꞌbe scꞌopic. Yuꞌun maꞌuc tal quichꞌbe scꞌopic li crixchanoetique; jaꞌ noꞌox tal jcoltaanic. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Li buchꞌutic mu schꞌunic ti joꞌon Yajcoltavanejicune, ta xcꞌot scꞌacꞌalil ta xꞌichꞌbat scꞌopic ta slajeb cꞌacꞌal. Jaꞌ ta xꞌichꞌbat o scꞌopic ti muc bu la schꞌunic li cꞌusi laj cale, jech ta xichꞌic o vocol. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mu jtucuc noꞌox ta jnop li cꞌusi ta xcale. Jaꞌ laj yalbun li Jtote, jaꞌ ti listac talele. Jaꞌ laj yalbun li cꞌusi ta xcale schiꞌuc li cꞌu sba chitacꞌave. ");
INSERT INTO tzoSA_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jaꞌ smantal Jtot ti chacuxiic o sbatel osile. Li cꞌusi ta xcale jaꞌ scꞌop li Jtote. Jaꞌ noꞌox ta xcal li cꞌusi yalojbune ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cꞌalal ta xa xlic li qꞌuin Coltaele, snaꞌoj onoꞌox Jesús ti jaꞌ xa scꞌacꞌalil ta xicta li balumile yuꞌun ta xa sut batel ta stojol li Stote. Li Jesuse toj cꞌuxuncutic ta yoꞌon onoꞌox, joꞌoncutic li yajchanbalajeltacuncutique. Pero más to liyacꞌbe quilcutic ti toj cꞌuxuncutic ta yoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Te tsoboluncutic ta veꞌel schiꞌuc li Jesuse. Li Judase, jaꞌ li snichꞌon Simón Iscariotee, acꞌbil xa onoꞌox ta yoꞌon yuꞌun li banquilal pucuj ti jaꞌ ta xacꞌ ta cꞌabal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Li Jesuse snaꞌoj onoꞌox ti jaꞌ acꞌbil sventain scotol yuꞌun li Jtotic Diose. Snaꞌoj onoꞌox ti jaꞌ itaque talel yuꞌun li Jtotic Diose, snaꞌoj onoꞌox nojtoc ti ta xꞌiqꞌue sutel ta stojole. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Acꞌo mi ta stojol Dios liquem talel li Jesuse pero la sbicꞌtajes sba eꞌuc. La spas jech chac cꞌu chaꞌal jtunel. Ivaꞌi, la slocꞌ spuychij schiꞌuc scꞌuꞌ, la schuc schꞌut ta cusobbail sventa atimol. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","La sqꞌueb joꞌ ta pocob‐cꞌabal, la spocbun coccutic, joꞌoncutic li yajchanbalajeltacuncutique. Cꞌalal la spocbuncutique, la scusbuncutic li ta cusobbail sventa atimol ti schucoj ta schꞌute. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cꞌalal ta xa spocbe yoc li Simón Pedroe, li Pedroe jech laj yalbe li Jesuse: ―Cajval, mu jechuc o smelol ti joꞌot chapocbun coque ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Itacꞌav li Jesuse: ―Li cꞌusi ta jpase mu xavaꞌibe smelol ta ora. Tsꞌacal to chavaꞌi ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Li Pedroe jech laj yal: ―Li joꞌone mu xcacꞌ ti chapocbun li coque ―xut. Itacꞌav li Jesuse: ―Mi muc bu chajpoque, mu xuꞌ chba achiꞌinun ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Itacꞌav li Simón Pedroe: ―Cajval, maꞌuc noꞌox xapocbun li coque. Pocbun eꞌuc li jcꞌobe, tsebeltasun nojtoc ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Li Jesuse jech laj yalbe: ―Li buchꞌu atinem xae mu xa persauc ta xichꞌ poquel sjunul. Xuꞌ ti yoc noꞌox ta xpocbate yuꞌun atinem xa onoꞌox. Li joꞌoxuque pocbil xa la avoꞌonique pero mu acotolicuc ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Snaꞌoj onoꞌox li Jesuse ti jaꞌ ta xꞌacꞌvan ta cꞌabal li Judase. Jaꞌ yuꞌun ti laj yalbuncutic ti mu jcotolcuticuc pocbil coꞌoncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cꞌalal la spocbun coc jcotolcutique, la schaꞌlap nojtoc li scꞌuꞌe schiꞌuc li spuychije. Ichaꞌchoti ta mexa. Jech la sjacꞌbuncutic: ―¿Mi xanaꞌic cꞌu chaꞌal ti la jpocboxuc avoquique? ");
INSERT INTO tzoSA_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Li joꞌoxuque jech chavalbecun: “Jchanubtasvanej, Cajval”, xavuticun. Lec ti jech chavalbecune yuꞌun melel ti joꞌon Avajvalicune. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Acꞌo mi joꞌon Avajvalicun, acꞌo mi joꞌon Avajchanubtasvanejicun, pero la jpocboxuc avoquic. Jech me xapasbe abaic eꞌuc li joꞌoxuque. Mu me xatoy abaic, coltao me abaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ti jech laj cacꞌboxuc avilique, yuꞌun ta jcꞌan ti jech chapasic eꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Melel li cꞌusi chacalbeique, li buchꞌu jtunel noꞌoxe muc bu tsots yabtel yichꞌoj. Jaꞌ tsots yabtel yichꞌoj li yajvale. Li buchꞌu ta mantal noꞌox oye muc bu tsots yabtel yichꞌoj. Jaꞌ tsots yabtel yichꞌoj li buchꞌu ta spasvan ta mantale. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","La avaꞌiic xa. Mi jech chapasulanique, xamuybajic noꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mu acotolicuc ti jech chacalbeique. Xacojtaquinic, joꞌoxuc ti tꞌujbiloxuc cuꞌun sventa chavalbecun batel li jcꞌope. Oy jun li joꞌoxuc ti la jtꞌujoxuque, jaꞌ noꞌox la jtꞌuj ta sventa acꞌo cꞌotuc ta pasel jech chac cꞌu chaꞌal tsꞌibabil onoꞌox comel jcꞌoplal ta scꞌop li Diose: “Li buchꞌu coꞌol chiveꞌ jchiꞌuque jaꞌ chiscontrain”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jaꞌ yoꞌ xanaꞌic oe baꞌi laj calboxuc. Jech cꞌalal ta xcꞌot ta pasele jaꞌ chachꞌunic o ti joꞌon Avajcoltavanejicune. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Melel li cꞌusi chacalbeique, li buchꞌutic chichꞌic ta mucꞌ li jcꞌop ti chavalic, joꞌoxuc ti chajtaquic batele, joꞌon chiyichꞌic ta mucꞌ. Mi chiyichꞌic ta muqꞌue, jaꞌ ta xꞌichꞌe o ta mucꞌ li Jtot yaꞌele, jaꞌ ti listac talele ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cꞌalal laj yalbuncutic jech li Jesuse, vocol isjamalꞌalbuncutic ti buchꞌu ta xꞌacꞌvan ta cꞌabale yuꞌun chat tajmec yoꞌon. Jech laj yalbuncutic: ―Melel li cꞌusi chacalbeique, oy junoxuc li joꞌoxuque ti jaꞌ chiyacꞌ ta cꞌabale ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Joꞌoncutic li yajchanbalajeltacuncutique la jqꞌuelbe jba jsatcutic. Mu jnaꞌcutic buchꞌu junucal cuꞌuncutic ti jech scꞌoplale. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Joꞌon ti toj cꞌuxun ta yoꞌon li Jesuse, te chotolun ta xocon te ta mexa. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Li Simón Pedroe laj yacꞌbun quil ta scꞌob ti acꞌo jacꞌbe Jesús buchꞌu junucal ti jech scꞌoplale. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yuꞌun te nopol oyun ta xocon li Jesuse, jech la jacꞌbe: ―Cajval, ¿buchꞌu junucal cuꞌuncutic? ―xcut. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Itacꞌav li Jesuse: ―Jaꞌ li buchꞌu ta xcacꞌbe tsꞌajbil pan sveꞌe ―xiyut. Lic stsꞌaj jsetꞌ li pane, jaꞌ laj yacꞌbe li Judase, jaꞌ snichꞌon li Simón Iscariotee. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cꞌalal la stsac li pan li Judase, iventainbat o yoꞌon ta ora yuꞌun li banquilal pucuje, jaꞌ li Satanase. Li Jesuse jech laj yalbe li Judase: ―Li cꞌusi anopoj chapase, ba paso ta ora ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ti jayvoꞌ te oyuncutic ta mexae, mu junuc buchꞌu ijul ta sjol cuꞌuncutic ti cꞌu chaꞌal jech laj yalbee. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yuꞌun jaꞌ schabioj yav jtaqꞌuincutic li Judase, la jnopcutic ti albil xa onoꞌox yuꞌun Jesús ti acꞌo xba sman talel li cꞌusi ta xtun cuꞌuncutic ta sventa li qꞌuine. Oy la jnopcutic ti albil xa onoꞌox yuꞌun Jesús ti oy cꞌusi acꞌo xba yacꞌbe li meꞌonetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cꞌalal la sveꞌ pan li Judase, ilocꞌ batel ta ora. Acꞌubal xaꞌox cꞌalal ilocꞌ batele. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Cꞌalal loqꞌuem xaꞌox batel li Judase, jech lic yalbuncutic li Jesuse: ―Ista xa yora chiꞌaqꞌue ta ichꞌel ta mucꞌ, joꞌon li coꞌol crixchanoutique. Jech ta xꞌichꞌe ta mucꞌ ta jventa li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ti mi iꞌichꞌe ta mucꞌ ta jventa li Diose, jaꞌ noꞌox jech chiyacꞌ ta ichꞌel ta mucꞌ ta ora eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Jnichꞌnabtac, mu xa epuc cꞌacꞌal liꞌ jchiꞌucoxuque. Chasaꞌicun. Jech chac cꞌu chaꞌal laj calbe li jchiꞌiltactique, jaꞌ noꞌox jech chacalbeic eꞌuc li joꞌoxuque. Li yoꞌ bu chibate mu to xuꞌ chachiꞌinicun batel ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chacalbeic achꞌ mantal, cꞌuxubinano me abaic. Jech chac cꞌu chaꞌal la jcꞌuxubinoxuque, jaꞌ jech sba xacꞌuxubinan abaic acotolic. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mi chacꞌuxubinan abaique, jech ta snaꞌic o scotol crixchanoetic ti joꞌoxuc cajchanbalajeloxuque ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Li Simón Pedroe jech la sjacꞌbe li Jesuse: ―Cajval, ¿bu chabat? ―xut. Itacꞌav li Jesuse: ―Li bu chibate mu to xuꞌ chachiꞌinun batel ta ora. Tsꞌacal to xuꞌ chabat ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Li Pedroe jech la sjacꞌbe: ―Cajval, ¿cꞌu chaꞌal ti mu to xuꞌ chajchiꞌin batel ta orae? Xuꞌ chimile ta aventa ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Itacꞌav li Jesuse: ―Mu to xuꞌ chavacꞌ aba ta milel ta jventa. Melel li cꞌusi chacalbee, tana cꞌalal muc toꞌox bu oqꞌuem jcotse, oxib xaꞌox velta avaloj ti mu xavojtaquinune ―xꞌutat yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Li Jesuse jech laj yalbuncutic, joꞌoncutic li yajchanbalajeltacuncutique: ―Mu me xcꞌopoj avoꞌonic. Chꞌunic me ti chascoltaic li Jtote. Jech chꞌunic me ti chajcoltaic eꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lec mucꞌ sna li Jtote, oy jaycꞌol. Jaꞌ te chacꞌotic. Ti manchuc lec muqꞌue, mu jechuc chacalbeic. Jaꞌ yuꞌun baꞌi chba jchapan li bu chacꞌotique. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tsꞌacal to chital nojtoc, chtal quicꞌoxuc muyel. Te chachiꞌinicun o sbatel osil. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Xanaꞌic xa li bu chibate, xanaꞌic xa onoꞌox ti xuꞌ chabatic tey eꞌuc li joꞌoxuque ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Li Tomase jech laj yalbe: ―Cajval, mu jnaꞌcutic bu chabat, jech mu jnaꞌcutic cꞌuxi chijbatcutic eꞌuc ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Li Jesuse jech laj yal: ―Ta jventa joꞌon chabatic li yoꞌ bu oy li Jtote. Li joꞌone xcojtaquin li Jtote, jaꞌ melel li cꞌu sba laj calboxuc scꞌoplale. Li buchꞌutic ta schꞌunic ti joꞌon Yajcoltavanejicune chcuxiic o sbatel osil ta jventa. Yan li buchꞌutic mu schꞌunic ti joꞌon Yajcoltavanejicune mu xuꞌ ta xojtaquinic li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ti avojtaquinicun ta melele, jech xavojtaquinic eꞌuc li Jtote. Pero chlic xa avojtaquinic li Jtote yuꞌun chlic xa avilic li cꞌu sba chascoltaic ta spasel li yabtele ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Li Felipee jech laj yal eꞌuc: ―Cajval, acꞌbun cojtaquincutic li Jtotic Diose jech xijmuybajcutic o ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Li Jesuse jech laj yalbe: ―Ep xa cꞌacꞌal liꞌ jchiꞌucoxuque. ¿Mi mu to xavojtaquinun? Felipe. Li buchꞌutic liyojtaquinic xae, iyojtaquinic xa eꞌuc li Jtotic Diose. ¿Cꞌu chaꞌal jech chavalbun: “Acꞌbun cojtaquincutic li Jtotic Diose”, ti xachie? ");
INSERT INTO tzoSA_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mi muc to bu achꞌunoj ti jununcutic jchiꞌuc li Jtote? Li cꞌusi chacalbeique mu jcꞌopuc jtuc ti ta xcale, jaꞌ scꞌop li Jtote yuꞌun ta cabtel ta xvinaj o ti jununcutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chꞌunic me ti jununcutic jchiꞌuc li Jtote. Mi mu xcꞌot ta avoꞌonic li cꞌusi laj cal liꞌi, jaꞌ me xachꞌunic o ta sventa ti laj cacꞌ ta ilel li juꞌele. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Melel li cꞌusi chacalbeique, mi chachꞌunic ti joꞌon chajcoltaique, xuꞌ chavacꞌbeic ta ilel sjuꞌel Dios jech chac cꞌu chaꞌal ta jpase. Schiꞌuc más to ep chlic yichꞌicun o ta mucꞌ li crixchanoetic ta aventaic li cꞌalal te oyun xa li yoꞌ bu oy li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Cꞌusiuc noꞌox chacꞌanbeic li Diose, joꞌon chacacꞌbeic scotol mi jaꞌ chacꞌanic li cꞌusi ta jcꞌane. Jech lec o scꞌoplal li Jtot ta sventa ti chajcoltaique. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuꞌun mi jaꞌ chacꞌanic li cꞌusi ta jcꞌane, jech chacacꞌbeic li cꞌustic chacꞌanbecune. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Mi tsloqꞌuel avoꞌonic cꞌuxun ta avoꞌonique, chachꞌunbecun scotol li jmantale. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ta jcꞌanbe li Jtote ti acꞌo stacboxuc talel li Chꞌul Espíritue yoꞌ chtal scoltaoxuc. Jaꞌ chaschiꞌinic sbatel osil. Jaꞌ sventainoj eꞌuc li cꞌop ti jaꞌ melele. Li buchꞌutic mu schꞌunic ti joꞌon Jcoltavanejune, mu xuꞌ ta xichꞌic li Chꞌul Espíritue yuꞌun mu schꞌunic ti oy li Chꞌul Espíritue. Mu snaꞌic li cꞌu sba ta xꞌabteje. Yan li joꞌoxuque chlic avilic li cꞌu sba ta xꞌabteje yuꞌun chtal schiꞌinoxuc. Ta xꞌoch o ta avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Muc bu chaquictaic o. Chtal jchiꞌinoxuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Li crixchanoetic li liꞌ oyic ta balumile mu xa jaluc liꞌ chiyilique. Mi la sta scꞌacꞌalil chichame, muc xa bu chiyilic nojtoc. Yan li joꞌoxuque ta to xavilicun. Ti jech cuxulun o sbatel osile, jech chacuxiic o sbatel osil ta jventa eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Cꞌalal mi iꞌoch ta avoꞌonic li Chꞌul Espíritue, jech chachꞌunic o ti jununcutic jchiꞌuc li Jtote, schiꞌuc ti jmojutic xa eꞌuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Li buchꞌutic ta schꞌunic li jmantaltaque jaꞌ tsloqꞌuel yoꞌonic cꞌuxun ta yoꞌonic. Mi tsloqꞌuel avoꞌonic cꞌuxun ta avoꞌonique, jaꞌ noꞌox jech cꞌuxoxuc ta yoꞌon li Jtote. Jech cꞌuxoxuc ta coꞌon eꞌuc, schiꞌuc más chacacꞌbe anaꞌic cꞌu sba li coꞌone ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jech ijacꞌbat yuꞌun li Judase, pero maꞌuc li Judas Iscariote, jaꞌ li yan o Judase: ―Cajval, ¿cꞌu chaꞌal ti jtuccutic noꞌox chavacꞌbun jnaꞌcutic ti cꞌu sba la avoꞌone? ¿Cꞌu chaꞌal mu xavacꞌbe snaꞌic li crixchanoetique? ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Itacꞌav li Jesuse: ―Li buchꞌu oyun ta yoꞌone ta schꞌun li cꞌusi chcalbee. Jaꞌ noꞌox jech li Jtote cꞌux ta yoꞌon. Chtal jchiꞌincutic. Chiꞌochcutic ta sjol ta yoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yan li buchꞌu mu cꞌuxucun ta yoꞌone, mu schꞌun li cꞌusi chcalbee. Maꞌuc jcꞌop jtuc li liꞌ chacalbeique; jaꞌ scꞌop li Jtote, jaꞌ ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Jaꞌ jech chacalbeic yoꞌ to liꞌ jchiꞌucoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cꞌalal mi libate, chastacbeic talel li Chꞌul Espíritu li Jtote, jaꞌ chtal scoltaoxuc. Chaschanubtasic o scotol, chasjulesboxuc ta ajolic scotol li cꞌusi laj calboxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Chajpasboxuc ta jun avoꞌonic comel. Li cꞌustic oy liꞌ ta balumile mu spas o ta jun avoꞌonic. Li joꞌone chajpasboxuc ta jun avoꞌonic jech chac cꞌu chaꞌal jun coꞌon li joꞌone. Mu me xavat avoꞌonic ti chibate. Mu me xaxiꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Laj xa calboxuc ti chibate. Laj xa calboxuc nojtoc ti chtal jchiꞌinoxuque. Ti cꞌuxucun ta avoꞌonique, xamuybajic noꞌox ti chisut batel ta stojol li Jtote. Yuꞌun jaꞌ más tsots yabtel yichꞌoj onoꞌox li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jaꞌ jech chacalbeic yoꞌ to muc bu batemun, yoꞌ jech mu xchibaj avoꞌonic ta jtojol li cꞌalal mi libate. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mu xa jaluc chajcꞌoponic yuꞌun poꞌot xa chtal ta jtojol li pucuje, jaꞌ li sventainoj li balumile. Pero mu cꞌusi xuꞌ chispasbe. ");
INSERT INTO tzoSA_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jaꞌ noꞌox ta jchꞌun li cꞌusi yalojbun li Jtote. Jech ta snaꞌic o scotol crixchanoetic ti oy ta coꞌon li Jtote. Licanic, batic xa ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Li Jesuse jech laj yalbuncutic, joꞌoncutic li yajchanbalajeltacuncutique: ―Ti cꞌu sba xuꞌ chatunic cuꞌune, jaꞌ scꞌan ti jaꞌ jechoxuc jech chac cꞌu chaꞌal li scꞌobtac li tsꞌusub ti tsacal ta smucꞌta aqꞌuile. Yuꞌun li joꞌone jaꞌ jechun jech chac cꞌu chaꞌal smucꞌta aqꞌuil li tsꞌusube. Li Jtote jaꞌ jech chac cꞌu chaꞌal jchabiejtsꞌusub. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Li joꞌoxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal li scꞌobtac li tsꞌusube. Li buchꞌutic ta xaꞌiic li jcꞌope, mi maꞌuc ta spasic li cꞌustic ta scꞌan li Jtote, jaꞌ jechic jech chac cꞌu chaꞌal li scꞌob tsꞌusub ti bu mu xacꞌ sate. Li jchabiejtsꞌusube ta stuchꞌan loqꞌuel scotol scꞌob li bu mu xacꞌ sate. Jaꞌ noꞌox jech eꞌuc li buchꞌutic mu scꞌan spasic li cꞌusi ta scꞌan li Jtote, mu xcꞌaneic yuꞌun li Jtote. Yan li buchꞌutic ta xaꞌiic li jcꞌope, mi jaꞌ ta spasic li cꞌustic ta scꞌan li Jtote, más ta xtuqꞌuibtaseic yuꞌun li Jtote jech chac cꞌu chaꞌal ta slecubtasbe scꞌob tsꞌusub li jchabiejtsꞌusube. Li jchabiejtsꞌusube ta sjaxbe loqꞌuel li bu chopol ta xile yoꞌ acꞌo satinuc o más. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Li joꞌoxuque tuqꞌuibtasbiloxuc xa yuꞌun laj xa avichꞌic ta mucꞌ li jcꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ichꞌicun o me ta mucꞌ jech chajcoltaic. Naꞌic me, ti manchuc tsacal ta smucꞌta aqꞌuil li scꞌob tsꞌusube, mu satin ti jechuque. Jaꞌ jechoxuc eꞌuc li joꞌoxuque, mu xuꞌ chapasic li cꞌusi leque mi mu xavichꞌicun ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Li joꞌone jaꞌ jechun jech chac cꞌu chaꞌal li smucꞌta aqꞌuil li tsꞌusube. Li joꞌoxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal li scꞌobtac li tsꞌusube. Mi chavichꞌicun o ta muqꞌue, jech chajcoltaic, jech xuꞌ chapasic li cꞌusi ta scꞌan li Jtote. Mi muc bu chajcoltaique, mu cꞌusi xuꞌ chapasic atuquic. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Li buchꞌu mu scꞌan chiyichꞌ ta muqꞌue, jaꞌ jech chac cꞌu chaꞌal li scꞌob tsꞌusub ti mu xacꞌ sate, ta xichꞌ tuchꞌel loqꞌuel. Li scꞌob tsꞌusub ti ituchꞌe loqꞌuele ta xtaquij o. Ta tsꞌacal ta xichꞌ tsobel, ta xichꞌ chiqꞌuel ta cꞌocꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mi chavichꞌicun o ta muqꞌue, mi te oy o ta avoꞌonic li jcꞌope, xuꞌ chacꞌanbeic Dios scotol li cꞌusi chacꞌanique jech chayacꞌbeic. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi jaꞌ chapasic li cꞌustic leque, jaꞌ ta xꞌichꞌe o ta mucꞌ li Jtote. Jech ta xvinaj ti la achꞌunic jech chac cꞌu chaꞌal la jchanubtasoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Toj cꞌuxoxuc ta coꞌon jech chac cꞌu chaꞌal toj cꞌuxun ta yoꞌon li Jtote. Ichꞌicun o me ta mucꞌ yuꞌun toj cꞌuxoxuc ta coꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mi chachꞌunbecun scotol li cꞌusi chacalbeique, jaꞌ chanaꞌic o ti toj cꞌuxoxuc ta coꞌone, jech chac cꞌu chaꞌal toj cꞌuxun ta yoꞌon li Jtote yuꞌun ta jchꞌunbe scotol li cꞌusi chiyalbee. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ti laj calboxuc ti scꞌan chavichꞌicun o ta muqꞌue, jaꞌ yoꞌ acꞌo muybajanic noꞌox jech chac cꞌu chaꞌal ximuybaj noꞌoxe. Jech xamuybajic noꞌox scotol cꞌacꞌal, mu xa cꞌusi chal avoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jech jmantal chacalbeic. Cꞌuxubino me abaic jech chac cꞌu chaꞌal la jcꞌuxubinoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Li buchꞌu ta xacꞌ sba ta milel ta sqꞌuexol li buchꞌu lec scꞌopon sbaic schiꞌuque, yuꞌun toj cꞌux ta yoꞌon li schiꞌile. Jaꞌ jech cꞌuxoxuc ta coꞌon. Jaꞌ scꞌan ti acꞌo jechuc avoꞌonic eꞌuc li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Li joꞌoxuque jmoj xa coꞌontic mi chapasic scotol li cꞌustic chacalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Li joꞌoxuque maꞌuc xa jtuneloxuc chcaꞌi, jmoj xa coꞌontic yuꞌun laj xa cacꞌboxuc anaꞌic scotol li cꞌustic caꞌioj ta stojol li Jtote. Li buchꞌu jtunel noꞌoxe muc bu ta xꞌalbat li cꞌustic ta snop li yajvale. Yan li joꞌone laj calboxuc xa scotol. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Li joꞌoxuque muc bu la atꞌujicun, joꞌon la jtꞌujoxuc. Laj cacꞌboxuc avabtelic yoꞌ chba apasic li cꞌusi ta scꞌan li Diose. Mu alticuc ti chapasic li cꞌusi ta scꞌan li Diose yuꞌun jaꞌ sventa sbatel osil. Ti chatunic cuꞌune jech scotol li cꞌustic chacꞌanbeic li Jtote chayacꞌbeic mi jaꞌ chacꞌanic li cꞌusi ta jcꞌane. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jaꞌ jech sba jmantal chacalbeic: Cꞌuxubino me abaic acotolic. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Mi chopol chayilic li crixchanoetique, mu me xchibaj avoꞌonic. Naꞌic me ti joꞌon chopol onoꞌox liyilique. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ti jaꞌuc to jech chapasic li cꞌustic chopol jech chac cꞌu chaꞌal ta spasic li crixchanoetique, lec chayilic ti jechuque. Li joꞌoxuque muc xa bu chapasic jech, yuꞌun laj quicꞌoxuc xa. Jaꞌ yuꞌun chopol chayilic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Naꞌic me ti jech onoꞌox calojboxuque: “Li buchꞌu jtunel noꞌoxe muc bu tsots yabtel yichꞌoj. Jaꞌ tsots yabtel yichꞌoj li yajvale”, xacutic onoꞌox. Ilbaj liyilic li joꞌone, jaꞌ noꞌox jech ilbaj chayilic eꞌuc. Muc bu xiyichꞌbeic ta mucꞌ li jcꞌope, jaꞌ noꞌox jech mu xayichꞌbeic ta mucꞌ eꞌuc la acꞌopique. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jaꞌ ta jventa joꞌon scotol li cꞌustic chaspasbeique yuꞌun mu xojtaquinic li Jtot ti listac talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ti manchuc tal jcꞌoponic li crixchanoetique, muc bu xvinaj mi chopol li yoꞌonique. Li avie mu xa xuꞌ chalic ti lec yoꞌonique yuꞌun chopol chiyilic. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Li buchꞌutic chopol chiyilique, chopol ta xilic eꞌuc li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ti manchuc laj cacꞌbe yilic jtsatsal juꞌel ti muc buchꞌu yan xuꞌ jech ta spase, muc bu xvinaj mi chopol li yoꞌonic ti jechuque. Li avie mu xa xuꞌ chalic ti lec yoꞌonique yuꞌun chopol iyilic li cꞌustic la jpascutic schiꞌuc li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ti jech chopol chiyilique, jaꞌ icꞌot ta pasel ti jech onoꞌox tsꞌibabil comel jcꞌoplal ta scꞌop Dios li te yichꞌojique: “Altic ti chopol chiyilique yuꞌun muꞌyuc jmul”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cꞌalal mi ital li Chꞌul Espíritu ti chajtacbeic talel sventa chascoltaique, jaꞌ jcꞌoplal chayalbeic. Melel li cꞌusi chayalbeique yuꞌun te chlic talel ta stojol li Jtote. ");
INSERT INTO tzoSA_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Li joꞌoxuque chavalic jcꞌoplal eꞌuc yuꞌun la achiꞌinicun li cꞌalal lic jpas li cabtele, schiꞌuc cꞌalal to tana. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Jaꞌ jech laj calboxuc ti chopol chayilic li crixchanoetique yoꞌ mu xchibaj avoꞌonic li cꞌalal muc xa bu liꞌ oyune. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chasloqꞌuesic ta schꞌulnaic li jchiꞌiltactic ta israelale. Ta xcꞌot scꞌacꞌalil ti chasmilic jayvoꞌoxuque yuꞌun ta snopic ti jaꞌ jech tscꞌan Dios ti chasmilique. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ti chasmilique, yuꞌun mu xojtaquinic li Jtotic Diose. Jech mu xiyojtaquinic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jaꞌ jech laj calboxuc ti chopol chayilic li crixchanoetique yuꞌun cꞌalal chascontrainique, jaꞌ ta xjul o ta ajolic ti jech onoꞌox calojboxuc comele. Cꞌalal laj quicꞌanoxuc ta jtojole, muc bu jech laj calboxuc yuꞌun liꞌ to jchiꞌucoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","’Chisut xa batel ta stojol li Jtote, jaꞌ ti listac talele. Pero jaꞌ noꞌox at‐oꞌon batem ta avoꞌonic li cꞌalal jech laj calboxuque. Muc un jaꞌ o chajacꞌbecun ti bu chibate. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Melel li cꞌusi chacalbeique, joꞌot acꞌuxubinelic ti chisut batel ta vinajele. Yuꞌun mi muc bu chisut batele, muc bu chtal scoltaoxuc li Chꞌul Espíritue. Ti chisut batele, jaꞌ chajtacbeic talel li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cꞌalal mi itale, ch‐acꞌbat yilic scotol crixchanoetic ti oy smulique, schiꞌuc ti muꞌyuc jmul li joꞌone, schiꞌuc ti ta xꞌacꞌbat yichꞌic vocol ta scoj li smulique. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Li smul ti ch‐acꞌbat yilique, jaꞌ ti mu schꞌunic ti joꞌon Yajcoltavanejicune. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ch‐acꞌbat snaꞌic ti tucꞌ coꞌone jaꞌ yuꞌun liyicꞌ muyel ta stojol li Jtote. Yuꞌun muc xa bu chavilicun li ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ch‐acꞌbat snaꞌic ti ta xichꞌic vocol ta scoj li smulique ta sventa ti jech onoꞌox yaloj Dios ti ta xichꞌ vocol sbatel osil li buchꞌu ta spas ta mantal li crixchanoetic liꞌ ta balumile, jaꞌ li banquilal pucuje. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Acꞌo mi oy to cꞌusi yan chacalbeique, pero mu xavaꞌibeic smelol scotol li avie. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cꞌalal chtal li Chꞌul Espíritue, jaꞌ melel scotol li cꞌusi ta xal eꞌuque. Jaꞌ chacꞌ anaꞌic chacꞌ avilic scotol li cꞌustic melele. Pero maꞌuc scꞌop stuc ti chale. Jaꞌ chal scotol li cꞌustic ch‐albat yuꞌun li Jtote. Jaꞌ chacꞌ anaꞌic scotol li cꞌustic ta xcꞌot ta pasele. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jaꞌ chiyacꞌ ta ichꞌel ta mucꞌ yuꞌun jaꞌ yabtel o ti ta sjules ta ajolic scotol li cꞌusi la jpase schiꞌuc li cꞌusi laj cale. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ti jech laj cale, mu jtucuc chiyacꞌ ta ichꞌel ta mucꞌ. Yuꞌun jununcutic jchiꞌuc li Jtote, jech coꞌol chijyacꞌuncutic ta ichꞌel ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mu xa jaluc liꞌ chavilicune. Oy jun chib cꞌacꞌal ti muc bu chavilicune. Tsꞌacal to chavilicun nojtoc. Ta tsꞌacal chisut batel li yoꞌ bu oy li Jtote ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oy chaꞌoxvoꞌuncutic, joꞌoncutic li yajchanbalajeltacuncutique, jech laj calbe jbacutic: ―¿Cꞌu sba smelol ti jech laj yalbutique: “Mu xa jaluc liꞌ chavilicune. Oy jun chib cꞌacꞌal ti muc bu chavilicune. Tsꞌacal to chavilicun nojtoc. Ta tsꞌacal chisut batel li yoꞌ bu oy li Jtote”, ti xijyututique? ");
INSERT INTO tzoSA_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Cꞌu sba smelol ti “mu xa jaluc” ti xie? Mu xcaꞌibetic smelol li cꞌusi ta xale ―xcut jbacutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Li Jesuse snaꞌoj ti chac jacꞌbecutic li cꞌu sba smelole, jech laj yalbuncutic: ―Jnaꞌoj ti chajacꞌbe abaic ta sventa ti jech laj cale: “Mu xa jaluc liꞌ chavilicune. Oy jun chib cꞌacꞌal ti muc bu chavilic jsate. Tsꞌacal to chavilicun nojtoc”, ti xacutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Melel li cꞌusi chacalbeique, li joꞌoxuque chaꞌoqꞌuic, chavat avoꞌonic. Yan li buchꞌutic mu xiyichꞌic ta muqꞌue jaꞌ xmuybajic o ti chimilee. Pero li joꞌoxuque jliquel noꞌox ti chavat avoꞌonique. Xamuybajic xa ta tsꞌacal. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Anaꞌojic li cꞌu sba li cꞌalal ta xcux jun antse, oy svocol. Pero cꞌalal mi ixcuxe, ta xchꞌay ta yoꞌon ti yan sba svocol iyaꞌie. Xmuybaj xa yuꞌun ispet xa yol. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jaꞌ noꞌox jechoxuc eꞌuc li joꞌoxuque, li avie chavat avoꞌonic, pero cꞌalal chavilic jsat nojtoque, xamuybajic xa. Muꞌyuc xa at‐oꞌon chavaꞌiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Cꞌalal chavilicun nojtoc jech chac cꞌu chaꞌal laj calboxuque, muꞌyuc xa cꞌusi chajacꞌbecun yuꞌun icꞌot xaꞌox ta pasel li cꞌustic laj calboxuque. Melel chacalbeic, scotol li cꞌusi chacꞌanbeic li Jtotic Diose chayacꞌbeic mi jaꞌ chacꞌanic li cꞌusi ta jcꞌan joꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Muc to bu acꞌanojbeic li Jtotic Dios li cꞌusi ta jcꞌane. Cꞌanbeic, jech chayacꞌboxuc. Jech xamuybajic noꞌox scotol cꞌacꞌal, mu xa cꞌusi yan chacꞌanic. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Scotol li cꞌustic laj calboxuque oy bu ta loꞌil noꞌox laj calboxuc. Pero chcꞌot scꞌacꞌalil ti jamal chacalbeic li scꞌoplal li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Cꞌalal chcꞌot scꞌacꞌalil ti jamal chavaꞌibeic scꞌoplal li Jtotic Diose, atuquic xa noꞌox chacꞌanbeic Dios li cꞌusi chacꞌanique yuꞌun xanaꞌic ti jech ta jcꞌane. Mu xa persauc ti joꞌon ta jcꞌanbe li Jtotic Dios li cꞌusi chacꞌanique. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yuꞌun toj cꞌuxoxuc ta yoꞌon li Jtotic Diose. Ti toj cꞌuxoxuc ta yoꞌone, jaꞌ ta sventa ti toj cꞌuxun ta avoꞌonic eꞌuque schiꞌuc achꞌunic xa ti te liquemun talel ta stojol li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Melel ti te lilic talel ta stojol li Jtotic Dios li cꞌalal lital liꞌ ta balumile. Ta xa xquicta li balumile, chisut xa batel li yoꞌ bu oy li Jtotic Diose ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Joꞌoncutic li yajchanbalajeltacuncutique jech laj calbecutic: ―Tana lec jamal la avalbuncutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jnaꞌcutic xa ti xanaꞌ scotole. Yuꞌun anaꞌoj xa onoꞌox ti oy cꞌusi ta jcꞌan chajacꞌbecutic li cꞌalal muc toꞌox bu jacꞌojbotcutique. Jaꞌ ta jchꞌuncutic o ti te liquemot talel li yoꞌ bu oy li Diose ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Itacꞌav li Jesuse: ―Lec mi chachꞌunic ti liquemun talel li yoꞌ bu oy li Diose. Pero scꞌan ti ta sloqꞌuel avoꞌonic chachꞌunic ti joꞌon Avajcoltavanejicune. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yuꞌun ta jliquel xa chavictaicun, chavoqꞌuilan abaic batel. Pero muc bu ictabilun, liꞌ schiꞌucun li Jtotic Diose. ");
INSERT INTO tzoSA_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Li cꞌu yepal laj calboxuque, jaꞌ sventa ti acꞌo xamuybajic o ta jventa li cꞌalal chavichꞌic vocol liꞌ ta balumile. Laj xa jpas ta canal scotol li cꞌustic oy liꞌ ta balumile, jech ta jventa joꞌon chapasic ta canal eꞌuc ―xijyutcutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cꞌalal laj yal jech li Jesuse, la sqꞌuel muyel ta vinajel, la sta ta naꞌel Dios. Jech laj yal: ―Tata, ista xa scꞌacꞌalil ti chicham jech chac cꞌu chaꞌal avaloj onoꞌoxe. Ta sventa ti ta jchꞌun li cꞌusi avaloje, jech acꞌun ta ichꞌel ta mucꞌ, joꞌon la Anichꞌonune. Chaꞌichꞌe ta mucꞌ eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","La avacꞌbun xa jventain scotol crixchanoetic ta spꞌejel balumil yoꞌ chcacꞌ ti chcuxiic o sbatel osil li cꞌu yepal atꞌujoj ti chiyichꞌic ta muqꞌue. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ti chcuxiic sbatel osile, yuꞌun xayojtaquinic, joꞌot li cuxul Diosote, schiꞌuc xiyojtaquinic eꞌuc, joꞌon li Yajcoltavanejicun ti la atacun talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Laj xa cacꞌot ta ichꞌel ta mucꞌ ta stojol li crixchanoetique. Nelebal xa cuꞌun li cabtel li avacꞌojbun jpase. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata, tanae acꞌun xa ta ichꞌel ta mucꞌ li te ta atojol jech chac cꞌu chaꞌal ichꞌbilun onoꞌox ta mucꞌ li te ta atojol li cꞌalal muc toꞌox bu meltsajem li balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Laj cacꞌot xa ta ojtaquinel ta stojol li viniquetic liꞌi, jaꞌ li la avacꞌ yichꞌicun ta muqꞌue. Baꞌi onoꞌox atꞌujoj ti chiyichꞌic ta muqꞌue, jech laj yichꞌic xa ta mucꞌ la acꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Snaꞌic xa ti joꞌot ta ajuꞌel la jpas scotol li cꞌustic la jpase schiꞌuc li cꞌustic laj cale. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Laj xa calbe yaꞌiic la acꞌope. Snaꞌic xa ti ta melel te liquemun talel ta atojole. Ischꞌunic xa ti joꞌot la atacun talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Chajcꞌopon ta stojolic. Maꞌuc chajcꞌopon ta stojol scotol li crixchanoetique. Jaꞌ chajcꞌopon ta stojolic li buchꞌutic la avacꞌ yichꞌicun ta mucꞌ yoꞌ jech chcolic o sbatel osil ta jventae yuꞌun jaꞌ avuꞌun. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Scotol li buchꞌutic chcolic ta jventa joꞌone jaꞌ cuꞌun. Jaꞌ avuꞌun eꞌuc. Coꞌol cuꞌuntic. Jaꞌ chiyaqꞌuic ta ichꞌel ta mucꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Stuquic xa chcomic liꞌ ta balumile yuꞌun chisut xa talel ta atojol. Tata, joꞌot ti mu cꞌusi chopol li te ta atojole, abolajan chabibun scotol li buchꞌutic la avacꞌ yichꞌicun ta muqꞌue yoꞌ jech mu spaseic ta canal yuꞌun li cꞌustic oy liꞌ ta balumile. Jech jmoj yoꞌonic scotolic jech chac cꞌu chaꞌal jmoj coꞌontique. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cꞌalal la jchiꞌinic liꞌ ta balumile ti jayvoꞌ la avacꞌ yichꞌicun ta muqꞌue, joꞌot ta atsatsal ajuꞌel ti mu junuc ichꞌay cuꞌune. Lec la jchabi, liꞌ schiꞌuquicun scotolique. Jaꞌ noꞌox li jun li buchꞌu scꞌoplal onoꞌox ta xchꞌay o sbatel osile, muc xa bu liꞌ jchiꞌuque. Yuꞌun jaꞌ icꞌot ta pasel li cꞌusi tsꞌibabil onoꞌox comel ta acꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Chital xa ta atojol, Tata. Cꞌalal liꞌ to jchiꞌuquic liꞌ ta balumil li buchꞌutic avacꞌojbune, chajcꞌopon ta stojolic yoꞌ acꞌo xmuybajic jech chac cꞌu chaꞌal xijmuybaj noꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Laj calbeic xa la acꞌope, pero chopol ta xꞌileic yuꞌun li buchꞌutic mu xiyichꞌic ta muqꞌue. Yuꞌun mu jmojuc yoꞌonic schiꞌuc li crixchanoetique, jech chac cꞌu chaꞌal mu jmojuc coꞌon jchiꞌuc li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mu me jaꞌuc chajcꞌanbe ti acꞌo xavicꞌ ta atojol li avie; jaꞌ chajcꞌanbe ti acꞌo xachabibune yoꞌ jech mu spaseic ta canal yuꞌun li pucuje. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yuꞌun mu xa jechuc yoꞌonic jech chac cꞌu chaꞌal yoꞌonic li crixchanoetique, jech chac cꞌu chaꞌal mu jechuc coꞌon jech chac cꞌu chaꞌal yoꞌonic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Acꞌo yacꞌ ta yoꞌonic la acꞌope yuꞌun jaꞌ melel, yoꞌ jech mu snopic mu spasic li cꞌusi ta snopic ta spasic li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jaꞌ jech chac cꞌu chaꞌal la atacun talel liꞌ ta balumile yoꞌ tal calbeic la acꞌope, jaꞌ noꞌox jechun eꞌuc ta jtaquic batel yoꞌ acꞌo ba yalbeic acꞌop li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ta slequil yutsil coꞌon ta jpas li cꞌusi chacꞌane, jech ta jventa joꞌon ti ta slequil yutsil yoꞌonic ta spasic eꞌuc li cꞌusi chacꞌane. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Maꞌuc noꞌox chajcꞌopon ta stojolic li viniquetic liꞌi. Chajcꞌopon ta stojolic eꞌuc li buchꞌutic chlic yichꞌicun ta mucꞌ ta sventa li viniquetic liꞌi. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chajcꞌanbe ti acꞌo jmojuc yoꞌonic scotolic li buchꞌutic chiyichꞌic ta muqꞌue jech chac cꞌu chaꞌal jmoj coꞌontique. Jech ta schꞌunic o scotol crixchanoetic ti joꞌot la atacun talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ta xcacꞌbe slequil yoꞌonic jech chac cꞌu chaꞌal slequil coꞌon li avacꞌojbune yoꞌ jech acꞌo jmojuc yoꞌonic jech chac cꞌu chaꞌal jmoj coꞌontique. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jaꞌ jech tspasic ta jmoj schiꞌuc li joꞌone. Li joꞌotique junutic onoꞌox. Jaꞌ jech tspasic ta jmoj scotolic jchiꞌuctic. Jaꞌ ta snaꞌic o scotol crixchanoetic ti joꞌot la atacun talele. Ta snaꞌic nojtoc ti toj cꞌux ta avoꞌon scotol li buchꞌutic jmojuncutic jchiꞌuque jech chac cꞌu chaꞌal toj cꞌuxun ta avoꞌone. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tata, ti jayvoꞌ la avacꞌ yichꞌicun ta muqꞌue, ta jcꞌan ti acꞌo xischiꞌinic o sbatel osil li yoꞌ bu oyote, jaꞌ te ta xilic o li cꞌu sba chavacꞌun ta ichꞌel ta muqꞌue. Yuꞌun cꞌuxun onoꞌox ta avoꞌon li cꞌalal muꞌyuc toꞌox li balumile. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, joꞌot ti tucꞌ avoꞌone, muc bu xavacꞌ xchꞌay li buchꞌutic xayojtaquinic xae. Li crixchanoetique mu xayojtaquinic. Li joꞌone xacojtaquin. Li jayvoꞌ li liꞌ oyique ischꞌunic xa ti joꞌot la atacun talele. ");
INSERT INTO tzoSA_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Laj yojtaquinicot xa cuꞌun. Pero más to chayojtaquinic cuꞌun, jech ta snaꞌic ti toj cꞌuxic ta avoꞌone jech chac cꞌu chaꞌal toj cꞌuxun ta avoꞌone. Schiꞌuc ta snaꞌic ti jmojuncutic xae ―xi iyal cꞌalal ista ta naꞌel Dios li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cꞌalal ilaj yoꞌon ta stael ta naꞌel Dios li Jesuse, ilocꞌ batel. Te tijil lijbatcutic eꞌuc, joꞌoncutic li yajchanbalajeltacuncutique. Lijelavcutic batel ta jot ucꞌum, Cedrón sbi. Te lijcꞌotcutic schiꞌuc Jesús ta tsꞌunbal olivatic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Li Judase, jaꞌ li buchꞌu spasoj xa trato ti chacꞌ ta cꞌabal li Jesuse, yiloj onoꞌox li bu tsꞌunbaltique yuꞌun te onoꞌox chijcꞌotilancutic jcotolcutic schiꞌuc li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jech li Judase laj yicꞌ batel soltaroetic ti te liquemic talel ta Romae, schiꞌuc jayvoꞌ yajmayoltaquic li banquilal paleetique schiꞌuc li jfariseoetique. Jaꞌ jchiꞌiltac ta israelal li mayoletique. Cꞌalal ibatique, tsꞌaclomic xa batel ta smachitaic, ta stojic, ta slamparaic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Li Jesuse snaꞌoj scotol li cꞌusi tspasbate. Inopoj batel, jech la sjacꞌbe li jchucvanejetique: ―¿Buchꞌu chasaꞌic? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Itacꞌavic: ―Jaꞌ ta jsaꞌcutic li Jesús li te liquem talel ta Nazarete ―xiic. Itacꞌav li Jesuse: ―Joꞌon li liꞌ oyune ―xi. Te vaꞌal eꞌuc li Judase, jaꞌ li jꞌacꞌvanej ta cꞌabale. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cꞌalal laj yal jech li Jesuse: “Joꞌon li liꞌ oyune”, ti xie, li jchucvanejetique ta valapat ibatic, iyalic ta lum. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Li Jesuse la schaꞌjacꞌbe: ―¿Buchꞌu chasaꞌic? ―xꞌutatic. Itacꞌavic: ―Jaꞌ ta jsaꞌcutic li Jesús li te liquem talel ta Nazarete ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Itacꞌav li Jesuse: ―Laj calboxuc xa ti joꞌon li liꞌ oyune. Mi jtuc noꞌox chasaꞌicune, li jchiꞌiltac liꞌi acꞌo baticuc ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ti jech laj yale, yoꞌ acꞌo cꞌotuc ta pasel ti jech onoꞌox laj yalbe li Stote: “Ti jayvoꞌ la avacꞌ yichꞌicun ta muqꞌue mu junuc ichꞌay cuꞌun”, xi onoꞌox laj yal. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te yichꞌoj smachita li Simón Pedroe. La sloqꞌues, la sjaxbe ta bojel sbatsꞌichiquin li yajtunel li más banquilal palee. Malco sbi li jtunele. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Li Jesuse jech laj yalbe li Pedroe: ―Ticꞌo ta sna la amachitae. Mi chapojune, mu xquichꞌ vocol jech chac cꞌu chaꞌal laj yal li Jtote ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Li banquilal soltaro schiꞌuc li yajsoltarotaque, schiꞌuc li yajmayoltaquic li banquilal paleetique, la stsaquic li Jesuse, la schuquic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Baꞌi laj yiqꞌuic batel ta stojol li loqꞌuem banquilal palee, Anás sbi. Oy jun sniꞌ li Anase, jaꞌ Caifás sbi, ti jaꞌ o ochem ta más banquilal pale li cꞌalal icham li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Li Caifase jaꞌ onoꞌox ti jech laj yalbe schiꞌiltac ta abtele: “Jaꞌ lec mi jun noꞌox vinic ta xcham cuꞌuntique; jaꞌ chopol mi chijcham jcotoltique”, ti xi onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Li joꞌone jchiꞌuc li Simón Pedroe nomnom tijiluncutic batel ta spat li Jesuse. Li joꞌone xiyojtaquin li loqꞌuem banquilal palee, jech cꞌalal iꞌoch ta yamaqꞌuil sna li banquilal pale li Jesuse, te liꞌoch eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Li Pedroe te vaꞌal icom ta pat tiꞌmoc. Li joꞌone yuꞌun ojtaquinbilun onoꞌox yuꞌun li banquilal palee, jaꞌ yuꞌun la jcꞌopon li jchabiejtiꞌmoque yoꞌ acꞌo otesatuc eꞌuc li Pedroe. Iꞌotesat li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Li jchabiejtiꞌmoc tseube la sjacꞌbe li Pedroe: ―¿Mi mu joꞌcot yajchanbalajelot li vinique? ―xut. Itacꞌav li Pedroe: ―Mu joꞌcun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Li jtuneletic li te oyique schiꞌuc li mayoletique te snopꞌojic lec scꞌoqꞌuic ta acꞌal yuꞌun toj sic. Te vaꞌalic ta xcꞌatinic. Te vaꞌal ta xcꞌatin eꞌuc li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Li Jesuse ijacꞌbat yuꞌun li loqꞌuem banquilal palee: ―¿Buchꞌutic la avajchanbalajeltaque? ¿Cꞌusi ti chavacꞌ ta chanele? ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Itacꞌav li Jesuse: ―Ta satilal laj calanbe li crixchanoetique. Scotol cꞌacꞌal lichanubtasvan ta chꞌulnaetic schiꞌuc te ta yamaqꞌuil li mucꞌta chꞌulna li yoꞌ bu ta stsob sbaic scotol li jchiꞌiltactique. Muc bu ta mucul lichanubtasvan. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Cꞌu chaꞌal chajacꞌbun? Jaꞌ jacꞌanbo li buchꞌutic laj yaꞌiic li cꞌusi laj calbeique. Jaꞌ snaꞌojic li cꞌusi laj calbeique ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cꞌalal laj yal jech li Jesuse, ta ora iꞌacꞌbat majel yuꞌun jun mayol li te vaꞌale. Jech laj yal li mayole: ―¿Cꞌu chaꞌal jech chatacꞌbe li banquilal palee? ―xꞌutat li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Itacꞌav li Jesuse: ―Mi yuꞌun chopol li cꞌusi laj cale, albun ti cꞌusi chopol ical avaꞌie. Mi lec li cꞌusi laj cale, ¿cꞌu chaꞌal la amajun? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Li Anase, jaꞌ li loqꞌuem banquilal palee, laj yacꞌbe ta chucbeel scꞌob li Jesuse, la stac batel ta stojol li sniꞌe, jaꞌ li Caifás li jaꞌ to iꞌoch ta más banquilal palee. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Cꞌalal jech ijacꞌbat te ta yut na li Jesuse, li Pedroe te vaꞌal ta xcꞌatin ta amacꞌ. Jech ijacꞌbat yuꞌun li buchꞌutic te coꞌol ta xcꞌatinic schiꞌuque: ―¿Mi mu joꞌcot yajchanbalajelot li vinique? ―xꞌutat. Itacꞌav li Pedroe: ―Mu joꞌcun ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te oy jun yajtunel li banquilal palee. Jaꞌ yutsꞌ yalal li buchꞌu ilaj ta bojbeel schiquine. Li Pedroe jech ijacꞌbat yuꞌun li jtunele: ―¿Mi mu joꞌcot ti te laj quilot achiꞌuc li vinic li te ta tsꞌunbaltique? ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Li Pedroe laj yal nojtoc ti mu xojtaquin li Jesuse. Jaꞌ xa o iꞌocꞌ schaꞌoqꞌuelal jcots. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Laj yiqꞌuic loqꞌuel ta stojol Caifás li Jesuse, ba yacꞌbeic ta scꞌob gobernador li te ta snae. Pretorio sbi li snae. Jaꞌ te ta xichꞌ meltsanbeel scꞌopic li crixchanoetique. Naca noꞌox xvinaj li cꞌalal icꞌotique. Li paleetic schiꞌuc li schiꞌiltaque muc bu xꞌochic li ta Pretorioe. Yuꞌun schꞌunojic ti ta sta o smulic ta stojol Dios mi ta scap sbaic schiꞌuc li buchꞌutic maꞌuc jchiꞌiltacutic ta israelale, jech mu xuꞌ tstiꞌic li chexel chij ta sventa li qꞌuin Coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jaꞌ yuꞌun ilocꞌ talel li Pilatoe, jaꞌ li gobernadore. Jech la sjacꞌbe li jꞌabteletic cuꞌuncutique: ―¿Cꞌusi smul avuꞌunic li vinic li liꞌ aviqꞌuic talele? ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Itacꞌavic: ―Ti muꞌyucuc smul li vinique, muc bu tal cacꞌcutic ta acꞌob ti jechuque ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Li Pilatoe jech laj yal: ―Iqꞌuic batel, ba meltsanbeic scꞌoplal ta sventa la amantal atuquique ―xꞌutatic. Li jꞌabteletique jech laj yalbeic li Pilatoe: ―Li joꞌoncutique muc bu quichꞌojcutic mantal avuꞌunic ti chijmilvancutique. Joꞌot chanop atuc yuꞌun jaꞌ avabtel ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ti jaꞌ iꞌoch ta scꞌob Pilato li Jesuse, yuꞌun jaꞌ icꞌot ta pasel li cꞌusi laj yal Jesús ti persa ta xcham ta cruze. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Li Pilatoe iꞌoch batel li yoꞌ bu ta smeltsan cꞌope. Laj yicꞌ ochel li Jesuse, jech la sjacꞌbe: ―¿Mi joꞌot ajvalilot yuꞌun la achiꞌiltac ta israelale? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Itacꞌav li Jesuse: ―¿Mi atuc noꞌox la anop taje, mi yuꞌun oy buchꞌu laj yalbot? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Itacꞌav li Pilatoe: ―Li joꞌone mu cꞌu jventa o yuꞌun maꞌuc jꞌisraelun. La achiꞌiltaque schiꞌuc li banquilal paleetic avuꞌunique jaꞌ laj yaqꞌuicot ta jcꞌob. ¿Cꞌusi chopol apasoj? ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Itacꞌav li Jesuse: ―Li buchꞌu laj yacꞌbun cabtel ti ta jpas mantale, mu crixchanouc. Ti crixchanouc laj yacꞌbun cabtele, la scoltaicun li jvinictaque yoꞌ jech muc xiꞌoch ta scꞌob li jchiꞌiltaque, jech muc xital liꞌ ta atojol eꞌuc ti jechuque. Li cabtel quichꞌoje mu crixchanouc laj yacꞌbun ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Li Pilatoe jech laj yalbe: ―Yuꞌun joꞌot ajvalilot chaꞌa ―xut. Itacꞌav li Jesuse: ―Joꞌon ajvalilun. Ti tal vocꞌcun liꞌ ta balumile, yoꞌ tal cal li cꞌop ti jaꞌ melele. Scotol buchꞌutic tscꞌan chaꞌiic li cꞌusi melele, jaꞌ chaꞌibecun li jcꞌope ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Li Pilatoe jech laj yalbe li Jesuse: ―¿Cꞌusi xa ti melel ti avaloje? ―xi. Cꞌalal laj yal jech li Pilatoe, ilocꞌ batel nojtoc, ba schaꞌcꞌopon li jꞌabteletic cuꞌuncutique. Jech laj yalbe: ―Muc bu jtabe smul li vinique. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero ta sventa ti nopem xavaꞌiic ti chajloqꞌuesbeic ta chuquel jun achiꞌilic ta jujun qꞌuin Coltaele, ¿mi jaꞌ chacꞌanic ti chajcoltabeic li ajvalil avuꞌunic, joꞌoxuc li jꞌisraeloxuque? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Toj tsots itacꞌavic scotolic: ―¡Mu me xacolta leꞌe! ¡Jaꞌ loqꞌueso li Barrabase! ―xiic. Li Barrabase jaꞌ jun jꞌelecꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Li Pilatoe laj yalbe li yajsoltarotaque ti acꞌo stsitsic ta nucul li Jesuse. La stsitsic. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tsꞌacal to la xotic chꞌix, la xojbeic ta sjol sventa scorona. La slapbeic natil cꞌuꞌil, icꞌpocꞌan stsajal. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","La snaꞌleic li Jesuse: ―¡Toj lec mucꞌta ajvalilot avaꞌuc yuꞌun la achiꞌiltac ta israelale! ―xutic. La smajbeic sat. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ilocꞌ nojtoc li Pilatoe. Jech laj yalbe li jchiꞌiltacutic ta israelale: ―Qꞌuelavilic, ta xquicꞌ loqꞌuel talel liꞌ ta atojolique yoꞌ jech chanaꞌic o ti muc bu jtabe smule ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Cꞌalal ilocꞌ talel li Jesuse, xojojbeic xaꞌox xotbil chꞌix ta sjol. Slapoj li icꞌpocꞌan tsajal cꞌuꞌile. Li Pilatoe jech laj yalbe li jchiꞌiltacutique: ―¡Qꞌuelavilic li vinique! ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cꞌalal iyilic Jesús li banquilal paleetique schiꞌuc li yajmayoltaquique, toj tsots la stacꞌbeic li Pilatoe: ―¡Jocꞌano ta cruz! ¡Jocꞌano ta cruz! ―xutic tajmec. Itacꞌav li Pilatoe: ―Iqꞌuic batel li joꞌoxuque, ba jocꞌanic ta cruz. Yuꞌun muc bu jtabe smul maꞌ joꞌone ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Itacꞌav li jꞌabteletic cuꞌuncutique: ―Li joꞌoncutique oy mantal cuꞌuncutic ti persa ta xcham li buchꞌu ta spꞌis sba ta Snichꞌon li Diose ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Li Pilatoe ta onoꞌox xiꞌ ta sventa li cꞌusi ta spasbeic li Jesuse. Cꞌalal iyaꞌi “ta spꞌis sba ta Snichꞌon Dios” ti xiique, más to ixiꞌ o. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ichaꞌochic ta yut Pretorio schiꞌuc li Jesuse. Jech la sjacꞌbe li Jesuse: ―¿Bu liquemot talel chaꞌa? ―xut. Li Jesuse muc bu xtacꞌav. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Li Pilatoe jech laj yalbe li Jesuse: ―¿Cꞌu chaꞌal ti mu xatacꞌbune? ¿Mi mu xanaꞌ ti joꞌon oy cabtele? Xuꞌ chacacꞌ ta jocꞌanel ta cruz, xuꞌ mi chajcolta batel nojtoque ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Itacꞌav li Jesuse: ―Mu cꞌusi xuꞌ chapasbun, jaꞌ noꞌox li cꞌusi chacꞌ apas li Dios ta vinajele yuꞌun jaꞌ yacꞌojbot avabtel. Li joꞌote mu másuc amul. Jaꞌ más ep smul li banquilal pale ti laj yacꞌun ta acꞌobe ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cꞌalal iyaꞌi Pilato li cꞌusi iyal li Jesuse, la snop ti cꞌu sba xuꞌ ta scolta batel li Jesuse. Li jchiꞌiltaque tsots laj yalic: ―Mi chacolta batel li vinic liꞌi, mu jmojuc avoꞌonic chaꞌa schiꞌuc li mucꞌta ajvalil Césare. Yuꞌun li buchꞌu ta spꞌis sba ta ajvalil stuque, jaꞌ ta scontrain li Césare ―xutic li Pilatoe. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cꞌalal iyaꞌi Pilato li cꞌusi laj yalic li jchiꞌiltaque, laj yal mantal ti acꞌo yiqꞌuic loqꞌuel ta amacꞌ li Jesuse. Li amaqꞌue pasbil ta ton. Te pasbil lec schotleb ta ton te ta oꞌlol yamacꞌ li gobernadore. Jaꞌ te chba chotluc cꞌalal ta xal ti cꞌu sba ta xcom scꞌoplal li buchꞌu ta smeltsanbe scꞌoplale. Jaꞌ Gabata sbi ta jcꞌopcutic. Li Pilatoe te ba chotluc. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jaꞌ xa o scꞌacꞌalil ta smilic li chexel chij sventa li qꞌuin Coltaele. Poꞌot xaꞌox oꞌlol cꞌacꞌal li cꞌalal te ba chotluc li Pilatoe. Jech laj yalbe li jchiꞌiltaque: ―¡Qꞌuelavilic li ajvalil avuꞌunique! ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Li jchiꞌiltaque tsots la stacꞌbeic li Pilatoe: ―¡Acꞌo chamuc, acꞌo jocꞌanatuc ta cruz! ―xiic. Li Pilatoe jech la sjacꞌbe li jchiꞌiltaque: ―¿Mi lec ti ta xcacꞌ ta jocꞌanel ta cruz li ajvalil avuꞌunique? ―xut. Itacꞌav li banquilal paleetique: ―Maꞌuc ajvalil cuꞌuncutic leꞌe. Jun noꞌox li mucꞌta ajvalil cuꞌuncutique, jaꞌ li Césare ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Li Pilatoe la schꞌun li cꞌusi iyalic li jchiꞌiltaque, jech laj yal mantal ti acꞌo ba jocꞌanatuc ta cruz li Jesuse. Li soltaroetique laj yiqꞌuic batel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Li soltaroetique laj yacꞌbeic xqꞌuech batel scruzal li Jesuse. Te ibatic li yoꞌ bu Baquil Jolil sbie. Jaꞌ Gólgota sbi ta jcꞌopcutic, joꞌoncutic li jꞌisraeluncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Te la sjocꞌanic ta cruz li Jesuse. Schiꞌuc chaꞌvoꞌ vinic te la sjocꞌanic ta cruz eꞌuc. Jujun cruz ta jujot xocon scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Li Pilatoe laj yacꞌ ta tsꞌibael jpech teꞌ. Te la sbajic ta sjol scruzal li Jesuse. “Liꞌi jaꞌ Jesús ti liquem talel ta Nazarete. Jaꞌ mucꞌta ajvalil yuꞌunic li jꞌisraeletique”, xi tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Oy ep jchiꞌiltac iyilic li cꞌusi tsꞌibabile yuꞌun te noꞌox ta tiꞌ jteclum Jerusalén ijocꞌanat ta cruz li Jesuse. Tsꞌibabil ta jcꞌopcutic, schiꞌuc ta griego cꞌop, schiꞌuc ta latin cꞌop. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Li banquilal paleetique, cꞌalal iyilic li cꞌusi tsꞌibabile, ba yalbeic ta ora li Pilatoe: ―¿Cꞌu chaꞌal jech la avacꞌ ta tsꞌibael: “Jaꞌ mucꞌta ajvalil yuꞌunic li jꞌisraeletique”, xi tsꞌibabil iquilcutic? Ta jcꞌancutic ti jech chavacꞌ ta tsꞌibaele: “Liꞌi jaꞌ la spꞌis sba ta mucꞌta ajvalil yuꞌunic li jꞌisraeletique”, xi ―xiic li banquilal paleetique. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Itacꞌav li Pilatoe: ―Li cꞌusi laj cacꞌ ta tsꞌibaele, jech acꞌo comuc ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cꞌalal la sjocꞌanic xaꞌox ta cruz Jesús li soltaroetique, la svoqꞌuilanbe sbaic li scꞌuꞌ spacꞌaltac li Jesuse. Julic laj yichꞌic li chanvoꞌique. Jaꞌ xa noꞌox icom li scꞌuꞌe yuꞌun muꞌyuc stsꞌis. Yuꞌun jis noꞌox jalbil. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Li soltaroetique jech laj yalbe sbaic: ―Mu jatulantic li jlic liꞌi. Jaꞌ lec jpastic canal tajimol jqꞌueltiquic buchꞌu junucal ta xichꞌ cuꞌuntic ―xiic. Ti jech la spasic li soltaroetique, yuꞌun jaꞌ icꞌot ta pasel li cꞌusi tsꞌibabil onoꞌox comel ta scꞌop li Diose. Jech tsꞌibabil: “Ta svoqꞌuilanbe sbaic li jcꞌuꞌ jpacꞌaltaque. Ta spasic canal tajimol yoꞌ jech chilic bu jlicucal li jcꞌuꞌ jpacꞌaltac ti chichꞌic jujunique”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Li smeꞌ Jesuse te nopol vaꞌalic ta yoc scruzal Jesús schiꞌuc smuc, jaꞌ María sbi eꞌuc. Jaꞌ Cleofas sbi li smalale. Te oy otro jun María li te liquem talel ta jteclum Magdalae. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Joꞌon li yajchanbalajelun li Jesuse ti toj cꞌuxun ta yoꞌone, te vaꞌalun eꞌuc, jaꞌ te jchiꞌuc li smeꞌ Jesuse. Cꞌalal lijyilcutic li Jesuse, jech laj yalbe li smeꞌe: ―Jaꞌ coꞌol schiꞌuc avol leꞌe ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jech laj yalbun eꞌuc li Jesuse: ―Jaꞌ ameꞌ yaꞌel leꞌe ―xiyut. Laj quicꞌ batel ta jna li smeꞌ li Jesuse. Te icom o. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Li Jesuse snaꞌoj ti chcꞌot xa ta pasel scotol li cꞌu sba tsꞌibabil comel scꞌoplale. Jaꞌ xa stsꞌaquieb ti jech laj yale: ―Ta xtaquij jtiꞌ ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te lechel jboch pajal yaꞌlel tsꞌusub. La stsꞌajic jpꞌej li cꞌusi cꞌunputsane. La xojic ta isopo teꞌ, laj yacꞌbeic muyel ta ye li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cꞌalal la stsꞌuꞌ li pajal yaꞌlel tsꞌusub li Jesuse, jech laj yal: ―Ijuꞌ xa cuꞌun li cabtele ―xi. La stsꞌuyan yalel li sjole, jaꞌ o ilocꞌ schꞌulel. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Joꞌoncutic li jꞌisraeluncutique jaꞌ xa o scꞌacꞌalil ta jcuxcutic ta yocꞌomal. Li jꞌabteletic cuꞌuncutique mu scꞌanic ti te jocꞌajtic ta xcomic ta cruz li sbecꞌtal stacupalic li oxvoꞌique. Yuꞌun jech onoꞌox persa ta schabiic li sábaro ta yechꞌel mucꞌta qꞌuin Coltael li jchiꞌiltaque. Jech la scꞌanbeic Pilato ti acꞌo yichꞌic cꞌasbeel yacanique yoꞌ acꞌo chamicuc ta ora, jech xuꞌ ta syalesic ta cruz. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Li soltaroetique iyichꞌic mantal ti acꞌo ba scꞌasanbe yacane. Jech ba scꞌasbeic yacan li june. Tsꞌacal to la scꞌasbeic yacan nojtoc li june, jaꞌ li te ijocꞌanatic ta cruz ta jujot xocon scruzal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Cꞌalal icꞌotic li yoꞌ bu jocꞌol li Jesuse, chamem xaꞌox iyilic li Jesuse, jaꞌ yuꞌun muc bu la scꞌasbeic li yacane. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Acꞌo mi chamem xaꞌox iyilic li Jesuse pero oy jun soltaro laj to xenbe xocon ta lanza. Ilocꞌ schꞌichꞌel ta ora capal xa ta joꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Li joꞌone iquil cꞌu sba icham li Cajvaltique. Melel li cꞌusi ta xcale yuꞌun iquil scotol. Ti jech ta xcale, jaꞌ ta sventa ti acꞌo xachꞌunic eꞌuc ti jaꞌ Avajcoltavanejique. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ti jech icꞌot ta pasele, yuꞌun jaꞌ icꞌot ta pasel li cꞌustic tsꞌibabil comel ta scꞌop li Diose: “Mu junuc sbaquil ta scꞌasbat”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jech tsꞌibabil comel nojtoc ta scꞌop Dios: “Chavilic li buchꞌu ixenbat xocon avuꞌunique”, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oy jun jchiꞌilcutic ta israelal, José sbi. Te liquem talel ta jteclum Arimatea. Ta yoꞌon noꞌox schꞌunoj ti jaꞌ Jcoltavanej li Jesuse yuꞌun ta xiꞌ o li yan schiꞌiltac ta meltsanejcꞌope. Cꞌalal iyil ti chamem xa li Jesuse, ba scꞌopon li Pilatoe, ba scꞌanbe li sbecꞌtal stacupal li Jesuse. Li Pilatoe laj yal mantal ti acꞌo syalesbe ta cruz sbecꞌtal stacupal li Jesuse yoꞌ acꞌo xba smuc. Ba syales. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Te ital eꞌuc li Nicodemoe, jaꞌ li buchꞌu a scꞌopon ta acꞌubal li Jesuse. Yichꞌoj talel chaꞌchop muil vomoletic, oy nan lajunebuc schaꞌvinic (30) kilo yalal. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","La spixic lec ta saquil pocꞌ li Jesuse. Te capal la spixic comel li chaꞌchop muil vomoletique ti yoꞌ mu xtuib oe. Yuꞌun jech onoꞌox jtalelcutic li cꞌalal ta jmuc jbacutic, joꞌoncutic li jꞌisraeluncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Li yoꞌ bu ijocꞌanat ta cruz li Jesuse te nopol tsꞌunbal olivatic. Li ta tsꞌunbaltique te jun jombil chꞌut chꞌen, yuꞌun jaꞌ sventa te ta xmuque jun ánima. Achꞌ chꞌen to, muꞌyuc to buchꞌu mucbil tey. ");
INSERT INTO tzoSA_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaꞌ te ba smuquic li Jesuse yuꞌun nopol noꞌox. Yuꞌun jaꞌ xa scꞌacꞌalil chlic jcuxcutic cꞌalal ibat xaꞌox cꞌacꞌale, jaꞌ yuꞌun la smuquic ta ora. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sob ta rominco, jaꞌ li sba cꞌacꞌal xemanae, icꞌ to ibat ta smuquenal Jesús li María li liquem talel ta Magdalae. Iyil ti tselelinbil xa loqꞌuel li ton li macbil toꞌox o stiꞌ li chꞌene. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Isut talel ta anil, tal yalbuncutic jchaꞌvaꞌalcutic, jaꞌ li Simón Pedroe schiꞌuc joꞌon ti toj cꞌuxun ta yoꞌon li Jesuse. Jech laj yalbuncutic: ―Li sbecꞌtal stacupal li Cajvaltique, laj xa sloqꞌuesic batel. Mu jnaꞌcutic bu laj yaqꞌuic ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Lijbatcutic ta ora ta smuquenal Jesús jchiꞌuc li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Coꞌol lijbatcutic ta anil. Li joꞌone lijelav batel. Joꞌon baꞌi licꞌot ta smuquenal li Jesuse. Li Pedroe tsꞌacal to icꞌot. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Li joꞌone jaꞌ noꞌox la jcujan jba, la jnachꞌta ochel li yut chꞌene. Iquil ti te xotol li saquil poqꞌue pero muc bu xiꞌoch ta yut chꞌen. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Cꞌalal icꞌot li Simón Pedroe, iꞌoch ta ora ta yut chꞌen. Iyil eꞌuc ti te xotol li saquil pocꞌ li la spixbeic o li sbecꞌtal stacupal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iyil ti te balbil comel li spix sjole, pero muc bu jmoj oy schiꞌuc li spixobile. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Li joꞌon ti baꞌi licꞌote tsꞌacal to liꞌoch ta yut li chꞌene. Cꞌalal iquil ti cꞌu sba comem li poqꞌue, ijchꞌun ti chaꞌcuxiem xa li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero muc toꞌox bu caꞌiojbecutic smelol li cꞌusi tsꞌibabil ta scꞌop Dios ti persa ta xchaꞌcuxi loqꞌuel ta smuquenal li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lijsutcutic batel ta jnacutic, joꞌoncutic li yajchanbalajeltacuncutique. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Li Maríae te vaꞌal icom ta tiꞌ chꞌen, te ta xꞌocꞌ. Cꞌalal te yacal ta oqꞌuele, la scujan sba, la snachꞌta ochel li yut chꞌene. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iyil ti te chotol chaꞌvoꞌ yajꞌangel Dios, jun ta sjol, jun ta yoc li bu toꞌox laj yaqꞌuic comel li sbecꞌtal stacupal li Jesuse. Toj sac tajmec li scꞌuꞌique. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jech iꞌalbat li Maríae: ―Yaa, ¿cꞌu chaꞌal chaꞌocꞌ? ―xꞌutat. Itacꞌav li Maríae: ―Yuꞌun laj xa sloqꞌuesic batel li sbecꞌtal stacupal li Cajvale. Mu jnaꞌ bu laj yaqꞌuic ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cꞌalal laj yal jech li Maríae, la sqꞌuel svalapat. Iyil ti te vaꞌal jun vinique, pero muc bu xojtaquin mi jaꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Li Jesuse jech laj yalbe: ―Yaa, ¿cꞌu chaꞌal chaꞌocꞌ? ¿Buchꞌu chasaꞌ? ―xi li Jesuse. Li Maríae la snop ti jaꞌ li jchabiej tsꞌunbaltique, jech laj yalbe: ―Totin, mi joꞌot la aloqꞌues batel li sbecꞌtal stacupal li Cajvale, albun ti bu la avaqꞌue yuꞌun ta jcuch batel ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Itacꞌav li Jesuse: ―¡María! ―xut. Li Maríae ijoypꞌij, la scꞌopon ta jcꞌopcutic, jaꞌ li hebreo cꞌope: ―¡Raboni! ―xut. “Jchanubtasvanej”, xi smelol. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Li Jesuse jech laj yalbe: ―Mu xtal amacun yuꞌun chibat li yoꞌ bu oy li Jtote. Batan, ba albo yaꞌiic li quermanotactique, jaꞌ li buchꞌutic coꞌol quichꞌojtic ta mucꞌ li Jtotic Diose: “Chibat ta stojol li Jtote, jaꞌ Atotic eꞌuc. Jaꞌ li Dios cuꞌune, jaꞌ li Dios avuꞌunic eꞌuque, xiyut”, uto me cꞌotel li yanetique ―xꞌutat li Maríae. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Li María li liquem talel ta Magdalae jech tal yalbuncutic, joꞌoncutic li yajchanbalajeltacuncutic li Jesuse: ―Iquil xa li Cajvaltique ―xijyutcutic. Scotol li cꞌustic iꞌalbat yuꞌun li Jesuse laj yalbuncutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Cꞌalal xtupꞌet xaꞌox osil ta sba cꞌacꞌal xemana, jaꞌ li romincoe, te jlapoj jbacutic ta na, joꞌoncutic li yajchanbalajeltacuncutic li Jesuse. Lec jmacojcutic li tiꞌnae yuꞌun chixiꞌcutic o li jꞌabteletic cuꞌuncutique. Li Jesuse te iyacꞌ sba ta ilel ta oꞌlol yut na li bu tsoboluncutique. Jech laj yalbuncutic: ―Junuc avoꞌonic ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cꞌalal laj yalbuncutic jech li Jesuse, laj yacꞌbun quilcutic li scꞌobe schiꞌuc li xocone. Jech ijnaꞌcutic o ti jaꞌ li Cajvaltique. Xijmuybajcutic xa jcotolcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Li Jesuse jech laj yalbuncutic nojtoc: ―Junuc avoꞌonic. Jaꞌ jech chac cꞌu chaꞌal listac talel li Jtote, jaꞌ jech chajtaquic batel eꞌuc yoꞌ chba apasbecun li cabtele ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cꞌalal laj yalbuncutic jech li Jesuse, la svuchꞌtauncutic jcotolcutic, jech laj yalbuncutic: ―Ichꞌic li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Li buchꞌutic ti laj xa yictaic li cꞌustic chopol tspasique, albeic ti muꞌyuc xa smulic ta xꞌileic yuꞌun li Diose. Pero li buchꞌutic ti mu xictaic li cꞌustic chopol tspasique, albeic ti oy smulic ta xꞌileic yuꞌun li Diose ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Li Tomás li vach xcutcutique muc toꞌox bu te oy li cꞌalal icꞌot li Jesuse. Li Tomase jaꞌ jununcutic li lajchavoꞌuncutic ta yajchanbalajeltacuncutic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jech laj calbecutic: ―Iquilcutic xa li Cajvaltique ―xcutcutic. Itacꞌav li Tomase: ―Jaꞌ to mi iquil jtuc li yav laux ta scꞌobe, mi la jticꞌ ochel sbicꞌtal jcꞌob ta yav li lauxe, schiꞌuc mi la jticꞌ ochel jcꞌob li ta yav lanza ta xocone, jaꞌ to ta jchꞌun ti melel chaꞌcuxiem xae ―xijyutcutic li Tomase. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Cꞌalal ilocꞌ vaxaquib cꞌacꞌal ti iyacꞌ sba ta ilel ta jtojolcutic li Jesuse, te tsoboluncutic nojtoc ta yut na, joꞌoncutic li yajchanbalajeltacuncutique. Jaꞌ to te xa jchiꞌucutic li Tomase. Lec jmacojcutic li tiꞌnae, pero li Jesuse te iyacꞌ sba ta ilel ta oꞌlol li yoꞌ bu tsoboluncutique. Jech laj yalbuncutic: ―Junuc me avoꞌonic ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Li Jesuse jech laj yalbe li Tomase: ―Laꞌ ticꞌo ochel sbicꞌtal acꞌob li ta yav laux li ta yut jcꞌobe. Qꞌuelavil li jcꞌobe. Ticꞌo ochel acꞌob li ta yav lanza li ta jxocone. Mu me xachibajes avoꞌon. Chꞌuno me ti lichaꞌcuxi xae ―xꞌutat li Tomás yuꞌun li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Itacꞌav li Tomase: ―¡Cajval cuꞌun, Dios cuꞌun! ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Li Jesuse jech laj yalbe: ―Tomás, jaꞌ to la achꞌun ti avil ta asat ti lichaꞌcuxi xae. Pero li buchꞌutic ta schꞌunic acꞌo mi muc bu yilojicune, más to toj lec ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Li Jesuse ep laj yacꞌ ta ilel stsatsal sjuꞌel ta jtojolcutic, joꞌoncutic li yajchanbalajeltacuncutique, pero muc xichꞌ tsꞌibael scotol liꞌ ta june. ");
INSERT INTO tzoSA_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Li cꞌu yepal iyichꞌ tsꞌibael liꞌi, jaꞌ ta sventa ti acꞌo xachꞌunic ti jaꞌ Cajcoltavanejtic li Jesuse schiꞌuc ti jaꞌ Snichꞌon li Diose. Mi chachꞌunique, jaꞌ chacuxiic o sbatel osil ta sventa. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Li Jesuse iyacꞌ sba ta ilel nojtoc ta jtojolcutic, joꞌoncutic li yajchanbalajeltacuncutique. Te iyacꞌ sba ta ilel ta tiꞌ nab Tiberias. Li cꞌalal iyacꞌ sba ta ilele, jech icꞌot ta pasel jech chac liꞌi: ");
INSERT INTO tzoSA_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Te tsoboluncutic schiꞌuc li Simón Pedroe, schiꞌuc li Tomás li vach xcutcutique. Te oy eꞌuc li Natanaele li liquem talel ta jteclum Caná li te ta cosilalcutic ta Galilea balumile. Te oyuncutic jchaꞌvaꞌalcutic eꞌuc ti jbanquil quitsꞌin jbacutic li Zebedeo sbi jtotcutique, schiꞌuc te oyic yan chaꞌvoꞌ jchiꞌilcutic ta yajchanbalajeltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Li Simón Pedroe jech laj yalbuncutic: ―Chibat ta tsac choy ―xijyutcutic. Jech lijtacꞌavcutic: ―Batic, chba jchiꞌinotcutic eꞌuc ―xcutcutic. Lijbatcutic, lijꞌochcutic ta canava. Sjunul acꞌubal la jsaꞌcutic li choye pero mu jcotuc ijtacutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cꞌalal sac xaꞌox osile, iquilcutic ti te vaꞌal ta tiꞌnab li Jesuse, pero joꞌoncutic li yajchanbalajeltacuncutique muc bu xcojtaquincutic mi jaꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Li Jesuse jech laj yalbuncutic: ―Queremutic, ¿mi atsaquic xa li choye? ―xijyutcutic. Jech lijtacꞌavcutic: ―Moꞌoj to ―xcutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Li Jesuse jech laj yalbuncutic: ―Ticꞌo ochꞌel anutiꞌic li stsacobil achoyique li te ta jot xocon acanavaic li ta abatsꞌicꞌobique. Jaꞌ te chataic ―xijyutcutic. Cꞌalal la jticꞌcutic ochel ta yut nab li jnutiꞌcutique, muc bu xlic ochel cuꞌuncutic ta yut canava yuꞌun noj tajmec ta choy. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Joꞌon ti toj cꞌuxun ta yoꞌon li Jesuse, jech laj calbe li Pedroe: ―¡Jaꞌ li Cajvaltic li leꞌ oye! ―xcut. Cꞌalal iyaꞌi Simón Pedro ti “jaꞌ Cajvaltic” xcute, la slap ta ora scꞌuꞌ yuꞌun tꞌanal toꞌox, la sten sba ochel ta nab, ba sta li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Li joꞌoncutique ta canava lijbatcutic, te jochojcutic batel li jnutiꞌcutic li noj ta choye. Muc bu nom li tiꞌ nabe, oy noꞌox nan joꞌvinicuc (100) metro snamal. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cꞌalal lijlocꞌcutic ta canava ta tiꞌnabe, iquilcutic ti te nopꞌol cꞌoqꞌue. Lec xa tilem li cꞌoqꞌue, oy xa lec yacꞌlel. Te yac tsvoel jcot choy. Te oy pan nojtoc. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Li Jesuse jech laj yalbuncutic: ―Ichꞌic talel chaꞌoxcotuc la achoyique ―xijyutcutic. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Iꞌoch ta canava li Simón Pedroe, ba snit loqꞌuel ta nab li jnutiꞌcutique. Noj tajmec ta mucꞌtic choy. Oxlajuneb svaxacvinic (153) ta cot li choye. Acꞌo mi ep li choye pero muc bu xjat li stsacobile. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Li Jesuse jech laj yalbuncutic: ―Laꞌ veꞌanic ―xijyutcutic. Joꞌoncutic li yajchanbalajeltacuncutique muc buchꞌu junucal la sjacꞌ cuꞌuncutic ti buchꞌue yuꞌun icojtaquincutic xa ti jaꞌ li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Li Jesuse la stam li pane, laj yacꞌbuncutic, joꞌoncutic li yajchanbalajeltacuncutique. Laj yacꞌbuncutic nojtoc li voꞌbil choye. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jaꞌ yoxibal xaꞌox velta iyacꞌ sba ta ilel ta jtojolcutic li Jesuse li cꞌalal chaꞌcuxiem xaꞌox loqꞌuel ta chꞌene. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cꞌalal ilaj coꞌoncutic ta veꞌele, li Jesuse jech laj yalbe li Simón Pedroe: ―Simón, snichꞌonot Jonás, cꞌuxun ta yoꞌonic la achiꞌiltac ta cajchanbalajeltac liꞌi. ¿Mi joꞌot más chital ta scꞌuxul avoꞌon? ―xut. Itacꞌav li Pedroe: ―Cajval, xanaꞌ onoꞌox ti cꞌuxot ta coꞌone ―xut. Li Jesuse jech laj yalbe: ―Alanbo me jcꞌop scotol li buchꞌutic jaꞌ to ta schꞌunic ti joꞌon Yajcoltavanejicune yoꞌ jech acꞌo ayanuc stsatsal yoꞌonic, jech mu xchibaj yoꞌonic ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Li Jesuse jech la sjacꞌbe schibal velta: ―Simón, snichꞌonot Jonás, ¿mi cꞌuxun ta avoꞌon? ―xut. Itacꞌav li Pedroe: ―Cajval, xanaꞌ onoꞌox ti cꞌuxot ta coꞌone ―xut. Li Jesuse jech laj yalbe: ―Chabibun me scotol li buchꞌutic schꞌunojic xa ti joꞌon Yajcoltavanejicune ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Li Jesuse jech la sjacꞌbe yoxibal velta: ―Simón, snichꞌonot Jonás, ¿mi cꞌuxun ta avoꞌon? ―xut. Li Pedroe iyat yoꞌon yuꞌun yoxibal xa velta ijacꞌbat: “¿Mi cꞌuxun ta avoꞌon?” ti xꞌutate. Itacꞌav li Pedroe: ―Cajval, anaꞌoj scotol. Anaꞌoj xa onoꞌox ti cꞌuxot ta coꞌone ―xut. Li Jesuse jech laj yalbe: ―Alanbo me jcꞌop scotol li buchꞌutic schꞌunojic xa ti joꞌon Yajcoltavanejicune yoꞌ jech acꞌo ayanuc más stsatsal yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Melel li cꞌusi chacalbee. Li cꞌalal biqꞌuitot toꞌoxe mu cꞌusi tsots la avaꞌi. Atuc la alap apacꞌal, buyuc noꞌox scꞌan avoꞌon labat. Pero ta sta scꞌacꞌalil ti cꞌalal molot xaꞌoxe, chachuque. Ajavaoj acꞌob ta teꞌ chacham ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Li Jesuse jaꞌ laj yacꞌbe snaꞌ li cꞌu sba ta xcham li Pedroe yoꞌ jech ta xacꞌ ta ichꞌel ta mucꞌ li Diose. Li Jesuse jech laj yalbe nojtoc li Pedroe: ―Ichꞌun o me ta mucꞌ ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Li Pedroe iyil ti te tijilun talel ta spatique, joꞌon ti toj cꞌuxun ta yoꞌon li Jesuse, joꞌon ti te chotolun ta xocon Jesús li cꞌalal lijveꞌcutique. Jaꞌ o ti cꞌalal la jacꞌbe Jesús ti buchꞌu junucal ta xꞌacꞌvan ta cꞌabale. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cꞌalal liyil li Pedroe, jech la sjacꞌbe li Jesuse: ―Cajval, li jchiꞌil liꞌi ¿cꞌu sba ta xcham eꞌuc? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Itacꞌav li Jesuse: ―Mi ta jcꞌan ti cuxul to chjul jta li cꞌalal chichaꞌtal nojtoque, mu aventauc. Li joꞌote ichꞌun o me ta mucꞌ ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ta ora ipuc jcꞌoplal ta stojol li quermanotactic, jaꞌ li buchꞌutic coꞌol quichꞌojtic ta mucꞌ li Jtotic Diose. Iyaꞌiic ti muc bu chicham ti yalojique. Li Jesuse muc bu iyal ti muc bu chichame. Jaꞌ noꞌox jech laj yal: “Mi ta jcꞌan ti cuxul to chjul jta cꞌalal chichaꞌtal nojtoque, mu aventauc”, ti xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Scotol li cꞌustic la jtsꞌiba liꞌi iquil jtuc, icaꞌi jtuc, joꞌon li Juanune, joꞌon li yajchanbalajelun li Jesuse. Melel ti jech la spas, ti jech iyal li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Toj ep li cꞌustic la spas li Jesuse. Ti iyichꞌuc tsꞌibael ta jun scotol li cꞌustic la spase, toj ep libroetic oy ti jechuque. Li cꞌu yepal iyichꞌ tsꞌibael liꞌi, xuꞌ chijcolutic o sbatel osil.");
INSERT INTO tzoSA_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, li jun li la jtsꞌibabot baꞌie, joꞌon li Lucasune, laj calbot xa scotol li cꞌustic sba la spas li Jesuse schiꞌuc li cꞌu sba ichanubtasvan cꞌalal liꞌ toꞌox oy ta balumile. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Li avie yan xa o li cꞌusi chacalbee. Cꞌalal muc toꞌox bu muyem batel ta vinajel li Jesuse, ta sventa li Chꞌul Espíritue laj yalbe comel mantal li yajtacbalaltaque, jaꞌ li yajchanbalajeltac ti tꞌujbil onoꞌox yuꞌune. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cꞌalal chaꞌcuxiem xaꞌoxe, laj yacꞌ sba ta ilel ta stojolic li yajchanbalajeltaque. Chaꞌvinic cꞌacꞌal laj yacꞌulan sba ta ilel ta stojolic, jaꞌ isnaꞌic o ti ta melel chaꞌcuxieme. Iꞌalbatic cꞌu sba ta sventainic li yabtel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cꞌalal te toꞌox schiꞌuc li yajchanbalajeltac li Jesuse, xi laj yalbe: ―Mu to me xaloqꞌuic batel liꞌ ta Jerusalene. Malaic chavichꞌbanic li Chꞌul Espíritu ti yaloj onoꞌox li Jtotic ti chacacꞌbeic jech chac cꞌu chaꞌal calojboxuc onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Li Juane jaꞌ laj yacꞌboxuc avichꞌic joꞌ. Pero jutuc xa scꞌan xcꞌot scꞌacꞌalil chacacꞌbe avichꞌic li Chꞌul Espíritue ―xi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cꞌalal te tsobolic schiꞌuc li yajtacbalaltac li Jesuse, jech la sjaqꞌuic: ―Cajval, ¿mi ista xa scꞌacꞌalil ti chavacꞌ ta jpas jbacutic ta mantal jtuccutic nojtoc, joꞌoncutic li jꞌisraeluncutique? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Itacꞌav li Jesuse: ―Li joꞌoxuque mu aventaicuc cꞌu ora. Jaꞌ snaꞌoj stuc li Jtotique yuꞌun jaꞌ sventainoj scotol. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero cꞌalal mi la avichꞌic xa li Chꞌul Espíritue, jaꞌ chata o stsatsal avoꞌonic ta stojol li Diose. Chapucbecun jcꞌop liꞌ ta jteclum Jerusalene, schiꞌuc liꞌ ta Judea balumile, schiꞌuc ta Samaria balumil, ta spꞌejel balumil. Jaꞌ noꞌox chapasic liꞌi ―xi comel li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cꞌalal iyal jech li Jesuse, li yajtacbalaltaque iyilic imuy batel li Jesuse. Iyilic imaque muyel ta toc, jech muc xa bu xilic yuꞌun imac ta toc. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cꞌalal sqꞌuelojic muyel ta vinajel li bu imuy batel li Jesuse, iyilic ta ora te vaꞌajtic chaꞌvoꞌ viniquetic yilel, jaꞌ yajꞌangeltac Dios. Sac scꞌuꞌ schaꞌvaꞌalic. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Li chaꞌvoꞌique xi laj yalic: ―Jgalileal viniquetic, ¿cꞌu chaꞌal chaqꞌuelic muyel li vinajele? Li Jesús li avilic imuy batel ta vinajele, jaꞌ noꞌox jech ta xchaꞌsut talel nojtoc jech chac cꞌu chaꞌal imuy batel avilique ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Li cꞌalal imuy batel ta vinajel li Jesuse, jaꞌ o te oyic ta vits Olivatic schiꞌuc li yajtacbalaltaque. Li vits Olivatique nopol noꞌox xil sbaic schiꞌuc li Jerusalene. Jaꞌ noꞌox jech snamal jech chac cꞌu chaꞌal li snamal ti xuꞌ chanavic ta scꞌacꞌalil chcuxic li jꞌisraeletique. Jech isutic batel ta Jerusalén li jtacbalaletique. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cꞌalal icꞌotic ta Jerusalene, te iꞌochic batel ta schaꞌcojol na ti bu schꞌamunojique. Jaꞌ li Pedro, schiꞌuc Jacobo, schiꞌuc Juan, schiꞌuc Andrés, schiꞌuc Felipe, schiꞌuc Tomás, schiꞌuc Bartolomé, schiꞌuc Mateo, schiꞌuc li otro jun Jacobo nojtoque, jaꞌ li snichꞌon Alfeoe. Schiꞌuc Simón, jaꞌ li la schiꞌin toꞌox li jzeloteetique. Schiꞌuc Judas, jaꞌ yitsꞌin li Jacoboe. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jmoj tsobolic, coꞌol yoꞌonic la staic ta naꞌel Dios ta jujun cꞌacꞌal. Te schiꞌuquic nojtoc jayvoꞌ antsetic, schiꞌuc María li smeꞌ li Jesuse, schiꞌuc li yitsꞌinab li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ta yan o cꞌacꞌal cꞌalal te tsobolic li buchꞌutic coꞌol quichꞌojtic ta mucꞌ Cajvaltic jchiꞌuctique, oy nan vacvinicuc (120) li te tsobolique, la svaꞌan sba ta oꞌlol li Pedroe, jech laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Jchiꞌiltac, icꞌot onoꞌox ta pasel li cꞌusi tsꞌibabil comel ta scꞌop Dios ta voꞌone li cꞌalal ichꞌamunbat ye David yuꞌun li Chꞌul Espíritue. Jaꞌ laj yal li cꞌusi icꞌot xa ta pasel ta stojol li Judase. Jaꞌ li buchꞌu ti laj yicꞌ batel li buchꞌutic la schuquic li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jaꞌ jununcutic li yajchanbalajeltacuncutic toꞌox Jesús li Judase. Coꞌol toꞌox quichꞌoj cabtelcutic yuꞌun li Jesuse ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Cꞌalal laj yacꞌ ta cꞌabal Jesús li Judase, iꞌacꞌbat taqꞌuin. Pero más to tsꞌacal ba sutes li taqꞌuine, jaꞌ la smanic o osil. Li Judase jaꞌ te ba sjocꞌan sba lajuc. Jaꞌ noꞌox ti muc bu te xjipet icom jech chac cꞌu chaꞌal snopoje. Itsꞌuj yalel ta balumil, pajal icꞌot sjol. Itꞌom schꞌut, toj loqꞌuel scotol sbiquil. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iyaꞌianic scotolic li buchꞌutic te nacalic ta Jerusalene, jech Acéldama laj yacꞌbeic sbi li osile. Jaꞌ yosil chꞌichꞌ smelol. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jech laj yal nojtoc li Pedroe: ―Jech onoꞌox tsꞌibabil scꞌoplal ta scꞌop Dios ta Salmos: Acꞌo mu xnaquiic tey, acꞌo pasuc o ta yavna, xi tsꞌibabil. Jech tsꞌibabil nojtoc ti acꞌo batuc ta yan li yabtele. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Jaꞌ yuꞌun persa ta jtꞌujbetic sqꞌuexol. Jaꞌ ta jtꞌujtic junuc li buchꞌutic ti liꞌ onoꞌox jchiꞌuctique, ti scotol cꞌacꞌal la jchiꞌincutic schiꞌuc li Cajvaltic Jesuse, ti coꞌol lijxanavcutic jchiꞌucutique, yoꞌ jech coꞌol ta jpucbecutic batel scꞌoplal ti chaꞌcuxiem xa li Jesuse. Jaꞌ ta jtꞌujtic junuc li buchꞌutic coꞌol iquilcutic ti iꞌacꞌbat yichꞌ joꞌ yuꞌun Juan li Jesuse, schiꞌuc ti cꞌalal to iquilcutic imuy batel ta vinajele ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","La stꞌujic chaꞌvoꞌ. Jaꞌ José Barsabás, Justo li schaꞌmojol sbie. Li june Matías sbi. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Xi la staic ta naꞌel Dios: ―Cajval, joꞌot aqꞌuelojbe yoꞌonic scotol li crixchanoetique. Li chaꞌvoꞌic liꞌi acꞌbun quilcutic buchꞌu junucal ti tꞌujbil avuꞌune, yoꞌ jech ta xꞌoch ta avabtel sventa ta spuc acꞌop. Yuꞌun jaꞌ ta stsacbe li yabtel toꞌox li Judase. Yuꞌun li Judase laj yicta avabtel jech ichꞌay o sbatel osil ―xi laj yalbeic Dios. ");
INSERT INTO tzoSA_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lic spasic canal tajimol, jaꞌ icꞌot ta stojol li Matíase. Jech icom ta schiꞌilic li buluchvoꞌique, jaꞌ jech ipasic ta lajchavoꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cꞌalal icꞌot scꞌacꞌalil qꞌuin Pentecostese, te jmoj tsobolic ta jun na li lajchavoꞌique schiꞌuc scotol li buchꞌutic schꞌunojic ti jaꞌ Jcoltavanej li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Iyaꞌiic ta ora ti oy cꞌusi tsots inic ta vinajele. Solel xjumumet iyaꞌiic jech chac cꞌu chaꞌal tsatsal icꞌ. Scotolic iyaꞌiic ti bu chotolique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Coꞌol schiꞌuc yat cꞌocꞌ iyilic, te cꞌot spuc sba ta sjolic jujunic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Scotolic iꞌoch ta yoꞌonic li Chꞌul Espíritue. Lic cꞌopojicuc ta yan o cꞌopetic ti iꞌacꞌbat snaꞌic yuꞌun li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Te talemic ta Jerusalén nojtoc li jꞌisraeletic li spucoj sbaic batel ta yantic o balumile, jaꞌ li lec yichꞌojic ta mucꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cꞌalal iyaꞌiic li cꞌusi xjumumete, la stsob sbaic talel scotolic ta ora. Toj chꞌayel yoꞌonic yuꞌun naca ta scꞌop jujuntal stuquic icꞌoponatic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Laj yalbe sbaic: ―Scotolic li buchꞌutic liꞌ ta xcꞌopojique, ¿mi maꞌuc jchiꞌiltic li te liquemic talel ta Galileae? ");
INSERT INTO tzoSA_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cꞌu chaꞌal ta xcaꞌitic ta jcꞌop jtuctic jujuntalutic li bu voqꞌuemutique? ¿Cꞌuxi ischanic li jcꞌoptique? ");
INSERT INTO tzoSA_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yuꞌun ep ta chop liꞌ talemutic ta qꞌuine. Oy liquemutic talel ta Partia balumil, oy liquemutic talel ta Media balumil, schiꞌuc ta Elám balumil, schiꞌuc oy te liquemutic talel ta Mesopotamia balumil, schiꞌuc liꞌ ta Judea balumil, schiꞌuc ta Capadocia balumil, schiꞌuc ta Ponto balumil, schiꞌuc ta Asia balumil. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Schiꞌuc oy liquemutic talel ta Frigia balumil, schiꞌuc ta Panfilia balumil, schiꞌuc ta Egipto balumil, schiꞌuc ta Africa balumil li te ta jelavel jteclum Cirenee. Oy te liquemic talel ta jteclum Roma ti jech schꞌunojic jech chac cꞌu chaꞌal jchꞌunojtic li joꞌotique. Oy talemic eꞌuc li jchiꞌiltactic li te xa nacalic ta Romae. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oy buchꞌutic liquemic talel ta Creta balumil schiꞌuc ta Arabia balumil. Pero jcotoltic ta xcaꞌitic ta jcꞌoptic li cꞌustic lec ti achꞌ to la spas li Diose ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Toj chꞌayel noꞌox yoꞌonic scotolic, mu snaꞌic cꞌu chaꞌal ti jech icꞌot ta pasele. Xi laj yalbe sbaic: ―¿Cꞌusi smelol xanaꞌ? ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Oy yan ti ilabanvanique, xi laj yalic: ―Yuꞌun nan chyacubic ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Li Pedroe la svaꞌan sbaic schiꞌuc li buluchvoꞌ schiꞌiltaque, jech tsots lic yal li Pedroe: ―Jchiꞌiltac, joꞌoxuc li liꞌ nacaloxuc ta Judea balumile schiꞌuc joꞌoxuc li liꞌ talemoxuc ta Jerusalene, aꞌiic li cꞌusi chcale. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Muc bu chijyacubcutic jech chac cꞌu chaꞌal chavalique yuꞌun jaꞌ to ista baluneb ora li cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Li cꞌusi chavilique yuꞌun jaꞌ icꞌot xa ta pasel li cꞌusi laj yal Joel li iyal scꞌop Dios ta voꞌonee. Jech laj yal: Jech laj yalbun li Diose, xi li Joele. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Cꞌalal poꞌot xa slajeb cꞌacꞌale, chcacꞌbe yichꞌanic li Chꞌul Espíritu ep crixchanoetic ta spꞌejel balumil. Chlic spucbecun jcꞌop la anitilul atsacalulique. Li bu svaꞌlej xa squeremique chcacꞌbe yilic li cꞌusi lec ti acꞌo spasique. Li moletic yuꞌunique oy cꞌusi chcacꞌbe yilic ta svaychilic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chcacꞌbe yichꞌic li Chꞌul Espíritu cuꞌune li buchꞌutic chiyichꞌic ta muqꞌue, acꞌo mi vinic, mi ants. Chispucbeic li jcꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ta xcacꞌ talel ti vocole, ti labale, ta vinajel schiꞌuc ta balumil; jaꞌ chꞌichꞌ, schiꞌuc cꞌocꞌ, schiꞌuc ep schꞌailal. Chlaj xiꞌuquic o li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta xmac sat li cꞌacꞌale, chcom ta icꞌal acꞌubal. Li ue ta stsajub jech chac cꞌu chaꞌal chꞌichꞌ. Jaꞌ jech ta xcꞌot ta pasel cꞌalal poꞌot xa chcꞌot scꞌacꞌalil chquichꞌbe scꞌop scotol li crixchanoetique. Jaꞌ xa o chvinaj li buchꞌutic chcolique schiꞌuc li buchꞌutic ta xchꞌayic o sbatel osile. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Scotol li buchꞌutic ta scꞌanic coltaele jaꞌ chcolic, xi laj yal li Diose, xi li Joele. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jchiꞌiltac, aꞌiic li cꞌusi ta xcale. Joꞌotic li jꞌisraelutique, acꞌo jnaꞌtic ti ep laj yacꞌ ta ilel stsatsal sjuꞌel li Jesús ti te liquem talel ta Nazarete. Iquiltic la spas ta jtojoltic. Toj chꞌayel o coꞌontic. Te iquiltic o ti melel jaꞌ acꞌbil yabtel yuꞌun li Diose, yuꞌun scotol ijuꞌ yuꞌun ta sventa stsatsal sjuꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Li Jesuse iꞌaqꞌue ta cꞌabal yuꞌun jech onoꞌox snopoj ta voꞌone li Diose. Joꞌoxuc la atsaquic, la avaqꞌuic ta milel ta cruz ta stojol li buchꞌutic muc bu yichꞌojic ta mucꞌ li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero li Diose la schaꞌcuxes loqꞌuel ta smuquenal yuꞌun mu xlaj o ta jꞌechꞌel. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yuꞌun li jtotic jmeꞌtic David ta voꞌonee xi laj yalbe li Diose: Achiꞌinojun scotol cꞌacꞌal. Liꞌ oyot ta jpat ta jxocon, jech mu cꞌu chal coꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jech ximuybaj noꞌox chcalbe yaꞌiic jchiꞌiltac ti quiloj ta alequilale. Acꞌo mi xicham pero jnaꞌoj ti chachaꞌcuxesune. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Muc bu te chavicta li jchꞌulel li yoꞌ bu oy schꞌulelic li buchꞌutic muc bu yichꞌojicot ta muqꞌue. Muc bu chavacꞌ xcꞌaꞌ li jbecꞌtale, joꞌon la anichꞌonune, yuꞌun toj cꞌuxun ta avoꞌon. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","La avacꞌbun xa jnaꞌ ti chicuxi o sbatel osil ta aventae. Jech ximuybaj noꞌox ta atojol sbatel osil, xi la scꞌopon Dios li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Jchiꞌiltac, jnaꞌojtic ti maꞌuc scꞌoplal stuc li iyal li Davide yuꞌun li Davide icham, la smuquic. Jnaꞌojtic ti liꞌ oy li smuquenale. Li cꞌusi iyal David li cꞌalal la sta ta naꞌel li Diose, jaꞌ scꞌoplal li Cajvaltique yuꞌun jech la scꞌopon Stot li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Li Davide yuꞌun noꞌox ichꞌamunbat ye, yuꞌun jaꞌ jun li buchꞌu iyal scꞌop Dios ta voꞌonee. Schiꞌuc iꞌalbat yuꞌun Dios ti jun snitilul ta xcom ta sqꞌuexole yuꞌun jaꞌ ta xꞌoch ta ajvalilal cuꞌuntic, joꞌotic li jꞌisraelutique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jaꞌ yuꞌun laj yalbe scꞌoplal ti ta persa ta xchaꞌcuxi li Cristoe, ti muc bu ta xcom schꞌulel li yoꞌ bu oy schꞌulelic li buchꞌutic muc bu yichꞌojic ta mucꞌ li Diose, schiꞌuc ti muc bu ta xcꞌaꞌ li sbecꞌtale. Jech onoꞌox icꞌot ta pasel. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios la schaꞌcuxes li Jesuse. Joꞌoncutic iquilcutic jcotolcutic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta stsatsal sjuꞌel Dios iꞌiqꞌue muyel ta vinajel li Jesuse. Te xa chotol ta sbatsꞌicꞌob li Diose. Albil xa onoꞌox yuꞌun li Jtotic Dios ti ta stac talel li Chꞌul Espíritue. Jaꞌ li laj xa quichꞌcutique. Avilic xa, avaꞌiic xa eꞌuc li joꞌoxuque. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Li Davide muc bu xmuy batel ta vinajel schiꞌuc sbecꞌtal, pero jech laj yal: Li Cristoe xi iꞌalbat yuꞌun li Jtotic Diose: “Chachoti ta jbatsꞌicꞌob, chapas mantal jaꞌ to mi la jpas ta canal scotol la avajcontrataque”, xꞌutat li Cristoe, xi li Davide. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Acꞌo jnaꞌtic jcotoltic, joꞌotic li jꞌisraelutique, li Jesús ti la avaqꞌuic ta milel ta cruze, jaꞌ tꞌujbil onoꞌox yuꞌun Dios ti ta xꞌoch ta mucꞌta ajvalilal schiꞌuc ta Jcoltavanej yuꞌun scotol crixchanoetic ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cꞌalal iyaꞌiic li schiꞌiltac li cꞌusi laj yal li Pedroe, toj echꞌem iyat o yoꞌonic ta scoj li smulique. Jech ijacꞌbatic li Pedro schiꞌuc li schiꞌiltac ta puc‐cꞌope: ―Jchiꞌiltac, ¿cꞌusi scꞌan ta jpascutic? ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Li Pedroe xi iyal: ―Ictaic scotol li cꞌustic chopol chapasique. Ichꞌic joꞌ ta jujuntal ta sventa li Jesucristoe, jech chaspasboxuc perton yuꞌun amulic. Jech chayacꞌboxuc li Chꞌul Espíritu li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yuꞌun li Dios cuꞌuntique yaloj onoꞌox ti jaꞌ ta xichꞌic li Chꞌul Espíritu li buchꞌutic ta schꞌunic iqꞌuel yuꞌun li Diose. Jech xuꞌ chavichꞌic eꞌuc. Xuꞌ ta xichꞌic li jnichꞌnabtique. Xuꞌ ta xichꞌic eꞌuc cꞌalal mi la schꞌunic iqꞌuel yuꞌun Dios li buchꞌutic maꞌuc jchiꞌiltic ta israelale ―xi li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oy to ep cꞌusi yan laj yal li Pedroe. Xi laj yalbe mantal scotolic: ―Acꞌ abaic ta scꞌob li Diose yoꞌ cꞌuxi mu xachꞌayic o sbatel osil jech chac cꞌu chaꞌal ti ta xchꞌayic o li buchꞌutic mu xacꞌ sbaic ta scꞌob li Diose ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Li buchꞌutic la schꞌunic li cꞌusi laj yal li Pedroe laj yichꞌic joꞌ. Oxmil schiꞌiltac la schꞌunic ta jun noꞌox cꞌacꞌal. Jech iꞌepajic li buchꞌutic iyichꞌic ta mucꞌ li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ta sloqꞌuel yoꞌonic la schanic ti cꞌu sba iꞌalbatic yuꞌun li yajtacbalaltac li Jesuse. Jmoj yoꞌonic scotolic jech xmuybajic noꞌox. Te la schiꞌin sbaic ta stael ta naꞌel Dios. Ta sloqꞌuel yoꞌonic la spasic jech chac cꞌu chaꞌal laj yacꞌ ta ilel li Cajvaltic ti cꞌalal la xut li pane schiꞌuc ti cꞌalal iꞌacꞌbatic yuchꞌic li yaꞌlel tsꞌusub li yajchanbalajeltaque. Jaꞌ noꞌox jech la spasic eꞌuc yuꞌun snaꞌic ti jaꞌ ta scojic ti ichame. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Scotolic yacꞌoj ta yoꞌonic ti te oy Dios ta stojolique, yuꞌun li yajtacbalaltac li Jesuse ep laj yacꞌbeic ta ilel stsatsal sjuꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Li buchꞌutic la schꞌunic ti jaꞌ Jcoltavanej li Cajvaltique, coꞌolcoꞌol la scoltaan sbaic, la spuquilanbe sbaic li cꞌustic oy yuꞌunic jujunique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Cꞌalal iyilic ti mu cꞌusi oy yuꞌunic li yanetique, li buchꞌutic oy yosilique la schonic. Schiꞌuc mi oy cꞌustic yan yuꞌunic li jujunique, la schonanic. Li stojole jaꞌ laj yacꞌanbeic li buchꞌutic mu cꞌusi xꞌayan yuꞌunique. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Scotol cꞌacꞌal la stsob sbaic ta yamaqꞌuil li mucꞌta chꞌulna li te ta Jerusalene. Te ta snaic la xutic pan schiꞌuc laj yuchꞌic yaꞌlel tsꞌusub. Jaꞌ snaꞌobil ti icham li Cajvaltic ta scoj li jmultique. Xmuybajic noꞌox scotolic, coꞌol iveꞌic. Jun yoꞌon scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Laj yalbeic slequilal Dios. Lec iꞌileic yuꞌun scotol li buchꞌutic muc to bu schꞌunojique. Ta jujun cꞌacꞌal iꞌepajic yuꞌun iꞌiqꞌueic yuꞌun li Cajvaltic li buchꞌutic iscꞌanic coltaele. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Li Pedro schiꞌuc li Juane ba staic ta naꞌel Dios ta yamaqꞌuil li mucꞌta chꞌulnae. Ta oxib ora stsꞌepꞌujel cꞌacꞌal ibatic, yuꞌun jaꞌ yorail ta staic ta naꞌel Dios scotol li schiꞌiltaquique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te istaic jun schiꞌilic pecꞌa yuꞌun jech onoꞌox voqꞌuem. Cuchbil talel yuꞌunic. Scotol cꞌacꞌal te ta scuchic talel ta mucꞌta chꞌulna. Te ta schotanic ta stiꞌ smacol li mucꞌta chꞌulna ti Toj Lec Sba sbie. Yuꞌun te chcꞌanolaj. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Li pecꞌae cꞌalal iyil ti te ta xꞌochic ta yamaqꞌuil li mucꞌta chꞌulna li Pedro schiꞌuc li Juane, la scꞌan smoton taqꞌuin. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Li Pedro schiꞌuc li Juane la sqꞌuelbeic sat li pecꞌae, jech laj yal li Pedroe: ―Qꞌueluncutic ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Li pecꞌae la sqꞌuel, la smala mi oy cꞌusi ta xꞌacꞌbat. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jech laj yal li Pedroe: ―Muꞌyuc jtaqꞌuin pero oy cꞌusi chacacꞌbe. Jaꞌ ta sventa li Jesucristo li liquem talel ta Nazarete vaꞌlan, xanavan ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Li Pedroe la stsacbe sbatsꞌicꞌob li pecꞌae, la snit liquel. Itsatsub ta ora schibal li yoque. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ipꞌit, vaꞌal icꞌot, lic xanavuc. La schiꞌinelic ochel ta yamaqꞌuil li mucꞌta chꞌulna yuꞌun li pecꞌae. Te xpꞌitpꞌun ochel yuꞌun xmuybaj tajmec. Te iyalulan ti iyilbe xa slequilal li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Li cꞌu yepal te oyic li crixchanoetique iyilic ti ta xanav xa li pecꞌa vinic toꞌoxe, schiꞌuc ti ta xalulanbe slequilal Dios. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iyojtaquinic ti jaꞌ li jcꞌanolajel li te onoꞌox xchotet ta stiꞌ smacol li mucꞌta chꞌulna ti Toj Lec Sba sbie. Toj chꞌayel noꞌox yoꞌonic li crixchanoetic li cꞌalal iyilic ti colem xa li pecꞌa toꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te ta stentennail li mucꞌta chꞌulna li Salomón sbie, jaꞌ te vaꞌalic li Pedro schiꞌuc li Juane. Te schiꞌuquic li pecꞌa ti colem xae yuꞌun muc bu xꞌictavan. Li crixchanoetique toj chꞌayel noꞌox yoꞌonic ti colem xae. Istsob sbaic ta ora scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cꞌalal iyil Pedro ti te xa tsobol scotolique, xi laj yal: ―Jchiꞌiltac, ¿cꞌu chaꞌal toj chꞌayel o avoꞌonic? ¿Cꞌu chaꞌal chapajuncutic ta qꞌuelel? Mu me xanopic ti ta jtsatsalcutic, ta jlequilalcutic jtuccutic ti icol li vinic li ta xanav xae. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Li Dios yuꞌunic li jtotic jmeꞌtic ta voꞌonee, jaꞌ li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove, laj yacꞌ ta ilel ti tsots yabtel yichꞌoj li Snichꞌone, jaꞌ li Jesús ti la avaqꞌuic ta scꞌob li Pilatoe. Cꞌalal iyal Pilato ti ta scoltae, li joꞌoxuque muc xachꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Muc bu la acꞌanbeic scolel li buchꞌu muꞌyuc smule, ti tucꞌ yoꞌone. Jaꞌ la acꞌanbeic scolel li jmilvaneje. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jaꞌ la avaqꞌuic ta milel li buchꞌu chijyacꞌbutic jcuxlejaltic sbatel osile. Pero ichaꞌcuxesat yuꞌun li Diose. Melel li cꞌusi chcalcutique yuꞌun joꞌoncutic iquilcutic. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jchꞌunojcutic ti scotol xuꞌ yuꞌun li Jesuse. Jaꞌ ta sventa stsatsal sjuꞌel Jesús ti icol o li pecꞌa li liꞌ chavilic ti xavojtaquinic onoꞌoxe. Yuꞌun la jchꞌuncutic ti chcol yuꞌun li Jesuse, jech icol o li vinic li liꞌ vaꞌal chavilique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Jchiꞌiltac, jnaꞌoj ti tscoj ti muc bu xavaꞌibeic smelol ti jech la avaqꞌuic ta milel li Jesuse. Jech nojtoc muc bu xaꞌibeic smelol eꞌuc li jꞌabteletic cuꞌuntique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yuꞌun jaꞌ icꞌot ta pasel li cꞌusi yaloj onoꞌox Dios cꞌalal la schꞌamunbe ye li buchꞌutic iyalic scꞌop Dios ta voꞌonee. Iyalic onoꞌox ti ta persa ta xcham li Cristo li tꞌujbil yuꞌun Dios ti chisventainutique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaꞌ lec ictaic scotol li cꞌustic chopol chapasique. Acꞌ abaic ta scꞌob li Diose jech chaspasbeic perton yuꞌun la amulique. Jech ta xacꞌ li Cajvaltic ti xamuybajic noꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Li Diose ta stac talel nojtoc li Jesuse, jaꞌ li tꞌujbil yuꞌun Dios ti chisventainutique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Li Jesucristoe te xa oy ta vinajel. Jaꞌ to ta xtal cꞌalal mi icꞌot scꞌacꞌalil ta spas ta achꞌ scotol yuꞌun li Diose, jech chac cꞌu chaꞌal iyalic li buchꞌutic iyalic scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Li Moisese xi laj yalbe li jtotic jmeꞌtic ta voꞌonee: “Li Dios cuꞌuntique ta xlic yuꞌun jun li buchꞌu ta xal li scꞌop Dios li ta jchiꞌiltique jech chac cꞌu chaꞌal listꞌuje. Ichꞌbeic me ta mucꞌ li cꞌusi chayalbeique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Li buchꞌu mu xichꞌ ta mucꞌ li cꞌusi ta xale, acꞌo locꞌuc ti bu nacaloxuque”, xi li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Jech onoꞌox iyal eꞌuc li Samuel li iyal scꞌop Dios ta voꞌonee, ti jech ta xcꞌot ta pasel jech chac cꞌu chaꞌal icꞌot xa ta pasel ta jtojoltique. Jech iyalic nojtoc li yan li buchꞌutic iyalic scꞌop Dios ti tsꞌacal to italique. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Joꞌotic jaꞌ snitilulutic li buchꞌutic iyalic scꞌop Dios ta voꞌonee, jaꞌ cuꞌuntic eꞌuc li cꞌusi iꞌalbatic li jtotic jmeꞌtic ta voꞌone yuꞌun li Diose. Yuꞌun li Diose xi laj yalbe li Abrahame: “Ta sventa anitilul chichꞌ slequil yutsilalic li crixchanoetic ta spꞌejel balumile”, xꞌutat Abraham yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jech li Diose baꞌi la stac talel liꞌ ta jtojoltic li Snichꞌone, yuꞌun tal scoltautic yoꞌ xuꞌ chquictatic li cꞌustic chopol ta jpastic jujunutique ―xut schiꞌiltac li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Cꞌalal te toꞌox yacalic ta loꞌil schiꞌuquic li crixchanoetic li Pedro schiꞌuc li Juane, te italic jayvoꞌ paleetic schiꞌuc li banquilal yuꞌunic li yajmayoltac li paleetique. Italic eꞌuc jayvoꞌ jsaduceoetic, jaꞌ li buchꞌutic chalic ti muꞌyuc chaꞌcuxesele. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Soquet o sjolic ta sventa li cꞌusi ta xchanubtasvanic o li Pedro schiꞌuc li Juane. Yuꞌun chalic ti ta xchaꞌcuxi li ánimaetic jech chac cꞌu chaꞌal ichaꞌcuxi li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Te la stsaquic li Pedro schiꞌuc li Juane, la stiqꞌuic ta chuquel. La snopic ti ta yocꞌomal to ta smeltsanbeic scꞌoplale yuꞌun mal xaꞌox cꞌacꞌal ti la schuquique. Li chucvanab yuꞌunique te tsacal ta mucꞌta chꞌulna. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero ep li buchꞌutic ischꞌunic li scꞌop Dios li laj yalic li Pedro schiꞌuc li Juane. Jech ipasic xa ta joꞌmil ta scotol li viniquetique schiꞌuc li buchꞌutic schꞌunojic xa onoꞌoxe. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta yocꞌomal la stsob sbaic ta Jerusalén li jꞌabteletic yuꞌunic li jꞌisraeletique. Li jꞌolole spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Te ital eꞌuc li Anase, jaꞌ li loqꞌuem banquilal palee, schiꞌuc li Caifase. Schiꞌuc otro chaꞌvoꞌ paleetic, Juan sbi schiꞌuc Alejandro. Schiꞌuc scotol schiꞌiltac li banquilal palee. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","La sloqꞌuesic ta chucvanab li Pedro schiꞌuc li Juane. La scacanic ta oꞌlol, jech la sjacꞌbeic: ―¿Buchꞌu ta smantal, buchꞌu ta sjuꞌel ti jech chapasique? ―xutic. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Li Pedroe iꞌacꞌbat spꞌijil yuꞌun li Chꞌul Espíritue, xi laj yal: ―Aꞌiic me, jꞌabteletic, juntotac. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Ti chajacꞌbuncutic ti cꞌu sba icol cuꞌuncutic li pecꞌa vinique, jaꞌ yuꞌun chacalbeic acotolic. Joꞌotic li jꞌisraelutique, acꞌo jnaꞌtic ti jaꞌ ta sjuꞌel li Jesucristo li liquem talel ta Nazarete ti icol li vinic li liꞌ oy ta atojolique. Jaꞌ li buchꞌu la avaqꞌuic ta milel ta cruze. Pero ichaꞌcuxesat yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Li joꞌoxuque jaꞌ jechoxuc jech chac cꞌu chaꞌal li jvaꞌanejnaetic ti la spꞌajic li ton ti la stꞌuj li yajval na sventa ta xacꞌ ta chiquin nae. Jaꞌ jechoxuc eꞌuc li joꞌoxuque. Muc bu xacꞌanic li buchꞌu tꞌujbil yuꞌun li Diose, jaꞌ li Jesuse, pero iꞌacꞌbat xa tsots yabtel yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Muc buchꞌu yan xuꞌ chiscoltautic, jaꞌ noꞌox li Jesucristoe. Yuꞌun muc buchꞌu yan albil scꞌoplal yuꞌun Dios ti xuꞌ chijcolutic yuꞌune ―xut li jꞌabteletic li Pedroe. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Cꞌalal iyilic li jꞌabteletic ti oy lec stsatsal yoꞌonic li Pedro schiꞌuc li Juane, toj chꞌayel noꞌox yoꞌonic yuꞌun snaꞌojic ti muc bu chanubtasbilic ta sventa smantaltac li Diose, schiꞌuc ti muc bu acꞌbilic yabtelique. Jaꞌ ijul o ta sjolic ti jaꞌ la schiꞌinic toꞌox li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yuꞌun te schiꞌuquic li vinic ti colem xa li pecꞌa toꞌoxe, jaꞌ yuꞌun mu cꞌusi xuꞌ ch‐albatic yuꞌun li jꞌabteletique li Pedro schiꞌuc li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Iꞌalbatic ti acꞌo loqꞌuicuc batel jliqueluque. Iloqꞌuic batel ta pana. Li jꞌabteletique lic snopic cꞌusi ta spasbeic li Pedro schiꞌuc li Juane. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Xi laj yalbe sbaic: ―¿Cꞌusi ta jpasbetic li viniquetique? Yuꞌun laj yacꞌbeic xa ta ilel stsatsal sjuꞌel Dios, yuꞌun icol yuꞌunic li vinique. Iyaꞌiic xa scotolic li buchꞌutic liꞌ nacalic ta Jerusalene. Mu xuꞌ chcaltic ti altique. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero yoꞌ acꞌo mu xpuc batel ta spꞌejel cosilaltique, jaꞌ lec tsots chcalbetic ti mu xa me spucbeic batel li scꞌoplal li Jesuse ―xut sbaic. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Laj yiqꞌuic ochel nojtoc li Pedro schiꞌuc li Juane. Tsots iꞌalbatic ti mu xa me xalic ba li scꞌoplal li Jesuse, schiꞌuc mu xa me xchanubtasvanic o ta sventa li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Itacꞌavic li Pedro schiꞌuc li Juane: ―Alic li bu jchopucal ti persa ta jchꞌuncutique. ¿Mi jaꞌ ta jchꞌuncutic la amantalique, mi jaꞌ ta jchꞌunbecutic smantal li Diose? ");
INSERT INTO tzoSA_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yuꞌun mu xuꞌ ta xquictacutic ta yalel li cꞌustic quilojcutique schiꞌuc li cꞌustic caꞌiojcutique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Li jꞌabteletique laj yalic nojtoc ti mu xa me spucbeic batel scꞌoplal li Jesuse, la scoltaic ba. Mu xuꞌ xꞌacꞌbat yichꞌic vocol li Pedro schiꞌuc li Juane yuꞌun li jꞌabteletique, yuꞌun ixiꞌic li ta schiꞌiltaquic ta israelale. Yuꞌun scotol schiꞌiltac laj yalic coliyal Dios ta sventa ti iyilic ti colem xa li pecꞌa vinique. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yichꞌoj xa más ta chaꞌvinic (40) jabil li vinic ti icol ta sventa stsatsal sjuꞌel li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cꞌalal icoltaatic batel li Pedro schiꞌuc li Juane, cꞌot slabanbeic li schiꞌiltaquic ta puc‐cꞌop scotol li cꞌustic iꞌalbatic yuꞌun li paleetique schiꞌuc li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cꞌalal iyaꞌiic jeche, jmoj xa yoꞌonic la staic ta naꞌel Dios: ―Cajval, joꞌot Diosot li la apas vinajel balumile, schiꞌuc li nabe, schiꞌuc scotol li cꞌustic oye. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Joꞌot la achꞌamunbe ye la avajtunel David ta voꞌonee. Ta sventa li Chꞌul Espíritue jech la stsꞌiba: Altic ti chlic stoy sbaic li crixchanoetique. Altic li cꞌustic chlic snopic stuquique. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Li ajvaliletique schiꞌuc li jꞌabteletic liꞌ ta balumile ta spas ta jmoj scꞌopic. Chlic scontrainic li Diose schiꞌuc li buchꞌu tꞌujbil yuꞌun Dios ti chisventainutique, xi onoꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ta melel jech icꞌot ta pasel yuꞌun liꞌ la stsob sbaic ta jteclum Jerusalén li Herodese, schiꞌuc li Poncio Pilatoe, schiꞌuc li yan crixchanoetic li maꞌuc jchiꞌiltacutic ta israelale, schiꞌuc li jchiꞌiltacutic ta israelale. La spas ta jmoj scꞌopic ti ta smilic la Achꞌulnichꞌon Jesús li avacꞌojbe yabtel ti chiscoltauncutique. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jaꞌ la spasbeic li cꞌusi anopoj onoꞌox ta voꞌonee yuꞌun jech la acꞌan atuc. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Cajval, tanae ta scꞌan chispajesuncutic, joꞌoncutic la avajtuneluncutique. Acꞌbun stsatsal jol coꞌoncutic ti mu xijxiꞌcutic ta yalel la acꞌope. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Acꞌo ta ilel atsatsal ti scotol xuꞌ chapase, acꞌo coluc cuꞌuncutic li jchamelajeletique. Acꞌbun cacꞌcutic ta ilel atsatsal ajuꞌel ta sventa la Achꞌulnichꞌon Jesuse ―xi la staic ta naꞌel Dios. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cꞌalal ilaj yoꞌonic ta stael ta naꞌel Diose, iyaꞌiic scotolic inic li na li yoꞌ bu tsobolique. Itsatsubtasbatic sjol yoꞌon scotolic yuꞌun li Chꞌul Espíritue. Jaꞌ yuꞌun jamal laj yalic echꞌel li scꞌop Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Li cꞌu yepal schꞌunojique jmoj yoꞌonic scotolic. Li buchꞌutic oy cꞌustic yuꞌunique muc bu xalic ti jaꞌ yuꞌun stuquique, ta comón yuꞌunic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Li yajtacbalaltac li Jesuse laj yalic ti ta melel ichaꞌcuxi li Cajvaltique. Oy smelol oy stuqꞌuil li scꞌopique jech icꞌot ta yoꞌonic li buchꞌutic yichꞌojic ta mucꞌ li Cajvaltique. Iꞌacꞌbat ep slequil yoꞌonic scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jaꞌ yuꞌun mu xa buchꞌu chichꞌ vocol yuꞌun scotol li buchꞌutic ti oy yosilique schiꞌuc li buchꞌutic ti oy snaique, ba schonic li cꞌalal iyilic ti mu xa cꞌusi oy yuꞌunic li schiꞌiltaquique. Laj yichꞌbeic talel li stojol li cꞌusi la schonique. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Te cꞌot yacꞌbe ta scꞌob li yajtacbalaltac li Jesuse. Li buchꞌutic mu xa cꞌusi oy yuꞌunique, jaꞌ iꞌacꞌbatic. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Te oy jun vinic, José sbi. Jaꞌ Bernabé iꞌacꞌbat sbi yuꞌun li yajtacbalaltac li Jesuse. Jaꞌ chistsatsubtasbutic coꞌontic, xi smelol li sbie. Jaꞌ jchipreal vinic. Li smucꞌta moltot ta voꞌonee Leví sbi. ");
INSERT INTO tzoSA_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Li Bernabée oy toꞌox yosil pero la schon. Laj yichꞌbe talel li stojol li yosile, laj yacꞌbe ta scꞌob li yajtacbalaltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oy jun vinic nojtoc, Ananías sbi. Safira sbi li yajnile. La schon jsetꞌ yosilic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Coꞌol la snopic schiꞌuc li yajnil ti mu tsꞌacluc ta xaqꞌuic li stojol li yosilique. Jech muc xichꞌ ba scotol li cꞌalal ba yacꞌbe ta scꞌob li yajtacbalaltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Li Pedroe xi laj yalbe li Ananíase: ―Ananías, ¿cꞌu chaꞌal la achꞌunbe smantal li banquilal pucuje, jaꞌ li Satanase, yuꞌun muc bu tsꞌacal la avacꞌ li stojol avosilique? La ajut cꞌop ta stojol li Chꞌul Espíritue. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Li osile jaꞌ avuꞌun atuc, jech mu persauc la achon ti jechuque. Ti la achone, joꞌot la anop atuc ti chavacꞌ li stojole. ¿Cꞌu chaꞌal la anop ti chavocꞌbe li stojole? Maꞌuc la ajut cꞌop ta stojol crixchano; jaꞌ la ajut cꞌop ta stojol Dios ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cꞌalal iyaꞌi li Ananíase, iyal ta lum, ilocꞌ schꞌulel ta ora. Toj xiꞌel icꞌotic scotolic li buchꞌutic iyaꞌiic ti ichame. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iliquic jayvoꞌ querem viniquetic, la spixbeic li sbecꞌtal stacupale, la scuchic loqꞌuel, ba smuquic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Oy xaꞌox ta oxib ora jaꞌ o iꞌoch talel eꞌuc li yajnile, jaꞌ li Safirae. Mu snaꞌ mi chamem xa li smalale. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Li Pedroe jech la sjacꞌbe: ―Albun mi jaꞌ noꞌox jech yepal li stojol avosilic li la achonique ―xut. ―Jaꞌ noꞌox jech yepal ―xi itacꞌav li antse. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Li Pedroe xi laj yalbe: ―¿Cꞌu chaꞌal toj jmoj anopic achiꞌuc la amalale yuꞌun la atoy abaic ta stojol li Chꞌul Espíritu ti junic schiꞌuc li Cajvaltique? Aꞌio, te xa xtalic ta patna li buchꞌutic a smuquic la amalale. Jaꞌ noꞌox jech chascuchic loqꞌuel eꞌuc ―xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Cꞌalal iyaꞌi li antse, iyal ta lum ta ora eꞌuc, ilocꞌ schꞌulel. Cꞌalal iꞌochic li querem viniquetique, chamem xa istaic nojtoc li antse. La scuchic loqꞌuel, ba smuquic. Jun schꞌenal schiꞌuc li smalale. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ixiꞌic scotolic li buchꞌutic yichꞌojic ta mucꞌ li Cajvaltique schiꞌuc li buchꞌutic yan ti iyaꞌiique. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Li yajtacbalaltac li Jesuse ep iyacꞌbeic ta ilel stsatsal sjuꞌel Dios ta stojol li crixchanoetique. Scotol cꞌacꞌal te la stsob sbaic ta stentennail li mucꞌta chꞌulna li yoꞌ bu Salomón sbie. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mu junuc buchꞌu icontrainvan. Scotolic lec iyilic li cꞌusi la spasic li yajtacbalaltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta jujun cꞌacꞌal iꞌepajic li buchꞌutic la schꞌunic ti jaꞌ Jcoltavanej li Cajvaltique. Ep viniquetic schiꞌuc antsetic la schꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Scotol jchamelajeletic la sloqꞌuesic talel schiꞌuc stemic schiꞌuc spopic, tal spuchꞌanic ta caya. Yuꞌun ta scꞌanic ti te ch‐echꞌ coltabaticuc yuꞌun li Pedroe. Yuꞌun la snopic mi mu xpaj li Pedroe, jaꞌ noꞌox la smalaic mi ta xcꞌot snacꞌubal ta sbaic li jchamelajeletique yoꞌ jech chcolic o. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ep italic nojtoc te ta Jerusalén li buchꞌutic te noꞌox nacalic ta yan jteclumetic ta nopol Jerusalene. Laj yiqꞌuic talel jchamelajeletic schiꞌuc li buchꞌutic ta xꞌilbajinatic yuꞌun li pucujetic ti ochem ta yoꞌonique. Pero icol scotolic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Li más banquilal palee schiꞌuc li buchꞌutic te schiꞌuc ti coꞌol jsaduceoetique, xtiꞌet noꞌox yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","La stsaquic li yajtacbalaltac li Jesuse, la yiqꞌuic batel ta cavilto, la stiqꞌuic ta chuquel. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ta acꞌubaltic ital jun yajꞌangel li Cajvaltique, la sjam li tiꞌ chucvanabe. La sloqꞌues batel li yajtacbalaltac li Jesuse, xi laj yalbe: ");
INSERT INTO tzoSA_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Batanic, ba vaꞌan abaic ta yamaqꞌuil li mucꞌta chꞌulnae. Albeic la achiꞌiltaquic ti xuꞌ ta xcolic sbatel osil ta sventa li Jesuse ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cꞌalal iyaꞌiic li cꞌusi iꞌalbatique, ta sacubel noꞌox osil iꞌochic ta yamaqꞌuil li mucꞌta chꞌulnae, te ichanubtasvanic. Li más banquilal palee schiꞌuc li jsaduceoetique la stsobic scotol li jꞌabteletic yuꞌunic li te ta mucꞌta chꞌulnae. La staquic batel jayvoꞌ yajmayoltac, ba sloqꞌuesic talel ta chuquel li yajtacbalaltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cꞌalal icꞌotic ta chucvanab li mayoletique, mu xa bu te istaic li jchuqueletique, isutic batel. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Xi cꞌot yalic: ―Lec macal ijtacutic li tiꞌ chucvanabe. Te vaꞌalic ta tiꞌ chucvanab li soltaroetique. Cꞌalal la jamcutique, muc buchꞌu te ijtacutic ―xiic cꞌotel li mayoletique. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cꞌalal jech iyaꞌiic li banquilal paleetique schiꞌuc li banquilal mayole, icꞌopoj yoꞌonic ti jech icꞌot ta pasele. Iyal yoꞌonic ti mu stacꞌ pajesel li Pedro schiꞌuc li schiꞌiltaque. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oy jun buchꞌu ba albatuc li banquilal palee: ―Li viniquetic ti la atiqꞌuic ta chuquele te xa oyic ta yamaqꞌuil li mucꞌta chꞌulnae. Te xa ta xchanubtasvanic ―xi cꞌotel. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cꞌalal iyaꞌi li banquilal mayole schiꞌuc li svinictaque, ibatic ta ora. Ba yiqꞌuic talel li yajtacbalaltac li Jesuse, pero muc bu laj yilbajinic yuꞌun ixiꞌic mi ta xꞌacꞌbatic ton yuꞌun li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cꞌalal icꞌot yuꞌunic ta stojol li jꞌabteletique, li más banquilal palee xi laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tsots laj calboxuc mantal ti mu xa me xachanubtasvanic ta sventa li Jesuse. Pero qꞌuelavilic, vinajem xa avuꞌunic ta spꞌejel li Jerusalene. Joꞌoncutic ta jcuchcutic avuꞌunic nojtoc smilel li vinic ti chavalique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Itacꞌav li Pedro schiꞌuc li schiꞌiltaque: ―Persa ta jchꞌunbecutic smantal Dios, maꞌuc ta jchꞌunbecutic smantal crixchano. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Li Dios yuꞌun li jtotic jmeꞌtic ta voꞌonee jaꞌ la schaꞌcuxes loqꞌuel ta smuquenal li Jesuse. Jaꞌ li la avaqꞌuic ta milel ta cruze. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Li Diose laj yacꞌ xa ta ichꞌel ta mucꞌ li Jesuse, la xa schotan ta sbatsꞌicꞌob. Jaꞌ mucꞌta Ajvalil xa cuꞌuntic ta comón. Jaꞌ Jcoltavanej cuꞌuntic. Jaꞌ chiscoltautic yoꞌ jech xuꞌ ta xquictatic li cꞌustic chopol ta jpastic, joꞌotic li jꞌisraelutique, jech chispasbutic perton yuꞌun li jmultique. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Joꞌoncutic ta xcalcutic ti melel acꞌbil yabtel yuꞌun Dios li Jesuse. Jaꞌ jech ta xal eꞌuc li Chꞌul Espíritu ti acꞌbilic xa ta yoꞌonic yuꞌun Dios scotol li buchꞌutic ta spasic xa li cꞌusi ta scꞌan li Cajvaltique ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cꞌalal iyaꞌiic ti jech itacꞌbatique, iꞌilinic tajmec, chac ox smilic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Te la svaꞌan sba ta ora jun vinic ochem ta fariseoal, jaꞌ jꞌabtel eꞌuc, Gamaliel sbi. Jaꞌ jun li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Lec ichꞌbil ta mucꞌ yuꞌun scotol schiꞌiltac ta israelal. Jaꞌ laj yal mantal ti acꞌo loqꞌuesatuc jliqueluc li yajtacbalaltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Xi lic yalbe scotol li jꞌabteletic li te schiꞌuque: ―Jchiꞌiltac, joꞌotic li jꞌisraelutique, scꞌan me jnoptic lec baꞌi li cꞌusi ta jpasbetic li viniquetique. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Naꞌic me li cꞌu sba scꞌoplal li Téudas ta voꞌonee. La snop ti xuꞌ ta spojbe yabtel li ajvalile. Oy chanib ciento svinictac. Pero imile li Téudase. Jech la svoqꞌuilan sbaic batel scotol li svinictaque, te ilaj o cꞌop yuꞌunic. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tsꞌacal to ilic jun vinic, Judas sbi. Liquem talel ta Galilea balumil. Jaꞌ o yora yaloj mantal li ajvalil ti acꞌo stsacan sbiic scotol li crixchanoetique. Ep buchꞌu la schꞌunan li cꞌusi laj yal li Judase. Pero imile nojtoc li Judase. Jech la svoqꞌuilan sbaic batel scotolic li buchꞌutic la schꞌunanic li cꞌusi laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaꞌ yuꞌun chacalbeic, mu me cꞌusi xapasbeic li viniquetic liꞌi. Acꞌo spasic li cꞌusi ta scꞌanique. Mi jaꞌ noꞌox ta sventa crixchano li scꞌopique schiꞌuc li cꞌustic ta spasique, xlaj noꞌox. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yan mi jaꞌ ta sventa Dios li scꞌopique, mu xlaj maꞌ leꞌe. Jaꞌ yuꞌun qꞌuelo me abaic naca me jaꞌ ta jcontraintic li Diose ―xi li Gamaliele. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","La schꞌunic scotolic li cꞌusi laj yal li Gamaliele. Jech cꞌalal laj yiqꞌuic ochel li yajtacbalaltac Jesuse, jaꞌ noꞌox la stsitsic ta nucul schiꞌuc tsots laj yalbeic mantal ti mu xa me xalic batel li cꞌop ta sventa li Jesuse. La scoltaic batel. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Cꞌalal iloqꞌuic batel ta stojol li jꞌabteletic li yajtacbalaltac li Jesuse, xmuybajic noꞌox ti jech la scꞌan stuc Dios ti chichꞌic vocol ta sventa li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Muc bu xictaic ta yalel li scꞌop li Jesucristoe. Scotol cꞌacꞌal ichanubtasvanic li te ta yamaqꞌuil li mucꞌta chꞌulnae schiꞌuc li ta naetique. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Cꞌalal epic xaꞌox li buchꞌutic yichꞌojic ta mucꞌ li Cajvaltique, te oyic jꞌisraeletic ti schanojic griego cꞌope, schiꞌuc te oyic eꞌuc jꞌisraeletic ti hebreo li scꞌopique, jaꞌ li scꞌopic onoꞌox li jꞌisraeletique. Li buchꞌutic ti griego li scꞌopique chopol icꞌopojic ta stojolic li buchꞌutic ti hebreo li scꞌopique. Laj yalic ti muc bu xichꞌic cꞌuxubinel li meꞌanal antsetic yuꞌunic li cꞌalal iꞌacꞌbat sveꞌelic ta jujun cꞌacꞌale. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Li lajchavoꞌ yajtacbalaltac li Jesuse la stsobic talel scotol li buchꞌutic yichꞌojic ta mucꞌ li Cajvaltique. Xi laj yalbeic: ―Li joꞌoncutique mu lecuc mi ta xquictacutic ta yalel li scꞌop Diose ta sventa ti ta jventaincutic li veꞌlile. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaꞌ lec, quermanotac, tꞌujic jucvoꞌuc viniquetic li bu lec scꞌoplal avaꞌiojique, ti pꞌijique, jaꞌ li buchꞌutic ventainbil yoꞌonic yuꞌun li Chꞌul Espíritue, jaꞌ ta xichꞌ yabtelic. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Li joꞌoncutique jaꞌ cabtelcutic ta jcꞌoponcutic Dios schiꞌuc ta jpuccutic li scꞌop Diose ―xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lec iyaꞌiic scotolic li cꞌusi iꞌalbatique. La stꞌujic Esteban, jaꞌ jun vinic ti lec yichꞌoj ta mucꞌ li Cajvaltique. Ventainbil yoꞌon yuꞌun li Chꞌul Espíritue. La stꞌujic otro vacvoꞌ. Jaꞌ Felipe, schiꞌuc Prócoro, schiꞌuc Nicanor, schiꞌuc Timón, schiꞌuc Parmenas, schiꞌuc Nicolás. Li Nicolase liquem talel ta jteclum Antioquía. Maꞌuc jꞌisraelal vinic, pero coꞌol toꞌox schꞌunoj jech chac cꞌu chaꞌal li jꞌisraeletique. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Cꞌalal la stꞌujique, laj yiqꞌuic talel ta stojol li yajtacbalaltac li Jesuse. Li yajtacbalaltac li Jesuse la scꞌoponbeic Dios ta stojolic ti acꞌo coltaatuc yuꞌun li Diose. Laj yacꞌanbe scꞌob ta sjolic li jucvoꞌique, jaꞌ senyail ti laj yichꞌ yabtelique. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ipuc batel li scꞌop li Cajvaltique. Jech más iꞌepajic li buchꞌutic yichꞌojic ta mucꞌ li Cajvaltic li te ta Jerusalene. Oy ep paleetic la schꞌunic eꞌuc. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Li Estebane iꞌacꞌbat ep slequil yoꞌon schiꞌuc stsatsal jech ep iyacꞌbe ta ilel stsatsal sjuꞌel Dios ta stojol li crixchanoetique. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Te oyic jayvoꞌ jꞌisraeletic li liquemic talel ta chꞌulna li bu Coltabilic xa ta Jtunel sbie. Jaꞌ te liquemic talel ta jteclum Cirene, schiꞌuc ta jteclum Alejandría, schiꞌuc ta Cilicia balumil, schiꞌuc ta Asia balumil. Te lic sbicꞌtalcꞌoponic li Estebane. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero li jsaꞌcꞌopetique muc bu spasic ta canal yuꞌun icꞌopoj ta sventa li Chꞌul Espíritu li Estebane. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","La saꞌic li buchꞌutic ta saꞌic mulil ta sjutic cꞌop ta stojol li Estebane, la stojic. Lec ichanubtasatic li cꞌu sba ta xalique: ―Jech me xcꞌot avalic: “Caꞌiojcutic ti chopol ta xcꞌopoj ta stojol li Moisese schiꞌuc ta stojol li Diose”, chianic me ―xꞌutatic. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ti jech iyalique, xvulajetic noj liquel scotol li jꞌisraeletique, schiꞌuc jayvoꞌ jꞌabteletic yuꞌunic, schiꞌuc jayvoꞌ li buchꞌutic spꞌisoj sbaic ta jchanubtasvanej ta smantaltac li Diose. Te chꞌayal yoꞌon istaic cꞌalal istsaquic li Estebane. Laj yiqꞌuic batel ta stojol li jꞌabteletique. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Laj yiqꞌuic talel li jtojeletique ti jaꞌ la sjutbeic smul li Estebane. Xi laj yalic: ―Li vinic liꞌi chopol chcꞌopoj ta sventa li mucꞌta chꞌulnae schiꞌuc ta sventa li chꞌul mantale. Mu xicta ta yalel. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yuꞌun caꞌiojcutic ti xi chale: “Li Jesús li te liquem talel ta Nazarete ta sjines li mucꞌta chꞌulna liꞌi, schiꞌuc ta sjel li cꞌu sba jtaleltic ti laj yal li Moisés ta voꞌonee”, xi chal ―xi la sjutbeic smul li Estebane. ");
INSERT INTO tzoSA_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Scotol li jꞌabteletic li te chotolique la sqꞌuelbeic sat li Estebane. Coꞌol schiꞌuc sat yajꞌangeltac Dios iyilic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Li más banquilal palee jech ijacꞌbat li Estebane: ―¿Mi melel li cꞌusi laj yalic li viniquetic liꞌi? ―xut. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Itacꞌav li Estebane: ―Jbanquil quitsꞌinab, aꞌiic me li cꞌusi chacalbeique. Li Diose, jaꞌ li oy sjuꞌel oy xojobale, laj yacꞌ sba ta ilel ta stojol li jtotic jmeꞌtic Abraham ta voꞌone li cꞌalal te toꞌox nacal ta Mesopotamia balumile, ti cꞌalal muc toꞌox bu batem ta naclej ta jteclum Harane. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Xi iꞌalbat yuꞌun Dios li Abrahame: “Locꞌan batel ta avosilal, ictao atot ameꞌ schiꞌuc scotol avutsꞌ avalal. Batan ta yan o balumil li bu chcacꞌ avile”, xꞌutat yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jech ilocꞌ batel ta yosilalic li jcaldeal crixchanoetic li Abrahame. Te cꞌot nacluc ta Harán. Cꞌalal icham stot li Abrahame, iꞌalbat yuꞌun Dios ti ta persa ta xlocꞌ talele. Jaꞌ liꞌ itaque talel ta cosilaltic, jaꞌ li yoꞌ bu oyutic li avie. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Li Diose muc bu xacꞌbe yichꞌ li osil liꞌi. Mu jsetꞌuc iꞌacꞌbat yichꞌ li Abrahame. Li bu inaquie yuꞌun noꞌox la schꞌamun. Jaꞌ noꞌox ti baꞌi iꞌalbat yuꞌun Dios ti jaꞌ ta xichꞌ comel li snitilultaque. Pero muꞌyuc toꞌox snichꞌon ti cꞌalal jech iꞌalbate. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iꞌalbat nojtoc yuꞌun Dios ti chba naclicuc ta yan o balumil li snitilultaque. Te chba ochicuc ta jtunel chanib ciento jabil, te chichꞌic ilbajinel. Te tspasic tsots abtel pero muc bu tojbilic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Li Abrahame xi iꞌalbat nojtoc yuꞌun li Diose: “Joꞌon ta xcacꞌbe yichꞌ vocol li buchꞌutic chastiqꞌuic ta yajtunele. Tsꞌacal to ta xloqꞌuic talel scotol la anitilultaque. Liꞌ chjul tunicuc cuꞌune”, xꞌutat yuꞌun Dios li Abrahame. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Li Diose laj yalbe Abraham ti persa ta xichꞌic li circuncisione. Jech cꞌalal ivocꞌ li snichꞌon li Abrahame, jaꞌ li Isaaque, ta svaxaquibal toꞌox cꞌacꞌal svoqꞌuel laj yacꞌbe yichꞌ circuncisión. Jaꞌ jech la spasulanic o. Cꞌalal ivocꞌ snichꞌon li Isaaque, jaꞌ li Jacove, laj yacꞌbe yichꞌ circuncisión eꞌuc. Cꞌalal ivocꞌ snichꞌnab li Jacove, jaꞌ noꞌox jech la spasbe eꞌuc li snichꞌnabe, jaꞌ li lajchavoꞌ jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Li snichꞌnab Jacove, jaꞌ li jtotic jmeꞌtic ta voꞌonee, xtiꞌet o yoꞌonic li yitsꞌinique, jaꞌ li Josee. La schonic batel ta Egipto balumil. Pero li Josee qꞌuelbil chabibil yuꞌun li Diose. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Cꞌalal iꞌilbajinat li Josee, icoltaat yuꞌun Dios. Iꞌacꞌbat spꞌijil jech lec iꞌile yuꞌun li faraone, jaꞌ li mucꞌta ajvalil li ta Egiptoe. Te iꞌoch ta gobernador li Josee, jaꞌ itsꞌinal ajvalil icꞌot. Iꞌacꞌbat yichꞌ ta venta scotol li jꞌegiptoal crixchanoetique. Iꞌacꞌbat sventain nojtoc sna li faraone. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ta tsꞌacale ital tsots viꞌnal ta spꞌejel li Egipto balumile schiꞌuc li ta Canaán balumile. Yan sba iyichꞌic vocol li crixchanoetique. Li jtotic jmeꞌtic ta voꞌonee mu xa sta sveꞌelic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iyaꞌi Jacov ti oy trigo te ta Egiptoe, te la stac batel li jtotic jmeꞌtic ta voꞌonee. Jaꞌ sba toꞌox la stac batel. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Cꞌalal ibatic ta schibal veltae, li Josee laj yacꞌ sba ta ojtaquinel ta stojol li sbanquiltac schiꞌuc li yitsꞌine. Jech li faraone iyojtaquinanbe sbanquiltac schiꞌuc yitsꞌin li Josee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Li Josee la stac ta iqꞌuel li stote, jaꞌ li Jacove, schiꞌuc scotol li schiꞌiltac ta voqꞌuele. Jaꞌ joꞌlajuneb schanvinic (75) icꞌot ta scotolic cꞌalal ta snichꞌnabic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Te inaqui ta Egipto li Jacove, te icham. Te ichamic eꞌuc li jtotic jmeꞌtic ta voꞌonee, jaꞌ li snichꞌnab Jacove. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","La scuchbeic talel li sbecꞌtal stacupalique. Mu junuc buchꞌu te mucul icom li ta Egiptoe. Liꞌ la smuquic ta nail chꞌen ta jteclum Siquem li bu smanoj onoꞌox li Abrahame. Jaꞌ ti la smanbe li snichꞌnab Hamor li te ta Siqueme. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Cꞌalal poꞌot xaꞌox chcꞌot scꞌacꞌalil ta xichꞌic li osil ti albil onoꞌox yuꞌun Dios li Abrahame, ep xaꞌox pꞌolemic te ta Egipto li jtotic jmeꞌtic ta voꞌonee. Epic xa tajmec. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iꞌoch achꞌ faraón te ta Egipto pero muc xa bu xꞌojtaquine li Josee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Li achꞌ faraone iloꞌlovan. Laj yilbajinan li jtotic jmeꞌtic ta voꞌonee. Laj yal mantal ti acꞌo sloqꞌues ta snaic scotol li bicꞌtal queremutique yoꞌ jech acꞌo chamicuc. Ti jech laj yal li faraone, yuꞌun jaꞌ mu scꞌan ti ta xpꞌolic li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Cꞌalal jech yaloj mantal li faraone, jaꞌ o ivocꞌ li Moisese. Toj lec iꞌile yuꞌun Dios li Moisese. Oxib noꞌox u te oy ta sna stot smeꞌ. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Cꞌalal iloqꞌuesat ta sna stot smeꞌ yoꞌ acꞌo chamuque, te itae yuꞌun stseub li faraone. La stsꞌites, la spꞌis ta yol. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lec laj yichꞌ chanubtasel li Moisese, jaꞌ laj yichꞌbe spꞌijilic li jꞌegiptoal crixchanoetique. Toj lec snaꞌ xcꞌopoj, toj lec ital schꞌulel. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Cꞌalal yichꞌoj xaꞌox chaꞌvinic jabil li Moisese, chac scꞌopon li schiꞌiltaque, jaꞌ li jtotic jmeꞌtic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Te iyil ta xmajbat jun schiꞌil yuꞌun jun jꞌegiptoal vinic. Li Moisese ba smil li jꞌegiptoal vinique, jaꞌ la spoj li schiꞌile. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","La snop Moisés ti snaꞌojic li schiꞌiltac ti jaꞌ tꞌujbil yuꞌun Dios ti jaꞌ chcoltaatique, pero mu snaꞌic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta yocꞌomal nojtoc iyil Moisés ti ta xut sbaic chaꞌvoꞌ schiꞌiltac. Li Moisese ba spajes. Xi laj yalbe: “¿Cꞌu chaꞌal chavut abaic yuꞌun achiꞌil noꞌox abaic?” xut. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Li Moisese inetꞌe loqꞌuel yuꞌun li buchꞌu la sliques cꞌope. Xi iꞌalbat: “¿Buchꞌu laj yacꞌbot avabtel ti tal aticꞌ abae? Mu joꞌcot ajvalilot cuꞌuncutic. Mu joꞌcot jmeltsanejcꞌopot cuꞌuncutic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Mi chacꞌan chamilun eꞌuc jech chac cꞌu chaꞌal la amil li jꞌegiptoal vinic voljee?” xꞌutat. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cꞌalal iyaꞌi Moisés ti vinajem xa ti milvaneme, ijatav batel. Te cꞌot nacluc ta Madián balumil. Te la saꞌ yajnil, te iyil chaꞌvoꞌ schꞌamal. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Cꞌalal oy xaꞌox ta chaꞌvinic jabil scꞌotel ta Madián balumil li Moisese, te iyil ti chtil jtecꞌ biqꞌuit chꞌix ta vits Sinaí te ta taqui jamaltic. Li ta yat cꞌoqꞌue te ivinaj Dios jech chac cꞌu chaꞌal jun yajꞌangel. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Cꞌalal iyil Moisés ti mu xcꞌacꞌ li biqꞌuit chꞌixe, toj chꞌayel noꞌox yoꞌon. Inopoj batel, ba sqꞌuel. Te iyaꞌi icꞌopoj li Diose, xi laj yal: ");
INSERT INTO tzoSA_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Joꞌon Diosun yuꞌun la atot ameꞌic ta voꞌonee, jaꞌ li Abrahame, schiꞌuc li Isaaque, schiꞌuc li Jacove”, xi. Li Moisese inic ta xiꞌel jech muc bu xnopoj ba más. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pero xi iꞌalbat nojtoc yuꞌun li Diose: “Locꞌ axonob yuꞌun liꞌ xa vaꞌalot ta jtojol, joꞌon li Diosune. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Quiloj ti ep ta xichꞌic vocol la achiꞌiltac li te ta Egiptoe, joꞌoxuc li coꞌol tꞌujbiloxuc cuꞌune. Icaꞌi ti ep xꞌavetique. Jaꞌ yuꞌun liyal talel yuꞌun tal jcoltaic loqꞌuel li ta svocolique. Batic ta Egipto”, xꞌutat yuꞌun Dios li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Jaꞌ li Moisés ti muc bu ichꞌbil ta mucꞌ yuꞌun li schiꞌiltac ta israelale, ti xi laj yalbeique: “¿Buchꞌu laj yacꞌbot avabtel ti tal aticꞌ abae? Mu joꞌcot ajvalilot cuꞌuncutic, mu joꞌcot jmeltsanejcꞌopot cuꞌuncutic”, ti xutic toꞌoxe. Pero li Diose la stac batel yuꞌun jaꞌ ta xcꞌot ta banquilal yuꞌunic schiꞌuc ta jcoltavanej yuꞌunic. Jaꞌ o itaque batel yuꞌun Dios ti cꞌalal te ivinaj ta jtecꞌ biqꞌuit chꞌixe. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jaꞌ li Moisés ti la sloqꞌuesan talel ta Egipto li jtotic jmeꞌtic ta voꞌonee, ti ep laj yacꞌbe ta ilel stsatsal sjuꞌel Dios li te ta Egipto balumile. Tsꞌacal to laj yacꞌbe ta ilel nojtoc stsatsal sjuꞌel Dios li te ta Tsajal Nabe. Schiꞌuc nojtoc chaꞌvinic jabil laj yacꞌbe ta ilel stsatsal sjuꞌel Dios li te ta taqui jamaltique. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jaꞌ li Moisés ti jech laj yalbe li jtotic jmeꞌtic ta voꞌonee: “Li Diose ta xlic yuꞌun jun li buchꞌu ta xal li scꞌop Dios li ta jchiꞌiltique jech chac cꞌu chaꞌal listꞌuj ti chacalbeic li scꞌope. Ichꞌbeic me ta mucꞌ li cꞌusi chayalboxuque”, xi onoꞌox li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaꞌ li Moisés li te ta taqui jamaltic schiꞌuc li jtotic jmeꞌtic ta voꞌonee. Li jtotic jmeꞌtique te la stsob sbaic ta yoc vits Sinaí. Li Moisese te icꞌoponat yuꞌun li Diose. Cꞌalal iyaꞌi li cꞌusi iꞌalbat yuꞌun li Diose, laj yalbe scotol li jtotic jmeꞌtique. Jaꞌ laj yalbe ti cꞌu sba tscꞌan Dios ti cꞌustic tspasique yoꞌ jech ta xcuxiic o sbatel osil. Jaꞌ ta sventa Moisés ti icaꞌitic eꞌuc li joꞌotique. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Li jtotic jmeꞌtic ta voꞌonee muc bu xacꞌ ta yoꞌonic li cꞌusi iyal li Moisese, muc bu schꞌunic. Chac suticuc ba nojtoc ta Egipto balumil. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Xi laj yalbeic li Aarone: “Pasbuncutic cajrioxcutic yoꞌ jaꞌ sbabe ta xbat cuꞌuncutic. Yuꞌun mu jnaꞌcutic cꞌusi ispas li Moisés ti yoquel to mu sut talele, jaꞌ li buchꞌu la sloqꞌuesuncutic talel ta Egiptoe”, xiic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jech la spasbeic slocꞌol jcot chexel tot vacax. La smilbeic smoton. Xmuybajic noꞌox ta sventa li cꞌusi meltsanbil noꞌox ta scꞌobique. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iteneic comel yuꞌun li Diose. Jaꞌ iꞌacꞌbat yichꞌic ta mucꞌ li cꞌustic xojobian ta vinajele, jech chac cꞌu chaꞌal tsꞌibabil onoꞌox yuꞌun li buchꞌutic iyalic li scꞌop Dios ta voꞌone ti jech onoꞌox yaloj li Diose: Jꞌisraeletic, cꞌalal laxanavic talel chaꞌvinic jabil ta taqui jamaltique, altic la avacꞌbecun ta sventa jmoton li vacaxe schiꞌuc li chije yuꞌun te noꞌox yalel muyel la avoꞌonique. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yuꞌun la acuchic talel avajrioxic, Moloc sbi, ti tiqꞌuil talel ta scaxaile. Schiꞌuc la avichꞌic talel li slocꞌol cꞌanal ti jaꞌ avajrioxique, jaꞌ li Renfán sbie. Jaꞌ apasojic yuꞌun jaꞌ chavichꞌic ta mucꞌ. Ta scoj ti jech chapasique jech chajtaquic loqꞌuel li ta avosilalique. Te chabatic ta jelavel Babilonia balumil, xi onoꞌox tsꞌibabil. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Cꞌalal te oyic ta taqui jamaltic li jtotic jmeꞌtic ta voꞌonee, jaꞌ itun yuꞌunic li chꞌulna ti meltsanbil jech chac cꞌu chaꞌal carpae yuꞌun jaꞌ te icꞌoponatic yuꞌun li Diose. Li chꞌulnae jaꞌ jech la spasic jech chac cꞌu chaꞌal iꞌacꞌbat yil yuꞌun Dios li Moisese. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Cꞌalal iꞌiqꞌueic talel yuꞌun Josué liꞌ ta cosilaltique, la scuchic talel li chꞌulna ti jech sba meltsanbil jech chac cꞌu chaꞌal carpae. Jaꞌ o laj yichꞌic yosilic li cꞌalal iꞌacꞌbat smilic yuꞌun Dios li yajvaltac toꞌox li osile. Cꞌalal iꞌoch ta ajvalilal li Davide, yoquel to jaꞌ chtun yuꞌunic li chꞌulna ti jech chac cꞌu chaꞌal carpae. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Li Davide lec iꞌile yuꞌun Dios. La scꞌanbe Dios ti acꞌo acꞌbatuc svaꞌanbe schꞌulnae, jaꞌ li Dios yuꞌun li jtotic jmeꞌtic Jacov ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero maꞌuc la svaꞌan li Davide; jaꞌ la svaꞌan li snichꞌone, jaꞌ li Salomone. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Li Diose mu xnaqui ta svaꞌanbil na crixchano yuꞌun te oy ta vinajel. Jech laj yal cꞌalal la schꞌamunbe ye jun li buchꞌu iyal scꞌop Dios ta voꞌonee: ");
INSERT INTO tzoSA_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Joꞌon ta jpas mantal liꞌ ta vinajel schiꞌuc ta balumil. ¿Cꞌu chaꞌal jech chavalic ti chavaꞌanbecun jnae, yuꞌun mu jnaꞌ jcux coꞌon? ");
INSERT INTO tzoSA_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Joꞌon la jpas scotol li cꞌustic oye, xi li Diose, xi li buchꞌu iyal scꞌop Dios ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Li joꞌoxuque toj tsots avoꞌonic. Coꞌol avoꞌonic achiꞌuquic li buchꞌutic mu xojtaquinic li Diose. Mu xacꞌan xavaꞌiic li scꞌop Diose. Scotol cꞌacꞌal chapꞌajic li Chꞌul Espíritue. Jaꞌ jech chapasic eꞌuc jech chac cꞌu chaꞌal la spasic la atot ameꞌic ta voꞌonee. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","53","La atot ameꞌic ta voꞌonee la scontrainic scotol li buchꞌutic iyalic scꞌop Dios ta voꞌonee. La smilic li buchꞌutic iyalic ti chtal li buchꞌu tucꞌ yoꞌone. Pero cꞌalal ital li buchꞌu ti tucꞌ yoꞌone, la avaqꞌuic ta cꞌabal, la avaqꞌuic ta milel, joꞌoxuc ti avaꞌiojic li mantaletic li laj yalic li yajꞌangeltac Dios ta voꞌonee, pero mu xachꞌunic ―xut li jꞌabteletic li Estebane. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cꞌalal jech laj yal li Estebane, isoc tajmec sjolic. Xcꞌuxuxet yeic ta scꞌacꞌal yoꞌonic. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Li Estebane ventainbil yoꞌon yuꞌun li Chꞌul Espíritue la sqꞌuel muyel ta vinajel. Iyilbe xojobal sjuꞌel Dios. Iyil nojtoc ti te vaꞌal ta sbatsꞌicꞌob Dios li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Li Estebane xi iyal: ―Jamal chquil li vinajele. Te oy ta sbatsꞌicꞌob Dios chquil li Jesuse, jaꞌ li coꞌol crixchanoutic jchiꞌuctique ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Li jꞌabteletique chopol iyaꞌiic ti jech laj yal li Estebane. Tsots lic cꞌopojicuc. La smac schiquinic yuꞌun mu scꞌan xaꞌiic li cꞌusi laj yal li Estebane, yuꞌun la snopic ti chopol ta xil Dios li cꞌusi laj yal li Estebane. Ba stsaquic ta ora scotolic li Estebane. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Laj yiqꞌuic loqꞌuel ta tiꞌ jteclum, te laj yacꞌbeic ton. Li buchꞌutic ta xaqꞌuic tone la sloqꞌuic spuychijic. Laj yacꞌbeic schabi jun querem, Saulo sbi. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Cꞌalal yacal ch‐acꞌbat tone, la sta ta naꞌel Dios li Estebane, xi laj yal: ―Cajval Jesús, icꞌbun ba li jchꞌulele ―xi. ");
INSERT INTO tzoSA_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","La squejan sba, tsots icꞌopoj, xi laj yalbe li Diose: ―Cajval, pasbo perton li jchiꞌiltac liꞌi yuꞌun mu snaꞌic li a sba lispasbeique ―xi. Cꞌalal jech laj yale, jaꞌ o ilocꞌ schꞌulel. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Cꞌalal iyil Saulo ti icham xa li Estebane, xmuybaj xa o. Ta ora noꞌox lic ilbajinaticuc li buchꞌutic yichꞌojic ta mucꞌ li Cajvaltic li te ta Jerusalene. La spuc sbaic batel scotolic ta Judea balumil schiꞌuc ta Samaria balumil. Jaꞌ xa noꞌox te icomic ta Jerusalén li lajchavoꞌ yajtacbalaltac li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oy jayvoꞌ viniquetic ti lec yichꞌojic ta mucꞌ li Diose, jaꞌ ba smuquic li Estebane. Yan sba iyoqꞌuitaic. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yan li Sauloe tscꞌan ta schꞌaybe scꞌoplal li scꞌop Jesús ti schꞌunojique. Iꞌoch ta naetic, la stsacan loqꞌuel viniquetic schiꞌuc antsetic, la sticꞌan ta chuquel. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Li buchꞌutic la spuc sbaic batele, buyuc noꞌox iyalic batel ti jaꞌ noꞌox chijcolutic o ta sventa li Cajvaltique. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Li Felipee te icꞌot ta jun jteclum te ta Samaria balumil. Cꞌot yalbe crixchanoetic ti iꞌay xa li buchꞌu tꞌujbil yuꞌun Dios sventa chiscoltautique, jaꞌ li Jesuse. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Li crixchanoetic li te ta jteclume la stsob sbaic scotolic yuꞌun tal yaꞌiic li cꞌustic ta xal li Felipee. Cꞌalal iyilic ti ep laj yacꞌbe ta ilel stsatsal sjuꞌel Dios li Felipee, la stsꞌean lec schiquinic li cꞌustic laj yale. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yuꞌun ep icolic li buchꞌutic ochem pucuj ta yoꞌonique. Cꞌalal ilocꞌ li pucujetique, tsots iꞌavanic. Icolic nojtoc li buchꞌutic ti mu xnic jun yoc scꞌobique schiꞌuc li coxoetique. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jech xmuybajic noꞌox scotolic li crixchanoetic li te ta jteclume. ");
INSERT INTO tzoSA_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Te oy jun vinic, Simón sbi. Jaꞌ jꞌilvanej toꞌox. Ep la sloꞌloan crixchanoetic li te ta Samaria balumile yuꞌun laj yal ti oy sjuꞌe